﻿USE sofia;
DROP TABLE IF EXISTS sofia.qub_vpl;
CREATE TABLE qub_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES qub_vpl WRITE;
INSERT INTO qub_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Gallarinancho manaraj imapis captin Tayta Dios camaran syëlutawan cay pachata. ");
INSERT INTO qub_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Cay pachaga manami canan caycashannöchu caran. Manami imapis caranchu. Chacay yanauyaycaj yacu juntashalla caran. Chay yacu janallanchömi Tayta Diospa Espiritonga tumaycaran. ");
INSERT INTO qub_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Chaura Tayta Diosga «¡Achicyaj cachun!» niran. Niptin achicyaj ricacuran. ");
INSERT INTO qub_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Dios ricaran achicyaj alli cashanta. Nircur chacaypita achicyajta raquiran. ");
INSERT INTO qub_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Achicyaj cajta «junaj» niran. Chacay cajtana «pagas» niran. Chaytami camaran rimir junajcho. ");
INSERT INTO qub_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Chaypita Tayta Dios niran: «Asulyaraycaj cachun yacucuna ishcayman raquicänanpaj.» ");
INSERT INTO qub_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Diosga chay nishannölla asulyaraycämojta camaran yacu ishcay pachaman raquicänanpaj. Waquin caj yacu quëdaran uracho, waquin cajnami janajcho. ");
INSERT INTO qub_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Asulyaraycämojta Tayta Dios jutichaparan «syëlu» nir. Chaytami camaran ishcay caj junajcho. ");
INSERT INTO qub_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Chaypitana Tayta Dios niran: «Ura caj yacu juc pachallaman shuntacächun allpa ricacänanpaj.» Chaura nishannölla caran. ");
INSERT INTO qub_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Chaqui cajtami «allpa» niran. Shuntacasha caj yacutanami «lamar» niran. Chayno camarcur Dios ricaran llapanpis alli cashanta. ");
INSERT INTO qub_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Chaypita yapay niran: «Allpapita wiñamuchun llapan casta jachacuna, muruyoj guewacuna, tucuy-niraj wayoj yöracunapis». Chaura nishannölla caran. ");
INSERT INTO qub_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Chaymi allpapita wiñamuran tucuy-niraj muruyoj jachacuna chayno tucuy-niraj wayoj yöracunapis. Chayta camarcur Dios ricaran llapanpis alli cashanta. ");
INSERT INTO qub_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Chaycunatami camaran quimsa caj junajcho. ");
INSERT INTO qub_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","15","Chaypita Dios niran: «Syëlucho cachun achicyajcuna allpaman achicyapämunanpaj. Chaynöpami junaj chacaypita raquicasha canga. Chay achicyajcunaga alli canga junajcunata, watacunata yupananpaj, imay wichan cashantapis musyananpämi.» Chaura nishannölla ruracaran. ");
INSERT INTO qub_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Nircur camaran intitawan quillata; inti junajpa achicyänanpaj, quillana chacaypa achicyänanpaj. Chaynömi goyllarcunatapis camaran. ");
INSERT INTO qub_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Chaycunata Tayta Dios syëluman churaran cay pachata achicyaptin ");
INSERT INTO qub_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","chacaypita junaj raquicänanpaj. Chaycunata camarcur Tayta Dios ricaran alli cashanta. ");
INSERT INTO qub_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Chaycunatami camaran chuscu caj junajcho. ");
INSERT INTO qub_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Chaypita Tayta Dios niran: «Tucuy casta yurichun yacucho tiyajcuna, chayno pacha jananpa pärejcunapis.» ");
INSERT INTO qub_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Chayno imapis mana cashanpitami camaran jatun animalcunata lamarcho tiyajta, yacucho tiyaj cajta llapan castata, äbicunatapis llapan castata. Chaycunata rurarcur Tayta Dios ricaran chayno alli caycashanta. ");
INSERT INTO qub_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Nircurna bindisyunta goshpan niran: «Lamarcho tiyajcunapis, pärejcunapis achcaman mirachun quiquin-pura mirachinacushpan.» ");
INSERT INTO qub_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Chaycunatami camaran pichga caj junajcho. ");
INSERT INTO qub_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Chaypita Dios niran: «Tucuy-niraj animalcuna yurichun manshu cananpaj y chucaru cananpäpis. Chayno cachun garachaypa purejcunapis.» Chaura nishannölla llapanpis caran. ");
INSERT INTO qub_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Dios ricaran llapan rurashan animalcuna alli cashanta. ");
INSERT INTO qub_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Chaypita Dios niran: «Canan runata rurashun quiquinchi-nirajta. Paypa munayninchömi canga pescäducuna, pärejcuna, manshu caj chucaru caj animalcunapis, chayno garachaypa purejcunapis.» ");
INSERT INTO qub_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Chay nishannöllami runata Tayta Dios ruraran. Quiquin-nirajtami camaran. Ollgutapis warmitapis camaran. ");
INSERT INTO qub_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Nircur bindisyunta goran cayno nir: «Gamcuna miray aypallaman cay pachaman juntanayquicama. Munayniquicho cachun pescäducunapis, pärej cajcunapis, cay pachacho llapan cajcunapis.» ");
INSERT INTO qub_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Nircur paycunata niran: «Gamcunatami llapan cay muruchaj caj lanta jachacunata goycö, chayno frütata wayoj yöracunatapis. Chaycunaga llapanmi canga micunayquicunapaj. ");
INSERT INTO qub_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Chaynömi guewacunata camashcä uywacuna micunanpaj, garachaypa purejcuna micunanpaj, pärej cajcunapis micunanpaj.» Chaura nishannöllami caran. ");
INSERT INTO qub_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Llapan rurashancuna amatar alli cashanta ricar Dios cushicuran. Chaycunatami camaran sojta caj junajcho. ");
INSERT INTO qub_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Chaynöpami Tayta Dios camayta usharan cay pachata, cay pachacho cajcunatapis, syëlutapis syëlucho cajcunatapis. ");
INSERT INTO qub_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Llapanta camarcurna ganchis caj junajchöga Dios jamaran. ");
INSERT INTO qub_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Nircur chay junajta bindisaran. Jamashanpitami Diosga chay junajta raquiran rispitasha junaj cananpaj. ");
INSERT INTO qub_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Caychömi isquirbiraycan syëlutawan cay pachata Tayta Dios camashanpaj. Syëluta cay pachata camanan wichanga ");
INSERT INTO qub_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","manarämi tamyachiranrächu. Chaymi manaraj wiñamuranrächu ima jachacuna ni guewacunapis. Chayno manarämi pipis caranrächu chacracho aroj. ");
INSERT INTO qub_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Chay wichan yacuga pacha rurinpita pashtaycämuran intëru allpata ushmananpaj. ");
INSERT INTO qub_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Chaypitana Tayta Diosga runata ruraran allpapita. Nircur senganpa pücaran cawayta gallaycunanpaj. Chaura runa cawaytana gallaycuran. ");
INSERT INTO qub_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Chaypitana Tayta Diosga Edencho wertata ruraran. Chayga caycaran inti yagamunan caj-lächo. Nircur rurashan runata chay wertaman churaran. ");
INSERT INTO qub_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Chay wertachömi Tayta Dios wiñachimuran tucuy-niraj cuyayllapaj yöracunata. Chaycunapa wayuynin alli caycaran runa micunanpaj. Werta chaupinchöna caran ishcay yöracuna. Juc yörapa wayuynin caran runa micuptin imaycamapis cawachinanpaj. Jucaj yörapa wayuyninta micuptinna caran alli cajta mana alli cajtapis runa musyananpaj. ");
INSERT INTO qub_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Quiquin Edén wertapitami juc mayu yuriycaran chay wertata pargunanpaj. Nircur chay mayuga wertapita llojshir chuscuman raquiycaran. ");
INSERT INTO qub_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Rimir caj mayupa jutin caran Pisón. Chay mayuga tumaycämuran Havila nishan partipa. Chaychöga achcami gori caran. ");
INSERT INTO qub_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Chaycho caj goriga mas alli caj gorimi. Chayno chaychömi caycan alli asyaj risïna, cuyayllapaj «ónice» jutiyoj rumicunapis. ");
INSERT INTO qub_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Jucaj mayupa jutinmi caycan Gihón. Chay mayu tumaycämun Cus partipa. ");
INSERT INTO qub_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Mas jucaj mayupa jutinmi caycan Tigris. Chay mayuga inti yagamunan caj-läpa aywar, Asiria nasyunpa päsan. Jucaj mayupana jutin caycan Éufrates. ");
INSERT INTO qub_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Tayta Diosga rurashan runata churaran Edén wertaman chaycho arunanpaj y ricananpaj. ");
INSERT INTO qub_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Chayman churar runata cayno willaparan: «Cay wertacho caycaj yöracunapa wayuynincunaga llapanpis micunayquipämi. ");
INSERT INTO qub_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","Ichanga ama micunquichu allita mana allita musyachicoj yörapa wayuynillanta. Chayta micushpayquega wañunquipämi». ");
INSERT INTO qub_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Nircur Tayta Dios niran: «Runa japallanga manami allichu canman. Payta yan'gänanpaj yanapänanpaj jucta rurashaj.» ");
INSERT INTO qub_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Chaypitana Tayta Diosga allpapita rurashan tucuy-niraj animalcunatawan tucuy-niraj päriypa purejcunatapis runa cajman apaparan pay jutincunata churapänanpaj. Runa jutinta churapashallanmi llapanpapis jutincuna caycan. ");
INSERT INTO qub_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Chaura runaga jutincunata churapasha manshu caj chucaru caj animalcunapatawan pärej cajcunapatapis. Ichanga mayganpis manami allichu caran paypa yan'guinpaj ni yanapänanpäpis. ");
INSERT INTO qub_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Chaymi Tayta Diosga runata wañuy puñuyman puñucäcachiran. Puñushanyaj juc custillanta jorguran. Nircur aychanta allchacächiran. ");
INSERT INTO qub_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Chay jorgushan custillanpitanami Tayta Diosga warmita ruraran. Nircurna runa cajman pusharan. ");
INSERT INTO qub_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Ricaycurmi runaga cayno niran: «Caymi ichanga tullö-niraj tulluyoj, aychä-niraj aychayoj. Payga ollgupita jorgusha cashpanmi warmi canga.» ");
INSERT INTO qub_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Chaypitami runaga mamanpa taytanpa maquinpita yargun warminwan mana raquicaypa tiyananpaj. Chayno tiyarmi ishcan ricacun jucnayllanöna. ");
INSERT INTO qub_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Runapis warmipis röpaynaj galallami caycaran. Chaypis manami pengacuyta musyaranchu. ");
INSERT INTO qub_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Tayta Dios camashan llapan animalcunapita culebraga caran mas sabïdu. Chaymi warmi caycashan cajman aywaycur tapuran: «¿Rasunpachi Dios nisha-cashunqui maygan yörapa wayuynintapis mana micunayquicunapaj?» ");
INSERT INTO qub_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Chayno niptin warmi niran: «Yöracunapa wayuynintaga micunäcunapämi nimasha. ");
INSERT INTO qub_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","Wertapa chaupincho caycaj yörapa wayuyninpämi ichanga nogacunata Tayta Dios nimasha mana micunäcunapaj, ni yatayllapis mana yatanäcunapaj. Chay yörapa wayuyninta micorga wañushäcunashi.» ");
INSERT INTO qub_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Chayno niptin culebraga warmita niran: «Nishushayquega manami rasunpachu. Manami wañunquipächu. ");
INSERT INTO qub_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Diosga musyanmi chay yörapa wayuyninta micushpayqui Diosnöna alli cajtapis mana alli cajtapis musyanayquipaj cashanta.» ");
INSERT INTO qub_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Chay yörapa wayuynin munapaypaj caycajta ricar warmi fiyupa munaparan. Yachaj tantiyaj cayta munashpan yörapa wayuyninta pallarcur micuran. Nircur runantapis macyaran paypis micunanpaj. Chaura runanpis micuran. ");
INSERT INTO qub_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Chay frütata micurcärerga jinan öra tantiyacuran galalla carcaycashanta. Chaura ïgus yörapa öjanta jirarcurna pengayninta chapacuran. ");
INSERT INTO qub_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Chay tardi inti päsariptin, llantullata wertacho Tayta Dios puriycaran. Chayta mayar runaga warminwan pacacaycäriran yöracunapa wajtanman. ");
INSERT INTO qub_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Runata Tayta Dios gayacuran: «¿Maychötaj caycanqui?» nir. ");
INSERT INTO qub_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Chaura runa niran: «Wertacho puriycashayquita mayarmi manchacushpä pacacushcä galalla cashpä, tayta.» ");
INSERT INTO qub_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Chaura Dios tapuran: «¿Pitaj nisha-cashunqui galalla cashayquita? ¿‹Ama micunquichu› nishä yörapa wayuynintachu micushcanqui?» ");
INSERT INTO qub_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Niptin runa niran: «Majäpaj apapämashayqui warmi macyamaptinmi micushcä, tayta.» ");
INSERT INTO qub_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Chaura warmitana Tayta Diosga tapuran: «¿Imatataj rurashcanqui?» nir. Warmina niran: «Culebra engañamaptinmi micushcä.» ");
INSERT INTO qub_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Chayno niptin Tayta Diosga culebrata niran: «Chayno rurashayquipitami llapan animalcunachöpis maldisyunädu canquipaj. Cananpitaga garachayllapami purinquipäpis. Allpata micullarmi cawanquipäpis. ");
INSERT INTO qub_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Warmiwanpis chiquinacachishayquimi. Paypita mirajwan gampita mirajpis chiquinacongapänami. Warmipita yurejtami talunnincho cañinquipaj. Paymi ichanga umayquipita ñitirishunquipaj.» ");
INSERT INTO qub_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Nircur warmitana niran: «Gueshyaj ricacur amatarmi ñacanquipaj. Fiyupa nanaywanrämi gueshyacunquipäpis. Runayquiwanga iwal goyaytami amatar munanquipaj. Paypa munayninchöna canquipäpis.» ");
INSERT INTO qub_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Chaypita runatana niran: «Warmiqui nishushayquita wiyashayquipitami, yörapa wayuyninta mana micunayquipaj nishäta micushayquipitami cananga cay pacha maldisyunädu canga. Chaypitami cawashayquicamaga waran-waran fiyupa ñacar chacracho arunqui micuyniqui cananpaj. ");
INSERT INTO qub_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Allpapitapis wiñamonga cashayoj mana alli jachacunallami. Allpacho wiñamoj jachacunatami micunquipäpis. ");
INSERT INTO qub_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Micunayquipäpis cangapaj südashayquiyaj aruptiquirämi. Chayno aruycällarmi wañunquipaj allpaman ticranayquicama. Allpapitami rurasha cashcanquipis. Chaymi cashgan allpaman cutinquipaj.» ");
INSERT INTO qub_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Chaypitarämi runaga warminpa jutinta churaparan «Eva» nir. Chayno jutita churaparan pay gueshyacushallanpita llapan runacuna ollgupis warmipis mirananpaj captinmi. ");
INSERT INTO qub_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Tayta Diosga warmipaj ollgupäpis röpancunata ruraparan animalcunapa garachancunallapita. ");
INSERT INTO qub_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Nircur Tayta Dios niran: «Canan runaga noganchïnönami caycan. Musyannami alli cajta mana alli cajtapis. Cayllacho tiyaycarga micucurcunmanchi imaycamapis cawachicoj yörapa wayuyninta. Chayta micucurcorga imaycamapis cawangami. Chaymi cay wertachöga ama tiyachunnachu.» ");
INSERT INTO qub_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Chayno nirmi runataga Edén wertapita garguran. Nircur chacramanna arunanpaj churaran, allpapita rurasha cashanman. ");
INSERT INTO qub_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Runata chayno gargurir Tayta Diosga wertaman churaran querubín nishan anjilcunata. Paycunaga achicyaypa achicyar rataycaj sablinwan caycaran. Chay wertata täpaycaran inti yagamunan caj-lächo, imaycamapis cawachicoj yöraman mana pipis yaycunanpaj. ");
INSERT INTO qub_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Chaypita Adanga warmin Evawan puñuran. Chaura Evaga gueshyaj ricacuran. Gueshyacushpan Eva niran: «Tayta Dios munayninpa ollgu wamrata tarishcä. Chaynöpami cay wamräpa jutin canga Caín.» ");
INSERT INTO qub_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Chaypita yapay ollgu wamran caran. Chay caj wamranpa jutintanami churaparan «Abel» nir. Abelga jatunyar uyshayoj cabrayoj caran. Cainnami chacra aroj caran. ");
INSERT INTO qub_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Achca watataraj Cainga Tayta Diospaj aparan micuynin wayushanta. ");
INSERT INTO qub_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Chayno Abelpis Tayta Diospaj aparan manta uyshacunapa rimir caj wawancunata mas wirannin cajta. Chaymi Abel apashan cajtaga Tayta Dios alli chasquiran. ");
INSERT INTO qub_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","Caín apashanta ichanga mana chasquiranchu Abelpatanöga. Chaura Cainga fiyupa rabyar jucajyasha puriran. ");
INSERT INTO qub_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Chaymi Cainta Tayta Dios niran: «¿Imanirtaj gam rabyasha uysuraycanqui? ");
INSERT INTO qub_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Allita ruraptiquega gamtapis allimi chasquishayqui. Mana allita ruraptiquega jucha ruray yargaycaj liyunnömi shuyaraycäshunqui usharishunayquipaj. Ichanga jucha rurayta ichipanquimanmi.» ");
INSERT INTO qub_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Juc junajcho wauguin Abelta Cainga «Jircapa pasyaj aywashun» niran. Jircacho ishcallan caycarna illajpita Abelta wañuycachiran. ");
INSERT INTO qub_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Chaypita Tayta Diosga Cainta tapuran: «¿Maytaj wauguiqui Abel?» nir. Tapuptin Caín niran: «Nogaga manami musyächu. ¿Wauguë ricaj-imatächu cä?» ");
INSERT INTO qub_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Niptin Tayta Dios niran: «¿Imanirtaj wauguiquita wañuchishcanqui? Wauguiquipa yawarnin mashtaraycajmi gayacaycäman gamta castiganäpaj. ");
INSERT INTO qub_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Canan gamga wauguiquipa yawarninta cay pachaman mashtashayquipitami maldisyunädu canqui. ");
INSERT INTO qub_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Maycho aruptiquipis manami micuypis sumäga wayupäshunquipächu. May-chaypapis mushrincu puricullarmi cacunquipaj. Manami maychöpis jamayta tarinquipächu.» ");
INSERT INTO qub_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Chayno niptinmi Cainga Tayta Diosta niran: «Chay castïgutaga manami awantashäpächu, tayta. ");
INSERT INTO qub_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Cananga caypita gargaycämanquimi. Ñaupayquipitapis carumanmi gargaycämanqui may-chaypapis mushrincu puricunäpaj. Chayno puriycajta pipis wañuycachimangachari.» ");
INSERT INTO qub_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Chaura Tayta Dios niran: «Pipis wañuchishoj cäga ganchis cuti mas fiyupa castigashami canga.» Nircur Caintaga juc señalta churaparan piwan tincuptinpis mana wañuchinanpaj. ");
INSERT INTO qub_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Chaynömi Cainga Tayta Dioswan parlaycashanpita aywacuran «Nod» nishan partiman. Chayga caycaran Edenman inti yagamunan caj-lächo. ");
INSERT INTO qub_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Chaypita Cainga warminwan cacuran. Warmin gueshyaj ricacur ollgu wamrata gueshyacuran. Jutinta churaparan «Enoc» nir. Chaypita Cainga juc marcata jatarachir chay marcapa jutinta churaparan wamran Enocpa jutillanta. ");
INSERT INTO qub_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Enocpa wamran caran Irad. Iradpa wamran caran Mehujael. Mehujaelpa wamran caran Metusael. Metusaelpa wamran caran Lamec. ");
INSERT INTO qub_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Lamecga caran ishcay warmiyoj. Jucajpa jutin caran «Ada», jucajpana «Zila». ");
INSERT INTO qub_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Ada gueshyacur wamranta jutichaparan «Jabal» nir. Jabalmi rimir-puntataga tolducunacho tiyaj y uywacunata mirachej caran. ");
INSERT INTO qub_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Jabalpa wauguinna caran Jubal. Jubalmi rimir-puntata arpata, quënata tucaj caran. ");
INSERT INTO qub_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Lamecpa jucaj warmin Zila gueshyacur wamranta jutichaparan «Tubal-Caín» nir. Tubal-Cainga jirrëru cashpanmi runsipita fyërrupita ima-aycatapis ruraj. Pañinpanami jutin caran «Naama». ");
INSERT INTO qub_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Lamecga ishcan warminta cayno willaparan: «¡Ada, Zila, nishäta wiyamay! Juc runa rachejpaj magamashanpitami wañurachirä. Goyojpaj chayaycachimaptinpis supaynintami apachirä. ");
INSERT INTO qub_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Cainta pipis wañuchej caj ganchis cuti mas fiyupa castigasha cananpaj caycaptenga nogata imatapis ruramaj cäga ganchis chunca ganchisnin (77) cuti masmi castigasha canga.» ");
INSERT INTO qub_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Adanga warminwan yapay cacuran. Warmin yapay gueshyaj ricacur gueshyacuran ollgu wamrata. Nircur niran: «Abelpa ruquin cananpämi Dios munasha wamrayoj canäta. Chaymi wamräpa jutinta churapäshaj ‹Set› nir, Abelta Caín wañuchishanpa ruquin captin.» ");
INSERT INTO qub_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Setpapis wamran caran. Wamran yuriptin jutinta churaparan «Enós» nir. Enospitarämi runacunaga Tayta Diosta adurayta gallaycäriran. ");
INSERT INTO qub_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Caychömi isquirbiraycan Adanpita miraj runacunapa willapan. Runata rurar Diosga quiquin-nirajtami ruraran. ");
INSERT INTO qub_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Ollguta warmita rurashan junaj Dios jutichaparan: «runa» nir. Nircur bindisyunta goran. ");
INSERT INTO qub_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Adán pachac quimsa chunca (130) watayoj caycaptin wamran Set yuriran. Chay wamranga pasaypa taytallanmi caran. ");
INSERT INTO qub_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Wamran yurishanpita pusaj pachac (800) wataraj Adanga cawaran. Chay wamranpa jananman warmi ollgu wamrancuna caranraj. ");
INSERT INTO qub_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Chaura Adanga cawaran isgun pachac quimsa chunca (930) watayoj cananyaj. Chay watayoj caycar-raj wañuran. ");
INSERT INTO qub_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Set pachac pichgan (105) watayoj caycaptin wamran Enós yuriran. ");
INSERT INTO qub_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Chaypita Set cawaran pusaj pachac ganchisnin (807) wataraj. Paypapis warmi ollgu wamrancuna caran. ");
INSERT INTO qub_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Chaura Set cawaran isgun pachac chunca ishcaynin (912) watayoj cananyaj. Chay watayoj caycar-raj wañuran. ");
INSERT INTO qub_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Enós isgun chunca (90) watayoj caycaptin wamran Cainán yuriran. ");
INSERT INTO qub_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Wamran yurishanpita Enós cawaran pusaj pachac chunca pichgan (815) wataraj. Paypapis warmi ollgu wamrancuna caran. ");
INSERT INTO qub_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Chaura Enós cawaran isgun pachac pichgan (905) watayoj cananyaj. Chay watayoj caycar-raj wañuran. ");
INSERT INTO qub_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Cainán ganchis chunca (70) watayoj caycaptin wamran Mahalaleel yuriran. ");
INSERT INTO qub_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Wamran yurishanpita Cainán cawaran pusaj pachac chuscu chuncan (840) wataraj. Paypapis warmi ollgu wamrancuna caran. ");
INSERT INTO qub_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Chaura Cainán cawaran isgun pachac chuncan (910) watayoj cananyaj. Chay watayoj caycar-raj wañuran. ");
INSERT INTO qub_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Mahalaleel sojta chunca pichgan (65) watayoj caycaptin wamran Jared yuriran. ");
INSERT INTO qub_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Wamran yurishanpita Mahalaleel cawaran pusaj pachac quimsa chuncan (830) wataraj. Paypapis warmi ollgu wamrancuna caran. ");
INSERT INTO qub_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Chaura Mahalaleel cawaran pusaj pachac isgun chunca pichgan (895) watayoj cananyaj. Chay watayoj caycar-raj wañuran. ");
INSERT INTO qub_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Jared pachac sojta chunca ishcay (162) watayoj caycaptin wamran Enoc yuriran. ");
INSERT INTO qub_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Wamran yurishanpita Jared cawaran pusaj pachac (800) wataraj. Paypapis warmi ollgu wamrancuna caran. ");
INSERT INTO qub_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Chaura Jared cawaran isgun pachac sojta chuncan ishcay (962) watayoj cananyaj. Chay watayoj caycar-raj wañuran. ");
INSERT INTO qub_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Enoc sojta chunca pichga (65) watayoj caycaptin wamran Matusalén yuriran. ");
INSERT INTO qub_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Enoc cawaran Tayta Dios munashanno. Wamran Matusalén yurishanpita quimsa pachac (300) wata goyaran cay pachacho. Paypapis warmi ollgu wamrancuna caran. ");
INSERT INTO qub_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Enoc quimsa pachac sojta chunca pichgan (365) watayoj caycashanchömi ");
INSERT INTO qub_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","illgaran. Tayta Dios munashanno cawasha captinmi paytaga Dios apacuran. ");
INSERT INTO qub_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Matusalén pachac pusaj chunca ganchis (187) watayoj caycaptin wamran Lamec yuriran. ");
INSERT INTO qub_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Wamran yurishanpita Matusalén cawaran, ganchis pachac pusaj chunca ishcay (782) wataraj. Paypapis warmi ollgu wamrancuna caran. ");
INSERT INTO qub_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Matusalén cawaran isgun pachac sojta chunca isgun (969) watayoj cananyaj. Chay watayoj caycar-raj wañuran. ");
INSERT INTO qub_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Lamec pachac pusaj chunca ishcay (182) watayoj caycaptin wamran yuriran. ");
INSERT INTO qub_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Wamran yuriptin Lamec niran «Cay pachata Tayta Dios maldisyunasha captinpis cay wamrami jamachimäshun arurpis alläpa mana ñacananchïpaj» nir. Chaypitami chay wamranpa jutinta churaparan Noé nir. ");
INSERT INTO qub_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Wamran Noé yurishanpita Lamec cawaran pichga pachac isgun chunca pichgan (595) wataraj. Paypapis warmi ollgu wamrancuna caran. ");
INSERT INTO qub_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Lamec cawaran ganchis pachac ganchis chunca ganchis (777) watayoj cananyaj. Chay watayoj caycar-raj wañuran. ");
INSERT INTO qub_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Noé pichga pachac (500) watayoj caycaptin wamrancuna yuriran. Chay wamrancunapa jutin caran: Sem, Cam, Jafet. ");
INSERT INTO qub_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Cay pachacho runacuna aypallaman miraptin, warmi wamrancunapis aypallana caran. ");
INSERT INTO qub_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","Chaura Diospa wamrancunaga ricaran runacunapa warmi wamrancuna cuyayllapaj cashanta. Chaymi maygantapis munashan cajta acrarcur majachacaran. ");
INSERT INTO qub_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Chayno captinmi Tayta Diosga niran: «Runalla captinmi jämaynëga runacho manana imaycamapis canganachu. Chaymi runacunaga cawanga pachac ishcay chuncan (120) watayoj cananyajlla.» ");
INSERT INTO qub_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Chay wichan runacunapa warmi wamrancunawan Diospa wamrancuna majachacaptinmi cay pachachöga yurimuran jatusaj runacuna. Paycunaga caran callpasapa, rejsisha runacuna. ");
INSERT INTO qub_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Tayta Dios ricaran runacuna pasaypa mana alli rurayllachöna cawashanta. Chay runacunaga yarparaycaran jucha rurayllapaj. ");
INSERT INTO qub_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Chaymi Tayta Diosga runata rurashanpita pësacushpan ");
INSERT INTO qub_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","niran: «¡Imapäraj runata rurarä! Cananga rurashä runacunata ushajpaj illgächishaj. Illgächishaj llapan animalcunata garachaypa purejcunatawan päriypa purejcunatapis.» ");
INSERT INTO qub_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Noëtami ichanga Tayta Dios alli ñawinpa ricaran pay munashanno cawaptin. ");
INSERT INTO qub_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Caychömi isquirbiraycan Noëpa willapan: Noëga caran amatar alli runa. Chay wichanga payllami Dios munashanno goyaran. ");
INSERT INTO qub_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Noëpaga wamrancuna caran quimsa. Jutincuna caran: Sem, Cam, Jafet. ");
INSERT INTO qub_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Dios ricaran cay pachachöga fiyupa jucha ruraywan wañuchinacuyllana caycajta. ");
INSERT INTO qub_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Cay pachacho tiyaj runacunaga fiyupa mana allimanna ticrasha caran. Jucha rurayllamanna uman churacasha caycaran. ");
INSERT INTO qub_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Chaymi Noëta Tayta Dios niran: «Cay pachacho caycaj runacunaga carcaycan fiyupa jucha rurayllachömi, wañuchinacuyllachömi. Chaymi munducho cajtaga ushajpaj illgächej-aywä. ");
INSERT INTO qub_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Chaymi gamga guerupita ruray achca cuartuyoj jatuncaray büquita. Yacu mana yaycunanpaj jananpa rurinpapis breyawan chapanqui. ");
INSERT INTO qub_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Chay büquita ruranqui cayno: larguyninta ruranqui pachac quimsa chunca pichgan (135) metruta. Anchuyninta ruranqui ishcay chunca ishcay (22) metruta. Altuynintanami ruranqui chunca quimsa (13) metruta. ");
INSERT INTO qub_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Ruranqui ishcay jana altusniyojta. Jananta gatashayqui chaquinpana pullan metru altutano uchcucunata ruranqui intëru cantupa tumarej. Büquipataga puncuntapis ruranqui. ");
INSERT INTO qub_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Nogami tamyachimushaj dilubyu tamyata. Chay dilubyu tamyaptinmi llapan puntacunata ñitinanyaj yacu juntanga. Allpa janancho cawaj cajcunaga intëru munducho shengaypa ushajpaj wañongapaj. ");
INSERT INTO qub_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Gamwanmi ichanga conträtuta rurashun salbanäpaj. Gamga yaycunquipaj büquiman, warmiqui, wamrayquicuna, wamrayquicunapa warmincunapis. ");
INSERT INTO qub_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Büquimanga yaycachinquipaj cay pachacho caj tucuy-niraj uywacunatapis chinan orgunta. Chaynöpami paycunapis gamcunano salbaconga. ");
INSERT INTO qub_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Gamcunawanmi büquiman yayconga tucuy-niraj animalcuna chinan orgun, uywana caj mana uywana cajpis, garachaypa purejcunapis, päriypa purejcunapis. Chaynöpami paycunapis gam cawashayquino cawanga. ");
INSERT INTO qub_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Micuyta churanqui aypallata quiquiquicunapäpis animalcunapäpis. Chaytami büquicho llapayqui micunquipaj.» ");
INSERT INTO qub_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Chaura Noëga llapantapis ruraran Tayta Dios nishannölla. ");
INSERT INTO qub_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Chaypita Noëta Tayta Dios niran: «Cay pachacho caj llapan runacunapita gamllami goyaycanqui noga munashäta rurar. Chaypitami gamga llapan famillyayquiwan yaycunqui büqui rurashayquiman. ");
INSERT INTO qub_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Limyu caj uywacunataga ganchis majata chinan orgunta charircur büquiman wichganqui; mana limyu cajta ichanga chinan orgullanta. ");
INSERT INTO qub_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Chayno päriypa purej äbicunatapis charinqui ganchis majata chinan orgunta. Chaycunatapis cay pachacho mana illgänanpaj büquiman wichganqui. ");
INSERT INTO qub_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Cananpita ganchis junajtami tamyata tamyachimushäpaj chuscu chunca (40) junaj, chuscu chunca (40) pagas mana chawayllapa. Chaynöpami llapan rurashäcuna cawaycajta cay pachapita illgächishaj.» ");
INSERT INTO qub_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Chaura Noëga llapantapis ruraran imano rurananpäpis Tayta Dios nishannölla. ");
INSERT INTO qub_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Cay pachaman löcu tamya tamyamushan wichan Noëga caycaran sojta pachac (600) watayoj. ");
INSERT INTO qub_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Löcu tamyawan mana wañunanpämi Noëga büquiman yaycuran warminwan, wamrancunawan, llumchuynincunawanpis. ");
INSERT INTO qub_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Chaynömi büquimanga yaycuran limyu caj mana limyu caj animalcunapis, päriypa purejpis, garachaypa purejpis. ");
INSERT INTO qub_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","Chay animalcunataga Tayta Dios nishanno Noëmi yaycachiran chinan orgunta. ");
INSERT INTO qub_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Tayta Dios nishanno rasunpami ganchis junajtaga löcu tamya gallaycuran. Allpataga yacu ñitiytana gallaycuran. ");
INSERT INTO qub_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Chay tamyaga gallaycuran mushoj wataman gallarej ishcay quilla chunca ganchis (17) junajnin caycaptinmi. Noëga caycaran sojta pachac (600) watayoj. Syëlucho yacuta chaparaycaj puncucunapis quichacäcuran. Tamyaycaptillanmi yacuga pacha rurinpitapis pashtacaramuran. ");
INSERT INTO qub_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Tamyaga tamyaran chuscu chunca (40) junaj chuscu chunca (40) pagas mana chawayllapa. ");
INSERT INTO qub_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Tamya gallarishan junaj Noëga büquiman yaycushana caran quimsan wamrancunawan. Wamrancunapa jutin caran: Sem, Cam, Jafet. Noëpa warminpis yaycushana caran quimsan llumchuynincunawan. ");
INSERT INTO qub_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Paycunawan iwalmi yaycuran llapan casta animalcuna chucarupis, manshupis, tucuy-niraj garachaypa purej animalcunapis, päriypa purej äbicunapis. ");
INSERT INTO qub_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Llapan casta animalcunatami ishcayta-cama Noëga büquiman yaycachiran. ");
INSERT INTO qub_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Cada casta animalcunatami yaycachiran chinan-orgunta. Llapantapis yaycuchiran Tayta Dios nishannölla. Büqui rurichöna llapan carcaycaptin puncutaga Tayta Dios wichgaran. ");
INSERT INTO qub_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Löcu tamya tamyaran chuscu chunca (40) junaj. Chayno tamyaycaptillanna yacu juntaran intëru allpa jananpa. Yacu juntarga büquita jogariranna. Chaura wampuytana gallaycuran. ");
INSERT INTO qub_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Yacuga masta mastana juntaycaran. Chaymi büquiga yacu jananpa wampur tumaycaran. ");
INSERT INTO qub_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Tamyaycaptillan yacuga juntaran altunnin puntacunata ñitinanyaj. ");
INSERT INTO qub_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Altunnin puntacunata ñitishanpitapis ganchis metrupanöraj mas altuta päsaran. ");
INSERT INTO qub_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Allpa janancho tiyaj cajtaga yacu ñitirmi llapanta wañuchiran. Runacunawan iwalmi wañuran manshu caj chucaru caj animalcunapis, garachaypa purejpis päriypa purejpis. ");
INSERT INTO qub_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Allpa janancho tiyaj jämayniyoj cäga llapanmi shengaypa ushacaran. ");
INSERT INTO qub_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Noëwan büquiman yaycojcunallami cawaycarga quëdaran. Chaypita cäga llapanmi ushacaran: runacunapis, animalcunapis, pärej äbicunapis, pampapa garachaypa purej cajcunapis. ");
INSERT INTO qub_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Yacuga allpa janancho gocharäcuran pachac pichga chuncan (150) junajmi. ");
INSERT INTO qub_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Tayta Diosga manami gongaranchu Noëta y büquicho caycaj animalcunatapis. Chaymi Dios niran chay lamar yacuta wayra pücananpaj. Wayra pücaptinmi yacuga chaquiyta gallaycuran. ");
INSERT INTO qub_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Chaura pacha rurinpita yacu pashtamojpis manana pashtamurannachu. Syëlupita yacu llojshimunanpaj quicharaycaj puncupis wichgacäcuranna. Chauraga tamyapis manana tamyarannachu. ");
INSERT INTO qub_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Chaura yacuga wallca-wallcalla chaquiytana gallaycuran. Pachac pichga chuncan (150) junajtaga yacu chaquiycaranna. ");
INSERT INTO qub_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Chay watacho ganchis quillana caycaptin chunca ganchisnin (17) junajcho büquega jamacäcuran Ararat parti puntacho. ");
INSERT INTO qub_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Waranllanta waranllantana yacuga chaquiycaran. Chunca quillaman gallarej junajchöga jatunnin caj puntacuna ricacaranna. ");
INSERT INTO qub_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Chaypita chuscu chunca (40) junajta Noé quicharan rurashan büquipa bentänanta. ");
INSERT INTO qub_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","Chay quichashan bentänapa cachaycuran «cuervo» jutiyoj äbita yacu chaquishanta u manaraj chaquishantapis musyananpaj. Chay äbiga maymanpis ratananpaj mana captin päriyllapa puriycaran wac-läman cay-lämanpis aywashpan. Ratananpaj chaqui allpata mana tarir chayno buylar puriycaran. ");
INSERT INTO qub_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Chaypitaga Noé cacharan juc palumatana yacu chaquishantana u manaraj chaquishantapis musyamunanpaj. ");
INSERT INTO qub_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Ichanga paluma cutimuran büquiman maychöpis chaqui allpata ratananpaj mana tarir. Yacuga jinallaraj allpata ñitiraycaran. Noëga maquinta bentänapa macyarcur palumata büquiman cutichimuran. ");
INSERT INTO qub_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Chaypita ganchis junajta Noé yapay cacharan palumata. ");
INSERT INTO qub_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Pacha chacaycaptinna paluma cutimuran olivo jachapa rämanta amusha. Chaynöpami Noé musyaran yacu chaquiycashantana. ");
INSERT INTO qub_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Cutimushanpita ganchis junajta palumata yapay cacharan. Chaura palumaga manana cutimurannachu. ");
INSERT INTO qub_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Cay pachapita yacu chaquiran Noé sojta pachac juc (601) watayoj caycaptin. Chayga caran juc wataman gallarej quilla rimir junajchöna. Noëga büquipa jananta quicharan. Quicharerga ricaran allpa caycajtana. ");
INSERT INTO qub_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Ishcay caj quillacho ishcay chunca ganchis (27) junajninna caycaptin intëru allpa jananpita yacu chaquishana caycaran. ");
INSERT INTO qub_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Chaymi Noëta Dios niran: ");
INSERT INTO qub_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","«Cananga büquipita llojshiyna llapayqui chaycho cäga, gampis warmiquipis wamrayquicunapis llumchuyniquicunapis. ");
INSERT INTO qub_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Gamcunawan iwal caycaj llapan casta animalcunatapis cachayna manshutapis, chucarutapis, pampapa garachaypa purejtapis mirar intëru munduman juntananpaj.» ");
INSERT INTO qub_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Chayno niptinmi Noëga büquipita llojshiran warminwan, wamrancunawan llumchuynincunawan. ");
INSERT INTO qub_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Chay büquipita llojshiran llapan casta animalcuna cay allpa janancho tiyaj cäga manshupis chucarupis, pampapa garachaypa purejpis, päriypa purejpis. ");
INSERT INTO qub_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Chaypita Noëga juc altarta pergaran Tayta Diosta adurananpaj. Nircur limyu caj animalcunapita jucta-cama chariran. Chaycunata pishtarcur altarcho rupachiran Tayta Diospaj. ");
INSERT INTO qub_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Chayno rupachiptinmi Tayta Dios cajman jömuynin chayaran. Chaymi pay niran: «Runaga wamra cashanpita-pachami mana allita rurar goyan. Chaypis runapa juchanpitaga allpata manami ‹maldisyunädu cachun› nishächu. Cananpitaga llapan casta animalcunatapis manami ushacächishäpänachu canan rurashänöga. ");
INSERT INTO qub_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","«Mundu manaraj ushacashanyäga caycangami micuycunata murupacuypis shuntapacuypis. Cangami shanaypis gasaypis. Cangami tamyapis usyapis. Cangami junajpis chacaypis.» ");
INSERT INTO qub_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Noëta wamrancunatawan bindisyunta goshpan Dios cayno niran: «Gamcuna miray aypallaman cay pachaman juntananyaj. ");
INSERT INTO qub_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Mundu intërucho caj animalcunapis gamcunatami manchacushunquipaj. Llapan casta animalcuna gamcunapa munayniquichömi canga päriypa purejpis, allpa janancho purejpis, chayno lamarcho cajpis. ");
INSERT INTO qub_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Nogaga gamcunatami micunayquipaj goycö llapan animalcunata, micuycunata, berdüra lantacunata. ");
INSERT INTO qub_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Ama micunquichu yawarniyoj caycaj aychataga. Yawarninchöga cawaymi caycan. ");
INSERT INTO qub_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Chaymi runapa yawarninta mashtaj cajtaga jusgashaj. Runata wañuchej animalpis wañuchicangami. Chaynömi runa-masinta wañuchej cajpis wañuchicanga. ");
INSERT INTO qub_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","«Quiquin-nirajtami Diosga runata rurasha. Chaymi pipis juc runata wañuchiptin quiquintapis jucga wañuchengapaj.» ");
INSERT INTO qub_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Gamcunapis aypallaman miray. Munduman juntanayquiyaj miray. ");
INSERT INTO qub_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Yapaypis Noëta wamrancunatawan Dios niran: ");
INSERT INTO qub_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","«Sumaj wiyamay. Gamcunawan, gamcunapita mirajcunawanpis juc conträtutami rurashun. ");
INSERT INTO qub_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","Büquipita llapan casta llojshej animalcunawanpis conträtutami rurashun. Conträtuta rurashanchëga canga llapan casta äbicunapaj, uywana caj animalcunapaj, chucaru caj animalcunapaj, mundu intërucho caj animalcunapäpis. ");
INSERT INTO qub_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Chayno canan conträtuta rurashanchïpitaga mananami yapayga tamyawan illgächishäpänachu allpata, runata ni animaltapis. ");
INSERT INTO qub_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Runawan animalcunawan imaycamapis conträtu rurashäpitami cay señalta churä. ");
INSERT INTO qub_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Pucutaymanmi turmanyata churashcä. Cay pachacho tiyajcunawan noga conträtu rurashä musyacänanpaj chay turmanyami señal caycan. ");
INSERT INTO qub_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Allpa jananpa pucutay shamuptin chaychömi turmanya yurengapaj. ");
INSERT INTO qub_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","Chay turmanya yuriptenga noga yarpäshäpaj gamcunawan llapan animalcunawan conträtu rurashäta. Yarpärishäpaj yapayga manana löcu tamyawan illgächinäpaj noga nishäta. ");
INSERT INTO qub_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Pucutaycho turmanya yuriptin, noga ricärir yarpärishäpaj llapan runacunawan animalcunawanpis cay pachacho caycajcunawan imaycamapis conträtuta rurar parlashäta. ");
INSERT INTO qub_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Llapan cawajcunawan noga conträtu rurashäpitami cay turmanya señal caycangapaj.» Chaynömi Diosga Noëwan parlaran. ");
INSERT INTO qub_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Noëpa wamrancuna büquipita llojshej caycunami caran: Sem, Cam y Jafet. Camga Canaanpa papäninmi caran. ");
INSERT INTO qub_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Chaycunami Noëpa quimsan wamrancuna caran. Paycunapita miraj wamrancunawannami cay pachacho yapay aypallamanna miraran. ");
INSERT INTO qub_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Noëga chacra aroj runami caran. Paymi rimëruga übasta lantaran. ");
INSERT INTO qub_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Chaypita juc junajcho Noëga bïnuta rurarcur upur machacäcuran. Nircur toldun rurincho röpaynaj galalla jitaraycaran. ");
INSERT INTO qub_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Canaanpa papänin Camga papänin Noé galalla caycajta ricaycur aywaran ishcay caj wauguincunata willaj. ");
INSERT INTO qub_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Chaura Semwan Jafetga jinan öra juc jacucunata aparan. Papänin galalla caycajta ricananpita aywaran guepallapa juc-läpa ricacushalla. Nircur papänin galalla jitaraycajta chaparcuran. ");
INSERT INTO qub_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Machashanpita paucarcur Noé musyaran shullca wamran imano portacushantapis. ");
INSERT INTO qub_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","Chaymi Campa wamran Canaán y paypita mirajcuna maldisyunasha cananpaj niran: «¡Canaanga maldisyunädu cachun! Payga wauguincunapa uywayninmi canga.» ");
INSERT INTO qub_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Mastapis niran: «¡Semtaga noga rispitashä Tayta Dios bindisyunta gochun! Canaanpita mirajcunaga Sempita mirajcunapa uywayninna cachun. ");
INSERT INTO qub_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Jafet-taga Dios yanapächun achcaman mirananpaj. Paypita mirajcunaga Sempita mirajcunawan iwal tiyachun. Canaanpita mirajcunaga Jafetpita mirajcunapapis uywaynin cachun.» ");
INSERT INTO qub_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Chay löcu tamya cashanpita Noëga cawaran quimsa pachac pichga chuncan (350) wataraj. ");
INSERT INTO qub_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Chaura Noëga wañuran isgun pachac pichga chuncan (950) watayoj caycar-raj. ");
INSERT INTO qub_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Caychömi isquirbiraycan Noëpa wamrancunapa, paycunapita mirajcunapa willapan. Noëpa wamrancuna caran: Sem, Cam, Jafet. Dilubyu cashanpitaraj chay wamrancunapa wamrancuna cayno jutiyojcuna caran: ");
INSERT INTO qub_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Jafetpa wamrancuna caran: Gomer, Magog, Madai, Javán, Tubal, Mesec, Tiras. ");
INSERT INTO qub_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Gomerpa wamrancuna cayno caran: Askenaz, Rifat Togarma. ");
INSERT INTO qub_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Javanpa wamrancuna caran: Elisa, Tarsis, Quitim, Rodanim. ");
INSERT INTO qub_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Chaycunami caran Jafetpita mirajcuna. Chaura paycunaga lamar cantunpa mashtacaran mirar nasyuncuna cananpaj. Paycunaga cada nasyuncho juc rimayta-camana parlaj. ");
INSERT INTO qub_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Campa wamrancuna caran: Cus, Mizraim, Fut, Cananeo. ");
INSERT INTO qub_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Cuspa wamrancuna caran: Seba, Havila, Sabta, Raama, Sabteca. Raamapa wamrancunana caran: Sebawan Dedán. ");
INSERT INTO qub_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Nimrodpis Cuspa wamranmi caran. Nimrodmi cay pachachöga munayniyoj runa caran. ");
INSERT INTO qub_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Nimrodga Tayta Dios yanapaptinmi yachacuycuran jirca animalcunata chariyta. Chaypitami rimaypis can: «Tayta Dios yanapaptin Nimrod cashanno animal chariyta yachan» nir. ");
INSERT INTO qub_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Pay mandashan mas jatun caj siudäcunaga caran Sinar particho: Babel, Erec, Acad, Calne. ");
INSERT INTO qub_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Chay pachapitami aywacuran Asur partiman. Nircur ruraran Nínive siudäta, Rehobot-Ir siudäta, Cala siudäta. ");
INSERT INTO qub_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","Chayno ruraran jatun Resén siudätapis. Chay siudäga caycaran Ninivepita Calaman aywaj nänichömi. ");
INSERT INTO qub_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Mizraimpita mirajcunanami caycan Lud runacuna, Anam runacuna, Lehab runacuna, Naftuh runacuna, ");
INSERT INTO qub_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","Patrus runacuna, Casluh runacuna, Caftor runacuna. Chay Caftor runacunapitami Filistea runacunaga mirasha. ");
INSERT INTO qub_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Canaanpa guechpa wamran caran Sidón. Paypa shullcanna caran Het. ");
INSERT INTO qub_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","Canaanpita mirajcunami caycan Jebús runacuna, Amorreo runacuna, Gerges runacuna, ");
INSERT INTO qub_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","Hev runacuna, Araz runacuna, Sin runacuna, ");
INSERT INTO qub_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","Arvad runacuna, Zemar runacuna, Hamat runacuna. Chay runacunaga aypallaman mirashpan intëruman mashtacaran. ");
INSERT INTO qub_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Chaura Canaanpita mirajcuna tiyarcaycaran Sidón marcapita Gaza marcapa ñaupancho caycaj Gerar siudäcama. Chay marcapitana chayaraycaran Lasa marcapa ñaupancho caycaj Sodoma, Gomorra, Adma, Zeboim marcacuna caycashancama. ");
INSERT INTO qub_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Chaycunami caran Campita mirajcuna. Chaura paycunami mirar mashtacaran nasyuncuna cananpaj. Chaura cada nasyuncho juc rimaytana parlaj. ");
INSERT INTO qub_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Jafetpa mayur wauguin Sempapis wamrancuna caran. Sempa wamranpita mirajllami caran Heberpis paypita mirajcunapis. ");
INSERT INTO qub_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Sempa wamrancunami caran: Elam, Asur, Arfaxad, Lud, Aram. ");
INSERT INTO qub_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Arampa wamrancunana caran: Uz, Hul, Geter, Mas. ");
INSERT INTO qub_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Arfaxadpa wamranmi caran Sala. Salapa wamranmi caran Heber. ");
INSERT INTO qub_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Heberpapis wamran caran ishcay. Jucaj wamranpa jutin caran Peleg. (Chaynöga jutin caran cay pachacho tiyaj runacuna chay wichan intëruman raquicashanpitami.) Pelegpa wauguinpana jutin caran Joctán. ");
INSERT INTO qub_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Joctanpa wamrancunana caran: Almodad, Selef, Hazar-mavet, Jera, ");
INSERT INTO qub_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Adoram, Uzal, Dicla, ");
INSERT INTO qub_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Obal, Abimael, Seba, ");
INSERT INTO qub_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Ofir, Havila, Jobab. Llapan paycunaga Joctanpa wamrancunami caran. ");
INSERT INTO qub_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Paycuna tiyashanga caran Mesäpita-pacha Sefarcama. Sefarga caycan inti yagamunan-lächo aypalla puntacuna caycashanchömi. ");
INSERT INTO qub_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Chaycunami caran Sempita mirajcuna. Chaura paycunami mashtacaran mirar nasyuncuna cananpaj. Paycunaga cada nasyuncho juc rimaytana parlaj. ");
INSERT INTO qub_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Cay pachata yacu ñitishanpitaga Noëpita mirajcuna cay pachacho intëruman mashtacaran. Paycunaga achca nasyuncunapaj aypajmi miraran. ");
INSERT INTO qub_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Chay wichanga llapan runacunapis juc casta rimayllatami parlaran. ");
INSERT INTO qub_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Inti yagamunan cajpita aywacur Sinar jutiyoj pampata tariran. Chaura chay pampallachöna tiyacaycäriran. ");
INSERT INTO qub_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Tiyarcaycashancho shuntacarcur juc junaj llapan parlacuran: «Llapanchi ladrilluta rurashun. Nircur cuwashun» nir. Ladrillutaga ruraran rumipa ruquin cananpämi. Chay ladrillucunatanami breyallanpawan pergaran. ");
INSERT INTO qub_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Chaypita llapan parlacur ninacuran: «Jatun marcata rurashun. Chaychöna juc törrita rurashun syëlucama chayajta. Chaynöpami rejsisha cashun. Chaura cay pachachöga noganchi manami intëruman mashtacäshunnachu.» ");
INSERT INTO qub_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Ichanga Tayta Dios urämuran runacuna arurcaycashan siudätawan törrita ricaj. ");
INSERT INTO qub_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Chaymi yarpachacur Tayta Dios niran: «Paycunaga carcaycan juc marcallami. Juc castallatami parlarcaycanpis. Chay arurcaycashanga gallaycunallanmi canpis. Imatapis munashantaga rurarengachari. ");
INSERT INTO qub_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Chaymi paycuna cajman urarcur rimashancunata achca castaman ticrachishun quiquin-pura mana tantiyachinacunanpaj.» ");
INSERT INTO qub_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Chayno nirmi Tayta Diosga llapan runacunata cay pacha intëruman mashtacächiran. Chaynöpami arurcaycashan marcatapis cachaycäriran. ");
INSERT INTO qub_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Tayta Diosga cay pachacho runacuna rimashanta ticrachiran achca casta rimayman. Mana tantiyachinacurnami runacunaga raquicarcur-raquicarcur intëru mundupa aywacuran. Chaypitami chay marcapa jutinta churaparan «Babel» nir. ");
INSERT INTO qub_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Caychömi isquirbiraycan Sempa wamrancunapa, paycunapita mirajcunapa willapan. Dilubyu cashanpita ishcay watatami Sempa wamran Arfaxad yuriran. Chay wichan Sem caycaran pachac (100) watayojna. ");
INSERT INTO qub_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Wamran Arfaxad yurishanpita Semga cawaran pichga pachac (500) wataraj. Wamrancuna caranraj warmipis ollgupis. ");
INSERT INTO qub_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Arfaxad quimsa chunca pichgan (35) watayoj caycaptin wamran Sala yuriran. ");
INSERT INTO qub_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Wamran Sala yurishanpita Arfaxad cawaran chuscu pachac quimsan (403) wataraj. Paypapis warmi ollgu wamrancuna caranraj. ");
INSERT INTO qub_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Sala quimsa chunca (30) watayoj caycaptin wamran Heber yuriran. ");
INSERT INTO qub_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Wamran Heber yurishanpita Sala cawaran chuscu pachac quimsan (403) wataraj. Paypapis warmi ollgu wamrancuna caranraj. ");
INSERT INTO qub_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Heber quimsa chunca chuscu (34) watayoj caycaptin wamran Peleg yuriran. ");
INSERT INTO qub_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Wamran Peleg yurishanpita Heber cawaran chuscu pachac quimsa chuncan (430) wataraj. Paypapis warmi ollgu wamrancuna caranraj. ");
INSERT INTO qub_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Peleg quimsa chunca (30) watayoj caycaptin wamran Reu yuriran. ");
INSERT INTO qub_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Wamran Reu yurishanpita Peleg cawaran ishcay pachac isgun (209) wataraj. Paypapis warmi ollgu wamrancuna caranraj. ");
INSERT INTO qub_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Reu quimsa chunca ishcay (32) watayoj caycaptin wamran Serug yuriran. ");
INSERT INTO qub_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Wamran Serug yurishanpita Reu cawaran ishcay pachac ganchisnin (207) wataraj. Paypapis warmi ollgu wamrancuna caranraj. ");
INSERT INTO qub_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Serug quimsa chunca (30) watayoj caycaptin wamran Nacor yuriran. ");
INSERT INTO qub_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Wamran Nacor yurishanpita Serug cawaran ishcay pachac (200) wataraj. Paypapis warmi ollgu wamrancuna caranraj. ");
INSERT INTO qub_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Nacor ishcay chunca isgun (29) watayoj caycaptin wamran Taré yuriran. ");
INSERT INTO qub_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Wamran Taré yurishanpita Nacor cawaran pachac chunca isgunnin (119) wataraj. Paypapis warmi ollgu wamrancuna caranraj. ");
INSERT INTO qub_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Taré ganchis chunca (70) watayoj caycaptin wamrancuna quimsana caycaran: Abram, Nacor, Harán. ");
INSERT INTO qub_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Caychömi isquirbiraycan Tarëpita mirajcunapa willapan. Tarëmi caran Abrampa, Nacorpa, Haranpa papänin. Haranpa wamrannami caran Lot. ");
INSERT INTO qub_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Haranga yurishan marcallachömi wañucuran Caldeacho caycaj Ur marcacho. Payga papänin Tarëpa ñaupantami wañucuran. ");
INSERT INTO qub_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Abramga Saraiwan majachacaran. Wauguin Nacornami Milcawan majachacaran. Milcaga caran Iscapa ñañan. Paycunapa papänin caran Harán. ");
INSERT INTO qub_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Saraiga wawata charayta manami camäpacuranchu. ");
INSERT INTO qub_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Chay tiyaycashan Ur marcapita Tarëga aywacuran Canaán partiman. Chayno aywacurmi pushacuran wamran Abramta, llumchuynin Saraita, willcan Lot-tapis. Harán siudäman chayaycärerga chayllachöna tiyacuran. ");
INSERT INTO qub_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Haranllachöna Tarëga wañucuran ishcay pachac pichgan (205) watayoj caycashancho. ");
INSERT INTO qub_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Juc junaj Abramta Tayta Dios niran: «Famillyayquicunata cachaycur cay marcayquipita aywacuy ricachinäpaj caycaj partiman. ");
INSERT INTO qub_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Gampita mirajcunataga noga yanapäshäpaj jatun nasyunpaj aypaj mirananpaj. Gamtapis bindisyunta goshayquimi. Sumaj rejsisha canayquipämi yanapäshayquipaj. Gam-cashami waquin runacunatapis bindisyunta goshaj. ");
INSERT INTO qub_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Gamta bindisashoj cajtaga nogapis bindisyuntami goshaj. Gamta chiquishoj cajtaga nogapis maldisyunädu cananpämi nishaj. Gam-cashami mundu intërucho tiyaj runacunatapis bindisyunta goshaj.» ");
INSERT INTO qub_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Chaura Abramga Tayta Dios nishanta wiyacur aywacuran Harán siudäpita Canaán partiman. Aywacushan öra Abramga caycaran ganchis chunca pichgan (75) watayoj. ");
INSERT INTO qub_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Abram aywacuran warmin Saraiwan subrinun Lot-tapis pushacurcur. Harancho tarishan uywaynincunatapis Abramga pushacuran. Harán siudächo tiyar tarishan cajtaga llapan ima-aycantapis Canaanman apacuran. Canaanman chayaycurpis ");
INSERT INTO qub_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Abramga carutaraj aywaran Shequem marcaman chayananyaj. Chay quinraychöna Morecho encina yöra caycashan ñaupancho pachacuran. Chay partichöga achcami Cananeo runacunapis tiyarcaycaran. ");
INSERT INTO qub_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Chaycho tiyaycaptin Abramta Tayta Dios yuriparcur niran: «Cay partitaga gampita mirajcunatami goycushäpaj» Chaycho yuripashanpitami Abramga Tayta Diosta adurananpaj juc altarta jinancho pergaran. ");
INSERT INTO qub_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Chaypita aywacur Bet-elpa chimpanchöna tiyaran. Paycuna tiyashan cajpita Bet-elga caycaran inti yaganan caj-lächöna. Hai siudänami caycaran inti yagamunan caj-lächo. Chaychömi Abramga yapay juc altarta pergaran Tayta Diosta adurananpaj. ");
INSERT INTO qub_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Chaypitapis aywacuran. Pachacur-pachacur aywaycällar chayaran Néguev particama. ");
INSERT INTO qub_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Chay wichan Abram tiyashan partichöga intërucho muchuy caran. Chaymi Abramga Egiptumanna aywacuran. ");
INSERT INTO qub_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Egiptuman chayaycashanchöna Abramga warmin Saraita cayno niran: «Gamga cuyayllapaj camaraj warmimi canqui. ");
INSERT INTO qub_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Chaymi warmë cashayquita Egipto runacuna musyarga nogata wañuchimanga gamwan tiyananpaj. ");
INSERT INTO qub_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Gam-raycu mana wañuchimänanpaj ‹pañinmi cä› ninqui.» ");
INSERT INTO qub_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Nishannöllami Abram Egiptuman chayaycuptin Egipto runacuna Saraita ricaran cuyayllapaj camaraj warmita. ");
INSERT INTO qub_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Egipto nasyuncho faraonta mandäshej runacunapis chaynömi ricaran. Chaymi faraonta willaran cuyayllapaj warmi cashanta. Willaptinna faraonga palasyunman pushachiran. ");
INSERT INTO qub_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Sarai-raycumi faraonga Abramta alli ricaran. Chaymi goycuran wäcacunata, uyshacunata cabracunata, bürrucunatapis, camëllucunatapis, chayno uyway runacunatapis warmita ollguta. ");
INSERT INTO qub_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Ichanga Sarai-jananmi Tayta Dios castigaran fiyu gueshyawan faraonta llapan famillyancunatawan. ");
INSERT INTO qub_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Chaymi faraonga Abramta gayarcachir cayno tapuran: «¿Imanirtaj chayno ruramashcanqui? ¿Imanirtaj cay warmipäga mana willamarayquichu warmiqui cashanta? ");
INSERT INTO qub_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Gamga nimashcanqui cay warmi pañiqui cashantami. Chaynöpitachi warmëpäpis uywacurcöman caran. Cananga warmiquita pushacurcur caypita aywacuy.» ");
INSERT INTO qub_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Chayno nirmi faraonga maquincho caj runacunata niran Abramta «aywacuy» ninanpaj. Chaura chay runacunaga Abramta garguran warmintawan llapan charashancunatawan. ");
INSERT INTO qub_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Abram Egipto nasyunpita cuticur aywacuran warminta pushacurcur llapan ima-aycantapis apacurcur. Néguev partiman chayaran. Subrinun Lotpis Abramwan iwal aywacuran. ");
INSERT INTO qub_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Abram rïcu captinmi paypaga caran goripis, guellaypis, aypalla uywacunapis. ");
INSERT INTO qub_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Abramga Neguevpita aywar pachacur-pachacur aywaran Bet-elman chayanancama. Chaypitana aywacuran ñaupata tiyashan partiman. Chayga caycan Bet-elpita Haiman aywajchömi. ");
INSERT INTO qub_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","Chay tiyashan partiga caran unay altarta pergashan cajmi. Chaychömi Tayta Diosta yapay aduraran. ");
INSERT INTO qub_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Abrampa subrinun Lotpis tiyunnöna rïcuyaran. Paypapis wäca, uysha, cabra, uywaynin runacunapis aypallana caran. ");
INSERT INTO qub_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Aypalla uywancuna captinmi ishcan juc pachallacho tiyananpäga guewa mana ayparannachu. ");
INSERT INTO qub_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Chaymi Abrampa uywa ricajnincunawan Lotpa uywa ricajnincuna guewa-janan pillyaj. Chay wichanga Cananeo runacunapis Ferez runacunapis chay particho tiyarcaycaranraj. ");
INSERT INTO qub_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Chaynöpami subrinun Lot-ta Abram niran: «Noganchëga famillyami canchïpis. Chaymi noganchëga ama rimanacushwanchu. Gampa uywayqui ricajpis ni nogapa uywä ricajpis ama pillyachunchu. ");
INSERT INTO qub_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Cay partiga may-may jäcojmi caycan. Chaymi shuyni-cama tiyashwan. Gam acray maygan läduman aywacunayquipäpis. Gam janapa aywacuptiquega noga urapa aywacushaj. Gam urapa aywacuptiquega noga janapa aywacushaj.» ");
INSERT INTO qub_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Chaura Lotga intërupa ricachacuran. Ricäriran Jordán mayu aywajpa Zoar marcacama. Chay ragran pampa aywajpa Edén werta cashannöraj achca yacuyoj caycämuran. Egiptucho tiyashanta cachaycushan-nirajraj caycämuran. (Chayno caycaran Sodoma siudäta Gomorra siudäta Tayta Dios manaraj illgächiptinmi.) ");
INSERT INTO qub_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Chaura Lotga acraran Jordán mayu aywaycashan caj ragran aywaj pampata. Chay tiyaycashan partipita Lotga inti yagamunan-läman aywacuran. Chaynöpami Abramwan Lotga juc-lächo juc-lächöna tiyacuran. ");
INSERT INTO qub_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Abramna jinan Canaán partillacho tiyacuran. Lotnami aywacuran chay ragran pampapa caycaj siudäcunaman. Sodoma siudäpa ñaupanchöna tiyaran. ");
INSERT INTO qub_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Sodomachöga llapanpis fiyu runacunalla tiyaran. Tayta Diosta rabyachishpan fiyupa juchallatana ruraran. ");
INSERT INTO qub_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Lot aywacushanpitana Tayta Diosga Abramta niran: «Canan caycashayquipita intërupa ricachacuy. ");
INSERT INTO qub_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Nogami goycushayqui llapan chay ricashayqui partita. Chay partiga imaycamapis canga gampami, gampita mirajcunapami. ");
INSERT INTO qub_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Gampita mirajcunaga ñuchu allpano yupaytapis mana atipaypaj mirananpämi camacächishaj. ");
INSERT INTO qub_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Chay ricashayquitaga aywar tumamunqui intëruta. Anchunta largunta ricamunqui. Ricapacamushayquitaga llapantami gamta goycushayquipaj.» ");
INSERT INTO qub_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Chayno niptin Abramga chay tiyaycashanpita juc-läman aywacuran llapanninta apacurcur. Chayno aywacur chayaran Mamrecho yöra caycaj ñaupanman. Chayga caycaran Hebrón siudäpa sercancho. Chaycho Abramga altarta pergaran Tayta Diosta adurananpaj. ");
INSERT INTO qub_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Chay wichan Sinar nasyunpa raynin caran Amrafel jutiyoj. Arioc jutiyojna caran Elasar nasyunpa raynin. Quedorlaomer jutiyojna caran Elam nasyunpa raynin. Tidal jutiyojna caran Goim nasyunpa raynin. ");
INSERT INTO qub_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","Chay raycunami guërracho caycaran cayno jutiyoj raycunawan: Sodomapa raynin Bera jutiyojwan, Gomorrapa raynin Birsa jutiyojwan, Admapa raynin Sinab jutiyojwan, Zeboimpa raynin Semeber jutiyojwan, Belapa rayninwanpis. Belapa jucaj jutin caran Zoar. ");
INSERT INTO qub_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Cay pichga caj raycunaga suldäruncunata shuntaran ragra pampacho caycaj Sidim partiman. Chay partiga caycaran Cachi Lamar caycashancho. ");
INSERT INTO qub_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Chay runacunataga ray Quedorlaomermi chunca ishcay (12) watana munaynincho charararan. Chunca quimsan (13) wata cajchönami ichanga pichgan raycuna contran jatariran. ");
INSERT INTO qub_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Watannin cajchöga Quedorlaomerwan caycaj raycunapis paywan aywaran Astarot Karnaim partiman. Chaychöna Refaí runacunata binsiran. Nircur Zuzi runacunatapis Hamcho binsiran. Emí runacunatapis binsiran Save-quiriataim particho. ");
INSERT INTO qub_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","Hor runacunatapis binsiran Seir jircacunacho. Waquintana gueshpiptin gatiran Parán particama. Chaypitaga chunyaj chaqui jircana caycaran. ");
INSERT INTO qub_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Chaypita cutimur Quedorlaomer paywan caycajcuna chayaran En-mispat partiman. Chaypa jucaj jutin caran Cades. Chay quinraychömi Amalec runacunatapis ushaypa wañuchiran. Chaypita päsar Hazezon-tamar particho tiyaj Amorreo runacunatapis ushaypa wañuchiran. ");
INSERT INTO qub_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Chaymi Sodomapa raynin, Gomorrapa raynin, Admapa raynin, Zeboimpa raynin, Belapa raynin (Belapa jucaj jutin caran Zoar) camaricuran Sidim ragra pampacho pillyananpaj. ");
INSERT INTO qub_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","Chaychöna pillyaran Elampa raynin Quedorlaomerwan, Goimpa raynin Tidalwan, Sinarpa raynin Amrafelwan, Elasarpa raynin Ariocwan. Chaynömi chay pichgan raycuna pillyaran chay chuscun caj raycunawan. ");
INSERT INTO qub_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Chay Sidim ragran pampa aywarajpaga aypalla caran breya cashan pösucuna. Sodoma, Gomorra suldärucuna pillyapita gueshpishanchöga yagaran breyayoj caycaj pösucunaman. Waquin cajnami ichanga puntacunaman gueshpiran. ");
INSERT INTO qub_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Pillyacho binsej chuscu raycunaga Gomorrapita Sodomapita llapan ima-aycantapis apacuran. ");
INSERT INTO qub_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Abrampa subrinun Lot tiyaycaran Sodomacho. Chaymi Lot-tapis prësu apacuran llapan ima-aycantawanpis. ");
INSERT INTO qub_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Juc runa chay pillyapita gueshpir aywacurmi willaran hebreo runa Abramta. Abram tiyaycaran Amorreo runa Mamrepa chacrancho yöracuna caycashan cajcho. Mamrega caran Escolpawan Anerpa wauguinmi. Paycunaga Abramwan imachöpis yanapänacunanpämi parlacusha carcaycaran. ");
INSERT INTO qub_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Subrinun Lot prësu caycashanta mayaycur Abramga shuntaran maquincho yurej uywaynincunata. Chaura paywan aywajpaj cajlla caran quimsa pachac chunca pusajnin (318) runacuna. Nircur shuntashan runacunawan Abramga Dan marcacama aywaran Lot-ta prësu apaj runacunapa guepanta. ");
INSERT INTO qub_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Abramga uywaynincunawan raquinacuran. Nircur chacaypa illajpita yaycapaycäriran chay prësu apaj runacunaman. Chaycho pillyar binsiptin chay runacunaga gueshpir aywacuran. Chaura gatiran Hoba marcacama. Chay marcaga Damasco siudäpita päsaychöna caycaran. ");
INSERT INTO qub_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Abramga raycuna llapan apashanta guechumuran. Lot-tapis, Lotpa ima-aycantapis cutichicamuran. Warmipis ollgupis prësu caycajcunata cutichimuran. ");
INSERT INTO qub_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Quedorlaomerta, paypa yanapajnin raycunata binsiycur Abram cutiycämuptin Sodomapa rayninpis aywar tariparan Save ragra pampaman. (Chay pampatami waquenga «Raypa pampan» nej.) ");
INSERT INTO qub_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Salempa raynin Melquisedecpis Abramwan tincoj aywaran. Payga munayniyoj Tayta Diospa cüranmi caran. Paymi tantatawan bïnuta gararan Abramta. ");
INSERT INTO qub_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Nircur bindisyunta goshpan cayno niran: «Abram, janaj pachatapis cay pachatapis camaj munayniyoj Tayta Dios bindisyunta goycushunqui ari. ");
INSERT INTO qub_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Chiquishojcunata munayniquiman churamoj janaj pachacho caycaj Tayta Diosga alabasha caycullächun ari.» Chaura Abrampis ima-aycatapis cutiycächimushanpita diesmuta raquircur Melquisedecta goycuran. ");
INSERT INTO qub_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Chaypitaga Sodomapa rayninpis Abramta niran: «Sodoma runacunataga cutiycachimay. Guepincunata ichanga llapanta apacuy.» ");
INSERT INTO qub_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Chayno niptin Abramga niran: «Janaj pachatapis cay pachatapis camaj Tayta Diospa jutinchömi nogaga jurashcä ");
INSERT INTO qub_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","gampataga ni juc jïlullatapis, ni llangui watullatapis mana apacunäpaj. Chaynöpami gamga mana ninquipächu ‹Nogapitami Abram rïcuyasha› nir. ");
INSERT INTO qub_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Quiquëpäga manami imatapis munächu. Uywaynëcuna micushallan cacuchun. Aywäshimaj Aner, Escol, Mamremi ichanga derëchunta apaconga.» ");
INSERT INTO qub_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Chaypita unayllataga Abramta Tayta Dios ribilar cayno niran: «Abram, ama manchacamaychu. Nogami gamtaga ima mana allicunapitapis chapaycä. Gamtaga ima-aycayquipis mas aypalla cananpämi yanapäshayqui.» ");
INSERT INTO qub_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Chayno niptin Abramga niran: «Tayta Dios, ¿imapänataj imäcuna mas aypalla cananpäpis yanapämanqui? Nogapaga manami wamrä canchu ni jucnayllapis. Wañucuptëga llapan ima-aycäwanpis quëdanga Damasco runa uywaycashä Eliezerchari. ");
INSERT INTO qub_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Manami yanapämashcanquichu wamrä cananpaj. Chaynöpami uywaynillä quëdanga llapan ima-aycäwanpis.» ");
INSERT INTO qub_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Chayno niptin Tayta Dios niran: «Manami. Chay runaga manami ima-aycayquiwanpis quëdangachu. Quiquiquipa wamrayquimi ima-aycayquiwanpis quëdangaga.» ");
INSERT INTO qub_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Chaypita Tayta Diosga Abramta jawaman pushaycur niran: «Syëlupa sumaj ricachacuy. Mä estrëllacunata yupayta atipanquichush. Chayno aypallami canga gampita mirajcunaga.» ");
INSERT INTO qub_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Chayno Tayta Dios nishanta Abramga riguiran. Chaypitami Tayta Diosga niran: «Cay runaga juchaynajnami caycan» nir. ");
INSERT INTO qub_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Abramta Tayta Dios niran: «Nogaga Caldeacho caycaj Ur marcapita jorgamushojniqui Tayta Diosmi caycä. Gamtaga jorgamurä cay partita goycunäpämi.» ");
INSERT INTO qub_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Chayno niptin Abramga niran: «Tayta Dios, ¿imanöpataj musyashaj rasunpa cay partita goycamänayquipaj cashanta?» ");
INSERT INTO qub_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Chaura Tayta Dios niran: «Cayman apapämay juc ternërata, juc cabrata, juc uyshata quimsa watayojta-cama. Apapämay juc palumatapis juc pushapa wampatapis.» ");
INSERT INTO qub_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Chaura Abramga apapämuran nishan uywacunata. Nircur pullanpa cuchurgäriran. Chayno rurarcur aychataga churaran wac-läman cay-läman. Äbicunata ichanga pullanpa mana cuchuranchu. ");
INSERT INTO qub_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Wisculcunaga urämuran chay aycha cajman. Chaura Abramnami michar manchaycächiran. ");
INSERT INTO qub_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Pacha chacaycaptinna Abramga fiyupa puñucäcuran. Chay öra puñuycashancho fiyupa manchariran. ");
INSERT INTO qub_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Chay örami Tayta Dios niran: «Gam musyay, gampita mirajcuna juc-lä nasyuncho tiyananpaj cashanta. Chaycho paycunaga goyangapaj uywayllami. Chuscu pachac (400) watayajmi ñacar goyangapaj juc casta runacunapa munaynincho. ");
INSERT INTO qub_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Ichanga ñacachej nasyun runacunata nogapis castigashäpämi. Chaypitaga gampa castayquicuna llojshicamongapaj librinami. Paycunaga aypallawanmi ima-aycanwanpis shacamongapaj. ");
INSERT INTO qub_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Gamga auquinyänayquicamami cawanquipaj. Alli wañuypanami wañucunquipäpis. Wañorga ñaupa wañoj castayquicunawan tincojnami aywacunquipaj. ");
INSERT INTO qub_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Gampita mirajcunaga chuscu pachac (400) wata juc-lächo tiyarcur yapay cayman cutimongapaj. Chay wichanpäga Amorreo runacunata juchanpita castiganä merësenganami.» ");
INSERT INTO qub_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Pacha chacashana caycaptin illajpita yurircuran shanshayoj cañalla goshtataycajwan nina ratataycajpis. Chayga aycha churaraycaj chaupinpa päsaran. ");
INSERT INTO qub_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Chay junajllami Abramwan Tayta Diosga conträtuta ruraran. Dios niran: «Cay partitaga Egipto mayupita Éufrates jatun mayucama gampita mirajcunatami noga goycushäpaj. ");
INSERT INTO qub_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","Chay partiga caycan canan Queni runacuna, Cenez runacuna, Cadmón runacuna, ");
INSERT INTO qub_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","Het runacuna, Ferez runacuna, Refaí runacuna, ");
INSERT INTO qub_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","Amorreo runacuna, Cananeo runacuna, Gerges runacuna, Jebús runacuna tiyarcaycashanmi.» ");
INSERT INTO qub_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Abrampaga warmin Saraicho wamran mana caranchu. Ichanga Saraipa uywaynin caran Agar jutiyoj warmi. Chay warmiga caran Egipto nasyunpita. ");
INSERT INTO qub_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Mana wamran captin Saraiga runan Abramta niran: «Noga wamrayoj canäta Tayta Diosga manami munashachu. Chaymi uywaynë Agarwan puñucuy ari. Paycho wamrayqui yuriptenga quiquëpa wamrätanömi uywacushaj» nir. Chaura Abramga auniran warmin Sarai nishanno. ");
INSERT INTO qub_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Chaymi Saraiga Abramta puñuchiran Egiptupita apamushan Agar warmiwan. Chay wichanga Canaancho tiyaycaran chunca watana. ");
INSERT INTO qub_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Abramwan puñurcur Agarga gueshyajna ricacuran. Gueshyaj caycashanta musyar Agarga patrönan Saraita manacajman churaytana gallaycuran. ");
INSERT INTO qub_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Chaymi Saraiga Abramta niran: «Agar manacajman churamänanpaj gammi juchayoj canqui. Nogaga cay warmiwan puñunayquipämi nirä. Ichanga canan pachayoj cashpanga nogata manacajman churaycäman. Imano captinpis Tayta Diosmi musyan mayganchi juchayoj cashanchïtapis.» ");
INSERT INTO qub_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Abramga Saraita niran: «Uywayniquega maquiquichömi caycan. Imatapis yarpashayquita ruray paytaga.» Chaura Saraiga Agarta amatar ñacachiytana gallaycuran. Chaymi Agarga gueshpir aywacuran. ");
INSERT INTO qub_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Chaymi Agartaga Tayta Diospa anjilnin yuriparan chunyaj pucyu ñaupancho. Chay pucyuga caycaran Shur partiman aywaj nänicho. ");
INSERT INTO qub_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Yuriparcur Tayta Diospa anjilnenga tapuran: «Saraipa uywaynin Agar ¿maypitataj shamunqui? ¿Maypataj aywaycanqui?» nir. Chaura Agar niran: «Patrönä Saraipitami gueshpicuycä.» ");
INSERT INTO qub_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Chaura Tayta Diospa anjilnin niran: «Cutiy patrönayqui Sarai cajman. Pay mandashushayquita wiyacur goyay.» ");
INSERT INTO qub_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Mastapis Tayta Diospa anjilnenga niran: «Gampita mirajcunaga aypallamanmi miranga. Yupaytapis mana atipaypämi canga. ");
INSERT INTO qub_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Gueshyaj caycashayqui wamrayqui ollgumi canga. Llaquicushayquita Tayta Dios wiyashanpitami jutinta churapanquipaj Ismael nir. ");
INSERT INTO qub_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","«Chay wamrayquega jirca chucaru bürrunömi cangapaj. «Payga llapanwanmi pillyangapaj. Paytapis wacpita caypitami magangapaj. Wauguincunawanpis chiquinacurmi goyangapaj.» ");
INSERT INTO qub_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Tayta Dioswan parlashanpita Agarga niran «Ricamaj Tayta Diostami ricashcä» nir. Chaypitami Diosta jutichaparan «Ricamaj Dios» nir. ");
INSERT INTO qub_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Chaypitami chay pösupa jutintapis churaparan «Ricamaj Cawaj Diospa pösun» nir. Chay pösuga caycan Cadespita Beredman aywaj nänichömi. ");
INSERT INTO qub_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Abram cajman cutir paypa churinta Agar gueshyacuran ollgu wamrata. Jutinta churaparan Ismael nir. ");
INSERT INTO qub_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Ismael yuriptin Abram caycaran pusaj chunca sojta watayoj. ");
INSERT INTO qub_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Abram isgun chunca isgun (99) watayoj caycaptin Tayta Dios yuriparcur niran: «Nogami cä munayniyoj Dios. Noga munashänölla goyay. Mana allicunata ama ruraychu. ");
INSERT INTO qub_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Chayno goyaptiqui gamwan conträtu rurashanchïtami cumlishaj. Nogami camacächishäpaj gampita mirajcuna aypallaman mirananpaj.» ");
INSERT INTO qub_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Chayno niptin Abramga juclla gongurpacuran urcunpis pampaman töpanancama. Tayta Diosnami sïguir willapaycaran: ");
INSERT INTO qub_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","«Conträtu rurashanchëga caynömi canga: Gampitaga achca nasyunpämi mirangapaj. ");
INSERT INTO qub_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Chaymi cananpitaga jutiquipis manana Abramnachu canga. Chaypa ruquin jutiqui canga Abrahamnami. Chaynöga jutiqui canga gampita mirajcuna achca nasyunpaj mirananpaj captinmi. ");
INSERT INTO qub_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Gampita mirajcunaga aypalla cananpämi camacächishaj. Chayno mirashpanmi cangapaj achca nasyunpaj aypaj. Gampita mirajcuna waquenga cangapaj raycunami. ");
INSERT INTO qub_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Gamwanpis gampita mirajcunawanpis conträtutami rurashaj. Chay conträtu rurashäga imaycamapis canga. Nogami cashaj gampa Diosniqui; chayno gampita mirajcunapapis. ");
INSERT INTO qub_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Canan tiyaycashayqui Canaán partitapis gamtami, gampita mirajcunatami imaycamapis goycushayqui. Gampita mirajcunapa Diosninpis nogallami cashäpaj.» ");
INSERT INTO qub_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Chaynöpis Abrahamta Dios niran: «Gamga conträtu rurashanchïta cumliy. Gampita mirajcunapis chaynölla cumlichun. ");
INSERT INTO qub_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Gamwan conträtuta rurashanchëga canga gampaj gampita mirajcunapäwanmi. Chaymi conträtu rurashanchïta cumlir cayno ruranqui: Gampita mirajcunaga llapan ollgu cajcuna señalacunqui. ");
INSERT INTO qub_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Gamcunaga llapaniqui ollgu cajcuna pengayniquipa puntanpa garanta cuchunqui. Chaymi canga conträtu rurashanchïta yarpänayquipaj. ");
INSERT INTO qub_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Cananpitaga llapan ollgu wamracunatapis chaynölla señalanqui yurishanpita pusaj junajyojllata. Maquiquicho yurej cajtapis, chayraj rantishayqui juc-lä nasyun uywaycunatapis señalanqui. ");
INSERT INTO qub_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Chaynömi llapayqui mana gongaypa señalacunqui conträtu rurashanchïta imaypis yarparänayquipaj. ");
INSERT INTO qub_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Señalacöni caj ollgoga gamcunacho tiyaycashanpita gargushami canga conträtu rurashäta mana cumlishanpita.» ");
INSERT INTO qub_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Mastapis Abrahamta Dios niran: «Cananpitaga warmiquipa jutin manami Sarainachu canga. Chaypa ruquenga Saranami jutin canga. ");
INSERT INTO qub_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Noga payta bindisyunta goshaj paycho wamrayqui cananpaj. Bindisyunta goptëmi payga cangapaj achca nasyun runacunapa mamanno. Paypita mirajcuna waquenga cangapaj nasyuncunapa rayninmi.» ");
INSERT INTO qub_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Niptin Abrahamga Diosta rispitashpan gongurpacur umpuran urcun pampaman töpanancama. Asicushpan shongullancho niran: «Auquin pachac (100) watayojna caycaptëga ¿imanöpanataj warmë gueshyaj ricaconga? Sarapis isgun chunca (90) watayojna caycan. Chacwanna caycaptenga ¿imanöpanataj wamran canga?» nir. ");
INSERT INTO qub_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Chaymi Diosta niran: «Tayta, chay bindisyunta wamrä Ismaelta goycuptiqui allimi canga.» ");
INSERT INTO qub_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Niptin Dios niran: «Manami Ismaelpächu niycä, juc wamrayqui warmiqui Saracho yurinanpaj cajpämi niycä. Chay wamrayquipa jutintaga churapanquipaj ‹Isaac› nirmi. Gamwan conträtu rurashätaga imaycamapis bälichishämi paypäpis paypita mirajcunapäpis. ");
INSERT INTO qub_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Ismaelpäpis gam nimashayquita wiyashcämi. Chaymi paytapis bindisyunta goshäpaj achcaman mirananpaj. Ismaelpa wamrancuna cangapaj chunca ishcay munayniyoj mandajcunami. Ismaelpita mirajcuna cangapaj jatun nasyunpaj aypajmi. ");
INSERT INTO qub_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Ichanga Isaacpämi bälichishaj gamwan conträtu rurashätaga. Isaactaga Sara gueshyacongapaj cananpita juc watatami.» ");
INSERT INTO qub_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Abrahamwan chayno parlayta usharcur Tayta Diosga aywacuran. ");
INSERT INTO qub_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Abrahamga chay junajllami wamran Ismaeltawan ushajpaj wasincho tiyaj ollgucunata Tayta Dios nishanno señalaran. Señalaran wasincho yurej uywaynincunata, rantishan uywaynincunatapis. ");
INSERT INTO qub_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Abrahamga señalacushan öra caycaran isgun chunca isgun (99) watayoj. ");
INSERT INTO qub_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","Wamran Ismaelpis caycaran chunca quimsa (13) watayoj. ");
INSERT INTO qub_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Chay junajlla Abrahamga wamran Ismaelwan ishcan señalacuran. ");
INSERT INTO qub_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","Chay junajllami señalacuran Abrahampa maquincho tiyaj ollgu cajcunapis. Señalacuran wasincho yurej uywaynincunapis, rantishan uywaynincunapis. ");
INSERT INTO qub_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Mamrepa chacran encina yöracuna caycaj ñaupancho Abraham tiyaycaran. Chaychömi inti pullan junaj fiyupa shanaptin Abrahamga toldun puncucho jamaraycaran. Chay örami Tayta Dios yuriparan. ");
INSERT INTO qub_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Abrahamga ricärishancho ricaran quimsaj runacuna ichirpaycajta. Ricärerga apurä jatariran jamachinanpaj. Rispitashpan urcunpis pampaman töpanancama ñaupanman gongurpacur ");
INSERT INTO qub_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","cayno niran: «Jamalläshun taytacuna. Ama aywacuyrächu ari. ");
INSERT INTO qub_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Yacuta aparaycachimushaj gamcuna chaquiquita mayllacunayquipaj. Nircur jamapärinqui yöra chaquin llantullacho. ");
INSERT INTO qub_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Ima allishi chayaycamunqui uywayniquita watucamaj. Tantatapis aparaycamushaj manaraj päsacur micupärinayquipaj.» Chayno niptin paycuna niran: «Allimi callanga.» ");
INSERT INTO qub_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Chaura Abrahamga toldun rurinman yaycuriycur Sarata niran: «Juclla ishcay chunca (20) quïlu alli caj jarinata chapuriycur tantata ruray.» ");
INSERT INTO qub_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Chaypita Abrahamga cörriylla aywaran wäcancuna caycashan cajman. Nircur werannin caj besërata acraran. Chaytana uywayninta entregaran. Chay runana pishtariycur apurä micuyta ruraran gorpan micunanpaj. ");
INSERT INTO qub_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Chay besëra aychata garashpanmi apaparan lëchita, quësuta, tantatapis. Apapashancunata paycuna micuran yöra chaquincho. Chayno micupacuptin Abrahamga shuyaraycaran imatapis munashan cajta apapänanpaj. ");
INSERT INTO qub_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Micuyta usharcärir Abrahamta tapuran: «¿Maychötaj caycan warmiqui Sara?» nir. Chaura Abraham niran: «Chay toldö rurichömi.» ");
INSERT INTO qub_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Chayno niptin juc niran: «Watan yapay cutimuptë warmiqui Saraga wawayojnami caycangapaj.» Abraham runacunawan parlashanta Saraga toldun puncu yaycurinacho wiyaparaycaran. ");
INSERT INTO qub_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Abrahamwan Saraga ishcanpis caran auquin chacwanna. Chacwanna captinmi Sarataga manana charejnachu quilla gueshyanpis. ");
INSERT INTO qub_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Chayno parlajta wiyar Saraga pacayllapa asicur cayno niran: «Ima alliraj caycunman wawä captin. Ichanga chacwannaga ¿imanöpanataj wawayoj cashaj runäpis auquinna caycaptenga?» nir. ");
INSERT INTO qub_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Chaymi Abrahamta Tayta Dios niran: «¿Imanirtaj asicusha Saraga ‹Chacwanna caycarga ¿rasunpachuraj wawata tarishaj?› nir? ");
INSERT INTO qub_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","¿Imallaga Tayta Diospaj sasa canchuraj? Watan cananno wichan rajacoj cutimuptë Saraga ollgu wawayojmi caycanga.» ");
INSERT INTO qub_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Saraga fiyupa manchacäcur «Nogaga manami asishcächu» niran. Niptin Dios niran: «Noga musyaycämi asicushayquita.» ");
INSERT INTO qub_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Chaypitana gorpan jatarcärir aywayta gallaycäriran Sodoma siudä-läman. Abrahamga despachashpan carucama iwal aywaran. ");
INSERT INTO qub_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Aywarcaycashancho Tayta Dios yarpachacuran cayno nir: «Imata ruranäpaj cashantapis Abrahamtaga ¿manachuraj willaycöman? ");
INSERT INTO qub_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Abrahampita mirajcunaga munayniyoj jatun nasyun cananpämi nishcäpis. Paytaga nishcä mundu intërucho caj nasyuncunata pay-raycu bindisyunta gonäpämi. ");
INSERT INTO qub_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Paytaga noga acrashcä wiyacamänanpaj wamrancunata, llapan famillyancunata yachachinanpämi, alli cajllata rasun cajllata rurananpämi. Abraham chayno ruraptenga conträtu rurashäta noga cumlishämi.» ");
INSERT INTO qub_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Chayno yarpachacurirmi Abrahamtaga Tayta Dios niran: «Gomorracho Sodomacho tiyaj runacunapäga fiyupami quijacamasha. Chaycho tiyaj runacuna mana awantaypänami juchata rurasha. ");
INSERT INTO qub_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Chaymi canan aywaycä quijacamar willamashanno rasunpa juchancuna cashanta musyanäpaj. Imano captinpis chayar-rämi musyashaj.» ");
INSERT INTO qub_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Ishcay caj gorpanga aywacuranna Sodomaman. Abrahammi Tayta Dioswan quëdacuran. ");
INSERT INTO qub_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Ñaupanman witiycushpan Abrahamga niran: «Juchayojcunataga ¿juchaynajcunatawan iwalchuraj usharinquiman? ");
INSERT INTO qub_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Juchaynaj runacunaga capaschari caycan pichga chuncapis (50) chay jatun siudächöga. ¿Chay pichga chunca (50) runacuna-raycu manachu cuyapanquiman chay siudächo tiyajcunataga? ");
INSERT INTO qub_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","¿Juchaynaj runacunatawan juchasapa runacunata tallucashata wañuchinquimanchuraj? Juchaynajcunataga juchayojcunatano manami wañuchinquimanchu. Chaytaga ruraycunquimanrächu. Mundu intërucho llapanpa juchaynaj jueznin caycarga ¿manachu alli arriglanquiman?» nir. ");
INSERT INTO qub_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Chaura Tayta Dios niran: «Juchaynaj runacunata pichga chuncata (50) Sodoma siudächo tarerga paycuna-raycu chay siudäta manami illgächishächu.» ");
INSERT INTO qub_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Chauraga yapay Abraham niran: «Yapay tapuptë ama rabyacuycuychu ari Tayta. Gamga canqui Tayta Diosmi. Nogaga cä runallami. ");
INSERT INTO qub_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Juchaynaj runacunaga capaschari pichgallapis pichga chuncapäga (50) pishin. Chaypis ¿illgächinquichuraj chay siudächo tiyaj llapan runacunata?» Niptin Dios niran: «Juchaynaj runacunata chuscu chunca pichganta (45) tarir manami illgächishächu.» ");
INSERT INTO qub_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Yapay Abraham niran: «Chaychöga capaschari caycan chuscu chuncallapis (40) juchaynaj runacunaga.» Niptin Dios niran: «Chuscu chunca (40) juchaynaj runacuna-raycu manami illgächishächu.» ");
INSERT INTO qub_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Yapay Abraham ruwacuran: «Tayta, yaparir-yaparir tapuptë ama rabyacuycuychu ari. Capaschari quimsa chuncallatapis (30) tarinquiman.» Chaura Dios niran: «Juchaynaj runacunata quimsa chuncallata (30) tarirpis manami illgächishächu.» ");
INSERT INTO qub_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Abraham yapay niran: «Manami lïsu caypitachu tapö, Tayta. Juchaynaj runacunata ishcay chuncallata (20) tarishpayquega ¿imataraj ruranqui?» Chaura Tayta Dios niran: «Ishcay chunca (20) juchaynaj runacuna-raycupis manami illgächishächu.» ");
INSERT INTO qub_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Abrahamga yapaypis niranraj: «Yaparir-yaparir tapuptë ama rabyacuycuychu ari Tayta. Cananllanami ruwacushayqui. Chuncalla juchaynaj captenga ¿imataraj ruranqui?» Niptin Tayta Dios niran: «Chay chunca juchaynaj runacuna-raycu chay siudäta manami illgächishächu.» ");
INSERT INTO qub_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Chayno Abrahamwan parlarcur Tayta Diosga aywacuran. Abrahampis tiyashan cajman cuticuran. ");
INSERT INTO qub_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Pacha chacaycaptinna Sodomaman chayaran ñaupacoj caj ishcay anjilcuna. Lotna jamaraycaran siudäman yaycurina sawan puncucho. Paycuna chayajta ricärir Lotga jatariran jamachinanpaj. Rispitar gongurpacur ñaupanman umpuran urcunpis pampaman töpanancama. ");
INSERT INTO qub_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","Nircur niran: «Taytacuna, wasëman aywaycushun ari pachacunayquipaj, chaquiquita mayllacunayquipaj. Wara tutanachari päsacunqui.» Chayno niptin chayajcunaga niran: «Manami. Cay cällillachömi waräshaj» nir. ");
INSERT INTO qub_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Chaypis Lotga yaparir-yaparir «aywacushun» niran wasincho pachacunanpaj. Chaura paycunaga aywaran Lotpa wasinman. Wasinchöna Lotga alli micuyta ruraran sënachinanpaj. Lebadüraynaj tantatapis ruraran gorpancunata garananpaj. ");
INSERT INTO qub_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Lotpa wasincho mayganpis manaraj puñuptin chay siudächo tiyaj llapan runacuna juntapaycäriran wamra-mösupita auquincama. ");
INSERT INTO qub_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Nircur Lot-ta gayapayta gallaycäriran: «¿Maytaj canan chacay wasiquiman pachacamoj runacuna? ¡Canan öra gargamuy! ¡Paycunawanmi cacuyta munä!» nir. ");
INSERT INTO qub_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Chayno gayapaptinmi Lotga paycunawan parlananpaj llojshiran puncuta sumaj wichgarcur. ");
INSERT INTO qub_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","Lot parlar niran: «Taytacuna, wasëman pachacamojcunataga ama mana allita ruraychu ari. ");
INSERT INTO qub_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Paycunapa ruquenga runa yatäni ishcay warmi wamräcunatami jorgapämushayqui munashayquita ruranayquipaj. Wasëman pachacamoj runacunata ichanga ama imatapis ruraychu.» ");
INSERT INTO qub_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Chayno niptinpis runacunaga nircaycaran: «¡Gamga washata ayway! Jäpa runa caycashpayquichi nogacunataga mandayta munamanqui. ¡Cananmi ichanga paycunata ruranäpaj cashäpitaga gamta mas piyur rurashayqui!» Chayno nir Lot-ta wacpita caypita magarcur wasi puncunman aywaran amiriycärinanpaj. ");
INSERT INTO qub_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Runacuna Lot-ta magaycaptin gorpancunaga guechuriycäriran. Nircur wasi ruriman yaycaraycachir puncuta sumaj wichgacurcuran. ");
INSERT INTO qub_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Jawacho caycaj runacunatana gaprayacäcachiran. Paycuna gaprayacäcuran wamra mösupita auquiscama. Gaprayasha carnaga wasipa puncunta ashir puriycällarna uticaranpis. ");
INSERT INTO qub_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Chaypita chay gorpancunaga Lot-ta niran: «¿Gampa famillyayquicuna masga caycho tiyaycanchu? Cay siudächo caycajtaga wamrayquicunata ollguta warmitapis, mashayquicunatapis llapanta pushacurcur carupa aywacuy. ");
INSERT INTO qub_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","Cay siudächo tiyaj runacunapaj achcaj fiyupa quijacusha captinmi cay siudätaga ushajpaj illgächej aywä. Chayno illgächinäpämi Tayta Dios cachamasha.» ");
INSERT INTO qub_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Chayno niptin Lotga aywaran mashan cananpaj caycajcunata willaj. Chayar paycunata niran: «Caypita juclla aywacushun. ¡Tayta Diosmi illgächej-aywan cay siudätaga!» Chayno niptin Lotpa mashan cananpaj caycajcunaga mana riguir asicuran. ");
INSERT INTO qub_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Pacha waraycaptinna Lot-taga anjilcuna niran: «¡Apuray! Mana wañuyta munarga caypita juclla aywacuy. Caypitaga pushacuy ishcan wamrayquitawan warmiquita. Carupa aywacuy cay siudächo tiyajcunata ushajpaj illgächiptë mana wañunayquipaj.» ");
INSERT INTO qub_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Lot mana llojshiyta atipaptin anjilcunaga maquinpita janchacurcur jorguran. Janchacurcur jorguran Lotpa warminta wamrancunatawan. Paycunataga siudäpita carucama pusharan Tayta Dios cuyapaptinmi. ");
INSERT INTO qub_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Siudäpita carumanna pusharcur jucaj anjil niran: «¡Apurä cörriyllapa aywacuy mana wañuyta munarga! Ama guepayquipaga ticraycamunquipischu. Cay guechwa pampachöga ni imanillarpis ama ichiycunquichu. Puntacunaman aywacuy mana wañunayquipaj.» ");
INSERT INTO qub_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Chayno niptin Lotga niran: «¡Quibä, taytacuna! ");
INSERT INTO qub_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Manacajlla caycaptëpis gamcunaga achcapitanami cuyapämashpayqui salbamashcanqui. Chay caru puntacunamanga noga manami aywämanchu. Lätaycachaycaptillächari nogatapis taripamar wañuycachimanga. ");
INSERT INTO qub_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Caypita sercallachömi caycan tacshalla marca. Chayllaman aywacushaj ari tayta. Chayno tacsha marcachöga manami wañushächu.» ");
INSERT INTO qub_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Chaura jucaj runa niran: «Nimashayquino chayllaman aywacuy. Manami illgächishächu nimashayqui marca-mallwataga. ");
INSERT INTO qub_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Chauraga juclla chayman aywacuy. Manaraj chayman chayaptiquega cay siudäta manami imatapis rurashärächu.» Tacshalla cashanpitami chay marcapa jutinta churaparan «Zoar» nir. ");
INSERT INTO qub_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Pacha warasha caycaptinna Lotga Zoarman chayaran. ");
INSERT INTO qub_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Chayraj Tayta Diosga tamyachimuran ratataycaj ninatawan asufrita Sodoma siudäman Gomorra siudäman. Chaynöpami ishcan siudächo nina ratariran. ");
INSERT INTO qub_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Chay ragran pampa aywajpaga llapan tiyajcunata ima-ayca jacha wiñamojtapis llapan uywacunatawanmi nina ruparan. ");
INSERT INTO qub_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Aywaycashancho Lotpa warmenga guepapa ticraycuran. Chaura jinallanchöna chiyacäcuran. Cachi rumiman ticracuriran. ");
INSERT INTO qub_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Chaypita warannin tuta Abrahamga aywaran Tayta Dioswan parlashan cajman. ");
INSERT INTO qub_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Ricäriran Sodomawan Gomorra caycashan ragran aywajpa. Ricaran intëru chay ragran aywajpaga jurnïllupitanöraj goshtay yana gontaynöraj jatariycämojta. ");
INSERT INTO qub_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Chaynömi Tayta Diosga ishcan siudäcunata illgächiran. Abraham ruwacushanta yarparmi chay illgächishan siudäpita Lot-taga jorguran. ");
INSERT INTO qub_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Chaypita Lotga fiyupa manchacuran Zoar marcallacho tiyayta. Chaymi chunyaj jircaman aywacuran ishcan warmi wamrancunata pushacurcur. Nircur machayllacho quimsan tiyacuran. ");
INSERT INTO qub_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Tiyarcaycashancho juc junaj Lotpa mayur caj wamranga shullcanta niran: «Papäninchëga auquinnami. Cay tiyashanchïcho manami ollgu runacuna canchu noganchi majachacaptinchi wamranchi cananpaj. ");
INSERT INTO qub_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Chaymi papäninchïta machächishun. Nircur paywan puñushun paypa wamranta charänanchïpaj». ");
INSERT INTO qub_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Parlacushan chacaylla papänintaga bïnuta upyachiran. Nircur mayur caj wamranga papäninwan puñuran. Papänenga mana mayaranchu imay öra wamran yaycapashantapis ni imay öra llojshishantapis. ");
INSERT INTO qub_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Warannin junaj mayurnenga shullcanta niran: «Ganyan chacay nogaga papäninchïwan puñushcänami. Chaymi yapay canan chacaypis papäninchïta machächishun gamna paywan puñunayquipaj. Chaynöpami paypa wamrallanta ishcanchïpis charäshun.» ");
INSERT INTO qub_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Chay chacay yapay papäninta upyachiran bïnuwan. Nircur shullca cajna papäninwan puñuran. Papänenga mana mayaranchu imay öra wamran yaycapashantapis ni imay öra llojshishantapis. ");
INSERT INTO qub_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Chaynöpami Lotpa ishcan wamrancuna papäninpata gueshyaj ricacuran. ");
INSERT INTO qub_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Mayur caj gueshyacuran ollgu wamrata. Jutinta churaparan «Moab» nir. Moabpita mirajmi caycan Moab runacunaga. ");
INSERT INTO qub_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Shullca cajpis gueshyacuran ollgu wamrata. Jutinta churaparan «Ben-amí» nir. Ben-amïpita mirajmi caycan Amón runacunaga. ");
INSERT INTO qub_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Tiyaycashan partipita Abrahampis aywacuran Néguev partiman. Chayman aywacur tiyaran Gerar siudächo. Chayga caycaran Cadespita Shurman aywanacho. ");
INSERT INTO qub_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Chaycho tiyashpanmi Abrahamga «Pañë» nej warmin Sarapaj. Chaymi Gerarpa raynin Abimelecga Sarata pushachiran warmin cananpaj. ");
INSERT INTO qub_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Pushachishan chacay Abimelecta suyñuynincho Dios willaparan: «Warmiquipaj pushachimushayqui warmiga runayojmi. Chaypitami gamga wañunqui.» ");
INSERT INTO qub_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Abimelecga Sarata manami yatapasharächu caran. Chaymi Abimelecga niran: «Tayta, ¿imanirtaj yarpanqui wañuchimayta, paywan ima juchatapis manaraj rurasha caycaptëga? ");
INSERT INTO qub_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Quiquin Abrahammi nimasha chay warmipäga pañin cashanta. Chaynömi warmipis nimasha paypäga turin cashanta. Chaymi nogaga llapantapis sumaj tapucachaycur pushachimushcä. Manami imatapis rurashcächu mana allitaga.» ");
INSERT INTO qub_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Chayno niptin Diosga suyñuynincho willaparan: «Au nogapis musyämi gam sumaj tapucushayquitaga. Chaynöpami chay warmiwan puñunayquitapis mana munashcächu, noga ricaycaptë juchata mana ruranayquipaj. ");
INSERT INTO qub_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Chaymi cananga chay runapa warminta cutiycachiy. Payga profëtami. Chaynöpami gam mana wañunayquipaj Abraham mañacamanga. Warminta mana cutichishpayquimi ichanga gampis llapan wasiquicho cajcunapis wañunquipaj.» ");
INSERT INTO qub_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Tutannin jatarcur Abimelecga gayaran llapan uywaynincunata. Nircur willaparan imano suyñushantapis. Wiyaycärir paycuna fiyupa manchariran. ");
INSERT INTO qub_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Chaypita Abimelecga gayachiran Abrahamta. Nircur niran: «¿Imanirtaj nogacunataga chayno llullapämashcanqui? ¿Imachötaj gamtaga rabyachishcä, nogata y mandashä runacunata fiyupa jatun juchata rurachimänayquipäga? Chaynöga manami pitapis ruranchïchu. ");
INSERT INTO qub_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Chayno ninayquipäga ¿imatataj yarpaycarayqui?» ");
INSERT INTO qub_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Chayno niptinmi Abrahampis niran: «Nogaga yarparä cay pachacho pipis Diosta mana adurashantami, warmë-casha wañuycachimänantami. ");
INSERT INTO qub_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Pañë caytaga rasunpa pañëmi. Payga papänëpa wamranmi, ichanga juc warmicho caj. Chaynöpami nogaga paywan majachacashcä. ");
INSERT INTO qub_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Papänëpa wasincho tiyaycaptë Dios ‹Aywacuy› nimaran. Chaymi warmëta nirä maymanpis chayaptëcuna ‹Payga turë› nimänanpaj.» ");
INSERT INTO qub_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Chaypita Abimelecga Abrahamta cutiycachiran warminta. Warminta cutichishpan Abrahamtaga goycuran uyshata, cabrata, wäcata, warmi ollgu uyway runacunatapis. ");
INSERT INTO qub_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Nircur Abrahamta niran: «Nogapa nasyunnëmi cayga. Gam munashayquita acray maygancho tiyanayquipäpis.» ");
INSERT INTO qub_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Saratana niran: «Turiquita goycushäga waranga guellaymi cuestan. Chaymi llapan ricashojcunapis gampaj nengapaj ‹ima mana allitapis manami rurashachu› nir. Chauraga manami pipis washayquita rimangapänachu.» ");
INSERT INTO qub_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","18","Sarata Abimelec pushachishanpitami Tayta Diosga camacächiran Abimelecpa wasincho caj warmicuna wawata mana tarinanpaj. Chaymi Abraham Diosta mañacuptin Abimelecpa uywaynin warmicunata allchacächiran llapan wawayoj cananpaj. Abimelectapis warmintinta allchacächiran. ");
INSERT INTO qub_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Tayta Dios yarpäriran Sarapaj nishanta. Chaymi Sarapaj aunishanta cumliran. ");
INSERT INTO qub_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Chaura Saraga gueshyaj ricacuran Abraham auquin caycaptinpis. Gueshyacuran ollgu wamrata. Tayta Dios imaypäpis nishan quillachömi Abrahampa wamran yuriran. ");
INSERT INTO qub_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Sara gueshyacuptin Abrahamga wamranpa jutinta churaparan «Isaac» nir. ");
INSERT INTO qub_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Yurishanpita pusaj junajta Abrahamga Dios nishannömi wamran Isaacta señalaran. ");
INSERT INTO qub_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Wamran Isaac yuriptin Abrahamga caycaran pachac (100) watayojna. ");
INSERT INTO qub_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Chaypita Sara cayno niran: «Cananga Diosmi cushicachimasha. Chayno llapan runacunapis wawayoj cashäta musyaycorga cushicongami. ");
INSERT INTO qub_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Noga wawayoj canätaga ni imanillarpis pipis yarpanmanrächu caran. Abraham auquin caycaptinpis paypa wamrantami gueshyacushcä» nir. ");
INSERT INTO qub_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Isaac jatullanna captin maman wasguiran. Wasguishan junaj Abrahamga cushicuywan jatun fistata ruraran. ");
INSERT INTO qub_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Saraga ricaran Abrahampa jucaj wamran Ismael Isaacta pucllacuycajta. Ismaelga caran Egipto warmi Agarpa wawanmi. ");
INSERT INTO qub_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Chayno pucllacuycajta ricaycurmi Saraga Abrahamta niran: «¡Chay uywaytaga wamrantawan garguriy! ¡Wamrä Isaacga chay wamrawan manami ima-aycanchïtapis raquipänacongachu!» ");
INSERT INTO qub_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Chayno niptin Abrahamga fiyupa llaquicuran Ismaelpis paypa wamran captin. ");
INSERT INTO qub_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Chaymi Abrahamtaga Tayta Dios niran: «Wamrayquipäwan uywayniquipäga ama llaquicuychu. Gamga Sara nishushayquino ruray. Aunishätaga wamrayqui Isaacpita miraj cajchömi cumlishaj. ");
INSERT INTO qub_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Uywayniquipa wamrantapis wamrayqui captinmi yanapäshäpaj aypallaman mirananpaj. Paypita mirajpis cangapaj jatun nasyunpaj aypajmi.» ");
INSERT INTO qub_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Chayno Dios nishan warannin, tutallana Abrahamga tantata, ordiwan yacutapis camarircur Agarta goycuran. Llapanta aparicurcuptin wamran Ismaeltawan ishcanta «aywacuy» nir despacharan. Agar mana musyaranchu maypa aywaytapis. Chayno aywacurmi puriycaran Beerseba chunyajpa. ");
INSERT INTO qub_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Upunanpaj apashan yacu ushacäcuptin wamran Ismaelta cachaycuran jacha chaquinman. ");
INSERT INTO qub_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Yacunayllapita wamran wañojta mana ricayta munar carullaman aywarcur jamacuycuran. Pay carullaman aywarcur jamacuycuptin wamranga wagayta gallaycuran. ");
INSERT INTO qub_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Wamra wagashanta Dios wiyaran. Chaymi Diospa anjilnenga syëlupita gayacuran Agarta cayno nishpan: «¿Imanaycanquitaj Agar? Ama llaquicuychu. Wamrayqui wagaycashantami Dios wiyasha. ");
INSERT INTO qub_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","¡Cutiy wamrayquiman! Janchacurcur pushacuy. Nogami yanapäshaj pay cawananpaj. Paypitami mirangapaj jatun nasyun cananpaj.» ");
INSERT INTO qub_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Chaura Dios camacächiptin Agarga ricchacurishancho ricaran pösucho yacu caycajta. Chaymi Agarga ordiman yacuta wiñarcur Ismaelta upuchiran. ");
INSERT INTO qub_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Wamrataga Dios yanaparan. Chunyajllachömi tiyacuran. Chunyajcho tiyar wamraga yachacuran lëchawan jirca animalcunata cäsayta. ");
INSERT INTO qub_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Paycuna tiyaran chunyaj Parán jutiyoj particho. Jatunyaptinnami Ismaeltaga maman Agar majacharan Egipto warmiwan. ");
INSERT INTO qub_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Chay wichan Abimelecga aywaran Abrahamwan parlaj. Suldäruncunapa mandajnin Ficolpis aywäshiran. Abimelecga Abrahamta niran: «Gamtaga llapan rurashayquichömi Dios yanapaycäshunqui. ");
INSERT INTO qub_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Chaymi canan öra Diospa jutincho juray nogatapis, wamräcunatapis, wamräcunapita mirajcunatapis mana engañamänayquipaj. Juray ari gampaj alli cashäno nogapäpis alli canayquipaj. Chayno alli caycunqui ari cay tiyaycashayqui nasyuncho caycaj runacunapäpis.» ");
INSERT INTO qub_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Chayno niptin Abraham niran: «Au, jurämi.» ");
INSERT INTO qub_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Nircur Abrahamga Abimelecta niran: «Uywayniquicunami uywaynëcunata yacu pösuta guechusha» nir. ");
INSERT INTO qub_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Chaura Abimelec niran: «Nogaga manami chayta musyashcärächu. Gampis manami imaypis willapämashcanquichu. Cananrämi nogaga chayta wiyarcöpis.» ");
INSERT INTO qub_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Chayno parlarmi Abrahamga Abimelecta goycuran uyshata, cabrata, wäcata. Chay junajmi ishcan juc conträtuta ruraran. ");
INSERT INTO qub_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Nircur Abrahamga uyshancunapita mas ganchis uyshata raquiran. ");
INSERT INTO qub_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Raquiptin Abimelec tapuran: «¿Imapätaj raquiycanqui chay ganchis uyshataga?» nir. ");
INSERT INTO qub_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Chaura Abraham niran: «Cay ganchis uyshatami gamta goycushayqui rasunpa cay yacu pösuta noga uchcushä musyacänanpaj.» ");
INSERT INTO qub_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Chaycho ishcan jurashanpitami chay partita jutichaparan «Beerseba» nir. ");
INSERT INTO qub_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Beersebacho conträtuta ruraycur Abimelecwan Ficolga cuticuran Filistea runacuna tiyashan partiman. ");
INSERT INTO qub_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Chay Beersebacho Abrahamga juc «tamarisco» jutiyoj yörata lantaran. Nircur imaycamapis cawaj Tayta Diosta aduraran. ");
INSERT INTO qub_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Abrahamga achca watami tiyaran Filistea runacuna tiyarcaycashancho. ");
INSERT INTO qub_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Chaypita achca watatanaga Abrahamta Dios musyapayta munaran. Chaymi Diosga gayaran «¡Abraham!» nir. Chaura Abrahamga niran: «Caychömi caycä» nir. ");
INSERT INTO qub_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Chaura Dios niran: «Japallan cuyay wamrayqui Isaacta pushacurcur ayway Moriah partiman. Chayman chayaptiquimi ricachishayqui maygan puntacho wamrayquita pishtarcur rupachinayquipäpis.» ");
INSERT INTO qub_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Chayno Dios nishan warannin tutaga tutalla jatarcur Abraham bürrunta carunacuran. Yantata camariran Dios nishanman apaycur chaycho wamranta rupachinanpaj. Camaricurcur aywacuran ishcay uywayninta wamranta pushacurcur. ");
INSERT INTO qub_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Quimsa junaj aywarcurna Abrahamga ricäriran carucho punta caycämojta. ");
INSERT INTO qub_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Chaura Abrahamga uywaynincunata niran: «Cayllacho gamcunaga quëdacuy. Bürrunchïtapis quëdachicuy. Tagaymanga nogallami cay wamrawan aywashaj chaycho Diosta aduranäpaj. Nircur cutimushäcuna.» ");
INSERT INTO qub_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Chayno nirmi Abrahamga rupachinanpaj caj yantata wamran Isaacta matancaparan. Abrahamnami ninata cuchilluta aparan. Apacarcärir aywacuran wamran ishcan. ");
INSERT INTO qub_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Caruta aywarcaycashancho Isaacga papänin Abrahamta niran: «Papä». Chaura Abrahamga niran: «¿Imatataj munanqui ïju?» Chaura Isaacga tapuran: «Ninatawan yantataga apaycanchïmi. ¿Maychötaj caycan uysha pishtananchïpäga?» ");
INSERT INTO qub_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Niptin papänin niran: «Ïju, uyshataga Diosmi tarichimäshun.» Chayno nerga ishcan aywarcaycaran. ");
INSERT INTO qub_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Dios nishan jircaman chayaycur Abrahamga altarta pergaran. Chayman yantatapis chojparan. Nircur wamran Isaacta mancurnarcurna yanta jananman churaran. ");
INSERT INTO qub_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Abraham cuchilluta aptarcur wamranta pishtariycunanpäna caycaran. ");
INSERT INTO qub_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Chaura Tayta Diospa anjilnin syëlupita gayacamuran: «¡Abraham! ¡Abraham!» nir. Chaura Abrahamga niran: «Imallaraj» nir. ");
INSERT INTO qub_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Niptin anjilga niran: «Wamrayquita ama imatapis ruraychu. Nogaga musyämi Diosta wiyacushayquita. Gamga jucnaylla wamrayquitapis manami ‹mana› nimashcanquichu.» ");
INSERT INTO qub_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Chayno niptin ricchacurishancho Abrahamga ricäriran juc carni shatacho auricasha caycajta. Chay carnitana altar jananman churarcur rupachiran wamranpa ruquin. ");
INSERT INTO qub_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Chaypitami Abrahamga chay puntata jutichaparan «Tayta Dios tarichicunan» nir. Chaypitami cananyaj rimay can cayno: «Puntachörämi Tayta Dios tarichicun» nir. ");
INSERT INTO qub_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Yapay Abrahamta Tayta Diospa anjilnin syëlupita gayacamuran. ");
INSERT INTO qub_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","Gayacamur niran: «Caynömi Tayta Dios nin: ‹Gamga noga nishäta imatapis ruranquimi. Japallan cuyay wamrayquitapis manami ñïgamashcanquichu. Chaypitami cananga jurashpä gamta në: ");
INSERT INTO qub_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","Sumajmi bindisyunta goshayqui. Gampita miräga cangapaj aypalla agushnömi, goyllarcunanömi. Paycunaga chiquejcunata llapantami binsengapaj. ");
INSERT INTO qub_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Paycuna-cashami mundu intërucho tiyaj runacunatapis bindisyunta goshaj noga nishäta gam wiyamashayquipita› nir.» ");
INSERT INTO qub_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Chaypitanaga Abraham cutiran uywaynincunata cachaycushan cajman. Nircur iwalna cuticuran tiyashan Beersebaman. ");
INSERT INTO qub_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Chaypita mas unayllataga Abraham mayaran wauguin Nacorpa warmin Milcacho wamrancuna achca cashanta. ");
INSERT INTO qub_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Guechpa wamranpa jutin caran Uz, chaypita shullcan Buz, nircur Kemuel, chaymi caran Arampa papänin. ");
INSERT INTO qub_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Nacorpaga maspis wamrancuna caran: Quesed, Hazo, Pildas, Jidlaf, Betuel. ");
INSERT INTO qub_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Betuelmi Rebecapa papänin caran. Paycunami caran Abrahampa wauguin Nacorpawan Milcapa pusaj wamrancuna. ");
INSERT INTO qub_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Nacorpaga caran wamrancuna uyway caj warmin Reúma jutiyojchöpis. Chay wamrancuna caran: Teba, Gaham, Tahas, Maaca. ");
INSERT INTO qub_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Sara cawaran pachac ishcay chuncan ganchis (127) watayoj canancama. ");
INSERT INTO qub_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Payga Quiriat-arbachömi wañuran. Mas jucaj jutin caran Hebrón. Chayga caycan Canaán particho. Sara wañuptin Abrahamga wagar lüturan. ");
INSERT INTO qub_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Warmin Sara wañusha caycaptin Abraham aywaran Het runacuna caycashan cajman. Chayaycur niran: ");
INSERT INTO qub_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","«Gamcunacho jäpa runa captëpis quiquëpaj cananpaj juc pachata ranticamay ari chayman warmëta pampanäpaj.» ");
INSERT INTO qub_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Chayno niptin Het runacunaga Abrahamta niran: ");
INSERT INTO qub_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","«Tayta, wiyaycallämay. Nogacunachöga gam canqui Dios acrashan mandajmi. Chaymi warmiquitaga pampay mas allinnin sepultüraman. Nogacunaga manami michäshayquichu mayninman pampaptiquipis.» ");
INSERT INTO qub_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Chayno niptin Abrahamga ichircur, chaycho caycaj llapan Het runacunata rispitashpan umpuran. ");
INSERT INTO qub_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","Nircur niran: «Taytacuna, caycho warmëta pampanäpaj rasunpa aunimashpayquega Zoharpa wamran Efronta ruwapaycamay ari ");
INSERT INTO qub_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","Macpelacho caycaj machayta ranticaycamänanpaj. Chay machay caycan chacrancunapa cantunchömi. Ayca cuestaptinpis chay machaypa risyuntaga pägashämi. Chayno rantiptërämi cay marcacho quiquëpa pampacunä canga.» ");
INSERT INTO qub_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Chay nishan öra Efronga chay runacunacho talluraycänaj. Chaymi Efronga marca-masincuna chaycho caycaj wiyananpaj, chayno chay siudä puncupa päsaycajcunapis wiyananpaj Abrahamta niran: ");
INSERT INTO qub_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","«Manami ranticöchu tayta. Sumaj wiyaycallämay. Nogaga goyllapami goycushayqui machayniyoj caycaj chacrata. Canan wiyaycämaj marca-masëcuna llapanmi musyanga gamta goycushäta. Chay machay uchcuman warmiquitaga pampaycuy ari.» ");
INSERT INTO qub_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Yapay Abrahamga chaycho caycaj runacunata rispitashpan umpuran. ");
INSERT INTO qub_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","Nircur llapan runacunapa ñaupancho Efronta niran: «Tayta, wiyaycamay ari. Chay chacrayquipaj pägashä guellaytaga chasquimay tayta. Chayrämi warmëtaga pampashaj.» ");
INSERT INTO qub_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Chaura Efrón niran: ");
INSERT INTO qub_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","«Wiyaycamay tayta. Chay chacrapa risyonga chuscu pachac (400) guellaymi cuestan. Ichanga chay guellayllapäga ¿imapätaj parlashunpis? Warmiquitaga chay machayman pampaycuy ari.» ");
INSERT INTO qub_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Het runacunapa ñaupancho Efrón nishanta pägananpaj auniran Abrahamga. Nircur jinan öra aunishan guellayta pësapashpan pägaran. Nigusyanticunapa balansanwan pësaparan. ");
INSERT INTO qub_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Chaynöpami Macpelacho Efronpa chacran caycäga Abrahampana ricacuran. Abrahampana caran machaynintin, chay chacracho caycaj yöracunapis. Chayga caycaran Mamre-läpita inti yagamunan caj-lächo. ");
INSERT INTO qub_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","Chay chacrata rantishanta ricaran chaycho caycaj Het runacunawan, siudä puncupa päsaj runacunapis. ");
INSERT INTO qub_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Chayno chacrata rantiycur-rämi Abrahamga warmin Sarata pamparan Macpelacho caycaj machayman, Mamreman inti yagamunan caj-lächo. Chay pachapa jucaj jutenga caran «Hebronmi». Chayga caycan Canaán partichömi. ");
INSERT INTO qub_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Chayno rantishanpitami chacraga machaynintin Abrahampana caran. Het runacuna ranticuycuran quiquin Abrahampis castancunapis chayman pampacunanpaj. ");
INSERT INTO qub_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Abraham caran auquinna. Paytaga llapan rurashancunachömi Tayta Dios bindisyunta goshpan yanaparan. ");
INSERT INTO qub_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Juc junajcho Abrahamga gayaran mas auquin caj uywayninta. Chay caj uywayninmi caran llapanninta ricaj. Paytami jurachishpan niran: «Maquiquita cay chancäman jatimuy. ");
INSERT INTO qub_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","Cay pachatapis syëlutapis camaj Tayta Diospa jutincho juray noga nishäta llapanta ruranayquipaj. Ama dëjanquichu cay tiyaycashä particho caycaj Cananea warmiwan wamrä Isaac majachacänantaga. ");
INSERT INTO qub_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Chaypa ruquenga gam aywanqui castäcuna tiyashan marcäman. Chaychömi castäcunapita juc jipashta ashimunqui wamräpa warminpaj.» ");
INSERT INTO qub_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Chaura uywaynenga niran: «Capas warmiga cay partiman shamuyta mana munangachu. Chauraga ¿Isaactachu pushäman warmipa marcanman?» ");
INSERT INTO qub_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Niptin Abraham niran: «Manami. Chaymanga wamräta manami pushanquichu. ");
INSERT INTO qub_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Papänëpa wasinpita jorgamaj syëlucho caycaj Tayta Diosmi, castäcunapa chacrancho goyaycajta cayman pushamashpan nimaran, cay tiyaycashanchi partita nogapa wamräcunata goycunanpaj. Paymi gampa ñaupayquita cachanga juc anjilninta. Chaymi gamga aywashayqui cajpita pushamunquipaj juc jipashta wamräpa warminpaj. ");
INSERT INTO qub_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Gamwan jipash shamuyta mana munaptin ichanga aunimashayquitapis mana cumlinquinachu. Wamrätami ichanga chayman ama pushanquichu.» ");
INSERT INTO qub_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Chayno niptin uywaynenga patrunnin Abrahampa chancanman maquinta jatiran. Nircur Diospa jutincho juraran patrunnin Abraham nishanta cumlinanpaj. ");
INSERT INTO qub_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Chaypita Abrahampa uywaynenga acraran patrunninpa ima-aycanpitapis mas alli cajta. Nircur chunca camëllucunawan cargacurcur aywacuran Mesopotamiacho Nacor tiyashan siudäman. ");
INSERT INTO qub_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Abrahampa uywaynin aywäga siudäpa ñaupancho caycaj yacu pösu ñaupanman chayaycur camëlluncunata jamachiran. Chay öraga tardina caran. Chay örami jipashcuna aywaj pösupita yacu apaj. ");
INSERT INTO qub_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Chaychömi Abrahampa uywaynenga Tayta Diosta mañacur cayno niran: «Patrunnë Abrahampa Tayta Diosnin, canan yanapämay ari noga yarpashä alli camacänanpaj. Chaynöpa patrunnë Abrahamta cuyapaycuy ari. ");
INSERT INTO qub_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Cay pösu ñaupallancho shuyaycäshaj jipashcuna yacuta apananpaj shamojta. ");
INSERT INTO qub_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Camacaycachiy ari tayta, patrunnëpa wamranpaj warmita tarinäpaj. Nogaga jipashta nishaj: ‹Puyñuyquipita yacuta upurcachimay jipash› nir. Chaura payna nimächun: ‹Upucurcuy ari. Camëlluyquicunatapis yacuta upuraycachishaj› nir. Chayno nimaj cajmi canga Isaacpa warminpaj acrashayqui jipash. Chaynöpami musyashaj patrunnë Abrahamta cuyapashayquita.» ");
INSERT INTO qub_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Abrahampa uywaynin manaräpis Diosta mañacuyta ushar ricäriran puyñun matancasha yacuman jipash aywaycämojta. Chay jipash caran Betuelpa wamran Rebeca. Betuelnami caran Nacorpawan Milcapa wamran. Nacorga caran Abrahampa wauguin. ");
INSERT INTO qub_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Rebecaga caran cuyayllapaj jipash. Payga pï runawanpis manarämi caranrächu. Yacu pösu cajman chayaycur puyñunman yacuta wishicurcur cuticuycaranna. ");
INSERT INTO qub_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Chaura Abrahampa uywaynenga cörrir tariparcur niran: «Puyñuyquipita yacuta upurcachimay jipash.» ");
INSERT INTO qub_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Chaura jipashga niran: «Upucurcuy ari.» Chayno nir puyñunta charipararan yacuta upunanpaj. ");
INSERT INTO qub_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Abrahampa uywaynin yacuta upuyta usharcuptin Rebecaga niran: «Camëlluyquicunatapis yacuta upuraycachishaj.» ");
INSERT INTO qub_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Chayno nirmi uywacunapa yacu upucunanman apurä tacshiriycur cutirir-cutirir ashtapämuran llapan camëllucuna upunanpaj. ");
INSERT INTO qub_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Abrahampa uywaynenga ricapaycaran upällalla mana imatapis niyllapa, mañacushanno Tayta Dios camacächishanta mana camacächishantapis musyananpaj. ");
INSERT INTO qub_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Camëllucuna yacu upuyta usharcuptin Abrahampa uywaynenga jipashpa senganman jatiparcuran gori surtïjata. Chay surtïjaga lasaran sojta grämuno. Chaynöpis maquinman jatiparan goripita ishcay brasalëtata. Chaycunaga lasaran pachac (100) grämuno. ");
INSERT INTO qub_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Nircur niran: «Willamay jipash: ¿pipa wamrantaj canqui? ¿Papäniquipa wasinchöga jäcunchu nogacuna pachacunäpaj?» ");
INSERT INTO qub_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Chayno niptin jipash niran: «Betuelpa wamranmi caycä. Payga Nacorpawan Milcapa wamranmi. ");
INSERT INTO qub_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Wasëcunachöga jäcuycanmi canan chacay gamcuna pachacunayquipaj. Ogshapis guewapis caycanmi camëlluyquicunapaj.» ");
INSERT INTO qub_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Chaura Abrahampa uywaynenga Tayta Diosta rispitashpan gongurpaycur alabaran ");
INSERT INTO qub_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","cayno nir: «Patrunnë Abrahampa Tayta Diosnenga alabasha cachun. Patrunnëtaga allimi yanapan. Chaymi castanmanpis chayachimasha.» ");
INSERT INTO qub_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Rebecaga cörriyllapa cuticuran yacuman aywajta ima päsashantapis mamanta willaj. ");
INSERT INTO qub_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","30","Rebecapa turin caran Labán. Paymi ricaran pañinpa sengancho gori surtïja jatiraycajta, brasalëtata maquincho jatiraycajta. Runa imata nishantapis mamanta willapaycajta wiyaran. Chaymi yacu pösu cajman cörriyllapa aywaran chay runawan tincunanpaj. Chay runataga pösu ñaupancho tariran camëlluncunawan caycajta. ");
INSERT INTO qub_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Labanga niran: «¡Tayta Dios yanapashan runa, wasëman aywaculläshun! ¿Imanöpataj cay jawallachöga puñunqui? Nogaga maynami jäcachipacushcä gam puñunayquipaj, chayno camëlluyquicunapäpis.» ");
INSERT INTO qub_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Chayno niptin Abrahampa uywaynenga Labanwan aywaran. Wasichöna Labanga camëllucunapita cargacunata pascaran. Nircur gararan. Yacutapis apapämuran Abrahampa uywaynin yan'guincunawan chaquincunata mayllacunanpaj. ");
INSERT INTO qub_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Chaypita micuyta micunanpaj churapaycuptin Abrahampa uywaynenga niran: «Nogaga manami micushärächu ninäpaj caycajta manaraj parlarga.» Chayno niptin Labán niran: «¡Parlamuy ari!» ");
INSERT INTO qub_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Chaura Abrahampa uywaynenga niran: «Nogaga cä Abrahampa uywayninmi. ");
INSERT INTO qub_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Paytaga Tayta Diosmi alli bindisyunta gosha. Paypaga aypallami mirasha uysha, wäca, camëllo, bürru. Warmi ollgu uywaynincunapis aypallami. Goripis guellaypis aypallami. ");
INSERT INTO qub_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Patrunnëpa warmin Sarapis chacwanna caycashanchörämi ollgu wamrata charasha. Paypaga japallanmi ollgu wamran. Chay wamrallantana patrunnëga llapan ima-aycantapis erensya goycusha. ");
INSERT INTO qub_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Patrunnëmi Tayta Diospa jutincho jurachimashpan cayno nimasha: ‹Ama dëjanquichu cay tiyaycashä particho caycaj Cananea warmiwan wamrä majachacänantaga. ");
INSERT INTO qub_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Chaypa ruquenga gam aywanqui noga yurishä partiman. Chay castäcunapita juc jipashta acramunqui wamräpa warminpaj› nir. ");
INSERT INTO qub_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","«Chaura noga nirä: ‹Capas warmiga cay partiman shamuyta mana munangachu› nir. ");
INSERT INTO qub_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","«Chaymi payga nimaran: ‹Nogaga imaypis Tayta Diospa maquinchömi purishcä. Chaymi payga gampa ñaupayquita cachanga juc anjilninta, alli purimunayquipaj, castäcuna cajpita wamräpaj warmita pushamunayquipaj. ");
INSERT INTO qub_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Famillyäcuna wamranta mana munashuptiquimi ichanga aunimashayquita cumlinayqui mana nistacanganachu› nir. ");
INSERT INTO qub_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","«Chaymi noga shamur canan chayamushcä yacu pösu ñaupanman. Chaychömi Tayta Diosta mañacur nishcä: ‹Patrunnë Abrahampa Tayta Diosnin, canan yanapämay ari noga yarpashä alli camacänanpaj. ");
INSERT INTO qub_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Cay pösu ñaupallancho shuyaycäshaj jipashcuna yacuta apananpaj shamojta. Camacaycachiy ari tayta, patrunnëpa wamranpaj warmita tarinäpaj. Nogaga jipashta nishaj: «Puyñuyquipita yacuta upurcachimay jipash» nir. ");
INSERT INTO qub_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","Chaura payna nimächun: «Upucurcuy ari. Camëlluyquicunatapis yacuta upuraycachishaj» nir. Chayno nimaj cajmi canga patrunnëpa wamranpa warminpaj acrashayqui jipash› nishpä. ");
INSERT INTO qub_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","«Chayno Diosta mañacuyta manaräpis usharmi ricärirä Rebeca puyñun matancasha aywaycämojta. Chaypitaga chayamusha yacu pösuman yacuta wishej. Chaura noga nirä: ‹Yacuta upurcachimay jipash.› ");
INSERT INTO qub_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","«Chaura payga matancaraycashan puyñunta jinan öra urarcachir nimaran: ‹Upucurcuy ari. Camëlluyquicunatapis upuraycachishaj› nir. Chaura nogaga yacuta upushcä. Chayno camëllöcunatapis upuchisha. ");
INSERT INTO qub_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","«Chaymi tapushcä: ‹¿Pipa wamrantaj canqui?› nir. Chaura payga nimasha: ‹Betuelpa wamranmi caycä. Payga Nacorpawan Milcapa wamranmi.› Chayno nimaptinmi nogaga senganman jatiparcurä juc surtïjata, maquinmanpis ishcay brasalëtacunata. ");
INSERT INTO qub_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Nircurna gongurpacuycur Tayta Diosta rispitar alabarä cayno nir: ‹Patrunnë Abrahampa Tayta Diosnin, gam alli nänipami pushamashcanqui patrunnëpa wamranpaj famillyanpita warmita ashinäpaj› nir. ");
INSERT INTO qub_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Cananga gamcunana nimay ari, patrunnëpaj alli u mana alli canayquipaj cashantapis. ¿Wamrayquita gomanquichu u manachu? Willaycamaptiquega noganami musyacushaj maypita ashiytapis.» ");
INSERT INTO qub_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Chaura Labanwan Betuelga niran: «Llapan nimashayquicunataga Tayta Diosmi camacächisha. Chaymi gamtaga auniyta ni ‹mana› niytapis mana puydëcunachu. ");
INSERT INTO qub_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Rebecataga pushacuy ari. Rebecaga Tayta Dios camacächishanno cachun patrunniquipa wamranpa warmin.» ");
INSERT INTO qub_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Chayno nejta wiyaycur Abrahampa uywaynenga Tayta Diosta agradësicushpan umpuran urcunpis pampaman töpanancama. ");
INSERT INTO qub_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Nircur apashancunata jorguran achca castata goripita, guellaypita rurashata, chayno röpacunatapis. Chaycunata goycuran Rebecata. Jipashpa turintapis mamantapis bälej cösacunata goycuran. ");
INSERT INTO qub_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Chaycunata chasquircuptinraj Abrahampa uywaynenga yan'guincunawan micuran upuran. Nircur chaycho wararan. Warannin tuta Abrahampa uywaynenga niran: «Cananga patrunnëpa wasinman cuticushäna.» ");
INSERT INTO qub_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Chayno niptin Rebecapa turinwan mamanga niran: «Jipashga nogacunawan goyapärichunraj chunca junajllapis. Chaypitami ichanga pushacunquina.» ");
INSERT INTO qub_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Chayno niptin Abrahampa uywaynenga niran: «Tayta Dios yanapämar llapantapis allina camacächisha caycaptenga amana goyächimaynachu. Patrunnëpa wasinman cuticunäpaj despachaycallämayna ari.» ");
INSERT INTO qub_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Chaura paycuna niran: «Jipashtaraj tapushun. Pay mä ima nengashi.» ");
INSERT INTO qub_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Chayno nir gayaran Rebecata. Nircur tapuran: «¿Cay runawan aywanquichu?» nir. Chaura pay niran: «Au, aywashaj.» ");
INSERT INTO qub_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Chaura Rebecaga mamanno uywaj warmiwan ishcan aywacuran. Abrahampa uywayninwan shamoj runacunapis iwalna aywacuran. ");
INSERT INTO qub_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Famillyanga Rebecata bindisyunta gor cayno niran: «Rebeca, wawayquicuna, willcayquicuna, chayno paycunapita mirajcunapis aypallaman mirar waranganpa-waranganpa caycullächun. Gampita mirajcunaga chiquejcunatapis llapanta binsichun.» ");
INSERT INTO qub_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Chaypita Rebeca warmi uywaynincunawan camëlluta muntacurcur Abrahampa uywayninpa guepanpa aywacuran. Chaynömi Abrahampa uywaynenga Rebecata pusharan patrunninpa wamranpa warminpaj. ");
INSERT INTO qub_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Isaacga tiyaycaran Néguev particho. Chaymi payga Ricamaj Cawaj Diospa Pösun jutiyoj cajpa aywashanpita cutiycämuran. ");
INSERT INTO qub_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Payga pacha chacaycaptinna puricachaj aywasha caran. Ricchacurishancho ricäriran camëllucuna awaycämojta. ");
INSERT INTO qub_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Chayno Rebecapis ricäriran. Isaacta ricärir camëllupita uraran. ");
INSERT INTO qub_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","Urarcur tapuran Abrahampa uywayninta: «¿Pitaj tagay runa noganchi cajman aywaycämoj?» nir. Chaura Abrahampa uywaynenga niran: «Paymi patrunnë.» Chayno niptinmi Rebecaga shucutanwan cäranta chapacurcuran. ");
INSERT INTO qub_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Uywaynenga Isaacta willaparan imano purimushantapis. ");
INSERT INTO qub_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Chaypitana Isaacga Rebecata pusharan mamanpa toldunman. Nircur paywan majachacaran. Isaacga Rebecata fiyupa cuyaran. Chaynöpami maman wañushanpitapis mana llaquicurannachu. ");
INSERT INTO qub_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Abrahamga jucwanpis yapapacuranraj. Chay warmipami jutin caran Cetura. ");
INSERT INTO qub_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Chay warmicho caj wamrancuna caran: Zimram, Jocsán, Medán, Madián, Isbac, Shúa. ");
INSERT INTO qub_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Jocsanpa wamrancuna caran Sebawan Dedán. Dedanpita mirajcuna caran Asur, Letus, Leum runacuna. ");
INSERT INTO qub_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Madianpana wamrancuna caran: Efa, Efer, Hanoc, Abida, Elda. Llapan chaycunaga caran Abrahampa warmin Ceturapita mirajcunalla. ");
INSERT INTO qub_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Abrahampa llapan ima-aycanpis caran Isaacllapämi. ");
INSERT INTO qub_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Juc warmincunacho caj wamrancunataga wallca wallcalla ima-aycantapis raquiparan. Nircur Abrahamga waquin caj wamrancunata Isaacpita raquiran. Raquirmi shuyni tiyacunanpaj despacharan inti yagamunan caj-läman. ");
INSERT INTO qub_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Abrahamga cawaran pachac ganchis chunca pichgan (175) watayoj canancama. ");
INSERT INTO qub_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Payga wañucur ñaupa wañoj castancunawan tincojna aywacuran. Pasaypa auquinna cashpan alli wañuypana wañucuranpis. ");
INSERT INTO qub_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Isaacwan Ismael ishcan wamrancuna pampaycachiran Macpelacho caycaj machayman. Chayga caycan Mamrepita inti yagamunan caj-lächo, Het runa Zoharpa wamran Efronpa chacrancho. ");
INSERT INTO qub_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Chay chacraga caran Het runapita Abraham rantishanmi. Abrahamga pampacuran warmin Sara pamparaycashan lädunman. ");
INSERT INTO qub_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Abraham wañushanpitaga Isaactana Dios bindisyunta goran. Paymi tiyacuran Ricamaj Cawaj Diospa Pösun jutiyojpa ñaupancho. ");
INSERT INTO qub_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Sarapa uywaynin Agarga Egipto warmimi caran. Paychömi caran Abrahampa wamran Ismael. ");
INSERT INTO qub_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Ismaelpa wamrancunami mayurpita shullcacama caran cayno: Nebaiot, chaypita Cedar, Adbeel, Mibsam, ");
INSERT INTO qub_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Misma, Duma, Massa, ");
INSERT INTO qub_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Hadar, Temá, Jetur, Nafis, Cedema. ");
INSERT INTO qub_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Chaycunami caran Ismaelpa chunca ishcay (12) wamrancuna. Paycunaga caran quiquin casta mirajcunacho munayniyoj mandaj. Chay mandajcunapa jutincuna cashannöllami trïbuncunapapis marcancunapapis jutin caran. ");
INSERT INTO qub_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Ismael wañuran pachac quimsa chuncan ganchis (137) watayoj caycashancho. Wañucur paypis ñaupa wañoj castancunawan tincojna aywacuran. ");
INSERT INTO qub_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Ismaelpita mirajcunami tiyaran Havila partipita Shur particama, Egipto nasyunpa chimpan Asiriaman aywanacama. Wauguincunawan chiquinacuycarpis Ismaelcunaga chaycho tiyacuran. ");
INSERT INTO qub_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Caypitami isquirbiraycan Abrahampa wamran Isaacpita mirajcunapa willapan: ");
INSERT INTO qub_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Rebecawan majachacashan öra Isaacga caycaran chuscu chunca (40) watayoj. Betuelpa wamranmi caran Rebecaga. Y Labanpana pañin caran. Paycunaga Aram runacunami caran. Padan-aram partichömi tiyaran. ");
INSERT INTO qub_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Rebecaga wamrata mana tariranchu. Chaymi Isaacga Tayta Diosta mañacuran warmin wawayoj cananpaj. Tayta Dios wiyaran Isaac ruwacushanta. Chaynöpami Rebecaga gueshyaj ricacuran. ");
INSERT INTO qub_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Gueshyaj captin millish cashpan tacanacur pachanta fiyupa nanächiran. Chaymi Rebecaga yarpachacuran «Cayno captenga mijur wañucöman» nir. Chaymi imanir chayno ñacashantapis Tayta Diosta tapucuran. ");
INSERT INTO qub_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Tapucuptin Tayta Dios niran: «Gampa pachayquichöga caycan ishcay nasyunpämi. Paycunaga manaräpis yurillarnami shuyni-shuyni cayta munaycan. Jucajmi mas munayniyoj canga jucajpitaga. Mayurnin cajmi canga shullcanpa munaynincho.» ");
INSERT INTO qub_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Rebeca gueshyacunan junaj chayamuptin gueshyacuran millishta. ");
INSERT INTO qub_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Rimëru yurej cajmi caran cuyayllapaj puca ajcha, intëru cuerpunpis mishwa juntasha. Paytami jutinta churaparan Esaú nishpan. ");
INSERT INTO qub_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Esaüpa chaqui-talunninta charicusha guepantana yuriran wauguin. Chayno yurishanpitami jutinta churaparan Jacob nir. Rebeca gueshyacuptin Isaac caycaran sojta chunca (60) watayoj. ");
INSERT INTO qub_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Chaypita wamrancunaga jatunyaranna. Jatun carna Esaüga jircapa puriyta mäñacuran, jirca animalcunata chariyta. Jacobmi ichanga toldullancho allilla goyäcoj caran. ");
INSERT INTO qub_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Isaacga masmi cuyaran Esaüta jirca animalcuna charimushancunata micushpan. Rebecana cuyaran Jacobta. ");
INSERT INTO qub_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Juc junaj Jacob yanucuycaptin Esaüga jircapa aywashanpita fiyupa uticasha chayamuran. ");
INSERT INTO qub_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Chayno chayamur wauguinta niran: «Chay puca micuy rurashayquita mañacushayqui. Fiyupami yargaycä. Garaycamay ari» nir. (Chaypitami Esaütaga Edom ninpis.) ");
INSERT INTO qub_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Niptin Jacobga niran: «Garanäpäga mayur cay derëchuyquiwan canan öra rucashun.» ");
INSERT INTO qub_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Chayno Jacob niptin Esaú niran: «Canan noga yargaypita caycashä öra manami imapäpis bälimanchu mayur cay derëchöga.» ");
INSERT INTO qub_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Chaura Jacobga niran: «Canan öra Diospa jutincho juray guechpa cay derëchuyquiwan rucanapaj.» Chayno niptin Esaüga aunishpan juraran guechpa cay derëchunta chay micuywan rucananpaj. ");
INSERT INTO qub_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Rasunpa aunircuptin Jacobga gararan landrïjas pushpu picanti rurashanta y tantatapis. Micuyta usharcur Esaüga upällalla aywacuran. Chaynömi Esaüga mayur cay derëchunpaj imatapis mana gocuranchu. ");
INSERT INTO qub_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Chay wichan Isaac tiyaycashan particho fiyupa muchuy caran. Abraham cawaycashan wichan muchuy cashanpitaga mas fiyupami caran. Chaynöpami Isaacga aywacuran Gerar siudäman. Gerarga caran Filistea runacunapa siudäninmi. Paycunapa raynin caycaran Abimelec. ");
INSERT INTO qub_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Chaychömi Isaacta yuriparcur Tayta Dios niran: «Ama aywaychu Egiptumanga. Gamga tiyacuy maychöpis noga nishallächo. ");
INSERT INTO qub_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Cananga cayllachöraj tiyacuycay. Nogaga gamwanmi caycäshaj. Bindisyuntapis goshayquipaj. Gamta y gampita mirajcunatami cay partitaga goycushäpaj. Chaynöpami cumlishaj papäniqui Abrahamta aunishäta. ");
INSERT INTO qub_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Nogami gampita mirajcunata yanapäshäpaj goyllarcunanöpis yupayta mana atipaypaj mirananpaj. Paycunatami cay particunataga goycushäpaj. Paycuna-raycumi mundu intërucho tiyaj runacunatapis bindisyunta goshaj. ");
INSERT INTO qub_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Chayno canga Abraham wiyacamashanpitami, mandamintöcunata, laynëcunata, yachachishäcunata cumlishanpitami.» ");
INSERT INTO qub_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Chaymi Isaacga Gerarcho tiyacuran. ");
INSERT INTO qub_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Chaycho tiyaj runacunaga Rebecapaj tapupäcuran. Rebeca cuyayllapaj captinmi Isaacga yarparan warmin-rayculla runacuna wañuycachinanta. Chaymi mana willacuranchu Rebeca warmin cashanta. Rasun cajta ninanpa ruquin «Pañëmi» niran. ");
INSERT INTO qub_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Chayllacho unaycama tiyaran. Chaypita juc junaj Abimelec bentänanpa ricchacuycashancho ricaran Isaacga warmin Rebecata cuyaycämojta. ");
INSERT INTO qub_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Chayno ricaycurmi Abimelecga Isaacta gayaycachir tapuran: «Payga warmiquimi ¿au? ¿Imanirtaj ‹pañëmi› nirayquega?» Chaymi Isaac niran: «Nogaga yarparä pay-raycu runa wañuycachimänantami.» ");
INSERT INTO qub_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Chayno niptin Abimelecga niran: «¿Imanirtaj chaynöga nogacunata llullapämashcanqui? Chaynöpitachi cay marca runacunaga warmiquiwan puñucuycunmanpis caran. Chaynöpaga nogacunata juchata rurachimanquimanchari caran.» ");
INSERT INTO qub_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Chaypitana Abimelecga munaynincho caj runacunata willachiran cayno nir: «Cay runata u warminta pipis yatapaj cäga wañuchicangami.» ");
INSERT INTO qub_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Chay wata Isaacga chay particho micuycunata murupacuran. Tayta Dios bindisyunninta churaptinmi shuntaytapis mana atipänancama micuy wayuran. ");
INSERT INTO qub_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Chaynöpami payga fiyupa rïcuyaran. Chayno ima-aycanpis aypallana caran. ");
INSERT INTO qub_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Uywancunapis uysha, cabra, wäca aypallaman miraran. Paypaga uyway runacunapis aypallana caran. Chaymi Filistea runacunaga Isaacta chiquicarcäriranna. ");
INSERT INTO qub_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Chayno chiquirmi Abraham cawashan wichan uywaynincuna pösucunata uchcushanmanpis Filistea runacunaga allpata cutichipaycäriran. ");
INSERT INTO qub_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Chaypitanaga Abimelecpis Isaacta niran: «Canan gamga nogacunapita mas fiyupanami ima-aycayojpis canqui. Chaymi caypitaga aywacuyna.» ");
INSERT INTO qub_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Chayno niptin Isaac aywacuran. Chayaran Gerar guechwa pampaman. Chaychöna tiyacuran. ");
INSERT INTO qub_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Chayman chayaycur Isaacga papänin cawaycar-raj uchcuchishan pösucunata pichachiran. Chay pösucunataga Filistea runacunami pamparpusha caran. Chaypita Isaacpis chay pösucunapa jutinta churaparan papänin churapashan juticunallata. ");
INSERT INTO qub_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Chay guechwa pampacho juc cuti Isaacpa uywaynincuna ojtircaycaran juc pösupaj. Pösupaj ojtircaycashancho tariran yacu pashtaycämojta. ");
INSERT INTO qub_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Chaymi Gerar pampacho uyshancunata michejcunaga rimanacuran Isaacpa uyshëruncunawan. «Chay yacuga nogapami» nishpan guechunacuran. Chaypitami Isaacga chay pösuta jutichaparan «Pillya» nishpan, chay pösu cajcho pillyasha captin. ");
INSERT INTO qub_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Chaypitapis yapay Isaacpa uywaynincunaga juc pösuta uchcuran. Chaychöpis yapay rimanacuran. Chaymi chay pösupa jutintapis Isaacga churaparan «Chiquinacuy» nishpan. ");
INSERT INTO qub_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Chaura Isaacga chay tiyaycashanpita caruman aywacuran. Chaychöna yapay pösuta uchcuchiran. Chay pösupaj mana piwanpis rimanacuptinna jutinta churaparan Rehobot nishpan. Chaymi niran: «Cananga Tayta Dios cayman churamashcanchi allilla goyäcur mirananchïpämi.» ");
INSERT INTO qub_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Chaycho tiyaycashanpita Isaac aywacuran Beersebaman. ");
INSERT INTO qub_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Chay chacay Tayta Dios yuriparcur niran: «Nogami caycä papäniqui Abrahampa Diosnin. Nogaga gamwanmi caycä. Chaymi ama manchacuychu. Sirbimajnë Abraham-raycumi gamtapis bindisyunta goshayqui. Chaymi gampita mirajcunapis aypallaman mirananpaj yanapäshaj.» ");
INSERT INTO qub_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Chaura Isaacga chaycho juc altarta rurarcur Tayta Diosta aduraran. Chaypitaga chaychöna tiyacuran. Uywaynincunana juc pösuta uchcuran. ");
INSERT INTO qub_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Juc junajcho Abimelec shamuran Gerarpita-pacha Isaacwan parlananpaj. Abimelecwan shamuran tantiyachejnin mayur runa Ahuzatpis. Chayno shamuran suldäruncunapa mandajnin Ficolpis. ");
INSERT INTO qub_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Chayaptinmi Isaacga niran: «Marcayquipitapis gargarcamar, ricaytapis mana munarcamarga ¿imamantaj cananga shamushcanqui?» ");
INSERT INTO qub_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Chayno niptin paycuna niran: «Nogacunaga tantiyacushcä gamwan Tayta Dios caycashantami. Chaymi yarpachacushcäcuna gamwan conträtuta rurananchïpaj. Conträtutaga caynömi rurashun: ");
INSERT INTO qub_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","Gamga ama ima mana allitapis ruramanquichu. Nogacunapis manami gamtaga imatapis rurashcächu. Chaypa ruquenga allimi goyaranchi. Gamga allillami llojshicamurayquipis. Cananpis Tayta Diosmi bindisyunta goycäshunqui.» ");
INSERT INTO qub_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Chayno niptin Isaacga achca micuyta rurachiran. Nircur paycunawan micuran upuran. ");
INSERT INTO qub_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Warannin tutaga tutallana conträtuta rurar ishcan juraran. Chaypita Abimelecga aywashan runacunawan cuticuran. Isaacpis alli despacharan. ");
INSERT INTO qub_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Chay junajlla Isaacpa uywaynincuna chayamuran willacoj «Pösuta uchcurcaycashächo yacuta tarishcä» nir. ");
INSERT INTO qub_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Chaymi Isaacga chay pösupa jutinta churaparan «Seba» nishpan. Chaypitami chay siudäpa jutenga caycan Beerseba. ");
INSERT INTO qub_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Esaú chuscu chunca (40) watayoj caycashpan majachacaran Beeri jutiyoj runapa wamran Juditwan. Chaypita yapaypis majachacaran Elón jutiyoj runapa wamran Basematwan. Paycunaga Het nasyun runacunami caran. ");
INSERT INTO qub_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Esaüpa ishcan warmincunami Isaactawan Rebecata pasaypa rabyachiran. ");
INSERT INTO qub_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Auquinna captinmi Isaacpa ñawin mana ricacurannachu. Chaymi juc junajcho mayur caj wamranta «Esaú» nir gayaran. Chaura Esaüga niran: «¿Ima papä?» ");
INSERT INTO qub_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Chaura Isaacga wamranta niran: «Ïju, pasaypa auquinnami caycä. Cayno caycashpäga waranachari wañucushäpis. ");
INSERT INTO qub_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Chaymi nogaga munä lëchayquiwan jirca animal charej aywanayquita. ");
INSERT INTO qub_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Animalta chariraycamorga noga yachashä micuyta rurapämanqui. Micuyta rurariycur apamunqui micunäpaj. Chaynöpami cawashäyaj bindisyunta goshayqui.» ");
INSERT INTO qub_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Isaac wamran Esaüta imata nishallantapis maman Rebecaga wiyaran. Chaura Esaüga papänin nishanno animal ashej jircapa aywacuran. ");
INSERT INTO qub_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Chaycama Rebecaga wamran Jacobta niran: «Ïju, sumaj wiyamay. Wauguiqui Esaüta papäniqui cayno niycajtami wiyashcä: ");
INSERT INTO qub_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","‹Jircapa aywar ima animal-llatapis chariraycamuy. Nircur micuyta ruramunqui noga micunäpaj. Micucurcurnami cawashäyaj Tayta Diospa bindisyunninta goshayqui.› ");
INSERT INTO qub_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Canan gamga ïju sumaj wiyamay imata nishätapis. ");
INSERT INTO qub_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Gam aywariycuy uywanchïcuna caycashan cajman. Nircur chaypita apamunqui mas allinnin ishcay cabra-mallwacunata. Chay cabra-mallwapitana papäniqui yachashan micuyta noga rurashaj. ");
INSERT INTO qub_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Chaura gamnami apapanquipaj papäniqui micunanpaj. Chaynöpami manaraj wañucushpan gamtana bindisyunta goshunquipaj.» ");
INSERT INTO qub_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Chayno niptin Jacobga mamanta niran: «Ichanga wauguë Esaú pasaypa shaprasapami. Nogaga manami paynöchu cä. ");
INSERT INTO qub_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Chaymi papänë yatamarga rejsimanga. Rejsimashpanga noga engañaycashäta musyanga. Chauraga bindisyunta gomänanpa ruquin maldisyunamangami.» ");
INSERT INTO qub_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Chayno niptin maman niran: «Ïju, maldisyunta papäniqui goshuptiquega nogata chayamächun. Gamga noga nishäta wiyamashpayqui cabra-mallwacunallata apamuy.» ");
INSERT INTO qub_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Maman chayno niptin Jacob aywaran cabra-mallwacunaman. Nircur mamanman apapämuran. Chaura mamannami Isaac yachashan micuyta ruraran. ");
INSERT INTO qub_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Nircur Rebecaga mayur wamran Esaüpa alli röpan churaräcojta jorgarcamur Jacobtana jatiparan. ");
INSERT INTO qub_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Jacobta papänin mana rejsinanpämi ricranpawan cuncanpa shapran mana cashanpaga cabra-mallwapa garachanwan pituparan. ");
INSERT INTO qub_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Chayno rurariycur Rebecaga yanucushan micuyta tantantinta «apay» niran Jacobta. ");
INSERT INTO qub_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Jacobnami micuyta apacurcur papänin caycashan cajman yaycurir «Papä» nir gayaran. Niptin papänin niran: «Caychömi caycä ïju. ¿Maygan caj wamrätaj canqui?» nir. ");
INSERT INTO qub_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Chaura Jacob niran: «Nogaga caycä mayur wamrayqui Esaümi. Nimashayquita ruramushcänami. Jatarimuy ari papä. Sumaj jamarcur micucurcuy ari charimushä animalpa aychanta bindisyunta gomänayquipaj.» ");
INSERT INTO qub_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Chaura Isaac tapuran: «¿Imanöpataj rätullaga chariraycamushcanqui?» nir. Niptin Jacobga niran: «Tayta Diosniqui yanapämaptinmi rätu tarimushcä» nir. ");
INSERT INTO qub_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Niptin papänin niran: «Witimuy yatanäpaj. Mä rasunpachush canqui wamrä Esaú.» ");
INSERT INTO qub_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Chayno niptin Jacobga papäninpa ñaupanman witiran yatananpaj. Yataycur papänin niran: «Rimaynenga Jacobpami; maquincunami ichanga Esaüpa.» ");
INSERT INTO qub_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Papänenga mana rejsiranchu. Yataycuptin maquincunaga Esaüpa maquinnöna ushajpaj millwa caycaran. Chaura bindisyunta gonanpäna caycaran. ");
INSERT INTO qub_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","Ichanga yapay tapuran: «Gamga ¿rasunpachu canqui wamrä Esaú?» nir. «Au, Esaümi cä» niran Jacobga. ");
INSERT INTO qub_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Chayno niptin papänin niran: «Charimushayqui animalpa aychanta garamay ari ïju. Nircurnami bindisyunnëta goshayqui.» Niptin Jacobga papäninta gararan. Bïnutapis apaparan. Chaura Isaacga micuran upuran. ");
INSERT INTO qub_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Micuyta usharcur niran: «Witircamur muchamay ïju» nir. ");
INSERT INTO qub_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Papäninta muchananpaj Jacob ñaupanman witircuptin Isaacga röpanpa asyayninta mayaran. Chaymi bindisyunta goshpan cayno niran: «Cayga wamräpa asyayninmi. Tayta Dios bindisyunta churashan jircacunapa asyayninnömi caycan. ");
INSERT INTO qub_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Gam tiyashayquimanga Tayta Dios tamyaycachimuchun. Micuyniquicunatapis Tayta Dios wayuycachichun. Pay yanapaycushunqui gampa achca rïgu achca bïnu cananpaj. ");
INSERT INTO qub_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Gamtaga achca runacuna sirbiycushunqui. Llapan nasyun runacuna gamta rispitaycushunqui. Wauguiquicunapis gampa munayniquicho caycullächun. Gamta chiquishoj cäga maldisyunädumi canga. Gamta bindisashoj cäga bindisashami canga.» ");
INSERT INTO qub_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Isaacga wamran Jacobta bindisyunta goyta usharanna. Papänin cajpita Jacob llojshirishallantana Esaüpis chayaramuran jirca animal charej aywashanpita. ");
INSERT INTO qub_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Paypis papänin yachashan mishquej micuyta ruraran. Nircur papäninman apaparan. Chayaycachir niran: «Jatarimuy papä. Charimushä animalpa aychanta micucurcuy bindisyunta gomänayquipaj.» ");
INSERT INTO qub_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Chayno niptin Isaac tapuran: «¿Pitaj canqui?» nir. Niptin wamranga niran: «Nogaga mayur wamrayqui Esaümi caycä.» ");
INSERT INTO qub_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Chayno niptin Isaacga manchacäcuran. Sicsicyayllapa watapa-watapa rimar niran: «Chauraga ¿pitaj animal charej aywashanpita cutiraycamur micuyta apamusha? Chayta mayna nogaga micushcäna manaräpis chayamuptiqui. Paytana bindisyuntapis goshcä. Bindisyun goshätaga manami cutiricömannachu.» ");
INSERT INTO qub_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Chayno papänin nishanta wiyaycur Esaüga fiyupa wagar gapararan. Llaquicur niran: «¡Papä, nogatapis bindisyunta gomay ari!» nir. ");
INSERT INTO qub_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Chayno niptin Isaacga niran: «Wauguiqui shaycamurmi llullapämasha. Gamta bindisyunta gonäpaj cajta paytanami goshcä.» ");
INSERT INTO qub_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Chaymi Esaüga niran: «Rasuntachari ‹Jacob› nirpis jutichaparan. Cananwanga ishcay cutinami engañaman. Rimëroga mayur cay derëchöta guechumasha. Cananga nogata bindisyunta gomänayquipaj cajtana guechumasha. ¿Manachu ichicllapis quëdasharaj nogatapis bindisyunta gomänayquipaj?» nir. ");
INSERT INTO qub_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Chayno niptin Isaac niran: «Nogaga Jacobtanami nishcä gampis paytana rispitanayquipaj. Llapan castancunapis paypa munayninchöna cananpaj nishcä. Paytami nishcä paypaga rïgupis übaspis aypalla cananpaj. Cananga ¿imatanataj bindisyuntapis goshayqui ari ïju?» ");
INSERT INTO qub_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Chaura Esaüga niran: «Papä, ¿manachu nogatapis juc shimillatapis bindisyunniquita gomanquiman? Nogatapis bindisyunniquitaga gomay ari papä.» Chayno nir Esaüga gaparaypa wagaran. ");
INSERT INTO qub_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Chaymi Isaacga niran: «Micuy alli wayunan chacrapita caruchömi tiyanquipaj. Tamya tamyamunanpitapis caruchömi tiyanquipaj. ");
INSERT INTO qub_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Magashunayquipaj shamuptin espädayquiwan difindicurmi cawanquipaj. Wauguiquipa munayninchömi canquipaj. Chaypis callpachacorga maquinpita llojshinquipämi.» ");
INSERT INTO qub_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Papänin bindisyunta goshan junajpita-pachami Esaüga Jacobta fiyupa chiquipacurcuran. Chaymi Esaú cayno yarparan: «Alläpaga papänë mananami cawanganachu. Papänë wañucuptinnaga wauguë Jacobta wañuycachishämi» nir. ");
INSERT INTO qub_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Esaú chayno yarpaycashanta Rebeca mayaran. Mayaycurmi wamran Jacobta gayarcachir niran: «Wauguiqui Esaüga wañuchishunayquipämi yarpaycan. ");
INSERT INTO qub_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Chaymi ïju, nishäta sumaj wiyamay. Harán marcacho turë Labán tiyaycashanman aywacuy. ");
INSERT INTO qub_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Pay cajcho goyäcamunqui unaycama, wauguiquipa rabyan päsacänancama. ");
INSERT INTO qub_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Guechushayquita wauguiqui gongaycuptinnaga willachimushayquimi cutimunayquipaj. ¡Nogaga juc junajllacho ishcan wamräta ograycuyta manami munächu!» ");
INSERT INTO qub_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Chaypita Rebecaga runan Isaacta niran: «Esaüpa warmincunapitaga pasaypa yamacashanami caycä. Cay Canaán marcacho tiyaj Het warmiwan Jacobpis majachacaptinnaga mas allimi canman wañucuptëna.» ");
INSERT INTO qub_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Chayno niptinmi Isaacga gayaran Jacobta. Bindisyunta goshpan cayno niran: «Cananea warmiwanga ama majachacaychu. ");
INSERT INTO qub_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Padan-aram marcaman aywacuy mamayquipa taytan Betuelpa wasinman. Chaycho majachacämunqui mayganwanpis mamayquipa turin tiyuyqui Labanpa wamrancunawan. ");
INSERT INTO qub_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Llapanpaj munayniyoj Tayta Dios bindisyunta goycushunqui. Bindisyunta goycushunqui wamrayquicunapis aypallaman mirananpaj, gampita mirajcuna achca nasyuncuna cananpaj. ");
INSERT INTO qub_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Abrahamta Tayta Dios yanapänanpaj aunishan bindisyuncuna gampaj, gampita mirajcunapäpis caycullächun. Chaynöpis Tayta Dios Abrahamta aunishannölla cay particho gorpanölla tiyaycashanchïpis gampita mirajcunapäna caycuchun.» ");
INSERT INTO qub_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Chayno bindisyunta goycurmi Isaacga wamran Jacobta cacharan Padan-aram marcaman chaycho tiyacunanpaj. Jacob aywacuran Labanpa wasinman. Labanga caran Aram runa Betuelpa wamran, Rebecapa turin. Rebecanami caran Esaüpawan Jacobpa maman. ");
INSERT INTO qub_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Esaüga ricaran papänin Isaac Jacobta bindisyunta goshanta, Padan-aram partiman aywarcur majachacämunanpaj nishantapis. Ricaran papänin bindisyunta goshpan Cananea warmiwan mana casarananpaj nishanta. ");
INSERT INTO qub_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Ricaran papänin maman nishanta wiyacur Jacob Padan-aramman aywacushantapis. ");
INSERT INTO qub_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Chaynöpanami Esaüga tantiyacuran Cananea warmicunataga llumchuyninpaj papänin mana munashanta. ");
INSERT INTO qub_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Chaymi Abrahampa wamran Ismael cajman aywaran. Chaychöna warminpaj ashiran Ismaelpa wamran Mahalat-ta. Chay warmiga caran Nebaiotpa pañin. Chaywanga majachacaran Cananea warmincunapis caycaptinna. ");
INSERT INTO qub_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Beersebapita aywacur Jacobga aywacuran Haranman näni aywajpa. ");
INSERT INTO qub_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Aywaycashancho juc partiman chayaran. Chaycho chacäpacurmi jawananpaj rumita churacurcur puñucuycuran. ");
INSERT INTO qub_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Puñur suyñuynincho ricaran jatun escalëra pampapita syëlucama ichiraycajta. Chay escalërapana Diospa anjilnincuna wichaycaran uraycämuran. ");
INSERT INTO qub_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Tayta Diostapis ricaran ñaupancho ichiraycajta. Paymi cayno niycaran: «Nogami cä chachayqui Abrahampawan papäniqui Isaacpa Tayta Diosnin. Canan puñuraycashayqui pachataga gamtami gampita mirajcunatami goycushayqui. ");
INSERT INTO qub_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Gampita mirajcunaga ñuchu allpano yupaytapis mana atipaypämi cangapaj. Wamrayquicuna mirashpanmi may-chaypapis mashtacangapaj. Gam-cashami, gampita mirajcuna-cashami mundu intërucho tiyaj runacunatapis bindisyunta goshaj. ");
INSERT INTO qub_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Nogaga gamwanmi caycä. Maypa aywaptiquipis nogami ricashayqui. Maypitapis cay partimanmi cutichimushayquipaj. Mana gongaypami gamta aunishäcunataga llapanta cumlishäpaj.» ");
INSERT INTO qub_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Puñuycashanpita riccharcamur Jacobga niran: «Rasunpa caychömi Tayta Diosga caycan. Nogaga manami musyashcächu» nir. ");
INSERT INTO qub_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Fiyupa manchacur niran: «Cay pachaga fiyupa rispitäduchaj. Cayga canaj Tayta Diospa wasinchaj, syëlupa puncunchaj.» ");
INSERT INTO qub_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Tutanninna Jacobga chaca-chacalla jatariran. Jawanacushan wanca rumita jawiran. Jawishan rumimanna Tayta Diosta rispitashpan asëtita wiñaparan. ");
INSERT INTO qub_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Nircur chay pachapa jutinta churaparan Bet-el nir. Chay siudäpa unay caj jutenga caran Luz. ");
INSERT INTO qub_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Chaycho Jacobga aunishpan Diosta cayno niran: «Canan aywaycashächo yan'gämaptiqui, ricamaptiqui, micunäpaj tarichimaptiqui, röpäpaj tarichimaptiqui, ");
INSERT INTO qub_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","papänëpa wasinman sänuta allita cutichimaptiquega gammi canquipaj nogapa Tayta Diosnë. ");
INSERT INTO qub_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Cay wanca rumita ichichishä pachami cangapaj Tayta Diospa wasin. Imata tarichimashayquipitapis diesmuta gampämi churamushaj.» ");
INSERT INTO qub_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Chaypita Jacob aywacur chayaran inti yagamunan cajcho tiyaj runacunapa tiyananman. ");
INSERT INTO qub_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Chayar Jacobga pösupa ñaupancho quimsaj runacuna shuyni-cama uyshancunata cabrancunata chaparpaycajta ricaran. Llapan runacunapis chay pösupitarämi uywancunata yacuta upuchej. Pösupa shimintana chaparaycaran jatuncaray läja rumi. ");
INSERT INTO qub_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Chay läjataga llapan uyshërucuna shuntacaycärir-rämi witichej. Nircur-rämi uyshancunata cabrancunata yacuta upuchej. Upurcäracherga pösuta yapay chaparcärej. ");
INSERT INTO qub_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Chay uyshërucunata Jacobga tapuran: «Gamcunaga ¿maypitataj canqui taytacuna?» nir. Chaura paycunaga niran: «Haranpitami cä» nir. ");
INSERT INTO qub_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Chaura Jacobga yapay tapuran: «¿Rejsinquichu Nacorpa willcan Labanta?» nir. Chayno niptin paycuna niran: «Au, rejsëcunami.» ");
INSERT INTO qub_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Yapaypis Jacob niran: «¿Allichuraj caycällan?» Chaura uyshërucunaga niran: «Au, Labanga allimi caycan.» Niycashancho niran: «Masqui ricay, wamran Raquel uyshancuna cabrancuna gatisha tagayta aywaycämun.» ");
INSERT INTO qub_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Chaura Jacobga uyshërucunata niran: «Intiga junajllarämi caycan uyshacunata cabracunata wichganayquipäga. Yacuta upuraycärachir ¿imanirtaj michej yapay mana gatinquichu?» ");
INSERT INTO qub_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Chaymi paycunaga nipäcuran: «Manami chaynöga ruräcunachu. Llapan chayamunantarämi shuyäcuna. Llapan shuntacaycur-rämi pösuta chaparaycaj rumita quichan. Chayrämi uywäcunata yacuta upuchë.» ");
INSERT INTO qub_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Paycunawan Jacob parlaycaptillanna Raquelga papäninpa uyshancunata cabrancunata gatisha chayamuran. Paymi caran papäninpa uyshërun. ");
INSERT INTO qub_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Tiyun Labanpa wamran Raquelta ricar jinan öra Jacobga pösuta chaparaycaj rumita witichiran. Nircur tiyunpa uyshancunata cabrancunata yacuta upuchiran. ");
INSERT INTO qub_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Yacuta upuraycachir Raquelta saludar mucharan. Saludarcur cushicuyllawan wagaran. ");
INSERT INTO qub_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Jacob willaran Rebecapa wamran y Labanpa subrinun pay caycashanta. Chaura Raquelga cörriyllapa aywaran papänin Labanta willaj. ");
INSERT INTO qub_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Pañinpa wamran Jacobpaj parlajta wiyar Labanga cörriyllapa aywaran tincunanpaj. Tincurcurnami macallarcur mucharan. Nircurnami wasinman pusharan. Chaychöna Jacobga tiyunta willaparan wasincho imano goyashantapis. ");
INSERT INTO qub_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Llapanta willapaycuptin Labanga niran: «Gamga rasunpami canqui yawar-masë.» Chaypita Jacob juc quillana tiyun Labanta aröshir goyarcuptin ");
INSERT INTO qub_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","tiyun Labanga tapuran: «Dibaldilla aröshimänayquega manami camacanchu subrinö cashpayquipis. Willamay aröshimashayquipita aycata päganäpäpis.» ");
INSERT INTO qub_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Labanpaga ishcay jipash wamrancuna caran. Mayur cajpami jutin caran Lea. Shullca cajpana jutin caran Raquel. ");
INSERT INTO qub_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Leapa ñawincuna camarajllami caran. Raquelmi ichanga chaquipita umanyaj cuyayllapaj camaraj caran. ");
INSERT INTO qub_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Jacobga Raquelta amatar cuyarmi Labanta niran: «Shullca caj wamrayqui Raquelpaj ganchis wata arupäshayqui.» ");
INSERT INTO qub_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Niptin Labán niran: «Au, allimi chaynöga. Gamta goycushayqui jäpa runata goycunäpa ruquenga. Chauraga cayllachöna goyäcushun.» ");
INSERT INTO qub_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Chaynömi Jacobga Raquelpaj aruran ganchis wata. Raquelta amatar cuyaptinmi ganchis wata arushanga manapis aycällatano päsariran. ");
INSERT INTO qub_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Ganchis watata usharcuptinna Jacobga Labanta niran: «Arupänäpaj parlashanchïtaga ushashcänami. Cananga wamrayqui Raquelta goycamayna paywan majachacänäpaj.» ");
INSERT INTO qub_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Chayno niptin Labanga llapan rejsinacushan runacunata willachiran wamran majachacaptin rurashan fistaman shamunanpaj. ");
INSERT INTO qub_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Fista caycashan chacay Labanga wamran Leata pushaparan Jacobman. Chaura Jacobga Leawan puñuran. ");
INSERT INTO qub_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Labanga wamran Lea majachacaptin Zilpa jutiyoj jipashta goycuran uywayninpaj. ");
INSERT INTO qub_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Puñushan warannin tuta Jacobga rejsircuran Lea cashanta. Chaymi Labantaga tapuran: «¿Imanirtaj chaynöga ruramashcanqui? ¡Nogaga arushcä Raquelpämi! Chauraga ¿imanirtaj engañamashcanqui?» nir. ");
INSERT INTO qub_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Chayno niptinmi Labán niran: «Cay nogacunachöga custumri rimëruga mayur cajrämi majachacan, chaypitarämi shullca cäga. ");
INSERT INTO qub_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Majachacashayquipita semänaraj goyay Leawan. Chayno goyarcuptiqui Raqueltapis goshayquimi yapay ganchis wata arupämänayqui captenga.» ");
INSERT INTO qub_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Chayno niptin Jacobga yapay arupänanpaj auniran. Leawan majachacashan semänarcuptin Labanga Raqueltapis goycuran Jacobta. ");
INSERT INTO qub_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Papänin Labanga Raqueltapis goycuran Bilha jutiyoj jipashta uywayninpaj. ");
INSERT INTO qub_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Chaypita Jacobga Raquelwanpis puñuran. Raqueltaga Leapita masmi cuyaran. Chaypita Labantaga yapay ganchis wata aruparan. ");
INSERT INTO qub_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Tayta Dios ricaran Leata Jacob mënus cuyashanta. Chaymi paytaga yanaparan wamrayoj cananpaj. Raquelpämi ichanga wawata mana tarinanpaj camacächiran. ");
INSERT INTO qub_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Leaga gueshyaj ricacur gueshyacuran ollgu wamrata. Chaymi niran: «Tayta Diosmi ricamasha llaquisha caycajta. Cananga runäpis masmi cuyamanga» nir. Chayno nirmi wamranpa jutinta churaparan «Rubén» nir. ");
INSERT INTO qub_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Chaypita yapay Leapa wamran caran. Chaymi niran: «Tayta Dios ricamashami runä mënus cuyamashanta. Chaymi munasha yapay wamrayoj canäta.» Chaypitami chay wamranpa jutinta churaparan «Simeón» nir. ");
INSERT INTO qub_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Yapay Leapa wamran caran ollgu. Chaymi niran: «Cananga nogallawannami runä goyanga. Paypa wamranga quimsanami nogacho» nir. Chaypitami chay wamranpa jutinta churaparan «Leví» nir. ");
INSERT INTO qub_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Yapaypis Leapa wamran caranraj. Chaymi niran: «Cananga Tayta Diostami alabashaj» nir. Chaypitami chay wamranpa jutinta churaparan «Judá» nir. Chay wamran cashanpitaga Leapa wamran mana carannachu. ");
INSERT INTO qub_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Raquelga quiquin wawata mana tarir ñañan Leata chiquiran. Chaymi runan Jacobta niran: «Nogachöpis wamrayqui cachun. Wawata mana tarerga wañucurishämi.» ");
INSERT INTO qub_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Chayno niptin Jacobga fiyupa rabyaran. Chaymi Raquelta niran: «Nogaga Diostächu cä. Paymi mana munanchu wawayoj canayquita.» ");
INSERT INTO qub_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Chaura Raquel niran: «Chauraga uywaynë Bilhawan puñuy. Paypa wamran captinpis chay wamraga canga quiquë gueshyacushänömi. Chaynöpami noga wamrayoj cashaj.» ");
INSERT INTO qub_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Chayno nir warmin Raquelga Jacobta goycuran uywaynin Bilhata, paypis uywaycaj warminna cananpaj. Chaura Jacobga Bilhawanpis cacuran. ");
INSERT INTO qub_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Chaypita Bilha gueshyacuran Jacobpa churinta. ");
INSERT INTO qub_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Chaura Raquel niran: «Wamraynaj cashpä Diosta ruwacushäpitami ñañäno wamrayoj canäta munasha» nir. Chaypitami chay wamrapa jutinta churaparan «Dan» nir. ");
INSERT INTO qub_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Chaypita yapaypis Bilhacho Jacobpa wamran caran. ");
INSERT INTO qub_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Chaura Raquel niran: «Ñañäwanmi pasaypa apänacushcä. Cananmi ichanga llalliycäna.» Chaypitami chay wamrapa jutinta churaparan «Neftalí» nir. ");
INSERT INTO qub_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Leapapis wamran masga manana carannachu. Chaymi uywaynin Zilpata goycuran runan Jacobta uyway caj warmin cananpaj. ");
INSERT INTO qub_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Chaypita Zilpapis gueshyacuran Jacobpa churinta. ");
INSERT INTO qub_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Chaura Lea niran: «Nogapami surtillaga.» Chayno nirmi chay wamrapa jutinta churaparan «Gad» nir. ");
INSERT INTO qub_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Chaypitapis Zilpachöga yapayraj Jacobpa wamran caran. ");
INSERT INTO qub_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Chaymi Leaga niran: «¡Canan nogaga fiyupa cushicuycä! Llapan warmicunapis nogapäga nenga ‹Cushishami caycan› nir.» Chayno nirmi wamranpa jutinta churaparan «Aser» nir. ");
INSERT INTO qub_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Chaypita juc junajcho rïgu cosëcha wichan Leapa mayur wamran Rubenga chacrapa aywaran. Chaycho tarimuran «mandrágora» nishan frütacunata. Chay frütatami mamanpaj aparan. Chay frütata ricaycur Raquelga Leata niran: «Wamrayqui apapämushushayqui mandragorata mañacushayqui juc ishcayta ari.» ");
INSERT INTO qub_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Niptin Lea niran: «¡Gamga pitäshi canqui simberwinsa! Runäta guechurcamarpis cananga munanquiraj wamrä apapämashan mandragoratapis guechumayta.» Chayno niptin Raquelga niran: «Canan chacayga Jacob gamwan puñuchun wamrayquipa mandragoranpa ruquin.» ");
INSERT INTO qub_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Chay tardi Jacob chacrapita cutimojta Leaga tariparcur niran: «Canan chacayga nogawanmi puñushun. Gamtaga mañamasha wamräpa mandragoranpa ruquinmi.» Chayno niptin Jacobga Leawan puñuran. ");
INSERT INTO qub_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Chaymi mañacushanta Tayta Dios wiyaptin Leaga yapay gueshyacuran ollgu wamrata. Chaywanga pichgana wamran caran. ");
INSERT INTO qub_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Chaymi Lea niran: «Uywaynë warmiwan runäta tiyachishäpitami Diosga cay wamräta pägutano gomasha» nir. Chayno nirmi chay wamranpa jutinta churaparan «Isacar» nir. ");
INSERT INTO qub_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Leachöga wamran yapay caran. Chaura llapanga wamrancuna caran sojtana. ");
INSERT INTO qub_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Leaga niran: «Tayta Diosmi cay wamrata regalamasha. Caywanga sojtanami wamräcuna. Chaypitami cananga runä nogatana mas cuyamanga.» Chayno nirmi chay wamranpa jutinta churaparan «Zabulón» nir. ");
INSERT INTO qub_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Chaypita yapay Leapa wamran caranraj ñuñush. Chay caj wamranga caran warmi. Chaypataga jutinta churaparan «Dina» nir. ");
INSERT INTO qub_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Chaypitanaga Dios cuyaparan Raqueltapis. Chaymi mañacushanta wiyar wawayoj cananpaj allchacächiran. ");
INSERT INTO qub_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Rimir wamran captin Raquelga niran: «Tayta Diosga manami munashachu pengaypaj wamraynajlla canäta. ");
INSERT INTO qub_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Tayta Dios munaycunman yapaypis wamrä cananta.» Chayno nirmi chay wamranpa jutinta churaparan «José» nir. ");
INSERT INTO qub_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Josëta Raquel gueshyacushanpitanaga Labanta Jacob niran: «Cananga marcäman cuticunäpäna cachaycamay ari. ");
INSERT INTO qub_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Wamrayquicunata gomänayquipaj arupashcänami. Cananga cachapaycamayna ari warmëcunata, wamräcunatapis. Gamga musyanquimi imano arupashätapis.» ");
INSERT INTO qub_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Chayno niptin Labán niran: «Cayllachöna tiyacushun ari. Maynami tantiyacushcä gam caycho captiqui Tayta Dios bindisyunta gomashanta. ");
INSERT INTO qub_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Gam nimay aycata gänayta munashayquitapis. Chauraga nimashayquitami pägashayqui.» ");
INSERT INTO qub_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Chaura Jacob niran: «Gam musyaycanquimi imano gampaj arushätapis, uywayquicunata michir imano ricashätapis. ");
INSERT INTO qub_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Noga chayamuptë wallcalla caycashanpita aypallamanmi mirasha. Chayamushäpita-pachami Tayta Dios bindisyunta gosha-cashunqui. Cananga quiquëpa wamräcunapäwan warmëcunapäna arushaj.» ");
INSERT INTO qub_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Chayno niptin Labanga yapay niran: «¿Aycata päganätataj munanqui?» Chaura Jacob niran: «Ama imatapis pägamaychu. Yapay uyshayquicunata cabrayquicunata michishaj noga cayno niptë aunimänayqui captin. ");
INSERT INTO qub_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Canan noga aywashaj uyshayquicuna caycashan cajman. Chaycho raquishaj llapan shajshu uyshacunata, muru-muru uyshacunata, yana uysha-mallwacunata, chayno llapan muru-muru cabracunata, shuyucunatapis. Chaycunami cangapaj noga arupashäpita pägö. ");
INSERT INTO qub_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Chaynöpami uywayquicuna ricaj shamur musyanquipaj mana suwapashäta. Nogapa uywäcuna caycashanchöga uyshapis cabrapis cangapaj allgalla, muru-murucunalla, yanalla. Chaycho yuraj tacurarga llapanpis canga noga gampata duyñu-tucuycashallämi.» ");
INSERT INTO qub_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Chaura Labanga niran: «Gam nishayquinöga au allimi.» ");
INSERT INTO qub_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Ichanga chay junajllami Labán raquiran llapan muru-murucunatawan shuyu chïbucunata, chayno llapan china cabracunatapis muru-murutawan shuyucunata, ichiclla yurajniyoj caj uyshatapis, llapan yana uyshacunatapis. Nircur wamrancunaman paytacuycuran. ");
INSERT INTO qub_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Paytacuycunanpäga Jacob caycashanpita quimsa junaj aywayman gaticurcur aywacuran. Jacobga Labanpa uyshancunata jinalla michipaycaran. ");
INSERT INTO qub_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Chaypita Jacobga muturan llullu guerucunapa rämancunata alamopata, almendropata, castañopatawan. Nircur garancunata sepracacharan yuraj räya-räya ricacänanpaj. ");
INSERT INTO qub_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","39","Nircur chay seprashan guerucunatana churargäriran uywacuna yacuta upunan caj wichanman. Chaychömi llapan uywacunaga charicoj. Chay seprasha guerucunapa ñaupancho charicuptinmi mallwacunaga yurej muru-muru, shuyu, allga. ");
INSERT INTO qub_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Chaura chaycunatami Jacobga quiquinpäna raquiran. Waquin uywancunatapis gatipaj Labanpa muru-muru, shuyu uyshancuna yawacur chay-niraj yurinanpaj. Chaynöpami Jacobpa uyshancunaga miraran. ");
INSERT INTO qub_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Wera uywacuna charicuptenga chay seprashan guerucunata churapaj yacuta upunan cajman, charicushan öra seprasha guerucunata ricaptin chay culur mallwa yurinanpaj. ");
INSERT INTO qub_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Uyu uywacuna shamuptinnaga mana churajnachu seprashan guerucunata. Chaynöpami uyu caj uywacunaga miraj Labanpaj. Wera cajcunalla miraj Jacobpäga. ");
INSERT INTO qub_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Chayno ruraycällarmi Jacobga rïcuna ricacuran. Chaymi paypaga aypallana caran uyshancuna, camëlluncuna, bürruncunapis. Warmi ollgu uywaynincunapis aypallana caran. ");
INSERT INTO qub_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Chaypita Jacobga mayaran Labanpa wamrancuna cayno rimar purircaycashanta: «Jacobga papäninchïpa cajllatami llapantapis charaycan. Papänillanchïpawanmi rïcuyashapis» nir. ");
INSERT INTO qub_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Chayno Jacobpis musyaranna Labán mana allina payta ricaycashanta. Manana ñaupata cashannönachu caran. ");
INSERT INTO qub_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Chaymi Jacobtaga Tayta Dios niran: «Cuticuy papäniqui tiyaycashanman. Chaychömi caycan famillyayquicuna. Caypita aywacuptiqui nogami yanapäshayquipaj.» ");
INSERT INTO qub_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Chaura Jacob gayachiran ishcan warmincunata Leatawan Raquelta uyshancunawan jircacho tiyaycashan cajman. ");
INSERT INTO qub_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Chayaptin niran: «Gamcunapa papäniquega manami ñaupata ricamashannönachu ricaman. Chaypis papänëpa Diosninmi nogata yanapämasha. ");
INSERT INTO qub_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Gamcunapis musyaycanquimi papäniquita imano sirbishätapis. ");
INSERT INTO qub_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Chayno sirbiycaptëpis payga engañamashami. Arupashäpitapis achca cutimi parlashänöga mana cumlimashachu. Chayno ruraycämaptinpis Diosmi alli ricamar yanapämasha. ");
INSERT INTO qub_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Papäniqui ‹pägashayqui muru uywacuna yurejtami› niptenga llapan uyshacunapis wachasha murullata. ‹Shuyucunawan pägashayqui› nimaptenga llapanpa wawan caran shuyulla. ");
INSERT INTO qub_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Chaynöpami Tayta Diosga camacächisha papäniquipa uywancuna nogapana cananpaj. ");
INSERT INTO qub_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","«Juc junaj uywacuna charicuycashan wichan suyñuynëcho ricarä llapan jaroj caj chïbucuna shuyu, muru, shajshu caycajta. ");
INSERT INTO qub_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Chay suyñuynëchömi Diospa anjilnin jutëpa gayamaran. Chaura nogaga nirä: ‹Imallaraj› nir. ");
INSERT INTO qub_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Chayno niptëmi Diospa anjilnin nimaran: ‹Sumaj ricay. Llapan orgucuna china cajcunata jaroj cäga caycan shuyulla, murulla, shajshulla. Nogaga musyaycämi imano Labán ñacachishushayquitapis. ");
INSERT INTO qub_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Nogami caycä Bet-elcho rumita jawiycur asëtita wiñapashayqui cajcho yuripaj Dios. Chaychömi aunimarayqui. Cananga caypita aywacuy. Yurishayqui partiman cuticuy› nir.» ");
INSERT INTO qub_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Chayno niptin Raquelwan Leaga niran: «Papänëga nogacunata manami ima erensyatapis gomanganachu. ");
INSERT INTO qub_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Imatapis goycamänanpa ruquenga jäpatanönami ricaycämanpis. Nogacunawan majachacänayquipaj pägashayquitapis quiquillanmi ushasha. ");
INSERT INTO qub_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Cananga Tayta Dios papänëta guechushan ima-aycanpis caycan noganchïpawan wamranchïcunapami. Chaymi cananga llapantapis ruray Tayta Dios nishushayquino.» ");
INSERT INTO qub_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","18","Jacob camaricuran papänin Isaac tiyaycashan Canaanman cuticunanpaj. Wamrancunatawan warmincunata muntachiran camëllucunaman. Quiquinpa cajtaga llapanninta apacuran. Padan-aramcho arupacur gänashan cajtaga llapan uywancunata gaticurcur aywacuran. ");
INSERT INTO qub_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Chay öra Labanga millwa rutoj juc-läman aywacusha caran. Chaycamami Raquelga papäninpa wasi ïduluncunata suwapaycuran. ");
INSERT INTO qub_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Chaynömi Jacobga Aram runa Labanta engañaycuran aywacunanpaj mana willapar. ");
INSERT INTO qub_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Llapanninta apacurcur gueshpir aywacuran. Chayno aywacur Éufrates mayutapis rätu chimpariran. Aywaycällar chayariran Galaad parti jircacunamanpis. ");
INSERT INTO qub_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Jacob aywacushanpita quimsa junajtaraj Labanga mayaran. ");
INSERT INTO qub_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Chaymi Labanga castancunawan Jacobta gatir aywaran. Chayno aywashpan ganchis junajtaraj tariparan Galaad particho caycaj jircacunacho caycajta. ");
INSERT INTO qub_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Taripanan chacay suyñuynincho Labanta Tayta Dios niran: «Jacobtaga ama fiyu shimiquipa imatapis ninquichu.» ");
INSERT INTO qub_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Labanga Jacobta tariparan Galaadcho caycaj jircacho pachacusha caycajta. Labanpis llapan castancunawan pachacuran Galaadcho caycaj jircacunaman. ");
INSERT INTO qub_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Chaycho tincurcurmi Labanga Jacobta niran: «¿Imatataj rurashcanqui? ¿Imanirtaj engañamashcanqui? ¡Wamräcunata pushacamushcanqui guërracho binsiycur prësu apacojno! ");
INSERT INTO qub_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","¿Imanirtaj mana willamayllapa gueshpir shacamushcanqui? ¿Nogaga imataj cashcä mana willamänayquipäga? Shacamunayquipaj willamaptiquega despachamöman caran tamburninpawan arpanpawanmi. ");
INSERT INTO qub_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Manami willamashcanquichu wamräcunatawan willcäcunata aywacamunanpaj muchaycunalläpäpis. ¡Canan rurashayquega upa rurashannömi! ");
INSERT INTO qub_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Noga munarga munashätami gamcunata rurarëman. Ichanga canan chacaymi papäniquipa Diosnin nimasha: ‹Jacobtaga ama fiyu shimiquipa imatapis ninquichu› nir. ");
INSERT INTO qub_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Papäniquipa wasinman cuticuyta munashpayquimi shacamushcanquipis. Ichanga ¿imanirtaj diosnëcunata suwapämashcanqui?» ");
INSERT INTO qub_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Chayno niptin Jacobga niran: «Gamta manchacushpämi yarparä wamrayquicunata guechumänayquita. ");
INSERT INTO qub_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Mayganpis caycho caycajcuna diosniquita chararaycajta taripaptiquega wañuchun. Imayquitapis gampa cajtaga ashicuy. Tarerga cutichicuy. Caycho caycaj castanchïcunami testïgu caycan.» Jacobga mana musyaranchu papäninpa ïduluncunata Raquel suwamushanta. ");
INSERT INTO qub_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Labanga ïduluncunata ashej yaycuran Jacobpa toldunman, chaypita Leapaman, chayno Jacobpa ishcay uyway warmincunapamanpis. Ïduluncunataga mayganpachöpis mana tariranchu. Leapa toldunpita llojshirir yaycuran Raquelpa cajmanna. ");
INSERT INTO qub_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Payga ïdulucunata charircur pacariycuran camëllucunapa carunancuna rurinman. Nircur jananman jamacuycuran. Labanga chay toldu rurita auchiypa auchir intëruta ashiran. Ichanga mana tariranchu. ");
INSERT INTO qub_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Chaura Raquel niran: «Papä ama rabyacuychu gampa ñaupayquicho mana jataricuptë. Cananga quilla gueshyäwanmi gueshyaycä» nir. Ïduluncunata intërupa ashirpis Labanga mana tariranchu. ");
INSERT INTO qub_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Chayno mana tariptinmi Jacobga rabyacuran. Chaymi Labanta cayno niran: «¿Ima mana allitataj rurashcä? ¿Imataj nogapa juchä chay-jinanpa gatimänayquipäga? ");
INSERT INTO qub_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Ima-aycätapis ashishcanquimi. ¿Imayquitataj tarishcanqui gampa cajtaga? Tarisha cashpayquega mä cayman churay castanchïcuna ricananpaj. Chaura paycunami nimäshun mayganchïcho jucha cashantapis. ");
INSERT INTO qub_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Gamtaga ishcay chunca (20) watami arupashcäpis uywayquicunata ricar. Chaycho manami ni jucnayllapis shullushachu uyshayquicuna ni cabrayquicunapis. Chayno manami ni jucnayllatapis gampa uyshayquitaga micushcächu. ");
INSERT INTO qub_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Jirca animalcuna wañuchiptin manami imaypis gammanga apapämushcächu. Llapan chay pishejcunatapis gamtaga ruquintami cutichishcä. Uywacunata chacaypa u junajpa suwa apaptinpis llapantami ruquinta mañamashcanqui. ");
INSERT INTO qub_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Gampa uywayquita michir ricashpä junajpaga fiyupa acaycho goyarä. Chacaypana caurushapis ñacashcä. Öraga manami puñojpischu cä. Puñunaypis maypashi aywacoj. ");
INSERT INTO qub_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Chaynömi gampa munayniquicho goyashcä ishcay chunca (20) wata. Chunca chuscu (14) watami arupashcä ishcan wamrayquicunapaj. Uywacunata gomänayquipänami arupashcä sojta wata. Achca cutimi parlashanchïnöga mana cumlimashcanquichu. ");
INSERT INTO qub_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Abrahamwan papänë Isaac rispitashan Dios mana yanapämaptenga capaschari gamga chayamushätano jinayllatapis gargaramanquiman caran. Ichanga Diosmi ricasha imano ñacashätapis, imano arushätapis. Chaynöpami ganyan chacaypis Diosga piñacusha-cashunqui.» ");
INSERT INTO qub_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Chayno niptin Labanga Jacobta niran: «Cay warmicunaga nogapa wamräcunami. Cay wamracunaga nogapa willcäcunami. Llapan uywacunapis nogapa uywäcunapa wawallanmi caycan. Llapan caycho ricashayquega nogallapami. Canan nogaga ¿imanäshätaj ari wamräcunata paycunapa wamrancunatapis? ");
INSERT INTO qub_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Chaymi cananga gamwan noga conträtuta rurashun. Chay conträtutaga ishcanchïmi cumlishun.» ");
INSERT INTO qub_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Chayno niptinmi Jacobga chaycho caycaj wanca rumita ichichiran señalpaj. ");
INSERT INTO qub_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Nircur castancunata niran: «¡Rumicunata shuntamuy!» nir. Chayno niptin llapan shuntapäcamuran juc gotuy rumita. Rumita gotushan ñaupanchöna llapan micupäcuran. ");
INSERT INTO qub_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Chay partipa jutinta Labanga quiquinpa rimaynincho churaparan Jegar Sahaduta nir. Jacobna quiquinpa rimaynincho churaparan Galaad nir. ");
INSERT INTO qub_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Chaymi Labanga niran: «Canan conträtu rurashanchïta yarpänanchïpämi canga cay gotuy rumiga.» Chaypitami chay partipa jutin caran Galaad. ");
INSERT INTO qub_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Jucaj jutinna caran Mizpa. Chaynöga jutita churaparan Labán cayno nishanpitami: «Cananpita gampis nogapis manana ricanacuptinchëga Tayta Diosllami ricamäshun imano goyäcushapis. ");
INSERT INTO qub_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Wamräcunata magaptiqui u paycuna warmiqui caycaptin jucwan majachacaptiquipis, mana pï ricashuptiquipis Diosllanami ricashunquipaj.» ");
INSERT INTO qub_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Mastapis Labanga Jacobta niran: «Caychömi rumi goturaycan. Ichichishä wancapis caycan. ");
INSERT INTO qub_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Chaycunami señal canga gampis ni nogapis mana päsapänacunanchïpaj, imatapis mana ruranacunanchïpaj. ");
INSERT INTO qub_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Chachayqui Abrahampa Diosnin nogapa chachä Nacorpa Diosninmi ishcanchïtapis ricamäshun imano cashapis.» Chayno niptin Jacobpis papänin Isaac adurashan Tayta Diospa jutincho juraran chay parlashancunata cumlinanpaj. ");
INSERT INTO qub_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Chaypita Jacobga Tayta Diospaj uywata pishtaran. Nircur chaycho micunanpaj llapan castancunata gayaran. Iwal llapan micucarcärirna chay jircallacho wararan. ");
INSERT INTO qub_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Chaypita warannin tuta Labanga llapan willcancunatawan wamrancunata mucharan. Nircur bindisyunta goran paycuna alli goyänanpaj. Llapanta chayno rurarcur Labanga marcanman cuticuran. ");
INSERT INTO qub_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Chaypita aywacuycashancho Jacobga Tayta Diospa anjilnincunawan tincuran. ");
INSERT INTO qub_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Chaura Jacob almirasha niran: «¡Caychöga Diospa suldäruncunami pachacaraycan!» nir. Chayno nirmi chay partipa jutinta churaparan Mahanaim nir. ");
INSERT INTO qub_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Jacobga uywaynincunata cacharan Seircho caycaj Edom partiman. Cachacuran wauguin aywaycashanta Esaüta willananpaj. ");
INSERT INTO qub_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Manaraj cacharmi yachachiran cayno ninanpaj: «Tayta Esaú, sirbishojniqui Jacobmi cachamasha päsaj watacunacho tiyun Labanpa wasincho goyashanta willanäpaj. ");
INSERT INTO qub_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Cananga paypapis caycanmi wäcacuna, bürrucuna, uyshacuna. Chayno canmi uywaynin runacunapis warmipis ollgupis. Chayno nirmi cachamasha allipa tincur cuyapänayquipaj» nir. ");
INSERT INTO qub_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Cachashan runacunaga Esaüta willashanpita cutiycamur Jacobta willaran: «Wauguiqui Esaüta willaj maynami aywashcäcuna. Cananga quiquinmi aywaycämun gamwan tincunanpaj chuscu pachac (400) runata pushacurcur.» ");
INSERT INTO qub_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Chayno cachancuna willaycuptin Jacobga fiyupa manchacäcuran. Pasaypa yarpachacuyman churacaran. Chaymi paywan caycaj runacunata, uywancunatapis ishcay röpaman raquiran. ");
INSERT INTO qub_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Jacobga caynömi yarparan: «Esaú aypalla runacunawan shamushpan jucaj röpata wañuycachiptinpis jucaj röpallapis gueshpengami» nishpan. ");
INSERT INTO qub_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Chayno rurariycur Tayta Diosta mañacuran: «Chachä Abraham rispitashan, papänë Isaac rispitashan Tayta Dios, gammi nimarayqui castäcuna caycashan partiman cutimunäpaj. Chaynöpis nimarayqui yanapämänayquipämi. ");
INSERT INTO qub_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Cayno cuyapämänayquipaj, cayno alli ricamänayquipaj nogaga manami imatapis rurashcächu. Cay Jordán mayutaga bastunnë aptashallami päsarä. Cananga charashäcunata ishcay röpamanrämi raquishcä. ");
INSERT INTO qub_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Wauguë Esaüpita salbaycamay ari. Aypalla runacunawan yaycaycamur warmicunatapis wamrantinta wañuchinanpitami manchacö. ");
INSERT INTO qub_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Gamga nimarayqui noga alli goyänäpämi, nogapita mirajcuna lamar cantuncho agushno mirananpämi, aypalla captin mana pipis yupayta atipananyaj cananpämi» nir. ");
INSERT INTO qub_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Diosta mañacushan chacayga Jacob chayllacho puñuran. Chaypitana uywancunata acraran wauguin Esaüta goycunanpaj. ");
INSERT INTO qub_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","Acraran china cabrata ishcay pachacta (200), chïbutana ishcay chuncata (20), china uyshata ishcay pachacta (200), carnitana ishcay chuncata (20), ");
INSERT INTO qub_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","quimsa chunca (30) camëlluta wawantinta, china wäcacunata chuscu chuncata (40), chunca törucunata, china bürrucunata ishcay chuncata (20), orgu bürrucunatana chuncata. ");
INSERT INTO qub_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Chayno raquircur cada casta uywacunata shuyni-cama gatichiran. Uywaynincunataga cayno niran: «Gamcunaga caru-caru ñaupäta aywanqui raquipashä uywacunata shuyni-cama gaticarcärir.» ");
INSERT INTO qub_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Ñaupata gatichishan cajta cayno yachachiran: «Wauguë Esaüga tincuptiqui capas tapushunqui: ‹¿Pitaj gampa patrunniqui? ¿Maypataj gam aywaycanqui? ¿Pipataj cay uywacuna?› nir. ");
INSERT INTO qub_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","Chayno nishuptiqui gam cayno ninqui: ‹Gampämi tayta Esaú. Sirbishojniqui Jacobmi gatiycächiman. Quiquenga chayrämi aywaycämun› nir.» ");
INSERT INTO qub_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Llapan uywa gatejcunatapis yachachiran chaynölla ninanpämi. ");
INSERT INTO qub_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Sumaj willaparan: «Llapaniquipis Esaüwan tincorga caynölla ninqui: ‹Jacobga chayrämi aywaycämun› nir.» Jacobga yarparan cayno: «Ñaupäta paypaj uywacunata gatichiptëga rabyasha caycashanpitapis allchacangami. Chaura nogaga tincurcushaj rabyashanpita allchacashwannami. Chauraga alli shiminpanami tincurcuptë chasquimanga» nir. ");
INSERT INTO qub_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Chaynömi Esaüta goycunanpaj caj uywacunataga ñaupanta gatichiran. Llapanta chayno gargupariycur quiquin Jacobga pachacaraycashan cajcho quëdacuran. ");
INSERT INTO qub_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Chaypita chay chacay Jacobga ishcan warmincunata, ishcan uyway warmincunata, chunca juc wamrancunatapis chimpachiran Jaboc mayuta päsana bädupa. ");
INSERT INTO qub_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Llapan ima-aycantapis päsachiran. ");
INSERT INTO qub_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Nircorga quiquillanna quëdacuran. Chay chacaymi juc runa Jacobwan warayta pillyaran. ");
INSERT INTO qub_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Jacobtaga imanöpapis manami binsiranchu. Chaymi Jacobta yataycuran cheglla tincoj moguncho. Chaura chay runawan charinacusha caycaptillan mogonga saltacäcuran. ");
INSERT INTO qub_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Chaymi chay runaga Jacobta niran: «Pacha waraycannami. Cacharimay» nir. Niptin Jacobga niran: «Bindisyunta manaraj gomaptiquega manami cacharishayquichu» nir. ");
INSERT INTO qub_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Chaura chay runaga Jacobta tapuran: «¿Imataj jutiqui?» nir. Paynami niran: «Nogapa jutëga Jacobmi.» ");
INSERT INTO qub_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Chay runanami niran: «Cananpitaga manami Jacobnachu jutiqui canga. Jutiquega canga Israel. Chayno jutiqui canga Dioswanpis, runacunawanpis pillyar llapanta binsishayquipitami» nir. ");
INSERT INTO qub_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Chaypita Jacobpis tapuran: «Cananga gamna willamay. ¿Imataj jutiqui?» nir. Chaura Jacobta niran: «¿Imapätaj jutëta musyayta munanqui?» nir. Chaypita chay runaga jinallancho Jacobta bindisyunta goran. ");
INSERT INTO qub_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Jacobga niran: «Dioswanmi ricanacushcä. Ichanga manami wañushcächu» nir. Chaymi chay partita jutichaparan Peniel nir. ");
INSERT INTO qub_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Penielpita Jacob aywacuycaptin inti ratarcamuranna. Cheglla tincoj moguncho anjil yataycusha captinmi wegruyllapa aywaycaran. ");
INSERT INTO qub_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Chayno Jacobta encuentru moguncho yatashanpitami Israelpita mirajcunaga uywata pishtar canancamapis mana micunchu uywapa chegllancho tincoj ancu ancunta. ");
INSERT INTO qub_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Chuscu pachac runacunawan Esaú awaycämojta ricärir Jacobga wamrancunata raquiran waquin Leawan aywananpaj, waquin Raquelwan aywananpaj, waquinna uyway warmincunawan aywananpaj. ");
INSERT INTO qub_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Ñaupa puntaman churaran uywaycaj warmincunata wamrancunatawan-cama, chaypitana Leata llapan wamrancunatawan, ushananmanna Raquelta wamran Josëtawan. ");
INSERT INTO qub_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Nircur quiquin Jacobga ñaupa-puntata aywaran. Esaüwan tincunanyaj aywaran urcunpis pampaman töpananyaj ganchis cuti gongurpacur-gongurpacur. ");
INSERT INTO qub_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Chayno aywaycajta ricärir wauguin Esaüga cörriran tincunanpaj. Chayaycur macallacurcur mucharan. Nircur ishcan wagaran. ");
INSERT INTO qub_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Esaüga ricchacurishancho ricäriran warmicunatawan wamracunata. Chaura tapuran: «Caycunaga ¿picunataj?» nir. Tapuptin Jacob niran: «Tayta Dios tarichimashan wamräcunami callan tayta.» ");
INSERT INTO qub_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Chaura uywaycaj warmincunapis wamrancunawan Esaüpa ñaupanman witimur gongurpacushpan umpuran urcunpis pampaman töpanancama. ");
INSERT INTO qub_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Leapis wamrancunawan witimur chaynölla umpuran. Ushanantana Raquel wamran Josëwan witimur umpuran. ");
INSERT INTO qub_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Esaüga tapuran: «¿Imapätaj röpa-röpa uywayquicunataga gatiycächinqui?» Chaura Jacob niran: «Chaycunaga nogawan alli canayquipaj goycunäpämi tayta.» ");
INSERT INTO qub_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Chayno niptin Esaú niran: «Nogataga ama gomaychu ari. Nogapapis caycällanmi tincullaga. Quiquiquipa cäga gampaj cacuchun.» ");
INSERT INTO qub_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Chayno niptin Jacobga yapay niran: «Goycushätaga chasquimay ari nogawan rasunpa alli caycashayquita musyanäpaj. Gamwanga alliwanmi tincushcanchïpis. Chaymi gamwan tincuycorga quiquin Diosta ricaycushanöraj fiyupa cushisha caycä. ");
INSERT INTO qub_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Gampaj apamushätaga chasquimay ari. Tayta Dios yanapämaptinmi rïcuyashcä. Chaymi ima-aycäpis aypalla caycan.» Jacob yaparir-yaparir ruwaptin Esaüga chasquiran. ");
INSERT INTO qub_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Chasquircur Jacobta niran: «Caypita juclla aywacushun. Noga aywashaj gamcunapa ñaupayquitami.» ");
INSERT INTO qub_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Chaura Jacob niran: «Tayta, gam ricaycanquimi wamracuna pishillaraj caycajta. Uywäcunapis iti mallwayojmi caycan. Chayachiypa juc junajlla gatishaga uticayllawan llapan uyshäcunapis wañunmanmi. ");
INSERT INTO qub_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Gamga mijur ñaupacuy tayta. Nogaga uywäcuna shamushan-tupu pasinsallami shamushaj. Wamräcunapis chaynölla shamonga. Chaynöllami chayamushaj tiyaycashayqui Seircho yapay tincunanchïpaj.» ");
INSERT INTO qub_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Chayno niptin Esaüpis niran: «Chauraga pushamushä runacunata waquinta cachapäshayqui yanapäshunayquipaj.» Chaura Jacobga Esaüta niran: «¿Imapänataj cachapämanqui tayta? Nogaga gamwan cushishawan tincuycur cushishami caycä.» ");
INSERT INTO qub_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Chaypita Esaüga chay junajlla Seirman cuticuran. ");
INSERT INTO qub_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Jacobnami aywacuran Sucot partiman. Chaychöna wasita ruraran. Ramädacunatapis ruraran uywancunapaj. Chaypitami chay partipa jutinta churaparan Sucot nir. ");
INSERT INTO qub_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Jacobga Padan-arampita shacamur Canaán partiman allilla chayamuran. Shequem siudä caycashan chimpanman chayaycur chaychöna tiyaran. ");
INSERT INTO qub_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Tiyacaycärishan partita Jacobga Hamorpa wamrancunapita rantiran pachac (100) guellaycho. Hamorpa jucaj wamranpa jutin caran Shequem. ");
INSERT INTO qub_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Chaychöna altarta pergaran. Chay altarpa jutinta churaparan El-Elohe-Israel nir. ");
INSERT INTO qub_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Jacobpa warmin Leacho caj wamran Dinaga aywaran chay particho tiyaj jipash-masincunata rajaj. ");
INSERT INTO qub_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Chayman aywajta ricaran Hev runa Hamorpa wamran Shequem jutiyoj. Chay partichöga Hamormi caran mandaj. Shequemga Dinata firsapita charipacur pengayman churaran. ");
INSERT INTO qub_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Chaypitami Shequemga Dinata fiyupa cuyacurcuran. Chaymi payta Dina cuyananpaj alli parlapar ruwaran. ");
INSERT INTO qub_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Chaypita Shequemga papänin Hamorta cayno niran: «Chay jipashta ashipämay warmëpaj» nir. ");
INSERT INTO qub_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Jacobga musyaranna wamran Dinata Shequem charipacushanta. Uywancunawan istansacho wamrancuna captin Jacobga upällalla cacuran wamrancuna cutimunancama. ");
INSERT INTO qub_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Chaycamami Shequempa papänenga aywaran Jacobwan parlaj. ");
INSERT INTO qub_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Jacobpa wamrancunaga pañinta charipacushanta musyaran istansapita cutimur-raj. Musyaycur fiyupa rabyaran. Israel casta runacunapäga chayno charipacushan fiyupa pengay caran. Paycunapäga mana nunca rurana caran. ");
INSERT INTO qub_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Chaymi Hamorga paycunawanpis parlar cayno niran: «Wamrä Shequemmi pañiquita fiyupa cuyacurcusha. Chaymi gamcunata ruwä pañiquiwan wamrä majachacänanpaj. ");
INSERT INTO qub_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Chaynöpami gamcunapis canquipaj nogacunapa famillyäna. Chauraga gamcuna castanami nogacunapa warmi wamräwan majachacanga. Nogacuna castanami gamcunapa warmi wamrayquicunawan majachacanga. ");
INSERT INTO qub_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Chaynöpami gamcunaga caycho tiyacunqui. Cay nasyunchöga maychöpis munashayquicho tiyacuy. Munashayquitaga ranticuy. Chacratapis munashayquicho rantiy.» ");
INSERT INTO qub_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Shequemnami Dinapa papänintawan turincunata ruwaran: «Mashayqui canäpaj aunimay ari. Aunimaptiquega imatapis munashayquitami goycushayqui. ");
INSERT INTO qub_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Manami imapis gocamanchu custumri cashanpita mas achcata goycuptëpis. Ichanga jipashwan casaranäpaj aunimay ari.» ");
INSERT INTO qub_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Pañin Dinata charipacushapitami Jacobpa wamrancunaga llullaparan Hamortawan wamran Shequemta. ");
INSERT INTO qub_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Chaymi cayno niran: «Nogacunapäga fiyupa pengaymi pañëta señalacöni runawan majachay. ");
INSERT INTO qub_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Gamcuna cayno ruranayqui captinmi ichanga aunishayqui: Llapayqui ollgu cajcunaga señalacuy nogacunano canayquipaj. ");
INSERT INTO qub_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Chaymi ichanga gamcunapa ollgu wamrayquicunata warmi wamräcunawan majachashunpaj. Chaynölla nogacunapa ollgu wamräcunatapis warmi wamrayquicunawan majachashun. Chaymi ichanga tiyashaj gamcunapa marcayquicho. Chaynöpami llapanchïpis cashun juc marcanöllana. ");
INSERT INTO qub_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Nogacuna nishäno mana señalacuptiquega pañëta pushacarcärir aywacushämi.» ");
INSERT INTO qub_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Chayno Jacobpa wamrancuna nishanga alli caran Hamorpäpis wamranpäpis. ");
INSERT INTO qub_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Chaypita manapis aycällatana Shequemga Dinata fiyupa cuyashpan señalacuran. Shequemga papäninpa castancho caran llapanpita mas rispitädu. ");
INSERT INTO qub_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Chaymi papänin Hamorwan aywaran siudäman yaycuna puncuman. Chay puncuchömi imata rurananpaj cashantapis runacuna willanacoj. Chaychömi runacunata cayno willaparan: ");
INSERT INTO qub_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","«Jacobpa wamrancunaga amistäninchïmi. Paycunapis cay nasyunninchïcho tiyacuchun. Nigusyucunata arucuchun. Paycuna caycho tiyananpaj jamaj jircacunapis chacracunapis aypallami caycan. Noganchïpa ollgu wamranchïcunata paycunapa warmi wamrancunawan majachashwanmi. Paycunapis ollgu wamrancunata noganchïpa warmi wamranchïcunawan majachanmanmi ");
INSERT INTO qub_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","juc castanölla cananchïpaj. Paycuna ichanga munan llapanchi ollgu cajcuna paycunano señalacusha cananchïta. ");
INSERT INTO qub_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Paycuna nishanta rurashun ari. Nishanno rurasha paycunaga caychömi tiyaconga. Chauraga paycunapa llapan ima-aycanpis uywancunapis noganchïpanami canga.» ");
INSERT INTO qub_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Siudä puncucho shuntacaj runacunaga auniran Hamorwan Shequem nishanta. Chaymi llapan ollgu cajcunaga señalacuran. ");
INSERT INTO qub_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Chayno señalacushanpita quimsa junajta Dinapa turincuna Simeonwan Leví sablinwan siudäman aywaran. Chay öra runacunaga señalacushanpita jinallaraj gueshyarcaycaran. Chaymi balurninpis mana caranchu. Chayno caycajtami Dinapa turincunaga sabliwan llapanta wañuycärachiran. ");
INSERT INTO qub_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Chaynömi Hamortapis wamran Shequemtawan sabliwan wañuycachiran. Paycunata wañuycärachir pañin Dinatapis Shequempa wasincho caycajta pushacurcur aywacuran. ");
INSERT INTO qub_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Chay siudä runacuna wañusha caycaptinna Jacobpa waquin caj wamrancunapis chayaran. Pañinta charipacushanpita rabyasha cayllawanmi wañusha caycajpa llapan ima-aycantapis apacuran. ");
INSERT INTO qub_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Siudächo marcacunacho cajtapis apacuran uyshancunata, wäcancunata, bürruncunata. ");
INSERT INTO qub_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Wasicunacho ima-aycan cajtapis apacuran. Warmicunatawan wamrancunatapis prësu apacuran. ");
INSERT INTO qub_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Chaura Jacobga Simeontawan Levïta niran: «Canan gamcunaga fiyupa chiquinacuymanmi gaycamashcanqui. Cananga cay Canaancho tiyaj runacunawan Ferez runacuna fiyupami chiquimanga. Nogapaga wallcallami caycan pillyapaj caj runacuna. Chaymi paycuna shuntacaycur shamorga wañuchimäshun llapan castanchïtawan.» ");
INSERT INTO qub_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Chayno niptin paycuna niran: «¿Chaura, nogacunapa pañëtaga Shequemga jinachi ruraconga mañösa warmitano?» ");
INSERT INTO qub_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Chaypitana Jacobta Tayta Dios niran: «Ima-aycayquitapis apacurcur aywacuy Bet-elcho tiyanayquipaj. Wauguiqui Esaüpita gueshpir aywacuycaptiqui nogami chaycho yuriparä. Chaychömi nogapaj juc altarta perganqui.» ");
INSERT INTO qub_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Chaura Jacobga wamrancunata paywan tiyaycaj runacunatapis niran: «Gamcunaga charaycashayqui diosniquicunata llapanta jitariy. Nircur purificacushpayqui bäñacuy. Röpayquicunatapis rucacuy. ");
INSERT INTO qub_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Bet-elmannami aywacunchi. Chaychömi altarta ruraj aywä nogata yanapämaj Diospaj. Paymi imapitapis salbamaran. Noga fiyupa ñacar puriptëpis, maypa aywaptëpis paymi yanapämaran.» ");
INSERT INTO qub_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Chayno niptin llapan runacunawan castancunaga Jacobta goycäriran charashan diosnincunata, rinrincho jatirashan arëticunatapis. Jacobnami llapanta chaycunataga pampaycuran Shequem siudäpa sercancho encina yörapa chaquinman. ");
INSERT INTO qub_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Chaypita paycuna llojshicuptin chay partipa tiyaj runacunataga Tayta Dios fiyupa manchacächiran. Chaynöpami chay runacunaga Jacobpa wamrancunata mana gatiparanchu. ");
INSERT INTO qub_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Jacobwan aywacöga llapanmi Canaancho caycaj Luzman chayaran. Chay siudäpa jucaj jutin caran Bet-el. ");
INSERT INTO qub_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Chaycho juc altarta pergaran. Nircur jutichaparan El-Betel nishpan. Chayno jutinta churaparan wauguinpita gueshpir aywacuycaptin Tayta Dios yuripashanpitami. ");
INSERT INTO qub_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Chay wichanmi Rebecata mamanno uywaj warmi Débora wañuran. Wañuptin pampaycäriran encina yörapa chaquinman. Chayga caran Bet-elpa sercan. Pampashan partipa jutinta Jacobga churaparan Alón-bacut nir. ");
INSERT INTO qub_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Ñaupata Padan-arampita Jacob cutiycämuptin yuriparcur Diosga bindisyunta goran ");
INSERT INTO qub_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","cayno nishpan: «Gampaga jutiqui Jacobmi. Cananpitaga manami Jacobnachu jutiqui canga. Cananpitaga jutiqui canga Israelnami.» Chayno nirmi Israel nir jutinta rucachiparan. ");
INSERT INTO qub_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Mastapis Tayta Dios cayno niran: «Nogaga munayniyoj Diosmi cä. Gampitaga aypallaman mirachun. Gampita mirajcunaga cangapaj jatun nasyun cananpämi. Chaynöpis achca nasyunpaj aypajmi cangapaj. Gampita mirajcuna waquenga cangapaj raycunami. ");
INSERT INTO qub_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Cananga gamtami goycushayqui Abrahamtawan Isaacta goycushä partitapis. Gam wañuptiquinaga gampita mirajcunatanami goycushäpaj.» ");
INSERT INTO qub_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Chayno Jacobwan parlarcur Diosga aywacuran. ");
INSERT INTO qub_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Chaura Jacobga Dioswan parlashan cajman juc wanca rumita ichichiran. Jawircorga chay wanca jananman bïnuta asëtita wiñaparan Tayta Diosta rispitashpan. ");
INSERT INTO qub_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Chaycho Tayta Dios parlapashanpitami jutichaparan Bet-el nishpan. ");
INSERT INTO qub_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Bet-elcho tiyaycashanpita aywacurcaycaran. Manaraj Efrata nishanman chayaptin Raquelta nanay chariran. Fiyupa ñacashpan fäsiga mana gueshyacuranchu. ");
INSERT INTO qub_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Fiyupa ñacaycaptin partëra niran: «Ama llaquicuychu. Cay wamrayquipis ollgumi yurisha.» ");
INSERT INTO qub_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Chaymi Raquelga pasaypa wañuycashanchöna niran: «Benoni jutin canga» nir. Jacobmi ichanga «Benjamín» nir jutichaparan. ");
INSERT INTO qub_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Raquelga chaynömi wañuran. Chaura Efrata marcaman näni aywajpa ñaupanman pampaycäriran. Chay marcapami cananga jutin Belén. ");
INSERT INTO qub_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Chaura Jacobga Raquelta pampashan jananman wancata ichichiran. Chay wancami canancamapis musyachimanchi Raquel chaycho pamparaycashanta. ");
INSERT INTO qub_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Raquelta pampashan cajpita aywacur Israelga toldunta ichichiran Edar törripa wash'ganman. ");
INSERT INTO qub_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Chaycho tiyaycaptin wamran Rubenga papäninpa uywaycaj warmin Bilhawan puñucuycuran. Chayta mayaycur papänenga fiyupa rabyaran. Jacobpa ollgu wamrancuna caran chunca ishcay. ");
INSERT INTO qub_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Leacho cajcuna caran Rubén mayur, chaypita Simeón, Leví, Judá, Isacar, Zabulón. ");
INSERT INTO qub_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Raquelcho caj caran José, Benjamín. ");
INSERT INTO qub_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Raquelpa uywaynin Bilhacho cajna caran Dan, Neftalí. ");
INSERT INTO qub_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Leapa uywaynin Zilpacho cajna caran Gad, Aser. Chay wamrancunaga llapanpis caran Padan-aramcho yurejlla. ");
INSERT INTO qub_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Jacobga aywaran Mamre partiman papänin Isaacta rajaj. Mamrega caycaran Arba siudä ñaupancho. Arbapami jucaj jutin caran Hebrón. Chaychömi Abrahampis unayga tiyaran. ");
INSERT INTO qub_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Pachac pusaj chuncan (180) watayoj caycashancho Isaacga wañuran. ");
INSERT INTO qub_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Wañucorga ñaupa wañoj castancunawan tincojna aywacuran. Wañucuptin wamrancuna Esaüwan Jacob pamparan. ");
INSERT INTO qub_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Caychömi isquirbiraycaran Esaüpita mirajcunapa willapan. Esaüpaga jucaj jutin caran Edom. ");
INSERT INTO qub_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Esaüga majachacaran Cananea warmicunawan: Elón jutiyoj Het runapa wamran Adawan; Heb runa Anäpa wamran Aholibamawan. Payga caran Zibeonpa willcan. ");
INSERT INTO qub_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","Ismaelpa wamran Basematwanpis majachacaran. Basematga caran Nebaiotpa pañin. ");
INSERT INTO qub_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Esaüpa warmin Adacho cäga wamran caran Elifaz. Basematcho cajna caran Reuel. ");
INSERT INTO qub_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Aholibamacho cajna caran Jeús, Jaalam, Coré. Paycunaga Canaán particho Esaú tiyaycaptillanna yuriran. ");
INSERT INTO qub_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Wauguin Jacobpa ñaupancho tiyaycashanpita witicur Esaüga aywacuran llapan warmincunata, wamrancunata, paywan tiyaj runacunatapis pushacurcur. Canaancho tiyar tarishan cajtaga llapanta apacuran. ");
INSERT INTO qub_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Wauguinwan ishcan chay pachallachöga manana tiyayta puydirannachu. Ishcanpa ima-aycanpis aypallana caran. Paycuna tiyashan cajcho manana guewapis ayparannachu uywancuna micunanpaj. ");
INSERT INTO qub_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Chaynöpa Edom jutiyoj Esaú castacunaga llapan aywacuran Seir particho caycaj jircacunaman. ");
INSERT INTO qub_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Esaüga Edom runacunapa unay awilunmi. Edom runacunaga tiyaran Seir particho caycaj jircacunachömi. ");
INSERT INTO qub_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Esaüpa warmin Adacho yuriran Elifaz. Warmin Basematchönami yuriran Reuel. ");
INSERT INTO qub_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Elifazpa wamrancunanami caran: Temán, Omar, Zefo, Gatam, Cenaz. ");
INSERT INTO qub_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Elifazpa uywaycaj warmin Timnachöpis Amalec jutiyoj wamran caran. Chaycunaga llapanpis caran Esaüpa jucaj warmin Adapita mirajcunalla. ");
INSERT INTO qub_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Reuelpa wamrancuna caran: Nahat, Zera, Sama, Miza. Paycunapis caran Esaüpa jucaj warmin Basematpita mirajcuna. ");
INSERT INTO qub_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Esaüpa warmin Aholibamacho caj wamrancuna caran cayno: Jeús, Jaalam, Coré. Aholibamaga caran Anapa wamran, Zibeonpa willcan. ");
INSERT INTO qub_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Esaüpa guechpa wamran Elifazpa wamrancunapis mandaj caran. Paycuna caran Temán, Omar, Zefo, Cenaz, ");
INSERT INTO qub_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","Coré, Gatam, Amalec. Chay mandajcunaga llapanpis caran Elifazpa wamrancunami. Paycuna mandaj caran Edom nasyunchömi. Paycunaga caran Esaüpawan warmin Adapa willcanmi. ");
INSERT INTO qub_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Esaüpa wamran Reuelpa wamrancunapis mandaj caran. Paycuna caran Nahat, Zera, Sama, Miza. Chay mandajcunaga llapanpis caran Esaüpawan warmin Basematpa willcanmi. ");
INSERT INTO qub_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Esaüpa jucaj warmin Aholibamapa wamrancunami mandaj caran. Paycuna caran Jeús, Jaalam, Coré. Aholibamaga Aná jutiyoj runapa wamranmi caran. ");
INSERT INTO qub_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Chay mandajcunaga llapanpis caran Esaú castami. Paycunapita mirajcunami Edom runacuna caycan. ");
INSERT INTO qub_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","21","Edom partiman Esaú manaraj chayaptin chaycho tiyaran Hor runacunami. Paycunaga miraran Seir jutiyoj runapitami. Seirpa wamrancunami caran Lotán, Sobal, Zibeón, Aná, Disón, Ezer, Disán. Paycunami caran Hor runacunapa mandajnincuna. ");
INSERT INTO qub_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Seirpa wamran Lotanpa wamrancunanami caran Horiwan Hemam. Chaynömi Lotanpa pañin caran Timna. ");
INSERT INTO qub_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Sobalpa wamrancunami caran Alván, Manahat, Ebal, Sefo, Onam. ");
INSERT INTO qub_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Zibeonpa wamrancunami caran Ajawan Aná. Taytan Zibeonpa bürruncunata michiycashanchömi Aná tariran pucyuta chaqui jircacho. ");
INSERT INTO qub_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Anäpa wamrancuna caran warmi ollgu. Ollgu cajpa jutin caran Disón, warmi cajpana Aholibama. ");
INSERT INTO qub_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Disonpa wamrancunanami caran Hemdán, Esbán, Itrán, Querán. ");
INSERT INTO qub_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Ezerpa wamrancunami caran Bilhán, Zaaván, Acán. ");
INSERT INTO qub_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Disanpa wamrancunanami caran Uzwan Arán. ");
INSERT INTO qub_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Hor runacunapa mandajnincuna caran Lotán, Sobal, Zibeón, Aná, ");
INSERT INTO qub_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","Disón, Ezer, Disán. Chay runacunaga cada-ünun mandaj caran Hor casta runacunacho. Cada castapa jutenga mandajninpa jutin cashannömi caran. Chay castacunami shuyni-shuyni Seir particho tiyaran. ");
INSERT INTO qub_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Israel nasyuncho ray manaraj captinmi Edom nasyunchöga raycuna caran. Caynömi chay raycuna caran. ");
INSERT INTO qub_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Juc ray caran Beorpa wamran Bela. Belapa marcanmi caran Dinaba. ");
INSERT INTO qub_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Bela wañuptinnami Zerapa wamran Jobab ray caran. Payga caran Bosra marcapitami. ");
INSERT INTO qub_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Jobab wañuptinna paypa ruquin ray caran Husam. Payga caran Temán marcapitami. ");
INSERT INTO qub_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Husam wañuptinnami ruquin ray caran Bedadpa wamran Hadad. Paymi Moab-wichaycho wañuchiran Madián runacunata. Hadadpa marcanmi caran Avit. ");
INSERT INTO qub_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Hadad wañuptinnami ruquin ray caran Samla. Payga caran Masreca marcapitami. ");
INSERT INTO qub_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Samla wañuptinnami ray caran Saúl. Payga caran Éufrates mayu läduncho caycaj Rehobot marcapitami. ");
INSERT INTO qub_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Saúl wañuycuptinnami ray caran Acborpa wamran Baal-hanán. ");
INSERT INTO qub_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Baal-hanán wañuycuptinnami ray caran Hadar. Payga caran Pau siudäpitami. Hadarpa warminpa jutinmi caran Mehetabel. Mehetabelga caran Matred runapa wamranmi, Mezaab runapana willcan. ");
INSERT INTO qub_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Esaüpita mirajcunapa castancunapa mandajnincuna caran Timna, Alva, Jetet, ");
INSERT INTO qub_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","Aholibama, Ela, Pinón, ");
INSERT INTO qub_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","Cenaz, Temán, Mibzar, ");
INSERT INTO qub_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","Magdiel, Iram. Chay mandajcunami tiyashan partichöga mandaran. Chaynöpis chay castacuna tiyashan marcacunaga mandajninpa jutillantami aparan. Llapan chay runacunaga Edom runacunami caycan. ");
INSERT INTO qub_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Jacobnami ichanga tiyacuran papänin tiyashan Canaán partillacho. ");
INSERT INTO qub_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Caychömi isquirbiraycan Jacobpa, wamrancunapa willapan. José chunca ganchis watayoj cashpan papäninpa uyshancunata cabrancunata michej wauguincunawan. Uyshata michej wauguincunaga caran Bilhapawan Zilpapa wamrancunami. Chay warmicunaga caran Josëpa papäninpa uywaycaj warmincunami. Josëga imaypis papäninta willaj chay wauguincuna mana allita rurashantami. ");
INSERT INTO qub_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Israelga wamran Josëta waquin caj wamrancunapita masmi cuyaran auquinna caycaptin pay yurisha captin. Chayno cuyashpanmi cuyayllapaj camaraj tünicanta ruraparan. ");
INSERT INTO qub_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Papänin cuyaptinmi llapan wauguincuna Josëta amatar chiquiran. Chaymi rabyashalla parlapajpis. ");
INSERT INTO qub_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Juc cuticho José suyñuran. Chay suyñushanta wauguincunata willaparan. Chaura wauguincunaga masraj chiquicurcuranpis. ");
INSERT INTO qub_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Willapashpan cayno niran: «Suyñöta masqui willapäshayqui-llapa. ");
INSERT INTO qub_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Suyñushcä rïgu cosëchacho carcaycashanchïta. Rïgu manöjuta llapanchi wancucurcuycashcanchi. Wancurcusha caycaptinchi nogapa cäga quiquillan ichicurcusha. Chaura gamcunapa cäga nogapa cajta intërunpa tumaparar umpurcur-umpurcur rispitaycasha.» ");
INSERT INTO qub_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Chayno willapaptin wauguincuna niran: «¿Chauraga gamchi canquipaj nogacunapa raynë? ¿Gampa munayniquichöchi nogacunaga cashaj?» Chayno suyñuncunata willapaptin wauguincunaga masraj chiquicarcäriran. ");
INSERT INTO qub_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Chaypita yapaypis Josëga suyñuran. Chaytapis wauguincunata willaparan: «Canan suyñushäta masqui willapäshayqui-llapa. Suyñushcä intita quillata chunca juc goyllarcunatawan. Paycuna llapan nogata rispitamashpan umpurcaycasha.» ");
INSERT INTO qub_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Chaynömi Josëga suyñushanta willaparan papänintawan wauguincunata. Chaura papänenga Josëta piñacuran: «¿Gam imatataj yarpanqui nogacunapaj chay suyñushayquiwan? ¿Acäsu nogapis mamayquipis wauguiquicunapis gamta rispitashayquipaj?» nir. ");
INSERT INTO qub_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Chayno willapaptin wauguincunaga fiyupa chiquiran. Papäninmi ichanga yarpachacoj «¿Imapäraj chaynöga wamrä suyñusha?» nishpan. ");
INSERT INTO qub_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Juc cuticho Josëpa wauguincuna aywaran Shequemman papäninpa uyshancunata cabrancunata michej. ");
INSERT INTO qub_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Chaymi Israelga wamran Josëta niran: «Wauguiquicunaga Shequemchömi uyshanchïcunata ricaycan. Aywariycuy. Ricaycamuy imano caycashantapis.» Chayno niptin José niran: «Au papä, aywashaj» nir. ");
INSERT INTO qub_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Chaura papänin niran: «Aywariycuy ari ïju. Ricaycamunqui imano wauguiquicuna caycashantapis, uyshanchïcuna imano caycashantapis. Cutimurnami willamanqui imano carcaycashantapis.» Chayno nirmi wamran Josëta cacharan Hebrón pampacho caycashanpita. Chaura Josëga aywar Shequemman chayaran. ");
INSERT INTO qub_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Chaycho pantacasha puriycaptinna juc runa tarircur Josëta tapuran: «¿Imatataj ashiycanqui?» nir. ");
INSERT INTO qub_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Chaura José niran: «Wauguëcunatami ashiycä. ¿Gam manachu musyanqui maycho wauguëcuna uyshancunawan tiyaycashantapis?» ");
INSERT INTO qub_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Chayno niptin runaga niran: «Caypitaga maynami aywacusha. ‹Dotán partiman aywacuycan› nejtami mayashcä.» Chayno niptin Dotanman aywar wauguincunata tariran. ");
INSERT INTO qub_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Wauguincunaga Josëta rejsiran caruta aywaycajllatana. Manaraj chayaptin parlacuran wañuycärachinanpaj. ");
INSERT INTO qub_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Jucnin-jucnin ninacuran: «Tagä ricay suyñuyninwan musyaj. ");
INSERT INTO qub_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Wañuycärachishun. Nircur pösuman cacharpärishun cuerpun mana taricänanpaj. Papäninchïtaga nishun ‹Jirca animalchari micucurcusha› nir. Chayno ruraptinchi mä suyñushannöchush canga.» ");
INSERT INTO qub_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Chayno parlacuycajta wiyar Rubenga michashpan niran: «Ama wañuchishunchu. ");
INSERT INTO qub_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Ama yawarta mashtashunchu ari. Chaypa ruquenga cay chunyajcho caycaj pösuman wiñarpäriy. ¡Quiquiquicuna ichanga ama wañuchiychu!» Chayno niran Rubenga wauguincunapita Josëta salbayta munar. Yarparan pacayllapa pösupita jorgurcur papäninman «cuticuy» ninanpaj. ");
INSERT INTO qub_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Wauguincuna cajman José chayaycuptin charipäcuran. Lojtiparan papänin rurapashan tünicanta. ");
INSERT INTO qub_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Nircorga wiñarpäriran yacun chaquisha caycaj pösuman. ");
INSERT INTO qub_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Wiñarpärir micur jamacaycäriran. Chaypita ricaran juc röpa Ismael runacuna aywaycämojta. Paycunaga aywaycämuran achca camëlluncunawan nigusyun cargasha. Galaadpita aparcaycaran perfümita, balsamuta, mïrrata. Chaycunataga Egiptumanmi ranticoj apaycaran. ");
INSERT INTO qub_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Chaura Judäga wauguincunata niran: «Noganchi manami imatapis chasquishunpächu wauguinchïta wañucherga. Wañurcacherga ‹Mana musyächu› niytami yarparcaycanchïpis. ");
INSERT INTO qub_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Chaypa ruquenga tagay nigusyanticunata ranticaycärishun. Wañuchinanchïtaga yawar-masinchïmi canpis.» Chayno Judá nishanga wauguincunapaj alli caran. ");
INSERT INTO qub_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Chaura Josëta pösupita jorgarcärir Ismael runacunaman wauguincuna ranticaycäriran. Paycuna pägaran Josëpaj ishcay chunca (20) guellayta. Chaynöpami Josëtaga Egiptuman apacuran. Apaj Ismaelcunaga caran Madianpitami. ");
INSERT INTO qub_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Chaypita pösuman Rubén cutirerga Josëta mana tarirannachu. Mana tarir fiyupa llaquicushpan röpantapis rachiriran. ");
INSERT INTO qub_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Wauguincuna cajman cutiycur paycunata niran: «Chay wiñashayqui pösucho chöluga manami cannachu. ¿Canan imatataj rurashaj?» ");
INSERT INTO qub_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Chaynöpami paycunaga cabra-mallwata pishtariycärir yawarninwan töpachiran Josëta guechushan tünicanman. ");
INSERT INTO qub_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Chayno rurarcärir tünicata papäninman apachiran. Apachir cayno willachiran: «Cay röpata chunyajchömi tarishcäcuna. Mä rejsiy ¿wamrayquipa röpanchush, jucpachush?» nir. ");
INSERT INTO qub_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Wamranpa tünicanta rejsircur Jacobga niran: «¡Cayga wamräpa röpanchaj! Tincuptinchari wamrä Josëtaga jirca animal micucurcusha.» ");
INSERT INTO qub_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Chaura Jacobga jinan öra jatiraycashan röpanta rachiriran. Nircur gachga röpata jaticuran wamranta unaycama lütunanpaj. Wamran wañushanpita unaycama wagallar goyäcuran. ");
INSERT INTO qub_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Llapan wamrancuna warmi caj, ollgu cajpis shogaran. Ichanga mana munaranchu maygan shoganantapis. Wamranpäga amatar wagaj. Chayno wagashpanmi cayno niran: «Wamräta lütushaj imaypis wañunäcamami, wañur tincunäcama.» ");
INSERT INTO qub_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Josëta rantej Madián runacunanami Egiptuman chayaycachir Josëta ranticaycäriran Potifar jutiyoj runaman. Chay runaga caran faraonpa mandaj suldärunmi. Faraonna caran Egipto nasyunpa mandajnin. ");
INSERT INTO qub_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Chay wichan Judäga wauguincunawan iwal tiyaycashanpita shuyniyar aywacuran Hira jutiyoj runapa wasinman paycuna cajcho tiyananpaj. Hiraga Adulam marcapitami caran. ");
INSERT INTO qub_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Chaycho tiyashpanmi Judäga Cananeo runa Shúa jutiyojpa wamranwan majachacaran. ");
INSERT INTO qub_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Chaypita warmi gueshyaj ricacurna ollgu wamrata gueshyacuran. Gueshyacuptin wamrapa jutinta churaparan Er nishpan. ");
INSERT INTO qub_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Yapay ollgu wamran caran. Chay wamranpa jutintana churaparan Onán nishpan. ");
INSERT INTO qub_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Chaypitapis yapay juc wamran caranraj. Chaypa jutintami churaparan Sela nishpan. Chay caj wamranga yuriran Judá Quezib marcacho tiyaycaptinna. ");
INSERT INTO qub_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Judäga guechpa caj wamran Erta majacharan Tamar jutiyoj warmiwan. ");
INSERT INTO qub_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Ichanga Tayta Dios ricaptin Er caran juchayoj runa. Chaymi Tayta Diosga camacächiran pay wañunanpaj. ");
INSERT INTO qub_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Chaura, Judäga Erpa shullcan Onantana niran: «Wauguiquipa biyüdanwan gamna tiyay. Chaura paycho yurej wamrayqui canga wauguiquipa wamrannöna. Chaynöpami wauguiquipa jutinpis mana gongacangachu.» ");
INSERT INTO qub_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Onán musyaran wamran cashpanpis paypa jutinta mana apananpaj cashanta. Chaymi wauguinpa biyüdanwan cacushan öra jorgurir jawaman juturachej. Onanga chayno ruraran wamran yurir wauguinpa jutinta apananta mana munarmi. ");
INSERT INTO qub_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Chayno Onán rurashan Tayta Diospäga mana alli caran. Chaymi paypis wañunanpaj Tayta Dios camacächiran. ");
INSERT INTO qub_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Ishcay caj wamrancuna chayno wañuptin Judäga yarparan wamran Selapis Tamarwan cacushpan wañunanpaj cashanta. Chaymi Judäga wamran Selawan tiyachiyta mana munar yachayllapa Tamarta cayno niran: «Wamrä Sela mösuyashancama taytayquipa wasincho biyüdalla cacuy.» Suyrun chayno niptin Tamarga cuticuran taytanpa wasinman. ");
INSERT INTO qub_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Chaypita unayllataga Judäpa warmin wañuran. Wañuptin lüturan. Warminta lütuyta cumlircurnami aywaran Timnat marcaman. Chaychömi uyshëruncuna millwa rutuycho carcaycaran. Chayman aywaptinmi rejsinacushan Adulam marca runa amïgun Hira jutiyoj Judäta aywäshiran. ");
INSERT INTO qub_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Tamarta willaran suyrun Judá millwa rutoj Timnat marcaman aywaycashanta. ");
INSERT INTO qub_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Musyarmi biyüda cay röpanta rucacuriycur shucutacunanta shucutacurcuran mana rejsinanpaj. Nircur aywar jamacuycuran Enaim marcaman yaycuna näniman. Chayga caran Timnat marcaman aywana näni aywajcho. Chayno Tamarga ruraran Sela rucuna caycaptin suyrun Judá paywan mana tiyachiptin. ");
INSERT INTO qub_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Cäran chapasha warmi jamaraycajta ricar Judäga yarparan guellay casha runata chasquej warmi cashanta. ");
INSERT INTO qub_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Warmita ricar näninpa aywaycashanpita aywaran warmi cajman. Llumchuynin cashanta mana musyashpan cayno parlaparan: «¿Gamwan cacushwanchu u manachu?» nir. Chayno niptin warmi niran: «¿Imatataj pägamanquiman gamwan cacushaga?» ");
INSERT INTO qub_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Chaymi Judäga niran: «Uyshäcuna cajpita juc cabra-mallwata apachimushayqui» nir. Chaura warmi niran: «Ichanga rasunpa apachimänayquicama imallayquitapis jaguipämay.» ");
INSERT INTO qub_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Chayno niptin Judá tapuran: «¿Imata jaguipänätataj munanqui?» Chaura warmiga niran: «Sëlluyquita watuntinta, aptaraycashayqui bastunniquitawan.» Chayno niptin Judäga nishancunata aptaparan. Nircur chay warmiwan cacuran. Chay cajllana warmiga gueshyaj ricacuran. ");
INSERT INTO qub_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Nircur Tamarga wasinman cutiycur shucutacushanta jorgurir biyüda cay röpantana jaticuran. ");
INSERT INTO qub_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Chaypita Judäga amïgun Adulam runawan apachiran cabra-mallwata warmi chasquircur Judäpata quëdachishancunata cutiycachinanpaj. Cabra-mallwata apaj runaga chay warmita mana tarirannachu. ");
INSERT INTO qub_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Chaura chay marcacho tiyaj runacunata tapucuran: «¿Maytaj cay Enaimcho guellaypaj runata chasquej warmi, näni päsana ñaupancho caycaj?» nir. Chayno tapucuptin chaycho tiyaj runacunaga niran: «Caychöga manami cashachu guellaypaj runata chasquej warmiga.» ");
INSERT INTO qub_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Chayno runacuna niptin Judá cajman cutiycur willaran: «Chay warmita manami tarishcächu. Nircur chaycho tiyaj runacunapis willamasha ‹Caychöga pï warmipis guellaypaj runata chasquej manami tiyanchu› nirmi». ");
INSERT INTO qub_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Chaura Judá niran: «Chauraga jina apacuchunpis. Chaypa tapucachashaga runacunapis asipämashwanmi. Nogaga cabra-mallwata apachishcämi. Ichanga gam aywar mana tarishcanquichu.» ");
INSERT INTO qub_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Chaypita quimsa quillatano Judäman runacuna shamuran willananpaj: «Llumchuyniqui Tamarga juc runawanmi cacusha. Cananga gueshyajnami caycan» nir. Chaura Judäga niran: «¡Wasinpita jawaman jorgurcur rupaycärachiy!» ");
INSERT INTO qub_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Wañuchinanpaj aparcaycaptin warmiga suyrun Judäta willachiran cayno nishpan: «Cay charaycashäcunapa duyñunpatami gueshyaj caycä. ¡Mä rejsiy! Mä pipashi cay sëlluga watuntin chayno cay bastunpis.» ");
INSERT INTO qub_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Chaura Judäga rejsircur niran: «¡Payga manami juchayojchu! Nogami ichanga juchayoj cä wamrä Selawan mana majachashäpita.» Y chaypitaga Judá manana masga imaypis llumchuyninwan cacurannachu. ");
INSERT INTO qub_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Gueshyacushpan Tamarga gueshyacuran millishta. ");
INSERT INTO qub_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Yuriyta ñacaycashancho juc cäga maquinta jorgaramuran. Chaura partëraga puca jïluwan maquinta wataparcur niran: «Cay cajmi rimëru llojshimusha.» ");
INSERT INTO qub_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Ichanga jinan öra maquinta cutichicurcuran. Yurirnaga rimëru yuriran wauguin caj. Chaymi partëraga niran «¡Imanöparaj cayga ñaupanpa päsamusha!» nir. Chaypitami jutinta churaparan Fares nir. ");
INSERT INTO qub_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Guepantaraj yuriran puca jïluwan maquin watasha cäga. Chaypa jutinta churaparan Zera nishpan. ");
INSERT INTO qub_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Josëta rantej Ismael nigusyanticunaga Egiptuman chayachiran. Chaychöna ranticuycuran Potifar jutiyoj runaman. Potifarga caran faraonpa suldäruncunapa mandaj capitannin. ");
INSERT INTO qub_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Tayta Diosga Josëwan imaypis caycaran. Chaymi Egiptucho patrunninpa wasincho tiyaptin ima rurashanpis llapan alli caran. ");
INSERT INTO qub_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Chaura patrunnin musyaran Josëwan Tayta Dios caycashanta. ");
INSERT INTO qub_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Llapan rurashanpis alli captinmi Josëtaga patrunnin amatar cuyaran. Chaynöpami Josëtaga patrunnin churaran wasincho pay capuralnin cananpaj. Llapan charashan cajcunataga Josëpa munayninmanna cachaycuran. ");
INSERT INTO qub_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Josëpa munayninman Potifar llapan charashanta cachaycushan junajpita-pacha Tayta Diosga Potifarta imachöpis mas allina yanaparan. Chaymi ima-aycanpis achcayaran. Micuyninpis sumaj wayuran. ");
INSERT INTO qub_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Potifarpa wasincho José captenga Potifar manana imanpäpis yarparajnachu. Josëga caran camaraj mösu. ");
INSERT INTO qub_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Chaymi unaycamana José tiyarcuptin patrunninpa warmenga paywan cacuyta munaran. Chaymi juc junajcho Josëta niran: «Nogawan cacushun» nir. ");
INSERT INTO qub_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Chaura Josëga mana munashpan niran: «Patrunnëga llapantami caycho cajta ricanäpaj nogata cachapämasha. Noga caycho captëga wasincho ima ruraynin captinpis manami yarparänan canchu. ");
INSERT INTO qub_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Cay wasincho cajta llapanta ricanäpämi cachapämasha. Gamtawan-camami ichanga mana cachapämashachu. Chayno caycaptenga ¿imanöpataj mana allitaga patrunnëpa contran ruraycöman? ¿Imanöpataj Diospa contran ruraycöman?» ");
INSERT INTO qub_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Patrunninpa warmenga waran-waranmi Josëta gatiraj «Nogawan cacushun» nishpan. Patrunninpa warmenga munaj ñaupallancho José caycänanta. Ichanga José mana cäsupajchu. ");
INSERT INTO qub_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Juc junajcho Josëga wasiman yaycuran imapis ruraynincunata rurananpaj. Chay öraga chay wasicho mana pipis caranchu. ");
INSERT INTO qub_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Chaymi patrunninpa warmenga Josëpa röpanpita charircur niran: «Canan nogawan cacushun» nir. Chaura Josëga röpanta cachariycur cörriyllapa wasipita llojshiriycuran. Chaura warmiga Josëpa röpanta aptaraycar quëdacuran. ");
INSERT INTO qub_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","José chayno röpanta cachariycur cörriylla aywacuptin ");
INSERT INTO qub_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","jinan öra gayacuran waquin caj uywaynincunata cayno nir: «¡Masqui ricay! Hebreo runata rantircur runä apapämashcanchi burlacamänanchïpaj. Charipacamayta munasha. Chaura gayacushcä llapan callpäpa. ");
INSERT INTO qub_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Chaymi payga cörriyllapa gueshpir shacamusha röpantapis cachariycur.» ");
INSERT INTO qub_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Chaypita Josëpa röpanta chay warmi churaran runan chayamunancama. ");
INSERT INTO qub_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Uywaynincunata willashannölla runan chayamuptinpis willaran: «Chay rantishayqui hebreo runaga cuartöman yaycaycamur charipacamayta munamasha. ");
INSERT INTO qub_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Chaura nogaga llapan callpäpa gaparashcä. Chaymi caycho röpanta cachariycur gueshpir llojshiraycamusha. ");
INSERT INTO qub_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Chay uywayniquega chaynömi ruramasha.» Chayno willapashanta wiyaycur Josëpa patrunnenga fiyupa rabyaran. ");
INSERT INTO qub_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Chaymi Josëta charircorga faraonta sirbejcunalla wichgaraycashan carsilman wichgachiran. Carsilcho captinpis ");
INSERT INTO qub_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Tayta Dios Josëwan carmi imachöpis yanaparan. Chaynöpami carsilcho cuydaj runapis payta alli ricaran. ");
INSERT INTO qub_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Chaura carsilcho cuydäga llapan prësucunata Josëpa munayninman jaguiparan. Chaymi Josëna mandaj imatapis chaycho rurananpaj cajtaga. ");
INSERT INTO qub_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Josëwan Tayta Dios captinmi paytaga ima rurashanpis alli llojshipaj. Chaymi Josëpa maquincho cajtaga carsilcho cuydaj runa mana yarparajnachu. ");
INSERT INTO qub_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Chaypita unayllataga Egiptupa mandajnin faraonman bïnuta apapajwan tantata ruräga mandajnin faraonpa contran ruraran. ");
INSERT INTO qub_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Chaymi faraonga fiyupa rabyaran chay ishcan mandajcunapaj. ");
INSERT INTO qub_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","Chaynöpami paycunataga prësu apachiran suldärucunapa capitanninpa wasincho caycaj carsilman. Josëpis chay carsilcho caycaran. ");
INSERT INTO qub_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Chaura chay capitanga Josëta niran chay runacunata ricananpaj. Chay runacunapis unaycama carsilcho goyaran. ");
INSERT INTO qub_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Juc chacay faraonta bïnu apapajwan, tantata ruräga cada-ünun jucnöta-cama suyñuran. Cada-ünun suyñuran quiquincuna imanöpis cananpaj. ");
INSERT INTO qub_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Tuta ricaj aywar José tariran llaquisha carcaycajta. ");
INSERT INTO qub_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Chaura Josëga tapuran: «¿Imanirtaj gamcunaga fiyupa llaquisha carcaycanqui?» nir. ");
INSERT INTO qub_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Chayno niptin paycuna niran: «Suyñushcäcunami. Caychöga manami pipis canchu chay suyñöcuna imapaj cashantapis willapämänanpaj.» Chayno niptin José niran: «¡Suyñucunataga Tayta Diosllami musyachimanchi imapaj cashantapis! Mä imata suyñushayquitapis nogata willapämay.» ");
INSERT INTO qub_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Chaura faraonman bïnuta apapaj runaga Josëta cayno willaparan: «Nogaga suyñuynëcho ricashcä übas yöratami. ");
INSERT INTO qub_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","Chay übas yöra caycasha quimsa rämayoj. Chay rämacuna chillguircur juclla waytasha. Nircur waytancuna ticracurisha pogusha übasmanna. ");
INSERT INTO qub_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Nogana aptaraycashcä faraonpa bäsunta. Chay aptaraycashä bäsuman übasta gapchircur faraonta macyaycashcä.» ");
INSERT INTO qub_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Chayno willapaptin José niran: «Gampa suyñuyquega cayno cananpämi: Quimsa rämacunaga quimsa junajmi. ");
INSERT INTO qub_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Faraonmi cananpita quimsa junajta cay carsilpita gamta jorgushunquipaj. Nircurmi cashgan churashunquipaj ñaupata arushayquiman. Chaura ñaupatanömi yapay faraonman bïnuta apapanquipaj. ");
INSERT INTO qub_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Noga nishäno llapan captenga nogata yarpämanqui ari. Faraonta ruwaycunqui noga cay carsilpita llojshinäpaj. ");
INSERT INTO qub_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Nogataga hebreo runacuna tiyashanpitami suwaypa apamaran. Manami ima mana allitapis rurashcächu carsilcho canäpäga.» ");
INSERT INTO qub_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Jucninpa suyñunta allitano willaptin tanta rurajpis Josëta niran: «Caynömi nogaga suyñushcä: Umä janancho chararaycashcä yurajlla tantata quimsa balay canastacunawan. ");
INSERT INTO qub_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Janan cajchöna caycasha faraón micunanpaj tucuy-niraj pastilcuna. Ichanga achca äbicuna aywarcamurmi chay balay canastapita micurcaycasha.» ");
INSERT INTO qub_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Chaura José niran: «Gampa suyñuyquega cayno cananpämi: Quimsa balay canastacunaga quimsa junajmi. ");
INSERT INTO qub_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Cananpita quimsa junajtami gamtaga guerucho faraón matichishunquipaj. Guerucho warcuraptiquimi äbicuna shamonga aychayquita micunanpaj.» ");
INSERT INTO qub_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Chay suyñushancunata José willapashanpita quimsa junajtaga faraonpa diyan caran. Chaura faraonga fistata ruraran llapan chaycho aroj runacunawan goturänanpaj. Llapan runacunawan goturpaycashancho carsilpita apachimuran tantata rurajpa y faraonman bïnuta apapajpa mandajnincunata. ");
INSERT INTO qub_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Bïnuta faraonman apapajtaga cutichiran ñaupata arushanman. Chauraga faraonman yapay bïnuta apaparan. ");
INSERT INTO qub_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Tanta rurajtanami ichanga José willapashannölla matichishpan warcuchiran. ");
INSERT INTO qub_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Chaypis faraonman bïnuta apapäga Josëta mana yarparanchu. ");
INSERT INTO qub_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Chaypita ishcay watata faraón suyñuran. Suyñuynincho pay ichiraycaran Nilo mayu cantuncho. ");
INSERT INTO qub_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Ichiraycashancho ricaran Nilo mayupita ganchis wera wäcacuna llojshimojta. Llojshircur wäcacunaga mayu cantuncho guewata micurcaycaran. ");
INSERT INTO qub_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Chay wera wäcacunapa guepantanami llojshimuran pasaypa uyu melanaypaj ganchis wäcacuna. Nircur chaycunapis ichicaycäriran wera wäcacunapa ñaupanman. ");
INSERT INTO qub_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Chaypitaga uyu tullullan wäcacuna micucarcäriran chay wera wäcacunata. Chayta suyñuycashanpita faraonga riccharaycamuran. ");
INSERT INTO qub_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Nircur yapay puñucäcuran. Chaychöpis yapay suyñuran. Ricaran juc yörallapita ganchis pallga rïgucuna wiñaycajta. Chaura ispïjacuna caran cuyayllapaj jatusaj. ");
INSERT INTO qub_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Chay alli ispïjayoj rïgucuna wiñamushan sapinpita chillguimusha yapay ganchis pallga mana alli rïgucuna. Chay rïgucunaga caran chunyajpita shamoj wayrawan chaquisha. ");
INSERT INTO qub_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Chay shanaywan yur'gaypa chaquisha rupatasha ispïjacunaga micucurcuran achca wayuyniyoj cuyayllapaj ispïjacunata. Chayta suyñuycashanpita faraonga riccharaycamuran. Tantiyacuriran suyñuynincho ricashanta. ");
INSERT INTO qub_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Chay suyñushan tutaga fiyupa yarpachacuran. Chayno yarpachacurmi gayachimuran Egipto nasyuncho cajtaga llapan musyacojcunata, yachajcunata pay cajman shamunanpaj. Llapan chayamuptin suyñushanta faraón willaparan. Manami maygan musyacojcunapis musyaranchu chay suyñun imapaj cashantapis. ");
INSERT INTO qub_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Chayrämi faraonman bïnuta apapäga niran: «Cananrämi yarpärë carsilcho wichgarashäta. ");
INSERT INTO qub_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Tayta faraón, gam fiyupa rabyashpayquimi nogatawan tanta rurajta apachimarayqui capitanpa wasincho caycaj carsilman. ");
INSERT INTO qub_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Chay carsilchömi juc chacay tanta ruraj suyñuran. Chayno nogapis suyñurä. Cada-ünöpa suyñöcuna caran imanöpis quiquëcuna canäpaj. ");
INSERT INTO qub_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Chay carsilchömi juc hebreo mösuwan iwal carä. Payga caran capitanpa uywaynin. Chay mösutami nogacunaga willaparä imata imano suyñushatapis. Chaura paynami willamaran ima päsamänanpaj suyñöcuna cashantapis. ");
INSERT INTO qub_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Chaypitaga llapanpis caran pay willamashannölla. Noga cutirä arushäman. Tanta rurajtana warcuchirayqui.» ");
INSERT INTO qub_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Chayno willaycuptin faraonga carsilpita Josëta jinan öra jorgachimuran. Carsilpita jorgaramuptin Josëga shapranta afitacuran. Röpanta rucacurir faraón cajman aywaran. ");
INSERT INTO qub_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Chaura Josëta faraón cayno niran: «Noga suyñushäta pipis manami imapaj cashantapis tantiyayta camäpacushachu. Gampämi mayashcä suyñushancunata willapäshuptiquega imapaj cashantapis musyar willashayquita.» ");
INSERT INTO qub_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Chayno niptin José niran: «Manami nogachu musyä suyñucuna imapaj cashantapis. Chaypa ruquenga Diosmi tantiyachiman. Pay yarpayta gomaptinrämi nogaga gamta willashayqui imapaj suyñuyqui cashantapis.» ");
INSERT INTO qub_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Chayno niptin faraonga Josëta cayno willaparan: «Suyñuynëcho ichiraycashcä Nilo mayu cantuncho. ");
INSERT INTO qub_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","Chaycho caycaptëmi mayupita llojshimusha ganchis wera wäcacuna. Llojshircamorga micurcaycasha ututucuna chaupincho. ");
INSERT INTO qub_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Chaypita guepanta yapay llojshimusha ganchis wäcacuna pasaypa uyu melanaypaj. Cay Egipto nasyunchöga chayno melanaypaj wäcacunata manami imaypis ricashcächu. ");
INSERT INTO qub_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Chay uyu melanaypaj wäcacunaga micucurcusha wera wäcacunata. ");
INSERT INTO qub_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Micucurcurpis chay wäcacunaga manami allchacashachu. Melanaypaj uyu cashannölla carcaycasha. Chayta suyñuycashäpita riccharaycamushcä. ");
INSERT INTO qub_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","«Puñucäcur yapay suyñushcä. Chaycho ricashcä juc rïgu yörallapita ganchis pallga rïgucuna alli wayuyniyoj caycajta. ");
INSERT INTO qub_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Chaypa guepantana yapay wiñamusha ganchis pallga ispïja pasaypa chaquisha gashchulla, chunyajpita shamoj wayrawan rupatasha. ");
INSERT INTO qub_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Chay chaquisha ispïjacuna, micucurcusha ñaupata alli wiñamoj rïgu ispïjacunata. Chayno suyñushäcunatami nogaga willapashcä llapan musyacojcunata. Ichanga manami mayganpis tantiyashachu chay suyñushä imapaj cashantapis.» ");
INSERT INTO qub_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Chayno willapaycuptin Josëga faraonta cayno niran: «Ishcan suyñushayquipis juc suyñunöllami caycan. Gamtaga Diosmi ricachisha-cashunqui pay imano rurananpaj caycashantapis. ");
INSERT INTO qub_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Chay ganchis alli wäcacunaga ganchis watami. Chayno chay ganchis alli wayuyniyoj wiñamoj alli ispïja rïgucunapis ganchis watallami. ");
INSERT INTO qub_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Waquin wäcacunapa guepanta llojshimoj uyu melanaypaj wäcacunapis yapay ganchis watapänami. Chayno waquinpa guepanpa wiñamoj yur'gasha rupatasha gashchu ispïjapis yapay ganchis watapämi. Chaycunaga ishcanpis caycan ganchis wata muchuy canallanpämi. ");
INSERT INTO qub_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","«Cay willashäcunaga llapanpis nishänömi cangapaj. Diosmi gamta musyachisha-cashunqui imano rurananpaj caycashantapis. ");
INSERT INTO qub_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Ganchis watami intëru Egipto nasyuncho ima-ayca micuypis fiyupa wayongapaj. ");
INSERT INTO qub_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Chaypita yapay ganchis wata cajchömi ichanga fiyupa muchuy cangapaj. Cay Egipto nasyuncho micuy fiyupa wayushanta manami pipis yarpangapächu. Chay muchuywanga manami imapis cangapächu. ");
INSERT INTO qub_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Fiyupa muchuy captinmi amatar micuy wayushanpis mana imallanpis quëdangapächu. ");
INSERT INTO qub_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Gamga ishcay cutipis suyñushcanqui rasunpa chayno cananpaj cajtami. Diosmi chayno rurananpaj caycan. Manapis aycällatanami ruranga. ");
INSERT INTO qub_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","«Manaraj chayno captin gam ashinquiman juc runata musyaj-yachajta. Chay runatana numranquiman cay Egipto nasyuncho imatapis rurachinanpaj. ");
INSERT INTO qub_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Chaynöpis intëru Egiptuman churanquiman achca gobernadorcunata. Paycunana nasyuncho micuy wayojta shuntachenga. Ganchis wata micuy amatar wayushan wichan cada pichga arröba rïgupita juc arröbata-cama shuntachimunqui. ");
INSERT INTO qub_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Chay shuntashantaga llapanpis churanga gampa munayniquicho cananpaj. Siudäcunaman churanga muchuy captin chayta micur runacuna cawananpaj. ");
INSERT INTO qub_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Chayno churaycuptin rïguga churaräconga ganchis wata muchuy captin cay nasyuncho yargaywan runacuna mana wañunanpämi.» ");
INSERT INTO qub_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","José chayno nishan alli caran faraonpaj, waquin autoridänincunapäpis. ");
INSERT INTO qub_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Chaymi faraonga autoridänincunata niran: «¿Juc runata tarishwanchuraj paytano Dios yanapaptin alli yarpayniyojta?» nir. ");
INSERT INTO qub_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Nircur Josëta faraón niran: «Gamtaga Diosmi llapan chaycunata musyachisha-cashunqui. Chaymi cay nasyunchöga gampita mas musyaj-yachaj runa mana canchu. ");
INSERT INTO qub_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Cananpitaga cay nasyuncho marcacunacho tiyaj llapan runacunapis gam nishayquitami imatapis ruranga. Cay palasyöcho cajtapis gampa munayniquimanmi churä. Nogallami gampita masga cashaj cay nasyunpa mandajnin caynëpa. ");
INSERT INTO qub_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Gamtami canan öra churä intëru Egipto nasyunta mandanayquipaj.» ");
INSERT INTO qub_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Chayno nirmi faraonga dëduncho jatiraycashan mandaj car sëllucuna surtïjanta jorgurir Josëta jatiparcuran. Nircorga uywaynincunata niran fïnu lïnu tëlapita rurasha röpata Josëta jatipänanpaj, gori wallgatapis wallgapänanpaj. ");
INSERT INTO qub_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Nircur wichächiran faraonpa guepanta aywaj carrëtanman. José maypa aywaptinpis runacuna cayno gaparpaj: «¡Paypa ñaupanman gongurpacuy!» nir. Chaynömi Josëtaga churaran llapan Egipto runacunapa mandajnin cananpaj. ");
INSERT INTO qub_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Chaypitanaga Josëta faraón niran: «Cay Egiptucho noga faraón captëpis manami pipis manaraj gam nishayquiyäga imatapis rurangachu.» ");
INSERT INTO qub_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Faraonga Josëta jinan Egipto jutitana churaparan Zafnat-panea nir. Nircur majacharan Asenat jutiyoj warmiwan. Chay warmiga caran On siudächo tiyaj cüra Potiferapa wamran. Chaynömi Josëga Egiptupa mandajnin ricacuran. ");
INSERT INTO qub_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Carsilpita jorgurcur faraonpa ñaupanman pushashan öra Josëga caycaran quimsa chunca (30) watayoj. Faraón cajpita aywacur Josëga intëru Egiptupa puriyta gallaycuran. ");
INSERT INTO qub_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Chay wata shamojpita ganchis watacama intëru Egipto nasyuncho micuy amatar wayuran. ");
INSERT INTO qub_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Chaura Josëga micuy alli wayushan wichan ganchis watantin micuyta shuntachiran. Chacrapita shuntashanta churachiran jinan siudäcunaman. Chauraga llapan siudäcunacho aypalla micuy churaraycaran. ");
INSERT INTO qub_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Lamar cantuncho agu goturäcojtanöraj Josëga rïguta shuntachiran. Aypalla captinmi manana tupurannapischu. ");
INSERT INTO qub_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Manaraj muchuy gallariptin Josëpawan warmin Asenatpa wamrancuna caran ishcayna. ");
INSERT INTO qub_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","«Diosmi yanapämasha llapan castäcunata imano ñacashätapis mana yarparaycänäpaj» nirmi Josëga rimir caj wamranpa jutinta churaparan Manasés nir. ");
INSERT INTO qub_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Jucaj wamran yuriptinnami «Amatar ñacashä nasyunchömi Dios munasha wamrayoj canäta» nishpan jutinta churaparan Efraín nir. ");
INSERT INTO qub_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Ganchis wata fiyupa micuy wayurcur Egiptuchöga mana wayurannachu. ");
INSERT INTO qub_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","José nishanno muchuy caj ganchis watana gallaycuran. Chaura intëru nasyuncunachöna fiyupa muchuy caycaran. Egiptullachöna micuyga caycaran. ");
INSERT INTO qub_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Egipto nasyuncho tiyajcuna micunanpaj manana captin llapan runacuna aywaran faraón cajman micuy mañacoj. Chaura faraonga llapan Egipto runacunata niran: «Josëman ayway. Nircur pay nishushayquino ruray.» ");
INSERT INTO qub_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Intëru Egipto nasyuncho muchuy captin waranllanta waranllantana fiyupa yargay caran. Chaymi Josëga quichachiran micuyta churachishan wasicunata. Nircur Egipto runacunata rïguta ranticuran. ");
INSERT INTO qub_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Juc-lä nasyuncunachöpis manami micuy caranchu. Chaymi intëru nasyuncunapita Egipto nasyunman shamuran Josëta «Rïguta ranticamay» ninanpaj. ");
INSERT INTO qub_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Egipto nasyuncho rïgu rantipaj caycashanta mayar Jacobga wamrancunata niran: «Gamcuna ¿imatataj rurarcaycanqui jucniqui-jucniqui ricapänacur? ");
INSERT INTO qub_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Nogaga mayashcä Egiptucho rïgu rantipaj caycashantami. Gamcunapis ayway. Rantimunqui chayta micur cawananchïpaj. Mana aywaptiquega ¿imata micurtaj cawashun?» ");
INSERT INTO qub_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Chayno niptin Josëpa chunca wauguincuna Egiptuman aywaran rïgu rantej. ");
INSERT INTO qub_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Papänin Jacob mana munaranchu Josëpa shullcan Benjamín wauguincunawan aywanantaga. Yarparan imapis päsananta. ");
INSERT INTO qub_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Israelpa wamrancunaga aywaran rïgu rantej aywaj runacunawan iwal. Chaynöga aywaran intëru Canaán nasyunchöpis fiyupana muchuy captinmi. ");
INSERT INTO qub_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Egipto nasyun Josëpa munaynincho captinmi intërupita payman chayaj rïgu rantej. Chaymi Josëpa ñaupanman chayaycur wauguincunapis rispitashpan umpuran urcunpis pampaman töpanancama. ");
INSERT INTO qub_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Josëga wauguincunata ricärishpan juclla rejsircuran. Ichanga mana rejsej-tucuranchu. Chaymi fiyu shiminpa tapuran: «Gamcunaga ¿maypitataj shamushcanqui?» nishpan. Chaura paycunaga niran: «Nogacunaga Canaán partipitami shamushcä rïgu rantej tayta.» ");
INSERT INTO qub_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Paycunaga Josëta mana rejsiranchu, José rejsiycaptinpis. ");
INSERT INTO qub_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Chay örami Josëga yarpäriran paycunapaj imano suyñushantapis. Chaymi niran: «Gamcunaga ricapacojmi canqui. Cay nasyunman yaycamunayquipaj maypa alli cashantapis ricapacojmi shamushcanqui.» ");
INSERT INTO qub_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Chayno niptin paycunaga ruwacur niran: «Manami tayta. Nogacunaga rïgu rantejllami shamushcä. ");
INSERT INTO qub_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Llapanëpis juc taytapa wamrallanmi cä. Alli runacunami cä. Nogacunaga manami juc nasyuncunata ricapacur purëchu.» ");
INSERT INTO qub_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Chayno niptin yapay José niran: «Manami chaynöchu. Gamcunaga shamushcanqui maypa cay nasyunman yaycamunayquipäpis alli cashanta ricapacojmi.» ");
INSERT INTO qub_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Chayno niptin wauguincunaga niran: «Nogacunaga cä chunca ishcay (12) wauguimi juc taytapa wamrallan. Llapanëpis tiyä Canaán partichömi. Shullca caj wauguëga papänëwanmi quëdamusha. Mas jucmi ichanga illgasha.» ");
INSERT INTO qub_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Chaypis Josëga yapay niran: «Näga nishänöpis gamcunaga rasunpami ricapacoj shamushcanqui. ");
INSERT INTO qub_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Gamcuna imano cashayquitapis cananmi musyashun. Shullca wauguiqui cayman manaraj chayamushancamaga gamcuna manami mayganiquipis caypita llojshinquichu. Chaytaga faraonpa jutincho jurarmi në. ");
INSERT INTO qub_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Mayganiquipis jucnaylla cutiy ñuñush wauguiquita pushamoj. Waquinniquega caychömi prësu quëdanqui. Cananmi musyashaj gamcuna nishayqui rasunpa cashanta. Nishayqui mana rasunpa captin gamcunaga nishäno rasunpami ricapacoj canqui. Chaytaga faraonpa jutinchömi jurä.» ");
INSERT INTO qub_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Josëga llapanta quimsa junaj prësu wichgarächiran. ");
INSERT INTO qub_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Chaypitana paycunataga José niran: «Nogaga Diostami rispitä. Gamcunaga mana wañunayquipaj cayno ruray: ");
INSERT INTO qub_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Rasunpa alli runacuna cashpayquega cay carsilcho juc wauguiquita jaguiy. Waquinniquega cutinqui famillyayquicuna micunanpaj micuyta apacarcärir. ");
INSERT INTO qub_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Nircur shullcayquita pushamunqui nishayquino rasunpa cashanta riguinäpaj. Chayno rurar manami wañunquipächu.» José chayno niptin paycunaga auniran. ");
INSERT INTO qub_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Ichanga quiquin-pura cayno ninacurcaycaran: «Cananga wauguinchïta mana allita rurashanchïpitami castïgu chayaycämanchi. Noganchëga fiyupa llaquicuycajta ricaycarpis wauguinchïta manami cuyaparanchïchu. Ruwamashapis manami cäsuranchïchu.» ");
INSERT INTO qub_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Chayno ninacuptin Rubenga paycunata niran: «Nogaga micharämi wamrata mana yatapänayquipaj. Chaypis gamcunaga manami wiyamarayquichu. Cananga chaypitami castïgu chayaycämanchi.» ");
INSERT INTO qub_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Josëga paycunawan parlaycaran juc tantiyachejllawanmi. Chaymi mana musyaranchu paycuna parlaycashanta José tantiyaycashanta. ");
INSERT INTO qub_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Josëga paycunapita juc-läman aywarcur wagaran. Wagashanpita cutiycur paycunapita juc-läman jorguran Simeonta. Nircur waquin wauguincuna ricapaycaptin wascanwan liyachiran. ");
INSERT INTO qub_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Chaypitaga niran llapanta custalnincunaman rïguta wiñapänanpaj, pägashan guellaynincunatapis cada ünunpa custalnincunaman cutirgärachinanpaj. Nircur niran mircapanpäpis micuyta gonanpaj. Chaura uywaynincunaga José nishanno ruraran. ");
INSERT INTO qub_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Chaura paycunaga bürruncunaman rïguta cargacarcärir cuticuran. ");
INSERT INTO qub_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Cuticurcaycashancho tardiyar juc pachaman cargancunata pascaran. Chaycho jucga custalninpa shiminta pascaran bürrunta garananpaj. Quicharcushanchöga guellayninta tariran. ");
INSERT INTO qub_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Chayno tarircur wauguincunata niran: «Pägashä guellaynëta custalnëman wiñarcamusha. Masqui ricay-llapa. Cay custalnëcho caycan.» Chaura paycunaga imata yarpachacuytapis mana camäpacuranchu. Chaymi jucnin-jucnin ninacuran: «¿Ima-aycamantaj Tayta Diosga jitarpamanchi?» nir. ");
INSERT INTO qub_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Canaanman chayaycärir papänin Jacobtaga llapallanta willaparan Egiptucho imano cashantapis. Chaymi niran: ");
INSERT INTO qub_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","«Chay nasyunpa mandajnenga rabyashami parlapämashacuna. Nogacunataga nimasha ‹nasyunnëman ricapacoj shamushcanqui› nirmi. ");
INSERT INTO qub_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Chaura nogacunaga willashcäcuna alli runacuna cashäta, imaypis mana ricapacoj cashäta. ");
INSERT INTO qub_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Chaynöpis willashcä juc taytapa wamrancunalla chunca ishcay waugui cashäta, jucga illgashantana, mas shullca caj wauguëna cay Canaancho gamwan carcaycashantapis. ");
INSERT INTO qub_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","«Chaura chay mandäga nimasha: ‹Nogaga caynöpami musyashaj gamcuna alli runa cashayquita: Juc wauguiquita caycho jaguiy. Waquinniquicunanami cutinqui castayquicuna micunanpaj micuyta apacarcärir. ");
INSERT INTO qub_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Shullca caj wauguiquita cayman pushamunqui. Chayrämi musyashaj rasunpa alli runacuna cashayquita. Chauraga jucaj wauguiquipis prësu caycashanpita llojshenga. Gamcunapis cay nasyuncho alli puricunquipaj› nir.» ");
INSERT INTO qub_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Custalnincunata tallishanchöraj cada-ünunpa custalnincunacho paycunaga guellaynincunata tariran. Bolsacho wiñasha caycajta guellaynincunata tariycärir papänintin fiyupa manchacäcuran. ");
INSERT INTO qub_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Chaypita Jacobga wamrancunata niran: «Gamcunaga nogata cachaycämanqui wamraynajllatanami. Cananga noganchïwan mana cannachu Josëpis ni Simeonpis. Cananga Benjamintana guechumaj-aywanqui. Imapis nogapäga manami allinachu.» ");
INSERT INTO qub_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Niptin Rubenga niran: «Benjamintaga nogami pushashaj; nogami cutichimushaj. Wamrayquita mana cutichimuptëga ishcan wamräta wañuycachinqui.» ");
INSERT INTO qub_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Chaura Jacobga niran: «Gamcunawanga wamrä manami aywangachu. Wauguin Josëpis wañushana. Pay japallannami quëdasha. Aywaycashancho imapis päsaptenga gamcunami juchayoj canquipaj noga llaquicuyllawan wañunäpaj.» ");
INSERT INTO qub_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Muchuyga intëru nasyuncunacho mas fiyupana caran. ");
INSERT INTO qub_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Chaymi Egiptupita apamushan rïguncuna ushacäcuptin Jacobga wamrancunata niran: «Yapay ayway rïgu rantej. Wallcallatapis rantimunqui.» ");
INSERT INTO qub_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Chayno niptin Judäga niran: «Egiptucho caycaj mandäga nogacunata nimaran: ‹Shullcayquita cayman mana pushamorga ama chayamunquichu› nir. ");
INSERT INTO qub_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Wauguë Benjamín nogacunawan aywaptenga rïguta rantipämunäpaj aywashämi. ");
INSERT INTO qub_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Nogacunawan mana aywaptenga manami aywashäcunachu. Chay runaga näga nishänöpis nimaran: ‹Shullcayquita cayman mana pushamorga amana chayamunquichu› nirmi.» ");
INSERT INTO qub_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Chaura Israel niran: «Gamcunaga ¿imapätaj chay runata willarayqui jucpis wauguiqui caycashanta? ¿Imanirtaj chayno mana allitaga ruramashcanqui?» ");
INSERT INTO qub_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Niptin paycuna niran: «Chay runa amatarmi nogacunata tapumaran aycaj cashanchïtapis, chayno famillyanchïcunapäpis. Tapumaran: ‹¿Papäniqui cawaycanrächu? ¿Jucpis wauguiqui caycanrächu?› nir. Chaymi nogacunaga llapantapis rasun cajllata willashcä. ¿Imanöpataj musyäcunaman caran ‹Wauguiquita pushamuy› nimänantaga?» ");
INSERT INTO qub_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Papänin Israelta Judá cayno niran: «Cawananchïpaj wamrata cachay nogawan aywananpaj. Paytaga nogami imapitapis ricashaj. ‹Wamra aywachun› niptiquega jucllami aywashäcuna. Chaura manami mayganchïpis wañushunchu yargaypita ni wamranchïcunapis ni quiquinchïcunapis. ");
INSERT INTO qub_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Wamrayquipäga nogata tapumanqui ima päsaptinpis. Cayman wamrayquita mana cutichimushpäga gampa ñaupayquicho imaycamapis nogami juchayoj cashaj. ");
INSERT INTO qub_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Auniptiquega maynami ishcay cutipis aywäcunaman cutimöcunaman caran.» ");
INSERT INTO qub_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Chayno niptin papänin niran: «Cananga ¿imanäshunnataj ari? Chaynönachari pushanqui. Chay runata goycunayquipaj apanqui cay particho mas munay cajninta: balsamuta, abëjapa mishquinta, perfümita, mïrrata, nuezcunata, almendracunatapis. ");
INSERT INTO qub_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Guellaytapis apanqui yapay rantimunayquipaj. Ñaupa caj guellayta cutichimushushayquitapis apanqui entreganayquipaj. Capaschari pantaypa cutiycachimushurayquipis. ");
INSERT INTO qub_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Wauguiquita pushacarcärir juclla ayway ari chay runa cajman. ");
INSERT INTO qub_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Llapanpaj munayniyoj Tayta Dios gamcunata chay runawan cuyapaycachishunqui jucaj wauguiquitapis cachaycunanpaj, Benjamintapis mana imatapis rurananpaj. Llapan wamräcunata ogranä captenga ¿imanäshätaj ari?» ");
INSERT INTO qub_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Jacobpa wamrancunaga Egiptuman chayachir mandajta goycunanpaj cajcunata camaricuran. Nircorga guellaytapis masta apacurcur, wauguin Benjaminta pushacurcur Egiptuman llapan aywaran. José cajman chayaycäriptin ");
INSERT INTO qub_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Josëga ricaran Benjamín paycunawan caycajta. Chaymi Josëga wasincho aroj sirbintinta niran: «Cay runacunata pushay wasëman. Nircur juc wäcata pishtanqui micuyta ruranayquipaj. Paycunawanmi canan junäga mirindashaj.» ");
INSERT INTO qub_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Sirbintenga José nishanta ruraran. Quiquin sirbintimi pusharan Josëpa wasinman. ");
INSERT INTO qub_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Chaura paycunaga fiyupa manchariran. Mancharirmi quiquin-pura parlar ninacuran: «Canan caymanga pushamashcanchi rimëru rïgu rantej shamuptinchi guellayta cutiycachimashanchïpitami. Cananga magarcur magarcurmi uywaytano aruchimäshun bürrunchïcunatawan.» ");
INSERT INTO qub_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Chayno parlacushpanmi Josëpa wasi puncunman chayaycärerga pushaj sirbintita cayno niran: ");
INSERT INTO qub_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","«Tayta, nogacunaga ñaupa cajcho rïgu rantej shamurä. ");
INSERT INTO qub_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Rïguta rantircur cuticuräcuna. Puñunäcunapaj pachacurmi custalnëcunapa shiminta pascarä. Chay shimincunachömi guellaynëcunata tarirä. Rïgupaj pägashä guellayga llapanmi caycasha. Chaytami cananga cutiycachinäpaj cutichimushcä. ");
INSERT INTO qub_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Mastapis apamushcäcunami yapay rantinäpaj. Ichanga manami musyäcunachu chay guellayta pï custalnëcunaman wiñashantapis.» ");
INSERT INTO qub_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Chaura Josëpa sirbintenga niran: «Ama manchacuychu. Gamcuna rïgupaj pägashayqui guellayta nogaga llapantami chasquirä. Chay guellaytaga papäniquipawan gamcunapa Diosniquichari custalniquiman wiñarcusha.» Chaypitaga Simeontapis carsilpita jorgarcamur pusharan paycuna caycashanman. ");
INSERT INTO qub_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Nircur llapantana yaycuchiran Josëpa wasinman. Chaychönami yacuta apapämuran chaquincunata mayllacunanpaj. Bürruncunatapis garaparan. ");
INSERT INTO qub_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Parlajta wiyar musyaycaranna chaycho José micunanpaj cashanta. Chaymi Josëta goycunanpaj apashanta camariran. Nircurna shuyarcaycaran José mirindaj chayananta. ");
INSERT INTO qub_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Wasinman José chayaycuptenga fiyupa rispitashpan umpuran urcunpis pampaman töpanancama. Nircorga goycunanpaj apashancunata goycäriran. ");
INSERT INTO qub_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Josëga tapuran imano goyarcaycashantapis. Chaynöpis tapuran: «¿Imanötaj caycan ‹Papänë auquin can› nimashayquega? ¿Cawaycanrächu?» nir. ");
INSERT INTO qub_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Chayno niptin rispitashpan llapan umpurcärir cayno niran: «Au tayta, papänëga allimi caycällan. Payga cawaycanrämi.» ");
INSERT INTO qub_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Paycunata ricapärishancho Josëga ricäriran chay taytapita chay mamapita caj wauguin Benjaminta. Chaymi José niran: «¿Paychu ‹Shullcä can› nimashayqui wauguiqui?» Nircur Benjaminta niran: «¡Gamtaga Dios yanapaycushunqui ari ïju!» nir. ");
INSERT INTO qub_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Josëga amatar cushicuran wauguinta ricärirmi. Cushicuyllawan fiyupa waganaran. Chaymi apurä cuartunman yaycucuycuran. Nircur chaychöna wagaran. ");
INSERT INTO qub_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Fiyupa wagashanpita chawaycur cärancunata mayllacurir llojshimuran. Nircur uywaynincunata niran: «Micuyta garacamuyna» nir. ");
INSERT INTO qub_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Juc mësaman shuyni Josëta gararan, juc mësamanna wauguincunata. Chay wasicho micoj Egipto runacunatapis juc mësaman gararan. Egipto runacunaga juc-lä jäpa runacunawan iwal manami imaypis micojchu. Chaymi Egipto runacunapäga hebreo runacunawan micuy fiyupa melanäcuypaj caran. ");
INSERT INTO qub_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Josëpa wauguincunaga mandashan-tupu mayurpita shullcacama jamacuran. Chaymi paycunaga imata rimacuytapis mana camäpacuranchu. Jucnin-jucnin manchacasha ricapänacurcaycaran. ");
INSERT INTO qub_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Quiquinpa mësancho caycaj micuytapis Josëga wauguincunata yaparan. Benjamintami ichanga waquinpita mas achcata gararan. Llapan wauguincunaga Josëwan cushisha micuran upuran. ");
INSERT INTO qub_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Chaypita, Josëga sirbintinta cayno niran: «Cay runacunapa custalninman rïguta wiñapay sumaj juntata. Rïgupaj pägashan guellaynintapis cada-ünunpa custalninpa shiminman wiñarcapunqui. ");
INSERT INTO qub_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Shullca caj runapa custalninman guellayninta wiñarcapushpayqui guellay bäsötapis wiñarcapunqui.» Chaura sirbintenga llapantapis ruraran José mandashannölla. ");
INSERT INTO qub_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Warannin tutaga Josëpa wauguincunata pacha chayraj achicyaycämuptillanna despacharan. Chaura chay runacunaga bürruncunata cargacurcur aywacuran. ");
INSERT INTO qub_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Aywacoj runacuna siudäpita manaraj caruta aywaptinmi Josëga sirbintinta cayno niran: «Ayway chay runacunapa guepanta. Tariparcur cayno ninqui: ‹¿Imanirtaj gamcunapaj alli caycaptëga mana allita rurashcanqui? ¿Imanirtaj guellay bäsuta suwacamushcanqui? ");
INSERT INTO qub_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Chay bäsuta patrunnëga charasha upunanpämi, adibinananpämi. Chay bäsuta apacamur gamcunaga mana allitami rurashcanqui› nir.» ");
INSERT INTO qub_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Chaura sirbintiga tariparcur niran José nishannölla. ");
INSERT INTO qub_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Niptin paycunaga sirbintita niran: «¿Imanirtaj chaynöpaga nogacunata jagachamanqui? ¡Chaytaga ruraycömanrächu! ");
INSERT INTO qub_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Canaanpita-pachapis nogacunaga custalnëcunapa shimincho tarishä guellaytapis cutichimushcämi. ¿Imanöpataj guellayta ni goritapis suwacamöcunaman caran patrunniquipa wasinpitaga? ");
INSERT INTO qub_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Mayganëchöpis bäsu taricaptenga wañuchun. Waquinnëcunaga mandajniquipa uywayninnami cashaj.» ");
INSERT INTO qub_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Chayno niptin sirbintiga niran: «Gamcuna nishayquinömi canga. Bäsuta charaj cajllami uywaynëga canga. Waquinniquega aywacunquipämi.» ");
INSERT INTO qub_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Chaura paycunaga jinan öra cargancunata pampaman jorguran. Nircur cada-ünun custalninta quichaparan. ");
INSERT INTO qub_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Chaura sirbintiga ashiyta gallaycuran mayur cajpa custalninpita shullca cajpa custalnincama. Ashiycashancho bäsutaga Benjaminpa custalnincho tariran. ");
INSERT INTO qub_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Chaura paycunaga llaquicuywan röpantapis rachiriran. Nircorga bürruncunata cargacarcärir jinan öra siudäman cutiran. ");
INSERT INTO qub_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Llapan wauguincunawan cutir Judäga wasillanchöraj Josëta tariran. Paycunaga pasaypa llaquicushpan Josëpa ñaupanman gongurpacur lätacuran. ");
INSERT INTO qub_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Chaura Josëga niran: «Gamcuna ¿imatataj rurashcanqui? ¿Gamcuna manachu musyashcanqui noga adibinayta yachashäta?» ");
INSERT INTO qub_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Chaura Judá niran: «Cananga ¿imanöpataj imatapis nishayqui ari, tayta? Nogacunaga manami imatapis niyta puydëchu mana suwa cashätaga. Tayta Diospis juchayojtachaj ricamasha. Cananga bäsuta charajwan llapanëmi gampa uywayniqui cashaj.» ");
INSERT INTO qub_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Chayno niptin José niran: «Llapaniquega manami. Pimi bäsöta charasha; chay cajllami uywaynëga canga. Chaypita cäga llapayquimi cuticunqui papäniquipa wasinman. Manami pipis rimapäshunquipächu.» ");
INSERT INTO qub_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Chaura Judäga Josëpa ñaupanman witiycur niran: «Tayta, caychöga gam caycanqui quiquin faraonnömi. Ichanga gamwan parlarcuytami munä. Ama rabyacuychu ari. ");
INSERT INTO qub_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Nogacunata tapumarayqui papänë cawashanta mana cawashantapis. Chayno wauguëpäpis tapumarayqui cashanta mana cashantapis. ");
INSERT INTO qub_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Chaymi nogacunaga willarä: ‹Papänë pasaypa auquinna caycashanta. Juc shullcäpis wamra mösullaraj caycashanta, paypa wauguenga wañushantana, paycuna ishcallan juc mamapita cashanta. Chay mamallapita japallanna captinmi papänë fiyupa cuyan› nir. ");
INSERT INTO qub_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Chayno niptëcunapis gamga nimarayqui: ‹Shullcayquita pushamuy rejsinäpaj› nir. ");
INSERT INTO qub_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Chaymi nogacunaga gamta willarä: ‹Chay wamraga papäninta manami cacharinmanchu. Wamran cachaycuptenga llaquicuypita papänëga wañunmanmi› nir. ");
INSERT INTO qub_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Chayno niptëcunapis gamga nimarayqui ‹Chay wamra mana shamuptenga ama cayman chayamunquichu› nir. ");
INSERT INTO qub_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","«Papänë cajman chayaycorga nimashayquita llapantami willarä. ");
INSERT INTO qub_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Chaypita papänëga nogacunata nimaran ‹Yapay rïgu rantej ayway› nir. ");
INSERT INTO qub_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Chaura nogacunaga nirä: ‹Manami aywächu. Shullca caj wauguëtawan cachamaptiquimi ichanga aywashaj. Pay mana aywaptenga manami chay mandajman chayämanchu› nir. ");
INSERT INTO qub_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Chayno niptëcuna papänë nimaran: ‹Gamcunaga musyaycanquimi jucaj warmëcho ishcaylla wamrä cashanta. ");
INSERT INTO qub_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Jucaj wamräga illgashana. Canancama manami yurimunchu. Jirca animalchari micucurcusha. ");
INSERT INTO qub_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Cay wamrätapis ñaupäpita pushacuptiquega payta imapis päsaptin gamcunami juchayoj canquipaj noga llaquicuyllawan wañunäpäpis› nir. ");
INSERT INTO qub_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","«Papänëga shullca caj wamranwan goyallarnami cawaycanpis. Canan nogacunawan wamran mana cutiptin ");
INSERT INTO qub_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","mana ricashpan papänëga wañucäcongami. Chauraga nogacunami juchayoj cashaj auquin papänë llaquicuyllawan wañunanpaj. ");
INSERT INTO qub_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Nogaga papänëta nirä ‹Wamrataga nogami imapitapis ricashaj. Wamrayquita mana cutichimorga nogami imaycamapis juchayoj cashaj› nir. ");
INSERT INTO qub_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Chaymi gamta ruwä tayta. Shullcäpa ruquin uywayniquega noga quëdashaj ari. Payga papänë cajman cuticuchun waquin caj wauguëwan. ");
INSERT INTO qub_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","¿Imanöparäshi papänë cajman cutiycöman shullcä mana cutiptenga? Nogaga awantämanrächu papänë llaquicojta ricashpä.» ");
INSERT INTO qub_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Sirbej runacunapa ñaupancho wagayta Josëga mana munaranchu. Chaymi sinchipa niran: «¡Caypita llapayqui llojshiy!» nir. Chayno niptin Josëta sirbej runacunaga jucnayllapis chaycho manana carannachu. ");
INSERT INTO qub_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Josëga sinchi gaparaypa wagaran. Chaytaga llapan Egipto runacunapis wiyaran. Chay willapataga faraonpa palasyunchöpis mayaran. ");
INSERT INTO qub_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Wauguin cashanta willarmi José niran: «Nogaga Josëmi cä. ¿Papäninchi cawaycanrächu?» Josëpa ñaupancho caycashanta musyaycur wauguincunaga imata niytapis mana camäpacuranchu. ");
INSERT INTO qub_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Chaymi José niran: «Cay ñaupäman witimuy-llapa» nir. Wauguincuna witircuptin niran: «Nogaga Egiptuman ranticaycamashayqui wauguiqui Josëmi caycä. ");
INSERT INTO qub_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Canan gamcunaga ama llaquicuychu, ama jitapänacuychu nogata ranticamashayquipita. Rasunpaga Diosmi gamcunapa ñaupayquita cachamasha runacunata cawachinäpaj. ");
INSERT INTO qub_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Muchuy gallarishanga ishcay watanami. Pichga watarämi chaynölla muchuy canga. Chay watacunaga murupacurpis manami ima micuytapis shuntashunpächu. ");
INSERT INTO qub_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Nogataga Diosmi gamcunapa ñaupayquita cachamasha yargaypita mana wañunayquipaj. Chaynöpami gamcunapita mirajcunapis cangaraj. ¿Piraj yarpayllapis yarpanman caran Tayta Dios chayno camacaycächishantaga? ");
INSERT INTO qub_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Caymanga manami gamcunachu cachamashcanqui. Diosmi nogataga cachamasha mandaj faraonta yanapänäpaj, faraonwan iwal Egipto runacunata mandanäpaj. ");
INSERT INTO qub_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Canan öra ayway papäninchi cajman. Payta cayno willanqui ‹Wamrayqui José caynömi nin: «Diosmi churamasha Egipto runacunata mandanäpaj. Juclla shacamuy. ");
INSERT INTO qub_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Cayman shacamorga llapan castayquicunawan tiyanquipaj Gosén partichömi. Chaycho tiyashpayquega sercächömi tiyanquipaj. Chay partiga uywayquicunapäpis aypanmi. Llapan ima-aycayquicunatapis chayman apacamuy. ");
INSERT INTO qub_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Chaymanga micuytapis llapayquipaj aypajpämi goshayqui. Muchuyga canga cananpita pichga watacamarämi» nir.› ");
INSERT INTO qub_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Noga chayno niycashätaga wauguë Benjaminwan gamcunami wiyaycanqui. ");
INSERT INTO qub_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Cay Egiptucho imano mandashätapis, imano ricashayquitapis papänëta willanqui. ¡Apurä ayway papäninchïta cayman pushamunayquipaj!» ");
INSERT INTO qub_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Josëwan Benjamín ishcan macallanacarcärir wagaran. ");
INSERT INTO qub_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Josëga wagashpan llapan wauguincunata mucharan. Chaypitanaga wauguincuna mana manchacuypana Josëwan parlaran. ");
INSERT INTO qub_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Josëpa wauguincuna chayashan willapaga chayaran faraonpa palasyunyaj. Chaymi faraonga llapan mandäshejcunawan cushicuran. ");
INSERT INTO qub_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Josëta faraón niran: «Wauguiquicunata niy uywancunata cargacarcärir Canaanman cutinanpaj. ");
INSERT INTO qub_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Nircur papäniquita llapan castancunatawan cayman pushamuchun. Nogami goycushäpaj Egipto nasyuncho caycajtaga mas allinnin partita. Micuytapis micongapaj cay nasyuncho wayoj cajtaga alli cajllatami. ");
INSERT INTO qub_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Paycunata niy cay Egipto nasyunpita carrëtacunata apananpaj. Nircur chaywan cargacurcur apamuchun wamrancunatawan warmincunata. Chayno papäniquitapis pushamuchun. ");
INSERT INTO qub_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Imantapis cachaycamunanpaj cajpäga ama llaquicuchunchu. Egipto nasyuncho mas allinnin cäga cangapaj paycunapämi.» ");
INSERT INTO qub_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Israelpa wamrancunaga faraón nishanno ruraran. Josëga faraón nishanno carrëtacunata apachiran. Micuytapis apachiran nänicho micunanpaj. ");
INSERT INTO qub_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Nircur wauguincunata mushoj röpacunata goran. Benjamintami ichanga goran pichga rucaj röpata, quimsa pachac guellaytapis. ");
INSERT INTO qub_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Papäninmannami apachiran chunca bürrucunawan Egiptucho mas alli cajcunata. Chunca china bürruwanna apachiran rïguta, tantatapis, micuycunatapis papänin shamushpan micunanpaj. ");
INSERT INTO qub_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Wauguincunata despachashpan Josëga cayno niran: «Cuydä nänipa rimanacur aywargunquiman.» ");
INSERT INTO qub_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Egiptupita aywar chayaran Canaanman. Chaycho papänin Jacob tiyaycaran. ");
INSERT INTO qub_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Jacobta willaran José cawaycashanta, chayno pay Egipto nasyunpa mandajnin caycashantapis. Chaura Jacobga imata rurayta ni imata niytapis mana musyaranchu. Willaycashantapis mana riguiranchu. ");
INSERT INTO qub_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Chaura José nishan cajtaga llapanta willaran. José apachishan carrëtacunata ricärishpan ichanga fiyupa cushicuran. ");
INSERT INTO qub_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Chaymi niran: «¡Cananga musyämi wamrä José cawaycashanta! ¡Manaräpis wañucur aywar ricaycamushaj!» ");
INSERT INTO qub_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Israelga ima-aycantapis apacurcur aywacuran. Beersebaman chayaycurnami papänin Isaac rispitashan Diospaj uywata pishtarcur rupachir gararan. ");
INSERT INTO qub_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Chaura chay chacay Tayta Diosga Israelta ribilaran. Jutinpa gayar «Jacob, Jacob» niran. Chaura pay niran: «¿Imallaraj?» ");
INSERT INTO qub_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Chaura Dios niran: «Nogaga papäniquipa Diosninmi caycä. Egiptuman aywaytaga ama manchacuychu. Chaychömi yanapäshaj wamrayquicuna juc nasyunpaj aypajpaj mirananpaj. ");
INSERT INTO qub_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Egiptuman aywaptiqui yan'gashayquimi. Chaypitapis nogami jorgamushäpaj wamrayquipita mirajcunata. Gam wañucuptiquega wamrayqui José ñaupayquichömi caycangapaj.» ");
INSERT INTO qub_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Jacobga Beersebapita aywacuran. Wamrancunanami papänin Jacobta, wamrancunata, warmincunata wichächiran faraón apachimushan carrëtacunaman. ");
INSERT INTO qub_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Jacobga llapan ima-aycantapis Egiptuman apacurcur aywacuran. Wäcancunata, uyshancunata, Canaancho tiyar charashan cajtaga ushajpaj gaticurcur aywacuran. ");
INSERT INTO qub_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","Llapan wamrancuna warmipis ollgupis, warmi ollgu willcancunapis paywan aywacuran. ");
INSERT INTO qub_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Egiptuman aywacoj Israel castacuna caynömi caran: Rubenmi caran Jacobpa guechpa wamran. ");
INSERT INTO qub_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Rubenpa wamrancunanami caran: Hanoc, Falú, Hezrón, Carmi. ");
INSERT INTO qub_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Simeonpa wamrancuna caran: Jemuel, Jamín, Ohad, Jaquín, Zohar, Saúl. Saulga caran Cananea warmicho caj wamrannami. ");
INSERT INTO qub_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Levïpa wamrancuna caran: Gersón, Coat, Merari. ");
INSERT INTO qub_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Judäpa wamrancuna caran: Er, Onán, Sela, Fares, Zara. Erwan Onanga wañuran Canaanllachöna. Farespa wamrancuna caran Hezronwan Hamul. ");
INSERT INTO qub_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Isacarpa wamrancuna caran: Tola, Fúa, Job, Simrón. ");
INSERT INTO qub_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Zabulonpa wamrancuna caran: Sered, Elón, Jahleel. ");
INSERT INTO qub_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Chaycunami caran Jacobpa warmin Leacho caj wamrancuna willcancuna, chayno warmi wamran Dinapis. Chaycunaga caran Padan-aramcho tiyaycaptin yurejcunalla. Warmi ollgu llapanga caran quimsa chunca quimsan (33) runacuna. ");
INSERT INTO qub_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Gadpa wamrancuna caran: Zifión, Hagui, Ezbón, Suni, Eri, Arodi, Areli. ");
INSERT INTO qub_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Aserpa wamrancuna caran: Imna, Isúa, Isúi, Bería. Paycunapa pañinpis caran «Sera» jutiyoj. Beriapa wamrancunaga caran Heberwan Malquiel. ");
INSERT INTO qub_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Chaycunami caran Jacobpa uywaycaj warmin Zilpacho caj wamrancuna willcancuna. Zilpaga caran Labán wamran Leata uywayninpaj goycushan warmimi. Paypa wamrancunapita mirajcuna llapanga caran chunca sojtan (16) runacunami. ");
INSERT INTO qub_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Jacobpa wamrancuna warmin Raquelcho caj caran Josëwan Benjamín. ");
INSERT INTO qub_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Josëpa wamrancuna warmin Asenatcho caran Manaseswan Efraín. Paycunaga Egiptucho yuriran. Asenatga caran On siudächo tiyaj cüra Potiferapa wamran. ");
INSERT INTO qub_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Benjaminpa wamrancuna caran Bela, Bequer, Asbel, Gera, Naamán, Ehi, Ros, Mupim, Hupim, Ard. ");
INSERT INTO qub_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Chaycunami caran Jacobpa jucaj warmin Raquelpa wamrancuna willcancuna. Chaura llapanga caran chunca chuscu (14) runacunanami. ");
INSERT INTO qub_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Danpa wamran caran: Husim. ");
INSERT INTO qub_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Neftalïpa wamrancuna caran: Jahzeel, Guni, Jezer, Silem. ");
INSERT INTO qub_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Chaycunami caran Jacobpa uywaycaj warmin Bilhacho caj wamrancuna willcancuna. Bilhaga caran Labán wamran Raquelta uywayninpaj goycushan warmimi. Paypita mirajcuna llapanga caran ganchis. ");
INSERT INTO qub_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Egipto nasyunman Jacobwan chayaj runacuna chay castapa yawarllan llapanga caran sojta chunca sojtan (66) runacuna. Chayga caran wamranpa warmincunata mana yupayllapa. ");
INSERT INTO qub_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Egiptucho yurej Josëpa wamrancuna caran ishcay. Chaura Egipto nasyunman Israel castacuna chayäga caran ganchis chuncana (70). ");
INSERT INTO qub_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Jacobga José cajman ñaupa-puntata cacharan wamran Judäta. Chaura Judäga Gosenman tincoj aywananpaj willaj aywaran. Chaypitanaga Gosenman Jacob chayaran. ");
INSERT INTO qub_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Chayashanta musyaycur Josëga carrëtancunata camarachiran papäninwan tincoj aywananpaj. Papänin cajman chayaycur macallacurcur may öra wagaran. ");
INSERT INTO qub_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Wamran Josëta Israelga niran: «Gamwan cawaycajwanmi tincuycunchi. Cananga allinami wañucuptëpis.» ");
INSERT INTO qub_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Chaypita Josëga wauguincunatawan llapan castancunata niran: «Faraonta willajmi cutë. Paytaga nishaj ‹Canaán particho tiyaycashanpitami papänë llapan castäcunawan cayman shacamusha. ");
INSERT INTO qub_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Paycunaga llapanpis uywacuna michiyllatami yachan. Chaymi llapan ima-aycantapis apacurcur; uywancunata gaticurcur shacamusha› nir. ");
INSERT INTO qub_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Chay mandaj gamcunata gayaycachir ‹¿Imachötaj arunqui?› nir ");
INSERT INTO qub_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","tapushuptiqui gamcunapis ninqui ‹Nogacunaga wamra cashäpita-pachapis unay caj awilöcunano uywa ricayllatami yachä› nir. Chaura gamcunataga Gosén particho shuyni chay castalla tiyacunayquipämi nishunquipaj. Egipto runacunaga melanäcunmi uyshayoj runacunawan iwal tiyayta.» ");
INSERT INTO qub_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Chaypita José aywaran faraonta willaj. Chayaycur niran: «Papänëmi llapan castancunawan uyshancunata, cabrancunata, wäcancunata gaticurcur, ima-aycantapis apacurcur Canaán partipita shacamusha. Paycunaga Gosenchöna carcaycan.» ");
INSERT INTO qub_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Josëga pichga wauguincunata acrarcur pusharan faraón rejsinanpaj. ");
INSERT INTO qub_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Chaycho Josëpa wauguincunata faraón tapuran: «¿Ima aruytataj yachanqui?» nir. Josëpa wauguincuna niran: «Nogacunaga unay awilöcunanöpis uyshacunata cabracunata uywacuyllatami yachä. ");
INSERT INTO qub_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Nogacunaga shacamushcä cay nasyuncho tiyacunäpämi. Tiyashä Canaán partichöga fiyupami muchuy caycan. Manami guewapis canchu uywäcuna micunanpaj. Chaymi gamta ruwacö tayta Gosencho tiyacunäpaj.» ");
INSERT INTO qub_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Chaura faraonga Josëta niran: «Papäniquiwan wauguiquicuna ñaupayquicho tiyananpaj shacamusha caycaptenga ");
INSERT INTO qub_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","cay Egipto nasyuncho tiyacunanpaj acray munashayqui partita. Gosencho juc pachata goycuy ari. Chay partimi waquin partipita mas alli cay nasyunchöga. Paycunacho mayganpis uywa ricayta sumaj yachaj cajtaga churay nogapa uywäcunata ricananpaj.» ");
INSERT INTO qub_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Chaypita Josëga papänin Jacobtapis pusharan faraón rejsinanpaj. Ñaupanman chayaycur Jacobga faraonta saludaran. ");
INSERT INTO qub_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Faraonga tapuran: «¿Ayca watayojnataj canqui?» nir. ");
INSERT INTO qub_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Chaura Jacobga niran: «Pachac quimsa chuncan (130) watayojnami caycä tayta. Juc-lächo juc-lächo purir wallcallatami cawashcä; ñacallarmi goyashcä. Ichanga chachäcuna cawashan wataman manami chayärächu.» ");
INSERT INTO qub_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Jacobga Tayta Diosta faraonpaj mañacurir llojshicamuran. ");
INSERT INTO qub_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Chaypitana Josëga faraón nishannölla wauguincunatawan papäninta tiyachiran intëru Egipto nasyuncho caycaj partipita mas allinnin partiman. Chayga caran Ramsés partimi. ");
INSERT INTO qub_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Chaycho tiyaptin Josëga llapan castancunata micuyta goran aycajpis cashanman-tupu. ");
INSERT INTO qub_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Muchuy fiyupa captinmi micuyga maychöpis manana carannachu. Chaymi Egiptuchöpis Canaanchöpis runacuna yargaywan pasaypana wañunarcaycaran. ");
INSERT INTO qub_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Chaura Egipto runacunapata Cananeo runacunapata Josëga ushajpäna guellaynincunatapis shuntaran rïguta rantir pägashanta. Nircur llapan guellayta faraonpa palasyunman aparcur churaran. ");
INSERT INTO qub_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Egipto runacunapa Cananeo runacunapa guellaynin ushacäcuranna. Chaura Egipto runacunaga aywaran Josëta cayno ninanpaj: «Nogacunapa guellaynë manami cannachu. Gamna garamay ari. Guellaynë ushacasha captillanga wañunäta ama cachaycamaychu ari tayta» nir. ");
INSERT INTO qub_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Chaura José niran: «Guellayniqui ushacasha captenga uywayquicunatana apamuy rïguwan rucanapaj.» ");
INSERT INTO qub_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Chayno José niptin Egipto runacunaga uywancunatana aparan rïguwan rucananpaj. Aparan cawalluncunata, uyshancunata, cabrancunata, wäcancunata, bürruncunata. Chayno uywancunata apaptin Josëga rïguwan rucaran. Chaynölla juc wata intëru rucaran. ");
INSERT INTO qub_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Watannin cajcho Josëman llapan aywaycärir yapay niran: «Tayta, musyashayquinöpis llapan guellaynëcuna ushacashanami. Llapan uywäcunapis gamllapanami. Cananga mananami imäpis cannachu micuywan rucanäpaj. ");
INSERT INTO qub_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Chacräcunatawan quiquëcunatana rantimay micuypaj. Faraonpa rantishan runacunallana cashaj. Payllapäna chacräcunachöpis arushaj. Muruta ichanga gomanqui chacräcunata murunäpaj quiquëcunapis micur cawanäpaj. Yargaypita wañunäta, chacräcunapis purunyänanta ama munaycuychu ari tayta.» ");
INSERT INTO qub_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Chaymi Josëga Egipto runacunapa chacranta rantiran faraonllapana cananpaj. Egipto runacunaga fiyupa yargaywanmi chacrancunatapis ushajpaj ranticuycuran. Chaynöpami llapan chacracunapis faraonllapana ricacuran. ");
INSERT INTO qub_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Intëru Egipto nasyuncho caj runacuna ricacuran faraonpa uywaynillanna. ");
INSERT INTO qub_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Cüracunapa chacrancunallatami Josëga mana rantiranchu. Cüracunataga faraón micuyta goran. Chaynöpami cüracunaga chacrancunata mana ranticuranchu. ");
INSERT INTO qub_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Chaypita Josëga llapan runacunata niran: «Canan gamcunaga chacrantin caycanqui faraonllapanami. Nogaga gamcunata rantishcä payllapana canayquipämi. Caychömi muru caycan chacracunata murunayquipaj. ");
INSERT INTO qub_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Murushayqui rïgu poguptenga cada pichga arröbapita juc arröbata faraonman päganquipaj. Puchoj cajtana waquinta churanqui yapay murunayquipaj. Waquinna canga wamrayquicunawan llapan wasiquicho tiyajcunapis micunayquipaj.» ");
INSERT INTO qub_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Chaura llapan runacuna niran: «Gamga amatar alli runami canqui tayta. Nogacuna yargaypita wañunäpitami salbamashcanqui. Faraonpa uywayninnachari cashaj.» ");
INSERT INTO qub_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Josëga llapan Egipto runacunata niran murushancuna poguptin cada pichga arröbapita juc arröbata faraonta cutichinanpaj. Chayno pägayga canancamapis caycanrämi. Cüracunami ichanga mana päganchu. Paycunapaga chacrancunapis manami faraonpachu caran. ");
INSERT INTO qub_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Jacobpita mirajcunaga Egiptuchöna tiyacuran. Gosén partichöna tiyacaycäriran. Chaycho tiyaycällar aypallaman miraran. ");
INSERT INTO qub_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Egiptuchöga Jacob tiyaran chunca ganchisnin (17) wataraj. Chaura pay caran pachac chuscu chunca ganchisnin (147) watayoj. ");
INSERT INTO qub_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Wañunanpaj wallcana pishiycaptin wamran Josëta gayachiran. Nircur cayno niran: «Gam rasunpa cuyapämashpayquega maquiquita cay chancäman jatimuy. Nircur Diospa jutincho juray ruwacushäta cumlinayquipaj. Noga wañucuptëga cay Egiptuman ama pampamanquichu ari. ");
INSERT INTO qub_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Nogaga wañur ñaupa wañoj castäcunawan tincoj aywacunäpänami caycä. Wañucuptëga cay Egipto nasyunpita cuerpöta apacunqui. Nircur pampaycäramanqui ñaupa caj castäcuna pamparaycashan cajman» nir. «Au, papä. Nimashayquinömi rurashaj» niran Josëga. ");
INSERT INTO qub_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","«Canan öra juray» niran papänenga. Chaura Josëga juraran. Jurarcuptin Israelga yapay wegucuycuran. ");
INSERT INTO qub_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Chaypita achca junajtaga Josëta willaran papänin gueshyaycashanta. Chaura Josëga ishcan wamranta Manasestawan Efrainta pushacurcur aywaran. ");
INSERT INTO qub_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Chayaycuptin Jacobta willaran wamran José chayashanta. Chauraga llapan callpanwan jatarir jamarcuran. ");
INSERT INTO qub_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Nircur Josëta niran: «Munayniyoj Diosmi Canaán particho yuripämaran Luz siudächo. Chaychömi bindisyunta gomashpan ");
INSERT INTO qub_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","cayno nimaran: ‹Gampitaga aypallamanmi mirachishaj. Gampita mirajcuna achca nasyun cananpämi camacächishaj. Gampita mirajcunatami cay partitapis goycushäpaj. Cay partichöga imaycamapis paycunami tiyangapaj› nir. ");
INSERT INTO qub_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","«Cay Egiptuman manaraj chayamuptë yurej wamrayquicunataga nogami wamrachacuycä. Chaymi Rubenwan Simeón wamräcuna cashannöna Efrainwan Manasesga nogapana canga. ");
INSERT INTO qub_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Paycunapa shullcan cajnami ichanga gampa wamrayquicuna canga. Paycunaga erensyatapis chasquenga Efrainwan Manasés chasquishallanchönami. ");
INSERT INTO qub_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Mamayqui Raquelga Canaán partichömi wañupämaran. Wañupämaran Padan-arampita cuticamur Efrata marcaman chayaycaptëmi. Chaura Efratallachömi näni aywajpa ñaupanman pampaycärirä. Chay marcapami cananga jutin Belén.» ");
INSERT INTO qub_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Josëta chayno niycashancho Israelga ricäriran Josëpa wamrancunata. Chaymi tapuran «¿Pitaj paycunaga?» nir. ");
INSERT INTO qub_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Chaura José niran: «Wamräcunami. Cay Egiptucho tiyaycaptëmi Tayta Dios tarichimasha.» Chayno niptin papänin niran: «Cayman witichipämay ari paycunata bindisyunta gonäpaj.» ");
INSERT INTO qub_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Israelga caran pasaypa auquinna. Manana ñawinpis sumäga ricacurannachu. Chaura Josëga papäninpa ñaupanman wamrancunata witichiparan. Ñaupanman witiycuptin ishcan wamracunata macallarcur-macallarcur mucharan. ");
INSERT INTO qub_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Nircur Josëta niran: «Nogaga manami gamta cawaynëcho ricayta yarparänachu. Chaypis Diosmi munasha wamrayquitapis ricanätaraj.» ");
INSERT INTO qub_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Israelpa gongurnincuna chaupincho caycajta wamrancunata José witichiran. Nircur quiquenga umpuran urcunpis pampaman töpanancama. ");
INSERT INTO qub_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Jatarcur ishcan wamrancunata papäninpa ñaupanman witichiparan. Chaura papänin Israelpa ñaupanchöga Efraín caycaran ichoj caj-läduncho, Manasesna derëchu caj-läduncho. ");
INSERT INTO qub_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Bindisyunta gonanpaj wamracunapa umanman maquinta churaran. Jogarishanchöga maquinta Israel rusachiran. Chaymi derëchu caj maquinta churaran Efrainpa umanman, shullca caycaptinpis. Ichoj caj maquintana Manasespa umanman churaran mayur caycaptinpis. ");
INSERT INTO qub_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Nircur bindisyunta gor cayno niran: «Chachä Abrahamwan papänë Isaac rispitashan Dios, Nogata yurishäpita-pacha ricamaj Dios, ");
INSERT INTO qub_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Nogata ima mana allipitapis salbamaj Anjil cay wamracunatapis yanapaycuchun. Paycunacho yarpaycuchun, nogapa jutëta chayno chachä Abrahampa jutintawan papänë Isaacpa jutintapis. Cay wamracunapitaga aypallaman mirachun. Intëru munduchöpis aypallanpa cachun paycuna castaga.» ");
INSERT INTO qub_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","José ricaptenga papänin rurashan mana alli caran. Shullca caycaptin Efrainpa umanman derëchu caj maquinta churaran. Chaymi Josëga papäninpa derëchu caj maquinta charircur Manasespa uman jananman churaran ");
INSERT INTO qub_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","papäninta cayno nishpan: «Ama chaynöga papä. Derëchu caj maquiquitaga mayur cajpa uman jananman churay.» ");
INSERT INTO qub_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Papänenga pay nishanno rurayta mana munashpan niran: «Nogapis musyaycämi maygan mayur cashantaga. Mayur cajpis mirashpanga cangapaj jatun nasyunmi. Shullcan cajmi cangapaj mas munayniyoj nasyunpaj. Paypita mirajcunaga achca nasyunpämi mirangapaj.» ");
INSERT INTO qub_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Chay junaj Jacobga ishcan willcancunata bindisyunta goran cayno nir: «Cananpitaga llapan Israelcuna bindisyunta goshpan caynömi nenga: ‹Efrainta Manasesta yanapashannölla Tayta Diosga gamcunatapis yanapaycushunqui› nir.» Chaynömi Israelga Efrainta churaran mayur wamranno cananpaj, Manasestana shullcano cananpaj. ");
INSERT INTO qub_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Nircur Josëta niran: «Nogaga wañucojnami-aywä. Noga wañucuptëpis Diosga gamcunawanmi caycangapaj. Paymi cutichishunquipaj awiluyquicuna tiyashan partiman. ");
INSERT INTO qub_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Gamtaga wauguiquicunapita mastami goycushcä. Chaymi Shequemtaga gamta goycö. Chaytaga Amorreo runacunatami guechurä sablëwan, lëchawan pillyashpä.» ");
INSERT INTO qub_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Llapan wamrancunata gayaycur Jacob niran: «Ñaupäman witimuy-llapa shamoj watacunacho ima päsashunayquipaj cashantapis willapänäpaj. ");
INSERT INTO qub_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","«Wamräcuna, witimuy-llapa. Nishäta wiyacuy-llapa. ");
INSERT INTO qub_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","«Rubén, gamga canqui guechpa wamrämi. Gamga mösullaraj caycaptëmi yurirayqui. Gamga mas rispitäduchari canquiman. Mas munayniyojchari canquiman. ");
INSERT INTO qub_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Ichanga gamga märistayquiwan puñucuycushpayquimi pengayman churamarayqui. Chaypitami manana mayurnönachu canquipaj. Gamga chayasha mayunömi cashcanqui. ");
INSERT INTO qub_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","«Simeonwan Levïga chay shongullami. Paycunaga mana cuyapaypami pitapis wañuchin. ");
INSERT INTO qub_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Nogaga manami paycuna parlacushancho cayta munächu. Paycunaga rabyacurcurmi runacunata wañuchiran. Asicunan-cashallami törucunapa ancuncunatapis cuchurgäriran. ");
INSERT INTO qub_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Nogaga melanäcömi gamcuna rabyar rurashayquita. Chaypitami gamcunataga mashtaypa-mashtarishayqui. Chaura intëru Israel nasyunchömi tallucasha caycangapaj. ");
INSERT INTO qub_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","«Judá, gamga chiquishojcunata munayniquichömi chararanquipaj. Quiquiquipa wauguiquicunapis umpuycur-umpuycur rispitashushpayquimi alabashunquipaj. ");
INSERT INTO qub_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Judá, gamga canqui juc manta liyun cäsata charircur cutimojno; micunanpaj pampaman lätacuycojno. Chayno caycaptiquega ¿piraj gamta rabyachishunquiman? ");
INSERT INTO qub_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Judätaga manami pipis guechongapächu munayniyoj cayninta. Manami pipis guechongapächu mandaj car charashan bastunnintapis rasunpa mandaj chayamunancama. Chay mandajtami llapan runacunapis rispitangapaj. ");
INSERT INTO qub_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Chay wichan übas aypalla captinmi bürruncunatapis übas yöracunamanna watanga. Bïnu yacunöraj captinmi bïnuwan röpantapis tagshacunanpänöna canga. ");
INSERT INTO qub_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Aypalla übas captinmi ñawincunapis bïnupita mas yanaraj cangapaj. Aypalla lëchi captinmi quiruncunapis lëchipita mas yurajraj cangapaj. ");
INSERT INTO qub_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","«Zabulón tiyanquipaj lamar cantuncunachömi. Gamga tiyanquipaj büquicuna chayanancho, llojshinanchömi. Lindayquega chayarangapaj Sidoncamami. ");
INSERT INTO qub_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","«Isacar, gamga sinchi bürru curralcho wichgaraycajnömi canquipaj. ");
INSERT INTO qub_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Tiyanayquipäno alli partita ricar, wajtayquitapis camapanquipaj chaycho guepicunata apanayquipaj. Mana rimacuyllapami rantisha runano ricacunquipaj. ");
INSERT INTO qub_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","«Dan, gamga quiquiqui castallatami alli arriglanquipaj. Gamga canquipis Israel trïbumi. ");
INSERT INTO qub_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Dan gamga canquipaj culebra näni cantuncho mayaj-mayaj caycajnömi; cawallupa chaquinta cañirir muntasha aywaycajta garpurejno. ");
INSERT INTO qub_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","¡Tayta Dios gam salbamänallayquitanami shuyaraycä! ");
INSERT INTO qub_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","«Gad, gamtaga juc-läpita juc-läpitami asaltashunayquipaj yaycamongapaj. Ichanga paycunatapis asaltanquipämi. ");
INSERT INTO qub_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","«Aser, gampaga aypallami micuyniqui cangapaj. Ray amatar yachashan micuycunapis cangapämi. ");
INSERT INTO qub_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","«Neftalí, gamga lluychu-nirajpis munashayquipa puricojmi canquipaj. Cuyayllapaj wawayoj lluychunömi canquipaj. ");
INSERT INTO qub_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","«José, gamga yacu cantuncho lanta wiñar amatar wayojnömi canquipaj. Nircur lantapa rämancunapis tapya jananpa lätajnöraj canquipaj. ");
INSERT INTO qub_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Fiyu runacuna chiquishushpayquimi lëchancunata gamcunaman jitamongapaj. Chayno rurar rabyachishunquipaj. ");
INSERT INTO qub_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Ichanga gampa ricrayquicuna fiyupa callpami canga. Lëchayquicunatapis sinchimi charinquipaj. Chaynöga canquipaj Jacobpa Tayta Diosnin yanapäshuptiquimi, Israelpa michejnin chapajnin yanapäshuptiquimi, ");
INSERT INTO qub_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","yäracushä Dios yanapäshuptiquimi, munayniyoj Dios bindisyunta goshuptiquimi. Syëlupitami payga bindisyunninta churamonga. Bindisyunta goshushpayquimi pacha rurinpitapis yacuta pashtachimonga. Warmicuna achca wawata tarinanpäpis bindisyunta goshunquipaj. ");
INSERT INTO qub_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Noga bindisyunta goshäga unaypita-pacha cacoj jircacuna mana ushacaj cashannömi cangapaj. Bindisyunta goshäcunaga gam Josëchömi caycangapaj. Gamga llapan wauguiquicunapita mas rispitädumi caycanqui. ");
INSERT INTO qub_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","«Benjamín, gamga canqui atojnömi. Imatapis charircur tuta tutallami micunqui. Tardipana llapan puchöpacushayquitapis aypurinqui.» ");
INSERT INTO qub_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Chaycunami caran chunca ishcay trïbu Israelcuna. Chaynömi papänenga llapan wamrancunata bindisyunta goran pay wañucuptin cada-ünun imanöpis cananpaj. ");
INSERT INTO qub_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Chaypitana juc junaj Jacobga llapan wamrancunata cayno niran: «Ñaupa wañoj castäcunawan tincoj aywacunäpänami caycä. Pampaycäramanqui Het runa Efronpa chacrancho taytäcuna pamparaycashan machay uchcuman. ");
INSERT INTO qub_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","Chayga caycan Canaán particho Mamrepa chimpan Macpelacho machay caycajmi. Chaytaga chacrantinta Abrahammi Efronpita rantiran llapan castancunawan chayman pampacunanpaj. ");
INSERT INTO qub_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Chaymanmi pamparan Abrahamtapis warmin Saratawan, Isaactapis warmin Rebecatawan. Nogapis chaymanmi pamparä Leata. ");
INSERT INTO qub_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Chaycho caycaj chacratawan machaytaga rantiran Het runacunapitami.» ");
INSERT INTO qub_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Chayno llapan wamrancunata willapayta usharcur Israelga cämanman yapay wegucuycuran. Nircur wañucäcuran. ");
INSERT INTO qub_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Wañucäcuptin Josëga papäninpa cuerpunta macallacurcur wagashpan mucharan. ");
INSERT INTO qub_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Chaypita Josëga paypa munaynincho caycaj mëdicucunata niran papäninpa cuerpunta jampinanpaj aychan mana gotucänanpaj. Chaura mëdicucunaga José nishanno ruraran. ");
INSERT INTO qub_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Mëdicucunaga chay ruraycho goyaran chuscu chunca (40) junaj. Chayno junajtarämi wañusha runapa cuerpun gotucänanta jampiyta ushaj. Israeltaga llapan Egipto runacuna lüturan ganchis chunca (70) junaj. ");
INSERT INTO qub_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Lütuyta ushashanpitana Josëga parlaran palasyucho caj mandajcunawan. Paycunata cayno niran: «Gamcunapaj rasunpa noga alli casha captëga nogapa ruquë faraonta ruwapaycamay ari. ");
INSERT INTO qub_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","Papänëmi wañunanpaj caycashancho nogata jurachimaran, pay wañuptin quiquin uchcucushan uchcuman pampachinäpaj. Chayga caycan Canaán partichömi. Nogaga ruwacö papänëta pampaj aywanäpaj aunimänanpämi. Papänëta pampaycacherga cutimushämi.» ");
INSERT INTO qub_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Chayno willaptin faraonga niran: «Aywachun ari. Papänin nishanno pampamuchun.» ");
INSERT INTO qub_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Chaypita papäninta pampaj José aparan. Chaymi Egipto palasyucho mandajcunapis yan'garan. ");
INSERT INTO qub_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Jacobpa llapan castancuna, Josëpis, wauguincunapis aparan papäninta pampaj. Jacobta pampaj aywacuptin Gosenchöga quëdaran wamracunawan uywancunalla. ");
INSERT INTO qub_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Aypalla runacuna Josëta yan'garan chaquipapis, carrëtacunawanpis. ");
INSERT INTO qub_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Goren-ha-atad pampaman chayaran. Chayga caycan Jordán mayupa chimpanchömi. Chaychöga José fiyupa llaquicushpan lütur goyächiran ganchis junaj. ");
INSERT INTO qub_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Chaycho tiyaj Cananeo runacuna ricashpan cayno nipäcuran: «Egipto runacunaga fiyupa llaquicushpanmi lütuycan» nir. Chaypitami chay partipa jutinta churaparan «Abel-mizraim» nishpan. Chayga caycan Jordán mayupa chimpanchömi. ");
INSERT INTO qub_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Jacobpa wamrancunaga llapantapis cumliran papänin caway shiminpa nishanno. ");
INSERT INTO qub_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Canaanman apaycärir Het runa Efronpita Abraham pampacunanpaj rantishan Macpelacho machay uchcu caycajman pamparan. Chay chacraga machaynintin caycan Mamrepa chimpanchömi. ");
INSERT INTO qub_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Papäninta pampaycärir Josëga llapan wauguincunawan Egiptuman cuticuran. Llapan aywäshej runacunapis paycunawan iwal cuticuran. ");
INSERT INTO qub_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Jacob wañushanpitanaga Josëpa wauguincuna cayno yarpar parlacuran: «Canan Josëga payta mana allita rurashanchïmannömi ayñita cutichimäshun» nir. ");
INSERT INTO qub_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Chayno yarparmi jucninta cacharan Josëta cayno ninanpaj: «Papäninchi manaraj wañurmi niran ");
INSERT INTO qub_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","gamta mana allita rurar juchata rurashäpita perdunamänayquipaj. Chaymi ruwacö mana alli rurashäcunapita perdunamänayquipaj. Nogacunapis cä papäninchi rispitashan Diosta sirbejmi» nir. Willaptin Josëga wagaran. ");
INSERT INTO qub_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Chaypita wauguincuna José cajman chayaycur pasaypa manchacushpan ñaupanman gongurpacuran urcunpis pampaman töpanancama. Paycuna niran: «Cananga gampa uywayniquicunami caycä.» ");
INSERT INTO qub_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Chaura José niran: «Gamcuna ama manchacamaychu. Nogaga manami Dioschu cä pita jusganäpäpis. ");
INSERT INTO qub_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Gamcunaga yarparayqui nogata chiquimar mana allita ruraycämashayquita. Chaytami Diosga rucachisha alliman, canan ricashanchïno runacunata wañunanpita salbanäpaj. ");
INSERT INTO qub_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Gamcunaga manami imapitapis manchacamänayquichu. Nogami micuytaga goshayqui quiquiquicunapäpis wamrayquicunapäpis.» Chayno nishpanmi Josëga wauguincunata alli shiminpa parlapar shacyächiran. ");
INSERT INTO qub_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Josëwan papäninpa castancuna tiyacuran Egiptullachöna. Josëga cawaran pachac chuncan (110) watayoj canancama. ");
INSERT INTO qub_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Chaymi wamran Efrainpa willcanpa wamrantapis ricaranraj. Manasespa wamran Maquirpa wamrancunatapis Josëga wamrantanöraj chasquiran. ");
INSERT INTO qub_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Chaypita juc junajcho wauguincunata José niran: «Wañucojnami-aywä. Diosmi shamongapaj gamcunata yanapäshunayquipaj. Paymi jorgushunquipaj cay nasyunpita. Nircurmi pushashunquipaj Abrahamta Isaacta Jacobta aunishan Canaán partiman.» ");
INSERT INTO qub_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Llapan wauguincunata jurachishpan Josëga cayno niran: «Diosga rasunpami shamongapaj gamcunata yanapäshunayquipaj. Chayno captenga nogapa tullötapis caypita apacunqui» nir. ");
INSERT INTO qub_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Egiptucho José wañuran pachac chuncan (110) watayoj caycashancho. Wañuptin Josëpa cuerpuntapis mëdicucuna jampiran aychan mana gotucänanpaj. Jampircärir cajunman churaycäriran.");
INSERT INTO qub_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Egipto nasyunman Jacob aywacuptin llapan wamrancunapis castantin aywaran. Egiptuman chayaj Israelcunapa jutincuna caycunami caran: ");
INSERT INTO qub_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Rubén, Simeón, Leví, Judá, ");
INSERT INTO qub_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","Isacar, Zabulón, Benjamín ");
INSERT INTO qub_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","Dan, Neftalí, Gad, Aser. ");
INSERT INTO qub_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Wamrancunawan willcancunawan Jacobga ganchis chuncami (70) Egiptuman chayaran. Josëga Egiptuchöna caycaran. ");
INSERT INTO qub_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Chaycho tiyarcaycashancho wañuranna Josëpis, llapan wauguincunapis, Egiptuman llapan chayajcunapis. ");
INSERT INTO qub_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","Ichanga Israelcuna fiyupa aypallamanna miraran. Paycunaga chay partipa intëruchöna aypacasha caycaran. Chaymi manchariypäna caran. ");
INSERT INTO qub_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Chaypita mas guepataga juc runana yaycuran Egiptupa raynin cananpaj. Chay rayga mana musyarannachu pï José cashantapis. Chay raymi Egiptucunata niran: ");
INSERT INTO qub_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","«Tantiyacuy-llapa: Israelcunaga fiyupa manchariypämi mirarcaycan. ");
INSERT INTO qub_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Cananga yarpachacushun mana mirananpaj imano rurananchïpäpis. Guërra captin-imaga contranchïcunamanmi guellicunman noganchïwan pillyananpaj. Binsiycamashpanchëga nasyunninchïpita aywacongami.» ");
INSERT INTO qub_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Chayno parlacarcärirmi Israelcunata ñacachir sasa aruycunacho aruchinanpaj achcaj capatascunata churaran. Chaynöpami faraonga aruchiran Pitón jutiyoj siudäta, Ramsés jutiyoj siudätapis. Chay siudäcunaga caran faraonpa ima-aycantapis churachinanpämi. ");
INSERT INTO qub_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Chayno ñacachiptinpis Israelcunaga chaynöllami miraycaran. Chaura Egiptucunaga Israelcunata fiyupana manchacoj. ");
INSERT INTO qub_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","Chaymi Israelcunataga fiyupa sasa aruycunachöna aruchej. ");
INSERT INTO qub_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","Fiyupa ñacachej sinchi aruycunacho aruchir, mitutapis adöbitapis rurachir, chacracunatapis aruchir. ");
INSERT INTO qub_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Egipto nasyunpa raynenga gayachimuran ishcay hebrea partëracunatapis Sifra jutiyojtawan Fúa jutiyojta. Chay partëracunata niran: ");
INSERT INTO qub_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","«Hebreo warmicuna gueshyacuptin, yuripacachej aywar gamcunaga ricanqui iti warmi u ollgu cashanta. Ollgu captenga wañurachinqui. Warmi captenga ama wañuchinquichu.» ");
INSERT INTO qub_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Chaypis partëracunaga Diosta rispitashpanmi Egiptupa raynin nishannöga mana ruraranchu. Chaypa ruquenga ollgu wamra yurejcunapis alli cawananpaj yanaparan. ");
INSERT INTO qub_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Chaura Egiptupa raynenga partëracunata yapay gayachiran. Paycunata niran: «¿Imanirtaj nishätaga mana rurashcanquichu? ¿Imanirtaj ollgu wamra yurejcuna cawananta dëjashcanqui?» ");
INSERT INTO qub_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Niptin partëracunaga faraonta niran: «Hebreo warmicunaga manami Egipto warmicunanöchu. Paycunaga sinchimi. Chaymi nogacuna manaraj chayaptë quiquillanna gueshyacurin.» ");
INSERT INTO qub_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","21","Partëracuna Diosta rispitar ollgu wamra yurejcunata mana wañuchishanpitami Diosga partëracunatapis yanaparan famillyancuna mirananpaj. Chaynöpami Israelcunaga aypallamanna mirarcaycaran. Achca car mas munayniyojna caran. ");
INSERT INTO qub_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Chaura faraonga llapan Egipto runacunata niran: «Hebreocunapa ollgu wamran yurejtaga manyapita mayuman garpuy. Warmi cajcunata ichanga cawananpaj cachaycuy.» ");
INSERT INTO qub_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Juc runami majachacaran. Paycunaga ishcanpis caran Leví trïbupitami. ");
INSERT INTO qub_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Tiyaycashanchönami warmin gueshyaj ricacur gueshyacuran ollgu wamrata. Cuyayllapaj maucha captinmi mamanga quimsa quilla pacayllapa charäcuran. ");
INSERT INTO qub_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Chaypita mastaga pacayllapa charayta manana puydirannachu. Chaymi totorapita awaran batyatano. Nircur llapan uchcuncunata breyawan chaparan yacu mana yaycunanpaj. Chayno rurarcur awashan rurinman wamranta wiñarpuran. Nircur churaycuran Nilo mayu cantuncho ututucuna caycaj chaupinman. ");
INSERT INTO qub_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Itipa pañinna carullapita ricapaycaran itita ima päsashantapis musyananpaj. ");
INSERT INTO qub_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Chay junaj faraonpa warmi wamranga mayuman bäñacoj aywaran. Bäñacushancama yanasancunaga mayu cantunpa purircaycaran. Faraonpa wamranga ricaran totora chaupincho batyano caycämojta. Chaymi uywayninta niran apapänanpaj. ");
INSERT INTO qub_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Quicharir tariran iti wagaycajta. Chaura faraonpa wamranga itita cuyapar «Cayga hebreo wamrachaj» niran. ");
INSERT INTO qub_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Chaura itipa pañinna faraonpa wamranta niran: «¿Munanquimanchu cay itita uywapar chuchupäshunayquipaj hebrea warmita gayapämunäta?» ");
INSERT INTO qub_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Chayno niptin niran: «¡Mä gayaraycamuy!» Chaura wamraga aywaran itipa mamanta pushamoj. ");
INSERT INTO qub_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Chayaptin faraonpa wamranga niran: «Cay wamrata uywapämay. Uywapämashayquipitaga pägashayquimi» nir. Chauraga itita uywapänanpaj apacuran. ");
INSERT INTO qub_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Chaypita wiñar jatullanna captenga faraonpa wamranman cutichiparcuran. Chaura paynami uywacuran quiquinpa wamrantano. «Yacupitami jorgucushcä» nirmi jutinta churaparan Moisés nir. ");
INSERT INTO qub_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Chaypita Moisés jatunna cashpan juc junaj aywaran hebreo-masincunata ricaj. Chaycho ricar rasunpa musyaran hebreo-masincuna fiyupa ñacar arurcaycajta. Chaychömi ricaran Egipto runa hebreo runata magaycajtapis. ");
INSERT INTO qub_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Chaymi Moisés intërupa ricchacuran. Pitapis mana ricar Egipto runataga wañuycachiran. Nircur agushllaman pampaycuran. ");
INSERT INTO qub_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Warannin yapay Moisés aywaran. Chaycho ishcaj hebreo runacuna pillyaycajta tariran. Chaymi mas magaj cajta tapuran «Hebreo-masiquitaga ¿imanirtaj magaycanqui?» nir. ");
INSERT INTO qub_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Niptin magaycäga niran: «Gamtaga ¿pitaj churasha-cashunqui mandajnë, jueznë canayquipaj? ¿Egipto runata wañuchishayquino wañuchimaytachu yarpanqui?» Chayno niptin Moisés fiyupa manchacuran. Chaymi yarpachacur niran: «Egipto runata wañuchishäga mayacashanachaj» nir. ");
INSERT INTO qub_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Rasunpa, faraonpis mayaranna Egipto runata Moisés wañuchishanta. Chaymi Moisesta wañuchinanpaj ashichiran. Chaura faraonpita gueshpir aywacuran. Chayno aywacurmi Madián partiman tiyaj aywacuran. Chayaycorga yacu pösupa ñaupanman jamacuycuran. ");
INSERT INTO qub_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Madianchömi tiyaran Reuel jutiyoj runa. Payga caran Madián runacunapa cüranmi. Paypami ganchis jipash wamrancuna caran. Pösu ñaupancho Moisés jamaraycaptinmi chay ganchis jipashcuna chayaran papäninpa uyshancunata cabrancunata upuchinanpaj yacuta jorgoj. ");
INSERT INTO qub_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Chaynöpis chay pösuman achcaj uyshërucuna chayaran. Chay uyshërucunami jipashcunata yacuta michar garguran. Chayta ricar Moisesga warmicunata washaran. Nircur uyshancunata cabrancunatapis yacuta upuchëshiran. ");
INSERT INTO qub_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Jipashcuna papänin Reuel cajman cutiycuptin tapuran: «Canan junäga ¿imanirtaj mas rätulla cutiramushcanqui?» nir. ");
INSERT INTO qub_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Chaura papäninta paycuna willaran: «Juc Egipto runami gargarcaycämaj uyshërucunata michasha. Nircur uywanchïcunatapis yacuta upuchëshimasha» nir. ");
INSERT INTO qub_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Chayno willaptin papänin tapuran: «¿Maytaj chay runaga? ¿Imanirtaj cachaycäramushcanqui? ¡Ayway pushamuy garananchïpaj!» ");
INSERT INTO qub_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Chaura Moisesga Reuel cajman aywaran. Chaycho parlar auniran chay cürapa wasincho tiyacunanpaj. Reuelga Séfora jutiyoj wamranwan Moisesta majacharan. ");
INSERT INTO qub_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Chaypita Seforapa caran ollgu wamran. Chaura Moisesga «Cay marcacho jäpa runami cä» nishpan Gersón nir jutinta churaparan. ");
INSERT INTO qub_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Chaypita mas unaytanaga Egiptupa raynin wañuran. Israelcunaga jinalla Diosta mañacurcaycaran amatar ñacay aruycunacho cashpan. Chayno llaquicur mañacushancunata Dios wiyaran. ");
INSERT INTO qub_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Abrahamwan Isaacwan Jacobwan unay conträtu rurashanta yarpashpanmi mañacushanta wiyar cuyaparan. ");
INSERT INTO qub_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Chaynöpis ricaran Israelcuna fiyupa ñacarcaycashanta. ");
INSERT INTO qub_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Moisesga suyrun Jetropa uyshancunatami michej. Jetroga caran Madián runacunapa cüranmi. Juc junaj Moisesga suyrunpa uyshancunata cabrancunata michej gatir chayachiran chunyajman. Chay chunyajcho caran Dioswan tincunan punta Horeb. ");
INSERT INTO qub_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Chaycho Tayta Diospa anjilnin Moisesta yuriparan shiracho nina rataycajno. Moisés nina rataycajta ricar cuentata gocuriran shirata mana ushashanta. ");
INSERT INTO qub_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Chaura yarpachacuran «¿Imaraj tagay? Mä, aywä ricamushaj. ¿Imanir-raj ninaga shirata mana ushanchu?» nir. ");
INSERT INTO qub_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Ricaj chayaycaptinna shiracho nina rataycajpita Tayta Dios nimuran: «Moisés, Moisés» nir. Chaura Moisés niran: «Caychömi caycällä.» ");
INSERT INTO qub_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Niptin Dios niran: «Ama witimuychu. Llanguiquita jorguy. Caycashayqui pachaga fiyupa rispitädumi.» ");
INSERT INTO qub_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Mastapis niran: «Nogaga unay caj awiluyquicuna Abrahampa, Isaacpa, Jacobpa Diosninmi caycä» nir. Chayno niptenga Diosta ricapayta manchacushpan Moisés cäranta chapacurcuran. ");
INSERT INTO qub_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Chaypis Tayta Dios sïguir niycaran: «Musyämi Egiptucho acrashä runacuna fiyupa llaquicur goyaycashanta. Wiyashcämi capatasnincuna ñacachiptin llaquicur mañacamashantapis. ");
INSERT INTO qub_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","Chaymi urämushcä acrashä runacunata Egiptucunapa munayninpita jorgunäpaj. Chay nasyunpita jorgurcurmi pushashaj alli jatun may-may partiman. Chaychöga ima-aycapis allimi wayun. Lëchipis, mishquipis yacunörämi aypalla caycan. Chay partichöga tiyarcaycan: Cananeo runacuna, Het runacuna, Amorreo runacuna, Ferez runacuna, Hev runacuna, Jebús runacunapis. ");
INSERT INTO qub_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Wiyashcämi Israelcuna mañacamashanta. Ricashcämi Egipto runacuna fiyupa ñacaycächishantapis. ");
INSERT INTO qub_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Chaymi cananga acracushä Israelcunata Egiptupita jorgamunayquipaj gam ayway faraón cajman.» ");
INSERT INTO qub_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Chaura Moisesga Diosta niran: «¿Pitaj nogaga cä faraón cajman aywanäpaj, Egiptupita Israelcunata jorgamunäpäga?» ");
INSERT INTO qub_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Chayno niptin Dios niran: «Nogami gamwan caycäshäpaj. Noga cachashäta musyanayquipaj caynömi canga: Egiptupita Israelcunata jorgaycamorga cay jircamanmi llapayqui shamunquipaj aduramänayquipaj.» ");
INSERT INTO qub_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Chaura Moisesga Diosta niran: «Ichanga noga chayar Israel-masëcunata ‹Unay caj awilunchïcunapa Diosninmi cachamasha› niptëga, paycuna tapumanga ‹¿Imataj jutin?› nir. Chauraga ¿ima nishätaj?» ");
INSERT INTO qub_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Niptin Diosga niran: «Nogaga quiquëmi caycä. Gampis Israelcunata ninqui ‹quiquëmi caycä nimajmi gamcunaman cachamasha› nir.» ");
INSERT INTO qub_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Mastapis Diosga Moisesta niran: «Israelcunata ninqui: ‹Tayta Diosmi cachamasha. Payga unay caj awilunchi Abrahampa, Isaacpa, Jacobpa Diosninmi› nir. Imaycamapis chayllami nogapa jutëga. Chay jutiwanmi imaycamapis rejsimanga. ");
INSERT INTO qub_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","«Chayaycushpayquega mayur Israelcunata llapanta shuntanqui. Paycunata ninqui: Awiluyquicuna Abrahampa, Isaacpa, Jacobpa Diosninmi yuripämasha. Chay Tayta Diosmi nimasha: ‹Noga ricashcämi Egiptucuna fiyupa ñacarcaycächejta› nir. ");
INSERT INTO qub_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","Chayno nirmi nimasha: ‹Egiptucho fiyupa ñacarcaycashanpita jorguycurmi pushashaj Cananeo runacuna, Het runacuna, Amorreo runacuna, Ferez runacuna, Hev runacuna, Jebús runacuna tiyarcaycashan partiman. Chaychöga ima-aycapis aypalla captin lëchipis mishquipis yacunöraj aypallanpami caycan› nir. ");
INSERT INTO qub_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","«Mayurcunaga willapashayquita chasquengami. Chaura paycunawanna aywanqui Egiptupa rayninwan parlaj. Chay rayta ninqui: ‹Hebreo runacunapa Tayta Diosninmi nogacunata yuripämasha. Chaymi nogacuna quimsa junaj aywayta chunyajman aywanäpaj aunimay. Chaychömi payta adurar uywäcunata pishtar sacrifisyuta rurashaj› nir. ");
INSERT INTO qub_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Chayno niptiquipis Egiptupa raynenga aywamunayquita manami munangapächu. Ichanga nogarämi camacächishaj ‹aywacuy› nishunayquipaj. ");
INSERT INTO qub_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Nogami Egiptucunataga imano munayniyoj cashätapis musyachishaj, almiraypajcunata rurashaj. Chayrämi chay rayga ‹Aywacuy› nishunquipaj. ");
INSERT INTO qub_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","«Chayno rurarmi noga camacächishäpaj Egiptucuna alliyacäcur imatapis goycushunayquipaj. Chaymi llojshicushpayquicuna jinayllaga mana aywacunquipächu. ");
INSERT INTO qub_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Israel warmicunaga bisïnan Egipto warmicunata, bisïnanpa wasincho tiyaycaj warmicunata ‹Goycamay› nenga goripita, guellaypita rurashacunata. Chayno röpacunatapis ‹Goycamay› nenga wamrancunata warmita ollgutapis jatipänanpaj. Chaynöpami gamcunaga Egiptucunapa ima-aycantapis apacunquipaj.» ");
INSERT INTO qub_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Chayno niptin Moisés niran: «Paycunaga manami riguimangapächu. Willapaptëpis manami wiyamangapächu. Chaymi nimangapaj ‹Gamtaga ¿imanöpataj Tayta Dios yuripaycushunqui?› nir.» ");
INSERT INTO qub_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Niptin Tayta Dios tapuran: «¿Imatataj aptaraycanqui?» nir. «Tucrötami» niran Moisesga. ");
INSERT INTO qub_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","Chaura Tayta Dios niran: «Mä pampaman jitaycuy.» Pampaman jitaycuptin tucronga culebraman ticracuriran. Chaura Moisesga culebrapita gueshpiran. ");
INSERT INTO qub_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Gueshpiptin Tayta Dios niran: «Chupanpita chariy.» Chaura aypar aptarcuptin culebraga tucrunman cashgan ticracuriran. ");
INSERT INTO qub_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","Chaura Tayta Dios niran: «Chayga canga unay caj awiluyquicuna Abrahampa, Isaacpa, Jacobpa Tayta Diosnin yuripashäta riguishunayquipämi.» ");
INSERT INTO qub_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Chayno nishpan yapaypis Tayta Dios niran: «Cananga maquiquita ogllayniquiman jatiy.» Chaura maquinta ogllayninman jatisha. Jorgaramuptin rashtano yur'gasha leprawan ismuycajna caycasha. ");
INSERT INTO qub_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Chaura Dios niran: «Maquiquita yapay ogllayniquiman jatiy.» Chayno niptin Dios nishanno ruraran. Maquinta jorgaramuptin cashganno sänuna caycaran. ");
INSERT INTO qub_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Chaypita Dios niran: «Rimir caj rurachishäta ricar mana riguishuptiquega yapay jucajta rurachishä cajwanrämi riguishunquipaj. ");
INSERT INTO qub_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Ishcanta rurachishäcunawan mana riguishuptiquega Nilo mayupita yacuta chagarcur pampaman jicharinqui. Chay yacuga pampaman chayar yawarmanmi ticracurengapaj.» ");
INSERT INTO qub_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Chayno Tayta Dios niptin Moisés niran: «Tayta Dios, nogaga parlayta ñacapacämi. Nogaga parlarpis manami tantiyachëchu. Chayno cashäga manami cananllarächu sinöga unaypita-pachanami.» ");
INSERT INTO qub_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Niptin Tayta Dios niran: «¿Pitaj runapa shiminta rurapasha? ¿Pitaj camacächin upa cananpaj mana wiyaj cananpaj, gapra cananpaj, alli ricaj cananpäpis? ¿Manachu Noga Tayta Dios llapan chaycunatapis camacächë? ");
INSERT INTO qub_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Cananga ayway. Gam parlashayqui öra Nogami rimachishayquipaj. Imano parlanayquipäpis yachachishayquipaj.» ");
INSERT INTO qub_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Moisés yapay niran: «Ay Tayta, juc runata cachaycuy ari.» ");
INSERT INTO qub_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Niptin Tayta Diosga rabyacurcur niran: «Chaypäga caycan Leví trïbu wauguiqui Aaronmi. Payga allimi parlan. Payga maynami aywaycämun tincunayquipaj. Tincuycuptiquega fiyupami cushicongapis. ");
INSERT INTO qub_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Nishäcunata gamga payta willapanqui. Paynami waquin runacunata willapanga. Noganami ishcaniquita yanapäshayquipaj alli parlanayquipaj. Yachachishayquipaj imata ruranayquipäpis. ");
INSERT INTO qub_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","Quiquë willapaycashänömi gamga Aaronta willapanqui. Gam nishayquitanami Aarón willapanga llapan Israelcunata. ");
INSERT INTO qub_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Chay tucruyquitaga apacuy. Chaywanmi fiyupa almiraypajcunata ruranquipaj.» ");
INSERT INTO qub_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Chaypitana Moisesga cutiran suyrun Jetro cajman. Chayaycur niran: «Tayta, Egiptucho Israel-masëcuna caycajta ricaycamushaj. Mä ¿cawaycanrächush?» Chaura suyrun Jetroga niran: «Ayway ari. Allilla puriycamunqui». ");
INSERT INTO qub_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Madiancho caycaptillan Moisesta Tayta Dios niran: «Cutiy Egiptuman. Gamta wañuchiyta munashojcunaga llapannami wañusha.» ");
INSERT INTO qub_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Chaymi Moisesga warminta wamranta bürruman muntarcachir Egiptuman pushacuran. Apacuran Dios «Apay» nishan tucruntapis. ");
INSERT INTO qub_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Tayta Diosga Moisesta niran: «Egiptuman chayashpayquega faraonpa ñaupancho ruranqui ruranayquipaj nishä almiraypajcunata. Nogami munaynëwan camacächishaj faraón rumi shonguno contra ricacunanpaj. Chaymi Israelcuna aywacunantaga mana munangapächu. ");
INSERT INTO qub_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Chaura faraonta cayno ninquipaj: ‹Tayta Diosga caynömi nin: Israelcunaga mayur wamrämi. ");
INSERT INTO qub_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","Chaymi gamtaga mayna nishcäna aduramaj aywananpaj wamräta cacharinayquipaj. Aywacunanta mana munaptiquega guechpa wamrayquitami wañuchishaj.› » ");
INSERT INTO qub_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Chaypita Egiptuman aywacurcaycashancho tardiyar puñunanpaj juc pachaman camacaran. Chaycho yuriparcur Tayta Diosga Moisesta wañuchiyta munaran. ");
INSERT INTO qub_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","Chaura Seforaga fïnu guechgawan cuchuran wamranpa chiullacunanpa punta garanta. Nircur chaywan runan Moisespa chancanta töpachir niran «Cananga yawarwan señalasha runänami canqui» nir. ");
INSERT INTO qub_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","Chayrämi Tayta Diosga Moisespita witicuran. Wamranpa chiullacunanpa punta garanta Séfora rogusha cashpanmi niran: «Yawarwan señalasha runänami canqui» nir. ");
INSERT INTO qub_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Moisés aywaycaptin Aarontaga Egiptucho caycajta Tayta Dios niran: «Ayway chunyajman chaycho Moiseswan tincunayquipaj» nir. Chaura Aarón aywashpan Moisesta tariran Tayta Dioswan ñaupata tincushan puntacho. Moiseswan tincur muchashpan saludanacuran. ");
INSERT INTO qub_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Chaycho Moisesga Aaronta willaparan Tayta Dios imano nishantapis, chayno almiraypajcunata rurananpaj Tayta Dios cachaycashantapis. ");
INSERT INTO qub_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Egiptuman chayaycurna Aaronwan Moisés ishcan aywaran mayur Israelcunata shuntananpaj. ");
INSERT INTO qub_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Shuntaycur Aarón willaparan Moisesta Tayta Dios parlapashancunata. Chaychöna Aaronga runacunapa ñaupancho Tayta Dios nishannölla almiraypajcunata ruraran. ");
INSERT INTO qub_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","Chaymi llapan runacuna riguishpan niran: «Tayta Diosga ricamashcanchïmi imano ñacar goyashanchïtapis» nir. Chayno nishpan gongurpaycärir Tayta Diosta aduraran. ");
INSERT INTO qub_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Israelcunawan parlarcärir Aaronwan Moisesga faraón cajman aywaran. Chayaycur niran: «Israelcunapa Tayta Diosninmi cayno nin: ‹Acrashä runacunata cachay chunyajman aywaycur Nogata rispitamashpan fistata rurananpaj› nir.» ");
INSERT INTO qub_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Chayno niptin faraón niran: «¿Pitaj chay Tayta Dios, Israelcunata cachanäpäga? Nogaga manami chay Tayta Diosta rejsëchu. Israelcunatapis manami cachashächu.» ");
INSERT INTO qub_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Niptin Aaronwan Moisesga niran: «Hebreocunapa Diosninmi yuripämasha. Chaymi chunyajman aywashäcuna quimsa junaj aywayta. Chaychömi Tayta Diosta adurashpä sacrifisyuta rupachishaj. Man'chäga Dios castigamangami gueshyawanpis u guërrawanpis.» ");
INSERT INTO qub_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Chaura Egiptupa faraonnenga niran: «Moisés, Aarón, ¿imanirtaj alli arucuycaj runacunata aruyninpita jorguyta munaycanqui? ¡Gamcunapis aroj cutiy!» ");
INSERT INTO qub_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Faraonga mastapis niran: «Canan Israelcunaga cay nasyuncho aypallamanmi mirasha. ¿Imanirtaj aruyninta cachaycachiyta munarcaycanqui?» ");
INSERT INTO qub_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Nircur faraonga chay junajlla Egipto capatasnincunata, Israel capuralcunata niran: ");
INSERT INTO qub_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","«Cananpitaga amana ogshata goynachu Israelcuna adöbita chutananpaj. Quiquincunana aywachun ogsha ashimoj. ");
INSERT INTO qub_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Ichanga imaypis rurashantano ni jucpis mana pishejta rurachiy. Chay runacunaga guellami. Chaymi nircaycan ‹Chunyajman Tayta Diosnëpaj uywata pishtarcur rupachej aywashaj› nir. ");
INSERT INTO qub_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Canan junajpita Israelcunataga aruchinqui mana jamachiypana aruywan ñitipacashana cashpan manacajcunata riguichishanta mana cäsupänanpaj.» ");
INSERT INTO qub_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Chaymi capatascunawan capuralcuna aywaycärir runacunata niran: «Faraonmi nimasha cananpitaga gamcunata ogshata manana ashichipämunäpaj. ");
INSERT INTO qub_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Cananga quiquiquicuna ogshata ashimunqui. Chaypis adöbitaga ruranqui imaypis rurarcaycashayquitawan iwal mana pishejtami.» ");
INSERT INTO qub_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Chaura Israelcunaga intëru Egiptupa aywaj punsha ashej ogshapa ruquin mituman tacuchinanpaj. ");
INSERT INTO qub_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Capuralcunanami waran-waran nircaycaran ogshata camaripaptin ruranyashantanölla adöbita chutananpaj. ");
INSERT INTO qub_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Capatascunaga Israel capuralcunata churaran Israel-masincunata aruchinanpaj. Mana cumlichiptinnami capuralcunata magar niran: «¿Imanirtaj ganyanpis ni cananpis adöbita mana chutachishcanquichu ogshata camaripaptin chutachishayquitanöga?» ");
INSERT INTO qub_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Chaymi Israel capuralcunaga quijacoj aywaran faraonman. Chayaycärir niran: «Uywayniquicunataga ¿imanirtaj fiyupa ñacachimanquicuna tayta? ");
INSERT INTO qub_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Capatasniquicunaga ogshatapis mana gomannachu. Chaypis ñaupata adöbita rurachishätanöraj rurachinäcunata munan. Jananmanpis magarcaycämanraj. Capatasniquicunami juchayoj adöbita ñaupata rurashan iwalta mana rurananpäpis.» ");
INSERT INTO qub_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Chayno niptin faraón niran: «Gamcunaga guellami canqui. Chaymi nircaycanqui ‹Chunyajman Tayta Diospaj sacrifisyuta ruraj aywanäpaj cachamay› nir. ");
INSERT INTO qub_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Chayno ninayquicunapa ruquenga aroj ayway. Ogshata mana goshuptiquicunapis gamcunaga adöbita simri rurachiy ñaupata rurashan iwalta.» ");
INSERT INTO qub_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","«Manami mas wallcataga rurachinquichu adöbita» nishanpitami capuralcunaga fiyupa llaquicur yarpachacuyman churacaran. ");
INSERT INTO qub_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Chay capuralcuna faraonwan palasyuncho parlashanpita yargaramurmi tariran Aaronwan Moisés shuyarpaycajta. Paycunatami capuralcunaga niran: ");
INSERT INTO qub_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","«Gamcunami juchayoj canqui faraón capatasnincunawan fiyupa ñacachimänanpaj. Nogacunata wañuchimänanpaj cuchilluta aptapajnöpis gamcunami achäquita ashipashcanqui. Nogacunapaj chayno mana allita rurashayquipita Tayta Dios jusgar gamcunata castigashunqui.» ");
INSERT INTO qub_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Chayno niptinmi Tayta Diosta mañacur Moisés niran: «Tayta Dios, ¿imanirtaj acrashayqui runacunata ñacaycächinqui? ¿Chaypächu cachamashcanqui? ");
INSERT INTO qub_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Faraonwan parlaj cachamashayqui junajpita-pachanami acrashayqui runacunataga magashpan fiyupa ñacaycächin. ¡Gamga manarämi imatapis ruranquirächu ñacashanpita jorgunayquipaj!» ");
INSERT INTO qub_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Niptin Tayta Dios niran: «Cananmi musyanqui Egiptupa faraonninta imano castigashätapis. Munayniyoj cashäta musyachiptërämi nasyunninpita cacharenga. Quiquinrämi ‹Aywacuy› nir gargongapis.» ");
INSERT INTO qub_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Juc cutichöna Moisesta Tayta Dios niran: «Nogaga Tayta Diosmi cä. ");
INSERT INTO qub_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Abrahamta, Isaacta, Jacobta yuriparcur noga musyachirä Munayniyoj Dios cashäta. Ichanga paycunata manami willarächu Tayta Dios jutë cashanta. ");
INSERT INTO qub_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Chaymi paycunawanpis conträtuta rurarä Canaán partita paycunapita mirajcunata goycunäpaj. Chaychöga puricachajllami tiyarcaycaran. ");
INSERT INTO qub_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Israelcunata cananga wiyashcä amatar ñacar wagarcaycajtami. Egipto runacunami fiyupa aruchin. Chaymi cananga unay conträtu rurashäta cumlishäna. ");
INSERT INTO qub_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","«Chaymi gamga Israel-masiquicunata willanqui uyway caycashanpita, fiyupa ñacay aruycunacho caycajtapis, Egiptucunapa munaynincho caycashanpitapis noga Tayta Dios jorgunäpaj cashanta. Munayniyoj cashäta musyachishpämi jorgushaj. Almiraypajcunata rurarmi Egiptucunataga castigashaj. ");
INSERT INTO qub_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Israelcunaga cangapaj noga acrashä runacunami. Nogami cashaj paycunapa Diosnin. Paycunanami musyangapaj Tayta Diosnin cashäta. Egiptucuna fiyupa ñacay aruycho caycächishanpita jorgurcurmi ");
INSERT INTO qub_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Abrahamta, Isaacta, Jacobta ‹Goycushayqui› nir aunishä partiman pushashaj. Chaytami paycunata goycushaj quiquinpana cananpaj. Noga Tayta Diosmi chayno cananpaj në.» ");
INSERT INTO qub_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Chayno Dios nishanta Moisesga Israel-masincunata willaran. Chaura runacunaga wiyaytapis mana munarannachu mas fiyupana ñacaycho cashpan. ");
INSERT INTO qub_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Chaymi Tayta Diosga Moisesta niran: ");
INSERT INTO qub_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","«Egiptupa faraonninwan parlay Israelcunata nasyunninpita cachaycunanpaj.» ");
INSERT INTO qub_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Chaura Moisesga Tayta Diosta niran: «Israelcunallapis mana cäsuycämaptenga ¿imanöparäshi faraonga wiyamanman? Nogaga parlarpis manami tantiyachëchu.» ");
INSERT INTO qub_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Chaypita Tayta Diosga Aarontawan Moisesta willaparan Israelcunapaj, Egiptupa faraonninpaj. Willaparan Egiptupita Israelcunata imano jorgunanpäpis. ");
INSERT INTO qub_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Israelcunapa unay mandajnincunapa jutincuna caycunami caran: Guechpa Rubenpita mirajcuna cayno caran: Hanoc, Falú, Hezrón, Carmi. Chaycunami caran Rubén trïbu castacuna. ");
INSERT INTO qub_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Simeonpita mirajcunapa jutin cayno caran: Jemuel, Jamín, Ohad, Jaquín, Zohar, Saúl. (Saulpa mamanga caran Cananea warmi.) Chaycunami caran Simeón trïbu castacuna. ");
INSERT INTO qub_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Leví cawaran pachac quimsa chunca ganchis (137) watayoj cananyaj. Wamrancunapa jutin mayurpita shullcacama caynömi caran: Gersón, Coat, Merari. ");
INSERT INTO qub_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Gersonpa wamrancunana caran Libni, Simei. Paycunapitami Libni, Simei castacuna caran. ");
INSERT INTO qub_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Coat cawaran pachac quimsa chunca quimsa (133) watayoj cananyaj. Paypa wamrancuna caran: Amram, Izhar, Hebrón, Uziel. ");
INSERT INTO qub_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Meraripa wamrancunanami caran: Mahli, Musi. Chaynömi Leví trïbu castacuna miraran. ");
INSERT INTO qub_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Coatpita mirajcunaga caynömi caran: Amram majachacaran tiyan Jocabedwan. Paycunapa wamrancunami caran Aaronwan Moisés. Amram cawaran pachac quimsa chunca ganchisnin (137) watayoj cananyaj. ");
INSERT INTO qub_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Izharpa wamrancuna caran: Coré, Nefeg, Zicri. ");
INSERT INTO qub_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Uzielpa wamrancuna caran: Misael, Elzafán, Sitri. ");
INSERT INTO qub_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Aarón majachacaran Aminadabpa wamran Elisabetwan. Elisabetga caran Naasonpa pañin. Aaronpawan Elisabetpa wamrancuna caran: Nadab, Abiú, Eleazar, Itamar. ");
INSERT INTO qub_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Corëpa wamrancuna caran: Asir, Elcana, Abiasaf. Chaycunana caran Coré castacuna. ");
INSERT INTO qub_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Aaronpa wamran Eleazarna majachacaran Putielpa warmi wamranwan. Paycunapa wamranna caran Finees. Chaynömi caran Leví trïbu runacunapa mandajnincuna cada-ünun castancho-cama. ");
INSERT INTO qub_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Chay castallami casha Aaronwan Moisespis. Paycunatami Tayta Dios niran: «Israelcunata Egiptupita jorguy. Paycunataga röpanpa shuntacashallatana pushay.» ");
INSERT INTO qub_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Moiseswan Aaronmi parlaran faraonwanpis Egiptupita Israelcunata jorgunanpaj. ");
INSERT INTO qub_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","Egiptucho Moiseswan Tayta Dios parlashan junaj ");
INSERT INTO qub_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","cayno niran: «Nogami cä Tayta Dios. Noga nishäcunata llapanta willanqui Egiptupa raynin faraonta.» ");
INSERT INTO qub_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Niptin Moisés niran: «Tayta Dios, nogaga rimarpis wata-watallami pashtachë. Chaura ¿imanöparäshi faraonga cäsumanman?» ");
INSERT INTO qub_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Chayno niptin Tayta Dios niran: «Sumaj wiyamay. Nogami gamtaga churashcä faraonpa ñaupancho ruquë canayquipaj. Wauguiqui Aaronnami gampa ruquiqui parlanga. ");
INSERT INTO qub_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Gamga Aaronta willanqui llapan willashäcunata. Chaura paynami faraonwan parlanga Israelcunata Egipto nasyunpita cachaycunanpaj. ");
INSERT INTO qub_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Ichanga nogami camacächishaj faraón rumi shonguno contra ricacunanpaj. Chaynöpami nogaga Egiptucho rurashaj fiyupa almiraypajcunata. ");
INSERT INTO qub_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","Chayta ricarpis faraonga manami cäsushunquipächu. Chaynöpami noga musyachishaj munayniyoj cashäta. Egiptucunata almiraypajcunawan castigarcur-rämi acrashä Israelcunata röpa-röpa pushashaj. ");
INSERT INTO qub_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Israelcunata chayno jorguptërämi Egipto runacunaga musyanga noga Tayta Dios cashäta.» ");
INSERT INTO qub_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Aaronwan Moisesga Tayta Dios mandashanta llapanta ruraran. ");
INSERT INTO qub_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Faraonwan parlashan öra Moisesga caycaran pusaj chunca (80) watayoj, Aaronna pusaj chunca quimsan (83) watayoj. ");
INSERT INTO qub_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Chaypita Aarontawan Moisesta Tayta Dios niran: ");
INSERT INTO qub_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","«Milagrutaraj ruranayquipaj faraón nishuptiquega Aaronta ninqui tucruyquita faraonpa ñaupanman jitarinanpaj. Jitaycuptenga culebramanmi ticracurenga.» ");
INSERT INTO qub_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Niptin Moisesga Aaronwan aywaran faraón cajman. Faraonpawan sirbejnincunapa ñaupanchöna Tayta Dios nishanno ruraran. Aarón tucrunta pampaman jitaycuptin culebraman ticracuriran. ");
INSERT INTO qub_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Chaura faraonpis gayachimuran mäjica rurayta yachajcunatawan brüjucunata. Chay runacunapis mäjicata rurayta yachashpan paycuna rurashanno ruraran. ");
INSERT INTO qub_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Paycunapis pampaman tucruncunata jitaycuptin culebracunaman ticracuriran. Aaronpa tucrunpita culebraman ticraj cäga micucurcuran waquin cajcunapata. ");
INSERT INTO qub_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Chaypis Tayta Dios nishannöllami faraón mas piyur-raj rumi shonguno contra ricacuran. Chaymi Aarontawan Moisestaga mana cäsurannachu. ");
INSERT INTO qub_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Chaypita Tayta Diosga Moisesta niran: «Faraonga fiyupa chucru shongumi ricacusha. Chaymi Israelcunata cachariytapis mana munannachu. ");
INSERT INTO qub_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Culebraman ticraj tucruyquita aptacurcur wara tutalla ayway Nilo mayuman chaycho faraonta shuyänayquipaj. ");
INSERT INTO qub_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","Chaychömi faraonta cayno ninqui: ‹Hebreocunapa Tayta Diosninmi cachamasha gamta willanäpaj. Acrashan runacunata cachay chunyajman aywarcur payta rispitar adurananpaj. Gamga canancamapis manami wiyacushcanquirächu pay nishanta. ");
INSERT INTO qub_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Cananmi ichanga musyanqui pï Tayta Dios cashantapis. Tayta Dios nimashannöllami cay aptaraycashä tucruwan mayuta wiruptë yawarman yacu ticracurengapaj. ");
INSERT INTO qub_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Mayucho caycaj pescäducunapis wañongapämi. Mayupis fiyupa asyaricäcongapaj. Egipto runacunapis Nilo yacuta melanashpan manami upongapänachu› nir. ");
INSERT INTO qub_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","«Aaronta niy: ‹Tucruyquita aptarcur maquiquita jogariy mayucunapa jananpa, ragra-mallwacunapa gochacunapa, chayno yacu churacunanmanpis llapan yacu yawarman ticrananpaj. Chaura Egiptucunapachöga yawar canga llapan yacu churacunancunacho, asta rumipita muchcancunacho, guerupita rurashan pucucunacho churaraj yacuncunapis› nir.» ");
INSERT INTO qub_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Chaura Aaronwan Moisesga ruraran Tayta Dios nishanno. Aaronga tucrunta jogarcur mayuta wiruran faraonpawan autoridänincunapa ñaupancho. Chaura llapan yacu jinan öra yawarman ticracuriran. ");
INSERT INTO qub_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Mayucho caj pescäducunapis wañuran. Mayupis fiyupa asyaricäcuran. Chaura Egipto runacunaga yacuta upuytapis mana puydirannachu. Egipto nasyunchöga llapan yacu yawarman ticrasha caycaran. ");
INSERT INTO qub_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Egiptucho tiyaj brüjucunapis mäjicata rurayta yachashpan yacuta yawarman ticrachiran. Chaura faraón mas piyur-raj rumi shonguno contra ricacuran. Aaronwan Moisés nishancunataga imanillarpis mana cäsurannachu. Tayta Dios willashannömi caran. ");
INSERT INTO qub_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Faraonga imatapis mana gocur palasyunman cuticuran. ");
INSERT INTO qub_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Chaura llapan Egiptucunaga mayu yacuta manana upuyta puydirannachu. Chaymi mayu cantuncunacho pösuta uchcuran chayllapitana yacuta upunanpaj. ");
INSERT INTO qub_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Mayuta Tayta Dios wiruchishanpitaga ganchis junajna caran. ");
INSERT INTO qub_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Chaura Tayta Diosga Moisesta niran: «Ayway faraonman. Chayaycur nogapa ruquë ninqui aduramaj aywananpaj acrashä runacunata cachananpaj. ");
INSERT INTO qub_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Aywananta mana munaptenga intëru nasyunninta nogami castigashaj säpucunawan. ");
INSERT INTO qub_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Intëru mayupitami säpucuna aypalla timpurir llojshicaramonga. Chauraga faraonpa palasyunmanpis, puñushan cämanmanpis yayconga. Yayconga llapan autoridäcunapa wasinman, llapan Egiptucunapaman, tanta ruracuna jatun artïsa batyancunamanpis, jurnuncunamanpis. ");
INSERT INTO qub_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Säpuga aypalla carmi quiquin faraonpa janancunamanpis autoridänincunapa jananmanpis, llapan Egipto runacunapa jananmanpis pintircaycanga. ");
INSERT INTO qub_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","«Aaronta niy tucrunta aptarcur mayucunaman, gochacunaman, ragracunaman macyaränanpaj. Chaycunapita säpu llojshimur intëru Egiptuman juntangapaj.» ");
INSERT INTO qub_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Chaura Aaronga tucrunta jogariran. Nircur macyararan intëru Egipto yacucunaman. Chaura säpucunaga intëru nasyunman juntajpaj yuricuriran. ");
INSERT INTO qub_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Chaura brüjucunapis mäjica rurayta yachashpan munayniyoj cashanta musyachinanpaj Aarón rurashanno ruraran. Chaynöpami Egipto nasyunchöga säpucuna mas aypallana yuricuriran. ");
INSERT INTO qub_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Chaura faraonga gayachiran Aarontawan Moisesta. Chayaptin niran: «Tayta Diosta mañacuy nogapita, Egiptucunapitapis säpucuna aywacunanpaj. Chauraga Israelcunata cachaycushämi Diosta adurar uywancunata sacrifisyuta ruraj aywananpaj.» ");
INSERT INTO qub_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Niptin faraonta Moisés niran: «Gam nimay gampaj autoridäniquicunapaj, Egipto runacunapaj imay Tayta Diosta mañacunäpäpis. Mañacuriptëga palasyuyquipita, wasiquicunapita may chaypitapis aywacur säpucuna mayullachönami tiyanga.» ");
INSERT INTO qub_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","Chaura faraonga «Wara junaj» niran. Niptin Moisés niran: «Nishayquinömi canga. Chaynöpami musyanquipaj nogacunapa Tayta Diosnëno juc dios mana cashanta. ");
INSERT INTO qub_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Llapan säpucunami aywaconga wasiquipita, palasyuyquipita, Egiptucunapitapis. Chaura mayullachönami tiyanga.» ");
INSERT INTO qub_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Aaronwan Moisesga faraonpa palasyunpita aywacuran. Nircur Tayta Diosta mañacuran llapan säpucunata illgächinanpaj. ");
INSERT INTO qub_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","Chaura Tayta Diosga camacächiran Moisés mañacushanno. Llapan säpucuna wañuran wasicunacho, wasi puncun pampacunacho, chacracunacho cajcunapis. ");
INSERT INTO qub_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Runacunaga intërucho shuntaran muntuy-muntuy wañusha säpucunata. Chaura may chaychöpis fiyupa asyaran. ");
INSERT INTO qub_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Chaypita llapanpis allina caycajta ricashpan faraonga yapay rumi shonguno contra ricacuran. Aaronwan Moisés nishantaga mana cäsurannachu. Tayta Dios willashannömi caran. ");
INSERT INTO qub_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Chaura Tayta Diosga Moisesta niran: «Aaronta willay tucrunwan ñuchu allpata wirunanpaj. Chaura gayishman ticrar intëru Egiptuman juntacurconga.» ");
INSERT INTO qub_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Chaura Aaronga tucrunwan wiruran ñuchu allpata. Wiruriptin Egiptucho caj ñuchu allpaga ticracuriran gayishman. Chay gayishmi llapan runacunata uywacunata juntapaycur cañiran. ");
INSERT INTO qub_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Chaura brüjucunapis mäjica rurayta yachashpan gayishta yurichiyta munaran. Ichanga mananami yurichiyta camäpacurannachu. Aypalla car gayishcunaga runacunata uywacunatapis fiyupana cañiran. ");
INSERT INTO qub_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Chaura brüjucunaga faraonta niran: «Caytaga Diosmi ruraycan» nir. Chaypis faraón mas piyur-raj rumi shonguno contra ricacuran. Tayta Dios willashannömi mana cäsuranchu. ");
INSERT INTO qub_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Chaura Tayta Diosga Moisesta niran: «Wara tutallami faraón mayuman aywanga. Gampis tutalla jatarcur ayway. Chaycho nogapa ruquë payta ninqui aduramaj aywananpaj acrashä runacunata cachaycunanpaj. ");
INSERT INTO qub_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Aywananta mana munaptenga aypalla upucruymi yuricurenga. Paytapis, autoridänincunatapis, llapan Egipto runacunatapis cañenga. Llapan Egipto runacunapa wasincho upucruyllanami juntasha caycangapaj. Chayno intëru pampacunachöpis juntashami caycanga. ");
INSERT INTO qub_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","«Intëru Egiptucho upucruy juntasha captinpis acrashä runacuna tiyaycashan Gosén partichöga manami chaynöchu canga. Chaynöpami musyanga Egipto runacunata noga Tayta Dios castigaycashäta. ");
INSERT INTO qub_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Chaymi Egipto runacunaman castïguta chayachiptëpis acrashä runacunamanga mana chayangachu. Warami chayno rurashaj.» ");
INSERT INTO qub_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Chaypita Tayta Diosga nishanno ruraran. Chaymi upucruycunaga intëru Egiptuman juntaycuran. Palasyumanpis autoridäcunapa wasinmanpis upucruy juntacuycuran. Egiptoga mana tiyaypänönami ricacuran. ");
INSERT INTO qub_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Chaynöpami faraonga Moisesta Aarontawan gayarcachir niran: «Cananga ayway Tayta Diosniquita adurar uywacunata sacrifisyuta ruranayquipaj. Ichanga cay nasyunpita ama llojshinquichu.» ");
INSERT INTO qub_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Niptin Moisés niran: «Chaynöga manami allichu canman. Tayta Diosnëpaj nogacuna uywacunata sacrifisyuta rupachishäga Egiptucunapaj fiyupa melanaypämi canga. Chayno rurajta ricaycäramar paycunaga fiyupa rabyashpan sajmaycällar wañuchimanmanmi. ");
INSERT INTO qub_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Chaymi nogacunaga quimsa junaj aywaytaraj chunyajman aywashaj. Chaychörämi Tayta Diosnë nimashanno payta adurar sacrifisyu uywata rupachishaj.» ");
INSERT INTO qub_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Chayno niptin faraón niran: «Carucama mana aywacunayqui captenga chunyajman aywanayquipaj cachashayquimi chaycho Tayta Diosniquipaj uywayquicunata pishtarcur rupachinayquipaj. Nogapäpis Tayta Diosniquita mañacamunqui.» ");
INSERT INTO qub_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Chaura Moisés niran: «Caypita llojshishä örami Tayta Diosta mañacushaj wara junaj upucruycuna gam cajpita, autoridäniquicunapita, llapan Egipto runacunapitapis illgänanpaj. Ichanga ama llullapämaynachu Dios nishanno sacrifisyu ruraj Israelcuna aywananta mana munashpayqui.» ");
INSERT INTO qub_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Chaura faraonpa palasyunpita llojshircullar Moisesga Tayta Diosta mañacuran. ");
INSERT INTO qub_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","Chaura Tayta Diosga llapan upucruycunata illgächiran. Chauraga ni jucnayllapis mana carannachu faraonpa wasincho, autoridäcunapa wasincho, intëru Egiptucho caj runacunachöpis. ");
INSERT INTO qub_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Upucruy mana captinnaga faraón rumi shonguno contra ricacuran. Chaymi Israelcuna aywacunanta mana munarannachu. ");
INSERT INTO qub_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Chaura Tayta Diosga Moisesta niran: «Faraón cajman ayway. Nogapa ruquë ninqui aduramaj aywananpaj acrashä runacunata cachaycunanpäna. ");
INSERT INTO qub_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Mana aywananta munaptin, chaynölla michaptenga ");
INSERT INTO qub_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","Nogami camacächishaj intëru Egiptucho fiyu gueshya yurimunanpaj. Chay gueshyaga ushanga cawallucunata, bürrucunata, camëllucunata, wäcacunata, uyshacunata, cabrancunatapis. ");
INSERT INTO qub_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Nogami camacächishaj Israelcunapa uywancunataga gueshya mana charinanpaj. Chaymi paycunapaga uywan ni jucnayllapis mana wañongapächu. ");
INSERT INTO qub_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","«Egiptuchöga warami cay nishä canga.» ");
INSERT INTO qub_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Warannin junäga nishannömi caran. Egipto runacunapaga llapan casta uywancuna aypalla wañuran. Israelcunapami ichanga ni jucnayllapis uywancuna mana wañuranchu. ");
INSERT INTO qub_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Chaymi faraón cacharan Israelcunapa uywancunata ricaj. Israelcunapaga manami jucnayllapis uywancuna wañushachu caran. Chaypis faraón rumi shonguno contra ricacuran. Chaynöpami Israelcuna aywananta mana munarannachu. ");
INSERT INTO qub_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Chaymi Tayta Diosga Moisesta Aarontawan niran: «Gamcuna jurnupita uchpata apacurcur ayway faraón cajman. Nircur gam Moisés faraonpa ñaupancho uchpata janajpa machirinqui. ");
INSERT INTO qub_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Chaura uchpataga wayra polbuta apajnöpis intëru Egiptupa mashtacächenga. Chayllanami chupu gueshyata yurichenga llapan Egiptucunacho, uywancunachöpis.» ");
INSERT INTO qub_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Dios nishannömi Aaronwan Moisesga jurnupita uchpata apacarcärir aywaran faraón cajman. Chaychönami Moisesga uchpata janajpa machiriran. Chaura llapan runacunachöpis, uywacunachöpis chupu yuricurcuran. ");
INSERT INTO qub_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Mäjica rurayta yachaj brüjucunapis manana Moisespa ñaupancho cayta puydiranchu marca-masincunachöno paycunachöpis chupu yuricurcuptin. ");
INSERT INTO qub_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Chaypis Tayta Diosmi camacächiran faraón rumi shonguno contra ricacunanpaj. Chaynöpami Aaronwan Moisés nishantaga mana cäsuranchu. Tayta Dios willashannömi caran. ");
INSERT INTO qub_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Chaura Tayta Diosga Moisesta niran: «Tutalla jatarcur wara aywanqui faraón cajman. Nogapa ruquë ninqui aduramaj aywananpaj acrashä runacunata cachaycunanpaj. ");
INSERT INTO qub_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Cananga mas fiyupanami castigashaj faraonta, autoridänincunata, llapan Egiptucunatapis. Chayrämi musyanga nogano juc dios mana cashanta. ");
INSERT INTO qub_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Munashpäga faraonta, llapan Egiptucunatapis fiyu gueshyawan castigämanmi caran. Chaura canan ushacashanami caycanman caran. ");
INSERT INTO qub_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Ichanga faraón cawaycanraj noga munayniyoj cashäta musyachinäpämi, intëruchöpis noga munayniyoj cashäta musyananpämi. ");
INSERT INTO qub_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Chaypis payga acrashä runacuna aywananta manami munanchu. ");
INSERT INTO qub_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Chaypitami wara cayno öra noga tamyachimushaj runtuta. Cay Egiptumanga manarämi imaypis runtumusharächu wara runtumunanpaj caycashannöga. ");
INSERT INTO qub_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Chaymi willay llapan uywancunata wasiman wichgacunanpaj, jircacho imaycan cajtapis shuntachinanpaj. Runtumorga runatapis uywatapis wañuchengapämi wasi ruricho mana captenga.» ");
INSERT INTO qub_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Faraonpa waquin autoridänincunaga Tayta Dios willachishanta riguiran. Chaymi wasi rurinman gueshpichiran uywaynincunatawan uywancunatapis. ");
INSERT INTO qub_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Waquenga mana riguishpan mana gueshpichiranchu uywancunata ni uywaynincunatapis. ");
INSERT INTO qub_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Chaura Tayta Diosga Moisesta niran: «Ricrayquita janajpa jogariy intëru Egiptuman runtu tamya gallaycunanpaj. Runtu tamya gallaycushpan chayanga llapan runacunaman, uywacunaman, micuycunaman, jachacunamanpis.» ");
INSERT INTO qub_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Tucrunta Moisés janajman jogariptin jinan öra Tayta Dios räyuchiran. Runtu tamyatapis tamyachiran. Chaynömi Tayta Diosga intëru Egiptuta runtu tamyawan ushachiran. ");
INSERT INTO qub_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","Mana chawarannachu illguypis, räyupis, runtu tamyapis. Egiptuchöga manami imaypis chayno caranchu. ");
INSERT INTO qub_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Chaura intëru Egiptuchömi ima aycatapis runtu tamya illgächiran. Runacunatapis uywacunatapis wañuchiran. Micuycunata lantacunata usharan. Yöracunatapis garapächullata cachaycuran. ");
INSERT INTO qub_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Intëru Egiptupa fiyupa runtu tamyarpis Israelcuna tiyarcaycashan Gosén partimanga manami chayaranchu. ");
INSERT INTO qub_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Chaymi faraonga Aarontawan Moisesta gayaycachir niran: «Nogaga juchayojmi cä. Marca-masïcunapis juchayojmi. Juchäcunapitami Tayta Diosga castigamasha. ");
INSERT INTO qub_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Runtu tamyapis räyupis chawananpaj Tayta Diosta mañacuycuy ari. Chaura aywanayquicunapaj cachaycushayquimi. Cananga manami michäshayquinachu.» ");
INSERT INTO qub_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Chayno niptin Moisés niran: «Cay siudäpita llojshicushä örami Tayta Diosta mañacushpä maquëta jogarishaj. Chauraga jinan örami räyupis runtu tamyapis chawanga. Chaynöpami musyanquipaj cay pachaga Tayta Diospa maquincho caycashanta. ");
INSERT INTO qub_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Nogaga musyaycämi gampis, autoridäniquicunapis Tayta Diosta manaraj manchacushayquita.» ");
INSERT INTO qub_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","Sebädapis shicshiraycashancho, linäsapis, waytaraycashancho ushacaran. ");
INSERT INTO qub_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Rïgutawan centenota ichanga mana imanaranpischu guepa muruy captin. ");
INSERT INTO qub_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Faraón cajpita aywacur siudäpita llojshirir Moisesga Tayta Diosta mañacur maquinta jogariran. Chaura räyupis runtupis jinan öra chawacäcuran. Mana tamyarannachu. ");
INSERT INTO qub_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Tamyapis runtupis räyupis chawashatana ricar faraonpa autoridänincuna mas piyur-raj rumi shonguno contra ricacuran. Aunircurpis manana munarannachu. ");
INSERT INTO qub_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Moisesta Tayta Dios willashannömi Israelcuna aywacunanta mana munar mas piyur-raj rumi shonguno contra ricacuran. ");
INSERT INTO qub_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Chaura Tayta Diosga Moisesta niran: «Cutiy faraón cajman. Nogami camacächishcä paypis autoridänincunapis rumi shonguno contra ricacunanpaj, chaynöpa almiraypajcunata ricachinäpaj. ");
INSERT INTO qub_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","Chaynöpami gamcunapis wamrayquicunata willcayquicunata willapanquipaj Egiptucunata imanöpis rurashäta, almiraypajcunata rurashäta. Chaynöpami gamcuna musyanquipaj rasunpa noga Tayta Dios cashäta.» ");
INSERT INTO qub_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Niptin Aaronwan Moisesga aywaran faraón cajman. Chayaycur niran: «Hebreocunapa Tayta Diosninmi cachamasha gamta tapunäpaj. ¿Imaycamaraj payta mana wiyacunquichu? ¡Aduraj aywananpaj acrashan runacunata cachay! ");
INSERT INTO qub_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Aywananta mana munaptiquega wara junajmi nasyunniquiman Tayta Dios yurichimonga aypalla chüpacacunata. ");
INSERT INTO qub_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","Chaycunami intëru jircapa juntacuyconga pampapis mana jäcoj. Runtu tamya ushashan wallca wallcalla quëdasha caycajllantapis ushajpämi ushacurcongapaj. Yöracunatapis micucurcongami. ");
INSERT INTO qub_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Gampa palasyuyquimanpis, autoridäniquicunapa wasincunamanpis, llapan Egiptucunapa wasincunamanpis juntayconga. Chayga cangapaj taytayquicuna, chachayquicuna, unay caj chachayquicunapis mana nunca ricashannömi.» Chayno nirerga ticrar aywacuran faraonpa palasyunpita. ");
INSERT INTO qub_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Chaura faraonpa autoridänincuna niran: «Tayta faraón, ¿imaycamataj chay runata awantashun? ¿Gamga manachu tantiyacunquiraj cay Egiptucho ima-aycawanpis ushachimashanchïta? Jina Israelcunaga aywacuchun Tayta Diosninta rispitar adurananpaj.» ");
INSERT INTO qub_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Chayno niptin faraonga gayachiran Aarontawan Moisesta. Chayaptin niran: «Aywayna-llapa Tayta Diosniquita rispitar aduramunayquipaj. Ichanga ¿pï-pïtaj aywanga?» ");
INSERT INTO qub_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Chaura Moisés niran: «Nogacunaga aywashaj ushajpämi ollgupis warmipis, wamrapis chacwan auquinpis, jucpis mana pishej. Uywäcunatapis manyapitami gatishaj. Nogacunaga Tayta Diosta adurarmi jatun fistata rurashaj.» ");
INSERT INTO qub_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Chaura faraón niran: «Achyä, gamcunataga Tayta Diosniquichari yanapäshunqui. ¿Llutanta yarpaycashayquita mana tantiyashätachu yarpanqui? ¿Wamrayquicunawan llapayqui aywanayquipaj auninätachu yarpanqui? ");
INSERT INTO qub_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Manami yarpashayquinöchu canga. Tayta Diosta aduraj aywayta munarga ollgu cajcunalla ayway.» Chayno nircur faraonga ñaupanpita paycunata garguchiran. ");
INSERT INTO qub_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Chaura Tayta Diosga Moisesta niran: «Ricrayquita jogariy Egiptuman aypalla chüpacacuna shamunanpaj. Chayno shamur llapan lantacunatami ushacurconga runtu tamya ushashan quëdasha caycajllantapis.» ");
INSERT INTO qub_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Janajpa tucrunta Moisés jogariptin Tayta Dios wayrächimuran inti yagamunan caj-läpita. Chaura Egiptuman wayraran chay junaj goyarpoj pagaspapis warayta. Warannin tutapäga aypalla chüpacacuna warämuran pachapis mana jäcoj. Inti yagamunan caj-läpita wayrämushpanmi chüpacacunata apamusha caran. ");
INSERT INTO qub_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Imaypis mana cashannömi chüpacacunaga intëru Egiptuman juntaycuran. Chaynöga unaypis manami caranchu; ni yapaypis manami canganachu. ");
INSERT INTO qub_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Chüpacacunaga juntacuycuran pampapis mana ricacaj. Chaura intëru jircacunapis chacracunapis yanayasha caycaran. Chayno aypalla carmi micucurcuran llapan frütacunata, lantacunata, runtu tamyapita quëdaj cajllantapis. Chaura Egiptuchöga jachacunapa lantacunapa öjan manami carannachu. ");
INSERT INTO qub_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Chaymi faraonga Aarontawan Moisesta jinan öra gayaycachir niran: «Nogaga Tayta Diosniquipa contranmi, gamcunapa contrayquimi llutanta rurashcä. ");
INSERT INTO qub_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Chaymi gamcunata ruwacö juchäta cananllana perdunamänayquipaj. Tayta Diosniquita nogapaj mañacuycuy cay chüpacacunallatapis illgaycachinanpaj.» ");
INSERT INTO qub_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Faraonwan parlashanpita llojshirir Moisesga jinan öra Tayta Diosta mañacuran. ");
INSERT INTO qub_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Chaura Tayta Diosga jinan öra cutichiypana wayrächiran. Chaymi inti yaganan caj-läpitana wayra fiyupa wayrayta gallaycuran. Chaynöpami llapan chüpacacunata Puca lamarman apacuran. Egiptuchöga chüpacacuna mana quëdarannachu ni jucnayllapis. ");
INSERT INTO qub_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Ichanga yapay Tayta Dios camacächiran faraón rumi shonguno contra ricacunanpaj. Chaynöpami Israelcuna aywacunanta mana munaranchu. ");
INSERT INTO qub_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Chaura Tayta Diosga Moisesta niran: «Syëlupa maquiquita jogariy intëru Egiptucho pacha chacacäcunanpaj. Chauraga yana mancapa siquinnörämi fiyupa chacacäconga.» ");
INSERT INTO qub_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Maquinta Moisés jogariptin intëru Egiptucho fiyupa chacacäcuran. Chayno chacaylla cacuran quimsa junajcama. ");
INSERT INTO qub_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Chay junajcuna Egipto runacunaga mayganpis mana ricanacuranchu. Maypa aywaytapis manami camäpacuranchu. Egiptucho chayno chacaptinpis Israelcuna tiyashanchöga achicyaj caycaran. ");
INSERT INTO qub_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Chaura faraonga Moisesta gayaycachimur niran: «Tayta Diosniquita aduranayquipaj llapayqui ayway wamrayquicunatapis pushacarcärir. Uywayquicunata ichanga cachaycäriy.» ");
INSERT INTO qub_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Niptin Moisés niran: «Uywäcunata gatinäta mana munarga ¿gamchuraj uywacunata camaripämanqui Tayta Diosnëta adurar uywacunata sacrifisyupaj rupachinäpaj? ");
INSERT INTO qub_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Uywäcunataga simri gatinä caycan. Caychöga manami jucpis quëdangachu. Manaraj chayashäcamaga manami musyärächu Tayta Diosta adurar ayca uywäcunata pishtarcur rupachinäcunapäpis.» ");
INSERT INTO qub_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Ichanga faraón rumi shonguno contra ricacunanpaj Tayta Dios yapay camacächiran. Chaymi Israelcuna aywananta mana munaranchu. ");
INSERT INTO qub_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Chaynöpis faraonga Moisesta niran: «Gamtaga mananami ricaytapis munächu. Aywacuy. Nogaman imaypis cuydä cutimur. Cutimushayqui öraga wañunquipämi.» ");
INSERT INTO qub_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Chaura Moisespis niran: «Nimashayquinömi canga. Cananpitaga ñaupayquiman manami shamushänachu.» ");
INSERT INTO qub_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Chaypita Tayta Diosga Moisesta niran: «Yapay juc castïgutarämi chayachimushaj faraonman, Egiptucunamanpis. Chay castïguwanrämi ‹Aywacuy› nir gargushunquipaj. ");
INSERT INTO qub_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Cananga Israelcunata willapay ollgupis warmipis goripita caj cösacunata guellaypita caj cösacunata bisïnun Egiptucunata ‹goycamay› ninanpaj.» ");
INSERT INTO qub_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","Tayta Dios camacächiran Israelcunapäga Egiptucuna fiyupa alli shongu ricacunanpaj. Faraonpa autoridänincunapis, llapan Egiptucunapis Moisesta fiyupa rispitaran. ");
INSERT INTO qub_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Moisesga faraonta niran: «Tayta Diosga caynömi nisha: ‹Pullan pagasmi purishaj intëru Egiptupa. ");
INSERT INTO qub_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","Chaymi llapan Egiptucunapa guechpa caj wamran wañonga. Faraonpa guechpa caj wamranpita gallaycur asta maraycho agapacoj warmipa guechpa caj wamranpis wañonga. Llapan uywacunapa rimir caj wawanpis wañonga. ");
INSERT INTO qub_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Chaura intëru Egiptuchömi mana nunca cashanno fiyupa llaquicuy wagay cangapaj. Chaynöga imaypis manami casharächu; ni yapaypis manami canganachu. ");
INSERT INTO qub_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Chayno captinpis Israelcuna tiyashanchöga ni juc allgullapis manami aullangachu. Israel runacuna tiyashan cajcho runacunapis ni uywacunapis mana wañuptinmi musyanquicuna Israel runacunata Tayta Dios cuyashanta.› ");
INSERT INTO qub_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Chayrämi llapan autoridäniquicunapis ricamaj shamongapaj. Gongurpaycur nimangapaj ‹Llapan Israelcunata pushacurcur aywacuyna ari tayta› nir. Chayno nimaptinrämi aywacushäpaj.» Chayno nircur faraón cajpita Moisesga fiyupa rabyasha aywacuran. ");
INSERT INTO qub_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Chaypitana Tayta Diosga Moisesta niran: «Faraonga manami cäsushunquipächu. Chaymi cay Egiptuchöga almiraypajcunata masta rurashaj.» ");
INSERT INTO qub_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Aaronwan Moisesga almiraypajcunata ruraran faraonpa ñaupancho. Chaypis Tayta Diosmi camacächiran faraón rumi shonguno contra ricacunanpaj. Chaymi Israelcuna Egiptupita aywacunanta faraón mana munaranchu. ");
INSERT INTO qub_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Aaronwan Moisés Egiptullachöraj caycaptin Tayta Diosga niran: ");
INSERT INTO qub_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","«Cay quillami gamcunapäga canga mushoj wata gallaycunan caj quilla. ");
INSERT INTO qub_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Llapan Israelcunata willapanqui cay quilla chunca junajcho uywata camaricunanpaj. Chaymi cada wasicho tiyajcuna juc watayoj cashnita carpis o manta capshita carpis pishtananpaj camarenga. ");
INSERT INTO qub_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Juc wasicho wallcajlla cashpan ichanga bisïnuncunawan shuntacanga pishtashan uyshata ushajpaj micunanpaj. ");
INSERT INTO qub_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Uywaga canga watayojllaraj orgu sänu. Chay acrashanga canga uysha, mana uysha cashpanga cabra. ");
INSERT INTO qub_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Chay acrashanta chararanga cay quilla chunca chuscu junajninyaj. Chay junajchömi ichanga tardipa pishtanga. ");
INSERT INTO qub_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Pishtashan uywata micunanpaj caj wasi puncupa ishcan marcuncunatawan numralnintapis pichonga chay pishtashan uywapa yawarninwan. ");
INSERT INTO qub_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Chay chacay cancayllapa aychataga ushajpaj miconga ashgaj jachantawan, lebadüraynaj tantantinta. ");
INSERT INTO qub_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Chay aychata ama micongachu yanushata ni chawatapis. Cancashallata micuchun. Miconga umanta, pachanta, shongunta, macshuncunatapis. ");
INSERT INTO qub_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Imantapis ama cachangachu waranninpäga. Puchöpacushan cajtaga ushajpaj rupaycachenga. ");
INSERT INTO qub_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Micushpan miconga röpanta, llanguinta jatishalla, tucruncunatapis aywacunayquipaj camaricushalla. Chay aychata apurälla miconga. Chay Pascua fistataga nogapa jutëcho rurachun. ");
INSERT INTO qub_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","Chay chacayga Egipto nasyun intërupami noga purishäpaj. Llapan Egiptucunapa guechpa wamrancunatami wañuchishaj. Chaynömi uywancunapatapis rimir caj wawantaga wañuchishaj. Egiptupa diosnincunata castigashäpaj. Noga Tayta Diosmi chayno në. ");
INSERT INTO qub_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","«Pishtashayqui uywapa yawarninwan puncuyquicuna pichusha captinmi maygan wasicho tiyarcaycashayquipis musyacanga. Egiptucunata noga wañuchishpäga wasiqui puncucunacho yawarta ricar päsacushämi. Chaura gamcunaga ni jucnayllapis manami wañunquipächu. ");
INSERT INTO qub_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","Chay junajta gamcunaga yarpanquipaj. Cada watacho chay junajmi rispitamar fistata ruranquipaj gamcunapaj alli rurashäta yarpänayquipaj. Chaynöllami gamcunapis gamcunapita mirajcunapis cada wata imaycamapis ruranquipaj. ");
INSERT INTO qub_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","Ganchis junajmi micunquicuna lebadüraynaj tantallata. Rimir junajpita-pacha gamcunapa wasiquichöga lebadüra ama cangachu. Maygayquipis lebadürayoj tantata chay junajcunacho micorga tiyaycashayquipita gargushami canquipaj. ");
INSERT INTO qub_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Gallarinan junajchöwan ganchis caj junajchöga nogata alabamänayquipaj shuntacanqui. Chay junajcunachöga ama arunquichu. Micunayquipaj micuyllata yanucunqui. ");
INSERT INTO qub_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","«Lebadüraynaj Tantata Micuna fistata rurar imaypis yarpanquicuna Egiptupita jorgamushäta. Gamcunapis gamcunapita mirajcunapis mana jamachiypa jatun fistatami ruranquipaj. ");
INSERT INTO qub_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Wata gallarej quilla chunca chuscu (14) junaj tardipita-pacha lebadüraynaj tantata micunqui ishcay chunca juc (21) junaj tardicama. ");
INSERT INTO qub_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","Gamcunapa wasiquichöga ganchis junajyaj lebadüra ama cangachu. Maygayquipis lebadürayoj tantata micojtaga Israel casta shuntacashanpita gargunqui. Chaynölla ruranqui Israel-masiqui captinpis, juc-lä runa captinpis. ");
INSERT INTO qub_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Chay junajcunacho lebadürayoj cajtaga ima micuytapis cuydä micur. Maycho tiyarpis micunqui lebadüraynaj tantallata.» ");
INSERT INTO qub_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Chaura Israelcunapa mandajnin auquincunata gayaycachir Moisesga niran: «Gamcuna cada wasicho juc cashnita man'chäga capshita acranqui. Nircur pishtanqui Pascua micuyta ruranayquipaj. ");
INSERT INTO qub_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Chay uywapa yawarninta charinqui. Nircur chajchucuna jachata yawarman töparcachir puncupa marcuncunata, numralninta pichunqui. Chayno ruraycorga chay pagas pipis ama llojshengachu pacha waränancama. ");
INSERT INTO qub_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Egiptucunata castigananpaj Tayta Dios purerga puncucunacho yawarta ricar chay wasicunapita päsaconga. Puncucunacho yawar captenga wasiquicunaman manami Tayta Dios yaycachengachu wañuchicoj anjilta. ");
INSERT INTO qub_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","«Cananpitaga llapaniqui Israelcuna wiyacunqui Tayta Dios willapäshushayquicunata. Gamcunapis, gamcunapita mirar aywajcunapis imaycamapis wiyacunqui. ");
INSERT INTO qub_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Tayta Dios goycushunayquipaj aunishan particho tiyashpayquipis canan rurashayqui Pascua fistataga mana gongaypa ruranqui. ");
INSERT INTO qub_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Mas guepata wamrayquicuna ‹¿Imapätaj cayno ruranchi?› nishuptiquega ");
INSERT INTO qub_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","cayno nir willapanqui: ‹Tayta Diosmi Egiptucho unay castanchi Israelcuna tiyashan wichan wañuchiran Egiptucunata. Israelcunapa wasinpita ichanga päsacuran. Chayno rurarmi noganchi castataga mana wañuchiranchu. Chaypitami cay Pascua micuytaga ruranchi Tayta Diosta rispitar› nir.» Chaura Israelcunaga rispitar gongurpashpan Tayta Diosta aduraran. ");
INSERT INTO qub_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Chaypita aywar llapan runacuna ruraran Moiseswan Aaronwan Tayta Dios willacachishanno. ");
INSERT INTO qub_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Nishan junäga pullan pagasmi Tayta Dios wañuchiran Egiptucunapa guechpa ollgu wamrancunata. Faraonpa guechpa ollgu wamranpita asta carsilcho caycajpa guechpa ollgu wamrantapis wañuchiran. Llapan uywacunapa rimir caj orgu wawancunatapis wañuchiran. ");
INSERT INTO qub_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Chaymi chay chacayga faraonpis autoridänincunapis llapan Egiptucunapis jatariran. Egiptuchöga fiyupa llaquicuy wagay caran cada wasicunacho aya captin. ");
INSERT INTO qub_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Chaura chay chacay faraonga Aarontawan Moisesta gayarcachir niran: «Canan öra aywacuy. Egiptucunapita llojshicuy llapan Israel-masiquicunawan. Nishayquino juclla aywacuy Tayta Diosta aduranayquipaj. ");
INSERT INTO qub_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Uyshayquicunata, cabrayquicunata, wäcayquicunata gaticarcärir juclla aywacuy ari nimashayquicunano. Nogapäpis Tayta Diosta mañacuycunqui.» ");
INSERT INTO qub_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Egipto runacunaga yarparan guechpa wamrancuna wañushanno quiquincunapis wañunanpaj cashanta. Chaymi yanaparan Israel runacuna juclla aywacunanpaj. ");
INSERT INTO qub_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Chaymi Israelcunaga tantapaj chayraj chapushan mäsatapis lebadüraynajllata apacuran. Jinan batyanpa jacuncunawan pitucarcärir, matancacarcärir apacuran. ");
INSERT INTO qub_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Israelcunaga Moisés willapashannölla Egiptucunata mañacuran goycärinanpaj, ima-aycatapis goripita, guellaypita rurasha cajcunata, asta röpacunatapis. ");
INSERT INTO qub_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","Tayta Dios camacächiran Egiptucuna fiyupa alliyacäcunanpaj, Israelcuna imatapis mañacuptin goycärinanpaj. Chaynöpami Israelcunaga Egiptucunapa ima-aycantapis apacuran. ");
INSERT INTO qub_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Israelcunaga Ramsés siudäpita aywacuran Sucot-läman. Ollgu runacunalla caran sojta pachac warangano (600,000) warmicunata wamracunata mana yupayllapa. ");
INSERT INTO qub_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Aywacuptin jäpa runacunapis paycunawan aywacuran. Israelcunaga uywacunatapis uyshata wäcata aypallata gaticurcur aywacuran. ");
INSERT INTO qub_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Egiptucuna apurä garguptinmi Israelcunapaga luwarninpis mana carannachu mircapanta ruracunanpaj. Chaymi jamashanchöga lebadüraynaj apashan mäsallapita tantata ruraran. ");
INSERT INTO qub_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Israelcunaga Egiptucho tiyasha caran chuscu pachac quimsa chuncan (430) wata. ");
INSERT INTO qub_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","Chuscu pachac quimsa chuncan (430) watata usharcushan junajmi Tayta Dios acrashan runacunaga röpa-röpa chay nasyunpita llojshicuran. ");
INSERT INTO qub_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Chay chacaymi Israel runacunata Tayta Dios yanaparan Egiptupita yargunanpaj. Chaypitami Israelcunapis Tayta Diosta adurashpan chay cumlinan chacayga Pascua fistata cada wata ruranga. ");
INSERT INTO qub_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Aarontawan Moisesta Tayta Dios niran: «Caynömi Pascua micuyta ruranquipaj: Pascuapaj pishtashayqui uywapa aychanta ama micongachu jäpa runaga. ");
INSERT INTO qub_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","Guellaywan rantisha uywayniqui runami ichanga señalacusha carga miconga. ");
INSERT INTO qub_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","Ama micongachu guellaypaj arupacoj shamoj jäpa runa, ni rätulla shamoj jäpa runapis. ");
INSERT INTO qub_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","Chay aychata micunqui pishtashayqui wasi rurillacho. Ama jorgunquichu jawamanga. Tulluntapis ama paquinquichu. ");
INSERT INTO qub_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Israel cajcunaga llapayquipis chaynölla ruranqui. ");
INSERT INTO qub_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","Gamcunacho tiyaj jäpa runapis gamcunano Tayta Diosta rispitar Pascua micuyta gamcunawan iwal micuyta munaptenga gamcuna ninqui ‹Rimëroga llapayqui wasiquicho tiyaj ollgu cajcuna señalacuyraj› nir. Chaura paycunapis cangapaj nasyunniquicho yurishanöna. Señalacöni cäga chay aychata ama micongachu. ");
INSERT INTO qub_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Chay layllami canga jinan nasyuncho yurejcunapäpis, gamcunacho juc-lä runacuna tiyajcunapäpis.» ");
INSERT INTO qub_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Chaura Israelcunaga llapanta ruraran Aarontawan Moisesta Tayta Dios nishannölla. ");
INSERT INTO qub_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","Chay junajllami Tayta Diosga Israelcunata röpa-röpa shuntacashallata Egiptupita jorguran. ");
INSERT INTO qub_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Tayta Diosga Moisesta niran: ");
INSERT INTO qub_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","«Israelcunapa guechpa caj ollgu wamrancunapis, llapan uywacunapa rimir caj orgu wawancunapis nogapämi canga. Chauraga llapan guechpa cajta nogapaj apamunqui.» ");
INSERT INTO qub_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Chaura Moisesga llapan runacunata niran: «Gamcuna yarpanqui Tayta Dios munayninwan Egiptupita jorguycäshushayqui junajta. Egiptucho uyway rantisha runano caycajtami jorguycäshunqui. Cananpitaga cada watami cay junajta yarpar lebadürayoj tantata ama micunquichu. ");
INSERT INTO qub_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Canan junäga Abib quillachömi llojshircaycanqui. ");
INSERT INTO qub_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","Chaymi awiluyquicunata Tayta Dios aunishan partiman chayar cada wata cay quillacho Pascua fistata ruranqui. Chay partichöga ima-aycapis aypalla captin lëchipis mishquipis yacunörämi caycan. Chayga caycan Cananeo runacuna, Het runacuna, Hev runacuna, Amorreo runacuna, Jebús runacuna tiyaycashan partimi. ");
INSERT INTO qub_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","Chay Pascua fistachöga gamcuna ganchis junaj intërumi lebadüraynaj tantallata micunquipaj. Fista ushanan caj junajchömi ichanga diya captin Tayta Diosta rispitar aduranqui. ");
INSERT INTO qub_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Fista cashan junajcunachöga tiyashayqui particho maychöpis ama cangachu lebadüra ni lebadürawan poguchishapis. Lebadüraynaj tantallata micunqui. ");
INSERT INTO qub_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","Chay junajcunachöga wamrayquicunata willapanqui: ‹Cay fistataga ruräcuna Egiptupita Tayta Dios jorgamashpan imanöpis rurashanta yarparmi› nir. ");
INSERT INTO qub_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Gamcunapäga cay fista canga ricrayquicho u urcuyquicho chäpasha caycajnömi Tayta Diospa mandamintuncunata imaypis mana gonganayquipaj. Chaynöga canga fiyupa munayninwan Egiptupita Tayta Dios jorgamushushayquipitami. ");
INSERT INTO qub_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Chaymi cay fistataga wata-wata ruranqui nimashanchi junajcho. ");
INSERT INTO qub_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","«Unay awiluyquicunata, gamcunata aunishushayqui Canaán partiman chayaycachir chay partita goycushuptiquega ");
INSERT INTO qub_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","guechpa caj wamrayquicuna Tayta Diospami canga. Uywayquicunapapis rimir wawan orgu cajcunaga Tayta Diospami canga. ");
INSERT INTO qub_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Bürrupa rimir caj orgu wawanpa ruquin ichanga Tayta Diospaj apanqui juc watayoj cashnita carpis u juc watayoj capshita carpis. Ruquinta mana aparga bürru-mallwapa cuncanta paquirinqui wañunanpaj. Chaynöllami gamcunapa guechpa caj ollgu wamrayquipa ruquinpis Tayta Diospaj ofrendata apanqui. ");
INSERT INTO qub_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","«Wara warantin wamrayquicuna ‹¿Imapätaj cayno ruranchi?› nir tapushuptiqui gamcunaga ninqui ‹Egiptucho uyway caycajtami Tayta Dios fiyupa munayninwan jorgamaran. ");
INSERT INTO qub_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Faraón fiyupa chucru shongu ricacur mana munaranchu llojshicamunäcunata. Chaymi Tayta Diosga Egipto runacunapa guechpa ollgu wamrancunata, uywancunapa rimir caj orgu wawantapis wañuchiran. Chaypitami uywäcunapa rimir caj orgu wawantaga Tayta Diospaj goycöcuna. Chayno guechpa ollgu wamräcunapa ruquinpis Tayta Diospaj ofrendata goycöcuna› nir. ");
INSERT INTO qub_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Ricracho u urcucho señal cashannömi chay fistapis señalno canga Egiptupita Tayta Dios munayninwan jorgamashanchïta imaypis yarparänayquipaj.» ");
INSERT INTO qub_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Israelcunata faraón «aywacuy» niptin Tayta Diosga manami Filistea nasyunpa aywaj nänipachu pusharan, chaypa serca caycaptinpis. Diosga musyaranmi pillyananpaj Filistea runacuna ichipaptin Israelcuna mancharir Egiptuman cuticunanpaj cashanta. ");
INSERT INTO qub_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Chaymi chunyajpa Puca lamarman aywaj nänipa tumachiypa pusharan. Israelcunaga Egiptupita aywacuran suldärucunano röpa-röpa camacasha. ");
INSERT INTO qub_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Josëpa tulluncunatapis Moisesga apachiran. Josëga manaraj wañurmi Israelpa wamrancunata jurachir unay cayno nisha caran: «Gamcunata yanapäshunayquipaj Tayta Diosga shamongami. Chayno yanapäshuptiqui tullöcunata caypita apacullanqui ari.» ");
INSERT INTO qub_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Israelcunaga Sucotpita aywacur chayaran Etam partiman. Chaypitaga caycaran chunyaj chaqui jircanami. ");
INSERT INTO qub_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Israelcunata pushashpan Tayta Diosga junajpa aywaran ichiraycaj pucutaycho, chacaypana achquipänanpaj ichiraycaj ninacho. Chaynöpami chacaypa junajpapis Israelcunaga aywaran. ");
INSERT INTO qub_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Chay ichiraycaj pucutayga junajpa mana illgaypa paycunapa ñaupa-puntanta aywaycaran. Chacaypana ichiraycaj nina rataycaj mana illgaypa ñaupa-puntanta aywaycaran. ");
INSERT INTO qub_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Moisesta Tayta Dios niran: ");
INSERT INTO qub_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","«Israelcunaga Pi-hahirot-läman cutimuchun. Chayga caycan Migdolpita lamarman aywajchömi. Chaychöga lamar cantuncho tolduncunata ichichichun Baal-zefonpa chimpanman. ");
INSERT INTO qub_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Chaymi faraonga yarpanga chunyajman chayar pantacasha purircaycashayquita. ");
INSERT INTO qub_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Nogami camacächishaj faraón rumi shonguno contra ricacushpan guepayquita gatishushpayqui shamunanpaj. Chayno gatishuptiqui nogami suldäruncunata ushacächishaj. Chaynöpami musyachishaj munayniyoj cashäta. Chayrämi Egiptucunaga musyanga noga Tayta Dios cashäta.» Chaymi Israelcunaga Tayta Dios nishannölla cutiran. ");
INSERT INTO qub_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Israelcuna gueshpiycashanta musyaycur faraonga autoridänincunawan pësacuran Israelcunata cachaycushanpita. Chaymi ninacuran: «¿Imatataj ruraycushcanchi? ¿Ima jinanpataj Israelcuna aywacunanpäga cachaycushcanchi? Cananga ¿pitaj arupämäshun?» nir. ");
INSERT INTO qub_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Chaymi faraonga jinan öra guërrapaj caj carrëtancunata camarircachir suldäruncunata pushacurcur aywaran. ");
INSERT INTO qub_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","Egiptupita aywaran sojta pachac (600) mas allinnin caj carrëtancunawan. Chaynöpis Egiptucho caj carrëtacunawanga llapanwanmi aywaran. Cada carrëtacho juc mandajpis aywaran. ");
INSERT INTO qub_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Tayta Diosmi camacächiran faraón rumi shonguno contra ricacunanpaj. Chaymi Israelcunapa guepanta gatir aywaran Tayta Dios fiyupa munayninwan yanapaptin aywacusha caycaptinpis. ");
INSERT INTO qub_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Faraonpa suldäruncunaga gatiran llapan cawalluncunawan, carrëtancunawan, muntädu caj suldäruncunawan. Israelcunataga tariparan Pi-hahirotpa ñaupancho Baal-zefonpa chimpancho lamar cantuncho pachacusha caycajta. ");
INSERT INTO qub_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Chaypita Israelcunaga ricaran faraón Egiptucunawan guepanta aywar taripaycashanta. Chaymi fiyupa mancharir gaparayparaj Tayta Diosta mañacuran. ");
INSERT INTO qub_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Moisestana jitapar paycuna niran: «Egiptucho pantiyun mana captinnöpis ¿imapätaj jorgamarayqui cay chunyajcho wañunäcunapaj? ¿Imanirtaj chayno ruramashcanqui? ");
INSERT INTO qub_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Nogacunaga Egiptullachönami nirä: ‹Jina Egiptucunata arupäshaj chunyajcho wañunäpitaga. Nogacunapäga mas allimi paycunapa uywaynin cacuptë› nir.» ");
INSERT INTO qub_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Chayno niptin Moisés niran: «¡Balurchay-llapa! ¡Ama manchacuychu! Cananmi Tayta Dios salbamashanchïta ricanquipaj. Egiptucunataga cananllanami ricanquipaj. Mananami mas imaypis ricanquipänachu. ");
INSERT INTO qub_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Gamcunaga ama llaquicuychu. Tayta Diosmi faburninchi pillyanga.» ");
INSERT INTO qub_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Chaypitaga Moisesta Tayta Dios niran: «¿Imanirtaj mañacaycämanqui? Israelcunata willay jucllana aywacunanpaj. ");
INSERT INTO qub_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Gamnami tucruyquita janajpa jogarcur lamarman macyaranqui ishcayman lamar yacu raquicäcunanpaj. Chaura Israelcunaga lamar raquicasha chaupinpa chaqui allpapanami päsangapaj. ");
INSERT INTO qub_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Nogami camacächishaj Egiptucuna rumi shonguno contra ricacunanpaj. Chaymi gamcuna aywashayquipa gatishunquipaj. Chaynöpami faraonta, llapan suldäruncunata carrëtancunatawan, muntädu suldäruncunatawan imanöpis rurashpä pï-maytapis noga musyachishaj munayniyoj cashäta. ");
INSERT INTO qub_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Egiptucunaga noga Tayta Dios cashäta musyanga faraonwan aywajcunata imanöpis ruraptërämi.» ");
INSERT INTO qub_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Chaura Tayta Diospa anjilnin y ichiraycaj pucutaypis Israelcunapa ñaupanta aywaycashanpita guepanmanna witicuriran. ");
INSERT INTO qub_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","Chaura chay ichiraj pucutayga caycaran Egiptucunapawan Israelcunapa chaupincho. Chay öra Egiptucunapäga pacha fiyupa chacacäcuran; Israelcunapäna achicyaparan. Chaynöpami Egiptucunaga ricayta mana camäpacur Israelcunata mana tariparanchu. ");
INSERT INTO qub_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Moisesga ricranta jogariran lamar cajman. Chaura Tayta Diosmi warayllata inti yagamunan caj-lädupita sinchi wayrata wayrächimuran. Chaynöpami lamarta ishcayman raquicäcachiran. Chay raquishan chaupitana chaqui allpaman ticrarachiran. ");
INSERT INTO qub_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","Chaura Israelcunaga chaqui allpapana päsaran washa-lädunpa cay-lädunpa yacu tapyano ichiraycaptin. ");
INSERT INTO qub_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Chaymi Egiptucunaga llapan suldäruncunawan, carrëtancunawan, muntädu aywaj suldäruncunapis Israelcunapa guepanta gatir yaycuran lamar chaupincamaraj. ");
INSERT INTO qub_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Pacha waraycaptinnaga nina rataycajpitawan pucutay ichiraycajpita Tayta Dios ricärir camacächiran Egiptucuna ima ruraytapis mana camäpacunanpaj. ");
INSERT INTO qub_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","Tayta Diosga carrëtancunapa ruyrancunatapis llojshicäcachiran. Chaura manana aywaytapis puydirannachu. Chaymi Egiptucuna ninacuran: «Israelcunapitaga gueshpir cuticushun. Tayta Diosmi Israelcunapa faburnin car noganchïpa contranchi caycan» nir. ");
INSERT INTO qub_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Ichanga Moisesta Tayta Dios niran: «Ricrayquita lamar jananpa jogariy yacu cashganman cutir Egiptucunata, carrëtancunata, cawalluncunata ñiticurcunanpaj.» ");
INSERT INTO qub_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Chaura Moisesga lamar jananpa ricranta jogariran. Pacha wararcuptenga yacu cutiran cashannömanna. Egiptucunaga gueshpishancho lamarman tacacaran. Israelcunata gatej Egipto runacunataga chaynömi Tayta Dios ushajpaj yacuwan ñitichiran. ");
INSERT INTO qub_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Cashanman yacu cutir faraonta, suldäruncunata, cawalluncunata, carrëtancunata ushajpaj ñiticurcuran. Chaura Israelcunata gatir yaycojcunaga ni jucnayllapis mana gueshpiranchu. ");
INSERT INTO qub_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Israelcunaga lamarta päsaran chaqui allpapa, ishcan-lädunpa yacu tapyano ichiraycaptin. ");
INSERT INTO qub_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Chay junaj Egiptucunapa maquinpita Tayta Dios Israelcunata gueshpichiran. Chaypitaga Israelcuna ricaran lamar cuchuncho Egiptucunapa ayan wampurcaycajta. ");
INSERT INTO qub_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Munayninwan Tayta Dios Egiptucunata fiyupa castigashanta ricaycur Israelcunaga amatar rispitashpan Tayta Diosta aduraran. Chaypitaga yäracuran Tayta Diosllamanna. Moisés nishancunallatana riguiranpis. ");
INSERT INTO qub_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Chaypita Moisesga llapan Israelcunawan Tayta Diosta alabar cantaran. Chay cantashan caynömi niycaran: «Tayta Diosta alabashpämi cantashaj munayniyoj cayninwan binsishanpita. Payga cawallucunatami, muntädu aywajcunatami lamarman garpurisha. ");
INSERT INTO qub_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","Tayta Diosmi imapitapis chapämaj, salbamaj. Chaymi payllapaj cantä. Payta alabä Diosnë captinmi. Payta adurä unay caj famillyäcunapapis Diosnin captinmi. ");
INSERT INTO qub_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","Tayta Diosga guërracho pillyay yachajmi. Paypaga jutinpis Tayta Diosmi. ");
INSERT INTO qub_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","«Tayta Diosga faraonpa suldäruncunatami, carrëtancunatami lamarman garpurisha. Mas mijur suldäruncunapis Puca lamarchömi shengaypa wañusha. ");
INSERT INTO qub_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Ruminömi ruricama yagacarpusha. Jundu lamarmi ultacurcusha. ");
INSERT INTO qub_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","«Tayta Dios, maquiqui fiyupa munayniyojmi. Chaywanmi llapan chiquimajcunata illgarachishcanqui. ");
INSERT INTO qub_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","Gamga fiyupa munayniquiwanmi contrayqui jatarejcunata usharishcanqui. Rabyacurcurmi ogshata nina ushacurcojnöpis illgarachishcanqui. ");
INSERT INTO qub_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Pücariptiqui yacu shuntacäcusha. Yaculla caycashpanpis tapya ichiraycajno ricacusha. Mas jundunnincho caj yacucunapis tinticäcusha. ");
INSERT INTO qub_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","Chiquimajcunaga caynömi yarparan: ‹Gatishaj taripanäcama. Llapan apaycashancunatapis guechurcurmi raquipänacushaj. Sablëwanmi ushajpaj wañuchishaj› nir. ");
INSERT INTO qub_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Ichanga lamarta gam pücariptiqui ushajpämi lamar ultacurcusha. Yacu bötiypa bötiycajman plömunömi yagacarpusha. ");
INSERT INTO qub_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","«Tayta Dios, maygan dioscunapis gammanga manami tincunchu. Gamno santuga manami juc canchu. Gamno munayniyöga manami juc canchu. Gamga fiyupa almiraypajcunatami rurashcanqui. ");
INSERT INTO qub_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Maquiquiwan ayparcamuptiqui chiquimajcunataga pachami ultacurcusha. ");
INSERT INTO qub_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","«Jorgushayqui runacunataga cuyapashpayquimi pushaycanqui. Munayniquiwanmi tiyashayqui rispitädu pachaman pushaycanqui. ");
INSERT INTO qub_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Chayta mayarga waquin nasyuncho tiyajcunapis fiyupami mancharenga. Filistea runacunapis mancharir almaynajmi ricaconga. ");
INSERT INTO qub_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Edom runacunapa mandajnincunapis mancharir callpaynajmi ricacongapaj. Moab runacunapa mandajninpis mancharir sicsicyangami. Cananeo runacunapis mancharishpanmi ima ruraytapis mana camäpacongachu. ");
INSERT INTO qub_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Paycunaga fiyupa munayniquiwanmi mancharishpan upatasha ricaconga. Ruminöpis chiyacäconga acrashayqui runacuna päsacurinancama. ");
INSERT INTO qub_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Tayta Dios, Israelcunataga gammi pushanquipaj tiyanayquipaj acrashayqui puntaman. Tiyanayquitaga quiquiquimi camarishcanqui. Chaychömi imaycamapis tiyachinquipaj. ");
INSERT INTO qub_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","«Tayta Dios gamllami imaycamapis mandaycanquipaj.» ");
INSERT INTO qub_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Carrëtancunawan cawalluncunawan faraonpa suldäruncuna lamar chaupinta aywaycaptin Tayta Dios lamar yacuta cashganman cutichir ñiticarpachiran. Israelcunami ichanga päsaran chaqui allpapa. ");
INSERT INTO qub_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Chaypitami Aaronpa pañin profetïsa Mariaga panderëtallanpawan cantaran. Chaura llapan warmicunapis cushicushpan gallaycuran panderëtata awishpan dansayta. ");
INSERT INTO qub_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Caynömi María cantaran: «Tayta Diosta alabar cantay munayniyoj cayninwan binsishanpita. Payga cawallucunatami, muntädu aywajcunatami lamarman garpurisha.» ");
INSERT INTO qub_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Chaypitanaga Israelcunata Puca Lamarpita Moisés pushacuran. Chaura aywacuran Shur jutiyoj chunyaj chaqui jircapa. Quimsa junajna aywarpis yacuta mana tariranchu. ");
INSERT INTO qub_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Chaypita chayaran Mara jutiyoj partiman. Chaycho yacu caycajtaga asgaptin mana upuranchu. Chayno yacu asgashanpitami chay partipa jutinta churaparan Mara nir. ");
INSERT INTO qub_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Chaura runacunaga Moisespa washan rimaran «Cananga ¿imataraj upushun?» ninacur. ");
INSERT INTO qub_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Chaura Moisesga Tayta Diosta mañacuran yanapänanpaj. Mañacuptin Tayta Diosga juc yörata ricachiran. Chayta Moisés yacuman jitarpuran. Chaura yacuga upunanpaj allina ticracuriran. Chaychömi Tayta Diosga Israelcuna imano cawananpäpis laycunata willaparan. Wiyacunanpaj cashanta mana wiyacunanpaj cashantapis paycunata mayaparan. ");
INSERT INTO qub_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","Paycunata niran: «Wiyacamaptiquega, munashänölla cawaptiquega, laynëcunata cumliptiquega Egiptucunata castigar gueshyawan charichishäno manami castigashayquipächu. Nogami cä Tayta Diosniqui, imapitapis allchacächej.» ");
INSERT INTO qub_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Chaypita päsar chayaran Elim partiman. Chaycho caran chunca ishcay (12) pashtaj yacu, ganchis chunca (70) palmëra yöracuna. Chay yacu ñaupanmanmi tolduncunata ichichiran. ");
INSERT INTO qub_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Elimpita Israelcuna ushajpaj aywacur chayaran Sin jutiyoj chunyajman. Chayga caycan Elimpita Sinaïman aywajchömi. Chay caran Egiptupita aywacushanpitaga quilla chunca pichga (15) junajninchöna. ");
INSERT INTO qub_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Chay chunyajcho llapan runacuna Moisespawan Aaronpa contran rimaran. ");
INSERT INTO qub_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","Chayno rimarmi paycunata niran: «Egiptullachöna Tayta Dios wañuchimashwan caran. Chaychöga sacsananchïyaj aychata tantatapis micoj canchi. Mancanchïcunacho aychapis manami pishejchu. Gamcunaga cay chunyajman pushamashcanqui llapanëta yargaypita wañuchimänayquipämi.» ");
INSERT INTO qub_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Chaymi Tayta Diosga Moisesta niran: «Janajpitami tantata tamyatano shicwachimushaj. Chaura paycunanami tiyaycashanpita aywar waran-waran shuntamonga chay junaj micunan aypajllata. Cananmi musyashaj noga nishäta cumlishanta mana cumlishantapis. ");
INSERT INTO qub_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Sojta junaj cajchöga ishcay junaj micunanpaj aypajta shuntachun.» ");
INSERT INTO qub_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Chayno niptin Aaronwan Moisesga Israelcunata niran: «Canan tardimi gamcuna musyanqui Egipto nasyunpita Tayta Dios jorgamushushayquita. ");
INSERT INTO qub_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","Tutapapis ricanquipaj Tayta Dios fiyupa munayniyoj cashanta. Nogacunapa conträ rimanayquipäga ¿pitaj nogacunaga cä? Gamcunaga Tayta Diospa contranmi rimashcanqui. Payga contran rimashayquita wiyashami. ");
INSERT INTO qub_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Tayta Diosmi tardipa micunayquipaj aychata goshunquipaj; tutapa micunayquipäna aypalla tantata. Gamcuna paypa washan rimashayquitaga wiyashami. Nogacunaga manami imapis cächu. Gamcuna manami nogacunapa conträchu rimashcanqui. Chaypa ruquenga Tayta Diospa contranmi rimashcanqui.» ");
INSERT INTO qub_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Chaypitaga Aaronta Moisés niran: «Tayta Diosga wiyashami Israelcuna contran rimashanta. Cananga Israelcunata willay Tayta Diospa ñaupanman shuntacänanpaj.» ");
INSERT INTO qub_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Israelcuna shuntacarcuptin Aarón willapaycaptinna llapan Israelcunaga chunyajpa ricäriran. Chaycho ricaran Tayta Diospa achicyaynin pucutaycho caycämojta. ");
INSERT INTO qub_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Moisesta Tayta Dios willashpan niran: ");
INSERT INTO qub_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","«Israelcunata wiyashcämi washäta rimarcaycajta. Paycunata willay cayno nir: ‹Tardipa aychata micunquipaj. Tutapana tantata micunquipaj sacsanayquicama.› Chaynöpami musyanquicuna noga gamcunapa Tayta Diosniqui cashäta.» ");
INSERT INTO qub_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Chay tardi aypalla codorniz äbicuna juntaycuran Israelcuna tiyaycashanmanga. Warannin tutapanami tiyaycashan ñaupan pampacunaga yuraj shullaylla warämuran. ");
INSERT INTO qub_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Nircur chay shullay chaquircuptinna rashta-niraj yurajlla pampacho ricacuran. ");
INSERT INTO qub_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Israelcunaga manami musyaranchu ima cashantapis. Jucnin-jucninpis ninacuran «¿Cayga imaraj?» nishpan. Chaura Moisés niran: «Cayga caycan micunayquipaj Tayta Dios goycäshushayqui tantami. ");
INSERT INTO qub_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Tayta Diosga nisha gamcuna micunayqui-tupuylla shuntanayquipämi. Aycajpis juc tolducho cashallayquipita, cada runapaj shuntanqui ishcay calu mati juntatano.» ");
INSERT INTO qub_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Chaura Israelcunaga Tayta Dios nishannömi shuntaran. Waquenga wallcallata shuntaran; waquenga achcata. ");
INSERT INTO qub_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Tupuptenga wallcata shuntajpapis mana pishiranchu. Achcata shuntajpapis mana puchuranchu. Chaynömi cada junaj shuntaran micunanpaj-tupuyllata. ");
INSERT INTO qub_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Chaypita Moisés niran: «Warapäga ama pipis puchöchengachu.» ");
INSERT INTO qub_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Chaypis waquenga Moisés nishanta mana wiyacur waranninpaj churacuran. Chaura chay churacushanga curushpan fiyupa asyaricuriran. Chaymi Moisesga piñacuran chay churacojcunata. ");
INSERT INTO qub_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Chaypitanaga cada tuta cada ünun shuntaj micunan-tupuyllana. Mana shuntashan cäga shanaywan chullucäcoj. ");
INSERT INTO qub_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Cada semänacho sojta junaj cajchöga waranninpajwan shuntaj. Waranninpäpis shuntaj chay junajpaj shuntashantano. Chayno shuntaycajta ricar Israelcunapa mandajnincunaga Moisesta willaj aywaran. ");
INSERT INTO qub_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Willaptin Moisés niran: «Chayno shuntananpämi Tayta Dios nisha. Wara junäga Tayta Diosta rispitana säbadu jamay junajmi. Chaymi yanunayquipaj cajtaga canan junajlla yanuy warapajwan. Timpuchinayquipaj cajtapis cananllana timpuchiy. Micurcur puchoj cajtaga churanqui wara junaj micunayquipaj.» ");
INSERT INTO qub_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Moisés nishannöllami churacuran warannin micunanpaj. Chay cäga manami asyariranchu, ni cururanpischu. ");
INSERT INTO qub_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Chaura Moisés niran: «Canan junäga chay churacushayquita micuy. Cananga manami imatapis tarinquipächu pampacho. Chaynöga caycan säbadu jamay junaj, Tayta Diosta rispitana junaj captinmi. ");
INSERT INTO qub_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Sojta junajmi shuntanqui micunayquipaj. Ganchis caj junajchöga säbadu jamay junaj captin manami imapis cangapächu.» ");
INSERT INTO qub_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Chayno willaycaptinpis waquenga ganchis junaj cajchöpis shuntaj yarguran. Ichanga manami imatapis tariranchu. ");
INSERT INTO qub_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Chaura Tayta Diosga Moisesta niran: «¿Imaycamataj gamcunaga laynëcunata mana wiyacunquichu? ");
INSERT INTO qub_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Ama gongaychu. Nogami nishcä ganchis caj junaj säbadu jamay junajcho jamanayquipaj. Chaymi gamcunataga sojta caj junajcho micuyta ishcay junajpaj goycä. Chaura ganchis caj junajchöga mana llojshiypa wasillayquicho goyäcunqui.» ");
INSERT INTO qub_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Chaynöpami ganchis caj junajchöga llapan runacuna jamaran. ");
INSERT INTO qub_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Israelcuna shuntashanga caran yurajmi, jinachöpis culantrupa murunnömi. Mishquiran abëjapa mishquinwan rurasha tantano. Chaytami Israelcunaga «maná» nir jutichaparan. ");
INSERT INTO qub_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Chaypitana Moisesga Israelcunata niran: «Tayta Diosmi nimashcanchi noganchïpita mirajcuna ricananpaj ishcay matitano manäta churananchïpaj. Chaynöpami paycunaga musyanga Egiptupita jorgamashpanchi chunyajcho tantata Tayta Dios garamashanchïta.» ");
INSERT INTO qub_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Aarontapis Moisés niran: «Ishcay calu mati juntatano churay manäta juc mancaman. Nircur Tayta Diospa ñaupanman churay. Chaycho churaranga Israelcunapita mirajcuna ricananpämi.» ");
INSERT INTO qub_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Chaura Moisesta Tayta Dios nishannömi Aaronga mancata churaran babul ñaupaman. ");
INSERT INTO qub_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Chaynömi Israelcunaga manäta micuran chuscu chunca (40) watantin Canaán nasyunman chayanancama. ");
INSERT INTO qub_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","Ishcay mati manäta shuntashanga caran ishcay quïlunömi. Chay tuputami «gomer» nej. ");
INSERT INTO qub_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Sin chunyajcho tiyarcaycashanpita llapan Israelcuna aywacuran. Tayta Dios nishannöllami goyar-goyar aywarcaycaran. Chayno aywaycällarmi chayaran Refidim partiman. Chaychöga runacuna upunanpaj yacu mana caranchu. ");
INSERT INTO qub_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Chaura rabyashpan Moisesta nipäcuran: «¡Yacuta gomay upunäcunapaj!» Chaura Moisés niran: «¿Imanirtaj nogata nimanqui? ¿Imanirtaj Tayta Diosta musyapayta munanqui?» ");
INSERT INTO qub_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Runacuna pasaypa yacunaypita car Moisespa contran rimar nircaycaran: «¿Cayno ñacachimänayquipächu Egiptupita jorgamarayqui? ¿Llapan wamräcunawan uywäcunapis yacunaypita wañunäcunapächu jorgamarayqui?» nir. ");
INSERT INTO qub_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Chayno niptinmi Moisesga Tayta Diosta mañacur niran: «¿Imatataj rurashaj cay runacunataga? Manapis aycällatanami sajmaycällar wañuycachimanga.» ");
INSERT INTO qub_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Chaura Tayta Dios niran: «Israelcunapita ñaupacuy juc ishcay mayur runacunata pushacurcur. Nilo mayuta wirushayqui tucrutapis apay. ");
INSERT INTO qub_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Ayway nogata tarimänayquicama. Nogaga Horeb jircachömi gaga janancho ichirar shuyaycäshayqui. Chaymi gagata wiruptiqui yacu llojshimonga llapan upunanpaj.» Chaura Moisesga Tayta Dios nishanno ruraran Israel mayur runacuna ricaycaptin. ");
INSERT INTO qub_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Chay partipa jutintanami churaparan «Meriba» nir, «Masah» nir. Chayno jutinta churaparan Israelcuna Moisespa contran rimashanpita, Tayta Diosta musyapayta munashanpitami. ");
INSERT INTO qub_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Israelcuna Refidimcho tiyarcaycaptin Amalec runacunaga paycunawan pillyananpaj aywaran. ");
INSERT INTO qub_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Chaura Moisesga Josuëta niran: «Gam acray noganchi castacunapita Amalec runacunawan pillyanayquipaj. Nogami wara tuta puntacho caycäshaj Tayta Dios ‹apay› nimashan tucru aptasha.» ");
INSERT INTO qub_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Chaura Moisés nishannömi Josuëga runacunata acrarcur Amalec runacunawan pillyaj aywaran. Chay örapäga Moisespis, Aaronpis, Hurpis puntachöna carcaycaran. ");
INSERT INTO qub_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Moisés ricrancunata janajpa jogariraptenga Israelcuna binsiycaran. Ricrancuna uticar bäjaptin ichanga Amalec runacunana binsicurpoj. ");
INSERT INTO qub_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Moisespa ricrancuna uticaptenga Aaronwan Hur rumita churaparan chayman jamananpaj. Nircur paycunaga Moisespa ricranta janajpa jogariraran jucnin wac-lädunpa jucnin cay-lädunpa. Chaura Moisespa ricranga janajllapa caycaran inti yaganancama. ");
INSERT INTO qub_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Chaynöpami Josuëga Amalec runacunata binsiran. ");
INSERT INTO qub_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Chaypitaga Moisesta Tayta Dios niran: «Pillya cashantaga isquirbiy mana gongacänanpaj. Josuëtana willanqui Amalec runacunataga noga illgächinäpaj cashanta.» ");
INSERT INTO qub_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Chaypita Moisesga altarta pergarcur jutinta churaparan «Tayta Diosmi bandërä» nir. ");
INSERT INTO qub_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","Nircur niran: «Amalec runacuna Tayta Diospa contran pillyashanpitami Tayta Diosga paycunapita mirajcunapa contran imaycamapis canga.» ");
INSERT INTO qub_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Madián runacunapa cüran Jetro Moisespa suyrun caran. Paymi mayaran Moisespäwan Israelcunapaj Tayta Dios imata rurashantapis, imano Egiptupita jorgamushantapis. ");
INSERT INTO qub_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","Mas ñaupatanami Moisesga warmin Seforata «Cuticuy» niran. Chaura wasinman chayaptin Jetro uywaycaran wamran Seforata ishcan wamrantawan. ");
INSERT INTO qub_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","Moisesga «Cay marcacho jäpa runami cashcä» nishpan juc wamranpa jutinta Gersón nir churaparan. ");
INSERT INTO qub_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","Chaynöpis Moisesga «Papänëpa Tayta Diosninmi yanapämasha. Faraón wañuchimänanpitapis gueshpichimasha» nishpan jucaj wamranpa jutinta churaparan Eliezer nir. ");
INSERT INTO qub_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Chaypitana Moisespa warmin Seforatawan ishcan wamrantinta pushacurcur suyrun Jetroga Moisés cajman chayaran. Chay wichanga Israel runacunawan Moisés tiyaycaran chunyajcho Tayta Dioswan Tincuna jirca ñaupancho. ");
INSERT INTO qub_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","Moisesta Jetro niran: «Nogallä suyruyqui Jetromi shamushcä gamta rajaj, ishcan wamrayquiwan warmiquiwan» nir. ");
INSERT INTO qub_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Chaura Moisesga taripaycur suyrunpa ñaupanman gongurpacuran. Nircur saludashpan mucharan. Imano cashantapis willapänacurcurnami toldunman yaycuran. ");
INSERT INTO qub_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Chaycho Moisesga suyrunta willaparan Tayta Dios Israelcunapa faburnin cashpan faraonta, Egipto runacunata imano rurashantapis. Chayno willaparan Egiptupita aywar nänicho imano ñacashanta, paycunata Tayta Dios imano yanapashantapis. ");
INSERT INTO qub_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Egipto runacunapa munayninpita Israelcunata cuyapar Tayta Dios jorgushanta wiyaycur Jetroga amatar cushicuran. ");
INSERT INTO qub_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","Nircur niran: «Tayta Diosga alabasha caycullächun. Gamcunataga amatar ñacaycajtami jorgusha-cashunqui faraonpa, Egiptucunapa munayninpita. ");
INSERT INTO qub_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Egipto runacuna manacajman churashushpayqui pasaypa ñacaycächishushayquipitami jorgushurayqui. Chaymi cananga musyä Tayta Dios waquin dioscunapita mas munayniyoj cashanta.» ");
INSERT INTO qub_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Nircur Jetroga Tayta Diospaj rupachina sacrifisyutawan waquin sacrifisyutapis rupachiran. Nircurna Aarón y Israel mayurcuna shuntacaran Moisespa suyrun cajman Tayta Diospa ñaupancho paycunawan iwal micunanpaj. ");
INSERT INTO qub_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Warannin junaj Moisesga jamacuycur Israel runacunata arriglaycaran. Chaura goyarpoj pacha chacänancama Moisesta runacuna täparaycaran. ");
INSERT INTO qub_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Moisés imanöpis Israelcunata arriglaycajta ricar suyrun Jetroga niran: «¿Imanirtaj gam japallayquega runacuna quijacushanta arriglanqui? Gam cajman tutapita tardicama runacuna shamuptin timpuyqui manami aypangachu llapanta arriglanayquipaj.» ");
INSERT INTO qub_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Chayno niptin Moisés niran: «Nogaman paycuna shamun Tayta Diosta tapucapänäpaj. ");
INSERT INTO qub_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Imatapis arriglayta mana camäpacorga shamun noga arriglanäpaj. Chaycho mayganpis juchayoj cashanta musyaycurmi arriglä. Nircurnami paycunata tantiyachë Tayta Diospa laynincunata, yachachimashancunata.» ");
INSERT INTO qub_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Chaura suyrun tantiyachiran cayno nir: «Nogapitaga llapanta gam japallayqui arriglaptiqui manami allichu. ");
INSERT INTO qub_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Runacunapis gampis uticanquimi. Quiquillayquega manami atipanquipächu llapanta arriglayta. ");
INSERT INTO qub_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Canan imano ruranayquipäpis nishäta sumaj wiyacuy. Willapashäno ruraptiqui Tayta Dios yanapaycushunqui. Diospa ñaupanmanga gammi aywanqui Israelcunapa ruquin. Paycuna nishushayquitapis Tayta Diosta willapanqui. ");
INSERT INTO qub_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Israelcunatana willapanqui Diospa laynin imano cashantapis. Chayno yachachinqui imano goyänanpäpis. ");
INSERT INTO qub_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Gamga acray jurmal runacunata, Diosta rispitajcunata, rasun cajta rurajcunata, saynita mana chasquejcunata. Chayno acrarcur churanqui mandaj cananpaj. Waquin mandanga warangata (1,000), waquin pachacta (100), waquin pichga chuncata (50), waquinna chuncata. ");
INSERT INTO qub_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Chauraga chay mandajcunana runacunata arriglanga. Mana arriglayta puydishan mas sasa cajllatana apamonga gam arriglanayquipaj. Mana sasa cajtaga churashayqui mandajcunallanami arriglanga. Chaura gamga manami alläpa ñacanquinachu. Paycuna yanapäshuptiqui gamga ancashllanami ruranquipaj. ");
INSERT INTO qub_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Tayta Dios camacächiptin willapashäno ruraptiquega balurniquipis cangarämi. Chayno sumaj arriglaptiquega llapan runacunapis cushishami wasinman cuticonga.» ");
INSERT INTO qub_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Chaura Moisesga suyrun nishannölla ruraran. ");
INSERT INTO qub_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Chaymi Israelcunapita acraran mas alli tantiyajnincunata. Nircur suyrun nishanno churaran mandananpaj. Waquinta churaran warangata (1,000) mandananpaj. Waquinta churaran pachacta (100) mandananpaj. Waquinta churaran pichga chuncata (50) mandananpaj. Waquinta churaran chuncata mandananpaj. ");
INSERT INTO qub_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Chaura paycunallana runacunata arriglaj fäsi cajcunataga. Arriglayta mana camäpacushan cajcunallatanami Moisés arriglananpäga päsaj. ");
INSERT INTO qub_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Chaypita suyrun aywacuptin Moisesga despacharan. Aywacur Jetroga marcanman cuticuran. ");
INSERT INTO qub_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","Egiptupita aywacushanpita quimsa quillata Israelcunaga chayaran chunyaj Sinaí partiman. ");
INSERT INTO qub_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","Refidimpita aywacorga chayaran Sinaí punta chaquin pampaman. Chaychönami Israelcunaga tolduncunata ichichiran. ");
INSERT INTO qub_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Chaypitana Moisesga puntaman wicharan Dioswan tincunanpaj. Chaymi Moisesta Tayta Diosga puntapita nimuran: «Jacobpita miraj Israel-masiquicunata willay noga cayno nishäta: ");
INSERT INTO qub_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","‹Gamcuna ricashcanquimi Egiptucunata imano castigashätapis. Musyanquimi caycashäman imano pushamushätapis. Wawancunata anca sumaj apashannömi Egiptupita apamushcä. ");
INSERT INTO qub_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Chaymi gamcuna wiyacamaptiqui, conträtu rurashanchïta cumliptiquega canquipaj cuyashä runacuna. Waquin runacunata cuyashäpita masmi cuyashayqui. Intëru cay pachacho tiyaj runacunata noga camasha carpis gamcunatami mas cuyashayqui. ");
INSERT INTO qub_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","Gamcunataga churashayqui nasyunninpa cüräcunano canayquipämi, santo car nogallata sirbimänayquipämi.› Chayno nishäta willay Israel runacunata.» ");
INSERT INTO qub_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Chaymi Moisés cutir llapan mayurcunata shuntaran. Nircur yachachiran Tayta Dios nishancunata. ");
INSERT INTO qub_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Willaptinmi Israel runacuna juc shimilla niran: «Tayta Dios nishantaga llapantami rurashaj» nir. Paycuna chayno nishantami puntaman cutiycur Tayta Diosta Moisés willaran. ");
INSERT INTO qub_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Chayno willaptinmi Moisesta Tayta Dios niran: «Yanauyaycaj pucutay rurinpitami parlapäshayqui Israel runacuna wiyananpaj. Chaynöpami paycuna imaypis riguenga gamta parlapashäta.» ");
INSERT INTO qub_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","Chaymi Tayta Diosga niran: «Aywar runacunata willanqui canan y wara purificacunanpaj. Röpancunatapis tagshacuchun. ");
INSERT INTO qub_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","Warantinpaj camaricushalla carcaycächun. Warantinmi llapan ricaycämaptin nogaga Sinaí puntaman urämushaj. ");
INSERT INTO qub_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Punta chaquinchöna intëru tumarejpa señalta churapanqui chaypita mas janamanga runacuna mana wichämunanpaj. Punta gallarejpita janamanga ama wichämuchunnachu. Señalta päsamoj cäga wañuchicangami. ");
INSERT INTO qub_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Chay señalta päsaj cajtaga ama pipis yatayllapis yatayconganachu. Chaypa ruquenga lëchawan-carpis sajmaypa-carpis wañuchinqui. Señalta päsaj cajtaga runatapis uywatapis chaynömi wañuchinqui. Runacunaga punta chaquincho señal caycashancama aywanga uyshapa wagranta tucamojta wiyar-rämi.» ");
INSERT INTO qub_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Chaura puntapita Moisés urarcamur runacunata camaricachiran Tayta Diosta adurananpaj. Chaura paycunaga röpanta tagshacuran. ");
INSERT INTO qub_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","Chaypita Moisés niran: «Warantinpaj camaricushalla carcaycay. Maygayquipis majayquiwan ama cacunquichu.» ");
INSERT INTO qub_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Chay quimsa junajman wararcuptenga puntata yana pucutay ñiticurcuran. Fiyupa räyupis illguypis caran. Uyshapa wagran wagamushanpis wiyacämuran. Chaura llapan Israelcuna manchariywan sicsicyaran. ");
INSERT INTO qub_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Chaypita Moisesga llapan Israelcunata pushacurcur aywaran punta chaquinman chaycho Tayta Diosta shuyänanpaj. Israelcunaga punta chaquinman chayar ichicaycäriran. ");
INSERT INTO qub_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Intëru Sinaí jircapitami goshtay jatariran Tayta Dios chay jircaman nina chaupincho urämusha captin. Jurnupitanöraj goshtay jatariycaran. Intëru jircapis fiyupa sicsicyaran. ");
INSERT INTO qub_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Uyshapa wagran wagamushan mas sinchipa mas sinchipana wiyacämuran. Moisés parlapaptin Tayta Diosga räyu pashtajnöraj parlamoj. ");
INSERT INTO qub_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Tayta Diosga quiquin Sinaí puntaman urämuran. Nircur Moisesta gayaran chayman aywananpaj. Moisés chayaptin ");
INSERT INTO qub_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","Tayta Dios niran: «Cutircushpayqui runacunata willay ricachishayqui señalpita mas janamanga ricamänan-casha mana wichämunanpaj. Wichämorga wañongami. ");
INSERT INTO qub_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Cüracunapis nogaman shamunanpäga purificacur limyuyächun. Man'chäga usharpis ushaycömanmi.» ");
INSERT INTO qub_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Chaura Moisés niran: «Runacunaga cay Sinaí puntaman wichämuyta manami balurangachu. Gammi nogata nimashcanqui ‹Punta chaquinpa intëru tumarej señalta churay. Chaypita janamanga rispitädumi canga› nir.» ");
INSERT INTO qub_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Chayno niptinmi Tayta Dios niran: «Runacuna caycashanman cutircur Aaronta pushacurcur cutimunqui. Cüracunawan runacunaga amana päsamonganachu ricachishayqui señalpita mas janaman noga caycashä cajmanga. Päsamoj cajtaga usharpis ushaycömanmi.» ");
INSERT INTO qub_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Chaura Moisesga Israelcuna caycashanman cutiycur willaran Tayta Dios nishanta. ");
INSERT INTO qub_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Tayta Diosga Israelcunata willapar caynömi niran: ");
INSERT INTO qub_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","«Nogaga cä Tayta Diosniquimi. Egiptucho uyway car ñacarcaycajtami noga jorgamushcä. ");
INSERT INTO qub_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","«Nogapita mas juctaga ama ‹diosnë› ninquichu. ");
INSERT INTO qub_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","«Aduranayquipäga imatapis ama ruranquichu syëlucho caj-nirajta, cay pachacho caj-nirajta, lamar rurincho caj-nirajtapis. ");
INSERT INTO qub_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Chaycunapa ñaupanmanga ama gongurpacunquichu ni aduranquipischu. Nogallami Tayta Diosniquega cä. Japalläta aduramänayquitami munä. Mana wiyacamar ïdulucunata adurajcunataga castigashaj maman-taytanta, wamranta, willcanta mas willcan cajtapis. ");
INSERT INTO qub_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","Noga nishäta rurashpan llapan mandamintöcunata cumliptenga paycunapita waranga aywaycama mirajnincunatapis cuyapäshämi. ");
INSERT INTO qub_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","«Tayta Diospa jutinta ama jogarinquichu manacajpäga. Manacajcunallapaj jutinta jogarej cajtaga castigangami. ");
INSERT INTO qub_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","«Ama gonganquichu säbadu jamay junäga rispitädu cashanta. ");
INSERT INTO qub_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Semänacho sojta junajmi arunqui. Chay junajcunacho rurayniquicunata ruranqui. ");
INSERT INTO qub_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","Sojta junajpa warannin junäga Tayta Diosta aduranayquipaj säbadu jamay junajmi. Chay junäga ama arunquichu, quiquiqui, ollgu ni warmi wamrayqui, ollgu ni warmi uywayniqui, uywayquicuna, ni lagacamoj runacunapis. ");
INSERT INTO qub_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Tayta Diosga sojta junajchömi cay pachata rurayta usharan cay pachacho cajcunatapis, syëluta syëlucho cajcunatapis, lamarta lamarcho cajcunatapis. Ganchis caj junajchöga Tayta Dios jamarannami. Chaymi chay junajpäga niran payta rispitanan junaj cananpaj. ");
INSERT INTO qub_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","«Mamayquita taytayquita alli ricanqui. Chaynöpami goycunäpaj caycaj nasyuncho edäyänayquicama alli cawanquipaj. ");
INSERT INTO qub_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","«Ama wañuchicoj canquichu. ");
INSERT INTO qub_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","«Majayoj caycar jucwanga ama cacunquichu. ");
INSERT INTO qub_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","«Ama suwacunquichu. ");
INSERT INTO qub_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","«Ama manacajtaga pitapis jitapanquichu. ");
INSERT INTO qub_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","«Ama munapaychu runa-masiquipa ima-aycantapis. Ama munapaychu warminta, ni uywayninta warmita ollgutapis, törunta ni bürruntapis, ni imantapis paypa cajtaga.» ");
INSERT INTO qub_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Chay öra Israelcunaga wiyaran räyu junrurushanta, uyshapa wagran wagamushantapis. Ricaran illgömushanta, jirca goshtashanta. Chaymi fiyupa manchacushpan carullachöna carcaycaran. ");
INSERT INTO qub_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","Chaynöpami Moisesta niran: «Gamllana parlapämay ari. Chaura nogacunaga wiyacushämi. Dioswanga amana parlashäcunachu. Pay parlapämaptenga wañucäcömanmi.» ");
INSERT INTO qub_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Chaura Moisesga runacunata niran: «Ama manchacuychu. Tayta Diosga shamusha gamcunata musyapäshunayquipämi, payta rispitashpayqui juchata mana ruraypa cawanayquipämi.» ");
INSERT INTO qub_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Chaypita runacuna carullacho carcaycaptin Moisesga aywaran yana pucutaycho Dios caycashan cajman. ");
INSERT INTO qub_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","Chaypita Moisesta Tayta Dios niran: «Israel-masiquicunata ninqui: ‹Gamcuna wiyashcanquinami syëlupita-pacha parlapämushäta. ");
INSERT INTO qub_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Goripita ni guellaypitapis ama ruranquichu «diosnë» nir aduranayquipaj. ");
INSERT INTO qub_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","« ‹Gamcuna nogapaj altarta ruranqui mitupita. Uyshayquita carpis wäcayquita carpis pishtarcur chaychömi rupachina sacrifisyuta carpis, alli goyaypita sacrifisyuta carpis garamanqui. Maychöpis rispitamänanpaj acrashä pachacho rispitamaj cajtaga bindisyuntami goshaj. ");
INSERT INTO qub_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","Nogata aduramänayquipaj altarta rumipita pergarga ama perganquichu llagllasha rumiwanga. Arucunayquiwan llagllaptiquega altarpaj manami bälenganachu. ");
INSERT INTO qub_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Chaynöpis altarta ama perganquichu escalun-niyojtaga. Chaypa wichaptiqui pengayniqui ricacanmanmi.› ");
INSERT INTO qub_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","«Cay laycunata Israel runacunata yachachinqui: ");
INSERT INTO qub_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","«Hebreo-masiquita uywayniqui cananpaj rantiptiqui, arupäshunquipaj sojta watallami. Watannin cajchönaga manami uywaynachu canga. Mana pägachiyllapa cachaycunqui. ");
INSERT INTO qub_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","Uyway cananpaj japallan yaycusha carga llojshicongapis japallanmi. Warmintin yaycusha carga warmintinmi llojshicongapis. ");
INSERT INTO qub_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","Uyway cananpaj japalla yaycojta patrunnin uywaynin warmiwan majachaptenga llojshicur quiquillanmi aywaconga. Chay warmicho wamrancuna ollgupis warmipis captenga warmiwan wamrancunaga patrunninpa maquincho quëdanga. ");
INSERT INTO qub_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","Ichanga chay runa patrunninta capas ninman ‹Warmëta, wamräta, gamtami llaquë, manami llojshïchu› nir. ");
INSERT INTO qub_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","Chaura patrunninna wasëman pushanga. Nircur puncuman sumaj guelliycachir rinrinta uchcurenga uchcucunawan. Chayno ruraycuptenga imaycamapis uywayninnami canga. ");
INSERT INTO qub_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","«Pipis warmi wamranta uyway cananpaj ranticuptenga manami ollgu uywaytanöga cachaycongachu. ");
INSERT INTO qub_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","Chay jipashta warminpaj patrun mana munaptenga juc Israel runa pägaycur shuntacunmanmi. Ichanga chay patrun warminpaj mana munarpis manami ranticunmanchu jäpa runamanga. ");
INSERT INTO qub_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","Chay uyway jipashta wamranwan majachar ichanga quiquinpa warmi wamrantanöna ricanga. ");
INSERT INTO qub_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","Chay jipashta uywaycarpis juc warmita ashicurcorga manami pishëchinanchu micuypita ni röpapitapis. Chayno majan car derëchuntapis cumlenga. ");
INSERT INTO qub_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","Chay quimsa castapaj nishäcunata runa mana cumliptenga chay uyway warmi librinami caconga imatapis mana pägayllapana. ");
INSERT INTO qub_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","«Pitapis magar wañuycachej cäga quiquinpis wañuchicangami. ");
INSERT INTO qub_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","Wañunanpaj distinasha caycaptin yarpaypa mana wañucherga manami wañuchishachu canga. Mana wañuchisha cananpämi noga ricachishayqui chay wañuchej runa mayman gueshpinanpäpis. ");
INSERT INTO qub_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","Yarpaypa runa-masinta wañuycachejtaga altarnëman gueshpisha caycaptinpis wañuchinqui. ");
INSERT INTO qub_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","«Mamanta taytanta magaj cäga quiquinpis wañuchicanga. ");
INSERT INTO qub_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","«Juc runata suwarcur ranticuptin u suwashan runata chararaycajta taripaptenga chay suwaj runa wañuchicächun. ");
INSERT INTO qub_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","«Mamanta u taytanta ashllej cajpis wañuchicächun. ");
INSERT INTO qub_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","«Runacuna rimanacushancho pillyar sajmaypapis, cutaypapis, cämacho gueshyar jitaränancama magaycuptin, ");
INSERT INTO qub_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","chayno jitaraycashanpita jatarcur tucrullanwanpis puriptenga rachejpaj magaj runa manami castigacanganachu. Chay runaga jampiyllana jampichenga; ayca junajpis jitarashan aträsullanpitana päganga. ");
INSERT INTO qub_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","«Pipis, uywayninta warmitapis ollgutapis gueruwan magashpan wañuycachiptenga chay magaj patrunta castiganquicuna. ");
INSERT INTO qub_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","Magashanpita juc ishcay junajraj cawaptenga chay patrun manami castigashanachu canga. Chaynöga canga quiquinpa uywaynin casha captinmi. ");
INSERT INTO qub_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","«Capas ishcaj runa pillyaycashancho pachayoj warmita päsapacunman. Chay achäquilla shulluptenga juezmanmi aywanan demandacoj. Chaycho mana wañuptin-imaptenga warmipa lesionninpita runan mañaptin jueznami tantiyaycur pägachenga. ");
INSERT INTO qub_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","Chayaycachishan-cäsulla gueshyar warmi wañuptin ichanga chayachej runapis wañuchicanga. ");
INSERT INTO qub_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","Ñawinta jorgupaptenga quiquintapis ñawinta jorguparinqui. Quiruta jorgupaptenga quirunta jorguparinqui. Maquinta paquipaptenga maquinta paquiparinqui. Chaquinta paquipaptenga chaquinta paquirinqui. ");
INSERT INTO qub_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","Rupachiptenga quiquintapis rupachinqui. Rachejpaj magaptenga quiquintapis rachejpaj maganqui. Goyuy-goyuy ruraptenga quiquintapis goyuy-goyuy ruranqui. ");
INSERT INTO qub_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","«Juc runa uywayninta ollguta u warmitapis magashpan ñawinta pashtapaycorga cachaycongana. Ñawinta pashtapashanpitami uywayga librina aywaconga. ");
INSERT INTO qub_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","Quirun llojshejpaj uywayninta magaycurpis quirunta jorgupashanpitami libri cachaycongana. ");
INSERT INTO qub_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","«Ollguta u warmita manshu wäca wishtar wañuchiptin quiquin wäcatapis sajmaycällar wañuchenga. Nircur aychantapis ama micongachu. Ichanga duyñunta ama dimandanganachu. ");
INSERT INTO qub_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","Wäcan wishtacoj captenga duyñun wichgayllapa uywanman. Wishtacoj caycashanta musyaycar cachayllata caycächiptin warmita u ollguta wishtar wañuycachiptenga wäcata sajmaycällar wañuchenga. Duyñunpis wañuchicanga. ");
INSERT INTO qub_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","Uywapa duyñun wañunanpa ruquin pägayta munaptenga aycatapis mañashanta päganga. ");
INSERT INTO qub_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","Chaynöllami ruranqui ollgu wamrata warmi wamrata wishtaptinpis. ");
INSERT INTO qub_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","Wäca ollgu uywayta u warmi uywayta wishtar wañuchiptin wäcata sajmaycällar wañuchinqui. Nircur wäcapa duyñunna uywaypa patrunninta päganga quimsa chunca guellayta. ");
INSERT INTO qub_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","«Pipis uchcuta uchcuptin u yacu pösutapis chapänillata cachaycuptin, chayman wäca car, bürru carpis yagaptin, ");
INSERT INTO qub_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","pösupa duyñun u uchcuta ojtichejmi uywapa risyunta päganga guellayninpa. Wañoj uywatana apaconga. ");
INSERT INTO qub_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","«Pipa wäcanpis juc runapa wäcanta magar wañuchiptenga cawaycaj cajta ranticuycur chaypa risyunta ishcan raquipänaconga pullan-pura, chayno wañoj wäcapa aychantapis. ");
INSERT INTO qub_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","Wäcan magacoj yachacasha cashanta musyaycar, mana ricashanpita juc wäcata wañuchiptenga duyñun ruquinta gonga. Wañusha wäcana pägajpaj canga. ");
INSERT INTO qub_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","«Pipis uyshata, cabrata, wäcata suwacurcur pishtacurcuptin, u ranticushana caycaptin taripacashpanga päganga juc wäcata suwacushanpita pichgata, juc uyshata u cabrata suwacushanpitana chuscuta. ");
INSERT INTO qub_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","«Chacaypa suwacuycajta tariycur wañuycachiptenga manami juchayojchu canga wañuchëga. ");
INSERT INTO qub_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","Junajpa suwacuycajta tarir wañuycachiptinmi ichanga wañuchicushano juchayoj canga. «Suwacoj runaga suwacushanpa risyunta pägachun. Pägananpaj guellaynin mana captenga quiquin suwata ranticuyconga. ");
INSERT INTO qub_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","«Cawaycajllata suwapa maquincho suwashan uywata taripaycorga duyñun shuntaconga. Ima uywata suwasha carpis suwashan uywatano ishcayta yapanga. ");
INSERT INTO qub_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","«Pipis uywancunata michishpan juc runapa chacranman, u übas wertanman uywancuna yaycuptin däñucushanpitaga quiquinpa cajta mas allinninta cutichenga. ");
INSERT INTO qub_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","«Pipis shatata cañaycuptin nina aywar ëracho rïgu goturaycajta ushaycuptin, u cusichananpaj caycajta ushaycuptenga nina sindej runami päganga aycatapis rupashanpita. ");
INSERT INTO qub_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","«Pipis juc Israel runata guellayninta, aläjanta paytacuycushanta, suwa wasinpita suwapaycuptin, chay suwata taripaptin suwashanta cutichenga. Jananman päganga ishcay chaynötaraj. ");
INSERT INTO qub_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","Suwa mana taripacaptenga wasiyojtana ñaupäman apamonga paytacuyninta yatashanta u mana yatashantapis jurachinanpaj. ");
INSERT INTO qub_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","«Pipis jucpa wäcanta, bürrunta, uyshanta, röpanta, man'chäga imatapis ogracajta duyñu-tucurcusha caycaptin juc runana ‹Nogapami› nir yurimushpanga ishcan shamonga ñaupäman. Taripacarga duyñu-tucoj caj päganga cutichishanpa jananman juc chaynötaraj. ");
INSERT INTO qub_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","«Pipis bürrunta, wäcanta, uyshanta, ima uywantapis paytacuycuptin, chaycho wañuptin, imapis päsaptin, pipis mana ricaycaptin suwa apaptenga ");
INSERT INTO qub_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","uywa ricaj runa nogapa ñaupächo juranga ‹Manami imatapis paytacuy uywata rurashcächu› nir. Chaura manami imatapis pägangachu. Uywayojpis manami pägachenganachu. ");
INSERT INTO qub_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","Paytacuyta mana sumaj ricashanpita suwa apaptenga duyñunta päganga aycatapis apashanpita. ");
INSERT INTO qub_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","Mañacuy uywata jirca animal micucurcuptin puchupanta duyñunta ricachishpanga manami päganganachu. ");
INSERT INTO qub_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","«Pipis uywata mañacuycur wañupacur, u gueshyaj-tucacherga mañacojna duyñunta päganga. ");
INSERT INTO qub_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","Duyñun ricaycaptin imapis päsaptinmi ichanga mana päganganachu. Guellaypaj mañacusha captenga aycapäpis mañacushallantana päganga. ");
INSERT INTO qub_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","«Pï runawanpis majachacänanpaj manaraj parlaj runa yatänillaraj jipashta aunichir paywan cacoj runaga warmin cananpäna simri shuntanga. Warmipa taytantapis päganga majachacaj mösu aycatapis pägashantano. ");
INSERT INTO qub_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","Jipashpa taytan chay runawan tiyananta mana munaptinpis simrimi päganga imanömi runa yatäni jipashwan majachacänanpaj mösu pägan, chaynöta. ");
INSERT INTO qub_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","«Brüjucunataga illgächinqui. ");
INSERT INTO qub_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","«Pipis uywawan cacojtaga wañuchinqui. ");
INSERT INTO qub_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","«Nogapaj sacrifisyuta pishtapämänanpa ruquin juc dioscunapaj pishtaj cajtaga wañuchinqui. ");
INSERT INTO qub_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","«Juc-lä runacunataga ama chiquinquichu, ama ñacachinquichu. Gamcunapis Egiptuchöga carayqui juc-lä runami. ");
INSERT INTO qub_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","«Biyüdacunatawan wacchacunataga ama ñacachinquichu. ");
INSERT INTO qub_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","Ñacachiptiqui paycuna llaquicushpan ruwacamashanta wiyashämi. ");
INSERT INTO qub_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","Chaymi fiyupa rabyacurcur wañuchishayquipaj. Chaura gamcunapa warmiquicunami biyüda quëdanga. Wamrayquicunami waccha quëdanga. ");
INSERT INTO qub_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","«Israel-masiqui pishëpacojta guellayniquita ristaycorga ama cobranquichu wawantapis guellay ristacoj cobrashannöga. ");
INSERT INTO qub_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","Guellayniquipaj punchunta rinda churaycuptenga tardi pacha chacaptin cutiycachinquina. ");
INSERT INTO qub_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","Chayllami caycan gasaypita pitucunanpäpis. Mana cutichiptiqui, ¿imanwantaj puñonga? Cuyapäcoj cashpämi pay mañacamashanta wiyashaj. ");
INSERT INTO qub_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","«Tayta Diosniquitaga ama manacajman churanquichu. Mandashojniquicunapäpis ama ‹Maldisyunädu cachun› ninquichu. ");
INSERT INTO qub_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","«Ama gonganquicunachu nogapaj apamuyta ima micuytapis poguptin rimir-punta shuntashayquita, chayno übaspita rurashayqui bïnutapis. «Guechpa caj ollgu wamrayquitapis goycamanqui. ");
INSERT INTO qub_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","Chayno nogapämi canga wäcapa, uyshapa, cabrapa rimir caj wawancunapis. Yurishanpita ganchis junajyajllami chay mallwacunaga mamanwan canga. Warannin pusaj caj junäga nogapäna apamunqui. ");
INSERT INTO qub_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","«Gamcunaga canqui nogapaj acrasha runacunami. Chaymi ama micunquichu jirca animalcuna wañuchishan uywapa aychanta. Chay aychataga allgucunata garaycunqui. ");
INSERT INTO qub_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","«Mana musyashayqui cajtaga ama ‹Rasunpami› ninquichu. Llutan rurajcunapa faburninpis ama jatarinquichu. ");
INSERT INTO qub_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","«Waquin runacuna mana allita ruraptinpis paycunanöga ama ruranquichu. Autoridäpa ñaupancho achcaj jucnöpa-jucnöpa niptinpis gamga rasun cajllata parlanqui. ");
INSERT INTO qub_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","Llutanta rurasha captenga ni pobri captinpis ama faburnin jatarinquichu. ");
INSERT INTO qub_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","«Contrayquipa ima uywanpis pantacasha caycajta tarishpayquega duyñunman cutichinqui. ");
INSERT INTO qub_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Contrayquipa uywan cargantin tunisha caycajta ricarga ama päsacunquichu. Chaypa ruquenga yanapar jatarachëshinqui. ");
INSERT INTO qub_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","«Dimandacamuptenga pobritapis alli arriglanqui. ");
INSERT INTO qub_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","Mana rasunpa cajta dimandacamuptenga ama chasquinquichu. Mana juchayoj runapaj ama ninquichu ‹Juchayojmi cayga. Wañuchun› nishpayqui. Juchaynaj runata wañuchejtaga manami perdunashächu. ");
INSERT INTO qub_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","«Autoridä captiqui faburnin canayquipaj pacayllapa guellayta pägayta munashuptiquipis ama chasquinquichu. Guellayta chasquej cäga ricacun gapranönami. Chaymi rasun cajtapis manana cäsupannachu. Chaynöpami guellay chasquëga juchaynajtana ‹juchayoj canqui› nir castigan. ");
INSERT INTO qub_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","«Juc-lä runacunata ama ñacachinquichu. Gamcunapis Egiptuchöga juc-lä runa cashpayqui ñacarayquimi. Chaymi imano ñacay cashantapis musyaycarga juc-lä runata cuyapanqui. ");
INSERT INTO qub_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","«Micuytaga sojta watami murupacunqui shuntapacunqui. ");
INSERT INTO qub_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","Watannin ganchis wataman aywaj cajchönaga chacrayquita jamachinqui. Chacrayquicho shiwa wiñamur pogojcunaga canga pobricuna shuntacunallanpäna, jirca animalcuna micunallanpäna. Übas chacrayquita olivo chacrayquitapis chaynölla ruranqui. ");
INSERT INTO qub_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","«Ima aruyniquitapis sojta junaj arunqui. Warannin ganchis junaj cajchöga jamanqui aroj wäcayquicuna, carga apaj uywayquicuna jamananpaj. Callpan yapay yurinanpaj jamachinqui uywayniquicunatapis arupacoj juc-lä runacunatapis. ");
INSERT INTO qub_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","«Noga nishätaga juctapis mana gongaypa llapanta cumlinqui. Juc-lä runacuna yäracushan dioscunata ama mañacunquichu. Chay dioscunapa jutintaga ama rimanquipischu. ");
INSERT INTO qub_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","«Cada watacho quimsa cuti fistata ruranqui nogata rispitamashpayqui. ");
INSERT INTO qub_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","«Lebadüraynaj Tantata Micuna fistata ruranqui. Chay fistachöga nishänölla ganchis junaj lebadüraynaj tantallata micunqui. Chaytaga ruranqui Egiptupita llojshicamushayqui Abib quillachömi. Pipis nogata aduramaj shamoj cäga jinaylla ama shamongachu. ");
INSERT INTO qub_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","«Chaypita Chaqui Micuy Cosëcha fistata ruranqui rimir caj cosëchata shuntayta usharcur. Wata ushananchöpis cosëchata shuntayta usharcur Übas Cosëcha Ushay fistata ruranqui. ");
INSERT INTO qub_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","«Ollgu cajcunaga watacho quimsa cutimi noga Tayta Diosniquipa ñaupäman shamonga cada fista rurayllan. ");
INSERT INTO qub_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","«Nogapaj uywayquita pishtarcur apamur uywapa yawarnintawan lebadürayoj tantata tallurcachir ama rupachinquichu. Chay uywapa wirantapis waranninpäga ama churaycunquichu. ");
INSERT INTO qub_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","«Chacracho murushayqui micuyniquita rimir-punta shuntar raquishan mas allinnin cajtaga apamunqui rispitamänayquipaj caycaj wasiman. «Cabra-mallwapa aychantaga ama yanunquichu mamanpa lëchinwanga. ");
INSERT INTO qub_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","«Nogaga anjilnëtami cachaycämö gamcunata pushashunayquipaj, aywaptiqui imapitapis chapäshunayquipaj. Chayachishunquipaj gamcunapaj camarishä cajman. ");
INSERT INTO qub_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Payta wiyacuy. Paypa contran imatapis ama ruraychu. Payga nogapa ruquë cashpanmi munaynëwan imatapis ruranga. Contran ruraptiquega manami perdunashunquipächu. ");
INSERT INTO qub_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","Payta wiyacuptiquega gamcunata chiquishojcunapa contranmi cashaj. ");
INSERT INTO qub_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","Anjilnë pushar chayachishunquipaj Amorreo runacuna tiyaycashanman Het runacuna tiyaycashanman, Ferez runacuna tiyaycashanman, Cananeo runacuna tiyaycashanman, Hev runacuna tiyaycashanman, Jebús runacuna tiyaycashanman. Chay runacunataga nogami ushajpaj illgächishäpaj. ");
INSERT INTO qub_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","Chay runacuna ‹diosnë› nishantaga ama aduranquichu. Chaypa ruquenga ïduluncunata illgächinqui. Rispitashan wanca rumincunatapis agullargärinqui. ");
INSERT INTO qub_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","«Nogallami Tayta Diosniquega cä. Chaymi nogallata rispitamashpayqui aduramanqui. Chayno cawaptiquega bindisyunta goshayquipaj micuypis, yacupis mana pishëshunayquipämi, ima gueshyapis mana charishunayquipämi. ");
INSERT INTO qub_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","Gamcunachöga manami ni jucnayllapis warmicuna shullongapächu, ni manami cangapächu wawata mana tarejpis. Chayno manami wañunquipächu edäniquiman manaraj chayarga. ");
INSERT INTO qub_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","«Nogami camacächishaj gamcuna päsashayqui nasyuncunapa tiyajcunaga manchacushunayquipaj, ima ruraytapis mana camäpacunanpaj, gueshpir aywacunanpaj. ");
INSERT INTO qub_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","Chayno fiyupa mancharichiptëmi Hev runacuna, Het runacuna, Cananeo runacunapis gueshpir aywaconga. ");
INSERT INTO qub_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","Chayno captinpis pushaycashä nasyunman chayachishpä chay runacunata manami juc watallachöga gargushächu. Juclla garguptëga chacra jamacur purunyanmanmi, jirca animalcunapis mirar ushashunquimanmi. ");
INSERT INTO qub_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Gamcunapa ñaupayquipitaga wamrayquicuna miraynin-tupu wallca wallcallami gargushäpaj. Chaypitanaga llapan chacrancunawan gamcunanami duyñu quëdanquipaj. ");
INSERT INTO qub_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","«Nasyunniquipa lindan caynömi canga: Puca lamarpita Filistea runacuna tiyashan cantun lamarcama, chunyajpitana Éufrates mayucama. Chaycho tiyajcunataga gargunayquipaj munayniquimanmi churashaj. ");
INSERT INTO qub_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","Chay runacunawanga alli goyänayquipaj ama parlacunquichu. Ni diosnincunatapis ama aduranquichu. ");
INSERT INTO qub_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","Chay runacunataga ama cachanquichu tiyashayqui nasyuncho tiyananpaj. Gamcuna cajcho tiyarga mana wiyacamänayquipämi shimita goshunquipaj. Chaynöpami paycuna yäracushan dioscunata aduraptiqui castigashayquipaj.» ");
INSERT INTO qub_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Moisesta Tayta Dios niran: «Noga caycashä puntaman wichämuy Aaronwan, Nadabwan, Abiüwan, mas ganchis chunca (70) rispitädu Israel mayur runacunawanpis. Paycunaga puntaman manaraj chayamur carullachöna gongurpacuchun. ");
INSERT INTO qub_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","Chaypita mastaga noga cajman ama wichämuchunchu. Gam japallayquinami caycashä cajmanga chayamunqui.» ");
INSERT INTO qub_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Moisés cutiycur llapan Israelcunata willaparan Tayta Dios imata nishantapis, laycunata willapashantapis. Chaura runacunaga llapan nipäcuran: «Tayta Dios nishancunataga llapantami cumlishäcuna» nir. ");
INSERT INTO qub_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Chaymi Moisesga Tayta Dios nishanta llapanta isquirbiran. Warannenga tutalla jatarishpan punta chaquincho altarta pergaran. Nircur chunca ishcay (12) wancata ichichiran. Chay wancacunaga caran chunca ishcay (12) Israel trïbucunapa ruquinmi. ");
INSERT INTO qub_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Nircur Israel mösucunawan pishtachiran törucunata rupachina sacrifisyupaj, alli goyaypita sacrifisyupäpis. ");
INSERT INTO qub_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Pishtashan töru-mallwapa pullan caj yawarninta Moisés chariran angaracunawan. Pullan cajwanna altarta chajchuran. ");
INSERT INTO qub_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Chaypitaga conträtuta rurar isquirbishan libruta liguiparan llapan runacunata. Chaura runacunanami niran: «Tayta Dios nishancunataga llapantami wiyacushaj, cumlishaj» nir. ");
INSERT INTO qub_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Chayno aunircuptinnami Moisesga angarawan charishan yawarta chajchuran runacunapa jananpa. Chajchur cayno niran: «Cay yawarga Tayta Dios gamcunawan conträtu rurashanta yarpänayquipämi, llapan willapäshushayquitapis cumlinayquipämi.» ");
INSERT INTO qub_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Chaypita Moisesga puntapa aywaran Aaronwan, Nadabwan, Abiüwan ganchis chunca (70) mayur Israelcunawan. ");
INSERT INTO qub_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","Chaychömi mayurcunaga ricaran Israelcuna yäracushan Tayta Diosta. Lluchcarashanga zafiro rumipita rurashano chip-chipyaycaj caycaran. Colorninpis syëlunöraj caran. ");
INSERT INTO qub_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Tayta Diosta ricaycarpis mayur runacunaga manami wañuranchu. Paycunaga chaycho micuran upuran. ");
INSERT INTO qub_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Tayta Diosga Moisesta niran: «Quiquin puntaman wicharcur shuyämanqui. Nogami entregashayquipaj läja rumicunacho isquirbishäta. Chaychömi isquirbiraycanga Israelcunata yachachinayquipaj caj laycuna, mandamintucuna.» ");
INSERT INTO qub_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Chaymi Moisesga yanapajnin Josuëwan wicharan Tayta Dios caycashan puntaman. ");
INSERT INTO qub_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","Israel mayurcunata niran: «Cutimunäcama cayllacho shuyarpaycämay. Gamcunawanmi quëdaycan Aaronwan Hur. Imapis captenga paycunata willanqui arriglashunayquipaj.» ");
INSERT INTO qub_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Chayno nircur Moisés puntaman wichaycaptin puntata pucutay chapacurcuran. ");
INSERT INTO qub_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","Sojta junaj intëru chay puntallacho pucutayga puñuräcuran. Chay Sinaí puntapitami Tayta Dios munayniyoj cashanpis ricacämuran. Warannin ganchis junajcho Tayta Diosga pucutay rurinpita Moisesta gayamuran. ");
INSERT INTO qub_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","Tayta Dios munayniyoj car achicyashanta ricaptin Israelcunapäga caycaran quiquin puntata nina rupaycajnöraj. ");
INSERT INTO qub_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Tayta Dios gayamuptinmi Moisés puntaman sïguir wichar pucutay rurinman yaycuran. Chaychömi goyaran chuscu chunca junaj chuscu chunca (40) pagas. ");
INSERT INTO qub_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","Sinaí jircacho Tayta Diosga Moisesta cayno niran: ");
INSERT INTO qub_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","«Israelcunata willay nogapaj ofrendata apamunanpaj. Ofrendata churayta munaj cäga llapan shongunpa churachun. ");
INSERT INTO qub_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","Chasquinqui gorita, guellayta, cubrita, ");
INSERT INTO qub_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","jïlucunatana muräduta, aurörata, pucata, lïnupita fïnu jïluta, cabrapa ajchanta, ");
INSERT INTO qub_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","uyshacunapa garachanta pucaman tiñishata, fïnu garacunata, acacia gueruta, ");
INSERT INTO qub_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","candilëru ratananpaj asëtita, alli asyaj jachacunata acrashpan alli asyaj asëtita wiñananman, alli asyaj insinsuman tacuchinanpaj, ");
INSERT INTO qub_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","ónice rumicunata, chayno mas cuyayllapaj rumicunatapis mas mandaj cürapa pichëranman lagapänanpaj, efodman adurnananpäpis. ");
INSERT INTO qub_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","«Chay ofrenda churashancunawan wasi-nirajta nogapaj ruranqui. Chaynöpami gamcuna tiyashayquicho imaypis tiyashäpaj. ");
INSERT INTO qub_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Chay tiyanä Tolduta, chaycho cananpaj caj cösacunatapis ruranqui ricachinäpaj caycajtanölla. ");
INSERT INTO qub_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","«Acacia guerupita ruray juc babulta. Largun canga juc metru chunca sentïmetrun. Anchun canga sojta chunca pichgan (65) sentïmetru. Altuyninpis canga sojta chunca pichgan (65) sentïmetru. ");
INSERT INTO qub_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","Rurinpa jananpa goriwan chapyanqui. Chayno intëru cantunpapis goripita capchi-capchi ribëtita churapanqui. ");
INSERT INTO qub_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","Goripita ruranqui chuscu arguyllata babulpa chuscun chaquin isquïnacunaman churanayquipaj. Churanqui ishcayta jucaj-lädunman, ishcayta jucaj-lädunman. ");
INSERT INTO qub_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","Chay babulta wintunanpaj acacia guerupita ishcay largu gueruta camarinqui. Chay camarishayqui guerucunata goriwan chapyanqui. ");
INSERT INTO qub_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","Nircur chay guerucunataga babulman churashayqui arguyllapa uchcunpa päsachinqui chaypita wintunanpaj. ");
INSERT INTO qub_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","Chay churashayqui gueruga jinallanchöna jatiräconga. ");
INSERT INTO qub_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","Chay babulmanga churanquipaj entreganäpaj caycaj laycunatami. ");
INSERT INTO qub_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","«Chapananta ruranqui gori-pürullapita. Largun canga juc metru chunca sentïmetrun. Anchun canga sojta chunca pichgan (65) sentïmetru. ");
INSERT INTO qub_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","Ishcay querubín anjilcunata rurarcur chapanapa ishcan cantunman churanqui. Chay canga gorita martilluwan tacayllapa rurasha. ");
INSERT INTO qub_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","Chapananwan chay querubín anjilcunaga canga juc pïsalla. Jucaj querubín anjil caycanga jucaj cantuncho, jucajna jucaj cantuncho. ");
INSERT INTO qub_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","Wac-lä cay-lä ishcanpis caycanga ñaupanman älancuna quichasha. Ishcanpis ricarpaycanga chapanallanman. Chaura älancunaga chapana jananpa quichasha caycanga. ");
INSERT INTO qub_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","Babul rurinman churanqui entreganäpaj caycaj laycunata. Nircur chapananwan chaparcunqui. ");
INSERT INTO qub_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","Gamwan tincorga conträtu babulpa chapanan janancho ishcay querubín anjilcuna caycashan chaupinpitami willashayqui Israel runacunata imata ninayquipaj cashantapis. ");
INSERT INTO qub_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","«Acacia guerupita ruranqui mësata. Largun canga isgun chunca (90) sentïmetru. Anchun canga chuscu chunca pichgan (45) sentïmetru. Altuynin canga sojta chunca pichgan (65) sentïmetru. ");
INSERT INTO qub_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","Intërunta goriwan chapyanqui. Intëru cantunpapis goripita capchi-capchi ribëtita churapanqui. ");
INSERT INTO qub_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","Chay mësapa cantullanpa churapanqui ganchis sentïmetru altuta intërunpa tumarejta. Chaymanpis goripita capchi-capchi rurasha ribëtita churapanqui intërunpa tumarej. ");
INSERT INTO qub_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","Goripita ruranqui chuscu arguyllata. Chay arguyllata churanqui chuscu isquïnanman. ");
INSERT INTO qub_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","Chaura chay arguylla caycanga chaquin tanaraycashan läduncho. Chay arguyllacunapanami päsaranga mësata wintunanpaj rurashan gueru. ");
INSERT INTO qub_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","Mësata wintunanpaj guerucunataga ruranqui acacia guerupita. Intëru jananpana goriwan chapanqui. ");
INSERT INTO qub_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","Goripita ruranqui lätucunata, wishllacunata, jatun wichicunata, cöpacunatapis chaywan altarman bïnuta wiñapänanpaj. ");
INSERT INTO qub_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","Ñaupächo caycaj mësamanga imaypis nogapaj tantata churanqui. ");
INSERT INTO qub_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","«Martilluwan tacayllapa rurachinqui goripita candilëruta. Jamanan, ichirajnin, cöpancuna, mogunno caycajcuna, waytapa uman-nirajcunapis canga juc pïsalla. ");
INSERT INTO qub_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","Chay candilëru canga sojta callapayoj, quimsa jucaj-lädunpita, quimsana jucaj-lädunpita. ");
INSERT INTO qub_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","Cada callapa aywajcho canga quimsa mogucuna almendropa waytan pashtaycaj-niraj. Chaynölla canga sojtan callapacho. ");
INSERT INTO qub_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","Jamananpita chaupi aywaj ichirajninchöna canga chuscu mogucuna wayta pashtaraycajno. ");
INSERT INTO qub_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","Chay mogucunaga cada callapancuna tincurajpa chaquincho canga. Chaynöpami cada lädunpa quimsa callapacuna canga candilërupa sojta callapan cananpaj. ");
INSERT INTO qub_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","Chay wayta pashtaraycaj moguncunaga canga jinallanpita martilluwan tacaypa rurasha. ");
INSERT INTO qub_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","Ganchis tübu-nirajcunata ruranqui candilërupa puntanman churanayquipaj. Chaycunata camacächinqui ñaupallaman achquënanpaj. ");
INSERT INTO qub_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","Tinäsuncunapis, llipta shuntacunan lätu-mallwancunapis canga gorillapita. ");
INSERT INTO qub_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","Candilërutaga llapan cösancunatawan ruranqui quimsa chunca quimsan (33) quïlu goripita. ");
INSERT INTO qub_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","Chaytaga ruranqui cay puntacho ricaycächishä-nirajta. ");
INSERT INTO qub_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","«Tiyanä Tolduta ruranqui chunca tëlapita. Chayta awanqui caupusha fïnu lïnu jïlupita, muräduman, auröraman, pucaman tiñishata. Chay jananman burdanqui cuyayllapaj querubín anjilcunata. ");
INSERT INTO qub_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","Tëlacunapaga cada-ünunpa larguynin canga chunca ishcay (12) metru medyan, anchuyninna ishcay metru. ");
INSERT INTO qub_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Pichga tëlacunata pësanqui jucnayllano cananpaj. Yapay pichga cajtapis pësanqui jucnayllano cananpaj. ");
INSERT INTO qub_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","Pësashayquipa largu caj cantunman ujalcunata jiranqui murädu tëlapita. Jucaj-lädun largu cajpa cantunmanpis chayno jiranqui. ");
INSERT INTO qub_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","Rimir caj jirachishayquiman churanqui pichga chunca (50) ujalcunata; guepa caj jirachishayquimanpis pichga chunca (50) ujalcunata. Chaura jucaj tëlapa ujalnincunaga jucaj tëlapa ujalnincunawan tincunacusha caycanga shinrichinanpaj. ");
INSERT INTO qub_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","Chayno goripita rurachinqui pichga chunca (50) ticpinöcunatapis tëlaman jirachishayqui ujalcunapita ishcanta shinrichinayquipaj. Chaynöpami juc pïsanölla chaparaycanga chay Tolduga. ");
INSERT INTO qub_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","«Cabrapa ajchanpitapis awanqui chunca juc bayëtacunata. Chay bayëtacunawan gatanqui Toldu jananpa. ");
INSERT INTO qub_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","Chay bayëtacunapaga cada-ünunpa larguynin canga chunca quimsa metru medyan (13.5), anchuyninna ishcay metru. ");
INSERT INTO qub_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","Nircurnami pichga caj bayëtacunata largun cajpa jiranqui jucnayllano cananpaj. Chayno sojta cajcunatapis largun cajpa jiranqui jucnayllano cananpaj. Sojta caj jirashayqui bayëtaga canga puncu yaycunacho päsaränanpaj. Chay päsaraj cajtaga jananman doblanqui. ");
INSERT INTO qub_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","«Pësasha caycaj bayëtacuna tincuränanpa jucaj cantunman pichga chunca ujalcunata jiranqui. Yapay jucaj cajpa tincuränanpaj caj cantunmanpis pichga chunca ujalcunata jiranqui. ");
INSERT INTO qub_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","Chayno runsipita ruranqui pichga chunca (50) ticpinöcunatapis bayëtaman jirashayqui ujalcunata shinrinayquipaj. Chaynöpami juc pïsanölla canga. ");
INSERT INTO qub_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","Toldu guepanpa puchurächun pullan metru. Chay guepanpa päsar puchoj cäga pampacho mashtaranga. ");
INSERT INTO qub_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","Chayno toldupa ishcan-läpapis puchuranga pullan metrucama. Chay puchoj cäga waguiranga ruricho gatasha cajta chaparänanpaj. ");
INSERT INTO qub_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","«Mas jananpapis uyshapa garachan pucaman tiñishawan gatanqui. Mas jananpana chapanqui fïnu garacunawan. ");
INSERT INTO qub_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","«Tolduta ichichinayquipäga marcuncunata ruranqui acacia guerupita. ");
INSERT INTO qub_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","Cada marcupa larguynin canga chuscu metru medyan. Anchuyninna canga sojta chunca pichga (65) sentïmetru. ");
INSERT INTO qub_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","Cada marcupa ishcay chaquincunatapis ruranqui. Chaynölla ruranqui llapan marcucunapaj. ");
INSERT INTO qub_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","Sur caj-läduncho ichichinayquipaj ruranqui ishcay chunca (20) marcucunata. ");
INSERT INTO qub_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","Chay ishcay chunca marcucuna (20) ichiränanpaj guellaypita ruranqui chuscu chunca (40) jamanancunata. Chaura cada marcu jamaraycanga guellaypita ishcay jamanacho. ");
INSERT INTO qub_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","«Norte caj-lädunpäpis ruranqui ishcay chunca (20) marcucunata. ");
INSERT INTO qub_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","Chay caj-läpäpis guellaypita ruranqui chuscu chunca (40) jamanancunata. Chaura cada marcu jamaraycanga guellaypita ishcay jamanacho. ");
INSERT INTO qub_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","Guepan caj-läpäpis ruranqui sojta marcucunata. Chayta ichichinqui inti yaganan caj-läman. ");
INSERT INTO qub_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","Chay guepancho ishcan isquïnancunapaj ruranqui mas ishcay marcuta. ");
INSERT INTO qub_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","Chay marcucunaga isquïnacunacho canga isquïnayoj cananpaj doblasha. Janaj ushajninchöna arguyllawan chariraycanga. Jucaj isquïnachöpis jucaj isquïnachönölla ruranqui. ");
INSERT INTO qub_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","Chaura llapanga canga pusaj marcucuna, cada ünun ishcay jamanancunawan-cama. Llapanpäga canga guellaypita chunca sojta (16) jamacunana. ");
INSERT INTO qub_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","29","«Tolduta quinranpa chacaraj guerucunatapis acacia guerupita ruranqui chunca pichgata (15). Chaycunaga pichga canga jucaj-lädunpa ichiraj marcucunata chariränanpaj. Yapay pichgana canga jucaj-lädunpa ichiraj marcucunata chariränanpaj. Yapay pichga cajna canga guepanpa ichiraj marcucunata chariränanpaj. Chay quinranpa chacaj guerucunataga goriwan chapyanqui. Marcucunatapis goriwan chapanqui. Arguyllacunatapis goripita ruranqui quinranpa chacaraj guerucuna chaypa päsaränanpaj. Marcupa pullan chaupinpa chacaraj gueruga juc cantupita juc cantucama päsaranga. ");
INSERT INTO qub_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","«Chay Toldutaga ruranqui puntacho ricachishätano. ");
INSERT INTO qub_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","«Toldu ruricho raquir chaparänanpaj tëlata awanqui caupusha fïnu lïnu jïlupita, muräduman, auröraman, pucaman tiñisha jïlupita. Chay jananman burdachinqui cuyayllapaj querubín anjilcunata. ");
INSERT INTO qub_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","Acacia guerupita chuscu tushacunata ruranqui. Chaytaga goriwan chapanqui. Jamanancunana canga guellaypita. Tushacunapa puntanman churanqui goripita arguyllata chaypita tëlacunata warcunayquipaj. ");
INSERT INTO qub_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","Nircur Tolduta gatananpaj ticpinöcunawan shinrishan rurincho tëlataga waguinqui. Chauraga chay tëla raquenga ishcay cuartuman. Ruri caj canga Mas Rispitädu cuartu, jawaman cajna Rispitädu cuartu. Mas Rispitädu cuartuman churanqui laycuna churaraycashan babulta. ");
INSERT INTO qub_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","Nircur chay babulta chapananwan chaparcunqui. ");
INSERT INTO qub_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","Tantapaj caycaj mësatana churanqui Rispitädu cuartucho jucaj-läduman. Candilërutapis churanqui mësapa wash'ganman. Chaura mësawan candilëruga wac-lä cay-lä caycanga. ");
INSERT INTO qub_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","«Tolduman yaycuna puncunpäna ruranqui caupusha fïnu lïnu jïlupita, muräduman, auröraman, pucaman tiñishapita. Chay jananman cuyayllapaj camarajta burdachinqui. ");
INSERT INTO qub_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","Acacia guerupita pichga tushacunata ruranqui. Chaytaga goriwan chapyanqui. Pichga jamanancunapis canga runsipita. Tushacunapa puntanman churanqui goripita arguyllata chay awashayqui tëlacunata warcunayquipaj. ");
INSERT INTO qub_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","«Altarta ruranqui chuscu isquïnayojta, acacia guerupita. Cada lädunpa larguynin canga ishcay metru ishcay chunca picha sentïmetrun. Altuyninpis canga juc metru ishcay chunca pichga sentïmetrun. ");
INSERT INTO qub_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","Chuscun isquïnancho wagratano ruranqui. Chaycuna canga llagllaypa rurasha quiquin altarwanga chay aywarajlla. Nircur intërunpa runsiwan chapyanqui. ");
INSERT INTO qub_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","Uchpa shuntacunantapis, uchpa chagacunantapis, tasunnincunatapis, rinchincunatapis, wichincunatapis ruranqui. Chaycunaga llapanpis runsipita rurashalla canga. ");
INSERT INTO qub_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","Chayno rëjasnincunatapis mällatano runsipita ruranqui. Cada isquïnancunapita chariränanpäpis runsipita ruranqui arguyllacunata. ");
INSERT INTO qub_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","Nircur rëjastaga churanqui altarpa shimin chaquinman. Chaura chay rëjasga altarpa pullannincho caycanga. ");
INSERT INTO qub_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","Altarpa wintucunantapis acacia guerupita ruranqui. Chaycunataga intërunta runsiwan chapyanqui. ");
INSERT INTO qub_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","Chay guerucunata ishcan-lächo rëjasta chariraycaj arguyllapa uchcunpa päsachinqui chaypita wintunanpaj. ");
INSERT INTO qub_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Chay altarga canga puntacho ricachishänömi tablapita rurasha alayri uchcu mancaraycajlla. ");
INSERT INTO qub_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","«Tolduga sawanniyoj cachun. Chay sawan intëru cantunpana fïnu lïnu tëlawan guenchanqui. Jucaj-lädunpa larguynin canga chuscu chunca sojta metrun. Chay caj canga sur caj-läpami. ");
INSERT INTO qub_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","11","Norte caj-läpapis larguynin canga chuscu chunca sojta metrun. Chaycunapäga cada lädunpaj canga ishcay chunca tushacuna. Chay tushacunapana runsipita jamanancuna cada lädunpaj canga ishcay chunca. Aushincunapis, arguyllancunapis guellaypita canga. ");
INSERT INTO qub_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","«Guepan caj-läpa anchuynin canga ishcay chunca quimsa metrun. Chaypapis fïnu lïnu tëlawan guenchanqui. Chaychöga canga chunca tushacuna, chunca jamacunancuna. ");
INSERT INTO qub_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","Puncunpis inti yagamunan caj-läpa ricaraycanga. Chaypapis anchuynin canga ishcay chunca quimsa metrun. ");
INSERT INTO qub_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","Chay läduchömi canga puncu. Puncupita jucaj läduman canga ganchis metrun. Chaycho canga quimsa tushacuna quimsa jamanancuna. ");
INSERT INTO qub_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","Puncupita jucaj-läduman cajpis canga ganchis metru. Chaychöpis canga quimsa tushacuna quimsa jamanancuna. ");
INSERT INTO qub_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","«Quiquin sawan puncu yaycunapa anchuynin canga isgun metru. Chaypaj awanqui caupusha fïnu lïnu jïlupita, muräduman, auröraman, pucaman tiñishapita. Chayga cuyayllapaj burdasha canga. Chaypäga canga chuscu tushacuna jamanancunawan-cama. ");
INSERT INTO qub_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","Intëru cantunpa tumariraj tushacunapaga arguyllancuna, aushincuna canga guellaypita. Jamanancunana canga runsipita. ");
INSERT INTO qub_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","Chay guencharaycaj sawan pampaga canga chuscu chunca sojta metru larguynin, ishcay chunca quimsa metru anchuynin. Chay guenchapa altuyninna canga ishcay metru ishcay chunca pichga sentïmetrun. Guencharänanpaj caj tëlaga canga fïnu lïnupita. Ichiraj guerucunapaga jamanancunapis canga runsipita. ");
INSERT INTO qub_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","Tolduta chariraj istägancunapis, Toldupa sawanninpa guenchanta chariraj istägancunapis, waquin cösacunapis runsillapita canga. ");
INSERT INTO qub_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","«Israelcunata willapay candilëru imaypis rataycänanpaj olivota gapchishan chuya caj asëtita apamunanpaj. ");
INSERT INTO qub_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","Aaronnami wamrancunawan camacächenga achquicuna ñaupächo warayllata ratananpaj. Tiyanä Tolducho babulta tëla chaparaycashanpita jawaman caj cuartucho rataycanga. Chay nishä laycunaga imaycamapis canga Israelcunapaj, paycunapita mirar aywajcunapäpis. ");
INSERT INTO qub_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","«Israelcunapita wauguiqui Aaronta acray sirbimaj cüra cananpaj. Chayno acray wamrancunatapis: Nadabta, Abiüta, Eleazarta, Itamarta cüräcuna cananpaj. ");
INSERT INTO qub_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","Wauguiqui Aarón rispitädu cüra cashpan jaticunanpaj rurachinqui cuyayllapaj camarajlla röpata. ");
INSERT INTO qub_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","Chayta imano rurananpäpis sumaj willapanqui rurayta yachananpaj yarpayta goshä runacunata. Chay rurashan röpata jaticuptin llapanmi musyanga Aarón acrasha cürä cashanta. ");
INSERT INTO qub_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","Rurachinqui: pectoralta, efodta, cuyayllapaj burdasha sotänanta, cuyayllapaj burdasha päsaypa largu röpata, shucullpinta, labur wachcutapis. Chay röpacunataga rurachinqui wauguiqui Aaronpaj, wamrancunapäpis acrashä cüracuna car sirbimänanpaj. ");
INSERT INTO qub_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","Chaycunataga awanga goriwan talluchiypa, caupusha fïnu lïnu jïluwan, muräduman, auröraman, pucaman tiñisha jïluwan. ");
INSERT INTO qub_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","«Efodta rurachinqui goriwan, caupusha jïlupita rurasha fïnu lïnu jïluwan, muräduman, auröraman, pucaman tiñisha jïlucunawan. Chaycunataga yachaj runacuna awanga. ");
INSERT INTO qub_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","Efodga canga ishcay tëla. Ishcanpa puntancho canga umrunpa shawatarar chaycunapita watacunanpaj. ");
INSERT INTO qub_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","Efodwan juc pësallami canga wachconga. Chay wachcuga canga gorinpawan caupusha jïlupita rurasha fïnu lïnu tëlawan, muräduman, auröraman, pucaman tiñisha tëlacunawan awasha. ");
INSERT INTO qub_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","«Nircorga achicyaycachaycaj ishcay ónice rumicunaman isquirbinqui Israelpa wamrancunapa jutincunata. ");
INSERT INTO qub_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","Chay jutincunataga isquirbinqui mayurpita gallaycur shullcacama. Jucaj rumiman isquirbinqui sojtata. Yapay jucaj rumimanna isquirbinqui sojta cajta. ");
INSERT INTO qub_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","Chay rumicunaman juticunataga isquirbenga aläja ruray yachajmi. Sëlluta rurashanno ruranga. Chay rumitana churanqui goripita cañichicuna caycajman. ");
INSERT INTO qub_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","Nircur chayta churanqui efod ishcan-lä umrunpa päsaränan cajman. Chaynöpami Aarón ñaupäman shamushpan juticuna isquirbiraycaj rumicunata apamonga. Chaycuna canga Israelpita mirajcunata noga yarpänäpämi. ");
INSERT INTO qub_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","Cañichicunataga goripita rurachinqui. ");
INSERT INTO qub_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","Nircur pilltaypa ishcay curduncunatapis goripita rurachinqui. Chaycunataga efodpa umruncho caycaj cañichicunaman charichinqui. ");
INSERT INTO qub_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","«Cüra pëchunman churacunan pectoral canga imano camacächishätapis cüra musyananpaj. Chaytapis rurachinqui efodta rurachishayquino goriwan, caupusha jïlupita fïnu lïnu tëlawan awashapita, muräduman, auröraman, pucaman tiñisha tëlanpawan. Chaycunataga yachaj runacuna ruranga. ");
INSERT INTO qub_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","Rurarcachir doblanqui bolsano chuscu isquïnayojta, cuarta largun, cuarta anchuyojta. ");
INSERT INTO qub_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","Jananman lagachinqui cuyayllapaj rumicunata chuscu fïlata. Rimir caj fïlacho caycanga cayno jutiyoj rumicuna: sárdica, topacio, carbunclo. ");
INSERT INTO qub_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","Ur'gan fïlacho canga: esmeralda, zafiro, diamante. ");
INSERT INTO qub_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","Mas ur'gan fïlacho canga: jacinto, ágata, amatista. ");
INSERT INTO qub_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","Ushanan caj fïlacho canga: berilo, ónice, jaspe. Chaycunaga llapanpis carcaycanga goripita rurasha caycaj cañichicunacho. ");
INSERT INTO qub_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","Chay rumicunachöga caycanga chunca ishcay Israel trïbucunapa jutincunami. Cada ünunpa jutincunami juc rumicho-cama caycanga. Sëlluta rurajno rurashami jutenga caycanga. ");
INSERT INTO qub_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","«Pectoralpaj rurachinqui curduntano goripita pilltaypa. ");
INSERT INTO qub_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","Chay pectoralcho goripita rurachinqui ishcay arguylla-mallwacunata. Chaycunaga caycanga pectoralpa jana caj ishcan-lä isquïnancunacho. ");
INSERT INTO qub_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","Ishcan gori curduncunatana charichinqui pectoralpa ishcan-lä isquïnancho arguylla caycajman. ");
INSERT INTO qub_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","Chay curduncunapa jucaj puntancunatana charichinqui cañichicunata rurashayqui efodpa umrunman. ");
INSERT INTO qub_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","Yapay goripita rurachinqui ishcay arguylla-mallwacunata. Nircur chaycunata churanqui pectoralpa ura caj ishcan-lä puntan rurinman. ");
INSERT INTO qub_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","Yapay goripita ruranqui ishcay arguylla-mallwata. Nircur churanqui efodpa ñaupan caj-läpa wachcu aywanan ñaupanman. ");
INSERT INTO qub_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","Chaura pectoralcho ishcay arguylla-mallwacuna caycajpita auröra curdunwan watanqui efodpa ishcan läduncho arguylla caycajman. Chaynöpami pectoralga efodpita mana yargongachu. ");
INSERT INTO qub_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","«Chaynöpami pëchuncho pectoralta jatisha aywar Aaronga Israel trïbucunapa jutincunata purichenga ñaupäman yaycamuptin paycunata yarpänäpaj. ");
INSERT INTO qub_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","Chay pectoralman churanqui Urimta Tumimtapis. Chaura ñaupäman yaycamushpan Aaronga pëchuncho charaycanga imano camacächishätapis musyananpaj. ");
INSERT INTO qub_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","«Efodpa rurincho jaticunan sotänanta rurachinqui murädu tëlapita. ");
INSERT INTO qub_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","Pullan chaupincho uman yaycunanpaj uchcuyojta rurachinqui. Chay uchcu sinchi cananpaj awaypa awasha canga ribëtino mana rachinanpaj. ");
INSERT INTO qub_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","Auröra tëlapita, murädu tëlapita, puca tëlapita rurachinqui wallwacunata purupuru-nirajta. Sotänan ura puntanpa intëru tumarejpa churachinqui wallwacunatawan gori campanillata talluchiypa. ");
INSERT INTO qub_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","Churachinqui juc wallwata, juc gori campanillata, yapay juc wallwata yapay juc gori campanillata sotänan puntanpa intërun tumarej. ");
INSERT INTO qub_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","Aaronga cüra cayninta cumlej Rispitädu cuartuman yayconga chay sotänan jatishami. Yaycuptin, llojshimuptinpis chay campanillacuna wiyacanga Aarón mana wañunanpaj. ");
INSERT INTO qub_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","«Vinchatano goripita rurachinqui llapchallata. Chayman sëlluta rurashanno isquirbichinqui. Chaychöga ‹Tayta Diospajacrasha car santo› nirmi isquirbiranga. ");
INSERT INTO qub_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","Chay vinchano caycajtaga auröra curdunwan charircachir Aarón wataconga urcunman, shucullpin jananman. ");
INSERT INTO qub_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","Chaynöpami Aaronpa urcuncho caycanga. Maygan Israel runapis aduraycämashancho juchata aparicuptenga Aaronllanami juchata aparicushano caycanga. Chay vincha-niräga Aaronpa urcuncho wataraycanga jucha rurajcunata juchanpita perdunanäpaj. ");
INSERT INTO qub_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","«Fïnu lïnupita rurachinqui päsaypa largu röpata. Chayno fïnu lïnullapita awachinqui shucullpinta, labur wachcutapis. Awarcur wachcumanga cuyayllapäcunata burdanga. ");
INSERT INTO qub_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","Aaronpa wamrancunapaj rurachinqui päsaypa largu röpacunata, labur wachcuncunata, shucullpincunata, chayta jaticur camaränanpaj, rispitädu cananpaj. ");
INSERT INTO qub_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","«Chaycunata rurarcachir wauguiqui Aaronta wamrancunatawan jatipanqui. Nircur umanman asëtita wiñapanqui acracushäcuna cananpaj, cüräcunana cananpaj. Shuyni raquinqui cüräcuna cashpan sirbimänanpaj. ");
INSERT INTO qub_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","«Chayno awachipanqui ajüruntapis chegllanpita gongurnincamalla fïnu lïnu tëlapita, pengayninta chapananpaj. ");
INSERT INTO qub_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","Tolduman yaycunanpaj Aaronpis wamrancunapis jaticonga chay ajürucunata. Rispitädu cuartucho altarman sirbimaj aywashpanpis jatisha yayconga. Ajüruta jaticöni yaycoj cäga juchata aparicushpan wañongami. Chay nishäcunaga imaycamapis laymi canga Aaronpaj y paypita mirajcunapäpis. ");
INSERT INTO qub_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","«Sirbimaj cüracuna cananpaj churashpayqui cayno ruranqui: Acranqui sänu töru-mallwata, ishcay sänu carnitapis. ");
INSERT INTO qub_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","Lebadüraynaj tantata ruranqui. Lebadüraynaj tortatapis ruranqui asëtiwan chapushallata. Lebadüraynaj llapsha tantacunatapis ruranqui jananpa asëtiwan pichushallata. Chaycunataga ruranqui alli caj jarinapita. ");
INSERT INTO qub_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","Chaycunata camarinqui canastaman. Nircur Tincuna Tolduman garamänayquipaj apamunqui acrashayqui uywacunatawan iwal. ");
INSERT INTO qub_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","Chayno pushamunqui Aaronta wamrancunatawan Toldu puncuman. Chaychönami purificashpayqui paycunataga bäñanqui. ");
INSERT INTO qub_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","Nircur Aaronta jatipanqui rurachishayqui päsaypa rurasha largu röpata, sotänata, efodta, pectoraltapis. Nircur efodpa wachcunwan chegllanpa watapanqui. ");
INSERT INTO qub_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","Umanman jatipanqui shucullpinta. Chay shucullpinpa jananmanna urcunman watapanqui isquirbiraycaj gori vincha-nirajta. ");
INSERT INTO qub_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","Chayno jatiparcur acrar wiñapäna asëtita Aaronpa umanman wiñapanqui nogapaj acrashana cananpaj. ");
INSERT INTO qub_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","Nircur wamrancunatapis ñaupayquiman gayanqui. Witimuptinna päsaypa rurasha largu röpata jatipanqui. ");
INSERT INTO qub_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","Aarontano wamrancunatapis wachcuwan chegllanpa watapanqui. Shucullpintapis jatipanqui. Chaynömi paycunataga cüräcuna cananpaj churanqui. Cananpitaga Aaronpita mirajcunallanami imaycamapis cürä canga. ");
INSERT INTO qub_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","«Nircur töru-mallwata apanqui Toldu puncuman. Aaronna wamrancunawan chay uywapa uman jananman maquincunata churanga. ");
INSERT INTO qub_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","Nircur chay töru-mallwataga nogapa ñaupächo Toldu puncucho pishtanqui. ");
INSERT INTO qub_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","Yawarninman dëduyquita töparcachir pichunqui altarpa wagrancunata. Waquin caj yawarnintana tallinqui altar chaquinman. ");
INSERT INTO qub_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","Pacha wirancunata, ñatinpa puntanta, ishcan rurunta wirantinta jorgurcur altarcho rupachinqui. ");
INSERT INTO qub_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","Aychanta, garanta, ashashnincunata, chay tiyaycashayquicunapita juc-läman jorguycur rupachinqui juchapita perdunasha cananpaj ofrenda captin. ");
INSERT INTO qub_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","«Jucaj carnipa umanmanpis Aaronwan wamrancuna maquincunata churanga. ");
INSERT INTO qub_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","Chayno rurarcur pishtanqui. Nircur yawarninwan chajchunqui chay altarta intëru cantunpa. ");
INSERT INTO qub_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","Aychantana cuartisanqui. Pachancunata macshuncunatawan mayllanqui. Mayllarcur churanqui cuartisashayqui aychawan uman altarcho churaraycashanman. ");
INSERT INTO qub_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","Nircur chay uysha aychataga chay altarcho rupachinqui. Rupachishayquipa jömuynin nogapäga shongöpäno canga. Chayga canga rupachina sacrifisyumi. ");
INSERT INTO qub_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","«Nircorga jucaj carnipa uman jananmanna Aaronwan wamrancuna maquinta churanga. ");
INSERT INTO qub_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","Chayno rurarcuptin pishtanqui. Yawarnintana wallcallata charircur Aaronpa wamrancunapa derëchu caj rinrinpa llapllanman, derëchu caj maquinpa maman dëdunman, derëchu caj chaquinpa maman dëdunmanpis pichupanqui. Puchoj caj yawarwanna altarpa intëru cantunpa chajchupanqui. ");
INSERT INTO qub_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","Altar janancho yawar caycajtawan acrar wiñapäna asëtitana Aaronta, röpanta chajchupanqui. Chayno ruranqui wamrancunatapis, röpantinta. Chaynöpami Aaronpis wamrancunapis sirbimänanpaj acrasha canga. Röpacunapis sirbimar jaticunanpaj acrasha canga. ");
INSERT INTO qub_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","«Cürata churar pishtashayqui uyshapataga jorgunqui chupa wiranta, pacha wiranta, ñatinpa puntanta, ishcan rurunta wirantinta, derëchu caj chancantapis. ");
INSERT INTO qub_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","Nogapa ñaupächo caycaj canastapita jorgunqui jucta-cama lebadüraynaj rurashayqui tantata, asëtiwan chapuyllapa rurashayqui tortata, lebadüraynajta rurashayqui llapsha tantatapis. ");
INSERT INTO qub_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","Chayno jorgurcur churapay Aaronpa maquinman, wamrancunapa maquinmanpis. Chaycunata cuyuchir ricachimashpan ‹Cay gampämi› nimanga. ");
INSERT INTO qub_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","Chayno rurarcuptin chay jogarishan tantacunata maquinpita shuntanqui. Nircorga jucaj carnita rupachishayquinölla chaycunatapis altarcho rupachinqui. Chay rupachishayquipa jömuynin nogapäga shongöpäno canga. ");
INSERT INTO qub_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","«Aaronta cüra cananpaj churar pishtashayqui uyshapa pëchuntana cuchurcur ricachipämanqui nogaman. Chay aychaga canga gampämi. ");
INSERT INTO qub_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","Chay cuyuchir ricachimashayqui aychataga shuyni churanqui Aarontawan wamrancunata cüra cananpaj churar jorgushayqui chancan aychatawan iwal. ");
INSERT INTO qub_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","Chayga canga Aaronpaj wamrancunapajwanmi. Alli goyaypita sacrifisyuta Israelcuna garamar raquishan aychataga imay-yajpis cüracunami chasquenga. ");
INSERT INTO qub_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","«Aarón jaticushan rispitädu röpancunaga canga paypita mirajcunapämi. Chaycunataga jaticonga cüräna cananpaj asëtita wiñapasha cashpanrämi. ");
INSERT INTO qub_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","Aaronpa ruquinna cüra car Tolduman sirbimaj yaycur chay röpata jatiranga ganchis junajcama. ");
INSERT INTO qub_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","«Cüra cananpaj churar pishtashayqui uyshapa aychan churashayquitaga yanunqui yanunayquipaj caycaj rispitädu pachacho. ");
INSERT INTO qub_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","Chaytaga canastacho puchoj tanta caycajtawanmi Toldu puncucho miconga Aarón wamrancunawan. ");
INSERT INTO qub_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","Miconga perdunasha cananpaj goycamasha captin, cüra cananpaj churashanpita pishtasha captinmi. Waquin caj runacunaga manami micöshengachu nogapaj churashan ofrenda captin. ");
INSERT INTO qub_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","Tantata ni aychatapis waranninpaj puchoj cajtaga ama pipis micongachu. Chaypa ruquenga rupaycärachinqui nogapaj ofrenda casha captin. ");
INSERT INTO qub_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","«Imanöpis willapashänölla ruranqui Aaronta wamrancunatapis cüra cananpaj churashpayquega. Ganchis junajmi canga cüra churayga. ");
INSERT INTO qub_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","Chay junajcunaga waran-waran juchapita perdunanäpaj töru-mallwata pishtanqui. Altartapis purificanqui. Chayman asëtita wiñanqui nogapäna raquishpayqui. ");
INSERT INTO qub_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Chaynölla waran-waran ganchis junajcama ruranqui. Chaura chay altarga fiyupa rispitäduna canga. Imapis chay altarta töpaj cäga nogapäna canga. ");
INSERT INTO qub_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","«Waran-waranmi ishcay cashnicunata juc watayojta-cama altar janancho rupachinqui. ");
INSERT INTO qub_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","Jucta tutapa rupachinqui. Jucajtana tardi inti yagay öra rupachinqui. ");
INSERT INTO qub_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","Rimir caj carni-mallwatawan iwal rupachinqui ishcay quïlu alli caj jarinata juc litru olivo asëtiwan chapushata. Chay jananman wiñapanqui juc litru bïnutapis. ");
INSERT INTO qub_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","Tutapa cajta rupachishayquinölla rupachinqui tardipa cajtapis: jarinantawan, asëtintawan. Bïnutapis wiñapanqui. Chaycunapa jömuynin nogapäga shongöpäno canga. ");
INSERT INTO qub_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","«Chaynöllami Toldu sawan puncucho nogapaj rupachina sacrifisyuta rupachenga canan caycaj runacunapis, paycunapita mirajcunapis. Chay Tolduchömi nogaga gamwan tincur willapäshayquipaj. ");
INSERT INTO qub_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","Chaychömi tincushäpaj Israel-masiquicunawanpis. Chaycho captëmi Tolduga fiyupa rispitäduna canga. ");
INSERT INTO qub_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","«Toldupis altarpis nogapaj acrasha rispitädu cananpämi camacächishaj. Aarontapis wamrancunatapis acrashaj rispitädu sirbimajnë cananpämi. ");
INSERT INTO qub_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","Nogaga Israelcuna tiyashanchömi caycäshaj. Nogami paycunapa Diosninpis cashaj. ");
INSERT INTO qub_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","Chaynöpami musyanga paycunacho goyänäpaj Egiptupita jorgamoj Tayta Diosnin cashäta. Nogaga Tayta Diosniquimi caycä. ");
INSERT INTO qub_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","«Juc altartapis ruray insinsuta rupachir saumachinayquipaj. Chaytaga ruranqui acacia guerupita. ");
INSERT INTO qub_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","Chuscun isquïnan iwalta ruranqui. Cada lädunpa larguynin canga chuscu chunca pichga (45) sentïmetrun. Chay iwal-lla canga anchuyninpis. Altuyninna canga isgun chunca (90) sentïmetru. Altarpa wagrancunapis altarwan chay pësalla canga. ");
INSERT INTO qub_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","Intëru jananpa goriwan chapyanqui. Wagrancunatapis chayno goriwan chapyanqui. Intëru cantun tumarejpapis goripita juc ribïtitano churapanqui. ");
INSERT INTO qub_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","Cada isquïnanmanna churanqui goripita rurashayqui arguyllacunata. Chaytaga churanqui chaypa gueruta jatircur wintunanpaj. ");
INSERT INTO qub_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","Wintunanpaj guerutapis acacia guerupita ruranqui. Nircur jananpa goriwan chapyanqui. ");
INSERT INTO qub_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","Chay altartaga churanqui mas rispitäduta chaparaycashan tëlapita jawa cajman. Mas rispitäduchöga conträtu babulmi caycanga. Chay babulpa chapanan janancho yurimurmi gamwan tincushunpaj. ");
INSERT INTO qub_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","«Cada tuta candilëruta camarej yaycushpan Aaronga chay altarcho insinsuta rupachir goshtachenga. ");
INSERT INTO qub_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","Yapay pacha chacaptin candilëruman achquita sindinanpaj yaycushpanpis insinsuta rupachir goshtachenga. Chaynöllami nogapa ñaupächo ruraycanga Aaronpis, wamrancunapis, paycunapita mirajcunapis. ");
INSERT INTO qub_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","Chay insinsu rupachicuna altarchöga ama rupachinquichu juc casta insinsuta, pishtashayqui uywapa aychanta, ni chaqui micuy ofrendacunatapis. Ni bïnutapis chaymanga ama wiñanquichu. ");
INSERT INTO qub_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","Aaronga watacho juc cutilla insinsuta rupachina altarpa wagranman yawarta pichonga. Chay yawarga canga juchapita perdunanäpaj pishtashan uywapa yawarninmi. Chaynöllami juchacunapita perdunanäpaj cada watacho ruranga Aarón, Aaronpa ruquin cajpis, mas ruquin cajcunapis. Chay altarga canga fiyupa rispitädumi.» ");
INSERT INTO qub_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","Tayta Diosga mastapis Moisesta niran: ");
INSERT INTO qub_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","«Israelcunata sinsuptiqui cada Israel runami cawananpaj pägunta gomanga sinsucushanpita ima fiyu gueshyawanpis mana wañunanpaj. ");
INSERT INTO qub_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","Sinsucusha caj runacunaga cada-ünunmi pägamanga pichga grämu guellayta. Chaytaga pësanga Tolducho caj pësacunawanmi. ");
INSERT INTO qub_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Ishcay chunca (20) watayojpita janaman sinsucoj cäga llapanmi ofrendanta churanga. ");
INSERT INTO qub_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","Cawananpaj pägunta churajcunaga pipis iwalmi päganga. Rïcupis manami mastaga pägangachu. Ni pobripis mas wallcataga manami pägangachu. ");
INSERT INTO qub_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","Chaynöpami Israelcuna mana wañunanpaj pägashan guellayta shuntanqui. Nircur chay guellayta gonqui Tolducho gastucunapaj. Chayta ricashpämi mana wañunanpaj ofrendanta churashanta yarpäshaj.» ");
INSERT INTO qub_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","Tayta Diosga mastapis Moisesta niran: ");
INSERT INTO qub_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","«Mayllacuna paylata runsipita ruranqui jamacunantinta. Chayta churanqui Tolduwan altar caycashanpa pullan chaupinman. Chayman jamarcachir yacuta wiñanqui. ");
INSERT INTO qub_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","Aarón wamrancunawan chay paylapita yacuta jorgurcur maquinta chaquinta mayllaconga. ");
INSERT INTO qub_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","Tolduman manaraj yaycushpan mayllaconga mana wañunanpaj. Aduramashpan altarman imatapis manaraj churaj aywar ");
INSERT INTO qub_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","maquinta chaquinta mayllaconga mana wañunanpaj. Chayno rurananpaj nishätaga Aaronpis paypita mirajcunapis chaynöllami ruranga.» ");
INSERT INTO qub_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","Tayta Diosga mastapis Moisesta niran: ");
INSERT INTO qub_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","«Gam shuntanqui alli asyayniyoj cajcunata: mïrra yörapa weguinta sojta quïluta, canëlata quimsa quïluta, alli asyayniyoj cäñata quimsa quïluta, ");
INSERT INTO qub_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","alli asyayniyoj casiata sojta quïluta. Llapanta pësanqui Tolducho pësacuna caycajwan. Chayno shuntanqui olivo asëtitapis quimsa litru medyanta. ");
INSERT INTO qub_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","Shuntashayquita tacuchinqui perfümita rurajcuna rurashanno. Chay asëtiga canga acrar wiñapäna rispitädumi. ");
INSERT INTO qub_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","Chaywan chajchupanqui Tolduman, chaycho caycajcunamanpis: conträtu babulman, ");
INSERT INTO qub_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","mësaman llapan cösancunaman, candilëruman y llapan cösancunaman, insinsu saumachicuna altarman, ");
INSERT INTO qub_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","uywacunata pishtarcur rupachinayquipaj caycaj altarman y llapan cösancunaman, paylaman jamanantinman. ");
INSERT INTO qub_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","Chayno ruraycuptiquega llapanmi rispitäduna canga. Chaynöpami imapis chay altarta töpaj cäga nogapäna canga. ");
INSERT INTO qub_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","«Chay asëtita wiñapanqui Aaronta wamrancunata acrashä sirbimaj cüräcunana cananpaj. ");
INSERT INTO qub_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","Chayno rurarcorga llapan Israelcunata ninqui: ‹Cananpitaga cay asëti canga acrar wiñapänanpaj imaycamapis fiyupa rispitädu asëtimi. ");
INSERT INTO qub_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","Gamcuna llutallaga ama pï runatapis wiñapanquichu. Chay asëtitanöga ama ruranquichu. Chay asëti rispitädu captin gamcunapis rispitanqui. ");
INSERT INTO qub_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","Pipis chay asëtitano ruraj cäga, pipis llutalla jucta wiñapaj cäga gamcunacho tiyaycashanpita gargushami canga› nir.» ");
INSERT INTO qub_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","Tayta Diosga mastapis Moisesta niran: «Gam shuntanqui noga nishä alli asyaj jachacunata llapantapis iwal-llata: risïna guerupa weguinta, caracolpa putuntapis, gálbanopa weguintapis, insinsu yörapa weguintapis. ");
INSERT INTO qub_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","Chay shuntashayqui jachacunapa weguinta tacurcachir ruranqui alli asyaj insinsuta, imanöpis perfümita rurajcuna rurashanno. Chayga canga pürumi, rispitädumi. ");
INSERT INTO qub_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","Waquin cajtaga sumaj ñuchu aganqui. Chaytana churanqui tincunanchi pachacho babul caycashanpita ñaupanman. Chay insinsu gamcunapäga canga fiyupa rispitädumi. ");
INSERT INTO qub_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","Gamcuna chay insinsuta talluchiypa rurashayquitanöga ama pipis rurangachu. Chayga nogallapaj rurasha captinmi fiyupa rispitädu canga. ");
INSERT INTO qub_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Chay insinsuta rurashayquino pipis musquipäcunanpaj ruraj cäga gamcunacho tiyaycashanpita gargushami canga.» ");
INSERT INTO qub_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","Moisesta mastapis Tayta Dios niran: ");
INSERT INTO qub_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","«Judá trïbupita caj Bezaleeltami noga acrashcä. Payga Uripa wamranmi, Hurpa willcanmi. ");
INSERT INTO qub_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","Bezaleeltaga nogami yarpayta goshcä abilösu runa cananpaj. Chaymi payga ima ruraytapis yachan. Imata rurananpäpis yarpaynin caycan. ");
INSERT INTO qub_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","Goripita, guellaypita, runsipita cuyayllapajcunata rurayta yachan. ");
INSERT INTO qub_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","Cuyayllapaj rumicunatapis llagllayta yachanmi. Llagllarcur camarajlla cananpaj cañichin. Chaynömi guerupitapis llagllayta yachan. Tucuy-niraj cuyayllapäcunata rurayta yachan. ");
INSERT INTO qub_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","Payta yanapänanpaj yarpayta goshcä Ahisamacpa wamran Aholiabta. Payga caycan Dan trïbupitami. Llapan musyaj yachajcunatapis chaynömi yanapashcä masta musyananpaj yachananpaj. Chaynöpami paycunaga gamta willashäcunata ruräshenga. ");
INSERT INTO qub_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","Paycuna ruranga: Tolduta, babulta, babulpa chapananta, Tincuna Tolducho llapan ima cajcunatapis, ");
INSERT INTO qub_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","mësata llapannintinta, goripita candilëruta llapannintinta, insinsu goshtachicuna altarta, ");
INSERT INTO qub_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","rupachicuna altarta llapannintinta, paylata jamacunantinta, ");
INSERT INTO qub_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","sirbimar jatiränan röpata, Aarón mandaj cüra cashpan jaticunan rispitädu röpata, wamrancuna cüra car sirbimänanpaj jaticunan caj röpacunatapis, ");
INSERT INTO qub_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","acrashä cajta wiñapäna asëtita, rispitädu cajcho goshtachinanpaj alli asyaj insinsutapis. «Paycunaga llapantapis ruranga gamta willashänöllami.» ");
INSERT INTO qub_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","Tayta Dios mastapis Moisesta niran: ");
INSERT INTO qub_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","«Israel-masiquicunata willapanqui säbadu jamay junaj cananpaj nishächo jamananpaj. Säbadu jamay junäga caycan juc señalmi gamcunata, wamrayquicunata, paycunapita mirajcunatapis acrashäta musyanayquipaj. ");
INSERT INTO qub_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","«Säbadu jamay junajtaga rispitädu captin llapayqui rispitanqui. Chay jamay junajta mana rispitaj cäga wañuchicangami. Chay junajcho ima aruytapis aroj cäga gamcuna tiyaycashayquipita gargushami canga. ");
INSERT INTO qub_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","Sojta junajlla arunquicuna. Warannin junäga jamanqui nogata rispitamashpayqui. Pipis säbadu jamay junajcho aroj cäga wañuchicangami. ");
INSERT INTO qub_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","«Chaynöpami Israelcunaga nishänölla säbadu jamay junajta imaycamapis rispitanga. Chayno rispitarga conträtu rurashanchïtami imaypis cumlenga. ");
INSERT INTO qub_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","«Nogaga syëlutawan allpata sojta junajcho camarcur warannin junajcho jamarä. Chaymi chay junäga imaycamapis juc señal canga.» ");
INSERT INTO qub_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","Sinaí puntacho Moisesta chayno tantiyarcachirmi ishcay läja rumicunaman dëdunwan isquirbishan laynincunata Tayta Dios entregaran. ");
INSERT INTO qub_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Puntapita Moisés apurä mana cutimuptin Israelcunaga Aarón cajman shuntacaycärir cayno niran: «Egiptupita jorgamajninchi Moisesga manami yurimunchu. Manami musyanchïchu ima päsashantapis. Chaymi cananga gam rurapämay dioscunata ñaupanchïta aywar pushamänanchïpaj.» ");
INSERT INTO qub_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Chaura Aarón niran: «Warmiquicuna, wamrayquicuna charashan gori arëticunata shuntarcur apamuy.» ");
INSERT INTO qub_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Chauraga gori arëtincunata Aaronman apaparan. ");
INSERT INTO qub_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Aaronnami llapan gorita chullurcachishpan töru-mallwa-nirajta jundiran. Chayta ricaycärir ninacuran «Israelcuna, caymi Egiptupita jorgamajninchi dios» nir. ");
INSERT INTO qub_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Chayta ricar Aaronga töru-mallwa-nirajpa ñaupancho juc altarta ruraran. Nircur Israelcunata niran: «Wara junajmi fistata rurashun Tayta Diosninchïta rispitashpanchi.» ");
INSERT INTO qub_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Warannin tutalla jatarcärir rupachina sacrifisyupaj uywancunata pishtaran. Y alli goyaypita sacrifisyutapis churaran chay rurashan diospa ñaupanman. Nircur jamacaycärir llapan micuran upuran. Cushicushpan jucnin-jucninpis munashanta ruran. ");
INSERT INTO qub_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Chaymi Tayta Diosga Moisesta niran: «Uraman juclla cutiy. Egiptupita jorgamushayqui runacunaga jucha ruraymannami churacasha. ");
INSERT INTO qub_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","Paycunaga manapis aycällatami nogata gongaycamar goripita töru-mallwata rurarcur adurarcaycan. Uywacunata pishtarcur ñaupancho rupachisha. Nircur ninacusha: ‹Israelcuna, caymi Egiptupita jorgamaj diosninchi› nir.» ");
INSERT INTO qub_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Tayta Diosga mastapis Moisesta niran: «Chay runacunata ricashcänami. Musyänami mana wiyacoj runacuna cashanta. ");
INSERT INTO qub_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Canan ama rimapämaychu. Fiyupa rabyacurcurmi paycunata usharishaj. Gamllapitanami juc nasyunpaj cananpaj camacächishaj.» ");
INSERT INTO qub_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Chaura Tayta Diospa rabyan päsananpaj Moisesga ruwacur niran: «Tayta Diosnë, munayniyoj cashayquita pï-maytapis musyachishpayquichaj Israel runacunataga Egiptupita jorgamurayqui. Chayno caycaptenga Israelcunapaj ama fiyupa rabyacuychu ari. ");
INSERT INTO qub_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Illgarachiptiquega Egiptucuna nenga: ‹Chunyaj jircacho wañuchinanpaj, cay pachapita illgächinanpaj yarpaypami Diosga caypita jorgusha› nir. Ama rabyacuychu ari. Juchata rurashanpita castiganayquipa ruquenga cuyapaycuy ari. ");
INSERT INTO qub_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Sirbishojniquicuna Abrahamta, Isaacta, Jacobta aunishayquita yarpaycuy ari. Paycunatami nirayqui: ‹Gamcunapita mirajcuna goyllarcunano aypalla cananpämi camacächishaj. Goycunäpaj aunishä partitapis llapanta paycunatami goycushäpaj. Chaura chay partiga paycunapami imaycamapis canga› nir.» ");
INSERT INTO qub_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Chayno Moisés ruwacuptin Tayta Diosga «Ushajpaj illgarachishaj» nishanpita pësacur cuyapashpan mana illgächirannachu. ");
INSERT INTO qub_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Moisés puntapita urämushpan apamuran laycuna isquirbiraycashan ishcay läja rumicunata. Cada läjacho ishcan-läpa isquirbisha caycaran. ");
INSERT INTO qub_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","Chay läjacunataga quiquin Tayta Diosmi camariran. Chaycho isquirbiraycajpis caran quiquin Tayta Dios isquirbishanmi. ");
INSERT INTO qub_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Runacuna büllata ruraycajta wiyar Josuëga Moisesta niran: «Israelcuna goyarcaycashanpitaga guërracho pillyar gaparpajnömi wiyacaycämun» nir. ");
INSERT INTO qub_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Chaymi Moisés niran: «Manami binsiycurchu cushicarcaycämun. Manami binsisha carpischu llaquicarcaycämun. Wiyä talluypa tallur cantarcaycämojtami.» ");
INSERT INTO qub_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Israelcuna goyarcaycashanman chayar Moisés ricaran goripita rurasha caycaj töru-mallwata, llapan gachwarcaycajta. Chaura laycuna isquirbiraycashanta apamushan läjacunata Moisesga rabyallawan punta chaquincho agullajpaj pagshiriran. ");
INSERT INTO qub_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Nircur gori töru-mallwatana ninaman jitapaycuran. Chayta ñuchu canancama agullarcur yacuman machiriran. Chay yacutana Israelcunata upuchiran. ");
INSERT INTO qub_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Aarontanami Moisés niran: «Cay Israelcunata fiyupa jucha rurayman tunichinayquipäga ¿imanashurayquitaj?» ");
INSERT INTO qub_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Niptin Aaronga niran: «Nogapäga ama rabyacuychu ari tayta. Quiquiquipis musyaycanquimi cay runacuna imaypis jucha rurayllapaj wañushanta. ");
INSERT INTO qub_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Paycunami nimaran: ‹Dioscunata rurapämay pushamänanchïpaj. Manami musyanchïchu Egiptupita jorgamajninchi Moisesta ima päsashantapis› nir. ");
INSERT INTO qub_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Chaymi noga nirä: ‹Gorita charajcuna shuntay› nir. Shuntarcärirna apamuran. ¡Chaura chayta ninaman wiñarcuptillä töru-mallwa-niraj ruracäcusha!» ");
INSERT INTO qub_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Moisés tantiyacuranna Israelcunata pusharänanpaj mana pipis cashanta. Aaronga mana imata ruraytapis camäpacushachu caran. Chaynöpis tantiyacuranna chiquejcuna cushipänanpaj cashanta. ");
INSERT INTO qub_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","Chaymi Moisesga Israelcuna tiyarcaycashan yaycunaman ichiycur niran: «Maygayquipis Tayta Diosta wiyacuyta munajcunaga noga caycashäman shuntacämuy.» Chayno niptin Leví trïbu runacunaga Moisés caycashanman llapan shuntacaran. ");
INSERT INTO qub_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","Chaura Moisesga paycunata niran: «Israelcunapa Tayta Diosninmi nisha cada ünuyqui sabliquiwan-cama wasincaylla wauguiquita carpis, bisïnuyquita carpis, yanasayquita carpis wañuchimunayquipaj.» ");
INSERT INTO qub_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Chaymi paycunaga Moisés nishanno rurar wañuchiran. Chauraga chay junaj runacuna wañuran quimsa warangano (3,000). ");
INSERT INTO qub_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Chaypitaga Moisés niran: «Tayta Diosman yäracurmi gamcunaga wamrayquipa, wauguiquipa contranpis jatarishcanqui. Cananga Tayta Dios acrasha-cashunqui payta sirbej canayquipäna.» ");
INSERT INTO qub_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Warannin junaj llapan runacunata Moisés niran: «Gamcunaga fiyupami juchallicushcanqui. Canan yapay aywä Tayta Dios cajman gamcunapaj ruwacoj. Capaschari perdunashunquimanpis» ");
INSERT INTO qub_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Tayta Dios caycashan puntaman chayaycur Moisés ruwacuran: «Rasunpami runacunaga fiyupa juchallicusha goripita diosta ruracarcärishpan. ");
INSERT INTO qub_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Chaypis juchallicushanpitaga perdunaycuy ari tayta. Mana perdunashpayquega libruyquicho isquirbishayqui jutëtapis börrar illgarachimay.» ");
INSERT INTO qub_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Chayno niptin Tayta Dios niran: «Libröpitaga illgächishaj pipis conträ juchata ruraj cajllatami. ");
INSERT INTO qub_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Cananga cutiycushpayqui runacunata pushanqui aunishä partiman. Anjilnëmi pushashunqui. Chaypis Israelcuna juchata rurashanpitaga castiganä junaj chayamuptinnami castigashaj.» ");
INSERT INTO qub_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Chaypita Aarón rurapashan töru-mallwata adurashanpita Tayta Diosga Israelcunata fiyu gueshyawan castigaran. ");
INSERT INTO qub_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Tayta Diosga mastapis Moisesta niran: «Cananga Egiptupita jorgamushayqui runacunawan caypita aywacuy Abrahamta, Isaacta, Jacobta aunishä partiman. Chay partipämi paycunata aunir nirä ‹Gampita mirajcunatami goycushäpaj› nir. ");
INSERT INTO qub_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","Gamcunapa ñaupayquita anjilnëta cachaptëmi gargonga Cananeo runacunata, Amorreo runacunata, Het runacunata, Ferez runacunata, Hev runacunata, Jebús runacunatapis. ");
INSERT INTO qub_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","Gamcuna aywacuy ari lëchipis abëjapa mishquinpis yacunöraj aypalla cashan partiman. Nogami ichanga manana aywashänachu gamcunawan iwal. Gamcunaga mana wiyacoj runacunami canqui. Gamcunawan aywarga nänicho illajpita illgarpis illgarachëmanmi.» ");
INSERT INTO qub_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Tayta Dios chayno nishanta musyaycur Israelcuna amatar llaquicuran. Wañupacusha caycajnöraj ricacuran. Chaymi mana jaticurannachu aläjacunata ni alli röpacunatapis. ");
INSERT INTO qub_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","Tayta Diosga Moiseswan maynami willachisha caran cayno nir: «Gamcunaga mana wiyacoj runacunami canqui. Chaymi gamcunawan aywarga nänicho illajpita illgarpis illgaycachëman. Cananga aläjayquicunata, alli röpata jatirpaycashayquicunatapis jorguy. Chaypitarämi musyacushaj gamcunata imano ruraytapis.» ");
INSERT INTO qub_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Chaura Horeb jircacho jorgushanpita-pacha mana jaticurannachu aläjancunata, alli röpancunatapis. ");
INSERT INTO qub_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Moisesga juc tolduta ichichiran Israelcuna tiyaycashanpita mas carullaman. Chaypa jutinta churaparan «Tincuna Toldu» nir. Pipis Tayta Diosta tapucuyta munaj cäga chay toldumanraj aywaj. ");
INSERT INTO qub_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Moisés chay tolduman aywaptin Israelcunaga cada-ünun toldun puncucho-cama ichirpaycaj. Moisesta ricapaj chay tolduman yaycunanyaj. ");
INSERT INTO qub_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Yaycuptinna toldu puncuman janajpita pucutay urämoj. Tayta Dios Moiseswan parlashancamaga chayllacho pucutayga wancano ichiraycaj. ");
INSERT INTO qub_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Tincunan Toldu puncucho pucutay ichiraycajta ricar runacunaga ichirpaj cada-ünun toldunpa puncuncho-cama. Nircur gongurpacur aduraj. ");
INSERT INTO qub_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Tayta Diosga Moiseswan parlaj amïgunwan runa parlajnömi. Parlayta usharcurnami Moisesga cutej runacuna tiyaycashan cajman. Moisesta yanapaj mösu Josuëmi ichanga chay Tincuna Toldupita imaypis mana llojshejchu. Josuëga caran Nunpa wamranmi. ");
INSERT INTO qub_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Moisesga Tayta Diosta ruwacuran: «Tayta, cay runacunata pushanäpaj nimashpayquipis manami willamashcanquichu pï aywäshimänanpaj cashantapis. Amïguyqui cashallätami, cuyapämashallayquitami nimashcanqui. ");
INSERT INTO qub_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Rasunpa cuyapämashpayquega canan tantiyachimay ari imata yarpashayquitapis. Tantiyachimaptiquimi musyashaj Israel runacunata imata tantiyachinäpaj cashantapis. Musyashayquinöpis cay runacunaga gam acrashayquimi caycan.» ");
INSERT INTO qub_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","Chaura Tayta Dios niran: «Quiquëwanmi aywashonga mana yarpachacuyllapa aywanayquipaj.» ");
INSERT INTO qub_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Moisesnami niran: «Mana yan'gämänayqui captenga caypita aywanäcunapaj ama nimaychu. ");
INSERT INTO qub_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Gam mana yan'gämaptiquega ¿imanöpataj musyashaj nogacunata yanapaycämashayquita? Mana yan'gämaptiquega waquin marca runacunanöllachari cashaj.» ");
INSERT INTO qub_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","Niptin Tayta Dios niran: «Gam amïgö captiquimi, gamta cuyapashä-raycumi mañacamashayquino gamcunata yan'gäshayqui.» ");
INSERT INTO qub_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Chaura Moisesga niran: «Tayta, mä quiquiquita ricaycushayqui ari.» ");
INSERT INTO qub_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Chayno niptin Moisesta Tayta Dios niran: «Cuyapashä cajta cuyapämi. Perdunayta munashä cajtaga perdunämi. Chaymi ñaupayquipa päsar cuyapäcoj cashäta musyachishayqui. Chaynömi jutë ima cashantapis willashayqui. ");
INSERT INTO qub_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","Ichanga cäräta manami ricanquimanchu. Pipis cäräta ricaj cäga wañongami.» ");
INSERT INTO qub_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","Masta Tayta Dios niran: «Ñaupächo caycaj gagaman ichicuy. ");
INSERT INTO qub_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","Fiyupa munaynëwan päsarmi gagapa shillinman yaycachishayqui. Nircur maquëwan chaparcushayqui päsanäcama. ");
INSERT INTO qub_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Päsarir-rämi maquëta jorgushaj. Chaura wajtallätanami ricamanquipaj. Cärätami ichanga mana ricamanquipächu.» ");
INSERT INTO qub_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Tayta Diosga Moisesta niran: «Rumipita llagllay ishcay läjata, paquishayqui läjacuna cashantano. Chay läjamannami isquirbishaj paquishayqui läjacho imanöpis isquirbirashantano. ");
INSERT INTO qub_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Camaricuy Sinaí puntaman wara tuta wichämunayquipaj. Chayamunqui quiquin puntaman noga caycashä cajcama. ");
INSERT INTO qub_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Gamwanga pipis ama shamuchunchu. Ni chay jircapapis ama pipis purichunchu. Chayno ama michicuchunchu uyshata ni wäcatapis Sinaí punta sercanpaga.» ");
INSERT INTO qub_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Chaura Moisesga llagllaran ishcay läja rumicunata, rimir caj cashantano. Tayta Dios nishannömi warannin tutaga ishcan läja rumita apacurcur aywaran Sinaí puntaman. ");
INSERT INTO qub_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Chay puntamannami Tayta Diosga pucutaycho urämuran. Nircur Moiseswan caycaran. Chaycho jutinta willar ");
INSERT INTO qub_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Moisespa ñaupanpa päsashpan Tayta Diosga cayno niran: «¡Nogaga Tayta Diosmi cä! ¡Nogaga Tayta Diosmi cä! Cuyapäcoj, alli shongu Diosmi cä. Jucllaga imapitapis mana rabyacojmi cä. Pasaypa cuyacojmi cä. Rasun cajta rurajmi cä. ");
INSERT INTO qub_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","Waranganpa (1,000) mirar aywajcunatapis cuyapämi. Juchancunapitapis perdunämi. Chaymannömi castigäpis mana wanacuypa jucha rurajcunataga taytanpita gallaycur, wamranta, willcanta, mas willcan cajta, mas willcan cajtapis.» ");
INSERT INTO qub_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Chayno niptin jinan öra Moisesga gongurpashpan umpuran urcunpis pampaman töpananyaj. Nircur Tayta Diosta aduraran. ");
INSERT INTO qub_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","Chaymi niran: «Tayta Dios, gampaj alli casha captëga nogacunata yan'gaycallämay ari. Cay runacunaga mana wiyacoj runacunami. Chaypis mana alli rurashäcunata, juchäcunata perdunaycamay. Nircur acrashayqui runacunana canäpaj chasquiycamay ari.» ");
INSERT INTO qub_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Chaura Tayta Dios niran: «Mañacamashayquita aunëmi. Chaymi canan gamcunawan conträtuta rurashun. May nasyunchöpis ni may marcachöpis mana ricashan milagrucunatami gamcunapa ñaupayquicho rurashaj. Almiraypaj milagrucunata ricarmi waquin nasyun runacunapis musyanga gamcunata yanapashäta. ");
INSERT INTO qub_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Canan willapaycashätaga sumaj wiyacuy. Gamcunapa ñaupayquitami gargushaj Cananeo runacunata, Amorreo runacunata, Het runacunata, Ferez runacunata, Hev runacunata, Jebús runacunata. ");
INSERT INTO qub_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","«Tiyanayquicunapaj caycaj nasyunman chayashpayqui chaycho tiyaj runacunawanga amistäta ni ima conträtutapis ama ruranquichu. Paycunawan conträtuta rurarga mana alli custumricunatami yachacunquipaj. ");
INSERT INTO qub_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","Chay runacunapataga altarnincunata juchorgärachinqui. Adurananpaj ichichishan wancacunatapis ushacächinqui. Asera nishan diosata adurananpaj jawishan racu guerucunatapis mutorgärinqui. ");
INSERT INTO qub_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","«Chaycho tiyaj runacunapa diosnincunataga ama aduranquichu. Nogaga manami munächu chayno ruranayquita. Nogaga munä japalläta aduramänayquitami. ");
INSERT INTO qub_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","«Chaymi chayashayqui nasyuncho tiyajcunawanga ama conträtuta ruranquichu. Paycunawan conträtuta ruraptiquega diosnincunapaj fistata rurashanmanmi pushashunquipaj. Chayman aywarga gamcunapis rurashan micuycunata micur diosnincunata aduraycunquimanmi. ");
INSERT INTO qub_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","Warmi wamrancunapis wamrayquicunawan majachacanmanmi. Paycunapa warmi wamrancuna diosnincunata adurashpanga gamcunapa wamrayquicunatapis mana allita rurachinmanmi adurananpaj shacyächishpan. ");
INSERT INTO qub_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","«Imata jundiypapis ama ïdulucunata ruranquichu. ");
INSERT INTO qub_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","«Lebadüraynaj tantata micuna fistata ruranqui imanöpis ruranayquicunapaj nishänölla. Chaychöga ganchis junaj micunqui lebadüraynaj tantata. Chay fistaga canga Abib quillacho Egiptupita jorgamushäta yarpänayquicunapaj. ");
INSERT INTO qub_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","«Guechpa ollgu wamracunaga nogapämi canga. Chayno wäcayquipa uyshayquipa rimir caj wawancunapis orgu cajcunaga nogapämi canga. ");
INSERT INTO qub_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Bürru rimir wawanta orguta wachaptenga gampaj chay bürru-mallwa cananpaj ruquin Tayta Diospaj apanqui juc cashnita u juc capshita. Ruquin mana apashpayquega bürru-mallwapa cuncanta millurinqui. Chaynömi guechpa wamrayquipa ruquinpis nogapaj ofrendata apamunqui. Noga caycashä cajman shamushpan jinayllaga ama pipis shamongachu. ");
INSERT INTO qub_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","«Semänacho sojta junaj arunquicuna. Warannin caj junajchönami ichanga jamanquicuna, murupacuy wichancho carpis cosëcha wichancho carpis. ");
INSERT INTO qub_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","«Semäna nishan fistatapis ruranqui rimir-punta shuntar raquishayqui chaqui micuyta Tayta Diospaj apaycur. Wata ushanancho cosëchata shuntayta usharcurna übas cosëcha fistatapis ruranqui. ");
INSERT INTO qub_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","«Chay quimsa fistata ruranayquipäga watacho quimsa cuti llapan ollgu cajcuna nogata aduramaj shamonga. Nogami cä Israelcunapa Tayta Diosnin. ");
INSERT INTO qub_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Gamcuna tiyashayquipa ñaupancho juc casta runacuna tiyaycajtaga ushajpämi gargushaj. Chaynöpami nasyunniquita jatunyächishaj. Chaymi gamcuna watacho quimsa cuti aduramaj ñaupäman shamuptiqui mana pipis charicurcongapächu gamcuna tiyashayqui chacrataga. ");
INSERT INTO qub_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","«Nogapaj uywayquita pishtarcur apamur, chay öralla iwaltaga ama rupachinquichu uywapa yawarnintawan lebadürayoj tantata. Pascua fistacho pishtashayqui uywapa aychantaga waranninpaj ama imantapis jaguinquichu. ");
INSERT INTO qub_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","«Chacracho murushayqui rimir-punta shuntar raquishayqui mas allinnin cajta apamunqui noga Tayta Diosta rispitamänayquipaj caycaj wasiman. «Cabra-mallwapa aychanta ama yanunquichu mamanpa lëchinwanga.» ");
INSERT INTO qub_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","Moisesta Tayta Dios niran: «Noga willapashäcunata isquirbiy. Chay isquirbinayquipaj nishäno cumlinayquicunapämi conträtuta rurashcä llapayqui Israelcunawan.» ");
INSERT INTO qub_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Moisesga Sinaí puntacho Tayta Dioswan caycaran chuscu chunca (40) junaj chuscu chunca (40) pagas imatapis mana micuypa mana upuypa. Chaychömi Moisesga läjacunaman isquirbiran Israel runacunawan Tayta Dios conträtu rurashanta. Chay isquirbishancunaga chunca mandamintucunami caycan. ");
INSERT INTO qub_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Sinaí puntapita Moisés cutimuran läjaman mandamintucunata isquirbishanta apacurcur. Chay puntapita cutimur Moisesga mana cuentata gocuranchu cäran achicyaycaj caycashanta. Chaynöga caran Tayta Dioswan parlasha captinmi. ");
INSERT INTO qub_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Chaura Aaronwan Israelcunaga Moisespa cäran fiyupa achicyajta ricar fiyupa manchacuran. Chaymi Moisespitaga carullachöna carcaycaran. ");
INSERT INTO qub_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Moisesga paycunata gayaran. Chaura Aarón Israelpa mandajnincunawan aywaran Moisespa ñaupanman. Moisesnami paycunawan parlaran. ");
INSERT INTO qub_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Chaypitaga llapan Israelcunapis Moisespa ñaupanman witiran. Moisesga willapar tantiyachiran Sinaí puntacho Tayta Dios nishancunata. ");
INSERT INTO qub_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Paycunata willapar parlayta usharcur Moisesga bëluta shucutacuran. ");
INSERT INTO qub_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Tayta Dioswan parlaj aywashpan jorgoj chay shucutaraycashanta, parlashanpita llojshinancama. Llojshircurna Moisesga Israelcunata willapaj Tayta Dios nishancunata. ");
INSERT INTO qub_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","Israelcunaga Moisespa cäranta ricaran fiyupa achicyaypa achicyaycajta. Chaymi Moisesga shucutanta yapay shucutacurcoj. Chaynölla cacoj Tayta Dioswan parlaj yapay yaycunancama. ");
INSERT INTO qub_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Llapan Israelcunata shuntarcur Moisés niran: «Tayta Diosga caynömi nimasha: ");
INSERT INTO qub_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","Semäna ganchis junaj captinpis gamcunaga sojta junajlla arunqui. Ushanan ganchis caj säbadu jamay junäga jamanqui rispitädu junaj captin. Chay junaj llapayqui Tayta Diosta rispitashpayqui jamanqui. Pipis chay junajcho aroj cäga wañuchicangami. ");
INSERT INTO qub_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","Maycho tiyarpis säbadu jamay junajchöga ni ninallatapis ama ratachinquicunachu.» ");
INSERT INTO qub_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Moisés llapan Israelcunata willapar, cayno niran: «Tayta Dios nogata nimasha cayno ruranapämi: ");
INSERT INTO qub_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","Tayta Diospaj ofrendata goycärinayquipaj gamcuna shuntanqui. Shonguyqui shacyashanpita Tayta Diospaj ofrendata churayta munaj cäga gamcuna apamunqui: gorita, guellayta, runsita, ");
INSERT INTO qub_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","jïlucunatana muräduta, aurörata, pucata, lïnu tëlata, cabrapa ajchanpita puchcasha jïluta, ");
INSERT INTO qub_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","uyshacunapa garachanta pucaman tiñishata, fïnu garacunata, acacia gueruta, ");
INSERT INTO qub_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","lamparin ratananpaj asëtita, chayno perfümicunatapis acrana asëtiman wiñananpaj, insinsuman wiñananpäpis, ");
INSERT INTO qub_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","ónice rumicunata, chayno cuyayllapaj rumicunatapis mas mandaj cürapa pichëranman lagapänanpaj, efodman churapänanpäpis. ");
INSERT INTO qub_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","«Gamcunacho maygayquipis ima ruraytapis yachajcunaga shamuy Tayta Dios nimashancunata imanöpis ruranayquipaj. ");
INSERT INTO qub_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","«Tayta Diosta rispitana witichinalla tolduta ruranquicuna: jananta, jananpa gatanancunata, ticpinancunata, marcuncunata, quinraypa chacarajnincunata, tushancunata, chay guerucunapa jamanancunata, ");
INSERT INTO qub_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","Babulta, chapananta, wintunanpaj gueruncunata, babul churaränan cuartuta raquir chaparänanpaj caj bayëtata, ");
INSERT INTO qub_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","mësata, wintunanpaj gueruncunata, mësacho cananpaj cajcunata, Diospaj caj tantata, ");
INSERT INTO qub_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","achqui ratananpaj candilëruta, ima-aycanpis chaycho cajcunatawan, tübu-nirajnincunata, achqui ratananpaj asëtita, ");
INSERT INTO qub_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","insinsuta rupachir goshtachina altartapis wintucunantinta, alli asyaj asëtita, alli asyaj insinsuta, tolduman yaycunata chaparaj tëlata, ");
INSERT INTO qub_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","uywacunata pishtarcur rupachinayquipaj caj altarta, uchpa shicwananpaj runsipita uchcuyojnincunata, wintucunanta, chaycho cananpaj cajcunata, runsipita paylata jamanantinta, ");
INSERT INTO qub_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","rispitädu toldu chaupicho captin guenchano intërunpa tumarej chaparänanpaj cajta rurananpäna: tëlacunata, tushancunata, tushacuna jamananpaj cajcunata, guenchano caycajman yaycuna puncupaj tëlata, ");
INSERT INTO qub_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","tolduta ichichinanpaj istägancunata, intëru cantunpa curraltano ichichinanpaj istägancunata, wasquïllacunata, ");
INSERT INTO qub_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","mas rispitädu cajcho Diosta rispitar jaticunanpaj awaypa awasha röpata: cüra Aarón jaticunanpaj rispitädu röpanta, Aaronpa wamrancunapa cüra cay röpancunatapis.» ");
INSERT INTO qub_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Chaura llapan Israelcuna Moiseswan goturpaycashanpita cuticuran imatapis capushanpita apamunanpaj. ");
INSERT INTO qub_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","Chaymi Tincuna Tolduta jatarachinanpaj ofrendata churayta munajcuna Tayta Diospaj apamuran. Chaynöpis apamuran Tincuna Tolducho cananpaj caj cösacunata rurananpaj y cüra jaticunan rispitädu röpacunata rurananpäpis. ");
INSERT INTO qub_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","Ollgupis warmipis shongun shacyaptin ofrendata goyta munajcuna apamuran ticpicunata, surtïjacunata, wallgancunata, jatirashan arëticunata, goripita rurashan cajtaga imatapis. Cada ünunmi ima-aycatapis goripita cajta Tayta Diospaj apamuran. ");
INSERT INTO qub_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","Caupusha jïlucunata muräduta aurörata pucata, mas alli caj lïnu tëlata awananpaj, cabrapa ajchan caupushata, uyshacunapa garachan pucaman tiñishata, lamarcho tiyajpa garachancunatapis apamuran. ");
INSERT INTO qub_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Mayganpis guellayta, runsita goycunanpaj apaj cäga Tayta Diospa ñaupanman apashpan goycoj. Acacia gueruta apamojpis apamuran Diospaj cajcunata imatapis rurananpaj. ");
INSERT INTO qub_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","Tucuy-nirajta burdayta yachaj caj warmicunapis, apamuran caupusha jïlucunata muräduta, aurörata, pucata, mas alli caj tëlata rurananpaj «lïnu» jutiyojta. ");
INSERT INTO qub_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","Puchcay yachaj warmicunana cabrapa ajchanta puchcaran. ");
INSERT INTO qub_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","Mandajcuna apamuran cuyayllapaj ónice rumicunata, waquinta mas mandaj cüra jaticunan pectoralman, efodmanpis adurnar lagananpaj. ");
INSERT INTO qub_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","Chayno apamuran alli asyaj jampicunata, achquipaj asëticunata, acrar wiñapänanpaj caj asëtita, goshtachiptin alli asyaj cananpaj insinsupäpis. ");
INSERT INTO qub_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","Israel runacuna ollgupis warmipis ofrendata churayta munaj cäga buluntänin cashanpita apapäcamuran Tayta Dios Moisesta nishan cajcunata llapanta rurachinanpaj. ");
INSERT INTO qub_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Israelcunata Moisés niran: «Wiyamay-llapa noga nishäta: Tayta Diosmi acrasha Judá trïbupita caj Bezaleelta. Payga Hurpa willcanmi, Uripa wamranmi caycan. ");
INSERT INTO qub_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","Bezaleeltaga abilösu cananpaj Tayta Diosmi yarpayta gosha Tayta Dios yarpaycashanno rurananpaj. Chaymi payga ima ruraytapis yachan, imata rurananpäpis yarpaysapa. ");
INSERT INTO qub_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","Goripita, guellaypita, runsipita cuyayllapajcunata rurayta yachan. ");
INSERT INTO qub_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","Cuyayllapaj rumicunatapis llagllayta yachanmi. Llagllarcur camarajlla cananpaj cañichin. Chaynömi guerupitapis llagllayta yachan. Tucuy-niraj cuyayllapäcunata rurayta yachan. ");
INSERT INTO qub_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","Chaynömi Diosga Bezaleeltawan Aholiabta tantiyaytapis gosha waquin cajta imano ruraytapis yachachinanpaj. (Aholiabga Ahisamacpa wamran. Ahisamacga Dan trïbupitami casha.) ");
INSERT INTO qub_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","Ishcantami Tayta Dios yanapasha imatapis cuyayllapäta rurananpaj, murädu, auröra, puca chicnu millwa jïluwan llanu caupusha lïnuwan imatapis burdananpaj, cuyayllapaj laburcunata awananpäpis. ");
INSERT INTO qub_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","«Chaymi Bezaleel, Aholiab y waquin yachajcunapis, tantiyaj runacunapis Tayta Dios nishanno Tolduta jatarachengapaj. Paycunatami Tayta Dios yachayta gosha Tolduta, Toldupa cösancunata rurananpaj.» ");
INSERT INTO qub_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Moisés gayaran Bezaleelta, Aholiabta, chayno waquin ima rurayta yachaj cajcunatapis Tayta Dios yachayta goshancunata, quiquinpa buluntänillanpita yanapayta munaj runacunatapis. ");
INSERT INTO qub_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","Tolduta, tolducho cananpaj cajta rurananpaj Israelcuna apapashanta chasquiran. Chay apashanta rurarcaycaptinpis runacunaga quiquincunapa buluntäninpita cada tuta jinalla aparcaycämuran. ");
INSERT INTO qub_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","Chayno apamuptinnami tolducho aruycashanta cachaycur aywaran ");
INSERT INTO qub_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","Moisesta cayno ninanpaj: «Runacunaga alläpanami aparcaycämun, rurananchïpaj Tayta Dios nimashanchïta llapanta rurashapis puchojpänami». ");
INSERT INTO qub_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","Chaura Moisesga runacunata intëru pachacaraycashanpa willacachiran cayno nir: «Tincuna Tolduta jatarachinanchïpaj amana mastaga imatapis apamuychu.» Chayno willacachiptinmi runacuna manana apamurannachu. ");
INSERT INTO qub_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","Tayta Dios nishancunata rurachinanpäpis puchoj puchojnami caran. ");
INSERT INTO qub_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","Waquin arojcunapita ima ruraytapis mas yachajcuna ruraran Tayta Dios tiyanan Tolduta. Tolduta ruraran chunca pësa tëlapita. Chayta awaran caupusha fïnu lïnu jïlupita, muräduman, auröraman, pucaman tiñishapita. Chay tëlacunapa jananman burdaran cuyayllapaj querubín anjilcunata. ");
INSERT INTO qub_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","Chay tëlacunapaga cada-ünunpa larguynin caran chunca ishcay metru medyan (12.5), anchuyninna ishcay metru. ");
INSERT INTO qub_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","Pichga tëlacunata pësaran jucnayllano cananpaj. Yapay pichga cajtapis pësaran jucnayllano cananpaj. ");
INSERT INTO qub_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","Pësashan jucaj cantunman ujalcunata jiraypa tanaran murädu tëlapita. Jucaj cajpa cantunmanpis chayno tanaran. ");
INSERT INTO qub_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","Rimir caj jirashanman churaran pichga chunca (50) ujalcunata; guepa caj jirashanmanpis pichga chunca (50) ujalcunata. Chaura jucaj tëlapa ujalnenga jucaj tëlapa ujalninwan tincucasha caycaran. ");
INSERT INTO qub_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","Chayno goripita ruraran pichga chunca (50) ticpinöcunatapis ujalnincunapita shinrinanpaj. Chaura juc pïsanöllana chaparaycaran chay Tolduga. ");
INSERT INTO qub_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","Cabrapa ajchanpitapis awaran chunca juc (11) tëlacunata. Chay tëlacunaga caran Tolduta gataraycashan jananpa gatananpaj. ");
INSERT INTO qub_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","Chay tëlacunapaga cada-ünunpa larguynin caran chunca quimsa (13) metru medyan, anchuyninna ishcay metru. ");
INSERT INTO qub_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","Pichga caj pësata pësaran jucnayllano cananpaj. Sojtata raquishan cajtapis shuyni pësaran. ");
INSERT INTO qub_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","Chaypa jucaj cantunman pichga chunca (50) ujalcunata jiraran. Jucaj cajpa cantunmanpis yapay pichga chunca (50) ujalcunata jiraran. ");
INSERT INTO qub_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","Chayno runsipita ruraran pichga chunca (50) ticpinöcunatapis jirashan ujalcunapita shinrinanpaj. Chaynöpami juc pïsanölla caycaran. ");
INSERT INTO qub_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","Mas jananman gatananpäpis pucaman tiñisha uyshapa garachanpita ruraran. Mas jananpa gatananpäpis ruraran fïnu garacunawan. ");
INSERT INTO qub_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","Tolduta ichichinanpaj marcuncunata ruraran acacia guerupita. ");
INSERT INTO qub_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","Cada marcupa larguynin caran chuscu metru medyan. Anchuyninna caran sojta chunca pichga (65) sentïmetru. ");
INSERT INTO qub_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","Cada marcupa ishcay chaquincunatapis ruraran. Chaynölla ruraran llapan marcucunapaj. ");
INSERT INTO qub_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","Jucaj-läduncho ichichinanpaj ruraran ishcay chunca (20) marcucunata. ");
INSERT INTO qub_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","Chay ishcay chunca (20) marcucuna ichiränanpaj guellaypita ruraran chuscu chunca (40) jamanancunata. Chaura cada marcu jamaränan caran guellaypita ishcay jamanacho. ");
INSERT INTO qub_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","Jucaj-lädunpäpis ruraran ishcay chunca (20) marcucunata. ");
INSERT INTO qub_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","Chay caj-läpäpis guellaypita ruraran chuscu chunca (40) jamanancunata. Chaura cada marcu jamaränanpaj caran guellaypita ishcay jamanacuna. ");
INSERT INTO qub_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","Guepan caj-läpa ichichinanpäpis ruraran sojta marcucunata. ");
INSERT INTO qub_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","Chay guepancho ishcan isquïnancunacho ichichinanpäpis ruraran mas ishcay marcuta. ");
INSERT INTO qub_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","Chay marcucunaga isquïnacunapaj caran isquïnayoj cananpaj doblasha. Janaj ushajninchöna arguyllawan chariränan caran. Jucaj isquïnapäpis jucaj isquïnapänölla ruraran. ");
INSERT INTO qub_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","Chaura llapanga caran pusaj marcucuna, cada ünun ishcay jamacunancunawan-cama. Llapanpäga caran guellaypita chunca sojta (16) jamanancuna. ");
INSERT INTO qub_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","34","Tolduta quinranpa chacarajnincunapis acacia guerupita ruraran chunca pichgata (15). Chaycunaga pichga caran jucaj-lädunpa ichiraj marcucunata chariränanpaj. Yapay pichgana caran jucaj-lädunpa ichiraj marcucunata chariränanpaj. Yapay pichga cajna caran guepanpa ichiraj marcucunata chariränanpaj. Chay quinranpa chacaj guerucunataga goriwan chaparan. Marcucunatapis goriwan chaparan. Arguyllacunatapis goripita ruraran quinranpa chacaraj guerucuna chaypa päsananpaj. Marcupa pullan chaupinpa chacaraj gueruga juc cantupita juc cantucama päsaränanpaj ruraran. ");
INSERT INTO qub_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","Toldu ruricho raquir chaparänanpaj tëlatapis awaran caupusha fïnu lïnu jïlupita, muräduman, auröraman, pucaman tiñishata. Chay jananman burdaran cuyayllapaj querubín anjilcunata. ");
INSERT INTO qub_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","Acacia guerupita chuscu tushacunata ruraran. Chaytaga goriwan chapyaran. Jamanancunatana jundiran guellaypita. Tushacunapa puntanman churaran goripita arguyllata chayman tëlacunata warcunanpaj. ");
INSERT INTO qub_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","Tolduman yaycuna puncu chaparajta ruraran caupusha fïnu lïnu jïlupita, muräduman, auröraman, pucaman tiñishapita. Chay jananman cuyayllapajcunata burdaran. ");
INSERT INTO qub_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","Acacia guerupita pichga tushacunata ruraran. Chaypa puntancunataga goriwan chapyaran. Jamanancunatapis runsipita pichgata jundiran. Tushacunapa puntanman churaran goripita arguyllata chay awashan tëlacunata warcunanpaj. ");
INSERT INTO qub_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","Nircur Bezaleelga acacia guerupita ruraran juc babulta. Largun caran juc metru chunca sentïmetrun. Anchun caran sojta chunca pichgan (65) sentïmetru. Altuyninpis caran sojta chunca pichgan (65) sentïmetru. ");
INSERT INTO qub_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","Rurinpa jananpa goriwan chapyaran. Chayno intëru cantunpapis goripita ribëtita churaparan. ");
INSERT INTO qub_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","Goripita ruraran chuscu arguyllata babulpa chuscun chaquin isquïnacunaman churananpaj. Chaycunataga churaran ishcayta jucaj-lädunman, ishcayta jucaj-lädunman. ");
INSERT INTO qub_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","Chay babulta wintunanpaj ishcay largu acacia gueruta camariran. Chay camarishan guerucunata goriwan chapyaran. ");
INSERT INTO qub_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","Nircur chay guerucunataga churashan arguyllacunapa uchcunpa päsachiran chaypita apar wintunanpaj. ");
INSERT INTO qub_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","Chapanantaga ruraran gorillapitana. Largun caran juc metru chunca sentïmetrun. Anchun caran sojta chunca pichgan (65) sentïmetru. ");
INSERT INTO qub_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","Babulpa chapanan janancho ruraran ishcay querubín anjilcunata. Chay caycaran gorita martilluwan tacayllapa rurasha. Querubín anjilcunaga caycaran chay chapanapa ishcan cuchuncunacho. ");
INSERT INTO qub_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","Chapananwan chay querubín anjilcunata rurashanga caycaran chay pïsalla. Jucaj querubín anjil caycaran jucaj cantuncho, jucajna jucaj cantuncho. ");
INSERT INTO qub_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","Chay querubincunaga wac-lä cay-lä ishcanpis caycaran ñaupanman älancuna quichasha. Ishcanpis ricarpaycaran chapanallanman. Chaura älancunaga chapana jananpa quichasha caycaran. ");
INSERT INTO qub_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","Bezaleelga acacia guerupita ruraran mësata. Larguynin caran isgun chunca (90) sentïmetru. Anchun caran chuscu chunca pichgan (45) sentïmetru. Altuynin caran sojta chunca pichgan (65) sentïmetru. ");
INSERT INTO qub_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","Intërunta goriwan chapyaran. Intëru cantunpapis goripita ribëtita churaparan. ");
INSERT INTO qub_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","Chay mësa cuchullanpa churaparan ganchis sentïmetru altuta intërunpa tumarejta. Chaymanmi gori ribëtita churaparan intërunpa tumarej. ");
INSERT INTO qub_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","Goripita jundiypa ruraran chuscu arguyllata. Chay arguyllata churaran chuscu isquïnanman. ");
INSERT INTO qub_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","Chaura chay arguylla caycaran chaquin tanaraycashan läduncho. Chay arguyllacunapanami päsararan mësata wintunanpaj rurashan gueru. ");
INSERT INTO qub_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","Mësata wintunanpaj caj guerucunataga ruraran acacia guerupita. Intëru jananpana goriwan chapyaran. ");
INSERT INTO qub_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","Goripita ruraran mësa janancho ruranan cösacunata: lätucunata, tasuncunata. Järracunatapis, cöpacunatapis ruraran chaywan altarman bïnuta wiñapänanpaj. ");
INSERT INTO qub_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","Bezaleelga martilluwan tacayllapa ruraran goripita candilëruta. Jamanan, ichirajnin, cöpancuna, mogu-mogu caycajcuna, wayta pashtaraycaj-niraj umancunapis caran juc pïsalla. ");
INSERT INTO qub_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","Chay candilërupa rämancunaga caran sojta callapayoj, quimsa jucaj-lädunpita, quimsa jucaj-lädunpita. ");
INSERT INTO qub_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","Cada callapa aywarajcho caran quimsa mogucuna wayta pashtaraycaj-niraj. Chaynölla caran sojtan callapancho. ");
INSERT INTO qub_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","Jamananpita aywaraj chaupi tullunchöga caran chuscu mogucuna wayta pashtaraycajno. ");
INSERT INTO qub_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","Chay mogucunaga cada callapa llojshejpa chaquinchömi caran. ");
INSERT INTO qub_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","Chay wayta pashtaraycaj-niraj moguncunaga caran jinallanpita martilluwan tacaypa rurasha. ");
INSERT INTO qub_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","Candilërupa ganchis tübu-nirajnincunatapis, tinäsuncunatapis, llipta shuntacunan lätu-mallwancunatapis gorillapita ruraran. ");
INSERT INTO qub_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","Candilërutaga llapan cösancunatawan ruraran quimsa chunca quimsa (33) quïlu goripita. ");
INSERT INTO qub_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","Bezaleel ruraran juc altarta acacia guerupita insinsuta chaycho rupachinanpaj. Chayta ruraran chuscun lädun iwalta. Cada lädun caycaran chuscu chunca pichgan (45) sentïmetru. Chay iwal-lla caycaran anchuynin larguyninpis. Altuyninna caran isgun chunca (90) sentïmetru. Altarpa wagrancunapis quiquin altarwanga chay pësallami caran. ");
INSERT INTO qub_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","Intërunta goriwan chapyaran. Wagrancunatapis goriwan chapyaran. Wirpanpapis intëru cantupa tumarej churaparan goripita juc ribïtitano. ");
INSERT INTO qub_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","Chay churashan chaquinpana churaparan goripita rurashan arguyllacunata, cada lädunman ishcayta-cama. Chay arguyllataga churaran chaypa gueruta jatircur altarta wintunanpaj. ");
INSERT INTO qub_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","Wintunanpaj caj guerutapis ruraran acacia guerupita. Nircur jananpa chapyaran goriwan. ");
INSERT INTO qub_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","Chaynöpis Bezaleel ruraran alli asyaj asëtita acrar wiñapänanta. Chayno ruraran alli asyaj insinsutapis. Chaytaga ruraran perfümita rurajcuna rurashanno. ");
INSERT INTO qub_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","Bezaleelga uywata pishtarcur rupachicuna altarta ruraran chuscu isquïnayojta, acacia guerupita. Cada lädunpa larguynin caran ishcay metru ishcay chunca picha (25) sentïmetrun. Altuynin caran juc metru ishcay chunca pichga (25) sentïmetrun. ");
INSERT INTO qub_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","Chuscun isquïnancho wagratano ruraran. Chaycuna caran llagllaypa rurasha quiquin altarwanga chay pïsalla. Nircur intëru jananpa runsiwan chapyaran. ");
INSERT INTO qub_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","Uchpa jorgucuna mancancunatapis, pälancunatapis, tasunnincunatapis, rinchincunatapis, wichincunatapis ruraran. Chaycunaga llapanpis caran runsipita jundiypa rurashalla. ");
INSERT INTO qub_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","Chayno rëjasnincunatapis mällatano runsipita ruraran. Nircur rëjastaga churaran altarpa rurincho patac caycajman. Chaynöpami chay rëjasga quëdaran altarpa pullannincho. ");
INSERT INTO qub_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","Runsipita chuscu arguyllacunatapis jundiypa ruraran. Nircur chay arguyllacunata chuscun isquïnaman churaran chay arguyllacunapa gueruta päsarcachir wintunanpaj. ");
INSERT INTO qub_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","Altarta wintunan guerucunataga acacia guerupita ruraran. Chay rurashantaga intërunta runsiwan chapyaran. ");
INSERT INTO qub_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","Chay ishcan-läduncho caycaj arguyllapa uchcunpa jatiran chaypita wintunanpaj. Chay altartaga tablapita ruraran alayri uchcullata. ");
INSERT INTO qub_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","Chaypita Bezaleelga ruraran juc paylata runsipita llapan jamanantinta. Chayta ruraran toldu puncucho aroj warmicunapa espëjuncunapita. ");
INSERT INTO qub_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","Bezaleelga Toldupa sawanninpaj tëlata rurachiran. Nircorga intëru cantunpana fïnu lïnu tëlawan guenchachiran. Sur caj-lädunpa larguynin caran chuscu chunca pichga (45) metrun. ");
INSERT INTO qub_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","11","Norte caj-lädunpapis larguynin caran chuscu chunca pichga (45) metrun. Chaycunapäga cada lädunpaj ruraran ishcay chunca (20) tushacunata. Chay tushacunapa jamanancunata cada lädunpaj runsipita ruraran ishcay chuncata (20). Aushincunatapis, arguyllancunatapis guellaypita ruraran. ");
INSERT INTO qub_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","Inti yaganan caj-läpa anchuynin caran ishcay chunca ishcay metru medyan (22.5). Chaypapis fïnu lïnu tëlawan guencharan. Chaypaj ruraran chunca tushacunata chunca jamanancunatawan. Chay tushacunapa aushincunata, arguyllancunatapis guellaypita ruraran. ");
INSERT INTO qub_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","Inti yagamunan caj-läpa ricaraycaj puncunpapis anchuynin caran ishcay chunca ishcay metru medyan (22.5). ");
INSERT INTO qub_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","Puncupita jucaj-lädunman caran ganchis metru. Chaypäpis ruraran quimsa tushacunata quimsa jamanancunatawan. ");
INSERT INTO qub_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","Puncupita jucaj-lädunmanpis churaran ganchis metru tëlata. Chay tëlata chararänanpaj ruraran quimsa tushacunata cada-ünunta jamanancunatawan. ");
INSERT INTO qub_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","Guenchanpaj caj tëlacunataga awaran fïnu lïnupitami. ");
INSERT INTO qub_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","Intëru cantunpa tumariraj tushacunapa jamanancunataga runsipita ruraran. Tushapa aushincunata arguyllancunatapis guellaypita ruraran. Tushapa puntanta chaparänanpäpis guellaypita ruraran. Sawanpa llapan tushancunapa arguyllancunatapis guellaypita ruraran. ");
INSERT INTO qub_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","Quiquin puncu yaycuna cajpana anchuynin caran isgun metru. Chaypaj awaran caupusha fïnu lïnu jïlupita, muräduman, auröraman, pucaman tiñishapita. Chaytaga cuyayllapaj burdaran. Chay tëlapa altuyninta ruraran ishcay metru ishcay chunca pichga (2.25) sentïmetrunta. Waquin guenchapa altuynintano ruraran. ");
INSERT INTO qub_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","Chay puncupäga ruraran chuscu tushacunata runsipita jamanancunatawan. Chay tushacunapa aushincunata arguyllancunata guellaypita ruraran. Tushapa puntanta chapananpäpis guellaypita ruraran. ");
INSERT INTO qub_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","Toldu tuninanta chariraj istägacunatapis, Toldupa sawanninpa guenchanta chariraj istägacunatapis runsillapita ruraran. ");
INSERT INTO qub_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","Moisés nishannöllami cüra Aaronpa wamran Itamarga cüracunata yanapaj Leví runacunawan apuntachiran Tolduta imawanpis rurachishancunata. Chay Tolduga caran babul churaränanmi. ");
INSERT INTO qub_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","Judá trïbupita caj Hurpa wamran Uripa wamran Bezaleelga llapantami ruraran Tayta Dios Moisesta nishannölla. ");
INSERT INTO qub_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","Bezaleeltaga ruräshiran Ahisamacpa wamran Aholiab. Pay caran Dan trïbupita. Chaynöpis Aholiab caran fyërruta tacay yachaj. Paymi yacharan tucuy-nirajta awayta, tucuy-nirajcunata burdaytapis. Llapan casta tëlacunacho, muräducho, auröracho, pucacho, lïnu tëlachöpis burdayta yacharan. ");
INSERT INTO qub_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","Tolduta, Tolducho cananpaj caj cösacunata rurananpaj gori caran runacuna ofrenda churashanmi. Runacuna ofrenda churashan gori llapanga caran isgun pachac sojta chunca pichgan (965) quïlu quimsa chunca (30) grämunwan. Chaycunata pësaran Tolducho caj pësacunawan. ");
INSERT INTO qub_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","Sinsucoj cumuncunapita shuntashan guellayga pësaptin lasaran quimsa waranga quimsa pachac chunca isgun (3,319) quïlu pichga pachac ishcay chunca pichgan (525) grämunwan. Chaycunataga pësaran Tolducho pësacuna cajwan. ");
INSERT INTO qub_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","Ishcay chunca (20) watayojpita janaman cajlla runacuna sinsucuran. Paycunami caran sojta pachac quimsa waranga pichga pachac pichga chuncan (603,550) runacuna. Chay runacunami cada-ünun pägaran pichga grämu medyan guellayta. Tolducho caj pësacunawan pësaypa churaran. ");
INSERT INTO qub_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","Chay shuntashan guellaymi quimsa waranga quimsa pachac (3,300) quïlu caran. Chay guellaywanmi Tincuna Toldupa marcuncunapa jamanancunata, ruricho caj tëlata chararaj tushacunapa jamanancunatapis ruraran. Pachactami (100) chay jamanancunata jundiran. Chaymi cada jamanata jundiran quimsa chunca quimsa (33) quïlu guellaypita. ");
INSERT INTO qub_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","Waquin caj guellay shuntashanwan ruraran tushacunapa aushincunata, arguyllancunatapis. Tushacunapa puntantapis chaparan chay guellayllawan. ");
INSERT INTO qub_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","Tayta Diospaj apashanga runsipis ushajpäga caran ishcay waranga quimsa pachac quimsa chunca sojta quïlu medyan (2,336.5). ");
INSERT INTO qub_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","Chay runsipitami ruraran Tincuna Tolduta rurashanpa puncun yaycurinacho tusha ichirajcunapa jamananta. Chayno altarta, uchpa shicwananpaj uchcuyojtapis chay runsipitami ruraran. Runsillapitami ruraran altarpa llapan cösancunatapis. ");
INSERT INTO qub_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","Toldupa intëru cantunpa guencharaycajcho caycaj tushacunapa jamanancunata, istägancunatapis runsillapita ruraran. Chayno guenchano caycajman yaycurinacho caycaj tushacunapa jamanancunatapis runsillapita ruraran. ");
INSERT INTO qub_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","Rispitädu Tolduman yaycunanpaj caj röpata cüra jaticunanpäga shuyni ruraran. Chayta ruraran murädu tëlapita, aurörapita, pucapita. Chaynöllami Aarón rispitädu röpata jaticunanpäpis ruraran. Moisesta Tayta Dios nishannöllami ruraran. ");
INSERT INTO qub_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","Bezaleelga efodta ruraran goriwan, caupusha jïlupita rurasha fïnu lïnu tëlawan, muräduman, auröraman, pucaman tiñisha tëlawan. ");
INSERT INTO qub_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","Goritaga tacaypa llapshacharan. Nircur chayta cuchuran jïlutanölla. Chay jïluno goriwanna burdaran caupusha jïlupita awashan lïnu tëlaman, muräduman, auröraman, pucaman tiñisha tëlaman. ");
INSERT INTO qub_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","Efodtaga ruraran ishcay tëlata. Ishcan-lä puntancho ruraran umrunpa päsachir chaycunapita watananpaj. ");
INSERT INTO qub_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","Efodta chegllanpa watacunanpäna wachcunta ruraran goriwan, caupusha jïlupita rurasha fïnu lïnu tëlawan, muräduman, auröraman, pucaman tiñisha tëlawan. Efodwanga chay pësallami caran. Chaytaga ruraran Moisesta Tayta Dios nishannöllami. ");
INSERT INTO qub_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","Achicyaycachaycaj ónice rumicunata churaran efodpa jananman goripita cañichicunata rurashanman. Chay churashan rumicuna jananmannami sëlluta rurajno isquirbiran Israel trïbucunapa jutinta. ");
INSERT INTO qub_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","Bezaleelga chaycunata churaparan efod watun umrunpa päsaränan cajman. Chaura chaycunaga caycaran Israel trïbucunata Tayta Dios yarpänanpämi. Chaytaga ruraran Moisesta Tayta Dios nishannöllami. ");
INSERT INTO qub_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","Cüra pëchunman churacur watacunan pectoraltapis ruraran efodta rurashannölla goriwan, caupusha jïlupita rurasha fïnu lïnu tëlawan, muräduman, auröraman, pucaman tiñisha tëlapita. Chaycunataga cuyayllapaj burdashata ruraran. ");
INSERT INTO qub_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","Pectoralta doblaran bolsano chuscu isquïnayojta, cuarta largun, cuarta anchuyojta. ");
INSERT INTO qub_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","Jananman lagaran cuyayllapaj rumicunata chuscu fïlata. Rimir caj fïlacho caycaran cayno jutiyoj rumicuna: sárdica, topacio, carbunclo. ");
INSERT INTO qub_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","Ur'gan fïlacho caycaran: esmeralda, zafiro, diamante. ");
INSERT INTO qub_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","Mas ur'gan fïlacho caycaran: jacinto, ágata, amatista. ");
INSERT INTO qub_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","Ushanan caj fïlacho caycaran: Berilo, ónice, jaspe. Chay rumicunaga llapanpis caycaran goripita awaypano rurashacho cañichisha. ");
INSERT INTO qub_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","Chay rumicunachöga caycaran Israelpa chunca ishcay wamrancunapa jutincunami. Cada ünunpa jutincuna caycaran juc rumicho-cama sëllucho isquirbiraycajno isquirbisha. ");
INSERT INTO qub_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","Pectoralpaj curdunta ruraran goripita pilltaypa. ");
INSERT INTO qub_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","Chay pectoralcho ruraran goripita ishcay arguylla-mallwacunata. Chayno goripita cañichicunatapis rurachiran. Chaycunataga churaparan pectoralpa jana caj ishcan-lä puntancunaman. ");
INSERT INTO qub_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","Ishcan gori curduntana charichiran pectoralpa ishcan-lä isquïnancho arguylla caycajman. ");
INSERT INTO qub_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","Chay curduncunapa jucaj puntancunatana charichiran efodpa umruncho lagaraycaj cañichicunaman. ");
INSERT INTO qub_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","Yapay goripita ruraran ishcay arguylla-mallwata. Nircur chaycunata churaran pectoralpa ura caj ishcan-lä puntan rurinman. ");
INSERT INTO qub_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","Yapay goripita ruraran ishcay arguylla-mallwata. Nircur churaran efodpa ishcan-lä cantunman, wachcu aywanan ñaupanman. ");
INSERT INTO qub_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","Pectoralcho ishcay arguyllacuna caycajpita auröra curdunwan wataran efodcho ishcay arguyllacuna caycajman. Chaynöpami pectoralga efodpita mana cuyucuranchu. Llapantapis ruraran Moisesta Tayta Dios nishannöllami. ");
INSERT INTO qub_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","Efodpa rurinman jaticunan sotänata murädu tëlapita ruraran. ");
INSERT INTO qub_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","Chaupincho uman yaycunanpaj uchcuyoj caran. Chay uchcu sinchi cananpaj awaypa awasha caran ribëtitano mana rachinanpaj. ");
INSERT INTO qub_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","Sotänapa chaqui puntanmanna intërupa tumarej churaran wallwata, auröra jïlupita, murädu jïlupita, puca jïlupita, caupusha fïnu lïnu jïlupitapis rurarcur. ");
INSERT INTO qub_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","Chayno goripita ruraran tacsha campanillacunatapis. Chay campanillacunataga sotänaman churaran intëru chaqui puntan tumarejpa wallwacunatawan tacuchiypa. ");
INSERT INTO qub_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","Chaura sotänachöga intëru chaqui cantunpa tumarej caycaran juc wallwa, juc gori campanilla, juc wallwa juc gori campanilla. Chayta ruraran Tolduman aroj yaycur cüra jaticunanpämi, Moisesta Tayta Dios nishannölla. ");
INSERT INTO qub_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","Aaronpaj wamrancunapäpis ruraran päsaypa largu röpata fïnu lïnu tëlapita. ");
INSERT INTO qub_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","Chayno ruraran shucullpintapis, adurnuncunatapis fïnu lïnupita. Ruri ajüruntapis caupusha fïnu lïnupita ruraran. ");
INSERT INTO qub_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","Labur wachcuntapis awaran lïnu jïlu caupushapita, murädupita, aurörapita, pucapita. Awarcur wachcumanga cuyayllapäcunata burdaran. Chayta ruraran rurachinanpaj Moisesta Tayta Dios nishannölla. ");
INSERT INTO qub_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","Vinchatano goripita läjallata rurachiran. Chayman isquirbiran sëllucho isquirbejno. Chaycho niycaran «Tayta Diospajacrasha» nir. ");
INSERT INTO qub_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","Chayman murädu tëlapita watunta churaparan shucullpin jananpa watananpaj. Chayta ruraran rurachinanpaj Moisesta Tayta Dios nishannölla. ");
INSERT INTO qub_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","Tincuna Tolduta rurayta usharanna. Israelcunaga llapantapis ruraran Tayta Dios Moisesta nishannölla. ");
INSERT INTO qub_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","Moisesman llapan rurashancunata apamuran, Tincuna Toldupaj cajta, Tincuna Toldupa llapan imancunatapis: aushincunata, marcuncunata, quinraypa chacaraj guerucunata, tushancunata, tushacuna jamanancunata, ");
INSERT INTO qub_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","Tincunata gatananpaj caj mas alli garachacunapita rurashancunata, Tolducho pullanpita raquir Dioswan conträtuta rurar isquirbishan churaraycaj babulta chaparänanpaj rurashancunata, ");
INSERT INTO qub_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","Dioswan conträtuta rurashanta churananpaj rurashan babulta, chay babulpa chapananta, wintunanpaj guerunta, ");
INSERT INTO qub_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","mësata, chaycho llapan imancunatapis, Tayta Diospaj tanta rurashantapis, ");
INSERT INTO qub_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","goripita rurashan candilëruta, lamparinnincunata, candilërupa llapan cösancunata, achqui ratananpaj asëtitapis, ");
INSERT INTO qub_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","insinsuta rupachir goshtachina altarta, acrar wiñapäna alli asyaj asëtita, alli asyaj insinsuta, Tincuna Tolduman yaycunata chaparaj tëlata, ");
INSERT INTO qub_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","runsipita rurashan altarta, uchpa shicwananpaj runsipita uchcuyojnincunata, wintucunanta, imancunatapis, runsipita paylata jamanantinta, ");
INSERT INTO qub_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","rispitana toldupa intëru cantun tumarejpa guenchano chaparänanpaj awashanta, tëlacunata, tushancunata, tushacunapa jamanancunata, guenchaman yaycunata chaparaj tëlata, Tincuna Toldupa llapan cösancunata, ");
INSERT INTO qub_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","awaypa awasha röpata mas rispitädu cajcho Diosta rispitar cüra jaticunanpaj cajta. Chayno apamuran cüra Aaronpaj rispitädu röpata, Aaronpa wamrancuna cüra car jaticunanpaj röpacunatapis. ");
INSERT INTO qub_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","Israelcunaga llapantapis ruraran Tayta Dios Moisesta nishannölla. ");
INSERT INTO qub_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","Llapan rurashancunata Moisés ricaptin caran Tayta Dios nishannölla. Chaymi Moisesga paycunata bindisyunta goran. ");
INSERT INTO qub_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","Moisesta Tayta Dios niran: ");
INSERT INTO qub_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","«Mushoj wataman gallarej quilla rimir junajcho Tincuna Tolduta ichichir camacächinqui. ");
INSERT INTO qub_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","Chay Toldu ruriman churanqui isquirbichishä churaraycaj babultapis. Nircur tëlata waguinqui babulta chapananpaj. ");
INSERT INTO qub_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","Mësata yaycarcachir sumaj camacächinqui. Candilërutapis yaycarcachir tübuncunata camarircur achquita sindinqui. ");
INSERT INTO qub_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","Insinsuwan saumachinayquipaj gori altartapis churanqui Conträtu Babulta chaparaj tëla ñaupanman. Tolduman yaycunata chapananpäpis tëlata churanqui. ");
INSERT INTO qub_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","«Nircur uywacunata pishtar rupachina altartapis Tolduman yaycuna ñaupanman-niraj churanqui. ");
INSERT INTO qub_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","Chaypita churanqui runsi paylata, altarpita Tincuna Tolduman aywaj pullan chaupiman. Nircur chay paylamanga juntata yacuta wiñanqui. ");
INSERT INTO qub_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","Chaycunata camacächiyta ushaycorga Toldupa ñaupanpa guenchano cananpaj intëru tumarej ichichinqui. Chayman yaycuna puncutapis chapanqui. ");
INSERT INTO qub_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","«Llapanta camacarcacherga acrar wiñapäna asëtita wiñapanqui Tolduman, chaycho caycaj cösacunamanpis. Chaynömi gamga ruranquipaj shuyni nogapäna cananpaj. Chaura chaycunaga canga rispitäduna. ");
INSERT INTO qub_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Chaynöpis asëtita wiñapanqui uywacunata rupachina altarta, chaycho caycajcunatapis. Chayno ruraptiquinami shuyni nogapaj canga. Chaura chayga canga rispitäduna. ");
INSERT INTO qub_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Paylamanpis jamacunantinman rispitädu asëtita wiñapanqui. Chaynöpami rispitädu car nogapäna canga. ");
INSERT INTO qub_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","«Nircur Aaronta wamrancunatawan pushay Tincuna Toldu puncu ñaupanman. Chaycho paycunata bäñanqui labaturyucho caycaj yacuwan. ");
INSERT INTO qub_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","Bäñarcur Aaronta jatipanqui rispitädu röpata. Nircurna umanman asëtita wiñapanqui shuyni nogapäna cananpaj. Chauraga nogata sirbimaj cüräna caycanga. ");
INSERT INTO qub_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","Aaronpa wamrancunatapis chayno gayarcur jatipanqui sotänancunata. ");
INSERT INTO qub_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","Nircorga papäninta umanman wiñapashayquino asëtita wiñapanqui. Chauraga paycunapis canga nogata sirbimaj cüräcunana. Chay asëtita wiñapashayquiwanga paycuna casta cüra caynin imaycamapis mana ushaypana canga.» ");
INSERT INTO qub_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Chaura Moisesga llapantapis ruraran Tayta Dios nishannölla. ");
INSERT INTO qub_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","Egiptupita llojshishan ishcay wataman gallaycoj rimir junajcho camacächir ichichiran Tolduta guenchano caycajnincunatawan. ");
INSERT INTO qub_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Moisés llapanta camacächishpan Tolduta ichichiran. Marcucuna jamananpaj churaparan jamanancunata. Chay jamanacunaman marcucunata ichichishpan chacaraj guerucunata churachiran. Tushacunatapis ichichiran. ");
INSERT INTO qub_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","Toldupaj ichichishan tushacunapa jananman-jananman gataran tolduna cananpaj. Llapantapis ruraran Tayta Dios Moisesta nishannölla. ");
INSERT INTO qub_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Nircorga conträtuta rurar isquirbishantapis babulman churaran. Babulta wintunan gueruncunatapis arguyllancunapa päsarcachiran. Chaynöpis babultaga chapananwan chaparcuran. ");
INSERT INTO qub_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","Llapanta camacarcachir aparan Toldupa mas rurin caj cuchuman. Nircur babul shuyni cananpaj ñaupanpa tëlata waguiran. Chaycunata llapantapis ruraran Tayta Dios Moisesta nishannölla. ");
INSERT INTO qub_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","Chaypita mësatapis churaran Tincuna Tolducho jawa caj cuartuman norte caj-läman. ");
INSERT INTO qub_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","Mësa jananman tantatapis camacächiran Tayta Diospa ñaupancho cananpaj. Llapantapis ruraran Moisesta Tayta Dios nishannölla. ");
INSERT INTO qub_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","Candilërutapis churaran mësapa ñaupanman. Chaura chayga caycaran cuartupa sur caj-lädunchöna. ");
INSERT INTO qub_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","Nircur lamparincunatapis sindiran Tayta Diospa ñaupancho. Llapanta ruraran Tayta Dios nishannölla. ");
INSERT INTO qub_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","Goripita rurashan altarta churaran Tincuna Tolducho tëla chaparaycashan ñaupanman. ");
INSERT INTO qub_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","Nircorga Tayta Dios nishannölla rupachishpan goshtachiran alli asyaj insinsuta. ");
INSERT INTO qub_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","Chaypita waguiran Tolduman yaycunata chapananpaj awashan tëlata. ");
INSERT INTO qub_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","Nircur uywata pishtarcur rupachina altarta churaran Tincuna Toldu puncupa cay lädunman. Chaypitaga rupachina sacrifisyucunata chay altarcho rupachiran, chaqui micuy ofrendacunatapis. Llapantapis ruraran Moisesta Tayta Dios nishannöllami. ");
INSERT INTO qub_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","Chaypita paylata churaran altarwan Tincuna Toldu caycashan pullan chaupinman. Nircur chay labaturyumanga yacuta wiñaran chay yacuwan mayllacunanpaj. ");
INSERT INTO qub_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","Chaypitana Moisés, Aarón, Aaronpa wamrancunapis maquinta chaquinta chay yacuwan mayllacoj. ");
INSERT INTO qub_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","Paycunaga mayllacoj Tincunaman yaycur, chayno altar cajman aywarpis. Tayta Dios nishannöllami ruraj. ");
INSERT INTO qub_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Chaycunata llapanta camacaycachir Moisesga Toldu ñaupanpa ichichiran guenchano cananpaj intëru tumarejpa. Nircorga tëlata waguiran puncu yaycunaman. Moisés llapanta camacächiyta ushaycuptin ");
INSERT INTO qub_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Tincuna Toldu jananpa pucutay chapacurcuran. Chaura Tayta Diospa achicyaynin juntacurcuran mas fiyupa rispitädu cajcho. ");
INSERT INTO qub_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Moisesga Tincuna Tolduman yaycuyta mana puydiranchu pucutay puñucuycusha captin, Tayta Diospa munayninpis chaycho junta ricacuptin. ");
INSERT INTO qub_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Pucutay chay Toldupita jogaricaptinraj Israelcunapis aywaycashanpa aywaj. ");
INSERT INTO qub_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","Pucutay mana jogaricaptenga paycunapis manami aywajchu. Chaypa ruquenga jinallanchömi goyaj pucutay jogaricänanyaj. ");
INSERT INTO qub_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Junajpami Tincuna Toldu janancho pucutay caycaj. Chacaypanami Tincuna Toldu janancho nina rataycaj. Llapan Israelcuna ricaymi pucutaypis ninapis caran. Chaynöllami caran Israel runacuna chunyajpa purishancamaga.");
INSERT INTO qub_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","Tayta Diosga Tincunan Toldupita gayaycur Moisesta cayno niran: ");
INSERT INTO qub_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","«Israel-masiquicunata willapanqui. Mayganpis ofrendata noga Tayta Diospaj apamorga apamuchun wäcata carpis, uyshata carpis. ");
INSERT INTO qub_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","«Rupachina sacrifisyupaj wäcancunapita apamorga sänu töruta apamonga. Tincuna Toldu puncu pampaman apaycur ñaupächo pishtanga. Chaynöpami noga Tayta Diospa shongöpäno canga. ");
INSERT INTO qub_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","Chaychönami apamoj runa uywapa umanman maquinta churanga chay runapa juchancuna perdunasha cananpaj. ");
INSERT INTO qub_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","Nircurnami noga Tayta Diospa ñaupächo chay töruta pishtanga. Aaronpa wamran cüracunana törupa yawarninta apanga Tincuna Tolduman yaycunacho caycaj altarman. Chaychöna altarpa cantuncunata chay yawarwan chajchonga. ");
INSERT INTO qub_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","Nircur rupachina sacrifisyupaj uywata apamoj runami uywapa garanta jorguriycur aychata pedäsu-pedäsu cuchonga. ");
INSERT INTO qub_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","Chaypitaga cüracunanami altarcho ninata ratarcachir yantata shancanga. ");
INSERT INTO qub_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","Chay jananmannami cuchushan aychacunata, umanta, pacha wirantapis churanga. ");
INSERT INTO qub_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","Rupachina sacrifisyupaj uywata apamöga pishtashan uywapa pachantawan macshuncunata mayllanga. Chaytapis cüracuna altarcho llapanta rupachenga. Rupachishanpa jömuynin noga Tayta Diospäga shongöpänömi canga. ");
INSERT INTO qub_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","«Rupachina sacrifisyupaj uyshata car u cabrata car apamorga sänu orgu cajta apamonga. ");
INSERT INTO qub_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","Chay uywataga ñaupächo pishtanga altarpa norte caj wajtancho. Aaronpa wamran cüracunana uywapa yawarninwan chajchonga altarpa cantuncunata. ");
INSERT INTO qub_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","Nircorga chay uywata apamoj runa aychata pedäsu-pedäsu cuchonga. Chay cuchushan aychata, umanta, pacha wirancunata cüracunana altarcho nina rataycajman churanga. ");
INSERT INTO qub_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","Chaypitana rupachina sacrifisyupaj uywata apamoj runaga uywapa pachantawan macshuncunata mayllanga. Chay rupachishanpa jömuynin noga Tayta Diospäga shongöpänömi canga. ");
INSERT INTO qub_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","«Rupachina sacrifisyupaj äbita nogapaj apamorga palumata car u pushapa wampata carpis apamonga. ");
INSERT INTO qub_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","Cüranami altarman apaycur chay äbipa cuncanta rachirenga. Yawarninta altarpa ñaupanman ushajpaj juturcachir cuerpuntana rupachenga. ");
INSERT INTO qub_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","Äbita apamoj runaga manaraj rupachiptinmi äbipa ucshintawan lümancunata jorgurir altarpa ñaupancho caycaj uchpaman jitarenga. ");
INSERT INTO qub_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","Nircurna älanpita charircur pullanpa ishcayman gasharenga. Ichanga ama ushajpäga päsachengachu. Nircur altarcho rupachenga. Rupachishanpa jömuyninmi noga Tayta Diospäga shongöpäno canga. ");
INSERT INTO qub_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","«Pipis noga Tayta Diospaj chaqui micuy ofrendata apamorga apamonga ñuchu caj jarinata. Chay jarinaman wiñanga asëtita. Insinsutapis churanga. ");
INSERT INTO qub_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","Nircur apanga Aaronpa wamran cüracunaman. Paycunana mayganpis asëtiwan tacusha caycaj jarinata juc aptayta altarman apaycur insinsuntawan rupachenga. Chayno rupachishanga canga ofrenda churaj runata yarpänäpämi. Chay rupachishanpa jömuyninnami noga Tayta Diospäga shongöpäno canga. ");
INSERT INTO qub_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","Chay rupachishanpita puchoj cajnami fiyupa rispitädu canga nogata garamashan ofrenda captin. Chaymi chay puchoj ofrendacunaga canga Aaronpaj, Aaronpita mirajcunapaj. ");
INSERT INTO qub_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","«Chaqui micuycunata ofrendapaj apamorga allinnin caj jarinapita asëtiwan masararcur lebadüraynajllata apamunqui. Chayta mana apamorga lebadüraynaj llapsha tantata rurarcur asëtiwan llushipashata apamunqui. ");
INSERT INTO qub_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","«Sartincho ancarcur chaqui micuy ofrendata apamorga alli caj jarinapita rurasha tantata apamunqui. Ichanga lebadüraynajllata asëtiwan chapunqui. ");
INSERT INTO qub_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","Chay ofrendata achcaman paquirir asëtita jananman wiñanqui. Chayga chaqui micuy ofrendami caycan. ");
INSERT INTO qub_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","«Chaqui micuyta mancawan ancarcur nogapaj ofrendata churarga churanqui ñuchu jarinawan rurashata, asëtiwan ancashata. ");
INSERT INTO qub_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","Chaycunata rurarcorga ñaupäman apamunqui. Nircur cürata entreganqui altarman apananpaj. ");
INSERT INTO qub_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","Paynami apamushayqui tantata ichicllata altarman apaycur rupachenga. Yarpänäpaj rupachishayquipa jömuyninmi nogapäga shongöpäno canga. ");
INSERT INTO qub_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","Puchoj caj ofrendana canga Aaronpaj, Aaronpita mirajcunapaj. Chay puchöga fiyupa rispitädumi canga nogata garamashan ofrenda captin. ");
INSERT INTO qub_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","«Noga Tayta Diospaj churananpaj caj chaqui micuy ofrendacunamanga lebadürata ama talluchengachu. Ama imaypis nogapaj rupachengachu lebadüratapis, abëjapa mishquintapis. ");
INSERT INTO qub_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","Lebadürata, abëjapa mishquinta noga Tayta Diospaj churarga churanga rimir-punta shuntar raquishan chaqui micuy ofrendantawan iwal. Ichanga altarcho ama rupachengachu jömuynin Nogapa shongöpäno cananpaj. ");
INSERT INTO qub_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","«Nogapäga ofrendancunata llapantapis cachiyojllata apamonga. Nogapaj ofrendataga llapantapis churanga cachiyojta. Cachiga imaypis yarpächin nogawan conträtu rurashantami. Chaymi ima ofrendamanpis cachita wiñapanqui. ");
INSERT INTO qub_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","«Rimir punta shuntar raquishan chaqui micuy ofrendacunata noga Tayta Diospaj apamorga agarir ancashata apamonga. ");
INSERT INTO qub_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","Chay chaqui micuy ofrendata nogapaj churarga asëtita wiñapanga. Insinsutapis churanga. ");
INSERT INTO qub_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","Cüranami chay ofrendapita wallcallata machcatawan asëtita, llapan insinsutapis rupachenga ofrendata apamoj runata yarpänäpaj. Chayga nogapaj rupachishan chaqui micuy ofrendami canga. ");
INSERT INTO qub_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","«Alli goyaypita sacrifisyuta apamorga china wäcata carpis töruta carpis sänuta apamonga. ");
INSERT INTO qub_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","Apamoj runaga uywapa uman jananman maquinta churanga. Nircur Tincuna Toldu ñaupancho pishtanga. Cüracunana uywapa yawarninwan chajchonga altarpa cantuncunata. ");
INSERT INTO qub_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","Nircurnami alli goyaypita sacrifisyuta apamoj runaga rupachinanpaj cürata gonga uywapa pacha wirancunata, ");
INSERT INTO qub_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","ruruncunata, mururupa ñaupancho caycaj ruru wirancunata, ñatinpa puntanta rurunnintinta. ");
INSERT INTO qub_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","Chaycunataga altarcho nina rupaycashan jananman cüracuna rupachenga. Rupachishanpa jömuyninmi nogapäga shongöpäno canga. ");
INSERT INTO qub_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","«Alli goyaypita sacrifisyupaj uyshata apamorga apamonga chinata carpis orguta carpis sänuta. ");
INSERT INTO qub_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","Uyshata apamorga ñaupächo ");
INSERT INTO qub_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","maquinta churanga uywapa uman jananman. Nircur Tincuna Toldu ñaupancho pishtanga. Cüracunana uywapa yawarninwan chajchonga altarpa cantuncunata. ");
INSERT INTO qub_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","Alli goyaypita sacrifisyupaj apamushan uywapataga nogapaj jorgonga wiranta, ushajpaj chupanta, pacha wirancunata, ");
INSERT INTO qub_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","ishcan ruruncunata, mururupa ñaupancho caycaj ruru wirancunata, ñatinpa puntanta rurunnintinta. Rurunta jorgojnöllami ñatinpa ñaupancho caycaj wirancunatapis jorgonga. ");
INSERT INTO qub_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","Chaycunataga cüranami altarcho rupachenga. Rupachishanna nogapäga canga sumaj alli micuy. ");
INSERT INTO qub_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","«Ofrenda apamushan cabra captenga ñaupächo pishtanan öra ");
INSERT INTO qub_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","chay cabrapa uman jananman maquinta churanga. Nircur pishtanga Tincuna Toldu ñaupancho. Cüracunana uywapa yawarninwan chajchonga altarpa cantuncunata. ");
INSERT INTO qub_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","«Chaypitanami nogapaj cabrata apamöga jorgonga chay uywapa pacha wirancunata, ");
INSERT INTO qub_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","ishcan ruruncunata, mururupa ñaupancho caycaj ruru wirancunata, ñatinpa puntanta rurunnintinta. Rurunta jorgojnöllami ñatinpa ñaupancho caycaj wirancunatapis jorgonga. ");
INSERT INTO qub_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","Chaycunataga cüranami altarcho rupachenga. Cabrapa wirancunaga nogallapämi canga. Rupachishanpa jömuyninpis Nogapäga shongöpäno canga. ");
INSERT INTO qub_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","«Maycho tiyarpis gamcunaga ama micunquichu wirata ni yawartapis. Chay nishäcunaga imaycamapis laymi canga gamcunapaj gamcunapita mirajcunapäpis.» ");
INSERT INTO qub_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","Chaypitana Moisesta Tayta Dios niran: ");
INSERT INTO qub_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","«Israel-masiquicunata willapanqui. Pipis mana yarpashapita laynëta mana cumlir llutanta rurar cayno ruranga: ");
INSERT INTO qub_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","«Mandaj cüra juchata ruraptenga llapan runami juchayoj ricaconga. Chaymi mandaj cüraga juchapita sacrifisyuta sänu töru-mallwata apamonga noga perdunanäpaj. ");
INSERT INTO qub_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","Tincuna Toldu ñaupanman apamonga. Nircur töru-mallwapa uman jananman maquinta churarcur ñaupächo pishtanga. ");
INSERT INTO qub_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","Quiquin mandaj cüranami töru-mallwapa yawarninta wallcallata charircur apanga Tincuna Tolduman. ");
INSERT INTO qub_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","Chaychömi dëdunta yawarman jatircur ñaupächo ganchis cuti tapsipanga mas rispitädu cuartuta chaparaj tëla cajman. ");
INSERT INTO qub_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","Insinsuta saumachicuna altar Tincuna Toldu ruricho caycajpa wagrancunatapis chay yawarwan pichupanga. Puchoj yawartana jicharenga Tincuna Toldu puncucho uywacunata rupachina altar caycaj chaquinman. ");
INSERT INTO qub_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","Nircur pishtashan töru-mallwapata jorgonga pacha wiranta, ");
INSERT INTO qub_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","ishcan ruruncunata, mururupa ñaupancho caycaj ruru wirancunata, ñatinpa puntanta rurunnintinta. ");
INSERT INTO qub_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","Chayta ruranga alli goyaypita sacrifisyuta rupachinanpaj wiranta jorgushannöllami. Chaycunatami uywacunata rupachina altarcho cüra rupachenga. ");
INSERT INTO qub_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","Töru-mallwapa garanta, aychanta, umanta, macshuncunata, pachanta, ashashninta ");
INSERT INTO qub_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","tiyarcaycashayquipita limyu partiman apanga. Chayga canga uchpata gotucunayquipaj acrashayquimi. Llapanta aparcur uchpa goturaycajman gaycurir yantata gotuycur ruparachenga. ");
INSERT INTO qub_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","«Llapan Israelcuna mana musyayninpa llutanta rurarga juchayojmi ricaconga. ");
INSERT INTO qub_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","Llutanta rurashanta tantiyacurerga llapanpaj juc töru-mallwata apanga. Tincuna Toldu ñaupanman apaycur ");
INSERT INTO qub_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","mayurcunana töru-mallwapa uman jananman maquincunata churanga ñaupächo. Nircur jinallancho pishtanga. ");
INSERT INTO qub_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","Mandaj cürana töru-mallwapa yawarninta wallcallata charircur apanga Tincuna Toldu ruriman. ");
INSERT INTO qub_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","Chaychömi dëdunta yawarman ushmarcachir ganchis cuti tapsipanga mas rispitädu cuartuta chaparaj tëla cajman. ");
INSERT INTO qub_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","Insinsu saumachicuna altar Tincuna Toldu ruricho caycajpa wagrantapis yawarwan pichonga. Puchoj yawartana jicharenga Tincuna Toldu puncucho uywacunata rupachina altar caycaj chaquinman. ");
INSERT INTO qub_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","Töru-mallwapataga jorgonga llapan wiranta. Nircur altarcho rupachenga. ");
INSERT INTO qub_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","Chay töru-mallwataga ruranga juchapita apashan töru-mallwata rurashannölla. Chaynömi cüraga ruranga llapan Israelcunapa juchanta perdunanäpaj. Chauraga juchancunapita perdunashanami canga. ");
INSERT INTO qub_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","Nircorga tiyaycashanpita juc-läman jorgurcur rupachenga imanöpis jucaj töru-mallwata rupachishanno. Chay juchapita sacrifisyu töru-mallwataga pishtanga Israelcunata perdunanäpämi. ");
INSERT INTO qub_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","«Juc mandajpis mana musyayninpa maygallantapis mandamintöta mana cumlir juchayojmi ricacun. ");
INSERT INTO qub_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","Jucha rurashanta tantiyacurerga sänu chïbuta apamonga sacrifisyupaj. ");
INSERT INTO qub_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","Chay chïbupa umanmannami maquinta churanga. Nircur pishtanga ñaupächo, uywacunata rupachinanpaj pishtanan cajcho. Chay sacrifisyupis caycan juchapita perdunasha cananpämi. ");
INSERT INTO qub_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","Juchapita sacrifisyupaj pishtashan uywapa yawarninman cüraga dëdunta töpachenga. Chaywannami uywacunata rupachina altarpa wagrancunata pichupanga. Puchoj yawartana rupachicuna altar chaquinman jicharenga. ");
INSERT INTO qub_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","Alli goyaypita sacrifisyuta garamashannömi juchapita sacrifisyuta pishtashanpa llapan wirantapis altarcho rupachenga. Cüra chayno ruraptin mandaj runa juchata rurashanga perdunashanami canga. ");
INSERT INTO qub_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","«Maygan cumun runapis mana musyayninpa laynëta mana cumlir juchayojmi ricacun. ");
INSERT INTO qub_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","Jucha rurashanta tantiyacurerga sänu china cabrata nogapaj apamonga. ");
INSERT INTO qub_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","Juchanpa ruquin apamushan cabrapa uman jananman maquinta churanga. Nircur pishtanga uywacunata rupachinanpaj pishtanan cajcho. ");
INSERT INTO qub_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","Cabrapa yawarninman cürana dëdunta töpachenga. Nircur uywacunata rupachina altarpa wagrancunata pichupanga. Puchoj yawartana altar chaquinman jicharenga. ");
INSERT INTO qub_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","Alli goyaypita sacrifisyutanömi llapan wiranta altarcho rupachenga. Rupachishanpa jömuynenga nogapa shongöpänömi canga. Cüra chayno ruraptinrämi chay runa juchata rurashanga perdunasha canga. ");
INSERT INTO qub_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","«Juchapita sacrifisyupaj cumun runa china uyshata apamorga apamonga sänuta. ");
INSERT INTO qub_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","Uyshapa uman jananman maquinta churarcur juchanpita perdunasha cananpaj pishtanga. Juchapita sacrifisyupaj apashan uywataga pishtanga uywacunata rupachina sacrifisyupaj pishtanan cajcho. ");
INSERT INTO qub_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","Cüranami dëdunta töpachenga juchapita sacrifisyuta pishtashan uyshapa yawarninman. Nircur uywacunata rupachina altarpa wagrancunata pichupanga. Puchoj yawartana altar chaquinman jicharenga. ");
INSERT INTO qub_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","Nircur alli goyaypita sacrifisyupaj uyshata garamashanno llapan wiranta jorgurcur altarcho rupachenga. Gayconga rupachiypa garaycämashanpa jananman. Cüra chayno ruraptinrämi chay runa juchanpita perdunasha canga. ");
INSERT INTO qub_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","«Pitapis ricashanta, wiyashanta cärananpaj gayachiptin mana cärarga paypis juchayojmi ricaconga. ");
INSERT INTO qub_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","«Pipis mana musyayninpa ganra cajcunata yatar ganranami ricaconga. Ganrami ricaconga mana micuna wañoj uywacunata chucaruta manshuta yatarpis, garachaypa purej curucunata yatarpis. Chaura ganra cajcunata yatarga juchayojnami ricaconga. ");
INSERT INTO qub_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","«Pipis mana musyayninpa ganra runata u ganra warmita u paycuna ganrayächishanta yatarga ganranami ricaconga. Yatashanta tantiyacurerga juchayojnami ricaconga. ");
INSERT INTO qub_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","«Mana musyayninpa pipis allita mana allita rurananpäpis jananta rurinta jurar, juclla mana tantiyarpis cuentata gocurerga juchayojnami ricaconga. ");
INSERT INTO qub_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","«Pipis chaycunata rurashanta tantiyacurerga perdunta mañacuchun. ");
INSERT INTO qub_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","Nircur juchapita sacrifisyuta nogata garamänanpaj apamonga uyshata carpis cabrata carpis chinata. Cüra garamaptinrämi runapa juchan perdunasha canga. ");
INSERT INTO qub_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","«Uyshapaj mana aypashpanga garamanga ishcay palumata car u ishcay pushapa wampata carpis. Jucaj canga juchapita sacrifisyuta pishtananpaj, jucajna rupachina sacrifisyupaj. ");
INSERT INTO qub_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","Chaycunataga cüraman apanga. Cüranami apashan cajta tipirenga. ");
INSERT INTO qub_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","Yawarnintana wallcallata altarpa cantuncunaman chajchupanga. Waquin yawartana altar chaquinman jutuchenga. Juchapita sacrifisyuta pishtashan uywaga canga apamoj runa juchayoj cashanpita perdunashana cananpämi. ");
INSERT INTO qub_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","Jucajtami ichanga rupachina sacrifisyupaj pishtanga willapashäno. Cüra chayno ruraptinrämi jucha rurashanga perdunasha canga. ");
INSERT INTO qub_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","«Ishcay palumata, u ishcay pushapa wampata rantinallanpäpis mana ayparga juchapita sacrifisyuta garamanga ishcay quïlu ñuchu caj jarinata. Juchapita sacrifisyu captin ama tacuchengachu asëtita, ni insinsutapis. ");
INSERT INTO qub_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","Cüraman apapanga. Paynami juc aptayta altarcho rupachenga ofrenda apaj runata noga yarpänäpaj. Chayta rupachenga waquin sacrifisyucunata rupaycächishan jananchömi. Chay ofrendaga juchapita sacrifisyu garamashanmi canga. ");
INSERT INTO qub_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","Cüra chayno ruraptinrämi ima juchata rurashanpitapis runaga perdunasha canga. Chaqui micuy ofrendata garamashannömi juchapita sacrifisyu garamashanpis puchoj cäga cürapaj canga.» ");
INSERT INTO qub_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","Moisesta Tayta Dios willaparan: ");
INSERT INTO qub_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","«Pipis mana musyayninpa Tayta Diospaj rispitädu cajcunata quiquinpaj quëdachicorga juchayojmi ricaconga. Chaura multata pägar uyshanpita sänu carnita Tayta Diospaj apamonga. Chay carniga duyñunman cutichina sacrifisyumi canga. Tincuna Tolducho caj pësacunawan pësarcur chay carnipa risyunta cüra täsanga. ");
INSERT INTO qub_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","Nogapaj rispitädu cajta quëdachicushantaga cutichinan. Chay jananmanna multata pägachun cada chuncapita ishcay mastaraj. Cutichina sacrifisyu carnita altarcho cüra rupachiptinnami quëdachicushanpita perdunasha canga. ");
INSERT INTO qub_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","«Mana musyayninpa noga nishäcunata mana cumlirpis juchayojnami ricaconga. ");
INSERT INTO qub_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","Chayno captenga uyshancunapita sänu carnita apamonga ayca chaninta apananpäpis cüra nishanno. Chay carniga cutichina sacrifisyumi canga. Chayta altarcho cüra rupachiptinmi juchayoj runa perdunasha canga. ");
INSERT INTO qub_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","Chay runa mandamintöcunata mana cumlishanpitami juchayoj caycan. Chaymi apamushan carniga cutichina sacrifisyu canga.» ");
INSERT INTO qub_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","Mastapis Moisesta Tayta Dios niran: ");
INSERT INTO qub_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","«Pipis ñaupächo juchatami ruran runa-masin mañashanta mana cutichir, ricapänanpaj paytacushanta mana cutichir, imantapis suwapar, firsapita guechur. ");
INSERT INTO qub_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","Juchatami ruran taricushanta ñïgar, u manacajpita ‹rasunpami› nir jurarpis. ");
INSERT INTO qub_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","Chayno rurasha carga duyñunman cutichinan suwapashanta, firsapita guechushanta, paytacuyta mana cutichishanta, taricushanta, ");
INSERT INTO qub_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","manacajpita ‹rasunpami› nir jurashanpitapis. Duyñunta cutichishanpa jananmanpis cada chuncapita ishcay mastaraj päganga cutichina sacrifisyuta garamashan öra. ");
INSERT INTO qub_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","Cutichinan sacrifisyupäga apamunan sänu carnita imanöta pägananpäpis cashanpita. Carnitaga cüraman apapanga juchanpa ruquin pishtananpaj. ");
INSERT INTO qub_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","Chayrämi yarpaypa ñaupächo maygan juchacunata rurasha carpis perdunasha canga.» ");
INSERT INTO qub_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","Moisesta Tayta Dios niran: ");
INSERT INTO qub_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","«Aarontapis wamrancunatapis uywacunata rupachina sacrifisyuta rurananpaj sumaj willapanqui: Pishtashan uywapa aychanga warayllata altar shanshacho rupanan. ");
INSERT INTO qub_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","Pacha wararcuptinna cüraga lïnu röpata jaticonga. Lïnupita rurasha ajürutapis jaticonga. Nircur altarcho rupachishan uywapa uchpanta shuntarcur altarpa ñaupallanman churanga. ");
INSERT INTO qub_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","Nircur cüra car jatiränan röpanta rucaconga. Chayno rucacuriycur-rämi uchpataga apanga uchpata gotunanpaj acrashan pachaman. Chay partiga canga tiyaycashancunapita juc-lächo. ");
INSERT INTO qub_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","«Altarchöga imaypis mana upiypa nina ratachun. Cüra cada tuta yantata yapanga nina mana upinanpaj. Uywapa aychantana jananman churanga rupachina sacrifisyupaj. Alli goyaypita sacrifisyupaj garamashan uywapa wirancunatapis rupachenga. ");
INSERT INTO qub_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","Altarchöga mana upiypa imaypis nina ratachun. ");
INSERT INTO qub_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","«Cananga willapanqui chaqui micuy ofrendacunata garamänanpaj: Cüracunami chaqui micuytaga ñaupächo altar cajman churanga. ");
INSERT INTO qub_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","Juc cürana asëtiwan tacusha jarinataga juc aptayta raquenga asëtintawan insinsuntawan. Chayta altarman apaycur rupachenga ofrenda apamoj runata yarpänäpaj. Rupachishanpa jömuyninnami nogapa shongöpäno canga. ");
INSERT INTO qub_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","Nogapaj ofrendata garamashan puchoj cajtaga lebadüraynajllatami Aaronpis wamrancunapis miconga. Miconga Tincuna Toldu puncun pampallacho. ");
INSERT INTO qub_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","Altarcho rupachishanpita puchoj cajtaga cüracunatami goycushcä. Chay micuypis juchapita sacrifisyunömi, cutichina sacrifisyunömi fiyupa rispitädu. Chaymi lebadürayojtaga ama cancangachu. ");
INSERT INTO qub_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","Chay micuycunataga Aaronpita miraj ollgucunallami miconga. Chay nishätaga imaycamapis cäsucunqui gamcuna y gamcunapita mirajcunapis. Chay micuyta pipis o imapis töpashan cajcunaga rispitädunami canga.» ");
INSERT INTO qub_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","Moisesta Tayta Dios niran: ");
INSERT INTO qub_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","«Aarón castacunapis cüra cayman chayar nogapaj chaqui micuy ofrendacunata apamonga. Apamonga ishcay quïlu jarinata. Pullantaga tutapa garamanga, pullantana tardipa. Waran-waran chaynölla ruranga. ");
INSERT INTO qub_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","Nogapaj churananpaj asëtiwan talluraycachir sartincho ancanga. Nircur tacsha tacshalla paquirir altarman churanga. Chay garamashanpa jömuynenga nogapaj shongöpänömi canga. ");
INSERT INTO qub_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","Aaronpita miraj mandaj cüra wañuptin ruquin yaycojpis chaynöllami ruranga. Ofrenda garamashantaga nogapa captin ushajpämi rupachenga. Imaycamapis chayno cananpaj noga Tayta Diosmi në. ");
INSERT INTO qub_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","Cüracuna garamashan ofrendataga llapanta rupachenga. Pipis ama micongachu.» ");
INSERT INTO qub_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","Moisesta Tayta Dios niran: ");
INSERT INTO qub_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","«Jucha rurashanpita pipis uywata garamänanpaj apamuptin Aarón y wamrancuna cayno rurananpaj willapay: Juchanpita sacrifisyu uywata apamur ñaupächo pishtanga. Pishtanga uywacunata rupachinanpaj pishtanan cajcho. Chayga nogallata garamänanpaj apamushanmi. ");
INSERT INTO qub_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","Juchapita sacrifisyuta pishtaj cürami chay aychata miconga. Ichanga miconga Tincuna Toldu puncun pampallacho. ");
INSERT INTO qub_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","Imapis chay aychata töpaj cäga rispitädumi ricaconga. Yawarnin röpaman pillchiptenga chay röpata tagshanga rejsisha rispitädu pachacho. ");
INSERT INTO qub_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","Aychata yanushan allpa mancataga paquirenga. Runsi mancawan yanusha car ichanga sumaj jichcaypa mayllanga. ");
INSERT INTO qub_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","«Chay sacrifisyuga nogallata garamänanpaj apamushan rispitädumi. Chaymi cüracunalla miconga. ");
INSERT INTO qub_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","Uywapa yawarninta Tincuna Tolducho mas rispitädu cajmanna apamusha carmi ichanga chay aychata cüra ama micongachu. Micunanpa ruquenga llapanta rupachenga. ");
INSERT INTO qub_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","«Cutichina sacrifisyuta garamashanga nogallapaj car rispitädumi. Chayta apamorga cayno ruranga: ");
INSERT INTO qub_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","Cutichina sacrifisyu uywataga pishtanga rupachinanpaj uywacunata pishtanan cajcho. Yawarninwanna chajchonga altarpa cantuncunata. ");
INSERT INTO qub_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","Chay uywapataga rupachenga wera chupanta, pacha wiranta, ");
INSERT INTO qub_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","ruruncunata, mururupa ñaupancho caycaj ruru wirancunata, ñatinpa puntanta rurunnintinta. ");
INSERT INTO qub_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","Chaycunataga cürami altarcho nogapaj rupachenga. Chay uywaga cutichina sacrifisyuta garamashanmi canga. ");
INSERT INTO qub_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","Aychataga cüracuna miconga micunanpaj acrashan pachallacho. Chay aychaga nogallapaj carmi rispitädu canga. ");
INSERT INTO qub_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","«Juchapita sacrifisyuta garamashan aychapis, cutichina sacrifisyuta garamashan aychapis chay öra rupachej cürapämi canga. ");
INSERT INTO qub_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","Rupachina sacrifisyupaj apamusha captenga uywapa garachallanmi rupachej cürapa derëchun canga. ");
INSERT INTO qub_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","Cuwasha caj chaqui micuy ofrendacunapis, mancacho u sartincho ancashacunapis chay öra garamaj cürapa derëchunmi canga. ");
INSERT INTO qub_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","Ichanga ofrendapaj apamushan chaqui micuycuna asëtiwan chapusha cajpis, jinaylla cajpis Aaronpita mirajcunapämi iwalcama canga. ");
INSERT INTO qub_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","«Sumaj yachacuchun alli goyaypita sacrifisyuta garamänanpaj. Cayno ruranga: ");
INSERT INTO qub_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","Agradësicamar sacrifisyupaj uywata apamorga jananmanpis apamonga asëtillawan chapusha lebadüraynaj tantata, asëtiwan pichusha lebadüraynaj llapsha tantata, asëtillawan chapurcur ancasha machca tantatapis. ");
INSERT INTO qub_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","Chay ofrendacunatawan iwalta apamonga lebadürayoj tantatapis. ");
INSERT INTO qub_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","Llapan apamushan ofrendapita nogapämi pägamajno jucta-cama raquenga. Chay raquishanga canga uywata pishtar yawarta chajchoj cürapa derëchunmi. ");
INSERT INTO qub_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","«Alli goyaypita sacrifisyuta agradësicamar pishtashan uywapa aychantaga chay junajlla ushajpaj miconga. Waranninpäga ni juc pedäsullatapis ama puchöchengachu. ");
INSERT INTO qub_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","Aunircamar uywata apamur, y shongun shacyaptin apamushan uywata pishtar ichanga puchuptenga waranninpis micunman. ");
INSERT INTO qub_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","Chay aychata ishcay junajta mana ushar quimsa junaj cajchöga ruparachengana. ");
INSERT INTO qub_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","Alli goyaypita sacrifisyuta garamashanta quimsa junaj cajcho micuptenga garamashanpis yangami canga; manami chasquishänachu. Aychapis melanaypämi canga. Chay aychata micoj cajpis juchayojna ricaconga. ");
INSERT INTO qub_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","« ‹Limyu› nishä runacunallami alli goyaypita sacrifisyuta pishtashan aychataga miconga. ‹Ganra› nishäman töpasha aychataga ama micongachu. Chaytaga ruparachengana. ");
INSERT INTO qub_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","«Alli goyaypita sacrifisyuta garamashantaga ‹ganra› nishä runacuna ama micongachu. Chay pishtashanga nogallapaj car rispitädumi. ‹Ganra› nishä caj runacuna micorga tiyashanpita gargushami canga. ");
INSERT INTO qub_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","«Pi runapis ‹ganra› nishä runata, ‹ganra› nishä uywata, ‹ganra› nishä jirca animalta töparga ama micongachu alli goyaypita sacrifisyuta garamashan uywapa aychanta. Micoj cäga tiyashanpita gargushami canga. Chay pishtashanga nogapaj car rispitädumi caycan.» ");
INSERT INTO qub_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","Moisesta Tayta Dios niran: ");
INSERT INTO qub_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","«Llapan Israelcunata willapanqui: Ama micongachu wäcapa, uyshapa, cabrapa wirancunata. ");
INSERT INTO qub_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","Ama micongachu aycha micoj animalcuna wañuchishan uywacunapa wirantapis, wañusha uywacunapa wirantapis. Micunanpa ruquin chay wirataga imachöpis manijanmanmi. ");
INSERT INTO qub_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","«Nogapaj rupachinanpaj garamashan uywapa wiranta micoj cäga gargucangami. ");
INSERT INTO qub_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","«Maycho tiyarpis ama micongachu uywapa yawarninta, pärejcunapa yawarninta. ");
INSERT INTO qub_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","Ima yawartapis micoj cäga pipis tiyashanpita gargushami canga.» ");
INSERT INTO qub_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","Moisesta Tayta Dios niran: ");
INSERT INTO qub_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","«Israel-masiquicunata willapanqui: Alli goyaypita sacrifisyuta garamänanpaj apamorga chay uywapa waquin aychanta ñaupäman apamonga. ");
INSERT INTO qub_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","Pipis quiquinmi nogapaj rupachinanpäga apamonga uywapa pëchu wiranta, quiquin pëchu aychanta. Chaychönami cuyuchir ricachimashpan entregamanga. ");
INSERT INTO qub_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","Nircur chay wirantaga cürami rupachenga altarcho. Pëchunmi ichanga canga cüracunapaj. ");
INSERT INTO qub_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","Alli goyaypita sacrifisyuta garamashan uywapa derëchu caj chancantaga cürapa derëchun captinmi payta goyconga. ");
INSERT INTO qub_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","Chay derëchu caj chancanga canga wiratawan yawarta garamaj cürapa derëchunmi. ");
INSERT INTO qub_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","Alli goyaypita sacrifisyuta Israelcuna cuyuchir ricachiypa garamashan uywapa pëchuntaga allinnin garamashantanömi acracushcä. Chancantanami pägata-japuy chasquishcä. Chaycunatanami Aaronta, paypita mirajcunata goycushcä. Chaura cüracunami imaycamapis chaycunataga chasquenga.» ");
INSERT INTO qub_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","Chaymi Tayta Diospaj rupachinanpaj sacrifisyuta apashanpita raquishancunaga canga Aaronpa, paypita mirajcunapa derëchun. Cüra cananpaj acrashanpita-pachami paycunaga chasquenga. ");
INSERT INTO qub_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","Chayno Israel runacuna goycunanpämi Tayta Dios nisha. Chaytaga niran cüra cananpaj churashan junajmi. Chay nishancunaga imaycamapis laymi canga Israelcunapaj Israelcunapita mirajcunapäpis. ");
INSERT INTO qub_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","Chaynömi willaparan rupachina sacrifisyupaj, chaqui micuy ofrendata garananpaj, juchapita sacrifisyuta rupachinanpaj, cutichina sacrifisyu cajpita, cürata acraptin, alli goyaypita sacrifisyu uywata garananpaj. ");
INSERT INTO qub_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","Israelcuna chunyaj Sinaïcho caycaptinmi Tayta Diosga Sinaí puntacho Moisesta willaparan imanöpis ofrendacunata payta garananpaj. ");
INSERT INTO qub_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","Moisesta Tayta Dios niran: ");
INSERT INTO qub_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","3","«Llapan Israel runacunata shuntanqui Tincuna Toldu ñaupanman. Quiquin Tincuna Toldu puncumanna Aaronta wamrancunatawan pushamunqui. Apamunqui cüra car jaticunan röpacunata, acrar wiñapänan alli asyaj asëtita, juchapita garamänanpaj töru-mallwata, ishcay carnicunata, balay canastawan lebadüraynaj tantatapis.» ");
INSERT INTO qub_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","Chaura Moisesga llapantapis ruraran Tayta Dios nishannölla. Chaymi llapan runacunata shuntaran Tincuna Toldu ñaupanman. ");
INSERT INTO qub_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","Shuntarcur Israelcunata Moisés niran: «Tayta Diosmi nimasha caycunata ruranäpaj.» ");
INSERT INTO qub_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","Chayno nirirmi Moisesga ñaupanman Aaronta wamrancunatawan gayarcur bäñaran. ");
INSERT INTO qub_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","Bäñariycorga Aaronta ajüruta jatiparcur wachcaparan. Jananmanna sotänata jatiparan, chaypa jananmanna mandil-niraj efodta. Nircur efodpa watullanwan chegllanpa sumaj wataparan. ");
INSERT INTO qub_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","Jananmanna wataparan pichëra-niraj pectoralta. Pectoralmanna wiñaparan «Urim» nishan «Tumim» nishan rumi-mallwacunata. ");
INSERT INTO qub_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","Nircur umanman shucutanta jatiparan. Urcun jananpana churaparan isquirbisha caycaj rispitädu gori vinchata. Chaycunata Moisesga ruraran Tayta Dios nishannömi. ");
INSERT INTO qub_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","Nircur Moisesga acrar wiñapäna asëtiwan chajchuran Tincuna Tolduta, chaycho caj cösacunatapis llapanta. Chauraga llapanpis rispitäduna caran. ");
INSERT INTO qub_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","Chay asëtillawan altartapis ganchis cuti chajchuran. Wiñaparan altarman, altarpa cösancunamanpis. Paylatapis jamanantinman wiñaparan. Llapanman asëtita wiñaparan Tayta Diospana car rispitädu cananpaj. ");
INSERT INTO qub_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","Chaypita Moisesga acrar wiñapäna asëtiwan Aaronpa umanman wiñaparan cürana cananpaj. ");
INSERT INTO qub_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","Aaronpa wamrancunatapis gayarcur ajüruta jatiparcur wachcaparan. Paycunapa umanmanpis shucutata jatiparan. Tayta Dios nishannömi llapantapis ruraran. ");
INSERT INTO qub_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","Nircurna Moisés apachimuran juchapita sacrifisyupaj caj töru-mallwata. Chay töru-mallwapa uman jananman Aarón wamrancunawan maquinta churaran. ");
INSERT INTO qub_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","Moisesna pishtariran töru-mallwata. Altar limyuna cananpaj dëdunwanna yawarta tawircur altarpa wagrancunata pichuran. Puchoj yawartana altarpa chaquinman jichariran. Chaynöpami altarga Tayta Diospaj acrashana caran janancho uywapa aychanta rupachiptin juchancunapita runacuna perdunasha cananpaj. ");
INSERT INTO qub_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","Moisesga pishtashan uywapa pacha wirancunata, ñatinpa puntanta, rurunpa wirancunata altarcho rupachiran. ");
INSERT INTO qub_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","Töru-mallwapa waquin aychanta, garanta, ashashninta tiyaycashanpita juc-läman apaycur rupaycachiran. Llapantapis Moisesga ruraran Tayta Dios nishannöllami. ");
INSERT INTO qub_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","Rupachina sacrifisyupaj caycaj carnitapis Moisés apachimuran. Carnipa uman jananman Aarón wamrancunawan maquinta churaran. ");
INSERT INTO qub_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","Pishtarerga Moisés yawarwan altarpa cantuncunata chajchuran. ");
INSERT INTO qub_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","Aychancunatana pedäsu-pedäsu cuchuran. Cuchushan aychata, umanta, wiranta rupachiran. ");
INSERT INTO qub_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","Uyshapa pachanta, macshuncunata yacuwan mayllariycur altarcho rupachiran. Rupachishanpa jömuynenga Tayta Diospa shongunpäno caran. Moisesga llapanta ruraran Tayta Dios nishannölla. ");
INSERT INTO qub_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","Chaypita jucaj carnitapis Moisés apachimuran. Chay carniga cüra cayman yaycur ofrendapaj churashanmi caran. Chay carnipa umanmanmi Aarón wamrancunawan maquinta churaran. ");
INSERT INTO qub_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","Moisesna pishtaran. Yawarninwanna pichuparan Aaronpa derëchu caj rinri llapllanta, derëchu caj maquinpa chaquinpa maman dëduntapis. ");
INSERT INTO qub_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","Aaronpa wamrancunatapis gayaran. Nircur yawarwan pichuparan derëchu caj rinri llapllanta, derëchu caj maquinpa chaquinpa maman dëduntapis. Puchoj yawarwanna altarpa cantuncunata chajchuran. ");
INSERT INTO qub_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","Chaypitana Moisesga uyshapa wiranta, chupanta, llapan pacha wiranta, ñatinpa puntanta, ishcan rurunta wirantinta, derëchu caj chancantapis jorguran. ");
INSERT INTO qub_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","Tayta Diospa ñaupanman balay canasta-mallwawan churashan lebadüraynaj juc tantata, ancasha machcata asëtillawan chapurcur rurasha tantata, juc llapsha tantata jorguran. Chaycunataga uyshapa wiranta chancanta churashanman churaran. ");
INSERT INTO qub_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","Chaycunataga Aaronta y wamrancunatami aptaparan. Paycunana cuyuchir ricachishpan Tayta Diosta entregaran cuyuchiypa ricachishan ofrenda cananpaj. ");
INSERT INTO qub_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","Paycunapa maquinpita chasquircurnami Moisesga altarcho rupachina sacrifisyuta rupaycächishan jananman churaran. Chay ofrendaga cüra cayman yaycunanpaj churashan ofrendami caran. Rupachishanpa jömuyninmi Tayta Diospa shongunpäno caran. ");
INSERT INTO qub_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","Moisesga uyshapa pëchun aychatana cuyuchir ricachishpan Tayta Diosta entregaran. Acrar rupachishan uyshapa pëchonga Moisespämi caran. Chaynömi Tayta Dios nisha caran. ");
INSERT INTO qub_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","Moisesga acrana asëtita, altar janancho caycaj yawartapis chajchuparan Aaronta, wamrancunata, cüra car jatiränan röpancunata. Chaynömi acraran Aaronta, wamrancunata, cüra car jatiränan röpancunatapis. ");
INSERT INTO qub_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","Nircur Moisesga Aaronta wamrantinta niran: «Tincuna Toldu puncucho aychata yanuy. Jinallancho micuy balay canasta-mallwacho acrasha caycaj tantantawan. Tayta Diospis nimasha: ‹Chay aychataga Aaronmi, wamrancunami miconga› nir. ");
INSERT INTO qub_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","Puchoj cajtana aychatapis, tantatapis rupachinqui. ");
INSERT INTO qub_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","Ganchis junajtarämi cüra cayman yaycunayquipaj caj timpu cumlenga. Chaymi ganchis junajyäga Tincuna Toldu pampapita ama maypapis yargunquichu. ");
INSERT INTO qub_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","Tayta Dios nishannöllami llapantapis cananga rurashcanqui jucha rurashayquipita perdunasha canayquipaj. ");
INSERT INTO qub_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","Chaymi gamcunaga Tincuna Toldu puncullacho goyäcunqui pagasta junajtapis ganchis junajcama. Mana wañunayquipaj Tayta Dios nishanta wiyacuy. Chayno ruranayquipämi Tayta Dios nimasha.» ");
INSERT INTO qub_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","Chayno niptin Aaronwan wamrancunaga llapantapis ruraran Moisesta Tayta Dios nishannölla. ");
INSERT INTO qub_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","Chaypita pusaj junaj cajcho Moisés gayaran Aaronta, wamrancunata, mayur Israelcunatapis. ");
INSERT INTO qub_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","Aarontana niran: «Tayta Diospa ñaupanman apay juchapita sacrifisyuta pishtanayquipaj töru-mallwata, sänu carnita rupachina sacrifisyupäpis. ");
INSERT INTO qub_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","Nircur Israel-masiquicunata ninqui juchapita sacrifisyupaj juc chïbuta apamunanpaj. Töru-mallwatapis, carni-mallwatapis apamonga watayojta-cama sänuta Tayta Diospaj rupachinanpaj. ");
INSERT INTO qub_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","Alli goyaypita sacrifisyuta garananpäpis apamonga juc törutawan juc carnita. Asëtillawan chapusha jarinatapis ofrendapaj apamonga. Canan junajmi Tayta Diosga munayniyoj cashanta musyachishunqui.» ");
INSERT INTO qub_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","Moisés «apamuy» nishancunata Israelcunaga llapanta aparan Tincuna Toldu ñaupanman. Llapan runacunapis Tayta Diospa ñaupancho ichirpaycaran. ");
INSERT INTO qub_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","Chaura Moisés niran: «Tayta Diosga chayno ruranayquipämi nisha. Nishanta ruraptiquega achicyaypa achicyarmi Tayta Diosninchi yuripäshunquipaj.» ");
INSERT INTO qub_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","Aarontana niran: «Juchapita sacrifisyuta y rupachina sacrifisyu uywatapis altarman apaycur pishtay. Chaycunaga canga gampis y wamrayquicunapis perdunasha canayquipämi. Chaypitana Israel runacuna apamushan caj uywacunata altarman apaycur pishtay paycunapis juchancunapita perdunasha cananpaj. Chayno ruranayquipämi Tayta Dios nisha.» ");
INSERT INTO qub_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","Chaura Aaronga juchapita sacrifisyu apashan töru-mallwata altarpa ñaupanman apaycur pishtaran. ");
INSERT INTO qub_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","Pishtariptinna wamrancuna yawarta apaparan. Chaura Aaronna yawarman dëdunta tawircur pichuran altarpa wagrancunata. Puchoj caj yawartana altarpa chaquinman jichariran. ");
INSERT INTO qub_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","Nircur juchapita sacrifisyuta pishtashan uywapataga altarcho rupachiran wirancunata, ruruncunata, ñatinpa puntanta. Llapantapis ruraran Moisesta Tayta Dios nishannölla. ");
INSERT INTO qub_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","Aychantawan garantami ichanga tiyaycashanpita juc-läman apaycur rupachiran. ");
INSERT INTO qub_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","Aaronga rupachina sacrifisyupaj caj uywatapis pishtaran. Chay uywapa yawarninta wamrancuna apaparan. Chaywan altarpa cantuncunata chajchuran. ");
INSERT INTO qub_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","Nircur apaparan rupachinanpaj caj uywapa umanta, cuchusha aychata. Aaronnami altarcho rupachiran. ");
INSERT INTO qub_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","Uywapa pachanta y macshuncunata mayllarcur waquinta rupachishannölla altarcho rupachiran. ");
INSERT INTO qub_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","Israelcuna juchapita sacrifisyupaj apamushan chïbutapis Aaronga Tayta Diosta garar pishtaran. Chaytapis quiquin perdunasha cananpaj rimir cajta pishtar rurashannömi juchapita sacrifisyupaj pishtaran. ");
INSERT INTO qub_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","Chaypitana rupachina sacrifisyuta pishtaran imanöpis rurananpaj Tayta Dios nishannölla. ");
INSERT INTO qub_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","Chaqui micuy ofrendatapis juc aptayta aparcur altarcho rupachiran. Chaytaga ruraran tutacuna rupachina sacrifisyuta rupachishanpitapis jananmanraj. ");
INSERT INTO qub_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","Alli goyaypita sacrifisyuta Israelcuna apashan törutapis carnitapis Aaronga pishtaran. Chay uywapa yawarninta wamrancuna apaparan. Chaura Aaronna altarpa cantuncunata chajchuparan. ");
INSERT INTO qub_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","Chaynöllami wamrancuna apaparan törupatawan uyshapa wiranta, chupanta, pacha wirancunata, rurunnincunata, ñatinpa puntancunata. ");
INSERT INTO qub_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","Chay wirancunatami pishtashan uywacunapa pëchuncuna jananman churaran. Nircurnami wirallanta altarcho Aarón rupachiran. ");
INSERT INTO qub_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","Aaronga uywapa pëchuntawan derëchu caj chancantami ichanga Moisesta Tayta Dios nishannölla cuyuchir ricachiypa Tayta Diospaj churaran. ");
INSERT INTO qub_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","Juchapita sacrifisyuta, rupachina sacrifisyuta, alli goyaypita sacrifisyuta apamushancunata altarman churarcurmi Aaronga Israel runacunapa jananpa maquinta jogarcur paycunata bindisyunta goran. Chaypitanami altarpa ñaupanpita uraran. ");
INSERT INTO qub_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","Nircur Aaronwan Moisés yaycuran Tincuna Tolduman. Chaypita llojshimur llapan Israel-masincunata bindisyunta goran. Chaura llapan Israelcuna ricaran Tayta Dios munayniyoj car achicyacurcojta. ");
INSERT INTO qub_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","Chaypitanaga Tayta Diospa ñaupanpita nina llojshimur rupacurcuran rupachinanpaj altarcho caycaj aychatawan wirata. Chayta ricar llapan Israelcuna cushicuypita gaparpar urcunpis pampaman töpananyaj umpuran. ");
INSERT INTO qub_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","Aaronpa wamrancuna Nadabwan Abiú insinsu saumachicunancunata charircärir saumachiran. Ichanga Tayta Dios nishanta mana wiyacur quiquinpa yarpayllanpita juc-niraj saumachiran. ");
INSERT INTO qub_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","Chaymi jinan öra Tayta Diospa ñaupanpita nina llojshimur paycunata rupar wañurachiran. ");
INSERT INTO qub_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","Chaypita Moisesna Aaronta niran: «Chayno päsananpaj captinmi Tayta Diosninchi niran: « ‹Ñaupäman yaycamojtaga Nogami tantiyachishaj santo captë wiyacamänanpaj. Acrashä Israelcunatami tantiyachishaj munayniyoj cashäta.› » Chayno niptin Aaronga imatapis mana rimacuranchu. ");
INSERT INTO qub_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","Chaypitana Moisesga gayachiran Aaronpa tiyun Uzielpa wamrancuna Misaeltawan Elzafanta. Paycunata niran: «Tincuna Toldu cajcho famillyayquicuna wañusha jitaraycajta tiyaycashanchïpita juc-läman apay.» ");
INSERT INTO qub_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","Chaura Moisés nishannöllami lïnu sotänan jatishallata wañushacunataga runacuna tiyashanpita juc-läman aparan. ");
INSERT INTO qub_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","Chaypita Moisesga Aaronta, Aaronpa wamrancuna Eleazartawan Itamarta niran: «Llaquicushpayqui gamcunaga ama ñajchacönega canquichu. Röpayquitapis ama rachicunquichu. Chayno rurashpayquega gamcunapis wañunquimanmi. Gamcuna janan Tayta Diosga llapan runacunatapis castigaycunmanmi. Tayta Dios castigar wañuchishanpitaga Israel castayquicunallami waganga. ");
INSERT INTO qub_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","Gamcunataga Tayta Diospaj acrana asëtiwanmi acrashcä. Chaymi mana wañunayquipaj Tincuna Toldu puncupita ama yargunquichu.» Chaura paycunaga imanöpis Moisés nishannöllami ruraran. ");
INSERT INTO qub_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","Chaypita quiquin Aarontapis Tayta Dios niran: ");
INSERT INTO qub_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","«Gampis ni wamrayquicunapis Tincuna Tolduman yaycunayquipaj caycarga ama upunquichu bïnuta, ni ima machächicojcunatapis. Chayno upucurcur yaycorga wañunquimanmi. Chay nishäcunaga imaycamapis laymi canga gamcunapaj gamcunapita mirajcunapäpis. ");
INSERT INTO qub_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","Chaymi cüra caycarga gamcuna tantiyacunqui maygan rispitädu cashanta, maygan mana rispitädu cashantapis; maygan limyu cashanta, maygan ganra cashantapis. ");
INSERT INTO qub_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","Nircur gamcunaga Moisesta willapashä laycunata yachachinqui llapan Israelcunata.» ");
INSERT INTO qub_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","Chaypita Moisesga Aaronta, Aaronpa wamrancuna Eleazarta, Itamarta niran: «Tayta Diospaj chaqui micuy ofrendata rupachinayquipaj apamushan puchojtaga lebadüraynajllata altarpa ñaupancho micunqui. Chayga Tayta Diospaj churasha car fiyupa rispitädumi. ");
INSERT INTO qub_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","Tayta Diospaj apamushan ofrendacunapita chay micuy gampäwan wamrayquicunapaj raquisha captinmi rispitädu pachacho micunqui. Chaynömi Tayta Dios nimasha. ");
INSERT INTO qub_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","Israelcuna alli goyaypita sacrifisyuta pishtashan uywapa pëchonga allinnin ofrendami cuyuchir ricachiypa Tayta Diosta entregasha captin. Chancannami pägashan-japuy canga. Chaycunataga derëchuyqui captinmi gampis, warmi ollgu wamrayquicunapis micunqui limyu pachacho. ");
INSERT INTO qub_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","Chay derëchu caj chancanga pägashan-japuymi. Pëchunnami caycan allinnin ofrenda cuyuchir ricachishpan Tayta Diosta entregasha captin. Chaycunataga wiracunata rupachinanpaj apashantawan iwal apanqui. Chaycunaga Tayta Dios nishannömi imaycamapis canga gampa, wamrayquicunapa derëchun.» ");
INSERT INTO qub_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","Chaypita Moisés tapuran «Juchapita sacrifisyuta pishtananchïpaj chïbu ¿maytaj?» nir. Chïbupa aychantaga mayna rupachishana caran. Chaymi Aaronpa ishcallanna wamran cawaycaj Eleazarta, Itamarta ollgöpar niran: ");
INSERT INTO qub_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","«¿Imanirtaj mana micushcanquichu juchapita sacrifisyuta pishtashayqui uywapa aychanta? Tayta Diospaj churasha caycaptenga rispitädu pachacho micunquiman-caran. Chaytaga gamcunatami Tayta Dios goycushurayqui Israelcunapa juchanpita altarcho rupachiptiqui perdunasha cananpaj. ");
INSERT INTO qub_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","Chay uywapa yawarninta Tincuna Toldu ruriman mana apaycarga pishtashayqui uywapa aychanta willapashänölla rispitädu pachacho micunquiman caran.» ");
INSERT INTO qub_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","Niptin Aarón niran: «Canan junaj wamräcunaga juchapita sacrifisyuta Tayta Diospaj pishtasha, rupachina sacrifisyu uywatapis rupachisha. Ichanga wañupacuynëpami mana micushcächu. Juchapita sacrifisyuta pishtashan uywapa aychanta micorga Tayta Diospaj ¿allitachuraj ruräman caran?» ");
INSERT INTO qub_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","Chayno niptin Moisesga imatapis mana rimacurannachu. ");
INSERT INTO qub_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","Aarontawan Moisesta Tayta Diosga niran: ");
INSERT INTO qub_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","3","«Israel-masiquicunata willapanqui: Llapan animaltami micunquiman chajchaj cajta, calla shilluyoj cajtaga. ");
INSERT INTO qub_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","Chajchaj captinpis calla shilluyoj captinpis ama micunquichu cay animalcunataga: «Camëllo aychata. Chajchaj captinpis shilluncuna manami callachu. Chay animaltaga ‹ganra› nir rejsinqui. ");
INSERT INTO qub_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","«Ama micunquichu gopi aychata. Chajchaj captinpis shillun manami callachu. Chay animaltaga ‹ganra› nir rejsinqui. ");
INSERT INTO qub_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","«Ama micunquichu wishcash aychata. Chajchaj captinpis shillun manami callachu. Chaytapis ‹ganra› nir rejsinqui. ");
INSERT INTO qub_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","«Ama micunquichu cuchi aychata. Shillun calla captinpis manami chajchanchu. Chay animaltaga ‹ganra› nir rejsinqui. ");
INSERT INTO qub_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","«Chay animalcunapa aychantaga ama micunquichu. Wañuptinpis ama yatayllapis yataycunquichu. Chaycunataga ‹ganra› nir rejsinqui. ");
INSERT INTO qub_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","«Yacucho tiyajcunata micunqui alëtayoj y pispayoj cajcunallata. ");
INSERT INTO qub_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","Alëtaynaj captin u pispaynaj captenga lamarcho tiyajtapis mayucho tiyajtapis, tacshatapis ni jatuntapis ‹ganra› nir rejsinqui. ");
INSERT INTO qub_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","Chaycunapa aychantaga ama micunquichu. Ganra captin wañushatapis melanäcunqui. ");
INSERT INTO qub_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","Yacucho tiyaj alëtaynaj y pispaynajcunataga llapan castata ganra captin melanäcunqui. ");
INSERT INTO qub_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","«Waquin cajtaga pärejcunatapis ama micunquichu. Chaypa ruquenga ganra captin melanäcunqui. Ama micunquichu: ancata, quebrantahuesosta, gocha ancata, ");
INSERT INTO qub_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","milanota, tucuy-niraj quillicsacunata, ");
INSERT INTO qub_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","tucuy-niraj cuervocunata, ");
INSERT INTO qub_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","avestruzta, chushyajta, gueullanchuta, llapan casta ancacunata, ");
INSERT INTO qub_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","tucuta, cormorán nishan yacu pätuta, ibista, ");
INSERT INTO qub_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","cisneta, pelicanota, wisculta, ");
INSERT INTO qub_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","cigüeñata, llapan casta garsata, abubillata, chicchitapis. ");
INSERT INTO qub_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","«Buylaj curu-mallwacunatapis, pampapa chuscun chaquinpa purej curu-mallwacunatapis llapanta ganra captin melanäcunqui. ");
INSERT INTO qub_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","Pintej cajcunatami ichanga micunqui päriypa purejcunatapis chuscu chaquinpa purejcunatapis. ");
INSERT INTO qub_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","Chayno captenga llapan casta chucluscuna, chüpacacuna allimi caycan micunayquipaj. ");
INSERT INTO qub_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","Waquin caj curucunataga buylaj captinpis, pampapa puriptinpis ganra captin melanäcunqui. ");
INSERT INTO qub_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","«Canan tantiyachishayqui imanöpa ganra ricacunayquipaj cashanta: «Chay ganra cajcunata maygantapis yatarga pacha chacashancamami ganra ricaconga. ");
INSERT INTO qub_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","«Chaycuna wañusha caycajta pipis jogarerga röpanta tagshaconga. Quiquinnami pacha chacänancama ganra canga. ");
INSERT INTO qub_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","«Ima animaltapis shilluncuna mana calla captenga, mana chajchaptenga ‹ganra› nir rejsinqui. Chay animalcuna wañuptin yataj cäga pipis ganrami ricaconga. ");
INSERT INTO qub_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","«Chuscu chaquiyoj animal chaqui-paltantin lluchcajtaga ‹ganra› nir rejsinqui. Chay animalcuna wañusha caycajta pipis yatäga pacha chacänancama ganrami ricaconga. ");
INSERT INTO qub_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","Chay ‹ganra› nishayqui animalcuna wañusha jitaraycajta jogarej cäga röpanta tagshaconga. Quiquinna pacha chacänancama ganra canga. ");
INSERT INTO qub_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","«Pachan garachaypa lätaypa purejcunatapis ‹ganra› nir rejsinqui waywashta, ucushta, llapan casta curucunata, ");
INSERT INTO qub_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","salamanquesata, cocodrilota, lagartota, tucuy-niraj shullashcunata, camaleoncunata. ");
INSERT INTO qub_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","«Chay animalcunatami garachaypa purej animalcunapitaga ‹ganra› nir rejsinqui. Pipis chay animalcuna wañusha caycajta yataycorga pacha chacänancama ganrami canga. ");
INSERT INTO qub_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","«Ganra animalcuna wañusha caycajman töparga ganrami ricaconga gueru, röpa, garacha carpis, custal carpis, iraminta carpis. Töpaptenga juclla yacuman jatirinqui. Pacha chacänancama ganra carpis nircorga limyunami canga. ");
INSERT INTO qub_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","«Ganra cajcuna wañushpan allpa mancaman shicwaptenga wiñayninpis ganranami canga. Chauraga allpa mancatapis paquirengana. ");
INSERT INTO qub_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","Chay mancapita yacu pillchir juc micuyman chayaptin chay micuypis ganrana ricaconga. Mancacho wiñaraycaj yacupis ganranami canga. ");
INSERT INTO qub_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","Ganracuna wañur ima jananmanpis shicwaptenga imapis ganrami ricaconga jurnu carpis, tullpa carpis. Chaycunataga ushajpaj juchuchinqui. Nircur gamcunapis ‹ganra› ninquina. ");
INSERT INTO qub_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","«Waquin yacu chayno ganrayaptinpis pucyu yacuwan upunayquipaj pösu yacuga limyumi caycanga. Yacupita wañusha ganra animalcunata jorgoj cajmi ichanga ganra ricaconga. ");
INSERT INTO qub_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","«Ganra animalcuna wañur murunayquipaj caycajman chayaptenga muru manami ganrachu canga. ");
INSERT INTO qub_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","Muru ushmasha jananman wañusha animalcuna chayaptinmi ichanga muruta ‹ganra› ninquicuna. ");
INSERT INTO qub_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","«Micunayquipaj caj uywa illajpita wañuptin pipis yataj cäga pacha chacänancama ganrami canga. ");
INSERT INTO qub_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","Quiquillan wañusha uywapa aychanta pipis micoj cäga röpanta tagshaconga. Chayno tagshacurpis pacha chacänancamami ganra canga. Chay wañusha uywata jorgoj cajpis röpanta tagshaconga. Chayno tagshacurpis pacha chacänancamami ganra canga. ");
INSERT INTO qub_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","«Ama micunquicunachu ima curucunatapis garachaypa lätaypa purejcunataga. Chay curucunataga ganra captin melanäcunqui. ");
INSERT INTO qub_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","«Garachaypa purej caj animalcunataga chuscu chaquinpa puriptinpis, mas achca chaquiyoj captinpis ama micunquichu. Chaycunaga ganra car melanaypaj animalcunami caycan. ");
INSERT INTO qub_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","Garachaypa purej animalcunata mayganiquipis ama yataychu. Yatarga melanaypaj ganrami ricacunquipaj. ");
INSERT INTO qub_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","Garachaypa purej animalcunata yataypa ama ganra ricacuychu. Nogami cä gamcunapa Tayta Diosniqui. Nogaga santumi cä. Chaymi gamcunapis nishäcunata wiyacamar santo cay-llapa. ");
INSERT INTO qub_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","Gamcunataga Egiptupita jorgamushcä Tayta Diosniqui canäpämi. Nogaga santumi cä. Chayno caycaptenga gamcunapis nishäcunata wiyacamar santo cay-llapa. ");
INSERT INTO qub_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","«Chay laycuna nishannömi caycan tucuy casta uywacunapaj, tucuy casta pärejcunapaj, yacucho tucuy casta cajcunapaj, tucuy casta garachaypa, lätaypa purejcunapäpis. ");
INSERT INTO qub_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","Chaynöpami musyanan caran maygan ganra cashanta limyu cashanta, micuna cashanta mana micuna cashantapis.» ");
INSERT INTO qub_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","Mastapis Moisesta Tayta Dios niran: ");
INSERT INTO qub_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","«Israel-masiquicunata willapanqui: Warmiga quilla gueshyanwan ganra cashannömi ollgu wamrata gueshyacushanpitapis ganchis junajcama ganra canga. ");
INSERT INTO qub_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","Ollgu wamrataga pusaj junajyojllatami pengayninpa punta garanta cuchonga. ");
INSERT INTO qub_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","Chaypitana mamanga yawarnin aywashanpita quimsa chunca quimsa (33) junajcama limyuyanga. Chaycamaga imatapis nogapaj acrashan rispitädu cajta manami yatananchu. Tincuna Toldu puncumanpis ama yaycongachu. ");
INSERT INTO qub_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","Warmi wamrata gueshyacorga quilla gueshyan aywaptin ganra cashanno ishcay semänami ganra canga. Nircur yawarnin aywashanpita purificaconga sojta chunca sojtan (66) junajcama. ");
INSERT INTO qub_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","«Ollguta u warmita gueshyacusha carpis limyuyashanpitanaga Tincuna Toldu ñaupanman apamonga watayoj cashnita rupachina sacrifisyupaj. Juchapita sacrifisyupäna apamonga juc pushapa palumata carpis wampata carpis. Chaytaga Tincuna Toldu puncuchömi cürata entreganga. ");
INSERT INTO qub_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","Cüranami chay uywacunata nogapa ñaupächo rupachenga warmipa yawarnin aywashanpita limyuna cananpaj. Chayrämi warmiga yawarnin bäjashanpita limyuyanga. «Chaynömi warmiga ruranga ollgu ni warmi wamrancunata gueshyacurpis. ");
INSERT INTO qub_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","Uyshata rantinallanpäpis warmi mana aypashpanga apamonga ishcay pushapa palumata, man'chäga ishcay wampata. Jucäga canga juchapita sacrifisyupaj, jucajna rupachina sacrifisyupaj. Chaura cüranami warmi perdunasha cananpaj mañaconga. Chaynöpami chay warmiga limyuna canga.» ");
INSERT INTO qub_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","Aarontawan Moisesta Tayta Dios niran: ");
INSERT INTO qub_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","«Pipapis janan jacaptin, pashtapäcuptin, janancho gueri-niraj yuraj-yuraj yuriptin cüra Aaronman apanga. Man'chäga Aaronpita mirar aywaj cüracunamanpis apanga. ");
INSERT INTO qub_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","Cürana chay runapa guerinta ricanga. Guericho caycaj ajcha yur'gacäcusha captin, chaynöpis gueri uchcucasha captenga lepranami canga. Chaura chay runata sumaj ricaycur cüraga ‹ganra› nenganami. ");
INSERT INTO qub_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","«Runapa garan yur'gasha captinpis guerin mana uchcucasha captenga, u ajchanpis mana yur'gaptenga chay runata cüra shuyni goyächenga ganchis junajcama. ");
INSERT INTO qub_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","Ganchis junajta yapay ricanga. Gueri mana miraptenga yapay ganchis junajcama shuyni goyächenga. ");
INSERT INTO qub_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","Ganchis junajta cüraga yapay ricanga. Gueri allchacaypana aywaptenga ‹limyu› nenganami cüraga. Lluta guerillami casha canga. Gueshyaj cajpis röpanta tagshaconga. Chaypitaga limyuna canga. ");
INSERT INTO qub_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","«Cüra ricarcur ‹limyu› nishanpitaraj guerin jatunyacurcuptenga yapay cutenga cüra ricananpaj. ");
INSERT INTO qub_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","Guerita cüra ricashpan yur'gaypa yur'gar miraycajta ricar cüra tantiyaconga leprana cashanta. Chaymi cüraga ‹ganra› nengana. ");
INSERT INTO qub_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","«Pï runatapis lepra gueshya charisha captenga cüraman apachun. ");
INSERT INTO qub_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","Cüranami imano cashantapis ricanga. Garan jacashpan yur'gacäcuptin, ajchanpis yur'gacäcuptin, gueri chaupincho llullu aychana ricacaptenga ");
INSERT INTO qub_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","pogucasha lepranami canga. Chaura chay runata cüraga ‹ganra› nenganami. Ganra captin manami musyananpaj shuyni goyächenganapischu. ");
INSERT INTO qub_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","«Chay runapa garancho yurircur rätu mirar chaquipita umancama yur'gaypa yur'gar yagacuriptenga ");
INSERT INTO qub_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","cüra sumaj ricanga allchacashantana u mana allchacashantapis. Chaquipashpan yur'gaypa yur'gar intëru cuerpunpa ñitiptenga cüra ‹limyu› nenganami. ");
INSERT INTO qub_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","Janancho gueri pashtacaramuptin ichanga chay runa ganrana ricaconga. ");
INSERT INTO qub_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","Gueri pashtamushanta ricar cüra ‹ganra› nenga. Yur'gasha aychapa chaupincho pashtacaramoj guerimi ganra. Chaymi lepra caycan. ");
INSERT INTO qub_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","Pashtacaramushan gueri chaquipaptin aywanga cüra ");
INSERT INTO qub_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","ricananpaj. Gueri chaquipasha captenga cüra ‹limyu› nenganami. ");
INSERT INTO qub_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","«Pipapis garancho gueri allchacarcur ");
INSERT INTO qub_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","llullu aychan cuticaypana aywaptin, man'chäga pucayaypa pucayar ricacuptin ricananpaj cüraman aywanga. ");
INSERT INTO qub_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","Gueri uchcucasha caycajta ricar, u ajchapis yur'gashana captin cüraga ‹ganra› nenganami. Chay guerenga lepranami canga. ");
INSERT INTO qub_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","Guericho ajchapis mana yur'gasha captin, aychanpis mana uchcucasha captin, allchacaycajnöna captenga ganchis junajcama shuynilla goyächenga. ");
INSERT INTO qub_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","Guerin miraptin cüraga runata ‹ganra› nenganami. Guerenga lepranami canga. ");
INSERT INTO qub_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","Gueri allchacashan mana miraptin jinallancho cacuptenga sirallanami canga. Chaura cürapis ‹limyu› nenganami. ");
INSERT INTO qub_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","«Pipis rupacuptin, garan yur'gacäcuptin u pucayacäcuptenga ");
INSERT INTO qub_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","cürana ricanga. Yur'gasha aycha caycajcho ajcha yuraj ricacuptin, aychan uchcucasha captenga rupacushancho lepranami yuricurisha canga. Chayta ricar cüraga ‹ganra› nenganami lepra captin. ");
INSERT INTO qub_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","Cüra ricaptin, yur'gasha aychancho yur'gasha ajcha mana captin, gueri mana uchcucasha captin, allchacaycaptinnaga cüra ganchis junajcama shuynilla tiyachenga. ");
INSERT INTO qub_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","Ganchis junajtaga yapay ricanga. Yur'gaycaj guerin jatunyashana captenga ‹ganra› nenganami. Chayga lepranami canga. ");
INSERT INTO qub_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","Gueri jinallancho cacuptenga, mana risipïluptenga rupashallanpitachari sirayasha canga. Chaura gueshyaycaj runata cüraga ‹limyu› nenganami. ");
INSERT INTO qub_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","«Ollgupa, warmipapis umancho gueri captin, quijädancho gueri captin ");
INSERT INTO qub_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","cürami sumaj ricanga. Gueri uchcucasha captin, guericho caj ajchanpis garwashtaptenga cüra nenga chay runa u chay warmi ganra cashanta. Umancho u chacallwancho carpis chay gueriga lepranami canga. ");
INSERT INTO qub_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","Uma guerin mana uchcucaptin, ajchanpis mana yana captenga gueriwan caycaj runata ganchis junajcama shuynilla tiyachenga. ");
INSERT INTO qub_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","Ganchis junajman chayarcuptin cüra yapay ricanga. Gueri mana jatunyasha captin, mana uchcucasha captin, ajchanpis mana garwashyasha captenga ");
INSERT INTO qub_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","cüra rutucachenga. Gueri caycashanpa ichanga ama rutucachengachu. Nircur ganchis junaj yapay shuynilla tiyachenga. ");
INSERT INTO qub_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","Ganchis junajpitaga guerita yapay cüra ricanga. Gueri mana jatunyaptin, mana uchcucaptenga gueriwan gueshyaycaj runata ‹limyu› nenganami. Runapis röpancunata tagshacurir limyuna canga. ");
INSERT INTO qub_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","‹Limyu› nishanpitaraj chay gueri jatunyayta gallaycuptenga ");
INSERT INTO qub_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","chay runata cüra yapay ricanga. Gueri jatunyashatana ricar manana ashenganachu ajchan garwashyashatapis. Chay runataga ‹ganra› nengana. ");
INSERT INTO qub_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","Gueri jinallancho garapaptin, yana ajchana wiñaptenga musyanga gueri allchacaycashantanami. Chayno captenga gueriwan gueshyaycaj limyuna cashantami cüra nenga. ");
INSERT INTO qub_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","«Ollgupa, warmipapis janancho cancha yuricuriptenga ");
INSERT INTO qub_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","cüra ricanga ima cashantapis musyananpaj. Ricaptin ogui-ogui captenga lluta yurej canchallami canga. Chayno captenga chay runa limyumi canga. ");
INSERT INTO qub_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","«Pipapis ajchan ushacäcuptin sepla ricacurpis limyumi caycan. ");
INSERT INTO qub_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","Urcullanpa ajchan ushacäcuptin galana ricacurpis limyumi. ");
INSERT INTO qub_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","Gala umancho, urcuncho, matancanchöpis pucaypa pucar gueri yuricurcuptin ichanga lepranami canga. ");
INSERT INTO qub_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","Chayno captin cüra ricanga. Cuerpucho lepra yurishanno pucaypa pucar gueri yurir jacacurcuptenga ");
INSERT INTO qub_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","chay runapa uma guerin lepranami canga. Chaura cüraga ‹ganra› nenganami. ");
INSERT INTO qub_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","«Lepra gueriyöga purinman röpanpis rachir-ushasha, ñajchacönilla, cäran chapacushalla ‹Ganrami caycä, ganrami caycä› nir gayacuraycar. ");
INSERT INTO qub_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","Guerin mana allchacashancamaga pipis ‹ganra› nengami. Gamcuna tiyaycashayquipita mas juc-lächömi allchacänancama japallan tiyaconga. ");
INSERT INTO qub_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","«Lïnu röpacho, millwa röpacho, ");
INSERT INTO qub_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","lïnu awacho, uysha awacho, garachacho, garachapita rurashacho carpis ");
INSERT INTO qub_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","mupallejno berdiyaypa pucayaypa-niraj yurerga canga leprami. Chayno captin cürata ricachenga ima cashantapis musyananpaj. ");
INSERT INTO qub_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","Cüraga sumaj ricaycur mupallisha captin ganchis junaj wichgarächenga. ");
INSERT INTO qub_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","Ganchis junajtaga ricanga. Röpacho, awacho, garachacho, garachapita rurashancho mupallishan jatunyaptenga canga fiyu lepranami. Chauraga ganranami canga. ");
INSERT INTO qub_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","Chaymi mupallisha cäga ushajpaj rupachicanga fiyu leprayoj captin. ");
INSERT INTO qub_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","Cüra yapay ricaptin mupallishan manana masta miraptin ichanga ");
INSERT INTO qub_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","mupallishanta tagshachenga. Nircur yapay wichgayconga ganchis junajcama. ");
INSERT INTO qub_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","«Tagsharcuptin cüra yapay ricanga. Mupallishan mana illgasha captenga ganrami canga. Chaura mupallisha cäga imapis rupachicanga. Jananpa u rurinpa mupallisha captinpis ruparachenga. ");
INSERT INTO qub_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","Tagshashanpitaraj cüra ricaptin mupallishan illgasha captinpis manchalla quëdaptenga röpapita, garachapita, awapita carpis rachiypa jorgurenga. ");
INSERT INTO qub_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","Ichanga rachir jorgushanpitaraj yapay röpacho, awacho, garachapita rurashancho mupalliptenga jinanpana rupaycachenga. ");
INSERT INTO qub_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","Röpacho, awacho, garachapita rurashacunacho tagshariptin mupallishan illgaptenga yapay tagshanga. Chaypitaga limyunami canga.» ");
INSERT INTO qub_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","Chaynömi lay caran röpacho, millwacho, lïnucho, awacho garachapita cajcho mupalliypa lepra yuriptin imano rurananpäpis. Imanöpis cashanta ricaycurmi limyu cashanta ganra cashantapis cüra nej. ");
INSERT INTO qub_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","Moisesta Tayta Dios niran: ");
INSERT INTO qub_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","«Leprawan gueshyajcuna allchacashanpita limyuyänanpaj cayno ruranga: Leprapita allchacäga cüraman willacachenga. ");
INSERT INTO qub_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","Chaura cüranami runacuna tiyaycashanpita caruman aywanga leprawan gueshyashan runata ricananpaj. Lepra gueshya allchacashana captenga ");
INSERT INTO qub_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","limyuyänanpaj apachimonga ishcay limyu äbi cawaycajta, sedru gueruta, puca tëlata, chajchucuna jachata. ");
INSERT INTO qub_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","Nircorga jucaj äbita wañurcachir yawarninta jutuchenga allpa mancacho pucyu yacu caycajman. ");
INSERT INTO qub_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","Chay pucyu yacu yawarniyoj caycajman ushmachenga cawaycaj äbita, sedru gueruta, puca tëlata, chajchucuna jachata. ");
INSERT INTO qub_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","Nircur leprawan gueshyashanpita allchacaj runatapis limyuna cananpaj yawarwan ganchis cuti chajchupanga. Cawaycaj äbitana aywacunanpaj cachayconga. ");
INSERT INTO qub_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","«Limyuyaj runaga röpanta tagshaconga; ushajpaj rutuconga, bäñaconga. Chaypitaga limyunami canga. Ichanga ganchis junajcama juc-lällacho goyanga. Chaypitaraj toldunman cutenga. ");
INSERT INTO qub_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","Ganchis caj junajchönaga ushajpaj ajchanta seplaypa rutuconga, shapranta, ñawi janan sëjasnintapis. Ajchan cajtaga ushajpämi garaypa afitaconga. Quiquinpis bäñaconga, röpancunatapis tagshaconga. Chayrämi limyu cangapaj. ");
INSERT INTO qub_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","«Chay limyuyaj runaga pusaj junaj cajcho chaqui micuy ofrendapaj apapämanga ishcay sänu cashnita, watayoj sänu china uyshata, sojta quïlu medyan allinnin jarinata asëtiwan chapushata, medyu litrupaj pishirpoj asëtitapis. ");
INSERT INTO qub_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","Cüraga limyuyänanpaj caycaj runatapis, ofrendancunatapis Tincuna Toldu ñaupanman apamonga. ");
INSERT INTO qub_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","Nircur cüraga juc cashnita y asëtitawan nogapa ñaupächo cuyuchir ricachimashpan entregamanga cutichina sacrifisyu cananpaj. ");
INSERT INTO qub_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","Chay cashnitaga pishtanga juchapita sacrifisyuta pishtanan cajcho, rupachina sacrifisyuta pishtanan cajcho. Cutichina sacrifisyupaj pishtashan aychapis juchapita sacrifisyu aychanömi cürapa derëchun canga. Chaycunaga nogallapaj car fiyupa rispitädumi. ");
INSERT INTO qub_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","«Nircur cutichina sacrifisyuta pishtashan uywapa yawarninta charircurna limyuyaj runata pichupanga derëchu caj rinri llapllanta, derëchu caj maquinpa chaquinpa maman dëdunta. ");
INSERT INTO qub_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","Cüraga ichoj caj maqui paltanman wiñanga ichiclla asëtita. ");
INSERT INTO qub_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","Nircur derëchu caj dëdunta asëtiyoj maquinman ushmachenga. Chaywanmi ñaupäman ganchis cuti tapsenga. ");
INSERT INTO qub_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","Maquincho caycajraj asëtita tawircur cüraga limyuyaj runata pichupanga derëchu caj rinri llapllanta, derëchu caj maquinpa chaquinpa maman dëdunta. Chayno ruranga cutichina sacrifisyuta pishtashan uywapa yawarninta pichupashan jananmanna. ");
INSERT INTO qub_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","Puchoj caj asëtitana limyuyajpa umanman pichupanga. Chayno cüra ruraptinrämi chay runapa juchanta perdunashaj. ");
INSERT INTO qub_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","Nircur cüraga juchapita sacrifisyuta pishtananpaj uyshata apanga. Chaynömi ruranga runa juchanpita limyuyänanpaj. Nircorga rupachina sacrifisyupaj caycaj uywatapis pishtangana. ");
INSERT INTO qub_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","Altarchöna rupachenga chaqui micuy ofrendata garamashantawan. Cüra chayno ruraptinrämi chay runa limyuyanga. Chaypitaga chay runa limyuna canga. ");
INSERT INTO qub_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","«Pobri carga cutichina sacrifisyuta pishtananpaj juc cashnillata apamonga. Altar ñaupanchöna cuyuchir ricachimanga chay runa limyuna cananpaj. Asëtiwan chapusha ishcay quïlu masnin alli jarinatapis apamonga. Chay canga chaqui micuy ofrendami. Apamonga medyu litrupaj pishircoj asëtita, ");
INSERT INTO qub_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","ishcay wampata, man'chäga ishcay pushapa palumatapis. Aypäpacushan-tupulla apamonga. Jucaj paluma canga juchapita sacrifisyupaj. Jucajna canga rupachina sacrifisyupaj. ");
INSERT INTO qub_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","Chaycunataga limyuna cananpaj cüraman apanga pusaj caj junajcho. Ñaupächömi Tincuna Toldu ñaupancho llapan apashanta cürata entreganga. ");
INSERT INTO qub_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","Cürana cutichina sacrifisyuta pishtananpaj caj uyshata y asëtita apamonga. Chay sacrifisyutaga ñaupächo cuyuchir ricachimanga. ");
INSERT INTO qub_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","Chaypitaga cutichina sacrifisyuta pishtananpaj apashan uyshatapis pishtanga. Chay pishtashan uywapa yawarninta charishanwanna limyuyaj runata pichupanga derëchu caj rinri llapllanta, derëchu caj maquinpa chaquinpa maman dëdunta. ");
INSERT INTO qub_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","Chaypitana cüraga ichiclla asëtita ichoj caj maqui paltanman wiñanga. ");
INSERT INTO qub_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","Nircur derëchu caj dëdunta asëtiyoj maquinman ushmachenga. Nircur ñaupäman ganchis cuti tapsenga. ");
INSERT INTO qub_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","Maquincho caycajraj asëtiman tawircur cüraga pichupanga limyuyaycaj runapa derëchu caj rinri llapllanta, derëchu caj maquinpa chaquinpa maman dëdunta. Chayno ruranga cutichina sacrifisyuta pishtashan uywapa yawarninta pichupashan jananmanmi. ");
INSERT INTO qub_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","Maquincho puchoj caj asëtitana limyuyaj runapa umanman pichupanga. Chaynömi cüra ruranga chay runa ñaupächo limyuna cananpaj. ");
INSERT INTO qub_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","Ofrendanta apamöga tarishan-tupulla apamonga. Chaytana cüraga juc wampata carpis, pushapa palumata carpis altarcho rupachenga. ");
INSERT INTO qub_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","Jucaj äbi canga juchapita sacrifisyupaj, jucajna rupachina sacrifisyupaj. Chaycunataga nogapaj churanga chaqui micuy ofrendata garamashanpa jananmanraj. Chaynömi cüra ruranga limyuyayta munaj runata limyuyächishpan.» ");
INSERT INTO qub_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","Chaynömi lay canga leprawan gueshyashanpita pobricuna allchacar limyuyänanpaj. ");
INSERT INTO qub_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","Aarontawan Moisesta Tayta Diosga niran: ");
INSERT INTO qub_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","«Gamcunata goycunäpaj caycaj Canaán nasyuncho tiyaycaptiqui maygayquipa wasiquichöpis mupalliypa yuriptenga ");
INSERT INTO qub_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","wasiyojmi aywarcur cürata willanga: ‹Wasëchömi mupalliypa yuriycan› nir. ");
INSERT INTO qub_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","«Chauraga cüra aywashpan jawallapita nenga: ‹Wasipita llapanta jäcachiy. Man'chäga llapanmi ganra ricaconga› nir. Nircur-rämi cüraga wasiman yayconga mupallishan imano caycashantapis ricananpaj. ");
INSERT INTO qub_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","«Wasipa pergancunacho berdi-berdi, puca-puca caycajta ricar, ruriman perga yaycucasha caycajta ricarga ");
INSERT INTO qub_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","wasipita llojshiconga. Wasiyojtana nenga ganchis junajcama wasita wichgarächinanpaj. ");
INSERT INTO qub_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","Ganchis junajta cüraga yapay ricaj cutenga. Mupalliycaj jatunyasha caycajta tarerga ");
INSERT INTO qub_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","cüra nenga ‹mupallisha caj rumicunata jorguy. Marca wajtan ganra jitaricunaman jitariy. ");
INSERT INTO qub_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","Wasipa rurintana intërunta jichcay. Jichcashayqui ñuchu allpatapis marca wajtan ganra jitaricunaman jitariy› nir. ");
INSERT INTO qub_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","Nircorga jorgushan rumicunapa ruquin juc rumitana churanga. Ribucananpaj mitutapis juc allpapitana ruranga. ");
INSERT INTO qub_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","«Rumita jorgushanpita, intërunta jichcashanpita, juc mituwanna mitushanpita wasi ruricho yapay mupallicurcuptenga ");
INSERT INTO qub_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","cüra yapay ricaj yayconga. Wasi ruricho achca pachapana mupallisha captin cüraga ‹ganra› nenganami. ");
INSERT INTO qub_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","Chayno captin wasitaga ushajpaj juchurachenga. Allpancunata, gueruncunatana marca wajtan ganra jitaricunaman jitarenga. ");
INSERT INTO qub_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","Ganchis junaj wichgaränanpaj cüra niycaptin pipis chay wasiman yaycoj cäga pacha chacänancama ganrami canga. ");
INSERT INTO qub_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","Chay wasicho pipis micoj u puñoj cäga limyu cananpaj röpanta tagshanga. ");
INSERT INTO qub_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","«Wasita ribucashanpitaraj cüra ricar ganrata manana tarir ‹Cay wasiga limyumi› nengana. Mupalliyga illgashana canga. ");
INSERT INTO qub_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","Wasipa duyñonga wasi limyuyänanpaj apanga ishcay äbita, sedru gueruta, puca tëlata, chajchucuna jachata. ");
INSERT INTO qub_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","Juc äbita wañurcachir yawarninta jutuchenga yacu wiñaraycaj allpa mancaman. Chay yacuga pucyupita chagamushami canga. ");
INSERT INTO qub_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","Wañuchishan äbipa yawarninwan, pucyu yacuwan ushmachenga cawaycaj äbita, sedru gueruta, puca tëlata, chajchucuna waytata. Chaywanga ganchis cutimi wasita chajchonga. ");
INSERT INTO qub_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","Chaynömi wasita limyuyächenga äbipa yawarninwan, pucyu yacuwan, cawaycaj äbiwan, sedru gueruwan, chajchucuna jachawan, puca tëlawan. ");
INSERT INTO qub_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","Chayno rurarcurnami cawaycaj äbitaga marca wajtanpita cachariyconga. Chaynömi wasi limyuna cananpäga ruranga.» ");
INSERT INTO qub_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","Chaynömi lay caran lepra gueshyapaj, uma gueripaj, ");
INSERT INTO qub_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","röpacho leprapaj, wasicho mupallejpaj, ");
INSERT INTO qub_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","jacapäcuypaj, pashtapäcuypaj, cancha yurejpaj. ");
INSERT INTO qub_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","Chay laycunata wiyacurmi imanöpis cashanpita limyu cashanta ganra cashantapis nej. Chaycunami leprapaj laycuna casha. ");
INSERT INTO qub_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","Aarontawan Moisesta Tayta Diosga niran: ");
INSERT INTO qub_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","«Gamcuna Israel runacunata cayno willapanqui: Pï runapapis chiullacunanpa mana chawaypa yuraj yacu llojshiptin ganrami ricaconga. ");
INSERT INTO qub_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","Pï runapis chayno ganrami ricaconga yuraj yacu llojshiycaptinpis, u pengaynin chapacäcuptinpis. Mayganno captinpis ganrami ricaconga. ");
INSERT INTO qub_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","«Chay runa maycho puñushanpis, maycho jamashanpis ganrami ricaconga. ");
INSERT INTO qub_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","«Chay runa puñushanta pipis yataycorga röpanta tagshaconga; quiquinpis bäñaconga. Nircorga pacha chacänancamami ganra canga. ");
INSERT INTO qub_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","«Chay runa jamashanman pipis jamaycoj cäga ganranami canga. Chaymi röpanta tagshaconga; quiquinpis bäñaconga. Chaypitaga pacha chacänancamami ganra canga. ");
INSERT INTO qub_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","«Yuraj yacuwan gueshyaycaj runata pipis yataycöga röpanta tagshaconga; quiquinpis bäñaconga. Chaynöpis pacha chacänancamami ganra canga. ");
INSERT INTO qub_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","«Yuraj yacuwan gueshyaycaj runa sänu runata togapaycuptin, togapasha runaga röpanta tagshaconga; quiquinpis bäñaconga. Nircurpis pacha chacänancamami ganra canga. ");
INSERT INTO qub_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","«Yuraj yacuwan gueshyaycaj runa muntacushan silla montürapis ganranami canga. ");
INSERT INTO qub_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","«Yuraj yacuwan gueshyaycaj jamashanta pipis yataycoj cäga ganranami canga pacha chacänancama. «Ganra caycaj runa yatashan cajta imatapis apaj cäga röpanta tagshaconga, quiquinpis bäñaconga. Nircurpis pacha chacänancamami ganra canga. ");
INSERT INTO qub_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","«Yuraj yacuwan gueshyaycaj runa maquinta mana mayllacuyllapa juc runata yataycuptin jucnenga röpanta tagshaconga, quiquinpis bäñaconga. Nircurpis pacha chacänancamami ganra canga. ");
INSERT INTO qub_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","«Yuraj yacuwan gueshyaycaj runa allpa mancata yataycuptenga chay mancata paquirenga. Imatapis guerupita rurasha cajcunata yataptin ichanga mayllanga. ");
INSERT INTO qub_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","«Yuraj yacuwan gueshyaycaj runa allchacashanpita ganchis junajtarämi limyuyanga. Chaypitarämi aywaj yacucho röpanta tagshaconga; quiquinpis bäñaconga. Chayno rurarcur ichanga limyuna canga. ");
INSERT INTO qub_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","Pusaj caj junajchöna apamonga ishcay wampata man'chäga ishcay pushapa palumata. Tincuna Tolduman apaycamur ñaupächo cürata entreganga. ");
INSERT INTO qub_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","Cürana jucajta pishtanga juchapita sacrifisyupaj. Jucajtana rupachina sacrifisyupaj pishtanga. Chaynömi ñaupächo ruranga yuraj yacuwan gueshyashanpita allchacaj runa limyuna cananpaj. ");
INSERT INTO qub_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","«Warmiwan mana puñuycaptin juc runapa lëchin quiquillan llojshiptenga bäñaconga. Nircur pacha chacänancamaraj ganra canga. ");
INSERT INTO qub_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","«Runapa lëchin töpashan röpatapis, garachatapis tagshanga. Nircur pacha chacänancamaraj ganra canga. ");
INSERT INTO qub_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","«Runa warminwan cacur custumrinta rurarerga ishcan bäñacuchun. Nircur pacha chacänancamaraj ganra canga. ");
INSERT INTO qub_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","«Quilla gueshyan aywaptenga ganchis junajcamami warmi ganra canga. Pipis quilla gueshyanwan caycaj warmita yataycoj cäga pacha chacänancamami ganra canga. ");
INSERT INTO qub_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","Quilla gueshyanwan caycar gueshtacushanga imapis ganranami canga. Chay warmi ima jananman jamaycuptinpis jamashan cäga ganranami canga. ");
INSERT INTO qub_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","Quilla gueshyanwan caycaj warmi gueshtacushanta pipis yataycorga röpanta tagshaconga, bäñaconga. Nircorga pacha chacänancamaraj ganra canga. ");
INSERT INTO qub_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","Quilla gueshyanwan caycaj warmi imamanpis jamashanta pipis yataycorga röpanta tagshaconga, bäñaconga. Nircur pacha chacänancamaraj ganra canga. ");
INSERT INTO qub_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","Chay warmi gueshtacushanta, jamashanta pipis yataycullarpis pacha chacänancama ganranami canga. ");
INSERT INTO qub_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","Quilla gueshyanwan caycaj warmiwan pï runapis cacorga ishcanmi ganra ricaconga. Chay runapis ganra canga ganchis junajcamami. Runa puñushan cämapis ganranami ricaconga. ");
INSERT INTO qub_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","«Pï warmipis quilla gueshyanwan gueshyashanpita mas achca junajna yawarnin aywaptenga ganra canga imaypis yawarnin chawänancamami. Quilla gueshyan aywaptin ganra cashan-japuymi ganra canga. ");
INSERT INTO qub_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","Chay warmi puñushan cämapis, imaman jamaycushanpis ganranami canga. Quilla gueshyan aywaptin ganra cashan-japuymi ganra canga. ");
INSERT INTO qub_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","Chay warmi töpashancunata pipis yatarga ganrami canga. Chaura röpanta tagshaconga; quiquinpis bäñaconga. Nircur pacha chacänancama ganra canga. ");
INSERT INTO qub_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","Warmipa yawarnin chawaptenga ganchis junajcamaraj shuyanga. Chaypitami ichanga limyuna canga. ");
INSERT INTO qub_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","Pusaj caj junajchöna apamonga ishcay wampata man'chäga ishcay pushapa palumata. Tincuna Tolduman apaycur ñaupächo cürata entreganga. ");
INSERT INTO qub_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","Cüranami jucajta pishtanga juchapita sacrifisyupaj. Jucajtana rupachina sacrifisyupaj pishtanga. Chayno ñaupächo ruranga quilla gueshyanwan warmi gueshyashanpita limyuna cananpämi. ");
INSERT INTO qub_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","«Chaynömi gamcunaga Israel-masiquicunata willapanqui mana ganra cananpaj. Ganra caycar Tincuna Toldöman aywaptenga Tincuna Toldupis ganrami ricacongapaj. Chayno ganra caycar chayman aywajcunaga wañunmanmi.» ");
INSERT INTO qub_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","Chaynömi laycuna caycan chiullacunanpa yuraj yacu llojshiptin ganra cajcunapaj, lëchi llojshiptin ganra cajcunapaj. ");
INSERT INTO qub_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","Chaynöllami laycuna caycan quilla gueshyanwan gueshyaj warmicunapäpis, quilla gueshyanwan caycaj warmiwan cacojpäpis. Chaynömi laycuna caycan warmipäpis ollgupäpis. ");
INSERT INTO qub_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","Tayta Diospa ñaupanman alläpa yaycushanpitami Aaronpa ishcan wamrancuna wañuran. Chaypitarämi Tayta Diosga Moisesta ");
INSERT INTO qub_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","cayno willaparan: «Wauguiqui Aaronta willapay. Tëla chaparaycajpita ruri mas rispitädu caj cuartumanga munashan öra ama yaycongachu. Chaychöga babulmi chapanantin caycan. Chay jananchöga nogami pucutaycho yurimö. Munashan öra yaycorga wañunmanmi. ");
INSERT INTO qub_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","«Aaronga Tincuna Tolduman yayconga juc töru-mallwata juchapita sacrifisyuta pishtarcur, rupachina sacrifisyupäna juc carnita ruparcachir. ");
INSERT INTO qub_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","Yayconga lïnupita awasha alban jatisha, lïnu ajürun jatisha, lïnu wachcun wachcusha, umanmanpis lïnu shucutan jatisha. Chay röpacuna fiyupa rispitädu captinmi jaticunanpäga sumajraj bäñaconga. ");
INSERT INTO qub_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","«Israel runacuna apamushanpitami Aaronga chasquenga ishcay chïbuta juchapita sacrifisyupaj, juc carnitana rupachina sacrifisyupaj. ");
INSERT INTO qub_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","Chaypitanami Tincuna Toldu puncuman töruta Aarón apamonga juchapita sacrifisyuta pishtananpaj. Chay töru canga Aaronpis, Aaronpita miraj cüracunapis limyuyasha cananpämi. ");
INSERT INTO qub_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","Chaynöpis Tincuna Toldu ñaupanman apaycamur ishcan chïbuta ñaupäman churanga. ");
INSERT INTO qub_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","Nircur surtita jitanga maygan chïbu nogapaj cananpaj, maygan chïbu Azazelpaj cananpäpis. ");
INSERT INTO qub_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","Nogapaj caj chïbutaga Aarón pishtanga Israelcuna juchapita sacrifisyuta apamushantami. ");
INSERT INTO qub_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","Azazelpaj caj chïbutana cawaycajllata ñaupäman apamonga Israelcunapa juchanta apananpaj. Nircur chunyajman apaycur Azazelpaj gargurenga chaynöpana Israelcuna purificasha car limyu quëdananpaj. ");
INSERT INTO qub_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","«Aaronga juchapita sacrifisyu töru-mallwata pishtanga. Chayrämi perdunasha canga quiquinpa juchanpis cüra-masincunapa juchanpis. ");
INSERT INTO qub_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","Nircur altarpita saumachicunawan shanshata apanga. Chaynöpis ishcay aptay ñuchu agasha alli asyaj insinsuta apanga Tincuna Tolducho mas rispitädu caj cuartuman. ");
INSERT INTO qub_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","Chaychömi ñaupächo insinsuta wiñanga saumachicunaman. Chaura insinsupa goshtaynin chapacurconga babulpa chapananta. Chaynöpami mana ricamar Aaronga mana wañongachu. ");
INSERT INTO qub_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","Töru-mallwapa yawarnintapis charenga. Nircur babulpa chapanancho caycajtaga ñaupanman ichiycur dëdunwan tapsipanga. Quiquin babulmanpis dëdunwan ganchis cuti tapsipanga. ");
INSERT INTO qub_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","«Nircur llapan Israelcunapämi juchapita sacrifisyu chïbuta pishtanga. Yawarnintapis apanga mas rispitädu caj cuartuman. Chaychöna töru-mallwapa yawarninwan rurashannölla babulpa chapanancho caycajtapis, babultapis yawarwan tapsipanga. ");
INSERT INTO qub_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","Chaynörämi mas rispitädu cajtapis limyuyächenga ima-ayca ganrapita, Israelcuna mana wiyacushanpita, llapan Israelcunapa juchanpita. Chaynölla ruranga juchasapa runacunapa chaupincho caycaj Tincuna Toldutapis. ");
INSERT INTO qub_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","«Mas rispitädu caj cuartucho juchanpita perdunasha cananpaj Aarón imatapis rurashan öra Tincuna Tolduchöga manami pipis canmanchu. Quiquinpa juchanpita, cüra-masincunapa juchanpita, llapan Israelcunapa juchanpita perdunasha cananpaj ruraycorga ");
INSERT INTO qub_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","llojshirir aywanga ñaupächo caycaj altarta limyuyächinanpaj. Chaychömi töru-mallwapa chïbupa yawarninta wallcallata charircur altarpa wagrancunata cantuncunata pichonga. ");
INSERT INTO qub_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","Nircurnami altar jananman yawarta dëdunwan ganchis cuti tapsipanga. Chaynöpami Israel runacuna juchata rurashanpita altar limyuyasha canga rispitäduna cananpaj. ");
INSERT INTO qub_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","«Mas rispitädu cajta, Tincuna Tolduta, altarta limyuyaycachir cawaycaj chïbuta Aarón apachimonga. ");
INSERT INTO qub_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","Chïbupa uman jananman maquinta churaycur Tayta Diosta willanga Israelcuna mana allicunata rurashanta, mana wiyacoj cashanta, juchasapa cashanta. Chayno willashpanmi llapanpa juchanta chïbuman jitapanga llapan juchanta apacunanpaj. Nircur juc runana chunyajman aparcur chïbuta cachayconga. ");
INSERT INTO qub_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","Chayno chunyajcho chïbu illgarnami llapan Israelcunapa ima-ayca juchantapis apaconga pipis mana tiyashanman. ");
INSERT INTO qub_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","«Chaypitana Aarón aywanga Tincuna Toldu cajman. Mas rispitädu caj cuartuman yaycunanpaj jaticushan lïnu röpataga rucacurir chaycho cachayconga. ");
INSERT INTO qub_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","Bäñacurir röpanta jaticurcurna yargonga quiquinpa juchanpita y Israel runacunapa juchanpita rupachina sacrifisyu uywata rupachinanpaj. Chayno rupachiptinmi quiquinpa juchancunawan Israel runacunapa juchancuna perdunasha canga. ");
INSERT INTO qub_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","Juchapita sacrifisyuta pishtashan uywapa wiranta altarcho rupachenga. ");
INSERT INTO qub_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","Chunyaj Azazelman chïbuta apaj runapis röpanta tagshaconga; quiquinpis bäñaconga. Nircur-rämi wasinman cutimonga. ");
INSERT INTO qub_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","«Juchapita sacrifisyupaj pishtashan töru-mallwapa, juchapita sacrifisyupaj pishtashan chïbupa garachanta, aychanta, ashashnincunatana tiyaycashanpita juc-läman apaycur rupachenga. ");
INSERT INTO qub_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","Chaycunata rupachej runaga röpanta tagshaconga; quiquinpis bäñaconga. Nircur-raj tiyaycashanman cutimonga. ");
INSERT INTO qub_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","«Willapashä laycunataga gamcuna imaycamapis cumlinqui. Ganchis caj quilla chunca junajnincho gamcuna ayunanqui. Chay junäga quiquiquicunapis jäpacunapis marcayquicho goyäga ama arongachu. ");
INSERT INTO qub_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","Chay junäga llapaniquitami juchayquipita perdunashayquipaj. Llapan juchayquipitami limyuna canquipaj. ");
INSERT INTO qub_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","Chay junäga gamcunapaj säbadu jamay junajmi canga. Chaymi ayunar ima aruytapis ama ruranquichu. Chay nishäcunaga imaycamapis laymi gamcunapaj canga. ");
INSERT INTO qub_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","Cada watami papäninpa ruquin mandaj cüra cananpaj churashan cüraga juchancunapita perdunasha cananpaj llapanta ruranga. Chaycunata ruranga lïnu röpata jatishami. ");
INSERT INTO qub_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","Nircur limyuyächenga mas rispitädu cajta, Tincuna Tolduta, altarta. Chayrämi cüracunapis llapan Israelcunapis perdunasha canga. ");
INSERT INTO qub_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","«Willapashä laytaga imaypis ama gonganquicunachu. Cada watacho juc cutimi chay nishäcunata ruranga llapan Israelcunapa juchan perdunasha cananpaj.» Chauraga Moisesta Tayta Dios nishannöllami llapantapis ruraran. ");
INSERT INTO qub_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","Moisesta Tayta Dios niran: ");
INSERT INTO qub_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","«Aaronta, wamrancunata, llapan Israel-masiquicunata willapanqui: ");
INSERT INTO qub_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","«Garamänanpaj Israelcuna, wäcata, uyshata, cabrata carpis tiyaycashancho, u juc-lächo pishtarpis ");
INSERT INTO qub_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","Tincuna Tolduman mana apamoj cäga yawarta mashtashanpitami juchayoj canga. Chaypitami chayno ruraj runaga Israelcunapita gargusha canga. ");
INSERT INTO qub_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","Chaymi may jircacunachöpis uywancunata nogapaj ama pishtangachu. Chaypa ruquenga Tincuna Toldu ñaupanman apamonga cürata entregananpaj. Cüranami alli goyaypita sacrifisyuta apamushan uywata Nogapaj pishtanga. ");
INSERT INTO qub_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","Cüraga Tincuna Toldu puncucho uywapa yawarninta altarnëman chajchupanga. Wirantapis altarcho rupachenga jömuynin Nogapa shongöpäno cananpaj. ");
INSERT INTO qub_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","Imaypis amana apanganachu cabra-niraj dyablucunapaj pishtananpäga. Chaycunatami paycunaga adurasha. Chayno rurarmi fiyupa mana alli ruraymanpis chayasha. Chay nishäcunaga imaycamapis laymi canga gamcunapaj gamcunapita mirajcunapäpis. ");
INSERT INTO qub_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","«Israel-masiquicunatapis, tiyashayquicho caj jäpa runacunatapis willapanqui. Nogapaj rupachina sacrifisyuta garamayta munar u ima sacrifisyutapis garamayta munar ");
INSERT INTO qub_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","Tincuna Toldu ñaupanman nogapaj mana apamoj runacunataga tiyashayquipita gargunqui. ");
INSERT INTO qub_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","«Yawarta micoj cajtaga Israel-masiquicunatapis lagacamoj jäpa runacuna cajtapis melanäcushämi. Yawarta ichicllatapis micojcunataga tiyarcaycashanpita gargurishämi. ");
INSERT INTO qub_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","Llapan cawajcunapa yawarninchömi bïdan caycan. Chaymi gamcunapis altarman yawarta jichar-raj juchayquipita perdunasha canquipaj. ");
INSERT INTO qub_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","«Chaymi Israelcuna sumaj wiyacuy. Gamcunapis ni lagacushoj jäpa runacunapis yawarta ama micunquichu. ");
INSERT INTO qub_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","Israelcunapis ni lagacushoj jäpa runacunapis micuna animalta, micuna äbita charir yawarnintaga pampaman jicharcur allpawan chaparconga. ");
INSERT INTO qub_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","Cawajcunapaga yawarninchömi bïdan caycan. Chaymi yawarnintaga ama micunquichu. Yawarninrämi llapantapis cawachin. Pipis yawarta micoj cäga gargushami canga. ");
INSERT INTO qub_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","«Israelcunapis, lagacushoj jäpa runacunapis wañusha uywapa aychanta micur, aycha micoj animal wañuchishan aychata micur röpanta tagshaconga; quiquinpis bäñaconga. Nircur pacha chacänancama ganra canga. ");
INSERT INTO qub_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","Röpanta mana tagshacur, quiquinpis mana bäñacorga juchanpita castigashami canga.» ");
INSERT INTO qub_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","Moisesta Tayta Dios niran: ");
INSERT INTO qub_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","«Israelcunata willapanqui: Nogami gamcunapa Tayta Diosniqui cä. ");
INSERT INTO qub_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","«Egiptucho tiyar ricashayqui custumricunataga ama ruranquinachu. «Pushaycashä Canaanman chayarpis chay parti runacunapa custumrinta ama ruranquichu. Ni laynincunatapis ama wiyacunquichu. ");
INSERT INTO qub_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","«Noga nishäcunataga wiyacuy. Laynëcunataga cumliy. Chaycuna niycashannölla goyay. Noga Tayta Diosniquimi chayno në. ");
INSERT INTO qub_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","«Laynëcunata, nishäcunatapis cumliy. Pipis laynëcunata cumlej cäga allimi cawanga. Noga Tayta Diosniquimi chayno në. ");
INSERT INTO qub_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","«Pipis famillyanwanga ama cacongachu. Noga Tayta Diosniquimi chayno në. ");
INSERT INTO qub_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","«Mamayquiwan ama cacunquichu. Chayta rurarga papäniquitami manacajman churanqui. Mamayqui caycaptenga chayta ama ruraycunquichu. ");
INSERT INTO qub_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","«Märistayquiwan ama cacuychu. Chayta rurarga papäniquitami manacajman churanqui. ");
INSERT INTO qub_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","«Pañiquiwan ama cacunquichu. Papäniquipita pañiqui carpis, mamayquipita pañiqui carpis payga yawar-masiquimi. Mamayquicho carpis wachachipacuynin carpis pañiquimi. Chaymi yawar-masiqui caycaptenga pañiquiwan ama cacunquichu. ");
INSERT INTO qub_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","«Willcayquiwan ama cacunquichu warmi wamrayquipa wamran captinpis ni ollgu wamrayquipa wamran captinpis. Chayta rurarga quiquillayquimi pengayman churacunquipaj. ");
INSERT INTO qub_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","«Papäniquipa intinädanwanpis ama cacunquimanchu. Paywan cacorga pañiquiwan cacoj-japuymi canquipaj. ");
INSERT INTO qub_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","«Papäniquipa pañinwanpis ama cacunquichu. Payga tiyayquimi. ");
INSERT INTO qub_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","«Mamayquipa ñañanwanpis ama cacunquichu. Payga tiyayquimi. ");
INSERT INTO qub_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","«Tiyuyquipa warminwanpis ama cacunquichu. Paypis tiyayquimi caycan. Paywan cacushpayquega tiyuyquitami manacajman churanqui. ");
INSERT INTO qub_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","«Wamrayquipa warminwanpis ama cacunquichu. Payga llumchuyniquimi. ");
INSERT INTO qub_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","«Wauguiquipa warminwanpis ama cacuychu. Paywan cacushpayquega wauguiquitami manacajman churanqui. ");
INSERT INTO qub_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","«Mamantinta intinädayquita ama manijanquichu. Intinädayquipa wawanwanpis intinäduyquipa wamranwanpis ama cacunquichu. Paycunaga warmiquipa yawar-masinmi caycan. Chayga pasaypa pengaypaj juchami caycan. ");
INSERT INTO qub_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","«Warmiquita ñañantintaga ama manijaychu. Warmiqui cawaycaptenga cuñädayquiwan ama cacuychu. Chayno ruraptiquega quiquin-purami chiquinacunman. ");
INSERT INTO qub_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","«Quilla gueshyanwan caycaj warmiwanga ama cacunquichu. ");
INSERT INTO qub_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","«Juc runapa warminwanga ama cacunquichu. Chayno jucpa warminwan cacorga ganrami ricacunquipaj. ");
INSERT INTO qub_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","«Moloc diospäga maygan wamrayquitapis ama rupachinquichu. Chayno rurarga nogatami rabyachimanqui. Noga Tayta Diosniquimi chayno në. ");
INSERT INTO qub_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","«Ollgu-pura ama cacunquichu. Chayga melanaypämi. ");
INSERT INTO qub_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","«Ima animalwanpis ama cacunquichu. Warmipis animalcunawan ama cacongachu. Chayga fiyupa melanaypämi. ");
INSERT INTO qub_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","«Chaycunataga ama ruraychu mana ganrayänayquipaj. Chaycunata rurarmi ganra ricacusha canan ñaupayquipita jitarinäpaj caycaj Cananeo runacunapis. ");
INSERT INTO qub_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","Chayno ganracunata rurashanpitami nasyunninpis ganrana ricacusha. Chaymi jusgar marcanpitapis llapanta gargushcä. ");
INSERT INTO qub_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","Gamcunaga nishäcunata, laynëcunata cumlinqui. Chay pengaypaj ganracunata ama ruranquichu. Chaynölla cumlichun gamcunaman lagacamoj runacunapis. ");
INSERT INTO qub_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","Gamcuna manaraj chayashayquicama jinan Cananeo runacuna fiyupa ganratami ruraran. Chaymi chay nasyuncunapis ganra ricacuran. ");
INSERT INTO qub_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","¡Gamcunatapis chay nasyunpita gargurëmanmi ganracunata ruraptiquega! Unaypis jinan runacuna ganracunata rurashanpitami gargushcä. ");
INSERT INTO qub_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","Pipis chayno ganra juchacunata ruraj cäga tiyashanpita gargushami canga. ");
INSERT INTO qub_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","Chauraga nishäcunata wiyacuy. Mana ganrayänayquipaj ama ruranquichu jinan Cananeo runacuna rurashan ganracunataga. Noga Tayta Diosniquimi chayno në.» ");
INSERT INTO qub_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","Moisesta Tayta Dios niran: ");
INSERT INTO qub_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","«Israel-masiquicunata willapanqui: «Noga Tayta Diosniquega santumi cä. Chaymi gamcunapis nishäcunata wiyacamar santo cay-llapa. ");
INSERT INTO qub_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","«Jucniqui-jucniquipis mamayqui taytayquita rispitanqui. «Säbadu jamay junajchöpis rispitamar jamanqui. Noga Tayta Diosniquimi chayno në. ");
INSERT INTO qub_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","«Ama ïdulucunata aduranquichu. Ni jundiypa rurarcurpis ‹diosnë› nir ama aduranquichu. Noga Tayta Diosniquimi chayno në. ");
INSERT INTO qub_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","«Alli goyaypita sacrifisyupaj uywacunata pishtarga ruranqui shongöpäno noga chasquinäpaj. ");
INSERT INTO qub_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","Pishtashayqui uywapa aychantaga chay junajlla micunqui. Puchuptin waranninpis micunquimanrämi. Quimsa junajpäna puchoj cajta ichanga rupaycachinquina. ");
INSERT INTO qub_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","Quimsa junaj goyashatana micuptiquicunaga ganranami canga. Yanganami canga nogapaj pishtar churashan ofrendanpis. ");
INSERT INTO qub_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","Chaymi ishcay junajpita mas goyasha aychata pipis micoj cäga juchayojna ricaconga. Chayno micojtaga nogapaj acrasha caycaptin ganrachishanpita tiyashayquipita gargurinqui. ");
INSERT INTO qub_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","«Cosëchata rurarga ama shuntanquichu ashircur-ashircorga. Rutushayqui rïgu shicwashantapis ama shuntanquichu. ");
INSERT INTO qub_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","Übastapis chacrapita ashircur-ashircorga ama pallacurinquichu. Shicwajcunatapis ama shuntanquinachu. Chaycunataga cachaycunqui pobricunapaj, lagacushojcunapämi. Noga Tayta Diosniquimi chayno në. ");
INSERT INTO qub_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","«Ama suwacunquichu. Ama llullacunquichu. Ama engañacunquichu. ");
INSERT INTO qub_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","Llullacuypaga nogapa jutëcho ama auninquichu. Llullacur Jutëta jogarishpayquega manacajmanmi churamanquipaj. Noga Tayta Diosniquimi chayno në. ");
INSERT INTO qub_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","«Runa-masiquita ama engañanquichu. Imantapis ama guechunquichu. Piyun arupäshojtapis pägunta warannincamaga ama shuyarächinquichu. ");
INSERT INTO qub_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","Upacunataga ama ashllinquichu. Ni gapratapis ama tunichinquichu. Chayno rurarga nogata manami rispitamanquichu. Noga Tayta Diosniquimi chayno në. ");
INSERT INTO qub_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","«Autoridä car derëchu canqui. Pobritapis juchanpitaga ama chapanquichu. Ni rïcucunatapis juchanpitaga ama chapanquichu. Autoridä carga alli arriglanqui. ");
INSERT INTO qub_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","Marcayquicho ama purinquichu runapa washanta rimar. Runa-masiquita wañuchinanpaj ama jitapanquichu. Noga Tayta Diosniquimi chayno në. ");
INSERT INTO qub_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","«Shongullayquicho pitapis ama chiquipanquichu. Juchanpitaga runa-masiquita piñacuy. Juchata ruraptin ama chapanquichu. Chaparga ishcaniquimi juchayoj ricacunquipaj. ");
INSERT INTO qub_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","Marca-masiqui imatapis rurashuptiqui ayñita ama cutichinquichu, ni nanaparanquipischu. Chaypa ruquenga runa-masiquita cuyanqui quiquiqui alli cawayta munashayquino. Noga Tayta Diosniquimi chayno në. ");
INSERT INTO qub_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","«Llapan laynëcunata sumaj wiyacuy. Uywayquicunata juc casta uywawanga ama jaruchinquichu. Chacrayquiman ama murunquichu tacuy murutaga. Röpatapis ama jaticunquichu tucuy casta jïluta tacurcachir awashataga. ");
INSERT INTO qub_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","«Uyway jipash majachacänanpaj parlasha caycaptin pipis chay jipashwan cacuptenga ishcanmi castigasha canga. Ichanga chay jipash libri yargunanpaj pipis manaraj pägasha captinmi castigarpis mana wañuchinmanchu. ");
INSERT INTO qub_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","Ichanga chay runa cutichina sacrifisyuta nogapaj pishtananpaj apamonga juc carnita. Chaytaga Tincuna Toldu ñaupanman apamonga. ");
INSERT INTO qub_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","Cutichina sacrifisyupaj apamushan uyshawanrämi cüra mañacamanga juchanpita chay runata perdunanäpaj. Chaynöparämi runapa juchan perdunasha canga. ");
INSERT INTO qub_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","«Pushar chayachinäpaj caycaj nasyunman chayarga frütacunapa wayuyninta quimsa watacama ama micunquichu. ");
INSERT INTO qub_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","Chuscu wata cajcho wayushantami ichanga nogata agradësicamar nogapaj ofrendata apamunqui. ");
INSERT INTO qub_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","Pichga wata cajcho wayushantarämi gamcunaga micunqui. Chayrämi llapan frütacuna amatar wayonga. Noga Tayta Diosniquimi chayno në. ");
INSERT INTO qub_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","«Ama ima aychatapis micunquichu yawarniyojllataga. Gamcunaga ama adibinapacoj canquichu. Ama brüju canquichu. ");
INSERT INTO qub_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","Ajchayquita sentïduyqui jananpa ama rutucunquichu. Shaprayquitapis puntallanpa ama rutucunquichu. ");
INSERT INTO qub_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","Wañojcunapaj llaquicushpayqui garayquicunata ama yawar-yawar ruracunquichu. Cuerpuyquicho ima señaltapis ama ruracunquichu. Noga Tayta Diosniquimi chayno në. ");
INSERT INTO qub_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","«Warmi wamrayqui guellaypaj jucwan-jucwan cacunanta ama dëjanquichu. Chayno arucherga pengaymanmi churanquipaj. Ganracunata rurachishpayquega tiyashayqui nasyuntapis ganrachinquipämi. ");
INSERT INTO qub_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","Säbadu jamay junajchöga rispitamar jamanqui. Tiyanä Toldutapis rispitanqui. Noga Tayta Diosniquimi chayno në. ");
INSERT INTO qub_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","«Ama almata gayaj cayta yachacunquichu. Musyacojcunawan ama musyachicunquichu. Chayta rurar ganrami ricacunquipaj. Noga Tayta Diosniquimi chayno në. ");
INSERT INTO qub_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","«Chachacunataga rispitanqui, saludanqui. Chayno rurarga nogatami rispitaycämanqui. Noga Tayta Diosniquimi chayno në. ");
INSERT INTO qub_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","«Jäpa runacuna marcayquiman lagacamojta ama ñacachinquichu. ");
INSERT INTO qub_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","Paycunataga marca-masiquitano alli ricanqui. Paycunapis gamcunanömi. Gamcunapis Egipto nasyunchöga lagacojllami carayqui. Noga Tayta Diosniquimi chayno në. ");
INSERT INTO qub_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","«Pësawan pësarpis, metruwan tupurpis ama pitapis engañanquichu. ");
INSERT INTO qub_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","Alli balansawan alli pësawan pësanquega. Pishej metruwan ama engañanquichu. Mana pishej metruwan tupunqui. Egiptupita jorgamushoj Tayta Diosniquimi chayno në. ");
INSERT INTO qub_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","«Llapan willapashäcunata, laynëcunata wiyacuy-llapa. Chaycunataga llapanta cumliy. Noga Tayta Diosniquimi chayno në.» ");
INSERT INTO qub_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","Moisesta Tayta Dios niran: ");
INSERT INTO qub_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","«Israel-masiquicunata ninqui: Israel runacunapis, lagacamoj runacunapis dios Molocpaj sacrifisyuta rurar wamranta rupachej cäga wañuchicangami. Chay runataga llapan runacunami sajmaypa wañuchenga. ");
INSERT INTO qub_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","Molocpaj wamranta rupachishpanga Tincunanchi Toldutami ganrachin, nogatapis manacajman churaman. Chaymi chayno ruraj runapa contran ricacur ushacächishäpaj. ");
INSERT INTO qub_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","Chay runata mana wañuchiptenga ");
INSERT INTO qub_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","quiquëmi chay runapa, famillyancunapa contran ricacushäpaj. Paycunata ushacächishänömi Molocta aduraj runacunatapis llapanta ushacächishäpaj. ");
INSERT INTO qub_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","«Pipis brüjucunaman, u ricacojcunaman musyachicoj aywajcunataga ticrapacurcushämi. Chaura chay runataga ushacächishämi. ");
INSERT INTO qub_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","«Nogami Tayta Diosniqui cä. Chayno caycaptenga mana juchata ruraypa santo caway-llapa. ");
INSERT INTO qub_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","Llapan laynëcunataga cumliy. Gamcunata acraj noga Tayta Diosniquimi chayno në. ");
INSERT INTO qub_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","«Pipis mamanta u papäninta maldisyunajcunataga wañuchinqui. Chayno wañuchicänanpäpis quiquinmi juchayoj canga. ");
INSERT INTO qub_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","«Pipis juc runapa warminwan cacuptenga ishcanta warmita ollgutapis wañuchenga. ");
INSERT INTO qub_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","«Pipis märistanwan cacorga papänintami manacajman churan. Chay-niraj runataga märistantinta wañuchenga. Wañuchicänanpäpis quiquincunami juchayoj canga. ");
INSERT INTO qub_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","«Pipis llumchuyninwan cacuptenga fiyupa melanaypaj juchami. Chaymi llumchuynintinta wañuchenga. Chayno wañuchicänanpäpis quiquincunami juchayoj canga. ");
INSERT INTO qub_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","«Pipis warmiwan cacoj-japuy ollgu-masinwan cacuptenga fiyupa melanaypaj juchami. Chayno rurajtaga ishcanta wañuchenga. Wañuchicänanpäpis quiquincunami juchayoj canga. ");
INSERT INTO qub_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","«Pipis warminta wawantinta manijarga fiyupa melanaypaj juchatami ruran. Chayno captenga quimsanta wañurachir ruparachenga. Chaura manami cangachu melanaypaj jucha rurajcuna. ");
INSERT INTO qub_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","«Juc runa uywawan cacuptenga wañuchenga. Uywatapis wañuchenga. ");
INSERT INTO qub_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","«Juc warmi ima uywawanpis cacuptenga wañuchenga. Uywatapis wañuchenga. Wañuchicänanpäpis quiquincunami juchayoj canga. ");
INSERT INTO qub_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","«Pipis papäninpita, u mamanpitapis pañin caycaptin warmiwan cacuptenga marca-masincunapa ricay ñawincho fiyupa pengaymi. Chaymi chayno cacojtaga ishcanta tiyarcaycashayquipita gargurinqui. Gargucänanpäpis quiquincunami juchayoj canga. ");
INSERT INTO qub_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","«Pipis quilla gueshyanwan caycaj warmiwan cacorga warmipa yawarnintami rican. Ricananpäpis quiquin warmimi juchayoj. Chaypitami ishcanta gargonga. ");
INSERT INTO qub_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","«Pipis ama cacongachu mamanpa ñañanwan, ni papäninpa pañinwanpis. Lijïtimu famillyanwan cacorga ishcanmi juchayoj car castigacanga. ");
INSERT INTO qub_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","«Pipis tiyunpa warminwan cacushpanga tiyuntami manacajman churan. Chayno cacojcunaga ollgupis warmipis ishcanmi juchayoj ricacun. Chayno cacojcunaga wamraynajllanami wañongapis. ");
INSERT INTO qub_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","«Pipis wauguinpa warminwan cacorga wauguintami manacajman churan. Chayta rurarga fiyupa juchatami ruran. Chaypitami paycunaga wamraynajllana wañongapis. ");
INSERT INTO qub_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","«Laynëcunata, willapashäcunata ushajpaj cumliy. Chaura gamcunataga chayachinäpaj caycaj nasyunpita manami jitarishayquipächu. ");
INSERT INTO qub_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","Chay nasyun runacunataga fiyupa juchata rurashanpitami gargushaj. Manami awantänachu. Gamcuna ichanga paycuna rurashanno ama ruraychu. ");
INSERT INTO qub_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","Chay runacuna tiyashan nasyuncunata nogaga aunishcänami gamcunata goycunäpaj. Quiquëmi tiyachishayqui lëchipis, mishquipis yacunöraj achca cashan nasyuncho. Llapanpis aypallami canga. «Nogami Tayta Diosniqui cä. Achca nasyun captinpis gamcunallatami acracushcä. ");
INSERT INTO qub_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","Chaymi gamcunapis raquinqui ganra caj limyu caj animalcunata; ganra caj limyu caj äbicunata. Chauraga mana ganrayänayquipaj ama micunquichu ‹ganra› nishä cajtaga: animalcunata, äbicunata, garachaypa purejcunatapis. ");
INSERT INTO qub_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","Noga Tayta Diosniquega santumi cä. Chaymi gamcunapis santo cawanayqui. Achca nasyun runacunapitapis gamcunatami raquicushcä nogapa canayquipaj. ");
INSERT INTO qub_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","«Ollgutapis, warmitapis almawan parlajcunata, brüjucunataga sajmaypa wañuchinqui. Chayno wañuchicänanpäpis quiquincunami juchayoj canga.» ");
INSERT INTO qub_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","Moisesta Tayta Dios niran: «Aaronpa wamran cüracunata willapay. Marcancho wañusha ayacunata ama yatangachu mana ganrayänanpaj. ");
INSERT INTO qub_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","Paycunaga ayata yatanman maman captin, papänin captin, wamrancuna captin, wauguin captin, ");
INSERT INTO qub_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","uywashan pañin japalla caycashancho wañuptillanmi. Paycunapa ayanta yatarga jina ganrayanmanpis. ");
INSERT INTO qub_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","Majayoj pañin wañuptinmi ichanga ama yatanganachu mana ganra ricacunanpaj. ");
INSERT INTO qub_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","«Ni ajchanta ni shaprantapis ama rutucongachu. Garancunatapis ama yawar-yawar ruracongachu. ");
INSERT INTO qub_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","Chaypa ruquenga noga munashänölla rurar santo cawachun. Manacajman ama churamangachu. Cüracunami altarcho rupachin runacuna garamashancunatapis. Chaymi paycunaga munashäno santo cawachun. ");
INSERT INTO qub_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","«Cüracunaga ama majachacangachu jucwan-jucwan cacojcunawan, bigulashacunawan, raquicashacunawan. Cüracunaga acracushämi. ");
INSERT INTO qub_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","Paycuna santo cashanta tantiyacur Israel runacuna rispitachun. Chayno rispitanga noga Tayta Diosniquipaj apamushanta altarcho rupachej cashanpitami, noga Tayta Dios Santo cashäpitami, gamcunatapis santo cawanayquipaj churashäpitami. ");
INSERT INTO qub_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","«Cürapa jipash wamran jucwan-jucwan cacuyman churacarga papänintami manacajman churan. Chay-niraj warmiga cawaycajllami rupachicanga. ");
INSERT INTO qub_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","«Mandaj cürallami fiyupa rispitädu röpataga jaticonga. Chaynöga jaticonga acrar umanman asëtita wiñapasha captinmi. Chaypitami wañupacur llaquicur tinshi uma ama purengachu. Röpantapis ama rachengachu. ");
INSERT INTO qub_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","Aya caycashanmanga ama yaycongachu maman ni papänin captinpis. Famillyan wañushan-raycu ama ganrayangachu. ");
INSERT INTO qub_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","Rispitädu asëtita umanman wiñapasha caycar ayaman aywarga Tayta Dioswan Tincuna Toldutapis ganrayächengami. Chayno captenga ayaman ama aywachunchu. Noga Tayta Diosniquimi chayno në. ");
INSERT INTO qub_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","«Mas mandaj cüraga runa yatänillaraj warmiwan majachacanga. ");
INSERT INTO qub_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","Ama majachacangachu biyüdawan, raquicashawan, bigulashawan, jucwan-jucwan cacojwanpis. Warmita asherga Leví trïbu-masillanpita runa yatäni jipashta ashichun. ");
INSERT INTO qub_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","Chaynöpami paypita mirar aywajcunapis mana manacajman churasha cangachu. Chaynöga canga paycunata santo cananpaj noga acracusha captëmi.» ");
INSERT INTO qub_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","Moisesta Tayta Dios niran: ");
INSERT INTO qub_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","«Aaronta willapanqui: Cananpitaga Aaronpita mirar aywajcuna sänu cajcunallami cüra canga. Paycunallami runacuna apamushanta nogapaj tantata churanga. ");
INSERT INTO qub_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","Tantata ama churangachu gapracuna, wegrucuna, cäran mana sänu cajcuna, macllucuna, ");
INSERT INTO qub_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","chaquinpis, maquinpis paquicushacuna, ");
INSERT INTO qub_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","curcucuna, enänucuna, ñawin nübiyashacuna, garachuyojcuna, pashtapäcuycajcuna, runtun däñashacunapis. ");
INSERT INTO qub_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","Aaronpita mirar aywajcuna mana sänu cajcunaga altarcho nogapaj manami rupachinmanchu. Chay apamushancuna nogapaj captinmi sänu cajcunalla rupachenga. ");
INSERT INTO qub_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","Altarcho mana rupachirpis micuytaga micongami tantatapis, nogapaj churashan rispitädu caj micuycunatapis. ");
INSERT INTO qub_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","Ichanga Tincuna Toldu rurimanpis ama yaycongachu. Altar caycashanmanpis ama witipangachu. Chauraga acrashäta manami manacajman churangachu. Cüracunataga noga Tayta Diosmi sirbimänanpaj acrashcä.» ");
INSERT INTO qub_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","Tayta Dios chayno nishantaga juctapis mana gongaypami Moisés willaparan Aaronta, Aaronpa wamrancunata, llapan Israel-masincunatapis. ");
INSERT INTO qub_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","Moisesta Tayta Dios niran: ");
INSERT INTO qub_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","«Aaronta wamrancunata ninqui: Israel-masiquicuna garamashantaga manchapacuyllapa imatapis ruranga. Chaynöpami mana manacajman churamangachu. Noga Tayta Diosniquimi chayno në. ");
INSERT INTO qub_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","«Israelcuna nogapaj apamushantaga rispitädu captin Aaronpita mirajcuna ama manacajman churangachu. Paycuna ganra caycar garamaptenga ñaupäpita gargurishämi. Noga Tayta Diosniquimi chayno në. ");
INSERT INTO qub_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","«Aaronpita mirar aywajcunaga leprawan gueshyar, u chiullacunanpa yuraj yacu aywaypa gueshyar manami micongachu nogata garamashanta. Limyuyar-rämi miconga. «Cüracunaga wañushata yatajcunata yatar, u lëchita chiullashacunata yatar ganrami ricaconga. ");
INSERT INTO qub_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","Pachan garachaypa purejta yataycurpis ganrayanmi. Ganra caycaj runata yatarpis ganrami ricaconga. ");
INSERT INTO qub_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","Paycunaga inti yaganancama ganra canga. Chaymi manaraj mayllacorga garamashancunata mana micongachu. ");
INSERT INTO qub_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","Inti yagacurcuptinrämi limyu canga. Chaypitami ichanga micongana Israelcuna garamashan micuycunata. Israelcuna garamashanga cüracunapa derëchunmi caycan. ");
INSERT INTO qub_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","Cüracunaga ama micongachu quiquillan wañusha uywacunapa aychanta, aycha micoj jirca animalcuna wañuchishan uywatapis. Chaycunata micushpanga ganrayangapämi. Noga Tayta Diosniquimi chayno në. ");
INSERT INTO qub_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","«Cüracunata willay mandamintöcunata llapanta cumlinanpaj. Mana cumlerga juchayoj ricacur wañongami. Noga Tayta Diosmi cüracunata acrashcä santo cananpaj. ");
INSERT INTO qub_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","«Jäpa cajcunaga manami micongachu nogata garamashanta. «Cürapa gorpanpis, ni piyunninpis manami micongachu nogata garamashan rispitädu micuycunataga. ");
INSERT INTO qub_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","«Guellayninwan cüra rantishan uywaymi ichanga miconga Israelcuna nogata garamashan micuyta. Uywayninpa wamran cürapa maquincho yurejcunapis micongami. ");
INSERT INTO qub_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","«Cürapa warmi wamran cürawan mana majachacasha cashpanga cürapa derëchuncunata manami micongachu. ");
INSERT INTO qub_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","Mana wamran captillan biyüdayar, u raquicar japalla cashanno papäninpa maquincho goyarga papänin chasquishan micuycunata micongami. Mana cüra casta caj runami ichanga mana micongachu cüra micunan micuyta. ");
INSERT INTO qub_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","«Pipis mana musyayninpa nogata garamashan ofrendacunata micorga cüraman cutichenga. Jananmanpis cada chuncapita ishcay mastaraj yapanga. ");
INSERT INTO qub_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","Israelcuna garamashan ofrendacunataga cüracuna ama manacajman churanmanchu. ");
INSERT INTO qub_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","Nogata garamashan ofrendata juccuna micunanta dëjar ama juchacachengachu. Juchacachiptin paycunaga cutichipacunmanrämi. Noga Tayta Diosmi cüracunataga santo cananpaj raquicushcä.» ");
INSERT INTO qub_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","Moisesta Tayta Dios niran: ");
INSERT INTO qub_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","«Aaronta, wamrancunata, llapan Israel-masiquicunata willapay: Maygan Israelcunapis, Israelcunaman lagacojcunapis nogapaj rupachina sacrifisyupaj uywata apamunmanmi aunishanta cumlir, shongun shacyaptinpis. ");
INSERT INTO qub_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","Chayno apamur noga chasquinäpäga apamonga sänu orgu uywata: töruta car, carnita car, chïbuta carpis. ");
INSERT INTO qub_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","Mana sänu captenga ama nogapaj apamongachu. Chaynötaga manami chasquishächu. ");
INSERT INTO qub_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","«Alli goyaypita sacrifisyupaj pipis uywata apamorga noga chasquinäpaj apamonga töruta carpis uyshata carpis sänuta. Apamunmanmi aunishanta cumlirpis, shongun shacyaptinpis. ");
INSERT INTO qub_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","Nogapäga ama apamongachu gapra uywata, paquicushata, ushuta, tictiyojta, garachuta, gueriyojta. Chaynötaga altarcho rupachinanpaj ama apamongachu. ");
INSERT INTO qub_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","Shongun shacyaptillan apamuptenga chasquishämi macllu töruta, macllu uyshata apamuptinpis. Aunishanta cumlir apamuptinmi ichanga chaynötaga mana chasquishäpächu. ");
INSERT INTO qub_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","Nogapäga ama apamongachu runtun llapchishacunata, runtun däñashacunata, runtun rachishacunata, capashacunata. Entreganäpaj caycaj nasyunchöpis chayno uywacunataga ama apamongachu. ");
INSERT INTO qub_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","Jäpa runacuna nogapaj apamuptinpis mana sänu uywacunataga ama chasquinquichu. Imallanpis däñasha uywacunataga manami chasquishächu.» ");
INSERT INTO qub_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","Moisesta Tayta Dios niran: ");
INSERT INTO qub_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","«Töru-mallwa, uysha-mallwa, chïbu-mallwa yuriptenga ganchis junajcamami maman chuchonga. Pusaj junajyojpitami ichanga nogapaj apamuyta munar apamunmanna. ");
INSERT INTO qub_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","«Wäcata, ni uyshatapis wawantinta chay junajllaga ama pishtangachu. ");
INSERT INTO qub_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","«Agradësicamar garamashpanga garamanga llapan shongunpa. Chaura nogapis cushishami chasquishaj. ");
INSERT INTO qub_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","Nogapaj pishtar llapan aychata chay junajlla miconga. Waranninpäga ama imatapis puchöchengachu. Noga Tayta Diosniquimi chayno në. ");
INSERT INTO qub_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","«Mandamintöcunata llapanta cumliy-llapa. Noga Tayta Diosniquimi chayno në. ");
INSERT INTO qub_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","«Santo caycaptë llutancunata rurar ama pengayman churamaychu. Llutancunata mana rurarga gamcunapis santumi canquipaj. Noga Tayta Diosmi gamcunata acrashcä santo canayquipaj. ");
INSERT INTO qub_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","Quiquëmi Egiptupitapis jorgamushcä Tayta Diosniqui canäpaj. Noga Tayta Diosniquimi chayno në.» ");
INSERT INTO qub_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","Moisesta Tayta Dios niran: ");
INSERT INTO qub_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","«Israel-masiquicunata willapay: Nogata rispitamänayquipaj fistata rurarga rispëtuwan shuntacanqui. Chay fistacuna caycunami canga: ");
INSERT INTO qub_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","«Sojta junajmi arunqui. Warannin ganchis caj junajchönaga ama arunquinachu ima aruytapis. Säbadu jamay junaj captin rispëtuwan shuntacanqui. Gamcuna maycho tiyashpayquipis chay junäga nogata rispitamashpayqui jamanqui. ");
INSERT INTO qub_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","«Gamcuna waquin fistacunata rurarpis aduramänayquipaj rispëtuwan shuntacanqui. ");
INSERT INTO qub_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","«Cada watami rispitamar Pascua fistata ruranqui. Chay fista gallayconga wata gallarej rimir quilla chunca chuscu (14) junajnin tardimi. ");
INSERT INTO qub_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","«Rispitamar lebadüraynaj tantata micuna fistatapis ruranqui. Chay fistapis gallayconga chay quilla chunca pichga (15) junajnincho. Chay fistachöga ganchis junajmi lebadüraynaj tantata micunqui. ");
INSERT INTO qub_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","Chay fista gallaycunan junäga jatun diya captin rispëtuwan shuntacanqui. Chay junäga ama arunquicunachu. ");
INSERT INTO qub_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","Chaypitaga waran-waran fista ushashancama nogata garamar ofrendacunata rupachinqui. Ushanan ganchis junaj cajchöpis jatun diya captin rispëtuwan jamanqui. Chay junäga ama arunquichu.» ");
INSERT INTO qub_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","Moisesta Tayta Dios niran: ");
INSERT INTO qub_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","«Israel-masiquicunata willapanqui: Goycunäpaj caycaj nasyunman chayaycorga murupacushanta rutur juc manöjuta cüramanraj apanga ‹rimir-punta shuntar raquishämi› nir. ");
INSERT INTO qub_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","Chay apashayquitami cüraga säbadu jamay junajpa warannin cuyuchir nogata ricachimanga. Chaynöpami noga bindisyunta churashaj. ");
INSERT INTO qub_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","Manöjuta apamushan junajlla nogapaj rupachina sacrifisyuta apamonga watayoj sänu cashnitapis. ");
INSERT INTO qub_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","Chay cashnita apamur chuscu quïlu medyan jarinatapis asëtillawan chapushata apamonga chaqui micuy ofrendapaj. Chaycunata rupachiptin jömuynenga nogapa shongöpäno canga. Juc litru bïnutapis jichaypa garamänanpaj apamonga. ");
INSERT INTO qub_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","Chay ofrendanta nogapaj manaraj apamorga ama micongarächu tantata, ancasha rïguta, ni chayraj cusichashantapis. Chay nishäcunaga imaycamapis laymi canga paycunapaj paycunapita mirajcunapäpis. ");
INSERT INTO qub_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","«Rimir pogoj manöjuta säbadu jamay junajpa warannin cuyuchir ricachipämashan junajpita-pacha yupanqui ganchis semäna cumlëtuta. ");
INSERT INTO qub_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","Warannin säbadu jamay junajnintenga chayanga pichga chunca junajmanna. Chay junajnami mushoj cusichashan rïgu ofrendata apamonga. ");
INSERT INTO qub_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","Wasinpita apamonga lebadürawan rurasha ishcay tantata. Chay tantataga ruranga chuscu quïlu jarinapita. Chay ofrendataga ‹rimir-punta shuntar raquishämi› nir cuyuchir ricachiypa garamanga. ");
INSERT INTO qub_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","Tantata apamurmi garamänanpaj apamonga juc watayoj ganchis sänu cashnicunata, juc töru-mallwata, ishcay carnicunatapis. Chay apamushan uywacunata, chaqui micuy ofrendatawan bïnuta altarcho cüra rupachiptinmi jömuynin nogapa shongöpäno canga. ");
INSERT INTO qub_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","«Juc chïbutapis juchapita sacrifisyupaj pishtanga. Alli goyaypita sacrifisyutapis pishtananpaj watayoj ishcay cashnita apamonga. ");
INSERT INTO qub_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","Chay uywacunataga cürami cuyuchir ricachiypa entregamanga rimir-punta pogojpita shuntashpan raquir rurashan tantatawan y ishcan cashnicunatawan iwal. Chaycunaga nogapaj carmi cüracuna micunanpaj canga. ");
INSERT INTO qub_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","«Chay junäga llapayqui shuntacanqui nogata rispitamänayquipaj. Ama arunquichu. Chay nishäcunaga imaycamapis laymi canga gamcunapaj gamcunapita mirajcunapäpis. ");
INSERT INTO qub_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","«Micuyniquita cusichar ama shuntanquichu ashiycur ashiycorga. Shicwaj ispïjacunatapis ama shuntanquichu. Cachaycunqui pobricunawan lagacamojcuna shuntacunanpaj. Noga Tayta Diosniquimi chayno në.» ");
INSERT INTO qub_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","Moisesta Tayta Dios niran: ");
INSERT INTO qub_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","«Israel-masiquicunata willanqui: Trompëta tucay fistata rispëtuwan ruranqui. Ganchis quillaman gallaycunan rimir junäga llapayqui rispitamashpayqui jamanqui. Trompëtacunata tucashpayqui chay fistata ruranqui. ");
INSERT INTO qub_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","Chay junäga nogata aduramar ofrendacunata rupachinqui. Ama arunquichu.» ");
INSERT INTO qub_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","Moisesta Tayta Dios niran: ");
INSERT INTO qub_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","«Perdun Tarina fistatapis rispëtuwan ruranqui. Chay fistataga rispitamar ruranqui ganchis quillallacho chunca junajnincho. Ayunanqui. Ofrendata garamar nogapaj rupachinqui. ");
INSERT INTO qub_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","Perdun Tarina junaj captin ama arunquichu. Chay junajmi gamcunata perdunashayquipaj. ");
INSERT INTO qub_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","Chay junaj mana ayunaj cäga pï carpis marcayquipita gargushami canga. ");
INSERT INTO qub_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","Ayunananpa ruquin imatapis aroj cajtaga pï captinpis usharishämi. ");
INSERT INTO qub_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","«Chayno caycaptenga chay junaj ama arunquichu. Chay nishäcunaga imaycamapis laymi canga gamcunapaj gamcunapita mirajcunapäpis. ");
INSERT INTO qub_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","Chay junäga jamanqui, ayunanqui. Ayunayta gallaycunqui chay quillacho isgun junaj caj tardillapitana warannin tardicama.» ");
INSERT INTO qub_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","Moisesta Tayta Dios niran: ");
INSERT INTO qub_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","«Israel-masiquicunata willapay: Ramäda fistatapis rispitamar ruranqui. Ganchis caj quillallacho chunca pichga junajnin gallayconga. Chay fistataga ruranqui ganchis junajmi. ");
INSERT INTO qub_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","Rimir junäga rispëtuwan shuntacanqui. Ama arunquichu. ");
INSERT INTO qub_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","Ganchis junaj fistata rurashpayqui cada junaj rupachiypa ofrendata garamanqui. Pusaj junaj cajchöpis rispëtuwan shuntacanqui. Chay junajpis nogata garamar ofrendata rupachinqui. Fista captinmi ama arunquichu. ");
INSERT INTO qub_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","«Ganchis caj quillacho chay fistacunami caycan shuntacaycur nogata aduramänayquipaj. Chay fistacunacho noga nishäno altarcho rupachinayquipämi apamunqui uywacunata, chaqui micuy ofrendacunatapis. Bïnutapis apamunqui wiñapänanpaj. ");
INSERT INTO qub_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","Chay fistacunataga ruranqui jamay junajcuna rurashayquipita shuyni. Fistacunapaj apamushayqui uywacunawan ofrendacuna shuynimi canga waquin ofrendacunapita, pishtanayquipaj apamushayquipitapis. Aunishayquita cumlir pishtanayquipaj apamushayquipitapis, quiquiquipa buluntäniquipita pishtanayquipaj apamushayquipitapis shuynimi canga. ");
INSERT INTO qub_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","«Ganchis quillacho chunca pichga junajnincho cosëchata shuntaycur rispitamashpayqui fistata ruranqui ganchis junajmi. Gallarinan junajpis ushanan junaj waranninpis jamanqui. ");
INSERT INTO qub_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","Chay fista rimir junaj cajchöga alli caj yöra wayushanta pallanqui. Mutunqui palmapa rämancunata, cupösu yörapa rämancunata, mayu wayaucunapa rämancunata. Nircur nogata rispitamashpayqui ñaupächo ganchis junaj cushisha goturpanqui. ");
INSERT INTO qub_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","Cada wata ganchis caj quillachöga nogata rispitamar ganchis junaj fistata ruranqui. Chay nishäcunaga imaycamapis laymi canga gamcunapaj gamcunapita mirajcunapäpis. ");
INSERT INTO qub_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","Israelcunaga ganchis junajnintin Ramädallacho goyanqui. ");
INSERT INTO qub_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","Chayno ruraptiquimi wamrayquicunapis musyanga gamcunata Egiptupita jorgamur Ramädacunallacho tiyachishäta. Noga Tayta Diosniquimi chayno në.» ");
INSERT INTO qub_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","Chaynömi Moisesga Israelcunata willaparan Tayta Diosta rispitar fistacunata rurananpaj. ");
INSERT INTO qub_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","Moisesta Tayta Dios niran: ");
INSERT INTO qub_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","«Israel-masiquicunata willapay: Olivo asëtillata apamonga candilëru waran-waran rataycänanpaj. ");
INSERT INTO qub_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","Tincuna Toldu ruricho warayllata achqui ratananpaj Aaronnami lamparincunata camarenga. Babulta chaparaycaj tëla ñaupanchömi ratanga. Chay nishäcunaga imaycamapis laymi canga gamcunapaj gamcunapita mirajcunapäpis. ");
INSERT INTO qub_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","Lamparincunataga gori candilërupa puntanman camacächenga ñaupächo warayllata ratananpaj. ");
INSERT INTO qub_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","«Alli caj jarinapita ruranqui chunca ishcay tantata. Cada tantata ruranqui chuscu quïlu medyan jarinapita. ");
INSERT INTO qub_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","Nircur chunca ishcay tantacunataga ñaupächo caycaj gori mësaman churanqui ishcay pachaman sojtata-cama. ");
INSERT INTO qub_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","Cada fïla tantaman churanqui alli caj insinsutapis. Chay insinsutami tantapa ruquin rupachinqui. ");
INSERT INTO qub_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","Chaytaga cada säbadu jamay junajmi ñaupäman churanqui. Chaycunata imaypis ruranqui Israel runacunawan conträtu rurashäta cumlirmi. ");
INSERT INTO qub_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","Chay tantacunataga acrasha rispitädu pachacho miconga Aaronllami, paypita mirar aywaj cüracunallami. Chay tantacunaga nogata rupachiypa garamashan ofrendacunapita mas rispitädu cajmi. Chay laytaga imaypis cumlenga.» ");
INSERT INTO qub_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","Juc runapa maman caran Israel warmi. Taytannami caran Egipto runa. Chay warmipa wawanmi juc junaj tiyarcaycashancho Israel-masinwan rimanacur ");
INSERT INTO qub_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","Tayta Diospa contran rimar manacajman churaran. Chayno parlashanta wiyajcunami Moisesman aparan. Chay runapa mamanpa jutinmi caran Selomit. Selomitpa taytannami caran Dibri. Dibrega caran Dan trïbupitami. ");
INSERT INTO qub_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","Nircur Diospa contran rimaj runataga prësu charararan imata rurananpäpis Tayta Dios ninancama. ");
INSERT INTO qub_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","Chaypitana Moisesta Tayta Dios niran: ");
INSERT INTO qub_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","«Conträ parlaj runata tiyaycashayquicunapita juc-läman jorguy. Conträ parlashanta wiyajcunaga chay runapa uman jananman maquincunata churachun. Nircurna llapan sajmayllapa wañuchichun. ");
INSERT INTO qub_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","Quiquin Israelcunatana ninqui: ‹Pipis nogapa conträ rimar, jutëta manacajman churäga quiquinmi juchayoj ricacun.› ");
INSERT INTO qub_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","Chay runataga llapan runacunami sajmaycällar wañuchenga. Lagacamoj runa carpis, Israel runa carpis ashllimaj cäga llapanmi wañuchicanga. ");
INSERT INTO qub_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","«Juc runata wañuchej runaga quiquinpis wañuchicanga. ");
INSERT INTO qub_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","«Jucpa uywanta wañucherga ruquinta cutichenga. Ima uywatapis cashgan uywanpa cutichenga. ");
INSERT INTO qub_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","«Juc runa pitapis magar malubraptenga quiquintapis jucninta malubrashanno rurachun. ");
INSERT INTO qub_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","Magashancho imantapis paquisha captin, quiquinpatapis paquipanga. Ñawinta gaprasha captenga ñawillanta gaprapanga. Quirun yargojpaj magasha captenga quirullanta jorgupanga. Runa-masin imanömi ñacan, chayno quiquinpis nanaywan ñacanan caycan. ");
INSERT INTO qub_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","«Pipa ima uywantapis wañucherga ruquinta ichichenga. Runa-masinta wañuchiptinmi ichanga quiquintapis wañuchenga. ");
INSERT INTO qub_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","«Chay willapashä laycunataga cumlenga Israelcunapis lagacamoj runacunapis. Noga Tayta Diosniquimi chayno në.» ");
INSERT INTO qub_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","Moisesna Tayta Dios imano nishantapis llapan Israelcunata willaran. Chaymi runacunaga tiyaycashanpita juc-läman jorguran Tayta Diospa contran rimaj runata. Chaychöna llapan runa sajmaypa wañuchiran. Israel runacunaga ruraran Moisesta Tayta Dios nishannömi. ");
INSERT INTO qub_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","Sinaí puntacho Moisesta Tayta Dios niran: ");
INSERT INTO qub_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","«Llapan Israelcunata willapanqui: Goycunäpaj caycaj nasyunman chayarga nogata rispitamar chacrata jamachinqui. ");
INSERT INTO qub_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","Chacracunataga sojta watami murunqui. Übas lantancunatapis chillguejcunata sojta watami rämanqui. Wayuynintapis chay watacunallachömi pallanqui. ");
INSERT INTO qub_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","Ganchis wata cajchömi ichanga nogata rispitamar chacrata jamachinqui. Imatapis ama murunquichu; ni übas lantancunatapis ama rämanquichu. ");
INSERT INTO qub_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","Shiwa rïgutapis ama rutunquinachu. Rämäni übas wayushantapis ama pallanquinachu. Chay wataga watanpami chacra jamanga. ");
INSERT INTO qub_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","Chacra jamashan wataga mana aruycaptinpis micuy wayongami. Aypanga llapan uywaynincunawan micunanpämi. Chayllami aypanga piyunniquicuna micunanpaj, lagacamoj runacuna micunanpäpis. ");
INSERT INTO qub_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","Uywayquicuna micunanpaj, jirca animalcuna micunanpäpis chay wayushallanmi aypanga. ");
INSERT INTO qub_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","«Gamcuna yupanqui chuscu chunca isgunnin (49) watata. ");
INSERT INTO qub_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","Chuscu chunca isgun (49) wata päsarcuptin ganchis caj quilla chunca junajninchöga canga Perdun Tarina Junajmi. Chay junäga nasyunniquicho intërucho tucachinqui carnipa wagranpita rurasha tucanata. ");
INSERT INTO qub_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","Chaynömi pichga chunca wata (50) cajtaga ‹Tayta Diospaj acrasha rispitädu wata› ninqui. Chay watachöga llapanta cacharinanpaj willacachinqui. Chaymi llapanta cacharengana. Rantiy runacunapis famillyanmanna, chacrancunamanna cuticonga. ");
INSERT INTO qub_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","Pichga chunca (50) watachöga cachaycunan watami canga. Chaymi chay watachöga ama murupacunquichu. Shiwa rïgutapis ama shuntanquichu. Übas lantancunatapis ama rämanquichu, wayuynintapis ama pallanquichu. ");
INSERT INTO qub_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","Chay wataga cachaycunan wata captinmi rispitädu wata canga. Micuytapis micunqui chacra quiquillan wayushantami. ");
INSERT INTO qub_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","«Chay cachaycunan watachöga chacrancunata rimir duyñuncunana shuntanga. ");
INSERT INTO qub_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","Chayno caycaptenga pipis chacrata rantir, ni ranticurpis runa-masiquita ama engañanquichu. ");
INSERT INTO qub_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","Cachaycunan watapaj ayca wata pishiycashantapis yuparirmi rantëga risyunta päganga. Ranticoj cajpis ranticonga ayca cuti chacrata murunanpaj cashantapis yuparirna. ");
INSERT INTO qub_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","Achca wataraj murunan captenga mas chaninmi canga. Wallca watallana murunanpaj pishiptenga wallcallatanami päganga. Chacrataga ranticonga ayca cosëchatapis shuntananpaj cashanpitami. ");
INSERT INTO qub_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","«Ama mayganiquipis engañanacunquichu. Nogata rispitamanqui. Nogami cä Tayta Diosniqui. ");
INSERT INTO qub_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","Laynëcunata cumlinqui. Willapashäcunata wiyacunqui. Chauraga nasyunniquicho allillami cawanqui. ");
INSERT INTO qub_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","Chacrapis allimi wayuchenga. Wayushancunatapis sacsaj micunquipaj. Chaura cushishami goyanquipaj. ");
INSERT INTO qub_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","«Gamcuna capas yarpachacunqui ‹Mana murupacorga, mana micuyta shuntarga ¿imataraj micushun ganchis caj wata chayamuptin?› nir. ");
INSERT INTO qub_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","Chaypäga ama yarpachacunquichu. Bindisyunnëwanmi sojta wata cajchöga aypallata shuntanquipaj. Chay shuntashayquicunaga düranga asta quimsa watacamarämi. ");
INSERT INTO qub_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","Chaymi churashan micuyllata micunquipaj pusaj wataman chayar murupacushan wichanpis. Asta isgun wataman chayarpis chay churashayqui micuyllatarämi micurcaycanquipaj murushayqui pogumuptin shuntanayquicama. ");
INSERT INTO qub_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","«Chacraga nogapami. Gamcunaga gorpanöllami päsacojllami chacracho tiyarcaycanqui. Chaymi rantejpa maquinchöga yupasha watalla canga. ");
INSERT INTO qub_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","Pipis rantishan chacrata ranticuyta munarga ñaupa caj duyñuntaraj munachenga. ");
INSERT INTO qub_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","«Marca-masiquicuna mayganpis fiyupa ushapacashpan chacranta ranticuycuptenga lijïtimu caj famillyan chay chacrata shuntanmanmi. ");
INSERT INTO qub_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","«Chacranta shuntananpaj lijïtimu famillyan pipis mana captenga quiquin chacranta shuntananpaj guellayta camarir ");
INSERT INTO qub_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","yupanga ayca watana ranticushan cashantapis. Rantej runataga guellayninta cutichenga ayca watapis murushanpita raquicurirna. Nircorga quiquin duyñunnami chacranta shuntanga. ");
INSERT INTO qub_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","Chacranta shuntananpaj guellayta mana aypächiptenga rantejpa maquillancho caconga cachaycunan wata chayamunancama. Chay wata chayamuptenga duyñunna chacrata shuntaconga. ");
INSERT INTO qub_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","«Pipis curalasha siudächo wasinta ranticuycuptenga juc watallami timpu canga shuntananpaj. ");
INSERT INTO qub_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","Watacama wasinta mana shuntaptenga imaycamapis quëdaconga rantejpäna, rantejpa wamrancunapäna. Cachaycunan wata chayamuptinpis manami shuntanganachu. ");
INSERT INTO qub_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","Chacracunacho caj wasicunatami ichanga chacrata-japuy imaypis shuntanman. Cachaycunan wata chayaptinpis rimir caj duyñun shuntangami. ");
INSERT INTO qub_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","«Leví trïbu runacunami ichanga siudänincho caycaj wasi ranticushanta imaypis shuntanga. ");
INSERT INTO qub_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","Cachaycunan watachöga wasita rantej runa cutichenga. Leví trïbu runacunapa marcancho wasillanmi partisyunnin caycan. Israel nasyuncho paycunapäga manami mas ima partisyunninpis canchu. ");
INSERT INTO qub_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","Leví trïbu runacunapa siudänin cantuncunapa caycaj uywa michicunan ichanga canga imaypis mana ranticuna. Chaycunaga imaycamapis quiquincunapa chacranmi canga. ");
INSERT INTO qub_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","«Marca-masiquicuna ushapacar mayganiquimanpis guellicamuptenga yanapanqui juc-lä nasyun runa pachacojtano. ");
INSERT INTO qub_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","Imatapis ama guechunquichu. Imata mañarpis ama ‹pägamay› ninquichu. Chaypa ruquenga nogata manchapacamar marca-masiquita tiyachinqui. ");
INSERT INTO qub_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","Guellayta ristashpayquipis ama ‹wawantawan cutichimay› ninquichu. Micuycunata goshayquipitapis ama mas chanintaga cobranquichu. ");
INSERT INTO qub_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","Nogami Egipto nasyunpita jorgamoj Tayta Diosniqui cä. Gamcunataga jorgamushcä Canaán nasyunta goycunäpämi, Diosniqui canäpämi. ");
INSERT INTO qub_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","«Marca-masiqui ushapacar ‹maquillayquichöna goyäcushaj› nishuptiqui chay runata ama fiyupa aruchinquichu uyway runatanöga. ");
INSERT INTO qub_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","Chay runataga ricanqui gorpayquitano, piyunniquitano. Cachaycuna wata chayamunancamami arupäshunquipaj. ");
INSERT INTO qub_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","Chaypita ichanga wasiquipita aywaconga wamrancunawan. Cuticonga castancunamanna, chacrancunamanna. ");
INSERT INTO qub_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","Israelcunaga sirbimajnëcunami. Paycunataga Egiptupitami jorgamushcä. Chaymi paycunataga jäpatano ama ranticongachu. ");
INSERT INTO qub_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","Paycunataga ama ñacachinquichu. Chaypa ruquenga nogata rispitamashpayqui alli ricanqui. ");
INSERT INTO qub_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","«Uyway runacunata charayta munarga warmita ollgutapis juc nasyuncunapita rantinqui. ");
INSERT INTO qub_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","Lagacamoj runacunatapis rantinquimanmi. Israelcunacho tiyashancamaga rantinquimanmi lagacoj runacunapa jinancho yurej wamrancunatapis. Paycunatami ichanga rantinqui duyñunna canayquipaj. ");
INSERT INTO qub_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","Wañucorga wamrayquicunata sirbinanpäpis cachapaycunquimanmi. Paycunaga mandäduntami ruranga. Israel-masiquitami ichanga ama munayniquicho chararanquichu; ama ñacachinquichu. ");
INSERT INTO qub_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","«Lagacamoj runa nasyunniquicho capas rïcuyanman. Rïcu runapa bisïnun marca-masiquina capas pobriyanman. Lagacamoj nasyun runacunaman quiquin guellicuptin ");
INSERT INTO qub_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","pägaycur castan jorgunmanmi. Jorgunmanmi marca-masin ");
INSERT INTO qub_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","tiyun, prïmun, lijïtimu famillyancuna. Guellaynin captenga quiquinpis llojshicunanpaj päganmanmi. ");
INSERT INTO qub_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","Yupanga ayca watapis sirbishanta, Cachaycunan watapaj ayca wata pishishantapis. Cachaycunan watapaj ayca watapis pishishanpitami päganga. Arupashantaga piyunta pägashan iwalmi cuentata jorgonga. ");
INSERT INTO qub_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","Cachaycunan wata Chayamunanpaj ayca watapis pishishan-tupumi patrunninta päganga. Achca watacunaraj pishiptenga mastami päganga. ");
INSERT INTO qub_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","Wallca watana Cachaycunan watapaj pishiptenga pishishan watallapitana guellayta päganga. ");
INSERT INTO qub_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","Patronga watanpa arupänanpaj parlashan runatanölla aruchenga. Ama ñacachengachu. ");
INSERT INTO qub_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","«Chay watacunacho llojshinanpaj pägayta mana camäpacorga Cachaycunan wata chayamuptin wamrancunawan librimi llojshiconga. ");
INSERT INTO qub_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","Manami pipapis uywaynin cananpächu Israel runacunata Egiptupita jorgamushcä, chaypa ruquenga nogata sirbimänanpämi. Noga Tayta Diosniquimi chayno në. ");
INSERT INTO qub_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","«Noga Tayta Diosniqui caycaptëga ima ïdulutapis ruraycur ama aduranquichu. Wanca rumicunatapis ni dibujasha rumicunatapis ama ichichinquichu aduranayquipaj. ");
INSERT INTO qub_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","Säbadu jamay junajcunachöga rispitamar jamanqui. Tiyashä Toldutapis rispitanqui. Noga Tayta Diosmi chayno në. ");
INSERT INTO qub_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","«Noga nishäta ruraptiquega, laynëcunata cumliptiquega ");
INSERT INTO qub_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","tamyatapis tamyachimushaj timpunchömi. Chacrapis, lanta yöracunapis allimi wayonga. ");
INSERT INTO qub_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","Rïguyquipis aypangapaj übas pogumunancamami. Übasnami aypangapaj murupacunayquicama. Sumaj micushami cawanquipaj. Nasyunniquichöpis allimi goyäcunquipaj. ");
INSERT INTO qub_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","Tiyashayqui nasyunchöga jaucallami goyäcunquipaj. Mishquilla puñucunquipaj. Nogami chapäshayqui micucoj animalcunapita. Wañuchinacuypis manami cangachu. ");
INSERT INTO qub_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","Guërrata rurananpaj contrayquicuna shamuptinpis binsir gaticachanquipämi. Chay contrayquicunataga sabliwanmi wañuchinquipaj. ");
INSERT INTO qub_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","Pichgajllami gaticachanquipaj pachacta (100). Pachacna gaticachanquipaj chunca warangata (10,000). Contrayquicunataga sabliwan wañuchirmi ushanquipaj. ");
INSERT INTO qub_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","Conträtuta rurashanchïnöllami alli ricashaj achcaman miranayquipaj. ");
INSERT INTO qub_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","Unay unaypita churaraj micuyniquicunatami micunquipaj. Mushoj cajta churanayquipäpis maranyasha micuyniquicunata jorgunquipärämi. ");
INSERT INTO qub_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","«Chaynöpis gamcunachömi imaypis goyäshaj. Manami imaypis yamacäshayquichu. ");
INSERT INTO qub_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","Maypa puriptiquipis gamcunawan iwalmi purishaj. Nogami Diosniqui cashaj. Gamcunanami acrashä runacuna canquipaj. ");
INSERT INTO qub_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","Noga Tayta Diosniquimi Egipto runacunapa munaynincho caycaptiqui jorgamushcä. Yuntata fiyupa lasaj yügu ñacachejnöpis ñacaycaptiquimi jorgamurä. Nircur llapanchöpis allimi purichishcä. ");
INSERT INTO qub_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","«Noga nishäcunata mana wiyacuptiqui, ");
INSERT INTO qub_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","laynëcunata mana cumliptiqui, manacajman churaptiqui, conträtuta rurashäta mana cumliptiqui ichanga ");
INSERT INTO qub_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","Nogapis illajpita mancharachishayqui, gueshyachishayqui rupaywan, fiyu gueshyacunawan, ñawi nanaycunawan. Callpayquipis manami cangachu. Murupacurpis manami shuntanquipänachu. Poguptin-imaga chiquishojcunallami micongapaj. ");
INSERT INTO qub_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","Nogaga manami yanapäshayquipänachu. Chiquishojcunapis binsishunquipämi. Waquenga chiquejcunapa munayninchönami canga. Imapis mana gaticachaycäshuptiquimi gueshpinquipäpis. ");
INSERT INTO qub_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","«Chayno ruraycaptëpis mana wiyacamaptiquega juchayquicunapita ganchis cuti mas fiyuparämi castigashayqui. ");
INSERT INTO qub_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","Alli-tucurcaycajtami manacajman churashayqui. Cay pachamanpis manana tamyachimushänachu. Chauraga allpapis manami imatapis wayonganachu. ");
INSERT INTO qub_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","Yangallanami chacrachöpis arur ñacanqui. Chacrapis manami imatapis wayonganachu. Lanta yöracunapis manami wayonganachu. ");
INSERT INTO qub_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","«Chayno ruraycaptëpis sïguir conträ captiquega, nishäcunata mana wiyacuptiquega juchayqui cashanmannömi ganchis cuti mas fiyuparaj castigashayqui. ");
INSERT INTO qub_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","Micucoj animalcunatami cachamushaj. Chauraga chay animalcunami wamrayquicunata miconga; uywayquicunatapis ushanga. Chaynöpami gamcunaga wallcajllana quëdanquipaj. Chauraga näniquicunapis chunyajna ricaconga. ");
INSERT INTO qub_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","«Chayno castigaycaptëpis mana wiyacur chaynölla conträ sïguir rurarcaycaptiquega ");
INSERT INTO qub_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","nogapis contrayquimi ricacushäpaj. Chaymi juchayquicunapitaga ganchis cuti mas fiyuparaj castigashayqui. ");
INSERT INTO qub_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","Mana cumliptiquega conträtuta rurar parlashanchïcho nishänömi castïguta gamcunaman chayachimushaj. Siudäniquicunaman pacacunayquipaj gueshpiptiquipis fiyu gueshyatami cachamushaj. Chauraga contrayquicunapa munayninchöna canquipaj. ");
INSERT INTO qub_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","Micuyniquicunata pasaypami illgächishaj. Jarinata pishipacur chunca warmi shuntacaycur juc pachallachöna tantata ruranquipaj. Ichic-ichicllanami yawarcärinquipäpis. Manami sacsanquipäpischu. ");
INSERT INTO qub_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","«Chayno castigaycaptëpis mana wiyacamar jinalla conträ rurarcaycaptiquega ");
INSERT INTO qub_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","nogapis contrayquimi cashaj. Rabyashpämi juchayquicunapita ganchis cuti mas fiyuparaj castigashayqui. ");
INSERT INTO qub_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","Chauraga wamrayquicunata ollguta, warmitapis micunquipaj. ");
INSERT INTO qub_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","Lömacunacho ïdulucunata aduranayquipaj jatarachishayqui capillayquicunatapis juchuchishaj. Insinsu saumachicunayquitapis paquir-usharishaj. Wañuptiqui ïdulucuna jananmanmi wicapashayqui. Chayno rurar fiyupami contrayqui ricacushaj. ");
INSERT INTO qub_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","Siudäniquicunatapis ragällantami cachaycushaj. Capillayquicunatapis juchurachishaj. Nogapaj alli jömuy chayamunanpaj uywacunata rupachiptiquipis manami cushicushänachu. ");
INSERT INTO qub_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","«Chay nasyun runacunata ushaypa wañuchishaj. Chaymi contrayquicuna tiyaj shamushpanpis manchacasharaj ricaconga. ");
INSERT INTO qub_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","Gamcunataga sablita aptacurcurmi gaticachäshayqui. Wacpa caypami mashtarishayqui. Nasyunniquega pasaypa chunyajmi ricacongapaj. Siudäniquicunapis ragällami quëdanga. ");
INSERT INTO qub_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","Chacrayquicunata jamachinayquipaj niycaptëpis mana jamachiypa murushayquipitami contrayquicunapa nasyunnincho cashayquiyaj chacrayquicunapis jamacongapaj. ");
INSERT INTO qub_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","Chunyaj car purunyashancamami chacraga jamacongapaj jamachina watacunachöpis mana jamachishanpita. ");
INSERT INTO qub_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","«Contrayquicunapa nasyunnincho cawaycar quëdajcunataga fiyupami mancharachishaj. Chaymi jachapa öjan shicwaptillanpis gueshpinquipaj ‹sabliwan gaticachaycäman› nir. Pipis mana gaticachaycäshuptillayquimi gueshpir quiquillayqui tuninquipaj. ");
INSERT INTO qub_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","Pipis mana gaticachaycäshuptiquimi guërrapita gueshpiycajno tacanacur-raj gueshpinquipaj. Gamcunaga manami maygayquipis contrayquicunata ichipanquipächu. ");
INSERT INTO qub_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","Juc-lä nasyuncunachömi ushacanquipaj. Contrayquicunami marcayquicho wañuchishunquipaj. ");
INSERT INTO qub_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","Contrayquicunapa nasyunnincho cawaycar quëdajcunapis juchanpitami wañonga. ¡Cawaycar quëdaj wamrayquicunapis wañur ushacangapämi! ");
INSERT INTO qub_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","41","«Mana wiyacamar conträ rurashanpita, nogapis contran ricacur contrancunapa nasyunninman apachishaj. Chaychörämi quiquin jucha rurashanpita, taytancuna jucha rurashanpita llaquiconga, juchancunapita arpinticonga. ");
INSERT INTO qub_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","Chauraga nogapis yarpärishäpaj Jacobwan, Isaacwan, Abrahamwan conträtuta rurar parlacushäta. Chaynöllami nasyunninpäpis yarpärishäpaj. ");
INSERT INTO qub_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","Israelcuna mana tiyashancamaga chacracuna jamacongapämi. Pipis manami arongapächu. Israelcunami ichanga imatapis mana allicunata rurashanpita, noga willapashäcunata mana wiyacushanpita, laynëcunata manacajman churashanpita amatar ñacangapaj. ");
INSERT INTO qub_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","«Ichanga, contrancunapa nasyunnincho tiyaycaptinpis manami gongashächu, ni cachaycushäpischu. Manami ushajpäga illgächishächu, ni unay caj famillyancunawan conträtuta rurar parlacushätapis manami gongashächu. Chaynöga cashaj Israelcunapa Tayta Diosnin cashpämi. ");
INSERT INTO qub_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","Gonganäpa ruquenga yarpäshäpaj llapan nasyuncunata musyachir Egiptupita jorgamur unay caj famillyancunawan conträtuta rurar parlacushätami. Paycunawan conträtuta rurashpä ‹Nogami Diosniqui cashaj› nirä. Noga Tayta Diosniquimi chayno në.» ");
INSERT INTO qub_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","Chayno nirmi Tayta Diosga Sinaí puntacho laynincunata, mandamintuncunata, yachachicuynincunata Israelcunata Moiseswan willachiran. ");
INSERT INTO qub_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","Moisesta Tayta Dios niran: ");
INSERT INTO qub_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","«Israel-masiquicunata willapanqui: Pipis castanta maquëman churamunanpaj aunishpanga ruquinta caynömi päganga: ");
INSERT INTO qub_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","Ishcay chunca (20) watayojpita sojta chunca (60) watayojcama ollgupaj päganga pichga chunca (50) guellayta. Chay guellayta pësanga Tincuna Tolducho caycaj pësawanmi. ");
INSERT INTO qub_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","Chay watayojlla caycaj warmipäga päganga quimsa chunca (30) guellayta. ");
INSERT INTO qub_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","Pichga watayojpita ishcay chunca (20) watayojcama ollgöpäga päganga ishcay chunca (20) guellayta. Chay watayojlla caycaj warmipäga päganga chunca guellayta. ");
INSERT INTO qub_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","Quillayojpita pichga watayojcamaga ollgupaj pägapanga pichga guellayta; warmipäna quimsa guellayta. ");
INSERT INTO qub_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","Rucu runacuna sojta chunca (60) watayojpita janaman cajpäna päganga ollgu cajcunapaj chunca pichga (15) guellayta; warmi cajpäna chunca guellayta. ");
INSERT INTO qub_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","Pasaypa pobri cashpan pägananpaj mana ayparga cürata willanga. Chaura cürana nenga aycatapis pägananpaj. ");
INSERT INTO qub_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","«Uywacunata nogapaj goycamashan cäga nogapaj car rispitädunami canga. ");
INSERT INTO qub_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","Goycamashan uywataga mananami ima uywawanpis rucachenganachu, mas alli captin mana alli captinpis. Rucananpaj apamuptenga ishcannami nogapaj canga. ");
INSERT INTO qub_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","«Nogapaj raquishan ofrenda ganra uywa captinpis cüraman apanga. ");
INSERT INTO qub_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","Chay uywata ricaycur cüranami risyunta churanga. Cüra aycatapis nishantami uywapa duyñonga päganga. ");
INSERT INTO qub_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","Chay uywata duyñun shuntacuyta munaptenga risyunta pägaycurpis jananman cada chunca guellaypita ishcaytaraj yapanga. Nircur-raj shuntaconga. ");
INSERT INTO qub_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","«Nogapäna cananpaj pipis wasinta goycamaptin wasita cüra täsanga. Chaura cüra aycachöpis risyunta täsashanchömi risyun quëdanga. ");
INSERT INTO qub_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","Nogapäna cananpaj wasinta goycamashanpita shuntayta munar duyñonga cüra täsashanta päganga. Jananmanpis cada chunca guellaypita ishcaytaraj yapanga. Chayno pägaycur-raj shuntanga. ");
INSERT INTO qub_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","«Pipis, nogapäna chacrata goycamaptenga chay chacrata täsanga muru aycapis yaycushanpita. Chunca pusajnin (18) arröba sebäda muruta yaycuptin päganga pichga chunca (50) guellayta. ");
INSERT INTO qub_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","Cachaycunan watacho chacranta goycamaptinpis cüra täsashannömi risyun quëdanga. ");
INSERT INTO qub_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","Cachaycunan wata päsashanpitana goycamaptenga cürami täsanga ayca cuestananpäpis. Nircur Cachaycunan watapaj aycapis pishiycashanta yuparcur risyunta churanga. ");
INSERT INTO qub_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","«Chacranta goycamashanpita shuntayta munar cüra täsashan risyunta päganga. Jananmanpis cada chunca guellaypita ishcaytaraj yapanga. Chayno pägaycur ichanga chacranta shuntaconga. ");
INSERT INTO qub_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","Quiquin mana shuntaptin chay chacrata juctana cüra ranticuycuptenga rimir duyñun manami shuntanganachu. ");
INSERT INTO qub_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","Cachaycunan wata chayamuptin chay chacraga nogapana canga. Chaura cüranami chay chacrawanga duyñu canga. ");
INSERT INTO qub_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","«Pipis derëchun mana caycaptin rantishan chacrata nogata goycamaptenga ");
INSERT INTO qub_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","cürana chay runawan ishcan chacrata täsanga Cachaycunan watacama ayca risyun cashantapis. Chay runana chay junajlla päganga aycatapis cüra täsashanta. Chay guellaytaga nogapäna churanga. ");
INSERT INTO qub_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","Cachaycunan wata chayamuptin chay chacraga cutenga rimir caj duyñunmanna. ");
INSERT INTO qub_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","«Aycata pägananpäpis täsanga Tincuna Tolducho tupu caycajwanmi. Chayga lasan chunca juc (11) grämumi. ");
INSERT INTO qub_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","«Uywayquicunapa rimir yurishan orgu cajcunaga uysha carpis wäca carpis nogapanami caycan. Chayno caycaptenga uywata nogapaj gomayta munar nogapa cajtaga ama gomächunchu, sinöga quiquinpa cajta apamuchun. ");
INSERT INTO qub_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","Ganra uywa captenga duyñun rantiypa jorgonga. Cüra täsashan risyunta päganga. Jananmanpis cada chunca guellaypita ishcaytaraj yapanga. Duyñun mana shuntaptenga cüra risyuta churashancho juctana ranticuyconga. ");
INSERT INTO qub_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","«Pipis quiquinpa cajta uywata carpis, runata carpis erensyata chasquishan chacrata carpis ‹imaypis manami shuntashänachu› nir nogapaj goycamaptenga manami ranticongachu ni shuntacongapischu. Chayno nir nogapaj goycamaptenga fiyupa rispitädu car nogapanami canga. ");
INSERT INTO qub_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","Wañuchicänanpaj caycaj runatapis mananami pägaypapis salbangachu. Chay runaga simrimi wañuchicanga. ");
INSERT INTO qub_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","«Allpacho wayoj cäga muruna cajpa wawanpis lantana cajpa wayuyninpis chuncapita jucga nogapämi. Chaycunaga nogapaj raquishan diesmumi caycan. ");
INSERT INTO qub_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","Chay diesmuta raquishanta quiquinpäna cananta munarga risyunta päganga. Jananmanpis pägashan cada chunca guellaypita ishcaytaraj yapanga. ");
INSERT INTO qub_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","«Cada chunca uywapita juc uywataga simrimi goycamanga wäcata carpis, uyshata carpis. ");
INSERT INTO qub_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","Chaycunataga goycamanga mana ricapayllapa alli captinpis mana alli captinpis. Gomashantaga jucwan ama rucanganachu. Rucaptenga ishcanmi uywacuna nogapäna canga. Chaura mananami maygantapis shuntanganachu.» ");
INSERT INTO qub_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","Chaynömi Tayta Diosga Sinaí puntacho Moisesta willaparan chay mandamintucunata llapan Israelcunata willapänanpaj.");
INSERT INTO qub_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","Egiptupita Israelcuna llojshicamushan caran wata juc quilla juc junajninna. Chay junaj paycunaga chunyaj Sinaí jircacho carcaycaran. Chaychömi Tincuna Tolducho Moisesta Tayta Dios niran: ");
INSERT INTO qub_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","«Llapan Israelcunata sinsuy castanpa-cama, famillyanpa-cama ayca cashantapis musyanayquipaj. Ollgu cajcunataga cada-ünunpa jutincunata apuntanqui. ");
INSERT INTO qub_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","Ishcay chunca watayojpita janaman guërraman aywananpaj edäninchöna cajtaga sinsur apuntanqui. Röpanpa röpanpa yupanqui. Sinsuychöga wauguiqui Aaronmi yanapäshunqui. ");
INSERT INTO qub_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","Yanapäshunqui cada trïbupa juc mandajnincunapis. ");
INSERT INTO qub_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","Yanapäshunayquipaj caj mandajcuna caycunami caycan: «Rubén trïbupita yanapäshunqui Sedeurpa wamran Elisur. ");
INSERT INTO qub_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","«Simeón trïbupita yanapäshunqui Zurisadaipa wamran Selumiel. ");
INSERT INTO qub_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","«Judá trïbupita yanapäshunqui Aminadabpa wamran Naasón. ");
INSERT INTO qub_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","«Isacar trïbupita yanapäshunqui Zuarpa wamran Natanael. ");
INSERT INTO qub_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","«Zabulón trïbupita yanapäshunqui Helonpa wamran Eliab. ");
INSERT INTO qub_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","«Josëpa wamrancunapitapis yanapäshunquimi. Efraín trïbupita yanapäshunqui Amihudpa wamran Elisama; Manasés trïbupitana Pedasurpa wamran Gamaliel. ");
INSERT INTO qub_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","«Benjamín trïbupita yanapäshunqui Gedeonipa wamran Abidán. ");
INSERT INTO qub_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","«Dan trïbupita yanapäshunqui Amisadaipa wamran Ahiezer. ");
INSERT INTO qub_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","«Aser trïbupita yanapäshunqui Ocranpa wamran Pagiel. ");
INSERT INTO qub_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","«Gad trïbupita yanapäshunqui Deuelpa wamran Eliasaf. ");
INSERT INTO qub_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","«Neftalí trïbupita yanapäshunqui Enanpa wamran Ahira.» ");
INSERT INTO qub_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","Paycunami caran Israel trïbupita acrashan runacuna. Paycunaga caran cada famillyapa mandajninmi. ");
INSERT INTO qub_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","Chay acrashan runacunawan Moisespis Aaronpis shuntacarmi ");
INSERT INTO qub_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","llapan Israel runacunata gayachiran. Chay caran watacho ishcay quillaman gallaycoj rimir junajmi. Chayno gayaycachirmi sinsuran llapan runacunata cada famillyata, cada castata shuyni-cama, jutincunatapis cada ünunpata. Chayno sinsur apuntaran ishcay chunca watayojpita janaman cajta ayca ollgu cashantapis. ");
INSERT INTO qub_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","Chayta ruraran Moisesta imanöpis Tayta Dios nishannöllami. Sinsuran chunyaj Sinaí jircacho. ");
INSERT INTO qub_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","21","Cada trïbuta, cada castata, cada famillyata sinsur jutincunata apuntaran. Chaura musyaranna ishcay chunca watayojpita janaman, guërraman aywananpaj edäninchöna cajcunalla ayca ollgu cashantapis. Caynömi caran: Israelpa mayur caj wamran Rubén trïbupita 46,500. ");
INSERT INTO qub_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","23","Simeón trïbupita 59,300. ");
INSERT INTO qub_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","25","Gad trïbupita 45,650. ");
INSERT INTO qub_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","27","Judá trïbupita 74,600. ");
INSERT INTO qub_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","29","Isacar trïbupita 54,400. ");
INSERT INTO qub_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","31","Zabulón trïbupita 57,400. ");
INSERT INTO qub_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","35","Josëpa wamran Efraín trïbupita 40,500, Josëpa wamran Manasés trïbupita 32,200. ");
INSERT INTO qub_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","37","Benjamín trïbupita 35,400. ");
INSERT INTO qub_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","39","Dan trïbupita 62,700. ");
INSERT INTO qub_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","41","Aser trïbupita 41,500. ");
INSERT INTO qub_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","43","Neftalí trïbupita 53,400. ");
INSERT INTO qub_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","Moisés, Aarón, cada trïbupita mirajcunapa ruquin shamoj chunca ishcay mandaj (12) Israelcunawan chaynömi sinsuta ruraran. ");
INSERT INTO qub_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","Israelcunaga ishcay chunca (20) watayojpita janaman caj, pillyapaj edäninchöna cajlla ollgu runacuna ");
INSERT INTO qub_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","llapanga caran sojta pachac quimsan waranga pichga pachac pichga chuncan (603,550). ");
INSERT INTO qub_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","Leví trïbu runacunataga waquin Israel-masincunatawan iwal manami sinsuranchu. ");
INSERT INTO qub_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","Chaynöga mana sinsuranchu Moisesta Tayta Dios cayno nisha captinmi: ");
INSERT INTO qub_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","«Israelcunata sinsushpayqui ama sinsunquichu Leví trïbu runacunataga. ");
INSERT INTO qub_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","Leví trïbu runacunataga churanqui Tincuna Tolducho rispitäducuna cajta, chaycho caj llapan cösacunatapis ricananpaj. Paycunallami mayman aywarpis apanga Tincuna Tolduta y llapan ima-aycantapis. Chaychöga paycunallami aronga nogata sirbimashpan. Maychöpis goyanga Tincuna Toldu ñaupancunallacho. ");
INSERT INTO qub_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","Gamcuna juc-läman aywaptiqui paycunami Tincuna Tolduta pascarcur apanga. Tiyanayquipaj mayman chayaptiquipis yapay ichichenga. Mana cüra caycar Tolduman yaycoj cäga wañuchicangami. ");
INSERT INTO qub_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","Waquin Israel trïbucunaga pachaconga suldärucunano, quiquincunapa bandërancuna ñaupallancho. ");
INSERT INTO qub_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","Leví trïbu runacunaga tiyanga Conträtuta rurashanchi churaränan Toldu läduncunallacho. Paycunami täpanga Israelcuna llutalla mana yaycunanpaj. Llutalla yaycuptin-imaga rabyashpä llapan Israel runacunata castigashämi.» ");
INSERT INTO qub_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","Chaura Israelcunaga llapantapis ruraran Moisesta Tayta Dios nishannölla. ");
INSERT INTO qub_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","Aarontawan Moisesta Tayta Dios niran: ");
INSERT INTO qub_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","«Israel runacunaga Tincunanchi Tolduta ichichishanpita mas carullapami tolduncunata tumarej ichichenga. Chayllachömi cada trïbu bandërancunata jawenga maygan trïbu cashanpis rejsicänanpaj. ");
INSERT INTO qub_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","«Judá trïbu runacuna röpanpa röpanpa tolduncunata ichichenga inti yagamunan caj-läman. Bandërantapis jawenga. Judá trïbu runacunapa mandajninmi caycan Aminadabpa wamran Naasón. ");
INSERT INTO qub_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","Chay trïbu runacunaga sinsuptin casha ganchis chunca chuscu waranga sojta pachacninmi (74,600). ");
INSERT INTO qub_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","Paycunapa ñaupanpana tolduncunata ichichenga Isacar trïbu runacuna. Isacar runacunapa mandajninmi Zuarpa wamran Natanael. ");
INSERT INTO qub_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","Sinsuptin paycunaga casha pichga chunca chuscu waranga chuscu pachacnin (54,400) runacuna. ");
INSERT INTO qub_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","Paycunapa ñaupanpana tolduncunata ichichenga Zabulón trïbu runacuna. Zabulón runacunapa mandajninmi Helonpa wamran Eliab. ");
INSERT INTO qub_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","Sinsuptin paycunaga casha pichga chunca ganchis waranga chuscu pachacninmi (57,400). ");
INSERT INTO qub_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","Chaura Judá caj trïbullacho shuntacasha caycanga quimsa trïbucuna. Llapanga canga pachac pusaj chunca sojta waranga chuscu pachacnin (186,400) suldärucuna. Israel runacuna maypapis aywaptin chay trïbu runacunami ñaupanta aywanga. ");
INSERT INTO qub_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","«Sur caj-lämanga röpanpa röpanpa tolduncunata ichichenga Rubén trïbu runacuna. Bandërantapis jawenga. Rubén suldärucunapa mandajnenga Sedeurpa wamran Elisurmi. ");
INSERT INTO qub_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","Chay trïbu runacunaga sinsuptin casha chuscu chunca sojta waranga pichga pachacnin (46,500). ");
INSERT INTO qub_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","Ñaupanpana tolduncunata ichichenga Simeón trïbu runacuna. Simeón trïbu suldärucunapa mandajnenga Zurisadaipa wamran Selumielmi. ");
INSERT INTO qub_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","Sinsuptin paycunaga casha pichga chunca isgun waranga quimsa pachacnin (59,300). ");
INSERT INTO qub_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","Paycunapa ñaupanpa tolduncunata ichichenga Gad trïbu runacuna. Gad suldärucunapa mandajninmi Deuelpa wamran Eliasaf. ");
INSERT INTO qub_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","Sinsuptin paycuna casha chuscu chunca pichga waranga sojta pachac pichga chuncan (45,650). ");
INSERT INTO qub_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","Chaura Rubén trïbu suldärucunapis caycanga quimsa trïbupita juc röpallaman ruracasha. Llapanga canga pachac pichga chunca juc waranga chuscu pachac pichga chuncan (151,450). Paycunaga aywanga rimir caj röpa aywajpa guepallanta. ");
INSERT INTO qub_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","«Chaypitaga Leví trïbu runacunana aywanga. Paycunaga imanömi llapan trïbucuna pachacushan chaupincho goyan, chaynöllami aywacongapis. Paycuna apanga Tincuna Tolduta y llapan ima-aycantapis. Chayashannölla aywaconga cada trïbu bandëranwan-cama. ");
INSERT INTO qub_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","«Efraín trïbu runacunaga röpanpa röpanpa inti yaganan cajcho tolduncunata ichichenga. Bandëranta jawenga. Efraín suldärucunapa mandajninmi Amiudpa wamran Elisama. ");
INSERT INTO qub_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","Sinsuptin paycunaga casha chuscu chunca waranga pichga pachacnin (40,500). ");
INSERT INTO qub_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","Paycunapa ñaupanpana tolduncunata ichichenga Manasés trïbu runacuna. Manasés suldärucunapa mandajnenga Pedasurpa wamran Gamalielmi. ");
INSERT INTO qub_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","Sinsuptin paycunaga casha quimsa chunca ishcay waranga ishcay pachacnin (32,200). ");
INSERT INTO qub_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","Paycunapa ñaupanmanna tolduncunata ichichenga Benjamín trïbu runacuna. Benjamín suldärucunapa mandajninmi Gedeonipa wamran Abidán. ");
INSERT INTO qub_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","Sinsuptin paycunaga casha quimsa chunca pichga waranga chuscu pachacnin (35,400). ");
INSERT INTO qub_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","Chaura Efraín trïbu suldärucunaga caycanga quimsan trïbupita juc röpallaman ruracasha. Llapanga canga pachac pusajnin waranga juc pachacnin (108,100). Israelcuna aywaptin paycuna aywanga ishcay caj röpa suldärucunapa guepanta. ");
INSERT INTO qub_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","«Dan trïbu runacunaga norte caj-lächo röpanpa röpanpa tolduncunata ichichenga. Bandërancunata jawenga. Dan suldärucunapa mandajninmi Amisadaipa wamran Ahiezer. ");
INSERT INTO qub_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","Sinsuptin paycunaga casha sojta chunca ishcay waranga ganchis pachacnin (62,700). ");
INSERT INTO qub_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","Paycunapa ñaupanpana tolduncunata ichichenga Aser trïbu runacuna. Aser suldärucunapa mandajninmi Ocranpa wamran Pagiel. ");
INSERT INTO qub_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","Sinsuptin paycunaga casha chuscu chunca juc waranga pichga pachacnin (41,500). ");
INSERT INTO qub_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","Paycunapa ñaupanpana tolduncunata ichichenga Neftalí trïbu runacuna. Neftalí suldärucunapa mandajnenga Enanpa wamran Ahirami. ");
INSERT INTO qub_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","Sinsuptin paycunaga casha pichga chunca quimsa waranga chuscu pachacnin (53,400). ");
INSERT INTO qub_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","Chaura Dan trïbu suldärucunaga caycanga quimsa trïbupita juc röpallaman ruracasha. Llapanga canga pachac pichga chunca ganchis waranga sojta pachacnin (157,600). Paycunapis bandëranwan-cama guepata aywanga.» ");
INSERT INTO qub_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","Chaynömi Israel runacunata sinsuptin caran sojta pachac quimsan waranga pichga pachac pichga chuncan (603,550) pillyapaj alli cajcunalla. ");
INSERT INTO qub_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","Ichanga Moisesta Tayta Dios nishannömi Leví trïbu runacunataga mana sinsuranchu. ");
INSERT INTO qub_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","Israelcunaga llapantapis ruraran Moisesta Tayta Dios nishannölla. Chaymi tiyarpis tiyaran shuyni-cama bandërancuna cashancho. Aywacushpanga aywaj cada famillya, cada trïbu shuyni-cama. ");
INSERT INTO qub_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","Chunyaj Sinaí jircacho Moisesta Tayta Dios parlapashan wichanga Aaronpapis Moisespapis wamrancuna cashanami. ");
INSERT INTO qub_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","Aaronpa wamrancuna caran Nadab, Abiú, Eleazar, Itamar. Nadabga caran guechpa wamranmi. ");
INSERT INTO qub_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","Paycunataga chuscuntami acraran cüracuna cananpaj. ");
INSERT INTO qub_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","Nadabwan Abiüga chunyaj Sinaïllachöna Tayta Diospa ñaupancho wañuran. Tayta Diospa ñaupancho juc-niraj saumachishanpitami wañuran. Paycunaga wamraynajllana wañuran. Chauraga Eleazarwan Itamarllana cüra caran. Paycunata papänin Aarón cuydaran llutanta mana rurananpaj. ");
INSERT INTO qub_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","Moisesta Tayta Dios niran: ");
INSERT INTO qub_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","«Leví trïbu runacunata shuntaycachir Aaronpa maquinman churay. Paycunaga Aarontami yanapanga. ");
INSERT INTO qub_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","Tincuna Tolduchömi aronga. Yanapanga Aaronta, marca-masincunata. ");
INSERT INTO qub_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","Paycuna täpanga Tincuna Tolducho cajtaga llapan cösacunata. Tolducho rispitamashpan Israelcuna rurananpaj cajtapis paycunami ruquin ruranga. ");
INSERT INTO qub_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","Waquin Israelcunapita shuyni raquinqui Leví trïbu runacunataga. Paycunaga Aarón nishantami, Aaronpita mirajcuna nishantami ruranga. ");
INSERT INTO qub_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","Cüra cananpäga churanqui Aaronta, y paypita mirajcunata. Ichanga pipis mana cüra caycar cüra rurananta ruraj cäga wañuchicangami.» ");
INSERT INTO qub_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","Moisesta Tayta Dios niran: ");
INSERT INTO qub_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","«Leví trïbu runacunataga Israelcunapitami acrashcä cada famillyapa guechpa wamranta acracunäpa ruquin. Chaymi Leví trïbu runacunaga nogapana canga. ");
INSERT INTO qub_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","Egipto runacunapa guechpa wamrancunata wañuchishpämi nogapaj acrarä Israelcunapa guechpa caj wamranta. Llapan casta uywacunapa rimir caj wawantapis nogapaj acrarä. Chaymi llapanpapis guechpa caj, rimir caj wawancunaga nogapaj canga. Noga Tayta Diosniquimi chayno në.» ");
INSERT INTO qub_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","Chunyaj Sinaïcho Moisesta Tayta Dios niran: ");
INSERT INTO qub_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","«Leví trïbu runacunata sinsur yupanqui cada castapita, cada famillyapita aycapis cashanta. Paycunata sinsunqui ollgutaga juc quillayojpita janaman.» ");
INSERT INTO qub_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","Chaura Tayta Dios nishannöllami Moisesga sinsuran. ");
INSERT INTO qub_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","Levïpa wamrancunaga caran: Gersón, Coat, Merari. ");
INSERT INTO qub_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","Gersonpa wamrancunami caran Libniwan Simei. Paycunapita mirajcunami caran Libni casta runacuna, Simei casta runacuna. ");
INSERT INTO qub_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","Coatpa wamrancunami caran Amram, Izhar, Hebrón, Uziel. Paycunapita mirajcunami caran Amram, Izhar, Hebrón, Uziel casta runacuna. ");
INSERT INTO qub_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","Meraripa wamrancuna caran Mahliwan Musi. Paycunapita mirajcunami caran Mahli casta runacuna, Musi casta runacuna. Chaynömi Leví trïbu castacuna mayurpita shullcacama caran. ");
INSERT INTO qub_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","Gersonpita mirajcunaga caran Libni casta runacuna, Simei casta runacuna. ");
INSERT INTO qub_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","Chay runacunaga ollgu cajcuna juc quillayojpita janaman caran ganchis waranga pichga pachacnin (7,500) runacuna. ");
INSERT INTO qub_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","Paycuna tolduncunata ichichiran Tincuna Toldupa guepan inti yaganan caj-läman. ");
INSERT INTO qub_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","Mandajninna caran Laelpa wamran Eliasaf. ");
INSERT INTO qub_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","Chay ishcan casta runacunami ricaj Tincuna Tolducho cajtaga. Paycunami ricaj Tincuna Tolduta gatarajta, Tolduman yaycunata chaparajta, ");
INSERT INTO qub_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","sawan pampata, intëru cantun chaparajta, sawan puncu yaycunata chaparajta, wasquïllacunatapis y charichinanpaj cajcunatapis. ");
INSERT INTO qub_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","Coatpita mirajcunana caran: Amram, Izhar, Hebrón, Uziel casta runacunapis. ");
INSERT INTO qub_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","Chay chuscun casta runacunaga quillayojpita janaman ollgulla caran pusaj waranga quimsa pachacnin (8,300). Paycunaga ricaj Tincuna Tolducho cajcunata. ");
INSERT INTO qub_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","Tolduncunatana ichichej Tincuna Tolduta ichichishan sur caj-läninman. ");
INSERT INTO qub_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","Paycunapa mandajnin caran Uzielpa wamran Elizafán. ");
INSERT INTO qub_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","Paycunami ricaj Tayta Dioswan Conträtuta rurashan babulta, mësata, achqui candilëruta, altarcunata, Tincuna Toldu rurincho raquej tëlata, waquin cösacunatapis. ");
INSERT INTO qub_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","Leví trïbu runacunapa mandajnenga caran cüra Aaronpa wamran Eleazarmi. Paymi Tincuna Tolduchöga imata rurananpäpis llapanta ricaj. ");
INSERT INTO qub_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","Meraripita mirajcunami caran Mahli casta, Musi casta runacuna. ");
INSERT INTO qub_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","Chay ishcan casta runacuna caran juc quillayojpita janaman ollgulla sojta waranga ishcay pachacnin (6,200) runacuna. ");
INSERT INTO qub_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","Paycunapa mandajninna caran Abihailpa wamran Zuriel. Chay casta runacunaga tolduncunata ichichej Tincuna Toldupa norte caj-läninman. ");
INSERT INTO qub_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","Chay Merari castacuna ricaj Tincuna Toldupa tablancunata, chacajnincunata, tushancunata, tushapa jamanancunata, waquin cösacunatapis, ");
INSERT INTO qub_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","sawanta ichichinanpaj caj tushancunata, tushapa jamanancunata, tacsha istägancunata, watananpaj wasquïllancunatapis. ");
INSERT INTO qub_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","Tincuna Toldupa puncun caj-läpana tolduncunata ichichej Moisés, Aarón, Aaronpa wamrancunapis. Paycunaga täparcaycaran waquin caj Israelcunapa ruquin. Pipis mana cüra caycar cüra rurananta rurarga wañuchicajmi. ");
INSERT INTO qub_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","Tayta Dios nishannölla Leví trïbu runacunata Aaronwan Moisés sinsuran cada castata shuyni-cama. Llapanta sinsuptin juc quillayojpita janaman ollgulla caran ishcay chunca ishcaynin waranga (22,000). ");
INSERT INTO qub_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","Moisesta Tayta Dios niran: «Llapan Israelcunapa guechpa wamrancunata sinsuy juc quillayojpita-pacha. Jutincunata llapanpata apuntanqui. ");
INSERT INTO qub_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","Nircur Israelcunapa guechpa wamrancunapa ruquin nogapaj raquinqui Leví trïbu runacunata. Israelcunapa uywancunapa rimir caj wawancunapa ruquinpis nogapaj raquinqui Leví trïbupa uywancunapa rimir caj wawancunata. Noga Tayta Diosniquimi chayno në.» ");
INSERT INTO qub_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","Chaura Tayta Dios nishannölla Israelcunapa guechpa wamrancunata Moisés sinsuran. ");
INSERT INTO qub_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","Sinsuptin juc quillayojpita-pacha ollgulla caran ishcay chunca ishcay waranga ishcay pachac ganchis chunca quimsawan (22,273). ");
INSERT INTO qub_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","Chaypitaga Moisesta Tayta Dios niran: ");
INSERT INTO qub_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","«Llapan Israelcunapa guechpa wamrancunapa ruquin Leví trïbu runacunata nogapaj acray. Leví trïbu runacunapa uywancunapa rimir caj wawancunapis canga nogapämi Israelcunapa uywancunapa rimir caj wawancunapa ruquin. Leví trïbu runacunaga llapanpis nogapaj acrashallämi. Nogaga Tayta Diosniquimi cä. ");
INSERT INTO qub_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","Israelcunapa guechpa wamrancunaga mas achcami Leví trïbu runacunapitaga. Ishcay pachac ganchis chunca quimsapa (273) masmi caycan Leví trïbu runacunapitaga. ");
INSERT INTO qub_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","Chaura chay runacunapa ruquenga guellayninpa chasquinqui cada runapita pichga guellayta. Chaytaga pësanqui Tincuna Tolducho caycaj pësawan. Chayga lasan chunca juc grämumi. ");
INSERT INTO qub_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","Chay guechpa wamrancunapa ruquin guellayta chasquircorga Aaronta wamrantinta entreganqui.» ");
INSERT INTO qub_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","Leví trïbu runacunapita mas achca Israelcunapa guechpa wamran captinmi Moisesga puchoj caj guechpacunapita guellayninpana Israelcunapita shuntaran. ");
INSERT INTO qub_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","Chaynöpami waranga quimsa pachac sojta chunca pichgan (1,365) guellayta shuntaran. Chay guellayta pësaran Tincuna Tolducho caj pësawan. ");
INSERT INTO qub_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","Nircur chay guellayta Moisesga Tayta Dios nishannölla Aaronta wamrancunatawan entregaycuran. ");
INSERT INTO qub_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","Aarontawan Moisesta Tayta Dios niran: ");
INSERT INTO qub_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","«Leví trïbu Coatpita mirajcunataga sinsunqui shuyni-cama cada castata cada famillyata. ");
INSERT INTO qub_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","Paycunata apuntanqui quimsa chunca (30) watayojpita pichga chunca (50) watayojcama Tincuna Tolducho imata rurananpäpis alli cajcunallata. ");
INSERT INTO qub_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","«Coatpita mirajcunaga Tolducho mas rispitädu cajcunatami apanga. ");
INSERT INTO qub_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","Israelcuna pachacarashanpita juc-lämanna witicuptenga Aaronmi wamrancunawan Tincuna Tolducho mas rispitädu cajman yaycunata chaparaycaj racta tëlata jorgonga. Nircorga chay tëlawan babulta pitonga. ");
INSERT INTO qub_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","Jananpa chapanga cuyayllapaj garachacunawan. Yapay chapanga juc pïsalla murädu tëlawan. Nircurnami churanga wintunanpaj caj gueruncunata. ");
INSERT INTO qub_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","Chaynölla tanta churacuna mësapita tantata jorgurcur pitonga murädu tëlawan. Chay tëla jananmanmi churanga lätucunata, wishllacunata, bïnuta altarman wiñananpaj caj cöpacunatapis wichicunatapis. Chaynöllami chay jorgushan tantatapis tëla jananman churanga. ");
INSERT INTO qub_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","Llapanta churaycur jananpana pitonga puca tëlawan. Jananpana pitonga cuyayllapaj garacunawan. Nircurnami wintunanpaj caj ishcay guerucunata churanga. ");
INSERT INTO qub_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","Murädu tëlawan pitonga candilëruta, lamparincunata, tinäsuncunata, latillucunata, asëtita wiñacunan bäsucunatapis. ");
INSERT INTO qub_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","Chaycunataga llapanta pitonga cuyayllapaj garacunawan. Nircurna quirma guerucunapa jananman churanga apananpaj. ");
INSERT INTO qub_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","«Insinsu rupachicuna gori altartapis pitonga murädu tëlawan. Jananpana pitonga cuyayllapaj garacunawan. Nircur-raj apananpaj gueruta churanga. ");
INSERT INTO qub_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","Tincuna Tolducho waquin caj cösacunatapis shuntanga. Chaycunata churanga murädu tëlaman. Nircur pitonga cuyayllapaj garacunawan. Chaycunatapis apanga quirma guerucunapa janancho. ");
INSERT INTO qub_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","Rupachicuna altartaga pichanga wiranta, uchpanta. Nircur pitonga cunchuybïnu tëlawan. ");
INSERT INTO qub_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","Tëla jananmanna churanga altarcho üsashan cajcunatapis. Churanga togricunata, rinchicunata, pälancunata, tasuncunata, altarcho cajtaga llapanta. Chaycunata pitonga cuyayllapaj garacunawan. Nircurnaga apananpaj caj guerucunata churanga. ");
INSERT INTO qub_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","Wamrancunawan Aarón llapan rispitädu cösacunata pituyta usharcuptenga Coatpita mirajcuna yayconga chaycunata apananpaj. Chay rispitädu cösacunata paycunaga ama yatayllapis yatangachu. Yatashpanga wañongami. Tincuna Tolducho cajcunataga chaycunatami apanga Coatpita mirajcunaga. ");
INSERT INTO qub_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","«Aaronpa wamran Eleazarna apanga lamparincunapaj asëtita, alli asyaj insinsuta, chaqui micuy ofrendata nogapaj imaypis churanan cajcunata, acrar wiñapäna alli asyaj asëtita. Chaynöpis paymi ricanga Tolduta, chaycho llapan caj cösacunatapis.» ");
INSERT INTO qub_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","Aarontawan Moisesta Tayta Dios niran: ");
INSERT INTO qub_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","«Leví trïbucho Coatpita mirajcunaga cuydä illgargunman. ");
INSERT INTO qub_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","Rispitädu cösacunata yatar mana wañunanpaj Aaronwan wamrancunami cada-ünunta tantiyachenga imata rurananpaj, imata apananpäpis. ");
INSERT INTO qub_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","Chaynöpami paycunaga mana yaycongachu fiyupa rispitädu cajcunata ricaj. Mana ricashpanga manami wañongapischu.» ");
INSERT INTO qub_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","Chaypita yapay Moisesta Tayta Dios niran: ");
INSERT INTO qub_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","«Gersonpita mirajcunatapis sinsunqui cada castata, cada famillyata ");
INSERT INTO qub_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","quimsa chunca (30) watayojpita pichga chunca (50) watayojcama. Paycunataga apuntanqui Tincuna Tolducho arunanpaj alli cajcunallata. ");
INSERT INTO qub_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","«Gersonpita mirajcunaga caycunatami apanga: ");
INSERT INTO qub_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","Tincuna Tolduta chapanan tëlata, Toldu jananta chapananpaj cuyayllapaj garapita rurashancunata, Tolduman yaycunata chaparajta, ");
INSERT INTO qub_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","sawanpa intëru cantun chaparajta, sawan puncu yaycunata chaparajta, wasquïllacunatapis, charichinanpaj cajcunatapis. ");
INSERT INTO qub_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","Gersón casta runacuna imata rurananpaj imata apananpäpis Aaronmi, wamrancunami nenga. ");
INSERT INTO qub_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","Gersón castacunaga Tincuna Tolducho cajta llapantapis ruranga cüra Aaronpa wamran Itamar nishannölla. ");
INSERT INTO qub_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","«Meraripita mirajcunatapis sinsunqui castanpa-cama, famillyanpa-cama. ");
INSERT INTO qub_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","Paycunatapis apuntanqui quimsa chunca (30) watayojpita pichga chunca (50) watayojcama Tincuna Tolducho arunanpaj alli cajcunallata. ");
INSERT INTO qub_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","Paycunami apanga Tincuna Tolducho cajtaga tablancunata, chacajnin larguërucunata, tushancunata, tusha jamanancunata, ");
INSERT INTO qub_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","sawanpaj caj tushancunata, tushapa jamanancunatawan, istägancunata, watananpaj wasquïllancunata, imancunatapis. Gammi ninqui paycuna imata apananpaj cajtapis. ");
INSERT INTO qub_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","Meraripita mirajcunapis Tincuna Tolducho cajta ruranga cüra Aaronpa wamran Itamar nishannöllami.» ");
INSERT INTO qub_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","Tayta Dios chayno niptinmi Moisés, Aarón, Israelcunapa mandajnincuna sinsuran Coatpita mirajcunataga castanpa-cama, famillyanpa-cama. ");
INSERT INTO qub_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","Apuntaran quimsa chunca (30) watayojpita pichga chunca (50) watayojcama Tincuna Tolducho arunanpaj alli cajcunallata. ");
INSERT INTO qub_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","Apuntaptin caran ishcay waranga ganchis pachac pichga chuncan (2,750) runacuna. ");
INSERT INTO qub_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","Paycunami caran Coatpita mirajcuna. Paycunaga caran Tincuna Tolducho arunanpaj alli cajcunalla. Chaynömi Aaronwan Moisesga sinsuran Tayta Dios nishannölla. ");
INSERT INTO qub_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","Gersonpita mirajcunatapis castanpa-cama, famillyanpa-cama sinsuran. ");
INSERT INTO qub_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","Quimsa chunca (30) watayojpita pichga chunca (50) watayojcama apuntaran Tincuna Tolducho arunanpaj alli cajcunallata. ");
INSERT INTO qub_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","Sinsuptin paycunaga caran ishcay waranga sojta pachac quimsa chuncan (2,630). ");
INSERT INTO qub_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","Chaynömi caran Gersonpita mirajcuna Tincuna Tolducho cajta ima-aycantapis apananpaj. Paycunata Aaronwan Moisesga sinsuran Tayta Dios nishannöllami. ");
INSERT INTO qub_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","Meraripita mirajcunatapis castanpa-cama, famillyanpa-cama sinsuran. ");
INSERT INTO qub_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","Paycunatapis quimsa chunca (30) watayojpita pichga chunca (50) watayojcama apuntaran Tincuna Tolducho arunanpaj alli cajcunallata. ");
INSERT INTO qub_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","Sinsuptin paycunaga caran quimsa waranga ishcay pachacnin (3,200). ");
INSERT INTO qub_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","Chaynömi caran Meraripita mirajcunaga Tincuna Tolducho arunanpaj alli cajcunalla. Paycunata Aaronwan Moisesga sinsuran Tayta Dios nishannöllami. ");
INSERT INTO qub_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","Leví trïbu runacunataga castanpa-cama famillyanpa-cama Moisesmi Aaronwan Israelpa mandajnincunawan sinsuran. ");
INSERT INTO qub_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","Quimsa chunca (30) watayojpita pichga chunca (50) watayojcama sinsuran Tincuna Tolducho arunanpaj alli cajcunallata. ");
INSERT INTO qub_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","Apuntaptin paycunaga caran pusaj waranga pichga pachac pusaj chuncan (8,580) runacuna. ");
INSERT INTO qub_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","Moisesta Tayta Dios nishannömi cada-ünun imata apananpaj cashantapis niran. Chaynömi Leví trïbu runacunaga sinsusha caran, Moisesta Tayta Dios nishannölla. ");
INSERT INTO qub_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","Chaypita yapay Moisesta Tayta Dios niran: ");
INSERT INTO qub_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","«Israelcunata willapay. Lepra gueshyawan gueshyaycajta, warmi ollgutapis yuraj yacuwan gueshyaycajcunata, wañushata yatashanpita ganrana ricacojcunata tiyaycashayquicunapita juc-läman jitarinanpaj niy. ");
INSERT INTO qub_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","Tiyaycashayquichömi nogaga tiyaycä. Chaymi ganra cajcunataga juc-läman jitarichun warmita ni ollgutapis. Chauraga manami ganrayächengapächu gamcuna tiyaycashayquita.» ");
INSERT INTO qub_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","Moisesta Tayta Dios nishannöllami llapan Israelcuna wiyacuran. Chaymi tiyaycashanpita juc-läman jorguran ganra caycaj runacunataga. ");
INSERT INTO qub_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","Moisesta Tayta Dios niran: ");
INSERT INTO qub_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","«Israelcunata willapanqui: Warmipis ollgupis mana wiyacamar runa-masinpaj mana allita rurashpanga juchatami ruran. ");
INSERT INTO qub_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","Chay runaga jucha rurashanta reconösir runa-masinpaj imanöpis mana allita rurashanpita päganga. Jananmanpis cada chuncapita ishcay mastaraj päganga. ");
INSERT INTO qub_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","Chay pägata chasquinanpaj caj runa wañushana captin, wañoj runapa mana pï famillyanpis captenga nogapäna canga. Chay pägataga cüracunana quiquinpaj chasquenga. Chaynöllami juchanpita perdunanäpäpis uyshata pishtananpaj apamonga. ");
INSERT INTO qub_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","«Israelcuna garamänanpaj apamushan ofrendacunaga chasquej caj cürapämi canga. ");
INSERT INTO qub_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","Nogapaj imatapis raquishan cajtaga cüraman apanga. Chaycunaga cürapänami canga.» ");
INSERT INTO qub_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","Moisesta Tayta Dios niran: ");
INSERT INTO qub_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","13","«Llapan Israelcunata willapanqui: Capas juc warmi runanta ganrachir juc runawan cacunman. Chayno rurashantaga capas pipis mana mayanchu. Ni runanpis capas mana mayanchu. ");
INSERT INTO qub_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","Ichanga capaschari runan sëlanman warmi imano cashantapis mayapallar. Capas runaga sëlacoj cayllapitapis sëlanman warmin mana jucwan cacuycaptinpis. ");
INSERT INTO qub_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","Chaura runanga warmita cüraman pushanga. Warminta pushar nogapaj apamonga ishcay quïlu sebäda jarinata. Jarinamanga ama wiñangachu insinsuta ni asëtitapis. Chay garamashan ofrendaga canga sëlacushanpitami; juchanta musyananpämi. ");
INSERT INTO qub_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","«Chay warmitana cüra pushamonga ñaupäman. ");
INSERT INTO qub_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","Nircorga rispitädu yacuta wichiwan chagarcur tacuchenga Tincuna Tolducho caycaj ichiclla allpata charircur. ");
INSERT INTO qub_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","Warmitana ñaupäman ichichenga. Ajcha pilltantapis pascachenga. Nircurna maquinman churapanga rasunpa juchan cashan musyacänanpaj nogata garamänanpaj apamushanta. Cüranami chararaycanga juchayoj cajta gueshyachej ashgaj yacuta. ");
INSERT INTO qub_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","Warmita jurachishpan cüra nenga: ‹Runayquita mana engañasha captiquega, jucwan mana cacusha captiquega cay ashgaj yacuta upuptiquipis manami ima castïgupis chayashunquipächu. ");
INSERT INTO qub_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","Runayquita ganrachir jucwan cacusha captiquega ");
INSERT INTO qub_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","Tayta Diosmi castigashunqui llapan ricacunanpaj. Castigashuptiquimi pachayqui jacacurconga. Wawatapis manami tarinquipänachu. ");
INSERT INTO qub_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","Chayno castïguta chasquinquipaj castïguta chayachicoj yacuta upurmi.› Warminami ‹nishayquino cachun› nenga. ");
INSERT INTO qub_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","«Chaura cüraga imano maldisyun päsanantapis isquirbenga. Nircurna ashgaj yacuwan mayllanga. ");
INSERT INTO qub_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","Nircur chay yacutana warmita upuchenga juchayoj captenga chay warmipa pachancho asgayta gallaycunanpaj. ");
INSERT INTO qub_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","Yacuta chasquircurmi runan sëlacur apamushan chaqui micuy ofrendata cürata chay warmi entreganga. Chaypitanami noga Tayta Diospa ñaupächo cuyuchir ricachimashpan cüraga altarman churanga. ");
INSERT INTO qub_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","Chay ofrendapitami cüraga juc aptay chaqui micuyta altarcho rupachenga noga yarpänäpaj. Warmita ashgaj yacuta cüra upuchiptin ");
INSERT INTO qub_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","warmi rasunpa runanta ganrachisha captin gueshyachicoj yacuga pachancho asgayta gallayconga. Chaura pachan jucllami jacacurconga. Mananami wawata tarenganachu. Chayno captin llapan warmicunami ricaconga. ");
INSERT INTO qub_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","Runanta warmi mana ganrachisha captin ichanga mana imanangapischu. Chay warmiga wamratapis tarenga. ");
INSERT INTO qub_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","«Runanta ganrachir juc runawan warmi cacur ganrayaptin, runan mayapar sëlarga chaynömi ruranga. ");
INSERT INTO qub_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","Chaynömi ruranga sëlashpallanpis. Sëlashpan warminta juclla ñaupäman apamonga. Cüranami lay niycashanno ruranga. ");
INSERT INTO qub_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","Chayno rurar runanga manami juchayojchu canga. Warmimi ichanga juchayoj cashpanga castïguwan ñacanga.» ");
INSERT INTO qub_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","Tayta Diosga Moisesta yapay niran: ");
INSERT INTO qub_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","«Israelcunata willapanqui: Nogata sirbimänanpaj Nazareona cayta munajcunaga warmipis ollgupis ");
INSERT INTO qub_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","ama upongachu bïnuta, bïnupita rurashan binagrita ni ima machächicojtapis. Ama micongachu übasta ni päsastapis. ");
INSERT INTO qub_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","Nazareo cananpaj aunimashan manaraj cumlicaptenga ama micongachu ni imatapis übaspita rurashataga. ");
INSERT INTO qub_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","Ajchantapis ama rutucongachu. Chayno canga nogata sirbimänanpaj aunishan cumlinancama. Chaynöpami musyacanga nogallata sirbimar cawaycashan. ");
INSERT INTO qub_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","Nazareo cashan wichanga wañushacunata ricajpis ama aywangachu ");
INSERT INTO qub_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","papänin, u maman, wauguin, u pañin wañusha captinpis. Wañushacunata yatarga ganrayanmannami. Chay wichanga caycanga limyu nogapaj acrashami. ");
INSERT INTO qub_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","Imaycamapis nogata sirbimänanpaj aunishan cumlinancamami acracushä canga. ");
INSERT INTO qub_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","«Sirbimar nazareo cananpaj aunimajpa ñaupancho runa illajpita wañushpan ganrayächiptenga nogata sirbimar ajchanta wiñachicushanpis yanganami canga. Chaymi ganrayashanpita ganchis junajchöga limyuyashan ajchanta rutuconga. ");
INSERT INTO qub_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","Warannin pusaj caj junajchöna Tincuna Toldu puncuman apanga ishcay palumata, man'chäga ishcay pushapa wampata. Chaychöna cürata entreganga. ");
INSERT INTO qub_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","Cüranami jucta juchapita sacrifisyupaj pishtanga. Jucajtana rupachina sacrifisyupaj pishtanga. Chaynömi cüraga ruranga wañusha runata yatashanpita Nazareo runapa u Nazareo warmipa juchanta perdunanäpaj. ");
INSERT INTO qub_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","Nazareo caycashancho ganrayaj runaga watayoj cashnitapis apamonga cutichina sacrifisyuta pishtananpaj. Chay örapitaraj yapay gallayconga nogata sirbimar Nazareo cayta. Ñaupa cajcho sirbimar Nazareo cashanga manami bälenganachu ganrayar ajchantapis rutucushanpita. ");
INSERT INTO qub_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","«Sirbimar Nazareo cayta cumlircurnaga shamonga Tincuna Toldu ñaupanman. ");
INSERT INTO qub_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","Chaychöna nogapaj rupachina sacrifisyuta rupachenga sänu juc watayoj cashnita. Juchapita sacrifisyupäpis watayoj sänu china uyshata pishtanga. Alli goyaypita sacrifisyupäna pishtanga juc sänu carnita. ");
INSERT INTO qub_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","Tantatapis mas alli caj jarinapita lebadüraynajllata asëtillawan rurashata, asëtiwan pichusha lebadüraynaj llapsha tantata balay canasta-mallwawan apamonga. Chaytaga chaqui micuy ofrendantawan bïnuntawan nogapaj apamonga. ");
INSERT INTO qub_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","Cüraga juchapita sacrifisyupaj uywata pishtarcur rupachenga. Rupachina sacrifisyupaj sänu cashnitapis rupachenga. ");
INSERT INTO qub_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","Alli goyaypita sacrifisyuta pishtashan uyshata, balay canasta-mallwacho caycaj lebadüraynaj tantatawan garamanga. Chaqui micuy ofrendatapis bïnutapis garamanga. ");
INSERT INTO qub_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","Chay öra nazareo cäga ajchanta rutuconga Tincuna Toldu ñaupancho. Nircur nogata sirbimar wiñachishan ajchantapis rupaycachenga alli goyaypita sacrifisyuta rupaycächishan nina rataycajman. ");
INSERT INTO qub_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","Nazareo runa ajchanta rutucushanpitaraj cüraga uyshapa mururu aychan chayashata, balay canasta-mallwacho lebadüraynaj caycaj juc tantata, lebadüraynaj llapsha tantata, llapanta charircur nazareo runapa maquinman churapanga. ");
INSERT INTO qub_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","Nircur chaycunataga cüra cuyuchir ricachimashpan nogata entregamanga. Chaycunaga llapanpis rispitädumi cürallapämi caycan. Cürallapämi caycan uywapa pëchu aychanta cuyuchir garamashanpis, chancan aychapis. Chaypitaga nazareo cajpis bïnuta upunmannami. ");
INSERT INTO qub_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","«Chaynömi laycuna canga nogata sirbimashpan nazareo cananpaj aunej runacunapäga. Chaynömi ofrendatapis garamanga. Aypäpacorga mastapis garamanmanmi. Nazareo cayman yaycur aunishantaga llapantami cumlenga.» ");
INSERT INTO qub_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","Tayta Diosga Moisesta niran: ");
INSERT INTO qub_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","«Aaronta wamrancunatawan willapanqui. Israelcunata bindisyunta gor cayno nenga: ");
INSERT INTO qub_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","« ‹Tayta Dios bindisyunninta goycushunqui; imapitapis washaycushunqui. ");
INSERT INTO qub_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","Tayta Dios alli ñawinpa ricaycushunqui; cuyapaycushunqui. ");
INSERT INTO qub_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","Tayta Dios imachöpis yanapaycushunqui; jaucalla goyaycachishunqui› nir. ");
INSERT INTO qub_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","«Chaynömi cüracunaga nogapa jutëcho Israelcunata nenga. Chaura nogapis bindisyunnëta goshaj.» ");
INSERT INTO qub_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","Tincuna Tolduta rurayta ushaycuptin Moisesga alli asyaj asëtita jichaparan Tayta Diospana cananpaj. Toldu ruricho cajcunatapis, altarcho cajtapis alli asyaj asëtita jichaparan Tayta Diospana cananpaj. ");
INSERT INTO qub_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","Chaypitaga cada trïbupa mandajnin sinsöshejcuna Tayta Diospaj ofrendancunata aparan. ");
INSERT INTO qub_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","Tayta Diospaj aparan sojta carrëtawan chapashata. Ishcay mandaj-cama juc carrëtawan ofrendata apachiran. Chunca ishcay törucunatapis aparan. Törutaga cada mandaj juc-cama aparan. Llapanta Tayta Diospaj churaran Tincuna Tolduman. ");
INSERT INTO qub_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","Chaura Tayta Diosga Moisesta niran: ");
INSERT INTO qub_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","«Carrëtacunatawan törucunata apamushan ofrendata chasquiy. Nircur Leví trïbu runacunata entregay arushancho nistashan-tupu üsananpaj.» ");
INSERT INTO qub_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","Chaura Moisesga carrëtacunatawan törucunata chasquircur Leví trïbu runacunata raquiparan. ");
INSERT INTO qub_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","Gersonpita miraj runacunataga goran ishcay carrëtatawan chuscu töruta. Chaytami paycunaga nistaran arushancho üsananpaj. ");
INSERT INTO qub_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","Meraripita mirajcunatana goran chuscu carrëtatawan pusaj törucunata. Chaytami paycunaga nistaran arushancho üsananpaj. Paycunapa mandajnenga caran cüra Aaronpa wamran Itamarmi. ");
INSERT INTO qub_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","Coatpita mirajcunatami ichanga carrëtacunata ni törucunatapis mana goranchu. Paycunaga rispitädu caj cösacunatami matancayllapa apanan caran. ");
INSERT INTO qub_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","Altarman asëtita jichapaycuptinnaga Israel mandajcunapis ofrendancunata aparan. Altarpa ñaupanman churaran. ");
INSERT INTO qub_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","Chaypitana Tayta Diosga Moisesta niran: «Altar nogapana cananpaj inauraptenga cada junaj juc trïbupa mandajninmi ofrendancunata apamonga.» ");
INSERT INTO qub_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","Rimir junajcho ofrendanta aparan Judá trïbu runa Aminadabpa wamran Naasón. ");
INSERT INTO qub_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","Naasón aparan juc quïlu medyan lasaj guellay lätuta, pusaj pachac (800) grämun lasaj guellay tasuntapis. Chaycunataga pësaran Tincuna Tolducho caj pësacunawan. Lätuchöpis tasunchöpis juntata aparan mas alli caj jarina asëtillawan chapushata. Chaycunaga caran chaqui micuy ofrendami. ");
INSERT INTO qub_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","Pachac chuncan (110) grämu lasaj gori cucharuntapis aparan junta insinsuyojta. ");
INSERT INTO qub_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","Rupachina sacrifisyupäpis aparan juc besërata, juc carnita, juc watayoj cashnita. ");
INSERT INTO qub_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","Juchapita sacrifisyuta pishtananpäna aparan juc chïbuta. ");
INSERT INTO qub_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","Alli goyaypita sacrifisyuta pishtananpaj aparan ishcay töruta, pichga carnita, pichga chïbuta, pichga cashnitapis watayojta-cama. Chay ofrendacunatami aparan Aminadabpa wamran Naasonga. ");
INSERT INTO qub_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","Ishcay junaj cajcho ofrendanta aparan Isacar trïbu runa Zuarpa wamran Natanael. ");
INSERT INTO qub_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","Natanael aparan juc quïlu medyan lasaj guellay lätuta, pusaj pachac (800) grämu lasaj guellay tasuntapis. Chaycunataga pësaran Tincuna Tolducho caj pësacunawan. Lätuchöpis tasunchöpis juntata aparan mas alli caj jarina asëtillawan chapushata. Chaycunaga caran chaqui micuy ofrendami. ");
INSERT INTO qub_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","Pachac chuncan (110) grämu lasaj gori cucharuntapis aparan junta insinsuyojta. ");
INSERT INTO qub_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","Rupachina sacrifisyupäpis aparan juc besërata, juc carnita, juc watayoj cashnita. ");
INSERT INTO qub_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","Juchapita sacrifisyuta pishtananpäna juc chïbuta aparan. ");
INSERT INTO qub_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","Alli goyaypita sacrifisyuta pishtananpaj aparan ishcay töruta, pichga carnita, pichga chïbuta, pichga cashnitapis watayojta-cama. Chaycuna caran Zuarpa wamran Natanaelpa ofrendancunami. ");
INSERT INTO qub_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","Quimsa junaj cajcho ofrendanta aparan Zabulón trïbu runa Helonpa wamran Eliab. ");
INSERT INTO qub_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","Eliab aparan juc quïlu medyan lasaj guellay lätuta, pusaj pachac (800) grämu lasaj guellay tasuntapis. Chaycunataga pësaran Tincuna Tolducho caj pësacunawan. Lätuchöpis tasunchöpis juntata aparan mas alli caj jarina asëtillawan chapushata. Chaycunaga caran chaqui micuy ofrendami. ");
INSERT INTO qub_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","Pachac chuncan (110) grämu lasaj gori cucharuntapis aparan junta insinsuyojta. ");
INSERT INTO qub_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","Rupachina sacrifisyupäpis aparan juc besërata, juc carnita, juc watayoj cashnita. ");
INSERT INTO qub_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","Juchapita sacrifisyuta pishtananpäna juc chïbuta aparan. ");
INSERT INTO qub_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","Alli goyaypita sacrifisyuta pishtananpaj aparan ishcay töruta, pichga carnita, pichga chïbuta, pichga cashnitapis watayojta-cama. Chaycuna caran Helonpa wamran Eliab apashan ofrendacunami. ");
INSERT INTO qub_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","Chuscu junaj cajcho ofrendanta aparan Rubén trïbu runa Sedeurpa wamran Elisur. ");
INSERT INTO qub_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","Elisur aparan juc quïlu medyan lasaj guellay lätuta, pusaj pachac (800) grämun lasaj guellay tasuntapis. Chaycunataga pësaran Tincuna Tolducho caj pësacunawan. Lätuchöpis tasunchöpis juntata aparan mas alli caj jarina asëtillawan chapushata. Chaycunaga caran chaqui micuy ofrendami. ");
INSERT INTO qub_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","Pachac chuncan (110) grämu lasaj gori cucharuntapis aparan junta insinsuyojta. ");
INSERT INTO qub_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","Rupachina sacrifisyupäpis aparan juc besërata, juc carnita, juc watayoj cashnita. ");
INSERT INTO qub_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","Juchapita sacrifisyuta pishtananpäna juc chïbuta aparan. ");
INSERT INTO qub_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","Alli goyaypita sacrifisyuta pishtananpaj aparan ishcay töruta, pichga carnita, pichga chïbuta, pichga cashnitapis watayojta-cama. Chaycuna caran Sedeurpa wamran Elisur apashan ofrendacunami. ");
INSERT INTO qub_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","Pichga junaj cajcho ofrendanta aparan Simeón trïbu runa Surisadaipa wamran Selumiel. ");
INSERT INTO qub_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","Selumiel aparan juc quïlu medyan lasaj guellay lätuta, pusaj pachac (800) grämun lasaj guellay tasuntapis. Chaycunataga pësaran Tincuna Tolducho caj pësacunawan. Lätuchöpis tasunchöpis juntata aparan mas alli caj jarina asëtillawan chapushata. Chaycunaga caran chaqui micuy ofrendami. ");
INSERT INTO qub_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","Pachac chuncan (110) grämu lasaj gori cucharuntapis aparan junta insinsuyojta. ");
INSERT INTO qub_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","Rupachina sacrifisyupäpis aparan juc besërata, juc carnita, juc watayoj cashnita. ");
INSERT INTO qub_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","Juchapita sacrifisyuta pishtananpäna juc chïbuta aparan. ");
INSERT INTO qub_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","Alli goyaypita sacrifisyuta pishtananpaj aparan ishcay töruta, pichga carnita, pichga chïbuta, pichga cashnitapis watayojta-cama. Chaycuna caran Surisadaipa wamran Selumiel apashan ofrendacunami. ");
INSERT INTO qub_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","Sojta junaj cajcho ofrendanta aparan Gad trïbu runa Deuelpa wamran Eliasaf. ");
INSERT INTO qub_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","Eliasaf aparan juc quïlu medyan lasaj guellay lätuta, pusaj pachac (800) grämun lasaj guellay tasuntapis. Chaycunataga pësaran Tincuna Tolducho caj pësacunawan. Lätuchöpis tasunchöpis juntata aparan mas alli caj jarina asëtillawan chapushata. Chaycunaga caran chaqui micuy ofrendami. ");
INSERT INTO qub_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","Pachac chuncan (110) grämu lasaj gori cucharuntapis aparan junta insinsuyojta. ");
INSERT INTO qub_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","Rupachina sacrifisyupäpis aparan juc besërata, juc carnita, juc watayoj cashnita. ");
INSERT INTO qub_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","Juchapita sacrifisyuta pishtananpäna juc chïbuta aparan. ");
INSERT INTO qub_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","Alli goyaypita sacrifisyuta pishtananpaj aparan ishcay töruta, pichga carnita, pichga chïbuta, pichga cashnitapis watayojta-cama. Chaycuna caran Deuelpa wamran Eliasaf apashan ofrendacunami. ");
INSERT INTO qub_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","Ganchis junaj cajcho ofrendanta aparan Efraín trïbu runa Amihudpa wamran Elisama. ");
INSERT INTO qub_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","Elisama aparan juc quïlu medyan lasaj guellay lätuta, pusaj pachac (800) grämun lasaj guellay tasuntapis. Chaycunataga pësaran Tincuna Tolducho caj pësacunawan. Lätuchöpis tasunchöpis juntata aparan mas alli caj jarina asëtillawan chapushata. Chaycunaga caran chaqui micuy ofrendami. ");
INSERT INTO qub_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","Pachac chuncan (110) grämu lasaj gori cucharuntapis aparan junta insinsuyojta. ");
INSERT INTO qub_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","Rupachina sacrifisyupäpis aparan juc besërata, juc carnita, juc watayoj cashnita. ");
INSERT INTO qub_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","Juchapita sacrifisyuta pishtananpäna juc chïbuta aparan. ");
INSERT INTO qub_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","Alli goyaypita sacrifisyuta pishtananpaj aparan ishcay töruta, pichga carnita, pichga chïbuta, pichga cashnitapis watayojta-cama. Chaycuna caran Amihudpa wamran Elisama apashan ofrendacunami. ");
INSERT INTO qub_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","Pusaj junaj cajcho ofrendanta aparan Manasés trïbu runa Pedasurpa wamran Gamaliel. ");
INSERT INTO qub_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","Gamaliel aparan juc quïlu medyan lasaj guellay lätuta, pusaj pachac (800) grämun lasaj guellay tasuntapis. Chaycunataga pësaran Tincuna Tolducho caj pësacunawan. Lätuchöpis tasunchöpis juntata aparan mas alli caj jarina asëtillawan chapushata. Chaycunaga caran chaqui micuy ofrendami. ");
INSERT INTO qub_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","Pachac chuncan (110) grämu lasaj gori cucharuntapis aparan junta insinsuyojta. ");
INSERT INTO qub_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","Rupachina sacrifisyupäpis aparan juc besërata, juc carnita, juc watayoj cashnita. ");
INSERT INTO qub_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","Juchapita sacrifisyuta pishtananpäna juc chïbuta aparan. ");
INSERT INTO qub_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","Alli goyaypita sacrifisyuta pishtananpaj aparan ishcay töruta, pichga carnita, pichga chïbuta, pichga cashnitapis watayojta-cama. Chaycuna caran Pedasurpa wamran Gamaliel apashan ofrendacunami. ");
INSERT INTO qub_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","Isgun junaj cajcho ofrendanta aparan Benjamín trïbu runa Gedeonipa wamran Abidán. ");
INSERT INTO qub_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","Abidán aparan juc quïlu medyan lasaj guellay lätuta, pusaj pachac (800) grämun lasaj guellay tasuntapis. Chaycunataga pësaran Tincuna Tolducho caj pësacunawan. Lätuchöpis tasunchöpis juntata aparan mas alli caj jarina asëtillawan chapushata. Chaycunaga caran chaqui micuy ofrendami. ");
INSERT INTO qub_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","Pachac chuncan (110) grämu lasaj gori cucharuntapis aparan junta insinsuyojta. ");
INSERT INTO qub_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","Rupachina sacrifisyupäpis aparan juc besërata, juc carnita, juc watayoj cashnita. ");
INSERT INTO qub_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","Juchapita sacrifisyuta pishtananpäna juc chïbuta aparan. ");
INSERT INTO qub_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","Alli goyaypita sacrifisyuta pishtananpaj aparan ishcay töruta, pichga carnita, pichga chïbuta, pichgata cashnitapis juc watayojta-cama. Chaycuna caran Gedeonipa wamran Abidán apashan ofrendacunami. ");
INSERT INTO qub_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","Chunca junaj cajcho ofrendanta aparan Dan trïbu runa Amisadaipa wamran Ahiezer. ");
INSERT INTO qub_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","Ahiezer aparan juc quïlu medyan lasaj guellay lätuta, pusaj pachac (800) grämun lasaj guellay tasuntapis. Chaycunataga pësaran Tincuna Tolducho caj pësacunawan. Lätuchöpis tasunchöpis juntata aparan mas alli caj jarina asëtillawan chapushata. Chaycunaga caran chaqui micuy ofrendami. ");
INSERT INTO qub_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","Pachac chuncan (110) grämu lasaj gori cucharuntapis aparan junta insinsuyojta. ");
INSERT INTO qub_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","Rupachina sacrifisyupaj aparan juc besërata, juc carnita, juc watayoj cashnita. ");
INSERT INTO qub_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","Juchapita sacrifisyuta pishtananpäna juc chïbuta aparan. ");
INSERT INTO qub_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","Alli goyaypita sacrifisyuta pishtananpaj aparan ishcay töruta, pichga carnita, pichga chïbuta, pichga cashnitapis watayojta-cama. Chaycuna caran Amisadaipa wamran Ahiezer apashan ofrendacunami. ");
INSERT INTO qub_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","Chunca juc junaj cajcho ofrendanta aparan Aser trïbu runa Ocranpa wamran Pagiel. ");
INSERT INTO qub_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","Pagiel aparan juc quïlu medyan lasaj guellay lätuta, pusaj pachac (800) grämun lasaj guellay tasuntapis. Chaycunataga pësaran Tincuna Tolducho caj pësacunawan. Lätuchöpis tasunchöpis juntata aparan mas alli caj jarina asëtillawan chapushata. Chaycunaga caran chaqui micuy ofrendami. ");
INSERT INTO qub_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","Pachac chuncan (110) grämu lasaj gori cucharuntapis aparan junta insinsuyojta. ");
INSERT INTO qub_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","Rupachina sacrifisyupäpis aparan juc besërata, juc carnita, juc watayoj cashnita. ");
INSERT INTO qub_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","Juchapita sacrifisyuta pishtananpäna juc chïbuta aparan. ");
INSERT INTO qub_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","Alli goyaypita sacrifisyuta pishtananpaj aparan ishcay töruta, pichga carnita, pichga chïbuta, pichga cashnitapis watayojta-cama. Chaycuna caran Ocranpa wamran Pagiel apashan ofrendacunami. ");
INSERT INTO qub_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","Chunca ishcay junaj cajchöna ofrendanta aparan Neftalí trïbu runa Enanpa wamran Ahira. ");
INSERT INTO qub_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","Ahira aparan juc quïlu medyan lasaj guellay lätuta, pusaj pachac (800) grämun lasaj guellay tasuntapis. Chaycunataga pësaran Tincuna Tolducho caj pësacunawan. Lätuchöpis tasunchöpis juntata aparan mas alli caj jarina asëtillawan chapushata. Chaycunaga caran chaqui micuy ofrendami. ");
INSERT INTO qub_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","Pachac chuncan (110) grämu lasaj gori cucharuntapis aparan junta insinsuyojta. ");
INSERT INTO qub_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","Rupachina sacrifisyupäpis aparan juc besërata, juc carnita, juc watayoj cashnita. ");
INSERT INTO qub_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","Juchapita sacrifisyuta pishtananpäna juc chïbuta aparan. ");
INSERT INTO qub_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","Alli goyaypita sacrifisyuta pishtananpaj aparan ishcay töruta, pichga carnita, pichga chïbuta, pichga cashnitapis watayojta-cama. Chaycuna caran Enanpa wamran Ahira apashan ofrendacunami. ");
INSERT INTO qub_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","Chaynömi Israelcunapa mandajnincuna ofrendanta aparan altarta inauraptin. Aparan chunca ishcay guellay lätucunata, chunca ishcay guellay tasuncunata, chunca ishcay gori cucharuncunata. ");
INSERT INTO qub_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","Guellay lätucuna cada-ünun lasaran juc quïlu medyan; tasuncunana cada-ünun pusaj pachac (800) grämun. Lätucunawan tasuncuna llapanga lasaran ishcay chunca ganchis (27) quïlu. Chaycunata pësaran Tincuna Tolducho caj pësacunawan. ");
INSERT INTO qub_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","Chunca ishcay (12) gori cucharuncunapis caran junta insinsunwan-cama. Cucharuncunaga cada ünun lasaran pachac chunca (110) grämun. Chaycunataga pësaran Tincuna Tolducho caj pësacunawan. Gori cucharuncuna llapanga lasaran juc quïlu chuscu pachacnin (400) grämun. ");
INSERT INTO qub_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","Rupachina sacrifisyupäpis caran chunca ishcay (12) besëracuna, chunca ishcay (12) carnicuna, watayoj cashnicunapis chunca ishcay (12). Chaycunaga cada ünun caycaran chaqui micuy ofrendanwan-cama. Chunca ishcay (12) chïbucunapis caycaran juchapita sacrifisyupaj. ");
INSERT INTO qub_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","Alli goyaypita sacrifisyuta pishtananpaj apashan ofrenda caycaran ishcay chunca chuscun (24) besëracuna, sojta chunca (60) carni, sojta chunca (60) chïbu, watayoj cashnicunapis sojta chunca (60). Chay ofrendacunataga aparan altarta inaurashpanmi. Asëtita wiñapashpanmi altarta inauraran. ");
INSERT INTO qub_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","Tincuna Tolducho Tayta Dioswan parlananpaj Moisés yaycurir wiyaran Tayta Dios rimamushanta. Rimamuran babulpa chapanancho querubín anjilcuna caycashanpita. Chaynömi Tayta Diosga Moiseswan parlaj. ");
INSERT INTO qub_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","Moisesta Tayta Dios niran: ");
INSERT INTO qub_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","«Aaronta willapay. Ganchis lamparincunata candilëruman churarcur sindiptin ñaupallaman achicyaranga.» ");
INSERT INTO qub_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","Chaura Aaronga ruraran Tayta Dios Moisesta nishannölla. Chaymi lamparincunata churaran ñaupallaman achicyaränanpaj. ");
INSERT INTO qub_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","Chay candilërutaga goripita tacayllapa ruraran. Jamananpita puntancho wayta-nirajnincama juc pïsallata ruraran. Chay candilërutaga Tayta Dios ricachishantanömi Moisés rurachiran. ");
INSERT INTO qub_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","Moisesta Tayta Dios niran: ");
INSERT INTO qub_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","«Israelcunapitaga Leví trïbu runacunata raquinqui. Nircur paycunata limyuyächinqui. ");
INSERT INTO qub_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","Limyuyächerga limyuyächina yacuwan chajchupanqui. Intëru cuerpunpita shapranta galaypa afitacuchun. Röpancunatapis tagshacuchun. Chayrämi limyu canga. ");
INSERT INTO qub_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","Nircur apamonga juc besërata, asëtillawan chapusha mas alli caj jarinanta ofrendapaj. Chaynölla gampis juchapita sacrifisyuta pishtanayquipaj juc besërata apamunqui. ");
INSERT INTO qub_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","Leví trïbu runacunata gayanqui Tincuna Toldu ñaupanman. Llapan Israelcunatapis shuntanqui. ");
INSERT INTO qub_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","Leví runacuna ñaupäman shamuptenga Israelcunapa mandajnincuna maquinta churanga paycunapa uman jananman. ");
INSERT INTO qub_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","Chaypitami Aaronga maquinta jogarishpan paycunata raquenga nogata sirbimänanpaj. Chaynöpami Leví runacunaga canga Israelcuna cuyuchir ricachimashan ofrendano. ");
INSERT INTO qub_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","«Chaypitaga Leví runacunana töru-mallwacunapa umanman maquincunata churanga. Jucaj töru-mallwaga pishtacanga juchapita sacrifisyupaj. Jucaj töru-mallwatana pishtanga rupachina sacrifisyupaj. Chaynöpami Leví runacuna limyuna canga. ");
INSERT INTO qub_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","Nircorga gammi Aaronpa wamrancunapa ñaupanman ichichinqui llapan Leví runacunataga. Nircur cuyuchir ricachiypa garamashayqui ofrendatano nogatana sirbimänanpaj ricachimanqui. ");
INSERT INTO qub_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","Chaynöpami Leví trïbu runacunataga Israelcunapita raquinqui shuynina cananpaj. ");
INSERT INTO qub_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","Chayno shuynina cananpaj raquircuptiquiraj, limyuyarcachiptiquiraj aywanga Tincuna Tolducho ima ruraytapis arunanpaj. ");
INSERT INTO qub_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","Llapan Israelcunapita paycunaga acrasha caycan nogata sirbimänallanpämi. Israelcunapa guechpa wamrancunapa ruquinmi Leví trïbu runacunataga chasquishcä. ");
INSERT INTO qub_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","Israelcunapa guechpa wamrancunapis, uywancunapa rimir caj wawancunapis nogapami. Egipto runacunapa guechpa wamrancunata wañuchishpämi Israelcunapa guechpa wamrancunataga nogapaj acracurä. ");
INSERT INTO qub_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","Chay guechpa wamrancunapa ruquinnami Leví trïbu runacunata chasquishcä. ");
INSERT INTO qub_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","Nircur Aaronpawan wamrancunapa munayninchöna cananpämi goycushcä. Paycunanami Tincuna Tolducho ima ruraycuna captinpis Israelcunapa ruquin ruranga. Israelcuna juchanpita perdunasha cananpaj apamushan ofrendancunatapis paycunanami churanga. Chaynöpami Israelcunaga Tincuna Tolduman mana yayconganachu. Chaura paycunataga ima mana allipis mana chayanganachu.» ");
INSERT INTO qub_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","Moisespis Aaronpis llapan Israelcunapis ruraran Leví trïbu runacunapaj Tayta Dios nishannömi. ");
INSERT INTO qub_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","Leví trïbu runacunapis bäñacurir röpancunatapis tagshacuran. Aaronna paycunataga Tayta Diosta ricachiran sirbinanpaj. Nircur paycuna limyuna cananpäpis uywata pishtaran. ");
INSERT INTO qub_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","Chaypita Leví trïbu runacunaga Tincuna Tolducho imapis rurananpaj cajcunatana ruraran. Chaychöga Aaronwan wamrancunami mandaran imata rurananpäpis. Tayta Dios nishannöllami Leví trïbu runacunataga arunanpaj churaran. ");
INSERT INTO qub_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","Chaypitana Tayta Diosga Moisesta niran: ");
INSERT INTO qub_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","«Leví runacunaga ishcay chunca pichga (25) watayoj cashanpita-pachami Tincuna Tolducho aronga. ");
INSERT INTO qub_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","Ichanga pichga chunca (50) watayojman chayar jamacongana. ");
INSERT INTO qub_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","Chaypitaga waquin famillyancunata yanapayllana yanapanga Tincuna Tolducho imapis ruraycunata. Ichanga waran-waran manami aronganachu. Chaynömi camacächinqui Leví trïbu runacuna arunanpäga.» ");
INSERT INTO qub_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","Egiptupita Israelcuna llojshicamushan ishcay wataman gallaycoj quillacho chunyaj Sinaí jircacho Moisesta Tayta Dios niran: ");
INSERT INTO qub_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","«Israelcuna Pascua fistata ruranga imaypis rurananpaj nishä junajcho. ");
INSERT INTO qub_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","Fista gallayconga cay quilla chunca chuscu junaj tardi. Fistata ruranquicuna imanöpis isquirbiraycashanno.» ");
INSERT INTO qub_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","Chaura Moisesga Israelcunata willaparan Pascua fistata rurananpaj. ");
INSERT INTO qub_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","Paycunaga fistata ruraran chay quillacho chunca chuscu junaj tardi chunyaj Sinaí jircacho. Moisesta Tayta Dios nishanno ruraran. ");
INSERT INTO qub_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","Ichanga chay öra waquin runacuna ganra caycaran ayata yatashanpita. Chaynöpa paycunaga chay junaj Pascua fistaman mana yaycuranchu. Chaymi Moisesman, Aaronman aywaran. ");
INSERT INTO qub_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","Moisesta niran: «Ayata yataynëpami nogacunaga ganra caycä. ¿Imanirtaj waquin Israel famillyäcunawan iwalga garaynëta Tayta Diospaj mana goycärïmanchu?» ");
INSERT INTO qub_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","Moisesna niran: «Gamcunaga shuyaycäriyraj. Mä imatashi Tayta Diosninchi nimanga.» ");
INSERT INTO qub_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","Tayta Diosna Moisesta niran: «Israelcunata sumaj willapay: ");
INSERT INTO qub_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","Gamcunaga llapayqui, wamrayquicunapis, nogata aduramar Pascua fistata ruranqui. Ayata yatashanpita ganra caycajpis, caminanticunapis ");
INSERT INTO qub_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","ishcay quilla cajcho chunca chuscu junajnin tardi fistata ruranga. Miconga cashnipa aychan cancashata, ashgaj jachallanpawan lebadüraynaj tantallanpawan. ");
INSERT INTO qub_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","Pishtashayqui cashnipataga ima tulluntapis ama paquinquichu. Chay junajlla ushajpaj micunqui. Waranninpäga imatapis ama puchöchinquichu. Pascuataga ruranqui willapashänölla. ");
INSERT INTO qub_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","Pipis limyu caycar, jinancho tiyaycar Pascua fistata mana ruraj cäga marcayquipita gargushami canga. Imaypis fista cashan junaj nogapaj garaynincunata mana apamushanpita castigasha canga. ");
INSERT INTO qub_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","«Gamcunacho juc-lä nasyun runacuna tiyaycajpis Pascua fistataga willapashäno ruranga. Imanöpis ruranayquicunapaj willapashäta gamcunapis juc-lä runacunapis cumlenga.» ");
INSERT INTO qub_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","Tincuna Tolduta ichichiyta ushashan junäga pucutay chapacurcuran. Pacha chacarcuptenga Toldu janancho yuricurcoj nina rataycarna. Chaynölla caj pacha waränancama. ");
INSERT INTO qub_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","Chaynöllami waran-waran rataran. Junajpaga pucutay chaparaj; chacaypana nina rataj. ");
INSERT INTO qub_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","Tincuna Toldu jananpita pucutay jogaricaptin Israelcunaga aywacärejna. Maychöpis pucutay ichicuycuptenga chayllachöna wasincunata ichichej. ");
INSERT INTO qub_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","Israelcunaga Tayta Dios mandaptinraj aywajpis, tiyananpaj wasincunatapis ichichej. Toldu janancho pucutay cacuptenga jinallancho tiyacoj. ");
INSERT INTO qub_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","Toldu janancho unaycamana pucutay cacuptenga mana aywajnachu. Jinancho Tayta Diosta sirbiytana gallaycoj. ");
INSERT INTO qub_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","Wallca junajlla Toldu janancho pucutay captenga Tayta Dios nishan öra maychöpis wasincunata ichichej. Tayta Dios nishan örami aywaytapis gallaycärej. ");
INSERT INTO qub_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","Öraga chacayllapa Toldu janancho pucutay ichiraj. Pacha wararcuptinna jogaricaptenga Israelcuna aywacojna. Pucutay jogaricaptenga junajpapis chacaypapis aywacoj. ");
INSERT INTO qub_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","Toldu janancho pucutay ishcay junaj, o juc quilla, man'chäga juc wata puñuräcuptenga Israelcuna jinallancho tiyaj. Pucutay jogaricaptenga jinan öra aywacoj. ");
INSERT INTO qub_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","Imaypis Tayta Dios nishan öra wasincunata ichichej, pay nishan öra aywacojpis. Manaraj imatapis niptenga Tayta Dios Moisesta nishanno sirbir goyaj. ");
INSERT INTO qub_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","Moisesta Tayta Dios niran: ");
INSERT INTO qub_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","«Guellaypita ishcay trompëtacunata ruray martilluwan tacayllapa. Chay trompëtacunaga canga runacunata shuntanayquipaj u aywayta gallaycärinanpäpis musyachinayquipaj. ");
INSERT INTO qub_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","Ishcan trompëtacunata tucaptenga llapan runacuna shamonga gam caycashayqui Tincuna Toldu puncuman. ");
INSERT INTO qub_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","Jucaj trompëtallata tucaptenga cada trïbupa mandajnincunallami shuntacämonga. ");
INSERT INTO qub_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","Aywacunanpäna trompëtata tonädachiypa tucaptenga inti yagamunan caj-läpa tiyaycajcuna aywayta gallaycärenga. ");
INSERT INTO qub_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","Yapay tonädachiypa trompëtata tucaptenga sur caj-läpa tiyajcunana aywayta gallaycärenga. Trompëtata tonädachiypa tucaptenga simri canga tiyaycashanpita juc-läman aywananpänami. ");
INSERT INTO qub_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","Runacuna shuntacämunallanpäga ishcan trompëtatami tucanga. Runacuna aywacunanpämi ichanga tonädachiypa tucanga. ");
INSERT INTO qub_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","Trompëtata tucajcunaga cangapaj Aaronpita miraj cüracunami. Chay nishäcunaga imaycamapis laymi canga gamcunapaj gamcunapita mirajcunapäpis. ");
INSERT INTO qub_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","«Tiyaycashayqui nasyunniquiman chiquishojcuna wañuchishunayquipaj yaycamuptenga trompëtata tonädachiypa tucanqui pillyaj aywanayquicunapaj. Noga Tayta Diosniquimi yanapäshayqui. Gamcunata salbashayqui chiquishojcunapita. ");
INSERT INTO qub_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","Trompëtacunataga tucanqui cushicuy junajcunacho, llullu quilla fistacunacho, rupachina sacrifisyuta rupachishpayqui, alli goyaypita sacrifisyu uywacunata pishtarpis. Chayno trompëtacuna wagajta wiyashpämi gamcunata yanapäshayquipaj. Nogami cä Tayta Diosniqui.» ");
INSERT INTO qub_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","Wata juc quilla ishcay chunca junajninchömi Conträtu Babul caycashan Rispitädu Toldu jananpita pucutay jogaricaran. ");
INSERT INTO qub_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","Chaura Israelcunaga chunyaj Sinaïcho tiyaycashanpita aywacuran. Chaypita pucutayga päracuycuran Parán jutiyoj chunyajchöna. ");
INSERT INTO qub_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","Tayta Dios Moisesta willapashannöllami Israelcunaga aywaran. ");
INSERT INTO qub_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","Judá trïbu runacuna rimir-puntata bandëranwan aywaran. Chay trïbu runacunata mandaycaran Aminadabpa wamran Naasón. (Paycunawan iwalmi aywaran ishcay trïbu runacunapis). ");
INSERT INTO qub_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","Isacar trïbutaga mandaycaran Zuarpa wamran Natanael. ");
INSERT INTO qub_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","Zabulón trïbutana mandaycaran Helonpa wamran Eliab. ");
INSERT INTO qub_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","Paycunapa guepantana Gersonpita, Meraripita mirajcuna Tincuna Tolduta pascarcur apacarcärir aywacuran. Paycunami chay cösacunata apananpaj caran. ");
INSERT INTO qub_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","Paycunapa guepantana Rubén trïbu runacuna bandëranwan aywaran. Paycunata mandaycaran Sedeurpa wamran Elisur. (Paycunawanmi aywaran Simeón trïbu runacunapis, Gad trïbu runacunapis.) ");
INSERT INTO qub_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","Simeón trïbutana mandaycaran Zurisadaipa wamran Selumiel. ");
INSERT INTO qub_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","Gad trïbutana mandaycaran Deuelpa wamran Eliasaf. ");
INSERT INTO qub_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","Paycunapa guepantana aywaran Coatpita mirajcuna. Paycunaga rispitädu cösacunata apar aywaran. Maymanpis chayashpan paycunaga tarej Tincuna Toldu ichichishatana. ");
INSERT INTO qub_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","Paycunapa guepantana aywaran Efraín trïbu runacuna bandëranwan. Paycunata mandaycaran Amiudpa wamran Elisama. (Paycunawanmi aywaran Manasés trïbu runacunapis, Efraín trïbu runacunapis) ");
INSERT INTO qub_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","Manasés trïbutana mandaycaran Pedasurpa wamran Gamaliel. ");
INSERT INTO qub_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","Benjamín trïbutana mandaycaran Gedeonipa wamran Abidán. ");
INSERT INTO qub_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","Ushanantana aywaran Dan trïbu runacuna bandëranwan. Paycunata mandaycaran Amisadaipa wamran Ahiezer. (Paycunawanmi aywaran Aser trïbu runacunapis, Neftalí trïbu runacunapis) ");
INSERT INTO qub_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","Aser trïbutana mandaycaran Ocranpa wamran Pagiel. ");
INSERT INTO qub_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","Neftalí trïbutana mandaycaran Enanpa wamran Ahira. ");
INSERT INTO qub_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","Chaynömi Israelcunaga röpa-röpa gatinaylla aywaj. ");
INSERT INTO qub_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","Madián runa Reuelpa wamran Hobab caran Moisespa cuñädun. Paytami Moisés niran: «Nogacunaga aywacö Tayta Dios aunimashan partimanmi. Tayta Diosga Israelcunata aunisha cuyar alli ricananpämi. Yan'gaycallämay ari. Yan'gämaptiquega nogacuna allimi ricashayqui.» ");
INSERT INTO qub_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","Hobabna niran: «Manami aywämanchu. Nogaga cuticushaj famillyäcuna tiyaycashan marcämanmi.» ");
INSERT INTO qub_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","Chaypis Moisesga ruwar niran: «Ama cuticuychu ari. Gamga rejsinquimi chunyajcho mayninman pachacuna cashantapis. Chaymi nogacunata pushamashpayqui rejsichimay ari. ");
INSERT INTO qub_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","Nogacunawan aywacuptiquega Tayta Dios tarichimashanchïcunata iwalmi raquipänacushunpis.» ");
INSERT INTO qub_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","Chaynömi Israelcunaga Sinaí jircapita aywacur quimsa junaj aywaran. Chay junajcuna Conträtuta rurashan babultaga Israelcunapa ñaupanta apaycaran maycho jamananpäpis ashishpan. ");
INSERT INTO qub_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","Israelcuna aywacuptenga Tayta Dios yurichishan pucutay aywaj Israelcunapa janallanta. ");
INSERT INTO qub_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","Babulta apananpaj jogarcäriptin Moisés nej: «¡Aywaculläshunna Tayta Dios! ¡Contrayqui cajcunaga machiypa-machir gueshpichun! ¡Chiquishojcunaga ricashushpayqui gueshpir aywacuchun!» ");
INSERT INTO qub_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","Babulta jamaycachiptinna Moisés nej: «¡Cutiycamuyna ari Tayta Dios yupaytapis mana atipaypaj Israel runacunaman!» ");
INSERT INTO qub_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","Chaypitanaga Israelcuna amatar ñacar Tayta Diospa contran rimaran. Rimashanta wiyar Tayta Diospis fiyupa rabyacurcuran. Chaymi Israelcuna tiyaycashan cantunpa ninata ratarachiran. ");
INSERT INTO qub_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","Chaura runacunaga Moisesta ruwar gaparparan. Moisesnami Tayta Diosta mañacuran. Chayrämi ninaga upiran. ");
INSERT INTO qub_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","Israelcunata rupananpaj ninata Tayta Dios ratachishanpitami chay partita jutichaparan «Tabera» nir. ");
INSERT INTO qub_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","Israel runacunaman guellicusha caran jäpa runacunapis. Chay runacunaga pachallanpaj yarpaj. Chaymi Israelcunatapis yarpächiran Egiptucho micushancunata. Chaymi yapay wagar niran: «¡Ojalä aycha canman micunanchïpaj! ");
INSERT INTO qub_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","Egiptuchöga listullatami micoj canchi pescäduta, pipinuta, tumbuta, pörruta, sibuyllata, äjustapis. ");
INSERT INTO qub_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","Cananga yargaypita caycho wañuycanchi. Manällatami micuycanchi.» ");
INSERT INTO qub_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","(Manäga caran culantrupa murunno; culurnenga risïna jachano. ");
INSERT INTO qub_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","9","Manäga chacaypa shullayno shicwamoj. Chaytanami runacuna shuntaj. Nircur agaj. Waquinna tacarcur yanoj. Waquinna tantatano ruraj. Micuptenga mishquej manticallawan rurasha tantano.) ");
INSERT INTO qub_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","Israelcuna toldun puncucunacho wagarcaycajta Moisés wiyaran. Chaura Tayta Dios fiyupa rabyaran. Moisespis llaquicuran. ");
INSERT INTO qub_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","Chaymi Tayta Diosta niran: «Sirbishojniquitaga ¿imanirtaj ñacachimanqui? ¿Imanirtaj aypalla runacunata pushanäpaj churamushcanqui? ");
INSERT INTO qub_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","Nogaga paycunapa maman-taytantächu cä aunishayqui partiman ‹chuchuycaj wamrata margasha apajno apay› nimänayquipäga. ");
INSERT INTO qub_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","Paycunaga wagaparcaycäman ‹Micunäpaj aychata gomay› nirmi. ¿Maypitataj aychata tarishaj chaychica runapäga? ");
INSERT INTO qub_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","Noga japalläga manami camäpacönachu chaychica runacunata pushayta. Paycunata pushanäpäga fiyupa sasami. ");
INSERT INTO qub_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","Chaynölla ñacachimänayqui captenga asta juclla shuntacamay. Chaura manami imachöpis ñacashänachu.» ");
INSERT INTO qub_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","Chaura Tayta Dios niran: «Gam musyanquimi maygan-maygan Israelcunapa mandajnin cashantapis. Chaymi ganchis chunca (70) mandaj auquincunata shuntarcur pushamuy Tincuna Tolduman. Chayllacho llapayqui shuyämanqui. ");
INSERT INTO qub_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","Noga urämushpä chaychömi gamwan parlashun. Nircurmi gamcho caycaj Espirituta paycunaman aypushaj. Chaura paycunanami Israelcunata pushäshishunqui. Manami japallayquinachu pushanquipaj. ");
INSERT INTO qub_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","«Llapan runacunata ninqui warapaj limyuyänanpaj. Warami aychata miconga. Maynami wiyashcä wagashpan ‹¡Ojalä aycha canman micunanchïpaj! ¡Caycho cashanchïpitaga Egiptucho mas allimi caranchi!› nejta. Chaymi cananga micunanpaj aychata goshaj. ");
INSERT INTO qub_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","Aychataga manami juc junajllachu, ni ishcay junajllachu, ni pichga junajllachu, ni chunca junajllachu, ni ishcay chunca (20) junajllapischu miconga. ");
INSERT INTO qub_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","Paycunaga aychata miconga juc quilla intërumi. Pasaypa däñapäcongarämi, melanäcongarämi. Chayno canga paycunawan caycaptë manacajman churamashanpitami, nogapa ñaupächo wagashpan ‹¿Imapäraj Egiptupita llojshimuranchïpis?› nishanpitami.» ");
INSERT INTO qub_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","Chaura Moisés niran: «Nogawan shamoj runacunaga pillyapaj alli cajlla sojta pachac warangami (600,000) caycan. ¿Chayno caycaptinchu ‹juc quillami aychata garashaj› nimanqui? ");
INSERT INTO qub_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","¿Maychötaj caycan chaychica uysha, wäca caychica runa micunanpäga? Lamarpita llapan pescäduta chariycur garashapis manami aypanmanchu.» ");
INSERT INTO qub_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","Chaura Tayta Dios niran: «¿Munayniynaj cashätachu yarpanqui? Cananmi musyanqui rimashä rasunpa cashanta u mana rasunpa cashantapis.» ");
INSERT INTO qub_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","Chaypita aywar Moisesga llapan runacunata willaran Tayta Dios nishanta. Ganchis chunca (70) mandaj Israel auquincunata shuntarcurna Tincuna Toldu intërunpa tumarej ichichiran. ");
INSERT INTO qub_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","Chayno caycaptin Tayta Dios pucutaycho urarcamur Moiseswan parlaran. Nircur Moisescho caycaj Espirituta aypuran ganchis chunca (70) auquincunata. Chaura chay runacunachöpis caycaranna Tayta Diospa Espiritonga. Chaymi Tayta Diospa profëtancunanöna chay öra parlaran. Yapay ichanga manana imaypis chayno parlarannachu. ");
INSERT INTO qub_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","Ganchis chuncata acrasha captinpis Eldadwan Medadga Tincuna Tolduman mana aywaranchu. Paycunaga tolduncunallachömi quëdacuran. Ichanga Tayta Diospa Espiritun paycunamanpis chayaran. Chaura Israelcuna tiyaycashancho profëtacunanöna parlaran. ");
INSERT INTO qub_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","Chaymi juc wamra cörriyllapa aywaran Moisesta willaj: «Eldadwan Medadga profëtacunanömi parlarcaycan tiyaycashäcunacho» nir. ");
INSERT INTO qub_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","Chayno niptinmi Nunpa wamran Josuëga Moisesta niran: «¡Tayta, michay. Ama parlachunchu!» Josuëga wamra cashanpita-pachami Moisespa yanapajnin caran. ");
INSERT INTO qub_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","Moisesna niran: «¿Imanirtaj nogalla profëta canäta munanqui? ¡Ojalä Tayta Diosga llapan runacunaman Espiritunta churanman! ¡Ima alliraj canman llapanpis profëtallana captin!» ");
INSERT INTO qub_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","Chaypitaga Moisespis, auquincunapis tiyaycashan tolduncunaman cuticuran. ");
INSERT INTO qub_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","Nircurna Tayta Diosga lamarpita fiyupa wayrächimuran. Chay wayrami apamuran aypalla codorniz äbita. Chay äbicunaga gotucaran Israelcuna tiyaycashanman y ñaupancunaman. Juc metru altunömi gotucaran. Juc junaj aywaycamapis sïguir caycaranraj. ");
INSERT INTO qub_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","Israelcunaga chay junaj, chay chacay, warannin junajpis mana jamaypa codornizta chariran. Wallcata charejcunapis chunca gotuytami shuntaran. Nircur tiyaycashan ñaupancunacho chaquichiran. ");
INSERT INTO qub_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","Israel runacuna codorniz aychata amurcullaptinnami Tayta Dios fiyupa rabyacurcuran. Chaymi castigar aypalla runacunata wañuchiran. ");
INSERT INTO qub_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","Pachallanpaj yarparajcunata chaycho pampashanpitami chay pachapa jutinta churaparan «Kibrot-hataava» nir. ");
INSERT INTO qub_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","Kibrot-hataava partipita aywacur Israelcunaga chayaran Hazerot partimanna. Chaychöna tolduncunata ichircachir goyaran. ");
INSERT INTO qub_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","Moisés majachacaran etiope warmiwan. Chaymi Aaronwan pañin Mariaga Moisespa washanta rimaran. ");
INSERT INTO qub_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","Mastapis niran: «Tayta Diosga manami Moisesllawanchu parlasha. Noganchïwanpis parlashami» nir. Chayno rimashancunatami Tayta Dios wiyaran. ");
INSERT INTO qub_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","Paycuna chayno parlaptinpis Moisés cay pachacho llapan runapita mas umildi car imatapis mana rimacuranchu. ");
INSERT INTO qub_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","Chaura Moisesta, Aaronta, Mariata Tayta Diosga niran: «Gamcunaga quimsayqui ayway Tincuna Tolduman.» Chayno niptenga Tincuna Tolduman quimsan aywaran. ");
INSERT INTO qub_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","Chaynami Tayta Diosga pucutaycho urämuran Tincuna Toldu puncuman. Chaypita gayaran Aarontawan Mariata. Paycuna ñaupanman aywaptin ");
INSERT INTO qub_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","Tayta Dios niran: «Sumaj wiyamay. Nogaga profëtäwan parlä ricapacushallanchömi, man'chäga suyñuyllanchömi. ");
INSERT INTO qub_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","8","Sirbimajnë Moiseswanmi ichanga defrenti parlä. Sumaj tantiyanacö. Wasëta ricaj-japuy waquin wiyacamajcunawanga manami chayno parlächu. Chayno defrenti paywan parlaycaptëga ¿imanirtaj Moisespa washanta rimarcaycanqui?» ");
INSERT INTO qub_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","Chayno nirir Tayta Diosga fiyupa rabyar aywacuran. ");
INSERT INTO qub_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","Tincuna Toldupita pucutay aywacuptin jinan öra Mariacho lepra yuricurcuran. Cuerpun pasaypa yurajna ricacuran. Aarón ricäriptenga Mariapa cuerpun leprawanna caycaran. ");
INSERT INTO qub_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","Chaymi Aaronga Moisesta ruwacushpan niran: «Ay tayta, ama castigaycäramaychu ari juchä atipasha upanöpis rimaycärishäpitaga. ");
INSERT INTO qub_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","Mariapa cuerponga caycan mamanpa pachallancho wañusha wamra garan juruycajnömi. Tayta Diosta mañacuycuy ari allchacaycachinanpaj.» ");
INSERT INTO qub_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","Chaura Moisesga Tayta Diosta ruwacur mañacuran: «Tayta Dios, Mariata allchacaycachiy ari» nir. ");
INSERT INTO qub_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","Tayta Diosnami niran: «Papänin wamrata gagllancho togapaptenga ¿manachu wamran ganra canman ganchis junajyaj? Chayno ari ganchis junajcama Mariatapis tiyarcaycashayquipita juc-läpa garguriy. Chaypitaraj cutimonga.» ");
INSERT INTO qub_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","Chaymi Mariataga tiyarcaycashanpita juc-läman ganchis junajyaj garguran. Chaycama runacunaga jinallancho goyarcaycaran. ");
INSERT INTO qub_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","María cutiycuptinraj Hazerotpita llapan aywacur chayaran Parán chunyajman. Chaychöna tolduncunata ichircachir goyaran. ");
INSERT INTO qub_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","Moisesta Tayta Dios niran: ");
INSERT INTO qub_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","«Israelcunata goycunäpaj caycaj Canaán partita ricapacamunanpaj runacunata cachay. Cachanqui cada trïbupita juc mandajta.» ");
INSERT INTO qub_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","Chaura Moisesga Tayta Dios nishannömi chunyaj Paranpita cacharan. Ricapacoj aywajcunaga Israelcunacho caran mandajcunallami. ");
INSERT INTO qub_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","Chay aywaj runacuna caran: Rubén trïbupita Zacurpa wamran Samúa, ");
INSERT INTO qub_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","Simeón trïbupita Horïpa wamran Safat, ");
INSERT INTO qub_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","Judá trïbupita Jefonepa wamran Caleb, ");
INSERT INTO qub_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","Isacar trïbupita Josëpa wamran Igal, ");
INSERT INTO qub_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","Efraín trïbupita Nunpa wamran Oseas, ");
INSERT INTO qub_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","Benjamín trïbupita Rafüpa wamran Palti, ");
INSERT INTO qub_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","Zabulón trïbupita Sodipa wamran Gadiel, ");
INSERT INTO qub_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","José trïbupita Susipa wamran Gadi (Payga caran Manasés trïbupita.), ");
INSERT INTO qub_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","Dan trïbupita Gemalipa wamran Amiel, ");
INSERT INTO qub_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","Aser trïbupita Micaelpa wamran Setur, ");
INSERT INTO qub_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","Neftalí trïbupita Vapsipa wamran Nahbi, ");
INSERT INTO qub_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","Gad trïbupita Maquipa wamran Geuel. ");
INSERT INTO qub_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","Paycunatami Moisesga cacharan Canaán partita ricapacoj. (Nunpa wamran Oseaspatana Moisesga jutinta rucachiparan «Josué» nir.) ");
INSERT INTO qub_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","Canaán nasyunta ricapacamunanpaj cachashpan Moisés niran: «Neguevpa aywashpayqui wichanqui punta-punta caycaj jircacunapa. ");
INSERT INTO qub_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","Chay parti imano cashantapis ricapacamunqui. Mayacachanqui chaycho tiyajcuna callpayoj cashanta callpaynaj cashanta, aypalla cashanta, wallcajlla cashantapis. ");
INSERT INTO qub_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","Ricapacamunqui tolducunallacho tiyarcaycashanta u siudänincuna curalasha cashantapis. Ricapacamunqui chacrancuna alli allpa cashanta, mana alli cashanta, ");
INSERT INTO qub_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","jundu allpa cashanta, gachpara cashanta, muntiyoj cashanta, mana cashantapis. Mana manchacuypa yaycunqui. Chay particho wayojtaga imallatapis apamunqui.» Chay ricapacoj aywashan öraga caran ñaupata pogoj übasta pallaycashan wichanmi. ");
INSERT INTO qub_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","Moisés cachashancuna aywar Canaán partitaga intëruta ricapacuran chunyaj Zinpita-pacha Hamatpa ñaupancho caycaj Rehobcama. Rehobga caycan Hamat yaycunachömi. ");
INSERT INTO qub_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","Neguevpa gallaycur chayaran Hebrón marcacama. Chaychömi tiyaycaran Anacpita miraj runacuna: Ahimán, Sesai, Talmai. Hebrón marcataga unaynami ruraran. Chaypita ganchis watatarämi Egiptucho caj Zoán marcatapis ruraran. ");
INSERT INTO qub_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","Ricapacojcuna chayaran yacu aywaycaj Escol ragracama. Chaycho juc rasïmu wayuyniyoj übasta muturan. Chay übastaga gueruman warcurcur ishcaj matancacarcärir aparan. Chaynöpis ricapacoj aywajcunaga pallaran ïgusta granadatapis. ");
INSERT INTO qub_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","Rasïmu übasta pallashanpitami chay partipa yacu aywaj ragrata jutichaparan «Escol ragra» nir. ");
INSERT INTO qub_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","Chuscu chunca junaj ricapacuycorga cutiran ");
INSERT INTO qub_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","Cadescho caycaj chunyaj Paranman. Chaycho goyarcaycaran Moisés, Aarón llapan Israelcunapis. Chayaycur willaparan imata ricapacushanta, imata mayacachashanta. Ricachiran chay partipita apashan frütacunatapis. ");
INSERT INTO qub_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","Nircurnami Moisesta willaran: «Cachamashayqui partiman ricapacoj aywashcäcunami. Chaychöga ima-aycapis aypalla captin lëchipis, mishquipis yacunöraj aypallami caycan. Chaycho wayushan frütacunami cay apamushäcunapis. ");
INSERT INTO qub_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","Ichanga chaycho tiyaj runacuna fiyupa callpayojmi; siudänincunapis jatunmi, sumaj curalashami. Manami chayllapischu. Chaychöga caycanmi Anacpita miraj jatusaj runacunapis. ");
INSERT INTO qub_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","Néguev partichöga tiyarcaycan Amalec runacuna. Punta puntayoj jircacunachöga tiyarcaycan Het runacuna, Jebús runacuna, Amorreo runacuna. Lamar cantun-quinraypana, Jordán mayu lädun-quinraypana tiyarcaycan Cananeo runacuna.» ");
INSERT INTO qub_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","Chaura Israelcunaga Moisespa contran rimayta gallaycäriran. Chaymi runacunata upällaycachir Calebga niran: «¡Aywashun chay chacrata guechunanchïpaj! ¡Noganchëga guechuyta puydinchïmi!» ");
INSERT INTO qub_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","Ichanga Calebwan ricapacoj aywajcuna niran: «¡Chacranta guechoj aywar chay runacunataga manami binsishunpächu! ¡Paycunaga noganchïpita mas munayniyojmi caycan!» ");
INSERT INTO qub_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","Chayno nirmi Israel-masincunata manchachir cayno niran: «Ricapacamushä partiga mana allimi. Wañuyllami tumaycan. Chaycho tiyaj runacunapis jatusajllami. ");
INSERT INTO qub_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","Anacpita miraj jatusaj runacunatapis ricashcämi. Paycunapa ñaupanchöga ticsanöllami cashcä. Paycunapis ticsatanöllami ricamasha.» ");
INSERT INTO qub_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","Chaura Israelcunaga gaparparan. Chay chacayga wagaycar wararan. ");
INSERT INTO qub_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","Moisespawan Aaronpa contran rimar nircaycaran: «¡Egiptullachöna wañucushwan caran! U ¡cay chunyajchöpis mayna wañucushwan caran! ");
INSERT INTO qub_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","Tayta Diosga ¿imapäraj cay partiman pushamashcanchi? ¿Pushamashcanchi guërracho wañunanchïpächu, warminchïcunapis wamranchïcunapis chiquimajninchïcunapa munaynincho prësu cananpächu? ¡Masbin Egiptuman cuticushun!» ");
INSERT INTO qub_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","Chayno parlarmi jucnin-jucnin ninacuran: «Mandajninchi cananpaj juctana churarcur Egiptuman cuticushun.» ");
INSERT INTO qub_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","Chaura Aaronwan Moisesga llapan runacunapa ñaupancho umpuran urcunpis pampaman töpananyaj. ");
INSERT INTO qub_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","Canaán partita ricapacoj aywaj Josuëpis Calebpis fiyupa llaquicushpan jatiraycashan röpanta rachiriran. ");
INSERT INTO qub_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","Nircurna llapan Israelcunata niran: «¡Ricapacur purimushä chacraga fiyupa allimi! ");
INSERT INTO qub_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","Tayta Dios cuyapämashpanchëga yanapämäshunmi chay nasyunman yaycunapaj. Nircur lëchipis mishquipis yacuno achca cashan nasyuntaga noganchïtami goycamäshun. ");
INSERT INTO qub_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","Ichanga Tayta Diospaj ama rabyaychu. Ama manchacuypischu chay nasyuncho tiyaj runacunataga. Chay runacunata noganchëga fäsimi binsirishun. Paycunataga manami pipis yanapanchu. Noganchïwan ichanga Tayta Dios caycan. ¡Chaymi ama manchacuychu-llapa!» ");
INSERT INTO qub_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","Chayno niycaptinpis runacunaga sajmayta munarcaycaran. Chaura Tincuna Toldu janancho Tayta Diospa achicyaynin yurircuran llapan Israelcuna ricaycaptin. ");
INSERT INTO qub_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","Chay örami Moisesta Tayta Dios niran: «Cay runacunaga ¿imaycamaraj chaynölla manacajman churamanga? ¿Imaycamaraj mana riguimangachu paycuna ricaycaptin almiraypajcunata rurasha caycaptëpis? ");
INSERT INTO qub_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","Canan paycunataga gueshyawanmi usharishaj. Mananami aunishä partichöpis tiyanganachu. Gampitami ichanga mirachishaj mas aypallata, mas callpayojta.» ");
INSERT INTO qub_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","Niptinmi Moisesga Tayta Diosta niran: «Gamga fiyupa munayniquiwanmi cay runacunata Egiptupita jorgamurayqui. Israel runacunata wañuchiyta yarpaycashayquita cumliptiquega Egipto runacuna mayaycur ");
INSERT INTO qub_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","willapanga Canaancho tiyajcunatami. Cananeo runacunapis mayashami gam cay runacunacho caycashayquita, paycunawan ricanacuypa parlashayquita, cay runacunapa ñaupanta ichiraycaj pucutaycho junajpa aywashayquita, chacaypana ichiraycaj nina rataycajcho aywashayquita. ");
INSERT INTO qub_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","Cay runacunata ushajpaj wañurachiptiquega gampaj parlajta wiyaj runacuna jamurpäshushpayqui nenga: ");
INSERT INTO qub_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","‹Tayta Diosga aunishan nasyunman chayachiyta mana puydishpanmi Israelcunata chunyajcho wañuycachisha› nir. ");
INSERT INTO qub_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","Chaymi Tayta Dios aunishayquinölla fiyupa munayniyoj cashayquita canan musyachiy. Gam nirayqui: ");
INSERT INTO qub_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","‹Jucllaga manami rabyacöchu. Amatar cuyacojmi cä. Mana allita rurajcunata, mana wiyacojcunata perdunä. Chaypis juchayojcunataga castigä maman-taytanta, wamranta, willcanta mas willcan cajtapis› nir. ");
INSERT INTO qub_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","Tayta Dios, Egiptupita jorgamushayquipita-pachami cay runacunata awantashcanqui. Rasunpa cuyacoj caycashpayquega jucha rurashanta perdunaycuy ari.» ");
INSERT INTO qub_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","Chaura Tayta Dios niran: «Ruwacamashayquinömi paycunata perdunashaj. ");
INSERT INTO qub_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","Rasunpami nogaga imaycamapis cawä. Intëru mundupis maquillächömi caycan. ");
INSERT INTO qub_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","23","Egiptucho, chunyaj jircacho milagrucunata rurashäta ricajcunaga manami ni jucnayllapis ricangachu unay famillyancunata aunishä nasyunta. Paycunaga quiquin munashanta rurachimayta munashpanmi yaparir-yaparir mana wiyacamashachu. Chayno rabyachimajcunaga manami mayganpis chay nasyunta ricangachu. ");
INSERT INTO qub_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","Sirbimajnë Calebmi ichanga nishäcunata riguir wiyacamasha. Chaymi ricapacoj aywashan partiman payllata yaycuchishaj. Paypita mirajcunapis chay partichömi tiyanga. ");
INSERT INTO qub_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","Ragran aywaj pampachöga tiyaycan Amalec runacunawan Cananeo runacunami. Chaymi gamcunaga wara junaj chunyajpa cutiy Puca Lamar läduman.» ");
INSERT INTO qub_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","Aarontawan Moisesta Tayta Dios niran: ");
INSERT INTO qub_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","«¿Fiyu Israelcuna washä rimashanta imaycamaraj awantashaj? Conträ rimashanta wiyashcänami. ");
INSERT INTO qub_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","Paycunaga rimaycan ‹Tayta Dios castigamashcanchi› nirmi. Chaymi cananga shimin nishanta cumlishaj. Nogaga cawämi. Nishäta cumlëmi. ");
INSERT INTO qub_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","Ishcay chunca (20) watayojpita janaman caj llapan sinsucojcuna, washä rimajcunaga cay chunyajllachömi ushacanga. Chaura ayancunapis chunyajchömi mashtarpanga. ");
INSERT INTO qub_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","Goycunäpaj aunishä nasyunman manami yaycongachu. Jefonepa wamran Calebwan Nunpa wamran Josuëllami aunishä nasyunmanga yayconga. ");
INSERT INTO qub_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","‹Chiquimajcunapa munayninchöchari canga› nishayqui wamrayquicunatami ichanga aunishä nasyunman chayachishaj. Paycunami ichanga manacajman churashayqui nasyuncho cushisha goyangapaj. ");
INSERT INTO qub_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","Gamcunapa ayayquega cay chunyajchömi mashtarpaycar quëdanga. ");
INSERT INTO qub_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","Wamrayquicunanami chuscu chunca (40) wata uywancunata ricallar chunyaj jirca-quinraypa goyanga. Chayno paycuna ñacanga gamcuna mana wiyacamashayquipitami. Puriycällarmi canan rucu cäga llapayqui ushacanquipaj. ");
INSERT INTO qub_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","Gamcunaga chuscu chunca (40) junajmi Canaán nasyunta ricapacamurayqui. Chaypitami ñacashpayqui purinquipaj chuscu chunca (40) wata. Chaynöpami cada junaj ricapacur purimushanpita juc wata chunyajpa purinquipaj. Chayrämi musyanquipaj conträ ricacojcunata imano castigashätapis. ");
INSERT INTO qub_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","Chaynömi nogaga rurashaj conträ jatarir mana wiyacamaj Israelcunata. Chaura paycunaga cay chunyajllachömi ushacanga. Noga Tayta Diosmi chayno në.» ");
INSERT INTO qub_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","Ricapacoj Moisés cachashan runacunami cutiycamur Israelcunataga willaparan «mana alli chacrami» nir. Chaynöpami llapan Israelcuna Tayta Diospa contran rimaran. ");
INSERT INTO qub_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","Chaypitami llullacuypa willajcunaga Tayta Diospa ñaupancho castïguwan wañuran. ");
INSERT INTO qub_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","Ricapacoj aywajcunaga Josuëwan Calebllami cawaycar quëdaran. ");
INSERT INTO qub_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","Tayta Dios nishanta Israelcunata Moisés willapaptin Israelcunaga fiyupa llaquicuran. ");
INSERT INTO qub_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","Chaymi tutalla jatarcärir altunnin puntaman aywaran. Chayaycärir Moisesta niran: «Nogacunaga juchatami rurashcä. Cananga caychönami caycäcuna. Juclla aywashun Tayta Dios aunimashanchi partiman.» ");
INSERT INTO qub_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","Chaura Moisés niran: «¿Imanirtaj Tayta Dios nishanta gamcuna mana wiyacunquichu? Manacajllapämi aywanquipaj. ");
INSERT INTO qub_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","Ama aywaychu. Tayta Diosga gamcunata manami yanapäshunquipächu. Chiquishojcunaga binsishunquipämi. ");
INSERT INTO qub_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","Amalec runacunawan Cananeo runacunaga magashunayquipaj, wañuchishunayquipämi shuyaycäshunqui. Tayta Diosman mana yäracushayquipitami gamcunatapis Tayta Dios mana yanapäshunquipänachu.» ");
INSERT INTO qub_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","Chaypis mana wiyacuypa aywaran punta puntayoj jircapa. Ichanga pacharpaycashanpita babulta mana aparanchu. Moisespis mana aywaranchu. ");
INSERT INTO qub_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","Chay partipa tiyaj Amalec runacunawan Cananeo runacunaga Israelcunata binsiran. Pasaypa binsirmi Horma marcacama gaticacharan. ");
INSERT INTO qub_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","Chaypitanaga Moisesta Tayta Dios niran: ");
INSERT INTO qub_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","«Israelcunata willanqui: Goycunäpaj caycaj nasyunman chayarga ");
INSERT INTO qub_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","Nogapaj sacrifisyucunata rupachenga. Chaycunapa jömuynenga nogapa shongöpänömi canga. Chay sacrifisyucunata rupachinqui rupachina sacrifisyu captinpis o aunimashayquita cumlishpayquipis, o buluntäniquipita uywata apamushpayquipis o fistapaj uywata apamushpayquipis. Chay sacrifisyucunapaj uywayquicunapita apamunqui töruta carpis, uyshata carpis, o cabrata carpis. ");
INSERT INTO qub_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","Sacrifisyupaj apamushayquiwan iwal apamunqui ishcay quïlu allinnin jarinata juc litru asëtiwan chapurcur. ");
INSERT INTO qub_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","Cada cashnita apamur jananman yapanga juc litru bïnuta. ");
INSERT INTO qub_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","«Carni captenga jananman yapanga chuscu quïlu jarinata litru masnin asëtiwan chapushata. ");
INSERT INTO qub_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","Jananmanpis nogapaj rupachiptin jömuynin shongöpäno cananpaj yapanga juc litru medyan bïnuta. ");
INSERT INTO qub_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","«Rupachina sacrifisyupaj apamurpis, aunishanta cumlirpis u alli goyaypita sacrifisyupaj apamurpis besërata apamushanpa ");
INSERT INTO qub_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","jananman yapanga sojta quïlu jarinata ishcay litru asëtiwan chapushata, ");
INSERT INTO qub_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","ishcay litru bïnuta. Chaycunata nogapaj rupachiptin jömuynin shongöpänömi canga. ");
INSERT INTO qub_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","Chaynöllami ruranga töruta apamurpis, carnita apamurpis, cashnita apamurpis, capshita apamurpis. ");
INSERT INTO qub_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","Ayca uywata apamurpis chaynömi cada uywapaj churanga. ");
INSERT INTO qub_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","Nogapa shongöpäno jömuynin cananpaj rupachir Israelcunaga chaynömi ruranga. ");
INSERT INTO qub_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","«Lagacamojcunapis nogapaj rupachinanpaj apamuyta munarga gamcuna rurashayquinöllami ruranga. ");
INSERT INTO qub_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","Nishätaga cumlinqui gamcunapis lagacamoj jäpacunapis. Chay nishäcunaga imaycamapis laymi canga gamcunapaj gamcunapita mirajcunapäpis. ");
INSERT INTO qub_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","Juc layllami canga gamcunapäpis jäpa runacunapäpis.» ");
INSERT INTO qub_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","Chaypitana Tayta Diosga Moisesta niran: ");
INSERT INTO qub_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","«Israelcunata willapanqui: Pushaycashä partiman chayaycorga ");
INSERT INTO qub_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","wayushan rïguta cusichar nogapäpis raquinqui. ");
INSERT INTO qub_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","Rimir puntata rïguta cusichar nogapaj raquishayquinöllami rimir mäsa chapushayquipitapis tantata nogapaj ruranqui. ");
INSERT INTO qub_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","Chaynöllami imaypis ofrendata nogapaj apamunqui. ");
INSERT INTO qub_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","«Moisesta nishä mandamintucunata mana musyayniquipa mana cumlir ");
INSERT INTO qub_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","cananpitaga gamcunapis, gamcunapita mirajcunapis caynömi ruranqui: ");
INSERT INTO qub_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","Mana musyayninpa llapan Israelcuna llutanta rurasha cashpanga llapanpäraj rupachina sacrifisyupaj juc töru-mallwata rupachenga jömuynin nogapa shongöpäno cananpaj. Chaytaga nishäno churanga chaqui micuy ofrendantawan bïnu ofrendantawan. Chïbutana juchapita sacrifisyupaj pishtanga. ");
INSERT INTO qub_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","Nircur cüranami rupachenga llapan Israelcunata juchanpita perdunanäpaj. Chayrämi perdunashaj. Paycuna mana musyayninpa juchata rurashanpita pishtanga, ofrendatapis apamonga. ");
INSERT INTO qub_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","Mana musyayninpa juchata rurasha captenga noga perdunashämi Israelcunata, lagacamoj jäpa runacunatapis. ");
INSERT INTO qub_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","«Pipis mana musyayninpa llutanta rurasha cashpanga juchapita sacrifisyupaj watayoj china cabra-mallwata pishtanga. ");
INSERT INTO qub_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","Cüranami rupachenga chay runa mana musyayninpa juchata rurashanpita perdunanäpaj. ");
INSERT INTO qub_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","Mana musyayninpa juchata rurashanpita chay layllami canga Israelcunapäpis, lagacoj jäpa runacunapäpis. ");
INSERT INTO qub_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","«Pipis yarpaypa juchata rurarga Israel carpis, jäpa carpis nogatami rabyachiman. Chaymi chay runaga ushacächisha canga. ");
INSERT INTO qub_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","Noga nishäta mana wiyacushpan manacajman churashanpitami, yachachishätapis mana rurashanpitami illgächisha canga. Quiquinmi juchayojpis canga.» ");
INSERT INTO qub_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","Israelcuna chunyajcho caycashallanchöraj tariran Israel-masin runa säbadu jamay junajcho yantacuycajta. ");
INSERT INTO qub_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","Tariycärir aparan Moisesman Aaronman llapan runacuna caycashanman. ");
INSERT INTO qub_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","Yantacuycajta tarishanta willaptinmi imano castigananpäpis mana musyar paycunaga prësulla chariraran. ");
INSERT INTO qub_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","Chaymi Tayta Diosga Moisesta niran: «Chay runaga wañunanmi merësin. Chaymi tiyarcaycashanpita juc-läman jorguycur llapan Israelcuna sajmachun.» ");
INSERT INTO qub_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","Chaura Tayta Dios nishannöllami Israelcunaga juc-läman jorguycur wañunanyaj sajmaran. ");
INSERT INTO qub_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","Tayta Diosga Moisesta niran: ");
INSERT INTO qub_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","«Israelcunata willapay: Gamcunapis, gamcunapita mirajcunapis röpayquipa cantunman murädu jïluwan paychancunata imaypis jiranqui. ");
INSERT INTO qub_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","Chay paychacunata ricashpayquimi gamcunaga yarpanquipaj llapan mandamintöcunata cumlinayquipaj cashanta. Chauraga quiquiquicunapa shonguyqui munashanta mananami ruranquipächu. ");
INSERT INTO qub_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","Chaynöpami mandamintöcunata yarpanquipaj, cumlinquipaj. Noga Tayta Diosniqui acrashäna canquipäpis. ");
INSERT INTO qub_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","Noga Tayta Diosniquimi Egipto nasyunpita jorgamushcä acracushä runacuna canayquipaj. Noga Tayta Diosniquimi chayno në.» ");
INSERT INTO qub_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","Leví trïbu Coatpita mirar aywaj Izharpa wamranmi caran Coré. Rubén trïbupita mirar aywajpis caran Eliabpa wamrancuna Datanwan Abiram y Peletpa wamran On jutiyojpis. ");
INSERT INTO qub_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","Paycunami ishcay pachac pichga chuncan (250) runacunawan Moisespa contran jatariran. Paycunaga caran runacuna churashan mandajcunami, tantiyachejcunami. ");
INSERT INTO qub_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","Paycunami shuntacaycur Aarontawan Moisesta niran: «¡Alläpanami gamcunaga mandaycämanqui! Llapanchïtami Tayta Diosga acramashcanchi. Llapanchïtami yanapaycämanchïpis. Chauraga ¿imanirtaj gamcunalla munayniyoj cashayquita yarpanqui?» ");
INSERT INTO qub_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","Chayno niptin Moisesga gongurpacushpan cumuran urcunpis pampaman töpanancama. ");
INSERT INTO qub_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","Nircur Corëtapis waquin runacunatapis niran: «Wara tutami Tayta Dios musyachimäshun pï paypa cashanta, pita acrashanta, pï ofrendancunata churananpaj cashanta. Pay quiquinmi nenga picuna ñaupanman witinanpäpis. ");
INSERT INTO qub_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","Wara tuta gamcunaga Corëwan cajcuna llapaniqui shamunqui insinsu saumachicunayquita apacurcur. ");
INSERT INTO qub_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","Chaycunaman shanshata wiñarcur insinsuta rupachinqui Tayta Diospa ñaupancho. Chaychömi Tayta Dios musyachishunqui pita acrashantapis. Pitapis acrashan cajllatami Tayta Dios chasquenga. ¡Leví trïbu runacuna, gamcunaga alläpanami caycanqui!» ");
INSERT INTO qub_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","Nircur Corëta Moisés niran: «Sumaj wiyamay Leví runacuna. ");
INSERT INTO qub_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","Israelcunapa Tayta Diosnenga ¿imapätaj acrashurayqui Israel-masiquicunapita? Acrashurayqui paypa ñaupancho arunayquipaj, Tolducho aruy cajcunata llapan runacunapa ruquin ruranayquipämi. ");
INSERT INTO qub_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","Tayta Diosga munasha gampis waquin Leví trïbu runacunapis paypa ñaupancho arunayquitami. ¿Cananga cürapa aruynintanachu guechuyta munaycanqui? ");
INSERT INTO qub_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","Aaronga lluta runallami. ¿Imapätaj paypa contran rimaycanqui? Llapaniquipis gamcunaga Tayta Diospa contranmi ricacushcanqui.» ");
INSERT INTO qub_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","Nircur Moisesga gayachiran Eliabpa wamrancuna Datantawan Abiramta. Paycunaga wiyaytapis mana munar niran: «Manami aywächu. ");
INSERT INTO qub_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","Lëchipis mishquipis yacunöraj cashan Egipto nasyunpita jorgarcamashpayqui cay chunyaj chaqui jircaman pushamashcanqui wañunäpaj. Chayno rurarga ¿allita rurashayquitachu yarpanqui? ¿Jinachöpis mandajnëcuna caytarächu munaycanqui? ");
INSERT INTO qub_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","Canancamapis manami chayachimashcanquirächu lëchipis mishquipis yacuno achca cashan nasyunmanga. Manami chacracunatapis ni übas chacratapis gomashcanquichu. ¿Imaycamataj chaynölla engañamanqui? Chaymi mana shamushäcunachu.» ");
INSERT INTO qub_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","Chaymi Moisesga fiyupa rabyacur Tayta Diosta niran: «¡Paycunapa ofrendantaga ama chasquiychu Tayta! Paycunataga manami ni juc bürrullantapis guechushcächu. Manami imaypis paycunata ufindishcächu.» ");
INSERT INTO qub_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","Chaypitana Corëta Moisés niran: «Wara tuta Tayta Diospa ñaupanman shamunqui mandayta munaj-masiquicunawan. Aaronpis chaychömi caycanga. ");
INSERT INTO qub_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","Cada-ünuyqui Tayta Diospa ñaupanman insinsu saumachicunayquita insinsuntawan apamunqui. Aaronpis insinsu saumachicunanta apamonga. Chaura ishcay pachac pichga chunca ishcay (252) saumachicunami canga.» ");
INSERT INTO qub_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","Chaura cada-ünun insinsu saumachicunanta aparan shanshatawan insinsuta wiñarcärir. Nircurnami Tincuna Toldu puncucho Aaronwan Moisés caycashanman shuntacaran. ");
INSERT INTO qub_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","Corëga maynami runacunata Tincuna Toldu ñaupanman Moisespawan Aaronpa contran shuntasha caycächiran. Chaycho llapan runacuna shuntacasha caycaptinmi Tayta Diospa achicyaynin ricacämuran. ");
INSERT INTO qub_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","Aarontawan Moisestana Tayta Dios niran: ");
INSERT INTO qub_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","«¡Cananmi cay runacunata illgarachishaj! Gamcuna cay runacunapa ñaupanpita witicuy.» ");
INSERT INTO qub_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","Chaura paycunaga gongurpacur urcunpis pampaman töpananyaj cumurcur niran: «Ay Tayta Dios, gammi llapan runatapis cawayta gonqui. ¿Juc runalla juchata rurashanpitachuraj llapan runacunapaj rabyacurcunqui?» ");
INSERT INTO qub_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","Chayno niptin Tayta Dios niran: ");
INSERT INTO qub_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","«Israel runacunata willay Coré, Datán, Abiram tiyaycashan ñaupanpita juc-läman witicunanpaj.» ");
INSERT INTO qub_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","Chaymi Moisesga mayur Israelcunawan aywaran Datanwan Abiram caycashan cajman. ");
INSERT INTO qub_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","Chayaycur Moisesga waquin runacunata niran: «Cay fiyu runacunapa tolduncuna ñaupanpita witicuy. Paycunapataga imantapis ama yataychu. Yatashpayquega paycunapa juchanpita gamcunapis wañunquipämi.» ");
INSERT INTO qub_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","Chaura llapan runacuna witicuriran Corëpa, Datanpa, Abirampa tolduncuna caycashan cajpita. Abiramwan Datanga tolduncuna puncuncho warmincunawan wamrancunawan caycaran. ");
INSERT INTO qub_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","Chaypita runacunata Moisés niran: «Cananmi musyanqui Tayta Dios cachamasha captin imatapis rurashäta, quiquilläpita imatapis mana rurashäta. ");
INSERT INTO qub_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","Cay runacuna waquin runacunanöpis alli wañuypa wañuptenga manami Tayta Dioschu cachamasha canga. ");
INSERT INTO qub_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","Mana ricashayquita Tayta Dios ruraptin, pachapa shimin quichacäcur llapan ima-aycantawanpis chay runacunata cawaycajta pacha ultacurcuptin gamcuna musyanquipaj chay runacuna Tayta Diospa contran jatarishanta.» ");
INSERT INTO qub_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","Moisés rimayta usharcuptin pachapa shimin quichacäcuran chay runacuna ichiraycashan cajpa. ");
INSERT INTO qub_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","Pachapa shimin quichacäcur ultacurcuran Corëta, Coré nishanta ruraj runacunata llapan wamrancunatawan warmincunatawan ima-aycantawanpis. ");
INSERT INTO qub_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","Chay runacunataga cawaycajllata ima-aycantintapis pachapa shimin ultacurcuran. Nircorga cashgan wichgacäcuran. Chaynömi Israelcunapitaga fiyu runacunata illgarachiran. ");
INSERT INTO qub_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","Pacha quichacäcuptin gaparpajta wiyashpan ñaupancho caycaj Israelcunapis gueshpir aywacuran «Noganchïtapis pachaga micucarcamäshunmi» nir. ");
INSERT INTO qub_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","Tayta Diosga ninawan ruparachiran ishcay pachac pichga chuncan (250) insinsuta saumachej runacunatapis. ");
INSERT INTO qub_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","Chaypitana Tayta Diosga Moisesta niran: ");
INSERT INTO qub_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","«Chay wañoj runacunapa cada saumachicunan rispitädumi caycan. Chaymi Aaronpa wamran Eleazarta cachay paycunapa saumachicunanta nina rupashanpita jorgunanpaj, saumachicunancho caycaj shanshatana shuntarcur Israelcuna tiyaycashanpita caruman jitarinanpaj. ");
INSERT INTO qub_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","Nogapa ñaupächo insinsuta saumachishanpitami cada saumachicunan rispitäduna caycan. Chaymi conträ jatarishanpita cada wañoj runapa saumachicunanta chullurcachir llapshallata altarman laganqui. Chayga canga Israel runacuna ricacushpan conträ mana jatarinanpämi.» ");
INSERT INTO qub_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","Chaura cüra Eleazar shuntaran rupaypa wañoj runacunapa runsipita insinsu saumachicunanta. Shuntashancunata chullurcachirmi llapshallata tacachiran altarman chapyachinanpaj. ");
INSERT INTO qub_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","Altarman chayno lagaran pï runapis chayta ricacur Tayta Diospa ñaupancho insinsuta llutalla mana saumachinanpämi. Pipis llutalla saumacherga Corëno yan'guincunano wañunan caran. Corëtapis yan'guincunatapis chayno päsaran Moisesta Tayta Dios nishannömi. ");
INSERT INTO qub_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","Chaypita warannin junäga llapan runacuna Aarontawan Moisesta gayapar niran: «¡Gamcunaga Tayta Dios acrashan runacunatami wañurcaycächinqui!» ");
INSERT INTO qub_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","Chayno nishpan llapan runacuna Aarontawan Moisesta juntapaycuran. Chaura paycunaga Tincuna Tolduman aywaran. Aywarcaycaptin Tincuna Tolduta pucutay chapacurcuran. Tayta Diospa achicyayninpis chaycho yuricurcuran. ");
INSERT INTO qub_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","Chaura Aaronwan Moisesga Tincuna Toldu puncunman aywaran. ");
INSERT INTO qub_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","Chaychömi Tayta Diosga Moisesta niran: ");
INSERT INTO qub_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","«¡Chay runacunapita witicuy. Cananmi paycunata illgarachishaj!» Chayno niptin Aaronwan Moisesga ruwacushpan lätaycur urcuncunapis pampaman töpananyaj cumuran. ");
INSERT INTO qub_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","Moisesna Aaronta niran: «Tayta Diosga fiyupa rabyacurcurmi runacunata wañuycächin. Cananga altarman juclla aywar insinsu saumachicunayquiman shanshatawan insinsuta wiñay. Chayta apacurcur ayway runacuna caycashan cajman. Chaycho Tayta Diosta ruwacuy paycunata perdunananpaj.» ");
INSERT INTO qub_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","Moisés chayno nishanta Aaronga ruraran. Runacuna goturpaycashan cajman cörriyllapa aywaran. Chay öraga Tayta Diospa castïgunwan runacuna wañuycaranna. Chaura Aaronga insinsuwan saumachishpan Tayta Diosta mañacuran runacunata perdunananpaj. ");
INSERT INTO qub_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","Wañusha jitaraycaj runacunata päsarir cawaycaj runacunapa ñaupanman Aarón ichicuycur Tayta Diosta ruwacuptinrämi wañuy chawaran. ");
INSERT INTO qub_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","Chay örapäga mayna wañuran chunca chuscu waranga ganchis pachacnin (14,700) runacuna. Chayno caran Corëwan wañojcunata mana yupayllapami. ");
INSERT INTO qub_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","Wañuy chawaycuptinna Aaronga cutiran Tincuna Toldu puncucho Moisés caycashan cajman. ");
INSERT INTO qub_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","Chaypitana Moisesta Tayta Dios niran: ");
INSERT INTO qub_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","«Cada trïbu Israelcunapa mandajnincunata ninqui bastunninta apamunanpaj. Llapan apamuptin canga chunca ishcay (12) bastuncunami. Gamnami cada bastunman mayganpa cashantapis jutincunata isquirbinqui. ");
INSERT INTO qub_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","Leví trïbupa cajmanga Aaronpa jutinta isquirbinqui. Cada trïbupa mandajninpami juc bastun canga. ");
INSERT INTO qub_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","Chay bastuncunataga churanqui Tincuna Tolducho babul ñaupanman. Chaychömi gamwan cadalla tincunchi. ");
INSERT INTO qub_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","Acrashä runapa bastunnintami chillguichimushaj. Chayrämi Israelcunaga gamcunapa washayquita mana rimanganachu.» ");
INSERT INTO qub_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","Tayta Dios nishannöllami Moisesga Israelcunata willaran. Chaymi cada trïbupa mandajnin juc bastunta-cama Moisesman aparan. Aaronpa bastunninpis paycunapa bastunninwan caycaran. Llapanga caycaran chunca ishcay (12) bastunna. ");
INSERT INTO qub_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","Chay bastuncunatami Moisesga churaran Tincuna Toldu rurincho babul caycashan cajman. ");
INSERT INTO qub_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","Warannin Tincuna Tolduman aywar Moisés tariran Leví trïbu Aaronpa bastunnin chillguisha caycajta, waytarcur wayuyninpis poguraycajtana. ");
INSERT INTO qub_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","Chaura Moisesga Tayta Diospa ñaupanpita llapan bastuncunata jorgamuran Israelcuna ricananpaj. Ricaycärerga cada ünunna bastunninta shuntacuran. ");
INSERT INTO qub_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","Chaura Tayta Diosga Moisesta niran: «Aaronpa bastunninta cutichiy babul ñaupanman. Chayman churanqui mana wiyacoj Israelcuna ricacunanpaj. Chaynöpami washayquita mana rimangachu. Chauraga manami wañonganachu.» ");
INSERT INTO qub_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","Moisesga Tayta Dios nishannölla ruraran. ");
INSERT INTO qub_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","Israelcuna ichanga Moisesta niran: «¡Nogacunapäga imapis manami allinachu! ¡Llapanëchari wañushaj! ");
INSERT INTO qub_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","Tayta Diospa Tincuna Toldunman chayaj cäga llapanmi wañun. Chayno captenga ¿llapanëchuraj wañushaj?» ");
INSERT INTO qub_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","Chaypitana Tayta Diosga Aaronta niran: «Gam, wamrayquicuna, waquin famillyayquicunapis Rispitädu Tincuna Tolducho imatapis llutanta rurarga llapayquimi juchayoj canquipaj. Ichanga cüra rurananpaj cajcunata imatapis llutanta rurashpayquega gamwan wamrayquicunallami juchayoj canquipaj. ");
INSERT INTO qub_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","Leví trïbu runacunata willanqui gamtawan wamrayquicunata yanapäshunayquipaj. Paycunami yanapäshunquipaj Tincunanchi Tolducho ima ruraycunachöpis. ");
INSERT INTO qub_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","Chay Leví trïbu-masiquicunaga ‹ruray› nishallayquitami ruranga. Tolducho ima ruraycunatapis ruräshishushpayqui ama yaycongachu altarpa ñaupanman, rispitädu cösacuna caycashanmanpis. Chaycunaman yaycuptin u yataptenga paycunapis gamcunapis wañunquipämi. ");
INSERT INTO qub_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","Tincuna Toldu cajcho ima ruraycunatapis Leví trïbu runacuna ruräshishunquimi. Paycunallami ruräshishunqui. Juccunaga manami ruräshishunquipächu. ");
INSERT INTO qub_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","«Gamcunallami Tincuna Tolducho, altarcho caj ruraycunatapis ruranquipaj. Chay nishäcunata wiyacuptiquega Israelcunapaj yapayga manami rabyashänachu. ");
INSERT INTO qub_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","Israel runacunapita Leví trïbu runacunataga nogami acrashcä gamcunatana goycunäpaj, Tincuna Tolducho ruraycunata ruräshishunayquipaj. ");
INSERT INTO qub_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","Gamtawan wamrayquicunatami ichanga churashcä nogata sirbimaj cüra canayquipaj. Chaymi gamwan wamrayquicunalla altarcho, Rispitädu cuartucho ruranayquipaj cajcunata ruranqui. Pipis mana cüra caycar cüra rurananta ruräga wañuchicangami.» ");
INSERT INTO qub_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","Chaypitana Aaronta Tayta Dios niran: «Nogapaj Israelcuna apamushancunata gammi ricanqui. Chay apamushan rispitädu cajcunata gamtami wamrayquicunatami goycö. Chay nishäcunaga imaycamapis laymi gamcunapaj canga. ");
INSERT INTO qub_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","Israelcuna rupachinanpaj apamushanpita raquishan cäga gamcunapämi canga: Chaqui micuy ofrendan car, uywancunata juchapita sacrifisyuta pishtashan car, cutichina sacrifisyuta garamashan carpis. Chaycunaga llapan canga gampämi wamrayquicunapämi. ");
INSERT INTO qub_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","Gamcunaga ollgu cajcunallami chay rispitädu cajcunata micunqui. Nogapaj acrasha captin sawan pampallacho micunqui. ");
INSERT INTO qub_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","«Israelcuna apamushanta cuyuchir ricachimashpayqui entregamashayquitapis goycö gamta, ollgu wamrayquicunata, maquiquicho caj warmi wamrayquicunatapis. Gampa famillyayquicuna juchaynaj cashpanga llapanpis micongami chay garamashanta. Chay nishäcunaga imaycamapis laymi gamcunapaj canga. ");
INSERT INTO qub_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","Gamta goycushayqui cada wata Israelcuna rimir-punta shuntar raquir apamushanta: alli caj asëtita, alli caj bïnuta, rïgutapis. ");
INSERT INTO qub_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","Gamtami goycö rimir-punta cosëchancunapita nogapaj apamushancunatapis. Gampa famillyayquicuna limyu cashpanga chay ofrendacunata micongami. ");
INSERT INTO qub_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","Israelcuna nogapaj apamushanga llapanpis gampämi canga. ");
INSERT INTO qub_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","«Israelcunapa guechpa ollgu wamrancunata, uywanpatapis rimir-punta caj orgu wawanta nogata goycamashanga gampämi canga. Guechpa wamranpa ruquin, mana micuna caj uywacunapa rimir wawanpa ruquin ichanga risyunta pägashunqui. ");
INSERT INTO qub_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","Yurishanpita juc quillayoj caycaptin päganta apamonga pichga guellayta. Pägashan guellaytaga Tincuna Tolducho tupuwan tuponga. Chay tupuwan tupuptin chunca grämumi lasanga. ");
INSERT INTO qub_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","Wäcapa, uyshapa, cabrapa ruquintaga ama chasquinquichu. Chay uywacunapa wawanga nogapaj acrashami. Chaycunataga pishtarcur yawarninta altarman jichanqui. Wirancunatapis altarcho rupachinqui. Chay rupachishayquipa jömuyninmi nogapa shongöpäno canga. ");
INSERT INTO qub_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","Chay uywapa aychanga gamcunapämi canga. Chaycunaga gampämi canga cuyuchir ricachiypa entregamashayqui pëchun, derëchu caj chancan gampaj cashannömi. ");
INSERT INTO qub_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","Israelcuna nogapaj apamushantapis goycö gamtami, ollgu wamrayquicunatami, maquiquicho goyaj warmi wamrayquicunatami. Nishätaga imaypis ama gonganquichu. Parlashanchëga manami rucangachu. Gampaj, gampita mirajcunapaj imaycamapis chayno cananpämi auniycä.» ");
INSERT INTO qub_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","Aaronta Tayta Dios niran: «Israelcuna tiyashan nasyunchöga manami cangachu chacrayqui, ni ima-aycayquicunapis. Chacrata chasquinayquipa ruquenga nogami gamcunapa erensyayqui cashaj. ");
INSERT INTO qub_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","Leví trïbu-masiquicunapänami canga Israel runacuna diesmuta apamushan. Chay apamushancunaga Tincuna Tolducho sirbimashanpita paycunapämi canga. ");
INSERT INTO qub_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","Waquin Israelcunaga Tincuna Tolduman ama yaycongachu. Yaycur-imarga wañuytami tarenga. ");
INSERT INTO qub_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","Leví trïbu runacunallami Tincuna Tolducho ruraycunata ruranga. Imapis mana alli chaycho captenga paycunami juchayoj canga. Chay nishäcunaga imaycamapis laymi canga Leví trïbu runacunapaj y paycunapita mirajcunapäpis. Israelcuna tiyashanchöga Leví trïbu runacunapa chacran quiquincunapaga manami cangachu. ");
INSERT INTO qub_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","Chacrancunacho wayushanpa diesmunta Israelcuna nogapaj apamushantami Leví trïbu runacunataga quiquinpa cananpaj goycushcä. Chaymi paycunapäga nishcä Israel runacuna tiyashancho chacran mana cananpaj.» ");
INSERT INTO qub_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","Chaypitaga Moisesta Tayta Dios niran: ");
INSERT INTO qub_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","«Leví trïbu runacunata gam willapay. Israelcuna diesmunta apamushanta chasquir Leví trïbu runacunapis yapay diesmuta raquircur nogapaj apamonga. ");
INSERT INTO qub_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","Garamashanga canga rimir cusichashan rïgunta, rimir llojshej bïnunta Israel-masincuna garamashan-japuymi. ");
INSERT INTO qub_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","Chaynömi Israelcuna diesmunta apamushanta chasquir Leví trïbu runacunapis nogapaj diesmuta raquenga. Nircur cüra Aaronta gonga. ");
INSERT INTO qub_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","Ima-aycata chasquirpis simri llapanpita raquenga nogata garamänanpaj. Nogapäga allinnin cajtami acranga. ");
INSERT INTO qub_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","«Mastapis willapanqui: ‹Allinnin cajta nogapaj raquiriptiqui waquenga quiquiquicunapa rïguyquino, bïnuyquinöna canga. ");
INSERT INTO qub_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","Chaytaga llapan famillyayquicunawan maychöpis micunqui. Chayga Tincuna Tolducho arushayquipita päguyquimi canga. ");
INSERT INTO qub_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","Allinnin cajta nogapaj raquirerga puchoj cajta micucunquina. Chayta micorga manami juchayojnachu canquipaj. Manami manacajman churanquinachu Israelcuna apamushan ofrendatapis. Chaura manami wañuchicanquipänapischu.› » ");
INSERT INTO qub_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","Chaypitana Aarontawan Moisesta Tayta Dios niran: ");
INSERT INTO qub_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","«Yapay juc laytana willapäshayqui. Manaraj aroj puca wäcata Israelcuna apamuchun. Chay wäcaga canga sänu. ");
INSERT INTO qub_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","Chayta chasquircur cüra Eleazarna tiyarcaycashayquipita juc-läman apaycur ricapaycällar pishtachenga. ");
INSERT INTO qub_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","Cüra Eleazarga chay wäcapa yawarninman dëdunta jatircur Tincuna Toldu caj-läman ganchis cuti tapsenga. ");
INSERT INTO qub_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","Jinancho ruparachenga wäcapa aychanta, garanta, yawarninta, ashashninta. ");
INSERT INTO qub_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","Cüra Eleazarga wäcapa aychan rupaycajman sedruta, chajchucuna jachata, puca tëlata jitapayconga. ");
INSERT INTO qub_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","Nircurnami cüraga bäñacurir, tagshacurir tiyarcaycashanman cutenga. Ichanga pacha chacänancamaraj ganra canga. ");
INSERT INTO qub_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","Wäcata pishtarcur rupachejpis tagshaconga, bäñaconga. Paypis pacha chacänancamami ganra canga. ");
INSERT INTO qub_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","Chaypitaga juc limyu runana wäca rupashan uchpanta shuntanga. Nircur runacuna tiyarcaycashanpita juc-läman apaycur churayconga limyu pachaman. Israelcunaga chay uchpatami yacuwan talluchenga ganra ricacushanpita limyuyächina yacu cananpaj. Chay-niraj yacuta ruranga juchapita limyuyächina cananpämi. ");
INSERT INTO qub_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","Uchpa shuntajpis tagshaconga. Nircur paypis pacha chacänancama ganra canga. Chay nishäcunaga juc laymi canga gamcunapäpis lagacamoj runacunapäpis. ");
INSERT INTO qub_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","«Pipis, ayata yatäga ganchis junajyajmi ganra canga. ");
INSERT INTO qub_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","Ganrayashanpita quimsa junajcho y ganchis junajcho limyuyächina yacuwan limyuyanga. Ichanga quimsa junaj cajcho ni ganchis junaj cajchöpis limyuyänanpaj mana rurarga ganrallami canga. ");
INSERT INTO qub_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","Pipis ayata yataycur mana limyuyarga Toldötami ganrachin. Limyuyächina yacuta mana wiñapasha carga ganrallami canga. Chay runaga Israelcunapita gargushami canga. ");
INSERT INTO qub_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","«Tiyanan tolduncho wañuptenga tolducho caycajpis tolduman yaycojpis ganchis junajyaj ganrana canga. ");
INSERT INTO qub_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","Chapäni cajcunapis, mana sumaj chapashacunapis ganranami ricaconga. ");
INSERT INTO qub_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","«Runa wañuchishanta, quiquillan wañushata toldupita juc-lächo tarir, runapa tullunta tarir, sepultürata tarir yatarga ganchis junajyaj ganrami ricaconga. ");
INSERT INTO qub_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","«Chayno ganra captenga juchapita rupachishan puca wäcapa uchpanta mancaman wiñarcur pucyu yacutapis wiñanga. ");
INSERT INTO qub_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","Nircorga limyu caycaj runami chay yacuman chajchucuna jachata jatircur chajchupanga ganra runa tiyashan tolduta, toldu rurincho llapan ima-aycancunata, llapan chaycho tiyajcunatapis. Ganra runatapis chajchupanga tulluta yatasha captinpis, runa wañuchishan ayata yatasha captinpis, quiquillan wañusha runapa ayanta yatasha captinpis u aya pamparashanta yatasha captinpis. ");
INSERT INTO qub_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","Limyu caycaj runaga ganra caycaj runata yacuwan chajchupanga quimsa junaj cajcho, ganchis junaj cajchöpis. Ganchis caj junajchöga limyunami canga. Chaura ganra caj runaga tagshaconga, bäñaconga. Chaypis pacha chacänancamami ganra canga. ");
INSERT INTO qub_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","Pipis ganra cashanpita mana limyuyaj runaga marcayquipita gargushami canga. Ganra cashpanga Toldötami ganrachin. Limyuyächicoj yacuwan mana chajchupasha cashpanga ganrallami canga. ");
INSERT INTO qub_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","Cay nishäcunaga imaycamapis laymi gamcunapaj canga. «Limyuyächej yacuwan chajchöga röpanta tagshaconga. Limyuyächicoj yacuta yataj cajpis pacha chacänancama ganrami canga. ");
INSERT INTO qub_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","Ganra caycaj runa imatapis yatashanga ganranami canga. Ganra caycaj runata yataycoj runapis pacha chacänancama ganrami canga.» ");
INSERT INTO qub_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","Wataman gallarej quillacho Zin chunyajman Israelcuna chayaycur Cades marcacho unaycama goyaran. Chaycho tiyarcaycaptin María wañuptin pampaycäriran. ");
INSERT INTO qub_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","Chaycho yacu mana caranchu. Chaura Israelcunaga llapan shuntacaycärir Moisespawan Aaronpa contran jatariran. ");
INSERT INTO qub_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","Moisesta niran: «¡Cayno ñacanäcunapitaga mas allimi canman caran Tayta Dios wañuchishan famillyäcunawan iwal wañucuptëna! ");
INSERT INTO qub_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","¿Tayta Dios acrashan runacunata imapätaj cay chunyajman pushamashcanqui? ¿Uywäcunawan iwal ushacänätachu munarcaycanqui? ");
INSERT INTO qub_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","¿Imapätaj Egiptupita pushamashcanqui cay fiyupa chunyaj partimanga? Cay partiga manami allichu murupacunapäpis. Manami caychöga canchu ïgus, übas, granadapis. ¡Yacupis upunanchïpaj manami canchu!» ");
INSERT INTO qub_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","Chaura Aaronwan Moisesga Tincuna Toldu puncuman aywaran. Chaychöna ima ruraytapis mana camäpacushpan gongurpacur umpuran urcunpis pampaman töpanancama. Chay örami Tayta Diospa achicyaynin yuricurcuran. ");
INSERT INTO qub_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","Moisesta Tayta Dios niran: ");
INSERT INTO qub_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","«Bastunniquita apacurcur aywar wauguiqui Aaronwan ishcaniqui runacunata shuntay. Nircur llapan runacunapa ñaupancho gagata ninqui ‹yacu llojshimuchun› nir. Chauraga gagapitami yacu llojshimonga llapan uywancuna, runacuna upunanpaj.» ");
INSERT INTO qub_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","Chaura Tayta Dios nishannölla Moisesga babul ñaupancho caycaj bastunta aparan. ");
INSERT INTO qub_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","Nircur Aaronwan Moisesga gagapa ñaupanman llapan runacunata shuntaran. Moisesna niran: «Mana wiyacoj runacuna, ¿cay gagapitachuraj jorgamushaj yacuta upunayquipaj?» ");
INSERT INTO qub_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","Chayno nirmi Moisesga aptaraycashan bastunwan ishcay cuti gagata wiruran. Chaura aypalla yacu llojshimuran. Chaytami jinan öra llapan runacuna, uywancuna upuran. ");
INSERT INTO qub_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","Chaypitanami Tayta Diosga Aarontawan Moisesta niran: «Gamcunaga nishäta manami riguishcanquichu. Ni Israelcunapa ricay-ñawinchöpis manami wiyacamashcanquichu. Chaypitami cay runacunata aunishä partiman mana yaycunquipächu.» ");
INSERT INTO qub_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","Chaycho Israel runacuna Tayta Diospa contran parlashanpitami chay achca yacu pashtamushanpa jutin caycan «Meriba». Chaychömi Tayta Dios musyachiran santo captin runacuna payta wiyacunanpaj cashanta. ");
INSERT INTO qub_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","Cadespita Moisesga cachacunata cachacuran Edom nasyunpa rayninman. Cayno willachiran: «Castayqui Israelcunami caycä. Gamga musyaycanquinami nogacuna fiyupa ñacar goyashäta. ");
INSERT INTO qub_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","Unay castäcuna Egiptuman aywacushanpita-pachami canancama chaycho tiyamushcä. Egipto runacunaga amatarmi ñacachimasha, unay caj awilöcunatapis. ");
INSERT INTO qub_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","Chaura Tayta Diosta mañacushcä. Paynami amatar ñacar wagashäcunata wiyamasha. Chaymi anjilninta cachamusha llapanëta Egiptupita jorgamänanpaj. «Chaynöpami nasyunniquipa lindan Cades marcachöna caycäcuna. ");
INSERT INTO qub_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","Nasyunniquipa päsaj nänillapa päsacuycushaj ari. Manami päsashächu mururaycaj chacracuna jananpa, übas lantaraycaj jananpa. Uchcushayqui pösucunacho caj yacuyquitapis manami upushächu. Nogacunaga jatun nänillanpami päsacushaj maypapis mana yagaycachaypa.» ");
INSERT INTO qub_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","Cacha aywaj chayno niptin Edompa raynenga niran: «Nasyunnëpaga manami päsanquichu. Yaycamuptiquega suldäröcunawanmi shamushaj.» ");
INSERT INTO qub_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","Niptinmi Israelcunaga yapay cachacuran cayno ninanpaj: «Nogacunaga maymanpis mana yagaycachaypa jatun nänillanpami päsacushaj. Nogacunapis uywäcunapis yacuyquita uporga pägashayquimi. Nasyunniquipa päsaj nänillayquipa päsacuyculläshaj ari.» ");
INSERT INTO qub_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","Chaypis Edompa raynenga niran: «¡Manami päsanquichu!» Chayno nirmi Israelcunawan pillyananpaj aywaran sumaj camaricusha aypalla suldäruncunawan. ");
INSERT INTO qub_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","Mana päsananta michar aywaptinmi Israelcunaga juc nänipana tumaran. ");
INSERT INTO qub_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","Chaymi Cadespita llapan Israelcuna aywacuran Hor jirca lädumanna. ");
INSERT INTO qub_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","Hor jircapis Edom nasyunpa lindan sercachömi caran. Chayman chayaptin Aarontawan Moisesta Tayta Dios niran: ");
INSERT INTO qub_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","«Aaronga wañonganami. Meriba yacu pashtajchömi gamcunaga nishäta mana rurarayquichu. Chaypitami payga mana chayanganachu Israelcunata ‹goycushayqui› nishä partiman. ");
INSERT INTO qub_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","Aaronta wamran Eleazartawan quiquin Hor puntaman pushay. ");
INSERT INTO qub_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","Puntachöna Aaronta lojtipanqui cüra cay röpanta. Nircur wamran Eleazartana jatipanqui. Aaronga chayllachönami wañonga.» ");
INSERT INTO qub_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","Chayno niptinmi Tayta Dios nishannölla Moisés ruraran. Chaymi llapan Israelcuna ricaycaptin Aarontawan Eleazarta pushacurcur Hor puntaman wicharan. ");
INSERT INTO qub_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","Quiquin puntachöna Aarontaga Moisés lojtiparan cüra cay röpanta. Nircur Eleazartana jatiparcuran. Chayllachöna Aaronga wañucuran. Eleazarllawanna Moisesga puntapita cutimuran. ");
INSERT INTO qub_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","Aarón wañushanta musyaycur Israelcunaga juc quillacama llaquicur lüturan. ");
INSERT INTO qub_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","Néguev partichömi caran Arad siudä. Chay siudäpa raynin Cananeo runami caran. Chay raymi mayaran «Israelcuna Atarim näninpa aywaycämun» nejta. Chaura pillyaj aywaran. Nircur ishcay quimsa Israelcunata prësu apacuran. ");
INSERT INTO qub_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","Chaura Israelcunaga Tayta Diosta mañacur niran: «Chay Arad runacunata binsinäpaj yanapämaptiquega caseryuncunatawan ushajpämi illgächishaj.» ");
INSERT INTO qub_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","Chaura Israelcuna mañacushannömi Tayta Dios camacächiran. Chaymi yanaparan Cananeo runacunata binsinanpaj, siudänincunatapis juchuchir-ushananpaj. Chayno ushaypa wañuchishanpitami chay partipa jutinta churaparan «Horma» nir. ");
INSERT INTO qub_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","Hor jircapitana Israelcuna aywacuran Puca Lamar läduman. Edom nasyunman mana yaycupänanpaj carupa tumaypa aywacuran. Ichanga ñacar aywaycaptin pasinsan ushacaran. ");
INSERT INTO qub_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","Chaynami Tayta Diospa, Moisespa contran rimaran: «Cay chunyajcho wañunäpaj ¿imapätaj Egiptupita pushamarayqui? Caychöga manami canchu yacupis ni micuypis. ¡Gustuynaj micuyllata waran-waran micur pasaypa yamacashcäcunanami!» ");
INSERT INTO qub_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","Chaymi Tayta Diosga Israelcunaman cachamuran wañuchicoj culebracunata. Culebracuna cañiptinmi Israelcuna achca wañuran. ");
INSERT INTO qub_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","Chaymi paycunaga Moisés cajman aywaycur niran: «¡Tayta Diospa contran, gampa contrayqui parlashäpita juchayojmi caycäcuna. Tayta Diosta mañacuycuy ari nogacunapita chay culebracunata illgächinanpaj!» Chayno niptinmi Moisesga Tayta Diosta mañacuran Israelcunapaj. ");
INSERT INTO qub_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","Tayta Diosna niran: «Chay culebra-nirajta runsipita ruray. Nircur gueru puntanman bandëranqui. Culebra cañiycuptenga runsi culebraman ricärichun. Chayno ricärerga manami wañongachu.» ");
INSERT INTO qub_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","Chayno niptin Moisesga culebra-nirajta runsipita ruraran. Nircur gueru puntanman bandëraran. Chaymi culebra cañiycuptenga juclla runsi culebraman ricärej. Chauraga runacuna manami wañojnachu. ");
INSERT INTO qub_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","Chaypitanaga Israelcuna aywar pachacuran Obotcho. ");
INSERT INTO qub_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","Obotpita päsarna pachacuran chunyaj Ije-abarimcho. Chay partiga caycan Moab nasyunman inti yagamunan läducho. ");
INSERT INTO qub_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","Chaypita aywacur pachacuran Zered ragracho. ");
INSERT INTO qub_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","Chaypita aywacurna pachacuran Arnón mayupa chimpancho. Arnón mayuga chunyajpami päsaycan. Chay mayumi raquiycan Amorreo nasyuntawan Moab nasyunta. ");
INSERT INTO qub_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","Israel Runacunata Guërracho Tayta Dios Yanapashan jutiyoj libruchöpis caynömi isquirbiraycan: «Sufá particho caycaj Vaheb marcapa päsaräcuna. Ragracunapa aywar Arnón mayupa päsaräcuna. ");
INSERT INTO qub_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","Yacullanpa aywar chayaräcuna Ar particama. Chay ragraga chayaraycan Moab nasyunpa lindancama» nir. ");
INSERT INTO qub_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","Arnón mayupita aywacur chayaran Beer pösucama. Chay yacu pösu caycajchömi Moisesta Tayta Dios niran: «Llapan Israelcunata shuntay yacuta upuchinäpaj.» ");
INSERT INTO qub_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","Chaycho yacuta tarirmi Israelcunaga cayno cantaran: «¡Pösupita yacu mana chaquiypa pashtamuchun! ¡Yacu pashtamushanpita cantay-llapa! ");
INSERT INTO qub_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","¡Chay pösutaga mandajcunami ojtiran! ¡Rispitädu mayur runacunami bastunnincunawan uchcuran!» Chay chunyajpita aywacur Israelcuna chayaran Matana partimanna. ");
INSERT INTO qub_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","Matanapita aywacur chayaran Nahalielman. Nahalielpita aywar chayaran Bamotman. ");
INSERT INTO qub_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","Bamotpita aywar chayaran Moab nasyuncho caycaj chunyaj pampaman. Chayga caran Pisga puntapa chaquinna. Pisga puntapitaga intëru chunyaj alayrimi ricacaj. ");
INSERT INTO qub_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","Chaypitanami Israelcuna cachata cacharan Amorreo nasyunpa raynin Sehonman. Cacha aywar niran: ");
INSERT INTO qub_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","«Nasyunnillayquipa päsacuycushaj ari. Manami yaycushäcunachu micuyniqui jananpa, ni übas chacrayquicunamanpis. Pösuyquicunapita manami yacutapis upushäcunachu. Jatun nänillanpami päsacushaj.» ");
INSERT INTO qub_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","Chayno niptinpis ray Sehonga mana munaranchu Israelcuna nasyunninpa päsananta. Chaymi llapan suldäruncunata shuntarcur chunyajman aywaran. Jahazacho tincur Israelcunata magaran. ");
INSERT INTO qub_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","Jina cajtami Israelcunaga ticrapar binsiran. Binsiycur chacrancunatapis charicarcäriran Arnón mayupita-pacha Jaboc mayucama. Amón nasyunpa lindancamana tiyacaycäriran. Amón runacunapa lindan sumaj sigurasha captinmi Israelcuna mana päsaranchu. ");
INSERT INTO qub_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","Amorreo runacunapa siudänincunata charicarcärirmi tiyacaycäriran Hesboncho, marcancunachöpis. ");
INSERT INTO qub_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","Hesbón siudächöga tiyaran Amorreo runacunapa raynin Sehonmi. Moab nasyunpa unay caj rayninwan Sehonga amatarmi pillyasha caran. Chaymi chay partitaga Arnón mayucama guechuran. ");
INSERT INTO qub_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","Chaypitami cantajcuna cantashanpis cayno nin: «¡Shamuy-llapa Hesbonman! ¡Ray Sehonpa siudäninta allchay! ");
INSERT INTO qub_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","Sehonpa siudänin Hesbonpitami nina llojshiyta gallaycusha. Nircur ushasha Moabcho caycaj Ar particama. Ushasha Arnón mayupa altuncunatapis. ");
INSERT INTO qub_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","Fiyupa llaquicuymi casha gampäga Moab. Quemós diospa marcancho tiyajcuna, manami imata ruraytapis camäpacushcanquinachu. Quemós diosga chaycho tiyajcunatapis manami chapashachu. Warmicunatana ray Sehonpa munaynincho cananpaj suldärucuna apacuran. ");
INSERT INTO qub_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","«Hesbón siudäga pasaypami ushacasha. Wamracunapis wañusha Dibón particama, warmicunana Nofa particama, ollgucunana Medeba particama.» ");
INSERT INTO qub_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","Chaynöpami Israelcunaga Amorreo runacunapa chacrancunacho tiyacaycäriran. ");
INSERT INTO qub_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","Chaypita Moisesga runacunata cacharan Jazer siudäta ricapacamunanpaj. Nircur ñaupan siudäcunacho Amorreo runacuna tiyajtapis Israelcunaga llapanta garguran. ");
INSERT INTO qub_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","Chaypita Israelcuna cutiran Basanmanna. Chaymi Basanpa raynin Og-ga llapan suldäruncunawan Edreiman aywaran Israelcunawan pillyananpaj. ");
INSERT INTO qub_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","Chaura Moisesta Tayta Dios niran: «Chay runacunataga ama manchacuychu. Nogami yanapäshayqui llapan suldäruntinta binsinayquipaj, nasyunnintapis guechunayquipaj. Hesboncho tiyaj Amorreo runacunapa raynin Sehonta ushashayquinömi paycunatapis usharinquipaj.» ");
INSERT INTO qub_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","Chaynömi Tayta Dios nishannölla ray Ogta, wamrancunata, llapan suldäruncunatapis wañuchir Israel runacuna usharan. Manami pitapis cawaycajtaga cacharanchu. Nircurnami llapan chacrancunatapis charicarcäriran. ");
INSERT INTO qub_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","Israelcunaga sïguir aywashpan chayaran Moabcho caycaj pampaman. Chay pampaga caycaran Jericöpa chimpan, Jordán mayupa jucaj lädunpana. ");
INSERT INTO qub_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","Ziporpa wamran Balac mayaran Amorreo runacunata Israelcuna imano ushashantapis. ");
INSERT INTO qub_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","Chaymi Moab runacunapis fiyupa manchariran Israelcuna fiyupa aypallaj captin. ");
INSERT INTO qub_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","Chaynöpami Madiancho caj mayurcunata Moab runacunaga niran: «Chaychica runacunaga wäca guewata lagwaypa lagwar ushacurcojnöchari chacranchïtapis pishirachenga.» Chay wichanga Moabpa raynin caycaran Ziporpa wamran Balac. ");
INSERT INTO qub_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","Israel runacunata manchacushpanmi gayachiran Beorpa wamran Balaamta. Balaamga tiyaycaran Éufrates mayu läduncho caycaj Petorchömi. Chaychömi Amav runacuna tiyaycaran. Balaam cajman manaraj aywaptin cachancunataga Balac sumaj willaparan chayaycur cayno ninanpaj: «Egiptupita aypalla runacuna yargamurmi nogacuna tiyaycashä cajman juntajpaj chayamusha. ");
INSERT INTO qub_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","Ray Balac musyanshi pipis bindisyunta chasquinanpaj niptiqui bindisyunta chasquishanta, maldisyunasha cananpaj niptiquipis maldisyunädu cashanta. Chaymi ruwacushunqui juclla aywaycur chay runacunata maldisyunapänayquipaj. Maldisyunaptiquega chay runacuna aypalla captinpis binsishpä nasyunnëpita gargushämi.» ");
INSERT INTO qub_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","Chayno willaparcuptin Moabcho, Madiancho tiyaj mayurcunaga maldisyunapänanpaj guellayta apacarcärir Balaam cajman aywacuran. Chayaycorga Balac nishannölla llapanta willaparan. ");
INSERT INTO qub_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","Willaptin Balaam niran: «Canan chacayga cayllacho pachacuy. Warami willashayqui Tayta Dios imata nimashantapis.» Chaura Moab mayurcunaga Balaam cajllacho pachacuran. ");
INSERT INTO qub_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","Chay chacaymi Tayta Dios yuriparcur Balaamta tapuran: «¿Picunataj wasiquicho pachacaraycan?» ");
INSERT INTO qub_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","Chaura Balaam niran: «Moabpa raynin Ziporpa wamra Balacmi cachamusha. Paycuna willamasha ");
INSERT INTO qub_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","aypalla runacuna Egiptupita shamur intëru nasyunninman juntaycushanta. Chay runacunata maldisyunanätami Balac munaycan binsir nasyunninpita gargunanpaj.» ");
INSERT INTO qub_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","Niptinmi Balaamta Tayta Dios niran: «Ama aywaychu chay runacunawanga. Nasyunninman chayaj runacunatapis ama maldisyunaychu. Paycunataga nogami bindisyunta goshcä.» ");
INSERT INTO qub_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","Chaypita tutalla jatarcur Balaamga Balac cachashan runacunata niran: «Marcayquiman cuticuy. Tayta Dios manami munanchu gamcunawan aywanäta.» ");
INSERT INTO qub_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","Chayno niptin Moabpa mandajnincuna cutiran Balac cajman. Chayar niran: «Balaamga nogacunawan shamuyta manami munashachu.» ");
INSERT INTO qub_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","Chaura Balacga yapay cacharan waquin mayurcunatana mas achcajta, mas mandajcunata. ");
INSERT INTO qub_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","Paycunami Balaamman chayar niran: «Ziporpa wamran Balacmi ruwacushunqui. Aywaycushun ari tayta. ");
INSERT INTO qub_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","Chayaptiquega allishi pägashunquipaj. Imata munashayquitapis camaripäshunquipaj. Ichanga jucllashi aywaycushun chay runacunata maldisyunanayquipaj.» ");
INSERT INTO qub_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","Cachacuna chayno niptin Balaam niran: «Palasyuncho caycaj gorinta guellayninta Balac goycamaptinpis Tayta Diosnë mana munashantaga imatapis manami rurämanchu. ");
INSERT INTO qub_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","Imano captinpis canan chacayga caycho pachacuy. Mä imatashi yapay Tayta Dios nimanga.» ");
INSERT INTO qub_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","Chay chacaynami Balaamta yuriparcur Tayta Dios niran: «Chay runacuna pushashunayquipaj shamusha caycaptenga paycunawan ayway. Ichanga aywarpis noga nishallätami ruranqui.» ");
INSERT INTO qub_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","Balaam tutalla jatarcur bürrunta sillacurcur aywaran mayur Moab runacunawan. ");
INSERT INTO qub_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","Balaamga bürrun muntashami ishcaj uywaynincunata pushacurcur aywaran. Ichanga Tayta Dios fiyupa rabyaran Balaam aywashanpita. Chaymi nänicho anjilnin chaparan. ");
INSERT INTO qub_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","Tayta Diospa anjilnin sablin aptasha nänicho ichiraycajta ricärir bürruga nänipita juc-läpa aywacuran. Chaura Balaamga bürruta magaran näniman cutinanpaj. ");
INSERT INTO qub_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","Chay aywaycashan näniga päsaycaran übas chacra chaupillanpa. Ishcan lädunpa pergasha caycaran. Chaypita anjilga ichicuycuran quichquichöna. ");
INSERT INTO qub_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","Anjilta ricärir bürruga jucaj-lä pergaman guellicuycuran. Balaampa jucaj chancanta pergaman tincuraycachiran. Chaura bürrunta yapay magaran. ");
INSERT INTO qub_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","Chaypitana anjilga ñaupariycur fiyupa quichquinninman ichicuycuran. Chaychöga manami jäcurannachu bürru maypa päsananpäpis. ");
INSERT INTO qub_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","Anjilta ricärir bürruga jitacacuycuran. Chaura Balaamga fiyupa rabyar bürrunta gueruwan wiruran. ");
INSERT INTO qub_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","Chaymi Tayta Dios rimarachiptin bürruga Balaamta niran: «¿Gamtaga imanashcätaj? Cananwanga quimsa cutina magamanqui.» ");
INSERT INTO qub_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","Niptin Balaam niran: «Gamga pucllacaycämanquimi. Canan öra cuchillö captenga maynami wañurachïman.» ");
INSERT INTO qub_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","Chaura bürru niran: «Nogaga cä muntasha purinayqui bürruyquimi. Manami imaypis canannöga rurashcächu.» Niptin Balaam tantiyacushpan niran: «Rasunpami.» ");
INSERT INTO qub_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","Chay öra Tayta Dios camacächiran anjilta Balaam ricananpaj. Pullan nänicho anjil sablin aptasha ichiraycajta ricärir Balaamga gongurpacur cumuran urcunpis pampaman töpananyaj. ");
INSERT INTO qub_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","Tayta Diospa anjilnenga niran: «¿Imanirtaj quimsa cuti bürruyquita magashcanqui? Nogami aywaycashayqui nänichöga chapashcä mana alli yarpayniquiwan aywaptiqui. ");
INSERT INTO qub_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","Bürruyquega quimsan cutipis nogata ricamarmi juc-läpa witicusha. Chayno mana ruraptenga maynami gamta wañurachëman caran. Bürrullayquinami cawaycanman caran.» ");
INSERT INTO qub_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","Chaura Balaamga anjilta niran: «Nogaga juchatami rurashcä. Manami musyashcächu chapaycämashayquita. Aywanäta mana munaptiquega cuticushaj ari.» ");
INSERT INTO qub_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","Chaura Tayta Diospa anjilnin niran: «Chay runacunawan ayway. Ichanga noga nishallätami imatapis ninquipaj.» Chaypita Balacpa cachancunawan Balaam aywaran. ");
INSERT INTO qub_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","Balaam aywaycashanta musyaycur Balacga tariparan. Chayaran Moab nasyunpa lindan Arnón mayucama. ");
INSERT INTO qub_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","Balaamwan tincurcur Balacga niran: «Yaparir-yaparir gayaycächimuptë ¿imanirtaj shamuyta mana munashcanquichu? ¿Mana päganätachu yarpashcanqui?» ");
INSERT INTO qub_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","Balaamna niran: «Chayamushcänachaj. Ichanga quiquëpa yarpaynilläpita manami imatapis parlashächu. Nogaga rimashaj Tayta Dios tantiyachimashallantami.» ");
INSERT INTO qub_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","Parlarcur Balaamga Balacwan aywaran Quiriat-huzotman. ");
INSERT INTO qub_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","Chaychönami wäcacunata, uyshacunata Balac pishtachiran. Nircur aychataga Balaamman y paywan caycaj mayur runacunamanpis apachiran. ");
INSERT INTO qub_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","Warannin tutanami Balacga Balaamta pusharan Bamot-baal jircaman. Chay jircapitaga Israelcuna pachacaraycashan ricacaran. ");
INSERT INTO qub_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","Chaura Balaamga niran: «Caycho rurachipämay ganchis altarta chaycho ganchis wäcata, ganchis uyshata Tayta Diospaj rupachinäpaj.» ");
INSERT INTO qub_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","Chaymi Balaam nishanta Balacga rurachiran. Chaura cada altarcho Balacwan Balaam rupachiran juc töru-mallwata y juc uyshata. ");
INSERT INTO qub_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","Nircur Balaamga Balacta niran: «Gamga cayllacho shuyaycämay. Nogana mä aywashaj Tayta Dioswan tincoj. Cutimurna willashayqui imata nimashantapis.» Balaamga chunyaj puntaman aywaran. ");
INSERT INTO qub_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","Chaycho Tayta Dios yuriparan. Yuripaptin Balaam niran: «Ganchis altarta ruraycurmi cada-ünuncho rupachishcä juc töru-mallwapa aychantawan juc carnipa aychanta.» ");
INSERT INTO qub_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","Chayno niptin Balaamtaga Tayta Dios willaparan imata rimananpäpis. Nircur Balaamta niran: «Balac cajman cutiycur ninqui rimanayquipaj nishänölla.» ");
INSERT INTO qub_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","Cutir Balacta tariran uywacunata rupaycächishanpa ñaupancho ichiraycajta. Chaycho Balacga caycaran Moab nasyunpa mandajnincunawan iwal. ");
INSERT INTO qub_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","Chaura Balaamga imano cananpäpis niran: «Moabpa raynin Balacga Arampita-pachami gayachimasha. Inti yagamunan cajpitami pushachimasha ‹Israelcunata maldisyunapämay. Jacobpita mirajcuna ushacänanpaj rimaycuy› nir. ");
INSERT INTO qub_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","Ichanga ¿imanöpataj nogaga maldisyunashaj Tayta Dios mana munaycaptenga? ¿Imanöpataj mana alli cananpaj rimashaj Tayta Dios mana niycaptenga? ");
INSERT INTO qub_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","Cay puntapitami paycunata ricaycä. Cay jircapitami imano cashantapis tantiyacuycä. Paycunaga shuynimi tiyacurcaycan. Waquin nasyun runacunamanga manami tallucanchu. ");
INSERT INTO qub_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","Jacobpita mirajcunaga ñuchu allpano aypallami caycan. ¿Piräshi yuparpis atipanman? ¿Aycaj cashantapis piräshi musyanman? ¡Tayta Dios munashanno cawaj runacunano nogapis cawäman! ¡Paycunano nogapis wañuyta tarëman!» ");
INSERT INTO qub_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","Chayno niptinmi Balaamta Balacga niran: «¿Imatataj niycanqui? Gamtaga gayachimushcä conträcunata maldisyunapämänayquipämi. Nishä gamga bindisyuntami goycanqui.» ");
INSERT INTO qub_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","Chaura Balaam niran: «Gamtaga nirä Tayta Dios rimachimashallanta rimanäpämi.» ");
INSERT INTO qub_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","Chayno niptin Balac niran: «Juc-läman aywashun. Chaypitaga Israelcuna tiyarcaycashan cantuncunallatami ricanquipaj. Intërutaga manami ricanquipächu. Chaypita chay runacunata maldisyunapaycamay ari.» ");
INSERT INTO qub_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","Chaymi Balaamtaga Balac pusharan Pisga puntacho caycaj Zofim partiman. Chaychöna ganchis altarta rurarcur cada altarcho rupachiran juc wäca aychata, juc uysha aychata. ");
INSERT INTO qub_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","Chaycho Balacta Balaam niran: «Cay altarcuna caycashallancho shuyaycämay. Nogana aywashaj Tayta Dioswan parlaj.» ");
INSERT INTO qub_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","Aywaptin Balaamta Tayta Dios yuriparan. Nircur imata rimananpäpis willaparan. Chaypita niran: «Balac cajman cutiycur willanqui noga willapashalläta.» ");
INSERT INTO qub_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","Chayno niptin cutiycur Balaamga tariran Balacta y Moabpa mandajnincunata uywacuna rupaycashan altarcuna ñaupancho ichirpaycajta. Chayaptin Balac tapuran: «¿Ima nisha-cashunquitaj Tayta Dios?» nir. ");
INSERT INTO qub_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","Chaura Balaamga Tayta Dios rimachishanta rimaran: «Ziporpa wamran Balac, nishäta sumaj wiyay. ");
INSERT INTO qub_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","Tayta Diosga manami runacunanöchu. Payga manami llullacunchu. Imata aunircurpis manami cutiricunchu. Aunishantaga cumlinmi. ");
INSERT INTO qub_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","Tayta Dios nimasha bindisyunta gonäpämi. Tayta Dios bindisyunta goycaptenga ¿imanöpataj maldisyunashaj? ");
INSERT INTO qub_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","Jacobpita mirajcunataga Tayta Dios manami maldisyunayta munanchu. Payga manami munanchu Israel runacunata disigrasya päsananta. Israel runacunataga Tayta Diosmi yanapaycan. Paymi raynin caycan. ");
INSERT INTO qub_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","Egiptupita jorgamoj Tayta Diosmi paycunataga yanapaycan. Payga pogusha törunöpis callpayojmi caycan. ");
INSERT INTO qub_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","Jacob castacunata maldisyunashapis manami chayanchu. Chay Israelcunata brüjushapis manami chayanchu. Cananpitaga Israelcunata niypaj: ‹Tayta Diosga gamcunapaj achca milagrutami rurasha.› ");
INSERT INTO qub_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","Chay runacunaga liyunno manchacuypämi caycan. Liyun imatapis micunanpaj chariycur yawarninta upur-raj jamashannömi Israelcunapis contrancunata binsiycur-raj jaman.» ");
INSERT INTO qub_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","Chayno niptin Balaamta Balac niran: «¡Chay runacunata maldisyunayta mana camäpacorga bindisyuntapis ama goychu!» ");
INSERT INTO qub_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","Chaymi Balaam niran: «Gamtaga ¿manachu willaräna Tayta Dios rimachimashallanta ninäpaj cashanta?» ");
INSERT INTO qub_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","Chaura Balacga Balaamta niran: «Chayno captenga juc-läman aywashun. Chaypita maldisyunapämaptiquega capaschari Tayta Dios mana rabyacongachu.» ");
INSERT INTO qub_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","Chayno nir Balacga Balaamta pusharan Peor puntaman. Chaypitaga intëru chunyajmi ricacan. ");
INSERT INTO qub_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","Chaychöpis Balacta Balaam yapay niran: «Caycho ganchis altarta rurachiy. Nircur apamuy ganchis töruta, ganchis carnita rupachinapaj.» ");
INSERT INTO qub_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","Balaam chayno niptin Balacga llapanta ruraran. Nircorga cada altarcho rupachiran juc töru aychata, juc uysha aychata. ");
INSERT INTO qub_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","Balaamga musyaranna Israelcunata Tayta Dios bindisyunta gonanpaj cashanta. Chaymi musyaj aywanyashannöga mana aywarannachu. Chaypa ruquenga chunyajllapana ricäriran. ");
INSERT INTO qub_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","Chaura Israelcunataga ricaran cada trïbu shuyni-cama tiyaycajta. Tayta Diospa Espiritunpa munaynincho ricacurna ");
INSERT INTO qub_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","Balaamga imano cananpäpis cayno rimaran: «Beorpa wamran Balaammi cä. Imano cananpaj cajtapis Tayta Dios musyachimaptinmi rimaycä. ");
INSERT INTO qub_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","Munaynincho Tayta Dios ricacachimaptinmi llapantapis ricä. Nogataga munayniyoj Tayta Diosmi musyachiman, ribilaman. ");
INSERT INTO qub_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","¡Jacobpita mirajcuna, tolduyquicuna cuyayllapämi! ¡Israelcuna, tiyarcaycashayquega cuyayllapaj camarajllami! ");
INSERT INTO qub_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","Palma yöracuna fïlayllanpa ichiraycajnömi ricacan. Mayu cantuncho wertata Tayta Dios lantashanno caycan. ¡Yacu cantuncho sedru guerucuna caycajnömi caycan! ");
INSERT INTO qub_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","Israelcuna upunanpaj, micuynincunata pargunanpaj yacuga manami pishengachu. Paycunapa raynenga Agagta binsengami. Munayniyoj cashantapis intëruchömi musyanga. ");
INSERT INTO qub_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","Egiptupita jorgamoj Tayta Diosmi paycunataga yanapan. Chay runacunapäga Tayta Diosmi callpayoj pogusha törunöpis caycan. Israelcunaga contran caj nasyuncunata ushangami. Tulluncunatapis paquengami. Lëchancunawan illaparmi wañuchenga. ");
INSERT INTO qub_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","Liyun cäsata charinanpaj llupucuycojnömi caycan. Pipis rimapayta manchacunmi. ¡Israelcuna, gamta bindisyunta goshojcunataga Tayta Diospis bindisyuntami gonga! ¡Maldisyunta goshojcunatami ichanga maldisyunanga!» ");
INSERT INTO qub_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","Balaam chayno nejta wiyaycur Balacga fiyupa rabyacurcuran. Chaymi maquitapis jitapar-raj niran: «¡Gamtaga pushachimushcä conträcunata maldisyunapämänayquipämi! ¡Nishä cananwanga quimsa cutinami bindisyunta goshcanqui! ");
INSERT INTO qub_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","¡Manaraj imapis cashancama wasiquiman cuticuy! Gamtaga ima-aycatapis goycunämi caran. Ichanga Tayta Diosmi mana camacächishachu.» ");
INSERT INTO qub_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","Chaura Balaam niran: «Cachayqui shamojcunataga maynami willarä: ");
INSERT INTO qub_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","‹Palasyuncho goriwan guellay caycajta ushajpaj goycamaptinpis Tayta Diosnë mana munashantaga imatapis manami rurashächu. Allita ni mana allitapis quiquilläpitaga manami rurashächu. Nogaga rimashaj Tayta Dios rimachimashallantami› nir. ");
INSERT INTO qub_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","Nogaga marcämannami cuticö. Ichanga manaraj cuticurmi willashayqui chay Israel runacuna nasyunniquicho imano rurananpaj cashantapis.» ");
INSERT INTO qub_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","Chaura Balaamga imanöpis cananpaj cajta niran: «Beorpa wamran Balaammi cä. Imano cananpaj cajtapis Tayta Dios musyachimaptinmi rimaycä. ");
INSERT INTO qub_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","Munaynincho Tayta Dios ricacachimaptinmi llapantapis ricä. Tayta Dios rejsishantami rejsë. Munayniyoj Tayta Dios ribilamaptin llapanta musyä. ");
INSERT INTO qub_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","Shamoj watacunacho imapis päsananpaj cajtami ricaycä. Carucho caycämojtami ricaycä. Jacobpa mirayninpitami juc goyllar llojshenga. Ricaycä Israelcho juc ray yurejtapis. Paymi Moab runacunataga umanpita llapirenga. Setpita mirajcunatapis ushajpaj wañuchenga. ");
INSERT INTO qub_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","Edom runacunataga binsengami. Contran caj Seircunatapis charicurcongami. Israelcunaga rurangapaj pipis mana rurashantami. ");
INSERT INTO qub_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","Jacobpita mirajcunapitami munayniyoj runa yurimonga. Siudäcunacho quëdajcunatapis illgächengami.» ");
INSERT INTO qub_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","Chayno niycashanpita Balaamga ricäriran Amalec nasyunpa. Chay nasyun imano cananpäpis cayno niran: «Amalec runacunaga cay pachacho fiyupa munayniyojmi carcaycan. Chaypis ushajpämi illganga.» ");
INSERT INTO qub_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","22","Queni runacuna tiyashan-lädupapis ricärir imano cananpäpis cayno niran: «Pacacunayqui sumaj caycaptinpis, gaga chaupincunacho pacacunayqui caycaptinpis, nina ratarir rupangami Asiriacuna prësu apashuptiqui.» ");
INSERT INTO qub_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","Chaypita mastapis imano cananpäpis cayno niran: «¡Ay Tayta! ¿Pinaraj tiyanga Tayta Dios chayno manchariypaj ruraycuptenga? ");
INSERT INTO qub_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","Lamar chaupin Chipre tishgupitami büquicunawan runacuna shamonga. Asiria nasyuncho caj marcacunata ragällantami cachayconga. Heber runacunatapis pasaypami ushacächenga.» ");
INSERT INTO qub_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","Chaypitaga Balaam wasinman cuticuran. Balacpis aywacuran. ");
INSERT INTO qub_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","Israelcunaga Sitimcho tiyar Moab warmicunawan cacuran. ");
INSERT INTO qub_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","Chay warmicunaga Israelcunata pusharan diosnincunata adurar uywata pishtashancunaman. Chaura Israelcunapis Moab runacuna diosnincunapaj churashan micuyta micöshiran, aduräshiran. ");
INSERT INTO qub_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","Chayno rurarmi Baal-peorta aduraran. Chaymi Tayta Diosga Israelcunapaj fiyupa rabyacurcuran. ");
INSERT INTO qub_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","Chaura Tayta Diosga Moisesta niran: «Israelcunapa mandajnincunata prësu charircur nogapa ñaupächo llapan runa ricay wañuchiy. Chayrämi Israelcunapaj fiyupa rabyaycashä päsanga.» ");
INSERT INTO qub_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","Chaura Moisesna Israelcunapa jueznincunata niran: «Baal-peorta aduraj aywaj famillyayquicunata quiquiquicuna wañuchiy.» ");
INSERT INTO qub_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","Chayno niptinmi llapan Israelcuna Tincuna Toldu puncucho wagarcaycaran. Chay örami Moisespis waquin runacunapis ricaycaptin juc Israel runa mana pengacuypa Madián warmita toldunman pushasha yaycarachiran. ");
INSERT INTO qub_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","Chayta ricar, cüra Aaronpa willcan Finees Eleazarpa wamranga fiyupa rabyashpan shuntacasha carcaycashanpita tucsicunanta aptacurcur ");
INSERT INTO qub_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","aywaran Madián warmita apajpa guepanta toldun ruricama. Yaycurir ishcanta pachapa tucsiycuran. Chayrämi fiyu gueshyawan Israelcuna wañuycashanpita chawaycuran. ");
INSERT INTO qub_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","Chay fiyu gueshyawanga ishcay chunca chuscun warangana (24,000) runacuna wañuran. ");
INSERT INTO qub_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","Chaypitana Moisesta Tayta Dios niran: ");
INSERT INTO qub_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","«Cüra Aaronpa willcan Finees Eleazarpa wamranmi Israelcunapaj fiyupa rabyaycashäta päsachisha. Paypis noganömi juchata ruraj runacunapäga fiyupa rabyan. Juchayoj runata wañuchishanpitami nogapis Israelcunata ushajpäga mana wañuchishcächu. ");
INSERT INTO qub_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","Cananga Fineesta willay. Paywanga conträtutami rurashaj alli ricanäpaj. ");
INSERT INTO qub_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","Chaymi quiquinta, paypita mirajcunata imaycamapis cüra cananpaj churä. Nogata rispitamar chay juchayoj runata wañuchishanpitami Israel runacunapa juchancunataga perdunashcä.» ");
INSERT INTO qub_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","Madián warmitawan wañuchishan runapa jutenga caran Zimri. Payga caran Salupa wamran, Simeón trïbupa mandajnin. ");
INSERT INTO qub_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","Madián warmipa jutenga caran Cozbi. Pay caran Zurpa wamran. Paynami caran Madián runacunacho juc mandaj. ");
INSERT INTO qub_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","Chaypitana Moisesta Tayta Dios niran: ");
INSERT INTO qub_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","«Yaycuycur llapan Madián runacunata wañuchiy. ");
INSERT INTO qub_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","Paycunami engañashushpayqui shacyächishurayqui Baal-peorta aduranayquicunapaj. Madián runacunata mandajpa wamran Cozbipis mana pengacuypami llapan ricay Zimripa toldunman yaycusha paywan cacunanpaj. Chay warmitami wañuchisha Israel runacunata fiyu gueshyawan wañuycächishä öra.» ");
INSERT INTO qub_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","Fiyupa wañuchicoj gueshya cashanpitaraj Tayta Diosga Moisesta, cüra Aaronpa wamran Eleazarta niran: ");
INSERT INTO qub_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","«Llapan Israelcunata sinsuy, castanpa-cama shuyni-cama juctapis mana cachaypa ishcay chunca watayojpita janaman guërrapaj alli cajllata.» ");
INSERT INTO qub_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","Chaura Eleazarwan Moisesga Moab ragra aywaj pampacho llapan Israelcunata willaparan. Chay pampaga caycan Jericöpa chimpan Jordán mayupa jucaj lädunpami. ");
INSERT INTO qub_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","Willaparan ishcay chunca watayojpita janaman cäga Moisesta Tayta Dios nishanno llapan sinsucunanpaj. Egiptupita llojshicamoj Israelcunaga caran caycunami: ");
INSERT INTO qub_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","Israelpa mayur wamran Rubenpita mirajcunaga caran: Enoc casta, Falú casta, ");
INSERT INTO qub_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","Hezrón casta, Carmi casta runacuna. ");
INSERT INTO qub_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","Sinsuptin Rubén trïbu runacunaga caran chuscu chunca quimsa waranga ganchis pachac quimsa chuncan (43,730). ");
INSERT INTO qub_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","Falüpa wamran caran Eliab. ");
INSERT INTO qub_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","Eliabpana wamrancuna caran: Nemuel, Datán, Abiram. Datanwan Abiramga Corëwan shuntacaycur Moisespa, Aaronpa, Tayta Diospa contran jatariran. Paycunaga mayur tantiyachej runacunami caran. ");
INSERT INTO qub_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","Chayno contran jatarishanpitami pachapa shimin quichacar Datanta, Abiramta, Corëtawan micucurcuran. Contran ricacoj cäga llapan wañuran. Ninana rupar ushacurcuran ishcay pachac pichga chuncan (250) runacunata. Chay runacuna wañuran waquin Israelcunapis ricacunanpämi. ");
INSERT INTO qub_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","Chayno Coré wañuptinpis wamrancunaga manami wañuranchu. ");
INSERT INTO qub_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","Simeón trïbu runacuna caran: Nemuel, Jamín, Jaquín, ");
INSERT INTO qub_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","Zera, Saúl casta runacuna. ");
INSERT INTO qub_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","Sinsuptin Simeón trïbu runacuna caran ishcay chunca ishcay waranga ishcay pachacnin (22,200). ");
INSERT INTO qub_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","Gad trïbu cajna caran Zefón, Hagui, Suni, ");
INSERT INTO qub_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","17","Ozni, Eri, Arod, Areli casta runacuna. ");
INSERT INTO qub_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","Sinsuptin Gad trïbu runacuna caran chuscu chunca waranga pichga pachacnin (40,500). ");
INSERT INTO qub_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","Judäpa wamrancuna Erwan Onanga Canaán nasyunllachönami mas unay wañuran. ");
INSERT INTO qub_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","Chaura Judá trïbu runacunaga caran Sela, Fares, Zera castacuna. ");
INSERT INTO qub_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","Farespita mirajcunaga caran Hezrón, Hamul casta runacuna. ");
INSERT INTO qub_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","Sinsuptin Judá trïbu runacuna caran ganchis chunca sojta waranga pichga pachacnin (76,500). ");
INSERT INTO qub_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","Isacarpita mirajcuna caran Tola, Fúa, ");
INSERT INTO qub_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","Jasub, Simrón casta runacuna. ");
INSERT INTO qub_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","Sinsuptin Isacar trïbu runacuna caran sojta chunca chuscu waranga quimsa pachacnin (64,300). ");
INSERT INTO qub_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","Zabulonpita mirajcuna caran Sered, Elón, Jahleel casta runacuna. ");
INSERT INTO qub_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","Sinsuptin Zabulón trïbu runacuna caran sojta chunca waranga pichga pachacnin (60,500). ");
INSERT INTO qub_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","Josëpita mirajcuna caran Manasés trïbu runacuna, Efraín trïbu runacuna. ");
INSERT INTO qub_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","Manasespita mirajcuna caran Maquir casta, Maquir castapitana Galaad casta, ");
INSERT INTO qub_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","Galaadpita mirajcuna Jezer casta, Helec casta, ");
INSERT INTO qub_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","Asriel casta, Shequem casta, ");
INSERT INTO qub_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","Semida casta, Hefer casta. ");
INSERT INTO qub_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","Heferpa wamranna caran Zelofehad. Paypaga manami caranchu ollgu wamrancuna. Warmilla wamrancuna caran. Jutin caran: Maala, Noa, Hogla, Milca, Tirsa. ");
INSERT INTO qub_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","Sinsuptin Manasés trïbu runacuna caran pichga chunca ishcay waranga ganchis pachacnin (52,700). ");
INSERT INTO qub_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","Efrainpita mirajcunaga caran Sutela casta, Bequer casta, Tahán casta runacuna. ");
INSERT INTO qub_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","Sutelapita mirajcuna caran Erán casta runacuna. ");
INSERT INTO qub_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","Sinsuptin Efrainpita mirajcuna caran quimsa chunca ishcay waranga pichga pachacnin (32,500) runacuna. Chaynömi Josëpita mirajcunaga cada casta caran. ");
INSERT INTO qub_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","Benjaminpita mirajcuna caran Bela, Asbel, Ahiram, ");
INSERT INTO qub_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","Sefufam, Hufam castacuna. ");
INSERT INTO qub_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","Bela casta runacuna caran: Ard, Naamán castacuna. ");
INSERT INTO qub_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","Sinsuptin Benjamín trïbu runacuna caran chuscu chunca pichga waranga sojta pachacnin (45,600). ");
INSERT INTO qub_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","Danpita mirajcuna caran Súham casta. ");
INSERT INTO qub_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","Sinsuptin Súham casta caran sojta chunca chuscu waranga chuscu pachacnin (64,400). ");
INSERT INTO qub_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","Aserpita mirajcuna caran Imna, Isúi, Bería castacuna. ");
INSERT INTO qub_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","Bería castapita mirajna caran Heber, Malquiel casta runacuna. ");
INSERT INTO qub_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","Aserpa warmi wamranpa jutin caran Sera. ");
INSERT INTO qub_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","Sinsuptin Aser trïbu runacuna caran pichga chunca quimsa waranga chuscu pachacnin (53,400). ");
INSERT INTO qub_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","Neftalïpita mirajcuna caran Jahzeel, Guni, ");
INSERT INTO qub_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","Jezer, Silem casta runacuna. ");
INSERT INTO qub_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","Sinsuptin Neftalí trïbu runacuna caran chuscu chunca pichga waranga chuscu pachacnin (45,400). ");
INSERT INTO qub_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","Sinsuyta ushaycur yupaptin Israel trïbu runacuna caran sojta pachac juc warangan ganchis pachac quimsa chuncan (601,730). ");
INSERT INTO qub_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","Moisesta Tayta Dios niran: ");
INSERT INTO qub_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","«Sinsuptiqui cada trïbu aycapis cashan-tupu chacrataga raquipanqui. ");
INSERT INTO qub_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","Achca runacuna captin mas jatunta raquipanqui. Wallca runacuna captenga tacshata raquipanqui. Cada trïbuta raquipanqui sinsucho apuntacushanman-tupu. ");
INSERT INTO qub_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","Maycho chacran cananpäpis chacrataga surtiyaypa raquipanqui. Runacunaga chacrata chasquenga taytan maygan trïbupis cashanchömi. ");
INSERT INTO qub_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","Chacrataga achcaj captinpis wallcaj captinpis surtiyarcur surtiyarcurmi raquipanqui.» ");
INSERT INTO qub_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","Leví trïbuta sinsur yuparan Gersón, Coat, Merari castacunata. ");
INSERT INTO qub_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","Levïpita mirajcunallami caran Libni, Hebrón, Mahli, Musi, Coré castacunaga. Coatpa wamranmi caran Amram. ");
INSERT INTO qub_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","Amram majachacaran Jocabedwan. Jocabedpis Leví trïbu warmimi caran. Payga Egiptuchömi yuriran. Amrampawan Jocabedpa wamranmi caran Aarón, Moisés, María. ");
INSERT INTO qub_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","Aaronpa wamrancunana caran Nadab, Abiú, Eleazar, Itamar. ");
INSERT INTO qub_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","Nadabwan Abiüga wañuran Tayta Diospaj juc-niraj saumachishanpitami. ");
INSERT INTO qub_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","Leví trïbu runacunaga juc quillayojpita janaman caran ishcay chunca quimsa warangan (23,000). Paycunataga manami sinsuranchu Israelcunata sinsur. Leví trïbutaga manami chacratapis raquiparanchu. ");
INSERT INTO qub_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","Moiseswan cüra Eleazar sinsuptin Israel runacunaga caycaran Moab pampachömi. Moab pampaga Jericöpa chimpan Jordán mayupa jucaj lädunpami caycan. ");
INSERT INTO qub_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","Aaronwan Moisés chunyaj Sinaïcho sinsushan runacunaga manami ni jucnayllapis carannachu. ");
INSERT INTO qub_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","Chunyaj Sinaí jircacho sinsushan runacunaga Tayta Dios nishannöllami chunyajcho llapanpis wañur ushacaran. Chaymi mayganpis mana carannachu guepa caj sinsucuypäga. Jefonepa wamran Calebwan Nunpa wamran Josuëllanami cawaycaran. ");
INSERT INTO qub_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","Manasés trïbucho caran chay ñañalla pichgaj warmicuna. Paycunapa jutincuna caran Maala, Noa, Hogla, Milca, Tirsa. Paycuna caran Zelofehadpa wamran. Zelofehadna caran Heferpa wamran; Heferna Galaadpa wamran; Galaadna Maquirpa wamran; Maquirna Manasespa wamran; Manasesna Josëpa wamran. ");
INSERT INTO qub_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","Chay warmicunami aywaran Tincuna Toldu ñaupanman Moiseswan cüra Eleazarwan, waquin mandajcunawanpis parlaj. Chayaycur cayno niran: ");
INSERT INTO qub_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","«Chunyajcho carcaycashallanami papänëga wañusha. Payga manami Corëwan Tayta Diospa contran cashanpitachu wañuran, man'chäga guepatarämi quiquinpa juchanpita. Papänëpaga manami ollgu wamran cashachu. ");
INSERT INTO qub_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","Chayno wañusha captinpis papänëpa jutenga manami gongacanmanchu waquin caj famillyacunachöga ollgu wamran mana cashallanpitaga. Jutin mana illgänanpaj papänëpa castancunata chacrata raquipashayqui cajcho nogacunatapis raquipämay.» ");
INSERT INTO qub_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","Chayno warmicuna ruwacushanta Moisesga Tayta Diosta willaran. ");
INSERT INTO qub_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","Chaura Tayta Dios niran: ");
INSERT INTO qub_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","«Zelofehadpa wamrancunaga allitami yarpaycan. Papäninpa wauguincunata aypushan ñaupancunallapa paycunatapis chacrata raquipay. Chaynöpami papäninpa ruquin chacrata chasquenga. ");
INSERT INTO qub_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","Israel-masiquicunatapis willapay. Pipis ollgu wamran mana caycaptin wañuptenga warmi wamranpämi canga ima-aycanpis. ");
INSERT INTO qub_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","Jucnayllapis wamran mana captinmi ichanga ima-aycanwanpis wauguincunana quëdanga. ");
INSERT INTO qub_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","Wauguincuna mana captenga papäninpa wauguincunapäna ima-aycantapis cachayconga. ");
INSERT INTO qub_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","Papäninpapis wauguin mana casha captenga chacrancunata cachayconga lijïtimu famillyancunapaj. Cay nishäga gamta nishänöllami llapan Israelcunapaj juc lay canga.» ");
INSERT INTO qub_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","Moisesta Tayta Dios niran: «Cay Abarim puntaman wichämuy. Caypitami ricanqui Israelcunata goycunäpaj caycaj partita. ");
INSERT INTO qub_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","Chaypita ricaycullarnami wañucunquipaj. Wañucorga wauguiqui Aaronnöpis ñaupa wañoj caj famillyayquicunawan tincojna aywacunquipaj. ");
INSERT INTO qub_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","Gamga Zin chunyajchömi wauguiquiwan ishcaniqui nishäta mana rurarayquichu. Zincho Israelcuna yacuta mañacur conträ rimaptinpis gamcunaga manami rispitamarayquichu.» (Chayno caran Cadescho caycaj Meriba pucyuchömi. Chayga Zin chunyajchömi caycan.) ");
INSERT INTO qub_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","Moisesna Tayta Diosta niran: ");
INSERT INTO qub_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","17","«Tayta Dios gammi canqui pï-maytapis cawachej. Cananga juc mandajta churay acrashayqui runacunata maypapis pushananpaj. Chaura manami uyshëruynaj uyshano mashtacashaga purengachu.» ");
INSERT INTO qub_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","Niptin Tayta Diosga niran: «Nunpa wamran Josuëmi alli runa. Paypa umanman maquiquita churay acrashä musyacänanpaj. ");
INSERT INTO qub_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","Chaynöpis cüra Eleazarman, llapan runacunaman pushay. Paycunapa ñaupancho churanqui ruquiqui mandaj cananpaj. ");
INSERT INTO qub_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","Munayniquita waquinta Josuëta cachapay paytana llapan Israelcuna wiyacunanpaj. ");
INSERT INTO qub_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","Josuëga tapucamayta munar aywanga cüra Eleazarman. Eleazarnami Josuëpa jutincho tapucamanga Urim rumiwan. Chaura imano rurananpäpis Josuënami Israelcunata mandanga.» ");
INSERT INTO qub_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","Chaura Moisesga Tayta Dios nishanno ruraran. Chaymi llapan runacunapawan cüra Eleazarpa ñaupanman Josuëta pusharan. ");
INSERT INTO qub_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","Josuëpa uman jananman Moisesga maquinta churaran ruquin mandaj cananpaj. Chaynömi Moisesga Tayta Dios nishanno ruraran. ");
INSERT INTO qub_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","Chaypita Moisesta Tayta Dios niran: ");
INSERT INTO qub_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","«Israelcunata sumaj willapay. Rejsisha diyacunachöga mana gongaypa tanta ofrendata nogapaj churachun. Uywacunatapis mana gongaypa rupachichun jömuynin nogapa shongöpäno cananpaj. ");
INSERT INTO qub_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","«Chaynöpis ninqui waran-waran juc watayoj sänu ishcay cashnita rupachina sacrifisyupaj apamunanpaj. ");
INSERT INTO qub_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","Jucta tutapa pishtanga, jucta tardipa. ");
INSERT INTO qub_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","Uywata rupachir chaqui micuy ofrendatapis apamonga ishcay quïlu mas alli caj jarina litru olivo asëtiwan chapushata. ");
INSERT INTO qub_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","(Chaynömi Sinaí jircacho sacrifisyu uywacunata waran-waran rupachiran. Chay rupachishanpa jömuyninmi Tayta Diospa shongunpäno caran.) ");
INSERT INTO qub_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","Cada cashnita rupachinayquipäga canga juc litru bïnumi. Nogata rispitamar bïnutaga jichanga rispitädu cajman. ");
INSERT INTO qub_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","Jucaj cashnitanami tardipa pishtanga. Chaytapis tutapa rurashanno nogapaj churanga chaqui micuy ofrendata juc litru bïnuntawan. Rispitamar rupachishanpa jömuynin nogapäga shongöpänömi canga. ");
INSERT INTO qub_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","«Säbadu jamay junajcho gamcuna apamunqui ishcay sänu watayoj cashnita. Chaqui micuy ofrendata garamarna apamunqui chuscu quïlu mas allinnin jarinata asëtiwan chapushallata. Jananman bïnutapis garamanqui. ");
INSERT INTO qub_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","Säbadu jamay junajchömi chay uywataga bïnuntawan rupachinqui. Chayga canga waran-waran rupachina sacrifisyuta pishtashayquipa jananmanraj. ");
INSERT INTO qub_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","«Cada quillacho rimir junaj rupachina sacrifisyupaj pishtanqui sänu ishcay töru-mallwata, juc carnita, watayoj cashnitapis ganchista. ");
INSERT INTO qub_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","Cada töru-mallwapaj sojta quïlu alli caj jarinata asëtillawan chapushata garamanga. Carnipäna chuscu quïlu jarina asëtillawan chapushata garamanga. ");
INSERT INTO qub_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","Cada cashnipäna canga ishcay quïlu jarina asëtillawan chapusha. Chay rupachishayquimi jömuynin canga nogapa shongöpäno. ");
INSERT INTO qub_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","Bïnuga cada töru-mallwapaj canga ishcay litru, carnipäga litru medyan. Cada cashnipäna canga juc litru. Chaynömi cada quilla rimir junajchöga rupachinqui. ");
INSERT INTO qub_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","Waran-waran nogapaj rupachina sacrifisyuta pishtashayquipa jananmanpis juc chïbuta pishtanqui juchapita sacrifisyupaj. Chaypis canga bïnunwanmi. ");
INSERT INTO qub_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","«Wata gallarej quilla chunca chuscu (14) junajninchömi nogata rispitamar Pascua fistata ruranga. ");
INSERT INTO qub_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","Warannin chunca pichga (15) junäga fista gallayconga. Ganchis junajcama lebadüraynaj tantallata micunqui. ");
INSERT INTO qub_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","Gallarej junajchöga shuntacanqui jatun diya captin. Chay junäga pipis ama arongachu. ");
INSERT INTO qub_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","Rupachina sacrifisyupaj pishtanqui sänuta ishcay töru-mallwata, juc carnita, watayoj ganchis cashnita. ");
INSERT INTO qub_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","Chay pishtashayqui uywacunapa jananmanpis churanqui asëtillawan chapusha jarinata. Churanqui cada töru-mallwapaj sojta quïlu jarinata, chuscu quïlu jarinata cada carnipaj, ");
INSERT INTO qub_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","ishcay quïlu jarinata cada cashnipaj. ");
INSERT INTO qub_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","Juc chïbutapis pishtanqui juchayquicunapita perdunasha canayquipaj. ");
INSERT INTO qub_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","Chay sacrifisyucunataga churanqui waran-waran cada tuta rupachina sacrifisyuta rupachishayquipa jananmanraj. ");
INSERT INTO qub_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","Chaynölla waran-waran ruranqui ganchis junajyaj. Rispitamar rupachishayquipa jömuynenga nogapa shongöpänömi canga. Chay sacrifisyucunataga garamanqui bïnuntawan waran-waran cada tuta rupachina sacrifisyuta garamashayquipa jananmanraj. ");
INSERT INTO qub_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","Ganchis caj junajchöpis jamanqui-llapa jatun diya captin. Chay junäga ama arunquichu. ");
INSERT INTO qub_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","«Rimir cosëchata shuntar ‹Semäna fista› nishan fistata ruranqui. Chay fistacho rimir pogushan caj chaqui micuy ofrendata nogapaj churashpayquipis shuntacanqui jatun diya captin. Chay junäga pipis ama arongachu. ");
INSERT INTO qub_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","Rupachina sacrifisyupaj pishtanga ishcay töru-mallwata, juc carnita, watayoj ganchis cashnita. ");
INSERT INTO qub_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","Cada töru-mallwapaj churanqui asëtiwan chapusha sojta quïlu jarinata, carnipäna asëtiwan chapusha chuscu quïlu jarinata, ");
INSERT INTO qub_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","cada cashnipäna ishcay quïlu jarinata. ");
INSERT INTO qub_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","Juc chïbutapis pishtanqui juchayquicunapita perdunasha canayquipaj. ");
INSERT INTO qub_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","Rupachishayqui uywacunamanga churanqui chaqui micuy ofrendatapis bïnu ofrendatapis. Chayga canga waran-waran rupachishayquipa jananmanraj. Rupachinayquipaj caj uywacunaga sänu canga. ");
INSERT INTO qub_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","«Ganchis quillaman gallaycoj rimir junajcho gamcuna shuntacanqui jatun diya captin. Chay junäga ama arunquicunachu. Jatun diya cashanta trompëtacunata tucaypa willaconga. ");
INSERT INTO qub_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","Nogapa shongöpäno jömuynin cananpaj rupachina sacrifisyuta rupachinqui juc sänu töru-mallwata, juc carnita, watayoj ganchis cashnita. ");
INSERT INTO qub_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","Cada töru-mallwapaj churanqui sojta quïlu jarinata asëtiwan chapushata, carnipaj chuscu quïlu jarinata asëtiwan chapushata, ");
INSERT INTO qub_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","cada cashnipäna ishcay quïlu jarinata asëtiwan chapushata. ");
INSERT INTO qub_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","Juc chïbutapis pishtanqui juchayquicunapita perdunasha canayquipaj. ");
INSERT INTO qub_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","Rupachishayqui uywacunamanga churanqui chaqui micuy ofrendatapis bïnutapis. Chaycunata rupachinqui waran-waran, quillan quillan rupachina sacrifisyuta pishtashayquipa jananmanraj. Rispitamar rupachishayquipa jömuyninmi nogapa shongöpäno canga. ");
INSERT INTO qub_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","«Chay ganchis quillallacho, chunca junajchöpis shuntacanqui jatun diya captin. Llapaniqui ayunar goyanqui. Chay junäga ama arunquicunachu. ");
INSERT INTO qub_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","Nogapa shongöpäno jömuynin cananpaj rupachinqui sänu töru-mallwata, juc carnita, watayoj ganchis cashnicunata. ");
INSERT INTO qub_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","9","Churanqui töru-mallwapaj sojta quïlu jarinata, carnipaj chuscu quïlu jarinata, ");
INSERT INTO qub_vpl VALUES ("NU29_10","005_29_10","NUM","29","10","10","cada cashnipaj ishcay quïlu jarinata. ");
INSERT INTO qub_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","Chaynöpis juchapita sacrifisyupaj juc chïbuta altarcho rupachinqui. Chaycunataga Perdun tarina junaj y waran-waran rupachina sacrifisyuta churashayquipitapis shuyniraj rupachinqui. Tayta Dios nishannölla chaqui micuy ofrendatapis bïnutapis churanqui. ");
INSERT INTO qub_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","«Chay ganchis quillallacho, chunca pichga junajcho shuntacanqui jatun diya captin. Ama arunquichu. Chaypa ruquenga nogata aduramashpayqui ganchis junajcama fistata ruranqui. ");
INSERT INTO qub_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","Rimir junajchöga rispitamar rupachinqui sänuta chunca quimsa (13) töru-mallwata, ishcay carnita, watayoj cashnitana chunca chuscuta (14). Chay rupachishayquipa jömuynenga nogapa shongöpäno canga. ");
INSERT INTO qub_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","Cada töru-mallwata rupachir churanqui sojta quïlu jarinata asëtillawan chapushata, cada carnita rupachirpis chuscu quïlu jarinata asëtillawan chapushata, ");
INSERT INTO qub_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","cada cashnita rupachirpis ishcay quïlu jarinata asëtillawan chapushata. ");
INSERT INTO qub_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","Chaynöpis juchapita sacrifisyupaj juc chïbuta altarcho rupachinqui. Chaycunataga rupachinqui waran-waran rupachina sacrifisyuta rupachishayquipitapis, chaqui micuy ofrendatapis bïnutapis churashayquipita shuyniraj. ");
INSERT INTO qub_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","17","«Ishcay caj junajcho pishtanqui sänuta chunca ishcay (12) töru-mallwata, ishcay carnita, juc watayoj cashnita chunca chuscuta (14). ");
INSERT INTO qub_vpl VALUES ("NU29_18","005_29_18","NUM","29","18","18","Noga nishäno cada töru-mallwapaj, cada carnipaj, cada cashnipaj churanqui chaqui micuy ofrendata, bïnutapis. ");
INSERT INTO qub_vpl VALUES ("NU29_19","005_29_19","NUM","29","19","19","Juc chïbutapis pishtanqui juchapita sacrifisyupaj. Chaycunataga waran-waran rupachina sacrifisyuta churashayquipitapis shuyniraj rupachinqui. Tayta Dios nishannölla chaqui micuy ofrendatapis bïnutapis churanqui. ");
INSERT INTO qub_vpl VALUES ("NU29_20","005_29_20","NUM","29","20","20","«Quimsa caj junajcho pishtanqui sänuta chunca juc töru-mallwata, ishcay carnita, juc watayoj cashnita chunca chuscuta (14). ");
INSERT INTO qub_vpl VALUES ("NU29_21","005_29_21","NUM","29","21","21","Noga nishäno cada töru-mallwapaj, cada carnipaj, cada cashnipaj churanqui chaqui micuy ofrendata y bïnutapis. ");
INSERT INTO qub_vpl VALUES ("NU29_22","005_29_22","NUM","29","22","22","Juc chïbutapis pishtanqui juchapita sacrifisyupaj. Chaycunataga waran-waran rupachina sacrifisyuta churashayquipitapis shuyniraj rupachinqui. Tayta Dios nishannölla chaqui micuy ofrendatapis bïnutapis churanqui. ");
INSERT INTO qub_vpl VALUES ("NU29_23","005_29_23","NUM","29","23","23","«Chuscu caj junajcho pishtanqui sänuta chunca töru-mallwata, ishcay carnita, juc watayoj cashnita chunca chuscuta (14). ");
INSERT INTO qub_vpl VALUES ("NU29_24","005_29_24","NUM","29","24","24","Noga nishäno cada töru-mallwapaj, cada carnipaj, cada cashnipaj churanqui chaqui micuy ofrendata, bïnutapis. ");
INSERT INTO qub_vpl VALUES ("NU29_25","005_29_25","NUM","29","25","25","Juc chïbutapis pishtanqui juchapita sacrifisyupaj. Chaycunataga waran-waran rupachina sacrifisyuta churashayquipitapis shuyniraj rupachinqui. Tayta Dios nishannölla chaqui micuy ofrendatapis bïnutapis churanqui. ");
INSERT INTO qub_vpl VALUES ("NU29_26","005_29_26","NUM","29","26","26","«Pichga caj junajcho pishtanqui sänuta isgun töru-mallwacunata, ishcay carnicunata, juc watayoj cashnicunata chunca chuscuta (14). ");
INSERT INTO qub_vpl VALUES ("NU29_27","005_29_27","NUM","29","27","27","Noga nishäno cada töru-mallwapaj, cada carnipaj, cada cashnipaj churanqui chaqui micuy ofrendata, bïnutapis. ");
INSERT INTO qub_vpl VALUES ("NU29_28","005_29_28","NUM","29","28","28","Juc chïbutapis pishtanqui juchapita sacrifisyupaj. Chaycunataga waran-waran rupachina sacrifisyuta churashayquipitapis shuyniraj rupachinqui. Tayta Dios nishannölla chaqui micuy ofrendatapis bïnutapis churanqui. ");
INSERT INTO qub_vpl VALUES ("NU29_29","005_29_29","NUM","29","29","29","«Sojta caj junajcho pishtanqui sänuta pusaj töru-mallwacunata, ishcay carnicunata, juc watayoj cashnicunata chunca chuscuta (14). ");
INSERT INTO qub_vpl VALUES ("NU29_30","005_29_30","NUM","29","30","30","Noga nishäno cada töru-mallwapaj, cada carnipaj, cada cashnipaj churanqui chaqui micuy ofrendata, bïnutapis. ");
INSERT INTO qub_vpl VALUES ("NU29_31","005_29_31","NUM","29","31","31","Juc chïbutapis pishtanqui juchapita sacrifisyupaj. Chaycunataga waran-waran rupachina sacrifisyuta churashayquipitapis shuyniraj rupachinqui. Tayta Dios nishannölla chaqui micuy ofrendatapis bïnutapis churanqui. ");
INSERT INTO qub_vpl VALUES ("NU29_32","005_29_32","NUM","29","32","32","«Ganchis caj junajcho pishtanqui sänuta ganchis töru-mallwata, ishcay carnita, juc watayoj cashnita chunca chuscuta (14). ");
INSERT INTO qub_vpl VALUES ("NU29_33","005_29_33","NUM","29","33","33","Noga nishäno cada töru-mallwapaj, cada carnipaj, cada cashnipaj churanqui chaqui micuy ofrendata, bïnutapis. ");
INSERT INTO qub_vpl VALUES ("NU29_34","005_29_34","NUM","29","34","34","Juc chïbutapis pishtanqui juchapita sacrifisyupaj. Chaycunataga waran-waran rupachina sacrifisyuta churashayquipitapis shuyniraj rupachinqui. Tayta Dios nishannölla chaqui micuy ofrendatapis bïnutapis churanqui. ");
INSERT INTO qub_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","«Pusaj caj junajcho ichanga jatun diya captin llapayqui shuntacanqui. Ama arunquichu. ");
INSERT INTO qub_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","Nogapa shongöpäno jömuynin cananpaj rupachinqui sänuta juc töru-mallwata, juc carnita, juc watayoj ganchis cashnita. ");
INSERT INTO qub_vpl VALUES ("NU29_37","005_29_37","NUM","29","37","37","Noga nishäno cada töru-mallwapaj, cada carnipaj, cada cashnipaj churanqui chaqui micuy ofrendata, bïnutapis. ");
INSERT INTO qub_vpl VALUES ("NU29_38","005_29_38","NUM","29","38","38","Juc chïbutapis pishtanqui juchapita sacrifisyupaj. Chaycunataga waran-waran rupachina sacrifisyuta churashayquipitapis shuyniraj rupachinqui. Tayta Dios nishannölla chaqui micuy ofrendatapis bïnutapis churanqui. ");
INSERT INTO qub_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","«Chaycunataga churanqui nishä junajcunacho aunishayquita cumlir churashayquipita, shonguyqui shacyaptin churashayquipita, rupachina sacrifisyuta, chaqui micuy ofrendatawan bïnuta garamashayquipita, alli goyaypita sacrifisyuta garamashayquipitapis shuyniraj.» ");
INSERT INTO qub_vpl VALUES ("NU29_40","005_29_40","NUM","29","40","40","Tayta Dios nishancunata Moisesga juctapis mana gongaypa Israelcunata willaparan. ");
INSERT INTO qub_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","1","Israel trïbucunapa mandajnincunata shuntaycur Moisesga niran: «Tayta Diosmi nin: ");
INSERT INTO qub_vpl VALUES ("NU30_2","005_30_2","NUM","30","2","2","Pipis jurar imapäpis aunimarga cumlichun. Imata rurananpaj nimashantapis cumlichun. ");
INSERT INTO qub_vpl VALUES ("NU30_3","005_30_3","NUM","30","3","3","«Jipash papäninpa maquillanchöraj caycar nogata aunimashanta ");
INSERT INTO qub_vpl VALUES ("NU30_4","005_30_4","NUM","30","4","4","papänin musyar imatapis mana rimacuptenga aunimashanta imanöpapis cumlengana. ");
INSERT INTO qub_vpl VALUES ("NU30_5","005_30_5","NUM","30","5","5","Nogapaj imatapis aunishanta musyaycur papänin mana munaptenga aunishanta manami cumlenganachu. Papänin mana munaptenga nogapis manami cumlinanpaj obligashänachu. ");
INSERT INTO qub_vpl VALUES ("NU30_6","005_30_6","NUM","30","6","6","«Japallaraj caycar jipash sumaj mana yarpachacuypa nogata aunircamar majachacäcuptin ");
INSERT INTO qub_vpl VALUES ("NU30_7","005_30_7","NUM","30","7","7","aunimashanta musyaycar runan mana michaptenga aunishanta cumlengami. ");
INSERT INTO qub_vpl VALUES ("NU30_8","005_30_8","NUM","30","8","8","Nogapaj aunishanta musyaycur runan mana munaptinmi ichanga manana cumlenganachu. Nogapis manami cumlinanpaj obligashänachu. ");
INSERT INTO qub_vpl VALUES ("NU30_9","005_30_9","NUM","30","9","9","«Biyüda u raquicasha warmi aunimarga simri cumlinan. ");
INSERT INTO qub_vpl VALUES ("NU30_10","005_30_10","NUM","30","10","10","«Runayoj warmi imatapis aunimashanta ");
INSERT INTO qub_vpl VALUES ("NU30_11","005_30_11","NUM","30","11","11","runan musyaycur mana michaptenga aunishanta cumlenga. ");
INSERT INTO qub_vpl VALUES ("NU30_12","005_30_12","NUM","30","12","12","Nogapaj aunishanta musyaycur runan mana munaptenga warmi mananami cumlenganachu. Runan mana munaptenga manami cumlinanpaj obligashänachu. ");
INSERT INTO qub_vpl VALUES ("NU30_13","005_30_13","NUM","30","13","13","Chaymi warmi imatapis auniptin u ayunananpaj auniptin runanraj nenga cumlinanpaj cashanta u mana cumlinanpaj cashantapis. ");
INSERT INTO qub_vpl VALUES ("NU30_14","005_30_14","NUM","30","14","14","Aunishanta musyaycur warminta mana imatapis niyllapa ishcay quimsa junaj upällalla cacushpanga warmin aunishanta auniycanmi. ");
INSERT INTO qub_vpl VALUES ("NU30_15","005_30_15","NUM","30","15","15","Chaypitaraj mana munashpanga runannami juchayoj canga warmin aunishancunata mana cumliptin.» ");
INSERT INTO qub_vpl VALUES ("NU30_16","005_30_16","NUM","30","16","16","Chaynömi Moisesta Tayta Dios willaparan majayoj warmi imano cananpaj, papäninpa maquillanchöraj caycaj jipash imano cananpäpis. ");
INSERT INTO qub_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","Moisesta Tayta Dios niran: ");
INSERT INTO qub_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","«Madián runacunata ayñita cutichir wañuchiy Israelcunata juchata rurachishanpita. Chaypitarämi wañucunquipaj.» ");
INSERT INTO qub_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","Chaura Moisesga Israelcunata niran: «¡Waquinniquega pillyanayquipaj camaricuy-llapa! Nircorga Madián runacunata ayñita cutichir Tayta Diospa jutincho wañuchimuy. ");
INSERT INTO qub_vpl VALUES ("NU31_4","005_31_4","NUM","31","4","4","Cada trïbupita waranga (1,000) runacuna guërraman aywachun.» ");
INSERT INTO qub_vpl VALUES ("NU31_5","005_31_5","NUM","31","5","5","Chaynöpami cada trïbupita waranga-cama (1,000) acranacuran. Chaura pillyaman aywananpäga chunca ishcay waranga (12,000) runacuna caran. ");
INSERT INTO qub_vpl VALUES ("NU31_6","005_31_6","NUM","31","6","6","Chay runacunatanami Moisesga pillyaj cacharan. Paycunawanmi cüra Eleazarpa wamran Fineestapis cacharan. Paymi aywaran Tincuna Toldupita rispitädu bäsucunata apacurcur, trompëtacunata tucananpäpis apacurcur. ");
INSERT INTO qub_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","Madián runacunawan pillyar llapanta wañuycachiran Moisesta Tayta Dios nishannölla. ");
INSERT INTO qub_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","Chaychömi wañuchiran Madián runacunapa pichgan raynincunata. Chay raycuna caran Evi, Requem, Zur, Hur, Reba. Beorpa wamran Balaamtapis wañuchiran. ");
INSERT INTO qub_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","9","Israelcunaga prësu apacuran Madián warmicunata, tacsha wamrancunata. Llapan casta uywancunatapis bälej cösacunatapis apacuran. ");
INSERT INTO qub_vpl VALUES ("NU31_10","005_31_10","NUM","31","10","10","Jananmanpis rupaycachiran llapan siudänincunata, tiyashan wasincunatapis. ");
INSERT INTO qub_vpl VALUES ("NU31_11","005_31_11","NUM","31","11","11","Prësu apashancunata, guechushancunata, uywacunata ");
INSERT INTO qub_vpl VALUES ("NU31_12","005_31_12","NUM","31","12","12","chayachiran Moisesman, cüra Eleazarman, quëdaj Israel-masincunaman. Chay wichan Israel runacunaga Moab pampachömi tiyaycaran. Chay pampaga caycan Jordán mayupa jucaj läduncho, Jericöpa chimpanchömi. ");
INSERT INTO qub_vpl VALUES ("NU31_13","005_31_13","NUM","31","13","13","Tiyaycashanman manaraj chayachiptin Moisés, cüra Eleazar, waquin mandajcunapis tariparan. ");
INSERT INTO qub_vpl VALUES ("NU31_14","005_31_14","NUM","31","14","14","Ichanga Moisés fiyupa rabyacurcuran pillyaj aywashanpita cutimoj mandajcunapaj. Paycunaga warangata, pachacta mandajcunami caran. ");
INSERT INTO qub_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","Paycunatami rabyashpan niran: «¿Imanirtaj warmicunataga mana wañuchishcanquichu? ");
INSERT INTO qub_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","Warmicunachaj Balaam yachachiptin Israelcunataga pushashapis Tayta Diosta gongaycur mana allita rurananpaj. ¿Manachu chay warmicuna yachachiran Baal-peorta aduraytapis? Chaypitami Tayta Diosga fiyu gueshyata yurichiran Israel-masinchïcunata wañuchinanpaj. ");
INSERT INTO qub_vpl VALUES ("NU31_17","005_31_17","NUM","31","17","17","Canan öra wañuchiy llapan ollgu wamrancunata. Warmicunatapis runawan cacushan cajcunataga wañuchiy. ");
INSERT INTO qub_vpl VALUES ("NU31_18","005_31_18","NUM","31","18","18","Manaraj runa yatasha cajcunata ichanga apacuy. ");
INSERT INTO qub_vpl VALUES ("NU31_19","005_31_19","NUM","31","19","19","«Runacunata wañuchej cajcuna, ayata yatajcunaga ganchis junajyaj tiyarcaycashanchïman ama yaycamuchunchu. Yaycamunanpäga paycunapis, apacamushan jipashcunapis, warmi wamracunapis cananpita quimsa junajta limyuyächun. Chaypita ganchis junajtaga limyuyasha cananpaj yapay bäñacuchun. ");
INSERT INTO qub_vpl VALUES ("NU31_20","005_31_20","NUM","31","20","20","Limyuyächiy garapita, cabrapa ajchanpita, guerupita caj cösacunatapis. Röpayquicunatapis limyuyänanpaj tagshacunqui.» ");
INSERT INTO qub_vpl VALUES ("NU31_21","005_31_21","NUM","31","21","21","Guërrapita cutimojcunata shuntarcurna cüra Eleazar niran: «Tayta Diosmi Moisesta cay layta nisha: ");
INSERT INTO qub_vpl VALUES ("NU31_22","005_31_22","NUM","31","22","22","Imatapis goripita, guellaypita, fyërrupita, runsipita, estañopita, plömupita rurashan cajta tiyaycashanchïman yaycuchinayquipäga ");
INSERT INTO qub_vpl VALUES ("NU31_23","005_31_23","NUM","31","23","23","ninaman jatinqui limyuyänanpaj (ninacho mana rupacäcoj cajtaga). Nircur limyuyächicuna yacuwan limyuyächinqui. Ninacho rupacäcoj cajcunata ichanga yacullawan mayllaypa limyuyächinqui. ");
INSERT INTO qub_vpl VALUES ("NU31_24","005_31_24","NUM","31","24","24","Ganchis junajta cumlircur röpayquicunata tagshacunqui. Chayrämi limyu canquipaj. Chaypitarämi tiyarcaycashanchïmanga yaycamunqui.» ");
INSERT INTO qub_vpl VALUES ("NU31_25","005_31_25","NUM","31","25","25","Moisesta Tayta Dios niran: ");
INSERT INTO qub_vpl VALUES ("NU31_26","005_31_26","NUM","31","26","26","«Madián runacunapa marcanpita apacamushan uywacunata, runacunata cüra Eleazarwan mandajcuna yupäshishunqui. ");
INSERT INTO qub_vpl VALUES ("NU31_27","005_31_27","NUM","31","27","27","Yuparcur pullanta raquiy. Pullan canga pillyaman aywajcunapaj, pullanna quëdaj Israelcunapaj. ");
INSERT INTO qub_vpl VALUES ("NU31_28","005_31_28","NUM","31","28","28","Pillyaman aywajcunapaj raquishayquipita nogapaj raquinqui cada pichga pachac (500) jipashcunapita jucta. Wäcacunapita, bürrucunapita, uyshacunapitapis cada pichga pachacpita jucta raquinqui. ");
INSERT INTO qub_vpl VALUES ("NU31_29","005_31_29","NUM","31","29","29","Nircorga nogapaj impuestuta pägajno cüra Eleazarta entregaycunqui. ");
INSERT INTO qub_vpl VALUES ("NU31_30","005_31_30","NUM","31","30","30","Israel runacunapaj raquishan cajcunatana cada pichga chunca (50) jipashcunapita jucta raquinqui. Wäcacunapita, bürrucunapita, uyshacunapitapis cada pichga chuncapita (50) jucta raquinqui. Chaycunatana entreganqui Toldöcho aroj Leví trïbu runacunaman.» ");
INSERT INTO qub_vpl VALUES ("NU31_31","005_31_31","NUM","31","31","31","Cüra Eleazarwan Moisesga Tayta Dios nishannömi llapantapis ruraran. ");
INSERT INTO qub_vpl VALUES ("NU31_32","005_31_32","NUM","31","32","32","Madián runacunapata pillyaj suldärucuna quiquincunapaj apacushanta mana yupayllapa caran sojta pachac ganchis chunca pichgan waranga (675,000) uysha, ");
INSERT INTO qub_vpl VALUES ("NU31_33","005_31_33","NUM","31","33","33","ganchis chunca ishcay warangan (72,000) wäca; ");
INSERT INTO qub_vpl VALUES ("NU31_34","005_31_34","NUM","31","34","34","sojta chunca juc warangan (61,000) bürru; ");
INSERT INTO qub_vpl VALUES ("NU31_35","005_31_35","NUM","31","35","35","quimsa chunca ishcay warangan (32,000) runa yatäni jipashcuna. ");
INSERT INTO qub_vpl VALUES ("NU31_36","005_31_36","NUM","31","36","36","Guërraman aywajcunapaj pullanga caran. Paycunata raquipaycuran quimsa pachac quimsa chunca ganchis waranga pichga pachacnin (337,500) uyshata. ");
INSERT INTO qub_vpl VALUES ("NU31_37","005_31_37","NUM","31","37","37","Chay raquipashanpitami impuestutano Tayta Diospaj entregaran sojta pachac ganchis chunca pichgan (675) uyshata. ");
INSERT INTO qub_vpl VALUES ("NU31_38","005_31_38","NUM","31","38","38","Quimsa chunca sojta warangan (36,000) wäcapita impuestutano Tayta Diospaj entregaran ganchis chunca ishcay (72) wäcata. ");
INSERT INTO qub_vpl VALUES ("NU31_39","005_31_39","NUM","31","39","39","Quimsa chunca waranga pichga pachacnin (30,500) bürrupitana impuestutano Tayta Diospaj entregaran sojta chunca jucta (61). ");
INSERT INTO qub_vpl VALUES ("NU31_40","005_31_40","NUM","31","40","40","Chunca sojta waranga (16,000) jipashcunapitana impuestutano Tayta Diospaj entregaran quimsa chunca ishcayta (32). ");
INSERT INTO qub_vpl VALUES ("NU31_41","005_31_41","NUM","31","41","41","Impuestutano raquishantaga Tayta Dios nishannömi cüra Eleazarta Moisés entregaycuran. ");
INSERT INTO qub_vpl VALUES ("NU31_42","005_31_42","NUM","31","42","42","Pillyaman aywajcunapaj Moisés raquishanpita quëdäga caran Israelcunapaj. Chaycunapis caran ");
INSERT INTO qub_vpl VALUES ("NU31_43","005_31_43","NUM","31","43","43","quimsa pachac quimsa chunca ganchis waranga pichga pachacnin (337,500) uysha, ");
INSERT INTO qub_vpl VALUES ("NU31_44","005_31_44","NUM","31","44","44","quimsa chunca sojta warangan (36,000) wäca, ");
INSERT INTO qub_vpl VALUES ("NU31_45","005_31_45","NUM","31","45","45","quimsa chunca waranga pichga pachacnin (30,500) bürru, ");
INSERT INTO qub_vpl VALUES ("NU31_46","005_31_46","NUM","31","46","46","chunca sojta waranga (16,000) jipashcuna. ");
INSERT INTO qub_vpl VALUES ("NU31_47","005_31_47","NUM","31","47","47","Tayta Dios nishannöllami cada pichga chunca (50) jipashcunapita jucta Moisés raquiparan Leví trïbu runacunapaj. Cada pichga chunca (50) uywacunapitapis jucta raquiparan Tayta Diospa rispitädu Tincuna Tolduncho aroj Leví trïbu runacunapaj. ");
INSERT INTO qub_vpl VALUES ("NU31_48","005_31_48","NUM","31","48","48","Chaypitaga waranga suldärucunapa mandajnincuna, pachac suldärucunapa mandajnincuna Moisesta ");
INSERT INTO qub_vpl VALUES ("NU31_49","005_31_49","NUM","31","49","49","niran: «Guërraman pushashä suldärucunata yupashcä. Manami jucnayllapis wañumushachu. ");
INSERT INTO qub_vpl VALUES ("NU31_50","005_31_50","NUM","31","50","50","Chaymi Tayta Diospaj apamushcäcuna suldärucuna gori adurnuta apacamushanta: brasalëtacunata, surtïjacunata, arëticunata, waquin aläjacunatapis. Chaycunataga quiquëcunapa ruquëmi Tayta Diosta goycö.» ");
INSERT INTO qub_vpl VALUES ("NU31_51","005_31_51","NUM","31","51","51","Chaura goripita adurnucunata apamushanta Eleazarwan Moisés chasquiran. ");
INSERT INTO qub_vpl VALUES ("NU31_52","005_31_52","NUM","31","52","52","Waranga suldärucunapa mandajnincuna, pachac (100) suldärucunapa mandajnincuna Tayta Diospaj apamushan gori lasaran pachac pusaj chunca chuscu quïlun (184). ");
INSERT INTO qub_vpl VALUES ("NU31_53","005_31_53","NUM","31","53","53","Chay entregashan gori aläjacunaga caran guërraman aywaj suldärucuna cada ünun quiquincunapaj apacamushanpitami. ");
INSERT INTO qub_vpl VALUES ("NU31_54","005_31_54","NUM","31","54","54","Chaynömi Eleazarwan Moisés chasquiran mandajcuna apamushan gorita. Paycunana chay gorita aparan Tincuna Tolduman Israelcunata Tayta Dios yanapashanta imaypis yarpänanpaj. ");
INSERT INTO qub_vpl VALUES ("NU32_1","005_32_1","NUM","32","1","1","Rubén trïbu runacunapa, Gad trïbu runacunapaga uywancuna aypalla caran. Paycuna ricaptin Jazer partiwan Galaad partiga uywancuna tiyananpaj alli caran. ");
INSERT INTO qub_vpl VALUES ("NU32_2","005_32_2","NUM","32","2","2","Chaymi Rubén trïbu runacunawan Gad trïbu runacunaga aywaran Moisés, Eleazar, waquin mandajcuna caycashanman. Paycunata niran: ");
INSERT INTO qub_vpl VALUES ("NU32_3","005_32_3","NUM","32","3","3","«Atarot, Dibón, Jazer, Nimra, Hesbón, Eleale, Sebam, Nebo, Beón particunaga ");
INSERT INTO qub_vpl VALUES ("NU32_4","005_32_4","NUM","32","4","4","uywäcunata michicunäpaj allimi caycan. Uywäcuna achca captin cay particunata nogacunapämi Tayta Dios shuntasha. ");
INSERT INTO qub_vpl VALUES ("NU32_5","005_32_5","NUM","32","5","5","Chaymi gamcunata ruwacö nogacunata chay partita goycamänayquipaj. Jordán mayutaga amana päsachimaynachu.» ");
INSERT INTO qub_vpl VALUES ("NU32_6","005_32_6","NUM","32","6","6","Chayno niptin Moisés niran: «Famillyayquicuna pillyaj aywarcaycaptenga ¿imanirtaj gamcuna cayllachöna quëdacuyta munarcaycanqui? ");
INSERT INTO qub_vpl VALUES ("NU32_7","005_32_7","NUM","32","7","7","¿Imanirtaj famillyayquicunata guellanächinqui Tayta Dios aunishan nasyunman aywananta? ");
INSERT INTO qub_vpl VALUES ("NU32_8","005_32_8","NUM","32","8","8","Cades-barneapita Canaán nasyunta ricapacoj cachaptë gamnöcunami Israel Israel-masiquicunata guellanächiran. ");
INSERT INTO qub_vpl VALUES ("NU32_9","005_32_9","NUM","32","9","9","Paycunami ricapacushpan chayaran Escol pampayaj. Cutiycamorga llapan famillyayquicunata guellanächiran Tayta Dios goycushan partiman mana yaycunanpaj. ");
INSERT INTO qub_vpl VALUES ("NU32_10","005_32_10","NUM","32","10","10","Chay achäquimi chay junaj Tayta Dios fiyupa rabyacur niran: ");
INSERT INTO qub_vpl VALUES ("NU32_11","005_32_11","NUM","32","11","11","‹Egiptupita yargamoj runacuna ishcay chunca watayojpita janaman cäga mana wiyacushanpita manami yaycongachu Abrahamta, Isaacta, Jacobta aunishä nasyunman. ");
INSERT INTO qub_vpl VALUES ("NU32_12","005_32_12","NUM","32","12","12","Cenez runa Jefonepa wamran Calebwan Nunpa wamran Josuëllami yäracamashanpita chay nasyunman yayconga.› ");
INSERT INTO qub_vpl VALUES ("NU32_13","005_32_13","NUM","32","13","13","Chayno nirmi Tayta Dios fiyupa rabyacushpan llapan chay runacuna ushacänancama chuscu chunca watantin chunyajpa purichiran. ");
INSERT INTO qub_vpl VALUES ("NU32_14","005_32_14","NUM","32","14","14","«¿Canan gamcunapis Tayta Diosta rabyachej unay Israel-masiquicunanöllachu guellanächiyta munaycanqui? Chayno guellanächiptiquega yapaymi Israelcunapaj Tayta Dios rabyacurcongapaj. ");
INSERT INTO qub_vpl VALUES ("NU32_15","005_32_15","NUM","32","15","15","Gamcuna Tayta Dios nishanno mana aywayta munaptiquega Tayta Dios rabyacurcongami. Chaura yapaymi Israelcunataga chunyajpa purichenga. Chaura gamcunami juchayoj canquipaj Israel-masiquicuna ushacänanpäpis.» ");
INSERT INTO qub_vpl VALUES ("NU32_16","005_32_16","NUM","32","16","16","Moisés chayno niptin paycunaga niran: «Nogacuna caychöga munä wäcäcunapaj uyshäcunapaj curralta rurayllatami, famillyäcuna tiyaycänanpaj siudäcunata jatarachiyllatami. ");
INSERT INTO qub_vpl VALUES ("NU32_17","005_32_17","NUM","32","17","17","Cay quinraycho tiyaj runacuna mana fastidyananpämi famillyäcunatawan uywäcunata siguraycur cachaycushaj. Nircur nogacunaga pillyapaj camaricurcur waquin Israel-masëcunapa ñaupanta aywashaj tiyananpaj partiman chayachinäcama. ");
INSERT INTO qub_vpl VALUES ("NU32_18","005_32_18","NUM","32","18","18","Llapan Israel-masëcuna tiyananpaj chacrata charircuptinrämi nogacunaga cuticamushaj. ");
INSERT INTO qub_vpl VALUES ("NU32_19","005_32_19","NUM","32","19","19","Jordán mayupita cay chimpacho chacrata chasquiycarnaga Jordán mayupa washa chimpanchöga mananami chacrata ‹gomay› nishänachu.» ");
INSERT INTO qub_vpl VALUES ("NU32_20","005_32_20","NUM","32","20","20","Niptin Moisés niran: «Chayno captenga Tayta Dios nishanno camaricurcur guërraman ayway. ");
INSERT INTO qub_vpl VALUES ("NU32_21","005_32_21","NUM","32","21","21","Tayta Dios yanapäshushpayqui Jordán mayuta chimpar chay particho tiyaj runacunata usharamuy. ");
INSERT INTO qub_vpl VALUES ("NU32_22","005_32_22","NUM","32","22","22","Intëru nasyuncho camacarcuptinraj cutimunqui. Chayno cumlerga Tayta Diospa ñaupancho, Israel-masiquicunapa ñaupancho manami juchayojnachu canquipaj. Chaynöpami cay chacracuna gamcunapäna canga. ");
INSERT INTO qub_vpl VALUES ("NU32_23","005_32_23","NUM","32","23","23","Nishayquino mana cumlishpayquimi ichanga Tayta Diospa ñaupancho juchayoj ricacunquipaj. Chaura chay juchayquipita castigashunquipämi. ");
INSERT INTO qub_vpl VALUES ("NU32_24","005_32_24","NUM","32","24","24","Chauraga famillyayquicuna quëdananpaj siudäcunata ruray. Uywayquicunapäpis curralcunata ruray. Nircur quiquiquicunaga aunishayquinölla ayway.» ");
INSERT INTO qub_vpl VALUES ("NU32_25","005_32_25","NUM","32","25","25","Chaura Gad trïbuwan Rubén trïbu runacuna niran: «Nogacunaga nimashayquita cumlishämi tayta. ");
INSERT INTO qub_vpl VALUES ("NU32_26","005_32_26","NUM","32","26","26","Warmëcuna, wamräcuna, uywäcuna cay Galaad parti siudänincunachömi quëdanga. ");
INSERT INTO qub_vpl VALUES ("NU32_27","005_32_27","NUM","32","27","27","Nogacunami ichanga sumaj camaricurcur Tayta Dios nishanno guërraman aywashaj.» ");
INSERT INTO qub_vpl VALUES ("NU32_28","005_32_28","NUM","32","28","28","Chayno niptin Moisesga cüra Eleazarta, Josuëta, cada trïbupa mandajnincuna shuntacasha caycajta niran: ");
INSERT INTO qub_vpl VALUES ("NU32_29","005_32_29","NUM","32","29","29","«Gad trïbu, Rubén trïbu runacuna gamcunawan iwal pillyäshishunayquipaj Tayta Dios nishanno Jordán mayuta päsaptin, nasyunta guechunayquicama pillyäshishuptiquega Galaad parti quiquincunapana cananpaj entreganqui. ");
INSERT INTO qub_vpl VALUES ("NU32_30","005_32_30","NUM","32","30","30","Yanapäshunayquipaj camaricusha Jordán mayuta mana päsashpanga paycunapis gamcunawan iwalmi Canaán partichöraj partisyunta chasquenga.» ");
INSERT INTO qub_vpl VALUES ("NU32_31","005_32_31","NUM","32","31","31","Chaura Gad trïbu, Rubén trïbu runacunaga niran: «Nogacunaga Tayta Dios nishannömi cumlishäcuna, tayta. ");
INSERT INTO qub_vpl VALUES ("NU32_32