﻿USE sofia;
DROP TABLE IF EXISTS sofia.pwr_vpl;
CREATE TABLE pwr_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES pwr_vpl WRITE;
INSERT INTO pwr_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","अबराहम को सन्तान, दाऊद को सन्तान यीसु मसीह को खानदान को पवीतर किताब मा जानकारी। ");
INSERT INTO pwr_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","अबराहम लक इसहाक जलम लेईस, इसहाक लक याकूब जलम लेईस, याकूब लक यहूदा, अखीन वोको भाऊ, जलम लेइन। ");
INSERT INTO pwr_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","यहूदा अखीन तमार लक फिरिस, अना जोरह जलम लेईस। फिरिस लक हिस्रोन जलम लेईस, अखीन हिस्रोन लक एराम जलम लेईस। ");
INSERT INTO pwr_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","एराम लक अम्मीनादाब जलम लेईस, अम्मीनादाब लक नहसोन, अखीन नहसोन लक सलमोन जलम लेईस। ");
INSERT INTO pwr_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","सलमोन अखीन राहब लक, बोअज जलम लेईस। बोअज अखीन रुत लक, ओबेद जलम लेईस। अखीन ओबेद लक, यिसै जलम लेईस। ");
INSERT INTO pwr_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","यिसै लक दाऊद राजा जलम लेईस। अखीन दाऊद लक सुलेमान, उ ऊरियाह को बायको ले जलम लेईस। ");
INSERT INTO pwr_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","सुलेमान लक रहबाम जलम लेइस। रहबाम लक अबिय्याह जलम लेईस, अखीन अबिय्याह लक आसा जलम लेईस। ");
INSERT INTO pwr_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","अखीन आसा लक यहोसापात जलम लेईस, यहोसापात लक योराम जलम लेईस। अखीन योराम लक उजिय्याह जलम लेईस। ");
INSERT INTO pwr_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","उजिय्याह लक योताम जलम लेईस, योताम लक अहाज जलम लेईस। अखीन अहाज लक हिजकिय्याह जलम लेईस। ");
INSERT INTO pwr_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","हिजकिय्याह लक मनस्से जलम लेईस। मनस्से लक अमोन जलम लेईस। अमोस लक योसियाह जलम लेईस। ");
INSERT INTO pwr_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","अखीन बँदी भई केन बेबीलोन जावन को बेरा मा योसियाह लक यकुन्याह, अखीन ओको भाऊ जलम भइन। ");
INSERT INTO pwr_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","बेबीलोन नगर मा पहुचनो को बादमा यकुन्याह ले सालतिएल जलम भयो। अना सालतिएल लक जरुब्बाबिल जलम लेईस। ");
INSERT INTO pwr_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","अना जरुब्बाबिल लक अबिहुद जलम लेईस अना अबिहुद लक इल्याकिम जलम लेईस, अना इल्याकिम लक अजोर जलम लेईस। ");
INSERT INTO pwr_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","अना अजोर लक सदोक जलम लेईस, अना सदोक लक अखिम जलम लेईस, अना अखिम लक इलीहुद जलम लेईस। ");
INSERT INTO pwr_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","अना इलीहुद लक इलियाजार जलम लेईस, अना इलियाजार लक मत्तान जलम लेईस, अना मत्तान लक, याकूब जलम लेईस। ");
INSERT INTO pwr_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","अना याकूब लक युसुफ जलम लेईस, जो मरियम को नवरा होतो। अना मरियम लक यीसु, जोन यीसु मसीह कहलावसे जलम लेईस। ");
INSERT INTO pwr_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","असो अबराहम लक, दाऊद लक, सब 14 पीढ़ी भयो। अना दाऊद ले, बेबीलोन देस बन्दी होयके जावन तकन 14 पीढ़ी, अना बन्दी होयके बेबीलोन जावन को बेरा ले, मसीह लक 14 पीढ़ी भयो। ");
INSERT INTO pwr_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","यीसु मसीह को जलम असो भयो। जबा वोकी माय मरियम की पक्की, युसुफ को संग भई। तबा उनको मिलन को पूढा, वा पवीतर आतमा कन लक, पोट ले भई गई। ");
INSERT INTO pwr_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","वोको होवन वारा नवरा युसुफ एक नेक मानूस होतो। यो गोस्टी सांग के उ वोकी बेइज्जती करनो नही चाव्हत होतो। एकोलाय उ चुप्पई लक बिहाव तोड़न को बिचार बनायो। ");
INSERT INTO pwr_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","जबा उ असो बिचारत होतो, तबच सपना मा पिरभु को सरगदूत आयो, अना वोला कव्हन लग्यो “अगा युसुफ! दाऊद को टूरा, नोको डराय, तु आपरी बायको मरियम संग लगन कर, काहेका वोको पोट मा जोन लेकरा सेत, उ परमेस्वर को पवितर आतमा कन लक सेत। ");
INSERT INTO pwr_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","अना मरियम टूरा ला जलम देहे, अना तु वोको नाव यीसु राखजोस, काहेका उ अपरा लोकगीन ला, उनको पाप लक बचा हेत।” ");
INSERT INTO pwr_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","असो होवन को यो कारन से का, पिरभु न जेना गोस्टी ला, भविस्यवक्ता गीन लक सागिसेस, उ पूरो भई जाये। ");
INSERT INTO pwr_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“आयको एक कुँवारी टूरी पोट लक रहेत, अना एक टूरा ला जलम देहे। अखीन वोको नाव इम्मानुएल ठेयो जाहे, मजे परमेस्वर आमरो संग मा से।” ");
INSERT INTO pwr_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","तबा युसुफ जप लक जगयो, पिरभु को सरगदूत ना जसो सांगयो होतो, वसोच उ वोको लक लगन करके आपरो घर आनिस। ");
INSERT INTO pwr_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","अना जब तकन वा टूरा जलम नहि लियो तबा तकन उ मरियम को संग नहि सोयो अना यूसुफ न, वोको नाव यीसु राखिस। ");
INSERT INTO pwr_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","राजा हेरोदेस जबा राज कर रहयो होतो। वोच बेरा मा, यहुदिया को, बैतलेहम नगर मा, यीसु को जलम भयो। तबच काही बेरा बाद, बिदवान जोन तारा ला चोव के पंचाग देखन वारा, येरुसलेम नगर मा आइन। ");
INSERT INTO pwr_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","“उनना पुसीन यहूदिगीन को आजच जलम हुयो लेकरा राजा कहाँन से? काहेका हमीना वोको तारा ला बादल मा देखीसेजन अना हमी वोकी पिराथना करन आयसेजन।” ");
INSERT INTO pwr_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","जबा असो गोस्टी राजा हेरोदेस न आयकिस, वसोच उ थरथराय गयो। अखीन सप्पा यरुसलेम को लोकगीन सटिया गईन। ");
INSERT INTO pwr_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","तबा वोना मुखिया याजक, अना मोसे को नियम को गुरू ला, जमा करीस। अना उनको लक पुसीस “का मसीह को जलम कहाँन होवनवारा से” ");
INSERT INTO pwr_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","भविस्यवक्ता गीनना राजा ला कहिन, “पवीतर गींरथ मा असो लिख्यो सेत का यहुदिया छेतर को” बैतलेहम नगर मा उ जलम लेवन वारा सेत, ");
INSERT INTO pwr_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","वो यहूदा देस को बैतलेहम, नगर, तु यहूदा देस को कोनी नगर लक कम नामी नाहत। काहेका तोरो लक एक राजा होहेत जोन मोरो इजरायली परजा ला मारग चोवाहेत। ");
INSERT INTO pwr_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","तबा हेरोदेस न पंचाग देसनवारा ला उगो-मुगो बुलाइस। अना यो गोस्टी ला पक्को करीस। का तारा ठीक कोनी बेरा मा चोयो होतो। ");
INSERT INTO pwr_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","मंग राजा उनला बैतलेहम धाड़ीस। अना कहीस, जाव अना वोना लेकरा को बारे मा साजरी लक “पता लगावो” अना जबा उ तुमला मिल जाहे त मोला सांगो बल्कि मी भी आयके वोकी पिराथना कर सकु। ");
INSERT INTO pwr_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","मंग उ राजा की गोस्टी ला आयक के, चली गइन। उ तारा ला बादर मा उनना देखी होतीन होती। उ उनको पुढ़ा-पुढ़ा जाय रहयो होतो, मंग जबा उ जघा आई जहान उ टूरा होतो त तारा वोको वारता रुक गयो। ");
INSERT INTO pwr_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","जबा उनना असो देखिन त वय लगत खुसी भईन। ");
INSERT INTO pwr_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","वय वोना घर मा गईन, अना उनना वोकी माय मरियम लेकरा को संग होति, उता माय अना लेकरा को दरसन करीन। अना टोंगरा टेकके, नमस्कार करन लगीन। अना आपरी-आपरी पेटी खोलके, ओमा लक मुदरो, लुभान अना गन्धरस को भेट चघाईन। ");
INSERT INTO pwr_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","पर परमेस्वर न एक सपना मा उनला चेताय देइस का वय वापसी हेरोदेस को जवर नोको जावो तबा वय एक दुसरो मारग लक अपरो देस ला लवट गईन। ");
INSERT INTO pwr_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","जबा वय चली गईन त यूसुफ ला सपना मा पिरभु को एक सरग दुत न पिरगट होयके कहीस, उभो होय अना माय अना लेकरा ला धरके उगो-मुगो लक मिसर चली जाय, अना मी जबा तकन तोला नहि कहु, उतच रव्हने काहेकी हेरोदेस एना टूरा ला मारवा डाकन को लाई ढुन्डेत। ");
INSERT INTO pwr_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","तबा यूसुफ उभो भयो, अना माय अखीन लेकरा ला धरके रात मा मिसर देस को लाई चली गयो। ");
INSERT INTO pwr_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","अना हेरोदेस राजा को मरनो तकन, वहाँच रहयो। एको लाई की जेनो गोस्टी ला, पिरभु ना भविस्यवक्ता गीनको टोन्ड लक, सांग्यो होतो, उ पूरो भयो “मी ना आपरो टूरा ला मिसर लक हाकलिसेव।” ");
INSERT INTO pwr_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","जबा राजा हेरोदेस ना यो चोवयो का, पंचाग चोवनवारा ना, मोला चुथिया बनाईसेस, तबा उ हिजड़ गयो अना लोकगीन ला धाड़के, पंचाग देसनवारा लक सांग्यो बेरा मा, बैतलेहम नगर अना ओको इतानी-उतानी को जघा मा जेतरा, दुई साल अना ओको लक कम उमर को लेकरा होतीन। उन सब ला मरवाय डाकीस। ");
INSERT INTO pwr_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","तबा जोन गोस्टी यीरमीयाह भविस्यवक्ता ना जोन बचन कव्हयो होतो, उ पूरो भयो। ");
INSERT INTO pwr_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“रामाह मा एक दुखी आवाज आयकु आई। रड़ना अना चिल्लानो की मोठी आवाज आई राहेल नाव की बायको, आपरो टूरा ऐना लाई रड़त होती। अना सान्ती लक चुप नही होवत होती काहे की वय मर गईन।” ");
INSERT INTO pwr_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","राजा हेरोदेस को मरन को मंघा, पिरभु को एक सरगदूत ना मिसर मा युसुफ ला चोयो, अना कहीस! ");
INSERT INTO pwr_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“उठ, उ टूरा अना-ओकी माय ला धर के इसरायल देस मा चली जाय। काहे का जोन टूरा को जान लेवन चाहत होतीन, वय मर गईन।” ");
INSERT INTO pwr_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","तब उ उठयो! अना टूरा अना ओकी माय ला धरके, इसरायल देस मा आय गयो। ");
INSERT INTO pwr_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","पर यो आयक के अरखिलाउस आपरो बाप राजा हेरोदेस की जघा, यहुदिया मा राज कर रही से वहाँन जावन लाई डराय गयो। मंग सपना मा परमेस्वर लक चेतावनी पायके गलील परदेस मा चली गयो। ");
INSERT INTO pwr_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","अना नासरत नाव को नगर मा जाय के रव्हन लगयो जोन लक वा गोस्टी पूरो भयी जाय जोन भविस्यवक्ता गीन लक सांग्यो गयो होतो, की “उ नासरी कहलाएत।” ");
INSERT INTO pwr_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","ओनो दिवस मा, योहन बप्तिस्मा देवन वालो, यहुदिया देस को सुनसान जंगल मा आयो अना परचार करन लगयो। ");
INSERT INTO pwr_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","अपरो पाप लक दुहूर भय जाव, काहे की सरग को राज कठा आय गई से। ");
INSERT INTO pwr_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","योहन वोच से जोन को गोस्टी यसायाह भविस्यवक्ता न कहिसेस का: “जंगल मा एक मानूस हाकल रहयो से का परमेस्वर की रास्ता ला तैयार करो, अना वोकी सरक सरल करो” ");
INSERT INTO pwr_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","योहन को कपरा ऊट को चुन्दी लक बनयो होतो। अना आपरी कमर मा चमड़ा को पट्टा बांधत होतो। ओको जेवन फाफा अना सहेद होतो। ");
INSERT INTO pwr_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","तबा येरुसलेम नगर, अना सारो यहुदिया देस, अना यरदन नदी को इतानी-उतानी को सब जघा, का लोक ओको जवर हिटके आइन। ");
INSERT INTO pwr_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","उनना आपरो-आपरो पाप ला मानके यरदन नदी मा ओको लक बप्तिस्मा लेईन। ");
INSERT INTO pwr_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","जबा योहन न लगत सा मोसे को नियम को सिक्सक अना सदुकि फरिसी इनला बप्तिस्मा लेवन काजी आपरो जवर आवत चोविस, ता उनलक कहीस “हे सरप को अवलाद, तुमीला कोनी ना हेत दिलाइसेस, का आवन वालो कोप लक बचो” ");
INSERT INTO pwr_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","वोनो काम गीनला चोवके तुमी अपरो पाप लक मन हटाव अना आपरो आप मा साजरो फर पावो। ");
INSERT INTO pwr_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","अना असो नोको सोचो, का तुमी यो कहेके दंड लक बच सकासेव का अबराहम तुमरो पुरखा से, मी तुमरो लक कव्हसु का परमेस्वर एना पहाड़ी को गोटा मा लक अबराहम को लाई आवलाद पैदा कर सकासे। ");
INSERT INTO pwr_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","अता टँगिया झाड़ की जड़ पर राखियो से, जेना-जेना झाड़ साजरो फर नही आना से, उ कापो अना स्तो मा झोको जाहेत। ");
INSERT INTO pwr_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","मि ता तुमी ला पानी लक “पाप लक मन हटाव को बप्तिस्मा देवासेउ, पर जोन मोरो मंघा आवन वालो से, उ मोरो लक ताकतवर से, मि ओको सेन्डिल उचलन को लाईक नही सेऊ। उ तुमला पवीतर आतमा अना स्तो लक बप्तिस्मा देहे। ");
INSERT INTO pwr_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","ओको सुपड़ो, ओको हात मा से, उ आपरो खरीयान साजरो लक सफा करेत। अना आपरो गहुँ ला आपरो ढोला मा जमा करेत पर भुसा ला ओना स्तो मा पेटाहे जोन कबच नही झिझाहेत।” ");
INSERT INTO pwr_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","ओना बेरा मा यीसु ना गलील छेतर लक, यरदन नदी को किनार मा, योहन लक बप्तिस्मा लेवन वोको जवर आयो। ");
INSERT INTO pwr_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","पर योहन यो सांगके, ओला रोकन लग्यो “मोला ता तोरो हात लक, बप्तिस्मा लेवनो से, अना तु मोरो जवर आयीसेस” ");
INSERT INTO pwr_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","यीसु ना ओला जवाब देइस “अबा ता असो च होवन दे, काहे की आमी ला येना रित लक सबच धरम-करम ला पूरो करनो से।” तबा योहन, यीसु को गोस्टी ला मान लेइस। ");
INSERT INTO pwr_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","जसोच यीसु बप्तिस्मा लेइस, त वसोच बाहेर आयो तबा वोको लई सरग को किवाड़ उघड़ गयो, अना वरता लक परमेस्वर को आतमा ला परेवा को जसो आपरो वरता उतरता चोइस। ");
INSERT INTO pwr_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","अना सरग लक आवाज आयकु आई “यो मोरो चहेतो टूरा से, जेना लक मि सब लक ज्यादा खुस सेव।” ");
INSERT INTO pwr_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","वोना बेरा आतमा यीसु ला जंगल मा ले गईस, का सैतान वोकी परिक्सा लेहे। ");
INSERT INTO pwr_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","यीसु चाड़ीस दिवस, अना चाड़ीस रात लक उपास करतो रहयो, मंग वोला भुख लगी। ");
INSERT INTO pwr_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","तबा परखन वालो ना ओको जवर आयके कहीस “अदी तु परमेस्वर को टूरा सेस ता कव्हका यो गोटा भाखरी बन जाए।” ");
INSERT INTO pwr_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","यीसु ना जवाब देइस, का गिरंथ मा असो लिख्यो से, मानूस सिरफ जेवन च लक नही, जित्तो रव्हासे, पर हरेक सबद जोन परमेस्वर को टोन्ड लक हिटासे वोको लक जित्तो रव्हासेत। ");
INSERT INTO pwr_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","तबा सैतान यीसु ला पवीतर नगर मा लेगइस अना ओला मंदिर करसा को वरता मा उभो कर देइस। ");
INSERT INTO pwr_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","अना ओला कहीस “अदी तु परमेस्वर को टूरा आस, ता खाल्या कुद जाय, काहे का पवीतर गीरंथ मा लिख्यो से, उ तोरो बारे मा आपरो सरगदूत गिनला हुकूम देहे, अना वय तोला हातो-हात उचल लेहेत। कहीं असी ना होय का तोरो पाय मा ठोकर लगे।” ");
INSERT INTO pwr_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","यीसु ना ओला कहीस, पर पवीतर गीरंथ मा असो भी लिख्यो से “अपरो पिरभु मोठो परमेस्वर की परीक्सा नोको लेवजोस।” ");
INSERT INTO pwr_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","मंग बालजबूल ओला एक लगत मोठो पहाड़ पर ले गईस, अना सारो जग को राज माया महिमा चोवाय के ");
INSERT INTO pwr_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","ओला कहीस “अदी तु टोंगरा टेकके मोरी आराधना करजोस, ता मि यो सब काही तोला दे देहू।” ");
INSERT INTO pwr_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","तबा यीसु ना ओला जवाब देइस, हट जाय सैतान! काहेका धरम की किताब मा लिख्यो से “तु अपरो पिरभू व परमेस्वर की आराधना करो अना अखिन वोकिच सेवा करो।” ");
INSERT INTO pwr_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","एको पर सैतान वोला सोड़के चली गयो अना सरगदुत आयके वोकी सेवा करन लगीन। ");
INSERT INTO pwr_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","जबा यीसु ना यो आयकीस, का योहन धराय गयो से। ता उ गलील नगर ला चली गयो। ");
INSERT INTO pwr_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","अना उ नासरत नगर ला छोडके कफरनहुम नगर मा रव्हन लगयो। जो झील को जवर जबूलून अना नप्ताली को देस मा से। ");
INSERT INTO pwr_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","असो परकार लक यसायाह भविस्यवक्ता को कव्हयो गयो गोस्टी पूरो भयो। ");
INSERT INTO pwr_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“जबूलून अना नप्ताली को देस, झील को रास्ता लक यरदन नदी को वोनागन, गैर यहुदीगीन को गलील ");
INSERT INTO pwr_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","जोन लोक अंधार मा बसी होतीन, उनना मोठी उजाड़ो चोविन, अना जोन मरन को देस अना सावली मा बसी होतीन, उन पर उजाड़ो चमकयो।” ");
INSERT INTO pwr_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","ओना बेरा लक यीसु ना पिरचार करन लगयो का “पाप लक मन ला हटाव मन फिराओ काहे का सरग को राज जवर आई से।” ");
INSERT INTO pwr_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","यीसु गलील को झील को जवर, हिंड रहयो होतो, ओना दुई भाऊ गीन समौन जेनको नाव पतरस भी कहलावसे, अना ओको भाउ अन्दिरयास ला झील मा जाल डाकत चोविस; काहे का वय धिवर होतीन। ");
INSERT INTO pwr_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","यीसु ना उन लक कहीस “मोरो मंघा आव, ता मि तुमला मसरी धरन की जघा लोकगीन ला परमेस्वर को राज मा आननो सिकाहु।” ");
INSERT INTO pwr_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","वय तुरुत जाल ला सोड़के ओको मंघा चलन लगीन। ");
INSERT INTO pwr_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","वहान लक पुढा बढ़नो पर यीसु चोवयो का जबदी को टूरागिन याकूब, अना योहन दूई भाऊगीन अपरो बाप जबदी को संग नाव मा जाल ला तैय्यार करत होतिन। ता यीसु न उनला हाकलीस, ");
INSERT INTO pwr_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","वय तुरूत नाव अना आपरो बाप ला सोड़के वोको मंघा चली गईन। ");
INSERT INTO pwr_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","यीसु सारो गलील मा हिंडत-हिंडत उनको पिराथना घर मा सिक्सा देवन लगयो होतो। अना राज को साजरो बारता को बारे मा सांगत होतो। अखीन लोक गीन की हर बीमारी, अना कमजोरी, ला साजरो करत होतो। ");
INSERT INTO pwr_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","अना वोको नाव सफा सीरिया देस मा, फैल गयो। अखीन लोकगीन सप्पा बीमार ला, अना दुखी मानूस गीन ला अना जिनमा भुत-पलित झोमयो होतिन, मिरगी वारा, लकवा वारा ला ओको जवर आनीन। अना उ उनला साजरो करत होतो। ");
INSERT INTO pwr_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","गलील अना दहानगर मा येरुसलेम नगर, यहुदिया छेतर अना यरदन नदी को ओनांगन लक भीड़ ओको मंघा भय गई। ");
INSERT INTO pwr_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","यीसु एना मोठो भीड़ ला चोवके पहाड़ी पर चघ गयो। अना जबा बस गयो, तबा ओको चेला ओको जवर आइन। ");
INSERT INTO pwr_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","अना उ यो कव्हतो हुयो सिक्सा देवन लगयो। ");
INSERT INTO pwr_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","धन्य सेत वय, जो मन को गरीब सेत। काहे का सरग को राज उनको सेत। ");
INSERT INTO pwr_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","धन्य सेत वय, जो सोक करासेत, काहे का वय सान्ती पाहेत। ");
INSERT INTO pwr_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","धन्य सेत वय, जोन नरम सेत! काहे का वय धरती का मालीक होयेत। ");
INSERT INTO pwr_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","धन्य सेत वय जो धरम का भुको अना तहान सेत, काहे का वय, अघा जाहेत। ");
INSERT INTO pwr_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","धन्य सेत वय जोन रहमदिल सेत, काहे का वोको पर रहम कियो जाहेत। ");
INSERT INTO pwr_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","धन्य सेत वय, जोनको मन सुध्द सेत, काहे उ परमेस्वर ला, चोहेत। ");
INSERT INTO pwr_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","धन्य सेत व, जो मेल करानवारा सेत, काहेका उ परमेस्वर का टूरा कहलाहेत। ");
INSERT INTO pwr_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","धन्य सेत वय, जोन धरम को कारन लक तगांयो जासेत, काहेका सरग को राज उनको च से। ");
INSERT INTO pwr_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","धन्य सेव तुमी, जबा, मानूस मोरो कारन, तुमरो बेज्जाती करेहत। तुमरो पर अत्याचार अपमान करेहत अना अखीन झुठो, दोस लगाहेत। ");
INSERT INTO pwr_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","तबा खुसी लक मगन होवना, काहे का तुमरो लाई सरग मा, मोठो फर से तुमरो पूढा को भविस्यवक्ता गीन ला भी एनाच रीत लक सतायो होतीन। ");
INSERT INTO pwr_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","तुम्हि धरती को नोन सेव, पर अदी नोन को सुवाद बिगड़ जाहेत ता कोन सी जिनुस लक वोला नमकीन कियो जाहेत। मंग वा कोनी काम को नाहती, एको लाई का बाहेर फेको जाहेत, अना मानूस को पाय खाल्या खुंदयो जाहेत। ");
INSERT INTO pwr_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","तुमी एना जग की उजाड़ो सेव, जोन नगर पहाड़ी मा बसो से, वा लूक नही सकत। ");
INSERT INTO pwr_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","अखीन लोक गीन दियो पैटाय के फुल को खाल्या डलिया मा नही राखत, पर फूल पर राखासेत, तबा ओना घर का सारो लोक गीन ला उजाड़ो भेटासे। ");
INSERT INTO pwr_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","वोको च जसो तुमरो भी उजाड़ो मानूस को पुढा चमकेत, काहे का उ तुमरो भलो काम ला देख के तुमरो बाप की सरग मा बड़ाई होहेत। ");
INSERT INTO pwr_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","यो नोको समजो का, मि पवीतर गीरंथ या भविस्यवक्ता मोसे को नियम ला, लोप करन लाय आई सेऊ, पर मी तो वोला पूरो करन लाई आई सेव। ");
INSERT INTO pwr_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","काहे की मि तुमरो लक खरो कव्हसु, का जबा तकन सरग अना धरती टल न जाहेति। तबा तकन मोसे को नियम लक एक मातरा एक बिन्दु भी, बिना पूरो हुये नही टलेत। ");
INSERT INTO pwr_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","एको लाई जो कोनी, एना नहानो लक नहानो , हुकूम ला कोनी एक ला तोड़के अना वसोच लोक गीन ला सिखाहे, उ सरग को राज मा सब लक नहानो कहलाहे पर जो कोनी एना हुकूम ला मानहेत अना उनला वसोच सिखाहे, उ सरग को राज मा मोठो कहलाहे। ");
INSERT INTO pwr_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","काहे की मि तुम लोक गीन कव्हसु, की अदी तुमरो नेकी को काम, मोसे को नियम को गुरू लक अना, फरिसी गीन लक बड़के नही होहेत। ता तुम्हि सरग को राज मा कदीच भीतर नही धस सकेत। ");
INSERT INTO pwr_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","तुमी आयकि सेव का जुनो जुग का लोक गीन ला कव्हयो गयो होतो, का जान लक नोको मारने, अना जोन जान लक मारहेत, उ कचहरी मा, सजा को काबील होहेत। ");
INSERT INTO pwr_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","पर मि तुमी लक यो कव्हासु, का जोन कोनी आपरो भाऊ पर हिजड़ेत, उ कचहरी मा सजा को काबील होहेत, अना जोन कोनी आपरो भाऊ ला निकम्मो कहे, ता उ मोठी सभा मा सजा को काबील होहेत, अना जो कोनी कहे अरे मुरख! ता उ नरक की स्‍तो को सजा को हिस्सेदार होयेत। ");
INSERT INTO pwr_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","एकोलाय अदी तुम्हि आपरी भेट होमन कुन्ड को जवर आनने, अना उता तुम्हिला हेत आहेत का तोरो भाऊ को मन मा तोरो लाय, काही विरोध से, ");
INSERT INTO pwr_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","ता आपरी भेट उतच होमनकुन्ड को पुढा सोड़ देव अना जायके पहले आपरो भाऊ लक मेल-मिलाप कर। अखीन तबा आयके आपरी भेंट चघाने। ");
INSERT INTO pwr_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","कचहरी जातो बेरा मी रास्ताच मा अपरो मुद्दई लक मेल मिलाप कर लेवो, कहीं असो नोको होहेत का वय तुमला न्याय करन वालो ला सोप दे अना सिपाई तुमला जेल मा डाक दे। ");
INSERT INTO pwr_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","मि तुम्हि लक खरो कव्हसु, की जबा तकन तुमी पैसा-पैसा भर नही देहो, तबा तकन उता लक सूट नही सकने। ");
INSERT INTO pwr_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","तुम्हि लोकगीन आयकि सेव की कव्हयो गयोसे, का छिनालापन नोको करना। ");
INSERT INTO pwr_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","पर मि तुम लक कव्हसु, की जोन कोनी कोनी बायको पर बुरो नजर डाखेत, उ ओको लक मन मा छिनाली कर लेवासे। ");
INSERT INTO pwr_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","अदी तोरी उज्जो डोरा तोला ठोकर खिलावासे, ता ओला हेड़के फेक दे काहे का तोरो लाई यो साजरो से, की तोरो तनमा लक एक आंग खराब होय जाहेत, अखीन तोरो सप्पा तन नरक मा नोको डाख्यो जाय। ");
INSERT INTO pwr_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","अदी तोरो उज्जो हात तोला ठोकर खवाये ता वोला काप के फेक देवने। काहेका तुम्हारो लाय योच साजरो से का तुम्हारो तन मा लक एक खराब होय जाहेत अखीन तोरी सप्पा काया नरक मा नोको डाकयो जाहेत। ");
INSERT INTO pwr_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","असो भी कव्हयो गयो होत्यो, जोन कोनी अपरी बायको ला सोड़-सुट्टी देवनो चाव्हसे, ता उ दे-दे। ");
INSERT INTO pwr_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","पर मी तुम्हिला कव्हसू, का जोन कोनी अपरी बायको ला छिनालापन को सिवा, काही अखीन कारन लक सोड़-सुट्टी देवासे, त उ छिनाली करवासेत। अना जो कोनी वोना छोड़ी हुई लक बिहा करासे त उ छिडरापन करासेत। ");
INSERT INTO pwr_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","तुम्हि आयकि सेव का पयले को जुग मा लोकगीन ला कव्हयो गयो होत्यो। का झुठी किरिया नोको खाना, पर पिरभु लाई अपरी कसम ला पूरी करने। ");
INSERT INTO pwr_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","पर मी तुमला यो कव्हसु, का कभीच किरया नोको खावने न त सरग की काहेका उ परमेस्वर को सिघासन आय। ");
INSERT INTO pwr_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","ना ता धरती की काहेकि वा वोको पाय की चौकी आय। ना ता येरुसलेम की काहेकि उ महा राजा को नगर आय। ");
INSERT INTO pwr_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","तुम्हि अपरी डोस्की की भी किरिया नोको खावने। कासेकि तु अपरा चुन्दी गीन ला कारा अना पांढरा नही कर सकासेस। ");
INSERT INTO pwr_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","पर तुमरी गोस्टी हव ता हव अना नही ता नही होय। कासेकि जोन एकोलक जादा होवासे वा बुराई लक होवासे। ");
INSERT INTO pwr_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","तुम्हि आयकि सेव का कहयो गयो होत्यो। डोरा को बदला डोरा, अना दाँत को बदला दाँत। ");
INSERT INTO pwr_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","पर मी तुमला यो कव्हसू, का बुराई को बीरोध नोको करने। पर जोन कोनी तोरो उज्जो गाल मा झापड़ मरेत, ता वोको कन दुसरो गाल कर देवने। ");
INSERT INTO pwr_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","अदी कोनी तोरो पर मुकदमा करके, तोरो कुरता ला लेवनो चाहे ता वोला पचिया भी दे देने। ");
INSERT INTO pwr_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","जोन कोनी तोला कोस भर मा लीजाहे त वोको संग मा दुई कोस चली जाजोस। ");
INSERT INTO pwr_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","जोन कोनी तोरो लक मगे, वोला देजोस। अना जोन कोनी तोरो लक उधार लेनो चाव्हसे वोको लक टोन्ड नोको मोड़जोस। ");
INSERT INTO pwr_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","तुम्हि आयकि सेव का कव्हयो गयो होत्यो। का अपरो संगी लक माया राखो, अना अपरो बयरी लक बईर। ");
INSERT INTO pwr_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","पर मी तुम्हिला यो कव्हसू का अपरा बयरी गीन पर माया राखो। अखीन तूम्हि अपरो सतावन वारा गीन लाई पिराथना करने। ");
INSERT INTO pwr_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","जेनको लक तुम्हि अपरो सरग को परमेस्वर बाबूजी की सन्तान कहलाने। कासेकी उ साजरो अना बुरो दुई, को लाय दिवस हेड़ासे। अखीन ईमानदार अना बैईमान, धरमी-अधरमी दुई पर बादर- पानी बरसासेस। ");
INSERT INTO pwr_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","कासेकी अदी तुम्हि अपरो लक माया राखन वारा, लक माया राखने । ता तुमरो लाई का फर होयेत? का बरगन लेवन वारा भी असो नही करेत। ");
INSERT INTO pwr_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","अदी तुमी केवल अपरो भाऊ ला नमस्कार करो। त कौनतो मोठो काम करीसेव? का गैरयहुदी भी असो नही करासेत। ");
INSERT INTO pwr_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","एकोलाय तुमी सिध्द बनो। जसो तुमरो सरग को परमेस्वर बाबूजी सिध्द से। ");
INSERT INTO pwr_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","तूम्हि होसियार रव्हने, मानूसगिन ला दिसान काजी, नेकी को काम नोको करो। नही ता अपरो परमेस्वर बाबूजी लक सरग मा काही भी फर नही पावने। ");
INSERT INTO pwr_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","जबा तुम्हि दान करने, ता आपरो पूढा तुर्रा बाजा नोको बजाओ, जसो कपटीगीन पिराथना घर सभा अना गल्ली मा करा सेत। जोन लक लोकगीन वोकी बड़ाई करेत। मी जसो तुमरो लक खरो सांगासू का, वय अपरो करनी को फर पाय चुकेत। ");
INSERT INTO pwr_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","पर जबा तु दान करजोस, त जो तोरो उज्जो हात करेत, उ तोरो डाखिया हात ला मालूम नही पडहेति। ");
INSERT INTO pwr_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","जोन लक तोरो दान लुको रहेत, अना तबा तोरो बाप चुपचाप मा चोवसे तोला करनी को फर देहे। ");
INSERT INTO pwr_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","जबा तुम्हि पिरथना करने, ता बगला भगत को जसो नोको करने। कासेकी लोकगीन ला चोवन लाई, पिराथना घर मा अना रास्ता, चौगड्डा मा ऊभा होयके, पिराथना करनो, चहेतो लगासे, मी तुम्हिला खरो सांगासू, का वय अपरो करनी को फर पाय लेहेत। ");
INSERT INTO pwr_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","पर जबा तुम्हि पिराथना करने, ता अपरी खोलीमा जायके, अना घर को किवाड़ लगायके अपरो परमेस्वर बाबूजी लक एकांत मा पिराथना करने, तबा तुम्हरो बाबूजी परमेस्वर जोन एकलो मा चोवासे, उ तुम्हिला करनी को फर देहे। ");
INSERT INTO pwr_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","तूम्हि पिराथना करतो बेरा मा गैर-यहूदिगीन लोकगीन को जसो बक-बक नोको करने वय समजासेत का लंबी-लंबी पिराथना करनो लक उनकी पिराथना आयकि जाहे। ");
INSERT INTO pwr_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","एकोलाय तुम्हि उनको जसो नोको बनने काहेका तुम्हरो परमेस्वर बाबूजी तुमरो माँगन को पुढ़ा जानासे का तुम्हि ला काजक-काजक चीज गीन की जरुरत से। ");
INSERT INTO pwr_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","एकोलाय तुम्हि लोक गीन असो रित लक पिराथना करने, ओ आमरो परमेस्वर बाबूजी तू जोन सरग मा सेव तोरो नाव पवीतर मानो जाय। ");
INSERT INTO pwr_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","अखीन तोरो राज आय, तोरो मनसा जसो सरग मा पूरो होवासेत वसोच धरती मा पूरो होहे, ");
INSERT INTO pwr_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","आमरो दिवस भर को जेवन आज अमीला देव, ");
INSERT INTO pwr_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","अना जसो हमिना अपरा बूरो करन वारा ला छिमा करीसेजन, वसोच तु भी हमरो बुराई ला छिमा कर। ");
INSERT INTO pwr_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","अना हमला परिक्सा मा नोको डाख, पर बुराई लक बचाव, काहेकि राज् अना मोठयो ताकत अना महिमा हमेसा तोरो रहेत। ");
INSERT INTO pwr_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","एकोलाय अदी तुमी मानूस को अपराध ला छिमा करने , ता तुम्हरो सरग को परमेस्वर बाबूजी भी तुम्हिला छिमा करेत। ");
INSERT INTO pwr_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","अना अदी तुमी मानूस गीन को अपराध छिमा नही करने, ता तुम्हरो बाबूजी परमेस्वर भी तुम्हरो अपराध ला छिमा नही करहेत। ");
INSERT INTO pwr_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","जबा तुमी उपास करहो, ता बगला भगत गिन जसो तुमरो टोन्ड पर उदासी नही छाय रव्हे, काहे का वय आपरो टोन्ड उतारके रहोसेत, एको लाई का लोकगीन उन ला उपासी जानेत। मि तुम लक खरो कहुसेऊ की वय आपरो ईनाम पाय चुकीन। ");
INSERT INTO pwr_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","पर जबा तु उपास करजोस ता आपरो डोस्की पर तेल मलन अना टोन्ड धोयके रव्हजोस। ");
INSERT INTO pwr_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","ताकि लोक नही पर तोरो बाप जो छुपयो मा से तोला उपासी जाने। यो दसा मा तोरो बाप जो छुपयो मा देखासे, तोला फर देहेत। ");
INSERT INTO pwr_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","आपरो लाई धरती मा तिजोरी मा धन जमा नोको करोह जिता कन कीड़ा अना काई बिगाड़सेत, अना जिता चोर सेंध लगावसेत अना चुरावसेत। ");
INSERT INTO pwr_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","पर आपरो लाई सरग को तिजोरी मा धन इकठ्ठा करोह। जिता न ता कीडा अना न काई बिगाड़ा सेत, अना जिता चोर न ताका करासेत अना चुरा नही सकेत। ");
INSERT INTO pwr_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","काहे क जिता तोरो तिजोरी मा धन सेत उता तोरो मन भी लगयो रहेत। ");
INSERT INTO pwr_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","तन को दियो डोरा सेत, एको लाई अदी तोरो डोरा साफ सेत ता तोरो सप्पा तन भी उजाड़ो होयेत। ");
INSERT INTO pwr_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","पर यदि तोरो डोरा बुरो सेत, ता तोरो सप्पा तन भी ईंधारो होहेत। एकोलाय वा उजाड़ो जोन तोरो मा से अदी इंधारो होहेत, ता वा इंधारो कसो मोठो होहेत। ");
INSERT INTO pwr_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","कोनी भी गुलाम मानूस दुई मालीक को सेवा नही कर सकासे। काहेका उ एक लक बइर अखीन दुसरो को संग माया राखेत। अना एक लक गाढोपन अना दुसरो ला नीच जानेत। तुमी परमेस्वर अना धन दुही की सेवा नही कर सकासो। ");
INSERT INTO pwr_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","एको लाई तुमी आपरो जान लाई यो चिंता नोको करने की आमी का खावबीन अना का पीवबीन। अना आपरो तन लाई का काजक पहरबीन, का जान जेवन लक, अना देह लक, कपरा बड़के नाहत? ");
INSERT INTO pwr_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","बादल का पकसी ला चोवो। वय ना ता बोवासे, ना च कापासे, अना ना च खरीयान मा जमा करासेत, मंग उनको सरग को परमेस्वर बाबूजी उनला खिलावासे। का तुम्हि उन लक लगत कीमती नही सेव? ");
INSERT INTO pwr_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","तुम्हि मा लक कोन से, जो चिन्ता करके आपरी उमर मा एक घडी भी बढाय सकासे? ");
INSERT INTO pwr_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","अना कपरा लाई काहे चिन्ता करासो? जंगल का फुल पर मन लगावो का वय कसा बढ़ासेत वय न तो मेहनत करासेत, न कापासेत। ");
INSERT INTO pwr_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","एतरो मा भी मि तुम लक कव्हसु का राजा सुलेमान भी, आपरो महिमा सप्पा धन माया मा उनमा लक कोनी को जसो कपरा नही डाकयो होतो। ");
INSERT INTO pwr_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","एकोलाय जबा परमेस्वर बर्रा की गवथ ला, जो आज से अना काल स्तो की भट्टी मा झोकी जाहे, असो कपरा पहिनासे, ता हे कच्चो भरोसा वालो, तुमी ला उ उन लक बड़के, काहे नही पहिनाहे? ");
INSERT INTO pwr_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","एको लाई तुमी चिन्ता करके यो नोको कव्हना, की आमी का जेवबीन, अना का पीवबीन, या का घालबीन। ");
INSERT INTO pwr_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","काहे का गैरयहुदीगीन यो सब चीज को खोज मा रव्हासेत। पर तुमरो सरग को परमेस्वर बाबूजी जानासे, की तुमला यो सब चीज गीन की जरुरत से। ");
INSERT INTO pwr_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","एको लाई पूढ़ा तुमी परमेस्वर की राज अना ओको न्याय की खोज करोह ता या सब चीज भी तुम ला मिल जाहेत। ");
INSERT INTO pwr_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","अता काल की चिन्ता नोको करो। काहे का काल का दिवस आपरी चिन्ता आप कर लेहे। अज को लाई अज को दुख लगत से। ");
INSERT INTO pwr_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","दोस नोको लगावो, जेनको लक तुमरो पर भी दोस लगायो जाहेत। काहेकी, ");
INSERT INTO pwr_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","जोन रीती लक तुमी दोस लगावासो, ओनोच रीती लक तुम पर भी दोस लगायो जाहेत, अना जोन पायली मा तुमी नापासेव, ओनोच पायली लक तुमला भी नापो जाहेत। ");
INSERT INTO pwr_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","जबा तु आपरो भाऊ को डोरा को तिनका ला चोवासेस, तोला आपरो डोरा को लठ्ठा तोला नही सुजासे? ");
INSERT INTO pwr_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","जबा तोरी च डोरा मा लठ्ठा से, ता तु आपरो भाऊ लक कसो कव्ह सकासेस, आन मि तोरो डोरा लक तिनका हेड़ देवासू? ");
INSERT INTO pwr_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","हे कपटी पुढ़ा आपरो डोरा मा लक, लठ्ठा हेड़ ले, तबा तु आपरो भाऊ की डोरा लक तिनका साजरो रिती लक चोयके हेड़जोस। ");
INSERT INTO pwr_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","पवीतर चीज कुतरा गीन ला नोको देव, अना आपरो मोती खालमानी को पुढा नोको डाको, असो नोको होय की वय उन ला पाय खाल्या खुँदेत अना पलट के तुमला फाड़ डाकेत। ");
INSERT INTO pwr_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","माँगो ता तुमला दियो जाहेत ढुँढो ता तुमी पाहो। खटखटाओ ता तुमरो लाई उघाड़ो जाहेत ");
INSERT INTO pwr_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","काहे का जो कोनी माँगासे, ओला मिलासे, अना जोन ढुँढासे, वोला भेटा सेत, अना जो खटखटावसे, ओको लाई उघाड़ो जासे। ");
INSERT INTO pwr_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","तुमी मा लक असो कोन मानूस से, का अदी ओको टूरा ओला भाकर माँगासे, ता उ ओला पथरा देसे? ");
INSERT INTO pwr_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","अना मसरी माँगासे, ता ओला सरप देसे? ");
INSERT INTO pwr_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","अता जबा तुमी बुरो होयके, आपरा लेकरा ला साजरी चीज देवासो, ता तुमरो सरग को परमेस्वर बाबुजी आपरो माँगन वालो ला साजरी चीज काहे नही देहे? ");
INSERT INTO pwr_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","योको लाई जो काही तुमी चाव्हसो की मानूस तुमरो सँग करे, तुमी भी उनको सँग वसोच बरताव करो, काहे का पवीतर गिरंथ अना मोसे को नियम अना भविस्यवक्ता गीन की सिक्सा याच से। ");
INSERT INTO pwr_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","सकड़ो बेसकुड़ लक जाव, काहेका चकरो से उ बेसकुड़ अना सिधो से उ रस्ता जोन नास कन जावासेत। अना लगत सा लोक सेत, जोन ओना रस्ता लक जावासेत। ");
INSERT INTO pwr_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","काहेका सकड़ो से उ बेसकुड़ अना कठिन से उ रास्ता जोन, जिंदगी कन पहुचासे। अना जरासा लोक सेत, जोन ओला भेटासेत। ");
INSERT INTO pwr_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","खोटो भविस्यवक्ता गीन लक होसियार रव्हने, जोन साजरा कपरा घाल के मेढा को हुलीया मा तुमरो जवर आवासेत, पर भीतर लक फाड़न वारा बिघा को जसो सेत। ");
INSERT INTO pwr_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","उनको फर लक तुमी उन ला चिन्ह लेहो, का लोकगीन झाड़ी लक अंगूर, अना काँटादार झाड़ लक अँजीर तोड़ासेत ? ");
INSERT INTO pwr_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","यो रीती लक साजरो झाड़ साजरो फर आनासे, अना निकम्मो झाड़ निकम्मो फर आनासे। ");
INSERT INTO pwr_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","साजरो झाड़ बुरो फर नही आन सका, अना निकम्मो झाड़ साजरो फर नही आन सका। ");
INSERT INTO pwr_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","जोन-जोन झाड़, साजरो फर नही आनासे, उ कापके स्तो मा डाकयो जाहे। ");
INSERT INTO pwr_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","येना रिती लक उनको फर लक, तुमी उन ला चीन्ह लेहो। ");
INSERT INTO pwr_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","जोन मोला हे पिरभु, हे पिरभु! कव्हसे, उनमा लक हरेक सरग को राज मा नही जाय सकत। पर जोन मोरो, परमेस्वर बाबूजी को मरजी लक चलासे, उ जाय सकासेत। ");
INSERT INTO pwr_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","ओनो दिवस मा मोला लगत सा लोक गीन कहेत, हे पिरभु हे पिरभु, का आमी ना तोरो नाव लक आवन वारो गोस्टी नोको सांगो? अना तोरो नाव लक बुरो आतमा भूत-पलित ला नही हेडिया? अना तोरो नाव लक लगत सा ताकत को काम नही करियो? ");
INSERT INTO pwr_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","तबा मि उन लक सपा-सपा मना कर देहुँ, अना सांगू, अरे, बुरो करम करनवालो, मोरो जवर लक चली जावो मी तुमीला नही जानासू। ");
INSERT INTO pwr_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","एकोलाय जो कोनी मोरो गोस्टी ला आयक के मानासे, उ वा अक्कलवर मानूस जसो से, जेना आपरो घर ला गोटा पर बनावासे। ");
INSERT INTO pwr_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","अना बरसात भई पूरा आई, अना आंधड चली अना उ घर लक टक्कराई मंग नही पड़यो, काहेका ओकी पाया गोटा मा डाकी गई होती। ");
INSERT INTO pwr_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","पर जो कोनी मोरी गोस्टी ला आयकसे अना उन पर नही चलासे, उ वोना मानूस को जसो से, जोन आपरो घर रेत पर बनावासेत। ");
INSERT INTO pwr_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","अना पानी बरसयो, अना पूरा आई, अना आँधड़ चली, अना ओना घर लक टक्कराई अना वा घर पड़के सत्यानास भई गई। ");
INSERT INTO pwr_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","जबा यीसु या गोस्टी कह चुकयो, ता असो भयो की भीड़ ओको सिक्सा लक चकित भय गईन। ");
INSERT INTO pwr_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","काहेकि उ उनको मोसे को नियम को गुरू जसो, नही पर अधिकारी जसो उनला सिक्सा देवत होतो। ");
INSERT INTO pwr_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","जबा उ ओनो पहाड़ लक खाल्या आयो, ता एक मोठी भीड़ ओको मँघा भय गई। ");
INSERT INTO pwr_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","अना एक कोढ़ी ना जवर आयके ओला हात जोड़ के नमस्कार करीस अना कहीस, ओ पिरभु! अदी तु चाव्हासेत, ता मोला साजरो कर दे। ");
INSERT INTO pwr_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","एतरो पर यीसु ना अपरो। हात बढायके ओला छीइस, अना कहीस, मि चाव्हुसु! तु साजरो भई जाय, अना उ गदने कोढ लक साजरा भय गयो। ");
INSERT INTO pwr_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","यीसु ना ओला कहीस, कोनी लक नोको कव्हजोस! पर मंदिर मा जायके आपरो आप ला याजक ला दिखावजोस, अना जसो पवीतर गिरंथ मा भेट चढावा मोसे भविस्यवक्ता ना तय करीसेस ओला चढावजोस, एको लाई की लोकगीन पर पूरुप मजे गवाही भई जाहेती। ");
INSERT INTO pwr_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","जबा यीसु कफरनहुम नगर मा आयो। ता एक सुबेदार ना ओको जवर आयके ओको लक पिराथना करीस। ");
INSERT INTO pwr_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","हे पिरभु! मोरो दास घर मा लकवा को बीमारी लक लगत दुख मा सेत। ");
INSERT INTO pwr_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","यीसु ना कहीस “चल मि आयके ओला साजरो करासू” ");
INSERT INTO pwr_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","सुबेदार ना जवाब देइस की ओ पिरभू! मी यो लायक नही सेउ का तु मोरी घर को छत को खाल्या आवजोस, ओ पिरभु तू तो इता लक सांग दे, ता मोरो दास साजरो भय जाहे। ");
INSERT INTO pwr_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","काहे का मि भी अधिकारी सेऊ सरकार को नौकरी करासु अना सिपाई मोरो बस मा सेति जबा मि एक ला कव्हसु जाय। ता उ जासे अना दुसरो ला, आव! ता उ आवासे अना जबा आपरो दास लक कव्हसु, यो कर! ता उ करासे। ");
INSERT INTO pwr_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","यो आयक के यीसु ला अचंभा भयो, अना जोन ओको मंघा होतीन, उन लक कहीस, मि तुमला ला खरो कव्हसु की मिना इसरायल देसमा असो बिस्वास नही पायो। ");
INSERT INTO pwr_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","अना मि तुमी लक कव्हसु, की दिवस उगती अना दिवस बुड़ती लक लगत सा लोक आयके अबराहम अना इसहाक अना याकूब को संग सरग को राज मा बसेत। ");
INSERT INTO pwr_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","पर राज की संतान बाहेर इंधारो मा डाक दियो जाहे उता रोनो अना दाँत को पीसनो होहे। ");
INSERT INTO pwr_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","तबा यीसु ना सुबेदार लक कहीस, जाय! जसो तोरो बिस्वास से वसोच तोरो संग मा होहे। अना ओको दास ओनोच घड़ी मा साजरो भय गयो। ");
INSERT INTO pwr_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","यीसु जबा पतरस को घर मा आयो, तबा ओकी सासु ला बुखार धरयो होतो। ");
INSERT INTO pwr_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","ओना ओला हात लक, छीइस अना ओको बुखार उतर गयो। अना वा उभी होय के, ओकी सेवा करन लगी। ");
INSERT INTO pwr_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","जबा झुलाखाली भई तबा ओको, जवर लगत सा लोकगीन ला आनीन। जिनमा भुत-पलित होतिन अना, बीमार ला ओना हुकूम देक साजरो करीस। ");
INSERT INTO pwr_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","एकोलाय जोन गोस्टी यसायाह भविस्यवक्ता कन, लक पवीतर गिरंथ मा लिख्यो से पूरो भयो का “ओना आपच आमरी कमजोरी ला ले लेइस, अना बीमारी ला उचल लेईस।” ");
INSERT INTO pwr_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","यीसु ना जबा आपरो आप ला भीड़ लक घीरो चोवके, उ झील को ओनांगन जावन की हुकूम देईस। ");
INSERT INTO pwr_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","तबा एक मोसे को नियम को गुरू ना ओको जवर आयके कहीस, हे गुरुजी! जिता-जिता तू जाजोस उतच-उतच मि तोरो सगं आहुँ। ");
INSERT INTO pwr_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","यीसु ना उन लक कहीस, कोल्हिया गीन को लाय खोदरा अना बादल का पकसी गीन को बसेरा होवासेत पर मानूस को टूरा लाई डोस्की राखके अराम करन को जघा नहात। ");
INSERT INTO pwr_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","एक अखीन चेला ना ओला कहीस, हे पिरभु मोला जावन दे, का आपरो बाप ला गड़ाय देहुँ। ");
INSERT INTO pwr_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","यीसु ना ओला कहीस, तु मोरो मंघा भय जाय, अना मुरदा ला आपरो मुरदा गाड़न दे। ");
INSERT INTO pwr_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","जबा उ नाव पर चघयो, ओको चेला मंघा भय गईन। ");
INSERT INTO pwr_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","अना देखो झिलमा एक मोठो आँधड़ उठयो। अना नाव लहर लक ढकन लगी। मगं उ जपमा होतो। ");
INSERT INTO pwr_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","तबा चेला ना ओला जगाईन। अना कहिन, हे पिरभु हमला बचा व हम मर जाबीन। ");
INSERT INTO pwr_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","ओना कहीस, अरे कच्चो भरोसा कमजोर बिस्वासवारा! काय ला डरावसो? तबा आँधी अना पानी ला डाटन लगिस, ता सफा उगा-मुगा भय गईन। ");
INSERT INTO pwr_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","अना वय अचंभा भयके कहिन, यो कसो मानूस से का आँधड़ अना, पानी एको हुकूम मानासेत। ");
INSERT INTO pwr_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","जबा ओनागन गदरनियो को देस मा पहुँचीन, ता दुई मानूस जिनमा भुत-पलित झोमी होती, मरघट्टी लक हिटके ओला भेटिन वय एतरो ताकत वर होतीन, का ओ रास्ता लक कोनी नही जा सकत होतीन। ");
INSERT INTO pwr_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","वय हाकल के कहिन, ओ परमेस्वर को टूरा, आमरो लक तोरो काजक काम से? का तु बेरा को पयले, अमीला, दुख देवन आईसेस? ");
INSERT INTO pwr_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","उनको लक काही दुहुर पर एक खालमानी की हेड़ चरत होती। ");
INSERT INTO pwr_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","बुरो आतमा ना उन लक यो कहके पिराथना करीन, का तु हमला हेड़ासेस, ता खालमानी को हेड़ मा धाड़ दे। ");
INSERT INTO pwr_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","ओना उनला हुकूम देइस, तबा वय हिटके खालमानी मा धस गईन। अना चोवो सप्पा, हेड़ जोर लक झपट के पानी मा चली गयो। ");
INSERT INTO pwr_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","उनको चरान वारा, पराय के नगर मा यो गोस्टी ला साँगीन, जिनमा भुत-पलित होतीन उनको सप्पा हाल आयकावईन। ");
INSERT INTO pwr_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","तबा सबच नगर का लोक गीन यीसु लक भेटन साठी हिट के गईन, अना ओला देखके पिराथना करीन, की हमरो देस लक चली जाय। ");
INSERT INTO pwr_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","मंग यीसु नाव मा चघके ओनागन गयो, अना आपरो नगर मा आयो। ");
INSERT INTO pwr_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","अना देखिन का लकवा वारा, ला खाट पर धरके ओको कठा आनीन। यीसु ना उनको बिस्वास देखके, लकवा को रोगी ला कहीस, अरे टूरा हिम्मत राख! तोरो पाप छिमा भईन। ");
INSERT INTO pwr_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","एको पर कई मोसे को नियम को गुरू ना सोचिन का यो तो परमेस्वर की निन्दा करासे। ");
INSERT INTO pwr_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","यीसु ना उनको मन की गोस्टी ला जानके कहीस, तुमी आपरो-आपरो मन मा बुरो बिचार कायलाई करासेव। ");
INSERT INTO pwr_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","सरल का से? यो कव्हनो का तोरो पाप छिमा भईन, अना यो कव्हना का उभो होय, अना चल फिर। ");
INSERT INTO pwr_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","पर एकोलाय तुमी जान लेव, का “मानूस को टूरा” ला धरती पर पाप छिमा करन को, अधिकार से, तबा ओना लकवा को रोगी ला कहीस, उभो होय! अना आपरी खाट ला उठाव, आपरो घर जाय। ");
INSERT INTO pwr_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","उ लकवा को रोगी उभो होयके, आपरो घर चली गयो। ");
INSERT INTO pwr_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","लोक असो देखके डराय गईन, अना परमेस्वर की बड़ाई करन लगीन, जेना मानूस ला असो अधिकारी ठहराईसेस। ");
INSERT INTO pwr_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","वहान लक लगत पुढा बढके यीसु न मत्ती नामको मानूस ला बरगन वसुली करन वालो चौबट्टा पर बसयो चोयो त वोको लक कहीस,“ मोरो मंघा भय जाव।” उ उभो होयके वोको मंघा भय गयो। ");
INSERT INTO pwr_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","जबा उ घर मा जेवन मा बसयो, ता लगत सा जमा वसूल करन वारो पापी आयके यीसु अना ओको चेला संग जेवन लाय बस गईन। ");
INSERT INTO pwr_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","असो देखीके फरिसी गीन ना ओको चेला ला कहिन, तोरो गुरूजी बरगन लेवन वारा अना पापी गीन को संग काय ला जेवन करासे? ");
INSERT INTO pwr_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","असो आयक के यीसु ना उनको लक कहीस, बईद साजरो लाई नही से, पर बीमार गीन लाई जरूरी से। ");
INSERT INTO pwr_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","एको लाई तुमी जायके एको अरथ सीक लेव। मि पुजा चढानो नही, पर दया चाहुसेऊ, काहे की मि न्यायी ला नही, पर पापी गीन ला बुलावन आईसेऊ। ");
INSERT INTO pwr_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","तबा योहन का चेला गीन ओको जवर आयके कहिन, का कारन से? आमी अना फरिसी एतरो उपास करासेत, पर तोरा चेला उपास नही करत। ");
INSERT INTO pwr_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","यीसु ना उन लक कहीस की जबा तकन बराती नवरदेव को संग मा रव्हासे , सोक कर सकासेत? पर वय दिवस आहेति जबा नवरदेव उनको लक अलग कियो जाहे। ओनो बेरा मा उपास करयेत। ");
INSERT INTO pwr_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","कोरो कपरा को नाड़ा जूनो कपरा पर कोनी नही लगाय सकत, काहे की उ नाड़ा ओ कपरा ला काही अखीन खीच लेवसे, अना उ लगत फट जासे। ");
INSERT INTO pwr_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","अना लोक नवा अंगूर को रस ला जुनो कुप्पा मा नही भरत, काहे का असो करन लक कुप्पा फट जासे, अना अंगूर को रस बह जासे अना कुप्पा नास भय जासे पर नयो अंगूर को रस नयो कुप्पा मा भरासेत अना वय दुही बचया रहोसेत। ");
INSERT INTO pwr_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","यीसु उन लक यो गोस्टी कर रहयो होतो। तबच एक समाज को मुखिया आयके दुई हात जोड़के नमस्कार करीस अना कहीस, मोरी टूरी मर गई। चलके आपरो हात ला ओको पर राख, ता वा जित्तो भयी जाहे। ");
INSERT INTO pwr_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","यीसु उभो होयके आपरा चेला गीन को संग मा, ओको मंघा चलन लगीन। ");
INSERT INTO pwr_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","एक बायको जोनको बारा बरस लक लाल धोवा जान की बीमारी होती। मंघा लक आयके ओको कपरा को कगर सेव ला छीव लेईस। ");
INSERT INTO pwr_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","काहे का वा आपरो मन मा कव्हत होती। अदी मि ओको कपरा ला छी लेहुँ ता साजरी भयी जाहुँ। ");
INSERT INTO pwr_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","यीसु ना मुरकके, ओला देखिस अना कहीस, अवो टूरी हिम्मत राख, तोरो बिस्वास ना तोला साजरो करीसेस। अता वा बायको ओनो बेरा मा साजरो भयी गई। ");
INSERT INTO pwr_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","जबा यीसु मुखिया को घर मा पहुचियो। अना बंसरी बजावन वारा अखीन, भीड़ ला हुल्लड़ करतो देखीस। ");
INSERT INTO pwr_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","तबा कहीस हट जाओ “टूरी मरी नही पर जप मा से।” एको पर ओकी हसी उडावन लगीन। ");
INSERT INTO pwr_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","पर जबा भीड़ हेड़ पर देईन, ता उ भीतर जायके टूरी पर को हात धरीस, अना वा जित्तो भय गई। ");
INSERT INTO pwr_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","अना या गोस्टी सप्पा देस मा फैल गई। ");
INSERT INTO pwr_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","जबा यीसु उता लक पुढ़ा बढ़यो, ता दुई अँधरा ओको मंघा असा हाकलत हुया आइन, ओ राजा दाऊद की संतान, आमरो पर रहम कर! ");
INSERT INTO pwr_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","जबा उ घर मा गयो, ता वय अँधरा ओको जवर आइन, अना यीसु ना उनको लक कहीस, का तुमला भरोसा से? का मि असो कर सकासु? उनना कहिन का हव पिरभु। ");
INSERT INTO pwr_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","तबा ओना ओको डोरा ला छीवके कहीस, तुमरो को भरोसा लक, तुमरो लाय होय जाय। ");
INSERT INTO pwr_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","अना उनका डोरा खुल गईन, अना यीसु ना उन ला चिता के कहीस, सतरक रव्हने, कोनी एना बात ला नोको जाने। ");
INSERT INTO pwr_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","पर उनना हिटके सप्पा देस मा साजरा बारता यस फैला देईन। ");
INSERT INTO pwr_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","जबा उ बाहेर जाय रहयो होतो, ता लोक एक मुका ला जेनको मा भुत-पलित होती, यीसु को जवर आनीन। ");
INSERT INTO pwr_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","जबा उ भूत-पलित अना बुरो आतमा ला हेड देइस, तबा मुका बोलन लगयो। एतरो पर भीड़ ना अचंभा करके कहीस, इसरायल देस मा असो कदीच नही चोवीसेव। ");
INSERT INTO pwr_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","पर फरिसी गिनना कहीन “यो ता सैतान को मुखिया को मदद लक बुरो आतमा भूत-पलित ला हेड़से।” ");
INSERT INTO pwr_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","यीसु सब नगर-गाँव मा फिरत होतो। अखीन सब पिराथना घर मा साजरो गोस्टी को मुनादी करत होतो करत होतो। अना राज को साजरो बारता आयकावत होतो। हर तरीका की बीमारी अना कमजोरी ला दुहुर करत होतो। ");
INSERT INTO pwr_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","जबा ओना भीड़ ला देखीस, ता ओला लोकगीन पर तरस आयो काहेका वय ओनो मेढा को जसो सेत। जिनको कोनी रखवालो नहाय। अना दुखी, भटको हुओ सेत। ");
INSERT INTO pwr_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","तबा ओना आपरा चेला गीन ला कहीस “खेत लगत पिकयो सेत, पर बनिहार जरा सा सेत। ");
INSERT INTO pwr_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","एकोलाय खेत का मालिक! पिरभु लक बिनती करो। का वय आपरो फसल ला कापन लाई बनिहार धाड़ेत”। ");
INSERT INTO pwr_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","तबा यीसु अपरा बारा चेला गीन ला, जवर हाकल के, उनला भूत-पलित ला हेड़न को हक देइस अना उ ताकत लक उनला हरेक बिमारी अना दुखला साजरा करन को हक देइस। ");
INSERT INTO pwr_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","वय बारा पेरीत गीन को नाव यो सेत। पहलो समौन जेनला पतरस कव्हासेत। अना ओको भाऊ अन्दिरयास, जबदी को टूरा याकूब, अना ओको भाऊ योहन ");
INSERT INTO pwr_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","फिलिप्पुस, अना बरतुल्मै थोमा अखीन बरगन लेवन वारा मत्ती, हलफई को टूरा याकूब अना तद्दै। ");
INSERT INTO pwr_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","सिमोन कनानी, अना यूदस इस्करियोति जेना वोला धरवायो होतो। ");
INSERT INTO pwr_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","यीसु ना वय बारा चेलागीन ला, यो हुकूम देके धाड़ीस। का “गैर यहुदी को घरमा नोको जाने, अना सामरी लोकगीन, को कोनी नगर मा धसनो। ");
INSERT INTO pwr_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","पर इसरायल को घरानो, की गुमो मेढा को जवर जाओ।” ");
INSERT INTO pwr_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","अना चलता-चलता यो गोस्टी करो, का सरग को राज जवर से। ");
INSERT INTO pwr_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","बिमारी ला साजरो करो, मरो हुवो ला जित्तो करो, कोढी ला साजरो करो, अखीन भूत-पलित बुरो आतमा ला हेड़ो, तुमी न फुकट मा पाइसेव, त फुकट मा देवो। ");
INSERT INTO pwr_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","अपरो पीवसी मा न ता खुरो मुदरो, सोनो अना न ता रुपया, अना न ता ताँबा राखो। ");
INSERT INTO pwr_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","रास्ता लाई कोनी जरुरत को जिनुस नोको ठेव। जसो झोला, दुई कुरता, न ता सेन्डिल, अना न ता लाठी राखना, जहान तुम ठैयर जोस वहान सब जिनुस मिल जाहेती, काहेकी बनिहार ला वोको, बनी मिलनो जरूरी से। ");
INSERT INTO pwr_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“जोन नगर या गाँव मा जाओ, ता पता लगाओ, का कोनी लायक सेत, उनको च याहान रव्हने, उता लक नोको हिटने। ");
INSERT INTO pwr_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","अना घर मा धसोतो-धसतो वोला असीस देवने। ");
INSERT INTO pwr_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","अदी वोको घर का लोक लायक होयेत, ता तुमरो सान्ती असीस उनला भेटे, पर अदी वय लायक नहात, ता तुमरो, असीस तुमरो जवर आई जाहे। ");
INSERT INTO pwr_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","जो कोनी तुमला नही रोकेत, अना तुमरी गोस्टी नही आयकेत, वोनो घर अना नगर लक हिटके, अपरो पाय की बारु झड़ाय लेवनो। ");
INSERT INTO pwr_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","मी तुमरो लक खरो कव्हसू, का न्याय को दिवस वोनो नगर की दसा लक, सदोम अना गमोरा देस की दसा, लगत सहन लायक होयेत।” ");
INSERT INTO pwr_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“चोवो! मी तुमला मेढा जसो, बिघा गीन को बीच मा धाड़सू। एकोलाय सरप जसो चतूर, अना परेवा जसो भोलो बनने।” ");
INSERT INTO pwr_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","पर लोकगीन लकन होसियार रव्हने, काहेका वय तुमला मोठि सभा मा सोपेत, अना अपरी पंचायत मा, तुमला कोड़ा मारहेत। ");
INSERT INTO pwr_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","तुमला मोरो लाई मालगुजार, अना राजा गीन को पूढा जानो पड़ेत जोन लक गैर यहूदी मा गवाही भई जाय, ");
INSERT INTO pwr_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","जबा वय तुमला धरायेत ता तुम्हिला काय सांगनो सेत, कसो कव्हनो सेत एको चिंता नोको करना। काहेका वोना बेरा तुम्हीला काय बोलनो सेत, सांग दियो जाहेत। ");
INSERT INTO pwr_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","हेत राखो, तुम्ही बोलनवारा नही सेव, “तर तुमरो परमेस्वर बाबूजी को आतमा तुमरो भितर लक बोलेत।” ");
INSERT INTO pwr_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“भाऊ-भाऊ ला अना बाप टूरा ला, मरवान लाई सोफेत, अना टूरा माय-बाप को बिरोध मा, उभो होयके उनला मरवा डाकेत।” ");
INSERT INTO pwr_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","“मोरो नाव को कारन सबच लोक गीन, तुमरो लक बैरी करेत। पर जो आखरी तकन धीरज धरेत, वोच बचायो जाहेत। ");
INSERT INTO pwr_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","जबा वय लोकगीन तुमला एक नगर मा परेसान करयेत, ता दुसरो नगर ला पराय जाना, मी तुमला खरो कव्हासू, तुमी इसरायल को सबच नगर मा हिन्ड नही सकेत, का मानूस को टूरा आजा हेत।” ");
INSERT INTO pwr_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“चेला अपरो गुरु लक मोठो नही होवत, अना दास अपरो पिरभु मजे मालिक लक। ");
INSERT INTO pwr_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","चेला को गुरू लक अना दास को, मालिक मजे पिरभु को बरोबर होवनो च, लगत से। जबा उनना घर को मालिक ला सैतान कहिन ता वोको घर को दुसरो लोकगीन लक तो अखिन बुरो बरताव करहेत।” ");
INSERT INTO pwr_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“एकोलाय भेव नोको खाव! जोन लुकयो सेत, उघड़ जाहेत। अना जोन काही छिपयो सेत, वा परगट होयेत।” ");
INSERT INTO pwr_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","“जो मी तुमला इंधारो मा सांग सू वोला तुमी उजाडो मा मुनादी करने अना जोन, कानो कान आयकासेव, वोला छत लक आयकावो।” ");
INSERT INTO pwr_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","“जोन तन ला मारसे उन लक नोको डराय जावो, पर वोला डराव जो आतमा ला मार सकासे अना आतमा अना तन दुहि ला नरक मा नास कर सकासे। ");
INSERT INTO pwr_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","का पैसा मा चिड़िया नही बिकासे? तब भी तुमरो परमेस्वर बाबूजी की इक्सा को बिना, उन मा लक एकात भी जघा पर, नही पड़ सकत। ");
INSERT INTO pwr_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","अरे तुमरो डोस्की का चुन्दी भी सप्पा गिनयो हुया सेत। ");
INSERT INTO pwr_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","एकोलाय नोको डराय जावो, तुमी लगत चिड़िया लक बड़के सेव।” ");
INSERT INTO pwr_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“जो कोनी मानूस को पुढा मोला अपना लेहत, वोला मी भी अपरो परमेस्वर बाप को पुढ़ा सरग मा अपना लेहुँ ");
INSERT INTO pwr_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","पर जो कोनी मानूस को पुढ़ा मोरो लक, मुकर जाहेत, वोको लक मी भी अपरो परमेस्वर बाबूजी को पुढा सरग मा, मुकर जाहिन।” ");
INSERT INTO pwr_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","असो नोको समजो का, मी धरती पर सान्ती-करान आईसेऊ। नही पर तरवार चलवान आईसेऊ। ");
INSERT INTO pwr_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","मी ता आई सेव का मानूस वोको बाबूजी लक, अना टूरी वोकी माय लक अना बहू वोकी सासू लक, बेगरो कर देहू। ");
INSERT INTO pwr_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","मानूस का बैरी ओको घरच का, लोग होहेत। ");
INSERT INTO pwr_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“जेनको माय अना बाप मोरो लक, लगत चहेतो सेत, वय मोरो काबिल नाहत। अना जोन, टूरा-टूरी ला मोरो लक लगत चाव्हासे वय मोरो लायक नाहत।” ");
INSERT INTO pwr_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","अना जोन आपरो कूरूस ला धरके दुख उचल के मोरो मंघा नही चलेत वय भी मोरो काबिल नाहत। ");
INSERT INTO pwr_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","उ जोन आपरो जान बचावन लो कोसीस करा से, वय ओला खोय देहेत, अना जो मोरो कारन आपरो जान खोवासे, ओला जिंदगी मिलहे। ");
INSERT INTO pwr_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“जो तुमरो सतकार करासेत, उ मोरो सतकार करासेत। अना जोन मोरो सतकार करासेत, वय मोरो धाड़न वारा को सतकार करासेत। ");
INSERT INTO pwr_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","जोन लोक गीन भविस्यवक्ता ला, भविस्यवक्ता जानके सतकार करासेत, वय भविस्यवक्ता को बदला पाहेत अना जो नेक मानूस ला नेक जानके सतकार करासेत वय नेकी को बदला पाहेत। ");
INSERT INTO pwr_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","कोनी लोक गीन एना नहानसो मा लक, मोरो चेला जान के बस एक गिलास थन्डो पानी पिलाहे। मी तुमला खरो कव्हासू, उ काही रीती लक आपरो ईनाम नही खोहे।” ");
INSERT INTO pwr_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","आपरो बारा चेला गीन, ला हुकूम देवन को मघा यीसु वहान लक हीट गयो। गलील छेतर को नगर-नगर मा परचार करन लगयो। ");
INSERT INTO pwr_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","योहन ना जेल मा यीसु मसीह को काम की गोस्टी आयकिस, अना आपरो चेला गीनला वोको लक, यो पूसन ला धाड़िस ");
INSERT INTO pwr_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","का आवनवालो तूच से का आमी दुसरो, को रस्ता चोवोबिन? ");
INSERT INTO pwr_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","यीसु ना जवाब देइस जो काही तुमीना, आयकीसेव अना चोयोसेव सबा जायके योहन लक सांगो। ");
INSERT INTO pwr_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","का अँधरा चोवासे लंगडो चलासे। कोढी गीन साजरो होवासे अना भैरा आयकसे, मुरदा जित्तो होवासे। अना गरिब गिनला साजरो बारता आयकोवासेत। ");
INSERT INTO pwr_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","अना धन्य “किस्मत वारा से” उ जोन मोला अपनावा सेत। ");
INSERT INTO pwr_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","जबा वय वहान लक चले गइन तबा यीसु योहन को बारेमा सागन लग्यो। जंगल मा तुमी काजक चोवन आयो सेव? घागरा गवथ ला? जोन वारा मा हिला सेत। नहीं! ");
INSERT INTO pwr_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","मंग तुम्ही काजक चोवन आयीसेव? का एक मानूस ला जोन साजरो झंगा घालासेत? असो मानूस तो राज भवन मा च रव्हासेत। ");
INSERT INTO pwr_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","मंग काजक लाय आयो सेव? का कोनी भविस्यवक्ता ला चोवन आयो सेव? हव मि तुमी लक कव्हसू, का भविस्यवक्ता लक मोठयो सेत ला। ");
INSERT INTO pwr_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","यो वोच मानूस से, जोनको बारेमा असो गिरंथ मा लिख्यो से “चोव! मी आपरो दुत ला तोरो पुढा धाड़ासू। जोन तोरो लाई रस्ता तैय्यार करयेत।” ");
INSERT INTO pwr_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","“मि तुमी लक खरो-खरो सागांसू, योहन बप्तिस्मा देवन वालो लक कोनी मोठो मानूस जलम नही लियो सेत। मंग सरग को राज मा सब लक, लहान मानूस योहन बप्तिस्मा देवनवारो लक मोठो सेत। ");
INSERT INTO pwr_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","योहन बप्तिस्मा देवन वालो को दिवस लक, अबा तकन सरग को राज भयानक लड़ाई झेलत आयो से, अना हिन्सा को ताकत लक एला हिसकन को कोसीस चालू सेत।” ");
INSERT INTO pwr_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","योहन बप्तिस्मा देवन वारो तकन सारो भविस्यवक्ता अना मोसे को नियम, आवन वालो गोस्टी को बारेमा सांग्यो होतो। ");
INSERT INTO pwr_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","अना अदी तुम्ही मोसे को नियम अना भविस्यवक्ता गीनना जो काही कह्यो होतो वोला अपनान तैयार सेव, जोनको आवन को बारेमा कह्यो होतो यो योहन वोच एलिय्याह से। ");
INSERT INTO pwr_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","यो गोस्टी ध्यान धरके आयको। ");
INSERT INTO pwr_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“आज को जुग को लोकगीन को बरोबरी कोन लक करू? वय असो लेकरा को जसो सेत, जोन हाटमा बसके एक दुसरो लक हाकल के कव्हासे। ");
INSERT INTO pwr_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","अमिना तुम्हारो लाय बंसरी बजायो अखीन तुमी नही नाचयत! अमीना सोक को गाना गायो, अना तुम्ही नहीं रडयो।” ");
INSERT INTO pwr_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","काहे की योहन बप्तिस्मा देवन वालो आयो, जोन ना जेवत होतो, अना काही पिवत होतो, लोक वोला कव्हत होतिन, एकोमा बुरो आतमा से। ");
INSERT INTO pwr_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","“मंग मानूस को टूरा आयो, जोन सबको जसो जेवन करा सेत, तरी वय लोक कव्हासेत। चोवो! यो अघोरी गजब खावन-पीवन वारा मानूस, अना बरगन लेवन वारा, अना पापी गीन को संगी सेत।” तरी काम लक अक्ल सहीमा कसो सेत पता चलासेत। ");
INSERT INTO pwr_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","मंग यीसु उन नगर ला धिक्कारन लगिस जोन मा वोना अदभुत काम करयो होतो। काहेका वोनो नगर का लोकगीन पाप करनो नही सोड़यो होतो, अना आपरो मनला नही बदलो होतीन। ");
INSERT INTO pwr_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","अरे अभागो खुराजीन नगर, अरे अभागो बैतसैदा नगर तुम्ही मा जोन अचरज को काम कियो गयो सेत। अदि नास कियो नगर, सुर अखीन सैदा मा होत्यो। त वहान की जनता, रड़त-रड़त गम मनाय के, कबा लक पाप लक मन ला हटाय लेई होतिन। ");
INSERT INTO pwr_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","पर मी तुमरो लक सागसू, का न्याय को दिवस, नास कियो नगर सुर अना सैदा को जसो हाल भयो होतो, अबा वोको लक ज्यादा खराब दसा ऐना नगर की भई जाहेत। ");
INSERT INTO pwr_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","हे कफरनहुम नगर! का तू सरग लक, वरता करयो जाहेत? नही तु तो पताल लक जादा धस जाहेत। काहेका, जोन ताकत को काम तोरो, अँदर मा कियो गयो से। वोच काम सदोम नगर मा करयो, जातो ता उ आज तकन बनयो रव्हतो। ");
INSERT INTO pwr_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","पर मी तुम लक कव्हासू, का न्याय को दिवसमा इनको हाल सदोम अना गमोरा देस लक जादा बूरो भई जाहेत। ");
INSERT INTO pwr_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","वोच बेरा यीसु ना कव्हयो परमेस्वर बाबूजी सरग, अना धरती को पिरभु, मी तोरो धनवाद करासू, का तूना यो गोस्टी ला अक्कलवर अना समजदार लोकगीन लक, लूकाईसेस अना लेकरागिन पर परगट करयो से। ");
INSERT INTO pwr_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","हे परमेस्वर बाबूजी तोला असोच साजरो लगिसेस। ");
INSERT INTO pwr_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","मोरो परमेस्वर बाबूजी मोला, सब काही भेटयो से, अना टूरा ला कोनी नही जानासे, बस परमेस्वर बाबूजी, अना परमेस्वर ला कोनी नही जानासे, बस टूरा! अना टूरा जोन पर परगट करवानो, चाव्हासे वा परमेस्वर लक भेट कर सकासे। ");
INSERT INTO pwr_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","ओ! सब मेहनत करन वारा, बोझा को खालया दबो लोकगीन, मोरो कठा आओ मि तुमला चैन देहू। ");
INSERT INTO pwr_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","मोरो जुआड़ी आपरो पर धरलो अना मोरो लक सीको। काहेका मी आतमा मा नरम, अना मन को गरीब सेव तबा तूमी आपरो मन मा चैन पावने। ");
INSERT INTO pwr_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","काहेका मोरो जुआड़ी सरल अना मोरो बोझा हलको से। ");
INSERT INTO pwr_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","वोना बेरा बिसराम दिवस मा यीसु, चेला गिनको संग खेत लक होयके, जावत होतिन। अना चेला गीनला भूख लगी। अना वय गहुँ को बाल तोड़के खावन लगीन। ");
INSERT INTO pwr_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","फरिसी अना मोसे को नियम को गुरूगिन ना यो चोवके, वोको लक कहिन “चोव! तोरो चेलागिन वा करासेत जोन बिसराम दिवस मा मोसे को नियम अनुसार करनो साजरो नाहत।” ");
INSERT INTO pwr_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","एको पर यीसु उनला पुसीस, काय तुम्हिना नही बाचीसेव? का राजा दाऊद अना वोको संगीगिन, भूखा होतिन। तो काजक करीन? ");
INSERT INTO pwr_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","उ कसो परमेस्वर को घर मा गईन, अना चढवा को भाकर ला जेइन जबकि मोसे को नियम लक वोला याजक सोड़ कोनिला, जेवन को हक नाहत। ");
INSERT INTO pwr_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","काय तुमी पवीतर गिरंथ मा नही बाची सेव? का पवीतर दिवस, मा याजक मंदिर मा मोसे को नियम अना विधि-विधान ला तोड़न पर, भी पापी नही ठहरासे। ");
INSERT INTO pwr_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","पर मी तुमी लक कव्हसू, यहान पर जोनसे, उ मंदिर लक मोठयो से। ");
INSERT INTO pwr_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","अदी तुमी ला एको मजे मालुम होत्यो “मी पुजा चघानो लक खुसी नही होवासू, पर दया लक खुसी होवासू। त तुमी बेकसूर ला पापी नही ठयरायोसेत। ");
INSERT INTO pwr_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","मानूस को टूरा तो पवीतर दिवस को भी पिरभु से।” ");
INSERT INTO pwr_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","यीसु वहाँन लक चलके ना उनको, पिराथना घर मा आयो। ");
INSERT INTO pwr_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","उता एक मानूस होतो जेनको हात सूक गयो होत्यो उनना यीसु पर दोस लगावन लाई पुसिन, काय मोसे को नियम लक पवीतर दिवस मा बिमार ला साजरो करनो खरोसे? उनना यीसु ला यो काजी पुसियो होतिन, का वय वोला दोसी साबीत करे। ");
INSERT INTO pwr_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","वोना उनला सांगिस तुमरो मा असो कोन सेत? जोनको, एकच मेढा होय, अना वा बिसराम को दिवस मा खोदरा, मा पड़ जाय, मंग तुम्ही वोला धरके बहार नही कहाड़ेत? ");
INSERT INTO pwr_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","अता तुमच मोला सांगो, मानूस मेढा लक कितरो किमती से? एकोलाय पवीतर दिवस, मा मोसे को नियम लक भला करनो साजरो से। ");
INSERT INTO pwr_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","तबा यीसु ना उ मानूस ला कव्हयो, “आपरो हात बढा वोना आपरो हात बढाईस अना वा हात भी दुसरो, हात जसो भई गयो।” ");
INSERT INTO pwr_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","एको पर फरिसी गुरूगिन पिराथना घर लक बाहेर हिटीन, वय यीसु ला मारन को बिचार करन लगीन। ");
INSERT INTO pwr_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","तबा यीसु न उनको मनकि बात जानके, वहान लक चली गयो अना लगत लोकगीन वोको मघा भई गईन अना वोना सबला साजरो कर देईस। ");
INSERT INTO pwr_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","अना उनला असो हुकूम देइस, का मी तूमला साजरो करीसेव यो बात कोनिला नोको साँगजोस। ");
INSERT INTO pwr_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","असो भविस्यवक्ता यसायाह को कव्हनो, पूरो भयो। ");
INSERT INTO pwr_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“आयको! एला मिना बेची सेव यो मोरो चहेतो दास आय, मी एकोलक गजब खुस सेव, मी वोको पर आपरो आतमा डाखू अना, उ गैर यहुदी मा सहि न्याय को बारे मा सागेत। ");
INSERT INTO pwr_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","यो न तो बैस करयेत अना हाकलेत, अना कोनी चौबट्टा कन एको आवज आयकु आयत। ");
INSERT INTO pwr_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","यो ना तो कुचलो हुओ घागरा गवथ ला तोड़ेत अना, न इझतो दियो ला इझाएति बुझाहेती, जब तकन न्याय ना भई जाये।” ");
INSERT INTO pwr_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","“वोको नाव मा सप्पा गैरयहुदी को लोक गीन भरोसा राखेत।” ");
INSERT INTO pwr_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","तबा लोकगीन एक अँधरा, गुंगो, भुत-पलित झोमयो, मानूस ला, वोको जवर आनीन, यीसु ना वोला साजरो कर देइस। अना उ गुंगो बोलन अना चोवन लग्यो। ");
INSERT INTO pwr_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","एको मा सब लोकगिन ला लगत अचरज भयो अना वय कव्हन लगीन “का यो मानूस दाऊद को टूरा से” ");
INSERT INTO pwr_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","जबा फरीसि गिन यो आयकिन तबा कव्हन लगीन “यो ता बुरो आतमा को मुखिया, बालजबूल की मदद लक भूत-पलित ला हेड़से।” ");
INSERT INTO pwr_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","यीसु ला उनको विचार मालुम भय गयो। उ उनला बोलयो “हरेक वा राज जोनमा फूट होवासेत वा नास भयी जासे वसोच हरेक नगर अना घराना जोनमा फुट पड़ जासे वा नास भयी जासे।” ");
INSERT INTO pwr_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","तरी यदि सैतान च अपरो आपला बाहेर हेडे़त। तबा उ आपरो च विरोधी भय जासे, मंग ओको राज कसो बनो रहेत? ");
INSERT INTO pwr_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","भलो अदी मि बालजबूल बुरो आतमा की मदद, लक भूत-पलित ला हेड़ासू, ता तुमरो खानदान कोन की मदद लक हेड़ासे? एकोलाय वयच तुमरो फैसला करयेत। ");
INSERT INTO pwr_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","मी परमेस्वर को आतमा की मदद लक, भूत-पलीत बुरो आतमा ला हेड़ासू, ता बेसक परमेस्वर को राज तुमरो जवर आई गईसे। ");
INSERT INTO pwr_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","मंग असो कोनतो मानूस से जोन कोनी मोठयो पहलवान को घरमा धसके, ना वोला बिना हराये, अना बिना बान्धे वोको घर को माल लूट सकसे। ");
INSERT INTO pwr_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","जो मोरो संग नहात उ मोरो बिरोध मा सेत अना जोन बगरो मेंढा गीनला जमा करनो मा मोरी मदद नहीं करासेत वा उनला छितरान वारा से। ");
INSERT INTO pwr_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","यो साठी मि तुम लक कव्हसु “की मानूस को सप्पा पाप बिरोध अना निन्दा, छिमा कियो जाहेत, पर परमेस्वर को आतमा पवीतर आतमा की निन्दा छिमा नही कियो जाहेत।” ");
INSERT INTO pwr_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","“जोन कोनी मानूस को टूरा को विरोध मा बात कहे ओको अपराध छिमा कियो जाहे, पर जोन कोनी पवीतर आतमा को बिरोध मा काही कहे ओको गुनाह न ता येना जुग मा, ना आवनवारा जुग मा छिमा कियो जाहे।” ");
INSERT INTO pwr_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“तुम्ही लोक ला मालुम सेत का साजरो फर आनन लाय साजरो झाड़ लगानो पाहिजे अना बुरो झाड़ लक बुरो च फर मिलासेत। काय की झाड़ आपरो फर लक चीन्हो जासे।” ");
INSERT INTO pwr_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","“अरे सरप का टुराहुन! तुमी खोटो होयके कसो साजरो गोस्टी कव्ह सकासेव?” मानूस को सबद जोन वोको मन मा भरयो से, वाच टोन्डमा भड़-भड़ आवासे। ");
INSERT INTO pwr_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","एक साजरो मानूस, जोन साजरोपन वोको मनमा जमासेत वोच मा लक साजरा गोस्टी हेड़ासेत। जबकि एक बुरो मानूस, जोन बुराई वोको मनमा सेत वो च मा लक बुरो गोस्टी हेड़ासेत। ");
INSERT INTO pwr_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","मि तुमी लक कव्हसू, का जोन-जोन खोटो अना फालतू सबद मानूस कव्हसेत, न्याय को दिवस वय हर एक ओनो गोस्टी को लेखा देहेत। ");
INSERT INTO pwr_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","काहे की तु आपरी गोस्टी को कारन निरदोस, “अना आपरी गोस्टी च को कारन दोसी ठहरायो, जाजोस।” ");
INSERT INTO pwr_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","एको पर काही मोसे को नियम को गुरू अना, फरिसी गुरू ना ओला कहिन “ओ गुरू हमि तोला अचरज निसान परगट करतो चोवनो चाव्हसेजन।” ");
INSERT INTO pwr_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","एको जवाब मा यीसु ना कहीस “एना जुग को बुरो अना दुस्ट लोकगीन च अचरज निसान चोवनो चाव्हासेत पर योना भविस्यवक्ता को अचरज निसान ला सोड़ून अखिन कोनी अचरज निसान उनला नही भेटेत।” ");
INSERT INTO pwr_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","जसो योना भविस्यवक्ता तीन रात-दिवस लक मगर को पोटमा रहयो, वसोच मानूस को टूरा ला तीन रात-दिवस धरती को भीतर रव्हनोसेत। ");
INSERT INTO pwr_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","न्याय को दिवस निनवे नगरी को निवासी अज् को यो पीढी को लोकगिन संग उभो होयेत अना उनला दोसी ठैयरायत। काहेका नीनेवा नगरी को वासी गिनना योना को परचार लक मन बदलयो होतीन। अना यहाँन ता कोनी योना लक मोठयो मौजूद से। ");
INSERT INTO pwr_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","“न्याय को दिवस दक्सिन की रानी यो पीढी को लोकगिन को संग उभो होयती अना उनला गुनाहगार ठैरायती। काहेकि वा सुलेमान को गियान आयकन को साठी धरती को छोर लक आई होती अना चोवो यहान उ से जोन सुलेमान लक मोठयो सेत।” ");
INSERT INTO pwr_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“जबा कोनी भूत-पलित कोनी मानूस ला सोड़ा सेत तबा उ अराम की खोज मा सूनसान जघा को लाय हिन्डा सेत। जबा वोला वसो जघा नही भेटासेत।” ");
INSERT INTO pwr_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","तबा वा कव्हसेत जोन घरला मी सोड़यो होती, मी वहान लवट जाहिन तबा वा उतानी लवटा सेत अना अबा वोला सफा चक्काक सजो सजायो मिलासेत। ");
INSERT INTO pwr_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","मंग वा लवटा सेत, अखिन अपरो संग सात भूत-पलित आनासेत। जोन वोको लक जादा बुरी होवा सेती। मंग वय सबअ आयके जुमला भयी के रव्हसेती अना वोना मानूस को दसा पयले लक लगत बूरो भयी जावा सेत। ");
INSERT INTO pwr_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","यीसु अबा भीड़ लक गोस्टी सांगत होतो तबा ओकी माय अना भाऊ, बाहेर उभया होतीन, अना ओको लक गोस्टी करन लाय बाट चोवत होतिन। ");
INSERT INTO pwr_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","कोनी ना यीसु लक कहीस “तोरी माय अना तोरो भाऊ बाहेर उभा सेत अना तोरो लक गोस्टी करनो चव्हसेत।” ");
INSERT INTO pwr_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","जवाब मा यीसु ना सांगन वालो ला कव्हयो “कउन से मोरी माय? कउन सेत मोरो भाऊ-बन्ध” ");
INSERT INTO pwr_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","मंग वोना हात लक आपरो चेला गीन कन ईसारा करके सांगन लगयो “चोवो यो मोरि माय अना भाऊ से। ");
INSERT INTO pwr_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","काहेका जोन मोरो सरग को परमेस्वर को कव्हनो मा चलासे अना वोको मन को मुताबिक काम करासे, वोच मोरो भाऊ बहिन अना मायसे।” ");
INSERT INTO pwr_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","यीसु वोच दिवस घर सोड़के झील को किनार मा उपदेस देवन बस गयो। अना उपदेस देवन लगयो। ");
INSERT INTO pwr_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","वोको आखा-पाखा एतरो मोठयो, भीड़ जमा भई गई, की तो नावमा जायके बस गयो। अना लोकगिन कगर मा उभा रव्हिन। ");
INSERT INTO pwr_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","वोना बोधकथा लक लगत गोस्टी समजावून सांगयो, “उत एक च मानूस धान्य पेरन गयो होतो। ");
INSERT INTO pwr_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","उ पेरत होतो तरी काही दाना बाटमा गीर गयो उनला पक्सी आयके खाय गयीन। ");
INSERT INTO pwr_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","वोको मा काही खडखड़ी जमीन मा गीरी उतानी माती की कमी होती। दाना लवकरच फुटली, अना माती खोल नव्हती। ");
INSERT INTO pwr_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","पर जबा दिवस को ऊन पड़यो तबा झुडुप मा जर गयो, अना जड़ी जास्त खोल मा बड़यो नव्हती, महुन लवकर च झाड बड़ गयो।” ");
INSERT INTO pwr_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","काही बीज कांटा को झाड़ी मा गिरिन, काँटा मोठो भई गईन अना, फसल ला दबा देइन। ");
INSERT INTO pwr_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","काही बीज साजरो जमीन मा पड़यो वय रोपां ना धान्य देइन काही ना संभर गुना काहीना साठ गुना काहींना तीस गुना। ");
INSERT INTO pwr_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","मग यीसु कहीस “जरा तुमरो कान आहेत तर आयको! मि काजक कव्हसू।” ");
INSERT INTO pwr_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","मंग यीसु को चेला गीन यीसु कठा आयके ओको लक कहीन “तु लोकगीन ला बोधकथा सांग-सांग के काहे सिक्सा देवासेस” ");
INSERT INTO pwr_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","जवाब मा यीसु ना उनलक कव्हयो “सरग राज को लुकयो भेद ला जानन को हक बस तुमरो च जवर सेत उनला नही।” ");
INSERT INTO pwr_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","काहेका जोनको जवर जरासो सेत वोला अखिन दियो जाहेत अना वोको जवर लगत भयी जाहेत परा जोन को जवर काही नाहोती वोको लक जितरो वोको जवर सेत वा हिसक लियो जाहेत। ");
INSERT INTO pwr_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","महुन मी उनलक बोधकथा मा गोस्टी सांगासू। उ चोवत-चोवत अँधरा भई जासेत, वसोच आयक सेत तरी उनला समजमा नही आवासे। ");
INSERT INTO pwr_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","उनको बारे मा भविस्यवक्ता यसायाह ना असो लिखीसेस तुमी आयकजो पर समजमा नहीं आयेत, तुमी चोवजो, “पर तुमिला नही दिसेत।” ");
INSERT INTO pwr_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","काहे का ऐना लोकगीन ला “अक्ल मा गोटा” पड गयी सेत ज्यादा आयक सेत, इनना डोरा बंद कर लईसेत कदी असो न होहे, का वय डोरा लक चोवके, अना कान लक आयक के; मन मा समज लेहेति, अना बदल जाय अना, मि उनला साजरो करू। ");
INSERT INTO pwr_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","पर धन्य सेत तुमरो डोरा, का वय चोवसेत अना तुमरो कान वय आयकसे। ");
INSERT INTO pwr_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","मि तुमी लक खरो कव्हसू तुमी जोन गोस्टी चोवसो, वोला कितरो नेक भविस्यवक्ता गीन चोवनो, अना आयकन चाव्हत होतो। पर उनको किस्मत मा असो नही होत्यो। ");
INSERT INTO pwr_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“तबा आयको, अखिन सीको का पेरनवालो को बोधकथा काजक सेत” ");
INSERT INTO pwr_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","जोन परमेस्वर को राज को बारे मा साजरा बारता आयक सेत तरी वा नहीं समजासेत। उ एक बीज को जसो से जोन रस्ता मा पड़ गयो अना सैतान आवा सेत अना उनलक जोन काही बोयो गयो सेत हिसक लेवासेत। ");
INSERT INTO pwr_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","खडखड़ी ज़मीन मा पडयो बीज उन लोकगिन को लाय सेत। जोन एला आयक सेत अना खुसी लक साजरा बारता ला अपनावा सेत। ");
INSERT INTO pwr_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","मंग यो उनमा गहराई लक नही धसन को कारन लगत उसीर तकन नही रव्हासेत एकोलाय जबा साजरा वारता को कारन मुसिबत आवासेत ता वय एकच बारमा हार मान लेवासेत। ");
INSERT INTO pwr_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","कांटादार झाड़ी को बीच गिरो बीज उन लोक गिनको लाय सेत। जोन साजरा बारता आयक सेत। मंग यो जिंदगी को चिंता अना धन को पिरेम साजरा बारता मा आड़ो आवासेत अना वय फलवन्त नही होवासेत। ");
INSERT INTO pwr_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","जो साजरो जमीन पर बोयो गयो से, वोच से जोन साजरा बारता आयक सेत समजासेत अना फर आनासेत कोनी सौगुना कोनी साठ गुना अना कोनी तीस गुना। ");
INSERT INTO pwr_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","यीसु ना उनला एक अखीन बोधकथा सागंयो। सरग को राज ओना मानूस को जसो से जोन आपरो खेतमा साजरो बीज बोयो। ");
INSERT INTO pwr_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","पर जबा लोकगीन झोपत होतीन, तबा उनको बयरी आयो, अना गहुँ मा जँगली गवथ को बीज बोयके चली गयो। ");
INSERT INTO pwr_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","जबा अँकुर फुटयो अना फसल लगयो तबा जँगली गवथ भी दिसयो। ");
INSERT INTO pwr_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","एको साठी दास गीन आयके मालिक लक बिनती करन लगीन, मालिक का तु ना खेत मा साजरो बीज नही बोयो होतो ता ओमा जँगली गवथ को बीज कसो आ गई? ");
INSERT INTO pwr_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","मालिक ना जवाब देइस, का यो सब बयरी को करामत से तबा दास पुसीन, अबा तोरी मनमा काजक सेत? आमी जायके उनला जमा करबीन? ");
INSERT INTO pwr_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","मालिक ना जवाब दियो नही, कही असो ना होयेत, का निंदत-निंदत जँगली गवथ को संग साजरो गहुँ झाड भी उखड़ जाहेत, तबा ज्यादा नुकसान भई जाहेति, यो साठी अबा फसल आवन देव। ");
INSERT INTO pwr_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","कापन को बेरा मा मि साँगु का जँगली गवथ ला काप लेव अना जलान काजी बोझा बान्ध लेव अना साजरो वालो गहुँ ला खरीयान मा ठेव देव। ");
INSERT INTO pwr_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","यीसु उनला अखिन एक बोधकथा सांगिस “सरग को, राज राई को बीज जसो से जेनला कोनी मानूस ना आन कन, आपरो खेत मा पेरिस। ");
INSERT INTO pwr_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","उ बीज सब लक नहानो बीज होवासे पर जब बढ जासे, ता सब साग-भाजी लक मोठो भय जासे; अना असो झाड़ बन जासे की बदल को पक्सी, भी ओको डगाली पर बसेरा करसेति।” ");
INSERT INTO pwr_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","यीसु ना उनला एक अखीन बोधकथा सांगयो सरग को राज डबल रोटी मा डाखन वालो खमीर पावडर जसो से। जोन ला आन कन एक बायको ना दहा किलो कनीक मा डाख दियो, अना सफा दहा किलो कनीक खमीर बन गयो। ");
INSERT INTO pwr_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","यीसु बोधकथा मा याच सब गोस्टी साँगत होतो बिना बोधकथा को कोनी ला काही नही कव्हत होतो। ");
INSERT INTO pwr_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","जेनको लाई भविस्यवक्ता को यो लिखी बात पूरो होवा से, का: मि मा सबला साँगु अना जोन गोस्टी जग बनावन को पयले लक छिपयो, होतो ओला मि सबला साँगु। ");
INSERT INTO pwr_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","यीसु लोकगीन ला सार करके घर आयो। वोको चेला गीनना, ओको कठा आयके साँगन लगीन, का खेत को जँगली गवथ को बीज को कथा को मजे काजक सेत अमीला समजाव? ");
INSERT INTO pwr_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","यीसु ना उनला जवाब देईस “साजरो बीज बोवनवालो मानूस को टूरा आय।” ");
INSERT INTO pwr_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","अना खेत सारो जग सेति साजरो बीज राज को सँतान सेत। अना जँगली गवथ को बीज सैतान बुराई को सन्तान सेत। ");
INSERT INTO pwr_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","जोन बैरी ना ओला बोइस, उ इबलीस से कटनी जेनको मतलब दुनियाँ को आखीर अना काटनवारा सरगदूत सेति। ");
INSERT INTO pwr_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","एकोसाठी जसो जँगली गवथ समटो जासेत अना जलायो जासेत वसोच दुनियाँ को आखीर होयेत। ");
INSERT INTO pwr_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","मानूस को टूरा सरगदूत ला धाड़ेत, अना वय ओको राज मा लक सब ठोकर को कारन गीनला अना बुरो करम करन वालो ला समटेत, ");
INSERT INTO pwr_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","अना उनला स्तो को कुन्ड मा डाकेत, जिता रोवनो अना दाँत पीसनो होहेत। ");
INSERT INTO pwr_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","ओनो बेरा नेक मानूस आपरो बाप को राज मा दिवस जसो चमकेत जेनला आयकनो से आयक लेव। ");
INSERT INTO pwr_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","सरग को राज खेतमा लुकयो हुवो, धन को जसो सेत। जेनला कोनी मानूस ला भेटयो अना उ ना पाय लेइस अना उ तिजोरी मा लूकाय देईस, अना खुसी लक जायके आपरो सब काही बीक देईस अना ओना खेत ला ले लेईस। ");
INSERT INTO pwr_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","अखीन सरग को राज वोना सेठ को जसो से, जोन सब लक बढ़िया मोती को खोजमा होतो। ");
INSERT INTO pwr_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","जबा वोला एक किमती मोती मिलयो, ता आपरो सब काही बिकके, ना उ मोती ला ले लेइस। ");
INSERT INTO pwr_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","अखीन सरग को राज सागर मा डाख्यो, जाल को जसो से जो हर जात को मसरी ला धर आनीस। ");
INSERT INTO pwr_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","अना जबा जाल भर गयो तबा धिवर वोला झिकसे अना किनार मा आन के साजरो-साजरो मसरी ला बेचके, आपरो ढुटी मा डाख लेवासे, अना खराब मसरी ला फेक देसे। ");
INSERT INTO pwr_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","दुनियाँ को आखीर असोच होयेत। सरगदूत गीन आयके न्यायी गीन लक, दूस्टगीन ला अलग करहेती। ");
INSERT INTO pwr_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","अना उन ला स्तो को कुन्ड मा डाख देहेत, वहान लोकगीन रड़त अना दात किटकिटात रहेत। ");
INSERT INTO pwr_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","का तुमी लोकगीन यो गोस्टी, ला समजासो? चेलागीन जवाब देईन। हव! ");
INSERT INTO pwr_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","यीसु ना उनला कहीस एको लाई हर एक मोसे को नियम को गुरू जोन सरग राज को चेला बनयो सेत ओनो घर को मुखिया को जसो से, जोन आपरो पेटखोली लक नवा अना जुना चीजला हेड़ासे। ");
INSERT INTO pwr_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","यो बोधकथा ला पूरो करके वहाँन लक चलयो गयो। ");
INSERT INTO pwr_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","अखिन आपरो देस मा आय गयो। मंग वोना यहूदी सभाघर मा उपदेस देवनो चालू करयो। एको लक हरेक अचरज मा पड़ के कव्हन लगीन “असो अक्कल अखिन चमत्कार एला कहाँन लक भेटयो से, ");
INSERT INTO pwr_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","का उ बढ़ई को टूरा नाहाय? का एको माय को नाव मरियम नाहती? याकूब, यूसुफ, सिमोन अखीन यहूदा एकोच भाऊ बहीन आमरो बीच मा नाहत? ");
INSERT INTO pwr_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","अना का एकी सप्पा बहिन, हमरो बीच मा नही रहीसेत” ");
INSERT INTO pwr_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","एना रिती लक उनना यीसु लक ठोकर खाईन। पर यीसु ना उनला कहीस “भविस्यवक्ता को आपरो नगर, अना आपरो घर ला सोड़ अना कही बेज्जती नही होवासेत।” ");
INSERT INTO pwr_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","अना ओना वहान उनको कड़ो मन अना अबिस्वास को कारन, लगतसा अद्भुत काम नही करीस। ");
INSERT INTO pwr_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","ओना बेरा गलील को राजा हेरोदेस, ना यीसु की चरचा आयकिस। ");
INSERT INTO pwr_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","अना वोना अपरा अधिकारी गीनला कहीस, “यो योहन बप्तिस्मा देवन वालो से जोन मरयो हुवो लक जित्तो, भईसे। योच कारन वोको जवर चमत्कार करन को ताकत से।” ");
INSERT INTO pwr_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","असो से का ओच हेरोदेस होतो जोनना योहन ला बंदी बनायो होतो, संकली मा बाँध, बंदीघर मा डाक देयि होतीस जेना हेरोदियास को कव्हनो पर असो करियो होतो, जोन पहले ओको भाउ फिलिप्पुस को बायको होती। ");
INSERT INTO pwr_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","योहन बप्तिस्मा देवनवालो ना हेरोदेस लक काही बेरा लाई कहीस तु हेरोदियास लक बिहा करके संग रव्हनो तोरो लाई साजरो नहोती। ");
INSERT INTO pwr_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","हेरोदेस ओला मार डाकनो चाव्हत होतो, पर उ यहुदी लोकहुन लक डरात होतो काहेकि वय ओला भविस्यवक्ता मानत होतीन। ");
INSERT INTO pwr_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","पर जबा राजा हेरोदेस को जलम दिवस आयो, तो हेरोदियास, की पोरी ना हेरोदेस अना ओको मेहमानहून को पुढा नाच के हेरोदेस ला लगत खुस करीस ");
INSERT INTO pwr_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","का राजा ना “वचन हारके” कहयो, जो काही तु मोरो लक मांगजोस मि तोला देहुँ। ");
INSERT INTO pwr_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","तबा उ टूरी आपरो माय को जवर जायके सलाह मांगीस ता वा आपरी माय को सलाह मानके राजा लक भानी मा योहन बप्तिस्मा देवनवालो को डोस्का ला मांगीस। ");
INSERT INTO pwr_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","तबा राजा सठ भई गयो, तरी चार को बीच मा वचन को हारन को कारन लक ओने टूरी को मरजी अनुसार असो करनलाई हव कव्ह देईस। ");
INSERT INTO pwr_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","तबा टूरी को मरजी को अनुसार राजा ना जेल लक योहन को डोस्का मंगवायो। ");
INSERT INTO pwr_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","तबा सिपाही ना ओको डोस्का ला भानी मा आनिस अना टूरी ला दे देईस अना टूरी ना आपरी माय ला दे देइस। ");
INSERT INTO pwr_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","जबा योहन को चेला गीन ला पता चलयो तबा चेलागीन आयके योहन को लास ला ले जायके दफनाय देईन अना जायके यीसु ला सांग देइन। ");
INSERT INTO pwr_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","जबा यीसु ना योहन को बारे मा खबर आयकिस, मंग नाव मा चघके एक सुनसान जघा मा चली गयो। तबा लोकगीन ना ओको बारे मा आयकिन ता नगरहुन लक पैदल हिटके ओको मंघा होय गयीन। ");
INSERT INTO pwr_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","जबा यीसु डोंगा लक बाहेर हिटके कगर पर आयो ता ओना एक मोठी गरदी ला चोयीस। ओला उन पर तरस आयी अना ओना उनको बिमार हुन ला चांगलो करीस। ");
INSERT INTO pwr_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","जबा झुलाखाली बेरा भई ता, ओको चेला गीन ना ओको कठा आयके कहीन, वसोच उसीर भयी गयी से, अखिन यो सुनसान जघा से तु लोकगीन ला सार कर, की वय बस्ति मा जायके, आपरो लाई जेवन लेहेत। ");
INSERT INTO pwr_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","मंग यीसु ना जवाब देईस उनको जानो जरुरी नाहत! तुमिच इनला जेवन लाई देव। ");
INSERT INTO pwr_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","चेला ना यीसु लक कहीन, की आमरो कठा पाँच भाकर अना दुई मसरी सेत। ");
INSERT INTO pwr_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","यीसु ना कहीस “मोरो कठा आनो।” ");
INSERT INTO pwr_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","तबा वोना लोकगीन ला गवथ पर बसन लाई कहीस अना पाँच भाकर अना दुई मसरी ला लेके सरग कन चोवके परमेस्वर ला धन्य वाद देईस। अना भाकर ला तोड़के चेला गीन ला देइस। अना चेलागीन ना लोक गीनला देइन। ");
INSERT INTO pwr_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","जबा सबच खायके अघाय गईन, ता चेलागिन ना बचो टुकड़ा-टाकड़ी को बारा टोपली उचलीन। ");
INSERT INTO pwr_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","अना खानवारा लेकरा अना बायका गीनला छोडके, पाँच हजार मानूस को करिब होतीन। ");
INSERT INTO pwr_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","तबा ओना आपरो चेला गीनला गदने नाव पर चघन को लाइ मजबुर करीस, का वय पयले झिलको ओनागन चली जाहेत। ");
INSERT INTO pwr_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","उ लोकगीन ला सार करके पिराथना करन, अलग पहाड़ पर चली गयो अना झुलाखाली बेरा ला उ वहान एकलो होतो। ");
INSERT INTO pwr_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","तबा तकन बेरा नाव किनार लक लगत दुहुर चले गयो होतो। अना लहरमा डगमग-डगमग होय रही होती काहेकि वारा उलटो चलत होती। ");
INSERT INTO pwr_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","अना यीसु सक्कारी को 3-6 बजे को बीच मा झील पर चलतो हुयो, उनको कठा आयो। ");
INSERT INTO pwr_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","झील मा ओला चलतो चोवके, ओको चेला गीन डराय गईन। अना कव्हन लगीन “यो भुत से” अना “पोक-पोका के” चिल्लान, लगीन। ");
INSERT INTO pwr_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","तबा यीसु ना उन लक कहीस, नोको डराव हिम्मत राखो! ");
INSERT INTO pwr_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","पतरस ना ओला जवाब देइस, अदी तु पिरभु सेस ता मोला पानी पर अपरो, जवर आवन की हुकूम देव। ");
INSERT INTO pwr_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","ओना कहीस चल, अना पतरस नाव लक उतरके, यीसु को जवर जान लाई पानी पर चलन लगयो। ");
INSERT INTO pwr_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","पर वारा ला चोवके डराय गयो। अना जबा बुड़न लगयो, ता चिल्लाय के कव्हन लगयो “हे पिरभु मोला बचाव” ");
INSERT INTO pwr_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","यीसु ना झट हात बढायके ओला थाम लियो, अना कहीस “हे कच्चो भरोसा वालो मानूस, तु ना काय लाई संका करीसेस” ");
INSERT INTO pwr_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","जबा वय नाव मा चघ गईन, ता वारा थम गई। ");
INSERT INTO pwr_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","ऐतरो पर जोन नाव मा होतीन ओला नमस्कार करके कहिन “खरो-खर तु सब लक मोठो परमेस्वर को टूरा आस।” ");
INSERT INTO pwr_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","वय झील को ओनागन जघा मा उतरके गन्नेसरत नगर मा पहुचीन। ");
INSERT INTO pwr_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","उता का लोकगीन गदने यीसु ला चीन्ह लेइन अना अगल-बगल का सप्पा देस, मा खबर ला साँग देइन तबा सब लोक बीमार गीनला ओको कठा आनीन। ");
INSERT INTO pwr_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","अना ओको लक पिराथना करन लगीन, का उ उनला आपरो कपरा को, कगर को सेव ला छीवन दे; अना जेतरा गीनना ओला छिईस, वय बच के साजरो भय गईन। ");
INSERT INTO pwr_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","मंग कही फरीसी और यहूदी मोसे को नियम को गुरू येरुसलेम नगर लक यीसु को जवर आयीन अना वोला पूसिन ");
INSERT INTO pwr_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“तोरो चेलागिन अमरो आजा पुरखा को नेम-धरम को पालन काहे नहीं करासेत? वय बिना हात जेवन करासेत।” . ");
INSERT INTO pwr_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","यीसु ना जवाब दियो “अपरो रीती-रिवाज को कारन तुम परमेस्वर को बिधि ला काहे तोड़ासेव” ");
INSERT INTO pwr_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","काहेका परमेस्वर ना कव्हयो होतो, आपरो दआजी अना आपरो माय को आदर करो। अना जेव उनला बूरो कहेत उ मार डाख्यो जाय। ");
INSERT INTO pwr_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","तरी तुमी यो सिकावा सेत, का अदि लोक को जवर असो काही से जोन वय अपरो दआजी अना माय की मदद करन को लाय बवज सका सेत। लेकिन कव्हसेत “यो परमेस्वर चघावा को से।” ");
INSERT INTO pwr_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","अबा उनला आपरो दाआजी ला सम्मान देवन की जरुरत नाहोत, असो परकार तुम्ही परमेस्वर को हुकूम नही मानासेव जोनलक तुम्ही आपरो सिक्सा को पालन करवायो सेव। ");
INSERT INTO pwr_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","अरे बगला भगतहुन! यसायाह भविस्यवक्ता को बानी तुमरो पर कितरो सही बसासेत। ");
INSERT INTO pwr_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","परमेस्वर कव्हासेत अमी आपरो सब लक परमेस्वर को गौरव करासेजन पर उनको दिल सहीमा मोरो लक लगत दूहुर सेत। ");
INSERT INTO pwr_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","अना वय फालतू मा मोरो भगती करासेत, काहेका वय खुद को बनायो विधी-विधान मानूसगीन ला सिकावा सेत, असो जसो का मोरोच बिधान सेत। ");
INSERT INTO pwr_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","तबा वोना लोकगीन ला आपरो, कठा हाकल के कव्हयो। आयको अना समजो। ");
INSERT INTO pwr_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","जोन टोन्ड मा जासे उ मानूस ला असुध्द नही करा, पर जोन टोन्ड लक हिटासे वाच मानूस ला असुध्द करासे। ");
INSERT INTO pwr_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","तबा चेला ना आयके ओको लक कहीन का तु जानासेत, की फरिसी गीन ला यो गोस्टी लगत बुरो लगिसेत? ");
INSERT INTO pwr_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","यीसु न जवाब देईस का जोन झाड़ मोरो सरग को परमेस्वर दआजी ना नही लगाइसेस उखाड़ दियो जाहे। ");
INSERT INTO pwr_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","उनला जावन देव; वय अँधरा, रास्ता ला दिसावन वारा मानूस सेत। अना अँधरा-अँधरा ला रस्ता चोवाय ता दुई गड्ढा मा पड़ जाहेत। ");
INSERT INTO pwr_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","यो आयक के पतरस ना वोला कह्यो यो आहना को काजक मतलब सेत। ");
INSERT INTO pwr_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","वोना कहीस का तुमी भी अबा तकन नासमज सेव? ");
INSERT INTO pwr_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","का तुमी नही जानासेव का जोन काही टोन्ड मा जासे उ पोटमा पड़ासे अखीन हगतबेरा पोट लक हिटासे? ");
INSERT INTO pwr_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","पर जोन काही टोन्ड मा लक हिटसे, उ मन लक हिटासे, अना उ मानूस ला असुध्द करासे। ");
INSERT INTO pwr_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","काहेकि बुरो विचार हत्या, पराय बायको संग सोवनो, छिनालापन, चोरी, झुठी गवाही अना निन्दा बिरोध मन मा लक हिटा सेत, ");
INSERT INTO pwr_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","या वोच सेत जोन मानूस ला असुध्द करासेत, पर हात बिना धोयो जेवन करनो, मानूस ला असुध्द नही करा। ");
INSERT INTO pwr_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","यीसु उता लक हिटके सुर अना सैदा, को देस कन चली गयो। ");
INSERT INTO pwr_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","उ परदेस लक एक कनानी बायका हिटी, अना चिल्लायके कव्हन लगी हे पिरभु दाऊद की संतान मोरो पर रहम कर, मोरी टूरी ला भुत-पलित लगत सताय रहिसे। ");
INSERT INTO pwr_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","पर उनना ओला जवाब नही देइस, तबा ओको चेला ना आयके ओको लक कव्हयो, एला सार कर, काहेकि वा हमरो मंघा चिल्लावत आय रहीसे। ");
INSERT INTO pwr_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","ओना जवाब देइस का इसरायल को घरानो की भटकी हुयी मेढा ला सोड़ मि कोनी को जवर नही धाड़ो गई सेव। ");
INSERT INTO pwr_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","पर वा आई अना यीसु ला नमस्कार करके कव्हन लगी हे पिरभु मोरी मदद कर। ");
INSERT INTO pwr_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","ओना ओक लक कहीस, की टुरागीन की भाकर आन के कुतरा, को पुढा डाकनो साजरो नहात। ");
INSERT INTO pwr_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","बायका न कहीस पिरभु यो गोस्टी खरो सेत, पर कुतरा गीन भी जुठन-काठन ला जेवसेत। जोन मालीक को ठाव मा बचासे। ");
INSERT INTO pwr_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","येना गोस्टी पर यीसु ना ओला कहीस, अवो बाया तोरो बिस्वास मोठो से जसो तु चाव्हसेस, तोरो लाई वसोच होहे, अना ओको टूरी ओनो बेरा साजरी भय गयी। ");
INSERT INTO pwr_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","यीसु उता लक हिटके गलील छेतर मा झील को कठा आयो अना एक पहाड पर जायके बस गयो। ");
INSERT INTO pwr_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","तबा भीड़ पर भीड़ ओको कठा आई। वय आपरो सँगा लँगडा गुँगा हात-पाय लुला, अना लगत लोकगीन ला ओको कठा आनीन, अना ओना उनला साजरो करीस। ");
INSERT INTO pwr_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","जबा लोकगीन ना चोवीन, की गुँगा बोलासेत अना हात-पाय लुला गीन साजरो भय गईन। अना लँगडा चलन लगीन अना अँधरा चोवन लगीन, तबा ता अंचम्भा करके इसरायल वासी परमेस्वर की बड़ाई करन लगीन। ");
INSERT INTO pwr_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","यीसु ना आपरो चेला गीन ला हाकलीस, अना कहीस, मोला या भीड़ पर तरस आवासे काहे की वय तीन दिवस लक मोरो सँग से अना उनको लाई जेवन लाई काही नाहत? मि उनला भुखो, कसो धाड़ू। असो ना होहे की वय, रास्ता मा थक जाहेत। ");
INSERT INTO pwr_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","चेला गीन ना ओला कहिन, हमी एना जँगल मा एतरो भाकर किता लक आनबीन। की हमि एना भीडला खिलाबीन? ");
INSERT INTO pwr_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","यीसु ना उन लक पुसिस, “का तुमरो जवर केतरी भाकर सेत?” उनना साँगिन का, “सात, भाकर अना जरासी मसरी सेत।” ");
INSERT INTO pwr_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","तबा यीसु लोकगीन ला जमीन मा बसन लाई कहीस, ");
INSERT INTO pwr_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","अना उन सात भाकर अना मसरी ला आन के सरग को परमेस्वर ला धन्यवाद देके तोड़ीस, अना आपरो चेला गीन ला देवत गयो। ");
INSERT INTO pwr_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","अना भीड़ जेयके अघाय गईन। अना चेला गीन ला बचा हुया भाकर को टुकड़ा बटोरन लाई कहीस। सबा तुकड़ा सात डलिया उचलिन। ");
INSERT INTO pwr_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","जेवन वालो मा बायका अना लेकरु, गीनला छोडके चार हजार को करिब मरद गीन होतीन। ");
INSERT INTO pwr_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","तबा उ भीड़ ला सार करके, नाव मा मगदन देस को मेंड मा आयो। ");
INSERT INTO pwr_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","मंग फरीसी अखिन सदूकी यीसु को जवर आयिन वय ओला ताड़न चाव्हत होतीन एकोलाइ ओन्हीसीन ओकोलक कोनी चमत्कार करन लाई कहीन, मनजे मालुम कर सकेत का ओला परमेस्वर को मंजुरी मिली से की नही, ");
INSERT INTO pwr_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","ओना जवाब देयो दिन लुकन पर तुमी लोक कव्हसेव “आज मौसम साजरो रव्हेत, काहेका बादर लाल सेत” ");
INSERT INTO pwr_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","अना दिन उगन पर तुमी कव्हासेव “आज आँधड़ आहेत, काहेका बादल धुँधरो अना लालसे” तुमी बादल को चिन्हानी ला बाचनो जानासेव, पर आपरो बेरा को चिन्हानी ला नही जानासेव। ");
INSERT INTO pwr_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","यो दिवस को बूरो अना परमेस्वर ला नही माननवारा लोक मोला एक चिन्हानी मांगासेत मंग योना को चिन्हानी ला सोड़ उनला अना कोनी चिन्हानी नही दियो जाहे। ऐतरो सांगके उ उनला छोडके चली गयो। ");
INSERT INTO pwr_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","चेला गीन झील को वोनागन गईन, मंग वय भाकर लेनो बिसर गईन। ");
INSERT INTO pwr_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","यीसु न उनला कहीस हुसियार रव्हो, फरिसी गुरूगीन अना सदुकि गुरूगीन को खमीर लक आपरो ला बचाय राखो। ");
INSERT INTO pwr_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","वय आपस मा विचार करन लगीन, हमी भाकर नही आनीसेजन एकोलाय उ असो कव्हासे। ");
INSERT INTO pwr_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","यो जानके का वय आपस मा काजक कव्हसेत यीसु न उनला कहीस, अरे कच्चो भरोसा राखनवारा! तुमी आपस मा काजक विचार करासो, का हमरो जवर भाकर नहात? ");
INSERT INTO pwr_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","का तुमी अब तकन नही समजयत? का तुमीला वय पाँच हजार को लाय पाँच भाकर हेत नहोत? हेत करो, तुम्ही ना केतरी टोपली उचलयत होता? ");
INSERT INTO pwr_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","वा सात भाकर मा चार हजार मानूस जेयके ना केतरो डलिया उचालयत होता? ");
INSERT INTO pwr_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","तुम्हीला बोध नाहत, का मीना तुमीला भाकर को बारेमा नही कहयो, मंग फरिसी गुरुगीन अना सदुकि गुरुगीन को खमीर मनजे बिचार लक हुसियार रव्हन लाई कहयो होतो। ");
INSERT INTO pwr_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","तब उन चेलाहुन ला समज मा आयो, का वोना पोड़ी को खमीर ला नही कहयो, पर फरिसी गुरूगीन अना सदुकि गीनको सिक्सा लक हुसियार रव्हन ला कहयो। ");
INSERT INTO pwr_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","जबा यीसु कैसरिया फिलिप्पी को परदेस मा आयो ता अना ओना अपरो चेला लक पुसयो लोकगीन का कव्हसेत की मानूस को टूरा कउन से? ");
INSERT INTO pwr_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","उनना कहीन काही लोक योहन बप्तिस्मा देवन वालो कव्हसेत, अना काही लोकगीन एलियाह अना काही यीरमीयाह अना भविस्यवक्ता गीन मा लक, कोनी एक कव्हासेत। ");
INSERT INTO pwr_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","यीसु ना उनला पुसिस, तुमी मोरो बारे मा काजक कव्हसेव? “का मि कउन सेउ?” ");
INSERT INTO pwr_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","समौन पतरस न जवाब देईस, तु जित्तो परमेस्वर को टूरा मसीह आस। ");
INSERT INTO pwr_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","यीसु न वोला जवाब देईस, हे समौन, योहन को टूरा तु धन्य सेस, काहेका मानूस को मन की गोस्टी नाहत, पर मोरो दाअजी परमेस्वर ना जोन सरग मा से, येनो गोस्टी ला तोरो मन मा डाखी सेस। ");
INSERT INTO pwr_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","अना मी तोला कव्हसू का तु पतरस सेस, अना मी येनो गोटा पर अपरी कलीसिया बनाऊ अना मिरतु वोको, पर ताकतवर नही होहेत। ");
INSERT INTO pwr_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","मी तोला सरग राज की कुन्जी देसू, अना जोन काही तु धरती पर बाँधबिन उ सरग मा बँधेत, अना जो काही तु धरती पर उघाड़बिन, वय सरग मा उघडेत। ");
INSERT INTO pwr_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","तबा यीसु ना चेला गीन ला चितायके कहीस, तुमी कोनी ला नोको सांगने का मी मसीह सेऊ। ");
INSERT INTO pwr_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","उ बेरा लक यीसु अपरो चेला ला सांगन लग्यो, जरुरी से का मी येरुसलेम नगर जाऊ अना सियानोगिन अना मुखिया याजक, अना मोसे को नियम को गुरू को हात लक लगत दुख उठाऊ अना मि मार दियो जाऊ अना तीसरो दिवस मंघा मि जित्तो भय जाऊ। ");
INSERT INTO pwr_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","येको पर पतरस पिरभु ला अलग लिजाय, के डाटन लग्यो अना कहयो “हे पिरभु! परमेस्वर तोरो पर दया करेत तोरो सँग असो कबच नही होहे!” ");
INSERT INTO pwr_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","वोना मंघा पछलके पतरस लक कहीस “हे सैतान मोरो पुढ़ा लक दुहुर भयी जाय” तु मोरो लाई रास्ता को ठोकर सेस, कहेका तु परमेस्वर लक आयो बिचार पर नही, पर मानूस की सुभाव लक गोस्टी करासेस। ");
INSERT INTO pwr_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","तबा यीसु न अपरो चेला लक कहीस, यदि कोनी मोरो माघा आवनो चाव्हसो, ता अपरो आप मा मुकरके, अपरो कूरूस खुदच उचलेह अना मोरो मंघा होय जाय। ");
INSERT INTO pwr_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","काहेका जोन कोनी अपरो जान बचावनो चाव्हासे, वय वोला खोय देहेत, अना जो कोनी मोरो, लाय अपरो जान खोहेत वय वोला पाहेत। ");
INSERT INTO pwr_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","यदि मानूस सप्पा जग ला पाय लेहेत, अना अपरो जान को हानी उठायहेत, ता वोला का नफा होयहेत, यो मानूस अपरो जान को बदला का देहे? ");
INSERT INTO pwr_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","ता मानूस को टूरा अपरो सरगदूत को संग अपरो, बाप को गौरव मा आहेत, अना वोनो बेरा मा उ हर एक ला, उनको काम को अनुसार बदला देहे। ");
INSERT INTO pwr_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","मी तुमला खरो सांगसेऊ का जो यहान उभो सेत, उनमा लक काही असो सेत का उ जब तकन, मानूस को टूरा ला राज मा आवता नही चोव लेहेत, तब तकन नही मरहेत। ");
INSERT INTO pwr_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","सह दिवस मंघा यीसु, पतरस, याकूब अना ओको भाउ योहन संगा एकलो मा वरता पहाड़ पर गयो। ");
INSERT INTO pwr_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","वहान उनको पुढा वोको रुप बदल गयो, अना वोको टोन्ड दिन को जसो चमकन लगयो। अना वोको कपरा उजारो भय गयो। ");
INSERT INTO pwr_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","मंग तीन चेला हुन ना चोवयो, मोसे अना एलिय्याह भविस्यवक्ता यीसु संग गोस्टी कर रव्हयो सेत। ");
INSERT INTO pwr_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","तबा पतरस ना यीसु ला कव्हयो, ओ पिरभु, कितरो साजरो से का हमि यहान सेजन, मी यहान तीन मान्डो बनाहूँ एक तोरो लाय, एक मोसे को लाय, अना एक एलिय्याह को लाय। ");
INSERT INTO pwr_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","जबा उ असो कव्हच रहयो होतो, तबा एक पाँढरो, बादर न उनला ढाक लियो, अना उ बादल लक एक आवाज आयी यो मोरो एकच चहेतो, टूरा से, जेनको लक मी गजब खुसी सेव “एकी आयको!” ");
INSERT INTO pwr_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","जब चेला गीन न असो आयकिन, वय ऐतरो डराय गईन का वय टोन्ड को बल, पड़ गइन। ");
INSERT INTO pwr_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","यीसु ना जवर आयके उनला छीवके कव्हसे। उभो होवो “डराव नोको।” ");
INSERT INTO pwr_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","तबा वय वरता नजर करीन, अना उनला यीसु को सीवाय, कोनी नही चोवयो। ");
INSERT INTO pwr_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","जब वय पहाड़ लक खाल्या, उतर रहयो होतिन। यीसु ना उनला हुकूम देइस, जब तकन मानूस को टूरा मुरदा लक जित्तो नही भई जाए, यो बात कोनी ला नोको सांगने। ");
INSERT INTO pwr_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","मंग यीसु को चेलागिन वोको लक पूसिन “मोसे को नियम को गुरू काय लाय कव्हासेत? पयले एलिय्याह को आवनो पक्को सेत।” ");
INSERT INTO pwr_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","वोना जवाब देइस एलिय्याह आ रहयो सेत, उ सब काही साजरो कर देहेत। ");
INSERT INTO pwr_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","पर मी तुमरो लक कव्हसू, का एलिय्याह आय गइसे। अना लोकगीन ला वोला चीन्हो नाहत, अना मन चाहो वोको संग करीन, असोच मानूस को टूरा ला तंगाहेत। ");
INSERT INTO pwr_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","तबा चेलागिन को समजमा आ गयो का यो योहन बप्तिस्मा देवन वारा, को बारेमा अमीला सांगा से। ");
INSERT INTO pwr_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","जबा वय भीड़ को जवर आइन, तबा यीसु को जवर एक मानूस आयो। अना टोघरा टेकके, असो कव्हन लग्यो। ");
INSERT INTO pwr_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","पिरभु मोरो टूरा पर रहम कर काहेका, वोला मीरगी आवासे। अना वोला मिरगी एतरो बिकराल आवा सेत का उ बार-बार स्तो अना पानी मा पड़ जासे। ");
INSERT INTO pwr_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","मी वोला तोरो चेला गीन को कठा आनयो होतो। पर वय वोला साजरो, नही कर सकिन। ");
INSERT INTO pwr_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","तबा यीसु ना जवाब दियो अरे भिरस्ट हुयो आबिस्वासी लोकहुन मी कितरो बेरा तुम्हरो संग अखिन रव्हिन? वोला मोरो जवर आनो। ");
INSERT INTO pwr_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","यीसु ना बुरो आतमा ला हुकूम देके डटकारीस अना बुरो आतमा टूरा मा लक हिट गयो, अना टूरा वोच बेरा साजरो भई गयो। ");
INSERT INTO pwr_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","तबा चेला गीन एकान्त, मा यीसु को जवर आयके ना ओको लक पुसन लगीन “हमी वोला, काहे हेड़ नही सकयो” ");
INSERT INTO pwr_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","तबा यीसु ना जवाब दियो, आपरो भरोसा को कमी कारन लक, काहेका, मी तुमला खरो-खरो सांगसू का यदि तुमी मा राई को बीज, को बराबर भरोसा से अना यो पहाड़ लक कव्हने “यहान लक हट अना उता जा!” तो उ सरक जाहेती। अना तुमरो, लाय काही भी कठिन नहात। ");
INSERT INTO pwr_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","पर यो जाती पिराथना न अना उपवास, को सिवाय कोनी उपाय लक नही हिटा से। ");
INSERT INTO pwr_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","जबा वय गलील छेतर मा जमा भई होतिन, तबा यीसु ना उनला कव्हयो “मानूस को टूरा लोक गीन को हात मा धरान वालो सेत। ");
INSERT INTO pwr_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","जोन वोला मार डाखेत, तरी तीसरो दिवस उ जित्तो भयी जाहेत।” एको पर यीसु को चेलागिन लगत दुखी भयी गयीन। ");
INSERT INTO pwr_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","जबा वय कफरनहुम नगर मा पहुचिन तबा मंदिर को बरगन वसुलन वारा पतरस को कठा आयके पुसिन, का तोरो गुरु मंदिर को बरगन देवासे? ");
INSERT INTO pwr_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","पतरस ना कहीस हाँ देवासे, जबा पतरस घर मा आयो। तबा यीसु ना पयले समौन लक पूछिस “तोरो का राय से? धरती को राजा गीन बरगन कोन लक वसुलसे, आपरो लेकरा लक या परायो लक” ");
INSERT INTO pwr_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","तबा पतरस ना जवाब दियो का परायो लक तब, यीसु ना वोला कहीस, “तब तो लेकरा छुट गयो।” ");
INSERT INTO pwr_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","पर आमी उन लोकहुन ला नाराज नही करबिन एकोलाई झील पर जाय अना अपरो गल फेक अना मंग जोन पयली मसरी धराहे ओको टोंड उघाड़ तोला चारअना को सिक्का मिलेह। ओला आन के मोरो अना आपरो लाई उनला दे-दे। ");
INSERT INTO pwr_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","वय बेरा चेला गीन यीसु को जवर आयके, पुसन लगीन “सरग राज मा सब लक मोठयो कोन से?” ");
INSERT INTO pwr_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","तबा यीसु ना एक लेकरा ला आपरो कठा, बुलाईस अना बीच मा उभो करके कहीस। ");
INSERT INTO pwr_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","मी तुमरो लक खरो कव्हसू, का जबा तकन तुमरो मन लेकरा गीन को जसो नही होयेत, तुमी सरग को राज मा कभी नही धस सकत। ");
INSERT INTO pwr_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","सरग को राज मा सब लक महान वा से जोन खुद ला नरम राखा सेत, अना लहान लेकरा जसो बन जासे। ");
INSERT INTO pwr_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","अना जोन कोनी लोक गीन मोरो नाव लक असो, एक लेकरा ला अपनावा से उ मोला अपनावा से। ");
INSERT INTO pwr_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","पर जोन कोनी असो लहान अना नरम मोरो बिस्वासी मा एक ला भी ठोकर खेलावासे, तो वोको लाय यो साजरो से। का वोको गरो मा गोटा बान्ध के सागर मा डाख दियो जाय। ");
INSERT INTO pwr_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","“आड़- फाटा तो आवनो सेत पर आड़- फाटा को कारन मोला दुनिया को लोकगिन लाय दुख सेत मोला दुखसे वोको लाय जोन बाधा को कारन बना सेत एकोलाय।” ");
INSERT INTO pwr_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","यदि तोरो हात या तोरो पाय ठोकर खिलायो, ता वोला काप केना फेक दे, काहेका तोरो लाय य लगड़ो होयके अमर जिंदगी मा धसनो एको लक ज्यादा साजरो, से का तु दुई हात अना दुई पाय से, पर कभी नही इझन वालो स्तो मा डाख्यो जायेती। ");
INSERT INTO pwr_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","यदि तोरा डोरा तोला ठोकर खिलाये तो वोला कहाड़ के, फेक दे अना भोकना होयके जिंदगी मा धस जा एको लक साजरो, से का “दुई डोरा से अना नरक को स्तो मा डाख्यो जाय।” ");
INSERT INTO pwr_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","चोवो ऐना लहान मा लक कोनी, एक ला भी बेकार नोको समजो। काहेका मी तुमी लक कव्हसू, इनको सरगदूत सरग मा हमेसा मोरो परमेस्वर दाआजी को पुढा रव्हसेत। ");
INSERT INTO pwr_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","काहेका मानूस को टूरा गुमयो हुवो ला ढुढन अखिन सूटकारा देवन काजी आयो से। ");
INSERT INTO pwr_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“तुम्ही ला काजक लगा सेत? एक मानूस को कठा 100 मेढ़ा से। उनमा लक एक मेंढा गुम जाय, ता उ निन्यानवे ला पहाड़ी मा सोड़ के एक ला ढूढन चलो जाहेत। ");
INSERT INTO pwr_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","अना जब उ मेंढा वोला मिल जासे, तो मी तुमी लक खरो सागसू उ 99 लक वा एक को लाय लगत खुस होवासेत। ");
INSERT INTO pwr_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","असोच तुमरो सरग को परमेस्वर दआजी नही चाव्हसेस, का कोनी ऐना लहान लक एक भी नास भई जाय।” ");
INSERT INTO pwr_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","अगर तोरो भाऊ तोरो खिलाफ पाप करा सेत, ता वोको जवर जायकर वोको गलती दिसाव। लेकिन यो काम एकान्त मा दुई को बीचमा करो, यदी उ तोरो गोस्टी मानासे ता तुना अपरो भाऊ ला आपिस जीत लियो सेत। ");
INSERT INTO pwr_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","लेकिन उ अगर तोरी गोस्टी नही माना सेत, तो एक दुजो मानूस ला आपरो संग ले जाय, जोन लक वय समजायेती, मंग समजमा नही आहेत, तो वय पुरुप भयी जाय। जसो का गीरंथ मा कहयो सेत। यदी उ तुमरो गोस्टी मानासे ता तुमीना अपरो भाऊ ला बचाय लियो सेव। ");
INSERT INTO pwr_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","अदि नही माना सेत ता कलिसिया मा जायके सांग, पर उ कलिसिया को भी नही मानहेत, तो वोला गैरयहुदी जमा लेवनवालो मुरतीपुजा वालो जान। ");
INSERT INTO pwr_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","मी तुमी लक खरो कव्हसू, जोन काही तुमी धरती मा बान्धने, उ सरग मा बन्ध जाहेती, अना जोन जानकारी तुमी धरती मा खोलने, वा सरग मा उधड़ जाहेती। ");
INSERT INTO pwr_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","मंग मी तुमरो लक खरो कव्हसू, यदि तुमी मा लक दुई मानूस धरती पर कोनी बात को लाई एक मन होयके वोला मांगसेत, ता वय मोरो बाप को कना सरग मा से उनको लाई होय जाहेत। ");
INSERT INTO pwr_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","काहेकि जहान दुई या तीन लोक गीन मोरो नाव पर जमा होसेत, मी उनको बीच मा रव्हसू। ");
INSERT INTO pwr_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","तब पतरस न जवर आयके यीसुला कहीस, हे पिरभु यदी मोरो भाऊ पाप करासे ता मी केतरी बार वोला छिमा करू? का सात बार तकन? ");
INSERT INTO pwr_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","यीसु न वोला कहीस “मी तोरो लक, यो नही कव्हसू का सात बार तकन, नही पर सात बार को सत्तर गुना तकन।” ");
INSERT INTO pwr_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","तो सरग राज को बरोबरी उ राजा लक कियो जाय सका सेत वोना कहयोका मी दिवान को लेखा-जोखा जाचनो चाव्हासू। ");
INSERT INTO pwr_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","जबा वय हिसाब लेवन लगयो, ता वोको पुढा एक असो मानूस ला लायो गयो, जोन को पर दसो लाख रुपिया को करजा होतो। ");
INSERT INTO pwr_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","वोको जवर करजा भरन काजी काही नही होत्यो। ता मालिक ना कहीस, यहान येकि बायको, अना टूरा-टूरी अना जोन काही येको सेत। सब बिकके करजा चुकायो जाय। ");
INSERT INTO pwr_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","येको पर वोना दास पाय पडके, कहीस, हे मालीक धीरज धर, मी सब काही भर देहू। ");
INSERT INTO pwr_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","तबा मालिक ना तरस खाय के करजा छिमा कर दियो। ");
INSERT INTO pwr_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","पर जबा वय दास बाहेर हिटयो, ता वोको संगी नौकर मा लक एक वोला भेटयो जोन वोको सौ सिक्का, को करज दार होत्यो। तबा उ नौकर संगी को गरो धरके कहीस “मोरो करजा भर” ");
INSERT INTO pwr_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","एको पर वोको संग काम करन वालो संगी पाय पड़के, वोको लक गिड़गिड़ान लगयो “धीरज धर मी सब भर देहू।” ");
INSERT INTO pwr_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","पर उ नही मानयो “अना वोला कयद खाना मा डाक दियो, का जबा तकन करज भर नही देसे तबा तकन कयद खाना मा रव्हे।” ");
INSERT INTO pwr_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","वोको एक संगी दास यहान जोन भयो होत्यो, चोयके लगत उदास भयो अना जायके, अपरो मालीक मजे राजाला सबा हाल सांगीस। ");
INSERT INTO pwr_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","तबा उ मालीक ना दास ला हाकलके कहीस “का हे पापी तु न मोरो जवर पिराथना करियो, अना मी न तोरो, वय पुरा करज छिमा कर देइसेउ।” ");
INSERT INTO pwr_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","एकोलाइ जसो मी तोरो पर दया करीसेव, वोसच का तोला भी अपरो संगी दास पर रहम नही करनो होतो। ");
INSERT INTO pwr_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","अना वोको मालिक मजे राजाना हिजड़के, वोला दन्ड देवन वालो को हात मा सोप दियो। अना जेल मा डाख दियो गयो अना करजा को पायी-पायी चुकान लाय कहयो। ");
INSERT INTO pwr_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","येना पिरकार यदि तुमी मा लक हर एक अपरो भाऊ को मन लक छिमा करयेत, ता मोरो बाप जोन सरग मा से तुमी भी वसोच छिमा करयेत। ");
INSERT INTO pwr_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","यीसु आपरो सिक्सा पुरो करन को मघा, गलील परदेस लक चले गयो, अना यरदन नदी को वोना गन यहुदिया, छेतर को सीव मा आयो। ");
INSERT INTO pwr_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","एक मोठी भीड़ वोको मंघा भई गई, अना यीसु ना वहाँन को लोकगीन ला साजरो कर देइस। ");
INSERT INTO pwr_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","तबा काही फरिसी गुरु गीन यीसु को कठा आइन अना वोकी परिक्सा, करन लाय सांगिन का मोसे को नियम को अनुसार कोनी भी कारन लक आपरो बायको, ला छोड़-छुट्टी देवनो सही से? ");
INSERT INTO pwr_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","यीसु ना जवाब दियो “काय तुमी लोकगीन पवीतर गिरंथ, मा असो नही बाची सेव? का दुनिया बनावन वारा परमेस्वर ना सुरुमा उनला, मानूस अना बायको बनाईस।” ");
INSERT INTO pwr_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","अना कव्हयो का एकोलाय मानूस आपरो माय-बाबूजी ला सोड़हेत अना आपरो बायको को संग रव्हसे। अना वय दुई एक देह होवेती। ");
INSERT INTO pwr_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","असो परकार अबा परमेस्वर वय दूई ला एकच तन कहयो सेत ता उनला कोनी बेगरो नोको कर सका सेत? ");
INSERT INTO pwr_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","उनना यीसु ला कव्हयो तबा मोसे ना आपरो नियम मा बायको, ला छोड़-छुट्टी को बेरा मा लिखके, देवनो को हुकूम काहे दियो से? ");
INSERT INTO pwr_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","यीसु ना जवाब दियो “मोसे ना यो हुकूम तुमरो गोटा जसो मन चोव के, तुमला आपरी, बायको ला छोड़न को हुकूम देइसेस पर सुरु लक असो कोनी रीत नहाय।” ");
INSERT INTO pwr_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","मी तुमी लोकगीन लक सांगासू, का छिनालापन को सीवा अखीन कोनी कारन लक आपरो, बायको ला छोड़-छुट्टी देके, अना दुसरो पाठ करयेत, तो उ खोटो काम करासे। ");
INSERT INTO pwr_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","चेला गिनना वोला कहिन यदि नवरा-बायको, को बीचमा असो समस्या सेत, तो बिन बायको को रव्हनो साजरा सेत। ");
INSERT INTO pwr_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","यीसु ना उनला कहीस सबा यो सिक्सा, ला नही अपना सकसे। पर जोनला यो वरदान दियो गयोसे, वोच अपना सका से। ");
INSERT INTO pwr_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","काहेका काही लोकगीन माय को गरभ लक, हिजड़ा होवासे, अना काही लोकगीन ला मानूस गीन हिजड़ा बना देइसेस, अना काही सरग राज लाय हिजड़ा बनिसेस, जोन यो सिक्सा अपना सका से, उ अपना लेवे। ");
INSERT INTO pwr_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","वोना बेरा काही लोकगीन लेकरागिन ला, यीसु को जवर आनीन, एकोलाय का उन पर आपरो हात राखके पिराथना करे, पर चेला गीन उनला डाटन लगीन। ");
INSERT INTO pwr_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","यीसु ना कव्हयो लेकरा गिनला मोरो, जवर आवन देव, उनला रोको नोको, काहे का सरग को राज असोच हुनको से। ");
INSERT INTO pwr_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","अना उ उन पर हात रखके वहान लक चली गयो। ");
INSERT INTO pwr_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","एक बेरा एक मानूस यीसु को कठा आयो। वोको लक कहीस ओ गुरुजी “मी अमर जिंदगी पावन को लाई कोनतो, साजरो काम करूँ” ");
INSERT INTO pwr_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","यीसु ना वोको लक कव्हयो, साजरो काजक से? तू मोरो लक साजरो काम को बारेमा काजक, लाय पुसासे? भला केवल एक च से पर तु अमर जिंदगी चाव्हसेस, ता हुकूम ला मान। ");
INSERT INTO pwr_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","वोना पुसयो “कोनतो हुकूम” यीसु ना कव्हयो, तु हत्या नोको करबिन छिनाली नोको करबिन, चोरी नोको करबिन, खोटो गवाही नोको देवजो। ");
INSERT INTO pwr_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","आपरो माय बाप को आदर करनो अना आपरो, सेजारी ला आपरो समान माया करनो। ");
INSERT INTO pwr_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","उ जवान ना वोला कहीस “यो सब हुकूम मी हमेसा लक मानिसेव। अबा मोरो मा कोनतो कमी से” ");
INSERT INTO pwr_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","यीसु ना वोको लक कहयो, “अदि तु सिध्ध होवनो चाव्हासे, ता जाय अना आपरो धन-सम्पति खोल के सब माल ला बीकदे, अना कँगालगिन ला देव, तब तोला सरग मा धन मिलहेत, अखीन मोरो मंघा आव।” ");
INSERT INTO pwr_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","जबा उ जवान ना यो गोस्टी आयकिस, उ गजब दुखी भई गयो, काहेकि उ गजब धनी होतो। ");
INSERT INTO pwr_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","मंग यीसु ना अपरो चेला गिनला कहीस, “मी तुमला खरो सांगासू, का धनी को सरग को राज मा धसनो लगत कठीन से।” ");
INSERT INTO pwr_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","मि मंग तुमला कव्हसू, का परमेस्वर को राज मा धनी लोक को धसनो लक सरल ऊट को सुई, को छेद लक बाहेर सरल हिटनो से। ");
INSERT INTO pwr_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","यो आयक के चेलाहुन लगत चकित भई गईन, “अना उनना पुसिन, मंग कोन को बचाव होय सकासे” ");
INSERT INTO pwr_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","यीसु ना उनको कन चोवके जवाब दियो “यो ता मानूस लक नामुमकिन सेत, पर परमेस्वर को लाई, सब काही सरल से।” ");
INSERT INTO pwr_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","तबा पतरस ना यीसु कना चोवके कहयो, हमी लोकगीन ता आपरो सबच काही सोड़के तोरो मंघा आयीसेत, ता हमला काजक मिलनो सेत? ");
INSERT INTO pwr_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","यीसु ना आपरो चेलागिन ला कव्हयो, मि तुमला खरो कव्हसेऊ, का नवतो जुग मा जबा मानूस को टूरा महिमा को सिघासन मा बसेह, तबा तुमी जो मोरो मंघा आयोसेव बारा सिघासन मा बसके परमेस्वर को लोकहुन को न्याय करोह। ");
INSERT INTO pwr_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","अना जोन कोनी लोक गीन मोरो नाव लाय, आपरो घर बार, भाऊ बहिन, माय-बाप, लेकरा बारा अना खेत ला सोड़ासे, उ संबर गुना पाहेत, अना अमर जिंदगी को अधिकारी होयेत। ");
INSERT INTO pwr_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","पर गजब सेत जो पयलो सेत, वय आखरी भई जाहेत, अना जो आखीर सेत, उ पयलो भई जाहेत। ");
INSERT INTO pwr_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","सरग को राज एक जमींदार को किस्सा जसो से। जोन भुन्सारे आपरो अंगुर को बगीचा मा काम करन बनिहार लावन हिटयो। ");
INSERT INTO pwr_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","ओना खुरो को एक रुपया मा ठहरायके नौकर बनिहार ठहरायो। अना उनला आपरो अंगूर को बगीचा मा काम करन लाई धाड़ देईस। ");
INSERT INTO pwr_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","मंग बनिहारी बेरा जमींदार मंग घर लक हिटयो अना हाट मा गयो। वोला काही बनिहार लोकहुन ला हाट मा इता-उता हिंडत चोवयो। ");
INSERT INTO pwr_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","तबा वोना उनलक कहयो, तुम्हि भी मोरो अंगुर को बगीचा मा जाव, अखिन काम करो, तुमला तुमरो बेस बनी देहुँ। ");
INSERT INTO pwr_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","वय बगीचा मा काम करन लाई चली गईन, मंग कोनी ला दुफरिया बेरा मा अना कोनी ला महातनी बेरा मा जायके वसोच कव्हके आनिस। ");
INSERT INTO pwr_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","तबा कोनी पील-पील दिवस मा मंग हाट गयो, अना मंग काही लोकहुन ला हाट मा इता-उता उभो चोईस। ओना उनलक पुसिस, तुमी यहान फालतू मा दिवस भर काय लाई उभा रव्हसेव? ");
INSERT INTO pwr_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","ओन्होसीन जवाब देईन, का कोनी ना आमला काम पर नही राखिन। तबा ओना उनलक कहयो, बेस से ता तुमी जाव, अना बगीचा मा काम करो। ");
INSERT INTO pwr_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","जबा दिवस बुड़ गयो तबा अंगूर को बगीचा को मालिक ना आपरो मुनीम ला कहीस, नौकर बनिहार ला हाकल लेव अना आखरी मा लगयो नौकर लक सुरु करके जो पयले लक लगायो गयो, सबला पगार दे देव। ");
INSERT INTO pwr_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","असो परकार जोन नौकर बनिहार पील-पील दिवस मा काम मा लगयो होतिन, उनमा लक हरेक ला खुरो को एक रुपया मिलयो। ");
INSERT INTO pwr_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","तबा जोन पुढा आई होतीन उनना यो समझीन का हम ला लगत भेटेत। पर उन ला भी एक-एक खूरो को एक रुपया मिलयो। ");
INSERT INTO pwr_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","उनना रुपया तो धर लेईन, मंग वय जमींदार पर कुड़कुड़ान लगीन। ");
INSERT INTO pwr_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","उनना कहिन, एक तास काम करनवालो ला ओतरो च पगार देईसेस, जेतरो आमीला भी देईसेस, जबकि आमी ता कड़कड़ातो ऊन मा दिवस भर काम करया सेजन। ");
INSERT INTO pwr_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","ओना मालक ना जवाब देइस, अरे संगी, मि तुमरो काही हानी भयी का? का तुना मोरो लक एक खुरो को सिक्का बिनी नही ठहरायो होतो? ");
INSERT INTO pwr_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","जोन तोरो से उचल ले, अना पराय जाय। मोरी मरजी या से की जेतरो तोला देहुँ, वोतरोच मंघा वालो ला भी देहुँ। ");
INSERT INTO pwr_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","का यो साजरो नहात? का मि आपरो माल ला जसो चाहुँ वसोच करुँ, का मोरो नेकी ला तु बुरो चोवोसेस? ");
INSERT INTO pwr_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","याच रिती लक जो मंघा सेत वय पुढा होहेत। अना जो पुढा सेत वय मंघा होहेत। ");
INSERT INTO pwr_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","यीसु येरुसलेम नगर जातो बेरा बारा चेला गीन ला एकलो मा ले गईस। अना रास्ता मा उन ला कव्हन लगयो, ");
INSERT INTO pwr_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“आयको हमि येरुसलेम नगर जासेजन, अना ‘मानूस को टूरा’ मुखिया याजक अना मोसे को नियम को गुरू गीन को हात धरयो जाहेत। अना वय वोला जान लक मारन को काबील दन्ड ठयराहेत। ");
INSERT INTO pwr_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","अना वोला गैरयहुदी गिनको हात मा सौप देहेत। अना वय वोको मजाक मा उड़ाहेत, अना कोड़ा लक मारेत। अखीन कूरूस मा चघायेत, अना उ तीसरो दिवस जित्तो भई जाहेत।” ");
INSERT INTO pwr_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","तबा जबदी को बायको आपरो टूरागिन को संग यीसु कठा आयके नमस्कार करीस, अना कव्हन लगी, ");
INSERT INTO pwr_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","“मोरो टुरा गिनला तोरो राज मा एक उज्जो अना एक ला डावो कन बसाजोस।” यीसु ना कहीस, “यो तु काजक मांगिसेस?” ");
INSERT INTO pwr_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","तोला मालुम नहात तू काजक कव्हासेत? “जोन दुख की बटकी मी पिवनवालो सेव, का तुम्हि भी पिवने?” वय यीसु लक कहिन? “हमी पीवबीन।” ");
INSERT INTO pwr_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","तबा यीसु उनला कहीस “यदी पिवने तबा भी कोनी ला डाखियो-उज्जो बसानो मोरो काम नाहत, काहेका उ तो परमेस्वर बाबुजी को काम से, वोच ला मालूम से, का कोनी बसन वारो से।” ");
INSERT INTO pwr_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","यो आयक के दहा चेलागीन वय दुई भाऊ पर गुस्सा भईन। ");
INSERT INTO pwr_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","यीसु ना उन ला जवर हकलके कहीस “तुमी ला मालुम सेत गैरयहुदी लोकगिन को अधिकारी उन पर हक जतावासेत। अना जोन मोठा सेत, वय उन पर अधिकार जमावा सेत। ");
INSERT INTO pwr_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","पर तुम मा असो नोको होय, पर जो कोनी तुम मा मोठो होवनो चावहासे, उ तुमरो दास बने। ");
INSERT INTO pwr_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","जो तुमरो मुखिया होवनो चाव्हासे उ तुमरो दास बने। ");
INSERT INTO pwr_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","मी एको लाई नही आईसेव, का मोरो कोनी सेवा करे। पर मानूस को टूरा एकोलाय आईसेस क उ खुदच सेवा चाकरी करे। अना लगत लोकगीन को सूटकारा लाई आपरी जान देदेहेत।” ");
INSERT INTO pwr_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","जबा वय यरीहो नगर लक हिटत होतीन, ता एक मोठी भीड़ ओको मंघा भयी गयीन। ");
INSERT INTO pwr_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","अना दुई अँधरा रास्ता को किनार मा बसया होतीन। असो आयक के का यीसु जाय रहीसे, हाकलके कव्हन लगीन “हे पिरभु दाऊद की सँतान हमरो पर रहम कर।” ");
INSERT INTO pwr_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","लोक गीन उनला डटकार के कहिन “उगो-मूगो रव्हो।” पर वय अखीन चिल्लाय के कहिन, “हे पिरभु दाऊद को सन्तान हमरो पर रहम कर।” ");
INSERT INTO pwr_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","तबा यीसु ना उभो होयके, हाकलके कहीस, “तुमी का चाव्हासेव, मी तुमरो लाय काजक करू?” ");
INSERT INTO pwr_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","उनना ओको लक कहिन, “हे पिरभु आमरो डोरा उघड जाय।” ");
INSERT INTO pwr_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","यीसु ना तरस खायके उनको डोरा ला छुईस अना वय देखन लगीन, अना ओको मंघा होय गईन। ");
INSERT INTO pwr_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","जबा वय येरुसलेम को कठा, जैतून पहाड़ मा बैतफगे गाँव को जवर आइन, ता यीसु ना दुई चेला गीनला यो कहके धाडीस, ");
INSERT INTO pwr_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","पुढा को गाँव मा जावो। उता जसो च जावने तुमीला एक गाढव बँधी हुई, अना ओको संग पाटरू मिलेहत। उनला सोड़के मोरो जवर आनो। ");
INSERT INTO pwr_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","अदी तुम लक कोनी काही कहे, तो कव्हना की पिरभु ला ऐको काम से, तबा उ गदने उनला धाड देहेत। ");
INSERT INTO pwr_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","यो एकोलाय भयो की जो गोस्टी भविस्यवक्ता गिनको कन लक कव्हयो गयो होतो। उ पूरो होहेत, ");
INSERT INTO pwr_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“सिय्योन की टूरी लक सांग, चोव! तोरो राजा तोरो जवर आवासे, उ नरम से अना गदही को पाटरू पर बसी से, अना लादु को बच्चा मा।” ");
INSERT INTO pwr_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","चेला गीन ना जायके, जसो यीसु ना उनको लक कही होतीस, वसो च करीन। ");
INSERT INTO pwr_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","अना गाढव अना पाटरू ला आनके ओको, पर आपरा कपरा डाकिन, अना यीसु ओको पर बस गयो। ");
INSERT INTO pwr_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","तबा लगत सा लोकगीन ना आपरो, कपरा रास्ता मा बिछाइन, अना लोकगीन झाड़ लक, डगाली गीन ला काटके रास्ता मा बिछाईन। ");
INSERT INTO pwr_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","जोन लोकगीन को भीड़ पुढा-पुढा जावत अना मंघा-मंघा चली आवत होती। अना जोरलक कव्हत होती, “दाऊद को सन्तान की बड़ाई होय! धन्य से उ जो पिरभु को नाव लक आवासे, वरता बादल मा बड़ाई होय!” ");
INSERT INTO pwr_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","जबा उ येरुसलेम मा भीतर आइन, ता सारो नगर मा खलबली मच गई, अना लोक गीन कव्हन लगीन, “यो कोन आय?” ");
INSERT INTO pwr_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","लोकगीन ना कहिन, “यो गलील परदेस को नासरत नगर को भविस्यवक्ता यीसु आय।” ");
INSERT INTO pwr_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","यीसु ना परमेस्वर को मंदिर मा जायके, मंदिर मा लेवन देन करनवालो सबच लोकहुन ला हेड देईस। अना सोन्ना-खुरो वालो को इसटूल अना परेवा बिकन वालो की चौकी ला उलट देईस। ");
INSERT INTO pwr_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","अना उनलक कहीस, “गीरंथ मा लिखयो से, मोरो घर पिराथना को घर कहलायेत पर तुम्हिना यो जघाला डाकूगीन को अड्डा बनाय डाकयत।” ");
INSERT INTO pwr_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","तबा यीसु जवर अँधरा लगँड़ा-पांगड़ा मंदिर मा आइन। अना ओना, सबला च साजरो करीस। ");
INSERT INTO pwr_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","मंग जबा मुखिया याजक अना मोसे को नियम को गुरूगिन असो अचँभो काम ला जोन ओना करयो होतो, अना टुरागिन ला मंदिर मा “ दाऊद की सन्तान को बड़ाई होय” आवाज करता चोवके वय “लाल पिवरा भय गईन।” ");
INSERT INTO pwr_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","अना ओला कव्हन लगीन, “तु आयक यो काजक कव्हासेत?” यीसु ना उन लक कहीस, “हव का तुमी ना गीरंथ मा यो कबच नही वाचिसेव? टूरागीन अना दुध पिवता लेकरा को टोन्डलक तु ना गजब स्तुति कराईसेस।” ");
INSERT INTO pwr_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","तबा उ उनला सोड़के नगर को बाहेर बैतनियाह गाँव मा गयो, अना रात बिताईस। ");
INSERT INTO pwr_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","सक्कार ला जबा उ नगर ला वापिस होय रहयो होतो, ता ओला भुख लगी। ");
INSERT INTO pwr_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","रास्ता को किनारो मा अँजीर को झाड़ चोयके उ ओको जवर गयो। तब पान ला छोड़ ओमा अखीन काही नही पायो अना झाड़ लक कहीस, “अता लक तोरो मा कबच फर नही लगहेत।” अना अँजीर को झाड़ तुरूत सूक गयो। ");
INSERT INTO pwr_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","यो चोयके चेला तुरूत अँचम्भा भय गईन अना उनना कहीन, “यो अँजीर को झाड़ तुंरुत कसो सूक गयो।” ");
INSERT INTO pwr_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","यीसु ना उन ला जवाब देके कहीस, मि तुमी लक खरो कव्हसु, “अदि तुमरो मा बिस्वास से, अना तुमरो मा संका नाहत तो तुम्ही येतरोच नही, जोन मी ना अंजीर को झाड़ लक करीसेऊ, बल्कि अदि तुम यो पहाड़ लक कव्हो, उचल अना सागर मा डूब जाय ता वसोच भयी जाहेत। ");
INSERT INTO pwr_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","जोन काही तुमी पिराथना मा बिस्वास करके, मांग लेव वय सबच तुमला मिल जाहेत।” ");
INSERT INTO pwr_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","यीसु मंदिर मा जायके सिक्सा, देवत ही होतो, ता मुखिया याजक अना सायनो लोक गीनना ओको जवर आयके पुसिन, “तु यो काम कोनतो अधीकार लक करासेस? अना असो अधिकारी तोला कोन बनाइसेस?” ");
INSERT INTO pwr_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","यीसु ना उन ला कव्हयो, “मि भी तुमला एक बात पुसा सेऊ, अदी मोला तुमी सांगो ता मि भी तुमला सांगु, का यो काम कोनतो हक लक करासेऊ, अना कोन ना अधिकारी ठयराइसेस? ");
INSERT INTO pwr_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","योहन की बप्तिस्मा किता लक होतो? सरग को कन लक या मानूस को कन लक?” तबा वय आपसी मा बहस करन लगीन, अदी हमी कव्हबीन सरग को कन लक, ता उ हम लक कहे, मंग तुमी ना ओको बिस्वास काय लाई नही कियत? ");
INSERT INTO pwr_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","तबा वय डराय गइन अना असो कव्हन लगीन “अदी आमी कव्हबिन का मानूस की कन लक, ता हमला भीड़ को डर से, काहे की वय सबच योहन ला भविस्यवक्ता मानासेत।” ");
INSERT INTO pwr_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","अता उनना यीसु ला जवाब देईन, “हमी नही जान सेजन।” यीसु भी उन ला कहीस, “ता मि भी तुमला नही सांगु का यो काम कोन, सो अधिकार लक करासेऊ अना कोन अधिकारी ठयराइसेस।” ");
INSERT INTO pwr_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“अता सांगो, तुम्ही लोक येको बारे मा काजक बिचार करा सो? एक मानूस को दोन टूरा होतिन। उ मोठो को जवर गयिस अना कहयो, ‘अज बेटा अंगूर को बाड़ी मा जाय अना काम कर’ ");
INSERT INTO pwr_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","ओना जवाब देईस, मि नही जाहुँ, पर मंघा मा पस्तायो अना गयो। ");
INSERT INTO pwr_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","मंग बाप ना दुजो ला भी जायके असोच कहीस, ओना जवाब देईस, हव जी! जासू, पर नही गयो। ");
INSERT INTO pwr_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","एना दुही मा लक कोन ना बाप की मरजी ला पूरो करीस?” उनना कहिन “पयलो ना!” यीसु ना उन लक कहीस, “मि तुमला खरो कव्हसु की जमा लेवन वारा अना बेसिया गीन भी तुम लक पुड़ा परमेस्वर को राज मा भीतर धसेत।” ");
INSERT INTO pwr_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","काहेकि योहन धरम को रास्ता दिखावन लाई, तुमरो जवर आईसे, अना तुम ना ओको बिस्वास नही करयात, पर बरगन लेवन वारा, अना बेसिया ओको पर बिस्वास करीन। अना तुमी यो चोयके मंग नही पस्तायत! नाच भरोसा करयत। ");
INSERT INTO pwr_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","एक अखीन उदाहरन ला आयको, एक घर को मालिक होतो, जेना अंगूर को बारी लगाईस, ओको आस-पास रुधान रूधिस, ओमा अंगूर को रसा को कुन्ड खोदिस अना गुम्मट बनाइस, अना खेती करन वारा गिनला ओको ठेका देयके परायो देस मा चली गयो। ");
INSERT INTO pwr_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","जबा फर को बेरा आयो, ता ओना आपरा दास गीन ला ओको, फर लेवन लाई किसान को कठा धाडीस। ");
INSERT INTO pwr_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","पर कास्तकार ना ओको दास हिन ला पकड़के, कोनी ला, पीटन अना कोनी ला मार डाकीन। अना कोनी ला पथराव करीन। ");
INSERT INTO pwr_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","मंग ओना पहलो लक लगत अखीन दास गीन ला धाडीस, अना ओन्हीसिन उन लक भी वसोच करीन, ");
INSERT INTO pwr_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","अखट्ट मा ओना आपरो टूरा ला उनको जवर यो सोचके धाडिस की वय मोरो टूरा को मान करयेत। ");
INSERT INTO pwr_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","पर किसान ना टूरा ला चोयके आपसी मा कहिन, यो ता हकदार से आओ येला मार डाकबोन अना ऐको जायजाद ला ले लेवबोन। ");
INSERT INTO pwr_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","अता ओन्हीसिन ओला पकड़ीन अना अंगूर को बारी लक बाहेर हेड़के मार डाकिन। ");
INSERT INTO pwr_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","एको लाई जबा अंगूर को बारी को मालिक मजे पिरभु आहे। ता उन कास्तकार गीनको संग का करेत? ");
INSERT INTO pwr_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","ओन्हीसिन उनको लक कहीस, उ उना कंतरी कास्तकार गीन ला बुरो रिती लक नास करेत, अना अंगूर को बारी को ठेका दुजो किसान गीनला दे देहे जोन फर देवन को बेरा मा फर देहेत। ");
INSERT INTO pwr_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","यीसु ना उन लक कहीस, का तुमीना कभीच पवितर गीरंथ मा यो नही वाचिसेव? “जेना गोटा ला राज मिस्तरी गीनना ठुकरायो सेत, उ कोन्टो को सिरा को गोटा भय जाहे। याच पिरभु की कन लक भईसे, अना आमरि नजर मा अचँम्भा से।” ");
INSERT INTO pwr_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","एकोलाय मि तुमी लक कव्हसु, का परमेस्वर को राज तुम लक ले लियो जाहे अना असो लोक गीनला जो ओको फर आनेह, दियो जाहे। ");
INSERT INTO pwr_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","जो यो गोटा पर गिरेह, उ चकनाचुर भय जाहे, अना जेनको पर उ गिरेह, ओला पीस डाकेत। ");
INSERT INTO pwr_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","मुखिया याजक अना फरिसी ओको उदाहरन लक आयक के समज गईन की उ उनको बारे मा कव्हासे। ");
INSERT INTO pwr_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","अना ओन्हीसिन ओला पकड़नो चाहीन, पर लोकगीन लक डराय गईन काहे, की वय ओला परमेस्वर को मोठो भविस्यवक्ता मानत होतीन। ");
INSERT INTO pwr_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","यीसु मंग एना उदाहरन लक लोकहुन ला कव्हन लग्यो। ");
INSERT INTO pwr_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","सरग को राज असो से जसो, एक मोठो मानूस मजे राजा ना अपरो टूरा को बिहा करीसेस। ");
INSERT INTO pwr_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","वोना अपरा दास ला धाडिस का निवता दियो गयो, लोकगीन ला बिहा को जेवन मा आवन लाय कव्ह, पर वय आवनो नही चाहिन। ");
INSERT INTO pwr_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","मंग वोना अखिन दास गीनला असो, सांग के धाडिस का निवता दियो गयो, लोकगीन ला कव्हने, “का छपन्न भोग अना पलियो हुया जनावर भी तैय्यार से। आव अना बिहा को जेवन करो।” ");
INSERT INTO pwr_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","पर वय जेवन मा नही आइन पर कोनी अपरो, खेत चली गयो अना कोनी अपरो, काम-धाम मा चली गयो। ");
INSERT INTO pwr_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","काही लोकगीन न दास गीनला मारिन, अना बेज्जती करीन। ");
INSERT INTO pwr_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","तबा राजा ला गुस्सा आयो अना अपरी सेना धाड़के, उनला नास करीस, अना धड़काय डाकिस। ");
INSERT INTO pwr_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","तबा वोना अपरो दास ला कहीस, बिहा को जेवन ता तैय्यार से पर निवता दियो गयो, लोक काबील नही होतीन। ");
INSERT INTO pwr_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","एकोलाय चौवक पर जावो अना जेतरा लोक, तुमला मिलहेत सबला बिहा को जेवन, मा बुलायके आनने। ");
INSERT INTO pwr_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","अखीन उन दास गीन न रास्ता मा जायके, का बुरा का साजरो भला जेतरा मिरिन सबला जोड़ीन, अना बिहा वालो घर पाहुना लक, गसा-गस भर गयो। ");
INSERT INTO pwr_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","जबा राजा पाहुना गिनला चोवके भीतर आयो, ता वोना वहान एक मानूस ला चोयो, का जेना बिहा का कपरा नही पेहनो होतो। ");
INSERT INTO pwr_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","वोना पुसीस का अगा संगी तुना बिहा, को कपरा कायलाय नही डाकिसेस? उ उगा-मुगा भय गयो। ");
INSERT INTO pwr_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","तबा राजा न दास गीनला कहीस, ऐका हात-पाय बांधके इंधारो मा डाक देव, वहान रोवनो अना दात पिसनो होहेत। ");
INSERT INTO pwr_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","काहेकी हाकलो गयो लगत सेत पर निवड़ो हुयो जरासो सेत। ");
INSERT INTO pwr_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","तबा फरिसी न जायके आपस मा विचारन लगीन का वोला कसो रिती लक फसावबिन। ");
INSERT INTO pwr_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","अखीन उनना अपरो चेला गीन ला हेरोदियोगीन को संग वोको जवर असो कव्हन लाई धाडिस हे गुरू हमी जानासेजन का तु खरो सेस, अना परमेस्वर को रस्ता खराई लक सिकावा सेस, अना कोनी की चिंता नही करासेस, काहेकि तु मानूस को टोन्ड चोयके गोस्टी नही करसेस। ");
INSERT INTO pwr_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","एकोलाय हमला सांग तु का सोचसेस? मोसे को नियम लक केसर राजा ला जमा पटावनो साजरो से का नही? ");
INSERT INTO pwr_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","यीसु न उनको मनकि कपट जानके कहीस, हे कपटी मोला कायला परखा सेव? ");
INSERT INTO pwr_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","रोमन देस को राजा ला जमा पटावन वालो सिक्का ला मोला दिसाव तबा वय वोको जवर एक खुरो को सिक्का आनीन। ");
INSERT INTO pwr_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","वोना उन लक पुसीस यो नाव अना छाप कोन को से? ");
INSERT INTO pwr_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","उनना वोला कहिन केसर को तबा उन लक कहीस जोन केसर, को से वोला केसर ला अना जोन परमेस्वर को से वोला परमेस्वर ला देव। ");
INSERT INTO pwr_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","असो आयक के उन न अचंभा करीन अना वोला सोड़के चली गईन। ");
INSERT INTO pwr_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","वोना दिवस सदुकी गुरुजी कव्हत होतीन का मरया हुया का जित्तो होवनो नहात, यीसु को जवर आइन अना ओला पुसिन, ");
INSERT INTO pwr_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","हे गुरू, मोसे गुरुजी ना कव्हयो होतिस, का अदी कोनी मानूस बंझला मर जाहेत, ता ओको भाऊ ओकी बायको लक बिहा करके, ना आपरो भाऊ को नाव लक लेकरा पैदा कर सकासे। ");
INSERT INTO pwr_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","अब आमरो यहान सात भाऊ होतिन, पयलो बिहा करीस अना मर गईस अना सन्तान नही होवन को काजी आपरी बायको ला आपरो भाउ लाई सोड़ गयो। ");
INSERT INTO pwr_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","असो तरीका लक दुजो अना तीसरो ना भी करीस अना सात गीन तकन असोच भई। ");
INSERT INTO pwr_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","सबच को संग वा बायको भी मर गई। ");
INSERT INTO pwr_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","अता जित्तो होवनो पर वा सात गीन मा लक कोन की बायको होहे? काहे की वा सबच की बायको भई गई होती। ");
INSERT INTO pwr_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","यीसु ना सांगिस, “तुमी पवितर गीरंथ अना परमेस्वर की ताकत ला नही जानासो एकोलाय भुल मा पड़ीसेव। ");
INSERT INTO pwr_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","काहे की मरयो हुयो मा लक जित्तो होवनो पर वय न ता बिहा करयेत अना न ता बिहा मा दियो जाहेत, पर सरग मा सरगदूत जसो रहेत। ");
INSERT INTO pwr_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","पर मरयो हुया लक जित्तो होवनो, को बारे का तुमी ना यो नही बाचिसेव जोन परमेस्वर ना तुमला कहिसेस, ");
INSERT INTO pwr_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","मि अबराहम, इसहाक अना याकूब को परमेस्वर सेव। उ मरयो हुया को नही पर जित्तो को परमेस्वर से।” ");
INSERT INTO pwr_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","भीड़ ना यो आयकिन ता ओको सिक्सा लक चकित भईन। ");
INSERT INTO pwr_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","जबा फरिसी गुरू ना आयकिन का यीसु ना सदुकि गीन ला उगा-मुगा कर देईसेस, ता वय एकजुट भई गइन। ");
INSERT INTO pwr_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","उनमा लक एक मोसे को नियम को गुरु गिनना ओला परखन लाई ओला सवाल पुसिन, ");
INSERT INTO pwr_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","हे गुरू सांग की पवीतर गिरंथ मा सब लक मोठी हुकूम कोनतो से? ");
INSERT INTO pwr_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","ओना सांगिस, तुमी आपरो पिरभु परमेस्वर लक आपरो सप्पा मन अना आपरो सप्पा आतमा अना आपरी सप्पा बुध्दि को संग माया राखजोस। ");
INSERT INTO pwr_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","सब लक मोठी हुकूम ता याच से। ");
INSERT INTO pwr_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","अना वोको जसी या दुसरी भी से की तुमी आपरो सेजारी लक आपरो जसो माया राखने। ");
INSERT INTO pwr_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","या दुही हुकूम सेत जोन सप्पा पवीतर गिरंथ अना मोसे को नियम अखीन सफा भविस्यवक्ता गीन को मूल सेत। ");
INSERT INTO pwr_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","जबा फरिसी गुरू जमा गईन, ता यीसु ना उनलक पुसिस, ");
INSERT INTO pwr_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","मसीह को बारे मा तुमी का जानासेव? उ कोन को टूरा आय? उनना कहिन का दाऊद को। ");
INSERT INTO pwr_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","ओना उन लक पुसिस ता दाऊद परमेस्वर को आतमा मा होयके ओला पिरभु काई लाई कव्हासे? ");
INSERT INTO pwr_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","पिरभु ना मोरो पिरभु लक कहीस, मोरो उज्जो कन बस जबा तकन की मि तोरो, बैरी गीन ला तोरो पाय को खाल्या नही कर देहुँ। ");
INSERT INTO pwr_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","भलो जबा दाऊद ओला पिरभु कव्हासे ता उ ओको टूरा कसो होहेत? ");
INSERT INTO pwr_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","एको लाई जवाब मा कोनी भी एक बात नही कहे सकीन। ओनो दिवस लक कोनी ला मंग ओको लक काही पुसन की हिम्मत नही भई। ");
INSERT INTO pwr_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","तबा यीसु ना भीड़ अना चेला ला कहीस, ");
INSERT INTO pwr_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","मोसे को नियम को गुरू अना फरिसी गुरु मोसे भविस्यवक्ता की पिढो पर बसो सेत। ");
INSERT INTO pwr_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","एको लाई वय तुमला जोन काही करन अना मानन ला कहेत वाच करना अना मानने पर उनको जसो काम नोको करना। काहेका वय काही कव्हासेत अना काही करासेत। ");
INSERT INTO pwr_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","वय असो बोझा ला जेनला उचलनो कठिन सेत बाँधके उन मानूस को खांद पर राखासेत, पर खुदच आपरी करंगी लक भी खिसकानो नही चाव्हत। ");
INSERT INTO pwr_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","वय आपरा सब काम दिसान लाई करासेत वय आपरी ताबीज ला चौड़ो करासेत अना कपरा की किनारो, ला बढावासेत। ");
INSERT INTO pwr_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","जेवन को बेरा मा मुख्य-मुख्य जगह अना पिराथना घर मा बैठकी लाई मुख्य-मुख्य आसन को चहेतो सेत। ");
INSERT INTO pwr_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","अना बाजार मा नमस्कार करनो साजरो लगासे। अना मानूस को बीच मा गुरू कहलानो साजरो लगासे। ");
INSERT INTO pwr_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","पर तुमी ना ता गुरू कहलावना काहेकि तुमरो एकच गुरू से अना तुम सब गुरू भाऊ आव। ");
INSERT INTO pwr_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","धरती पर कोनी ला आपरो बाबूजी नोको कव्हने, काहेकि तुमरो एकच बाप से जोन सरग मा से। ");
INSERT INTO pwr_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","अना मालिक भी नोको कहलाने काहे की तुमरो एकच मालिक से, अना की मसीह। ");
INSERT INTO pwr_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","जो तुमरो मा मोठो होहेत, उ तुमरो दास बनेह। ");
INSERT INTO pwr_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","जोन कोनी आपरो आप ला मोठो बनाहेत, उ नहानो कियो जाहेत अना जोन कोनी आपरो आप ला नहानो बनाहे, उ मोठो कियो जाहे। ");
INSERT INTO pwr_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","हे कपटी मोसे को नियम को गुरू अना फरिसी गुरू, गीन तुम पर हाय। तुम मानूस को लाई सरग को राज को किवाड़ बंद करोसो, न ता खुदच ओमा धस सक सो, अना न ता ओमा धसन वारा हिन ला धसन देसो। ");
INSERT INTO pwr_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","हे कपटी गियानी अना फरिसी गुरूगीन, तुम पर हाय! तुमी बेवा को घर ला खाय डाखासेव, अना चोवन लाई मोठी बेरा तकन पिराथना करोसो, एको लाई तुमला लगत सजा मिलहेत। ");
INSERT INTO pwr_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","हे कपटी मोसे को नियम को गुरू अना फरिसी गुरू, तुम पर हाय। तुमी एक मानूस ला आपरो पक्स मा आनन को लाई मजे यहुदी बनान काजी सारो, पानी परवान एक करासो अना जबा उ मत मा आय जासे ता ओको गत बिल्ला देवसो अना वोला दुगनो नरक मा जावन काजी बनाय देवासो। ");
INSERT INTO pwr_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","हे अँधरा गुरू तुमी पर हाय, तुमी सिकावा सेव, “अदी कोनी मंदिर को किरिया खावा से, तो कोनी गोस्टि नहात, मंग सोन्नो की किरया खाय ता ओको, लक बँध जावासेत।” ");
INSERT INTO pwr_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","अगो अन्धरा बेडिमाक कोन को जादा मायना सेत, सोन्नो का उ मंदिर, जोन मा सोन्नो पवितर होवासेत? ");
INSERT INTO pwr_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","मंग कव्हसो, की अदी कोनी होमन कुन्ड की किरिया खासे ता कोनी गोस्टी नाहत। पर अदी वा होमन कुन्ड को चघावा को किरिया खासे तो वा बन्ध जासे। ");
INSERT INTO pwr_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","हे अँधरा, कोन मोठो से भेट या होमन कुन्ड जेना लक चघावा पवीतर होवासे? ");
INSERT INTO pwr_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","एकोलाय जेना होमन कुन्ड की कसम खासे, वा वोकी अना वोको पर ठेई हुई सबच जीनुस की कसम खासे। ");
INSERT INTO pwr_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","जोन मंदिर की कसम खासे वा वोकी अना वोमा रव्हन वालो परमेस्वर की भी कसम खासे। ");
INSERT INTO pwr_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","अखीन जोन सरग की कसम खासे, उ परमेस्वर को सिघासन अना वोको, पर बसनवालो की कसम खासे। ");
INSERT INTO pwr_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","कपटी मोसे को नियम को गुरू अना फरिसी गीन धिक्कार से तुमला तुमी पुदिना, सौप अना जीरा को दसमांस ता देवासेव, पर धरम बेवस्था की सही गोस्टी न्याय, अना दया अखीन बिस्वास ला छोड़ सो। भलो होतो स्वता तुमी असो सिक्सा को पालन करतत अना सबला असोच सिक्सा देवतत। ");
INSERT INTO pwr_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","अरे अँधरा लगंडा तुमी मुगंसा ला ता छनाय डाकसेत, पर ऊट घीटक जासेत। ");
INSERT INTO pwr_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","अरे कपटी मोसे को नियम को गुरू अना फरिसी गीन, तुमरो पर धिक्कार से तुमी बटकि अना भानी ला ओरिया-ओरिया, साजरो लक माजासेव, पर तुमरो भीतर हिन्सा अना सुवारत सेत। ");
INSERT INTO pwr_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","अरे अँधरा फरिसी, पुढा बटकी अना भानी को भीतर लक साजरो मलके, बाहेर लक भी सुध्द भय जावो। ");
INSERT INTO pwr_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","अरे कपटी मोसे को नियम को गुरू अना फरिसी गीन तुमरो, पर धिक्कार से! तुमी चुनो पोतयो कबर को जसो सेव, जेनको ओरिया, से ता सुन्दर चोवसे पर भीतर मुरदा की हडडी, अना सबच पिरकार की खोटो करम अना गंधगी भरिसे। ");
INSERT INTO pwr_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","येनच रिति लक तुमी भी ओरिया लक, मानूस ला न्यायी चोवसे, पर भीतर लक कपट अना बुरो करम अधरम लक भरया हुयो सेत। ");
INSERT INTO pwr_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","अरे कपटी मोसे को नियम को गुरू अना फरिसी गीन तुमरो, पर धिक्कार से तुमी भविस्यवक्ता गीनको मरघट्टी बनातत, अना न्यायी गीनको कबर ला सुधारसो। ");
INSERT INTO pwr_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","अना कव्हसो आमी आपरो बाप-दादा गिनको, बेरा मा होतिन, ता भविस्यवक्ता गीनको, खून मा भागी नही होतिन। ");
INSERT INTO pwr_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","एको लक तो तुमी खुद च गवाहि देवसो का आमी भविस्यवक्ता गिनको हत्यारा की सन्तान सेजन। ");
INSERT INTO pwr_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","अता तुमी आपरो बाप-दादा गिनको, कसर पूरो कर लेव। ");
INSERT INTO pwr_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","ओ सरप अना नाग को सन्तान, तुमी नरक को दन्ड लक कसो, बच सकासो? ");
INSERT INTO pwr_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","एकोलाय चोवो मि तुमरो कठा, भविस्यवक्ता गीन अक्कलवर अना मोसे को नियम को गुरू गीनला धाडासू। अना तुम उनमा लक काही ला मार डाखेत, अना काही ला कूरूस मा चघायेत, अना काही ला आपरो पिराथना घर लक, हेड़ने अना कोडा मारके, नगर-नगर मा उनला कुदाने। ");
INSERT INTO pwr_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","जोन मा न्यायी हाबिल लक, बिरिक्याह, को टूरा जकरयाह लक, जोन ला तूमी ना मंदिर अना होमन कुन्ड को जघा, को बीचम बीच मा खून बोहायो होतो। जितरो धरमीगिन को रकत धरती मा बोयो गयो से। उ सब तुमरो डोस्का पर पड़हेत। ");
INSERT INTO pwr_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","मी तुमी लक खरो कव्हसू, यो बात वोना बेरा को लोकगीन पर आहेत। ");
INSERT INTO pwr_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","ओ येरुसलेम नगर, ओ एरुसलेम नगर, तू भविस्यवक्ता गीनला मार डाखासे। अना जोन तोरो कठा धाडो गयो, उन पर तू गोटा मारसे, कितरो बार मी चहायो का जसो कुक्कड़ी आपरो, बच्चागिन ला आपरो पंखा को खालया जमा करा से। वसोच मी तोरो, लेकरा गिनला जमा कर लेऊ पर तुना नही चाव्हयो। ");
INSERT INTO pwr_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","चोवो तुमारो घर तुमारो लाय बिरान छोड़यो जावासे। ");
INSERT INTO pwr_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","कायका मी तुमला कव्हसू, क जबा तकन तुमी लोक नही कव्हने, धन्य से जो पिरभु को नाव लक आवासे। तबा तकन तुमी मोला कभी नही चोवने। ");
INSERT INTO pwr_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","जबा यीसु मंदिर लक हिटके दुहुर जाय रहयो होतो। तबा वोको चेला गीन वोको जवर आइन, अना मंदिर कना ईसारा करके ध्यान देवन कव्हन लगीन। ");
INSERT INTO pwr_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","तबा यीसु ना उन लक कव्हयो हव तुमी यो सब चोव रही सेव मी तुमरो लक खरो सांगसू इनमा एक भी गोटा नही सोड़यो जाहेत सब खाल्या फेकयो जाहेत। ");
INSERT INTO pwr_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","जबा उ जैतून को पहाड़ मा बसो होतो, तबा चेला हुन ना वोला नीजी तौर मा कहीन, सांगो यो गोस्टी कबा होयेत? मनजे अखीन संसार को अखट्ट को काजक हिदान होयेत? तोरो आवन को अना दुनियाँ को आखीर को काजक हिदान होहेत? ");
INSERT INTO pwr_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","यीसु ना जवाब दियो, सतरक रव्हने तुमीला कोनी नोको बहकाय। ");
INSERT INTO pwr_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","लगत सो लोक गीन आयके, ना तुम्ही ला सांगेत का मी मसीह सेउ। अना गजब, लोक गीन बहक जाहेत। ");
INSERT INTO pwr_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","तुमी लडाई-वडाई की गोस्टी आयको, तबा नोको डरावना काहेका असो होवनो जरुरी से, पर यो आखीर नाहत। ");
INSERT INTO pwr_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","लोक को विरोध मा लोक, अना राज को विरोध मा राज, उभो होहेत। जघा-जघा मा गीरानी पडहेत, अना भुईडोल होहेत। ");
INSERT INTO pwr_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","असो मान लेव का लेकरा होवन को दरद जसो दरद को सुरुवात से। ");
INSERT INTO pwr_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","वोना बेरा लोक तुमला धराके मार डाखेत, अना तगांहेत, अना मोरो नाव को कारन सब जाती को लोकगीन तुमरो बैरी भई जाहेती। ");
INSERT INTO pwr_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","वोना बेरा मा गजब बिस्वासी गीन को भरोसा थन्डो पड़ जाहेत, अना वय एक दुसरो ला धरायेत, अना एक दुसरो लक घीरना करयेत। ");
INSERT INTO pwr_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","गजब सो खोटो भविस्यवक्ता पैदा हो जाहेत, अना गजब लोकगीन ला बहका देहेत। ");
INSERT INTO pwr_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","अधरम अना बुरो करम बढनो लक सब लोकगीन को माया थन्डो भई जाहेती। ");
INSERT INTO pwr_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","पर जोन अखीर धीरज राखेत, सब सह लेहेत, वोच बचायो जाहेत। ");
INSERT INTO pwr_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","यो परमेस्वर को राज को साजरो बारता सारो संसार मा लोकगीन जवर मुनादी करयो जाहेत। तबा सारो, संसार मा गवाही भय जाहेत तबा आखीर आ जाहेत। ");
INSERT INTO pwr_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","यो काजी जब तुमी उ उजाड़न वालो, बेकार चीज ला चोवो, जेनको चरचा भविस्यवक्ता दानीयल को किताब मा से, पवीतर जघा मा उभो चोवयो। (जो वाचेत वोला समजमा आय जाहेत) ");
INSERT INTO pwr_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","तब जोन यहुदिया नगर मा से उ सब पहाड़ी मा पराय जाय। ");
INSERT INTO pwr_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","अना जोन घर को छत मा से उ जुनूस लेवन ना उतरे। ");
INSERT INTO pwr_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","अना जोन खेत मा से, उ आपरो कपरा धरन काजी मघा नोको लवटे। ");
INSERT INTO pwr_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","वोना दिवस मा जोन पोट लक से, अना जोन अना वय माय जिनको नहानसो लेकरा सेत, वा बायकोगिन को गजब आफत सेत। ");
INSERT INTO pwr_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","तुमी पिराथना करो का जाड़ो को मौसम मा पवीतर दिवस मा नोको धावनो पडे़त। ");
INSERT INTO pwr_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","काहेका वोना बेरा मा असो आफद आहेत, जोन सारो जग बनान को बेरा लक, अबा तकन नही आइसेस, अर ना कभी आहेत। ");
INSERT INTO pwr_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","अदी वय दिवस कम नही करयो, जातो ता कोनी को भी तन साजरो नही बचतो पर निवाड़ो गयो, मानूस को कारन वय दिवस घटायो, गयो से। ");
INSERT INTO pwr_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","वोना बेरा कोनी सांगेत, का यीसु मसीह वहान सेत, का यहान सेत, तो तुमी बिस्वास नोको करजोस। ");
INSERT INTO pwr_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","काहेका खोटो मसीहा अना खोटो भविस्यवक्ता उभो होयेती, अना मोठयो-मोठयो चमतकार करतब दिसाहेत। उनको मकसद निवाड़ो गयो मानूस गीन ला बहकानो से। ");
INSERT INTO pwr_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","समजो मी ना तुमी ला पहले लक सांग दियो सेव। ");
INSERT INTO pwr_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","एको लाय यदि कोनी सांगेत, का चोवो यीसु जंगल मा सेत। किवाड़ लगायके राखने बाहेर नोको हिटने, अना वा घर मा से, तो बिस्वास नोको करने। ");
INSERT INTO pwr_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","काहेका जसो बीजरी दिन उगती लक हिट के दिवस बुडती तकन चमका से वसोच मानूस को टूरा आहेत। ");
INSERT INTO pwr_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","जहा लास सेत वहाँच गीधाड़ जमा होयेती। ");
INSERT INTO pwr_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","वोना दिवस मा अचरज दुख को मघा दिन इन्धार भई जाहेत। अना चन्दा को उजार खतम भई जाहेत। अना बादल मा जोन नक्सतर सेत, उ सब हिलायो जाहेत। तबा तारा चान्दनी बादल लक पड़ जाहेत। ");
INSERT INTO pwr_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","तबा मानूस को टूरा को हिदान बादल मा चोहेत, अना सब धरती को लोकगीन आपरो, सीना ला पिटेहेत। अना मोठयो, ताकत अना महिमा को संग बादल मा मानूस को टूरा ला आवता दिसेत। ");
INSERT INTO pwr_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","अना उ तुर्रा का मोठयो आवाज को संग, आपरो, सरगदूत गीन ला धाड़ेत अना सप्पा दुनिया पासुन आपरो निवाड़ो लोकगीन ला जमा करयेत। ");
INSERT INTO pwr_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","अँजीर को झाड़ को उदाहरन लक सीको, जबा वोको डगाली नरम होवासे अना पान हिटासे, तबा तुमला मालूम भई जासे, का उनहारो को मौसम आय गयोसे। ");
INSERT INTO pwr_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","असोच जबा तुम्हीला असो गोस्टी होवतो दिसेत। तो समज जावने का यो बेरा कठा नाहत, बल्की बेसकुड़ मा सेत। ");
INSERT INTO pwr_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","तुमरो लक खरो-खरो सागंसू, जब लक यो गोस्टी पूरो नही होयेत। तबा तकन यो जुग को आखीर नही होहेत। ");
INSERT INTO pwr_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","बादल अना धरती टल जाहेत, पर मोरो कव्हयो कदीच नही बदलेत। ");
INSERT INTO pwr_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","वोना दिवस अना वोना बेरा को बारेमा कोनीला मालूम नाहत, ना सरग दूत गिनला, ना मानूस को टूरा ला यो गोस्टी बस परमेस्वर बाबुजी ला मालूम सेत। ");
INSERT INTO pwr_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","जसो नूह को परलय को बेरा मा होतो, वसोच मानूस को टूरा को भी आवनो होहेत। ");
INSERT INTO pwr_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","काहेका परलय को बेरा को पयले, जोन दिवस तकन नूह जहाज मा नही चघयो होतो। वोना दिवस तकन लोकगीन जेवत-पिवत अना बिहा करत होतीन। ");
INSERT INTO pwr_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","अना पानी-पूरा आयो, अना सबला बाहाय के ले गयोअना मानूस गीनला काही पता नही चलो, वसोच मानूस को टूरा को भी आवनो होहेत। ");
INSERT INTO pwr_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","वोना बेरा मा दुई जन खेत मा सेत, एक सोड़ दियो जाहेत, अना दुसरो उचल लियो जाहेत। ");
INSERT INTO pwr_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","दुई बायका चकिया मा कनीक पीसत होतीन, वा मा लक एक उचल लियो जाहेती, अना दुसरी ला सोड़ दियो जाहेती। ");
INSERT INTO pwr_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","यो काजी तुमी जगत रव्हो अना पिराथना करत जावो, काहेका तुमीला यो मालुम नाहत का, खेत का मालिक मजे पिरभु कबा आवनवारो सेत। ");
INSERT INTO pwr_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","पर तुमी यो जान लेव का घर को मालिक ला मालुम होवतो का चोर कबा धसन वारा सेत। मंग उ जागत रव्हतो अना घर मा चोरी होवतो। ");
INSERT INTO pwr_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","यो कारन लक तुमी तैय्यार रव्हो जोन बेरा मा तुम्ही नही सोचा सेव वोच बेरा मानूस को टूरा आजाहेत। ");
INSERT INTO pwr_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","असो बिस्वास काबील अना अक्कलवारा दास कोन सेत? जोनला वोका मालीक ना नौकर गीन को वरता, मुकतियारी मा राखेत का सबला सहि बेरा मा वोला जेवन देहेत। ");
INSERT INTO pwr_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","“धन्य से उ दास जेनको मालीक जबा आवासेत, तो वोला उ मालीक वसोच, करता पाहेत।” ");
INSERT INTO pwr_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","मी तुमरो लक खरो कव्हसू, का उ आपरो सब धन माया को पर वोला मूनिम राखेत। ");
INSERT INTO pwr_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","“दूसरो पक्स मा एक बुरो दास से, जोन अपरो मन मा कव्हा सेत। मोरो मालिक लगत दिवस भयो लवटो नाहत। अबा उसीर से। ");
INSERT INTO pwr_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","अना आपरो संगी नौकर गिनला मारन लगे। अना बेवडा को संग जेवन अना पीवन लगे। ");
INSERT INTO pwr_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","तबा वोना दास को मालीक असो दिवस आहेत, जोन दिवस अना पलको बारेमा कोनी नही सोचयो होतो। ");
INSERT INTO pwr_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","तबा उ वोला कड़ो सजा देहेत। अना पाखन्डी गिनला वोको संग डाख देहेत, जहान रड़नो अना दात किचकीचानो होहेत। ");
INSERT INTO pwr_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“वोना दिवस सरग को राज वय दहा कुँवारी टूरी को जसो होयेत। जोन अपरी टेमा धरके नवरदेव ला मिरन हिटीन।” ");
INSERT INTO pwr_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","उनमा पाँच मुरख अना, पाँच हुसियार होतिन। ");
INSERT INTO pwr_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","मुरख न अपरी टेमा धरीन। तरी अपरो संग तेल नही आनीन। ");
INSERT INTO pwr_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","पर अक्कलवर गीन न अपरी, टेमा को संग कुप्पी मा भरके तेल आनीन। ");
INSERT INTO pwr_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","जबा नवरदेव को आवनो मा उसीर भई। ता वय सब उघंन लगीन, अना झोप गइन। ");
INSERT INTO pwr_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","अरधी रात ला धुम मची चोवो नवरदेव आवासे। वोको लक मिरन लाय चलो। ");
INSERT INTO pwr_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","तबा वय सब कुँवारी टूरी गीन जगके अपरी टेमा साजरी करन लगीन। ");
INSERT INTO pwr_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","अना मुरखगीन न अक्कलवर लक कहीन, “अपरो कुप्पी को तेल देव। काहेकि हमारो टेमा बुझसे।” ");
INSERT INTO pwr_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","पर अक्कलवर गीन न कहिन, आमरो लाय अना तुमरो लाय तेल पुन्ज जाय इतरो तेल नाहती। भलो त योच से की तुमी बिकन वालो को कठा जायके, अपरो लाई आनो। ");
INSERT INTO pwr_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","जबा वय लेवन साठी जावत होतीन, त नवरदेव आय गयो। अना जोन तैय्यार होतीन वय वोको संग बिहा के घर मा चली गईन, अना किवाड़ बंद कियो गयो। ");
INSERT INTO pwr_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","एको मंघा वय दुसरी कुँवारी टूरी गीन, आयके कव्हन लगीन, “हे पिरभु-हे स्वामी हमरो लाई किवाड़ उघाड दे।” ");
INSERT INTO pwr_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","वोना कहीस मी तुमला खरो कव्हसू, “मी तुमला नही चिन्हू तुमी कोन सेव?” ");
INSERT INTO pwr_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","एको लाई जगता रव्हो, तुमी वो दिवस अना उ बेरा को बारेमा मालुम नाहत। ");
INSERT INTO pwr_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“सरग को राज वोना मानूस जसो होयेत।” जोन परदेस जातो बेर आपरा, दास गिनला हाकलके, आपरी संपति उनको सुपरुत कर देईस। ");
INSERT INTO pwr_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","वोना एक ला खुरो को सिक्का लक भरयो पाँच पिवसी, दुसरो ला दोन अना तिसरो ला एक पिवसी उनको योगता को अनुसार दियो। अना मालिक यातरा मा हीट गयो। ");
INSERT INTO pwr_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","तबा जेना ला पाँच सिक्का लक भरयो पिवसी मिलयो होतो। उ लवकर जायके लेवन-देन करीस। अना आपरो अवकात को लक अखीन पाँच सिक्का को पिवसी कमा लेइस। ");
INSERT INTO pwr_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","असोच जोन ला दुई मिलयो होतो, ओना अखीन दुई कमायो। ");
INSERT INTO pwr_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","पर जोन ला एक मिलयो होतो। उ जायके माटी खोदिस, अना आपरो मालिक को रुपया को पिवसी ला जमीन मा लूका देइस। ");
INSERT INTO pwr_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","लगत बेरा बीतन को मंघा उनको आयो। अना दास गीनला लेखा जोखा मांगिस। ");
INSERT INTO pwr_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","जोन ला पाँच पिवसी सिक्का मिलयो होतो। ओना अखीन पाँच पिवसी सिक्का आनके कहीस, ओ मालीक तुना मोला पाँच पिवसी सिक्का दियो होतो। मि ना अखीन पाँच पिवसी सिक्का कमाई सेउ। ");
INSERT INTO pwr_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","ओको मालिक ना ओला कहीस, सबास साजरो बिस्वासी दास तु जरा सो मा लायक हिटसेस। मि तोला लगत चीज गीन को वरता, अधिकारी बनाहुँ। आपरो पिरभु को सँग खुसी मनाओ। ");
INSERT INTO pwr_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","अखीन जेनको कठा दुई पिवसी सिक्का होतीन, ओना भी आयके असोच साँगिस, हे मालिक तुना मोला दुई पिवसी सिक्का दियो होतो, चोव मिना अखीन दुई कमायो। ");
INSERT INTO pwr_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","ओको मालिक ओला कव्हयो साबास साजरो, अना बिस्वासी दास तु जरा सो मा लायक हिटयो से, यो काजी तोला लगत चीज को अधिकार देहुँ, तु भी आव अना आपरो मालिक को सँग खुसी मनाओ। ");
INSERT INTO pwr_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","जोन ला एक पिवसी सिक्का मिलयो होतो। ओना आयके कव्हयो, हे मालिक मोला मालुम सेत, का तु कठोर मानूस सेस, तु जहान नही बोवसेस वहान कापा सेस। अना जहान नही छिड़का सेस, वहान लक बटोरा सेस, तोला जवाब देवन को मोरो अवकात नही होत्यो। ");
INSERT INTO pwr_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","यो काजी मि डराय गयो होतो, अना जायके तोरो मोहर ला जमीन मा छिपाय दियो। चोव जो तोरो से उ यो से। ");
INSERT INTO pwr_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","ओको मालिक ना ओला जवाब देइस, वो नीच अना कोढया दास तु जानसेस, का मि जहान नही बोयि सेव, वहान लक कापा सेउ। अना जहान मि नही बोयो सेऊ, वहान लक कापासेऊ। ");
INSERT INTO pwr_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","तो तोला सोचनो होतो, का मोरो रुपया महाजन गीन ला दे देतो। तबा मी आयके आपरो धन ला ब्याज समेत ले लेतो। ");
INSERT INTO pwr_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","एको अवकात नाहती यो काजी वा सिक्का को पिवसी ओको लक ले लेव। अना जेनको जवर दहा पीवसी सिक्का से ओला देदेव। ");
INSERT INTO pwr_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","काहेका हरेक उ मानूस ला, जेनना जो काही वोको कठा होतो वोला सही रीत लक बौजिसेत ओला अखीन दियो जाहेत। अना जितरो ओको जरुरत सेत, वोको लक जादा मिल्हेत। पर उनलक जेनको कठा होतो। पर उ साजरो रीत लक नही बवजअ सेत, ओको कठा लक, बचो-कुचो सब ले लियो जाहेत। ");
INSERT INTO pwr_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","एकोलाय वो बेकार दास ला बाहेर इन्धार मा ढकेल देव, “जहाँन लोक रड़ेयेत अखीन दात किच किचानो होहेत।” ");
INSERT INTO pwr_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","जबा मानूस को टूरा आपरो गौरव को सँग, सरगदूत को सँग आहेत, अना गौरव को सिघासन मा बसेत। ");
INSERT INTO pwr_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","ता सबच जातिहुन ओको पुढ़ा संगरो जाहेत अना उ एक ला दुसरो लक वसोच बेगरो करेत, जसो एक गडरिया अपरी मेंढा ला सेरी लक बेगरो करासे ");
INSERT INTO pwr_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","अना मेढा गीन ला उज्जो कन अना सेरी गीन, ला डाकयो कन उभो करुँ। ");
INSERT INTO pwr_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","तबा मि आपरो उज्जो कन वालो लक कहुँ, ओ मोरो बाबूजी को धन्य साबास लोक आव वो राज को अधिकरि भय जावो, जोन सारो जग बनन को पहिले तुमरो लाइ, राजा ना तैय्यार कियो होतो। ");
INSERT INTO pwr_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","काहे का मि भुखो होतो अना तुमी ना, मोला जेवन दियो अना जबा मि तहान होतो, ता तुमी ना मोला पानी पिलायो अना मि परदेसी होत्यो, अना तुमी ना मोला आपरो घर मा रुकवायो। ");
INSERT INTO pwr_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","मि नंगा होतो, अना तुमी ना मोला झंगा दियो, अना मि बीमार होतो अना तुमी ना मोरो सुधि लियो अना, मि जेल मा होतो अना तुम मोरो लक भेटन आयो। ");
INSERT INTO pwr_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","तबा नेक मानूसगीन ओला जवाब देहेत, हे पिरभु आमी ना कबा तोला, भूखा चोयो अना जेवन दियो अना कबा, तु तहान होतो अना हमी ना पानी पिलायो। ");
INSERT INTO pwr_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","आमी ना कब तोला परदेसी चौयो, अना आपरो घर मा रुकवायो अना कब तु नंगरा होतो, अना हमीना झंगा दियो। ");
INSERT INTO pwr_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","आमी ना कब तोला बीमार चोयो अना जेल मा चोयो, अखीन तोरो लक भेटन आयो। ");
INSERT INTO pwr_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","तबा राजा उनला जवाब देहेत, मि तुम लक खरो कहुसेउ, का तुमी ना मोरो यो नहान-नहान भाऊ गीन मा लक कोनी, एक को सँग करीसेव उ मोरो सँग, करीसेव। ");
INSERT INTO pwr_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","तबा उ आपरो डाकयो कन, वालो लक सांगेत ओ सापित लोकगीन मोरो पुढा लक, कभी नही बुझन वालो अमर स्तो मा जावो, जोन इबलीस अखीन ओको सरगदूत गीन लाइ तैय्यार से, ");
INSERT INTO pwr_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","काहे का मि भुखो होत्यो अना तुमी ना मोला जेवन नही देयेत, मि तहान होतो अना तुमी ना मोला पानी नही देइसेव। ");
INSERT INTO pwr_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","मि परदेसी होतो अना तुमी ना मोला, आपरो घर मा जघा नही दियो, मि नंगरो होतो अना तुमी ना झंगा नही पहिनायत। मि बीमार होतो अना जेल म होतो, अना तुमी ना मोरो सुधी नही लियत। ");
INSERT INTO pwr_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","तबा वय जवाब देहेत, हे पिरभु हमी तोला कब भुखो अना, तहान, परदेसी अना नंगरो, बीमार जेल मा चोयो, अना हमी ना तोरो सेवा नही करयो। ");
INSERT INTO pwr_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","तबा उ उनला जवाब देहत, मी तुमिला खरो कव्हसू जोन ऐना लहान लेकरा को सँग मा काही नही करयत वसोच मोरो सँग नही करयत। ");
INSERT INTO pwr_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","अना वय अमर सजा भोगेत पर नेक मानूस, अमर जिंदगी मा धसेत। ");
INSERT INTO pwr_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","जबा यीसु यो सबच गोस्टी को सिक्सा देवनो पुरो भयो, तबा आपरो चेला गीन, ला कव्हन लगियो। ");
INSERT INTO pwr_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“तुमी लोकहुन जानसो, का दुई दिवस को मंघा फसह को तिहार से। अना मानूस को टूरा बैरीहुन को हात मा कूरूस मा चघावन लाय धरायो जावन वारो से।” ");
INSERT INTO pwr_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","तबा मुखिया याजक अना सयानो लोकगीन काइफा नाव को मोठो मुखिया याजक, को आँगन मा जमा भईन। ");
INSERT INTO pwr_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","अना ओन्हीसीन कोनो तरकीब लक यीसु ला धरन अना मार डाकन को मन बनाईन। ");
INSERT INTO pwr_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","मंग वय कव्हत होतीन, “आमला यो तिहार को दिवस नही करनो पाहिजे नही ता लोकहुन मा दंगा फसाद भयी सकासे।” ");
INSERT INTO pwr_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","यीसु बैतनियाह गांव मा सिमोन को घर मा जोन कोढ को, बीमारी लक होतो वोको घर रुकयो। ");
INSERT INTO pwr_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","तबा एक बायको यीसु को जवर आयी जबा यीसु जेवन लाई बसयो होतो, ओना एक कीमती इतर संगसंगमरमर को बरतन मा भरके आनिस अना ओना यीसु को डोस्की पर उबड़ाय देइस। ");
INSERT INTO pwr_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","चेलाहुन ना असो चोयके गुस्सा होय गयीन, अना पुसन लगीन, एतरो कीमती इतर नास कायलाई करीसेव? ");
INSERT INTO pwr_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","यो इतर ला आमी बिकता ता एक मोठो दाम मिलतो अना ओनो धन लक आमी गरीबहुन ला दे देता। ");
INSERT INTO pwr_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","यीसु जान गयो का वय काजक कव्ह रही सेत। एकोलाई उनलक कव्हयो, “तुमी ऐना बायका ला काहे तंगा रही सेव? ओना ता मोरो लाई भलाई करीसेस।” ");
INSERT INTO pwr_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","काहेका गरीब-गोर गीन, हमेसा तुमरो सँग रहेत, पर मि तुमरो सँग हमेसा नही रव्हन वालो सेऊ। ");
INSERT INTO pwr_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","मोरो गाड़ो जावनो को तैय्यारी को लाय ओना मोरो तन मा, यो सुगंध वारो इतर उडेलीसेस। ");
INSERT INTO pwr_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","मी खरो साँगसू का जबच कभी सारो जग मा जबा परमेस्वर को साजरो बारता मुनादी कियो जाहेत, तबा वहान यो गोस्टी को, चरचा जरुर कियो जाहेत। ");
INSERT INTO pwr_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","तबा यूदस इस्करियोति जोन बारा चेला मा एक चेला होतो। उ मुखिया याजक, को कठा गयो, अना ओको लक कहयो। ");
INSERT INTO pwr_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","अदी मि यीसु ला तुमला धराय देहुँ, ता तुमी लोक मोला काजक देव्हो? तबा उनना यहूदा ला खुरो को तीस सिक्का, देन को मनसा करीन ");
INSERT INTO pwr_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","वोच बेरा यहूदा यीसु ला धरावन को मौका ताकन लगयो। ");
INSERT INTO pwr_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","बेखमीर भाकर को तिहार को पयलो दिवस मा चेला गीन यीसु को जवर आयके, पुसन लगीन, “तोरो का मरजी सेत, का आमी तोरो खावन को लाई बेखमीर जेवन को तैय्यारी किता जायके करबिन?” ");
INSERT INTO pwr_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","ओना कहीस नगर मा फलानो मानूस को, कठा जायके ओको लक साँगजोस, गुरुजी कव्हसे मोरो जावन को बेरा, जवर आय गई से। मि आपरो चेला गीन को सँग, मा तोरो घर मा बलिदान को तिहार मनाहुँ। ");
INSERT INTO pwr_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","तबा चेला गीन ना यीसु को, हुकूम मानिन अना बलिदान को तिहार लाय तैय्यारी करीन। ");
INSERT INTO pwr_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","जबा जेवन रात भयो तबा वय, बारा चेला गीन को सँग, जेवन करन लाई बस्यो। ");
INSERT INTO pwr_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","जबा वय जेवन करत होतीन, तबच, यीसु चेला गीन ला कव्हन लगियो, “मी तुमरो लक खरो कव्हसू का तुमरो लक एक मोला धराय देहे।” ");
INSERT INTO pwr_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","एको पर वय गजब उदास भय गईन। अना हर एक ओको लक पुछन लगीन, ओ पिरभु का उ मि सेव? ");
INSERT INTO pwr_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","वोना जवाब देईस जोन मोरो सँग ठाव मा हात, डाकीसेस वोच से। ");
INSERT INTO pwr_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","मानूस को टूरा को बारे मा असो लिखयो से, उ ता जावसे पर ओना मानूस पर, हाय जेना लक मानूस को टूरा धरायो जाहे। अदी उ जलम नही लेतो, ता साजरो होतो। ");
INSERT INTO pwr_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","तबा वोको धरान वालो यूदस कव्हयो, हे गुरू का उ मिच आऊ? यीसु ना कहीस, “तु ता अपरो टोंड लक साँग दियोस।” ");
INSERT INTO pwr_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","जब वय जेवन करत होतीन, तबा यीसु ना भाकर लेईस। अना धन्य वाद माँग के ना तोड़के, चेला गीन ला देवन लगयो। अना कहीस, “या मोरो तन से।” ");
INSERT INTO pwr_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","मंग बटका ला लेइस, अना परमेस्वर ला धनवाद देइस। अना चेला गिनला कहीस, “तुमी सब येला पी लेव।” ");
INSERT INTO pwr_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","“यो मोरो रक्त से, जोन परमेस्वर को करार ला स्थापित करासेत। अना मोरो रक्त लगत लोकगिन को पापहुन को छिमा को लाय बोहायो गयो सेत।” ");
INSERT INTO pwr_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","मि तुमी लक कव्हसू का मी वोना दिवस तकन अंगूर रस नहीं पीविन जबा तकन अपरो परमेस्वर बाबूजी को राज मा तुम्हारो संग नवतो अंगूर रस नही पीहुँ। ");
INSERT INTO pwr_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","तबा वय भजन करतो हुवो, जैतून नाव को पहाड़ मा गईन। ");
INSERT INTO pwr_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","तबा यीसु ना उनला साँगीस, आज-राती तुम सबको मोरो पर लक भरोसा उठ जाहेत। काहेका गिरंथ मा लिख्यो से, “मि चरानवालो ला, मारिन अना करप को मेढा गीन, इतानि-उतानी पराय जाहेत। ");
INSERT INTO pwr_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","पर जित्तो होवन मँघा, तुमी लक पयले गलील को पहाड़ मा जाहुँ।” ");
INSERT INTO pwr_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","एको पर पतरस ना कहीस, “चाहे सबा तोरो पर लक बिस्वास सोड़ देहेत पर मी आखीर तकन बिस्वास करीन।” ");
INSERT INTO pwr_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","यीसु ना वोको लक कहीस, मी तोला खरो कव्हसू “आज राती कुकड़ा को बाग देवन, को पयले तु तीन बार मुकर के कहजोस, मि यीसु ला नही जानासू उ कोन से?” ");
INSERT INTO pwr_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","तबा पतरस ना कहीस, “तोरो सँग मरनो भी पडे़त ता मर जाहुँ,” सबच चेला गीन ना भी असोच कहिन। ");
INSERT INTO pwr_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","मंग यीसु उनको संग वोना जघा मा गयो जोन गतसमनी कहलावा सेत। अना आपरो चेला गीनला कव्हन लगयो, “इतानि बस जावो, जबा तकन मि उता जायके ना पिराथना करासू।” ");
INSERT INTO pwr_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","मंग यीसु पतरस अना जबदी को दुई टूरा गीनला आपरो सँग ले गयो, अना दुखी लक उदास भय गयो। ");
INSERT INTO pwr_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","मंग वोना अपरो संगी गिनला कव्हयो, “मोरो मन लगत उदास सेत, असो लगा सेत जसो मोरो जान हीटन वालो सेत। तुम्ही मोरो संग इतानी च रूको, अना चौकस रव्हो।” ");
INSERT INTO pwr_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","मँग उ जरासो, पयले जायके, टोन्ड को बल पड़यो अना असो पिराथना करन लगयो। “ओ मोरो परमेस्वर बाबू, अदी भय सकासे ता या दुखको बटकी मोरो पुढा लक टल जाय, पर जसो मि चाव्हुसू, वसो नही, पर तु जसो चाव्हसेस वसोच तोरो मरजी ला पूरी कर।” ");
INSERT INTO pwr_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","तबा उ आपरो चेला गीनको कठा गयो, अना वय झोपत होतीन तब यीसु पतरस लक कहीस, “का तुमी यो लायक भी नही सेव का मोरो सँग एक घडी जाग सकासेव? ");
INSERT INTO pwr_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","जागत रव्हो! अना पिराथना करो, का तुमी परिक्सा मा नोको पड़ो। आतमा ता तैय्यार से, पर तन कमजोर से।” ");
INSERT INTO pwr_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","मंग उ दुसरो बेरा जायके ना असो, पिराथना करन लगयो। “हे परमेस्वर मोरो बाबूजी अदी यो बटकी, मोरो बिना पिये नही हट सकसे ता तोरो मरजी पूरी कर।” ");
INSERT INTO pwr_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","तबा ओना मंग उन ला, झोपत पाइस, काहे का उनको डोरा मा जप होती। ");
INSERT INTO pwr_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","उनला उता छोडके, मंग चली गयो। अना वसोच तीसरो, बार पिराथना करीस। ");
INSERT INTO pwr_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","तबा ओना चेला गीन को कठा आयके उनलक कहीस, अबा झोपो अना अराम करो, चोवो वा बेरा आय गई से, अना मानूस को टूरा पापी गीनको हात धरायो जाहेती। ");
INSERT INTO pwr_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","उभो होय! चोवो मोरो धरान वालो कठा आय गईन। ");
INSERT INTO pwr_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","यीसु असो साँगत च होतो। तबा च, यूदस जोन बारा चेला गीनमा एक होतो आयो, अना ओको सँग मुखिया याजकगीन, अना सियानो गीन, गजब भीड़ को सँग हात मा लाठी, तलवार धरके ना आइन। ");
INSERT INTO pwr_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","वोको धरान वालो युदूस ना ईसारा करीस, जोन ला भी चुमु वाच यीसु से, ओला तुमी धर लेवने। ");
INSERT INTO pwr_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","मंग युदूस यीसु को कठा आयके, कहीस गुरू जी नमस्कार! अना ओला खुब चुमीस। ");
INSERT INTO pwr_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","यीसु ना ओको लक कहीस, ओ सँगी जोन काम को लाई तु आईसेस, ओला कर। तबा लोकगीन यीसु को कठा आयके वोला धर लेइन। ");
INSERT INTO pwr_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","यीसु को सँगी मा लक एक, तरवार खीच लेइस, अना मोठो मुखिया याजक को दास को, कान काट देइस। ");
INSERT INTO pwr_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","तबा यीसु ना कव्हयो, “आपरो तरवार आपरो मियान मा राख ले, काहेकि जोन तरवार चलावासेत, वय तरवार लक मारो जासे। ");
INSERT INTO pwr_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","का तोला मालुम नहात? का अबा मि पिराथना करहुँ अना सरगदूत गीन को बारा दल लक ज्यादा मोरो कठा आय जाहेत।” ");
INSERT INTO pwr_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","पर मी अदी असो करीन ता पवितर गीरंथ मा जो लिख्यो से, उ पूरो कसो होहे? एकोलाय, “असो होवनो जरुरी से।” ");
INSERT INTO pwr_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","वोना बेरा यीसु ना भीड़ लक कव्हयो, “का तुमी तरवार डन्डा अना हतियार धरके मोला असो धरन काहे आयीसेव? जसो का मी डाकु सेऊ, मि हर दिवस तुमला मंदिर मा सीक्सा देवत होतो, तबा तुमीना मोला नही धराइ सेव।” ");
INSERT INTO pwr_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","पर असो सब एकोलाय भई से का भविस्यवक्ता गीन, “को कही गई गोस्टी पूरी होहेत।” तबा सबा चेला गीन वोको कठा, लक पराय गईन। ");
INSERT INTO pwr_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","जोनना यीसुला धरी होतिन, वय यीसु ला धरके काइफा नाव को मोठयो मुखिया याजक को कठा ले गईन। जहान मोसे को नियम को गुरू गीन अना सियानो गीन, अना यहुदी नेताहुन जमा भई होतीन। ");
INSERT INTO pwr_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","पतरस दुहुर लक वोको, मंघा-मंघा मोठो मुखिया याजक को आँगन तकन गयो। अना भीतर जायके, का होवासे देखन लाई सिपाही गीन, को सँग बस गयो। ");
INSERT INTO pwr_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","मुखिया याजक अना सब पंचयात, यीसु ला मार डाकन को लाई, वोको विरोध मा अरोप अना खोटो, गवाही को खोज मा होतीन। ");
INSERT INTO pwr_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","पर लगत खोटो गवाह आवन को मंघा, भी कोनी मुद्दा नही पाईन। आखीर मा दुई जन आइन ");
INSERT INTO pwr_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","अना कहीन “एना साँगीसेस की मि परमेस्वर को मंदिर ला पाड़ देहुँ, अना तीन दिवस मा जसो को तसो कर देहुँ।” ");
INSERT INTO pwr_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","तबा मुखिया याजक उभो होयके कहीस, “तु कोनी जवाब नही देवासेत, लोकगीन तोरो विरोध मा, गवाही देवा सेत।” ");
INSERT INTO pwr_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","पर यीसु उगो-मुगो रहयो। मुखिया पुजारी ना ओको लक कहीस, “मि तोला जित्तो परमेस्वर की किरया देवासू, की अदी तु परमेस्वर को टूरा मसीह सेस, ता आमी ला कव्ह दे।” ");
INSERT INTO pwr_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","यीसु ना जवाब देयिस, “हव मी सेऊ। पर मी तुमी लक यो भी कव्हुसेउ, अता मानूस को टूरा ला सब लक ताकतवर परमेस्वर को उजो कन बसया हुया, अना बदल मा आवता चोवने।” ");
INSERT INTO pwr_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","मोठोयाजक असो आयक के आपरो, कपरा फाडके कहीस, “एना परमेस्वर की निन्दा बिरोध करीसेस, अता हम ला गवाह को का मतलब? ");
INSERT INTO pwr_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","तुम्ही ना परमेस्वर को बिरोधमा सांगतो आयकीसेव, अबा तुम्ही काजक सोचासेव?” “ओन्हीसीन जवाब देइन यो मार डाकन को काबिल से।” ");
INSERT INTO pwr_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","तबा ओन्हिसीन ओको टोन्ड मा थुकिन। अना ओला मुक्का मारिन अना काही ना चाटा मारीन अना कहिन। ");
INSERT INTO pwr_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","“हे मसीह हमरो कन लक आवन वारो गोस्टी ला साँग अना कव्हो, का तोला कोन ना मारिस?” ");
INSERT INTO pwr_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","अना पतरस बाहेर आँगन मा, बसयो होतो की एक बनिहारिन ना ओको जवर आयके कहीस, तु भी ता गलीली यीसु को सँगी आस। ");
INSERT INTO pwr_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","अना पतरस ना जवाब देईस, ओना सब को पुढ़ा यो कहके मनाही करीस, अना कहीस, मि नही जानासेऊ, की तु कउन को बारे कव्हसेस। ");
INSERT INTO pwr_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","जबा उ बाहेर डहलाना मा चली गयो, ता दुसरी बनिहार ना पतरस ला चोयके, जोन लोक वहान होतीन कहीस, यो भी ता यीसु नासरी को सँग होतो। ");
INSERT INTO pwr_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","मंग पतरस ना मना कर देईस अना सांगीस, मि कसम खासू, का मि ओना मानूस ला नही जानु। ");
INSERT INTO pwr_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","जरा देर मंघा जोन वहान उभया होतीन, ओन्हिसीन पतरस को जवर आयके कहीस, खरो खर तू भी उन मा लक एक सेस। काहे की तोरी बोली तोरो भेद सांगासे। ");
INSERT INTO pwr_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","तबा उ धिक्कारन लगयो, अना कसम खावन लगयो, की मि वो मानूस ला नही जानु। अना तुरुत, कुकड़ा ना चिल्लाय देईस। ");
INSERT INTO pwr_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","तबा पतरस ला यीसु की कही हुयी सबद हेत, आई की, कुकड़ा को बाग देनो को पहिले तु तीन डाई मोरो मनाही करजोस। अना उ बाहेर जायके जोर लक रड़न लगयो। ");
INSERT INTO pwr_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","जबा दिवस हिटयो, तबा सब मुखिया याजक, अना सियानो गीन, आपसी मा विचार करीन, का यीसु मार डाख्यो जाय। ");
INSERT INTO pwr_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","उनना यीसु ला बाँधीन, अना वोला पिलातुस राजा ला सोप देईन। ");
INSERT INTO pwr_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","जबा, यीसु को धरानवारा, यूदस ना चोवयो, का वोला दन्ड मिल्यो से। तब उ, गजब पस्तायो, अना उ खुरो को तीस सिक्का, वापिस आनिस। ");
INSERT INTO pwr_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","मीना निरदोस मानूस को खून को सौदा, अना पाप करीसेव। तबा मुखिया यजक गिन सांगीन, हमला एको लक, काजक कामसे? तूच जान। ");
INSERT INTO pwr_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","एको पर यूदूस ना, खूरो को सिक्का ला, मंदिर मा फैक दियो, अना वहान लक चलयो गयो, अना जायके फाँसी मा झूल गयो। ");
INSERT INTO pwr_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","मुखिया याजक गीन खुरो को सिक्का, ला सकल लेइन। अना कव्हन लगीन, मोसे को नियम लक यो सिक्का ला खजाना मा राखनो, पाप से। काहेका यो तो खून को किमत से। ");
INSERT INTO pwr_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","यो काजी आपसी मा, विचार करन को बादमा, उनना परदेसी गीन ला दफनान काजी, उन सिक्का लक, कुम्भार को जमीन खरीद लेइन। ");
INSERT INTO pwr_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","योच कारन लक, आज तकन, उ जमीन खून को जमीन कहलावसे। ");
INSERT INTO pwr_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","तबा काजक भविस्यवक्ता यीरमीयाह को लिख्यो, पूरो होवासे, उनना खुरो को तीस सिक्का लियो, ओतरो रकम लक इसरायल को लोकहुन ना, बेकिमती मानूस लाय राखी सेस। ");
INSERT INTO pwr_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","अना उनना यो सिक्का कुम्भार को जमीन लाय, दे दियो से जसो पिरभु ना, मोला हुकूम देइसेस। ");
INSERT INTO pwr_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","अबा यीसु राजपाल को पूढ़ा उभो होत्यो। राजपाल ना वोला पुसयो, का तू यहूदिगीन को राजा आस? यीसु ना जवाब दियो, तु खुदच कव्हसेस। ");
INSERT INTO pwr_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","मुखिया याजक, अना सियानोगीन, वोको पर लान-छान लगावत होतिन। पर यीसु ना कोनी जवाब नही दियो। ");
INSERT INTO pwr_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","एको पर पिलातुस ना यीसु ला कव्हयो, “का तू नही आयकासेत? का यो तोरो विरोध मा कितरो गवाही देवासे।” ");
INSERT INTO pwr_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","मंग भी यीसु ना काही सबद नही सांगयो। एको पर राजपाल ला, गजब ताजुब भयो। ");
INSERT INTO pwr_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","हरेक फसह सन-तीहार को बेरा मा राज पाल, लोकहीन को मनको अनुसार, एक कैदी ला छोड़त होतो। ");
INSERT INTO pwr_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","वोच बेरा यीसु को संग बरब्बा नाव को एक मानूस, जेल मा होतो। ");
INSERT INTO pwr_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","पिलातुस राजा ना लोकइन ला साग्यो। “तुमी काजक चव्हासो? मी तुमरो लाय कोनी ला छोडू? बरब्बा ला का यीसु ला? जो मसीह कहलावसे।” ");
INSERT INTO pwr_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","उ जानत होत्यो का, यीसु ला जलन, लक धरायो गयो से। ");
INSERT INTO pwr_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","जबा राजपाल पिलातूस न्याय आसन मा बसो होतो। ता वोकी बायको ना वोको जवर खबर धाड़ी होती, “वोना सीधो-नेक मानूस को संग काही नोको करजोस, मी ना वोको बारेमा एक सपना चोवीसेऊ जोनलक अज मी दिवस भर बेचैन होती।” ");
INSERT INTO pwr_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","पर मुखिया याजक अना बुजुरुग यहूदी नेतागिन ना भीड़ ला बहेका लेइन, का वय पिलातुस लक बरब्बा ला सोड़न अना यीसु ला मरवान की माँग करेत। ");
INSERT INTO pwr_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","जवाब मा राजपाल ना अखीन पुछयो, “तुम्ही काजक चव्हासो? दोंनो मा कोनी ला छोडनो से?” उनना जवाब दियो, “बरब्बा ला!” ");
INSERT INTO pwr_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","एको पर पिलातुस न उन लक कव्हयो, “मी यीसु जोन मसीह कहलावा से वोको का करु?” सबना जवाब देइन, “एला कूरूस मा चघा देव।” ");
INSERT INTO pwr_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","पिलातुस ना कहीस “काहे ओना काजक, बुरो करीसेस?” पर वय अखीन चिल्लावसेत अना कव्हसेत, “ओला कूरूस मा चघा ओ।” ");
INSERT INTO pwr_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","जब पिलातुस ना चोवयो, का यीसु ला बचावन को लाय कोनी, चांस नाहती। तबा उ उदास भई गयो, अना वोना पानी बुलवायके, ना हात धोवके सांगीस, “मी यो मानूस को खून को, दोसी नही सेव, तुमच जानो।” ");
INSERT INTO pwr_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","तबा सप्पा भीड़ ना जवाब देइन, “एको खून को बदला, आमी अना, हमरो सन्तान ला मिले।” ");
INSERT INTO pwr_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","तब पिलातुस न उनको लाय, बरब्बा ला छोड़ देइस। अना यीसु ला कोडा लगवाइस, अना कूरूस मा चघान, काजी सिपाई गीन को हातमा सोप देइस। ");
INSERT INTO pwr_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","एको मंघा राजपाल को सिपाही गीन, यीसु ला राजभवन को भीतर ले गइन। अना उनना यीसु को कठा सिपाही गीन, ला जमा कर लेइन। ");
INSERT INTO pwr_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","उनना यीसु को कपरा उतार के, वोला, लाल चोगा पहनाइन। ");
INSERT INTO pwr_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","अना झाड़ी को काँटा को मुकुट गुथ के वोको, डोस्की मा राखीन। अना वोको, उज्जो हात मा एक घागरा काड़ी धरा देइन। तबा वोको पुढा टोगंरा टेकके, असो मजाक करन लगीन। यहूदिगीन को राजा ला नमस्कार! ");
INSERT INTO pwr_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","उनना वोको पर थुकिन, अना घागरा काड़ी लक वोको डोस्की मा मारिन। ");
INSERT INTO pwr_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","असो मजाक करन को मंघा यीसु को, चोगा ला उतार लेइन, अना वोको कपरा पहना देइन। एको मंघा वय यीसु ला कूरूस मा चघा वन काजी ले गइन। ");
INSERT INTO pwr_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","नगर लक हिटतो बेरा मा, सैनीक गीन, एक कुरेन देस को रव्हनवारा, सिमोन नामको मानूस ला धरीन। अना वोला यीसु को कूरूस उचलन लाई कहीन। ");
INSERT INTO pwr_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","वय गुलगुता मजे कवटी नाव को, जघा मा पहूचीन। ");
INSERT INTO pwr_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","वहान लोकगीन पीत मिलयो अंगूर को रस, यीसु ला पीवन लाय देइन, यीसु वोला चख्यो, पर नही पीवयो। ");
INSERT INTO pwr_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","सीपाई गिनना, यीसु ला कूरूस मा चघा देइन। अना वोको कपरा ला आपसी मा बाट लेइन। ");
INSERT INTO pwr_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","एको मंघा वय वहान बसके पहेरा देवन लगीन। ");
INSERT INTO pwr_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","यीसु को डोस्की को वरता मा दोस पतर लटका देइन। वोमा लिख्यो होता, यहूदिगीन को राजा यीसु से। ");
INSERT INTO pwr_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","यीसु को संग, उनना दोन डाकुगीन ला, कूरूस मा चघा देइन। एक ला उज्जोकन, अना एक ला डायोकन। ");
INSERT INTO pwr_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","उता लक आवन-जावन वारा लोकगीन, यीसु को निन्दा बदी करत अना डोस्का हिलात। ");
INSERT INTO pwr_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","यो कव्हत होतीन, यो मंदिर ला गीरावन वारा, अना तीन दिवस मा, मंग बनान वालो, यदि तु परमेस्वर को टूरा आस, तो आपरो आप ला बचा। अना, कूरूस लक खाल्या आव। ");
INSERT INTO pwr_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","असोच मोसे को नियम को गुरू सयानो अना मुखिया याजकगीन, भी कव्हत-कव्हत मजाक करत होतीन। ");
INSERT INTO pwr_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“यो ना दूसरो ला बचाई सेस, पर आपरो आप ला नही बचा य सकसे, यो तो इसरायल जात को राजा से, अबा यो कूरूस लक खाल्या उतरे ता, हमी एको पर बिस्वास कर बीन। ");
INSERT INTO pwr_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","यो परमेस्वर पर बिस्वास राखासेत। यदि सचमा परमेस्वर एको लक खुस सेत तो अबा एको बचाव कर लेहत। काहेका यो ना साग्यो होतो, का मी परमेस्वर को टूरा सेव।” ");
INSERT INTO pwr_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","डाकुगीन यीसु को संग, सूली पर चघीन होतीन, वय भी असोच खरो-खोटो सांगन लगीन। ");
INSERT INTO pwr_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","दूफार 12 बजे लक 3 बजे को बेरा लक, सारो देस मा इन्धार छायो, रहयो। ");
INSERT INTO pwr_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","अना तीन बजे, यीसु ना जोर लक कव्हयो, “एली-एली लेमा सबकतानी,” जोन ओ मोरो परमेस्वर! ओ मोरो परमेस्वर! तूना, मोला काहे छोड़ देइसेस। ");
INSERT INTO pwr_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","यो आयक के जवर उभो लोकगीन, बोलन लगीन, यो भविस्यवक्ता एलिय्याह ला हाकल से। ");
INSERT INTO pwr_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","उन मा लक एक धावके ना, स्पंज आन लेइस अना वोला अंगूर रस सिरका, मा डुबाय के, घागरा काड़ी मा लगाके यीसु ला, पीवन दियो। ");
INSERT INTO pwr_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","पर बाकी बचयो लोकगीन ना सांगिन, चोवो एलिय्याह वोला बचा वन काजी आवासे, का नही। ");
INSERT INTO pwr_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","तबा यीसु ना मंग ऊचो आवाज मा हाकलके, आपरो जान छोड़ दियो। ");
INSERT INTO pwr_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","वोच बेरा मंदिर को पड़दा वरता लक, खाल्या तकन फट गयो, अना दोन टुकड़ा भई गई। जमीन हिलन लगी, भुईडोल भई अना, चट्टान फट गइन। ");
INSERT INTO pwr_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","मरघट्टी उघड़ गयो, अना गजबसो पवीतर सन्त महातमा, देह समेत दुबारा जित्तो भई गईन। ");
INSERT INTO pwr_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","अना वय यीसु को जित्तो, होवन को मंघा मरघट्टी लक हिट के, अना पवीतर नगर मा जायके, लगत लोक ला चोवन लगीन। ");
INSERT INTO pwr_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","सेना को मुखिया, अना पहरादार, सैनीक गीन भुईडोल अना, यो सब गोस्टी चोयके गजब डराय गइन। अना बोलन लगीन, खरो खर पक्को मा यीसु च परमेस्वर को टूरा आय। ");
INSERT INTO pwr_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","वहान गजब सी आई-माई गीन दुहूर लक चोवत होतीन। वय यीसु को सेवा करन वालो, गलील छेतर लक उनको संग-संग आई होतिन। ");
INSERT INTO pwr_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","उनमा मरियम मगदलनी, याकूब अना यीसु को माय अना जबदी को टूरा गीन को माय होती। ");
INSERT INTO pwr_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","सन्जा होवन को मंघा, अरिमितिया नगर को, एक धनी महाजन आयो। वोको नाव युसुफ होतो, उ खुद यीसु को चेला बन गयो, होतो। ");
INSERT INTO pwr_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","वोना पिलातुस राजपाल को कठा जायेके, यीसु को लास मागीस, अना पिलातूस ना हुकूम करीस, का देह वोला सौप दियो जाय। ");
INSERT INTO pwr_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","युसुफ देह धरकेना, वोला सुध्द मलमल को कफन मा लपेट के। ");
INSERT INTO pwr_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","नवो मरघट्टी मा ठेव दियो जोनला, वोना आपरो लाय चट्टान मा, खुदवायो होत्यो। उ मरघट्टी को, धसन को जघा मा एक मोठो गोटा लुढकाके चले गयो। ");
INSERT INTO pwr_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","मरियम मगदलनी दूसरी मरियम कबर को पुढा बसी होतिन। ");
INSERT INTO pwr_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","दुसरो दिवस मजे सूकिरवार को, मंघा पवीतर दिवस मा मुखिया पुजारी मोठयो पुरोहित अना, फरिसी गुरु गीन एक संग, पिलातुस को घरमा गइन। ");
INSERT INTO pwr_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","अना बोलिन की अमीला हेत से पिरभु, क उ धोकाबाज न आपरो, जिंदगी मा असो सांग्यो होतो, का मी तीन दिवस मघा जित्तो भई जाहू। ");
INSERT INTO pwr_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","कहि असो न होहे का चेला उचलके, ले जाये अना जनता लक सांगन लगेत, का यीसु जित्तो भई गईसे, यो मंघा को धोका लक जादा खोटो होहेत, यो काजी तीन दिवस लक कबर को, सुरक्सा को इन्तेजाम कियो जाय। ");
INSERT INTO pwr_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","पिलातुस ना कव्हयो “तुमरो कठा पहरेदार से” जाओ! अना जसो साजरो लगसे, वसोच तुमी करो। ");
INSERT INTO pwr_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","वय चले गइन, अना उनना कबर को, दरवाजा मा राख्यो गोटा मा मूहर लगा देइन। ");
INSERT INTO pwr_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","सब्त को मघा जबा इतवार हफ्ता को सक्कारी बेरा लाल बादल मा, मरियम मगदलीनी अना दूसरो बाया मरियम कबर ला जाँचन आइन। ");
INSERT INTO pwr_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","काहेका सरग लक पिरभु को सरग दुत वहान उतरियो होतो। एको लाई वोनोच बेरा एक मोठयो भुई डोल आयो। अना सरग दुत वहान आयके एक गोटा ला लुढकाय देइस अना वोको पर बसगयो ");
INSERT INTO pwr_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","वोको रूप बादर की उजाड़ जसो चमचमात होती। अना वोका कपरा बरफ को जसो सप्पा होतीन। ");
INSERT INTO pwr_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","वय सिपाई जोन कबर पर पहरा देत होतीन। डर को मारे कापन लगीन, अना मरो जसो भयी गयिन। ");
INSERT INTO pwr_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","सरगदूत ना आई-माई लक कहीस। नोको डराव, मी जानासू, तुम्ही यीसु ला ढुंढ रही सेव। जोनला कूरूस मा चघा यो गयो होतो। ");
INSERT INTO pwr_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","उ यहान नहात, उ जित्तो भई गई से। जसो, वोना साग्यो होतो। आव, अना चोवो, जहान यीसु ला ठेवो गयो होतो। ");
INSERT INTO pwr_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","अबा तुमी लवकर जायके ना, वोको चेला गीन ला सांगो का, यीसु मरो मा, जित्तो भई गई से। उ तुमरो लक पुढ़ा, गलील परदेस मा जाहेती। वहान उ तुम्ही ला चोहेत, चोवो मीना तुम्ही लोक गीन ला यो खबर सांग देई सेव। ");
INSERT INTO pwr_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","आईमाई गीन गदने मरघट्टी को जवर लक, डराय के चले गइन। अना अचंभा अना खुसी लक, चेला गीन ला यो खबर आयकवान लाय लवकर-लवकर धाइन। ");
INSERT INTO pwr_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","यीसु एकाएक रस्ता मा, आई-माई गीन लक भेटयो अना सूकी रव्हो असो कहीस। तबा वय यीसु को कठा गईन, अना पाय पड़के वोको स्तुती करीन। ");
INSERT INTO pwr_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","यीसु ना उन लक कहीस नोको भेव करो, जाओ अखीन यो खबर, मोरो भाऊ गीन ला आयको आयो। अना मी उनला, गलील परदेस मा भेटू वय वहान जाय। ");
INSERT INTO pwr_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","आईमाई गीन रस्ता मा होतीन। का काही सीपाई नगर मा आइन। अना सारो हाल, मुखिया याजकगीन ला कहिन। ");
INSERT INTO pwr_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","तबा मोठो याजक अना मुखिया सियानो गीन मिल्के अपसी मा विचार करीन। अना सिपाई गीन ला भारी रकम देके ना सांगीन। ");
INSERT INTO pwr_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","लोकगीन ला कव्हने, का रात मा, जबा हमी झोपयो होता। ता यीसु को चेला गीन आइन, अना वोला चोरा के ले गइन। ");
INSERT INTO pwr_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","यो बात राजा ला मालूम पड़हेत, तो हमी समझाय देबीन। अना तुमी चिन्ता नोको करो। ");
INSERT INTO pwr_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","चौकीदार गीन, रुपीया ले लेइन, अना वसोच करीन, जसो उनना सिकि होतिन। वसोच सांगन लगीन, अना योच कहानी फैल गयो। अखीन यहूदिगीन अबा लक, असोच माना से। ");
INSERT INTO pwr_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","तबा चेला गीन गलील छेतर मा वोना पहाड़ी मा गइन। जहान जान लाय यीसु ना उनला कव्हयो होतो। ");
INSERT INTO pwr_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","उनना यीसु ला चोवीन, अना वोकी अराधना करीन। पर कोनी-कोनी ला सक भयो। ");
INSERT INTO pwr_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","तबा यीसु ना, उनको जवर आयके सांगीस। मोला सरग मा अना धरती को पूरो अधिकारी बनायो गयो सेत। ");
INSERT INTO pwr_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","यो काजी तुमी जाओ, अना सब गैर यहुदी लोक गीन ला चेला बनाओ। अना उनला, परमेस्वर बाबूजी अना टूरा यीसु मसीह, अना पवीतर आतमा को नाव लक, पानी मा बप्तिस्मा देवो। ");
INSERT INTO pwr_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","अना मीना जोन-जोन हुकूम देइसेव। सब उनला माननो सिकावो, चोवो संसार को आखीर तकन, मी तुमरो संग सेव।");
INSERT INTO pwr_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","यो परमेस्वर को टूरा यीसु मसीह को साजरा बारता से। ");
INSERT INTO pwr_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","येको सुरुवात जसो की यसायाह भविस्यवक्ता को किताब मा लिखयो गयो होतो। की आयको, परमेस्वर ना कहीस “मि एक दुत ला धाड़ूसू, जो तोरो लाई रास्ता सुधारेत।” ");
INSERT INTO pwr_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","“बियाबान मा कोनी हाकल रहयो होतो, की पिरभु को गाडादान ला तैय्यार करो अना ओको पगदन्डी ला सीधो करो।” ");
INSERT INTO pwr_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","एकोलाय योहन आयो, अना मुनादी करयो “आपरो पाप लक मन हटाव अना बप्तिस्मा लेव, तब परमेस्वर तुमरो पाप ला छिमा करयेत।” ");
INSERT INTO pwr_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","अना यहुदिया छेतर लक अना यरुसलेम नगर का गजब सा रव्हन वारा हिटके योहन जवर आइन। अना आपरो पाप ला मानके यरदन नदी मा लक बप्तिस्मा लेइन। ");
INSERT INTO pwr_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","योहन ऊट को चुन्दी को कपरा घालत होतो। अना आपरी कमर मा चमड़ा को पट्टा बान्धत होतो। अना फाफा सहेद जेवत होतो। ");
INSERT INTO pwr_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","अना यो परचार करत होतो की “मोरो मंघा उ आवन वालो से जो मोरो लक ताकतवर से। मि यो काबिल नही सेऊ, की नवके ओको सेन्डिल की दोरी खोलू। ");
INSERT INTO pwr_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","मि तो तुमला पानी लक बप्तिस्मा देसू पर, उ तुमला पवीतर आतमा लक बप्तिस्मा देहे।” ");
INSERT INTO pwr_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","ओना बेरा मा यीसु ना गलील छेतर को नासरत नगर लक आयके, यरदन नदी मा योहन लक बप्तिस्मा लेइस। ");
INSERT INTO pwr_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","जसोच यीसु पानी लक हिटीस वसोच बादल उघड़तो हुयो अना पवीतर आतमा परेवा को जसो ओको वरता उतरतो चोवीस। ");
INSERT INTO pwr_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","अना बादल लक आवाज भई “की तु मोरो चहेतो टूरा आस, तोरो लक मि बेहद खुस सेउ।” ");
INSERT INTO pwr_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","तबा परमेस्वर की पवीतर आतमा ना गदने ओला जंगल कन ले गयो। ");
INSERT INTO pwr_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","अना जंगल मा चालीस दिवस तकन सैतान ना ओकी परिक्सा लेईस, अना उ जंगल-को जनावर को संग रहयो; अना सरगदूत ओकी सेवा करता रहीन। ");
INSERT INTO pwr_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","योहन ला जेल मा डाकनो को मंघा, यीसु ना, गलील छेतर मा आयके, परमेस्वर को राज को साजरा बारता ला परचार करन लगयो। ");
INSERT INTO pwr_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","अना कव्हयो “बेरा भई गई से, परमेस्वर को राज कठा आय गई से पाप ला छोड़ो अना साजरा बारता पर भरोसा राखो।” ");
INSERT INTO pwr_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","गलील को झील को कगर जावत-जावत, ओना समौन अना ओको भाऊ अन्दिरयास ला झील मा जाल डाकत देखीस, काहेकि वय ढिमर होतीन। ");
INSERT INTO pwr_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","अना यीसु ना उन लक कहीस “मोरो मंघा आव! ता मि तुमला मसरी धरन की जघा लोकगीन ला परमेस्वर को राज मा आननो सिकाहु।” ");
INSERT INTO pwr_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","वय गदने जाल ला सोड़के ओको मंघा भय गईन। ");
INSERT INTO pwr_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","काही दूहुर जायके ओना जबदी को टूरा याकूब, अना ओको भाऊ योहन ला, नाव मा जाल ला सुधारता चोविस। ");
INSERT INTO pwr_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","ओना गदने उनला हाकलीस, अना वय आपरो बाबूजी जबदी ला बनिहार को सँग नाव पर सोड़के, यीसु को मंघा चली गईन। ");
INSERT INTO pwr_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","यीसु अना चेलागीन कफरनहुम नगर मा आइन। अना उ गदने यहुदी गीन को बिसराम को दिवस मा पिराथना घर मा जायके सिक्सा देवन लगयो। ");
INSERT INTO pwr_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","अना लोक गीन ओको सिक्सा लक चकित भईन, काहे की उ उनला मोसे को नियम को गुरू जसो नही, पर अधिकार लक सिक्सा देवत होतो। ");
INSERT INTO pwr_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","अना ओनो बेरा, यहुदीगीन को सभाघर मा एक मानूस होतो। जोनमा एक भुत होतो। ");
INSERT INTO pwr_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","ओना चिल्लायके कव्हयो “ओ यीसु नासरी हमरो लक तोरो काजक काम से? का तु आमीला नास करन ला आईसेस? मी तोला जानासू, तू कोन आस? परमेस्वर कन लक धाड़ो गयो पवीतर मानूस आस!” ");
INSERT INTO pwr_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","यीसु ना भूत-पलीत ला डटकार के कहीस “उघो-मुघो रव्ह, अना ओमा लक हिट जाय।” ");
INSERT INTO pwr_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","तबा भुत ओला मरोड़ के अना मोठो आवाज लक बेमीया के ओमा लक हिट गयो। ");
INSERT INTO pwr_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","एको लाई सब लोकगीन अचंभा करता हुया आपस मा गोस्टी करन लगीन की “यो कसो गोस्टी आय? यो तो कोनी नवो सिक्सा से? उ अधिकार को संग भुत ला भी हुकूम देवासे, अना वय ओको हुकूम मानासेती।” ");
INSERT INTO pwr_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","एकोलाय या गोस्टी गलील छेतर को इतानी-उता लगत देस मा फैल गयो। ");
INSERT INTO pwr_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","जसोच यीसु पिराथना घर चेलागीन याकूब अना योहन को संग समौन अना अन्दिरयास को घर आयो। ");
INSERT INTO pwr_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","समौन की सासु बीमारी लक खाट मा लेटी होती एकोलाय वोको बारे मा यीसु ला सांगिन। ");
INSERT INTO pwr_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","तबा ओना जवर जायके ओको हात धर के ओला उचलीस अना ओको बुखार उतर गयो अना वा वोकी सेवा करन लगि। ");
INSERT INTO pwr_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","झुलाखाली जबा दिवस बुडतो बेरा भय गयो तो लोक सब बीमार ला अना जिनमा भुत आतमा होतीन यीसु को जवर आनीन। ");
INSERT INTO pwr_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","अना नगर को सप्पा लोकगीन बेसकुड़ को जवर एकठ्ठो भइन। ");
INSERT INTO pwr_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","अना यीसु लगत लोकगीन जोन गजब-गजब को बीमारी लक परेसान होतीन, उनला साजरो करीस, अना लगत बुरो आतमा ला हेड़िस। पर उनला बोलन लक मना करीस। काहे की वय ओला चिन्हत होतीन। ");
INSERT INTO pwr_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","यीसु पहट को बेरा दिवस हिटन लक लगत पुढा, जाग के हिटयो, अना एकांत जघा मा गयो, उता पिराथना करन लगयो, ");
INSERT INTO pwr_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","तबा समौन अना ओको संगी ओला ढुंढन ला गईन। ");
INSERT INTO pwr_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","जबा उ मिलयो, तो ओको लक कहिन “की सब लोक तोला ढुंढ रही सेत।” ");
INSERT INTO pwr_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","ओना उन लक कहीस “आव हमि अखीन कोनी गांव-बस्ति मा जाबिन, की मि उता भी साजरा बारता सांगु, काहे की मि परचार करन लाई आइसेव।” ");
INSERT INTO pwr_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","अता उ सप्पा गलील छेतर मा यहूदी गीन को पिराथना घर मा जायके गोस्टी सांगत होतो अना बुरो आतमा ला हेड़त होतो। ");
INSERT INTO pwr_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","एको मंघा एक कोढी यीसु कठा आयके ओको लक बिनती करन लगयो अना ओको पुढा टोघरा टेकके कव्हयो! “यदि तु चाव्हसेस तो मोला साजरो कर सकसेस।” ");
INSERT INTO pwr_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","ओना ओको पर दया करके हात बड़ाइस, अना ओला छुयके कहीस “मि चाव्हसू की तु साजरो होय जाय।” ");
INSERT INTO pwr_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","अना ओको कोढ सजरो भय गयो अना उ साजरो भय गयो। ");
INSERT INTO pwr_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","तबा यीसु न चेताय के वोला सार करीस। ");
INSERT INTO pwr_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","मंघा ओको लक कहीस “आयक! कोनी ला काही नोको कव्हजोस। पर जायके आपरो आप ला याजक ला दिखाजोस, अना आपरो साजरो होवन को बारे मा जो काही मोसे ना ठहराईसेस, ओला चढावा चढाजोस, का उनला गवाही भई जाय।” ");
INSERT INTO pwr_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","पर उ जयके यो गोस्टी ला लगत सांगन लगयो अना यहान तकन परचार भयो। की यीसु मंग खुल्लम-खुल्ला नही फिरयो। पर बाहेर जायके जगंली जघा मा रहयो। अना चारो कन लक लोक ओको जवर आवत होतिन। अना कोनी मोठयो नगर मा नही जाय सकयो। ");
INSERT INTO pwr_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","काही दिवस को बाद यीसु मंग कफरनहुम नगर मा आयो, अना असी खबर फैल गई का पहले जाहन यीसु रुकत होतो वोनच घर मा यीसु आयो से। ");
INSERT INTO pwr_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","मंग एतरो लोक इकठ्ठो भईन की किवाड़ को जवर पाय राखन लाय जघा नही होती अना यीसु उनला साजरा बारता आयकन लगयो। ");
INSERT INTO pwr_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","अना चार मानूस एक लकवा को मारयो हुयो ला, ओको कठा आनीन। ");
INSERT INTO pwr_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","पर जबा वय जमघट को कारन ओको जवर नही पहुच सकीन, ता जोन छपरी मा यीसु होतो वोको सड्डन ला उघाड देईन। अना जोन खाट मा लकवा को मारयो हुवो होतो वोला वय उतार देईन। ");
INSERT INTO pwr_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","यीसु ना उनको भरोसा देखिस अना उ लकवा को मारो हुयो ला कहीस “ओ टूरा, तोरो पाप छिमा भईन।” ");
INSERT INTO pwr_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","वहान पर काही मोसे को नियम को गुरू जी गीन उता बसी होतिन वय आपरो-आपरो मन मा सोचन लगीन। ");
INSERT INTO pwr_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","की “यो मानूस असो काय लाई कव्हसे? यो ता परमेस्वर की निन्दा करासे। परमेस्वर ला सोड़ कोनी पाप ला छिमा कर सकासे” ");
INSERT INTO pwr_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","गदने यीसु ना आपरो आतमा मा जान लेइस, वय आपरो मन मा असो विचार कर रही सेत, एकोलाय यीसु न कहीस “तुमी असी गोस्टी कायला सोचासेव” ");
INSERT INTO pwr_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","का वोको लक यो कव्हनो खरोसे का, तोरो पाप छिमा भयो, या का यो कव्हनो, ज्यादा सरल से? “का अपरी खाट उचल” अना चल ? ");
INSERT INTO pwr_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","पर जेनको लक तुम जान लेव की “मी मानूस को टूरा ला धरती पर पाप छिमा करन को भी हक से।” ओना ओनो लकवा को रोगी लक कहीस, ");
INSERT INTO pwr_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“मि तोला कहुँसू की उठ, आपरी खाट उचल अना आपरो घर ला जाय।” ");
INSERT INTO pwr_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","उ गदने उठयो अना आपरी खाट ला उठायके, सबको पुढा लक हिटके चलो गयो, एतरो पर सबच अचंभा करन लगीन अना परमेस्वर को बड़ाई करता हुया, यो कव्हन लगीन “की आमी ना असो कभी नही चोयो।” ");
INSERT INTO pwr_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","मंग यीसु हिटके गलील झील को किनार मा गयो अना सिक्सा देवन लग्यो, तबा सप्पा भीड़ ओको जवर आई। ");
INSERT INTO pwr_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","जात-जात उ ना हलफई को टूरा लेवी ला, जमा पटान की नाका मा बस्यो चोवयो, अखीन उ वोको लक साग्यो “मोरो मघा आव।” ता उ ओको मंघा भय गयो। ");
INSERT INTO pwr_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","लेवी को, घर मा जबा यीसु जेवन कर रहयो होत्यो, वहान पर लगत सा जमा वसूल करन वारो पापी अना चेला गीन, वोको मंघा आवन वालो सब लोकगीन वोको संग जेवन मा बसया होतीन। ");
INSERT INTO pwr_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","फरिसी अखीन यहूदि मोसे को नियम को गुरू, ना यो चोयके की उ ता पापी गीन अना जमा वसुलन वारो को संग जेवन करासे, ओको चेला गीन ला कहिन “यीसु जमा वसुलन वालो अना पापगिन को संग काहे खावासे पिवासे।” ");
INSERT INTO pwr_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","जबा यीसु आयकिस ता असो कव्हन लगयो “साजरो गीनला बईद को काजक जरुरत से? पर बीमार ला से मि नेक मानूस ला नही पर पापी गीन ला हाकलन लाय आयी सेऊ।” ");
INSERT INTO pwr_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","योहन को चेला अना मोसे को नियम को गुरू को चेला उपास करत होतीन, एकोलाय मोसे को नियम को गुरू ओला आयके असो कहिन, की योहन का चेला अना धरमगुरू का चेला काहे उपास राखासेति? पर तोरा चेला उपास नही राखत। ");
INSERT INTO pwr_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","यीसु ना उन लक कहीस की “जबा तकन बराती नवरदेव को संग मा रव्हासे, तबा तकन का वय उपास कर सका सेति? नवरदेव को संग बराति भुखा नही रव्ह सकत ");
INSERT INTO pwr_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","पर वय दिवस आहेत की नवरदेव उन लक बेगरो कियो जाहे, ओनो बेरा वय उपास करहेति।” ");
INSERT INTO pwr_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“नयो कपरा को थेगड़ जुनो घालन को कपरा मा कोनी नही लगावासेत; काहे की उ थेगड़ ओमा लक काही खिच डाकहे, मन्जे नयो जुनो लक अखीन उ फट जावासे। ");
INSERT INTO pwr_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","नवा अंगूर को रस ला जुनो चमड़ा को थैला मा कोनी नही राखत नही ता अंगूर रस चमड़ा को थैला ला फाड़ डाकेह अखीन अंगूर रस अना चमड़ा को थैला दुही नास भई जाहे एको लाई नवा अंगूर रस ला नयो चमड़ा को थैला मा भरो जावसे।” ");
INSERT INTO pwr_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","असो भयो का उ यहुदीगीन को बिसराम को दिवस मा खेत मा लक भयके जावत होतो अना ओको चेला चलत-चलत बाल तोड़न लागीन। ");
INSERT INTO pwr_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","तबा फरिसी गीन यीसु लक कहिन “चोय; या लोकगीन मोसे को नियम लक बिसराम को दिवस मा असो कायलाई करयेत जोन साजरो नाहत?” ");
INSERT INTO pwr_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","यीसु उनला कव्हन लगयो “का तुमी कबच नही बाचीसेव की जबा दाऊद राजा अना ओको सँगी भुखा होतिन, तबा उनना काजक करी होतिन? ");
INSERT INTO pwr_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","ओना कायलाई अबियातार मुखिया याजक को बेरा, याजक को घर मा जायके, परमेस्वर को भेंट को भाकर खाईन मोसे को नियम लक जिनला खावनो याजक ला छोड़ अखीन कोनी ला बेस नही होतो अखीन आपरो संगीगिन ला भी देइस।” ");
INSERT INTO pwr_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","अखीन ओना उन लक कहीस “बिसराम को दिवस मानूस लाय बनयो से, न की मानूस बिसराम दिवस लाय। ");
INSERT INTO pwr_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","एकोलाय मानूस को टूरा बिसराम को दिवस को भी मालिक से।” ");
INSERT INTO pwr_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","मंग जबा यीसु पिराथना घर मा गयो अना उता एक मानूस होतो जेनको हात सुकयो होतो। ");
INSERT INTO pwr_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","धरम गुरू ओला दोस लगावन लाई ओको दाव देखत होतीन की देखबिन, उ बिसराम को दिवस मा ओला साजरो करेत का नही। ");
INSERT INTO pwr_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","ओना सुक्को हातवालो मानूस ला कहीस “बीच मा उभो होय।” ");
INSERT INTO pwr_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","अना उन लक कव्हसे “का मोसे को नियम लक बिसराम दिवस साजरो करन लाई नही से? का जान ला बचावन लाई नही से” तबा वय चुपई भई गईन। ");
INSERT INTO pwr_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","यीसु ना फरिसी को कड़ो मन ला चोयके उदास भय गयो, अना हिजड़ के चारो कन चोयीस अखीन ओनो मानूस ला कहीस “आपरो हात बढाव।” ओना बढाईस, अखीन ओको हात साजरो भई गयो। ");
INSERT INTO pwr_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","तबा फरिसी बाहेर जायके गदने हेरोदि गीन को राजा को लोक गीन संग मा ओको विरोध मा सलाह करन लगासेत, की कसो करके ओला नास करबिन। ");
INSERT INTO pwr_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","अखीन यीसु चेला को संगा गलील झील को कन चली गयो। यहुदिया छेतर अखीन गलील लक एक मोठी भीड़ ओको मंघा भई गई। ");
INSERT INTO pwr_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","अखीन यहुदिया अखीन येरुसलेम नगर अखीन इदुमिया लक अखीन यरदन नदी को पार अना सूर अना सैदा को इता उता लक एक मोठयो भीड़ यो आयक के की उ कसो अचंभा को काम करासे ओको जवर आइन। ");
INSERT INTO pwr_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","अखीन ओने आपरो चेला लक कहीस “भीड़ भई गई से एको लाई मोरो लाई एक नान्होसो नाव तैय्यार राखने जेनको लक वय मोला नही दबाय सकेत।” ");
INSERT INTO pwr_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","काहे की ओना लगत ला साजरो करत होतो; एकोलाय जेतरा लोक कोढ को बीमार होतीन, ओला छुवन लाई ओको पर गिरत पड़त होतीन। ");
INSERT INTO pwr_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","अना बुरो आतमा जबा ओला ताकत होतीन तो ओको पुढा गिरत पड़त होतीन अखीन चिल्लाय के कव्होत होतीन की “तु परमेस्वर को धाड़ो हुयो पवीतर टूरा आस” ");
INSERT INTO pwr_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","यीसु ना उनला डटकार के हुकूम देसे, मोरो बारे मा कोनी ला नोको सांगना की “मी कोन सेव” ");
INSERT INTO pwr_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","यीसु मंग पहाड़ पर गयो अना जिन ला उ चाव्हत होतो उनला आपरो कठा हाकलीस। अना वय ओको कठा चली गईन। ");
INSERT INTO pwr_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","तबा ओना बारा मानूस ला बेचयो अना उनला पेरीत ठहाराइस की वय ओको सँग- सँग रहेत अखीन उ उनला धाड़ेह की वय साजरी बारता परचार करेत, ");
INSERT INTO pwr_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","अखीन बुरो आतमा को हेड़न को हक राखेत। ");
INSERT INTO pwr_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","अखीन वय यो सेति समौन जेनको नाव ओना पतरस राखिस। ");
INSERT INTO pwr_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","अखीन जबदी को टूरा याकूब अना याकूब को भाऊ योहन जेनको नाव ओना बुअनरगिस मजे गरजन को टूरा राखिस। ");
INSERT INTO pwr_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","अखीन अन्दिरयास अना फिलिप्पुस अना बरतुल्मै अना मत्ती अना थोमा अना हलफई को टूरा याकूब अना तद्दै अना समौन कनानी ");
INSERT INTO pwr_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","अना यूदूस इस्करियोति, जेने ओला धराइस। ");
INSERT INTO pwr_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","तबा यीसु घर आयो अना असी भीड़ उमड़ी की यीसु अना ओको चेला ला जेवन की बेरा नही मिली। ");
INSERT INTO pwr_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","जबा ओको नातावारा ना यो आयकिन तो ओला धरान लाई हिटीन काहे की वय कव्हत होतीन की ओको दिमाग ठीकान मा नाहत। ");
INSERT INTO pwr_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","अखीन मोसे को नियम को गुरू जोन येरुसलेम लक आई होतिन यो कव्हत होतीन “ओमा बुरो आतमा से,” अना यो भी की “उ बुरो आतमा को मुखिया बालजबूल को सक्ति लक बुरो आतमा ला हेड़ासे।” ");
INSERT INTO pwr_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","अना उ उनला जवर हाकलके उन लक हाना देके साँगन लगयो “सैतान कसो सैतान ला हेड़ सकसे?” ");
INSERT INTO pwr_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","अना अदी कोनी को राज मा फुट पड़ जासे ता उ घर काय लाई अडिग रव्ह सकसे? ");
INSERT INTO pwr_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","अना अदी कोनी घर मा फुट पड़ जाहे ता उ घर कायलाई अडिग रव्ह सकासे? ");
INSERT INTO pwr_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","अदी सैतान आपरो विरोध करेत अना आपरो मा फुट डाकेह ता उ कायलाई बनो रव्ह सकासे? ओको ता सत्यानास होय जाहे। ");
INSERT INTO pwr_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“पर कोनी ताकतवर मानूस को घर मा जायके जबा तकन बाँध नही लेहे, तब तकन ओको घर लुट नही सका।” ");
INSERT INTO pwr_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“मि तुमी लक खरो बात सागुंसू, की मानूस को सब पाप अना निन्दा जोन वय करसेति, छिमा कियो जाहेति। ");
INSERT INTO pwr_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","पर जोन कोनी पवीतर आतमा को विरोध मा निन्दा करेत, उ कबच छिमा नही कियो जाहे पर उ अमर पाप को दोसी ठहरेति।” ");
INSERT INTO pwr_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","काहेकि वय यो कव्हत होतीन, की ओमा बुरो आतमा से। ");
INSERT INTO pwr_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","यीसु की माय अना ओको भाऊ आइन, अना बाहेर उभा भयके ओला हाकलन धाड़ीन। ");
INSERT INTO pwr_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","अना भीड़ ओको आजुबाजु बसी होतीन, अखीन ओन्हीसीन ओला कहीन “चोवो, तोरी माय अना तोरो भाऊ बहिन बाहेर तोला ढुढासेत।” ");
INSERT INTO pwr_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","ओना जवाब साँगीस का “कोन मोरो माय अना भाऊ सेत” ");
INSERT INTO pwr_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","ओना नजर इता-उता घुमायके कव्हसे “दिसो, यो आय मोरो माय अना भाऊ। ");
INSERT INTO pwr_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","काहेकि जोन कोनी परमेस्वर को मरजी पर चलासे, वोच मोरो भाऊ अना बहिन अना माय आय।” ");
INSERT INTO pwr_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","यीसु मंग झील को कगर सिक्सा देवन लागयो असी भीड़ जमघट भई की उ झील मा एक नाव पर चघके बस गयो, अना सारी भीड़ भुई मा झील को कगर मा उभी रहयी। ");
INSERT INTO pwr_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","अना उ उनला हाना मा लगत सी गोस्टी सिकावन लगयो। अना आपरो परवचन मा उनलक कहीस। ");
INSERT INTO pwr_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“आयको एक बोनी करन वालो बीज बोवन ला हिटयो। ");
INSERT INTO pwr_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","अखीन बोवतो बेरा काही ता रास्ता को कगर गिरयो अना पक्सी ना आयके ओला चुग लेइस। ");
INSERT INTO pwr_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","अना काही ता गोटाडी जमीन पर गिरयो, जिता ओला लगत माटी नही मिलनो लक अखीन गहरो न होवनो लक गदने उग आयो ");
INSERT INTO pwr_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","अना जबा दिवस हिटयो ता ओला जराय डाकिस, अना जड़ नही धरन लक सूक गयो। ");
INSERT INTO pwr_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","अना काही ता झाड़ी मा गिरयो, अना झाड़ी न मिलके दबाय डाकिस। अना ओमा फर नही लगयो। ");
INSERT INTO pwr_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","पर काही साजरो जमीन मा गिरयो अना उगयो, ता जो काही बोयो गयो से ओमा कोनी तीस गुना अखीन कोनी साठ गुना अना कोनी सौगुना फर लगयो।” ");
INSERT INTO pwr_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","यीसु कव्हसे, “जेका कान सेति वय जरुर आयक लेयेत।” ");
INSERT INTO pwr_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","जबा यीसु एकलो रव्ह गयो ता ओको सँगी ना जोन बारा होतीन येने किस्सा को मतलब पुसिन। ");
INSERT INTO pwr_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","ओना उन लक साँगीस, “तुमला ता परमेस्वर राज को भेद को लुकयो गोस्टी सांगयो गई से, पर बाहेर वालो ला नही, एको लाई हाना देके आयकायो जाहेत।” ");
INSERT INTO pwr_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","एकोलाय का “वय डोरा लक चोवयेत पर, उनला सुझाई नही पड़हेत, अना वय आयकेत, पर समझ मा नही आहेत, कही असो ना भई जात का वय परमेस्वर को कन मुड़ जाहेत, अना परमेस्वर उनला छिमा कर देहेत।” ");
INSERT INTO pwr_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","मंग यीसु ना कहीस, “का तुमी यो हाना नही समझीयत? ता मंग अखीन गोस्टी ला कसो समझने? ");
INSERT INTO pwr_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","बोवन वालो गोस्टी बोवासे। ");
INSERT INTO pwr_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","जो रास्ता को कगर का सेत, जिता गोस्टी बोयो जासे, यो वय सेत की जबा उनना आयकिन ता सैतान गोस्टी ला जोन बोयो गयो से उचल ले जासे। ");
INSERT INTO pwr_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","अना वसो जो गोटाड़ी जमीन पर बोयो जासे यो वय सेत, की जो गोस्टी ला आयक के खुसहाली लक अपनाय लेवसे। ");
INSERT INTO pwr_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","पर परमेस्वर को गोस्टी उनको भीतर सदा को लाई जड़ नही धरयो। वय जरा सो दिवस लाई रव्हसेत; येको मंघा जबा गोस्टी को काजी लक उन पर मुसीबत आवासे ता वय ठोकर खावसेत। ");
INSERT INTO pwr_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","अना जोन झाड़ी मा सेत, यो वय सेत जिनना गोस्टी ला आयकिन ");
INSERT INTO pwr_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","अना संसार को चिन्ता अना धन को लोभ अना अखीन चीज गीन को बुरो लोभ उनमा समायके उन ला दबाय देसेत। अना उ बेफर भई जावसे। ");
INSERT INTO pwr_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","अना जोन साजरी जमीन मा बोयो गयो सेत, यो वय सेत, जोन गोस्टी आयक के अपनाय लेसेत अना फसल आनासेत, कोनी तीस, कोनी साठ अखीन कोनी सौ गुना।” ");
INSERT INTO pwr_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","यीसु ना उन लक कहीस, “घर को भितर दियो एकोलाय नही आनसेत, की हमी ओला खाट को खाल्या डलिया मा राखबीन पर एकोलाय आनसेत की फूल पर राखेत? ");
INSERT INTO pwr_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","काहेकि कोनी चीज लुकी नही, पर उघाड़ो जाहेत। अना ना काही छुपयो मा से जेनला सब ना चोवयेत ");
INSERT INTO pwr_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","कान खोल लेव अना आयक लेव।” ");
INSERT INTO pwr_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","मंग ओना उनलक कहीस; “चाक पाक रव्हने, की का आयकासो? जेना तरिका लक तुमी दुसरो ला परखसो, ओको लक लगत तुमला परखो जाहे जेना नाप लक तुमी कोनी ला नापसो, वाच नाप परमेस्वर तुमरो लाई नापेह, ओको लक भी लगत नापेह। ");
INSERT INTO pwr_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","काहेकि जेनको जवर से, ओला दियो जाहे। पर जेनको जवर नाहती ओको लक जोन ओको जवर से, हिसक लियो जाहे।” ");
INSERT INTO pwr_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","मंग ओना कहीस “परमेस्वर को राज असो से, जसो कोनी मानूस जमीन मा बीज बोवासे। ");
INSERT INTO pwr_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","अना उ रात मा सोय जासे अना दिवस ला जागासे अना उ बीज असो बढासे की उ नही जान पावसे। ");
INSERT INTO pwr_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","जमीन आप लक आप फसल ला बनासे अना गँहु अँकुर बनासे अना बढ़ासे अना दाना पकासे। ");
INSERT INTO pwr_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","पर जबा फसल पक जावसे, तबा उ इरा चलावासे, काहेकि कटनी को बेरा आय जासे।” ");
INSERT INTO pwr_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","मंग यीसु ना कहीस “परमेस्वर को राज कोनको जसो से। परमेस्वर को राज ला समझन लाई कोन सो हाना ला काम मा लेवबिन। ");
INSERT INTO pwr_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","उ राई को दाना जसोकि जबा जमीन मा बोयो जासे, ता जमीन को सब बीजा लक नहानो होवासे। ");
INSERT INTO pwr_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","पर जबा बोयो जासे ता उगके सब हिवरो साग लक मोठो भई जावासे, अना ओको असो मोठो डार हिटासेत की बादल का पक्सी ओको पर गोदा बनावासेत।” ");
INSERT INTO pwr_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","अखीन यीसु उनला यो तरीको लक लगत सा हाना दे देयके उनको समझ को जसो गोस्टी साँगन लग्यो ");
INSERT INTO pwr_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","अखीन बिना हाना साँगयो उन ला काही नही साँगत होतो, पर एकलो मा उ आपरो चेला ला सब गोस्टी ला समझावत होतो। ");
INSERT INTO pwr_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","ओनो दिवस जबा दिवस बुड़ गयो ता ओना उन लक कहीस “आव हमी झील को ओनागन चलबिन।” ");
INSERT INTO pwr_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","अना उ भीड़ ला छोडके आपरो संगीगिन को सँग नाव पर चघके चली गयो अना ओको सँग अखीन नाव होतीन। ");
INSERT INTO pwr_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","तबा मोठी आँधड़ आयी अना पहला चलन लक नाव मा पानी भरन लगयो। ");
INSERT INTO pwr_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","अना यीसु जहाज को मंघा गद्दी मा झोप रहयो होत्यो, तबा चेलागीन ना जगाय के कहिन “हे गुरुजी हमि नास होय रही सेजन, का तोला हमारो चिंता नाहत?” ");
INSERT INTO pwr_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","तबा ओना जाग के आँधी अना पानी ला हुकूम देइस। “सानत हो अना थमजा” अना आँधी वोतरो बेरा मा थम गई। अखीन मौसम सानत भय गयो। ");
INSERT INTO pwr_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","ओना उन लक कहीस; “कायलाई डरासो? का तुमला अबा तकन भरोसा नहाय?” ");
INSERT INTO pwr_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","अखीन वय गजब डराय गईन होतीन, अना आपसी मा कव्हन लगीन की “यो कसो मानूस से की जेकी हुकूम ला वारा अना पानी को लहर भी मानासेती?” ");
INSERT INTO pwr_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","यीसु अना ओको चेला झील को ओनागन गिरोसेनियो नाव को जघा मा पहुचीन। ");
INSERT INTO pwr_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","अना जबा उ नाव लक उतरीन तो गदने एक मानूस जेने पर बुरो आतमा धसी होतो, मरघट्टी लक हिटके ओला मिलयो। ");
INSERT INTO pwr_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","उ मरघट्टी म रव्हत होतो। अना कोनी ओला साकल लक बाँध नही पाइन। ");
INSERT INTO pwr_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","काहे की उ लगत गन साकल लक बाँधयो गयो होतो पर ओना उन साँकल ला भी तोड़ दियो होतो। अना बेडी ला भी टुकड़ा-टुकड़ा कर डाकिस, अना कोनी ओला बस नही कर पाइन काहेका उ लगत बलवान होतो। ");
INSERT INTO pwr_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","उ रोज-रोज मरघट्टी अना पहाड़ मा बेमियात होतो। अना आपरो आप ला गोटा लक घायल करत होतो। ");
INSERT INTO pwr_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","उ यीसु ला दुहुर च लक चोवके धायो। अना वोनो होयके डोस्का टेकिस। ");
INSERT INTO pwr_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","अना उचो आवाज कव्हसे “हे यीसु सब लक वरता मा रव्हन वालो मोठो परमेस्वर को टूरा, मोरो लक तोरो का काम? मि तोला परमेस्वर को किरया देवसू की मोला तकलीफ नोको देस।” ");
INSERT INTO pwr_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","काहेकी यीसु न वोको लक कहीस “अरे भूत-पलीत यो मानूस मा लक हिट जाय।” ");
INSERT INTO pwr_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","यीसु ना ओको लक पुसीस की “तोरो काजक नाव से?” ओना जवाब देइस “सार संगाड़ से। काहे की हमि लगत सारी सेजन” ");
INSERT INTO pwr_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","अना वय वोको लक गजब बिनती करीन “आमीला यो छेतर लक नोको हेड़स।” ");
INSERT INTO pwr_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","उता पहाड़ी को ढलान मा खालमानी को एक करप चरत होतो। ");
INSERT INTO pwr_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","सार-सांगड़ ना यीसु लक गीड़गीड़ायके बिनती करीन की “आमीला खालमानी मा डाक देव।” ");
INSERT INTO pwr_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","तबा यीसु ना ओला हुकूम देइस। की हिट जाव, तबा सारो सार संगाड़ ओमा लक हिटके खालमानी को करप मा धस गई। अना करप जिनको गिनती दोन हजार को होती, लवकर झपट के झील मा धस पड़यो। अना बूड़ के मर गयो। ");
INSERT INTO pwr_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","अना चरानवारा ना धायके नगर अना गांव मा यो खबर बिखराय देइन। ");
INSERT INTO pwr_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","अना असो भयो ता ओला देखन ला लोक आइन। यीसु को जवर आयके वय वोनो मानूस ला जेमा भुत-पलीत झोमयो होत्यो कपरा घालयो हुयो अना बड़िया डिमाक चोयके डराय गीन। ");
INSERT INTO pwr_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","अना चोवनवारा गीनना उनला सांगीन, का भुत झोमयो हुयो मानूस अना खालमानी को सप्पा हाल, कसो भयो? ");
INSERT INTO pwr_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","अना वय ओला बिनती करके कव्हन लागीन, की हमरो सिवानो लक चली जाय। ");
INSERT INTO pwr_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","अना जबा उ नाव पर चघन लगयो। तो उ जोन मा पयले भुत पलित होतीन, ओकोलक बिनती करन लगयो, की “मोला आपरो सँगा आवन दे।” ");
INSERT INTO pwr_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","पर ओना ओला मना कर देईस अना ओला कव्हासे, “आपरो घर ला जाव अना जो काही पिरभु ना तोरो पर दया करीसेस, वोनो मोठो काम ला साँग।” ");
INSERT INTO pwr_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","उ जायके दिकापुलिस मा यो गोस्टी को परचार करन लगयो। की यीसु ना मोरो लाई कसो मोठो काम करीसेस। अखीन सप्पा ना मोठो अचंभा करीन। ");
INSERT INTO pwr_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","जबा यीसु मंग नाव लक ओनागन गयो ता एक मोठी भीड़ ओको जवर आयी, अना उ झील को जवर होतो। ");
INSERT INTO pwr_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","अना याईर नाव को सभाघर को मुखिया मा लक एक मानूस आयके, ओको पाय पड़न लगयो। ");
INSERT INTO pwr_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","अना ओना यो साँगके बिनती करन लगयो, की “मोरी नहानी टूरी मरन पर से, तु आयके ओको पर हात राखजो ता वा साजरी भई जाय अना जित्तो रव्हे।” ");
INSERT INTO pwr_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","तबा उ सँग गयो अना मोठी भीड़ ओको मंघा भई गई यहान तकन की लोकगीन ओको पर गिरत पड़त होती। ");
INSERT INTO pwr_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","अना एक बायको जोनको बारा बरस लक लाल धोवा जावत होती। ");
INSERT INTO pwr_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","अना जेना बइद गीन लक लगत दुख उचलीस होतीस, अना आपरो सब काही खरच डाकिस पर काही फायदा नही मिलयो होतो, पर अखीन रोग बढ गयो होतो। ");
INSERT INTO pwr_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","यीसु को चरचा आयक के भीड़ मा लक ओको मंघा आई अना कपरा को पल्लु ला छिवलेइस। ");
INSERT INTO pwr_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","काहेकि उ कव्हत होती “अदी मि ओको कपरा को पल्लु ला च छिव लेहु तो साजरी भई जाहु।” ");
INSERT INTO pwr_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","अना गदने ओको रकत बहनो बंद भई गयो। अना ओना आपरो देह मा जान लेइस, की मि ओना बीमारी लक साजरी भई गई सेव। ");
INSERT INTO pwr_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","यीसु ना गदने आपरो मा जान गयो, की मोरो लक ताकत हिटी से, अना भीड़ ला मुरकके पुसिस, “कोन से जेने मोरो कपरा को पल्लु ला छुवीस?” ");
INSERT INTO pwr_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","ओको चेला ना ओला कहिन “तु चोवसेस की भीड़ तोरो पर गिर पड़ से, अना तु कव्हसेस; की कोन ना मोला छुईसेस?” ");
INSERT INTO pwr_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","तबा ओना ओला चोवन लाई चवतरफा नजर दौड़ाइस। ");
INSERT INTO pwr_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","तबा वा बायको यो जानके की मोरी कसी भलाई भई से डरात अना कापत आयी, अना यीसु को पाय पड़के, ओको लक सबच हाल खरो-खर सांगिस। ");
INSERT INTO pwr_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","ओना ओको लक कहीस; “टूरी तोरो भरोसा लक तु साजरो भईसेस। सान्ती लक जाव अना सारो संकट लक बची रव्ह।” ");
INSERT INTO pwr_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","उ असो कव्हत होतो की सभाघर को मुखिया को घर लक खबर आई की “तोरी टूरी ता मर गई अब काय लाई गुरुजी ला दुख देवासेस।” ");
INSERT INTO pwr_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","जोन गोस्टी वय कर रही होतीन, ओकी अनसुनी करके यीसु ना ओना सभाघर को मुखिया ला कहीस “नोको डराव; बस भरोसा राख।” ");
INSERT INTO pwr_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","अना ओना पतरस अना याकूब अना वोको भाऊ योहन ला छोड़ अना कोनी ला आपरो सँग आवन नही देइस। ");
INSERT INTO pwr_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","अना सभाघर को मुखिया को घर मा पहुचियो ता ओना लोकगीन मा हलचल चोविस। ");
INSERT INTO pwr_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","तबा ओना भीतर जायके भीड़ ला कहीस “तुमी कायला बेचैन सेव, अना रडसो? टूरी मरी नही से पर जपमा से।” ");
INSERT INTO pwr_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","लोकगीन ओकी हसी उडाईन, पर ओना सबला बाहेर हेडके टूरी को माय-बाप अना उनको सँगी ला आन कन भीतर गयो, जिता वा टूरी होती। ");
INSERT INTO pwr_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","अना टूरी को हात धरके ओको लक कहीस, “तलीता कुमी।” जेनको लक मतलब से, “हे टूरी मि तोरो लक कव्हसू, उभो होय।” ");
INSERT INTO pwr_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","अना टूरी गदने जाग के चलन फिरन लगीन। अना वा बारा बरस की होती। यो चोवके लोकगीन ला लगत अचंभा भयो। ");
INSERT INTO pwr_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","मंग ओने उनला कड़ो हुकूम देइस, की यो गोस्टी कोनी ला नोको साँगने। अखीन असो कहीस का “टूरी ला काही जेवन लाई देव।” ");
INSERT INTO pwr_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","उता लक हिटके यीसु आपरो गाँव नासरत मा आयो। अना ओको चेला ओको मंगा भई गईन। ");
INSERT INTO pwr_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","यहुदीगीन को बिसराम दिवस उ पिराथना घर मा सिक्सा देवन लगयो। लगत लोक ओकी आयक के अचंभा भईन अना कव्हन लगीन “यो मानूस ला यो गियान ओला कोन ना देईसेस? एको हात लक कसो-कसो अचंभा को काम होवासेत?” ");
INSERT INTO pwr_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","क उ बढ़ई को टूरा नहाय? जो मरियम लक पैदा भयो से अना जोन याकूब योसेस यहूदा अना सिमोन को भाऊ से। का ओकी बहिन गीन आमरो बीच मा नही सेत? लोकगीन ओको कारन लक ठोकर खाईन। ");
INSERT INTO pwr_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","यीसु ना उनलक कहीस, “भविस्यवक्ता को का आपरो नगर आपरो कुटुंब अना घर को सिवाय कोनी जघा मा कोनी बेज्जती नही होवासे।” ");
INSERT INTO pwr_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","मंग काही बिमार पर हात धरके उनला साजरो करके काही अचंभा को काम नही कर सकयो, काहेका उनना यीसु पर भरोसा नही राखिन। ");
INSERT INTO pwr_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","अना उनको अबिस्वास लक वोला मोठो अचंभा भयो! मंग उ गाँव-गाँव सिक्सा देवत फिरयो। ");
INSERT INTO pwr_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","बारा चेलागीन ला हाकलीस अना उनला दोन-दोन करके धाड़ीस। अना भुत पलित कहाड़न को हक देइस। ");
INSERT INTO pwr_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","अना उन ला साँगीस, की “रस्ता मा जावतो बेरा लाठी ला सोड़ काही नही लेवने। ना भाकर-वाकर, झोला-झंकड़ अना न बसनी मा पैसा-वैसा काही नोको ठेवने। ");
INSERT INTO pwr_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","पर पनही घालने, अना कहीस, दुई दुई कुरता नोको धरने।” ");
INSERT INTO pwr_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","अना “तुम्ही जोन घर मा जावने तो वोना नगर छोड़न तकन उतच रव्हने। ");
INSERT INTO pwr_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","जेने घर मा तुमरो आवभगत नही होहेत, अना तुमरी गोस्टी नही आयकेत तबा आपरो पाय की धुल भी झड़ाय देने का उनको पर गवाही होहेत” ");
INSERT INTO pwr_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","अना उनना जायके परमेस्वर की साजरा बारता को परचार करन लगीन, का पाप लक मन ला हटाव। ");
INSERT INTO pwr_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","अना उ लगत भुत-पलीत ला हेड़त अना बीमारगिन पर तेल लगाय के साजरो करत होतिन। ");
INSERT INTO pwr_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","हेरोदेस राजा ना यीसु को बारे मा चरचा आयकिस का लोक कव्हसेत, “योहन बप्तिस्मा देवनवालो मर गयो, अब जित्तो भयी से, एको लाई वोको लक यो अचंभा को काम होवासेत।” ");
INSERT INTO pwr_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","पर काही लोक सोचत होतीन। “का उ एलिय्याह से अना कोनी जुनो जुग का भविस्यवक्ता मा लक एक समजत होतीन।” ");
INSERT INTO pwr_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","पर हेरोदेस राजा कव्हत होतो की “योहन जोनको मिना डोस्का कपवायो सेव, उ जित्तो भई गई से।” ");
INSERT INTO pwr_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","राजा हेरोदेस ना आपरो सिपाही हुकूम देके योहन ला धरके जँजीर लक बाँधके जेल मा डाक दियो, ओना यो एको लाई करीस, काहेकि हेरोदेस ना हेरोदियास लक बिहा करयो होतो अना वा ओको भाऊ फिलिप्पुस की बायको होती। ");
INSERT INTO pwr_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","काहेका योहन हेरोदेस ला कहीस “मोसे को नियम लक असो साजरो नहाय की तुमी आपरो भाऊ बहु ला राखो।” ");
INSERT INTO pwr_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","एको लाई हेरोदियास योहन की गुस्सा करत होती, अना वा ओला मारन की तक्का मा रहोत होती, पर हेरोदेस को कारन मार नही सकी। ");
INSERT INTO pwr_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","काहे का हेरोदेस योहन ला एक नेक अना पवीतर मानूस मानत होतो, येको लाय उ डरात होतो अना वोकी रक्सा करत होतो। जबा उ ओकी आयकत होतो, तब उ लगत डरात होतो, पर ओको गोस्टी खुसी लक आयकत होतो। ");
INSERT INTO pwr_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","अना ठीक बेरा जबा हेरोदेस ना आपरो जलम दिवस मा मुख सेनापति अना गलील को मुख मानुसिन ला मोठो जेवन मा बुलाइस। ");
INSERT INTO pwr_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","तबा वोकी भाउबहु हेरोदियास की टूरी ना नाचके हेरोदेस अना वोको पाहुना हुनला खुस करीस। तबा राजा ना वा टूरी लक कहीस, का “तु माँग मि तोरी मरजी ला पूरी करुँ। ");
INSERT INTO pwr_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","अना वोना कसम खाइस का आपरो अरधो राज भी तोला दे देहू।” ");
INSERT INTO pwr_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","तबा वा टूरी आपरो माय जवर जायके? पुसिस, अवो मायँ, मी काय माँगु? तबा वोकी माय ना वोला कहीस “योहन बप्तिस्मा देवनवालो को डोस्का।” ");
INSERT INTO pwr_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","वा लवकर राजा जवर जायके कहीस, का “मि चाह्वसू का तु मोरो लाय भानी मा योहन बप्तिस्मा देवनवारा को डोस्का देजोस।” ");
INSERT INTO pwr_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","तबा राजा कुम्हलाय गयो पर अपरो कसम खानो को कारन मना नही करीस। ");
INSERT INTO pwr_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","अता राजा ना एकदम सिपाही ला धाडके वोको मान कापन को हुकूम देइस। उ गयो अना जेल मा वोको मान ला कापियो ");
INSERT INTO pwr_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","अना वोला भानी मा आनके टूरी ला दे दियो, अना टूरी ना आपरो माय ला दे देईस। ");
INSERT INTO pwr_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","यो आयक के ना योहन का चेला ऐना आइन, अना ओको लास ला मरघट्टी मा लीजाए के राखिन। ");
INSERT INTO pwr_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","मंग पेरीतगीन यीसु को कठा एकठ्ठा भईन अना जोन काही उनना करयो होतीन, अना जनता ला सिकायो होतिन वा सब यीसु ला सांगीन। ");
INSERT INTO pwr_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","यीसु ना आपरो चेलागीन ला कहीस, “चलबिन एकलो मा जाबिन, काहेकि यहान लोकगीन आवनो-जावनो करासेत, हमला जेवन को अना सुस्तान ला भी बेरा नाहत।” ");
INSERT INTO pwr_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","एकोलाय वय नाव मा चघके, एक सुनसान जघा मा चली गयीन। ");
INSERT INTO pwr_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","लगत लोक ऐना ना उनला जावत चोय लेईन अना चिन्ह लेईन तबा सब हिट के पाय-पाय धावके उन लक पुढा पहुचीन। ");
INSERT INTO pwr_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","वोना खाल्या उतरके मोठी भीड़ चोयिस अना उन पर तरस आयो। काहेका वय असी मेढा जसो होतीन जिनको कोनी रखवालो नही होतीन। उ उनला सिकावन लगयो, ");
INSERT INTO pwr_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","जबा दिवस बुढतो बेरा भयी होती, वोका चेला आयिन अना वोला कव्हन लगीन, “यो सुनसान जगह से। अना महातनी बेरा भय गयो। ");
INSERT INTO pwr_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","इनला साँग का इता उता गाव अना बस्ति मा जायके जेवन लाय काही आनबीन।” ");
INSERT INTO pwr_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","तबा यीसु ना जवाब देइस “त तुमीच उनला काही खान लाय देव, उनना कहिन, का आठ महिना को बनी को सिक्का की भाकर खरिद आनबिन अना उन लाय देबिन?” ");
INSERT INTO pwr_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","वोना उन लक कहीस “जायके चोवो तुमरो जवर केतरी भाकर सैत?” उनना पता करीन ता “पाँच भाकर अना दुई मसरी सेत।” ");
INSERT INTO pwr_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","यीसु ना चेलागिन ला हुकूम देइस, की सब ला हिवरो गवथ मा पंगत मा बसाय देव। ");
INSERT INTO pwr_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","वय संबर-संबर अना पन्नास-पन्नास करके पंगत मा बस गइन। ");
INSERT INTO pwr_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","वोना उन पाँच भाकर अना दुई मसरी ला लियो अना सरग कन चोयके परमेस्वर ला धन्य वाद करीस। अना भाकर ला तोड़के चेला ला देवत गयो। अना वय लोकगीन मा परसन लगीन अना वसोच दुई मसरी ला भी उन मा परोस देइन। ");
INSERT INTO pwr_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","अना सब पोट भर जेय लेइन ");
INSERT INTO pwr_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","चेलाइन ना भाकर अना मसरी को टुकड़ा को बारा टोपली भरके उचलीन। ");
INSERT INTO pwr_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","वय करिब पाँच हजार मानूसगिन जेवन करीन! ");
INSERT INTO pwr_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","तबा वोना एकदम आपरो चेलाइन ला नाव पर चघन ला मजबुर करीस का चेला गीन वोको लक पुड़ा वोना गन बैतसैदा ला चली जाहेत। तबा मंघा ओना भीड़ ला सार करीस। ");
INSERT INTO pwr_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","अना उनला सार करके यीसु पहाड़ पर पिराथना करन गयो। ");
INSERT INTO pwr_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","जबा दिवस बुडता सँजा बेरा भई ता यीसु एकलोच भुई मा होतो, अना नाव झील को बीच मा होती। ");
INSERT INTO pwr_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","जबा यीसु ना चोयो की वय खेवत-खेवत घबराय गईन, काहे का वारा उल्टी चलत होती ता रात को 3 बजे को करीब मा उ झील पर चलत-चलत उनको जवर आयो, अना पुढा होवनो चाहत होतो। ");
INSERT INTO pwr_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","पर चेलागीन ना यीसु ला झील पर चलतो चोयके वय समजिन का भुत से। अना चिल्लान लगीन। ");
INSERT INTO pwr_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","काहेका सब वोला चोय के घबराय गईन, पर वोना एकदम उन लक कव्हयो “हिम्मत राखो। मि सेउ, नोको डराव!” ");
INSERT INTO pwr_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","तबा उ उनको जवर नाव मा आयो ता वारा थम गई तब वय लगत चकित भय गईन। ");
INSERT INTO pwr_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","उन ला एतरो भीड़ ला जेवन करानवालो चमत्कार समजमा नही आयो। एकोलाय उनको मन कड़ो भय गयो होतो। ");
INSERT INTO pwr_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","वय उतरके गन्नेसरत गाँव मा धाड़िन अना नावघाट मा नाव लगाईन। ");
INSERT INTO pwr_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","जबा वय नाव लक खाल्या उतरीन ता उता का लोकगीन गदने यीसु ला चीन्ह लेइन। ");
INSERT INTO pwr_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","तबा यहुदिया अना इता-उता परान लगीन अना सब लोक बीमार गीनला खाट पर डाकके जितानि-उता खबर मिलयो का उ वहान से उतच लक आनन लगीन ");
INSERT INTO pwr_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","अना जिता-जिता गाँव नगर अना बस्ति मा उ जावत होतो लोक बीमारगीन ला बाजार मा राखके ओको लक बिनती करत होतीन, का उ उनला आपरो कपरा को छोर ला छुवन दे, अना जेतरा वोला छुवत होतीन, वय सप्पा साजरो भय जात होतीन। ");
INSERT INTO pwr_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","तब फरिसी अना मोसे को नियम को गुरू, जोन येरुसलेम नगर लक आयो होतीन ओको आखा-पाखा जुमला भईन। ");
INSERT INTO pwr_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","अना ओको चेला गीनला बिना हात धोये के जेवन जेवत चोइन। ");
INSERT INTO pwr_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","काहे का फरिसी अना सब यहूदी अना मुखिया बिना हात धोवन को नेम कियो जेवत नही होतीन, काहेकि बाप दादो की रिवाज मा चलत होतीन, ");
INSERT INTO pwr_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","अना बाजार लक आयके, पानी लक आपरो आप ला सुध्द करत होतीन तबच जेवत होतीन। असो बेजा सारो रिवाज ला मानके चलत होतीन, जसो कटोरा करसा ताँबा को भाँडो ला धोवनो अना माँजनो। ");
INSERT INTO pwr_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","फरिसी मुखिया अना मोसे को नियम को गुरू गिन ओको लक पुसिन “असो काय बात से? का तोरो चेला गीन बापदादा को रिती रिवाज नही चला सेत अखीन बिना हात धोये जेवासेत?” ");
INSERT INTO pwr_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","यीसु ना उन लक कहीस, “यसायाह भविस्यवक्ता ना तुम्हि कपटीगीन को लाय सहीच लिख्योसे” “वय लोक गीन टोन्ड लक मोरो आदर करासेत, पर इनको दिल मोरो लक लगत दूहुर सेत। ");
INSERT INTO pwr_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","वय फालतू मा मोरो भगती करासेत, अना मानूस को सिक्सा ला धारमिक नियम को रुपमा सबला सिकावासेत।” ");
INSERT INTO pwr_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","“तुमी परमेस्वर को हुकूम ला टालासो अना मानूस को रीती रिवाज ला पालन करोसो।” ");
INSERT INTO pwr_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","यीसु ना उनलक कहीस, “तुम्हि लोक बेजा चलाक सेव, परमेस्वर की हुकूम ला तोड़के खुदच की रिति रिवाज ला मानासेव।” ");
INSERT INTO pwr_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","तुमहि ला मोसे ना सांगयो होतो, “आपरो माय-बाप को आदर करने, अना जोन कोनी माय-बाप ला बुरो कहे, उ मार दियो जाय” ");
INSERT INTO pwr_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","पर तुम्हि सांगासो कोनी मानूस आपरो माय-बाप कहेत का, जोन काही पालन को खरचा से, ओला मि परमेस्वर ला भेट करासेऊ। ");
INSERT INTO pwr_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","ता वोला आपरो माय-बाप को लाय काही नही करन देसो। ");
INSERT INTO pwr_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","यो तरीका लक तुम्हि आपरो रीत लक परमेस्वर को हुकूम ला टाल के ना आपरी रीती रिवाज ला मानासो। ");
INSERT INTO pwr_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","यीसु ना जनता ला आपरो कठा बुलाके उन ला साँगीस, “तुमी सब मोरी गोस्टी ला आयको अना समजो। ");
INSERT INTO pwr_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","असी कोनी बाहरी चीज नहात जोन मानूस को भीतर जायके वोला असुद करे। जोन भीतर लक बाहेर आवासे ता वा च असुद करासे। ");
INSERT INTO pwr_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","जोको कठा कान से, उ मोरी आयको।” ");
INSERT INTO pwr_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","जबा उ जनता को कठा लक घर मा गयो, त चेला गीन वोको लक हाना को बारे मा पुसन लगीन, ");
INSERT INTO pwr_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","यीसु ना कहीस “का तुमी एतरो नासमज सेउ का? तुम्हिला एतरो समज नहात? का जोन चीज बाहेर लक मानूस को भीतर जासे वा मानूस ला असुद नही करासे। ");
INSERT INTO pwr_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","काहे की उ मन मा नही पर सीध्दो पोट मा जावासे, अना हगतबेरा बाहेर हीट जासे,” असो परकार यीसु ना सब जेवन को चीज ला पवीतर ठयरायो। ");
INSERT INTO pwr_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","यीसु ना मंग साँगयो, “जोन मानूस मा लक हिटासे वोच, ओला असुद करासे। ");
INSERT INTO pwr_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","काहेका भीतर मन लक खोटो बिचार, मजे छिनालापन, चोरी, जान लक मारनो, ");
INSERT INTO pwr_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","लोभ, खोटो गोस्टी, छल, लुचपन, खोटो नजर, निन्दा, अहम अना मुरखता हिटसे, ");
INSERT INTO pwr_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","यो सब खोटो गोस्टी मानूस को भीतर लक हिटासे, यो मानूस ला असुध्द करासे।” ");
INSERT INTO pwr_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","मंग यीसु उता लक सुर अना सैदा देस को सीवमेढ मा आयो अना एक घर मा गयो। उ चाहत होतो की कोनीला पता नोको चले, पर उ लुक नहि सकयो। ");
INSERT INTO pwr_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","एक बायको, जोकि लहान टूरी, एक भूत को कब्जा मा होती वा यीसु को बारे मा आयक के आई। अना यीसु को पाय पडन लगी, ");
INSERT INTO pwr_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","वा बायको गैरयहूदी होती। जोन सीरिया देस की रव्हनवारी होती। वोना यीसु लक बिनती करी का मोरी टूरी लक भूत ला हेड़ दे। ");
INSERT INTO pwr_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","यीसु ना वा बायको लक कहीस, “पुढा टुरागीन ला अघान दे, काहे का टूरा को भाकर कुतरा को पुढा डाकनो साजरो नहाय।” ");
INSERT INTO pwr_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","“वोना जवाब देईस।” पिरभु या बात खरो से, “पर कुतरा जुठन-जाठन जेवासेत।” ");
INSERT INTO pwr_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","यीसु ना वोको लक कहीस, “तोरो भरोसा को कारन, भूत तोरी टूरी मा लक हिट गयो।” ");
INSERT INTO pwr_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","जबा वा बायको आपरो घर मा जायके चोयी, टूरी खाट मा सोयी होती, अना भूत हिट गयो होतो। ");
INSERT INTO pwr_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","मंग सुर सैदा को देस लक हिटके, दिकापुलिस मजे दहा नगर लक होतो, गलील को सागर कठा पहुचयो। ");
INSERT INTO pwr_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","अना लोकगीन एक बावरो ला जो हकलात होतो, ओको जवर आनीन अना बिनती करीन की ओको पर हात राख ");
INSERT INTO pwr_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","तबा वा बावरो ला भीड़ कन लक अलग ले गयो, अना आपरो बोट ला ओको कान मा डाकीस अना थुक के ओकी जुबान ला छुईस ");
INSERT INTO pwr_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","अना सरग कना देखके ओना पोट भर सांस लेके कहीस, “इप्फत्तह” मजे “उघड जाय।” ");
INSERT INTO pwr_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","अना ओको कान उघड़ गईन अना जुबान को बंधन भी उघड़ गई मंग उ सप्पा-सप्पा बोलन लगयो। ");
INSERT INTO pwr_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","तबा ओना उनला कहीस, यो गोस्टी को कोनी ला परचार नोको सांगने, पर मना करनो पर वय अखीन ओको बारे मा सांगन लगीन, ");
INSERT INTO pwr_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","अना वय लगत चकित भयके कव्हत होतीन, “वोना जोन काही भी करीसेस, साजरोसे। उ मुक्कोपन ला बोलन अना भैरागीन ला आयकन को ताकत देसे।” ");
INSERT INTO pwr_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","ओनो दिवस मा जबा मोठी भीड़ एकठ्ठी भई अना उनको कठा काही जेवन ला नही होतो। तबा ओना आपरो चेला इन ला जवर बुलायके, उनला साँगीस। ");
INSERT INTO pwr_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","मोला यो भीड़ ला चोवके तरस आवासे, काहेका अज तीन दिवस भयो, मोरो संग सेत, उनको कठा जेवन लाय काही नहात। ");
INSERT INTO pwr_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","अदी मि इनला भुखो घर धाड़ूसु, तबा यो रस्ता मा बेहोस भय जाहेत, उनमा लक लगत लोक बेजा दुहुर लक आई होतीन। ");
INSERT INTO pwr_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","यीसु को चेला गीन वोला जवाब देईन। यो सुनसान जघा मा एतरो जेवन कहान मिलहेत? ");
INSERT INTO pwr_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","यीसु ना उनलक कव्हयो, तुमरो जवर केतरी जेवन सेत? उनना जवाब देईन सात भाकर! ");
INSERT INTO pwr_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","तबा ओना जनता ला जमीन मा बसन लाय कहीस, यीसु ना सात भाकर धरके परमेस्वर ला धन्यवाद देईस। अना भाकर को टुकड़ा करके चेला गीन ला देइस, तबा वय उनला परसन लगीन। ");
INSERT INTO pwr_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","उनको कठा काही लहान-लहान मसरी होतीन, वोला वसोच परमेस्वर ला धन्य वाद देके, उनला परसन ला कहीस। ");
INSERT INTO pwr_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","तबा वय लोक जेयके अघाय गईन, अना चेला गीन बचयो सात टोपली भरके उचलीन। ");
INSERT INTO pwr_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","अना लोक चार हजार को करीब मा होतीन। तबा उनला वोना सार करीस। ");
INSERT INTO pwr_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","अना उ झट आपरो चेला गीन को संग नाव मा चघके दलमनुथा नाव को जघा मा चली गयो। ");
INSERT INTO pwr_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","मोसे को नियम को गुरू आयके यीसु संग बैस करन लगीन, अना ओला परखन लाई ओको कन लक काही सरग लक निसान मांगन लगीन। ");
INSERT INTO pwr_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","ओना आपरी मन लक पोट मा सांस भरके कहीस, यो बेरा को लोकगीन कायलाई निसान ढुंढासे? मि तुमरो लक खरो सांगुसू, यो बेरा को लोकगीन लाय काही निसान नहात। ");
INSERT INTO pwr_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","अना उ उनला वहान सोड़के अना नाव पर चघयो अना वोनागन गयो। ");
INSERT INTO pwr_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","चेलागीन भाकर राखनो भूल गयो होतीन। अना नाव मा उनको कठा एकच भाकर होतो। ");
INSERT INTO pwr_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","ओनो बेरा यीसु ना उनला ध्यान देवाके कव्हसे, चोवो! फरिसी गुरूगीन को खमीर अना हेरोदेस राजा को खमीर लक चाकपाक रव्हने। ");
INSERT INTO pwr_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","एको पर वय आपसी मा बेस करके कव्हन लगीन, आमरो कठा भाकर नहात, एकोलाय यो असो सांगासे। ");
INSERT INTO pwr_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","यीसु ना यो जानके उनलक कहीस, तुमी आपस मा मन मा काहे सोचसो? का आमरो कठा भाकर नहात। का तुमला अबा तकन समज मा नही आयो से, का तुमरो “अक्ल मा गोटा पड़ गयो से?” ");
INSERT INTO pwr_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","तुमरो “डोरा से का चीज को बीज”, अना “कान से का परसा को पान” अना तुमला हेत नहाय? ");
INSERT INTO pwr_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","जब मिना पांच हजार मानूस लाई भाकर तोड़ो होतो तबा तुमना केतरी टोपली भाकर को टुकड़ा उचलो होतो। उन ना कहीन बारा। ");
INSERT INTO pwr_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","जबा चार हजार मानूस लाय सात भाकर ला दियो, तबा तुमी ना केतरो टोपली भरके उचलो होतो, उन ना कहीन सात। ");
INSERT INTO pwr_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","यीसु ना उनला कहीस का तुमी अबा तकन नही समजयोसेव? ");
INSERT INTO pwr_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","वय बैतसैदा गांव मा आइन। तबा लोकगीन एक अँधरा ला ओको जवर आनीन अना ओको लक बिनती करके कव्हन लगीन एला साजरो कर। ");
INSERT INTO pwr_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","अना यीसु ना अँधरा ला हात धरके गाँव को बाहेर ले गयो, अना ओना ओको डोरा मा लगावन साठी थुकीस, अना ओदो हात करके आपरो हात वोको डोरा मा राखके वोला पुसिस का तोला काही चोवसे? ");
INSERT INTO pwr_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","डोरा उचलके ओना कहीस की मि लोकगीन ला झाड़ जसो चलतो चोवसू। ");
INSERT INTO pwr_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","मंग दुबारा ओना अँधरा को डोरा मा हात राखीस तबा ओला साजरो-साजरो चोवन लगयो। ");
INSERT INTO pwr_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","यीसु ना ओला यो साँगके धाडीस, मंग यो गाँव मा दुबारा पाय नोको राखजोस। पर आपरो घर जाय। ");
INSERT INTO pwr_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","यीसु आपरो चेला गीन को सँग, कैसरिया फिलिप्पी को आखा-पाखा को गाँव मा आयो। रास्ता मा ओना चेलागीन लक असो पुछिस का लोक मोरो बारे मा काजक कव्हसेत? ");
INSERT INTO pwr_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","उनना कहिन कोनी योहन बप्तिस्मा देवन वालो कव्हासेत अना कोनी भविस्यवक्ता एलिय्याह अना काही को कव्हनो से का कोनी जुनो भविस्यवक्ता मा लक एक से। ");
INSERT INTO pwr_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","उ उन लक पुसासे? तुम मोला काजक कसो? मि कोन आँवू? पतरस ओला कहीस, तु परमेस्वर को कन लक “सूटकारा देवन वालो मसीह आस।” ");
INSERT INTO pwr_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","तबा उ उनला चेतायके हुकूम देइस, तुमी मोरो बारे मा कोनी लक नोको साँगने। ");
INSERT INTO pwr_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","मंग यीसु उनला सिकावन लग्यो का “मानूस को टूरा” को लाय यो जरुरी सेत का उ लगत दुख उठाएत सयानो, मुखिया याजक, अना मोसे को नियम को गुरू लक नकारो जाय, अना मार डाको जाए। मंग तीन दिवस को मंघा जित्तो भय जाए। ");
INSERT INTO pwr_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","यो गोस्टी ला आयक के मंग पतरस वोला एककन ले जायके डाटन लगिस। ");
INSERT INTO pwr_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","पर वोना पलट के चेला ऐना ला चोविस, अना पतरस ला डाटके कहीस, हे सैतान मोरो पुढा लक दुहूर भय जाय, तु परमेस्वर को नही पर मानूस को गोस्टी पर मन लगावसेस। ");
INSERT INTO pwr_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","वोना गरदी लक चेला गीनला जवर बुलायके सांगिस, अदी कोनी मोरो मंघा आवन चाव्हासे, उ आपरो आप ला तज देय। अना आपरो कूरूस ला उचलके मोरो मंघा आहेत। ");
INSERT INTO pwr_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","काहे का जो आपरो परान ला बचावनो चाव्हासे, उ वोला खोय देहे। अना जो कोनी मोरो अना मोरो साजरो बारता साँगन लाय आपरो परान खो देयेत, उ ओला सुरक्सित पाहेत। ");
INSERT INTO pwr_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","काहे का अदी मानूस सारो जगत ला पायके ना, आपरो जान की हानि उठायेत ता का फायदा? ");
INSERT INTO pwr_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","काहेकि मानूस आपरो जान को बदला मा, का दे सकसे? ");
INSERT INTO pwr_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","जो कोनी यो खोटो अना पापी पीढ़ी बेरा मा मोरो लक अना मोरो गोस्टी लक लजाहे ता मानूस को टूरा भी जबा आपरो पवीतर सरगदूत को सँग आपरो परमेस्वर बाबूजी को महिमा मा आहे, तबा उ भी उनला आपरो कव्हन लाय लजाहे। ");
INSERT INTO pwr_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","अना यीसु जनता लक कव्हासे, मि तुमरो लक खरो कव्हुसू, का जोन यहान उभो सेत उनमा लक कोनी कोनी असो से, का जबा तकन परमेस्वर को राज ताकत लक आयो नही चोव लेहेत, तबा तकन वय नही मरहेत। ");
INSERT INTO pwr_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","एक हफ्ता को मंघा यीसु ना पतरस याकूब अना योहन गिनको सँग एक लगत उच्चो पहाड़ को वरता गयो। अना उता उनको पुढा यीसु को रुप बदल गयो। ");
INSERT INTO pwr_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","ओको कपरा असो चमकन लग्यो जसो कोनी बरेठ धरती मा असो पाँढरो नही कर सकत, एतरो पाँढरो होतो। ");
INSERT INTO pwr_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","अना उनला भविस्यवक्ता मोसे अना एलिय्याह चोयो, वय यीसु को सँग गोस्टी करत होतीन। ");
INSERT INTO pwr_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","तबा पतरस यीसु ला कव्हासे, हे गुरू जी! हमरो यहान रव्हनो साजरो से, एकोलाय आमी तीन मान्डो बनाबिन एक तोरो एक मोसे अना एक एलिय्याह लाय। ");
INSERT INTO pwr_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","काहेका वय बेजा भेवमा होतीन एकोलाय काजक जवाब देवनो से वोला समजमा नही आयो। ");
INSERT INTO pwr_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","तबा एक बादल ना उनला ढाक लेईस। अना वय बादल मा लक यो आवाज आयकू आयी, का यो मोरो चहेतो टूरा आय, एको आयको। ");
INSERT INTO pwr_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","तबा उनना एकाएक आख-पाखा चोइन, अना यीसु को सीवाय आपरो सँग कोनी ला नही पायीन। ");
INSERT INTO pwr_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","पहाड़ लक उतरतो बेरा वोना हुकूम देइस, का जबा तकन मानूस को टूरा मरके जित्तो नही होवासे। तबा तकन जोन काही तुम्ही ना चोयीसेव कोनी लक नोको साँगने। ");
INSERT INTO pwr_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","उनना यो गोस्टी ला हेत करके आपसी मा बातचीत करन लगीन, का मरो मा लक जी उठनो काजक से? ");
INSERT INTO pwr_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","अना चेला गीन कव्हन लगीन, मोसे को नियम को गुरू काय लाय कव्हासेत? पयले एलिय्याह को आवनो पक्को सेत? ");
INSERT INTO pwr_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","वोना जवाब देइस, एलिय्याह सच मा पुढा आयके सब काही सुधारेत? पर मानूस को टूरा को बारे मा कायलाई लिखीसे की उ लगत दुख उचले अना निकम्मो गिनो जाहे। ");
INSERT INTO pwr_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","अना मि तुम लक कव्हसु, का एलिय्याह तो आय गयो से? अना जसो ओको बारे मा लिखयो से उ सबच पूरो भय गयो से। ");
INSERT INTO pwr_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","जब यीसु चेला गीन को कठा आयो, तो चोयीस का उनको आखा-पाखा भीड़ जमा होती; अना मोसे को नियम को गुरू उनको सँग बैस करत होतीन। ");
INSERT INTO pwr_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","अना ओला चोयकेना सब गजब चकित भईन अना ओको कन धावके ओला दन्डवत करीन। ");
INSERT INTO pwr_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","यीसु ना चेलागीन लक पुछिस तुमी इनको सँग कायला बैस करोसो। ");
INSERT INTO pwr_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","भीड़ मा लक एक ने ओला जवाब देइस, हे गुरुजी मि आपरो टूरा ला जेनको पर भूत झोमो से वोला तोरो कठा आनयो होतो। ");
INSERT INTO pwr_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","जितानी-उतानी वा ओला धरके अना पटक देसे, ओला मिरगी आवासे मिना तोरो चेला ला भूत कहाडन लाय कव्हयो, पर वय कोनी काम को नाहत ओला नही कहाड़ सकीन। ");
INSERT INTO pwr_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","यो आयक के ओना जवाब देइस तुम्ही अबिस्वासी काहे बनयो सेव? मि कब लक तुमरो सहुँ? बिमार ला मोरो कठा आनो। ");
INSERT INTO pwr_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","तबा उ बीमार ला ओको कठा आनीन, तब ओना डोरा भरके ओला चोइस, अना वा भूत ओला मरोड़न लगयो, अना जमीन मा पटकन लगयो, अना उ टोन्ड लक फेसकुड़ फेकन लगयो। ");
INSERT INTO pwr_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","तबा यीसु ना ओको बाबूजी ला कहीस, एको हाल कब लक से? ओना साँगीस का नहानपन लक से। ");
INSERT INTO pwr_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","अना वोना ओला नास करन ला कभी स्तो मा, कभी पानीमा पड़ात होतो, पर तु काही कर सकासेस, ता हमरो पर तरस खायके एला साजरो कर। ");
INSERT INTO pwr_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","यीसु ना ओला कहीस, अदी जोन भरोसा राखासेत, वोको लाय सब काही होय सकासे। ");
INSERT INTO pwr_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","टूरा को बाबूजी ना तुरत गिड़गिड़ाय के कहीस, हे पिरभु मी बिस्वास राखुसू तु मोरो अबिस्वास को उपाय कर। ");
INSERT INTO pwr_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","जबा यीसु ना चोविस की लोकगीन धावके भीड़ लगावसे, तो ओना भूत ला हुकूम देइस। हे गुंगो अना बावरो भूत! एको मा लक हिट जाय, अना एको मा दुबारा नोको धसजोस। ");
INSERT INTO pwr_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","तबा भूत बेमियायके ओला लगत मरोड़के वोमा लक हिट गयो। अना उ टूरा मरो जसो भय गयो, एतरो तकन की लोग कव्हन लगीन, उ मर गईसे। ");
INSERT INTO pwr_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","पर यीसु ना ओको हात धरके ओला उचलीस, अना उभो भय गयो। ");
INSERT INTO pwr_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","जबा उ घर मा आयो, तो ओको चेला ना ओको लक एकलो मा पुसिन, आमी ओला काय ला नही कहाड़ सकया। ");
INSERT INTO pwr_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","वोना उनला साँगीस की असो भूत-पलित बिना पिराथना कियो नही हिटासे। ");
INSERT INTO pwr_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","मंग यीसु अना चेलागिन उता लक हिटके अना गलील मा लक जावत होतो, उ नही चाव्हत होतो का कोनी जान पाहे, का वय वहान पर सेत। ");
INSERT INTO pwr_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","काहेका उ केवल आपरो चेला गीन ला सिक्सा देवत अना कव्हत होतो। मानूस को टूरा मानूस गीन को हात धराय देहेत अना वोला मार दियो जाहेत, अना उ मरनको तीन दिवस मघा जित्तो भय जाहेत। ");
INSERT INTO pwr_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","पर या सबद उनको समज मा नही आई। पर वय पुसन लक डरात होतिन। ");
INSERT INTO pwr_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","अना वय कफरनहुम नगर मा आइन, घर मा धसन को मंघा यीसु चेलागीन ला पुसासे की रास्ता मा तुमी कोन गोस्टी लक बैस कर रहया होता। ");
INSERT INTO pwr_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","पर वय ऊगो मुगो भय गईन, काहेका उ रास्ता मा यो बैस करत होतीन, का आमरो मा कोन मोठो से? ");
INSERT INTO pwr_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","तबा यीसु बस गयो अना वय बारा ला हाकलके कव्हसे? अदी कोनी मोठो होवनो चाव्हसे, तो सब लक लहान बन जाय, अना सबको दास बनेह। ");
INSERT INTO pwr_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","अना एक नहानो सो टूरा ला आपरो कन्हिया मा धरके कव्हासे। ");
INSERT INTO pwr_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","जो कोनी मोरो नाव लक असो टूरा मा लक कोनी एकच ला भी अपनावसे उ मोला अपनावासे अना जो कोनी मोला अपनावासे, उ मोला नही मोरो धाड़न वालो परमेस्वर ला अपनावासे। ");
INSERT INTO pwr_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","तबा योहन ना ओको लक साँगीस, हे गुरूजी आमी ना एक मानूस ला तोरो नाव लक भूत-पलीत ला हेडतया देखाया अना ओला अमीना मना करीसेजन, ");
INSERT INTO pwr_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","यीसु ना कहीस का वोला मना नोको करो। काहे का असो कोनी नहात जोन मोरो नाव लक अचंभा को काम करे अना मोला बुरो कहे। ");
INSERT INTO pwr_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","काहेका जोन आमरो विरोध मा नहात, उ आमरो कना से। ");
INSERT INTO pwr_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","जोन कोनी तुमला मसीह होवन को कारन मोरो नाव लक एक गिलास थन्डो पानी देहे, मी तुमला खरो कव्हासू तो वोला आसीस मिलेह। ");
INSERT INTO pwr_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","जोन कोनी ऐना लहान लक जोन मोरो पर भरोसा ठेवासे, अना कोनी पाप को कारन बनकर उनको भरोसा तोड़ देसे, ता भलो होतो की एक मोठो चक्की को पाट वोको गरो मा बांधके वोला समुदर मा डाक दियो जातो। ");
INSERT INTO pwr_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","अदी तोरो हात तोरो पाप को कारन बनासे, ता उ हात ला कापके फेक दे, भलो से की तु टुन्डो भयके जीवन पावजोस पर दुई हात को रहतो नरक मा नही पड़जोस, जहान को स्तो कभ्भू नही बुझेत। ");
INSERT INTO pwr_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","जहान कीड़ा नही मरन को अना स्तो नही बुझन को। ");
INSERT INTO pwr_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","अदी तोरो पाय तोला पाप को कारन बनासे, तुमी वोला काप डाक, चांगलो जिंदगी योच से का तुमी लगड़ा भयके परमेस्वर को राज मा जावो पर दोन पाय को रहतो नरक मा जानो साजरो नहात। ");
INSERT INTO pwr_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","जहान कीड़ा नही मरन को अना ना स्तो बुझन को ");
INSERT INTO pwr_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","अखीन अदी तोरो डोरा तोला पाप को कारन बनासे ता ओला हेड़ दे, भोकना भयके परमेस्वर को राज मा धसनो तोरो लाई साजरो से दुई डोरा धरके नरक मा जानो लक। ");
INSERT INTO pwr_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","जिता उनको कीड़ा नही मरा अना स्तो नही बुझा। ");
INSERT INTO pwr_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","जसो नोन बलिदान ला सुध्द करासे, वसोच हर एक मानूस स्तो लक सूद कियो जाहे। ");
INSERT INTO pwr_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","नोन त साजरो से, पर अदी नोन को स्वाद चलो जाहे, त कोनती सी चीज लक नमकीन करयो जाहे, एकोलाय आपरो मा नोन राखो, अना आपस मा मेल जोल राखो। ");
INSERT INTO pwr_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","यीसु मसीह ना ओना जघा ला सोड़ देइस अना यहुदिया को छेतर लक होयके यरदन नदी को पार आयो। अना भीड़ ओको कठा एकठ्ठा भई अना वय अपरो रिति लक उनला सिक्सा देवन लगयो। ");
INSERT INTO pwr_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","फरिसी दल को लोक यीसु को जवर आइन, अना वोको परिक्सा लेवन को ठानके पुसन लागीन। का मोसे को नियम लक नवरा आपरी बायको ला छोड़ासे? का यो खरो से? ");
INSERT INTO pwr_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","ओना उन लक कहीस गुरुजी मोसे ना तुम ला काजक हुकूम देइसेस? ");
INSERT INTO pwr_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","उनना कहिन गुरुजी मोसे ना ता आपरी बायको ला कागद मा लिखके छोड़छुट्टी देवन को हुकुम दियोसे। ");
INSERT INTO pwr_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","यीसु ना उनला कहीस, तुमरो गोटा जसो मन होवन को कारन ओना तुमरो लाय असो हुकूम लिखीसेस। ");
INSERT INTO pwr_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","सुरुआत मा परमेस्वर ना मरद अना बायको ला बनाईस। ");
INSERT INTO pwr_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","एकोलाय मानूस आपरो माय बाबूजी ला सोड़हेत अना आपरो बायको को संग च रहेत। अना वय दुही एकच तन होहेत। ");
INSERT INTO pwr_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","असो परकार अबा वय दुई नही पर एकच देह सेत। ");
INSERT INTO pwr_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","एकोलाय जोन ला परमेस्वर ना जोड़ीसेस ओला मानूस अलग नोको करेत। ");
INSERT INTO pwr_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","चेला गीनना घर पहुचके यो बारे मा यीसु लक मंग सवाल करीन। ");
INSERT INTO pwr_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","यीसु उनला कहीस, जोन कोनी आपरी बायको ला सोड़ के दुसरी पाठ करेत, ता उ पयली को विरोध मा खोटो काम करासे। ");
INSERT INTO pwr_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","अना अदी बायको आपरो नवरा ला सोड़के दुसरो लक पाठ करेत ता वा खोटो काम करासे। ");
INSERT INTO pwr_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","लोक यीसु को जवर लेकरा गीनला आनीन, का उनला आसीरवाद देये। अना चेलागीन उनला डटकारन लगीन। ");
INSERT INTO pwr_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","यीसु ना यो चोयके गुस्सा लक उनलक कहीस, लेकराइन ला मोरो जवर आवन देव अना उनला मना नोको करो। काहे का परमेस्वर को राज असोच लोकगीन को से। ");
INSERT INTO pwr_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","मी तुम लक खरो कव्हसु, जोन कोनी परमेस्वर को राज लेकरा को समान नही अपनाहेत, वय ओमा कभी धस नही पाहेत। ");
INSERT INTO pwr_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","अना ओना ओला कन्हिया मा राखके ओको पर हात राखीस अना उनला आसीस देइस। ");
INSERT INTO pwr_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","अखीन जबा यीसु जतरा को लाई हिटत होतो। तबा एक मानूस धावत आयो, अना ओको पुढा टोघरा टेकके ओना यो पुसयो, ओ साजरो गुरु! मि अमर जीवन ला पावन लाई का करू? ");
INSERT INTO pwr_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","यीसु ना ओको लक कहीस, तु मोला साजरो काहे कव्हासे? परमेस्वर ला सोड़के कोनी बेस नहात। ");
INSERT INTO pwr_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","तु हुकूम ला जानासेस का कोनी को जियान नोको लेवने, छिनाली नोको करने, चोरी नोको करने, झुठो पुरुप नोको देने, छल नोको करने, आपरो माय बाबूजी को आदर करने। ");
INSERT INTO pwr_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","ओना यीसु ला कहीस, हे गुरुजी एने गोस्टी ला ता मि नहानपन लक मानता आयीसेऊ। ");
INSERT INTO pwr_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","यीसु ना ओला नजर गड़ायके ध्यान लक चोयीस, अना ओको दिल मा माया उमड़ गयो। यीसु ना ओला कहीस, तोरो मा एक गोस्टी की कमी से, जाय अना जो तोरो तिजोरी माल से ओला गरीब गोर इनला देदे, अना आयके मोरो मंघा चल तब तु परमेस्वर को राज मा मजे सरग मा धन पावजोस। ");
INSERT INTO pwr_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","यो आयक के ओको टोन्ड उदास भय गई, अना उ टोन्ड उतारके घर चली गयो, काहेका उ लगत धनी होतो। ");
INSERT INTO pwr_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","यीसु ना आसपास मा चोयके आपरो चेला गीनला कव्हयो धनवान को परमेस्वर को राज मा धसनो गजब कठिन से। ");
INSERT INTO pwr_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","यीसु की गोस्टी ला आयक के चेला चकित भईन, तब यीसु ना उनला जवाब देइस, ओ लेकरागिन जोन धन पर भरोसा राखासेत, उनको परमेस्वर को राज मा धसनो गजब कठिनसे। ");
INSERT INTO pwr_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","ऊट ला सुई को छेद लक पार होय जानो सरल से। पर धनी मानूस को परमेस्वर को राज मा धसनो सरल नहात। ");
INSERT INTO pwr_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","चेलागीन गजब चकित भयके कव्हन लगीन, अता कोन को सूटकारा होय सकासे? ");
INSERT INTO pwr_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","यीसु ना उनला चोयके कहीस, मानूसगिन लक ता असो नही होय सकासे, पर परमेस्वर को लाय सरल से। ");
INSERT INTO pwr_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","पतरस न ओको लक कहीस, देख, आमी त सब काही छोड़- छाड़ के तोरो मंघा आईसेजन। ");
INSERT INTO pwr_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","यीसु खरोपन लक उनला कव्हासे, जोन मोरो अना साजरा बारता को कारन, आपरो घर, भाऊ, बहिन, माय अना बाप अना लेकरा अना खेत ला सोड़ दियो से। ");
INSERT INTO pwr_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","अना योच जीवन मा सौ गुना पाहेत, घर, भाऊगीन, बहिनगीन, मायगीन, लेकरागीन अना खेत, इन सबको संग सताव अना आवन वारा जुग मा हरामेसा को लाय जिन्दगी भेटेत। ");
INSERT INTO pwr_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","पर वय जोन पुढा सेत, वय मंघा होहेत, अना जो मंघा सेत, वय पुढा होयेत। ");
INSERT INTO pwr_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","यीसु अना वोको चेला येरुसलेम नगर जावनवारी रस्ता मा लक जावत होतिन। अना यीसु पुढा-पुढा चलत होतो, तबा उन बारा ला वोना आपरो पर आवनवालो मुसीबत को बारे मा सांगिस यो आयक के चेलागीन चकित होय गईन, अना ओको मंघा आवनवालो लोकगीन डराय गईन। ");
INSERT INTO pwr_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","चोवो, आमी येरुसलेम नगर ला जावासेजन, अना “मानूस को टूरा” मुखिया याजक अना मोसे को नियम को गुरू गीनको हात मा सोप दियो जाहेत, अना वोला जान लक मारन को दन्ड देवन काजी, गैर यहुदीगीन को सुपरत कर दियो जाहे। ");
INSERT INTO pwr_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","वय वोको मजाक उड़ाहेत, थुकेत अना मार डाकेत, अना उ तीन दिवस मा जित्तो होय जाहेत। ");
INSERT INTO pwr_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","तबा जबदी को टूरा याकूब, अना योहन ना यीसु को कठा आयके कहिन, “हे गुरुजी, हमी चाव्हसेजन का तोरो लक जो काही भी माँगबिन, तु हमरो लाय करजोस।” ");
INSERT INTO pwr_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","ओना उन लक कहीस, की “तुम काजक, चाव्हसो? मि तुमरो लाई काजक करु?” ");
INSERT INTO pwr_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","उनना ओको लक कहिन “जबा तु महिमा को सँग सिहासन मा बसजोस तबा, आमी मा लक एक ला उज्जो अना दुसरो ला डाखयो मा बसाजोस।” ");
INSERT INTO pwr_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","यीसु ना उन ला कहीस “तुम्ही नही जानासेव, का काजक माँगसो? जोन दुख को बटकी मि पीवन पर सेउ, वोला तुमी वोला पी सकसो? अना का जसो मी बप्तिस्मा लेवन ला तैय्यार सेव, वसोच तुमी भी बप्तिस्मा लेवन ला तैय्यार सेव?” ");
INSERT INTO pwr_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","उनना ओको लक कहिन की, “हव हमि ले सकासेजन।” एतरो पर यीसु ना कहीस “जोन बटकी मि पीवन पर सेउ, ओला तुमी भी पीहो अना जोन बप्तिस्मा मोला लेनो से वोला तुमी लेहो, ");
INSERT INTO pwr_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","मंग परमेस्वर ना जिनको लाई जघा तैय्यार करीसेस उनला च दियो जाहे। अना कोनी ला आपरो उज्जो अना डाख्यो बसानो मोरो काम नाहत।” ");
INSERT INTO pwr_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","असो आयक के दहा चेलागीन याकूब अना योहन पर गुस्सा होय गईन। ");
INSERT INTO pwr_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","यीसु ना चेला गीन ला जवर हाकलके कहीस, “तुमी जानसो का जोन दुसरो लोकगीन को राजा अना अधिकारी जानो जावासे, उ आपरी जनता पर हक जमावासेत। ");
INSERT INTO pwr_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","पर तुम्ही मा असी बात नाहत पर जो तुम्ही मा पयले होवनो चाव्हासे व पयले तुमरो दास बनेह। ");
INSERT INTO pwr_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","जो तुम्ही मा मुखिया होवनो चाव्हासे व सबका दास बने। ");
INSERT INTO pwr_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","काहे की मानूस को टूरा आपरी सेवा करान लाय नही, पर सेवा करन ला अना सबको लाय पाप को दाम चुकावन अना सूटकारा देवन आयो से। अना लगत लोक गीनला सोड़ान को लाय आपरो परान देदे।” ");
INSERT INTO pwr_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","यीसु अना ओको चेला यरीहो लक होयके जाय रही होतीन, तिमाई को टूरा बरतिमाई एक अँधरा भिखारी होतो, अना सड़क को कगर मा बसयो होतो। ");
INSERT INTO pwr_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","जबा ओना आयकिस, की उ नासरत वालो यीसु से, जोन जावासे, ता हाकल के कव्हन लगयो, “हे यीसु नासरी दाऊद को सन्तान! मोरो पर दया कर!” ");
INSERT INTO pwr_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","लगत लोक ओला डटकारन लगीन की चुप रव्ह, पर उ अखीन जोर-जोर लक हाकलन लगयो, “हे दाऊद को सन्तान मोरो पर दया कर।” ");
INSERT INTO pwr_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","यीसु रुकयो अना कहीस, “ओला बुलाव,” लोकइन ना ओला बुलाइन अना कहीन की “हिम्मत राख, उभो होय! उ तोला हाकलासे” ");
INSERT INTO pwr_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","उ आपरी चद्दर फेकके उछल पड़यो, अना यीसु जवर आयो। ");
INSERT INTO pwr_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","यीसु ना ओको लक पुसिस की “का चाव्हसेस मि तोरो लाई करु?” अँधरा ना जवाब देइस की “गुरुजी मि चोवन चाव्हुसु।” ");
INSERT INTO pwr_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","यीसु ना कव्हयो “जा तोरो भरोसा ना तोला साजरो करीसेस,” अना उ चोवन लग्यो अना यीसु को मँघा भय गयो। ");
INSERT INTO pwr_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","जबा वय येरुसलेम को कगर जैतून पहाड़ पर, बैतफगे अना बैतनिय्याह गाँव को जवर आइन। यीसु आपरो चेला मा लक दुई ला यो कहके धाड़ीस ");
INSERT INTO pwr_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","की “ओना नगर मा जावो, अना जसो ही तुमी धसो तो तुमला पाटरू बच्चा चोयेत। जोन पर कोनी नही बसयो से, ओला खोलके आनने। ");
INSERT INTO pwr_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","अदी तुम ला कोनी पुछेत असो काहे करोसो, त कव्हने की मोरो मालिक ला एको काम से, उ ओला गदने इता धाड़ देहेत।” ");
INSERT INTO pwr_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","उनना जायके उ पाटरू ला बाहेर बेसकुड़ को जवर चौक मा बन्धो पाईन, अना खोलन लगीन। ");
INSERT INTO pwr_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","अना उनमा लक जोन उता उभा होतीन, कोनी कोनी कव्हन लगीन, “की यो का करोसो? गढव को पाटरू ला काय ला खोलोसो?” ");
INSERT INTO pwr_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","उनला जसो यीसु न कहि होतीस, वसोच उनला कव्ह देईन, तबा उनना उनला जावन देईन। ");
INSERT INTO pwr_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","अना उनना उ पाटरू ला यीसु को जवर आनके आपरो कपरा ओमा डाक देईन, अना उ ओमा बस गयो। ");
INSERT INTO pwr_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","लगत लोकगीन ना आपरो कपरा रास्ता मा बिछाइन, अना काही ना खेत मा लक नहानी-नहानी डारी काटके फैलाय देइन। ");
INSERT INTO pwr_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","अना जोन ओको पुडा-पुढा जावत, अना मंघा चलो आवत होतीन, चिल्लाय के कव्हत होतीन, “ओ पिरभू अमीला बचा! धन्य से उ, जोन पिरभु को नाव लक आवासे। ");
INSERT INTO pwr_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","हमरो बाबूजी दाऊद को राज जोन आय रही से; उ धन्य से, वरता बादल मा जय जयकार हो!” ");
INSERT INTO pwr_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","अना उ येरुसलेम पहुचके मंदिर मा आयो। अना चहु तरफा सब चीजहुन ला चौवके, बारा चेलागिन को सँग बैतनिय्याह गाँव गयो। काहेकि झुलाखाली बेरा भई गयो होतो। ");
INSERT INTO pwr_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","दुसरो दिवस जबा यीसु अना चेलागीन बैतनिय्याह लक आय रही होतीन, तबा यीसु मसीह ला भुख लगी। ");
INSERT INTO pwr_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","अना उ दुहुर लक अँजीर को झाड़ चोवके जवर आयो, जोन पत्ता लक ढकयो होतो। पर पत्ता ला छोड़ ओमा काही नही मिलयो, काहेकि फर को बेरा नही होती। ");
INSERT INTO pwr_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","एतरो पर ओना झाड़ लक कहीस “अता सदा लक कोनी तोरो फर नही खाहेत!” अना ओको चेला आयकत होतीन। ");
INSERT INTO pwr_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","मंग यीसु अना ओको चेला येरुसलेम मा आइन, अना उ मंदिर मा गयो। अना उता जो लेन-देन करत होतीन, उनला बाहेर हेड़न लगयो। अना सोना-खुरो बिकन वालो की पीढा, अना परेवा बिकन वालो की पीढा ला उलट देइस। ");
INSERT INTO pwr_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","अना मंदिर मा लक होयके कोनी ला, बरतन धरके आवन-जावन नही देइस। ");
INSERT INTO pwr_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","अना सीकान को लाय उनलक कहीस, “का पवीतर गिरंथ मा नही लिखियो से? की मोरो घर सब देस को लोकगीन को लाय पिराथना करन को घर कहलाहे पर तुमी ना एला डाकूगीन को अड्डा बनाय डाकिसेव।” ");
INSERT INTO pwr_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","यो आयक के मुखिया पुजारी अना मोसे को नियम को गुरू ओला नास करन को तक्का चोवन लगीन। सब लोक ओको सिक्सा लक चकित होतीन एकोलाय वय डरात होतीन। ");
INSERT INTO pwr_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","अना झुलाखाली होवनो पर यीसु अना ओको चेला नगर लक बाहेर चली गईन। ");
INSERT INTO pwr_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","मंग पहट ला जबा वय उता लक जावत होतीन, त चेलागिन उ अँजीर को झाड़ जड़ ला सूक्को चोइन। ");
INSERT INTO pwr_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","तब पतरस ला वा गोस्टी हेत आई, अना ओना यीसु ला कहीस, “ओ गुरू जी चोव! यो अँजीर को झाड़ जेनला तुना सराप दियो होतो, उ सूक गयो से।” ");
INSERT INTO pwr_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","यीसु ना ओला साँगिस का “परमेस्वर भरोसा पर ठेवो।” ");
INSERT INTO pwr_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","मि तुमी लक खरो कव्हसु “की जोन कोनी मन मा संका नही राखेत अना भरोसा राखके यो पहाड़ लक कहे, की तु उखड़ अना यहान समुदर मा पड़ जाय त ओको लाई वसो होय जाहेत।” ");
INSERT INTO pwr_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","एकोलाय मि तुमी लक कव्हसु, की जो काही तुमी पिराथना करके माँगोह त भरोसा कर लेव की तुमला मिल गयो अना तुमरो लाई वसो होय जाहेत। ");
INSERT INTO pwr_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","अना जबा कभी तुमी उभा होयके पिराथना करासो, त तुमरो मन मा कोनी को बारे मा काही विरोध से ता छिमा करहो, एकोलाय की तुमरो सरग को बाबूजी भी तुमरो गलती छिमा करेत। ");
INSERT INTO pwr_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","अना तुमी अदी छिमा नही करहो, त तुमरो बाबूजी परमेस्वर भी जो सरग मा से, तुमरो गलती छिमा नही करेत। ");
INSERT INTO pwr_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","यीसु अना वोको चेला येरुसलेम नगर मा आइन, अना जबा उ मंदिर मा फिरत होतो त मुखिया याजक अना मोसे को नियम को गुरू, अना सयाना ओको जवर आयके पुछन लगीन, ");
INSERT INTO pwr_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","“तु यो काम कोन हक लक करसेस? अना असो हक तोला कोन न देईसेस की असो काम करजोस?” ");
INSERT INTO pwr_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","यीसु ना उन लक कहीस, “अदी तुमी मोला जवाब देहो, ता मि तुमला साँगु की मि यो काम कोन हक लक करासू।” ");
INSERT INTO pwr_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","योहन को बप्तिस्मा देवनो, का सरग को परमेस्वर को कन लक से, का मानूस को कन लक से? अता साँगो। ");
INSERT INTO pwr_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","तबा वय आपसी मा बैस करन लगीन, की अदी आमी कहबिन सरग को कन लक सेत त उ कहेत मंग तुमी ना ओको काय लाई नही भरोसा ठेयत? ");
INSERT INTO pwr_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","अदी आमी असो कव्हबिन का उ मानूस को कन लक सेत? ता लोकगीन को भेव सेत, काहे की सब जानत होतिन, योहन सचमूच मा भविस्यवक्ता होतो। ");
INSERT INTO pwr_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","एकोलाय उनना यीसु ला जवाब देईन, “आमी नही जानासेजन।” यीसु ना उन लक कहीस। “मि भी तुमला नही साँगु, की यो काम कोनतो हक लक करूसू?” ");
INSERT INTO pwr_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","मंग यीसु मुखिया याजकगिन, अना सास्तरी, सियानो गिनलक उदाहरन मा गोस्टी सांगन लगयो, कोनी मानूस ना अंगूर को बारी लगाईस अना ओको चारो कना रुधान रूधिस अना रसा को कुन्ड खन्दिस अना जगेली को लाय मचान वारो ढाबा बनायो अना कास्तकार गिनला ओको ठेका देयके परदेस चली गयो। ");
INSERT INTO pwr_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","मंग फर को बेरा मा ओना कास्तकारगिन को जवर एक दास ला धाडिस, की कास्तकारगिन लक अंगूर को बारी को फर को हिस्सा लेय। ");
INSERT INTO pwr_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","पर उनना दास ला धरके पीटीन अना छुछो हात वापिस कर देईन। ");
INSERT INTO pwr_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","मंग मालीक ना एक अखीन दास ला उनको जवर धाडिस। उनना ओको डोस्का फोड देईन अना ओको बेइज्जती करीन ");
INSERT INTO pwr_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","मंग ओना एक अखीन ला धाडिस, उनना ओला भी मार डाकिन, तबा ओना अखीन लगत सा हिनला भी धाड़िस उनमा लक उनना काही ला पीटीन अना काही ला मार डाकिन। ");
INSERT INTO pwr_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","अता एकच रह गयो होतो, जोन ओको चहेतो टूरा होतो, आखीर मा ओना उनको जवर यो सोचके धाड़िस की वय मोरो टूरा को मान करयेत। ");
INSERT INTO pwr_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","पर उन कास्तकार ना आपस मा कहिन, योच ता वारिस से आव आमी एला मार डाकबिन तबा राज पाठ आमरी होय जाहे ");
INSERT INTO pwr_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","अना उनना ओला धरके मार डाकिन अना अंगूर को बारी को बाहेर फेक देईन। ");
INSERT INTO pwr_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","एको लाई अंगूर को बारी को मालिक का करेत, उ आयके उन कास्तकार ला मारेत अना अंगूर को बारी दुजो ला दे देहे। ");
INSERT INTO pwr_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","का तुमी ना पवितर गीरंथ मा यो नही बाचिसेव? “जेने गोटा ला कारिगर ना नकारो होतीन वोच कोनो को गोटा भय गयो। ");
INSERT INTO pwr_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","असो पिरभु परमेस्वर को कन लक भयो अना हमरो नजर मा चमत्कार से।” ");
INSERT INTO pwr_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","तबा उनना ओला धरन चाहीन काहेकि समझ गईन होतिन की ओना आमरो खिलाफ मा असो उदाहरन कहीसे पर वय लोक लक डरान अना ओला सोड़ के चली गईन। ");
INSERT INTO pwr_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","तबा उनना यीसु ला गोस्टी मा फसावन को लाई काही मोसे को नियम को गुरू अना हेरोदि गीनला ओको जवर धाड़िन ");
INSERT INTO pwr_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","उनना आयके ओको लक कहिन हे गुरु आमी जानसेजन की तु खरो सेस अना कोनी को चिंता नही करस काहे की तु मानूस को टोंड चोवके बात नही करस, पर परमेस्वर को रास्ता खराई लक साँगासेस त का मोसे को नियम लक कैसर को जमा पटावनो साजरो से का नहात? ");
INSERT INTO pwr_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","आमी देबिन या नही देबिन? ओना उनको कपट जानके उनला कहीस “मोला कायलाई परखोसो?” “एक सिक्का मोरो जवर आनो की मि ओला चोय लेउ।” ");
INSERT INTO pwr_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","वय आन के देयीन अना ओना उनलक कहीस, “यो छाप अना नाव कोन को से?” उनना कहीन “कैसर को।” ");
INSERT INTO pwr_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","यीसु ना कहीस “जो कैसर को से, उ कैसर ला अना जो परमेस्वर को से, ओला परमेस्वर ला देव।” तबा वय ओको पर लगत अचंभा करन लगीन। ");
INSERT INTO pwr_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","मंग सदुकी लोक भी कहोसेत की “मरो मा लक जित्तो होवनो नहाय” ओको जवर आयके ओको लक पुसिन, ");
INSERT INTO pwr_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“हे गुरूजी मोसे गुरुजी ना आमरो लाई लिखीसेस, की अदी कोनी को भाउ बिना औलाद कियो मर जाहे, अना ओकी बायका रह जाहे त ओ भाउ की बायका लक बिहा कर सके अना आपरो भाऊ को लाई औलाद पैदा करेत। ");
INSERT INTO pwr_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","सात भाउगीन होतीन, जिनलक पयलो भाऊ बिहा करके बिना ओलाद कियो मर गयो। ");
INSERT INTO pwr_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","तबा दुजो भाउ ना वा बायका लक बिहा कर लेइस, अना बिना ओलाद को मर गयो। अना वसोच तीसरो ना करीस ");
INSERT INTO pwr_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","अना सातोगीन लक औलाद नही भई, सब को मंघा वा बायका भी मर गई। ");
INSERT INTO pwr_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","एको लाई जित्तो होवनो को मंघा वा उनमा लक केकी बायको होहे? काहे की वा त सातई की बायको भई गई होती।” ");
INSERT INTO pwr_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","यीसु ना उन लक कहीस, “का तुमला भुल नही भई से, अना का तुमी ना कभी पवितर गीरंथ नही वाचीसेव अना का परमेस्वर की ताकत ला नही जानासो?” ");
INSERT INTO pwr_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","काहेकि जबा मरया हुया लक वय जी उठेत, त वय न त बिहा करयेत, अना न त बिहा मा दिया जाहेत, पर सरग मा दूत को जसो रहेत। ");
INSERT INTO pwr_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","मरयो हुयो को जीवनो को बारे मा, का तुमी ना मोसे को किताब मा, “झाड़ी की कथा” ला नही वाचयत, की परमेस्वर ना कहीस “की मि अबराहम अना इसहाक अना याकूब को परमेस्वर सेव?” ");
INSERT INTO pwr_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","परमेस्वर मरो हुयो का नही, वरन जित्तो को परमेस्वर से, “एकोलाय तुमी मोठो भूल मा पड़या सेव।” ");
INSERT INTO pwr_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","मोसे को नियम को गुरू गीन मा लक एक ना आयके, उनला बैस करता आयकीस, अना यो जानके की ओना उनला साजरो रिति लक जवाब देईसेस ओकोलक पुसिस, “सब लक मोठी हुकूम कोनतो से?” ");
INSERT INTO pwr_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","यीसु ना ओला जवाब देइस “सब हुकूम लक मोठो हुकूम यो से, की हे इसरायल सुन! पिरभु आमरो परमेस्वर एकच पिरभु से, ");
INSERT INTO pwr_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","अना तु पिरभु आपरो परमेस्वर लक आपरो सारो मन, सारो परान अना सारो बुध्दि अना सारो सक्ति लक माया राखजोस ");
INSERT INTO pwr_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","अना दुसरी या से की तु आपरो पड़ोसी लक आपरो जसो माया राखजोस। एकोलक मोठी अना कोनी हुकूम नही।” ");
INSERT INTO pwr_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","मोसे को नियम को गुरू ना ओको लक कहीस “हे गुरूजी बिलकुल ठीक! तु ना खरो कहिसेस, की उ एकच से अना ओला सोड़ अना कोनी नहात। ");
INSERT INTO pwr_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","अना वोको लक सारो मन, सारो अक्ल, अना सारो परान अना सारो ताकत लक माया राख, अना पड़ोसी लक आपरो जसो माया राख योच दुही हुकूम सप्पा होमन को बलिदान अना बलिदान लक बढके से।” ");
INSERT INTO pwr_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","जबा यीसु ना चोयीस की ओना “समजदारी” लक जवाब देईसेस, त ओकोलक कहीस, तु परमेस्वर को राज लक दुहूर नहात, अना कोनी ला मंग ओको लक काही पुसन को हिम्मत नही भई। ");
INSERT INTO pwr_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","मंग यीसु ना मंदिर मा सिक्सा देवत हुयो यो कहीस, “मोसे को नियम को गुरू कसो कव्हासेत की मसीह दाऊद को टूरा आय?” ");
INSERT INTO pwr_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","दाऊद ना खुदच पवीतर आतमा मा होयके कहिसेस, पिरभु ना मोरो पिरभु ला कव्हासे, मोरो उज्जो बस जबा तकन मि तोरो जरन वालो बैरी ला तोरो पाय को पीढो नोको कर देहुँ। ");
INSERT INTO pwr_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","दाऊद त आपच ओला पिरभु कव्हसे मंग उ ओको टूरा कहान लक ठहरो? अना भीड़ को लोक ओको खुसी लक आयकत होतीन। ");
INSERT INTO pwr_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","ओना आपरो सिक्सा मा उनलक कहीस, “मोसे को नियम को गुरू गीन लक चाकपाक रव्हने, जोन लम्बो चोगा पहिनके फिरसेत अना बाजार-हाट मा नमस्कार ");
INSERT INTO pwr_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","सभाघर मा मोठो-मोठो कुरसी अना जेयन को भोज मा मुख मुख जघा चाव्हसेत। ");
INSERT INTO pwr_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","वय बेवा गीनको घर हड़प जासेत अना दिसावन लाई लगत देर तकन पिराथना करसेत। यो लगत दन्ड पाहेत।” ");
INSERT INTO pwr_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","उ मँदिर को दान पेटी को पुड़ा बसके देख रहयो होतो की लोक मँदिर को खजाना मा कोनी रीत लक पैसा डाकसेत अना लगत धनवान ना लगत मा लक काही डाकिन। ");
INSERT INTO pwr_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","एतरो मा एक कँगाल बेवा ना आयके दुई दमड़ी जोन एक अधेला को बराबर होवासे डाकिस। ");
INSERT INTO pwr_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","तबा ओना आपरो चेला ला जवर बुलायके उनलक कहीस, “मि तुमी लक खरो कव्हसु की मँदिर को दान पेटी मा डाकन वालो मा लक यो कंगाल बेवा ना सब लक बढके डाकीस ");
INSERT INTO pwr_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","काहे की सब ना आपरो धन को बढ़ती मा लक डाकिन, पर यो तो आपरो सप्पा कमाई को धन दान कर देइसेस जोन काही वोको जवर होतो। एने आपरो घटी मा लक जो काही ओको जवर होतो।” ");
INSERT INTO pwr_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","जबा यीसु मंदिर लक हिट रहयो होतो, त ओको चेला मा लक, एक ना ओला कहीस, हे गुरुजी चोव, कसो मोठो गोटा अना कसो सुंदर मकान सेत! ");
INSERT INTO pwr_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","यीसु ना ओला कहीस, का तुमी यो मोठा- मोठा घर चोवसो, यो गोटा पर गोटा नही बचेत जो नोको पड़ेत। ");
INSERT INTO pwr_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","जबा उ जैतून को पहाड़ पर मंदिर को पुढा बसयो होतो, त पतरस, याकूब अना योहन अना अन्दिरयास ना एक कन जायके ओला पुसिन, ");
INSERT INTO pwr_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“आमी ला साँग की यो गोस्टी कब होहेत? अना जबा यो सब गोस्टी पूरी होवन पर होयेत ओनो बेरा को काजक निसान होहेत?” ");
INSERT INTO pwr_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","यीसु उनलक कव्हन लगयो, “होसियार रव्हने” का कोनी तुमला नोको बहेकाय। ");
INSERT INTO pwr_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","काहेका लगत सा मोरो नाव लक आयके कहेत, “मि मसिहा आऊ!” अना लगत लोक ला बहेकायेत। ");
INSERT INTO pwr_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","जबा तुम लड़ाई-वड़ाई की चरचा आयको, त नोको घबराने, काहेकी इनको होवनो जरुरी से, पर ओनो बेरा अन्त नही होहेत। ");
INSERT INTO pwr_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","काहेकि जाति पर जाति, अना देस- देस पर चढाई करयेत। जघा-जघा भुईडोल होहेत, अना गिरानी पड़हेत, यो तो जचकि को पयलो दुख को जसो से। ");
INSERT INTO pwr_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","पर तुमी आपरो बारे मा होसियार रव्हो, काहेकी लोकगीन तुमला मोठी सभामा सौपेत अना तुमला सभाघर पंचायत मा पिटेत। अना मोरो कारन हाकिम अना राजा गीनको पुढा उभा कियो जाहो, असो परकार लक उन पर गवाही होयेत। ");
INSERT INTO pwr_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","पर जरुरी से की पुढा साजरो बारता सब देस गीनमा आयकवायो जाहेत। ");
INSERT INTO pwr_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","जबा वय तुमला ले जायके कचहरी मा सोपेत, ता पयले लक चिन्ता नोको करने की आमी काजक कव्हबिन पर जोन काही तुमला ओना बेरा सांगोसे वोच कव्हने। काहेकि बोलन वारा तुमी नही सेव, पर पवीतर आतमा से। ");
INSERT INTO pwr_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","भाऊ ला भाऊ अना बाप ला टूरा मार डाकन ला सोपेत, अना लेकरागीन माय- बाप को खिलाप मा जायके उनला मरवाय डाकेत। ");
INSERT INTO pwr_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","अना मोरो नाव को कारन सबच लोकगीन तुमी लक बैर करयेत, पर जोन अन्त तकन धीरज धरयो रहेत, वोकोच सूटकारा होयेत। ");
INSERT INTO pwr_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","एकोलाय जबा तुमी ओनो “उजाड़नवारी बेकार चीज” ला जोन साजरो नहात, उता उभी चोवो, जहान वोको होवनो साजरो नहात। एला बाचनवालो समझ लेहे, तबा जो यहुदिया नगर मा होहे, वय पहाड़ मा पराय जाय, ");
INSERT INTO pwr_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","जोन छत मा होयेत, उ आपरो घर लक काही लेवन ला खाल्या नोको उतरे अना भीतर जाये, ");
INSERT INTO pwr_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","अना जोन खेत मा होहेत, उ आपरो कपरा लेवन को लाई मंघा नोको मुरके। ");
INSERT INTO pwr_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","ओनो दिवस मा जोन पोट लक अना दुध पिलावन वारी होहेत, उनको लाई हाय से। ");
INSERT INTO pwr_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","अना पिराथना करो की असो थन्डी मा नोको होय। ");
INSERT INTO pwr_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","काहेका वय दिवस असो आफद होयेत, जसो परमेस्वर ना दुनिया बनायो से तब लक अबा तकन नही भयो से। ना ता कभ्भू होयेत। ");
INSERT INTO pwr_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","अदी पिरभु उन दिवस ला कम नही करतो त कोनी नही बचतो पर ओनो बेचयो हुयो को मानूस को कारन जिनला ओना बेचीसेस, ओनो दिवस ला घटाइसेस। ");
INSERT INTO pwr_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","ओनो बेरा अदी कोनी तुमिलक कहे, चोवो, मसीह इता से या उता से, त भरोसा नोको करने ");
INSERT INTO pwr_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","काहे की खोटो मसीहा अना खोटो भविस्यवक्ता उभो होयेत, अना निसान आना अचँभा काम चोवाहेत की अदी होय सके ता बेचयो हुया ला भी भरमाहेत। ");
INSERT INTO pwr_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","पर तुमी सतरक रव्हने, मिना तुमला सबच गोस्टी पयले लक साँग देईसेउ। ");
INSERT INTO pwr_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“ओनो दिवस मा दुख को मंघा दिन अँधारो भई जाहेत” अना चँदा को उजाड़ो नही होहेत। ");
INSERT INTO pwr_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","अना बादल लक तारागीन पड़ेत, अना बादल को सक्ति हिलायो जाहे। ");
INSERT INTO pwr_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","तबा लोक मानूस को टूरा ला मोठी ताकत अना महिमा को सँगा बादल मा आवता चोव्हेत। ");
INSERT INTO pwr_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","ओनो बेरा उ आपरो सरग दूत गीनला धाड़के, धरती को एकछोर लक धरती को दुसरो छोर तकन, चहु दिसा लक आपरो निवाड़ो लोकगीन ला जमा करयेत। ");
INSERT INTO pwr_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","अँजीर को झाड़ लक यो हाना लक यो सिक्सा सीको, जबा ओकी डार मुलाम होय जासेत, अना पत्ता हिटासेत, ता तुमी जान लेसो की गरमी जवर आय गई से। ");
INSERT INTO pwr_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","येने रिती लक जबा तुमी यो गोस्टी ला होता चोव्हो, ता जान लेव की बेरा जवर च नहाय, पर बेसकुड़ मा से। ");
INSERT INTO pwr_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","मि तुमी लक खरो कव्हसू, की जबा तकन यो सबच गोस्टी पूरी नोको होय जाय, तबा तकन यो पीढी को लोकगीन बनयो रहेति। ");
INSERT INTO pwr_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","बादल अना धरती टल जायेत, पर मोरी गोस्टी कभ्भूच नही टलेत। ");
INSERT INTO pwr_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“वा बेरा कब आहे कोनीला पता नहात? न सरग को दूत अना ना टूरा पर सीरप परमेस्वर बाबूजी।” ");
INSERT INTO pwr_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","देखो, जागत रव्हो अना तैय्यार रव्हने, काहेकि तुमीला पता नहात का वा बेरा कब आहे? ");
INSERT INTO pwr_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","यो उ मानूस को दसा जसो से, जोन परदेस ला जातो बेरा आपरो घर ला सोड़के जासे, आपरो दास ला हक देसे, अना हर कोनीला ओको काम देवासे अना चौकीदार ला जागन को हुकूम देवासेत। ");
INSERT INTO pwr_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","एकोलाय जागत रव्हो, काहेकी तुमीला पता नहात की घर को मालिक कबा आहे? सन्जा ला या अरधी रात या कुकड़ा को चिल्लान को बेरा, या पहट ला या दिवस हिटन को बेरा। ");
INSERT INTO pwr_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","असो नोको होय की उ आहे अना तुमला झोपत पाहे। ");
INSERT INTO pwr_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","एको लाई मि जो तुमला कव्हसु, तुम सब लक कव्हसु, जागत रव्हो! ");
INSERT INTO pwr_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","दुई दिवस को मंघा पास्का अना बलिदान को तिहार होवन वालो होतो। मुखिया याजक अना मोसे को नियम को गुरू यो बात को तक्का मा होतिन की ओला कसो छल लक धरके मार डाकबिन। ");
INSERT INTO pwr_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","पर कव्हत होतीन की “तिहार को दिवस मा नही, एकोलाय की कही असो न होय की लोकगीन मा बगावत होय जाय।” ");
INSERT INTO pwr_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","यीसु जबा बैतनिय्याह समौन कोढ़ी को घर जेवन करन लाई बसयो होतो, तबा एक बायको सील बँद सीसी मा सुध्द जटामाँसी को बेसकीमती इतर आनी, अना सील तोड़के तेल ला ओको डोस्का मा रिचाय देइस ");
INSERT INTO pwr_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","पर कोनी आपरो मन मा गुस्सा होयके कव्हन लगीन, यो इतर ला बेकार काहे कर दियो? ");
INSERT INTO pwr_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","काहे की यो इतर ला तीन सौ खुरोको सिक्का मा जोन एक साल की मजदुरी से बिकके कँगालगीन मा बाट दियो जातो, अना वय ओला गुस्सा करके बोलन लगीन। ");
INSERT INTO pwr_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","यीसु ना कहीस, “ओला छोड़ देव ओला काहे सतावासो? ओना ता मोरो सँग भलाई करीसेस। ");
INSERT INTO pwr_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","कंगाल तुमरो सँग सदा रहेत, अना तुमी जबा चाव्हने तबा उनलक भलाई कर सकासो। पर मि तुमरो सँग सदा नही रहुँ। ");
INSERT INTO pwr_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","जोन काही ओना कर सकीस, ओना करीस, ओना मोरो गाड़न को तैय्यारी मा पुढ़ा लक मोरो देह मा तेल रिचाइस। ");
INSERT INTO pwr_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","मि तुमी लक खरो सांगासु, की सारो संसार मा जिता- जिता साजरो बारता की जाहे, उता ओको हेतमा यो काम की चरचा भी कियो जाहे।” ");
INSERT INTO pwr_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","तबा यूदूस इस्करियोति जो बारा मा लक एक होतो, मुखिया याजक गीनको जवर गयो की यीसु ला उनको हात धराय दे। ");
INSERT INTO pwr_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","वय यो आयक के खुस भईन अना ओला रुपये देवन को परन करीन, अना उ मौका तलासन लगयो की ओला कोनी तरीका लक धरवाहु। ");
INSERT INTO pwr_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","पाठी को बलिदान तिहार को पयलो दिवस जोन मा वय फसह को बलिदान करत होतीन, ओको चेला ना ओला पुसिन, “तु किता चाव्हसेस की आमी जायके तोरो लाई फसह को पाठी को बलिदान को तैय्यारी करबिन?” ");
INSERT INTO pwr_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","ओना दुई चेला ला यो कहके धाड़िस, “नगर मा जाव अना एक मानूस घघरा मा पानी लेयके जावतो चोयेत ओको मंघा होय जाने।” ");
INSERT INTO pwr_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","अना उ जेना घर मा जाहे, ओनो घर को मालिक लक कहने, गुरूजी कव्हसे की “कनघर” जिता मि आपरो चेला गीन को सँग फसह को जेवन जेवहु। उ किता से? ");
INSERT INTO pwr_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","उ तुमला एक सजी अना तैय्यार मोठी अटारी मा खोली दिसाएत, उता हमरो लाई तैय्यारी करने। ");
INSERT INTO pwr_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","चेला गीन हिटके सहर मा पहुचीन अना जसो उनलक ओना कव्हयो होतो, वसोच पायीन अना फसह को जेवन तैय्यार करीन। ");
INSERT INTO pwr_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","जबा झुलाखाली भय गई त उ बारा चेला गीनको सँगा आयो। ");
INSERT INTO pwr_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","जबा वय बसके जेवन कर रही होतीन त यीसु ना कहीस, मि तुमिलक खरो कव्हुसू की “तुमी मा लक एक, जो मोरो सँगा जेवन कर रही से, उ मोला धराहे।” ");
INSERT INTO pwr_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","चेला गीन उदास भई गईन अना वय एक-एक करके ओला पुसन लगीन, “का उ मि सेव?” ");
INSERT INTO pwr_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","यीसु उनलक कहीस, “उ बारा मा लक एक से, जो मोरो संग ठाव मा हात डाकीसेस। ");
INSERT INTO pwr_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","काहेका मानूस को टूरा ता जसो वोको बारे मा लिखयो से, की उ मारो जाहेत पर हाय ओना मानूस पर जेनको लक उ बैरी को हात धरायो जाहे। अदी उ मानूस को जनमच नही होतो, ता ओको लाई साजरो होतो।” ");
INSERT INTO pwr_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","जबा वय जेय रही होतीन तो, यीसु ना भाकर लेइस अना परमेस्वर ला धन्य वाद देके ना तोड़िस, अना चेला गीनला देइस अना कहीस, “लेव यो मोरो तन आय।” ");
INSERT INTO pwr_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","मंग ओना कटोरा लेके परमेस्वर ला धन्य वाद देइस, अना चेलागीन ला देइस अना उन सब ना ओमा लक पीइन। ");
INSERT INTO pwr_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","अना यीसु उनलक कहीस, “यो मोरो खून से, जोन लगतगीन को लाई बहायो गयो से, जोन परमेस्वर की करार से। ");
INSERT INTO pwr_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","मि तुमी लक खरो कव्हसू की अंगूर को रस ओनो दिवस तकन मंग कभी न पीहुँ, जबा तकन परमेस्वर को राज मा नयो अंगूर को रस नही पीहुँ।” ");
INSERT INTO pwr_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","मंग वय भजन गायके, बाहेर जैतून को पहाड़ पर गईन। ");
INSERT INTO pwr_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","तबा यीसु ना उनलक कहीस, “तुमी सब मोला छोड़के पराय जाहो, काहेकि लिखीसे, मि रखवालो ला मारु, अना मेढ़ा तितर-बितर भय जाहेत।” ");
INSERT INTO pwr_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","पर मि आपरो जित्तो उठन को मंघा तुमी लक पयले गलील छेतर ला जाहुँ। ");
INSERT INTO pwr_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","तर पतरस ना ओला कहीस, “अदी सब सोड़ जाहेत पर मि नही सोड़ू।” ");
INSERT INTO pwr_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","यीसु ना पतरस लक कहीस, “मि तुमिलक खरो कव्हसू, की आज येने रात ला कुकड़ा को दुई बार चिल्लावन लक पयले, तु तीन बार मोरो नाव ला मना करजोस।” ");
INSERT INTO pwr_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","पर पतरस अखीन जोर देयके कव्हासे, “अदी मोला तोरो सँग मरनो भी पड़ेत, ता भी मि तोला मना नही करुह।” येने रिति लक सबच चेला ना कहिन। ");
INSERT INTO pwr_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","मंग यीसु अना ओको चेला गतसमनी नाव को एक जघा मा आइन अना ओना आपरो चेला ला कहीस, “यहान बसा रव्हो, जबा तकन मि पिराथना करके आवुसू।” ");
INSERT INTO pwr_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","अना उ पतरस अना याकूब अना योहन ला आपरो सँगा ले गयो, अना लगत बैचेन अना परेसान होवन लगयो, ");
INSERT INTO pwr_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","अना ओना उनलक कहीस, “मोरो मन लगत उदास से, यहान तकन की मि मरन पर सेउ, तुमी यहान रुको अना जागत रव्हो।” ");
INSERT INTO pwr_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","मंग उ पुढा बढ़यो अना जमीन पर गिरके पिराथना करन लगयो की अदी होय सके ता या घड़ी मोरो पर लक हट जाय, ");
INSERT INTO pwr_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","अना कहीस, “ओ परमेस्वर बाबूजी, तोरो लक सब काही होय सकासे, येने दुख को कटोरा ला मोरो जवर लक हटाय ले, ता भी जसो मि चाव्हसु वसो नोको पर जोन तु चाव्हासेस, वाच होय।” ");
INSERT INTO pwr_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","मंग उ वापिस आयो अना उनला झोपत पायके पतरस ला कहीस, “हे समौन, तु झोपासेस? का तु जरासी देर भी नही जाग सकयोस तू कोनी काम को नाहत? ");
INSERT INTO pwr_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","जागतो अना पिराथना करता रव्हो, की तुमी परिक्सा मा नोको पड़हो, काहेका आतमा ता तैय्यार से पर आँग कमजोर से।” ");
INSERT INTO pwr_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","अना उ चलो गयो अखीन ओनो सबद लक पिराथना करीस। ");
INSERT INTO pwr_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","मंग आयो ता उनला झोपत पायीस, काहे की उनला जपरी लगी गई होती अना नही जानत होतीन की ओला का जवाब देबिन। ");
INSERT INTO pwr_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","मंग तिसरो बार उन ला झोपत चोयीस ता कहीस, “का तुमी अबा तकन जप मा सेव? अना आराम कर रही सेव! अता घड़ी आय पहुचयो, चोवो! मानूस को टूरा बैरीगीन पापी को हात धरायो जाहे। ");
INSERT INTO pwr_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","उठो अना चलो! चोवो मोरो धरानवालो जवर आय गई से।” ");
INSERT INTO pwr_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","उ यो कव्हत च होतो की यूदूस जोन बारा मा लक एक होतो, आपरो सँग मुखिया याजक अना मोसे को नियम को गुरू अना सयानो को कन लक एक मोठी भीड़ लेके गदने पहुचियो जोन्हासीन तलवार अना लाठी धरी होतीन। ");
INSERT INTO pwr_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","यूदस ना उनला यो साँगी होतीस की जेनला मि चुम लेहु वाच से, ओला धर लेने। ");
INSERT INTO pwr_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","उ आयो, अना गदने ओको जवर जायके कहीस, “हे गुरू!” अना ओला चुमीस। ");
INSERT INTO pwr_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","तबा उनना ओला धर लेईन। अना ओला बाँध देईन ");
INSERT INTO pwr_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","उनको चेला मा लक एक ना तलवार खीचिस अना मुखिया याजक को दास को कान ला काट देइस। ");
INSERT INTO pwr_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","यीसु ना उनलक कहीस “का तुमी मोला डाकु समझके तलवार अना लाठि लयके मोला धरन ला हिटि सेव? ");
INSERT INTO pwr_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","मि ता हरपल तुमरो सँग रहयो, अना मंदिर मा सिक्सा देवत रहयो, अना तुमीना मोला नही धर सकयत, पर यो ऐकोलाई भयो की पवितर गीरंथ की गोस्टी पूरी होय।” ");
INSERT INTO pwr_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","असो होवन पर ओको चेला ओला सोड़के पराय गईन। ");
INSERT INTO pwr_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","एक जवान आपरो मलमल को चददर घालयो ओको मंघा चल रहयो होतो, अखीन लोकगीन ओला पकड़नो चाहीन। ");
INSERT INTO pwr_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","पर उ मलमल चददर ला छोड़के पराय गयो। ");
INSERT INTO pwr_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","यीसु मुखिया याजक को जवर ले जायो गयो, अना सब मोठा याजक, अना सयाना, अना मोसे को नियम को गुरू, ओको जवर एकठ्ठो भईन। ");
INSERT INTO pwr_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","पतरस दुहुर लक चोवके मंघा-मंघा मुखिया याजक को आँगन तकन गयो, अना सिपाही गीनको सँग बसके स्तो तापन लगयो। ");
INSERT INTO pwr_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","मुखिया याजक अना यहुदीगीन की मोठी सभा यीसु मारन डाकन लाई ओको विरोध मा पुरुप की खोज मा होतीन पर काही गवाही नही मिलयो। ");
INSERT INTO pwr_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","काहेकि वय ओको बारे मा झुठी गवाही देवत होतीन अना उनको गवाही एक दुसरो लक नही मिलत होती। ");
INSERT INTO pwr_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","तबा काही लोक जाग के ओको विरोध मा झुठी गवाही देवन लगीन, उनना कहिन, ");
INSERT INTO pwr_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“आमी ना यो सांगतो आयकीसेजन, ‘मि यो हात को बनायो मंदिर ला नास कर देहू, अना तीन दिवस मा दुजो बनाहु। जोन हात लक नही बनो रहेत।’” ");
INSERT INTO pwr_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","एतरो मा भी उनको गवाही एक जसो नही होतो। ");
INSERT INTO pwr_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","तबा मुखिया याजक ना बीच मा उभो होयके यीसु लक पुसिन, “तु काहे जवाब नही देवासेस? यो लोक तोरो खिलाप मा का गवाही देसेत?” ");
INSERT INTO pwr_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","पर उ चुप रहयो, अना काही जवाब नही देइस। मुखिया याजक ना मंग ओला पुसयो, “का तु सब लक मोठो परमेस्वर परम धन्य को टूरा मसीह आस?” ");
INSERT INTO pwr_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","यीसु ना कहीस, “मि सेउ, अखीन तुमी मानूस को टूरा ला सब लक ताकत वर परमेस्वर को उज्जो कन बसा, अना बादल को बदली मा आवता चोवो।” ");
INSERT INTO pwr_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","तबा मुखिया याजक ना आपरो कपरा फाड़के कहिन “अता आमीला पुरुप को का जरुरत से? ");
INSERT INTO pwr_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","तुमीना यो निन्दा आयकासेव, तुमरी का राय से?” वय सब कव्हन लगीन यो परान दन्ड को लायक से। ");
INSERT INTO pwr_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","तबा सिपाही गीन ओको पर थुकन अना टोन्ड ढाकन अना ओला थप्पड़ मारन लगीन अना कव्हन लगीन, “अता जान के साँग, की कोन ना तोला मारिसेस?” ");
INSERT INTO pwr_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","जबा पतरस आँगन मा उभो होतो, तो मुखिया याजक की एक दासी वहान आयी। ");
INSERT INTO pwr_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","अना पतरस स्तो ताप रहयो होतो, ता ओना ओला ध्यान लक चोवीस, तबा कव्हासे, “तु भी यीसु नासरी को सँग होतो।” ");
INSERT INTO pwr_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","उ मुकर गयो अना कहीस “मि नही जानु अना नही समझु की तु का कव्हसेस?” मंग उ बाहेर दरवाजा मा गयो अखीन कुकड़ा ना चिल्लाय देइस। ");
INSERT INTO pwr_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","वा दासी ओला चोवके उनलक जो कठा उभा होतीन, मंग कव्हन लगीन “यो उनमा लक एक से।” ");
INSERT INTO pwr_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","पर उ मंग मुकर गयो। जरा देर मंघा उनना जो जवर उभा होतीन मंग पतरस लक कहीस, “सही मा तु उनमा लक एक सेस; काहेकि तु भी गलीली सेस।” ");
INSERT INTO pwr_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","तबा पतरस ना कहीस, “मि कसम खावसु की अदी मि झुठो कव्हासू ता परमेस्वर मोला सजा दे।” ");
INSERT INTO pwr_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","तबा कुकडा ना दुबारा चिल्लाय देइस। पतरस ला उ गोस्टी जो यीसु ना ओला कहि होतीस हेत आई “कुकड़ा को दुई बार चिल्लान को पुढा तु तीन बार मोरो इन्कार करजोस।” अना पतरस आखरी मा सोचिस, की मिना पिरभु को नाव ला मना करीसेव, एकोलाय उ फुट-फुट के रोवन लगयो। ");
INSERT INTO pwr_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","पहट होतो मुखिया याजक, सयाना अना मोसे को नियम को गुरू ना अना सप्पा यहुदी गीन को मोठो सभा ना न्याय करके यीसु ला बंधवायो, अना ओला धरके ना पीलातुस को हात मा दे देइन। ");
INSERT INTO pwr_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","पीलातुस ना ओको लक पुसिस, “का तु यहूदी गीन को राजा आस?” ओना ओला जवाब देइस “असो तु खुदच कव्हासेस।” ");
INSERT INTO pwr_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","मुखिया याजक गीन ओको पर गजब लान-छान लगावत होतीन। ");
INSERT INTO pwr_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","पीलातुस ना ओला कहीस “का तु काही जवाब नही देस? चोव यो तोरो पर केतरी गोस्टी लक लानछान लगावसेत?” ");
INSERT INTO pwr_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","यीसु ना मंग जवाब नही देइस, यहान तकन की पीलातुस ला मोठो अचंभा भयो। ");
INSERT INTO pwr_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","पीलातुस वोनो तिहार मा कोनी एक बन्दी ला जेनला वय लोकगीन चाहवत होत्यो उनको लाई छोड़ देवत होतो। ");
INSERT INTO pwr_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","बरब्बा नाव को एक मानूस होतो, उ जेल मा होत्यो उ सासन को खिलाफ खुनी लडाई मा लोक गीन को संगी होतो उ रकत कियो होतो। अना बन्दी होतो। ");
INSERT INTO pwr_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","अना भीड़ वरता जायके वोको लक पिराथना करन लगीन, का जसो तुमी रिती-रिवाज को लक करता आइसेस, वसोच करो। ");
INSERT INTO pwr_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","पीलातुस न उनला जवाब देईस, “का तुमी चाव्हासेव का मी तुमरो लाई यहूदी गीन को राजा ला छोड़ देऊ?” ");
INSERT INTO pwr_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","काहेकि पीलातुस जानत होतो की मुखिया याजक गीन ना ओला जरनोठी लक धराय होतीन। ");
INSERT INTO pwr_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","पर मुखिया याजक गीन ना लोक गीन ला उकसाईन का पिलातुस लक यीसु को जघा बरब्बा ला उनको लाई छोड़न को माग करे। ");
INSERT INTO pwr_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","यो आयक के पीलातुस ना उनलक मंग पुसिस, “ता जेनला तुमी यहूदी गीन को राजा कसो, ओको सँग मि का करू? तुमी काजक चाव्हसो?” ");
INSERT INTO pwr_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","वय मंग चिल्लाइन, “ओला कूरूस मा चघाव!” ");
INSERT INTO pwr_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","पीलातुस ना उनलक कहीस, “काहे येने काजक जुरुम करीसेस?” पर वय अखीन जोर लक चिल्लाईन, “ओला कूरूस मा चघा!” ");
INSERT INTO pwr_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","तबा पीलातुस ना भीड़ ला खुस करन की मनसा लक, बरब्बा ला उनको लाई छोड़ देइस। अना यीसु ला कोड़ा लगवाय के सुपरुत कर देइस की कूरूस मा चघायो जाहे। ");
INSERT INTO pwr_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","सिपाही ओला सरकारी मोठो किला को भीतरी आँगन मा ले गईन, अना सप्पा पलटन ला हाकल लेइन। ");
INSERT INTO pwr_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","तबा उनना ओला बैजनी रँग को कपरा घालिन अना काँटा को डगाली को मुकुट बनायके ओको डोस्का पर राखिन। ");
INSERT INTO pwr_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","यो कहके ओला नमस्ते करन लगीन, “हे यहूदी गीन को राजा, अमर रव्ह!” अना वोको मजाक उडावन लगीन ");
INSERT INTO pwr_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","वय ओको डोस्का मा घागरा काड़ी मारके ओको पर थुकिन अना टोंगरा टिकाय के ओला नमस्कार करतो रहीन। ");
INSERT INTO pwr_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","जबा वय ओको मजाक कर लेइन, ता ओला ओकोच बैजनी रँग को कपरा उतारके ओनाच पर डाकिन; तबा ओला कूरूस मा चघान को लाई बाहेर ले गईन। ");
INSERT INTO pwr_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","जब यीसु ला कूरूस पर लटकान लेय जावत होतिन त रस्ता मा एक मानूस लक भेंटीन, जोनको नाव सिमोन होतो। (वा सिकन्दर अना रुफुस को बाबूजी होतो) उ कुरेनी मानूस गाँव लक आय रहयो होतो; उनना ओला बेगार मा धर लेईन की यीसु को कूरूस ला उचल चलेह। ");
INSERT INTO pwr_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","वय यीसु ला गुलगुता नाव की जघा मजे कवटी नाव की जघा मा आनीन। ");
INSERT INTO pwr_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","वहान ओला दरद नासक दवा मिलयो अंगूर को रस देवन लगीन पर ओना नही लेइस। ");
INSERT INTO pwr_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","तबा उनना ओला कूरूस मा चघा इन अना कपरा पर चिठ्ठी डाकिन की कोन ला काजक मिलेह, ओला बाट लेईन। ");
INSERT INTO pwr_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","अना सक्कारी नौ बजे को बेरा होतो। जबा उनना ओला कूरूस मा चघा इन होतीन। ");
INSERT INTO pwr_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","अना ओको दोस पतर पर यो लिख देईन की “यहूदिगीन को राजा।” ");
INSERT INTO pwr_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","उनना ओको सँग दुई डाकु ला भी कूरूस मा चघाव गयो, एक उज्जो कन अना एक डाखियो कन। दुही ला कूरूस मा चघाइन ");
INSERT INTO pwr_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","तबा पवीतर गिरंथ को उ गोस्टी की उ दोसीगीन को संग गिनो जाहे, पूरो भयो। ");
INSERT INTO pwr_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","अना रास्ता लक कटन वारा डोस्का हला-हलाय के असो कव्हके ओकी निन्दा करत होतीन, “वाह! मंदिर को नास करनवालो अना तीन दिवस मा बनावन वालो! ");
INSERT INTO pwr_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","कूरूस पर लक उतर के आपरो आपच ला बचाव लेव।” ");
INSERT INTO pwr_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","येने रिती लक मुखिया याजक मोसे को नियम को गुरू सकट, आपस मा मजाक लक कव्हत होतीन, येने अउर लोकगीन ला सूटकारा देइस पर आपरो आप ला नही बचाय सकयो। ");
INSERT INTO pwr_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","इसरायल को राजा, मसीह अता कूरूस मा लक उतर, आव अखीन, “आमी चोवबिन अना भरोसा करबिन।” अखीन जोन ओको सँग कूरूस मा चघायो गईन होतीन, वय भी ओकी निन्दा करत होतीन। ");
INSERT INTO pwr_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","दुफारी होवनो पर सप्पा देस मा अँधारो छाय गयो। अना महातनी बेरा तीन बजे तकन रहयो। ");
INSERT INTO pwr_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","महातनी बेरा यीसु ना मोठो आवाज लक चिल्लाय के कहीस, “इलोई-इलोई लमा सबक्तनी?” जेनको मजे, “हे मोरो परमेस्वर, हे मोरो परमेस्वर, तु ना मोला कायलाई छोड़ दियोस?” ");
INSERT INTO pwr_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","जो जवर उभा होतीन, उनमा लक काही ना आयक के कहिन, “आयको, उ एलिय्याह ला हाकलासे।” ");
INSERT INTO pwr_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","एक सिपाही ना धावके स्पंज ला सिरका मा डुबाइस अना घागरा काड़ी मा राखके ओला चखाइस अना कहीस, “रुको, देखबिन, एलिय्याह ओला सूलि लक उतारन लाई आवासे का नही।” ");
INSERT INTO pwr_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","तबा यीसु ना लगत जोर लक चिल्लाय के जियान छोड़ देइस। ");
INSERT INTO pwr_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","अना मंदिर को पड़दा वरता लक खाल्या तकन फटके दुई भई गयो। ");
INSERT INTO pwr_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","जोन दरोगा (वोको हात को खालया 100 सिपाई होतिन) कूरूस को पुढा उभा होतो, जबा ओला येने रिती लक चिलावत अना जियान छोड़ता चोवीस, ता ओना कहीस, “खरो से यो मानूस परमेस्वर को टूरा होतो!” ");
INSERT INTO pwr_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","लगतसी बायको भी दुहुर लक चोय रही होतीन। उनमा मरियम मगदलीनी, नहानो याकूब अना योसेस की माय मरियम, अना सलोमी होतिन। ");
INSERT INTO pwr_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","वा बायकागिन, जबा यीसु गलील मा होतो, वोकी सेवा करत होतिन। अना लगतसा बायका ओको मंघा येरुसलेम आई होतीन। ");
INSERT INTO pwr_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","जबा झुलाखाली भय गई ता सब्त को एक दिवस पुढ़ा को दिवस होतो अना तैय्यारी को दिवस होतो। ");
INSERT INTO pwr_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","अरिमितिया को रव्हनवालो यूसुफ आयो, जो मोठीसभा को मेम्बर हो तो अना खुदच परमेस्वर को राज की रास्ता चोवत होतो। उ हिम्मत करके पीलातुस जवर गयो अना यीसु को लास ला माँगिस। ");
INSERT INTO pwr_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","यो आयक के पीलातुस ला अचंभा भयो की उ एतरो जल्दी मर गयो। अना 100 सिपाही को अधिकारी ला हाकलके पुसिस, “का ओला मरन ला देर भई?” ");
INSERT INTO pwr_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","वोना अधिकारी को जवाब आयक के पीलातुस ना लास ला यूसुफ ला दे देइस। ");
INSERT INTO pwr_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","तबा ओना मलमल को एक कपरा खरिद लेइस, अना लास ला उतारके ओला चादर मा लपटिस, अना एक मरघटी मा जो चट्टान मा खोदी गई होती राखिस। अना मरघट्टी मा धसन को जघा पर एक गोटा अड़ा देइस। ");
INSERT INTO pwr_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","मरियम मगदलीनी अना योसेस की माय मरियम चोवत होतीन की ओको लास कहाँन राखयो गयो से? ");
INSERT INTO pwr_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","जबा बिसराम दिवस बीत गयो, ता मरियम मगदलीनी अना याकूब की माय मरियम अना सलोमी, ना यीसु को तनमा मलन काजी सुगंधित चीज खरीद के आनीन। ");
INSERT INTO pwr_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","हफ्ता को पयले दिवस पहट ला, दिवस हिटन को पयले वय मरघट्टी पर आइन। ");
INSERT INTO pwr_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","ता वय आपस मा कव्हत होतीन, “की आमरो लाई मरघट्टी मा धसन को जघा को गोटा कवन लुड़काहे?” ");
INSERT INTO pwr_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","जबा उनना चोइन तो गोटा लुड़को हुयो से अना उ लगत मोठो होतो। ");
INSERT INTO pwr_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","ता मरघट्टी मा जायके देखनो पर उनना एक जवान ला पाँढरो कपरा घालयो हुयो जेवनो बसा चोवीन, ता वय लगत डराय गईन। ");
INSERT INTO pwr_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","ओना मानूस ना उनलक कहीस “नोको डराव, तुमी यीसु नासरी ला, जो कूरूस पर चघाव गयो होतो ढुँढोसो। उ जित्तो होय गयो से, इता नहात, चोवो, याच उ जघा से, जिता उनना ओला राखी होतीन। ");
INSERT INTO pwr_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","पर तुमी जाव, अना ओको चेला गीन अना पतरस लक कव्हजोस की उ तुमी लक पयले गलील जाहे। जसो ओना तुमी लक कव्हयो होतो, तुमी ओला वहान चोवने।” ");
INSERT INTO pwr_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","अना वय यीसु को मरघट्टी लक हिटके पराय गईन, काहे की सही मा वय डराय गई होतीन, एकोलाय उनना कोनी लक काही गोस्टी नही कहीन। ");
INSERT INTO pwr_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","हफ्ता को पयले दिवस पहट होतो बेरा यीसु जी उचलके पयले मरियम मगदलीनी ला जोन पर लक सात बुरो आतमा हिटी होती, चोयो। ");
INSERT INTO pwr_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","ओना जायके यीसु को संगीगिन ला, जो दुखी होतीन अना रडत होतीन खबर देइन। ");
INSERT INTO pwr_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","उनना यो आयक के की यीसु जित्तो से अना मरियम ना चोविसेस, ता उनना भरोसा नही करीन। ");
INSERT INTO pwr_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","एको मंघा यीसु दुसरो रुप मा उनमा लक दुई ला जबा वय गाँव को कन जाय रही होतीन चोयो। ");
INSERT INTO pwr_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","उनना भी जायके दुजो ला खबर देईन, पर उनना उनको भरोसा नही करीन। ");
INSERT INTO pwr_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","मंघा यीसु उन अकरा चेलागीन ला भी, जबा वय जेवन करन बसी होतीन, चोयो, अना उनको अबिस्वास अना गोटा जसो मन को कारन उनला डाटिस। काहेकि जोन्हासीन ओको जित्तो उचलनो को मंघा ओला चोयो होतीन, ओन्हासीन ओको पर भरोसा नही करीन। ");
INSERT INTO pwr_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","अना यीसु उनलक कहीस, “तुमी सप्पा संसार मा जायके सप्पा लोकगीन ला साजरो बारता सांगो। ");
INSERT INTO pwr_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","जो लोकगीन भरोसा करेहत अना बप्तिस्मा डुबकी लेहेत, ओको च सूटकारा होव्हे, पर जो भरोसा नही करेहत, वोको पर दन्ड को हुकूम ठहरेत। ");
INSERT INTO pwr_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","भरोसा करनवालो मा यो निसान होवेती, की वय मोरो नाव लक बुरो आतमा ला हेड़ेति नवी-नवी भासा बोलहेति, ");
INSERT INTO pwr_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","सरप गीन ला उचल लेहेत, अना जहेर पी जाहेत ता भी उनकी काही हानि नही होव्हेत, वय बीमार गीन पर हात राखेत अना वय चाँगलो भय जाहेत।” ");
INSERT INTO pwr_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","एको मंघा पिरभु यीसु चेलागीन लक गोस्टी करन को मंघा, सरग मा उचल लियो गयो, अना परमेस्वर को उज्जो कन बस गयो। ");
INSERT INTO pwr_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","तबा उनना हिटके जघा-जघा परचार करन लागिन, अना पिरभु परमेस्वर उनको संग-संग काम करतो रहयो। अना गजब हिदान लक उनको गोस्टी ला पक्को करत रहयो। आमीन। ");
INSERT INTO pwr_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","ओ पियारो थियुफिलुस, जोन गोस्टी हमरो संग मा बितो से। मि ना उनला लिखन को मन बनाइ सेव हमरो लक ");
INSERT INTO pwr_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","पयले यीसु को उन गोस्टी ला चोवन अखीन आयकन वालो दास होतिन। उनना सबच गोस्टी ला हमि तकन धाडिसेस। ");
INSERT INTO pwr_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","एकोलाई अगो थियुफिलुस अबा मोला यो साजरो लगि से, का उनच, गोस्टी ला खरो-खरो जाँचकेना, एक को मघा एक, ठिख-ठाख मालुम करके लिखु। ");
INSERT INTO pwr_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","जेनको लक तू जानले, का वा गोस्टी, अना जोन को गियान तुना पाईसेस। कसो अटल से? ");
INSERT INTO pwr_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","यहुदिया को राजा हेरोदेस को बेरा मा, अबिय्याह को दल मा, जकरयाह नाव को एक याजक होत्यो। अखीन वोको बायको हारून को खानदान की होति। अखीन वोको नाव एलीसीबा होती। ");
INSERT INTO pwr_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","वय दुई परमेस्वर को नजर मा नेक होतीन। वय पिरभु को सबच, हुकूम ला मानत होतीन। ");
INSERT INTO pwr_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","उन को कोनी लेकरा बारा नही होतिन। काहेका एलीसीबा वाखड होती, अखीन उ बुड़गा भई गई होतो। ");
INSERT INTO pwr_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","जब जकरयाह आपरो दल को सगंमा परमेस्वर को पुजा-पाट करत होतिन। ");
INSERT INTO pwr_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","तबा धुप-जलावन काजी, जकरयाह याजक को नाव लक चिठ्ठी हिट्यो। का उ मंदिर मा पिरभु को पूढा धुप जलाये। ");
INSERT INTO pwr_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","तबा धूप जालावन को बेरा मा, सबच बिनती करत होतिन। ");
INSERT INTO pwr_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","ओच बेरा मा पिरभु को सरगदूत ओला धुप वेदी को उज्जो कन चोवयो। ");
INSERT INTO pwr_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","जकरयाह डराय गयो, अखीन ओको “घिघगि बंध गयो।” ");
INSERT INTO pwr_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","पर सरगदूत न ओला सांगिस, ओ जकरयाह, भेव नोको खावजोस, काहेका तोरो पिराथना परमेस्वर ना आयक, लेइस। अखीन तोरि बायको एलीसीबा लक, तोरो लाय एक टूरा होहेत, अखीन तु वोको नाव योहन राखजोस। ");
INSERT INTO pwr_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","तोला खुसी होहे। अखीन गजब लोकगीन, वोको जनम को कारन, खुसी मनाहेत। ");
INSERT INTO pwr_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","काहे का उ पिरभु को पुढ़ा, मा महान होयेत। अखीन अंगूर को रस, अर दारु, कभी नही पिहेत। अखीन उ आपरो माय को पोट लक, पवीतर आतमा लक भरो होयेत। ");
INSERT INTO pwr_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","अखीन भटको हुओ, इसरायल को गजब लोकगीन ला, उनको परमेस्वर को रास्ता मा आनेत। ");
INSERT INTO pwr_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","उ एलिय्याह को आतमा अखीन ताकत मा, पुढा-पुढा चलेत, क आजा पुरखागीन को मन ला, लेकरा-बारा मा लगा देहेत। अखीन हुकूम नही मानन वालो ला, नेक बना देहेत। अखीन पिरभु को लाई, साजरो लोकगीन ला, तैय्यार करयेत। ");
INSERT INTO pwr_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","जकरयाह ना सरगदूत सांग्यो, यो कसो होयेत? काहेकी मी, अखीन मोरो बायको, दूई को बुडगापन से। ");
INSERT INTO pwr_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","तब सरगदूत ना वोला जवाब दियो, मी जिबराइल सरगदूत सेव। जोन परमेस्वर को पुढा उभो रहुसु, अखीन तोरो लक बात करन, अखीन यो खबर आयकावन काजी इता आईसेव। ");
INSERT INTO pwr_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","जोन दिवस तकन यो गोस्टी पूरो होहेत, ओना दिवस तकन तू गुंगो रव्हजो। काहेका तू मोरी गोस्टी पर भरोसा नही मानीसेस। ");
INSERT INTO pwr_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","लोग गीन जकरयाह को “बाट जोहत होतिन” अखीन चकित भईन। काहे का मंदिर मा, वोला उसीर भई गई होती। ");
INSERT INTO pwr_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","जब उ बाहेर हिटयो, तो उ बोल ना सकयो, तब लोकगीन जान गईन, का मंदिर पर कोनी दरस-परस भयो से। अखीन उ ईसारा करत होतो, अखीन गुगों भय गयो होतो। ");
INSERT INTO pwr_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","जब वोको सेवा को दिवस पूरो भयो, तो उ आपरो घर चलो गयो। ");
INSERT INTO pwr_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","काही बेरा को बादमा वोको बायको एलीसीबा पेट लक भई। वो 5 मास तकन आपरो ला छुपाय राखयो। ");
INSERT INTO pwr_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","अखीन कव्हन लगयो, मोरो कलंक दुर करन काजी, पिरभु न किरपा करीसेस। ");
INSERT INTO pwr_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","छँटवो महीना मा, परमेस्वर कन लक, एक कुँवारी को कन जिबराइल सरगदूत नाव को, सरग दूत ला धाडिस। वा टूरी गलील छेतर को, नासरत नगर मा, रव्हन वालो होती। ");
INSERT INTO pwr_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","जोकि पक्की राजा दाऊद को खानदान मा, यूसुफ नामको टूरा संग भई होती। ओ कुँवारी टूरी को नाव मरियम होती। ");
INSERT INTO pwr_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","सरग दूत ना, ओको कठा जायके सांगिस, नमस्कार मरियम, पिरभु को किरपा तोरो पर भईसे। ");
INSERT INTO pwr_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","अखीन, यो बात ला आयक के, वा टूरी घबराय गई, अखी मनमा सोचन लगी, यो कसी गोस्टिसे? ");
INSERT INTO pwr_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","तबा सरगदूत ना कहीस, मरियम तु भेव नोको कर, परमेस्वर को किरपा तोरो पर भईसे। ");
INSERT INTO pwr_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","चोव! तु पोट लक होवजोस, अखीन तोरो लक एक टूरा जनम लेहे, तु ओको नाव यीसु राखजो। ");
INSERT INTO pwr_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","उ महान होहे अखीन पिरभु को टूरा कहलाहे। परमेस्वर वोको आजा-पुरखा, दाऊद को सिघासन वोला देहे। ");
INSERT INTO pwr_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","अना उ तोरो पुरखा, याकूब को घराना मा, जुग-जुग लक राज करहे, अखीन वोको राज अमर रहेत। ");
INSERT INTO pwr_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","मरियम ना सरगदूत ला कहीस, यो कसो होहे, मी तो, कोनी मरद को संग नही सोयी सेऊ। ");
INSERT INTO pwr_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","सरगदूत ना वोला साँगिस, पवीतर आतमा को ताकत तोरो पर आहेत, अखीन मोठो परमेस्वर तोरी, रक्सा करहे। एको लाई उ पवीतर, जो जनम लेवन-वालो से, परमेस्वर को टूरा कहलाहे। ");
INSERT INTO pwr_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","अखीन देख, तोरो कुटुम्ब मा एलीसीबा लक वोला बुड़गीपन मा टूरा होवन वालो से। अब वोको छँटवो महीना से। ");
INSERT INTO pwr_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","काहे की परमेस्वर की गोस्टी खरी ठयरासे। कभी खोटो नही होवासे। ");
INSERT INTO pwr_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","मरियम ना सांगिस, चोव, मी, पिरभु की सेविका सेउ। मोला तु जसो सांगासे, वसोच गोस्टी भई जाहे। तब सरगदूत ओको कठा लक चलो गयो। ");
INSERT INTO pwr_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","वो ना बेरा मा, मरियम लवकर तैय्यार भई अखीन आपरो कुटुम्बी एलीसीबा को यहूदा देस को पहाड़ी गांव मा गई। ");
INSERT INTO pwr_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","वो जकरयाह को घर मा गई। अखीन एलीसीबा ला नमस्कार करीस। ");
INSERT INTO pwr_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","जेंधावर एलीसीबा ना, मरियम को नमस्कार आयकिस, तसोच, वोको लेकरा पोट मा उचलो, अना उ पवीतर आतमा लक भर गई। ");
INSERT INTO pwr_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","अना वा चिल्ला के कहीस, तु सबच आई-माई गीनमा धन्य से। अना धन्य से तोरो पोट को फर। ");
INSERT INTO pwr_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","मोरो ऊँचो किस्मत से का, मोरो पर दया कसो भई? पिरभू को माय मोरो घरमा आई सेस। ");
INSERT INTO pwr_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","काहेका, जसो तोरो नमस्कार मीना आयकीसेव, लेकरा मोरो पोट मा, खुसी लक उछल पडयो। ");
INSERT INTO pwr_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","तू धन्य सेस, जोन ना बिस्वास लक असो करीसेस, का पिरभू ना जोन गोस्टी साँगीसेस, वो पूरी भई जाहेत। ");
INSERT INTO pwr_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","एको पर मरियम असो गावन लगी, “मोरी जीव (मन) पिरभु को गुन-गान करासे।” ");
INSERT INTO pwr_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","मोरो जीव, आपरो मुक्ती देवन वालो, परमेस्वर को खुसी मनावसे। ");
INSERT INTO pwr_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","काहे का वोना आपरो सेविका को गरीबी पर, किरपा करीसेस। अब लक सब पीड़ी, मोला धन्य कहेति। ");
INSERT INTO pwr_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","काहे का, गजब सक्तिसाली परमेस्वर ना, मोरो लाय मोठयो काम करीसेस, पवीतर से वोको नाव। ");
INSERT INTO pwr_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","वोको तरस वोको भविस्यवक्ता गीन पर, पीढ़ी-पीढ़ी लक बनो रव्हसे। ");
INSERT INTO pwr_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","परमेस्वर ना अपरो ताकत दिखाईसेस, वोना घमन्डी गीन ला, छितराय देईसे। ");
INSERT INTO pwr_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","वोना मोठो अधिकारी गिनला, उनको सिघासन लक उतार दियो से। अखीन, गरिब ला, महान बनायो से। ");
INSERT INTO pwr_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","वोना भुखो-लाघो गिनला, साजरो-साजरो जेवन देइसेस। अखीन धनी गिनला, रिकामो हात लौटा दियो से। ");
INSERT INTO pwr_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","वोना अपरो दया, ला ध्यान देके ना, आपरो दास इसरायल ला संभालयो से। ");
INSERT INTO pwr_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","जसो कसम, हमरो बाप-दादा लक खायो होतो। का अबराहम अखीन ओको सन्तान पर, परमेस्वर को करुना सदा बनो रहेत। ");
INSERT INTO pwr_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","तीन महीना मरियम एलीसीबा को घर रहकेना, अपरो घर आय गई। ");
INSERT INTO pwr_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","एलीसीबा को जचकी को बेरा पूरो भयी। अखीन वोना एक टूरा ला जलम दियो। ");
INSERT INTO pwr_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","जब वोको पड़ोसी, अखीन रिस्तेदार ना यो बात आयकिन, का पिरभु को किरपा से। तब सब वोको संग खुसी मा सामील भईन। ");
INSERT INTO pwr_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","आठवा दिवस टूरा को खतना को बेरा आयो। तब लोकगीन वोको नाव वोको बाबूजी जकरयाह को नाव पर, राखन चाव्हत होतीन। ");
INSERT INTO pwr_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","पर वोको माय ना सांगीस, नही, एको नाव योहन राखबिन। ");
INSERT INTO pwr_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","तब वोना लोकगीन कव्हन लगीन, तुम्हारो कुटुम्ब मा, कोनी को असो नाव नहात। ");
INSERT INTO pwr_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","तब लोकगीन ईसारा करके वोको बाबूजी लक पुसन लगीन, उ का नाव राखन चाव्हसेस। ");
INSERT INTO pwr_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","वोना पाटी मागंके ओमा योहन नाव लिख्यो। ");
INSERT INTO pwr_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","वोच बेरा मा, जकरयाह को जुबान खुल गयो, अखीन उ परमेस्वर को धन्यवाद करन लगयो। ");
INSERT INTO pwr_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","तब सब सेजारीगीन मा भेव छाय गयो। अखीन उनको गांव को आखा-पाखा मा अना यहुदिया देस मा यो गोस्टी को चरचा फैल गयो। ");
INSERT INTO pwr_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","सब आयकन वारा मन मा विचार के, ना कव्हन लगीन, का यो लेकरा का बनहेत? काहे का सचमूच मा पिरभु को “वोको पर हात होतो।” ");
INSERT INTO pwr_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","योहन को दादजी जकरयाह, पवीतर आतमा लक भर गयो। अखीन असो कव्हत, आवन वारो गोस्टी साँगन लग्यो। ");
INSERT INTO pwr_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","धन्य से इसरायल को परमेस्वर, वोना आपरो लोकगीन को सूधी लेवासे, अखीन उनको मोक्स करोसे। ");
INSERT INTO pwr_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","अखीन आपरो दास दाऊद को घराना, लक एक सूटकारा देवन वालो सींग हिटिसे। ");
INSERT INTO pwr_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","उ आपरो पवीतर भविस्यवक्ता को टोन्ड ले, पूरानो जमाना लक, यो कव्हतो आयो सेस। ");
INSERT INTO pwr_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","क उ बैरी अखीन सब बैरी हुन को हात लक, हमीला सूटकारा करीसेस। ");
INSERT INTO pwr_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","का आमरो बाबूजी दादजी पर दया करके आपरी पवीतर वायदा ला हेत करयेत। ");
INSERT INTO pwr_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","वोना किरया खायके ना, हमारो पुरखा अबराहम लक, असो सांग्यो होतो। ");
INSERT INTO pwr_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","क उ हमारो दुस्मन को हाथ लक, हमीला छुड़ाय लेहेत। ");
INSERT INTO pwr_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","जोन को लक हमी बेधड़क, पवीतर, अखीन न्यायी पन लक वोको सेवा करयेत। ");
INSERT INTO pwr_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","उ टूरा सब लक मोठो परमेस्वर को भविस्यवक्ता कहलाव जोस, तू पिरभू को पूढ़ा चलन वालो दूत बनजो! तू वोको मारग तैय्यार करजो। ");
INSERT INTO pwr_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","अखीन वोको लोकगीन ला, उनको पाप छिमा को कन लक, मुकती को गियान देवजोस। ");
INSERT INTO pwr_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","हमारो परमेस्वर को यो माया, अखीन दया लक, हमी ला सरग लक, उजाड़ो मिलहेत। ");
INSERT INTO pwr_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","जेनको लाय उ इन्धीयारो अखीन, मरन को सावली मा, जो लोग बस्यो से, वोला उजाडो देवजो! अखीन हामरो पाय ला सान्ती को रास्ता मा ले जाहेत। ");
INSERT INTO pwr_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","लेकरा योहन मोठो होवन लग्यो, अखीन वोको आतमा बल बढन लगयो! उ इसरायल को सामने चोवनो को पूढ़ा सुनसान जघा मा रव्हन लग्यो। ");
INSERT INTO pwr_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","ओना बेरा मा राजा औगुस्तुस कैसर को कना लक हुकूम हिटयो, क सारो जग का लोकईन को नाव लिखवान की जाये। ");
INSERT INTO pwr_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","यो पयलो नाव लिखवाई वोना बेरा भयो, जब किवरिनियुस सीरिया को राजा होतो। ");
INSERT INTO pwr_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","सब लोग आपरो-आपरो नाव लिखवान काजी आपरो नगर मा गइन। ");
INSERT INTO pwr_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","मंघा यूसुफ अखीन मरियम, आपरो नाव लिखावन काजी गलील को नासरत नगर ले, यहुदिया मा दाऊद को नगर बैतलेहम मा गईन। ");
INSERT INTO pwr_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","वहान दूई युसूफ अना मरियम जोनको पक्की भयी होती जायके आपरो नाव लिखवान गईन। ");
INSERT INTO pwr_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","जब उ दोई वोच नगर मा होतीन, तब मरियम को जचकि को बेरा भई गयी। ");
INSERT INTO pwr_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","उनको रुकन को लाय सराय मा, जघा नही होतो। यो काजी वय गाई-बईल को कोठा मा रुकिन। अखीन वोको पयलो टूरा वहांच भयो, अखीन वोला कपरा मा लपेट केना, गव्हान मा राखीस। ");
INSERT INTO pwr_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","देस मा केतरा गडेरिया होतीन, जोई रात ला मैदान मा रहके, आपरो करप को निगरानी करत होतिन। ");
INSERT INTO pwr_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","तबा परमेस्वर को एक सरगदूत, उनको जवर आयके, उभो भयो। अना पिरभू को तेज, चमकन लगयो, तबा उन गजब डराय गईन। ");
INSERT INTO pwr_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","परमेस्वर को सरगदूत उनला कव्हसे, नोको डराव चोवो, मी तुम्ही ला मोठयो खुसी को साजरो बारता सांगसू। जो सब लोग लाय होहे। ");
INSERT INTO pwr_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","आज दाऊद को नगर मा तुमरो लाय एक पाप मोचक जन्म लेईसे योच मसीह पिरभू से। ");
INSERT INTO pwr_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","योको यो निसान सेत का तुमही एक टूरा ला कपरा मा लिपटो गव्हान मा रख्यो पावजो। ");
INSERT INTO pwr_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","तबा एकाएक लक उ परमेस्वर को सरग दूत संग अना दूतगिन भी परमेस्वर की भक्ती करत अना यो सांगत चोवयो। ");
INSERT INTO pwr_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","सरग मा परमेस्वर की बड़ाई अना धरती मा उन मानूस लक जिन लक खुस से, अखीन सान्ती होय। ");
INSERT INTO pwr_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","जब पिरभू को सरगदूत उनको जवर लक सरग मा गईन। तो गडरिया ना आपस मा कव्हन लगीन। आओ हमि बैतलेहम जायके, जो हमला परमेस्वर को दुत सांगिसेस देखबिन। ");
INSERT INTO pwr_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","तब उनना गदने जायके मरियम अना यूसुफ ला, अखी गव्हान मा उ टूरा ला पड़यो चोविन। ");
INSERT INTO pwr_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","ऐना ला चोवके, उनना वा सबद जो यो टूरा को बारे मा सरगदूत सागयो होतो, उन लक सांगन लगीन ");
INSERT INTO pwr_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","अना गडरिया को गोस्टी आयक के सब आयकन वालो ना अचंभा करीन। ");
INSERT INTO pwr_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","पर मरियम यो सब कव्हनो ला, आपरो मन मा सोचत होती। ");
INSERT INTO pwr_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","अखीन गडरिया जसो उनला कव्हयो होतो, वसोच चोवके, वोना लोकगीन, परमेस्वर को बड़ाई अना भक्ति करत-करत लवट गईन। ");
INSERT INTO pwr_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","सरगदूत को कव्हन को लक, आठ दिवस को मंघा, जब लेकरा को खतना को बेरा आयो। तब वोको नाव यीसु राखयो, काहे का सरगदुत ना, पुढा मा असोच सांगयो होतो। ");
INSERT INTO pwr_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","मोसे को नियम को लक, जब लेकरा को अरपन लक सुध्द करन को दिवस आयो। ता वय ओला येरुसलेम मा आनीन की पिरभू को पुढा लाहेत। ");
INSERT INTO pwr_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","जसो का मोसे को नियम मा लिख्योसे, हर एक पयलो टूरा, पिरभू को लाय पवीतर मानो जाय। ");
INSERT INTO pwr_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","अखीन एको लाय भी का, उ मोसे को नियम को हुकूम लक, परेवा को एक जोड़ा, या दोन बच्चा पिरभू को लाय बली चघाइन। ");
INSERT INTO pwr_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","ओना बेरा येरुसलेम नगर मा, सिमोन नाव को, एक नेक मानूस रव्हत होतो। उ इसरायल को सान्ती को बाट चोवत होतो। पवीतर आतमा ओको पर होतो। ");
INSERT INTO pwr_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","अखीन पवीतर आतमा लक, मिल्यो जानकारी को लक, जब तकन उ मसीह पिरभू को दरसन ना करलेहे नही मरन को, असो वोला बरदान होतो। ");
INSERT INTO pwr_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","उ पवीतर आतमा ले मिलो जानकारी को लक, मंदिर मा आयो। “जब माय-बाप लेकरा यीसु को लाय, मोसे को नियम पूरो करन, वोला भित्तर लाईन।” ");
INSERT INTO pwr_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","तबा सिमोन ना लेकरा ला, अपरो कन्हिया मा लियो, अखीन परमेस्वर को धन्य करत कव्हन लगयो। ");
INSERT INTO pwr_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","हे मालीक! अब तु अपरो कव्हन को लक, सान्ती लक आपरो दास सार कर। ");
INSERT INTO pwr_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","काहेका मोरो डोरा ना ओको सूटकारा मोला चोविसे। ");
INSERT INTO pwr_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","जो ला तुना सब लोकगीन को पूढा मा दिखवा सेस। ");
INSERT INTO pwr_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","यो दुसरो लोकगीन लाय लुको गोस्टी को खुलासा लाई आखिन तोरी पर जा इसरायल ला मान देवन वालो उजाड़ो से। ");
INSERT INTO pwr_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","टूरा को बारे मा यो गोस्टी आयक के ओको माय बाप चकित भय गईन। ");
INSERT INTO pwr_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","सिमोन ना उनला, अखीन आसीस दियो। अना लेकरा को माय मरियम ला कहीस। अवो यो लेकरा, एक असो निसान से, जोन को लोकईन विरोध करयेत, यो कारन लक इसरायल मा बहुत लोकगीन को पड़नो, अखीन जी उचलनो होयहेत। ");
INSERT INTO pwr_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","अखीन एक तरवार, वोको हिरदय को आरपार, छेद देहेत। जेनको लक लोकगीन को, मन को बात टोन्ड मा आ जाहे। ");
INSERT INTO pwr_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","हन्ना नाव को एक भविस्यवक्तनी बाई होती। जो आसेर को खानदान मा, फनुऐल को टुरि होती। वा गजब बुड़गी होती। वा लगन को बाद मा, केवल सात साल, अपरो नवरा संग जित्तो रहि होती। ");
INSERT INTO pwr_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","अखीन मंघा, वा बेवा भई गई होती अना ओको चऊरासी बरस लक बेवा होती। वा मंदिर को बाहेर नही हिटत होती, अखीन उपास पिराथना करत-करत, रात दिवस परमेस्वर को सेवा मा रव्हत होती। ");
INSERT INTO pwr_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","वा भी वोच बेरा मा आयकेना, परमेस्वर ला धनवाद देवन लगी। अखीन जोन लोग येरुसलेम नगर को सूटकारा को रस्ता, चोवत होतीन, उन सबला वा लेकरा को बारे मा सांगन लगि। ");
INSERT INTO pwr_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","मोसे को नियम को लक पिरभू लाय सब कुछ पूरो करन को मंघा, ओना गलील छेतर मा, अपरो नगर नासरत मा लवट गइन। ");
INSERT INTO pwr_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","लेकरा यीसु मोठो होवन लग्यो, अखीन उ अक्ल लक भरपुर होतो गयो। काहे का “परमेस्वर को हात वोको पर होतो” मजे किरपा होतो। ");
INSERT INTO pwr_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","यीसु को माय-बाप हर साल बलिदान तिहार मनावन ला, येरुसलेम नगर जावत होतयो। ");
INSERT INTO pwr_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","जबा यीसु बारा साल को भयो, तबा उ आपरो रीती को लक, तिहार मनावन काजी, येरुसलेम नगर मा गईन। ");
INSERT INTO pwr_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","तिहार को रोज, पूरो होवन को मंघा, वो लवट गईन, मंग लेकरा यीसु येरुसलेम मा रह गयो, वोको माय-बाप यो बात नही जानत होतीन। ");
INSERT INTO pwr_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","वय समझत होतीन का, उ यातरी दलमा सेत। येको लाय उ एक दिवस को यातरा पूरो करन को बाद मा, वोला आपरो कुटूम्ब अखीन जान-पहचान का लोकगीन मा ढुन्ढ-ढान्ड करन लगीन। ");
INSERT INTO pwr_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","जब यीसु उनला नही मीलयो, तब ढुंढत-ढान्डत येरुसलेम नगर पँहुचिन। ");
INSERT INTO pwr_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","तीन दिवस को बाद मा, उनला यीसु मंदिर मा मिल्यो। उ बसके ना, धरम गुरूगीन लक सवाल-जवाब करत पायो गयो। ");
INSERT INTO pwr_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","सब आयकन वारा, अक्ल अखीन सवाल-जवाब पर चकीत भई गईन। ");
INSERT INTO pwr_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","वोको माय-बाप भी वोला चोवके ना, अचंभा भई गइन। वोको माय ना वोला कहीस, टूरा, तू ना आमरो संग मा असो काहे करीसेस? देख, तोरो बाप अखीन मी, चिन्ता मा होतीन, अखीन तोला ढुढ़त होतिन। ");
INSERT INTO pwr_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","तब यीसु ना कव्हयो, का तुम्ही मोला काहे ढुन्ढ-ढान्ढ काहे करासो? तुम्ही नही जानसो, की मी पक्को, आपरो बाबूजी को घर मा रहू। ");
INSERT INTO pwr_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","पर यो गोस्टी, कोनी ला समझ नही आयो। ");
INSERT INTO pwr_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","यीसु उनको संग येरूसलेम नगर लक आपरो घर नासरत नगर मा आयो। अखीन, उ आपरो माय-बाप को आधीन रहयो। वोको माय ना यो सब गोस्टी आपरो मन मा, सजोय के राखीस। ");
INSERT INTO pwr_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","यीसु अक्ल अना ताकत मा, अखीन परमेस्वर अना मानूस को किरपा मा बढतो गयो। ");
INSERT INTO pwr_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","तिबेरियुस को, सरकार को पांचवा साल होत्यो। कैसर को राज मा पोंतियुस पिलातुस, यहुदिया गलील को राजपाल होतयो। दोनी भाऊ, फिलिपी इतूरैया, तरखोनीतिस राज को राजा, अखीन लुसानियस, अबिलेने राज को, राजा होत्यो, अना गलील मा हेरोदेस राजा होतो। ");
INSERT INTO pwr_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","हन्ना अखीन काइफा, मुखिया याजक होतो। वोना दिवस मा, परमेस्वर को कव्हनो, सूनसान जघा मा जकरयाह को टूरा, योहन को कठा पहुचो। ");
INSERT INTO pwr_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","उ यरदन नदी को आजू-बाजू को छेतर मा, घुम-घाम के न पाप छिमा, अखीन पाप लक मन हटाव, बप्तिस्मा, को बारे मा, परचार करन लगयो। ");
INSERT INTO pwr_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","जसो भविस्यवक्ता यसायाह को पवीतर किताब मा लिख्यो से, “सून-सान जघा मा चिलावन वालो को आवाज। पिरभू को रास्ता ला तैय्यार करो! अखीन वोको रास्ता ला सीधो करो” ");
INSERT INTO pwr_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","दुई टवरिया को बीच को खोदरा, भर दियो जाय, हर एक पहाड-पहाड़ी खाल्या करो। टेडो-टाडो रस्ता सिधो करो, उबड-खाबड रस्ता ला समान करो। ");
INSERT INTO pwr_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","अना हरेक लोकगीन परमेस्वर को आतमा छुट्टकारा ला चोवयेत। ");
INSERT INTO pwr_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","जोन लोक बप्तिस्मा लेवन ला आवत होतीन, योहन उनला कव्हत होत्यो, हे सरप को लेकरा कोन तुम्हीला सांगीसेस, की परमेस्वर को हिजरनो लक पराय जाओ। ");
INSERT INTO pwr_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","आपरो मन ला पाप लक हटाय के पस्तावा करो, अना साजरो भई जाओ, अखीन साजरो-साजरो काम करो। तुम्ही आपरो मन मा असो मत सोचो, हमी अबराहम को खानदान को सेत। मि तुम्ही ला सांगासु, परमेस्वर ऐना गोटा लक, अबराहम को लाय, लेकरा जनमा सकसे। ");
INSERT INTO pwr_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","अबा झाड़ को जड़ मा, टँगिया से। जो झाड़ साजरा फर नही देवासे, वोला काटपीट के ना, स्तो मा पेटाय दियो जाहेत। ");
INSERT INTO pwr_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","तबा लोग गीन योहन लक पुसयो, तो हमि काजक करबीन? ");
INSERT INTO pwr_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","तबा वोना जवाब दियो, जोको कना दोन कुरता से, वोला देदो, जोन को कठा नहाती, अना जोन को कठा जेवन को सेत, वो भी वसोच करयेत। ");
INSERT INTO pwr_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","अना जमा पटानवारा अधिकारी गीन ओको जवर बप्तिस्मा-लेवन आइन, अखीन वोला पुछीन, गुरूजी हमला का करनो से सांगो? ");
INSERT INTO pwr_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","तब योहन ना कव्हयो, जितरो ठहरायो गयोसे वोको लक जादा नोको लेवने। ");
INSERT INTO pwr_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","सीपाहि गीन पुसन लगीन, अखीन आमरो लाय काजक हुकूम से? तबा उ सांगयो, कोनी लक पैसा नोको एठने। अखीन झुठो दोस नोको लगावने, पर आपरो तनखा मा जिन्दगी करो, घूस नोको लेवने। ");
INSERT INTO pwr_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","जबा आस लगायके होतीन अना योहन को बारे मा आपरो मन मा सोच बिचार कर रही होतीन। का योच ता मसीह नहात? ");
INSERT INTO pwr_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","यो काजी योहन कहीस, तुम्ही अपरो-आपरो मनमा काजक सोचसो, कही मी मसीह सेऊ? सच-मूच मा मी मसीह नही सेव। काहे का मि, तो तुम्ही ला पानी मा बप्तिस्मा देवासू, पर उ आवन वालो मसीहा, मोरो ले जादा ताकतवर से। मी वोको जूता को दोरी, खोलन को काबील नही सेव, उ तुम्हीला, पवीतर आतमा, अखीन स्तो लक बप्तिस्मा देहेत। ");
INSERT INTO pwr_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","वोको हात मा सूपड़ो से, उ आपरी खरीयान ला साजरो रीती लक सफा करहे। अपरो गँहु ला कोठी मा जमा करयेत। अखीन भुसा-भासी ला, कभ्भू नही बुझन वालो स्तो मा, डाक देहेत। ");
INSERT INTO pwr_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","योहन असो अजब-गजब उदाहरन समेत सिक्सा, जनता ला आयकावत होतो। ");
INSERT INTO pwr_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","पर योहन ना राजा हेरोदेस ला, वोको भाऊ हेरोदियास बहू को बारे मा, अखीन वोको सब गलत काम को लाई, वोला बूरो-भलो ठासन लगयो। ");
INSERT INTO pwr_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","तब राजा ना, योहन ला धरवायके जेल मा डाक देईस। अखीन आपरो खोटो काम को, हद पार कर देईस। ");
INSERT INTO pwr_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","जबा सबा लोकगीन बप्तिस्मा लेईन, तबा यीसु भी बप्तिस्मा लेवन को बाद, परमेस्वर लक पिराथना करन लगीस। तबा बादल खुल गयो। ");
INSERT INTO pwr_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","अखीन परेवा को देह जसो, पवीतर आतमा वोको पर उतर गयो, अखीन सरग लक यो आवाज आयो, तू मोरो चहेतो टूरा आस, मी तोरो लक गजब खुसी सेव। ");
INSERT INTO pwr_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","जब यीसु ना परमेस्वर को सेवा सुरु करीस। ओना बेरा उ तीस बरस को होतो। लोग ओला यूसुफ को टूरा समझत होतिन। यूसुफ एली को टूरा होतो, ");
INSERT INTO pwr_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","अखीन उ मत्तात को टूरा, अखीन उ लेवी को टूरा, अखीन उ मलकी को टूरा, अखीन उ यन्ना को टूरा, अखीन उ यूसुफ को, टूरा ");
INSERT INTO pwr_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","अखीन उ मत्तित्याह को टूरा, अखीन उ आमोस को टूरा, अखीन उ नहूम को टूरा, अखीन उ असल्याह को टूरा, अखीन उ नोगहा को टूरा, ");
INSERT INTO pwr_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","अखीन उ मात को टूरा, अखीन मत्तित्याह को, अखीन उ सिमी को, अखीन उ योसेख को, अखीन उ योदाह को, ");
INSERT INTO pwr_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","उ योहान को, अखीन उ रेसा को, अखीन उ जरुब्बाबिल को, अखीन उ सालतिएल को, अखीन उ नेरी को, ");
INSERT INTO pwr_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","अखीन उ मलकी को, अखीन उ अद्दि को, अखीन उ कोसाम को, अखीन उ इलमोदाम को, अखीन उ एर को, ");
INSERT INTO pwr_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","अखीन उ यहोसु को, अखीन उ एलीएजर को, अखीन उ योरीम को, अखीन उ मत्तात को, अखीन उ लेवी को ");
INSERT INTO pwr_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","अखीन उ सिमोन को, अखीन उ यहूदा को, अखीन उ यूसुफ को, अखीन उ योनाम को, अखीन उ इलयाकीम को ");
INSERT INTO pwr_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","अखीन उ मेलेआह को, अखीन उ मिन्नाह को, अखीन उ मत्तात को, अखीन उ नातान को, अखीन उ दाऊद को, ");
INSERT INTO pwr_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","अखीन उ यिसै को, अखीन उ ओबेद को, अखीन उ बोअज को, अखीन उ सेलह को, अखीन उ नहसोन को, ");
INSERT INTO pwr_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","अखीन उ अम्मीनादाब को, अखीन उ अरनी को, अखीन उ हिसरोन को, अखीन उ पेरेस को, अखीन उ यहूदा को, ");
INSERT INTO pwr_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","अखीन उ याकूब को, अखीन उ इसहाक को, अखीन उ अबराहम को, अखीन उ तेरह को, अखीन उ नाहोर को, ");
INSERT INTO pwr_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","सरुग को, अखीन उ रऊ को, अखीन उ पेलेग को, अखीन उ एबर को, अखीन उ सेलेह को ");
INSERT INTO pwr_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","अखीन उ केनान को, अखीन उ अरपछद को, अखीन उ सेम को, अखीन उ नूह को, अखीन उ लामेक को, ");
INSERT INTO pwr_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","अखीन उ मथूसेलह को, अखीन उ हनोक को, अखीन उ यारेद को, अखीन उ महल्लेल को, अखीन उ केनान को, ");
INSERT INTO pwr_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","अखीन उ एनोस को, अखीन उ सेत को, अखीन उ आदम को, अउर अखीन उ परमेस्वर को टूरा होतो। ");
INSERT INTO pwr_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","यीसु पवीतर आतमा लक पूरो भरके ना, यरदन नदी लक लवटयो। तबा आतमा वोला सूनसान मा लेगइस। ");
INSERT INTO pwr_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","वोना जघा बालजबूल चालीस दिवस तकन वोको परीक्सा लेवत रहयो। यीसु उन दिवस मा काही नही जेविस, जबा चालीस दिवस बीत गयो, तबा वोला गजब भूख लग्यो। ");
INSERT INTO pwr_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","बालजबूल ना वोला सांग्यो, यदी तु परमेस्वर को टूरा आस, तो यो गोटा ला हुकूम देव, का यो भाकर बन जाहेत। ");
INSERT INTO pwr_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","पर यीसु ना जवाब देइस। गिरंथ मा लिखीसे। मानूस भाकर लक नही, पर परमेस्वर को गोस्टी लक जित्तो रहेत। ");
INSERT INTO pwr_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","मंग बालजबूल वोला, वरता उठायके ना ले गईस, अखीन पलभर मा जग को राज चोवाइस। ");
INSERT INTO pwr_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","अखीन बालजबूल ना वोला कहीस, मी तोला यो सबच राज अना महिमा देदेहू। यो मोरो अधिकार मा से, मि जोनला चाँहू ओला दे सकासू। ");
INSERT INTO pwr_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","यदी तू मोरो पाँय पड़जोस अना नमस्कार करजोस, ता यो सबा तोला देदेहू। ");
INSERT INTO pwr_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","तबा यीसु ना जवाब देइस, गिरंथ मा लिखीसे, तू आपरो पिरभू परमेस्वर ला नमस्कार करजो, अखीन वोको च सेवा करजो। ");
INSERT INTO pwr_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","तबा बालजबूल ना, वोला येरुसलेम नगर, को मंदिर को छेन्डी मा, उभो करयो। अखीन कव्हयो, यदि तू परमेस्वर को टूरा से, तो खाल्या कूद जाय। ");
INSERT INTO pwr_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","काहेका गिरंथ मा लिखीसे, तोरो लाय परमेस्वर आपरो सरगदूत ला हुकूम देहेत, अखीन वो तोला बचाहेत। ");
INSERT INTO pwr_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","कही तोरो पाँय मा खोद्दा, नोको लग जाय। ");
INSERT INTO pwr_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","यीसु ना जवाब देइस, यो लिखी से, तू आपरो पिरभू परमेस्वर को परिक्सा नोको करजो। ");
INSERT INTO pwr_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","असो परिक्सा लेवन को बाद, बालजबूल सैतान वोको जवर लक, पराय गयो। ");
INSERT INTO pwr_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","यीसु आतमा को ताकत लक भरके, गलील छेतर मा हिट आयो। वोको चरचा, आखा-पाखा को सबा जघा मा फैल गयो। ");
INSERT INTO pwr_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","उ सभाघर मा जायके ना, सिक्सा देवन लग्यो। अखीन लोकगीन वोको बड़ाई करन लगीन। ");
INSERT INTO pwr_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","जबा यीसु आपरो नगर नासरत मा आयो। जहाँ उ पालो गयो होतो। तबा उ आपरो आदत को लक पवीतर दिवस सभाघर मा गयो। उ गिरंथ बाचन ला उभो भयो। ");
INSERT INTO pwr_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","तबा वोला भविस्यवक्ता यसायाह को किताब दियो गयो, गिरंथ खोलके ना उ जघा हेड़यो, जहा लिखो से। ");
INSERT INTO pwr_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","पिरभू को आतमा मोरो वरतासे, काहेका वोना मोला निवाड़ी सेस, का मी गरीब-गोर ला साजरो बारता आयकावाहु, वोना मोला धाड़ीसेस। जोको लाया मी बन्दी लोकगीन को सूटकारा, अखीन अँधरा गीन ला डोरा चोवन को, खबर सुनाऊ। मी दलीत लोकगीन ला, सोड़ाऊ। ");
INSERT INTO pwr_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","अखिन पिरभू को किरपा को साल, ला सबला साजरा बारता आयकावसू। ");
INSERT INTO pwr_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","यीसु ना किताब ला बंद कर दियो, अखीन दास को हात मा धरा दियो, अखीन सबा बस गईन। सभाघर मा, सबकी नजर यीसु पर होतो। ");
INSERT INTO pwr_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","तबा यीसु ना कव्हयो, यो गोस्टी आज पवितर गीरंथ मा पूरो भई। ");
INSERT INTO pwr_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","सब लोग गीन वोकी किरपा को बात आयक के चकीत भई गईन। अखीन आपस मा कव्हन लगीन। का यो सचमा यूसुफ को टूरा नहाय? ");
INSERT INTO pwr_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","वोना उन लक कहीस, तुम्ही मोरो पर यो हाना जरुर कहजोस, हे बईद, अपरो आप ला साजरो कर, जो काही हमि न आयकी सेजन। जोन काम कफरनहुम नगर मा किरीसेस, ओला अपरो देस मा कर। ");
INSERT INTO pwr_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","अना वोना कहीस मि तुमी लक खरो कव्हसू, कोनी खरो भविस्यवक्ता अपरो देस मा मान-सम्मान नही पावासे। ");
INSERT INTO pwr_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","अना मी तुमी ला खरो कव्हसू, की एलिय्याह को दिवस मा जबा साढ़े तीन साल तकन बादल बन्द रहीसेस, यहान तकन क सारो देस मा मोठयो गिरहानी पडयो, त इसरायल मा लगत बेवा होतिन। ");
INSERT INTO pwr_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","पर एलिय्याह उनमा लक कोनी को जवर नही धाड़यो गयो होतो। उ एकच सैदा को सारपत को एक बेवा को जवर धाड़ो गयो होतो। ");
INSERT INTO pwr_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","अखीन एलिसा भविस्यवक्ता को बेरा इसरायल म गजब सो कोढी होतिन, पर नामान सिरयानी ला छोड़ उनमा लक, कोनी ला साजरो नही करीस। ");
INSERT INTO pwr_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","यो गोस्टी ला आयक के, जेतरा लोग गीन सभाघर मा होतिन, सबच “लाल-पिवरो” भयी गईन। ");
INSERT INTO pwr_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","अना उठके ओला नगर लक बाहेर हेड़ीन, अना जोन पहाड मा उन को नगर बसो से, ओको वरता मा ले चलिन, की ओला वहान लक खाल्या ढकल दे। ");
INSERT INTO pwr_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","पर उ उनको बिचमा लक, हिटके चली गयो। ");
INSERT INTO pwr_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","मग उ गलील छेतर को, कफरनहुम नगर मा गयो, अना पवीतर दिवस मा लोग गीन ला, सिक्सा देवन लग्यो। ");
INSERT INTO pwr_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","उनना वोको सिक्सा ले चकित भई गईन। काहेका उ गोस्टी अधिकार सकट होत्यो। ");
INSERT INTO pwr_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","सभाघर मा, एक मानूस होतो, जोन एक असुध्द भुत-पलित झोमो होतो। ओना चिल्लायके कव्हयो। ");
INSERT INTO pwr_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","ओ यीसु, नासरी, हमरो लक तोरो काजक काम से? का तु आमीला नास करन ला आईसेस? मी तोला जानासू, तू कोन आस? तु परमेस्वर को पवीतर मानूस आस। ");
INSERT INTO pwr_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","यीसु न वोला डटकार के हुकूम देइस, उघा-मूघा रव्ह अना वोको लक हीट जाय, तब भूत वोला बीच मा पटककर बिना हानि पहुचाए, हीट गयो। ");
INSERT INTO pwr_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","योच लाइ सबा ला, अचंभा भयो, अना वय आपस मा बोलन लगीन। ये कसो ताकत अना हक से, यो भूत ला हुकूम देवासे, अना वा हिट जासे। ");
INSERT INTO pwr_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","तबा यीसु की यो गोस्टी अगल-बगल जघा मा होवन लगी। ");
INSERT INTO pwr_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","उ सभाघर लक उभो होयके, समौन के घर मा गईस। अखीन समौन की सास ला गजब बुखार होतो। अना उनना वोको लाय वोको लक बिनती करीन। ");
INSERT INTO pwr_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","तबा यीसु ना ओको जवर उभो, होयके, बुखार ला हुकूम देयके डाटीस, अना बुखार उतर गयो। अना उ एकदम उठके उनको सेवा करन लग्यो। ");
INSERT INTO pwr_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","दिवस बुड़तो बेरा मा, जोन-जोन को घर मा बिमार होतिन उनना वोको जवर आनीन, अना उन सबपर हात ठेवके सबला साजरो करीस। ");
INSERT INTO pwr_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","भूत बेमियात-बेमियात कव्हन लगीन, तु परमेस्वर को टूरा आस, अना हीट गइन, पर यीसु उनला डाटके नही बोलन को हुकूम देइस। काहेका भूत जानत होतिन का यो मसीह सूटकारा देवनवारा सेत। ");
INSERT INTO pwr_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","यीसु पहट को बेरा घर लक हिटके, अना एकांत जघा मा गयो। लोग वोला ढुढ़त-ढाढ़त ओको जवर आइन। अखीन बिनती करके कव्हन लगीन, तु हमि ला सोड़के नोको जास। ");
INSERT INTO pwr_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","पर वोना उनलक कव्हयो, मोला अखीन देस मा जावनो से, अना परमेस्वर को साजरो बारता, आयकानो जरुरी से, काहेका मोला योच काजी धाड़ो गयो से। ");
INSERT INTO pwr_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","अना उ गलील छेतर यहुदिया को सब, सभाघर मा, साजरा बारता सांगन लगयो। ");
INSERT INTO pwr_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","जनता जबा, परमेस्वर को गोस्टी आयकन को लाई, सबा जमा होय गईन। तबा यीसु गनेसरत झील को कीनार मा, उभो होत्यो। ");
INSERT INTO pwr_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","वोना झील को किनार मा, दुई नाव होतो, अखीन ढीमर जाल धोवत होतीन। ");
INSERT INTO pwr_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","वोना मा लक एक नाव, समोन को होतो। नाव मा यीसु बस गयो, अखीन समोन ला जघा लक जरा हटान ला, कव्हयो, अखीन यीसु सिक्सा देवन लगयो। ");
INSERT INTO pwr_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","जबा सिक्सा देके ना भई गयो, तबा यीसु ना समोन ला कव्हयो, गहरो मा नाव लेचल, अखीन अपरो जाल डाख। ");
INSERT INTO pwr_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","समोन ना कव्हयो, हे मालीक, हमी रात भर मेहनत करीसेजन, अखीन काही “हात नही लगयो” तोरो कव्हनो को सनुसार, मी जाल डाखासु। ");
INSERT INTO pwr_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","जबा वोना जाल डाखीस, तबा गजब मसरी जाल मा फस गईन, अखीन जाल फाटन लगी। ");
INSERT INTO pwr_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","तबा समोन आपरो संगीइन ला, हाकलिस, अखीन सबा आय केन, जाल हेड़न लगीन, नाव मसरी लक एतरो भर गयो, का नाव बुड़न लगी। ");
INSERT INTO pwr_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","असो चमत्कार चोवकेना, समोन यीसु को पाय मा पड़ गयो। अखीन वोला कहीस, हे मालीक मोरो जवर लक जाय, काहे का मी पापी मानूस सेव। ");
INSERT INTO pwr_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","काहेकि एतरो मसरी ला समट लेवन को कारन ओला अना ओको संगीगिन ला अचंभा भयो। ");
INSERT INTO pwr_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","वहान जबदी को टूरा याकूब, अखीन योहन भी होत्यो। तब जोन समोन को संगी होतिन, अचंभा करन लगीन, तबा यीसु, समोन लक कहीस, भेव नोको करो अबा, लक तू मानूस ला, परमेस्वर को राज मा आनजोस। ");
INSERT INTO pwr_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","अना उनना नाव ला किनारे जघा मा, आनीन अना सबा काही ला सोड़के वोको मंघा गईन। ");
INSERT INTO pwr_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","जबा उ कोनी नगर मा गयो होत्यो, ता वहान एक कोढी मानूस आयो। अना यीसु को पायमा, तोन्ड को बल पड़के ना बिनती करन लगयो, हे पिरभू! यदि तु चाव्हजोस, ता मोला साजरो कर सकासेस। ");
INSERT INTO pwr_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","वोना हात छिवके कहीस, मी चाव्हसू, तू साजरो भय जास, वोच बेरा वोको कोढ साजरो भय गयो। ");
INSERT INTO pwr_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","यीसु ना वोला हुकूम दियो, यो गोस्टी तू कोनीला नोको सांगजोस, पर आपरो आप ला मुखिया याजक ला दिसाजोस, अना जोन चढावा चढ़ावन ला मोसे गुरूजी ना सांगिसेस, उ भेंट चढाजोस, तबा लोक गीन ला गवाही भई जाहे, का तू साजरो भय गइसेस। ");
INSERT INTO pwr_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","मंग यीसु की गोस्टी गजब फैलत गई, भीड़ वोकी गोस्टी आयकन लाई, अना अपरी बीमारि लक साजरो होवन लाई, जमा भईन। ");
INSERT INTO pwr_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","पर यीसु उन लक बेगरो होयके जगंल मा जायकेना, पिराथना करन लगियो। ");
INSERT INTO pwr_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","एक रोज यीसु, सिक्सा दे रहयो होतो। मोसे को नियम को गुरू अखीन मुखिया याजकगिन, वोको कठा बस्या होतिन। वय गलील, अना यहुदिया छेतर को हर, एक गाँव लक येरुसलेम नगर मा आयो होतिन। रोगिन ला साजरो करन को लाय, पिरभू को ताकत यीसु को संग होत्यो। ");
INSERT INTO pwr_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","वोच बेरा काही लोग गीन खाट मा एक लकवा को रोगि ला आनीन। वय वोला भीतर ली जायके, यीसु को पूढा राखन चाव्हत होतिन। ");
INSERT INTO pwr_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","पर गरदी को कारन लक, वोला भीतर नही आन सकिन, ता वय सपरी मा चघ गईन। अना सड्डन कापके, रोगिला जहान यीसु बस्यो होतो, वहान पूढा मा खाट ला, खाल्या उतार देइन। ");
INSERT INTO pwr_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","उनको भरोसा ला चोवके, यीसु कव्हयो, जा भाऊ, तोरो पाप छिमा भय गयो। ");
INSERT INTO pwr_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","एको पर मोसे को नियम को गुरू लेखक, अना पुरोहित एक दुसरो ला, जवाब करन लगीन। का यो परमेस्वर को निन्दा करन वारा कोन से? परमेस्वर को सिवाय कोन, पाप छिमा कर सकासे? ");
INSERT INTO pwr_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","उनको यो जवाब जान के यीसु ना उनला जवाब दियो। तुमारो मन मा यो जवाब काहे, उभो रहयो से? ");
INSERT INTO pwr_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","सबा लक सरल का से? यो कव्हनो तोरो पाप छिमा भय गयो। का उठ चल? ");
INSERT INTO pwr_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","पर एकोलाय का तुमला मालूम भई जाये, का मानूस को टूरा ला, धरती मा पाप छिमा करन को अधिकार से। तबा उ लकवा को रोगी ला कहीस, उभो होयके आपरी खाट उचल, अना घर जाय। ");
INSERT INTO pwr_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","वोनोच बेरा उ सबको पूढा उभो भयो, अना जोन खाट मा उ झोपयो होतो, वोला उचल के परमेस्वर को बड़ाई करत-करत आपरो घर चली गयो। ");
INSERT INTO pwr_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","वय सबा चकीत भय गईन, अना परमेस्वर को भजन बड़ाई करन लगीन। अना सबा डराय के कव्हन लगीन। आज तकन अमीना असो काम नही परख पायी सेजन। ");
INSERT INTO pwr_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","मंघा उ बाहेर गयो अना उ लेवी नाव को एक जमा वसूल करन वालो ला वसूल करन को नाका पर जायके बसयो चोयो, अना उ वोला कहीस मोरो मंघा भई जाय। ");
INSERT INTO pwr_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","तबा उ सारी चिज ला सोड़के उभो भयो अना ओको मंघा भय गयो। ");
INSERT INTO pwr_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","तबा लेवी ना अपरो घर मा वोको लाय एक मोठो जेवन देईस, अना वहान पर जमा वसूल करन वालो, अखीन बेजा लोग वोको संग मा जेवन करन ला बस गईन, वहान लगत मानूस होतिन। ");
INSERT INTO pwr_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","एको पर मोसे को नियम को गुरू, अना लेखक भन्नात यीसु को चेला गीन ला कव्हन लगीन, तूमी जमा वसूल करन वालो अधिकारी अना पापी गीन को संग मा काहे जेवन करासो? ");
INSERT INTO pwr_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","यीसु ना जवाब देईस बइद साजरोगिन लाई नाहाय, लेकिन बिमार लाई जरुरी से। ");
INSERT INTO pwr_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","नेक मानूस गीन ला नही पर पापी गी ला पस्तावा करन काजी हाकलन आईसेव। ");
INSERT INTO pwr_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","उनना यीसु ला कहिन, योहन को चेला गीन बार-बार उपास राखासे। अना पिराथना मा लग्यो रव्हसे, अना मोसे को नियम को गुरू चेलागिन भी वसोच करासेत पर तोरा चेलागिन काहे जेवत रव्हासेत? ");
INSERT INTO pwr_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","तबा यीसु ना उन लक कहीस की जबा तकन बराती नवरदेव को संग मा रव्हासे, त बराति कसो उपास रव्ह सकासेत? ");
INSERT INTO pwr_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","पर वोना दिवस आवन वारा से। जबा मि इनको लक दुहुर भई जाहू उना दिवस मा वय उपास करयेत। ");
INSERT INTO pwr_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","वोना अखीन एक उदाहरन उनको लक कहीस। कोनी मानूस नयो कपरा मा जुनो कपरा को तनी नही लगाय सकासेत। काहेकि जूनो कपरा फट जाहे अखीन जुनो कपरा मा नवतो कपरा को तनी नही लगा सकासे काहेका जूनो तनी टुट जाहेत। एकोलाय नयो मेल नही खायेत। ");
INSERT INTO pwr_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","अखीन कोनी नवा अंगूर को रस जुनो चमड़ा को कुप्पा मा नही डाखत। नही तो नयो वालो अंगूर रस छागल ला फाड़के बोह जाएत अखीन छागल नास भई जाहेत। ");
INSERT INTO pwr_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","मंग नवा अंगूर को रस नवो छागल मा डाखनो खरो से। ");
INSERT INTO pwr_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","कोनी मानूस जुनो अंगूर को रस पिवके नयो नही चाव्हासे। सांगासे क जुनो च साजरो से। ");
INSERT INTO pwr_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","तबा यीसु अखीन वोको चेला गीन, पवीतर दिवस मा, एक खेत मा लक जावत होतो। आखिन वोको चेला गीन, सेंग तोडके, अना हात लक मल के, जेवत-जेवत जावत होतीन। ");
INSERT INTO pwr_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","तबा मोसे को नियम को गुरू मा, काही कव्हन लगीन, मोसे को नियम लक जोन काम पवीतर दिवस मा, करनो मनाहिसेत, तुमी वोच काम कायलाय करोसो। ");
INSERT INTO pwr_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","मंग यीसु न उनला जवाब देइस, का तुमीना यो नही बाचिसेव? दाऊद राजा अखीन वोको संगी गीनला, जबा भूख लग्यो होतो। तबा वय का करीन? ");
INSERT INTO pwr_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","वय परमेस्वर को घर मा गईन, अना भेंट की भाखर ला आन के, अपरो संगीगिन सगं जेविन, जोनला मोसे को नियम लक याजक ला सोड़के, कोनी ला जेवन करनो खरो नहात। ");
INSERT INTO pwr_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","अखीन वोना उनला सांग्यो, मानूस को टूरा पवीतर दिवस को भी पिरभू सेत। ");
INSERT INTO pwr_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","एक बेरा यीसु, पवीतर दिवस सभाघर मा जायके, सिक्सा देवन लगयो। अना वहान एक मानूस होतो, जेनको उज्जो हात सूकयो होतो। ");
INSERT INTO pwr_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","मोसे को नियम को गुरू आना धरमगुरू, एना गोस्टी को तक्का मा होतीन, की अदी यीसु पवीतर दिवस मा साजरो करासे, ता वय ओको पर दोस लगाय सकसेत। ");
INSERT INTO pwr_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","यीसु उनको मन को विचार जानत होतो, येको लाय वोना सुक्को हातवालो मानूस ला कहीस, बीच मा उभो होय जाय! तब उ उठ के उभो भय गयो। ");
INSERT INTO pwr_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","यीसु ना उनला कव्हयो, मि तुमी लक पुससू मोसे को नियम लक पवीतर दिवस मा भलो करनो साजरो से का खोटो से? जान बचानो या जान ला लेवनो? ");
INSERT INTO pwr_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","तबा वोना इता-उता सबला चोवीस, अना मानूस लक कहीस, अपरो हात बढ़ाव, वोना वसोच करीस अखीन वोको हात जसो को तसोच साजरो भई गयो। ");
INSERT INTO pwr_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","वय लोग गीन गजब गुस्सा भय गईन, अना आपसी मा बिचार करन लगीन, का हमी यीसु को संग मा का करबीन? ");
INSERT INTO pwr_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","यीसु वोना दिवस मा पहाड़ी मा पिराथना करन गयो, अना परमेस्वर लक पिराथना करनो मा पूरी रात बिताइस। ");
INSERT INTO pwr_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","जबा दिवस भयो तो वोना अपरो, चेला गीनला हाकल के ओमा लक बारा चेला गीनला निवाड़ो, अखीन उनला पेरीत कहीस। ");
INSERT INTO pwr_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","अना वय यो सेत, समोन जेनको नाव, वोना पतरस राखीस। अखीन वोको भाऊ अन्दिरयास, अना याकूब, अना योहन, अना फिलिप्पुस, आना बरतुल्मै। ");
INSERT INTO pwr_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","अना मत्ती, अना थोमा, आना हलफई को टूरा याकूब अना सिमोन ला जोन धरमोत्साही कहलावासेत, ");
INSERT INTO pwr_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","याकूब को टूरा यहूदा अना युदस इस्करियोति ला जोन बिन भरोसावालो होतो, जेना यीसु ला धरवायो भी होतियो। ");
INSERT INTO pwr_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","तबा यीसु उनको संगा मा, खाल्या आयके, बर्रा मा उभो भयो। अना वोको चेलागीन, अना जनता को गरदि, सप्पा यहुदिया छेतर, येरुसलेम नगर, आना सूर अना सैदा, सागर को जवर लक लगत सा लोक, ");
INSERT INTO pwr_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","जसो की वोको आयकन वारा, आपरी बीमारी लक, साजरो होवन लाय, वोको कठा आइन। वय भुत-पलित लक भुकतन वारा, लोकगीन ला साजरो करत होतो। ");
INSERT INTO pwr_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","सबा लोकगीन यीसुला छिवन को कोसीस करत होतिन, काहेका वोको लक ताकत हिटके ना, सबला साजरो करत होतो। ");
INSERT INTO pwr_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","यीसु ना आपरो चेला गीन, को कना चोवयो, अना यो कहीस, “धन्य सेव तुमी जो गरिब सेव काहेका, परमेस्वर को राज तुमरोच सेत।” ");
INSERT INTO pwr_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","धन्य सेव तुम्ही जोन भुखो सेव, काहेका तुमी अघाय जाहो। धन्य सेव तुमी, अबा रोवसो काहेका तुमला हसनो पड़हेत। ");
INSERT INTO pwr_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","धन्य सेव तुमी जबा मानूस को टूरा को कारन लक लोक तुमरो लक बुराई करे, अना तुम ला हेड देहेत, आना तुमरो निंदा करते, अखीन तुमरो नाव ला बुरो जानके काप देहेत। ");
INSERT INTO pwr_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","वोच दिवस खुसी होवने, अखीन खुसहाली मनाने काहेका, सरग मा मोठो फर सेत, उनको आजा पुरखा भविस्यवक्ता गीनको संग, असोच करयो सेत। ");
INSERT INTO pwr_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","अखीन हाय तुमरो पर जोकी धनवान सेव, येको लाय तुमी आपरो सान्ती पाय गयो सेव। ");
INSERT INTO pwr_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","धिक्कार सेत “तुमरो पर, अता अघाय सेव, काहेका तुम, ला भुखो रव्हनो पडे़त।” धिक्कार सेत तुमला, जोन अबा हासोसेव काहेका, तुमला रोवनो अखीन दुख मनानो पड़हेत। ");
INSERT INTO pwr_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","धिक्कार से जबा मानूस तुमला भला कहेत, काहेकि उनको बाप-आजा ना, भी खोटो भविस्यवक्ता गीनको सँगा असोच बरताव करयो होतीन। ");
INSERT INTO pwr_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","पर मि तुमी आयकन वारा गिनला कहुँसू आपरो बैरी गीन लक माया राखो, जोन तुमरो लक बैर राखासे, उनको भलाई करो। ");
INSERT INTO pwr_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","तुम ला जोन सराप देवासे उनला आसीस देव। जो तुमरो बेईज्जति करासे, उनको लाय पिराथना करो। ");
INSERT INTO pwr_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","अना तोरो एक गाल मा झापड़ मारासे तबा दुसरो गाल ला भि देदे। जोन तोरी पचिया ला हिसकवासे वोला झंगा भी देदे। ");
INSERT INTO pwr_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","जोन कोनी तोरो लक मांगासे, वोला देवने, अखीन जो चिज ला हिसकासे वोको लक नोको मागंने। ");
INSERT INTO pwr_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","जसो तुमी चाव्हासेव का लोग गीन तुमरो संग करेत, तुमी भि उनको संग मा वसोच करो। ");
INSERT INTO pwr_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","अखीन तुमी आपरो चाव्हन वालो को संग मा माया राखासेव, ओमा का बड़ाई से? काहे की पापी गीन भी आपरो चाव्हन वालो को संग मा असोच करासे। ");
INSERT INTO pwr_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","अखीन तुमी आपरो भलो करन वालो संग मा, भलो करासो, असो मा तुमरो का बड़ाई से? काहे की पापी भी असोच करासे। ");
INSERT INTO pwr_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","जोन लक मिलन को भरोसा ठेवा सो उनला उधार देवासो, तो तुमरो काजक बड़ाई से? काहेकी पापी भी सबला, उधारी देव से। क मंग वोतरोच पाय सके। ");
INSERT INTO pwr_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","पर मिले न नोको मिले, पर माँगन वालो ला उधारी देव, यो तुमरो लाय मोठो फर होयेत। अना तुम्ही परमेस्वर को, टूरा-टूरी कहलाने, काहे की जोन परमेस्वर ला नही मानासे, अखीन बुरो भी सेत, ओको पर भी, परमेस्वर भलो सेत। अना आपरो सतरु लक, माया करो। ");
INSERT INTO pwr_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","जसो परमेस्वर दयालू से, वसोच तुमी दयालु बनो। ");
INSERT INTO pwr_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","तुम्हि न्याय नोको करो अना “नोको बोट उठाव, नही तो तुमरो पर भी उठायो जाहेत।” छिमा देदो, तो तुमला भी छिमा कर दियो जाहेत। ");
INSERT INTO pwr_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","देवो तो तुमला भी दियो जाहेत, लोकगीन ठुस-ठुस के गजब, तुमरो आचर मा डाखेत। काहेकि जोन नाप लक तुम नापिसेव, वोच लक तुमरो लाय नापयो जाहेत। ");
INSERT INTO pwr_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","मंग वोना उनला यो हाना डाखिस, “का अँधरा-अँधरा ला रस्ता चोवाय सकासे? दुई खोदरा मा पड़ जाहेत।” ");
INSERT INTO pwr_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","का चेला आपरो गुरूले मोठो होयेत, नही, आपरो गुरू को जसो भई जाहेत योच लगत से। ");
INSERT INTO pwr_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","तु आपरो भाऊ को डोरा मा तिनका, काय लइ चोवासेस, पयले आपरो डोरा मा को लठ्ठा नही चोवसे। ");
INSERT INTO pwr_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","जबा तोला आपरो डोरा को, लठ्ठा नही चोवासे, तबा आपरो भाऊ ला कसो कह सकसे? अगा भाउ, रव्हजोस, तोरो डोराको तिनका हेड़देसू। अगा कपटी पयले, आपरो डोरा लक लट्टा हेड, तबा, आपरो भाऊ को डोरा मा लक, तिनका हेड़न काजी, साजरो लक चोवजोस। ");
INSERT INTO pwr_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","असो साजरो झाड़ नोहोय जेव निकम्मो फर आनेत, अखीन असो नोहोय का निकम्मा झाड़ सजरो फर आनेत। ");
INSERT INTO pwr_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","अना सप्पा झाड़ अपरो फर लक चिन्हो जासेत काहेका लोग गीन झाड़ी मा लक अँजीर नही तोड़त अखीन कांटा को झाड़ लक अंगूर नही तोड़ासेत। ");
INSERT INTO pwr_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","साजरो मानूस अपरो मन को साजरा पेटखोली लक सजरो गोस्टी हेड़ासे अना बुरो मानूस अपरो आतमा को पेटखोली लक बुरी- बुरी गोस्टी हेड़ासेस काय की जेनो आतमा मा ठुसीसे वाच वोको टोंड पर अवासे। ");
INSERT INTO pwr_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","जबा तुमी मोरो कव्हनो नही मानो ता कायलाय मोला हे पिरभू, हे पिरभू! कव्हसो ");
INSERT INTO pwr_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","जोन मोरो जवर आवासे अखीन मोरी गोस्टी आयकासे वोला मी ओरखूसु अना मी तुमला सांगसू का उ कोन को जसो से। ");
INSERT INTO pwr_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","उ वोनो मानूस को जसो से जोन घर बनावतो बेरा मा धरती ला खोदकर गहेरी करके ना वोना चट्टान मा पाया डाकीस अखीन जबा पूरा को धार वोना घर मा लगी अना वोनो घर ला नही हलाय सकीस काहेकी उ घर पक्को बनयो होतो। ");
INSERT INTO pwr_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","पर जोन आयक के नही मानसे उ मानूस वोको जसो से जोन चट्टान मा पाया खोदन को जघा जमीन मा बिना पाया को घर बनावासे अना जबा पूर आवासे, त वोको घर नास भय जासे। ");
INSERT INTO pwr_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","जबा उ लोग गीन ला, गजब सी गोस्टी सांग चुकयो तबा कफरनहुम नगर मा आयो। ");
INSERT INTO pwr_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","वहान एक सूबेदार को, एक नौकर बिमारी लक, मरन वालो होतो। सुबेदार वोला गजब चाव्हत होत्यो। ");
INSERT INTO pwr_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","यीसु की गोस्टी ला आयक के, सुबेदार यहूदिगीन आपरा सयानो गीनला, अना कई नावी मानूस, ला यीसु को जवर, बिनती करन धाड़िन, का जायके वोको नौकर ला बचाय लेय। ");
INSERT INTO pwr_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","गुरू गीन यीसु को कठा आइन, अखीन बिनती करके कव्हन लगीन। उ सूबेदार यो काबील सेत, का वोको नौकर ला, तू साजरो कर दे। ");
INSERT INTO pwr_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","काहे का, यो सभाघर ला वोच ना बनवाइसेस। अना उ आमरो लोक गीन लक माया राखासे। ");
INSERT INTO pwr_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","यीसु उनको, संग-संग गयो, वय वोको, घर को, कठा पहुचयो होतिन, सुबेदार ना आपरो संगी गीनको जवर, यीसु को लाय यो खबर धाडीस। पिरभू दुख नोको उठावस, काहेकी, मी यो काबिल नही सेव, का तुमी मोरो छत मा आव। ");
INSERT INTO pwr_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","एको काजी मी तोरो कठा नही आईसेव, पर तू वहाँच लक हुकूम दे, अना मोरो दास साजरो भय जाहेत। ");
INSERT INTO pwr_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","मी खुदच सरकारी अधिकारी सेव। अना सिपाई मोरो हात को खाल्या सेत, अना जबा मी, एक ला कव्हसू, तु जाय, तो उ जासे अना दूसरो ला कव्हासू तू आव तो उ आवासे। अखीन अपरो दास ला कव्हासू का तु यो कर त उ करासे। ");
INSERT INTO pwr_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","यो आयक के यीसु ला अचंभा भयो, वोना आपरो मंघा आवन वालो ला कव्हयो, असो भरोसा ठेवन वालो मी, इसरायल लोक मा नही चोवीसेव। ");
INSERT INTO pwr_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","अना खबरिया, जबा घर मा आइन, तबा उ दास सजरो भय गयो होतो। ");
INSERT INTO pwr_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","काही दिवस को मंघा, यीसु नाईन नाव को नगर मा गयो। गजब जनता, अखीन चेला गीन वोको संगमा होतिन। ");
INSERT INTO pwr_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","जब वय नगर मा भीतर धसन को जघा मा गयीन, तब लोक साकोली मा एक लास बाहेर ले जावत होतीन। उ आपरो माय को एकच टूरा होतो, अना वोकी माय बेवा होती, नगर को लगत जनता वोको संग होतीन। ");
INSERT INTO pwr_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","वोला चोवके यीसु पिरभू दया लक भर गयो, अखीन वोको लक काहीस, रड़स नोको ");
INSERT INTO pwr_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","तबा वोना जवर आयके सकोली ला छिइस अखीन उचलन वारा उभो भईन। तबा वोना कव्हासे ओ जुवान तोला कव्हसू का उठ जाय, ");
INSERT INTO pwr_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","तबा मुरदा जाग के ना बस गयो, अखीन वोना वोकी माय ला सोप देइस। ");
INSERT INTO pwr_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","यो चोवके सबा डराय गईन, अउर वय, परमेस्वर को बड़ाई करके कव्हन लगीन, का हमारो बिच मा एक मोठयो भविस्यवक्ता आईसे, अखीन परमेस्वर आपरो लोक-बाग गीन पर किरपा करीसेस। ");
INSERT INTO pwr_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","अना ओको बारे मा यो गोस्टी सप्पा यहुदिया अना अगल-बगल को सब देस मा फैल गयो। ");
INSERT INTO pwr_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","योहन को चेला गीन, यो गोस्टी वोला सांगिन। ");
INSERT INTO pwr_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","तबा योहन आपरो चेला मा लक दोन ला, यीसु पिरभू को कठा, यो पूसन ला धाड़िस, का आवनवालो तू च आस? का दुसरो सेत, हमि वोको बाट चोयबीन। ");
INSERT INTO pwr_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","तबा वय लोक ओको जवर आवा सेत ता उनना कहिन योहन बप्तिस्मा देन वालो यो कव्हके पूसन ला धाड़िसेस। “का आवनवालो तू च आस, का अखीन कोनी सेत?” ");
INSERT INTO pwr_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","ओना बेरा, ओना गजब बिमार ला दया लक साजरो करीस, अँधरा गीनको डोरा उघाड़ो, अना भूत-पलीत ला भगायो। ");
INSERT INTO pwr_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","वोना उनलक कहीस, जोन काही तुम्ही ना चोवीसेव, अखीन आइकू सेव, जायके योहन लक साँगने का, अँधरा चोवा से, लंगडा हिडंसे, कोढी साजरो होवासे, बहेरा आयकासेत, मरयो हुयो जित्तो होवासे, अखीन गरिब गोर गीनला, परमेस्वर को साजरो बारता सांगासेत। ");
INSERT INTO pwr_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","अना धन्य “किस्मत वारा से” उ जोन मोरो बारे मा ठोकर ना खाय।, ");
INSERT INTO pwr_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","जबा योहन को चेला चले गइन, त यीसु योहन को बारे मा लोग गीन ला संगिस, “तुमी जंगल मा का चोवन गयो होतो? का हवा लक हिलतो, झाड़-झड़ुला ला। ");
INSERT INTO pwr_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","तुमी का चोवन गयो होतो? का नरम कपरा पहरो हुवो मानूस ला, जोन सजरा कपरा पहिरिसेस, अना सुख लक रव्हसे? उ महीमा लक राज दरबार मा रव्हसे। ");
INSERT INTO pwr_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","तबा तुमी का चोवन ला गयो होतो, का कोनी भविस्यवक्ता ला? मि तुमरो लक कव्हसु, उ भविस्यवक्ता लक मोठो सेत। ");
INSERT INTO pwr_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","यो वोच से जेनको बारे मा लिखिसे, चोव मी, आपरो दूत ला, तोरो पूढ़ा-पूढ़ा धाड़सु, जो तोरो पूढ़ा लक रस्ता सीधो करयेत। ");
INSERT INTO pwr_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","मि तुमी ला कव्हसू, जोन बायको लक जलमो से, उनमा कोनी योहन लक मोठो नहात। पर जोन परमेस्वर को राज मा, सबा लक नाहनो सेत, उ योहन लक मोठो सेत।” ");
INSERT INTO pwr_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","सबा जनता अखीन जमा लेवन वारा अधिकारी गीन, जबा यो आयकिन तो, उनना योहन को बप्तिस्मा लेवन को कारन, परमेस्वर को न्यायीपन ला खरो मान लेईन। ");
INSERT INTO pwr_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","अखीन धरमगुरू अना मोसे को नियम को गुरू ना, वोको बप्तिस्मा नही लेइन, अखीन परमेस्वर ना उनको लाय, जोन तरकिब हेड़ो होतो, वोला नापास कर देईन। ");
INSERT INTO pwr_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","यीसु ना कव्हयो, अता मी, यो जुग को लोकगीन ला, कोनी को जसो समझू, यो कोनी को समान सेत? ");
INSERT INTO pwr_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","वय वोना टूरागिन को जसो से, जो हाट मा बस्यो एक दुसरो लक हाकलके कव्हासे, अमीना तुमरो लाय बंसरी बजाया, अखीन तुमी नही नाचिसेउ, हमी दुखी भयी सेजन, अखीन तुमी नही रड़ीसेव। ");
INSERT INTO pwr_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","योहन बप्तिस्मा देवन वालो कभी जेवन नही जेवो, न कभी दारू पिविस, मंग तुमीना कव्हयो, एको मा बालजबुल से। ");
INSERT INTO pwr_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","मानूस को टूरा जेवन करतो अना पिवतो आयो सेत अना तुम्ही कव्हसो चोवो, यो मानूस कसो अघोरी सेत? यो तो, बरगन लेवन वारा पापी गिनको संगी सेत। ");
INSERT INTO pwr_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","पर परमेस्वर की अक्कल अपरो सबा परजा को लक खरो दिसाईसेस। ");
INSERT INTO pwr_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","कोनी मोसे को नियम को गुरू न बिनती करीस, की मोरो संग जेवन कर, तबा धरमगुरू को संग, ठाव मा बस्यो। ");
INSERT INTO pwr_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","नगर मा एक पापी बायको होति। वोला पता चलयो, का यीसु मोसे को नियम को गुरू को घर मा जेवन ला बसीसे, वहान वोना एक सीसी मा इतर आनिस। ");
INSERT INTO pwr_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","अखीन रड़त-रड़त यीसु को पाय को जवर उभी भई, अना अपरो आसूँ लक, ओको पाय ला धोवन लगी, अखीन अपरो चुन्दी लक पाय ला पोछन लगी। अना पाय को चुम्मा लेवन लगी, अना इतर ला मलन लगी। ");
INSERT INTO pwr_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","जोन मोसे को नियम को गुरू यीसु ला निवता देई होतिस, असो चोवके! मन च मा कव्हन लग्यो “यदि यो मानूस भविस्यवक्ता होतो तो जान लेतो का यो बायको कसी से अना काजक करासे? काहे की वातो पापी होती।” ");
INSERT INTO pwr_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","वोको मन को बिचार जान के यीसु वोला कव्हयो ओ सिमोन! मि तोला काही कव्हनो चाव्हसू। वोना जवाब देइस गुरूजि सांगो। ");
INSERT INTO pwr_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","तबा यीसु न कहीस, कोनी साउकार का दुई करजदार होतिन, एक पाँच सौ दीनार, अना दुजो पचास दीनार लेई होतिस। ");
INSERT INTO pwr_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","उनको जवर काही पटावन ला नही होतो। तो उ साउकार ना उनको करजा छिमा कर देईस। वोना दुई मा कोनी साउकार लक लगत माया करयेत। ");
INSERT INTO pwr_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","सिमोन ना उत्तर दियो, मोरो समज मा मी तय करासू वोच से, जोनला लगत दे दियो गयो से। वोना वोको लक कहीस, की तु साजरो कव्हासेस। ");
INSERT INTO pwr_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","अना वोनो बायको कन मुरकके, सिमोन ला सांगिस, का तु या बायको ला चोयोसेस, मि तोरो घर मा आयो, पर तु मोरो पाय धोवन लाई पानी नही देईस। पर या बायको, मोरो पाय ला आसूँ लक भिगोय के, अपरो चुन्दी लक पोछिसेस। ");
INSERT INTO pwr_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","तुना मोला चूमा नही देईस, पर जबा लक मि आईसेऊ, या मोरो पाय ला चुमनो नही छोड़िस। ");
INSERT INTO pwr_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","तुना डोस्का पर जैतून तेल लगावन नही देईस, पर येना मोरो पाय मा इतर मलन लगी। ");
INSERT INTO pwr_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","येको लाय मि तोला सांगसु, या बायको को लगत पाप, छिमा भई सेति। काहेका यो मोरो लक, लगत माया करासे। पर जेनको जरासो छिमा भयोसे, वा जरासो माया करासे। ");
INSERT INTO pwr_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","तबा यीसु वोना बायको ला कहीस, आव बाया जाय तोरो पाप छिमा भय गई सेति। ");
INSERT INTO pwr_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","तबा जोन, यीसु को संग जेवन लाय बसाया होतीन। वय बिचारन लगीन यो कोन से? जो पाप ला छिमा करासे। ");
INSERT INTO pwr_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","तबा यीसु न वा बायको लक कहीस, तोला तोरो बिस्वास साजरो मोक्स देइसेस, तु सान्ती लक घर जाय। ");
INSERT INTO pwr_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","योको मंघा उ नगर-नगर अना गाँव-गाँव परमेस्वर को राज को साजरो बारता साँगत होतो। ");
INSERT INTO pwr_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","अना बारा चेला भी वोका संग होत्यो, अना गजब आई-माई गीन, जोन भुत-पलित लक, अखीन बिमारी लक, साजरी भयी होतिन। अना उनको नाव यो सेत। मरियम मगदलीनी जेनको मा सात भूत होतिन। ");
INSERT INTO pwr_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","अना राजा हेरोदेस को खजांची खोजा की बायको, अना योअन्ना अना सुसन्ना अना लगत आई-माई गीन होतिन, अना यो आपरो धन-माया लक, पिरभू को सेवा करत होतिन। ");
INSERT INTO pwr_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","जबा, मोठि भीड़ ओको कठा एकठ्ठो भईन, अना नगर-नगर को लोक हुन जमा होवन लगीन, तबा वोना उदाहरन लक सांगिस। ");
INSERT INTO pwr_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","एक बीज-बोवनवालो, बीज-बोवन हिटयो। बोनी करत बेरा, काही बीज रास्ता को कठा पड़यो। अना उनला बादल को पक्सी न आयके खाय लियो। ");
INSERT INTO pwr_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","अना काही बीज चट्टान पर पड़यो अना उगयो, अखीन माटी न मिलन लक सूक गयो। ");
INSERT INTO pwr_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","काही बीज कांटा को झाड़ को बिच मा पड़यो अना झाड़ झकड़ संग-संग बढके ना ओला दबाय देईस। ");
INSERT INTO pwr_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","अना काही बीज साजरो जघा मा पड़यो अना उगके सौ गुना फर लायो। यो कहके ओना उचो आवाज लक कहीस, सबा ध्यान धरके आयको। ");
INSERT INTO pwr_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","वोको चेला गीन पुसन लगीन, यो उदाहरन को काजक मतलब से? तबा वोना सांगिस, ");
INSERT INTO pwr_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","“तुम ला परमेस्वर को राज को, छुपयो गोस्टी को समझाय दियो गयो से। पर परायो ला, उदाहरन लक आयकवायो जासे। एकोलाय का वय चोवकेना बिना चोवो जसो भयी जाय, अखीन आयकनो पर भी नही समजेत।” ");
INSERT INTO pwr_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","उदाहरन को मतलब असो से, बीज तो परमेस्वर को गोस्टी से। ");
INSERT INTO pwr_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","“रास्ता को किनार का बीज वय सेती। जोना आयकीस, तबा बालजबूल उनको मन लक, गोस्टी उचल ले जासे। कही असो नाहती की भरोसा राखेत, अना साजरो बिस्वास लक सूटकारा मिल जाये। ");
INSERT INTO pwr_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","चट्टान मा पड़ियो बीज वय सेत, जोन परमेस्वर को गोस्टी ला खुसी-खुसी लक आयकासेव सेत, अना मानन लगासे। पर उथलो भरोसा राखासे, काहेका उनमा जड़ नही रव्हासे, अखीन परिक्सा को बेरा मा सब भरोसा खतम होय जासे। ");
INSERT INTO pwr_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","जोन बीज कांटा को झाड़ पर पड़ासे, उ वय लोग सेत, जोन परमेस्वर को गोस्टी ला, आयकन पर, पयले धन-माया की चिंता, रोज को जिंदगी को सुक, लोभ-माया को कारन, उन मा फर नही लगासे। ");
INSERT INTO pwr_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","साजरी जघा पर पड़ियो हुयो बीज, वय लोक होत्यो, जोन गोस्टी ला आयक केना, वोना बिचारीस, अखीन साजरो मन लक, अपनावसेत, अना धिरज लक फर आनासे।” ");
INSERT INTO pwr_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","दियो पेटावनो को मंघा, बरतन लक नही ढाकासे, अखीन ना खाट को खाल्या ठेवासे। मंघ फूल मा राखसेत, का भीतर अवन वालो ला, उजाड़ो दिसेत। ");
INSERT INTO pwr_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","काही, लुको नहात, जोन उघाड़ो ना जाहेत, अखीन उ सबला दिसेत, अखीन काही लुकयो नहात, जोन सबला ना दिसेत। ");
INSERT INTO pwr_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","“एको लाय होसियार रव्हो, का तुमी काजक आयकसेव? काहेका जेनको जवर सेत, वोला अखीन दियो जाहेत। अखीन जेनको जवर नहात, पर जोन सेत, उ सप्पा ले लियो जाहेत, जोनला वो आपरो समजासे।” ");
INSERT INTO pwr_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","वोको भाऊ, अखीन माय, वोको जवर आइन। पर भिड को कारन लक, यीसु लक, नही मिल सकिन। ");
INSERT INTO pwr_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","कोनी ना सांगिस का, “तोरो माय अखीन भाऊ, बाहेर उभो सेत, वय भेंट करन आइसेस।” ");
INSERT INTO pwr_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","वोना फट ने जवाब देईस, मोरी माय अखीन भाऊ वोच से, जोन परमेस्वर को गोस्टी आयका सेत, अखीन मानासेत। ");
INSERT INTO pwr_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","अना एक दिवस यीसु, अखीन वोको चेला, डोंगा पर चढिन। वोना अपरो चेला लक कहीस, “आव हमी झिल को वोना गन जाबिन।” अना वोना नाव ला खोल देईन। ");
INSERT INTO pwr_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","जबा नाव चलन लगी, तो यीसु झोप गयो, तबा झिल मा आँधड़ चली, अना डोंगा पानी मा, बुड़न लगयो। अना वय संकट मा पड़ गेईन। ");
INSERT INTO pwr_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","तबा उनना, जवर आयके वोला जगाईन, अना कव्हयो, मालीक-मालीक हमी नास भई जाबिन, तबा वोना, आँधड़ अखीन पानी ला डटकार के हुकूम देइस, अखीन आँधड़ थम गयो, अना उनको मन मा, सुकुन आयो। ");
INSERT INTO pwr_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","तबा वोना उनला कहीस, “कसो, तुमरो भरोसा कहांन से?” अना वय डराय गयो होतीन, अना चकित होय के कव्हन लगीन “उ कोन आय जोकी हुकूम पानी अना आँधड़ भी मान सेती।” ");
INSERT INTO pwr_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","अना वय गिरोसेनियो नाव को देस मा पहुचीन। जोन ओनागन गलील परदेस को पुढा मा से। ");
INSERT INTO pwr_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","जबा व डोंगा लक खालया मा उतरियो, तो उ नगर मा एक मानूस होतो। जेनको मा भूत-पलित धसी होतीन। उ बिना कपरा को रव्हत होतो, न तो घर मा रव्हत होतो, उ मरघट्टी को जघा मा रहोत होत्यो। ");
INSERT INTO pwr_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","व यीसु ला चोवयो, तो चिलवन लग्यो, अना ओको पुढा मा, पड़यो, अना उच्चो आवाज लक कव्हन लग्यो। “ओ मोठो, परमेस्वर को टूरा यीसु! मोला तोरो लक का काम से? तोरो लक बिनती करासू, मोला दुख नोको दे।” ");
INSERT INTO pwr_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","काहेका उ भूत-पलित ला हिटन को हुकूम देवत होतो। व ओला घड़ी-घड़ी झूमत होतो अना ओला साँकल अना बेड़ी मा बांधत होतिन, पर उ बंधन ला पटा-पट तोड़ देत होतो। अना जंगल मा भागतो फिरतो रहोत होतो। ");
INSERT INTO pwr_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","यीसु न ओको लक पुसीस की, तोरो काजक नाव से। वोना सांगिस, मोरो नाव सार संगाड़ से, काहेका वोको भितर मा, लगत सारी बुरो आतमा होती। ");
INSERT INTO pwr_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","वोना बिनती करीस हमला नरक मा जावन को हुकूम नोको देव। ");
INSERT INTO pwr_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","वहान, पहाड मा खालमानी को एक मोठो करप चर रहयो होतो। एको लाय उनना, ओको लक बिनती करीन, हमला उनमा धसन देव। यीसु ना कहीस जाय! ");
INSERT INTO pwr_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","तबा भूत-पलित ओनो मानूस लक हिटके, खालमानी मा धस गईन। अना हेड जोर लक झपटयो, अना झिल मा जायके बुड़ गयीन, अना मर गयीन। ");
INSERT INTO pwr_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","तबा चरानवारा गीन, असो कान्ड चोय के पारय गेईन। अना नगर मा जाय के सबला सांगिन। ");
INSERT INTO pwr_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","लोग यो चोवन, लाई यीसु को कठा आइन, अखीन उ भुत वालो मानूस ला चोवके ना भेव मा पड़ गईन। काहेका उ मानूस कपरा घाल केना सान्त यीसु को कठा बस्यो होतो। ");
INSERT INTO pwr_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","अना चोवनवारा गीनना उनला सांगीन का भुत लक झोमयो हुयो मानूस कसो रिति लक साजरो भयी से। ");
INSERT INTO pwr_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","तबा गिरोसेनियो छेतर को आखा-पाखा को लोकगीन, बिनती करन लगीन, तुम्ही यहान लक चली जाव, काहे का लोग गजब भेव मा पड गई होतीन। यीसु नाव मा चघ के ना लवट गयो। ");
INSERT INTO pwr_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","जोन मानूस लक बुरो आतमा हिटी होती। उ यीसु लक बिनती करके कव्हन लग्यो, मोला आपरो सँगा रव्हन दे। तबा ");
INSERT INTO pwr_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","यीसु ना कव्हयो, “का तु घर जाय, अखीन लोकगीन ला सांगजो, का परमेस्वर ना तोरो लाय, काजक-काजक काम करीसेस।” उ चले गयो अखीन सबा, नगर-नगर मा, यो गोस्टी ला परचार करन लग्यो। का यीसु ना मोरो लाय कसो मोठो काम करयो से। ");
INSERT INTO pwr_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","जबा यीसु लवट गयो, तबा लोग गीन वोको मान करीन, काहे का सबा वोको बाट जोहत होतीन। ");
INSERT INTO pwr_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","वोना बेरा सभाघर मा, याईर नाव को एक मुखिया आयो। अखीन यीसु को पाव पड़के, ना बिनती करन लग्यो, का मोरो घर चल, ");
INSERT INTO pwr_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","काहेका वोकी एकच टूरी होती। वोको, उमर 12 साल होति, व आखीर सांस लेवत होति। यीसु वोको संग जावन लग्यो। रस्ता मा भीड़, यीसु ला, दबान लगीन। ");
INSERT INTO pwr_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","एक बायको बारा बरस लक लाल धोवा को बीमारी लक, परेसान होती, वा साजरो होवन को लायक भी नहोती। वा आपरो सबा धन, बैद को जवर, इलाज मा लगा देयि होती, पर उ साजरो नही भई। ");
INSERT INTO pwr_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","वा आयके ना, कपरा को छोर ला, छिव लेयी, अखीन वोको रकत बहनो, बंद भई गई। ");
INSERT INTO pwr_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","तबा यीसु ना कव्हयो, “मोला कोन छिवी से?” सबको मना करन को मघा, पतरस ना कव्हयो, “गुरूजी, तुम्ही भीड़ लक घिरोसव, अखीन भीड़ तोरो पर पड़ासे।” ");
INSERT INTO pwr_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","यीसु ना कव्हयो, “कोनी ना जरुर मोला छिवी सेस, काहे का मी ना समज गई सेव, का मोरो लक, साजरो होवन वालो ताकत हिटी से।” ");
INSERT INTO pwr_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","तबा वा बायको ना चोयी, का मी लुक नही सकसू, तबा थरथारान लगी, यीसु को पाय पड़के ना, सब लोकगीन को पूढा सांगन लगी, का काहे छिवीसेव, अखीन उ कसो साजरो भई गई। ");
INSERT INTO pwr_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","यीसु ना वोला कव्हयो “बेटी, तोरो भरोसा ना तोला साजरो करीसेस। तू सान्ती लक घर जाय।” ");
INSERT INTO pwr_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","यीसु साँगत होत्यो, तबच उ सभाघर को मुखिया लक एक मानूस आयो। अखीन कव्हयो, “तोरी टूरी मर गई, तु गुरूजी ला सांग दे।” ");
INSERT INTO pwr_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","यो आयक के, यीसु न कव्हयो, “भेव नोको खाय, भरोसा राख, उ साजरो भई जाहेती।” ");
INSERT INTO pwr_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","जब यीसु याईर को घर मा, पहुचयो। तो वोना पतरस योहन अना याकूब, अखीन टूरी को माय-बाबूजी को सीवा कोनी ला भीतर नही, आवन दियो। ");
INSERT INTO pwr_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","सब रड़त होतीन, यीसु ना कहेयो “नोको रडो, यो मरी नहाति, पर जप मा से।” ");
INSERT INTO pwr_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","लोकगीन यीसु को मजाक उडावन लगीन, काहेका, सब जानत होतीन। का वा मर गईसे। ");
INSERT INTO pwr_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","यीसु ना टूरी को हाथ धरके ना कव्हयो, टूरी उठ ओ। ");
INSERT INTO pwr_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","तबा टूरी को जीव लवट के आई गई, अखीन उ जाग के ना बस गई। यीसु न कव्हयो, एला काही जेवन देव। ");
INSERT INTO pwr_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","वाको माय-बाबूजी चकीत भई गईन। पर यीसु न कव्हयो, यो चरचा कोनीला नोको सागजोस। ");
INSERT INTO pwr_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","तबा यीसु ना, 12 चेला गिनला हाकलिस। अना उनला, भुत-पलित, बुरो आतमा हेड़न अना बिमारी साजरो करन की ताकत, अखीन अधिकार देईस। ");
INSERT INTO pwr_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","अना उनला, परमेस्वर को राज को परचार करन लाई, अखीन बिमार गीनला, साजरो करन लाई, धाडीस। ");
INSERT INTO pwr_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","वोना उनको लक कहीस, का रास्ता लाई काही नोको आनने रुपिया-पैसा, लाठी-वाठी, खानो-पिनो को समान, कुरता-पचिया झोला-झंकड़ नोको राखने। ");
INSERT INTO pwr_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","जेनो घर मा, तुमी उतरनो, वहान रव्हने, अखीन वहान लक, सार होवने। ");
INSERT INTO pwr_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","जोन कोनी तुम्हिला नही पुसेत, उ नगर लक हिटके ना, आपरो पाय को बारू ला झड़ाय लेने जोन उनको विरोध मा, गवाही होयेत। ");
INSERT INTO pwr_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","अखीन वोना हिटके ना, गांव-गांव मा परमेस्वर को साजरो बारता, आयकावत होतिन। अखीन गजब लोग गिनला, हिन्ड-हिन्ड के, साजरो करन लगीन। ");
INSERT INTO pwr_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","तबा चौथाई देस को राजा हेरोदेस, यो सबा ला आयक के, भेव खाय गयो। अखीन सांगन लग्यो, योहन मरयो हुयो जित्तो, भई से। ");
INSERT INTO pwr_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","अना काही कव्हन लग्यो, का भविस्यवक्ता एलिय्याह, अखीन काही सांगत होतिन, का कोनी जुनो भविस्यवक्ता, जिव गईसे। ");
INSERT INTO pwr_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","तबा हेरोदेस राजा ने कहीस, योहन जोनको मिना, डोस्का कपवायो डाखिसेव, यो कोन आय? जेनको बारे मा, असो गोस्टी आयकुसु, अना उ यीसु ला देखनो की मन कर लेइस। ");
INSERT INTO pwr_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","मंग पेरीतगीन लवट के, जोन काही करयो होतो, उ यीसु ला सांगीन, अना उ उनला, आपरो संग, बैतसेदा नाव को नगर मा ले गईस। ");
INSERT INTO pwr_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","यो जान के, भिड़ ओको माघा भई गई, अना उ खुसी लक ओको संग मा मिलयो। अखीन उन को लक, परमेस्वर को राज गोस्टी करन लगयो। अखीन जोन लोग गीन साजरो होवनो चाव्हत होतिन, उनला साजरो करीस। ");
INSERT INTO pwr_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","जबा दिवस बुड़ता बेरा भयो, तबा 12 पेरीतगीन ना, आयके वोको लक कहिन, भीड़ ला सार कर दे, वय चारो कन का गांव, अना बस्ती मा जाय के, रव्हन को इन्तेजाम करयेत, काहे की हमि, एक सुनसान जघा मा, सेजन। ");
INSERT INTO pwr_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","ओना उनको लक कहीस, तुमी उनला जेवन ला देव, उनना कहिन, हमरो जवर पांच भाकर अना दूई मसरी, ला सोड़ अखीन कहि नहात। का तू कव्हसे, की हमि जायके, सबा लोकगीन लाय, जेवन आनबीन? ");
INSERT INTO pwr_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","वहान पाँच हजार मानूस होतिन। मघं उ आपरो चेला गीनला, कहीस, उन ला पचास-पचास की पंगत मा बसाय देव। ");
INSERT INTO pwr_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","उन ना असोच करीन, सबला बसाय देईन। ");
INSERT INTO pwr_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","तबा वोना पांच भाकर अना दोई मसरी लेईस, अउर सरग को कन चोवके ना, धन्य वाद कहीस, अउर तोड़-तोड़ के चेला गीनला देईस, क वय लोग गीन ला परसे। ");
INSERT INTO pwr_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","तबा सारा लोग खायकर खुसी भईन, अना चेला गीन ना, बचया हुयो टुकड़ा गीन ला, 12 डलीया मा उठाईन। ");
INSERT INTO pwr_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","जबा उ एकांत मा, पिराथना कर रहयो होतो। अखीन चेला वोको संग मा होतीन। ता वोना उनको लक पुसीस, लोकगीन मोला का कव्हसे? ");
INSERT INTO pwr_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","तबा चेलागिन जवाब देईन, योहन बप्तिस्मा देवन वालो, अना कोनी-कोनी, एलिय्याह अखीन गियान की सजरी-सजरी गोस्टी सांगन वालो, जुनो भविस्यवक्ता जिव गई से। ");
INSERT INTO pwr_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","वोना वोको लक पुसिस, अखीन तुमी मोला, का कसो? पतरस ना जवाब देईस, तू परमेस्वर का मसीह आस। ");
INSERT INTO pwr_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","यीसु ना अपरो चेलागिन ला, कड़ाई लक हुकूम देइस, का यो गोस्टी कोनी ला, नोको सांगने। ");
INSERT INTO pwr_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","यीसु ना सांग्यो मानूस को टूरा लाय लगत दुख उठानो जरूरी से, अखीन सियानो अना मुखिया याजक अना मोसे को नियम को गूरू लक उ नकारो जाय, अना उ तिसरो दिवस मरयो हुयो लक जित्तो होहेत। ");
INSERT INTO pwr_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","तबा यीसु ना सबा लक कव्हयो, जो मोरो मघ आवन चाव्हासे, आपरो आप ला नकारे, रोज कूरूस उठायके मोरो मघा आहेत। ");
INSERT INTO pwr_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","काहे का, जोन आपरो जान बचावनो चाव्हासे, उ वोला खो देहेत, अना जोन मोरो कारन आपरो जान खो देहेत, वोच वोला पाहेत। ");
INSERT INTO pwr_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","वोना मानूस ला, का फायदा? जोन खुदला नास कर दे, अखीन जगत को धन पाय जाय। ");
INSERT INTO pwr_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","जोन मोला अखीन, मोरो कव्हनो ला मानन लाय, लाज करयेत, मानूस को टूरा आपरो तेज को संग आहेत तो वोला सबको पुआ नकार देहत, अखीन जोन सबको पुढा वोला मान लेहेत, वो वोला परमेस्वर अखीन पवीतर सरगदूत, को पुढा मान लेहेत। ");
INSERT INTO pwr_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","मि तुम्ही लोक गीन ला, खरोखर सांगासू, यहान काही लोकगीन सेत, जबा लक परमेस्वर को राज ला नही चोव लेत, वो नही मरहेत। ");
INSERT INTO pwr_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","यो गोस्टी को हपता भर बाद मा, यीसु पतरस योहन अना याकूब ला, आपरो सगंमा, पहाड़ मा ले गयो। अना वहान परमेस्वर लक पिराथना करन लगीन। ");
INSERT INTO pwr_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","पिराथना करत-करत, यीसु को टोंड चमकन लग्यो, कपरा उजरो भय गयो। ");
INSERT INTO pwr_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","एकदम चेला गीनला, यीसु को संग, दुई मानूस गोस्टी करत चोवयो, वोना मोसे, अखीन एलिय्याह भविस्यवक्ता होत्यो। ");
INSERT INTO pwr_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","वय दुई मा लगत तेज होत्यो, उ काही येरुसलेम मा होवन वारा, घटना को बारेमा, सांगत होत्यो। ");
INSERT INTO pwr_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","पतरस अखीन वोको सगीं जपमा होतिन, मंग वय जप लक जाग गयो होतिन। ता वोना यीसु अखीन वय दुई ला तेज समेत चोईन। ");
INSERT INTO pwr_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","वय दुई, यीसु को जवर लक, बिदा हो रहयो होतो। तबा पतरस, यीसु ला कव्हयो, मालीक, कितरो साजरो होतो, का हमि तिन मान्डो गाड़बोन, एक तोरो, एक मोसे, अखीन एक एलिय्याह काजी, वोला पता नही होत्यो। क उ काजक, सांग रहि सेस? ");
INSERT INTO pwr_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","उ सांग रहयो होतो, का एक बादल न आयके, वोना पर छाय गयो, अना वय डराय गइन। ");
INSERT INTO pwr_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","बादल लक यो आवाज आयो, यो मोरो चहेतो टूरा आय अना मोरो निवाड़ो हुया से, एको आयको। ");
INSERT INTO pwr_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","आवाज आवन को मघा, यीसु एकलो चोवयो, चेलागिन यो बारे मा काही, नही सांगिन। ");
INSERT INTO pwr_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","दुसरो दिवस जबा, वय पहाड़ लक उतरीन, तबा गजब लोकगीन मिलन ला आइन। ");
INSERT INTO pwr_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","अना भिड़ मा लक, एक मानूस ना चिल्लाय के कव्हयो, हे गुरू मी तोरो लक बिनती करासू, का मोरो एकच टूरा से, वोको पर किरपा कर। ");
INSERT INTO pwr_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","वोला एक भूत धरसे, अना उ एकदम बेमियासे, आँग ऐठासे, टोन्ड मा फेसकुड़ आवासे, अखीन वो भूत वोलो कठनाई लक छोड़ासे। ");
INSERT INTO pwr_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","मि ना तोरो चेला गीन, लक बिनती करीसेव, का वोला हेड़ देव, पर कोनी नही हेड सकिन। ");
INSERT INTO pwr_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","तबा यीसु ना जवाब दियो, ओ अबिस्वासी अना केड मानूस, मि कबा तकन तुमरो संग मा रहु? वोला यहान आनो। ");
INSERT INTO pwr_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","जसो टूरा समोर मा आयो, बुरो आतमा वोला धर के ना मरोड़ दियो, पर यीसु ना वोला डटकार के वोला परान को हुकूम दियो, उ टूरा साजरो भय गयो, अखीन वोला वोको बाबूजी ला सोप देइस। ");
INSERT INTO pwr_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","सबा लोग गीन परमेस्वर कन लक यीसु को काम चोवके ना, चकित भई गईन। तब यीसु ना आपरो चेला गीन ला कह्यो ");
INSERT INTO pwr_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","तुम कान धरके ना मोरो गोस्टी ला आयको, मानूस को टूरा मानूसगिन लक धराय जान वारा सेत। ");
INSERT INTO pwr_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","पर यो गोस्टी उनला, समज मा नही आयो, काहेका परमेस्वर ना, उनको समजन को बुध्धि ला, हर लियो होतो। उनला यो बारे मा, बिनती करनलाय लाय भेव लगत होतयो। ");
INSERT INTO pwr_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","चेलागिन, आपसी मा कव्हन लगीन। आमी मा कोन मोठो सेत? ");
INSERT INTO pwr_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","यीसु ना उनको दिल को गोस्टी जान, एक लेकरा ला उभो करके, ");
INSERT INTO pwr_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","अना उन लक कव्हयो, जोन मोरो नाव लक, असो लेकरा ला आपरो समजा से, उ मोला आपरो समजा से, अना जोन कोनी मोला आपरो समजा से, परमेस्वर वोला आपरो समजा से, काहेका तुम्ही लक, जोन कोनी नान्हो सेत, वोच सबा मा मोठयो सेत। ");
INSERT INTO pwr_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","योहन यीसु को जवर आयके ना, कव्हन लग्यो, गुरूजी एक मानूस से, जो तोरो नाव लक बुरो आतमा हेड़ासे, पर उ हमरो संगी नहाय। ");
INSERT INTO pwr_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","तबा यीसु ना कहीस, वोला मना नोको करो। जोन आमरो विरोध मा नहात उ आमरो कना से। ");
INSERT INTO pwr_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","यीसु येरुसलेम नगर जावन लाय, आपरो मन मा ठान लियो, काहेका वोको वरता उचलन को, बेरा जवर, आय गयो होतो। ");
INSERT INTO pwr_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","यीसु ना आपरो पुढा सन्देसा देवन वालो ला धाडीस, समरिस्थान मा, सामरी लोक को लोकगीन रव्हत होतिन। ");
INSERT INTO pwr_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","पर उन लोकगीन ना वोला नही रोखिन, काहे की वय येरुसलेम जावत होतिन। ");
INSERT INTO pwr_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","यो चोव के वोको चेला याकूब अखीन योहन कव्हासेत, हे पिरभू तु हुकूम दे, हमि बादल लक स्तो पड़ाये के ना, गाँव ला भस्म कर डाकबो? ");
INSERT INTO pwr_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","पर यीसु ना उनला डटकार देइस अना कहीस, तुमला मालुम सेत तुमी कोनतो आतमा को सेव? काहेका मानूस को टूरा लोकगीन ला मारन नही पर बचान आइसेत। ");
INSERT INTO pwr_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","अखीन उ दुसरो गाँव मा चले गईन। ");
INSERT INTO pwr_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","रस्ता मा जावत-जावत, कोनी ना वोला सांगिस, तुम्ही जँहा-जँहा जावासो, मि संग-संग आवासू। ");
INSERT INTO pwr_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","तबा यीसु ना वोला कव्हयो, कोल्हिया को, रव्हन को ठिकनो से, बादर को पक्सी चिड़िया-चुनगुन काजी गोदा से, पर मानूस को टूरा ला डोस्का लुकान को जघा नहती। ");
INSERT INTO pwr_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","वोना दुसरो ला कहीस, मोरो मंघा आय, पर वोना जवाब दियो, हे पिरभू मोला पयले मोरो बाबूजी ला गाड़ के ना आवन दे, ");
INSERT INTO pwr_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","यीसु ना कव्हयो, मुरदा ला मुरदा गाड़न दे। पर तुम्ही जायके ना, परमेस्वर को राज को गोस्टी, सबला सांगो। ");
INSERT INTO pwr_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","दुसरो ना कव्हयो, हे पिरभू मि आपरो घर लक बिदाई लेके आवासेऊ, तबा मी तोरो मंघा आँहू ");
INSERT INTO pwr_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","यीसु ना कव्हयो, जो नांगर को मुठ मा हात धरके ना, मंघा चोवासे वो परमेस्वर को राज मा काबिल नहात। ");
INSERT INTO pwr_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","यो सबको मंघा पिरभू अखीन बहात्तर चेला गीनला निवाड़ के जोन-जोन गाँव-नगर मा जावनवालो होत्यो, उता दुई-दुई करके आपरो पूढा धाड़िस। ");
INSERT INTO pwr_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","यीसु ना उनला कहीस, पिक्को फसल गजब सेत, पर बनीहार जरासो सेत। यो काजी खेत को मालीक लक बिनती करो, का फसल कापन लाय, बनीहार धाड़हे। ");
INSERT INTO pwr_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","जावो मि तुम्ही ला बिघा गीन को बीच मा, मेढा-सेरी को बच्चा जसो धाड़ासू। ");
INSERT INTO pwr_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","तुम्ही झोला पियुसी, सेंडिल, कपरा काही नोको आनने अखीन रास्ता मा कोनी लक, नमस्कार नोको करने। ");
INSERT INTO pwr_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","जबा कोनी घरमा भितर जावो, तबा सबा लक पूढा असो सांगने, का “यो घर को कल्यान होय।” ");
INSERT INTO pwr_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","अदी कोनी कल्यान को काबिल सेत, तो वा घर मा, कल्यान रुक जाहेत, नही तो उ, तुमरो कठा लवट आहेत। ");
INSERT INTO pwr_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","वोच घर मा रव्हने, अखीन उनको कठा जो सेत, वोच जेवन करने, घर-घर नोको फिरने। काहेका बनीहार ला वोको बन्नी मिलन को, हक सेत। ");
INSERT INTO pwr_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","कोनी गावँ-नगर मा तुम्ही जावासो, आदर को सगं जोन परसा से, जेवन करने। ");
INSERT INTO pwr_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","उता को बिमार गिनला साजरो करने, अखीन उनला सांगने, “परमेस्वर को राज तुमरो कना सेत।” ");
INSERT INTO pwr_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","पर जोन गाँव-नगर मा जावासो, अखीन वहान को लोग गीन, तुमारो आदर नही करासेत, तो बजार-हाट मा जायके कव्हने, ");
INSERT INTO pwr_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","आमरो पाय मा धुल सेत, आमी झाड़ देसेजन। पर तुम्ही जान लेव, का परमेस्वर को राज, तुमरो कठा आईसे। ");
INSERT INTO pwr_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","मि तुम्ही ला सांगासु, वो दिवस लक सदोम-अमोरा नगर जसो, उ नगर मा सत्यानास आय जाहेत। ");
INSERT INTO pwr_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","यीसु कव्हयो, “खुराजिन अखीन बैतसेदा नगर ला, धिक्कार से, जोन अचंभा को काम परमेस्वर को ताकत लक, यो नगर मा भयोसे, सूर अखीन सिदोन नगर मा होतो, तो वय लोकगीन पस्तावा कर, मन बदल के, परमेस्वर को कठा, आय गईन होतिन। ");
INSERT INTO pwr_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","यो काजी, न्याय को बेरामा, सूर अना सैदा नगर को दसा, जादा खराब होहेत। ");
INSERT INTO pwr_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","अना हे कफरनहुम नगर, तू का सरग लक वरता कियो जावजोस? नही, तू खाल्या नरक लक गिराय दियो जाहेत।” ");
INSERT INTO pwr_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","जोन तुम्हारो आयक सेत, उ मोरि आयकासे, जोन तुम्हारो बेइज्जती करासे, उ मोरो बेइज्जती करासे, अखीन परमेस्वर को भी बेइज्जती करासे। ");
INSERT INTO pwr_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","सत्तर चेला गीन खुसी लक, लवट के आयके कव्हन लगीन, हे पिरभू, तोरो नाव लक बुरो आतमा भी आमरो कब्जा मा सेत। ");
INSERT INTO pwr_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","यीसु ना जवाब दियो, मी ना सैतान ला, बिजली को घाई सरग लक पड़तो, चोविसेव। ");
INSERT INTO pwr_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","मि ना सरप, मेहदल, अखीन बयरी को सारो ताकत ला, कुचलन को हक देवासू, अखी काही भी तुम्हिला, हानी नही करयेत। ");
INSERT INTO pwr_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","तरि यो काजी खुस नोको होवने, का बुरो आतमा तुमरो बस मा सेत पर एकोलक खुस होवो का तुमरो नाव सरग मा लिख्यो सेत। ");
INSERT INTO pwr_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","वोच बेरा उ पवीतर आतमा लक खुसी मा भर गयो अना कव्हसेत, “हे बाबूजी, सरग अना धरती को मालीक, मि तोरो धनवाद करासू, का तूना यो गोस्टी ला, मोसे को नियम को गुरू अखीन समजदार लक लुकाके राखिसेस। अखीन नहानो लेकरा गीन पर, उजागर करीसेस। हाँ हे बाबूजी तोला, असोच साजरो लगिसेस।” ");
INSERT INTO pwr_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","मोरो बाबूजी न मोला सबा कछु सोप देईसेस। अना कोनी नही जानासे, का टूरा कोन आय? केवल बाबूजी, अना बाबूजी, कोन सेत, कोनी नही जानासे, केवल टूरा? अखीन जोन पर टूरा उजागर करनो चाव्हासे, वोको पर उजागर करासे। ");
INSERT INTO pwr_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","तबा चेला गीन कन, मुरकके ना एकलो मा कव्हयो, “धन्य सेत तुमरो डोरा, जोन यो गोस्टी चोवासे। ");
INSERT INTO pwr_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","काहे का, मि तुम्ही लक कव्हसू, का गजब राजा भविस्यवक्ता, यो चोवनो चाहत होत्यो। पर उ नही चोव सकिन, आयकन चाव्हत होतिन, पर उ नहि आयकिन।” ");
INSERT INTO pwr_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","एक मोसे को नियम को गुरू, यीसु को परिक्सा लेवन काजी आयो। अना पुसिस, हे गुरूजी, अमर जीवन को अधिकारी होवन लाय, मी काजक करु? ");
INSERT INTO pwr_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","यीसु ना कव्हयो, मोसे को नियम मा का लिखी सेस? अता तुमी का बाचासो? ");
INSERT INTO pwr_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","वोना जवाब दियो, तू आपरो पिरभू परमेस्वर लक आपरो सारो मन अना आपरो सारो परान अना आपरो सारो ताकत अना आपरो सारो अक्ल को संग पिरेम करो। अखीन आपरो सेजारी, लक आपरो जसो माया राखो। ");
INSERT INTO pwr_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","यीसु ना वोला ला सांगीस, तु ना खरो सांगीसेस योच कर, तो तू जित्तो रव्हजोस। ");
INSERT INTO pwr_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","एको पर एक गुरू ना आपरो आप ला, जादा खरो दिसान काजी यीसु ला सवाल करीस, लेकिन मोरो सेजारी कोन आय? ");
INSERT INTO pwr_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","यीसु वोला एक उदाहरन सांगन लग्यो। एक मानूस येरुसलेम लक, येरीयो नगर जावत होत्यो। वोला डाकू गीन घेर लेइन, वोला मारपीट के लुट लेइन अखीन अधमरो करके सोड़ देइन। ");
INSERT INTO pwr_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","एकाएक एक याजक वहान लक, पार भयो। वोला चोवके ना उतरा के चलीगयो। ");
INSERT INTO pwr_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","असोच एक लेवी आयो उ भी चोवके, कतरा के चले गयो। ");
INSERT INTO pwr_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","अबा एक सामरी लोक को आदमी वोला चोवके ना, दया लक भर गयो। ");
INSERT INTO pwr_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","उ वोको कना गयो अखीन, अंगूर को रस डालके ना, मरहम पट्टी करीस, अना आपरो सवारी मा बसाय के, बइद को जवर लेगइस। ताकि ओको सेवा कियो जाहे। ");
INSERT INTO pwr_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","बइद ला दोन सौ दीनार देके कहीस, का अखीन लगहे तो मी आनके दे देहू अखीन रोगी को सेवा करजोस। ");
INSERT INTO pwr_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","यीसु ना गुरू ला पुसयो उन तीनो लक, कोन उ मानूस को सेजारी पड़ोसी कहलावासे। ");
INSERT INTO pwr_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","वोना जवाब देइस का, जोन ना वोको काम आइसे, यीसु कव्हयो जाओ तुमी असोच किरपा करो। ");
INSERT INTO pwr_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","यीसु चेलागीन को संग एक गाँव मा गईन अखीन, वोना गाव मा मरियम अखीन, मारथा नाव को दूई बहिन रव्हत होतीन उनको घर यीसु अखीन वोको चेलागीन, पहूनाई मा गईन। ");
INSERT INTO pwr_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","मरियम नाव ओकी एक बहिन होती, सबा काम धाम छोड़ केना यीसु को कठा, बस के पिरभू को गोस्टी ध्यान लक, आयकत होती। ");
INSERT INTO pwr_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","अखीन मारथा काम करत-करत हिजड़ गई अखीन कहीस, पिरभू तोला मोरो चिन्ता नही सेती की मोरी बहिन ना मोला सेवा को काम करन को लाई एकलोच छोड़ देईसेस? एको लाई ओला हुकूम दे का मोरी हात बटाये। ");
INSERT INTO pwr_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","तबा पिरभू ना सागींस मारथा, तू गजब चिंता करासेस। ");
INSERT INTO pwr_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","मरियम ना मोरो कठा, बसके संसार को सबा लक, साजरो हिस्सा निवाड़ो सेस, ऊ कभी नही सुड़ायो जाहेत। ");
INSERT INTO pwr_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","यीसु कोनी जघा मा, पिराथना करत होतो। जबा पिराथना पूरो भयो, तो वोको चेला गीन मा, एक ना कव्हयो, पिरभू योहन गुरूजि ना, आपरो चेला गिनला, जसो पिराथना सिकाइसेस, वसोच अमीला पिराथना करनो सिकाव। ");
INSERT INTO pwr_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","वोना कव्हयो जबा तु पिराथना करने, तो असो कव्हने, हे, आमरो बाबूजी तोरो नाव पवीतर मानो जाहेत, तोरो राज आहेत। ");
INSERT INTO pwr_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","अमरो दिवस भर को जेवन, अमीला देव। ");
INSERT INTO pwr_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","हमिना जसो हरेक बुराई करनवालो ला, छिमा करीसेजन वसोच, आमरो बुराई ला छिमा कर, अखीन हमीला परिक्सा मा नोको डाख। ");
INSERT INTO pwr_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","तबा यीसु ना, उन लक कव्हयो, तुम्ही मा लक कोन सेत। वोको एक संगी अरधो रात मा, जायके वोला कहे, मोला तीन भाकर देव, ");
INSERT INTO pwr_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","मोरो घर मा संगी आइसे। वोला जेवन परसन लाय, काही नाहत। ");
INSERT INTO pwr_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","उ भीतर लक कव्हन लग्यो, मोला दुख नोको देव, किवाड़ बंद से, अखीन लेकरा-बारा झोपीसेस। यो काजी बिछोना लक जाग के ना, काही नही दे सकसू। ");
INSERT INTO pwr_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","मी तुम्हिला सागंसू, का उ टोन्ड फोड के मांगीसेस, यो काजी जेतरो जरुरत से, वोको संगी वोला जरुर देहेत। ");
INSERT INTO pwr_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","अखीन मी सांगसू, क मांगजोस तबा दियो जाहेत, ढुढने, पावने, किवाड़ खटखटाने, तो उघाडो, जाहेत। ");
INSERT INTO pwr_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","काहेका जो कोनी मांगा से, वोला भेटासे। अखीन जो ढुढासे, उ पावासे, अखीन जोन खटखटासे वोको काजी किवाड़ उघाड़ासे। ");
INSERT INTO pwr_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","तुम्ही मा कोनतो आसो बाबूजी से, जबा टूरा भाकर मांगहे, त वोला गोटा दे देहे, मसरी मांगहे, त सरप दे देहेत। ");
INSERT INTO pwr_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","ना डिम, मांगेत तो मेहदल देहेत। ");
INSERT INTO pwr_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","अता जबा तुम्ही बुरो होयके, आपरो लेकरा बारो-ला, साजरो चीज देवनो जानासो, तो सरग को बाबूजी, परमेस्वर आपरो मांगन वालो ला, पवीतर आतमा काहे नही देहेत। ");
INSERT INTO pwr_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","मंग वोना, एक गुंगो बुरो आतमा ला कहाड़िस। जबा उ बुरो आतमा हिट गयो तो, गुंगो हाका देवन लगयो, अखीन लोकगीन चकित भई गईन। ");
INSERT INTO pwr_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","पर काही लोग गीन कव्हन लगीन, का, यो बुरो आतमा को मुखिया, बालजबुल को सहायता लक बुरो आतमा ला हेड़ासे। ");
INSERT INTO pwr_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","काही लोग गीन वोको परिक्सा लेवन काजी, बादल लक निसान मांगन लगीन। ");
INSERT INTO pwr_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","उनको मन को बात जानके ना, यीसु कव्हन लगयो, जोन राज मा फुट पड़ जासे, उ सत्यानास हो जासे, अना जोन घरमा फुट पड़ जासे उ नास होवजासे। ");
INSERT INTO pwr_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","अदी बालजबुल आपरो विरोध करयेत, तो वोको राज कसो बनो रहेत? काहेका, तुम्ही कव्हसो का, मि सैतान को सहयाता लक बुरो आतमा हेड़ासु। ");
INSERT INTO pwr_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","अदी मि बालजबुल की सहायता लक बुरो आतमा ला हेड़ासेत तबा तूमी तय करो, तुमरो औलाद कोनी को साहयता लक हेड़ासेत? एकोलाय वोच तुमरो न्याय करयेत। ");
INSERT INTO pwr_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","पर अदी मि परमेस्वर को ताकत लक बुरो आतमा हेडासु, तो परमेस्वर को राज तुम्हारो कठा आईसेस। ");
INSERT INTO pwr_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","जबा कोनी ताकतवर मानूस, हतियार बान्ध लेवासे अना आपरो घर को चौकीदारी आँगन मा कर रहयो से, तो धन को सुरक्सा को चिन्ता नही रव्हासे। ");
INSERT INTO pwr_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","पर कोनी मोठयो पहलवान चढ़ाई करके, वोको हतियार जोनमा वोला भरोसा होतो वोला हिसकसे, अखीन वोको सम्पती लुटा से, अखीन बाट देवासे। ");
INSERT INTO pwr_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","जोन मोरो संग नहात, उ मोरो बिरोध मा सेत, अखीन जो मोरो संग नही सेत, उ बटोरनो सोड़ केना, छितरावा सेत। ");
INSERT INTO pwr_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","जबा भूत पलीत, मानूस लक हीट जावासे, अखीन सूखो जमीन मा, चैन नही मिलासे। तो, उ जहान लक हिटयो से, वहान लक जावासे। ");
INSERT INTO pwr_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","अखीन आके आपरो घरला, झाड़ो बोहरो, सजो पावासे। ");
INSERT INTO pwr_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","ता उ जायकेना, अपरो लक सात बुरो आतमा ला, आपरो सगं ले आवासे, अखीन वय वो मा समाके बास करासेत। अखीन उ मानूस को हाल, मंघा पूढा लक बूरो भई जासे। ");
INSERT INTO pwr_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","जबा उ यो गोस्टी सांग रहयो होतो, तबा भीड़ मा लक, एक बाई ना जोर लक हाकलीस। धन्य से उ पोट, जेनको लक तू जनम लेइसेस। अखीन जोन माय को दूध पीवी सेस। ");
INSERT INTO pwr_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","यीसु ना कव्हयो, हाँ पर धन्य सेत उ, जोन परमेस्वर को गोस्टी आयक के, वोला मानसे। ");
INSERT INTO pwr_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","जब गजब भीड़ हो लोक होत्यो तो, उ कव्हन लग्यो, यो जूग को लोक गीन खोटो सेत, उ हिदान ढुन्ड़ासे, पर योना भविस्यवक्ता को हिदान ला सोड़, अखीन कोनी हिदान, उनला नही दियो जाहेत। ");
INSERT INTO pwr_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","जसो योना भविस्यवक्ता, निनवे माहानगर को लोग गिनको लाय, एक हिदान बन गयो होतो। वसोच मानूस को टूरा, यो पीढ़ी काजी हिदान सेव। ");
INSERT INTO pwr_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","न्याय को दिवस, दक्सिन देस को महारानी, यो पीढ़ी को लोग गीन संग मा, उभी होयती, अखीन इनला खोटो ठहराय देहेत। काहेका, उ राजा सुलेमान को अक्ल को, गोस्टी आयकन काजी, धरती को छोर लक आई होति। अखीन चोवो मि वोको लक महान सेव, ");
INSERT INTO pwr_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","न्याय को दिवस, निनवे नगर को लोकगीन, यो पीढ़ी को लोकगीन संग उभो होहेत, अना इनला दोसी मानेत, काहेका उनना, योना भविस्यवक्ता को संदेसा आयकके ना पस्तावा करयो होतो, अखीन चोयो सेस, क मी योना लक भी मोठो सेव। ");
INSERT INTO pwr_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","दियो पेटाके कोनी वोला तहखाना मा, मंग डलीया उबड़ा के नही ठेवासे, पर फूल मा ठेवासे, जोन लक भीतर आन जान वालो ला उजारो चोहे। ");
INSERT INTO pwr_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","तुमरो, तन को, दियो तुमरो डोरा सेत, अदी तुमरो डोरा साजरो से, तर तुमरो सारो आँग मा उजाड़ो से, पर उ खराब भयि जाहेत, तर आँग भी इन्धार भई जाहेत। ");
INSERT INTO pwr_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","एको लाय दोन गोस्टी ध्यान राखन को से, जोन यो उजाड़ो तुमरो मा से उ कहिं, इन्धार न होयेत जायेत। ");
INSERT INTO pwr_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","अदी तुम्हारो सारो तन मा उजाड़ो सेत, अखीन वोको कोनी भी हिस्सा, इन्धारो मा नाहत, तो उ वसोच हमेसा लक चमकत रव्हासे जसो दियो आपरो उजाड़ो लक सबा ला चकाचक कर देसे। ");
INSERT INTO pwr_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","यीसु सागंत होतो, तबच एक मोसे को नियम को गुरू ना कव्हयो, गुरूजी हमरो संग जेवन कर, यीसु भीतर जायके न, जेवन करन बस गयो। ");
INSERT INTO pwr_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","मोसे को नियम को गुरू यो चोवके, चकीत भय गयो, का यीसु बिना हात पाय धोवके, जेवन बस गयो। ");
INSERT INTO pwr_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","पिरभू ना कव्हयो, हे मोसे को नियम को गुरू, तुम्ही विधि-विधान लक हात-पाय धोवके ना, गडू-गिलास भानी ला बहार लक माजा सो, पर तुम्हारो भीतर मा ला लक बुराई भरोसे। ");
INSERT INTO pwr_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","अरे मुरख, जो बाहेर को हिस्सा बनइसेस, वोच भीतर भी बनाइसेस। ");
INSERT INTO pwr_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","जोन भीतर सेत, वोला तुम्ही दान करदेव, अखीन चोवो सबच सुध्द भय जाहेत। ");
INSERT INTO pwr_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","हे मोसे को नियम को गुरू, तुम लक धिक्कार से, काहेका पोदीना, सोप, अखीन हरेक हिवरो साग को, दसवा पराय लेवासो, पर परमेस्वर को, माया अखीन न्याय को लक, तुम्ही लापरवाही करा सेव। तुम्हारो लायक यो साजरो होवतो, का तुम्ही वोला भी मानासेव, अखीन येला भी। ");
INSERT INTO pwr_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","मोसे को नियम को गुरू तुम्हारो पर धिक्कार सेत, तुम्ही सभाघर मा, हरेक समाजीक काम मा, ऊचो आसन चाव्हासो, अखीन बजार मा सबा परनाम करहेती, तुम्ही यो सबा माया राखासेव। ");
INSERT INTO pwr_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","धिक्कार से तुम पर, काहेका, तुम्ही चुना पुतो सफा मरघट्टी सेव, जोन नही दिससे का, भितर मा का सेत, लोग तुमीला साजरो समज के, लोग तुमरो कव्हनो मा चलासे। ");
INSERT INTO pwr_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","एक मोसे को नियम को गुरू कव्हसे, हे गुरूजी, तुम्ही असो कव्हसो, आखिन आमरो बेइज्जती करासो। ");
INSERT INTO pwr_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","यीसु ना कव्हयो, हे मोसे को नियम को गुरू गीन तुमला धिक्कार सेत, तुम्ही मोठो-मोठो नियम को बोझा जनता पर लाद देसो, जो उ नही उचल सक से। अखीन वो भारी बोझा ला तुम्ही बोट भी नही, लगा सकासो। ");
INSERT INTO pwr_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","तुम पर धिक्कर सेत, जुनो जमाना मा, मोठो-मोठो भविस्यवक्ता गीनला, तुमारो बाप-दादा गीन मार डाखिन अखीन तुम्ही उनको मठ बनासेव ");
INSERT INTO pwr_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","असोमा तुम्ही गवाही सेव का तुम्हरो बाप दाद ना खोटो काम करी सेस मारके उनको मठ बनाइसेस ");
INSERT INTO pwr_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","यो कारन परमेस्वर कव्हासे, मि उनको जवर चेलागीन ला धाड़ासू उन मा लक काही ला सताहेत अखीन काही भविस्यवक्ता ला मार डाखेत ");
INSERT INTO pwr_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","जोन लक दुनिया बनान को बेरा ले अब तकन जितरो भविस्यवक्ता गीनको खून बोहाय गयो सेत वोको हिसाब योच पीढ़ी को लोकईन लक लियो जाहेत। ");
INSERT INTO pwr_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","मि कव्हसू भविस्यवक्ता हाबिल पासुन जकरयाह वरीच जोनला भविस्यवानी को घर अना वेदी को भितर म खून कर दियेत। ");
INSERT INTO pwr_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","मोसे को नियम को गुरू तुम पर धिक्कार सेत, तुम्ही ना गियान को कुन्जी हिसकसेव, अना तुम्ही खुदच नही धसेव अखीन कोनी ला भी नही धसन देसो। ");
INSERT INTO pwr_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","यीसु वहान लक जावन लग्यो, त मोसे को नियम को गुरू गीन वोला फसावन काजी, सवाल-जवाब करन लगीन। ");
INSERT INTO pwr_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","अखीन वोको विरोध मा वोला मार डाखन लाय डाव ढुढन लगीन। ");
INSERT INTO pwr_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","यीसु कोनी जघा मा पिराथना करत होतो। जबा पिराथना पूरो भई गयो हो तो। गरदी एतरो तकन बढ गई की लोकगीन एक दुजो पर पड़त होतीन। तबा यीसु चेला गीन लक कव्हन लग्यो। मोसे को नियम को गुरूगीन को कपट लक सतरक रव्हने। ");
INSERT INTO pwr_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","असो काही झाको नाहत जोन उघाडो न जाहेत अखीन अदी लुको नहात जोन जानो ना जाये। ");
INSERT INTO pwr_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","एकोलाय जो काही तुम्हीना इन्धार मा सांग सेव उ उजयाला मा आयको जाहेत। अखीन जो काही तुम्हीला खोली मा सांगे सेव उ अटारी को वोरता लक सबला परचार करो। ");
INSERT INTO pwr_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","ओ मोरो संगी हुन तुम्हीला सांगसू जो तुमी लोक गीनको तन ला नास करयेत उन लक नोको डराव पर एको मघा अखीन काही नही कर सकेत। ");
INSERT INTO pwr_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","मी तुम्ही ला चोवके कव्हसू कोनी लक डराव ये वोको लक डरो जो मरनो को बाद मा जोनला नरक मा डाकन को अधिकार सेत वोको लक डराओ। ");
INSERT INTO pwr_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","उ दुई पैसा मा पाँच चिड़िया मिलासे मंग भी परमेस्वर उन मा लक एक ला नही भूलासे। ");
INSERT INTO pwr_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","तुम्ही भेव नोको खाव तुम्हारो जान गजब सो चिड़िया गीन लक जादा कीमती सेत परमेस्वर ना तुम्हारो डोस्का को चुन्दी गिनके राखिसेस। ");
INSERT INTO pwr_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","मि तुम्‍ही लक कव्हासू जो कोनी मानूस गीनको पुढा मोला मानसे मानूस को टूरा सरगदूत अखीन परमेस्वर को सामने मान लेवासु का यो ला मी जानासू। ");
INSERT INTO pwr_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","पर जो मानूस गीन को पुढा मोला मुकर जायेत अखीन सांगासे कोन यीसु से? तो मी परमेस्वर अखीन सरगदूत गीन को पूढा सांगू मी भी यो ला नही जानासू यो कोन सेत? ");
INSERT INTO pwr_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","जोन कोनी मानूस को टूरा को विरोध मा गोस्टी सांगेत वोको दोस छिमा हो जाहेत, पर जोन कोनी पवीतर आतमा को विरोध मा निन्दा करेत वोको अपराध छिमा नही होयेत। ");
INSERT INTO pwr_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","जबा लोग गीन तुम्हीला सभाघर मा न्यायलय मा अधिकारी गीन को कठा लिजायेत तो हमी काजक सांगबीन सोचके नोको घबराने। ");
INSERT INTO pwr_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","काहेका वोच बेरा मा काजक कव्हनो सेत पवीतर आतमा तुम्ही ला सीका देहेत। ");
INSERT INTO pwr_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","भीड़ लक एक मानूस चिल्लायो, हे गुरू! मोरो भाऊ लक हुकूम देव, का धन को बटवारा कर देवे। ");
INSERT INTO pwr_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","यीसु ना कव्हयो कोन ना मोला तुम्हारो न्यायी ठहराई सेस। ");
INSERT INTO pwr_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","यीसु ना भीड़ लक कव्हयो कोनी को सम्पती वोको जान लक बड़के नही होय सका से, पर यो काजी आपरो आप ला लोभ लक बचाये राखो। ");
INSERT INTO pwr_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","वोना एक उदाहरन लक समजावन लग्यो कोनी धनवान को जमीन मा गजब फसल पीकी। ");
INSERT INTO pwr_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","तबा उ आपरो मन मा विचार करन लग्यो फसल राखन काजी अता मी काजक करु? ");
INSERT INTO pwr_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","अखीन वोना सोचीस का घर मा ढोला गिनला तोड के उनला मोठी बनाके ना वहान गँहु ठे देहू। ");
INSERT INTO pwr_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","तबा मि आपरो मन ला सांगू, “हे मोरो मन, तोरो जवर लगत बरस को साठी लगत सी जायदाद राखीसे। सुख मनाय अना जेवन कर, खुसी मनाव।” साजरो-साजरो रव्हो अखीन चैन लक जिंदगानी करेत। ");
INSERT INTO pwr_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","पर परमेस्वर ना ओला साँगीस, हे मन्द डिमाक! आजच रात मा तोरो पिरान तोरो लक हर लियो जाहे, तबा तु अपरो धन सम्पती ला काजक करजोस अखीन जोन राखी सेस कोन को भई जाहेत? ");
INSERT INTO pwr_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","जोन मानूस आपरो काजी धन जोड़ासे वा यो मुरख जसो सेत, परमेस्वर को नजर मा कोनी धनी नहात। ");
INSERT INTO pwr_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","मंग आपरो चेला गीन ला कव्हासे, ऐना करन लक मि तुमरो लक कव्हसू, “आपरो जान लाई असो कव्हके चिन्ता नोको करने, की हमी काजक जेवन करबीन देह मा काजक पहनबीन? ");
INSERT INTO pwr_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","काहेका जान सेत तो जेवन सेत, अखीन तन सेत तो कपरा सेत। ");
INSERT INTO pwr_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","कावरा पर ध्यान देव! वा ना बोवासे ना कापासे ना कोठी मा ठेवासे तबा भी परमेस्वर वोला पालासे तुम्ही कावरा अखीन पंखेरु ला बढ़के सेव। ");
INSERT INTO pwr_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","तुम्ही मा असो कोन सेत जो चिन्ता करके ना आपरो जिंदगी को बेरा बढा सकासे? ");
INSERT INTO pwr_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","अदी एतरो नान्होसो काम तुम्ही नही कर सकसो ता काजक लाय चिन्ता करोसेव?” ");
INSERT INTO pwr_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“पहाड़ी को तराई कन ध्यान देव वहान जंगल को फुल कसो बढासे वोना आसो चोवसे का राजा सुलेमान को महिमा अना राजसी कपरा वोको पूढा फैल सेत। ");
INSERT INTO pwr_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","यो काजी बर्रा को गवथ ला जोन आज सेत कल स्तो को भट्टा मा डाख्यो जाहेत परमेस्वर वोला असो हरो भरो राखासे, तो हे कच्चो भरोसा राखन वालो! तुम्हीला काहे साजरो कपरा नही पहनायेत?” ");
INSERT INTO pwr_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","“तुम्ही सक नोको करो का काजक जेवबीन अखीन काजक पहनबीन? ");
INSERT INTO pwr_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","काहेका संसार को सप्पा मानूस मजे गैरयहुदी खुद जानासे का तुम्ही ला ये पाहिजेत। ");
INSERT INTO pwr_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","पर सब लक पुढा परमेस्वर को राज अखीन न्याय ला खोजो तबा सबा चीज तुम्ही ला मिल जाहेत। ");
INSERT INTO pwr_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","हे नान्हो हेड़ डराव नोको! परमेस्वर को इक्सा सेत, का तुम्ही ला राज देहेत।” ");
INSERT INTO pwr_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","“आपरो धन-सम्पती बिक देव अना दान कर देव, अना आपरो कना असो पियुसी राखो, जोन जूनो नही होवासे, मजे सरग मा असो धन जमा करो जोन कमी नही होवासेत अना जोन को जवर चोर नही जावासेत, अना किड़ा काही बिगाड़ सकत। ");
INSERT INTO pwr_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","काहे का जहा तिजोरी मा तुमरो धन से, वहाच तुमरो मन लगो रव्हेत।” ");
INSERT INTO pwr_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“दियो पेटाव के ठेयो अखीन अपरो कमर बान्ध के ना तैय्यार रव्हने, ");
INSERT INTO pwr_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","अना तुम्ही वोना दास को जसो बनो, जोन आपरो मालीक को बाट जोहत रव्हसे का लग्न को जेवन करके ला कबा आहेत? अखीन मी किवाड़ खोलू। ");
INSERT INTO pwr_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","धन्य सेत वय दास जेनला वोको मालीक को आवनो पर जागतो मिल्हेत, मी तुम्ही लक खरो कव्हसू, मालीक उन ला पूरी तैय्यारी को सँगा जेवन लाय बसाहे, अना जवर आयके उनको सेवा करहे। ");
INSERT INTO pwr_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","धन्य सेत उ दास, जबा वोको मालीक रात मा कभ्भू भी आहेत, अना वोला निगरानी करतो पाहेत। ");
INSERT INTO pwr_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","यो साजरो लक समजलो का, यदि घर को मालीक ला मालूम हो तो का चोर कबा आवन वालो सेत, तो घर मा सेन्ध नही लगन देतो। ");
INSERT INTO pwr_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","तुमी तैय्यार रव्हने जोन बेरा तुम्हि वोको आवन को मन मा विचार नही आनिसेव वोच बेरा मानूस को टूरा आय जाहेत।” ");
INSERT INTO pwr_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","तबा पतरस पुसयो पिरभू का यो उदाहरन तुम्ही हमरो लाय सांगासो का सबको लाय सेत? ");
INSERT INTO pwr_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","तबा यीसु ना कव्हयो, उ बिस्वास को काबील को ईमानदार मूनीम कौन सेत? जेनको मालीक आपरो नौकर चाकर पर मूनीम ठयरावा सेत, जोनलक उनला बेरा मा जेवन भेटेत। ");
INSERT INTO pwr_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","धन्य सेत उ दास जो मालीक को अवन को बेरा मा वसोच करतो पाहेत। ");
INSERT INTO pwr_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","मी तुम्ही लक खरोखर सांगसू उ वोला आपरो सब सम्पती पर अधिकारी बनायेत। ");
INSERT INTO pwr_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","पर उ दास असो मन मा सोचन लगे, का मोरो मालीक ला आवन ला उसीर सेत, अना नौकर बनिहारिन ला मारन पीटन लगे, अना नसा बाजी एसो अराम करन लगेत। ");
INSERT INTO pwr_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","तबा उ दास को मालीक असो दिवस आहेत, जोन दिवस को बारे मा उ मन मा विचार नही आनो होतो। तबा वोला गजब मोठो दन्ड देहेत, अना वोको हिस्सा भरोसा नही राखन वारा लोकगीन को संग होहेत। ");
INSERT INTO pwr_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","आपरो मालीक को मन को गोस्टी जानके न जोन दास ना काही तैय्यार नही करयो, ना वोकी मन मुताबीक काम करीस, उ गजब मार खायेत। ");
INSERT INTO pwr_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","पर जोना अनजान मा मार खावन को काम करी सेस, उ जरासो मार खायेत, जोनला दियो गयो सेत, वोको लक गजब हीसाब मागो जाहेत। जोन ला गजब सोपो गई सेस वोको लक गजब लियो जाहेत। ");
INSERT INTO pwr_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","मी धरती मा स्तो पेटावन काजी आई सेव। मी कीतरो चाव्हसू क उभो होयके धधक जाहेत। ");
INSERT INTO pwr_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","मोला एक अखीन बप्तिस्मा लेनो से। अखीन जबा तकन यो पूरो नही होवासे मी गजब दुखीसेव। ");
INSERT INTO pwr_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","का तुम्ही सोचसो का मी धरती मा सान्ती अना मेल करान आयो सेऊ, नही मी फूट डालन आइसेव। ");
INSERT INTO pwr_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","काहे का एक घर मा पाँच मानूस सेत तो उन मा फूट होहेत, तीन दोन को विरोध अना दोन तीन को विरोध करेत। ");
INSERT INTO pwr_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","वय एकमेक को विरोध करेत बाप टूरा को अखीन टूरा बाप को, माय टूरी को अना टूरी माय को, सास बहु को अखीन बहु सास को विरोध करेत। ");
INSERT INTO pwr_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","यीसु ना भीड़ ला कव्हन लगीस, अदी तुमी दिवस डूबती लक बादल चोवासो तो कव्हसो, का बरसात होवन वालो सेत, अखीन असोच होवासे। ");
INSERT INTO pwr_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","जबा दक्सिन को वारा चलासे तो कव्हासो का लपट चलहेत अखीन असोच होवासे। ");
INSERT INTO pwr_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","वो कपटी गीन, तुम्ही बादल अखीन धरती को मौसम ला चीन्हासो तबा यो बेरा को लच्छन ला काय नही परख सकसो? ");
INSERT INTO pwr_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","तुम्ही खुदच न्याय काहे नही करासो, का काजक भलो सेत? ");
INSERT INTO pwr_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","जबा तुम आपरो विरोधी को संग अदालत मा जावासो तो रास्ता मा वोको लक रिहाई को कोसिस करने, कही असो ना होयेत का उ तुमला न्यायी को कठा ले जाहेत। ");
INSERT INTO pwr_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","मी तुम्ही लक कव्हसू जबा तकन एक-एक कवड़ी नही भरजो तबा तकन सूटकारा नही होवेत। ");
INSERT INTO pwr_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","वोना बेरा काही लोग गीन, यीसु ला, काही गलीली मानूस गीनको बारे मा सांगन आइन, जिनको खून को बरोबरी बलिदान कियो गयो जनावर लक, राजपाल पिलातुस ना करयो होतो। ");
INSERT INTO pwr_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","तबा यीसु ना उन लोग गीनला कहीस, तुम्ही काजक सोचासो का यो गलीली मानूस बाकी लोकगीन लक लगत पापी सेत, यो कारन लक, उन पर आफद आइसेस। ");
INSERT INTO pwr_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","असो गोस्टी नहात मी तुमी ला सागंसू, का तुमी पस्तावा कर मन नही बदलने, तो वसोच नास होय जाने। ");
INSERT INTO pwr_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","अखीन तुमी काजक, सोचासो का सीलोह मा मीनार पड़न को कारन 18 लोकगीन मर गईन, उ येरुसलेम को सब रव्हन वारा लक जादा पापी होतिन। ");
INSERT INTO pwr_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","असो नहात अदी तुमी पस्तावा कर, मन नही बदलने तो असोच नास भई जाने। ");
INSERT INTO pwr_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","तबा यीसु ना उनला, एक उदाहरन सांग्यो, कोनी, मानूस को अंगूर को बारी मा, एक अँजीर को झाड़ होत्यो। उ वोमा फर खोजन आयो पर वोला, एक भी फर नही मिलयो। ");
INSERT INTO pwr_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","तबा वोना अंगूर को बगीचा को माली ला कहीस, चोव! मी तीन- साल लक, यो अँजीर को झाड़ मा फर खोजन आयो, पर एकच फर नही पायो। एला, काप डाखो काहे का यो फालतू मा जघा घेरासेत। ");
INSERT INTO pwr_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","पर माली ना कव्हयो, मालीक यो साल अखीन रव्हन दे, मी एको, चारि कन खन्दकेना येको, जड़ मा मी खात डाखसू। ");
INSERT INTO pwr_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","तबा मंग भी नही फलेत, त काप दियो जाहेत। ");
INSERT INTO pwr_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","पवीतर दिवस मा यीसु कोनी, सभाघर मा उपदेस देवत होत्यो। ");
INSERT INTO pwr_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","वहान एक बाई होती जोन ला 18 साल लक, एक कमजोर करन वालो, बुरो आतमा झोमो होत्यो वा वोवन केना, कुबड़ी भई गई होती। वा कसी, भी सीधी नही होय सकत होती। ");
INSERT INTO pwr_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","यीसु ना वोला चोवके, ना बुलायो अखीन वोला कहीस, हे बाई तु साजरी भई गइसेस। ");
INSERT INTO pwr_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","अखीन वोना वोको, पर हात रख्यो, उ वोच बेरा साजरो भई गई अखीन, परमेस्वर ला धन्यवाद बड़ाई देवन लगी। ");
INSERT INTO pwr_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","तबा सभाघर को मुखिया गीन, हिजड़ गईन काहेका, यीसु ना पवीतर दिवस मा बाई ला साजरो करीस, तबा लोकगीन कव्हन, लगीन 6 दिवस काम को सेत, वोना दिवस मा साजरो होव, अना पवीतर दिवस मा नोको आव। ");
INSERT INTO pwr_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","पर पिरभू ना कहीस, हे कपटी गीन का पवीतर दिवस मा तुम आपरो जानवर गधा बईल गीनला डोगा मा पानी देवसो का नही? ");
INSERT INTO pwr_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","का साजरो नाहती, का यो बायका जोन अबराहम को टूरी सेत, जोनला सैतान ना अठरा साल लक बन्धो होतो, पवीतर दिवस यो बंधन लक सुटाई जाय? ");
INSERT INTO pwr_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","यीसु को यो गोस्टी आयक केना, वोको सब बिरोध करनवारा लजा गईन, अना सप्पा लोकगीन वोना महीमा को काम चोवके खुसी लक भर गईन। ");
INSERT INTO pwr_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","यीसु ना कव्हयो परमेस्वर को, राज कोन को जसो सेत, मी एको बरोबरी काजक लक करु? ");
INSERT INTO pwr_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","सरग को राज एक राई को दाना जसो सेत, जोनला कोनी मानूस ना बगीचा मा लगायो, वा गजब मोठयो भयी गयो, अखीन पक्सी ओना झाड़ को डार मा बसेरा करन लगीन। ");
INSERT INTO pwr_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","मंघा यीसु ना कव्हयो, “परमेस्वर को राज को बरोबरी काजक लक करु? ");
INSERT INTO pwr_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","वो खमीर को जसो सेत जोनला लेय के, एक बायको ना दहा किलो कनीक मा मिला दियो सबा 10 कीलो आप खमीर बन गयो।” ");
INSERT INTO pwr_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","यीसु गाँव-गाँव नगर-नगर सीकावत, येरुसलेम नगर को कन, जाय रहयो होतो। ");
INSERT INTO pwr_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","कोनी ना पुसयो ओ पिरभू! का जरा सो लोक गीन सूटकारा पाहेत? एको पर यीसु ना कव्हयो, ");
INSERT INTO pwr_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","सकड़ो किवाड़ लक, धसनो को पूरो-पूरो कोसीस करो, काहेकि मी तुमी ला कव्हसू, कोसीस करनो पर भी गजब लोकगीन धसन को लायक भी नही रहेत। ");
INSERT INTO pwr_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","जब घरा को मालीक उभो भई केना, किवाड़ लगा देहेत, तबा तुम्हि बाहेर लक खट-खाटावने, अखीन कव्हने आमरो लाय किवाड़ उघाड़!तब उ तुम्हिला सांग देहत, तुम्ही कहान लक आइसेव, मी नही जानासू? ");
INSERT INTO pwr_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","तबा तुमच कव्हने, आमी तोरो संग जेवन करीसेस, तुमी बजार मा उपदेस देत होतो। ");
INSERT INTO pwr_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","पर उ तुमरो लक, कव्ह देहत, “अरे अन्याय को काम करन वालो, मी तुम्ही ला नही जानासू तुम्ही कोन सेव? तुमी मोरी नजर लक हट जाओ!” ");
INSERT INTO pwr_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","जबा तुमी ही अबराहम इसहाक याकूब अखीन, सबा भविस्यवक्ता गीनला, परमेस्वर को राज मा चोवने, पर अपरो आप ला उन लक बेगरो चोयके तुम्हि रोवने अखीन पस्तावा करने । ");
INSERT INTO pwr_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","दिन उगती, दिन बुड़ती, उत्तर अखीन दक्सिन का लोक गीन आहेत अखीन, परमेस्वर को राज मा मोठोयो, जेवनार मा जेवन करयेत। ");
INSERT INTO pwr_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","चोवो जोन मघा सेत, उ पुढा भई जाहेत। अखीन जो पुढा सेत, उ मंघा भई जाहेत। ");
INSERT INTO pwr_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","वोच बेरा मा काही मोसे को नियम को गुरू जी गीन, आयके सांगन लगीन, हे गुरूजी तुम्ही यहान लक, बिदाई लेलो काहेका, राजा हेरोदेस तुमी, ला मार डाखनो चाव्हासे। ");
INSERT INTO pwr_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","यीसु ना उनला कव्हयो, जाके ना उ कोल्हिया ला कव्हने, मी आज काल अखीन परो, बुरो आतमा गीन ला हेड़ासू, अखीन रोगी गीनला साजरो करासू, अखीन परो को दिवस मोरो काम पूरो भई जाहेत। ");
INSERT INTO pwr_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","आज काल अखीन परो को दिवस मोला चलनो से, काहेका यो नही होय सकासे, का कोनी परमेस्वर को भविस्यवक्ता येरुसलेम तीरथ लक, बाहेर मारो जाहेत। ");
INSERT INTO pwr_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","यो येरुसलेम नगर तु भविस्यवक्ता गीनको हत्‍या करासे अखीन तोरो कना, जोन परमेस्वर को गोस्टी आना सेत, वोला गोटा लक मार डाकासेत, मीना कितरो बार चाहयोसेव, का तोरो सन्तान गीनला, इक्कठो करू, जसो कुकडी आपरो बच्चा गीन, ला पंखा को खाल्या, लुकाय लेवासे असोच सबा ला, लुकाय लेऊ, पर तु ना मोरो एक नही चलन दियो। ");
INSERT INTO pwr_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","अता तुम्हारो घर तोरो लय, छोड़ दियो जाहेत। मी तुमी लक खरो सांगासू, तुम्हि मोला जबा तकन नही चोवने, तबा तकन तुम्हि आवन वारो बेरा मा असो नही सागंने, का धन्य से उ जोन पिरभू को नाव लक आवासे। ");
INSERT INTO pwr_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","यीसु पवीतर दिवस मा कोनी, मोसे को नियम को गुरू को यहान जेवनार मा गयो होतो, लोग वोला फसावन को ताक मा होतिन। ");
INSERT INTO pwr_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","यीसु को पुढा एक जलोदर को रोगी आयो। ");
INSERT INTO pwr_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","यीसु ना मोसे को नियम को गुरू गीन ला पुसिस, “का मोसे को नियम लक पवीतर दिवस मा कोनी रोगीला साजरो करनो खरो काम सेत का खोटो काम सेत?” ");
INSERT INTO pwr_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","तबा वोना ऊगा-मूगा रह गईन, तबा यीसु ना उ रोगि ला हात धरके ना साजरो कर देइस, अना वोला बिदाई दे देइस। ");
INSERT INTO pwr_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","तबा यीसु ना उनला कहीस, अदी कोनी को टूरा या बईल बिहर मा पड़ जाहेत, तो तुमी मा कोन सेत जो पवीतर दिवस मा वोला बिहर लक नही हेडेत? ");
INSERT INTO pwr_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","अखीन वय वोको जवाब देवन को लायक भी ना होतिन। ");
INSERT INTO pwr_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","जेवनार मा आयो लोग गीन बसन लाय ऊचो-ऊचो जघा निवाड़न लगीन, असो चोवके ना यीसु एक उदाहरन लक, समजावन लगीन। ");
INSERT INTO pwr_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","जबा कोनी लगन मा नेवता देवासे, ता सबा लक मूख जघा मा नोको बसने। का मालुम तुमरो लक मोठो लोक ला घरवाला ना नेवता देइसेस। ");
INSERT INTO pwr_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","अना जोना दुई ला निवता देइसेस, वोच आय के सांगेत, का उभो भय अखीन खाल्या जायके बस, तबा लजानो पड़ेत। ");
INSERT INTO pwr_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","यो काजी जबा तुमला न्योता मिल्हे तो पूढा नोको बसने, मंघा जायके, बसने, तबा घर को मालीक आयके सागेत, अगो संगी पूढा बस, ता तुमरो महिमा होयेत, ");
INSERT INTO pwr_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","काहेका जोन आपरो आप ला, मोठयो मानासे उ लहान कियो जाहेत, अखीन जो लहान सेत, उ मोठयो करो जाहेत। ");
INSERT INTO pwr_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","मंग यीसु ना निवता देवन वालो, ला सांग्यो। जबा तुमी दूफर या रात मा जेवनार देवो, तबा संगी गीन ला नोको हाकलो अना आपरो, भाऊ कुटुम्ब, धनी सेजारी गीनला नोको हाकलो, कही असो ना होय का आपरो, घर मा नेवता देके, ना बदाला चुकाय देहेत। ");
INSERT INTO pwr_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","पर जब तुमी, जेवनार देव तो अँधरा लगंडा लूलो ला हाकलो। ");
INSERT INTO pwr_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","तबा उ तुमी धन्य भई जाने, काहेका, उनको कठा बदला देन काजी काही नहात, अखीन तुमला परमेस्वर को अदालत मा, नेक गिनको जित्तो होवन को मघा फर भेटेत। ");
INSERT INTO pwr_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","वोको संग जेवन करन वालो मा लक, एक मानूस यो गोस्टी आयक के सांगिस, धन्य से उ जोन परमेस्वर को राज मा जेवन करयेत। ");
INSERT INTO pwr_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","वोना ओको लक कव्हयो, कोनी मानूस ना गजब मोठो जेवनार दियो। अना गजब लोक हीनला न्योता दियो। ");
INSERT INTO pwr_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","जबा जेवन तैय्यार भय गयो, ता वोना आपरो दास को हात मा न्योता हारो गीनला, सांग के धाडिस, “आव अबा जेवन तैय्यार से”। ");
INSERT INTO pwr_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","पर वय सबा वोको लक माफी माँगन लगीन, पहलो ना नौकर लक, कव्हयो, “मी ना खेत लेयी सेव, वोला चोवन जानो से तोरो लक मोरो अरज से, का मोरो कन लक माफी मांग लेवजो।” ");
INSERT INTO pwr_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","अखीन एक ना कव्हयो “मी ना पाँच जोड़ी बईल लेईसेव, अना उनला परख करनो से। तोरो लक मोरो बिनती से, का मोरो कन लक माफी मांग लेव जोस।” ");
INSERT INTO pwr_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","अखीन एक ना कव्हयो, “मोरो लगन भइ सेस एको लाय मी नही आ सकसू।” ");
INSERT INTO pwr_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","दास ना लवट के आपरो मालीक ला यो सबा हाल सांगीस, तबा मालक हिजड़ के ना आपरो नौकर ला कहीस, “लवकर नगर को बाजार सरक, गली मा जायके ना गरीब गोर, अँधरा लगडा लूलो गीन ला यहान ले आओ।” ");
INSERT INTO pwr_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","तबा दास कहीस, मालीक तोरो हुकूम पूरो भई से, पर अबा जघा खाली सेस। ");
INSERT INTO pwr_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","ता मालीक ना दास ला कहीस, “सड़क मा अखीन रुधान बाहेर जितरो लोक, चोहेत सबला आनो जीनको लक घर भर जाहेत।” ");
INSERT INTO pwr_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","काहेका मी सबा लक कव्हसू, जोनला न्योता दियो होतो, उनमा लक कोनी जेवन नही जेव पाहेत। ");
INSERT INTO pwr_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","यीसु को संग-संग एक मोठयो भीड़ चलत होत्यो, यीसु ना भीड़ को लोग गीन लक असो सांग्यो, ");
INSERT INTO pwr_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“अदी कोनी मोरो कन आवासे अखीन आपरो माय बाप नवरी, सन्तान, भाऊ बहिन अखीन यहाँ लक की आपरो जान लक बैर नही करत, तो उ मोरो चेला नही होय सकासे?” ");
INSERT INTO pwr_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","जोन आपरो कूरूस उचलके, नही ले जावासे, अखीन मोरो मंघा नही चलासे, उ मोरो चेला नही होय सकेत। ");
INSERT INTO pwr_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","तुमी मा कोन असो सेत, जोन मीनार बनवानो चाव्हासे, अखीन पुढा घर मा बस के, ना खरचा को अन्दाज हिसाब नही करयेत। अखीन यो ना चोवेत, का वोको जवर केतरा रुपया सेत। ");
INSERT INTO pwr_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","कही असो ना होयेत, का पाया डाकन को मघा, घर को काम अधूरो छोड़ देहेत, अखीन चोवन वोरो, मजाक उड़ावत कहेत, “यो घर बनान को लायक भी नाहती।” ");
INSERT INTO pwr_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","यो मानूस ना घर बनान काजी नीव डाखीस, पर पूरो करन को लायक भी नहाय। ");
INSERT INTO pwr_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","अना कोन राजा होयेत, जोन दूसरो राजा लक, लडाई मा जावासे, अखीन पूढा बसके, यो विचार नही करासे, का जोन राजा बीस हजार सेना को, फौज को संग वोको पर चढ़ाई कर रही सेस, तो का उ दहा हजार सैनीक को फौज लक, सामना कर सकासे का नही। ");
INSERT INTO pwr_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","यदि उ सामना नही कर सकासेत, तबा दूसरो राजा को, कन सान्ती को लाय, राजदूत लक बिनती धाड़ देहेत। ");
INSERT INTO pwr_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","असोच तुम्ही लक जोन कोनी, सबा काही नही छोड़ देसे, उ मोरो चेला नहात। ");
INSERT INTO pwr_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“नोन साजरो सेत, पर वोको स्वाद बिगड जाय, तो कसो नमकीन होय सकासेत? ");
INSERT INTO pwr_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","उ ना तो जमीन को खात को काम को से, एकोलाय लोकगीन वोला बाहेर फेक देवासे। जोन को कान होयेत, उ आयक लेव।” ");
INSERT INTO pwr_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","यीसु को सिक्सा आयकन लाय, सबा पापी अना जमा लेवन वारा, अधिकारी आवत होतिन। ");
INSERT INTO pwr_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","पर सास्तरी अखीन मोसे को नियम को गुरू मोसे को नियम को गुरुगीन, कुडकूडान लगीन, अना कव्हन लगीन यो तो पापी लोक गीन, संग मिलसे उनको च संग जेवन करासे। ");
INSERT INTO pwr_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","तबा वोना एक उदाहरन सांगन लग्यो ");
INSERT INTO pwr_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","तूम्ही लक कोन सेत, जेनको जवर 100 मेढा सेत, अखिन वोमा लक, एक गुम जाहेत, तबा 99 ला जंगल मा छोड़के, उ एक ला जबा तकन ना भेटेत, ढुन्ढत ना रह। ");
INSERT INTO pwr_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","अखीन जबा उ मिल जावसे, तबा उ गजब खुसी होवासे, अखीन मेंढा ला कन्धा मा उचल लेवसे। ");
INSERT INTO pwr_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","अखीन आस पड़ोस को लोक घर को लोक संगी गीन, ला इक्कठो करके कव्हसे, का खुसी मनावो मेढा गुम गयो, होत्यो मिल गयो से। ");
INSERT INTO pwr_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","मी तुमी लक सांगसू, असोच एक पाप लक मन ला हटाव अना पस्तावा करन वालो, पापी को बारे मा सरग मा इतरोच खुसी होवासे, जितरो की 99 असो न्यायी को बारे मा नही होवासे। जोन ला मन बदलन को जरूरत नही सेती। ");
INSERT INTO pwr_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","कोनी असो बाया होवती जोको जवर दहा मुन्दरी को सिक्का होहेत, वोमा लक एक गुम जाये, ता उ दियो पेटाय के, अखीन घर झाड बुहार के, जबा तकन ना मिल जाहेत, जान लगाय के ढुन्ढत रही। ");
INSERT INTO pwr_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","अखीन जबा उ मुन्दरी को सिक्का मिल जासे, उ आपरो सहेली अना सेजारीन ला इक्कठो करासे, अखीन कव्हसे, का मोरी सिक्का गुम गयो, होतो मिल गयो से, मोर संग खुसी मनाओ। ");
INSERT INTO pwr_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","मी तुमी लक कव्हसू, का असोच एक पाप ला सोड़ो हुया, पापी को बारेमा, सरग मा परमेस्वर को, सरगदूत गीन खुस होवासेत। ");
INSERT INTO pwr_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","मंग यीसु ना कव्हयो, कोनी मानूस को दोन टूरा होतीन। ");
INSERT INTO pwr_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","उनमा लक लहान ना आपरो, बाबूजी लक कव्हसे, बाबूजी, धन मा लक जोन मोरो हिस्सा सेत, मोला देदे। वोना आपरो धन बाँट दियो। ");
INSERT INTO pwr_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","लगत दिवस बीत गयो, लहान टूरा सब धन जमा करके, ना लगत दूर देस मा जिंदगी बितान चले गयो। अखीन वहान आपरो धन खरचा कर डाखीस, अखीन कंगाल भई गयो। ");
INSERT INTO pwr_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","तबा उ देस मा गजब गीरानी पड गयो, अखीन वोको कन, जेवन लाय दाना नही होतो। ");
INSERT INTO pwr_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","तबा उ देस मा एक मानूस को, कन उ गयो, अखीन वोला वोना खालमानी चरावन को, लाय नौकरी मा राख लियो। ");
INSERT INTO pwr_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","वोको मालीक खालमानी गीन ला, खावन काजी जो सेंगा देवत होतो वोच ला उ लहानो टूरा भी खावत होतो। ");
INSERT INTO pwr_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","जबा उ एक दिवस सोचन लग्यो, मोरो बाबूजी को घर मा कितरो बनिहार सेत, उनला भरपेट जेवन भेटासे अखिन मी भूखो मर रहीसेव। ");
INSERT INTO pwr_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","अबा मी उठके, ना आपरो बाबूजी को कठा जाहू, अखीन वोको लक सांगू, का बाबूजी मी ना सरग को विरोध मा अखीन तोरो विरोध मा पाप करीसेव। ");
INSERT INTO pwr_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","अबा मी तोरो टूरा कहलान को, काबील नहिसेव, अबा मोला आपरो एक बनिहार जसो राखले। ");
INSERT INTO pwr_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","तबा उभो भयो अखीन आपरो, बाबूजी को कठा जावन लग्यो। वा अबा दूहूरच होत्यो, का वोको बाबूजी ना वोला चोवके उ तरस लक, भर गयो। अखीन परायके ना गरो लगाय लियो अना चुमन लग्यो। ");
INSERT INTO pwr_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","तबा टूरा ना वोला कव्हयो, बाबूजी मी ना सरग को विरोध मा अखीन तोरो नजर मा पाप करीसेव। अबा मि यो लायक नही सेव, का तोरो टूरा कहलाउ। ");
INSERT INTO pwr_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","पर वोना आपरो दास गीन ला कहीस, झटाक ना साजरो लक साजरो कपरा हेडके वोला पहनाव, अखीन वोको बोट मा मुन्दरी अना पायमा पनहि पहनवो। ");
INSERT INTO pwr_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","अखीन पलियो हुओ बोकरा आनके, मारो जेवन करो खुसी मनाओ। ");
INSERT INTO pwr_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","काहेका मोरो टूरा मर गयो होतो, मंग लक जित्तो भय गयो से। गुम गयो होतो, अबा मिल गयो से। अना सबा खुसी मनान लगीन। ");
INSERT INTO pwr_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","पर वोको मोठो टूरा खेत मा होत्यो। जबा उ घर को कठा, आयो ता वोना गानो बजानो को आवाज आयकिस। ");
INSERT INTO pwr_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","तबा दास ला हाकल के पुसिस, यो सबा काजक से? ");
INSERT INTO pwr_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","तबा वोना वोला कहीस, तोरो भाऊ आइसे, अना तोरो बाबूजी ना बोकरा कटवायो सेस। ");
INSERT INTO pwr_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","एको पर उ हिजड़ गयो अखिन भीतर नही गयो। तबा वोको बाबूजी वोला बाहेर आयके, वोला मनान लग्यो। ");
INSERT INTO pwr_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","तबा मोठयो टूरा ना आपरो, बाबूजी ला जवाब दियो, मि एतरो साल तोरो चाकरी करीसेव, अखीन मि तोरो हुकूम ला कभीच नही टालेसेव, तो तु ना कभी मोला सेरी को पाठी नही दियो से का मि आपरो संगी गीन को संग खुसी मनाऊ। ");
INSERT INTO pwr_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","पर जब तोरो लहान पोरगा, आयो जो रन्डीबाजि सरो धन खरचा कर दियो से मंग तू बोकरा कटवायो से। ");
INSERT INTO pwr_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","तबा बाबूजी कव्हसे बेटा मि हमेसा तोरो संग सेव जोन काही मोरोसे उ सबा तोरो से। ");
INSERT INTO pwr_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","पर अबा खुसी मनाव काहेका, तोरो लहान भाऊ मर गयो होतो, मंग जित्तो भई गई से। गुम गयो होतो अबा मिल गयो से। ");
INSERT INTO pwr_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","यीसु ना चेला गीनला कव्हयो, “एक धनवान को एक मूनीम होत्यो। धनवान को पूढा लोकगीन, कव्हन लगीन का खँजाचि तोरो, माल ला उड़वासे।” ");
INSERT INTO pwr_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","तबा धनवान ना मूनीम ला हाकल के, पुसिस, यो काजक आयकसु? तू आपरो हिसाब-किताब जचवा मि तोला नौकरी लक हेडसू। ");
INSERT INTO pwr_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","तबा दिवान कव्हसेत मि काय करु, माती खदन को ताकत नाहती यो काम तो मोरो लक, नही होयेत? मोला कोनी भिख भी नही देहेत, मालीक तो हेड देहेत। ");
INSERT INTO pwr_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","दिवान कसे तबा का करनो से मोला समजमा आय गई से। लोग गीनको फायदा कराय देसू, जोन मुसिबत मा काम आहेत। ");
INSERT INTO pwr_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","वोना आपरो मालीक को एक-एक करजदार गीन ला बुलायो अखीन पहलो ला पुछिस, तोरो पर कितरो करजा सेत? ");
INSERT INTO pwr_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","वोना कव्हयो तीन हजार लीटर जैतून तेल, तबा खंजाचि कव्हयो, आपरो करजा को रसिद आन बसके ना वोमा 15 संबर लीटर लिख दे। ");
INSERT INTO pwr_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","अखीन दुसरो ला पुसयो, तू कितरो को करजदार सेत? तबा वोना जवाब देइस, 100 मन गँहु तबा खंजाची ना कहीस, 80 लिख दे ");
INSERT INTO pwr_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","मालीक ना वो अन्यायी मूनीम को बडाई करीस, काहेका उ चलाकी लक काम करीस, यो जुग मा भी असोच लोग परमेस्वर को लोकगीन लक लगत चतुर सेत। ");
INSERT INTO pwr_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","एको लक मी सांगा सेऊ, यो अन्याय को धन लक, आपरो लाय असोच संगी बनाय लेव, जसो खंजाची ना बनायो होतीस, ताकि सरग मा तुमी अमर निवास मा रव्हने। ");
INSERT INTO pwr_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","जोन नहान-नहान गोस्टी मा बिस्वास काबिल सेत, उ लगत मा भी बिस्वास को काबिल सेत, अना जो लहान-लहान गोस्टी मा अबिस्वासी सेत, उ लगत मा अबिस्वासी ईमानदार सेत। ");
INSERT INTO pwr_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","अदी तुमी संसार को, धन मा बिस्वास को काबिल नही सेव, तो खरो धन परमेस्वर तुमी ला, काहे सौपे ");
INSERT INTO pwr_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","अदी तुमी परायो धन मा बिस्वास को काबिल नही सेव तो तुमरो आपरो, धन तुम्ही ला कसो मिलेहेत। ");
INSERT INTO pwr_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","कौनी मानूस दुई मालीक को चाकरी नही कर सका; उ एक लक बैर धरे अखीन, दुजो लक माया धरे या एक ला, आदर देहेत अखीन दुजोलक अपमान करयेत, तुमी परमेस्वर अना धन दुई को सेवा एक संग नही कर सकसेव। ");
INSERT INTO pwr_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","मोसे को नियम को गुरू गिन धन-दौलत लक माया करत होतीन एकोलाय, यीसु को गोस्टी आयक के मजाक उड़ावत होतीन, ");
INSERT INTO pwr_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","एको पर यीसु ना कव्हयो, तुमी लोकगीन को पुढ़ा सच्चो होवन को ढोंग करासो पर परमेस्वर तुमरो दिल ला जानासे, जोन चीज मानूस को नजर मा उच्चो से दुनिया को धन-दौलत, वा परमेस्वर को नजर मा बेकार से। ");
INSERT INTO pwr_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","मोसे को नियम अना भविस्यवक्ता योहन बप्तिस्मा देवन वालो तकन रहयो, वोना बेरा लक परमेस्वर को राज को साजरो बारता, आयकोआय रव्होसेत, अना हरेक वोमा जान काजी जबरन कोसीस करासेत। ");
INSERT INTO pwr_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","बादल अना धरती दुई सरक जाहेत, पर मोसे को नियम को एक-एक गोस्टी नही टलयेत बल्कि सबा पूरो होयेत। ");
INSERT INTO pwr_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","जोन नवरा अपरी बायको ला छोड़के अना दुसरो पाठ करयेत, उ वोको संग छिंडरापन करासे, अना जो अपरो नवरा ला छोड़के, दुसरो मानूस लक संग रव्होसे, व वोको संग पाप करासे। ");
INSERT INTO pwr_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","एक धनवान मानूस रव्हत होतो। उ गजब मंहगो ऊचो-ऊचो कपरा घालत होत्यो, अना रोज साजरो-साजरो जेवन करत होतो। ");
INSERT INTO pwr_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","वोको घर को बेसकूड़ मा एक गरिब लाचार मानूस पडयो रहत होत्यो, वोको नाव लाजर होत्यो, वोको आँग भर फोडा-फुन्सि होत्यो। ");
INSERT INTO pwr_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","उ धनवान मानूस को जूठो-काठो गिरो-पड़ो जेवन जेत होत्यो, अखीन कुतरा वोको फोडा ला जिबली चाटत होत्यो। ");
INSERT INTO pwr_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","उ गरिब एक दिवस मर गयो, अखीन सरगदूत वोला धरकेना अबराहम को कोरा मा राखदेइन। मंग धनवान भी मर गयो, अना वोला भी माती देइन। ");
INSERT INTO pwr_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","उ नरक मा दूख भोगन लग्यो, आपरो डोरा वरता उठायके ना, दूर लक अबराहम अखीन वोको कोरा मा गरिब लाजर ला चोवयो। ");
INSERT INTO pwr_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","वोना हाकलिस, अबराहम दादजी मोरो पर दया कर, अखीन लाजर ला धाड़, उ आपरो बोट ला पानी मा फिलायके, मोरो तोन्ड मा डाखेत काहेका, मि इस्तो मा तड़पासू। ");
INSERT INTO pwr_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","तबा अबराहम ना वोला सांगिस, हेतकर मोरो लाल, तोरो जीवन मा कसो-कसो सुख मिलिसेस, अखीन लाजर को जीवन मा कितरो मोठो-मोठो दुख होतो, अबा वोला चैन मिलि सेस, अना तोला दुख। ");
INSERT INTO pwr_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","अखीन तोरो अना हमारो, बिच मा गहरो खोदरा सेत, एको लाय यदि कोनी तोरो कठा, जावन चाव्हासे, तो भि नही जाय सकत, ना कोनी वोना गन लक एनागन आय सकत। ");
INSERT INTO pwr_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","तबा धनवान ना जवाब दियो दादजी, मोरो बिनती सेत क लाजर ला मोरो बाबूजी को गाँव मा धाड, ");
INSERT INTO pwr_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","काहेका मोरो पाँच भाऊ सेत, उ उनको पुढ़ा एना गोस्टी ला चेतायेत, असो नहोय की वय भी एना तकलीफ की जघा मा आहेत। ");
INSERT INTO pwr_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","तबा अबराहम ना कव्हयो, उनको कना मोसे को नियम अना भविस्यवक्ता गिनको पवीतर गिरंथ से, वय उनको गोस्टी मानेत ");
INSERT INTO pwr_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","तबा धनवान मानूस कव्हासे, अबराहम दादजी, वोना कहान आयकेसी? पर मूरदा लक कोनी उनको कठा जाहेत, तबा वय पस्तावा करके ना मन बदलेत। ");
INSERT INTO pwr_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","एको पर अबराहम कव्हसे, जबा वय मोसे को नियम अना भविस्यवक्ता गिनको पवीतर गिरंथ को नही मानासे, तो कोनी मूरदा लक, जी उठेत ता वोको भि नही समजेत। ");
INSERT INTO pwr_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","यीसु ना आपरो चेला गीन, ला कव्हासे, “पक्को पाप को लोभ मानूस को पूढा जरुर आहेत, मंग उ मानूस ला धिक्कार सेत, जोन को लक मानूस पाप को लोभ मा पड़ासे! ");
INSERT INTO pwr_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","जोन मानूस ऐना लहान लोक गीनको पाप को कारन सेत, वोको सजा यो से का, गरो मा चकिया को गोटा बान्धके, ना सागर मा डाख दियो जाये।” ");
INSERT INTO pwr_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","“एकोलाय सतरक रव्हने, अदी तुमारो कोनी भाऊ गलति पाप करासे ता वोला नोको डाटो पर समजा लेव, अखीन उ पस्तावा करासे, ता वोला छिमा कर। ");
INSERT INTO pwr_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","अदी कोनी दिवस मा सात बार तोरो विरोध मा पाप करासे, अखीन पस्तावा के छिमा मांगासे ता छिमा करदेव।” ");
INSERT INTO pwr_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","तबा चेलागीन पिरभू ला कव्हासेत, आमरो भरोसा ला बढ़ाव, ");
INSERT INTO pwr_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","पिरभू कव्हासेत, अदी तुमला राई को दाना बरोबर भरोसा होत्यो, अना सहतूत को झाड़ ला हुकूम देवतो, का उखड अना सागर मा लगी जाय! ता उ तोरो हुकूम ला मानतो। ");
INSERT INTO pwr_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“यदि तुमारो दास नांगर धरकेना खेत लक लवटसे, या सेरकी सेरी चरा के ना लवटासे, तो तुमी मा लक असो कोन सेत? जोन सांगेत आ अबा जेवन करले। ");
INSERT INTO pwr_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","अना यो नही कहे, की मोरो जेवन तैय्यार कर, अना मि जबा तकन जेव नही लेऊ, तबा पासुन तैय्यार रव्हके मोरी सेवा कर, एको मंघा तु भी जेव लेजोस। ");
INSERT INTO pwr_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","का मालीक आपरो दास ला एको, लई धनबाद देनो चाव्हासे, का ओना कव्हनो मानीसेस? ");
INSERT INTO pwr_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","हमी भी वसोच सेजन, जसो सबरई हुकूम को माननो को मंघ, हमी नालायक दास सेजन, काहेकी हमना अपरो करम करी सेजन।” ");
INSERT INTO pwr_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","यीसु येरुसलेम नगर जावत-जावत सामरिया अना गलील, परदेस को सिवमेढो मा लक होय कना, जाय रहिया होतिन। ");
INSERT INTO pwr_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","कोनी गाँव मा धसीन, ता उन ला दहा कोढी मिलिन वय गाँव को सिव मेढो पर उभा होतिन। ");
INSERT INTO pwr_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","वय उच्चो आवाज मा कहिन, का यीसु हमरो पर दया कर! ");
INSERT INTO pwr_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","यीसु ना उनला चोवके उनला कहीस, जावो! “अना अपरो आप ला याजक ला देखाव” जबा वय जाय रहया होतीन, त रास्ता मा च साजरा भय गईन। ");
INSERT INTO pwr_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","तबा वोमा लक एक असो चोय केना, का मी सजरो भय गयो कहेकर उच्चो आवाज लक, परमेस्वर को पिराथना बड़ाई करत, लवट गयो। ");
INSERT INTO pwr_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","उ यीसु ला धन्यवाद देता-देता वोको पाय पर टोन्ड को बल पड़ गयो, अना उ सामरी होतो। ");
INSERT INTO pwr_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","एको मघा यीसु ना सांग्यो, “का दहा साजरो नही भयो, तो मंग नउ कहान सेत? ");
INSERT INTO pwr_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","अखीन ऐना परदेसी ला छोड़ केना, असो कोनी नई हिटयो जेव लवट केना, परमेस्वर की बड़ाई करतो?” ");
INSERT INTO pwr_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","तबा यीसु न वोको लक कहीस, “का उभो होय जाय काहेका, तोरो भरोसा ना तोला साजरो करीसेस।” ");
INSERT INTO pwr_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","एक बेरा मा मोसे को नियम को गुरू ना यीसु लक पुसिस, का परमेस्वर को राज कबा आहेत? तबा यीसु न वोला जवाब दियो, “परमेस्वर को नही चोवन वारा रुप मा राज आहेत, काहेका वा परगट नाहत। तो लोग गीनला कसो चोहेत? ");
INSERT INTO pwr_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","लोक यो नही सांगासे ता चोवो उ यहान से उता सेत, काहेका परमेस्वर को, राज तुमारो बीच मा सेत।” ");
INSERT INTO pwr_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","यीसु ना आपरो चेला गीनला सांगिस, एक बेरा असो आहेत, जबा तुम मानूस को टूरा एक दिवस चोवनो चाव्हने, पर वोला नही चोवने। ");
INSERT INTO pwr_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","लोक तुम्ही लक कव्हेत, चोवो उ वहान से, चोवा उ यहान से, ता तुमी उता नोको जावने, अखीन उनको मंघा नोको जावने। ");
INSERT INTO pwr_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","काहेका जसो बादल मा बिजली कड़कासे अखीन यो छोर लक उ छोर तकन चमका से, वसोच तुमी मानूस को टूरा को आवन को बेरा होयेत। ");
INSERT INTO pwr_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","पर पुढा बेजा दुख उठानो पडे़त, यो जरुरी सेत का लोक गीन, वोला नकारेत। ");
INSERT INTO pwr_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","जसो भविस्यवक्ता नूह को बेरा मा हुओ होत्यो, वसोच मानूस को टूरा को दिवस मा भी होयेत। ");
INSERT INTO pwr_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","भविस्यवक्ता नूह को पानी जहाज मा बसन तकन, लोकगीन जेवन अना सादी ब्याह करत होतीन। तबा परलय आयो अना सबला बुड़ा देइस अना सबा सत्यानास भई गइन। ");
INSERT INTO pwr_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","लूत को बेरामा भी असोच भयो, लोग जेवन करत रहयो, घर बनावत होत्यो पौधा लगावत होतिन ");
INSERT INTO pwr_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","पर जोन दिवस लूत ना सदोम नगर सोड़यो परमेस्वर ना बादल लक स्तो बरसायके, सबला नास कर डाख्यो। ");
INSERT INTO pwr_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","मानूस को टूरा को आवन को बेरा मा असोच होयेत। ");
INSERT INTO pwr_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","वोना दिवस जोन अटारी मा सेत, वो समान लेवन लाय घर मा खाल्या नोको आहेत, अखीन जोन खेत मा सेत, उ मंघा नोको लवटे। ");
INSERT INTO pwr_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","लूत को बायको ला हेत करो। ");
INSERT INTO pwr_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","जोन आपरो जान सुरक्षीत रखनो चाव्हासे, उ वोला गुमा देहेत अखीन, जोन आपरो जान देहेत, उ जित्तो रहेत। ");
INSERT INTO pwr_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","मी तुम लक कव्हसू, वोना रात दूई झन एक खाट मा झोपेत, एक उचल लियो जाहेत, अखीन दुजो सोड़ दियो जाहेत। ");
INSERT INTO pwr_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","“दोन बाया संग-संग चक्कीया मा दरत रहेत अना एक ला उचल लियो जाहेती अखीन दुसरी ला सोड़ दियो जाहेती।” ");
INSERT INTO pwr_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","“दुई जन खेत मा सेत, एक उचल लियो जाहेत, अखीन दुजो सोड़यो जाहेत।” ");
INSERT INTO pwr_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","यो आयक के चेलागिन, न पुसयो, “हे पिरभू यो कहान, होयेत?” तबा यीसु ना कव्हयो, “जहान लास सेत, वहाँच गीधाड़ इक्कठो होवासे।” ");
INSERT INTO pwr_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","मंग यीसु ना हमेसा पिराथना करनो से, अखीन हिम्मत नही छोडनो से समझावन काजी, एक किस्सा सांगीस। ");
INSERT INTO pwr_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","कोनी नगर मा एक न्यायी रव्हत होतो, जोन नातो परमेस्वर को भगती करत होतो ना डरत होतो अना मानूस गीन को भेव खावत होत्यो। ");
INSERT INTO pwr_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","वोच नगर मा एक बेवा रव्हत होती, जो वोका कठा आय आयके, कव्हत होती, मोरो बदला, देव अखीन मोला, मुकदमा करन वालो लक बचा। ");
INSERT INTO pwr_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","काही बेरा तकन उ नही मानिस, पर आखीर मा मन मा बिचारन लगीस, का मोला ना तो परमेस्वर को भेव से ना ता कोनी लोकगीन को भेव सेत। ");
INSERT INTO pwr_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","पर मोला रोज वा बेवा परेसान कर डाखीस, एको लाय मी आज एको, न्याय कर देसू कही असो ना होयेत, का बार-बार आयके, ना मोरो नाक मा दम कर देहेत। ");
INSERT INTO pwr_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","यीसु पिरभू कव्हसे, आयको! यो अन्यायी न्यायी का कव्हसे? ");
INSERT INTO pwr_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","एकोलाय का परमेस्वर आपरो पूढा, बेचयो लोक गीनको, बदला लेहे जो रात दिवस, वोकी दोहाई देवासे। का उ उनको बारे मा देर करयेत? ");
INSERT INTO pwr_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","मी तुमरो लक कव्हसू, उ एक दम सटाकना उनको बदला लेहे, तबा मानूस को टूरा जबा आहेत त का उ धरती मा बिस्वास पाहेत? ");
INSERT INTO pwr_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","जोन आपरो उपर न्यायी होवनको, भरोसा राखत होतिन, उन लक एक उदाहरन सांगीस। ");
INSERT INTO pwr_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“दोन मानूस मंदिर मा पिराथना करन लाय, गइन एक मोसे को नियम को गुरू होतो, अखीन एक जमा लेवन वारा होतो।” ");
INSERT INTO pwr_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","मोसे को नियम को गुरू उभो-उभो असो, पिराथना करत होतो। “परमेस्वर मी तोला धनवाद देवासू, का मी दुसरो लोकगीन जसो, लोभी, अन्यायी, गलत काम करन वालो नहि सेव, अखीन यो जमा वसूली करन वालो, अन्धेर करन वालो जसो नही सेव। ");
INSERT INTO pwr_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","मी हफ्ता मा दूई दिवस उपास रव्हसू, अखीन आपरो सप्पा आय, को दसवा हिस्सा दान करासू।” ");
INSERT INTO pwr_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","जमा वसूली करन वालो, पापी अधिकारी काही दूहुर मा उभो होतो, वोला सरग कना, डोरा उठानो तकन को हिम्मत नही होतो। उ आपरो छाती पीट-पीट के ना कव्हत होत्यो, “परमेस्वर मोरो पर दयाकर।” ");
INSERT INTO pwr_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","यीसु ना कव्हयो, “मी तुमरो लक कव्हसू, उ पहलो नही पर यो मानूस पाप लक सूटकारा पाय के अना न्यायी ठहराय के आपरो घर गयो।” काहेका “जोन कोनी आपरो आप ला ऊचो करासे, उ खाल्या कियो जाहेत, पर जोन आपरो आप ला खाल्या करासे, उ ऊचो कियो जाहेत।” ");
INSERT INTO pwr_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","लोक गीन यीसु को कठा, लहान- लहान लेकरा ला जवर आनीन का उ उनला छिव दे। चेला गीन ना यो चोवके, ना डाटन लगीन। ");
INSERT INTO pwr_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","पर यीसु न लेकरा गीनला, आपरो जवर बुलायो, अखीन कव्हयो, लेकरा गीनला मोरो कठा, आवन देव, नोको मना करो, काहेका परमेस्वर को राज इनको जसा लोक गीनको सेत। ");
INSERT INTO pwr_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","मी तुमरो लक खरो कव्हसू, जोन मानूस लहान-लहान लेकरा गीन जसो, परमेस्वर को राज ला नही अपनायेत, उ वोमा कभी नही धसनो पाहेत। ");
INSERT INTO pwr_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","एक मुखिया ना यीसु लक असो पुसयो, ओ सब लक साजरो गुरु, अमर जीवन को वारसान, बनन लाय मी काजक करु? ");
INSERT INTO pwr_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","यीसु ना वोला सागीस, “मोला साजरो गुरू काहे कव्हसो? परमेस्वर ला सोड़ अखीन कोनी साजरो नहाय। ");
INSERT INTO pwr_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","तुमी सप्पा हुकूम ला तो जानसो, बूरो नजर लक नोको चोवो, छिनाली नोको करो, कोनी ला जान लक नोको मारो, चोरी नोको करो खोटो, गवाही नोको देव, आपरो माय बाप को आदर करो।” ");
INSERT INTO pwr_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","वोना जवाब दियो “यो सबा मी तो बचपन लक मानसू।” ");
INSERT INTO pwr_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","यीसु ना यो आयक के ओको, लक सांगीस, “तोरो मा एक बात की कमीसे। आपरो सप्पा बिग दे तिजोरी खोलके अखीन गरीब गोर मा बाट के ना मोरो मंघा आव। तब सरग मा धन मिल्हेत।” ");
INSERT INTO pwr_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","उ यो आयक के ना गजब उदास भय गयो, काहेका उ गजब धनवान होत्यो। ");
INSERT INTO pwr_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","यीसु ना वोला उदास चोवके ना कहीस, “धनवान लोक गीनको, परमेस्वर को राज मा धसनो कठीन सेत ");
INSERT INTO pwr_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","पर ऊँट को सूज्जी को नाक लक हीटनो सरल से। ” पर उनको परमेस्वर को राज मा धसनो कठीन से। ");
INSERT INTO pwr_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","येको पर आयकन वालो, लोक गीन कव्हन लगीन, तो कोन सूटकारा पाय सकासे? ");
INSERT INTO pwr_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","यीसु ना जवाब दियो जोन मानूस लक नही होय सकासे वा परमेस्वर कर सकासे। ");
INSERT INTO pwr_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","तबा पतरस ना कव्हयो, चोव, अमी लोकगीन आपरो सबा कही छोड़-छोड़ केना, तोरो माघा-मघा आय गयो सेजन। ");
INSERT INTO pwr_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","यीसु ना जवाब दियो, मी तुम्ही लोक हिनला खरो सांगसू, असो कोनी नहात जोन ना परमेस्वर को राज लाय, घर बार, अना बायको अना भाऊ गीन अना माय-बाबूजी अना बाल-बच्चा छोड़-छाड़ देईसेस। ");
INSERT INTO pwr_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","यो जुग मा वोला, कई गुना मील्हेत अखीन अमर जीवन भी मील्हेत। ");
INSERT INTO pwr_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","मंग यीसु बारा चेला गीनला अलग-थलग करके उन लक सांगीस, आयको हमी येरुसलेम नगर जाय रहयो सेत, मानूस को टूरा बारे मा जोन काही भविस्यवक्ता गीनना पवीतर गीरंथ मा लिखयो सेत, उ सप्पा पूरयो होवन वालो सेत। ");
INSERT INTO pwr_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","काहेकि मी गैरयहुदी गीनको हात मा सौप दियो जाहेत, वोना मोरो मजाक उड़ाहेत, मोरो बेईज्जती करयेत अना मोरो पर थूकेत। ");
INSERT INTO pwr_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","वय वोला कोड़ा मारेत अखीन मार डाखेत। पर उ तीन दिवस मा जित्तो भई जाहेत। ");
INSERT INTO pwr_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","उनला यो सबद समजमा नही आयो काहेका, परमेस्वर ना उनको, समज ला बंद कर दियो। ");
INSERT INTO pwr_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","जब यीसु येरीयो नगर को कठा पहुचयो, वहान एक अँधरा रास्ता को कीनार मा बसके, भीख माँग रहयो होतो। ");
INSERT INTO pwr_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","वोना भीड़ भाड़ जावन को आवाज आयकीस, अखीन पुसो यो काजक होवासे? ");
INSERT INTO pwr_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","तबा लोकगीन वोला सांगिन यीसु नासरी जाय रहि सेस। ");
INSERT INTO pwr_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","तबा उ जोर लक हाकलन लग्यो, “ओ यीसु दाऊद को खानदान मोरो पर दया कर!” ");
INSERT INTO pwr_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","तबा पूढा चलन वालो लोग गीन, ना चुप्प होवन काजी डाटन लगीन, पर उ अखीन जोर लक, वसोच हाकलीस। “ओ दाऊद को औलाद, मोरो पर दया कर।” ");
INSERT INTO pwr_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","यीसु थम गयो अखीन वोला वोको कठा, लावन को हुकूम दियो जबा उ जवर आयो, तबा यीसु ना पुछयो ");
INSERT INTO pwr_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","तु काजक चाव्हासे, मी तोरो लाय काजक करु? वोना जवाब दियो मालीक मी चोवन चाव्हासू। ");
INSERT INTO pwr_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","यीसु कव्हसे, तो चोव, तोरो भरोसा ना तोला साजरो करीसेस। ");
INSERT INTO pwr_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","वोच बेरा उ चोवन लग्यो, अखीन उ परमेस्वर को स्तुती बड़ाई करन लग्यो अखीन यीसु को, मघा जावन लग्यो सारी जनता यो चोवके, ना परमेस्वर को स्तूती करन लगीन। ");
INSERT INTO pwr_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","यीसु येरीयो नगर मा धसके, ना जाय रहयो होतो। ");
INSERT INTO pwr_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","वहान जक्कई नाव को एक मानूस होत्यो, जो जमा लेवन वालो को मुखीया होतो, उ गजब धनवान सेत। ");
INSERT INTO pwr_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","उ यीसु ला चोवनो चाव्हत होतो, उ चोव नही सकत होत्यो, काहेका उ खुज्जा होतो। ");
INSERT INTO pwr_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","वोना यीसु ला देखन काजी पुढा धावके, ना उमर को झाड़ मा चघ गयो, काहेका यीसु वोच रस्ता लक, जावन वालो होतो। ");
INSERT INTO pwr_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","जबा यीसु वोना जघा मा पहूचो तबा वरता, नजर घुमाय के कव्हन लग्यो, ओ जक्कई तू खटाक ने खाल्या आव! काहेका, आज मी तोरो घर मा रुकन वालो सेव। ");
INSERT INTO pwr_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","उ एक दम उतर केना, खुसी लक आपरो घर ले गयो। ");
INSERT INTO pwr_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","यो चोवकर सप्पा लोक गीन, कुड़ कुड़ा के कव्हन लगीन, उ तो एक पापी मानूस को, यहाँ पाहूना सेत ");
INSERT INTO pwr_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","जक्कई न उभो होयके पिरभू यीसु ला कव्हयो। हे मालीक चोव! मी आपरो धन को आरधो हिस्सा मी कंगाल गीन ला देवासू, अखीन काही अन्याव करके, ना राखीसेव तो वोला, मी चौगुना वापस देवासू। ");
INSERT INTO pwr_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","तबा यीसु ना कव्हयो, अबा यो घर मा सूटकारा आयो से, एको लाय का यो भी अबराहम को एक टूरा सेत। ");
INSERT INTO pwr_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","काहे का मानूस को टूरा गुमो हुओ ला ढुढ़न अखीन वोला सूटकारा देवन काजी आई सेव। ");
INSERT INTO pwr_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","जबा वोना यो गोस्टी ला आयकत होतिन, तो वोना एक उदाहरन सांगन लगीस। काहेका वय लोकगीन, येरुसलेम नगर को कठा होतिन अखीन उ समजत होतिन, का परमेस्वर को राज अबासीन आवन वालो सेत। ");
INSERT INTO pwr_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","एक धनी मानूस होतो, उ दुर देस जावन लग्यो, का राज पद पाय केना आपस लवट आयो। ");
INSERT INTO pwr_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","वोना आपरो दास मा लक, दहा ला बुलायके, ना उनला दहा मोहर दियो, अखीन कव्हयो मोरो लवट के आवत तकन धन्धा करने। ");
INSERT INTO pwr_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","पर उ नगर को रव्हासी गीन, वोको लक बैर राखत होतिन, अखीन वोको मंघा दूत गीन लक खबर पायो, हमी नही चाव्हसेत का तू आमरो पर राज करयेत। ");
INSERT INTO pwr_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","जबा उ राज पद पाय के, लवटो तो असो भयो का वोना, आपरो दास गीनला बुलायो, अखीन पुसन लग्यो का, कोन-कोन न कितरो कमाई सेस? ");
INSERT INTO pwr_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","तबा पहलो ना आयके कव्हयो, मालीक तोरो दहा मोहर लक मी अखीन दहा कमाई सेव। ");
INSERT INTO pwr_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","तब वोना कव्हयो वाह साजरो दास गीन, मा तू एकच बिस्वास को काबील सेस। अबा 10 नगर मा अधिकार राख। ");
INSERT INTO pwr_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","तबा दूसरो ना कव्हयो मालीक मी तोरो, मोहर लक पाँच मुहर कमाई सेव। ");
INSERT INTO pwr_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","तबा वोना वोला भी कव्हयो, तु पाँच नगर पर अधिकार राख। ");
INSERT INTO pwr_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","तीसरो ना आयके कव्हयो, हे मालीक देख यो तोरो मोहर से जसो को तसो मी गमछा मा बान्ध के राखी सेव। ");
INSERT INTO pwr_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","काहेका मी जानासू, तू गजब कठोर मानूस से एको, लाय मोला तोरो लक भेव लगीस, का कहि मी जानासू, जोन तू ना नही राखीसेस, वोला उचल लेवासे अखीन जो तू ना नही बोयो सेस, वोला काप लेवासे? ");
INSERT INTO pwr_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","तबा वोना वोला कव्हयो, हे दुस्ट दास! मी तोरो टोन्ड लक, हिटयो गोस्टी लक, तोला दन्ड देवासू, तू मोला जानत होतो का मी कठोर मानूस सेव, जो मीना नही ठेवी सेव, वोला उचल लेवासू, अखीन मी जो नही बोयि सेव, वोला मी कापसू। ");
INSERT INTO pwr_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","तो तूना यो मोहर ला माहाजन कठा ठेव देतो मी आकेना, ब्याज समेत ले लेतो। ");
INSERT INTO pwr_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","अखीन जोन कठा होतिन, उनलक कव्हयो का उ मोहर वोको लक, ले लेव अखीन जोको कठा, दहा मोहर सेत वोला, देदो। ");
INSERT INTO pwr_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","उनना कव्हयो, मालीक वोको, कठा तो दहा मोहर सेत। ");
INSERT INTO pwr_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","मी तुम्ही लक कव्हसू, का जोको कठा सेत, वोला अखीन दियो जाहेत, अखीन जोको कठा नही सेत, वोको लक जो सेत, वे भी ले लियो जाहेत। ");
INSERT INTO pwr_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","पर मोरो उन बैरी गीनला जोन नही चाव्हत, होतिन का मी राज करु, उनला आन केना मार डाखो। ");
INSERT INTO pwr_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","अखीन यीसु ये गोस्टी कव्हयो अना उ येरुसलेम नगर को कना, उनको पूढा चलयो। ");
INSERT INTO pwr_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","जबा यीसु जैतून पहाड़ को कठा, बैतफगे अना बैतनिय्याह गाँव को जवर पहूचयो, तबा वोना, दोन चेला गीनला ");
INSERT INTO pwr_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“असो सांगत पठाय दियो का पूढा को गाँव मा, जाव जबा तुम्ही वहाँन, पहूचजो तबा तुम्हिला, खूटा मा बन्धो एक गधी को बछेरु मिल्हेत, जोको पर अबा कोनी, सवारी नही करीसेन ");
INSERT INTO pwr_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","वोला छोड़ केना आनो यदि कोनी तुमला पूछेत, तो कव्हजोस का यीसु पिरभू ला, एको जरुरत से।” ");
INSERT INTO pwr_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","जोन चेला गीनला धाड़ीस होतीस, वोना जसो यीसु ना सांग्यो होतो, तसोच पाईन। ");
INSERT INTO pwr_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","जबा वय बछेरु ला छोड़त होतिन, तबा वोको मालीक आयकेना कव्हसे “तुम्हि काहे छोड़ोसो।” ");
INSERT INTO pwr_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","तबा उनना जवाब देइन का, “यीसु पिरभू ला एको जरुरत से, वोच हमीला धाडीसेस।” ");
INSERT INTO pwr_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","वय बछेरु ला वोको कठा, आनीन अखीन लोक गीन ना चद्दर बिछा के वोमा यीसु ला, बसाय देइन। ");
INSERT INTO pwr_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","जसो-जसो यीसु पूढा बड़तो गयो, लोक गीन वोको पूढा रास्ता मा, चद्दर बिछात होतिन। ");
INSERT INTO pwr_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","जबा वय जैतून पहाड़ को, उतार मा पहुचियो तबा सब चेला गीन, खुसी होयके ना जोन काम उनना चोयो होतो, उ सबा अचंभा होवन वालो काम को, हेत कर केना सबा लक, उच्चो आवाज मा परमेस्वर को, स्तुती करन लगीन ");
INSERT INTO pwr_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","धन्य से उ राजा जो पिरभू को, नाव लक आवासे सरग मा सान्ती सबा लक, ऊचो सरग मा महिमा। ");
INSERT INTO pwr_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","भीड़ मा काही मोसे को नियम को गुरू होतिन, वोना यीसु लक कहिन गरुजी चेला गीनला डटकार ");
INSERT INTO pwr_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","यको पर यीसु ना जवाब दियो “मी तुम लक कव्हसू, यदि वोना चूप रहयो, ता गोटा चिलावन लगेत।” ");
INSERT INTO pwr_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","जबा यीसु जवर आयो अना, नगर ला चोवयो अखीन उ रोवन लग्यो। ");
INSERT INTO pwr_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","अना बोलयो, “कितरो साजरो, होतो का तू आज को दिवस, यो समज पातो का कोनतो, बात मा तोरि सान्ती, से?” पर अबा यो बात तोरी डोरा लक लुको हुओ सेत। ");
INSERT INTO pwr_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","तोरो पर उ दिवस आहेत, जबा तोरो बैरी तोरो चारो लक घेर लेहति अखीन, तोरो पर दड़ब डाखेत। ");
INSERT INTO pwr_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","तोला अखीन तोरो मा निवास करन वालो, तोरि सन्तान ला माती मा मिला देहति, अखीन तोरो मा एक भी गोटा तरा उपर नही रव्हेत, काहेका तूना उ साजरो दिवस ला नही चिन्हिसेस, जब परमेस्वर ना तोरि सुधि लेइसेस। ");
INSERT INTO pwr_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","यीसु मंदिर मा धसिस अखीन, बिकन वालो ला यो सांगत बाहेर कहाडिस, का ");
INSERT INTO pwr_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","लिखो से परमेस्वर को घर पिराथना को, घर होयेत, पर तूमना वोला डाकू को, अड्डा बना दियो से। ");
INSERT INTO pwr_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","यीसु हर रोज मंदिर मा उपदेस देवत होतो, अखीन मोसे को नियम को गुरू मुखिया याजक अखीन, जनता गीन यो डाव ढुढत होतिन, का यीसु को कसो नास कियो, जाय। ");
INSERT INTO pwr_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","पर उनला नही सुझत होतो का, काजक करे? काहेका, जनता यीसु को बात लक खुसी होतिन। ");
INSERT INTO pwr_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","एक रोज यीसु मंदिर मा, जनता ला साजरो बारता सांगत होतो। का मोसे को नियम को गुरू, लेखक, मुखिया याजक ओको कठा आइन। ");
INSERT INTO pwr_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","अखीन वोला पुसीन, यो तू हमला सांग का कोनतो, अधिकार लक यो काम करासे? उ कोन आय जोना तोला यो अधिकार देइसेस? ");
INSERT INTO pwr_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","तबा यीसु ना जवाब दियो, मि भी तुम्ही लक एक सवाल पूसासू, अखीन तुमी सांगो ");
INSERT INTO pwr_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","योहन बप्तिस्मा देवन वालो को बप्तिस्मा, सरग कन लक होतो, का मानूस को कन लक होतो? ");
INSERT INTO pwr_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","वय आपसी मा सलाह करासे, हमि सरग कन लक सांगबीन तो उ कहेत, का तुम्ही योहन पर भरोसा काहे नही ठेवासो? ");
INSERT INTO pwr_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","अदी हमि सांगबीन का मानूस कन लक तबा जनता हमला गोटा लक मार-मार के ना मार डाखेत। काहेका लोक गीन ला यो भरोसा होतो, का योहन परमेस्वर को भविस्यवक्ता आय। ");
INSERT INTO pwr_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","एको लाय उनना जवाब दियो का, आमी नही जानसेजन, का योहन कोन कन लक से। ");
INSERT INTO pwr_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","एको पर यीसु ना उन लक, कव्हयो “तबा मि भी तुम्ही लक नही सांगसू, का मि कोनतो अधिकार लक यो काम करासू।” ");
INSERT INTO pwr_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","तबा यीसु जनता ला यो उदाहरन सागन लग्यो, एक किसान आपरी अंगूर को बारी, किसान गीनला ठेका मा देयके, ना गजब दिवस काजी, परदेस मा चले गयो। ");
INSERT INTO pwr_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","जबा बेरा भयो ता उ मालीक ना आपरो एक दास ला धाड़िस, का अंगूर को बारी को बटाई देय दे। पर किसान गीन वोला, मर-पीट के ना रिकामो हात पराय देइन। ");
INSERT INTO pwr_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","मंग उ मालीक ना दुसरो दास ला धाड़िस, अना वोला भि वसोच मार-पीटके ना रिकामो हात लवटा दियो। ");
INSERT INTO pwr_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","मंग मालीक ना तिसरो नौकर ला धाड़िस, अखीन उनना वोला भी घायल करके ना कहाड़ देइन। ");
INSERT INTO pwr_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","तबा अंगूर को बारी को मालीक ना सोचिस, का मी काय करू? मि आपरो चहेतो टूरा ला धाड़सु, साइद वोना लोक गीन वोको आदर करयेत। ");
INSERT INTO pwr_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","जबा किसान ना वोला चोविन तो, आपस मा बिचारन लगीन, यो ता ओको वारिस आय, आओ एला मार डाखो, का यो बारी हमेसा लक आमरो भई जाहेत। ");
INSERT INTO pwr_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","अखीन वोला अंगूर को बारी लक, बाहेर कहाड़ केना मार डाखिन। एकोलाय अबा अंगूर को बारी को मालीक उनको संग का, करयेत? ");
INSERT INTO pwr_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","उ आयके ना वोना किसान गीनला नास करयेत, अखीन अंगूर को बारी ला दुसरो ला देहेत। उनना यो आयक के ना ओला कहिन, परमेस्वर करे असो नोको होयहेत। ");
INSERT INTO pwr_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","वोना उनको कना चोवके ना कहीस, अखीन का लिखोसे? जोन गोटा ला मिस्तरी ना नकारो सेस, वोच कोनटा को सप्पा बजन सहन वालो, गोटा भई गईस। ");
INSERT INTO pwr_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","जोन कोनी वो गोटा मा पडे़त, चकनाचूर भई जाहेत। अखीन गोटा जोनको पर पडहेत उ पिस जाहेत। ");
INSERT INTO pwr_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","वोच बेरा मुखिया याजक, अखीन मोसे को नियम को गुरू लिखनवारा, समज गइन का यो उदाहरन आमरो पर लक सांगिसेस, ओना यीसु ला पकड़न चाहत होतिन, पर जनता लक भेव खाइन। ");
INSERT INTO pwr_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","वय यो ताका मा होतिन, का भेद लेवन काजी कोनि मानूस ला धाड़ेत जोन झुठो बहाना लक नेक बनके वोला कोनी ना कोनी गोस्टी मा पकड़ेत, अना वोला अधिकारी को हात को सुपरुत करहेत। ");
INSERT INTO pwr_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","वोना गीनना वोला पुसिन, हे गुरू हमि जानसेजन का तू खरो, सांगासेस अखीन सिकावासे। परमेस्वर को मारग खराई लक, सांगासेस अखीन कोनी, तरफदारी नही करासे। ");
INSERT INTO pwr_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","ता अबा सांग मोसे को नियम लक का अमीला राजा कैसर ला, जमा को सिक्का देवनो खरो, से का खोटो से? ");
INSERT INTO pwr_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","वोना उनको होसियारी, समज गयो अखीन कव्हयो, ");
INSERT INTO pwr_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","एक रुपया को सिक्का मोरो कठा आनो, तबा जनता लक पुछयो योमा कोन को छापा सेत अखीन कोको नाव सेत? लोगगीन कहिन राजा कैसर को। ");
INSERT INTO pwr_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","तबा उ उनला कहीस, जोन राजा कैसर को सेत, उ राजा कैसर ला देव, अखीन जो परमेस्वर को, से वो परमेस्वर ला देव। ");
INSERT INTO pwr_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","वय लोकगीन वोला मिसा लक पकड़न को ताका मा होतिन, यो काजी नेकी को भेस धरके ना काही लोक गिनला ओको कठा मिसा लक धाड़िन, का वय वोको कोनी सबद पकड़े, अखीन वोला अधिकारी गीन लक, सिकायत करके ना धराय देहत। ");
INSERT INTO pwr_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","एको बाद काही सदूकी गुरूगीन, यीसु को जवर आइन जोन मरन को बाद जी उचलनो नही मानत होतिन। उनना वोला यो सवाल करीन, ");
INSERT INTO pwr_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","गुरूजी, मोसे गुरूजी ना आमरो लाय, एक नियम बनाइसेस, का कोनी को भाऊ बिना सन्तान को मर जासे, तो वोको भाऊ उ बेवा ले बिहा करके ना आपरो भाऊ को, काजी सन्तान पैदा करेत। ");
INSERT INTO pwr_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","एक परिवार मा सात भाऊ होतिन मोठो ना बिहा करकेना नवरी आनीस, अखीन उ बझला मर गयो। ");
INSERT INTO pwr_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","दुजो अखीन तिसरो ");
INSERT INTO pwr_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","असो सातो भाऊ वा बायको, लक बिहा करके ना बिना सन्तान को मर जावासे। ");
INSERT INTO pwr_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","आखीर मा उ बायको भी मर जासे। ");
INSERT INTO pwr_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","अबा सांगो जित्तो होवनो को बाद मा वा बायको, कोन की बायको होयेत? उ तो सातो को बायको होति। ");
INSERT INTO pwr_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","यीसु ना कव्हयो एना जुग मा मरद-बायको, को बिहा होवासे। अखीन नवरा-नवरी होवासे। ");
INSERT INTO pwr_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","पर आवन वालो जुग मा जबा, सप्पा मुरदा जित्तो होवनो भई जाहेत, वहान बर-बिहा नही होयेत। ");
INSERT INTO pwr_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","पर सबा जी उचलनो को मंघा अमर होयके ना, सरग दुत जसो परमेस्वर को सन्तान बन जाहेत। ");
INSERT INTO pwr_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","पर यो गोस्टी को की मरयो हुयो जित्तो जित्ता होवासे, मोसे ना स्तो पेटायो झाड़ी को किस्सा मा सांगिसेस, जहान उ पिरभू कव्हासे का मि अबराहम, इसहाक अना याकूब को परमेस्वर सेउ। ");
INSERT INTO pwr_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","उ मुरदा को नही पर जित्तो को परमेस्वर सेत। कायको लाय का वोको, पूढा सबा जित्तो सेत। ");
INSERT INTO pwr_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","एको मंघा मोसे को नियम को गुरू अना लेखक गीन कहिन का, तू ना साजरो सांगिसेस। ");
INSERT INTO pwr_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","अखीन यीसु लक कोनी सवाल पुसन को, हिम्मत नही भयो। ");
INSERT INTO pwr_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","मंग यीसु ना उनला पुसयो, मसीह ला राजा दाऊद को, सन्तान काहे कव्हासेत? ");
INSERT INTO pwr_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","राजा दाऊद खुदच आपरो भजन को पवीतर किताब मा कव्हासे, परमेस्वर ना मोरो मालीक लक कव्हयो। ");
INSERT INTO pwr_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","मोरो उज्जो बस जबा तकन मि तोरो बयरी गीन ला तोरो पाँय को खाल्या को पीढ़ो नही कर देवासू। ");
INSERT INTO pwr_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","राजा दाऊद ता वोला पिरभू कव्हासे त मंग वा कसो वोको सन्तान से? ");
INSERT INTO pwr_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","जबा सबा लोक गीन आयकत होतिन, तबा वोना आपरो चेला गीनला कव्हासे, ");
INSERT INTO pwr_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","लेखक मोसे को नियम को गुरू ले होसियार रव्हो। जोन ला, लम्बो-लम्बो कपरा पहननो अखीन, फिरनो चाव्हासेत अखीन उनला, बजार मा नमस्कार अखीन, सभाघर मा उच्चो आसन ");
INSERT INTO pwr_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","वय बेवा गीनको घर अना धन चट करासे अना दिसावन को लाय लम्बो-लम्बो पिराथना करोसे, उनला कठोर दन्ड मिलहेत। ");
INSERT INTO pwr_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","मंग वोना डोरा उठय के, ना धनी गीनला आपरो-आपरो दान पेटी मा डाखत चोवो, ");
INSERT INTO pwr_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","वोना एक गरिब बेवा ला, वोमा दोन दमड़ी डाखत चोयो, तबा वोना कव्हयो, मि तुम्ही लक खरो सांगासू, का यो गरिब बेवा ना सबा मा बड़के दान डाखयो से। ");
INSERT INTO pwr_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","तबा वोना कव्हयो, मी तुम्ही लक खरोखर सांगासू, का यो गरिब बेवा ना सबा मा बड़के, दान डाखिसे। ");
INSERT INTO pwr_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","यो तो आपरो सप्पा कमाई को धन दान कर देइसेस, बाकि लोग गीन आपरो बढत लक, उलफा रुपिया डाखिन। ");
INSERT INTO pwr_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","जबा काही लोकगीन मंदिर को, बारे मा कव्हत होतिन, का यो कसो सुन्दर गोटा अना भेंट को, चीज लक सजायो गयो से? ");
INSERT INTO pwr_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","तबा यीसु ना कव्हयो, वोना दिवस आहेत, जोन मा यो जोन काही तूम्हि चोवासो, उनमा लक कोनी गोटा लक गोटा नही बचेत, सबा नास कर दियो जाहेत। ");
INSERT INTO pwr_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","उनना वोला पुसिन “हे गुरू यो सबा कबा होयेत? अना यो बात पूरो होवन को, का निसान सेत?” ");
INSERT INTO pwr_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","तबा उ कव्हसे “होसियार रव्हो का कोनी, तुमिला नोको भरमाय, काहेका गजब लोकगीन मोरो, नाव लक आहेत अखीन सांगेत, का मी वोच सेव अना यो, भी का बेरा जवर आय गयो से, तुमी उनको मंघा नोको जावने।” ");
INSERT INTO pwr_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","जबा तुम्ही लडाई-बलवा को, चरचा आयकने तो नोको, घबराने, इनको पुढा होवनो जरुरी से, पर वोना बेरा अन्त नही होयेत। ");
INSERT INTO pwr_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","तबा वोना उन लक कव्हयो, लोक पर लोक अखीन, राज पर राज चढ़ाई करयेत। ");
INSERT INTO pwr_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","अखीन मोठयो-मोठयो भुईडोल होयेत, अना जघा-जघा गिरानी पड़ेत, मरही आहेत अना वरता बादल मा, मोठो-मोठो निसान चोवेत। ");
INSERT INTO pwr_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","पर इनलक पूढा लोग मोरो नाव को कारन, तुमला धराय देहेत, अखीन तगांयेत अना सभाघर मा सोपेत, अना जेल मा डाख देयेत, अना राजा न्यायईगिन को पूढा लेजायेत। ");
INSERT INTO pwr_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","यो तुमारो लाय गवाही को बेरा होयेत। ");
INSERT INTO pwr_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","एकोलाय आपरो-आपरो, मन मा ठान लेवका हमि उनको पूढा का कव्हनो से? यो चिन्ता नोको करने। ");
INSERT INTO pwr_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","काहेका मि तुमीला असो बोल अना अक्ल देहू, का तुमारो विरोध करनवालो, काप नही सकेत। ");
INSERT INTO pwr_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","तुमारो माय-बाप अना, भाऊ कुटुम्ब, अना संगी भी तूमीला धराय देहेत, अना यहान तकन का तुमी लक कोनी-कोनी, ला मरवा डाखेत। ");
INSERT INTO pwr_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","मोरो नाव को कारन सबा लोक तूमी लक बैर करेत। ");
INSERT INTO pwr_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","पर तुमरो डोस्का को, एक चुन्दी भी नहीं उखान सकेत। ");
INSERT INTO pwr_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","पर आपरो धिरज लक, तूमी आपरो पिरान बचाय राखो। ");
INSERT INTO pwr_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","जबा तूमी चोवने का, येरुसलेम नगर सेना लक, घिरो सेत तबा जान लेवने, का वोको नास कठा सेत। ");
INSERT INTO pwr_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","वोना बेरा जो यहुदिया परदेस मा सेत, उ पहाड़ी मा पराय जाय, अना जोन येरुसलेम नगर को भीतर सेत, उ बाहेर हीट जाय, अखीन जोन देस मा नाहती उ सहर मा नोको जाय। ");
INSERT INTO pwr_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","काहेका उ बदला को दिवस होयेत, जोन मा पवीतर गिरंथ मा लिखयो सबा बात पूरो भई जाहेत। ");
INSERT INTO pwr_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","वोना बायको को लाय, दूख को दिवस होयेत, जोन पेट ले सेत, अना वा लेकरा ला दूध पिलाय सेति। काहे का धरती मा गजब मोठो विपदा आ जाहेत। ");
INSERT INTO pwr_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","लोकगीन तलवार लक, काप दियो जाहेत। अना उनला बन्दी बनाय के ना, गैरयहुदी लोकिगीन मा लीजाय लेहेत। अना गैरयहुदी लोकगीन को लक, येरुसलेम नगर, जबा तकन बेरा पूरो ना भई जाय रवदो जाहेत। ");
INSERT INTO pwr_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","दिन-चन्दा तारा मा हिदान होयेत, सागर गरजेत अखीन पूरा-पानी लक, धरती को सबा मानूस लोक घबरा जाहेत। ");
INSERT INTO pwr_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","भेव को कारन मा अना संसार मा होवन वारा अचंभा को काम को कारन आवनवालो बेरा को बाट जोहत-जोहत, लोकगीन को जान ठिकानो पर नही रहेत। काहे का बादल को ताकत डुलायो जाहेत। ");
INSERT INTO pwr_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","तबा उ मानूस को टूरा मोठो ताकत न महिमा को, संग बादल म आवत चोहेत। ");
INSERT INTO pwr_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","जबा यो बात होवन लगेत, तबा आपरो, मान सीधो करके ना उठने, काहेका तुमारो सूटकारा जवर होहेत। ");
INSERT INTO pwr_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","वोना एक उदाहरन लक समजायो, अँजीर को झाड़ ला चोवो, ");
INSERT INTO pwr_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","जबा उन मा नवा पान आवासे, तबा तुम्ही जान लेवासो का उनहारी को मौसम आय गयो सेत। ");
INSERT INTO pwr_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","तुमी जबा असो होवत चोवने, तबा यो जान लेने का परमेस्वर को राज जवर सेत। ");
INSERT INTO pwr_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","मी तुम्ही लक खरो सांगासू, का जबा लक यो बात नही होयेत, यो पीढ़ी को अन्त नही होयेत। ");
INSERT INTO pwr_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","बादल अना धरती टल जाहेत, पर मोरो बात नही टलहेत। ");
INSERT INTO pwr_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","एकोलाय होसियार रव्हने, असो ना होहेत एने जीवन को, भोग-विलास, नसा-पानी अना संसार को, चिन्ता मा तुमारो मन लग जाहेत, अना एकदम वोना दिवस जाल जसो आ जाहेत। ");
INSERT INTO pwr_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","काहेका धरती मा रव्हन वालो, सबा पर असोच एकदम लक आफत आ जाहेत। ");
INSERT INTO pwr_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","एकोलाय जागतो रव्हो अखीन, पिराथना करो का आवन वालो घटना लक, बचके न असो ताकत लक भर जावो का मानूस को टूरा पुढा उभो रह सको। ");
INSERT INTO pwr_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","यीसु दिवस मा मंदिर मा उपदेस देवत होतो, अना रात मा उ नगर को बाहेर हिटके ना जैतून पहाड़ मा रात बितात होतो। ");
INSERT INTO pwr_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","अना पहेट मा उपदेस आयकन काजी मंदिर मा लोक आवत होत्यो। ");
INSERT INTO pwr_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","बेखमिरी भाकर को तिहार जोन ला, बलिदान तिहार कव्हसेत, जवर आय गई। ");
INSERT INTO pwr_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","मोसे को नियम को गुरू अना लेखक, मुखिया याजक, यीसु ला मार डाखन को उपाय ढूढत होतिन, पर वय जनता लक भेव करत होतिन। ");
INSERT INTO pwr_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","वोना बेरा मा सैतान ना यूदस इस्करियोति, मा धस गयो, यूदस बारा चेला मा एक होत्यो। ");
INSERT INTO pwr_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","वोना मोसे को नियम को गुरू अना मुखिया याजक लक, यीसु ला धरान को बारेमा चरचा करीस, का यीसुला उनको, हात धराय देयेत। ");
INSERT INTO pwr_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","वोना खुस भई गयिन अना धन देवन को लोभ देईन। ");
INSERT INTO pwr_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","यूदस भिड लक अलग यीसुला, धरान को डाव ढुढन लगिस। ");
INSERT INTO pwr_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","बेखमिरी भाकर को दिवस आयो, वोना दिवस पाठी को बलिदान करनो जरुरी होत्यो। ");
INSERT INTO pwr_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","यीसु पतरस अना योहन ला यो सांगके धाड़िस, “जाओ बलिदान तिहार को तैयारी करो, का अपन सबा संग-संग जेवन करबीन।” ");
INSERT INTO pwr_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","उनना यीसुला पुसिन, “कहाँ तैयारी करबीन हमला सांग का तोरो मन मा काय सेत?” ");
INSERT INTO pwr_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","यीसु ना जवाब दियो, “जसो नगर मा धसने वसोच तुम्ही ला, एक मानूस घघरा मा पानी लेयके जावतो चोयेत, वोको मघा-मघा जावने अना उ जोन घर मा जायेत, वोच घर मा जावने। ");
INSERT INTO pwr_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","अना उ घर को मालक ला सांगने का, गुरूजी यहान बलिदान तिहार मनानवालो सेत, मिजवान खोली कोनतो से? जहा उ आपरो चेला गीनको संग जेवन करहेत। ");
INSERT INTO pwr_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","उ तुमला सजो अटारी मा खोली दिसाएत वहाँच तैयारी करने।” ");
INSERT INTO pwr_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","वोना चले गइन अखीन यीसु ना जसो सांगो होतो, वसोच पाइन अखीन वहान बलिदान तिहार को जेवन तैय्यार करन लगीन। ");
INSERT INTO pwr_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","जबा बेरा भयो, तबा यीसु चेला गीनको संग जेवन लाय बस्यो। ");
INSERT INTO pwr_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","यीसु ना उनलक कव्हयो, “मोरो दिल मा यो गोस्टी होत्यो, का मी को बलिदान तिहार मा तुमारो संग मा जेऊ। ");
INSERT INTO pwr_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","काहेका जबा तकन परमेस्वर को, राज पूरो रिती लक नहि आ जाहेत, मी मंग जेवन नहि करु।” ");
INSERT INTO pwr_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","एको मंघा यीसु ना बटकी लियो, अना परमेस्वर ला धनवाद देके कव्हयो “एला, आपसी मा बाट लेने ");
INSERT INTO pwr_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","काहेका मि तूमी लक कव्हसू, का अज को मघा जबा तकन परमेस्वर को राज पूरी रिति लक नही आ जाहेत, मी अंगूर रस नही पिवन को।” ");
INSERT INTO pwr_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","यीसु ना भाकर लियो अखीन, परमेस्वर लक पिराथना करके चेलागिन ला भाकर दियो, अखीन सांगीस यो मोरी देह आय, मोरो हेत करन को लाय असोच करने। ");
INSERT INTO pwr_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","यो जेवन को बाद मा यो सांगत बटकी दियो अना कहो, “यो बटकी मोरो रकत को वायदा को नवतो करार सेत जो तुमरो लाई बहायो गयो से।” ");
INSERT INTO pwr_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","चोवो! जोन पातर मा जेवसे, वोच मा छेद करन वारा मोरो, संग से अखीन वोको हात ठाव मा से। ");
INSERT INTO pwr_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","काहेका मानूस को टूरा ता जसो वोको लाय पक्को, करयो गयो से वसोच होहेत। “पर धिक्कार से वो मानूस ला, जो वोला धराय रहीसेस।” ");
INSERT INTO pwr_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","वोना एक दूजो लक पूसन लग्यो का, हमी लोक गीनमा कोन सेत? ");
INSERT INTO pwr_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","चेला गीन मा विवाद बड़ गयो का, हमरो मा मोठयो कोन से? ");
INSERT INTO pwr_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","तबा यीसु ना कव्हयो, “गैरयहुदी लोकिगीन को, राजा उन पर सासन करासे, अना जोन उन पर अधिकार राखासे, उ उपकार करन वालो कहलावासे”। ");
INSERT INTO pwr_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","पर तुमी असो नोको होवने, पर जो तुमरो मा मोठयो से, उ लहान जसो अना जो मुखिया से उ सेवा करन वालो को जसो बनेत। ");
INSERT INTO pwr_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","कायलाई का मोठयो कोन से, जो जेवन करन बस्यो से? का उ जोन सेवा करासे ? का उ नही जो जेवन करन बसो सेस? पर मी तुमारो बीचमा नौकर जसो सेव। ");
INSERT INTO pwr_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","पर तुम्ही मोरो परिक्सा मा, हमेसा मोरो सगं रहयो। ");
INSERT INTO pwr_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","अना जसो परमेस्वर ना मोरो लाय एक राज ठयरायो से। ");
INSERT INTO pwr_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","वसोच मी तुमारो लाया ठयरावासू, जोन लक तुम्ही मोरो राज मा मोरो संग राजगद्दी मा बसो, संग जेवन करो, अना इसरायल राज को 12 गोत को नियायी बन जाओ। ");
INSERT INTO pwr_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","पतरस ओ समौन चोव सैतान ना तुम्ही लोग गीनला मांग लियो से का गँहु जसो तुम्ही ला फटके। ");
INSERT INTO pwr_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","पर मी तोरो लाय पिराथना करूसेव का तोरो भरोसा, ना चलो जाय, अना जबा, तु वापस आवजोस, ता आपरो संगी भाऊ गीनला थामजोस। ");
INSERT INTO pwr_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","पतरस ना वोला कहीस, का पिरभू!मी तोरो संग मा जेल जान लाय अखीन मरन लाय राजी सेव। ");
INSERT INTO pwr_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","पर यीसु न कव्हयो, पतरस मी तोरो लक कव्हसू का आज कुकड़ा को चिल्वनो को पूढा, तू मोला तीन बार नकारजोस। ");
INSERT INTO pwr_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","यीसु ना चेला गीनला कहीस, जबा मीना पियुसी, झोला अखीन सेंडिल को, बिना धाड़यो होतो तबा, “काही चीज की कमी भई का?” ");
INSERT INTO pwr_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","वय जवाब देईन का कोनी चीज की नहीं, एतरो पर यीसु ना कव्हयो, पर अबा मी कव्हसू अबा जेनको, कठा पियुसी से वोला धर लेव वसोच, झोला अखीन तरवार आपरो झंगा बिक केना आनलो। ");
INSERT INTO pwr_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","काहे का मी तुम्ही लक कव्हसू, का यो जोन लिखयो से का उ दोसीगीन को संग गिनो गयो। वोको मोरो पर पूरो होवनो जरुरी से, काहेका मोरो बारे मा यो गोस्टी पूरो होवनो पर सेत। ");
INSERT INTO pwr_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","उनमा कव्हयो, हे पिरभू चोव यहान दोन तरवार सेत! वोना कव्हयो लगत से? ");
INSERT INTO pwr_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","तबा उ बाहेर हिटके आपरो आदत लक जैतून पहाड़ मा गयो अना चेला गीन, उनको मंघा भई गइन। ");
INSERT INTO pwr_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","वोना जघा पहूचकेना वोना उन लक, कव्हयो तुम्ही परिक्सा मा नोको, पडजोस यो काजी पिराथना करो। ");
INSERT INTO pwr_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","तबा उ काही जरासो दूरी बनाय के, ना चेला गीन लगी अलग पिराथना करन लग्यो। ");
INSERT INTO pwr_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","हे परमेस्वर मोरो बाप, यदि तोरी इक्सा से तो यो दुख ला मोरो पूढा लक हटाय, ले। मंग मोरो नही तोरो मनसा, मोरो जीवन मा पूरो होहे। ");
INSERT INTO pwr_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","तबा यीसु ला एक सरगदूत दिख्यो, जोना, वोला ताकत देतो रहयो। ");
INSERT INTO pwr_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","यीसु संकट लक दूखी भय गयो अखीन गजब दूखी मन लक परमेस्वर लक पिराथना करन लग्यो। अखीन वोको पसी रकत को बुन्द जसो, थेम-थेम जघा मा टपकन लगीन। ");
INSERT INTO pwr_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","तबा उ पिराथना करके ना उठयो, तबा आपरो चेला गीन, को जवर आयो चेला गीन उदास मन लक सो रहयो होतीन, तबा यीसु ना कव्हयो, तुमी काहेला सोवसो। ");
INSERT INTO pwr_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","उठो अखीन पिराथना करो, क तुम्ही परिक्सा मा नोको पड़ो। ");
INSERT INTO pwr_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","तबा उ कव्हत होतो का एक भीड़ को, पूढा-पूढा, यीसु को चेला यूदस आयो, उ यीसु को कना चूमा लेवन काजी, बढयो। ");
INSERT INTO pwr_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","तबा यीसु ना कव्हयो हे यूदस का तू चुम्मा लेयके, मानूस को टूरा धरा रहोसे। ");
INSERT INTO pwr_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","तबा यीसु को चेला गीन कव्हन लगीन, पिरभू का हमी तरवार चलाबीन? ");
INSERT INTO pwr_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","अखीन उनमा लक एक ना तरवार कहाडके ना मुखिया पुजारी को, दास को जेवनो कान उड़ाय देईस। ");
INSERT INTO pwr_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","तबा यीसु न कव्हयो बंद करो यो खून खराबा, अखीन वोको कान ला, वोको जगहा मा धरके ना, साजरो कर दियो। ");
INSERT INTO pwr_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","तबा यीसु ना मुखिया पुजारी अखीन, मंदिर को रक्सक को मुखीया, अना सयानो गीन, जो वोना भीड़ मा लाठी-वाठी तरवार धरके ना आयो होतिन, उनला कव्हयो का तुम्ही मोला, डाकू वाकू समझकेन, हथीयार धर के मोला मारन आयीसेव। ");
INSERT INTO pwr_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","जबा मी मंदिर मा हर रोज तुमारो, संग होतो तबा तुमना मोला नही धरयात पर यो तुमारो बेरा से, वोका पर इन्धारो को अधिकार से। मतलब मोला मालूम से का सैतान मोरो, संग काजक करन वालो से। ");
INSERT INTO pwr_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","मंग वोला धरकेना, मुखिया याजक को घर मा पहूचा देइन। पतरस काही दूरी बनाय के, ना यीसु को मघा-मघा जावन लग्यो। ");
INSERT INTO pwr_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","अखीन आँगन मा अघेटा पेटायो होतीन, वहांच पतरस उनको बीच मा जायके बस गयो। ");
INSERT INTO pwr_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","एक टूरी जो उनकी दासी होती पतरस ला, स्तो को उजाड़ो मा, चोवके ना कव्हन लगीस, यो भी वोको संग होतो। ");
INSERT INTO pwr_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","पर पतरस मना करके ना कव्हासे, बाई मी वोला नही जानासू। ");
INSERT INTO pwr_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","जरा देर को मघा कोनी दूसरो ना पतरस ला चोवके कव्हयो, “तू भी वोमा लोक गीनको संगी मा लक एक आस! पतरस ना कव्हयो, नही भाऊ मी नही सेउ।” ");
INSERT INTO pwr_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","एक तासको बाद मा कोनी मानूस ना पक्को चीन्ह केना कव्हयो “खरो खर यो वोको संग होतो काहेका, यो भी गलीली मानूस से।” ");
INSERT INTO pwr_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","पतरस ना कव्हयो “हुट भाऊ, मी नही जानासू, का तुम्ही काजक सागसो?” उ जसो बोल रहयो होतो। वसोच कुकड़ा ना चील्लायो, कोक रे कोक। ");
INSERT INTO pwr_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","अना पीरभू ना लवट के पतरस कना चोवयो, तबा पतरस ला हेत आयो का पिरभू ना वोला, काय कव्हयो होतो? का अज कुकड़ा को चिल्लान को पूढा तो मोरो, तीन बेरा मुकर करजोस। ");
INSERT INTO pwr_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","अना उ बाहेरे हिटके ना बिलख-बिलख के रोवन लग्यो। ");
INSERT INTO pwr_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","यीसु को पहरा देवन वालो सीपाही गीन, यीसु ला मजाक मा उड़ान लगीन अखीन वोला मारन पीटन लगीन। ");
INSERT INTO pwr_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","ओनो डोरा मा पट्टी बान्धके ना वोला मारत होतिन अना कव्हत होतीन, का आवन वारो गोस्टी सांग अबा तोला कोन ना मारेत। ");
INSERT INTO pwr_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","अखीन उनना योको गजब निन्दा करके ना, वोको विरोध मा गजब गोस्टी सांगन लगीन। ");
INSERT INTO pwr_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","जबा दिवस हिटयो ता गजब सयानो, अना मुखिया याजक मोसे को नियम को गुरू गीन लेखक, इक्कठो भईन अना वोला, आपरो पंचायत मा आनके पुसन लगीन। ");
INSERT INTO pwr_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","अदी तुम्ही मसीह सेव ता हमला सांग! अना उनना कहीस, यदि मी तुम्ही लक कँहू ता, भरोसा नही करबीन। ");
INSERT INTO pwr_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","अना यदि मी पुसू ता जवाब नही देवजोस। ");
INSERT INTO pwr_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","पर अता मानूस को टूरा सबा लक मोठो, ताकत को परमेस्वर को उज्जो बस्यो चोवने। ");
INSERT INTO pwr_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","एतरो पर सप्पा को सप्पा सांगन लगीन, ता का तूच परमेस्वर को टूरा आस? यीसु ना जवाब दियो तुम्ही कव्हासो का मीच आँव! ");
INSERT INTO pwr_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","येको पर उनना कव्हयो “अबा आमला अखीन गवाही को, का जरुरत से?” आमी ना ता खुद वोकोच तोन्ड लक आयकसेजन। ");
INSERT INTO pwr_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","तबा सबा पंचायत उभो भय गइन, अखीन पिलातुस न्यायी को कठा ला गइन। ");
INSERT INTO pwr_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","अना सबा असो दोस लगावन लगीन, का यो राजा कैसर ला जमा देवन लाय मना करासे, अखीन आपरो आप ला राजा कव्हासे, अना लोग लोक गीनला राजा को खिलाफ भड़कावसे। ");
INSERT INTO pwr_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","तबा पिलातुस न्यायी ना पूसयो का यो बात खरो सेत? का तू यहूदी लोकी को राजा आस? तबा यीसु ना कव्हयो, तू खुदच सांगासे। ");
INSERT INTO pwr_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","तबा पिलातुस ना मोसे को नियम को गुरू अना, मुखिया याजक लोक गीनला सांगीस, मोला यो मानूस मा काही खोट नही चोवासे। ");
INSERT INTO pwr_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","पर वय मजबूती लक सांगीन, यो गलील परदेस लक सबा यहुदिया मा उपदेस देके ना, लोकगीन ला उकसावासे। ");
INSERT INTO pwr_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","यो आयक के पिलातुस ना पुसयो, का यो गलीली मानूस आय? ");
INSERT INTO pwr_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","अना यो जानके का यो राजा हेरोदेस को राज को अधिकार मा सेत, वोना वोला राजा हेरोदेस को कठा धाड़ीस, काहेका उ वोना दिवस मा येरुसलेम नगर मा होतो। ");
INSERT INTO pwr_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","राजा हेरोदेस ना यीसु ला चोवके गजब खुसी भयो, काहेका वोला गजब दिवस लक चोवन को आस होत्यो। काहेका व आयको होतो का यीसु गजब अचंभा भरो निसान चोवासेत। ");
INSERT INTO pwr_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","उ वोको लक गजब सवाल करत रहयो, पर यीसु उघा मुघा रहयो। ");
INSERT INTO pwr_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","अना पुरोहित अना मोसे को नियम को गुरू, मुखिया याजक देह मन लक वोको, पर दोस मढन लगीन। ");
INSERT INTO pwr_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","तबा राजा हेरोदेस ना आपरो सीपाही गीनको संग, वोला खरो-खोटो कव्हके वोको मजाक उड़ाइन, अना माजाकी कपरा घालके वोला, पिलातुस न्यायी को जवर लवटा देइन। ");
INSERT INTO pwr_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","वोच दिवस लक न्यायी पिलातुस अना राजा हेरोदेस संगी-संगी बन गइन, एको मंघा एकमेक को बैरी होतिन। ");
INSERT INTO pwr_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","पिलातुस न मोसे को नियम को गुरू अना मुखिया याजकगीन ला बुलाके सांगयो, ");
INSERT INTO pwr_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","“तुम्हिना यो मानूस ला जनता ला, बहकावन वालो सांग के ना मोरो कठा आनी सेव, अना मीना तुमरो पूढा जायके यो मानूस मा जाँच करयो, अना एकोमा कोनी खोट नही पाइसेव। ");
INSERT INTO pwr_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","न राजा हेरोदेस ना, काहेका वोना वोला मोरो कठा धाड़ देइसेस, अना चोवो, मी वोको मा असो खोट नही पायोसेऊ, का वोला पिरान दन्ड दियो जायेत। ");
INSERT INTO pwr_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","यो काजी मी वोला, पिटवा केना सोड़ देसू।” ");
INSERT INTO pwr_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","काहे का यो तिहार मा एक कैदी ला सोड़नो जरुरी होत्यो। ");
INSERT INTO pwr_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","पर सप्पा चिलावन लगीन, का अमरो काजी बरब्बा नाव को कैदी ला, सोड़ देव अना येला मार डाको। ");
INSERT INTO pwr_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","बरब्बा कोनी झगड़ा को कारन लक, बन्दी घर मा टाक दियो होत्यो। ");
INSERT INTO pwr_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","पर राजा पिलातुस ना यीसु ला, सोड़न को मनसा लक, जनता ला अखीन समजायो। ");
INSERT INTO pwr_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","पर जनता चिलान लगीन, का “ वोला कूरूस मा चघावो! कूरूस मा चघावो!” ");
INSERT INTO pwr_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","राजा ना तिसरो बार कव्हयो, “काहे यो मा कोनतो, खोट सेत?” मीना वोको मा कूरूस मा चघावन को लाय कोनी गोस्टी नही पाई सेव! एकोलाय मी वोला, पिटावाये केना सोड़ा सेऊ। ");
INSERT INTO pwr_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","पर जनता चिल्ला चिल्लाके, वोको मंघा पड़गइन, अना चिल्लानो गजब बढ गयो। अना चिलावन लगीन का, वोला कूरूस पर चघावो। ");
INSERT INTO pwr_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","तबा राजा पिलातुस ना हुकूम देइस, का उनको निरनय को अनूसार कियो जाय। ");
INSERT INTO pwr_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","तबा बरब्बा जोन हिन्सा अना जानलक मारन को आरोप मा होतो वोला छोड़ देइस, अना यीसु ला उनको मनसा को लक उनला सोप देइस। ");
INSERT INTO pwr_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","एक कुरेनी नगर को मानूस जोको नाव सिमोन होतो, उ गाव लक आ रहयो होतो। वोला धरकेना वोको पर कूरूस ला लाद देइन, अना वोला यीसु को मंघा मंघा चलन को हुकूम देइन। ");
INSERT INTO pwr_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","जनता को गजब भीड़ उनको मंघा- मंघा चल रहयो होतिन। उनमा काही आई माई होतिन, जो आपरो छाती पीटत वोको लाय रोवत होतिन। ");
INSERT INTO pwr_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","यीसु ना उनको कन मुरक के कव्हयो, वो येरुसलेम नगर को टूरी तुम्ही मोरो लाई नोको, रड़ो पर आपरो लाय अना आपरो, लेकरा गीन लाई रोओ। ");
INSERT INTO pwr_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","काहेका उ दिवस आय आहेती, जबा लोक गीन कहेत का वा बायको धन्य से जो वाखाड से, अना लेकरा को जलम पासुन दुध नही पिवाइसेस। ");
INSERT INTO pwr_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","तबा लोक गीन पहाड़ी ला कहेत, का आमरो पर पहाड़ी पड़ जाय अना पहाड़ ला कहेत, का हमला ढाक लेव। ");
INSERT INTO pwr_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","काहे का यदि कोनी हरो-भरो झाड लक असो करासेत, ता वोको सूक्को काड़ी को काजक हाल होवते। ");
INSERT INTO pwr_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","वय यीसु को संग दूई आपराधी गीन ला मारन लाय ले गइन। ");
INSERT INTO pwr_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","वय कवटी नाव की जघा मा पहूचीन वहान, उनना यीसु ला अना दोन अपराधी इनला कूरूस पर चघाइन, एक ला वोको उज्जो कन अना दुजो ला डाख्या कना। ");
INSERT INTO pwr_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","यीसु ना कहीस, हे बाबूजी इनला, छिमा कर काहेका यो नही जानासे, का यो काजक कर रहीसेत, तबा उनना चिठ्ठी टाक केना यीसु का कपरा ला आपस मा बाट लेइन। ");
INSERT INTO pwr_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","जनता उभी होयके यो सब चोय रही होतीन। मुखिया गीन यो कहके, येसु को मजाक करत होतीन, का वोना दूसरो ला बचाइसेस। यदि यो परमेस्वर को मसीह से अना यदि परमेस्वर येला बेचयो सेस, ता यो आपरो आप ला बचाये। ");
INSERT INTO pwr_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","सीपाही गीन मजाक करन लगीन, वोना वोला सिरका देता कव्हन लगीन। ");
INSERT INTO pwr_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","यदि तू यहूदिगीन को राजा आस, ता आपरो आप ला बचाव। ");
INSERT INTO pwr_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","येसु को कूरूस पर भी लिखयो होत्यो। “यो यहूदी गीन को राजा से।” ");
INSERT INTO pwr_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","कूरूस पर टगों एक खोटो काम करन वालो यीसु निन्दा करके, ना कव्हन लगीस, तू मसीह आस ना? ता खुद बच अना हमला बचाव। ");
INSERT INTO pwr_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","पर दूसरो न वोला डटकार देईस अखीन कव्हयो, का तोला परमेस्वर को भेव नहात? तू भी वोच दन्ड भोग रहयो सेस, जोन वोला मीलो से? ");
INSERT INTO pwr_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","पर हमी आपरो करनी को दन्ड पाय रही सेजन, पर यो तो नेक से। ");
INSERT INTO pwr_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","तबा यीसु ला कहीस येसु जब तोरो राज आहेत तो मोला हेत राखजोस। ");
INSERT INTO pwr_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","येसु ना वोला कहीस, मी तोरो लक खरो, सागांसू का आजच तू सरग मा मोरो संग होवजोस। ");
INSERT INTO pwr_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","दोफारी को बेरा होतो वोना बखत तीसरो पहर मा सप्पा देस मा इन्धार छाय गयो। ");
INSERT INTO pwr_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","दिनो उजयारी चेले गयो अना मंदिर को पड़दा बीच लक फटके दोन टुकड़ा भय गयो। ");
INSERT INTO pwr_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","यीसु ना ऊचो लक चिल्लायो हे दाअजी जी मी आपरो आतमा ला तोरो हात मा सोपसू अखीन वोको जान हिट गयो। ");
INSERT INTO pwr_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","सेना को मुखीया यो चोवके ना परमेस्वर को भजन बड़ाई करन लग्यो, अना कव्हयो खरो खर यो मानूस न्यायी होतो। ");
INSERT INTO pwr_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","गजब जनता यो चोवन लाय इक्कठो भय गयो होतो, उ सब यो चोवके ना अपरो मन मा रोवत ललावत लवट गइन। ");
INSERT INTO pwr_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","यीसु को जान पहचान को लोक गीन दूहर उभो होतीन, अना उनमा काही आई-माई होतीन, वा गलील परदेस लक यीसु को मंघा-मंघा आई होतीन। अना यो सब चोवत होतीन। ");
INSERT INTO pwr_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","यूसुफ नाव को एक भला मानूस होतो, वोको अँदर कोनी कपट नही होत्यो, अना उ नेक मानूस होतो। ");
INSERT INTO pwr_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","वोको यो काम मा कोनी हात नही होतो, उ यहूदिगीन को परदेस अरिमितिया गाँव को निवासी होत्यो। अना उ परमेस्वर को राज को बाट जोहत होत्यो। ");
INSERT INTO pwr_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","वोना राजा पिलातुस को कठा जायके, ना यीसु को लास ला मांग लेइस। ");
INSERT INTO pwr_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","वोना लास ला कूरूस लक खाल्या उतार केना, मलमल को साजरो कफन मे लपेट केना, असो खोली जसो मरघट्टी मा ठेव दियो जहान कोनी ला नही राखयो होत्यो, उ कबर चट्टान मा खुदो होतो। ");
INSERT INTO pwr_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","वोना दिवस सूकीरवार होतो, अना पवीतर दिवस सुरु होवन वोरो होतो। ");
INSERT INTO pwr_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","जोन आई माई गलील परदेस लक आयी होतीन, उनना यूसूफ को मघा-मघा जायके ना मरघट्टी ला चोवीन, का यीसु को लास ला कसो ठेयो गयो से? ");
INSERT INTO pwr_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","तबा उनना आयके सुगंधित चीज अना इतर तैय्यार करीन अखीन पवीतर दिवस मा हुकूम को लक आराम करीन। ");
INSERT INTO pwr_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","हफ्ता को पहलो दिवस मा दिवस उगन को पूढा, बेजा सुगंधित चीज इतर आन के तैय्यार करयो होतीन लेके मरघट्टी मा आइन। ");
INSERT INTO pwr_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","अना उनना मरघट्टी को गोटा लुड़को पाइन, ");
INSERT INTO pwr_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","अना खोली जसो कबर मा धसके चोवीन, पर पिरभू यीसु की लास नहोती। ");
INSERT INTO pwr_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","वा ऐना बात ला चोवके चकीत भई गइन, तबा दोन मानूस चमकतो जामा घालयो उनको जवर आयके उभो भय गइन। ");
INSERT INTO pwr_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","जबा वय थरथराय के जमीन कना नजर ला खाल्या करके उनना उनला कहीन, का तुम्ही जित्तो ला मरया हुवा मा काहे ढुडासेव? ");
INSERT INTO pwr_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","उ यहान नहात पर मरयो हुयो जित्तो भय गईसे, अना हेत करो का वोना गलील मा रव्हतो बेरा काजक कव्हयो होतो? ");
INSERT INTO pwr_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","का यो जरुरी से, का मानूस को टूरा पापी लोक गीनको, हात लक धरयो जाहे अना कूरूस पर चघावो जाहे, अना परो को दिवस जित्तो भय जाहे। ");
INSERT INTO pwr_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","तबा उनला वोको यो गोस्टी हेत आई। ");
INSERT INTO pwr_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","तबा मरघट्टी लक लवट केना, उनना वय अकरा लोक गीनला अना सबला गोस्टी कहीन, अखीन आयकवाइन। ");
INSERT INTO pwr_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","जोन चेलागीन लक यो गोस्टी कहीन, कबर मा जान वालो आई-माई वा मरियम मगदलीनी अना योअन्ना अखीन याकूब की माय मरियम अना लगत आई-माई होतीन। ");
INSERT INTO pwr_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","पर उनला यो गोस्टी किस्सा-कन्था जसो लग्यो, यो काजी उनना उनको भरोसा नही करीन। ");
INSERT INTO pwr_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","तबा पतरस उभो भयो अना मरघट्टी चोवन काजी पराय गयो, अना उ वोनो होयके, चोयो वहान पर कफन च होतो, जोन भयो वोला सोचत-सोचत अचंभा करत आपरो घर चलो गयीन। ");
INSERT INTO pwr_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","वोच दिवस उन मा लक दुई जन इम्माऊस नाव को गाँव मा जावत होतीन, उ गाँव येरुसलेम नगर लक कोनी अकरा किलो मीटर दुहुर होतो। ");
INSERT INTO pwr_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","अना यो सबा घटना जो येरुसलेम नगर मा हुयो होतो, वोच मा आपस मा बातचीत करत होतीन। ");
INSERT INTO pwr_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","जबा वय आपस मा बात करत होतिन, तबच यीसु उनको संग-संग चलन लगयो। ");
INSERT INTO pwr_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","पर उनको डोरा ला असो बंद कर दियो होतो, का वय वोला नही चीन्ह सकिन। ");
INSERT INTO pwr_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","वोना उनला पुसयो तुम्ही आपस मा चलत-चलत काजक बोलासो गा? तबा वय उभो होयके उदास भय गईन। ");
INSERT INTO pwr_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","यो आयक के क्लियूपास नाव को मानूस ना कव्हयो, का तम्ही येरुसलेम नगर मा एकलो परदेसी सेस, जोन यो नही जानासो का? येना दिवस मा काजक-काजक भयो से। ");
INSERT INTO pwr_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","यीसु ना उनला पुसयो कोनतो, बात गा? उनना वोको लक कव्हयो परमेस्वर को भविस्यवक्ता यीसु नासरी को बारे मा उ सबा लोक गीनको बीच परमेस्वर को काम अना गोस्टी ला ");
INSERT INTO pwr_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","मोसे को नियम को गुरू अना मुखिया याजक ना वोला धरवाके, वोला जान लक मारन को दन्ड दिलवाइन अना कूरूस पर चघाय डाकिन ");
INSERT INTO pwr_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","हमिला यो आस होत्यो का योच हमरो इसरायल लोक ला सूटकारा दिलाहेत, अना यो घटना परो को दिवस घटो होतो। ");
INSERT INTO pwr_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","अमरो बीच लक काही आई-माई सक्कारी मरघट्टी मा गई होतीन, उनना हमला चकित कर देइन। ");
INSERT INTO pwr_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","वोना कव्हत होतीन, का लास गायब से अना, सरगदूत ना हमला सांगिसेस का यीसु जित्तो से। ");
INSERT INTO pwr_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","तबा हमरा संगी गीन मरघट्टी मा गईन, अना उनना चोइन का खरो-खर, लास गायब से। ");
INSERT INTO pwr_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","तबा यीसु कव्हासेत, हे कम भरोसा को, तुमरी अक्कल मा गोटा पड गयो का, तुम्ही भविस्यवक्ता गीन पवीतर गीरंथ ला नही समजासो? ");
INSERT INTO pwr_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","का यो जरुरी नहात? का मसीह यो सबा दुख उठायके, महिमा मा जाय। ");
INSERT INTO pwr_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","तबा यीसु ना मोसे गुरूजी अना, सब भविस्यवक्ता गीनको पवितर गीरंथ लक, वोको बारे मा जोन काही लिख्यो से उ सबा समजाय दियो। ");
INSERT INTO pwr_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","येतरो मा उनको गाँव आय गयो पर यीसु पुढा बढन लगयो। तबा ");
INSERT INTO pwr_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","उनना यीसु ला कहिन, का गोधुली बेरा भय गईसे, अता तु हमरो घर मा रुक जा। ");
INSERT INTO pwr_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","जबा उ उनको संग जेवन करन बस्यो, ता वोना भाकर लेय के परमेस्वर ला धन्य वाद देके तोड़िस, अना उनला देवन लग्यो। ");
INSERT INTO pwr_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","तबा उनको डोरा उघड़ गयो अना उनना वोला चिन्ह लेइन। तबा उ वहान लक गायब हो गयो। ");
INSERT INTO pwr_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","उनना आपसी मा सांगन लगीन, जबा उ रस्ता म आमी लक, गोस्टी करत होतो अना पवितर गीरंथ लक सांगत होतो, ता हमरो मन मा खुसी होयेत होतो। ");
INSERT INTO pwr_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","वय वोच बेरा उभो भईन, अना येरुसलेम नगर लवट गइन, अना उन अकरा चेला अखीन उनको संगि गिनला जमा भयो पाइन। ");
INSERT INTO pwr_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","उ कव्हत होतिन पिरभू खरो-खर, मरयो हुयो जित्तो भयो से। अना वोको, चेला समौन ला चोविसेस। ");
INSERT INTO pwr_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","तबा उनना रस्ता को सकड्या गोस्टी उनना सांग दियो। ");
INSERT INTO pwr_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","वोना यो घटना को पर गोस्टी करत होतीन, का यीसु उनको बीच मा आयके, उभो भयो अना कव्हयो, तुमला सान्ती मिल्हे। ");
INSERT INTO pwr_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","पर वोन चकीत भई गइन अना, डर के सोचन लगीन कोनी आतमा भूत से। ");
INSERT INTO pwr_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","यीसु ना उन लक कव्हयो, तुम लोग गीन काहे घबरा रही सेव? तुमरो मन मा काहे सका से? ");
INSERT INTO pwr_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","मोरो हात अना पाय चोवयो मीच सेव, मोला टटोर के चोवो काहेका, आतमा को हाड-मास नही होतो, जसो तुम्ही मोला चोव रही सेव। ");
INSERT INTO pwr_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","यो सांग के ओना कहकर उ ना वोला आपरो, हात अना पाय दिसायो। ");
INSERT INTO pwr_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","जबा खुसी को मारे ले, वोला भरोसा नही भयो, ता वय आचरज करन लगीन, ता वोना उनको लक पुसिस, का तुमरो कठा कहि जेवन को सेत। ");
INSERT INTO pwr_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","वोना वोला भुजिं मसरी को टुक्का देईस। ");
INSERT INTO pwr_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","वोना वोला लेइस, अना उनको पूढा जेव लेइस। ");
INSERT INTO pwr_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","यीसु ना चेला गीन ला कहीस, मीना तुमरो संग रहतो बेरा कव्हयो होतो, की जो काही मोसे को नियम अना, भजन भविस्यवक्ता गिनको कीताब मा लिखयो, से सबा को पूरो होवना जरूरी से। ");
INSERT INTO pwr_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","तबा वोना उनको अक्कल ला उघाड़ देइस, का उनला पवितर गीरंथ समजमा आ सके। ");
INSERT INTO pwr_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","अना उन लक कहीस, पवीतर गिरंथ मा असो लिखयो, से का मसीह दुख उठायेत अना परो को दिवस मरो लक, जिव जाहेत। ");
INSERT INTO pwr_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","अना येरुसलेम लक सुरू करके सबच लोक गीनमा वोको नाव लक पाप की छिमा लाई मनफिरावन अना पस्तावा को परचार करयो। ");
INSERT INTO pwr_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","तुमी यो गोस्टी को गवाह सेव। ");
INSERT INTO pwr_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","चोवो! जोनको वादा मोरो बाबूजी ना कियो से, मी वोला तुमरो पर उतारीन, अखीन जब तकन सरग लक सक्ती नही भेटेत तुम्ही येरुसलेम-नगर मा रव्हने काहेका, जबा उ वरदान आहेत, तबा तुम्ही परमेस्वर को ताकत लक, भरपूर होय जाने। ");
INSERT INTO pwr_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","असो सांगत-सांगत वो चेला गीनला बैतनिय्याह गाँव तकन ले गयो, अना उनना आपरो हात उठायके, न आसीस देइस। ");
INSERT INTO pwr_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","यीसु आसीस देत-देत उन लक बेगरो भय गयो, अना सरग मा उचल लियो गयो। ");
INSERT INTO pwr_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","चेलागिन वोला परनाम करके वोको स्तुति करत खुसी लक, येरुसलेम नगर लवट गइन। ");
INSERT INTO pwr_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","अना मंदिर मा परमेस्वर को बड़ाई करन लगीन।");
INSERT INTO pwr_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","सबमा सूरू मा सबद होतो। अना सबद परमेस्वर को संगा होतो। अखीन सबद परमेस्वर होतो। ");
INSERT INTO pwr_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","वोच सुरुमा परमेस्वर को संगा होतो। ");
INSERT INTO pwr_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","सबच काही वोकोच लक जलम भयो से, उनमा लक कोनी भी चीज वोको बगर जलम नही भयेव। ");
INSERT INTO pwr_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","वोको मा जिंदगी होतो, अना वा जीन्दगी मानूस गिनको उजाड़ो होतो। ");
INSERT INTO pwr_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","अखीन उजाड़ो इंधारो मा चमकासे अना इँधारो वोला नही अपनाय सकयेव। ");
INSERT INTO pwr_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","परमेस्वर को कन लक एक मानूस आयो, वोको नाव योहन होतो। ");
INSERT INTO pwr_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","उ सच्चो उजाड़ो को बारे मा सबला गवाही देन आयेव होतो, का सब वोको गोस्टी ला मानके भरोसा करेत। ");
INSERT INTO pwr_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","उ खुद उजाड़ो नहोत, मंग उ सच्चो उजाड़ो को बारे मा साँगन आयेव होतो। ");
INSERT INTO pwr_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","उ उजाड़ो जोन खरो से, वा हरेक मानूस मा उजाड़ो कर देसे। असो उजाड़ो दुनिया मा आवनवारा होतो। ");
INSERT INTO pwr_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","उ दुनिया मा होतो, अना सप्पा दुनिया वोको लक जलम लेयी होती, तरी दुनिया को लोक गीनना वोला नही चिन्हो। ");
INSERT INTO pwr_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","उ आपरो घर मा आयो, अना वोकोच घरवारो ना वोला धुतकार देइन। ");
INSERT INTO pwr_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","पर जितरो ना वोला आपनाय लेइन, उनला वोना परमेस्वर को टूरा-टुरी होवन को हक देइस। मनजे जोन लोकगीन वोको नाव पर भरोसा राखासे। ");
INSERT INTO pwr_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","की जसो रकत लक मानूस जलम होवासे, ओनो पिरकार लक वय जलम नही लेईन तरी उनको अजी स्वता परमेस्वर से। ");
INSERT INTO pwr_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","अना सबद देह मा आयो अना दया अखीन खराई लक आमरो बीच मा रहयो अना आमी ना उ परमेस्वर को टूरा को महिमा आपरो डोरा लक चोवयो सेजन। ");
INSERT INTO pwr_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","योहन ना वोको बारे मा गवाही दियो से। अना हाकल के कव्हयो “यो वोच से जोन को बारे मा मिना साँगयो होतो, जोन मोरो मँघा आवनवालो से, मोरो लक मोठयो से, काहेकि उ मोरो लक पयले होतो।” ");
INSERT INTO pwr_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","काहे का वोको मोठयो दया लक एक नही पर आमी ला दुई बार दया मिलि से। ");
INSERT INTO pwr_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","एको लाय का मोसे को नियम ता मोसे ना दियो से। पर खराई अना दया यीसु मसीह सूटकारा देवन वालो लक धाड़ियो गयो से। ");
INSERT INTO pwr_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","कबच कोनी न परमेस्वर ला नही चोयोसेस, पर परमेस्वर को टूरा नाच परमेस्वर ला चोवयोसेस, काहेका जोन वोकोच कन लक आईसे, वोनाच परमेस्वर ला चोवायोसेस। ");
INSERT INTO pwr_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","जबा यहूदिगीन ना यरुसलेम मा याजक अना लेवी दासगिन ला योहन लक यो पुसन काजी धाड़ीन का “तु कोन आस?” ");
INSERT INTO pwr_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","ता वोना यो गवाही देइस अना बिना संका को राजी भय गयो। “की मी मसीह नही सेव।” ");
INSERT INTO pwr_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","तबा उनना योहन लक पुसिन, “मंग तु कोन आस?” “का तू भविस्यवक्ता एलिय्याह आस?” योहन ना कव्हयो “मि एलिय्याह नही सेऊ” तो “का कोनी मोठयो भविस्यवक्ता सेव?” योहन ना कहीस, नही। ");
INSERT INTO pwr_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","तबा उनना वोको लक पुसिन का तू कोन आस? जोन ना आमला धाड़ीसेस उनला आमी काजक साँगबिन? “तू आपरो बारेमा काजक कव्हसेस?” ");
INSERT INTO pwr_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","योहन ना कव्हयो, जसो भविस्यवक्ता यसायाह ना साँगिसेस “जंगल मा एक हाकलनवारा को आवाज का पिरभू को पंथ ला सरल करो।” मि वोच सेव। ");
INSERT INTO pwr_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","वय मोसे को नियम को गुरू को कन लक धाडो गयो होतिन। ");
INSERT INTO pwr_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","उनना योहन लक पलट के पुसिन, “तू ना ता मसीह ना तो भविस्यवक्ता ना ता एलिय्याह आस। मंग तु काय साठी बप्तिस्मा देसेस?” ");
INSERT INTO pwr_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","तबा योहन ना जवाब दियो, “मि तो तुमी ला पानी मा बप्तिस्मा देवासू, पर तुमारो बीच मा एक मानूस उभो से, जेनला तुमी नही जानसो। ");
INSERT INTO pwr_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","मतलब मोरो मँघा आवनवालो से, जोन मोरो लक ज्यादा साजरो से, मि जोन को जूता की दोरी खोलन लायक भी नही सेउ।” ");
INSERT INTO pwr_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","यो गोस्टी यरदन नदी को वोनागन बैतनिहा गाँव मा भयो होतो जहान योहन बप्तिस्मा देत होतो। ");
INSERT INTO pwr_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","दुसरो दिवस मा योहन बप्तिस्मा देवनवारा ना यीसु ला आपरो कन आवता चोइस अना कहीस, चोवो यो परमेस्वर को पाठी से, जो दुनिया को पाप ला उचल ले जावसे। ");
INSERT INTO pwr_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","जोन को बारेमा मीना सांग्यो होतो, क एक मानूस मोरो मंघा आवन वारा से यो वोच से, जोन मोरो लक साजरो से काहेका उ मोरो लक पूढा होतो। ");
INSERT INTO pwr_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","अना मी वोला चिन्हत नही होतो। पर यो काजी मी पानी मा बप्तिस्मा देवसू का यो गोस्टी इसरायल जाती मा सब ला मालुम भई जाहेति। ");
INSERT INTO pwr_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","अना योहन ना यो गवाही देइस, मी ना परेवा को जसो आतमा ला सरग लक उतरतो चोयी सेऊ अना आतमा आयके वोको वरता रुक गयो। ");
INSERT INTO pwr_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","अना मी ता वोला चिन्हत नही होतो। पर जोन परमेस्वर ना मोला पानी लक बप्तिस्मा देवन लाय धाड़िसेस, वोना मोला सांगीस, का तुमी जोको वरता आतमा ला उतरतो अना रुकतो चोवजोस वोच पवितर आतमा लक बप्तिस्मा देवनवारा से। ");
INSERT INTO pwr_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","अखीन मीना चोवयो अना मि सांगुसू, का योच परमेस्वर को टूरा आय। ");
INSERT INTO pwr_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","दुसरो दिवस योहन ओको दुई चेला को संगा उभो होतिन। ");
INSERT INTO pwr_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","जबा उनना यीसु ला चलता चोयो, तबा कव्हन लगयो, चोवो यव परमेस्वर को पाठी आय। ");
INSERT INTO pwr_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","तबा वय दुई चेला ना यव आयकिन ता यीसु को संगा भय गईन। ");
INSERT INTO pwr_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","यीसु ना मुरक के उनला मंघा आवता चोयो, ता पुसासे, तुमी कोन ला चोवासेव? तबा उनना कहिन, हे गुरू तू कहाँन रव्हसेस? ");
INSERT INTO pwr_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","तबा यीसु ना चेलाहुन ला कव्हसे, “चलो अना चोय लेव” तबा वोना जायके वोको रव्हन को जघा चोयो अना वोको संगा रहयो, यो महातनी बेरा होती। ");
INSERT INTO pwr_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","जोन चेला योहन को गोस्टी आयकिन होतीन यीसु को मंघा भई गयी होतीन, उन दुही मा लक समोन अना एक अंद्रियास नाव को होतो। ");
INSERT INTO pwr_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","अंद्रियास पयले आपरो सगो भाऊ समौन ले भेटयो अना वोला कव्हयो “आमला बचावन वारो मसीह मिल गयो से।” ");
INSERT INTO pwr_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","तबा अंद्रियास ना समौन ला यीसु को जवर आनिस। तबा वोना टकटकी लगायके ओला चोयके कहीस, “तु योहन को टूरा समौन आस, तू पतरस कहलाजोस।” ");
INSERT INTO pwr_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","दुसरो दिवस यीसु ना गलील जानो को निरनय लेवो,। उ फिलिप्पुस लक भेटयो अना ओको लक कव्हयो “मोरो मंघ होय लेव।” ");
INSERT INTO pwr_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","फिलिप्पुस, अन्दिरयास, अना पतरस को नगर बैतसेदा को रव्हन वारा होतीन। ");
INSERT INTO pwr_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","फिलिप्पुस नतनएल लक भेटयो अना वोको लक कव्हयो जेनको बारेमा भविस्यवक्ता मोसे ना, मोसे को नियम मा अना पवीतर भविस्यवक्ता गीनना पवीतर गिरंथ मा सांगिने, उ हमला मिल गयो से, उ यूसुफ को टूरा यीसु आय, जोन नासरत नगर मा रव्हासे। ");
INSERT INTO pwr_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","नतनएल ना वोको लक कहीस, का कोनी साजरो चीज नासरत नगर लक हीट सकासे? फिलिप्पुस ना वोको लक कव्हयो, आयके चोय ले। ");
INSERT INTO pwr_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","यीसु ना नतनएल ला आपरो कन आवत चोवके वोको बारेमा कव्हयो, “चोवो एकोमा कपट नहात, यो खरो-खर इसरायली से?” ");
INSERT INTO pwr_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","नतनएल ना वोको लक कव्हयो, तू मोला कसो जानासेस? यीसु ना वोला जवाब दियो, ओको लक पुढा की फिलिप्पुस ना तोला हाकलीस, जबा तु अँजीर को झाड़ को खाल्या होतो, तबा मिना तोला चोवयो होतो। ");
INSERT INTO pwr_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","नतनएल ना वोला जवाब दियो, “हे गुरू तू परमेस्वर को टूरा, अना इसरायल जाती को महा राजा आस।” ");
INSERT INTO pwr_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","यीसु ना उनला जवाब दियो, “मीना जो तोरो लक कव्हयो का मिना तोला अँजीर को झाड़ को खाल्या चोवयो सेव का तू एकोलाय भरोसा राखासे? तू एको लक मोठो-मोठो काम चोवजोस।” ");
INSERT INTO pwr_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","मंग वोको लक सांग्यो मी तूमी लक खरो-खर सांगसू का, “तुमी सरग ला उघड़ो हुयो अना परमेस्वर को सरगदूत गिनला वरता जातो अना मानूस को टूरा ला खाल्या उतरतो चोवने।” ");
INSERT INTO pwr_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","मंग परो को दिवस गलील छेतर को काना नगर मा कोनी को बिहाव होतो, अना यीसु की माय भी उता होती। ");
INSERT INTO pwr_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","यीसु अना वोका चेला गीन भी नेवता मा आयो होतीन। ");
INSERT INTO pwr_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","जबा पिवनो को लाई अंगूर को रस खत्म भय गयो। ता यीसु की माय ना कहीस, “अता उनको जवर ता अंगूर को रस नाहती।” ");
INSERT INTO pwr_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","यीसु न कहीस। अवो माय, अबा मोरो काजक काम से? अबा यो काम करनो की बेरा नहात। ");
INSERT INTO pwr_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","ओकी माय नौकर गीनला कव्हासे, उ जोन काही करन ला सांगेत वोच करने। ");
INSERT INTO pwr_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","उता यहूदी-जात सुध्द करन को रिती-रिवाज को लक गोटा को सह गजब मोठो भांडो राखी होतीन, उनमा एक-एक मा संबर लिटर को लगभग रस समावत होत्यो। ");
INSERT INTO pwr_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","यीसु ओन्हीसीन कव्हसे, भांडो मा पानी भर देव, अना यीसु को कव्हन लक, ओन्हीसीन भांडो ला टोंड तकन लबा-लब भर देयि होतीन। ");
INSERT INTO pwr_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","तबा वोना ओन्हीसीन कव्हासे, हेड़के हांडी रांधिया को जवर ले जावो। ");
INSERT INTO pwr_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","जबा हांडी रांधिया ना वा पानी ला चाखीस, जोन अंगूर को रस बन गयो होतो। अना ओन्हीसीन नही जान पाईन का किता लक आइसे, पर वोको नौकर गीनला यो सब कान्ड मालुम होतो। तबा हान्डी राँधिया ना नवरदेव ला हाकलके कहीस, ");
INSERT INTO pwr_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","“हर कोनी मानूस पुढा निट-नाट अंगूर को रस देवासे, अना जबा लोकगीन को जिव भर जासे तबा फिको देवासे, पर तुना अबा लक निट-नाट अंगूर रस बचाय राखिसेस।” ");
INSERT INTO pwr_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","यीसु ना गलील को काना नगर मा आपरो यो पयलो निसान दिसाय के आपरी महिमा ला दिसाइस। अना ओको चेला ना वोको पर भरोसा ठेइन। ");
INSERT INTO pwr_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","येको मंघा वा अना वोकी माय अना भाऊ अना चेला कफरनहुम नगर ला गईन अना उता काही दिवस रहीन। ");
INSERT INTO pwr_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","यहूदिगीन को फसह को तिहार जवर होतो, अना यीसु यरुसलेम ला गयो। ");
INSERT INTO pwr_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","वोना मंदिर मा मेढा परेवा बईल बिकनवालो अना सोना-चांदी ला बदलन वारो ला बसा चोवसे, ");
INSERT INTO pwr_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","एकोलाई वोने रस्सी को कोड़ा बनायीस अना सब मवेसीहुन ला बाहेर मंदिर लक हेड़ देयो होत्यो। अना सोनार गीन को पैसा ला बगराय देयो होतो, अना पीढा ला उलट देयो होतो। ");
INSERT INTO pwr_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","अना परेवा बिकन वारो ला साँगीस, इनला इता लक ले जावो! मोरो परमेस्वर को घर ला, धंधा करन को सराव नोको बनाव। ");
INSERT INTO pwr_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","तबा ओको चेला गीनला हेत आई, का गिरंथ मा लिखयो से, “तोरो घर को लाई मोरी धुन मोला खाय डाकेत।” ");
INSERT INTO pwr_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","एतरो पर यहूदी लोक ओको लक कव्हासेत। तु असो काम करासेस, ता आमी ला काही निसान दिसाव। ");
INSERT INTO pwr_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","यीसु ना उनलक जवाब मा कव्हासे, “यो मंदिर ला पाड़ देव, अना मी एला तीन दिवस मा उभो कर देहू।” ");
INSERT INTO pwr_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","यहूदी लोकगीन ना कहिन, “यो मंदिर ला बनावन मा छियालीस साल लगीसेत। अना का तु वोला तीन दिवस मा उभो कर देवजोस?” ");
INSERT INTO pwr_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","पर वोना आपरो देह रुपी मंदिर को बारे मा कव्हयो होतो। ");
INSERT INTO pwr_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","अना जबा उ मरो मा लक जित्तो भयो, तबा ओको चेला गीनला हेत आई, का वोने उनलक यो कव्हयो होतो, अना उनना परमेस्वर को पवितर गिरंथ अना उ परमेस्वर की गोस्टी पर, जोन यीसु ना साँगयो होतो भरोसा राखीन। ");
INSERT INTO pwr_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","यीसु यरुसलेम नगर मा फसह को तिहार मा होतो, अना उ जोन निसान दिसावत होतो, ओला चोवके लोकगीन यीसु नाव पर भरोसा ठेइन। ");
INSERT INTO pwr_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","पर यीसु ना आपरो आप ला, उनको भरोसा मा नही छोड़ीस, काहेकी उ उन मानूस को मन ला जानत होतो। ");
INSERT INTO pwr_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","यो काजी वोला मानुसहिन ला गवाही देवन को जरूरत नही होतो। ");
INSERT INTO pwr_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","याजक अना मोसे को नियम को गुरू गीनमा नीकुदेमुस नाव को एक मानूस होतो जोन यहूदी लोकगीन को मुखिया होतो। ");
INSERT INTO pwr_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","वोना रात मा यीसु को जवर आयके वोको लक कहीस, “हे पिरभू तू परमेस्वर कन लक गुरू होयके आईसेस, काहे की जो निसान तु दिसावासेस, अदी परमेस्वर वोको संग नही सेत तो उ नही दिसा सकासे।” ");
INSERT INTO pwr_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","यीसु ना खरो जवाब देइस, ओला साँगीस, की अदी कोनी मानूस नवतो रीती लक जलम नही लेवासे, तो उ परमेस्वर को राज कभी नही चोय सकेत। ");
INSERT INTO pwr_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","नीकुदेमुस न ओको लक कहीस मानूस जब बुड़गा भय गयो, तबा उ कसो जलम ले सकासे? का वा आपरी माय को कोख लक दुसरो बार जलम लेहेत। ");
INSERT INTO pwr_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","यीसु ना खरो जवाब ओला देईस, “मी तुमी लक कव्हसू, जब तकन कोनी मानूस, पानी अना आतमा लक नही जलम लेहेत, ता उ परमेस्वर को राज मा धस नही सकासे। ");
INSERT INTO pwr_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","काहे की जोन तन लक जलमो से उ तन सेत, अना जोन आतमा लक जलमो से वा आतमा सेत। ");
INSERT INTO pwr_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","काहे चकित होवा सो, की मीना तोरो लक साँगिसेव, तोला नवतो रीती लक जलम लेनो जरूरी से। ");
INSERT INTO pwr_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","वारा जितानी कन चाव्हासे उता कन चलासे, अना तु वोको सबद आयकासे, पर नही जानासो की वा किता लक आवासे अना किता लक जासे? जोन कोनी आतमा लक, जलमो से उ असोच से।” ");
INSERT INTO pwr_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","नीकुदेमुस ना वोला जवाब देइस, “असो-कसो होय सकसे?” ");
INSERT INTO pwr_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","यो आयक के यीसु ना वोको लक कहीस, “तु इसरायल लोक को गुरू होयके भी, यो गोस्टी ला नही समझीसेस।” ");
INSERT INTO pwr_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","मी तोरो लक खरो कव्हसू, “आमी जोन गोस्टी जानसेजन वोला कव्होसेजन, अना जोन आमी ना चोवोसेजन ओकी गवाही देवासेजन, अना तुमी आमरो गवाही पर भरोसा नही करासो। ");
INSERT INTO pwr_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","जबा मीना तुम लक, धरती की गोस्टी सांगिसेव, तो तुमी न भरोसा नही ठेवासो, अना मी तुमला सरग की गोस्टी सांगु तो कसो भरोसा ठेवने।” ");
INSERT INTO pwr_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","कोनी सरग मा नही चघयो से, पर उ चघयो से जोन सरग मा लक खाल्या उतरयो से। मजे “मानूस को टूरा” जोन सरग मा से। ");
INSERT INTO pwr_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","अना जोन रीत लक, मोसे भविस्यवक्ता ना जंगल मा, सरप ला, वरता चघायो होतो। वोच रीत लक जरुरीसे की “मानूस को टूरा” भी वरता मा चघायो जाय। ");
INSERT INTO pwr_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","एकोलाय जोन कोनी, वोको पर भरोसा राखेत, उ अमर जीवन पाहेत। ");
INSERT INTO pwr_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","काहेका परमेस्वर ना संसार लक एतरो माया राखियो, का वोना आपरो चहतो एकच टूरा ला दे देईस। एकोलाय जोन कोनी वोको पर भरोसा राखेत, उ नास नही होहेत पर अमर जीवन पाहेत। ");
INSERT INTO pwr_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","परमेस्वर ना आपरो टूरा ला दन्ड देवन ला नही, पर संसार ला सूटकारा देवन लाय धाड़ीसेस। ");
INSERT INTO pwr_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","“ जोन कोनी ओको पर भरोसा राखेत, वो दन्ड नही पाहेत, पर जो लोकगीन भरोसा नही करयेत, वो खोटो मानो जाहेती। ऐको मायना असो से का उनना, परमेस्वर को एकलो चहेतो टूरा को नाव पर भरोसा नही राखिन। ");
INSERT INTO pwr_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","अना दन्ड को यो कारन से, की उजाड़ो जगत मा आयो पर मानुसगिन ना इंधारो ला उजाड़ो लक ज्यादा माया करीन, काहेका, उनको काम खोटो होतीन। ");
INSERT INTO pwr_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","काहेका जोन कोनी खोटो काम करनवालो को संगी से, उ उजाड़ो लक गुस्सा राखासे। अना उजाड़ो को जवर नही आवासेत, कहीं असो न होहे की उनको काम पर दोस लगाहेत। ");
INSERT INTO pwr_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","पर जोन खराई पर चलासे, वा उजाड़ो को जवर आवासे, का उनको काम जोन परमेस्वर लक कियो गयो सेत पुडा आहेत।” ");
INSERT INTO pwr_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","येको मंघा यीसु, अना वोका चेला, यहुदिया देस मा आई होतीन, अना यीसु उनको संग रव्हके बप्तिस्मा देवन लगयो। ");
INSERT INTO pwr_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","योहन भी सालेम नगर को जवर बप्तिस्मा देवत होतो, काहे का उता लगत पानी होतो, अना लोक गीन आयके बप्तिस्मा लेवत होतीन। ");
INSERT INTO pwr_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","योहन वोना बेरा तकन जेल मा नही डाकयो गयो होतो। ");
INSERT INTO pwr_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","उता योहन को चेला को काही यहूदी लोकगीन संग सुध्दी को बारे मा बैस भयी। ");
INSERT INTO pwr_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","अना उनना योहन को जवर आयके, वोको लक कहिन, “हे गुरू जोन मानूस यरदन नदी को वोनागन तोरो संग होतो। अना जोकि तुना गवाही देईसेस, चोव उ बप्तिस्मा देवासे, अना सबच वोको जवर आवासेत।” ");
INSERT INTO pwr_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","योहन ना जवाब देइस, “जब तकन मानूस ला सरग लक नही दियो जाय सका, तब तकन वा काही नही पाय सकासे। ");
INSERT INTO pwr_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","तुमी ता खुदच मोरो गवाही सेव, की मीना साँगयो मी मसीह नही सेव, पर वोको पुढा धाड़ो गयो सेव। ");
INSERT INTO pwr_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","जोन की नवरी से, उ नवरा से, पर नवरा को संगी जो उभो से, वोकी आयकसेस अना नवरा को सबद लक खुस होवासे। अता मोरो खुसि पूरी भय गयी। ");
INSERT INTO pwr_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","जरुरी से की उ बढ़े अना मी घटत रहुँ।” ");
INSERT INTO pwr_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","जोन वरता लक आवासे, उ सब लक बेस से, जो धरती लक आवासे उ धरती को से, अना उ धरती को गोस्टी कव्होसे, जोन सरग लक आवासे वा सब लक वरता से। ");
INSERT INTO pwr_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","जोन काही ओना चोयोसे अना आयकीसेस ओकी च गवाही ला देवासे अना कोनी वोकी गवाही नही अपनावासे। ");
INSERT INTO pwr_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","जिनना वोकी गवाही अपनाय लेईसेत वोना यो गोस्टी पर छाप लगा देइसेत की परमेस्वर खरो से। ");
INSERT INTO pwr_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","काहे की जोनला परमेस्वर ना धाड़ीसेस उ परमेस्वर की गोस्टी कव्होसे, काहे की उ आतमा नाप-नाप के नही देवासे। ");
INSERT INTO pwr_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","बाबूजी टूरा लक माया राखासे अना ओना चीज ला जोन ओको जवर से टूरा को हात मा दे देसे। ");
INSERT INTO pwr_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","जो टूरा पर भरोसा करासे, उ अमर जीवन पाहे। पर जो टूरा ला नही मानासे, उ जीवन ला नही चोय सके। पर परमेस्वर को गुस्सा वोको पर रव्होसे। ");
INSERT INTO pwr_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","मोसे को नियम को गुरू गिनला मालुम भयो का, यीसु योहन लक लगत चेला बनावासे अना उनला बप्तिस्मा देवासे। ");
INSERT INTO pwr_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","पर यीसु खुदच बप्तिसमा नही देत होतो पर ओको चेला गीन पानी मा बप्तिस्मा देवत होतीन। ");
INSERT INTO pwr_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","तबा यीसु यहुदिया छेतर ला छोड़के मंग गलील छेतर ला चलो गयो। ");
INSERT INTO pwr_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","अना वहान लक होयके उ सामरिया छेतर ला जावनो जरुरी समजयो। ");
INSERT INTO pwr_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","एकोलाय उ सामरिया छेतर ला आयो ता सुखार नगर कठा आयो, यो नगर उ जघा को जवर से, जोन याकूब न आपरो टूरा यूसुफ ला देयि होतीस। ");
INSERT INTO pwr_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","जबा यीसु थक गयो तो आयके जहान याकूब को बिहर होतो बस गयो। ओनो बेरा दिवस को टिकाटिक 12 बजया होतीन, यो बिहर ला याकूब खन्दो होतो। ");
INSERT INTO pwr_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","एतरो मा एक सामरिया की रव्होन वाली बायका पानी भरन ला आई। यीसु ना ओको लक कहीस, “का मोला पानी पियाव।” ");
INSERT INTO pwr_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","काहे का ओको चेला ता, नगर मा जेवन लेवन ला गई होतिन। ");
INSERT INTO pwr_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","सामरी बायका वोला कव्हसे; तु ता यहूदी जात को सेस अना मि सामरी बायका आऊ, मोला पानी कायला मांगासेस। (काहे की यहुदी, सामरी लोकगीन को कोनी बरतन भांडो काम मा नही आनत होतीन) ");
INSERT INTO pwr_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","यीसु ना सांगीस, का तु परमेस्वर को बरदान ला चिन्हतीस, ता यो भी चिन्हतीस की उ कोन से, जो तोरो लक कव्होसे, का मोला पानी पियाव, तो तु मोरो लक मांगतीस। अना मि तोला जिंदगी को पानी देवतो। ");
INSERT INTO pwr_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","बायका न ओला कहीस, हे पिरभू, पानी भरन ला ता बालटी नाहती, बिहर भी गहरो से, ता वो जीवन को लाई पानी तोरो जवर किता लक आहे? ");
INSERT INTO pwr_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","यो तो आमरो अजी याकूब जोनना आमला यो बेहेर देइसेस। जोन मा ओना अना ओको लेकरा अना ओको मवेसी हुनार ना पीई सेजन। का तु आमरो अजी याकूब लक मोठो सेस? ");
INSERT INTO pwr_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","यीसु कव्हासे, जोन कोनी यो पानी ला पीवासे वा मंग तहान होय जाहे। ");
INSERT INTO pwr_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","पर जोन कोनी यो पानी पीहे जोन मी देवासू, उ सदा लक तहान नही होहेत। पर उ पानी एक झिरिया बन जाहेत, जोन हरामेसा तकन पिझरत रहेत। ");
INSERT INTO pwr_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","बायका वोला कहीस, हे पिरभू, वा पानी मोला देव जोन लक मोला तहान नही लगहेत अना मी एतरो दुहूर पानी भरन आहू। ");
INSERT INTO pwr_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","यीसु वोला कव्हासे, जाय अना आपरो नवरा ला बुलायके आन। ");
INSERT INTO pwr_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","ता बायका ओला कव्होसे, “मि बगर नौरा की सेव।” यीसु न वोला जवाब देसे, तु सहीच कव्होसेस, का मोरो कोनी नौरा नहाति। ");
INSERT INTO pwr_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","काहे की तु पाँच नौरा बनाय लियो से अना जोको जवर तु अता होत उ भी तोरो नवरा नाहती। मोला तुना यो खरो साँगलीस। ");
INSERT INTO pwr_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","बायका ना यीसु ला कव्हसे, हे पिरभू, “मोला असी लगासे की तु कोनी मोठो भविस्यवक्ता आस।” ");
INSERT INTO pwr_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","आमरो अजी-दाजी ना योच पहाड़ पर बलिदान चघाईसेत, पर तुम्हि कव्होसेव की वा जघा जिता बलिदान चघावनो से, यरुसलेम मा से। ");
INSERT INTO pwr_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","यीसु ना बायका ला कव्हासे, की अवो बाया, मोरो गोस्टी मा भरोसा ठेव, वा बेरा आवासे, अजीहुन को अराधना तुमी ना ता पहाड़ पर, ना यरुसलेम नगर मा करोह। ");
INSERT INTO pwr_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","तुम जेनला नही जानसो वोला बलिदान चघावसो, आमी जेनला जानसेजन वोला बलिदान चघावसेजन, काहेका सूटकारा यहूदिगीन लक से। ");
INSERT INTO pwr_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","पर वा बेरा आवासे पर अबा से वोमा खरो भगत सरग को दआजी की पूजा आतमा अना खराई लक करयेत। काहे का सरग को दआजि आपरो लाय असो ही भगत ला तपाससे। ");
INSERT INTO pwr_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","परमेस्वर आतमा से अना जरुरी से का वोकी बलिदान करनवारा आतमा अना खराई लक वोकी बलिदान करयेत। ");
INSERT INTO pwr_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","बायका कव्होसे मि जानसेउ का मसीह जोन खिस्त कहलावोसे उ आवनवारा सेत, जब उ आहे तबा सबच गोस्टी हमला सांग देहे। ");
INSERT INTO pwr_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","यीसु ओला कव्हासे। मि तोरो लक गोस्टी करुसेऊ, “मी वाच सेव।” ");
INSERT INTO pwr_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","वाच बेरा मा चेला आय जासेत, अना यीसु ला बाई संग गोस्टी करत चोवसेत अना चकित भय जासेत। एको मंग कोनी ना असो नही पुसिन, तु काजक चाव्हसेस अना यो बाई लक काजक गोस्टी करसेस? ");
INSERT INTO pwr_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","तब च मंग बायका ना आपरो भांडो ला उतच सोड़ देइस, अना नगर ला धायके लोकहुन ला सांगासे, ");
INSERT INTO pwr_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“चलबिन एक मानूस ला चोवो, जोन मोरो बारे मा सबच काही सांग देईसेस, कहीं वोच तो मसीह नही से?” ");
INSERT INTO pwr_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","एको लाय वय लोकगीन नगर ला‌ सोड़के अना यीसु को जवर आइन। ");
INSERT INTO pwr_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","वोनोच बेरा चेला ना यीसु ला बिनती करीन, “गुरू, काही जेव लेव।” ");
INSERT INTO pwr_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","यीसु उन लक कव्हासे, “जेवन लाय मोरो जवर उ जेवन से जेनला तुमी नही जानोसो।” ");
INSERT INTO pwr_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","एतरो मा ओको चेला आपस मा यो कव्हन लगीन, “का कोनी ना वोको लाय काही जेवन ला आनी सेत?” ");
INSERT INTO pwr_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","यीसु ना उनला कव्हासे, जोन मोला धाड़ीसेस, वोकी मरजी पर चलहु, अना वोको काम ला पूरो करू, योच मोरो जेवन से। ");
INSERT INTO pwr_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","यीसु कव्हासे, का तुमी नही कव्होसो, का अब कटनी ला चार महिना रहय गईसेत? पर मि तुमी लोकगीन लक कव्हुसू, डोरा ला उचलके उन्हारी ला चोवो। वय कटनी को लाय पक गईसेत। ");
INSERT INTO pwr_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","अबा कापनवालो रोजी पाहेत अना अमर जीवन को लाय फर सँगरेत, जिनको लाय बोवन वालो अना कापनवालो दुही मिलके खुसी मनाहेत। ");
INSERT INTO pwr_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","काहे का यो हाना खरो बससे, एक से ता बोवासे अना दुजो से तो कापसे। ");
INSERT INTO pwr_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","मिना तुमला वा खेत कापन लाय धाड़िसेउ, जिनमा तुमी ना मेहनत नही करयत। दुजा ऐमा मेहनत करीसेत अना तुमला वोको मेहनत को फर मिलिसे। ");
INSERT INTO pwr_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","ता उ यहुदिया ला सोड़के मंग लवटके गलील ला चली गयो। ओनो बायको को गवाही ला जो यीसु ना ओको बारे मा सब काही कही होतीस यो गवाही ला आयक के ओनो नगर को लगत सो सामरीहुन ना यीसु मा भरोसा कर लेइन। ");
INSERT INTO pwr_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","एको लाय जबा वय सामरी यीसु जवर आइन त यीसु लक बिनती करिन का तु आमरो इता रुक। वा दुई दिवस उतच रहयो। ");
INSERT INTO pwr_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","लगत लोकगीन ना वोको सिक्सा ला आयकीन अना वोको पर भरोसा करन लगीन। ");
INSERT INTO pwr_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","अना सामरीगिन वा बाई ला बोलिन का, अता त आमी तोरो कव्हन लक भरोसा नही करबिन। आमी खुदच वोला आयक लेई सेजन। अना आमी जान सेजन, का उ खरो-खर मा संसार को बचावनवारो से। ");
INSERT INTO pwr_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","जबा दुई दिवस बीत गईन, तबा यीसु वहान लक गलील छेतर ला गयो। ");
INSERT INTO pwr_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","यीसु खुदच गवाही देवत होतो का आपरो देस मा भविस्यवक्ता को मान नही होवा। ");
INSERT INTO pwr_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","जबा यीसु गलील छेतर ला पहुचियो, तबा लोकगीन ना वोको मिजवानी करीन। काहेका यीसु तिहार को दिवस यरुसलेम मा जो काही कियो होतो, ओला सबला गलील छेतर का रहोन वालो ना चोइन होतीन, काहे का तिहार मा वय सबच उतच होतीन। ");
INSERT INTO pwr_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","यीसु मंग गलील छेतर को काना नगर मा आयो, जिता वोने पानी ला अंगूर को रस बनायी होतीस। उता एक करमचारी होतो, जोन कफरनहुम नगर को रव्होन वालो होतो, वोको टूरा बीमार होतो। ");
INSERT INTO pwr_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","जबा उ करमचारी ना कव्हयो, का यीसु यहुदिया छेतर लक गलील छेतर मा आइसे, तब उ वोको जवर आयो। अना ओको लक पिराथना करासे का, उ चलके वोको टूरा ला साजरो कर दे, काहेका वा मरनो पर होतो। ");
INSERT INTO pwr_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","यीसु ना वोला कहीस, का तुमी निसान अना चमतकार ला चोयके मोरो पर भरोसा करोसो। ");
INSERT INTO pwr_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","यो गोस्टी पर करमचारी ना ओको लक कहीस, पिरभू किरपा कर अना मोरो टूरा को मरन को पुढा चल। ");
INSERT INTO pwr_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","यीसु ना वोला कहीस, “जाय तोरो टूरा जित्तो से,” उ वोको कव्हन पर भरोसा करके चलो गयो। ");
INSERT INTO pwr_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","उ रास्ता पर जाय रहयो होतो, एतरो मा वोको दास गीन आयके वोला कव्हन लगीन, की तोरो टूरा जित्तो से। ");
INSERT INTO pwr_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","वोना उन ला पुसयो, का उ कोन सो बेरा मा साजरो भयो। उनना वोला कहिन, “काल दिवस को एक बजे वोको बुखार ठीक भयो।” ");
INSERT INTO pwr_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","तबा उ समज गयो का ठीक वोच बेरा यीसु ना कहीस होतो, का जाय तोरो टूरा जित्तो से। अना वोने आपरो सप्पा घर सकट भरोसा करन लगयो। ");
INSERT INTO pwr_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","यो यीसु को दुसरो निसान होतो। जो वोने यहुदिया छेतर लक आयके गलील छेतर मा दिसाईस। ");
INSERT INTO pwr_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","एको काही रोज बाद मा यीसु यहूदी लोकहुन को एक तिहार बेरा मा यरुसलेम तीरथ ला गयो। ");
INSERT INTO pwr_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","यरुसलेम मा भेड़ बेसकुड़ को जवर एक कुन्ड से, इब्रानी भासा मा येला बेतहसेदा कहयो जासे। एको जवर पाँच छप्पर बनयो सेत। ");
INSERT INTO pwr_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","वोमा लगत सा बीमार अँधरा, लँगडा, अना लकवा वालो पड़या रहोत होतिन। वय पानी ला हिलन की रास्ता चोवत होतीन। ");
INSERT INTO pwr_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","काहे का पिरभू को सरग दुत बेरा-बेरा मा कुन्ड मा उतरके पानी ला हिलावत होतीन। पानी हिलन को बेरा जोन मानूस पहेले कुन्ड मा उतरत होतो, चाहे उ कोनी भी रोग लक होयहेत, उ साजरो भय जात होतो। ");
INSERT INTO pwr_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","उता कन एक मानूस होतो जोन अड़तीस बरस लक बीमार होतो। ");
INSERT INTO pwr_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","जबा यीसु ना वोला वहान लेटो चोयीस अना यो जानके का उ एतरो लम्बो बेरा लक रोगी से ता यीसु ओला कव्हासे, “का तू साजरो होवनो चाव्हासे?” ");
INSERT INTO pwr_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","बीमार ना कहीस, पिरभू! मोरो कोनी नाहात, की जोन पानी हिलन को बेरा मोला कुन्ड मा उतारहेत। मोरो उतरनो को पुढ़ा च, कोनी दुसरो मोरो लक पयले उतर जासे। ");
INSERT INTO pwr_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","यीसु ना वोला कहीस, उभो होय! आपरो दरी ला उचल अना हिंड। ");
INSERT INTO pwr_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","गदने उ मानूस चाँगलो भय गयो, अना आपरो दरी ला उचलके हिंडन लगयो। ");
INSERT INTO pwr_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","ओला हिंडतो चोयके यहुदी अधिकारी ना ओनो मानूस कव्हन लगीन की तोला कउन ना साजरो करीसेस? काहेकि यो ता बिसराम को दिवस से यो कानुन को बिरोध मा से, आज को दिवस तोला आपरो दरी उचलनो भी साजरो नहोती। ");
INSERT INTO pwr_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","वोना उन ला जवाब देइस, “जोन मानूस मोला साजरो करीसेस, वोच न मोला कहिसेस, आपरो दरी ला उचल अना हिंडबिन।” ");
INSERT INTO pwr_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","उनना वोको लक पुसिन, “उ कोन मानूस से? जोन तोला कहिसेस, दरी उचल अना हिंड।” ");
INSERT INTO pwr_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","पर उ मानूस जोन साजरो भयो होतो, नही जानत होतो का उ कोन आय, काहेका ओनो जघा लगत भीड़ होती एकोलाई यीसु ओको लक दुहूर चली गयो होतो। ");
INSERT INTO pwr_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","येने गोस्टी को मंघा, रोगी यीसु ला मंदिर मा भेटयो। यीसु ना वोला कहीस, चोव! तु साजरो भय गईसेस, मंग पाप नोको करबिन, नही ता अखिन कोनी मोठी आफद तोरो पर आन पड़ेहत। ");
INSERT INTO pwr_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","ओना जायके यहूदि अधिकारीहुन ला कव्ह देसे, उ यीसु होतो, जेने मोला चांगलो करीसेस। ");
INSERT INTO pwr_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","काहेकि यीसु ना बिसराम दिवस मा साजरो करन को काम करीसे, एकोलाई यहुदीहुन ओला सतावन लगीन। ");
INSERT INTO pwr_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","यीसु ना उनला जवाब देईस, मोरो दाअजी अजी हमेसा काम करतो रव्हसे, एकोलाई मि भी काम करासेऊ। एकोलाई यहुदी ओला मार डाकन को कोसिस करत होतीन। ");
INSERT INTO pwr_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","नाच केवल एकोलाई का उ बिसराम ला तोड़ रहयो होतो बल्कि उ परमेस्वर ला आपरो बाबूजी भी कव्हत होता। अना एकोलाई अपरो आपला परमेस्वर को जसो ठहरात होतो। ");
INSERT INTO pwr_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","ऐना रिती यीसु ना उन लक साँगीस, मि तुमी लक खरो कव्हासेऊ, “टूरा खुदच काही नही कर सका, केवल परमेस्वर दाअजी जोन वोला करन ला कव्हासे, काहे का जोन काम ला दाअजी करासे, वसोच टूरा भी वोच रिती लक करासे।” ");
INSERT INTO pwr_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","काहे का परमेस्वर दाअजी टूरा ला माया राखासे। अना जोन-जोन काम उ खुद करासे, उ सबला वोला दिसावासे अना यो काम लक मोठो काम वोला दिसाये। काहे का तुमी चकित होवो। ");
INSERT INTO pwr_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","जसो की दाअजी मरयो हुयो ला जित्तो उचलासे, अना जिंदगी भी देसे। वसोच टूरा भी जेनला उ चाव्हासे ओला जित्तो कर देसे। ");
INSERT INTO pwr_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","दाअजी कोनी को न्याय नही करासे, पर न्याय करन साठी हक टूरा ला देइसेस। ");
INSERT INTO pwr_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","मनजे कोनी टुआ को मान करहेत वसोच दाअजी को मान करहेत। जोन टूरा को मान नही करासे, उ दाअजी को जोने वोला धाडीसेस, मान नही करासे। ");
INSERT INTO pwr_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","मि तुमी लक खरो सांगिसेउ,“ जोन मोरी गोस्टी आयक के मोरो धाड़नवालो पर भरोसा करासे, वोको जवर अमर जीवन से अना ओको पर सजा की हुकूम नही होवासे। पर उ मिरतु लक पार भयके जीवन मा धसेत।” ");
INSERT INTO pwr_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","मि तुमी लक खरो सांगिसेउ, “उ बेरा आवासे अना अबा भी से, जोनमा मरया हुया परमेस्वर दाअजी को टूरा की आवाज आयकेत। अना जोन कोनी आयकेत वय जित्तो होयेती।” ");
INSERT INTO pwr_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","“काहे की जोन रिती लक दाअजी जीवन राखासे, वोच रिती लक वोना टूरा ला भी यो हक दियो से का आपरो आप मा जीवन राखे। ");
INSERT INTO pwr_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","वरन वोला न्याय करन को भी हक दियो गईसे, एको लाय उ मानूस को टूरा से। ");
INSERT INTO pwr_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","एको लाय चकित नोको हुओ, काहे का उ बेरा आवासे का जेतरा मरा हुआ सेत, वय वोकी आवाज आयक के मरघट्टी लक हिटहेत। ");
INSERT INTO pwr_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","जिनना साजरो करीसेत, वय जीवन को लाय अना जोनना बुरो करीसेत, वय सजा को लाय, जित्तो होयेती।” ");
INSERT INTO pwr_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“मि आपरो लक काही नही कर सकु, जसो आयकासेऊ वसोच न्याय करासेउ, काहेकि मोरो न्याय खरो से काहेका मि आपरी मरजी लक नही पर आपरो धाड़न वालो की मरजी ला चाहव्सेउ।” ");
INSERT INTO pwr_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","अदी मि आपरो गवाही आपच देवासु, तो यो गोस्टी खरो नाहती। ");
INSERT INTO pwr_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","एक अखीन से जो मोरी गवाही देसे, अना मि जानासू का जोन यो गोस्टी ला पुरुप करासे, उ खरो से। ");
INSERT INTO pwr_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","तुमी ना लोक गीनला योहन को जवर पुछन लाई धाड़यात अना वोना खरो गवाही सांगिसेस। ");
INSERT INTO pwr_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","मि मानूस को गवाही पर आसरित नही सेऊ। तरी मि एकलाय कव्हासेउ जेकोलक तुमरो बचाव भय सकेत। ");
INSERT INTO pwr_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","योहन ओनो दियो को जसो होतो जोन जलतो हुयो से अना उजाड़ो देसे। अना तुमी काही बेरा को लाई ओको उजाड़ो को खुसी मनावन चाव्हत होता। ");
INSERT INTO pwr_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","पर मोरो जवर जोन गवाही से, उ योहन की गवाही लक मोठी से। अना जोन काम परमेस्वर दाअजी ना मोला पूरो करन लाई, देईसेस। मजे वय योच काम सेत, जोन मि करुसेउ, वय मोरो सबुत सेती, का परमेस्वर दाअजी ना मोला धाड़ीसेस। ");
INSERT INTO pwr_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","परमेस्वर दाअजी ना जेना मोला धाड़ीसेस, मोरी गवाही देईसेस। तुमी लोकहुन ना ओको गोस्टी कबच नही आयकियत अना न तुमीना ओको रूप चोयीसेव। ");
INSERT INTO pwr_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","अखिन नाच तुमी आपरो भीतर ओको खबर ला अपनायो सेव। काहेकी तुमी ओमा बिस्वास नही राखासेव जेनला परमेस्वर दाअजी ना धाड़ीसेस। ");
INSERT INTO pwr_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","तुमी गिरंथहुन मा वाचासो, काहेका तुम्हि समजासो की ओमा अमर जिंदगी तुमला मिलेहत। अना यो वाचासो जोनमा मोरो बारे मा सबूत कहयो गयो से। ");
INSERT INTO pwr_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","मंगच तुमी जिंदगी पावन लाई मोरो जवर नही आवन चाव्हसो। ");
INSERT INTO pwr_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","मि मानूस लक मान- मरयादा नही चाव्हसेउ। ");
INSERT INTO pwr_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","पर मि जानसेउ का तुमी मा परमेस्वर को माया नहात। ");
INSERT INTO pwr_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","मि आपरो दाअजी को नाव लक आईसेऊ मंग तुमी लोकहून मोला नही अपनावा सेव। अदी कोनी आपरो नाव लक आहे तो ओला तुमी अपनाय लेहो। ");
INSERT INTO pwr_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","तुमी मोरो पर बिस्वास कसो कर सकासेव? काहेकि तुमी ता एकमेक लक मान- मरयादा चाव्हासेव। अना उ मान- मरयादा जोन एक परमेस्वर को कन लक से, नही चाव्हासेव। ");
INSERT INTO pwr_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","यो नोको समजो का मि परमेस्वर दाअजी को पुढ़ा तुमी पर दोस लगाव सेउ। तुमी पर दोस लगावन वालो मोसे से, जोन पर तुमी ना आस राखयत। अदि तुमी मोसे पर सही मा बिस्वास करासेव ");
INSERT INTO pwr_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","ता तुमी मोरो मा भी बिस्वास करतत काहेकि मोसे ना मोरो बारे मा लिख्यो से। ");
INSERT INTO pwr_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","जबा तुमी, जोन ओना लिख्यो सेस ओमा बिस्वास नही करासेव, “ता मोरो गोस्टी मा बिस्वास कसो करोह?” ");
INSERT INTO pwr_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","एको मंघा यीसु गलील नगर को तिबिरियास नाव को झील को वोनागन चली गयो। ");
INSERT INTO pwr_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","अना ओको मंघा एक मोठी भीड़ वोको मंघा भय गई, काहे का उनना रोगीहुन ला साजरो करन लाय अदभुत हिदान चोवायो होता। ");
INSERT INTO pwr_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","तबा यीसु पहाड़ मा चघके आपरो मंघा आवनवालो चेलाहुन को संग उता बस गयो। ");
INSERT INTO pwr_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","यहूदिगीन को फसह को तिहार जवर होतो। ");
INSERT INTO pwr_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","जबा यीसु ना एक मोठी भीड़ ला आपरो जवर आवत चोवीस, तबा ओना फिलिप्पुस लक पुसिस, हमि इनको लाई जेवन किता लक आनबिन? ");
INSERT INTO pwr_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","यीसु यो गोस्टी ओको परिक्सा लेवन को लाई कही होतीस, काहे का उ खुदच जानत होतो, का उ काजक करन जाय रही से? ");
INSERT INTO pwr_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","फिलिप्पुस न ओला जवाब देईस, का दुई सौ सिक्का की जेवन भी उनला ला कम पड़हेत। पर हरेक झनला जरा-जरा बाँटनो पर जरा लगत बाँटा नही आहेत। ");
INSERT INTO pwr_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","ओको चेला मा एक अखिन, जोन समौन पतरस को भाऊ अन्दिरयास होतो, ओना यीसु ला कहीस, ");
INSERT INTO pwr_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","इता एक टूरा से, जोको जवर, जौ को पांच भाकर अना दुई मसरी सेती। पर एतरो लोकहुन लाय नही होवन की। ");
INSERT INTO pwr_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","यीसु न कहीस, लोकहुन ला गवथ मा बसाय देव। तबा मरद-माना जिनकी गिनती पांच हजार को करिब होती। बर्रा मा गवथ पर बसाय देईन। ");
INSERT INTO pwr_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","तबा यीसु ना भाकर लेइस, अना परमेस्वर ला धनवाद करके लोकहून ला पगंत मा परस देइन, वसोच मसरी ला भी मन को मरजी लक बाट देइन। ");
INSERT INTO pwr_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","जबा वय जेयके के अघा गईन, तबा यीसु आपरो चेला गीन ला कहीस, बचयो टुकड़ा-टाकड़ी ला सकेल लेव, नास नोको करो। ");
INSERT INTO pwr_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","तबा जेवन को मंघा उनना जौ को भाकरी को बारा टोपली टुकड़ा-टाकड़ी ला जमा करीन। ");
INSERT INTO pwr_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","यीसु को यो चमत्कार चोयके लोकहुन ना कहयो, “पिक्को मा यो भविस्यवक्ता से जोन संसार मा आवन वारो होतो।” ");
INSERT INTO pwr_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","यीसु ना यो जानके क वय मोला राजा बनान लाय धरन चाव्हासेत, एकोलाय उ पहाड़ पर चली गयो। ");
INSERT INTO pwr_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","जब झूलाखाली भई, ता ओको चेला झील को कन गईन। ");
INSERT INTO pwr_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","अना नाव मा चघके सागर को ओनागन, कफरनहुम नगर ला जावन लगीन। ओना बेरा जेवन रात भई गई होती। अना यीसु उनको कठा नही आयो होतो। ");
INSERT INTO pwr_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","मोठो आंधड़ आवन लगी अना पानी मा लहर चलन लगी, ");
INSERT INTO pwr_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","तबा वय डोंगा चलात-चलात सह किलोमीटर तकन निकल गईन। तबा उनना यीसु ला सागर पर चलता, अना नाव को कठा आवता चोयीन, तो डराय गईन। ");
INSERT INTO pwr_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","तबा यीसु उनला कव्हसे, डराव नोको, “काहेकि मि सेऊ।” ");
INSERT INTO pwr_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","मंग उनना ओला गदने नाव मा चघाय लेईन, ता गदने डोंगा वोना जघा पर पहुच गयी, जिता उनला जानो होतो। ");
INSERT INTO pwr_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","दुसरो दिवस लोकहून को ओना भीड़ ना जोन झील को ओनागन रह गयी होती, चोयिन का वहान केवल एक डोंगा होतो, अना अपरो चेलाहुन को संग यीसु नही गयो होतो, पर ओको चेलागीन च चले गयो होतीन। ");
INSERT INTO pwr_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","तबा ओनाच बेरा मा, काही लोक नाव तिबिरियास लक वोना जघा को जवर आइन, जहान उनना पिरभू को पिराथना-धनवाद करके ना भाकर जेयी होतीन। ");
INSERT INTO pwr_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","तबा लोकगीन ना चोयीन का यहान, यीसु अना चेला गीन नहात, ता वय नहानी डोंगी मा चघके, यीसु ला ढुंढत-ढांढत कफरनहुम मा पहुँचईन। ");
INSERT INTO pwr_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","झील को ओनागन जबा वय लोक यीसु लक मिलिन ता उनना ओला सांगीन, ओ गुरू, इता तु कब लक आईसेस? ");
INSERT INTO pwr_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","यीसु उनला कव्हासे। खरो-खर तुमी मोला एकोलाय नही पुसासेव, की तुम्हिना अचंभा वालो निसान चोयोसेव, पर भाकर जेयके अघाइसो। ");
INSERT INTO pwr_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","नास होवन वालो जेवन लाई मेहनत कायलाई करोसो? पर उ जेवन लाई मेहनत करो, जोन अमर जीवन लाई से। काहेकि उ जेवन मानूस को टूरा देहे, काहेका परमेस्वर दाअजी ना यो देन को हक वोला देईसेस। मजे परमेस्वर ना छाप लगाइसे। ");
INSERT INTO pwr_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","एतरो आयक के उनना कहीन, परमेस्वर को काम करन ला आमी का करबिन। ");
INSERT INTO pwr_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","यीसु ना जवाब देइस, परमेस्वर का काम यो से की तुमी मोरो भरोसा पर करो काहेकी परमेस्वर ना मोला धाड़िसेस। ");
INSERT INTO pwr_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","तब ओन्हीसीन कहिन, मंग तु कोनतो निसान दिसावासेस की आमी चोवके तोरो भरोसा पर करबिन। ");
INSERT INTO pwr_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","आमरो बाप-दादा ना जंगल मा मन्ना खाईन, जसो लिखयो से, वोना उनला खावन लाई सरग की भाखर देइस। ");
INSERT INTO pwr_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","यीसु ना कहीस, का मि तुम लक खरो कव्हसू, “का मोसे ना तुम्हिला वा भाकर सरग लक नही देइस, पर मोरो दाअजी तुमला सच्ची भाखरी सरग लक देसे। ");
INSERT INTO pwr_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","काहे का परमेस्वर की भाकर वाच से जोन सरग लक उतरीसे अना संसार ला जिंदगी देसे।” ");
INSERT INTO pwr_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","तबा ओन्हीसीन कहिन, हे पिरभू यो भाकर हमला सबा बेरा देजोस। ");
INSERT INTO pwr_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","यीसु ना उनला कहीस, “जिंदगी की भाकर मि सेव, जो मोर कगर आवासे, ओला कभ्भु भुख नही लगेत, अना जोन मोरो पर भरोसा ठेवासे, ओला कभ्भु तहान नही लगेत।” ");
INSERT INTO pwr_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","तुमना मोला चोय भी लियत ता भी भरोसा नही ठेवासो। ");
INSERT INTO pwr_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","जोन कोनी ला परमेस्वर दाअजी मोरो कठा धाड़ासे, उ मोरो कठा आहेत। अना जो कोनी मोरो कठा आहेति ओला मि कभ्भुच नही हेड़ु। ");
INSERT INTO pwr_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","काहे का मि आपरी मरजी ला नही पर परमेस्वर की मरजी पूरी करनलाय सरग लक आईसेऊ। ");
INSERT INTO pwr_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","परमेस्वर की मरजी यो से की जिनला ओना मोला देईसेस उनमा लक मि कोनी ला नही खोउँ, पर आखीर मा ओला जित्तो कर देहुँ। ");
INSERT INTO pwr_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","काहेकी परमेस्वर की मरजी यो से की जोन कोनी मोला चोहे, अना मोरो पर भरोसा ठेये उ अमर जिंदगी पाहेत। ");
INSERT INTO pwr_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","एको लाय यहूदिगीन वोको पर कुड़कुड़ान लगीन, की ओना कव्हयो होतो की जोन भाकर सरग लक उतरीसे, उ मि सेव। ");
INSERT INTO pwr_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","अना उनको कव्हनो यो होतो, का यो यूसुफ को टूरा यीसु नहाती का, जोनको माय-अजी ला आमी जाना सेजन? ता उ कसो कव्हसे का, मि सरग लक आईसेऊ? ");
INSERT INTO pwr_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","यीसु उनला जवाब देसे, आपस मा नोको कुड़कुड़ाओ। ");
INSERT INTO pwr_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","कोनी मोर कठा नही आय सका, जब तकन दाअजी परमेस्वर जोन मोला धाड़िसेस, ओला नोको झीक लेय। ");
INSERT INTO pwr_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","भविस्यवक्ता गीनको लेख मा यो लिखयो से। वय सब परमेस्वर को कन लक सिकायो होयेति। जोन कोनी ना दाअजी लक आयकिया अना सिकाया होयेत, उ मोर कठा आहेति। ");
INSERT INTO pwr_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","एको अरथ यो नहोती का कोनी ना दाअजी ला चोयीसेस, पर वाच जोन परमेस्वर कन लक आयीसे ओनाच दाअजी ला चोयीसे। ");
INSERT INTO pwr_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","मि तुम लक खरो साँगुसु, जोन कोनी भरोसा करासे वाच अमर जिंदगी पाहेत। ");
INSERT INTO pwr_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","मि जिंदगी की भाकर सेव। ");
INSERT INTO pwr_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","तुमरो आजा-पुरखागीन ना जंगल मा मन्ना खाईन पर वय मर गईन। ");
INSERT INTO pwr_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","यो वा भाखर से, जोन सरग लक उतरीसे, एकोलाय जोन कोनी ओनो भाखर ला खाहे उ नही मरेत। ");
INSERT INTO pwr_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","जीवन की भाकर जोन सरग लक उतरी से, मि सेव। जोन यो भाकर मा लक खाये उ सदा जित्तो रहेत, अना जोन भाकर मि संसार को जिन्दगी को लाय देहुँ, उ मोरो देह से। ");
INSERT INTO pwr_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","येने गोस्टी पर यहूदिगीन आपस मा झगड़न लगीन, यो मानूस कसो हमला आपरो देह खावन लाई दे सकासे? ");
INSERT INTO pwr_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","यीसु उन ला कहीस, मि खरो-खरो साँगुसु की जबा तकन मानूस को टूरा को माँस नही खाओ, अना मोरो खून नही पिवने, तबा तकन, तुमरो मा जिंदगी नही रहेत। ");
INSERT INTO pwr_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","जोन मोरो माँस खावसे अना खून पिवासे, अमर जिंदगी ओकोच से, अना आखीर मा ओला मंग जीत्तो करू। ");
INSERT INTO pwr_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","काहे का मोरो माँस सहीच मा खावन की चीज से अना मोर खून सही मा पिवन की चीज से। ");
INSERT INTO pwr_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","जोन मोरो माँस खावासे अना मोरो खून पिवासे, उ मोरो मा अडिग बनयो रहोसे, अना मि ओमा बनयो रहुसु। ");
INSERT INTO pwr_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","जसो जित्तो परमेस्वर ना मोला धाड़ीसेस अना जिंदगी देइसेस वसोच जोन मोरो माँस ला खावसे। उ भी जित्तो रहेत। ");
INSERT INTO pwr_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","जो भाकर सरग लक उतरी याच से, उ भाकर को जसो नही जेनला तुमरो आजा-पुरखा ना खाईन अना मर गईन। जोन कोनी यो भाकर खाये उ सदा जित्तो रहेत। ");
INSERT INTO pwr_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","यीसु ना यो गोस्टी कफरनहुम गाँव को एक सभाघर मा सिक्सा देवतो बेरा कहीस। ");
INSERT INTO pwr_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","ओको चेला मा लक बहुत लोकगीन यो आयक के कहिन यो गजब कठीन सिक्सा से, येला कोन आयक सकासे। ");
INSERT INTO pwr_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","यीसु न आपरो मन मा यो जानके का चेला आपस मा यो गोस्टी लक कुड़कुड़ावा सेति, उन लक पुसिस, का यो सिक्सा तुमला कठिन लगासे। ");
INSERT INTO pwr_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","अदी तुमी मानूस को टूरा ला जिता उ पयले होतो, उता वरता जातो चोहो ता का होहे? ");
INSERT INTO pwr_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","आतमा ता जिन्दगी देन वालो से, माँस लक कोनी फायदा नही से, जो गोस्टी मीना तुमी लक कव्हसू, वय आतमा अना जिन्दगी दुही सेत। ");
INSERT INTO pwr_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","पर तुम मा लक काही ता असो सेति जोन नही करासेत, काहे का यीसु पुढ़ा च लक जानत होतो का कोन मोरो भरोसा नही करह, अना कोन मोला धरायहे। ");
INSERT INTO pwr_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","अना ओना कहीस, एको लाई मिना तुमी लक कव्हयो होतो का जबा तकन कोनी को दाअजी को कन लक यो वरदान न देयो जाहेत तबा तकन उ मोरो कठा नही आय सका। ");
INSERT INTO pwr_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","एतरो पर ओको चेला मा लक लगत सा उलटो मंग गईन अना कोनी लगत सँग नही चलिन। ");
INSERT INTO pwr_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","तबा यीसु ना बारा चेला लक कहीस, का तुमी भी हमेसा सोड़के जानो चाहोसो? ");
INSERT INTO pwr_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","समौन पतरस नाव को चेला ना कहीस, हे पिरभू! आमी कोन को जवर जाबोन, अमर जिंदगी की गोस्टी ता तोरोच जवर सेत। ");
INSERT INTO pwr_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","अना आमी ना भरोसा कर लिया अना जान लिया का परमेस्वर को पवीतर जन तु ही सेस। ");
INSERT INTO pwr_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","यीसु न जवाब देइस, का मिना तुमी बारा ला नही निवाड़ी सेव, ता भी तुमी बारा मा लक एक से जो सैतान कन लक से। ");
INSERT INTO pwr_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","यो ओना समोन इस्करियोति को टूरा यहूदा लाय कहि होतीस। काहे की वाच बारा मा लक एक होतो जेने यीसु ला धराय होतीस। ");
INSERT INTO pwr_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","एको मंघा, यीसु ना गलील मा फिरयो, काहेका उ यहुदिया ला नही फिरन चाव्हत होतो, काहेका वहान को यहुदी अधिकारी ओला मार डाकन चाव्हत होतीन। ");
INSERT INTO pwr_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","यहूदिगीन को झोपड़ी को तिहार कठा होतो। ");
INSERT INTO pwr_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","एको लाई यीसु को भाऊ लोकगीन ना ओको लक कहीन, यो जघा ला सोड़के यहुदी नगर मा जाय, काहेका जोन काम तु करासेस, ओला तोरो मघा चलनवारो चोवेत। ");
INSERT INTO pwr_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","जोन जग जाहीर होवनो चाव्हासे वा लूक के काम नही करासेत। जब तू असो काम करासेस ता सबको पूढा आपरो काम दिसाव। ");
INSERT INTO pwr_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","काहेका यीसु को भाऊहुन तकन ओमा भरोसा नही करत होतीन। ");
INSERT INTO pwr_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","तब यीसु ना उन लक कहीस, तुमरो लाई हरेक बेरा साजरो से, पर मोरो लाई अबा साजरो बेरा नही आईसे। ");
INSERT INTO pwr_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","यो दुनिया तुमरो लक बैर नही करासे, पर मोरो लक बैर करासे, काहेका मी उनको बिरोध मा यो गवाही देवासू का उनको काम बुरो सेति। ");
INSERT INTO pwr_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","ऐना तिहार मा तुमी लोक जावो, मि अबा यो तिहार मा नही जाहु, काहे की मोरो बेरा पूरो नही भईसे। ");
INSERT INTO pwr_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","असी गोस्टी कव्हन को मंघा यीसु गलील नगर मा रुक गयो। ");
INSERT INTO pwr_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","जबा तिहार मा ओको भाऊहुन चली गईन ता उ भी गयो पर उ खुल्लो रुप लक नही, चुप्पई चाप गयो होतो। ");
INSERT INTO pwr_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","यहूदी मुखिया यीसु ला तिहार मा यो कव्हके तलास कर रही होतीन का, “उ मानूस किता से?” ");
INSERT INTO pwr_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","लोकगीन ओको बारे मा चुप्पई लक लगत पिरकार को गोस्टी कर रही होतीन, काही कव्हत होतिन, का उ साजरो मानूस से, अना काही कव्हत होतीन, नही उ लोकगीन ला भरमावासे। ");
INSERT INTO pwr_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","ता भी यहूदिगीन को भेव लक कोनी मानूस ओको बारे मा नही साँगत होतो। ");
INSERT INTO pwr_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","जबा तिहार अरधो बीत गयो होतो, तबा यीसु मंदिर मा गयो अना ओना पिरवचन देवनो सुरु कियो। ");
INSERT INTO pwr_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","तबा यहूदिगीन चकित होयके कव्हन लगीन, यो मानूस कबच वाचन करन लाई पाठसाला नही गयी से, मंग एतरो काही कसो लक जानासे? ");
INSERT INTO pwr_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","यीसु ना जवाब देइस, मि जोन पिरवचन ला देसू उ मोरो कन लक नही, पर मोरो धाड़न वालो परमेस्वर को कन लक से, जोन ना मोला धाड़ीसेस। ");
INSERT INTO pwr_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","अदी मानूस उ करनो चाहे, जोन मोठो दाअजी को मरजी से ता उ यो जान जाहे का जोन पिरवचन मि देवासू, उ मोठो परमेस्वर को से, मंग मि आपरो कन लक नही देय रही सेउ। ");
INSERT INTO pwr_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","जोन आपरो टोंड लक कव्हन चाव्हासे, उ आपरो बड़ाई चाव्हासे, पर जोन आपरो धाड़न वालो की बडाई चाव्हासे, वाच खरो से, अना ओमा अन्याय नाहती। ");
INSERT INTO pwr_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","का तुमला मोसे को नियम ला नही देई गयी से? मंग तुम्हि मा लक कोनी मोसे को नियम पर नही चलासे। तुमी मोला कायलाई मार डाकन चाव्हासो? ");
INSERT INTO pwr_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","लोकहुन ना जवाब देइन, “तोरो पर भूत घुस गयी से जोन तोला मारन को तक्का पर से।” ");
INSERT INTO pwr_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","यीसु उनला जवाब देसे की, मि तुमरो लाई एक अदभुत काम ला करयो अना तुम्हि ता चकित भयो सेव। ");
INSERT INTO pwr_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","एनाच मकसद लक मोसे ना तुमला खतना को रिवाज सौप देयि होतो। (असो नही का यो रिवाज मोसे को कन लक से, पर तुमरो आजा-पुरखा लक चलके आय रहयो होतो।) अखीन तुमी बिसराम दिवस मा टुराहुनार को खतना करासेव। ");
INSERT INTO pwr_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","जबा पवीतर दिवस मानूस को खतना कियो जासे, तबा मोसे को नियम को हुकूम बनो रव्हासे, तो तुमी मोरो पर काहे गुस्सा करासो की मिना एक मानूस ला पूरी तरीको लक साजरो करीसेऊ। ");
INSERT INTO pwr_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","गोस्टी जसी से वसो चोवके न्याय करो, टोंड चोवके न्याय नोको करो। ");
INSERT INTO pwr_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","तबा यरुसलेम का रव्हनवालो लोकहुन मा लक काही ना कहिन, “का यो वोच मानूस नही से, जोनला लोक मार डाकन चाव्हसेत?” ");
INSERT INTO pwr_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","चोवो, उ ता लोकहुन को बीच खुल्लमखुल्ला गोस्टी कर रही से अना कोनी ओला काही नही कव्ह सका सेत, का यो नही होय सका यहुदी मुखिया ला सही मा मालुम भयो, का योच खरोखर मसीह से? ");
INSERT INTO pwr_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","“येला तो हमी जानसेजन, का यो कहाँन को से? पर जब मसीह आहेत, तबा कोनी नही जान पाहेत, की उ कहाँन को सेत?” ");
INSERT INTO pwr_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","यीसु ना मंदिर मा जोर लक कहयो, “का तुमी सच मा नही जानासेव, मि कोन सेऊ अना किता लक आयीसेऊ?” मि आपरो हक लक नही आयीसेऊ, काहेका जोन ना मोला धाड़ीसेस उ सच्चो से, तुमी ओला नही जानासेव। ");
INSERT INTO pwr_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","मि ओला जानासू, काहेका मि ओको कन लक आयी सेऊ, अखीन ओने मोला धाड़िसेस। ");
INSERT INTO pwr_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","मंग वय ओला बंदी बनावन को कोसिस करन लगीन, पर कोनी भी ओको पर हात नही डाक सकया। काहेकि ओको बेरा अबा नही आयी होती। ");
INSERT INTO pwr_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","मंग भीड़ मा लक लगत सा लोक ओको पर भरोसा कर लेईन। अना कव्हन लगीन, “मसीह जबा आहे तबा का येको लक लगत निसान करेत जोन एना चोवायीसेस।” ");
INSERT INTO pwr_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","मुखिया याजक अना मोसे को नियम को गुरू गीन ना सुनगुन-सुनगुन यो गोस्टी ला लोकगीन ला करत आयकिन, एकोलाई मोठा याजक अना मोसे को नियम को गुरु ना ओला धरन लाई सिपाही धाड़िन। ");
INSERT INTO pwr_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","तबा यीसु ना कहीस, “मी काही बेरा तुम्हरो संग सेव, तबा मि आपरो धाड़न वालो परमेस्वर को जवर चलो जाहुँ। ");
INSERT INTO pwr_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","तुमी मोला ढुँढ-ढाँढ करहो, पर मि तुमला नही मिलुँ, काहेका मि जिता जासू, वहान तुमी नही आय सकसो।” ");
INSERT INTO pwr_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","यहुदी अधिकारी आपसी मा कहिन, “उ किता को जघा ला जासे का हमी ओला नही पायबिन?” का उ युनानी नगर ला ता नही जासे का वहान तितिर-बितिर रव्हन वाला यहुदी गीनला, युनानी मा सिक्सा सांगेह? ");
INSERT INTO pwr_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","यो गोस्टी को का मतलब से? का उ कव्हसे का तुमी मोला तपासो पर नही पायबिन, अखिन जिता मि जाहु उता तुमी नही आय सकबिन। ");
INSERT INTO pwr_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","तिहार को आखरी दिवस मा यीसु उभो हुयो, अना जोर लक कव्हन लगयो, “जोन कोनी भी तहान होय, उ मोरो कठा आयेत।” ");
INSERT INTO pwr_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","जोन कोनी बिस्वासी होयके मोरो मा लक पिहे, पवितर गिरंथ मा असो लिख्यो से, ओको भितर लक जिंदगी को पानी को झरना बोह जाहेत। ");
INSERT INTO pwr_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","यीसु ना यो गोस्टी पवीतर आतमा को बारे मा साँगयो होतो, जेनला ओको पर भरोसा ठेवन वालो पावन वालो होतीन। काहे की पवीतर आतमा अबा तकन नही उतरयो होतो। काहे की यीसु आपरो महिमा अबा तकन नही भेटयो होतो। ");
INSERT INTO pwr_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","भीड़ मा लक काही लोकहुन ना यीसु ला यो कव्हत आयकिन अखिन कहिन, “यो मानूस ता वाकई मा भविस्यवक्ता आय!” ");
INSERT INTO pwr_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","अना दुसरो ना कहिन, “उ ता मसीह आय!” पर कोनी-कोनी कव्हन लगीन, “का मसीह गलील नगर लक आहेत?” ");
INSERT INTO pwr_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","का पवितर गिरंथ मा यो लिख्यो से? का मसीह दाऊद को खानदान, बैतलेहम गाँव मा जलम लियो, अना दाउद को नगर लक आहेत, जहान दाऊद रव्हत होतो। ");
INSERT INTO pwr_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","तबा असो गोस्टी को कारन लक, भीड़ मा फुट पड़ गई। ");
INSERT INTO pwr_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","उनमा लक काही लोकगीन ओला धरनो चाव्हत होतीन, पर वा कोनी को हात मा नही आयो। ");
INSERT INTO pwr_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","जबा सिपाही वापिस होयके मुखिया याजक अना मोसे को नियम को गुरू जवर आइन। तबा उनना सिपाही लक पुसिन, “तुमी काय लाई ओला नही आनयत?” ");
INSERT INTO pwr_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","सिपाही ना साँगिन, “आज तकन आमिना ओको जसो कोनी मानूस ला गोस्टी करता नही चोया!” ");
INSERT INTO pwr_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","मोसे को नियम को गुरू गीनना उनला कहीन, “का तुमी भी भरमाया गया सेव?” ");
INSERT INTO pwr_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","कोनी भी यहुदी मुखिया अना मोसे को नियम को गुरू गीनना ओको पर भरोसा नही करीन? ");
INSERT INTO pwr_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","यो लोक जोन मोसे को नियम नही जानासेति‌ वय सापित सेति। ");
INSERT INTO pwr_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","नीकुदेमुस जोन पुढा वोको जवर आयो होतो, उ उनमा लक एक होतो, उनला कहीस। ");
INSERT INTO pwr_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","का आमरो मोसे को नियम मा, असो नही लिख्योसेत? का जबा तकन वोको बारे मा यो जान नही लेव, उ काजक करासे, कसो दन्ड ठहरायो जाहेती? ");
INSERT INTO pwr_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","ओन्हीसिन ओला जवाब देईन, का तु भी गलीली सेस? तू ढूढ-ढान्ड कर अना खोज, का गलील मा कोनी भविस्यवक्ता भयो से? ");
INSERT INTO pwr_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","तबा वय सब वहान लक आपरो घर ला चली गईन। ");
INSERT INTO pwr_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","यीसु मंग जैतून पहाड़ पर चली गयो। ");
INSERT INTO pwr_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","पहट ला मंदिर मा आयो, तबा सब लोकगीन मंदिर मा आवन लगीन, यीसु वहान बसके उनला सिक्सा देवन लगयो। ");
INSERT INTO pwr_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","तबा यहुदी अगुवा अना मोसे को नियम को गुरू गीन एक बायको ला आनीन जोन छिनाला करत धरी गई होती। ओला बीच मा उभी करके यीसु लक कहीन, ");
INSERT INTO pwr_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","“हे गुरूजी, या बायको छिनाली करत धराय गईसे। ");
INSERT INTO pwr_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","मोसे को नियम मा हम ला हुकूम देईसेस की असी बायको ला गोटा लक मारो जाय, एको बारे मा तोरी काजक राय से?” ");
INSERT INTO pwr_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","ओन्हीसीन यीसु ला फसावन लाय यो गोस्टी पुस रही होतीन, जोनको लक उनला कोनी असो बहाना मिल जाहेत का ओको पर दोस लगाय सकेत। पर यीसु खाल्या नवके अखिन आपरी कंरगी लक जमीन मा लिखन लगयो। ");
INSERT INTO pwr_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","काहेकि जबा वय ओको लक पुसत रहिन, एकोलाई यीसु सीधो तनके उनलक बोलिस, “तुमी मा लक जोन पापी नहात वाच सबलक पयले एने बायका ला गोटा मारे।” ");
INSERT INTO pwr_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","अना मंग उ जमीन मा वोनो भयके लिखन लगयो। ");
INSERT INTO pwr_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","जबा लोकहुन ना असो आयकिन, तबा मोठो लक नहानो तकन, एक-एक करके उता लक हिट गईन। असो यीसु च उता एकलो रह गयो। यीसु को मोहरा वा बायको अबा भी उभी होती। ");
INSERT INTO pwr_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","तबा यीसु उभो भयो अना ओनो बायका लक बोलिस, “ओ बायका, वय सब किता गईन? का कोनी ना तोला दोसी नही ठहरायीन?” ");
INSERT INTO pwr_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","बायका कव्हासे, “हे पिरभू! कोन्हीसीन नही।” यीसु ना कहीस, “मि भी तोला दन्ड नही देहुँ, जाय अना मंग कबच पाप नोको करजोस।” ");
INSERT INTO pwr_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","मंग वहान पायो जावन वाला लोक गीनला यीसु ना कहीस, “जगत को उजाडो मि सेव। जोन मोरो मंघा चलहेत कबच इंधारो मा नही रहेत, पर ओला उजाड़ो मिल्हेत जोन जिंदगी देवासे।” ");
INSERT INTO pwr_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","एतरो पर मोसे को नियम को गुरू यीसु लक कव्हासेत, “तु आपरी गवाही खुदच देसेस, एकोलाई तोरी गवाही खरी नहात।” ");
INSERT INTO pwr_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","तबा यीसु ना उन ला साँगिस, “अदी मि आपरो पुरूप खुदच देवासु ता भी मोरो पुरूप खरो से, काहे की मि जानासेऊ की मि किता लक आयीसेऊ, अना किता लक जावासू। पर तुमी नही जानासेव की मि किता लक आयीसेऊ अना किता लक जावासेऊ। ");
INSERT INTO pwr_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","तुमी मानूस की उसुल पर न्याय करोसो, मि कोनी को नियाव नही करूँ। ");
INSERT INTO pwr_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","तरी अदी मि न्याय करूँ, ता मोरो न्याय खरो से। काहे की मि एकलो नही सेव। पर मोठो दाअजी अजी, जेना मोला धाड़ीसेस, उ अना मि मिलके न्याय करासेत। ");
INSERT INTO pwr_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","मि आपरी गवाही खुदच देवासेऊ अना मोठो दाअजी अजी भी, जेना मोला धाड़ीसेस, मोरो कन लक गवाही देसे। ");
INSERT INTO pwr_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","एक तो मि खुदच आपरी गवाही देवासु। अना दुजो से परमेस्वर बाबूजी, जोन ना मोरो कनलक गवाही देइसेस, जोन ना मोला धाड़िसेस।” ");
INSERT INTO pwr_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","ऐतरो मा लोकहुन यीसु ला कव्हासेत, “तोरो अजी किता से?” यीसु ना कहीस, “तुमी नही जानासो, का मि कोन सेऊ? अना मोरो अजी ला भी नही जानासो, अदि तुमी जानतत, ता मोरो अजी ला भी जान लियो रव्हतत।” ");
INSERT INTO pwr_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","यीसु ना या गोस्टी उनला मंदिर मा सिक्सा देतो बेरा भन्डार घर मा कहीस, तरी कोनी ना ओला नही धरीन, काहेकि ओको बेरा अबा नही आयो होतो। ");
INSERT INTO pwr_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","यीसु ना मंग एक गन उन ला कहीस, “मि चली जाहु, तुमी मोला ढुंढ-ढान्ड करने, पर तुम्हि आपरो पापहुन मा मर जाहो। जिता मि जावासेऊ वहान तुमी नही आय सकने।” ");
INSERT INTO pwr_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","मंग यहुदी अगूवा कव्हन लगीन, “का तुमी सोचसो का उ आपरो खुदच ला मार देहे? काहेकि ओना कहिसेस तुमी वहान नही आय सकने जहान मि जावासेऊ।” ");
INSERT INTO pwr_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","ओना उन ला कहीस तुमी धरती का सेव, मि वरता लक आयी सेऊ। अना तुमी दुनियाँ का आव, मि दुनिया को नही आऊ। ");
INSERT INTO pwr_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","एको लाई मिना तुमला कव्हयो, की तुमी पाप मा मरोह। काहे की तुमी भरोसा नही ठेवो, की मि वाच सेऊ। ");
INSERT INTO pwr_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","मंग ओन्हीसीन ओको लक पुसिन, “तु कोन आस?” यीसु ना उन लक जवाब देइस, मि सुरू लक तुमला साँगत आयीसेऊ, वाच सेऊ। ");
INSERT INTO pwr_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","तुमरो बारे मा मोला लगत गोस्टी कव्हनो से, अना तुमरो न्याय करनो से। पर मोरो धाड़न वालो परमेस्वर खरो से। मीना जोन गोस्टी ओको लक आयकीसेऊ। वाच मि जगत लक कव्हसू। ");
INSERT INTO pwr_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","वय नही समज पाईन की आमी ला उ परमेस्वर दाअजी को बारे मा कव्हासे। ");
INSERT INTO pwr_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","तबा यीसु न कहीस जबा तुमी मानूस को टूरा वरता मा चघावने, तो जान लेवने की मि वाच आऊ। अना मि आपरो आप लक काही नही करासू। पर जसो मोरो परमेस्वर दाअजी ना सिकाईसेस वसोच गोस्टी कव्हसू। ");
INSERT INTO pwr_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","मोरो धाड़नवालो मोरो सँग से, ओने मोला एकलो नही सोड़ीसेस, यो काजी सदा वाच काम करासू, जोको लक परमेस्वर खुस रव्हासे। ");
INSERT INTO pwr_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","यीसु की यो गोस्टी ला आयक के लगत लोकइन ना ओको बिस्वासी होय गयीन। ");
INSERT INTO pwr_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","तबा यीसु ना वोको पर भरोसा राखनवालो यहूदी गीनला कहीस, अदी तुमी मोरो गोस्टी ला आयको, ता खरो मा मोरो चेला कहलाहो। ");
INSERT INTO pwr_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","अना खराई ला जान लेवने तो खराई तुमला सूटकारा देहेत। ");
INSERT INTO pwr_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","ओन्हिसीन यीसु लक सवाल पुसासेत, “आमी तो अबराहम को खानदान को सेजन। आमी कोनी का गुलाम नही भयो, मंग तु कसो कव्हासेव तुमिला सूटकारा मिलहेत?” ");
INSERT INTO pwr_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","यीसु ना उन ला जवाब देइस, मि तुमला खरो-खरो कव्हुसू। हर कोनी जोन पाप करासे, पाप को दास से। ");
INSERT INTO pwr_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","कोनी दास हमेसा घर मा नही रव्ह सका, पर टूरा हमेसा संग रव्होसे। ");
INSERT INTO pwr_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","तबा अदी टूरा तुमला सूटकारा देहेत, तबा सच्ची मा तुमी पाप लक सूटकारा पाहो। ");
INSERT INTO pwr_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","मि जानासु की तुमी अबराहम को खानदान का सेव। मंग मोरो सबद तुमरो मनमा नही समावासे, तबच तुमी मोला मार डाकनो चाव्हासेव। ");
INSERT INTO pwr_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","मि वाच कव्हुसू जोन मिना आपरो परमेस्वर अजी को इता चोविसेऊ। अना तुमी वाच करोसो जोन तुमीना आपरो अजी सैतान लक आयकासेव। ");
INSERT INTO pwr_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","एतरो पर ओन्हिसीन यीसु ला जवाब देइन, “आमरो अजी ता अबराहम से।” यीसु ना कहीस, “अदी तुमी अबराहम की औलाद होतत ता अबराहम को जसो काम करतत। ");
INSERT INTO pwr_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","पर तुमी ता मोरो जसो मानूस ला मार डाकन चाव्हसेव, जेने तुमला उ खराई ला साँगिसेस जो मोठो परमेस्वर लक आयकीसेस। अबराहम ना ता असो नही करयो होतो। ");
INSERT INTO pwr_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","तुमी आपरो अजी को काम करोसो।” मंग ओन्हीसीन यीसु लक कहीन, “आमी छिंडरापन लक नही जनम नही लियासेजन। आमरो एकच अजी परमेस्वर से अना उ पवीतर से।” ");
INSERT INTO pwr_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","यीसु ना उन लक कहीस अदी परमेस्वर तुमरो अजी होतो ता तुमी मोरो लक माया राखतत। काहे की मि परमेस्वर कन लक हिटके आईसेऊ, अना अबा यहान सेऊ। मि खुद नही आईसेऊ, पर ओना मोला धाडीसेस। ");
INSERT INTO pwr_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","एकोलाई तुमी मोरो समाचार नही आयकासो, एकोलाई नही समजासो का मि काजक कह रही सेऊ। ");
INSERT INTO pwr_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","तुमी आपरो अजी सैतान कन लक सेव, अना आपरो अजी को लालसा ला पूरी करनो चाव्हासेव। उ ता सुरू लक खूनी से, खराई लाय सच्चो नही रव्हे। काहे की सच ओमा नहाती, जबा उ झुठो सांगासे ता आपरो आचरन च लक सांगासे, काहे की उ झुठो से, अना झुठो को अजी से। ");
INSERT INTO pwr_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","“पर काहेकि मि खराई कव्ह रही सेउ एकोलाई तुमी मोरो भरोसा नही करतत।” ");
INSERT INTO pwr_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","तुमी मा लक कोन मोला पापी होवन को लानछान लगाय सकासे। अदी मि खराई लक कव्हसू, तो तुमी मोरो भरोसा कायलाई नही करतत। ");
INSERT INTO pwr_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","जोन मानूस परमेस्वर को होवासे, उ परमेस्वर की गोस्टी ला आयकासे, तुमी एकोलाय नही आयको की परमेस्वर कन लक नही सेव। ");
INSERT INTO pwr_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","यो आयक के यहूदिगीन ना ओला कहिन, “का हमी खरो नही सांगासेजन, का तू सामरी आस अना तोरो मा भूत से?” ");
INSERT INTO pwr_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","यीसु ना जवाब देईस, मोरो मा कोनी भूत नहात। पर मि आपरो अजी को मान करुसु अना तुमी मोरो बेईज्जती करोसो। ");
INSERT INTO pwr_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","पर मि आपरी बड़ाई नही चाव्हासेऊ, पर एक से जोन मोरी बड़ाई चाव्हासे अना न्याय करासे। ");
INSERT INTO pwr_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","मि तुमला खरो कव्हसु की अदी कोनी मानूस मोरो कव्हो गयो गोस्टी ला आपनासे ता उ मिरतु ला कबच नही चोहेत। ");
INSERT INTO pwr_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","एतरो पर यहुदी अगूवा गीनना ओला कहिन, “अता आमला मालुम भय गयो से का तोरो मा कोनी भूत से। अबराहम अना भविस्यवक्ता गीन मर गयो सेत। अना तु कव्हसेस अदि कोनी मोरी गोस्टी ला आपनाहे ता ओकी मिरतु कभ्भू नही होयेत। ");
INSERT INTO pwr_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","का तु आमरो पुरखा अबराहम लक मोठो आस? जोन मर गयो, अखिन भविस्यवक्ता भी मर गयीन। तु अपरो आप ला काजक समजासे?” ");
INSERT INTO pwr_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","यीसु ना जवाब देईस, अदी मि आप आपरी बड़ाई करु ता मोरी बडाई काही नही, पर मोरी बडाई करन वालो मोरो परमेस्वर बाबूजी से, जेनला तुमी कसो की उ आमरो परमेस्वर आय। ");
INSERT INTO pwr_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","अना तुमी तो ओला नही जानो, पर मि ओला जानसेऊ, अना अदी मि कहुँ की ओला नही जानु तो मि तुमरो जसो झुठो ठहरू। पर मि ओला जानासेऊ, अना ओको सबद मा चलासेऊ। ");
INSERT INTO pwr_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","तुमरो पुरखा अबराहम मोला चोवन की आसा लक लगत खुस होतो, अना ओना चोय लेइस अना खुसी मनाईस। ");
INSERT INTO pwr_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","मंग यहूदी अगूवागीन ना ओला कहीन, “अब तकन तु पचास बरस को नही भईसेस, मंग तु ना अबराहम ला कसो चोय लियोसे?” ");
INSERT INTO pwr_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","यीसु ना उनला कहीस, “मि तुमी लक खरो कव्हसु, की पुढा अबराहम पैदा भयो, एको लक पुढा मि सेउ।” ");
INSERT INTO pwr_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","तबा ओन्हीसीन ओला मारन लाई गोटा उचलीन पर यीसु हिटके मंदिर लक चलो गयो। ");
INSERT INTO pwr_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","मंग जातो बेरा ओना एक मानूस ला चोवीस, जोन जनम लक अँधरा होतो। ");
INSERT INTO pwr_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","एतरो पर यीसु को चेलाहुन ना ओको लक पुसिन, “हे गुरू कोन ना पाप करीसेस, की यो अँधरा जनम लेइसे, यो मानूस ना, का ओको माय-अजी ना?” ");
INSERT INTO pwr_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","यीसु ना जवाब देइस, “ना तो ओना पाप करीसेस, ना ओको माय-अजी ना, पर यो एकोलाय अँधरो भयो की परमेस्वर को काम दिसायो जाहे। ");
INSERT INTO pwr_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","जोन मोला धाडिसेस आमीला ओको काम दिवस मा करनो से अना उ रात आनो पर से, जोनमा कोनी काम नही कर सका। ");
INSERT INTO pwr_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","जबा तकन मि दुनिया मा सेउ, तबा तकन दुनियाँ को उजाड़ो सेव।” ");
INSERT INTO pwr_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","असो कव्हके ओना धरती मा थुकीस, अना वा थुक लक माटी ला सानिस अना उ माटी ला अँधरा को डोरा मा लगायके रगड़ देईस। ");
INSERT INTO pwr_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","अना ओला कहीस “जाय सीलोह को कुन्ड मा धोय ले! मंग अँधरा ना जायके डोरा ला धोय लेइस, जबा उ मंघा वापिस भयो ता ओला चोवन लगयो।” ");
INSERT INTO pwr_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","तबा सेजारवारा अना जोन्हीसीन ओला पयले भीक मांगत चोवत होतीन, कव्हन लगीन, का यो वाच मानूस नही से, जोन बसके ना भीक मांगत होतो? ");
INSERT INTO pwr_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","काही लोकगीन ना कहिन, “यो वाच से” दुसरो ना कहिन, “नही, यो उ नही से, ओको जसो चोवासे।” एतरो पर अँधरा ना कहीस, “मि वाच सेव।” ");
INSERT INTO pwr_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","तबा वय ओको लक पूसन लगीन, “तोरो डोरा कसो उघड गईन?” ");
INSERT INTO pwr_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","वोना जवाब देइस, “यीसु नाव को एक मानूस ना माटी गिली करीस, अना मोरो डोरा मा लगायके मोरो लक कहीस, जाय अना सीलोह मा जायके धोय ले! अना मि जायके धोयो बस एतरो पर मोला चोवन लगयो।” ");
INSERT INTO pwr_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","मंग लोकहुन ना वोको लक पुसिन, “उ किता से?” वोना कहीस, “मि नही जानु।” ");
INSERT INTO pwr_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","लोक ओला जोन पयले अँधरा होतो, मोसे को नियम को गुरू को जवर आनीन। ");
INSERT INTO pwr_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","जोन दिवस मा यीसु ना माती ओदी करके अँधरा ला डोरा उघाड़ो होतीस, वा बिसराम दिवस होतो। ");
INSERT INTO pwr_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","मंग एक गन मोसे को नियम को गुरू ना ओको लक पुसिन, “का ओको डोरा कसो उघड़ीन?” ओना सांगीस, “ओना मोरो डोरा पर ओदी माती लगाइस, मंग मिना धोयो अना अता मि चोय सकासू।” ");
INSERT INTO pwr_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","एतरो पर काही मोसे को नियम को गुरू कव्हन लगीन, यो मानूस परमेस्वर को कन लक नहात, काहेकि उ बिसराम दिवस को पालन नही करासे। ओतरो पर दुसरो ना कहीन, “कोनी पापी मानूस भला असो निसान कसो दिसाय सकासे?” असो परकार लक उनमा आपसी मा फूटफैर भय गई। ");
INSERT INTO pwr_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","वय एक गन मंग ओनो अँधरा लक कहिन, “ओको बारे मा तु काजक कव्हासेत? काहेकि ऐना बिसय ला तु जानासेस की ओने तोला डोरा देईसेस।” तबा ओना कहीस, “उ भविस्यवक्ता आय।” ");
INSERT INTO pwr_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","यहूदी अगुवाहुन ना ओनो बेरा ओको पर बिस्वास नही करीन की उ मानूस अँधरा होतो अना ओला डोरा लक चोवन लगयो होतो। तबा ओको माय-अजी ला बुलवाइन। ");
INSERT INTO pwr_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","अना उनको लक पुसीन, “का यो च तुमरो टूरा आय! जोनको बारे मा तुम्हि सांगासेव की उ अँधरा होतो? मंग यो कसो चोवन लगयो।” ");
INSERT INTO pwr_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","ओको माय-अजी ना जवाब देइन, “का हमी ता जानसेजन की यो हमरो टूरा आय, अना यो अँधरा जलम लियो होतो। ");
INSERT INTO pwr_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","पर हमी अता नही जानसेजन की अबा कसो चोवासे? अना नही जानासेजन का येको डोरा कोन ना उघाडीसेस? एको लक पुस लेव अता उ अकलवर से, आपरो बारे मा उ खुदच साँग देहे।” ");
INSERT INTO pwr_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","यो गोस्टी ला ओको माय-बाबूजी ना एको लाई कहिन का वय यहूदी अगुवागीन लक डरात होतिन। काहेकि यहुदी अगुवाहुन यो गोस्टी लक एक मन भयो होतिन, का अदी कोनी कहेत की उ मसीह से, ता वोला मंदीर को सभा लक हेड़ दियो जाहे। ");
INSERT INTO pwr_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","एकोलाई ओको माय-अजी ना कहीन, “उ मोठो भय गयो से, ओकोच लक पुस लेव।” ");
INSERT INTO pwr_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","तबा उनना उ मानूस ला जोन अँधरा होतो दुसरो गन बुलाइन, अना कहिन, “खरो साँग, जोन तु साजरो भयो से, ओको कारन परमेस्वर को बड़ाई कर! हमिला मालुम से की उ मानूस पापी आय।” ");
INSERT INTO pwr_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","एको पर ओना जवाब देइस, “मि नही जानु की उ पापी से का न्यायी से, मि ता बस यो जानासेऊ की मि अँधरा होतो, अना अता चोवन लगयो।” ");
INSERT INTO pwr_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","यो गोस्टी पर उनना ओको लक पुसिन, “ओना तोरो सँग काजक करीसेस? ओना तोरो डोरा कसो उघाडीसेस?” ");
INSERT INTO pwr_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","असो गोस्टी पर ओना जवाब दियो, मि ता तुमला साँग दियो, पर तुमी नही आयकत!अता दुसरो गन कायलाई आयकनो चाव्हासो? का तुमी भी ओको चेला बननो चाव्हासो? ");
INSERT INTO pwr_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","एको पर वय ओला बेज्जत करीन अना कहिन, “तुच ओको चेला सेस, पर आमी ता मोसे भविस्यवक्ता को चेला आजन। ");
INSERT INTO pwr_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","आमी ता जानासेजन का परमेस्वर ना मोसे भविस्यवक्ता लक गोस्टी करी होतिस, पर एला नही जान पाया की उ किता लक आयीसे?” ");
INSERT INTO pwr_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","ओना उन ला जवाब देइस, “या ता अचंभा से, तुम्हिला मालूम नहात कि वा किता को आय? पर ओना मोरो डोरा उघाड़ीसेस। ");
INSERT INTO pwr_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","हमि जानसेजन, का परमेस्वर पापी गीनको नही आयकासे पर अदी कोनी परमेस्वर को भगत से अना ओकी मरजी पर चलासे ता उ ओकी आयकसे। ");
INSERT INTO pwr_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","जूनो जमाना लक यो कभ्भू आयकनो मा नही आयो का कोनी ना जलम लक अँधरा को डोरा उघाड़यो से। ");
INSERT INTO pwr_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","अदी यो मानूस परमेस्वर को कन लक नही होतो, ता यो काही भी नही कर सकतो।” ");
INSERT INTO pwr_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","उनना जवाब देइन, “का तु खरो-खर मा पाप मा रहयोसेस, अना पाप लक जलम लेयीसेस। अना अता तु हमला सीकावासे?” अना उनना वोला बाहेर हेड़ देयीन। ");
INSERT INTO pwr_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","यीसु ना आयकिस की उनना ओला बाहेर हेड देइन, अना जबा वोला मिलयो ता कहीस, “का तु मानूस को टूरा पर भरोसा करासेस?” ");
INSERT INTO pwr_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","ओना मानूस ना जवाब देइस का, “हे पिरभू, उ कोन आय, जोको पर मि भरोसा राखु?” ");
INSERT INTO pwr_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","यीसु ना ओला कहीस, “तु ना ओला चोवीसेस, अना जोन तोरो सँग गोस्टी करा से वोच आय!” ");
INSERT INTO pwr_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","ओना कहीस, “हे पिरभू मि भरोसा करासू।” अना ओला परनाम करीस। ");
INSERT INTO pwr_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","तबा यीसु ना कहीस, “मि यो संसार मा न्याय करन ला आइसेऊ। काहेकी जोन नही चोवासेत वय चोवेत, अना जो चोवासेत वय अँधरा भय जाहेत।” ");
INSERT INTO pwr_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","जोन मोसे को नियम को गुरू ओको सँग होतिन, “उनना यो गोस्टी आयक के ओको लक कहिन, का हमि अँधरा सेजन?” ");
INSERT INTO pwr_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","यीसु ना उनला साँगीस, “अदी तुम्हि अँधरा नही होतत, तो मोला पापी नही ठहरतत। पर अब कव्हसो की हमि चोवसेजन, एकोलाय, तुम्हरो पाप बनो रव्हासे।” ");
INSERT INTO pwr_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","यीसु ना कहीस मि तुमला खरो-खर कव्हासू, जोन कोनी बेसकुड़ लक मेंढा को कोठा मा नही धसासे, पर कोनी दुसरो परकार लक धसासे, उ चोट्टा अना डाकु आय। ");
INSERT INTO pwr_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","पर जोन मानूस बेसकुड़ लक भीतर धसासे, उ मेढा को चरानवालो से। ");
INSERT INTO pwr_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","जबा उ आपरो मेढा हुनला बाहेर हेड़ देसे अना उनको मोहरा-मोहरा चलासे। अना मेढा ओको आवाज ला आयकासेत अना ओको मंघा चलासेत। ");
INSERT INTO pwr_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","जबा उ आपरी सप्पा मेंढ़ा ला बाहेर हेड़ लेवासे, ता उनको पुढा-पुढा चलासे, अना मेढा ओको मंघा-मंघा होय जासेति। काहेका वय ओको आवाज जानासेत। ");
INSERT INTO pwr_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","पर वय पराया को मंघा नही जासेत, पर ओको लक परायेत काहेका वय परायो को आवाज नही जानासेत। ");
INSERT INTO pwr_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","यीसु ना उन लक यो बोधकथा कहीस, पर वय नही समझ पाईन का यो का गोस्टी से जोन वा उनलक कव्हसे। ");
INSERT INTO pwr_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","तबा यीसु ना उन लक सांगयो, मि तुमी लक सही-सही कव्हसु, मेढा गीनको बेसकुड़ मि सेव। ");
INSERT INTO pwr_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","जेतरो मोरो लक पुढ़ा आइन, वय सबच चोट्टा अना डाकु सेति, पर मेढा गीनना उनकी नही आयकिन। ");
INSERT INTO pwr_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","बेसकुड़ मि सेव, अदी कोनी मोरो लक भितर धसेत, तो सूटकारा पाहेत, अना भीतर बाहेर आवनो-जावनो करहेत अना चारा पाहेत। ");
INSERT INTO pwr_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","चोट्टा अखीन कोनी काम लाई नही आवासे, पर चोरी करन अना मार डाकन बरबाद करन ला आवासे। मि एकोलाय आई सेउ, की वय जिंदगानी पाहेत, अना लगत लक पाहेत। ");
INSERT INTO pwr_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","मि साजरो चरानवालो सेव, साजरो चरान वालो मेढा गीन लाई आपरो जान देवासे। ");
INSERT INTO pwr_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","बनिहार जोन ना तो मेढा को चरान वालो से अना मेढा को मालीक आय, बीघा ला आवता चोवके मेढा गिनला सोड़के पराय जासे, अना बीघा उनला धर लेवासे, अना छित्तरा देवासे। ");
INSERT INTO pwr_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","उ एक बनिहार आय अना वोला मेंढा गीनको फिकर नहात, एकोलाय वा उनला सोड़के पराय जावासे। ");
INSERT INTO pwr_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","मि साजरो चरानवालो सेउ, मि आपरी मेढागिन ला जानासेऊ अना मोरो मेढा मोला जानासे। ");
INSERT INTO pwr_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","जसो बाबूजी मोला जानासे अना मि बाबूजी ला जानासु अना मि मेढा लाई आपरो जान देवासेउ। ");
INSERT INTO pwr_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","मोरो अखीन मेढा सेत, जोन यो मेंढ़ा खोली को नाहती, मोला उनला आननो जरुरीसेत। वय मोरो आवाज आयकेत, तबा एक करप अना एक चरानवालो होयेत। ");
INSERT INTO pwr_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","बाबूजी एको लाई मोरो लक माया राखासे, की मि आपरो जान देवासेउ की ओला मंग ले लेहु। ");
INSERT INTO pwr_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","मोरो जिंदगानी कोनी मोरो लक नही हीसक सकासे। पर मि ओला आपच देवसेउ, मोला ओला देवनो को भी हक से अना ओला मंग लेवन को हक से। यो हुकूम मोरो बाबूजी लक मोला मिलिसे। ");
INSERT INTO pwr_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","या गोस्टी को कारन लक यहूदिगीन मा मंग फुट पड़ गई। ");
INSERT INTO pwr_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","उनमा लक लगत कव्हन लगीन, ओमा भुत से, अना उ बैताड़ से, ओकी कायलाई आयकासेव? ");
INSERT INTO pwr_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","अखीन लोकहुन ना कहिन, यो गोस्टी असो मानूस को नही जोनमा भुत-पलित से। का भुत-पलित अँधरा की डोरा उघाड़ सका सेत? ");
INSERT INTO pwr_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","ओनो दिवस मा यरुसलेम मा मंदिर को उदघाटन दिवस मनायो जात होतो, अना जाड़ो की बेरा होतो। ");
INSERT INTO pwr_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","यीसु मंदिर मा सुलेमान को अँगना मा फिरत होतो। ");
INSERT INTO pwr_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","तबा यहूदिगीन ना ओला घेर लेइन, अना पुसन लगीन, “तु कब तकन हमला संका मा राखजोस? अदी तु मसीह आस ता हमला साँग दे।” ");
INSERT INTO pwr_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","यीसु उनला साँगिस, “मिना तुम्हि ला साँगीसेव पर तुमला भरोसा नहाय।” मि आपरो बाबूजी को नाव लक जोन काम करासू, वाच मोरो पूरुप से। ");
INSERT INTO pwr_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","पर तुमी भरोसा नही राखोसो, काहेकी मोरी मेढा गीनमा लक तुम्ही नही सेव। ");
INSERT INTO pwr_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","मोरी मेढा मोरी गोस्टी ला आयकासेत, मि उनला जानासेऊ अना वय मोरो मंघा-मंघा चलसेति। ");
INSERT INTO pwr_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","मि उनला अमर जिंदगी देवासु, वय कभ्भू च नास नही होहेत। अना कोनी उनला मोरो हात लक नही हिसकेत। ");
INSERT INTO pwr_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","उनला मोरो दाअजी ना मोला देइसेस, अना कोनी उनला दाअजी को हात लक नही हिसक सकेह। ");
INSERT INTO pwr_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","मी अना मोरो अजी दूई एकच सेजन। ");
INSERT INTO pwr_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","मंग यहूदी अगुवाहुन ना ओला मारन लाई गोटा उचलीन। ");
INSERT INTO pwr_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","एतरो पर यीसु ना कहीस की, मि तुमला आपरो बाबूजी को लगत सा काम चोवायो, उनमा लक कोन तो भला काम लक मोला गोटा मारासो। ");
INSERT INTO pwr_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","यहूदिगीन ना जवाब देईन “भलो काम को लाई नही पर तु परमेस्वर की निन्दा करासेस एको लाई आमी मारासेजन। तु मानूस होयके भी आपरो आप ला, परमेस्वर मानासेत।” ");
INSERT INTO pwr_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","यीसु उनला कव्हसे, का यो भी तुमरो मोसे को नियम अना गिंरथ मा लिखियो से? का मिना कहयो सेऊ, “तुमी सबच परमेस्वर सेव?” ");
INSERT INTO pwr_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","आमी जानसेजन का गिरंथ जोन कव्हासे उ हमेसा को लाई सच्चो से, अना परमेस्वर ना उन लोक हुनला परमेस्वर कहयो, जोन लोक हुनला ओको बारता दियो गयो होतो। ");
INSERT INTO pwr_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","“अता जोनला बाबूजी ना चघावा ठयरायके जगत मा धाड़ीसेस, का तुमी एकोलाई ओला कव्हसो, तु परमेस्वर की निन्दा करासेस? एकोलाय मि ना कव्हयो, मि परमेस्वर को टूरा सेउ। ");
INSERT INTO pwr_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","अदी मि आपरो दाअजी को मरजी को जसो काम नही करासू, ता मोरो भरोसा नोको करो। ");
INSERT INTO pwr_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","पर अदि मि आपरो मोठो दाअजी को काम करासेउ, ता चाहे मोरो बिस्वास नोको करो, पर काम पर ता बिस्वास करो। जोन लक तुम्हिला पता लग जाय का बाबूजी मोरो मा से अना मी बाबूजी मा सेऊ।” ");
INSERT INTO pwr_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","तबा उनना मंग ओला धरन को कोसिस करीन, पर उ उनको हात लक बूचक गयो। ");
INSERT INTO pwr_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","मंग उ यरदन नदी को वोनागन पराय गयो। जिता योहन पुढा बप्तिस्मा देवत होतो, अना उतच रहयो। ");
INSERT INTO pwr_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","तबा लगत लोक ओको कठा आयके कव्हन लगीन, योहन ना तो कोनी निसान नही दिसाइस, पर जोन काही योहन ना येको बारे मा सांगी होतीस, उ सब खरो से। ");
INSERT INTO pwr_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","अना उता लगत लोकगीन ना यीसु पर भरोसा करीन। ");
INSERT INTO pwr_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","एक आदमी को नाव लाजर होतो, उ आपरो बहिन मरियम अना मारथा को संग बैतनिय्याह नगर मा रव्हत होतो, उ बिमार भई गयो। ");
INSERT INTO pwr_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","या वाच मरियम से, जेना पिरभू पर इतर डाकके ओको पाय ला चुन्दी लक मलन लगीन। वोको भाऊ लाजर बीमार होतो। ");
INSERT INTO pwr_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","एको लाई ओकी बहिन गीनना ओको जवर खबर धाड़िन, “ओ पिरभू, अता चोव, जेनको लक तु माया राखसेस, उ बीमार पड़यो से।” ");
INSERT INTO pwr_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","यो आयक के यीसु ना कहीस, “यो बीमारी मरन लाय नहाय, पर परमेस्वर की महिमा लाय भईसे, जेनालक परमेस्वर को टूरा की महिमा होय।” ");
INSERT INTO pwr_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","यीसु मारथा, ओकी बहिन अना लाजर सब लक माया राखत होतो। ");
INSERT INTO pwr_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","जबा ओना आयकिस की लाजर बीमार से, तबा उ जहान होतो उतच दुई दिवस अखीन रूकयो। ");
INSERT INTO pwr_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","तबा उ चेला गीन लक कहीस, “आव आमी यहुदिया ला चलबीन।” ");
INSERT INTO pwr_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","चेला गीनना कहिन, “गुरू, अबा तो यहूदी तोला गोटा मारत होतीन, अना अबा तु उता जावासेस?” ");
INSERT INTO pwr_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","यीसु ना जवाब देईस, “का दिवस मा 12 तास नही होवासे? अदी कोनी दिवस-दिवस मा चलासे ता खोद्दा नही खावासे, काहेकि यो जगत को उजाड़ो चोवासे। ");
INSERT INTO pwr_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","पर अदी कोनी राति मा चलासे ता खोद्दा खावासे, काहेकि उ इंधारो मा चलासे।” ");
INSERT INTO pwr_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","यो गोस्टी सांगनो पर यीसु ना कहीस, “हमरो संगी लाजर जप मा से, मि ओला जगान जावासु।” ");
INSERT INTO pwr_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","तबा चेला ना ओला कहिन हे पिरभू अदी उ जप मा से, तो उ साजरो भई जाहे। ");
INSERT INTO pwr_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","यीसु ना तो वोको मौत को बारे मा सांगी होतीस, पर वय समजीन की जप को बारे मा सांगसेस। ");
INSERT INTO pwr_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","तबा यीसु ना उन लक सप्पा-सप्पा कह देईस “लाजर मर गई से, ");
INSERT INTO pwr_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","अखीन मि खुस सेव का आमी उता नही होता, का तुमी भरोसा करहो। पर आव, आमी ओको कठा जाबिन।” ");
INSERT INTO pwr_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","तबा थोमा, “जोन दिदमुस कहलावसे, आपरो संगी चेला गीन ला कव्हसे, आव, हमि भी ओको सँगा मरन ला चलबिन।” ");
INSERT INTO pwr_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","उता पहुचनो पर यीसु ला मालुम भयो, की लाजर ला मरयो अना मरघट्टी मा राखो चार दिवस भई, ");
INSERT INTO pwr_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","जोन बैतनिय्याह यरुसलेम को जवर कोनी तीन किलोमीटर की दुरी पर होतो। ");
INSERT INTO pwr_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","लगत यहूदिगीन मारथा अना मरियम को जवर ओको भाऊ की मौत पर सान्ती देवन लाई आई होतीन। ");
INSERT INTO pwr_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","जबा मारथा ना यीसु को आवन को खबर आयकिस, ता ओला मिलन को लाई गई, पर मरियम घर मा बसी रहयी। ");
INSERT INTO pwr_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","मारथा ना यीसु लक कहीस, हे पिरभू! अदी तु यहान होतो, ता मोरो भाऊ कभ्भूच नही मरतो ");
INSERT INTO pwr_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","अखीन अबा भी मि जानासेऊ की जोन कही तु परमेस्वर लक माँगजो ता परमेस्वर तोला देहे। ");
INSERT INTO pwr_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","यीसु ना ओको लक कहीस, तोरो भाऊ जिँदो भई जाहे। ");
INSERT INTO pwr_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","मारथा ना ओला कहीस, मि जानासेऊ की आखीर दिवस मा सबको जित्तो होवनो को बेरा उ जी उठेत। ");
INSERT INTO pwr_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","यीसु ना ओला कहीस, जित्तो होवनो, अना जिंदगी मि सेउ, जोन कोनी मोरो पर भरोसा करेत, उ अदी मर भी जाहेत ता भी जीहेत। ");
INSERT INTO pwr_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","अना जोन कोनी जित्तो से अना मोरो पर भरोसा करासे, उ अमर काल तकन नही मरेह। का तु भरोसा करसेस? ");
INSERT INTO pwr_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","ओना ओला कहीस, हव पिरभू, मि भरोसा करुसेउ, की तुच परमेस्वर को टूरा मसीह आस, जोन जगत मा आवनवालो होतो। ");
INSERT INTO pwr_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","यो कहके मारथा चली गई, अना आपरी बहिन मरियम ला बुलाके चुप्पी लक कहीस, गुरू यहान से अना तोला बुलावसेत। ");
INSERT INTO pwr_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","यो आयक के उ एकदम उठके ओको जवर आई। ");
INSERT INTO pwr_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","यीसु अबा गाँव मा नही पहुचियो होतो, पर ओना जघा मा होतो, जिता मारथा ना ओला मिली होती। ");
INSERT INTO pwr_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","तबा जोन यहूदी ओको सँग घर मा होतीन अना ओला सान्ती देय रही होतीन, यो चोयके मरियम एकदम उठके बाहेर गई, ता वय यो समझीन की उ मरघट्टी पर रोवन ला जावासे ता ओको मंघा भय गईन। ");
INSERT INTO pwr_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","जबा मरियम उता पहुची जिता यीसु होतो, ता ओला चोवके ओको पाय पर पड़ गई अना कहीस, हे पिरभू! अदी तुमी इता होतत, ता मोरो भाऊ नही मरतो। ");
INSERT INTO pwr_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","जबा यीसु ना ओला अना उन यहूदिगीन ला जोन ओको सँग आई होतीन रड़ता चोवयो, ता आतमा मा लगत उदास अना बैचेन भयो। ");
INSERT INTO pwr_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","अना कहीस, तुमी ना ओला किता रखिसेव? उनना ओला कहीन हे पिरभू चलके चोव लेव। ");
INSERT INTO pwr_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","यीसु रड़यो। ");
INSERT INTO pwr_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","तबा यहूदी कव्हन लागीन, चोवो उ ओको लक केतरो माया राखासे? ");
INSERT INTO pwr_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","पर उनमा लक काही ना कहीन, का यो जोन अँधरा की डोरा खोलिस, यो भी नही कर सकिस, की यो मानूस न मरतो। ");
INSERT INTO pwr_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","यीसु मन मा मंग लगत उदास भयो मरघट्टी पर आयो। उता एक गुफा होती, अना एक गोटा ओको पर राखियो होतो। ");
INSERT INTO pwr_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","यीसु ना कहीस, गोटा ला हटाय देव? उ मरयो हुयो की बहिन मारथा ओला कव्हन लगीस, हे पिरभू! ओमा लक अता ता बदबु आवासे, काहेका ओला मरयो हुयो चार दिवस भई गई सेत। ");
INSERT INTO pwr_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","यीसु ना वोला कहीस, का मिना तोला नही कव्हयो होतो? की अदी तु भरोसा करजोस ता परमेस्वर की महिमा ला चोवजोस। ");
INSERT INTO pwr_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","तबा उनना वो गोटा ला हटाईन, यीसु ना डोरा उठायके कहीस, हे बाबूजी! मि तोरो धनवाद करू सेऊ, की तु ना मोरी आयक लेई सेस। ");
INSERT INTO pwr_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","मि जानसु तु हमेसा मोरी आयकिसेस, पर जोन भीड़ इता-उता उभी से, उन ला भी भरोसा भय जाहे की तु ना मोला धाडिसेस, यो काजी मि ना असो कहीसेउ। ");
INSERT INTO pwr_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","यो कहके ओने मोठी आवाज लक हाकलीस, हे लाजर हिट आव। ");
INSERT INTO pwr_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","जोन मर गयो होतो उ कफन लक हात पाय बंधयो हिट आयो। अना ओको टोन्ड अंगोछा लक लिपटो होतो। यीसु ना कहीस, ओला उघाड़ देव अना जान देव। ");
INSERT INTO pwr_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","तबा जोन यहूदी मरियम को जवर आयो होतिन, अना ओको यो काम चोईन, उनमा लक लगत गीनना भरोसा करीन। ");
INSERT INTO pwr_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","पर उनमा लक काही ना मोसे को नियम को गुरू को जवर यीसु को काम को खबर देईन। ");
INSERT INTO pwr_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","एतरो पर मुखिया याजक अना मोसे को नियम को गुरू ना मोठी सभा बुलाईन अना कहिन, हमि का करबीन, यो मानूस तो लगत निसान चोवायोसे? ");
INSERT INTO pwr_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","अदी हमि ओला असोच सोड़ देबीन, तो सबच ओको पर भरोसा कर लेहेत, अना रोमी आयके आमरी जघा अना लोक दुही पर हक जमा लेहेत। ");
INSERT INTO pwr_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","तबा उनमा लक काइफा नाव को एक मोठो मुखिया याजक होतो। ओना कहीस, तुम काही भी नही जानो, ");
INSERT INTO pwr_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","अखीन नही समजासो, का तुमरो लाई यो भलो से, की हमरो काजी एक मानूस मरेत, अना सप्पा लोक को नास नोको होय। ");
INSERT INTO pwr_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","यो गोस्टी ओने आपरो कन लक नही कहीस, पर आवन वारो गोस्टी ला जानके, मोठो मुखिया याजक होवनो को कारन लक सांगीस, का यीसु ओना लोकगीन लाई मार दियो जाहेत। ");
INSERT INTO pwr_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","अना ना केवल उन लोक को लाय पर एकोलाय की परमेस्वर की गुमयो हुयो सँतान एकठ्ठो भयी जाहे। ");
INSERT INTO pwr_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","अखीन ओनो दिवस लक वय ओला मार डाकन की सलाह करन लगीन। ");
INSERT INTO pwr_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","एको लाई यीसु ओनो बेरा लक यहूदिगीन मा खुलो रित लक नही घुमयो, पर उता लक जंगल को जवर छेतर मा इफराईम नाव को एक नगर मा चली गयो, अना चेला गीन संगा उतच रव्हन लगयो। ");
INSERT INTO pwr_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","यहूदिगीन को फसह को तिहार जवर होतो। अना लगत सा लोक बलिदान को पुढा देहात लक यरुसलेम मा गईन, की आपरो आप ला पवीतर करयेत। ");
INSERT INTO pwr_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","एको लाई वय यीसु ला ढुढन लगीन, अना मंदिर मा उभा होयके आपस मा कव्हन लागिन, तुमी का सोचासो? का उ तिहार मा नही आहे। ");
INSERT INTO pwr_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","मोठो मुखिया याजक अना मोसे को नियम को गुरू ना यो हुकूम देईन, का अदी कोनी यो जाने की यीसु किता से ता सांगे, ताकि ओला धर लेबो। ");
INSERT INTO pwr_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","यीसु फसह को तिहार लक छह दिवस पुढा बैतनिय्याह नगर मा आयो, जिता लाजर होतो। जेनला यीसु ना मरो मा लक जित्तो करी होतिस। ");
INSERT INTO pwr_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","उता उनना ओको लाई जेवन तैय्यार करी होतीन, अना मारथा सेवा करत होती। लाजर उनमा लक एक होतो, जोन ओको सँगा जेवन लाई बसयो होतो। ");
INSERT INTO pwr_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","तबा मरियम ना जटामाँसी को ढाई किलो सुध्द कीमती इतर आनके यीसु को पाय पर डाकीस, अना चुन्दी लक ओको पाय ला मलन लगीस अना इतर की महक लक सारो घर महकन लगयो। ");
INSERT INTO pwr_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","पर ओको चेला मा लक यहूदा इस्करियोति नाव को एक चेला जोन ना ओला धरायो, कव्हन लगयो। ");
INSERT INTO pwr_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","यो इतर तो तीन सौ सिक्का मा बेचो भी जाय सकासे अना गरिब गोर गीनला दियो जाय सकासे। ");
INSERT INTO pwr_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","यो बात ओना एको लाई नही कहीस, की ओला गरीब गोर की चिंता होती, पर एको लाई कहीस, की उ चोट्टा होतो, अना ओको जवर ओकी पियुसी रहोत होती। अना ओको मा जो काही डाकयो जावत होतो उ हेड़ लेत होतो। ");
INSERT INTO pwr_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","यीसु ना कहीस, ओला रव्हन देव, ओला मोरो गाड़ो जावन को दिवस को लाय करन देव। ");
INSERT INTO pwr_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","काहे की गरीब गोर तो तुमरो सँगा हमेसा रव्हेत,, पर मि तुमरो सँगा हमेसा नही रहुँ। ");
INSERT INTO pwr_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","जबा यहूदी को मोठी भीड़ यो जान गईन, का उ उता से, ता वय केवल यीसु को काजी नही, बल्कि एको लाई भी आइन, का लाजर ला चोवबोन, जेनला ओने मरयो हुयो मा लक जित्तो करी होतिस। ");
INSERT INTO pwr_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","तबा मोठा मुखिया याजक ना लाजर ला भी मारन की साजिस करीन। ");
INSERT INTO pwr_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","काहेकि ओको काजी लगत सा यहूदी ओको पक्स मा भय गई होतीन, अना ओको पर भरोसा कर रही होतिन। ");
INSERT INTO pwr_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","दुसरो दिवस लगत सा लोकगीन ना जोन तिहार मा आई होतीन उनना आयक के की यीसु यरुसलेम मा आय रहयो से। ");
INSERT INTO pwr_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","लोकगीन खजुर की डारी लेईन, अना ओला मिलन को लाई हिटिन। “अना चिल्लाके कव्हन लगीन।” बड़ाई होय, “धन्य से इसरायल को राजा।” जो पिरभू को नाव लक आवासे। ");
INSERT INTO pwr_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","जबा यीसु ला गदही को एक बच्चा मिलयो, ता उ ओको पर बस गयो। जसो ओको बारे मा लिखि से। ");
INSERT INTO pwr_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“अवो सिय्योन की टूरी, भेव नोको राख, देख, तोरो राजा गदही को बछेरु पर चघके चलत आय रही से।” ");
INSERT INTO pwr_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","यीसु को चेलागीन यो गोस्टी नही समजयो होतीन, पर यीसु को महिमा मिलन को मंघा उनला हेत आयी, का यो वोको बारे मा लिखीसे अना लोक गीनना वोको संग असोच कियो होतो। ");
INSERT INTO pwr_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","तब भीड़ मा वय मानूस गीन गवाही देयीन, जोन बेरा लाजर ला मरघट्टी लक हाकल के यीसु ने जित्तो कियो होतो वोच बेरा चोयो होतीन। ");
INSERT INTO pwr_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","एको लाई लगत लोक गीन यीसु को आवभगत करन लाई हिटीन। ओन्हीसीन आयकीन का यीसु ना यो निसान चोवाइसेस। ");
INSERT INTO pwr_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","यो सब चोय के मोसे को नियम को गुरू ना एकमेक लक कहिन, “चोव रहिसेव ना, तुमी लक काही नही होय सका। चोवो सप्पा संसार ओको मंघा चल रही से।” ");
INSERT INTO pwr_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","जोन लोक तिहार को बेरा मा पूजा करन आई होतीन, उनमा काही यूनानी होतीन। ");
INSERT INTO pwr_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","उनना फिलिप्पुस को जवर आयके यो बिनती करीन, महोदय, आमी यीसु पिरभू लक मिलन आईसेजन। फिलिप्पुस गलील छेतर को बैतसेदा नगर को रव्हन वालो होतो। ");
INSERT INTO pwr_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","उ गयो अना अन्दिरयास ला यो सांगिस, तबा अन्दिरयास अना फिलिप्पुस गईन अना उनना यीसु ला एको बारे मा खबर देईन। ");
INSERT INTO pwr_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","यीसु ना उन लक कहीस, उ बेरा आय गईसे, जबा मानूस को टूरा महिमा ला पाय लेहे। ");
INSERT INTO pwr_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","मि तुमी लक खरो सांगासेउ जबा तकन गँहु को बीज माती मा पड़के मर नही जासे तबा तकन उ एकलो रव्होसे, पर अदी उ मर जावासे ता लगत फर देवासे। ");
INSERT INTO pwr_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","जोन आपरो जान लक माया करासे, उ ओला नास करासे, अना जोन यो संसार मा आपरो जान लक बैर करासे, उ ओला अमर जिन्दगी कोलाय सुरक्सित राखासे। ");
INSERT INTO pwr_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","अदी कोनी मोरो दास बननो चाव्हासे तो मोरो मंघा चले, जिता मि सेउ, उता मोरो चेला भी रव्हेत, अदी कोनी मोरी सेवा करनो चाव्हासे ता बाबूजी ओको मान करेत। ");
INSERT INTO pwr_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“अब मोरी मन बेचेन से, का मि यो कहुँ, बाबूजी, यो बेरा को आफद लक मोला बचाव? काहेका यो काजी मि यो बेरा तकन पहुची सेउ। ");
INSERT INTO pwr_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","ओ बाबूजी! लोकगीन मा आपरो नाव की महिमा कर।” ओनो बेरा मा यो सरग लक आवाज आई, का मिना आपरो नाव की महिमा करीसेव, अना मंग ओको महिमा करू। ");
INSERT INTO pwr_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","इता उता लोक गीनना आयक के कहिन बादल गरजियो, काही लोकगीन ना कहिन, एक सरगदूत ना वोला काही सांगयो से।। ");
INSERT INTO pwr_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","यीसु ना सांगीस यो आवाज मोरो लाई नही, बलिक तुमी लोकगीन लाय से। ");
INSERT INTO pwr_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","अब यो संसार को न्याय होवा से, अब यो संसार को मुखिया हेड़ दियो जाहे। ");
INSERT INTO pwr_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","अना मि जबा धरती लक वरता उचलो जाहुँ। तबा सब मानूस गीनला आपरो कन झीक लेहुँ। ");
INSERT INTO pwr_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","ऐना सबद लक यीसु ना ईसारा करीस, का ओकी मिरतु कोन तरीको लक होयेत? ");
INSERT INTO pwr_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","लोकगीन ना असो सांगीन, मोसे को नियम हमला यो सिक्सा देसे की मसीह सदा रहेत, मंग तु यो कायलाय कव्हसेस, की मानूस को टूरा ला वरता जानो जरूरी से? यो मानूस टूरा कोन आय? ");
INSERT INTO pwr_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","एतरो पर यीसु ना उन ला कहीस, अता कम बेरा से की उजाड़ो तुमरो संग से। जबा तकन उजाड़ो तुमरो जवर से पुढा बढ जाओ। कहीं असो न होहे की इंधारो तुमला घेर ले। जोन इंधारो मा चला से वा नही जान सका की किता जावसे? ");
INSERT INTO pwr_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","जबा तकन उजाड़ो तुमरो जवर से उजाड़ो पर भरोसा ठेवो, जोन लक तुम्हि उजाड़ो की सँतान बन सको। असो कव्हनो पर यीसु चली गयो अना उनको लक लुक गयो। ");
INSERT INTO pwr_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","मंग यीसु ना उनको पुढ एतरो निसान चोवाइस, मंग उनना भरोसा नही करीन। ");
INSERT INTO pwr_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","एकोलाय भविस्यवक्ता यसायाह को यो कव्हनो पूरो भयो का, ओ पिरभू! हमरो साजरो खबर पर कोन भरोसा ठेइस ? अना पिरभू को हात को ताकत कोन पर परगट भयो से? ");
INSERT INTO pwr_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","वय एको लाई भी भरोसा नही कर सकीन, का भविस्यवक्ता यसायाह ना यो कव्हयो होतो, ");
INSERT INTO pwr_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","मोठो परमेस्वर ना उनको डोरा ला अँधरा कर देइस अना उनको अक्कल ला सटया देइस। परमेस्वर ना कव्हयो, कहीं असो न होहे की वय डोरा ला चोयेत, अना अक्कल लक समजेत। अना मोरो मंघा भय जाहेत। अना मि उन ला साजरो कर देहुँ। ");
INSERT INTO pwr_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","यसायाह ना यो सबच एको लाई साँगीस, की उनना यीसु की महिमा ला चोयी होतो, अना वोको बारे मा सांगीस ");
INSERT INTO pwr_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","मंग अधिकारी मा लक काही ना ओको भरोसा करीन, पर मोसे को नियम को गुरू को पुढा ओला नही अपनात होतीन। उनला डर होतो की सभा लक उनला कही नोको ठुकराय दियो जाय। ");
INSERT INTO pwr_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","उनला परमेस्वर को मान लक ज्यादा, मानूस को मान को माया होतो। ");
INSERT INTO pwr_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","यीसु ना हाकलके कहीस, “जोन मोरो पर भरोसा करासे उ मोरो पर नही पर जोनना मोला धाड़िसेस ओको पर करासे। ");
INSERT INTO pwr_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","अना जोनना मोला चोवीसेस, ओना मोरो धाड़न वालो ला चोवीसेस। ");
INSERT INTO pwr_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","मि जगत मा उजाड़ो होयके आईसेऊ, एकोलाय जोन कोनी मोरो पर भरोसा करेत, उ इंधारो मा नही रव्हेत। ");
INSERT INTO pwr_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","अदी कोनी मोरी गोस्टी ला आयकसे अना नही मानासे ता मि ओला सजा नही देहु। काहेकि मि जगत ला अपराधी ठहरावन को लाय नही, पर जगत ला सूटकारा देवन ला आईसेऊ। ");
INSERT INTO pwr_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","जोन मोला बेकार जानासे अना मोरी गोस्टी नही अपनावासे, ओला अपराधी ठयरावन वालो तो एक से, जेना गोस्टी मिना सांगीसेउ, वा बितो दिवस मा ओको न्याय करयेत। ");
INSERT INTO pwr_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","काहे की मिना आपरो कन लक गोस्टी नही करिसेऊ, पर बाबूजी जोनना मोला धाड़िसेस ओना मोला हुकूम देईसेस, मि काजक कहुँ, अना मि काजक सांगीन? ");
INSERT INTO pwr_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","अना मि जानासेऊ का ओको हुकूम अमर जिंदगी से, एकोलाय मि जेना गोस्टी ला सांगासु, बाबूजी ना मोला जसो सांगीसेस, वसोच सांगासु।” ");
INSERT INTO pwr_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","फसह को तिहार को पुढा जबा यीसु ना जान लियो का मोरी बेरा आय गयो से, का मी जगत ला सोड़के बाबूजी को जवर जावनो से, ता आपरो लोकगीन लक जोन जगत मा होतीन, उनलक जसो माया उ राखत होतो, आखरी बेरा भी वसोच माया राखिस। ");
INSERT INTO pwr_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","अना जबा सैतान समोन को टूरा यहूदा इस्करियोति को मन मा यो गोस्टी डाक चुकयो होतो, का ओला धरवाए। ");
INSERT INTO pwr_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","यीसु ना यो जानके की, बाबूजी ना सब काही मोरो हात मा कर देईसेस। अना मि परमेस्वर को जवर लक आईसेऊ, अना परमेस्वर को जवर जासू। ");
INSERT INTO pwr_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","जेवन लक उठके आपरो कपरा ला उतार देईस, अना गमछा लक आपरी कम्मर ला बाँधिस ");
INSERT INTO pwr_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","तबा बरतन मा पानी भरके चेला को पाय धोवन लगयो, अना गमछा लक पोसन लगयो। ");
INSERT INTO pwr_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","जबा उ समौन पतरस को कठा गयो, तबा पतरस ना ओला कहीस, का “हे पिरभू, का तु मोरो पाय धोवसेस?” ");
INSERT INTO pwr_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","यीसु ना साँगीस, “जोन मि करासेऊ, तु ओला अबा नही जानस, पर एको मंघा समज जाजोस।” ");
INSERT INTO pwr_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","पतरस ना ओला कहीस, “तोला मी आपरो पाय कभ्भू नही धोवन देहू।” असो आयक के यीसु ना कहीस, अदी तू मोला तोरो पाय नही धोवन देजोस ता हरामेसा को लाय तोरो मोरो काही नाता नहात। ");
INSERT INTO pwr_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","समौन पतरस ना ओला कहीस, हे पिरभू ता मोरो पाय ला च नही पर हात अना डोस्का ला भी धोय देव। ");
INSERT INTO pwr_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","यीसु ना ओला कहीस जोन आंग खोर लियो सेत, वोला पाय को सिवा अखीन काही धोवन को जरूरत नहाय, पर वा सुध्द से। तुम्हि सुध्द सेव पर सबच नही। ");
INSERT INTO pwr_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","उ आपरो धरानवालो ला जान गयो होतो, एको लाई ओना कहीस, तुम्हि सब का सब सुध्द नहाव। ");
INSERT INTO pwr_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","जबा उ उनको पाय धोय चुकयो, अना आपरो कपरा डाकके बस गयो, ता उन लक कव्हन लगयो, का तुम्हिला समजमा आयो! मिना तुमरो सँग काजक करीसेव? ");
INSERT INTO pwr_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","तुमी मोला गुरू अना पिरभू कव्हसो अना साजरो च कव्हसो, काहे का मि वाच सेऊ। ");
INSERT INTO pwr_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","अदी मी पिरभू अना गुरू होयके तुमरो पाय धोयो, तो यो जरुरी सेत का तुमी भी एकमेक को पाय धोवो। ");
INSERT INTO pwr_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","काहे की मिना तुमला उदाहरन चोवायो सेऊ, का जसो मिना तुमरो सँग करीसेऊ तुमी भी वसोच करो। ");
INSERT INTO pwr_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","मि तुमी लक खरो कव्हसू, दास आपरो पिरभू लक मोठो नही होवासे, अना ना धाडयो गयो आपरो धाड़न वालो लक, ");
INSERT INTO pwr_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","तुमी यो गोस्टी जानासेव, अना अदी उन पर चलो तो धन्य सेव। ");
INSERT INTO pwr_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","मी तुम्हि सबको बारेमा नही सांगासेऊ, काहेका जोनला मिना निवाड़ी सेव ओला मि जानासू। पर यो एको लाय भयो से का, पवितर गिरंथ को उ गोस्टी पूरो भयी जाय “का जोन ना मोरो जेवन जेयो सेत, वोनाच मोला लात मरा सेत।” ");
INSERT INTO pwr_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","अता मि तुमला हेत दिलासू, का जबा यो गोस्टी भय जाहे तो तुमी भरोसा करो। की मि वाच सेव। ");
INSERT INTO pwr_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","मि तुमी लक खरो कव्हासू जोन मोरो धाड़न वारो ला अपनावसे, उ मोला अपनावासे अना जोन मोला अपनावसे उ मोरो धाड़नवालो ला अपनावासे। ");
INSERT INTO pwr_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","यो गोस्टी ला साँगके यीसु आतमा मा बैचेन भयो अना ओना गवाही देइस मि तुमी लक खरो कव्हसु, की तुमी मा लक एक से, जोन मोला धराहे। ");
INSERT INTO pwr_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","चेला गीनला संका भई की वा कोन को बारे मा सांगासे? ता वय एकमेक कन चोवन लगीन। ");
INSERT INTO pwr_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","उन चेला मा लक एक जोन यीसु लक माया करत होतो, ओको छाती कन नवके बसत होतो। ");
INSERT INTO pwr_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","तबा समौन पतरस ना ओला ईसारा करके पुसयो, साँग, उ कोन को बारे मा कव्हासे? ");
INSERT INTO pwr_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","तबा ओना ओच तरिका लक यीसु की छाती कन नवके ओको लक पुसिस, हे पिरभू उ कोन आय? ");
INSERT INTO pwr_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","यीसु ना वोकोलक सांगीस, जोनला मि यो भाकर को टुकड़ा डुबा के देहुँ वाच से, ओना टुकड़ा ला डुबायके समोन इस्करियोति को टूरा यूदूस ला देईस। ");
INSERT INTO pwr_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","टुकड़ा लेवन को मंघा सैतान ओमा समाय गयो। तबा यीसु ना कहीस, जोन काम तु करन चाव्हासेस वा गदने कर। ");
INSERT INTO pwr_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","पर बसन वालो मा लक कोनी नही जान पायो, का यो गोस्टी ओना ओला काय लाई कहीस। ");
INSERT INTO pwr_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","यहूदा को जवर पियुसी रव्हत होतो एकोलाय काही-काही ना समजीन का यीसु ओला यो कव्हासे जो काही हमला तिहार को लाई पाहिजे उ लेके आन। या यो कहीस, गरीब गोर ला काही देव। ");
INSERT INTO pwr_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","येने परकार लक उ टुकड़ा धरयो अना बाहेर हीट गयो, वा रात को बेरा होती। ");
INSERT INTO pwr_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","जबा उ बाहेर चली गयो ता यीसु ना कहीस अबा मानूस को टूरा को बड़ाई होवासे, अना परमेस्वर की महिमा ओमा भयोसे। ");
INSERT INTO pwr_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","अदी ओमा परमेस्वर की महिमा होवासे, तो परमेस्वर भी आपरो लक ओकी महिमा करेत, अना तुरतई करेत। ");
INSERT INTO pwr_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","ओ टूराहुन, मि जरा सो बेरा तकन तुमरो जवर सेउ, मंग तुम्हि मोला ढुंढने, जसो की मि यहूदिगीन लक कव्हसू, जिता मि जावासेऊ, उता तुमी नही आय सको, वसोच तुम्हिला भी कव्हासू। ");
INSERT INTO pwr_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","मि तुम्हिला एक नवतो हुकूम देवासु, का एकमेक लक माया करो, जसो मि तुम्हरो लक माया राखासु, वसोच तुम्हि एकमेक लक माया राखो। ");
INSERT INTO pwr_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","अदी आपसी मा माया राखो, ता सबच जान जाहेत, का तुम्हि मोरो चेला आव। ");
INSERT INTO pwr_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","समौन पतरस ना ओला कहीस, हे पिरभू तु किता जावसेस? यीसु ना जवाब देइस, जिता मि जावसु उता तु नही आय सकस, पर येको मंघा मोरो मघानी आवजोस। ");
INSERT INTO pwr_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","पतरस ना ओला कहीस, हे पिरभू अबा मि तोरो मंघा काय लाई नही आय सकु? मि तो तोरो लाई आपरो जान भी दे देहुँ। ");
INSERT INTO pwr_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","यीसु ना जवाब देइस, का तु मोरो लाई आपरो जान देजोस? मि तोरो लक खरो सांगासु का कुकड़ा चिल्लावन को पहले तु मोरो नाव लक तीन डाई मुकर जाजोस। ");
INSERT INTO pwr_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","तुमरो मन बैचेन नोको होय, तुम्हि परमेस्वर पर भरोसा राखिसो, मोरो पर भी भरोसा राखो। ");
INSERT INTO pwr_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","मोरो बाबूजी को घर मा लगत सा रव्हन को जघा सेत, अदी नही होतो ता मि तुम्हिला सांग देतो। काहे की मि तुमरो लाय जघा तैय्यार करन जावासू। ");
INSERT INTO pwr_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","अना अदी मि जायके तुमरो लाई जघा तैय्यार करासू, ता मंग आयके तुमला आपरो सँग ले जाहुँ। की जिता मि रव्हुसु, उतच तुम्हि भी रव्हो। ");
INSERT INTO pwr_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","अना जिता मि जावनो पर सेव, तुम्हि उता को रास्ता ला जानासेव। ");
INSERT INTO pwr_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","थोमा ना कहीस, हे पिरभू हमला मालूम नहाय, का तु किता जावसेस। ता रास्ता कसो जानबोन? ");
INSERT INTO pwr_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","यीसु ना ओला कहीस, रास्ता, खराई अना जीवन मिच आव। मोरो बगर कोनी बाबूजी को जवर नही जाय सका। ");
INSERT INTO pwr_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","अदी तुमी मोला जानने, ता मोरो बाबूजी ला भी जानने। पर अब तुम्हि ओला जान गयो सेव अना चोवासो। ");
INSERT INTO pwr_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","फिलिप्पुस ओला कव्हसे, हे पिरभू! बाबूजी ला हमला चोवा। याच हमरो लाई लगत से। ");
INSERT INTO pwr_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","यीसु ना ओला कहीस, हे फिलिप्पुस, मि एतरो दिवस तकन तुमरो जवर रहयो, अना का तु मोला नही जानासे? एको लाई जोन ना मोला चोय लियो ओना बाबूजी ला चोय लेइसेस। तु कायलाय कव्हसेत की बाबूजी ला हमला चोवाय? ");
INSERT INTO pwr_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","का तोला भरोसा नहात? का मि बाबूजी मा सेव अना बाबूजी मोरो मा से, यो गोस्टी जोन तुमी लक कव्हसु आपरो आपच लक नही कव्हसू पर बाबूजी जोन मोरो मा से, आपरो काम करासे। ");
INSERT INTO pwr_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","मोरोच भरोसा करो की मि बाबूजी मा सेव अना बाबूजी मोरो मा से। नही ता काम लक च मोरो भरोसा करो। ");
INSERT INTO pwr_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","यीसु ना उनला खरो साँगीस, जोन मोरो पर भरोसा करासे, जसो काम मि करासू, वसोच काम उ भी करेत, वरन ओको लक भी मोठो काम करेत। ");
INSERT INTO pwr_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","मि तुम्हि लोकगीन लक खरोखर कव्हसू-अना जोन काही तुम्हि मोरो नाव लक माँगने ता वा पूरो होहेत। जोनलक मोरो लक बाबूजी की महिमा होहे। ");
INSERT INTO pwr_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","अदी कोनी बात ला तुम्हि लोकगीन मोरो नाव लक माँगो ता मि ओला करहुँ। ");
INSERT INTO pwr_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","अदी तुमी मोरो लक माया राखने ता मोरी हुकूम ला मानने ");
INSERT INTO pwr_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","मि बाबूजी लक बिनती करुहुँ अना उ तुमला एक अखीन सहारा देहे की उ सदा तुमरो सँग रहे ");
INSERT INTO pwr_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","मजे खराई को आतमा, जेनला ना तो जगत अपनाव सकासे, ना ओला जानासे, काहे की उ तुमरो संग च रव्हासे अना तुममा च होहे। ");
INSERT INTO pwr_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","मि तुमला फिरतहा नहि छोड़ू, मि तुमरो जवर आवासेऊ। ");
INSERT INTO pwr_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","जरासो देर मंघा यो जगत मोला नही चोवहे। पर तुमी मोला चोवहो, एको लाई की मि जित्तो सेव, तुमी भी जित्तो रव्हो। ");
INSERT INTO pwr_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","उ दिवस तुमी जानने की मि आपरो बाबूजी मा सेव, अना तुम्हि मोरो मा सेव अना मि तुमरो मा सेव। ");
INSERT INTO pwr_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","जोनो को जवर मोरो हुकूम सेत अना उ ओला मानासे। वाच मोरो लक माया राखासे, अना मी ओको लक माया राखुँ। अना आपरो आप ला ओको पर परगट करुह। ");
INSERT INTO pwr_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","एक यहूदा नाव को चेला जो इस्करियोति नही होतो, ओला कहीस, “हे पिरभू, का भयो का तु आपरो आप ला हमि पर दिखान चाव्हासेस अना जगत पर नही।” ");
INSERT INTO pwr_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","यीसु ना जवाब देईस, अदी कोनी मोरो लक माया राखेह, ता उ मोरो सबद ला मानेह। अना मोरो बाबूजी ओको लक माया राखेह, अना हमि ओको जवर आवबिन अना ओको सँग रव्हबिन। ");
INSERT INTO pwr_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","जोन मोरो माया नही राखा, उ मोरो गोस्टी ला नही मानासे अना जोन गोस्टी तुमीना आयकीसेव, उ मोरो नही पर बाबूजी को से, जोनना मोला धाड़िसेस। ");
INSERT INTO pwr_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","यो गोस्टी मिना तुमरो सँग रहतो बखत कव्हसू। ");
INSERT INTO pwr_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","पर जबा उ सहायक मजे पवीतर आतमा आहेत, जोनला बाबूजी मोरो नाव लक धाडे़त, उ तुम लोकगीन ला सबच गोस्टी सिखाहे। अना सब काही हेत कराहे, जोनला मिना कहीसेउ। ");
INSERT INTO pwr_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","मि तुमला सान्ती देय के जासू, आपरो सान्ती तुमला देवासु। जसो जगत देसे वसो मि तुमला नही देहुँ, तुमरो मन बेचैन नोको होयेत, अना नोको डराव। ");
INSERT INTO pwr_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","तुमी आयकासेव का मिना तुमला कव्हयो होतो, मि जावासू अना तुमरो जवर मंग आहू, अदी तुम्हि माया राखिसेव तो यो गोस्टी लक खुस होवो की मि बाबूजी को जवर जावासू, अना बाबूजी मोरो लक मोठो से। ");
INSERT INTO pwr_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","मिना तुमला असो होवनो को पुढा कव्ह देइसेव, की जबा उ भय जाहे, ता तुमी भरोसा करहो। ");
INSERT INTO pwr_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","मि अबा तुमरो सँग अखीन गोस्टी नही करू। काहे का यो जगत को अधिकारी आवासे, मोरो पर ओको काही हक नही। ");
INSERT INTO pwr_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","पर यो एकोलाय होवासे, की जगत जानेह की मि बाबूजी लक माया राखासू, अना जसो बाबूजी ना मोला हुकूम देइसेस वसोच करूसू, उठो, यहान लक चलो। ");
INSERT INTO pwr_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","खरो अंगूर की बेला मि सेव। अना मोरो बाबूजी कास्तकार से। ");
INSERT INTO pwr_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","जोन डाली मोरो मा से अना नही फरासे, ओला उ काट डाकासे, अना जो फरासे, ओला छाटासे, जोन लक अखीन फरेत। ");
INSERT INTO pwr_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","तुम्हि तो उ गोस्टी लाय सुध्द सेव जोन मिना सांगासेऊ, ");
INSERT INTO pwr_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","तुम्हि मोरो मा बनो रव्हो, अना मि तुमरो मा, जसो डार अदी अंगूर बेला मा बनी रव्हसे, ता तबच फर सकेत। ");
INSERT INTO pwr_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","मि अंगूर बेला सेव, तुमी डार सेव, जोन मोरो मा बनो रव्हासे, अना मि ओमा, उ लगत फर फरासे, काहेकि तुम्हि मोरो लक बेगरो भयके, तुम्हि काही नही कर सको। ");
INSERT INTO pwr_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","अदी कोनी मोरो मा बनो नोको रव्हेत, ता उ डार को जसो फेक दियो जावासे, अना सूक जावासे, अना लोक गीन उनला एकठ्ठो करके स्तो मा झोक देवासेत, अना वय जर जासेत। ");
INSERT INTO pwr_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","अदी तुम्हि मी मोरो मा बनयो रव्हो अना मोरो गोस्टी तुमी मा बनी रव्हो, तो जोन चाव्हो माँगने तो उ तुमरो लाय भई जाहे। ");
INSERT INTO pwr_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","मोरो बाबूजी की बड़ाई योच लक होवासे, तुम्हि लगत सा फर आननो, तबाच तुम्हि मोरो चेला कहलाने। ");
INSERT INTO pwr_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","जसो बाबूजी ना मोरो लक माया राखीसेस, वसोच मिना तुमी लक माया राखीसेऊ, मोरो माया मा बनो रव्हो। ");
INSERT INTO pwr_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","अदी तुमी मोरो हुकूम ला मानने तो मोरो माया मा बनयो रव्हने। जसो की मीना आपरो बाबूजी को हुकूम ला मानीसेऊ, अखीन ओको माया मा बनयो रहोसेऊ। ");
INSERT INTO pwr_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","मिना यो गोस्टी तुम्हि लक एकोलाय कहीसेउ, की मोरो खुसी तुम्हि मा बनो रव्हो, अना तुम्हरो खुसी पूरो भई जाहे। ");
INSERT INTO pwr_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","मोरो हुकूम यो से की जसो मिना तुम्हि लक माया राखीसेऊ, वसोच तुम्हि भी एकमेक लक माया राखो। ");
INSERT INTO pwr_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","एको लाई मोठो माया कोनतो से?का कोनी आपरो संगी को लाई आपरो जान देदे? ");
INSERT INTO pwr_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","जोन हुकूम मि तुम्हिला देसु, अदी ओला मानने तो तुम्हि मोरो संगी सेव। ");
INSERT INTO pwr_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","अता अबा लक मि तुम्हिला दास नही कहुँ, काहे की नौकर ला मालुम नही रव्हासे का वोको मालीक काजक करासे?पर मि ना तुमला संगी कहीसेउ, काहे की मिना जोन गोस्टी आपरो बाबूजी लक आयकासेऊ, वय सबच तुमला साँग देइसेउ। ");
INSERT INTO pwr_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","तुम लोकगीन ना मोला नही निवाड़ो सेव पर मिना तुमला निवाड़ी सेव अना तुमला ठहराई सेउ की तुमी जायके फर आनो अना तुमरो फर बनो रहे। की तुम्हि मोरो नाव लक जोन काही बाबूजी लक माँगो, उ तुमला देहे। ");
INSERT INTO pwr_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","यो गोस्टी को हुकूम, मि तुमला एको लाई देवसु की तुमी एकमेक लक माया राखो। ");
INSERT INTO pwr_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","अदी जगत तुमरो लक बइर राखासे तो तुम्हि जानासो की ओना तुमरो लक पुड़ा मोरो लक बयिर राखिस। ");
INSERT INTO pwr_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","अदी तुमी जगत का होतत, तो जगत तुमरो लक माया राखतो, पर एको काजी की तुमी जगत को नही सेव, काहेका मि ला जगत मा लक निवाड़ी सेव। एकोलाय जगत तुमी लक बइर राखासे। ");
INSERT INTO pwr_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","जोन गोस्टी मिना तुमी लक कहीसेउ, वोला हेत राखो, दास आपरो पिरभू लक मोठो नही होवासे, अदी ओन्हीसीन मोला तगाईन, तो तुमला भी तंगाहेत। अदी ओन्हिसीन मोरी गोस्टी मानीन, तो तुमरो भी मानहेत। ");
INSERT INTO pwr_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","पर यो सबच काही वय मोरो नाव को कारन तुमी लोक सँग करहेती। काहे की वय मोरो धाड़न वालो ला नही ओरखासेस। ");
INSERT INTO pwr_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","अदी मि नही आतो, अना उनलक गोस्टी नही करतो, तो वय पापी नही ठयरतिन, पर अबा उनला उनको पाप लाई कोनी बहाना नाहती। ");
INSERT INTO pwr_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","जोन मोरो लक बइर राखसेत, उ मोरो बाबूजी लक भी बइर राखसेत। ");
INSERT INTO pwr_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","यदी मिना उनमा वय काम नही करतो जोन कोनी ना नही करयो सेत, ता वय पापी नही ठयरतत। पर अबा तो उनना मोला अना मोरो बाबूजी दुही ला चोवीसेत अना दुही लक बइर कियो, ");
INSERT INTO pwr_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","यो एकोलाय भयो का वा सबद पूरो होय, जोन उनको मोसे को नियम मा लिखीसे, “उनना मोरो लक बेकार च बइर करीसेत।” ");
INSERT INTO pwr_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","पर जबा उ सहायक आहे मजे खराई को आतमा जेनला मि तुमरो जवर बाबूजी को कन लक धाड़हु मजे सत को आतमा, जोन अजी को कनलक हीटासेत वो मोरो गवाही देहेत। ");
INSERT INTO pwr_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","अना तुमी भी मोरो गवाही सेव काहे की तुमी सुरु मा मोरो सँग रही सेव। ");
INSERT INTO pwr_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","यो गोस्टी मिना तुमी लक एकोलाय सांगासू का तुम्हि डावाडोल नोको होव। ");
INSERT INTO pwr_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","वय तुम्हिला पिराथना सभा अना समाज लक हेड़ देहेत, इतरोच नही पर उ बेरा आवासे, की जो कोनी तुमला मार डाकेह, उ समजेत की मि परमेस्वर की सेवा करुसु। ");
INSERT INTO pwr_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","असो वय एकोलाय करयेत, की उन बाबूजी ला नही जानासेत, अना मोला भी नही जानासेत। ");
INSERT INTO pwr_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","पर यो गोस्टी मिना एकोलाय तुमी लक सांगीसेउ की जबा एको बेरा आहे तो तुमला हेत आहे की मिना तुम्हि लक पुढा च सांग दियो होतो। ");
INSERT INTO pwr_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","मि ना सुरु मा तुम्हि लक यो गोस्टी एकोलाय नही सांगयो, काहे की मि तुम्हारो सँग होतो, पर अबा मि आपरो धाड़नवालो को जवर जावासू अना तुम्हि मा लक कोनी मोरो लक नही पुसेत, तु कहाँन जासेस? ");
INSERT INTO pwr_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","पर मिना जोन गोस्टी तुमी लक सांगीसेउ एकोलाय तुम्हारो मन सोक लक भरीयो से। ");
INSERT INTO pwr_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","ता भी मि तुम्हि ला खरो सांगासू, का मोरो जावनो तुमरो लाय साजरो से, काहेकी अदी मि नही जाऊ तो उ सहायक तुमरो जवर नही आहेत, पर अदी मि जाउ तबा ओला तुमरो जवर धाड़ू। ");
INSERT INTO pwr_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","उ आयके जगत ला पाप अना नेकी अना न्याय को बारेमा बेजवाब करेत। ");
INSERT INTO pwr_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","पाप को बारे मा एकोलाय की वय मोरो पर भरोसा नही करयेत। ");
INSERT INTO pwr_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","अना नेकीपन को बारे मा एकोलाय की मि बाबूजी को जवर जासू अना तुमी मोला मँग नही चोहो। ");
INSERT INTO pwr_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","न्याय को बारे मा एकोलाय का जगत को मुखिया दोसी ठयरायो गई से। ");
INSERT INTO pwr_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","मोला तुम्हि लक अखीन भी लगत सी गोस्टी कव्हनो से, पर अबा तुमी उनला सहन नही कर सकेत। ");
INSERT INTO pwr_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","पर जबा उ असो खराई को आतमा आहे, ता तुमला सबच खराई को रास्ता सांगेत, काहेकी उ आपरो कन लक नही सांगेत पर जोन-जोन काही आयकेत वाच ला सांगेत अना आवनवालो गोस्टी तुमला सांगेत। ");
INSERT INTO pwr_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","उ मोरी बड़ाई करेत, काहेकि उ मोरो गोस्टी लक तुम्हिला सांगेत। ");
INSERT INTO pwr_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","जोन काही बाबूजी को से, उ सबच मोरो से, एकोलाय मिना कव्हयो का उ मोरी गोस्टी मा लक तुम्हिला सांगेत। ");
INSERT INTO pwr_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","जरासो बेरा को बादमा तुम्हि मोला नही चोवने पर जरासो बेरा को बाद मंग मोला चोवने। ");
INSERT INTO pwr_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","यो गोस्टी आयक के यीसु को काही चेलागीन एकमेक लक सांगन लगीन, यो अमीला काजक सांगासे? जरासो बेरा मा तुमी मोला नही चोवने, मँग जरासो बेरा मा तुम्हि मोला चोवने। ");
INSERT INTO pwr_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","तबा चेला गीन ना कहीन, “ यो जरासो बेरा” कव्हसे, एको काजक मतलब से, अमीला समजमा नही आवासेत? ");
INSERT INTO pwr_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","यीसु जानत होतो का वय वोको लक काही सवाल करनो चाव्हासेत, तबा यीसु ना कव्हयो, तुम्हि एकमेक लक बिचार करासो, का यो “जरासो बेरा मा मोला नही चोवने मंग जरासो बेरा मा मोला चोवने” को काजक मतलब सेत? ");
INSERT INTO pwr_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","मि तुम्हिला खरो सांगासू का “तुम्हि रड़तो रव्हने अना जगत खुसहाली मनाहेत, तुम्हिला दुख होहेत पर तुमरो दुख खुसहाली मा बदल जाहेत। ");
INSERT INTO pwr_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","लेकरा जलम लेवन को पुढा बायका ला दरद होवासे, काहे की ओकी दुख को बेरा आय जासे, पर जबा वा लेकरा को जलम भयी जासे ता वा खुसहाली मनावासे, का एक मानूस तन जलम लेयीसेस, अना वा मुसीबत ला हेत नही करासे। ");
INSERT INTO pwr_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","वसोच परकार लक तुम्हिला अबा सोक से पर मि तुमी लक मँग मिलहु अना तुमरो मन खुसहाली लक भर जाहे। अना तुमरो खुसहाली कोनी तुम लक नही हिसक सकेत।” ");
INSERT INTO pwr_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","वोना दिवस तुम्हि लोक मोला काही नही पुसने, मि तुमरो लक खरो-खर सांगासू, “अदी मोरो नाव लक तुम्हि बाबूजी लक काही माँगने, ता उ मोरो नाव लक तुम्हिला देहेत। ");
INSERT INTO pwr_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","अबा तकन तुम्हि लोक ना मोरो नाव लक काही नही माँगीसेव, माँगो तो तुम्हिला भेटेत, जोनलक तुमरो खुसहाली पूरो भई जाहेत।” ");
INSERT INTO pwr_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","मिना यो गोस्टी तुम्हिला उदाहरन लक सांगीसेउ, पर उ बेरा आवासे, मि तुम्हिला उदाहरन लक नही सांगू पर अबा मी तुम्हिला बाबूजी को बारे सपा-सपा साँगु। ");
INSERT INTO pwr_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","ओनो दिवस तुम्हि लोक मोरो नाव लक माँगने अना मि तुम्हिला यो नही सांगासु, की मि तुमरो लाय बाबूजी लक बिनती करुहुँ। ");
INSERT INTO pwr_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","काहे की परमेस्वर तो खुदच तुम्हिला माया करासे। काहेका तुम्हिना मोरो लक माया करयो से, अना यो भी भरोसा करासेव की मि बाबूजी को कनलक आईसेऊ। ");
INSERT INTO pwr_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","मि बाबूजी को कन लक जगत मा आयीसेऊ, अना मि मंग जगत ला सोड़के बाबूजी को जवर जावासू। ");
INSERT INTO pwr_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","तब यीसू ना चेलागीन ना कहीन, चोव, अता तो तु खोलके सांग दियोसे, अना कोनी उदाहरन नही सांगासेस। ");
INSERT INTO pwr_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","अता हमि जान गई सेजन की तु सबच काही जानासेस, अता जरूरत नहात, की कोनी तोरो लक काही पुसेत, एकोलाय अमी भरोसा करासेजन की तु परमेस्वर को कन लक आईसेस। ");
INSERT INTO pwr_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","यो आयक के यीसु ना उन लक जवाब दियो, का तुम्हि अता भरोसा करासेव। ");
INSERT INTO pwr_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","चोवो, उ घडी आवासे, की तुमी सबच भटक जाहो अना आपरो-आपरो रास्ता लेहो, अना मोला एकलो सोड़ देहो। ता भी मि एकलो नही सेव, पर बाबूजी मोरो सँगमा से। ");
INSERT INTO pwr_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","मि ना यो गोस्टी तुमला एकोलाय सांगीसेऊ की तुमला मोरो सान्ती मिल्हे, जगत मा तुम्हिला दुख होवासे, पर हिम्मत राखो! मि ना जगत ला जीत लियोसेऊ। ");
INSERT INTO pwr_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","यीसु ना यो गोस्टी कहीस, अना आपरो डोरा सरग कन उचलके कहीस, अगो बाबूजी! वा बेरा आय गयोसे, आपरो टूरा को बड़ाई कर, की टूरा भी तोरो बडाई करहे, ");
INSERT INTO pwr_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","काहेकि तुना ओला सबच मानूस जाति पर हक देईसेस, जोनलक उ उन सबला अमर जिंदगी दे, जोनला तूना वोला सोपयो सेत। ");
INSERT INTO pwr_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","अना अमर जिंदगी योसे की वय तोला एकच खरो परमेस्वर अना यीसु मसीह ला, जेनला तु ना धाड़ीसेस जानेत। ");
INSERT INTO pwr_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","“जोन काम तुना मोला करन लाय देइसेस ओला पूरो करके मिना धरती पर महिमा करयो सेऊ, जोन जगत बनान को पुढा, मोरो तोरी सँग होतो। ");
INSERT INTO pwr_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","अता हे बाबूजी! तु आपरो सँग मोरी महिमा वा महीमा लक कर जोन जगत को पैदा होवन लक पुढा, मोरो तोरो सँग होतो।” ");
INSERT INTO pwr_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","मिना तोरो नाव वोना मानूसगिन पर उजागर कियो से, जोन लोक गीनला तुना जगत मा मोला देइसेस, वय तोरी होतीन अना तुना उनला मोला देईसेस, अखीन उनना तोरो सबद ला मना लेईसेत। ");
INSERT INTO pwr_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","अबा वय जान गईसेजन जोन काही तुना मोला देईसेस, उ सबच तोरो कन लक से। ");
INSERT INTO pwr_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","काहेकि जोन गोस्टी तुना देइसेस मिना उनला धाड़ीसेऊ, अना उनना ओनो गोस्टी ला भरोसा लक अपनाय लियो सेत अना खरो मा जान लेयीसेत, का मि तोरो मा लक हिटि सेऊ। ओन्हिसीन जान लियो सेत का तुना मोला धाड़ीसेस। ");
INSERT INTO pwr_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","मि उनको लाई बिनती करासू। जगत को लाई बिनती नही करुहू। पर उनको लाई जिनला तुना मोला देइसेस, काहेकि वय तोरा सेती। ");
INSERT INTO pwr_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","अना जोन काही मोरो सेत, वय सबच तोरो सेत अना जोन तोरो से उ मोरो से, अना इनलक मोरो बड़ाई उजागर भई। ");
INSERT INTO pwr_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","मि दुनिया मा नही रहुँ, पर यो लोकगीन दुनिया मा रहेत, अना मि तोरी जवर आवासेऊ, हे पवीतर बाबूजी, आपरो उ नाव लक जोन तुना मोला देईसेस, उनकी रक्सा कर, वय आमरो जसो एक रहेत। ");
INSERT INTO pwr_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","जबा मि उनको सँग होतो, मिना तोरो उ नाव लक, जोन तुना मोला देइसेस, उनको रक्सा कर, अना नास होवनवालो टूरा ला सोड़के उन लोकगीन मा लक कोनी नास नही भयो। एकोलाय की पवितर गिरंथ मा जोन कहो गयो उ पूरो होए। ");
INSERT INTO pwr_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","अबा मि तोरो जवर आवासू अना यो गोस्टी जगत मा कव्हसू, की वय मोरो खुसहाली आपरो मा पूरो पाहेत। ");
INSERT INTO pwr_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","मिना तोरो गोस्टी उनला पहुचा देईसेऊ। अना जगत ना उनलक बइर करीस, काहे की जसो मि जगत को नही, वसोच वय भी जगत का नहाति। ");
INSERT INTO pwr_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","मि यो बिनती नही करुहु की तू उनला जगत लक उचल लेहे, पर यो की तु उनला ओनो दुस्ट लक बचाव राख, ");
INSERT INTO pwr_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","जसो मि जगत को नही। वसोच वय भी जगत का नहात। ");
INSERT INTO pwr_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","खराई को दवारा उन ला पवीतर कर, तोरो सबद खराई से। ");
INSERT INTO pwr_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","जसो तुना मोला जगत मा धाड़िसेस, वसो मिना मि उनला जगत मा धाड़िसेत। ");
INSERT INTO pwr_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","अना उनको लाई मि आपरो आप ला पवीतर करुसेऊ काहेकि वय भी खराई को कन लक पवीतर कियो जाहेत। ");
INSERT INTO pwr_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","मि केवल इनको लाई बिनती नही करुहु, पर उनको लाई भी जोन इनको सबद लक मोरो पर भरोसा करासेत। ");
INSERT INTO pwr_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","की वय सबच एक होय जाहेत। जसो तु हे बाबूजी मोरो मा सेस, अना मि तोरो मा सेव, वसोच वय आमरो मा होहेत। जेना लक जगत भरोसा करहे की तुना मोला धाड़िसेस। ");
INSERT INTO pwr_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","उ महिमा जेनला तुना मोला देईसेस मिना उनला देईसेऊ, की वसोच एक होहेत। जसो की हमी एक सेजन। ");
INSERT INTO pwr_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","मि उन मा अना तु मोरो मा की वय सिध्द भयके एक जाहेत अना जगत जानहेत की तुना मोला धाडिसेस अना जसो तुना मोरो लक माया राखिसेस, वसोच उनलक भी माया राख। ");
INSERT INTO pwr_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","हे बाबूजी मी चाव्हुसु की जिनला तुना मोला देईसेस, जिता मि सेव, उता वय भी मोरो सँग होहेत। की वय मोरी महिमा ला चोहेत जोन तुना मोला देइसेस। काहे की जगत को पैदा होवन को पुढा तुना मोरो लक माया राखयोस। ");
INSERT INTO pwr_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","हे न्यायी बाबूजी जगत ना मोला नही जानिस पर मिना तोला जानीसेऊ, अना इनना भी जानिन का तुना मोला धाड़िसेस। ");
INSERT INTO pwr_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","मिना तोरो नाव उन लोकगीन ला साँगयो, अना साँगतो रहुँ। की जोन माया तुना मोरो लक करीसेस, वोच माया उनमा रव्हे। अना मि उनमा रहुँ। ");
INSERT INTO pwr_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","यीसु यो गोस्टी साँगके आपरो चेला को सँगा किदरोन नाला को वोनागन गयो। उता एक बारी होती, जोन मा उ अना ओको चेला गईन। ");
INSERT INTO pwr_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","ओको धरानवालो यहूदा भी उ जघा जानत होतो, काहेकि यीसु आपरो चेला को सँगा उता जात होतो। ");
INSERT INTO pwr_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","तबा यूदूस, सिपाही गीनको दल ला लेयके अना मुखिया याजक अना मोसे को नियम को गुरू कन लक सिपाही ला लेयके, दियो, टेमा अना हतियार धरके उता आयो। ");
INSERT INTO pwr_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","तबा यीसु उ सब गोस्टी ला जोन ओको पर आवनवालो होती, जानके हिटयो, अना उनला कहीस कोन ला ढुँढोसेव? ");
INSERT INTO pwr_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","उनना ओला जवाब देईन, यीसु नासरी ला, यीसु ना उनला कहीस, मि सेव ओको धरानवालो यहूदा भी उतच उभयो होतो। ");
INSERT INTO pwr_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","ओको कव्हन पर की मि सेऊ, वय मँघा पछलके जमीं पर गिर गईन। ");
INSERT INTO pwr_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","तबा ओना मंग उनलक पुसयो, तुमी कोन ला ढुँढोसेव? वय बोलिन का यीसु नासरी ला! ");
INSERT INTO pwr_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","यीसु ना जवाब देइस मि तो तुमला कह देइसेउ, की मि सेव, अदी मोला ढुँढोसो तो इनला जावन देव। ");
INSERT INTO pwr_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","यो एकोलाय भईसे की उ सबद पूरो होहे जोन ओना कव्हयो होतिस, “जोनला तुना मोला दियो होतोस, उनमा लक मिना एक ला भी नही खोयो।” ");
INSERT INTO pwr_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","एतरो पर समौन पतरस ना, तलवार झीकके अना मोठो मुखिया याजक को दास पर चलायके ओको उज्जो कान ला काप देइस, यो दास को नाव मलखुस होतो। ");
INSERT INTO pwr_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","तब यीसु ना पतरस लक कहीस, आपरी तलवार म्यान मा राख, जोन बटकी बाबूजी ना मोला देइसेस, का मि ओला नही पीहुँ? ");
INSERT INTO pwr_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","तबा दरोगा ना सिपाही ला हुकूम देईस, तबा यहूदिगीन को दास गीन अखीन सिपाईगीन ना यीसु ला धरके बाँध लेइन। ");
INSERT INTO pwr_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","अना पुढा ओला हन्ना को जवर लेगइन, काहेकि उ ओना बरस को मोठो मुखिया याजक होतो जोन काइफा को ससुर होतो। ");
INSERT INTO pwr_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","यो वाच काइफा होतो, जेना यहूदिगीन ला सलाह दियो होतो की हमरो लोकगीन को लाई एक मानूस ला मरनो साजरो से। ");
INSERT INTO pwr_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","समौन पतरस अना एक अखीन चेला यीसु को मँघा भय गइन, यो चेलाला मोठो मुखिया याजक ओरखत होतो, एकोलाय उ यीसु को सँग मोठो याजक को आँगन मा गयो। ");
INSERT INTO pwr_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","पर पतरस बाहेर डहलान मा उभो होतो तबा दुसरा चेला जोनला मोठो मुखिया याजक ओरखत होतो, बाहेर हिटके अना चौकीदार लक कहके पतरस ला भीतर ले आइस। ");
INSERT INTO pwr_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","वय दासी जोन चौकीदार होती पतरस लक कहीस, कहीं तु भी यो मानूस को चेला मा लक तो नही आस, ओना कहीस, मि नही सेव, ");
INSERT INTO pwr_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","दास अना सिपाही थन्डी को मारे अँगेठा पैटाय के स्तो तापत होतीन अना पतरस भी उनको सँग होतो। ");
INSERT INTO pwr_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","तबा मोठो मुखिया याजक ना यीसु लक ओको चेला को बारे मा अना ओको सिक्सा को बारे पुसयो। ");
INSERT INTO pwr_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","यीसु ना जवाब देइस, मिना जगत लक खुलके गोस्टी करिसेऊ, मिना सभाघर अना मंदिर मा जिता सबच यहूदिगीन एकठ्ठो होत होतीन, हमेसा सिक्सा देवत रहयो, अना छिपयो मा काही नही कव्हयो। ");
INSERT INTO pwr_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","तुमी मोला कायलाई पुसा सो? आयकन वालो ला पुसो, की मिना उनलक काजक सांगीसेऊ? ");
INSERT INTO pwr_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","जबा ओना यो कहीस, तो सिपाही मा लक एक ना जो जवर उभो होतो, यीसु ला चाटा मारके कव्हन लग्यो, का तु मोठो मुखिया याजक ला यो रिती लक जवाब देईसेस? ");
INSERT INTO pwr_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","यीसु ना जवाब देइस, अदी मिना बुरो कव्हसू, तो वा बुराई की गवाही दे, पर अदी भलो कव्हसू तो मोला कायलाई मारासो? ");
INSERT INTO pwr_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","हन्ना ना ओला बँधयो हुयो काइफा मोठो मुखिया याजक को जवर धाड़ दियो। ");
INSERT INTO pwr_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","समौन पतरस उभो होयके स्तो ताप रहयो होतो। तबा उनना ओला कहीन, कहीं तु भी ओको चेला तो नहात? ");
INSERT INTO pwr_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","मोठो मुखिया याजक को दास गीनमा लक एक जोन ओको खानदान लक होतो, जेनको कान पतरस ना कापयो होतिस, ओना कहीस, का मिना तोला ओको सँग बारी मा नही चोवयो? ");
INSERT INTO pwr_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","पतरस ना मंग मना कर देइस, अना कुकड़ा ना एकदम लक चिल्लाय देइस। ");
INSERT INTO pwr_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","पहट को बेरामा वय यीसु ला काइफा को जवर लक किला मा ले गईन पर भीतर नही धसीन, काहेका उनला असुध्द होवन को डर होति। अबा फसह को तिहार को जेवन नही करी होतिन। ");
INSERT INTO pwr_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","तबा पीलातुस उनको जवर बाहेर हिट गयो, अना कहीस, तुमी यो मानूस पर कोन गोस्टी लक दोस लगावसो? ");
INSERT INTO pwr_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","उनना ओला जवाब देइस, अदी उ कुकरमी नही होतो, तो हमी ओला तोरो हात नही सौपता। ");
INSERT INTO pwr_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","पीलातुस ना उनलक कहीस, तुमी येला ले जाके मोसे को नियम लक न्याय करो! यहूदिगीन ओला कहिन, हमी ला यो हक नहात की कोनी ला जान लक मारबोन। ");
INSERT INTO pwr_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","यो एको लाई भयो का यीसु की उ गोस्टी पूरी होहे जोन ओना यो ईसारा देतो बेरा कव्हयो होतीस, की ओकी मौत कसी रीत लक होहे। ");
INSERT INTO pwr_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","तबा पीलातुस किला मा अँदर धसके अना यीसु ला मंग लक पुसयो की का तु यहूदिगीन को राजा आस? ");
INSERT INTO pwr_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","यीसु ना जवाब देइस, “का तु यो गोस्टी आपरो कन लक कव्हसेस का दुसरो मोरो बारे मा तोरो लक कव्हसेत?” ");
INSERT INTO pwr_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","पीलातुस ना जवाब देइस, का मि यहूदी आऊ ?तोरोच जात वारा अना मुखिया याजक ना तोला मोरो हात मा सौपीसेत। तुना का करीसेस? ");
INSERT INTO pwr_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","यीसु ना जवाब देइस, मोरो राजपाठ यो जगत को नही से। अदी मोरो राजपाठ यो जगत को होतो, तो मोरो सिपाही इनलक लड़तीन अना मि यहूदिगीन को हात मा नही सौपयो जातो। पर मोरो राज इता को नहाती। ");
INSERT INTO pwr_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","पीलातुस ना ओला कहीस, तो का तु यहुदीगीन को राजा आस? यीसु ना जवाब देइस, तु कव्होसेस की मि राजा सेउ, मिना एकोलाय जन्म लेइसेउ अना जगत मा आयीसेऊ, की खराई को गवाही देऊ। जो कोनी भी खराई को से, उ मोरो आवाज ला आयकासे। ");
INSERT INTO pwr_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","पीलातुस ना ओला कहीस की खराई काजक से? यो साँगके उ मंग यहूदिगीन को जवर लक हिट गयो, अना उन लक कहीस, मि तो ओमा काही दोस नही पाऊ। ");
INSERT INTO pwr_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","पर तुमरो यो रीती लक की मि फसह को तिहार मा तुमरो लाई एक आदमी ला छोड़ देहू, एकोलाय का तुम्हि चाव्हासो की मि तुमरो लाई यहूदिगीन को राजा ला सोड़ देहू? ");
INSERT INTO pwr_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","तबा उनना मँग चिल्लायके कहीन, एला नही पर हमरो लाई बरब्बा ला छोड़ दे! अना बरब्बा डाकु होतो। ");
INSERT INTO pwr_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","येको पर पीलातुस ना यीसु ला कोड़ा लगवाइस। ");
INSERT INTO pwr_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","सिपाई ना कांटा झाड़ को मुकुट गुथके ओको डोस्का मा राखिन अना ओला बेजनी कपरा पहनाय देईन। ");
INSERT INTO pwr_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","अना ओको जवर आयके कव्हन लगीन, हे यहूदी को राजा नमस्कार अना ओला झापड़ भी मारिन। ");
INSERT INTO pwr_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","तबा पीलातुस ना मंग बाहेर हिटके लोक गीनला कहीस, चोवो मि ओला तुमरो जवर मँग बाहेर आनासू, जोनलक तुम्हि जानो का उ निरदोस से। ओमा काही भी दोस नहात। ");
INSERT INTO pwr_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","तबा यीसु कांटा को मुकुट अना बैजनी कपरा डाकयो हुयो बाहेर हिटयो। अना पीलातुस ना उनलक कहीस, “चोवो यो मानूस ला।” ");
INSERT INTO pwr_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","तबा मुखिया याजक अना सिपाही ना ओला चोवीन। तो चिल्लाके कहिन, का ओला कूरूस मा चघाव! पीलातुस ना ओला कहीस, तुम्हिच ओला आन के कूरूस पर चघाओ! काहेकि ओमा काही दोस नही पायो सेऊ। ");
INSERT INTO pwr_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","यहूदी गीनना ओला जवाब देइन, “हमारो भी मोसे को नियम को लक, उ जरुर मार डाकन को काबील से, काहेकी ओना आपरो आपच परमेस्वर को टूरा बनाईसेस।” ");
INSERT INTO pwr_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","जबा पीलातुस ना यो गोस्टी आयकीस तो अखीन भेव समाय गयो अना यीसु लक कहिस, “तु किता को सेस?” पर यीसु ना ओला काही भी जवाब नही देइस। ");
INSERT INTO pwr_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","अना मंग किला को भीतर गयो अना यीसु लक कहिस, तु किता को सेस? पर यीसु ना ओला काही भी जवाब नही देइस। ");
INSERT INTO pwr_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","एतरो पर पीलातुस ना ओला कहीस, मोरो लक काहे नही कव्हासे? का तु नही जानस की तोला छोड़ देवन को हक मोला से, अना तोला कूरूस मा चघा वन को हक मोला से। ");
INSERT INTO pwr_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","यीसु ना जवाब देइस, “अदी तोला वरता लक नही दियो जाहे तो तोरो मोरो पर काही भी हक नही से। एकोलाय जोन मोला तोरो हात धरायो से ओको पाप लगत से।” ");
INSERT INTO pwr_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","एतरो पर पीलातुस ना ओला सोड़ देनो चाहयो, पर यहूदी गीनना चिल्लाके कहीन, अदी तु एला सोड़ देजोस तो तोरी भक्ति कैसर को संगी नही से। जोन कोनी आपरो आप ला राजा बनावासे। उ कैसर को सामना करासे। ");
INSERT INTO pwr_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","यो गोस्टी आयक के पीलातुस यीसु ला बाहेर लायो, अना उ जघा एक चबुतरा होती जो इबरानी मा गब्बता कहलासे अना उता न्याय आसन पर बसयो ");
INSERT INTO pwr_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","यो फसह को तिहार की तैय्यारी को दिवस होतो, अना यो बेरा छटवो तास को लगभग की होती। तबा ओना यहूदिगीन लक कहीस, “चोवो तुमरो राजा!” ");
INSERT INTO pwr_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","पर वय चिल्लाइन, ले जाव, ले जाव! अना ओला कूरूस मा चघाव, पीलातुस ना उन लक कहीस, का मि तुमरो राजा ला कूरूस पर चघाऊ! मुखिया पुजारी ना जवाब देइस, कैसर ला छोड़ हमरो कोनी राजा नहाय! ");
INSERT INTO pwr_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","तबा उनना यीसु ला उनको हात सौप देइस, ताकि उ कूरूस मा चघाव जाहे। ");
INSERT INTO pwr_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","तबा वय यीसु ला ले गईन, अना उ आपरो कूरूस उठायके उ जघा तकन बाहेर गयो, जो कवटी को जघा कहलावासे अना इबरानी मा गुलगुता। ");
INSERT INTO pwr_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","उता उनना ओला अना ओको सँगा अखीन दोन मानूस ला कूरूस पर चघाईन, एक को इता अना एक ला उता, अना बीच मा यीसु ला। ");
INSERT INTO pwr_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","पीलातुस ना एक दोसपतर लिखवाके‍ कूरूस पर लगा देइस, अना ओमा यो लिखयो होतो, यीसु नासरी, यहूदिगीन को राजा। ");
INSERT INTO pwr_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","यो दोसपतर लगत सा यहूदिगीन ना वाचिन काहेकि उ जघा जिता यीसु कूरूस मा चघाव गयो होतो। नगरको जवर होतो, अना पतर इबरानी मा अना लतीनी अना यूनानी मा लिखयो होतो। ");
INSERT INTO pwr_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","तबा यहूदिगीन को मुखिया याजक ना पीलातुस लक कहीस, “यहुदि गिनको को राजा” मत लिखने पर यो की “ओने कहीस मि यहुदी को राजा सेउ।” ");
INSERT INTO pwr_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","पीलातुस ना जवाब देइस, मि ना जो लिख दियो उ लिख दियो। ");
INSERT INTO pwr_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","जबा सैनिक यीसु ला कूरूस मा चघा देईन तो ओको कपरा आन के चार करीन, हर सिपाही को लाई एक पराय अना कुरता भी लेईन, पर कुरता बिन सिवन को वरता लक खाल्या तकन बुनयो हुवो होतो। ");
INSERT INTO pwr_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","एकोलाय उनना आपसी मा कहिन, हमि एला नही फाड़बोन पर एको पर चिठ्ठी डाकबिन की यो कोन की होहे। यो एकोलाय की पवितर गिरंथ मा जोन कव्हयो गयो उ पूरो भये। उनना मोरो कपरा आपस मा बाँट लेइन अना मोरो पल्लु पर चिठ्ठी डाकिन। ");
INSERT INTO pwr_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","अता सिपाही ना असो ही करीन यीसु को कूरूस जवर ओकी माय, अना ओकी माया की बहिन, कलोपास की बायको मरियम, अना मरियम मगदलीनी उभी होती। ");
INSERT INTO pwr_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","जबा यीसु ना आपरी माय अना ओनो चेला ला जेनला उ माया राखत होतो। जवर उभो देखिस ता आपरी माय लक कहीस हे बाया देख यो तोरो टूरा से। ");
INSERT INTO pwr_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","तबा ओना चेला लक कहीस, यो तोरो माय से। अना वोच बेरा लक उ चेला ओला आपरो घर ले गईन। ");
INSERT INTO pwr_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","एको मँघा यीसु ना यो जानके की अता सब काही पूरो भयो, पवितर गिरंथ मा जोन कहो गयो उ पूरो भयो, तब कह्यो “मि तहान सेउ।” ");
INSERT INTO pwr_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","उता अंगूर रस भरो हुयो एक बरतन राखियो होतो, अता उनना अंगूर को रस माफिलायो हुयो स्पंज ला जुफा मा राखके ओको तोन्ड लक लगाइन। ");
INSERT INTO pwr_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","यीसु ना उ पित मिलयो अंगूर को रस टोंड मा लेइस अना कहीस “पूरो भयो।” अना डोस्का डाखके परान छोड़ देइस। ");
INSERT INTO pwr_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","यो बिसराम-दिवस लक पहेले तैय्यारी को दिवस होतो। यहूदी गीनना पीलातुस लक बिनती करीन का उनको टगंड़ी तोड़ दियो जाय अना उनको देह उतारो जाय, जोनलक पवीतर दिवस मा वय कूरूस पर नोको रहेत। काहेकि उ सब्त का मोठो दिवस होतो। ");
INSERT INTO pwr_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","एकोलाय सैनिक ना आयके कूरूस मा टगयो, पहेलो अना दूसरो, मानूस को टेगड़ी टोड़िन, जोन यीसु को संग कूरूस मा चघायो गयो होतीन। ");
INSERT INTO pwr_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","पर जबा यीसु को जवर आयके चोविन की उ मर चुकयो तो ओकी टाँग नही तोड़ीन। ");
INSERT INTO pwr_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","पर सिपाही मा लक एक ना बरछी लक ओको पसरी मा मारयो, अना ओमा लक तुरंत रकत अना पानी हिटियो। ");
INSERT INTO pwr_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","जेना यो देखीस ओने गवाही देइस, अना ओकी गवाही देईसेस अना ओको गवाही खरो से उ खूदच जानासे का खरो कव्हसे जेनको लक तुमी भी भरोसा राखो। ");
INSERT INTO pwr_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","यो गोस्टी एको लाई भई का पवितर गिरंथ मा कव्हयो गयो होतो, उ पुरो भयो। “ओकी एक भी हाड़ नही तोड पाहे।” ");
INSERT INTO pwr_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","मँग एक जघा पवितर गिरंथ पर यो लिखो से “जोनना वोला छेदयो, वाच वोको कन चोवयो।” ");
INSERT INTO pwr_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","यो गोस्टि को बाद अरिमितिया को यूसुफ ना जोन यीसु को चेला होतो, पर यहूदी गीनको भेव लक यो गोस्टी ला लुकाय राखत होतो। युसुफ ना पीलातुस ला साँगीस, का “तु यीसु को लास ला मोला देव।” तबा पीलातुस ना कव्हयो का ले जाय। ");
INSERT INTO pwr_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","नीकुदेमुस जोन पुढा रात ला यीसु को कठा गयो होतो, वोच पचास सेर लुभान अना गवारपाठा ले गयो। ");
INSERT INTO pwr_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","तबा उन्ना यीसु को लास ले गईन, अना यहूदिगीन को गाड़ो जानो को रिवाज लक ओला सुगंधित सामान को सँगा कपरा मा लपटिन। ");
INSERT INTO pwr_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","ओनो जघामा जिता यीसु कूरूस मा चघाव गयो होतो, एक बारी होती अना उ बारी मा एक नवतो मरघट्टी होती जेमा कोनी ना राखियो गयो होतो। ");
INSERT INTO pwr_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","एकोलाय यहूदिगीन की तैय्यारी को दिवस सूकीरवार को कारन उनना यीसु ला वोचमा राख्यो, काहेकि वा मरघट्टी जवर होती। ");
INSERT INTO pwr_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","हफ्ता को पहिले दिवस मरियम मगदलीनी पहेटिया मा मरघटी मा आइन, अना गोटा ला मरघट्टी लक हटयो हुयो चोवीन। ");
INSERT INTO pwr_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","तबा वय धाव के समौन पतरस अना उ दुसरो चेला को जवर जेनको लक यीसु माया राखत होतो आयके कहिन, वय पिरभू ला मरघट्टी मा लक हेड़के ले गईन, अना अमीला पता नहात, वोला किता राख दियो! ");
INSERT INTO pwr_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","तबा पतरस अना उ दुजो चेला हिटके मरघट्टी को कन चली गईन। ");
INSERT INTO pwr_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","वय दोंनो सँग-सँग धाव रह्यो होतिन, पर दुसरो चेला पतरस लक पुड़ढा मरघट्टी मा पहुचयो। ");
INSERT INTO pwr_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","अना उ वोनो होयके कपरा पड़ो चोवयो, ता भी उ भीतर नही गयो। ");
INSERT INTO pwr_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","तबा समौन पतरस ओको मंघा-मंघा पहुचियो, अना मरघट्टी को भीतर गयो, अना कपरा पड़ा चोविस ");
INSERT INTO pwr_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","अना उ गमछा जोन ओको डोस्का लक बँधो होतो, अलग एक जघा गुन्ड के राखियो होतो। ");
INSERT INTO pwr_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","तबा दुसरो चेला भी जोन मरघट्टी पर पुढा पहुचियो होतो, भीतर गयो अना चोयके भरोसा करीन। ");
INSERT INTO pwr_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","वय तो अबा तकन पवितर गिरंथ की उ गोस्टीच ला नही समजयो होतीन, की ओको मरो मा लक जिँदो होवनो से। ");
INSERT INTO pwr_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","तबा यो चेला आपरो घर लवट गईन। ");
INSERT INTO pwr_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","पर मरियम रोवती हुई मरघट्टी को जवर च बाहेर उभी रही, अना रोवती-रोवती मरघट्टी को कन नवके, ");
INSERT INTO pwr_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","दुई सरगदूत ला पाढरो कपरा घालयो हुयो एक ला मुंडेसा अना दुसरो ला पैताना मा बस्यो चोयी, जिता यीसु को लास राखी होतीन। ");
INSERT INTO pwr_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","उनना ओकोलक कहीन अवो बायका तु काय ला रोवासेस? ओना उनलक कहीस, वय मोरो पिरभू ला उचलके ले गईन, अना मोला मालूम नहात की ओला किता राखीसेत? ");
INSERT INTO pwr_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","यो कही अना वा यीसु ला उभो चोयी, पर वा नही वोरख सकी का उ यीसु आय। ");
INSERT INTO pwr_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","यीसु ना ओला कहीस, अवो बाई तु काय लाय रोवासेस कोन ला ढुढासे? ओना माली समजके ओला कहीस, हे पिरभू अदी तु ना ओला उचल लेइसेस। तो मोला सांग ओला किता राखीसेस अना मि ओला ले जा? ");
INSERT INTO pwr_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","यीसु ना ओला कहीस, मरियम! ओना मंघा मुरकके ओला इबरानी मा कहिस “हे गुरु” ");
INSERT INTO pwr_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","यीसु ना कहीस, मोला नोको छुवस। काहेकि मि अबा तकन बाबूजी को जवर वरता नही गयो, पर मोरो भाऊ को जवर जावके उन लक सांग दे, की मि आपरो बाबूजी अना तुमरो बाबूजी अना आपरो परमेस्वर अना तुम्हरो परमेस्वर को जवर वरता जावासु। ");
INSERT INTO pwr_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","मरियम मगदलीनी ना जायके चेलागीन चेला गीनला साँगिस, मिना पिरभू ला चोवीसेऊ, अना ओना मोला यो गोस्टी कहीस। ");
INSERT INTO pwr_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","ओनो दिवस जोन हप्ता को पहेलो दिवस होतो, झुलाखाली को बेरा जबा उता को बेसकुड़ जिता चेला होतीन, यहूदिगीन को भेव को मारे बंद होतो। तबा यीसु आयो अना उनको बीच मा उभो होयके उनलक कहीस, “तुमला सान्ती मिलहे।” ");
INSERT INTO pwr_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","अना यो सांग के ओना आपरो हात अना आपरो पंजर उनला चोवायो तबा चेलागीन पिरभू ला चोवके खुसी लक भय गईन। ");
INSERT INTO pwr_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","यीसु ना मँग उनलक कहीस, “तुमला सान्ती मिलहे। जसो बाबूजी ना मोला धाड़ीसेस, वसो ही मि भी तुमला धाड़िसेउ।” ");
INSERT INTO pwr_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","यो साँगके ओना उन पर फुकिस। अना उन लक कहीस, “पवीतर आतमा लेव। ");
INSERT INTO pwr_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","जिनको पाप तुमी छिमा करो वो उनको लाई छिमा कियो जाहे। जिनला तुमी राखसेव वय राखो गईसेत।” ");
INSERT INTO pwr_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","पर बारा मा लक एक मजे थोमा जोन दिदमुस कहलावासे। जबा यीसु आयो ता उनको सँग नही होतो। ");
INSERT INTO pwr_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","जबा चेलागीन ओको लक कव्हन लागीन, हमी ना पिरभू ला चोवीसेजन, तबा ओना उन लक कहीस, जबा तकन मि ओको हात मा खिल्ला का छेद न चोय लुँ, अना खिल्लो को छेद मा आपरी वोट ना डाक लुँ, अना ओको छेद मा आपरो हात न डाख लु, तबा तकन मि भरोसा नही करुँ। ");
INSERT INTO pwr_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","आठ दिवस को मंघा ओको चेलागिन मंग घर को भीतर आइन, अना थोमा उनको सँग होतो। अना किवाड़ बँद होतीन। तबा यीसु आयो अना उनको बीच मा उभो होयके कहीस, तुमला सान्ती मिलहे। ");
INSERT INTO pwr_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","तबा ओना थोमा लक कहीस, आपरी बोट इता आनके मोरो हात ला चोय। अना आपरो हात आनके मोरो छेद मा डाक। अना अबिस्वासी नोको पर बिस्वास करन वालो बन। ");
INSERT INTO pwr_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","यो आयक के थोमा ना जवाब देइस। हे मोरो, पिरभू हे मोरो परमेस्वर। ");
INSERT INTO pwr_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","यीसु ना ओला कहीस, “तु ना मोला चोवीसेस एको लाई भरोसा करसेस, धन्य सेत वय जेने मोला बिन चोय भरोसा करासेत।” ");
INSERT INTO pwr_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","यीसु ना अखीन लगत सा निसान चेला को पुढा चोवाईस। जोन यो किताब मा लिखयो नही गई सेत। ");
INSERT INTO pwr_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","पर एको कारन लक लिखी गई से की तुमी लोकगीन भरोसा करो, की यीसु जोन से उ परमेस्वर को धाड़ो गयो से। अना कव्हनो मा मसीह से। अना ओको नाव मा भरोसा करनो लक जीवन मिलासे। ");
INSERT INTO pwr_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","येको मंघा यीसु ना तिबिरियास झील को किनार मा मगं चेला गीनको जवर आपरो आप ला दिसायो। यो असो भयो, ");
INSERT INTO pwr_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","समौन पतरस अना थोमा जोनला दिदमुस भी कहव्सेत। अना गलील को काना नगर को नतनएल अना जबदी को टूरा अना ओको चेला मा दोन दिगर जन इकठ्ठा भईन। ");
INSERT INTO pwr_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","समौन पतरस ना उनको लक कहीस, “मि मसरी पकड़न लाई जावासू।” वय ओला कहिन “हमि भी तोरो सँग चला सेजन।” वय चले गइन, नाव मा चघके मसरि पकड़न लगीन, पर उ रात उनला काही नही भेटियो। ");
INSERT INTO pwr_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","पहट को बेरा यीसु किनारे पर उभो होतो, पर चेला गीन नही चिन्हो का यो यीसु से। ");
INSERT INTO pwr_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","तबा यीसु ना उन लक कहीस, ओ भाऊ तुमरो कठा कितरो मसरी सेत? तबा वय जवाब देईन, काही नाहती। ");
INSERT INTO pwr_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","ओना उन लक कहीस, नाव की उज्जो कना जाल डाकहो तबा तो तुम पाहो। एकोलाई: उनना जाल डाकिन, अना लगत सारी मसरी जेनला उनला झिकत नही बनयो। ");
INSERT INTO pwr_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","तबा ओनो चेला ना जेनला यीसु माया राखत होतो। ओना पतरस ला कहीस, यो तो पिरभू से। समौन पतरस ना यो आयकिस, तो ओना कमर मा गमछा डाकके अना झील मा कूद गयो। ");
INSERT INTO pwr_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","पर दुसरो चेला नहानी डोंगी मा मसरी लक भरो जाल खिचत-खिचत आइन। वहान लक सिरफ 100 मिटर दुहुर लक धरती को किनार होतो। ");
INSERT INTO pwr_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","वय धरती मा उतरीन होतीन अना कोयले को स्‍तो अना ओको पर मसरी राखी गई होती अना भाकर चोवीन। ");
INSERT INTO pwr_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","यीसु ना उन लक कहीस “तुमीना जोन मसरी अबा धरियासेव, ओमा लक काही आनो।” ");
INSERT INTO pwr_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","समौन पतरस ना डोंगी मा चघके एक सौ तिरेपन मोठो मसरी लक भरो हुवो जाल धरती मा झिकिस। अना एतरी मसरी होवनो पर भि जाल नही फटयो। ");
INSERT INTO pwr_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","यीसु ना उनलक साँगीस, आव, आमी जेवन करबीन। चेला गीन मा कोनी ला एतरो हिम्मत नई भयो की ओला पुसेत, की तु कोन आस? काहे की वय जानत होतीन की यो पिरभू च से। ");
INSERT INTO pwr_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","यीसु आयो अना भाकर आन कन उनला देइस, अना वसोच मसरी भी। ");
INSERT INTO pwr_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","यो तिसरो गन से की यीसु मरो मा लक जित्तो होवनो को मंघा चेला गीन ला चोयो। ");
INSERT INTO pwr_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","जेवन करनो को मंघा यीसु समोन पतरस लक कहीस, की हे समौन, योहन को टूरा, का तु मोला माया राखसेस का? ओना कहीस, “हव, पिरभू, मि तोरो लक माया राखुसु तु तो जानसेस।” ओने ओला कहीस, “मोरो मेंढ़ा गीन ला चराव।” ");
INSERT INTO pwr_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","ओना मंग दुसरो गन ओला कहीस, हे समौन योहन को टूरा का तू मोरो लक माया करासेत, तबा समौन यीसु लक कहीस, हव पिरभू तु जानासेस की मि तोरो लक माया राखसू ओने मंग कहीस, मोरो मेढा ला चराव। ");
INSERT INTO pwr_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","ओने मंग तीसरो डाई ओला कहीस, हे समौन योहन को टूरा, का तु मोरो लक माया राखसेस। मंग पतरस उदास भय गयो की ओने तीसरो गन असो कह देइस। का तु मोला माया राखसेस? अना एतरो पर ओने कह देइस, का हे पिरभू तु तो सब काही जानासेस की मि तोरो लक माया राखसु का नही। यीसु ना मंग कहीस मोरी मेढा ला चराव। ");
INSERT INTO pwr_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","मि तोरो लक खरो मा कव्हुसु की जबा तु जवान होतोस तो आपरो कमर बाँधके जिता चाहत होतो जात होतोस, पर जब तु सयानो होजोस तो आपरो हात पसार जोस, अना दुसरो तोरी कमर बाँधके जिता तु नही चाहवजोस उता तोला ले जाहेत। ");
INSERT INTO pwr_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","ओना ऐना गोस्टी लक ईसारा देईस की पतरस कसो मौत लक परमेस्वर की बड़ाई करेत। अना तबा ओना ओला कहीस, मोरो मँघा भयजाहे। ");
INSERT INTO pwr_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","पतरस ना मुरकके उ चेला ला मंघा आवता चोवीस, जेनको लक यीसु माया राखत होतो अना जेना जेवन को बेरा ओको छाती कन नवके पुछिस होतीस, हे पिरभू तोरो धरान वालो कोन से? ");
INSERT INTO pwr_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","ओला चोवके पतरस ना यीसु लक कहीस हे पिरभू एको काजक हाल होहे? ");
INSERT INTO pwr_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","यीसु ना ओला कहीस अदी मि चाहु की उ मोरो आनो तकन रुकयो रह। ता मोला एकोलक काजक, तु मोरो मंघा भय जाय। ");
INSERT INTO pwr_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","एको लाई भाऊ गीन मा यो गोस्टी फैल गई की उ चेला नही मरेह, ता भी यीसु ना ओला नही कहीस की उ नही मरेह, पर यो की “अदी मि चाहुँ की उ मोरो आनो तकन रुकयो रह, तो तोला एको लक काजक?” ");
INSERT INTO pwr_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","यो वाच चेला से, जोन ऐना गोस्टी की गवाही देवासे। अना जेना ऐना गोस्टी ला लिखि से अना हमी जानसेजन की ओकी गवाही खरो से। ");
INSERT INTO pwr_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","अखीन भी लगत सा काम सेत, जोन यीसु ना करीसेस। अदी वय एक-एक करके बयान करी जातीन ता मि समझुसु की जोन किताब लिखी जातीन, वय जगत मा नही समातीन।");
INSERT INTO pwr_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","ओ चहेतो थियुफिलुस, मीना आपरो पयलो किताब उन सब काम गीनको बारे मा लिखिसेव, जो काम यीसु ना पयले लक करयो अना सिकायो। ");
INSERT INTO pwr_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","वोना दिवस तकन पवितर आतमा लक आपरो बेचयो गयो चेला गिनला हुकूम दियो जोन दिवस लक उ सरग नही उचल लियो गयो। ");
INSERT INTO pwr_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","आपरो मरनो को मघा, वोना 40 दिवस तकन उ अलग-अलग रीत लक उ लगत बार उनला आपरो जित्तो होवन को सबूत उनला देवत रहयो। अना वोना उनलक परमेस्वर को राज को बारेमा सागत रह्यो। ");
INSERT INTO pwr_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","मग जबा वय यीसु को संग जमा होतिन, “ता ओना उनला हुकूम देईस।” येरुसलेम नगर नोको तजजोस, बल्की जोन पवितर आतमा भेटन को बारे मा तुमीना मोरो लक आयकिसेव, बाबूजी को ओनो वायदा को पुरो होवन को रास्ता ताको। ");
INSERT INTO pwr_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","काहे का योहन ना पानी मा बपतिस्मा देई होतीस, “पर अबा तुमला जरासो दिवस को मंघा पवीतर आतमा लक बप्तिस्मा दियो जाहेत।” ");
INSERT INTO pwr_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","जबा पेरीतगीन डुगां भईन, तबा वय यीसु लक पुसिन, पिरभू का तू योच बेरा इसरायल राज ला लवटा देजोस? ");
INSERT INTO pwr_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","यीसु ना उनला कहीस “ओनो अवसर अना बेरा ला जाननो तुमरो काम नाहती। जोन ला परमेस्वर ना खुद अपरो हक मा पक्को करीसेस। ");
INSERT INTO pwr_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","पर जबा पवीतर आतमा तुमी पर आहे तबा तुमी ताकत पावने, अना येरुसलेम, सप्पा यहुदिया अना सामरिया मा, यहान तकन का धरती को छोर तकन तुमी मोरो गवाह ठहरने।” ");
INSERT INTO pwr_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","एतरो कव्हनो को मंघा उ उनको देखत-देखत वरता उचल लियो गयो, अना उ उनला नही चोवयो। ");
INSERT INTO pwr_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","जबा उ जाय रहयो होतो, तो वय बादर कन ताक रहया होतिन, ताभिच दुई मानूस पांढरा झंगा घाल्या हुया उनको कगर मा आयके उभा भईन, ");
INSERT INTO pwr_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","अना उनको लक कहिन, अरे! गलीली लोक गीन, तुमी कायलाई, उभा होयके बादर कन चोवासेव जोन यीसु तुमरो, जवर लक सरग मा उचलीयो गयोसे, अना वोला जसोच तुमीना, सरग ला जात चोयीसेव, वसोच रिती लक अखीन वापस लौटहेत। ");
INSERT INTO pwr_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","मंग पेरीत जैतून नाव को पहाड लक जोन यरुसलेम लक कोनी एक किलोमीटर दुहुर से। वहान लक येरुसलेम सहेर लवटिन। ");
INSERT INTO pwr_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","तबा वय येरुसलेम सहेर को वय घर को पाटन पर गईन, जहा पतरस अना योहन अखीन याकूब अना अन्दिरयास, अखीन फिलिप्पुस, अना थोमा, अना बरतुल्मै, अखीन मत्ती अना हलफई, को टूरा याकूब, अखीन समौन, जेलोतेस अना याकूब, को टूरा यहूदा, ठहेराया होतीन। ");
INSERT INTO pwr_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","इनको संग मा काही आई-माई, अखीन यीसु की माय मरियम अना वोका भाऊ गिन भी होतिन। यो सब आपरो आपला एक संग पिराथना मा लगायो राखत होतिन। ");
INSERT INTO pwr_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","काही दिवस मघा बिस्वासी भाऊ गिन को सभा मा जोन एक सम्बर बीस लोक गीन होतिन। पतरस उभो होयके कव्हन लगयो। ");
INSERT INTO pwr_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","यहूदा आमरो समूह को एक मेम्बर होतो अना यो सेवा मा उ हिस्सेदार होतो। ");
INSERT INTO pwr_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","जोनको को बारेमा, पवितर गिरंथ को उ लेख जोनला राजा दाऊद को टोन्ड लक पवितर आतमा ना लगत पयलेच कव्हयो होतो। ओको पूरो होवनो जरुरी होतो। का उ आमरो च सग गिनो जाहेत, अना यो सेवा मा वोको भी हिस्सा होहेत। ");
INSERT INTO pwr_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","यो मानूस ना अपरो अन्याय को कमाई लक एक खेत लेई सेस, उ ओको मा टोन्ड को बल पडीसे वोको पोट फट गयो, अना वोकी सबरी अतड़ी बाहेर हिट गईसेत। ");
INSERT INTO pwr_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","सबच यरुसलेम का रहवन वारा गीन ला मालुम भय गयो ऐना कारन उ खेत ला हकलदमा मजे खून वालो खेत कहव्सेत। ");
INSERT INTO pwr_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","काहेका भजन संहिता की किताब मा असो भी लिखीसे, “वोको घर उजड़ जाये, अना कोनी ना रव्हे।” अना असो भी लिखयो सेत का वोको सेवा को जघा कोनी अवर ला भेटेत। ");
INSERT INTO pwr_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","एकोलाय यो जरुरी से, का जबा पिरभु यीसु हमरो बीच मा होतो। तबा लक जोन लोक हरामेसा आमरो संग होतिन उनमा लक कोनी एक ला बेचयो जाय, मजे वोना बेरा लक जब ले योहन ना लोकगिन ला बप्तिस्मा देवनो सुरु कियो होतो अना जब तकन आमरो बीच लक यीसु ला उचल लियो गयो होतो। ");
INSERT INTO pwr_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","उनमा लक कोनी एक ला यीसु को दुबारा जित्तो होवन को आमरो सग गवाह होवनो पायिजे। ");
INSERT INTO pwr_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","उन मा लक वोना दुई मानूस गीन को नाव बेच के पेस करीन। यूसुफ को जोनला बरसब्बास, कव्हत होतीन, अना जेनको छाप युस्तुस, होतो, अना मत्तियास ला। ");
INSERT INTO pwr_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","मंग उनना पिराथना करीन, ओ पिरभू तुमी सबच को मन ला जानासे, ये दूई मा लक तुमी कोन ला यो पद लाय बेचयो सेस। ");
INSERT INTO pwr_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","जोन यहूदा जघा होतो वहान वा चले गयो, अना आपरो जघा सोड़ दियो, अबा एक पेरीत को रुपमा सेवा को यो पद ला कोन अपनायेत। ");
INSERT INTO pwr_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","तबा उनना वोको बारे मा चिठ्ठी डाकिस, अना चिठ्ठी मत्तियास को नाव पर हिटी होती अना वय अकरा चेलागीन को संग गिनयो गयो। ");
INSERT INTO pwr_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","जबा यहुदी गीन को तिहार को पन्नास दिवस को मजे फसह को तिहार आयो, ता वय सब बिसवासी गीन एक जगह मा जमा भईन ");
INSERT INTO pwr_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","तभिच एकाएक जोन घरमा बसी होतीन, वहान बादल लक अंधाड बोहन जसी आवाज आई अना जोन घरमा वय बसी होतीन, वोना घरमा आवाज भर गई। ");
INSERT INTO pwr_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","अखिन इस्तो को लपट जसी अना जिबली वानी इस्तो की लपट चोवन लगी। उ इस्तो लपट को टुकड़ा-टुकड़ा हरेक वरता आयके ठहेर गई। ");
INSERT INTO pwr_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","अना वय सबच पवीतर आतमा लक भर गईन अना जेनो तरह लक आतमा, न उनला बोलन की ताकत देईस ता वय अलग-अलग बोली बोलन लगीन। ");
INSERT INTO pwr_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","वहान यरुसलेम सहेर मा दुनिया को सबच देस-देस को भक्त यहूदी रव्हत होतिन। ");
INSERT INTO pwr_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","जबा या आवाज गरजन भई, तबा एक मोठी भीड़ जमा भय गई। अना लोक गीन अचंम्भा मा पड गइन। काहेकि बिस्वासी भाऊगिन ला, आपरो खुद को भासा मा बोलत आयकुयो। ");
INSERT INTO pwr_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","वय सबा चकित होयके आपसी मा कव्हन लगीन, का वय गलील पिरान्त को नाहती? ");
INSERT INTO pwr_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","मंग हमरो मा लक हर एक अपरी-अपरी जलम भूमि की बोली कसो आयकासे। ");
INSERT INTO pwr_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","हमी जसो पारथी अना मेदी अखीन एलामी अना मेसोपोटामिया अखीन, यहुदिया अना कप्पदूकिया अखीन पुन्तुस अना आसिया। दहा अना फ्रूगिया अखीन पंपलिया अना मिसर ");
INSERT INTO pwr_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","अना फ्रुगिया पंफलिया, मिसर, लीबिया, देस जेव कुरेने को अगल-बगल मा ये सबच देसगीन को रव्हनवालो अना रोमी नगर मा जायके रव्हन वारा मा। ");
INSERT INTO pwr_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","यहूदी अना यहुदी बनान केरेती अना अरबी सेत पर अपरी-अपरी भासा मा उनको लक परमेस्वर का मोठा-मोठा काम की गोस्टी आयकासेत। ");
INSERT INTO pwr_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","अना वय सबच चकित होयके अना संका एक दुसरो लक कव्हन लगीन, यो का होय रहीसे? ");
INSERT INTO pwr_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","पर दूसरो लोक गिन ना पेरीतगिन को हसी उड़ाय के कहीन, वय सब ना काही लगतच अंगुर को रस पियो सेत। ");
INSERT INTO pwr_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","तबा उन अकरा को संग पतरस उभो भयो, अना लोग गिनला कव्हन लगयो, अरे यहुदि सगी हुन अना येरुसलेम सहेर मा रव्हनवारा, मोरो सबद आयको, अना एको मतलब मोला सागन देव, ");
INSERT INTO pwr_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","एना लोक गिन नसा मा नाहती, जसो का तुमी मा लक कितरो लोक समजा सेव, अबा तो दिवस को 9 बजयो सेत। ");
INSERT INTO pwr_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","बल्की यो वाच गोस्टी से, जेनको बारेमा योएल भविस्यवक्ता सागयो होतो। ");
INSERT INTO pwr_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","परमेस्वर कव्होसे, का आखीर को दिवस मा असो होयेत का मी सबा मानूसगिन पर आपरो आतमा उबड़ा देहूँ, मग तुमरो टूरा अना टूरी भविस्यवानी सागेत। अना तुमरा जवान दरसन देखेत, अखीन तुमरा सायनो सपना देखेत। ");
INSERT INTO pwr_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","हव, ओना दिवसगिन मा, मी अपरा चाकर अना दासी गीन पर अपरी आतमा उबडाहूँ, अना वय भविस्यवानी करेहेत। ");
INSERT INTO pwr_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","मी ओरिया बादर को खाल्या धरती पर हिदान, अना बादल मा रकत स्तो, आना धुंगा की बादर देखाऊ। ");
INSERT INTO pwr_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","पिरभू को महान अना महीमा को दिवस आवन को पयले सूरज इंधारो अना चांदा रक्त जसो लाली मा बदल जाहेत। ");
INSERT INTO pwr_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","अना जोन कोनी पिरभु लक मद मागेत, वोला पिरभू बचाहेत। ");
INSERT INTO pwr_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","अरे इसरायली गीन मोरी एना गोस्टी ला आयको, यीसु नासरी एक मानूस होतो जेनको लक परमेस्वर ना अचंभा को काम, अखीन हिदान वोको लक करायो, एकोलक यो साबीत होवासेत का परमेस्वर ना वोला धाड़िसेस। यो गोस्टी ला तुमी जाना सेव। ");
INSERT INTO pwr_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","यो मानूस ला परमेस्वर को पक्को योजना अना पक्को पुढ़ा की गियान को अनुसार तुमला सोपो गयो होतो। पर तुमीना पापी मानूस गिन को सायता लक वोला कूरूस पर चघायके मार डाकिन। ");
INSERT INTO pwr_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","पर परमेस्वर न वोला मिरतु को यो उन लक सोड़ाय लियो अना वोला मंग जित्तो करीस। अना मिरतु मा इतरो ताकत नाहोती का वोला बन्धन मा राखे। ");
INSERT INTO pwr_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","कायकि दाऊद वोको बारे मा कव्होसे मी पिरभू ला हमेसा अपरो समने चोवतो रहयो कायकि उ मोरो जेवनो हात कन से ताकि मी ना डगमगाय जाऊ। ");
INSERT INTO pwr_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","एको लाई मोरो मन खुसी सेत, अना मोरी बानी मा खुसी सेत। अना मोरो देह भी आस मा जीव्हेतीन। ");
INSERT INTO pwr_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","कायकि तुना मोरी आतमा ला मिरतु को लोकमा नही छोडजोस, तू आपरो पवीतर बिस्वासी चाकर ला कबर मा नही सड़न देजोस। ");
INSERT INTO pwr_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","तुना मोला जिंदगी को कन जावन की रस्ता चोवाइसेस। आपरो हाजरी लक तु मोला खुसी लक भर देजोस। ");
INSERT INTO pwr_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","अरे मोरा लोकगीन आपरो पुरखा राजा दाऊद को बारे मा मी बेखटका कव्हसू, का उ मर गयो से, अना अबा भी वोको मरघट्टी आज तकन मौजुद से। ");
INSERT INTO pwr_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","उ एक भविस्यवक्ता होतो, उ जानत होतो, का परमेस्वर न करार लक वोको ले वादा करीसेस। का मी वोको खानदान मा लक कोनी एक मानूस ला वोको राजगद्दी पर बसाऊ। ");
INSERT INTO pwr_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","एकोलाय जोन आवन वालो बेरा मा घटनवालो सेत। वोला चोवत हुया, दाउद ना जबा यो सांगयो होतो। वोला मिरतु को दुनिया मा नही सोड़यो गयो। अखिन ना च वोको देह सड़न को लाय मरघट्टी मा राख दियो गयो। तो वोना मसीह को मंग लक जित्तो उचलन को बारे मा कव्हो होतो। ");
INSERT INTO pwr_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","अना वोच यीसु ला परमेस्वर ना दुबारा जित्तो करीस अना हमी सबच येनो गोस्टी का गवाह सेजन। ");
INSERT INTO pwr_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","परमेस्वर को उजो हात कन सब लक वरता पद पायके यीसु ना परम अजी को वादा को अनुसार पवितर आतमा पायके अना मग वोने यो आतमा ला आमरो पर उबडाय देईस जोनला तुमी अबा देखासेव अना आयकसेव। ");
INSERT INTO pwr_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","दाऊद सरग पर नही चाघयो पर उ खुदच कव्हसे, पिरभू न मोरो पिरभू लक कहीस, मोरो उजो बस, ");
INSERT INTO pwr_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","जबा तकन मी तोरो बयरी गिन ला तोरो पाय खाल्या को पीढ़ो को जसो नही बनाय देहूँ। ");
INSERT INTO pwr_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","येको लाय पूरो इसरायल पक्को रूप लक यो जान ले का परमेस्वर ना यो यीसु ला जेनला तुमी न कूरूस मा चघायो होतो वोला पिरभू यीसु अना मसीह बनायो होतो। ");
INSERT INTO pwr_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","लोक गिन ना जबा यो गोस्टी आयकिन ता दुखी भई गईन। वय पेरीतगिन अना उनको संगी गिनला कव्हन लगीन, तो अबा अमीला काजक करनो पड़हेत? ");
INSERT INTO pwr_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","पतरस न उनला कहीस, मन मुरकाओ, अना आपरो पापगिन की छिमा पावन लाई तुम मा लक हरेक ला यीसु मसीह को नाव लक बप्तिस्मा लेवनो पड़हेत। अना तुमला परमेस्वर को उपहार पवितर आतमा मिलहेत। ");
INSERT INTO pwr_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","“कायकी या परन तुमी अना तुमरी अवलाद अखीन वय सब दूर-दूर का लोकगीन को लाई भी से जोनला पिरभू हमरो परमेस्वर ना अपरो जवर हाकलो सेत।” ");
INSERT INTO pwr_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","पतरस न अखिन लगतसा गोस्टी को लक हुसियार करीस अना बिनती को संग उनलक कहीस, यो भिरस्ट खानदानी लक अपरो आप ला बचायके राखो। ");
INSERT INTO pwr_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","उनमा लक लगतसा लोकगिन ना ओको सन्देस ला आयक के बिस्वास करीन, उनला बपतिस्मा दियो गयो, असो परकार वोना दिवस उनको समूह मा, लगभग तीन हजार मानूस अखिन जूड़ गइन। ");
INSERT INTO pwr_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","वय लोक गिन पेरीतगीन लक सिक्सा पावनो अना संगती राखनो अखीन जेवन करनो मा लगयो रहिन। ");
INSERT INTO pwr_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","अना पेरीतगिन को लक अचरज को काम अना मोठयो-मोठयो काम होवत रहयो। अखिन हरेक मानूस अचँभित भेव लक भर गइन। ");
INSERT INTO pwr_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","अना सबच बिस्वासी लगातार संगती बनायो राखत होतिन। अखीन उनको जवर जोन काही जीनुस होतो वोला वय आपसी मा बटवार करत होतिन। ");
INSERT INTO pwr_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","वय अपरी-अपरी सम्पित अना चीज ला बीकत होतिन। अना वोको लक जोन पैसा भेटेत, उनकी जरुरत को अनुसार बाट देत होतीन। ");
INSERT INTO pwr_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","वय हर दिवस मंदिर मा समूह मा मिलत होतिन। वय आपरो घरगिन मा संगमा जेवन बाट-बाट के अना सरल मन लक खुसी लक, मिलजुल के जेवत होतिन। ");
INSERT INTO pwr_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","हर रोज पिरभु उनला समहू मा जोड़त होतो। सबा लोक गिन साजरा भावना को मजा लेवत हुयो, वय परमेस्वर को पिराथना करत होतीन अखीन जोन हररोज बचावत जात होतिन उनला समूह मा मिला लेवत होतिन। ");
INSERT INTO pwr_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","एक दिवस पतरस अना योहन दुफारी, तीन बजे पिराथना को बेरा मंदिर जाय रहयो होतो। ");
INSERT INTO pwr_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","लोक जनम को लगंडा ला हररोज आवन-जावन को जघा मा बसाय देत होतीन ताकि उ मंदिर मा आवन जावन वालो लक भीख मांगे। ");
INSERT INTO pwr_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","यो मानूस न जबा योहन अना पतरस ला मंदिर मा धसता देखिस, ता ओना उन लक आपरो लाय भीख मांगिस। ");
INSERT INTO pwr_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","उनना सिधो योहन कन चोविन अना पतरस ना कहीस, “हमरो कन देख।” ");
INSERT INTO pwr_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","तबा उ काही पावनो की इक्सा लक उनको, कन ताकन लग्यो। ");
INSERT INTO pwr_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","पर पतरस न वोको लक चोवत हुयो कहीस “मोरो जवर तोला देवन लाय काही पैसा नाहती पर जोन काही सेत उ मी तोला देवासू। नासरत को यीसु मसीह को नाव लक उभो होय अना चल मंग।” ");
INSERT INTO pwr_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","मग वोना वोको उजो हात ला धरके ना ओला उचलीस, एकदम ओको पाय अना घुटना मा जान आय गयी। ");
INSERT INTO pwr_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","तबच उ उछल के उभो भय गयो अना इतानी-उतानी उछलत कुदत उनको संग परमेस्वर को मंदिर मा गयो। ");
INSERT INTO pwr_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","सप्पा लोक गीन ने वोला चलता-फिरता अना परमेस्वर की स्तूती करता देखीन। ");
INSERT INTO pwr_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","लोकगिन ना वोला चीन लेइन यो ता ओच आय जोन मंदिर को सुन्दर फटका मा भीक मांगत होतो वोको सग घटयो घटना ला चोयके वय एकाएक अचंभा मा पड़के चकीत भय गईन। ");
INSERT INTO pwr_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","उ मानूस पतरस अना योहन को संग होतो एकोलाय सबरी लोक अचम्भीत होयके, सुलेमान नाव को डहरी को जवर परात आइन। ");
INSERT INTO pwr_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","पतरस न जब असो चोयो ता लोकगीन लक कहयो, अगो इसरायल को लोकगिन, तुम ऐको पर कायलाय अचम्भीत सेव, अना असो घुर-घुर के आमीला कायलाई चोय रही सेव, असो लगासे का आमीना अपरो ताकत अना भक्ति को हिम्मत लक यो मानूस ला चलन-फिरन को लायक बनाय दियोसेजन। ");
INSERT INTO pwr_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","अबराहम इसहाक अना याकूब को परमेस्वर, आमरो आजा पुरखा परमेस्वर न आपरो दास यीसु ला अपरो महिमा देइसेस पर तुमीना वोला अधिकारी गीन ला सोप दियो अना तुमीना पेन्तुस-पीलातुस को पुढा नकार दियो जबकि पिलातुस न वोला छोड़ देनो को मनसा राखीयो होतीस। ");
INSERT INTO pwr_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","तुमीना वोना साजरो अना नेक मानूस ला ठुकरायो, अना वोको बदला मा पीलातुस लक मांग करयत का एक खून करनवालो ला तुमरो लाय छोड़ दियो जाय। ");
INSERT INTO pwr_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","तुमीना जिंदगानी को रास्ता चोवन वारा ला मार डाकयात। पर परमेस्वर न वोला मरयो हुयो मा लक जित्तो करीस। हमी वोको पुरुप सेजन। ");
INSERT INTO pwr_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","काहेकी अमी यीसु को नाव मा भरोसा करासेजन। एकोलाय यो वोकोच नाव सेत जोन न यो लगंडा मानूस ला ताकत देइसेस, जोन ला तुमी चोवासेव अना वोला जानासेव वोला पाय मा ताकत देयि सेस जेनला तुमी चोय रही सेव। ओनाच बिस्वास लक जोन यीसु लक भेटासे, तुमी सब को पुढ़ा एने मानूस ला पुरो तरीका लक साजरो करीसेस। ");
INSERT INTO pwr_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","अना अबा अगा भाऊ गीन मी जानासू का यो काम तुमी ना वसोच करीसेव अना वोसोच, तुमरो मुखियागीन ना भी करीसेत। ");
INSERT INTO pwr_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","पर जेना गोस्टी ला परमेस्वर न सबच मोठो भविस्यवक्ता को टोन्ड लक पहेलच सांग दियो होतो का वोको, मसीह दुख उठाये वोना ऐना रिती लक पूरो करीसेस। ");
INSERT INTO pwr_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","एकोलाय परमेस्वर को कन लौट जाव जोन लक उ तुमरो पाप हुन ला छिमा करेत। ");
INSERT INTO pwr_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","जोन लक आतमा को ताकत को बेरा पिरभू को कन लक आय अना पिरभु तुमरो लाय मसीहा ला धाड़े जोन न ओना पयले लक बेचके राखीसेस, मजे यीसु ला। ");
INSERT INTO pwr_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","अना मसीह ला जरूरी से का वोना बेरा तकन सरग मा रहेत, जबा तकन सबरी गोस्टी पहेलो जसो सुधारी न जाय। जोन को चरचा लगत पहेल लक परमेस्वर न अपरी पवीतर लोकगीन लक करी होतीस। ");
INSERT INTO pwr_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","जसो का मोसे भविस्यवक्ता न कहीस, मोरो जसो एक भविस्यवक्ता तुमरो लोकगीन मा लक धाडे़ह अना जोन काही उ तुमला करन लाई कहे वोला तुमी पुरो रिती लक मानना। ");
INSERT INTO pwr_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","पर जोन कोनी मानूस वोना भविस्यवक्ता की गोस्टी नही मानेत वोला परमेस्वर को लोकगीन लक बेगरो कियो जाहे, अना वोको सत्यानास कर दियो जाहे। ");
INSERT INTO pwr_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","हा समूएल अना वोको मंघा आयो सबच भविस्यवक्ता गीन ऐना दिवस गीन को बारे मा मुनादी कियो होतो। ");
INSERT INTO pwr_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","तुमी तो वोना भविस्यवक्ता गीन अना वोना करार को वारिस सेव जोन ला परमेस्वर न तुमरो आजा पुरखा, लक करार करीसेस जबा वोना अबराहम लक कहीहो तीस, तोरो खानदान लक धरती का सप्पा खानदान आसीस पाहेत। ");
INSERT INTO pwr_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","अना परमेस्वर न अपरो दास ला बेचीस, अना तुमरो जवर धाड़िस, ताकि तुमला तुमरो खोटो रास्ता लक हटाय के आसीस देहे। ");
INSERT INTO pwr_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","जब पतरस अना योहन, लोक गीन लक, गोस्टी कर रही होतीन, का याजक मंदिर को मुखिया, अना सदूकी लोकगीन वोको जवर आइन। ");
INSERT INTO pwr_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","वय उन पर एना गोस्टी पर गुस्सा होतीन, का पतरस अना योहन उन लोकगीन ला सिकावत होतीन, का यीसु मरयो हुयो मा लक जित्तो भइसे, वोको लक असो साबीत करत होतीन का मरयो हुयो मानूस जित्तो होय सेकासे। ");
INSERT INTO pwr_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","आखिन काहेका वोना बेरा झुलाखाली भय गई होती। एकोलाय उनला दुसरो दिवस तकन उनला जेलमा राखिन। ");
INSERT INTO pwr_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","पर जिनना उ संदेस ला आयकीन होतीन उन मा लक लगत लोकगीन वोको भरोसा करीन, अना उनको गिनती लग-भग लगभग पाँच हजार, तकन पुहुची होतीन। ");
INSERT INTO pwr_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","आवन वालो दिवस मा यहुदिगीन को नेता, सायना अना नियम को गुरु येरुसलेम सहर मा जुमला भईन। ");
INSERT INTO pwr_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","मुखिया पुजारी हन्ना, काइफा, योहन, सिकन्दर अना मोठो याजक को परिवार को सबच लोकगीन वहान हाजीर होतीन। ");
INSERT INTO pwr_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","वय पतरस अना योहन, ला उनको बीच उभो करके असो पुस ताछ करन लगीन, “तुमी लोकगीन न कोनती, ताकत अना अधिकार यो काम करीसेव?” ");
INSERT INTO pwr_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","पतरस न पवीतर आतमा लक भरपुर होयके, उन लक कहीस, अगा लोकगीन को मुखिया अना मोठो सायना! ");
INSERT INTO pwr_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","अदि हमी लक आज उ कमजोर मानूस कसो साजरा भयो यो बारे मा यो पुस ताछ करियो जासे ");
INSERT INTO pwr_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","तो तुमी सबच ला अना इसरायल, की लोकगीन ला यो जान लेवनो चाहिये का यो काम नासरत को रहनवालो यीसु मसीह जेनला तुमीना कूरूस पर मरवाय डाकयत अना जेनला मोठयो परमेस्वर ना मंग लक जित्तो कर देयीसेस, ओकोच लक यो मानूस तुमरो पुढ़ा साजरा चंगो से। ");
INSERT INTO pwr_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","यो वाच गोटा से जोनला घर बनान वालो मिस्तरी गिनना नकारो बेकार समझ के हटायो होतिन वोच एक गजब जरूरी गोटा बन गयो। ");
INSERT INTO pwr_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","अना कोनी दुसरो मानूस लक बचाव नाहती से, काहेकी पूरो संसार मा मानूसगिन, ला कोनी दुसरो नाव नही देई सेस, जेनको लक आमरो, सूटकारा होय सके। ");
INSERT INTO pwr_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","उनना जबा पतरस अना योहन ला निडर चोयके, अना यो जाके का, वय अनपढ अना साधारन मानूस सेत। उनला मोठो अचंभा भयो। मग वय पहचान गईन, यो ता यीसु को संग रहयो लोक सेत। ");
INSERT INTO pwr_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","अना काहेकि वय वोनो मानूस ला जोन साजरो भयो होतो, उनको संगा उभो चोय रहयो होतीन, एकोलाई उनको कठा काही कव्हन लाई नही रहयो। ");
INSERT INTO pwr_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","पर उनना पतरस अना योहन ला सभा लक बाहेर हेड़ देइन अना वय आपस मा सला बिचार करन लगीन, ");
INSERT INTO pwr_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","“एना लोक गीन को संग कसो बरताव करयो जाय? काहेका येरुसलेम सहेर मा रहवन वारा, सबच लोक गीन जानासेत, का इनको लक एक जाहिर अचंभा भयो सेत। जोनला नकारो नही जाय सकसे। ");
INSERT INTO pwr_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","बल्कि हमी इनला चेताय देसेजन की वय एना नाव की चरचा कोनी अखिन मानूस लक नही करबिन ताकि लोक गीन मा एनो गोस्टी को अखिन बढनो रोखियो जाय सकेहे।” ");
INSERT INTO pwr_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","वोना पतरस अना योहन, ला बुलावन धाडीस, अखीन उनला हुकूम देईन, का वय यीसु को नाव को कोनी लक काहिच चरचा नोको करे अखिन कोनी ला गोस्टी नोको सांगेत। ");
INSERT INTO pwr_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","ऐको पर पतरस अना योहन न उनला, जवाब देईन “अबा तुमी सागो का परमेस्वर की नजर मा हमरो लाई यो साजरो होयेत का अमी परमेस्वर को हुकूम तोड़ के तुमरो हुकूम मान बीन? ");
INSERT INTO pwr_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","काहेकी असो नही भई सकासेत। का जोनला हमी चोवीसेजन, अना आयकी सेजन कोनी ला वोको बारे मा नही सांगबिन।” ");
INSERT INTO pwr_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","मंग उनना उनला अखिन कड़ो रुप लक चेताय के सोड़ देइन। काहे का उनला सजा देवन को कोनी बहाना नाहोती। काहेका जोन घटना घटी होती। वोकोलाय सबच स्तूती करत होतिन। ");
INSERT INTO pwr_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","अना जोन मानूस को संग यो अचंभा भयो, वोकी उमर चालीस बरसा लक जादा, होती। ");
INSERT INTO pwr_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","जसोच पतरस, अना योहन ला सोड़यो गयो। वय मंग अपरा लोक गीन को समूह मा गइन। अना उनलक जोन काही मुखिया याजक गीन अखीन सयाना यहूदी पेरीत ना कही होतीन, उ सब गोस्टी उन ला कह आयकवाइन। ");
INSERT INTO pwr_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","जबा बिसवासीगीन ना यो आयकिन, ता वय मिलके उचो आवाज लक पिराथना करन लगीन, “मालिक तुनच बादर अना धरती, सागर अना, वोको मा जोन काही सेत, उन सबला बनाइसेस। ");
INSERT INTO pwr_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","तुनच पवीतर आतमा लक हमरो पुरखा, अपरो सेवक दाऊद को टोन्ड लक यो कहयो होतो।” ऐना जमाना को लोकगीन ना जाने काहे आपरो घमन्ड चोवायो, लोकगीन ना फालतुच साजिस कायलाई रच डाकिन। ");
INSERT INTO pwr_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","पिरभू अना वोको, मसीह को विरोध मा, सासन करन वारा नियावी, धरती को सासक उभो भयो, अना राजा गिन आपस मा मिल गइन। ");
INSERT INTO pwr_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","हेरोदेस अना पोंतियुस पीलातुस भी ऐना सहर मा गैरयहुदी गीन अना इसरायिल गीन को संगा मिलके तोरो पवितर सेवक यीसु को विरोध मा, जेनला तुना मसीह को रूप मा निवाड़ी होतो। वाकई मा एकजुट भय गयी होतीन। ");
INSERT INTO pwr_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","वय जुमला भईन ताकि तोरो सकति अना मरजी को अनुसार जोन काही पयले लक पक्को होय गयो होतो, वा पुरो होय सके। ");
INSERT INTO pwr_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","अबा वो पिरभू! तु उनको धमकी, पर धियान दे, अना बिना भेवको दास ला तोरो बचन आयकावन को ताकत देव। ");
INSERT INTO pwr_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","अना अबा तु अपरो हात बढायके, अपरो पवीतर दास यीसु को, नाव लक साजरो काम हिदान अना अचँभा काम होवन देव। ");
INSERT INTO pwr_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","जबा उनना पिराथना पूरो करीन ता जोन जघा मा वय होतिन, वा हिल गई अना उन सब मा पवीतर आतमा समा गयो, अना वय बेधड़क परमेस्वर, को गोस्टी आयकावन लग्यो। ");
INSERT INTO pwr_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","भरोसा करन वालो गीन को समुदाय एक चित अना एक मन होती, उनमा कोनी भी आपरी जायदाद ला आपरी नही मानासेत, जोन काही उनको जवर होतो वोमा सबको हिस्सा एक मा से। ");
INSERT INTO pwr_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","चेलागीन मोठो ताकत लक पिरभू यीसु को, मर जानो पर जित्तो उचलनो, की गवाही देत होतिन, अना वय सब पर परमेस्वर को मोठो दया होतो। ");
INSERT INTO pwr_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","वोना समूह मा कोनी असो नही होतो, जोनला काही बात को घटी होय, काहेका जिनको जवर खेत, मकान होतीन, वय उनला बीक देत होतीन, अना धन रासी ला आनके। ");
INSERT INTO pwr_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","पेरीत ला सोप देत होतिन, अना हर एक को वोकी जरुरत को अनुसार बाट देत होतिन। ");
INSERT INTO pwr_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","उदाहरन को लाई यूसुफ, नाव को एक मानूस होतो, वय लेवी खानदान, को होतो। वोको जन्म साइप्रस, दीप मा भयो होतो। चेलागीन, न वोको छाप को नाव बरनबास, मन्जे हिम्मत को टूरा राखी होतिन। ");
INSERT INTO pwr_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","वोको जवर काही जमीन होती, वोना वोला बीक देईस, अना वोको लक मिलयो, रुपया ला आन कर पेरीत ला सोप देइस। ");
INSERT INTO pwr_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","पर हनन्याह नाव को मानूस न अना ओकी बायको सफीरा ना मिलके आपरी जायदाद को एक हिस्सा बेच देइन। ");
INSERT INTO pwr_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","अना वोना अपरी बायको ला जानकारी मा ओना एमा लक काही धन बचा लेइयो। अना बाकी धन पेरीत ला को पाय खाल्या राख देइन। ");
INSERT INTO pwr_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","ऐको पर पतरस न कहीस, अरे हनन्याह; सैतान ला तुना आपरो मनमा यो गोस्टी कायलाई डाखन दियो? का तुना पवितर आतमा लक खोटो सांगे, अना बोकी जमीन को रकम लक काही बचाय के राख लियो। ");
INSERT INTO pwr_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","जब तक तुना उ जघा ला बिकी नही होतयो का वा तोरी नही होती? पर जब तुना ओला बिक दियो, अना जोन धन मिलयो उ तोरोच होतो, मंग तुना आपरो डिमाक मा खोटो बोलन को कायलाय सोचयो? तुना मानूस लक नही, पर परमेस्वर लक खोटो सागिसेस। ");
INSERT INTO pwr_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","यो गोस्टी आयकत च उ भुईमा पड़ गयो, अना उ मर गयो। वय सबच जोन यो गोस्टी आयकत होतिन, उनमा भेव समा गयो। ");
INSERT INTO pwr_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","जुवान गीन न उभो होयके वोला कफन मा लपेट के अना बाहेर ली जायके गाड़ देईन। ");
INSERT INTO pwr_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","लगभग तीन घन्टा बाद मा ओको लक अनजान, वोकी बायको भितर आई, वा ऐना घटना को बारे मा काही नही जानत होती। ");
INSERT INTO pwr_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","पतरस न वोला सवाल करीस, का अता मोला सांग, उ जघा वोतरोच मा बिकी सेव? ता वा जवाब देईस, हव येतरोच मा से। ");
INSERT INTO pwr_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","ऐको पतरस न वोको लक कहीस, या काजक गोस्टी से? का तुमी दुई पिरभू को आतमा की परिक्सा लेवन को लाय एक चित भई सेव? अता चोव, जोन लोक गीन तोरो नवरा ला गड़ाय के आयोसेत वय बेसकुड़ मा उभो सेत, अना अबा तोला भी लिजाहेत। ");
INSERT INTO pwr_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","वा वोच बेरा पतरस को पाय खाल्या पड़ गई, अना वोको जान हिट गयो। जवानगीन भितर आयके वोला मरयो हुयो पाईन, अना वोला उचलके, वोको नवरा को बगल मा गड़ाय देईन। ");
INSERT INTO pwr_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","ऐको लक सारी कलीसिया मा अना जेतरा लोक गीन न ऐना गोस्टी ला आयकिसेत, वय सबच पर मोठो भेव छाय गयो। ");
INSERT INTO pwr_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","पेरीत गीन लक लोकगिन को बीच लगत सा हिदान, दिसात होतिन। अना अचँभा काम करत होतिन। वय सबा बिस्वासी गिन सुलेमान को ओसरी मा जमा होतीन। ");
INSERT INTO pwr_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","वोना समहु मा सामिल होवन को हिम्मत कोनी नही करत होतिन मंग लोकगीन उनकी बढाई जरुर करत होतीन। ");
INSERT INTO pwr_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","पिरभू मा भरोसा करन वालो मानूस अना बायका लगत-लगत बड़त होतिन। ");
INSERT INTO pwr_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","एको असो फर भयो का जोन लोक अपरा बिमारगीन ला आनके खाट अना बिस्तर मा आन-आन के रस्ता-बाट मा सोवान लगीन, जोनलक जबा पतरस उता लक हिटेत त काही भी पिरकार लक वोकी सावली पड़जाय। ");
INSERT INTO pwr_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","येरुसलेम नगर को आखापाखा को नगर लक अपरो बीमार गीन ला अना दुस्ट आतमा लक पीड़ित लोकगीन ला आनके उनको जवर राख देइन, अना वय सबच साजरो भय जात होतीन। ");
INSERT INTO pwr_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","मंग महायाजक अना उनको संगी मजे वोना नगर को सदुकीगिन को झुंड उनको बिरोध मा उभा भय गईन। वय ईरसा लक भर गईन। ");
INSERT INTO pwr_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","एकोलाई उनना पेरीतगीन ला बान्ध के एक जेल मा डाख देइन। ");
INSERT INTO pwr_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","पर रात को बेरा मा, पिरभू को एक सरगदूत ना जेल को बेसकुड़ खोल देइस। अना उनला बाहेर हेडके असो कहीस। ");
INSERT INTO pwr_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","जावो, मंदिर मा उभो भई जाव, अना यो नवा जिंदगी को बारेमा सबला सांगो। ");
INSERT INTO pwr_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","जबा उनना असो आयकिन ता सक्कारी वय मंदिर जायके धस के उपदेस देन लगीन। मंग महायाजक यहुदि अगवा अना उनको संगी वहान आइन त उनना वहान पर उनना यहुदी अगवा अना इसरायल को सायना हिन को पुरो सभा ला बुलाइन। अना सिपाई धाड़िन का जेल मा लक पेरीतगीन ला आनो। ");
INSERT INTO pwr_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","जबा अधिकारी जेल मा पहुचीन, ता वहान पेरीतगीन ना होतीन। त उनना लवटके खबर सांगिन। ");
INSERT INTO pwr_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","अना उनना कहिन, जबा हमी जेलमा पहुचयो ता अमीना चोवयो का जेलमा कुलुप लगयो होतो, अना बेसकुड़ मा पेहरा देवनवारा उभो होतिन। पर बेसकुड़ खोलन पर मंग हमला भीतर कोनी च नहि भेटयो। ");
INSERT INTO pwr_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","जबा मंदिर को रखवारा गिनको अधिकारी ना अना महायाजकगिन न असी खबर आयकिन ता वय उनको बारेमा सोच मा पड़ गइन “का अबा काजक होहेत।” ");
INSERT INTO pwr_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","ऐतरो मा कोनी न आयके उनला खबर देईस देखो तुमी ना जिन लोकगीन ला जेल मा डाकिसेव वय मंदिर मा उभा होयके लोक गीन ला सिक्सा देय रहीसेत। ");
INSERT INTO pwr_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","तबा मंदिर को सुरक्सा करनवारा सिपाईगिन को अधिकारी आपरो अधिकारी गिन सग वहान गयो। अना बिना सकती बरते उनला वापस आनीन। काहेकी उनला डर होतो का कही लोकगिन अमीला गोटा नोको मारहेत। ");
INSERT INTO pwr_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","उनना पेरीतगीन ला मोठी धरम सभा को पुड़ा उभा कर देइन मंग महायाजक न सवाल पुसिस अना कहयो, ");
INSERT INTO pwr_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","हमीना एना नाव को सिक्सा देवन लाई तुमला कड़ो हुकूम मना कियो होतो, मंग तुमी यो सिक्सा लक सप्पा येरुसलेम सहेर ला भर देइसेव। अना वोना मानूस की हत्या को दोस आमरो पर लादनो चाव्हासेव। ");
INSERT INTO pwr_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","पतरस अना पेरीतगीन न असो जवाब देइन, “मानूस गीन को बजाय परमेस्वर को गोस्टी ला माननो जरूरी सेत।” ");
INSERT INTO pwr_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","तुमी लोकगीन न यीसु ला कूरूस काड़ी मा खील्ला ठोक के मार डाकिसेव। पर आमरो सायना गीन को परमेस्वर न उनला मरयो मा लक जित्तो करीस। ");
INSERT INTO pwr_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","ओला च परमेस्वर ना अगवा अना सुटकारा देवनवालो ठहरायके उजो हात कन राखीसेस, ताकी उ इसरायल गीन ला पाप छिमा अना मन मुरकान को मौका देहे। ");
INSERT INTO pwr_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","एना सप्पा गोस्टी को अमी गवाही सेजन, अना वसोच पवीतर आतमा भी जोनला परमेस्वर न आपरो हुकूम मानन वारा लोकगीन ला देइसेस। ");
INSERT INTO pwr_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","जबा सभा को मेम्बरगीन न असो आयकिन, त वय दुफारी को ऊन जसो तमतमा गइन। अना वय प्रेरितगिनला मार डाखन चाव्हत होतीन। ");
INSERT INTO pwr_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","पर उन मा लक एक फरिसी जोनको नाव गमलीएल होतो। जोन मोसे को नियम को गुरू होतो, अना सब लोकगिन मा वोको मोठो मान होतो। सभा मा उभो भयो अना यो हुकूम दियो। का पेरीतगीन ला जरासो बेरा को लाई बाहेर हेड़ देव। ");
INSERT INTO pwr_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","तबा उ सभा मा कव्हन लगयो। “इसरायली भाऊगिन तुम इन लोकगीन को संगा जोन काही करन चाव्हसेव वोला तुमी सोच समझके करो। ");
INSERT INTO pwr_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","का तुमला हेत से? काही बेरा पयले, आपरो आपला एक महान मानूस कव्हन वालो, थेउदास नाव को मानूस तुमरो बीच मा उभो भयो होतो। अना करिब चार संबर लोकगिन वोको मघा भय गई होतीन। पर उ मार डाख्यो गयो, अना वोका मानन वारा सबच लोक इता-उता बगर गईन। अना वोको कोनी मतलब नही हिटयो। ");
INSERT INTO pwr_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","मंग जनता को गिनती को बेरा, गलील को रव्हनवारा, एक यहूदा नाव को मानूस उभो भयो। ओना भी काही लोकगिनला आपरो मंघा कर ह लियो होतो। उ भी मारो गयो, अना तीस ओको मघा चलनवारा सबच लोक इता-उता बगर गईन। ");
INSERT INTO pwr_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","एको लाई ऐना बेरामा, मी तुम्हिला कव्हसू, ऐना लोकहुन लक बेगरो रव्हो। इनको मामला मा कोनी काम नोको करो, इनला एकलो राख देव अदि इनको पिलान अना काम मानूस को कन लक सेत, त आपरो आप खतम भयी जाहेत। ");
INSERT INTO pwr_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","पर अदी यो काम परमेस्वर को कन लक सेत, ता तुमी येला नही रोख सकसो। अना तबा होय सकसे, तुमी आपरो आपला परमेस्वर को बिरोध मा पाहो।” उनना वोको बात मान लेइन। ");
INSERT INTO pwr_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","अना उनना पेरीत गिनला बुलाइन, अना उनला कोड़ा मरवाइन, अना हुकूम देइन का यीसु को नाव को चरचा नोको करे, अना उनला सोड़ देइन। ");
INSERT INTO pwr_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","वय खुसी होयके मोठी सभा लक चली गईन, काहेका उनना असो मानिन का परमेस्वर ना उनला यीसु को नाव लाई, बेइज्जत होवन को काबील समझयो। ");
INSERT INTO pwr_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","मंग वय मंदिर अना घर-घरमा हरेक दिवस सदा ऐना साजरो बारता ला आयकावन लगीन। का यीसु च मसीह से। उपदेस देवनो अना चरचा करनो नही सोड़िन। ");
INSERT INTO pwr_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","काही दिवस को मघा जबा चेला गीन की गिनती बढत होती। ता यूनानी बोलनवारा बिस्वासी, अना इबरानी बोलन वारा यहुदी बिस्वासी, मा एक बैस भई गई। काहेका युनानी बोलनवारा यहुदी बिस्वासी यो दावा करत होतिन का उनको बेवागिन ला रोज को जरुरत को चीजगिन ला बाटनो मा अनदेखयो करत होतिन। ");
INSERT INTO pwr_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","ता बारा पेरीतगिन ना चेलागीन को सारो मन्डली ला एक संग हाकलके कहीस, “आमरो लाय, परमेस्वर को बचन की सेवा ला सोड़, जेवन अना रुपिया को बरताव कन धियान देवनो साजरा नाहती।” ");
INSERT INTO pwr_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","ता भाऊगिन साजरा नाव वारा, पवितर आतमा अना सूझबुझ लक भरयो, सात मानूस ला आपरो मा लक बेच लेव, अमी उनला यो काम को अधिकारी बना देबिन। ");
INSERT INTO pwr_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","अना अमी आपरो आपला पिराथना अना वचन को सेवा, को काम लगायो राखबिन। ");
INSERT INTO pwr_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","यो सुझाव लक सबरी मन्डली लगत खुस भय गईन। ता उनना बिस्वास अना पवितर आतमा लक भरयो, स्तिफनुस नाव को मानूस ला, अना फिलिप्पुस, प्रोखरुस, निकानोर, तीमोन, परमिनास अना अन्ताकिया-निवासी जोन यहुदी बन गयो होतो निकोलास ला बेचयो। ");
INSERT INTO pwr_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","अना इन लोकगिन ला उनना पेरीतगिन को पुड़ा हाजिर कर दियो अना पेरीतगिन पिराथना करके उनला नियुक्त करीन। ");
INSERT INTO pwr_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","असो परमेस्वर को गोस्टी लगातार याजक गिनको एक मोठो समहु भरोसा मानन लगीन। अना येरुसलेम नगर मा चेला गीन की गिनती लगत बढगइ। ");
INSERT INTO pwr_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","स्तिफनुस दया अना ताकत लक पूरो पक्को होयके लोक गीन को बीच मोठो-मोठो अचँभा काम अना चिन्हान देखावत होतो। ");
INSERT INTO pwr_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","पर नाव को लाय अजाद करीयो गयो, यहुदि लोकगीन को सभाघर को काही लोक, जोन कुरेनी अना सिकन्दरिया अना किलिकिया आसिया प्रांत लक आयो यहुदी होतीन, वय स्तिफनुस को बिरोध मा वाद विवाद करन लगीन। ");
INSERT INTO pwr_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","पर वा आतमा जोन लक उ गोस्टी करत होतो, अना वोको अक्ल को पुढा वय नही ठैयर सकिन। ");
INSERT INTO pwr_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","मंग उनना काही लोक गीन ला लोभ देके कहलवायो। हमिना मोसे अना परमेस्वर को बिरोध मा एला बेज्जती को गोस्टी करता आयकासेजन। ");
INSERT INTO pwr_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","असो परकार उनना लोकगीन को मोठो सयानागीन, यहुदी नेतागिन, अना मोसे को नियम को गुरूगीन, ला भड़कायो। मंग उनना आयके वोला धर लेइन अखिन वोला घसीटके यहुदी मोठी सभा को पुड़ा आनीन। ");
INSERT INTO pwr_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","अना उनना खोटो गवाही पेस करीन, जेनना कहिन का यो मानूस हरामेसा आमरो पवीतर मंदिर को बिरोधमा, अना मोसे को नियम गिरंथ को बिरुधमा कव्हसेस। ");
INSERT INTO pwr_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","काहेका हमिना वोला यो कव्हतो आइकेसेजन, का यो नासरत को यीसु यो मंदिर ला नास कर देहेत। अना आमरो रिति रिवाज ला बदल देहेत, जोनला मोसे ना अमिला देइसेस। ");
INSERT INTO pwr_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","तबा सबा लोक जोन महासभा मा बसयो होतिन, वोला धियान लक चोविन। ता उनला कोनी सरगदूत को तोन्ड जसो चोविस। ");
INSERT INTO pwr_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","तबा महा यजक न कहयो, “का या गोस्टी सही से?” ");
INSERT INTO pwr_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","स्तिफनुस न जवाब देईस, “अगो भाऊ गीन अना मोरो अजि को जसो बुजरुक हुन, मोरी गोस्टी आयको, आमरो अजी अबराहम हारान देस मा रव्हन लक पयले, मेसोपोटामिया मा रव्हत होतो।” ता उ बेरा महिमा वालो परमेस्वर न वोला दरसन देईस। ");
INSERT INTO pwr_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","अना वोको लक कहीस, तु अपरो देस अना खानदान ला छोड़ दे अखीन वोना देस मा जाय, जोनमी तोला मी देखाऊ। ");
INSERT INTO pwr_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","एकोलाय उ कसदिगिन को देस ला सोड़, हारान देस मा बस गयो। जहान ले वोको अजी को मरन को मघा, परमेस्वर न वोला एना देस मा आवन को लाय उकसायो जहान तुमी अबा रव्हसेत। ");
INSERT INTO pwr_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","पर परमेस्वर ना वोला वारसाना मा काही नही दियो, अना उ देस मा पाय मंडावन जघा भी नहि दियो। वोना बेरा वोको कोनी टूरा नाहोती, मग परमेस्वर ना करार कियो का, यो देस उ वोला अना वको खानदान ला, उनको धन माया को रूपमा देहेत। ");
INSERT INTO pwr_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","परमेस्वर न वोला यो भी कहीस “तोरो खानदान को लोक गिन पर देसी लोकगिन को कबजा मा रहेत।” अना चार सौ बरस तकन उनला गुलाम बनायेके बुरो बरताव करहेत। ");
INSERT INTO pwr_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","परमेस्वर न कहीस, “गुलाम बनावन वालो देसला, मि खुदच दन्ड देहुँ, एको बाद वय वा देस लक बाहेर हिट जाहेत, अना एना जघा मा वय मोरो सेवा करेहेत।” ");
INSERT INTO pwr_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","तबा परमेस्वर न अबराहम को लाई मुहर लक छापा ठहरायो अना उ करार लक अबराहम इसहाक को अजी भयो। तबा उ वोको जलम को आठवो दिवस मा वोको खतना करीयो। मग इसहाक लक याकूब अना याकूब लक बारा कुल को पुरखा पैदा भईन। ");
INSERT INTO pwr_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“आमरो पुरखा याकूब को टूरा गिन अपरो भाऊ यूसुफ लक जलन राखत होतिन। एकोलाय उनना वोला मिसर देस मा दास बनन लाय बीक देईन। पर परमेस्वर वोको संग रहयो।” ");
INSERT INTO pwr_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","वोना सब परेसानी लक उनला सूटकारा देइस अना वोला मिसर इलाका को राजा फिरोन की नजर मा दया अना अकलवर बनाय देईस फिरोन न यूसुफ ला मिसर देस अना पूरो राज भवन को अधिकारी बनाय देईस। ");
INSERT INTO pwr_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","मग मिसर अना कनान देस मा मोठो गीरानी पडि अना संकट छाय गयो अना खावन काजी काही नही मिल्यो। ");
INSERT INTO pwr_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","अना याकूब न आयकिस, का मिसर देस मा अनाज से, ता वोना आपरो टूरा आमरो पुरखागीन ला मिसर धाडिस। यो उनको पयलो भेट होतो। ");
INSERT INTO pwr_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","दुसरी यातरा को मोका पर यूसुफ न अपरा भाऊगिन ला अपरो पहेचान देईस अना फिरोन मिसर को राजा ला यूसुफ को परिवार को पता चलयो। ");
INSERT INTO pwr_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","तबा यूसुफ न अपरो बाप याकूब अना वोको पूरो परिवार झन ला बुलाईस सब मिलाय के वय पचहत्तर आदमी होतीन। ");
INSERT INTO pwr_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","याकूब मिसर देस मा आयो। अना वोना वहान वसोच मरिन जसो आमरो पुरखा मिरो होतिन। ");
INSERT INTO pwr_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","मंग उनको लास वापस सकेम नगर आनीन, अना वोना मरघट्टी मा राखयो गयो यो वोच मरघटी होतो जेनला अबराहम न सकेम नगर मा हमोर को टूरा गीन ला चाँदी देयके लेई सेस। ");
INSERT INTO pwr_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","परमेस्वर न अबराहम लक जाय परन करीस जबा वोकी पूरो होवन को बेरा जवर आय गईसे तबा आपरो लोक गीन की संख्या मिसर इलाका मा लगत बढ गईसे। ");
INSERT INTO pwr_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","आखीर मा मिसर इलाका मा एक असो राजा को सासन आयो जेव यूसुफ ला नही जानत होतो। ");
INSERT INTO pwr_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","वोना हमारी लोक को संग कुरता को बेवहार करीस, वोना आमरो पुरखा गिन ला मजबूर करीस का वय अपरो लहान सो लेकरा ला बाहेर फेक देहेत जेनको लक वय जित्तो न रव्ह सकसेत। ");
INSERT INTO pwr_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","वोच बेरा एक लेकरा को जलम भयो। मोसे गजब खुबसुरत होतो, उ तीन महीना तकन अपरो अजीगीन को घर मा पालो गयो। ");
INSERT INTO pwr_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","एको बाद जबा उनना घरको बाहेर फेकिन तो फिरोन को टूरी वोला आपरो टूरा बना के उठाय ले गइस वोना आपरो टूरा को जसो पालिस। वपलागयो तबा फिरोन की टूरी न वोला गोद लेईस अना आपरो टूरा को जसो वोको लालन पालन करीस। ");
INSERT INTO pwr_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","मोसे ला मिसरी को पुरो कला कौसल क सबच सिक्सा दियो गयो। उ बोलन मा ताकतवर अना काम मा वरता होतो। ");
INSERT INTO pwr_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","जबा वय चालीस बरस को भयो तबा उनको मन मा आयो का अपरा इसरायल भाऊ लक भेंट करेत। ");
INSERT INTO pwr_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","जबा एक बेरा वोना चोवयो वोनो मा कोनी एक को सघ बुरो बेवहार करत होतिन। ता वोना वोला बचायो। अना मिसरी ला मार के वोना वो मानूस को बदला ले लियो। ");
INSERT INTO pwr_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","वोना सोचयो होतो का वोको भाऊ बन्धू जान जाहेत, उनला सूटकारा देवन काजी परमेस्वर वोको उपयोग कर रहयो सेत। पर वय असो नही समझिन। ");
INSERT INTO pwr_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","परो दिवस मोसे न दुई इसरायल गीन ला लडता देखीस। उनला मोसे कहीस, हे इसरायली सान्ती लक रव्ह भाउ तुमी दुई लोक भाऊ-भाऊ सेव तुमी एक दुसरो लड़के आपरो आपला काहे नुकसान पहुचानो चाव्हासेव। ");
INSERT INTO pwr_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","पर वो मानूस जोन लड़त होतो मुसा ला धकाय के कहयो, तोला कोनना आमरो सासक अना अधिकारी बनाइसेस? ");
INSERT INTO pwr_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","काल तुमी न वोना मिसरी मानूस ला मार दियत का वोको जसो मोला भी मार डाकनो चाहाव सेव? ");
INSERT INTO pwr_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","मोसे ना जब यो आयकिस तो उ वहान लक पराय गयो अना मिधान देस मा परदेसी को रुप मा रव्हन लगीन वहान उनका दुई टूरा उत्पन भईन। ");
INSERT INTO pwr_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","चालीस बरस बितन को बाद सीनय पहाड को जवर जगल मा एक बरतो हुया झाड़ी को स्तो को बीच मा वोको पुड़ा एक सरगदूत दिसयो। ");
INSERT INTO pwr_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","यो चोयके मोसे भविस्यवक्ता अचंभा मा पड़ गयो, ता उ वोना झाड़ को जवर आयो, ता वोला पिरभू की या आवाज आइकू आई। ");
INSERT INTO pwr_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","मी तुमरो पुरखागिन को परमेस्वर सेव मजे अबराहम, इसहाक अना याकूब को परमेस्वर सेऊ। मोसे डर को मारे काँप उठयो अना देखन की हिम्मत नही जुटा पाइस। ");
INSERT INTO pwr_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","तबा पिरभू न वोको लक यो कहीस, पाय लक सेंडिल उतार अना जोन जघामा तू, उभो सेस वा पवीतर जघा से। ");
INSERT INTO pwr_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","मी न मिसर देस मा आपरो लोकगिन को सग होवनवारा अत्याचार साजरो लक देख-परख करिसेऊ। अर उनला रड़त आयकासेऊ, अना मी वोको सूटकारा करन उतरी सेव अना मी तोला मिसर देस धाडासू। ");
INSERT INTO pwr_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","यो वोच मोसे सेत, जोनला असो कहके नकारो गयो होतो तोला सासक अना अधिकारी कोन ना बनाइसेस? ये वोच से जोनला परमेस्वर न झाड़ी मा दरसन दियो होतो। वोचला परमेस्वर ना सासक अना मुक्ति देवन वालो को रुप मा धाडीस। ");
INSERT INTO pwr_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","उ उनला मिसर को धरती अना लाल सागर, अना जगंल मा चालीस बरस तकन अचँभा को काम करातो हुया अना निसान दिखावत बाहेर हेड़िस। ");
INSERT INTO pwr_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","यो उ मोसे भविस्यवक्ता से, जेना इसरायल गीन को सन्तान लक कहीस, परमेस्वर तुमरो भाऊ गीनमा लक तुमरो लाई मोरो जसो एक भविस्यवक्ता उभो करहेत। ");
INSERT INTO pwr_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","यो उ वोचसे जोन जगंल परदेस मा पुरखा गिन, अना वोना सरगदूत को संग मौजुद होतो, जेनना सीनय पहाड़ मा उनको लक गोस्टी करयो होतो। यो च ना अमीला देवन काजी परमेस्वर लक जित्तो बचन भेटयो होतो। ");
INSERT INTO pwr_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","पर आमरो सयना गीन न वोकी गोस्टी माननलाय मुकर कर देइन। इतरोच नही, उनना दिल लक मंग मिसर देस लवटनो चाहावत होतीन। ");
INSERT INTO pwr_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","उनना हारून लक कहीन, जोन अमीला रस्ता चोवाय असी आमरो लाय देवता बना, जोन हमरो पुड़ा-पुड़ा चलेत काहेकि हमी नही जानासेजन का वोना मोसे भविस्यवक्ता को का भयो जोना हमला मिसर देस लक हेडके आनी होतीस। ");
INSERT INTO pwr_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","वोना दिवस नाटा को मुरती बनाईस अना वोको पुड़ा चढ़ावा चघाईस अना अपरो हात की बनाई हुई मुरति लाई एक तिहार मनाईस। ");
INSERT INTO pwr_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","तबा परमेस्वर वोको लक तोन्ड मुरकेट लियो, अना उनला बादल को तारागिनला मानन लाय छोड़ देईस, जसो का पवीतर गिरंथ मा लिखीयो से, इसरायल लोक गीन का तुमी लोक गीन न जंगल परदेस मा चालीस बरस तकन मोला जानवर चढ़ावा अना अन्न चढ़ावा नही चघायो होतो? ");
INSERT INTO pwr_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","तुमी लोक ता मोलेक देवता को तम्बु को अना अपरो देवता रैफान को तारा अना उनना मुरती गीन को जिनला तुमरी पूजा लाई निमीत बनाईसेस अपरो भुजा पर उचालके ले गईस एको लाई मी तुमी लोक गीन को बेबीलोन को ओनागन हेड़ देहिन। ");
INSERT INTO pwr_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","सही मा निरजन परदेस मा हमरा सायना गीन को जवर गवाही को तम्बु होतो परमेस्वर न मोसे भविस्यवक्ता ला ऐको बिसय मा यो हुकूम देईस का येला बनाव। ");
INSERT INTO pwr_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","आमरो पुरखागिन ना वोला आन के तबच वहान लक आयो होतिन। तबा यहोसु को अगुवाई मा उन जाति गिन लक यो भूमी ले लियो होतो। जोनला आमरो आजा पुरखा को पूड़ा लक परमेस्वर ना हेड़ दीयो होतो। अना असोच दाऊद को बेरा तकन रहयो। ");
INSERT INTO pwr_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","दाऊद ना परमेस्वर को दया को मजा उठायो, वोको मरजी होतो का याकूब को लोकगिन लाय एक मंदिर बना सके। ");
INSERT INTO pwr_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","पर उ सुलेमान च होतो जोन वोको लाई एक मंदिर बनवायो। ");
INSERT INTO pwr_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“काही भी होय, सब लक मोठयो परमेस्वर हात लक बनायो घर मा नही रव्हसे। वा जसो की भविस्यवक्ता न सागिसेस।” ");
INSERT INTO pwr_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","“पिरभू कव्होसे सरग मोरो राजगद्दी से, अना धरती पाय की पायदान से।” कवन परकार को घर मोरो लाई बनावजोस? कही कोनी असो जघा नाहती, जहान मी बिसराम पाहिन? ");
INSERT INTO pwr_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","का या सबच चीज मोरो हात की बनाई नही? ");
INSERT INTO pwr_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","अना स्तिफनुस अवर कव्हसे, तुमी कितरो हटिलो लोक सेव, तुम आपरो दिल लक परमेस्वर को हुकूम नही मानसो, अना आयको भी नही। तुमी आपरो पुरखागिन को जसो तमिना हरामेसा पवितर आतमा को बिरोध कियो सेत। ");
INSERT INTO pwr_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","का कोनी असो भविस्यवक्ता या मानूस सेत, जोनला तुमरो पुरखा गिन ना नही तगांयो? अना उनना तो उनला भी मार डाख्यो, जोन ना परमेस्वर को नेक मानूस को आवन को मुनादि कियो होतो, अना वोना नक मानूस ला भी तुमी धरवा के मरवा डाखिसेव। ");
INSERT INTO pwr_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","तुमी वोच सेव, “जोनना सरगदूत गीन लक दियो गयो मोसे को नियम तो पाय लियो पर वोनो मा नही चलयो सेव।” ");
INSERT INTO pwr_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","जबा उनना एना गोस्टी ला आयकिन ता वय हिजड़ गईन, अना वोको पर दाँत पीसन लगीन। ");
INSERT INTO pwr_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","पर पवीतर आतमा लक पूरो भरके स्तिफनुस सरग कन चोवत रहयो, वोना चोवयो का परमेस्वर की महिमा ला अना परमेस्वर को उजो कन उभो यीसु ला। ");
INSERT INTO pwr_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","वोना कहीस आयको! मी चोवसू का सरग उघड़ो हुयो से अना मानूस को टूरा परमेस्वर को उज्जो कन उभो सेत। ");
INSERT INTO pwr_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","एको मघा बेमरातो हुया उनना कान बंद कर लेईन, अना सप्पा को सप्पा वोको पर झपटिन। ");
INSERT INTO pwr_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","वय वोला घसिट के नगर को बाहेर हेड़िन अना वोला गोटा मारन लगीन, तबच गवाह गिनना अपरा कपरा उतार के साऊल नाव को जुवान को पाय को जवर राख देईन। ");
INSERT INTO pwr_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","स्तिफनुस पर गोटा मारत रहिन अना वय यो कहेके पिराथना करता रहेयो “हे पिरभू यीसु मोरि आतमा ला ले-ले।” ");
INSERT INTO pwr_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","मंग टोगंरा टेके ऊँची आवाज लक हाकलीस हे पिरभू यो पाप उनको पर नोको लगावस “अना असो कहेके उ मर गयो।” ");
INSERT INTO pwr_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","असो परकार स्तिफनुस को मारो जावनो मा साऊल भी सामिल होतो। वोनो दिवस येरुसलेम सहेर को कलीसिया पर मोठो उपदरा होवन लग्यो। पेरीतगिनला सोड़ सबा बिस्वासी गिन यहुदिया अना सामरिया छेतर मा गाँव-गाँव मा तितर-बितर भय गईन। ");
INSERT INTO pwr_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","काही भक्त गीन ना स्तिफनुस ला मरघट्टी मा राखीन अना वोको लाई गजब रड़िन। ");
INSERT INTO pwr_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","साऊल कलीसिया ला मिटकाय रव्हो होतो, अना घर-घर धसके मरद माना गीन ला अना आई-माई ला घसीट घसीटकर जेल मा डाकन लगयो। ");
INSERT INTO pwr_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","जेव तितर-बितर भयो होतीन वय साजरो बारता आयकावत हिंडत होतीन। ");
INSERT INTO pwr_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","अना फिलिप्पुस सामरिया नगर मा जायके लोक गीन मा मसीह को साजरो बारता पिरचार लगयो। ");
INSERT INTO pwr_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","जबा फिलिप्पुस को गोस्टी ला लोकगीन न धियान धरके आयकिन, अना ओको अचरज को काम अना हिदान चोवयो, तबा वय एक चित भई के वोको काम मा धियान देइन। ");
INSERT INTO pwr_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","लगत सा लोकगिन जोन मा भूत-पलित झोमयो होतो, वय बेमरात-बेमरात बाहेर हिटीन। अना लगत सा लकवा को बिमार अना लगड़ा-लुला भी चंगा होत होतिन। ");
INSERT INTO pwr_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","अना वोना नगर मा मोठी खुसी छाय गई। ");
INSERT INTO pwr_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","वोच नगर मा समौन नाव को एक मानूस होतो। उ जादु-टोना करत होतो। अना सामरिया को लोकगिन ला चकित करत होत्यो। उ अपरो आप मा एक मोठो मानूस होवन को दावा करत होतो। ");
INSERT INTO pwr_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","नहानो लक मोठो तकन सबच वोको गोस्टी पर धियान देवत होतिन। अना कव्हत होतीन, यो मानूस मा परमेस्वर को वोच सक्ती सेत। जोन महान कहेलावसे। ");
INSERT INTO pwr_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","काहेका वोना लगत दिवस लक उनला अपरी चमत्कार को चक्कर मा उलझायो राखयो होतो। एको लाई वय वोको पर धियान देवत होतिन। ");
INSERT INTO pwr_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","पर उनना फिलिप्पुस पर बिस्वास करीन। काहेकि वोना उनला, परमेस्वर को राज को साजरो बारता अना यीसु मसीह को नाव आयकावत होतो, ता वय मरदमाना अना, आई-माई दुई बप्तिस्मा लेवन लगीन। ");
INSERT INTO pwr_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","अना खुद समौन न भी भरोसा करीस। अना बप्तिस्मा लेवन को मघा फिलिप्पुस को संग करिब लक रव्हन लग्यो। उ मोठो हिदान अना अचरज भरो काम चोव के उ दंग भई गयो। ");
INSERT INTO pwr_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","उतानी येरुसलेम सहेर मा जबा पेरीतगिन असो आयकीन का सामरिया को लोकगिन न परमेस्वर को गोस्टी मान लेईन। ता उनना पतरस अना योहन ला वोको जवर धाडीन। ");
INSERT INTO pwr_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","जब वय समरिया पहुचिन ता उनना नहान को लोक गिन लाय पिराथना करीन का उनला पवीतर आतमा भेटे। ");
INSERT INTO pwr_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","काहेकी वय अबा तकन उनमा लक कोनी पर नही उतरयो होतो, उनना ता केवल पिरभू यीसु को नाव मा बप्तिस्मा लेईस होतीन। ");
INSERT INTO pwr_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","तबा उनना उनको पर हात राखीन अना पवीतर आतमा पाइन। ");
INSERT INTO pwr_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","जबा समौन न देखीस का चेलागीन को हात राखन लक पवीतर आतमा भेटासे, ता उ उनको जवर रुपया आनके कहीस। ");
INSERT INTO pwr_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","यो सक्ती मोला भी देव, ताकि जेनो कोनी पर हात राखु वोला पवीतर आतमा भेटे। ");
INSERT INTO pwr_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","पतरस न वोको लक कहीस, तोरा रुपया तोरो संग सत्यानास भई जाय, काहेका तु न यो सोचयो, का तू धन लक परमेस्वर को दान ला खरीद सकसेत। ");
INSERT INTO pwr_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","यो दान मा न तोरो हिस्सा सेत न कोनी सांझ-मांझ सेत। काहेकी तोरो बिचार परमेस्वर को पुड़ा सरको नाहती। ");
INSERT INTO pwr_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","एकोलाई तु अपरी ऐना खोटो बिचार लक मन मुरका पिरभू लक पिराथना कर। हो सका सेत तोरो वा बिचार को लाय छिमा करयो जाहे। ");
INSERT INTO pwr_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","काहेकी मी देखासू का तू पाप को बेड़ी मा जकड़ो हुया सेत। अना तोरो मन पित जसो कडू बीक सेत। ");
INSERT INTO pwr_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","समौन, पतरस अना योहन ला जवाब देईस “तुमी मोरो लाई पिरभू लक पिराथना करो का जोन गोस्टी तुमी न कहयो, उनमा लक कोनी गोस्टी मोरो पर ना घटे।” ");
INSERT INTO pwr_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","मंग पेरीतगिन आपरो गवाही देयके, अना पिरभू को गोस्टी आयकावाय के रस्ता की सामरी गाँवगिन मा साजरो बारता आयकावाता हुया चेताय के येरुसलेम को लवट के गईन। ");
INSERT INTO pwr_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","पिरभू को एक सरगदूत न फिलिप्पुस ला कहीस “तैयार होय अना दक्सिन को रास्ता पर जाय जोन लक येरुसलेम लक गाजा मा जासे।” या एक सुनसान रास्ता से। ");
INSERT INTO pwr_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","उ तैयार भयो अना चलन लगयो। वहाच एक कुस देस को खोजा होतो। उ कुस देस को रानी कन्दाके बाई को खाजाना को खाजांची होतो उ पिराथना करन को लाय यरुसलेम गयो होतो। ");
INSERT INTO pwr_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","उ अबा लवट रहेयो होतो। उ अपरो रथ मा बसयो, भविस्यवक्ता यसायाह को गीरंथ वाचत होत्यो। ");
INSERT INTO pwr_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","तबच फिलिप्पुस ला आतमा लक असो लगयो, “वोना जवर जाय अना वहाच ठहर” ");
INSERT INTO pwr_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","फिलिप्पुस वोना खोजा को जवर परायके पहुचयो अना वोला पुसयो जोन भविस्यवक्ता यसायाह को गीरंथ ला वाचसे वोला तु का समझसे? ");
INSERT INTO pwr_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","अधिकारी न जवाब देईस, मोला जबा तकन कोनी नही समझाय कसो समझ सकासू? वोना फिलिप्पुस लक बिनती करीस का वय रथ पर चघके वोको संग बस जाहे। ");
INSERT INTO pwr_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","गिरंथ की जोन हिस्सा ला वा बाच रव्हो होतो उ यो होतो। वोला बली होवन वालो मेंढा को जसो लीजाय रहयो होतिन। वा तो वोना पाठी को जसो उगो-मुगो होतो, जोन आपरो ऊन कापन वालो को पुड़ा रव्हसे। ठीक वसोच ही वोना अपरो टोन्ड नही खोलीस। ");
INSERT INTO pwr_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","वोकी दसा गरीब गोर को जसी होती वोको नियाव नही करियो गयो वोकी चरचा कोन करेहत? काहेका धरती लक वोको जिंदगानी हर लियो गयो। ");
INSERT INTO pwr_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","तबा खोजे न गींरथ वोना हिस्सा ला हेडके फिलिप्पुस लक पुसीस अब अता मोला सांग यो गोस्टी भविस्यवक्ता कोन को बारे मा कव्हसेत, खुद को बारे मा का कोनी दुसरो को बारे मा? ");
INSERT INTO pwr_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","तबा फिलिप्पुस न कव्हनो चालू करीस अना पवितर गिरंथ की एना कथा को आधार बनायके वोला यीसु को साजरो बारता आयकावाइस। ");
INSERT INTO pwr_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","वय रास्ता मा जता-जता पानी जवर पहुचीन खोजे न कहीस यो पानी से अबा मोरो बप्तिस्मा मा का रुकावट से? ");
INSERT INTO pwr_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","फिलिप न उतर देईस अदि तुमी पूरो आतमा लक बिस्वास करसेव ता कोनी रुकावट नही ऐको पर वोना कहीस मी बिस्वास करासेऊ का यीसु मसीह परमेस्वर को टूरा से। ");
INSERT INTO pwr_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","तबा वोना रथ रोखन को हुकूम देईस तबा फिलिप्पुस अना खोजा दुई पानी मा उतरीन अना फिलिप्पुस न वोला बप्तिस्मा देईस। ");
INSERT INTO pwr_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","जबा वय पानी लक बाहेर हिटीन त फिलिप्पुस ला पिरभू को आतमा कोनी जगह उचल लेगयो अना वोना खोजे न वोला मंग नही देखीस, अना उतानी खुसी को संग अपरो रास्ता पर चलीगयो। ");
INSERT INTO pwr_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","इतानी फिलिप्पुस न अपरो आपला सदोद नगर मा पाईस। अना जबा तकन वय कैसरिया पहुचियो तब तकन सबच नगरगीन मा साजरो बारता को पीरचार करत-करत यातरा करत होत्यो। ");
INSERT INTO pwr_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","साऊल अबा तकन पिरभू का चेला गीन ला मार डाकनो की धामकी देवत होतो, उ महान याजक को जवर जायके, ");
INSERT INTO pwr_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","दमिस्क नगर की सभाघर गिन को नाव मा अधिकार पतर मांगीस जोन को अनुसार मा यदी कोनी यो मारग वालो भेटेत, चाहे वय मरदमाना होय अना आई-माई होय ला बांधके येरुसलेम नगर मा आनो। ");
INSERT INTO pwr_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","जबा साऊल अना वोको संगी यातरा करत-करत दमिस्क नगर को जवर आइन, ता एकाएक बादर लक एक उजोडो चारीकन लक चमकयो। ");
INSERT INTO pwr_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","वा जमीन मा पड़ गयो, अना वोना एक आवाज आयकू आई कोनी वोला कव्ह रव्हयो होत्यो। “साऊल, साऊल तु मोला काय लाई सतावासेस?” ");
INSERT INTO pwr_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","साउल ना कहीस, “पिरभू तुमी कोन आव?” जवाब मिलयो “मी यीसु सेव मोला तु काय लाई तगावसे। ");
INSERT INTO pwr_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","उभो होय अना सहेर मा जाय तोला जेव करनो से उ तोला सांगयो जाहे।” ");
INSERT INTO pwr_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","वोको संग यातरा करन वारा अवाक रह गईन काहेकी उनना आवाज ता आईकिन पर उनला कोनी नही चोयो। ");
INSERT INTO pwr_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","साऊल जमीन लक उभो भयो अना वोको डोरा उघड़ गयो पर वोला काही नही चोवत होतो, एकोलाई वय वोका हात धरके वोला दमिस्क सहेर ले गईन। ");
INSERT INTO pwr_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","उ तीन दिवस तकन अँधरा रहेयो, अना वोना काही जेवन नही करयो। ");
INSERT INTO pwr_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","दमिस्क नगर मा हनन्याह नाव को एक बिस्वासी रव्हत होतो, पिरभू न वोला दरसन देयके कहीस, हनन्याह! वोना उतर देईस “हव पिरभू” ");
INSERT INTO pwr_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","पिरभू न वोला कहीस, अबा तू सिद्दो नाव को गल्ली मा जाय अना पता लगा, वहान यहूदा को घर मा तरतुस नगर को रव्हन वारा, साऊल नाव को एक मानूस यो बेरा पिराथना करासेत। ");
INSERT INTO pwr_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","अना वोना दरसन मा चोविसेत का हनन्याह नाव को मानूस वोकोजवर आयके वोको वरता हात राख रहयो सेत, मंग उ चोवन लगयो। ");
INSERT INTO pwr_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","हनन्याह न जवाब देईस हे पिरभू मी न एना मानूस को बारेमा मा लगत सा बुराई आयकिसेऊ, एना तोरो पवितर लोक गिनला येरुसलेम नगर मा कितरो तगाइसेत। ");
INSERT INTO pwr_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","अना योभी का मुखिया याजक लक तोरो नाव मा सबच बिस्वास करन वालो लोक गिनला बंदी बनान को अधिकार लेके आइसेत। ");
INSERT INTO pwr_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","पर पिरभू न वोला कहीस तु जाय, काहेकि यो मानूस ला गैरयहुदी अना राजागीन अखीन इसरायल गीनको पुड़ा मोरो नाव लेवन काजी मीना एला बेची सेऊ। ");
INSERT INTO pwr_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","अना मी खुदच वोला सांगू। का मोरो नाव को लाय वोला कितरो दुख उचलनो पड़हेत। ");
INSERT INTO pwr_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","तबा हनन्याह उभो होय के घर मा गयो, जहान साऊल होतो, अना भितर जायके अना साऊल पर अपरो हात रखके कहीस, अरे भाऊ साऊल जोन पिरभू यीसु ना यहान आवत बेरा, तोला रस्ता मा दरसन दियो होतो, वोनच मोला धाडीसेस, का तु दुबारा चोवन लगे, अना तू पवीतर आतमा लक पूरो भर जाय। ");
INSERT INTO pwr_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","तबा वोच बेरा साऊल को डोरा लक कचरा जसो काही गिरयो, अना उ मंग देखन लगयो। मंग उचलके ओना बप्तिस्मा लेईस। ");
INSERT INTO pwr_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","मंग जेवन करके ओना ताकत पाईस। मंगा उ कई दिवस तकन दमिस्क को बिस्वासी व गीन को संग रहेयो। ");
INSERT INTO pwr_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","अना उ तुरन्त सभाघर मा यीसु को परचार करन लगयो, का उ परमेस्वर को टूरा से। ");
INSERT INTO pwr_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","सबच आयकन वारा चकित भयि गइन, अना कव्हन लगीन का यो उ मानूस निहोय जोन बिस्वासी गिनला बंदी बनाकै येरुसलेम सहेर मोठयो याजक को जवर ले जान लाय आयो होतो? अना येरुसलेम मा भी बिस्वासी गिनला लगत तगाइसेस। ");
INSERT INTO pwr_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","पर साऊल परचार मा अखिन ताकतवर होतो गयो। अना यीसु च मसीह से ऐना गोस्टी की सबुत देयके वोना दमिस्क सहेर को यहूदी गिनला उघो मुघो कर देइस। ");
INSERT INTO pwr_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","लगत दिवस बितन को मघा, यहुदीगिन वोला जान लक मारन को पिलान करीन। ");
INSERT INTO pwr_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","यो गोस्टी को साऊल ला पता चल गयो, का सहेर को बेसकुड़ मा लोकगिन मोला मारन को रात दिवस ताक मा सेत। ");
INSERT INTO pwr_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","तबा बिस्वासी गिनना रात मा साऊल ला डलिया मा बसाय के सहेर को दिवाल को वोनागन उतार देइन। ");
INSERT INTO pwr_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","जबा साऊल येरुसलेम पहुचीस, ता वोना चेला गीन को समूह मा मिलन को जानो को कोसिस कियो। पर वय सबच वोको लक डरात होतीन। काहेकी उनला यो भरोसा नही होतो का उ सहीमा बिस्वासी बन गयो सेत। ");
INSERT INTO pwr_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","तबा बरनबास वोला चेलागीन को जवर ले गयो। अना सागीस का साऊल न रास्ता मा कसो पिरकार लक पिरभू को दरसन करीस, अना पिरभू न गोस्टी करीस। बरनबास न उनला यो भी सांगीस का कसो पिरकर साऊल ना दमिस्क नगर मा बेधड़क यीसु को पिरचार करीस। ");
INSERT INTO pwr_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","ऐको बाद साऊल येरुसलेम मा प्रेरिगीन को संग आवन-जावन लगीस, अना बेधड़क पिरभू यीसु को नाव को बारे मा सागन लग्यो। ");
INSERT INTO pwr_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","उ यूनानी भासा बोलनवारा यहूदि गीन लक गोस्टी अना बहस करत होतीन, पर वय लोक उनला मार डाकनो चाहव्त होतिन। ");
INSERT INTO pwr_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","जबा बिस्वासी भाऊ बहिन गीन को ऐको पता चलयो ता वय साऊल कैसरिया जहाज घाट ले गईन। अना वहान लक तरसुस नगर ला भेज देइन। ");
INSERT INTO pwr_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","असो परकार अबा सबरी यहुदिया गलील अना सामरिया छैत्र गीन को कलीसिया को बेरा सान्ती लक डर मा बितन लगयो। अना कलीसिया अखीन बनन लग्यो। अना पवीतर आतमा को बड़ावा मा जिंदगी बीतावन लगीन। अना कलिसिया गिनतीमा बड़न लगयो। ");
INSERT INTO pwr_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","पतरस हर जगह हिंडता हुयो, एक दिवस लुद्दा नगर मा रव्हन वारा बिस्वासी गिनको यहान पहुचयो। ");
INSERT INTO pwr_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","वहान वोला एनियास नाव को लकवा को रोगी एक मानूस मिल्यो। जोन 8 साल लक खाट मा पडयो होतो। ");
INSERT INTO pwr_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","पतरस न वोला कहेयो “वो एनियास यीसु मसीह तोला साजरो करासे उठ अपरो बिछोना उचल।” तबा उ गदने उभो भयो। ");
INSERT INTO pwr_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","तबा लुद्दा अना सारोन को सबच रव्हन वारा वोला चोयके पिरभू कन मुरकिन। ");
INSERT INTO pwr_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","याफा नगर मा तबिता नाव को चेली रव्हत होति। जोनको यूनानी अनुवाद दोरकास मजे हिरनी सेत। वा हरामेसा आपरो बेरा साजरो काम अना दान धरम मा बितावत होती। ");
INSERT INTO pwr_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","वोना बेरामा वा बिमार भई अना मर गई। उनना वोला आग खोराके वरता पाटन मा राख देईन। ");
INSERT INTO pwr_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","लुद्दा नगर याफा सहेर को जवर सेत। चेलागीन ला पता चलयो का पतरस वहान से। तब वय दुई मानूस ला धाडके वोको लक बिनती करीन, की तु गदने यहान आव। ");
INSERT INTO pwr_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","तबा पतरस वोच बेरा उनको संग चले गयो। जबा उ याफा नगर पहुचयो तबा लोकगीन वोला वरता पाटन पर ले गईन। उता सबा बेवागिन रड़त-रड़त आखा-पाखा आयके उभो भईन, अना जोन कुरता अना कपरा दोरकास ना उनको संग बनाई होति, वोला दिखावन लगीन। ");
INSERT INTO pwr_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","पतरस ना सबला बाहेर काढ दियो। अखीन टोघरा टेकके पिराथना करन लगयो, अना एको मघा उ ओको लास कन मुरकके कहीस “तबिता उठ” अना वा डोरा उघाड देइस, अना पतरस ला चोवके जाग के बस गई। ");
INSERT INTO pwr_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","पतरस ना हात धरके वोला उठायो, अना पवीतर लोक गीन अखीन बेवागिन ला हाकलके ओला जित्तो होवनो पर होस मा पुड़ा कर दियो। ");
INSERT INTO pwr_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","याफा नगर मा यो गोस्टी फैल गई। अना गजब लोकगीन पिरभू यीसु को नाव पर भरोसा करीन। ");
INSERT INTO pwr_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","पतरस याफा नगर मा एक चमड़ा को काम करनवारा मानूस को घरमा रहयो। वोको नाव समौन होतो। ");
INSERT INTO pwr_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","कैसरिया मा कुरनेलियुस नाव को एक मानूस होतो। उ रोमन सौ सेना को नायक होतो। ");
INSERT INTO pwr_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","अना वोका सबरी परिवार समेत, उ नेक आदमी अना परमेस्वर का भगत होतो। अना वय यहुदी गरीब लोकगीन ला लगत दान देत होत्यो। अना हरामेसा परमेस्वर की पिराथना मा लग्यो रव्हत होत्यो। ");
INSERT INTO pwr_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","वोना एक दिवस दुफारी को लकभग 3 बजे दरसन मा यो सफा-सफा चोयो का परमेस्वर को सरगदूत वोको जवर आयके कहीस “कुरनेलियुस।” ");
INSERT INTO pwr_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","कुरनेलियुस डरात हुयो सरगदुत को कना चोवतो बोलीस “ओय! पिरभू का से?” सरग दूत न जवाब देईस अपरी पिराथना अना अपरो दान परमेस्वर को पुड़ा पहुच गयो से; अना वोना तोरो हेत करिसेत। ");
INSERT INTO pwr_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","तु अबा काही आदमी ला याफा नगर मा धाड़। अना समौन नाव को एक मानूस जो पतरस भी कहलावासे। वोला हाकल! ");
INSERT INTO pwr_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","उ समौन, चमड़ा को काम करनवारा को घर मा पाहुना से जेनको घर सागर को कगरमा से। ");
INSERT INTO pwr_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","जबा उ सरगदूत, वोको लक गोस्टी कर रहयो होत्यो चली गयो। ता करनेलियुस न दुई दासगीन अना एक नेक सैनिक ला हाकलीस। ");
INSERT INTO pwr_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","अना उनना सबच गोस्टी समझायके याफा नगर धाडिस। ");
INSERT INTO pwr_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","दुसरो दिवस जबा वय यातरा करत-करत नगर को जवर पहुचीन। ता दुफारी को बेरा जवर पतरस अटारी पर पिराथना करन चघयो। ");
INSERT INTO pwr_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","तबच वोला भुख लगी अना काही जेवनो को मनसा होतो। उतानी सयपाक बन रहयो होतो। अना पतरस अचेत भय गयो। ");
INSERT INTO pwr_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","अना पतरस आतमा लक दरसन देखीस का बादर खुल गई से, अना एक बरतन मोठयो चद्दर को जसो चारी कोन्टो लक लटकतो हुयो धरती कन उतर रव्हयो से। ");
INSERT INTO pwr_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","जोनमा धरती का सबच पिरकार को चौपाए अना रेंगने वारा सरप डेडूर वारा जीव जन्तु अना बादर का पक्सी होतीन। ");
INSERT INTO pwr_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","वोला एक असो आवाज आयकू देइस, हे पतरस उठ अना इन ला मारके अना खाय। ");
INSERT INTO pwr_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","पर पतरस न कहीस पिरभू पक्को नही। काहेकि मी ना कोनी असुध्द चीज नही खाई सेउ। ");
INSERT INTO pwr_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","मंग दुसरी बार वोला आवाज आयकू देईस, जोन कोनी परमेस्वर न पवीतर राखीसेस वोला तू असुध्द नोको कव्हजोस। ");
INSERT INTO pwr_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","तीन बेरा असो भयो एको बाद उ चदर एकाएक बादर पर उचल लियो गयो। ");
INSERT INTO pwr_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","जबा पतरस अपरो मन मा दुविधा मा होत्यो, का यो दरसन जोन मी न देखीसेऊ, उ का होय सकासे? ता चोवो! उ मानूस जेनला कुरनेलियुस न धाड़ियो होतो, समौन को घर को पता लगायके बेसकुड़ मा उभो भइन। ");
INSERT INTO pwr_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","अना हाकलके पुसन लग्यो, का‍ समौन जोन पतरस कहलावसे, एनागन पाहुना से? ");
INSERT INTO pwr_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","पतरस ता वोनो दरसन मा बिचारत होत्यो का आतमा न वोला कहीस, देख 3 मानूस तोरी खोज मा सेत। ");
INSERT INTO pwr_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","चेत अना खाल्या जाय! अना बेखटका उनको संग जाय। काहेकी मीनच उनला धाडीसेऊ। ");
INSERT INTO pwr_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","तबा पतरस न उतरके वय मानूस गीन लक कहीस, आयको जोन को खोज मा तुमी सेऊ, उ मी आँव, अता तुमरो आवन को कारन सांगो? ");
INSERT INTO pwr_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","उनना कहिन सौ सेना दल को नायक करनेलियुस जोन परमेस्वर ला मानासेत उ एक नेक मानूस से। अना सबच यहुदी गिन वोको आदर करासेत। वोना एक पवीतर सरगदूत लक यो हुकूम पाईसेस, का तोला अपरो घर बुलायके तोरो लक गोस्टी आयके। ");
INSERT INTO pwr_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","तबा पतरस उनला भितर हाकलिस रात मा ठहरनो को जघा दियो। अना रात बिताइस अना आवनो वालो दिवस मा तैयार भयके उ उनको संगा चली गयो। अना काही बिस्वासी याफा लक ओको संगा गयीन। ");
INSERT INTO pwr_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","वय दुसरो दिवस कैसरिया पहुचिन, करनेलियुस आपरो घराना अना रिस्तेदार समेत उनको रस्ता चोय रहयो होतो। ");
INSERT INTO pwr_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","जबा पतरस अंदर आय रव्हो होतो ता कुरनेलियुस न उनको लक मिल्यो वोको पाय पड़िस। ");
INSERT INTO pwr_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","पर पतरस न वोला उठायके कहीस “उभो होय मी भी ता मानूस सेव।” ");
INSERT INTO pwr_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","अना वोको संग गोस्टी करतो हुयो अंदर गयो, अना लगत सा लोक गीन ला इक्कठो पाय के। ");
INSERT INTO pwr_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","वोना कहीस, तुमी जानासेव का गैरयहुदी की संगति करनो अना उनको घरमा जावनो एक यहुदी लाय मनायी सेत। पर परमेस्वर न मोला कहिसेस, का कोनी मानूस को अपवितर या असुध्द नही कव्हनो चहिये। ");
INSERT INTO pwr_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","एको लाई मी, तुमरो नेवता पर आईसेऊ। अबा मी तुमरो लक पुसा सेऊ? तुमिना काहे बुलाई सेव? ");
INSERT INTO pwr_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","कुरनेलियुस न कहीस, चार दिवस पयले योच बेरा मा अपरो घर मा 3 बजे को पिराथना कर रहयो होतो। तबा मी चकमक झंगा घाल्यो एक मानूस ला मोरो पुड़ा उभो चोवयो। ");
INSERT INTO pwr_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","अना उ मोला कव्हन लग्यो हे कुरनेलियुस तोरी पिराथना आयक ली गईसे अना दुखी गरिब ला दियो दान परमेस्वर को पुड़ा हेत कियो गयोसेत। ");
INSERT INTO pwr_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","एकोलाई कोनी ला याफा नगर धाडके समौन जोन पतरस कहलावसे हाकल, उ समुदर को जवर समौन चमड़ा को काम करनवारा को घर मा पाहुना सेत। ");
INSERT INTO pwr_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","तबा मि गदने तोरो जवर लोकगीन ला धाडयो अना तु यहान आवन को किरपा करके न साजरो करीसेस। ता अबा परमेस्वर ना जोन कही हुकूम दियो सेत अमीला सांग, वोना सारो गोस्टी आयकन काजी अमी सब यहान सेत। ");
INSERT INTO pwr_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","तबा पतरस न कहीस, अबा मोला यो खराई लक मालुम भयो का, परमेस्वर कोनी मानूस को पक्स नही करासे। ");
INSERT INTO pwr_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","हरेक मानूस कोनी भी जात को सेत, जोन परमेस्वर को भेव करासेत, अना नेक काम करासेत, परमेस्वर वोला अपनावसे। ");
INSERT INTO pwr_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","यीसु मसीहा को लक धाड़यो गयो सान्ती को खबर ला तुम्ही जानासेव। जोन साजरा बारता को मुनादी करतो हुया इजराइल को लोक गिनला आयकवायो होतो का उ सबको परमेस्वर सेत। ");
INSERT INTO pwr_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","तुमी वोना महान घटना ला जानासेव, जोन यहुदिया मा घटो होतो, यो गलील लक सुरु भयो, अना योहन लक बप्तिस्मा दियो जावनो को मघा ले जोनको पिरचार कियो वयो होतो। ");
INSERT INTO pwr_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","तुमी नासरत को यीसु ला जानासेव, का परमेस्वर ना निवाड़ी सेत अखिन ओला पवीतर आतमा अना ताकत देइस। अना उ साजरो काम करतो हुया, अना जोन सैतान को बन्धन मा होतिन उनला सोड़ाय के सब रोग ला साजरा करत हिंडत होतो अना परमेस्वर वोको संग होतो। ");
INSERT INTO pwr_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","हमी सबच ओनो गोस्टीहुन को गवाह सेजन। जोन काम ओना यहूदी को देस अना येरुसलेम मा कियोसेस, अना वोच नासरत नगर को यीसु ला उनना कूरूस पर टँगाय के मार डाकीसेत। ");
INSERT INTO pwr_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","ओच यीसुला परमेस्वर ना तीसरो दिवस मरयो मा लक जित्तो करीस। अना वोला अमी चोवयो सेजन। ");
INSERT INTO pwr_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","सबच लोकगीन को पुड़ा नही, पर बस उन गवाह को पुड़ा जोनला परमेस्वर ना पयले लक बेच लेई होतो। मजे आमरो पुड़ा अ जिनना मरयो हुयो मा ओको जित्तो होवन को मंघा ओको सँग पियो अना जेवन कियो। ");
INSERT INTO pwr_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","वोनच अमिला हुकूम देईस, की लोकगीन मा साजरा बारता आयकावायके सबुत देयजन का यो वोच से जेनला परमेस्वर ना जित्तो होवनो अना मरयो हुयो को न्याय करन वालो ठैयरायो सेत। ");
INSERT INTO pwr_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","सबच भविस्यवक्ता गीन वोको गवाही देई सेत, का वोको पर भरोसा करन वारा हरेक मानूस, वोको नाव लक पाप की छिमा पावा सेत। ");
INSERT INTO pwr_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","पतरस एना गोस्टी ला कहेच रहेयो होतो, का पवीतर आतमा गोस्टी को सबच आयकन वारा पर उतर आयो। ");
INSERT INTO pwr_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","पवितर आतमा को बरदान गैर यहुदी पर उतरता चोव के पतरस को सग आयो यहुदी गिन चकित भई गइन। ");
INSERT INTO pwr_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","काहेकी उनला किसम-किसम बोली बोलता अना परमेस्वर की महिमा बडाई करता आयकिन। एको पर पतरस न कहीस, ");
INSERT INTO pwr_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“का कोनी इन लोखहुन ला पानी ला रोक सकसे, का यो बप्तिस्मा न पाहे?” जिनला हमरो जसो पवितर आतमा भेटयो सेत? ");
INSERT INTO pwr_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","असो परकार लक पतरस ना उनला हुकूम देईस, का वय पानी मा यीसु मसीह को नाव लक बपतिस्मा लेय। तबा उनना वोको लक कहिन, अवर काही दिवस आमरो संग रव्ह। ");
INSERT INTO pwr_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","पुरो यहुदिया मा पेरीतगिन अना बिस्वासि गिनला मालुम भयो का गैर यहुदीगिन ना परमेस्वर को बचन मान लियो सेत। ");
INSERT INTO pwr_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","ता जबा पतरस येरुसलेम पहुचयो ता जोन बिस्वासी खतना को पक्समा होतिन, वोला बुरो कव्हन लगीन। ");
INSERT INTO pwr_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","वय कव्हन लगीन “का तू गैर यहुदी को घरमा गयो अना तू ना उनको संग जेवन करीसेस।” ");
INSERT INTO pwr_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","एतरो पर पतरस ना सहीमा सुरुवात लक जोन काही घटयो होतो उनला आयकुवान अना समझान लगयो। ");
INSERT INTO pwr_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","का मी याफा नगर मा पिराथना करत होतो। अना बेसुद होयके असो दरसन चोविसेऊ का एक मोठयो चद्दर को जसो एक भांडो होती अना उ चारो छोर लक लटको भूईमा आयी। ");
INSERT INTO pwr_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","मी ना वोला साजरा लक चोवयो, वोमा धरती को चार पाय वारा जनावर, अना रेंगन वारा जीव, अना उड़न वारा सब पक्सी चोइस। ");
INSERT INTO pwr_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","अना असो अवाज आयो, ओ पतरस! उठ अना मार, अखीन जेव। ");
INSERT INTO pwr_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","पर मीना कव्हयो: पिरभू सहि मा पक्को नही काहेकि मी बेकार अना असुध्द जेवन को चीज मोरो टोंड मा कबच नही डाकयो। ");
INSERT INTO pwr_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","एको जवाब मा दुसरी वानी मंग बादर मा लक आयकु आई। परमेस्वर ना जोन चीज ला मी सुध्द पवीतर ठहराई सेउ वोला तू असुध्द नोको कव्ह। ");
INSERT INTO pwr_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","तीन बेरा असोच भयो मंग सबच चीज सरग बादर मा वरता खीच लेईन। ");
INSERT INTO pwr_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","यो याफा को तीन भाऊ मोरो संगा कैसरिया तकन साथमा होतीन। जोन घर मा हमी ठहराया होता। ");
INSERT INTO pwr_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","तबा पवीतर आतमा न मोला उनको संग बिना-संका लक जावन लाई कहीस, अना ये छह भाऊ भी मोरो संग भय गईन, अना हमी वोना मानूस को घर गया। ");
INSERT INTO pwr_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","वोना हमला सागीस का वोना एक सरगदूत ला अपरो घर मा उभो देखीस जेना वोला कहीस याफा मा मानूस ला धाडके समौन को जोन पतरस कहेलावासे हाकल लेव। ");
INSERT INTO pwr_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","उ तुमरो लक या गोस्टी कहे, का जोको लक तु अना तोरो सप्पा खानदान सूटकारा पाय जाहे। ");
INSERT INTO pwr_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","जबा मी गोस्टी करन लग्यो ता पवीतर आतमा उनको पर वोनच रीती लक उतरयो, जेना रीती लक सुरु मा हमरो पर उतरी होती। ");
INSERT INTO pwr_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","तबा मोला पिरभू को उ गोस्टी आयकू आयो जोन वोना कही होतीस। योहन ना ता पानी लक बप्तिस्मा देयो होतो, पर तुमी पवीतर आतमा लक बप्तिस्मा पाहो। ");
INSERT INTO pwr_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","जबा परमेस्वर न उनला भी उ दान देईस जोन हमीला पिरभू यीसु मसीह पर भरोसा करन लक मिलयो होतो ता मी कोन होतो जोन परमेस्वर ला रोक सकासेव? ");
INSERT INTO pwr_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","यो आयक के उगा-मुगा रहीन अना परमेस्वर की बड़ाई करके कव्हन लगीइन “तबा ता परमेस्वर न गैरयहुदी लोकगीन को जीवन को लाई मन को पस्तावा को दान देईसेस।” ");
INSERT INTO pwr_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","स्तिफनुस को कारन लक कलीसिया को लोकगीन ला सब लोकगीन गजब तंग करन लगीन। यो दुख को मार लक कलीसिया को लोकगीन इता-उता पराय गइन। अना हिंडत-हिंडत फीनीके अना साइप्रस अखीन अन्ताकिया नगर मा गइन, पर यहूदी लोकगीन ला छोड़ अना कोनी ला साजरा बारता नही आयकु आई होतिन। ");
INSERT INTO pwr_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","पर उनमा लक कितरो साइप्रस को रव्होन वारा गैरयहूदी अखीन कुरेनी को बिस्वासी होतिन। जोन अन्ताकिया नगर मा आयके पिरभू यीसु को साजरो बारता आयकु आय लगीन। ");
INSERT INTO pwr_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","अना पिरभू को ताकत उनको वरता होती। अखीन गजब लोक गीन भरोसा करके पिरभू को मानन वारा बन गईन। ");
INSERT INTO pwr_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","तबा उनको चरचा येरुसलेम नगर को कलीसिया मा आयकु आयी, अना उनना बरनबास ला अन्ताकिया नगर धाडीन। ");
INSERT INTO pwr_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","उ उता जायके अना परमेस्वर को दया चोवके खुसी लक भर गयो; अना सबला सिक्सा देइस, का देह-मन लक पिरभू लक लिपटो अना बिनती करत रव्हो। ");
INSERT INTO pwr_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","कायका उ साजरो मानूस होतो, अना पवीतर आतमा अखीन भरोसा मा “लबा लब भरो होतो।” अना दुसरो लगत सा लोकगीन पिरभू मा मिल गईन। ");
INSERT INTO pwr_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","तबा उ साऊल ला ढुढन को लाय तरसुस नगर ला चले गईस। ");
INSERT INTO pwr_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","अना जबा उ वोको लक मिल्यो, तो वोला अन्ताकिया नगर आनीस। अना वय एक साल लक किराया को खोली मा कलीसिया को सँग मिलतो जुलतो अखीन गजब लोकगीन ला सिक्सा देवत रहयो। अना चेला गीन सब लक पयले अन्ताकिया नगर मा मसीह कहलाइन। ");
INSERT INTO pwr_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","वोना दिवस मा लगत भविस्यवक्ता गीन येरुसलेम नगर लक अन्ताकिया नगर आइन। ");
INSERT INTO pwr_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","उनमा लक अगबुस नाव को एक ना उभो होयके पवितर आतमा को डाख्यो गयो बिचार को अनुसार कव्हन लग्यो का सारो जगत मा गजब गिरानी पडहेत। उ गिरानी राजा क्लौदियुस को बेरा मा पडयो होतो। ");
INSERT INTO pwr_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","तबा चेला गीन ना बिचार करीन का हरेक आपरो पूंजी को लक यहुदिया को भाऊ गीन को सेवा लाई काही धाडे। ");
INSERT INTO pwr_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","अना उनना असोच करीन; अखीन बरनबास अना साऊल को हात मोठो पुरनियो को जवर काही पैसा धाड देइन। ");
INSERT INTO pwr_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","एना बेरा राजा हेरोदेस न कलीसिया का काही मानूस गीन ला परेसान करन लाई उनको पर हात डाकिन। ");
INSERT INTO pwr_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","उनना योहन को भाऊ याकूब की तलवार लक मारवय डाकिन। ");
INSERT INTO pwr_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","जबा वोना देखीस का यहूदी ऐना गोस्टी लक खुसी भयो, ता वोना पतरस ला भी धरनो को सोचीस। यो सादो भाकर को तिहार होत्यो। ");
INSERT INTO pwr_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","अना वोला धरके जेल मा डाक देईन, अना चार-चार सिपाई गीन को चार दल को पहरा मा एकोलाय राखीन का बलिदान तिहार को मंग, वोला बाहेर लोक गीन को पुढ़ा आनेत। ");
INSERT INTO pwr_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","पतरस ला जेल मा बेंड देईन पर कलीसिया वोको लाई परमेस्वर लक लवलीन भयके पिराथना कर रही होतीन। ");
INSERT INTO pwr_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","जेनो रात मा हेरोदेस वोला बाहेर आनन वालो होत्यो पतरस ला दूई हतकड़ी लक बांध देईन। जेल को चौकीदार बेसकुड़ मा जेल की देख-रेख करत होतीन। ");
INSERT INTO pwr_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","अना पिरभू को एक सरगदूत एकाएक परगट भयो अना वोच जेल को खोली मा उजाडो भयो, अना ओना पतरस को पसली पर हात मारके ओला जगाईस अना साँगीस, “सटाकनेरी उभो होय!” अना वोको हात लक हतकड़ी पड़ गईन। ");
INSERT INTO pwr_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","तबा सरगदूत न वोला साँगीस, “तु कमर बाँध, जुता कपरा पहर वोना वसोच कर लेईस, मंगा सरगदुत वोला साँगीस का मोरा मंघा आव।” ");
INSERT INTO pwr_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","उ बाहेर हिटके अना वोको मंघा-मंघा चलतो गयो पर वोकी समझ मा यो नही आय रहयो होतो, का जोन काही सरगदूत कर रहीसे उ खरो मा से! पर वोना सोचीस का मी कोनी सपना चोय रहीसेऊ। ");
INSERT INTO pwr_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","अना जबा वय रात को पहलो पहेर अना रात को दुसरो पहेर लक हिटके लोहा गीन को बेसकुड़ मा आइन जोन नगर कन होतो। वा बेसकुड़ उनको लाई अपरो आप उघड गयो, वय बाहेर हिटके एक गली मा लक चली गईन। तबा सटाकने सरगदूत वोला छोडके चली गयो। ");
INSERT INTO pwr_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","जबा पतरस ला होस आयी तबा वोना कहीस अबा मी खरो खर मा जान गईसेऊ का पिरभू न अपरो सरगदूत धाडके मोला हेरोदेस को हात लक सूटकारा देइसेस अना यहूदी गीन की सारी आसा तोड़ देईस। ");
INSERT INTO pwr_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","यो जानके उ ओना योहन की माय मरियम को घर आयो, जो मरकुस कहलावासे। वहान लगत लोक एकठ्ठो भयके पिराथना कर रही होतीन। ");
INSERT INTO pwr_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","जबा ओने किवाड़ ला खटखटाइस, तबा रूदे नाव की बायको जवाब देवन आयी। ");
INSERT INTO pwr_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","जबा ओना पतरस की आवाज ला चिन्हिस त खुसी को मारे किवाड़ खोलयो बगैर परायके भीतर गयी। अना सांगीस का पतरस फटका मा उभो से। ");
INSERT INTO pwr_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","उनना ओकोलक कहीस, “तु बावरो सेस।” पर वा हिम्मत लक बोलत रही ऐतरो पर ओना सांगीस उ सरगदुत होहे। ऐतरो पर भी पतरस बाहेर किवाड़ को जघा खटखटातो रव्हो। हिम्मत लक कहीस का असोच से। ");
INSERT INTO pwr_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","पर पतरस खटखटातो रहयो। जबा उनना किवाड़ खोलिन ता वय ओला दिसके चकित रव्ह गईन। ");
INSERT INTO pwr_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","तबा ओने उनला चुप्पी रव्हन लाई हात लक ईसारा करयो, अना साँगीस का पिरभू ना कोन रिति लक मोला बन्दीघर लक बाहेर हेड़ीसेस, मंग उनलक कहीस, “याकूब अना अखिन भाऊ गीन ला यो खबर देव।” तबा उ वहान लक हिटके कोनी दुजो जघा ला चली गयो। ");
INSERT INTO pwr_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","सक्कारी होतच सिपाही मा मोठी खलबली मच गईन का पतरस ला काजक भय गयो। ");
INSERT INTO pwr_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","हेरोदेस न जबा वोकी मोठी जाँच करीस अना उ नही मिलयो ता वोना देख-रेख करन वारा गीन लक पुछ ताछ करीन की हुकूम देईस की उनला लीजायके मार डाको अना पतरस यहुदिया लक कैसरिया मा जायके रव्हन लगीस। ");
INSERT INTO pwr_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","उ सूर अना सैदा को लोक गीन लक लगत गुस्सा मा होत्यो। वय एक मेल होयके वोको जवर आयो। अना राजभवन को मुखिया बलास्तुस को मनायके मेल करनो चाहिन, काहेकी राजा को देस लक उनको देस को पालन-पोसन होत होतो। ");
INSERT INTO pwr_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","ठैरायो दिवस आय गयो अना हेरोदेस राज घराना का कपरा पहेर के, नियाव आसन पर बसयो अना उनना गोस्टी आयकावीस। ");
INSERT INTO pwr_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","अना लोक गीन ला हाकलता रव्हयो “या ता मानूस की नही परमेस्वर की आवाज से।” ");
INSERT INTO pwr_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","गदने सरगदूत न वोला मार डाकीस, काहेकी वोना परमेस्वर पिरभू की महिमा नही देईस वोको बदन मा कीड़ा पड़ गईन अना वोना दम तोड देईस। ");
INSERT INTO pwr_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","पर परमेस्वर को गोस्टी बड़तो गयो अना फैलतो गयो। ");
INSERT INTO pwr_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","बरनबास अना साऊल जबा अपरो सेवा काम पूरो करके ता येरुसलेम लक लवटीन अना अपरो संग योहन ला भी जोन मरकुस कहेलावसे आनीन। ");
INSERT INTO pwr_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","अन्ताकिया की कलीसिया मा लगतसा भविस्यवक्ता अना गुरूजी होत्यो, जसो बरनबास अना समौन जोन निगर मजे कालु कहेलावसे लूकियुस, कुरेनी, मनाहेम जेनको पालन-पोसन चौथाई देस को राजा हेरोदेस को संग भयो होतो। अना साऊल। ");
INSERT INTO pwr_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","जबा वय उपवास अना पिरभू की उपासना कर रहेयो होतो, ता पवीतर आतमा न कहीस “मोरो लाई बरनबास अना साऊल ला वोनो काम लाई अलग करो जेनको लाई मीना उनला हाकली सेऊ।” ");
INSERT INTO pwr_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","जबा वय उपवास अना पिराथना कर चुकीन, ता उनको पर हात राखके उनला धाडीन। ");
INSERT INTO pwr_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","अना पवीतर आतमा लक धाडके उ सिलूकिया गयो अना वहान लक जहाज लक साइप्रस गईन। ");
INSERT INTO pwr_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","सलमीस पहुचके उनना यहूदी गीन को सभाघर मा परमेस्वर को गोस्टी को पिरचार करनो चालू करीन, योहन उनको सायता करत होत्यो। ");
INSERT INTO pwr_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","जबा वय सप्पा टापु मा लक होता हुया पाफुस पहुचीन ता उनला बार-यीसु नाव को एक जादूगर मिलयो, जोन यहुदिया को खोटो भविस्यवक्ता होत्यो। ");
INSERT INTO pwr_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","उ दिप को राजपाल सिरगियुस पौलुस को संगी होत्यो, जोन गियानी मानूस होतो। राज पाल ना उनको पुड़ा बरनबास अना साऊल ला हाकलके परमेस्वर की गोस्टी आयकनो चव्हत होतो। ");
INSERT INTO pwr_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","पर इलीमास जोतिस बिद्या वारा वोको नाव को योच मतलब से। उनको बिरोध करके राजपाल को भरोसा करनो लक अडंगा डाकिस। ");
INSERT INTO pwr_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","पर साऊल न जोन पौलुस भी कहलावसे, पवीतर आतमा लक भरपुर भय, ओको कन ध्यान लक चोयके कहीस, ");
INSERT INTO pwr_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","सप्पा छल अना चलाकी लक भरयो हे बालजबूल की सन्तान, तु जो सब धरमिपन को दुस्मन सेस। तु पिरभू को सरको रास्ता ला तिरछो करनो नही छोडजोस? ");
INSERT INTO pwr_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","अबा देख, पिरभू को नियाव तोरो पर पडयोसे अना तु अँधरा भई जाजोस, अना काही बेरा सुरज नही देखजोस। तबा गदने ओको पर धुधरोपन अना इँधारो छाय गयो, अना उ इता-उता टटोलन लगयो, की कोनी ओला रास्ता दिखाएत। ");
INSERT INTO pwr_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","तबा राज अधिकारी ना यो घटना ला देखके अना पिरभू को गोस्टी ला अचँभित करके भरोसा करीन। ");
INSERT INTO pwr_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","पौलुस अना ओको सँगी पानी रास्ता लक होयके पाफुस लक पंफलिया को पिरगा मा आइन। अना योहन उनला सोड़के येरुसलेम लवट गयो। ");
INSERT INTO pwr_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","वय पिरगा लक चलिन, अना पिसदिया को अन्ताकिया मा पहुचीन अना पवीतर दिवस मा सभाघर मा जायके बस गईन। ");
INSERT INTO pwr_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","मोसे को नियम अना भविस्यवक्ता को किताब मा लक गोस्टी बाचन को मघा सभाघर को मुखिया गीन न उनको जवर साँगके धाडीस, भाऊ यदि तुमरो जवर लोक गीन को सान्ती लाई कोनी गोस्टी से तो आयकावो। ");
INSERT INTO pwr_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","तबा पौलुस उभो अना हात लक उनला उगो-मुगो रहवन को ईसारा करन लगयो, इसरायली भाऊ गीन अना परमेस्वर को भगत अखीन सज्जगीन आयको। ");
INSERT INTO pwr_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","इसरायल जनता ला परमेस्वर न हमरो सयनागीन ला बेचयो सेस उनला मिसर देस मा जावन को बेरा मोठो बनाइ होतीस, अना वहान लक अपरो ताकत लक हेडीस। ");
INSERT INTO pwr_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","उ कोनी चालीस बरस तकन जंगल मा उनको सव्हतो रहयो, ");
INSERT INTO pwr_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","अना कनान देस मा सात जात ला नास करके उनको देस, कोनी साढ़े चार सौ बरस को लाय वारसाना हक मा कर देईस। ");
INSERT INTO pwr_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","एको बाद वोना समूएल भविस्यवक्ता गीन तकन उनमा न्याय करन वालो ठहराईसेस। ");
INSERT INTO pwr_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","मंग उनना एक राजा मांगीन तबा परमेस्वर न चालीस बरस को लाई बिन्यामीन को खानदान लक एक मानूस अना कीस को टूरा साऊल को उन पर राजा ठहराईसेस। ");
INSERT INTO pwr_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","मंग वोला अलग करके दाऊद को नाव राजा बनयो, जेनको बारे मा वोना गवाही देईस मोला एक मानूस यिसै को टूरा दाऊद, मोरो मन को जसो मिल गयो, उ मोरी इक्सा पूरी करेहेत। ");
INSERT INTO pwr_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","ऐना खानदान मा लक परमेस्वर न अपरी परन को जसो इसरायल लोक को जवर एक पाप मोचक यीसु ला धाडिस। ");
INSERT INTO pwr_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","जेनको आवन लक पहेल योहन न सबरी इसरायल गीन को सबच लोकगीन मा मन पस्तावा का बप्तिस्मा देवन वालो को पिरचार कर रहयो होत्यो। ");
INSERT INTO pwr_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","जबा योहन अपरी बेरा पूरो करनो पर होतो ता उ कव्हत होत्यो, तुमी मोला का समझसेव? मी उ नही सेव पर देखो मंग मोरो एक आवन वालो से जेनको पाय की जूता को बन्ध (कसा) भी मी खोलन को बराबर नही सेव। ");
INSERT INTO pwr_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","अरे भगत भाऊ अबराहम की आवलाद अना तुमी मा जोन परमेस्वर को डर मानासे हमरो लाई यो सूटकारा को आवाज धाडीसेस। ");
INSERT INTO pwr_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","येरुसलेम को रव्हन वारा अना उनको मुखिया गीन न यीसु ला नहि चिन्हयो, अना वोला पापी ठहराय दियो। असो परकार लक उनना भविस्यवक्ता गीन की गोस्टी ला पुरो करियो। जेनला हर पवीतर दिवस मा बाचयो जावासेत। ");
INSERT INTO pwr_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","मंग उनला वोला मार डाकन लाय कोनी कारन नही भटयो। मंग उनना पीलातुस लक माँग करीन का उ मार डाकयो जाय। ");
INSERT INTO pwr_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","“वोको बारेमा लिखी हुई सबरी गोस्टी पूरी कर लेवन को मघा उनना वोला कूरूस पर लक उतारके मरघट्टी मा राख देईन।” ");
INSERT INTO pwr_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","पर परमेस्वर न वोला मरयो मा लक जित्तो करीस। ");
INSERT INTO pwr_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","मंग लगत दिवस तकन उ उनला चोवतो रहयो। जोन गलील लक येरुसलेम नगर तकन वोको संग होतीन। अना वोच इसरायल लोकगीन को पुड़ा खरो गवाह से। ");
INSERT INTO pwr_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","हमी वोच साजरो बारता आयकाव सेत। जोन परन आमरो पुरखागीन लक करी गई होती। ");
INSERT INTO pwr_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","यीसु को मर जावन को मघा वोला दुबारा जित्तो करके उनको सन्तान गिन को लाय परमेस्वर ना वाच वायदा ला हमरो लाई पूरी करयो। जसो की भजन मा लिख्यो से, “तु मोरो टूरा आस, आज मीना तोला जलमायो सेउ।” ");
INSERT INTO pwr_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","परमेस्वर ना वोला मरयो हुयो मा लक जित्तो करीस, अबा उ कबच नही सड़हेत। यो गोस्टी को सबूत मा परमेस्वर ना असो बचन कहीस “मी दाऊद की पवीतर अना अटल किरपा तोला देहू।” ");
INSERT INTO pwr_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","एको लाई उ एक अवर भजन मा असो कव्हसे, तु अपरो पवीतर जन ला नही सड़न देजोस। ");
INSERT INTO pwr_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","दाऊद अपरो बेरा मा परमेस्वर को मरजी को अनुसार अपरो सेवा पूरी करके झोफ गयो। वोला अपरा पुरखागीन को संग मरघट्टी मा गड़ा देइन अना वो लास नास हो गयो। ");
INSERT INTO pwr_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","पर जेनला परमेस्वर न मरयो मा लक जित्तो करीस उ नास नही भयो। ");
INSERT INTO pwr_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","एकोलाई अरे सबा यिसरायली भाऊगीन तुमी यो जान लेव, यीसुच लक पाप छिमा को उपदेस तुमला दियो गयो सेत। ");
INSERT INTO pwr_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","अना येकोच लक हरेक जोन बिस्वासी सेत। उ पापगिन लक सूटकारा पा सकासेत। जोन लक तुमीला मोसे को नियम नही दिला सकासेत। ");
INSERT INTO pwr_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","एको लाई होसियार रव्हो, कही भविस्यवक्ता गीनको कव्हयो तुमरो पर नोको घट जाय। ");
INSERT INTO pwr_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","निन्दा करन वारा देखो अना चकीत हुओ, अना मिट जाव काहेकी जोन आज मी करासु। वोला कोनी खुला देय तबा भी वोको मा “तुमी ला भरोसा नही होहेत।” ");
INSERT INTO pwr_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","जबा पौलुस अना बरनाबास बाहेर जान लगीन ता लोकगीन न उनको लक बिनती करीन का आवनवालो पवीतर दिवस या गोस्टी उनला मंग लक आयकायो जाय। ");
INSERT INTO pwr_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","जबा सभा को खतम भयो, ता लगत सा यहुदी गैरयहूदी नेक लोक गिनना पौलुस अना बरनबास को गोस्टी मान लेइन। अखिन वय उनलक लगत गोस्टी करीन। अना कहिन का तुमी परमेस्वर को दया जिंदगी बिताव। ");
INSERT INTO pwr_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","अगलो पवीतर दिवस ला, पिरभू को गोस्टी आयकन लाई नगर को सब लोक गीन जमा भईन। ");
INSERT INTO pwr_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","तबा यहूदी गीन ना भीड़ ला देखीन, ता वय जलन करन लगीन। अना पौलुस जो कव्हत होतो वोको निन्दा करीन। ");
INSERT INTO pwr_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","तबा पौलुस अना बरनबास न हिम्मत लक कहीन, “यो तय होतो का परमेस्वर को गोस्टी पुड़ा तुमला आयकायो जाय, पर जबा तुमी वोला नही मानयत अना अपरो आपला ला अमर जीवन को काबिल नही ठैयराय सेव, ता देखो हमी गैर यहुदी कन जाबिन।” ");
INSERT INTO pwr_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","काहेकी पिरभू न हमला यो हुकूम देई होतीस। का मीना तुमला गैर यहुदी गीन को लाई उजाडो ठयराई सेऊ, तुमी धरती को छोर तकन सूटकारा लेके जाव। ");
INSERT INTO pwr_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","जबा गैरयहुदी गीन असो आयकिन ता खुस भय गईन। अना उनना पिरभु को बचन को सतकार करीन। मंग लगत लोक गिन बिस्वासी बनके आपरो लाय अमर जीवन पिक्को कर लेइन। ");
INSERT INTO pwr_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","अना पिरभू को गोस्टी पूरो देस मा फैलतो चली गयो। ");
INSERT INTO pwr_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","उतानी यहूदी गिन न उचो कुल को भकती करन वाली आई-माई गिन अना नगर का मुखिया मानूस गीन ला भड़कायके पौलुस अना बरनबास को बिरोध मा उपदरा करवायके उन पर दबाव बनायके अपरी सिवमेड़ लक बाहेर हेडदेईन। ");
INSERT INTO pwr_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","तबा पौलुस अना बरनबास ना अपरो पाय की बारु झड़ायके इकुनियुम नगर मा चली गईन। ");
INSERT INTO pwr_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","अन्ताकिया को बिस्वासी पवीतर आतमा लक भरपुर भई गइन। ");
INSERT INTO pwr_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","ठीक असो परकार की घटना इकुनियुम मा घटी। पौलुस अना बरनबास यहूदी गीन को सभाघर मा गईन। अना उनना असो गोस्टी करीन का, यहूदिगीन अना गैरयहुदी गीन दुई लक लगत लोकगीन, बिस्वास करीन। ");
INSERT INTO pwr_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","पर वय यहूदी अना गैर यहुदीगीन जोन बिस्वास नही करया होतिन। वय हड़कम्प मचाइन अना बिस्वासी गिन को बिरोध भई गईन। ");
INSERT INTO pwr_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","पौलुस अना बरनबास लगत दिवस तकन रहयो। उनना पिरभू को बारेमा बेधड़क बताइन। उनको हात लक हिदान, अना अचँभा काम होत होतो। अना उनना यो साबीत कर दियो का यो सन्देसा उन पर होवन वारा किरपा को बारे मा सेत। ");
INSERT INTO pwr_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","पर नगर का लोक गीन मा दरार पड़ गई जेनको लक कोनी, ता यहूदी गीन को पक्स मा अना कोनी चेलागीन को पक्स मा भय गईन। ");
INSERT INTO pwr_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","पर जबा गैरयहुदी अना यहूदी गीन न अपरो मुखिया, गीन को संग मिलके उनको संग बुरो बरताव करके अना उनला, गोटा मारन को कोसिस मा होतिन ");
INSERT INTO pwr_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","उनला यो गोस्टी मालुम भई। तबा वय लुकाउनिया, लुस्तरा अना दिरबे नगर को अगल-बगल छेतर मा पराय गईन। ");
INSERT INTO pwr_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","अना वहान साजरो बारता आयकावत होतीन। ");
INSERT INTO pwr_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","लुस्तरा मा एक अपंग मानूस होतो जोन उपजन लक लगड़ो होतो। अखिन कभीच रिगंयो नही होतो। ");
INSERT INTO pwr_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","उ वहान बस्यो होतो। अना उ पौलुस की गोस्टी लगत धियान लक आयकत होतो। पौलुस ना चोवयो उ बिस्वास करासेत। अना साजरा होय सकासेत। एकोलाय वोना सिद्दो चोवयो ");
INSERT INTO pwr_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","अखिन जोरलक कव्हयो, “आपरो पायमा उभो होय! उ उछल के इतानी-उतानी हिन्डन लगयो।” ");
INSERT INTO pwr_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","जबा लोकगीन ला चोवयो, का पौलुस ना का करिसे, ता वय लुकाउनियाई बोली मा बोलिन “देवता मानूस को रूप धरके हमरो कठा उतरियो सेस।” ");
INSERT INTO pwr_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","उनना बरनबास को नाव ज्यूस, अना पौलुस ला हिरमेस नाव देइन। काहेकी उ मुख बोलन वालो होतो। ");
INSERT INTO pwr_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","नगर को बाहेर ज्यूस देवता को मंदिर होतो। वहान को पुजारी, बइल अना फूल को माला लेके बेसकुड़ को पुड़ा आनयो। काहेका उ अना लोक गीन पेरीत गिनलाय बलिदान करनो चाव्हत होतिन। ");
INSERT INTO pwr_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","पर जबा पेरीत बरनबास अना पौलुस न यो आयकिन ता अपरा-अपरा कपरा चीर डाखिन, अना जोरलक चिल्लायके भीड़ ला कहिन। ");
INSERT INTO pwr_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“अरे लोकगिन तुम यो कायलाय करासेव?” अमी भी वसोच मानूस सेत जसो तुमी सेव। यहान हमी तुम्हिला साजरा बारता आयकान साठी आयासेजन। जोनलक, तुमी एना बेकार जीनुस गीन ला सोड़के, जित्तो परमेस्वर को कन मुरक जाव। जोन ना बादल अना धरती सागर अना उनमा जोन काही भि सेत सबला बनाईसेस। ");
INSERT INTO pwr_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","वोना जुनो जुग मा सबच लोक गीन ला, अपरो-अपरो रास्ता मा चलन देइस। ");
INSERT INTO pwr_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","मंग उ तुमला अपरो होवन को सबुत देइसेस। काहेका उ लगत भलाई करतो रहयो। वोना तुमरो लाय बादल लक पानी बरसायो, अना मौसम को अनुसार फसल दियो। वोच तुम्हिला जेवन देवसेत। अना तुमरो मनला खुसी लक भर देवासेत। ");
INSERT INTO pwr_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","ऐना गोस्टी लक उन लोकगीन ला समझा के बलिदान देवन लक रोकीन। ");
INSERT INTO pwr_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","पर काही यहूदी गिन न अन्ताकिया नगर अना इकुनियुम लक आयके, लोक गीनला अपरो कन कर लेईन, अना पौलुस ला गोटा लक मारिन। अना मरया समझके, वोनो नगर को बाहेर घसीटके ले गईन। ");
INSERT INTO pwr_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","पर जब चेलागीन उनको चारी कन आयके उभा भईन ता उ उभो होयके, नगर मा गईन। अना दुसरो दिवस बरनबास को संग दिरबे, ला चली गईन। ");
INSERT INTO pwr_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","वोना नगर मा उनना साजरो बारता परचार करके लगत बिस्वासी बनाइन। ");
INSERT INTO pwr_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","अना उनको आतमा ला अडिग करके बिस्वास मा बनयो रव्हन लाय यो सांगके सिकायो का अमिला मोठयो दुख झेल के परमेस्वर को राज मा धसनो सेत, मंग वय लुस्तरा मंग इकुनियुम अना अन्ताकिया नगर ला लवटके आइन। ");
INSERT INTO pwr_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","उनना हरेक कलीसिया ला मा उनको लाई मुखिया बेचयो अना, उपवास को संग पिराथना करीन, अना उनला पिरभू को सुपरुत कर देईन, जोन पर उनना भरोसा करयो होतिन। ");
INSERT INTO pwr_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","वय पिसदिया देस लक होतो हुयो पंफलिया नगर पहुचीन। ");
INSERT INTO pwr_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","अना पिरगा नगर मा साजरा बारता परचार करीन, मंग वय अन्ताकिया गईन। ");
INSERT INTO pwr_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","उता लक उनना पानी जहाज मा मोठो, नगर अन्ताकिया गईन। जहान वोला परमेस्वर को काम करन काजी परमेस्वर को दया मा दियो गयो होतो। ");
INSERT INTO pwr_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","उता पहुचके ना उनना कलीसिया, को सभा हाकलिन। अना सबला सागिन, का परमेस्वर ना उनको लक काजक-काजक करीस, अना कसो गैर यहुदी लोकगीन को लाय, भरोसा को बेसकुड़ उघाड़िसेस। ");
INSERT INTO pwr_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","वय गजब बेरा तकन वहान चेला गीन संग रहिन। ");
INSERT INTO pwr_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","मंग काही लोकगीन यहुदिया छेतर लक मोठो नगर अन्ताकिया मा आइन। अना भाऊ गीन ला यो सिकान लगीन। “यदी मोसे भविस्यवक्त को नियम को अनुसार तुमरो खतना नही होहेत, तो तुमीला सूटकारा नही भेटेत।” ");
INSERT INTO pwr_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","पौलुस अना बरनबास उनको लक सहमत नही होतिन। तो उनको सँग लगत बैस भयो। तबा पौलुस, बरनाबास अना उनमा लक काही संगीगिन ना ऐना समस्या को उपाय लाई पेरीतगिन अना मुखिया गिन को जवर येरुसलेम नगर धाड़न को इरादा करीन। ");
INSERT INTO pwr_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","असो कलीसिया लक बिदाई पायके वय फीनीके अना सामरिया होतो हुयो, सबा भाऊ गीनला गैरयहुदी को मन बदलन को पूरो-पूरो समाचार आयकाव के लगत खुसी पहुचाय रहयो होतीन। ");
INSERT INTO pwr_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","मंग जबा वय येरुसलेम पहुचीन, तो कलिसिया को पेरीतगिन ना, अना बुजरुग गिन ना उनको आव-भगत करीन। पौलुस अना बरनाबास ना उनको संग परमेस्वर ना जोन काही काम करीसेस सांगीस। ");
INSERT INTO pwr_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","पर फरीसी दल को काही बिस्वासी ना उभा होयके उन लक कहिन, उनका खतना जरुर होवनो चाहिये। अना उन लक मोसे को नियम को काम पालन करन को हुकूम देवनो जरुरी से। ");
INSERT INTO pwr_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","ता यो बारे मा सलाह मसोवरा करन लाय पेरीत अना बुजरुक गिन जमा भईन। ");
INSERT INTO pwr_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","एक लम्बो-चौवड़ो बैस को मघा पतरस ना उभा होयके उनलक कहीस, “मोरो भाऊ गीन, लगत दिवस पुढ़ा तुमरो मा लक परमेस्वर ना निवाड़ी होतो। का मोरो लक गैरयहुदी गिन साजरा बारता आयकेत, अना बिस्वास करहेत।” ");
INSERT INTO pwr_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","अना दिल की गोस्टी को जानकार परमेस्वर ना आमरो च जसो उनला भी पवीतर आतमा देयके उनको पक्स ला पिक्को करीसेस। ");
INSERT INTO pwr_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","येने परकार बिस्वास लक उनको पाप ला छिमा करके अना उनको मनला पवितर करयो अना उनको अना आमरो बिच कोनी भेद-भाव नही करयो। ");
INSERT INTO pwr_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","अता चेला गीन की गरदन पर असो मजबूत जुमेदारी की जुआड़ी राखके जेनला न तो हमरो पुरखा, अना हमि उचल सकया सेजन, अता काहे परमेस्वर की परिक्सा करोसो? ");
INSERT INTO pwr_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","पर आमरो ता यो बिस्वास सेत। का पिरभू यीसु को दया लक आमरो बचाव भई सेत, वसोच उनको भी भई सेत। ");
INSERT INTO pwr_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","तबा सारी भीड़ सान्त भई गइन। तबा बरनबास अना पौलुस लक यो बखान करन लगीन। का परमेस्वर ना उनको लक गैरयहुदी लोकगीन मा कसो-कसो हिदान दिखाइसेस। अना अचँभा काम करीसेस। ");
INSERT INTO pwr_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","जबा वय बोल चुकिन ता येरुसलेम कलिसिया को मुखिया याकूब ना साँगीस। भाऊ मोरी आयको, ");
INSERT INTO pwr_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","समौन ना सबूत दियो होतो, का परमेस्वर ना काही लोकगिन ला आपरो नाव को लाई बेचके, कसो पिरेम करीयो होतो। ");
INSERT INTO pwr_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","भविस्यवक्ता गिन को बचन भी यो गोस्टी ला मानासेत, जसो का लिख्यो सेत। ");
INSERT INTO pwr_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","ऐको मंघा मि लवटिन अना दाऊद को पड़यो हुयो राज ला मंग बनाहिन। मी वोको खन्डार को सुधार करीन। ");
INSERT INTO pwr_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","अना सब बचयो लोक अना सबच गैरयहुदी गिन, जोनला मोरो बनन लाय बनायो गयो सेत पिरभू को खोज करे। ");
INSERT INTO pwr_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","दुनिया को सुरुवात लक यो वोच पिरभू सेत जोन येने गोस्टी ला परगट करत आईसे। ");
INSERT INTO pwr_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","असो परकार लक मोरो फैसला यो सेत का अमीला उन लोकगिन ला जोन गैरयहुदि होतयो हुयो परमेस्वर कन मुरकी सेत तगांवनो साजरा नाहती। ");
INSERT INTO pwr_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","पर उन ला लिख धाड़यो का मुरती को पर चघायो जुनुस, छिंनरापन अना गला घोटयो जनावर को मांस अना खून लक दुहुर रहेत। ");
INSERT INTO pwr_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","काहे की “जूनो बेरा लक नगर-नगर मा मोसे भविस्यवक्ता की कानुन बाचन वारा होता आइन अना सबच पवीतर दिवस सभाघर मा मुसा को नियम ला बाचो जावसे।” ");
INSERT INTO pwr_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","मंग पेरीत गिन अना बुजरुक गिन ना पूरी कलीसिया सकट यो पक्को करीन का पेरीत उनको बीच मा लक काही मानूस अना पौलुस ला को बेचके अंताकिया धाड़यो जाय। बरसब्बा कहयो जान वालो यहूदा, अना सीलास ला बेच लेइन। वय भाऊगीन मा आदर को काबिल होतिन। ");
INSERT INTO pwr_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","उनना उनको हात यो चिठ्ठी धाडिन। तम्हारो भाऊ, बुजरुगगिन अना पेरीत गिन को कन लक अन्ताकिया सीरिया अना किलकिया को गैरयहुदी भाऊ गीनला नमस्कार, ");
INSERT INTO pwr_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","अगो चहेतो भाऊगिन! हमिना जबा लक यो आयकिया की हमि मा लक कोनी बगैर आमरो हुकूम को जायके तुमरो मनला उलट के परेसान कियो सेत, अना तुमरो मन ला डगमगा देइसेत, ");
INSERT INTO pwr_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","तबा हमी एक मत भयके यो फैसला कर निवाड़ी सेजन का आपरो चहेतो बरनबास अना पौलुस को सँग काही मानूस ला तुमरो कठा धाड़िसेजन। ");
INSERT INTO pwr_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","यो असो मानूस सेत जिनना हमरो पिरभू यीसु मसीह को नाव को लाई आपरो जान जोखिम मा डाकिसेत। ");
INSERT INTO pwr_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","एकोलाय हमिना यहूदा अना सीलास ला धाडीसेउ, जोन खुदच आपरो मुँह लक ऐना सारी गोस्टी को खबर सांग देहेत। ");
INSERT INTO pwr_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","काहेकि पवीतर आतमा अना हमला यो ठीक जान पडयो की ऐना जरुरी गोस्टी ला छोड़ तुमी पर अना कोनी बोझ न डाके। ");
INSERT INTO pwr_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","मुरत गीन को पुड़ा चघायो हुयो जेवन तुमी नोको जेव। गला घोटके मारयो गयो जनावर को गोस अना रकत नको पिवने। अना छिंनरापन लक दुहुर रव्हो। इनलक बचयो रव्हो तो तुमरो भलो होहे। बाकी-बेस सेत। ");
INSERT INTO pwr_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","असो परकार उनला बिदा कर देइन, अना वय अन्ताकिया गईन। वहान बिस्वासी गीनला जमा करके उनला उ चिठ्ठी देईन। ");
INSERT INTO pwr_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","जबा वय चिठ्ठी वाच चुकीन, ता उनला लगत सय भेटयो अना गजब खुसी भईन। ");
INSERT INTO pwr_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","अना उनना भाऊगिन को यहूदा अना सीलास ना जोस अना मजबुती देय के उनला लगत लम्बो परबचन देइन। ");
INSERT INTO pwr_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","काही दिवस वहान रव्होन को मंघा सुब कामना आन के बिदाई लेइन। अना लवट गइन। ");
INSERT INTO pwr_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","पर सीलास ला वहान रव्हनो साजरो लगयो। ");
INSERT INTO pwr_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","पौलुस अना बरनबास भी अन्ताकिया मा रह गईन, अना अखीन लगत लोक गीन को सँग वय भी पिरभू को साजरो बारता की सिक्सा देवत अना ओको पिरचार करत रहयो। ");
INSERT INTO pwr_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","मंग काही दिवस मा पौलुस न बरनबास लक कहीस “आव, जेना-जेना नगर मा हमी न पिरभू को गोस्टी आयकिवाईस मंग उनमा चलके अपरा भाऊ गीन ला चोयके वय कसासेत।” ");
INSERT INTO pwr_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","तबा बरनबास न योहन जोन मरकुस कहेलावसे संग लेवन को बिचार करीस। ");
INSERT INTO pwr_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","पौलुस न यो फैसला करीस का, जोना पंफलिया मा उनको साथ सोड़ दियो होतो। अना काम पर उनको संग नही गयो होतो एको लाय वोला लेजान लाय मना करीस। ");
INSERT INTO pwr_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","अना दुई मा दुई-दुई गोस्टी भई अना वय एक दुसरो लक अलग होय गईन। अना बरनबास, मरकुस को संग जहाज मा साइप्रस चली गयो। ");
INSERT INTO pwr_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","पर पौलुस न सीलास ला बेच लेईस अना भाऊ गीन लक पिरभू को दया मा सोप देईस अना वहान लक चली गयो। ");
INSERT INTO pwr_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","अना उ कलीसिया गीन ला पक्को करतो हुयो सीरिया अना किलकिया लक होते हुयो हिटयो। ");
INSERT INTO pwr_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","मंग पौलुस अना सिलास, दिरबे अखीन लुस्तरा नगर मा गइन। वहान तीमुथियुस नाव को एक चेला होतो। जोन को माय यहुदी बिस्वासी अना वोको बाप यूनानी होतो। ");
INSERT INTO pwr_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","लुस्तरा अना इकोनियुम नगर मा उ बिस्वासी गिनमा नामी होतो। ");
INSERT INTO pwr_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","पौलुस तिमुथियुस ला आपरो संगा यातरा पर ले जावनो चाव्हत होतो। एकोलाय ओला आपरो संगा ले गयो। अना वोनाजघा मा रव्हन वालो यहुदीगीन को कारन, ओको खतना करयो गयो। काहेकि वय सबच जानत होतीन की ओको बाबूजी एक युनानी होतो। ");
INSERT INTO pwr_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","वहान लक एना सहर लक वोना सहेर यातरा करतो हुयो। पेरीतगिन येरुसलेम मा जोन फैसला लियो होतो बिस्वासी गिनला सांगिन। का वय उनको पालन करे। ");
INSERT INTO pwr_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","एना पिरकार कलीसिया बिस्वास मा मजबूत होती गई अखीन उनकी गिनती हर दिवस बडतो गयो। ");
INSERT INTO pwr_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","वय फ्रुगिया अखीन गलातिया परदेस मा लक होयके हिटीन, काहेकी पवीतर आतमा न उनला आसिया मा साजरो बारता आयकावनो लक मना कर देयि होतो। ");
INSERT INTO pwr_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","मंग उनना मुसिया कस्बा को जवर पहुचियो, अना ता बिथुनिया जान को जतन करिया पर यीसु की आतमा न उनला वहान जान नही देईस। ");
INSERT INTO pwr_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","मंग वय मुसिया कस्बा लक होयके तोरआस मा पहुचीन। ");
INSERT INTO pwr_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","वहान पौलुस न रात मा एक दरसन मा चोयीस, का मकिदुनिया को एक मानूस वोको लक पिराथना कव्हत हुयो कव्ह रही से, “मकिदुनिया मा आव अना आमरो सायता कर।” ");
INSERT INTO pwr_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","दरसन को मघा जवाब भेटयो ता अमीला मालुम भयी गयो का अमीला परमेस्वर ना उन लोकगीन को बीच साजरो बारता आयकावन लाय मकीदुनिया जावन लाय सांगीसेस। ता अमी ना वहान जावन लाय ठान लियो। ");
INSERT INTO pwr_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","असो आमिना तोरआस लक पानी च पानी जावन लाय आपरो जहाज खोल दियो। अना सीधो समुथार तकन गयो। अना दुसरो दिवस नेआपुलिस ला चली गया। ");
INSERT INTO pwr_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","अखीन वहान लक एक रोमी उपनिवेस फिलिप्पी पहुचियो। फिलिप्पी मकीदुनिया को मुखय नगर से। यो नगर मा अमी काही दिवस बितायो। ");
INSERT INTO pwr_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","मंग बिसराम दिवस यो बिचार करतो हुयो पिराथना करन को लाई का वहान कोनी जघा होहेत। आमी नगर को बेसकुड़ को बाहेर नदी मा गयो। अमी बसके जमा आई-माई लक गोस्टी करन लगया। ");
INSERT INTO pwr_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","वहाच लीदिया नाव को बाई होती। वा किमती बैंजनी कपरा को धंधा करत होती। अना परमेस्वर की पिराथना करत होती। वा आमरी गोस्टी आयकत होती। पिरभू ना ओको मन को बेसकुड़ खोलिस। जोनलक वा पौलुस की गोस्टी धियान देयके आयके। ");
INSERT INTO pwr_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","जबा ओना अना ओको परिवार ना बप्तिस्मा लेईन। मंग बिनती करीस, “अदी तुमी लोक मोला बिस्वासी मानासो ता मोरो घरमा रव्हो।” असो कव्ह के आमीला मनाईस। ");
INSERT INTO pwr_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","मंग असो भयो का जबा आमी कोनी दिवस पिराथना घर जावत होता की एक जुवान बायको लक आमरी मुलाकात भई। ओमा सगुन देखनवारी आतमा होती। वा लोकगिन को पराय सांगके आपरो मालीक गीन को साठी लगत पैसा कमाय के देवत होती। ");
INSERT INTO pwr_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","वा पौलुस अना आमी लोकगीन को मंघा-मंघा आयके बेमियावन लगी। “यो लोकगीन सब लक वरता को परमेस्वर का दास सेत अना तुमी लोकगीन ला सूटकारा को रास्ता साँगसेत।” ");
INSERT INTO pwr_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","वा लगत दिवस तकन असोच करत रही। तबा आ पौलुस परेसान भयी गयो। तबा उ मुरक के ओना आतमा लक कहीस; “मि तोला यीसु मसीह को नाव लक हुकूम देवसु, तु ओमा लक हिट जाय,” अना वा बुरो आतमा तुरुत ओमा लक हिट गई। ");
INSERT INTO pwr_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","जबा ओको मालीक ना चोयीन, की उनकी कमाई को आसा चलयो गयो। ता वय पौलुस अना सीलास ला धरके चौक मा मुखिया गीन को कठा झिक के ले गईन। ");
INSERT INTO pwr_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","उनना पौलुस अना सीलास ला रोमन अधिकारी को पुढ़ा ले जायके कहिन, “यो लोक आमरो सहर मा सान्ती भँग कर रही सेत, यो यहूदी सेत। ");
INSERT INTO pwr_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","अना असी मोसे को नियम सांग सेत, जेनला माननो हमी रोमी को लाई नियम लक नाहती।” ");
INSERT INTO pwr_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","तबा जमघट का लोक उनको बिरोध मा इकठ्ठे होयके चघके आयइन अना रोमन अधिकारी गिन उनका कपरा चीरके उतार डाकिन, अखीन उनला कोडा मारन की हुकूम देईस। ");
INSERT INTO pwr_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","लगत कोडा लगायके, उनना उनला जेल मा डाक देईन। अना जेलर ला हुकूम दियो का उनला कड़ो निगरानी मा राखो। ");
INSERT INTO pwr_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","वोना असी हुकूम पायके उनला भीतर की खोलीमा राखीस। अखीन उनका पाय लकड़ी मा ठोंक देइस। ");
INSERT INTO pwr_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","अरधी रात को करीब मा पौलुस अना सीलास पिराथना करतो हुयो, परमेस्वर को भजन गावत होतिन। अना कैदी उनकी आयक रहयो होतो। ");
INSERT INTO pwr_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","एतरो मा एकाएक जेल को पाया हिल गयो। यहान तकन अखीन गदने सबच बेसकुड़ खुल गईन। अना सबच का बेड़ी खुल गईन। ");
INSERT INTO pwr_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","जेलर चेत गयो, अखीन जेल को बेसकुड़ उघडया चोयके समझयो का जैली पराय गई सेत। अना उनना तरवार झिकन के अपरो आप ला मारन लगिस। ");
INSERT INTO pwr_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","पर पौलुस न जोर लक हाकलके कहीस, “अपरो आप को काही नुकसान नोको कर” काहेकी हमी सबच यहाच सेजन। ");
INSERT INTO pwr_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","तबा उ टेमा बुलायके भीतर परायो, अना थर-थर कपकपा के पौलुस अना सीलास को पाय पड़न लगयो। ");
INSERT INTO pwr_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","अना वोनच घड़ी उनला बाहेर हेड़के कहीस “अरे पिरभू को भगत सूटकारा पावन लाई मी का करु?” ");
INSERT INTO pwr_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","उनना कहीन “पिरभू यीसु मसीह पर भरोसा कर त तोरो खानदान सूटकारा पाहे।” ");
INSERT INTO pwr_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","अना वोना अखीन वोका सारा घर का लोक गीन ला पिरभू को गोस्टी आयकावीस। ");
INSERT INTO pwr_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","रात को वोन च बेरा मा वोना उनला लीजायके उनका घाव धोयके अखीन उनना अपरा सबच लोकगीन समेत गदने बप्तिस्मा लेईस। ");
INSERT INTO pwr_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","तबा वोना उनला अपरो घर मा लीजायके उनको जेवनार करीस। अखीन सबरी खानदान समेत परमेस्वर पर बिस्वास करके खूसी मनावन लगयो। ");
INSERT INTO pwr_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","जबा दिवस भयो तबा रोमन अधिकारी न सिपाईगीन ला धाडीस। का उन मानूसगिन ला छोड़ देव। ");
INSERT INTO pwr_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","जेलर ना या गोस्टी पौलुस लक कहीस का रोमन अधिकारी कहलवायो सेत का तोला अना ला सोड़यो जाय। अबा हिटके सान्ती लक चली जावो। ");
INSERT INTO pwr_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","पर पौलुस न उन सिपाईगिन लक कहीस, हमी रोमी नागरिक सेजन, पर उनना बेकसूर होवन पर भी हमला सबको पुड़ा मारपीट के जेलमा डाकदियो। अना अबा अमीला चुप्पई लक अमीला बाहेर हेड रहीसेत? असो नही होहेत, वय खुदच आयके अमीला बाहेर हेडे़त। ");
INSERT INTO pwr_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","सिपाई गीन न यो गोस्टी रोमन अधिकारी लक कहीन। रोमी अधिकारी ला जबा यो पता चलयो का पौलुस अना सिलास रोमी से ता वय डराय गइन। ");
INSERT INTO pwr_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","तबा वय वहान आइन, अना उनलक माफी मागके, उनला बाहेर ले जायके, उनलक सहेर सोड़न को बिनती करन लगयो। ");
INSERT INTO pwr_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","पौलुस अना सिलास जेल लक हिटके, लुदिया को घर मा गईन अखीन भाऊ गीन लक भेंट करके उनको जोसला बड़ाय के सान्ती लक चली गईन। ");
INSERT INTO pwr_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","वय अम्फिपुलिस अना अपुल्लोनिया नगर को यातरा पूरो करके वय थिस्सलुनीके नगर आइन। जहान यहूदी गीन को सभाघर होतो। ");
INSERT INTO pwr_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","पौलुस अपरी रीत को लक वहान उनलक भेटयो। उनना तीन हपता को पवीतर दिवस लक उन को संग मा बिचार राखिस। ");
INSERT INTO pwr_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","अना गिरंथ लक उनला समझात हुया, असो सिकात रहयो, का मसीह ला दुख भोगनो च होतो। अना मरया हुया मा लक जित्तो होवनो जरूरी होतो। अना “यो यीसु च से जोन को मी तुमरो बीच मा पिरचार करासेऊ मसीह सेत।” ");
INSERT INTO pwr_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","उनमा लक काही लोकगीन न भरोसा करीन, अखीन वय पौलुस अना सीलास को संग मिल गईन। परमेस्वर लक भेव राखनवारा अनगिनत गैरयहुदी भी उनमा मिल गइन। इनमा लगत आई माई गीन भी होतिन। ");
INSERT INTO pwr_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","पर यहूदी ईरसा अना जलनखोरी करन लगीन। अखीन उनना हाट का काही गुन्डा बदमास गीनला जमा करीन। अना नगर मा दंगा करा देईन। वय यासिन को घर पहुच गइन। अना यो कोसीस करन लगीन का कोनी परकार लक पौलुस अखीन सीलास ला लोकगिन पुड़ा मनजे। ");
INSERT INTO pwr_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","जब वय उनला नही भेटयो ता वय यासोन अखीन काही भाऊ गीन ला सहेर को पूड़ा घसीट के आनीन अना चिल्लाइन। ए लोक गिन सब कन उथल-पूथल करयो सेत अबा यो सहेर मा आयो सेत। ");
INSERT INTO pwr_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","यासोन न इनला अपरो यहान राखीसेस। अना ये सब लोक कैसर राजा को नियम को बिरोध मा काम करासेत। अना कव्हसेत का अवर एक राजा सेत जोनको नाव यीसु से। ");
INSERT INTO pwr_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","असो आयक के भीड़ अना अधिकारी भडक गयो। ");
INSERT INTO pwr_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","अना छुड़ायो जावनको लाय लगनवारा पैसा आन के अधिकारी गिन उनला अना यासेन ला छोड़ देइन। ");
INSERT INTO pwr_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","भाऊ-बहिन न गदने रातो-रात पौलुस अना सीलास ला बिरीया नगर मा धाडीस। वहान पहुच के वय यहूदी गीन को सभाघर मा गईन। ");
INSERT INTO pwr_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","यो यहूदी थिस्सलुनीके यहूदिगीन लक लगत उदार होतिन। वय मोठि खुसी लक पिरभू की खबर आयकावत होतीन। अना वोकी खराई ला जाँचन लाई हर दिवस पवितर गिरंथ मा जाँचत होतीन। का यो गोस्टी असो सेति का नहाति। ");
INSERT INTO pwr_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","एको परिनाम मा लगत सा यहुदी अना गैर यहदी अना रहीस आईमाई ना भी बिस्वास करन लगीन। ");
INSERT INTO pwr_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","जबा थिस्सलुनीके को यहूदीगीन ला यो मालूम भयो तो वय बिरीया नगर मा आइन। अना बीरिया मा पौलुस को खिलाप लोकगीन ला भडकावन अना गुस्सा दिलावन लगीन। ");
INSERT INTO pwr_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","एकोलाय तभी भाऊ गिन ना गदने पौलुस ला सागर को कगर जावन लाय धाड़ दियो। पर सिलास अना तिमोथी वहाच रहयो। ");
INSERT INTO pwr_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","पौलुस को लिजावन वारा लोकगिन ना वोला अथेन पहुचा देइन। अना, सीलास अना तीमोथी ला कहीन का तुमी लवकर आव अना वय चले गइन। ");
INSERT INTO pwr_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","जबा पौलुस अथेने नगर मा सीलास अना तिमोथी की रास्ता चोवत होतो। ता नगर मा देवता की मुरत की भरमार चोयके ओको “करेजा जर गयो।” ");
INSERT INTO pwr_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","एकोलाई उ हर रोज यहूदी गीन युनानी लक बहेस करत होतो। इतरोच नही उ बाजार हाट मा जोन आवत-जावत होतीन। उनको संग मा भी बहेस करत होतो। ");
INSERT INTO pwr_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","काही एपिकूरी अना स्तोइकी सिक्सक भी वोको लक बहेस करन लगीन। उन मा लक लोक कव्हन लगीन “यो बाकवाद करन वालो काजक चाहवासे ‘दुसरो न कहीस’ यो त विदेसी देव गीन पिरचार करन वालो मालुम पडसे” उनना एकोलाई कहीस का उ यीसु को बारे मा उपदेस देवत होतो। मंग जित्तो होवन को पिरचार करत होतो। ");
INSERT INTO pwr_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","एको लाई वय पौलुस ला अपरो संग अरियोपिगुस महा सभा मा ले गईन। अना उनला कहीन का हमी जान सका सेजन का तुमी या कौनती नवी सिक्सा देय रहीसेव? ");
INSERT INTO pwr_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","तुमी काही असी गोस्टी कव्हसेव, जोन हमरो कान लगावन वालो गोस्टी लगासे। हमी जाननो चाव्हसेजन का वोको अरथ का से? ");
INSERT INTO pwr_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","काहेकी अथेने नगर का सबच रव्हनवारा अना वहान का रव्हनवारा विदेसी नवी-नवी गोस्टी आयकावन अना आयकन को अलावा अखीन काही काम मा नही बितावत होतिन। ");
INSERT INTO pwr_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","अरियोपिगुस न्यायालाय को पुड़ा उभो होयके पौलुस न यो कहीस “अथेने नगर को रव्हन वारा महान गीन! मी चोय रही सेव का तुमी लोक हर पिरकार लक मोठो धरम पिरेम से।” ");
INSERT INTO pwr_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","जबा मी हिंडता-फिरता तुमरी उपासना को चीजगीन ला देख रही सेव, ता मोला एक होमनकुन्ड मिली जेनको पर यो लिख्यो से। “जोन ला आमी नही जानासेजन वा परमेस्वर काजी,” तुमी लोक उ परमेस्वर लक बेखबर सेव जेकी पुजा करासेव, “मी वोकी खबर तुमला आयकावसु।” ");
INSERT INTO pwr_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","जेना परमेस्वर न दुनिया अना वोको मा जोन काही सेत उ सब बनाईसेस, अखीन जोन बादर अना धरती को पिरभू से उ मानूस को हात लक बनाया हुया मंदिर मा नही रव्ह। ");
INSERT INTO pwr_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","अना वोला कोनी चीज को कमी नहाय, ता वोको मानूसगिन को हात लक सेवा नही होय सका। काहेकी उ ता खुदच सबला सांस अना सब कही देवासेत। ");
INSERT INTO pwr_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","वोना एकच मानूस लक सबरी मानूस लोक ला पैदा करीस। जोनलक वय सारी धरती पर बस जाय। अना वोना च मानूस गीन की बेरा पक्को कर देइसेस। अना जहान वय सेत वोना जघा मा रव्हन की सीवमेंडो ला पक्को करीसेस। ");
INSERT INTO pwr_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","एको मतलब यो सेत का वय परमेस्वर को खोज करे। अना वोला खोजता हुया हो सक सेत उनला मिल जाय। एतरो होवन मा भी उ आमरो लक दुहुर नाहती। ");
INSERT INTO pwr_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","काहेकी वोकोच मा हमी जित्तो सेजन। अना वोमच आमरो हिंड़नो-फिरनो सेत। अना वोच मा आमरो जिंदगी सेत। असो परकार तुमरो कितरो लिखनवारा ना लिखि सेत, का अमी वोको च सन्तान सेजन। ");
INSERT INTO pwr_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","मंग अमी परमेस्वर को लेकरा-बारा आजन। एकोलाय अमीला यो समझनो जरुरी सेत का उ परमेस्वर सो-खूरो या गोटा की मुरत नाहती, जोनला मानुसगिन बनावसेत। ");
INSERT INTO pwr_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","यो गोस्टी ला जूनो जमाना मा परमेस्वर ना अगियानी समज के टाल दियोसेत। पर अबा सब मानुसगिन ला यो अगियानी पन लक हिटके मन मा सही बिचार आनन को मौका देवासेत। ");
INSERT INTO pwr_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","काहेका हरेक मानूस काजी वोना एक दिवस ठहरायोसेस, का वोना मानूस लक सब संसार को मानूस को धरमी पन लक न्याय करहेत। जेना वोला पयले लक ठहरायो। अना वोला मारयो मा लक जित्तो करीस, “एना गोस्टी ला पक्को करीसेस।” ");
INSERT INTO pwr_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","जबा उनला मरयो हुयो मा लक जित्तो उठनो की गोस्टी आयकिस। तो उन मा लक काही तो वोको हासी उडावन लगीन बल्की काही न कहिन हमी यो तोरो पिरवचन मघा आयकबीन। ");
INSERT INTO pwr_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","अना पौलुस उनको बीच लक चली गयो। ");
INSERT INTO pwr_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","मंग कोनी मानूस वोको संग भय गयो, अना बिस्वासी बन गयो। जसो न्यायालय को मुखिया दियोनिसियुस, दमरिस नाव की आई-माई अखीन काही मानूस। ");
INSERT INTO pwr_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","एको बाद पौलुस अथेने नगर छोडके कुरिन्थुस नगर चले गयो। ");
INSERT INTO pwr_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","जहान अक्किला नाव को यहूदी लक वोकी भेंट भई। अक्विला पोंतुस को रव्हन वारा होतो। जोन अबा हाल च मा, अपरी बायको प्रिस्किल्ला को संग कछुक बेरा पयले इटली देस लक आयो होतो। उनना इटली यो काजी सोड़यो होतो, की राजा क्लौदियुस न सब यहूदीगिन ला रोम देस लक हेड़ दियो होतो। एकोलाय पौलुस वोको लक मिलन गयो। ");
INSERT INTO pwr_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","अखीन वोको संग रव्हन अना काम करन लग्यो। काहेकी वय पन्डाल बनावन को एकच धंधा करत होतीन। ");
INSERT INTO pwr_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","पौलुस हर एक बिसराम दिवस पर यहुदी सभाघर मा तरक-बेस करत अना यहूदी गीन अना यूनानी गीन ला समझावन को जतन करत होतयो। ");
INSERT INTO pwr_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","जबा सीलास अना तीमुथियुस मकीदुनिया लक आइन। ता पौलुस गोस्टी आयकावन मा अपरो पूरो पुरुप देवन लगीस। अना यहूदी गीन को आयकावायके का यीसु च मसीह से। ");
INSERT INTO pwr_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","जबा वय लोक पौलुस को बिरोध करनो अना निन्दा करन लगीन। ता वोना अपरा कपरा की बारू ला झड़ायके उनको लक असो कहीस, तुमरो जान को जवाब दार तुम्हिच सेव। अबा अमी गैरयहुदी गिन जवर जाबिन। ");
INSERT INTO pwr_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","असो सांगके पौलुस वहान लक चले गयो। अना वा तितूस युस्तूस नाव को एक गैरयहुदी को घर मा गयो। जेनको घर यहुदी सभा घर को कगर होतो। ");
INSERT INTO pwr_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","यहुदी सभाघर को मुखिया क्रिस्पुस न अपरो सबरी खानदान को संग पिरभू मा बिस्वास करीस। अना उनको संग लगत कुरुन्थी को यहुदीगिन पौलुस की गोस्टी आयक के बिस्वास करीन अना बप्तिस्मा लेईन। ");
INSERT INTO pwr_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","पिरभू न एक रात को दरसन देके पौलुस लक असो कहीस, नोको हार, पर बोलत जाय अना उगो-मुगो नोको रव्ह। ");
INSERT INTO pwr_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","“मी तोरो संग सेव, कोनी भी तोरो पर धावा नही करहेत कोनी तोरो नुकसान नही कर पाहेत। काहेकी येनाच नगर मा लगत सा लोक मोरा अपरा सेत।” ");
INSERT INTO pwr_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","पौलुस लोकगीन ला परमेस्वर को बचन की सिक्सा देतो हुयो, वहान डेढ़ बरस रहयो। ");
INSERT INTO pwr_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","जेना बेरा गल्लियो अखया यूनान देस को मोठो राजा होतो। यहूदी गीन न मिलजुल के पौलुस पर हमला करीन। अना वोला नियाव आसन को पुड़ा पेस करीस। ");
INSERT INTO pwr_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","उनना यो अरोप लगाईन “यो मानूस परमेस्वर ला मनान को असो नियम सिकावासे जोन मोसे को नियम को बिरुध से।” ");
INSERT INTO pwr_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","पौलुस अबा अपरो सफाई मा बोलन वालो होतो। का गल्लियो न्यायी न यहूदी गीन लक कहीस, “अरे यहूदिगीन! अदी यो अन्याव या अपराध को मामला होतो, त सही मा मि तुमरी गोस्टी आयकतो।” अना नियाव को साजरा कारन होतो। ");
INSERT INTO pwr_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","पर यो झगड़ा-राड़ सबद नाव अना तुमरी मोसे को नियम लक सम्बन्ध राख सेत। त तुमी जेनो मी असी गोस्टी को न्याय करनो नही चाव्हसेऊ। ");
INSERT INTO pwr_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","अना यहुदिगिन ला नियाव आसन लक बाहेर हेड देईस। ");
INSERT INTO pwr_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","तब सब न सभाघर को मुखिया सोस्थेनेस ला धरके दबोचिन नियाव आसन को पुड़ा पीटीन, पर गल्लियो न येको पर जरासो भी धियान नही देईस। ");
INSERT INTO pwr_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","पौलुस लगत दिवस तकन कुरिन्थुस को बिस्वासी गिन को संग मा रहयो। मंग उ भाऊ गीन लक बिदाई लेके नाव को रस्ता लक सीरिया जावन लगयो। वोको संग प्रिस्किल्ला अना अक्किला भी होतिन। पौलुस ना किंखिया मा आपरो डोस्की मुन्डवाय लियो काहेका वोना एक मन्नत मानयो होतो। ");
INSERT INTO pwr_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","अना जब वय इफिसुस नगर आइन ता पौलुस न प्रिस्किल्ला अना अक्विला ला वहान छोड़ देईस। अना खुद यहुदी सभाघर मा जायके यहूदी गीन को संग बैस करीस। ");
INSERT INTO pwr_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","उनना पौलुस लक बिनती करीन, “तु काही बेरा अखीन रव्हजोस।” पर पौलुस नही मानयो। ");
INSERT INTO pwr_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","अना उनको लक यो साग के बिदाई लेइस, “अदी परमेस्वर चाव्हसे ता मी तुमी लोकगीन को जवर मंग आहिन।” उ इफिसुस छोड़के जहाज मा समुंदर को रस्ता लक चली गयो। ");
INSERT INTO pwr_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","कैसरिया जहाज घाट मा उतरके वहान लक उ कलीसिया को धन्यवाद करन गयो, अना येरुसलेम लक मोठो नगर अन्ताकिया चली गयो। ");
INSERT INTO pwr_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","काही बेरा बितन को बाद वोने बिदाइ लेइस। अना गलातिया अना फ्रुगिया को छेतर लक होतो हुयो एक जघा लक दुसरो जघा मा हिंडता हुयो। सब चेला गीन को बिस्वास मा पूरो पक्को करतो रहयो। ");
INSERT INTO pwr_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","वोनोच बेरा वहान अपुल्लोस नाव को यहूदी होतो। उ सिकन्दरिया को बिस्वासी होतो। बोलन मा विदवान होतो। अना वोला पवितर गिरंथ को लगत गियान होतो। उ इफिसुस नगर आयो। ");
INSERT INTO pwr_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","वोला पिरभू को मारग को सिक्सा भेटयो होतो। उ लगत सतरक होयके जो सच सेत। वोला साजरा लक सिकावत होतो। अना यीसु को बिसय मा साजरी गोस्टी सिकावत होतो। वोला केवल योहन को बप्तिस्मा मालुम होतो। ");
INSERT INTO pwr_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","उ यहुदी सभाघर मा बेधड़क बोलन लगयो। प्रिस्किल्ला अना अक्किला वोकी सिक्सा आयकन को बाद वोला अपरो संग ले गईन। अना उनना लगत साजरो तरीका लक वोना परमेस्वर को सिधो रास्ता ला समझाइन। ");
INSERT INTO pwr_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","जबा अपुल्लोस आखया ला जावनो चाहिस ता बिस्वासी हुन ना वोला जोस लक भर देइन। अना वहान को बिस्वासी गिनला स्वागत करन लाय चिठ्ठी धाड़ीन। जब उ वहान गयो तो उ वहान को लोकगिन लाय लगत मदद करन वारा साबीत भयो। जोन ना परमेस्वर को किरपा लक बिस्वासी बन गयो होतिन। ");
INSERT INTO pwr_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","काहेकी वोना पवितर गिरंथ लक सबुत देदे के यहूदी गीन को तोन्ड बंद करत होतो। अना गिरंथ लक समझावत होतो का यीसु च मसीह आय। ");
INSERT INTO pwr_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","वोनो बेरा अपुल्लोस कुरिन्थुस नगर मा होतो। तबा पौलुस भीतरी परदेसगीन को लक यातरा खतम करके इफिसुस आइस। वहान वोला काही चेला गीन मिलीन। ");
INSERT INTO pwr_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","पौलुस न उनको लक पुछिस “का बिस्वास करत बेरा तुमी लोक गीन को पवीतर आतमा मिली से?” उनना जवाब देईन, “हमी न यो नही आयकीसेजन का पवीतर आतमा होवासे?” ");
INSERT INTO pwr_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","उ तबा उ कहीस “तो तुमिना कसो बप्तिस्मा लियो से?” उनना कहीन “योहन को बप्तिस्मा।” ");
INSERT INTO pwr_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","मंग पौलुस न असो कहीस, योहन ना असो सांगत पस्तावा को बप्तिस्मा दियो होतो। का “जोन मोरो मंघा आवन वालो से वोको पर, मजे यीसु पर भरोसा करनो।” ");
INSERT INTO pwr_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","उनना असो आयके पिरभू यीसु को नाव पर बप्तिस्मा लेइन। ");
INSERT INTO pwr_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","जबा पौलुस न वोको पर हात राखीस, त पवीतर आतमा उनको पर उतर गयो। अना वय अलग-अलग बोली बोलन लगीन। अना भविस्यवानी सांगन लगीन। ");
INSERT INTO pwr_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","वय पूरो मिलायके करीब बारा मरद-माना होतीन। ");
INSERT INTO pwr_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","मग पौलुस तीन महिना तकन सभाघर जावत रहेयो उ “परमेस्वर को राज” को बिसय बेधड़क बोलत अना यहूदिगीन ला समझावत होतो। ");
INSERT INTO pwr_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","पर उनमा लक काही लोक जिद्दी होतीन। वय बिस्वास नही करीन। बल्कि पंचायत मा एना रस्ता की निन्दा भी करन लगीन। एकोलाय पौलुस न उनला छोडके, अपरा चेलागीन ला वहान लक हटाय लेईस। उ हरदिन तुरन्नुस सिक्सा घर मा चरचा बिचार करन लग्यो ");
INSERT INTO pwr_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","असो काम दूई बरस तकन चलतो रहयो, एको फर यो भयो का आसिया सब रव्हन वारा न चाहे वय यहूदी होय, या त यूनानी, सब न पिरभू को बचन आयक लेइन। ");
INSERT INTO pwr_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","परमेस्वर को पौलुस कन लक अजब-गजब ताकत को काम, अना अचंभा करवात होतो। ");
INSERT INTO pwr_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","यहान तकन की वोको छुयो अगोछा अना रुमाल बिमार गिन को कठा लिजा के छिवात होतिन अना उ साजरा भयि जात होतो। अना भूत-पलित परात होतिन। ");
INSERT INTO pwr_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","काही यहूदी गिन जोन भूत-पलित हेड़त अना इतानी उतानी हिंडत होतिन। असो करन लगीन की, जोनमा भुत-पलित होतिन। उन पर यीसु को नाव आन के फूक मारके असो कव्हन लगीन। “मी तुमला वोना यीसु को नाव मा जोनको परचार पौलुस करासे मी तुमला हुकूम देवासू।” ");
INSERT INTO pwr_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","स्किवास नाव को एक यहुदी मुखिया पुजारी को सात टूरा भी असोच करत होतीन। ");
INSERT INTO pwr_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","कोनी फिरयाद पर भूत-पलित न उनला जवाब देईन, “मी यीसु ला जानासेऊ, पौलुस कोन आय यो भी जानासेऊ, पर तुमी लोक कोन आव?” ");
INSERT INTO pwr_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","अना उ मानूस जोन मा भूत-पलीत होतीन उन को पर झपटयो अखीन उनला हिन्सा लक कब्जा मा करके उन को पर असो मजबूत ताकत दिसायो। का वय नंगा अना घायल होयके परान लगीन। ");
INSERT INTO pwr_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","इफिसुस का रव्हन वारा सबा यहूदी अना गैरयहुदी गिनला मालूम भय गयो। अना सबमा भेव भर गयो। अना पिरभू यीसु को नाव को बड़ाई भयी। ");
INSERT INTO pwr_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","उनमा लक लगत सा जोन ना बिस्वास करी होतिन। अपरो लक कियो खोटो काम ला सबको पुड़ा मान लेइन। अना उनला परगट कर देईन। ");
INSERT INTO pwr_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","लगत सा लोकगीन न जोन जादू-टोना करत होतीन। वय अपरी-अपरी जादू की किताब ला आनके जमा करीन। अना सब को पुड़ा जलाय देईन। जबा उनना वोका हिसाब लगाइन, ता करीब पन्नास हजार खुरो का मोहर को बरोबर हिटयो। ");
INSERT INTO pwr_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","ऐना पिरकार लक पिरभू को बचन मजबूत लक फैलत गयो। ");
INSERT INTO pwr_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","जबा या घटना घट चुकयो त पौलुस न मकीदुनिया अना अखया लक होतो हुया। येरुसलेम नगर जानो को मन मा ठानिस। अना कहीस वहान पहुचानो को बाद मोला रोम देस ला भी चोवनो जरुरी से। ");
INSERT INTO pwr_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","वोना आपरो दुई सायता करन वालो तीमुथियुस अना इरास्तुस ला मकीदुनिया धाड़ दियो। के वय खुदच काही बेरा तकन आसिया मा रहयो। ");
INSERT INTO pwr_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","अना वोना बेरा पिरभू को ऐना मारग को कारन लगत मोठी आफद इफिसुस मा भयी। ");
INSERT INTO pwr_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","देमेतिरयुस नाव को एक सोनार होतो। जोन अरतिमिस देवी खुरो को भान्डो बनावत होतो। जोन लक कारीगरगीन ला लगत फायदा भेटत होतो। ");
INSERT INTO pwr_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","वोना उनला अखीन दुसरो ऐना धंधा लक जुड़यो कारीगार गीनला जमा करके कहीस, “अरे भाऊ तुमी जानासेव का हमारो यो धंधा लक लगत आमदानी होवासेत।” ");
INSERT INTO pwr_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","अना तुमी चोईसेव अखीन आयकी सेव का न केवल इफिसुस मा नही पर पूरो आसिया मा एना पौलुस न लगत सा लोकगीन ला बहला फुसला दियो से। उ कव्हसेस का हात को बनायो देवता सच्चो नाहती। ");
INSERT INTO pwr_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","एको लक नही केवल योच भेव सेत का आमरो धन्धा बदनाम होहेत। बलकी मोठी देवी अरतिमिस को मंदिर को मान खोवन को भी भेव सेत। अना जेनो देवी की पूजा आसिया अना दुनिया को सबच लोक करासेत। वोको मान छिन्डन को भेव सेत। ");
INSERT INTO pwr_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","जबा उनना असो आयकीन त लोक गुस्सा लक भर गईन। अना चिल्लाय-चिल्लायके कव्हन लगीन, “इफिसिलोक गीन की देवी अरतिमिस मोठी से” ");
INSERT INTO pwr_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","नगर मा हुल्लड़ मच गयो अना लोकगीन न मकिदुनिया लक आयो गयुस अखीन अरिस्तखुरस नामको पौलुस को संगी यातरी गिनला दबोच लेइन। अना वय रंगसाला पराय गईन। ");
INSERT INTO pwr_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","पौलुस न जमघट को पूड़ा जावनो चाहत होतो। पर चेला गीन न वोला नही जान देईन। ");
INSERT INTO pwr_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","काही पिरान्त को अधिकारी गीन जोन वोका सँगी होतीन। खबर धाडिन का उ रंगसाला मा जानो को जोखिम नोको उचलेत। ");
INSERT INTO pwr_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","अना कोनी काही चिल्लाय रही होतीन। अखीन कोनी काही, काहेकी सभा मा उथल-पुथल मची होती। लगत सा लोकगीन ला यो भी मालुम नही होतो का हमी जमा कायलाई भई सेजन। ");
INSERT INTO pwr_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","तबा यहुदीगिन ना भीड़ ला सान्त करन लाय सिकन्दर को नाव सुझाइन। तबा सिकन्दर न हात उभो करके लोकगिन को पूड़ा बचाव पक्स जाहिर करनो चाहयो। ");
INSERT INTO pwr_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","पर जबा लोकगीन न चीन्हिन का यो तो यहूदी से। ता लगभग दूई घंटा तकन सबच का सब एकच आवाज लक चिल्लावत रहीन। “इफिसिलोक गीन की अरतिमिस देवी मोठी से” ");
INSERT INTO pwr_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","तबा नगर को दिवान न जमघट ला उगो-मुगो करके कहीस “अरे इफिसिलोक गीन असो कोनतो मानूस से जोन नही जानासे का इफिसुस को यो नगर मोठी देवी अरतिमिस को मंदिर अना बादल लक पडी हुई पवितर गोटा को रखवालो से?” ");
INSERT INTO pwr_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","एना गोस्टी को कोनी तोड़ नाहती। त तुमी उगो-मुगो रहवो अना उताली मा काही नोको करो। ");
INSERT INTO pwr_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","काहेकी तुमी एना मानूसगिन ला धरके आनीसेऊ। जोन न त हमरो मंदिर गीन का लुटेरा सेत, ना आमरो देवी का निन्दा करनवारा सेत। ");
INSERT INTO pwr_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","मंग अदी देमेतिरयुस अना वोना कारीगीर ला जोन वोको संग सेत। कोनी मानूस लक कोनी सिकायत सेत त न्यायालय खुल्लो सेत। अना मोठो राजपाल मोजूद सेत। वहान वय एक दुसरो पर नालीस करो। ");
INSERT INTO pwr_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","पर तुमी एको लक जादा जाननो चव्हसेत ता एको फैसला नागरिक अदालत मा होहेत। ");
INSERT INTO pwr_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","काहेका अबा जोन काही भी सेत वोको अनुसार अमीला यो गोस्टी को भेव सेत। आज को बलवा को ठेका कहिं आमरो डोस्की मा नोको फूटे। काहेका यो दंगा को कोनी कारन नाहती। ");
INSERT INTO pwr_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","वोना ऐतरो कहेके पंचायत ला खत्म कर देइन। ");
INSERT INTO pwr_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","हुल्लड़ सान्ती होवनो को मघा पौलुस न चेला गीन ला बुलावन धाडिस। उनला बड़ावा को अना मजबूत होवन को गोस्टी समझायो। मंग वोना सार होयके मकीदुनिया कन चली गयो। ");
INSERT INTO pwr_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","वोना सबच छेतर को दौरा करयो। अना सब लोकगिन ला सन्देस देयके जोस मा भरतो यूनान पहुचियो। ");
INSERT INTO pwr_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","वहान वोना तीन महीना बीताईस अना जबा उ जहाज लक सीरिया जावन वालो होतो। पर जबा वोला मालुम भयो का यहूदीगीन वोको बिरोध मा साजीस करयो सेत। तो उ पिलान बदल के मकिदुनिया लौटन को इरादा बनायो। ");
INSERT INTO pwr_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","बिरीया को रव्हन वालो पुर्रुस को टूरा सोपतरुस, थिस्सलुनीकिया को रहवन वालो अरिस्तखुरस, सिकुन्दुस, दिरबे को गयुस, तीमुथियुस अना एसिया को तुखिकुस अना तुरफियुस वोको संग होतो। ");
INSERT INTO pwr_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","पर ये लोक हमरो लक पुड़ा पैदल चली गईन अना तोरआस मा हमारो बाट जोह रहया होतीन। ");
INSERT INTO pwr_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","अखमीरी भाकर को तिहार को मंग हमी फिलिप्पी लक जहाज लक हिटके अना पाँच दिवस मा उनको जवर तोरआस पहुचयो। अना वहान सात दिवस तकन रहयो। ");
INSERT INTO pwr_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","सनीवार को राती हफ्ता जबा हमी भाकर टोड़न को लाई इक्कठा भयो। त पौलुस गोस्टी करन लगयो। उ दुसरो दिवस जावन वारा होत्यो। एकोलाय अरधी रात तकन सिक्सा देवतो रहयो। ");
INSERT INTO pwr_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","जो वरता पाटन मा हमी इक्कठा हुया होता। वहान सिड़ीगिन मा लगत सा टेमा पेटायो होतीन। ");
INSERT INTO pwr_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","युतखुस नाव को एक मानूस होत्यो जोन खिड़की पर बस्या हुया। जप को झोक मा होत्यो। जबा पौलुस उसीर तकन जोर लक बोलता रहयो। त वोला जप आय गई अना उ दुय मंजिला लक खाल्या पड गयो। अना मरयो हुयो उचलेयो गयो। ");
INSERT INTO pwr_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","पर पौलुस खाल्या उतरयो अना वोको पर झुक गयो मंग अना गरो लगायके कहीस “घबरावो नोको काहेकी वो जित्तो सेत।” ");
INSERT INTO pwr_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","अना वरता जायके भाकर तोडीस, अखीन खायके येतरी देर तकन उनको लक गोस्टी करता रहयो का फर-फर भय गयो मंग उ चली गयो। ");
INSERT INTO pwr_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","वय वोना जित्तो टूरा ला घर ले गइन एकोलक उनला लगत सान्ती भेटयो। ");
INSERT INTO pwr_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","अमी जहाज लक पयले पहुचयो। अना अस्सुस जावन लाय हिट गयो। अमिला उतानी पौलुस ला जहाज मा चघानो होतो। काहेका उ रेगत-रेगत वहान जावन को योजना बनायो होतो। ");
INSERT INTO pwr_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","जबा उ अमिला अस्सुस मा मिलयो त हमी वोला जहाज मा चघायके मितुलेने मा जावन लगयो। ");
INSERT INTO pwr_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","वहान लक जहाज खोलके हमी दुसरो दिवस खियुस को पुड़ा पहुचया। मंग परो दिवस अमी सामुस मा आय गयो। मंग वोको दुसरो दिवस मिलेतुस मा पहुचयो। ");
INSERT INTO pwr_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","काहेकी पौलुस जहान तकन होय सके पेन्टि कोस्त को तिहार को कारन हड़बड़ी करत होतो। उ असो पक्को करयो होतो। का इफिसुस मा रुकयो बिना पूड़ा येरुसलेम चलयो जाहेत। जोनलक आसिया मा बेरा बितानो ना पड़े। ");
INSERT INTO pwr_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","वोना मिलेतुस लक इफिसुस मा कहेके धाडिस अना कलीसिया ला बुजरुक गिनला बुलवाइस। ");
INSERT INTO pwr_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","जबा वय वोको जवर आइन। त वोना कहीस तुमी जानासेव का पहेलो च दिवस लक जबा मी आसिया मा पहुचयो। मी हर बेरा तुमरो संग कोनो पिरकार लक रहीसेऊ। ");
INSERT INTO pwr_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","अना मोठी गरीबी लक अखीन आवा सेऊ मी आँसू बोहाय-बोहाय के मी सेवा करत रहयो। जोन यहुदीगिन को साजिस को कारन मोरो पर आयो होतो। ");
INSERT INTO pwr_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","अना जोन-जोन गोस्टी तुमरो हित की होतीन उनला सांगयो अना लोकगीन को पुड़ा अखीन घरन-घर सिकावन लक कभीच न हिचकयो। ");
INSERT INTO pwr_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","यहूदी अना यूनानी गीनला समान भाव लक मी मनला मुरकाके परमेस्वर कन मुड़न लाय कव्हसू, अना आमरो पिरभू यीसु मसीह मा विस्वास को लाय मी चेताय रहयो सेऊ। ");
INSERT INTO pwr_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","अबा चोवो मी पवितर आतमा को अधीन होवके येरुसलेम नगर मा जावासू। अना नही जानासू का मोरो पर वहान काजक-काजक बीतेत। ");
INSERT INTO pwr_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","मी बस एतरो जानासू का हरेक नगर मा पवीतर आतमा चेताय रव्हसे। क वहान बेड़ी अना दुख तोरो लाई तैय्यार सेत। ");
INSERT INTO pwr_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","पर मी जान ला किमती नही समझसू। मी तो बस उ दौड अना वोकी सेवा ला पूरी करनो चाव्हसू। जोन मोला पिरभू यीसु देइसेस। उ यो से का परमेस्वर को दया मा गवाही देवनो। ");
INSERT INTO pwr_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","अबा मोरो तोन्ड मग नहि दिसेत। काहेका मी परमेस्वर को राज को परचार करासु। ");
INSERT INTO pwr_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","एकोलाय मी आज को दिवस तुमरो लक मुनादी करासू। का तुमरो मा लक कोनी को खून को दोसी नही सेऊ। ");
INSERT INTO pwr_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","काहेकी मी परमेस्वर को सबरी मकसद लक तुमला पूरो रीत लक सांगन नही हिचकयो। ");
INSERT INTO pwr_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","एकोलाय अपरी, अना पूरो हेड की चोकसी करो, जिनमा पवीतर आतमा न तुमला कलिसीया को मुखिया ठायराइसेस। जोनलक तुमी परमेस्वर की कलीसिया की देख-रेख करो, जेनला वोना अपरो खून लक मोल लेई सेस। ");
INSERT INTO pwr_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","मी जानासेऊ का मोरो जावन को बाद तुमरो बीचमा हिंसक बीघा आहेत, जोन हेड़ ला नही छोड़ेत। ");
INSERT INTO pwr_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","असो बेरा आहेत का तुमरो बीच मा लक असो मानूस उठेत, अना लोकगीन ला अपरो मंघा खीचन लाई बचनला तोड़ मरोड़ के सांगेत। ");
INSERT INTO pwr_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","एकोलाय जागतो रहेयो अना हेत करो। का मी न तीन बरस तकन रात दिवस आसू बोहाय-बोहायके हर एक ला चेतावनी देनो नही छोडो। ");
INSERT INTO pwr_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","अना अबा मी तुमला परमेस्वर को, अना वोको दया को वचन ला सौप देवासू। जोन तुमरी उन्नती कर सकसे, अना सब पवीतर किया गयो तुमरो लोकगीन ला वारसाना अधिकार दिलाय सकसेत। ");
INSERT INTO pwr_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","मी न कोनी को सोना अना खुरो मुन्दरो अखीन कपरा को लोभ नही करयो। ");
INSERT INTO pwr_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","तुमी खुदच जानासेव का मी एना हात लक मोरी अना संगी गीन की जरुरत की सेवा ला पूरो करीसेऊ। ");
INSERT INTO pwr_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","मी न आपरो हरेक काम लक बतलायो। का महेनत करतो हुयो कमजोर गीन ला सम्भालनो। अना पिरभू यीसु को बचन ला हेत राखनो जरुरी सेत जसो वोना खुदच कहिसेत “लेवनो लक देवनो धन्य से।” ");
INSERT INTO pwr_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","असो सांगके टोंगरा टेकके सब झन पिराथना करीन। ");
INSERT INTO pwr_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","तबा वय सब रोईन अना पौलुस को गरो ला धरके वोला भेटन लगीन। ");
INSERT INTO pwr_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","वय खासकर यो गोस्टी लक दुखित होतिन का पौलुस ना असो कहयो होतो का तुमला मी अबा कभीच नही भेटिन। तबा सबा लोकगिन वोला जहाज तकन पहुचाइन। ");
INSERT INTO pwr_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","जबा हमी न बिदाई आन के अमीना सागर मा आपरो जहाज खोल दियो। अना सरको अमी कोस पहुचयो। दुसरो दिवस रुदुस मा, अना वहान लक पतरा पहुचयो। ");
INSERT INTO pwr_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","वहान अमीना एक जहाज लियो जोन फीनीके मा जावता होतो। ");
INSERT INTO pwr_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","जबा साइप्रस चोयो त हमी न वोला डाक्यो हात छोड़के अखीन सीरिया कन मुरक गयो। काहेकि वहान जहाज को माल उतरनो होतो। एकोलाय अमी उतानी उतर गयो। ");
INSERT INTO pwr_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","उतानी अमीला चेलागीन भेटयो। अना अमीला सात दिवस तकन रहेया। उनना आतमा को सिकायो पौलुस ला येरुसलेम जावनो लाय रोकिन। ");
INSERT INTO pwr_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","पर उतानी रुकन को पूरो बेरा बिताय के वहान लक चली गया। अना सब आई-माई अना टूरा-टारी सहीत हमला नगर को बाहेर तकन पहुचाइन। मगं सागर को कगर मा अमी टोंगरा टेकके पिराथना करया। ");
INSERT INTO pwr_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","तबा उनलक सार होयके हमी त जहाज पर चघ गयो। अखीन वय अपरो-अपरो घर लवट गईन। ");
INSERT INTO pwr_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","सूर लक जल यातरा लक अमी पतुलिमयिस मा उतर गयो अमी उनको संग एक दिवस रुकयो। ");
INSERT INTO pwr_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","दुसरो दिवस अमी वहान लक चलके कैसरिया मा आयो। अना फिलिप्पुस साजरी खबर सांगन वालो को घर मा जोन सात बेचयो गयो एक होत्यो। जायके वोको घर मा रहेया। ");
INSERT INTO pwr_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","वोकी चार कुवारी टूरी होतीन, जोन भविस्यवानी करत होती। ");
INSERT INTO pwr_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","जबा हमी वहान लगत दिवस रह चुकया। त अगबुस नाव को एक भविस्यवक्ता यहुदिया लक आयो। ");
INSERT INTO pwr_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","वोना हमरो जवर आयके पौलुस को गमछा लेईस अना अपरो हात पाय बांधके कहीस “पवीतर आतमा असी कव्हसेस, का जेना मानूस को यो गमछा से वोला येरुसलेम मा यहूदी गीन एना रीती लक बांधेत अना दुसरो लोकगीन को हात मा सोफेत।” ");
INSERT INTO pwr_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","जबा हमी एना गोस्टी ला आयकाया, त हमी अना वहान का लोकगीन न वोको लक बिनती करीन का येरुसलेम नगर मा नोको जाय। ");
INSERT INTO pwr_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","पर पौलुस न जवाब देईस “तुमी का करासेव का रोय-रोयके मोरो दिल तोडासेव? मी त पिरभू यीसु को नाव को लाई येरुसलेम नगर मा केवल बांधयो जानोच को लाई नही, पर मरन लाई तैय्यार सेव।” ");
INSERT INTO pwr_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","जबा वोना नही मानीस। त हमि यो कहेकर उगो-मुगो भय गयो, का “पिरभू को इक्सा पूरी होय।” ");
INSERT INTO pwr_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","एना दिवस को मघा हमी न तैय्यारी करीयो अना येरुसलेम नगर ला चली गयो। ");
INSERT INTO pwr_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","कैसरिया लक भी काही चेला हमरो संग भय गईन। अना हमी मनासोन नाव को साइप्रस को एक जुनो चेला को घर आया। का हमी वोको संग वहान रुकनो होतो। ");
INSERT INTO pwr_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","जबा हमी येरुसलेम मा पहुचयो ता भाऊगिन मोठी खुसी ले हमरो लक मिलयो। ");
INSERT INTO pwr_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","दुसरो दिवस पौलुस आमरो संग याकूब ला भेटयो। वोको संग सबा बुजरुक गिन होतीन। ");
INSERT INTO pwr_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","तबा पौलुस ना भी उनको सतकार करीस अना वोना आपरो काम गिनको जोन परमेस्वर कन लक गैरयहुदी मा करयो होतो, एक-एक करके सबच सांगिस। ");
INSERT INTO pwr_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","जबा उनना असो आयकीन ता वय परमेस्वर को बड़ाई करीन। मंग वोको लक कहीन, “अरे भाऊ तुम देखासेस का यहूदीगीन मा लक कई हजार न बिस्वास करीन।” अना मोसे को नियम लाई सब धुनमा सेत। ");
INSERT INTO pwr_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","उनला तोरो बिसय मा सिकायो गयो से। का तु दुसरो गैर यहुदीगिन को बीच रव्हन वालो यहूदीगीन ला, मंग मोसे भविस्यवक्ता को नियम ला सोड़न कव्हसेत। अना उनलक तु कव्हसेस का अपरा टूरा गीन को खतना नोको करावो, अना न रिती लक चलो। ");
INSERT INTO pwr_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","त मंग का करयो जाय? लोक जरुर आयकेत का तु आइसेस। ");
INSERT INTO pwr_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","एकोलाय जोन हमी तोरो लक कव्हसेजन उ कर। हमरो यहान चार मानूस सेत जेना मन्नत मानीसेत। ");
INSERT INTO pwr_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","उनला संग ले जाय अखिन उनको संग पवितर करनो को जलसा मा सामिल भयि जा अना उनको खरचा उठाय का वय भी आपरो डोस्की मुंडवा लेय। तब सब जान जाहेत का उनना तोरो बारेमा जो आयकिसेत उ सब सच नाहती। पर तु आपच मोसे को नियम अनुसार जिंदगी जिओ सेत। ");
INSERT INTO pwr_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","जहान तकन बिस्वास करनवालो गैर यहुदीगीन को सवाल सेत। अमीना उनला एक चिठ्ठी मा लिख्यो धाडिसेस। का वय मुरत गीन को पुड़ा चघायो हुयो जेवन, गरो मुरकेटो जनावर को मांस, अना खून नोको जेवे। अखीन छिंनरापन लक बचयो रहवो। ");
INSERT INTO pwr_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","असो परकार पौलुस वय मानूस गीनला आपरो संग ले गयो। अना दुसरो दिवस उनको संग पवीतर होयके मंदिर मा गयो। अना उ सांग देईस का उनमा लक हर एक को लाई चढावा चघायो जानो को दिवस कबा पूरो होहे। ");
INSERT INTO pwr_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","जबा वय सात दिवस पूरो होवन पर होतीन त आसिया पिरान्त का यहूदी गीन न पौलुस ला मंदिर मा चोवके सब लोक गीन ला भड़काइन अना असो चिल्लायके वोला धरलेइन। ");
INSERT INTO pwr_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","अरे इसरायली गीन मदद करो। यो वोच मानूस आय, जोन आमरो नियम को अना मंदिर को बिरोधमा सिकावत हिंड़सेत। यहान तकन का गैरयहुदी गीन ला येनो मंदिर मा आनके पवीतर जगह ला भी असुध्द कर देइस। ");
INSERT INTO pwr_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","उनना एकोलाय असो कव्हयो होतो, का पयले इफिसि लोकगीन त्रुफियुस ला वोको संग नगर मा देखी होतीन। अना यो समझी होतीस का पौलुस न वोला मंदिर मा आनीसेस। ");
INSERT INTO pwr_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","तबा सबरी नगर मा हडकम मच गई। अना लोकगीन पराय-परायके इकक्ठा भईन। अना पौलुस ला धरके मंदिर को बाहेर घसीटके आनीन। अना सटाकने बेसकुड़ बंद कर देइन। ");
INSERT INTO pwr_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","जबा वय वोला मर डाकनो चाव्हत होतीन। त सेना को नायक ला खबर पहुचाइन। का येरुसलेम मा उथल-पुथल मच रहयो होतो। ");
INSERT INTO pwr_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","तबा सौ सिपाई को अधिकारी सिपाई लेके सटाकने आयो ता यहुदीगिन जोन पौलुस ला मारत होतिन मारनो बंद कर देइन। ");
INSERT INTO pwr_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","तबा सेना को अधिकारी पौलुस जवर आयो, अना बन्दी बना लियो। वोना वोला दुई हतकड़ी लक बांधनो की हुकूम देके ना पुसन लगयो “यो कोन से? अखीन एना न का करीसेस?” ");
INSERT INTO pwr_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","पर जमघट मा लक कोनी काही, अखीन कोनी काही, चिलावता रहेयो। जबा हुल्लड़ को मारे उ सही गोस्टी पता नही चलयो। ता वोला छावनी मा लीजान की हुकूम देइस। ");
INSERT INTO pwr_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","जबा उ सीढ़ी पर पहुचयो त फैलो हींसा को कारन वोला सिपाई गीन को सुरक्सा मा लीजानो पडयो। ");
INSERT INTO pwr_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","काहेका वोको मघा एक मोठी भीड़ वोला मार डालेयो असो चिल्लावत होतिन ");
INSERT INTO pwr_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","जबा वय पौलुस ला गढ मा लीजानो पर होतीन। त पौलुस ना कहीस का “का मी तोला काही कहूसू?” सेना को अधिकारी कहीस “का तु यूनानी जानासेस? ");
INSERT INTO pwr_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","का तु उ मिसरी तो नाहस? जोन काही दिवस पयले दंगा करवायो, होतो। अना जोन जंगल मा चार हजार आंतकी लोकगीन ला जंगल मा ले गयो होतो?” ");
INSERT INTO pwr_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","पौलुस न कहीस “मी त तरसुस को यहुदी मानूस सेव किलकिया को मानयो-जानयो नगर को रव्हन वालो सेऊ। मी तोरो लक पिराथना करासेऊ का मोला लोकगीन लक गोस्टी करन देव।” ");
INSERT INTO pwr_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","जबा वोना हुकूम देईस त पौलुस न सीढ़ी पर उभो होयके लोक गीन को हात लक ईसारा करीस। जबा उ उगो-मुगो भय गयो। त उ इबरानी बोली मा बोलन लगयो। ");
INSERT INTO pwr_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","पौलुस ना कहयो, “अगो भाउगीन अना बाप को बरौबर को नेक मानूस! मोरो बचाव मा अब मोला जोन कव्हनो से, ओला आयको।” ");
INSERT INTO pwr_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","वय असो आयके का, उ हमरो लक इबरानी बोली मा सांगासे अना उगो-मुगो भय गयो। तबा पौलुस ना कहीस। ");
INSERT INTO pwr_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","मी यहुदि मानूस सेउ। किलकिया को तरसुस मा पैदा हुयो सेउ। अना ऐना सहर मा पलियो अना मोठो भयि सेउ। गमलीएल को पाय को जवर बसके आमरो पुरखा को विधान को अनुसार कड़ाई को संगा मोरी दिक्सा भयी से। परमेस्वर को पुढ़ा मि बड़ो धुन लगायो समरपित होतो। वसोच जसो तुमी आज सेव। ");
INSERT INTO pwr_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","ऐना मारग को लोकगीन ला मिना लगत सतायो। मी ना मरदमाना अखीन आई-माई दुई ला बंदी बनायके जेलमा डाकके राखो होतो। ");
INSERT INTO pwr_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","मुखिया याजक अना बुजरुक लोक को सभा खुदच यो गोस्टी को सबूत से सकासेत। का मी दमिस्क नगर जावन लाय मी इनको लक चिठ्ठी ले के यो मारग को लोकगिन ला बन्दी बनाय के येरुसलेम आनन गयो होतो। ");
INSERT INTO pwr_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","जबा मी चलता-चलता दमिस्क को कठा पहुचयो। त असो भयो का दुफारी को बेरा होतो। बादल लक एकाएक एक मोठी उजाड़ो मोरो चारी कन चमकी। ");
INSERT INTO pwr_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","अना मी धरती पर पड़ गयो। तबच मी एक असी आवाज आयकू आयो। अरे साऊल! अरे साऊल! तु मोला कायलाई सातवसेस? ");
INSERT INTO pwr_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","तबा मी न जवाब दियो ओ पिरभू तु कोन आस? वोना मोरो लक कहीस “मी यीसु नासरी सेव जेनला तु सतावसेस?” ");
INSERT INTO pwr_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","मोरा संगी गीन न उजाडो त चोवयो मंग जोन मोरो लक सांगत होतो। वोकी आवाज नही आयकयो। ");
INSERT INTO pwr_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","तबा मी न कहेयो, “अरे पिरभू मी का करु?” पिरभू न मोरो लक कहीस “उभो होयके दमिसक मा जाय अना जोन काही तोरो करन को लाई राखीसेऊ उ तोला ला सब सांग दियो जाहे।” ");
INSERT INTO pwr_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","वोनो उजाडो को तेज को मारे मोला काही चोयो। ता मोरो संगी गीन हात धरके दमिस्क नगर ले गईन। ");
INSERT INTO pwr_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","यो सहेर मा तबा हनन्याह नाव को एक मानूस होतो। उ मोसे को नियम ला माननवालो एक नेक मानूस होतो। उ मोरो जवर आयो। ");
INSERT INTO pwr_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","अना उभो होयके मोरो लक कहीस, अरे भाऊ साऊल मंग चोवन लग, वोनच बेरा मोरा डोरा उघड गईन अना मी न वोला देखयो। ");
INSERT INTO pwr_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","तबा वोना कहीस, “आमरो आजा-पुरखागीन को परमेस्वर न तोला एकोलाय बेचीसेस का तु वोकी इक्सा ला जान, अना वोनच न्यायी यीसु ला चोव, अना वोको टोन्ड लक गोस्टी आयको। ");
INSERT INTO pwr_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","काहेकी तु ना जोन चोइसेस अना आयकिसेस। वोको लाय सब मानूसगिन को पुड़ा तु वोको गवाह होवजोस। ");
INSERT INTO pwr_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","अबा का देर करासेस? उभो होय अना बप्तिस्मा ले अखीन वोको नाव ला अपना अना अपरो पाप ला धोय डाक।” ");
INSERT INTO pwr_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","जबा मी मंग येरुसलेम नगर मा आयके मंदिर मा पिराथना कर रहयो होतो त बेसुध भय गयो। अना मी दरसन चोवयो। ");
INSERT INTO pwr_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","“का पिरभू यीसु मोरो लक कव्हसेस, येरुसलेम नगर लक फटाकने हिटी जाय।” काहेकी उ मोरो बारे मा तोरी गवाही नही मानेत। ");
INSERT INTO pwr_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","मी न कहेयो “हे पिरभू उ त आपच जानासे, का मी तोरो पर बिस्वास करनवारा ला जेल मा डाकसेत, अना जघा-जघा यहुदी सभाघर मा पीटावत होतो।” ");
INSERT INTO pwr_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","जबा तोरो गवाह स्तिफनुस को खून बोवायो जाय रहेयो होतो। तबा मी भी वहान उभो होतो। अखीन एना गोस्टी मा हिस्सेदार होतो। लोक वोला मारत होतिन, अना मी उनको कपरा की देख-रेख करत होतो। ");
INSERT INTO pwr_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","अना वोना मोरो लक कहीस चली जाय काहेकी मी तोला गैर यहुदी को जवर दुहुर-दुहुर तकन। ");
INSERT INTO pwr_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","वय ओको एना बयान तकन ता आयकत रहीन। तबा जोर लक चिल्लाय के कव्हन लगीन, “असो मानूस को धरती पर लक नास कर देव, काहेका वोकी जित्तो होवनो बेस नाहती।” ");
INSERT INTO pwr_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","जबा वय चिल्लावत अना कपरा फेकके अना बादल मा धुल उडात होतीन। ");
INSERT INTO pwr_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","त सेना को अधिकारी न कहीस “एला किला मा लीजावो, अना कोडा मारके जाचो। का मी जानु का लोक कोनतो कारन लक वोको बिरोध मा असो चिल्लावत होतिन।” ");
INSERT INTO pwr_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","पर जबा उनना वोला कोड़ा, लगावन काजी बारती लक बांधीन, तबा उभो सौ सेना को अधिकारि लक पौलुस न कहयो, “कोनी रोमी नागरिक जोन बेकसूर सेत कोड़ा लगवानो का सही सेत।” ");
INSERT INTO pwr_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","यो आयक के वा अधिकारी सौ सेना को मुखिया को जवर जायके कहीस “तु यो का करासेस? यो त रोमी मानूस से।” ");
INSERT INTO pwr_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","तबा सेना को मुखिया न पौलुस जवर आयके कहीस, मोला सांग का तु रोमी सेस? वोना कहीस “हव।” ");
INSERT INTO pwr_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","असो आयक के सेना को मुखिया न कहीस मी न लगत रुपया देके पाइसेस। “पौलुस न कहीस मी त जन्म लक रोमी सेव।” ");
INSERT INTO pwr_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","तबा जोन लोक वोला जाचन पर होतीन। वय गदने वोको जवर लक सरक गयो। अना सेना को मुखिया भी असो जानके का योच रोमी से अना मी न वोला बांधी सेव उ डराय गयो। ");
INSERT INTO pwr_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","सेना को मुखिया यो गोस्टी को बारेमा सही-सही जानन की मनसा लक, का यहूदी वोको पर कायलाई दोस लगावसेस वोको बन्धन खोल दियो। मंग वोना मुखिया याजक अना सबरी मोठी सभा ला इकक्ठा होवन की हुकूम देईस। अखीन पौलुस ला खाल्या लीजायके वोको पुड़ा उभो कर देईस। ");
INSERT INTO pwr_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","तबा पौलुस न यहूदी महासभा कन धयान चोवके कहीस, “मोरो भाउगीन्! मिना परमेस्वर को पुड़ा आज तकन साजरो भरोसा को संगा जिंदगी जियीसेउ।” ");
INSERT INTO pwr_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","एको पर हनन्याह मुखिया याजक न जवर उभा लोक गिनला हुकूम देईस। का वय ओको गाल मा झापड़ मारेत। ");
INSERT INTO pwr_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","तबा पौलुस न वोको लक कहीस “अरे पांढरो पोती भीत! तोरो पर, परमेस्वर को मार पड़हेत। तु मोसे को नियम को अनुसार, मोरो कसो न्याय करन लाई बसीसेस। का तु मोसे को नियम को बिरोध मा, मोला झापड़ मारन को हुकूम दे रहिसेस।” ");
INSERT INTO pwr_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","जो पौलुस को कन उभो होतयो वोला कहीस “तु परमेस्वर को महायाजक गीन को बेज्जती करन को हिम्मत कसो करीसेस।” ");
INSERT INTO pwr_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","पौलुस न कहीस “मोरो इसरायली भाऊगीन मोला त पता च नही होतो का यो महायाजक आय। काहेका गिरंथ मा असो लिखीसे, तु अपरो लोकगीन को सासक को लाई बुरो नही बोलनो पाहिजे से।” ");
INSERT INTO pwr_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","मंग जबा पौलुस ला यो मालुम चलयो का उनमा लक अरधा लोक फरीसी अना अरधा लोक सदुकी सेत तबा मोठो सभा को बीच ओने जोरलक कहीस; मि एक फरिसी सेउ। अना एक फरिसी को टूरा सेउ। मरन को मंघा जित्तो होवन को बारे मा, मोरो आसा को कारन, “मोरो पर मुकदमा चलायो जाय रव्ही से।” ");
INSERT INTO pwr_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","ओको असो कव्हनो पर सदुकियो अना फरिसियो मा एक विवाद उभो हुयो अना सभा को बीच फूट पड़ गयी। ");
INSERT INTO pwr_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","काहेकि सदुकि गीन को कव्हनो होतो का मरयो मा लक जित्तो होवनो नही से, ना सरग होवासे, अना ना आतमा, काहेका फरिसी को एना सब पर बिस्वास से। ");
INSERT INTO pwr_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","एको पर मोठो उथलपुथल मच गयो। फरीसी दल को काही, मोसे को नियम को गुरू, उभा होयके बैस कर असो कव्हन लगीन “हमी एना मानूस मा कोनी दोस नही पाहेत। अदी कोनी आतमा, अना सरगदूत, एको लक काही बोलयो होतो। ता एको लक का?” ");
INSERT INTO pwr_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","जबा लगत हिन्सक झगड़ा बढ गयो। त सेना मुखिया को डराय गयो। का कहीं वय पौलुस का टुकड़ा-टुकड़ा नोको कर देत। एको लाई वोना सिपाई गीन ला हुकूम देईस, का वय सबा मा खाल्या जाय के, पौलुस ला वोको बीच लक हेड़के अना किला मा लीजायहेत। ");
INSERT INTO pwr_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","वोनाच रात पिरभू न पौलुस को जवर उभो होयके कहीस “हिम्मत राख, जसो तुना येरुसलेम नगर मा मोरो बिसय मा गवाही देईस वसोच तोला रोम देस मा गवाही देनो पडे।” ");
INSERT INTO pwr_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","दिवस होवनो पर काही यहूदी गीन न मिलके साजिस रचीन। अना उनना असी किरीया खाईन। का वय तबा तकन न खाहेत न त पीहेत। जबा तकन वय पौलुस ला मार नोको डाकत। ");
INSERT INTO pwr_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","जेना लोक गीन न यो साजिस रची होतिन, वय चालीस लक लगत होतीन। ");
INSERT INTO pwr_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","वय मुखिया याजक अना बुजरुक गिनला जवर जायके कहीन “हमी न कठिन किरया खाई सेजन। का हमी तबा तकन काही नही जेवबिन जबा तकन हमी पौलुस ला मार नही डाकबिन।” ");
INSERT INTO pwr_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","एकोलाय आपच धरम की मोठी सभा की मंजुरी लक, सेना को मुखिया ला खबर करो। का उ पौलुस ला अपरो जवर धाडदेव, मानो का तुमी साजरो लक वोकी जाच करनो चाव्हअ सेव। वोको इतानी आवन लक पयलेच, अमी जान बट्टा लक उड़ाय देबीन। ");
INSERT INTO pwr_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","पर पौलुस को बहिन को टूरा ना, वोला मार डाकन को बारेमा आयकीस, तबा उ किला मा पहुचियो। अना भीतर जायके पौलुस ला एकी खबर देईस। ");
INSERT INTO pwr_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","पौलुस न एक सेनापति ला बुलावाईस। अना वोला कहीस, “एना टूरा ला सौ सेना को मुखिया जवर ली जावो, काहेकी एला वोको लक काही कव्हनो से।” ");
INSERT INTO pwr_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","वोना टूरा ला सेना को मुखिया जवर ली जायके वोना कव्हयो “बन्दी पौलुस न मोला हाकलके कहीस का यो जवान सेनापती ला काही बात सागन वारा सेत। यो काजी एला वोको जवर ले जाव।” ");
INSERT INTO pwr_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","सेना को मुखिया न वोको हात धरके अना वोला सुनसान जघा मा ली जायके पुसीस “तु मोला कोनती गोस्टी सांगन चाहवसेस?” ");
INSERT INTO pwr_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","वोना कव्हयो “यहूदी धरम गुरु गीन आपसी मा बिचार करीसेत, का वय असो बहाना करयेत का उनला तोरो पुड़ा काही पुसन को सेत। यो काजी वोला धरम सभा मा आनो। का आमी पौलुस की साजरो लक जाँच करबिन। ");
INSERT INTO pwr_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","पर तु उनकी वय गोस्टी नोको मानजोस। काहेकी उनमा लक चाड़ीस लक जादा मानूस गीन पौलुस ला मारन को ताक मा सेत। उनना ठान लेइसेस का आमी जब तकन पौलुस ला मारबिन नही। तब तकन अमीला जेवन अना पानी पिवन को धिक्कार सेत। वय अबा परन करी सेत। अखीन तोरो नियाव की रास्ता देख रहयोसेत।” ");
INSERT INTO pwr_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","सेना को मुखिया न पौलुस को भासिया ला हुकूम देईस “कोनी ला नोको सांगजोस का तुना मोला असी खबर देईसेस” अना वोना टूरा ला जावन ला कहीस। ");
INSERT INTO pwr_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","तबा सेना को मुखिया न दूई सेनापती गीनला हाकलीस। अना उनला कहीस “आज रात नौ बजे तकन कैसरिया जान लाई दूई सौ सिपाई सत्तर घुडसवार अना दूई सौ भाला चलनवारो तैय्यार राखो। ");
INSERT INTO pwr_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","अना पौलुस को लाई भी एक घोड़ोसवारी को इंतेजाम करो। जोन मा बसके उ साजरो लक बचाय के राजपाल फेलिक्स को जवर पहुच जाय।” ");
INSERT INTO pwr_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","वोना असो चिठ्ठी लिखीस: ");
INSERT INTO pwr_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“हे महासय राजपाल फेलिक्स, क्लौदियुस लुसियास को नमस्कार। ");
INSERT INTO pwr_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","एना मानूस ला यहूदीगीन धरके मार डाकनो चाव्हत होतो। पर मीना अपरा सिपाई गीन को संग वहान पहुचके एला सूटकारा देईसेऊ, काहेकी मोला मालूम चल गयो का यो रोमी आय। ");
INSERT INTO pwr_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","मी यो जाननो चाव्हत होतो, का वय एको पर कोनतो दोस लगावसेत। एकोलाय मी वोला उनको धरम सभा मा ले गयो। ");
INSERT INTO pwr_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","वहान मोला मालूम चलयो, का वय अपरी नियम को बारे मा, एको पर दोस लगाय रहीसेत। पर यो कोनी असो खोटो काम नही करिसेत। जोनको लाय एला मारनो या बेड़ी लक बान्धनो पड़ेत। ");
INSERT INTO pwr_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","जबा मोला या खबर मिली का एना मानूस को बिरोध मा साजीस रचयो गयो सेत। तबा मीना एला गदने तोरो जवर धाडिसेव। मीना एको बिरोधीगीन ला भी हुकूम देईसेऊ, का वय तोरो पुड़ा एको बिरोध मा नालीस करे।” ");
INSERT INTO pwr_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","हुकूम को लक सिपाई पौलुस ला ले गईन। अना उनला वोनच रात अन्तिपतिरस पहुचाय देईस। ");
INSERT INTO pwr_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","दुसरो दिवस वोना घोडो सवार गीन ला पौलुस को सांग जान देईन। अना वय खुदच किला मा लवट के आइन। ");
INSERT INTO pwr_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","घोडसवार न कैसरिया पहुचनो मा राजपाल ला वा चिठ्ठी देईस। अना पौलुस ला वोको पुड़ा करीस। ");
INSERT INTO pwr_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","राज पाल न चिठ्ठी बाचीस। अना पुछिस का वा कोनतो परदेस की आय। असो जानके का वा किलकिया की आय। ");
INSERT INTO pwr_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","वोना कहीस “जबा तुमरो बिरोधी आय जाहे तबा तुमरी पुकार होहे। अना वोना हुकूम देईस। का पौलुस ला हेरोदेस को राजभवन मा पहेरा मा राखयो जाय।” ");
INSERT INTO pwr_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","पाँच दिवस को मघा मुखिया याजक हनन्याह काही बुजरुक नेता अना तिरतुल्लुस नाव को वकिल को संग कैसरिया पहुचयो। उनना राज पाल को पुड़ा पौलुस को बिरोध बिनती को चिठ्ठी लिखीन। ");
INSERT INTO pwr_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","तबा पौलुस ला बुलायो गयो। अना तिरतुल्लुस न असो कव्हतो हुयो वोको पर दोस लगाईस “महामहिम फेलिक्स महासय! हमी तोरो कारन लक लगत सान्ती मा जिंदगी बितावसेजन। अखीन तोरो साजरो काम लक अमरो लोकगिन को लगत बुराई मा सुधार भय गयो सेत।” ");
INSERT INTO pwr_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","एकोलाय आमी हरेक जघा मा अना हरेक परकार लक तोरो धनवाद मानासेजन। ");
INSERT INTO pwr_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","मी तुमरो लगत बेरा नही लेवनो चाहवसू। मोरी बिनती से का तुमी हमरा दूई सबद आयकनो की किरपा करो। ");
INSERT INTO pwr_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","काहेकी हमी न एना मानूस ला उपदरी अना जगत को सप्पा यहूदी गीन मा बलवा करन वालो अना नासरी गीन को नेता सेत। ");
INSERT INTO pwr_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","वोना मंदिर ला अपवितर करन को कोसीस करयो सेत। अना हमिना वोला धरिसेस। ");
INSERT INTO pwr_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","पर सेना को मुखिया लुसियास न वोला जबरन हमरो हात लक हिसक लेईस। ");
INSERT INTO pwr_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","अना एको पर लगयो अरोप खुदच एकोलक पुसतास करके जान सकासेव। ");
INSERT INTO pwr_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","एना आरोप मा यहूदी गीन भी समील भय गईन। वय ताकत लक कव्हन लगीन, का या गोस्टी सच्चीसे। ");
INSERT INTO pwr_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","जबा राजपाल न पौलुस ला बोलन को ईसारा करीस। त वोना जवाब देतो हुयो कहीस, तु लगत साल लक यो लोक गिनको न्याय करनवालो सेस। यो जानतो हुयो मी खुसी लक, अपरो बचाव कर रहयो सेऊ। ");
INSERT INTO pwr_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","तु आपच जान सेस का अबा येरुसलेम नगर गयो। मोला बारा दिवस भईन। ");
INSERT INTO pwr_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","वहान मंदिर मा मोला नही त, कोनी संग बहेस करता देखिन, अना नहि सभाघर गीनमा न नगर मा कोनी लक झगड़ा करता हुयो। ");
INSERT INTO pwr_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","अना अबा तोरो पूड़ा जोन अरोप ला मोरो उपर लगाय रहिसेत। वोको पुरुप नही देय सकत। ");
INSERT INTO pwr_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","पर मी तोरो पुड़ा यो मान लेसू का मी अपरो बुजरुक गीन को परमेस्वर की आराधना अपरो मारग को जसो करासेऊ। जोनला एक मारग कव्हसेत। मी हरेक गोस्टी मा भरोसा करासेऊ जोन नियम अना भविस्यवक्ता गीनको किताब मा लिखीसे। ");
INSERT INTO pwr_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","अना मि परमेस्वर मा वसोच भरोसा राखासु, जसो खुदच यो लोक राखसेत। का साजरा अना बुरो दुई कोच मर जानो को बाद जित्तो होवनो होहेत। ");
INSERT INTO pwr_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","एकोलाय मि भी परमेस्वर अना मानूस गीन को पूड़ा आपरी आतमा ला सुध्द बनावन को लाई जतन करतो रव्हासेऊ। ");
INSERT INTO pwr_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","लगत बरस दुर रव्हन को मघा मि येरुसलेम मा आपरो गरीब लोक गीन को लाय दान लेके भेंट चघावन आयो होतो। ");
INSERT INTO pwr_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","अना जबा मी पवितर बिधी कर रहयो होतो। तो ना मंदिर मा कोनी भीड़ होतो, ना कोनी असान्ति होतो। ");
INSERT INTO pwr_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","पर आसिया को काही यहुदीगिन को मनमा मोरो विरोध मा काही से, त वय तोरो पुड़ा यहान होवनो चाहिये होतो। ");
INSERT INTO pwr_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","यो जोन लोकगीन उभा सेत। वय खुदच ही सांगेत, का मोरो मा कोनतो खोट सेत? ");
INSERT INTO pwr_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","केवल एनाच गोस्टी ला छोडके जेनला मीना वोको बीच मा उभो होयकर जोर लक कहियो होतो “मारया हुया को जित्तो उठनो को बिसय मा तुमरो पुड़ा मोरो मुकदमा होय रहिसे।” ");
INSERT INTO pwr_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","पर फेलिक्स न जोन एना मारग की साजरी-साजरी खबर राखत होतो। आयक के रोकतो हुयो कहीस “जबा सेना को मुखिया लुसियास आहेत। तबा मी तुमरो मुकद्दमा ला जाच देहू।” ");
INSERT INTO pwr_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","तबा वोना सेना को मुखिया ला हुकूम देइस। का पौलुस ला काही छुट देकन जेल मा राखयो जाय। अना वोका संगी मा लक कोनी ला भी वोकी सेवा करन लक न रोखयो जाहे। ");
INSERT INTO pwr_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","काही दिवस गीन को मंघा फेलिक्स अपरी बायको दरसिल्ला ला जोन यहूदी होती। संग आनके अखीन पौलुस ला बुलाय के वोला भरोसा को बिसय मा जोन मसीह यीसु मा से आयकाव। ");
INSERT INTO pwr_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","पर जबा पौलुस उ आवन वालो न्याय की गोस्टी कर रहयो होतो त फेलिक्स न कहीस “एना बेरा त तु जाय। बेरा मिलनो पर मी तोला मंग बुलाऊ।” ");
INSERT INTO pwr_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","वोना बेरा यो आस भी होती का पौलुस वोला काही रुपया देहे। एकोलाई उ पौलुस ला बार-बार बुलायके वोको लक गोस्टी करत होतो। ");
INSERT INTO pwr_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","जबा दुई बरस बीत गईन त फेलिक्स को जघा मा पुरखियुस फेस्तुस आयो। तबा फेलिक्स यहूदी गीन को खुस करन की आस लक पौलुस ला जेल मा च छोडके गईस। ");
INSERT INTO pwr_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","पेन्तुस वोना पिरान्त मा जायके तीन दिवस बाद कैसरिया लक येरुसलेम नगर गयो। ");
INSERT INTO pwr_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","वहान यहूदी अना मोठो याजक अना यहुदी को नेतागीन पौलुस पर नालिस लगावन वोको जवर आइन। ");
INSERT INTO pwr_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","अना फेस्तुस लक यो बिनती करीन, का उ पौलुस ला येरुसलेम नगर बुलावन की किरपा करे। काहेकी पौलुस ला रास्ता मा च मार डाकन को पिलान करी होतीन। ");
INSERT INTO pwr_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","पर फेस्तुस न यो जवाब देईस “पौलुस कैसरिया मा बंन्दी से, मी खुदच गदने वहान जावन वारा सेऊ।” ");
INSERT INTO pwr_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","“तुमी मा लक जोन मुख मानूस मोरो संग कैसरिया जा सका सेत। अना उना कोनी खोटो काम करीसेस ता वहान ओको पर दोस लगा सकासेत।” ");
INSERT INTO pwr_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","फेस्तुस अखिन आठ, दहा दिवस उनको संग रव्ह के कैसरिया ला चलीगयो। दुसरो दिवस ओना अदालत मा बसके हुकूम देइस। की पौलुस ला आनयो जाय। ");
INSERT INTO pwr_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","जबा पौलुस वहान पहुचयो। तबा वय यहुदी जोन येरुसलेम लक आयो होतीन। वय वोको चारो कन उभो होय गईन। अना ओको पर असो गंभीर आरोप लगावन लगीन, जिनको उनको कठा कोनी सबुत नही होतो। ");
INSERT INTO pwr_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","पर पौलुस ना आपरो बचाव मा कहीस, “मिना ना ता यहूदी गीन की कानुन, न मंदिर अना ना च रोमन राजपाल को विरोध कोनी खोटो काम करीसेऊ।” ");
INSERT INTO pwr_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","पर फेस्तुस ना यहूदी गीन ला खुस करनो चाव्हत होतो। एकोलाय उ पौलुस ला साँगीस, “का तु येरुसलेम जावनो चाव्हसेस। जोनलक वहान तोरो न्याय करुँ?” ");
INSERT INTO pwr_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","पौलुस ना कहीस, मि यो बेरा मी रोमन को राजपाल को नियाव आसन को पुढ़ा उभो सेऊ। मोरो न्याय यँहाच करयो जाय। तुमी साजरो लक जानासेव का मिना यहूदी गीन को काही भी गलती नही करीसेव। ");
INSERT INTO pwr_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","अदी मीना इनको नियम को बिरोध मा या मार डाखन लाय कोनी खोटो काम करिसेऊ। ता मी मरन लाय तैयार सेऊ। पर लोकगिन जोन आरोप मोरो पर लगावसो उनमा कोनी गोस्टी खरो नाहती ता कोनी भी मोला इनको सुपरुत कर नही सका। “यो मोरी रोमन राजपाल लक बिनती से।” ");
INSERT INTO pwr_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","तबा फेस्तुस ना आपरी बैठक लक सलाह लेवन को मघा साँगीस, “तु ना रोमन राज पाल लक बिनती करीसेस, ता तु रोमन राजपाल कठा उभो होवजोस।” ");
INSERT INTO pwr_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","जबा लगत दिवस बित गईन ता राजा अग्रिप्पा ना आपरी बहिन बिरनीके को संग कैसरिया आयके फेस्तुस ला भेंट करीस। ");
INSERT INTO pwr_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","उनको लगत दिवस वहान रव्हन को मघा, फेस्तुस ना पौलुस को मुकदमा को बारेमा राजा ला सब गोस्टी समझायो “यो एक असो मानूस से जेनला फेलिक्स बँदी को रुपमा छोड़ गयो सेत। राखी ");
INSERT INTO pwr_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","जबा मि येरुसलेम मा होतो, ता मुखिया याजक अना यहूदी को बुजरुक गिनना ओको विरोध मा दोस लगायो, अना बिनती करिया की ओला सजा देव। ");
INSERT INTO pwr_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","तबा मिना उन ला साँगियो की रोमी की यो नियम नाहती। कोनी मानूस जबा तकन की दोस लगावन वालो को पुढ़ा होयके, आपरो बचाव मा जवाब देवन को मौका नही मिलहेत। तब तकन, ओला सजा को लाई कोनी सुपरुत नही कर सकत। ");
INSERT INTO pwr_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","असो रिति लक जबा वय यहान एकठ्ठो भईन। ता मिना बिना उसीर करया दुसरो रोज अदालत मा बसके ओना मानूस ला आनन की हुकूम दियो। ");
INSERT INTO pwr_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","जबा वोको नालीस करन वारा उभो भइन, ता उनना असो कोनी खोटो गोस्टी को दोस नही लगायो, जसो मी समझत होतो। ");
INSERT INTO pwr_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","बलकी वय सब आपरो धरम को काही गोस्टी पर, यीसु नाव को एक मानूस, जोन मर गयो से। पौलुस ओला जित्तो को साँगत होतो। वोको परच मतभेत को चरचा होतो। ");
INSERT INTO pwr_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","मी उलझन मा होतो का एना गोस्टी को पता कसो लगाऊ? एको लाई मीना वोको लक पुसयो, का तू यरुसलेम जावनो चाव्हासेस? जोनलक एना गोस्टी को बारेमा निवाव होहे। ");
INSERT INTO pwr_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","पर पौलुस ना जबा बिनती करयो का वोको सुनवाई राजा को जवर कियो जाय। ता मीना हुकूम दियो का जबा तकन मी वोला कैसर को जवर न धाड देहू, उ यहाच जेल मा रव्हे।” ");
INSERT INTO pwr_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","तबा अग्रिप्पा न फेस्तुस लक कहीस “मी खुदच भी एना मानूस की सुनवाई करनो चाव्हसेऊ।” वोना कहीस “तु काल आयक लेव जोस।” ");
INSERT INTO pwr_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","अना दुसरो दिवस जबा अग्रिप्पा अना बिरनीके मोठो धुम-धाम लक आय के अखीन सेनानायक गीन अना नगर को माननिय मानूस गीन को संग उनना सभाघर मा धसीन। तबा फेस्तुस की हुकूम लक पौलुस ला आनयो गयो। ");
INSERT INTO pwr_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","फेस्तुस न कहीस, राजा अग्रिप्पा, अना हमरो संग हजीर सज्जन गीन, एना मानूस ला चोवो सो। जेनको बिसय मा सप्पा यहूदी लोक न येरुसलेम नगर मा अना यहान भी चिल्लाय चिल्लायके मोरो लक सिकायत करत होतिन का “अबा एको जित्तो होवनो बेस नहीं से।” ");
INSERT INTO pwr_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","पर मोला पता लगयो का एना असो कोनी काम नही करयो सेस। का एला मिरतु की साजा दियो जाय। अखीन एना खुदच राजाको राजा दुबारा बिचार लाय बिनती करीसेस। एकोलाय मीना एला धाड देवन को फैसला करीयो सेऊ। ");
INSERT INTO pwr_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","मंग मोरो जवर एको बिसय मा अपरो मालीक ला लिखन को लाई कोनी पक्की गोस्टी नाहती। एको लाई मी वोला तुमी सब को पुड़ा, खास लक राजा अग्रिप्पा तोरो पुड़ा, आनीसेऊ। जेकि जाँच पूरो होवनो पर मोला काही लिखन ला मिल जाय। ");
INSERT INTO pwr_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","काहेकी मोला यो बेअरथ मालुम होवासे। का कोनी बन्दी ला वोको आरोप की चिठ्ठी तैय्यार करयो बिना धाड देहू। ");
INSERT INTO pwr_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","तबा अग्रिप्पा न पौलुस लक कहीस, “तोला खुदच अपरो पक्स मा बोलन की हुकूम से।” अना पौलुस अपरो बचाव मा सांगन लगयो। ");
INSERT INTO pwr_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","“हे राजा अग्रिप्पा, मी आपरो आपला तकदीर वालो समझासु का, यहूदी गीन न जोन मोरो पर लान-छान लगायो से। वोना सब गोस्टी को बचाव मा मी तोरो पुड़ा अपरो बचाव साग रही सेऊ।” ");
INSERT INTO pwr_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","खास एकोलाय का ये सब यहूदी ला मालुम सेत, का मी बचपन मा कसो जिंदगी बिताइसेव। ");
INSERT INTO pwr_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","वय जानसेत मी मोरो देसमा अना येरुसलेम मा कसो जियो सेऊ। ");
INSERT INTO pwr_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","वय मोला लगत बेरा लक जानासेत, अना वय अदी चाव्हासेत ता यो बात को गवाहि, देव सक सेत। का मी ना कसो, आमरो धारमिक रित मा एक कट्टर समहु को अनुसार एक फरीसी को जसो जिंदगी बिताइसेऊ। ");
INSERT INTO pwr_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","अना अबा उ करार, जोन परमेस्वर ना आमरो आजा पुरखा लक कियो होतो। वोच भरोसा मा, मी यहान यो मुकदमा साठी उभो सेउ। ");
INSERT INTO pwr_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","यो वोच करार सेत, जेनको आस मा, हमी बारा कुर रात-दिवस परमेस्वर को भगती करत आयो सेत। अना हे राजा एना च आस को बारे मा, मोरो पर यहुदी गिन लान-छान लगावसे। ");
INSERT INTO pwr_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","तुमी लोकगीन ला यो गोस्टी, बिस्वास को लायक काहे नही लगसेत। का परमेस्वर मरयो हुया ला जित्तो कर सेत? ");
INSERT INTO pwr_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","मी खुद सोचत होतो, नासरी यीसु को बिरुद करनलाय जोन काही होय सकत उ सब करीन। ");
INSERT INTO pwr_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","ता मीना येरुसलेम नगर मा असोच करीसेव। अना मुख याजक लक हक पायके, लगत सो परमेस्वर को भगतगिन ला जेल मा डाख दियो। अना जबा वय मारो जात होतीन। ता मी उनको बिरोध मा अपरी मत देवत होतो। ");
INSERT INTO pwr_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","अना मी हरेक यहुदी सभाघर मा जायके। उनको यो बिस्वास को मारग लक हटान काजी दबाव डाकन को कोसीस करत होतो। उनको लाय गुस्सा इतरो होतो का उनला सतावन लाय मी परदेस को सहेर मा गयो। ");
INSERT INTO pwr_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","असोच एक मकसद को संग मी मुख याजक लक हुकूम पाय के दमिस्क नगर जा रहयो होतो। ");
INSERT INTO pwr_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","तबच हे राजा दुफार जबा मी अना सब मोरो संगी रस्ता मा होतिन, तबच मी ना बादल लक एक उजाड़ उतरता चोवयो। वोको तेज दिवस को सुरज लक भी जादा लगत होतो। अना मोरो अना मोरो संगी गिन को आखा-पाखा चमको। ");
INSERT INTO pwr_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","जबा हमी सब जमीन पर लुड़क गयो। तबच मोला इबरानी बोली मा असी आवाज आयकू आई। साऊल-साऊल, तु मोला कायलाई सतावसेस? तरवार को धार मा लात नोको मार, यो तोरो बसको नाहती। ");
INSERT INTO pwr_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","मग मीना कव्हयो पिरभू तु कोन आस, “पिरभू न कहीस, मी यीसु सेव, जेनला तु दुख दे रहीसेस।” ");
INSERT INTO pwr_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","परन्तु तु उभो होय, अना अपरो पाय पर उभो होय, मी तोरो पूड़ा एकोलाय परगट भयी सेऊ, का तोला मी एक दास को रूपमा ठैयराउ। अना जोन काही मोरो बारेमा तूना चोविसेस। अना जोन काही तोला चोवाहिन, वोको गवाही रहेत। ");
INSERT INTO pwr_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","अना मी तोला जोन यहुदी अना गैर यहुदी लोकगिन को जवर धाड़ासू। ");
INSERT INTO pwr_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","उनको डोरा उघाड़न, उनला इंधारो लक उजाड़ कन आनन लाय, अना सैतान को अधिकार लक परमेस्वर को कन मुरकान लाय, तोला धाड़ासेऊ। उनलक तोला बचावत रहिन। एकोलक वय उनला पाप की छिमा भेटेत। अखीन उन लोखगिन को बीचमा जघा पाहेती। “जोन मोरो मा बिस्वास को कारन पवितर भयो सेत।” ");
INSERT INTO pwr_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","“हे राजा अग्रिप्पा तबा च लक वोना दरसन की हुकूम ला कभीच मना नही करिसेऊ।” ");
INSERT INTO pwr_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","बल्की एको उलट मी पयले उनला, दमिस्क मा, मंग येरुसलेम नगर मा, अना यहुदिया छेतर मा अना गैर यहुदी गीन ला सांगत रहयो। का मन मुरकाव, अना परमेस्वर कन मुरको अना साजरा काम करो। ");
INSERT INTO pwr_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","एनाच कारन जबा मी मंदिर मा होतो। यहूदी गीन न मोला धरलेइन। अना मोरो मार डाकन को जतन करयो। ");
INSERT INTO pwr_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","पर आज तकन मोला परमेस्वर को मदद भेटत रव्हयो, जोनलक मी आज तकन जित्तो रहयो। अना एकोलाइ मी नहान मोठो सबच को पुड़ा गवाही देवन लाई उभो सेऊ। मी बस एना गोस्टी ला छोड़के अखिन काही नहि कव्हसेऊ। जोन भविस्यवक्ता गीन अना मोसे को अनुसार पुरो होवन की होती। ");
INSERT INTO pwr_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","जसो की मसीह ला दुख उठावनो पडहेत। अना ओच मारयो हुया मा लक पयले जित्तो होहेत, अना उ यहूदी अना गैर यहूदी गीन ला उजाड़ को खबर देहेत। ");
INSERT INTO pwr_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","जबा पौलुस अपरो बचाव मा एना पिरकार कहे रहयो होतो। त फेस्तुस न जोरलक कहीस “पौलुस तोरो डिमाक खराब भय गईसे।” तोरी लगत पढ़ाई लक तु बैयताड़ भय गयोसेस। ");
INSERT INTO pwr_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","पौलुस न कहीस हे “महामहिम् फेस्तुस! मी बैताड़ नही सेउ, पर खराई अना मुद्‍दा की गोस्टी ला सांगासू।” ");
INSERT INTO pwr_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","राजा भी जेनको पुड़ा मी बेधड़क होयके सांग रहयो सेऊ। उ एना गोस्टी ला जानासे। अना मी बेखटका कव्हसू, मोला बिस्वास, का इन गोस्टी मा लक काही भी नही लुको नाहती, काहेका उ घटना कोनी कोनटा मा नही भईसे। ");
INSERT INTO pwr_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","“हे राजा अग्रिप्पा, का तु भविस्यवक्ता गीन जोन गोस्टी कहिसेत वोना गोस्टी मा बिस्वास करासे? हव मी जानासेव का तु बिस्वास करासे।” ");
INSERT INTO pwr_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","एको पर राजा न पौलुस न कहेयो “तु काजक सोचासेस का इतरो सरल रित लक मोला मसीह बनानो चाव्हसेस।” ");
INSERT INTO pwr_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","पौलुस न कहीस “जरासो मा का लगत बेरामा, परमेस्वर लक मोरो पिराथना से का, ना तु च बल्कि वय सबच भी बिना सजा को आ जाय। जोन आज मोला आयक सेत।” ");
INSERT INTO pwr_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","तबा राजा उभो भयो अना वोको संगच राजपाल, बिरनीके अखीन बसया हुया लोक भी उभा भईन। ");
INSERT INTO pwr_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","अखीन ऐक कन जायके एक दुसरो लक गोस्टी करके असो कव्हन लगीन। यो मानूस त असो काही भी नही कर रहीसेत। जोन ला मिरतु को दंड मिलहे। ");
INSERT INTO pwr_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","अग्रिप्पा न फेस्तुस लक कहीस “अदी एना मानूस न कैसर लक अपील न करी होतीस त एला मानूस ला छोड़ दियो गयो होतो।” ");
INSERT INTO pwr_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","जबा असो पक्को भय गयो का, हमी ला जहाज लक इटली जानो से। त पौलुस अना काही दुसरो कैदी गीनला महाराजा को एक युलियुस नाव को सेना नायक को हात सोप देइन। उ 100 सेना को कमान्डर होतो। ");
INSERT INTO pwr_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","अदरमुत्तीयुम लक अमी एक पानी जहाज मा चघयो, जोन असिया को कगर छेतर लक होयके जावन लाय तैयार होतो। वोमा अमी यातरा करन काजी हिटयो। थिस्सलुनीकिया निवासी, एक मकीदुनिया को मानूस होतो जेनको नाव अरिस्तखुरस होतो। ");
INSERT INTO pwr_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","परो को दिवस हमी सैदा मा उतरया अना युलियुस न पौलुस को लाय दयावन भयो अना वोना पौलुस को संगीगिन लक मिलन लाय अनुमति दियो। जोन लक वोको लाय जरूरी-जरूरी चीज वोको संगी आन देहे। ");
INSERT INTO pwr_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","वहान लक हमी सागर को मारग लक मंघा चल पडयो हमी साइप्रस को आड़-आड़ मा चल रहेयो होतो काहेका वारा हमरो उलट मा होतो। ");
INSERT INTO pwr_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","सागर ला पार करके हमी मंग हमी किलकिया अना पंफलिया को कठा लुकिया अना मूरा नाव को जहाज घाट मा पहुचयो ");
INSERT INTO pwr_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","उ सौ सिपाई को मुखिया ला सिकन्दरिया लक इटली जावन वालो एक जहाज मिलयो, वोना हमला वोको पर चघाय दियो। ");
INSERT INTO pwr_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","हाडु-हाडु मुसिबत लक पुढा बढातो हुयो कनिदुस को जवर पहुचयो काहेका वारा अमरो उलट आवत होती। अना हमी ला पुढा नही जान देत होती। त हमी सलमोने को पुड़ा लक किरेति कन आपरो जहाज बढान लगयो। ");
INSERT INTO pwr_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","किरेति दीप कगर-कगर मोठयो मुसीबत लक जहाज ला पुढा बढात-बढात एक असो जघा मा पहुचयो जेनको नाव सुरक्सित जहाज घाट होतो। यहान लक लसैया सहर जवर होतो। ");
INSERT INTO pwr_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","गजब उसीर भयगयो होतो जहाज को पुढा बढानो मा भी लगत संकट होतो। काहेका तब तकन उपास को दिवस बीत गयो होतो। एको लाय पौलुस ना उनला सालह देवत हुए कहयो, ");
INSERT INTO pwr_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","अगो भाऊ गीन मोला असो लगासे। का अमरो यो सागर यातरा लगत बिनास करन वालो होहेत। सिरप माल मत्ता अना जहाज को लाय बल्की अमरो जान गीन को लाय भी सेत। ");
INSERT INTO pwr_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","पर 100 सेना को मुखिया ना पौलुस ना जोन कव्हयो होतो। वोको मा धियान नही दियो। पर सेना नायक न जहाज को मालीक अना अगवा को गोस्टी मा भरोसा राखीस। ");
INSERT INTO pwr_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","उ जहाज घाट, थन्डी को मौसम मा ठैयरन को लायक नहोती। एकोलाय लगत लोकगिन ना हो सके तो फिनिकस जावन को ठानीन। अना थन्डी उतानी बितावन को इरादा बनाइन। फिनिकस किरेति देस को एक असो जहाज घाट सेत। जेन को मुख दक्सिन अना दिवस बुड़ती, अना उत्तर दुई को पुड़ा सेत। ");
INSERT INTO pwr_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","जबा दक्सिनि वारा हड़ु-हड़ु बहोन लगी, ता उनना सोचयो का जसो उनना चाहयो होतो तसोच उनको योजना को मुताबीक भय गयो। त उनना लंगर उचलके किरेति को कगर-कगर जहाज चलावन लगीन। ");
INSERT INTO pwr_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","पर जरा उसीर मा एक टापु को कन लक लगत भयानक आँधड़ आयो। अना जहाज को अखा-पखा बोहन लगयो जोन ला उतर-पुर्वी आँधड़ कव्हत होतीन। ");
INSERT INTO pwr_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","जबा जहाज आँधड़ मा फस गयो तबा यो मुमकिन नही होतो यो आँधड़ चीरत-चीरत जहाज पुड़ा जाय। एकोलाय हमीना जतन करनो छोड़ दिया। अना जहाज ला वारा को सहारा मा बोहन लाई छोड़ दियो। ");
INSERT INTO pwr_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","दक्सिन को लहान टापु कौदा ला जहाज न पार करियो। तबा काही सहारा मिलयो, लगत कठनाई लक अमीना हमरो जहाज ला सुरक्सित कर सकियो। ");
INSERT INTO pwr_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","मंग जहाज चलानवारा गीन ना जहाज ला उचलन को मंघा चराट लक लपटके बांध दियो। अना काही सुरक्सित टापु को उथलो पानी मा नोको फसे असो भेव लक उनना जहाज को पाल उतार देइन। अना जहाज ला वारा को कन बोहन देईन। ");
INSERT INTO pwr_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","दुसरो दिवस जबा आमी आँधड़ लक लगत हिंसक धाका खाय रही होतीन, ता वय जहाज को माल फेकीन। ");
INSERT INTO pwr_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","परो को दिवस मा उनना जहाज को उपकरन ला अना तिरपाल भी फेक दिया। ");
INSERT INTO pwr_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","जबा लगत दिवस तकन न ता सुरज चोयो, न तारा अना आँधड़ लगातार चल रही होती तबा हमी न जिंदगानी को आस छोड़ देइन। ");
INSERT INTO pwr_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","जबा लगत दिवस लक कोनी न काही नही जेवीन। तबा पौलुस न उनको बिच उभो होयके कहयो, अरे लोकगीन तुमीला सोचनो होतो। तुमी मोरी गोस्टी मानके किरत लक जहाज नही खोलतत। अना नही योसच मुसीबत आवतो, अना कोनी हानी होती। ");
INSERT INTO pwr_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","पर मी तुमरो लक बिनती करासु का हिम्मत राखो। अपरो मा लक कोनी की नही मरहेत, बस यो जहाज की नुकसानी जरुर होहेत। ");
INSERT INTO pwr_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","काहेकी परमेस्वर जेकी सेवा मी करसेऊ, वोको एक सरगदूत आज रात मोरो जवर आयके उभो भयो। ");
INSERT INTO pwr_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","अखीन वोना कहीस पौलुस नोको डराय, तोला रोमन राजा को पुड़ा उभो होवनो जरुरीसे। चोव! परमेस्वर न एना सबला जोन तोरो संग मा सेत। उनला तोरो सुपरुत करीसेऊ। ");
INSERT INTO pwr_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","एकोलाय अगा भाऊहुन धीरज राखो। काहेकी मी परमेस्वर पर बिस्वास राखासू, जसो मोरो लक कव्हयो गयो से, वसोच जरुर होहे। ");
INSERT INTO pwr_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","कोनी न कोनी टापू मा हमरो जहाज जरुर ठहरे। ");
INSERT INTO pwr_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","जबा आँधड़ की चौदहवी रात आई, तबा हमी भुमध्य सागर मा भूलत-भटकत होत्यो। अना टिका-टिक अरधी राती को बेरा जहाज खेवन वारा ला असो लग्यो, का हमी कोनी तट को जवर पहुची सेजन। ");
INSERT INTO pwr_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","थाह लेवन पर उनना सैतीस मीटर गहरई नापीन। जरासो पयले बड़के उनना मंग थाह लेईन त छब्बीस मीटर गहरो पाइन। ");
INSERT INTO pwr_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","तबा कंही पहाड-वहाड लक नोको टकराय जाय। यो भेव को कारन लक वय जहाज को मंघा वालो हिस्सा लक चार लंगर डालके अना पिराथना करन लगयो। आस लगाके पहट होवन को बाट जोहन लगीन। ");
INSERT INTO pwr_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","उतानी जहाज चलान वालो माँझीगिन जहाज लक परान को पिलान बनायो। उनना असो बहाना बनाइन का जहाज को पूड़ा को हिस्सा मा लंगर डाखन काजी जाय रहयो सेजन। कहेके रक्सा डोगा सागर मा उतार देइन। ");
INSERT INTO pwr_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","ता पौलुस न सेना नायक अना सिपाई गीन लक कहीस, अदी ये लोक जहाज पर न रहयो, ता तुमरो भी बचनो मुस्किल सेत। ");
INSERT INTO pwr_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","तबा सिपाई गीन न चराट ला काटके डोंगा ला बोहाय देइन। ");
INSERT INTO pwr_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","जबा पहेटिया होवनवारा होतो। तब पौलुस ना उनला समझाइस का आज चौदह दिवस भय गयो। तुमी चिन्ता को कारन काही नही जेविसेव। ");
INSERT INTO pwr_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","मी तुमरो लकजेवन को बिनती करासेऊ। तुमरो जित्तो रव्हन लाय यो जरूरी सेत। काहे का तुमरौ जान को हानी नहि होहेत। ");
INSERT INTO pwr_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","असो कहके वोना भाकर लेईस, अना सबच को पुड़ा वोको लाई परमेस्वर ला धनयवाद देईस। अखीन तोडके जेवन लगयो। ");
INSERT INTO pwr_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","एको लक उनको हिम्मत बनी अना सबना जेवन करीन। ");
INSERT INTO pwr_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","जहाज पर हमी सबच मिलके दूई सौ छिहत्तर आदमी होता। ");
INSERT INTO pwr_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","अखीन जबा वय जेवन करके अघाय गईन। मंग गहूँ ला सागर मा फेकके जहाज ला हल्को करन लगीन। ");
INSERT INTO pwr_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","जबा दिवस हिटयो, त वय देस ला चीन्ह नही सकयो। पर उनला लगयो, का एक किनारोदार खाडी सेत। उनना पक्को बिचार बनायो का हो सके ता जहाज वहान टिकाये देबिन। ");
INSERT INTO pwr_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","उनना लंगर कापके सागर मा‌ छोड़ देईन। अना वोनोच बेरा पतवार को बंध ला ढिलो कर देईन। अना जहाज को अगलो तिरपाल चघाय के किनार कन बड़न लगीन। ");
INSERT INTO pwr_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","अना उनको जहाज रेतामा टक्करायो। जहाज को अगलो हिस्सा रेतामा फस गयो। अना थम गयो अना ताकतवर लहेर को थपेड़ लक जहाज को मघा को हिस्सा टुटन लगयो। ");
INSERT INTO pwr_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","सिपाई गीन को बिचार होतो का कैदिगीन ला मार डाको। जेकोमा उनमा लक कोनी भी तिरके पराय नोको जाय। ");
INSERT INTO pwr_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","पर सेना नायक ना पौलुस ला साजरो लक लीजावन की आस लक उनला असो करनो लक रोखीस। अना हुकूम देईस “का जोन तीर सकसेत वय पयले कुदके ना जघा पर बच के हिट जाय।” ");
INSERT INTO pwr_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","अखीन बाकी लोक पटिया अना जहाज का अना टुकड़ा गीन को सहारा लक बच के हिट जाहे। एना पिरकार लक वय सब लोक जघा पर साजरा-साजरा पहुच गईन। ");
INSERT INTO pwr_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","जबा हमी साजरो रुप लक कगर मा बच हिटया, तबा मंग मालुम चलयो। का वोनो दीप को नाव माल्टा होतो। ");
INSERT INTO pwr_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","वहान को मुलनिवासी गीन न हमरो सांगा संगी जसो साजरो बरताव करीन। काहेका दव को मौसम होतो। अना बरसात होय रहि होती। एको लाई इस्तो पेटायो। अना हमरो सबको सुवागत करीन। ");
INSERT INTO pwr_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","पौलुस न लकड़ी को गठ्ठा जमा करके इस्तो मा राखीस। त आच लगी त एक सरप हिटयो, अना वोको हात ला चाब देइस। ");
INSERT INTO pwr_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","जबा मुलनिवासी न सरप ला वोको हात मा गुन्डियो चोयो, त कव्हन लगीन पक्को मा यो मानूस खूनी से। जबा की यो सागर लक बच गयो, पर नियाव एला जीवनो नही दे रहिसे। ");
INSERT INTO pwr_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","पर तबा पौलुस न सरप ला इस्तो मा झटकार देइस। अना वोको काही हानी नहि भई। ");
INSERT INTO pwr_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","पर लगत उसीर मा रास्ता चोवन को मघा, अना यो चोयके अजब गजब रुप लक काही नही भईसे। उनना अपरी सोच ला बदल लेइन। अना कहिन, “यो तो कोनी देवता सेत।” ");
INSERT INTO pwr_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","वोना जघा को अगल-बगल वोनो दीप को मुखिया अधिकारी पुबलियुस की खेत होती। वोना हमरो सुवागत करीस। अना तीन दिवस तकन हमरो पाहुनाई करीस। ");
INSERT INTO pwr_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","मंग असो भयो का पुबलियुस को अजी बुखार अना आव लक पीडित होतो। पौलुस वोला देखन अंदर गयो। अना वोना पिराथना करके अपरो हात वोको पर राखीस। अखीन वोला साजरो भयि गयो। ");
INSERT INTO pwr_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","एना घटना को मघा दीप मा को सप्पा बीमार आइन, अना साजरा भईन। ");
INSERT INTO pwr_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","उनना हमीला लगत उपहार देईन। जबा हमी वहान लक जहाज मा पुढा बढयो, तबा उनना सप्पा जरुरत को चीज आनके देईन। ");
INSERT INTO pwr_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","तीन महिना बाद हमी न सिकन्दरिया को एक जहाज मा चल पडया। अना दव को बेरा यो जहाज यहान च होतो। अना जहाज को पुड़ा हिस्सा मा “जुड़या इस्वर” असो छापा होतो। काहेकि वोला जुड़या इस्वर जहाज भी कव्हत होतीन। ");
INSERT INTO pwr_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","मंग सरकुसा सहर मा हमी पहुचयो वहान हमी तीन दिवस तकन रुकया रहया। ");
INSERT INTO pwr_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","वहान लक हिटके रेगियुम पहुचयो अना परो दिवस मा दक्सिन की वारा चली। अखीन हमी दुसरो दिवस पुतियुली मा आया। ");
INSERT INTO pwr_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","वहान हमी ला काही बिसवासी मिलीन जिनना हमरो लक बिनती करीन, का हमी उनको यहान सात दिवस तकन रहया। एना पिरकार हमी रोम पहुच गयो। ");
INSERT INTO pwr_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","जबा रोम को बिस्वासी न हमरो आवन को बारे आयकिन अप्पियुस बाजार अना तीन सराव तकन मिलन आइन। तबा पौलुस ला देखिन त परमेस्वर ला लगत धन्यवाद देइन, अना लगत खुस भयो। ");
INSERT INTO pwr_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","जबा हमी रोम मा पहुचियो तबा पौलुस ला एक सिपाई को संग जोन वोकी देख-रेख करत होतो अलग रव्हन की हुकूम देईन। ");
INSERT INTO pwr_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","मंग तीन दिवस को मघा पौलुस न यहूदी नेता गीन ला बुलवाईस। अना वय जमा भईन, त वोना उनको लक कहीस “भाऊ गीन अदी मीना अपरा लोक अना अपरा पुरखा गीन की रिती-रिवाज को बिरुध्द काही नही करयो। मंग भी मी येरुसलेम लक बन्दी बानायके रोमी को हात सोप दियो गई सेऊ। ");
INSERT INTO pwr_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","रोमन अधिकारी को पुछ-ताछ करनो को मघा मोला छोड़ देवनो चाहिन। काहेकि मोला मिरतु की सजा दियो जानो कोनी कारन नही होतो। ");
INSERT INTO pwr_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","पर जबा यहूदीगीन न बिरोध करीन तबा मीना रोमन राजा लक दुबारा विचार करन लाय कहेयो, एकोलाई नही का मी अपरोच लोक गीन पर कोनी अरोप लगावनो चाव्हत होतो। ");
INSERT INTO pwr_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","एना कारन मीना तुमीला बुलायके गोस्टी सांगी सेऊ काहेकी इसरायल को भरोसा च से जोन कारन मी बेडी लक बंधयो सेऊ।” ");
INSERT INTO pwr_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","यहुदी नेता उनना पौलुस लक कहयो, तुमरो बारे मा न कोनी चिठ्ठी मिलीसेत। अना नही कोनि वहान लक आवन वारा मानूस तोरो खबर देइसेस। अना न कोनी न तोरो बिरोध मा पुरो गोस्टी सांगी सेत। ");
INSERT INTO pwr_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","पर तोरो बिचार काजक से हमी आयकनो चाव्हसेजन का हमीला मालुम सेत। का सप्पा जघा लोकगीन यो मारग को बिरोध मा सांगा सेत। ");
INSERT INTO pwr_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","तबा वोको यहान जमा भईन, जहान उ ठहरियो होतो। अना उ परमेस्वर को राज की गवाही देत होतो। अना मोसे को नियम अखिन भविस्यवक्ता गीनको किताब लक यीसु को बारे मा समझायके-समझाय के साकरी लक झुलाखाली तकन सांगत होतो। ");
INSERT INTO pwr_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","वोना जो काही कहे होतो, वोको लक काही न सहमती धरीन। अना काही न भरोसा नही करीन। ");
INSERT INTO pwr_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","मंग वय अपसी मा एक दुसरो बेगरो मन होयके वहाँ लक जवान लगीन। तबा पौलुस न यो गोस्टी अखिन सांगयो, यसायाह भविस्यवक्ता को कन लक तुमरो पुरखा गीन लक खरो कहीस का। ");
INSERT INTO pwr_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","जायके इन लोकगीन ला कव्हो आयकत रव्हो पर समझ मा नही आहेत। अना चोवत त रव्हना पर नही चोहे। ");
INSERT INTO pwr_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","काहेकि एना लोकगीन को मन जड़ता लक भर गयो। अना इनको कान कठनाई लक आयक सेत। अना इनको डोरा बंद कियो गयो सेत। काहेका कही असो ना भई जाय, का वय आपरो डोरा लक चोवे, अना कान लक आयकत, अना उनको मन लक समझेत, अना कदी मुरक जाय, “अना मी उनला साजरा कर देउ।” ");
INSERT INTO pwr_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","तबा पौलुस न आखीर मा कव्हयो, एकलाय तुमला जान लेवनो चाहिये। का परमेस्वर को यो छुट्टकारा को संदेस गैर यहुदी को कन धाड़ दियो गयो सेत। वय येला आयकेत। ");
INSERT INTO pwr_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","जबा पौलुस को यो गोस्टी कव्हन को मघा यहूदी आपसी मा हिंसक झगड़ा करतो वहान लक चली गइन। ");
INSERT INTO pwr_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","वहान पौलुस किराया को घर मा, पूरो दुई बरस तकन रहेयो। जोन कोनी वोको जवर आवत होतीन, उन सब को उ सुवागत करत होतो। ");
INSERT INTO pwr_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","उ परमेस्वर को राज को परचार करतो, अना पिरभू यीसु मसीहा को बारेमा, उपदेस देवत। उ यो काम ला बेखटका करत होतो।");
INSERT INTO pwr_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","पौलुस को यो चिठ्ठी से। जोनला यीसु मसीह ना सेवक अना पेरीत को नाता लक निवड़ले आहेत। अना परमेस्वर को साजरा बारता सांगन लाय बुलायो सेत। ");
INSERT INTO pwr_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","परमेस्वर ना आपरो भविस्यवक्ता गिन लक असो पयले च करार कियो होतो। असो पवितर गिरंथ मा लिख्यो सेत। ");
INSERT INTO pwr_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","त मानूस मा दाऊद को कुटुम्ब को होता। ");
INSERT INTO pwr_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","परंतु मोठ्या सामरथ लक मरनो लक जित्तो होवन को कारन। अना वोको पवितरपन को कारन उ परमेस्वर को टूरा से, असो दरसायो जासे। ");
INSERT INTO pwr_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","वोच यीसु को खासम-खास चेला होवन को मौका मोला भेटयो सेत। जोन लक मी सबा देस को लोकगिन ला यीसु मा बिस्वास करन अना वोला मानन मा मदद करबिन। ");
INSERT INTO pwr_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","यो गोस्टी मा तुमी रोम को सबा रव्हन वारो भी सामिल सेव। ");
INSERT INTO pwr_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","अबा मी सब रोमीला लिखासू का परमेस्वर तुम सब लक पिरेम करासेत। अना आपरो जवर बुलावा सेत। तुमी सप्पा लोक ला आमरो पिरभू यीसु मसीह अना वोको परमेस्वर दादाजि कन लक दया अखिन सान्ती भेटेत। ");
INSERT INTO pwr_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","पयले मी तुम सबको लाय यीसु मसिहा को कनलक परमेस्वर ला धनवाद देवासू। काहेका सबा दुनिया मा इतानि- उतानी तुमरो च बिस्वास को चरचा होवासेत। ");
INSERT INTO pwr_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","यो गोस्टी को परमेस्वर गवाह से, जोन मी सांगा सेऊ उ खरो से। जोन परमेस्वर को टूरा को बारेमा साजरो बारता आयकवा के पुरो मन लक मी वोको सेवा करासेऊ। ");
INSERT INTO pwr_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","परमेस्वर जाना सेत, मि हरेक बेरा तुमरो लाय पिराथना करा सेऊ। मी कव्हसेऊ का परमेस्वर उनको भलो करे। मी बिचार करा सेऊ का कसो तुमरो जवर आऊ। ");
INSERT INTO pwr_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","मी तुमिला आपरो डोरा लक चोवनो चाव्हासू। जोन लक मी तुमला आतमा मा मजबूत करन लाय एक नवीन आसीरवाद बाटू। ");
INSERT INTO pwr_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","मोरो मतलब सेत का जबा अमी आपस मा भेट करहेत ता दुई पक्स को बिस्वास बढेत। ");
INSERT INTO pwr_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","मोरो संगी हुन का तुमीला हेत से? लगत बार मीना तुमरो जवर आवन को योजना बनयो। पर मी काय सांगू कहीना कही आड़-फाटा को करन मोरो आवनो फयिल भयि गयो। मी तुमरो संग बदलयो जीवन जिवनो चाव्हसू जसो यहुदीगिन संग जिवासू। ");
INSERT INTO pwr_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","मोरो पर यूनानिगिन अना गैर यूनानिगिन, अक्लवर अना मुरख, सब को करजा सेत। ");
INSERT INTO pwr_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","एकोलाय मी तुमी रोम को रव्हवासी लोक ला भी साजरा बारता को उपदेस देवन तैय्यार सेऊ। ");
INSERT INTO pwr_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","साजरो बारता आयकवान काजी मोला काही सरम-लाज नाहती। यो तो परमेस्वर को ताकत से, जोन हरेक भरोसा राखन वारा, पयले यहूदी लोकगीन, अना मघा गैरयहुदी लोकगीन को लाय, मुकती को जरिया से। ");
INSERT INTO pwr_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","साजरा बारता मा “परमेस्वर को नेकपन” जो सुरु लक आखीर तकन भरोसा पर टिकीसे, असो परगट भईसे, जसो का मोसे को नियम मा लिखीसे। “नेक मानूस बिस्वास लक जित्तो रहेत।” ");
INSERT INTO pwr_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","परमेस्वर को यो गुस्सा सरग लक, वय सबा पाप अना लोकगीन को खोटो काम को बिरोधमा परगट होवा सेत। जोनको खोटो तरिका सच्चाई ला जानन लाय रोकासेत। ");
INSERT INTO pwr_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","परमेस्वर उनला सजा देवासेत। काहेका जोन गोस्टी परमेस्वर को बारेमा जाननो को काबिल से, वा उनको लाय हरामेसा लक सेत। कारन परमेस्वर ना स्वता हरामेसा साठी बनायो सेत। ");
INSERT INTO pwr_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","जबा लक परमेस्वर ना दुनिया ला बनायो सेत। तबा लक परमेस्वर को नही चोवन वालो गुन, वोको अमर सक्ती, अना वोको महान आचरन दुई सपा-सपा रुपमा चोवयो गयो सेत। उनला परमेस्वर ना बनाइसेत असो सांगयो जावासेत ता कोनी बहाना नाहोती। ");
INSERT INTO pwr_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","वय परमेस्वर ला जना सेत, तरी वय परमेस्वर को आदर नही करतत। ना च वोको धनवाद करतत। एको अलावा उनको बकवास बिचार सेत। अना उनको रिकामो डिमाक मा इन्धार भर गयो सेत। ");
INSERT INTO pwr_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","वय खुदच ला अकलवर समजके ना चूथीया बन गईन। ");
INSERT INTO pwr_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","अमर परमेस्वर को पूजा करन को जघामा नास होवन वालो, जनावर, पक्सी सरप डेडुर को जसो बनायो कलाकारी अना फोटु को पुजा करा सेत। ");
INSERT INTO pwr_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","यो कारन लक परमेस्वर ना उनला मन को इक्सा लक, सोड़ दियो। वय असुध्ध भई गईन, अना आपसी मा आपरो देह को अनादर मजे खोटो करम करन लगीन। ");
INSERT INTO pwr_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","काहेका उनना परमेस्वर को खरो को बदला मा, खोट ला अपनायो से। अना संसार को चीजगिन को भगती-सेवा करीन, ना की दुनिया बनावन वारा परमेस्वर को। आमेन। ");
INSERT INTO pwr_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","एकोलाय परमेस्वर ना उनला खोटो करम करन लाई सोड़ देईसेस। उनको बायका गीन भी बायको जवर बायका सोवन लगीन अना बायका-बायका च आपसी मा खोटो काम करन लगीन। ");
INSERT INTO pwr_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","वसोच मरद भी बायका को संग सोवनो छोड़ केना, आपसी मा मरदमाना खोटो काम करन लगीन। अना खुद आपरो पाप लक, दन्ड पावन लगीन। ");
INSERT INTO pwr_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","अना काहेका उनना परमेस्वर ला ओरखन लक मना कर देयिन। ता परमेस्वर ना उनला वसोच बेडिमाक रव्हन दियो। अना वय मन मरजी लक खोटो-खोटो काम करन लगयो। जोन करनो पायजे नाही। ");
INSERT INTO pwr_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","एको लाय वय सब परकार को अन्याय करन लगीन अना खोटो काम, लोभ बुराई लक भर गईन। वय ईरसा, जान लेवनो, बैर छल-कपट, अना खोटो बिचार लक भर गइन। ");
INSERT INTO pwr_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","बदनाम करन वारा, परमेस्वर ले घिरना राखन वारा, ढिट, जिद्दी, डीग हाकन वारा, बुराई राखन वारा, माय-बाप को हुकूम नही मानन वारा। ");
INSERT INTO pwr_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","अठ्ठिया, बिस्वास करन वारा ला धोका देवन वारा, बन गइन अना उनको मन मा माया अना दया नाहती। ");
INSERT INTO pwr_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","वय परमेस्वर को हुकूम ला, जानबुझ के, असो-असो काम करन लगीन। जेनको फर मरनो सेत, तोभी वय वसोच काम करासे, अना करनवारा लक खुस होवासे। ");
INSERT INTO pwr_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","अगो मोरो संगीहुन! तुमी जोन गोस्टी मा दुसरो ला फैसला मा खोटो ठैयरावा सो, वोच काम तुमी करासेव, तुमी कोनी भी सेव तुमरो बहाना को कारन तुमिला कोनी सूट नाहती। ");
INSERT INTO pwr_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","अमीला मालूम सेत का, परमेस्वर सही से। अना एनो गोस्टी को बिरोध मा फैसला देवासेत। ");
INSERT INTO pwr_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","तरी तुमी वोना काम करतत जोन को बारेमा तुमी दुसरो को फैसला करतत। का तुमिला असो लगा सेत का परमेस्वर को फैसला तुमी ला बचा देहेत? ");
INSERT INTO pwr_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","मंग तू वोको मोठो दया अना धिरज लक सहन करनो ला हीन मानतत। अना तु यो गोस्टी को कन धियान नही देवा सेत। का वोको दया तोला पाप सोड़न को लाय मौका देवा सेत। ");
INSERT INTO pwr_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","तरी तुम्ही जिद्दी सेव, अना तुम्हरो गोटा को दिल से। कारन तुम्ही आपरो सजा ला अखिन बढावा देवा सेव। एक दिवस परमेस्वर को कोप अना सही फैसला तुम्हरो पुढा आहेत। ");
INSERT INTO pwr_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","काहेका नियाव को दिवस मा अमिना जोन काम करयो सेत वोको अनुसार अमिला ईनाम भटेत। मजे “जसो करनी तसोच भरनी” ");
INSERT INTO pwr_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","काही लोकहुन साजरा करतत, अना मान गौरव, अना अमर जिंदगी चाव्हा सेत। परमेस्वर उनला अमर जिंदगी देहेत। ");
INSERT INTO pwr_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","काही लोकहुन सुवारथी सेत, अना गलत काम करा सेत, सही काम करन लाय, वोको हुकूम ला नही माना सेत। उनको मा परमेस्वर को गुस्सा दिसायेत। ");
INSERT INTO pwr_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","हरेक मानूस, जोन बूरो करासे, वोका पर दुख अना सकंट आहेत, पयले यहूदी पर, मंग गैरयहूदी पर। ");
INSERT INTO pwr_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","हरेक मानूस जोन साजरो काम करासे, वोला महिमा मान, अना सान्ती मिल्हेत, पहले यहूदी मंग गैरयहूदी गीनला। ");
INSERT INTO pwr_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","परमेस्वर कोनी को तरफदारी नही करा से। ");
INSERT INTO pwr_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","जोन मोसे को नियम को जाने बगेर पाप करा से, वोला बिना मोसे को नियम को दन्ड भेटेत। अना जोन को कना मोसे को नियम से, अना पाप करीसेस, वोको नियाव मोसे को नियम, को लक होहेत। ");
INSERT INTO pwr_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","काहेका परमेस्वर को कठा मोसे को नियम को आयकन वाला नही, पर वोको लक चलन वारा नेक ठहरायो जावासेत। ");
INSERT INTO pwr_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","मंग जो गैरयहुदी सेत अना उनको कठा मोसे को नियम नाहती, वय आपरो सुभाव लक, मोसे को नियम को बात ला मानसे। ता वय मोसे को नियम नही होवन को मंघा, भी आपरो हिरदय मा मोसे को नियम ठेवा सेत। ");
INSERT INTO pwr_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","असो वय मोसे को नियम ला आपरो हिरदय मा लिख्यो दिसासेत, अना उनको अक्कल भी यो गोस्टी को गवाही देवा से। अना उनको आपस को विचार उनला, कभी दोसी अना कभी निरदोस ठैयरावा सेत। ");
INSERT INTO pwr_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","यो वोना दिवस होहेत, जोन दिवस साजरो बारता को लक यीसु मसीह को लक मोसे, परमेस्वर मानूस गीन को लुकी बात को, न्याय करके दन्ड देहेत। ");
INSERT INTO pwr_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","अना तुम जोन यहूदी कहलावा सो। अना तुम मोसे को नियम मा भरोसा राखासो, अना परमेस्वर मा घमन्ड राखासो। ");
INSERT INTO pwr_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","अना परमेस्वर को काजक मरजि सेत? तुमला मालूम सेत। अना मोसे को नियम को सिक्सा पायके, तुमिला खरो अना खोटोमा परख सेत। ");
INSERT INTO pwr_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","अना तु आपरो आप मा भरोसा राखासे, का मी अन्धरा गिन ला रास्ता चोवान वारा, अना इन्धार मा पडयो मानूस गीन को, उजाड़ सेऊ। ");
INSERT INTO pwr_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","अना मुरख ला सिकावन वारा, अना लेकरागिन ला सिक्सा देवन वारा सेउ। अना गियान अना खराई को नमूना सेऊ, मोला यो सबा मोसे को नियम लक भेटयो से। ");
INSERT INTO pwr_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","पर तु मुनादी करा सेत, का चोरी नोको करो। अना तू खुदच चोरी करा सेत। पर तुमी स्वता ला सिक्सा नही देवा सो, पर दुसरो ला सिक्सा देवसो। तुमरो तो दियो खाल्या इंधार सेत। ");
INSERT INTO pwr_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","तुम कव्हसो छिनाला नोको करो, अना का खुदच करासो। तुमी मुरत लक घिरना करासो, अना मंदिर ला लुटा सो। ");
INSERT INTO pwr_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","तुम मोसे को नियम मा घंमड करा सो, तरी मोसे को नियम को हुकूम ला तोड़ा सो, अना परमेस्वर ला बेइज्‍जत करा सेव। ");
INSERT INTO pwr_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","काहेका जसो मोसे को नियम मा लिखीसे, गैरयहुदी मा परमेस्वर को नाव को बदी होवासे। कारन तुमरो यो काम। ");
INSERT INTO pwr_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","यदि तुमी मोसे को कानून को पालन करा सेत। ता किमती सेत तुमरो खतना! पर तुमी मोसे को कानून ला तोड़ा सेव। ता खतना लका तुमरो काजक फायदा? ");
INSERT INTO pwr_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","यदि गैरयहुदी को खतना नहीं होवासे, अना मोसे को हुकूम माना सेत। ता खतना को कोनी जरुरत नाहोती। ");
INSERT INTO pwr_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","जोन बिना खतना को, मोसे को नियम को पूरो हुकूम ला माना सेत, उ तुमरो न्याय करयेत। काहेका जोन हुकूम मोसे को नियम मा लिख्यो सेत, वोला तुमी यहुदी होवन को बाउजूद भी तोड़ासो। ");
INSERT INTO pwr_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","यो सब को बाद, जोन एक असली यहूदी से, सहीमा खतना करायो सेत। यो उ मानूस नाहाय जोन बहारी तौरमा यहूदी सेत। वोको लाय खतना देह को सपायी सेत। ");
INSERT INTO pwr_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","तरी असली यहूदी वा मानूस सेत। जोनको दिल को खतना सेत। अना यो परमेस्वर को आतमा को काम सेत, कोनी लिख्यो कानून को नाहोती। असो मानूस को परमेस्वर बड़ाई करा सेत कोनी मानूस नही। ");
INSERT INTO pwr_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","ता यहूदी होवन को काजक फयदा सेत, अना खतना को काजक हेलु सेत? ");
INSERT INTO pwr_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","नही फायदा तो सेत। काहेका सब लक पयले तो कानून उनला च भेटयो होतो। ");
INSERT INTO pwr_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","यदि यहुदी मा लक काही अबिस्वासी हिटयो तो काजक फरक पडसे। का उनको हुकूम तोडनो परमेस्वर को हुकूम ला बिगाड देहेत। ");
INSERT INTO pwr_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","पक्को नही! अदि हरेक मानूस खोटो सेत ता का भयव, परमेस्वर तो खरो से। जसो गीरंथ मा लिख्यो से, “जबा तू सांगेत, तबा तु सही मनो जाहेत, अना जबा तोरो फैसला होयेत, तोरो जीत होयेत।” ");
INSERT INTO pwr_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","तरी का होयेत? अदी आमरो खोटो काम करनो लका परमेस्वर को अधिकार अखिन लगत रूप लक चोवासेत। का अमी कव्ह सका सेत का परमेस्वर अमीला सजा देवा सेत वा खोटो सेत? यदि आमरो अधरम परमेस्वर को न्यायीपन दिसावसे तो आमी काय सांगबिन? ");
INSERT INTO pwr_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","असो पुसनो सुभाविक सवाल सेत। तरी यो सवाल को कोनी मतलब नाहोती। यदि परमेस्वर अन्यायी होतो, तो उ जग को न्याय कसो कर सकेत। ");
INSERT INTO pwr_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","लेकिन का होयेत अगर मोरो खोटो वोको खराई ला अखिन सफा-सफा रुपलक उभो करके परमेस्वर को महीमा को काम करा सेत? मोला अबा भी पापी को रूपमा काहे धिक्कारो जानो पायजे? ");
INSERT INTO pwr_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","काहे नही कव्हबीन? “अमिला बुराई करन देव, जोन लक साजरो भय जाय।” काही लोकहुन, सहीमा असो आरोप लगाय के मोरो बेइज्जती करयो सेत। उनको भी निन्दा होयेत, जसो होवनो पायजे। ");
INSERT INTO pwr_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","मंग का अमी यहुदी गैरयहुदी को संग तखड़ी मा तौलन मा बजनदार सेत? बिलकुल नाही। मिना पयलेच समजायो सेत का, यहुदी अना गैरयहुदी दुयी पाप को ताकत को भितर च सेत। ");
INSERT INTO pwr_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","जसो लिख्यो से कोनी भी असो नाहोति जोन न्यायी होय, ");
INSERT INTO pwr_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","कोनी अक्लवर नाहोति, जोन परमेस्वर को अराधना करतत। ");
INSERT INTO pwr_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","सबा परमेस्वर लक दूहुर भयो सेत। वय सबच वाईट सेत। कोनी असो काम करासेत नाही। जोन परमेस्वर को नजर मा सही सेत। एकच नाही। ");
INSERT INTO pwr_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","उनको गरो उघाड़ो हुवो मठ को जसो सेत। उनको गोस्टी मा छल कपट सेत। अना उनको ओठ मा सरप को जहर सेत। ");
INSERT INTO pwr_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","उनको भासा कड़ु बिक अना सराप लक भरयो सेत। ");
INSERT INTO pwr_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","उनला मारपीट करनो अना जान लक मारन को घायी सेत। ");
INSERT INTO pwr_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","उनको रस्ता सत्यानास, अना बिपत लक भरयो सेत। ");
INSERT INTO pwr_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","ओन्हीसीन सान्ती को रास्ता नही जान पाईन। ");
INSERT INTO pwr_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","अना उनको डोरामा परमेस्वर को भेव नाहती। ");
INSERT INTO pwr_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","आमी जान सेजन का मोसे को नियम जोन काही सांगा सेत, वा वय लोकगीन ला सांगा सेत, जोन कायदा को अधीन सेत। जोन को लक हरेक मानूस को जुबान मा ताला लगी जाय। अना परमेस्वर को पूढा सारो जग सजा को काबील मानो जाय। ");
INSERT INTO pwr_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","काहे का मोसे को नियम को लक कोनी भी मानूस तन परमेस्वर को पूढा धरमी ठहरायो नही जाहेती। मोसे को नियम केवल पाप को गियान करासेत। ");
INSERT INTO pwr_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","तरी अबा परमेस्वर ना लोकगिन को संगा रव्हन को एक असो तरकीब हेड़यो सेत। जोनको कानून लक कोनी मतलब नाहोती। जबकि मोसे अना सबा भविस्यवक्ता गिन ना कानून को पक्स मा गोस्टी कियो सेत। ");
INSERT INTO pwr_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","बिना भेद-भाव को परमेस्वर ना सबा बिस्वासी गिनको लाय, यीसु मसीह मा भरोसा ठेवनो लका परमेस्वर को न्यायीपन दरसायो गयो सेत। ");
INSERT INTO pwr_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","हरेक मानूस ना पाप करयो सेत। अना परमेस्वर कन लक दियो तेज बचाव लक लगत दुहूर सेत। ");
INSERT INTO pwr_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","पर परमेस्वर को किरपा लक फुकट मा दियो, भेट सबला पिरभू यीसु कन लक सूटकारा देयके सहीमा धरमी बनयो गयो सेत। ");
INSERT INTO pwr_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","परमेस्वर ना यीसु मसीह ला लोकहुन को लाय बली को रूपमा दे दियो। जोन लक वोको बोहायो गयो रकत लक वा साधन बन जाय। जेनको लक लोकहुन को पाप ला, वोको मा भरोसा राखन लका माफी कर दियो जाय। परमेस्वर आपरो न्यायीपन दिसावन लाय, जुनो बेरा मा धिरज धरयो। अना लोकगिन को पाप ला अनदेखयो कर देत होता। ");
INSERT INTO pwr_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","पर परमेस्वर अबा को बेरामा पाप ला अनदेखयो नही करतत। पर उ पाप ला हटाय के आपरो धरमी पन दिसावा सेत। अना यीसु मा बिस्वास करन वालो ला साजरो राखा सेत। ");
INSERT INTO pwr_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","एकोलाय कोनी ला आपरो उपर घमंड करन को अधिकार नही रहयो, वोको तो कोनी जघा नाहती, कोनतो नियम को कारन लक, का मोसे को नियम को कारन लक, नही पर भरोसा को नियम को कारन लक, ");
INSERT INTO pwr_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","काहे का आमी मान सेजन का मानूस मोसे को नियम को करमकांड लक अलग, भरोसा लक धरमी ठहरायो जावासेत। ");
INSERT INTO pwr_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","का परमेस्वर केवल यहूदी गीन को परमेस्वर से? का उ गैरयहुदी को परमेस्वर नही सेत। उ सचमूच मा गैरयहुदी को भी परमेस्वर सेत। ");
INSERT INTO pwr_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","काहेका केवल एकच परमेस्वर से। जोन खतना कियो यहूदी गीन ला उनको भरोसा लक नेक ठहरायेति वसोच गैरयहुदी ला उनको भरोसा लक नेक ठहरायो सेत। ");
INSERT INTO pwr_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","तो का हमी यो भरोसा लक मोसे को नियम ला रद्द करासे? कभी नही पर हमी मोसे को नियम ला खरो ठहरावसेजन। ");
INSERT INTO pwr_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","का अमी कहबिन, अबराहम को जोन आमरो जाति को अजी सेत? वोको अनुभव काजक सेत? ");
INSERT INTO pwr_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","यदि अबराहम वोको नेक काम को कारन, नेक गिनयो जातो। तो काही गरब को गोस्टी होतो। तरी परमेस्वर को नजर मा वोको काम, काही महात्व को नाहोति? ");
INSERT INTO pwr_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","गिरंथ कव्हसेत, “अबराहम ना परमेस्वर मा बिस्वास करीस, , अना वोको बिस्वास को कारन परमेस्वर ना वोला सही मानयो।” ");
INSERT INTO pwr_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","काम करन वालो मानूस ला बनी दियो जावा सेत। तरी वा भेट नाहोती। वोला काही असोच भेटयो होतो। ");
INSERT INTO pwr_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","तर यदि कोनी मानूस काम करन को बजाय वोना परमेस्वर मा बिस्वास करा सेत, जोन पापी ला भी सोड़ देवा सेत। ता वोको बिस्वास च वोको नेक होवन को कारन बन जावा सेत। ");
INSERT INTO pwr_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","राजा दाऊद, असो मानूस ला धन्य कव्हसेत। जोनला परमेस्वर बिना काम करे नेक माना सेत। ");
INSERT INTO pwr_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","“धन्य से उ जोन को पाप छिमा भयो सेत, अना उनको खोटो करम ढाकयो गयो सेत! ");
INSERT INTO pwr_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","धन्य से उ मानूस, जोन को पाप को लेखा-जोखा परमेस्वर नहि राखासे।” ");
INSERT INTO pwr_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","क असो धन्य बचन खतना कियो यहूदी काजी सेत, या गैरयहुदी काजी सेत? आयको आमी का सांगि सेजन, “अबराहम ना परमेस्वर मा बिस्वास करीस, अना यो वोको लाय नेकी गीनो गयो।” ");
INSERT INTO pwr_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","वोला कसो नेक मानूस गीनो गयो? का वोना बेरा लक, वोला आपरो खानदान ला खतना कराके बेगरो करन को बिधान भेटयो होतो। का नहि? वोना बेरा लक असो बिधान नही आयो होतो। उ तबा बिना खतना को होतो। ");
INSERT INTO pwr_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","बाद मा वोको खतना कियो गयो, अना वोको खतना यो दिसान को एक निसान होतो। का वोको बिस्वास को कारन परमेस्वर ना वोको खतना लक पयले नेक इन्सान मान लियो होतो। अना एकोलाय अबराहम उन सबको दआजी सेत। जोन परमेस्वर मा भरोसा राखा सेत। अना वोको लका नेक मानूस को रूप मा स्वीकार कियो जावा सेत। चाहे उनको खतना नहीं हुयो होय। ");
INSERT INTO pwr_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","अबराहम खतना करन वालो को भी दआजी से। मजे, खतना करवान वालो को अलावा, बिस्वास को वोच जिंदगी ला भी जीवा सेत। जोन खतना करन लक पयले आमरो दआजी अबराहम ना जीयो होतो। ");
INSERT INTO pwr_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","जबा परमेस्वर ना अबराहम अना वोको खानदान लका वादा कियो होतो, का दुनिया लक वोको सम्बंध होयेत। ता वोना असो एकोलाय नही करयो, का अबराहम ना कानून को पालन कियो होतो। बल्कि एकोलाय का उ मानत होतो, अना परमेस्वर लक नेकी को रुपमा स्वीकार कियो गयो होतो। ");
INSERT INTO pwr_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","काहेका परमेस्वर जोन वादा करा सेत। वोला कानून को पालन करन वालो ला दियो जावा सेत, ता बिस्वास को काजक मतलब सेत? अना परमेस्वर को वादा बेकार सेत। ");
INSERT INTO pwr_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","कानून परमेस्वर को गुस्सा ला कम करा सेत। तरी जितानी कानून नोहोति, उतानी हुकूम तोड़न को सवाल च नाहती। ");
INSERT INTO pwr_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","अना एकोलाय यो वादा बिस्वास को अधार मा होतो। जोनलक वादा ला सबा अबराहम को खानदान लाय, पक्को परमेस्वर को कन लक भेट दियो जाय। नाच केवल कानून ला मानन वाला लोकगिन लाय, बल्कि उन लोक गिनको लाय भी जोन अबराहम ला माना सेत। काहेका अबराहम सबा बिस्वासी गिनको दआजी आय। ");
INSERT INTO pwr_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","जसो का गीरंथ कव्हासेत, “मीना तोला लगत देस को दआजी बनायो सेत। वोना परमेस्वर को नजरमा अबराहम आमरो दआजी से।” जोनको असो बिस्वास होतो का, परमेस्वर मरयो हुया ला जिंदगी देवा सेत। अना जोन नाहती वा भी बन जावा सेत। ");
INSERT INTO pwr_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","सबा मानूस को आस को बिरोध मा आपरो आस ला मनमा सपना मा चोय के अबराहम ना बिस्वास करयो, एकोलाय उ कहयो हुया गोस्टी को कारन लगत देस को दआजी बनयो। जसो लिखयो होतो, “तोरो खानदान लगत होयेत।” ");
INSERT INTO pwr_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","अबराहम करीब सम्बर साल को होतो। तरी वोको बिस्वास कमजोर नाहोति। जबा वोना आपरो देह को बारेमा बिचार करयो, जोन पयले लक कोनी काम को ना होतो, अना सारा भि लेकरा जलम देवन को काबिल नाहोती। ");
INSERT INTO pwr_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","वोको बिस्वास ला वा नहीं सोड़यो, अना उ वादा मा सक नही करयो, वोको बिस्वास मा ताकत होतो, अना वा जोस लक भर गयो अना परमेस्वर को स्तुति करयो। ");
INSERT INTO pwr_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","अना वोला पक्को भरोसा होतो का परमेस्वर आपरो परन ला जरूर पूरो करयेत। ");
INSERT INTO pwr_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","यो बिस्वास को कारन उ नेक मानूस कहलायो ");
INSERT INTO pwr_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","मोसे को नियम को यो बचन न केवल अबराहम लक, ");
INSERT INTO pwr_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","बल्कि आमरो लक भी सम्बन्ध राखासे। यदि आमी परमेस्वर पर भरोसा राखा सेजन। पिरभू यीसु ला मरयो हुयो मा लक जित्तो करिसेत, तो हमी असोच भरोसा को कारन नेक मानूस मानो जाबिन। ");
INSERT INTO pwr_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","वोच यीसु आमारो पाप को कारन धरयो गयो, अना हमला पाप छिमा कर नेक मानूस ठयरावन काजी जित्तो भयो। ");
INSERT INTO pwr_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","अब आमी बिस्वास को लक परमेस्वर को नजरमा नेक मानूस सेजन, ता अमी आमरो पिरभु यीसु मसीह लक परमेस्वर संग मिलाप कर लेयबीन। ");
INSERT INTO pwr_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","उ अमिला परमेस्वर को किरपा मा बिस्वास को लका आनयो सेत जोनमा अमी अबा सेजन। अना अमिला असो आस सेत का परमेस्वर को महीमा मा आमरो हिस्सादारी सेत। ");
INSERT INTO pwr_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","इतरोच नहि आमी दुख अना तकलिफ मा भी, घमंड करबीन। काहेका आमी जाना सेजन का, दुख तकलिफ लक धिरज, पैदा होवा सेत। ");
INSERT INTO pwr_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","धीरज परमेस्वर को मंजूरी अना सेत। अना वोको मन्जूरी उम्मीद पैदा करतत। ");
INSERT INTO pwr_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","अना आस अमिला निरास नहीं होन देवा सेत। काहेका पवितर आतमा कन लका जोन अमिला दियो गयो सेत। परमेस्वर को पिरेम आमरो हिरदय मा, उबड़ायो गयो सेत। ");
INSERT INTO pwr_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","जबा अमी अता बेसहारा होतिन। तबच सही बेरा मा पापीगिन लाय मसीह ना आपरो बली दियो। ");
INSERT INTO pwr_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","कोनि नेक इंसान को लाय मरनो कोनी मुस्किल काम सेत का? हव असो भी होय सका सेत कोनी असो करन को हिम्मत कर सका सेत। ");
INSERT INTO pwr_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","परा परमेस्वर ना अमिला दिसायो का उ आमरो लक कितरो माया करा सेत। जबा अमी अबा पापी होतिन। तब च मसीह आमरो लाय मरयो। ");
INSERT INTO pwr_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","यदि आमी मसिहा को खून को कारन धरमी ठहरायो गयो, तो आमी पक्को मसिहा मा परमेस्वर को गुस्सा लक बच जाबीन। ");
INSERT INTO pwr_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","आमी परमेस्वर को बैरी होतिन, पर जबा परमेस्वर को संग आमरो मेल, वोको टूरा को मरन लक भई गयो। तब परमेस्वर को सगं मेल हो जान को कारन लक, वोको टूरा को जीवन लक पक्को आमरो सूटकारा हो जाहेति। ");
INSERT INTO pwr_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","इतरोच नही, अबा तो आमरो पिरभू यीसु मसीह कन लक परमेस्वर ले आमरो मेल भई गयो। एकोलाय आमी वोको लक परमेस्वर पर भरोसा राखके घमंड करासेजन। ");
INSERT INTO pwr_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","यो गोस्टी बिचार करन जोग से। का एकच मानूस लक जग मा पाप आयो, अना पाप लक मौत, असो परकार सबा मानूस मा यो मौत फैल गई। काय से की सबच पापि सेत। ");
INSERT INTO pwr_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","मोसे को नियम को पुढ़अ जग मा पाप होति, पर नियम नही होवन को कारन पाप को लेखा नही लियो जात होतो। ");
INSERT INTO pwr_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","मंग आदम ले मोसे लक मरनो, उन लोकगीन पर राज करत होति। जोन ना आदम को जसो कोनी हुकूम ला नही तोड़ी होति मजे पाप नही कियो होतो। आदम उ मानूस को रुप से, जोन आवन वालो होतो। ");
INSERT INTO pwr_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","मंघ आदम को गलती, अना परमेस्वर को बरदान ला, कोनी बरोबरी नही से, यो सच्चो से की, एकच मानूस को गलती को कारन लक सबच लोक मरीन पर यो फर लक कदी जादा महान सेत। परमेस्वर को दया, अना वो दया लक भरो वरदान, जो एकच मानूस यीसु मसीह लक, सबला छिमा भेटयो से। ");
INSERT INTO pwr_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","एक मानूस को गलती अना परमेस्वर को बरदान को बरोबरी नाहती। एक को गलति को कारन लक दन्ड को हुकूम दियो गयो। पर गजब गलती को मघा बरदान दियो गयो, जोन लक पाप लक छिमा मिल गयो। ");
INSERT INTO pwr_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","यो सचसे का मरन को राज, एक मानूस को गलति को कारन, एक च लक सुरु भई। पर एको फर लक कहि लगत जोन लोकगीन ला परमेस्वर को किरपा अना धरमिपन को बरदान ज्यादा लक ज्यादा मिलहेत। वय एकच मानूस यीसु मसीह को लक पाप को छिमा भेटत। ");
INSERT INTO pwr_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","एकोलाय जसो एक गलति, सब मानूसगिन को लाय दन्ड को, हुकूम को कारन भयो। वसोच एक नेकी को काम भी, सब मानूस को लाय जीवन को कारन ठैयरेत। ");
INSERT INTO pwr_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","काहेका जसो एक मानूस को हुकूम नही मानन को कारन गजब लोकगीन पापी ठहरिन, वसोच एक मानूस को हुकूम माननो लक, गजब लोकगीन नेक ठहरायो गइन। ");
INSERT INTO pwr_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","कानून ला खोटो तरीका लक बढान को लाय पेस कियो गयो होतो। परा जबा पाप बढयो तबा परमेस्वर को किरपा भी लगत बढ़ गयो। ");
INSERT INTO pwr_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","एकोलाय जसो पाप मौत को कारन सासन करा सेत। वसोच परमेस्वर की किरपा को भी नियम, अमीला यीसु मसीह को कारन अमर जीवन को कन लेजावा सेत। ");
INSERT INTO pwr_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","मसीह मा अमी काजक कव्हबीन? का आमी पाप करत रहबीन, का किरपा गजब होहेत? ");
INSERT INTO pwr_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","पक्को रूप लक नहीं! अमी पाप करन लाय मरयो सेत। मंग अमी योमा कसो रव्हबीन? ");
INSERT INTO pwr_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","तुमी, पक्को जाना सेव का, जब अमी मसीह यीसु को संग बपतिस्मा ले रहयो होतो। तो अमीला वोको संग मरनो को बपतिस्मा दियो गयो होतो। ");
INSERT INTO pwr_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","मंग आमरो बपतिस्मा लक अमी वोको संग दफनायो गयो अना वोको मौत मा साझा करयो, असो परकार लक जसो मसीह को दआजी, को सानदार ताकत लक मरनो लक जित्तो भयो। वसोच अमिला भि नवा जिंदगी भेटेत। ");
INSERT INTO pwr_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","जब लक अमी मरनो को संग, वोको संग एक भयी गयो सेत। ता जसो उ जित्तो से, वसोच अमी भी वोको संग जित्तो रव्हबीन। ");
INSERT INTO pwr_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","अमी यो जाना सेजन का, आमरो मा जोन जूनो मानूस होतो, उ यीसु को संगच मा सूली मा चघा दियो होतो जोनलक आमरो पाप वालो देह नास भयी जाय। अना अमी पाप को गुलामि लक सोड़ाया गयो मनूससेजन। ");
INSERT INTO pwr_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","काहेका जोन मर गई सेत, उ पाप लक सूट गयो अना निरदोस ठहरो सेत। ");
INSERT INTO pwr_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","एकोलाय यदी आमी यीसु मसीह को संग मर गयो। तो आमरो भरोसा यो से, का आमी वोको संग जीवबीन भी। ");
INSERT INTO pwr_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","काहेका यो जाना सेजन का यीसु मसीह मरो हुवो मा लक जित्तो भई के दुबारा नही मरन को। अना वोको पर मंग मिरतु को राज नही होवन को। ");
INSERT INTO pwr_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","काहेका जोन मर गयो से तो उ एकच बार पाप को काजी मर गयो सेत। अना जोन जित्तो से उ तो उ परमेस्वर को काजी जित्तो से। ");
INSERT INTO pwr_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","असोच तूमी स्वता पाप को काजी मरो, अना परमेस्वर को काजी यीसु मसीह मा जित्तो समझो। ");
INSERT INTO pwr_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","एकोलाय पाप तुमारो नासमान तन मा, राज नोको करे। का तुमी वोको मुताबिक चलन लगो। या वोको लालच को लक जीवन करो। ");
INSERT INTO pwr_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","अना आपरो आँग ला बदी को हथियार होवन को लाय पाप ला नोको सोपो। तुमी अपरो आप ला मरो हुया मा लक जित्तो समझके अपरो आप ला परमेस्वर ला दे देव। अना आपरो देह ला धरमिपन को हतियार बनन काजी परमेस्वर ला सोप देव। ");
INSERT INTO pwr_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","तबा तुमरो पर पाप को राज नही होयेति। काहेका तुमी मोसे को नियम को दास नही पर किरपा को आधीन सेव। ");
INSERT INTO pwr_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","मंग काजक, अमी दुबारा पाप करबीन? काहे का अबा अमी कानून को नही पर परमेस्वर को किरपा को अधिन सेजन। अमी कोनी परकार लक पाप नहि कर सकत। ");
INSERT INTO pwr_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","जबा तुमिला मालुम सेत, का कोनी को मानन लाय जबा तुम्ही तैयार होवा सेव। ता दास को रूपमा आपरो-आपला देवा सेव। तो वो तुमरो मालिक अना तुमी गुलाम भयी जासो। जोन पाप करा सेत वा पाप को गुलाम सेत जोनको फर मिरतू सेत। चाहे हुकूम माननो जोनको फर नेकी सेत। ");
INSERT INTO pwr_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","पर परमेस्वर को लाय धन्यवाद! तुमी एक बेरा पाप करन को लाय पाप को गुलाम होतो। पर अबा आपरो दिल लक भेटयो सिक्सा को माननवारा भई गयो, जेन को साँचा मा ढालो गयो सेत। ");
INSERT INTO pwr_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","अना पाप को कब्जा लक छुडायो जाके नेकपन को दास बन गयो सेत। ");
INSERT INTO pwr_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","मी तुमारो आँग को निरबलता को कारन मानूस को रीत लक कव्हसू। जसो तुमरो देह ला कुकरम को लाय बुराई अना खोटो करम को दास बनाके सोपो होतो। वसोच अबा आपरो देह ला धरमी होवन को कजि, वोको दास बनाके सोपो। ");
INSERT INTO pwr_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","जबा तुमी पाप को दास होतो। तो धरम को कन लक सूट होति। ");
INSERT INTO pwr_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","अबा जोन बात मा तूमी लज्जित होवा सो, उनमा वोना बेरा तुमीला काजक भेटत होतो। काय का वोको अन्त तो मरनो सेत। ");
INSERT INTO pwr_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","पर अबा पाप को कब्जा लक सूटकारा पायके अना परमेस्वर को दास बनके तुमला फर मिल्यो से, जेनको लक तूमी पवीतर भई जावासो। अना वोको अन्त अमर जीवन सेत। ");
INSERT INTO pwr_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","काहेका पाप को बनी तो मरनो से, पर परमेस्वर को बरदान आमरो पिरभू यीसु मसीह मा अमर जीवन सेत। ");
INSERT INTO pwr_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","अगो भाऊहुन! सहि मा का तुमी समजा सेव? जबा तकन मानूस को जिंदगी सेत तबा तकन च वोको लाय कानून सेत। का तुमी नही जानासो? ");
INSERT INTO pwr_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","समजन को लाय यो उदाहरन सेत। काहेका सादि-सूदा भी मोसे को नियम को लक आपरो मरद को जित्तो जी वोको लक बन्धो रव्हसेत। पर यदि वोको मरद मर जावासे, तबा वा आपरो मरद लक सूट जासेत। ");
INSERT INTO pwr_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","एकोलाय यदि कोनी बायका आपरो मरद को जित्तो जी वा कोनी दुसरो मरद को भई जाय। ता वोला छिनाल कव्हा सेत। तरी वोको मरद मर जाय तो वा मोसे को नियम अनुसार वा वोको लक वोको लक सूट गई, अना कोनी दुसरो मरद को भई जाय तो कोनी पाप नाहती। ");
INSERT INTO pwr_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","अगो मोरो भाऊ हुन असोच मसीह को देह को लक तुमी कानून को लाय मर गयो सेव। एकोलाय अबा तुमी कोनी दुसरो लक नातो जोड़ सका सेव। वोको लकजोन मरयो हुया लक मंग जित्तो भयो सेत। जोन लक अमी परमेस्वर को लाय साजरो काम कर सकत। ");
INSERT INTO pwr_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","जबा अमी मानूस को जसो जिंदगी बितावा सेत। ता कानून लक दियो गयो पाप को लालच आमरो देहमा काम करा सेत। अना येको आखीर मौत से। ");
INSERT INTO pwr_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","तर अबा कानून लक सूटकारा भेटयो सेत। काहेका जोन कानून ना अमीला बांधयो होतो वोको काजी अमी मर गयो सेत। अना अबा, जूनो लिख्यो कानून लक नही, बल्कि आतमा को नवा रीत लक अमी आपरो मालिक को सेवा करा सेजन। ");
INSERT INTO pwr_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","अमी काजक कव्हबीन? का कानून खुदच पापी से बिलकूल नही! पर यो कानून होतो जोन ना सांगयो का पाप काजक सेत? अगर कानून यो नही सांगयो होतो का लोभ नोको करो, तो मोला मालूम नही होतो का लोभ करनो पाप सेत। ");
INSERT INTO pwr_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","पर पाप ना डाव चोवके हुकूम लक, मोरो मा, सब परकार को लोभ पैदा करीस। काहेका बिना मोसे को नियम को पाप मुरदा से। ");
INSERT INTO pwr_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","मी तो मोसे को नियम बिना पयले जित्तो होतो। पर जबा हुकूम आयो तबा पाप जी गई, अना मी मर गयो। ");
INSERT INTO pwr_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","10","अना वोच हुकूम जेन जीवन को लाई होती। मोरो लाय मरन को कारन बनी। ");
INSERT INTO pwr_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","काहेका पाप ना मौका पायके हुकूम लक मोला बहकायो, अना वोको लक मोला मार डाख्यो। ");
INSERT INTO pwr_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","एकोलाय मोसे को नियम पवीतर सेत, अना हुकूम भी न्याय अना भला सेत। ");
INSERT INTO pwr_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","तो का उ जोन साजरो होती। मोरो काजी मरनो को कारन बनी? कभी नही! पर पाप वोना साजरो चीज लक मोरो लाय मरनो पैदा करनवारा बनी। का वोको पाप पूढा चोवयेती। अना हुकूम को लक पाप गजब बेकार साबीत भई जाये। ");
INSERT INTO pwr_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","काहेका अमीला मालूम सेत, का कानून तो आत्मिक सेत। अना मी हाड़-माँस को मानूस सेऊ। जोन पाप को हात बिकयो गुलाम सेऊ। ");
INSERT INTO pwr_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","मोला मालूम नाहती, मी काजक करा सेऊ। काहेका जोन मी करनो चाव्हअ सेऊ, मी नही करा सका सेऊ। पर जोन लक मोला घिरना आवा सेत, वोच काम मोरो लक होवासेत। ");
INSERT INTO pwr_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","यदी मी जोन नही चव्हासू, अना वोच करासू, तो मी मान लेवसू का कानून साजरो सेत। ");
INSERT INTO pwr_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","एकलाय मी सहीमा उ नही सेऊ। जो असो काम करा सेत। बल्कि यो वा पाप सेत। जोन मोरोमा रव्हसेत। ");
INSERT INTO pwr_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","मोला मालूम सेत। का नेकी मोरो मा नाहती। मजे मानूस को सुभाव मा। भलो मोरो मनमा साजरो करन को मरजी सेत। परअ मी साजरो नही कर सका सेऊ। ");
INSERT INTO pwr_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","वा नेकी को काम जो मी करनो चाव्हसू, नही करा सका सेऊ, पर मी बदी करा सेऊ जोन मी करनो नही चाव्हसू। ");
INSERT INTO pwr_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","अबा मी जोन नही चव्हासू वोच करासू तो करनवारा मी नही सेव। पर पाप जोन मोरो मा बसो हुवो सेत। ");
INSERT INTO pwr_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","एकोलाय मी आपरो आपमा यो नियम चोवअ सेऊ। जबा मि नेकी करनो चाव्हसू, ता मोरो मा बदी चोवासेस। ");
INSERT INTO pwr_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","मी यो भीतर को परमेस्वर को नियम लक खुस सेऊ। ");
INSERT INTO pwr_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","23","तर मोरो देहमा काम करन को एक बेगरो कानून चोवअ सेत। एक असो कानून जोन वोना कानून को खिलाफ लड़अ सेत। जोनला मोरो डिमाक मंजूर करा सेत। यो मोला पाप को कानून कोलाय कैदी बनावा सेत। जोन मोरो देहमा काम करा सेत। ");
INSERT INTO pwr_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","24","मी एक दुखी मानूस सेऊ! मोला यो देह लक कउन सोड़ाहेत? जोन मोला मरासेत। ");
INSERT INTO pwr_vpl VALUES ("RM7_25","075_7_25","ROM","7","25","25","परमेस्वर को लाय धनवाद जोन आमरो पिरभू यीसु मसीह कोलक यो करा सेत। मंग मोरो यो हालत सेत। आपरो दम मा मी आपरो मन लक सिरप परमेस्वर को कानून को सेवा करा सका सेऊ। जबकि मोरो आदत मा पाप को कानून काम करा सेत। ");
INSERT INTO pwr_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","अबा यीसु मसीह को संग मा रव्हन वालो पर कोनी दन्ड को हुकूम नाहती। ");
INSERT INTO pwr_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","आत्मा को कानून, जोन अमिला मसीह यीसु मा जिंदगी देवा सेत। वा अमिला पाप अना मिरतु को कानून लक सूटकारा दे दियो सेत। ");
INSERT INTO pwr_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","यो काम ला कानून नहीं कर सकयो, तबा परमेस्वर ना आपरो स्वता को टूरा लक यो काम करायो। जसो कमजोर देह लक अमी पाप करा सेजन, वसोच देह मा परमेस्वर ना आपरो टूरा ला धाड़ीस। जोन लक पाप ला निरस्त कर देवे। ");
INSERT INTO pwr_vpl VALUES ("RM8_4","075_8_4","ROM","8","4","4","परमेस्वर ना असो करयो सेत, यो साठी का कानून को नेक जरुरत पुरो करयो जाय। यो कारन लका अमी मानूस को सुभाव को अनुसार नाही। तर आतमा को सुभाव को अनुसार चलनो पूरो भयी जाय। ");
INSERT INTO pwr_vpl VALUES ("RM8_5","075_8_5","ROM","8","5","5","जोन लोक मानूस को सुभाव को अनुसार बिचार मा रव्हा सेत। वोको मन मानूस को इक्सा अनुसार रव्हसेत। तरी जोन लोक आतमा को अनुसार रव्हअ सेत। वोको मन आतमा ला काजक पहिजे, यो इक्सा को लाय ब्यस्त रव्हअ सेत। ");
INSERT INTO pwr_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","6","तन मा मन लागवनो तो मिरतू सेत, पर पवीतर आतमा मा मन लगावनो जीवन अना सान्ती सेत। ");
INSERT INTO pwr_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","7","काहेका तन मा मन लगावनो तो, परमेस्वर लक बैर करनो सेत। काहेका असो ता ना तो परमेस्वर को नियम को लक सेत, अना ना होय सका सेत। ");
INSERT INTO pwr_vpl VALUES ("RM8_8","075_8_8","ROM","8","8","8","अना जोन मानूस को इक्सा मा ब्यस्त रव्हा सेत। ते परमेस्वर ला आनंद नाही देव सकत। ");
INSERT INTO pwr_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9","पर जबा परमेस्वर को आतमा तुम मा रव्हा सेत। तो तुमी देह को दसा मा नही, पर आतमिक दसा मा सेव। यदि कोनी मा मसीह को आतमा नाहती तो उ मसीह को लोक नाहती। ");
INSERT INTO pwr_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","यदि मसीह तुमी मा रव्हा सेत, तो पाप को कारन देह मरयो हुया सेत। तर परमेस्वर को सूटकारा को नेक कानून को कारन पवीतर आतमा तुमरो जीवन मा सेत। ");
INSERT INTO pwr_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","जोन ना यीसु ला मरयो हुयो मा लक जित्तो करयो। अना वोको आतमा तुम लोकगीन मा रव्हअ सेत। वा च तुमरो नासवान देह ला भी जीत्तो करा देहेत। ");
INSERT INTO pwr_vpl VALUES ("RM8_12","075_8_12","ROM","8","12","12","एकोलाय मोरो संगी हुन! आमरो पर यो देह को करजा तो सेत, पर अमिला मानूस को स्वाभाविक मरजी को अनुसार जित्तो रव्हअनो नाहती। भलो च आमरो मन असो करन लाय साठी उकसावे। ");
INSERT INTO pwr_vpl VALUES ("RM8_13","075_8_13","ROM","8","13","13","पर यदि तुमी आपरो मानूस सुभाव को अनुसार रव्हअ सेव, ता तुमी मरन वालो सेव। तरी आतमा लक मनला मार के जिंदगी को दिवस बितावअ सेव। ता जित्तो रव्हन को मौका सेत। यो काजी आतमा लक बुरो करम ला मार डाखो। ");
INSERT INTO pwr_vpl VALUES ("RM8_14","075_8_14","ROM","8","14","14","जोन आतमा को अनुसार जिंदगी बितावा सेत वा च परमेस्वर को सन्तान सेत। ");
INSERT INTO pwr_vpl VALUES ("RM8_15","075_8_15","ROM","8","15","15","परमेस्वर तुम्हिला आपरो आतमा को गुलाम नही बनावा सेत। यो काजी तुम्हीला परमेस्वर को सन्तान बननो मा भेव लगअ सेत। तरी आतमा तुम्हिला परमेस्वर को लेकरा बनावा सेत। अना वोनअ च आतमा को ताकत को कारन तुम्ही परमेस्वर ला दआजी कव्हा सेव। ");
INSERT INTO pwr_vpl VALUES ("RM8_16","075_8_16","ROM","8","16","16","ता परमेस्वर को आतमा स्वता आमरो आतमा को संग मिलके कव्हा सेत। का अमी परमेस्वर को लेकरा सेजन। ");
INSERT INTO pwr_vpl VALUES ("RM8_17","075_8_17","ROM","8","17","17","अदी अमी वोको लेकरा सेजन। ता वोको दियो गयो आसीरवाद मा आमरो च हक सेत। अना जबा अमी मसीह को संग सेजन ता वोको संग अमिला दुख उचलनो पायिजे। तबच अमीला वोको संग गौरव भेटेत। ");
INSERT INTO pwr_vpl VALUES ("RM8_18","075_8_18","ROM","8","18","18","मोरो असो माननो सेत, का अबा अमी जोन काही भी दुख भुगत रव्हयो सेजन, वोको तवल मा वोना गौरव को संग जोन अमिला मिलनवारो सेत, लगत हलको सेत। ");
INSERT INTO pwr_vpl VALUES ("RM8_19","075_8_19","ROM","8","19","19","परमेस्वर को सबच रचना, परमेस्वर को लेकरा गिनको जलम होवन को रस्ता लगत आस लक चोवअ सेत। ");
INSERT INTO pwr_vpl VALUES ("RM8_20","075_8_20","ROM","8","20","20","यो दुनिया को सबच रचना बेआस होतो, यो जगत आपरो मरजी लक बेआस नहि होतो, तरी असो बनावन वारो को मरजी होतो। ");
INSERT INTO pwr_vpl VALUES ("RM8_21","075_8_21","ROM","8","21","21","मंग अबा भी आस होतो। का दुनिया आपरो गुलामी लक अजाद होवके, परमेस्वर लेकरा गिनको संग गौरव को संग हिस्सादारी करयेत। ");
INSERT INTO pwr_vpl VALUES ("RM8_22","075_8_22","ROM","8","22","22","अमीला मालुम सेत, का अज लका पूरो रचना दुख अना दरद लक कुन्हाय रव्हयो सेत। ");
INSERT INTO pwr_vpl VALUES ("RM8_23","075_8_23","ROM","8","23","23","पर अकेलो दुनिया को रचना च नही कुन्हावअ सेत। मंग परमेस्वर को भेटयो लका एक आतमा भी सेत। वा भी आपरो भितर ढुकअ सेत, काहेका अमी यो काजी परमेस्वर को रस्ता चोवा सेजन। का वो अमिला आपरो लेकरा बनाय के आमरो पुरो जिंदगी को सूटकारा कर देवे। ");
INSERT INTO pwr_vpl VALUES ("RM8_24","075_8_24","ROM","8","24","24","अमी बचायो गयो सेत यो गोस्टी को आमरो मनमा आस सेत। तरी अमी जोन गोस्टी को उमेंद करा सेजन। वोला अमी आपरो डोरा लक चोवासेजन, ता आमरो आस पुरो भयी जासेत। जोन चोवअ सेत, वा अबा आस नाहती। ");
INSERT INTO pwr_vpl VALUES ("RM8_25","075_8_25","ROM","8","25","25","परअ अबा आमरो आस कियो गयो चीज अमीला नही चोवा सेत। मजे अबा धिरज को संग रस्ता चोवनो बाकी सेत। ");
INSERT INTO pwr_vpl VALUES ("RM8_26","075_8_26","ROM","8","26","26","वोना परकार आतमा भी आमरो मदद करन आवा सेत। जसो अमीसेजन। काहेका अमीला मालुम नाहती का अमिला पिराथना कसो करनो पायजे। आतमा स्वता परमेस्वर लका आमरो लाय तकलीफ को संग पिराथना करा सेत, जोन सबद लक सांगयो नही जासेत। ");
INSERT INTO pwr_vpl VALUES ("RM8_27","075_8_27","ROM","8","27","27","परमेस्वर आमरो दिल ला चोवअ सेत। अना वोला मालूम सेत, का आमरो आतमा को काजक बिचार सेत? काहेका आतमा आपरो लोकहुन को कन लक, अना आपरो इक्सा को अनुसार, परमेस्वर लक पिराथना करा सेत। ");
INSERT INTO pwr_vpl VALUES ("RM8_28","075_8_28","ROM","8","28","28","अमिला मालूम सेत, का परमेस्वर जोनको लक पिरेम राखअ सेत, उनको सबा चीजमा साजरा काम करा सेत। अना उनला आपरो उद्देस्य को अनुसार हकलयो सेत। ");
INSERT INTO pwr_vpl VALUES ("RM8_29","075_8_29","ROM","8","29","29","काहेका जेनना वोला पयले लक जान लियो सेत, अना उनला पयले लक ठहरायो सेत। का परमेस्वर को टूरा को रुप होय। जेनको लक यीसु लगत भाऊ गीनमा पहलौटा ठहरेत। ");
INSERT INTO pwr_vpl VALUES ("RM8_30","075_8_30","ROM","8","30","30","मंग जोन ला वोना पयलो लक ठहरायो, उनला हाकलिस भी उनला नेक मानूस ठहरायो, अना उनको बड़ाई भी करयो सेत। ");
INSERT INTO pwr_vpl VALUES ("RM8_31","075_8_31","ROM","8","31","31","येना सबअ गोस्टीहुन ला चोवता हुया, अमी काजक कव सका सेजन? अगर परमेस्वर आमरो कन लक सेत, ता आमो बिरोध कोन कर सका सेत? ");
INSERT INTO pwr_vpl VALUES ("RM8_32","075_8_32","ROM","8","32","32","परमेस्वर न आपरो सगो टूरा ला आमी सबको काजी मौत को सुपरुत कर दियो। उ यीसु को संग आमीला सबा काही, काहे नही देहेत? ");
INSERT INTO pwr_vpl VALUES ("RM8_33","075_8_33","ROM","8","33","33","परमेस्वर को निवाड़ो हुवो पर कोनी दोस लगाहेत। जबा उनला निरदोस ठहरानवारा खुदच परमेस्वर सेत। ");
INSERT INTO pwr_vpl VALUES ("RM8_34","075_8_34","ROM","8","34","34","मंग कोनी सेत जोन अमीला दन्ड को हुकूम देहेत? यीसु मसीह सेत जोन मर गयो होतो। अना मुरदा लक जित्तो भई सेत। अना परमेस्वर को जेवनो कना सेत। अना उ आमरो लाय निवेदन करा सेत। ");
INSERT INTO pwr_vpl VALUES ("RM8_35","075_8_35","ROM","8","35","35","कोन अमीला यीसु मसीह को माया लक अलग कर सका सेत। का दुख का मुसिबत का उपदरा नगांपन, का गिरानी, का जोखिम, का तरवार, ");
INSERT INTO pwr_vpl VALUES ("RM8_36","075_8_36","ROM","8","36","36","जसो मोसे को नियम मा लिख्यो सेत का “तोरो लाय आमी दिवस भर घात कियो जाय रहयो सेत। आमी बलि होवन वारा मेढा जसो समजो जावअ सेत।” ");
INSERT INTO pwr_vpl VALUES ("RM8_37","075_8_37","ROM","8","37","37","पर ऐना सब गोस्टी मा अमीला यीसु लक पूरो जीत भेटासेत। वोना अमी लक गजब माया राखासेत। ");
INSERT INTO pwr_vpl VALUES ("RM8_38","075_8_38","ROM","8","38","38","मोला मजबूत भरोसा सेत का नातो मिरतू, ना जीवन, ना सरगदूत ना नरक दूत ना अबा को बेरा, ना आवन वारा बेरा ना कोनी अचंभा ताकत, ना अधिकारी ");
INSERT INTO pwr_vpl VALUES ("RM8_39","075_8_39","ROM","8","39","39","ना बादल मा ना कोनी पताल को कोनी ताकत अना ना सारो दुनिया को कोनी चीज, अमीला परमेस्वर को वोना माया लक बेगरो कर सकासेत। जोन आमी ला आमरो पिरभू यीसु मसीह मा लक भेटयो सेत। ");
INSERT INTO pwr_vpl VALUES ("RM9_1","075_9_1","ROM","9","1","1","मी खरो कव्हासेऊ, मी मसीह को सेऊ। मोरी भितरी आतमा, पवितर आतमा को हुकूम मानअ सेत। मी खोटो नही कव्हासेऊ। ");
INSERT INTO pwr_vpl VALUES ("RM9_2","075_9_2","ROM","9","2","2","सचमुच मा, मोरो दुख कितरो मोठो सेत। मोरो दिलमा लगत दरद सेत। मोला लगत सोक सेत, मोरो मन हरामेसा दुखी रव्हअ सेत। ");
INSERT INTO pwr_vpl VALUES ("RM9_3","075_9_3","ROM","9","3","3","अदी मी आपरो सगो रकत को कुटुम्बी लोक गिन लाय, मी उनको सराप आपरो डोस्का मा राख लेवतो। अना मसीह कन लक सरापित भयी जातो। अना मसीह लक बेगरो हो जातो। असो मोरो मरजी सेत। ");
INSERT INTO pwr_vpl VALUES ("RM9_4","075_9_4","ROM","9","4","4","वय परमेस्वर को लोख सेत। परमेस्वर ना उनला आपरो लेकरा बनायो। अना आपरो गौरव उनको समोर दिसायो। परमेस्वर ना उनको संग करार कियो अना उनला कानून दियो। उनको पूजा सच्चो सेत। उनला परमेस्वर को वादा भेटयो सेत। ");
INSERT INTO pwr_vpl VALUES ("RM9_5","075_9_5","ROM","9","5","5","वय जाहीर हिबरू घराना को सेत। अना मसिहा भी उनको च घराना को से। परमेस्वर जोन सबा पर सासन करा सेत, वोको हरामेसा बड़ाई होवे! ");
INSERT INTO pwr_vpl VALUES ("RM9_6","075_9_6","ROM","9","6","6","असो नाहोती का परमेस्वर ना आपरो बचन पूरो नही करयो। काहेका जोन इसरायल को खानदान सेत। वय सबच यिसरायली नाहती। ");
INSERT INTO pwr_vpl VALUES ("RM9_7","075_9_7","ROM","9","7","7","अना ना च अबराहम को खानदान को सबा सचमुच मा अबराहम को खानदान को सेत। बल्कि जसो परमेस्वर ना कव्हयो, “तोरो खानदानी इसहाक को लक आपरो परम्परा बढ़ाहेत।” ");
INSERT INTO pwr_vpl VALUES ("RM9_8","075_9_8","ROM","9","8","8","मजे असो नाहती का देह लक जलम लियो च लेकरा परमेस्वर को खानदानी सेत। बल्कि परमेस्वर को बचन ला मानन वालो भी परमेस्वर को खानदान को सेत। ");
INSERT INTO pwr_vpl VALUES ("RM9_9","075_9_9","ROM","9","9","9","बचन मा असो कहयो गयो होतो। “सही बेरा मा मी लवट आहूँ, अना सारा ला लेकरा होयेत।” ");
INSERT INTO pwr_vpl VALUES ("RM9_10","075_9_10","ROM","9","10","10","इतरो च नही, जबा रिबका भी एक मानूस, आमरो पुरखा इसहाक लक पोट लक भयी ");
INSERT INTO pwr_vpl VALUES ("RM9_11","075_9_11","ROM","9","11","11","पर वोको एक लेकरा ला निवाड़ो अना यो पूरो तौर लक परमेस्वर को खुद को यदेस्य को परिनाम होतो, परमेस्वर ना कहयो यो मोरो निवाड़ो गयो मानूस सेत। ");
INSERT INTO pwr_vpl VALUES ("RM9_12","075_9_12","ROM","9","12","12","टुराहुन को जलम लेवन को पयले अना उनको काही भलो-बुरो करन को पयले च कहयो गयो होतो। का “मोठयो लहान को दास होयेत।” एकोलक असो मालुम होवासेत का, हाकलन वालो खुदच तय करा सेत, का कोनीला निवाड़नो सेत। यो मानूस को करम पर नही पर हाकलन वालो को मरजी पर सेत। ");
INSERT INTO pwr_vpl VALUES ("RM9_13","075_9_13","ROM","9","13","13","गिरंथ मा लिखयो सेत। “मिना याकूब ला निवाड़यो पिरेम करयो, अना एसाव ला नकार दियो।” ");
INSERT INTO pwr_vpl VALUES ("RM9_14","075_9_14","ROM","9","14","14","मंग अमी काजक सांगबीन परमेस्वर अन्याय करा से? कबच नही। ");
INSERT INTO pwr_vpl VALUES ("RM9_15","075_9_15","ROM","9","15","15","पक्कोच नही! काहेका परमेस्वर मोसे भविस्यवक्ता ला कहयो होतो “मी जोन कोनी पर दया करन को बिचार करहीन, वोच पर दया करहीन।” ");
INSERT INTO pwr_vpl VALUES ("RM9_16","075_9_16","ROM","9","16","16","एकोलाय यो मानूस को इक्सा या वोको मेहनत पर नही, पर दया करनवारा परमेस्वर को इक्सा पर सेत। ");
INSERT INTO pwr_vpl VALUES ("RM9_17","075_9_17","ROM","9","17","17","काहेका गिरंथ मा मिसर देस को राजा फराओ लक परमेस्वर कव्हसेत, “मी ना तोला एकोलाय वरता उचली सेव, का तोरो मा आपरा ताकत दिसाऊ, अना सप्पा धरती मा आपरा नाव को परचार करू।” ");
INSERT INTO pwr_vpl VALUES ("RM9_18","075_9_18","ROM","9","18","18","एकोलाय परमेस्वर जोन पर चव्हासेत रहम करासेत। अना जोनला चाहे हटिला बना देवा सेत। ");
INSERT INTO pwr_vpl VALUES ("RM9_19","075_9_19","ROM","9","19","19","एकोलाय तू साइद मोरो लक कव्हजोस “अदि मानूस को काम मा, परमेस्वर को मरजी सेत। ता वा मा आमरो काजक दोस से?” आखीर मा परमेस्वर को इक्सा को विरोध कोन कर सका सेत? ");
INSERT INTO pwr_vpl VALUES ("RM9_20","075_9_20","ROM","9","20","20","मानूस भला तू कोन आस? जोन परमेस्वर ला जवाब पलटा जोस? का कोनी रचना आपरो रचनवालो ला पूस सका सेत, “तूना मोला असो काहे बनायो सेत?” ");
INSERT INTO pwr_vpl VALUES ("RM9_21","075_9_21","ROM","9","21","21","का कुम्भार ला यो अधिकार नहि? का उ माती को एक लोदा आन कन एक भान्डा साजरा काम काजी, अना दुसरो सधारन काम को काजी बनाये। ");
INSERT INTO pwr_vpl VALUES ("RM9_22","075_9_22","ROM","9","22","22","पर योमा काजक सेत? यदि परमेस्वर ना आपरो गुस्सा दिसावन साठी अना आपरो ताकत परगट करन को लाय उन लोकगिन को जोन गुस्सा को लाय होतिन, अना जोनको नास होवन वालो होतो। गजब धिरज लक उन भान्डा ला सहन कियो। ");
INSERT INTO pwr_vpl VALUES ("RM9_23","075_9_23","ROM","9","23","23","जोन लक उ उन लोक गिन को फयदा को लाय, जोनला दया को लाय बनायो होतो, अना जोनला वा आपरो महिमा करन लाय बनायो होतो। उनमा आपरो महिमा चोवा सके। ");
INSERT INTO pwr_vpl VALUES ("RM9_24","075_9_24","ROM","9","24","24","असो दया को भान्डो आमी सेजन। जोनला परमेस्वर ना सिरप यहूदी लक नही, पर गैरयहूदी लक भी हाकलिसेत। ");
INSERT INTO pwr_vpl VALUES ("RM9_25","075_9_25","ROM","9","25","25","जसो उ भविस्यवक्ता होसे को किताब मा कव्हसेत “जोन मोरो परजा नही होतिन, मी उनला आपरो परजा कहूँ, अना जोन मोरो चहेतो नही होति, उनलक मि माया करहू।” ");
INSERT INTO pwr_vpl VALUES ("RM9_26","075_9_26","ROM","9","26","26","अना जोन जघामा परमेस्वर ना उनको लक असो कव्हो होतो “तुमी मोरो परजा नही सेव, उतच वय जित्तो परमेस्वर को सन्तान कहलायेती।” ");
INSERT INTO pwr_vpl VALUES ("RM9_27","075_9_27","ROM","9","27","27","अना भविस्यवक्ता यसायाह इसरायल को बारे मा हाकलके कव्हसेत का “इसरायल लोकगीन को गिनती सागर को बालू जसो काहे ना होहेत, पर उनमा लक काही च बचायो जाहेत।” ");
INSERT INTO pwr_vpl VALUES ("RM9_28","075_9_28","ROM","9","28","28","काहेका पिरभू पूरो रुप लक, लवकर धरती मा आपरा गोस्टी पूरो करयेत। ");
INSERT INTO pwr_vpl VALUES ("RM9_29","075_9_29","ROM","9","29","29","जसो यसायाह भविस्यवक्ता को किताब मा लिख्यो सेत। यदि सेना का परमेस्वर ना आमरो काजी काही खानदान बचाके नही ठेवो होतो, तो आमी सदोम अना गमोरा नगर जसो पूरो सत्यानास हो गयो होतो। ");
INSERT INTO pwr_vpl VALUES ("RM9_30","075_9_30","ROM","9","30","30","ता मंग अमी काजक कहबीन? अमी यो नतिजा मा पोहोचयो सेजन, का गैर यहुदीहुन, परमेस्वर को संग आपरो संबंध साजरा करन को कोसीस नही करत होतिन। मंग उनको बिस्वास को लक उनको संग सही संबंध होतो। ");
INSERT INTO pwr_vpl VALUES ("RM9_31","075_9_31","ROM","9","31","31","पर परमेस्वर को लोगहुन, जोन एक असो कानून चाव्हत होतिन। जोन परमेस्वर को संग सही संबंध राखेत पर उनला नही मिल्यो। ");
INSERT INTO pwr_vpl VALUES ("RM9_32","075_9_32","ROM","9","32","32","अना काहे नही मिल्यो काहेका वय बिस्वास पर निरभर नहि होतिन, पर वय आपरो करम मा निरभर होतिन। एको लाय उनला ठोकर को गोटा मा खोद्दा लगयो। अना काहे नही लगहेत? ");
INSERT INTO pwr_vpl VALUES ("RM9_33","075_9_33","ROM","9","33","33","गिरंथ काजक कव्हासेत? “चोवो, मी सिय्योन मा एक गोटा राखा सेऊ, जोनमा लोकहुन खोद्दा खाहेत, एक चट्टान जोन लक वय पड़ जाहेत। तरी जोन कोनी वोको मा बिस्वास करहेत, वा कभ्भू निरास नही होयेत।” ");
INSERT INTO pwr_vpl VALUES ("RM10_1","075_10_1","ROM","10","1","1","अगो मोरो संगीहुन, मोरो पुरो मन लक चव्हा सेऊ, का मोरो लोकगिन बच जाय, मि उनको लाय पिराथना कसो करू? ");
INSERT INTO pwr_vpl VALUES ("RM10_2","075_10_2","ROM","10","2","2","मी तुमिला सांगासेऊ, वय परमेस्वर को लाय खूप काम करनो चाव्हा सेत। लेकिन उनको यो काम सच्चो भगति अना गियान लक नाहती। ");
INSERT INTO pwr_vpl VALUES ("RM10_3","075_10_3","ROM","10","3","3","वय वोना नेकी को रस्ता ला नही जानत होतिन, जोनला परमेस्वर सिकावनो चाव्हत होतो। अना उनना खुदच आपरो लाय नेकी को रस्ता बनावन को कोसीस करयो। अना उनना परमेस्वर लक सांगयो नेकी को रस्ता ला नही अपनायो। ");
INSERT INTO pwr_vpl VALUES ("RM10_4","075_10_4","ROM","10","4","4","काहे का यीसु मसीह सबच पिरकार लक कानून ला पूरो करासेत। अना हरेक भरोसा राखन वारा ला नेक रस्ता देवा सेत। ");
INSERT INTO pwr_vpl VALUES ("RM10_5","075_10_5","ROM","10","5","5","नेक काम को बारेमा जोन कानून भेटासेत वोको बारे मा मोसे ना लिखयो सेत, जोन कानून ला मानहेत वा वोको कारन जित्तो रहेत। ");
INSERT INTO pwr_vpl VALUES ("RM10_6","075_10_6","ROM","10","6","6","पर जोन भरोसा लक नेक सेत, वोको लाय असो लिख्यो सेत, का तुमी आपरो मन मा असो विचार नोको करो, का सरग मा वरता कोन चघेत? मजे मसीह ला खाल्या आनन लाई। ");
INSERT INTO pwr_vpl VALUES ("RM10_7","075_10_7","ROM","10","7","7","या नरक मा खाल्या कोन जाहेत? मसीह ला मरयो हुयो मा लक वरता आनन काजी। ");
INSERT INTO pwr_vpl VALUES ("RM10_8","075_10_8","ROM","10","8","8","पर मोसे को नियम मा असो लिख्यो सेत। का बचन तोरो जवर तोरो होठ मा अना तोरो मन मा सेत। यो वोच भरोसा को बचन सेत जोन ला आमी मुनादी कर सेजन। ");
INSERT INTO pwr_vpl VALUES ("RM10_9","075_10_9","ROM","10","9","9","यदि तुमी असो स्विकार करा सेव, का यीसु च पिरभू सेत। अना बिस्वास करो का परमेस्वर ना वोला मरयो हुयो लक जित्तो करयो सेत, तो तुम्हि बच जाहो। ");
INSERT INTO pwr_vpl VALUES ("RM10_10","075_10_10","ROM","10","10","10","काहे का मन मा भरोसा राखन लक मानूस नेक बन जासे अखिन परमेस्वर लक सही संबंध भई जासे। अना स्वीकारनो लक हमीला बचायो जावा सेत। मजे आमरो सूटकारा होवा सेत। ");
INSERT INTO pwr_vpl VALUES ("RM10_11","075_10_11","ROM","10","11","11","काहे का गीरंथ असो कव्हासेत का “जोन कोनी बिस्वास करहेत उ कभी नही लजाहेत।” ");
INSERT INTO pwr_vpl VALUES ("RM10_12","075_10_12","ROM","10","12","12","अबा यहूदी अना गैर यहुदीमा काही भेद-भाव नही सेत, एको लाय उ सबको पिरभू सेत। अना आपरो सब नाव लेवन वारा पर दया करासेत। ");
INSERT INTO pwr_vpl VALUES ("RM10_13","075_10_13","ROM","10","13","13","काहेका जोन कोनी पिरभू को नाव लेहेत वो बचायो जाहेत। ");
INSERT INTO pwr_vpl VALUES ("RM10_14","075_10_14","ROM","10","14","14","पर जोन पर उनना भरोसा नही करीसेस वय वोका कसो नाव लेहेत? अना जोन को बारेमा नही आयकिसेस, वोको पर कसो भरोसा ठेहेत? अना मुनादी करन वारा को बिना वय कोन लक आयकेत? ");
INSERT INTO pwr_vpl VALUES ("RM10_15","075_10_15","ROM","10","15","15","अना यदी मुनादी करनवारा ला धाडयो ना जाय, तो कसो सांगेत? जसो का गिरंथ मा लिख्यो सेत, “उनको पाय कितरो खुबसुरत अना साजरो सेत, जोन साजरो बारता आयकावसे?” ");
INSERT INTO pwr_vpl VALUES ("RM10_16","075_10_16","ROM","10","16","16","पर सबना उ साजरो बारता पर कान नही लगायो। भविस्यवक्ता यसायाह कव्हसेत “ओ पिरभू कोन ना आमरो साजरा बारता पर भरोसा ठेविसेस।” ");
INSERT INTO pwr_vpl VALUES ("RM10_17","075_10_17","ROM","10","17","17","एकोलाय भरोसा आयकन लक, अना आयकनो मसीह को बचन लक होवासेत। ");
INSERT INTO pwr_vpl VALUES ("RM10_18","075_10_18","ROM","10","18","18","पर मी कव्हसू, का उनना नही आयकिन? जरूर आइकिसेस; काहेका लिख्यो सेत, “उनको आवाज सारो जगत मा, अना उनको बचन धरती को छोर तकन पहुच गयो सेत।” ");
INSERT INTO pwr_vpl VALUES ("RM10_19","075_10_19","ROM","10","19","19","मी मंग कव्हसू। का इसरायल लोकगीन ला मालूम नही होतो? पयले ता मोसे भविस्यवक्ता कव्हासेत, मी गैर यहुदी लोक लक तुमरो मन मा जलन पैदा करहू। मी एक मुरख देस लक तुमिला गुस्सा दिलवाहू। ");
INSERT INTO pwr_vpl VALUES ("RM10_20","075_10_20","ROM","10","20","20","मंग यसायाह भविस्यवक्ता मोठो दिलेरि को लक कव्हसेत, “जोन मोला नही ढूढत होतीन, उनला मि भेंट गयो। अना जोन मोला पुसत भी नही होतिन उन पर मी परगट भई गयो।” ");
INSERT INTO pwr_vpl VALUES ("RM10_21","075_10_21","ROM","10","21","21","पर इसरायल को बारे मा उ असो कव्हसेत। “मी सारो दिवस आपरो हात हुकूम नही मानन वारा अना झगड़ा करन वारा परजा को कन पसारो रह्यो।” ");
INSERT INTO pwr_vpl VALUES ("RM11_1","075_11_1","ROM","11","1","1","मी पूसा सेऊ, का परमेस्वर ना आपरो लोकहुन ला बिसरा दियो से। नही असो नाहती मि खुदच एक इसरायली अना अबराहम को खानदान को सेऊ, मी, बेंजामिन को कुल को एक मानूस सेऊ। ");
INSERT INTO pwr_vpl VALUES ("RM11_2","075_11_2","ROM","11","2","2","परमेस्वर ना आपरो लोक गिनला नही बिसरो सेत। जोनला वा सूरूवात लक निवाड़ो सेत। तुमी जाना सेव, गिरंथ को वोना जघा मा काजक कव्हसेत, जहा एलियाह इसरायल को खिलाप मा पिराथना करासेत। ");
INSERT INTO pwr_vpl VALUES ("RM11_3","075_11_3","ROM","11","3","3","“हे पिरभु, उनना तोरो भविस्यवक्ता गिनला मार डाख्यो सेत। अना तोरी वेदि हुन ला तोड़ दियों सेत। बस मी च बचयो सेऊ। अना वय मोला मारन को कोसीस मा सेत।” ");
INSERT INTO pwr_vpl VALUES ("RM11_4","075_11_4","ROM","11","4","4","परमेस्वर ना वोला जवाब दियो, “मीना अपरो लाय असो सात हज़ार मरदमाना गिनला राखयो सेऊ, जोनना खोटो बाल देवता को पूजा नहीं करयो सेत।” ");
INSERT INTO pwr_vpl VALUES ("RM11_5","075_11_5","ROM","11","5","5","वसोच हाल यहान भी सेत। परमेस्वर की किरपा लक उन लोक गिनको एक लहान संख्या बचयो सेत। जोनला परमेस्वर निवाड़ो सेत। ");
INSERT INTO pwr_vpl VALUES ("RM11_6","075_11_6","ROM","11","6","6","वोको पसंद किरपा पर अधारित सेत। ना च काम मा, काहेका अगर परमेस्वर को पसंद लोकगिन पर आधारित होतो ता वोको किरपा सहीमा किरपा नही होतो। ");
INSERT INTO pwr_vpl VALUES ("RM11_7","075_11_7","ROM","11","7","7","मंग काजक? इजराइल को लोक गिन ला वा नही भेटयो जोनको उनला तलास होतो। यो बस लहान सो एक समूह होतो। जोनला परमेस्वर ना निवाड़ो, वोच ला भेटयो सेत। बाकि सब परमेस्वर को हाकलनो पर भयरा भयि गयिन ");
INSERT INTO pwr_vpl VALUES ("RM11_8","075_11_8","ROM","11","8","8","जसो गीरंथ कव्हसेत, “परमेस्वर ना उनको मन अना हिरदय ला बेरस बना दियो, यो दिवस मा वय अन्धरा अना भयरा बन गयो सेत।” ");
INSERT INTO pwr_vpl VALUES ("RM11_9","075_11_9","ROM","11","9","9","अना दाऊद कव्हासेत, वय धरयो जाय सकत, अना आपरो जेवन मा फँस सका सेत। वय पड़ सकत, अना उनला सजा दियो जाय सका सेत। ");
INSERT INTO pwr_vpl VALUES ("RM11_10","075_11_10","ROM","11","10","10","उनको डोरा ला अधंरा कर दियो जाय जोन लक वा चोव ना सकेत। अना उनला हरामेसा आपरो आफद को खाल्या नवाय। ");
INSERT INTO pwr_vpl VALUES ("RM11_11","075_11_11","ROM","11","11","11","एकोलाय मी कव्हासेऊ, का उनना एकोलाय खोद्दा खायो का वय पड़के नास भयी जाय? पक्को च नही। बल्कि उनको खोटो करनो लक गैर यहूदी लोक ला सूटकारा भेटयो। जोनलक यहूदिगिन मा जलन पैदा होय। ");
INSERT INTO pwr_vpl VALUES ("RM11_12","075_11_12","ROM","11","12","12","असो परकार अदि उनको गलती करन लक सारो जगत ला मोठयो फायदा सेत। अना अदी उनको गवड़नो लक गैरयहूदी गिनला फायदा सेत। तो उनको पुरो होवनो लगत काही होहेत। ");
INSERT INTO pwr_vpl VALUES ("RM11_13","075_11_13","ROM","11","13","13","अबा मी तुम गैरयहूदी लक मी कव्हासेऊ, तुमी तो यहुदी नाहोती। काहेका मि खास लक गैरयहूदी गिनको लाय पेरीत सेऊ, मी आपरो काम को लाय पूरो मेहनत करा सेऊ। ");
INSERT INTO pwr_vpl VALUES ("RM11_14","075_11_14","ROM","11","14","14","यो आस लक का मी उनको भी भितर मा जलन पैदा करनो चाव्हा सेऊ जोनलक वय भी बचायो जाय मि एकोलाय मेहनत करा सेऊ। ");
INSERT INTO pwr_vpl VALUES ("RM11_15","075_11_15","ROM","11","15","15","काहेका अदी भगवान को लक उनको नकार दियो जानो लक जगत मा परमेस्वर को संग मेल मिलाप पैदा होवासेत। मंग उनको अपनायो जानो का मरयो हुवो लक जिलायो जानो नही होहेत। ");
INSERT INTO pwr_vpl VALUES ("RM11_16","075_11_16","ROM","11","16","16","अदि आमरो भेंट को एक हिस्सा पवितर से ता का वा सबअ पवितर नाहती? अदि झाड़ को जड़ पवितर सेत, ता वोको डगाल भी पवितर सेत। ");
INSERT INTO pwr_vpl VALUES ("RM11_17","075_11_17","ROM","11","17","17","यदि काही डगाली तोडके बेगरो कर दियो गयो सेत। अना तुमी गैरयहुदिगिन! जो बन जैतून सेव उनको जघा मा कलम लगायो गयो से अना जैतून को जड़ अना वोको चिकनाई को भागीदार बने। ");
INSERT INTO pwr_vpl VALUES ("RM11_18","075_11_18","ROM","11","18","18","तुमी आपरो आप ला डगाली लक बड़के नोको समझो। यदि तुमी घमन्ड करनो चाव्हासो, त हेत राखो क तुमी जड़ ला नही पाल रहयो सेव। बल्कि जड़ तुमिला पाल रहयो सेत। ");
INSERT INTO pwr_vpl VALUES ("RM11_19","075_11_19","ROM","11","19","19","तुमी कव्हसेव “डगाली एकोलाय कापके अलग कर दियो गयो का मोला बान्धो जाय।” ");
INSERT INTO pwr_vpl VALUES ("RM11_20","075_11_20","ROM","11","20","20","बेस से, वय तो अबिस्वासी को कारन कापके अलग कर दियो गयो, अना तुमरो भरोसा बल मा आपरो जघा पर बनो हुयो सेव। एकोलाय गरब नोको करो, वरन भेव मानो। ");
INSERT INTO pwr_vpl VALUES ("RM11_21","075_11_21","ROM","11","21","21","यदि परमेस्वर असल डगाली पर रहम नही करयो, तो उ तुम पर भी रहम नही करेत। ");
INSERT INTO pwr_vpl VALUES ("RM11_22","075_11_22","ROM","11","22","22","एकोलाय परमेस्वर को दयालुपन अना कठोरपन दुई गोस्टी पर बिचार करो। पापी लोग काजी उ कठोर सेत, अना तुमरो लाय परमेस्वर को दयालुपन सेत, पर सरत यो से, का तुमी वोकी दयालुपन को लायक बनो रव्हो। नही तो तुमला भी कापके अलग कर दियो जाहेति। ");
INSERT INTO pwr_vpl VALUES ("RM11_23","075_11_23","ROM","11","23","23","दुसरो कन यदि वय अबिस्वासी बनो नही रहेत, तो वय भि साटो जाहेत। काहेका परमेस्वर उनला दुबारा लगानो को ताकत राखा सेत। ");
INSERT INTO pwr_vpl VALUES ("RM11_24","075_11_24","ROM","11","24","24","यदि तुमी आपरो गुन लक बन जैतून को डगाली सेव, अना वोला कापके आपरो गून को बिरोध मा असली जैतून मा कलम लगायो गयो सेव। तो वय कहि ज्यादा सरल लक आपरो आचरन को लक, आपरो निज जैतून मा कलम लगायो जा सकेत। ");
INSERT INTO pwr_vpl VALUES ("RM11_25","075_11_25","ROM","11","25","25","अगो मोरो संगीहुन! यो एक छिपयो सच्चो गोस्टी सेत। जोन तुम्हिला सांगा सेऊ। यो गोस्टी तुम्हिला चेताहेत का तुमी कितरो अक्कलवर सेव? इसरायिल को लोकहुन को यो हरामेसा को जिद्द नाहती। मंग यो तबा तकन चलयेत, जबा तकन पूरो गैरयहूदी परमेस्वर को जवर ना आय जाय। ");
INSERT INTO pwr_vpl VALUES ("RM11_26","075_11_26","ROM","11","26","26","अना असो रिति लक सारो इसरायल ला बचायो जाहेत। जसो गीरंथ मा लिख्यो सेत बचावन वारा सिय्योन लक आहेत, अना सबा नीचपन ला याकूब लक दुर करयेत। ");
INSERT INTO pwr_vpl VALUES ("RM11_27","075_11_27","ROM","11","27","27","तबा मी उनको पाप गिनला हिसक लेहू अना उनको संग यो करार करहीन। ");
INSERT INTO pwr_vpl VALUES ("RM11_28","075_11_28","ROM","11","28","28","साजरो बारता को हिसाब लक तो तुमारो लाय वय परमेस्वर को बैरी सेत, पर निवाड़ो होवन को कारन, वय बाप दादा को जमाना लक चहेतो सेत। ");
INSERT INTO pwr_vpl VALUES ("RM11_29","075_11_29","ROM","11","29","29","परमेस्वर आपरो मनला नही बदला सेत। जोनला वा निवाड़ो सेत वोला वा आसीरबाद भी देवा सेत। ");
INSERT INTO pwr_vpl VALUES ("RM11_30","075_11_30","ROM","11","30","30","जसो तुमीना जूनो जमाना मा परमेस्वर को हुकूम ला नही मानयो सेव, वसोच, यहूदी गिन भी हुकूम नहि मानयो सेत। पर अबा तुम्हिला परमेस्वर को दया भेटयो सेत। ");
INSERT INTO pwr_vpl VALUES ("RM11_31","075_11_31","ROM","11","31","31","वसोच यहुदीगिन भी परमेस्वर को हुकूम ला नही माना सेत, जोन लक तुमरो जसो उनला भी परमेस्वर को दया भेटेत। ");
INSERT INTO pwr_vpl VALUES ("RM11_32","075_11_32","ROM","11","32","32","काहेका परमेस्वर ना सबला हुकूम नही मानन को लाय, बन्दी बनाके राखिसेस जेनको लक उ सब पर रहम करे। ");
INSERT INTO pwr_vpl VALUES ("RM11_33","075_11_33","ROM","11","33","33","आहा! परमेस्वर को धन अना अक्ल अना गियान कितरो गंभीर सेत! वोको बिचार कसो अथाह अना वोको रस्ता ला कोनी नही जान सकासेस। ");
INSERT INTO pwr_vpl VALUES ("RM11_34","075_11_34","ROM","11","34","34","“पिरभू को अक्ल ला कोन जानयो सेत? या वोको सला देवन वालो कोन सेत? ");
INSERT INTO pwr_vpl VALUES ("RM11_35","075_11_35","ROM","11","35","35","या कोन ना पयले वोला काही दियो से, जोनको बदला वोला दियो जाय?” ");
INSERT INTO pwr_vpl VALUES ("RM11_36","075_11_36","ROM","11","36","36","काहे का वोच को कन लक, अना वोच को लक अना वोच को लाय सब काही सेत। वोको महिमा सदा तकन होवत रवहे आमेन। ");
INSERT INTO pwr_vpl VALUES ("RM12_1","075_12_1","ROM","12","1","1","अगो मोरो संगीहुन! परमेस्वर को दया ला हेत कराके मी तुम्हि लक बिनती करा सेऊ। का अपरो आप ला परमेस्वर को लाय जित्तो बली को रूपमा परमेस्वर को सेवा अना वोला खुस करन लाय दे देव। योच सच्चो पूजासेत। असो पूजा तुमीला करनो सेत। ");
INSERT INTO pwr_vpl VALUES ("RM12_2","075_12_2","ROM","12","2","2","तुम्हि आपरो आप ला दुनिया को माफीक नोको बनाओ लेकिन परमेस्वर ला अपरो मन ला बदलन को पूरो मौका देव। तबा तुमला परमेस्वर को इक्सा को बारेमा पता चल जाहेत। जोन साजरा सेत अना वोला साजरो लगासेत। अना सिध्द भी सेत। ");
INSERT INTO pwr_vpl VALUES ("RM12_3","075_12_3","ROM","12","3","3","अना मी परमेस्वर को किरपा को वजा लक हरेक ला कव्हसेऊ। अपरो आप ला जरुरत लक जादा हुसियार नोको समजो। आपरो बिचार मा सयंम बरतो। अना परमेस्वर ना तुम्हिला जोन बिस्वास देयि सेत, वोको अनुसार खुद को बरोबरी करो। ");
INSERT INTO pwr_vpl VALUES ("RM12_4","075_12_4","ROM","12","4","4","आमरो देह को लगत हिस्सा सेत। अना सबको अलग-अलग काम सेत। ");
INSERT INTO pwr_vpl VALUES ("RM12_5","075_12_5","ROM","12","5","5","वसोच अमी भी लगत सेजन। मंग मसीह मा एक देह सेजन। अना देह को आंग होवन को कारन एक दुसरो लक जुड़यो सेजन। ");
INSERT INTO pwr_vpl VALUES ("RM12_6","075_12_6","ROM","12","6","6","एकोलाय अमी आपरो अलग-अलग बरदान ला वोना किरपा को अनुसार, बवजा सेजन, जोन परमेस्वर न अमिला दियो सेत। अदि आमरो बरदान परमेस्वर को सन्देस सांगनो सेत, ता अमिला एला वोना बिस्वास को संग करनो पायजे जो आमरो जवर सेत। ");
INSERT INTO pwr_vpl VALUES ("RM12_7","075_12_7","ROM","12","7","7","अदी सेवा करन को बरदान सेत, ता अमीला सेवा करनो पाहिजे। अगर अमिला सिकावन को बरदान भेटयो सेत, ता अमिला सिकावनो पाहिजे। ");
INSERT INTO pwr_vpl VALUES ("RM12_8","075_12_8","ROM","12","8","8","अदि यो दुसरो को जोस भरन को वरदान सेत, ता वोला वोच करनो पायजे। जोन कोनी दूसरों को संग साझा करनो को सेत ता दया लक करनो पायिजे। जोनको जवर अधिकार सेत। वोला कड़ी मेहनत करनो पायजे। जोन कोनि दूसरों पर दया करा सेत। वोला खुसी-खुसी करनो पायिजे। ");
INSERT INTO pwr_vpl VALUES ("RM12_9","075_12_9","ROM","12","9","9","पिरेम पूरो ईमानदारी लक होवनो पाहिजे। बुराई लक बेगरो भयी जाव, जोन साजरो सेत वोला धरो। ");
INSERT INTO pwr_vpl VALUES ("RM12_10","075_12_10","ROM","12","10","10","भाऊ-भाऊ मा जसो पिरेम होवासे वसोच एक दूसरो लक पिरेम राखो, आपसी मा एक दूसरो को आदर करो। अना एक दूसरो लक बढ चढ़के करो। ");
INSERT INTO pwr_vpl VALUES ("RM12_11","075_12_11","ROM","12","11","11","कोसीस करनो मा अलाली नोको करो, पवीतर आतमा मा को जोस मा भरयो रव्हो, पिरभू को सेवा करतो रव्हो। ");
INSERT INTO pwr_vpl VALUES ("RM12_12","075_12_12","ROM","12","12","12","आपरो आस मा खुसहाली करो, दूख मा पक्को रव्हो, पिराथना मा हमेसा लगे रहयो। ");
INSERT INTO pwr_vpl VALUES ("RM12_13","075_12_13","ROM","12","13","13","पवीतर लोकगीन ला काही चीज को जरुरत हो उनला हिस्सादार बनावो, पोहनाई करनो मा लग्यो रव्हो। ");
INSERT INTO pwr_vpl VALUES ("RM12_14","075_12_14","ROM","12","14","14","आपरो सतावन वालो ला आसीस देव, उनला सराप नोको देव। ");
INSERT INTO pwr_vpl VALUES ("RM12_15","075_12_15","ROM","12","15","15","खुसहाली करन वारा को संग खुसहाली करो रडन वारा को सगं रडो। ");
INSERT INTO pwr_vpl VALUES ("RM12_16","075_12_16","ROM","12","16","16","आपसी मा एक मन राखो घमन्ड नोको करो, पर गरीब लोक गीन को संगती करो। अना आपरो नजर मा बिचार के अक्लवर नोको बनो। ");
INSERT INTO pwr_vpl VALUES ("RM12_17","075_12_17","ROM","12","17","17","बुराई को बदला मा कोनी को बुराई नोको करो। ");
INSERT INTO pwr_vpl VALUES ("RM12_18","075_12_18","ROM","12","18","18","जहान तकन हो सका सेत, तुमी जी भरके सब मानूसगिन को संग साजरो मेल-मिलाप राखो। ");
INSERT INTO pwr_vpl VALUES ("RM12_19","075_12_19","ROM","12","19","19","ओ मोरो चहेतो लोकगीन आपरो पलटा नोको लेव पर परमेस्वर को गुस्सा ला मौका देव, कहेका लिख्यो से पलटा लेवनो मोरो काम सेत, पिरभू कव्हसेत मि च बदला लेहू। ");
INSERT INTO pwr_vpl VALUES ("RM12_20","075_12_20","ROM","12","20","20","पर यदि तोरो बैरी भुको सेत, तो वोला जेवन देव; यदि तहान से तो वोला पानी पिलाव, काहेका असो करनो लक तू वोको डोस्का मा स्तो को इंगरा को ढेर लगाजोस। ");
INSERT INTO pwr_vpl VALUES ("RM12_21","075_12_21","ROM","12","21","21","बुराई लक नोको हारो, पर बुराई ला भला लक जीत लेव। ");
INSERT INTO pwr_vpl VALUES ("RM13_1","075_13_1","ROM","13","1","1","सबअ राज को अधिकारी गिनको पालन करनो पाहिजे। काहेका कोनी भी अधिकार परमेस्वर को हुकूम को बिना मौजुद नाहती। अना मौजुद अधिकारी गिन परमेस्वर लक राख्यो गयो सेत। ");
INSERT INTO pwr_vpl VALUES ("RM13_2","075_13_2","ROM","13","2","2","जोन मौजूद अधिकारी गिनको बिरोध करा सेत वा परमेस्वर को हुकूम को बिरोध करा सेत, अना जोन कोनी असो करा सेत उ आपरो पर नियाव आना सेत। ");
INSERT INTO pwr_vpl VALUES ("RM13_3","075_13_3","ROM","13","3","3","राजा अना सासकगिन उन लोक हुनला नही डरावा सेत, जोन साजरा काम करा सेत, पर वय वोला च डरावा सेत, जोन बुराई करा सेत। अदी तुमी सासन लक नही डरनो चाव्हा सेव, तो भलो काम करो, तुमरो बड़ाई होहेत। ");
INSERT INTO pwr_vpl VALUES ("RM13_4","075_13_4","ROM","13","4","4","काहेका वय परमेस्वर को सेवक सेत। जोन तुम्हारो भलो को लाय काम कर रहयो सेत। परा अगर तुम्ही बुराई करतत ता उन लक डरो, काहेका दंड देवन को ताकत उनला भेटयो सेत। अना बुराई करन वालों ला सजा देवा सेत। ");
INSERT INTO pwr_vpl VALUES ("RM13_5","075_13_5","ROM","13","5","5","यो कारन लक तुमला अधिकारी गिनको पालन करनो पाहिजे। ना च परमेस्वर की सजा को कारन, बल्कि डिमाक लक भी। ");
INSERT INTO pwr_vpl VALUES ("RM13_6","075_13_6","ROM","13","6","6","यो च कारन सेत, का तुम्ही जमा पटावा सेव। काहेका हरेक अधिकारी परमेस्वर को काम करा सेत। अना आपरो करतब ला पूरो करा सेत। ");
INSERT INTO pwr_vpl VALUES ("RM13_7","075_13_7","ROM","13","7","7","एकोलाय हरेक को हक देव, जोनला जमा पटानो से, उनको जमा पटाओ, जोको लक डरानो जरुरी से, वोको लक डराव, जोनको आदर करनो से, वोको आदर करो। ");
INSERT INTO pwr_vpl VALUES ("RM13_8","075_13_8","ROM","13","8","8","आपसी मा पिरेम ला छोड़ अना काही बात को करजा नोको चाहो। काहेका जोन दुसरो लक माया राखासे उ नियम धरम ला पूरो कर सेस। ");
INSERT INTO pwr_vpl VALUES ("RM13_9","075_13_9","ROM","13","9","9","यो का छिनालापन नोको करो, कोनिला जान लक नोको मारो, चोरी नोको करो, लोभ नोको करो, इनला छोड़ अना कोनी हुकूम सेस तो यो सब बातको निचोड़ यो हुकूम मा सेत। का आपरो सेजारी लक आपरो समान माया राख। ");
INSERT INTO pwr_vpl VALUES ("RM13_10","075_13_10","ROM","13","10","10","माया आपरो सेजारी को काही बुराई नही करा से, एकोलाय माया राखनो नियम ला पूरो करनो से। ");
INSERT INTO pwr_vpl VALUES ("RM13_11","075_13_11","ROM","13","11","11","बेरा ला चिन्हके असोच करो, एकोलाय का अबा तुमारो लाय जप लक जगन को बेरा आय गयो सेत। काहेका जोन बेरा अमीना भरोसा राख्यो होतो, वोना बेरा को बिचार लक सूटकारा कठा होति। ");
INSERT INTO pwr_vpl VALUES ("RM13_12","075_13_12","ROM","13","12","12","अबा रात बित गयी सेत, दिवस हिटनवारा सेस एकोलाय आमी इन्धार को काम ला छोड़-छोड़के उजाड को हतियार घालो। ");
INSERT INTO pwr_vpl VALUES ("RM13_13","075_13_13","ROM","13","13","13","आमी दिवस को लक खरो चाल-चलबिन। आमी रगिलोपन नसा पानी गन्दोकाम, अना छिनालापन जलन अना देह को वासना झगड़ा-रगडा लक दुहुर रव्हबिन। ");
INSERT INTO pwr_vpl VALUES ("RM13_14","075_13_14","ROM","13","14","14","तुमी पिरभू यीसु मसीह ला घालो अना देह को इक्सा पूरो करन को कोसिस नोको करो। ");
INSERT INTO pwr_vpl VALUES ("RM14_1","075_14_1","ROM","14","1","1","जोन भरोसा मा निरबल सेत वोला आपरो संगती मा ले लेव, पर वोको सक पर विवाद नोको करो। ");
INSERT INTO pwr_vpl VALUES ("RM14_2","075_14_2","ROM","14","2","2","एक को भरोसा से का वा सब जेवन कर सका सेत, पर दुसरो मा भरोसा कमजोर सेत। उ बस हिवरो साग-भाजी च जेव सेत। ");
INSERT INTO pwr_vpl VALUES ("RM14_3","075_14_3","ROM","14","3","3","साकाहारी मांस खावनो गलत सेत, असो तय नोको करे। काहेका साकाहारी-माँसाहारी दूई ला परमेस्वर अपनाइसेस। ");
INSERT INTO pwr_vpl VALUES ("RM14_4","075_14_4","ROM","14","4","4","तू कोन सेत जोन दूसरो दास पर दोस लगावासेत? वोको उभो रव्हनो, अना पड़ जावनो, वोको पिरभू तय करा सेत बल्की मी यो कव्हसू का वोला उभो कर दीयो जाहेत, काहेका परमेस्वर च वोला उभो रखा सका सेत। ");
INSERT INTO pwr_vpl VALUES ("RM14_5","075_14_5","ROM","14","5","5","कोनी तो एक दिवस ला, दूसरो दिवस लक ज्यादा साजरो समजासे। अना कोनी सबच दिवस ला एक जसो माना सेत, हर एक मानूस यो आपरो मन मा तय करलेवे। ");
INSERT INTO pwr_vpl VALUES ("RM14_6","075_14_6","ROM","14","6","6","आपरो बिचार लक जोन कोनी दिवस ला माना सेत, उ परमेस्वर को लाय माना सेत। जो जेव सेत, उ पिरभू लाय जेवा सेत। अना जोन नही जेव सेत उ परमेस्वर को लाय नही जेव सेत। अना परमेस्वर को धनवाद करासे। ");
INSERT INTO pwr_vpl VALUES ("RM14_7","075_14_7","ROM","14","7","7","काहेका आमरो लक कोनी, अपरो लाय नही जित्तो रव्हअ सेत, अना कोनी अपरो लाय मरअ सेत। ");
INSERT INTO pwr_vpl VALUES ("RM14_8","075_14_8","ROM","14","8","8","यदि आमी जित्तो होवन लाय जित्तो सेजन, अना आमी मर जावअ सेत, तो पिरभू लाय मर जावअ सेत। मंग अबा जित्तो रहबीन, या मर जाबीन सब पीरभू को लाय सेत। ");
INSERT INTO pwr_vpl VALUES ("RM14_9","075_14_9","ROM","14","9","9","काहेका यीसु मसीह यो काजी मरयो अना जित्तो भई गयो, काहेका उ मरो हुवो अना जितो दुई को पिरभू बन जाये। ");
INSERT INTO pwr_vpl VALUES ("RM14_10","075_14_10","ROM","14","10","10","तू आपरो भाऊ पर काहे दोस लगावअ सेत या तू काहे आपरो भाऊ ना नीच समजा सेत? जबा आमी सबच ला परमेस्वर को नियाव आसन को पूढा उभो होवनो सेत। ");
INSERT INTO pwr_vpl VALUES ("RM14_11","075_14_11","ROM","14","11","11","काहेका लिख्यो सेत पिरभू कव्हासेत, “का मोरो जिंदगी को कसम, हरेक टोघरा मोरो पुड़ा टीकेत अना हर एक जुबान परमेस्वर ला हाकलेत।” ");
INSERT INTO pwr_vpl VALUES ("RM14_12","075_14_12","ROM","14","12","12","एकोलाय अमी लक हरेक परमेस्वर ला आपरो लेखा देवनो सेत। ");
INSERT INTO pwr_vpl VALUES ("RM14_13","075_14_13","ROM","14","13","13","एकोलाय आमी एक मेक ला दोस लगावनो सोड़के ना आपसी मा तय करलेव। का कोनी आपरो भाऊ को रस्ता मा खोद्दा को कारन नोको पैदा करे अना जाल बिछायेति। ");
INSERT INTO pwr_vpl VALUES ("RM14_14","075_14_14","ROM","14","14","14","मी जाना सेऊ अना पिरभू यीसु मसीह को चेला होवन को नाता लक, मोरो भरोसा सेत। का कोनी चिज असुध्द सेत, पर कोनी यो सोचा सेत, का फलानो चीज सुध सेत। तो उ वोको लाय सुध भई जावअ सेत। ");
INSERT INTO pwr_vpl VALUES ("RM14_15","075_14_15","ROM","14","15","15","यदि तुमी आपरो जेवन को कारन लक आपरो भाऊ गिनला दुख देवा सो, तो तुमी माया को मारग पर नही चलअ सो। जोन मानूस काजी यीसु मसीह मर गयो, तुमी आपरो जेवन को कारन वोको नास को कारन नोको बनो। ");
INSERT INTO pwr_vpl VALUES ("RM14_16","075_14_16","ROM","14","16","16","एकोलाय वोको नजर मा जोन साजरो सेत, उ निन्दा को कारन नोको बने। ");
INSERT INTO pwr_vpl VALUES ("RM14_17","075_14_17","ROM","14","17","17","काहेका परमेस्वर को राज खावन-पिवन लाय नही, पर उ न्याय सान्ती अना खुसि को बारे मा सेत। जो पवीतर आतमा लक भेटा सेत। ");
INSERT INTO pwr_vpl VALUES ("RM14_18","075_14_18","ROM","14","18","18","जोन एना गोस्टी लक यीसु मसीह को सेवा करा सेत, परमेस्वर उ को चहेतो अना मानूस गीन मा सतकार को काबील ठयरा सेत। ");
INSERT INTO pwr_vpl VALUES ("RM14_19","075_14_19","ROM","14","19","19","आमी असो गोस्टी मा लगो रहबिन, जोन लक सान्ती बनावन मा बढावा मिले। ");
INSERT INTO pwr_vpl VALUES ("RM14_20","075_14_20","ROM","14","20","20","यो सच से का सब काही आपरो मा सुध्द सेत, पर जेवन लक दुसरो ला परमेस्वर को कठा आवनो मा रस्ता मा खोद्दा को कारन पैदा करनो बुरो सेत। ");
INSERT INTO pwr_vpl VALUES ("RM14_21","075_14_21","ROM","14","21","21","साजरो तो यो सेत, का मांस अना दारू ला नोको खाय पिये, अना कोनी असो काम नोको करो, जोन को लक कोनी भाऊ अना बहिन खोद्दा खाय, अना आपरो रस्ता लक भटक जाय। ");
INSERT INTO pwr_vpl VALUES ("RM14_22","075_14_22","ROM","14","22","22","तोरो जो भरोसा सेत, वोला तुमी परमेस्वर को पूढा आपरो तय कियो बिचार, आपरो च कठा ठेवो, धन्य से उ जोनको मन वोला दोसी नही ठहरावा सेत, जबा उ आपरो मनला परख के चलअ सेत। ");
INSERT INTO pwr_vpl VALUES ("RM14_23","075_14_23","ROM","14","23","23","काहेका जोन जेवन को बारे मा संका करा सेत, अना तबा भी जेव सेत, तो उ दन्ड को भागी सेत। काहेका उ यो काम भरोसा को लक नही करतत। अना जोन काम भरोसा को लक नही सेत उ पाप सेत। ");
INSERT INTO pwr_vpl VALUES ("RM15_1","075_15_1","ROM","15","1","1","अमी जोन आतमिक रूपमा ताकतवर सेत। उनला कमजोर लोक गिनको सहनो पाहिजे। अमी बस आपरो आपला खुस नोको करो। ");
INSERT INTO pwr_vpl VALUES ("RM15_2","075_15_2","ROM","15","2","2","आमरो मा लक हरेक, एकमेक को साजरोपन, को बढ़ोतरी को लाय उनको भावना को संग आतमा मा जोस लक भरो। ");
INSERT INTO pwr_vpl VALUES ("RM15_3","075_15_3","ROM","15","3","3","यहाँन तकन का मसीह ना भी खुद ला खुस नही कियो होतो। बल्कि जसो मसीह को बारेमा गीरंथ कव्हअ सेत “उनको बेइज्जती जोनना तोरो बेइज्जती कियो सेत। मोरो पर आय गयो सेत।” ");
INSERT INTO pwr_vpl VALUES ("RM15_4","075_15_4","ROM","15","4","4","हरेक वा गोस्टी जोन गिरंथ मा पयले लक लिख्यो गयो सेत, अमिला सिक्सा देवन साठी सेत। जोन लक धीरज अना बढ़ावा गिरंथ लक मिलतो रहेत। जोन लक अमिला आस भटेत। ");
INSERT INTO pwr_vpl VALUES ("RM15_5","075_15_5","ROM","15","5","5","परमेस्वर च धिरज अना सान्ती को देवन वालो से। उ तुमी लोक गीनला असो बरदान देहे, का तुमी यीसु मसीह को सिक्सा को लक आपसी मा मेल-मिलाप को बिचार मा बढ़ावा बनाये राखो। ");
INSERT INTO pwr_vpl VALUES ("RM15_6","075_15_6","ROM","15","6","6","जेनको लक सबा मिलके एकच आवाज मा आमरो पिरभू यीसु मसीह को परमेस्वर दआजि को बड़ाई करत रव्हबिन। ");
INSERT INTO pwr_vpl VALUES ("RM15_7","075_15_7","ROM","15","7","7","जसो यीसु मसीह ना अमीला आपरो परमेस्वर को महिमा काजी अपनाई सेत, वसोच तुमी एक मेक ला भाऊ चारा लक अपनाने ");
INSERT INTO pwr_vpl VALUES ("RM15_8","075_15_8","ROM","15","8","8","मि यो कव्हनो चव्हासू का यीसु मसीह खतना वालो लोक गीनको दास एकोलाय बनयो, का उ बाप दादा लक कियो गयो परन पूरो कर सकेत। अना यो पुरुप कर दे, का परमेस्वर सच्चो वादा करा सेत। ");
INSERT INTO pwr_vpl VALUES ("RM15_9","075_15_9","ROM","15","9","9","अना एकोलाय भी का गैरयहूदी गिनला परमेस्वर को दया भेटे, अना वय स्तुती करे। जसो गिरंथ मा लिख्यो सेत, “एकोलाय गैर यहूदि गिनको बीचमा तोला ओरखा हिन अना तोरो नाव को महिमा गावइन।” ");
INSERT INTO pwr_vpl VALUES ("RM15_10","075_15_10","ROM","15","10","10","अना असो भी लिखयो सेत, अरे! गैर यहूदि हुन परमेस्वर को परजा संगा खुसि मनाओ। ");
INSERT INTO pwr_vpl VALUES ("RM15_11","075_15_11","ROM","15","11","11","मंग असो भी “ओ सब गैरयहुदि लोकगीन पिरभू को स्तुति करो, अना सप्पा देस को लोकगीन वोको बडाई करयेत।” ");
INSERT INTO pwr_vpl VALUES ("RM15_12","075_15_12","ROM","15","12","12","मंग भविस्यवक्ता यसायाह कव्हसेत “यिसै को बंस को मानूस चोहेत, उ गैरयहुदी गिनमा सासन करन आहेत। अना वय वोको मा आरो आस ठेयेत।” ");
INSERT INTO pwr_vpl VALUES ("RM15_13","075_15_13","ROM","15","13","13","अबा आस को परमेस्वर, तुमला भरोसा करन मा पूरो खुसि अना सान्ती लक भरदे। जेनको लक पवीतर आतमा को ताकत लक तुमरो आसा बढत जाय। ");
INSERT INTO pwr_vpl VALUES ("RM15_14","075_15_14","ROM","15","14","14","ओ मोरो संगीहुन! जहान तकन तुमरो बारेमा मी खुदच बेखटका सेव, अना भरोसा सेत, का तुम खुद च साजरा अना सप्पा गियान लक भरो हुयो सेव। अना तुमी ला एतरो मालुम सेत, का एक मेक ला समजा सको। ");
INSERT INTO pwr_vpl VALUES ("RM15_15","075_15_15","ROM","15","15","15","तोभी मि ना काही-काही हेत दिलावन काजी तुमीला लगत हिम्मत जुटाय के लिखी सेउ। यो वोना किरपा को कारन भयो, जोना परमेस्वर ना मोला दियो सेत। ");
INSERT INTO pwr_vpl VALUES ("RM15_16","075_15_16","ROM","15","16","16","का मी गैरयहुदी गिनको लाय यीसु मसीह को दास बनू, अना परमेस्वर को साजरो बारता को सेवा याजक को जसो करू, का गैरयहुदी रुपी मोरि भेंट पवीतर आतमा लक पवीतर होयके चढ़ायो जाय। ");
INSERT INTO pwr_vpl VALUES ("RM15_17","075_15_17","ROM","15","17","17","एको लाय मोला यीसु मसीह मा, वोना गोस्टी को बारेमा, जोन परमेस्वर को बारे मा से। बडाई करन को कारन भेटयो से। ");
INSERT INTO pwr_vpl VALUES ("RM15_18","075_15_18","ROM","15","18","18","उन गोस्टी ला छोड़, मी कोनी दुसरो गोस्टी करन को हिम्मत नही करू, जोन यीसु मसीह मा गैरयहुदी गिनला, परमेस्वर को हुकूम मानन को रस्ता दिसान को काम मोरो बचन, करम, ");
INSERT INTO pwr_vpl VALUES ("RM15_19","075_15_19","ROM","15","19","19","अना निसान अखीन अचँभा काम को ताकत लक, अना पवीतर आतमा को ताकत लक, मोरो हात लक भई सेत। यहान लक का मि ना येरुसलेम लक, इतानी उतानी सब जघा इल्लुरिकुम तकन यीसु मसीह को साजरो बारता ला पूरो-पूरो सांगिसेऊ। ");
INSERT INTO pwr_vpl VALUES ("RM15_20","075_15_20","ROM","15","20","20","पर मोरो मनमा यो उमंग सेत। का जहान-जहान यीसु मसीह को नाव नही लियो गयो से, वहान साजरो बारता आयकाव, असो न हो का दुसरो को रद्दा मा घर बनाऊ। ");
INSERT INTO pwr_vpl VALUES ("RM15_21","075_15_21","ROM","15","21","21","पर जसो लिखिसे वसोच हो “जोन को जवर वोको साजरा बारता नही पहुचिसेस, वय चोहेत। अना जोन ना नही आयकिसेस, वो च समजेत।” ");
INSERT INTO pwr_vpl VALUES ("RM15_22","075_15_22","ROM","15","22","22","एकोलाय मी बार-बार तुमी लोक गीनको कठा आवनो लक रुकयो रव्हयो सेऊ। ");
INSERT INTO pwr_vpl VALUES ("RM15_23","075_15_23","ROM","15","23","23","परअ अबा ऐना देस मा मोरो काम को लाय जघा नाहती। अना लगत साल लक तुमरो कठा आवन को मनसा सेत। ");
INSERT INTO pwr_vpl VALUES ("RM15_24","075_15_24","ROM","15","24","24","एकोलाय जबा मी स्पेन ला जाहु तो तुमरो कठा लक जाहु, काहेका मोला वोना यातरा मा मुलाकात होयहेत असो आस सेत। अना जबा तुमरो संगति लक मन भर जाए तबा मोला काही दुहुर पूढा धाड़ जोस। ");
INSERT INTO pwr_vpl VALUES ("RM15_25","075_15_25","ROM","15","25","25","परअ अभिसिन मी, पवीतर लोकगीन को सेवा करन को लाय येरुसलेम नगर जावासू। ");
INSERT INTO pwr_vpl VALUES ("RM15_26","075_15_26","ROM","15","26","26","काहेका मकीदुनिया अना अखया को संगती करनवारा लोक गीनला, यो साजरा लगिसेस, का येरुसलेम को पवीतर लोकगीन मा गरिब लोक गिनको लाय काही चन्दा करे। ");
INSERT INTO pwr_vpl VALUES ("RM15_27","075_15_27","ROM","15","27","27","उनला साजरा तो लग्यो, परअ वय उनको करजदार भी सेत, काहेका गैर यहुदी उनको आतमिक बात मा हिस्सादार बनिन, तो उनको यो फरज सेत। का देह को बारेमा उनको सेवा करे। ");
INSERT INTO pwr_vpl VALUES ("RM15_28","075_15_28","ROM","15","28","28","एकोलाय मि यो काम पूरो करके, अना उनला यो चन्दा सुरक्सित सोपके, तुमारो जवर लक स्पेन जाबिन। ");
INSERT INTO pwr_vpl VALUES ("RM15_29","075_15_29","ROM","15","29","29","मोला भरोसा से का, जबा मी तुमरो जवर आसिन तो यीसु मसीह को आसिरवाद आनीन। ");
INSERT INTO pwr_vpl VALUES ("RM15_30","075_15_30","ROM","15","30","30","अबा ओ संगीहुन! आमरो पिरभू यीसु मसीह अना पवीतर आतमा को माया लक, मि तुमी लक बिनती करासू, का मोरो लाय परमेस्वर लक पिराथना करनो मा मोरो संग लग्यो रव्हो। ");
INSERT INTO pwr_vpl VALUES ("RM15_31","075_15_31","ROM","15","31","31","जेनको लक मी यहुदिया को भरोसा नही ठेवनवारा लोकगीन लक बचयो रव्हू। अना मोरो येरुसलेम को सेवा पवीतर लोक मा मानता होहे। ");
INSERT INTO pwr_vpl VALUES ("RM15_32","075_15_32","ROM","15","32","32","जोनलक परमेस्वर को इक्सा को अनुसार मी खुसी-खुसी तुमरो जवर आयके तुमरो संग खुसी मनाऊ। ");
INSERT INTO pwr_vpl VALUES ("RM15_33","075_15_33","ROM","15","33","33","पूरो सांती को धाम परमेस्वर तुमरो संग रव्हे। आमीन। ");
INSERT INTO pwr_vpl VALUES ("RM16_1","075_16_1","ROM","16","1","1","मी किंखेया नगर को कलीसिया की खास सेविका आमरो बहिन फिबे को लाय तुमी लोकगीन लक सिपारिस करके कव्हसू। ");
INSERT INTO pwr_vpl VALUES ("RM16_2","075_16_2","ROM","16","2","2","का तुमी पिरभू मा वोला असो रित लक अपनाने जसो परमेस्वर को लोक गिनको लायक सेत। वोला तुमरो लक जसो मदद पाहिजे तसोच वोकी मदद करो। काहेका वा मोरो समेत लगत लोक गिनको मदद करियो सेत। ");
INSERT INTO pwr_vpl VALUES ("RM16_3","075_16_3","ROM","16","3","3","प्रिस्किल्ला अना अक्किला ला जोन यीसु मसीह मा मोरो संग काम करनवारा सेत। उनला मोरो नमस्कार। ");
INSERT INTO pwr_vpl VALUES ("RM16_4","075_16_4","ROM","16","4","4","उनना मोरो जान को लाय आपरो जीवन ला जोखिम मा डाख दियो होतिन, अना केवल मी च नही पर गैरयहुदी गिनको सारो कलीसिया भी उनको धनवाद करासेत। ");
INSERT INTO pwr_vpl VALUES ("RM16_5","075_16_5","ROM","16","5","5","उनको घरमा जोन कलीसिया से, वोला भी नमस्कार मोरो चहेतो इपैनितुस ला, जो मसीह को लाय आसिया मा पयलो फर सेत, नमस्कार ");
INSERT INTO pwr_vpl VALUES ("RM16_6","075_16_6","ROM","16","6","6","मरियम ला, जोन ना तुमारो लाय गजब महेनत करीसेस, वोला नमस्कार। ");
INSERT INTO pwr_vpl VALUES ("RM16_7","075_16_7","ROM","16","7","7","अन्द्रुनीकुस अना युनियास जोन मोरो रिस्तेदार सेत, अना मोरो सग कैद भई होतिन, अर वय पेरीत गीन मा नामी गामी सेत। अना मोरो लक पयले मसीह मा सेती, नमस्कार। ");
INSERT INTO pwr_vpl VALUES ("RM16_8","075_16_8","ROM","16","8","8","अम्पलियातुस ला, जोन पिरभू मा मोरो चहेतो से नमस्कार। ");
INSERT INTO pwr_vpl VALUES ("RM16_9","075_16_9","ROM","16","9","9","उरबानुस ला जेना मसीह मा आमरो संग काम करनवारा सेत, अना ओ मोरो चहेतो इस्तखुस को नमस्कार। ");
INSERT INTO pwr_vpl VALUES ("RM16_10","075_16_10","ROM","16","10","10","अपिल्लेस ला जो मसीह मा सच्चो अना काबील से, वोला नमस्कार। अरिस्तुबुलुस को घराना ला नमस्कार ");
INSERT INTO pwr_vpl VALUES ("RM16_11","075_16_11","ROM","16","11","11","मोरो रिस्तेदार हेरोदियोन ला नमस्कार। नरकिस्सुस को घराना को जेन लोक पिरभू मा सेत, उनला नमस्कार। ");
INSERT INTO pwr_vpl VALUES ("RM16_12","075_16_12","ROM","16","12","12","तुरूफेना अना तुरूफोसा ला जेन पिरभू मा महेनत करसेति वा ला नमस्कार। मोरो चहेतो पिरसिस ला जेन ना पिरभू मा गजब मेहनत करीसेस नमस्कार। ");
INSERT INTO pwr_vpl VALUES ("RM16_13","075_16_13","ROM","16","13","13","रुफुस ला जोन पिरभू मा बेचो होवासे। अना वा की माय ला जोन मोरो भी माय लगासेत। वा दूई ला नमस्कार ");
INSERT INTO pwr_vpl VALUES ("RM16_14","075_16_14","ROM","16","14","14","असुंक्रितुस अना फिलगोन अना हिर्मेस अना पतरुबास अना हिर्मास अना उनको सगी भाऊ गिनला नमस्कार। ");
INSERT INTO pwr_vpl VALUES ("RM16_15","075_16_15","ROM","16","15","15","फिलुलुगुस अना यूलिया अना नेरयुस अना वाकि बहिन, अना उलुम्पास अना उनको सग को सब पवीतर लोकगीन ला नमस्कार। ");
INSERT INTO pwr_vpl VALUES ("RM16_16","075_16_16","ROM","16","16","16","आपस मा पवीतर चुम्मा लक नमस्कार करो। तुमला यीसु मसीह को सबा कलीसिया गीन को कन लक नमस्कार। ");
INSERT INTO pwr_vpl VALUES ("RM16_17","075_16_17","ROM","16","17","17","अबा ओ भाऊ अना बहिन गीन, मि तुमरो लक बिनती करासू का जोन लोकगीन वोना सिक्सा को विरोध मा जोन तुमीना पाइसेव, फूट डाखन अना ठोकर खावन को कारन सेत। उनला ताड़ लेव अना उन लक दुहुर रव्हो। ");
INSERT INTO pwr_vpl VALUES ("RM16_18","075_16_18","ROM","16","18","18","आपरो पोट को सेवा करनवारा, अना चिकनो-चिकनो साँग के सिदो-सादो मन को लोकगीन ला बहकानवारा, असो लोकगीन पिरभू यीसु मसीह को सेवा नही करा सेस, पर वय आपरो सेवा करसेस। ");
INSERT INTO pwr_vpl VALUES ("RM16_19","075_16_19","ROM","16","19","19","तुमरो हुकूम मानन को चरचा सब लोकगीन मा फैल गयो सेत, एको लाय मी तुमरो लाय खुसी मनावसू, पर मी यो चव्हासू, का साजरो लक अक्कलवर अना बुराई को लाय भोला बनो। ");
INSERT INTO pwr_vpl VALUES ("RM16_20","075_16_20","ROM","16","20","20","सान्ती को परमेस्वर सैतान ला तुमारो लात मा लवकर खुदवा देहेत। आमरो पिरभू यीसु मसीह को किरपा तुमरो पर होतो रव्हे। ");
INSERT INTO pwr_vpl VALUES ("RM16_21","075_16_21","ROM","16","21","21","मोरो संग काम करनवारा तीमुथियुस को, अना मोरो रिस्तेदार लूकियुस, अना यासोन अना सोसिपतरुस को तुमला नमस्कार। ");
INSERT INTO pwr_vpl VALUES ("RM16_22","075_16_22","ROM","16","22","22","मी चिठ्ठी लिखन वारा तिरतियुस को पिरभू मा तुमला नमस्कार। ");
INSERT INTO pwr_vpl VALUES ("RM16_23","075_16_23","ROM","16","23","23","गयुस जोन मोरो अना सब कलीसिया को पोहनाइ करनवारा, अना यो नगर को खजांची एरास्तू अना भाऊ क्वार्तुस तुमी लोक गिनला नमस्कार कव्हसेत। ");
INSERT INTO pwr_vpl VALUES ("RM16_24","075_16_24","ROM","16","24","24","आमरो पिरभू यीसु मसीह को किरपा तुम सब पर बनो रवहे। आमेन ");
INSERT INTO pwr_vpl VALUES ("RM16_25","075_16_25","ROM","16","25","25","वोना अमर परमेस्वर को स्तुति हो, जोन तुमी लोकगीन ला मोरो साजरा बारता अना यीसु मसीह को बारता को लक मजबूत राखन मा ताकतवर सेत। यो साजरो बारता वोना राज को सुरुवात से, जोन जुग-जुग लक लुको सेत। ");
INSERT INTO pwr_vpl VALUES ("RM16_26","075_16_26","ROM","16","26","26","पर अबा परगट हो गयो से। यो भविस्यवक्ता गिन को भविस्यवानी मोसे को नियम को लक अमर परमेस्वर को हुकूम लक, सब लोक गीन मा मुनादी कियो गयो से। जेनको लक वय भरोसा को लक अधिनता स्विकार करे। ");
INSERT INTO pwr_vpl VALUES ("RM16_27","075_16_27","ROM","16","27","27","वोच केवल एक गियान को रुप परमेस्वर को महिमा यीसु मसीह लक जूग-जूग तकन होहे आमेन");
INSERT INTO pwr_vpl VALUES ("C11_1","076_1_1","1CO","1","1","1","धाड़न वालो, पौलुस! जोन ला परमेस्वर को मरजी लक यीसु मसीह को पेरीत कह्यो जावत होतो, अना आमरो भाऊ सेस्थिनेस, ");
INSERT INTO pwr_vpl VALUES ("C11_2","076_1_2","1CO","1","2","2","कुरिन्थुस नगर को परमेस्वर को वोना कलीसिया को नाव, जोन यीसु मसीह मा पवितर कियो गयो सेत। अना जोनला परमेस्वर ना पवितर लोक बनन को लाय उनको संग निवाड़ो सेत। जोन हर जघा पिरभू यीसु को नाव ला हाकल सेत। ");
INSERT INTO pwr_vpl VALUES ("C11_3","076_1_3","1CO","1","3","3","आमरो बाबूजी परमेस्वर अना पिरभू यीसु मसीह को कन लक तुम्हिला दया अना सान्ती भेटत रव्हे। ");
INSERT INTO pwr_vpl VALUES ("C11_4","076_1_4","1CO","1","4","4","जोन किरपा तुम्हिला परमेस्वर ना यीसु मसीह लक दियो सेत। वोको लाय मी आपरो परमेस्वर ला धनवाद देवा सेऊ। ");
INSERT INTO pwr_vpl VALUES ("C11_5","076_1_5","1CO","1","5","5","यीसु मसीह मा होयके तुमी हरेक गोस्टी मा, मजे सप्पा बचन अना सप्पा गियान मा, धनी बन गयो सेत। ");
INSERT INTO pwr_vpl VALUES ("C11_6","076_1_6","1CO","1","6","6","अना यीसु मसीह को यो सन्देसा तुमरो मा पक्को भयी गयो सेत। ");
INSERT INTO pwr_vpl VALUES ("C11_7","076_1_7","1CO","1","7","7","यहान तकन का, कोनी बरदान को तुमरो मा कमी नाहती, अना तुमी आमरो पिरभू यीसु मसीह को, परगट होवन को रस्ता चोवत रव्हासो। ");
INSERT INTO pwr_vpl VALUES ("C11_8","076_1_8","1CO","1","8","8","परमेस्वर तुमला अखट्ट तकन पक्को बनाय राखेत, जोन लक तुमी आमरो पिरभू यीसु मसीह को दिवस तकन बेडाग रव्हो। ");
INSERT INTO pwr_vpl VALUES ("C11_9","076_1_9","1CO","1","9","9","परमेस्वर मा भरोसा ठेवनो पाहिजे। जोन ना आपरो टूरा यीसु मसीह को संग रव्हन को लाय हाकलयो सेत। ");
INSERT INTO pwr_vpl VALUES ("C11_10","076_1_10","1CO","1","10","10","मोरो संगीहुन! अमरो पिरभु यीसु मसीह को नाव मा मोरो तुमरो लक पिराथना सेत का तुमरो मा कोनी फूट नोको होवे। तुम सबा एक संग जुटो रव्हो अना तुमरो बिचार अना धेय एकच होवे। ");
INSERT INTO pwr_vpl VALUES ("C11_11","076_1_11","1CO","1","11","11","काहेकि अगो भाऊहुन! खलोए को घराना को लोकगीन, तुमरो बारेमा सांगयो सेत का तुमरो मा झगड़ा रार होवा सेत। ");
INSERT INTO pwr_vpl VALUES ("C11_12","076_1_12","1CO","1","12","12","मोरो सांगनो यो से का, तुमरो मा कोनी तो आपरो आपला पौलुस को, कोनी अपुल्लोस को, कोनी कैफा को, अना कोनी मसीह को कव्हासेत। ");
INSERT INTO pwr_vpl VALUES ("C11_13","076_1_13","1CO","1","13","13","का मसीह बट गयो सेत? का पौलुस तुमरो लाय कूरूस मा चघायो गयो सेत? या तुमिला पौलुस को नाव लक बप्तिस्मा भेटयो सेत। ");
INSERT INTO pwr_vpl VALUES ("C11_14","076_1_14","1CO","1","14","14","मी परमेस्वर को धनवाद करासू का क्रिस्पुस अना गयुस ला सोड़, मीना कोनी ला बप्तिस्मा नही देईसेव। ");
INSERT INTO pwr_vpl VALUES ("C11_15","076_1_15","1CO","1","15","15","कहि असो ना होहे का, कोनी बोलहेत का तुमीला मोरो नाव लक बप्तिस्मा मिलिसेत। ");
INSERT INTO pwr_vpl VALUES ("C11_16","076_1_16","1CO","1","16","16","अना हव मीना स्तिफनास को घराना ला छोड़, अखीन कोनी ला मी बप्तिस्मा नही देइसेव। ");
INSERT INTO pwr_vpl VALUES ("C11_17","076_1_17","1CO","1","17","17","काहेका मसीह ना मोला बप्तिस्मा देवन काजी नही, पर साजरो बारता आयकुआय लाय हक लक धाड़िसेस। वो भी सबद को लक नही, कही असो ना होहे की, मसिहा को कूरूस ला लोक बेकार समझन लगहेत। ");
INSERT INTO pwr_vpl VALUES ("C11_18","076_1_18","1CO","1","18","18","काहेका कूरूस को कथा, नास होवन वारा लाय, अठ्ठियापन सेत। पर आमी सूटकारा पावनवालो को लाय, परमेस्वर को ताकत सेत। ");
INSERT INTO pwr_vpl VALUES ("C11_19","076_1_19","1CO","1","19","19","काहेका लिखीसेत, मी गियानी गिनको गियान ला नास कर देहू, अना समजदार गीनको समजदारी ला बेकार कर देहू। ");
INSERT INTO pwr_vpl VALUES ("C11_20","076_1_20","1CO","1","20","20","कहान रहयो गियानीगिन? अना कहान रहयो मोसे को नियम को गुरू? कहान रहयो यो दुनिया को बकवासी? का परमेस्वर ना दुनिया को गियान ला, अठ्ठियागिरी नही ठहराईसेस? ");
INSERT INTO pwr_vpl VALUES ("C11_21","076_1_21","1CO","1","21","21","काहेका जबा परमेस्वर को गियान को लक दुनिया, परमेस्वर ला नही जानिन, तबा परमेस्वर ला यो साजरा लगयो का परचार को मुरखता को लक, भरोसा करनवारा ला सूटकारा दे। ");
INSERT INTO pwr_vpl VALUES ("C11_22","076_1_22","1CO","1","22","22","यहूदी गीन हिदान माँगसेत, अना यूनानी गीन गियान चाव्हा सेत। ");
INSERT INTO pwr_vpl VALUES ("C11_23","076_1_23","1CO","1","23","23","पर आमी कूरूस मा चघायो, गयो मसीह को च परचार करीसेजन। यो यहूदिगीन काजी भरोसा, मा बाधा, सेत। अना गैर यहुदी लाय जाल सेत। ");
INSERT INTO pwr_vpl VALUES ("C11_24","076_1_24","1CO","1","24","24","पर परमेस्वर को निवाड़ो गयो लोक गीनको लाई, चाहे वय यहूदी होय, या गैर यहुदी, येच मसीह की ताकत अना परमेस्वर की गियान से। ");
INSERT INTO pwr_vpl VALUES ("C11_25","076_1_25","1CO","1","25","25","काहेका परमेस्वर को बेअक्कल, मानूसगिन को पूरो अक्ल लक लगत सेत, अना परमेस्वर की कमजोरी, मानूस की ताकत लक, लगत ताकतवर से। ");
INSERT INTO pwr_vpl VALUES ("C11_26","076_1_26","1CO","1","26","26","ओ मोरो संगीहुन! अबा जरासो सोचो का जबा परमेस्वर ना तुम्हिला हाकलो होतो, ता तुमरो लक लगतसो ना अक्कल वर होतिन ना ताकतवर, लगत लोकगिन को समाज भी नीचो होतो। ");
INSERT INTO pwr_vpl VALUES ("C11_27","076_1_27","1CO","1","27","27","गियानी गिनला लजान काजी, परमेस्वर न तुम लोकगीन ला बेचयो से, जोन दुनिया को डोरा मा मुरख से। ताकतवर गीनला लजान काजी, वोना लोकगीन ला निवड़ीसेस, जोन दुनियाँ को डोरा मा कमजोर से। ");
INSERT INTO pwr_vpl VALUES ("C11_28","076_1_28","1CO","1","28","28","मोठो मानुसगिन को घमंड तोडन काजी, परमेस्वर वय लोकगीन ला निवाड़ी सेस, जोन दुनिया को नजर मा अठ्ठिया सेत। ");
INSERT INTO pwr_vpl VALUES ("C11_29","076_1_29","1CO","1","29","29","जोनमा कोनी देह वालो मानूस, परमेस्वर को पुढ़ा घमंड नोको करे। ");
INSERT INTO pwr_vpl VALUES ("C11_30","076_1_30","1CO","1","30","30","पर वोच परमेस्वर को कन लक तुमी यीसु मसीह मा सेव, जोन परमेस्वर को कन लक आमरो लाय गियान ठैरी सेत। नेकी अखीन पवीतर, अना मुकती। ");
INSERT INTO pwr_vpl VALUES ("C11_31","076_1_31","1CO","1","31","31","एकोलाय जसो पवीतर गिरंथ मा लिखीसेत “अदी कोनी घमंड करनो चव्हा सेत तो उ पिरभू मा घमंड करे।” ");
INSERT INTO pwr_vpl VALUES ("C12_1","076_2_1","1CO","2","1","1","अगो मोरो संगीहुन! मी जबा तुमरो जवर आयो होतो। ता परमेस्वर को सच्चो राज की गोस्टी ला, बोली को चतुराई अना मानूस को अक्कल लक उपदेस देवत नही आयो होतो। ");
INSERT INTO pwr_vpl VALUES ("C12_2","076_2_2","1CO","2","2","2","परा मी यो ठान के आयो होतो, का तुमरो बीच मा कूरूस मा चघायो गयो, यीसु मसीह को बारता को सिवाय कोनी गोस्टी नही करहीन। ");
INSERT INTO pwr_vpl VALUES ("C12_3","076_2_3","1CO","2","3","3","काहेका मी तुमी लोक गीनको बीच रव्हत बेरा, कमजोर, गुमसुम अना लगत डरयो हुयो होतो। ");
INSERT INTO pwr_vpl VALUES ("C12_4","076_2_4","1CO","2","4","4","अना मोरो सबद अना संदेस मा मानूस जसो चिकनो चुपड़ो गोस्टी नोहोति। बल्कि उनमा आतमा को ताकत अना सबूत होतो। ");
INSERT INTO pwr_vpl VALUES ("C12_5","076_2_5","1CO","2","5","5","जोनलक तुमरो बिस्वास मानूस को अक्कल को बजाय परमेस्वर को ताकत पर टिको रव्हे। ");
INSERT INTO pwr_vpl VALUES ("C12_6","076_2_6","1CO","2","6","6","जोन समजदार सेत। उनला अमी अक्कल देवा सेजन। परा यो अक्कल यो जुग को नाहती। ना च यो जुग को राजा हुनको अक्कल सेत। जोन दुनिया ला नास को कगर मा आनासेत। ");
INSERT INTO pwr_vpl VALUES ("C12_7","076_2_7","1CO","2","7","7","वोको जघामा अमी परमेस्वर को छिपयो गियान को अक्कल देवा सेजन। जोनला लगत जूनो जमाना ला परमेस्वर ना आमरो गौरव को काजी पक्को कियो होतो। ");
INSERT INTO pwr_vpl VALUES ("C12_8","076_2_8","1CO","2","8","8","अना यो गोस्टी ला एना जुग को कोनी भी राजा अना सासक नहि समजयो। काहेका अदी समजयो होतो ता, वय वा महिमा लक भरयो, पिरभू ला कूरूस मा नही चघातो। ");
INSERT INTO pwr_vpl VALUES ("C12_9","076_2_9","1CO","2","9","9","परा गीरंथ मा असो लिख्यो सेत, “जोनला डोरा लक नही चोव सकत, अना कान लक नही आयकयो, जहाँन मानूस को अक्कल तकन नही पहोच सका सेत। असो गोस्टी परमेस्वर को चहेतो लोक गिन लाय राख्यो सेत।” ");
INSERT INTO pwr_vpl VALUES ("C12_10","076_2_10","1CO","2","10","10","यो गोस्टी परमेस्वर ना आपरो आतमा लक आमरो पर परगट करीसेस, काहेकि आतमा सब काही गोस्टी, अना परमेस्वर को सब भेद ला भी जाँच से, अना सबा छिपयो भबिस्य वानी ला भी जाना सेत। ");
INSERT INTO pwr_vpl VALUES ("C12_11","076_2_11","1CO","2","11","11","मानूस मा लक कोनी, कोनी को भितर को गोस्टी ला जानासेत? सिरप वोच मानूस को आतमा, जोन वोको भितर सेत। वसोच परमेस्वर की गोस्टी ला भी कोनी नही जान सकासे। सिरप परमेस्वर को आतमा। ");
INSERT INTO pwr_vpl VALUES ("C12_12","076_2_12","1CO","2","12","12","पर अमीला दुनिया को आतमा नही, पर परमेस्वर को आतमा भेट्यो सेत। जोन लक अमीला परमेस्वर ना जोन वरदान सुपरुत करयो सेत, वोला अमी जान सका सेजन। ");
INSERT INTO pwr_vpl VALUES ("C12_13","076_2_13","1CO","2","13","13","जोनला आमी मानूस गिनको सिकायो गोस्टी पर नही, पर आतमा को सिकायो गयो गोस्टी मा आतमिक गोस्टी मिला-मिला के बखान करा सेजन। सांगनो को बेरा मा, मानूस को बुध्दि लक दियो गयो सबद नही, पर आतमा कन लक मिलियो सबद गीनला बौजासेन। ऐना रिती लक आमी आतमिक गोस्टी मा आतमिक घटना को बारे मा साँगा सेजन। ");
INSERT INTO pwr_vpl VALUES ("C12_14","076_2_14","1CO","2","14","14","पर सुभाविक मानूस परमेस्वर की आतमा सिक्सा नही धरा सेत। पर वोना गियान ला उ बेवाकुपी समजा सेत। अना ओला समजन काबिल नाहती। काहेका आतमा की सहायता लक, ओना सिक्सा की परख भई सका से। ");
INSERT INTO pwr_vpl VALUES ("C12_15","076_2_15","1CO","2","15","15","आतमिक मानूस सबच गोस्टी की परख कर लेवा से, पर कोनी भी उ मानूस की परख नही सका, ");
INSERT INTO pwr_vpl VALUES ("C12_16","076_2_16","1CO","2","16","16","जसो गीरंथ मा लिख्यो से “पिरभु को मन कोन जानासे? कोन ओला सलाह दे सकासे?” अना अमी मा मसीह को मन बसयो हुयो से। ");
INSERT INTO pwr_vpl VALUES ("C13_1","076_3_1","1CO","3","1","1","अगो संगीहुन! जोनको जवर आतमा सेत, उनको जसो मी तुमी लक गोस्टी नही कर सकयो। परा मोला एको उलटा तुमी लोकहुन लक अबा बिस्वास कियो मसीह जसो, तुमरो लक गोस्टी करनो पड़यो। मजे कलिसिया को बहारि लोक जसो। जोन मसीह मा लेकरा जसो सेत। ");
INSERT INTO pwr_vpl VALUES ("C13_2","076_3_2","1CO","3","2","2","तुम्हिला मोला दूध च पिलानो होतो। तुमी जेवन काबिल नही होतो। अना अबा भी तैयार नही सेव। ");
INSERT INTO pwr_vpl VALUES ("C13_3","076_3_3","1CO","3","3","3","अबा तुम यो दुनिया को लोकगिन को जसो रव्हासेव। जबा तुमी मा ईरसा होवा सेत। अना तुमी एकमेक लक झगड़ा करा सेव। का एकोलक साबीत होवा सेत का तुमी यो दुनिया लक संबंध लक जी रहयो सेत। ");
INSERT INTO pwr_vpl VALUES ("C13_4","076_3_4","1CO","3","4","4","जबा तुमरो मा लक कोनी कव्हासेत, “मी पौलुस को मघा चला सेऊ।” अना दुसरो, “मी अपोलुस को मघा चला सेऊ।” का तुमी दुनिया को लोक को जसो काम नही कर रहयो सेत? ");
INSERT INTO pwr_vpl VALUES ("C13_5","076_3_5","1CO","3","5","5","अखट्ट मा, अपोलुस कउन सेत? अना पौलुस कोन सेत? अमी केवल परमेस्वर को सेवक सेत। जोनको लक तुम्ही बिस्वास करन को लाय तैयार भयी सेव। आमरो लक हरेक वोच काम करा सेत, जोन काम पिरभू ना उनला दियो होतो। ");
INSERT INTO pwr_vpl VALUES ("C13_6","076_3_6","1CO","3","6","6","मिना बीज पेरो, अपोलुस ना फसल मा पानी चलायो। परा परमेस्वर ना वोला बड़ायो। ");
INSERT INTO pwr_vpl VALUES ("C13_7","076_3_7","1CO","3","7","7","जोन फसल पेरा सेत, अना जोन पानी सिंचा सेत उनको कोनी मायना नाहती। परा फसल ला बड़ावन वालो परमेस्वर मायना राखा सेत। ");
INSERT INTO pwr_vpl VALUES ("C13_8","076_3_8","1CO","3","8","8","लगावन अना सींचनवालो एकच काम करा सेत, अना हरेक आपरो-आपरो मेहनत को लक पगार पाहेत। ");
INSERT INTO pwr_vpl VALUES ("C13_9","076_3_9","1CO","3","9","9","अमी परमेस्वर को लाय एक संग काम करन वालो संगी सेजन। अना तुम परमेस्वर को काम करन को छेतर सेव। अना तुमी परमेस्वर को इमारत सेव। ");
INSERT INTO pwr_vpl VALUES ("C13_10","076_3_10","1CO","3","10","10","जोन बरदान परमेस्वर ना मोला दियो सेत, वोला बवजतो हुया मिना एक इमारत बनावन वालो इन्जनियर जसो, काम करीसेऊ। अना पाया धरीसेऊ, अना कोनी वोको मा बनावअ सेत। परा हरेक ला हुसियार रव्हन को जरूरत सेत। का कसो बनावअ सेत। ");
INSERT INTO pwr_vpl VALUES ("C13_11","076_3_11","1CO","3","11","11","यीसु मसीह घर को रद्दा सेत वोला छोड़ कोनी दुजो नीव नही डाक सकत। ");
INSERT INTO pwr_vpl VALUES ("C13_12","076_3_12","1CO","3","12","12","नीव मा रद्दा राखत बेरा कोनी मानूस सोन्नो खूरो कीमती गोटा काड़ी गवथ अना तनीस काम मा मनजे, ");
INSERT INTO pwr_vpl VALUES ("C13_13","076_3_13","1CO","3","13","13","तो हरेक को काम परगट भई जाहेती। अना नियाव को दिवस उ सागेत। काहेका उ स्तो को संग परगट होहे। अना उ स्तो हरेक काम की परिक्सा लेहेत का कसो सेत? ");
INSERT INTO pwr_vpl VALUES ("C13_14","076_3_14","1CO","3","14","14","जोन को काम बनो रव्हे, ओला ईनाम मिलेह। ");
INSERT INTO pwr_vpl VALUES ("C13_15","076_3_15","1CO","3","15","15","जोन को काम जर जाहे ओला ईनाम नही मिलेह, मंग उ बच जाहे, जसो कोनी स्तो पार करके बच जासे। ");
INSERT INTO pwr_vpl VALUES ("C13_16","076_3_16","1CO","3","16","16","का तुमी नही मालूम सेत का तुमी परमेस्वर को मंदिर सेव? अना परमेस्वर को आतमा तुमी मा रव्हसे। ");
INSERT INTO pwr_vpl VALUES ("C13_17","076_3_17","1CO","3","17","17","अदी कोनी परमेस्वर को मंदिर ला नास करा से, तो परमेस्वर ओला नास करा से। काहे की परमेस्वर को मँदिर पवीतर से, अना उ मँदिर तुमी सेव। ");
INSERT INTO pwr_vpl VALUES ("C13_18","076_3_18","1CO","3","18","18","कोनी आपरो आप ला धोखा नोको देवे। अदी तुमी मा लक कोनी दुनिया मा अपरो आपला गियानी समजासे, तो अपरो आपला मुरख बनाय ले। ");
INSERT INTO pwr_vpl VALUES ("C13_19","076_3_19","1CO","3","19","19","काहेकि यो संसार को गियान, परमेस्वर को नजर मा अठ्ठियापन सेत। पवीतर गिरँथ मा यो लिखी से, “उ गियानी गीनला उनको चतुराई मा च फसावासे” ");
INSERT INTO pwr_vpl VALUES ("C13_20","076_3_20","1CO","3","20","20","अना यो भी लिखीसे, “पिरभु जानासे की गियानी गीनको सोच विचार बेकार से।” ");
INSERT INTO pwr_vpl VALUES ("C13_21","076_3_21","1CO","3","21","21","एकोसाठी कोनी मानूस पर गरब नही करे। सबच काही तुमरो च से। ");
INSERT INTO pwr_vpl VALUES ("C13_22","076_3_22","1CO","3","22","22","चाहे उ पौलुस, अपुल्लोस अना कैफा होय, संसार होय या जीवन होय या मिरतु होय, बितो बेरा होय या भबिस्य होय-उ सबच तुमरो से। ");
INSERT INTO pwr_vpl VALUES ("C13_23","076_3_23","1CO","3","23","23","पर तुमी मसीह का सेव अना मसीह परमेस्वर को से। ");
INSERT INTO pwr_vpl VALUES ("C14_1","076_4_1","1CO","4","1","1","तुम्हि लोक अमिला एक मसीह को सेवक को रूपमा समजनो पाहिजे। परमेस्वर ना अमिला आपरो लुकयो हुया सच्चाई ला सांगन वालो बनायो गयो सेत। ");
INSERT INTO pwr_vpl VALUES ("C14_2","076_4_2","1CO","4","2","2","असो सेवक गिनको लाय यो गोस्टी जरूरी सेत। का वय अपरो गुरु को लाय बिस्वास को काबिल होवनो पाहिजे। ");
INSERT INTO pwr_vpl VALUES ("C14_3","076_4_3","1CO","4","3","3","मोला एको जरासो भी चिन्ता नाहती। का तुमी लोकहुन मोरो नियाव करो। या मानूस को कोनी अदालत। मी स्वता आपरो नियाव नही करा सेऊ। ");
INSERT INTO pwr_vpl VALUES ("C14_4","076_4_4","1CO","4","4","4","मोरो मन सफा सेत, परा यो साबीत नही करा सेत। का मी सही मा निरदोस सेऊ। परमेस्वर मोरो निरदोस होवन को फैसला करा सेत। ");
INSERT INTO pwr_vpl VALUES ("C14_5","076_4_5","1CO","4","5","5","एकोलाय तुम्हिला सही बेरा आवन को पयले कोनी को फैसला नही करनो पाहिजे। आखीर फैसला परमेस्वर को आवन को रस्ता चोवनो पाहिजे। उ जोन राज इन्धार मा लुकयो सेत, उनला उजाड़ मा आनेत। अना लोक गिनको डिमाक मा लुकयो उद्देस्‍य ला उजागर करहेत। तबा सबला परमेस्वर को कन लक बड़ाई भेटेत जोनको वय हकदार सेत। ");
INSERT INTO pwr_vpl VALUES ("C14_6","076_4_6","1CO","4","6","6","अपरो हित को लाय, मोरो संगीहुन! मिना अपोलुस अना मोरो उदाहरन लक यो गोस्टी सबा पर लागू करीसेऊ। जोन लक सबा सिक्सा आन के साजरो लक नियम को पालन करहेत। तुमीला कोनी पर गरब करनो अना कोनी ला नीच नही समजनो पाहिजे। ");
INSERT INTO pwr_vpl VALUES ("C14_7","076_4_7","1CO","4","7","7","कोनना तुम्हिला दुसरो लक साजरो बनायो सेत? का परमेस्वर ना तुम्हिला सबा काही नही दियो सेत जो तुमरो जवर सेत? खरो सेत, मंग तुमी कसो घमंड करा सेव? असो, जसो का कोनी चीज दुसरो को दियो नाहती? ");
INSERT INTO pwr_vpl VALUES ("C14_8","076_4_8","1CO","4","8","8","का सबा जरुरत को चीज पयले लक तुम्हरो जवर सेत? का पयले लक तुम्ही धनवान सेव? का तुम्ही राजा सेव? भलो अमी नाहती, मोरो मनसा तो असो होतो का तुम्ही राजा होवतो अना अमी सब राज करबिन। ");
INSERT INTO pwr_vpl VALUES ("C14_9","076_4_9","1CO","4","9","9","मोला ता असो लगासे, की परमेस्वर ना अमी पेरीत गिनला अखट्ट मा जघा दियो सेत। जसो का लोकगिन, अना सरगदूत गिनको पूरो दुनिया मा, अना मानूस गिनको लाय आमरो मौत को जुलुस हिटी सेत। ");
INSERT INTO pwr_vpl VALUES ("C14_10","076_4_10","1CO","4","10","10","अमी मसीह को साठी मुरख सेजन, पर तुमी मसीह मा समजदार दास सेव। अमी कमजोर सेजन, अना तुमी ताकतवर सेव। तुमी ला ईज्जत भेटा सेत, पर आमरो बेइज्जती होवा सेत। ");
INSERT INTO pwr_vpl VALUES ("C14_11","076_4_11","1CO","4","11","11","येना बेरा अमी भुको, तहान सेजन। फटयो-जुनो कपरा घालअ सेजन, मार खावा सेजन, आमरो संग बुरो बरताव होवा सेत, अमी बेघर सेत। ");
INSERT INTO pwr_vpl VALUES ("C14_12","076_4_12","1CO","4","12","12","अमी कड़ो मेहनत करके हरेक जरुरत ला पुरो करा सेजन। जबा कोनी अमिला सराप देवा सेत ता अमी आसिरवाद देवा सेजन। जबा अमिला कोनी सतावा सेत ता अमी सहन करतत। अमी आपरो हात लक मेहनत कर-करके थक जाय सेजन। ");
INSERT INTO pwr_vpl VALUES ("C14_13","076_4_13","1CO","4","13","13","वय हमारो निंदा करसेति, अना हमि बिनती करा सेजन। वय हमरो सँग असो बरताव करा सेत, जसो अमी संसार को कचरा अना समाज का कुड़ा सेजन। ");
INSERT INTO pwr_vpl VALUES ("C14_14","076_4_14","1CO","4","14","14","मि तुमला लजान काजी नही, पर आपरो चहेतो लेकरा समजके यो गोस्टी लिखके, सतरक करा सू। ");
INSERT INTO pwr_vpl VALUES ("C14_15","076_4_15","1CO","4","15","15","अदी तुमरो कठा लगत गुरुगिन सेत, पर मसीह मा तुमारो लगत सा दआजी नाहती। काहेका, मसीह यीसु मा साजरा बारता लक मी तुमी लोक गीनको दआजी बनयो सेऊ। ");
INSERT INTO pwr_vpl VALUES ("C14_16","076_4_16","1CO","4","16","16","अता मी तुमी लक बिनती करा सू, का तुमी मोरो जसो चलो। ");
INSERT INTO pwr_vpl VALUES ("C14_17","076_4_17","1CO","4","17","17","योच कारन लक मीना, तीमुथियुस ला, जोन पिरभू यीसु मसीह मा मोरो चहेतो टूरा सेत। वोला मी तुमरो कठा धाड़िसेउ। वो तुमिला मसिहा मा मोरो भरोसा को लायक चाल चलन ला हेत करायेत। जसो का मी हरेक जघा कलीसिया मा सिक्सा देवा सेऊ। ");
INSERT INTO pwr_vpl VALUES ("C14_18","076_4_18","1CO","4","18","18","काही लोकगीन घमंडी भई गई सेत। उनला असो लगा से, जसो मी उनको कठा आवनवालो नही सेऊ। ");
INSERT INTO pwr_vpl VALUES ("C14_19","076_4_19","1CO","4","19","19","पर पिरभू को मरजी सेत, ता मी तुमरो कठा लवकर आहिन। अना गरब करनवालो, लोक गीनको ताकत को पता चल जाहेती। ");
INSERT INTO pwr_vpl VALUES ("C14_20","076_4_20","1CO","4","20","20","काहेका परमेस्वर को राज, गोस्टी मा नाहती, पर वोको ताकत मा सेत। ");
INSERT INTO pwr_vpl VALUES ("C14_21","076_4_21","1CO","4","21","21","तुमरो काजक मनसा सेत? का तुमी ला समजावन काजी बेत धरके आऊ? या पिरेम, अना नरमी आतमा आन कन आऊ? ");
INSERT INTO pwr_vpl VALUES ("C15_1","076_5_1","1CO","5","1","1","अबा, सही मा यो आयकनो मा आवा सेत, का तुमरो बीचमा कु करम लगत फैल गयो सेत। असो कुकरम ता कोनी कुल को लोक गिनमा भी नाहती। मोला बतायो गयो सेत का एक मानूस आपरो मौसि माय को संग सो रहयो सेत। ");
INSERT INTO pwr_vpl VALUES ("C15_2","076_5_2","1CO","5","2","2","मंग काजक को गरब, एको उलट तुमरो मा उदासी होवनो पाहिजे। अना जोन मानूस ना असो काम कियो सेत वोला संगती लक बाहेर हेड़ो। ");
INSERT INTO pwr_vpl VALUES ("C15_3","076_5_3","1CO","5","3","3","अना मी तुमरो बीच मा नही सेऊ, मी दुहुर सेऊ, मंग मन लक तुमरो संग सेऊ। तुमी असो समजो का मी तुमरो जवर सेऊ। मीना पयले लक पिरभू यीसु को नाव लक फैसला देवा सेऊ ");
INSERT INTO pwr_vpl VALUES ("C15_4","076_5_4","1CO","5","4","4","का जबा तुमी संगति मा जमा होवने ता मोरो आतमा अना यीसु को ताकत लक, ");
INSERT INTO pwr_vpl VALUES ("C15_5","076_5_5","1CO","5","5","5","वा मानूस को देह ला सैतान को हात मा सोप देवने। वोको देह तो नास भयी जाहेत। पर पिरभु को दिवस मा वोको आतमा बचायो जाहेत। ");
INSERT INTO pwr_vpl VALUES ("C15_6","076_5_6","1CO","5","6","6","तुमरो गरब करनो साजरा नाहती। का तुमीला मालुम नहती? जरा सो खमिर सब मलो कनिक ला खमीर बना डाका सेत, अना जसो हाना सेत का “एक मरो मसरी, सप्पा बोडी को पानी ला, खराब कर देवसेस।” ");
INSERT INTO pwr_vpl VALUES ("C15_7","076_5_7","1CO","5","7","7","ता तुमी जुनो खमीर ला हेड़के, आपरो आपला सूद करो, मजे नवा मलो कनिक जसो बन जावो, जसो तुमी सहीमा सेव। काहेका आमरो फसह को तिहार को पाठी, मसीह भी बली भईसेस। ");
INSERT INTO pwr_vpl VALUES ("C15_8","076_5_8","1CO","5","8","8","एकोलाय आमी ना तो जूनो खमीर लक, ना तो बुराई, अना दुस्टपन को खमीर लक, पर बिना कपट को, अना खराई लक बेखमिरी भाकर लक, फसह को तिहार मनाबीन। ");
INSERT INTO pwr_vpl VALUES ("C15_9","076_5_9","1CO","5","9","9","मि ना आपरो चिठ्ठी मा लिखि सेव, का छिनरापन करनवारा को संगती नोको करजोस। ");
INSERT INTO pwr_vpl VALUES ("C15_10","076_5_10","1CO","5","10","10","यो जरुरी नाहती, का तुमी, यो दुनिया को छिनरा, लालची, लुटेरा, अना मुरत पुजा करनवारा, लोकगीन को संगति नोको राखो। तब ता तुम्हिला दुनिया लक हीट जानो पड़येत। ");
INSERT INTO pwr_vpl VALUES ("C15_11","076_5_11","1CO","5","11","11","पर मिना सहीमा, यो लिखि सेव का, अदी कोनी मसीह भाऊ कहलावा से, अना छिनरापन, लालची, मुरत पुजा करनवालो, सिवा देवनवारा, बेवड़ा, लुटेरा, होहे ता वोको सगंति नोको करा जोस। पर असो मानूस को संग, जेवन नोको करा जोस। ");
INSERT INTO pwr_vpl VALUES ("C15_12","076_5_12","1CO","5","12","12","काहेका मोला बाहेरवालो को नियाव करन लक काजक काम सेत? का तुम्हिला उनको न्याय नही करनो सेत? जोन कलीसिया मा सेत। ");
INSERT INTO pwr_vpl VALUES ("C15_13","076_5_13","1CO","5","13","13","बाहेरवालो लोक गीनको नियाव, परमेस्वर करा सेत। पर तुमी असो खोटो काम करनवारा ला, आपरो बीच लक हेड़ देव। ");
INSERT INTO pwr_vpl VALUES ("C16_1","076_6_1","1CO","6","1","1","का तुमरो मा असो कोनी मानूस सेत जोन आपरो च भाऊहुन को बीच मा कोनी झगड़ा होवनो मा परमेस्वर को पवितर मानूस गिन को जवर नही जावा सेत, पर हिम्मत करके अन्यायी गिनको अदालत मा जावा सेत। ");
INSERT INTO pwr_vpl VALUES ("C16_2","076_6_2","1CO","6","2","2","का तुमी ला नही मालूम सेत? का पवीतर लोकगीन दुनिया को सब लोक गीन को न्याय करयेत। अना यदी तुम्ही, सब दुनिया को लोकगीन को नियाव कराबिन। तो तुमी ऐना लहान-लहान झगड़ा-राड़ को नियाव स्वता काहे नही करा सेत? ");
INSERT INTO pwr_vpl VALUES ("C16_3","076_6_3","1CO","6","3","3","का तुमी नही जाना सो, क आमी सरगदूत गिनको नियाव करबीन? ता का आमी, यो दुनिया को गोस्टी को न्याय करन काबील नाहती? ");
INSERT INTO pwr_vpl VALUES ("C16_4","076_6_4","1CO","6","4","4","मंग जबा तुमी लोकगीन लाय, दुनिया को गोस्टी को न्याय करन लाय, अदालत सेत। तो का तुमी असो मानूस ला, न्यायलय बसा जोस, जोन कलीसिया मा काही नहती? ");
INSERT INTO pwr_vpl VALUES ("C16_5","076_6_5","1CO","6","5","5","मी तुमला लजान काजी, नही सांगा सू। का यो खरो सेत, का तुमारो बीच मा कोनी गियानी भेद करन वालो नाहती? जोन आपरो भाऊ गीन को तन्टा ला सुलजा देवे। ");
INSERT INTO pwr_vpl VALUES ("C16_6","076_6_6","1CO","6","6","6","अबिस्वासी गिनको पुढ़ा, न्याय भेटन लाय आपरो भाऊ-भाऊ पर नालिस करा सो। यो तुमरो काजी सरम को बात सेत। ");
INSERT INTO pwr_vpl VALUES ("C16_7","076_6_7","1CO","6","7","7","तबा ता खरो-खर तुमरो पयलो गलती योच सेत। का तुमी एक दुसरो पर नालीस करा सेव, तुमी हानी काहे नही सहा सेव? तुमच छल ला काहे नही सहा सेव? ");
INSERT INTO pwr_vpl VALUES ("C16_8","076_6_8","1CO","6","8","8","एको उलट तुमी आपरो भाऊ गीनको संग अन्याव करा सेव। ");
INSERT INTO pwr_vpl VALUES ("C16_9","076_6_9","1CO","6","9","9","का तुमीला नही मालूम सेत? का बदी करन वालो परमेस्वर को राज मा वारिस नही होहेत। धोखा नोको खावो, छिनरापन करनवारा, ना तो मुरत पुजा करनवारा, ना दुसरो को बायको संग सोवनवारा, छिनाल, ");
INSERT INTO pwr_vpl VALUES ("C16_10","076_6_10","1CO","6","10","10","न तो चोर, बेवड़ा, न सीवा देवन वालो, ना तो लुट-खसोट करन वालो, परमेस्वर को राज को वारिस होहेत। ");
INSERT INTO pwr_vpl VALUES ("C16_11","076_6_11","1CO","6","11","11","अना तुमी मा लक काही, असोच होतिन। पर अबा तुमी पिरभू यीसु मसीह को नाव लक, अना आमरो परमेस्वर को आतमा लक, धोयो गयो, पवीतर करियात अना नेक बन गयो सेत। ");
INSERT INTO pwr_vpl VALUES ("C16_12","076_6_12","1CO","6","12","12","तुमरो मा लक कोनी असो सांगेत, “मोला सब चीज बेखटका करन को अधिकार सेत।” “हव पर सब साजरा नाहती।” मी असो सांग सका सू, “मोला सब चीज करन को सूट सेत।” “पर मी कोनी चीज को गुलाम नहिसेऊ।” ");
INSERT INTO pwr_vpl VALUES ("C16_13","076_6_13","1CO","6","13","13","कोनी असो भी सांगेत पर जेवन पोटको लाय, अना पोट जेवन को लायसेत। पर परमेस्वर, यो दुई को अन्त कर देहेत। मंग देह छिंडरापन लाय नाहती, पर पिरभू काजी सेत, अना पिरभू देह काजी सेत। ");
INSERT INTO pwr_vpl VALUES ("C16_14","076_6_14","1CO","6","14","14","परमेस्वर ना जसो पिरभू ला जिलायो, वसोच उ अमीला भी, आपरो ताकत लक जित्तो करयेत। ");
INSERT INTO pwr_vpl VALUES ("C16_15","076_6_15","1CO","6","15","15","का तुमला मालूम नहती? तुमरो देह मसीह को आंँग सेत। तो का मी मसीह को आँग ला धरके बेसिया को आँग बना देऊ? ");
INSERT INTO pwr_vpl VALUES ("C16_16","076_6_16","1CO","6","16","16","का तुमीला यो मालुम नहती? जोन बेसिया को संग सोवा सेत, वो वोको संग एक देह होय जावा सेत, काहेका असो कव्हयो गयो सेत, का दुई एक देह होहेत। ");
INSERT INTO pwr_vpl VALUES ("C16_17","076_6_17","1CO","6","17","17","पर उ जोन पिरभू लक संगत करतत, वोको संग एक आतमा होय जासे। ");
INSERT INTO pwr_vpl VALUES ("C16_18","076_6_18","1CO","6","18","18","छिनालापन लक पराय जावो। अना सप्पा पाप, जोन मानूस करा सेत, वय देह लक बाहेर होवासेत। पर छिनालापन करनवारा, आपरो देह को बिरोध मा पाप करासेत। ");
INSERT INTO pwr_vpl VALUES ("C16_19","076_6_19","1CO","6","19","19","का तुमिला मालुम नही सेत? का तुम लक हरेक को देह पवीतर आतमा को मंदिर सेत। जोन तुममा सेत, अना वा तुमिला परमेस्वर लक भेटयो सेत। तुमी आपरो नही सेव। ");
INSERT INTO pwr_vpl VALUES ("C16_20","076_6_20","1CO","6","20","20","काहेका तुमी मोल देके सूटायो गयो सेव, एको एवज मा आपरो तन लक, परमेस्वर को महिमा करो। ");
INSERT INTO pwr_vpl VALUES ("C17_1","076_7_1","1CO","7","1","1","अबा, तुमरो कन लक लिख्यो मामला गिनला निपटान को लाय। एक मरद साजरो लक बिहा नही करतत। ");
INSERT INTO pwr_vpl VALUES ("C17_2","076_7_2","1CO","7","2","2","एकोलाय का उ लगत बायका को संग से। ता हरेक मरद को आपरो एकच बायको होवनो पाहिजे। अना हरेक बायको को एकच बायको होवनो पाहिजे। ");
INSERT INTO pwr_vpl VALUES ("C17_3","076_7_3","1CO","7","3","3","एक मरद ला नवरा को रूपमा आपरो करतब पूरो करनो पाहिजे। वसोच एक बायको ला एक नवरी को रूपमा करतब पुरो करके दूई एक दुसरो को जरुरत पूरो करनो पाहिजे। ");
INSERT INTO pwr_vpl VALUES ("C17_4","076_7_4","1CO","7","4","4","बायको ला आपरो देह मा हक नहती, पर वोको नवरा को सेत, वसोच नवरा को आपरो देह मा हक नाहती, पर वोकी बायको को सेत। ");
INSERT INTO pwr_vpl VALUES ("C17_5","076_7_5","1CO","7","5","5","एक दुसरो ला यो हक लक दुहुर नोको राखो, पर काही दिवस काजी, दुई को मनको लक, बेगरो भई जावोत, जेनको लक पिराथना काजी बेरा मिल जाहेती, मंग एक संग रव्हो, सैतान ला मौका नोको देव, का उ तुमरो परिक्सा करे। ");
INSERT INTO pwr_vpl VALUES ("C17_6","076_7_6","1CO","7","6","6","पर मी तुमला यो परमिसन देवा सू, यो हुकूम नाहती। ");
INSERT INTO pwr_vpl VALUES ("C17_7","076_7_7","1CO","7","7","7","मंग मी चाव्हसु का, जसो मी कुंवारो सेऊ, वसोच सब मानूस कुंवारो रहेत, पर हरेक मानूस ला परमेस्वर कन लक, अलग-अलग बरदान भेटयो सेत। कोनी ला काही, तो कोनी ला काही? ");
INSERT INTO pwr_vpl VALUES ("C17_8","076_7_8","1CO","7","8","8","पर अबा जोन कुंवारो अना बेवा सेत, उनला मी सांगा सेऊ का, उनको वसोच रव्हनो साजरा सेत। ");
INSERT INTO pwr_vpl VALUES ("C17_9","076_7_9","1CO","7","9","9","वय बिना सादि को नही रव्ह सकसेत, ता वा सादी करा लेवे, तो साजरा सेत। काहेका लगन करनो, “बाडी कुदनो” लक साजरा सेत। ");
INSERT INTO pwr_vpl VALUES ("C17_10","076_7_10","1CO","7","10","10","पर सादि-सुदा गिनला मी नही, पर पिरभू यो हुकूम देवा सेत, का बायको आपरो नवरा ला नोको सोड़े। ");
INSERT INTO pwr_vpl VALUES ("C17_11","076_7_11","1CO","7","11","11","पर अदी वा सोड़ भी देवे, तो पाठ नोको करे, पर आपरो नवरा लक मिलाप करे, अना नवरा आपरो बायको ला नोको सोड़े। ");
INSERT INTO pwr_vpl VALUES ("C17_12","076_7_12","1CO","7","12","12","दुसरो लक पिरभू नही, पर मी सांगासू, का अदी कोनी भाऊ को बायको बिस्वास नही राखा सेत, अना वोको संग खुसी लक रव्हा सेत तो उ वोला नोको सोड़े। ");
INSERT INTO pwr_vpl VALUES ("C17_13","076_7_13","1CO","7","13","13","जोन बायको को नवरा अबिस्वासी सेत, अना वोको संग रव्हन लक खुस रव्हा सेत, तो वा नवरा ला नोको सोड़े। ");
INSERT INTO pwr_vpl VALUES ("C17_14","076_7_14","1CO","7","14","14","काहेका असो भाऊ आपरो बायको को कारन लक पवीतर ठयरासेत, अना असी बायको जोन अबिस्वासी सेत, आपरो नवरा को कारन पवीतर ठयरासेत, असो नाहती तो तुमरो लेकरा बारा असुध्द होत्यो, पर अबा पवीतर सेत। ");
INSERT INTO pwr_vpl VALUES ("C17_15","076_7_15","1CO","7","15","15","पर जोन नवरा भरोसा नही राखन वारा सेत, उ अदी बेगरो रव्हे, तो वोला बेगरो होवन देव, असो दसा मा कोनी भाऊ, अना बहिन कब्जा मा नाहती। काहेका परमेस्वर ना अमीला मेल करवान काजी हाकलि सेत। ");
INSERT INTO pwr_vpl VALUES ("C17_16","076_7_16","1CO","7","16","16","काहेका अवो बायको! का तोला मालूम सेत? का तू आपरो नवरा ला बचाय सका सेत। अना अगो भाऊ! तोला का मालूम सेत? का तू आपरो बायको को ला बचा सका सेत। ");
INSERT INTO pwr_vpl VALUES ("C17_17","076_7_17","1CO","7","17","17","जसो पिरभू ना हरेक ला दीयो सेत, अना जसो परमेस्वर ना हरेक ला हाकलि सेत, वसोच चले, मी सबा कलीसिया मा असोच ठहरावा सेऊ। ");
INSERT INTO pwr_vpl VALUES ("C17_18","076_7_18","1CO","7","18","18","अदी कोनी खतना करवान वालो मानूस ना परमेस्वर को हाकलनो ला अपना लियो सेत, ता वोको खतना हटावन को कोसीस नही करनो पाहिजे। वसोच बिन खतना वालो मानूस ना, परमेस्वर को हाकलनो आयक के आयो सेत, ता वोको खतना नोको करवाओ। ");
INSERT INTO pwr_vpl VALUES ("C17_19","076_7_19","1CO","7","19","19","न खतना काही सेत, अना खतना नही करवानो काही सेत पर परमेस्वर को हुकूम ला माननो सब काही सेत। ");
INSERT INTO pwr_vpl VALUES ("C17_20","076_7_20","1CO","7","20","20","हरेक जन जोन दसा मा हाकलो गयो सेत वोच मा रव्हे। ");
INSERT INTO pwr_vpl VALUES ("C17_21","076_7_21","1CO","7","21","21","अदी तू दास को दसा मा हाकलो गयो सेत, तो मनमा चिन्ता नोको कर पर तू खुल्ला हो सका सेत असो काम कर। ");
INSERT INTO pwr_vpl VALUES ("C17_22","076_7_22","1CO","7","22","22","काहेका जोन दास को दसा मा पिरभू मा हाकलो गयो सेत, उ पिरभू को छुड़ायो गयो सेत, वसोच जोन छुट्टो सेत उ मसीह को दास सेत। ");
INSERT INTO pwr_vpl VALUES ("C17_23","076_7_23","1CO","7","23","23","तुमी दाम देके छुट्टो कियो गयो सेव, एको लाई तुमी मानुसगिन को दास नोको बनो। ");
INSERT INTO pwr_vpl VALUES ("C17_24","076_7_24","1CO","7","24","24","अगो भाऊ हुन जोन कोनी जोन दसा मा हाकलो गयो सेव उ वोच दसा मा परमेस्वर को संग रव्हे। ");
INSERT INTO pwr_vpl VALUES ("C17_25","076_7_25","1CO","7","25","25","अबा कुंवारी टुरीगीन को बारेमा पिरभू को कोनी हुकूम, मोला नही भेटिसेत। पर बिस्वास को काबिल होवन को काजी, जसो दया पिरभू ना मोरो पर करिया सेत, वोको लक मी सला देवा सेऊ। ");
INSERT INTO pwr_vpl VALUES ("C17_26","076_7_26","1CO","7","26","26","मोरो समज मा यो साजरा सेत, का आज काल को बखत को लक, मूसिबत को कारन, जोन जसो सेत, वसोच रव्हे। ");
INSERT INTO pwr_vpl VALUES ("C17_27","076_7_27","1CO","7","27","27","अदी तोरी बायको सेत, तो वोको लक अलग नोको रव्ह, अना बायका नाहती, तो नोको ढूढ। ");
INSERT INTO pwr_vpl VALUES ("C17_28","076_7_28","1CO","7","28","28","पर तू लगन करजोस, तो ओ कोनी पाप नाहती, अना कुवारी को लगन भई जाय, तो कोनी पाप नाहती। पर असो मा तन ला दुख होहेत, वोको लक मी बचावनो चाव्हासू। ");
INSERT INTO pwr_vpl VALUES ("C17_29","076_7_29","1CO","7","29","29","ओ भाऊ हुन! मी असो कव्हसू, का बेरा कम कियो गयो सेत। एकोलाय, तुमीला जोनको बायका सेत, उ असो रव्हे का जसो वोकी बायको नाहती। ");
INSERT INTO pwr_vpl VALUES ("C17_30","076_7_30","1CO","7","30","30","अना रड़नवारा असो रव्हे, मानो डोरा मा पानी नाहती। अना खुसी मनावनवारा, असो मनावे, जसो उ खुस नाहती। अना काही लेवनवारा असो लेवे, जसो वोको कठा काही नाहती। ");
INSERT INTO pwr_vpl VALUES ("C17_31","076_7_31","1CO","7","31","31","अना यो दुनिया को चीज ला, असो काम मा लावो, मानो वोको कोनी जरूरत नाहती। काहेका दुनिया को यो रुप बदलतो जाय रव्होसेव। ");
INSERT INTO pwr_vpl VALUES ("C17_32","076_7_32","1CO","7","32","32","एकोलाय मी तो असो चाव्हसे का तुमला काही बात को फिकर नोको होय। जोन कुंवारो सेत उ पीरभू को गोस्टी को फीकर करा सेत। अना उ पिरभू ला खुस करनो चाव्हसेत। ");
INSERT INTO pwr_vpl VALUES ("C17_33","076_7_33","1CO","7","33","33","पर जोन सादी-सूदा सेत उ दुनिया दारी को चिन्ता करा सेत। अना उ वोको बायको ला खुस राखन चाव्हा सेत। ");
INSERT INTO pwr_vpl VALUES ("C17_34","076_7_34","1CO","7","34","34","अना वोको धियान संसार मा बट जावासे, अखीन जोन कुंवारी सेत वोला पिरभू को आतमा को चिन्ता रव्हा सेत। का वा देह मन लक पवीतर होयहेत पर सादि-सूदा बायको, आपरो नवरा ला खुस राखन चाव्हा सेत। ");
INSERT INTO pwr_vpl VALUES ("C17_35","076_7_35","1CO","7","35","35","मी यो गोस्टी तुमारो भलाई को लाय कव्हासू, तुमला उलझान काजी नही, यो काजी जसो सोबा देवासेत वसोच करो। का तुम एक चित लक पिरभू को सेवा करो। ");
INSERT INTO pwr_vpl VALUES ("C17_36","076_7_36","1CO","7","36","36","अदी कोनी असो जरुरी समजासेत का मी वा कुंवारी को हक्कमार रहि सेव, जोनको जवानी ढल रही सेत, अना जरुरत भी सेत तो उ जसो मरजी मा सेत बिहा कर सका सेत। यो मा कोनी पाप नाहती वोको बिहाव होवन देवे। ");
INSERT INTO pwr_vpl VALUES ("C17_37","076_7_37","1CO","7","37","37","जोनको इरादा तय सेत, वोला जरूरत नाहती, असो समजासेत, वा आपरो मन ला आपरो बसमा राखा सेत, अना ठान लेवासेत का आपरो टूरी ला कुवारी राखनो सेत, उ साजरा करासेत। ");
INSERT INTO pwr_vpl VALUES ("C17_38","076_7_38","1CO","7","38","38","मंग जोन आपरी कुंवारी टूरी को लगन कर देसे उ साजरो करासेत, अना जोन लगन नही करासेत उ अखीन साजरा करासेत। ");
INSERT INTO pwr_vpl VALUES ("C17_39","076_7_39","1CO","7","39","39","जब तकन कोनी बायको को नवरा जित्तो सेत, तब तकन वोको जोड़ा वोको संग बन्धो सेत, पर वोको नवरा मर गयो तो उ खुली भई गई वा पिरभू मा कोनी लक बिहा कर सका सेत। ");
INSERT INTO pwr_vpl VALUES ("C17_40","076_7_40","1CO","7","40","40","पर मोरो बिचार लक जसो उ सेत वसोच रव्हे तो अखीन साजरा सेत। अना मी समजासू का मोरो मा परमेस्वर को आतमा सेत। ");
INSERT INTO pwr_vpl VALUES ("C18_1","076_8_1","1CO","8","1","1","अबा मुरत गीनको पुड़ा चघायो हुयो बली को बारेमा, आमी जाना सेजन, अना आमी सक्ड़िया मानूस ला यो मालूम सेत। पर पिरेम लक सबको उन्नती होवासेत, पर गियान गरब ला पैदा करा सेत। ");
INSERT INTO pwr_vpl VALUES ("C18_2","076_8_2","1CO","8","2","2","अदी कोनी असो समजा सेत का मोला सब मालूम सेत। तो जितरो वोला मालूम होवनो पाहिजे, वोतरो वोला साजरा लक मालूम नाहती। ");
INSERT INTO pwr_vpl VALUES ("C18_3","076_8_3","1CO","8","3","3","पर अदी कोनी परमेस्वर लक माया राखासेत, ता परमेस्वर वोला चिन्हअ सेत। ");
INSERT INTO pwr_vpl VALUES ("C18_4","076_8_4","1CO","8","4","4","ता आमीला मुरत गीनको पुड़ा चघायो हुयो जेवन को बारेमा अमीला मालूम सेत, का मुरती दुनिया मा काही नाहती। अना एक परमेस्वर ला छोड़, कोनी दुसरो परमेस्वर नाहती। ");
INSERT INTO pwr_vpl VALUES ("C18_5","076_8_5","1CO","8","5","5","अमीला यो मालूम सेत, का बादल अना धरती मा, ढगभर परमेस्वर सेत, अना पिरभू भी सेत। ");
INSERT INTO pwr_vpl VALUES ("C18_6","076_8_6","1CO","8","6","6","मंग आमरो कठा एकच परमेस्वर सेत, मजे परमेस्वर दआजी जेनना सब चीज ला बनाइसेस, अना उ आमीला भी बनाइसेस, एकोलाय उ आमरो भी पिरभू सेत, वोच यीसु मसीह सेत। ");
INSERT INTO pwr_vpl VALUES ("C18_7","076_8_7","1CO","8","7","7","पर यो सत हरेक मानूस ला मालूम नाहती, काही लोकगीन, हाल मा मुरती पुजा करनवारा होतिन। वय मुरत गीन को पुड़ा चघायो हुयो जेवन समजके जेवत होतिन, अना उनको मन कमजोर होवन को कारन, अपवीतर हो जावासेत। ");
INSERT INTO pwr_vpl VALUES ("C18_8","076_8_8","1CO","8","8","8","जेवन अमीला परमेस्वर को कठा नही धाड़ा सेस। अदी आमी जेवन नही करबीन, तो काही नुकसान नाहती। अना जेवन करबीन, तो काही फायदा नाहती। ");
INSERT INTO pwr_vpl VALUES ("C18_9","076_8_9","1CO","8","9","9","पर सतरक रव्हजोस, असो ना भई जाय का, तुमरो यो हक कोनी निरबल बिस्वासी को पड़न को कारन भई जाय। ");
INSERT INTO pwr_vpl VALUES ("C18_10","076_8_10","1CO","8","10","10","काहेका कोनी तोरो जसो अक्कल वर ला, मुरत गीन को पुड़ा चघायो हुयो जेवन मंदिर मा जेवन करत चोवके, उ भी जेवन करन बस जाहेती। ");
INSERT INTO pwr_vpl VALUES ("C18_11","076_8_11","1CO","8","11","11","असो रीत लक तोरो गियान को कारन लक, उ कमजोर बिस्वासी जोनको लाय मसीह मरयो सेत, नास भई जाहेती। ");
INSERT INTO pwr_vpl VALUES ("C18_12","076_8_12","1CO","8","12","12","अना भाऊ-बहिनहुन को बिरोध मा, असो पाप करन लक अना उनको कमजोर बिचार को कारन लक, उनको दिल दुखान को पाप करतत, जोन मसीह को बिरोध मा सेत। ");
INSERT INTO pwr_vpl VALUES ("C18_13","076_8_13","1CO","8","13","13","एकोलाय अदी मोरो जेवन, मोरो भाऊ अना बहिनगिन को लाय, पाप को कारन बना सेत, तो मी सदा जेवन नही जेहुँ। कही असो ना भई जाय का, मी आपरो भाऊ अना बहिन को काजी पाप को कारन बन जाऊ। ");
INSERT INTO pwr_vpl VALUES ("C19_1","076_9_1","1CO","9","1","1","का मी छुट्टा मानूस नही सेऊ? का मी पेरीत नही सेऊ? का मीना पिरभू यीसु ला नही चोविसेऊ? का तुमी लोक मोरो मेहनत को फर नोहोव? ");
INSERT INTO pwr_vpl VALUES ("C19_2","076_9_2","1CO","9","2","2","मोला दुसरो लोकगीन पेरीत नही माना सेत, तो का भयो, मी तो तुमरो काजी पेरीत सेऊ। काहेका तुमी लोकगीन, पिरभू मा मोरो पेरीत होवन को चिन्ह सेव। ");
INSERT INTO pwr_vpl VALUES ("C19_3","076_9_3","1CO","9","3","3","जोन लोकगीन बिना जाँच को मोरो पर लान-छान लगावासेत, उनला आपरो बारेमा मोला यो सांगनो सेत। ");
INSERT INTO pwr_vpl VALUES ("C19_4","076_9_4","1CO","9","4","4","का हमला खावन-पीवन को हक नाहती? ");
INSERT INTO pwr_vpl VALUES ("C19_5","076_9_5","1CO","9","5","5","का अखीन पेरीत गीन पिरभु को भाऊ गीन, अना कैफा को जसो, हमला आपरी मसीही बहिन ला बायको बनाके आपरो सँग लेजान को हक नाहती? ");
INSERT INTO pwr_vpl VALUES ("C19_6","076_9_6","1CO","9","6","6","का मि अना बरनबास, आपरो जिन्दगी चलान को लाई काम करन को हक सेत। ");
INSERT INTO pwr_vpl VALUES ("C19_7","076_9_7","1CO","9","7","7","का यो कबच आयकनो मा आयो, की कोनी आपरो खरचा लक सेना मा सेवा करासे? कोनी अंगूर को बारी लगायके, ओको फर नही खावासे? कोनी पालतु जनावर पालके ना करप को देख-रेख करके, ओना जनावर को दुध नही पिवा से? ");
INSERT INTO pwr_vpl VALUES ("C19_8","076_9_8","1CO","9","8","8","यो मि सादो जीवन को उदाहरन लक नही कव्ह रही सेव। पर मोसे को नियम पवीतर गिरंथ भी योच कव्हासे। ");
INSERT INTO pwr_vpl VALUES ("C19_9","076_9_9","1CO","9","9","9","काहेकि मोसे को नियम मा लिखयो से, तुमी गाहानी करतो बेरा बईल को पर मोहरका नोको लगाने। का परमेस्वर ला बईल गीनको चिंता से? ");
INSERT INTO pwr_vpl VALUES ("C19_10","076_9_10","1CO","9","10","10","या उ हमरो लाई यो जरुरी कव्हासे? यो पक्को हमरो लाई लिखी से; काहेकि यो बेस से की, उपज को हिस्सा मिलन की आस लक जोतन वालो नांगर चलाहे। अना दावन वालो दावनी करेत। ");
INSERT INTO pwr_vpl VALUES ("C19_11","076_9_11","1CO","9","11","11","अदी अमीना आतमिक बीज बोया सेजन, तो का हमी दुनिया को देहिक फर खावन-पिवन को चीजको आस नही राखबीन? ");
INSERT INTO pwr_vpl VALUES ("C19_12","076_9_12","1CO","9","12","12","अदी दुजो लोकगीन ला तुमी पर यो हक से, तो का बराबरी मा हमरो लगत हक नही? मंग हमीना यो हक ला नही बवजसेजन, काहेका हमी मसीह को साजरो बारता मा कोनी बाधा डाकनो नही चाव्हा सेजन। एको लाई हमी, हर तौर लक दुख उठासेजन। ");
INSERT INTO pwr_vpl VALUES ("C19_13","076_9_13","1CO","9","13","13","का तुमी लोकगीन नही जानोह, की मंदिर मा धरम सेवा करनवारा ला, मंदिर लक जेवन मिला से। अना वेदी की सेवा करन वारा, वेदी की चघावा को हिस्सेदार सेत। ");
INSERT INTO pwr_vpl VALUES ("C19_14","076_9_14","1CO","9","14","14","असोच पिरभू ना हुकूम देइसेस, का साजरा बारता आयकावान वारा, साजरा बारता आयकवा के, आपरो जिंदगी को रूजूक भाकर चला सका सेत। ");
INSERT INTO pwr_vpl VALUES ("C19_15","076_9_15","1CO","9","15","15","पर मिना ऐना हक को बवजनो कोनी मतलब को लाय नही कियो। अना यो मि एकोलाय नही लिख रही सेव, की अबा मोरो लाई असोच कियो जाहे। मि भलाई मर जाहुँ, बल्की मि आपरो आपच ला ऐना महिमा लक छुटयो नही सेऊ। ");
INSERT INTO pwr_vpl VALUES ("C19_16","076_9_16","1CO","9","16","16","मि यो गोस्टी पर गरब नही करुसु, की मि साजरो बारता को साँगन वालो सेऊ। मि तो यो काम करन को लाई मजबुर सेव। हाय! से मोला, अदी मि साजरो बारता ला नही सांगु। ");
INSERT INTO pwr_vpl VALUES ("C19_17","076_9_17","1CO","9","17","17","अदी मि आपरी मनसा लक यो कव्हसू, तो मोला ईनाम को हक से, पर मि आपरी मरजी लक यो नही करुसु। मोला जोन काम भरोसा लक सौपियो गई से मि ओला पूरो करुसेऊ। ");
INSERT INTO pwr_vpl VALUES ("C19_18","076_9_18","1CO","9","18","18","तो ईनाम पर मोरो कोन तो हक से? अना मि साजरो बारता को बारे मा आपरो हक ला काम मा नही आनु सेऊ। उ यो से का मी फोकट मा, साजरो बारता ला सांगा सेऊ। ");
INSERT INTO pwr_vpl VALUES ("C19_19","076_9_19","1CO","