﻿USE sofia;
DROP TABLE IF EXISTS sofia.pwg_vpl;
CREATE TABLE pwg_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES pwg_vpl WRITE;
INSERT INTO pwg_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Karenai God bera kudubina kunumai ma dobuwai iyamoni. ");
INSERT INTO pwg_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Kunona na ke aviyavisina sago ita makamakai da kata kitai, tuna nakanani ma kwavu bo bau. Nubakutuva kavakava ma God Kanumina kiidamowai ivivi dagudagu da okowa iriroi. ");
INSERT INTO pwg_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Vaghina ma God ivona bo, “Yasegana ketupuwa” da iyaghari. ");
INSERT INTO pwg_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Ma ikitai da biibiina. Muriyai yasegana da nubakutuva itupayaraghi. ");
INSERT INTO pwg_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Ma yasegana ivi vavei ‘mara’ ma nubakutuva ivi vavei ‘didibara.’ Ravi ipika, ididibari da mara karena ikovi. Ma mara itom. ");
INSERT INTO pwg_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Muriyai ivona bo, “Taraboga, okowa basunai ketupuwa da okowa ketupayaraghi.” ");
INSERT INTO pwg_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Vaghina ma iberai da taraboga nabana itupuwa ma okowa ivi bogebogesi da nevanevana ighae ku kiidamo ma nevanevana kapinai imakai. ");
INSERT INTO pwg_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Nakanani itupuwa ma tarabogina ivi vavei ‘kunuma.’ Ravi ipika, ididibari ma mara itom. Weni tuna na mara kana viruwa. ");
INSERT INTO pwg_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Muriyai ivona bo, “Okowa kapinai na ku gawara sago kovi sagomi da dowa kanakanana ina nekiibau,” da nakanani itupuwa. ");
INSERT INTO pwg_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Ma dowa kanakanana ivi vavei ‘dobu’ ma okowina ivi vavei ‘yegai.’ Ma ikitai da biibiina. ");
INSERT INTO pwg_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Muriyai ivona bo, “Dowa, gwabimuwai pei ma kii bogii ma bogiiyai etupuwa da dobuwai ina gogo. Ma ina rove bo iname da peisi ina rakata.” Ma nakanani itupuwa. ");
INSERT INTO pwg_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Dobuwai pei igogo ighae da peisi nununai iterei. Ma bade kii igogo ighae da kiisi amesi nununai iame da ere peisi. Ma ikitai da biibiina. ");
INSERT INTO pwg_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Ravi ipika, ididibari ma mara itom. Weni tuna na mara kana viaroba. ");
INSERT INTO pwg_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Muriyai ivona bo, “Yasegana kunumai kotupuwa. Weni yaseganisi, mara ma didibara ini bogebogei, ini matakira da iri, mara ma madegha. ");
INSERT INTO pwg_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","Kunumai ina makai da dobu kana yasegana.” Ma nakanani itupuwa. ");
INSERT INTO pwg_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Yasegana ghamaghamasi ruwa iyamoni. Ghamana iyamoni da mara kana vibadana. Ma sago kayo gisina iyamoni da didibara kana vibadana. Ma bade gwamegwame yavata iyamonisi. ");
INSERT INTO pwg_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Peyarisi kunumai iteresi da dobu iti yasegani, ");
INSERT INTO pwg_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","da didibara ma mara iti badei, ma yasegana da nubakutuva iti bogebogesi. Ma ikitai da biibiina. ");
INSERT INTO pwg_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Ravi ipika, ididibari ma mara itom. Weni tuna na mara kana viruwamaruwa. ");
INSERT INTO pwg_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Muriyai ivona bo, “Yegai, gwabimuwai iyana etupuwa da ina peyari kirakai. Ma bade kiu kotupuwa da kiidamowai kona rovo.” ");
INSERT INTO pwg_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Vaghina ma yegai ghamoghamosi ma bade iyana bogii ma bogiiyai iyamonisi da yawayawasi ma bababasi. Ma kiu ere mapemapesi iyamonisi da bogii ma bogiiyai. Ma ikitai da biibiina. ");
INSERT INTO pwg_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Ma ivi biibiinisi ma ivona bo, “Kovi tuwa kirakai da kona peyari. Iyana, yegai da okowa kovi tupoi. Kiu, kovi tuwa da kona peyari dobuwai.” ");
INSERT INTO pwg_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Ravi ipika, ididibari ma mara itom. Weni tuna na mara kana vimiikovi. ");
INSERT INTO pwg_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Muriyai ivona bo, “Dobu, gwabimuwai ghamoghamo etupuwa, ghamoghamo manamisi ma dowatetetesi ma ghamoghamo dipa. Bogii ma bogiiyai iti tuwa da natunatusi na ti mani maghimaghighisi.” Ma nakanani itupuwa. ");
INSERT INTO pwg_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Nani ghamoghamosi kudubina iteresi da iti tuwa da natunatusi na ti mani maghimaghighisi. Ma ikitai da biibiina. ");
INSERT INTO pwg_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Muriyai ivona bo, “Wawaya tayamonisi da maghimaghighita. Ti na dobu kudubina ini badei. Iyana yegiyai ma kiu kiidamowai ma bade ghamoghamo manamisi ma dowatetetesi ma ghamoghamo dipa na kudubina dobuwai ini badesi.” ");
INSERT INTO pwg_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Ma vaghina, wawaya iyamonisi da tuna mani maghimaghighina. Iteresi da tomowa ma wavine. ");
INSERT INTO pwg_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Ivi biibiinisi ma ivona bo, “Kovi tuwa da tupurereghimi ina peyari. Dobu kovi tupoi ma kovi badei. Ghamoghamo ma bera kudubina dobuwai idagudagu na kovi badesi, iyana yegiyai ma kiu kiidamowai yavata.” ");
INSERT INTO pwg_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Muriyai ivona bo, “Kami vavai na aviyavisina dobuwai egogogo, peisi yavata, kii amame ere peisi ma bade vavai dowa kamonai, kudubina avereveremi da kona kani. ");
INSERT INTO pwg_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Ma ghamoghamo kii vavai na inamona ma kii rugurugu matamatisi. Ghamoghamo kudubina yawayawasi dobuwai idagudagu, ghamoghamo dipa ma kiu ma dowatetetesi yavata na inamona ma kii rugurugu kudubina avereveresi da ina kani.” Ma vaghina, nakanani itupuwa. ");
INSERT INTO pwg_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","God bera kudubina iyamoni ikovi na ikitai da ibiibii kirakai. Ravi ipika, ididibari ma mara itom. Weni tuna na mara kana vimiikovimasago. ");
INSERT INTO pwg_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Ma vaghina, nakanani God iberai da kunuma ma dobu ma bera kudubina iyamoni. ");
INSERT INTO pwg_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Mara miikovimasago na bigana iberaberai da ivi koviya. Mara kana vimiikovimaruwa na ivi yakam. ");
INSERT INTO pwg_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Tuna kubiine mara kana vimiikovimaruwa ivi biibiini ma ivinei da vovokaravina. ");
INSERT INTO pwg_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Kunuma ma dobu varagutugutuna ma ikikava Bada God iyamoni na weni. Kunuma ma dobu iyamoyamoni, ");
INSERT INTO pwg_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","na garewa ke ita vonatawei, karakava. Tuna kubiine ke sago kii bo inamona bo pei tano tepanai ita gogo. Ma kesago wawaya da tano ita wayowei. ");
INSERT INTO pwg_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Ma vusira tano kamonai igheghae da dowa kudubina ivivi nubanubai. ");
INSERT INTO pwg_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Vaghina ma, Bada God tano iviiya ma tomowa ivopasipasiya, yana itawe ku giyabonaghina da tomowina irupapara da yawayawana. ");
INSERT INTO pwg_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Ma dobu sago ku maramatana imakamakai kana vava Eden. Eden kamonai na Bada God vao sago iberai ma nani tomowina ivopasipasiya na nake iterei. ");
INSERT INTO pwg_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Ma iberai da kii bogii ma bogiiyai tano kamonai igogo ighae. Viya kitasi biibiisi ma nuwaviiviinisi ma viya amesi na vavai. Ma vao basunai na kii ivi ruwa imiimiiri. Sago na Yawasa Kiina ma sago na Akova Kiina. Iyavo kava Akova Kiina amena ina kani na akova biibiina ma bade akova berona ina veresi. ");
INSERT INTO pwg_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Ma Eden kamonai okowa sago iveraverau da vao ivivi nubanubai ma nani dobunai okowina ivi ruragharagha da okowa ruwamaruwa. ");
INSERT INTO pwg_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Okowa sago kana vava Pison na dobu kana vava Havila kamonai iveruriwariwa da dobuna ine yavui. Nani dobunai gold imakamakai ");
INSERT INTO pwg_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","ma nani gold na ghamana ma biibiina, ma bade kii ipana ghabughabusi ma wakima vovokeyakeyusi imakamakai. ");
INSERT INTO pwg_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Okowa kana viruwa na kana vava Gihon ma dobu kana vava Kus kamonai iveruriwariwa da dobuna ine yavui. ");
INSERT INTO pwg_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Okowa kana viaroba na kana vava Taigris ma tuna iveraverau ku maramatana Asiriya nevanai. Ma okowa kana viruwamaruwa na kana vava Yuperetis. ");
INSERT INTO pwg_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Vaghina ma, Bada God tomowina ivopasiya ikovi na Eden kamonai iterei da ita wayowa ma vao ita koyaghi. ");
INSERT INTO pwg_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Ma ina sisiya bagibagina iterei, ivonei bo, “Weni vona kamonai kii amame peyarina kuna kani, ");
INSERT INTO pwg_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","ma kii sago kava na amena ke kuna kani. Tuna na Akova Kiina. Wawaya ina kani na akova ina veresi da nuwanuwasi kamonai inakovi da meni berana na biibiina ma meni berana na berona. Kuna kani na vonavaghata da kuna rabobo.” ");
INSERT INTO pwg_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Ma bade ivona bo, “Ke ita biibai da tomowina ina kina kava ina makai. Kana neva ana yamoni da ini vitei.” ");
INSERT INTO pwg_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Bada God namada dowa iviini da ghamoghamo ma kiu peyarina ivopasipasisi. Ma ineyesi tomowina kurina da ita kitai ikikava iti vavesi. Ivi vaghinei da tomowina ina kayowanai sago sago duma kii vava iveresi. ");
INSERT INTO pwg_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Ma vaghina, ghamoghamo manamisi ma kiu kiidamowai ma ghamoghamo dipa kii vava iveresi ikovi, ma nani kamonai na ‘Adam’ ke kana neva kiimatana da iti vitei. ");
INSERT INTO pwg_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Tuna kubiine Bada God iberai da tomowina ikena irabobo. Ma nani kamonai tuwirina sago ghabaghabanai ivotawei ma tarabogina na viyonai ivopotai. ");
INSERT INTO pwg_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Ma tuwirinai wavine iyamoni ma irutinaneyei tomowina kurina. ");
INSERT INTO pwg_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Ma tomowina ivona bo, “Vaghina, ibiibii kirakai! Weni na taku maghimaghighiku! Tuwirina, tuwirikuwai iviiya ma viyona, viyokuwai iviiya. Tuna kubiine kana vava ‘wavine,’ ina karena taku tomowa gwabikuwai iviiya.” ");
INSERT INTO pwg_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Weni berana kubiine tomowa ina mamai ma ina maduwa ina voteresi da kawana yavata ini kiikapu da sago. ");
INSERT INTO pwg_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Ma tomowina wavinena yavata imakamakai ma ivi ruwa na iyusi kava ma ke iti nimaya. ");
INSERT INTO pwg_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Bada God ghamoghamo iyamonisi kamosiyai na sago ina bera vigayagaya irakata. Tuna na mota. Inae da wavinena ivi nuwatini, ivonei bo, “Vonavaghata da God ivonem da kiiamame peyarina vao kamonai ke kona kani bo?” ");
INSERT INTO pwg_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Ma wavinena ivonapotei, “Kegha, tokai kiiamame peyarina vao kamonai kana kani. ");
INSERT INTO pwg_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","Ma ivonatanikai da vao basunai kii sago kava na ‘amena’ ke kana kani bo kiina ke kana votovoni. Kana berai na kana rabobo.” ");
INSERT INTO pwg_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Ma ivonapotei, “Tuna ke vonavaghata, tami ke kona rabobo. ");
INSERT INTO pwg_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","God iakovi da kota kani na matami ita votawei da kotakova kirakai da ami akova na tuna mani ina akova nakanani. Nuwanuwam kamonai biibiina ma berona kotakova yavui.” ");
INSERT INTO pwg_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Ma wavinena ikita da nani kiina iame ikitai da ivi nuwaviivai. Ma inotai da ibiibai da ita kani. Ma bade ina kayowana ghamana da nani akovina ita viiya. Vaghina ma ipura da ikam. Ma tomowina na yavata da wavinena viya iverei da tuna bade ikani. ");
INSERT INTO pwg_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Ikam ikovi ma nota iviiya da ti na iyusi kava. Ma kii rugurugusi iyuna ivatura da ikiipapaparisi. ");
INSERT INTO pwg_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Nani ravinai ivi ruwa ivi yanei da Bada God vao kamonai ibababa na kii kunukunusiyai ikovemakai. ");
INSERT INTO pwg_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Ma kegha, Bada God tomowina kurina ivi kwatu, “Adam, tam imapatana?” ");
INSERT INTO pwg_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Ma ivonapotei, “Weni vaona kamonai avi yanem ma taku iyuku kava na ayabumanem, tuna kubiine na akove.” ");
INSERT INTO pwg_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Ma Bada God ivona bo, “Iyi ivonem da iyum kava? Avonatanim da nani kiina amena ke kuta kani. Ma tam kukani, bo?” ");
INSERT INTO pwg_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Ma tomowina ivona bo, “Wavinena gwabikuwai kuterei, tuna kii amena ivereku da akani.” ");
INSERT INTO pwg_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Ma Bada God wavinena ivonei bo, “Avi kubiine weni berana kuberai?” Ma ivonapotei bo, “Mota ivi beroberoweku da akani.” ");
INSERT INTO pwg_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Vaghina ma Bada God mota ivonei, “Tam aimimaghim! Weni berana kuberai kubiine ghamoghamo peyarisi kamosiyai tam kovogha ghamana kuna viiya. Karako ma mara ku kudubina kuna tetete. Ma popoku kuna kanikani da am mara ku turina. ");
INSERT INTO pwg_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Ma ana berai da tam ma wavinena koni kawapata. Ma bade peim ma wavinena peina yavata ini kawapata nonowa. Mara sago kaekarena kuna kani ma gayamim ini tugudai.” ");
INSERT INTO pwg_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Vaghina ma wavinena ivonei bo, “Ana berai da am ropeya kamonai am inivisi ina rakata da ere vokwarakwaram kuni tuwa. Ma ana berai da am kayowana ghamana da kawam. Ma tuna ini badem.” ");
INSERT INTO pwg_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Vaghina ma, Adam ivonei bo, “Avonem da kii amena ke kuta kani ma kawam gamona kuvi yanei da kukani. Tuna kubiine dowa aimimagi, da kuni inipika kirakai am yawasa ku kudubina da kuna kam. ");
INSERT INTO pwg_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Ma am wayowa kamonai inamona ma iyiyo ina gogo. Ma dipiyai yabayaba kunekwa yawara da kuna kam. ");
INSERT INTO pwg_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Kuni poyapoya da kuna kam, nakanani ina nenae da mara sago kuna vovira kuni dowa. Tam dowiyai avovipasipasim da kuvi wawaya ma mara sago na kuna vovira ku dowa.” ");
INSERT INTO pwg_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Adam kawana ivi vavei Eve iyamna tuna wavinena na wawaya kudubisi i maduwa. ");
INSERT INTO pwg_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Ma Bada God ghamoghamo bekasi iviiya da gara iyamoni, ma Adam kawana yavata ivi kotesi. ");
INSERT INTO pwg_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Nani murinai Bada God ivona bo, “Karako nani wawayisi ivi ruwa na tota nakanani, biibiina ma berona iakovi. Ma ke vaghina da ita vororona da Yawasa Kiina amena ita viiya. Amena ita kani na yawasa makamakii nonowina ita veresi.” ");
INSERT INTO pwg_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Tuna kubiine Eden kamonai ikwavinisi ikiibau. Ti i karena na dowiyai ivopasipasisi ma ivonatawesi ikiibau da dowa ita wayowei. ");
INSERT INTO pwg_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Ikwavinisi ikovi na vao kupunai kana koyakoyagha iteresi, maramatana ku nevana aneya rewapanisi iteresi da wawaya ke ita rui. Ma seri ghamana ere yebayebarina ma vovokeyakeyuna iterei da ivivi kiivirevirei, tuna na Yawasa Kiina ivivi tarapaparanei. ");
INSERT INTO pwg_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Adam kawana Eve yavata ikena da iropeya. Ma ivi tuwa da tomowa ma ivona bo, “Bada ivi viteku da natuku tomowa avi tuwei.” Ma ivi vavei Kein. ");
INSERT INTO pwg_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Muriyai ivi tuwame da bade natuna tomowa ma tuna ivi vavei Abel. Natunatusi imagura na Abel ivivi ghamoghamo ma Kein na tano iwayowayowei. ");
INSERT INTO pwg_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Imakamakai da mara sago ita suwara Bada kurina. Kein na iyaba ma vavai ipiyei. ");
INSERT INTO pwg_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Ma Abel na siya monamonana ipiyei. Siyana na sipu natunatusi iyiyarokosi viya ivunuwa ma viyosi biibiisi kavakava isuwarei. Bada, Abel ina suwara yavata nuwanuwana iviiya. ");
INSERT INTO pwg_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","Ma Kein ina suwara yavata ibaresi da Kein nuwanuwana ipughu ma maghighina ibero. ");
INSERT INTO pwg_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Ma Bada ivonei, “Avi kubiine nuwanuwam ipughu? Avi kubiine maghighim ibero?” ");
INSERT INTO pwg_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Bera biibiisi kuna beraberai na ana kayowem. Kekitaruvim. Berabero ekayokayowei da ini badem, ikoyakoyagha da ina vowim. Kevi rewapana da kuna ghegavovori. ");
INSERT INTO pwg_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Vaghina ma Kein, tina kikei Abel ivonei, “Takiibau ku warere.” Ikiibau ma Kein ikayaya tina kikei kurina da ikiivunui. ");
INSERT INTO pwg_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Nani murinai Bada, Kein ivi tarakiiyanei, “Abel imapatana?” “Ke atakovi. Taku ke tiku kikei kana koyakoyagha.” ");
INSERT INTO pwg_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Ma Bada God ivona bo, “Kevi yana, tim kikei tarana tanowai imatakira kuriku, biwa viinina kubiine. Avi kuberai? ");
INSERT INTO pwg_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Tam imamuwai da tarana dowa inunui da ivi beroi. Tuna kubiine aimimagim da ke kuna wayowa. ");
INSERT INTO pwg_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Dowa kuna wayowei da imai ma kara vavai ke ghamana kuna panani. Kenae! Kuni ketabababa dobuwai.” ");
INSERT INTO pwg_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Ma Kein ivona bo, “Kovogha kuvereku na irakata kirakai. ");
INSERT INTO pwg_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Karako kekwavikwaviniku da dowa ke ana wayowei ma bade ana kiibukuyowem. Dobuwai ani ketabababa, aku numa kegha. Ma wawaya ina pananiku na ina kiivunuku.” ");
INSERT INTO pwg_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Ma Bada God ivonapotei, “Kegha, sisiya atereterei da meni wawayina ina kiivunum na taku kovogha berona mara miikovimaruwa ana verei, biwa ghamanakina ina viiya.” Ma Bada matakira Kein gwabinai iterei da iyavo kava ita panapanani na ke ita kiivunui. ");
INSERT INTO pwg_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Ma vaghina, Kein ivomiiri da Bada ikuyowei ma inae da ku dobu sago kana vava Nod ma nani dobunai imakai. Nod na ku maramatana Eden nevanevanai. ");
INSERT INTO pwg_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Kein kawana yavata ikena ma kawana iropeya da natusi tomowa itupuwa, kana vava Inoka. Ma Kein kwanatu ivowai ma kwanatuna ivi vavei da Inoka, natuna yavata ivi varigheya. ");
INSERT INTO pwg_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Ma Inoka imagura ma ivi tuwa da natuna kana vava Iradi. Ma Iradi imagura ma ivi tuwa da natuna Meyujayel. Ma Meyujayel imagura ma ivi tuwa da natuna Metusela. Ma bade Metusayel imagura ma ivi tuwa da natuna na Lameki. ");
INSERT INTO pwg_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Ma Lameki kakawana ruwa, kii vava Ada ma Sila. ");
INSERT INTO pwg_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Ada ivi tuwa da natuna Jabal. Ma tuna ina rakaraka yavata i kiki da ghamoghamo ivivi kam ma yobeyai ivivi makiiyana. ");
INSERT INTO pwg_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Ma Jabal tina kikei kana vava Jubal. Tuna ina rakaraka yavata i kiki na durere iuvuveni ma hap ivivi rekwei. ");
INSERT INTO pwg_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Ma bade Lameki kawana Sila ivi tuwa da natuna Tubal Kein. Tuna na kirama ma brons igudaguda da bagibagi sawarisi bogii ma bogiiyai iyamoyamona. Ma Tubal Kein novuna na Nama. ");
INSERT INTO pwg_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Mara sago Lameki kakawana kurisi ikayotata, ivonesi bo, “Ada ma Sila, aku sisiya kovi yanei. Kakawaku kovi yaneku. Tomowa yaragina iraviku na akiivunui. Tomowina gubaga ivereku tuna kubiine avi raboboi. ");
INSERT INTO pwg_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","God sisiya iterei da meni wawayina Kein ita kiivunui na kovogha berona mara miikovimaruwa ita verei. Ma taku Lameki avonavona da meni wawayina ina kiitovoniku na biwa mara 77 ina viiya.” ");
INSERT INTO pwg_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Kein tina kikei ikiivunui tuna kubiine Bada ikwavini da ina maduwa ma ina mamai ikuyowesi inae. Nani murinai, Adam kawana yavata ikena ma ivi tuwame da natusi tomowa. Ma ivona bo, “Kein ivomiiri da tina kikei Abel ikiivunui, tuna kubiine God weni pepeyina ivereku da Abel epayanina.” Ma ivi vavei Seti. ");
INSERT INTO pwg_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Seti imagura ma ivi tuwa da natuna tomowa. Ma ivi vavei Inos. Ma Seti ina mariyai na wawaya ivi karei da Bada kana vava ivovokavakavari. ");
INSERT INTO pwg_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Weni girumina na Adam, tupurereghina yavata ikikava ivi tuwa ma kii vava itura. Karenai na God wawaya iyamonisi da tuna mani maghimaghighina. ");
INSERT INTO pwg_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Iyamonisi da tomowa ma wavine, ivi biibiinisi ma ivi vavesi “wawaya.” ");
INSERT INTO pwg_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Adam kana madegha 130 na natuna tomowa itupuwa da ina mamai maghimaghighina. Ma ivi vavei Seti. ");
INSERT INTO pwg_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Muriyai madegha 800 imakai ma kamonai na natunatuna viya tomotomowisi ma wivinesi itupuwa. ");
INSERT INTO pwg_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Ma vaghina, kana madegha 930 ma irabobo. ");
INSERT INTO pwg_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Seti kana madegha 105 na natuna tomowa itupuwa. Ma ivi vavei Inos. ");
INSERT INTO pwg_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Muriyai madegha 807 imakai ma kamonai na natunatuna viya tomotomowisi ma wivinesi itupuwa. ");
INSERT INTO pwg_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Ma vaghina, kana madegha 912 ma irabobo. ");
INSERT INTO pwg_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Inos kana madegha 90 na natuna tomowa itupuwa. Ma ivi vavei Kenan. ");
INSERT INTO pwg_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Muriyai madegha 815 imakai ma kamonai na natunatuna viya tomotomowisi ma wivinesi itupuwa. ");
INSERT INTO pwg_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Ma vaghina, kana madegha 905 ma irabobo. ");
INSERT INTO pwg_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Kenan kana madegha 70 na natuna tomowa itupuwa. Ma ivi vavei Mahalalel. ");
INSERT INTO pwg_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Muriyai madegha 840 imakai ma kamonai na natunatuna viya tomotomowisi ma wivinesi itupuwa. ");
INSERT INTO pwg_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Ma vaghina, kana madegha 910 ma irabobo. ");
INSERT INTO pwg_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Mahalalel kana madegha 65 na natuna tomowa itupuwa. Ma ivi vavei Jaredi. ");
INSERT INTO pwg_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Muriyai madegha 830 imakai ma kamonai na natunatuna viya tomotomowisi ma wivinesi itupuwa. ");
INSERT INTO pwg_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Ma vaghina, kana madegha 895 ma irabobo. ");
INSERT INTO pwg_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Jaredi kana madegha 162 na natuna tomowa itupuwa. Ma ivi vavei Inoka. ");
INSERT INTO pwg_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Muriyai madegha 800 imakai ma kamonai na natunatuna viya tomotomowisi ma wivinesi itupuwa. ");
INSERT INTO pwg_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Ma vaghina, kana madegha 962 ma irabobo. ");
INSERT INTO pwg_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Inoka kana madegha 65 na natuna tomowa itupuwa. Ma ivi vavei Metusela. ");
INSERT INTO pwg_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Nani murinai Inoka, God yavata ivi nuwasago da yavata ibababa. Ma madegha 300 imakai ma kamonai na natunatuna viya tomotomowisi ma wivinesi itupuwa. ");
INSERT INTO pwg_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Ma vaghina, kana madegha 365 ma iwapa. ");
INSERT INTO pwg_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","God yavata ivi nuwasago, tuna kubiine ke ita rabobo ma God iviitawei. ");
INSERT INTO pwg_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Metusela kana madegha 187 na natuna tomowa itupuwa. Ma ivi vavei Lameki. ");
INSERT INTO pwg_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Muriyai madegha 782 imakai ma kamonai na natunatuna viya tomotomowisi ma wivinesi itupuwa. ");
INSERT INTO pwg_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Ma vaghina, kana madegha 969 ma irabobo. ");
INSERT INTO pwg_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Lameki kana madegha 182 na natuna tomowa itupuwa. ");
INSERT INTO pwg_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Ma ivi vavei Nowa. Ma Lameki ivona bo, “Bada dowa imagi da ita biga irakata ma tikamaghiyei, ma weni wawaya kikina kara ini viteta ma ini yawasita.” ");
INSERT INTO pwg_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Muriyai madegha 595 imakai ma kamonai na natunatuna viya tomotomowisi ma wivinesi itupuwa. ");
INSERT INTO pwg_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Ma vaghina, kana madegha 777 ma irabobo. ");
INSERT INTO pwg_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Nowa imakai da kana madegha 500 ma nani kamonai natunatuna tomotomowa aroba itupuwa. Kii vava Sem, Ham ma Jepeta. ");
INSERT INTO pwg_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Wawaya ivi karei da i koroto irakarakata dobuwai. Natunatusi ituputupuwa da kamosiyai viya na wivine. ");
INSERT INTO pwg_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","Ma God natunatuna tomotomowa ikita da wawaya natunatusi wivinesi na karakarawatisi ma i kayowanai irutinisi da iravaghisi. ");
INSERT INTO pwg_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Ma Bada ivona bo, “Karako wawaya rabobo damina eviiviiya da Kanumiku gwabisiyai ke ina makii nonowa. Ini karei da tupuwisi ina bero ma i yawasa ke ina guri. Ke ina makii kirakai da kii madegha 120 ina kuyowei.” ");
INSERT INTO pwg_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","God natunatuna nani wivinesi iravaghisi ma natunatusi ituputupuwa, nani maranai na Nepirim damsi namada dobuwai imakamakai. Nepirim na tupuwisi ghamaghamasi, ti na iyo damsi, tomotomowa avatetesi mara katamaninai. ");
INSERT INTO pwg_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Vaghina ma Bada ikitai da wawaya i berabero dobuwai irakata kirakai ma bade ikitai da i nota didibarisi ivovotana nonowei. ");
INSERT INTO pwg_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Nuwanuwana ipoyai da wawaya iyamonisi ma dobuwai iteresi. Nuwanuwana ivisi kirakai da ivona bo, ");
INSERT INTO pwg_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","“Wawaya ayamonisi ma kegha da nuwanuwaku ipoyai. Tuna kubiine dobuwai ana kiipupunatawesi, ghamoghamo da kiu ma dowatetetesi yavata.” ");
INSERT INTO pwg_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Ma Bada tomowa sago kava ivivi nuwabiibiiyei. Tomowina kana vava Nowa. ");
INSERT INTO pwg_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Weni tuna na Nowa ina varagutugutu. Tuna ina mariyai wawaya kudubisi na beroberosi. Ma Nowa ina kina kava na tomowa maninina. Ma ina yawasa kamonai God yavata ivivi nuwasago ma yavata ibababa. ");
INSERT INTO pwg_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Ma natunatuna tomotomowa ivi aroba, ti na Sem, Ham ma Jepeta. ");
INSERT INTO pwg_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Ma nani maranai God ikitai da bera didibarisi dobuwai irakata. Wawaya mara nonowa ivivi ruwa ma kiivunuwa irakata. ");
INSERT INTO pwg_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","I berabero ikitai ma ke iti vaghinei da wawaya kudubisi i bera didibarisi irakata kirakai. ");
INSERT INTO pwg_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Tuna kubiine Nowa kurina ivona bo, “Weni nakanani ana berai, wawaya kudubisi ana pupunatawesi. I kayoghakighaki dobu ikiimumui, tuna kubiine bera kudubina dobuwai ma wawaya yavata ana kiipupunatawesi da kii mara ina kovi. ");
INSERT INTO pwg_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Ma tam na ‘kii biibiisi’ ketara da waka kevowai. Kamonai na tupayaragha keyamona ma kamona ma kupuna na kii ipanai kepasi. ");
INSERT INTO pwg_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Kevowai da kana guri na 133 mitas ma kana naba na 22 mitas, ma ina ghae da 13 mitas. ");
INSERT INTO pwg_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Ma waka kana tarasovo keyamoni. Ma waka kawaririnai da matakororo basusiyai na taraboga 50 sentimita ina makai. Ma waka kamona kekemai da kema aroba ina tupuwa, sago tepanai, sago basunai ma sago gaburinai. Ma bade waka kana matuketa baranai keterei. ");
INSERT INTO pwg_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Taku na kutukutuva ana vonatawei da wawaya kudubisi dobuwai ina kiipupunatawesi. Bera kudubina yawayawana dobuwai na ina rabobo. ");
INSERT INTO pwg_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Ma tam ma taku tavi nuwasago kubiine, na vivaghina makamakiina taberai da taku na kam papara ana vowai. Kawam yavata korui ku waka, tami, natunatumi ma kakawasi yavata. ");
INSERT INTO pwg_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Ma ghamoghamo kudubisi bogii ma bogiiyai, tomotomowisi ere kakawasi kerutinisi da yavata kona geru. Kii papara kuna vowai da ke ina rukwa. ");
INSERT INTO pwg_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Nani kamonai kiu bogii ma bogiiyai, ruwa ruwi duma, ere kakawasi ma ghamoghamo dipa ere kakawasi ma bade dowatetetesi ere kakawasi na kudubina ina pisi kurim. Ma kerutinisi ku waka kona rui da ke ina rukwa. ");
INSERT INTO pwg_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Ma vavai bogii ma bogiiyai tami kubiimi ma bade ghamoghamo kubiisi koyuna da waka kamonai kovovidaburana. Tuna tepanai kona makai.” ");
INSERT INTO pwg_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Ma vaghina, Nowa ikikava God ivonaverei na peyarina ibera yavui. ");
INSERT INTO pwg_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Bada ivona bo, “Nowa, akitim da tam kava dobu kamonai am yawasa na maninina kavakava. Tuna kubiine tam, kawam ma natunatumi, kakawasi yavata korui ku waka. ");
INSERT INTO pwg_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Ma meni ghamoghamosi ma kiusi avi vaghinei da kam ma suwara kubiine na tomotomowisi ivi 7 ere kakawasi kerutinaruwesi. Ma meni ghamoghamosi na ke biibiisi suwara kubiine, ti na puyapuyakisi, na sagosago duma ere kakawasi kerutinisi da ku waka kona rui. ");
INSERT INTO pwg_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Ma kiu kitasi bogii ma bogiiyai keviinisi ina pisi da kiu sago sago duma kii kita nununai tomotomowisi ivi 7 ere kakawasi na keghamosi da yawayawasi ina makamakai da kutukutuva murinai ini tuwame dobuwai. ");
INSERT INTO pwg_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Mara 7 murinai na garewa ana vonatawei da mara 40 ma didibara 40 ina katukatuna da bera kudubina yawayawana dobuwai ayamoni na peyarina ana kiipupunatawei.” ");
INSERT INTO pwg_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Ma vaghina, Nowa ikikava Bada ivonaverei na peyarina ibera yavui. ");
INSERT INTO pwg_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Nowa kana madegha 600 na kutukutuva ivi karei ");
INSERT INTO pwg_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","da kawana yavata, natunatusi, kakawasi yavata na peyarisi irui ku waka da kutukutuva ita veruvuvurei. ");
INSERT INTO pwg_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Ma bade ghamoghamo bogii ma bogiiyai ere kakawasi ku waka irui, ti na puyapuyakisi ma ke puyapuyakisi, kiu ma dowatetetesi yavata. ");
INSERT INTO pwg_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","Tomotomowisi ere kakawasi ipisi Nowa kurina da yavata irui ku waka. God ikikava ivonaverei na iberai. ");
INSERT INTO pwg_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Mara ivi 7 kamonai ivovunagha ikovi na kutukutuva ivi karei dobuwai. ");
INSERT INTO pwg_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Nowa kana madegha 600 ma nawaravi kana viruwa kamonai, mara kana vi 17 na kutukutuva ivi karei. Dowa kamonai vusira peyarina ivi tamobubuwana da okowa irakata. Ma kunuma itamotate da garewa vitana ivi karei. ");
INSERT INTO pwg_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Nakanani ikatukatuna inenae da mara 40 ma didibara 40 ikovi. ");
INSERT INTO pwg_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Garewa ivi karei na Nowa kawana yavata ma natunatusi ivi aroba, ti na Sem, Ham ma Jepeta, kakawasi yavata na peyarisi namada ku waka irui. ");
INSERT INTO pwg_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Ma bade ghamoghamo manamisi ma siya dipa, ghamaghamasi ma gisigisisi, rovorovosi ma dowatetetesi, kiu bogii ma bogiiyai na peyarina ere kakawasi namada irui. ");
INSERT INTO pwg_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Bera kudubina yawayawana dobuwai na ruwaruwi duma ipisi Nowa kurina da waka kamonai. ");
INSERT INTO pwg_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Ma vaghina, ikikava God ivonaverei na Nowa peyarina iberai ikovi. Tomotomowisi ma wivinesi igeru yavu na murinai Bada waka kana matuketa ivopotai. ");
INSERT INTO pwg_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Ma mara 40 kamonai kutukutuva igheghae ma okowa irakarakata ma idoga da waka irutenama. ");
INSERT INTO pwg_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Ma okowa igheghae da idoga kirakai ma wakana na okowa tepanai itenatenama. ");
INSERT INTO pwg_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Igheghae da koya ighegheyana kirakai na kudubina ikamyanumisi. ");
INSERT INTO pwg_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Okowa ighae da 7 mitas koya vovosi ma ku tepana. ");
INSERT INTO pwg_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Ma bera kudubina yawayawana dobuwai ivivi dagudagu na iwapa. Kiu, ghamoghamo manamisi ma siya dipa ma dowatetetesi ma bade wawaya, peyarina na iuma dodo. ");
INSERT INTO pwg_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Bera kudubina yawayawana tano tepanai yasi itawetawei na irabobo. ");
INSERT INTO pwg_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Bada God bera kudubina ikiipupunatawesi da wawaya kegha, ghamoghamo kegha, dowatetetesi kegha ma bade kiu kegha. Ma Nowa ma iyavo kava waka kamonai imakamakai na ti kava ke ita rukwa. ");
INSERT INTO pwg_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Ma okowa dobu itenukutuvi inene da mara 150 ikovi. ");
INSERT INTO pwg_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","God, Nowa ma ghamoghamo peyarisi waka kamonai inotanotisi. Ma yanunu ivonatawei da ivosisina ma okowa ivi karei da iororu. ");
INSERT INTO pwg_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Ma namada dowiyai vusira igudupotapota ma iberai da kunumai garewakatuna ivoterei. ");
INSERT INTO pwg_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Ma okowa na mara 150 kamonai nuwatuwai iororu. ");
INSERT INTO pwg_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Kutukutuva ivi karei inenae da nawaravi miikovi murinai na waka Ararati koyana ku tepana ivi kiikenei. ");
INSERT INTO pwg_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Okowa patana iororu da nawaravi kana vi 10 ina karena na koya vovosi irumatara. ");
INSERT INTO pwg_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Garewa ikatuna ikovi murinai, Nowa ikoyagha da mara 40 ikovi ma waka tarabogina kana gudu ivotawei. ");
INSERT INTO pwg_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","Ma oghogha ivonatawei ikiibau ma ke ita vovira. Irovorovo yawara ma ivivi koyakoyagha da okowa ita mamaghatawei. Ma Nowa, oghogha ikoyagha kavai. ");
INSERT INTO pwg_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Ina kayowana da akova ita viiya da okowa ioru da imapatana, tuna kubiine bade gabubu ivonatawei inae. ");
INSERT INTO pwg_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Ma kegha, okowa patana da dobu ikiimumui da gabubu gawara iekwa kavai da iti yakam. Irovo ivovira ku waka ma Nowa ivororona da iviiya, ma itereruwei ku waka. ");
INSERT INTO pwg_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Ivi koyakoyagha da mara 7 ikovi ma gabubu ivonatawe meyei. ");
INSERT INTO pwg_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Raviyai ivovira kurina ma mutunai na oliv kiina ruguruguna matina ikaratani. Nowa nani ruguruguna ikitai na iakovi da okowa namada ioru kirakai. ");
INSERT INTO pwg_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Ivi koyakoyagha da mara 7 ikovi na gabubu ivonatawe meyei. Ma ke ita vovirame kurina, ine vaghata. ");
INSERT INTO pwg_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Nowa kana madegha 601 ma nani madeghina karenai okowa imamaghatawei. Waka kana tarasovo ivotawei ikitavirevire ma ikitai da dowa ivovokanakana. ");
INSERT INTO pwg_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Ma mara kana vi 27 nawaravi kana viruwa kamonai na dobu kudubina ikanakana tuwanonowa. ");
INSERT INTO pwg_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Vaghina ma God, Nowa ivonei bo, ");
INSERT INTO pwg_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Tam kawam yavata ma natunatum ere kakawasi na waka kokiibutawei. ");
INSERT INTO pwg_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Ma bade ghamoghamo waka kamonai, kiu, ghamoghamo manamisi, siya dipa ma dowatetetesi na peyarina kerutinakiibuwesi. Ina kiibau da ini tuwa ma ina peyari kirakai dobuwai.” ");
INSERT INTO pwg_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Ma vaghina, Nowa kawana yavata ikiibau, ma natunatusi ere kakawasi na peyarisi waka ikiibutawei. ");
INSERT INTO pwg_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Ma bade ghamoghamo manamisi, siya dipa, dowatetetesi ma kiu na peyarina ere kii nevaneva waka ikiibutawei. ");
INSERT INTO pwg_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Nani murinai Nowa wakima ivi daburi da suwara kana kema iyamoni. Ma meni ghamoghamosi ma kiusi Bada ivi vaghinei da suwara kubiine na kamosiyai viya iviinisi ma ivunuwa da suwara kana kema tepanai ikapuna, Bada God kurina isuwara. ");
INSERT INTO pwg_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Bada suwara ghabuna iyoni ma nuwanuwana iviiya ma ivona bo, “Ke meyani dobu animaga meyei wawaya i berabero kubiine. Akovi da gegeyai da i ku rabobo na i nota didibarisi emakamakai. Akovi ma namanaki, ke meyani da bera yavu yawayawana ana kiipupuna meyei. ");
INSERT INTO pwg_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Karako da dobu ku damona na iri atereterei da vao kana mara ma yaba kana mara, nuba kana mara ma muyamuya kana mara, bodu ma kwamra, mara ma didibara, ina nenae da ke meyani ina kovi.” ");
INSERT INTO pwg_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","God, Nowa natunatuna yavata ivi biibiinisi ma ivonesi bo, “Kovi tuwa kirakai da kona peyari da rakarakami dobu ina makii yavui. ");
INSERT INTO pwg_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Ma ghamoghamo dipiyai, kiu kiidamowai, dowatetetesi ma iyana yegiyai na kudubisi ina yabuyabumanemi ma ami rewapana gaburinai ina makamakai. ");
INSERT INTO pwg_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Mara wadobunai kii amame ma vavai dowa kamonai averemi da kami vavai. Ma karako na ghamoghamo, kiu ma iyana bade avereveremi da kami siya. ");
INSERT INTO pwg_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Ma yawasa na tara kamonai, tuna kubiine avonavonatanimi da siya ere tarana ke kona kani. ");
INSERT INTO pwg_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Ma bade meni wawayina ina berai da kwinana tarana ina sororo na ani tupavirei da avi kubiine iberai. Ghamoghamo wawaya ina kiivunui na kana kovogha na rabobo. Ma wawaya kwinana ina kiivunui na bade kana kovogha na rabobo. ");
INSERT INTO pwg_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","‘Wawaya ayamonisi da taku mani maghimaghighiku. Tuna kubiine meni wawayina kwinana ina kiivunui na tuna bade tarana ina sororo, wawaya kana kovogha ina verei da ini raboboi.’ ");
INSERT INTO pwg_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Ma vaghina, tami na kovi tuwa kirakai da kona peyari da rakarakami dobu ina makii yavui.” ");
INSERT INTO pwg_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Nani murinai God, Nowa ma natunatuna ivonesi bo, ");
INSERT INTO pwg_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“Kovi yana, wekarakava Vivaghina Makamakiina tami kurimi atereterei. Tami ma tupurereghimi ");
INSERT INTO pwg_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","ma bera yavu kudubina yawayawana, ghamoghamo manamisi, ghamoghamo dipa ma kiu waka kamonai ikiibau na ");
INSERT INTO pwg_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","peyarimi yavata ma Vivaghina Makamakiina aberaberai. Ke meyani kutukutuva ana vonatawe meyei da bera yavu yawayawana ina rabobo. Ke meyani okowa ina rakata da dobu kudubina ina resotawei.” ");
INSERT INTO pwg_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Ma God ivonesi bo, “Ita Vivaghina Makamakii Nonowina na tami ma tupurereghimi ma bera yavu yawayawana, kimta ma kimta kurimi aberaberai na kana matakira na weni, ");
INSERT INTO pwg_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","aku vurere kwavuwai atereterei. Tuna ini matakira da Vivaghina Makamakiina gwabitiyai emakamakai. ");
INSERT INTO pwg_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Kwavu ana vonatawei ma maranai vurere kwavu kamonai ina nekiibau ana kitai na ");
INSERT INTO pwg_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","ita Vivaghina Makamakiina ana notai da ke meyani kutukutuva ana vonatawe meyei da bera yawayawana kudubina ina kiipupuna meyei. ");
INSERT INTO pwg_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Meni marasiyai vurere ina nenekiibau ana kitakitai na ita Vivaghina Makamakiina taku ma bera yavu yawayawana taberai na ana notai.” ");
INSERT INTO pwg_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Ma vaghina God, Nowa kurina ivona bo, “Ita Vivaghina Makamakiina kana matakira na vurere.” ");
INSERT INTO pwg_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Nowa natunatuna waka ikiibutawei na kii vava Sem, Ham ma Jepeta. (Ma Ham natuna kana vava Keinan.) ");
INSERT INTO pwg_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Weni tomotomowisi ivi aroba tupurereghisi na tota, wawaya kudubita karako dobuwai. ");
INSERT INTO pwg_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Nowa tuna wayowa wawayina ma ina vao kamonai na greipi ivoni. Muriyai greipi amesi iyuna da wain iyamoni. ");
INSERT INTO pwg_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Mara sago wain iumai da ineghanegha ma yobe kamonai iyuna kava ikenakena. ");
INSERT INTO pwg_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Ma natuna Ham irugenara da ina mamai iyuna kava ikenakena ikitai na inae da Sem ma Jepeta ivonesi. ");
INSERT INTO pwg_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Ma ivi ruwa ivi nimaya na gara iviini da kuputuwasiyai itawanepai, visovo gubana. Ivi murititina ku yobe irui da i mamai ikiisovoi. Matasi ku boga ikitakita da i mamai iyuna kava ke ita kitai. ");
INSERT INTO pwg_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Muriyai Nowa gayamina ivi kiimaniniyei na akova iviiya da natuna murimurina Ham ibera beroi, ina mamai ke ita vopepetei. ");
INSERT INTO pwg_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","Tuna kubiine Nowa ivona bo, “Keinan, aimimagim! Karako tam na varevaresim i wayowa kana kavakavara.” ");
INSERT INTO pwg_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Ma Sem da Jepeta ivi biibiinisi ma ivona bo, “Bada avokavakavari, tuna Sem ina God! Karako Sem ina wayowa kana kavakavara na Keinan. ");
INSERT INTO pwg_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Ma ainowi God kurina da Jepeta ina rakaraka ina peyari da dobu ghamana ini rapenei, ma Sem ina rakaraka yavata ina makii patapata. Ma bade Jepeta ina wayowa kana kavakavara na Keinan.” ");
INSERT INTO pwg_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Ma vaghina, kutukutuva murinai Nowa madegha 350 ku tepana imakai. ");
INSERT INTO pwg_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Kana madegha 950 ma irabobo. ");
INSERT INTO pwg_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Weni tuna na Nowa natunatuna Sem, Ham ma Jepeta i varagutugutu. Kutukutuva murinai ivi tuwa da kii vava na weni. ");
INSERT INTO pwg_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Jepeta natunatuna na Goma, Magogi, Madai, Javan, Tubal, Meseki ma Tiras. ");
INSERT INTO pwg_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Ma Goma natunatuna na Askenas, Ripati ma Togama. ");
INSERT INTO pwg_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Ma Javan natunatuna na Elisa, Tasis, Kiti damsi ma Rodan damsi. ");
INSERT INTO pwg_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Ma tupurereghisi inae da kikira barabarasiyai imakai, ti na kukakuka damsi. Kii dam nununai imakamakai da i dobu, i gamo ma i rakaraka na bogii ma bogiiyai. ");
INSERT INTO pwg_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Ma Ham natunatuna na Kus, Misraim, Puti, ma Keinan. ");
INSERT INTO pwg_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Ma Kus natunatuna na Seba, Havila, Sabata, Rama ma Sabateka. Ma Rama natunatuna na Seba ma Dedan. ");
INSERT INTO pwg_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Kus tupurereghina sago na Nimrodi, tuna imagura da ivi rewapana kirakai. Tuna wawaya ghamana dobuwai, iyo wawayina. ");
INSERT INTO pwg_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Rewapana Bada gwabinai iviiya da tuna na yebagha bogana. Tuna kubiine meni wawayina ita yebagha bubuna na turaturana ita vona bo, “Tam na yebagha bogam Nimrodi nakanani.” ");
INSERT INTO pwg_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Nimrodi ivi kiivavo Babilon dobuna kamonai. (Babilon kana vava sago na Sina.) Nani dobunai kwanatu ruwamaruwa ivi karei. Ti na Babilon, Eregi, Akadi ma Kalne. ");
INSERT INTO pwg_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Babilon dobuna kudubina ivi bada yavui na ivomiiri inae ku Asiriya dobuna da kwanatu ruwamaruwa iyamoni, kii vava na Nineva, Reyobot Ire, Kala ");
INSERT INTO pwg_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","ma Resen. (Resen na kwanatu ghamana Nineva ma Kala basusiyai.) ");
INSERT INTO pwg_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Misraim tupurereghina na Ludim damsi, Anam damsi, Leyaba damsi, Napetu damsi, ");
INSERT INTO pwg_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","Paterus damsi, Kapeto damsi ma Kaslu damsi (ti na Pilisti damsi i kaekiki). ");
INSERT INTO pwg_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Keinan natuna iyarokona na Saidon, tuna na Saidon damsi i kaekiki. ");
INSERT INTO pwg_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","Ma Keinan na bade Hiti damsi, Jebu damsi, Amor damsi, Giraga damsi, ");
INSERT INTO pwg_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","Hivi damsi, Araki damsi ma Sini damsi, ");
INSERT INTO pwg_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","Avadi damsi, Semari damsi ma Hama damsi na kudubisi i kaekiki. Muriyai Keinan tupurereghina ikiibau da i dobu irakata. ");
INSERT INTO pwg_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","I dobu kana parata na Saidon da inae ku Gera ma Gasa da ku Sodom, Gomora, Adma ma Sebowim, ma bade ku Lasa. ");
INSERT INTO pwg_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Ma vaghina, nani damsi na Ham tupurereghina ma kii dam nununai ivivi makiiyana, i dobu, i rakaraka ma i gamo bogii ma bogiiyai. ");
INSERT INTO pwg_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Jepeta tina kikei na Sem, ma Sem na Eba tupurereghina kudubisi i kaekiki. ");
INSERT INTO pwg_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Sem natunatuna na Elam, Asuru, Apakisadi, Ludi ma Aram. ");
INSERT INTO pwg_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Ma Aram natunatuna na Usi, Hul, Getere ma Meseki. ");
INSERT INTO pwg_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Apakisadi natuna na Sela ma Sela natuna na Eba. ");
INSERT INTO pwg_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Eba ivi tuwa da natunatuna ruwa. Iyarokona kana vava ‘Pelegi,’ iyamna tuna ina mariyai wawaya ivi karei da dobu iyaraghi. Ma Eba natuna murimurina kana vava Jokatan. ");
INSERT INTO pwg_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Ma Jokatan natunatuna na Arumodadi, Selepi, Hasa Maveta, Jera, ");
INSERT INTO pwg_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Hadoram, Usal, Dikala, ");
INSERT INTO pwg_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Obal, Abimeyal, Seba, ");
INSERT INTO pwg_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Opiri, Havila ma Jobabi. Weni damsi kudubisi na Jokatan natunatuna. ");
INSERT INTO pwg_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Ma i dobu na Mesa dobunai ivi karei da ku Sepa dobuna, tuna na koya kamosiyai. Nani koyasi na maramatana ina ku nevaneva. ");
INSERT INTO pwg_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Ma vaghina, nani damsi na Sem tupurereghina ma kii dam nununai ivivi makiiyana, i dobu, i rakaraka ma i gamo na bogii ma bogiiyai. ");
INSERT INTO pwg_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Ma vaghina, nani wawayisi kudubisi na Nowa natunatuna ma tupurereghisi, kii dam nununai. Kutukutuva murinai na kamosiyai dam ma dam ikiibau da dobu kudubina imakii yavui. ");
INSERT INTO pwg_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Karenai dobu kudubina kamonai wawaya peyarisi i gamo ma i sisiya na sago. ");
INSERT INTO pwg_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Ma wawaya viya ibaba inae ku warere sago maramatanai ma nani dobunai ivivi makiiyana. Dobuna kana vava Babilon. ");
INSERT INTO pwg_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Ma dughu kamonai ivona bo, “Tanae, dobodobo tavopasipasi ma takapuna da ina pakora, ini wakima.” Nani dobunai wakima vaghata kegha, tuna kubiine dobodobo pakorisi itura numa vowana kubiine. Ma bade pasi dumadumana gwabisiyai da dobodobo wakimisi ita pasitatana. ");
INSERT INTO pwg_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Ma nani murinai ivona bo, “Tanae, kwanatu ghamana tayamoni ma kamonai na numa sago gurina tavowai ina ghae ku kunuma. Nakanani taberai da kata vava ina rakata ma ke meyani tibogebogeta ku dobu bogii ma bogiiyai.” ");
INSERT INTO pwg_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Ma kegha, Bada ioru da ita rugenarisi, kwanatuna ma numa gurina iyamoyamoni na ita kitai. ");
INSERT INTO pwg_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Ma ivona bo, “Weni damsi gamo sago kava isisiya da ivi sagosi. Ma weni berana ivi karei da eberaberai na karakava kesago aviyavisina ina tarapotesi. ");
INSERT INTO pwg_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Toru da weni wawayisi i gamo tavirai da ke kovokovoghina ini akovavivirana.” ");
INSERT INTO pwg_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Vaghina ma Bada ikiivisawarisi da Babilon ikiibutawei inae da dobu ine yavui. Ma kwanatuna iyamoyamoni na ivoterei. ");
INSERT INTO pwg_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Nani kwanatunai ivi notaragharaghisi da gamo bogii ma bogiiyai ivivi sisiya, tuna kubiine kana vava vuna na ‘Babel.’ Ma wawayisi ikiivisawarisi da ivi bogebogesi inae da dobu bogii ma bogiiyai imakii yavui. ");
INSERT INTO pwg_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Sem tupurereghina na weni. Kutukutuva murinai madegha ruwa ikovi na Sem kana madegha 100. Ma ivi tuwa da natuna Apakisadi. ");
INSERT INTO pwg_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Murinai na madegha 500 ku tepana imakai. Ma kamonai na natunatuna viya, tomotomowisi ma wivinesi itupuwa. ");
INSERT INTO pwg_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Ma Apakisadi kana madegha 35 na ivi tuwa da natuna tomowa. Ma ivi vavei Sela. ");
INSERT INTO pwg_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Ma tuna murinai na madegha 403 ku tepana imakai. Ma kamonai na natunatuna viya, tomotomowisi ma wivinesi itupuwa. ");
INSERT INTO pwg_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Sela kana madegha 30 na ivi tuwa da natuna tomowa, ma ivi vavei Eba. ");
INSERT INTO pwg_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Ma tuna murinai na madegha 403 ku tepana imakai. Ma kamonai na natunatuna viya, tomotomowisi ma wivinesi itupuwa. ");
INSERT INTO pwg_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Ma Eba kana madegha 34 na ivi tuwa da natuna tomowa, ivi vavei Pelegi. ");
INSERT INTO pwg_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Ma tuna murinai na madegha 430 ku tepana imakai. Ma kamonai na natunatuna viya, tomotomowisi ma wivinesi itupuwa. ");
INSERT INTO pwg_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Ma Pelegi kana madegha 30 na ivi tuwa da natuna tomowa, ivi vavei Reyu. ");
INSERT INTO pwg_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Ma tuna murinai na madegha 209 ku tepana imakai. Ma kamonai na natunatuna viya, tomotomowisi ma wivinesi itupuwa. ");
INSERT INTO pwg_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Ma Reyu imakai da kana madegha 32 na ivi tuwa da natuna tomowa, ma ivi vavei Serugi. ");
INSERT INTO pwg_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Ma tuna murinai na madegha 207 ku tepana imakai. Ma kamonai na natunatuna viya, tomotomowisi ma wivinesi itupuwa. ");
INSERT INTO pwg_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Ma Serugi imakai da kana madegha 30 ma ivi tuwa da natuna tomowa. Ma ivi vavei Nayo. ");
INSERT INTO pwg_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Ma tuna murinai madegha 200 ku tepana imakai. Ma kamonai na natunatuna viya, tomotomowisi ma wivinesi itupuwa. ");
INSERT INTO pwg_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Ma Nayo imakai da kana madegha 29 na ivi tuwa da natuna tomowa. Ma ivi vavei Tera. ");
INSERT INTO pwg_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Ma tuna murinai na madegha 119 ku tepana imakai. Ma kamonai na natunatuna viya, tomotomowisi ma wivinesi itupuwa. ");
INSERT INTO pwg_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Tera kana madegha 70 muriyai na ivi tuwa da natunatuna Abram, Nayo ma Haran. ");
INSERT INTO pwg_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Ma ina rakaraka i varagutugutu na weni. Haran ivi tuwa da natuna tomowa kana vava na Lot. ");
INSERT INTO pwg_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Ma Haran ina mamai Tera na patana da yawayawana imakamakai ma Haran irabobo, Uru kwanatunai. Kwanatuna na Kaldiya damsi i dobu kamonai, ma nani dobunai itupuwa. ");
INSERT INTO pwg_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Ma bade Abram ma Nayo wivine ipanana da itavine. Nayo kawana na Milka. Milka ma tina kikei Iska ivi ruwa i mamai na Haran. Ma Abram kawana na Serai. ");
INSERT INTO pwg_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Tuna wavinena na gagarina, ke iti tuwa. ");
INSERT INTO pwg_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Mara sago Tera ina rakaraka irutinisi da Uru dobuna ikiibutawei. Natuna Abram kawana Serai yavata ma tupuna Lot (tuna ina mamai na Haran) na peyarisi iviinisi da ita nae ku Keinan dobuna. Ma keta borinai ku Haran kwanatuna inekiibau na nani dobunai imakii kirakai. ");
INSERT INTO pwg_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Tera imakai da kana madegha 205 ma Haran kwanatuna kamonai irabobo. ");
INSERT INTO pwg_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Bada ivi sisiya, Abram kurina ivona bo, “Am dobu kekuyowei, am dam ma am mamai ina rakaraka kekuyowesi ma kenae da ku dobu sago ani beyem nake. ");
INSERT INTO pwg_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Ana berim da tupurereghim ina peyari da am dam ina rakata. Ani biibiinim, ma ana berai da kam vava ina rakata kirakai. Aku vibiibiina gwabimuwai ina makai, tam tepamuwai da wawaya nani vibiibiinina ina viiya. ");
INSERT INTO pwg_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Iyavo kava ini biibiinim na ani biibiinisi ma iyavo kava inimagim na animagisi. Tam tepamuwai da dam ma dam kudubina dobuwai ani biibiinisi.” ");
INSERT INTO pwg_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Vaghina ma, Abram kana madegha 75 na Haran dobuna ikiibutawei inae natuna kikei Lot yavata, Bada ikikava ivonavonei na iberai. ");
INSERT INTO pwg_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Kawana Serai ma natuna kikei Lot yavata inae. Ma bade i ghamoghamo, i mura kudubina ma i bigabiga wawayisi, ti na iyavo kava Haran kamonai ivivi vitesi na yavata ivomiiri da Haran ikiibutawei inae ku Keinan dobuna. Inekiibau ma ");
INSERT INTO pwg_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Abram ina wawaya yavata Keinan dobuna kamonai ibaba inae da ku Sekem kwanatuna. (Tuna maranai na Keinan damsi patana da ivivi makiiyana.) Ma Sekem ririnai na kii sago ghamana imiimiiri ivi matakira da gawara vovokaravina, kana vava More. ");
INSERT INTO pwg_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Ma nani dobunai Bada inekiibau Abram kurina ma ivonei bo, “Weni dobuna na tupurereghim ana veresi.” Tuna kubiine Abram wakima ivi daburi da suwara kana kema iyamoni ma nani dobunai Bada ivokavakavari. ");
INSERT INTO pwg_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Vaghina ma, ivomiiri inae ku koya nuwasi da nake Betel kwanatuna ma wike ku maramatana na Ayi kwanatuna ma basunai na ina yobe ivowai. Ma bade suwara kana kema sago iyamoni da Bada ivovokavakavari. ");
INSERT INTO pwg_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Muriyai Abram ivomiiri ibababa, gawara bogii ma bogiiyai imakii inenae da ku Negev dobuna inekiibau. ");
INSERT INTO pwg_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Mara sago Keinan dobunai gomara itupuwa. Ma gomara irakata kubiine, Abram inae ku Egypt da ita makai mara gisina. ");
INSERT INTO pwg_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Ma muriyai da parata ita damani ku Egypt ita rui na kawana ivonei bo, “Kuvi karawata kirakai. ");
INSERT INTO pwg_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Egypt damsi ina kitim na ina kayowem ma ina vona bo, ‘Kawana kubiine takiivunui ma wavinena tarutini.’ ");
INSERT INTO pwg_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Tuna kubiine kevonesi da tam na novuku. Nakanani kuni sisiya na ke ina kiivunuku ma ina koyagha bubuniku.” ");
INSERT INTO pwg_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Vaghina ma, Abram ina wawaya yavata ku Egypt inekiibau. Ma Egypt damsi Serai ikitai da ivi karawata kirakai. ");
INSERT INTO pwg_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Ma bade kiivavo Pero ina wawaya ghamaghamasi na wavinena ikitai, ma inae ivonei da wavine sago karawatina ipanani. Vaghina ma, Serai irutinaneyei ina ku numa ghamana. ");
INSERT INTO pwg_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Ma Serai irutini kubiine na Abram ikoyagha bubuni, kana puyo na sipu, gote, kau, donki ma kamel yavoyavosi iverei, ma bade bigabiga tomotomowisi ma wivinesi yavata. ");
INSERT INTO pwg_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Ma ke mara gurina na Pero ina wawaya yavata igubaga. Abram kawana irutini kubiine na Bada gubaga beroberosi iveresi. ");
INSERT INTO pwg_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Tuna kubiine Pero, Abram kana sisiya ivonatawei da ipisi. Ma ivonei bo, “Avi kubiine weni berana kuberai kuriku? Kade kuta voneku da tuna na kawam. ");
INSERT INTO pwg_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Avi kubiine kuvona da tuna na novum? Am sisiya kubiine arutini da aravaghi. Vaghina, wavinena weni. Kerutini ma konae.” ");
INSERT INTO pwg_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Ma Pero ina bigabiga wawayisi sisiya bagibagina iveresi da Abram kawana yavata ivonatawesi inae. Ivomiiri na i mura ma i bera kudubina iviiya ma Egypt dobuna ikiibutawei inae. ");
INSERT INTO pwg_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Abram na Egypt ikiibutawei inae ku Negev dobuna, kawana ma ina mura kudubina yavata. Ma natuna kikei Lot na yavata inae. ");
INSERT INTO pwg_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Ma Abram tuna tomowa mumurina, ina ghamoghamo yavoyavosi ipeyari, ina silva ma ina gold yavata. ");
INSERT INTO pwg_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Muriyai Negev ikuyowei da ibababa, gawara bogii ma bogiiyai imakai inenae da ku Betel kwanatuna. Ma ivovirame nani ku gawarina Betel kwanatuna ma Ai kwanatuna basunai, rorova imapatana i yobe itina na nani ku gharavuna inekiibau. ");
INSERT INTO pwg_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","Nani gawarinai na namada suwara kana kema iyamoni imakamakai. Inekiibau na Bada ivokavakavari. ");
INSERT INTO pwg_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Ma Lot na Abram yavata mara nonowa ibababa ma tuna ina rakaraka, i yobe ma bade ina ghamoghamo yavoyavosi ipeyari. ");
INSERT INTO pwg_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Tuna kubiine tano ke ruvaruvana da ivi ruwa i ghamoghamo yavoyavosi na gawara sago kava ita makai da ita kam. Ipeyari kirakai. ");
INSERT INTO pwg_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Ke mara gurina na Abram ina ghamoghamo kii koyakoyagha ma Lot ina ghamoghamo kii koyakoyagha vikawapata ivi karei. Ma bade Keinan damsi ma Perusa damsi i ghamoghamo yavata patana da ivivi makiiyana nani dobunai. ");
INSERT INTO pwg_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Vaghina ma Abram, Lot ivonei bo, “Tota na rakaraka sago. Tuna kubiine ke vaghina da tam ma taku kamoputiyai vikawapata ina makai. Ke ita biibai da am bigabiga ma aku bigabiga weni nakanani ini kawapata. ");
INSERT INTO pwg_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Kekitai, dobu irakata. Kade kovokovowina bo kegha da kati bogebogeta? Meni tanona kuna kayokayowei na keviiya. Ma meni tuna kuna vovoterei na taku ana viiya. Ku katagheyam kuna nenae na taku ku dugem ana nae. Ma ku dugem kuna nenae na taku ku katagheyam ana nae.” ");
INSERT INTO pwg_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Ma Lot ikitataweyana da Jodan okowina gonuna ikitai ma matana ivi babai da ku Sowa kwanatuna. Ikita da nani dobunai okowa ghamana da tano ivivi novuri. Ibiibii kirakai nakanani ma Bada ina vao bo nakanani ma Egypt dobuna. (Sodom ma Gomora kwanatusi na nani dobuna kamonai. Mara karakava epipisi da Bada nani kwanatusi ina resotawei.) ");
INSERT INTO pwg_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Vaghina ma Lot, Jodan gonuna kudubina ivinei da tuna ina tano. Ma ivomiiri da koyiyai ioru da ku maramatana. Ma vaghina, Abram da Lot weni nakanani ivi bogebogesi. ");
INSERT INTO pwg_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Abram, tuna Keinan dobuna kamonai imakamakai. Ma Lot na Jodan gonuna kwanatusi ririsiyai imakamakai, i yobe na Sodom kwanatuna ririnai itina. ");
INSERT INTO pwg_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Ma Sodom damsi na kawakiikiisi ma berabero wawayisi Bada ku matana. ");
INSERT INTO pwg_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Lot inae ma muriyai Bada ivi sisiya Abram kurina, ivona bo, “Wekarakava weni dobunai kemakamakai na ketepa ma kekitavirevire da dobu kudubina kekita yavui. ");
INSERT INTO pwg_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Weni dobuna kekitakitai na kudubina tam, tupurereghim yavata ana veremi da koni rapenei ma ke meyani koni wapai. ");
INSERT INTO pwg_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Ma ana berai da tupurereghim ina peyari kirakai da nakanani ma popoku. Ikikava wawaya ke kovokovoghina da popoku ini yavi na nakanani tupurereghim ini yava kavakavisi. ");
INSERT INTO pwg_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Weni dobuna ana veremi da tami rapemiyai, tuna kubiine kevomiiri da dobu kudubina kuna ne yavui.” ");
INSERT INTO pwg_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Vaghina ma Abram ina wawaya yavata i yobe irika ma inae. Ibaba da ku Hibron dobuna ma nani dobunai imakai. Hibron kamonai na kwanatu sago kana vava Mamre, ma ririnai na kii viya ivivi miimiiriyana, ivi matakira da tuna na gawara vovokaravina. Kiisi ririsiyai i yobe itina da imakai ma Abram suwara kana kema sago iyamoni da Bada ivovokavakavari. ");
INSERT INTO pwg_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Nani maranai kiikiivavo viya vighaviya ivi karei. Kiikiivavo ruwamaruwa imakamakai, ti na Babilon dobuna kana kiivavo Amarapel, Elasa dobuna kana kiivavo Ariyoki, Elam dobuna kana kiivavo Kedolama ma Goyim dobuna kana kiivavo Tidal. ");
INSERT INTO pwg_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","Ti damsi ivomiiri inae kiikiivavo ivi miikovi kurisi da iti ghaviya. Ma kiikiivavosi ivi miikovi na Sodom kana kiivavo Bera, Gomora kana kiivavo Bisa, Adma kana kiivavo Sinab, Sebowim kana kiivavo Semeba, ma Bela kana kiivavo. (Bela dobuna kana vava sago na Sowa). ");
INSERT INTO pwg_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Ma anagha sago kana vava Sidim (karako na kana vava Toka Yegayegina anaghina) na nani anaghinai kiikiivavosi ivi miikovi na vivaghina iberai da i iyo wawayisi itarakapu da koroto ghamana. ");
INSERT INTO pwg_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Ti na kiivavo Kedorayome ina vibadana ibarei, tuna kubiine i iyo wawayisi ivi sagosi. Madegha 12 ivivi badesi ma madegha kana vi 13 na i kayowana da ina vibadana ita kutawei. ");
INSERT INTO pwg_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Ma madegha kana vi 14 na Kedolama ma kiikiivavo turaturana yavata itarakapu da i iyo wawayisi yavata namada inae da dam bogii ma bogiiyai yavata ivi ghaviya. Ivomiiri inae da ku dobu sago kana vava Asteroti Kanaim da Repati damsi ighegavovorisi. Ma inae ku dobu kana vava Ham, da Susa damsi ighegavovorisi, ma muriyai inae ku Save Kiriyataim dobuna da Ema damsi ighegavovorisi, ");
INSERT INTO pwg_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","ma bade inae da Hora damsi ighegavovorisi, i dobu na koya nuwasiyai, dobuna kana vava Seya inene da ku dobu sago kana vava El Paran, tuna na warere ririnai. ");
INSERT INTO pwg_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Ma ivovovira da keta borinai inae ku En Misipati (Karako dobuna kana vava Kades). Ma Amaleki damsi nani dobunai ighegavovorisi da i dobu kudubina ivi badei. Ma bade Amon damsi ighegavovorisi, ti na Hasason Tama dobunai. ");
INSERT INTO pwg_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Nani murinai kiikiivavosi ivi miikovi Sidim anaghinai ivovunagha da i iyo wawayisi taraboga nununai iteresi da Kedolama yavata iti ghaviya. (Ti na i dobu na Sodom, Gomora, Adma, Sebowim ma Bela, tuna dobuna kana vava sago na Sowa). ");
INSERT INTO pwg_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","Ma nani kiikiivavosi ivi miikovi na kiikiivavo ruwamaruwa kurisi ivivi ghaviya. Ma ivi ruwamaruwa, ti na Elam dobuna kana kiivavo Kedolama, Goyim dobuna kana kiivavo Tidal, Sinare dobuna kana kiivavo Amarapel, ma Elasa dobuna kana kiivavo Ariyoki. ");
INSERT INTO pwg_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Ma Sidim anaghinai na bonagha viya kamonai dobodobo karapasipasisi imakamakai. Vighaviya kamonai Sodom da Gomora damsi i kiikiivavo yavata iverutaweyana na nevanevana bonagha ku kamosi iririgha da irukwa. Ma nevanevana iverau da ku koya. ");
INSERT INTO pwg_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Vaghina ma, nani kiikiivavosi ruwamaruwa na Sodom ma Gomora damsi ighegavovorisi ma i mura kudubina iviitawei, kii vavai peyarina ikavara yavui ma ivomiiri i ku dobu. ");
INSERT INTO pwg_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Ma Abram natuna kikei Lot na Sodom kwanatunai imakamakai, tuna kubiine vighaviya kamonai kiikiivavosi Lot ipaniya ma ina mura kudubina ikavara yavui. ");
INSERT INTO pwg_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Ma tomowa sago ionagha inae Hibru tomowa Abram kurina da aviyavisina itupuwa na ivi mamatarei. Ma nani maranai Abram ina wawaya yavata i yobe na kii ghamaghamasi rogunai itina da imakamakai. Ma nani kiisi na Amo tomowa kana vava Mamre rapenai, tuna na Abram kwinana. Ma titina yoghoyogho Eskol ma Ane na ti bade na Abram turaturana. ");
INSERT INTO pwg_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Abram sisiya ivi yanei da natuna kikei ipaniya na iyavo kava i bigabiga wawayisi kamosiyai ghaviya kana keta iakovi na ikwaturiyariyesi. Tomotomowa ivi 318 ipisi, viya na Abram ina rakaraka kamonai itupuwa ma imagura. Vaghina ma ivomiiri da nani kiikiivavosi ruwamaruwa iverukivinisi inae da ku dobu kana vava Dan inekiibau. ");
INSERT INTO pwg_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Ma Abram ina ghaviya wawayisi ivorereghisi da koroto bogii ma bogiiyai ma didibara rogunai iravisi da ighegavovorisi. Ma ikwavinisi da ku Hoba, Damaskas kwanatuna ku nevanevana. ");
INSERT INTO pwg_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Ma mura kudubina ivii meyei ma iyavo kava nani kiikiivavosi ruwamaruwa ipanisi, tomotomowa ma wivine na peyarisi irutinisi da yavata ivovira. Nani kamonai natuna kikei Lot, ina wawaya ma ina mura yavata. ");
INSERT INTO pwg_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Abram na kiivavo Kedolama ma kiikiivavo turaturana yavata ighegavovorisi ikovi ma ivovovira da ku Save anaghina inekiibau. (Anaghina kana vava sago na ‘Kiivavo Ina Anagha.’) Nani dobunai Sodom kwanatuna kana kiivavo Abram iverupotei. ");
INSERT INTO pwg_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Ma bade Salem kwanatuna kana kiivavo Melkisedeki parawa da wain ikavarapiyei. Tuna na God Kiidamo Makamakiina ina suwara kapuna badana. ");
INSERT INTO pwg_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Ma Abram kurina ivona bo, “God Kiidamo Makamakiina kunuma ma dobu iyamoni. Ma ainowi kurina da ini biibiinim. ");
INSERT INTO pwg_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Rewapana iverem da kam ghavighaviya kughegavovorisi. Tuna kubiine tighegheni.” Ma Abram nani murina kudubina Kedolama gwabinai iviiya na ivorereghi da riba imaruwa ma sago ivotawei da Melkisedeki kana reregha ma iverei. ");
INSERT INTO pwg_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Ma Sodom kana kiivavo Abram ivonei bo, “Aku wawaya kava kevere meyeku ma mura peyarina na kevotani da kevi rapenei.” ");
INSERT INTO pwg_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Ma Abram mura ibarei. Ivona bo, “Bada God Kiidamo Makamakiina kunuma ma dobu iyamoni. Ma tuna maghinonai aku vonakiiyapa bagibagina atereterei ");
INSERT INTO pwg_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","da ke sago aviyavisina rapemuwai ana votani. Ke avi yoghoyoghona sago bo kae kana terepapara uravina ana kavari. Ata kavari na muriyai kuta vona bo, ‘Abram ina mura na taku averei.’ ");
INSERT INTO pwg_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Taku na ke sago aviyavisina ana viiya ma aviyavisina aku ghaviya wawayisi namada ikani na aivaghinei. Ma turaturaku Ane, Eskol ma Mamre yavata kanae, tuna kubiine aivaghinei da ti kii reregha na ina viiya.” ");
INSERT INTO pwg_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Nani murinai Abram, Bada mekeyuna ikitai da kurina ivivi sisiya, ivonei bo, “Abram, kam papara ana vowai. Tuna kubiine ke kuna yabumana. Ma am miiya ghamanakina ana verem.” ");
INSERT INTO pwg_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Ma Abram ivonapotei bo, “O Bada, bera kudubina na tam kibadei. Miiya ghamana kuta vereku na iyamna kegha. Taku na gagariku, natuku kegha. Tuna kubiine ana rabobo na aku bigabiga tomowina mura kudubina rapekuwai ina viiya. Tuna na Damaskas tomowa Eliyesa.” ");
INSERT INTO pwg_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Ma bade ivona meyei, “Kevi yana. Kesago natuku sago kuta vereku, tuna kubiine bigabiga wawayina aku mura ina viiya da ina buderi.” ");
INSERT INTO pwg_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Vaghina ma Bada ivi sisiyame, ivona bo, “Kegha. Nani bigabiga wawayina am mura ke ini rapenei. Tam mani natum vaghata am mura ina viiya da ina buderi.” ");
INSERT INTO pwg_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Ma irutini ikiibau ku matara ma ivonei bo, “Ketepa ku kunuma da gwamegwame kuni yava tovoni. Kegha, ke kovokovoghina.” Vaghina ma, ivonei bo, “Tupurereghim ina peyari da gwamegwame nakanani.” ");
INSERT INTO pwg_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Ma Abram ivi tumaghana da Bada ina sisiya na vonavaghata. Ma Bada God ikitai da Abram ina vitumaghana irakata, tuna kubiine ivi nuwabiibiiyei ma ivonakiiyaragha da Abram na ina wawaya maninina. ");
INSERT INTO pwg_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Ma bade Abram kurina ivona bo, “Taku na Bada. Taku arutinim da Kaldiya damsi i kwanatu Uru kukiibutawei ma kupisi wike. Ma weni dobuna ana verem da kuni rapenei.” ");
INSERT INTO pwg_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Ma Abram ivona bo, “O Bada, bera kudubina na tam kibadei. Ma kade, matakira kuta vereku da atakovi da weni dobuna ani rapenei.” ");
INSERT INTO pwg_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Vaghina ma Bada God ivona bo, “Kau wavinena sago, gote sago, ma sipu tomowina sago, ivi aroba kii madegha aroba na peyarisi kerutinapiyesi. Ma yavata na gabubu sago ma kughukughu sago kekavarapiyei.” ");
INSERT INTO pwg_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Abram ghamoghamosi ipiyei Bada God kurina na ivi kiivunuwana ma tupuwisi ivi tarasepiyana. Sago sago duma basunai itarasepini da kii nevaneviiyai irereghisi. Ma kiusi na kudukudubisi itura, ke iti tarasepiyana. ");
INSERT INTO pwg_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Ma siya kamkam kiusi viya ipisi da ghamoghamo viyosi ita kam ma Abram ikwavinisi da inae. ");
INSERT INTO pwg_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Ravi ipika na Abram matana ikiikovowi da ikenanunuwapa ma nubakutuva ghamana itinariyai. Ma yabumana damina iviiya da ininina ogariri igheyei. ");
INSERT INTO pwg_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Ma Bada God ivi sisiya kurina, ivona bo, “Vonavaghata ana vonem. Mara karakava epipisi da tupurereghim ini numataya, dobu viruwai ina makii kirakai da madegha 400 ina kovi. Ma nani kamonai nokoni dobuna wawayisi tupurereghim ini kayonogenogeyanesi da ini kamyuyuwa. Ini sleiv, biga vitana ina beraberai ma miiyiina kegha. ");
INSERT INTO pwg_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Ma muriyai, iyavo kava tupurereghim ini kayonogenogeyanesi na kii kovogha ana veresi. Ma tupurereghim dobuna ina kiibutawei na mura ghamana ina kavari ina nae. ");
INSERT INTO pwg_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Ma tam na am yawasa dobuwai ina guri kirakai ma nuwanubiiyai kuna rabobo da ina dogom. ");
INSERT INTO pwg_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Ma Amo damsi ana voteresi weni dobunai ina makai da i bera beroberosi ina rakata kamowa na muriyai kovogha ana veresi. Ma tupurereghim na kimta ruwamaruwa ina kovi ma nani murinai ina vovirame wike.” ");
INSERT INTO pwg_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Madegha ioru ma ivi didibari. Vaghina ma, Abram ikita da bayawa sago ikitai ma kamonai keyama ikarakarata ma ibubau. Ma bade kibe ere yebayebarina irumatara da ghamoghamo tarasepisepisi basusiyai ikarata inae. ");
INSERT INTO pwg_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Ma nani maranai Bada vivaghina makamakiina iberai Abram yavata. Ivona bo, “Weni dobuna na tupurereghim ana veresi, i tano paratina na Egypt okowina da ku Yuperetis okowina. ");
INSERT INTO pwg_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","Nani kamonai na Kena damsi i tano, Kenisi damsi i tano, Kadimo damsi i tano, ");
INSERT INTO pwg_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","Hiti damsi i tano, Peru damsi i tano, Repa damsi i tano, ");
INSERT INTO pwg_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","Amo damsi i tano, Keinan damsi i tano, Giraga damsi i tano ma bade Jebu damsi i tano na kudubina tupurereghim ana veresi.” ");
INSERT INTO pwg_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Abram kawana Serai na gagarina, ma ina bigabiga wavinena na Egypt wawaya kana vava Heiga. ");
INSERT INTO pwg_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Mara sago Serai inae Abram kurina ma ivona bo, “Bada ivi tarapaparaneku da ke ati tuwa. Kade aku bigabiga wavinena yavata kota kena da iti tuwa. Ini tuwa na natuna ana viini da tuna tepanai aku ribiribi ina tupuwa.” Abram ivi vaghinei. ");
INSERT INTO pwg_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Tuna kubiine Serai ina bigabiga wavinena Heiga irutini ineyei Abram kurina da iti kawanei. Ti na Keinan dobunai imakamakai da madegha 10 ikovi ma muriyai weni berana itupuwa. ");
INSERT INTO pwg_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Ivi kawanei na Heiga damina iviiya da iropeya. Ma ivi karei da ikayokayotata ma Serai ikitakitaoruwei. ");
INSERT INTO pwg_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Vaghina ma Serai, Abram ivonei bo, “Tam kubera beroi da Heiga ekayokayotata. Taku mani nani wavinena ku imam aterei, ma karako na iakova meyei da iropeya na ekitakitoruweku. Ainowi Bada kurina da weni nuwapoyina ini maninini. Ma iyi ti wavui?” ");
INSERT INTO pwg_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Ma Abram ivonapotei bo, “Kevi yana, wavinena na tam am bigabiga, tuna na am rewapana gaburinai da kuni badei. Am kayowanai keberai kurina.” Nani murinai Serai ivi karei da Heiga ivivi tupaketowanei, tuna kubiine iverau. ");
INSERT INTO pwg_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Iverau da ku vusira sago warereyai, nani vusirina na keta enenae ku Sura kwanatuna na baranai. Ma Bada ina aneya inekiibau kurina. ");
INSERT INTO pwg_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Ivona bo, “Heiga, tam Serai ina bigabiga wavinem, mimei kupisi ma mike kenenae?” Ma ivonapotei bo, “Aku bada wavinena ivivi tupaketowaneku na averau.” ");
INSERT INTO pwg_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Ma Bada ina aneya ivonei bo, “Kevovirame am bada wavinena kurina ma kevotekatekei.” ");
INSERT INTO pwg_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Ma aneyina ina sisiya ikwapanatini da ivona bo, “Ana berim da tupurereghim ina peyari kirakai da ke ruvaruvana da wawaya ini yavisi.” ");
INSERT INTO pwg_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Ma ku tepana ivona bo, “Kuni tuwa da natum tomowa ma kuni vavei Ismayel, iyamna Bada sisiya ivi yanei da tam nuwapoya kamonai. ");
INSERT INTO pwg_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Ina magura na tuna nakanani ma donki dipa. Wawaya peyarisi ini kawapatesi ma ti bade ini kawapatei. Tuna mani ina rakaraka yavata ini makiiberowana.” ");
INSERT INTO pwg_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Nani murinai Heiga, Bada kurina kana vava vuna ikwatukwatui, ivonavonei bo, “Tam God Kekitakitiku.” Ma bade ivona bo, “Wawayina ekitakitiku na taku mani matakuwai akitai. Anotakavakavai.” ");
INSERT INTO pwg_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Tuna kubiine wawaya nani dogona ivi vavei Be Layai Roi, iyamna “God yawayawana ekitakitiku na tuna ina dogo.” Ma dogona na patana da Kades ma Beredi basusiyai emakamakai. ");
INSERT INTO pwg_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Vaghina ma Heiga, Abram natuna ivi tuwei da tomowa. Ma Abram ivi vavei Ismayel. ");
INSERT INTO pwg_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Natuna itupuwa na Abram kana madegha 86. ");
INSERT INTO pwg_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Abram kana madegha 99 na Bada inekiibau kurina ma ivona bo, “Taku na ‘El Sadai,’ God Rewapana Kirakiiku. Kevotekatekeku ma kevi wawaya bubuna da am yawasa na maninina kavakava. ");
INSERT INTO pwg_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Vona bubuna da tam ma taku na vivaghina namada taberai ma tuna na makamakiina. Ma ana berai da tupurereghim ina peyari kirakai.” ");
INSERT INTO pwg_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Ma Abram itawotei da maghighina ioru ku tano. Ma God ivona bo, ");
INSERT INTO pwg_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“Aku vivaghina makamakiina kurim na weni, avonavonakiiyaragha da dam ipeyari i mamai na tam. ");
INSERT INTO pwg_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Kam vava Abram ma karako aviravirai da kam vava vuna na Abraham, vavana iyamna ‘koroto ghamana i mamai.’ Ana berai da dam ipeyari ina vona da i mamai ghamana na tam. ");
INSERT INTO pwg_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Ana berai da tupurereghim ina peyari da kamosiyai na dam bogii ma bogiiyai. Ma bade kamosiyai na kiikiivavo ghamaghamasi ina miirikiibau. ");
INSERT INTO pwg_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Ma aku vonakiiyapa bagibagina atereterei da weni vivaghinina tam ma tupurereghim kurimi aberaberai na ina makii nonowa da kimta ma kimta kurisi ina damadamana. Mara nonowa taku na am God ma bade tupurereghim i God. ");
INSERT INTO pwg_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Karako na tam numataya Keinan dobuna kamonai. Ma mara sago weni dobuna kudubina ana veremi da tam ma tupurereghim murimuwai na ini rapena nonowei. Ma taku na i God.” ");
INSERT INTO pwg_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Vaghina ma God, Abraham kurina ivona bo, “Ma tam na kevotekateka. Vivaghina makamakiina taberaberai na kuna vokikini da tam ma tupurereghim murimuwai na kona kivina nonowei, da kimta ma kimta nununai ina damadamana kurisi. ");
INSERT INTO pwg_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Ma ita vivaghina makamakiina kamonai na tami tomotomowa kovi tuvivira. Tam ma tupurereghim murimuwai ina tuputupuwa na tomotomowa kudubimi kwimata bekami kotuviviratawei. ");
INSERT INTO pwg_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Kudubimi kona tuviviratawei na tuna ini matakira da tami ma taku weni vivaghina makamakiina tepanai tamakamakai. ");
INSERT INTO pwg_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Ma kimta vusi kamonai tomotomowa ina tuputupuwa na kovi koyakoyagha da taparoro sago ina kovi ma mara ina tom na natunatumi kwimata bekasi kotuviviratawei. Ma bade wawaya kubiimi evovobagibagi ma tomotomowa iyavo kava kogimarisi da am bigabiga na peyarisi, natunatusi yavata kotuviviratawesi. ");
INSERT INTO pwg_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Namanaki tomotomowa gwabimiyai itupuwa bo kogimarisi da ami sleiv na peyarisi sagosago duma kotuviviratawesi. Weni matakirina tupuwimiyai ina makai na konakovi da weni vivaghinina na ina makii nonowa. ");
INSERT INTO pwg_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Ma meni tomowina kwimata bekana ke ita tuviviratawei na ke aku wawaya. Vivaghina makamakiina ke ita kivikivini, tuna kubiine ina kiibutawemi.” ");
INSERT INTO pwg_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Ma bade God, Abraham ivonei bo, “Kawam ke kuna kwatui da Serai. Karako aviravirai da kana vava vuna na Sera. ");
INSERT INTO pwg_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Kawam ani biibiini da natum tomowa ini tuwei. Ani biibiini da dam ipeyari ina vona da i maduwa na kawam. Ma tupurereghina kamosiyai na kiikiivavo ina miirikiibau.” ");
INSERT INTO pwg_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Ma Abraham itawotei da maghighina ioru ku tano. Ma inota meyei da ivivi nama. Ivona bo, “Kade tomowa ina morapa da kana madegha 100 na ini tuwa bo? Ma bade Sera imorapa da kana madegha 90 na kade ini tuwa bo?” ");
INSERT INTO pwg_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Ma God kurina ivona bo, “Vaghina bo kegha da natuku Ismayel am vibiibiina gaburinai ita makai.” ");
INSERT INTO pwg_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Ma God ivona bo, “Vaghina, Ismayel ani biibiini. Ma aku vivaghina makamakiina na ke tuna yavata kana berai. Kawam Sera ini tuwa da natum tomowa sago ma kuni vavei Aisiki. Ma akii viruwa vivaghina makamakiina kana berai da nani vivaghinina na ina makii nonowa da tupurereghina yavata nani kamonai. ");
INSERT INTO pwg_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Ma Ismayel kubiine na am vinowi avi yanei da ani biibiini ma natunatuna ina peyari ma tupurereghina ina rakata da ini dam ghamana. Ma tuna na kiikiivavo ivi 12 i mamai. ");
INSERT INTO pwg_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Ma vivaghina makamakiina na ke Ismayel yavata. Nokon ku madeghina Sera natum Aisiki ini tuwei ma muriyai na tuna yavata vivaghina makamakiina kana berai.” ");
INSERT INTO pwg_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Ma vaghina, God, Abraham yavata ivi sisiya ikovi na ikuyowei. ");
INSERT INTO pwg_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Marana sago Abraham ivotekateka da natuna Ismayel ma tomotomowa kudubisi gwabinai imakamakai na irutinisi da kwimata bekasi ituviviratawei, nani kamonai bigabiga tomotomowisi gwabinai itupuwa bo igimarisi na yavata. ");
INSERT INTO pwg_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Tuna maranai Abraham kana madegha 99 na kwimata bekana ituviviratawei ");
INSERT INTO pwg_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","ma natuna Ismayel na kana madegha 13. ");
INSERT INTO pwg_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Ma vaghina, ivi ruwa ituvivira ikovi ");
INSERT INTO pwg_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","ma bade tomotomowa kudubisi Abraham gwabinai imakamakai na ituvivira yavusi, ina bigabiga tomotomowisi ma natunatusi tomotomowisi na yavata. ");
INSERT INTO pwg_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Mara sago Bada inekiibume Abraham kurina. Abraham ina yobe na Mamre ina kii ghamaghamasi ririnai ma imuyamuya kirakai da tuna na ina yobe maghinonai imakamakai. Madegha punai na ");
INSERT INTO pwg_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","itepa da tomotomowa ivi aroba ivivi miiriyana ikitisi. Ikitisi na yaghiyaghinai ivomiiri, iverupotesi da iti kiikiiwesi. Maghinosiyai itawotei da maghighina ioru ku tano. ");
INSERT INTO pwg_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","Ma ivona bo, “Bada, kobababa ma, ke maninina kona nae. Taku am bigabiga wawayiku na weni. ");
INSERT INTO pwg_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Weni kiina rogunai koni yakam mara gisina ma okowa kana kavarapiyei da kaemi kona kowa. ");
INSERT INTO pwg_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Ma bade vavai gisina kana kavarapiyei da kona kam. Rewapana kona viiya ma muriyai da kona nae. Aikiikiiwemi da kopisi aku ku numa da ana koyaghimi.” Ma tomotomowisi ivona bo, “Kiiwakiiwa, ibiibii kirakai. Ikikava kuvonekai na keberai.” ");
INSERT INTO pwg_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Vaghina ma Abraham yaghiyaghinai ina yobe ku kamona irui ma Sera ivonei bo, “Kevi yaghiyaghina. Parawa biibiina keviiya da 20 kilos kevokapakapawi ma kekapuni.” ");
INSERT INTO pwg_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Muriyai iverau inae da meni dobunai ina kau yavona ivivi makiiyana nake. Ma kau natuna dodona ivinei ma irutini ineyei ina bigabiga tomowina kurina. Ma ivonei da yaghiyaghinai ita vowai ma ita vokuyi. ");
INSERT INTO pwg_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Ivi tava ikovi na siyana, mereki ma chis ikavari da numataya maghinosiyai iterei. Ma ikamkam kubiine Abraham ivokaravesi na kiirogunai imiiri da i kayowana avai na ita kavarapiyei. ");
INSERT INTO pwg_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Ma nani tomotomowisi ivona bo, “Ma kawam Sera na imapatana?” Ma ivonapotesi bo, “Tuna na yobe kamonai.” ");
INSERT INTO pwg_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Ma Bada God ivona bo, “Maram madeghinai ana vovira ana kitimi. Muriyai da ana pisi na kawam ini tuwa da tomowa.” Ivivi sisiya na Sera murisiyai, yobe kamonai ivivi yanesi. ");
INSERT INTO pwg_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Abraham da Sera imagura kirakai, ma Sera inota meyei da tuna imorapa da vituwa kana mara ikovi. ");
INSERT INTO pwg_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Tuna kubiine numa kamonai ivi nama, ivona bo, “Taku namada amorapa kirakai da ke ata vivinumamakamakai. Ikikava ani tuwa? Ma kawaku, tuna bade imorapa kirakai.” ");
INSERT INTO pwg_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Ma Bada, Abraham kurina ivona bo, “Avi kubiine Sera ivi nama ma ivona bo, ‘Amorapa kirakai. Kade ani tuwa bo kegha.’ ");
INSERT INTO pwg_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Bada kurina bera kudubina itekateka kirakai. Ikikava avonemi na ina tupuwa. Murina madeghinai ana vovirame. Muriyai da ana pisi na kawam ini tuwa da tomowa.” ");
INSERT INTO pwg_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Ma Sera iyabumana, tuna kubiine ivi bero, ivona bo, “Kegha, ke ati nama.” Ma Bada God ivona bo, “Ke kuni bero. Kuvi nama.” ");
INSERT INTO pwg_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Tomotomowisi ivi aroba ivomiiri da baba ivi karei. Ma Abraham na yavata inae da iti tutawesi. Ma peyarisi ikitataweyana da Jodan gonunai Sodom kwanatuna ikitai. ");
INSERT INTO pwg_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Ma Bada ivona bo, “Aviyavisina ana berai na Abraham ani mamatarei bo kegha? E, ani debei kurina. ");
INSERT INTO pwg_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Tupurereghina ini dam ghama ma ini rewapana kirakai. Ma Abraham tepanai na dam kudubisi ani biibiinisi. ");
INSERT INTO pwg_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Avinei da natunatuna ma tupurereghina ini nowesi da aku keta vaghata ina kivikivini ma bera biibiisi ma maninisi ina beraberai. Nakanani ina berai ma ikikava aku vonakiiyapa bagibagina kurina aterei na kudubina ana bera yavui.” ");
INSERT INTO pwg_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Tuna kubiine Bada, Abraham kurina ivona bo, “Sisiya avi yanei da Sodom ma Gomora kwanatusi kamonai wawaya i berabero irakata ma ibero kirakai. ");
INSERT INTO pwg_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Taku mani anoru da matakuwai ana kitai da weni sisiyisi avivi yanei na vonavaghata bo vibero.” ");
INSERT INTO pwg_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Ma tomotomowisi ivi ruwa ivoteresi inae da ku Sodom. Ma Abraham na Bada yavata imiimiiri. ");
INSERT INTO pwg_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Vaghina ma, Abraham imiiririya Bada kurina ma ivonei bo, “Vona bubuna da wawaya maninisi na berabero wawayisi yavata kuna kiipupunatawesi bo? ");
INSERT INTO pwg_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Ma kade wawaya maninisi ivi 50 kava kwanatuna kamonai na ikikava? Nani wawayisi maninisi ivi 50 notasiyai na kwanatuna kuna nuwaghanei bo kuna kiipupunatawei? ");
INSERT INTO pwg_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Ke vaghina da wawaya maninisi kuna kiivunusi. Ke ita biibai da wawaya maninisi na berabero wawayisi yavata kovogha ita viiya. Tam na dobu kana vitupavira wawayim ma am bera kudubina na maninina kavakava.” ");
INSERT INTO pwg_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Ma Bada ivona bo, “Vaghina, Sodom kamonai wawaya maninisi ivi 50 ana pananisi na kwanatuna kudubina ana nuwaghanei.” ");
INSERT INTO pwg_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Ma Abraham ivi sisiyame, ivona bo, “Bada, taku ke wawaya kiimatana da maghinomuwai ati tepatora ma ati gheviravira. Taku nakanani ma popoku bo yapukare. Ma kegha da ana vonem. ");
INSERT INTO pwg_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Kade wawaya maninisi ivi 45 kava kuna pananisi na ikikava? Wawaya maninisi ivi 5 kunekwa kavisi na kwanatu kudubina kuna kiipupunatawei bo kegha?” Ma Bada God ivonapotei bo, “Vaghina, wawaya maninisi ivi 45 ana pananisi na kwanatuna ke ana kiipupunatawei.” ");
INSERT INTO pwg_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Ma Abraham ina sisiya ikwapanatini, ivona bo, “Ma, kade wawaya ivi 40 kava na ikikava?” Ma ivonapotei bo, “Vaghina, wawaya ivi 40 ana pananisi na ke ana berai.” ");
INSERT INTO pwg_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","“Bada, ke nuwanuwam ina pughu. Ma kevotereku da ani sisiyame. Kade wawaya maninisi ivi 30 na ikikava?” “Vaghina, ivi 30 ana pananisi na ke ana berai.” ");
INSERT INTO pwg_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","“Bada, aku vitepatora ma aku vigheviravira kubiine na aku berabero kenotatawei. Ma kegha da ana vona meyem. Kade wawaya ivi 20 kava kuna pananisi na ikikava?” “Vaghina, ivi 20 kava na ke ana berai.” ");
INSERT INTO pwg_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","“Bada, ke nuwanuwam ina pughu, kevotereku da ani sisiyame. Kade wawaya ivi 10 kuna pananisi na ikikava?” Ma Bada ivona bo, “Vaghina, wawaya maninisi ivi 10 kava ana pananisi na kwanatuna kudubina ana nuwaghanei, ke ana kiipupunatawei.” ");
INSERT INTO pwg_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Ma vaghina, Bada, Abraham yavata ivi sisiya ikovi na ikuyowei inae. Ma Abraham ivovirame ina ku yobe. ");
INSERT INTO pwg_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Nani murinai, aneyisi ivi ruwa Abraham ivoterei na raviyai ku Sodom kwanatuna inekiibau. Ma Lot na kwanatu matuketinai imakamakai da ikitisi. Ivomiiri inae da ivi kiikiiwesi, maghinosiyai itawotei da maghighina ioru ku tano. ");
INSERT INTO pwg_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","Ma ivonesi bo, “Aku babada, taku ami bigabiga wawayiku na weni. Ibiibai da kota pisi aku ku numa. Gwabikuwai kaemi kona kowa ma takena da maram mara boiboi vaghata kona nae.” Ma ivona potei bo, “Kegha, tokai na kwanatu basunai yagharinai kana kena.” ");
INSERT INTO pwg_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Ma ikiikiitupesi da damonai na ivi vaghinei ma inae ina ku numa. Ma Lot ina bigabiga ivi yonesi da parawa ke yist yavata ita kapuni ma vavai ita vovunaghi da kii numataya kubiisi. Ivovunagha ikovi na ikam. ");
INSERT INTO pwg_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Muriyai da numataya ita kena na tomotomowa Sodom kamonai, yarayaragisi ma magumagurisi, na kudubisi ipisi da numa imiiriviviri. ");
INSERT INTO pwg_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Vaghina ma, irukwatu Lot kurina ma ivona bo, “Nani tomotomowisi ipisi kurim na imapatana? Kerutinisi kokiibau da yavata kani iputona.” ");
INSERT INTO pwg_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Lot ikiibau da iti sisiya kurisi ma matuketa murinai itinapotai. ");
INSERT INTO pwg_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","Ivonesi bo, “Kegha, turaturaku, kovoteresi. Bera berona ke kona berai. ");
INSERT INTO pwg_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Koviyana, natunatuku wiwikesi ruwa na kamonai. Ti na ke meyani tomowa damina ita viiya. Ana rutinisi kana kiibau kurimi da ami kayowanai kona berai kurisi. Ma tomotomowisi ivi ruwa na ke kona beraberoi kurisi. Ti na taku kaku numataya, tuna kubiine kii papara avowavowai.” ");
INSERT INTO pwg_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Ma ivonapotei bo, “Kemiiritaweyana!” Muriyai ivona bo, “Tuna dobu viruwa wawayina, ina rewapana kegha da ini tupavirekai ma ina vonakiiyaragha da bera berona taberaberai.” Ma Lot kurina ivona bo, “Ke kuna miiritaweyana na tam kurim berabero kirakiina kana berai.” Ma ivopotepotei da ivi muritina, i kayowana da matuketa ita kiirikai. ");
INSERT INTO pwg_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Vaghina ma nani tomotomowisi ivi ruwa numa kamonai ivororona da Lot itinaruwei ku numa kamona ma matuketa itinapotai. ");
INSERT INTO pwg_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Muriyai ivi ruwa bera sago iberai da tomotomowisi kupunai ivowisi, matasi ikiipotai da kudubisi, yarayaragisi ma magumagurisi yavata na matuketa iekwa kavai. ");
INSERT INTO pwg_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Tomotomowisi ivi ruwa Lot ivi tarakiiyanei bo, “Kade am wawaya viya weni kwanatuna kamonai bo kegha? Natunatum bo rawarawam bo am rakaraka sago emakamakai na kerutinisi da kwanatuna kokiibutawei. ");
INSERT INTO pwg_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","Weni kwanatuna kana kiipupunatawei. Bada sisiya ivi yanei da Sodom kamonai wawaya i berabero ibero kirakai. Tuna kubiine ivonatawekai da kana kiipupunatawei.” ");
INSERT INTO pwg_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Vaghina ma Lot inae da natunatuna wiwikesi kii vopapara ivonesi bo, “Kovi yaghiyaghina da weni dobuna kona kiibutawei. Gisina kava ma Bada weni kwanatuna ina kiipupunatawei.” Ma rawarawana inotai da ita vivinama. ");
INSERT INTO pwg_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Mara itomtom na nani aneyisi ivi ruwa Lot idarudarui, ivonavonei bo, “Kovi yaghiyaghina! Kovomiiri, kawam da natunatum wiwikesi ruwa kerutinisi da weni dobuna kokiibutawei. Ke kona verau na kwanatu kana kovogha kana vereverei na nani kamonai tami bade kona rabobo.” ");
INSERT INTO pwg_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Lot ina nota iragharagha tuna kubiine aneyisi imana iviiya ma kawana da natunatuna ruwa imasi yavata iviiya ma irutinisi, ivi nowesi ikiibau kwanatu ku kupuna. Bada ivi kamyuyuwesi da ivi yawasisi. ");
INSERT INTO pwg_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Ikiibau na aneya sago ivonesi bo, “Koverau! Ami yawasa koekwai! Ma ke kona tavire ma ke warereyai koni kiimiiriyemi. Koverau, ku koya kona ghae da ke kona rabobo.” ");
INSERT INTO pwg_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Ma Lot ivona bo, “Kegha, babada. Ke kovokovoghina da ana verau ku koya. ");
INSERT INTO pwg_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Namada bera ghamanakina kuberai da kuvi yawasiku ma, koya irabaraba kirakai. Keta borinai Sodom kana kovogha na taku yavata ina kamowaniku da ana rabobo. ");
INSERT INTO pwg_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Kekitai, nokoni meyagina gisina na ke ita rabaraba. Kevi vaghinei da nake ana verau. Tuna na meyagi gisi korekorena ma nani dobunai ana yawasa.” ");
INSERT INTO pwg_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Ma aneyina ivonapotei bo, “Vaghina, aivaghinei. Nani meyagina ke ana kiipupunatawei. ");
INSERT INTO pwg_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Ma, yaghiyaghinai koverau! Ke kovokovoghina da aku biga ana berai da nake kona nekiibau.” Lot ivona da kwanatuna na gisina. Tuna kubiine wawaya ivi vavei Sowa, vavana iyamna ‘gisina.’ ");
INSERT INTO pwg_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Madegha ighepaka na Lot inekiibau ku Sowa. ");
INSERT INTO pwg_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Vaghina ma, Bada iberai da sulpa wakimisi karakaratisi kunumai ivi garewakatuna, ere yebayebarisi ioru da Sodom ma Gomora kwanatusi iravisi. ");
INSERT INTO pwg_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Kwanatusi, anaghina kudubina ma iyavo kava nani dobunai ivivi makiiyana ma aviyavisina peyarina igogogo na kudubina ikaragavogavovorisi. ");
INSERT INTO pwg_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Ma Lot kawana na itavire ku murina ita kita na tupuwina ivi wakima. ");
INSERT INTO pwg_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Mara boiboiyai Abraham ivi mara ma ivovira da meni dobunai Bada yavata ivivi sisiya na nake. ");
INSERT INTO pwg_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Ikitaveruwana da Sodom ma Gomora ma nani anaghina kudubina ita kitai. Vaghina ma, ikita da keyama nani dobunai ivivi bubuwana. Bau ghamana igheghae tuna nakanani ma keyama ghamanakina ita karakarai. ");
INSERT INTO pwg_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Ma vaghina, God kwanatusi nani anaghina kamonai ikiipupunatawesi ikovi ma nani kamonai Abraham inotai. Tuna kubiine Lot ivowagui da kovogha berona iveruvuvurei da iyawasa. ");
INSERT INTO pwg_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Nani murinai Lot iyabumana ma ke ina kayowana da Sowa kamonai ita makai. Tuna kubiine natunatuna wiwikesi ivi ruwa irutinisi ma Sowa ikuyowei ma ighae ku koya da buba kamonai ivivi makiiyana. ");
INSERT INTO pwg_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Mara sago iyarokona, murimurina ivonei bo, “Ita mamai na imagura, ma ke sago tomowa weni dobunai ita makamakai da kata ravaghi. Dobu ku kudubina tomotomowa ma wivine etatavine, nakanani bera emakamakai. ");
INSERT INTO pwg_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Weni nakanani taberai. Ita mamai ti uma neghaneghai ma yavata takena. Tituwa da kata dam ke ina wapa.” ");
INSERT INTO pwg_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Vaghina ma, nani didibarinai wain iverei da iumai. Ma iyarokona inae i mamai kurina da yavata ikena. Ma iuma kirakai kubiine ke itakovi da aviyavisina itupuwa. ");
INSERT INTO pwg_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Mara itom na iyarokona tina kikei ivonei bo, “Taku didibarai yavata kakena. Ma karako ti uma neghanegha meyei na tam kuna nae kurina da yavata kona kena. Tam ma taku tituwa da kata dam ke ina wapa.” ");
INSERT INTO pwg_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Vaghina ma, nani didibarinai ivi uma neghaneghai ma murimurina inae da yavata ikena. Bade nakanani, iuma kirakai kubiine ke itakovi da aviyavisina itupuwa. ");
INSERT INTO pwg_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Ma vaghina, nakanani Lot natunatuna wivinesi ivi ruwa iropeya da i mamai ina manawa. ");
INSERT INTO pwg_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Iyarokona ivi tuwa da tomowa ma ivi vavei Mowabi. Tuna na Mowabi damsi i kaekiki. ");
INSERT INTO pwg_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Ma murimurina bade ivi tuwa da tomowa ma ivi vavei Benami. Tuna na Amon damsi i kaekiki. ");
INSERT INTO pwg_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Abraham, Mamre dobuna ikuyowei ma inae ku warere kana vava Negev da kwanatu kii vava Kades da Sura na basunai imakai. Ma bade mara gisina Gera kwanatunai imakamakai, ");
INSERT INTO pwg_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","na nani dobuna damsi ivonesi da kawana Sera na novuna. Tuna kubiine, Gera kana kiivavo Abimaleki wawaya ivonatawesi da Sera irutinapiyei kurina. ");
INSERT INTO pwg_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Didibara sago Abimaleki ivi matu da God inekiibau kurina ma ivonei bo, “Nani wavinena kurutini na tatavinena, tuna kubiine tam na kurabobo ma kemakamakai.” ");
INSERT INTO pwg_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Ma kegha, Abimaleki wavinena ininina ke ita kiitovoni, tuna kubiine ivona bo, “Bada, taku ma aku wawaya akii berona kegha ma kuna kiipupunatawekai bo? ");
INSERT INTO pwg_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Abraham tuna mani ivona da Sera na novuna, ma Sera bade nakanani ivona. Weni berana aberai na aku nota maninina ma ke berona.” ");
INSERT INTO pwg_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Abimaleki ina vimatu kamonai God ivonapotei bo, “E, akovi da am nota manininai weni berana kuberai, tuna kubiine atarapaparim da ku mataku berabero ke kuta berai, akovi da wavinena ininina ke kuta votovoni. ");
INSERT INTO pwg_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Wekarakava na kawana kevere meyei, iyamna Abraham na peroveta ma tuna ina nipowana kubiim da ke kuna rabobo. Ma wavinena ke kuna vere meyei na kuakovi da tam ma am wawaya na kona rabobo.” ");
INSERT INTO pwg_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Mara itom ma mara boiboiyai Abimaleki ina wawaya ghamaghamasi ikwaturiyariyesi ma ivonesi da aviyavisina itupuwa kurina na iyabumana kirakai. ");
INSERT INTO pwg_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Vaghina ma Abimaleki, Abraham ikwatui ipisi ma ivonei bo, “Aviyavisina kuberai kurikai? Kade ikikava akiiviberom da weni nuwapoyina ghamanakina kuverekai da taku ma aku wawaya yavata wavuna kana kavari? Tam kava weni nakanani kubera beroi kuriku, ke meyani wawaya sago ita berai. ");
INSERT INTO pwg_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Weni berana kuberai na bera berona.” ");
INSERT INTO pwg_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Abraham ivonapotei bo, “Anotai da weni dobunai na God ke kota yabuyabumanei, tuna kubiine kovokovoghina da kota kiivunuku ma kawaku kota viiya. ");
INSERT INTO pwg_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Ma vona bubuna da tuna na novuku. Tuna na aku mamai natuna, ma ke aku maduwa ina nevanevai tuna kubiine aravaghi. ");
INSERT INTO pwg_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Rorova kava God ivonataweku da aku mamai ina rakaraka ma ina dobu kakiibutawei ma dobu viruwa kamosiyai kabababa. Baba kavi karei na wavinena avonei bo, ‘Weni nakanani kuni debe meyem da am nuwaviina irakata kuriku, dobu nununai tarurui na wawaya kevonesi da tam na novuku.’” ");
INSERT INTO pwg_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Vaghina ma Abimaleki sipu ma kau ma sleiv tomotomowisi ma wivinesi irutinapiyei da Abraham iverei ma bade kawana irutini da ivere meyei. ");
INSERT INTO pwg_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Ma ivona bo, “Aku tano kudubina kekitai, ma am kayowana mikeme na vaghina, nani dobunai kemakai.” ");
INSERT INTO pwg_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Ma Sera kurina ivona bo, “Tam kubiim na mane 1,000 silva riririghisi novum avereverei, am wawaya kurisi ini matakira da tam na am berabero kegha.” ");
INSERT INTO pwg_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Nani murinai Abraham inipowana God kurina da Abimaleki kana gubaga ivi yawasi. Ma bade kawana ma i bigabiga wivinesi yavata na peyarisi i keta ivotawei da iti tuwame. ");
INSERT INTO pwg_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","Abimaleki, Sera irutini ina ku numa da ita ravaghi, tuna kubiine Bada God iberai da wivine peyarisi ina rakaraka kamonai i vituwa ketana igudui. ");
INSERT INTO pwg_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Bada ina agabiibai Sera kurina irakata da ikikava ivonakiiyapa na iberai. ");
INSERT INTO pwg_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Namanaki da Abraham imorapa kirakai na Sera iropeya ma ivi tuwa da natuna tomowa. Avi maranai tomowa kikei ita tupuwa na God namada ivi debei na vaghina, nakanani itupuwa. ");
INSERT INTO pwg_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Sera ivi tuwa ikovi na Abraham tomowa kikei ivi vavei ‘Aisiki.’ ");
INSERT INTO pwg_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Ma mara 8 ikovi na God ina sisiya bagibagina ikivini da natuna kwimata bekana ituviviratawei. ");
INSERT INTO pwg_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Tomowa kikei itupuwa na ina mamai kana madegha na 100. ");
INSERT INTO pwg_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Ma Sera ivona bo, “God nuwabiibai ivereku ma iberai da ainama. Wawaya peyarisi sisiyiku ini yanei na yavata kani nama patapata.” ");
INSERT INTO pwg_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Ma ku tepana ivona bo, “Rorova wawaya ita pisi kawaku ita vonei da taku mani natuku ati susui na kata nota kavakavai. Ma kegha, kawaku moramorapina ma natuna tomowina avi tuwei da weni.” ");
INSERT INTO pwg_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Ma vaghina, Aisiki imagura ma vikaratawena kubiine na Abraham kamporagha ghamana iberai. ");
INSERT INTO pwg_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Egypt wavine Heiga na Abraham natuna Ismayel ivi tuwei ma muriyai Aisiki itupuwa. Ma Ismayel ivi karei da Aisiki ivivi namei ma ikitakitaoruwei. Mara sago Sera ikitisi ");
INSERT INTO pwg_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","na inae da Abraham ivonei bo, “Buderi kuna rereghi na Ismayel nevanevana ke ina viiya, kudubina na natuku Aisiki ini rapenei. Tuna kubiine nani sleiv wavinena natuna yavata kekwavinisi ina nae.” ");
INSERT INTO pwg_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Weni sisiyina kubiine Abraham nuwanuwana ipoya kirakiiyei, iyamna Ismayel na bade natuna. ");
INSERT INTO pwg_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Ma God, Abraham ivonei bo, “Tomowa kikei ma ami bigabiga wavinena na ke kuni nuwapoyesi. Aviyavisina Sera evonavonem na kevi yanei. Aisiki gwabinai tupurereghim ina rakata da am wawaya na dam ghamana, ke Ismayel gwabinai. ");
INSERT INTO pwg_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Ma bigabiga wavinena natuna na bade natum, tuna kubiine ani biibiini da tupurereghina ina rakata da dam sago.” ");
INSERT INTO pwg_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Mara itom ma mara boiboi nakiyai Abraham ivomiiri ma vavai da ‘okowa diudeuna’ iviiya da Heiga kana keta tamiina. Ku katagheyana iterei ma natuna yavata ivonatawesi inae. Ivi ruwa inae da ku dobu makiiwapana (Dobuna kamonai gawara sago kana vava Beyaseba). Ma nani dobunai ibababa yawara. ");
INSERT INTO pwg_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Okowa kudubina diudeu kamonai iumai ikovi na tomowa kikei kiikiiruku rogunai iterekuyowei. ");
INSERT INTO pwg_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Ibaba inae gisina ma ivi kiimakiiyei. Inotai da natuna ita rabobo tuna kubiine ke ina kayowana da ita kitai. Nani dobunai imakamakai da tou ivi karei. ");
INSERT INTO pwg_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","God ivi yanei da tomowa kikei itutou na ina aneya kunumai ivi kwatu Heiga kurina, ivonei bo, “Heiga, aviyavisina ibero? Ke kuna yabumana. God ivi yanei da tomowa kikei ekenakena ma etutou. ");
INSERT INTO pwg_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Kevomiri, kenae da imana kuna viiya ma kuna tinavomiirini. Ke ina rabobo ma ana berai da tupurereghina ina peyari.” ");
INSERT INTO pwg_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Vaghina ma God iberai da Heiga matana itamotatagha ma ikita da dogo sago ikitai. Inae da diudeu ivui ma tomowa kikei iverei da iuma. ");
INSERT INTO pwg_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Ma vaghina, Ismayel imagumagura na God na gwabinai. Dobu makiiwapasiyai imakamakai ma tuna na dosiyo wawayina. ");
INSERT INTO pwg_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Warere kana vava Paran na nani dobunai imakamakai na ina maduwa inae da Egypt wavine sago irutini da natuna kawana. ");
INSERT INTO pwg_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Nani maranai Abimaleki ma ina iyo damsi i bada ghamana Pikol na inae Abraham kurina ma ivonei bo, “Akitai da aviyavisina kudubina keberaberai na God gwabimuwai. ");
INSERT INTO pwg_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Tuna kubiine ainowi da God ku matana kuna vonakiiyapa kuriku da ke meyani kuni beroberowekai, natunatuku ma tupurereghiku yavata. Weni dobunai tam na dobu viruwa wawayim ma kevi debe meyem da ikikava aku nuwaviina avereverem na nakanani bade kuna vereku.” ");
INSERT INTO pwg_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Abraham ivona bo, “Vaghina, avonavonakiiyapa kurim.” ");
INSERT INTO pwg_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Muriyai nuwapoya sago ivi dughuwei. Abraham dogo sago rapenai ivi yarani ma Abimaleki ina bigabiga iviiya, tuna kubiine Abraham, Abimaleki kurina ivi gheviravira. ");
INSERT INTO pwg_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Ma Abimaleki ivona bo, “Ke atakovi da iyavo kava weni berana iberai. Ke kuta voneku, tuna kubiine wekarakava sisiyina avi yanei.” ");
INSERT INTO pwg_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Tuna kubiine Abraham sipu da kau irutinapiyei da Abimaleki ipuyoi ma ivi ruwa vivaghina iberai. ");
INSERT INTO pwg_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Ma Abimaleki ikitai da Abraham ina sipu yavona kamonai sipu wivinesi votuvotusi ivi 7 ivoviviri, ");
INSERT INTO pwg_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","ma ivi tarakiiyanei bo, “Weni sipusi na avi kubiine?” ");
INSERT INTO pwg_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Ma ivonapotei bo, “Weni sipusi votuvotusi ivi 7 imakuwai kevopotei, ini matakira da weni dogona na taku mani ayabai.” ");
INSERT INTO pwg_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Ma vaghina, nani dobunai ivi ruwa vivaghina iberai, tuna kubiine dobuna ivi vavei Beyaseba. ");
INSERT INTO pwg_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Vivaghina iberai ikovi na Abimaleki ma ina iyo damsi i bada ghamana Pikol na ivovirame i ku kwanatu Pilisti dobuna kamonai. ");
INSERT INTO pwg_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Ma Abraham na kii kana vava tamarisk ivoni Beyaseba dobunai. Ma bade nani dobunai Bada makamakii nonowina ivokavakavari. ");
INSERT INTO pwg_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Ma vaghina, mara iguri kirakai Pilisti dobuna kamonai imakai. ");
INSERT INTO pwg_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Mara sago God inae Abraham kurina da ita rubui. Ikwatu, ivona bo, “Abraham!” Ma ivonapotei bo, “Taku weni.” ");
INSERT INTO pwg_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Ma God ivona bo, “Natum tupukeya Aisiki na am nuwaviina ghamana ma kegha da kerutini konae da ku Morai dobuna. Ma koya sago ani beyem na tepanai natum kuna verena, kuna kiivunui ma kuna kapuni da am suwara kuriku.” ");
INSERT INTO pwg_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Mara itom ma maraboiboi nakiyai Abraham ivomiiri ma ina donki ivovunaghi. Ma natuna Aisiki irutini, ina bigabiga ruwa yavata. Keyama ibiga da ruvaruvana suwara kapunina kubiine na ivomiiri da ita nae God gawarina ivonavonei na nake. ");
INSERT INTO pwg_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Ibaba inenae da mara viarobinai Abraham ikitataweyana da gawarina ikitai. ");
INSERT INTO pwg_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Ina bigabiga ivonesi bo, “Donki yavata weni dobunai komakai. Ma taku tomowa kikei yavata kana nae noke da kana vokavakavara ma muriyai kana vovirame kurimi.” ");
INSERT INTO pwg_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Abraham suwara kana keyama bawana iviiya da natuna Aisiki ivi kavari ma tuna na naipi ma kii karakarata ikavari. Ma ivi ruwa ibaba inenae ");
INSERT INTO pwg_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","na Aisiki ivona bo, “Mamai?” Abraham ivona bo, “Natuku, avai?” Ma Aisiki ivona bo, “Akitai da kii karakarata ma keyama bawana na weni, ma suwara kana sipu na imapatana?” ");
INSERT INTO pwg_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Ma ivona bo, “Natuku, God tuna mani suwara kana sipu ina vokiibuwei.” Ma ivi ruwa ibaba inae. ");
INSERT INTO pwg_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Gawarina God ivonavonei na inekiibau nake ma wakima ivi daburi da suwara kana kema iyamoni ma keyama ikemai. Ikemai ikovi na natuna imana da kaena ikutatana ma ipewai da kema ma keyama tepanai ivi kenai. ");
INSERT INTO pwg_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Vaghina ma, ivororona naipi iviiya da natuna ita gwarivunui. ");
INSERT INTO pwg_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Ma kegha, kunumai Bada ina aneya irukwatu kurina, “Abraham, Abraham!” Ma Abraham ivonapotei bo, “Taku weni.” ");
INSERT INTO pwg_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Aneyina ivona bo, “Tomowa kikei ke kuna gwariya. Kevoterei, ke sago aviyavisina berona kuna berai kurina. Natum tupukeya ke kuta panikowei, tuna kubiine wekarakava akovi da God kevovokaravei.” ");
INSERT INTO pwg_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Vaghina ma, Abraham itepa da kiikiiruku kamonai sipu tomowina sago ikitai, tonana ikirai ma ivivi paparana. Inae da iviiya ivowai ma natuna epayanina kubiine ikapuni da ina suwara. ");
INSERT INTO pwg_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Ma vaghina, Abraham nani gawarina ivi vavei ‘Bada ivokiibuwei.’ Ma karako weni ku marana wawaya patana da evonavona bo, ‘Bada ina koya tepanai ina vokiibuwei.’ ");
INSERT INTO pwg_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Muriyai Bada ina aneya kunumai ivi kwatume Abraham kurina, tuna na mara kana viruwa. ");
INSERT INTO pwg_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","Ivona bo, “Natum tupukeya ke kuta panikowei. Weni berana kuberai kubiine na taku mani avakuwai avonavonakiiyapa da ");
INSERT INTO pwg_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","ani biibiinim ma ana berai da tupurereghim ina rakata kirakai da ti na nakanani ma gwamegwame kunumai bo gonugonu kikirai. Ma tupurereghim kii ghavighaviya ina ghegavovorisi da i kwanatu ini rapenei. ");
INSERT INTO pwg_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Ma kuvotekateka kubiine na mara sago tupurereghim sago tepanai dam ma dam kudubisi dobuwai ani biibiinisi.” ");
INSERT INTO pwg_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Ma vaghina, Abraham natuna yavata ivovirame ina bigabiga kurisi ma peyarisi inae ku Beyaseba da nani dobunai Abraham imakai. ");
INSERT INTO pwg_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Mara sago Abraham imakamakai na tina kikei Nayo varana ivi yanei da natunatuna tomotomowisi ipeyari kirakai. Nayo kawana Milka ivi tuwa ");
INSERT INTO pwg_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","da iyarokona kana vava Usi ma murinai na Busi ma Kemuwel itupuwa (ma Kemuwel imagura na natuna Aram). ");
INSERT INTO pwg_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Ma Kemuwel murinai na Kesedi, Haso, Pildas, Jidilapi ma Betuwel. ");
INSERT INTO pwg_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Ma Betuwel natuna na Rebeka. Vaghina Nayo kawana Milka nakanani ivi tuwa da natunatuna tomotomowisi ivi 8. ");
INSERT INTO pwg_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Ma ku tepana bigabiga wavinena kana vava Reuma, tuna bade ivi tuwa da Nayo natunatuna tomotomowa ruwamaruwa, kii vava Teba, Gayam, Tayas ma Maka. ");
INSERT INTO pwg_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Sera imakai da kana madegha 127, ");
INSERT INTO pwg_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","vaghina ma kwanatu kana vava Kiriyati Aba na kamonai irabobo. Kiriyati Aba kana vava sago na Hibron, tuna Keinan dobuna kamonai. Ma nani dobunai Abraham itou ma isiyapa kawana Sera kubiine. ");
INSERT INTO pwg_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Vaghina ma, kawana tupuwina ivoterei ma ivomiiri inae Hiti damsi kurisi ma ivona bo, ");
INSERT INTO pwg_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“Taku dobu viruwa wawayiku, kaku vava na numataya ma kamomiyai amakamakai. Kade karawaga kubiine tano gisina weni dobunai ata gimari da kawaku tupuwina ata terei.” ");
INSERT INTO pwg_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Ma Hiti damsi ivonapotei bo, ");
INSERT INTO pwg_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“Bada, kevi yanekai, kamokiiyai tam na kiivavo ghamam. Nuwabiibiiyai kaivaghinei da am kayowanai akii karawaga sago biibiina kevinei da kawam tupuwina kuna terei.” ");
INSERT INTO pwg_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Ma Abraham nani dobuna damsi ivokaravesi da gayamina itereoruwei ");
INSERT INTO pwg_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","ma ivona bo, “Kovi vaghinei da kawaku tupuwina ami dobuwai ana terei, tuna kubiine kade Soya natuna Eperon kurina koti nowi ");
INSERT INTO pwg_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","da gwabinai buba kana vava Makipela ata gimaratawei, tuna bonaghina na Eperon ina parata ririnai. Kovonei da maghinomiyai buba kana miiya vaghata ina terei da kudubina ani miiyatawei da nani karawagina na taku ani rapenei.” ");
INSERT INTO pwg_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Abraham na Hiti damsi kurisi ivivi sisiya na peyarisi kwanatu matuketinai ivivi makiiyana da ivivi yana. Ma Eperon na yavata nani kamonai. Ma Abraham kurina ivona bo, ");
INSERT INTO pwg_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“Kegha, aku bada, kevi yaneku. Aku wawaya maghinosiyai nani bubana ma tanona na kudubina avereverem da nani dobunai kawam tupuwina kuna terei.” ");
INSERT INTO pwg_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Abraham na ivokaravesi da gayamina itereoruwe meyei ");
INSERT INTO pwg_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","ma maghinosiyai ivi sisiya Eperon kurina da peyarisi iti yanei. Ivona bo, “Kegha, kevi yaneku. Tanona kudubina kana miiya vaghata kevoneku da ani miiyatawei. Kevi vaghinei da ani miiyem ma nani dobunai kawaku tupuwina ana terei.” ");
INSERT INTO pwg_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Ma ivonapotei bo, ");
INSERT INTO pwg_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“Aku bada, kevi yaneku. Tanona miiyiina na silva riririghisi ivi 400 ma tuna ke sago avai. Kegimari ma kawam tupuwina nani dobunai kuna terei.” ");
INSERT INTO pwg_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Abraham, Eperon ina sisiya ivi vaghinei ma Hiti damsi maghinosiyai silva riririghisi ivi 400 na ivi yavi da ruvana iviini ma iverei. Ma Abraham ina silva sago sago duma i vita ma vivigimara wawayisi nani kwanatuna kamonai i silva sago sago duma i vita na ivi yavayavatei. ");
INSERT INTO pwg_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Vaghina ma Eperon ina tano ivi damani Abraham kurina. Dobuna kana vava Makipela, tuna na Mamre ririnai. Ma nani kamonai vao, kii ma buba na kudubina Abraham iviiya, ");
INSERT INTO pwg_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","da ivi rapenei. Weni berana na kwanatu matuketinai iberai da Hiti damsi peyarisi matasiyai ikitai. ");
INSERT INTO pwg_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Nani murinai Abraham kawana tupuwina ikavaraneyei da buba ku kamona iterei. Bubana na Mamre ririnai, Keinan dobuna kamonai, ma Mamre kana vava sago na Hibron. ");
INSERT INTO pwg_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Ma vaghina, nakanani itupuwa da Hiti damsi i tano ma bubana Abraham iviiya da ivi karawagei. ");
INSERT INTO pwg_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Abraham na kana madegha ine kirakai da imorapa ma mara nonowa Bada ina vibiibiina gwabinai da ina yawasa kamonai na biibiina kavakava, kesago nuwapoya ita panani. ");
INSERT INTO pwg_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Mara sago ina bigabiga tomowina ikwatui ipisi kurina, tuna tomowina na Abraham ina bera peyarina ivivi gayamei. Ma ivonei bo, “Imam ku tepaku keterei kevi matakira da aku kayowana kuna berai. ");
INSERT INTO pwg_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","Keinan damsi kamosiyai tamakamakai. Bada God tuna kunuma ma dobu iyamoni na matanai kuna vonakiiyapa kuriku da ke weni dobunai wiwike sago kuna rutini da natuku Aisiki ini kawanei. ");
INSERT INTO pwg_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Kegha, kenae da aku ku dobu, aku rakaraka kurisi da nani dobunai wiwike sago kuna rutinapiyei da natuku kawana.” ");
INSERT INTO pwg_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Ma bigabiga tomowina ivi tarakiiyanei, “Ma mikeda wiwike sago ana panani ma ina bara, ke ina kayowana da weni ku dobuna ina pisi na ikikava? Vaghina bo kegha da natum Aisiki ana rutinaneyei ami ku dobu vaghata?” ");
INSERT INTO pwg_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Ma Abraham ivona bo, “Kegha, kegha taweyana! Ke kuna rutinaneyei nake. ");
INSERT INTO pwg_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Bada God kunumai ikwatuku da aku mamai ina rakaraka ma aku dobu vaghata akuyowesi. Ma ivonakiiyapa kuriku da weni dobuna na tupurereghiku ina veresi da ini rapenei. Ma ina aneya ina vonatawei ini nao nake ini vitem da wiwike sago kuna panani da natuku kawana. ");
INSERT INTO pwg_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Ma wiwikena ina bara na am vonakiiyapa kuriku kevi bagunei ma kevovirame. Ma ke meyani natuku tomowina kuna rutinaneyei nake.” ");
INSERT INTO pwg_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Vaghina ma bigabiga wawayina imana ina bada ku tepana iterei ma ivonakiiyapa da ina sisiya ina votekatekei. ");
INSERT INTO pwg_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Bigabiga tomowina inae da Abraham ina kamel ivi 10 irutinapiyesi ma mura ghamana, sawara bogii ma bogiiyai ku tepasi ivi tawanepeyana. Ma ivomiiri inae ku Aram Nayaraim dobuna. Ibaba inenae da Nayo ina ku kwanatu inekiibau. ");
INSERT INTO pwg_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Ma kwanatu kupunai dogo imakamakai ma baranai kamel iberisi da ikenavipika. Namada ravi ipika ma tuna maranai na wivine ikiikiibau okowa ivu kubiine. ");
INSERT INTO pwg_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Vaghina ma inipowana bo, “O, Bada God, tam aku bada Abraham ina God. Ainowi da kuni viteku da aviyavisina kubiine apisi na karako ana panani. Am nuwaviina aku bada kurina kuti debei. ");
INSERT INTO pwg_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Kekitiku, taku weni dogona baranai amiimiiri ma weni kwanatuna damsi natunatusi wivinesi ekiikiibau okowa inivu. ");
INSERT INTO pwg_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Kevi matakira kuriku da meni wiwikena kurina ati nowi bo, ‘Kade am kibubu kuta tereoruwei da atuma.’ Ma ita vonapoteku bo, ‘Kiuma ma bade am kamel kubiisi anivu da ani umiisi.’ Nakanani ini sisiya na anakovi da tuna wiwikena kuvinei da am bigabiga Aisiki kubiine. Nakanani kuna berai na am nuwaviina aku bada kurina kuni debei.” ");
INSERT INTO pwg_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Karakava da ina nipowana iti kovini na Rebeka ina kibubu katagheyanai ikavaravaghai ma meyagai ikiibutawei. Wiwikena ina mamai na Betuwel, ina kwabura na Milka, ma ina doboro na Nayo, tuna na Abraham tina kikei. ");
INSERT INTO pwg_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Wavinena ivi karawata kirakai, tuna wiwike gubugubu, ke meyani tomowa damina ita viiya. Ioru ku dogo da ina kibubuwai okowa ivui ma ighae. ");
INSERT INTO pwg_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Vaghina ma bigabiga tomowina yaghiyaghinai wiwikena iverupotei ma ivonei bo, “Kade am kibubuwai okowa gisi vaghina kuta vereku da atumai.” ");
INSERT INTO pwg_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Ivona bo, “Vaghina, bada, kiuma.” Ma yaghiyaghinai ina kibubu itereoruwei ma ivovigewai da bigabiga tomowina iuma. ");
INSERT INTO pwg_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Iuma ikovi ma wiwikena ivona bo, “Bade, am ghamoghamo kubiisi anivu da ani uma dodosi.” ");
INSERT INTO pwg_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Vaghina ma yaghiyaghinai okowa kibubu kamonai ituratepoi ku siga, ma iverau ivovira ku dogo da okowa itivu meyei. Ma okowa ivui inenae da kamel iuma dodowana na ivoterei. ");
INSERT INTO pwg_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Bigabiga tomowina ke sago aviyavisina ita vonei, wiwikena ivivi matatetei da akovina ita viiya da vaghina wiwikena Bada ivinei bo kegha. Ivivi nuwanotanota da dobu rabarabai ibaba ipisi na Aisiki kawana inekwa kavai bo ina panani. ");
INSERT INTO pwg_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Kamel iuma ikovi na bigabiga tomowina ivororona da kamel sago tepanai giyayodi ma bade imakwasi ruwa iviiya ma wiwikena iverei, sawarisi na goldiyai iyamoni. ");
INSERT INTO pwg_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Ma ivi tarakiiyanei bo, “Tam am mamai na iyai? Kade ina numiyai na gawara ruvaruvana bo kegha da gwabimiyai kata kena?” ");
INSERT INTO pwg_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Ma wiwikena ivona bo, “Aku mamai na Betuwel, aku doboro na Nayo ma aku kwabura na Milka. ");
INSERT INTO pwg_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Ma ghamoghamo i kenakena gawarina emakamakai, rai katawei da tepanai ina kena ma bade kii vavai nani. Ma gawara emakamakai da tam bade kuna kena.” ");
INSERT INTO pwg_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Vaghina ma, bigabiga tomowina ivi tuwaporeruruwana ma Bada ivokavakavari. ");
INSERT INTO pwg_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","Ivona bo, “Bada God, aigheghenim, tam aku bada Abraham ina God. Kuvi patutu kirakai da am agabiibai kurina kuvi debei. Kuvi noweku da maninina ina rakaraka kurisi.” ");
INSERT INTO pwg_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Ma wiwikena iverau inae ina ku numa ma aviyavisina itupuwa kurina na peyarina ivi sisiyei ina rakaraka kurisi. ");
INSERT INTO pwg_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Ma nani wiwikena novuna na kana vava Leiban. Ma tuna yaghiyaghinai iverau ku dogo da bigabiga tomowina ita kitai, ");
INSERT INTO pwg_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","iyamna yodi ma imakwasi novuna ikotekotei ikitai ma ina sisiya ivi yanei. Inae da bigabiga tomowina ipanani, patana ina ghamoghamo yavata dogo baranai imiimiiri. ");
INSERT INTO pwg_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Ma ivonei bo, “Kepisi ma tanae ku numa, damim aviiya da tam na Bada ina vibiibiina kamonai. Avi kubiine we koimiiriyana? Namada tami kubiimi gawara kavovunagha ikovi ma bade ami ghamoghamo kubiisi.” ");
INSERT INTO pwg_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Vaghina ma, Leiban nani bigabiga tomowina irutini inae ina ku numa. Ma kamel i vita ivi oruni, ivi kanisi ma i kenakena gawarinai na rai vuna itawei da tepanai ita kena. Ma bade okowa ikavarapiyei da bigabiga tomowina ina wawaya yavata kaesi ita kowa. ");
INSERT INTO pwg_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Vavai itura da ita kam ma bigabiga tomowina ivona bo, “Kegha, muriyai da ana kam na kunona ani akovimi da avi kubiine apisi.” Ma Leiban ivona bo, “Vaghina, kevi sisiya.” ");
INSERT INTO pwg_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Vaghina ma ivona bo, “Taku na Abraham ina bigabiga. ");
INSERT INTO pwg_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Ma Bada aku bada ivi biibiini ma iberai da ina mura irakata kirakai. Ivi biibiini da sipu ma kau yavoyavosi, ina silva ma gold irakata, ina bigabiga wivinesi ma tomotomowisi ipeyari ma ina kamel da donki yavata. ");
INSERT INTO pwg_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Ma aku bada Abraham kawana Sera imagura kirakai ma kegha da ivi tuwa da natuna tomowa, kana vava na Aisiki. Ma Abraham ina mura kudubina na ivi damani natuna kurina. ");
INSERT INTO pwg_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Aku bada sisiya bagibagina ivereku, avonakiiyapa kurina da ke Keinan dobuna damsi kamosiyai wiwike sago ata rutini da natuna Aisiki iti kawanei. ");
INSERT INTO pwg_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Ivoneku da ata pisi wike ina ku dobu, ina rakaraka kurimi da kamomiyai wiwike sago ata rutinaneyei da natuna kawana. ");
INSERT INTO pwg_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Ma aku bada Abraham avi tarakiiyanei, ‘Ma mikeda wiwikena ina bara da ke ina pisi na ikikava?’ ");
INSERT INTO pwg_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Ma ivoneku bo, ‘Bada mara nonowa gwabikuwai na tuna ina aneya ina vonatawei ini vitem da wiwike kuna panani. Aitumaghana da kuna nae na wavine sago aku rakaraka kamosiyai kuna rutini da natuku ini kawanei. ");
INSERT INTO pwg_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Ma mikeda aku rakaraka ke ini vaghinei da wiwike sago kamosiyai kuna rutini na ke kuni nuwapoyei. Nakanani ina tupuwa na am vonakiiyapa kamonai ana votawem. Kovogha ke kuna panani.’ ");
INSERT INTO pwg_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","Nakanani aku bada ivi sisiya kuriku, vaghina ma ababa apisi da karako anekiibau ku dogo na anipowana bo, ‘O, Bada God, tam na aku bada Abraham ina God. Kevi viteku da aviyavisina kubiine apisi na karako ana panani. ");
INSERT INTO pwg_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Kekitiku, taku weni dogo baranai amiimiiri ma wavine wiwikena sago ina pisi okowa itivu kubiine na ani nowi kurina bo, “Kade am kibubu kuta tereoruwei da atuma.” ");
INSERT INTO pwg_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","Mikeda ina vonapoteku bo, “Kiuma ma bade am kamel kubiisi anivu da ani umiisi,” na anakovi da tuna wiwikena kuvinei da aku bada natuna kawana.’ ");
INSERT INTO pwg_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Karakava aku nipowana nuwanuwakuwai ati kovini na Rebeka akitai, ina kibubu katagheyanai ikavaravaghai ma ioru ku dogo da itivu. Ivu ma avonei bo, ‘Kade atuma bo kegha?’ ");
INSERT INTO pwg_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Yaghiyaghinai ina kibubu itereoruwei ma ivona bo, ‘Kiuma ma bade am kamel ani umiisi.’ Vaghina ma auma ma bade aku kamel ivi umiisi. ");
INSERT INTO pwg_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Ma avi tarakiiyanei bo, ‘Tam am mamai na iyai?’ Ma ivonapoteku bo, ‘Aku mamai na Betuwel, aku doboro na Nayo ma aku kwabura na Milka.’ Avi yanei na vaghina, giyayodi sago ma imakwasi ruwa averei. ");
INSERT INTO pwg_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Vaghina ma, avi tuwaporeruruwana ma Bada God avokavakavari, avona bo, ‘Bada aigheghenim, tam aku bada Abraham ina God. Kuvi noweku da maninina Abraham tina kikei kurina da tupuna wavinena apanani da natuna kubiine.’ ");
INSERT INTO pwg_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Ma vaghina, wekarakava na kade aku bada Abraham kurina ami nuwaviina koni debei bo kegha da akovina ana viiya. Koni akoviku ma muriyai da aku nota ana rereghi da aviyavisina ana berai.” ");
INSERT INTO pwg_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Ma Leiban da Betuwel ivonapotei bo, “Ke ruvaruvana da ikikava kana vonem. Weni tuna na Bada ina kayowana. ");
INSERT INTO pwg_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Vaghina, Rebeka na weni. Kerutini ma kona nae da am bada natuna ini kawanei. Bada ina kayowana takivini.” ");
INSERT INTO pwg_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Ma Abraham ina bigabiga i sisiya ivi yanei na itawotei da maghighina ku tano itereoruwei ma Bada kurina ivi kiikiiwa. ");
INSERT INTO pwg_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Ma posaru, imakwasi ma yodi, silva ma goldiyai iyamona na Rebeka ipuyoi ma bade gara yavata. Muriyai na ina maduwa ma novuna ipuyosi, nani puyosi na miiyanisi irakata kirakai. ");
INSERT INTO pwg_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Vaghina ma peyarisi ikam ma iuma patapata ma bigabiga tomowina ina wawaya yavata na Rebeka ina rakaraka gwabisiyai ikena. Mara boiboiyai ivomiiri ma ivona bo, “Kovonatawekai kana vovirame aku bada Abraham kurina.” ");
INSERT INTO pwg_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Ma Rebeka ina maduwa ma novuna ivona bo, “Kegha, karakava. Wiwikena na mara ivi 10 gwabikiiyai ina makai ma nani murinai kona nae.” ");
INSERT INTO pwg_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Ma ivonapotesi bo, “Ke kona vonatanikai. Bada iberai da avi kubiine ababa apisi na namada apanani ikovi. Tuna kubiine wekarakava kovonatawekai kana vovirame aku bada Abraham kurina.” ");
INSERT INTO pwg_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Vaghina ma ivona bo, “Wiwikena takwatui ina pisi ma titarakiiyanei da tuna mani ina kayowana ina voneta.” ");
INSERT INTO pwg_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Rebeka ikwatui ipisi ma ivonei bo, “Wekarakava weni tomowina yavata kona nae bo kegha?” Ma ivonapotesi bo, “E, vaghina, aku kayowana da yavata kana nae.” ");
INSERT INTO pwg_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Vaghina ma Rebeka ivonatawei da bigabiga tomowina ina wawaya yavata inae. Ma ina bigabiga sago yavata inae, tuna wavinena na kana koyakoyagha. ");
INSERT INTO pwg_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Ivomiiri da ita nae ma Rebeka ina rakaraka ivonakiiyaragha kurina bo, “Novukai, kevi tuwa kirakai da natunatum ina peyari. Tupurereghim ini rewapana kirakai ma kii ghavighaviya ina ghegavovorisi da i kwanatu ini rapenei.” ");
INSERT INTO pwg_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Vaghina ma Rebeka ina bigabiga wivinesi yavata ivovunagha ikovi na i ku kamel igeru ma nani bigabiga tomowina yavata ivomiiri inae. ");
INSERT INTO pwg_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Tuna maranai Aisiki na namada dogo kana vava Be Layai Roi ivoterei da Negev dobunai imakamakai, tuna na Keinan ina parata kamonai. ");
INSERT INTO pwg_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Mara sago ravi ipika na ikiibau ku dobu yagharina ma ivivi nuwanotanota. Ma itepa da ikitataweyana ma ikita da kamel viya ibaba ipipisi. ");
INSERT INTO pwg_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Ma bade Rebeka itepa da Aisiki ikitai. Ina kamel tepanai ioru ma inae da ");
INSERT INTO pwg_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","Abraham ina bigabiga ivi tarakiiyanei bo, “Meni tomowina everaverupotepoteta?” Ivona bo, “Tuna na aku bada natuna.” Vaghina ma, vokarava kubiine Rebeka gayamina kana gere iviiya da maghighina igerei. ");
INSERT INTO pwg_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Ku taki inekiibau na bigabiga tomowina ivi sisiya Aisiki kurina, aviyavisina kudubina itupuwa na ivonaverei. ");
INSERT INTO pwg_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Vaghina ma Aisiki da Rebeka itavine ma ivi ruwa inae Sera ina ku yobe. Muriyai da Rebeka ita nekiibau na Sera irabobo da Aisiki ina maduwa kubiine ivi nuwapoya. Ma itavine na kawana nuwanuwana ivii kirakiiyei, tuna kubiine nuwanuba ipanani. ");
INSERT INTO pwg_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Abraham wavine sago irutini da kawana vuna. Wavinena kana vava Ketura. ");
INSERT INTO pwg_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Ivi tuwa da natunatuna Simram, Jokisan, Medan, Midiyan, Isibaki ma Suwaya. ");
INSERT INTO pwg_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Jokisan natunatuna na Seba ma Dedan. Ma Dedan tupurereghina na Asura damsi, Letusi damsi ma Leyum damsi. ");
INSERT INTO pwg_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Ma Midiyan natunatuna na Epa, Eperi, Hanoki, Abida ma Elda. Weni wawayisi peyarisi na Ketura tupurereghina. ");
INSERT INTO pwg_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Ma Abraham na aviyavisina rapenai peyarina na natuna Aisiki kurina ivi damani. ");
INSERT INTO pwg_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Ma karakava da ita rabobo na natunatuna tomotomowisi kakawana viya gwabisiyai na puyo irereghi kurisi. Ma ku maramatana ivonatawesi ine rabaraba da ke Aisiki gwabinai ita makai. ");
INSERT INTO pwg_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Abraham imakai da kana madegha 175. ");
INSERT INTO pwg_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Imakii bubuna da ina yawasa iguri ma imagura kirakai, vaghina ma irabobo. ");
INSERT INTO pwg_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Natunatuna Aisiki da Ismayel tupuwina iviini inae ku karawaga da ku buba kamona iterei. Nani bubana na Makipela dobuna kamonai emakamakai, tuna na Mamre ririnai. Karenai tuna tanona na Hiti tomowa Eperon rapenai, tuna Soya natuna. ");
INSERT INTO pwg_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Muriyai Abraham inae da Hiti damsi gwabisiyai igimari ma kawana tupuwina nani bubana kamonai iterei. Ma Abraham irabobo na bade bubana kamonai, kawana Sera yavata idogosi. ");
INSERT INTO pwg_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Abraham irabobo murinai na natuna Aisiki dogo kana vava Be Layai Roi na ririnai imakamakai. Ma God, Aisiki ivi biibiini. ");
INSERT INTO pwg_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Weni tuna na Abraham natuna Ismayel ina varagutugutu. Tuna na Heiga natuna ma Heiga na Sera ina bigabiga wavinena, ina dobu na Egypt. ");
INSERT INTO pwg_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Ismayel natunatuna tomotomowisi kii vava na weni, i tupuwa nununai tagiruma. Natuna iyarokona na Nebayoti, tuna murinai na Keda, Adebel, Mibsam, ");
INSERT INTO pwg_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Misma, Duma, Masa, ");
INSERT INTO pwg_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Hadadi, Tema, Jetura, Napis ma Kedema. ");
INSERT INTO pwg_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Weni damsi na Ismayel natunatuna, ti na dam ivi 12 i kaekiki mau. Ma ti na i meyagai ma i taki nununai ivivi makiiyana. ");
INSERT INTO pwg_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Ma Ismayel imakai da kana madegha 137 ma irabobo. ");
INSERT INTO pwg_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Ma tupurereghina peyarisi i dobu na Havila da ku Sura warerena, dobuna na Egypt ina parata ririnai ma ku maramatana. Keta sago enenae ku Asura dobuna ma nani ketana kuta viiya na i dobu kuta panani. Ma peyarisi mara nonowa ti mani i rakaraka yavata ivivi kawapata. ");
INSERT INTO pwg_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Weni tuna na Abraham natuna Aisiki ina varagutugutu. ");
INSERT INTO pwg_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Aisiki kana madegha 40 ma itavine, kawana na Rebeka. Rebeka ina mamai na Betuwel ma novuna na Leiban. I dobu ghamana na Arameya ma i dobu gisina kana vava na Padan Aram. ");
INSERT INTO pwg_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Ma Rebeka na gagarina. Tuna kubiine Aisiki inipowana Bada kurina da iti tuwa ma ina nipowana ivi yanei. Vaghina ma, Rebeka iropeya. ");
INSERT INTO pwg_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Ma damina iviiya da iti tuwa da wawayaruwa ma pepeyisi na manawina kamonai ivivi papareyana. Ma i maduwa ivona bo, “Weni tuna na avi berana etuputupuwa kuriku?” Tuna kubiine ivi nowi Bada kurina da akova ita viiya. ");
INSERT INTO pwg_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Ma Bada ivonapotei bo, “Pepeyisi kamomuwai ina magura na ini tuwa da dam ruwa, ma ivi ruwa na ini kawapata. Murimurina ina dam ini rewapana kirakai da iyarokona ina dam ina ghekuyowesi. Ma murimurina na iyarokona ini badei.” ");
INSERT INTO pwg_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Kana mara ipisi da iti tuwa ma ivi tuwa da tomotomowa ruwa. ");
INSERT INTO pwg_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Natuna iyarokona na buroburona ma inikorokorona tuna kubiine ivi vavei, ‘Iso.’ ");
INSERT INTO pwg_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Ma murimurina ikiikiibau na iyarokona ku kaekarena ivokikita vaghata, tuna kubiine ivi vavei, ‘Jeikap.’ Aisiki kana madegha 60 na Rebeka nani ededisi ivi tuwesi. ");
INSERT INTO pwg_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Vaghina ma, nani tomotomowisi imagumagureyana na Iso tuna yebagha bogana ma dipa kana wawaya. Ma Jeikap tuna kawapotapotana ma numiyai, yobe kamosiyai imakamakai. ");
INSERT INTO pwg_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Aisiki ina kayowana ghamana siya tuna kubiine ina nuwaviina Iso. Ma Rebeka, tuna ina nuwaviina ghamana Jeikap. ");
INSERT INTO pwg_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Mara sago Jeikap bini yebayebarisi ivivi tavi ma Iso dipiyai ikiibau. Inekiibau na vitonara ikara kirakiiyei ");
INSERT INTO pwg_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","tuna kubiine ivona bo, “Vitonara ikara kirakiiyeku, bini kuta vereku da ata kani.” (Iso kana vava sago na Edom, tuna vavana iyamna ‘yebayebarina.’) ");
INSERT INTO pwg_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Ma Jeikap ivonapotei bo, “Kunona kuni vaghinei da iyaroko buderina kudubina kuna vereku da rapekuwai na vaghina.” ");
INSERT INTO pwg_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Iso ivona bo, “Kekitiku, vitonara ekarakara kirakiiyeku da gisina kava ma ana rabobo. Aviyavisina biibiina nani buderina kamonai ana panani?” ");
INSERT INTO pwg_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Jeikap ivonapotei bo, “Kunona vonakiiyapa bagibagina keterei, kuni vaghinei da am buderi ana viiya.” Vaghina ma, Iso ivi vaghinei. Ina vonakiiyapa bagibagina iterei da aviyavisina kudubina i mamai iti damani kurina na ke tuna ina viiya ma Jeikap ini rapenei. ");
INSERT INTO pwg_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Muriyai Jeikap parawa da bini iverei da ikam ma iuma ikovi ma ivomiiri da inae. Ma vaghina, Iso ina ‘buderi’ ivi wapai ma kesago iti nuwapoyei. ");
INSERT INTO pwg_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Mara sago gomara ghamana nani dobunai itupuwa. Ma gomarina kubiine Aisiki mau inae ku Gera dobuna, Pilisti damsi i kiivavo Abimaleki kurina. Weni tuna na gomara kana viruwa, kunona gomara sago Abraham ina mariyai itupuwa. ");
INSERT INTO pwg_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Bada inekiibau Aisiki kurina da ivonei bo, “Ke kunoru ku Egypt, avonavonem da weni dobunai kemakai. ");
INSERT INTO pwg_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Kemakai mara gisina ma taku na gwabimuwai ma ani biibiinim. Weni dobuna kudubina na tam, tupurereghim yavata ana veremi. Nakanani ana berai na aku vonakiiyapa bagibagina am mamai Abraham kurina aterei na ana nunuri. ");
INSERT INTO pwg_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Ana berai da tupurereghim ina rakata da nakanani ma gwamegwame kunumai. Ma weni dobuna kudubina ana veresi da rapesiyai. Ma tupurereghim tepasiyai na dam ma dam dobuwai ani biibiinisi. ");
INSERT INTO pwg_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Am mamai Abraham ivotekateka bubuniku da aku vonaviyoyovana, aku sisiya bagibagisi ma aku kayowana kudubina ibera yavui, tuna kubiine ani biibiinim.” ");
INSERT INTO pwg_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Aisiki nani sisiyina Bada gwabinai iviiya, tuna kubiine Gera dobunai imakiikikina. ");
INSERT INTO pwg_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Ma nani dobuna tomotomowisi ipisi kawana Rebeka kubiine ivi tarakiiyanei. Kawana ivi karawata kirakai ma Aisiki iyabumana, inotai da ita vona bo, “Tuna kawaku,” na tomotomowisi ita kiivunui ma kawana ita rutini. Tuna kubiine ivi bero, ivona bo, “Tuna novuku.” ");
INSERT INTO pwg_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Aisiki nani dobunai imakii kirakai. Ma mara sago Pilisti damsi i kiivavo Abimaleki ina numa tepanai ikita ioru da Aisiki ikitai, kawana Rebeka itaraghavui ma iyoyoni. ");
INSERT INTO pwg_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Tuna kubiine Aisiki ikwatui inae kurina ma ivonei bo, “Kuvi bero! Wavinena na kawam! Avi kubiine kuvona da tuna na novum?” Aisiki ivonapotei bo, “Anotai da ati mamatara da tuna na kawaku na kota kiivunuku.” ");
INSERT INTO pwg_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Ma Abimaleki ivona bo, “Avi kubiine weni berana kuberai kurikai? Aku wawaya sago kawam ita kenei na wavuna kata kavari.” ");
INSERT INTO pwg_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Vaghina ma, Abimaleki ina sisiya bagibagina iterei ina wawaya kudubisi kurisi, ivonesi bo, “Meni wawayina Aisiki bo kawana ini kayotiranei na vaghina, wawayina kani raboboi.” ");
INSERT INTO pwg_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Ma vaghina, Aisiki gwabisiyai imakai ma Bada ivi biibiini, nani dobunai iwayowa da mura ghamanakina ipanani. ");
INSERT INTO pwg_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Ina mura irakata ma nakeda irakarakata da ina mura isasara. ");
INSERT INTO pwg_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Ina bigabiga wawayisi ma ina sipu da ina kau yavoyavosi ipeyari, tuna kubiine Pilisti damsi inuwakapiyei. ");
INSERT INTO pwg_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Ti na ivomiiri da dogo peyarisi idogo potapota yavu, dogosi na Aisiki ina mamai ina bigabiga wawayisi yavata iyaba. ");
INSERT INTO pwg_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Nani murinai Abimaleki, Aisiki ivonei bo, “Akii dobu kekiibutawei, tam kuvi rewapana kirakai, ke nakanani ma tokai.” ");
INSERT INTO pwg_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Vaghina ma Aisiki nani dobuna ikiibutawei ma inae da Gera anaghinai itupagigira da imakai. ");
INSERT INTO pwg_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Ma dogo viya nani dobunai na ina mamai Abraham iyaba ma irabobo murinai na Pilisti damsi idogo potapota. Ma Aisiki na dogosi peyarina iyabame. Ma ina mamai ikikava kii vava iveresi na nakanani ivi vava meyesi. ");
INSERT INTO pwg_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Mara sago anaghina kamonai, Aisiki ina bigabiga wawayisi dogo vuna iyabai da okowa biibiina ipanani. ");
INSERT INTO pwg_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Ma Gera dobuna wawayisi, ti na sipu kii koyakoyagha, na ivomiiri da Aisiki ina sipu kii koyakoyagha iyeghisi nani dogona kubiine, ivonesi bo, “Weni okowina na tokai akii okowa, ke tami.” Tuna kubiine dogona ivi vavei ‘Eseki,’ nani vavana iyamna ‘Vigamowana.’ ");
INSERT INTO pwg_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Vaghina ma, Aisiki ina bigabiga inae da dogo sago iyabai ma kegha, nani dogona kubiine na bade ivi gamowana. Tuna kubiine dogona ivi vavei ‘Sitna,’ nani vavana iyamna ‘Miiripote.’ ");
INSERT INTO pwg_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Nani dogona ikuyowei ma inae da bade dogo sago iyabai na kesago iyai nani dogona kubiine ita gamo. Tuna kubiine ivi vavei, ‘Reyobota,’ nani vavana iyamna ‘Taraboga Ghamana.’ Ma ivona bo, “Wekarakava na Bada ivotaweta ma taraboga ghamana ivereta da tamakai bubuna ma mura ghamana tapanani.” ");
INSERT INTO pwg_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Muriyai Aisiki nani dobuna ivoterei ma inae ku Beyaseba. ");
INSERT INTO pwg_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Inekiibau ma nani didibarinai Bada irumatara kurina ma ivona bo, “Namada avonakiiyapa aku bigabiga Abraham kurina da tupurereghimi ina rakata, tuna kubiine ani biibiinim ma ana berai da nakanani ina tupuwa. Taku na am mamai Abraham ina God. Taku gwabimuwai, tuna kubiine ke kuna yabumana.” ");
INSERT INTO pwg_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Vaghina ma, Aisiki suwara kana kema iyamoni ma Bada ivokavakavari. Ma nani dobunai itupagigira da ina yobe itini ma ina bigabiga wawayisi dogo sago vuna iyabai. ");
INSERT INTO pwg_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Mara sago Abimaleki, Gera dobuna kamonai ivomiiri inae Aisiki kurina. Ma ina wawaya ruwa irutinisi da yavata inae. Sago na ina wawaya akakovina kana vava Ayusati ma sago na ina iyo wawayisi i bada Pikol. ");
INSERT INTO pwg_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Ivi aroba inekiibau na Aisiki ivona bo, “Rorova kovi kawapateku na kokwaviniku da akiibutawemi. Ma wekarakava na avi kubiine kopisi kuriku?” ");
INSERT INTO pwg_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Ivonapotei bo, “Wekarakava kakovi da Bada gwabimuwai. Kanotanotai da tam ma tokai na vivaghina kata berai. Kakayokayowei da kurikai kuna vonakiiyapa ");
INSERT INTO pwg_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","da ke kuna kiiviberokai. Rorova tokai bade ke kata kiiviberom, kakoyagha bubunim da damonai na nuwanubiiyai kavonatawem da akii dobu kukuyowei. Ma karako kakitai da ivi biibiinim.” ");
INSERT INTO pwg_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Vaghina ma, Aisiki kamporagha ghamana iberai kubiisi da ikam ma iuma. ");
INSERT INTO pwg_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Mara itom ma mara boiboiyai peyarisi vivaghina iberai, sagosago duma vonakiiyapa bagibagina iterei. Nani murinai Aisiki ivi kiikiiwesi ma nuwanubiiyai ivonatawesi da inae. ");
INSERT INTO pwg_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Inae ma murinai na Aisiki ina bigabiga wawayisi inekiibau ma ivonei da dogo sago iyabai. Nuwabiibiiyai ivona bo, “Okowa kapanani!” ");
INSERT INTO pwg_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Ma Aisiki dogona ivi vavei ‘Siba’ ma kwanatu nani dobunai ivowai kana vava ‘Beyaseba.’ Ma karako kwanatuna patana da emakamakai ma kana vava ke ita virai, kana vava Beyaseba. ");
INSERT INTO pwg_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Aisiki natuna Iso kana madegha 40 na Hiti wivine ruwa iravaghisi. Sago na Beri natuna Juditi, ma kana viruwa na Elon natuna Basemati. ");
INSERT INTO pwg_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Iso nani wivinesi iravaghisi na Aisiki da Rebeka i yawasa ivi beroi ma nuwapoya ghamana iveresi. ");
INSERT INTO pwg_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Aisiki imagura kirakai ma matana isowasowa da ke ruvaruvana ita kita. Mara sago natuna iyarokona Iso ikwatui ma ivonei bo, “Natuku.” Ma ivonapotei bo, “Taku weni.” ");
INSERT INTO pwg_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Ivona bo, “Taku wekarakava na amagura kirakai ma gisina kava da ana rabobo. ");
INSERT INTO pwg_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Am yovu ma dosiyo kekavari ma kekiibau ku warere da siya sago kuna vowai kubiiku. ");
INSERT INTO pwg_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Kaku siya kekavarapiyei ma vavai yavata kevokuya monamonai da ana kam. Ana kam ina kovi na muriyai da ana rabobo na ani biibiinim.” ");
INSERT INTO pwg_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Aisiki nakanani ivivi sisiya Iso kurina na Rebeka ivivi yana. Iso ivomiiri ikiibau ku warere da siya sago ita vowai ma ita kavarapiyei, ");
INSERT INTO pwg_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","na Rebeka natuna Jeikap kurina ivona bo, “Am mamai ivi sisiya Iso kurina ma avi yanei. ");
INSERT INTO pwg_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","Ivona bo, ‘Siya sago kekavarapiyei ma vavai yavata kevokuya monamonai da ana kani. Ma muriyai da ana rabobo na Bada matanai ani biibiinim.’” ");
INSERT INTO pwg_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Muriyai Rebeka ivona bo, “Natuku, kevi yana bubuna da aviyavisina ana vonem na kuna berai. ");
INSERT INTO pwg_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Kenae da gote yavona kamonai na dodosi ivi ruwa kuna vinetawei ma kuna rutinapiyei da ana vokuya monamonai. Ikikava am mamai ekayokayowei na nakanani ani tavi. ");
INSERT INTO pwg_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Ma kuna kavaraneyei am mamai kurina da ina kani ma muriyai da ina rabobo na ini biibiinim.” ");
INSERT INTO pwg_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Ma Jeikap ina maduwa kurina ivona bo, “Aku tuwa Iso na ere inikorokorona ma taku na kegha. ");
INSERT INTO pwg_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Kade mamai ita votovoniku ma ita panani da aiberoberowei na vibiibiina ke ana viiya. Kegha, taku mani kaku imaga ana titinariyai.” ");
INSERT INTO pwg_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Ma ina maduwa ivonapotei bo, “Natuku, avi imagina ina tupuwa kurim na biwana taku ana viiya. Ma aviyavisina avonavonem na keberai. Kenae da gotesi kuna rutinapiyei wike.” ");
INSERT INTO pwg_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Vaghina ma, inae da irutinisi ipisi ina maduwa kurina. Ma ikikava ina mamai ikayokayowei na nakanani ina maduwa ivokuya monamonai. ");
INSERT INTO pwg_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Muriyai Rebeka inae da Iso kana gara biibii kirakiisi numiyai itura imakamakai na iyuna da natuna murimurina ivi kotei. ");
INSERT INTO pwg_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Ma bade gote bekasi iviiya da imana igerei ma bade ku iwana mumumuna itawanepai. ");
INSERT INTO pwg_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Vaghina ma, nani vavina ivokuya monamonai na iverei. ");
INSERT INTO pwg_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Jeikap inae ina mamai kurina ma ivonei bo, “Mamai.” Ma Aisiki ivonapotei bo, “Avai natuku, tam iyai?” ");
INSERT INTO pwg_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Ma Jeikap ivi bero, ivonapotei bo, “Taku na natum iyarokoku ma aviyavisina kuvoneku na aberai, tuna kubiine kemakiivomiiri da kam siya kuna kani ma vibiibiina kuna vereku.” ");
INSERT INTO pwg_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Ma ivona bo, “Natuku, ikikava siya kupanani, iyaghiyaghina ghagha?” Ivonapotei bo, “Am Bada God ivowaguku da avowai.” ");
INSERT INTO pwg_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Vaghina ma, ina mamai ivona bo, “Kepisi kuriku da ana votovonim. Anakovi da tam natuku Iso bo kegha.” ");
INSERT INTO pwg_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Jeikap inae ina mamai ku dogarina ma ina mamai ivororona da ivopitapitari ma ivona bo, “Gamom na nakanani ma Jeikap ma imam na nakanani ma Iso imana.” ");
INSERT INTO pwg_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Jeikap imana igerei da korokorona nakanani ma Iso imana, tuna kubiine Aisiki ke ita vogii tovoni. Tuna kubiine karakava, kam murinai na ivi biibiini. ");
INSERT INTO pwg_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","Ma ivi tarakiiyaname, “Vonavaghata da tam natuku Iso bo?” Ma Jeikap ivonapotei bo, “E, taku.” ");
INSERT INTO pwg_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Ma ivona bo, “Natuku, siya kuvowai na kepiyei ana kani ma muriyai na ani biibiinim.” Vaghina ma, Jeikap siya ma vavai ikavaraneyei da ina mamai ikam ma bade wain yavata iverei da iuma. ");
INSERT INTO pwg_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Vaghina ma ina mamai ivona bo, “Natuku, kepisi kuriku da kuna yoniku.” ");
INSERT INTO pwg_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Inae kurina da iyoni na ina mamai na kana gara pughuna iyoni da weni nakanani ivi biibiini. Ivona bo, “Natuku, pughum ibiibii kirakai. Tuna nakanani ma tano pughuna. Tano Bada ivi biibiini na pughuna ibiibii kirakai. ");
INSERT INTO pwg_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Ainowi God kurina da garewa kunumai ina verem ma am tano ini biibiini da am mura ina rakata. Ina berai da witi ma wain kana greipi kuna yuna kirakiiyei. ");
INSERT INTO pwg_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Ainowi da dobu ma dobu ina biga kubiim, ma dam ma dam ina runomem. Ma titim yoghoyogho kuni badesi. Ma am maduwa tupurereghina na peyarisi ina runomem ma ina vokaravem. Ainowi da iyavo kava inimagim na God inimagisi ma iyavo kava ini biibiinim na God ini biibiinisi.” ");
INSERT INTO pwg_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Ivi biibiini ikovi na Jeikap ivomiiri inae. Inenae na nani kamonai Iso iyebagha ikovi da inekiibau. ");
INSERT INTO pwg_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Iso bade vavai da siya ivi tava monamonai ma ikavara inae ina mamai kurina ma ivonei bo, “Mamai, kemakiivomiiri da weni siyana akavarapiyei na kuna kani ma kuni biibiiniku.” ");
INSERT INTO pwg_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Aisiki ivi tarakiiyana bo, “Tam iyai?” Ma ivonapotei bo, “Taku Iso, natum iyarokoku.” ");
INSERT INTO pwg_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Vaghina ma, Aisiki ivi nuwapoya kirakai da kiroro ivi karei ma ivona bo, “Nakanani na iyai siya ivowai ma ikavarapiyei kuriku? Akani ikovi ma avi biibiini ma muriyai tam kunekiibau. Ma nani vibiibiinina namada averei ikovi da gwabinai ina makii nonowa.” ");
INSERT INTO pwg_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Ina mamai ina sisiya ivi yanei na Iso nuwanuwana ipoya kirakai da ere tutuna ivona bo, “Mamai, nakanani na taku bade kevi biibiiniku.” ");
INSERT INTO pwg_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Ma ivona bo, “Tim kikei ipisi ma ivi beroberoweku da am vibiibiina iviiyavui.” ");
INSERT INTO pwg_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Ma Iso ere nuwavisina ivona bo, “Wena mara kana viruwa ivi beroberoweku. Kovi vava bubuni da tuna na ‘Jeikap.’ Kunona kaku gawara iviiya da ivi yaroko ma wekarakava na aku vibiibiina gwabimuwai iyapiya da ivi rapenei.” Muriyai ivi tarakiiyana bo, “Kade vibiibiina sago kuvi yapakei da kubiiku bo kegha?” ");
INSERT INTO pwg_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Ma ivonapotei bo, “Kegha. Tuna na namada rewapana gwabikuwai iviiya da ini badem ma ita rakaraka kudubisi aberisi da ti na ina bigabiga. Ma bade avi biibiini da vavai ma wain na mara nonowa gwabinai ina rakata. Natuku, wekarakava na kesago avai da ana berai kubiim.” ");
INSERT INTO pwg_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Ma Iso na ina mamai ivonei bo, “Kade vibiibiina sago kava kuvi yapakei kubiiku bo kegha? Aku mamai, taku bade kevi biibiiniku!” Ivi sisiya ikovi na itupagavovora da tou ivi karei. ");
INSERT INTO pwg_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Ma Aisiki ivonei bo, “Kesago garewa kunumai inoru da tam kubiim, Kesago tano biibiina da kuna wayowei. ");
INSERT INTO pwg_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Am yawasa kamonai na kuni tona da kuna makai. Ma tim kikei kubiine kuna biga. Ma mara sago koni kawapata kirakai, Ma tuna maranai kuna kiibutawei da nani vitana kuna tatawei.” ");
INSERT INTO pwg_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Jeikap, ina mamai ivi beroberowei da gwabinai vibiibiina iviiya, tuna kubiine ina tuwa Iso nuwanuwana ipughu kirakai. Iso ivona da i mamai na mara gisina kava da ina rabobo ma kasira ina kovi, nani murinai na Jeikap ina kiivunui. ");
INSERT INTO pwg_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Ma kegha, wawaya sago Iso ina sisiya ivi yanei ma inae da Rebeka ivonei. Ma tuna na Jeikap kana sisiya ivonatawei da ipisi, ma ivonei bo, “Kevi yana, am tuwa kana biwa ina viiya, ina kayowana da ina kiivunum. ");
INSERT INTO pwg_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Natuku, aviyavisina ana vonem na keberai. Tam na keverau! Yaghiyaghinai kuna nae ku Haran, novuku Leiban kurina. ");
INSERT INTO pwg_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Yavata kona makamakai da am tuwa ina nuwapughu ina kovi. ");
INSERT INTO pwg_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Karakava nuwanuwana ina nuba ma aviyavisina kurina kuberai na ini nuwawapei. Tuna maranai na kam sisiya ana vonatawei da kuna pisi. Ke vaghina da ami viruwa mara sago kava kamonai ani wapimi.” ");
INSERT INTO pwg_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Muriyai Rebeka inae Aisiki kurina ma ivonei bo, “Weni Hiti wivinesi natuta Iso iravaghisi na ke aku kayowana, weni makamakiina na ke ata vivivaghinei. Mikeda Jeikap bade weni dobuna kamonai Hiti wavine sago ina ravaghi na ibiibai da ata rabobotaweyana.” ");
INSERT INTO pwg_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Tuna kubiine Aisiki, Jeikap ikwatui da ivi biibiini ma ivonei bo, “Ke Keinan wavine kuna ravagha tovoni. ");
INSERT INTO pwg_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Yaghiyaghinai kenae ku Padan Aram da am maduwa ina mamai Betuwel ina ku numa. Ma nani dobunai am maduwa novuna Leiban natunatuna wivinesi kamosiyai sago kuna viiya da kawam. ");
INSERT INTO pwg_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Ainowi God Rewapana Kirakiina kurina da ini biibiinim ma ina berai da natunatum ina peyari ma am koroto ina rakata da dam sago ina tupuwa. ");
INSERT INTO pwg_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Ma bade ainowi da ikikava Abraham ivi biibiini na nani vibiibiinina ini damani tam ma tupurereghim kurimi. Ma karako weni dobunai kemakamakai na tam nakanani ma numataya, tuna kubiine ainowi da God ini vaghinei da dobuna tam kuni rapenei. Ma dobuna na God, Abraham iverei.” ");
INSERT INTO pwg_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Vaghina ma, Aisiki, Jeikap ivonatawei inae ku Padan Aram, ina mamai kikei Leiban kurina. Leiban novuna na Rebeka, tuna na Jeikap da Iso i maduwa. Ma Leiban da Rebeka i mamai na Betuwel, ina dobu na Aram. ");
INSERT INTO pwg_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Iso iakovi da Aisiki, Jeikap ivi biibiini ma ivonatawei inae ku Padan Aram da nani dobunai wavine sago ita viiya da kawana. Ma bade iakovi da ivivi biibiini na tuna maranai ina sisiya bagibagina iverei da ke Keinan wavine sago ita ravaghi. ");
INSERT INTO pwg_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Ma Jeikap na ina maduwa da ina mamai i sisiya ivotekatekei da inae ku Padan Aram. ");
INSERT INTO pwg_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Iso nani maranai iakova bubuni da ina mamai ke ina kayowana Keinan wivine. ");
INSERT INTO pwg_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Tuna kubiine Iso inae Ismayel kurina da natuna Mayalati iravaghi, tuna genebuna na Nebayoti. Iso kakawana ruwa ma weni tuna na kana viaroba. ");
INSERT INTO pwg_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Jeikap Beyaseba dobuna ikiibukuyowei inenae ku Haran. ");
INSERT INTO pwg_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Ma inenae da ravi ipika na gawara sago biibiina ipanani da ita kena. Nani dobunai wakima sago iviiya iterei da ina kunuwana ma ivi kiikenei da ita kena. ");
INSERT INTO pwg_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Ma ivi matu da kiitete ikitai, kaena na dobuwai ma damona na ighae da ku kunuma. Ma ikitai da God ina aneaneya nani kiitetenai igheghae ma iororu. ");
INSERT INTO pwg_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Ma nani kiitetena damonai na Bada imiimiiri, ma ivonei bo, “Taku na Bada, am mamai Abraham da Aisiki i God. Ma weni tanona tepanai kekenakena na tam ma tupurereghim ana veremi. ");
INSERT INTO pwg_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Ma tupurereghim ina peyari da dobu ini yoghoyoghoi ma ina kiibau da ku dobu kudubina ina ne yavui. Ma tam ma tupurereghim tepamiyai na dam ma dam dobuwai ani biibiinisi. ");
INSERT INTO pwg_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Ma mike kuna nenae na taku yavata ma ani tarapaparanem ma ana viinim kuna vovira weni ku dobuna. Ma ke ana voterem da aviyavisina avonakiiyapa kurim na ana berai na vaghina.” ");
INSERT INTO pwg_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Jeikap irumataka ma nota iviiya na ivona bo, “Vona bubuna Bada na weni dobunai ma taku ke atakovi.” ");
INSERT INTO pwg_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Ma iyabumana da ivona bo, “Weni dobuna ivi iniririmona ghagha, weni tuna na kesago avai da Bada ina numa. Weni tuna na kunuma kana matuketa.” ");
INSERT INTO pwg_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Mara itom ma mara boiboiyai Jeikap nani wakimina ivivi kunuwanei na iviiya da ivi miirini ma oira ku tepana itepoi. ");
INSERT INTO pwg_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Ma nani dobuna ivi vavei ‘Betel’, kunona nani kwanatuna ikwatukwatui Lus. ");
INSERT INTO pwg_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Vaghina Jeikap vonakiiyapa bagibagina iberai, ivona bo, “Mikeda God gwabikuwai weni babana kamonai na ani vaghinei da tuna na aku God. Ina kitaruviku ma vavai ina vereku da ana kam ma gara ina vereku da ani kote, ");
INSERT INTO pwg_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","ma mikeda biibiinai ana vovira aku mamai ina ku numa na vaghina, Bada ana vonei da tuna na aku God. ");
INSERT INTO pwg_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Ma weni wakimina avi miirini na ini debei da tuna na gawara vovokaravina. Ma aviyavisina peyarina kuna vereku na riba ivi imaruwa ana terei ma sago ana verem.” ");
INSERT INTO pwg_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Vaghina ma Jeikap ibaba inenae da maramatana wawayisi i ku dobu inekiibau. ");
INSERT INTO pwg_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Ma nani dobunai ikita ku warere da dogo sago ikitai. Ma dogo baranai na sipu yavona aroba ivivi keneyana iyamna nani sipusi na nani dogonai iumuma. Ma dogona kawana kana gudu wakimina na ghamana ma vitana. ");
INSERT INTO pwg_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Ma sipu yavosi kudubina ina riyesi nani ku dogona na sipu kii koyakoyagha wakimina ina tabiratawei da sipu ini umiisi. Ma ini umiisi ina kovi na dogona kawana bade ina gudui. ");
INSERT INTO pwg_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Jeikap sipu kii koyakoyagha ivi tarakiiyanesi bo, “Varevaresiku, tami na meni dobuna wawayimi?” Ma ivonapotei bo, “Tokai akii kwanatu na Haran.” ");
INSERT INTO pwg_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Jeikap ivonesi bo, “Nayo tupuna Leiban koakovi bo kegha?” Ma ivonapotei bo, “E, kakovi.” ");
INSERT INTO pwg_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Ma Jeikap ivi tarakiiyanesi bo, “Tuna vaghina bo?” Ma ivonapotei bo, “Eee, tuna vaghina, natuna Risera ina sipu yavona yavata wepina.” ");
INSERT INTO pwg_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Jeikap sipu kii koyakoyagha ivonesi bo, “Kokitai, wekarakava na madegha ghamana ma karakava kii mara da koni umiisi. Ma vaghina kovi umiisi ma bade koviinisi ina vovira da i ku kamkam gawarina biibiina.” ");
INSERT INTO pwg_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Ma ivonapotei bo, “Ke kovokovoghina, sipu yavosi kudubina ina riyesi ina kovi na dogo kana gudu wakimina kana tabiratawei. Ma nani murinai na sipu kani umiisi.” ");
INSERT INTO pwg_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Jeikap patana da nani tomotomowisi yavata ivivi sisiya na Risera ina mamai ina sipu yavona yavata inekiibau. Tuna na sipu kii koyakoyagha. ");
INSERT INTO pwg_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Ma Jeikap, Risera ikitai da ina sipu yavata ipipisi na inae da dogo kana gudu wakimina itabiratawei ma sipu ivi umiisi. ");
INSERT INTO pwg_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Vaghina ma Jeikap, Risera iyoni ma ituwei. ");
INSERT INTO pwg_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Ma ivonei bo, “Taku na am mamai ina rakaraka, taku Rebeka natuna.” Tuna kubiine Risera iverau inae da ina mamai ivonei. ");
INSERT INTO pwg_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Leiban sisiyina ivi yanei da natuna kikei Jeikap inekiibau na yaghiyaghinai ikiibau da ita verupotei. Ma itaraghavui, iyoni ma irutinaneyei ina ku numa. Ma Jeikap aviyavisina peyarina kurina itupuwa na Leiban ivi akovi. ");
INSERT INTO pwg_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Leiban ivi yanei ma ivonei bo, “Tam na viyoku ma taraku vaghata.” Nani murinai Jeikap yavuna Leiban yavata imakai da nawaravi sago ikovi. ");
INSERT INTO pwg_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Ma Leiban ivona bo, “Tam na aku rakaraka vaghata ma ke vaghina da kubiiku kuna biga wapawapa, tam na ke sleiv. Kevoneku da ikikava ani miiyem.” ");
INSERT INTO pwg_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Leiban natunatuna wivinesi na ivi ruwa, iyarokona na Liya ma murimurina na Risera. ");
INSERT INTO pwg_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Liya tuna na matanenenerina ma ke iti karawata kirakai. Ma Risera tuna tupuwina ghamana ma ivi karawata kirakai. ");
INSERT INTO pwg_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Jeikap, Risera nuwanuwana iviini, tuna kubiine ivona bo, “Mikeda kuni vaghinei da natum Risera ana ravaghi na taku madegha miikovi ma ruwa kubiim ana biga.” ");
INSERT INTO pwg_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Leiban ivonapotei bo, “Ke aku kayowana da tomowa wapawapa ina ravaghi ma ibiibai da tam ana verem da kuna ravaghi ma yavata tamakai.” ");
INSERT INTO pwg_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Tuna kubiine Jeikap madegha miikovi ma ruwa ibiga da Risera ita ravaghi. Ma kegha da Jeikap ina nuwaviina irakata kirakai da nani madeghisi ivi miikovi ma ruwa na damina na kegha. ");
INSERT INTO pwg_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Vaghina ma Jeikap, Leiban ivonei bo, “Kaku ruva kutereterei na iviiya, kawaku kevereku, aku kayowana da yavata kana kena.” ");
INSERT INTO pwg_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Tuna kubiine Leiban nani dobuna wawayisi kudubina ikwatusi ipisi ma kamporagha ghamana iberai. ");
INSERT INTO pwg_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Ravi ipika na Leiban natuna Liya irutini Jeikap kurina ma iverei da yavata ikena. ");
INSERT INTO pwg_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Ma bade Leiban ina bigabiga wavinena Silpa irutini da natuna Liya iverei da ina bigabiga wavinena. ");
INSERT INTO pwg_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Mara itom ma mara boiboiyai Jeikap ipanani da wavinena ke Risera, tuna na Liya. Maninina inae Leiban kurina ma ivonei bo, “Avi kubiine weni berana kuberai kuriku? Taku Risera kubiine abigem ma avi kubiine kuvi beroberoweku?” ");
INSERT INTO pwg_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Leiban ivonapotei bo, “Weni dobunai akii kiki evonavona da ke vaghina da wavine murimurina ini nao ina tavine ma iyarokona ini muri. ");
INSERT INTO pwg_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Kevi vaghinei da madegha miikovimaruwa ku tepana kuna biga na weni tavinena kamporaghina ina kovi na Risera ana verem da kuna ravaghi.” ");
INSERT INTO pwg_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Ma Jeikap ivi vaghinei na nani kamporaghina ivi koviya murinai na Leiban bade natuna Risera irutini ma Jeikap iverei da kawana. ");
INSERT INTO pwg_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Ma Leiban ina bigabiga wavinena Biliya irutini da natuna Risera iverei da ina bigabiga wavinena. ");
INSERT INTO pwg_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Jeikap bade Risera yavata ikena ma ina nuwaviina ghamana na Risera kurina, ke Liya. Ma vaghina, madegha miikovi ma ruwa ku tepana Leiban kubiine ibiga. ");
INSERT INTO pwg_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Bada ikitai da Jeikap, Liya ke iti nuwaviina kirakiiyei na iberai da tuna na kovokovoghina da iti tuwa ma Risera na kegha. ");
INSERT INTO pwg_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Liya iropeya ma ivi tuwa da natuna tomowa ma ivi vavei ‘Ruben’ ma ivona bo, “Bada aku nuwapoya iakovi ma wekarakava na kawaku ini nuwaviineku.” ");
INSERT INTO pwg_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Liya bade iropeyame ma ivi tuwa da natuna tomowa ma ivona bo, “Bada ivi yanei da kawaku ke iti nuwaviina kirakiiyeku, tuna kubiine natuku tomowa kana viruwa ivereku kana vava ‘Simiyon.’ ” ");
INSERT INTO pwg_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Ma bade iropeyame ma ivi tuwa da natuna tomowa, ivi vavei ‘Livai’ na ivona bo, “Natunatuku tomotomowa ivi aroba avi tuwesi, tuna kubiine wekarakava na kawaku nakeda ini nuwaviina kirakiiyeku ma kuriku ini riya.” ");
INSERT INTO pwg_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Ma bade iropeyame ma ivi tuwa da tomowa ma ivona bo, “Wekarakava na Bada ana vokavakavari.” Tuna kubiine ivi vavei ‘Juda,’ vaghina ma vituwa ivoterei. ");
INSERT INTO pwg_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Ma Risera inotameyei da tuna Jeikap ke ita vivituwei na genebuna inuwakapiyei. Tuna kubiine Jeikap ivonei bo, “Aku kayowana da ati tuwa. Ke ani tuwa na ana rabobo.” ");
INSERT INTO pwg_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Jeikap nuwanuwana ipughu da ivona bo, “Taku avai, taku ke kovokovoghina da God kana gawara ata viiya. Tuna iberim da ke kuta vivituwa.” ");
INSERT INTO pwg_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Vaghina ma Risera ivona bo, “Aku bigabiga wavinena Biliya weni, ma tuna yavata kona kena da ini tuwa da natunatuku. Ma tuna tepanai na taku bade aku rakaraka ina rakata.” ");
INSERT INTO pwg_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Tuna kubiine Risera ina bigabiga wavinena Biliya irutini Jeikap kurina da yavata ikena. ");
INSERT INTO pwg_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Biliya iropeya ma ivi tuwa da natuna tomowa. ");
INSERT INTO pwg_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Vaghina ma Risera ivona bo, “God ivi kamyuyuweku ma aku tou ivi yanei da natuku tomowa ivereku.” Weni berana kubiine ivi vavei ‘Dan.’ ");
INSERT INTO pwg_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Risera ina bigabiga wavinena ivi tuwame da natuna tomowa. ");
INSERT INTO pwg_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Ma Risera ivona bo, “Avi paparana kirakai da genebuku aghekuyowei.” Tuna kubiine nani tomowa kikina ivi vavei ‘Napitali.’ ");
INSERT INTO pwg_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Liya damina iviiya da vituwa ivoterei na ina bigabiga wavinena Silpa irutini Jeikap kurina, iverei da kawana. ");
INSERT INTO pwg_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Vaghina Silpa ivi tuwa da natuna tomowa. ");
INSERT INTO pwg_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Ivi tuwa na Liya ivona bo, “Aku nuwabiibai irakata.” Tuna kubiine Silpa natuna ivi vavei ‘Gedi.’ ");
INSERT INTO pwg_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Liya ina bigabiga wavinena Silpa ivi tuwame da natuna tomowa. ");
INSERT INTO pwg_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Vaghina ma Liya ivona bo, “Avi nuwabiibii kirakai! Karako wivine ina voneku bo, ‘Nuwabiibai wavinem.’” Tuna kubiine Silpa natuna ivi vavei ‘Asera.’ ");
INSERT INTO pwg_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Witi borina kana mara ma Ruben ikiibau ku warere da vituwa kana gegura irupanapanana na iyuna ma inae da ina maduwa Liya iverei. Risera inae da Liya ivonei bo, “Natum ina gegura ma kade ruwa kava kuta vereku bo kegha?” ");
INSERT INTO pwg_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Liya ere nuwapughupughuna ivonapotei bo, “Tam namada kawaku kuyapiya ma kekayokayowei da bade natuku ina gegura kuna viiya bo?” Ma Risera ivona bo, “Mikeda natum ina gegura kuna vereku na ani vaghinei da karako didibarai Jeikap yavata kona kena.” ");
INSERT INTO pwg_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Nani ravinai Jeikap witi vaonai ivovovira na Liya iverupotei ma ivonei bo, “Tam karako yavata takena, iyamna tam namada natuku ina gegurai agimarim ikovi.” Vaghina ma, nani didibarinai inae da Liya yavata ikena. ");
INSERT INTO pwg_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","God, Liya ina nipowana ivi yanei na iberai da iropeya ma natuna tomowa kana vimiikovi ivi tuwei. ");
INSERT INTO pwg_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Ma Liya ivona bo, “God aku miiya ivereku iyamna aku bigabiga wavinena arutini kawaku kurina da averei.” Tuna kubiine natuna ivi vavei ‘Isaka.’ ");
INSERT INTO pwg_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Liya iropeyame ma natuna tomowa kana vimiikovi ma sago ivi tuwei. ");
INSERT INTO pwg_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Ma Liya ivona bo, “God puyo kiimatanina ivereku. Wekarakava na kawaku ina vokaraveku, natunatuna tomotomowa ivi miikovi ma sago avi tuwesi kubiine.” Ma natuna ivi vavei ‘Sebulun.’ ");
INSERT INTO pwg_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Ma tuna murinai na Liya ivi tuwame da natuna wavine ma ivi vavei ‘Daina.’ ");
INSERT INTO pwg_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Vaghina ma God, Risera inotai ma ina nipowana ivi yanei. Iberai da kovokovoghina da iti tuwa. ");
INSERT INTO pwg_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Risera iropeya ma ivi tuwa da natuna tomowa ma ivona bo, “Aku vinimaya God iviitawei.” ");
INSERT INTO pwg_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Ma ivi vavei ‘Josepa,’ ma ivona bo, “Ainowi Bada kurina da natuku tomowa sago ina veremeyeku.” ");
INSERT INTO pwg_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Josepa itupuwa murinai Jeikap inae da Leiban ivonei bo, “Kade kuti vaghinei da ata nae aku ku dobu? ");
INSERT INTO pwg_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Kakawaku ma natunatuku kevereku iyamna ti kubiisi na biga ghamanakina aberai tam kubiim. Ma karako kevotereku da ana nae. Kuakovi da biga irakata kirakai aberai kubiim.” ");
INSERT INTO pwg_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Leiban ivona bo, “Aku sisiya kevi yanei, tam tepamuwai da Bada ivi biibiiniku da mura ghamanakina apanani. Kade gwabikuwai kuta makai mara gisina. ");
INSERT INTO pwg_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Ma kevoneku am kayowana aviyavisina da ana verem.” ");
INSERT INTO pwg_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Jeikap ivonapotei bo, “Kuakovi da kubiim abiga kirakai ma kuakovi da aku vikoyakoyagha kamonai na am ghamoghamo ivi koroto da irakata. ");
INSERT INTO pwg_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Apisi na am mura na gisina ma wekarakava na am mura irakata kirakai ma aviyavisina peyarina aberaberai na Bada ivi biibiini. Ma wekarakava na taku ikikava? Avi maranai taku mani aku rakaraka kubiisi ana biga?” ");
INSERT INTO pwg_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Leiban ivi tarakiiyanei bo, “Aviyavisina ana verem?” Ma ivonapotei bo, “Kesago aviyavisina kuna vereku da bera sago kava kuna berai kubiiku na patana da am ghamoghamo ana koyagha bubunisi ma ana kitaruvisi. ");
INSERT INTO pwg_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Karako aku kayowana da am ghamoghamo kamosiyai na sipu dumadumasi ma bade gote bodayarayaraghisi ma punepunesi ana yuna da ti na aku miiya. ");
INSERT INTO pwg_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Karakava mara epipisi da kuna panani da taku bera maninina aberai. Mikeda kuna pisi da aku miiya ghamoghamosi kamosiyai kuna panani da gote ke bodayarayaraghisi ma ke punepunesi ma bade sipu ke dumadumasi na kunakovi da ti na gwabimuwai ayapi.” ");
INSERT INTO pwg_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Leiban ivonapotei bo, “Vaghina, am kayowanai taberai.” ");
INSERT INTO pwg_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Ma nani murinai Leiban ikiibau da gote tomotomowisi ma wivinesi bodayarayaraghisi ma punepunesi, bo kii kiruma poipoisi ma bade sipu dumadumasi na peyarisi irutinisi inae da natunatuna tomotomowisi iveresi da ita koyaghisi. ");
INSERT INTO pwg_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Ma natunatuna nani ghamoghamosi irutinisi na ivomiiri da Jeikap ina makamakai gawarina ikuyowei ma ibaba da mara aroba ikovi. Ma Jeikap imakai da Leiban ina ghamoghamo makiiterena patana da ikoyakoyaghisi. ");
INSERT INTO pwg_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Vaghina Jeikap inae da popla da amond da plein kiisi ragharaghasi iyuna da ikiruma, bekasi nevanevasi ipapa da kiisi ragharaghasi na kii kiruma poipoisi irumatara. ");
INSERT INTO pwg_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Jeikap nani kiisi ragharaghasi iyuna da ghamoghamosi i umuma sigasi maghinosiyai itura. Nani dobunai itura iyamna ghamoghamo ipipisi uma kubiine na nani dobunai ivivi momorana. ");
INSERT INTO pwg_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Nani kiisi kirukirumisi maghinosiyai ivivi momorana na ivivi tuwa da natunatusi na bodayarayaraghisi, punepunesi ma kirukirumisi. ");
INSERT INTO pwg_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Jeikap ina sipu da gote gegeyisi ivinetawesi da bogiiyai iteresi. Ma iberisi da karosi ivirei Leiban ina ghamoghamo bodayarayaraghisi ma punepunesi kurisi iterei. Nakanani iberai da tuna ina ghamoghamo yavosi ivi rakati ma bogiiyai iteresi, ke Leiban ina ghamoghamo yavata iti kapusi. ");
INSERT INTO pwg_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Ma meni ghamoghamosi rewapanisi ivivi momorana na Jeikap nani kiisi kirukirumisi iyuyuna da kii siga kamosiyai itutura da nani kiisi barasiyai ivivi momorana. ");
INSERT INTO pwg_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Ma meni tusi mitamitasi ivivi momorana na nani kiisi ragharaghasi ke maghinosiyai ita tutura. Tuna kubiine rewapanisi natunatusi na Jeikap iyuyuna ma mitamitasi na Leiban rapenai. ");
INSERT INTO pwg_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Jeikap weni nakanani iberai na ina mura irakata, ina ghamoghamo yavoyavosi ipeyari. Ma bade ina bigabiga tomotomowisi ma wivinesi ipeyari, ina kamel ma bade ina donki ipeyari. ");
INSERT INTO pwg_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Jeikap sisiya ivi yanei da Leiban natunatuna ivivi sisiya ivonavona bo, “Jeikap ita mamai ina bera kudubina iyabigogona yavui. Ma ina mura na ita mamai gwabinai.” ");
INSERT INTO pwg_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Ma Jeikap damina iviiya da Leiban ina bera ma ina yawasa na ivirai ke kunona nakanani. ");
INSERT INTO pwg_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Vaghina ma Bada, Jeikap ivonei bo, “Kevovirame am ku dobu vaghata da meni dobunai am mami mau ma am rakaraka imakamakai nake, ma taku na tam yavata.” ");
INSERT INTO pwg_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Tuna kubiine Jeikap sisiya ivonatawei Risera da Liya kurisi da ikiibau da meni dobunai ina sipu ikoyakoyaghisi nake. ");
INSERT INTO pwg_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Jeikap kakawana ivonesi bo, “Akitai da ami mamai na ina bera ma ina yawasa na ke ita biibai taku kuriku kunona nakanani, ma kegha da aku mamai ina God na taku gwabikuwai emakamakai ma ekoyakoyaghiku. ");
INSERT INTO pwg_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Tami ami viruwa koakovi da nuwanuwaku kudubinai ami mamai kubiine abiga. ");
INSERT INTO pwg_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Ma kegha, ami mamai ivivi beroberoweku da aku miiya na mara imaruwa nakanani iviravirai. Ma God ke iti vaghinei da ku tepana ita kiiviberoku. ");
INSERT INTO pwg_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Kunona Leiban ivona bo, ‘Gote ini tuwa da punepunesi na natunatusi rapemuwai, am miiya. Ma vaghina, nani murinai ivi tuwa da peyarisi na punepunesi kavakava.’ Muriyai ina nota ivi rai na ivona bo, ‘Ini tuwa da bodayarayaraghisi na ti kava rapemuwai, ma vaghina, ivi tuwa da bodayarayaraghisi kavakava.’ ");
INSERT INTO pwg_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Nakanani ivi tuwa da ghamoghamo yavosi ami mamai gwabinai na God iviitawei da taku ivereku. ");
INSERT INTO pwg_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Ghamoghamo ivivi momorana maranai ma avi matu da gote tomotomowisi ivivi momorana na peyarina bodayarayaraghisi ma punepunesi kavakava. ");
INSERT INTO pwg_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Ma aku matu kamonai na aneya ivi sisiya kuriku ivona bo, ‘Jeikap.’ Ma avonapotei bo, ‘Taku weni.’ ");
INSERT INTO pwg_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Aneya ina sisiya ikwapanatini ivona bo, ‘Kekitai, gote tomotomowisi ididiwana na bodayarayaraghisi ma punepunesi kavakava.’ Akitai da Leiban aviyavisina eberaberai kurim, tuna kubiine weni berana aberai. ");
INSERT INTO pwg_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Taku na God, Betel dobunai taku anekiibau kurim. Nani dobunai wakima kuvi miirini ma kuvi biibiini ma am vonakiiyapa bagibagina kuberai kuriku. Ma wekarakava na kevovunagha da kuna vovirame am ku dobu kutupuwa nake.” ");
INSERT INTO pwg_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Risera da Liya, Jeikap ivonapotei bo, “Kesago aviyavisina ita makamakai akii mamai gwabinai da akii buderi kana viiya. ");
INSERT INTO pwg_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Ma iberikai da tokai nakanani ma dobu viruwa wawayikai, ivi gimarekai ma manena kubiikai na ibera wapawapai. ");
INSERT INTO pwg_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Ma vona bubuna da mura kudubina God akii mamai gwabinai iviitawei na tokai ma natunatukai rapekiiyai. Tuna kubiine God ikikava evonavonem na nununai keberai.” ");
INSERT INTO pwg_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Vaghina ma Jeikap kakawana ma natunatuna ku kamel ivi gerusi. ");
INSERT INTO pwg_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","Ma ina ghamoghamo yavoyavosi ma aviyavisina kudubina Padan Aram kamonai ipanapanani na peyarina iviiviiya da yavata ita nae ku Keinan, ina mamai Aisiki kurina. ");
INSERT INTO pwg_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Ma Risera na iakovi da Leiban inae da ina sipu vunivunisi ivivi gharitaweyana tuna kubiine ina ku numa irui da kana kokoitau iyapi. ");
INSERT INTO pwg_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Ma bade Jeikap na Leiban ivi beroberowei, ke ita vonei da ivomiiri, matagavunai inae. ");
INSERT INTO pwg_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Aviyavisina peyarina rapenai na iyuna yavui ma yaghiyaghinai iverau, Yuperetis okowina idamani da ita nae ku Giliyadi koyasi. ");
INSERT INTO pwg_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Mara aroba murinai wawaya inae Leiban ivi akovi da Jeikap iverau. ");
INSERT INTO pwg_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Leiban ina wawaya iviinisi ma Jeikap iverukivini da mara miikovi ma ruwa murinai Giliyadi koyasiyai ivotanisi. ");
INSERT INTO pwg_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Nani maranai, God inekiibau Leiban kurina, ina matu kamonai ivonei bo, “Kawam kekoyagha bubuni, ke avi sisiyina berona kuna karatawei da Jeikap kuni yabuyabumani.” ");
INSERT INTO pwg_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Giliyadi koyasi tepanai Jeikap ina taki iyamoni ma i yobe itina. Muriyai Leiban ina wawaya yavata inekiibau na bade nani koyasiyai i taki iyamoni da Jeikap mau ririsiyai. ");
INSERT INTO pwg_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Ma Leiban inae da Jeikap ivonei bo, “Avi kubiine kuvi matagavugavuweku da natunatuku wivinesi kuveruwesi da ti nakanani ma ghaviya kamonai kuta panisi na kuta veruveruwesi? ");
INSERT INTO pwg_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Avi kubiine kuvi beroberoweku da ke kuta voneku ma kuonagha da kunae? Ma kuta voneku na nuwabiibiiyai gita ma enava kata ravi ma tavotavoriyai kata vonatawemi. ");
INSERT INTO pwg_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Ma ke sago kuti akoviku da natunatuku ma tuputupuku ata yonisi ma ati kiruruwesi ma kota nae. Weni tuna na bera neghaneghana kuberai. ");
INSERT INTO pwg_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Taku rewapana gwabikuwai emakamakai da ati kiiviberom, ma kegha da didibarai am mamai ina God ivoneku bo, ‘Ke sago avi sisiyina berona kuna karatawei da Jeikap kuni yabuyabumani.’ ");
INSERT INTO pwg_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Ma akovi da am kayowana ghamana da kuta vovira am mamai ina ku dobu. Ma avi kubiine aku numa kana kokoitau kuyapi?” ");
INSERT INTO pwg_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Jeikap, Leiban ivonei bo, “Ayabumanem, iyamna anotai da natunatum wivinesi gwabikuwai kuta kayoviitawesi. ");
INSERT INTO pwg_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Ma mikeda wawaya sago kuna panani da am kokoitau iyapi na tuna wawayina na ina rabobo. Ita wawaya matasiyai na am sawara kekwa ma kuna panani da tam rapemuwai na kuna yuna.” Ma Jeikap ke itakovi da Leiban ina kokoitau na Risera iyapi. ");
INSERT INTO pwg_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Vaghina Leiban irui Jeikap ina ku yobe ma bade irui Liya ina ku yobe ma ke sago aviyavisina ita panani. Nani murinai na irui Risera ina ku yobe. ");
INSERT INTO pwg_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Ma Risera, Leiban ina kokoitau iyuna da ina kamel kana ku makamakii gaburinai ituragavugavu ma imakiitani. Leiban yobe kamonai igini yavui ma kesago aviyavisina ita panani. ");
INSERT INTO pwg_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Risera ina mamai ivonei bo, “Aku bada ke nuwanuwam ina pughu, taku ke ruvaruvana maghinomuwai ana vomiiri, taku na nawaravi aviiya.” Ma Leiban iekwa da ke sago ina kokoitau ita panani. ");
INSERT INTO pwg_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Jeikap nuwanuwana ipughu kirakai Leiban kurina da ivonei bo, “Aviyavisina abera beroi?” Ma bade ere nuwapughupughuna ivi tarakiiyanei bo, “Ikikava abera beroi da taku kekwavikwaviniku nakanani ma taku ghamoghamo dipa? ");
INSERT INTO pwg_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Wekarakava na aku sawara peyarina kugini yavui ma kamonai na aviyavisina sago tam rapemuwai kupanani. Avi kava kupanani boni na am wawaya ma aku wawaya maghinosiyai keterekiibuwei da ina kitai ma ti ina voneta da iyi ivonavaghata. ");
INSERT INTO pwg_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Taku na madegha 20 gwabimuwai amakai ma am ghamoghamo akoyaghisi da kesago iti tuwa bero, ma bade kesago am ghamoghamo kamosiyai sipu tomowina sago siyana ata kam tovoni. ");
INSERT INTO pwg_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Ma maranai am ghamoghamo sago ghamoghamo dipa ivowai na nani tarabogina na taku mani agudugudui. Ma kuvoneku da ghamoghamo sago wawaya ina yapini madeghai bo didibarai na taku mani ani teparari. ");
INSERT INTO pwg_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Mara ipeyari madegha ikariku da avi kamaghiyei ma bade didibarai nuba ivowavowiku da ke ruvaruvana ata kena. ");
INSERT INTO pwg_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Ma nakanani amakai da madegha 20 ikovi gwabimuwai. Madegha 14 na natunatum wivinesi ivi ruwa kubiisi avi uratamana ma madegha 6 na am ghamoghamo akoyaghisi ma kuvomiiri da aku miiya mara 10 nakanani kuvirai. ");
INSERT INTO pwg_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Ma mikeda aku mamai ina God, tuna Abraham ma Aisiki i God gwabikuwai kegha na vonavaghata da namada imaku kwebuna ma kuta vonataweku. Ma kegha da God aku nuwapoya ma aku biga aberai na ikitai na didibarai inekiibau kurim da itupavimaninimu.” ");
INSERT INTO pwg_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Leiban, Jeikap ivonapotei bo, “Weni wivinesi na taku natunatuku ma natunatusi na taku tuputupuku ma ghamoghamosi na taku aku ghamoghamo. Ma vonavaghata da bera kudubina weni dobunai kekitakitai na taku rapekuwai. Ma wekarakava na taku ke ruvaruvana da aviyavisina ana berai da natunatuku ma tuputupuku ana votanisi. ");
INSERT INTO pwg_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Ma vaghina, kepisi da tam ma taku vivaghina makamakiina taberai. Wakima tidaburi da tuna takitakitai na ita vivaghina makamakiina tanotai.” ");
INSERT INTO pwg_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Vaghina Jeikap wakima sago gurina iviiya ma ivi miirini da i matakira. ");
INSERT INTO pwg_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Ma ina wawaya ivonesi da wakima viya iyuna ma ivi daburi. Ma nani wakimina daburina baranai imakai da ikam. ");
INSERT INTO pwg_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Leiban nani gawarina ivi vavei ‘Jega Sayaduta’ ma Jeikap nani gawarina ivi vavei ‘Galidi.’ ");
INSERT INTO pwg_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Ma vaghina, Leiban, Jeikap ivonei bo, “Weni wakimina daburina na imatakira da tam ma taku vimakiibero tavoterei.” Tuna kubiine nani gawarina ivi vavei ‘Galidi.’ ");
INSERT INTO pwg_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Ma ina sisiya ikwapanatini ivona bo, “Ainowi Bada kurina da maranai weni gawarinai tibogebogeta na ina koyagha bubunita.” Tuna kubiine nani gawarina kana vava sago na ‘Mispa.’ ");
INSERT INTO pwg_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Ma ivoname, “Mikeda natunatuku wivinesi ke kuna koyagha bubunisi bo wivine bogiiyai kuna ravaghisi na namanaki da ke anakovi ma kenotai da God na ekitakitita.” ");
INSERT INTO pwg_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Ma bade ivonei bo, “Wakima avi daburi weni, tam ma taku kamoputiyai ma wakima kuvi miirini weni. ");
INSERT INTO pwg_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Weni wakimina daburina ma weni wakimina miimiirina na matakira da tam ma taku ita viparaparata. Taku ke meyani ana damani da ani ghaviyem ma bade ke kuna damani da kuni ghaviyeku. ");
INSERT INTO pwg_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Ma ainowi da mikeda taku ana beraberoi bo tam kuna beraberoi, na God ina tupavimaninita ma kovogha ina rereghi. Tuna na am doboro Abraham da am nosi Nayo i God.” Ma vaghina, Jeikap vonakiiyapa bagibagina iberai da nani vivaghina makamakiina ke ini kiigiiyei. God avanai ivonakiiyapa, tuna God na ina mamai Aisiki ere yabuyabumanina ivovokavakavari. ");
INSERT INTO pwg_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Ma ghamoghamo sago ikiivunui da koya tepanai isuwara God kurina ma ina wawaya ikwatusi ipisi da yavata ikam. Ikam ikovi ma koya tepanai ivi keneyana. ");
INSERT INTO pwg_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Mara itom ma mara boiboiyai Leiban tuputupuna da natunatuna iyonisi ma ivi biibiinisi, ivoteresi ma ivovira ina ku dobu. ");
INSERT INTO pwg_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Jeikap bade ivomiiri inenae da God ina aneaneya ketiyai iverupotesi. ");
INSERT INTO pwg_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Ikitisi na ivona bo, “Weni tuna na God ina taki.” Tuna kubiine nani gawarina ivi vavei ‘Mayanaim.’ ");
INSERT INTO pwg_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Inenae na yonayona ivonatawesi ivi nao ina tuwa Iso kurina, Edom dobuna kamonai, dobuna kana vava sago na Seya. ");
INSERT INTO pwg_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Ma ivonaviyoyovanesi bo, “Konae da aku bada Iso kana sisiya weni nakanani kovonei, ‘Taku na am bigabiga Jeikap ma ani akovim da weni marana gurigurina Leiban yavata kamakamakai da karako na weni. ");
INSERT INTO pwg_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Taku gwabikuwai na kau, donki, sipu, gote ma bigabiga wawayisi tomotomowisi ma wivinesi. Ma wekarakava na sisiya avonavonatawei tam aku bada kurim. Ainowi da kade kuni vaghinei da tam ma taku tinuwasago bo kegha.’” ");
INSERT INTO pwg_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Yonayona wawayisi ivovira Jeikap kurina ma ivonei bo, “Tokai kanae am tuwa Iso kurina ma tuna na namada epipisi da ina verupotem ina wawaya ivi 400 yavata.” ");
INSERT INTO pwg_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Jeikap weni sisiyina ivi yanei na iyabumana ma ivi nuwapoya kirakai. Ina wawaya ivorereghisi da koroto ruwa iyamoni ma nakanani bade ina sipu, gote, kau ma kamel yavata. ");
INSERT INTO pwg_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Inota da Iso ina pisi da koroto sago ina ravisi na koroto sago na inonagha. ");
INSERT INTO pwg_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Vaghina ma Jeikap inipowana ina doboro Abraham da ina mamai Aisiki i God kurina, ivona bo, “Bada tam kuvoneku, ‘Kevovira am ku dobu, am rakaraka kurisi ma ana berai da am mura ina rakata.’ ");
INSERT INTO pwg_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Taku ke wawaya kiimatana ma kegha da am agabiibai ma am nuwaviina kuriku irakata da bera biibiisi ipeyari kuberai taku am bigabiga kubiiku. Rorova kava imakuwai na diwona kava ma Jodan okowina adamani ma karako na aku koroto ruwa itupuwa. ");
INSERT INTO pwg_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Ma aniponipowana da kevi tarapaparaneku da aku tuwa Iso ke ina kiivunuku, iyamna ayabuyabumana da ina pisi na ina raviku ma bade maduwa mau natunatusi yavata ina ravisi. ");
INSERT INTO pwg_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Kenotai da kuvoneku bo, ‘Vonavaghata, ana berai da am mura ina rakata ma ana berai da tupurereghim ina peyari da nakanani ma gonugonu kikirai, iyava kavakavana.’” ");
INSERT INTO pwg_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Didibarai Jeikap nani dobunai ikena. Mara itom na aviyavisina gwabinai na biibiisi ivovinesi da ina tuwa Iso ita puyoi. ");
INSERT INTO pwg_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","Weni nakanani ivovinesi. Gote wivinesi ivi 200 ma bade tomotomowisi ivi 20, sipu wivinesi ivi 200 ma bade tomotomowisi ivi 20. ");
INSERT INTO pwg_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","Ma kamel ivi 30 wivinesi ere natunatusi ma kau wivinesi ivi 40 ma tomotomowisi ivi 10. Ma bade donki wivinesi ivi 20 ma tomotomowisi ivi 10. ");
INSERT INTO pwg_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Ivinesi ikovi na iyavo nununai itura ma ina bigabiga ivonesi da sagosago duma na yavosi ita koyaghisi. Ma ivona bo, “Kovi nao, ma kokitaruvai da taraboga nani yavosi basusiyai ina makai.” ");
INSERT INTO pwg_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Ma vinoraveraveyana wawayina sisiya bagibagina iverei, ivonei bo, “Aku tuwa Iso ina nepotemi ma ini tarakiiyanem, ‘Tami iyi ina wawaya ma mike konenae ma weni ghamoghamosi maghinomiyai na iyi rapenai?’ ");
INSERT INTO pwg_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","Ma weni nakanani kuna vonapotei bo, ‘Am bigabiga Jeikap rapenai. Ma weni ghamoghamosi ivonatawei tam ina bada kurim, ina puyom. Ma wawayina na murikiiyai vaghata epipisi.’” ");
INSERT INTO pwg_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Ma bade bigabiga wawayisi kana viruwa da kana viaroba ma iyavo kava nani yavosi ivivi noravesi na peyarisi sisiyina sago iveresi. “Iso kona panapanani na bade sisiyina sago kovonei. ");
INSERT INTO pwg_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Ma konota bogai da weni nakanani kona vonei, ‘Am bigabiga Jeikap murikiiyai vaghata epipisi.’” Jeikap namada ina nota irereghi da ivona bo, “Weni puyosi ana vonatawei ini nao da aku tuwa nuwanuwana ani nubai. Muriyai ana nepotei na aku berona ina notatawei.” ");
INSERT INTO pwg_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Vaghina ma Jeikap ina puyo ivi nao inae ma tuna na ina takiyai ikena. ");
INSERT INTO pwg_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Nani didibarinai Jeikap ivomiiri da kakawana ruwa ma ina bigabiga wivinesi ruwa ma natunatuna tomotomowisi ivi 11 irutinisi da Jaboki okowina ivi damanisi. ");
INSERT INTO pwg_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Ivi damanisi ikovi ma murinai na bade ina sawara kudubina ivi damani. ");
INSERT INTO pwg_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Ma Jeikap ina kina kava imakai. Ma tomowa sago ipisi da yavata ivi vowa inene da gisina kava da mara iti kwata. ");
INSERT INTO pwg_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Ma tomowina damina iviiya da ke ruvaruvana da Jeikap ita ghetani na ivororona da Jeikap geyageyana ikiitovoni. Ma vaghina ivivi vowa kamonai ma Jeikap damina iviiya da geyageyana itamotawe. ");
INSERT INTO pwg_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Muriyai tomowina ivona bo, “Mara ikwata ma kevotereku ana nae.” Ma Jeikap ivonapotei bo, “Kuni biibiiniku na ana voterem da kuna nae.” ");
INSERT INTO pwg_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Tomowina Jeikap ivi tarakiiyanei bo, “Kam vava iyai?” Ma ivonapotei bo, “Jeikap.” ");
INSERT INTO pwg_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Vaghina tomowina ivona bo, “Kam vava Jeikap na karako ikovi. Tam na God ma wawaya yavata kovi vowa da kughetanisi, tuna kubiine kam vava vuna na ‘Israel.’ ” ");
INSERT INTO pwg_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Vaghina Jeikap ivona bo, “Ma kade kam vava kuta voneku.” Ma tomowina ivonapotei bo “Avi kubiine kekayokayowei da kaku vava kunakovi?” Ivi sisiya ikovi na Jeikap ivi biibiini. ");
INSERT INTO pwg_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Tuna kubiine nani dobuna ivi vavei ‘Peniyel.’ Jeikap nani dobunai ivona bo, “God yavata kavi kitapoteyana ma patana da taku yawayawaku, ke ata rabobo.” ");
INSERT INTO pwg_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Madegha ighetawei igheghae ma Jeikap, Peniyel ikiibutawei ma geyageyana itamotawe kubiine ivivi sike. ");
INSERT INTO pwg_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Tuna kubiine nani maranai da ku karako na Israel damsi na ghamoghamo viyosi geyageyasi baranai ke ita kamkam. Tomowina Jeikap geyageyana ikiitovoni da ikiitawei. ");
INSERT INTO pwg_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Jeikap itepa ma ikitai da Iso ina wawaya ivi 400 yavata ipipisi. Tuna kubiine natunatuna ivorereghisi da Liya, Risera ma bigabiga wivinesi ruwa gwabisiyai. ");
INSERT INTO pwg_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Ma ina bigabiga wivinesi ere natunatusi na maghinonai iteresi, iteretani na Liya ere natunatuna ma Risera da Josepa kii muri itupotai. ");
INSERT INTO pwg_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Jeikap ivi nao inae ma inenekiibau varesina kurina na mara ivi 7 ku dowa irunoma. ");
INSERT INTO pwg_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Ma Iso iverau da tina kikei itaraghavui, iyoni ma ivi tutuwana. ");
INSERT INTO pwg_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Vaghina ma Iso itepa ma ikitavirevire da wivine ma ededa yoghoyogho ikitisi ma ivi tarakiiyana bo, “Weni wawayisi na iyavo?” Ma Jeikap ivonapotei bo, “God ina agabiibai irakata kirakai da weni wawayisi ivereku.” ");
INSERT INTO pwg_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Vaghina ma bigabiga wivinesi ere natunatusi ivi nao inae da Iso maghinonai irunoma. ");
INSERT INTO pwg_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Iteretani na Liya ere natunatuna ipisi da Iso maghinonai irunoma, turina na Josepa da Risera ipisi da Iso maghinonai irunoma. ");
INSERT INTO pwg_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Iso ivi tarakiiyana bo, “Avi berana kuberai da weni ghamoghamosi kuvi vonataweyana ivi nao na averupotesi?” Jeikap ivonapotei bo, “Aku bada, weni berana aberai na tam kuta kitai da kuti turaneku bo kegha.” ");
INSERT INTO pwg_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Ma Iso ivona bo, “Kegha, varesiku. Taku gwabikuwai ipeyari kirakai ma aviyavisina kupipiyei na kevotani da kubiim.” ");
INSERT INTO pwg_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Ma Jeikap ivona bo, “Kegha. Mikeda nuwanuwam kudubinai kituraneku na vaghina ainowi kurim da weni puyosi avereverem na keviiya. Maghighim akitai na nakanani ma God maghighina ata kitakitai. Wekarakava ainuwabiibai da kuvi turaneku. ");
INSERT INTO pwg_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Ma ainowi kurim da weni puyosi apipiyei na keviiya, God ina agabiibai irakata kuriku kubiine. Taku gwabikuwai ipeyari kirakai da isasara.” Jeikap ina sisiya ivi rewapana kirakai da turinai na Iso ivi vaghinei da puyosi ivopotei. ");
INSERT INTO pwg_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Vaghina Iso ivona bo, “Wekarakava tavomiiri, taku yavata tanae patapata.” ");
INSERT INTO pwg_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Ma Jeikap ibara, tuna kubiine ivona bo, “Aku bada, kuakovi da ededa na mitamitasi ma bade aku ghamoghamo nakanani ere natunatusi ana kitaruvisi. Mikeda mara sago kamonai ana tupesi da ina baba kupom na ghamoghamo ina rukwa. ");
INSERT INTO pwg_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Ma taku am bigabiga ainowi kurim, aku bada, da tam kevi nao. Ma taku na muriyai ededa da ghamoghamo natunatusi yavata kii neyai ana nae na nuwatuwai ana pisi da Seya dobunai Edom kamonai ana pananim.” ");
INSERT INTO pwg_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Ma Iso ivona bo, “Vaghina ma aku wawaya viya gwabimuwai ana voteresi da ini vitem.” Ma Jeikap ivonapotei bo, “Namanaki. Namada nuwanuwam kudubinai kuvi vaghineku ma avi kubiine weni berana kuna berai?” ");
INSERT INTO pwg_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Ivi ruwa ivi sisiya ikovi na Iso ivomiiri da ibaba ivovira ku Seya dobuna. ");
INSERT INTO pwg_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Ma Jeikap na inae ku Sukoti ma nani dobunai numa kweta ivowa, tuna ma ina ghamoghamo kubiisi. Tuna kubiine nani dobuna ivi vavei ‘Sukoti.’ ");
INSERT INTO pwg_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Ma vaghina, nakanani itupuwa da Jeikap mau Padan Aram ikiibutawei da inae ku Sekem kwanatuna Keinan dobuna kamonai. Ma i baba kamonai na biibiina kavakava. Kwanatu ririnai ina taki iyamoni ma i yobe itina da imakai. ");
INSERT INTO pwg_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Kwanatuna kana bada na Hamo ma Jeikap inae Hamo natunatuna kurisi da taki dowana gwabisiyai igimari, miiyanina na silva riririghina ivi 100. ");
INSERT INTO pwg_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Ma nani dobunai suwara kana kema iyamoni ma ivi vavei ‘El Eloye Israel.’ ");
INSERT INTO pwg_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Mara sago Jeikap da Liya natusi wiwikena kana vava Daina inumataya inae da Keinan wivine ita kitisi. ");
INSERT INTO pwg_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Ma Hivi tomowa sago wiwikena ikitai, tomowina kana vava Sekem, tuna na Hamo natuna ma Hamo na nani dobuna paratina kana kiivavo. Vaghina ma, Daina ikitai na ivotani ma ikenei. ");
INSERT INTO pwg_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Ma wavinena ivi karawata kirakai da nuwanuwana iviiya. Tuna kubiine ivi marumarui, ina kayowana ghamana da yavata iti turana. ");
INSERT INTO pwg_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Vaghina Sekem ina mamai ivonei bo, “Aku kayowana ghamana da nani wavinena kuta viiya da kawaku.” ");
INSERT INTO pwg_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Iya mara gurina ma Jeikap akova iviiya da Sekem, Daina ikenei da Daina tupuwina ikiiviberoi. Ma Jeikap natunatuna tomotomowisi warereyai i ghamoghamo ikoyakoyaghisi kubiine ivi kawapotapota da ita vovira. ");
INSERT INTO pwg_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Sekem ina mamai Hamo yavata inae Jeikap kurina da iti sisiya. ");
INSERT INTO pwg_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Ma nani kamonai na Jeikap natunatuna warereyai inekiibau. Sisiya ivi yanei na itataghana ma nuwanuwasi ipughu kirakai da Sekem novusi ikenei. Sekem weni berana iberai na Jeikap ina rakaraka kurisi na ibero kirakai. ");
INSERT INTO pwg_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Hamo, Jeikap ivonei bo, “Natuku Sekem natum wavinena nuwanuwana ivii kirakiiyei ma ainowi da kevi vaghinei da ina ravaghi. ");
INSERT INTO pwg_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Vivaghina taberai da natunatumi wivinesi ina pisi gwabikiiyai ina tavine ma bade natunatukai wivinesi ina nae da gwabimiyai ina tavine. ");
INSERT INTO pwg_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Weni berana taberai ina kovi na aivaghinei da weni dobunai tamakai patapata. Weni dobunai kuna makai da kuni wadubo ma kuni gimagimara wapawapa.” ");
INSERT INTO pwg_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Sekem tuna mani Daina ina mamai da novunovuna kurisi ivi sisiya, ivona bo, “Ainowi da koni vaghinei da Daina ana ravaghi. Koni vaghinei na aviyavisina kona kayowei na ana veremi.” ");
INSERT INTO pwg_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Ma wavinena miiyanina na ami kayowana nununai koterepai. Ma mikeda koni vaghinei da wavinena ana ravaghi na aviyavisina kokayokayowei na peyarina ana veremi. ");
INSERT INTO pwg_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Ma Sekem bera berona iberai da novusi Daina ikenei, tuna kubiine Jeikap natunatuna tomotomowisi viberowai Sekem ina mamai Hamo yavata ivonapotesi. ");
INSERT INTO pwg_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Ivonei bo, “Ke kovokovoghina kani vaghinei da Sekem novukai ina ravaghi, iyamna ke iti tuvivira. Tomowa ke iti tuvivira ina ravaghi na berana ivi inimayamaya kirakai kurikai. ");
INSERT INTO pwg_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Ma mikeda ami tomotomowa kudubisi ini tuvivira tokai nakanani na vaghina, tokai kani vaghinei. ");
INSERT INTO pwg_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Ma bade kani vaghinei da titavine vivirana ma yavata tamakai patapata da dam sago. ");
INSERT INTO pwg_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Ke koni vaghinei da koni tuvivira na novukai kana rutini ma kana nae.” ");
INSERT INTO pwg_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Weni notana Jeikap natunatuna yavata iterei na ibiibai da Hamo natuna Sekem yavata ivi vaghinei. ");
INSERT INTO pwg_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Ma Sekem tuna Hamo ina rakaraka kamonai wawaya ghamana ma ina nuwaviina ghamana Jeikap natuna wavinena tuna kubiine avina ita virai aviyavisina ivonavonei na iberai. ");
INSERT INTO pwg_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Vaghina, Hamo natuna Sekem yavata inae i ku vidughu gawarina, i kwanatu matuketinai da tomotomowa kurisi iti sisiya. ");
INSERT INTO pwg_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","Ivona bo, “Weni damsi na turaturata, kovoteresi da ita dobuwai ina makai ma ini gimagimara wapawapa. Dowa irakata kirakai da ti kubiisi. Ma ti ma tota titavinevivirana. ");
INSERT INTO pwg_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Nani damsi ivona da ikikava ituvivira na tota tomotomowa kudubita bade nakanani tituvivira. Taberai na ini vaghinei da yavata tamakai da ti dam sago. ");
INSERT INTO pwg_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Ma weni nakanani taberai na kara i ghamoghamo ma i sawara kudubina tota tirapenei, tuna kubiine tivaghinei da yavata tamakai.” ");
INSERT INTO pwg_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Ma aviyavisina kudubina Hamo natuna Sekem yavata ivivi sisiyei na peyarina kwanatu damsi ivi vaghinei da i tomotomowa kudubisi kwimata bekasi ituvivira. ");
INSERT INTO pwg_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Mara aroba murinai patana da inivisi damina iviiviiya ma Jeikap natunatuna ruwa Simiyon da Livai, ti na Daina novunovuna, i seri iyuna ma irui ku kwanatu da wawaya imakamakii nunuwapa ma ikunisi da tomotomowa kudubisi ivi kiivunuwana yavu. ");
INSERT INTO pwg_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Ma bade Hamo natuna Sekem yavata ivi kiivunuwana ma ina numa kamonai Daina irutini da yavata inae. ");
INSERT INTO pwg_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Jeikap natunatuna viya inekiibau ma ipanani da wawaya irukwa na novusi biwana iviiya, irui kwanatu ku kamona da sawara kudubina iyapi. ");
INSERT INTO pwg_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","I sipu da i kau yavoyavosi ma bade i donki ma i sawara kudubina kwanatu kamonai ma kupunai iyapi yavui. ");
INSERT INTO pwg_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","I mura ma isawara peyarina i numa kamosiyai na ipupuna yavui. Ma bade ededa yoghoyogho ma wivine ipanisi ma irutinisi da inae. ");
INSERT INTO pwg_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Nani murinai Jeikap natunatuna Simiyon da Livai ivonesi bo, “Tami ku nuwapoya kotereku, karako Keinan damsi da Peres damsi ma nani dobuna makamakiisi kudubisi ini kawapateku. Taku aku iyo wawayisi ke ita peyari ma mikeda nani damsi ina tarakapu ma ina kayaya kuriku na ita rakaraka kudubina ina kiipupunatawei.” ");
INSERT INTO pwg_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Ma kegha, ivonapotei bo, “Ke vaghina da nani tomowina kata voterei iyamna novukai iberai da nakanani ma wavine madamadawarina.” ");
INSERT INTO pwg_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Mara sago God ivi sisiya Jeikap kurina, ivonei bo, “Kevomiiri kuna nae ku Betel da nani dobunai kuna makai. Ma nani dobunai suwara kana kema kevowai taku God kubiiku, taku rorova arumatara kurim maranai varesim Iso yabumanina kuveraverau.” ");
INSERT INTO pwg_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Tuna kubiine Jeikap ina rakaraka ma iyavo kava nani dobunai ivivi makiiyana na ivonesi bo, “Ami kokoitau kudubina kovi tawetaweyana ma kovovunagha meyemi ma kami gara biibiisi kovi kote. ");
INSERT INTO pwg_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Wekarakava na tanae ku Betel ma nani dobunai suwara kana kema ana vowai God kubiine. Tuna aku nuwapoya peyarina kamonai iviteku ma mike anenae na mara nonowa gwabikuwai.” ");
INSERT INTO pwg_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Ma vaghina peyarisi i kokoitau iviiya da iverei ma kii tinayodi ivivi kote na ivi votaweyana da bade iverei. Jeikap kudubina iyuna ma inae da Sekem kwanatuna baranai ‘oak’ kiina kunukununai idogo. ");
INSERT INTO pwg_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Idogo ikovi na ina wawaya yavata ikiibau da inae. Ma meyagai kudubisi nani dobuna kamonai wawaya ivivi makiiyana na yabumana ikunisi da ke ita verukivinisi ma ke ita kayaya kurisi. ");
INSERT INTO pwg_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Jeikap ina wawaya yavata inekiibau ku Betel (kana vava sago na Lus), Keinan dobuna kamonai. ");
INSERT INTO pwg_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Ma nani dobunai wakima ivi dabura da suwara kana kema ivowai ma dobuna ivi vavei, ‘El Betel’ iyamna nani dobunai God irumatara kurina maranai varesina yabumanina iveraverau. ");
INSERT INTO pwg_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Nani dobunai imakamakai na Rebeka kana koyakoyagha kana vava Debora irabobo. Tuna kubiine inae Betel baranai ‘oak’ kiina imiimiiri na rogunai idogoi ma dobuna ivi vavei ‘Alon Bakuti.’ ");
INSERT INTO pwg_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Rorova Padan Aram dobunai ivovira ku Betel na God inekiibau Jeikap kurina da ivi biibiini. ");
INSERT INTO pwg_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Ma ivonei bo, “Kam vava ana virai da ke Jeikap. Karako ma nake na kam vava vuna na ‘Israel.’ ” Ma vaghina, tuna maranai ivi vavei Israel. ");
INSERT INTO pwg_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Ma God ivona bo, “Taku na ‘God Rewapana Kirakiina’. Ma kevi tuwa kirakai da tupurereghim ina peyari da dam ma dam ma kiikiivavo na tami kamomiyai ina kiibau. ");
INSERT INTO pwg_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Ma tano rorova Abraham da Aisiki averesi na karako tam avereverem ma bade murimuwai tupurereghim ana veresi.” ");
INSERT INTO pwg_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Ma vaghina God, Jeikap ikuyowei. ");
INSERT INTO pwg_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Nani murinai Jeikap wakima sago ivi miirini. Ma wain da oira ku tepana itepoi ivi matakira da nani dobunai God kurina ivi sisiya. ");
INSERT INTO pwg_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Ma gawarina kana vava ‘Betel.’ ");
INSERT INTO pwg_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Jeikap ina rakaraka yavata Betel ikuyowei ma inenae da keta borinai karakava da ku Eperati ita nekiibau ma Risera damina iviiya da iti tuwa ma ipanani da ina inivisi irakata. ");
INSERT INTO pwg_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Ma ina inivisi irakarakata na ina vivowavowa wavinena ivona bo, “Ke kuna yabumana, iyamna natum na bade tomowa.” ");
INSERT INTO pwg_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Ma kegha, Risera damina iviiya da iraborabobo ma muriyai da yatupona ita tapurai na natuna ivi vavei ‘Ben Oni.’ Ma muriyai Jeikap natuna ivi vavei ‘Benjamin.’ ");
INSERT INTO pwg_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Risera irabobo na Eperati ketana baranai idogoi. Dobuna karako tavonavonei bo, ‘Beteliyem.’ ");
INSERT INTO pwg_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Ma dogona tepanai na Jeikap wakima ivi miirini da karako weni ku marana nani wakimina imatakira da nani dobunai Risera idogoi. ");
INSERT INTO pwg_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Jeikap, bo kana vava vuna na Israel, na inae Eperati kwanatuna ikuyowei ma inenae da Migidal Ede nevanai ina yobe itini ma imakai. ");
INSERT INTO pwg_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Jeikap nani dobunai imakamakai ma kamonai Ruben irui da Biliya yavata ikena. Biliya na Risera ina bigabiga wavinena ma Jeikap ivi kawanei da yavata imakai. Jeikap sisiyina ivi yanei da nuwanuwana ipughu kirakai. Jeikap natunatuna tomotomowisi ivi 12. ");
INSERT INTO pwg_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Liya natunatuna na Ruben (tuna Jeikap natuna iyarokona), ma bade Simiyon, Livai, Juda, Isaka ma Sebulun. ");
INSERT INTO pwg_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Risera natunatuna na Josepa da Benjamin. ");
INSERT INTO pwg_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Risera ina bigabiga wavinena Biliya natunatuna na Dan da Napitali. ");
INSERT INTO pwg_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Liya ina bigabiga wavinena Silpa natunatuna na Gedi ma Asera. Weni tomotomowisi peyarisi na Padan Aram kamonai itupuwamakai ma Benjamin ina kina kava na kegha. ");
INSERT INTO pwg_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Jeikap inae ina mamai Aisiki kurina ku Mamre, tuna Kiriyati Aba kwanatuna baranai, dobuna kana vava sago na Hibron. Kunona ina doboro Abraham ma ina wawaya nani dobunai ivivi makiiyana. ");
INSERT INTO pwg_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Ma vaghina, Jeikap ina mamai Aisiki imakai da kana madegha 180. ");
INSERT INTO pwg_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Imakai inae da imorapa kirakai ma irabobo ma natunatuna Iso da Jeikap idogoi. ");
INSERT INTO pwg_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Weni tuna na Iso tupurereghina i varagutugutu (Iso kana vava sago na Edom). ");
INSERT INTO pwg_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Iso kakawana ruwa na Keinan wivine kii vava Ada (tuna ina mamai Elon ma kana dam Hiti) ma Olibama (tuna ina mamai Ana, ina doboro Sibeyon ma kii dam Hivi.) ");
INSERT INTO pwg_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","Ma kana vi aroba na Basemati, ina mamai Ismayel ma novuna Nebayoti. ");
INSERT INTO pwg_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Ada ivi tuwa da natuna Elipas. Ma Basemati ivi tuwa da Rewel. ");
INSERT INTO pwg_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Ma Olibama ivi tuwa da natunatuna Jeyus, Jalam ma Kora. Weni tomotomowisi na Iso natunatuna, peyarisi na Keinan dobuna itupuwamakai. ");
INSERT INTO pwg_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Iso kakawana ma natunatuna tomotomowisi da wivinesi ma ina wawaya kudubina ma bade ina ghamoghamo ma aviyavisina Keinan dobunai iyamoyamoni na peyarina iviiya ma varesina Jeikap ikuyowei inae ku dobu sago. ");
INSERT INTO pwg_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Ikiibau inae iyamna nani dobunai imakamakai na dobu igisi ma ghamoghamo irakata da ke ruvaruvana da varesina yavata ita makii bubuna. ");
INSERT INTO pwg_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Ma vaghina Iso (kana vava sago Edom) inae da Seya koyasi tepanai imakai. ");
INSERT INTO pwg_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Weni tuna na Iso tupurereghina i varagutugutu, tuna na Edom damsi i kaekiki. ");
INSERT INTO pwg_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Iso natunatuna tomotomowisi kii vava na weni. Kawana Ada natuna na Elipas. Ma kawana Basemati natuna na Rewel. ");
INSERT INTO pwg_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Ma Elipas natunatuna tomotomowisi na Teman, Oma, Sepo, Gatam ma Kenas. ");
INSERT INTO pwg_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Ma bade bigabiga wavinena sago ivi kawanei, kana vava Timna, ma tuna ivi tuwa da natuna tomowina na Amaleki. Weni damsi na Iso kawana Ada tuputupuna. ");
INSERT INTO pwg_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Ma Rewel natunatuna tomotomowisi na Nayati, Sira, Sama ma Misa. Weni damsi na Iso kawana Basemati tuputupuna. ");
INSERT INTO pwg_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Ma Iso kawana Olibama ina mamai na Ana ma ina doboro na Sibeyon. Olibama ivi tuwa da natunatuna tomotomowisi ivi aroba, Jeyus, Jalam, ma Kora. ");
INSERT INTO pwg_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Dam kii kiikiivavo Iso tupurereghina kamonai kii vava na weni. Iso natuna iyarokona Eripas natunatuna na kiikiivavo Teman, Oma, Sepo ma Kenas, ");
INSERT INTO pwg_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","Kora, Gatam ma Amaleki. Weni tomotomowisi na Edom dobunai ivivi makiiyana. Peyarisi na Eripas tupurereghina, Ada tuputupuna. ");
INSERT INTO pwg_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Iso natuna Ruwel natunatuna tomotomowisi na kiikiivavo Nayati, Sira, Sama ma Misa. Weni tomotomowisi na Edom dobunai ivivi makiiyana. Ti na Rewel tupurereghina, Iso kawana Basemati tuputupuna. ");
INSERT INTO pwg_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Iso kawana Olibama natunatuna na kiikiivavo Jeyus, Jalam ma Kora. Weni kiikiivavosi na Ana tuputupuna. ");
INSERT INTO pwg_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Ma vaghina, nani kiikiivavosi peyarisi taviyavi ikovi na Iso natunatuna. Ma Iso kana vava sago na Edom. ");
INSERT INTO pwg_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Seya kana dam Hori ma natunatuna tomotomowisi Edom dobuna kamonai imakiiyana. Kii vava na Lotan, Sobal, Sibeyon, Ana, ");
INSERT INTO pwg_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Dison, Eseru ma Disan. Weni tomotomowisi na Seya natunatuna ma ti na Hori damsi i kiikiivavo. ");
INSERT INTO pwg_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Lotan natunatuna tomotomowisi na Hori ma Homam. Ma Lotan novuna kana vava Timna. ");
INSERT INTO pwg_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Sobal natunatuna tomotomowisi na Aruvan, Manayati, Ebal, Sepo ma Onam. ");
INSERT INTO pwg_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Sibeyon natunatuna tomotomowisi na Aya ma Ana. Ana na ina mamai ina donki warereyai ikoyakoyaghisi ma nani kamonai vusira muyamuyana ipanani. ");
INSERT INTO pwg_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Ana natunatuna ruwa, tomowina na Dison ma wavinena na Olibama. ");
INSERT INTO pwg_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Dison natunatuna tomotomowisi na Hemdan, Eseban, Itaran ma Keran. ");
INSERT INTO pwg_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Eseru natunatuna tomotomowisi na Bilan, Savan ma Akan. ");
INSERT INTO pwg_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Disan natunatuna tomotomowisi na Usi ma Aran. ");
INSERT INTO pwg_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Ma vaghina, nani kiikiivavosi peyarisi taviyavi ikovi na Seya natunatuna, ti na Hori damsi. Kii vava Lotan, Sobal, Sibeyon, Ana, ");
INSERT INTO pwg_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","Dison, Eseru, ma Disan. Ma Seya ina dobuwai kiikiivavo sagosago duma kii dam yavata imakiiyana. ");
INSERT INTO pwg_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Kunona ke wawaya sago kava iti kiivavo ghamana Israel damsi kubiisi. Nani marasiyai Edom dobuna kamonai na iyavo kava ivivi kiivavo na weni. ");
INSERT INTO pwg_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Beyo natuna Bela na Edom kubiine ivi kiivavo. Ma ina kwanatu kana vava Dinaba. ");
INSERT INTO pwg_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Bela ina rabobo murinai ma Jobabi kana gawara iviiya da ivi kiivavo. Jobabi ina mamai na Seraya ma i dobu na Bosera. ");
INSERT INTO pwg_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Jobabi ina rabobo murinai na Teman wawaya kana vava Husam ivi kiivavo. ");
INSERT INTO pwg_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Husam ina rabobo murinai na Bedadi natuna Hadadi ivi kiivavo. Tuna wawayina na Midiyan damsi ighegavovorisi Mowabi dobuna kamonai. Ma Hadadi ina kwanatu kana vava Aviti. ");
INSERT INTO pwg_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Hadad ina rabobo murinai na Samla ivi kiivavo. Ina dobu na Masireka. ");
INSERT INTO pwg_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Samla ina rabobo murinai na Sarul ivi kiivavo. Ina dobu na Reyobota, okowa baranai. ");
INSERT INTO pwg_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Sarul ina rabobo murinai na Akebora natuna Bal Anan ivi kiivavo. ");
INSERT INTO pwg_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Bal Anan ina rabobo murinai na Hadadi ivi kiivavo. Ina kwanatu kana vava Pau. Ma kawana kana vava Meyetabel, ma kawana ina maduwa na Matiredi. Ma Matiredi ina maduwa na Me Sayaba. ");
INSERT INTO pwg_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Weni kiikiivavosi na Iso tupurereghina kamosiyai ikiibau da kii dam ma i dobu nunusiyai ivivi makiiyana, kii vava tiyavi na weni. Timna, Aruva, Jeteti, ");
INSERT INTO pwg_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","Olibama, Ela, Pinon, ");
INSERT INTO pwg_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","Kenas, Teman, Mibesara, ");
INSERT INTO pwg_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","Magidiyel ma Iram. Ma vaghina, Edom damsi i kiikiivavo kii vava na tagirumi ikovi. Ma peyarisi i kaekiki na Iso. ");
INSERT INTO pwg_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Jeikap na ina mamai meni dobunai imakamakai na nani dobunai imakai, dobuna na Keinan. ");
INSERT INTO pwg_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Weni tuna na Jeikap ma natunatuna i varagutugutu. Natuna Josepa na ghamoghamo kana koyakoyagha, varevaresina yavata ikoyakoyaghisi. Tuna na yaragina, kana madegha 17 ma ti na iyarokosi, ina mamai kakawana Biliya da Silpa natunatusi. Mara sago i ghamoghamo ikoyakoyagha na Josepa varevaresina i bera ikitai ma ke iti vaghinei, tuna kubiine inae ma i berabero peyarina i mamai kurina ivi mamatarei. ");
INSERT INTO pwg_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Ma i mamai Jeikap na ina nuwaviina ghamana Josepa, ke natunatuna viya nakanani, iyamna imagura kirakai ma ivi tuwei. Mara sago Josepa kana tarasovo biibiina iyamoni da iverei. Tuna garana na gurina ma kirukirumina, ma imana gurigurina. ");
INSERT INTO pwg_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Varevaresina nani garana ikitai na damina iviiya da i mamai ina nuwaviina Josepa kurina irakata kirakai, ma ti kurisi na kegha. Tuna kubiine inuwanuwapughuwei da ke sisiya pikanai ita vivisisiya kurina. ");
INSERT INTO pwg_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Didibara sago Josepa ivi matu ma inae da varevaresina ivi akovisi na varevaresina inuwapughu kamokamowi. ");
INSERT INTO pwg_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Ivonesi bo, “Kovi yana ma aku matu ani sisiyei. ");
INSERT INTO pwg_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Peyarita witi vaona kamonai witi tabawabawa ma kadeni ma aku bawa ivomiiri da basunai ivi kiimiiriyei ma peyarimi ami bawa iriyei da aku bawa imiiriviviri da irurunomei.” ");
INSERT INTO pwg_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Ma varevaresina ivonei bo, “Tam kenotanotai da kuni kiivavo da kuni badekai bo?” Ma ina matu ma ikikava ivi sisiyei kubiine na varevaresina nakeda inuwapughu kamokamowi. ");
INSERT INTO pwg_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Muriyai Josepa ivi matume na bade varevaresina ivi akovisi, ivonesi bo, “Aku matu kamonai akitai da madegha da nawaravi ma gwamegwame ivi 11 irurunomeku.” ");
INSERT INTO pwg_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Ma bade ina matu na ina mamai kurina ivi mamatarei. Ma ina mamai iyeghai ma ivonei bo, “Weni tuna na avi matuna kukenei? Tam kenotanotai da am maduwa da taku ma varevaresim kana runomem, bo?” ");
INSERT INTO pwg_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Ma vaghina, Josepa varevaresina inuwakapiyei ma ina mamai na weni berana ivi nuwanotanota kirakiiyei. ");
INSERT INTO pwg_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Mara sago Josepa varevaresina inae ku Sekem da i mamai ina ghamoghamo ikoyakoyaghisi. ");
INSERT INTO pwg_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Muriyai Josepa ina mamai ikwatui ma ivonei bo, “Ana vonatawem kuna nae ku Sekem da varevaresim ghamoghamo ekoyakoyaghisi na kuna kitisi.” Ivonapotei bo, “Vaghina, ana nae.” ");
INSERT INTO pwg_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Vaghina ina mamai ivonei bo, “Kenae da varevaresim kuna kitisi da ti na yawayawasisi bo kegha. Ma bade ghamoghamo kekitisi da ti na vaghina bo kegha. Ma kuna vovira da kuni akoviku.” Ma vaghina Hibron anaghinai ivomiiri inae da ku Sekem inekiibau. ");
INSERT INTO pwg_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Ma warereyai ibababa yawara na tomowa sago ikitai na tomowina ivi tarakiiyanei bo, “Aviyavisina kekwekwai?” ");
INSERT INTO pwg_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Ma Josepa ivonapotei bo, “Varevaresiku aekwekwisi. Kade kuta voneku da ti na meni dobunai ghamoghamo ekoyakoyaghisi.” ");
INSERT INTO pwg_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Tomowina ivonapotei bo, “Ti namada inae. Avi yanesi da ivona bo, ‘Tanae ku Dotan.’” Ma Josepa na varevaresina murisiyai inae da Dotan dobunai ipananisi. ");
INSERT INTO pwg_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Ma varevaresina ikitataweyana da nokomanaki ikitai ipipisi, karakava da ita nekiibau kurisi na ivi ogatara da ita kiivunui. ");
INSERT INTO pwg_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Ti mani kavakava ivi sisiya, ivona bo, “Nani matu wawayina wepiyai. ");
INSERT INTO pwg_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Kopisi, takiivunui ma weni ku dogosi sago imotomtawei na ku kamona tawanaoruwei. Ma tavona da ghamoghamo dipa ivowai. Ma takitai da aviyavisina ina tupuwa ina vimatu kubiine.” ");
INSERT INTO pwg_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","I tuwa Ruben sisiya ivi yanei na ibera tovoni da Josepa kana papara ita vowai. Ivona bo, “Ke takiivunui. ");
INSERT INTO pwg_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Ke vaghina da tarana ina sororo. Weni dogona imotomtawei na ku kamona tatawanaoruwei ma ke takiivunui.” Kana papara ita vowai, tuna kubiine nakanani ivi sisiya, ina nota da muriyai Josepa ita rutini ita nae ina mamai kurina. ");
INSERT INTO pwg_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Vaghina ma, Josepa inekiibau na varevaresina ivomiiri da ivotatani ma kana tarasovo kirukirumina ikotekotei na irukovowi. ");
INSERT INTO pwg_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Iviiya inae da ku dogo kamona itawanaoruwei. Ma dogona rorova kava imotomtawei. ");
INSERT INTO pwg_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Nani murinai imakiivipikapika da ikamkam ma ita kita da Ismayel tupurereghina ikitisi, ti na Midiyan damsi. Giliyadi dobunai ipipisi ma inenae ku Egypt. Ma i kamel tepanai na vavai kii tavighabughabu ma bade gegura gubaga kubiine na iuwana da iti gimara. ");
INSERT INTO pwg_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Juda varevaresina ivonesi bo, “Josepa takiivunui na avi biibiina tapanani? ");
INSERT INTO pwg_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Tigimarei vigimaragimara wawayisi kurisi ma ke takiivunui, iyamna tuna na varesita ma tarata vaghata.” Weni nakanani ivi sisiya na varevaresina peyarisi ivi vaghinei. ");
INSERT INTO pwg_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Midiyan damsi inekiibau kurisi, ti na vigimagimara wawayisi. Vaghina ma Josepa varevaresina dogo kamonai itinepai da ivi gimarei kurisi. Miiyanina na silva ririghina ivi 20. Ti damsi Josepa iviiya ma ineyei ku Egypt dobuna. ");
INSERT INTO pwg_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Nani murinai Ruben ivovira da dogona kamonai Josepa ikita kavai na ivi nuwapoya kirakai da kana gara isikai. ");
INSERT INTO pwg_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Ivovira titina yoghoyogho kurisi da ivona bo, “Tita kikei ke nani, taku aviyavisina ana berai?” ");
INSERT INTO pwg_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Nani murinai peyarisi inae da gote ikiivuni ma tarana iviiya da Josepa kana tarasovo ikiipasipasiya. ");
INSERT INTO pwg_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Ma ikavari inae da tarasovona i mamai iverei ma ivonei bo, “Weni sawarina kapanani, mede kevovirevirei kuna kitai, natum kana tarasovo bo?” ");
INSERT INTO pwg_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Ikitai da ivogiini ma ivona bo, “Weni tuna na natuku kana tarasovo! Ghamoghamo kayakayayina sago natuku ivowai. Vona bubuna da Josepa na ivi kutabedibediyanei!” ");
INSERT INTO pwg_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Jeikap nuwapoya ikiivunui da kana gara isikai ma mowasi modimodina ikotei. Ma natuna kubiine itou kirakai. ");
INSERT INTO pwg_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Natunatuna tomotomowisi da wivinesi peyarisi ipisi da iti nuwabiibiini. Ma kegha, iwenotaweyana da ivona bo, “Taku ana siyapa ina nene da ana rabobo. Anoru raborabobosi i ku dobu.” ");
INSERT INTO pwg_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Nani kamonai Midiyan damsi inene ku Egypt. Inekiibau na Josepa ivi gimarei Potipa kurina. Potipa na kiivavo Pero ina numa kana potapota i bada ghamana. ");
INSERT INTO pwg_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Nani berasi murinai Israel natuna Juda ivomiiri, varevaresina ikuyowesi ma inae da tomowa kana vava Hira gwabinai imakai, ina kwanatu na Adulam. ");
INSERT INTO pwg_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Nani dobunai imakamakai da Keinan wavine ipanani da iravaghi ma yavata ikena. Wavinena ina mamai kana vava Suwaya. ");
INSERT INTO pwg_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Wavinena iropeya ma ivi tuwa da natuna tomowa ma ivi vavei Eru. ");
INSERT INTO pwg_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Ma iropeyame na ivi tuwa da natuna tomowa ma ivi vavei Onan. ");
INSERT INTO pwg_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Ma bade ivi tuwame da tomowa ma ivi vavei Sela. Tuna na Kesibi dobunai ivi tuwei. ");
INSERT INTO pwg_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Natusi iyarokona Eru imagura na Juda inae da wavine sago irutini da Eru kawana, wavinena kana vava na Tama. ");
INSERT INTO pwg_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Ma Eru na ina berabero irakata, Bada ku matana ina bera ke biibiisi, tuna kubiine Bada ikiivunui. ");
INSERT INTO pwg_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Ma nani murinai Juda natuna Onan ivonei bo, “Ita kiki ikikava evonavona na kuna nunuri da am tuwa kwapurina kuna ravaghi ma kamonai ededa ina tupuwa na am tuwa natunatuna.” ");
INSERT INTO pwg_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Ma kegha, Onan iakovi da ti ededisi na ke tuna rapenai. Tuna kubiine maranai kwapurina yavata ikena na morona na ku tano ivivi sororoi da kwapurina ke iti ropeyi da iti tuwa da iyarokona natunatuna. ");
INSERT INTO pwg_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Ma aviyavisina iberai na Bada ke iti nuwabiibai tuna kubiine na bade ikiivunui. ");
INSERT INTO pwg_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Nani murinai Juda rawana Tama ivonei bo, “Kenae da am mamai kurina ma kemakai da tam kwapukwapurim. Ma kuna makamakai da natuku Sela ini yaraga.” Iyabumana da ikikava ina tuwa mau irabobo na nakanani Sela ita rabobo, tuna kubiine weni nakanani ivi sisiya. Ina nota gavugavuna na ke ita kayowei da Tama ita vovira da natuna ita ravaghi. Ma vaghina Tama ivovirame ina mamai kurina. ");
INSERT INTO pwg_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Madegha viya ikovi na Juda kawana irabobo. Ma Juda ina siyapa marana ikovi na kwinana Hira yavata inae ku Timna. Nani dobunai tomotomowa ina sipu vunivunisi ivivi gharitaweyana na inae kurisi. ");
INSERT INTO pwg_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Wawaya sago Tama ivi akovi da rawana Juda inenae ku Timna ina sipu gharina kubiine. ");
INSERT INTO pwg_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Tama sisiyina ivi yanei na kwapura garasi ivivi kote na ivi votaweyana. Ma gara sago iviiya da maghighina itarasovoi da wawaya ke ita vogiiya ma inae da Enayim meyagina garina matuketina ma keta inenae ku Timna na nani dobunai ivi kiimakiiyei. Iakovi da Juda ivi bero, namada Sela ivi yaraga ikovi ma ke ita verei da ita ravaghi. ");
INSERT INTO pwg_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Juda ibaba inene da Tama ikitai na inotai da tuna wavine madamadawarina iyamna maghighina ikwarewi. ");
INSERT INTO pwg_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Tuna kubiine ke damina ita viiya da tuna mani rawana keta baranai imakamakai. Inae kurina da ivonei bo, “Kepisi, tanae ma takena.” Ma wavinena ivona bo, “Yavata takena na aviyavisina biibiina kuna vereku?” ");
INSERT INTO pwg_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Ma Juda ivona bo, “Aku gote yavona kamonai votuna sago ana vonatawei kurim.” Ma ivonapotei bo, “Vaghina, muriyai da gote kuna vonatawei na am sawara sago kevereku ana vovotani da gote kuna vonatawei.” ");
INSERT INTO pwg_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Ivona bo, “Avi sawarina ana verem?” Ma wavinena ivona bo, “Tam am wakima ere uravina iwamuwai kekotekotei na kuna vereku. Ma bade am diwona imamuwai kuna vereku.” Vaghina nani sawarisi iverei ma yavata ikena da iropeya. ");
INSERT INTO pwg_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Nani murinai, wavinena ivovira ina ku numa na nani garana gayamina ikwarewi na ivotawei ma kwapura garana ikote meyei. ");
INSERT INTO pwg_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Juda kwinana Hira ivonatawei da gote ita viiya ita neyei ma wavinena gwabinai Juda ina sawara ita yuname. Ma kegha, wavinena iekwa kavai. ");
INSERT INTO pwg_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Ma inae da Enayim meyaginai tomotomowa viya ivi tarakiiyanesi bo, “Wavine madamadawarina rorova keta baranai imakamakai na imapatana?” Ma ivonapotei bo, “Ke sago weni dobunai wavine madamadawarina sago ita makamakai.” ");
INSERT INTO pwg_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Hira ivovira Juda kurina ma ivonei bo, “Wavinena ke ata panani. Ma nani dobunai tomotomowa ivoneku da ke meyani wavine madamadawarina sago nani meyaginai ita makii tovona.” ");
INSERT INTO pwg_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Ivona bo, “Vaghina, wavinena kevoterei da aku sawara ini rapenei, ke kata kayokayowei da wawaya ini nameta. Taku abera tovoni da ati miiyei ma wavinena ke kuta panani kubiine namanaki.” ");
INSERT INTO pwg_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Nawaravi aroba ikovi ma wawaya ipisi ma Juda ivonei bo, “Rawam Tama na madamadawarisi i bera iberaberai da wekarakava na tuna iropeya.” Juda sisiya bagibagina iterei, ivona bo, “Meyagi kamonai kotinakiibuwei ma kokapuvunui.” ");
INSERT INTO pwg_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Ma itinakwarokwaroi ikiikiibau na sisiya ivonatawei rawana kurina, ivona bo, “Meni tomowina weni sawarisi iverevereku na tuna tomowina ivi ropeyiku. Weni matakira wakimina ere uravina ma weni diwonina kokitai, iyi rapenai.” ");
INSERT INTO pwg_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Juda sawarisi ikitai da ivogiini na ivona bo, “Tuna wavinena bera maninina iberai ma taku na kegha. Taku namada natuku Sela ata verei da ita ravaghi da iti tuwa na kegha, abera beroi.” Ma nani murinai Juda ke meyani Tama yavata ita kename. ");
INSERT INTO pwg_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Ma Tama ina mara itupo da iti tuwa na ivopanani da tomotomowa ruwa manawina kamonai. ");
INSERT INTO pwg_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Ma ina vivowavowa kamonai natuna sago imana iterekiibuwei na vivowavowa wavinena imana ivotani ma gara taratarana iviiya da ikuni. Ma ivona bo, “Weni tuna na iyarokona.” ");
INSERT INTO pwg_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Ma kegha, imana irurui na kwinana sago ivi nao ikiibau na vivowavowa wavinena ivona bo, “O, da tam weni nakanani, kukiibewara kukiibau.” Ma ivi vavei ‘Peres.’ ");
INSERT INTO pwg_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Ma murinai na kwinana imana gara tarataranai ikukuni na ikiibau, ma tuna ivi vavei ‘Seraya.’ ");
INSERT INTO pwg_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Josepa na vigimagimara damsi irutini da namada ioruwei ku Egypt. Ma nani dobunai Potipa kurina ivi gimarei. Tuna na kiivavo Pero ina numa kana potapota damsi i bada ghamana. ");
INSERT INTO pwg_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Josepa ina bada vuna na Egypt wawaya ma ina numa kamonai imakamakai ma ivovobagibagi. Ma Bada na Josepa gwabinai, tuna kubiine ivi biibiini da bera peyarina iberaberai na biibiina kavakava. ");
INSERT INTO pwg_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Potipa ikitai da Bada gwabinai ma biga biibiina eberaberai. ");
INSERT INTO pwg_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Tuna kubiine ivi nuwabiibiiyei ma ivinei da tuna mani ina bigabiga, ivobagibagi patapata ma yavata ibababa. Muriyai bade ivinei da ina numa kamona ma ina bera kudubina iti badei. ");
INSERT INTO pwg_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Josepa ivivi bada na Bada ivi biibiini da Potipa ina rakaraka ma aviyavisina kudubina rapenai ina numa kamonai ma bade ina ghamoghamo kudubina na biibiina. Ma bade ina vao kamonai iyaba bubuna, mura irakata. ");
INSERT INTO pwg_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Potipa ina bera kudubina rapenai ivi damani Josepa kurina da iti badei ma ke sago aviyavisina sago iti nuwapoyei da vavai ikanikani tuna kava. Josepa na ivi komeruwana kirakai ma tupuwina kana kita biibiina. ");
INSERT INTO pwg_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Ke mara gurina ma ina bada kawana ikirorowei na ivona tovoni, ivonei bo, “Aku kayowana da tam yavata takena.” ");
INSERT INTO pwg_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Ma kegha, Josepa ibara ma ivonei bo, “Kutakovi da kawam ke sago aviyavisina ina numa kamonai ita vivinuwapoyei, iyamna taku amakamakai. Tuna itereku da ina bera kudubina aibadei. ");
INSERT INTO pwg_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Weni numana kamonai na taku kava aku rewapana emakamakai da ani bada, ke sago iyai. Ma ke sago aviyavisina sago iti tarapaparanei da tam kava. Ikikava da taku weni berana inimayamayana ana berai? Tuna na berabero God kurina.” ");
INSERT INTO pwg_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Ma wavinena marana patapatana ivonavonei da yavata ita kena bo mara nonowa na gwabinai ita makamakai ma kegha, Josepa ke ina kayowana. ");
INSERT INTO pwg_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Mara sago irui ku numa kamona da ina biga ita berai ma ke sago bigabiga wawayisi nani dobunai. ");
INSERT INTO pwg_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Wavinena ipisi da Josepa kana tarasovo ivotani ma ivonei bo, “Kepisi, yavata takena.” Ma kegha, ionagha da iverau ma kana tarasovo na wavinena imanai ikuyowei. ");
INSERT INTO pwg_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Ionagha iverau, numa ikiibutawei na wavinena ikita da Josepa kana tarasovo na patana da imanai. ");
INSERT INTO pwg_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","Tuna kubiine ivi kwatu ina bigabiga wawayisi kurisi ma ivona bo, “Weni tarasovona kokitai! Nani Hibru tomowina kawaku irutini ipiyei weni ku numana na irekweta, bo? Irui aku ku kenakena gawarina ma ina kayowana da yavata kata kena, ma kegha ayabumana da aghekiirara. ");
INSERT INTO pwg_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Ivi yanei da akiirara na kana tarasovo ikuyowei ma iverau da numa ikiibutawei.” ");
INSERT INTO pwg_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Wavinena Josepa kana tarasovo ivotani imakamakai da kawana inekiibau. ");
INSERT INTO pwg_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Vaghina, sisiyina sago kawana kurina ivi damani ivonei bo, “Nani Hibru tomowina kurutinapiyei ita ku numa na irui aku ku kenakena gawarina ma ina kayowana da iti rekweku. ");
INSERT INTO pwg_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Ma ivi yanei da akiirara na kana tarasovo ikuyowei ma iverau da numa ikiibutawei.” ");
INSERT INTO pwg_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Josepa ina bada weni sisiyina ivi yanei na nuwanuwana ipughu kirakai. ");
INSERT INTO pwg_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Ma ivona na Josepa ipaniya da ku gabura iterei, meni dobunai kiivavo ina gabura wawayisi ivivi makiiyana na nake iterei da nani dobunai imakai. ");
INSERT INTO pwg_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Ma kegha da Bada na Josepa gwabinai, ma ina agabiibai ivi debei, iberai da gabura kana koyakoyagha wawayina ina kayowana ghamana na Josepa. ");
INSERT INTO pwg_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Tuna kubiine gabura kana koyakoyagha wawayina Josepa ivinei da gabura wawayisi i bada ma aviyavisina peyarina kamonai ina beraberai na tuna ina vibadana gaburinai. ");
INSERT INTO pwg_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Ma bera kudubina ivivi badei kubiine na gabura kana koyakoyagha wawayina ke sago aviyavisina iti nuwapoyei, iyamna Bada na Josepa gwabinai da bera peyarina iberaberai na vaghina kavakava. ");
INSERT INTO pwg_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Ke mara gurina ma kiivavo Pero ina redu kana kavakavara ma kana parawa kana kapukapuna wawayisi bera berona iberai i kiivavo kurina. ");
INSERT INTO pwg_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Pero nuwanuwana ipughu ina bigabiga wawayisi ruwa kurisi ");
INSERT INTO pwg_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","ma iviinisi da ku gabura iteresi. Gabura na potapota wawayisi i bada ghamana ina numa kamonai, imapatana Josepa imakamakai na nake. ");
INSERT INTO pwg_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Ma potapota wawayisi i bada ghamana na Josepa ivinei da ita koyaghisi. Redu kana kavakavara ma parawa kana kapukapuna na gabura kamonai imakii kirakai ma ");
INSERT INTO pwg_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","didibara sago na ivi ruwa ivi matu. Ma i matu na iyamsi na bogii ma bogiiyai. ");
INSERT INTO pwg_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Mara itom ma mara boiboiyai na Josepa ikitisi ma ivogiinisi da ke nuwabiibiiyai ita makamakai. ");
INSERT INTO pwg_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Ma ivi tarakiiyanesi bo, “Avi kubiine karako na kami kita da koinuwapoya kirakai?” ");
INSERT INTO pwg_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Ma ivonapotei bo, “Didibarai akii viruwa kavi matu ma ke sago iyai da akii matu iyamsi iti debei.” Josepa ivona bo, “God ina kina kava rewapana gwabinai da matu ini debei ma vaghina ami matu kovi sisiyei kuriku.” ");
INSERT INTO pwg_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Vaghina ma redu kana kavakavara ina matu ivi sisiyei Josepa kurina, ivona bo, “Aku matu kamonai na greipi kiina maghinokuwai akitai ");
INSERT INTO pwg_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","ma kiina tepanai na ragharaghana aroba. Ragharaghana na ivi karei da isisini ma ke mara gurina ma irutatagha da amesi duridurisi imenai. ");
INSERT INTO pwg_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Ma Pero ina redu avovotani ma greipi amesi ayuna da avoroi ina ku redu kamona ma reduna averei.” ");
INSERT INTO pwg_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Josepa ivona bo, “Am matu iyamna na weni. Greipi ragharaghana aroba iyamna na mara aroba. ");
INSERT INTO pwg_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Mara aroba murinai kiivavo Pero am bera ina notatawei ma ina votawem. Ma ina ruwepim da kam ku gawara ina tere meyem da ina redu kana kavakavara. ");
INSERT INTO pwg_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Ma am bera peyarina ina manini na ainowi kurim da kenotiku ma bade am agabiibiiyai aku bera Pero kurina kevi sisiyei da taku bade gabura kamonai ina votaweku. ");
INSERT INTO pwg_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Ke taku mani aku kayowana Hibru dobuna ata kuyowei da ata pisi. Kegha, wawaya iyapiku ma irutiniku kapisi wike. Ma karako weni dobunai na bade ke sago aviyavisina ata beraberoi da ku gabura ita tereku.” ");
INSERT INTO pwg_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Parawa kana kapukapuna wawayina ivi yanei da redu kana kavakavara wawayina ina matu iyamna kudubina ivi debe bubuni na Josepa ivonei bo, “Taku bade weni nakanani avi matu, parawa kodesi aroba akunapi. ");
INSERT INTO pwg_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Ma tepana kodena kamonai na parawa kapukapunisi bogii ma bogiiyai kiivavo kubiine. Ma parawisi na kiu ikamkam.” ");
INSERT INTO pwg_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Ma Josepa ivonei bo, “Am matu iyamna na weni. Kode aroba iyamna na mara aroba. ");
INSERT INTO pwg_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Mara aroba murinai na kiivavo gabura kamonai ina votawem da iwam ina kiiyaraghi ma tupuwim kii tepanai ini rorokei da viyom kiu ina kani.” ");
INSERT INTO pwg_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Mara aroba murinai na kiivavo Pero ina tupuwa marana na kamporagha ghamana iberai ina wawaya ghamaghamasi kubiisi. Ina redu kana kavakavara da kana parawa kapukapuna gabura kamonai iviinisi ipisi ina wawaya ghamaghamasi ku maghinosi. ");
INSERT INTO pwg_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Ma ina redu kana kavakavara ina ku biga katamanina itere meyei. ");
INSERT INTO pwg_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Ma parawa kapukapuna wawayina na iwana ikiiyaraghi, Josepa ikikava ivonavonei na nakanani itupuwa. ");
INSERT INTO pwg_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Ma kegha da redu kana kavakavara wawayina Josepa ina vibagha ivi notawapei, nuwanuwana iwapa. ");
INSERT INTO pwg_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Madegha ruwa murinai kiivavo Pero ivi matu da Nael okowina baranai imiimiiri. ");
INSERT INTO pwg_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Ina matu kamonai kau ivi 7 dodosi ma kitasi biibiisi okowa kamonai ighetawesi ma ighae da okowa baranai inamona ikamkam. ");
INSERT INTO pwg_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Ti murisiyai na bade kau ivi 7 okowa kamonai ighae ma ti na togetogesi ma petopetosi. Weni kausi ighae da okowa baranai kau dodosi ivivi miiriyana na imiiritanisi. ");
INSERT INTO pwg_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Kau togetogesi ma petopetosi ivomiiri da kau dodosi ikam yavusi. Nani kamonai na Pero irumataka. ");
INSERT INTO pwg_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Matana ikiikovowi da bade ivi kiikena meyei na ina matu kana viruwa ivi matuwei. Weni kamonai ikitai da witi kiina sago kava ma ibire da imana ivi 7 ma kitasi biibiisi. ");
INSERT INTO pwg_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Ti murisiyai na bade witi sago ibire da imana ivi 7 ikiibau da beroberosi ma momosisi. Ma witina kitana da warereyai yanunu berona ita karagavovori. ");
INSERT INTO pwg_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Ma nani vaviisi beroberosi ma momosisi ivomiiri da nani vaviisi kitasi biibiisi irunamisi. Kiivavo irumatakame ma tuna na matu kava. ");
INSERT INTO pwg_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Mara itom ma mara boiboiyai na ina nota iragharagha tuna kubiine, ina wawaya kasikasikosi ma ina nuwagiura wawayisi Egypt kamonai kii sisiya ivi vonataweyana da ita pisi kurina. Ina matu ivi sisiyei kurisi ma ke sago iyai da ina matu iyamna iti debei. ");
INSERT INTO pwg_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Vaghina ma redu kana kavakavara kiivavo kurina ivona bo, “Wekarakava na ani mamatarem da taku abera beroi, sisiya sago ata vonem. ");
INSERT INTO pwg_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Rorova nuwanuwam ipughu kurikai da taku ma am parawa kapukapuna wawayina ku gabura kuterekai. Gabura na potapota wawayisi i bada ghamana ina numa kamonai. ");
INSERT INTO pwg_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Didibara sago kamonai na akii viruwa kavi matu ma matusi iyamsi na bogii ma bogiiyai. ");
INSERT INTO pwg_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Ma gabura kamonai na Hibru tomowa yaragina, tuna na potapota wawayisi i bada ghamana ina bigabiga. Akii matu kurina kavi sisiyei ma tuna iyamsi ivi debei. ");
INSERT INTO pwg_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Ma ikikava ivivi debei kurikai na itupuwa. Taku na kaku ku gawara kutere meyeku ma parawa kapukapuna wawayina na iwana kukiiyaraghi.” ");
INSERT INTO pwg_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Vaghina ma Pero, Josepa kana sisiya ivonatawei na potapota wawayisi yaghiyaghinai gabura kamonai ivotawei ikiibau. Mutukorona igharitawei, itowa ma ivi garavunagha ikovi na irutinaneyei Pero ku maghinona. ");
INSERT INTO pwg_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Ma Pero, Josepa ivonei bo, “Avi matu ma ke sago iyai da aku matu iyamna ini debei. Ma sisiya avi yanei da tam kovokovoghim da wawaya i matu iyamsi kuni debei.” ");
INSERT INTO pwg_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Josepa ivonapotei bo, “Aku bada, taku ke ruvaruvaku da am matu iyamna ani debei ma God, tuna kava am matu iyamna ini debe bubuni kurim.” ");
INSERT INTO pwg_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Pero ivona bo, “Avi matu da Nael okowina baranai amiimiiri. ");
INSERT INTO pwg_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","Ma kau dodosi ma kitasi biibiisi ivi 7 okowa kamonai ighetawesi ma ivi karei da inamona ikanikani. ");
INSERT INTO pwg_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Ti murisiyai na bade kau ivi 7 okowa kamonai ighae, ti na togetogesi ma petopetosi. Ma kitasi beroberosi ma gubagubagisi, ke meyani Egypt dobuna kamonai kau nakanani ata kita tovonisi. ");
INSERT INTO pwg_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Ma nani kausi togetogesi ma petopetosi ivomiiri da kau dodosi ikanisi. ");
INSERT INTO pwg_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Ikanisi ikovi ma kegha da patana da togetogesi ma petopetosi, kii kita ke ita vire tovona. Ma nani dobunai arumataka. ");
INSERT INTO pwg_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Ma bade akena da avi matume. Aku matu kamonai na bade witi kiina sago kava ma imana ivi 7 akitai ma vavina na tonapotona. ");
INSERT INTO pwg_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Ti murisiyai na bade witi sago ibire da imana ivi 7 ikiibau da beroberosi ma momosisi. Ma witina kitana da warereyai yanunu berona ita karagavovori. ");
INSERT INTO pwg_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Ma nani vaviisi beroberosi ma momosisi ivomiiri da nani vaviisi kitasi biibiisi irunamisi. Aku matu na kasikasikosi avonesi ma ke sago iyai da iyamna iti debei.” ");
INSERT INTO pwg_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Josepa ivona bo, “Am matu na ruwa ma iyamsi na sago. God ivi beyem da aviyavisina ina berai. ");
INSERT INTO pwg_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Nani kausi ivi 7 dodosi kukitai na madegha ivi 7 ma witi imana ivi 7 ma tonapotona na bade madegha ivi 7, ivi ruwa na iyamna sago. ");
INSERT INTO pwg_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Ma nani kausi ivi 7 togetogesi ma petopetosi muriyai ighetawesi ma bade witi imana ivi 7 beroberosi ma momosisi warere yanununa berona ikaragavovori, ti na madegha ivi 7 na gomara. ");
INSERT INTO pwg_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Vaghina ikikava avonavonem na nakanani, God ivi beyem da aviyavisina ina berai. ");
INSERT INTO pwg_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Madegha ivi 7 na Egypt dobuna kamonai mura ghamana. ");
INSERT INTO pwg_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Ma nani murinai na madegha 7 na gomara ghamana ma bero kirakiina ina tupuwa da wawaya mura madeghisi ini notawapei. Ma Egypt dobuna kamonai wawaya vitonara ina karakarisi. ");
INSERT INTO pwg_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Nani gomarina na ina bero kirakai tuna kubiine rorova murina nuwanuwasi ina wapa. ");
INSERT INTO pwg_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Weni berana na God tuna mani namada ina nota irereghi ikovi da ina berai, tuna kubiine am matu kamonai mara ruwa weni berasi ivi beyem. Ma berasi na gisina kava ma ina tupuwa. ");
INSERT INTO pwg_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Aku bada, wekarakava na wawaya sago nuwanuwagiurina ma akakovina kuna vinei da Egypt dobuna ini badei. ");
INSERT INTO pwg_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Ma bade babada viya kuna vinesi da madegha 7 mura ghamana kamonai witi ina boriboriya na riba ivi miikovi ina terei da sago ina viiya ma makiiterena na wawaya ina kam. ");
INSERT INTO pwg_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Tam Pero am vibadana gaburinai na babada i biga da madegha 7 kamonai vavai ina yuna da kwanatu nunusiyai ina tura, maghara numasiyai ina koyagha bubuni. ");
INSERT INTO pwg_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Ma vavina na ina koyaghi ina nenae da Egypt dobuna kamonai gomara ina tupuwa na tuna ini yapakei, madegha 7 wawaya nani vavina tepanai ina makai. Nakanani ina berai da maranai gomara ina tupuwa na wawaya vitonara ke ina karisi.” ");
INSERT INTO pwg_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Weni notana na kiivavo Pero ma ina babada ghamaghamasi kurisi na ibiibii kirakai. ");
INSERT INTO pwg_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Ma ivonesi bo, “Ke kovokovoghina wawaya sago Josepa nakanani imapatana tapanani, tuna na God kanumina gwabinai.” ");
INSERT INTO pwg_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Tuna kubiine Pero imiiritavire da Josepa ivonei bo, “God weni berasi na tam kurim ivi beyem ma kana kita na ke sago iyai ita nuwaguira bo ita akova tam nakanani. Ma bera gavugavusi na namada kuakovi. ");
INSERT INTO pwg_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Tam atereterem da aku numa kuni badei ma aku wawaya peyarina tam ina votekatekem. Ma tam na taku gaburikuwai. ");
INSERT INTO pwg_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Ma wekarakava na vibadana avereverem da Egypt dobuna kudubina kuni badei.” ");
INSERT INTO pwg_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Vaghina ma Pero imarakorakonai rin ivotawei da Josepa ku imarakorakona ivi ruini. Nani rin na kiikiivavo i matakira tepanai ipapai. Ma tarasovo vuna, kiimatanina ma poipoina iviiya da ivi kotei ma bade chein goldiyai iyamoni na iviiya da ku iwana ivi rorokei. ");
INSERT INTO pwg_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Muriyai irutini ma Pero tuna mani ina ku serioti ivi geruni da ibaba, dobu ine yavui, ivi matakira wawaya kurisi da Josepa na Pero gaburinai ini bada. Ma maghinonai na potapota wawayisi inenae na ikiikiirara bo, “Keta kovoviyaghari, keta kovoviyaghari.” Ma vaghina nakanani iberai da Josepa tuna Egypt dobuna kudubina ivi bada yavui. ");
INSERT INTO pwg_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Ma Pero, Josepa ivonei bo, “Taku patana da kiivavo ma ke sago iyai Egypt dobuna kamonai aviyavisina ina bera wapawapai da kunona tam kuni vaghinei.” ");
INSERT INTO pwg_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Ma bade kana vava vuna iverei, ivi vavei Sapenati Paneya, weni vavana na Egypt damsi kii vava. Ma wavine sago kana vava Asenati iverei da kawana, wavinena ina mamai na Potipera, tuna na god vibero ina vokavara ivi badei ‘On’ kwanatuna kamonai. ");
INSERT INTO pwg_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Josepa kana madegha 30 ma biga ivi karei Egypt dobuna kana kiivavo kubiine. Ma ke Pero gwabinai ita makamakai, ikiibutawei da Egypt dobuna kudubina ine yavui, ina biga iberaberai. ");
INSERT INTO pwg_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Madegha 7 kamonai Egypt dobunai na mura bogii ma bogiiyai ivi turagudei. ");
INSERT INTO pwg_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Nani madeghisi 7 kamonai Josepa ina bigabiga yavata ibababa da meni dobunai witi iboriborini na Pero kana riba iyuyuna. Kwanatu nununai iyuyuna ma Pero ina ku maghara numasi ituturavidaburana. ");
INSERT INTO pwg_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Josepa iberai da maghara Egypt kamonai irakata, isasara nakanani ma gonugonu yegiyai, ke kovokovoghina da ita ruvai. ");
INSERT INTO pwg_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Muriyai da gomara ita nekiibau na Josepa kawana Asenati mara ruwa ivi tuwa da natunatuna tomotomowa. ");
INSERT INTO pwg_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Kunona ivi tuwa na Josepa ivona bo, “God iberai da aku nuwapoya ma bade aku mamai ina rakaraka yavata avi notawapesi.” Tuna kubiine natuna iyarokona ivi vavei ‘Manase.’ ");
INSERT INTO pwg_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Muriyai ivi tuwame na ivona bo, “Weni dobunai avi kamyuyuwa ma karako God iberai da natuku itupuwa.” Tuna kubiine natuna kana viruwa ivi vavei ‘Eperaim.’ ");
INSERT INTO pwg_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Mura ghamana madegha 7 Egypt dobuna kamonai ivivi nuwabiibiiyei na marana ikovi, ");
INSERT INTO pwg_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","ma gomara ivi karei. Josepa ikikava ivivi sisiyei na nakanani itupuwa. Gomarina na madegha ivi 7 imakamakai ma ke Egypt kava, dobu kudubina ikamowani, ma kegha da Egypt dobuna kamonai na vavai imakamakai. ");
INSERT INTO pwg_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Egypt damsi vitonara ikarakarisi na Pero kurina ivivi nowi da vavai ita veresi. Ivivi nowi na ivonesi da ita nae Josepa kurina da ita vonesi da aviyavisina ita berai. ");
INSERT INTO pwg_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Ma gomara irakata da dobu kudubina ikamowana yavui. Vaghina Josepa maghara numasi ivi votaweyana da vavai ivivi gimara Egypt damsi kurisi. ");
INSERT INTO pwg_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Wawaya dobu bogii ma bogiiyai kamosiyai ipisi ku Egypt da Josepa gwabinai vavai ita gimara, iyamna gomarina na irakata ma ibero kirakai da dobu kudubina ikamowana yavui. ");
INSERT INTO pwg_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Keinan dobunai, Jeikap sisiya ivi yanei da Egypt dobunai vavai imakamakai na natunatuna ivonesi bo, “Avi kubiine komakamakai ma koikitavonevoneyana? ");
INSERT INTO pwg_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Sisiya avi yanei da Egypt dobuna kamonai na vavai emakamakai. Koru ku Egypt da witi kona gimara da tuna tepanai tamakai da ke tarabobo.” ");
INSERT INTO pwg_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Vaghina ma Josepa varevaresina ivi 10 ioru ku Egypt da vavai ita gimara. ");
INSERT INTO pwg_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Ma Jeikap natuna Benjamin, tuna Josepa tina kikei, ke ita vonatawei da varevaresina yavata ita nae, iyamna iyabumana da berona ita kayo panani. ");
INSERT INTO pwg_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Keinan dobuna kamonai na bade gomara irakata. Tuna kubiine ke Jeikap natunatuna kava ma bade wawaya viya yavata ioru ku Egypt da vavai ita gimara. ");
INSERT INTO pwg_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Ma tuna maranai na Josepa na bada ghamana Egypt kamonai ma tuna vavai ivivi gimara wawaya kurisi. Vaghina ma varevaresina inekiibau kurina da irunomei, maghighisi ku dowa. ");
INSERT INTO pwg_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Josepa ikitisi na ivogiinisi, ma kegha da iberai da nakanani ma ke itakovisi ma ere ghakighakina ivi sisiya kurisi. Ma ina wawaya sago na gamona ivivi damani kurisi i dughu kamonai. Tuna kubiine varevaresina inotai da tuna na Egypt tomowa ma Hibru gamona ke iti sisiyei. Ivi tarakiiyanesi bo, “Tami imapatana kopisi?” Ma ivonapotei bo, “Tokai na Keinan dobunai kapisi da vavai kana gimara.” ");
INSERT INTO pwg_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Josepa na varevaresina ivogiinisi ma varevaresina tuna ke ita vogiini. ");
INSERT INTO pwg_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Ma ina nota ivovira da ikikava ivi matu na inotai ma ivonesi bo, “Tami na nanaga wawayimi, kopisi da akii mitamita tarabogina koekwekwai.” ");
INSERT INTO pwg_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Ma ivonapotei bo, “Kegha akii bada, tokai am bigabiga, kapisi da vavai kana gimara. ");
INSERT INTO pwg_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Tokai na tomowa sago kava natunatuna. Am bigabiga wawaya maninikai. Tokai na ke nanaga wawayikai.” ");
INSERT INTO pwg_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Josepa ivonapotesi bo, “Kegha! Kopisi da akii mitamita tarabogina koekwekwai.” ");
INSERT INTO pwg_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Ma ivonapotei bo, “Tokai am bigabiga katupuwa da tomotomowa kavakava akii vi 12 ma akii mamai na sago kava ma tuna na Keinan dobunai emakamakai. Ma tikii kikei murimuri vaghina na akii mamai yavata emakamakai ma varesikai sago na irabobo.” ");
INSERT INTO pwg_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Josepa ivonesi bo, “Vona bubuna da tami na nanaga wawayimi. ");
INSERT INTO pwg_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Ma vaghina, weni nakanani ana berai da akovimi ana viiya da tami kovonavona bubuna bo koibero. Pero avanai amiimiiri na avonavonemi da weni dobunai kona makamakai da timi kikei wike ina nekiibau na vaghina kana votawemi da kona nae. ");
INSERT INTO pwg_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Ami yonayona kona vonatawei ami mamai kurina da timi kikei ina rutinapiyei. Ma tami na ku gabura ana teremi kona makamakai da timi kikei ina nekiibau wike. Ina nekiibau na akova kiimatana ana viiya da kovonavona bubuna bo kegha. Ma kegha na Pero avanai amiimiiri na avonavonemi da tami na nanaga wawayimi.” ");
INSERT INTO pwg_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Ma Josepa ipanisi ma ku gabura iteresi da mara aroba imakai. ");
INSERT INTO pwg_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Mara kana viaroba kamonai na Josepa ivonesi bo, “Taku na God ayabuyabumanei, tuna kubiine bera maninina ana berai. Kona bera bubuna na ke ana kiivunumi. ");
INSERT INTO pwg_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Mikeda tami na wawaya maninimi na ami wawaya sago gabura kamonai ina makai ma peyarimi na vavai kona kavara kona nae ami rakaraka vitonara ekarakarisi na kurisi. ");
INSERT INTO pwg_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Ma timi kikei murimurina na koviiya da kopiyei kuriku. Tuna maranai anakovi da ami sisiya na vona bubuna na ke ani rabobomi.” Ma peyarisi ivi vaghinei da nakanani ina berai. ");
INSERT INTO pwg_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Ma ti mani kamosiyai ivi sisiya, ivona bo, “Vona bubuna da kata kovogha, varesita kurina tabera beroi, tuna kubiine weni nuwapoyina tapanapanani. Takitai da varesita ivi kamyuyuwa kirakai ma ivivi nowi ina yawasa kubiine na ke kati nuwapoyei, tuna kubiine tota bade na nuwapoya tapanani.” ");
INSERT INTO pwg_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Ma Ruben ivonesi bo, “Rorova kava tami avonemi da tomowa kikei kurina berabero ke kata berai ma aku sisiya ke koti yanei. Ma wekarakava na tarana isororo kubiine, kovoghina taviiviiya.” ");
INSERT INTO pwg_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Ivivi sisiya na ke itakovi da aviyavisina ivivi sisiyei na Josepa ivivi yanei. Inotai da Hibru gamo ke itakovi iyamna wawaya sago na ina sisiya ivivi damani kurisi. ");
INSERT INTO pwg_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Josepa varevaresina ikuyowesi inae ma itou. Ma itou ikovi na ivovira da kurisi ivi sisiya. Ma Simiyon iviiya da maghinosiyai ma ikutatani. ");
INSERT INTO pwg_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Josepa ina bigabiga ivonesi da witi varevaresina i ku kutu ghamaghamasi iti tupotupo ma bade gavunai i mani na ituwaname i ku kutu kamosi. Ma vavai ita veresi da kii keta tamiina kubiine, na kudubina iberai. ");
INSERT INTO pwg_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Vaghina ma, kudubina i ku donki ivi geru ikovi na ivomiiri inae. ");
INSERT INTO pwg_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Ma inenae da kena kubiine na i wawaya sago ina kutu ivotawei da vavai ita viiya ina donki kubiine na ipanani da ina mane na ina kutu kamonai. ");
INSERT INTO pwg_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Ma varevaresina ivonesi bo, “Aku mane na iuwana meyei aku ku kutu kamona, kokitai, weni.” Vaghina ma nuwanuwasi ikarai, ivi kitavonevonei ma ere kirokirorosi ivona bo, “Avi kubiine weni berana God iberai kurita?” ");
INSERT INTO pwg_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Ku Keinan inekiibau na aviyavisina peyarina itupuwa Egypt dobuna kamonai ma ketiyai na i mamai Jeikap kurina ivi mamatara, ivona bo, ");
INSERT INTO pwg_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","“Egypt dobuna kana bada ghamana ivi wavukai na ere ghakighakina ivi sisiya kurikai da nakanani ma tokai na nanaga wawayikai. ");
INSERT INTO pwg_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Ma kegha da kavonapotei bo, ‘Tokai na ke nanaga wawayikai, tokai na wawaya maninikai. ");
INSERT INTO pwg_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Ma tokai na katupuwa da tomotomowa akii vi 12 ma akii mamai na sago kava ma varesikai sago na irabobo ma tikii kikei murimuri vaghina na akii mamai yavata Keinan dobunai emakamakai.’” ");
INSERT INTO pwg_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","“Vaghina ma bada ghamana ivonekai bo, ‘Weni nakanani kona berai da anakovi da kovonavona bubuna bo koibero. Kwinami sago na yavata kana makai ma peyarimi na vavai kona kavara kona nae da ami rakaraka vitonara ekarakarisi na kurisi. ");
INSERT INTO pwg_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Ma timi kikei murimuri vaghina korutinapiyei kuriku da anakovi da tami kovonavona bubuna da tami wawaya maninimi ma ke nanaga wawayimi. Tuna maranai na varesimi ana vere meyemi ma ani vaghinei da weni dobunai kona gimagimara.’” ");
INSERT INTO pwg_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Ma peyarisi i kutu kamosiyai vavai ivivi kiibuni na ipanani da i kutu kamosiyai gimagimara manesi na kudubina nani. I mamai yavata nani manesi ikitakitai na iyabumana kirakai. ");
INSERT INTO pwg_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Ma i mamai ivonesi bo, “Ami kayowana da natunatuku kudubimi ani wapimi bo? Josepa namada irabobo, ma bade Simiyon iwapa ma wekarakava na ami kayowana da Benjamin kona viitawei bo? Bera kudubina na imiirikuputeku.” ");
INSERT INTO pwg_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Ruben ina mamai ivonei bo, “Benjamin kevereku ma kevi tumaghaneku da ana rutini kana vovira. Mikeda ke ana rutinapiyei na natunatuku ivi ruwa kevi kiivunuwana, kaku kovogha.” ");
INSERT INTO pwg_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Ma kegha, Jeikap ivona bo, “Ke kovokovoghina da natuku yavata konoru, namada ina tuwa irabobo ma ina kina kava emakamakai. Taku namada amorapa kirakai ma mikeda keta borinai berona ina panani na tuna nuwapoyina ini raboboku. Anoru raborabobosi i ku dobu.” ");
INSERT INTO pwg_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Keinan dobuna kamonai na patana da gomara irakata ma ibero kirakai. ");
INSERT INTO pwg_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Vaghina ma Jeikap ina rakaraka yavata kii vavai Egypt dobunai ikavari igheghae na ikam yavui. Tuna kubiine Jeikap natunatuna ivonesi bo, “Kovovira da vavai gisina voghamana kubiita kona gimara.” ");
INSERT INTO pwg_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Ma Juda ivona bo, “Tomowina ina sisiya bagibagina iverekai da ivona bo, ‘Kara maghighiku ke kona kitai da timi kikei kona rutinapiyei na vaghina.’” ");
INSERT INTO pwg_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Tuna kubiine kuni vaghinei da tiki kikei yavata kana nae na vaghina, kanoru da kata vavai kana gimara kubiim. ");
INSERT INTO pwg_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Ma mikeda ke kuni vaghinei na tokai ke kanoru, iyamna tomowina ivonekai da tikii kikei ke kana rutinaneyei na ke ina tavire da ina kitikai. ");
INSERT INTO pwg_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Jeikap ivona bo, “Avi kubiine tomowina kovonei da timi kikei sago emakamakai? Weni nakanani koberai na taku nuwapoya kovereku.” ");
INSERT INTO pwg_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Ma ivonapotei bo, “Tomowina ivi taravirevire bogiikai da tokai ma akii rakaraka ita akova bubuni. Ivona bo, ‘Ami mamai patana da emakamakai bo? Ma timi kikei sago emakamakai bo kegha?’ Ma ikikava katakovi da ita vonekai da tiki kikei kata rutini da yavata katoru. Ma ina vitarakiiyana kubiine na nota yagharinai kavona potei.” ");
INSERT INTO pwg_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Juda ina mamai kurina ivona bo, “Tomowa kikei kevonatawei da taku yavata wekarakava kana nae da tam ma tokai natunatukai yavata yawayawata tamakai ma ke tarabobo. ");
INSERT INTO pwg_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Ma taku averevere meyeku tuna ina yawasa kubiine. Mikeda ke ana viiya ana vovirei kurim na wavuna na taku ana kavara nonowei. ");
INSERT INTO pwg_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Madegha enenae. Mikeda Benjamin ke kuta tarapapari, ma vivaghina kutaverekai na tokai namada mara ruwa kata nae ku Egypt ma kata vovira.” ");
INSERT INTO pwg_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Vaghina ma i mamai Jeikap ivonesi bo, “Mikeda ami kayowana da nakanani taberai na vaghina. Ma ami puyo kokavaraneyei da tomowina kona verei. Okowa ghabughabuna, manigewa, gegura, vavai kii vovoghabughabu, mapa bogii ma bogiiyai, weni dobunai aviyavisina imatiyai tayamoyamoni na kiikiimatanisi kouwana ami ku kutu ma kona nae da kona puyoi. ");
INSERT INTO pwg_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Ma nani manena ami ku kutu iuwana na kokavari da kona vere meyesi. Mikeda wawaya sago bera wapawapa iberai da iuwaname. Ma bade ku tepana mane koviiya da kata vavai kona gimari. ");
INSERT INTO pwg_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Konae, timi kikei korutini ma yaghiyaghinai konoru nani tomowina kurina. ");
INSERT INTO pwg_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Ma ‘God Rewapana Kirakiina’ kurina ainowi da ina berai da tomowina ini kamyuyuwemi ma ini vaghinei da varesimi sago ma Benjamin yavata kona vovirame. Ma ke ini vaghinei ma natunatuku ivi ruwa ani wapisi na vaghina, nuwapoya kamonai ana makai.” ");
INSERT INTO pwg_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Vaghina ma Jeikap natunatuna nani puyosi iyuna ma mane ku tepana ikavari ma Benjamin yavata ivomiiri da inae ku Egypt da Josepa maghinonai imiiri. ");
INSERT INTO pwg_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Ikitisi da Benjamin yavata na ina bigabiga wawayina ivonei bo, “Weni tomotomowisi kerutinisi kona nae aku ku numa. Siya sago kekiivunui ma kevokuyai. Ti na taku yavata madegha punai kana kam.” ");
INSERT INTO pwg_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Vaghina ma ikikava ivonavonei na bigabiga wawayina iberai, irutinisi da inae Josepa ina ku numa. ");
INSERT INTO pwg_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Ma varevaresina na ere yabuyabumanisi inenae, inotanotai bo, “Kunona tapisi tagimara ma ita mane na wawaya sago iuwaname ita ku kutu, nani berana kubiine iviinita wike ina ku numa tapisi. Ina kayowana da ina ravita ma ina berita da ti sleiv ma bade ita donki ina yuna da rapenai.” ");
INSERT INTO pwg_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Varevaresina inekiibau da Josepa ina numa matuketinai na ivi sisiya bigabiga wawayina kurina. ");
INSERT INTO pwg_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","Ivona bo, “Akii bada, kevi yanekai. Kunona kapisi wike da vavai kata gimara, ");
INSERT INTO pwg_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","ma kavovovira da keta borinai kena kubiine ma kavopanani da peyarikai akii kutu kamosiyai na akii mane ikikava kagimagimara na peyarina nani. Tuna kubiine manesi na peyarina kaviini kavovira. ");
INSERT INTO pwg_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Ma wekarakava na mane ku tepana kakavari da vavai kana gimara. Ma ke katakovi da iyai akii mane iuwaname akii ku kutu kamosi.” ");
INSERT INTO pwg_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Bigabiga wawayina ivona bo, “Vaghina, ke kona yabumana. Agunai ami God nani manena iuwana ami ku kutu, tuna God na ami mamai evovokavakavari. Ma akovi da rorova vavai kogimari na kovi mayei. Ami mane na taku mani aviiya.” Vaghina ma Simiyon ivotawei ma irutini ipisi kurisi. ");
INSERT INTO pwg_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Ivi sisiya ikovi na bigabiga wawayina irutinaruwesi Josepa ina ku numa kamona ma okowa iveresi da kaesi ita kowa ma bade i donki kii vavai iveresi da iti kanisi. ");
INSERT INTO pwg_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Ma tomotomowisi namada iakovi da madegha punai na nani numanai ita kam, tuna kubiine i puyo ivovunagha da Josepa ita nekiibau na ita puyoi. ");
INSERT INTO pwg_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Josepa inekiibau na i puyo iyuna da inae ku maghinona da irunoma ma ipuyoi. ");
INSERT INTO pwg_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Ma ivi tarakiiyanesi da ti na vaghina bo kegha, ma muriyai na ivona bo, “Ami mamai imagura kirakai na kovi sisiyei avi yanei, tuna ikikava? Tuna yawayawasina bo?” Josepa ina sisiya na vidamadamana wawayina ivi damani varevaresina kurisi. ");
INSERT INTO pwg_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Ma ivonapotei bo, “Akii mamai na am bigabiga. Ma tuna na vaghina ma yawayawana.” Vaghina ma varevaresina irunomei ivi matakira da ivopepetei. ");
INSERT INTO pwg_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Josepa ikitavirevire da Benjamin ikitai, tuna na tina kikei vaghata ma ivona bo, “Timi kikei kovivi sisiyei na vaghina weni bo?” Ma ivona bo, “Natuku, God ini biibiinim.” ");
INSERT INTO pwg_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Tina kikei ikitai na nuwapoya ivowa kirakiiyei da yaghiyaghinai ikiibau ina ku tupayaragha irui da nani dobunai itou. ");
INSERT INTO pwg_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Josepa itou ikovi na maghighina ikowai ma ikiibau da ivi potepote meyei ma sisiya iterei da ina bigabiga vavai ita riyei. ");
INSERT INTO pwg_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Vavai ivorereghi da Josepa ina kina kava kana vavai na bogiiyai ma varevaresina ti bogiiyai ma Egypt damsi yavata ikamkam na bade bogiiyai. Nakanani irereghi, iyamna Egypt damsi inota meyesi da ti na ighe kirakai tuna kubiine na ke kovokovoghina da Hibru damsi yavata ita kam patapata. ");
INSERT INTO pwg_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Ma bade Josepa varevaresina ivorereghisi da i tupuwa nununai imakai, iyaroko vaghina da inae ku murimuri vaghina. Nakanani ikitakitai na ivi deye kirakiiyei. ");
INSERT INTO pwg_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Ma kii vavai na bigabiga inae da Josepa ina kema tepanai iyuyuna ma ivereveresi da ikamkam. Ma Benjamin na ivi kam kirakiiyei ke varevaresina viya nakanani. Ma vaghina Josepa yavata nuwabiibiiyai ikam ma iuma patapata. ");
INSERT INTO pwg_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Josepa ina bigabiga wawayina ivonei bo, “Witi kiuwana kirakai nani tomotomowisi i ku kutu da ina kavara ma i kutu tepasiyai na sagosago duma i mane kiuwaname. ");
INSERT INTO pwg_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Ma aku redu vovokeyakeyuna na tisi kikei murimuri vaghina ina ku kutu kiuwani ma ina mane yavata.” Vaghina bigabiga wawayina Josepa ikikava ivonavonei na iberai. ");
INSERT INTO pwg_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Mara itom mara boiboi vaghata varevaresina i donki yavata ivonatawesi inae. ");
INSERT INTO pwg_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Ma kwanatu ikiibutawei inenae da ke rabaraba ma Josepa ina bigabiga wawayina ivonei bo, “Yaghiyaghinai nani tomotomowisi keverukivinisi kuna nae. Ma kuna votanisi na kevonesi bo, ‘Avi kubiine biibiina kaberai kurimi ma berona koberai kurikai? ");
INSERT INTO pwg_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Avi kubiine aku bada ina redu koyapini? Mara nonowa nani redunai eumuma ma bade reduna ku kamona ekitakita da bera gavugavusi ini debei kurina. Weni tuna na berabero kirakiina koberai.’” ");
INSERT INTO pwg_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Vaghina ma, bigabiga wawayina inae da kurisi inekiibau ma Josepa ikikava ivonevonei na nakanani ivonesi. ");
INSERT INTO pwg_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Ma ivonapotei bo, “Bada, weni sisiyina na iyamna avai? Tokai kavonavona bubuna da weni berana ke kata berai. ");
INSERT INTO pwg_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Kuyakovi da rorova Keinan dobunai mane akii kutu kamosiyai kavopanana na kudubina kakavara kavovirei kurim. Ma avi kubiine am bada ina numa kamonai silva bo gold kata yapi? ");
INSERT INTO pwg_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Mikeda wawaya sago kamokiiyai kuna panani da iviiya na kuni raboboi. Ma peyarikai na kani sleiv kubiimi.” ");
INSERT INTO pwg_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Ivona bo, “Aivaghinei da iyai reduna ikavakavari tuna wawayina kava na aku sleiv ma peyarimi na vovotawemi kona nae.” ");
INSERT INTO pwg_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Tuna kubiine yaghiyaghinai i kutu ituraororuwana ku tano ma i kutu kawasi ivotatetate. ");
INSERT INTO pwg_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Josepa ina bigabiga wawayina iyarokona gwabinai gini ivi karei da murimurina gwabinai turina iterei. Ma reduna na Benjamin ina kutu kamonai ivopanani. ");
INSERT INTO pwg_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Tuna kubiine ere nuwapoyisi kii gara igosira ma i sawara ivi tawanepepeyana i ku donki ma ivovirame ku kwanatu. ");
INSERT INTO pwg_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Josepa patana da ina numa kamonai imakamakai ma Juda varevaresina yavata inekiibau. Ma maghinonai itawesi ku tano. ");
INSERT INTO pwg_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Ma Josepa ivona bo, “Aviyavisina koberai? Koakovi bo kegha da aku keta emakamakai da bera gavugavusi anakovi? Bera weni nakanani kona berai na yaghiyaghinai ana pananimi.” ");
INSERT INTO pwg_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Juda ivonapotei bo, “Bada, aviyavisina kani sisiyei. Ke keta sago ita makamakai da kana vona da wawaya maninikai. God ivi debei da tokai kabera beroi. Ma wekarakava na peyarikai na am sleiv. Wawayina iyai gwabinai reduna kopanani na yavata.” ");
INSERT INTO pwg_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Ma Josepa ivona bo, “Kegha, ke nakanani ana berai. Meni wawayina aku redu gwabinai tuna wawayina kava na aku sleiv.” Ma peyarimi na nuwanubiiyai kona vovirame ami mamai kurina. ");
INSERT INTO pwg_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Juda inae da imiiririya Josepa kurina ma ivona bo, “Bada, kevi vaghinei da yavata tisisiya. Ke nuwanuwam ina pughu kuriku. Akovi da tam na kiivavo Pero nakanani, am rewapana irakata. ");
INSERT INTO pwg_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Aku bada, kunona tokai am bigabiga kuvi tarakiiyanekai bo, ‘Ami mamai bo varesimi bo kegha?’ ");
INSERT INTO pwg_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Ma kavonapotem bo, ‘Akii mamai emakamakai ma imagura kirakai. Ma tiki kikei sago emakamakai, tuna na akii mamai imagura kirakai ma ivi tuwei. Ma ina maduwa ivi tuwa da ivi ruwa kava ma iyarokona na irabobo ma murimurina kava emakamakai. Akii mamai ina nuwaviina ghamana na tuna.’” ");
INSERT INTO pwg_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","“Ma kuvonekai bo, ‘Korutinapiyei wike da taku mani matakuwai ana kitai.’ ");
INSERT INTO pwg_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Tuna kubiine kavonapotem bo, ‘Tomowa kikei ina mamai ke ina kuyowei, mikeda ina kuyowei na ina mamai ina rabobo.’ ");
INSERT INTO pwg_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Ma kuvonekai bo, ‘Mikeda timi kikei murimuri vaghina ke kona rutinapiyei na maghighiku ke kona kita meyei.’ ");
INSERT INTO pwg_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Ma kavovirame akii mamai kurina na aviyavisina kuvonekai na kavi mamatarei.” ");
INSERT INTO pwg_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","“Muriyai akii mamai ivonekai bo, ‘Kovovira da vavai gisina voghamana kubiita kona gimara.’ ");
INSERT INTO pwg_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Ma kavonapotei bo, ‘Ke kana nae ku Egypt da tiki kikei yavata na vaghina. Mikeda tuna yavata kana nae na tomowina maghighina kana kitai.’” ");
INSERT INTO pwg_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","“Akii mamai na am bigabiga. Ma ivonekai bo, ‘Koakovi da kawaku Risera ivi tuweku da natunatuku tomotomowa ruwa. ");
INSERT INTO pwg_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Ma sago iwapa na avona bo, “Vona bubuna da ghamoghamo dipa ivi raboboi, iyamna ikuyoweku na ke ata kita meyei.” ");
INSERT INTO pwg_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Ma mikeda natuku kana viruwa gwabikuwai kona viitawei ma berona ina tupuwa kurina da tuna yavata ina wapa na nani nuwapoyina ini raboboku iyamna amorapa kirakai. Anoru raborabobosi i ku dobu.’ ");
INSERT INTO pwg_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","Tuna kubiine, aku bada, wekarakava na ke kovokovoghina tiki kikei kana verukuyowei kana vovira akii mamai kurina. Weni tomowa kikina yavata kana vovira na vaghina. Mamai ina yawasa kudubina na tomowa kikina evovotani, ");
INSERT INTO pwg_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","ma ina kita da tomowa kikei gwabikiiyai kegha na ina rabobo. Tokai am bigabiga na wavu kana kavari da akii mamai sisiwina kavonatawei ku dogo kamona. ");
INSERT INTO pwg_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Taku am bigabiga averemeyeku aku mamai kurina tomowa kikei ina yawasa kubiine. Ma avonei da mikeda tomowa kikei ke ana rutini ana vovira kurina na wavuna aku yawasa kamonai ana kavara nonowei. ");
INSERT INTO pwg_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Ma wekarakava na ainowi kurim da tomowa kikei kevonatawei da varevaresina yavata ina nae ma taku na tomowa kikei kana gawara ana viiya da ani sleiv tam kubiim. ");
INSERT INTO pwg_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Ma tomowa kikei kegha na ikikava ana vovira aku mamai kurina? Kegha, ke ata kayokayowei da matakuwai aku mamai weni nuwapoyina ina kavari.” ");
INSERT INTO pwg_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Vaghina ma Josepa ke kovokovoghina da nuwanuwana ita tatani ma ke ina kayowana da ina bigabiga matasiyai ita tou. Tuna kubiine ikwavinisi, ivonesi bo, “Kokiibau!” da peyarisi inae, numa kiibutawei. Josepa ina kina kava na ivi debe meyei varevaresina kurisi da tuna iyai. ");
INSERT INTO pwg_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Ma itou da itousiyasiyapa da Egypt damsi ivi yanei na sisiya ikavari ineyei Pero ina ku numa. ");
INSERT INTO pwg_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Josepa na wekarakava ivi karei da Hibru gamonai ivi sisiya. Varevaresina ivonesi bo, “Taku na Josepa, ma vona bubuna da ita mamai patana da yawayawana, emakamakai bo?” Ma varevaresina weni sisiyina ivi yanei na iyabumana kirakai da ke kovokovoghina ita vonapotei. ");
INSERT INTO pwg_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Vaghina ma Josepa ivonesi bo, “Kopisi wike ku ririku.” Ina sisiya ivi yanei na imiiririya kurina ma ivonesi bo, “Taku na Josepa, varesimi vaghata, taku kovi gimareku Egypt damsi kurisi. ");
INSERT INTO pwg_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Ma wekarakava na ke koni nuwapoya ma bade ke koni wavu meyemi da weni damsi kurisi kovi gimareku. God ina kayowanai da nakanani ita tupuwa, tuna kubiine ivonataweku avi nao da tami aku wawaya ati yawasimi. ");
INSERT INTO pwg_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Weni gomarina kamonai tamakamakai da madegha ruwa ikovi ma bade madegha miikovi maghinotiyai ina makai, nani kamonai na ke kovokovoghina tavao ma tayaba. ");
INSERT INTO pwg_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Ma God ivonataweku avi nao da tami ma tupurereghimi ati yawasimi, gomara kamonai ke kona rabobo. Wena tuna na bera ghamana eberaberai kubiimi. ");
INSERT INTO pwg_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Kokitai, ke tami ami kayowanai wike kota vonataweku, kegha, God ina kayowanai. Tuna iberai da Pero iterepiiku da avi wawayaghama ma ivineku da ina numa kana bada ma bade Egypt kudubina kana bada. ");
INSERT INTO pwg_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Ma wekarakava na yaghiyaghinai kovovira ita mamai kurina ma kovonei bo, ‘Natum Josepa weni nakanani ivona, “God iberai da taku na Egypt dobuna kudubina kana bada, tuna kubiine ke kuni kayovira, yaghiyaghinai ita rakaraka yavata kona pisi kuriku. ");
INSERT INTO pwg_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Tami na Gosen dobunai kona makai da taku ririkuwai, tam, natunatumi, tuputupumi, ami ghamoghamo ma aviyavisina kudubina gwabimiyai na yavata.” ");
INSERT INTO pwg_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Ma taku Egypt kamonai ana koyaghimi iyamna gomarina na patana da madegha miikovi maghinotiyai ina makamakai. Mikeda ke kona pisi na tami, ami rakaraka, ma ami ghamoghamo na kudubimi vitonara ini karavunuwanemi.’” ");
INSERT INTO pwg_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Ma Josepa ina sisiya ikwapanatini ivona bo, “Varevaresiku, wekarakava na peyarimi ma tam Benjamin yavata na matamiyai kokitakitiku da vona bubuna da taku na Josepa.” ");
INSERT INTO pwg_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Ita mamai kovonei da aku rewapana irakata kirakai Egypt dobuna kamonai. Ma aviyavisina kudubina matamiyai kokitakitai na kovi akovi. Ma yaghiyaghinai korutini da konoru kuriku. ");
INSERT INTO pwg_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Ma tina kikei yavata ivi taraghaghavuwana ma ivi ruwa ivi tutuwana. ");
INSERT INTO pwg_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Muriyai ere tutuna varevaresina peyarisi iyonisi ma ituwesi. Nani murinai peyarisi ikweya patapata. ");
INSERT INTO pwg_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Pero na ina numiyai ma sisiya ivi yanei da Josepa varevaresina ipisi na ina wawaya ghamaghamasi yavata ivi nuwabiibii kirakai. ");
INSERT INTO pwg_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Ma Josepa kurina ivona bo, “Varevaresim kevonesi da vavai ini geru i ku ghamoghamo ma ina vovira i ku dobu, ku Keinan. ");
INSERT INTO pwg_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Ma kevonesi da ami mamai ma kakawasi da natunatusi ina rutinisi da ina vovirame wike. Ina pisi na tano ana veresi ma bade Egypt kana biibiina ana veresi da ina kam bubuna. ");
INSERT INTO pwg_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Bade kevonesi da tano wakasi weni dobunai eyuna vaghata ma ina nae ku Keinan da ami mamai, kakawasi ma natunatusi yavata ini gerusi ma ina vovira wike. ");
INSERT INTO pwg_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Ma i sawara ke ini nuwapoyei iyamna Egypt kana biibiina kudubina na ti ini rapenei.” ");
INSERT INTO pwg_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Jeikap natunatuna na ikikava Pero ivonavonesi na nakanani iberai. Ina sisiya nununai na Josepa tano wakasi iyuna ma iveresi ma bade vavai iveresi da kii keta tamiina kubiine. ");
INSERT INTO pwg_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Ma peyarisi sagosago duma na gara vusi iveresi. Ma Benjamin na silva ririghina ivi 300 iverei ma kana gara biibiisi ivi miikovi iverei. ");
INSERT INTO pwg_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Ma Josepa puyo ivonatawei ina mamai kubiine, donki tomotomowisi ivi 10 ku tepasi na Egypt kana sawara kiikiimatanisi iuwani ma bade witi ma vavai bogii ma bogiiyai donki wivinesi ivi 10 ku tepasi iuwani. Vaviisi na ina mamai ina baba ku Egypt na kana keta tamiina. ");
INSERT INTO pwg_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Ivovunagha ikovi na varevaresina ivomiiri, ivonatawesi inenae na ivonesi bo, “Ketiyai kona nenae na ke koni kawapata.” ");
INSERT INTO pwg_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Egypt dobuna ikuyowei ma inae i mamai Jeikap kurina, ku Keinan. ");
INSERT INTO pwg_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Inekiibau na i mamai ivonei bo, “Josepa na patana da yawayawana ma tuna na Egypt dobuna kana bada ghamana.” Jeikap itataghana ma inotakavakavai da ke iti tumaghanesi. ");
INSERT INTO pwg_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Ma Josepa ina sisiya peyarina ivi damani i mamai kurina ma bade ikitai da tano wakasi imiimiiri na nota rewapana iviiya ma ivi tumaghana. ");
INSERT INTO pwg_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Ma Jeikap ivona bo, “Wekarakava na aitumaghanemi da natuku Josepa na patana da yawayawana. Muriyai da ana rabobo na ana nae natuku ana kitai.” ");
INSERT INTO pwg_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Vaghina ma Jeikap ina sawara kudubina iviiya ma ina rakaraka irutinisi da ivomiiri ku Egypt. Inenae da inekiibau ku Beyaseba na isuwara ma ivokavakavara ina mamai Aisiki ina God kurina. ");
INSERT INTO pwg_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Ma nani didibarinai na ina kena kamonai na God ivi sisiya kurina, ivona bo, “Jeikap, Jeikap!” Ma ivonapotei bo, “Taku weni.” ");
INSERT INTO pwg_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Ma God ivona bo, “Taku na God, am mamai ina God. Ke kuna yabumana da kunoru ku Egypt, iyamna nani dobunai ana berim da tupurereghim ina rakata da dam ghamana ina tupuwa. ");
INSERT INTO pwg_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Taku na ke ana voterem, tam yavata toru patapata ku Egypt. Ma mara sago tupurereghim ana rutinisi da ina vovirame ku Keinan. Ma bade ana berai da am rabobo kana ku mara na Josepa na gwabimuwai.” ");
INSERT INTO pwg_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Jeikap natunatuna ivomiiri da i mamai na tano wakasi Pero ivi vonataweyana na ku tepana ivi gerui ma bade nakanani kakawasi ma natunatusi yavata ivi gerusi. Ma vaghina ivomiiri da Beyaseba dobuna ikiibutawei ioru ku Egypt. ");
INSERT INTO pwg_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Ma bade i ghamoghamo, i sawara gwabisiyai Keinan dobunai iviiviiya na yavata inae ku Egypt. Jeikap inenae na ina rakaraka kudubisi na yavata. ");
INSERT INTO pwg_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","Natunatuna, tuputupuna, tomotomowisi ma wivinesi na kudubisi irutinisi da yavata ioru. ");
INSERT INTO pwg_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Jeikap ina rakaraka iyavo kava ioru ku Egypt, kii vava na weni. Jeikap natuna iyarokona na Ruben. ");
INSERT INTO pwg_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Ma Ruben natunatuna tomotomowisi na Hanoki, Palu, Hesron ma Kami. ");
INSERT INTO pwg_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Simeyon natunatuna tomotomowisi na Jemuwel, Jamin, Oyadi, Jakin, Soya ma Saul, tuna na Keinan wavine natuna. ");
INSERT INTO pwg_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Levi natunatuna tomotomowisi na Geson, Koyati ma Merari. ");
INSERT INTO pwg_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Juda natunatuna tomotomowisi na Eru, Onan, Sela, Peres ma Sira (Eru da Onan na Keinan dobunai irabobo.) Peres natunatuna tomotomowisi na Hesron da Hamul. ");
INSERT INTO pwg_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Isaka natunatuna tomotomowisi na Tola, Puwaya, Jasuba, ma Simron. ");
INSERT INTO pwg_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Sebulum natunatuna tomotomowisi na Seredi, Elon ma Jalil. ");
INSERT INTO pwg_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Ma vaghina, weni damsi tavi yavi ikovi na Jeikap kawana Liya yavata Padan Aram dobunai imakamakai na ivi tuwesi da natunatuna ma tuputupuna na ivi 33 ma ku tepana na novusi Daina. ");
INSERT INTO pwg_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Gedi natunatuna tomotomowisi na Sepon, Hagi, Suni, Esbon, Eri, Arodi ma Areli. ");
INSERT INTO pwg_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Asera natunatuna tomotomowisi na Imna, Isva, Isvi, Beriya ma novusi na Seraya. Beriya natunatuna tomotomowisi na Heberu ma Malkiyel. ");
INSERT INTO pwg_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Ma vaghina, weni tomotomowisi ivi 16 na Jeikap da Silpa tupurereghisi. Kunona Silpa na Leiban ina bigabiga ma natuna Liya iverei da ina bigabiga wavinena. ");
INSERT INTO pwg_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Jeikap kawana Risera ivi tuwa da natunatuna tomotomowisi na ivi ruwa kava, Josepa da Benjamin. ");
INSERT INTO pwg_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Ma Egypt dobunai Josepa ivi tuwa da natunatuna tomotomowa ivi ruwa, Manase da Eperaim ma i maduwa na Asenati. Ma Asenati ina mamai na Potipera ma tuna na god vibero ina vokavara ivi badei ‘On’ kwanatunai. ");
INSERT INTO pwg_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Benjamin natunatuna tomotomowisi na Bela, Bekeru, Asbel, Gera, Naman, Eiyi, Rosi, Mupim, Hupim ma Adi. ");
INSERT INTO pwg_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Ma vaghina, weni tomotomowisi ivi 14 tavi yavi ikovi ti na Jeikap da Risera tupurereghisi. ");
INSERT INTO pwg_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Dan natuna tomowina sago kava na Husim. ");
INSERT INTO pwg_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Napitali natunatuna tomotomowisi na Jasiyel, Guni, Jeseru ma Silem. ");
INSERT INTO pwg_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Ma vaghina, weni tomotomowisi ivi 7 na Jeikap da Biliya tupurereghisi. Biliya na Leiban ina bigabiga ma natuna Risera iverei da ina bigabiga wavinena. ");
INSERT INTO pwg_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Jeikap tupurereghina vaghata ioru ku Egypt na ivi 66 ma nani kamonai na rawarawana wivinesi na ke kati yavisi. ");
INSERT INTO pwg_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Ma ku tepana na Josepa, ma natunatuna ruwa na Egypt kamonai itupuwa. Peyarisi tisagosi na Jeikap tupurereghina yavata ivi 70. ");
INSERT INTO pwg_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Jeikap inenekiibau ku Egypt na Juda ivonatawei ivi nao Josepa kurina da keta ita tupavibeyesi da ita nae ku Gosen dobuna. ");
INSERT INTO pwg_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Inekiibau ku Gosen na Josepa yaghiyaghinai ina serioti ivovunagha ma igeru inae da ina mamai ita verupotei. Josepa inekiibau na ina mamai itaraghavui ma ituwei da kana guri. ");
INSERT INTO pwg_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Ma Jeikap, natuna Josepa ivonei bo, “Taku mani matakuwai akitim da tam patana da yawayawam kemakamakai. Wekarakava ata rabobo na nuwabiibiiyai ata nae.” ");
INSERT INTO pwg_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Vaghina ma Josepa ivi sisiya ina mamai ma varevaresina ma ina rakaraka kudubisi kurisi, ivonesi bo, “Ana nae kiivavo Pero kurina ma ana vonei da varevaresiku ma aku mamai ina rakaraka Keinan dobunai ivivi makiiyana na ipisi kuriku. ");
INSERT INTO pwg_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Ma ana vonei da tami na sipu kii koyakoyagha ma bade ghamoghamo viya yavata kokoyakoyaghisi. Ma kopisi na ami ghamoghamo yavoyavosi ma ami sawara kudubina yavata koviiya ma kopisi.” ");
INSERT INTO pwg_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Vaghina ma Josepa ina rakaraka ivonesi bo, “Ma Pero ina kwatumi kona rui na ini tupaviremi da weni marana gurigurina komakamakai na avi bigasi kava koberaberai. ");
INSERT INTO pwg_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","Ma tami na weni nakanani kovonei, ‘Tokai am bigabiga na gisigisikiiyai ghamoghamo vikam kavi karei. Nakanani akii mami mau da doboro mau ivivi kam.’ Nakanani kona vonapotei na ini vaghinei da Gosen dobunai kona makai, iyamna Egypt damsi na sipu kii koyakoyagha ke ita kayokayowesi.” ");
INSERT INTO pwg_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Josepa inae da Pero ivonei bo, “Aku mamai ma varevaresiku i sipu da i ghamoghamo ma i sawara kudubina rapesiyai iyuna da Keinan dobuna ikuyowei. Ma ipisi da wekarakava ti na Gosen dobunai.” ");
INSERT INTO pwg_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Ma Josepa varevaresina ivi miikovi yavata inae da Pero kurina iti maghibeyesi. ");
INSERT INTO pwg_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Vaghina ma Pero ivi tarakiiyanesi bo, “Weni marana gurigurina komakamakai na avi bigasi kava koberaberai?” Ma ivonapotei bo, “Tokai am bigabiga na ghamoghamo kii koyakoyagha nakanani ma akii mami mau.” ");
INSERT INTO pwg_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Ma bade ivonei bo, “Tokai kapisi da Egypt dobunai kana makai mara gisina, iyamna Keinan dobunai na gomara irakata ma ibero kirakai. Tuna kubiine akii ghamoghamo na kii vavai kegha. Kainowi kurim da kuni vaghinei da Gosen dobunai kana makai.” ");
INSERT INTO pwg_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Ma Pero, Josepa ivonei bo, “Ainuwabiibai da am mamai da varevaresim ipisi kurim. ");
INSERT INTO pwg_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Ma Egypt dobuna na kekita bubuni da tano kiimatana keveresi. Gosen dobuna keveresi da ina makai. Ma mikeda kamosiyai kuakovi da wawaya biga bubunisi ina makamakai na keteresi da taku mani aku ghamoghamo ina koyaghisi.” ");
INSERT INTO pwg_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Muriyai Josepa ina mamai Jeikap irutini ipisi da Pero ivi maghibeyei. Ma Jeikap, Pero ivi kiikiiwei ma ivi nowi Bada kurina da Pero iti biibiini. ");
INSERT INTO pwg_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Ma nani murinai na Pero, Jeikap ivi tarakiiyanei bo, “Kam madegha na viya?” ");
INSERT INTO pwg_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Ma Jeikap, Pero ivonei bo, “Aku yawasa kamonai abababa yawara da madegha 130 ikovi. Taku kaku madegha na itupo ma ipiropiro ke nakanani ma aku mamai mau, ti i baba kamonai na kii madegha ine kirakai.” ");
INSERT INTO pwg_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Vaghina ma Jeikap, Pero ivi biibiina meyei ma ikuyowei. ");
INSERT INTO pwg_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Ma vaghina, Josepa ina mamai da varevaresina Egypt dobunai iteresi. Irutinisi inae da ikikava Pero ivonavonei nununai iberai, tano kiimatanina Ramese ina parata ririnai iveresi, nani dobuna kana vava sago na Gosen. ");
INSERT INTO pwg_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Ma bade vavai iveresi, ina mamai da varevaresina ma bade ina mamai ina rakaraka ma ededa gisigisi, i koroto nununai vavai irereghi kurisi. ");
INSERT INTO pwg_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Gomarina Egypt da Keinan dobusiyai na irakata ma ibero kirakai da nani dobuna wawayisi kii vavai ikovi ma vitonara ikarakarisi. ");
INSERT INTO pwg_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Tuna kubiine mara nonowa damsi inenae Josepa kurina da vavai igimagimari na manesi kudubina Josepa iyuyuna da ikavakavari Pero ina ku numa. ");
INSERT INTO pwg_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Ma Egypt da Keinan dobusiyai mane ikovi na damsi patana da inenae Josepa kurina ma ivonavonei bo, “Vavai keverekai. Tokai akii mane ikovi, ma, ke ita biibai da matamuwai kana rabobo.” ");
INSERT INTO pwg_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Vaghina ma Josepa ivonesi bo, “Nakanani na tivovivirana, ami ghamoghamo kona vereku na vavai ana veremi, iyamna ami mane ikovi.” ");
INSERT INTO pwg_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Tuna kubiine i ghamoghamo peyarina irutinapiyei Josepa kurina da vavai iveresi, i hosi, i sipu, i gote, i kau ma i donki ivi vovivirana vavai kubiine. Madegha sago kamonai i ghamoghamo ivivi vovirana ma kii vavai ruvana ivereveresi da tepanai imakamakai. ");
INSERT INTO pwg_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Nani madeghina ikovi ma murina madeghinai na ivovirame Josepa kurina ma ivona bo, “Tam na akii bada, ma wekarakava na ke kovokovoghina da kani kawagavugavuwem. Vonavaghata da akii mane ikovi ma bade akii ghamoghamo na tam kuvi rapenei. Ke sago aviyavisina ita makamakai kata verem da wawayikai ma akii tano kava. ");
INSERT INTO pwg_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Avi kubiine maghinomuwai kana rabobo? Akii tano ma tokai wawayikai kegimarikai, tivovivirana vavai kubiine ma kani sleiv Pero kubiine ma bade akii tano ini rapenei. Vavai keverekai da ke kana rabobo ma bade pei keverekai kana voni da tano ke ina makii wapawapa.” ");
INSERT INTO pwg_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Vaghina ma Josepa i tano kudubina Egypt kamonai igimaratawei da Pero ivi rapenei. Gomara irakata kirakai tuna kubiine na Egypt damsi kudubisi i tano ivi gimarei kiivavo Pero kurina, tanona kudubina na rapenai. ");
INSERT INTO pwg_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Egypt dobuna kamonai na Josepa iberai da meyagii nununai wawaya kudubisi ivi sleiv yavu. ");
INSERT INTO pwg_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Ma kegha da iyavo kava god viviberosi i vokavara ibadei na kii tano kava na ke ita gimari, iyamna kii reregha na nonowa Pero gwabinai iviiviiya, tuna kubiine kii vavai imakamakai ma kii tano na ke iti gimarei. ");
INSERT INTO pwg_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Ma iyavo kava ivi sleiv ma i tano ivi wapai, na Josepa ivi sisiya kurisi, ivonesi bo, “Wekarakava na tami ma ami tano agimari ikovi Pero kubiine. Ma pei weni koyuna da ami bada Pero kubiine kona vovao. ");
INSERT INTO pwg_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Witi borina kana mara ina nekiibau na riba miikovi koterei da riba sago na Pero koverei ma riba ivi ruwamaruwa na kovotani da ami pei ma kami vavai, tami ma ami rakaraka ma iyavo kava yavata komakamakai na kubiimi.” ");
INSERT INTO pwg_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Ma wawayisi ivonapotei bo, “Akii bada, tam kuvi yawasikai, tam kubiibii kirakai. Tokai na kani sleiv Pero kubiine.” ");
INSERT INTO pwg_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Weni berasi kubiine Josepa taravatu iterei da Egypt dobuna kamonai na riba miikovi ina terei ma sago na kiivavo rapenai. Weni taravatuna na Egypt damsi patana da evovotani. Ma iyavo kava god viviberosi i vokavara ibadei na ti kava kii tano na Pero ke iti rapenei. ");
INSERT INTO pwg_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Israel damsi Gosen dobuna kamonai imakamakai da i mura irakata ma ivi tuwa da natunatusi ipeyari kirakai. ");
INSERT INTO pwg_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Jeikap, Egypt dobuna kamonai imakai da madegha 17 ikovi ma nani maranai na kana madegha 147. ");
INSERT INTO pwg_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Ma ina mara itupo da ita rabobo na natuna Josepa ikwatui ma ivonei bo, “Mikeda am nuwaviina irakata kirakai kuriku na imam ku daghadaghaku keterei, kevi matakira da aku kayowana kuna berai. Am agabiibiiyai aku sisiya kuna vokikini ma kuna vonakiiyapa da ke Egypt dobunai kuna dogoku. ");
INSERT INTO pwg_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Ana rabobo na Egypt dobunai kekavarakiibuweku da meni dobunai aku mami mau idogosi na nani dobunai kuna dogoku.” Ma Josepa ivonapotei bo, “Ikikava kuvoneku na ana berai.” ");
INSERT INTO pwg_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Ma Jeikap ivoname, “Kevonakiiyapa da kuna berai.” Ma vaghina, Josepa vonakiiyapa bagibagina iterei ina mamai kurina. Ma Jeikap ina diwonai itupavibagi ma idune da God ivokavakavari. ");
INSERT INTO pwg_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Ke mara gurina ma wawaya inae Josepa kurina, ivi akovi da ina mamai Jeikap na igubaga. Tuna kubiine natunatuna ruwa Manase da Eperaim irutinisi da yavata inae. ");
INSERT INTO pwg_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Ma Jeikap sisiya iviiya da Josepa ipisi da ita kitai na ere nununa ivomiiri da ivi kiimakiiyei. ");
INSERT INTO pwg_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Ma natuna Josepa kurina ivona bo, “Mara sago God Rewapana Kirakiina irumatara kuriku Lus kwanatunai, tuna na Keinan dobuna kamonai. Ivi biibiiniku ");
INSERT INTO pwg_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","ma ivona bo, ‘Ana berai da kuni tuwa kirakai da am koroto ina rakata, tupurereghim ina rakata da dam ma dam ina tupuwa. Ma weni dobuna na tupurereghim ana veresi da ini rapena tuwanonowi.’” ");
INSERT INTO pwg_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Ma ina sisiya ikwapanatini ivona bo, “Josepa, natunatum Eperaim da Manase namada itupuwa weni dobuna Egypt kamonai ma nani murinai apisi da yavata tamakamakai. Ma wekarakava ivi ruwa aviiviinisi da ti na natunatuku vaghata nakanani ma Ruben da Simiyon. ");
INSERT INTO pwg_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Ma weni ededisi murisiyai kuna vivituwa na tam kava rapemuwai. Ma tano buderina kona rerereghi na murimurisi i tano na Eperaim da Manase gwabisiyai ina viiya. ");
INSERT INTO pwg_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Rorova kava Padan dobunai kabababa da keta borinai am maduwa Risera irabobo. Tuna na Keinan dobuna kamonai ma ke ita rabaraba da ku Eperati da weni nuwapoyina apanani. Ma vaghina, ere matadogaku na Eperati ketana baranai adogoi.” ");
INSERT INTO pwg_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Jeikap, Josepa natunatuna ikitisi na ivi tarakiiyana bo, “Weni ededisi na iyavo?” ");
INSERT INTO pwg_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Ma Josepa ina mamai ivonapotei bo, “Weni ededisi na taku natunatuku. Egypt dobunai amakamakai na God ivereku.” “Kerutinapiyesi kuriku da ani biibiinisi.” ");
INSERT INTO pwg_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Ma Jeikap na imagura kirakai da matana isowai da ke ruvaruvana ita kita bubuna. Vaghina ma Josepa natunatuna irutinapiyesi i doboro kurina da itaraghavusi ma iyonisi. ");
INSERT INTO pwg_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Ma Jeikap ivona bo, “Ke ata notai da maghighim ata kita meyei ma wekarakava na God ivi vaghinei da tam, natunatum yavata akitakitimi.” ");
INSERT INTO pwg_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Muriyai Josepa natunatuna Jeikap dogarinai itinavivirisi ma ina mamai maghinonai irunoma da maghighina ku tano. ");
INSERT INTO pwg_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Ma natunatuna iviinisi da Jeikap ku maghinona iteresi da imiimiiri. Eperaim na murimurina tuna kubiine iviiya da Jeikap ku dugena iterei ma Manase na iyarakona tuna kubiine ku katagheyana iterei. ");
INSERT INTO pwg_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Ma kegha, Jeikap imana ivi kiivonei da katagheyanai ivororona da Eperaim ku gayamina iterei, namanaki da tuna murimurina, ma dugenai ivororona da Manase ku gayamina iterei, namanaki da tuna iyarokona. ");
INSERT INTO pwg_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","19","Ma Josepa na ke iti nuwabiibai, ikitai da ina mamai katagheyana Eperaim ku gayamina tepana iterei. Tuna kubiine ina mamai imana ivotani ma ina kayowana da Eperaim gayaminai ita votawei da Manase ku gayamina ita terei. Ma Josepa ina mamai ivonei bo, “Kegha mamai, ke nakanani, weni tuna na iyarokona katagheyam ku gayamina keterei.” Ma kegha, ina mamai ke iti vaghinei ma ivona bo, “Akovi, natuku, akovi. Ma tuna bade tupurereghina ina rakata kirakai. Ma kegha da tina kikei ina rewapana ina rakata kirakai ke iyarokona nakanani. Ma tupurereghina ina rakata da kamosiyai dam ma dam ina tupuwa.” Nani murinai na Josepa natunatuna yavata ivi biibiinisi ivona bo, “Ainowi da God ini biibiinimi. Aku doboro Abraham da aku mamai Aisiki na God ivokavakavari ma i yawasa kamonai ivotekatekei. Ma bade God na taku kaku koyakoyagha, aku yawasa karenai da weni ku marana ivi noweku. Ma ina aneya ivivi tarapaparaneku da berona ke ata panana tovoni. Ainowi da weni ededisi ini biibiinisi! Ainowi da ti na kaku vava ma Abraham da Aisiki kii vava ina voviteteyanei. Ma ainowi da dobuwai i koroto ina rakata kirakai.” ");
INSERT INTO pwg_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Vaghina ma Jeikap ivi ruwa ivi biibiinisi, ivona bo, “Ma Israel damsi vibiibiina ina beraberai na tami avamiyai.” Ina vona bo, “Ainowi da God ina berim da Eperaim da Manase nakanani.” Weni sisiyisi kubiine Jeikap tupuna Eperaim iviiya da ivi nao, Manase maghinonai iterei. ");
INSERT INTO pwg_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Nani murinai Jeikap natuna Josepa ivonei bo, “Taku gisina kava ma ana rabobo ma God na gwabimuwai ma mara sago tupurereghim yavata ina rutinimi kona vovira ita mami mau i ku dobu, ku Keinan. ");
INSERT INTO pwg_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Ma tam na Sekem dobuna avereverem ma varevaresim na kegha. Tuna dobuna kubiine na aku seri ma dosiyowai avi tona da Amo damsi gwabisiyai aviiya. Ma dobuna na tano mumurina.” ");
INSERT INTO pwg_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Vaghina ma Jeikap natunatuna ikwaturiyariyesi ma ivonesi bo, “Komiirigwagwariku ma ana vonemi da mara karakava epipisi na aviyavisina ina tupuwa kurimi. ");
INSERT INTO pwg_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Natunatuku, taku ami mamai Jeikap. Kopisi wike ma kovi yana. Kaku vava sago na Israel. Koriyemi da aku sisiya koni yanei. ");
INSERT INTO pwg_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Ruben, natuku iyarokom, tam na aku rewapana. Kutupuwa na ivi matakira da taku na avi tomowa. Tam na kayotatam ma rewapana kirakiim natunatuku peyarisi kamosiyai. ");
INSERT INTO pwg_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Tam na kayoghakighakim ma kara ke kuni wawayaghama, iyamna kawaku yavata bera berona koberai da aku kepana gawarina kuvi dadabui. ");
INSERT INTO pwg_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Simiyon da Livai Tami na ami seri na kapiya kubiine, ami kayowana vighaviya. ");
INSERT INTO pwg_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Ami ogatara gavugavusi ke ati vaghinei, Ma ami ku dughu kamosi ke ana rui. Nuwanuwami ipughupughu na wawaya kovi kiivunuwana, Ma bade ghamoghamo korugwarigwarisi da kaesi kovi sidarisi, Iyamna ami kayowana ghamana da ina vokwarakwara. ");
INSERT INTO pwg_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Ami nuwapughu ma ami kayoghakighaki na iberoberowana kirakai, Tuna kubiine God inimagimi. Ma Israel dobunai tupurereghimi ina kiivigerisi Ina berisi da Jeikap tupurereghina kamosiyai ini bogebogesi. ");
INSERT INTO pwg_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Juda, tam na varevaresim ini gheghenim, Ma imamuwai kam ghavighaviya kuna ghegavovorisi. Am tuwa mau ma titim yoghoyogho ina runomem. ");
INSERT INTO pwg_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","O Juda, tam na laiyon natuna. Kuvokiira, kukam ma kuvovira am ku bonagha. Tam nakanani ma laiyon wavinena iti kwerukweru da ita kenakena, Ke sago iyai da ini tataghani. ");
INSERT INTO pwg_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Tupurereghim mara nonowa ini bada, Ti na kiivavo ina diwona ina voviteteyanei. Ke kovokovoghina ini damani dam sago kurisi. Ina nenae da wawayina vaghata ina nekiibau. Ina nekiibau ma dam ma dam ina pisi da ina suwari ma ina vokaravei. ");
INSERT INTO pwg_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Ina mura ina rakata da ina donki ku greipi kunukununa ina warimi. Ku greipi uravina ina kune da ruguruguna ina kamkam. Ma kana gara na wain kamonai ina kowai. Kana tarasovo na greipi muina tarataranai ina vokutuvi. ");
INSERT INTO pwg_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Matana na ina yebari da wain nakanani. Ma okena na ina poi kirakiiyei da mereki nakanani. ");
INSERT INTO pwg_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Sebulun, tam na kikira baranai kuna makai Ma tam gwabimuwai na waka ina viviwotawotei, Am parata ina nae da ku Sidon. ");
INSERT INTO pwg_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Isaka, tam na nakanani ma donki, Vita kana kavakavara. ");
INSERT INTO pwg_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Kuna kitai da am viyakam gawarina na ibiibii kirakai ma am tano na biibiina kavakava, Ma kegha da kuna tupe meyem da biga vitana kuna berai, ma bade wawaya ina darum da kuna vobagibagi kirakai. ");
INSERT INTO pwg_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Dan na tam kuni dam sago Israel kamonai Ma nota maninina tepanai am wawaya kuni tupaviresi ma kuni badesi. ");
INSERT INTO pwg_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Tam na mota sago keta baranai, Tam nakanani ma mota berona keta ekenakenapotai da hosi kaegidugiduna ina tonai, Hosi ina tonai na ini kapoka ma geru wawayina murimuriyai ina peku.” ");
INSERT INTO pwg_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","Muriyai da Jeikap ina sisiya ita kwapanatini, ivona bo, “O Bada, akoyakoyaghim da kuni yawasiku.” Vaghina ma, ivona bo, ");
INSERT INTO pwg_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","“Gedi, tam kurim na keta bababasi yapiyapisi ina kayaya, ma kegha da kuna miiritavire da kuna kwavinisi. ");
INSERT INTO pwg_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Asera, tam na am tano na mumurina ma kiikiivavo kii vavai ina yamona da vaviisi na biibiisi ma magimagisi. ");
INSERT INTO pwg_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Ma Napitali, tam na nakanani ma diya wavinena, tuna na vovotawena da ina kayowanai ina baba, ma ituwa da natunatuna na kiikiimatanisi. ");
INSERT INTO pwg_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Ma Josepa, tam na nakanani ma greipi ere amamena da vusira baranai emiimiiri. Ma ragharaghana ituwa ikiibu kirakai da ku gari kupuna. ");
INSERT INTO pwg_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Dosiyo wawayisi ere nuwapughupughusi ina kayaya kurim da iti tonem ma kegha. ");
INSERT INTO pwg_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Taku Jeikap aku God Rewapana Kirakiina ina vowagum, Tuna na sipu kii koyakoyagha nakanani, tota Israel kata wakima rewapanina Tuna kubiine am yovu kuna vokikini da bagibagina, ma imam na rewapana makamakiina, ke ina mitamita. ");
INSERT INTO pwg_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Iyamna am mamai ina God ini vitem, God Rewapana Kirakiina ini biibiinim. Kunuma da dobu kana vibiibiina ina verem ma tupurereghim ini biibiinisi da ini tuwa ma ini susu bubuna. ");
INSERT INTO pwg_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Taku am mamai aku vibiibiina avereverem na ighe kirakai, da koya vovosi ighekuyowesi, irakata da koya katakatamanisi irogusi. Weni vibiibiinisi peyarina na tam Josepa avereverem, ku tepam atereterei, ma varevaresina kamosiyai tam na kiivavo. ");
INSERT INTO pwg_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Ma Benjamin, tam na nakanani ma kukou dipa kayakayayina. Ikikava mara boiboiyai kukou kana siya ina vowai ma ina kam yavui na nakanani, kam ghavighaviya kuna vowa kirakiiyesi. Ma raviyai sawara gwabisiyai kuneboi na kuna vorereghi am wawaya kurisi.” ");
INSERT INTO pwg_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Ma vaghina, Jeikap nakanani ivi sisiya natunatuna kurisi, sago sago duma i bera nununai ivi biibiinisi. Ma natunatuna, ti na Israel kana dam ivi 12 i kaekiki mau. ");
INSERT INTO pwg_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Jeikap natunatuna weni nakanani ivi varavarisi, “Gisina kava ma ana rabobo. Ana rabobo na tupuwiku koviiya kona nae da imapatana aku mamai da aku doboro buba kamonai idogosi na nani dobunai kona dogoku. Kunona nani bubana na Hiti wawaya rapenai, tomowina kana vava na Eperon. ");
INSERT INTO pwg_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","Bubana na dobu kana vava Makipela kamonai, tuna na Mamre ririnai, Keinan dobunai. Abraham nani tanona Hiti wawaya kana vava Eperon gwabinai igimari da nevanevana na ivi karawagei. ");
INSERT INTO pwg_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Ma nani dobunai na Abraham kawana Sera yavata idogosi ma bade Aisiki kawana Rebeka yavata idogosi. Ma bade nani dobunai kawaku Liya adogoi. ");
INSERT INTO pwg_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Ma nani tanona da bubana na Hiti damsi gwabisiyai igimari da rapetiyai.” ");
INSERT INTO pwg_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Ma natunatuna tomotomowisi ivi varavarisi ikovi na kaena itawanepai ina ku kenakena gawarina, yana itapurai ma irabobo. ");
INSERT INTO pwg_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Josepa ina mamai irabobo na itaraghavui, iyoni ma ituwei. ");
INSERT INTO pwg_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Vaghina ma sisiya bagibagina iterei da ina mamai tupuwina ita vovunaghi, ku gegura ita vokutuvi da ke ita bowa. ");
INSERT INTO pwg_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Ivokutuvi da mara 40 tupuwina ivotani. Ma bade Egypt damsi na mara 70 irubasepa Jeikap irabobo kubiine. ");
INSERT INTO pwg_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Basepa kana mara ikovi na Josepa inae da Pero ina wawaya ghamaghamasi ivonesi bo, “Kade, kovokovoghina bo kegha da aku sisiya kota kavaraneyei Pero kurina? ");
INSERT INTO pwg_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","Aku kayowana da mamai tupuwina ata viiya ata neyei ku Keinan dobuna da buba tuna mani imanai ipapai na ku kamona ata terei. Ina mara itupo da ita rabobo na ivoneku da Keinan dobunai ata dogoi ma avi vaghinei, maghinonai vonakiiyapa bagibagina aberai. Tuna berana ana berai ina kovi na ana vovirame.” ");
INSERT INTO pwg_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Vaghina ma Pero ivonapotei bo, “Kenae da am mamai kuna dogoi, ikikava kuvonakiiyapa na nununai keberai.” ");
INSERT INTO pwg_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Vaghina ma, Josepa ivomiiri da ita nae da ina mamai ita dogoi. Ma koroto ghamana yavata inenae, ti na Pero ina wawaya ghamaghamasi, Egypt dobuna kana babada ghamaghamasi ma bade ");
INSERT INTO pwg_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Josepa varevaresina ma ina rakaraka ma ina mamai ina wawaya peyarisi na ivi kaeturanei da yavata inae. Ma ededa yoghoyogho i maduwa mau yavata da i ghamoghamo na Gosen dobunai ivoteresi da imakai. ");
INSERT INTO pwg_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Koroto irakata kirakai. Ma kamosiyai viya na seriyotiyai igeru ma bade viya na hosiyai igeru. ");
INSERT INTO pwg_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Ma inekiibau ku Atadi, tuna na witi kana gudaguda gawarina, Jodan okowina ririnai. Nani dobunai na peyarisi itou da itousiyasiyapa ma rabobo kana kiki inunuri na tupuwina ivotani da mara 7 ikovi. ");
INSERT INTO pwg_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Ma Keinan damsi ikitisi da ivivi tutuwana Atadi dobunai na ivona bo, “Egypt damsi na tou ghamana eberaberai.” Tuna kubiine dobuna ivi vavei Abel Misrayim, vavana iyamna na Egypt damsi nani dobunai isiyapa. ");
INSERT INTO pwg_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Jeikap natunatuna tomotomowisi ikikava ivonavonaveresi na peyarina iberai. ");
INSERT INTO pwg_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Tupuwina iviiya inae ku Makipela, Mamre ririnai, Keinan dobuna kamonai da nani dobunai buba ku kamona iterei. Tanona na mara katamanai Abraham igimari Hiti wawaya kana vava Eperon gwabinai da kii karawaga. ");
INSERT INTO pwg_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Josepa ina mamai Jeikap idogoi ikovi na varevaresina ma iyavo kava inae idogodogo na peyarisi ivovirame ku Egypt. ");
INSERT INTO pwg_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","I mamai irabobo murinai na Josepa varevaresina ivona bo, “Tita kikei patana da nuwanuwana epughupughu kurita bo kegha? Kade ina nota ererereghi da tavi kayotiranei na biwana ina viiya bo?” ");
INSERT INTO pwg_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Tuna kubiine Josepa kana sisiya ivonatawei ivona bo, “Muriyai da ita mamai ita rabobo na ");
INSERT INTO pwg_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","ivonekai da kati nowi kurim da akii berabero kuna notatawei. Wekarakava na tokai am mamai ina God ina bigabiga kainowi kurim da akii berabero kuna notatawei.” Josepa nani sisiyina iviiya na itou kirakai. ");
INSERT INTO pwg_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Vaghina ma Josepa varevaresina timani ipisi da maghinonai itawesi da maghighisi ku dowa ma ivonei bo, “Tokai na am sleiv.” ");
INSERT INTO pwg_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Ma Josepa ivonesi bo, “Ke kona yabumaneku, taku ke God da kami kovogha ana veremi. ");
INSERT INTO pwg_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Kovi ogatara da kovi agaberoweku ma kegha da God iruvovirei da ku biibiina. Nakanani iberai da karako wawaya peyarisi yawasa ipanani. ");
INSERT INTO pwg_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Tuna kubiine ke kona yabumana, tami ma natunatumi ana koyagha bubunimi.” Ma sisiya biibiinai ivonesi da nuwanuwasi ipika. ");
INSERT INTO pwg_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Josepa ma ina mamai ina rakaraka yavata Egypt dobuna kamonai imakai inenae da kana madegha 110 ma irabobo. ");
INSERT INTO pwg_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Imakai inae da Eperaim natunatuna ma tuputupuna ikitisi ma bade Manase natuna Makiri natunatuna irapisi. ");
INSERT INTO pwg_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Josepa varevaresina ivonesi bo, “Taku gisina kava ma ana rabobo. God tuna kovokovoghina da ina rutinimi da Egypt dobuna kona kiibutawei. Ma ikikava vonakiiyapa bagibagina Abraham, Aisiki da Jeikap kurisi iterei da dobu ita veresi na nani ku dobuna kona nae.” ");
INSERT INTO pwg_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Muriyai Josepa ivonesi bo, “Vona bubuna da mara sago God ina vowagumi, ina rutinimi da weni dobuna kona kiibutawei. Ma vonakiiyapa bagibagina koterei da nani maranai tuwiriku kona kavari da yavata kona nae.” ");
INSERT INTO pwg_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Vaghina ma Josepa imakai da kana madegha 110 ma irabobo. Tupuwina na ku gegura ivokutuvi da ke ita bowa ma nani murinai na igerei ma Egypt dobunai imakai. ");
INSERT INTO pwg_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Kimta ma kimta kamonai na Yesu Keriso ina kaekiki mau kii vava girumina na weni. Yesu na Kiivavo David tupurereghina, ma David na Abraham tupurereghina. ");
INSERT INTO pwg_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham natuna na Aisiki, ma Aisiki natuna na Jeikap, ma Jeikap natunatuna na Juda titina yoghoyogho yavata, ");
INSERT INTO pwg_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Ma Juda natunatuna na Peres ma Zera, ma i maduwa na Tama, ma Peres natuna na Hesron, ma Hesron natuna na Ram. ");
INSERT INTO pwg_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ma Ram natuna na Aminadab, ma Aminadab natuna na Nason, ma Nason natuna na Samon, ");
INSERT INTO pwg_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","ma Samon kawana na Reiyab ma natusi na Bowas, ma Bowas kawana na Ruti ma natusi na Obedi, ma Obedi natuna na Jesi, ");
INSERT INTO pwg_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","ma Jesi natuna na Kiivavo David. Ma David na Uraya kwapurina iravaghi ma ivi tuwa da natusi na Soromon, ");
INSERT INTO pwg_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","ma Soromon natuna na Reyobowam, ma Reyobowam natuna na Abiya, ma Abiya natuna na Asa, ");
INSERT INTO pwg_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","ma Asa natuna na Jospat, ma Jospat natuna na Jeyoram, ma Jeyoram natuna na Usaya, ");
INSERT INTO pwg_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","ma Usaya natuna na Jotam, ma Jotam natuna na Ahas, ma Ahas natuna na Hesekaya, ");
INSERT INTO pwg_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","ma Hesekaya natuna na Manase, ma Manase natuna na Amon, ma Amon natuna na Josaya, ");
INSERT INTO pwg_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","ma Josaya natunatuna na Jekonaya titina yoghoyogho yavata. Nani maranai Babilon damsi ipisi ma Israel damsi ipatumisi ma irutinisi ku Babilon da kubiisi ita biga. ");
INSERT INTO pwg_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Nani dobunai Jekonaya natuna Seletiyel itupuwa, ma Seletiyel natuna na Zerubabel, ");
INSERT INTO pwg_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","ma Zerubabel natuna na Abiudi, ma Abiudi natuna na Eliyakim, ma Eliyakim natuna na Aso, ");
INSERT INTO pwg_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","ma Aso natuna na Zadok, ma Zadok natuna na Akim, ma Akim natuna na Eriyudi, ");
INSERT INTO pwg_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","ma Eriyudi natuna na Eriyesa, ma Eriyesa natuna na Matan, ma Matan natuna na Jeikap, ");
INSERT INTO pwg_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","ma Jeikap natuna na Josepa. Ma Josepa kawana Meri ivi tuwa da Yesu, ma tuna na God ina Vivinevine Wawayina. ");
INSERT INTO pwg_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Abraham ina kimtiyai da David ina ku kimta nani kamonai na kimta ivi 14. Ma bade David ina kimtiyai da Jekonaya ina ku kimta (ti damsi na irutinisi ku Babilon) na nani kamonai kimta ivi 14. Ma bade Babilon murinai da Keriso ina ku mara nani kamonai na kimta ivi 14. ");
INSERT INTO pwg_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Yesu Keriso na weni nakanani itupuwa. Ina maduwa Meri na Josepa kana vopapara. Muriyai da ita ravaghi na Meri damina iviiya da Kanuma Vovokaravina ina rewapanai iropeya. ");
INSERT INTO pwg_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Ma Josepa na tomowa maninina, tuna kubiine maranai akova iviiya da Meri na roperopeyina, nota iviiya da gavugavunai ita voterei. Ma ke wawaya matasiyai ita berai da Meri iti avaberowei. ");
INSERT INTO pwg_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Nakanani nuwanuwana ivivi tetei ma ina matu kamonai Bada ina aneya kurina inekiibau. Ivona bo, “Josepa, tam David tupurereghina, Meri kuna ravaghi da kawam. Ke kuna yabumana, iyamna Kanuma Vovokaravina ina rewapanai iropeya. ");
INSERT INTO pwg_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Meri ini tuwa da natuna tomowa ma kuni vavei Yesu, iyamna ina wawaya i berabero kamonai ini yawasisi.” ");
INSERT INTO pwg_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Weni berasi peyarina ivi debei da aviyavisina rorova mara katamaninai God peroveta Aisaya kurina ivi sisiyei da ita tupuwa na itupuwa. Aisaya weni nakanani igiruma, ivona bo, ");
INSERT INTO pwg_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Kovi yana, wiwike gubugubu na ke meyani tomowa damina ita viiya, ma kegha da ina ropeya da natuna tomowa ini tuwei. Ini vavei Imanuweru.” Nani vavana iyamna, “God gwabitiyai emakamakai.” ");
INSERT INTO pwg_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Vaghina ma, Josepa irumataka ma aviyavisina aneya ivonavonei na peyarina iberai. Meri irutini ");
INSERT INTO pwg_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","da yavata imakamakai. Nani kamonai Josepa, Meri damina ke ita viiya, ikoyakoyaghi da iti tuwa. Ma ivi tuwa da natuna tomowa ma Josepa tomowa kikei ivi vavei Yesu. ");
INSERT INTO pwg_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Yesu Beteliyem kwanatunai itupuwa, tuna na Judiya dobunai ma nani maranai na Herodi ivivi kiivavo. Nani murinai nuwagiura wawayisi maramatanai ipisi ku Jerusalem ");
INSERT INTO pwg_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","ma ivivi tarakiiyana bo, “Jiu damsi i kiivavo wekarakava itupuwa na imapatana? Ina tupuwa matakirina na gwamegwame maramatanai kakitai ma kapisi da kata vokavakavari.” ");
INSERT INTO pwg_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Ma Kiivavo Herodi weni sisiyina ivi yanei ma nuwanuwana ikarai, ma ke tuna kava, Jerusalem kamonai wawaya peyarisi yavata. ");
INSERT INTO pwg_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Ma Herodi taparoro babadisi i babada ma vonaviyoyovana vibeyebeyena wawayisi ikwaturiyariyesi ma ivi tarakiiyanesi bo, “God ina Vivinevine Wawayina na meni dobunai ita tupuwa?” ");
INSERT INTO pwg_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ivonapotei bo, “Beteliyem kwanatunai, Judiya dobunai. Peroveta sago weni nakanani igiruma, ");
INSERT INTO pwg_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Ma tami Beteliyem dami, Juda dobunai, Ke kona tereoruwe meyemi. Judiya dobunai na kwanatu ipeyari ma kamosiyai kami vava irakata, iyamna kamomiyai kiivavo sago ina kiibau da aku wawaya Israel damsi ini nowesi.’” ");
INSERT INTO pwg_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Vaghina ma Herodi maramatana wawayisi gavunai ikwaturiyariyesi ma gwabisiyai akova iviiya da avi maranai gwamegwamena inekiibau. ");
INSERT INTO pwg_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Ma ivonatawesi ku Beteliyem ma ivonesi bo, “Konae, ma wawaya kikei koekwa bubuni. Kona panani na kovovira da kona vonavereku. Ma taku bade ana nae da ana vokavakavari.” ");
INSERT INTO pwg_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Herodi ina sisiya ivi yanei ikovi ma maramatana damsi ivomiiri. Nani gwamegwamena maramatanai ikitai na ivi nowesi da meni dobunai wawaya kikei imakamakai na tepanai ivi kiimiiriyei. ");
INSERT INTO pwg_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Ikitai ma nuwanuwasi ibiibii kirakai. ");
INSERT INTO pwg_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Ma nani ku numana irui na wawaya kikei ina maduwa yavata ikitisi. Ma ivi tuwaporeruruwana, ma wawaya kikei ivokavakavari. Ma i kutu ivi votaweyana da kamonai gold, frankinsens ma meya iyuna da wawaya kikei isuwarei. ");
INSERT INTO pwg_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Ma i matu kamonai God ivonesi da ke ita vovira Herodi kurina, tuna kubiine keta bogiiyai iviiya da ivovira i ku dobu. ");
INSERT INTO pwg_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Maramatana wawayisi inae ma muriyai Josepa ina matu kamonai Bada ina aneya ivonei bo, “Kevomiiri, wawaya kikei ma ina maduwa yavata kona nae ku Egypt dobuna, iyamna Herodi wawaya kikei inekwai da ina kiivunui. Nani dobunai kona makai ma kara ana vonemi da kona vovira.” ");
INSERT INTO pwg_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Vaghina ma, Josepa wawaya kikei ina maduwa yavata irutinisi, didibarai ivomiiri ku Egypt ");
INSERT INTO pwg_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","da nani dobunai imakamakai da Herodi irabobo. Weni berasi peyarina ivi debei da aviyavisina rorova mara katamaninai God peroveta Hoseya kurina ivi sisiyei da ita tupuwa na itupuwa. Hoseya igiruma da God ivona bo, “Natuku ana kwatui da Egypt ina kiibutawei.” ");
INSERT INTO pwg_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Herodi damina iviiya da maramatana wawayisi ivi beroberowei na nuwanuwana ipughu. Ma i sisiya inotapanani da avi maranai gwamegwame matakirina inekiibau. Tuna kubiine sisiya bagibaginai seri damsi ivonatawesi ku Beteliyem ma bade ku meyagai gisigisi Beteliyem ririnai da kamosiyai tomotomowa gisigisi kii madegha ruwa ma gaburinai iti kiivunuwana. Vaghina ma berana iberai. ");
INSERT INTO pwg_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Ma aviyavisina peroveta Jerimaya ivi sisiyei na itupuwa. Igiruma bo, ");
INSERT INTO pwg_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Rama dobunai tutou ighae. Risera natunatuna kubiisi etutou ma esiyasiyapa. Wawaya itinavurei ma ivi kayokayo kavai, iyamna natunatuna irabobo yavu.” ");
INSERT INTO pwg_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Kiivavo Herodi irabobo ma murinai na Egypt kamonai Bada ina aneya matuwai inekiibau Josepa kurina. ");
INSERT INTO pwg_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Ma ivona bo, “Kevomiiri, wawaya kikei ina maduwa yavata kuna rutinisi kona vovira ku Israel dobuna, iyamna nani damsi wawaya kikei ita kiivunui na irukwa yavu.” ");
INSERT INTO pwg_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Vaghina ma Josepa ivomiiri ma wawaya kikei ina maduwa yavata irutinisi ma ivovira ku Israel. ");
INSERT INTO pwg_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Ma ivi yanei da Akereyosi ivivi kiivavo Judiya kamonai, tuna ina mamai Herodi kana gawara iviiya. Tuna kubiine iyabumana ma ke ita kayokayowei da Judiya kamonai ita makai. Ma matuwai God ivonaverei da ita nae ku Gariri dobuna. ");
INSERT INTO pwg_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Tuna kubiine inae da Nasaret kwanatunai imakai. Weni berasi peyarina ivi debei da aviyavisina rorova mara katamaninai God peroperoveta kurisi ivivi sisiyei da ita tupuwa na itupuwa, ivona bo, “Wawaya ina vona da tuna Nasaret tomowa.” ");
INSERT INTO pwg_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Nani marasiyai Jon Babataito inae ku Judiya ma warere kamonai dima ivi karei. ");
INSERT INTO pwg_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Ma ivonavona bo, “Ami bera beroberosi kovinimayei ma komiirikupukuputei, iyamna wekarakava na God ina vikiivavona enenekiibau.” ");
INSERT INTO pwg_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Peroveta Aisaya ina giruma kamonai Jon ivi sisiyei. Ivona bo, “Wawaya sago warereyai ekwatukwatu bo, ‘Bada ina keta kovovunaghi, Keta maninina koberai ma ina pisi.’” ");
INSERT INTO pwg_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Ma Jon kana gara na kamel vunivuninai iyamoni ma kana boriwaya na ghamoghamo bekana. Ma kana vavai na madi da manigewa. ");
INSERT INTO pwg_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Wawaya Jerusalem kamonai ma Judiya dobuna kamonai ma bade dobu kudubisi Jodan okowina ririnai na peyarisi inae Jon kurina. ");
INSERT INTO pwg_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Ma i berabero debiiyai ivivi mamatarei ma Jon ibababataitosi Jodan okowina kamonai. ");
INSERT INTO pwg_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Perisi ma Sadusi damsi ipisi Jon kurina da ita babataito na Jon ikitisi ma ivonesi bo, “Tami mota natunatusi! Iyi ivonemi da God ina kovogha epipisi na kona veruvuvurei? ");
INSERT INTO pwg_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Kovonavona da ami berabero komiirikupukuputei na ami yawasa iti mamatara da vonavaghata. ");
INSERT INTO pwg_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Ma ke kona nota meyemi da tami Abraham tupurereghina kubiine na God ina kovogha kona veruvuvurei. Avonavonemi, God kovokovoghina da weni wakimisi ina berisi da ini wawaya da ti na Abraham tupurereghina. ");
INSERT INTO pwg_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Wawaya ere karuwakoyina namada kii kunukunusiyai emiimiiri ma meni kiina amena ke biibiina na ina taratawei ma ku keyama karakaratina ina tawei. ");
INSERT INTO pwg_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Ma taku okowai abababataitomi, tuna ivi matakira da ami berabero komiirikupukuputei. Ma murikuwai wawaya sago rewapana kirakiina ina nekiibau na taku ke wawaya kiimataniku da ata tawopika da kaena kana terepapara uravina ata rupamatawei. Ma tuna wawayina na Kanuma Vovokaravinai ma keyama karakaratinai ina babataitomi. ");
INSERT INTO pwg_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Mara sago ini tupavirevireta ma ina rereghita da biibiita ma beroberota. Biibiisi ina rutinisi ku kunuma ma ina koyagha bubunisi. Ti nakanani ma whiti vavina da wayowa wawayina ina maghara, numa kweta kamonai ina terei. Ma beroberosi ti nakanani ma whiti muguna. Wayowa wawayina ina yuna da ina tawei ku keyama karata makamakii nonowina da ina karai.” ");
INSERT INTO pwg_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Ma Yesu Gaririyai ivomiiri ku Jodan okowina da Jon gwabinai ita babataito. ");
INSERT INTO pwg_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Ma Jon ikayowei da Yesu ina nota ita virai, tuna kubiine ivona bo, “Taku ke wawaya kiimataniku da ana babataitom. Ma tam na taku kuta babataitoku.” ");
INSERT INTO pwg_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Ma Yesu ivonapotei bo, “Kegha vaghina, tam kuna babataitoku. Weni nakanani taberai, iyamna bera maninina ma God ina kayowana.” Ma Jon ivi vaghinei. ");
INSERT INTO pwg_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Yesu ibabataito ma okowai igheghetawei na kunuma itamotate ma ikita da God ina Kanuma Vovokaravina nakanani ma gabubu iororu kurina da tepanai itowa. ");
INSERT INTO pwg_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ma nani kamonai kunumai God gamona ivona bo, “Weni tuna na natuku vaghata. Tuna na nuwanuwaku, ainuwabiibiiyei.” ");
INSERT INTO pwg_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Nani murinai Kanuma Vovokaravina Yesu irutini ku warere da Devil ita pisi da Yesu ita ruyaghai. ");
INSERT INTO pwg_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Madeghai ma didibarai ivivi siya da mara 40 ikovi ma vitonara ikara kirakiiyei. ");
INSERT INTO pwg_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Ma Devil ipisi ma ivona bo, “Tam God natuna, bo? Kevona da weni wakimisi ini parawa.” ");
INSERT INTO pwg_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Yesu ivonapotei bo, “Giruma katamana evonavona bo, ‘Wawaya ke parawa kava tepanai ita makamakai ma God gwabinai vonana ekiikiibau na tuna tepanai ina makai.’” ");
INSERT INTO pwg_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Nani murinai Devil, Yesu irutini ku Jerusalem, tuna na kwanatu vovokaravina. Ma ighae ku Taparoro Numana vovona. ");
INSERT INTO pwg_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Ma Devil ivona bo, “Tam God natuna, bo? Ketawem kunoru. Giruma katamana evonavona bo, ‘God ina aneya ina vonesi da ina koyagha bubunim, ma ina vokemim da kaem ke wakima ina takurei.’” ");
INSERT INTO pwg_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Ma Yesu ivonapotei bo, “Giruma katamana bade evonavona bo, ‘Bada God ke kuna rubui.’” ");
INSERT INTO pwg_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Nani murinai Devil, Yesu irutini da ku koya tepana ma dobu kudubina ina mura yavata ivi beyei. ");
INSERT INTO pwg_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Ma Devil ivona bo, “Kuna runomeku ma kuna vokavakavariku na aviyavisina peyarina kekitakitika na ana verem da kuni badei.” ");
INSERT INTO pwg_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Ma Yesu ivonapotei bo, “Seitan, kenetaweyana! Giruma katamana evonavona bo, ‘Am Bada God ina kina kava kevokavakavari ma kevotekatekei.’” ");
INSERT INTO pwg_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Ma vaghina, Devil inae. Ma Bada ina aneya viya inekiibau ma Yesu ikoyagha bubuni. ");
INSERT INTO pwg_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Yesu sisiya ivi yanei da Jon gabura kamonai na ivovirame ku Gariri dobuna. ");
INSERT INTO pwg_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Ma Nasaret kwanatuna ivoterei ma inae da Kapeniyam kwanatunai imakai. Nani kwanatuna na Gariri tokana baranai, Zebulun ma Napitali damsi i dobu kamonai. ");
INSERT INTO pwg_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Nakanani iberai da aviyavisina peroveta Aisaya igirumi na itupuwa, ivona bo, ");
INSERT INTO pwg_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Gariri na Zebulun ma Napitali damsi i dobu. Tuna kikirai, Jodan okowina nevanai, ma kamonai na kupuna damsi peyarisi imakiiyana. ");
INSERT INTO pwg_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Tuna dobunai wawaya nubakutuva kamonai imakamakai, ma yasegana ghamana ina kitai. Iyavo kava rabobo damina eviiviiya ma nubakutuvina kamonai emakamakai na kurisi yasegana ina nekiibau.” ");
INSERT INTO pwg_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Nani maranai Yesu dima ivi karei, ivonavona bo, “Ami bera beroberosi kovinimayei ma komiirikupukuputei, iyamna God ina vikiivavona enenekiibau kurimi.” ");
INSERT INTO pwg_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Yesu Gariri tokana kikirinai ibababa ma tomotomowa ruwa ikitisi iwiwito. Ti i biga na iyana ikonakonisi ma ivivi gimara. Sago na Saimon (kana vava sago Pita) ma sago na tina kikei Anduru. ");
INSERT INTO pwg_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Ma Yesu ivonesi bo, “Kopisi, kokiviniku. Ani beyebeyemi da wawaya kona konisi.” ");
INSERT INTO pwg_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Ma yaghiyaghinai i wito ivoterei ma Yesu ikivini. ");
INSERT INTO pwg_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Inae gisina ma tomotomowa ruwa ikitisi, ti na Zebedi natunatuna Jemes ma Jon. Waka kamonai i mamai yavata i wito iwuwurapotapotai ma Yesu ikwatusi ");
INSERT INTO pwg_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","na yaghiyaghinai i mamai ma i waka ikuyowei ma Yesu ikivini. ");
INSERT INTO pwg_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Yesu Gariri dobuna ine yavui ma kiki numasi kamosiyai ivivi beyebeyena, God ina vikiivavona idimadimei. Ma wawaya kii gubaga bogii ma bogiiyai na kudubisi ivivi yawasisi. ");
INSERT INTO pwg_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Varana Siriya dobuna ine yavui, ma wawaya turaturasi gubagubagisi irutinisi kurina. Kii gubaga bogii ma bogiiyai. Viya na ininisi ivivi visivisiyana, viya na paroparorosi, viya na digadigasi ma bade viya kanuma beroberosi gwabisiyai irunuma. Ma Yesu peyarisi ivi yawasisi. ");
INSERT INTO pwg_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Tuna kubiine koroto ghamaghamasi ivivi kiidaburana da Yesu ikivikivini. I dobu na Gariri, Dekapolis, Jerusalem, Judiya ma bade Jodan okowina nevanai. ");
INSERT INTO pwg_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Yesu koroto ghamana ikitisi na ighae ku koya barana ma ivi kiimakiiyei. Kana kivikivina ipisi kurina ");
INSERT INTO pwg_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","ma vibeyebeyena ivi karei. Ivonesi bo, ");
INSERT INTO pwg_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Iyavo kava kanuma ina ku nevaneva mitamitasi na God ini biibiinisi ma ina vikiivavona na rapesiyai. ");
INSERT INTO pwg_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Iyavo kava etutou na God ini biibiinisi ma ini kayokayosi. ");
INSERT INTO pwg_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Iyavo kava vovokuwayisi na God ini biibiinisi ma ti na dobu ini rapenei. ");
INSERT INTO pwg_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Iyavo kava keta iekwekwa kirakiiyei da God ina kayowana ina kivini na God ini biibiinisi ma ini vitesi da ina panani. ");
INSERT INTO pwg_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Iyavo kava wawaya ikamyuyuwesi na God ini biibiinisi ma ini kamyuyuwesi. ");
INSERT INTO pwg_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Iyavo kava nuwanuwasi yagharina na God ini biibiinisi ma mara sago maghighina ina kitai. ");
INSERT INTO pwg_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Iyavo kava wawaya i vikawapata erarayaragha bo wawaya ivitesi da viruwa evovoterei na God ini biibiinisi ma ina vonesi da ti na natunatuna. ");
INSERT INTO pwg_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Iyavo kava God evovotekatekei da vitupaketowana damina eviiviiya na God ini biibiinisi ma ti na ina vikiivavona na rapesiyai.” ");
INSERT INTO pwg_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Tami iyavo kava taku kubiiku wawaya iavaberowemi bo itupaketowanemi bo viberowai iwavumi na God ini biibiinimi. ");
INSERT INTO pwg_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Kovi nuwabiibii kirakiiyei iyamna kunumai God ini miiya bubunimi. Koakovi da ikikava itupaketowanemi na nakanani peroperoveta mara katamaninai ivivi tupaketowanesi.” ");
INSERT INTO pwg_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Tami na dobu kana yegai. Mikeda yegai damina ina wapa na ikikava taberai da damina ina vovira? Ke kovokovoghina. Tuna ibero, wawaya ina tawei ma ini tugudagudai.” ");
INSERT INTO pwg_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Tami na dobu kana yasegana. Ma kwanatu koya tepanai na yaseganina ke kovokovoghina da ina gavui, wawaya peyarisi ina kitai. ");
INSERT INTO pwg_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Ke meyani wawaya rampa ina kapuni ma bayawa vivikuratabuna kamonai ina terei. Ini rorokei da wawaya kudubisi numa kamonai yasegana ina veresi. ");
INSERT INTO pwg_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Tuna kubiine bera biibiisi koberai da tuna nakanani ma yasegana gwabimiwai ekarakarata. Wawaya ina kitai ma ami Mamai kunumai ini ghegheni.” ");
INSERT INTO pwg_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Ke kona notai da apisi da Moses ma peroperoveta i giruma ata kiiviwapawapai. Apisi da aviyavisina igirumi da ita tupuwa na ina tupuwa. ");
INSERT INTO pwg_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Vonavaghata avonavonemi, karako da kunuma ma dobu i ku damona na nani kamonai ke sago avi girumina gisi korekorena God ina vonaviyoyovana kamonai ina wapa. Aviyavisina ivi sisiyei na peyarina ina tupuwa. ");
INSERT INTO pwg_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Tuna kubiine tam iyai vonaviyoyovana kamonai sisiya bagibagina gisi korekorena kuni kiigiiyei, ma wawaya kuni beyebeyesi da ti yavata ini kiigiiyei na kam vava inoru kirakai God ina vikiivavona kamonai. Ma tam iyai vonaviyoyovana kamonai sisiya bagibagisi kuna nunura bubuni ma wawaya kuni beyebeyesi da ti yavata ina nunura bubuni na kam vava ina rakata God ina vikiivavona kamonai. ");
INSERT INTO pwg_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Avonavonemi, God kota votekateka kirakiiyei da Perisi damsi ma vonaviyoyovana vibeyebeyena wawayisi kota ghekuyowesi. Ke kona votekateka na God ina vikiivavona ku kamona ke kona rui.” ");
INSERT INTO pwg_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Namada kovi yanei da mara katamaninai God ivona bo, ‘Ke kuna kiivunuwa. Meni wawayina kiivunuwa ina berai na tuna wawayina vitupavira ma kovogha ina panani.’ ");
INSERT INTO pwg_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ma taku avonavonemi da meni wawayina nuwanuwana ipughu varesina kurina na tuna yavata vitupavira ma kovogha ina panani. Ma bade, meni wawayina varesina ina vonatepatepani na babada Sanhidran kamonai ini tupavirei. Ma meni wawayina nuwanuwana ina pughu kirakai da varesina ina vonei bo, ‘Neghanegham!’ na ina nae ku keyama karata makamakii nonowina. ");
INSERT INTO pwg_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Tuna kubiine, mikeda am suwara God kurina ketereterei ma nani kamonai kuna notapanani da varesim kurina berona kuberai na ");
INSERT INTO pwg_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","am suwara na suwara kana kema ririnai keterekuyowei ma kenae da varesim yavata koni vonapoteyana. Muriyai kuna vovira ma kuna suwara God kurina.” ");
INSERT INTO pwg_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Wawaya ini wavum na kebera tovoni da yaghiyaghinai koni vonapoteyana. Ketiyai kona baba kona nenae vitupavira badana kurina na nani kamonai kovi vonapoteyana. Ke kuna berai na ini damanim vitupavira badana kurina. Ma tuna ina vonakiiyaragha da kubera beroi ma seri wawayina ku imana ina terem da ku gabura ina tawem. ");
INSERT INTO pwg_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Vonavaghata avonavonemi, gabura kamonai kuna makamakai da kam kovogha kudubina kuni miiya yavui ma muriyai da kuna kiibau.” ");
INSERT INTO pwg_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Namada kovi yanei da Moses igiruma bo, ‘Wawaya ke kawam vaghata na ke yavata koni pekana.’ ");
INSERT INTO pwg_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ma taku avonavonemi, tam iyai wavine kukitakirorowei na namada nuwanuwam kamonai berabero kuberai. ");
INSERT INTO pwg_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Mikeda matamuwai aviyavisina kuna kitai ina berim da nota berona kuna notai na matam ketupamiitawei ma ketawei. Ibiibai da tupuwim nevanevana kava kuni wapai da berabero kuna voterei. Ma ibero da tupuwim kudubina ina makai ma berabero kuna beraberai na karakava God tupuwim kudubina ku keyama karakaratina ina tawei. ");
INSERT INTO pwg_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ma bade katagheyamuwai berabero kuna berai na kekiiyaraghatawei ma ketawei, iyamna ibiibai da tupuwim nevanevana kava kuni wapai da berabero kuna voterei. Ma ibero da tupuwim kudubina ina makai ma berabero kuna beraberai na karakava God tupuwim kudubina ku keyama karakaratina ina tawei.” ");
INSERT INTO pwg_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Ma bade igiruma bo, ‘Tomowa kawana ina barei na kana sisiya ina girumi ma ina verei ma muriyai ina vonatawei ina nae.’ ");
INSERT INTO pwg_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Ma taku avonavonemi, meni tomowina kawana ina barei ma ina vonatawei na berabero iberai. Ma mikeda karakava wavinena tomowa sago ina ravaghi na vipekana wapawapa eberaberai, tuna na berabero. Ma ke wavinena kava ma bade kawana wadubona yavata wavuna ina kavari. Ma meni tomowina nani wavinena iravaghi, tuna yavata na berabero eberaberai. Ma bera sago kava kubiine ani vaghinei da wawaya kawana yavata ini kiitawetaweyana. Mikeda ina vopanani da kawana ke iti patutu ma wawaya sago yavata ivi pekana na tuna maranai ini kiitawetaweyana na vaghina.” ");
INSERT INTO pwg_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Ma bade namada kovi yanei da mara katamaninai Moses igiruma bo, ‘Am vonakiiyapa bagibagina ke kuni kiigiiyei. Ma aviyavisina kuvonakiiyapa Bada kurina na keberai.’ ");
INSERT INTO pwg_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Ma taku avonavonemi da vonakiiyapa bagibagisi ke kona bera wapawapai. Ke kunuma vavanai konitukikita da vonakiiyapa bagibagina kona terei, iyamna tuna na God ina vikiivavo gawarina. ");
INSERT INTO pwg_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Ma bade ke dobu vavanai konitukikita da vonakiiyapa bagibagina kona terei, iyamna tuna na God kaena kana kepana. Bo ke Jerusalem vavanai konitukikita da vonakiiyapa bagibagina kona terei, iyamna tuna na Kiivavo God ina kwanatu vovokaravina. ");
INSERT INTO pwg_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Ke gayamimiyai konitukikita da vonakiiyapa bagibagina kona terei, iyamna tam ke kovokovoghim kuna berai da uyawim sago kava ina dumai bo ina poini. ");
INSERT INTO pwg_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Am vonakiiyapa kubiine na kevonota bo, ‘Vaghina, ana berai.’ Bo, ‘Kegha, ke ana berai.’ Ma sisiya viya am vonakiiyapa ku tepana kuna terei da wawaya ini tumaghanem na sisiyisi Seitan gwabinai ipisi.” ");
INSERT INTO pwg_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Namada kovi yanei da mara katamaninai Moses igiruma bo, ‘Wawaya matam ina tupamiimiini na bade nakanani matana kuna tupamiimiini. Ma bade wawaya okem ina rigei, nakanani bade okena kuna rigei.’ ");
INSERT INTO pwg_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ma taku avonavonemi da wawaya ina berona ke kuni nevani. Mikeda wawaya nevanevam ina tapini na ketavira da bade nevana ina tapini. ");
INSERT INTO pwg_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Bo mikeda vitupavira kamonai ina panani da berona kuberai wawaya sago kurina na kam kovogha na kam gara sago ina viiya na bade ku tepana kam tarasovo keverei. ");
INSERT INTO pwg_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Mikeda seri wawayina ita darum da ina sawara kuta kavari da mutuba sago kota kenaviviri, kekavari da mutuba ruwa kona kenaviviri. ");
INSERT INTO pwg_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Ma wawaya ini nowi kurim na keverei. Ma wawaya ita vonem bo, ‘Kade am sawara kuta vereku ma karakava ata vovirei’ na keverei, ke kuna miirikupukuputei.” ");
INSERT INTO pwg_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Namada kovi yanei da igiruma bo, ‘Turaturami nuwanuwasi koviiya, ma kami ghavighaviya kovi matatonetonesi ma kobaresi.’ ");
INSERT INTO pwg_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Ma taku avonavonemi da kami ghavighaviya nuwanuwasi koviiya, ma iyavo kava itupaketowanemi na kubiisi konipowana. ");
INSERT INTO pwg_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Weni nakanani kona berai na koni debemi da tami God natunatuna vaghata, iyamna tuna madegha ma garewa na ke wawaya biibiisi kava ita vereveresi ma wawaya beroberosi yavata. Ke maninisi kava ita vereveresi ma kawakiikiisi yavata. ");
INSERT INTO pwg_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Wawaya ini nuwaviina kurimi ma koni nevani na God ke ini miiyemi. Teks yuyuna damsi na berabero wawayisi ma kegha da nakanani inuwaviina. ");
INSERT INTO pwg_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Mikeda turaturami kava koni kiikiiwesi na tuna ke bera ghamana. Kupuna damsi bade nakanani eberaberai. ");
INSERT INTO pwg_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Ma tami na kovi wawaya kiimatana da ami Mamai kunumai nakanani.” ");
INSERT INTO pwg_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Kokitaruvimi da ami bera kiikiimatanisi ke debiiyai kona berai da wawaya ina kitimi ma ina kawabiibiiyemi. Mikeda nakanani kona berai na ami Mamai God kunumai ke ini miiyemi.” ");
INSERT INTO pwg_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Maranai kovereverena wawaya moyamoyakisi kurisi na ke miiriruwaruwasi evereverena nakanani kona verena. Ti na tureyai iyonayona ma evereverena da kiki numasiyai ma ketiyai wawaya ina kitisi ma ini gheghenisi. Vonavaghata avonavonemi, wawaya namada igheghenisi, tuna kubiine God ke ini miiyesi. ");
INSERT INTO pwg_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Ami verena moyamoyakisi kurisi na gavugavunai koberai da wawaya ke ina kitimi. Katagheyami ina vereverena na dugemi ke inakovi. ");
INSERT INTO pwg_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Gavugavunai koverena da ami Mamai, tuna bera gavugavusi iakova yavui na ini miiyemi.” ");
INSERT INTO pwg_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Ma bade ke kona nipowana miiriruwaruwasi nakanani. I kayowana ghamana da kiki numasiyai bo ketiyai ina nipowana da wawaya ina kitisi ma ini gheghenisi. Vonavaghata avonavonemi, kii miiya namada iviiya. ");
INSERT INTO pwg_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Ma nipowana kubiine na korui numa ku tupayaraghina kamona ma matuketa kogudui. Ami Mamai ke kitakitana na kurina konipowana ma ini miiyemi, iyamna tuna bera gavugavusi iakova yavui.” ");
INSERT INTO pwg_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Ma ami nipowana kamonai na ke sisiya sago kava kona terei ma kona terei ma kona tere meyei kupuna damsi nakanani. Enotanotai da i nipowana ina guri na i god viviberosi ini yanesi. ");
INSERT INTO pwg_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Ke kona berai da ti damsi nakanani, iyamna ami Mamai na ami kayowana namada iakovi ma muriyai koni nowi. ");
INSERT INTO pwg_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Tuna kubiine weni nakanani kona nipowana. ‘Akii Mamai kunuma makamakiim, Kam vava kavovokaravei. ");
INSERT INTO pwg_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Kainowi da am vikiivavona ina nekiibau. Am kayowana kunumai etuputupuwa na bade nakanani dobuwai ita tupuwa. ");
INSERT INTO pwg_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Karako kakii vavai keverekai. ");
INSERT INTO pwg_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Akii bera beroberosi kenotatawei. Bade nakanani wawaya i bera beroberosi kurikai iberai na kanotatawei. ");
INSERT INTO pwg_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Kevi noravekai da ruyagha ke kana panani. Ma ketarapaparikai da wawaya bero kirakiina ke ina vowikai.’” ");
INSERT INTO pwg_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Wawaya berabero ina berai kurimi ma kona notatawei na bade ami Mamai kunumai ami berabero ina notatawei. ");
INSERT INTO pwg_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ma i berabero ke kona notatawei na bade ami Mamai kunumai ami berabero ke ina notatawei.” ");
INSERT INTO pwg_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Kona vivisiya na ke miiriruwaruwasi i bera nakanani kona berai. I kayowana da ini debei wawaya kurisi da ke ita kamkam ma ke itumuma. Tuna kubiine ti na maghighisi kitasi beroberosi. Vonavaghata avonavonemi, wawaya namada igheghenisi, tuna kubiine God ke ini miiyesi. ");
INSERT INTO pwg_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Ma tami kona vivisiya na komonagha bubuna ma maghighimi kokowai. Ke koni debe meyemi ");
INSERT INTO pwg_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","da wawaya inakovimi da koisiya. Ami Mamai kava inakovi. Tuna ke kitakitana ma bera gavugavusi iakova yavui ma tuna ini miiyemi.” ");
INSERT INTO pwg_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Dobu ina mura ke kona nuwatani, iyamna ami maghara na kaniketekete ina kani bo ina ravuwa bo yapiyapi wawayisi numa ina gavovori da ina yapiya. ");
INSERT INTO pwg_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Ma God ina kayowana koberai da tuna nakanani ma ami maghara kunumai koti daburi. Ma kunumai na kaniketekete, ravuwa, ma yapiyapi kegha. ");
INSERT INTO pwg_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Ami mura imapatana kovi daburi na nuwanuwami ma ami nota na nani dobunai.” ");
INSERT INTO pwg_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Matam na tupuwim kana kibe. Mikeda matam biibiina na tupuwim kudubina ina biibai ma ere yaseganina. ");
INSERT INTO pwg_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Ma mikeda matam berona na tupuwim kudubina ina bero ma ere nubakutuvina. Mikeda tam nubakutuva wawayim ma kenotanotai da yasegana gwabimuwai emakamakai na kiberoberowe meyem ma am yawasa kamonai na nubakutuva irakata kirakai.” ");
INSERT INTO pwg_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Wawaya ke kovokovoghina da babada ruwa kubiisi ina biga. Bada sago kurina ina biga bubuna ma sago ina vonabarei. Sago nuwanuwana ina viini ma sago ina barei. Ke kovokovoghina da tami ami babada ruwa, sago na God ma sago na mane.” ");
INSERT INTO pwg_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Tuna kubiine avonavonemi da ami yawasa ke koni nuwapoyei da aviyavisina kona kani bo aviyavisina konumai. Tupuwimi ke koni nuwapoyei da aviyavisina kona kotei. Ami yawasa kamonai, kam ma gara na ke bera ghamaghamasi. ");
INSERT INTO pwg_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Kiu kokitisi, ke ita wayowayowa ma ke ita yabayaba bo ke ita vovovidaburana. Ma kegha da ami Mamai kunumai ikanikanisi. God ku matana tami kobiibii kirakai, ke kiu nakanani. ");
INSERT INTO pwg_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Ma nuwapoya ke ini vitemi da ami yawasa ina guri.” ");
INSERT INTO pwg_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Ma avi kubiine gara koinuwapoyei? Berana kokitisi, dipiiyai egogogo wapawapa. Ke ita wayowayowa ma kii gara ke ita yamoyamoni. Ma kegha da kitasi ibiibii kirakai. ");
INSERT INTO pwg_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Avonavonemi da Kiivavo Soromon tuna mura wawayina da kana gara kitana biibiina. Ma kegha da berana dipiiyai kitasi ibiibii kirakai, ke Soromon kana gara nakanani. ");
INSERT INTO pwg_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Karako berana egogogo ma God ikotevunaghisi. Ma maram wawaya ina kapuni da ina karai. Ma tami bade ini kotevunaghimi. Ami vitumaghana igisi ghagha!” ");
INSERT INTO pwg_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“Tuna kubiine ke koni nuwapoya da kona vona bo, ‘Avi kana kani?’ bo ‘Avi kanumai?’ bo ‘Avi kana kotei?’ ");
INSERT INTO pwg_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Iyavo kava God ke ita vivitumaghanei na weni sawarisi inuwapoyei. Ma tami na ami Mamai kunumai iakovi da ami kayowana avai. ");
INSERT INTO pwg_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Kunona God ina vikiivavona konekwai ma ina kayowana kona berai na aviyavisina mara nonowa koekwekwai da dobuwai kota makai bubuna na ina veremi. ");
INSERT INTO pwg_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Tuna kubiine maram kana bera ke koni nuwapoyei. Maram na mara sago, tuna mani kana nuwapoya emakamakai. Ma karako kana nuwapoya na tuna kava kokitai.” ");
INSERT INTO pwg_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Yesu ivona bo, “Wawaya ke koni tupaviresi na God ke ini tupavirem. ");
INSERT INTO pwg_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Ikikava wawaya koni tupavireviresi ma kovogha kona vereveresi na God nakanani ini tupavireviremi ma kovogha ina vereveremi. Ma ikikava i yawasa koruvaruvai na God nakanani bade ami yawasa ina ruvai. ");
INSERT INTO pwg_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Avi kubiine kwinam matanai vunavuna kekitakitai ma kinuwapoyei ma tam mani matamuwai kiibuta ghamanakina ikenapotai na damina ke kuta viiviiya? ");
INSERT INTO pwg_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Avi kubiine varesim kevonavonei bo, ‘Kepisi, vunavuna matamuwai ana votawei,’ ma tam mani matamuwai na kiibuta ghamana ikenapotai? ");
INSERT INTO pwg_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Tam miiriruwaruwam! Kunona kiibuta tam mani matamuwai kevotawei da kuna kita bubuna ma muriyai vunavuna kwinam matanai kuna votawei.” ");
INSERT INTO pwg_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Iyavo kava God ina sisiya vovokaravisi namada ibarei na ke kurisi kuni beyebeyena, iyamna ti nakanani ma kukou, ina miiritavire ma ina kanim. Ma bade kam posaru kiimatanina ke kuna tawei poro kurisi, iyamna ini tugudagudai.” ");
INSERT INTO pwg_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Kevi nowi da God ina verem. Ma kekwa da am kayowana kuna panani. Kekiipowapowara da kubiim matuketa ina votawei. ");
INSERT INTO pwg_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Iyavo kava ini nowi na peyarisi ina viiya. Iyavo kava inekwa na ina kayowana ina panani. Ma iyavo kava ina kiipowapowara na kubiisi matuketa ina votawei. ");
INSERT INTO pwg_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Mikeda natum ita pisi kurim da parawa kubiine iti nowi na wakima kuta verei, bo? ");
INSERT INTO pwg_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Bo iyana kubiine iti nowi na mota kuta verei, bo? Kegha! ");
INSERT INTO pwg_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Tami wawaya beroberomi, ma kegha da natunatumi puyo biibiisi kovereveresi. Ma ami Mamai kunumai na wawaya biibiina. Tuna kubiine maranai koni nowi na puyo biibii kirakiisi ina veremi.” ");
INSERT INTO pwg_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Ikikava kekayokayowei da wawaya ina berai kurim na nakanani keberai kurisi. Weni sisiyina na Moses ina vonaviyoyovana ma peroperoveta i giruma kudubina ivi kiisagoi da iyamna ivi debei.” ");
INSERT INTO pwg_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Kovi paparana da matuketa bikokonai kona rui. Matuketa nabana ma keta nabana emakamakai ma kegha da maninina enenae ku keyama karata makamakii nonowina. Ma wawaya peyarisi na keta nabana ekivikivini. ");
INSERT INTO pwg_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Ma matuketa bikokona ma keta wiririna enenae ku yawasa makamakii nonowina. Ipiropiro kirakai da matuketa bikokonai kona rui, ma wawaya viya kava epanapanani da erurui.” ");
INSERT INTO pwg_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Peroperoveta viviberosi kokitaruvisi. Ina pisi kurimi na kitasi nakanani ma sipu manamisi ma kegha da nuwanuwasi kamonai ti na nakanani ma kukou dipa, kayaya voravorasi. ");
INSERT INTO pwg_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","I bera kona kita kamowi na konakova bubunisi da ti na ikikava wawayisi. Ke kovokovoghina da puiya amesi gampuwe kamosiyai kota yuna. Ma bade ke kovokovoghina da koweya amesi iyiyo kamosiyai kota yuna. ");
INSERT INTO pwg_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Maghimaghighina na kii biibiina amena biibiina ina terei. Ma kii berona na amena berona ina terei. ");
INSERT INTO pwg_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Ma bade kii biibiina na ke meyani amena berona ina terei. Ma kii berona na ke meyani amena biibiina ina terei. ");
INSERT INTO pwg_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Ma vao kana koyakoyagha meni kiina ke ita amame bubuna na ina taratawei ma ku keyama karakaratina ina tawei da ina karai. ");
INSERT INTO pwg_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Ikikava kii amena kokitakitai da biibiina bo berona na bade nakanani wawaya i bera kona kita kamowi na kona vogiinisi da ti na ikikava wawayisi.” ");
INSERT INTO pwg_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Wawaya peyarisi evonavoneku bo, ‘Bada, Bada.’ Ma ke ruvaruvana da kudubisi ina rui God ina vikiivavona ku kamona. Ma iyavo kava aku Mamai kunumai ina kayowana eberaberai na ti wawayisi kava ina rui. ");
INSERT INTO pwg_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Mara damonai, vitupavira kana mara ina nekiibau na wawaya peyarisi ina voneku bo, ‘Bada, Bada, avamuwai kavi peroveta ma kanuma beroberosi kakwavinisi ma bera ghamaghamasi kaberai.’ ");
INSERT INTO pwg_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Ma debiiyai ana vonesi bo, ‘Taku ke atakovimi. Konetaweyana, wawaya beroberomi!’” ");
INSERT INTO pwg_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Wawaya aku sisiya ini yanei ma ina votekatekei na ti nakanani ma wawaya nuwanuwagiurina ina numa dobu akakiminai ivowai. ");
INSERT INTO pwg_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Ma garewa ghamana ikatuna, okowa ghamana ikiibau da numana itenukutuvi ma yanunu ghamana iverau da itapini, ma ke ita peku, iyamna dobu akakakiminai ivowai.” ");
INSERT INTO pwg_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","“Ma wawaya aku sisiya ini yanei ma ke ina votekatekei na ti nakanani ma wawaya neghaneghana ina numa gonugonu tepanai ivowai. ");
INSERT INTO pwg_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ma garewa ghamana ikatuna, okowa ghamana ikiibau ma yanunu ghamana iverau da nani numana ivorikai da okowa ikaruwei. Numa kudubina iresotawei.” ");
INSERT INTO pwg_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Yesu ina sisiya ivi kovini na koroto ghamana ivi deye kirakiiyei, ");
INSERT INTO pwg_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","iyamna ina vibeyebeyena na ere rewapanina, ke vonaviyoyovana vibeyebeyena wawayisi nakanani. ");
INSERT INTO pwg_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Yesu koya tepanai iororu na koroto ghamana ikivini. ");
INSERT INTO pwg_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Ma tomowa sago, kana gubaga giipo na ipisi ma maghinonai ivi tuwaporeruruwana ma ivona bo, “Bada, kuna kayowei na kuni biibiiniku.” ");
INSERT INTO pwg_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Ma Yesu ivororona da ivotovoni. Ma ivonei bo, “Akayokayowei. Aibiibiinim ma keyawasa.” Ma yaghiyaghinai giipo gwabinai ikovi. ");
INSERT INTO pwg_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Ma Yesu ivona bo, “Ke kuni mamatara da ikikava kuyawasa. Kenae, taparoro badana ina kitim da kuyawasa. Ma Moses ina vonaviyoyovana kenunuri da kuna suwara. Nakanani keberai da wawaya inakovi da tam yawayawasim.” ");
INSERT INTO pwg_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Yesu irui ku Kapeniyam kwanatuna ma senturiyon sago ina dobu na Rome, ipisi kurina ma ivi nowi Yesu kurina da iti vitei. ");
INSERT INTO pwg_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Ivonei bo, “Bada, aku bigabiga yaragina igubaga kirakai da ivi tamokovokovoghana, numiiyai ekenakena ma evovokwarakwara.” ");
INSERT INTO pwg_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Ma Yesu ivonei bo, “Tanae da ani yawasi.” ");
INSERT INTO pwg_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Ma senturiyon ivonei bo, “Kegha, Bada. Taku ke wawaya kiimataniku da aku ku numa kuta rui. Sisiya kava kevonei ma aku bigabiga ina yawasa. ");
INSERT INTO pwg_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Taku wawaya ghamaghamasi gaburisiyai ma bade seri wawayisi aku rewapana gaburinai. Sago ana vonei bo, ‘Kenae’ da ina nae. Ma sago ana vonei bo, ‘Kepisi’ da ina pisi. Ma aku bigabiga ana vonei bo, ‘Keberai’ da ina berai.” ");
INSERT INTO pwg_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Yesu weni sisiyina ivi yanei na ivi deyei. Itavire da wawaya ikivikivini ivonesi bo, “Kovi yaneku. Israel damsi kamosiyai ke sago wawaya ata panani da ina vitumaghana ita rakata weni senturiyon nakanani. ");
INSERT INTO pwg_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Avonavonemi da God ina vikiivavona kamonai na kupuna damsi peyarisi i dobu bogii ma bogiiyai ina pisi ma Abraham, Aisiki ma Jeikap yavata ina kam patapata. ");
INSERT INTO pwg_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Ma Israel damsi peyarisi enotanotai da God ina vikiivavona ku kamona ita rui ma kegha, ina tawesi ku nubakutuva. Nani dobunai ina tou ma okesi ini tarakikitei.” ");
INSERT INTO pwg_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Muriyai Yesu, senturiyon ivonei bo, “Kenae ma ikikava kitumaghana na itupuwa.” Ma ivivi sisiya kamonai na senturiyon ina bigabiga wawayina iyawasa. ");
INSERT INTO pwg_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Yesu irui Pita ina ku numa na ikitai da Pita rawana wavinena igubaga, ininina imuyamuya kirakai ma ikenakena. ");
INSERT INTO pwg_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Imana ivotovoni ma muyamuyana inekuyowei ma ivomiiri da Yesu ikoyagha bubuni. ");
INSERT INTO pwg_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Ravi ipika na wawaya turaturasi kanuma beroberosi gwabisiyai irunuma na irutinisi ipisi Yesu kurina. Ma Yesu kanuma beroberosi iyeghisi da wawaya ikiibutawesi. Ma gubagubagisi peyarisi ivi yawasisi. ");
INSERT INTO pwg_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Mara katamaninai God peroveta Aisaya kurina weni berasi ivi sisiyei na peyarina itupuwa. Aisaya igiruma bo, “Ita inivisi vitana ikavari, Kata gubaga kudubina iviitawei.” ");
INSERT INTO pwg_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Mara sago Yesu ikitai da koroto irakarakata na kana kivikivina ivonesi da tuna yavata toka ita damani ku nevana. ");
INSERT INTO pwg_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Ma vonaviyoyovana vibeyebeyena tomowina ipisi da Yesu ivonei bo, “Bada, mike kuna nenae na ana kivinim.” ");
INSERT INTO pwg_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Ma Yesu ivonapotei bo, “Kukou dipa kii buba emakamakai ma kiu kiidamowai kii nighu emakamakai ma taku Wawaya Natusi, aku kenakena gawarina kegha.” ");
INSERT INTO pwg_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Ma Yesu kana kivikivina sago ivona bo, “Bada, aku mamai ana dogoi ma muriyai ana vovira da ana kivinim.” ");
INSERT INTO pwg_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Ma Yesu ivonapotei bo, “Kekiviniku. Wawaya raborabobosi i biga da raborabobosi ina dogosi.” ");
INSERT INTO pwg_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Yesu kana kivikivina yavata ku waka igeru. ");
INSERT INTO pwg_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Idamadamana ma yaghiyaghinai yanunu berona ivomiiri ma tovava waka ikiikiimumui da ita monu. Ma Yesu, tuna ikena nunuwapa. ");
INSERT INTO pwg_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Ma kana kivikivina inae ikiimataki ma ivonei bo, “Bada, kevi viteta! Tamonumonu, tarabobo!” ");
INSERT INTO pwg_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Ma Yesu ivonapotesi bo, “Avi kubiine koyabuyabumana? Ami vitumaghana igisi ghagha!” Ma ivomiiri da yanunu ma tovava iyeghisi ma ivi nubai da toka kamonai biimara ikena. ");
INSERT INTO pwg_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Ma kana kivikivina inota kavakavai ma ivona bo, “Wena tomowa sago! Ivona, ma yanunu da tovava ivotekatekei!” ");
INSERT INTO pwg_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Yesu Gerasa damsi i kikirai iwota, tuna na Gariri tokana nevanai. Ma tomotomowa ruwa iverupotei, gwabisiyai kanuma beroberosi irunuma. Ti na karawagai, buba kamosiyai ivivi makiiyana ma ikayakayaya kirakai da wawaya nani ketanai ke ita bababa. ");
INSERT INTO pwg_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Ma Yesu kurina ikiirara bo, “Avi kuna berai kurikai? Tam God Natuna. Kupisi da kovogha kuna verekai, bo? Kovogha kana mara vaghata na karakava.” ");
INSERT INTO pwg_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Ma ririsiyai na poro yavona ikamkam. ");
INSERT INTO pwg_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Ma kanuma beroberosi Yesu kurina ivi nowi bo, “Mikeda kuna kwavinikai na kevonatawekai poro yavona kurisi.” ");
INSERT INTO pwg_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Yesu ivonesi bo, “Konae.” Ma kanuma beroberosi tomotomowisi ikiibutawesi ma inae da poro itowatepanisi. Ma porosi iverau ku anagha kiiyagirina ma iririgha da ku okowa ma iuma dodo. ");
INSERT INTO pwg_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Ma poro kii koyakoyagha iverau ku kwanatu ma aviyavisina itupuwa na ivi mamatarei. Ma bade ivonesi ikikava kanuma beroberosi tomotomowa ruwa gwabisiyai ikiibau. ");
INSERT INTO pwg_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Ma nani kwanatunai wawayisi kudubisi ikiibau Yesu kurina ma ivi nowi da i dobu ita kiibutawei. ");
INSERT INTO pwg_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Yesu ku waka igeru ma toka idamani ku nevana da ina ku kwanatu, ku Kapeniyam. ");
INSERT INTO pwg_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Ma wawaya viya kwinasi digadigana ritowai ipawoi da Yesu kurina inae. Yesu ikitisi da i vitumaghana irakata na digadigana ivonei bo, “Natuku, am nota ke ina gisi. Am bera beroberosi anotatawei.” ");
INSERT INTO pwg_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Ma weni sisiyina kubiine vonaviyoyovana vibeyebeyena wawayisi viya ti mani ivi tupanunuranei bo, “Ibero kirakai, weni tomowina God iavaberowei. Enotanotai da tuna nakanani ma God.” ");
INSERT INTO pwg_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Yesu i nota iakovi ma ivonesi bo, “Avi kubiine nota beroberosi koinuwanotanotei? ");
INSERT INTO pwg_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Itekateka da ana vona bo, ‘Am bera beroberosi anotatawei.’ Ma ibagibagi kirakai da ana vona bo, ‘Kevomiiri, kuna baba,’ iyamna matamiyai kona kitai da ina tupuwa bo kegha. ");
INSERT INTO pwg_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ani beyemi da konakovi da taku Wawaya Natusi, aku rewapana kovokovoghina da bera beroberosi dobuwai ana notatawei.” Ma digadigana kurina ivona bo, “Kevomiiri, am kepana kekavari ma kenae am ku numa.” ");
INSERT INTO pwg_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Ma tomowina ivomiiri ma inae ina ku numa. ");
INSERT INTO pwg_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Ma koroto ghamana nani berana ikitai na iyabumana ma inota kavakavai. Ma peyarisi God ivi ghegheni da ina rewapana ivonatawei ioru wawaya kurisi. ");
INSERT INTO pwg_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Yesu nani dobuna ikuyowei ma ibaba inenae da tomowa kana vava Matiu ikitai, tuna teks yuyuna yobena kamonai imakamakai. Ma ivonei bo, “Kekiviniku.” Ma Matiu ivomiiri da ikivini. ");
INSERT INTO pwg_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Ma Matiu ina numiiyai, Yesu kana kivikivina yavata ikamkam. Ma bade berabero wawayisi ma teks yuyuna damsi viya ipisi da yavata ikamkam. ");
INSERT INTO pwg_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Ma Perisi damsi ikitisi na kana kivikivina ivonesi bo, “Avi kubiine ami bada na teks yuyuna damsi ma berabero wawayisi yavata ekamkam?” ");
INSERT INTO pwg_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Yesu ivi yanesi ma ivonesi bo, “Wawaya gubagubagisi kava na yaboyabo inekwai, ma yawayawasisi na kegha. ");
INSERT INTO pwg_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Konae ma koekwa da weni sisiyina giruma katamana kamonai na iyamna avai. Igiruma bo, ‘Ke ata kayokayowei da ghamoghamo kota kiivunui ma kota suwara kuriku. Aku kayowana ghamana da wawaya koni kamyuyuwesi.’ Taku apisi da berabero wawayisi ata kwatusi. Ke ata pisi wawaya biibii kirakiisi kubiisi.” ");
INSERT INTO pwg_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Jon kana kivikivina inae Yesu kurina ma ivi tarakiiyanei bo, “Avi kubiine tokai ma Perisi damsi kaisiya, ma kam kivikivina na ekamkam ma eumuma.” ");
INSERT INTO pwg_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Ma Yesu ivonapotesi bo, “Tavine tomowina kana miimiirigwagwara wawayisi ke ina siyapa, gwabinai ina kamporagha ma ini nuwabiibai. Ma marana epipisi da nani tomowina ini wapai ma tuna maranai turaturana ini siya.” ");
INSERT INTO pwg_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Ma miiba sago iterei. “Wawaya gara vuna sinamina ita viiya da gara katamana tamosikana tepanai ita terei ma ita tupapotai na karakava peyarina ita bero, iyamna maranai ina tinakowai na gara sinamina ina tinakokoni ma gara katamanina tarabogina ita sikavinabanabai da iti beroi. ");
INSERT INTO pwg_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Ma wawaya wain vuna ke ku beka katamanina ina tepoi, iyamna puropuro ina berai da beka katamanina ini kwata da ini beroi ma wain ina sororo. Kegha, wain vuna ku beka vuna kuna tepoi da ina makai bubuna.” ");
INSERT INTO pwg_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Yesu ivivi sisiya kamonai na kiki numana badana sago inekiibau. Yesu maghinonai ivi tuwaporeruruwana ma ivona bo, “Natuku wavine wekarakava irabobo. Kuta pisi da imam kava ku tepana kuta terei da ita yawasa.” ");
INSERT INTO pwg_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Vaghina ma, Yesu ma kana kivikivina ivomiiri da tomowina yavata inae. ");
INSERT INTO pwg_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Inenae ma wavine sago Yesu murinai ipisi da kana gara damona ivotovoni. Tuna wavinena na nawaravi iviiya ma tarana mara nonowa iveraverau da madegha 12 ikovi. ");
INSERT INTO pwg_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Ivi nuwanotanota bo, “Mikeda kana gara kava ana votovoni na ana yawasa.” ");
INSERT INTO pwg_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Yesu imiiritavire da wavinena ikitai. Ma ivonei bo, “Natuku, am nota evirewapana. Kuvi tumaghana kubiine kuyawasa.” Ma yaghiyaghinai wavinena iyawasa. ");
INSERT INTO pwg_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Ma Yesu inae da kiki numana badana ina ku numa irui ma koroto ikitai, ti na isiyasiyapa, iyogoyogosi ma viya ivivi durere. ");
INSERT INTO pwg_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Ma ivonesi bo, “Konetaweyana. Wavine kikei ke ita rabobo, ekenakenota.” Ma wawayisi ivi namei. ");
INSERT INTO pwg_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Ma nani korotona irudarudarusi da ikiibau na Yesu irui wavine kikei kurina ma imana iviiya da ivomiiri. ");
INSERT INTO pwg_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ma aviyavisina itupuwa na sisiyina nani dobuna ine yavui. ");
INSERT INTO pwg_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Yesu ivomiiri inenae ma wawaya ruwa matapotapotasi murinai iverukivini, ma ikwatukwatu bo, “Tam David Tupurereghina, kevi kamyuyuwekai.” ");
INSERT INTO pwg_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Yesu ku numa sago irui na bade matapotapotasi ikivini da irui. Ma ivi tarakiiyanesi bo, “Koitumaghana da taku kovokovoghina da ani yawasimi, bo?” Ma ivonapotei bo, “E, vaghina, Bada, kaitumaghanem.” ");
INSERT INTO pwg_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Ma matasi ivotovoni ma ivonesi bo, “Ikikava koitumaghana na nakanani ina tupuwa kurimi.” ");
INSERT INTO pwg_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Yaghiyaghinai matasi iruyaghari da ikita. Ma Yesu ivonatanisi bo, “Wawaya ke koni akovisi.” ");
INSERT INTO pwg_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Ma kegha da tomotomowisi inae ma aviyavisina Yesu iberai na ivi mamatarei da varana nani dobuna ine yavui. ");
INSERT INTO pwg_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Nani tomotomowisi ivi ruwa ikiibau inae na wawaya tomowa sago irutinapiyei Yesu kurina. Tomowina na kanuma berona gwabinai irunuma da ke ita vivisisiya. ");
INSERT INTO pwg_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Yesu kanuma berona ikwavini da ikiibutawei inae, ma tomowina sisiya ivi karei. Koroto ghamana ikitai na ivi deyei ma inota kavakavai ma ivona bo, “Te, te, te, te, te! Ke meyani Israel kamonai bera weni nakanani kata kitai!” ");
INSERT INTO pwg_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Ma Perisi damsi ivona bo, “Yesu ina rewapana na kanuma beroberosi i bada ghamana gwabinai iviiya da kanuma beroberosi ekwavikwavinisi.” ");
INSERT INTO pwg_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Yesu ibaba inenae da kwanatu ma meyagai nununai, kiki numasiyai ivivi beyebeyena, God varana biibiina ma ina vikiivavona idimadimei. Ma wawaya kii gubaga bogii ma bogiiyai na peyarina ivivi yawasisi. ");
INSERT INTO pwg_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Ma Yesu ina baba kamonai koroto ghamaghamasi ikitakitisi ma ivivi kamyuyuwesi, iyamna i nuwapoya ipeyari ma ke itakovi da iyi iti vitesi. Kitasi na nakanani ma sipu kii koyakoyagha kegha. ");
INSERT INTO pwg_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Tuna kubiine kana kivikivina ivonesi bo, “Yaba kana mara ipisi ma vao irakata kirakai ma yabayaba wawayisi ke ita peyari. ");
INSERT INTO pwg_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Kovi nowi vao badana kurina da yabayaba wawayisi viya ina vonatawesi da yavata tayaba.” ");
INSERT INTO pwg_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Yesu kana kivikivina ivi 12 ikwaturiyariyesi ma rewapana iveresi da kanuma beroberosi ita kwavinisi ma wawaya kii gubaga bogii ma bogiiyai iti yawasisi. ");
INSERT INTO pwg_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Ma nani aposol kii vava na weni. Saimon, kana vava sago Pita, ma tina kikei Anduru, Zebedi natunatuna Jemes ma Jon, ");
INSERT INTO pwg_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Piripo, Batoromiya, Tomas, Matiu, tuna teks yuyuna wawayina, Arupiyasi natuna Jemes, Tadiyas, ");
INSERT INTO pwg_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","ma Saimon, tuna Zelote wawayina. Ma bade Judas Iskariyot, tuna karakava Yesu ini wawanei. ");
INSERT INTO pwg_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Muriyai da Yesu weni tomotomowisi ivi 12 ita vonatawesi na ivi varavarisi bo, “Ke kona nae kupuna damsi kurisi bo kona rui ku Sameriya kwanatusi. ");
INSERT INTO pwg_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Ma konae da Israel damsi kava kurisi, ti na God ina sipu siwasiwanisi. ");
INSERT INTO pwg_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Kona nenae na weni sisiyina kona dimei. ‘Wekarakava na God ina vikiivavona enenekiibau.’ ");
INSERT INTO pwg_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Ma gubagubagisi kovi yawasisi, raborabobosi kovovimiirinisi, giigiiposi kovi yawasisi ma kanuma beroberosi kokwavinisi. Ikikava God nevana kava iverotemi na bade nakanani wawaya nevana kava koverotesi. ");
INSERT INTO pwg_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Ami baba kubiine na mane ke kona kavari, ");
INSERT INTO pwg_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","ke kutu, gara, kaeterepapara, bo diwona kona kavari. Iyavo kubiisi kona biga na kii wavu da ina koyagha bubunimi.” ");
INSERT INTO pwg_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Meni ku kwanatuna bo meyagina kona rurui na kokitavirevire da wawaya kiimatanina kona panani. Ma nani wawayina gwabinai kona makamakai da ami vomiiri kana ku mara. ");
INSERT INTO pwg_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Ina ku numa kona rurui na kovonesi bo, ‘God ini biibiinimi.’ ");
INSERT INTO pwg_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Kona rui ma ina koyagha bubunimi na ami vibiibiina gwabisiyai ina makai. Mikeda kona rui ma ina koyagha beromi na ami vibiibiina gwabisiyai koviitawei. ");
INSERT INTO pwg_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Ma mikeda wawaya ke ini kiikiiwemi bo ami sisiya ke ini yanei, nani numana bo kwanatuna kokiibutawei ma kaevunavunami kokiiririghi, ini matakira da kovogha ina viiya. ");
INSERT INTO pwg_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Vonavaghata avonavonemi, vitupavira maranai Sodom ma Gomora kwanatusi kovogha berona ina viiya, ma kegha da meni kwanatuna ina baremi na kovogha ghamanakina ina viiya.” ");
INSERT INTO pwg_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Kovi yana, tami nakanani ma sipu ma avonavonatawemi kukou dipa kurisi. Tuna kubiine konuwagiura mota nakanani. Ma bade kovi yamoyamona gabubu nakanani. ");
INSERT INTO pwg_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Kokitaruvimi, iyamna wawaya ina panimi da vitupavira wawayisi maghinosiyai kona miiri ma bade kiki numasiyai ina widimi. ");
INSERT INTO pwg_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Ma kokivikiviniku kubiine ina rutinimi babada ma kiikiivavo kurisi da ini tupavireviremi ma nani kamonai God varana biibiina koni mamatarei kurisi da kupuna damsi yavata ini yanei. ");
INSERT INTO pwg_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Ma ina panimi da ina vivitupavireviremi na ke koni nuwapoya da aviyavisina kona vonei bo ikikava kurisi koni sisiya, iyamna God sisiya ina veremi. ");
INSERT INTO pwg_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Nani sisiyisi na ke tami ami nota, ami Mamai God Kanumina nota ina veremi da koni sisiya.” ");
INSERT INTO pwg_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Wawaya ina vomiiri da varesina kana puka ina vowai, ma bade morapa natuna kurina nakanani ina berai. Ededa i moramorapa ini ghaviyesi ma babada ku imasi ina teresi da ini rabobosi. ");
INSERT INTO pwg_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Taku kubiiku na wawaya kudubisi ina baremi ma iyavo kava ina miirikikina da ku damona na God yawasa ina veresi. ");
INSERT INTO pwg_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Mikeda kwanatu sago kamonai ina vivitupaketowanemi na koverau, kona nae ku kwanatu sago. Vonavaghata avonavonemi, ami biga Israel dobuna ina kwanatu kamosiyai ke koni kovini ma Wawaya Natusi ina nekiibau.” ");
INSERT INTO pwg_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Wawaya girugirumina ke kovokovoghina da ina vibeyebeyena wawayina ina ghekuyowei, ma bade bigabiga wawayina ke ina bada ina ghekuyowei. ");
INSERT INTO pwg_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Ma kovokovoghina da wawaya giruma ina voyavui da tuna ina vibeyebeyena wawayina nakanani. Ma ikikava ina tupuwa bigabiga wawayina ina bada kurina na bade nakanani ina tupuwa bigabiga kurina. Wawaya namada ivomiiri da rakaraka kii iyaroko ivi avaberowei ma ivonei da tuna Berusiburu. Ma bade ina vomiiri da peyarisi nani rakarakana kamonai ini avaberowesi.” ");
INSERT INTO pwg_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Tuna kubiine wawaya ke kona yabumanesi. Karakava God wawaya i bera gavugavusi kudubina ini debei ma aviyavisina wawaya ke ita kitakitai na ina vovimatari. ");
INSERT INTO pwg_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Aviyavisina nubakutuvai ana vonemi na mariyai kovi sisiyei. Ma aviyavisina tinimiyai ana vonakarakaravei na numa kupuwai korumamarei. ");
INSERT INTO pwg_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Iyavo kava tupuwimi ina kiivunui na ke kona yabumanesi, iyamna ti na ke kovokovoghina da kanumimi ina kiivunui. Ma God ina kina kava kota yabumanei, iyamna tuna kovokovoghina da ke tupuwimi kava ma kanumimi yavata keyama karakaratinai ina kiivunui. ");
INSERT INTO pwg_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Aririta ruwa kona gimari na miiyanisi igisi kirakai. Ma kegha da aririta sago kava ina rabobo na God ke ini notawapei, iyamna nani rabobona ina vivaghina kamonai itupuwa. ");
INSERT INTO pwg_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Ma tami, uyawimi peyarina God ivi yavi ikovi da viya. ");
INSERT INTO pwg_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Tuna kubiine ke kona yabumana. God enotanotimi, iyamna tami na ina kayowana ghamana da aririta peyarina koghekuyowesi.” ");
INSERT INTO pwg_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Tam iyai dobuwai, wawaya maghinosiyai kuni debe meyem da kekivikiviniku na bade nakanani kunumai, aku Mamai maghinonai ani debei da tam na aku wawaya. ");
INSERT INTO pwg_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ma tam iyai wawaya maghinosiyai kuna vonaveyaveyiyeku na bade nakanani aku Mamai maghinonai ana vonaveyaveyiyem.” ");
INSERT INTO pwg_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Ke kona notai da taku nuwanuba ata piyei ku dobu. Apisi na seri akavarapiyei da wawaya ini bogebogesi ma ini makiiberowana. ");
INSERT INTO pwg_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Apisi da tomowa ina mamai ini kawapatei, wavine ina maduwa ini kawapatei, ma bade wavine na rawana wavinena ini kawapatei. ");
INSERT INTO pwg_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Ma tomowa kana ghavighaviya na tuna mani ina rakaraka kamonai.” ");
INSERT INTO pwg_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Mikeda kevonavona da nuwanuwaku kuviiya ma kegha da am mamai bo am maduwa nuwanuwana kuvii kirakiiyei da taku ighekuyoweku na tam na ke taku kaku kivikivina vaghata. Ma natunatum nuwanuwasi kuna vii kirakiiyei da taku ina ghekuyoweku na tam na ke taku kaku kivikivina vaghata. ");
INSERT INTO pwg_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Tam iyai am korosi ke kuna kavari da murikuwai kuna pisi na tam na ke taku kaku kivikivina. ");
INSERT INTO pwg_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Tam iyai am yawasa kuna nuwaghanei na kuni wapai. Ma tam iyai am yawasa taku kubiiku kuna nuwatawei na yawasa vaghata kuna panani.” ");
INSERT INTO pwg_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Wawaya ikiikiiwemi na taku yavata ikiikiiweku. Ma iyavo kava ikiikiiweku na aku Mamai yavata ikiikiiwekai, iyamna tuna ivonataweku. ");
INSERT INTO pwg_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Wawaya peroveta ini kiikiiwei iyamna iakovi da tuna na God ina peroveta na ikikava God peroveta ini miiyei na bade nakanani wawayina ini miiyei. Ma wawaya tomowa maninina ini kiikiiwei iyamna iakovi da tuna God ina wawaya na ikikava God tomowa maninina ini miiyei na bade nakanani wawayina ini miiyei. ");
INSERT INTO pwg_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ma mikeda kaku kivikivina sago, kana vava ke ita rakata ma okowa nubanubana kava kuna verei, iyamna kuakovi da tuna na aku wawaya na vonavaghata avonavonem, God ini miiyem.” ");
INSERT INTO pwg_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Yesu kana kivikivina ivi 12 ivonavibeyebeyesi ikovi na ivomiiri da Gariri dobunai vibeyebeyena ma dima ivi karei kwanatu nunusiyai. ");
INSERT INTO pwg_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Ma Jon Babataito na gabura kamonai ivi yanei da Keriso aviyavisina iberaberai na kana kivikivina ivonatawesi da iti tarakiiyanei. ");
INSERT INTO pwg_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Vaghina ma inae da ivonei bo, “God ina Vivinevine Wawayina kakoyakoyaghi na vaghina tam, bo wawaya sago kana koyaghi?” ");
INSERT INTO pwg_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Ma Yesu ivonapotesi bo, “Kovovira da aviyavisina kokitakitai ma koiyanei na Jon kovonei. ");
INSERT INTO pwg_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Kovonei da matapotapotasi ekitakita, digadigasi ebababa, giigiiposi eyawayawasa, tinapotapotasi iyana, raborabobosi evovomiiri, ma moyamoyakisi God varana biibiina iyanei. ");
INSERT INTO pwg_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Kovi tumaghana da vaghina wawayina kokoyakoyaghi na taku. Ami nota ke ina ragharagha ma God ini biibiinimi.” ");
INSERT INTO pwg_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Jon kana kivikivina inae ma Yesu ivi karei da koroto ghamana kurisi Jon Babataito ivivi sisiyei. Ivonesi bo, “Avi kubiine kokiibau ku warere? Ami kayowana da rai yanunu itapitapini da ituwayovana na tuna kota kitai, bo? ");
INSERT INTO pwg_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Mikeda kegha na avi kubiine kokiibau? Tomowa gara biibiisi ivi kote na kota kitai, bo? Kegha, Jon kana gara ke biibiisi. Ma mura wawayisi na ke warereyai, ti na kiikiivavo i numa ghamaghamasi kamonai kona pananisi. ");
INSERT INTO pwg_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Aviyavisina kitana kubiine kokiibau? Peroveta, bo? E, vaghina, vonavaghata da Jon na peroveta. Ma God ina peroperoveta kamosiyai na Jon ighe kirakai. ");
INSERT INTO pwg_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Giruma katamana kamonai God ivona bo, ‘Aku yonayona maghinomuwai ana vonatawei. Tuna am keta ina vovunaghi.’ Wawayina ivivi sisiyei na vaghina tuna, Jon. ");
INSERT INTO pwg_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Vonavaghata avonavonemi da Jon Babataito na wawaya ghamana. Dobuwai kotekwa na ke sago wawaya kota panani da Jon ita ghekuyowei. Ma kegha da God ina vikiivavona kamonai na wawayota kana vava ke ita rakata na tuna ighe kirakai da Jon ighekuyowei. ");
INSERT INTO pwg_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Rorova Jon idimadima ma ibababataito ma nani maranai ivi karei da ipisi karako na God ina vikiivavona ere rewapanina erakarakata. Ma bade wawaya kawakiikiisi na God ina vikiivavona ikawapatei. ");
INSERT INTO pwg_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Moses ma peroperoveta kudubisi vonaverena igirugirumi i mariyai da Jon Babataito ina ku mara na ivonavoneta da mara sago God ina vikiivavona ita nekiibau na karako enenekiibau. ");
INSERT INTO pwg_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ma bade ti igiruma da mara sago Elaidiya ita pisi, ma avonavonemi da wawayina na Jon, namada ipisi. Vonavaghata, kovi tumaghana. ");
INSERT INTO pwg_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Wawaya ere tinimi na aku sisiya kovi yana bogai.” ");
INSERT INTO pwg_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Tami weni kimtina kamonai na ikikava ani sisiyemi? Tami nakanani ma ededa merewai irekwa ma irukwatukwatuwana turaturasi kurisi, ");
INSERT INTO pwg_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Durere kauveni kubiimi ma ke kota riku. Kasiyapa ma ke kota tou.’ ");
INSERT INTO pwg_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Jon Babataito ivivi siya, ke ita kamkam ma wain ke meyani itumumai. Tuna kubiine weni kimtina kovonavona bo, ‘Kanuma berona gwabinai.’ ");
INSERT INTO pwg_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Ma taku, Wawaya Natusi, akamkam ma aumuma na kovonavona bo, ‘Nani wawayina na kamonabanabana ma umaneghaneghana. Turaturana na teks yuyuna damsi ma berabero wawayisi.’ Ma God ina nuwagiura na wawaya i yawasa kamonai idebei kurita da tuna nuwagiura vaghata.” ");
INSERT INTO pwg_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Kwanatu viya kamosiyai na Yesu bera ghamaghamasi iberai ma kegha da wawaya i berabero ke itinimayei ma ke ita miirikupukuputei. Tuna kubiine iyeghisi. Ivona bo, ");
INSERT INTO pwg_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Koti nuwapoya kirakai, Korasin ma Betsaida! Ikikava kamomiyai bera ghamaghamasi aberai, nakanani Taya ma Saidon wawayisi gwabisiyai ata berai na yaghiyaghinai i berabero itinimayei ma ita miirikupukuputei, i nuwapoya kubiine mowamowasi iti kote ma ere yapuyapukaresi ita makamakai. ");
INSERT INTO pwg_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Ma avonavonemi, vitupavira maranai na Taya ma Saidon kii kovogha na berona. Ma tami Korasin ma Betsaida kami kovogha na ina bero kirakai. ");
INSERT INTO pwg_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Ma tami Kapeniyam wawayimi, konotanotai da kota ghae ku kunuma, bo? Kegha! God ina tawemi konoru ku keyama karakaratina. Ikikava kamomiyai bera ghamaghamasi aberai na nakanani Sodom kamonai ata berai na nani kwanatuna karako patana da ita makamakai. ");
INSERT INTO pwg_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Avonavonemi, vitupavira maranai Sodom kana kovogha na berona. Ma tami Kapeniyam wawayimi na kami kovogha na ina bero kirakai.” ");
INSERT INTO pwg_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Nani maranai Yesu ivona bo, “Mamai, tam dobu ma kunuma kana kiivavo ma aigheghenim iyamna akova vaghata kuteregavui da wawaya nuwanuwagiurisi ma giruma kirakiisi ke itakovi. Ma iyavo kava ke girugirumisi ma ke akakovisi, ti nakanani ma ededa yoghoyogho na ti kurisi vonavaghata kuvi debei da iakovi. ");
INSERT INTO pwg_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","E Mamai, am kayowana da weni nakanani ita tupuwa na vaghina, itupuwa.” ");
INSERT INTO pwg_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“Aku Mamai bera peyarina ivereku da rapekuwai. God ina kina kava Natuna iakova bubuni. Ma God Natuna ma bade iyavo kava ivinesi da ina Mamai akovina ita viiya na ti kava Mamai iakova bubuni.” ");
INSERT INTO pwg_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Tami iyavo kava vita kokavakavari ma ininimi ibara na peyarimi kopisi kuriku ma gwabikuwai koni yakam. ");
INSERT INTO pwg_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Aku vibeyebeyena kokivini ma tuna tepanai kona makai, iyamna taku na voyaghota ma nuwanuba wawayiku, ma gwabikuwai kanumimi ini yakam. ");
INSERT INTO pwg_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Aku vibeyebeyena itekateka da kona kivini, ma vita ana veremi da kona kavari na ke damina.” ");
INSERT INTO pwg_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Viyakam marana sago Yesu kana kivikivina yavata vao basunai ibabakiiyaragha inenae. Ma kana kivikivina vitonara ikarisi, tuna kubiine ivi karei da whiti vavisi ivivi tinamuyana ma ikamkam. ");
INSERT INTO pwg_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Ma Perisi damsi ikitisi na Yesu ivonei bo, “Kekitai! Kam kivikivina vonaviyoyovana ikiigiiyei. Avi kubiine viyakam maranai ewayowayowa?” ");
INSERT INTO pwg_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Ma Yesu ivonapotesi bo, “Kovi yavi bo kegha da mara katamaninai David turaturana yavata vitonara ikarisi na aviyavisina iberai. ");
INSERT INTO pwg_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Irui God ina ku Taparoro Numana ma suwara parawisi iyuna da turaturana yavata ikam. Nani parawisi na itaravatu da ke wawayota ita kam, tuna taparoro babadisi kava kii parawa ma kegha da David ikani. Vonaviyoyovana ivi kiigiiyei ma kegha da God ke ita vona da berabero iberai. ");
INSERT INTO pwg_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Ma kovi yavi bo kegha da Moses ina vonaviyoyovana kamonai igirumi da viyakam maranai na biga kegha. Ma kegha da ivi vaghinei da taparoro babadisi kava Taparoro Numana kamonai i biga ina berai na nani kamonai ke berabero ita beraberai. ");
INSERT INTO pwg_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ma avonavonemi da karako wawaya sago inekiibau na tuna wawayina ighe kirakai da Taparoro Numana ighekuyowei. ");
INSERT INTO pwg_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Giruma katamana ivona bo, ‘Ke ata kayokayowei da ghamoghamo kota kiivunui da kota suwara kuriku. Aku kayowana ghamana da wawaya koni kamyuyuwesi.’” Ma Yesu ina sisiya ikwapanatini bo, “Nani girumina iyamna kotakova bubuni na wawaya biibiisi nakanani ma kaku kivikivini ke kota kiiviberosi. ");
INSERT INTO pwg_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Ma viyakam marana badana na taku, Wawaya Natusi.” ");
INSERT INTO pwg_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Yesu nani dobuna ivoterei inae da ku kiki numana irui. ");
INSERT INTO pwg_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Ma kamonai tomowa sago imana gibegibesina imakamakai. Ma Perisi damsi keta iekwekwai da Yesu iti wavui, tuna kubiine ivi tarakiiyanei bo, “Moses ina giruma kamonai ivi vaghinei da viyakam maranai wawaya tiyawasi bo kegha?” ");
INSERT INTO pwg_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Ma Yesu ivonesi bo, “Viyakam maranai am sipu ku bonagha ita peku na kuta tinepai bo kegha? ");
INSERT INTO pwg_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Ma meni tuna na bera ghamana, sipu kuti yawasi bo wawaya kuti yawasi? Sipu na kana vava ghamoghamo ma wawaya na iyamna irakata. Tuna kubiine Moses ina giruma kamonai ivi vaghinei da viyakam maranai na bera biibiisi taberai.” ");
INSERT INTO pwg_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Ma gibegibesina ivonei bo, “Kevororona.” Ma ivororona da imana kudubina iyawasa, iyanumi da imana nevana nakanani. ");
INSERT INTO pwg_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Ma Perisi damsi nuwanuwasi ipughu ma inae da ivi ogatara, keta iekwekwai da Yesu iti raboboi. ");
INSERT INTO pwg_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Yesu iakovi da Perisi damsi i kayowana da iti raboboi, tuna kubiine nani dobuna ikiibutawei. Ma wawaya peyarisi ikivikivini ma gubagubagisi peyarisi ivivi yawasisi. ");
INSERT INTO pwg_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Ma Yesu ivonatanisi da ke iti mamatara da tuna iyai. ");
INSERT INTO pwg_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Weni berasi peyarina iberai da aviyavisina peroveta Aisaya igiruma da ita tupuwa na itupuwa. Aisaya igiruma bo, ");
INSERT INTO pwg_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Aku bigabiga avinei na weni, tuna aku nuwaviina ma ainuwabiibiiyei. Kanumiku ana vonatawei kurina da ina towatepani, Ini yonayona dam ma dam dobu ku kudubina kurisi da God ini tupaviresi ma kubiisi bera maninina ina berai. ");
INSERT INTO pwg_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ke ini kawapata bo ina kiirara, Kwanatu kamosiyai ke ina rumamara da gamona ketiyai ini yanei. ");
INSERT INTO pwg_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Ke ina berai da wawaya vivikamyuyuwisi i nota ina peku, Ke ina berai da wawaya mitamitasi kii vita ini taratatanei. Nakanani ina beraberai da mara sago bera kudubina ina ghegavovori ma ini maniniya. ");
INSERT INTO pwg_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Ma dobu kudubina aku bigabiga kana vava ini tumaghanei.” ");
INSERT INTO pwg_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Ma wawaya viya kwinasi irutinaneyei Yesu kurina. Kwinasi na kanuma berona gwabinai irunuma da matana ma kawana ipota. Ma Yesu ivi yawasi da ikita ma ivi sisiya. ");
INSERT INTO pwg_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Ma wawaya peyarisi ivi deyei ma ivona bo, “God ina Vivinevine Wawayina takoyakoyaghi, tuna David tupurereghina na vaghina wawayina, bo?” ");
INSERT INTO pwg_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Ma Perisi damsi weni sisiyina ivi yanei na ivona bo, “Kegha! Kanuma beroberosi i kiivavo Berusiburu gwabinai rewapana iviiya da kanuma beroberosi ekwavikwavinisi.” ");
INSERT INTO pwg_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Yesu i nota iakovi ma ivonesi bo, “Kiivavo sago ina wawaya kamosiyai iti kawapata ma iti bogebogesi na nani kiivavona kudubina ita wapa. Bo dam sago kamonai rakaraka ruwa iti kawapata na nani damna ke ita miirikikina, ita peku. ");
INSERT INTO pwg_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ma nakanani kanuma berona wawaya gwabinai ma Seitan ita vomiiri da ita kwavini na iti matakira da ina vikiivavona kamonai ivi bogebogesi da ke kovokovoghina da ita miirikikina. ");
INSERT INTO pwg_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Kovonavona da Berusiburu rewapana ivereku da kanuma beroberosi akwavikwavinisi. Ma tami mani kami kivikivina na God ina rewapanai ekwavikwavinisi. Ma ti na ina vonemi da koibero, iakovi da taku bade aku rewapana God gwabinai aviiya.” ");
INSERT INTO pwg_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","“God Kanumina ina rewapanai kanuma beroberosi akwavikwavinisi, tuna kubiine kotakovi da kurimi God ina vikiivavona inekiibau.” ");
INSERT INTO pwg_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Ma sago, wawaya ke kovokovoghina ita rui tomowa rewapanina ina ku numa da aviyavisina rapenai ita yapi da kunona tomowina imana ma kaena ita kutatani ma muriyai da ita yapi.” ");
INSERT INTO pwg_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Wawaya ke ita viviteku na ikawapateku. Iyavo kava ke taku yavata kata bigabiga patapata da wawaya kata kiikiividaburisi na aku biga eresoresoi. ");
INSERT INTO pwg_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Avonavonemi da God kovokovoghina da ami bera beroberosi peyarina ina notatawei. Ma Kanuma Vovokaravina koni avaberowei na ke meyani ina notatawei. ");
INSERT INTO pwg_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Ma iyai taku Wawaya Natusi ini avaberoweku na God kovokovoghina da ina berabero ina notatawei. Ma iyai Kanuma Vovokaravina ini avaberowei na ke ina notatawei, ke karako ma ke nokoni ku marana.” ");
INSERT INTO pwg_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Mikeda kii biibiina na amena biibiina, bo kii berona na amena berona. Amena kona kitai ma kiina konakovi da biibiina bo berona. ");
INSERT INTO pwg_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Tami mota natunatusi! Tami beroberomi na ke kovokovoghimi da sisiya biibiina koni sisiyei. Aviyavisina wawaya nuwanuwasi kamonai egheghetawei na kawasiyai ekarakaratawei. ");
INSERT INTO pwg_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Wawaya biibiina nuwanuwana kamonai na biibiina enuwanuwaghanei. Maranai nuwanuwana ina votawei na biibiina ina karatawei. Ma wawaya berona nuwanuwana kamonai na berona enuwanuwaghanei. Maranai nuwanuwana ina votawei na berona ina karatawei. ");
INSERT INTO pwg_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Ma avonavonemi da vitupavira maranai wawaya God maghinonai ina miiri ma aviyavisina kudubina ivivi sisiya wapawapai na kurina ini mamatarei. ");
INSERT INTO pwg_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Tam mani am sisiya tepanai God ina vona da tam wawaya biibiim bo tam wawaya berom.” ");
INSERT INTO pwg_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Perisi damsi ma vonaviyoyovana vibeyebeyena wawayisi viya Yesu ivona tovoni bo, “Vibeyebeyena wawayim, akii kayowana da matakira ghamana kuta berai da kata kitai ma katakovi da am rewapana God gwabinai kuviiya.” ");
INSERT INTO pwg_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Ma Yesu ivonapotesi bo, “Tami weni kimtina kamonai ami nota na beroberosi ma kawakiikiimi. Ma ami kayowana da matakira ghamana kota kitai, bo? Kegha, ke ana berai. Ma aviyavisina itupuwa peroveta Jona kurina na tuna matakirina kava. ");
INSERT INTO pwg_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Ikikava Jona mara aroba ma didibara aroba iyana ghamanakina kamokamona kamonai imakai, nakanani ina tupuwa Wawaya Natusi kurina da mara aroba ma didibara aroba tano kamonai ina kena. ");
INSERT INTO pwg_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Ma Jona idima Nineva damsi kurisi da itupuwavira. Ma vitupavira maranai nani damsi ina vomiiri ma ina vona da karako weni kimtina na berabero wawayimi. Ma kovi yana, karako wawaya sago inekiibau ma tuna na Jona ighekuyowei. ");
INSERT INTO pwg_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Mara katamaninai Seba kana kiivavo wavinena dobu rabarabai ivomiiri inae Kiivavo Soromon kurina da ina nuwagiura ma ina vibeyebeyena iti yanei. Ma vitupavira maranai nani wavinena ina vomiiri ma weni kimtina ini wavumi, ina vona da tami na berabero wawayimi iyamna aku vibeyebeyena ke koti yanei. Ma kovi yana, karako wawaya sago inekiibau ma tuna na Kiivavo Soromon ighekuyowei.” ");
INSERT INTO pwg_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Mikeda kanuma berona wawaya gwabinai ina kiibau na warere makiiwapasiyai gawara inekwekwa da iti yakam ma ke ina panani. ");
INSERT INTO pwg_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Ma ina vona bo, ‘Aku ku numa ana vovira.’ Ina ku numa ina nekiibau na ina panani da numana kwebuna, wawaya igigiri ma bera peyarina itere bubuni. ");
INSERT INTO pwg_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Vaghina ma ina nae ma kanuma beroberosi miikovimaruwa, ti na bero kirakiisi, ina rutinisi ma peyarisi ina vovira da nani wawayina gwabinai ina runuma. Karenai wawayina ina yawasa ibero. Ma peyarisi ina runuma na ina yawasa ina bero kirakai. Ma nakanani ina tupuwa weni kimtina kawakiikiimi kurimi.” ");
INSERT INTO pwg_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Yesu patana da ivivi sisiya koroto kurisi ma ina maduwa ma titina yoghoyogho inekiibau da kawakawarai imiiri ma i kayowana da Yesu kurina iti sisiya. ");
INSERT INTO pwg_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Wawaya sago Yesu ivonei bo, “Am maduwa ma titim yoghoyogho matarai ekoyakoyaghim, i kayowana da iti sisiya kurim.” ");
INSERT INTO pwg_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Ma Yesu ivonapotesi bo, “Aku maduwa na iyai? Ma titiku yoghoyogho na iyavo?” ");
INSERT INTO pwg_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Ma ituparorona kana kivikivina kurisi ma ivona bo, “Aku maduwa ma titiku yoghoyogho na vaghina weni, ");
INSERT INTO pwg_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","iyamna iyavo kava aku Mamai kunumai ina kayowana eberaberai, ti na titiku yoghoyogho ma novunovuku ma aku maduwa mau.” ");
INSERT INTO pwg_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Marana sago Yesu numa ikiibutawei ma inae ku toka da baranai imakiipika da iti beyebeyena. ");
INSERT INTO pwg_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Ma wawaya peyarisi Yesu kurina iriyei ma koroto irakata sasara da Yesu ku waka igeru ma tepanai imakai. Ma wawaya kikirai imiimiiri. ");
INSERT INTO pwg_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Ma sisiya peyarisi miibiiyai ivonesi. Ivona bo, “Wawaya sago ikiibau pei vonina kubiine. ");
INSERT INTO pwg_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Ma pei ivivi busagha da viya ketiyai iririgha ma kiu ipisi da ikam yavui. ");
INSERT INTO pwg_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Ma viya ku tano wakiwakimina iririgha, ma kana tano ke ghamana. Ma yaghiyaghinai ituwepa. Ma kana tano tetepakina kubiine, ");
INSERT INTO pwg_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","madegha irarana da nani peina kudubina isivisivi ma ikaragavovori, iyamna ramramsi kegha. ");
INSERT INTO pwg_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Ma pei viya iyiyo ku kamosi iririgha na yavata igogo ma iyiyo nani peina ipanigudagudai. ");
INSERT INTO pwg_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Ma pei viya ku tano biibiina iririgha ma igogo da sago sago duma iuwa bubuna da pei sago na amena 100 ma sago 60 ma sago 30 iterei.” ");
INSERT INTO pwg_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Ma Yesu ivonesi bo, “Wawaya ere tinimi na aku sisiya kovi yana bogai.” ");
INSERT INTO pwg_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Yesu kana kivikivina ipisi kurina ma ivi tarakiiyanei bo, “Avi kubiine miibiiyai wawaya kurisi kisisiya?” ");
INSERT INTO pwg_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Ma ivonapotesi bo, “Akova gavugavuna kudubina God ina vikiivavona kamonai avi debei kurimi, ma wawaya viya kurisi na ke ati debei. ");
INSERT INTO pwg_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Ma iyavo kava akova gwabisiyai, God ku tepana ina terei da ina sasara. Ma iyavo kava akova gisi vaghina gwabisiyai na nani akovina God ina viitawei. ");
INSERT INTO pwg_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Miibiiyai aisisiya kurisi, iyamna ina kitai ma ke inakovi, ini yanei ma ke notana ina viini. ");
INSERT INTO pwg_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Weni wawayisi kamosiyai aviyavisina peroveta Aisaya igirumi na itupuwa. Igiruma bo, ‘Weni wawayisi ini yana ma ini yana ma akovina ke ina viini. Ina kita ma ina kita ma ke ina kitai. ");
INSERT INTO pwg_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Matasiyai ita kita, bo tinisiyai iti yana, ma nuwanuwasi ita votawei, na ita miiritavire kuriku ma ati yawasisi. Ma kegha da nuwanuwasi igudui, ma tinisi itupapotapotai, ma matasi itapotapotai.’” ");
INSERT INTO pwg_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Ma tami na koti nuwabiibai, iyamna God ivi biibiinimi da matamiyai kokitakita ma tinimiyai koiyana. ");
INSERT INTO pwg_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Vonavaghata avonavonemi, rorova mara katamaninai peroperoveta ma God ina wawaya maninisi i kayowana da aviyavisina karako kokitakitai ma koiyanei na ita kitai ma iti yanei, ma ke kovokovoghina.” ");
INSERT INTO pwg_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Kovi yana bubuna da pei miibiina ani debei kurimi da konakova bubuni. ");
INSERT INTO pwg_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Pei ketiyai iririgha na nakanani ma iyavo kava God varana biibiina ivi yanei ma iyamna ke itakova bubuni. Aviyavisina nuwanuwasi kamonai na Seitan ipisi da inebosi. ");
INSERT INTO pwg_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Ma pei tano wakiwakiminai iririgha na nakanani ma iyavo kava God varana biibiina ivi yanei ma yaghiyaghinai iviini ma ivi nuwabiibiiyei. ");
INSERT INTO pwg_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Ma ramramsi ke itoru kirakai, tuna kubiine ke ina miiri mara gurina. Wawaya ini kawapatesi ma ini tupaketowanesi vara biibiina itumaghanei kubiine na yaghiyaghinai i nota ina peku ma ina voterei. ");
INSERT INTO pwg_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Pei iyiyo ku kamosi iririgha na nakanani ma iyavo kava God varana biibiina ivi yanei ma dobu yawasina inuwapoya kirakiiyei ma mura ikirokirorowei da God vonana ipanigudagudai ma amena gwabisiyai kegha. ");
INSERT INTO pwg_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Ma pei viya ku tano biibiina iririgha na nakanani ma iyavo kava God varana biibiina ivi yanei ma iakova bubuni. Tuna nakanani ma pei igogo ighae, iuwa da sago sago duma amena 100, 60 bo 30 iterei.” ");
INSERT INTO pwg_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yesu bade miiba sago ivi sisiyei kurisi. Ivona bo, “God ina vikiivavona na weni nakanani. Tomowa sago whiti peina biibiina ina vao kamonai ivi busagha. ");
INSERT INTO pwg_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Ma didibarai wawaya ikenakena ma kana ghaviya ipisi ma inamona peina vao ku kamona ivi busagha ma inae. ");
INSERT INTO pwg_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Ma pei biibiina igogo ighae ma ivi karei da amena itereterei ma nani kamonai bade inamona igogo ighae.” ");
INSERT INTO pwg_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","“Vao badana ina bigabiga inae kurina ma ivonei bo, ‘Bada, pei biibiina kuvoni ma inamona imapatana ipisi da whiti kamonai igogo?’” ");
INSERT INTO pwg_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","“Ma ivonapotesi bo, ‘Kaku ghaviya iberai.’” “Ma ina bigabiga ivi tarakiiyanei bo, ‘Kekayokayowei da kana ragui bo?’” ");
INSERT INTO pwg_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","“Ma ivonesi bo, ‘Kegha. Inamona kona ragui na whiti yavata kona kayoragutawei. ");
INSERT INTO pwg_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Kovoterei da inamona yavata ina gogo patapata da kara bori kana mara ina nekiibau. Ma boribori wawayisi ana vonesi da kunona inamona ina ragutawei ma ina bawai ma ina kapuni. Ma muriyai whiti ina borini ma aku ku maghara numana ina tura.’” ");
INSERT INTO pwg_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Yesu miiba sago ivi sisiyei. Ivona bo, “God ina vikiivavona na weni nakanani. Tomowa kii peina iviiya da ina vao kamonai ivoni. ");
INSERT INTO pwg_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Tuna peina na gisi korekorena ma kegha da ina rakata da ini kiidagima da vao kamonai pei peyarina ina ghekuyowesi. Ma kiu ina pipisi da ragharaghanai ina towatowei.” ");
INSERT INTO pwg_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Ma bade miiba sago iterei. Ivonesi bo, “God ina vikiivavona na weni nakanani. Wavine sago yist gisi vaghina iviiya ma parawa ghamana yavata ivoviravirai ma iterei da kapawina irakata.” ");
INSERT INTO pwg_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Ma Yesu aviyavisina ivivi sisiyei koroto kurisi na miibiiyai kava, ke meyani da iti sisiyota. ");
INSERT INTO pwg_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Nakanani ivivi miiba da aviyavisina peroveta igirumi na itupuwa. Igiruma bo, “Miibiiyai ani sisiya, Dobu ayamoni ma nani maranai aku nota ateregavui da mara sago nani notasi miibiiyai ani sisiyei kurisi.” ");
INSERT INTO pwg_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Yesu koroto iverukuyowesi ma irui ku numa kamona. Ma kana kivikivina ipisi kurina ma ivonei bo, “Bada, kade inamona vao kamonai miibiina na kuta vonavibeyekai.” ");
INSERT INTO pwg_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Ma ivonapotesi bo, “Tomowa pei biibiina ivoni na Wawaya Natusi. ");
INSERT INTO pwg_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Ina vao na dobu. Ma pei biibiina na God natunatuna. Inamona na Devil natunatuna. ");
INSERT INTO pwg_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Vao badana kana ghaviya inamona ivoni na Devil. Bori marana na mara damona ma boribori wawayisi na aneya.” ");
INSERT INTO pwg_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","“Ikikava inamona ina ragui ma ku keyama karakaratina ina tawei na nakanani mara damonai ina tupuwa. ");
INSERT INTO pwg_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Wawaya Natusi ina aneya ina vonatawesi da ina vikiivavona kamonai berabero wawayisi ma aviyavisina kava eberaberisi da berabero eberaberai na kudubisi ina ragutawesi. ");
INSERT INTO pwg_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Ina tawesi ku keyama karata makamakii nonowina ma nani dobunai ina tutou ma okesi ina vivitarakikitei. ");
INSERT INTO pwg_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Nani murinai wawaya maninisi i Mamai God ina vikiivavona kamonai ina makai na kii kita ina ruyasegana da madegha nakanani. Wawaya ere tinimi na aku sisiya kovi yana bogai.” ");
INSERT INTO pwg_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“God ina vikiivavona na weni nakanani. Mara sago tomowa sago mane ghamana gavugavuna tano kamonai ipanani. Idogo meyei ma nuwabiibiiyai inae ma ina mura kudubina ivi gimarei. Ma manena iviiya ma inae da nani tanona igimaratawei da mane gavugavuna ivi rapenei.” ");
INSERT INTO pwg_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Bade miiba sago weni. God ina vikiivavona nakanani ma tomowa sago pel biibiisi iekwekwai da ita gimara. ");
INSERT INTO pwg_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Sago biibii kirakiina ipanani ma inae da ina mura peyarina ivi gimarei. Ma manena iviiya da nani pelna igimaratawei da rapenai.” ");
INSERT INTO pwg_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Ma miiba sago na God ina vikiivavona nakanani ma wito. Wawaya ivi yoyowi ioru ku okowa ma iyana bogii ma bogiiyai ikonai. ");
INSERT INTO pwg_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Ikona kirakai da wito itupakutukutuvi ma itini da ku kikira. Ma imakiivipikapika ma ivorereghi, iyana biibiisi ku kode iuwana ma beroberosi ivi tawetaweyana. ");
INSERT INTO pwg_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Weni nakanani ina tupuwa mara damonai. Aneya ina nekiibau ma God ina wawaya maninisi kamosiyai na wawaya beroberosi ina viitawesi ");
INSERT INTO pwg_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","ma ina tawesi ku keyama karata makamakii nonowina. Nani dobunai ina tutou ma okesi ina vivitarakikitei.” ");
INSERT INTO pwg_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Ma Yesu ivi tarakiiyanesi bo, “Weni miibiisi peyarina koakova bubuni bo kegha?” Ma kana kivikivini ivona bo, “E, damina kaviini.” ");
INSERT INTO pwg_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ma ivonesi bo, “Meni vonaviyoyovana vibeyebeyena wawayina God ina vikiivavona ku kamona ina rui na tuna nakanani ma wawaya ghamana ina mura numa kamonai iti yava bubuni. Ma mura kamonai na buderi katakatamanisi ma bade mura vusi.” ");
INSERT INTO pwg_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Yesu ina miiba sisiyisi ivi kovini ma ivomiiri inae. ");
INSERT INTO pwg_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Ina ku kwanatu vaghata inekiibau ma ivi karei da i kiki numanai wawaya ivivi beyebeyesi. Ma wawayisi ivi deyei ma ivona bo, “Weni tomowina na ina nuwagiura meni dobunai iviiya? Ma rewapana imapatana iviiya da bera ghamaghamasi eberaberai? ");
INSERT INTO pwg_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Wena takovi, da tuna vonura wawayina natuna, ma ina maduwa na Meri. Titina yoghoyogho na Jemes, Josepa, Saimon ma Judas. ");
INSERT INTO pwg_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Ma bade novunovuna gwabitiyai emakamakai. Ma weni berasi na imapatana iviiya?” ");
INSERT INTO pwg_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ma ivonavuvurei. Ma Yesu ivonesi bo, “Dobu viruwa wawayisi peroveta evovokaravei, ma tuna mani ina dobuwai bo ina numiiyai na kegha.” ");
INSERT INTO pwg_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Tuna kubiine nani dobunai bera ghamaghamasi ke peyarina ita berai, iyamna i vitumaghana kegha. ");
INSERT INTO pwg_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Nani maranai Gariri damsi i kiivavo kana vava Herodi ma tuna Jon Babataito iwana ikiiyaraghi. Ma Yesu varana ivi yanei, ");
INSERT INTO pwg_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","na ina bigabiga wawayisi ivonesi bo, “Nani tomowina na Jon bo? Agunai da rabobowai ivomiiri. Tuna kubiine rewapana gwabinai da bera ghamaghamasi eberaberai.” ");
INSERT INTO pwg_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Jon ina rabobo na weni nakanani itupuwa. Herodi varesina na Piripo ma Piripo kawana na Herodiyasi. Ma Herodi na Piripo kawana ivi tuneboi. Tuna kubiine Jon inae Herodi kurina ma ivonei bo, “Varesim kawana kuravaghi na Moses ina vonaviyoyovana kuvi kiigiiyei.” Weni sisiyina kubiine Herodi, Jon ipaniya ma ku gabura iterei. ");
INSERT INTO pwg_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Ma ina kayowana ghamana da Jon ita kiivunui. Ma ke kovokovoghina, iyamna wawaya peyarisi ivivi tumaghana da Jon na God ina peroveta, tuna kubiine Herodi iyabumanesi. ");
INSERT INTO pwg_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Ma Herodi ina tupuwa marana na kam ghamana iterei. Ma Herodiyasi natuna wiwikena koroto maghinosiyai iriku da Herodi nuwanuwana ivii kirakiiyei. ");
INSERT INTO pwg_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Tuna kubiine vonakiiyapa bagibagina kurina iterei, ivona bo, “Am kayowana avai, kuna voneku na ana verem.” ");
INSERT INTO pwg_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Ma wiwikena ina maduwa ina kayowana ikivini da Herodi ivonapotei bo, “Aku kayowana Jon Babataito gayamina dabira kamonai kunuwani da kuna vereku.” ");
INSERT INTO pwg_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Ma Herodi ivi nuwapoya kirakai, ma namada ivonakiiyapa da turaturana peyarisi ina sisiya ivi yanei, tuna kubiine ke iti kegha. Ina seri wawayina ivi yonei ");
INSERT INTO pwg_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","da ita nae da gabura kamonai Jon iwana ita kiiyaraghi. ");
INSERT INTO pwg_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Ikiiyaraghi ma Jon gayamina ku dabira iuwani ma ikavararuwei da wiwikena iverei. Ma wiwikena ikavari da ina maduwa iverei. ");
INSERT INTO pwg_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Ma vaghina, Jon kana kivikivina ipisi da tupuwina ikavari inae da idogoi. Muriyai inae da aviyavisina itupuwa na Yesu ivonei. ");
INSERT INTO pwg_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Yesu ivi yanei da Jon irabobo na koroto ghamana ikuyowesi ma ku waka igeru ma ina kayowana da ina kina kava ita nae ku dobu makiiwapana. Ma ke kovokovoghina, wawaya sisiya ivi yanei da Yesu wakiiyai inenae na i kwanatu ikiibutawei ma tanowai iverukivini. ");
INSERT INTO pwg_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Yesu iwota na koroto ghamana ikitisi da ivi kamyuyuwesi ma i wawaya gubagubagisi ivi yawasisi. ");
INSERT INTO pwg_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Ravi ipika na kana kivikivina ipisi ma Yesu ivonei bo, “Madegha ikovi ma wena dobu makiiwapana. Kevonatawesi ina nae ku meyagai da ti mani kii vavai ina gimara.” ");
INSERT INTO pwg_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Ma Yesu ivonapotesi bo, “Kegha, ke ina nae. Tami vavai kona veresi da ina kam.” ");
INSERT INTO pwg_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Ma kana kivikivina ivona bo, “Ke ruvaruvana! Parawa miikovi ma iyana ruwa kava weni.” ");
INSERT INTO pwg_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Ma Yesu ivona bo, “Kokavarapiyei kuriku.” ");
INSERT INTO pwg_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Ma nani korotona ivonesi da inamona tepanai imakiipikapika. Ma nani parawisi miikovi ma iyana ruwa iviiya ma itepa ku kunuma ma God kurina ivi kiikiiwa ma parawa ivogimai. Ma kana kivikivina iveresi da wawaya irereghisi. ");
INSERT INTO pwg_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Vaghina ma, nani korotona kudubina ikam da inunusi. Ikam ikovi ma kana kivikivina kam tutura iyuna da kode ivi 12 ivi tupoi. ");
INSERT INTO pwg_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Ma nani korotona kamonai tomotomowa kava ivi yavisi na 5 tausan. Ma wivine da ededa yoghoyogho na ke iti yavisi. ");
INSERT INTO pwg_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Nani murinai Yesu kana kivikivina ivi gerusi ku waka, ivonatawesi da ivi nao ku toka nevana. Idamadamana na bade Yesu koroto ghamana ivonatawesi inae. ");
INSERT INTO pwg_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Korotona inenae ma nipowana kubiine ighae ku koya tepana. Ravi ipika ma patana da ina kina kava imakamakai, ");
INSERT INTO pwg_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","ma waka na namada ikiibu kirakai. Ma yanunu maghinosiyai ipipisi ma tovava ghamaghamasi waka irugerugei. ");
INSERT INTO pwg_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Mara tomtom nubakutuvina kamonai, Yesu okowa tepanai ibaba inenae kurisi. ");
INSERT INTO pwg_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Ma kana kivikivina ikitai da wawaya sago okowa tepanai ibababa ma iyabumana kirakai ma ikiirara bo, “Momosika!” ");
INSERT INTO pwg_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Ma Yesu yaghiyaghinai ivonesi bo, “Ke kona yabumana, ami nota evirewapana. Taku.” ");
INSERT INTO pwg_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Ma Pita ivona bo, “Bada, vonavaghata da tam na kevoneku da taku bade okowa tepanai ana baba ana nae kurim.” ");
INSERT INTO pwg_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Ma Yesu ivona bo, “Kepisi.” Vaghina ma Pita waka ikiibutawei ma ivi karei da okowa tepanai ibaba inenae Yesu kurina, ");
INSERT INTO pwg_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","ma damina iviiya da yanunu ma tovava irakata na iyabumana kirakai. Ivi karei da imonumonu ma ivi kwatu bo, “Bada, kevi viteku!” ");
INSERT INTO pwg_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Ma Yesu ivororona, imana ivotani ma itinepai. Ma ivonei bo, “Am nota igisi, avi kubiine ke kuti tumaghaneku?” ");
INSERT INTO pwg_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Ma ivi ruwa igerugeru ku waka na yanunu inuba. ");
INSERT INTO pwg_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Ma vaghina, kana kivikivina waka tepanai ivokavakavari ma ivona bo, “Vonavaghata, tam God Natuna.” ");
INSERT INTO pwg_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Toka idamani ku nevana da Genesaretiyai iwota. ");
INSERT INTO pwg_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ma wawaya nani dobunai ivogiini da tuna Yesu na sisiya ivi vovonavoneyanei da dobu ine yavui ma i wawaya gubagubagisi ikavaraneyesi Yesu kurina. ");
INSERT INTO pwg_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Ma wawaya ivivi nowi da gubagubagisi kana gara damokikina kava ita votovoni. Ma iyavo kava ivovotovoni na kudubisi iyawasa. ");
INSERT INTO pwg_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Perisi damsi ma vonaviyoyovana vibeyebeyena wawayisi viya Jerusalem kamonai ipisi Yesu kurina da ivi tarakiiyanei bo, ");
INSERT INTO pwg_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Avi kubiine kam kivikivina kiki katamana ikiigiiyei? Vi imakowa ketana ke ita kivikivina bubuni. Kunona na imasi ita tepokowakowai ma muriyai da ita kam.” ");
INSERT INTO pwg_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Ma Yesu ivonapotesi bo, “Ma tami, avi kubiine God ina sisiya bagibagisi kobarei da tami mani ami kiki kokivikivini? ");
INSERT INTO pwg_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","God ivoneta bo, ‘Ami mamai da ami maduwa kovopepetisi.’ Ma ivona bo, ‘Iyi ina mamai bo ina maduwa ini avaberowesi na kokiivunui.’ ");
INSERT INTO pwg_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Ma tami na ami vibeyebeyena na weni nakanani. Tomowa ina maduwa da ina mamai ina vonesi bo, ‘Aku bera ma aku sawara peyarina God kurina asuwara. Tuna kubiine ke ani vitemi.’ ");
INSERT INTO pwg_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Weni nakanani koibeyebeyena na God vonana kotatakuputei da ami kiki katamana kokivikivini. ");
INSERT INTO pwg_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Tami miiriruwaruwami! Aisaya ivona bubuna, igiruma da God ivona bo, ");
INSERT INTO pwg_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Weni wawayisi kawasiyai evonavona da evovokaraviku, Ma nuwanuwasi inetaweyana, ke gwabikuwai. ");
INSERT INTO pwg_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","I vokavakavara na kwebuna. Nuwatepasiyai evovokavakavariku na iyamna kegha. Ti mani i akova ma i kiki tepanai ibeyebeyena.’” ");
INSERT INTO pwg_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Yesu wawaya ikwaturiyariyesi ma ivonesi bo, “Kovi yana bubuna da akova kona viiya. ");
INSERT INTO pwg_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Aviyavisina kawamuwai kekanikani ma keumumai na ke ina berim da God ku matana tam na dadabum. Ma sisiya berona kawamuwai ina kiibau na tuna ina berim da God ku matana tam na dadabum.” ");
INSERT INTO pwg_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Muriyai kana kivikivina inae Yesu kurina ma ivonei bo, “Kuakovi bo kegha da nakanani kuvi sisiya na Perisi damsi nuwanuwasi ipughu.” ");
INSERT INTO pwg_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Ma ivonapotesi bo, “Aku Mamai kunumai aviyavisina ke tuna mani imanai ita voni na ere ramramna ina tinaragutawei. ");
INSERT INTO pwg_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Kovoteresi, nani Perisi damsi ke kona notisi, ti na babada matapotapotasi. Wawaya matapotapotana ma kwinana matapotapotana ini nowei na ivi ruwa ku bonagha ina ririgha.” ");
INSERT INTO pwg_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Ma Pita ivona bo, “Bada, miibiina Perisi damsi kuvonesi na iyamna kuti debei kurikai.” ");
INSERT INTO pwg_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Ma Yesu ivona bo, “Te! Patana da koneghanegha bo? ");
INSERT INTO pwg_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Kade kotakovi da aviyavisina kawatiyai takanikani ma tumumai na ku kamokamota erurui ma muriyai tupuwita ina kiibutawei. ");
INSERT INTO pwg_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Nota berona wawaya nuwanuwana kamonai egheghetawei da kawanai sisiyina ekarakaratawei. Tuna ina berai da God ku matana wawayina na dadabuna. ");
INSERT INTO pwg_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Wawaya nuwanuwana kamonai nota dadabusi egheghetawei. Kiivunuwa, vipekana wapawapa, ruwavine, rutomowa, yapi, vimamatara bero ma viavabero. ");
INSERT INTO pwg_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Weni berasi kona berai na God matanai tami wawaya dadabumi. Ma imami ke kona tepokowakowai ma kona kam na tuna ke ini dadabumi.” ");
INSERT INTO pwg_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Yesu nani dobuna ikiibutawei ma inae ku Taya ma Saidon kwantusi. ");
INSERT INTO pwg_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Ma wavine sago nani dobunai imakamakai, tuna dobu viruwa wawayina, ina karena na Keinan dobuna. Ma ipisi Yesu kurina ma ikiirara bo, “Bada, tam David Tupurereghina, kevi kamyuyuweku! Natuku wavinena gwabinai kanuma berona irunuma da evovokwarakwara kirakai.” ");
INSERT INTO pwg_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Ma Yesu ke sago ita vonapotei. Ma kana kivikivina ipisi da Yesu kurina ivi nowi bo, “Kevonatawei ina nae, ekivikivinita ma ekiikiirara kirakai.” ");
INSERT INTO pwg_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Ma Yesu wavinena kurina ivona bo, “Apisi da Israel damsi kava kubiisi. Ti nakanani ma sipu siwasiwanisi.” ");
INSERT INTO pwg_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ma wavinena ipisi kurina da maghinonai ivi tuwaporeruruwana ma ivonei bo, “Bada, kevi viteku!” ");
INSERT INTO pwg_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Ma ivonapotei bo, “Ke ita biibai da wawaya ededa kii vavai ita viiya ma ita tawei kukou kurisi da ita kani.” ");
INSERT INTO pwg_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Ma wavinena ivona bo, “Vonavaghata Bada, ma kegha da kukou ina mamai ekamkamririgha na evovoterei da ina kukou ekanikani.” ");
INSERT INTO pwg_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Ma Yesu wavinena ivonapotei bo, “Aku wavine, am vitumaghana irakata kirakai! Am kayowana ana berai.” Ma yaghiyaghinai natuna iyawasa. ");
INSERT INTO pwg_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Yesu nani dobuna ivoterei da ku Gariri tokana inae. Ma kikirai ibaba inae da ighae ku koya barana ma imakiivipika. ");
INSERT INTO pwg_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Koroto ghamana iriyei kurina ma gubagubagisi irutinaneyesi. Digadigasi, matapotapotasi, kawapotapotasi ma kii gubaga bogii ma bogiiyai. Yesu maghinonai ivi makiinisi da ivi yawasisi. ");
INSERT INTO pwg_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Ma wawaya peyarisi ivi deye kirakiiyei da kawapotapotasi ivivi sisiya, digadigasi ibababa, ma matapotapotasi ikitakita. Ma Israel i God ivi ghegheni. ");
INSERT INTO pwg_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Yesu kana kivikivina ikwaturiyariyesi ma ivonesi bo, “Weni wawayisi aikamyuyuwesi, iyamna mara aroba yavata tamakamakai ma kii vavai kegha. Ke ata kayokayowei da ere vitonarisi ana vonatawesi da ketiyai ina kayoparoro.” ");
INSERT INTO pwg_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Ma kana kivikivina ivonei bo, “Wena dobu makiiwapana. Vavai imapatana tapanani da koroto ghamana tikanisi?” ");
INSERT INTO pwg_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Ma Yesu ivi tarakiiyanesi bo, “Parawa viya gwabimiyai?” Ma ivonapotei bo, “Parawa miikovimaruwa ma iyana ruwa kikei.” ");
INSERT INTO pwg_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Ma Yesu, koroto ghamana ivonesi da tanowai imakai. ");
INSERT INTO pwg_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Ma parawa da iyana iviiya ma God ivi kiikiiwei. Ivogimagimai ma kana kivikivina iveresi da irereghi wawaya kurisi. ");
INSERT INTO pwg_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Ma peyarisi ikam da inunusi. Ikam ikovi ma murinai kana kivikivina kamtutura iyuna da kode miikovimaruwa ivi tupoi. ");
INSERT INTO pwg_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Nani korotona kamonai na tomotomowa kava ivi yavisi na ivi 4 tausan ma bade wivine ma ededa yoghoyogho yavata ikam. ");
INSERT INTO pwg_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Ma vaghina, korotona ivonatawesi inenae na Yesu ku waka igeru da idamana ku Magadan dobuna. ");
INSERT INTO pwg_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Perisi ma Sadusi damsi ipisi Yesu kurina ma ivi kaetina da matakira ghamana ita berai da ita kitai. ");
INSERT INTO pwg_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Ma ivonesi bo, “Ravi ina pika ma mara ina ruwabai na kona vona bo, ‘Maram na mara biibiina.’ ");
INSERT INTO pwg_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ma mara boiboiyai mara ina gigiri ma muriyai ina kwavui na kona vona bo, ‘Garewa ina katuna.’ Koakovi ikikava matakira kunumai kona kitai na kona vona da mara biibiina bo mara berona. Ma karako na matakira ghamaghamasi etuputupuwa, idebei da God ina Vivinevine Wawayina inekiibau ma avi kubiine ke akovina kota viiviiya? ");
INSERT INTO pwg_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Weni kimtina na God ke koti tumaghanei ma kawakiikiimi, ma ami kayowana da matakira ghamana kota kitai, bo? Kegha, ke ani beyemi, ma peroveta Jona aviyavisina ipanani na tuna matakirina kava kona kitai.” Ma Yesu ivoteresi ma inae. ");
INSERT INTO pwg_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Toka idamani na Yesu kana kivikivina nuwanuwasi iwapa da parawa ke ita viini. ");
INSERT INTO pwg_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Ma Yesu ivonesi bo, “Kokitaruvimi! Perisi ma Sadusi damsi i yist kokitaruvai.” ");
INSERT INTO pwg_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Ma kana kivikivina ti mani kavakava inipusi, ivona bo, “Mikeda parawa ke kata viini, tuna kubiine nakanani ivoneta.” ");
INSERT INTO pwg_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Ma Yesu iakovi aviyavisina ivivi sisiyei ma ivi tarakiiyanesi bo, “Tami ami vitumaghana igisi ghagha. Parawa ke kota viini na tuna koisisiyei, bo? ");
INSERT INTO pwg_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Tami kotakovi da taku iyai. Konotanotai bo kegha da parawa miikovi kava ma tomotomowa ivi 5 tausan avi kanisi? Ma kamtutura na kodesi viya koviini? ");
INSERT INTO pwg_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Ma bade parawa miikovimaruwa kava na tomotomowa ivi 4 tausan avi kanisi. Ma kamtutura koyuna na kode viya kovi tupoi? ");
INSERT INTO pwg_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Avi kubiine ke kotakovi da taku ke parawa ata vivisisiyei? Ma ana vona meyemi da Perisi ma Sadusi damsi i yist kokitaruvai.” ");
INSERT INTO pwg_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Ma wekarakava kana kivikivina akovina iviiya da ke parawa kana yist ita vivisisiyei ma Perisi ma Sadusi damsi i vibeyebeyena viviberona na tuna ivivi sisiyei. ");
INSERT INTO pwg_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Yesu kana kivikivina yavata inae ku kwanatu sago kana vava Sisariya Pilipai. Ma kana kivikivina ivi tarakiiyanesi bo, “Kovoneku, wawaya enotanotai da taku Wawaya Natusi na iyai?” ");
INSERT INTO pwg_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Ma ivonapotei bo, “Viya evonavona da tam Jon Babataito, ma viya evonavona da tam na peroveta Elaidiya, ma viya evonavona da tam Jerimaya bo peroveta sago.” ");
INSERT INTO pwg_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Ma ivi tarakiiyanesi bo, “Ma tami, konotanotai da taku na iyai?” ");
INSERT INTO pwg_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Ma Saimon Pita ivonapotei bo, “Tam na God ina Vivinevine Wawayina. Tam na God Yawayawana Natuna.” ");
INSERT INTO pwg_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Ma Yesu ivonapotei bo, “Saimon, Jona natuna, God ivi biibiinim. Aku Mamai kunumai nani notana iverem, ke wawayota gwabisiyai kuta viiya. ");
INSERT INTO pwg_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Saimon, avonavonem da kam vava vuna na Pita (Pita iyamna na ‘wakima’). Ma weni wakimina tepanai aku ekalesiya ana yamoni. Ma rabobo ina rewapana ke kovokovoghina da ina ghegavovori. ");
INSERT INTO pwg_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Pita, tam matuketa kana koyakoyagha God ina vikiivavona kamonai ma rewapana avereverem da aviyavisina dobuwai kuna gudui na bade God ku murim ina miiri da kunumai ina gudui. Ma aviyavisina dobuwai kuni vaghinei na bade God ku murim ina miiri da kunumai ini vaghinei.” ");
INSERT INTO pwg_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Ma Yesu ivonatanisi da wawaya kurisi ke iti mamatara da tuna na God ina Vivinevine Wawayina. ");
INSERT INTO pwg_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Nani maranai Yesu ivi karei da kana kivikivina ivonavonaveresi da aviyavisina ina tupuwa kurina. Ivona bo, “God ina kayowana da ana nae ku Jerusalem da Jiu damsi i babada ma taparoro babadisi i babada ma vonaviyoyovana vibeyebeyena wawayisi ina berai da ani kamaghi kirakiiyei. Ma ini raboboku ma mara viarobina kamonai rabobowai ana vomiiri.” ");
INSERT INTO pwg_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Ma Pita, Yesu itinaviviri ku ririna ma iyeghai bo, “Kegha, Bada! Ke nakanani ina tupuwa kurim!” ");
INSERT INTO pwg_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Ma Yesu imiiritavire ma Pita ivonapotei bo, “Seitan, kenetaweyana! Kiketagudugudu! Nani notana na ke God ita verem, tam dobu notana kenotanotai.” ");
INSERT INTO pwg_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Muriyai Yesu kana kivikivina ivonesi bo, “Iyi tam kekayokayowei da kuna kiviniku na kevere meyem, am korosi kekavari ma kekiviniku. ");
INSERT INTO pwg_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Tam iyai am yawasa kuna nuwaghanei na kuni wapai. Ma tam iyai am yawasa kuna nuwatawei taku kubiiku na yawasa makamakii nonowina kona panani. ");
INSERT INTO pwg_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Dobu kana mura kudubina kuta viiya ma kanumim kuti wapai na am mura ke sago iti vitem da yawasa kuta panani bo kanumim kuta vii meyei. ");
INSERT INTO pwg_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Ma mara sago taku Wawaya Natusi aku Mamai kana kadara kamonai ana pisi, ma aneya vovokaravisi yavata. Nani maranai wawaya kudubisi i bera ana ruvai ma ani miiyesi bo kii kovogha ana veresi. ");
INSERT INTO pwg_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Vonavaghata avonavonemi, wawaya viya kamotiyai taku Wawaya Natusi aku vikiivavona kona kitai ma muriyai da kona rabobo.” ");
INSERT INTO pwg_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Mara miikovimasago murinai Yesu kana kivikivina aroba irutinisi, ti na Pita, Jemes ma Jon, tuna Jemes tina kikei. Koya ghamana igheni ma nani dobunai ti mani kava imakai. ");
INSERT INTO pwg_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Ma kana kivikivina ikitakitai ma Yesu kana kita ivire. Maghighina iruyasegana da madegha nakanani ma kana gara poipoi kirakiina. ");
INSERT INTO pwg_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Ke mara gurina ma ivi aroba ikitai da Moses ma Elaidiya irumatara da Yesu yavata ivivi sisiya. ");
INSERT INTO pwg_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Ma Pita, Yesu kurina ivona bo, “Bada, ibiibii kirakai da tota weni! Kuna kayowei na yobe aroba ana yamoni. Sago tam, sago Moses, ma sago Elaidiya.” ");
INSERT INTO pwg_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Ivivi sisiya kamonai na kwavu ere yaseganina inekiibau da isovomumusi. Ma gamo kwavu kamonai ivona bo, “Wena natuku, tuna nuwanuwaku ma ainuwabiibiiyei. Ina sisiya kovi yana bogai.” ");
INSERT INTO pwg_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Maranai kana kivikivina gamo ivi yanei na iyabumana kirakai da itawotesi ku dowa ma maghighisi ikiigavugavui. ");
INSERT INTO pwg_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Ma Yesu ipisi kurisi da ivotovonisi. Ma ivonesi bo, “Kovomiiri, ke kona yabumana.” ");
INSERT INTO pwg_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Itepa ma ita kita na Yesu ina kina kava ikitai. ");
INSERT INTO pwg_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Koya tepanai iororu na Yesu sisiya bagibaginai ivonatanisi bo, “Matakirisi kokitai na ke koni sisiyei. Taku Wawaya Natusi rabobowai ana vomiiri ma nani murinai wawaya kurisi koni mamatara.” ");
INSERT INTO pwg_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Kana kivikivina Yesu ivi tarakiiyanei bo, “Avi kubiine vonaviyoyovana vibeyebeyena wawayisi mara nonowa evonavona da Elaidiya ini nao ina vovira ku dobu ma murinai na God ina Vivinevine Wawayina ina nekiibau?” ");
INSERT INTO pwg_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Ma Yesu ivonapotesi bo, “Vonavaghata da Elaidiya iti nao ma bera peyarina ita vovunaghi. ");
INSERT INTO pwg_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ma ana vonemi da Elaidiya namada inekiibau ma wawaya iveyiyei ma ivi kayotiranei. Ma bade nakanani taku Wawaya Natusi ini kayotiraneku da ani kamaghi kirakiiyei.” ");
INSERT INTO pwg_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Nani maranai kana kivikivina inotapanani da tuna Jon Babataito ivivi sisiyei. ");
INSERT INTO pwg_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Yesu kana kivikivina ivi aroba yavata koyiyai iororu na koroto ghamana ipananisi ivivi koyakoyagha. Ma tomowa sago ipisi Yesu kurina ma maghinonai ivi tuwaporeruruwana ma ivi nowi bo, ");
INSERT INTO pwg_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Bada, natuku kevi kamyuyuwei. Eparoparoro ma evovokwarakwara kirakai. Mara ipeyari epekupeku ku keyama karakaratina ma ku okowa. ");
INSERT INTO pwg_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Arutinapiyei kam kivikivina kurisi ma ke ruvaruvana da iti yawasi.” ");
INSERT INTO pwg_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Ma Yesu ivonesi bo, “Weni kimtina na kawakiikiimi. Mara iguri ghagha yavata tamakamakai ma patana da ami vitumaghana kegha! Vaghina, tomowa kikei korutinapiyei kuriku.” ");
INSERT INTO pwg_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Ma Yesu kanuma berona iyeghai da tomowa kikei ikiibutawei ma yaghiyaghinai iyawasa. ");
INSERT INTO pwg_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Nani murinai kana kivikivina inae Yesu kurina ma gavunai ivi tarakiiyanei bo, “Avi kubiine tokai ke ruvaruvana da kanuma berona kata kwavinakiibuwei?” ");
INSERT INTO pwg_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Ma ivonapotesi bo, “Iyamna ami vitumaghana igisi kirakai. Vonavaghata avonavonemi, mikeda ami vitumaghana ita rakata da nakanani ma pei gisi korekorena na kovokovoghina da koya kota vonei bo, ‘Noke kenae’ ma vaghina ita nae. Koni tumaghana na kovokovoghimi da bera kudubina kona berai.” ");
INSERT INTO pwg_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","(-) ");
INSERT INTO pwg_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Yesu kana kivikivina yavata Gariri kamonai ivi sagosi ma ivonesi bo, “Tomowa sago taku Wawaya Natusi ini wawaneku da kaku ghaviya ku imasi ina tereku. ");
INSERT INTO pwg_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Ma ini raboboku ma mara viarobina kamonai God ina berai da rabobowai ana vomiiri.” Nakanani ivi sisiya na kana kivikivina ivi nuwapoya kirakai. ");
INSERT INTO pwg_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Yesu kana kivikivina yavata irui ku Kapeniyam kwanatuna. Ma teks yuyuna damsi ipisi Pita kurina ma ivi tarakiiyanei bo, “Ami Bada Taparoro Numana kana teks ini miiyei bo kegha?” ");
INSERT INTO pwg_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Ma Pita ivonapotesi bo, “E, ini miiyei.” Pita irui ku numa kamona da Yesu kurina iti sisiya ma Yesu ivi nao, ivona bo, “Saimon, am nota avai? Kiikiivavo na meni wawayisi gwabisiyai teks ina yuna, natunatusi gwabisiyai bo wawayota gwabisiyai?” ");
INSERT INTO pwg_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Pita ivonapotei bo, “Wawayota gwabisiyai.” Ma Yesu ivona bo, “Tuna kubiine kiikiivavo natunatusi na teks ke ini miiyei. ");
INSERT INTO pwg_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Ma kegha da ke ata kayokayowei da weni damsi nuwanuwasi ina pughu. Tuna kubiine kenae ku toka ma am kiimo ketawei. Meni iyanina kuni nao kuna tini na kawana kevoaghae da kamonai silva riririghina kuna panani. Ma tuna na ruvaruvana da tam ma taku kubiita ita teks kuni miiyei.” ");
INSERT INTO pwg_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Nani maranai Yesu kana kivikivina ipisi kurina ma ivi tarakiiyanei bo, “God ina vikiivavona kamonai na iyi ini wawayaghama?” ");
INSERT INTO pwg_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Ma Yesu wawaya kikei sago ikwatui ipisi da kamosiyai imiiri. ");
INSERT INTO pwg_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Ma ivonesi bo, “Vonavaghata avonavonemi, ke kona tereoruwe meyemi da tami nakanani ma ededa yoghoyogho na ke kovokovoghina kona rui God ina ku vikiivavona. ");
INSERT INTO pwg_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Tam iyai kuna tereoruwe meyem da weni wawaya kikina nakanani na God ina vikiivavona kamonai tam kuna ghe kirakai.” ");
INSERT INTO pwg_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","“Ma iyavo kava taku notakuwai wawaya kikei kona tinariyai na ke tuna kava ma taku yavata kotitinariyeku.” ");
INSERT INTO pwg_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Ma iyavo kava ina berai da wawaya kikei ina vitumaghana ina voterei na kovogha bero kirakiina ina viiya. Ita biibai da iwanai wakima ghamana ita kuni ma ita tawei ku bogapu da ituma dodo. ");
INSERT INTO pwg_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Wawaya dobuwai, koti nuwapoya kirakai iyamna ruyagha ipeyari ina berai da wawaya vitumaghana ina voterei. Nakanani mara nonowa ruyagha tapanapanani. Ma iyai kwinana ina ruyaghai da ina peku na tuna kana kovogha ina rakata kirakai.” ");
INSERT INTO pwg_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Mikeda imam bo kaem ina berim da berabero kuna berai na kekiiyaraghatawei. Ibiibai da imam bo kaem nevana kava ma yawasa makamakii nonowina kuna panani. Ma ibero kirakai da imam bo kaem ruwa ma ku keyama karata makamakii nonowina ina tawem. ");
INSERT INTO pwg_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Bo matam ina berim da kuna peku na matam kemuitawei. Ibiibai da matam nevana kava ma yawasa makamakii nonowina kuna panani. Ma ibero kirakai da matam ruwa ma ku keyama karata makamakii nonowina ina tawem.” ");
INSERT INTO pwg_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Kokitaruvimi da weni ededa yoghoyoghosi ke kona kitaoruwesi. Avonavonemi da i aneya kunumai mara nonowa aku Mamai God maghinonai emiimiiri.” ");
INSERT INTO pwg_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","(-) ");
INSERT INTO pwg_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Mara sago tomowa ina sipu ivi 100 ma sago ita siwana na ami nota ikikava? Aviyavisina ita berai? Ina sipu ivi 99 warereyai ita kuyowesi da ita kamkam ma ita nae da siwasiwanina itekwai. ");
INSERT INTO pwg_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Nani sipuna sago kava ita panani na avonavonemi da iti nuwabiibii kirakiiyei, ke nakanani ma ivi 99. ");
INSERT INTO pwg_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Bade nakanani ami Mamai kunumai ke ita kayokayowei da wawaya kikei sago ina siwana.” ");
INSERT INTO pwg_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Keresiyana varesim berabero ina berai kurim na kenae kurina ma kevonei da ibera beroi. Kebera gavui da ami viruwa kava koni sisiyei. Ini yanem na nuwanuwana kuna tinavirai da koni vonapoteyana. ");
INSERT INTO pwg_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ma am sisiya ke ini yanei na bade vimamatara wawayisi sago bo ruwa kuna rutinisi da yavata kona vovira da kona vona meyei. Nakanani kona berai da giruma katamana kona nunuri. Igiruma bo, ‘Wawaya ruwa bo aroba wawaya ini wavui, ke sago kava.’ ");
INSERT INTO pwg_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Patana da ke ini yanemi na korutini da ekalesiya yavata kovi dughuwei ma ina berabero kudubina kovi debei kurisi. Ma tuna ekalesiya ke ini yanesi ma ina berabero ke ininimayei na vaghina, kobarei da ke kamomiyai ina makai. Koberai da tuna nakanani ma ke vitumaghana wawayina bo teks yuyuna wawayina yapiyapina.” ");
INSERT INTO pwg_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Vonavaghata avonavonemi, aviyavisina dobuwai kona gudui na bade God kunumai ina gudui. Ma aviyavisina dobuwai koni vaghinei na bade God kunumai ini vaghinei. ");
INSERT INTO pwg_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Ma bade ana vona meyemi. Keresiyana varesim yavata ami viruwa dobuwai aviyavisina koni vaghinei na ami nota koni sagoi ma kona nipowana na aku Mamai kunumai ami kayowana ina berai kubiimi, ");
INSERT INTO pwg_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","iyamna maranai wawaya ruwa bo aroba avakuwai ini sagosi na taku yavata nani kamonai.” ");
INSERT INTO pwg_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Pita imiiririya Yesu kurina ma ivi tarakiiyana bo, “Bada, varesiku berona ina beraberai kuriku na mara viya ana notatawei? Mara miikovimaruwa bo?” ");
INSERT INTO pwg_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Ma Yesu ivonapotei bo, “Avonavonem da ke mara miikovimaruwa kava, kegha da mara peyarina ma mara nonowa kuna beraberai, ");
INSERT INTO pwg_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","iyamna God ina vikiivavona na weni miibiina nakanani. Mara sago kiivavo sago imakamakai ma nuwanuwana ivivi tetei da ina bigabiga wawayisi kii tupi ita ruvai da ita gudui. ");
INSERT INTO pwg_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Ivi karei ma wawaya ina bigabiga sago irutinapiyei, kana tupi irakata kirakai. ");
INSERT INTO pwg_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Nani bigabiga wawayina ke ruvaruvana da kana tupi ghamanakina ita gudui. Tuna kubiine kiivavo ina bigabiga viya kurisi ivonakiiyaragha da wawayina, kawana ma natunatuna iti gimaresi da iti sleiv ma bade ina sawara yavata kudubina iti gimarei da nani tupina ita gudui.” ");
INSERT INTO pwg_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","“Ma bigabiga wawayina itawotei ku tano ma manawinai isasa da kiivavo ku maghinona. Ma ivi nowi bo, ‘Kevi kamyuyuweku ma karakava kaku tupi peyarina ani miiyei.’ ");
INSERT INTO pwg_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Vaghina ma, kiivavo ivi kamyuyuwei ma kana tupi inotatawei ma ivotawei da inae.” ");
INSERT INTO pwg_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Nani bigabiga wawayina ikiibau inenae na bigabiga kwinana ipanani. Tuna gwabinai kana tupi gisina imakamakai. Tuna kubiine kaiyona ikimopotai ma ikiirara bo, ‘Kam tupi gwabikuwai kegudui!’” ");
INSERT INTO pwg_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","“Ma kwinana maghinonai itawotei ku tano ma ivi nowi bo, ‘Kevi kamyuyuweku ma karakava kaku tupi peyarina ani miiyei.’” ");
INSERT INTO pwg_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","“Ma ibara, ke iti kamyuyuwei da ku gabura itawanaoruwei ma nani dobunai ita makamakai da kana tupi iti miiya yavui. ");
INSERT INTO pwg_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Bigabiga turaturasi weni berana ikitai ma ivi nuwapoya kirakai. Inae kiivavo kurina ma aviyavisina peyarina itupuwa na ivi debei.” ");
INSERT INTO pwg_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","“Ma kiivavo nani bigabiga wawayina ikwatui da irui kurina. Ma ivonei bo, ‘Tam bigabiga berom! Kuvonavikamyuyuwa kuriku na kam tupi ghamanakina ma anotatawei. ");
INSERT INTO pwg_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Ikikava avi kamyuyuwem na nakanani bigabiga kwinam kuti kamyuyuwei.’ ");
INSERT INTO pwg_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Ma kiivavo nuwanuwana ipughu kirakai da ivonatawei ku gabura. Ma nani kamonai ina vowavowa kirakiiyei ina nene da kana tupi kudubina ini miiya yavui na ina kiibau.” ");
INSERT INTO pwg_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","“Ma aku Mamai kunumai nakanani ina berai kurimi maranai tami ke nuwanuwami kudubinai varevaresimi i berabero kona notatawei.” ");
INSERT INTO pwg_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Yesu ina sisiya ivi kovini na Gariri dobuna ikuyowei ma inae ku Judiya dobuna da Jodan okowina idamani. ");
INSERT INTO pwg_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Ma koroto ghamana ikivikivina yawarei, ma Yesu gubagubagisi nani dobunai ivivi yawasisi. ");
INSERT INTO pwg_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Ma Perisi damsi inae kurina da ivivi kaetina. Ivi tarakiiyanei bo, “Vonaviyoyovana kamonai kade vivaghina emakamakai bo kegha da tomowa tuna mani ina kayowanai kawana yavata ini kiitawetaweyana?” ");
INSERT INTO pwg_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Ma Yesu ivonapotesi bo, “Moses ina giruma namada kovi yavi da dobu karenai God ‘wawaya iyamonisi da tomowa ma wavine.’ ");
INSERT INTO pwg_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Ma God ivona bo, ‘Tuna kubiine tomowa ina mamai ma ina maduwa ina kuyowesi da kawana yavata ini kiikapu da sago.’ ");
INSERT INTO pwg_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Ivi ruwa ini kiikapu da sago, ke ruwa, iyamna God iberai da tomowa ma wavine isagosi, tuna kubiine wawaya ke ini bogebogesi.” ");
INSERT INTO pwg_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Perisi damsi ivi tarakiiyanei bo, “Avi kubiine Moses igiruma da, ‘Maranai tomowa kawana ina barei na kana bera weni nakanani. Vikiitawetaweyana sisiyina ina girumi da wavinena ina verei. Ma ina vonatawei da ina nae.’” ");
INSERT INTO pwg_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Ma Yesu ivonapotesi bo, “Ami vikawakiikai irakata, tuna kubiine Moses vivaghina iveremi da kakawami yavata koti kiitawetaweyana. Ma dobu karenai God ke nakanani ita terei. ");
INSERT INTO pwg_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Avonavonemi da meni tomowina kawana yavata ini kiitawetaweyana ma wavine sago ina ravaghi, tuna na berabero iberai. Ma bera sago kava kubiine ani vaghinei da tomowa kawana yavata ini kiitawetaweyana. Mikeda ina vopanani da kawana tomowa sago yavata ipekana wapawapa na vaghina, ina barei da ini bogebogesi.” ");
INSERT INTO pwg_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Ma kana kivikivina ivi 12 ivonei bo, “Mikeda tomowa da wavine weni nakanani ita makamakai na ibiibai da wawaya ke meyani ita tavine.” ");
INSERT INTO pwg_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Ma Yesu ivonapotesi bo, “God vibeyebeyena sago iterei da wawaya voviyavisi kava ke meyani ina tavine, ma tuna na ke wawaya peyarisi kubiisi. ");
INSERT INTO pwg_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Bera bogii ma bogiiyai emakamakai da wawaya ke ina tavine. Viya itupuwesi da igisi kegha ma ke ruvaruvana da iti pekana. Ma viya igisi iyuna da ke ruvaruvana da iti pekana. Ma wawaya viya God ina vikiivavona kubiine na vonakiiyapa bagibagina ina terei da ke ini pekana. Iyavo kava God ivinesi da ke ina tavine na weni vibeyebeyena ita kivini. Ma kegha na kegha.” ");
INSERT INTO pwg_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Ma wawaya viya ededa yoghoyogho irutinapiyesi Yesu kurina da imana ku tepasi ita terei ma ita nipowana kubiisi. Ma kana kivikivina wawayisi iyeghisi. ");
INSERT INTO pwg_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Ma Yesu ivonesi bo, “Ededa yoghoyogho kovoteresi da ina pisi kuriku, ke kona tarapaparisi. Wawaya weni ededa yoghoyoghosi nakanani na God ina vikiivavona rapesiyai.” ");
INSERT INTO pwg_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Vaghina ma, imana ku gayamisi iterei da ivi biibiinisi ma inekuyowesi. ");
INSERT INTO pwg_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Tomowa sago yaragina ipisi Yesu kurina ma ivi tarakiiyanei bo, “Bada, avi berana biibiina ana berai da yawasa makamakii nonowina ana viiya?” ");
INSERT INTO pwg_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Ma Yesu ivonapotei bo, “Avi kubiine bera biibiisi kitarakiiyanei? God ina kina kava na biibiina. Ina sisiya bagibagisi kevotekatekei da yawasa makamakii nonowina kuna panani.” ");
INSERT INTO pwg_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Ma ivi tarakiiyanei bo, “Meni sisiyisi bagibagisi kava?” Ma Yesu ivonapotei bo, “Ke kuna kiivunuwa, ke kuni pekana wapawapa, ke kuna yapi, ke kuni mamatara bero, ");
INSERT INTO pwg_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","am mamai da am maduwa kevopepetisi, ma ikikava tam mani kinuwaviina meyem, nakanani kwinam nuwanuwana keviiya.” ");
INSERT INTO pwg_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Ma yaragina ivonapotei bo, “Weni sisiyisi bagibagisi peyarina avovotekatekei. Ma aviyavisina ku tepana ata berai?” ");
INSERT INTO pwg_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Ma Yesu ivonei bo, “Viwawaya kiimatana kuna kayowei na kenae, am mura kudubina kevi gimarei ma manena na wawaya moyamoyakisi keveresi. Ma God mura makamakii nonowina kunumai ina verem. Tuna kuna berai, ma muriyai kuna pisi da kuna kiviniku.” ");
INSERT INTO pwg_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Ma yaragina weni sisiyina ivi yanei na ere nuwapoyina inae, iyamna tuna wawayina ina mura irakata kirakai. ");
INSERT INTO pwg_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Yesu kana kivikivina ivonesi bo, “Vonavaghata avonavonemi. Ipiropiro kirakai da mura wawayina God ina ku vikiivavona ina rui. ");
INSERT INTO pwg_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Avonavona meyemi, ipiropiro da kamel unubu bonaghinai itonagha, ma bade ipiropiro kirakai da mura wawayina God ina vikiivavona ku kamona ita rui.” ");
INSERT INTO pwg_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Kana kivikivina ina sisiya ivi yanei da inota kavakavai ma ivonei bo, “Nakanani na iyavo kava yawasa makamakii nonowina ina panani?” ");
INSERT INTO pwg_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Ma Yesu ikitakunukunusi ma ivonesi bo, “Aviyavisina ipiropiro kirakai da wawaya ke kovokovoghina ita berai na God kurina na itekateka kirakai.” ");
INSERT INTO pwg_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Ma Pita ivona bo, “Ma tokai na ikikava? Akii bera kudubina kavoterei da kakivikivinim.” ");
INSERT INTO pwg_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Ma Yesu ivonesi bo, “Vonavaghata avonavonemi, mara epipisi da taku Wawaya Natusi na kiivavo kana gawara kadakadarinai ana makai. Ma tuna maranai tami bade ami kiivavo gawarisi ivi 12 kona viiya da kona makiivipika ma Israel kii dam ivi 12 koni tupaviresi. ");
INSERT INTO pwg_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ma iyavo kava taku kubiiku i numa bo varevaresisi, novunovusi, i mamai, i maduwa, natunatusi bo i tano ikuyowesi na God vibiibiina ina veresi ma ku tepana ina vivikiitatanei. Ma bade yawasa makamakii nonowina ina veresi. ");
INSERT INTO pwg_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Ma wawaya viya wekarakava inao na karakava ini muri. Ma wawaya viya wekarakava imuri na ini nao.” ");
INSERT INTO pwg_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Yesu ivonesi bo, “God ina vikiivavona na weni nakanani. Mara sago boiboiyai na vao badana ina numa ikiibutawei inae da bigabiga ita viinisi da ina vao kamonai ita biga. ");
INSERT INTO pwg_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ivonesi da ita wayowa kupom na wawaya sago sago duma silva riririghina. ");
INSERT INTO pwg_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","“Madegha ighepaka ma vao badana mara viruwina ikiibau ma vigimagimara gawarinai ikita da tomotomowa viya ivivi miiriyana, i biga kegha. ");
INSERT INTO pwg_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Ma ivonesi bo, ‘Tami bade konae da aku vao kamonai kona biga ma ani miiya bubunimi.’ ");
INSERT INTO pwg_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Vaghina ma, tomotomowisi inae.” “Ma vao badana na madegha punai ma ravi madeghinai na bade berana sago iberai. ");
INSERT INTO pwg_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Ma raviyai ivovirame ku vigimagimara gawarina ma ikita da wawaya viya patana da ivivi miiriyana. Ma ivonesi bo, ‘Avi kubiine koimiiriwapeyana? Iyamna kegha.’” ");
INSERT INTO pwg_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","“Ma ivonapotei bo, ‘Ke sago wawaya ita kayowekai da kubiine kata biga.’” “Ma vao badana ivonesi bo, ‘Vaghina, tami bade konae da aku vao kamonai kona biga.’” ");
INSERT INTO pwg_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Madegha ita kamkovoghi ma vao badana ina vao kana koyakoyagha ivonei bo, ‘Bigabiga wawayisi kekwatusi da kuni miiyesi. Ma iyavo kava raviyai biga ivi karei na ini nao. Ma iyavo kava mara boiboiyai biga ivi karei, ti damsi na ini muri kuni miiyesi.’” ");
INSERT INTO pwg_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","“Wawaya raviyai biga ivi karei na sago sago duma silva riririghina sago ivi miiyesi, tuna nakanani ma biga ku pom miiyanina. ");
INSERT INTO pwg_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Vaghina ma, iyavo kava mara boiboiyai biga ivi karei ipisi da iti miiyesi na inotai da kii miiya ita rakata. Ma kegha, peyarisi kii miiya na silva riririghina sago. ");
INSERT INTO pwg_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","I miiya iyuna ma vigamowana ivi karei vao badana kurina. ");
INSERT INTO pwg_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Ivonei bo, ‘Nokoni damsi ivi muri ipisi ma tokai na biga ghamana kabera kupomei, madegha iraranikai. Ma kuberai da kii miiya ma kakii miiya na sago.’” ");
INSERT INTO pwg_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Ma vao badana i wawaya sago ivonapotei bo, ‘Aku tomo, ke ata bera beroi kurim. Kuvi vaghinei da silva riririghina sago kava ati miiyem. ");
INSERT INTO pwg_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Vaghina, am miiya kuviiya ikovi ma kenae. Aku kayowanai na tam ikikava avi miiyem na bade nakanani nokoni tomowina avi miiyei, tuna muriyai vaghata ipisi. ");
INSERT INTO pwg_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Aku rewapana emakamakai da taku mani aku mane na aku kayowanai ana berai. Ma aku agabiibai kubiine kunuwakapi bo?’” ");
INSERT INTO pwg_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Ma vaghina, Yesu ina sisiya turina ivonesi bo, “God ina vikiivavona kamonai iyavo kava karako inao na ini muri ma iyavo kava karako imuri na ini nao.” ");
INSERT INTO pwg_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Yesu ivomiiri igheghae ku Jerusalem ma kana kivikivina ivi 12 itinavivirisi ku ririna ma ivonesi bo, ");
INSERT INTO pwg_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Tagheghae ku Jerusalem na wawaya sago, taparoro babadisi i babada ma vonaviyoyovana vibeyebeyena wawayisi kurisi ini wawaneku da taku Wawaya Natusi, ini tupavireku ma ina vonakiiyaragha da ana rabobo. ");
INSERT INTO pwg_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Ina patumiku ma kupuna damsi ku imasi ina tereku da ini nameku ma ina widiku ma korosiyai ina tuparatuku da ana rabobo. Ma mara viarobina kamonai rabobowai ana vomiiri.” ");
INSERT INTO pwg_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Nani murinai Zebedi kawana, natunatuna Jemes ma Jon irutinisi inae Yesu kurina ma ivi tuwaporeruruwana da iti nowi. ");
INSERT INTO pwg_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Ma Yesu ivona bo, “Am kayowana avai?” Ma ivonapotei bo, “Aku kayowana da kuni vaghinei da maranai kuni kiivavo na natuku sago katagheyamuwai ma sago dugemuwai ina makai.” ");
INSERT INTO pwg_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Ma Yesu ivonapotesi bo, “Ke kotakovi da avi koisisiyei. Tami kovokovoghimi da aku redu kona karapotai, bo?” Ma ivi ruwa ivonapotei bo, “Tokai kovokovoghikai.” ");
INSERT INTO pwg_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Ma Yesu ivonesi bo, “Vonavaghata da aku reduwai konuma. Ma taku aku rewapana kegha da wawaya ata vinesi da iyai katagheyakuwai ma iyai dugekuwai ina makai. Nani gawarisi na aku Mamai ivovunaghi ikovi na kii wawaya namada ivinesi.” ");
INSERT INTO pwg_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Maranai Yesu kana kivikivina imaruwa ivi yanei da Jemes ma Jon nakanani ivi nowi na nuwanuwasi ipughu. ");
INSERT INTO pwg_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Tuna kubiine Yesu ikwatusi ipisi ma ivonesi bo, “Tami koakovi da meni kiikiivavosi ke iti tumaghana na ivi rewapana kirakai, ti na wawaya bagibagisi ma ekayokayotata kirakai. ");
INSERT INTO pwg_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Ma tami na ke nakanani kona berai. Iyavo kava kamomiyai ekayokayowei da ini wawayaghama na ina tereoruwe meyei da tuna na kudubimi ami bigabiga. ");
INSERT INTO pwg_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Ma iyavo kava ekayokayowei da ini nao na ini sleiv turaturana kubiisi. ");
INSERT INTO pwg_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Ma taku Wawaya Natusi bade nakanani, ke ata pisi ku dobu da wawaya vitaku ita kavari. Kegha, apisi da wawaya vitasi ata kavari. Ana suwara meyeku da wawaya kii tupi ani miiyei da berabero kamonai ana votawesi ina kiibau da yawasa ina panani.” ");
INSERT INTO pwg_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Yesu kana kivikivina yavata Jeriko kwanatuna ikiikiibukuyowei na koroto ghamana ikivinisi. ");
INSERT INTO pwg_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Ma tomotomowa ruwa matapotapotasi keta baranai imakamakai na ivi yanei da Yesu inenae ma ikiirara bo, “Bada, David Tupurereghina, kevi kamyuyuwekai.” ");
INSERT INTO pwg_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Ma wawaya nani korotona kamonai iyeghisi ma ivonesi da kawasi ita pota. Ma kegha, ighekiirara, ivona bo, “Bada, David Tupurereghina, kevi kamyuyuwekai.” ");
INSERT INTO pwg_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Yesu ivi kiimiiriyei ma ikwatusi ipisi ma ivonesi bo, “Aviyavisina kokayokayowei da ana berai kubiimi?” ");
INSERT INTO pwg_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ma ivonapotei bo, “Bada, kakayokayowei da kana kita.” ");
INSERT INTO pwg_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Ma Yesu ivi kamyuyuwesi ma matasi ivotovoni. Yaghiyaghinai ikitabanenega ma Yesu ikivini. ");
INSERT INTO pwg_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Yesu kana kivikivina yavata ibababa da gisina kava ita nekiibau ku Jerusalem. Ma ipisi ku Betipadi, Oliv koyanai. Ma kana kivikivina ruwa ivonatawesi da iti nao ");
INSERT INTO pwg_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","ma weni nakanani ivi varavarisi. “Konae da meyagai maghinotiyai donki iwarimi na ere natuna kona kitai. Uravina kotinarupami ma korutinapiyesi wike kuriku. ");
INSERT INTO pwg_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Mikeda wawaya ikikava ina vonavonemi na kovonei bo, ‘Bada ekayokayowei.’ Ma yaghiyaghinai ini vaghinei da kona rutinisi.” ");
INSERT INTO pwg_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Yesu weni nakanani iberai da aviyavisina peroveta igirumi da ita tupuwa na itupuwa. Igiruma bo, ");
INSERT INTO pwg_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Zayon wawayimi, Kokitai, ami kiivavo epipisi kurimi, Itereoruwe meyei da donki votuna ku tepana igeru, Donki tepanai igeru ma epipisi.” ");
INSERT INTO pwg_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Vaghina ma, kana kivikivina ruwa inae ma aviyavisina ivonesi na iberai. ");
INSERT INTO pwg_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Donki irutinipiyesi ma kii tarasovo natuna tepanai ikepani ma Yesu igeru. ");
INSERT INTO pwg_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Ma koroto ghamana kii tarasovo ketiyai ikepana ma wawaya viya kii ragharaghasi ketiyai itawetawei. ");
INSERT INTO pwg_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Ma nani korotona kamosiyai Yesu inenae. Ma wawaya ibababa na ikarakarayogosi. “Hosana! Kaigheghenim! Tam David Tupurereghina, kavovokavakavarim! God ini biibiinim, tam Bada avanai kepipisi! Hosana, God, kiidamo makamakiim, kaigheghenim!” ");
INSERT INTO pwg_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Yesu irui na wawaya kudubisi Jerusalem kamonai ivi tataghanisi da ivi tarakiiyana bo, “Mede wawaya iyai?” ");
INSERT INTO pwg_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Ma nani korotona ivonapotesi bo, “Weni tuna na peroveta Yesu, ina kwanatu Nasaret, Gariri dobunai.” ");
INSERT INTO pwg_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Yesu Taparoro Numana garina ku kamona irui da iyavo kava ivivi gimagimara na peyarisi ikwavinisi ikiibau. Ma iyavo kava mane ivivi vovivirana na i kemakema ivi kuvirei. Ma iyavo kava gabubu ivivi gimagimara na i ipumakamakai ma kemakema ivi kutabirana. ");
INSERT INTO pwg_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ma ivonesi bo, “Giruma katamana kamonai evonavona bo, ‘Aku numa na nipowana numana.’ Ma tami, koberaberai da yapiyapi damsi i numa.” ");
INSERT INTO pwg_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Matapotapotasi ma digadigasi Yesu kurina ipisi da ivi yawasisi Taparoro Numana garina kamonai. ");
INSERT INTO pwg_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Ma taparoro babadisi i babada ma vonaviyoyovana vibeyebeyena wawayisi weni berasi ghamaghamasi ikitai ma bade ivi yanei da ededa yoghoyogho ivivi kiirareyana bo, “Hosana kurim, tam David Tupurereghina, kavovokavakavarim.” Tuna kubiine nuwanuwasi ipughu, ");
INSERT INTO pwg_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","ma ivonei bo, “Kiyanei da ededa yoghoyogho aviyavisina evonavonei?” Ma Yesu ivonapotesi bo, “E, aiyanesi. Giruma katamana kovi yavi bo kegha? Ivona bo, ‘God, tam ededa ma gegeya kuvi beyebeyesi da vigheghena biibiina ita berai.’” ");
INSERT INTO pwg_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Ma Yesu ivoteresi ma kwanatu ikiibutawei inae ku Betani kwanatuna, ma nani dobunai ikena. ");
INSERT INTO pwg_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Mara boiboiyai Yesu ivovovirame ku Jerusalem ma vitonara ikarai. ");
INSERT INTO pwg_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ma koweya kiina sago imiimiiri keta baranai ma inae ita kitai da amena bo kegha. Ma ipanani da ke sago amena ita makamakai, ruguruguna kava na ivona bo, “Kawakuwai aimimagim da ke meyani kuname!” Ma yaghiyaghinai ruguruguna isivi da kiina ipoki. ");
INSERT INTO pwg_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Kana kivikivina ikitai ma ivi deye kirakiiyei da ivona bo, “Te! Ikikava da kiina yaghiyaghinai ipoki?” ");
INSERT INTO pwg_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Ma Yesu ivonapotesi bo, “Vonavaghata avonavonemi, koni tumaghana ma ke ami nota ina peku na aviyavisina weni kiina kurina aberai na kovokovoghina da nakanani kona berai. Ma ke tuna kava, bade weni koyana kota vonei bo, ‘Kevomiiri, ma ketawem ku yegai’ na ita tupuwa. ");
INSERT INTO pwg_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","God koni tumaghanei ma kona nipowana na ina veremi.” ");
INSERT INTO pwg_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Yesu ivovira ku Taparoro Numana da wawaya ivivi beyebeyesi. Ma taparoro babadisi i babada ma Jiu damsi i babada ipisi kurina ma ivi tarakiiyanei bo, “Iyi ivi vaghinei da weni berasi keberaberai? Iyi rewapana iverem?” ");
INSERT INTO pwg_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Ma Yesu ivonapotesi bo, “Taku bade ati tarakiiyanemi. Kona vonapoteku na bade taku ana vonemi da aku rewapana imapatana aviiya. Ke kona vonapoteku na bade ke ana vonapotemi. ");
INSERT INTO pwg_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Kovona, Jon ina rewapana imapatana iviiya da ibabataito? God gwabinai iviiya bo wawayota gwabisiyai?” Ivi karei da ti mani kamosiyai ivivi sisiya bo, “Ikikava tavonapotei? Mikeda tavona bo, ‘God gwabinai’ na ina voneta bo, ‘Ma avi kubiine Jon ke koti tumaghanei?’ ");
INSERT INTO pwg_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ma mikeda tavona bo, ‘Wawaya gwabisiyai’ na tayabuyabumana da weni korotona ina ravita, iyamna ti na itumaghana da Jon na God ina peroveta.” ");
INSERT INTO pwg_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Tuna kubiine ivonapotei bo, “Ke katakovi.” Ma Yesu ivonesi bo, “Nakanani na bade ke ana vonemi da iyai ina rewapanai weni berasi aberaberai.” ");
INSERT INTO pwg_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Yesu, taparoro babadisi i babada ma Jiu damsi i babada ivonesi bo, “Miiba sago ana vonemi na kovi nuwanotanotei. Tomowa natunatuna ruwa yavata imakamakai. Ma iyarokona ivonei bo, ‘Natuku, karako kuna nae vao kamonai kuna wayowa.’ ");
INSERT INTO pwg_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Ma ivonapotei bo, ‘Abara.’ Ma muriyai ina nota ivirai ma inae da iwayowa. ");
INSERT INTO pwg_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Ma natuna murimurina kurina inae ma sisiyina sago ivonei. Ma murimurina ivonapotei bo, ‘Vaghina, mamai, ana nae.’ Ma ke ita nae.” ");
INSERT INTO pwg_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Ma Yesu ivonesi bo, “Ikikava konotanotai? Tomowa natunatuna ivi ruwa na meni tuna ina mamai ina kayowana iberai?” Ma ivonapotei bo, “Iyarokona.” Ma Yesu ivonesi bo, “Vonavaghata avonavonemi, teks yuyuna damsi ma wivine madamadawarisi ina rui God ina ku vikiivavona, ma tami na kegha, ");
INSERT INTO pwg_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","iyamna Jon Babataito ipisi kurimi na yawasa maninina ketana ivi beyebeyemi ma ke koti tumaghana. Ma teks yuyuna damsi ma wivine madamadawarisi, ti na ivi tumaghana. Ma tami na kokitisi da ikikava i berabero imiimiirikupukuputei ma patana da ke koti tumaghana ma bade ami bera beroberosi ke koti nuwapoyei da kota miirikupukuputei.” ");
INSERT INTO pwg_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Yesu, taparoro babadisi i babada ma Jiu damsi i babada ivonesi bo, “Kovi yana. Miiba sago. Tomowa greipi ivoni ina vao kamonai, wakimiyai igariya, ma mewa iyabai da greipi amena nani gawarinai iti tugudagudai da muina kava ita viiya. Ma numa kweta kiidamowai ivowai da potapota wawayisi ita makai da vao ita koyaghi. Ma wawaya viya yavata vivaghina iberai da vao ku imasi iterei da ita koyakoyaghi ma madegha nununai ita vivimiiyei. Muriyai tomowina inumataya ku dobu sago da nani dobunai imakii kirakai. ");
INSERT INTO pwg_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Ma greipi imenai da purana kana mara ipisi ma vao badana ina bigabiga ivonatawesi vao kana koyakoyagha kurisi da kana reregha ita viiya. ");
INSERT INTO pwg_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Ma koyakoyagha ivomiiri da bigabiga sago ivowai, sago ikiivunui ma sago wakimiyai iravi. ");
INSERT INTO pwg_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Ma bade ina bigabiga viya ivonatawesi ma ti na koroto ghamana, ma koyakoyagha damsi berana sago iberai kurisi. ");
INSERT INTO pwg_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Ma turina na natuna vaghata ivonatawei. Inotanotai da natuna ita vokaravei. ");
INSERT INTO pwg_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Ma koyakoyagha damsi natuna ikitai ipipisi na ti mani kavakava ivi ogatara ma ivona bo, ‘Wena vao badana natuna. Kopisi ma takiivunui ma mara sago vao badana ina rabobo na weni vao na tirapenei.’ ");
INSERT INTO pwg_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Vaghina ma, ivotatani ma itawanakiibuwei ku gari kupuna ma ikiivunui.” ");
INSERT INTO pwg_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Ma Yesu taparoro babadisi i babada ivi tarakiiyanesi bo, “Vao badana ina pisi na aviyavisina ina berai vao kana koyakoyagha kurisi?” ");
INSERT INTO pwg_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Ma ivonapotei bo, “Nani wawayisi beroberosi ini kiivunuwana tawetaweyana ma wawaya vusi ina vinesi da vao ina koyaghi. Ma pura kana mara ina pisi na koyakoyagha vusi vivaghina ina nunura bubuni da vao badana kana reregha ina verei.” ");
INSERT INTO pwg_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Ma Yesu ivi tarakiiyanesi bo, “Giruma katamana kovi yavi bo kegha? Ivona bo, ‘Vonura damsi wakima ibarei. Ma Bada nani wakimina iviiya ma iterei da tepanai numa vuna ivowai. Weni berana Bada iberai na ibiibii kirakai kurita.’” ");
INSERT INTO pwg_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Tuna kubiine avonavonemi da God ina vikiivavona gwabimiyai ina viitawei ma dam sago ina verei, da ti na God ina kayowana kava ina berai. Ti nakanani ma kii biibiina amena biibiisi kavakava ina terei.” ");
INSERT INTO pwg_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","(-) ");
INSERT INTO pwg_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Taparoro babadisi i babada ma Perisi damsi Yesu ina miiba ivi yanei na iakovi da ti ivivi sisiyesi. ");
INSERT INTO pwg_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","I kayowana da Yesu ita paniya ma koroto iyabumanesi kubiine na ivoterei, iyamna nani korotona inotanotai da Yesu na God ina peroveta. ");
INSERT INTO pwg_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Yesu miibiiyai ivi sisiyame. Taparoro babadisi i babada ma Jiu damsi i babada ivonesi bo, ");
INSERT INTO pwg_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“God ina vikiivavona na weni nakanani. Kiivavo sago natuna ina tavine kubiine na ivovovunagha da ita kamporagha. ");
INSERT INTO pwg_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Ivovunagha ikovi na ina bigabiga ivonatawesi ikiibau iti yonayona da ina wawaya ghamaghamasi ita pisi. Ma kegha, ivi bareyana. ");
INSERT INTO pwg_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Ma bade ina bigabiga viya ivonatawesi, ivonesi bo, ‘Konae, da aku wawaya vovinesi kona vonesi da namada avovunagha, kata siya monamonana arighai ma vavai yavata avi tava ikovi. Kopisi da takam.’ ");
INSERT INTO pwg_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Ma kegha, ina wawaya vovinesi nani kamna ibarei, i kayowana iberai. Sago inae ina ku vao, ma sago inae da iti gimagimara. ");
INSERT INTO pwg_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Ma wawaya vovinesi viya na kiivavo ina bigabiga ivotanisi ma iravisi ma bade ina bigabiga viya na ivi kiivunuwana. ");
INSERT INTO pwg_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Ma kiivavo nuwanuwana ipughu kirakai ma ina seri wawayisi ivonatawesi inae da kiivunuwa damsi ivi kiivunuwana ma i kwanatu ikapuni. ");
INSERT INTO pwg_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Muriyai ina bigabiga ikwatusi ma ivonesi bo, ‘Tavine kamna avovunaghi ikovi. Ma wawayisi akayokayowesi na ke wawaya kiimatanisi da yavata kata kam, tuna kubiine abaresi. ");
INSERT INTO pwg_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Ma wekarakava na kokiibau da wawaya ketiyai kona panapananisi na kovonesi da ina pisi weni ku kamna.’ ");
INSERT INTO pwg_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Vaghina ma, ina bigabiga ikiibau ku keta da wawaya wapawapa irutinisi, biibiisi ma beroberosi yavata irui da kam gawarina ivi tupoi.” ");
INSERT INTO pwg_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Ma kiivavo irui da kana numataya iti kiikiiwesi. Ma tomowa sago ikitai da gara berona ikotei. ");
INSERT INTO pwg_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Ma ivonei bo, ‘Aku tomo, tam ke gara biibiina kuta kotei. Avi kubiine kurui?’ Ma tomowina ke sago ita vonapotei. ");
INSERT INTO pwg_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Ma kiivavo ina bigabiga ivonesi bo, ‘Imana ma kaena kokuni, kotawanakiibuwei ku nubakutuva. Wawaya nani dobunai ina vivitutuwana ma okesi ina vivitarakikitei.’” ");
INSERT INTO pwg_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Ma Yesu ivonesi bo, “God wawaya peyarisi ekwatukwatusi ma voviyavina kava ina kwatu iyanei na evinevinesi da erurui.” ");
INSERT INTO pwg_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Perisi damsi viya inae ma ivi ogatara da Yesu ku poko ita terei, iti sisiya bero na iti wavui. ");
INSERT INTO pwg_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Ma Perisi damsi kii kivikivina ma Kiivavo Herodi turaturana ivonatawesi Yesu kurina da ivonei bo, “Bada, kakovi da tam wawaya kiimatanim ma mara nonowa kevonavona vaghata. Am vibeyebeyena kamonai wawaya kevonavonesi da God ina keta maninina ita kivini. Wawaya ke kuta vivinimayesi ma kevonavonatepanisi da nuwanuwasi epughupughu kurim ma kegha da tam vonavaghata kidebei. Ma tam kurim wawaya ghamaghamasi ma wawayota keberaberisi da peyarisi na sago. ");
INSERT INTO pwg_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Ma ikikava kenotanotai? Kevonekai da vaghina bo kegha da Rome ina Kiivavo Sisa kurina teks timiiyei?” ");
INSERT INTO pwg_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Ma Yesu iakovi da nota beroberosiyai ivivi kaetina na ivonesi bo, “Tami miiriruwaruwami. Avi kubiine koiberoberoweku da ati sisiya bero? ");
INSERT INTO pwg_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Teks kana ruva mane riririghina sago kovi beyeku da takitai.” Vaghina ma, mane sago iverei, ");
INSERT INTO pwg_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","ma Yesu ivi tarakiiyanesi bo, “Iyi maghighina ma kana vava weni?” ");
INSERT INTO pwg_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Ma damsi ivonapotei bo, “Rome ina Kiivavo Sisa.” Ma Yesu ivonesi bo, “Vaghina, aviyavisina Sisa rapenai na Sisa koverei. Ma aviyavisina God rapenai na God koverei.” ");
INSERT INTO pwg_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Weni sisiyina ivi yanei ma ivi deye kirakiiyei da Yesu ina nota ighekuyowesi. Ma vaghina, Yesu ivoterei ma inae. ");
INSERT INTO pwg_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Nani maranai Sadusi damsi viya ipisi Yesu kurina. Ti na inotanotai da wawaya ina rabobo na ke meyani ina vomiiri. Ma Yesu ivi tarakiiyanei bo, ");
INSERT INTO pwg_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Bada, Moses weni nakanani igiruma. ‘Tomowa sago ina tavine ma ina rabobo ma kawana yavata natunatusi kegha na varesina sago kwapurina ina ravaghi da ini tuwa. Ma nani ededisi na tomowina raborabobona natunatuna. ");
INSERT INTO pwg_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Ma kevi yana. Kamokiiyai na rakaraka sago kamonai na tomotomowa miikovimaruwa. Iyarokona itavine ma irabobo ma natunatusi kegha. Ma kana teretana kwapurina iravaghi ");
INSERT INTO pwg_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","da bade ke iti tuwa ma tomowina irabobo. Ma kana viaroba bade nakanani. Ma vaghina, miikovimaruwa nani kwapurina iravaghi da peyarisi irukwa. ");
INSERT INTO pwg_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Turina vaghata na kwapurina irabobo. ");
INSERT INTO pwg_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Kevonekai, mara damonai raborabobosi ina vomiiri na wavinena na iyi kawana, iyamna wavinena sago ma tomotomowa miikovimaruwa iravaghisi.’” ");
INSERT INTO pwg_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Ma Yesu ivonapotesi bo, “Tami neghaneghami, iyamna giruma katamana ma God ina rewapana ke kotakovi. ");
INSERT INTO pwg_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Maranai raborabobosi ina vomiiri, ti na God ina aneya nakanani da ke ina tavine. ");
INSERT INTO pwg_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Ma wekarakava ani debei kurimi da raborabobosi ina vomiiri. Giruma katamana kovi yavi da kotakovi. Ivona bo, ");
INSERT INTO pwg_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Taku na Abraham, Aisiki ma Jeikap i God.’ God na wawaya yawayawasisi i God, ke raborabobosi i God.” ");
INSERT INTO pwg_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Ma koroto ghamana weni vibeyebeyena ivi yanei na ivi deye kirakiiyei. ");
INSERT INTO pwg_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Perisi damsi sisiya ivi yanei da Yesu, Sadusi damsi i keta peyarina igudui na ivi ogatarame da nota vuna ita panani da iti wavui. ");
INSERT INTO pwg_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Ma vonaviyoyovana vibeyebeyena wawayina sago inae Yesu kurina da iti kaetina. Ivi tarakiiyanei bo, ");
INSERT INTO pwg_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Vibeyebeyena wawayim, Moses ina vonaviyoyovana kamonai na meni sisiyina bagibagina ighe kirakai?” ");
INSERT INTO pwg_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Ma ivonapotei bo, “‘Nuwanuwami kudubinai, kanumimi kudubinai ma ami nota kudubinai ami Bada God nuwanuwana kona viiya.’ ");
INSERT INTO pwg_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Weni tuna na sisiya bagibagisi peyarina ighekuyowei ma iyamna irakata kirakai. ");
INSERT INTO pwg_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ma kana viruwa na weni, ‘Ikikava tam mani kinuwaviina meyem, nakanani kwinam nuwanuwana keviiya.’ ");
INSERT INTO pwg_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Moses ina vonaviyoyovana ma peroperoveta i vibeyebeyena kudubina na weni ivi ruwa tepanai iututukikita.” ");
INSERT INTO pwg_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Perisi damsi ivi kiidaburana na Yesu ivi tarakiiyanesi bo, ");
INSERT INTO pwg_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Ikikava konotanotai? God ina Vivinevine Wawayina na iyi tupurereghina?” Ma ivonapotei bo, “Kiivavo David tupurereghina.” ");
INSERT INTO pwg_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Ma Yesu ivi tarakiiyanesi bo, “Avi kubiine Kiivavo David, Kanuma Vovokaravina ina rewapanai ivona da God ina Vivinevine Wawayina na ina Bada? Igiruma bo, ");
INSERT INTO pwg_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Bada God, aku Bada kurina ivona bo, Katagheyakuwai kuna makamakai da kam ghavighaviya kudubina ku kae gaburim ana teresi.’” ");
INSERT INTO pwg_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","“Takovi da David ivona da God ina Vivinevine Wawayina na ina Bada. Ma kegha da David na mara katamaninai itupuwa, ma God ina Vivinevine Wawayina na murinai, tuna na David tupurereghina. Tuna kubiine God ina Vivinevine Wawayina David ita vopepetei ma kegha, David, God ina Vivinevine Wawayina ivopepetei. Ikikava na nakanani?” ");
INSERT INTO pwg_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Perisi damsi ke kovokovoghisi da Yesu ita vonapotei. Nani murinai ke sago iyi ita bera tovoni da iti tarakiiyana. ");
INSERT INTO pwg_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Nani murinai Yesu na kana kivikivina ma koroto kurisi ivi sisiya. ");
INSERT INTO pwg_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","Ivona bo, “Vonaviyoyovana vibeyebeyena wawayisi ma Perisi damsi rewapana iviini da Moses ina vonaviyoyovana ita vonaveremi. ");
INSERT INTO pwg_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Tuna kubiine i vibeyebeyena kona votekatekei. Ma i bera ke koni bonebonei, iyamna ti mani i vibeyebeyena ke ita kivikivini. ");
INSERT INTO pwg_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Ma ti mani i vibeyebeyena viya vonaviyoyovana ku tepana etereterei na ibagibagi kirakai da wawaya ina kivini. Ma nani vitasi wawaya ikavarisi na ke meyani ini kamyuyuwesi da ini vitesi. ");
INSERT INTO pwg_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Ma bade i bera peyarina debiiyai eberaberai da wawaya ita kitisi ma iti gheghenisi. Kii kuyaragha ma kii imakwasi ghamaghamasi ma tepasiyai Moses ina sisiya igirumi ma ivovikarapasipasi. Kokitai, irakarakateyana ghagha! Ma bade kii tarasovo ikote na ararusi gurigurisi. ");
INSERT INTO pwg_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Ma i kayowana da kamporagha kamonai ma kiki numasiyai na babada kii gawariyai ina makai. ");
INSERT INTO pwg_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Ma bade i kayowana ghamana da vigimagimara gawarisiyai wawaya ina runomesi ma ini kiikiiwesi ma ina vonesi bo, ‘Bada.’ ");
INSERT INTO pwg_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Ma tami vitumaghana wawayimi peyarimi na sago, ke sago ita ghae bo sago itoru. Tuna kubiine ke koni vaghinei da wawaya ina kwatumi bo ‘Bada’ iyamna ami Bada na sago kava. ");
INSERT INTO pwg_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ma wawaya dobuwai ke kona kwatui bo ‘Mamai’ iyamna ami Mamai na sago kava ma tuna kunumai. ");
INSERT INTO pwg_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Ma bade ke koni vaghinei da wawaya ina kwatumi bo, ‘Aku vibeyebeyena wawayim’ iyamna ami vibeyebeyena wawayina na sago kava ma tuna na God ina Vivinevine Wawayina. ");
INSERT INTO pwg_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ma wawaya ghamakirakiina kamomiyai na ami bigabiga wawayina. ");
INSERT INTO pwg_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Iyavo kava ina terepa meyesi na God ina tereoruwesi. Ma iyavo kava ina tereoruwe meyesi na God ina terepiisi.” ");
INSERT INTO pwg_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Tami vonaviyoyovana vibeyebeyena wawayimi ma Perisi dami, koti nuwapoya kirakai! Miiriruwaruwami! God ina vikiivavona ketana kogudugudui, iyamna ke ami kayowana da kota rui. Ma wawaya komiimiiripotesi da ti bade ke ina rui.” ");
INSERT INTO pwg_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","(-) ");
INSERT INTO pwg_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Tami vonaviyoyovana vibeyebeyena wawayimi ma Perisi dami, koti nuwapoya kirakai! Miiriruwaruwami! Yegiiyai ma dobuwai konumanumataya da wawaya koekwekwisi. Koipaparana kirakai da wawaya kona tinavurei da ikikava koitumaghana nakanani ini tumaghana. Ma maranai wawaya sago ami vibeyebeyena ini tumaghanei na ina berabero ini ruwai da kana kovogha keyama karakaratina kamonai ina rakata kirakai.” ");
INSERT INTO pwg_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Koti nuwapoya kirakai! Konotanotai da wawaya koti noravesi ma matami isowa yavui. Ami vibeyebeyena kamonai wawaya kovonavonesi bo, ‘Iyi Taparoro Numana vavanai vonakiiyapa bagibagina ina terei na iyamna kegha, kovokovoghina da ini kiigiiyei.’ Ma wawaya kovonavonesi bo, ‘Iyi Taparoro Numana kana gold vavanai vonakiiyapa bagibagina ina terei, tuna na bera vaghata, vonakiiyapa ina kivini.’ ");
INSERT INTO pwg_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Tami neghaneghami! Matapotapotami! Meni tuna iyamna irakata, gold bo Taparoro Numana? Taparoro Numana iyamna irakata. Ma kegha da wawaya gold esuwasuwara na Taparoro Numana kamonai, suwara kana kema tepanai etereterei, tuna kubiine nani gold na vovokaravina. ");
INSERT INTO pwg_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Ma bade kovonavonesi bo, ‘Iyi suwara kana kema vavanai vonakiiyapa bagibagina ina terei na iyamna kegha, kovokovoghina da ini kiigiiyei.’ Ma wawaya kovonavonesi bo, ‘Iyi ina suwara vavanai vonakiiyapa bagibagina ina terei, tuna na bera vaghata, vonakiiyapa ina kivini.’ ");
INSERT INTO pwg_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Matapotapotami! Meni tuna iyamna irakata, suwara bo suwara kana kema? Suwara kana kema iyamna irakata. Wawaya esuwasuwara na suwara kana kema tepanai etereterei, tuna kubiine nani suwarina na vovokaravina. ");
INSERT INTO pwg_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Tuna kubiine iyavo kava suwara kana kema vavanai vonakiiyapa bagibagina ina terei na ke kemana vavanai kava, ma bera kudubina kemana tepanai na yavata. ");
INSERT INTO pwg_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Ma iyavo kava Taparoro Numana vavanai vonakiiyapa bagibagina ina terei na ke Taparoro Numana vavanai kava, ma God yavata. ");
INSERT INTO pwg_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ma wawaya kunuma vavanai vonakiiyapa bagibagina ina terei na ke kunuma vavanai kava, ma God ma ina vikiivavo gawarina yavata ina kamowani.” ");
INSERT INTO pwg_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Tami vonaviyoyovana vibeyebeyena wawayimi ma Perisi dami, koti nuwapoya kirakai! Miiriruwaruwami! Bera gisigisisi konununura bogai, ma avi kubiine bera ghamaghamasi ke kota beraberai? Wawaya koti kamyuyuwesi ma bera maninisi kava kota berai kurisi, ma God kurina koti patutu. Ma nani berasi ke kota beraberai. Ami kayowana da bera gisigisisi kona bera bogai, vavai kii vovoghabughabu korereregha da riba imaruwa ma riba sago God kurina kosuwasuwara. Nakanani koberaberai na vaghina, ma kegha da ku tepana bera ghamaghamasi yavata kota berai. ");
INSERT INTO pwg_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Konotanotai da wawaya koti noravesi ma kegha matami isowa yavui. Avi kubiine nasinasi gisi korekorena kami okowa kamonai na kona taratawei ma muriyai konumai? Ma sawara ghamanakina nakanani ma kamel ruvana na kudubina kona runamiya.” ");
INSERT INTO pwg_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Tami vonaviyoyovana vibeyebeyena wawayimi ma Perisi dami, koti nuwapoya kirakai! Miiriruwaruwami! Ami redu ma dabira kupusi kotepotepokowakowa, ma kamosiyai na idadabu kirakai iyamna kawakiikai ma nota meyena nuwanuwami ivi tupoi. ");
INSERT INTO pwg_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Tami Perisi dami matami isowai! Kunona ami redu ma ami dabira kamosi kota kowai ma muriyai da kupuna kota kowai.” ");
INSERT INTO pwg_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Tami vonaviyoyovana vibeyebeyena wawayimi ma Perisi dami, koti nuwapoya kirakai! Miiriruwaruwami! Tami nakanani ma dogo karawaga kamonai, wawaya wakima poipoisi igwagwara da tepanai kitana biibiina ma kamonai na wawaya tuwirisi ma viyosi bowabowasi. ");
INSERT INTO pwg_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Ma bade ana vona meyemi, koberaberai da wawaya ina kitimi ma ina vona da tami God ina wawaya maninimi. Ma kegha, nuwanuwami kamosiyai na notaruwaruwami ma berabero itupo.” ");
INSERT INTO pwg_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Tami vonaviyoyovana vibeyebeyena wawayimi ma Perisi dami, koti nuwapoya kirakai! Miiriruwaruwami! Peroperoveta kii dogo gawarisi tepasiyai na matakira numasi kovowavowa ma bade wawaya kiikiimatanisi kii dogo gawarisi na koimonagha bogai. Ma tami mani ami kaekiki mau nani wawayisi ivi kiivunuwana. ");
INSERT INTO pwg_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Ma kovonavona bo, ‘Rorova mara katamaninai akii kaekiki mau yavata kata makamakai na ke kati vitesi da peroperoveta kati kiivunuwana.’ ");
INSERT INTO pwg_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Vona bubuna, wekarakava koimamatara meyemi da tami mani ami kaekiki mau peroperoveta ivi kiivunuwana. ");
INSERT INTO pwg_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Vaghina, ami kaekiki mau aviyavisina ivi karei na tami koni kovini. ");
INSERT INTO pwg_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Tami mota! Tami na mota natunatusi! God ini tupavireviremi ma ku keyama karata makamakii nonowina ina tawemi! Ke kovokovoghina kona veruvuvurei! ");
INSERT INTO pwg_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Avonavonemi da peroperoveta, nuwagiura wawayisi ma vibeyebeyena wawayisi ana vonatawesi kurimi. Ma viya kona kwavinisi kwanatu nunusiyai, ma viya koni kiivunuwana, ma viya kona tuparatusi ma viya ami kiki numasi kamosiyai kona widisi. ");
INSERT INTO pwg_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Tuna kubiine ami kaekiki mau i berabero na tami weni kimtina wavuna kona kavari. Ti na God ina wawaya manininisi mara katamaninai ivi kiivunuwana da tarasi isororo. Abel ina rabobowai da ipisi Barakiya natuna Zekaraya ina ku rabobo, tuna na Taparoro Numana garina kamonai kokiivunui da Taparoro Numana ma suwara kana kema basunai irabobo. ");
INSERT INTO pwg_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Vonavaghata avonavonemi, weni rabobosi rorova mara katamaninai itupuwa na wavuna weni kimtina kona viiya.” ");
INSERT INTO pwg_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“O, Jerusalem, Jerusalem! Tami peroperoveta koikiivunuwana ma God ina yonayona wawayisi wakimiyai koraravisi da koirabobosi. Mara nonowa akayokayowei da natunatumi ata koyagha bubunisi ma ke ami kayowana. Ikikava kokoreko wavinena mapemapenai natunatuna eragoragobisi, nakanani ata taraghavumi ma kegha, kobabareku! ");
INSERT INTO pwg_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Ma kovi yana, God ami Taparoro Numana ivoterei da ibubu. ");
INSERT INTO pwg_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Vonavaghata avonavonemi, ke kona kita meyeku, karako da ku mara damona. Ma nani maranai ana vovira ma kona vona bo, ‘God ini biibiinim, tam Bada avanai kepipisi! Kiiwa, kiiwa!’” ");
INSERT INTO pwg_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Yesu ivomiiri da Taparoro Numana garina ikiikiibutawei ma kana kivikivina ipisi kurina da Taparoro Numana ma numa viya nani garina kamonai ivivi deyei na ivivi sisiyei kurina. ");
INSERT INTO pwg_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Ma Yesu ivonesi bo, “Weni Taparoro Numana kokitakitai ma koideyei, bo? Vonavaghata avonavonemi, mara epipisi da peyarina ina kuririghi inoru ku tano, ke wakima sago kana gawariyai ina makai.” ");
INSERT INTO pwg_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Yesu Oliv koyana baranai imakamakai ma kana kivikivina inae kurina da ti mani kavakava ma ivi tarakiiyanei bo, “Kevonekai, weni berasi kisisiyei na avi maranai ina tupuwa? Ma avi ini matakira da kanakovi da gisina kava ma kuna vovira ma bade mara damona?” ");
INSERT INTO pwg_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Ma ivonapotesi bo, “Kokitaruvimi da wawaya ke ini beroberowemi. ");
INSERT INTO pwg_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Wawaya ipeyari ina pisi ma ina vonemi da taku avonatawesi. Ma ina vonemi bo, ‘Taku God ina Vivinevine Wawayina!’ Wawaya peyarisi ini yanesi ma ini tumaghanesi. ");
INSERT INTO pwg_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Sisiya koni yanei da wawaya rabarabai ighaviya, bo sisiya kona viiya da ghaviya epipisi na ke kona yabumana. Weni berasi ini nao ma ke kona notai da mara damona. Kegha, karakava. ");
INSERT INTO pwg_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Dam ina vomiiri da dam sago kana ghaviya. Ma kiivavo ina vomiiri da kiivavo sago kana ghaviya. Ma dobu bogii ma bogiiyai kamosiyai nukenuke bo gomara ina tupuwa. ");
INSERT INTO pwg_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Weni berasi na nakanani ma wavine vituwa kubiine ita dagui da ita vivivowavowa.” ");
INSERT INTO pwg_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Nani maranai wawaya ina patumimi, ini tupaketowanemi ma ini rabobomi. Taku kubiiku na dam kudubina dobuwai ina baremi. ");
INSERT INTO pwg_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Wawaya peyarisi i vitumaghana ina voterei. Ma turaturasi ini wawanesi ma ini makiiberowana. ");
INSERT INTO pwg_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Ma peroperoveta viviberosi ipeyari ina nekiibau ma wawaya ini noweberosi. ");
INSERT INTO pwg_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Berabero ma kawakiikai ina rakata da dobu ina kiimumui, ma wawaya i nuwaviina ini beroi. ");
INSERT INTO pwg_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Ma iyavo kava ina miirikikina da ku damona na God ini yawasisi. ");
INSERT INTO pwg_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Wawaya God ina vikiivavona varana biibiina ina dimei dam ma dam kurisi. Ma vonavaghata ini mamatarei da dobu kudubina akovina ina viiya. Ma nani murinai na mara damona ina nekiibau.” ");
INSERT INTO pwg_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Aviyavisina peroveta Daniyera igirumi da ina tupuwa na kona kitai. ‘Sawara Bero Kirakiina’ Taparoro Numana kamonai God kana gawara ina viiya da gawarina vovokaravina ina puyaki.” (Viyava wawayimi akova kovii bubuni.) ");
INSERT INTO pwg_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","“Nani sawarina bero kirakiina kona kitakitai na iyavo kava Judiya kamonai na yaghiyaghinai ku koya koverau. ");
INSERT INTO pwg_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Ma iyai matarai kemakamakai na ke kuna rui ku numa kamona da am sawara kuna yuna. ");
INSERT INTO pwg_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ma iyai vao kamonai na ke kuna vovira ku numa da kam gara kuna yuna. ");
INSERT INTO pwg_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Nani maranai wivine roperopeyisi ma vivi sususi na ini kamyuyuwa kirakai. ");
INSERT INTO pwg_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Konipowana kirakai God kurina da weni marana berona ke bodu kamonai bo viyakam maranai ina tupuwa. ");
INSERT INTO pwg_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Dobu karenai da karako weni ku marana na wawaya vokwarakwara damina eviiviiya ma ke ita rakata kirakai. Ma weni marana aisisiyei na nuwapoya ma vokwarakwara na ina rakata ma ina bero kirakai. Ma murinai ke vokwarakwara nakanani tapanana meyei. ");
INSERT INTO pwg_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Nani marana berona ita guri na wawaya kudubisi ita rabobo yavu. Tuna kubiine God ina wawaya vovinesi notasiyai na vokwarakwara marana ina terevitupoi.” ");
INSERT INTO pwg_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Nani maranai wawaya ina vonemi bo, ‘Kokitai, God ina Vivinevine Wawayina na weni’ bo ‘God ina Vivinevine Wawayina nokoni’ na ke koni tumaghanesi. ");
INSERT INTO pwg_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Wawaya ipeyari ini bero, ina vonemi da ti na God ina Vivinevine Wawayina ma peroperoveta viviberosi yavata ina vomiiri da bera ghamaghamasi ma matakira notakavakavasi ina berai da wawayota ini beroberowesi. Ma ini paparana da God ina wawaya vovinesi yavata bade ini beroberowesi da i vitumaghana ina voterei. ");
INSERT INTO pwg_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Vaghina, namada avonaveremi ikovi, ");
INSERT INTO pwg_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","tuna kubiine maranai wawaya ina vonemi bo, ‘Kovi yana, God ina Vivinevine Wawayina warereyai’ na ke kona kiibau nake. Bo ina vonemi bo, ‘Kovi yana, God ina Vivinevine Wawayina numa kamonai ikove’ na ke koni tumaghanesi, ");
INSERT INTO pwg_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","iyamna Wawaya Natusi ina pipisi na namanamara nakanani. Ma ina vokadari da maramatana da niyipuna ina yasegana yavui.” ");
INSERT INTO pwg_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","“Oghogha yavona imapatana kona kitai na konakovi da bowabowa nani. Ma wawaya weni matakirisi kudubina ina kitai na inakovi da tuna na mara damona.” ");
INSERT INTO pwg_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Vokwarakwara marasi ina kovi na murinai na yaghiyaghinai madegha ini nubakutuvi, nawaravi ina yasegana ina kovi, ma gwamegwame ina ririgha. Ma bera peyarina kunumai na God ina nukei. ");
INSERT INTO pwg_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Wawaya peyarisi dobuwai matakira kunumai ina kitai na ina tutou. Ma ina kita da Wawaya Natusi kwavu kamonai ere kadarina ma rewapanina ina pipisi. ");
INSERT INTO pwg_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Ma ture ina tou da gamona ghamana na God ina aneya ina vonatawesi da dobu ina ne yavui da ina wawaya vovinesi ina kiividaburisi.” ");
INSERT INTO pwg_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Kii na miiba, nota ina veremi da mara damona na ikikava. Maranai kiinumo kiina takitai da ruguruguna eraravi ma enumonumoi na takovi da gisina kava da kwamra. ");
INSERT INTO pwg_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Maghimaghighina weni berasi avi sisiyei peyarina kona kitai na konakovi da mara itupo, gisina kava da Wawaya Natusi ina nekiibau. ");
INSERT INTO pwg_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Vonavaghata avonavonemi, Jiu dami viya patana da kona makamakai ma weni berasi peyarina ina tupuwa. ");
INSERT INTO pwg_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Kunuma ma dobu ina wapa ma vonaku na ke meyani da ina wapa.” ");
INSERT INTO pwg_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Ke sago iyai itakovi da avi maranai weni berasi aisisiyei na ina tupuwa. Aneya kunumai ke itakovi, nakanani bade God Natuna ke itakovi. Mamai God ina kina kava iakovi. ");
INSERT INTO pwg_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Nowa ina mariyai ikikava bera ghamana itupuwa da ivi tataghanisi, nakanani ina tupuwa Wawaya Natusi ina vovira marana. ");
INSERT INTO pwg_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Muriyai da kutukutuva ita kunisi na wawaya ikamkamporagha, iumuma, ma itatavine ma nani kamonai na Nowa ina ku waka igeru. ");
INSERT INTO pwg_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Wawaya ke itakovi da aviyavisina ituputupuwa ma kutukutuva inekiibau da peyarisi ikaruwesi da irukwa. Nakanani ina tupuwa maranai Wawaya Natusi ina vovira. ");
INSERT INTO pwg_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Nani maranai tomotomowa ivi ruwa vao kamonai ina wayowayowa na sago ina viitawei ma sago ina makai. ");
INSERT INTO pwg_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Bade wivine ivi ruwa vavai ina yaghayagha na sago ina viitawei ma sago ina makai.” ");
INSERT INTO pwg_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Tuna kubiine kovovunagha meyemi ma kona vivikoyakoyagha. Ke kotakovi da mara avai ami Bada ina vovira. ");
INSERT INTO pwg_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Koviyana. Numa badana itakovi da avi maranai yapiyapi wawayina ita pisi na numa iti tarapaparanei da yapiyapi wawayina ke kovokovoghina da numa ita gavovori da ita rui. ");
INSERT INTO pwg_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Ma vaghina, tami bade kovovunagha meyemi, iyamna nani marana kona notanotai da Wawaya Natusi ke ina pisi na tuna maranai ina nekiibau.” ");
INSERT INTO pwg_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Yesu ivona bo, “Numa badana ina bigabiga tomowina patupatutuna ma nuwanuwagiurina ina panani na ina vinei da ina bigabiga peyarina ini badesi ma kii vavai ina rereghisi. ");
INSERT INTO pwg_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Maranai numa badana ina vovira ina ku numa ma ina panani da bigabiga tomowina ebigabiga bubuna na ini nuwabiibiiyei. ");
INSERT INTO pwg_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Vonavaghata avonavonemi, numa badana nani bigabigana ina terepai da ina mura kudubina ini badei ma ina koyagha bubuni. ");
INSERT INTO pwg_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Ma mikeda bigabiga tomowina na wawaya berona na ina vona bo, ‘Aku bada ina numataya iguri.’ ");
INSERT INTO pwg_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Tuna kubiine ini karei da bigabiga turaturana ina kwapukwapusi ma mara nonowa wawaya umaneghaneghasi yavata inumuma ma ina kamkam. ");
INSERT INTO pwg_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Ma ke itakovi da meni maranai ina bada ina vovira, tuna kubiine ke ita notanotai da ita nekiibau na nani maranai ina nekiibau da ini tataghani. ");
INSERT INTO pwg_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Ma numa badana bigabiga berona ini tarabedibediyanei ma ina tawanakiibuwei da miiriruwaruwasi yavata ina vivitutuwana ma okesi ina vivitarakikitei.” ");
INSERT INTO pwg_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Yesu ivona bo, “God ina vikiivavona na weni nakanani. Mara sago wiwike imaruwa, i rampa ikavara ma inae da tomowa ita tavine na verupotena kubiine. ");
INSERT INTO pwg_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Kamosiyai wivine miikovi na nuwanuwagiurisi ma miikovi na neghaneghasi. ");
INSERT INTO pwg_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Neghaneghasi na i rampa ikavara ma kamonai kii oira ke ghamana. ");
INSERT INTO pwg_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Ma nuwanuwagiurisi na i rampa ikavara ma bade kii oira ku diudeu kamosi itepo na yavata ikavara. ");
INSERT INTO pwg_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Tavine tomowina ivivi kayovira kubiine, wiwikesi matasi ipota na ivivi keneyana.” ");
INSERT INTO pwg_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Nubakutuva basunai ma yonayona wawayina ikiirara bo, ‘Tavine tomowina epipisi! Kokiibau da kona verupotei!’ ");
INSERT INTO pwg_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Wiwikesi irumatamatakeyana da i rampa ivovovunagha. ");
INSERT INTO pwg_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Ma neghaneghasi turaturasi kurisi ivi nowi bo, ‘Kade oira gisina kota verekai, akii rampa epekipeki.’ ");
INSERT INTO pwg_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Ma nuwanuwagiurisi ivonapotesi bo, ‘Kegha. Konae da kubiimi kona gimara. Ke ruvaruvana da kana votepowemi.’ ");
INSERT INTO pwg_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Vaghina ma, neghaneghasi inae da i oira ita gimara ma nani kamonai tavine tomowina inekiibau. Ma wiwikesi miikovi ivovunagha na tomowina yavata irui ku numa tavine kamna kubiine ma matuketa igudui.” ");
INSERT INTO pwg_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Muriyai neghaneghasi inekiibau ma ikwatukwatu bo, ‘Bada, Bada! Matuketa kevotawei da kana rui!’ ");
INSERT INTO pwg_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Ma ivonapotesi bo, ‘Kegha! Vonavaghata avonavonemi da tami ke atakovimi!’” ");
INSERT INTO pwg_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Ma Yesu ina sisiya turina iterei, ivona bo, “Tuna kubiine kovovunagha meyemi, iyamna ke kotakovi da mara avai Wawaya Natusi ina nekiibau.” ");
INSERT INTO pwg_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Yesu ivonesi bo, “Ma bade God ina vikiivavona na weni nakanani. Mara sago mura tomowina ita numataya. Ina bigabiga ikwatusi ma ivi varavarisi da ina mura ita koyagha bubuni. ");
INSERT INTO pwg_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Ma i akova ruvanai mane irereghisi. Sago na 5 tausan gold riririghisi, sago na 2 tausan gold riririghisi ma sago na 1 tausan gold riririghisi iverei. Ma iverukuyowesi da inae. ");
INSERT INTO pwg_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Bigabiga tomowina 5 tausan iviiya na maninina inae da ivi gimagimara ma bade ku tepana 5 tausan ipanani. ");
INSERT INTO pwg_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Ma bigabiga tomowina 2 tausan iviiya na berana sago iberai da ivi gimagimara da ku tepana 2 tausan ipanani. ");
INSERT INTO pwg_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Ma bigabiga tomowina 1 tausan iviiya na inae da dowa iyabai ma ina bada ina mane iteregavui.” ");
INSERT INTO pwg_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Mara gurina murinai ma mura tomowina ivovira. Ma ina bigabiga ikwaturiyariyesi da iti tarakiiyanesi da mane iveresi na ikikava iberai. ");
INSERT INTO pwg_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Ma bigabiga tomowina sago ipisi ma ivona bo, ‘Bada, 5 tausan kuvereku na ku tepana 5 tausan aberai na kekitai, weni.’ ");
INSERT INTO pwg_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Ma ina bada ivonapotei bo, ‘Kubera bubuni, tam bigabiga biibiim! Bera gisigisi kubiisi kuvi patutu kirakai, tuna kubiine ana terem da bera ghamaghamasi kuni badei. Kerui da yavata tinuwabiibai.’” ");
INSERT INTO pwg_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Ma bigabiga tomowina kana viruwa ipisi ma ivona bo, ‘Bada, 2 tausan kuvereku na ku tepana 2 tausan aberai na kekitai, weni.’ ");
INSERT INTO pwg_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Ma ina bada ivonapotei bo, ‘Kubera bubuni, tam bigabiga biibiim! Bera gisigisi kubiisi kuvi patutu kirakai, tuna kubiine ana terem da bera ghamaghamasi kuni badei. Kerui da yavata tinuwabiibai.’” ");
INSERT INTO pwg_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Ma bigabiga tomowina turina ipisi ma ivona bo, ‘Bada, akovim da tam na wawaya bagibagim. Pei ke kuta vovoni ma keyabayaba. Wereka ke kuta bubuni ma kevovopura. ");
INSERT INTO pwg_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Tuna kubiine ayabumanem ma anae da am 1 tausan gold riririghisi tano kamonai ateregavui. Kekitai, am mane na weni.’ ");
INSERT INTO pwg_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Ma ina bada ivonapotei bo, ‘Tam bigabiga berom, kayobarim! Namada kuakovi da taku pei ke ata vovoni ma kegha da ayabayaba, ma wereka ke ata bubuni ma kegha da avovopura. ");
INSERT INTO pwg_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Aku gold riririghisi averem na mane kii vovidaburana wawayisi benki kamonai kuta veresi da mane gisina ku tepana ita yamoni. Ma maranai avovira na aku mane gwabisiyai kuta viiya ma bade ku tepana iyamoni na yavata kuta vereku.’” ");
INSERT INTO pwg_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","“Ma ina wawaya ivonesi bo, ‘Weni bigabiga wawayina gwabinai gold riririghisi koviitawei da nokoni bigabiga wawayina 10 tausan gwabinai na tuna kona verei.’ ");
INSERT INTO pwg_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","‘Avonavonemi da iyavo kava avi puyona God gwabinai iviiya ma ina bera bubuni na ku tepana ina vere kirakiiyesi. Ma iyavo kava puyo gisina gwabisiyai ma ke ina bera bubuni na God kudubina ina viitawei. ");
INSERT INTO pwg_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ma weni bigabiga kayobarina kotawanakiibuwei ku nubakutuva. Nani dobunai ina tutou ma okena ina vivitarakikitei.’” ");
INSERT INTO pwg_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Mara sago Wawaya Natusi ere kadarina ma ere rewapanina ina aneya yavata ina nekiibau na ina vikiivavo gawarina tepanai ina makiivipika ma ini bada. ");
INSERT INTO pwg_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Ma wawaya dam ma dam ku maghinona ina kiiriyariyesi ma wawaya ina vorereghisi da koroto ruwa. Nakanani ma sipu kii koyakoyagha ghamoghamo ita rereghisi da sipu bogiiyai ma gote bogiiyai. ");
INSERT INTO pwg_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","God ina wawaya maninisi, ti nakanani ma sipu na ina vonatawesi da katagheyanai ina makai. Ma wawaya ke maninisi na ina vonatawesi da dugenai ina makai, ti nakanani ma gote. ");
INSERT INTO pwg_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Nani murinai na Kiivavo ina vona bo, ‘Tami katagheyakuwai na kopisi. Aku Mamai ivi biibiinimi. Dobu karenai ina vikiivavona ivovunaghi tami kubiimi da koni rapenei, ");
INSERT INTO pwg_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","iyamna vitonara ikariku na vavai kovereku da akani. Kaiyoku ikanakana na okowa kovereku da aumai. Anumataya ma ke kotakoviku ma kegha da korutiniku ami ku numa. ");
INSERT INTO pwg_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Kaku gara kegha na gara kovereku. Agubaga na korapa bubuniku. Taku gabura kamonai na korugenariku.’ ");
INSERT INTO pwg_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Ma wawaya maninisi ivonapotei bo, ‘Bada, avi maranai kakitim da vitonara ikarim na kavi kanim? Bo kaiyom ikanakana na okowa kaverem? ");
INSERT INTO pwg_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Ma avi maranai ke katakovim ma kegha da karutinim akii ku numa? Bo kam gara kegha ma gara kaverem? ");
INSERT INTO pwg_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Avi maranai kugubaga na kanae kakitim? Bo gabura kamonai kumakamakai na karugenarim?’ ");
INSERT INTO pwg_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Ma kiivavo ina vonapotesi bo, ‘Vonavaghata avonavonemi, wawayota vivikamyuyuwina na nakanani ma varesiku. Ma aviyavisina kurina koberai na nakanani ma taku kuriku kota berai.’” ");
INSERT INTO pwg_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Ma wawaya dugenai ina vonesi bo, ‘Konetaweyana! Tami God ivi magimi. Keyama karata makamakii nonowina ivovunaghi da Devil ma ina aneya kubiisi na tami yavata nake konae, ");
INSERT INTO pwg_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","iyamna vitonara ikariku na vavai ke kota vereku. Kaiyoku ikanakana na okowa ke kota vereku. ");
INSERT INTO pwg_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Ke kotakoviku na kokitakuyoweku da ke kota rutiniku ami ku numa. Kaku gara kegha na gara ke kota vereku. Gabura kamonai agubaga na ke kota rugenariku.’” ");
INSERT INTO pwg_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Ma nani wawayisi dugenai ina vonapotei bo, ‘Bada, avi maranai kakitim da vitonara ikarakarim, bo kaiyom ikanakana, bo kunumataya da kakitakuyowem, bo kam gara kegha, bo kugubaga gabura kamonai na ke kati vitem?’ ");
INSERT INTO pwg_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Ma kiivavo ina vonapotesi bo, ‘Vonavaghata avonavonemi, wawayota vivikamyuyuwina kokitakuyowei ma ke koti vitei na tuna nakanani ma taku kuriku kota berai.’ ");
INSERT INTO pwg_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Vaghina ma, nani damsi dugenai na ina nae da kovogha makamakii nonowina ina viiya. Ma wawaya maninisi na ina nae da yawasa makamakii nonowina ina viiya.” ");
INSERT INTO pwg_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Yesu weni vibeyebeyena ivi kovini na kana kivikivina kurisi ivona bo, ");
INSERT INTO pwg_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Koakovi da mara ruwa ina kovi na Pasova kamna kana mara. Ma taku Wawaya Natusi, wawaya sago ini wawaneku da kaku ghavighaviya ku imasi ina tereku da ina tuparatuku.” ");
INSERT INTO pwg_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Ma nani maranai taparoro babadisi i babada ma Jiu damsi i babada ivi kiidaburana da taparoro badana ghamana Kayapas ina numiiyai ");
INSERT INTO pwg_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","ivivi ogatara da ikikava gavunai Yesu ita paniya ma iti raboboi. ");
INSERT INTO pwg_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Ma ivona bo, “Ke Pasova kamna kamonai taberai iyamna koroto ghamana ini kayotirana da kwanatu ina kayoresoi.” ");
INSERT INTO pwg_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Yesu inumataya ku Betani kwanatuna da Saimon ina numiiyai imakamakai. Tomowina kunonai gubaga kana vava giipo ininina ikam yavui. ");
INSERT INTO pwg_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Ma Yesu nevanevanai ikenavipika da ikamkam ma wavine sago ipisi kurina, ina diudeu kamonai na oira ghabughabuna, miiyanina irakata kirakai. Ikavari ipisi da Yesu ku gayamina ivotepoi. ");
INSERT INTO pwg_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Ma kana kivikivina ikitai da nuwanuwasi ipughu. Ivona bo, “Avi kubiine oira irekwei? ");
INSERT INTO pwg_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Nani oirina iti gimarei da mane ghamana ita viiya da wawaya moyamoyakisi ita veresi.” ");
INSERT INTO pwg_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Ma Yesu iakovi da aviyavisina ivi sisiyei na ivonesi bo, “Weni wavinena kovoterekuyowei, ke kona yeghai. Tuna bera biibiina kuriku iberai. ");
INSERT INTO pwg_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Moyamoyakisi na mara nonowa gwabimiyai emakamakai, ma taku na ke mara gurina yavata tamakai. ");
INSERT INTO pwg_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Weni wavinena oira ghabughabuna ivotepoi ku tepaku na tupuwiku ivovunaghi da dogoku kubiine. ");
INSERT INTO pwg_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Vonavaghata avonavonemi, dobu ku kudubina wawaya God varana biibiina ina dimadimei na aviyavisina weni wavinena iberai na ini sisiyei da notana ina viiviiya.” ");
INSERT INTO pwg_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Yesu kana kivikivina ivi 12 kamosiyai na sago kana vava Judas Iskariyot, ma tuna inae taparoro babadisi i babada kurisi. ");
INSERT INTO pwg_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Ivi tarakiiyanesi bo, “Yesu ani wawanei na aviyavisina ku imaku kona terei?” Ma ti na silva riririghisi ivi yavi da 30 ma ivi miiyei. ");
INSERT INTO pwg_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Vaghina ma, Judas ivi karei da keta iekwekwai da ikikava Yesu ku imasi ita terei. ");
INSERT INTO pwg_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Jiu damsi i kamporagha sago kana vava ‘Parawa Kiipanina’ ma nani kamna na mara ivi 8 ina verau. Ma nona marana nani kamporaghina kamonai na kana vava Pasova. Ma kana kivikivina Yesu ivi tarakiiyanei bo, “Imapatana kekayokayowei da kana vovunagha Pasova kamna kubiine?” ");
INSERT INTO pwg_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Ma Yesu ivonapotesi bo, “Korui ku Jerusalem ma tomowa sago kona panani ma kovonei, ‘Ita Bada ivona bo, Kaku mara ipisi. Kaku kivikivina yavata Pasova kamna kana berai am numa kamonai.’” ");
INSERT INTO pwg_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Vaghina ma, kana kivikivina inae ma ikikava ivonavonesi na iberai, Pasova kamna kubiine ivokuyakuya. ");
INSERT INTO pwg_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Ravi ipika ma Yesu kana kivikivina ivi 12 yavata nevanevasiyai ikenavipika da ita kam. ");
INSERT INTO pwg_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Ma ikamkam kamonai na Yesu ivona bo, “Vonavaghata avonavonemi, kamotiyai wawaya sago ini wawaneku.” ");
INSERT INTO pwg_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Kana kivikivina nani sisiyina ivi yanei da ivi nuwapoya kirakai, ma sago sago duma ivonavonei bo, “Bada, ke taku, bo?” ");
INSERT INTO pwg_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Ma Yesu ivonapotesi bo, “Wawayina ini wawaneku na taku yavata parawa ku dabira kakiikutuva patapata. ");
INSERT INTO pwg_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Ikikava peroperoveta igiruma na nakanani taku Wawaya Natusi ana rabobo. Ma meni wawayina ina viviwawaneku na iti nuwapoya kirakai iyamna ini kamyuyuwa kirakai. Ita biibai da nani wawayina ke meyani ita tupuwa.” ");
INSERT INTO pwg_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Ma Judas, viwawana wawayina, ivonei bo, “Bada, ke taku, bo?” Ma Yesu ivonapotei bo, “E, vaghina, tam. Kuvi debe meyem.” ");
INSERT INTO pwg_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Ikamkam kamonai na Yesu parawa sago iviiya ma God kurina ivi kiikiiwa ma ivogimai da kana kivikivina irereghisi. Ma ivonesi bo, “Koviiya ma kokani. Weni tuna tupuwiku.” ");
INSERT INTO pwg_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Ma bade redu iviiya ma ivi kiikiiwa. Ma kana kivikivina iveresi ma ivonesi bo, “Peyarimi weni redunai kouma. ");
INSERT INTO pwg_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Weni tuna taraku. Imatakira da God ma ina wawaya yavata vivaghina vuna makamakii nonowina eberaberai. Taraku ina sororo da wawaya peyarisi i berabero God ina notatawei. ");
INSERT INTO pwg_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Avonavonemi da wain ke anuma meyei ina nenae da mara karakava aku Mamai ina vikiivavona kamonai na tuma patapata.” ");
INSERT INTO pwg_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Ma vaghina, vokavara tavorina sago iravi ikovi ma ikiibau ku Oliv koyana. ");
INSERT INTO pwg_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Yesu kana kivikivina ivonesi bo, “Weni didibarinai peyarimi kona verukuyoweku. Giruma katamana evonavona bo, ‘Sipu kii koyakoyagha ina kiivunui, ma sipu yavona ini verubogebogesi.’ ");
INSERT INTO pwg_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Ma rabobowai ana vomiiri murinai na ani nao ana nae ku Gariri.” ");
INSERT INTO pwg_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Ma Pita ivona bo, “Mikeda kam kivikivina kudubisi ina verukuyowem ma taku na ke meyani da ana verukuyowem.” ");
INSERT INTO pwg_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Ma Yesu, Pita ivonei bo, “Vonavaghata avonavonem, karako weni didibarinai, muriyai da kokoreko ina tou na mara aroba kuni bero da ke kuta koviku.” ");
INSERT INTO pwg_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Ma Pita ivona bo, “Kegha! Namanaki inakoviku da taku na kam kivikivina na yavata ini rabobota, ke meyani ana vona da ke atakovim!” Ma kana kivikivina peyarisi sisiyina sago ivonei. ");
INSERT INTO pwg_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Yesu kana kivikivina yavata inae ku gawara sago kana vava Getsemani, ma ivonesi bo, “Weni dobunai komakai ma ana nae noke da ana nipowana.” ");
INSERT INTO pwg_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Ma Yesu ita nae na Pita ma Zebedi natunatuna Jemes da Jon irutinisi da yavata inae. Ma damina iviiya da nuwanuwana kamonai ivisivisi ma nuwapoya ikiivunui. ");
INSERT INTO pwg_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Ma ivi aroba ivonesi bo, “Aviyavisina nuwanuwaku kamonai damina aviiviiya na tuna nuwapoyina ekiikiivunuku. Ke kona kuyoweku, weni dobunai komakai da kokita ma yavata tabanebanenega.” ");
INSERT INTO pwg_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Yesu ine gisina ma itawotei da maghighina ku tano ma inipowana bo, “Aku Mamai, kovokovoghina bo kegha da vokwarakwara reduna gwabikuwai kuta viitawei. Ma ke taku aku kayowana ma tam am kayowanai keberai.” ");
INSERT INTO pwg_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Yesu ivovira kana kivikivina ivi aroba kurisi ma ikitisi da ivivi keneyana na Pita ivonei bo, “Kade kota banenega mara gisina bo kegha? ");
INSERT INTO pwg_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Kokitabanenega ma konipowana da ruyagha ke kona panani. Kanumimi ina kayowana ma tupuwimi na imitamita.” ");
INSERT INTO pwg_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Vaghina ma, mara viruwina ikuyowesi da ine gisina ma inipowana bo, “Mamai, mikeda ke kovokovoghina da vokwarakwara reduna kuna viitawei na vaghina, anumai da am kayowana ina tupuwa.” ");
INSERT INTO pwg_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Ma ivovirame kana kivikivina kurisi ma ikitisi da bade ivivi keneyaname, iyamna matasi ikiikovoghi. ");
INSERT INTO pwg_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Ma vaghina, mara viarobina Yesu ikuyowesi inae ma nipowanai sisiyina sago iterei. ");
INSERT INTO pwg_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Ma ivovirame kana kivikivina kurisi ma ivonesi bo, “Karakava da kokenakena ma koiyakam bo? Kokitai, taku Wawaya Natusi kaku mara inekiibau da viwawana wawayina ini wawaneku da berabero wawayisi ku imasi ina tereku. ");
INSERT INTO pwg_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Kovomiiri ma tanae. Kokitai, viwawana wawayina inekiibau.” ");
INSERT INTO pwg_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Yesu ivivi sisiya kamonai na Judas, tuna Yesu kana kivikivina sago ivi 12 kamosiyai na koroto ghamana yavata ere kepatisi ma ere serisi inekiibau. Ti na taparoro babadisi i babada ma Jiu damsi i babada ivonatawesi. ");
INSERT INTO pwg_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Karakava da ita pisi na Judas ivonesi bo, “Wawayina ana yoyoni na vaghina wawayina. Tuna kopaniya.” ");
INSERT INTO pwg_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Vaghina ma, Judas maninina inae Yesu kurina ma ivona bo, “Kiiwa, kiiwa, Bada.” Ma iyoni. ");
INSERT INTO pwg_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Ma Yesu ivonapotei bo, “Kwinaku, aviyavisina kenotanotai na vaghina, keberai.” Ma nani korotona ipisi da Yesu ivotatani ma ipaniya. ");
INSERT INTO pwg_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Ma kana kivikivina sago ina seri itinatawei da taparoro badana ghamana ina bigabiga tinina ikiiyaraghatawei. ");
INSERT INTO pwg_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Ma Yesu ivona bo, “Am seri ketupasusura meyei, iyamna iyavo kava seriyai itona na seriyai ina rabobo. ");
INSERT INTO pwg_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Kotakovi da ati kwatu aku Mamai kurina na yaghiyaghina aneya korotosi ita vonatawesi da kubiiku iti tona. ");
INSERT INTO pwg_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ma mikeda weni berana ata berai na aviyavisina peroperoveta igirumi na ke ita tupuwa.” ");
INSERT INTO pwg_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Vaghina ma, Yesu nani korotona ivonesi bo, “Avi kubiine seri da kepata kopiyei da kota paniku, nakanani ma taku kayakayayiku? Mara nonowa Taparoro Numana garina kamonai avivi beyebeyena ma ke kota paniku. ");
INSERT INTO pwg_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Ma aviyavisina peroperoveta namada igirumi da ita tupuwa na wekarakava etuputupuwa na idebei kurita da vonavaghata.” Nani murinai kana kivikivina ivoterei da iverukuyowei. ");
INSERT INTO pwg_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Iyavo kava Yesu ipaniya na irutini ma yavata inae da Taparoro Badana Ghamana Kayapas ina ku numa. Ma nani dobunai vonaviyoyovana vibeyebeyena wawayisi ma Jiu damsi i babada ivi kiidaburana. ");
INSERT INTO pwg_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Ma Pita ina kina kava murisiyai ikivinisi da Kayapas ina numa garina ku kamona irui. Ma numa kana potapota wawayisi yavata imakiivipika ma ita kitai da aviyavisina ita tupuwa. ");
INSERT INTO pwg_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Taparoro babadisi i babada ma Sanhidran babada kudubisi keta iekwekwai da sisiya viberowai Yesu iti wavui ma iti raboboi. ");
INSERT INTO pwg_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Ma wawaya ipeyari ivomiiri da sisiya viviberosi iberaberai ma ke ruvaruvana da aviyavisina ita panani da Yesu iti wavui. Turinai na tomotomowa ruwa imiirikiibau ");
INSERT INTO pwg_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","ma ivona bo, “Weni tomowina ivona da God ina Taparoro Numana ita rikatawei ma mara aroba kamonai ita vowa meyei.” ");
INSERT INTO pwg_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Ma taparoro badana ghamana ivomiiri ma Yesu ivonei bo, “Iwavum na ikikava kuna vonapotesi? Kam papara kuna vowai bo kegha?” ");
INSERT INTO pwg_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Ma Yesu kawana ipota. Ma ivona meyei bo, “God makamakii nonowina avanai vonavaghata kevonekai. Tam God ina Vivinevine Wawayina bo kegha? Tam God Natuna, bo?” ");
INSERT INTO pwg_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Ma Yesu ivonapotei bo, “Vaghina, kuvona bubuna. Ma peyarimi avonavonemi da mara epipisi da taku Wawaya Natusi kona kitiku da God Rewapana Kirakiina katagheyanai ana makamakai, ma bade kona kitiku da kwavuwai anororu ku dobu.” ");
INSERT INTO pwg_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Taparoro badana ghamana weni sisiyina ivi yanei na nuwanuwana ipughu da kana gara itinasikai. Ma ivona bo, “Kovi yanei! God ivi avaberowei! Ivona da tuna na God! Ke vimamatara wawayisi tekwai da ini wavui, iyamna namada tuna mani ina sisiya tavi yanei! ");
INSERT INTO pwg_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Ami nota ikikava?” Ma Sanhidran wawayisi ivonapotei bo, “Wawaya berona! Kana kovogha na rabobo!” ");
INSERT INTO pwg_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Ma ivi karei da maghighina ikanukanui ma piideyai iraravi. Ma viya nevanevana itapitapiya ");
INSERT INTO pwg_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","ma ivonavonavinamei bo, “Kuvona da tam na God ina Vivinevine Wawayina. Tam peroveta na kade kuta vonekai da iyi iravim.” ");
INSERT INTO pwg_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Ma Pita na numa garina kamonai imakamakai ma bigabiga wavine sago ipisi da ivonei bo, “Akitim da tam bade Gariri tomowa Yesu yavata kobababa.” ");
INSERT INTO pwg_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Ma Pita ivi bero ma wawaya maghinosiyai ivona bo, “Taku ke atakovi da avi kisisiyei.” ");
INSERT INTO pwg_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Ma ikiibau gari ku matuketina ma bigabiga wavinena sago Pita ikitai ma wawaya viya ivivi miiriyana na kurisi ivona bo, “Weni tomowina na Yesu, Nasaret wawaya yavata ibababa.” ");
INSERT INTO pwg_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Mara viruwina Pita ivi bero, ivona bo, “God vavanai vonavaghata avonavonemi da nani tomowina ke atakovi.” ");
INSERT INTO pwg_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Ke mara gurina ma nani wawayisi baranai ivivi miiriyana ipisi Pita kurina ma ivonei bo, “Vonavaghata, tam ina wawaya sago ma bade am sisiya viyanina na Gariri damsi nakanani.” ");
INSERT INTO pwg_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Ma Pita ivonesi bo, “God vavanai vonavaghata avonavonemi da nani tomowina ke atakovi. Mikeda aibero na aivaghinei da God kovogha ina vereku.” Ma ina sisiya turina itereterei na kokoreko itou. ");
INSERT INTO pwg_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Ma yaghiyaghinai Pita ina nota ivovira da ikikava Yesu ivivi sisiya na inotai. Yesu ivona bo, “Muriyai da kokoreko ina tou na mara aroba kuni bero da ke kuta koviku.” Ma vaghina, Pita ikiibau ku kupuna ma itusiyasiyapa. ");
INSERT INTO pwg_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Mara boiboiyai na taparoro babadisi i babada ma Jiu damsi i babada kudubisi ivi ogatara da ikikava Yesu iti raboboi. ");
INSERT INTO pwg_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Ma imana ikuni ma irutini inae Pailat kurina. Tuna na Rome kana bada sago ma ivonatawei da Judiya dobuna ivivi badei. ");
INSERT INTO pwg_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Judas, tuna viwawana wawayina na sisiya ivi yanei da Sanhidran babada ivi vaghinei da Yesu iti raboboi. Ma damina iviiya da bera berona iberai na ivi nuwapoya kirakai. Ma nani 30 silva riririghisi taparoro babadisi i babada ma Jiu damsi i babada gwabisiyai iviiya na ikavari ivovira da ita vere meyesi. ");
INSERT INTO pwg_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Ma ivonesi bo, “Abera beroi da wawaya ina berabero kegha ma avi wawanei da koni raboboi.” Ma ivonapotei bo, “Tam kava kam wavu. Tokai ke kati nuwapoyei.” ");
INSERT INTO pwg_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Vaghina ma, Judas nani 30 silva riririghisi Taparoro Numana ku kamona ivi tawetaweyana. Ma ikiibau inae da iruke. ");
INSERT INTO pwg_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Taparoro babadisi i babada nani riririghisi iyuna ma ivona bo, “Weni tuna na puka manena, ma vonaviyoyovana evonavoneta da ke ruvaruvana da Taparoro Numana kana mane yavata tikiikapui.” ");
INSERT INTO pwg_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Ivi dughu ma ivi vaghinei da riririghisi ivoviviri na bayawa yamoyamona wawayina gwabinai tano igimari da kupuna damsi kii karawaga. ");
INSERT INTO pwg_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Tuna kubiine nani tanona patana da ekwatukwatui da ‘Tara Tanona.’ ");
INSERT INTO pwg_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Weni tanona igimari na ikikava peroveta Jerimaya ivi sisiyei na berana itupuwa. Ivona bo, “Israel damsi ivi vaghinei da wawayina kana miiya na 30 silva riririghisi. Ma manena iviiya ");
INSERT INTO pwg_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","da iruvoviviri da bayawa yamoyamona wawayina gwabinai tano igimari. Ikikava Bada sisiya bagibagina iverevereku na nakanani itupuwa.” ");
INSERT INTO pwg_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Yesu na Judiya dobuna kana bada Pailat maghinonai imiimiiri ma Pailat ivi tupavirevirei. Ivi tarakiiyanei bo, “Tam Jiu damsi i kiivavo, bo?” Ma Yesu ivona bo, “Vaghina, kuvona bubuna.” ");
INSERT INTO pwg_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Ma taparoro babadisi i babada ma Jiu damsi i babada ivi karei da Yesu ivivi wavui na ke ita vonapotesi. ");
INSERT INTO pwg_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Tuna kubiine Pailat ivi tarakiiyanei bo, “Kade, wavu kudubina evereverem na kiyanesi bo kegha?” ");
INSERT INTO pwg_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Ma Yesu ivi kawapotapota da i sisiya ke sago ita vonapotei na Pailat ivi deye kirakiiyei. ");
INSERT INTO pwg_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Pailat ina bera imakamakai da Pasova kamna nununai koroto i kayowanai wawaya sago gabura kamonai ina votawei. ");
INSERT INTO pwg_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Ma nani maranai tomowa sago gabura kamonai imakamakai, kana vava Barabas. Ma wawaya peyarina iakovi da tuna tomowa kayakayayina. ");
INSERT INTO pwg_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Ma koroto ghamana ipisi na Pailat ivi tarakiiyanesi bo, “Meni wawayina kokayokayowei da kubiimi ana votawei? Barabas bo Yesu, tuna na wawaya viya evonavonei da God ina Vivinevine Wawayina.” ");
INSERT INTO pwg_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Pailat iakovi da taparoro babadisi i babada na Yesu inuwakapiyei, tuna kubiine irutinapiyei kurina. ");
INSERT INTO pwg_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Ma Pailat vitupavira gawarinai imakamakai na kawana sisiya ivonatawei kurina. “Nani wawayina kevoterei. Ke aviyavisina sago kuna berai kurina. Tuna ina berabero kegha. Taku didibarai wawayina avi matuwei na ayabumana kirakai.” ");
INSERT INTO pwg_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Ma taparoro babadisi i babada ma Jiu damsi i babada koroto ghamana ivivi nuwatinisi da ita vona bo, “Barabas kevotawei ma Yesu na kevi raboboi.” ");
INSERT INTO pwg_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Ma Pailat ivi tarakiiyana meyesi bo, “Wawaya na ruwa, ma meni wawayina kokayokayowei da ana votawei kubiimi?” Ma peyarisi ikarayogosi bo, “Barabas!” ");
INSERT INTO pwg_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Ma Pailat ivonesi bo, “Ma weni tomowina Yesu, wawaya evonavona da tuna na God ina Vivinevine Wawayina na ikikava ana berai?” Ma kudubisi ighekiirara bo, “Kotuparatui!” ");
INSERT INTO pwg_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Ma bade ivonapotesi bo, “Avi kubiine kana tuparatui? Aviyavisina ibera beroi?” Ma kegha da koroto ighekiirarame. “Kotuparatui! Kotuparatui!” ");
INSERT INTO pwg_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pailat damina iviiya da ke kovokovoghina da wawaya i nota ita tinavirai. Ma ikitai da gisina kava viruwa ghamana ita tupuwa. Tuna kubiine bigabiga sago ivonei da okowa ikavarapiyei ma koroto maghinosiyai imana ikowai. Ivonesi bo, “Weni tomowina tarana ina sororo na ke taku wavuna ana kavari, tami mani kami wavu!” ");
INSERT INTO pwg_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Ma wawaya kudubisi nani korotona kamonai ivonapotei bo, “Tarana na tokai ma natunatukai wavuna kana kavari!” ");
INSERT INTO pwg_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Vaghina ma Pailat, Barabas gabura kamonai ivotawei da ikiibau. Ma Yesu na ivi damani seri damsi kurisi da ita kwapui ma ita tuparatui. ");
INSERT INTO pwg_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Seri wawayisi viya Yesu irutini i numa garina ku kamona ma seri damsi kudubisi ikwaturiyariyesi da Yesu imiirigwagwari. ");
INSERT INTO pwg_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Ma kana gara irupamatawei ma tarasovo yebayebarina ivi kotei. ");
INSERT INTO pwg_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Ma urava ere iyiyona iviiya da imetami ma gayamina itaratani, kiivavo kana tarapinawa ivi bonebonei. Ma diwona ku katagheyana iterei. Tuna nakanani ma kiivavo ina diwona. Ma ivi beroberowei da maghinonai ivi tuwaporeruruwana ma ivonavonavinamei. Ivonei bo, “Kiiwa kiiwa, tam Jiu damsi i kiivavo!” ");
INSERT INTO pwg_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ma ikanukanui ma diwona imanai itinaneboi da gayamina iraravi. ");
INSERT INTO pwg_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Ivi namei ikovi ma tarasovo yebayebarina ivotawei ma kana gara vaghata ivi kotei. Ma irutini ikiibau da ita tuparatui. ");
INSERT INTO pwg_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Seri wawayisi Yesu irutini da Jerusalem ikiibutawei inenae. Ma ketiyai tomowa sago ipanani, kana vava Saimon, ina dobu Sairini. Ma seri damsi idarui da Yesu kana korosi ikavari. ");
INSERT INTO pwg_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Inekiibau ku koya sago, kana vava Gorugata. ");
INSERT INTO pwg_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Ma wain ikavarapiyei ma gegura kawakiikwarikwarina yavata igwadai ma Yesu iverei da itumai. Ikara tovoni ma ibarei, ke itumai. ");
INSERT INTO pwg_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Vaghina ma ku korosi ituparatui. Ma seri damsi virekwa sago iberai da kamosiyai Yesu kana gara irereghi. ");
INSERT INTO pwg_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Nani murinai imakiivipika da Yesu iti matatetei. ");
INSERT INTO pwg_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ma Yesu gayamina ma ku tepana vonaverena igirumi imakamakai, ivi debei da avi kubiine ituparatui. Igiruma bo, “Weni na Yesu, Jiu damsi i kiivavo.” ");
INSERT INTO pwg_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Ma yapiyapi damsi ruwa Yesu yavata ituparatusi, sago katagheyanai ivi miirini ma sago dugenai ivi miirini. ");
INSERT INTO pwg_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Ma wawaya ketiyai inenae ma ipipisi na Yesu ikarakara vibagibagiyei ma ikiikiirara, ivonavonaberoberoi. ");
INSERT INTO pwg_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Ivonavonei bo, “Tam kuvona da Taparoro Numana kuta rikai ma mara aroba kamonai kuta vowa meyei. Tam God Natuna, bo? Mede kevi yawasa meyem da korosiyai keoru!” ");
INSERT INTO pwg_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Ma bade taparoro babadisi i babada, vonaviyoyovana vibeyebeyena wawayisi ma Jiu damsi i babada Yesu ivonavonaviiviiyakei. ");
INSERT INTO pwg_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Ivonavona bo, “Wawaya bogii ma bogiiyai ivivi yawasisi ma ke kovokovoghina da tuna mani iti yawasa meyei. Ivonavoneta da tuna Israel kana kiivavo na mede tuna mani ina rewapanai korosiyai eoru da takitai ma titumaghanei. ");
INSERT INTO pwg_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","God itumaghanei ma ivona da tuna God Natuna. Vaghina, takitai da God ekayokayowei da ini yawasi bo kegha.” ");
INSERT INTO pwg_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Ma nani tomotomowisi ruwa Yesu ririnai ituparatusi na ti yavata ivonavonaviiviiyakei. ");
INSERT INTO pwg_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Madegha punai dobu kudubina ivi nubakutuvi, ma nakanani imakai da ku ravi madegha. ");
INSERT INTO pwg_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Ma ravi madeghinai Yesu ikiirara bo, “Eloi, Eloi, lama sabachthani?” Sisiyina iyamna na “Aku God, aku God, avi kubiine kukuyoweku?” ");
INSERT INTO pwg_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Ma wawaya viya ririnai imiimiiri na ivi yana beroi ma ivona bo, “Kovi yana, Elaidiya ekwatukwatui.” ");
INSERT INTO pwg_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ma wawaya sago yaghiyaghinai iverau da gumba ivokutuvi ku wain kamona. Ma ku kii gurina ivi kavini ma ivororona da Yesu ita karasusui. ");
INSERT INTO pwg_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ma wawaya viya ivona bo, “Kevoterei. Takitai, kade Elaidiya ina pisi da ini yawasi bo kegha.” ");
INSERT INTO pwg_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Vaghina ma Yesu ikiirarame, yapurana itatawei ma irabobo. ");
INSERT INTO pwg_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Ma tuna maranai Taparoro Numana kana tupayaragha garana basunai itamosika, tepanai ivi karei da ioru ku kapina da nake ma wike. Ma nukenuke dobu inukei da wakima ivi tamosepisepiyana. ");
INSERT INTO pwg_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Ma bade karawaga kamonai dogo kawasi itamotate da God ina wawaya vovokaravisi irukwamakai na rabobowai ivomiiri. ");
INSERT INTO pwg_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Ma karakava Yesu rabobowai ina vomiiri ma murinai nani wawayisi vovokaravisi ina rui ku Jerusalem da wawaya peyarisi ina kitisi. ");
INSERT INTO pwg_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Ma seri damsi i senturiyon yavata Yesu ivivi matatetei na nukenuke damina iviiya ma aviyavisina peyarina itupuwa na ikitai da iyabumana kirakai ma ivona bo, “Vonavaghata, weni tomowina tuna God Natuna.” ");
INSERT INTO pwg_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Ma wivine viya Gariri kamonai ivomiiri da Yesu yavata ibababa da kana vavai ivivi tava ma ikoyakoyaghi. Nani wivinesi imiiritaweyana da Yesu korosi tepanai ikitakitai, ");
INSERT INTO pwg_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","ma kamosiyai na Meri Magadarini, Jemes ma Joses i maduwa Meri, ma Zebedi kawana, tuna Jemes ma Jon i maduwa. ");
INSERT INTO pwg_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Ravi ipika ma mura tomowina sago inekiibau. Kana vava Josepa ma ina kwanatu na Arimateya, Judiya dobuna kamonai. Ma tuna Yesu kana kivikivina sago. ");
INSERT INTO pwg_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Inae Pailat kurina ma ivi nowi da Yesu tupuwina ita viiya. Ma Pailat vivaghina sisiyina ivonatawei seri damsi kurisi da Josepa, Yesu tupuwina ita kavari. ");
INSERT INTO pwg_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Ma Josepa inae da Yesu tupuwina korosiyai itereoruwei ma kwarewa vunai igerei. ");
INSERT INTO pwg_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Ma Josepa namada buba sago iyamoni da karakava ita rabobo na tupuwina nani dobunai ita terei. Ma Yesu tupuwina ikavari inae ma nani bubana ku kamona iterei. Ma wakima ghamana itabiri da buba kawana igudupotai ma ikuyowei. ");
INSERT INTO pwg_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Meri Magadarini ma Meri sago ivi ruwa imakai da karawaga imakiikarokaroni ma aviyavisina peyarina Josepa iberaberai na igayogayoi. ");
INSERT INTO pwg_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Mara itom na viyakam marana. Ma taparoro babadisi i babada ma Perisi damsi inae Pailat kurina. ");
INSERT INTO pwg_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Ivonei bo, “Bada, Yesu na viviberona ma kanotanotai da ivona bo, ‘Ana rabobo ma mara viarobina kamonai rabobowai ana vomiiri.’ ");
INSERT INTO pwg_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Tuna kubiine seri damsi viya kevonatawesi da kana buba ina potapotai da mara aroba ina kovi. Nakanani kuna berai da kana kivikivina ke ruvaruvana da tupuwina ina yapini ma muriyai wawaya ina vonesi da tuna rabobowai ivomiiri. Mikeda nakanani ina tupuwa na weni viberona na ina bero kirakai, ke Yesu ina vibero viya nakanani.” ");
INSERT INTO pwg_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Ma Pailat ivonesi bo, “Vaghina, seri damsi yavata konae ma karawaga kopota bubuni.” ");
INSERT INTO pwg_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Vaghina ma inae ma karawagai dobodobo iviiya ma buba matuketina ipasipotai, ivi matakira da wawaya ke ita votawei. Ma seri damsi iteresi da buba ipotapotai. ");
INSERT INTO pwg_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Viyakam marana ikovi ma mara tomtomwai Meri Magadarini ma Meri sago inae Yesu kana ku karawaga da ita kitai. ");
INSERT INTO pwg_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Ma God ina aneya sago kunumai ioru ma nukenuke ghamana itupuwa. Inae Yesu kana ku buba ma wakima ghamana buba kawana igudui na wakimina itabiratawei ma tepanai imakai. ");
INSERT INTO pwg_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Maghighina kitana vovokadakadarina ma kana gara poipoi kirakiina da kitana matakamokamona. ");
INSERT INTO pwg_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Seri wawayisi iyabumana kirakai da ikirokiroro ma iririgha ku tano da ivi kiiparoparorowesi da nama wawaya raborabobosi. ");
INSERT INTO pwg_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Ma aneyina wivinesi ivonesi bo, “Ke kona yabumana. Akovi da Yesu ituparatui na tuna koekwekwai. ");
INSERT INTO pwg_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Tuna ke weni. Namada rabobowai ivomiiri. Ikikava ivonavonemi na nakanani itupuwa. Kopisi da ikenakena gawarina kona kitai. ");
INSERT INTO pwg_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Ma yaghiyaghinai konae da kana kivikivina kona vonesi bo, ‘Yesu rabobowai ivomiiri. Ma ini nao ku Gariri, nani dobunai kona panani.’ Vaghina, avonemi.” ");
INSERT INTO pwg_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Wivinesi yaghiyaghinai karawaga ikuyowei, ti na ere yabuyabumanisi ma kegha da ivi nuwabiibii kirakai. Veru ivi karei da kana kivikivina ita vonesi, ");
INSERT INTO pwg_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","ma keta borinai na Yesu itawanakiibuwei da ivonesi bo, “Kiiwa, kiiwa!” Ma wivinesi inae kurina, itawotesi ku maghinona da kaena ivotani ma ivokavakavari. ");
INSERT INTO pwg_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Ma Yesu ivonesi bo, “Ke kona yabumana. Konae da varevaresiku kona vonesi da ina nae ku Gariri ma nani dobunai ina pananiku.” ");
INSERT INTO pwg_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Nani wivinesi inenae na seri damsi buba ipotapotai na viya ivovira ku kwantu da karawagai aviyavisina itupuwa na taparoro babadisi i babada kurisi ivi mamatarei. ");
INSERT INTO pwg_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Taparoro babadisi i babada ma Jiu damsi i babada ivi kiidaburana ma ivi dughu. Mane ghamana seri damsi ivi miiyesi da iti bero. ");
INSERT INTO pwg_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Ma ivonesi bo, “Weni nakanani kovi bero. ‘Didibarai kakenakena ma kana kivikivina ipisi da tupuwina iyapiya.’ ");
INSERT INTO pwg_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ma mikeda Pailat weni sisiyina ini yanei na ke koni nuwapoyei, iyamna tokai kami papara kana vowai da ke aviyavisina berona kurimi ina berai.” ");
INSERT INTO pwg_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Vaghina ma potapota damsi mane iviiya ma ikikava ivonavonesi na nakanani iberai. Nani vibero sisiyina Jiu damsi kamonai ivoviteteyanei da karako patana da emakamakai. ");
INSERT INTO pwg_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Yesu kana kivikivina ivi 11 ivi varavarisi da ita nae ku koya sago Gariri kamonai na vaghina inae. ");
INSERT INTO pwg_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Nani dobunai Yesu ikitai na ivokavakavari. Ma viya i nota iragharagha da tuna Yesu bo kegha. ");
INSERT INTO pwg_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Yesu kurisi imiiririya ma ivonesi bo, “God rewapana ivereku da bera kudubina kunumai ma dobuwai ani badei. ");
INSERT INTO pwg_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Tuna kubiine avonavonatawemi kona nae da dobu ma dobu, dam ma dam kurisi koni beyebeyesi da ini tumaghaneku ma ina kiviniku. Ma Mamai ma Natuna ma Kanuma Vovokaravina avasiyai kona babataitosi. ");
INSERT INTO pwg_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Koni beyebeyesi da aku sisiya bagibagisi peyarina avi beyebeyemi na ina votekateke yavui. Ma konota bogai da taku mara nonowa gwabimiyai ana makamakai, karako da ku mara damona.” ");
INSERT INTO pwg_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Yesu Keriso na God Natuna ma varana biibiina tikarei. ");
INSERT INTO pwg_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Peroveta Aisaya igiruma da God ivona bo, “Aku yonayona maghinomuwai ana vonatawei, Tuna am keta ina vovunaghi.” ");
INSERT INTO pwg_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","“Wawaya sago warereyai erurukwatu bo, ‘Bada epipisi, tuna kubiine kovovunagha meyemi, ina keta maninina koberai.’” ");
INSERT INTO pwg_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Ma vaghina Jon inekiibau da warereyai wawaya ibababataitosi ma idimadima, ivonavonesi bo, “Ami berabero kubiine kovinimaya ma ami nota korereghi da nani berasi kona takuputei ma kona babataito. Nakanani kona berai na God ami berabero ina notatawei.” ");
INSERT INTO pwg_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Ma wawaya peyarisi Judiya dobuna ma Jerusalem kamonai ikiikiibau Jon kurina da i bera beroberosi ivivi mamatarei ma Jodan okowinai Jon ibababataitosi. ");
INSERT INTO pwg_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Ma Jon kana gara na kamel vunivuninai iyamoni ma borikiide borinai iveruviviri. Ma kana vavai na madikapoka ma manigewa. ");
INSERT INTO pwg_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ma ina dima kamonai ivona bo, “Wawaya sago murikuwai epipisi na tuna ina rewapana irakata kirakai, ke taku nakanani. Taku ke tomowa kiimataniku da ata tawopika da kaena kana terepapara uravina ata rupamatawei. ");
INSERT INTO pwg_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Taku na okowai ababataitomi ma tuna na Kanuma Vovokaravinai ina babataitomi.” ");
INSERT INTO pwg_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Ke mara gurina ma Yesu ivomiiri da Nasaret meyagina Gariri dobuna kamonai ikuyowei ma inae Jon kurina da Jodan okowinai ibabataito. ");
INSERT INTO pwg_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Ma okowa kamonai igheghetawei na ikita da kunuma itamotate ma Kanuma Vovokaravina iororu kurina, kitana nakanani ma gabubu. ");
INSERT INTO pwg_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ma God gamona kunumai ivona bo, “Tam na natuku vaghata. Tam na nuwanuwaku, ainuwabiibiiyem.” ");
INSERT INTO pwg_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Nani murinai Kanuma Vovokaravina Yesu ivi nowei da maninina inae ku warere. ");
INSERT INTO pwg_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Mara 40 warereyai imakamakai ma nani kamonai Seitan iruruyaghai. Ma Yesu ghamoghamo dipa yavata imakamakai ma aneya ikoyakoyagha bubuni. ");
INSERT INTO pwg_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Jon ku gabura itereruwei ma murinai na Yesu inae ku Gariri dobuna ma God varana biibiina idimadimei. ");
INSERT INTO pwg_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Ivona bo, “Karako na marana vaghata ipisi. God ina vikiivavona namada enenekiibau kurimi. Ami berabero kovinimayei ma komiirikupukuputei. Ma God varana biibiina kovi tumaghanei!” ");
INSERT INTO pwg_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Mara sago Yesu Gariri tokana baranai ibaba inenae da Saimon tina kikei Anduru yavata ikitisi. Ti na wito damsi ma i wito itawetawei. ");
INSERT INTO pwg_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Ma Yesu ivonesi bo, “Kopisi, kokiviniku. Ma ani beyemi da wawaya kona konisi.” ");
INSERT INTO pwg_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Yaghiyaghinai i wito ivoterei ma ikivini. ");
INSERT INTO pwg_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Ma Yesu ibaba gisina inae na Zebedi natunatuna Jemes da Jon ikitisi waka kamonai i wito ivovovunaghi. ");
INSERT INTO pwg_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Yaghiyaghinai ikwatusi ma i mamai ina bigabiga wawayisi yavata waka kamonai ikuyowesi ma Yesu ikivini. ");
INSERT INTO pwg_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Yesu kana kivikivina yavata inae ku Kapeniyam kwanatuna. Ma viyakam marana inekiibau na inae ku kiki numana da irui ma vibeyebeyena ivi karei. ");
INSERT INTO pwg_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Ma wawaya ina vibeyebeyena ivi yanei na ivi deyei, iyamna tuna ke vonaviyoyovana vibeyebeyena wawayisi nakanani. Ivivi beyebeyena na nakanani ma rewapana ghamana gwabinai. ");
INSERT INTO pwg_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Ma tomowa sago ku kiki numana irui ma gwabinai na kanuma berona irunuma. ");
INSERT INTO pwg_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Ma ikiirara bo, “Yesu, Nasaret wawayim! Avi kuna berai kurikai? Kupisi da kuna gwaramutukai, bo? Akovim da tam God ina wawaya vovokaravim!” ");
INSERT INTO pwg_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Ma Yesu kanuma berona iyeghai bo, “Kawam epota. Tomowina kekiibutawei!” ");
INSERT INTO pwg_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Ma kanuma berona tomowina inuke kirakiiyei, ikiirara ma ikiibutawei. ");
INSERT INTO pwg_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Ma wawaya kudubisi ivi deyei. Ma ti mani kamosiyai ivonavona bo, “Ikikava? Vibeyebeyena vuna etereterei na ivi rewapana kirakai. Ma bade kanuma beroberosi kurisi isisiya na evovotekatekei!” ");
INSERT INTO pwg_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Ma yaghiyaghinai sisiyina ikiibau, dobu ine yavui da wawaya peyarisi Gariri kamonai ivi yanei. ");
INSERT INTO pwg_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Yesu ma kana kivikivina kiki numana ikiibutawei ma Jemes da Jon yavata inae Saimon da Anduru i ku numa. ");
INSERT INTO pwg_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Ma Saimon rawana wavinena igubaga, ininina imuyamuya kirakai na ina kepana tepanai ikenakena. Yesu inekiibau na wawaya yaghiyaghinai ivonei da wavinena igubaga. ");
INSERT INTO pwg_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Ma irui kurina, imana iviiya ma ivovimakiini na ininina inuba da iyawasa. Ma ivomiiri da ikoyagha bubunisi. ");
INSERT INTO pwg_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Ravi ipika ma madegha ivokutuvi na kwanatu damsi i wawaya gubagubagisi ma iyavo kava kanuma beroberosi gwabisiyai irunuma na peyarisi irutinapiyesi Yesu kurina. ");
INSERT INTO pwg_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Kwanatu damsi kudubisi numa maghinonai ivi kiidaburana, ");
INSERT INTO pwg_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","ma Yesu wawaya peyarisi kii gubaga bogii ma bogiiyai na ivi yawasisi. Ma bade kanuma beroberosi wawaya gwabisiyai na peyarisi ikwavinisi. Ma kanuma beroberosi ivonatanisi da ke ini sisiya, iyamna iakovi da Yesu na iyai. ");
INSERT INTO pwg_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Mara tomtom didibarinai Yesu ivomiiri numa ikiibutawei inae ku dobu makiiwapana ma nani dobunai iniponipowana. ");
INSERT INTO pwg_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Ma Saimon turaturana yavata ivi karei da Yesu iekewekwai. ");
INSERT INTO pwg_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Ma ipanani na ivonei bo, “Wawaya peyarisi iekwekwim.” ");
INSERT INTO pwg_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Ma Yesu ivonapotesi bo, “Kegha, tanae ku kwanatu viya da bade ti damsi kurisi ana dima. Tuna bigana kubiine apisi.” ");
INSERT INTO pwg_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Vaghina ma Gariri dobuna ine yavui, i kiki numasi kamosiyai idimadima ma kanuma beroberosi wawaya gwabisiyai ikwavikwavinisi. ");
INSERT INTO pwg_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Tomowa sago ipisi Yesu kurina, tuna gubaga berona iviiya da ininina kudubina ivi beroi. Maghinonai ivi tuwaporeruruwana ma ivi nowi bo, “Kuna kayowei na kuni biibiiniku da ana yawasa. Akovim da tam kovokovoghim.” ");
INSERT INTO pwg_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Ma Yesu ivi kamyuyuwei na ivororona da tomowina ivotovoni. Ma ivona bo, “Aivaghinei. Keyawasa.” ");
INSERT INTO pwg_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Ma yaghiyaghinai kana gubaga ikovi da iyawasa. ");
INSERT INTO pwg_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Muriyai da tomowina ita vonatawei ita nae, Yesu ivonatani da ke weni berana iti sisiyei. Ivona bo, ");
INSERT INTO pwg_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Kevi yaneku. Ke kuni mamatara da taku avi yawasim. Kenae taparoro badana kurina da ina kitim da kuyawasa. Ma Moses ina vonaviyoyovana kenunuri da kesuwara. Nakanani wawaya kurisi kuni debe meyem da gubaga gwabimuwai ikovi.” ");
INSERT INTO pwg_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ma kegha, tomowina inae da ikweya wapawapa da wawaya peyarisi varana ivi yanei. Tuna kubiine Yesu ke kovokovoghina da debiiyai ita rui ku kwanatu kamosi ma dobu makiiwapasiyai imakamakai. Ma patana da wawaya peyarisi dobu bogii ma bogiiyai inenae kurina. ");
INSERT INTO pwg_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Mara viya ikovi na Yesu ivovirame ku Kapeniyam kwanatuna. Ma wawaya sisiya ivi yanei da ina ku numa inekiibau. ");
INSERT INTO pwg_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Ma koroto ghamana iriyei kurina da numa kamona itupo ma bade wawaya matariyai matuketa imiiripotei da ke sago taraboga ita makai. Ma Yesu na God vonana idimadimei kurisi. ");
INSERT INTO pwg_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Ma nani kamonai tomotomowa ruwamaruwa inekiibau. Kwinasi digadigana ritowai ipawoi da ita nae Yesu kurina. ");
INSERT INTO pwg_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Ma taraboga kegha da ita neriya kurina iyamna koroto irakata kirakai. Tuna kubiine ipawoi ighae da ku numa tepana ma imapatana Yesu imiimiiri na tepanai taraboga iberai da kwinasi ritowai ivi yoyowi da ioru kurina. ");
INSERT INTO pwg_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Yesu damina iviiya da i vitumaghana irakata kirakai da digadigana kurina ivona bo, “Natuku, am berabero anotatawei.” ");
INSERT INTO pwg_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Ma korotona kamonai na vonaviyoyovana vibeyebeyena wawayisi viya imakamakai. Ma ivivi nuwanotanota bo, ");
INSERT INTO pwg_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Avi kubiine weni tomowina nakanani isisiya? God iavaberowei, iyamna God ina kina kava kovokovoghina da berabero ina notatawei.” ");
INSERT INTO pwg_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Yaghiyaghinai Yesu i nota gavugavusi iakovi na ivonesi bo, “Avi kubiine nakanani koinuwanotanota? ");
INSERT INTO pwg_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Meni sisiyina itekateka? Itekateka da digadigana kurina ata vona bo, ‘Am berabero anotatawei.’ Ma ibagibagi kirakai da kurina ata vona bo, ‘Kevomiiri, am kepana kekavari ma kebaba,’ iyamna matamiyai kona kitai da ina yawasa bo kegha. ");
INSERT INTO pwg_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Bera bagibagina ana berai da ini matakira kurimi da taku Wawaya Natusi aku rewapana dobuwai emakamakai da berabero ana notatawei.” Ma digadigana ivonei bo, ");
INSERT INTO pwg_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Avonavonem, tam kevomiiri, am kepana kekavari ma kebaba kenae am ku numa.” ");
INSERT INTO pwg_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ma tomowina yaghiyaghinai ivomiiri, ina kepana ikavari ma koroto matasiyai ibaba ikiibau. Ma peyarisi ivi deyei ma God ivi ghegheni da ivonavona bo, “Ke meyani bera nakanani kata kitai!” ");
INSERT INTO pwg_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Mara sago Yesu ivovirame ku Gariri tokana. Ma toka baranai na koroto ghamana iriyei kurina, ma ivi karei da ivi beyebeyena kurisi. ");
INSERT INTO pwg_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Ma ibaba inenae da tomowa sago ikitai, tomowina na Arupiyasi natuna Livai. Tuna ina biga gawarinai imakamakai ma teks mane wawaya gwabisiyai iyuyuna. Ma Yesu ivona bo, “Kekiviniku.” Ma vaghina Livai ivomiiri da ikivini. ");
INSERT INTO pwg_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Nani murinai Yesu, Livai ina numiiyai ikamkam. Ma bade koroto ghamana iyavo kava mara nonowa Yesu yavata ibababa, kamosiyai na teks yuyuna wawayisi ma berabero wawayisi, peyarisi na Yesu ma kana kivikivina yavata ikamkam. ");
INSERT INTO pwg_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Ma vonaviyoyovana vibeyebeyena wawayisi Yesu ikitai. Ti na Perisi damsi ma ke iti vaghinei da berabero wawayisi ma teks yuyuna wawayisi yavata ikamkam. Tuna kubiine kana kivikivina ivi tarakiiyanesi bo, “Avi kubiine wawaya beroberosi yavata ekamkam?” ");
INSERT INTO pwg_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Yesu ivi yanesi ma ivonesi bo, “Wawaya yawayawasisi na yaboyabo ke ita kayokayowei, gubagubagisi kava. Ke ata pisi wawaya maninisi kubiisi. Taku apisi da berabero wawayisi ata kwatusi.” ");
INSERT INTO pwg_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Mara sago Jon Babataito kana kivikivina ma Perisi damsi ivivi siya. Ma wawaya viya inae Yesu kurina ma ivona bo, “Avi kubiine kam kivikivina ke ita vivisiya? Perisi damsi kii kivikivina ma Jon kana kivikivina na peyarisi isiya, ma kam kivikivina na kegha.” ");
INSERT INTO pwg_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Ma Yesu miibiiyai ivonapotesi bo, “Tomowa ina tavine na kam ghamana ina terei. Ma nani kamonai turaturana ke ini siya, ti na i tomowa yavata ina kam. ");
INSERT INTO pwg_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Ma marana ina nekiibau da turaturana tomowina ini wapai ma nani maranai visiya ini karei.” ");
INSERT INTO pwg_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Ma sago na ke ita biibai da gara wadubona tamosikana kuta viiya ma gara vuna sinamina na wadubona tepanai kuta terei ma kuta popopotai. Kuta kowai na gara vuna na ita gisi ma katamanina na kegha da tarabogina ita tinavinabanabai. ");
INSERT INTO pwg_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Ma bade ke ita biibai da wain vuna kuna tepoi ghamoghamo bekana katamanina ku kamona, iyamna beka katamanina na bagibagina. Ke kovokovoghina da ita rakata maranai wain kamonai ina puropuro ma ina dodo. Kuta berai na beka iti kwata, ma wain yavata peyarina iti beroi. Tuna kubiine mara nonowa wain vuna ku beka vuna pikapikana tatepoi da ina makai bubuna.” ");
INSERT INTO pwg_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Viyakam marana sago Yesu kana kivikivina yavata ibababa ma keta na vao sago itupakiiyaraghi, kamonai na whiti. Ma kana kivikivina ivi karei da whiti vavina ivivi tinamuyana ma ikamkam. ");
INSERT INTO pwg_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Ma Perisi damsi Yesu kurina ivona bo, “Kekitisi, vonaviyoyovana ikiigiiyei. Karako na viyakam marana ma evovobagibagi.” ");
INSERT INTO pwg_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Ma ivonapotesi bo, “Giruma katamana kovi yavi na kotakova bubuni da aviyavisina ita kaekiki David iberai maranai turaturana yavata vitonara ikarakarisi. ");
INSERT INTO pwg_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Taparoro badana ghamana Abiyata ina mariyai na Kiivavo David irui God ina ku Taparoro Numana ma suwara parawina iviiya da ikani. Ma bade turaturana iveresi da ti yavata ikani. Ma vonaviyoyovana kamonai iterei da suwara parawina na vovokaravina ma taparoro babadisi kava ita kani ma kegha da David ivi kiigiiyei.” ");
INSERT INTO pwg_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Muriyai ivonesi bo, “Wawaya iyamonisi ma kubiisi viyakam marana iterei da iti vitesi. Ma ke viyakam marana ita terei iti nao ma muriyai wawaya ita yamonisi. ");
INSERT INTO pwg_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Ma Wawaya Natusi na Bada. Ma nani kamonai na bade viyakam marana ibadei.” ");
INSERT INTO pwg_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Viyakam marana sago na Yesu ivovirame ku kiki numana. Ma numana kamonai na tomowa sago imana gibegibesina. ");
INSERT INTO pwg_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Ma Perisi damsi viya keta iekwekwai da ikikava Yesu iti wavui. Tuna kubiine ikitakita bogai da nani gibegibesina iti yawasi bo kegha. Viyakam maranai iti yawasi na vonaviyoyovana iti kiigiiyei. ");
INSERT INTO pwg_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Ma Yesu gibegibesina ivonei bo, “Kepisi wike da koroto maghinosiyai kuna miiri.” ");
INSERT INTO pwg_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Ma Perisi damsi ivi tarakiiyanesi bo, “Vonaviyoyovana kamonai na aviyavisina ivi vaghinei da viyakam maranai kata berai? Bera biibiisi bo bera beroberosi? Wawaya tiyawasisi bo takiiviberosi?” Ma ti na kawasi ipota. ");
INSERT INTO pwg_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Yesu ikitavirevire ma nuwanuwana ipughu kurisi. Ma bade nuwanuwana idugara kirakiiyei da nuwanuwasi na gudugudusi. Ma nani gibegibesina ivonei bo, “Kevororona.” Ivororona ma imana iyawasa. ");
INSERT INTO pwg_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Ma Perisi damsi ikiibau inae Kiivavo Herodi ina wawaya kurisi. Ma yavata ivivi ogatara da ikikava Yesu iti raboboi. ");
INSERT INTO pwg_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Yesu ma kana kivikivina ikiibau inae ku Gariri Tokana. Ma Gariri damsi peyarisi ikivini. ");
INSERT INTO pwg_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Ma bade koroto ghamana Yesu sisiyina ivi yanei da dobu rabarabai ipisi. I dobu na Judiya dobuna, Jerusalem, Idumeya dobuna, Taya ma Saidon kwanatusi ma dobu viya Jodan okowina nevanai. ");
INSERT INTO pwg_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Koroto irakata kirakai da Yesu kana kivikivina ivonesi da waka gisina ita tinapiyei da maranai koroto ita riyatawei na ita geru. ");
INSERT INTO pwg_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Wawaya ipeyari namada ivi yawasisi tuna kubiine gubagubagisi peyarisi ivivi riya kurina da ita votovoni. ");
INSERT INTO pwg_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Ma wawaya viya kanuma beroberosi gwabisiyai irunuma na ti damsi Yesu ikitai ma maghinonai itawotawotesi ma ikiikiirara bo, “Tam God Natuna!” ");
INSERT INTO pwg_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ma Yesu iyeghisi da ke iti mamatara da tuna iyai. ");
INSERT INTO pwg_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Yesu ighae ku koya barana ma ina kayowana wawayisi ikwatusi da ita pisi kurina na wawayisi ighae. ");
INSERT INTO pwg_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Ma ivi 12 ivinesi da ti na ina aposol da yavata ita makai ma ita baba. Ma bade ita vonatawesi da ita dima, ");
INSERT INTO pwg_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","ma rewapana ita veresi da kanuma beroberosi ita kwavinisi. ");
INSERT INTO pwg_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Tomotomowisi ivi 12 kii vava na weni. Saimon, tuna na Yesu ivi vavei Pita, ");
INSERT INTO pwg_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","ma Zebedi natunatuna Jemes ma Jon, ti na Yesu ivi vavesi Bowanajesi, vavana iyamna warikeyakeya natunatuna. Ma bade ");
INSERT INTO pwg_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Anduru, Piripo, Batoromiya, Matiu, Tomas, Arupiyasi natuna Jemes, Tadiyas, Saimon, tuna Zelote wawayina, ");
INSERT INTO pwg_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ma Judas Iskariyot, tuna wawayina karakava Yesu ini wawanei. ");
INSERT INTO pwg_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Yesu ku numa irui, ma bade koroto ghamana iriyei kurina da ke kovokovoghina da tuna ma kana kivikivina yavata ita kam. ");
INSERT INTO pwg_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Ma ina rakaraka ivi yanei da ikikava Yesu imakamakai na ipisi da ita rutinatawei. Ma ivona bo, “Yesu ineghanegha.” ");
INSERT INTO pwg_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Ma vonaviyoyovana vibeyebeyena wawayisi viya Jerusalem kwanatunai ipisi ma ivonavona bo, “Berusiburu Yesu itowatepani. Tuna na kanuma beroberosi i kiivavo ma rewapana iverei da kanuma beroberosi erurukwavina.” ");
INSERT INTO pwg_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Ma Yesu ikwatusi ipisi kurina ma miibiiyai ivi sisiya kurisi, ivona bo, “Avi kubiine Seitan ina vomiiri da Seitan ina kwavini? ");
INSERT INTO pwg_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Mikeda dobu sago kamonai wawaya ita totoi da ti mani kavakava kamosiyai iti ghaviya na i rewapana ita gisi ma peyarisi ita peku. ");
INSERT INTO pwg_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Bo mikeda rakaraka sago kamonai wawaya iti kawapata na ke kovokovoghina da nani rakarakana ita miirikikina. ");
INSERT INTO pwg_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ma bade nakanani Seitan tuna mani ina wawaya yavata iti kawapata na ke kovokovoghina da ita miirikikina, ita peku.” ");
INSERT INTO pwg_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Ma Yesu miiba sago iterei, ivona bo, “Wawaya ita rui tomowa rewapanina ina ku numa da ina sawara ita yapi na kunona tomowina imana ma kaena ita patumi ma muriyai da ina numa ita rikai da ita yapi.” ");
INSERT INTO pwg_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Ma vonavaghata avonavonemi da God wawaya i berabero ma i avabero bogii ma bogiiyai ina notatawei ");
INSERT INTO pwg_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","ma berabero sago kava na ibero kirakai da ke meyani ina notatawei. Iyavo kava Kanuma Vovokaravina ini avaberowei na i berabero na makamakii nonowina.” ");
INSERT INTO pwg_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Wawaya ivonavona da kanuma berona Yesu itowatepani, tuna kubiine weni sisiyisi iterei. ");
INSERT INTO pwg_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Ma Yesu ina maduwa ma titina yoghoyogho inekiibau da matarai imiimiiri, ma sisiya ivonatawei da Yesu ita kiibau. ");
INSERT INTO pwg_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Koroto ghamana Yesu imakiigwagwari ma wawaya ivonei bo, “Am maduwa ma titim yoghoyogho matarai na ekwekwim.” ");
INSERT INTO pwg_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Ma Yesu ivonapotesi bo, “Aku maduwa ma titiku yoghoyogho na iyavo?” ");
INSERT INTO pwg_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Ma nani korotona ikitaviraviresi ma ivonesi bo, “Aku maduwa ma titiku yoghoyogho na weni. ");
INSERT INTO pwg_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Iyavo kava God ina kayowana evovotekatekei, ti na titiku yoghoyogho ma novunovuku ma aku maduwa.” ");
INSERT INTO pwg_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Mara sago Gariri tokana baranai na Yesu vibeyebeyena ivi karei. Ma wawaya peyarisi iriyei kurina da koroto irakata kirakai na Yesu ku waka igeru ma imakiivipika. Ma korotona toka baranai imakai. ");
INSERT INTO pwg_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Yesu miibiiyai ivi beyebeyena kurisi, kamonai na akova bogii ma bogiiyai. Ivona bo, ");
INSERT INTO pwg_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Kovi yana. Mara sago, tomowa inae da ina whiti peina ita voni. ");
INSERT INTO pwg_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Ma peina ivivi busagha da viya ketiyai iririgha ma kiu ipisi da ikani. ");
INSERT INTO pwg_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Ma viya tano wakiwakiminai iririgha da kana tano ke ita rakata. Tuna kubiine yaghiyaghinai ituwepa ");
INSERT INTO pwg_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","ma kegha da madegha iraranisi na isivisivi, iyamna ramramsi kegha. ");
INSERT INTO pwg_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Ma viya iyiyo kamosiyai iririgha da igogo. Ma iyiyo yaghiyaghinai ighae ma irogusi da ke iti yam. ");
INSERT INTO pwg_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Ma viya tano biibiinai iririgha ma igogo ighae ma iuwa bubuna, da pei sago sago duma amesi iterei da viya 30, viya 60, ma viya 100.” ");
INSERT INTO pwg_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Muriyai Yesu ivonesi bo, “Wawaya ere tinimi na aku sisiya kovi yana bogai.” ");
INSERT INTO pwg_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Yesu ina kina kava imakamakai na ina wawaya ivi 12 ma iyavo kava mara nonowa ikivikivini na ipisi kurina, ma ivi tarakiiyanei da ina miiba na iyamsi avai. ");
INSERT INTO pwg_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Ma ivonesi bo, “Akova gavugavuna God ina vikiivavona kamonai na tami kurimi aidebei da konakovi. Ma iyavo kava kupunai na miibiiyai aisisiya kurisi. ");
INSERT INTO pwg_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Peroveta Aisaya igiruma bo, ‘Ina kita ma ina kita ma ke ina kitai. Ini yana ma ini yana ma iyamna ke ina viiya. Ita kita ma iti yana na i berabero ita takuputei ma ita miiritavire God kurina na i berabero ita notatawei.’” ");
INSERT INTO pwg_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Muriyai Yesu ivonesi bo, “Weni miibiina iyamna ke kotakovi na ikikava miiba viya konakovi? ");
INSERT INTO pwg_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Nani tomowina pei ivivi busagha na God varana idimadimei. ");
INSERT INTO pwg_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Ma wawaya viya na nakanani ma pei ketiyai. God varana ivi yanei ma Seitan yaghiyaghinai ipisi na vonana gwabisiyai iviitawei. ");
INSERT INTO pwg_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Ma wawaya viya nakanani ma pei tano wakiwakimina tepanai. God varana ivi yanei ma nuwabiibiiyai iviiya. ");
INSERT INTO pwg_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Ma ramramsi kegha, iyamna sisiyisi nuwatepasiyai ivi vaghinei. Imakai da ke mara gurina ma i vitumaghana kubiine wawaya ivi tupaketowanesi bo nuwapoya ipanani na yaghiyaghinai God varana ibarei. ");
INSERT INTO pwg_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Ma viya nakanani ma pei iyiyo kamosiyai. God varana ivi yanei ");
INSERT INTO pwg_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","ma nuwapoya i yawasa kamonai inotanota kirakiiyei, dobu ina mura imatamatighei ma sawara biibiisi ikirokirorowei da God varana irogui ma amesi kegha. ");
INSERT INTO pwg_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ma viya nakanani ma pei tano biibiinai. God varana ivi yanei, ivi vaghinei ma ivi tumaghanei. Ti na nakanani ma pei igogo ighae, sago sago duma amesi iterei da 30, 60 bo 100.” ");
INSERT INTO pwg_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Ma Yesu ivonesi bo, “Wawaya rampa karakaratina ina kavarapiyei na meni dobunai ina terei? Ke bayawa vivikuratabuna gaburinai ina terei. Ma bade ke kemakema gaburinai ina terei. Kegha, gawara yagharinai ini rorokei da ina ruyasegana. ");
INSERT INTO pwg_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Ma akova gavugavuna kudubina ina rudeba. God varana biibiina ke gavugavuna ina makai, kudubina ina rupamatawei da wawaya inakova bubuni. ");
INSERT INTO pwg_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Wawaya ere tinimi na aku sisiya kovi yana bogai.” ");
INSERT INTO pwg_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","“Sisiya koni yana bubuna ma nuwanuwami koni tete bubuni na iyamna kona panani. Akova gisi vaghina kunekwai na kuna panani ma God akova ku tepana ina terei. ");
INSERT INTO pwg_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Iyavo kava akova gwabisiyai emakamakai na ku tepana ina veresi. Ma iyavo kava akova gwabisiyai irekwei na kudubina ina viitawei.” ");
INSERT INTO pwg_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Ma Yesu miiba sago iterei, ivona bo, “God ina vikiivavona na weni nakanani. Tomowa ina whiti peina irubusagha vao kamonai. ");
INSERT INTO pwg_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Ma tomowina didibarai ikenakena ma mariyai na ivovomiiri ma ivovobagibagi kupom ma nani kamonai peina igogogo ma igheghae. Ma tomowina na ivivi nuwanotanota da ikikava pei na egogogo. ");
INSERT INTO pwg_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Tano muina na biibiina, tuna kubiine pei igogo ighae da iuwa. Kunona kunukununa iterei, muriyai tanana iterei, muriyai na amena iterei. ");
INSERT INTO pwg_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ma vaghina, amena imagura da bori kana mara inekiibau ma tomowina inae da whiti iboriya.” ");
INSERT INTO pwg_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Ma bade Yesu ivona bo, “God ina vikiivavona na ikikava ani sisiyei kurimi? Kade miiba sago ana terei da konakovi. ");
INSERT INTO pwg_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Tuna na kiiroko peina nakanani. Tuna gisina ma kegha da ");
INSERT INTO pwg_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","kuna voni ma ina ghae ina rakata kirakai da pei peyarina vao kamonai ina ghekuyowesi. Ini ruragharagha da ragharaghana ghamaghamasi. Ma kiu ina pisi da tepanai ina towa ma rogunai ini yakam.” ");
INSERT INTO pwg_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Ma vaghina, nakanani Yesu miiba bogii ma bogiiyai ivivi beyebeyena kurisi da ti na akova ghamana ma ruvasi kava iviiya. ");
INSERT INTO pwg_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Ke meyani iti sisiyota koroto ghamana kurisi, ina vibeyebeyena peyarina na miiba kavakava. Ma maranai kana kivikivina kava gwabinai imakamakai na miibiisi peyarina ivivi debei kurisi. ");
INSERT INTO pwg_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Ravi ipika ma Yesu kana kivikivina ivonesi bo, “Tadamana ku toka nevana.” ");
INSERT INTO pwg_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Yesu namada waka tepanai ma kana kivikivina bade ku wakana igeru da yavata inae, koroto ghamana kikirai ikuyowesi. Ma waka viya na yavata inae. ");
INSERT INTO pwg_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Idamadamana ma yanunu ghamana yaghiyaghina ivomiiri ma tovava irakata da irui ku waka kamona da gisina kava ita monu. ");
INSERT INTO pwg_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Ma Yesu na namada ivi kunuwana da ikena nunuwapa ma kana kivikivina ikiimataki ma ivonei bo, “Bada, tamonumonu! Tuma dodo! Kinuwapoyekai bo kegha?” ");
INSERT INTO pwg_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Ma Yesu ivomiiri da yanunu ma tovava iyeghisi bo, “Kovi raborabobo!” Ma yaghiyaghinai yanunu ivoterei. Ma biimara ikena. ");
INSERT INTO pwg_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Ma kana kivikivina kurisi ivona bo, “Avi kubiine koyabuyabumana? Patana da ke kota vivitumaghaneku, bo?” ");
INSERT INTO pwg_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ma kegha, peyarisi iyabumana kirakai ma ti mani kamosiyai ivivi sisiya karakarava bo, “Wena avi tomowina da bade yanunu ma tovava evovotekatekei!” ");
INSERT INTO pwg_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Yesu kana kivikivina yavata Gariri tokana idamani ma iwota. Dobuna kana vava Gerasa. ");
INSERT INTO pwg_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Yesu wakiiyai iororu na yaghiyaghinai tomowa sago iverupotei. Tomowina na kanuma berona gwabinai irunuma ma karawaga kamonai ikiibau. ");
INSERT INTO pwg_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Mara nonowa karawaga bubana kamosiyai ivivi makiiyana ma wawaya ikutatana kavai. ");
INSERT INTO pwg_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Mara ipeyari imana ma kaena ikutatani ma kegha da chein imanai iyaraghi ma kirama sawarisi kaena ipatumi na ivi kiigiiyana. Ma ke kovokovoghina da wawaya ita kuvipikapikai. ");
INSERT INTO pwg_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Didibarai ma mariyai tomowina na karawagai ma koyiyai ikiikiirara yawara ma tuna mani wakimiyai irigharigha meyei. ");
INSERT INTO pwg_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Tomowina ikitataweyana da Yesu ikitai. Iverau da ku maghinona ma ivi tuwaporeruruwana ma maghighina ioru ku tano. ");
INSERT INTO pwg_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Ma ikiirara bo, “Yesu, tam God Kiidamo Makamakiina Natuna. Avi kuna berai kuriku? Ainowi kurim da God avanai kuni vaghinei da kovogha ke kuna vereku.” ");
INSERT INTO pwg_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Nakanani ivi sisiya iyamna Yesu namada ivona bo, “Kanuma berom, weni tomowina kekiibutawei.” ");
INSERT INTO pwg_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Ma Yesu ivi tarakiiyana bo, “Kam vava iyai?” Ma ivonapotei bo, “Kakii vava Koroto Ghamana, iyamna kapeyari kirakai weni tomowina gwabinai karunuma.” ");
INSERT INTO pwg_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ma ivi nowi kirakai da Yesu ke ita kwavinisi da nani dobuna ita kuyowei. ");
INSERT INTO pwg_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Ma poro yavona ghamana ke ita rabaraba, ti na koya baranai ikamkam. ");
INSERT INTO pwg_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Ma kanuma beroberosi Yesu kurina ivi nowi bo, “Nani porosi kurisi kuna vonatawekai. Ma kuni vaghinekai da gwabisiyai kana runuma.” ");
INSERT INTO pwg_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Ivi vaghinei na peyarisi tomowina ikiibutawei da inae poro kurisi. Ma nani porosi ivi 2 tausan na iverau ioru ku kiiyagirina ma itawesi ku okowa da iuma dodo. ");
INSERT INTO pwg_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Ma poro kii koyakoyagha iverau inae da wawaya kwanatu kamonai ma bade dipiiyai ivonaveresi. Ma peyarisi ikiibau da aviyavisina itupuwa na matasiyai ita ikitai. ");
INSERT INTO pwg_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Yesu kurina inekiibau ma tomowina kanuma beroberosi ikiibutawei na ikitai da tuna Yesu ririnai imakamakai, ivi gara ma gayamina ibiibai. Ikitai na peyarisi iyabumana. ");
INSERT INTO pwg_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Ma iyavo kava bera kudubina ikitai na turaturasi ivi mamataresi da aviyavisina itupuwa tomowina kurina ma bade poro kurisi. ");
INSERT INTO pwg_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Ma peyarisi ivi karei da Yesu ivonavonei da i dobu ita kiibukuyowei. ");
INSERT INTO pwg_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Yesu ku waka igerugeru da ita nae ma nani tomowina kanuma beroberosi ikiibutawei na ivi nowi da yavata ita nae. ");
INSERT INTO pwg_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Ma Yesu ke iti vaghinei, ivonapotei bo, “Kegha, kenae am ku numa ma am rakaraka kuna vonesi da aviyavisina Bada iberai kurim. Kevi akovisi da ivi kamyuyuwem.” ");
INSERT INTO pwg_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Ma vaghina, tomowina inae ma Dekapolis dobunai ivivi mamatara meyei da Yesu ivi yawasi. Ma wawaya peyarisi ivi deyei. ");
INSERT INTO pwg_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Yesu idamaname ku Gariri tokana nevana na toka baranai koroto ghamana iriyei kurina da imiirigwagwari. ");
INSERT INTO pwg_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Ma bade kiki numana badana sago kana vava Jairas ipisi. Tuna Yesu ikitai na maghinonai itawotei da ivi tuwaporeruruwana, ");
INSERT INTO pwg_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","ma ere nuwadugarina natuna gisina kubiine ivi nowi kirakai, ivona bo, “Natuku wavinena igubaga kirakai da gisina kava ina rabobo. Kade kuta pisi, imam ku tepana kuta terei da ita yawasa.” ");
INSERT INTO pwg_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Ma Yesu ivomiiri da yavata inae. Ma koroto ghamana ikivinisi da ivi kiitabitabirana. ");
INSERT INTO pwg_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Ma wavine sago gubagubagina nani korotona kamonai. Kana gubaga na nawaravi iviiya ma tarana iverau da madegha 12 ikovi. ");
INSERT INTO pwg_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Yaboyabo ipeyari ivi miiyesi ma ibunama kavai, ke ita yawasa. Ina mura kudubina ivi kovini ma kegha da kana gubaga irakata. ");
INSERT INTO pwg_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Ivi yanei da Yesu wawaya ivivi yawasisi, tuna kubiine koroto kamonai tuna murinai ipisi ma kana gara ivotovoni. ");
INSERT INTO pwg_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Inotai bo, “Kana gara kava ana votovonotei na ana yawasa.” ");
INSERT INTO pwg_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Yaghiyaghinai tarana veru ivoterei ma damina iviiya da iyawasa. ");
INSERT INTO pwg_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Ma bade Yesu damina iviiya da rewapana gwabinai ikiibau. Wawaya kamosiyai imiiritavire ma ivi tarakiiyanesi bo, “Iyi kaku gara ivotovoni?” ");
INSERT INTO pwg_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ma kana kivikivina ivonapotei bo, “Kekitai da koroto ikiitabitabirana. Avi kubiine kuvi tarakiiyana da iyi ivotovonim?” ");
INSERT INTO pwg_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Ma Yesu patana da ikitakitavirevire da iyi iberai. ");
INSERT INTO pwg_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Ma wavinena iakovi da aviyavisina itupuwa kurina ma ipisi Yesu kurina da maghinonai ivi tuwaporeruruwana ma maghighina ioru ku tano. Iyabumana kirakai ma ere kirokirorona vonavaghata kudubina ivi mamatarei. ");
INSERT INTO pwg_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Ma Yesu ivona bo, “Wavine, am vitumaghana kubiine kuyawasa. Nuwanubiiyai kenae. Weni gubagina kamonai kuvovokwarakwara na karako kukiibutawei.” ");
INSERT INTO pwg_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Yesu ivivi sisiya ma nani kamonai Jairas turaturana ipisi ma ivonei bo, “Natum namada irabobo. Ita vibeyebeyena wawayina kitinaviravirai. Kevoterei ma tanae.” ");
INSERT INTO pwg_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Ma Yesu ivi yanatawesi ma Jairas kurina ivona bo, “Ke kuna yabumana. Kevi tumaghaneku.” ");
INSERT INTO pwg_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Ma Yesu koroto ivonatanisi da ke ita kivini ma wawaya aroba kava ivinesi da yavata ita nae. Ti na Pita, Jemes ma Jon (tuna na Jemes tina kikei). ");
INSERT INTO pwg_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Jairas ina ku numa inekiibau na Yesu nipu ghamana ivi yanei, wawaya itutuwenoweno ma isiyasiyapa. ");
INSERT INTO pwg_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Irui ma ivonesi bo, “Avi kubiine kotutou ma kosiyasiyapa? Kovoterei! Wawaya kikei ke ita rabobo, ekenakena.” ");
INSERT INTO pwg_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ma wawayisi Yesu ivi namei. Ikwavinisi ikiibau da wavine kikei ina mamai, ina maduwa, ma kana kivikivina ivi aroba na ti kava irutinisi da irui wavine kikei kurina. ");
INSERT INTO pwg_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Imana iviini ma ivonei bo, “Talitha, koum” iyamna “Wavine kikei, kevomiiri.” ");
INSERT INTO pwg_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Yaghiyaghinai ivomiiri ma ibaba tovotovona ma peyarisi inotakavakavai. Ma wavine kikei iyawasa na kana madegha na 12. ");
INSERT INTO pwg_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Nani murinai Yesu peyarisi ivonatanisi da aviyavisina itupuwa na ke ini mamatara. Ma ivonesi da wavine kikei vavai ita verei da ita kam. ");
INSERT INTO pwg_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Yesu nani dobuna ikuyowei ma kana kivikivina yavata inae ina ku dobu, ku Nasaret kwanatuna. ");
INSERT INTO pwg_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Ma viyakam maranai irui ku kiki numana ma ivi karei da ivivi beyebeyena wawaya kurisi. Peyarisi ivivi yanei na ivivi deyei ma ivonavona bo, “Ina akova na ikikava iviiya? Ma rewapana imapatana iviiya da bera ghamaghamasi eberaberai? ");
INSERT INTO pwg_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Tuna na vonura tomowina. Ina maduwa na Meri ma titina yoghoyogho na Jemes, Josepa, Judas ma Saimon ma bade novunovuna na weni, yavata tamakamakai.” Ma wawayisi na Yesu ibarei. ");
INSERT INTO pwg_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Ma ivonesi bo, “Dobu ku kudubina dam peyarina God ina peroperoveta evovokaravei. Ma tuna mani ina kwanatu kamonai, kana dam ma ina rakaraka vaghata ke ita vovokaravei.” ");
INSERT INTO pwg_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Tuna kubiine Nasaret kamonai gubagubagisi viya kava ivotovonisi da ivi yawasisi. Ma ke kovokovoghina da bera ghamaghamasi ita berai. ");
INSERT INTO pwg_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Ma inotakavakavai da wawayisi ke iti tumaghanei. Ma Yesu baba ivi karei da kwanatu nununai ivivi beyebeyena. ");
INSERT INTO pwg_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Nani kamonai, kana kivikivina ivi 12 ikwaturiyariyesi. Ma ivonatawesi da ruwa ruwa ita kiibau ma bade rewapana iveresi da kanuma beroberosi ita kwavinisi. ");
INSERT INTO pwg_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Ma ivonesi da i diwona ita yuna ma ke sago avai ku tepana ita kavari. Ke vavai, ke kutu, ke mane bo ke gara viya, kegha. ");
INSERT INTO pwg_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Ma ivi vaghinei da kaesi kii terepapara iti kote. ");
INSERT INTO pwg_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ma ivonesi bo, “Ku kwanatu sago kona rui na meni wawayina ini kiikiiwemi ma ina rutinimi ina ku numa da kana numataya, tuna yavata komakai da ami ku vomiiri marana. ");
INSERT INTO pwg_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Ma meni kwanatuna kamonai wawaya ke ini kiikiiwemi ma ami dima ke ini yanei na kovoteresi. Kaevunavunami kovi turirighakuyowei ma konae. Ini matakira da kovogha ina viiya.” ");
INSERT INTO pwg_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Ma kana kivikivina ivomiiri ikiibau ma wawaya kurisi idima da i berabero itinimayei ma ita miirikupukuputei. ");
INSERT INTO pwg_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Ma kanuma beroberosi peyarisi ikwavinisi da wawaya ikiibutawesi. Ma bade oira ikavari da wawaya gubagubagisi peyarisi ivi kununubisi da ivi yawasisi. ");
INSERT INTO pwg_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Wawaya peyarisi Yesu ivivi sisiyei na Kiivavo Herodi varana ivi yanei. Ma viya ivonavona bo, “Yesu tuna na Jon Babataito. Irabobo ma ivomiiri, tuna kubiine rewapana gwabinai da nani berasi ghamaghamasi eberaberai.” ");
INSERT INTO pwg_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Ma wawaya viya ivonavona bo, “Tuna na Elaidiya.” Ma bade viya ivonavona bo, “Tuna na God ina peroveta, nakanani ma peroperoveta mara katamaninai.” ");
INSERT INTO pwg_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Kiivavo Herodi sisiyisi ivi yanei na ivona bo, “Jon iwana akiiyaraghi ma rabobowai ivomiiri, bo?” ");
INSERT INTO pwg_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Jon ina rabobo weni nakanani itupuwa. Kiivavo Herodi ina seri wawayisi ivonatawesi da Jon ivotani, ipatumi ma ku gabura iterei. Herodiyasi kubiine na nakanani iberai, iyamna tuna wavinena na varesina Piripo kawana ma ivi tuneboi. ");
INSERT INTO pwg_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Ma Jon mara nonowa Kiivavo Herodi kurina ivonavona bo, “Varesim kawana kuvi tuneboi na God ina vonaviyoyovana kovi kiigiiyei.” ");
INSERT INTO pwg_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Tuna kubiine Herodiyasi mara nonowa nuwanuwana ipughupughu ma ina kayowana da Jon ita kiivunui. Ma kegha da Kiivavo Herodi kana papara ivowai da ku gabura iterei na Herodiyasi ke kovokovoghina da ita kiivunui. ");
INSERT INTO pwg_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Kiivavo Herodi iakovi da Jon na God ina wawaya maninina ma vovokaravina, tuna kubiine iyabuyabumanei. Ina kayowana ghamana da Jon ina sisiya iti yanei ma kegha da ivivi yana na notaragharagha gwabinai irakata. ");
INSERT INTO pwg_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Ma mara sago Herodiyasi keta ipanani da Jon ita kiivunui. Kiivavo Herodi ina tupuwa marana kubiine kam ghamana iterei. Wawaya ghamaghamasi ipisi, ti na iyavo kava Kiivavo Herodi gaburinai dobu ivivi badei ma seri wawayisi i babada ma bade Gariri dobuna ina kiikiivavo. ");
INSERT INTO pwg_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Ma Herodiyasi natuna wiwikena irui ma iriku da Kiivavo Herodi turaturana yavata nuwanuwasi ivii kirakiiyei. Ma Kiivavo Herodi wiwikena ivonei bo, “Ana puyom. Am kayowana avai? Kevoneku ma ana verem. ");
INSERT INTO pwg_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","God matanai vonakiiyapa bagibagina atereterei da am kayowana avai na ana puyom. Kuna vona na aku mura nevanevana ana verem.” ");
INSERT INTO pwg_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Ma wiwikena ikiibau ma ina maduwa ivi tarakiiyanei bo, “Aviyavisina ani nowi da ina vereku?” Ma ivonapotei bo, “Kevi nowi da Jon Babataito gayamina ina verem.” ");
INSERT INTO pwg_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Maninina irui Kiivavo Herodi kurina ma ivonei bo, “Akayokayowei da wekarakava Jon Babataito gayamina kuna kiiyaraghi da ku dabira kunuwani ma kuna vereku.” ");
INSERT INTO pwg_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Ma Kiivavo Herodi ivi nuwapoya kirakai. Ma namada babada turaturana peyarisi ina vonakiiyapa bagibagina ivi yanei, tuna kubiine ke kovokovoghina da iti kegha. ");
INSERT INTO pwg_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Vaghina ma yaghiyaghinai taravunuwa tomowina ikwatu ipisi. Ma ivonei da Jon gayamina ita kiiyaraghi ma ita kavarapiyei. Tomowina inae ma gabura kamonai Jon iwana ikiiyaraghatawei, ");
INSERT INTO pwg_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","ma gayamina ku dabira iuwani ma ikavaraneyei wiwikena kurina da iverei. Ma wiwikena ikavari ikiibau da ina maduwa iverei. ");
INSERT INTO pwg_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Ma Jon kana kivikivina ivi yanei da irabobo na ipisi ma tupuwina ikavari ku karawaga da buba kamonai iterei. ");
INSERT INTO pwg_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Aposols ivi 12 ibaba ikovi na ivovira Yesu kurina ma ivonaverei da avi kava iberai ma ivi beyebeyena. ");
INSERT INTO pwg_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Ma wawaya peyarisi ipipisi ma inenae da taraboga kegha da Yesu ma ina aposol ita kam. Tuna kubiine Yesu ivonesi bo, “Tota kavakava tanae ku gawara makiiwapana, tamakiitaweyana da tiyakam.” ");
INSERT INTO pwg_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Ma ina aposol yavata wakiiyai igeru da ivomiiri. ");
INSERT INTO pwg_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Ma kegha da wawaya peyarisi ikitisi da inenae na ivogiinisi. Tuna kubiine wawaya i kwanatu bogii ma bogiiyai kaetanowai iverau. Ivi nao da makii katamanisi ma murisiyai Yesu ina aposol yavata inekiibau. ");
INSERT INTO pwg_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Yesu iwota ma koroto ghamana ikitisi da ivi kamyuyuwesi, iyamna kii kita nakanani ma sipu kii koyakoyagha kegha. Tuna kubiine ivi karei da kurisi na vibeyebeyena bogii ma bogiiyai iberaberai. ");
INSERT INTO pwg_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Ravi ipika na kana kivikivina ipisi ma Yesu kurina ivona bo, “Weni dobuna na makiiwapana ma namada mara ikovi. ");
INSERT INTO pwg_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Wawaya kevonatawesi ina nae da iyavo kava ririnai emakamakai, ti na kwanatu viya kamosiyai ma bade dipiiyai na gwabisiyai vavai ina gimara da ina kam.” ");
INSERT INTO pwg_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Ma Yesu ivonapotesi bo, “Kegha. Tami vavai koveresi da ina kam.” Ma ivonapotei bo, “Te! Mane irakata ghagha! Imapatana taviiya da parawa tagimari ma weni korotona tikanisi?” ");
INSERT INTO pwg_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Ma Yesu ivi tarakiiyanesi bo, “Parawa viya gwabimiyai? Konae da kona kitai.” Ikitai ikovi ma ivona bo, “Parawa miikovi ma iyana ruwa weni.” ");
INSERT INTO pwg_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Muriyai kana kivikivina ivonesi da koroto ghamana ita yaraghi da i gawara nununai ita makai. ");
INSERT INTO pwg_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Ma vaghina, nani korotona iyaraghi da viya na 100 ma viya na 50. Ma peyarisi inamona tepanai imakiipika. ");
INSERT INTO pwg_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Ma Yesu na parawa miikovi ma iyana ruwa iviiya ma itepa ku kunuma da God ivi kiikiiwei. Ma parawa ivogimai ma kana kivikivina iveresi da ita rereghi koroto ghamana kurisi. Ma bade iyana ivogiiya ma iveresi da irereghi. ");
INSERT INTO pwg_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ma peyarisi ikam da ikam dodo. ");
INSERT INTO pwg_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Ma murinai kana kivikivina puwata iyuna da kode 12 ivi tupoi. ");
INSERT INTO pwg_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Ma nani korotona kamonai tomotomowa kava ivi yavi na 5 tausan. ");
INSERT INTO pwg_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Yaghiyaghinai Yesu kana kivikivina ivi gerusi ma ivonatawesi ivi nao da Gariri tokana ita damana ku Betsaida kwanatuna. Ma tuna ita makai da koroto ita vonatawesi ita nae. ");
INSERT INTO pwg_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Koroto ivi kiruruwesi ikovi na ighae ku koya da ita nipowana. ");
INSERT INTO pwg_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Ivi didibari ma i waka na toka basunai. Ma Yesu ina kina kava na tanowai ");
INSERT INTO pwg_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","ma ikitataweyana da kana kivikivina wakiiyai ivivi paparana, yanunu ivoivoi potepotei. Mara tomtom nubakutuvina kamonai, Yesu okowa tepanai ibaba inenae da namada kurisi inenekiibau. Ita kiivuresi iti nao ");
INSERT INTO pwg_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","ma kana kivikivina ikitai da wawaya sago okowa tepanai ibababa, ma ti inotai da momosika da peyarisi ikiirara ");
INSERT INTO pwg_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","ma iyabumana kirakai. Yaghiyaghinai ivonesi bo, “Ami nota ke ina gisi. Wena taku. Ke kona yabumana.” ");
INSERT INTO pwg_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Muriyai ku waka igeru ma yanunu inuba. Ma kana kivikivina inota kavakavai, ");
INSERT INTO pwg_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","iyamna ikikava Yesu parawa iviiya da bera ghamana iberai na ke ita nota kamowi. Nuwanuwasi patana da guduguduna. ");
INSERT INTO pwg_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Yesu kana kivikivina yavata toka idamani ku dobu kana vava Genesaret ma iwota. ");
INSERT INTO pwg_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Wakiiyai iororu ma yaghiyaghinai wawaya ivogiini da tuna Yesu. ");
INSERT INTO pwg_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Wawayisi iverau da nani dobuna ine yavui, i wawaya gubagubagisi ritowai ikavakavarisi Yesu kurina. ");
INSERT INTO pwg_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Yesu meni ku kwanatuna bo meyagina inenae na wawaya turaturasi gubagubagisi ikavarisi da namada keta baranai ma vigimara gawarisiyai ivivi koyakoyagha. Ma ivivi nowi kurina da kana gara damokikina ita votovoni. Ma iyavo kava ivotovoni na kudubisi iyawasa. ");
INSERT INTO pwg_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Mara sago Perisi damsi ma vonaviyoyovana vibeyebeyena wawayisi Jerusalemuwai ipisi Yesu kurina ma imiirigwagwari. ");
INSERT INTO pwg_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Nuwanuwasi ipughupughu iyamna ikitai da Yesu kana kivikivina ikamkam wapawapa, ke imasi ita tepokowakowai ma muriyai da ita kam. ");
INSERT INTO pwg_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Jiu damsi peyarisi i kiki katamana inununura bubuni ma kamosiyai na Perisi damsi ine kirakai. Ke meyani ita kam wapawapa. Kunona okowa vivibiibiinina ita viiya da imasi ita tepokowakowai ma muriyai da ita kam. ");
INSERT INTO pwg_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Ma sago na vigimara gawarina ina kiibutawei na maninina imasi ina tepokowakowai ma muriyai da ina kam. Ma bade nakanani vivitava ma kamkam sawarisi mara nonowa na ina tepokowakowa. Weni berasi peyarisi ivi matakira da i kiki katamana bogii ma bogiiyai ivovotani. ");
INSERT INTO pwg_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Vaghina ma Perisi damsi ma vonaviyoyovana vibeyebeyena wawayisi Yesu ivi tarakiiyanei bo, “Avi kubiine kam kivikivina ita kiki katamanina ke ita nunuri? Ekamkam ma imasi ke ita tepotepokowai.” ");
INSERT INTO pwg_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Ma ivonapotesi bo, “Peroveta Aisaya ivona bubuna maranai tami miiriruwaruwami ivi sisiyemi. Rorova mara katamaninai igiruma da God ivona bo, ‘Weni wawayisi kawasiyai evonavona da evovokaraviku, Ma nuwanuwasi inetaweyana, ");
INSERT INTO pwg_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Nuwatepasiyai evovokavakavariku na iyamna kegha. Ti mani i akova ma i kiki tepanai ibeyebeyena.’” ");
INSERT INTO pwg_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","“Ma tami na God ina sisiya bagibagisi kovovurei ma wawaya i kiki kovovotani.” ");
INSERT INTO pwg_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Ma Yesu ivona meyesi bo, “Koakova kirakai da God ina sisiya bagibagisi kobarei ma tami mani ami kiki konununuri! ");
INSERT INTO pwg_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Ami bera ani mamatarei. Moses igiruma bo, ‘Ami mamai da ami maduwa kovopepetisi.’ ma bade igiruma bo, ‘Iyi ina mamai bo ina maduwa ini avaberowei na koni raboboi.’ ");
INSERT INTO pwg_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Ma tami na ke nakanani koti beyebeyena, kovonavona da wawaya ina maduwa da ina mamai kurisi ina vona bo, ‘Ke kovokovoghina da ani vitemi. Aku mura kudubina na God rapenai, iyamna namada vonakiiyapa bagibagina aterei da kurina ana suwara yavui.’ ");
INSERT INTO pwg_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Tuna kubiine ami vibeyebeyena kamonai wawaya kotaratarapaparisi da i mamai ma i maduwa ke ini vitesi na ini kamyuyuwa. ");
INSERT INTO pwg_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Nakanani koibeyebeyena wawaya kurisi na God vonana murimiyai koterei ma ami kiki koviiya da ku maghinomi. Bera peyarisi nakanani koberaberai.” ");
INSERT INTO pwg_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Ma Yesu koroto ikwatusi ipisi ma ivonesi bo, “Peyarimi, kovi yana bubuniku da akova kona viiya. ");
INSERT INTO pwg_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Aviyavisina wawaya tupuwina kupunai ina rutonai da ku kamokamona ina rui na ke nuwanuwana ini dadabui. Ma aviyavisina berona nuwanuwana kamonai ina ghetawei da berabero ina berai na tuna ina yawasa ini dadabui.” ");
INSERT INTO pwg_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","(-) ");
INSERT INTO pwg_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Muriyai Yesu koroto ikuyowesi ma irui ku numa. Ma kana kivikivina ivi tarakiiyanei da nani miibiina na iyamna avai. ");
INSERT INTO pwg_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Ma ivonesi bo, “Tami bade neghaneghami, bo? Namada kotakovi da aviyavisina tupuwita kupunai tarutonai na ke nuwanuwata ini dadabui God matanai, ");
INSERT INTO pwg_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","iyamna wawaya ina kam bo inuma na inoru ku kamokamona ma karakava tupuwina kamonai ina kiibau, ma ke ku nuwanuwana ina rui.” Yesu na weni sisiyina iterei da vavai ma siya peyarina ivotawei da wawaya ina kam wapawapa. ");
INSERT INTO pwg_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Ma ina sisiya ikwapanatini bo, “Aviyavisina berona wawaya nuwanuwana kamonai ina ghetawei na tuna ini dadabui God matanai. ");
INSERT INTO pwg_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Wawaya nuwanuwana kamonai nota dadabusi egheghetawei da tuna berabero eberaberai da vipekana wapawapa, yapiyapi, kiivunuwa, vitunebo, ");
INSERT INTO pwg_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","matamatigha, kayotirana, vibero, tupuwa ina kayowana dowadowasi, nuwakapi, avabero, kayotata ma bera neghaneghasi eberaberai. ");
INSERT INTO pwg_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Weni berasi beroberosi peyarina wawaya nuwanuwana ma ina nota kamonai ekiikiibau na eberaberai da wawayina na dadabuna God ku matana.” ");
INSERT INTO pwg_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Yesu Gariri dobuna ikuyowei ma ikiibau ku Taya kwanatuna. Ma kwanatu ririnai ku numa sago irui ma ke ita kayowei da wawaya itakovi da tuna na nani dobunai. Ma ke kovokovoghina da ita kove. ");
INSERT INTO pwg_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Wavine sago ivi yana da Yesu ipisi. Wavinena natuna na wavine kikei ma gwabinai kanuma berona irunuma. Tuna kubiine yaghiyaghinai inae Yesu kurina ma maghinonai ivi tuwaporeruruwana ma maghighina ioru ku tano. ");
INSERT INTO pwg_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Wavinena na Grik wavine, ma Ponisiya dobunai itupuwa, Siriya kamonai. Ma ivi nowi Yesu kurina da kanuma berona natuna gwabinai ita kwavini. ");
INSERT INTO pwg_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Ma Yesu miibiiyai ivonapotei bo, “Kunona ededa yoghoyogho ina kam bubuna. Ke ita biibai da kii vavai taviitawei ma kukou taveresi.” ");
INSERT INTO pwg_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ma wavinena Yesu ivonapotei bo, “Bada, kuvona bubuna, ma kegha da ededa ekamkam ririgha na kukou bade kema gaburinai ekamkam.” ");
INSERT INTO pwg_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Ma vaghina, Yesu ivona bo, “Kuvonapote bubuniku. Tuna kubiine kevovira am ku numa na kuna panani da kanuma berona natum gwabinai ikiibau.” ");
INSERT INTO pwg_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Ivovira ina ku numa na ikitai da natuna ikenakena bubuna, iyamna kanuma berona ikiibutawei inae. ");
INSERT INTO pwg_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Yesu ivomiiri Taya kwanatuna ikuyowei inae ku Saidon kwanatuna. Muriyai ibaba da ku Dekapolis, tuna dobuna na Gariri tokana baranai. ");
INSERT INTO pwg_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ma wawaya viya tomowa sago irutinapiyei kurina, tomowina na ke ita viviyana ma ke ita vivisisiya. Ma wawayisi ivi nowi da imana ku tepana ita terei da iti yawasi. ");
INSERT INTO pwg_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Ma Yesu koroto kamonai tomowina irutinavurei ma imarakorakona ku tinabonaghina nevana da nevana iterei. Muriyai imana ikanui ma tomowina pepana ivotovoni. ");
INSERT INTO pwg_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Ma itepa da ku kunuma ikita. Ma yana itawei ma tomowina kurina ivona bo, Ephphatha, weni sisiyina iyamna ‘Kevotawei.’ ");
INSERT INTO pwg_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Yaghiyaghinai tinina itamobau da ivi yana, ma pepana ivi kiivirei da ivi sisiya bubuna. ");
INSERT INTO pwg_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Ma Yesu koroto ivonatanisi da ke sago iyi kurina iti mamatara da avi iberai. Mara nonowa nakanani ivonavonatanisi da ke iti mamatara ma kegha da wawaya kurisi ivivi sisiya. ");
INSERT INTO pwg_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Wawaya peyarisi inotanota kavai da ivonavona bo, “Bera peyarina eberabera bubuni! Ma bade tinapotapotasi da iyana ma kawabutabutasi da isisiya!” ");
INSERT INTO pwg_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Mara sago koroto ghamana ivi kiidaburana ma kii vavai na ivi kovini. Tuna kubiine Yesu kana kivikivina ikwatusi ma ivonesi bo, ");
INSERT INTO pwg_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Weni wawayisi aikamyuyuwesi iyamna mara aroba yavata tamakai ma kii vavai kegha. ");
INSERT INTO pwg_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Mikeda ere vitonarisi ana vonatawesi na ketiyai ina paroro, iyamna wawaya viya na dobu rabaraba ma ipisi.” ");
INSERT INTO pwg_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ma kana kivikivina ivonei bo, “Ke kovokovoghina da weni dobunai parawa taviiya da tikanisi. Wena dobu makiiwapana.” ");
INSERT INTO pwg_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Ma Yesu ivi tarakiiyanesi bo, “Parawa viya gwabimiyai?” Ma kana kivikivina ivonapotei bo, “Parawa miikovimaruwa.” ");
INSERT INTO pwg_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Ma Yesu nani korotona ivonesi da tanowai ita makiipikapika. Parawina iviiya ma God ivi kiikiiwei, ivogimagimai ma kana kivikivina iveresi da ivorereghi koroto kurisi. ");
INSERT INTO pwg_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Ma bade iyana gisigisi viya imakamakai na Yesu iviiya da God ivi kiikiiwei. Ma kana kivikivina ivonesi da ita vorereghi. ");
INSERT INTO pwg_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Wawaya ikam da ikam dodo ma muriyai kana kivikivina puwata iyuna da kode miikovimaruwa ivi tupoi. ");
INSERT INTO pwg_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Ma nani korotona kamonai na tomotomowa ivi 4 tausan. Kakawasi ma natunatusi yavata ikam ikovi na Yesu ivonatawesi inae. ");
INSERT INTO pwg_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Ma kana kivikivina yavata ku waka igeru ma idamana ku Darumanuta dobuna. ");
INSERT INTO pwg_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Perisi damsi viya ipisi da Yesu yavata iti taghegheyana. Ma ita rubui kubiine ivonei bo, “Bera ghamana keberai kana kitai. Nakanani kanakovi da rewapana God gwabinai kuviiya bo kegha.” ");
INSERT INTO pwg_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Ma Yesu yana itawei ma ivona bo, “Tami weni kimtina kokayokayowei da bera ghamana kota kitai. Ma vonavaghata avonavonemi da kubiimi na ke avi berana ana berai.” ");
INSERT INTO pwg_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Ma vaghina Yesu ikuyowesi da ku waka igerume, ma ivomiiri da Gariri tokana idamadamani. ");
INSERT INTO pwg_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Ma kana kivikivina nuwanuwasi iwapa da parawa ke ita kavari. Ma parawa sago kava wakiiyai imakamakai. ");
INSERT INTO pwg_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Ma Yesu ivi varavarisi bo, “Kokoyagha bubunimi ma kokitaruvimi Perisi damsi i yist ma Kiivavo Herodi ina yist kubiine.” ");
INSERT INTO pwg_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Ma kana kivikivina ti mani kavakava inipusi, ivona bo, “Mikeda parawa kegha, tuna kubiine nakanani ivoneta.” ");
INSERT INTO pwg_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Ma Yesu iakovi da aviyavisina ivivi sisiyei na ivi tarakiiyanesi bo, “Avi kubiine parawa koinuwapoyei? Patana da akoviku ke kota viiviiya bo? Avi kubiine vonavaghata damina ke kota viiviiya? Nuwanuwami na gudugudusi, bo? ");
INSERT INTO pwg_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Matami emakamakai. Avi kubiine ke kota kitakita? Ma tinimi emakamakai. Avi kubiine ke kota viviyana? Kade konotanotai bo kegha, ");
INSERT INTO pwg_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","da parawa miikovi avogimagimai da tomotomowa 5 tausan avi kanisi? Ma puwata kodesi viya kovi tupoi?” Ma kana kivikivina ivonapotei bo, “Kode ivi 12.” ");
INSERT INTO pwg_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“Ma bade parawa miikovimaruwa avogimagimai da tomotomowa 4 tausan avi kanisi. Ma puwata kodesi viya kovi tupoi?” Ma ivonapotei bo, “Kode miikovimaruwa.” ");
INSERT INTO pwg_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Ma ivonesi bo, “Ma patana da vonavaghata damina ke kota viiviiya, bo?” ");
INSERT INTO pwg_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Yesu kana kivikivina yavata ku Betsaida kwanatuna inekiibau. Ma wawaya viya tomowa matapotapotana irutinapiyei Yesu kurina. Ma ivi nowi da ita votovoni da iti yawasi. ");
INSERT INTO pwg_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Matapotapotana imana iviiya ma irutini da kwanatu ikiibutawei. Matana ikanui ma muriyai na imana ku tepana iterei. Ma ivi tarakiiyanei bo, “Kade aviyavisina kekitakitai?” ");
INSERT INTO pwg_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ikita tovona ma ivona bo, “Wawaya akitakitisi ma kitasi nakanani ma kii ita bababa.” ");
INSERT INTO pwg_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Ma matana ivotovona meyei da itamotatagha na iyawasa da ikita bubuna. ");
INSERT INTO pwg_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Ma Yesu ivona bo, “Ke kuna rui ku kwanatu. Maninina kenae da am ku numa.” ");
INSERT INTO pwg_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Yesu kana kivikivina yavata ivomiiri inae ku meyagai gisigisi Sisariya Pilipai kwanatuna ririnai. Ketiyai inenae ma kana kivikivina kurisi ivi tarakiiyana bo, “Kovona. Wawaya isisiya da taku na iyai?” ");
INSERT INTO pwg_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Ma ivonapotei bo, “Viya evonavona da tam na Jon Babataito. Viya evonavona da tam Elaidiya, ma bade viya evonavona da tam na God ina peroveta sago.” ");
INSERT INTO pwg_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Ma ivi tarakiiyanesi bo, “Ma tami na ikikava koinuwanotanota? Taku na iyai?” Ma Pita ivonapotei bo, “Tam na God ina Vivinevine Wawayina.” ");
INSERT INTO pwg_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Ma Yesu ivonatanisi da ke iti mamatara wawaya kurisi da tuna na iyai. ");
INSERT INTO pwg_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Yesu ivi karei da kana kivikivina ivonavonaviakovisi bo, “Taku Wawaya Natusi ana vokwarakwara kirakai. Ma Jiu damsi i babada ma taparoro babadisi i babada ma vonaviyoyovana vibeyebeyena wawayisi ina bareku. Ini raboboku ma mara viarobina kamonai na ana vomiiri.” ");
INSERT INTO pwg_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Debiiyai ivi sisiyei kurisi, ma Pita irutini ku ririna ma iyeghai da ke nakanani ini sisiya. ");
INSERT INTO pwg_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Ma Yesu itavira da kana kivikivina viya ikitakitisi ma Pita iyeghai bo, “Seitan, kawam epota! Nani notana na ke God ita verem. Dobu kana akova kenotanotai.” ");
INSERT INTO pwg_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Ma Yesu koroto ikwaturiyariyesi da kana kivikivina yavata ipisi kurina. Ma ivona bo, “Iyi tam kekayokayowei da kuna kiviniku na tam mani kuna vere meyem, kam korosi kuna kavari ma murikuwai kuna pisi. ");
INSERT INTO pwg_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Tam iyai am yawasa kuna nota kirakiiyei na kuni wapai. Ma iyi tam am yawasa kuna nuwatawei kubiiku ma God varana biibiina kubiine na yawasa makamakii nonowina kuna panani. ");
INSERT INTO pwg_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Mikeda wawaya dobu kudubina iti rapenei ma ita rabobo da kanumina ita wapa na ina mura ke ini vitei. ");
INSERT INTO pwg_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Aviyavisina ini miiyei da kanumina ma ina yawasa ina vii meyei? Ke sago. ");
INSERT INTO pwg_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Karako weni kimtina na kawakiikiimi ma ami berabero irakata. Ma iyi taku Wawaya Natusi ina vonaveyaveyiyeku ma vonaku ina barei na nani wawayina ana vonaveyaveyiyei maranai aku Mamai kana kadara kamonai aneya vovokaravisi yavata kana pisi.” ");
INSERT INTO pwg_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Ma Yesu ivonesi bo, “Vonavaghata avonavonemi da tami viya weni kamonai God ina vikiivavona ere rewapanina ina nekiibau na kona kitai, ma muriyai da kona rabobo.” ");
INSERT INTO pwg_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Mara miikovimasago ikovi na Yesu turaturana Pita, Jemes ma Jon irutinisi ighae koya ghamana ku tepana da ti mani kava imakamakai. Ma maghinosiyai Yesu kana kita ivire. ");
INSERT INTO pwg_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Ma bade kana gara ivirei da poipoi kirakiina ma vovokeyakeyuna. Wawaya dobuwai ke kovokovoghina kii gara ita kowai da nakanani ita poini. ");
INSERT INTO pwg_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Ma bade ivi aroba ikitakita na peroveta Elaidiya ma Moses inekiibau Yesu kurina da yavata ivivi sisiya. ");
INSERT INTO pwg_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Ma Pita ivona bo, “Bada, ibiibii kirakai da tota weni. Yobe aroba kana vowai, sago tam kubiim, sago Moses, ma sago Elaidiya kubiine.” ");
INSERT INTO pwg_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Pita turaturana yavata iyabumana kirakai, tuna kubiine ke itakovi da aviyavisina ivivi sisiyei. ");
INSERT INTO pwg_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Ma kwavu inekiibau isovosi ma kwavuna kamonai gamo sago ivona bo, “Wena na natuku, tuna nuwanuwaku. Ina sisiya kovi yana bogai.” ");
INSERT INTO pwg_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Nani murinai, Pita ma turaturana yaghiyaghinai ikitavirevire da ke sago iyi ita kitai, Yesu ina kina kava. ");
INSERT INTO pwg_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Ma peyarisi ivomiiri da koyiyai iororu ma Yesu ivonatanisi bo, “Bera kokitai na ke wekarakava wawaya kurisi koni mamatara. Taku Wawaya Natusi ana rabobo ma rabobowai ana vomiiri na murinai koni mamatara.” ");
INSERT INTO pwg_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Tuna kubiine nani berana ikitai na nuwanuwasi kamonai itatani. Ma Yesu ina sisiya da rabobowai ina vomiiri na ti mani kamosiyai kava ivivi tarakiiyana meyesi da tuna na iyamna avai. ");
INSERT INTO pwg_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ma Yesu kana kivikivina ivi tarakiiyanei bo, “Avi kubiine vonaviyoyovana vibeyebeyena wawayisi evonavona da peroveta Elaidiya ini nao ina pisi ma God ina Vivinevine Wawayina na ini muri?” ");
INSERT INTO pwg_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Ma ivonapotesi bo, “Vonavaghata da Elaidiya iti nao da bera peyarina ita vovunaghi. Ma kovi nuwanotanota da avi kubiine giruma katamana ivona da Wawaya Natusi ini kamaghi kirakiiyei ma wawaya ina barei. ");
INSERT INTO pwg_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Ma ani akovimi da Elaidiya namada ipisi ma wawaya i kayowanai ivi kayotirana kurina. Ikikava giruma katamana ivona da ita tupuwa kurina na nakanani itupuwa.” ");
INSERT INTO pwg_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Yesu ma turaturana ivi aroba ivovovira kana kivikivina peyarisi kurisi na ikitai da koroto ghamana imiirigwagwarisi. Ma ikitai da vonaviyoyovana vibeyebeyena wawayisi yavata ivivi gamowana. ");
INSERT INTO pwg_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Peyarisi Yesu ikitai da ipipisi na ivi deyei. Ma iverupotei da ivi kiikiiwei. ");
INSERT INTO pwg_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Ma ivi tarakiiyanesi bo, “Avi koigamowanei?” ");
INSERT INTO pwg_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Ma tomowa sago koroto kamonai ivonapotei bo, “Bada, natuku arutinapiyei kurim, iyamna kanuma berona gwabinai irunuma da ke ita vivisisiya. ");
INSERT INTO pwg_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Maranai natuku evowavowai na eparoparoro, kawapuropurona ekiikiibau ma okena itarakikitei. Ma muriyai tupuwina epatopatokiiyana. Kam kivikivina avi nowi kurisi da ita kwavini na ibera kavai.” ");
INSERT INTO pwg_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Ma Yesu ivona bo, “O, tami weni kimtina na ami vitumaghana kegha. Mara iguri ghagha yavata tamakamakai ma patana da ke kota vivitumaghana. Karakava da koinibariku. Vaghina, tomowa kikei korutinapiyei.” ");
INSERT INTO pwg_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Irutinapiyei kurina na kanuma berona Yesu ikitai ma iberai da tomowa kikei iparoro, ipeku ku tano ma ivivi kiivirevirei ma kawapuropurona ikiikiibau. ");
INSERT INTO pwg_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Ma Yesu tomowa kikei ina mamai ivi tarakiiyanei bo, “Mara avai weni gubagina gwabinai ivi karei?” Ma ivonapotei bo, “Namadani kava, gisinai ivi karei. ");
INSERT INTO pwg_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Mara ipeyari itawei ku keyama karakaratina ma ku okowa, virabobona kubiine. Kade, kovokovoghina bo kegha da kuni kamyuyuwekai ma kuni vitekai?” ");
INSERT INTO pwg_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Ma Yesu ivonapotei bo, “Avi kubiine kuvona bo, ‘kovokovoghina bo kegha?’ Wawaya ini tumaghana na kovokovoghina da ina tupuwa.” ");
INSERT INTO pwg_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Ma yaghiyaghinai tomowa kikei ina mamai ivona bo, “Aitumaghanem ma kegha da aku nota igisi. Kuni viteku da aku vitumaghana ina rakata.” ");
INSERT INTO pwg_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Yesu ikitai da wawaya peyarisi ivivi veraveruwana kurina ma yaghiyaghinai kanuma berona iyeghai bo, “Kanuma berom, kam vava kawabuta ma tinapota na kevi yaneku. Sisiya bagibagina avereverem da tomowa kikei kekiibutawei ma ke meyani da kuna vovira kurina!” ");
INSERT INTO pwg_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Nani kanumina berona ikiirara, tomowa kikei inukei ma ikiibukuyowei. Ma tomowa kikei kitana da nama ita rabobo ma wawaya peyarisi ivonavona bo, “Irabobo!” ");
INSERT INTO pwg_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Ma Yesu tomowa kikei imana iviiya ma itinavomiirini da imiiri. ");
INSERT INTO pwg_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Muriyai ku numa irui ma kana kivikivina gavunai ivi tarakiiyanei bo, “Avi kubiine kanuma berona kwavinina kabera kavai?” ");
INSERT INTO pwg_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Ma ivonapotesi bo, “Kona nipowana kirakai da kanuma beroberosi weni kanumina nakanani kona kwavinisi da ina kiibau.” ");
INSERT INTO pwg_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Nani dobuna ikuyowei ma Gariri dobuna kamonai ibaba inenae. Ma Yesu ke ita kayokayowei da wawaya itakovi da mike ineyana, ");
INSERT INTO pwg_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","iyamna kana kivikivina kurisi ivivi beyebeyena. Ivonesi bo, “Wawaya ini wawana da Wawaya Natusi kana ghavighaviya ku imasi ina terei. Ini raboboi ma mara viarobina kamonai na ina vomiiri.” ");
INSERT INTO pwg_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Ma kana kivikivina nani sisiyina ivi yanei na ke itakovi. Ma iyabumana, tuna kubiine ke iti tarakiiyanei da iyamna iti debei. ");
INSERT INTO pwg_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Yesu kana kivikivina yavata ku Kapeniyam kwanatuna inekiibau. Ma numiiyai ivi tarakiiyanesi bo, “Ketiyai na aviyavisina kovivi gamowanei?” ");
INSERT INTO pwg_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Ma kana kivikivina ke ita vonapotei iyamna ketiyai ivivi gamowana da kamosiyai iyi kana vava ita rakata. ");
INSERT INTO pwg_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Yesu imakiipikapika ma kana kivikivina ivi 12 ikwatusi ma ivonesi bo, “Mikeda kekayokayowei da God matanai kuni nao na kevi muritaweyana. Ketereoruwe meyem da tam turaturam i bigabiga.” ");
INSERT INTO pwg_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Ma wawaya kikei sago irutinapiyei da basusiyai ivi miirini. Ku dogarina iterei ma kana kivikivina ivonesi bo, ");
INSERT INTO pwg_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Iyi tam avakuwai wawaya kikei sago kuni kiikiiwei na bade taku kikiikiiweku. Ma iyi tam kuni kiikiiweku na aku Mamai ivonataweku na tuna bade kikiikiiwei.” ");
INSERT INTO pwg_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Jon ivona bo, “Bada, tomowa sago kakitai, avamuwai kanuma beroberosi ikwavikwavinisi. Ma tuna na ke tota ita wawaya kubiine kavonatani.” ");
INSERT INTO pwg_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Ma Yesu ivona bo, “Ke kona vonatani. Wawaya avakuwai bera ghamaghamasi ina berai na muriyai ke kovokovoghina da yaghiyaghinai kaku vava ina kiiviberoi. ");
INSERT INTO pwg_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Wawaya iyai ke ita vivikawapateta na kwinata. ");
INSERT INTO pwg_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Vonavaghata avonavonemi da meni wawayina iakovim da tam na taku rapekuwai ma avakuwai okowa ina verem na God wawayina ini miiyei.” ");
INSERT INTO pwg_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Meni wawayina itumaghaneku da tuna na weni wawaya kikei nakanani na ke meyani kuna ruyaghai da berabero ina berai. Kuna ruyaghai da ina peku na kovogha ghamana kuna viiya, ita biibii kirakai da wakima vitana iwamuwai ita kuni ma ku yegai ita tawem. ");
INSERT INTO pwg_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Imamuwai bera berona kuta berai na imam kuta boritawei. Ibiibai da imam nevana kava ma yawasa makamakii nonowina kuna panani. Ma ibero kirakai da imam ruwa ma kuna nae ku keyama karata makamakii nonowina. ");
INSERT INTO pwg_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","(-) ");
INSERT INTO pwg_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Ma kaemuwai bera berona kuta berai na kaem kuta boritawei. Ibiibai da kaem nevana kava ma yawasa makamakii nonowina kuna panani. Ma ibero kirakai da kaem ruwa ma ku keyama karakaratina ina tawem. ");
INSERT INTO pwg_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","(-) ");
INSERT INTO pwg_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ma matamuwai bera berona kuta berai na matam kuta tupatawei. Ibiibai da matam nevana kava ma God ina ku vikiivavona kuna rui. Ma ibero kirakai da matam ruwa ma ku keyama karakaratina ina tawem. ");
INSERT INTO pwg_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Nani gawarinai na, ‘Wawaya kii motamota ke meyani ina rukwa, nonowa viyosi ina kanikani. Ma keyama ke meyani ina peki, mara nonowa ina karakarisi.’” ");
INSERT INTO pwg_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Ma bade kudubimi keyama ina karimi da avi berona ami yawasa kamonai na peyarina ina kara yavui da biibiina kava ina makai.” ");
INSERT INTO pwg_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“Ma yegai na biibiina ma kegha da damina ina wapa na ikikava kona berai da damina ina vovira? Ke kovokovoghina. Kobera meyemi da tami nakanani ma yegai damina biibiina, ere nuwanubami komakai ma kovi nuwasago.” ");
INSERT INTO pwg_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Yesu kana kivikivina yavata Gariri dobuna ikuyowei ma inae ku Judiya dobuna. Ma Jodan okowina idamani da ku nevana. Ma mara nonowa koroto bogii ma bogiiyai ipipisi kurina ma ikikava mara nonowa vibeyebeyena itereterei, nakanani ivivi beyebeyena kurisi. ");
INSERT INTO pwg_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Ma Perisi damsi viya ipisi da Yesu ita rubu tovoni. Tuna kubiine ivi tarakiiyanei bo, “Vonaviyoyovana kamonai vivaghina emakamakai bo kegha da tomowa kawana ina barei?” ");
INSERT INTO pwg_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Ma Yesu ivonapotesi bo, “Moses aviyavisina igirumi?” ");
INSERT INTO pwg_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Ma Perisi damsi ivona bo, “Moses ivi vaghinei da maranai tomowa kawana ina barei na kana bera weni. Vikiitawetaweyana sisiyina ina girumi da wavinena ina verei ma ina vonatawei da ina nae.” ");
INSERT INTO pwg_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Ma Yesu ivonesi bo, “Ami vitinapota irakata ma nuwanuwami gudugudusi, tuna kubiine Moses nakanani igirumi. ");
INSERT INTO pwg_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Kota notai da dobu karenai ‘God wawaya iyamonisi da tomowa ma wavine.’ ");
INSERT INTO pwg_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","‘Tuna kubiine tomowa ina mamai ma ina maduwa ina kuyowesi da kawana yavata ini kiikapu ");
INSERT INTO pwg_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","da tupuwsi sago.’ Tuna kubiine ivi ruwa ini sagosi da ke ruwa, ti na sago. ");
INSERT INTO pwg_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","God tomowa ma wavine ivi sagosi, tuna kubiine wawaya ke ini bogebogesi.” ");
INSERT INTO pwg_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Muriyai Yesu kana kivikivina yavata numiiyai imakamakai na ivi tarakiiyanei da ina sisiya na iyamna avai. ");
INSERT INTO pwg_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Ma ivonapotesi bo, “Tomowa kawana ina barei da ini kiitawetaweyana ma wavine vuna ina ravaghi, tuna na berabero, vipekana wapawapa eberaberai. ");
INSERT INTO pwg_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ma bade wavine kawana ina barei ma tomowa vuna ina ravaghi, tuna na berabero, vipekana wapawapa God ku matana.” ");
INSERT INTO pwg_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Mara sago wawaya ededa yoghoyogho irutinapiyesi da Yesu ita votovonisi ma iti biibiinisi. Ma kana kivikivina iyeghisi ma ededa itarapaparisi. ");
INSERT INTO pwg_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Ma Yesu ikitisi ma ke iti nuwabiibiiyesi na ivonesi bo, “Ededa kovoteresi da ina pisi kuriku. Ke kona tarapaparisi iyamna iyavo kava weni ededisi nakanani na God ina vikiivavona kamonai emakamakai. ");
INSERT INTO pwg_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Vonavaghata avonavonemi da iyi tam kekayokayowei da God ina vikiivavona kamonai kuna makai na kebera meyem da weni ededisi i yawasa nakanani. Ke kuna berai na ke meyani kuna rui God ina vikiivavona ku kamona.” ");
INSERT INTO pwg_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Ma ededa yoghoyogho itaraghavusi, imana ku tepasi iterei ma ivi biibiinisi. ");
INSERT INTO pwg_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Yesu ivomiiri da baba iti karei ma tomowa sago iverau kurina ma maghinonai ivi tuwaporeruruwana. Ma ivonei bo, “Bada biibiim, avi ana berai da yawasa makamakii nonowina ana viiya?” ");
INSERT INTO pwg_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Ma Yesu ivonapotei bo, “Avi kubiine kuvona da taku biibiiku? Ke sago wawaya biibiina dobuwai, ma God ina kina kava na biibiina. ");
INSERT INTO pwg_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Sisiya bagibagisi namada kuakovi. ‘Ke kuna kiivunuwa, ke kuni pekana wapawapa, ke kuna yapi, ke kuni mamatara bero, ke wawaya ina mura kuna vogavui da kuni rapenei, ma bade ami mamai da ami maduwa kovopepetisi.’” ");
INSERT INTO pwg_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Ma tomowina ivona bo, “Bada, gisikuwai avi karei ma patana da weni sisiyisi bagibagisi peyarina avovotekatekei.” ");
INSERT INTO pwg_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Ma Yesu tomowina ikita bogai ma nuwanuwana iviini. Ma ivonei bo, “Bera sago kava kuta berai. Kenae ma aviyavisina peyarina rapemuwai na kevi gimarei. Ma nani manena kuna viiya da wawaya moyamoyakisi kuna veresi da kunumai am mura makamakii nonowina kuna panani. Ma muriyai na kepisi da kuna kiviniku.” ");
INSERT INTO pwg_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Tomowina Yesu ina sisiya ivi yanei na ivi nuwapoya kirakai da idune. Ma ere nuwapoyina inekuyowei iyamna ina mura na ghamana. ");
INSERT INTO pwg_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Ma Yesu ikitavirevire ma kana kivikivina ivonesi bo, “Ipiropiro kirakai da mura wawayisi ina rui God ina ku vikiivavona.” ");
INSERT INTO pwg_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Ma kana kivikivina ina sisiya ivi yanei na ivi deyei. Ma Yesu sisiyina ivona meyei, “Natunatuku, ipiropiro kirakai da wawaya God ina ku vikiivavona ina rui. ");
INSERT INTO pwg_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Ikikava ipiropiro da kamel unubu ku bonaghina ita susura na bade nakanani ipiropiro kirakai da mura wawayina ita rui God ina ku vikiivavona.” ");
INSERT INTO pwg_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Kana kivikivina ivi deye kirakiiyei ma kamosiyai ti mani ivi tarakiikiiyana meyesi bo, “Nakanani na iyavo yawasa ina panani?” ");
INSERT INTO pwg_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Yesu ikita bogiisi ma ivonesi bo, “Wawaya kurisi na ke kovokovoghina. Ma God kurina na kovokovoghina, iyamna tuna kurina bera peyarina na itekateka kirakai.” ");
INSERT INTO pwg_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Ma Pita ivonapotei bo, “Ma tokai na ikikava? Aviyavisina kudubina kaverukuyowei da kakivikivinim.” ");
INSERT INTO pwg_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Ma ivonapotesi bo, “Vonavaghata avonavonemi, iyavo kava God varana biibiina kubiine bo taku kubiiku i numa bo varevaresisi, novunovusi, maduwa da mamai, natunatusi bo i tano ikuyowei, ");
INSERT INTO pwg_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","na ti damsi weni maranai aviyavisina iverukuyowei na maghimaghighina dobuwai bade ina panana meyei. Numa, vivaresina, vinovuna, maduwa mau, vinatuna bo tano ina panani da ina sasara. Ma bade nani kamonai wawaya ini tupaketowanesi. Ma maghinotiyai marana epipisi da yawasa makamakii nonowina ina panani. ");
INSERT INTO pwg_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Ma iyavo kava weni yawasina kamonai inao na karakava ini muri. Ma iyavo kava weni yawasina kamonai imuri na karakava ini nao.” ");
INSERT INTO pwg_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Yesu kana kivikivina yavata igheghae ku Jerusalem ma kana kivikivina ivi deyei da tuna ivi nao. Ma bade iyavo kava ivivi kaeturanesi na iyabuyabumana kirakai da aviyavisina ita tupuwa Jerusalem kamonai. Ma Yesu turaturana ivi 12 itinavivirisi ma ivona meyesi da aviyavisina ita tupuwa kurina. ");
INSERT INTO pwg_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Ivonesi bo, “Ku Jerusalem taghae na wawaya sago taku Wawaya Natusi ini wawaneku taparoro babadisi i babada ma vonaviyoyovana vibeyebeyena wawayisi kurisi. Ini tupavireku da wavu ina vereku ma ina vonakiiyaragha da ini raboboku. Ma kupuna damsi ku imasi ina tereku da ");
INSERT INTO pwg_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","ini avaberoweku, ina kanuku ma ina widiku ma muriyai na korosiyai ini raboboku. Ma mara viarobina kamonai na rabobowai ana vomiiri.” ");
INSERT INTO pwg_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Ma Zebedi natunatuna Jemes da Jon inae Yesu kurina ma ivona tovoni bo, “Bada, akii kayowana kuna berai.” ");
INSERT INTO pwg_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Ma ivonapotesi bo, “Aviyavisina ana berai kubiimi?” ");
INSERT INTO pwg_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Ma ivi ruwa ivona bo, “Akii kayowana da kuni vaghinei da am vikiivavona kadakadarina kamonai, sago katagheyamuwai ma sago dugemuwai kana makai da tibada patapata.” ");
INSERT INTO pwg_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Ma Yesu ivonapotesi bo, “Ke kotakovi da aviyavisina koisisiyei. Tami kovokovoghimi da aku redu kona karapotai, bo? Kovokovoghimi da ikikava ana babataito nakanani kona bapataito, bo?” ");
INSERT INTO pwg_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Ma ivonapotei bo, “Kovokovoghikai.” Ma ivonesi bo, “Vonavaghata da ikikava vokwarakwara reduna anumai na nakanani konuma. Ma ikikava rabobowai ana babataito na nakanani kona babataito. ");
INSERT INTO pwg_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Ma taku na aku rewapana kegha da wawaya ana vinesi da iyi katagheyakuwai bo dugekuwai ina makai. Nani gawarisi na God ivovunaghi ma kii wawaya ivinesi ikovi.” ");
INSERT INTO pwg_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Maranai turaturasi imaruwa ivi yanei da Jemes ma Jon weni nakanani ivi nowi na nuwanuwasi ipughu kirakai. ");
INSERT INTO pwg_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Ma Yesu ikwaturiyariyesi ma ivonesi bo, “Koakovi da kupuna damsi i babada na ivi rewapana kirakai. Ma bade i wawaya ghamaghamasi na ekayokayotata kirakai. ");
INSERT INTO pwg_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Ma tami na ke nakanani kona berai. Iyi tam kamomiyai kekayokayowei da kuni wawayaghama na ketereoruwe meyem da tam na turaturam kudubisi i bigabiga. ");
INSERT INTO pwg_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ma iyi tam kekayokayowei da kuni nao na tam kebera meyem da kuni sleiv turaturam kubiisi. ");
INSERT INTO pwg_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Ma bade taku Wawaya Natusi ke ata pisi ku dobu da wawaya vitaku ita kavari. Kegha, apisi da wawaya vitasi ata kavari. Aku yawasa ana suwara da wawaya peyarisi ana gimaratawesi.” ");
INSERT INTO pwg_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Yesu kana kivikivina yavata inekiibau ku Jeriko kwanatuna. Koroto ghamana ivivi kaeturanesi inae da Jeriko kwanatuna ikiibukuyowei. Ma keta baranai tomowa matapotapotana imakamakai da mane kubiine ivivi nowi. Tuna na Timeyas natuna, kana vava na Batimeyas. ");
INSERT INTO pwg_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Ma ivi yana da nani Nasaret tomowa Yesu ketiyai inenae na kwatu ivi karei, ikiikiirara bo, “Yesu! David Tupurereghina, kevi kamyuyuweku.” ");
INSERT INTO pwg_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Ma wawaya peyarisi iyeghai ma ivonei da kawana ita pota. Ma kegha da ighekiirara, “David Tupurereghina, kevi kamyuyuweku!” ");
INSERT INTO pwg_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Ma Yesu ivi kiimiiriyei ma ivona bo, “Kokwatui da ina pisi.” Ma wawaya matapotapotana ivonei bo, “Kevi nuwabiibai ma kevomiiri. Ekwatukwatum.” ");
INSERT INTO pwg_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Ina kwarewa ivi rupiitawei ma yaghiyaghinai ivomiiri ma ibaba inae Yesu kurina. ");
INSERT INTO pwg_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Ma Yesu ivi tarakiiyanei bo, “Avi ana berai kubiim?” Ma Batimeyas ivona bo, “Bada, aku kayowana da ata kita.” ");
INSERT INTO pwg_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Ma Yesu ivona bo, “Am vitumaghana kubiine kuyawasa, nuwabiibiiyai kenae.” Yaghiyaghinai ikita ma Yesu ikivini da yavata ibaba inae. ");
INSERT INTO pwg_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Yesu kana kivikivina yavata ibaba inenae da gisina kava ku Jerusalem ita nekiibau, ma Betani da Betipadi ku meyagisi ipisi, ti na Oliv koyana barabaranai. Ma kana kivikivina ruwa ivonatawesi da iti nao. ");
INSERT INTO pwg_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Ivonesi bo, “Konae, ma nani meyagina maghinotai kona rurui na donki votuna wariwarimina kona kitai. Wawaya ke meyani ita geru tovoni. Uravina korupami ma korutinapiyei wike. ");
INSERT INTO pwg_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ma mikeda wawaya ini tarakiiyanemi bo, ‘Avi kubiine donki uravina koruparupami?’ na kovonesi bo, ‘Bada ekayokayowei. Ke mara gurina ma ina vovirei.’” ");
INSERT INTO pwg_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Ivi ruwa irui ku meyagai da keta baranai numa sago matuketinai donki wariwarimina ipanani ma ivi karei da uravina ita rupami. ");
INSERT INTO pwg_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Ma wawaya viya ikitisi na ivonesi bo, “Avi kubiine nani donki uravina koruparupami?” ");
INSERT INTO pwg_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Ma ikikava Yesu ivonavonesi na nakanani ivonaveresi na wawayisi ivi vaghinei. ");
INSERT INTO pwg_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Ma donki irutini ivovira Yesu kurina. Ma kii tarasovo ivi tawanepeyana donki ku tepana ma Yesu igeru. ");
INSERT INTO pwg_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Ma wawaya peyarisi kii tarasovo ketiyai ikepana ma bade viya kiiragharaghasi dipiiyai iyaragha da ketiyai itawei. ");
INSERT INTO pwg_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ma kana koroto Yesu maghinonai ma murinai ibababa na ikarakarayogosi bo, “Hosana! Kaigheghenim! Bada avanai kepipisi! Tam na Bada ina vibiibiina kamonai! ");
INSERT INTO pwg_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Ita kaekiki David kana viteparara epipisi ma ina vikiivavona na Bada God ini biibiini! Hosana! God, kiidamo makamakiim, kaigheghenim!” ");
INSERT INTO pwg_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Yesu irui ku Jerusalem, ma maninina inae ku Taparoro Numana. Ikitavirevire ma namada ravi ipika, tuna kubiine kana kivikivina ivi 12 yavata ikiibau ku Betani meyagina. ");
INSERT INTO pwg_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Mara itom ma Betani meyagina ikiibutawei inenae da Yesu vitonara ikarai. ");
INSERT INTO pwg_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Ikitataweyana da koweya inumoi ikitai. Ma iverubanenegi, ita kitai da iame bo kegha. Inekiibau na ipanani da amena kegha, iyamna ke kana mara da koweya itame. ");
INSERT INTO pwg_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Ma nani kiina imagi bo, “Ke meyani wawaya amem ina kam tovoni.” Ma kana kivikivina ivi yanei da nakanani ivivi sisiya. ");
INSERT INTO pwg_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Yesu inekiibau ku Jerusalem ma irui Taparoro Numana garina ku kamona. Ma vigimara wawayisi ma iyavo kava gwabisiyai igimagimara na kwavinisi ivi karei. Iyavo kava gabubu ivivi gimara bo mane ivivi vovivirana na i kemakema ivi kuririghana. ");
INSERT INTO pwg_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ma keta igudui da wawaya ke kovokovoghina da i vigimagimara sawarisi yavata Taparoro Numana garina ku kamona ita rui. ");
INSERT INTO pwg_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Ma ivi beyebeyena kurisi, ma nani kamonai ivonesi bo, “Giruma katamana kamonai evonavona bo, ‘Aku numa na nipowana numana dam ma dam kubiisi.’ ‘Ma tami koberai da tuna yapiyapi damsi i numa.’” ");
INSERT INTO pwg_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Ma taparoro babadisi i babada ma vonaviyoyovana vibeyebeyena wawayisi ina sisiya ivi yanei na ivi karei da keta iekwekwai da ikikava iti raboboi. Ma Yesu iyabuyabumanei iyamna ina vibeyebeyena ivi rewapana kirakai da koroto kudubina itinavivirisi. ");
INSERT INTO pwg_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Ma ravi ipika na Yesu kana kivikivina yavata Jerusalem kwanatuna ikiibutawei. ");
INSERT INTO pwg_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Mara itom na Yesu kana kivikivina yavata ibaba inenae ku Jerusalem ma ikitai da koweyina Yesu imagi na isivisivi ma ipoki. ");
INSERT INTO pwg_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Ma Pita nani koweyina inotapanani na Yesu ivonei bo, “Bada, kekitai. Koweyina kuimagi na ikaragavovori.” ");
INSERT INTO pwg_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Ma Yesu ivonesi bo, “God kovi tumaghanei. ");
INSERT INTO pwg_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Vonavaghata avonavonemi da iyai weni koyana ita vonei bo, ‘Kenae, ku yegai kuna tawem,’ ma aviyavisina isisiyei na nani kamonai notaragharagha gwabinai kegha da nuwanuwana kudubinai ini tumaghana da nani berana ina tupuwa na God ina berai. ");
INSERT INTO pwg_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Tuna kubiine avonavonemi da aviyavisina ami nipowana kamonai koinowi na kovi tumaghana da ami kayowana namada gwabimiyai, God ina veremi. ");
INSERT INTO pwg_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Ma kuna vomiiri da kuta nipowana na kuna notapanani da nuwanuwam kamonai kwinam ina berabero patana da kutatani emakamakai na kenotatawei. Kuna notatawei na am Mamai kiidamowai bade am berabero ina notatawei.” ");
INSERT INTO pwg_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","(-) ");
INSERT INTO pwg_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Yesu kana kivikivina yavata ivovirame ku Jerusalem. Ma Yesu Taparoro Numana garina kamonai ibababa na taparoro babadisi i babada, vonaviyoyovana vibeyebeyena wawayisi ma Jiu damsi i babada ipisi kurina ma ivonamatakitakitei bo, ");
INSERT INTO pwg_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","“Avi rewapanina kuviini ma iyi nani rewapanina iverem da weni berasi keberaberai?” ");
INSERT INTO pwg_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Ma Yesu ivonesi bo, “Aku vitarakiiyana sago kava ana terei kurimi. Kona vonapoteku na bade ana vonemi da aku rewapana imapatana aviiya da weni berasi aberaberai. ");
INSERT INTO pwg_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Jon ina rewapana na imapatana iviiya da ibabataito? Kunumai ipisi bo wawaya gwabisiyai? Kovoneku.” ");
INSERT INTO pwg_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Ma kamosiyai ti mani ivivi sisiya bo, “Mikeda kata vona da ina rewapana kunumai ipisi na ina kayovoneta bo, ‘Avi kubiine Jon ke koti tumaghanei?’ ");
INSERT INTO pwg_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ma bade kata vona da rewapana wawayota gwabisiyai iviiya na iyavo kava i nota da Jon na peroveta na ti damsi nuwanuwasi ita pughu kurita.” Koroto ghamana iyabuyabumanesi, iyamna wawaya peyarisi inotanotai da Jon na God ina peroveta. ");
INSERT INTO pwg_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Tuna kubiine Yesu kurina ivona bo, “Ke katakovi.” Ma ivonesi bo, “Nakanani da bade ke ana vonemi da iyi rewapana ivereku da weni berasi aberaberai.” ");
INSERT INTO pwg_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Ma Yesu ivi karei da miibiiyai kurisi ivivi sisiya. Ivona bo, “Mara sago tomowa greipi ivoni ina vao kamonai. Ma wakimiyai igariya ma mewa iyabai da greipi amesi inuwani ma ititugudagudai da muina kava ita viiya. Ma numa kweta ivowai da wawaya ita makai da greipi ita potapotai. Muriyai ina vao na wawaya ku imasi iterei da ita koyaghi ma inumataya ku dobu sago. ");
INSERT INTO pwg_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Ma kana mara ipisi da greipi imenai na ina bigabiga sago ivonatawei da kana reregha ita viiya. ");
INSERT INTO pwg_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Ma vao kana koyakoyagha, bigabiga wawayina ivotani, ivowai ma ikwavini da imana kwebuna ma ivovira vao badana kurina. ");
INSERT INTO pwg_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Ma bade kana viruwa ivonatawei inae kurisi. Ma gayamina iravi ma ivi kayoberoberowanei. ");
INSERT INTO pwg_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Ma bade kana viaroba ivonatawei ma tuna na ikiivunui. Muriyai na peyarisi sago sago duma ivi vonataweyana inae da viya ivowa kirakiiyesi ma viya ivi kiivunuwana. ");
INSERT INTO pwg_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Vao badana na ina wawaya turina gwabinai da ita vonatawei. Tuna na natuna tomowina ma nuwanuwana ivii kirakiiyei. Murina vaghata na natuna ivonatawei ma ivona bo, ‘Anotanotai da natuku ina vokaravei.’ ");
INSERT INTO pwg_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Ma vao kana koyakoyagha ivi ogatara ma ivona bo, ‘Nokona natuna. Vao badana ina rabobo na weni tanona buderina ina damana da tuna ini rapenei. Tuna kubiine takiivunui ma tanona na tota mani tirapenei.’ ");
INSERT INTO pwg_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Ma vaghina ivotatani, ikiivunui ma gari ku kupuna itawanakiibuwei.” ");
INSERT INTO pwg_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Ma Yesu ivi tarakiiyanesi bo, “Ma vao badana na aviyavisina ina berai? Ina nae da vao kana koyakoyagha ini kiivunuwana ma vao na dam viruwa ina veresi. ");
INSERT INTO pwg_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Ma tami na giruma katamana kovi yavi na damina koviini bo kegha? Igiruma bo, ‘Vonura damsi wakima ibarei, Ma Bada nani wakimina iviiya ma iterei da tepanai numa vuna ivowai. ");
INSERT INTO pwg_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Weni berana Bada iberai na ibiibii kirakai kurita.’” ");
INSERT INTO pwg_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Nani murinai taparoro babadisi i babada ma vonaviyoyovana vibeyebeyena wawayisi keta iekwekwai da Yesu ita paniya, iyamna iakovi da nani miibiina kamonai na ti ivivi wavusi. Ma koroto ghamana iyabumanesi, tuna kubiine ivoterei ma inae. ");
INSERT INTO pwg_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Muriyai Perisi damsi ma Kiivavo Herodi ina wawaya viya ivonatawesi Yesu kurina da iti kaetina. I kayowana da Yesu iti sisiya bero na wavu ita verei. ");
INSERT INTO pwg_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Ipisi Yesu kurina ma ivona bo, “Bada, kakovi da tam tomowa kiimatanim. Tam ke miiriruwaruwam, iyamna namanaki wawaya ghamaghamasi bo wawayota ma peyarisi kurisi am vibeyebeyena na maninina kavakava. Vonavaghata tepanai na God ina keta kibeyebeyena. Ma kevona, Kiivavo Ghamana Sisa ina teks kani miiyei na tuna na bera maninina bo kegha? Tam kivaghinei bo kegha da kani miiyei?” ");
INSERT INTO pwg_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Ma Yesu iakovi da ivivi kaetina na ivonesi bo, “Avi kubiine ku poko kota tereku? Mane sago kokavarapiyei da ana kitai.” ");
INSERT INTO pwg_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Mane sago iverei na ivi tarakiiyanesi bo, “Wena iyi maghighina ivi gubegubei? Ma iyi kana vava igirumi?” Ma ivona bo, “Kiivavo Sisa.” ");
INSERT INTO pwg_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Ma Yesu ivona bo, “Aviyavisina Sisa rapenai na Sisa koverei. Ma aviyavisina God rapenai na God koverei.” Wawaya Yesu ina sisiya ivi yanei da ivi deyei. ");
INSERT INTO pwg_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Ma Sadusi damsi inotai da wawaya ina rabobo na ke ina vomiiri. Ma vikaetina kubiine ipisi Yesu kurina ma ivonei bo, ");
INSERT INTO pwg_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Bada, Moses ina vonaviyoyovana kamonai igiruma da tomowa tatavinena ina rabobo da kawana ina verukuyowei ma natunatusi kegha na varesina sago kwapurina ina ravaghi da ini tuwa. Ma nani ededisi na tomowina raborabobona natunatuna. ");
INSERT INTO pwg_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Vaghina ma, mara sago tomowa titina yoghoyogho miikovimasago. Tomowina itavine ma ke iti tuwa ma irabobo. ");
INSERT INTO pwg_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Tina kikei sago vonaviyoyovana inunuri da kwapurina iravaghi. Ma tuna bade ke iti tuwa ma irabobo. Ma nakanani itupuwa tina kikei viarobina kurina. ");
INSERT INTO pwg_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Nakanani ma tomotomowa miikovimaruwa kwapurina sago iravaghi ma ke sago iyai iti tuwa ma peyarisi irabobomakai. Turina na bade kwapura irabobo. ");
INSERT INTO pwg_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Ma mara damonai God ina berai da wawaya rabobowai ina vomiiri na nani wavinena na iyi kawana, iyamna kakawana miikovimaruwa?” ");
INSERT INTO pwg_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Ma Yesu, Sadusi damsi ivonapotesi bo, “Avi koakovi? Tami koinuwanotanota bero iyamna God vonana ma ina rewapana damina ke kota viini. ");
INSERT INTO pwg_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Mara damonai raborabobosi ina vomiiri ma ti na aneya kiidamowai nakanani, ke ina tavine. ");
INSERT INTO pwg_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Ma vonavaghata ani beyebeyemi da wawaya raborabobosi ina vomiiri. Moses ina giruma kovi yavi da kotakovi da kiikiiruku ikarakarai na God gamona ivi sisiya Moses kurina. Ivona bo, ‘Taku na Abraham, Aisiki ma Jeikap i God ma ti na gwabikuwai emakamakai.’ ");
INSERT INTO pwg_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Weni sisiyina ivi debei da God na ke wawaya raborabobosi ma wawaya yawayawasisi i God. Tuna kubiine koinuwanotanota bero da raborabobosi ke ina vomiiri.” ");
INSERT INTO pwg_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Vonaviyoyovana vibeyebeyena wawayina sago ipisi ma ivi yanei da Sadusi damsi ma Yesu ivivi taghegheyana. Ma bade ivi yanei da Yesu ivonapote bubunisi. Ma kurina ivi tarakiiyana bo, “God ina sisiya bagibagisi kudubina kamosiyai na meni tuna irakata kirakai?” ");
INSERT INTO pwg_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Ma Yesu ivonapotei bo, “Sisiya bagibagina ghamanakina na weni. ‘O Israel kovi yana, ita Bada God na sago kava, ma tuna kava na Bada. ");
INSERT INTO pwg_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Nuwanuwami kudubinai, kanumimi kudubinai, ami nota kudubinai ma ami rewapana kudubinai da ami Bada God kurina kovi nuwaviina.’ ");
INSERT INTO pwg_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ma sisiya bagibagina kana viruwa na weni. ‘Ikikava tam mani kinuwaviina meyem, nakanani kwinam nuwanuwana keviiya.’ Ke meni sisiyina bagibagina weni ivi ruwa ita ghekuyowesi.” ");
INSERT INTO pwg_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Ma vonaviyoyovana vibeyebeyena wawayina ivona bo, “Kuvi sisiya bubuna da ita Bada God na sago kava ma tuna kava na God. ");
INSERT INTO pwg_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Ma nuwanuwata kudubinai, kanumita kudubinai, ita nota kudubinai ma ita rewapana kudubinai na ita Bada God kurina tinuwaviina. Ma bade ikikava tinuwaviina meyeta, nakanani kwinata nuwanuwana taviiya. Weni berasi na bera ghamaghamasi, ke verena ma suwara kapukapunina nakanani.” ");
INSERT INTO pwg_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Ma Yesu ivi yanei da ivonapote bubuna ma ivonei bo, “Tam na gisina kava ma God ina ku vikiivavona kuna rui.” Ma nani murinai ke sago iyai iti tepatora da Yesu kurina iti tarakiiyaname. ");
INSERT INTO pwg_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Yesu Taparoro Numana garina kamonai ivivi beyebeyena na wawaya ivi tarakiiyanesi bo, “Avi kubiine vonaviyoyovana vibeyebeyena wawayisi evonavona da God ina Vivinevine Wawayina na Kiivavo David tupurereghina? ");
INSERT INTO pwg_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Kanuma Vovokaravina David itowatepani da ivona bo, ‘Bada God ivi sisiya aku Bada kurina. Ivona bo, Katagheyakuwai kuna makamakai da kam ghavighaviya kudubina ku kae gaburim ana teresi.’ ");
INSERT INTO pwg_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","David ivona da God ina Vivinevine Wawayina na ina Bada. Ma nakanani ivi sisiya iyamna God ina Vivinevine Wawayina na David tuna mani tupurereghina kamosiyai?” Ma koroto ghamana nuwabiibiiyai Yesu ivivi yana bogai. ");
INSERT INTO pwg_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Yesu ivivi beyebeyena inenae da ivona bo, “Vonaviyoyovana vibeyebeyena wawayisi na kokitaruvisi. I kayowana da iti wawayaghama. Tuna kubiine gara rurukarukaruwesi ini kote ma nakanani ina baba yawara. Ma i kayowana da vigimagimara gawarisi kamosiyai wawaya ina vokaravesi ma ini kiikiiwesi. ");
INSERT INTO pwg_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Ma bade kiki numasiyai ma kamporagha marasiyai i kayowana da babada kii gawariyai ina makai. ");
INSERT INTO pwg_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Kwapukwapura iberoberowesi da i numa ma i sawara irapenei. Ma kayotata notasi gwabisiyai, tuna kubiine debiiyai eniponipowana guriguri. Iyavo kava nakanani eberaberai na kovogha berona ina viiya.” ");
INSERT INTO pwg_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Yesu na Taparoro Numana garina kamonai ma inae da suwara gawarina ririnai imakiipika. Ma iyavo kava i suwara ivereverena na ikitakita bogiisi. Ikita da mura wawayisi peyarisi mane ghamaghamasi itutura. ");
INSERT INTO pwg_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Ma kwapura moyamoyakina ipisi da mane riririghina ivi ruwa kava iterei. ");
INSERT INTO pwg_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Ma Yesu kana kivikivina ikwaturiyariyesi ma ivonesi bo, “Vonavaghata avonavonemi, weni kwapurina moyamoyakina ina verena irakata kirakai, ke wawaya peyarisi nakanani. ");
INSERT INTO pwg_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Peyarisi i mura nevanevasi iverena. Ma weni kwapurina na moyamoyakina ma kana makii kavakava na kudubina itere yavui.” ");
INSERT INTO pwg_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Yesu Taparoro Numana ikiikiibutawei na kana kivikivina sago ivona bo, “Bada, kekitai. Wakima irakarakateyana vaghata! Taparoro Numana kana kita ibiibii kirakai!” ");
INSERT INTO pwg_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Ma Yesu ivonesi bo, “Weni Taparoro Numana ghamana koideyei, bo? Mara sago wawaya weni wakimisi kudubina ina rikatawei da ke sago wakimina kwinana tepanai ina kena. Peyarina ina kuririghi ku tano.” ");
INSERT INTO pwg_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Yesu na Oliv koyana baranai imakamakai ma anagha nevanai na Taparoro Numana imiimiiri. Ma Pita, Jemes, Jon da Anduru ivi tarakiiyana gavui bo, ");
INSERT INTO pwg_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Kevona. Weni berasi kuvi sisiyei na mara avai ina tupuwa? Ma avi matakirina ini nao, ini akovikai da weni berasi na gisina kava ina tupuwa?” ");
INSERT INTO pwg_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Ma Yesu ivonesi bo, “Matami ekita da wawaya ke ini beroberowemi. ");
INSERT INTO pwg_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Wawaya ipeyari avakuwai ina pisi ma ina vonavona da ti na God ina Vivinevine Wawayina. Ma bade wawaya ipeyari kirakai i vibero ini tumaghanei. ");
INSERT INTO pwg_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Sisiya koni yanei da ghaviya dobu rabarabai etuputupuwa bo sisiya kona viiya da ghaviya kurimi epipisi na ke kona yabumana. Weni berasi ini nao ma mara damona na karakava da ina pisi. ");
INSERT INTO pwg_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Dam sago ina vomiiri da dam viruwa kana ghaviya. Ma dobu sago ina vomiiri da dobu viruwa kana ghaviya. Ma nukenuke dobu bogii ma bogiiyai ina tuputupuwa ma bade gomara yavata. Weni berasi na nakanani ma wavine vituwa ita dagui na inivisina iti karei.” ");
INSERT INTO pwg_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Matami ekita ma kovi rewapana. Ina patumimi ma vitupavira babadisi ku imasi ina teremi da kiki numasiyai ina widimi. Taku kubiiku ina patumimi da babada ghamaghamasi ma kiikiivavo maghinosiyai kona miiri da ini tupaviremi. Ma God varana biibiina koni mamatarei kurisi. ");
INSERT INTO pwg_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Ma kunona wawaya God varana biibiina ina dimei da dam ma dam kudubisi ini yanei ma muriyai mara damona ina nekiibau. ");
INSERT INTO pwg_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Ma maranai ina patumimi ma ini tupaviremi na ke koni nuwapoya da ikikava koni sisiya. Maghinosiyai kona miiri na nani kamonai God nota ina vereveremi na kovi sisiyei. Nakanani kona berai na ke tami kota vivisisiya, ma Kanuma Vovokaravina ini sisiya kubiimi. ");
INSERT INTO pwg_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Wawaya ina vomiiri da varesina ini wawanei. Ma bade morapa tuna mani natuna ini wawanei. Ededa i maduwa mau ma i mami mau ini ghaviyesi na kii puka ina vowai. ");
INSERT INTO pwg_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Kokivikiviniku kubiine na wawaya kudubisi ina baremi. Ma iyi tam kuna miirikikina da ku damona na yawasa makamakii nonowina kuna panani.” ");
INSERT INTO pwg_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Mara sago kona kitai da ‘Sawara Bero Kirakiina’ Taparoro Numana kamonai God kana gawara ina viiya da gawarina vovokaravina ina puyaki.” (Viyava wawayim na damim kevii bubuni.) “Nani maranai iyavo kava Judiya kamonai komakamakai na yaghiyaghinai ku koya koverau. ");
INSERT INTO pwg_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Ma tam iyai matarai kemakamakai ke kuna rui ku numa kamona da am sawara kuna yuna. ");
INSERT INTO pwg_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Wawaya vao kamonai na veru kevi karei, ke kuna vovira ku numa da kam gara kuna yuna. ");
INSERT INTO pwg_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Nani maranai wivine manamanawisi ma vivisususi na ini kamyuyuwa kirakai. ");
INSERT INTO pwg_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Konipowana kirakai da weni nuwapoyisi ke nuba kana mara kamonai ina tupuwa. ");
INSERT INTO pwg_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Nani marasiyai na nuwapoya ina rakata kirakai, ke mara karenai God dobu iyamoni da ku karako nakanani. Ma murinai nani nuwapoyisi ke meyani ina tupuwame. ");
INSERT INTO pwg_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Nani marana berona ita guri kirakai na wawaya kudubisi ita rabobo yavu. Tuna kubiine God ina boriya da tupona, iyamna iyavo kava ivovinesi da ina wawaya na ini kamyuyuwesi.” ");
INSERT INTO pwg_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Nani maranai mikeda wawaya ina vonemi bo, ‘Kokitai, God ina Vivinevine Wawayina ipisi!’ bo ‘Kokitai, God ina Vivinevine Wawayina nokoni!’ na ke koni tumaghanei, ");
INSERT INTO pwg_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","iyamna Keriso vivibero ma peroperoveta vivibero ina pisi ma bera ma matakira ghamaghamasi ina berai, ina bera tovoni da God ina wawaya vovinesi ini noraveyana berosi. ");
INSERT INTO pwg_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Tuna kubiine kokitaruvimi. Vaghina, mara damona kana bera na karakava ina tupuwa ma namada kudubina avi mamataremi.” ");
INSERT INTO pwg_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Ma nani nuwapoyisi murinai, ‘Madegha ina didibari ma nawaravi yaseganina kegha. ");
INSERT INTO pwg_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Gwamegwame kiidamowai ina ririgha, ma aviyavisina kudubina kunumai na ini nuke yavu.’ ");
INSERT INTO pwg_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Nani maranai wawaya kudubisi ina kitai da taku Wawaya Natusi kwavuwai ere rewapaniku ma ere kadariku anororu ku dobu. ");
INSERT INTO pwg_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ma aku aneya ana vonatawesi da dobu ku kudubina ina ne yavui. Ma God ina wawaya vovinesi ina rutinisi da ini kiidaburana.” ");
INSERT INTO pwg_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Kovi yana, kii kona kitai na ini beyemi. Kiina enumonumoi na namada akovina koviiviiya da kwamra kana mara epipisi. ");
INSERT INTO pwg_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Ma bade maghimaghighina, nani berasi avivi sisiyei ina tuputupuwa na konakovi da mara damona gisina kava ina pisi, marana namada enenekiibau. ");
INSERT INTO pwg_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Vonavaghata avonavonemi da weni kimitina ke ina rabobo yavu ma berasi ina tupuwa. ");
INSERT INTO pwg_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Kunuma ma dobu ina wapa ma vonaku na ke meyani da ina wapa.” ");
INSERT INTO pwg_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Ke sago iyai itakovi da avi maranai weni berasi aisisiyei na ina tupuwa. Aneya kunumai ke itakovi ma bade nakanani taku God Natuna ke atakovi. Aku Mamai ina kina kava iakovi. ");
INSERT INTO pwg_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Tuna kubiine kokitaruvimi ma mara nonowa na kovovunagha meyemi, iyamna ke kotakovi da mara avai ana vovira. ");
INSERT INTO pwg_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Tuna nakanani ma tomowa sago ita numataya. Muriyai da ita nae na ina bigabiga sago sago duma i biga iveresi. Ma bade matuketa kana koyakoyagha ivonei bo, ‘Matam ekita.’ Ma ivomiiri, ina numa ivoterei. ");
INSERT INTO pwg_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Ma tami bade nakanani, matami ekita, iyamna ke kotakovi da avi maranai numa badana ina vovira. Raviyai bo didibara punai, kokoreko ina vivitutuwana kamonai bo mara tomtomwai. ");
INSERT INTO pwg_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Yaghiyaghinai ina nekiibau na ke ita biibai da ina pananimi da kokenakena. ");
INSERT INTO pwg_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Weni sisiyina avonavonemi na bade wawaya kudubisi kii sisiya. ‘Matami ekita.’” ");
INSERT INTO pwg_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Mara ruwa kava imakamakai da Pasova kamna kana mara ma nani murinai na kam ghamana sago kana vava ‘Parawa Vivikiipanina.’ I kiki da nani kamna kubiine kii parawa kamonai na yist ke ina terei. Ma taparoro babadisi i babada ma vonaviyoyovana vibeyebeyena wawayisi ivi ogatara da gavunai Yesu ita paniya da iti raboboi. ");
INSERT INTO pwg_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Ma ivona bo, “Ke Pasova kamna kamonai taberai. Ina wawaya nuwanuwasi ita pughu da iti kayotirana.” ");
INSERT INTO pwg_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Ma Yesu na Betani meyaginai ma Saimon Giigiipona ina numa kamonai nevanevasiyai ikenavipika da ikamkam. Ma wavine sago diudeu ikavarapiyei, kamonai na oira ghabughabuna, kana mane na ghamanakina. Ma diudeu kana terepapara ivotawei, ma muriyai na virina ivotawei da oira Yesu ku gayamina itepoi. ");
INSERT INTO pwg_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Wawaya viya nani berana ke iti vaghinei da ti mani inipusi ma ivona bo, “Avi kubiine oira irekwei? ");
INSERT INTO pwg_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Tuna iti gimarei na mane ghamana ita panani da wawaya moyamoyakisi ita veresi.” Ma wavinena iyegha kirakiiyei. ");
INSERT INTO pwg_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ma Yesu ivona bo, “Kovoterei, ke kona yeghai. Tuna bera biibiina ma nuwaviiviinina kuriku iberai. ");
INSERT INTO pwg_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Mara iguri da wawaya moyamoyakisi yavata kona makii patapata da koni vitesi. Ma taku na ke mara gurina yavata tamakai. ");
INSERT INTO pwg_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Weni wavinena nota iviiya da weni berana biibiina iberai kuriku. Oira ghabughabuna itepoi na tupuwiku ivovunaghi da ke mara gurina ma wawaya ku karawaga ina tereku. ");
INSERT INTO pwg_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Vonavaghata avonavonemi, dobu ku kudubina wawaya God varana biibiina ina dimadimei na bade weni wavinena aviyavisina karako iberai na ini sisiyei da notana ina makii nonowa.” ");
INSERT INTO pwg_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Ma nani murinai Judas Iskariyot ivomiiri inae. Tuna na Yesu ina wawaya ivi 12 kamosiyai ma inae taparoro babadisi i babada kurisi da Yesu iti wawanei. ");
INSERT INTO pwg_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Damsi ivi yanei da nuwanuwasi ibiibii kirakai ma vonakiiyapa bagibagina kurina iterei da imana ina kovoghi. Ma Judas ivi karei da keta iekwekwai da Yesu ku imasi ita terei. ");
INSERT INTO pwg_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Kam ghamana kana vava ‘Parawa Vivikiipanina’ na marana inekiibau. Ma i kiki da weni kamna kubiine parawa kamonai na yist kegha. Weni kamna ghamana ina verau da taparoro sago ina kovi ma karenai sipu gegeyina ina kiivunui ma ina kani da Pasova ina notai. Ma kana kivikivina Yesu ivi tarakiiyanei bo, “Mike kana nae da kana vovunagha da Pasova kamna taberai?” ");
INSERT INTO pwg_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Ma kana kivikivina ruwa ivonatawesi, ivonesi bo, “Korui ku Jerusalem ma tomowa sago kona panani, tuna okowa kibubuna ina kavakavari na kokivini. ");
INSERT INTO pwg_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Ma meni ku numana ina rui na tuna wawayina na numa tuwakarena kurina kovona bo, ‘Akii Bada ekayokayowei da am numiiyai Pasova kamna ina berai. Ivi nowi da numataya i tupayaragha kamonai kuna terekai da tokai kana kivikivina yavata kana kam patapata.’ ");
INSERT INTO pwg_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ma tomowina tupayaragha ghamana kiidamowai ini beyemi, kamonai na namada ivovunaghi ikovi ma sawara kudubina itura. Ma tami nani dobunai kona vokuyakuya ma kona vovunagha kubiita.” ");
INSERT INTO pwg_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Ivi ruwa inae ku Jerusalem da Yesu ikikava ivonavonesi na nakanani ipanani. Ma Pasova kamna ivovunaghi. ");
INSERT INTO pwg_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Ravi ipika na Yesu turaturana ivi 12 yavata inekiibau. ");
INSERT INTO pwg_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Ma nevanevasiyai ikenavipika da ikamkam na Yesu ivona bo, “Vonavaghata avonavonemi, wawaya sago kamotiyai ini wawaneku, wawayina yavata takamkam patapata.” ");
INSERT INTO pwg_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Turaturana nani sisiyina ivi yanei da ivi nuwapoya kirakai. Ma sago sago duma ivona bo, “Bada, taku bo iyai? Ma taku adami kaviku.” ");
INSERT INTO pwg_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Ma Yesu ivonesi bo, “Wawayina na tami ami vi 12 kamomiyai. Tuna na taku yavata parawa ku dabira kavovokutuva patapatai. ");
INSERT INTO pwg_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Ikikava giruma katamana namada ivona da Wawaya Natusi ita rabobo na nakanani ina tupuwa. Ma meni wawayina ini wawaneku na iti nuwapoya kirakai, iyamna kovogha berona ina panani. Tuna kubiine ita biibai da nani wawayina ke ita tupuwa ku dobu.” ");
INSERT INTO pwg_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Ikamkam na Yesu parawa iviini ma God ivi kiikiiwei, ma ivogimagimai da kana kivikivina iveresi. Ma ivonesi bo, “Koviiya, wena tupuwiku.” ");
INSERT INTO pwg_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Muriyai redu iviiya ma God ivi kiikiiwei, ma iveresi da peyarisi iuma. ");
INSERT INTO pwg_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Ma ivonesi bo, “Wena taraku, ina sororo da wawaya peyarisi ini yawasisi. Karako imatakira da God ina vivaghina makamakiina ina wawaya yavata eberaberai. ");
INSERT INTO pwg_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Vonavaghata avonavonemi, wain ke anuma meyei da karakava nokoni ku marana God ina vikiivavona kamonai wain vuna anumai.” ");
INSERT INTO pwg_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Ma vokavara tavorina sago iravi ma peyarisi ikiibau inae ku Oliv koyana. ");
INSERT INTO pwg_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Yesu kana kivikivina ivonesi bo, “Peyarimi ami nota ina peku da kona verukuyoweku. Giruma katamana evonavona bo, ‘Sipu kana koyakoyagha ina kiivunui, ma sipu yavona ini verubogebogesi.’ ");
INSERT INTO pwg_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Ma ana vomiiri na ani nao ku Gariri ma nani dobunai ana pananimi.” ");
INSERT INTO pwg_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Ma Pita ivona bo, “Turaturata peyarisi ina verukuyowem ma taku na ke ana voterem.” ");
INSERT INTO pwg_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Ma Yesu ivonapotei bo, “Vonavaghata avonavonem, karako weni didibarinai, muriyai da kokoreko mara viruwina ita tou na mara aroba kuni bero da ke kuta koviku.” ");
INSERT INTO pwg_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Ma Pita ina sisiya bagibagina iterei da ivona bo, “Ke ana vonabarem! Mikeda taku na tam yavata iti rabobota na kara ke ana voterem.” Ma kana kivikivina peyarisi nakanani ivivi sisiya. ");
INSERT INTO pwg_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Yesu kana kivikivina yavata inae ku nawaba sago kana vava Getsemani, ma ivonesi bo, “Weni dobunai komakai ma ana nae noke da ana nipowana.” ");
INSERT INTO pwg_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Ma Pita, Jemes da Jon irutinisi da yavata inae. Ma ivi karei da nuwanuwana ipoya kirakiiyei da damina ibero kirakai. ");
INSERT INTO pwg_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Ma ivi aroba ivonesi bo, “Nuwapoya tepanai ma tepanai da vitana irakata, ma tuna ekiikiivunuku. We komakai ma matami ekita.” ");
INSERT INTO pwg_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Ma Yesu inae gisina ma ivi tuwaporeruruwana ma itawotei da gayamina ioru ku tano. Ma inipowana ina Mamai kurina, ivi nowi da kovokovoghina bo kegha da vokwarakwara marana maghinonai epipisi na ita veruvuvurei. ");
INSERT INTO pwg_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Ma ivonatou bo, “Abba, Mamai, kade weni vokwarakwarana reduna gwabikuwai kuta viitawei. Bera peyarina kurim na itekateka kirakai. Ma kegha da ke taku aku kayowana, ma tam am kayowana keberai.” ");
INSERT INTO pwg_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Ma ivovira da kana kivikivina ivi aroba ipananisi da ivivi keneyana ma ivona bo, “Saimon Pita, avi kubiine kekenakena? Kade mara gisina kava kuta makamakai ma kuta kitakita. ");
INSERT INTO pwg_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Matami ita kita ma kota nipowana da maranai ruyagha ina nekiibau na ke kona peku. Kanumimi i kayowana da biibiina kota berai ma tupuwimi na mitamitasi.” ");
INSERT INTO pwg_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Ma ivomiiri inae da kunona ikikava inipowana na bade nakanani inipowaname. ");
INSERT INTO pwg_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Ma ivovirame na bade ipananisi da matasi ikiikovoghi da ikena nunuwapa. Ma ti na ke itakovi da ikikava ita vonei. ");
INSERT INTO pwg_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Ma mara viarobina ivovirame ma ivonesi bo, “Tami kokenakena, bo? Patana da koiyakam, bo? Kena kovoterei. Marana inekiibau. Kokitai, taku Wawaya Natusi ini wawaneku da berabero wawayisi ku imasi ina tereku. ");
INSERT INTO pwg_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Kovomiiri. Tanae. Kokitai, wawayina ini wawaneku na enenekiibau.” ");
INSERT INTO pwg_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Yesu ivivi sisiya ma Judas inekiibau, tuna bade na kana kivikivina sago. Ma tuna murinai na koroto ghamana seri da kepata ikavara. Taparoro babadisi i babada, vonaviyoyovana vibeyebeyena wawayisi ma Jiu damsi i babada ivonatawesi. ");
INSERT INTO pwg_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Ma Judas namada koroto ivonesi bo, “Weni nakanani ani matakira. Tomowa sago ana yoni na konakovi da vaghina wawayina. Ma tuna kona paniya ma kona rutinaneyei.” ");
INSERT INTO pwg_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Vaghina ma Judas maninina inae Yesu kurina ma ivona bo, “Bada,” ma iyoni. ");
INSERT INTO pwg_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Ma nani korotona Yesu ivotani da ipaniya. ");
INSERT INTO pwg_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Ma Yesu ina wawaya sago ina seri itina yavui da taparoro badana ina bigabiga tinina ikiiyaraghatawei. ");
INSERT INTO pwg_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Ma Yesu ivonesi bo, “Taku ke tomowa nuwaghakighakiku bo kayakayayiku da seri ma kepata kota kavarapiyei da kota paniku. ");
INSERT INTO pwg_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Mara nonowa Taparoro Numana garina kamonai avivi beyebeyena ma ke kota paniku. Ma ikikava giruma katamana ivona da ita tupuwa na nakanani etuputupuwa.” ");
INSERT INTO pwg_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Ma kana kivikivina kudubisi Yesu iverukuyowei. ");
INSERT INTO pwg_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Ma kana kivikivina sago, tuna na yaragina ere kaperona. Ita verau ma nani korotona ibera tovoni da ita votani ");
INSERT INTO pwg_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","ma kegha, kana kapero kava itinatawei ma yaragina iyuna kava iverau, kana kapero iverukuyowei. ");
INSERT INTO pwg_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Yesu irutini da taparoro badana ghamana ina ku numa. Ma Sanhidran babadisi kudubisi ivi kiidaburana, ti na taparoro babadisi i babada, Jiu damsi i babada ma vonaviyoyovana vibeyebeyena wawayisi. ");
INSERT INTO pwg_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Ma Pita na kana taraboga ma ikivikivinisi da taparoro badana ghamana ina ku numa garina irui. Ma nani kamonai potapota wawayisi yavata imakai da ivivi rarana. ");
INSERT INTO pwg_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Ma taparoro babadisi i babada ma bade iyavo kava Sanhidran kamonai na kudubisi keta iekwekwai da Yesu iti wavui da iti raboboi. Ma ke sago wawaya ita panani da iti mamatara da berona iberai. ");
INSERT INTO pwg_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Wawaya peyarisi ivivi mamatara bero da Yesu iti wavui ma i sisiya bogii ma bogiiyai na viviberosi. ");
INSERT INTO pwg_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Ma turinai wawaya viya ivomiiri da Yesu iti wavui. Vimamatara vibero iterei, ");
INSERT INTO pwg_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","ivona bo, “Weni tomowina kavi yanei da ivona bo, ‘Weni Taparoro Numana na wawaya imasiyai ivowai, ma taku na kudubina ana rikatawei. Ma mara aroba kamonai sago vuna ana vowai, ma tuna na ke wawaya imasiyai ina vowai.’” ");
INSERT INTO pwg_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ma patana da i nota bogii ma bogiiyai itereterei da ke sago iyai kwinana yavata i nota iti sagoi. ");
INSERT INTO pwg_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Vaghina ma, taparoro badana ghamana ivomiiri da peyarisi maghinosiyai Yesu ivi tarakiiyanei bo, “Weni wawayisi iwavum na kam papara kuna vowai bo? Kade i sisiya kuna kovoghi bo kegha?” ");
INSERT INTO pwg_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Ma Yesu kawana ipota da ke sago ita vonapotei. Ma bade ivona bo, “Tam na God ina Vivinevine Wawayina bo kegha? God tavovokavakavari ma vonavaghata bo kegha da tam na natuna?” ");
INSERT INTO pwg_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Ma Yesu ivona bo, “Vaghina, taku. Ma mara sago taku Wawaya Natusi kona kitiku da God Rewapana Kirakiina katagheyanai ana makamakai ma bade kona kitiku da kwavuwai anororu ku dobu.” ");
INSERT INTO pwg_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Ma taparoro badana ghamana nuwanuwana ipughu kirakai da tuna mani kana gara itinasikai. Ma ivona bo, “Ke sago vimamatara wawayina tekwai da ini wavui, ");
INSERT INTO pwg_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","iyamna namada kovi yanei da God ivi avaberowei. Ma tami ikikava konotanotai?” Ma kudubisi ivonakiiyaragha da ibera beroi ma kana kovogha na rabobo. ");
INSERT INTO pwg_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Ma wawaya viya ivi karei da Yesu ikanukanui. Ma gara iviiya da matana ikupotai ma imasi ivovidubidubini da iraravi. Ma ivonavonavinamei bo, “Tam peroveta bo? Kevonekai da iyi iravim.” Muriyai potapota wawayisi Yesu irutini da ivowa kirakiiyei. ");
INSERT INTO pwg_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Pita na numa garina kamonai imakamakai ma taparoro badana ghamana ina bigabiga wavinena ipisi ");
INSERT INTO pwg_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","ma ita kita da Pita ivivi rarana na ikita bogai ma ivonei bo, “Tam na Yesu kwinana, nani Nasaret tomowa ina wawaya.” ");
INSERT INTO pwg_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Ma Pita ivona bo, “Taku nani tomowina ke atakovi. Ke atakovi da aviyavisina kisisiyei.” Ma ikiibau da gari ku matuketina ma yaghiyaghinai kokoreko itou. ");
INSERT INTO pwg_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Ma wavinena Pita ikitai da nani gawarinai imiimiiri ma iyavo kava ririnai ivivi miiriyana na ivona meyesi bo, “Ina wawaya sago na weni.” ");
INSERT INTO pwg_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Ma Pita ivi berome da Yesu ivonaveyaveyiyei. Ke mara gurina ma wawaya Pita ririnai imiimiiri na ivonei bo, “Vonavaghata da tam na Yesu ina wawaya sago, iyamna tam na Gariri wawaya.” ");
INSERT INTO pwg_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Ma Pita ivona bo, “Taku ani bero na God kovogha ina vereku. Nani tomowina kisisiyei na ke atakovi.” ");
INSERT INTO pwg_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Vaghina ma, yaghiyaghinai kokoreko itume. Ma Pita ina nota ivovira ma Yesu ina sisiya inotapanani da tuna ivona bo, “Mara aroba kuni bero da ke kutakoviku ma murinai kokoreko mara viruwina ina tou.” Ma Pita itupagavovora da itou. ");
INSERT INTO pwg_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Mara boiboi vaghata Sanhidran damsi ivi kiidaburana. Ti na taparoro babadisi i babada ma Jiu damsi i babada ma vonaviyoyovana vibeyebeyena wawayisi na kudubisi Yesu ivivi dughuwei da vivaghina iberai. Ma imana ikutatani ma irutini inae Pailat kurina. ");
INSERT INTO pwg_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Ma Pailat, Yesu ivonei bo, “Tam Jiu damsi i kiivavo bo?” Ma Yesu ivonapotei bo, “E, ikikava kisisiya na taku nakanani.” ");
INSERT INTO pwg_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Ma taparoro babadisi i babada wavu kudubina Yesu kurina iterei. ");
INSERT INTO pwg_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Tuna kubiine Pailat ivi tarakiiyanei bo, “Kade, kuna vonapotesi da kam papara kuna vowai bo kegha? Kiyanei da wavu kudubina kurim etereterei.” ");
INSERT INTO pwg_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Ma Yesu ke sago aviyavisina ita vonapotei. Ma Pailat ivi deyei da tuna mani kana papara ke ita vowai. ");
INSERT INTO pwg_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Pailat ina bera imakamakai da Pasova kamna nununai wawaya sago gabura kamonai ivovotawei. Koroto i kayowana iyai na tuna wawayina ini kiibuni. ");
INSERT INTO pwg_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Ma wawaya viya gabura kamonai, ti na Israel damsi ma ivomiiri da ivi ghaviya da Rome damsi ita kwavinisi. Ma nani viruwina kamonai wawaya viya ivi kiivunuwana. Tuna kubiine gabura ku kamona iteresi. Ma sago kana vava na Barabas. ");
INSERT INTO pwg_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Ma Yesu patana da Pailat maghinonai imiimiiri na koroto ghamana ipisi ma Pailat ivonei da i kayowana da ikikava madegha nununai iberaberai na nakanani ina berai, wawaya sago gabura kamonai ita terekiibuwei. ");
INSERT INTO pwg_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Ma Pailat koroto ivi tarakiiyanesi bo, “Ami kayowana iyai? Kokayokayowei da Jiu dami ami kiivavo ana votawei, bo?” ");
INSERT INTO pwg_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Nakanani ivi tarakiiyanesi iyamna iakovi da taparoro babadisi i babada Yesu inuwakapiyei, tuna kubiine ipaniya ma irutinaneyei kurina. ");
INSERT INTO pwg_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Ma taparoro babadisi i babada koroto nuwanuwasi ipiroi da peyarisi ke i kayowana Yesu. I kayowana da Barabas ita votawei. ");
INSERT INTO pwg_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Ma Pailat ivona bo, “Ma aviyavisina ana berai weni tomowina kurina, tami kovonavona da tuna na Jiu dami ami kiivavo?” ");
INSERT INTO pwg_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ma korotona ikiirarapotei bo, “Kotuparatui.” ");
INSERT INTO pwg_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Ma Pailat ivona bo, “Avi kubiine? Aviyavisina ibera beroi?” Ma kegha, korotona gamosi irakata da ikarayogosi bo, “Kotuparatui!” ");
INSERT INTO pwg_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Ma Pailat ina kayowana da nani korotona iti nuwabiibiinisi da nuwanuwasi ita pika. Tuna kubiine Barabas gabura kamonai ivi kiibuni. Ma seri wawayisi ivonesi da Yesu iwidi kirakiiyei ma ivonatawei da ita tuparatui. ");
INSERT INTO pwg_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Seri wawayisi Yesu irutinaruwei da Pailat ina numa garina ku kamona. Ma gawara kana vava Praitoriyum ku kamona irui ma turaturasi ikwaturiyariyesi. ");
INSERT INTO pwg_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Tarasovo yebayebarina iviini da Yesu ivi kotei. ");
INSERT INTO pwg_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Ma ivi karei da ivonavonavinamei bo, “Kiiwa kiiwa! Tam Jiu damsi i kiivavo ghamam!” ");
INSERT INTO pwg_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Ma diwona ikavarapiyei da gayamina iraravi ma bade ikanukanui. Ivivi tuwaporeruruwana ma ere vivinamesi irurunomei. ");
INSERT INTO pwg_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Ivi namei ikovi na tarasovo yebayebarina ivotawei ma kana gara vaghata ivi kote meyei. Ma irutinakiibuwei da ita tuparatui. ");
INSERT INTO pwg_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Ketiyai inenae ma tomowa kana vava Saimon ipanani, tuna wekarakava dobu rabarabai ipisi da ku Jerusalem irurui. Tomowina ina dobu Sairini ma natunatuna kii vava Ariksanda ma Rupas. Seri wawayisi ikwatui ma idarui da Yesu kana korosi ita kavari ma yavata ita nae. ");
INSERT INTO pwg_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Ma Yesu irutini inae da ku gawara kana vava Gorugata, nani vavana iyamna ‘Teuteu Gawarina.’ ");
INSERT INTO pwg_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Ma wain ita verei da itumai, kamonai na gegura kana vava meya ivirai. Ma Yesu ibarei. ");
INSERT INTO pwg_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Ma muriyai na ituparatui. Ma kana gara ita vorereghi kubiine na virekwa sago iberai da kamosiyai Yesu kana gara irereghi. ");
INSERT INTO pwg_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Marana ituparatui na madegha namada ivovomuyamuya. ");
INSERT INTO pwg_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ma gayamina tepanai giruma sago itutui ivi debei da avi wavuna ikavakavari. Igiruma bo, “Jiu damsi i kiivavo.” ");
INSERT INTO pwg_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Ma yapiyapi wawayisi ruwa yavata ituparatusi, sago ku katagheyana ma sago ku dugena. ");
INSERT INTO pwg_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","(-) ");
INSERT INTO pwg_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Ma wawaya ketiyai ibababa na ivivi avaberowei ma gayamisi ivivi ruruwini. Ikiikiirara bo, “Damidamina! Taparoro Numana kuta rikai ma mara aroba kamonai kuta vowa meyei. ");
INSERT INTO pwg_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Korosi tepanai keoru da kuni yawasa meyem!” ");
INSERT INTO pwg_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Ma bade nakanani taparoro babadisi i babada ma vonaviyoyovana vibeyebeyena wawayisi Yesu ikarakara vibagibagiyei. Ma ti mani kamosiyai ivonavona bo, “Wawaya ivivi yawasisi ma ke kovokovoghina da tuna mani ini yawasa meyei. ");
INSERT INTO pwg_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Ivona da tuna na God ina Vivinevine Wawayina ma Israel ina kiivavo. Mede wekarakava korosiyai eoru da takitai ma titumaghanei.” Ma tomotomowa ruwa Yesu yavata ituparatusi na ti bade ivi avaberowei. ");
INSERT INTO pwg_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Madegha punai dobu kudubina ivi didibara yavui ma nakanani imakai da madegha inubanuba kana ku mara. ");
INSERT INTO pwg_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Ma tuna maranai Yesu ikiirara bo, “Eloi, Eloi, lama sabachthani?” iyamna, “Aku God, aku God, avi kubiine kukuyoweku?” ");
INSERT INTO pwg_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Ma wawaya viya ririnai imiimiiri na ivi yanei ma ivona bo, “Kovi yana, Elaidiya ekwatukwatui.” ");
INSERT INTO pwg_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Ma tomowa sago iverau da gumba ivokutuvi wain tomatomana ku kamona ma kiiyai ivi kavini ma ivororona da Yesu ita susui. Ma ivona bo, “Wekarakava na tavoterei. Takitai da kade Elaidiya ina pisi da ina tereoruwei.” ");
INSERT INTO pwg_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Ma Yesu ikiirara, yana turina itawei ma irabobo. ");
INSERT INTO pwg_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Irabobo na Taparoro Numana garana itamosika da ruwa. Tepanai da ioru ku kapina. ");
INSERT INTO pwg_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Ma senturiyon, tuna seri wawayisi i bada Yesu maghinonai imiimiiri na ivi yanei da ikiirara, ma ikitai da ikikava irabobo. Ma ivona bo, “Vonavaghata, weni tomowina na God Natuna.” ");
INSERT INTO pwg_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Ma wivine viya gisina rabarabai imiimiiri ma kamosiyai na Meri Magadarini, Sayome ma Meri (tuna na Jemes murimurina ma Joses i maduwa). ");
INSERT INTO pwg_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Weni wivinesi na Yesu ikivikivini, yavata ibababa Gariri kamonai da ikoyakoyaghi. Ma bade wivine viya ikivini, ti na yavata ighae ku Jerusalem. ");
INSERT INTO pwg_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Vovunagha marana kamonai na Yesu irabobo. Ravi ita pika na viyakam marana iti karei. Gisina kava ravi ita pika, ");
INSERT INTO pwg_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","tuna kubiine tomowa sago kana vava Josepa Arimateya ivi yaghiyaghina ma ere tepatorana inae Pailat kurina. Tuna na wawaya ghamana Sanhidran kamonai ma nimonimoriyai ivivi koyakoyagha da God ina vikiivavona ita pisi. Inae ma ivi nowi da Yesu tupuwina ita viiya. ");
INSERT INTO pwg_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pailat ivi yanei da Yesu namada irabobo ma ivi deyei. Senturiyon ikwatui ma ivi tarakiiyanei da vonavaghata da irabobo bo kegha. ");
INSERT INTO pwg_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Ma akova senturiyon gwabinai iviiya da irabobo ikovi na ivi vaghinei da Josepa, Yesu tupuwina ita viiya. ");
INSERT INTO pwg_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Ma Josepa inae da gara vuna igimari ma Yesu tupuwina korosiyai itereoruwei da igerei, ma buba ku kamona iterei. Bubana na koya baranai itarai da karawaga iyamoni. Muriyai wakima ghamana itabiri inae da bubana igudupotai. ");
INSERT INTO pwg_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Ma Meri Magadarini ma Joses ina maduwa Meri na ivi ruwa ikitai da tupuwina meni dobunai iterei. ");
INSERT INTO pwg_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Viyakam marana ikovi na Meri Magadarini, Jemes ina maduwa Meri ma Sayome oira ghabughabusi igimara da ita nae Yesu tupuwina ita vovisiboi. ");
INSERT INTO pwg_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Sande mara boiboi vaghata i oira ikavara ma ivomiiri ku karawaga. ");
INSERT INTO pwg_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Ibaba inenae na ti mani ivivi ogatara da nani wakimina bubana igudupotai na iyi ita tabiratawei. ");
INSERT INTO pwg_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Inenekiibau na itepa ita kita da buba wakimina ghamanakina na namada wawaya itabiratawei. ");
INSERT INTO pwg_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Wivinesi irui karawaga bubana ku kamona ma itataghana, iyamna ku katagheyasi tomowa yaragina ikitai, kana gara poipoina. ");
INSERT INTO pwg_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ma tomowina ivonesi bo, “Ke kona yabumana. Akovi da Nasaret wawayina Yesu ituparatui na tuna koekwekwai. Rabobowai ivomiiri da ke ita makamakai. Kokitai, tupuwina weni dobunai iterei, gawarina na kwebuna. ");
INSERT INTO pwg_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Ma konae da kana kivikivina ma Pita kovonesi bo, ‘Yesu ini nao ku Gariri. Ma nani dobunai kona panani, nakanani ina sisiya kurimi iterei.’” ");
INSERT INTO pwg_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Wivinesi inotakavakavai ma ere kirokirorosi karawaga ikiibutawei ma veru ivi karei. Ma iyabumana kirakai da ke sago iyi kurina iti sisiya. ");
INSERT INTO pwg_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Sande mara boiboi vaghatai Yesu rabobowai ivomiiri na kunona Meri Magadarini kurina inekiibau, tuna wavinena gwabinai kanuma beroberosi miikovimaruwa na Yesu ikwavinisi. ");
INSERT INTO pwg_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Ma Meri inae da kana kivikivina itutusiyasiyapa na ivonesi. ");
INSERT INTO pwg_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Ivi mamataresi da Yesu na yawayawana, ma ivonesi da tuna mani matanai ikitai. Ma kana kivikivina ke iti tumaghanei. ");
INSERT INTO pwg_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Muriyai kana kivikivina ruwa Jerusalem ikiibutawei da ketiyai ibababa ma Yesu inekiibau kurisi. Ma kana kita ivire da kunona ke ita vogiini da tuna na Yesu. ");
INSERT INTO pwg_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Muriyai ivi ruwa ivovira ku Jerusalem ma turaturasi ivonesi da Yesu ikitai. Ma bade ke iti tumaghanesi. ");
INSERT INTO pwg_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Muriyai bade kana kivikivina ivi 11 ikamkam ma Yesu kurisi inekiibau. Ma iyeghisi iyamna i vitumaghana igisi ma bade iyavo kava ivivi mamataresi da rabobowai ivomiiri na ke iti tumaghanesi, nuwanuwasi na guduguduna. ");
INSERT INTO pwg_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Ma ivonesi bo, “Kokiibau da dobu ku kudubina, da varaku biibiina dam ma dam kurisi kona dimei. ");
INSERT INTO pwg_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Iyavo kava ini tumaghaneku ma ina babataito na yawasa makamakii nonowina ina panani. Ma iyavo kava ke ini tumaghaneku na kovogha ghamana ina viiya. ");
INSERT INTO pwg_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Ma iyavo kava itumaghaneku na weni matakirisi gwabisiyai ina makamakai. Avakuwai kanuma beroberosi ina kwavinisi, kunuma gamosi bogii ma bogiiyai ini sisiya, ");
INSERT INTO pwg_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","mota beroberosi ina votovoni ma gubaga ke ina panani, gegura berona inumai ma ke ina rabobo, ma bade imasi wawaya gubagubagisi ku tepasi ina terei da ini yawasisi.” ");
INSERT INTO pwg_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Bada Yesu kana kivikivina kurisi ivi sisiya ikovi na God iviitawei ighae ku kunuma da katagheyanai imakiipika. ");
INSERT INTO pwg_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Ma vaghina, kana kivikivina ikiibau da dobu nununai Yesu varana biibiina idimadimei. Ma Bada ivi vitesi da bera ma matakira ghamaghamasi kamosiyai ituputupuwa, berasi ivivi mamatara da vonavaghata ivivi sisiyei. ");
INSERT INTO pwg_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Kiiwa kiiwa Teyopilas, tam wawaya ghamam. Kamotiyai bera ipeyari itupuwa ma wawaya peyarisi ibera tovoni da ita girumi. ");
INSERT INTO pwg_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Iyavo kava God varana idimadimei, ti damsi kudubina matasiyai ikitai na ivi damani kurita. ");
INSERT INTO pwg_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Tuna kubiine weni berasi kudubina karena da ku damona anunura bubuni ma anotai da ibiibai da taku ata girumi kubiim. ");
INSERT INTO pwg_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Akovi da varana gisina kuvi yanei ma agirugirumi da iyamna vaghata kudubina kutakova bubuni. ");
INSERT INTO pwg_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Judiya kamonai, kiivavo Herodi ina mariyai taparoro badana sago kana vava Zekaraya. Tuna turaturana yavata na Abiya ina rakaraka kamonai. Ma Zekaraya kawana kana vava Elisabet. Ti na Eron tupurereghina. ");
INSERT INTO pwg_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Ma ivi ruwa God yavata ivi nuwasago ma ina vonaviyoyovana kudubina inununura bubuni. ");
INSERT INTO pwg_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Ma natusi kegha, iyamna Elisabet na gagarina ma kawana yavata imorapa kirakai. ");
INSERT INTO pwg_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Mara sago Zekaraya ina rakaraka yavata i mara ipisi da taparoro badana bigana ita berai Taparoro Numana kamonai. ");
INSERT INTO pwg_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Ma i kiki imakamakai da virekwa sago iberai da biga irereghi, ma Zekaraya ivinei da ita rui Taparoro Numana ku kamona da insens ita kapuni. ");
INSERT INTO pwg_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Insens ikapukapuni na wawaya peyarisi Taparoro Numana matarai iniponipowana. ");
INSERT INTO pwg_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Nani kamonai Bada ina aneya sago inekiibau Zekaraya kurina da suwara kana kema katagheyanai imiimiiri. ");
INSERT INTO pwg_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Maranai Zekaraya aneya ikitai na itataghana ma nuwanuwana ikaragavovori. ");
INSERT INTO pwg_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Ma aneyina ivona bo, “Zekaraya, ke kuna yabumana. Am nipowana God ivi yanei. Kawam Elisabet ini tuwa da tomowa, ma koni vavei ‘Jon.’ ");
INSERT INTO pwg_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Tuna na ami nuwabiibai ma ami nuwaviina. Ma bade ina tupuwa na wawaya peyarisi ini nuwabiibiiyei. ");
INSERT INTO pwg_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Bada ku matana tuna na wawaya ghamana. Ke meyani da wain bo okowa rewapanisi inumai. Ma gegeyinai Kanuma Vovokaravina gwabinai ina runuma. ");
INSERT INTO pwg_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Ma wawaya peyarisi Israel kamonai nuwanuwasi ina tinavirai da ina vovira i Bada God kurina. ");
INSERT INTO pwg_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Bada maghinonai ini nao, ma kanuma ina ku nevaneva ini rewapana kirakai peroveta Elaidiya nakanani. Moramorapa nuwanuwasi ina tinaviresi natunatusi kurisi. Ma wawaya kawakiikiisi ku maninina ina teresi. Bada kubiine ina vovunaghisi ma muriyai da Bada ina nekiibau.” ");
INSERT INTO pwg_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Ma Zekaraya aneyina ivi tarakiiyanei bo, “Ikikava anakovi da vonavaghata? Taku kawaku yavata kamorapa kirakai.” ");
INSERT INTO pwg_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Ma aneyina ivona bo, “Taku Gebriyel, ma mara nonowa God maghinonai amiimiiri. Tuna ivi yoneku da weni varana biibiina ata vonem. ");
INSERT INTO pwg_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Ma ke kuti tumaghaneku kubiine, karako kawam akiikiipotai da ke kuni sisiya. Kana mara vaghata ina pisi da natum ina tupuwa ma muriyai kuni sisiya.” ");
INSERT INTO pwg_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Wawaya Taparoro Numana matarai Zekaraya ikoyakoyaghi ma nuwanuwasi ivivi tetei da avi kubiine ke ita kiibau yaghiyaghina. ");
INSERT INTO pwg_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Muriyai ikiibau ma visisiya kurisi ibera kavai. Wawaya ikitai ma inotai da bera gubana sago Taparoro Numana kamonai ikitai, iyamna ke kovokovoghina da iti sisiya ma imana kava irurutawei. ");
INSERT INTO pwg_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Zekaraya ina biga Taparoro Numana kamonai ivi kovini na Jerusalem ikiibutawei ma ivovira ina ku numa. ");
INSERT INTO pwg_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Nani murinai kawana Elisabet iropeya ma nawaravi miikovi gaburai imakai da ke ita baba. ");
INSERT INTO pwg_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Ma Elisabet ivona bo, “Weni berana Bada kubiiku iberai. Karako ivi kamyuyuweku da kaku vinimaya aku wawaya kamosiyai ivi koviya.” ");
INSERT INTO pwg_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Elisabet iropeya da kana nawaravi miikovimasago na God ina aneya Gebriyel ivonatawei ku meyagai sago. Meyagina kana vava Nasaret, Gariri dobuna kamonai. ");
INSERT INTO pwg_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Ivonatawei inae wiwike gubugubu sago kurina, wiwikena kana vava Meri ma kana vopapara Josepa, ma tuna na Kiivavo David tupurereghina. ");
INSERT INTO pwg_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Aneyina ivona bo, “Kiiwa kiiwa, tam Bada ina vigheghena ghamana. Bada gwabimuwai emakamakai.” ");
INSERT INTO pwg_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Ma Meri weni sisiyina ivi yanei na nuwanuwana ikarai ma ivi nuwanotanota da avi kubiine nakanani ivi kiikiiwei. ");
INSERT INTO pwg_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Ma aneyina ivona bo, “Meri, ke kuna yabumana. God ina agabiibai gwabimuwai irakata. ");
INSERT INTO pwg_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Kuna ropeya ma kuni tuwa da natum tomowa, ma kevi vavei Yesu. ");
INSERT INTO pwg_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Ini wawayaghama ma wawaya kudubisi ina vonei da tuna na God Kiidamo Makamakiina Natuna. Rewapana Bada God gwabinai ina viiya da ini kiivavo ina kaekiki David nakanani. ");
INSERT INTO pwg_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Jeikap kana dam kamonai ini bada nonowa ma ina vikiivavona na ina makai nonowa.” ");
INSERT INTO pwg_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Ma Meri ivona bo, “Taku na ke meyani tomowa damina ata viiya. Tuna kubiine ikikava da weni berasi ina tupuwa kuriku?” ");
INSERT INTO pwg_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Ma aneyina ivonapotei bo, “Kanuma Vovokaravina ina towatepanim ma God ina rewapana ina rogum. Ma tuna kubiine pepeya vovokaravina kuni tuwei da tuna na God Natuna. ");
INSERT INTO pwg_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Ma bade am tuwa Elisabet ini tuwa. Imagura kirakai ma wawaya inotanotai da tuna na gagarina ma kegha da gisina kava ini tuwa da natuna tomowa. Wekarakava kana nawaravi na miikovimasago. ");
INSERT INTO pwg_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","God kurina bera kudubina itekateka kirakai.” ");
INSERT INTO pwg_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Ma Meri ivonapotei bo, “Taku na God ina bigabiga. Aivaghinei da ikikava kuvoneku na nakanani ina tupuwa kuriku.” Ma vaghina, aneyina Meri inekuyowei. ");
INSERT INTO pwg_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Nani murinai Meri ivovunagha ma yaghiyaghinai ivomiiri, inumataya ku kwanatu sago Judiya kamonai. ");
INSERT INTO pwg_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Inekiibau ma Zekaraya ina ku numa irui da Elisabet ivi kiikiiwei. ");
INSERT INTO pwg_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Elisabet, Meri ina vikiikiiwa ivivi yanei na pepeya manawina kamonai ikayopapara ma Kanuma Vovokaravina itowatepani ");
INSERT INTO pwg_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","da ikiirara, ivona bo, “Wivine kudubisi kamosiyai na tam gwabimuwai Bada ina vibiibiina irakata kirakai. Ma bade wawaya kikei kuni tuwei, tuna yavata na Bada ina vibiibiina kamonai. ");
INSERT INTO pwg_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Ma anota meyeku da taku na ke wavine kiimatana da aku Bada ina maduwa ita pisi da ita kitiku. ");
INSERT INTO pwg_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Kuvi kiikiiweku na wawaya kikei manawiku kamonai nuwabiibiiyai ikayopapara. ");
INSERT INTO pwg_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Bada ivi biibiinim iyamna aviyavisina ivi sisiyei kurim na kuvi tumaghanei da berasi ina tupuwa.” ");
INSERT INTO pwg_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Ma Meri ivona bo, “Nuwanuwaku Bada evovokavakavari da kana kadara ina rakata, ");
INSERT INTO pwg_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Ma kanumiku inuwabiibai da God na kaku Viviyawa, ");
INSERT INTO pwg_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Iyamna taku ina bigabiga vovokuwayiku na enotanotiku. Kimta kudubisi karako ma mara nonowa ini sisiyeku, ina vona da taku na ina vibiibiina kamonai. ");
INSERT INTO pwg_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Tuna na God Rewapana Kirakiina ma kubiiku bera ghamaghamasi eberaberai. Ma kana vava na vovokaravina. ");
INSERT INTO pwg_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Iyavo kava God eyabuyabumanei na ini kamyuyuwesi, Kimta ma kimta kurisi ina vikamyuyuwa ini debei. ");
INSERT INTO pwg_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Imana rewapaninai na bera ghamaghamasi eberaberai. Iyavo kava i nota gavugavusi kamonai ekayokayotata na ikugerisi. ");
INSERT INTO pwg_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Kiikiivavo eteretereoruwesi ma wawaya vovokuwayisi na etereterepisi. ");
INSERT INTO pwg_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Iyavo kava vitonara ikarakarisi na ikanikanisi, ma mumurisi na imasi kwebukwebusi ma evonavonatawesi. ");
INSERT INTO pwg_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Ina bigabiga Israel damsi ini vitesi, ke nuwanuwana ita wapa da iti kamyuyuwesi. ");
INSERT INTO pwg_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Vonakiiyapa bagibagina iterei Abraham ma tupurereghina kurisi, Tuna sisiyina ita kaekiki mau kurisi iberai na enununuri.” ");
INSERT INTO pwg_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Ma vaghina, Meri nawaravi aroba Elisabet yavata imakai ma muriyai ivovira ina ku dobu. ");
INSERT INTO pwg_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Elisabet ina mara ipisi da iti tuwa na ivi tuwa da natuna tomowa. ");
INSERT INTO pwg_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Ma ina rakaraka ma turaturana sisiyina ivi yanei da Elisabet yavata ivi nuwabiibii kirakai da Bada ivi kamyuyuwei da ivi tuwa. ");
INSERT INTO pwg_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Ivi tuwa murinai na mara 8 ikovi na wawaya iriyei da tomowa kikei kwimata bekana ita tuviviratawei ma kana vava ita verei. Ma iti vavei Zekaraya, ina mamai yavata iti varigheya. ");
INSERT INTO pwg_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Ma ina maduwa ivona bo, “Kegha, kana vava Jon.” ");
INSERT INTO pwg_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ma wawayisi ivonapotei bo, “Am rakaraka kamonai ke sago iyai da kana vava nakanani.” ");
INSERT INTO pwg_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Ma wawayisi tomowa kikei ina mamai kurina imasiyai irurutawei, akova ita viiya da ina kayowana ikikava natuna kana vava kubiine. ");
INSERT INTO pwg_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Ma imanai ivi matakira da girugiruma sawarisi ita kavarapiyei. Ma igiruma bo, “Kana vava Jon.” ");
INSERT INTO pwg_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Yaghiyaghinai kawana itamotatagha ma pepana ivi kuvirei da ivi sisiya ma God vigheghenina ivi karei. ");
INSERT INTO pwg_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Turaturasi inota kavakavai ma weni berasi kudubina sisiyisi ikiibau da Judiya dobuna ine yavui. ");
INSERT INTO pwg_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Wawaya ivi yanei ma nuwanuwasi ivivi tetei da ivonavona bo, “Weni wawaya kikina ina magura na avi ina berai? God imana gwabinai emakamakai.” ");
INSERT INTO pwg_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Ma Kanuma Vovokaravina, Zekaraya itowatepani da sisiya God gwabinai iviiya. Ma ivona bo, ");
INSERT INTO pwg_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Bada tavokavakavari, tuna Israel ita God Tota ina wawaya kurita inekiibau da ita nuwapoya kamonai ina votaweta. ");
INSERT INTO pwg_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Ina bigabiga David ina rakaraka kamosiyai kata Viviyawa rewapana kirakiina ina miirikiibau. ");
INSERT INTO pwg_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Ikikava mara katamaninai ina peroperoveta vovokaravisi kurisi ivi sisiya na nani berasi ina berai. ");
INSERT INTO pwg_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Ivona da kata ghavighaviya ina ghegavovorisi ma ini yawasita. Ini viteta da iyavo kava ebabareta na i rewapana takiibutawei. ");
INSERT INTO pwg_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Ita kaekiki ivonesi da ini kamyuyuweta, Ma ina vivaghina makamakiina ma vovokaravina kurita iterei na ke ini notawapei. ");
INSERT INTO pwg_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Vonakiiyapa bagibagina ita mamai Abraham kurina iterei, ");
INSERT INTO pwg_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Ivona da ini tarapaparaneta da kata ghavighaviya ke aviyavisina ina berai kurita. Tuna kubiine ke tayabumana ma kovokovoghita da tavokavakavari ma ina biga tabera bubuni, ");
INSERT INTO pwg_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Ma mara ku peyarina ina vona da tota na ina wawaya vovokaravita ma maninita. ");
INSERT INTO pwg_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Ma tam, natuku, ina kwatum da God Kiidamo Makamakiina ina peroveta. Kuni nao da Bada ina keta kuna vovunaghi. ");
INSERT INTO pwg_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Ina wawaya kuni akovisi da God i bera beroberosi ina notatawei da yawasa makamakii nonowina ina panani. ");
INSERT INTO pwg_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Ita God nuwanuwana nubana, tuna kubiine ivi kamyuyuweta. Karako mara itom, iyamna ina yasegana kunumai ioru kurita, ");
INSERT INTO pwg_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","ma iyavo kava nubakutuva kamonai imakamakai na gweyurina ina rui kurisi, ma bade iyavo kava rabobo eyabuyabumanei na ina yasegana ina veresi, Ini noweta da nuwanuba ketana takivini.” ");
INSERT INTO pwg_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Ma vaghina, Zekaraya natuna Jon imagura ma kanumina ivi rewapana. Ma warereyai imakai inene da kana mara vaghata ipisi da ina biga iti karei ma inekiibau Israel damsi kurisi. ");
INSERT INTO pwg_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Nani maranai kiivavo ghamana Sisa Ogastas sisiya iterei da iyavo kava Rome damsi i rewapana gaburinai imakamakai na kudubisi vivavatura ita berai, kii vava ita giruma da iti yavisi. ");
INSERT INTO pwg_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Weni tuna na vivavatura karena maranai Kwiriniyas ivivi kiivavo Siriya dobunai. ");
INSERT INTO pwg_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Ma wawaya kudubisi ivovira i ku dobu da kii dam kamosiyai iti vavatura. ");
INSERT INTO pwg_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Tuna kubiine Gariri dobunai tomowa sago kana vava Josepa ivomiiri da ina kwanatu Nasaret ikiibutawei. Inae ina kaekiki David ina ku dobu, ku Beteliyem kwanatuna Judiya dobunai. ");
INSERT INTO pwg_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Josepa kana vopapara Meri na roperopeyina ma tuna yavata inae da iti vavatura. ");
INSERT INTO pwg_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Ma Beteliyem kamonai Meri ina mara inekiibau, damina iviiya da iti tuwa. ");
INSERT INTO pwg_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Vaghina ma ivi tuwa, natuna iyarokona ivi tuwei da tomowa. Ma pepeyina kwarewa sinasinamisiyai igerei. Ma numataya i numa itupo kubiine, ghamoghamo kii siga kamonai ivi kenai. ");
INSERT INTO pwg_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Ma Beteliyem ririnai tomotomowa viya warereyai ivivi makiiyana, didibarai i sipu ikoyakoyagha. ");
INSERT INTO pwg_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Ma Bada ina aneya inekiibau kurisi, ma bade Bada kana kadara ioru da gweyurina nani gawarina iyasegana yavui da sipu kii koyakoyagha iyabumana kirakai. ");
INSERT INTO pwg_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Ma aneyina ivonesi bo, “Ke kona yabumana. Kurimi apisi da vara biibiina ata vonemi. Weni varana kubiine, wawaya peyarisi ini nuwabiibii kirakai. ");
INSERT INTO pwg_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Karako David ina kwanatu kamonai kami Viviyawa itupuwa. Tuna na Bada, God ina Vivinevine Wawayina. ");
INSERT INTO pwg_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Weni ini matakira kurimi da pepeyina kona panani, tuna kwarewa sinasinamisiyai igerei ma ghamoghamo kii siga kamonai ekenakena.” ");
INSERT INTO pwg_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Aneyina ivi sisiya ikovi na yaghiyaghinai aneya korotona ghamana inekiibau da God ivovokavakavari. ");
INSERT INTO pwg_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","Peyarisi ivonavona bo, “God kiidamo makamakiina tavokavakavari ma tighegheni da kana kadara ina rakata. Ma iyavo kava dobuwai God nuwanuwami eviiviiya na ina nuwanuba gwabimiyai ina makai.” ");
INSERT INTO pwg_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Aneya ikuyowesi ighae ku kunuma na muriyai sipu kii koyakoyagha ti mani kamosiyai ivona bo, “Tanae ku Beteliyem. Ma weni berana Bada ivoneta da itupuwa na takitai.” ");
INSERT INTO pwg_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Yaghiyaghinai ivomiiri inae da Meri da Josepa ipananisi ma bade pepeyina ikitai, tuna ghamoghamo kii siga kamonai ikenakena. ");
INSERT INTO pwg_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Sipu kii koyakoyagha ikitai ikovi na ikikava aneyina wawaya kikei ivi sisiyei na peyarina wawaya ivonaveresi. ");
INSERT INTO pwg_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Ma iyavo kava ivi yanesi na kudubisi inota kavakavai. ");
INSERT INTO pwg_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Ma Meri na weni berasi kudubina ku nuwanuwana iterei ma ivivi nuwanotanotei. ");
INSERT INTO pwg_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Ma sipu kii koyakoyagha ivovira ku warere ma God ivivi ghegheni ma kana kadara ivovokavakavari iyamna bera ghamaghamasi ivi yanei ma ikitai. Ikikava aneyina ivonesi na nakanani ipanani da vonavaghata. ");
INSERT INTO pwg_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Meri ivi tuwa murinai mara ivi 8 ikovi na kana mara vaghata inekiibau da wawaya kikei kwimata bekana ita tuviviratawei. Ituviviri ma ivi vavei Yesu. Nani vavana na aneyina iverei ma muriyai Meri iropeya. ");
INSERT INTO pwg_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Ikikava Moses ina vonaviyoyovana iterei na kana mara vaghata ipisi na Josepa da Meri natusi ita kavari ita nae ku Jerusalem da Bada kurina iti maghibeyei ma taparoro babada iti biibiinisi, ");
INSERT INTO pwg_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","iyamna Bada ina vonaviyoyovana kamonai igiruma da Israel damsi natunatusi tomotomowisi iyiyarokosi na vovokaravisi ma God rapenai. ");
INSERT INTO pwg_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Ma bade igiruma da gabubu ruwa bo kughukughu ruwa ita suwara da taparoro babadisi ita kapuni. Josepa da Meri nani girumisi inununuri da ivomiiri ku Jerusalem. ");
INSERT INTO pwg_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Ma Jerusalem kamonai tomowa sago imakamakai, kana vava Simiyon ma tuna na wawaya maninina ma God iyabuyabumanei. Ma ivivi koyakoyagha da Israel kana Viviyawa ita nekiibau, iyamna Kanuma Vovokaravina gwabinai irunuma ");
INSERT INTO pwg_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","ma ivi debei kurina da muriyai da ina rabobo na matanai Bada ina Vivinevine Wawayina ina kitai. ");
INSERT INTO pwg_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Mara sago God Kanumina ivi nowei da Taparoro Numana garina ku kamona irui. Ma Josepa da Meri inekiibau, vonaviyoyovana inununuri da natusi Yesu ikavarapiyei ma ti bade irui. ");
INSERT INTO pwg_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simiyon pepeyina ipewai ma God ivi ghegheni, ivonavona bo, ");
INSERT INTO pwg_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Bada, ikikava kuriku vonakiiyapa bagibagina kuterei na karako berana itupuwa. Tuna kubiine taku am bigabiga kevotaweku da ere nuwanubaku dobu ana kuyowei, ");
INSERT INTO pwg_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Iyamna karako matakuwai am Viviyawa akitai ikovi, ");
INSERT INTO pwg_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Am Viviyawa kuvovunaghi na dam ma dam kudubisi ina kitai. ");
INSERT INTO pwg_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Tuna am yasegana da ini debem kupuna damsi kurisi, Ma bade tuna na kam kadara am wawaya Israel kamosiyai.” ");
INSERT INTO pwg_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Simiyon weni nakanani wawaya kikei ivi sisiyei na ina mamai da ina maduwa ivi yanei ma ivi deyei. ");
INSERT INTO pwg_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Ma Simiyon ivi biibiinisi ma Meri kurina ivona bo, “God weni wawaya kikina ivinei da tuna tepanai wawaya viya Israel kamonai ina tereoruwesi ma viya ina terepisi. Ma bade ini matakira da wawaya viya ina vonavikoniyei ");
INSERT INTO pwg_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","na ti mani i nota gavugavusi ini debei. Ma tam ina maduwa na mara epipisi da nuwapoya nuwanuwam ina tonai.” ");
INSERT INTO pwg_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Ma nani kamonai kwapura sago inekiibau. Tuna na God ina peroveta ma kana vava Ana. Ina mamai kana vava Panuweru ma kii dam na Asera. Itavine ma madegha miikovimaruwa murinai ikwapura. ");
INSERT INTO pwg_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Ma namada imagura kirakai, kana madegha na 84. Mariyai ma didibarai Taparoro Numana ikivukivui da Bada ivovokavakavari, ivivi siya ma iniponipowana. ");
INSERT INTO pwg_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Ma kwapurina inekiibau da wawaya kikei ikitai ma God ivi kiikiiwei. Muriyai inae da iyavo kava nimonimoriyai Jerusalem kana Viviyawa ikoyakoyaghi da ita pisi ma iti yawasisi na kurisi wawaya kikei ivi sisiyei. ");
INSERT INTO pwg_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Josepa da Meri, Bada ina vonaviyoyovana inunura bubuni da bera kudubina ivi kovini ma ivovira i ku kwanatu Nasaret, Gariri dobuna kamonai. ");
INSERT INTO pwg_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Ma natusi imagura ma ivi rewapana. Ina nuwagiura irakata ma God ina agabiibai gwabinai imakamakai. ");
INSERT INTO pwg_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Madegha nununai Yesu ina maduwa da ina mamai inumanumataya ku Jerusalem Pasova kamna kubiine. ");
INSERT INTO pwg_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Ma Jiu damsi i kiki inunuri da Yesu kana madegha ivi 12 na yavata inae nani kamna kubiine. ");
INSERT INTO pwg_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Pasova murinai Josepa da Meri ivomiiri, ibaba ivovovira i ku dobu. Ma ke itakovi da natusi Yesu iverukuyowei, tuna na Jerusalem kamonai imakai. ");
INSERT INTO pwg_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Inotai da tuna turaturasi kamosiyai. Tuna kubiine ibaba ku pom ma raviyai turaturasi ma i rakaraka kamosiyai iekwa kavai. ");
INSERT INTO pwg_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Ke ita panani na ivovirame ku Jerusalem da nani dobunai itekwai. ");
INSERT INTO pwg_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Mara aroba ikovi ma Taparoro Numana garina kamonai natusi ipanani, tuna vibeyebeyena wawayisi kamosiyai imakamakai da ivivi yanesi ma ivivi tarakiikiiyanesi. ");
INSERT INTO pwg_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Ma iyavo kava ivivi yanei da ikikava Yesu ina akova irakata ma ina nuwagiura tepanai ivonavonapote na peyarisi ivivi deye kirakiiyei. ");
INSERT INTO pwg_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Ina maduwa da ina mamai ipanani na inota kavakavai. Ma Meri ivona bo, “Akuu! Natuku, avi kubiine weni nakanani kuberai kurikai? Am mamai yavata kavi nuwapoya kirakiiyem da kaekwekwim.” ");
INSERT INTO pwg_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Ma ivi tarakiiyanesi bo, “Avi kubiine koekwekwiku? Tami kotakovi da taku na aku Mamai ina numiiyai ata makamakai.” ");
INSERT INTO pwg_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Ma ti na ke itakovi da aviyavisina ivivi sisiyei. ");
INSERT INTO pwg_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Nani murinai ina maduwa da ina mamai yavata ivovira ku Nasaret. Ma mara nonowa ina yawasa kamonai ivovotekatekesi. Ma ina maduwa na weni berasi kudubina ku nuwanuwana iterei da ivivi nuwanotanotei. ");
INSERT INTO pwg_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Ma Yesu imagura, tupuwina ivi rewapana ma ina nota ikiivimaguri da ina nuwagiura irakata. Ma God ma wawaya ku matasi tuna na wawaya biibiina da peyarisi ivi ghegheni. ");
INSERT INTO pwg_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Rome kamonai Taiberiyas Sisa ivivi kiivavo ma ina vikiivavona kamonai na Pontiyas Pailat ivinei da Judiya dobuna iti badei. Ma Gariri dobuna kubiine na Herodi ivinei. Ma Ituriya ma Trakonitis dobusi kubiine na Herodi varesina Piripo ivinei. Ma Abilin dobuna kubiine na Laiseniyas ivinei. ");
INSERT INTO pwg_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Ma bade nani maranai taparoro babada ghamaghamasi Jerusalem kamonai na Anas ma Kayapas. Taiberiyas Sisa ivivi kiivavo da madegha 15 ikovi na Zekaraya natuna Jon warereyai imakamakai ma kana sisiya God gwabinai iviiya. ");
INSERT INTO pwg_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Ivomiiri da dobu kudubina Jodan okowina barabaranai ine yavui, idimadima da wawaya i bera beroberosi itinimayei, ita miirikupukuputei ma ita babataito da God i berabero ita notatawei. ");
INSERT INTO pwg_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Peroveta Aisaya weni nakanani igiruma, ivona bo, “Wawaya sago warereyai ekwatukwatu bo, ‘Kovovunagha Bada kubiine, Ina keta maninina koberai. ");
INSERT INTO pwg_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Anagha kodogomumui ma koya kotaravipikapikai. Keta riwariwana kovovimanimanini Ma keta tupitupina kotaramumui. ");
INSERT INTO pwg_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Ma wawaya kudubisi God ina Viviyawa ina kitai.’” ");
INSERT INTO pwg_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Koroto ghamaghamasi mara nonowa ikiikiibau Jon kurina da ita babataito. Ma iyeghisi bo, “Tami mota natunatusi! Iyi ivonemi da God ina nuwapughu kota veruvuvurei? ");
INSERT INTO pwg_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Ami yawasa kamonai amena ita tupuwa. Kovonavona da ami bera beroberosi koinimayei ma kona miirikupukuputei. Kota tupuwavira, koti debemi da ke koti bero. Ma ke kona vona bo, ‘Tota na Abraham tupurereghina, tuna kubiine God namada ivona da tota na ina wawaya maninita.’ Vonavaghata avonavonemi, God kovokovoghina da weni wakimisi ina berisi da ti na Abraham natunatuna. ");
INSERT INTO pwg_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Namada wawaya ere karuwakoyina kii kunukununai ikoyakoyagha. Meni kiina ke ita amame bubuna na ina taratawei ma ku keyama karakaratina ina tawei da ina karai.” ");
INSERT INTO pwg_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Ma wawaya viya koroto kamonai ivi tarakiiyanei bo, “Kevonekai, aviyavisina kana berai?” ");
INSERT INTO pwg_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Ma Jon ivonapotesi bo, “Mikeda gara ruwa gwabimuwai ma kwinam ivi kegha na kam gara sago keverei. Ma mikeda vavai gwabimuwai na bade nakanani keberai da wawaya kuni vitesi.” ");
INSERT INTO pwg_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Ma bade teks yuyuna damsi ipisi da ita babataito ma Jon kurina ivi tarakiiyana bo, “Bada, tokai na aviyavisina kana berai?” ");
INSERT INTO pwg_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ma ivonesi bo, “Teks ruvana vaghata koyuna. Ke ku tepana kona yuna.” ");
INSERT INTO pwg_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Muriyai seri wawayisi viya ivi tarakiiyanei bo, “Ma tokai, aviyavisina kana berai?” Ma Jon ivonapotesi bo, “Wawaya ke kona darusi da i mane ina veremi ma bade wawaya ke koni wavu wapawapisi. Ami miiya ikikava koviiviiya na tuna kava kovi nuwabiibiiyei.” ");
INSERT INTO pwg_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Wawaya peyarisi ivivi neneghana ma nuwanuwasi ivivi tetei da Jon na God ina Vivinevine Wawayina bo kegha. ");
INSERT INTO pwg_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Ma Jon ivonapotesi bo, “Taku okowai ababataitomi ma aku rewapana igisi. Ma wawaya sago epipisi, tuna ina rewapana irakata kirakai ma taku ke tomowa kiimataniku da kana kaeterepapara uravina ata vorupami. Ma tuna na Kanuma Vovokaravinai ma keyama karakaratinai ina babataitomi. ");
INSERT INTO pwg_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Wawayina nakanani ma vao badana, namada ivovunagha da whiti ita gudagudai ma ita tawetawei ku yanunu matana da muguna ita karukaruwei. Ma whiti vavina ina yuna ma ina numiiyai ina terei ma whiti muguna ina kapuni, ku keyama karata makamakii nonowina ina tawei da ina karai.” ");
INSERT INTO pwg_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Ma vaghina, Jon weni nakanani idima, sisiya bogii ma bogiiyai tepanai God varana biibiina ivivi sisiyei kurisi ma bade ivivi nowi kirakai da iti yana bubuna. ");
INSERT INTO pwg_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Ma mara sago inae Kiivavo Herodi kurina da iyeghai, iyamna Herodi ina bera beroberosi ipeyari kirakai ma bade varesina Piripo kawana ivi tuneboi. ");
INSERT INTO pwg_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Tuna kubiine Herodi ivomiiri da Jon ku gabura iterei. Nakanani iberai na ina berabero ivi kiitatanei. ");
INSERT INTO pwg_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Wawaya peyarisi ibababataito na nani kamonai Yesu yavata ibabataito. Ma iniponipowana na kunuma itamotate ma ");
INSERT INTO pwg_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Kanuma Vovokaravina ioru kurina, kitana nakanani ma gabubu. Ma God gamona kunumai ivona bo, “Tam na natuku. Tam nuwanuwaku ma ainuwabiibiiyem.” ");
INSERT INTO pwg_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Yesu kana madegha 30 ma ina biga ivi karei. Ma wawaya inotanotai da ina mamai na Josepa. Ma Josepa ina mamai na Heli. ");
INSERT INTO pwg_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Ma Heli ina mamai na Matat. Ma Matat ina mamai na Livai. Ma Livai ina mamai na Melki. Ma Melki ina mamai na Janai. Ma Janai ina mamai na Josepa. ");
INSERT INTO pwg_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Ma Josepa ina mamai na Matatayas. Ma Matatayas ina mamai na Eimos. Ma Eimos ina mamai na Naum. Ma Naum ina mamai na Esili. Ma Esili ina mamai na Nagai. ");
INSERT INTO pwg_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Ma Nagai ina mamai na Mat. Ma Mat ina mamai na Matatayas. Ma Matatayas ina mamai na Semein. Ma Semein ina mamai na Josek. Ma Josek ina mamai na Joda. ");
INSERT INTO pwg_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Ma Joda ina mamai na Jowanan. Ma Jowanan ina mamai na Resa. Ma Resa ina mamai na Zerubabel. Ma Zerubabel ina mamai na Seletiyel. Ma Seletiyel ina mamai na Neri. ");
INSERT INTO pwg_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Ma Neri ina mamai na Melki. Ma Melki ina mamai na Adi. Ma Adi ina mamai na Kosam. Ma Kosam ina mamai na Elumadam. Ma Elumadam ina mamai na Eya. ");
INSERT INTO pwg_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Ma Eya ina mamai na Josuwa. Ma Josuwa ina mamai na Eliyesa. Ma Eliyesa ina mamai na Jorim. Ma Jorim ina mamai na Matat. Ma Matat ina mamai na Livai. ");
INSERT INTO pwg_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Ma Livai ina mamai na Simiyon. Ma Simiyon ina mamai na Juda. Ma Juda ina mamai na Josepa. Ma Josepa ina mamai na Jonam. Ma Jonam ina mamai na Eliyakim. ");
INSERT INTO pwg_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Ma Eliyakim ina mamai na Meleya. Ma Meleya ina mamai na Mena. Ma Mena ina mamai na Matata. Ma Matata ina mamai na Neitan. Ma Neitan ina mamai na David. ");
INSERT INTO pwg_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Ma David ina mamai na Jesi. Ma Jesi ina mamai na Obedi. Ma Obedi ina mamai na Bowas. Ma Bowas ina mamai na Samon. Ma Samon ina mamai na Nason. ");
INSERT INTO pwg_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Ma Nason ina mamai na Aminadab. Ma Aminadab ina mamai na Ram. Ma Ram ina mamai na Hesron. Ma Hesron ina mamai na Peres. Ma Peres ina mamai na Juda. ");
INSERT INTO pwg_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Ma Juda ina mamai na Jeikap. Ma Jeikap ina mamai na Aisiki. Ma Aisiki ina mamai na Abraham. Ma Abraham ina mamai na Tera. Ma Tera ina mamai na Naho. ");
INSERT INTO pwg_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Ma Naho ina mamai na Serugi. Ma Serugi ina mamai na Reu. Ma Reu ina mamai na Pelegi. Ma Pelegi ina mamai na Eba. Ma Eba ina mamai na Sela. ");
INSERT INTO pwg_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Ma Sela ina mamai na Keinan. Ma Keinan ina mamai na Apakisadi. Ma Apakisadi ina mamai na Sem. Ma Sem ina mamai na Nowa. Ma Nowa ina mamai na Lamek. ");
INSERT INTO pwg_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Ma Lamek ina mamai na Metusera. Ma Metusera ina mamai na Inoka. Ma Inoka ina mamai na Jared. Ma Jared ina mamai na Mahalalel. Ma Mahalalel ina mamai na Keinan. ");
INSERT INTO pwg_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Ma Keinan ina mamai na Inos. Ma Inos ina mamai na Set. Ma Set ina mamai na Adam. Ma Adam ina Mamai na God. ");
INSERT INTO pwg_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Kanuma Vovokaravina, Yesu itowatepani ma ivi nowei da Jodan okowina ivoterei inae ku dobu makiiwapana ma ivivi siya, ");
INSERT INTO pwg_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","imakamakai da mara 40 ikovi. Ma ke ita kamkam kubiine na damonai vitonara ikarai. Ma nani kamonai Devil ipisi da ita ruyaghai. ");
INSERT INTO pwg_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Ivona bo, “Tam God Natuna, bo? Kevona da weni wakimina ini parawa.” ");
INSERT INTO pwg_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Ma Yesu ivonapotei bo, “Giruma katamana evonavona bo, ‘Wawaya ke parawa kava tepanai ina makai.’” ");
INSERT INTO pwg_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Ma Devil, Yesu ivi nowei da ku gawara sago ighe kirakai nake da dobu kudubina ivi beyei, ");
INSERT INTO pwg_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","ma ivonei bo, “Kudubina rapekuwai. God ku imaku iterei da aku kayowanai wawaya ana verei. ");
INSERT INTO pwg_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Kuna vokavakavariku na rewapana ma kadara kudubina dobuwai ana verem da kuni badei.” ");
INSERT INTO pwg_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Ma Yesu ivonapotei bo, “Giruma katamana evonavona bo, ‘Am Bada God ina kina kava kevokavakavari ma kevotekatekei.’” ");
INSERT INTO pwg_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Ma Devil, Yesu ivi nowei da inae ku Jerusalem ma ku Taparoro Numana vovona ighae. Ma ivonei bo, “Tam God Natuna, bo? Ketawem, ");
INSERT INTO pwg_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","iyamna giruma katamana evonavona bo, ‘God ina aneya ina vonesi da ina koyagha bubunim ");
INSERT INTO pwg_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","ma ina vokemim da ke wakima kuna takurei.’” ");
INSERT INTO pwg_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Ma Yesu ivonapotei bo, “Ma bade evonavona bo, ‘Bada God ke kona rubui.’” ");
INSERT INTO pwg_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Ma Devil, Yesu iruyaghai ikovi na ikuyowei inae. Inotai da mara sago taraboga biibiina ita panani da ita vovirame. ");
INSERT INTO pwg_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Yesu ivovirame ku Gariri ma Kanuma Vovokaravina gwabinai na ivi rewapana kirakai. Ma varana ikiibau da dobu ikiimumui. ");
INSERT INTO pwg_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Ma i kiki numasi kamosiyai ivivi beyebeyena ma wawaya peyarisi ivivi ghegheni. ");
INSERT INTO pwg_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Mara sago Yesu inae ku Nasaret, ina ku dobu. Ma ikikava mara nonowa iberaberai na viyakam maranai irui ku kiki numana. Ma ivomiiri da iti yava ma ");
INSERT INTO pwg_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","wawaya sago ipisi da Aisaya ina giruma iverei. Ivotataghi ma kamonai giruma sago ipanani da ivi yavi, ivona bo, ");
INSERT INTO pwg_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Bada kanumina gwabikuwai, Iyamna ivineku da wawaya moyamoyakisi kurisi varana biibiina ana dimei. Ivonataweku da iyavo kava gabura kamonai na ana rumamara kurisi da gabura ina kiibutawei. Ma matapotapotasi kurisi ana rumamara da ina kita. Ma bade iyavo kava wawaya ikayotiranesi da i nota ipeku na ana votawesi. ");
INSERT INTO pwg_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Aiyonayona da karako marana vaghata ipisi da Bada ina wawaya ini yawasisi.” ");
INSERT INTO pwg_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Yesu ivi yava ikovi na girumina ivonokui ma giruma kana koyakoyagha wawayina iverei. Muriyai ivi kiimakiiyei. Ma wawaya kudubisi kiki numana kamonai ikitakita bogai ");
INSERT INTO pwg_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","ma Yesu sisiya ivi karei. Ivonesi bo, “Karako weni girumina kovi yanei na vonavaghata, marana inekiibau.” ");
INSERT INTO pwg_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Muriyai sisiya ghamaghamasi itere bubuni da wawaya peyarisi ivi deyei ma ikawabiibiiyei. Ma kegha da, muriyai wawayisi ivona bo, “Te! Ikikava da nakanani isisiya? Wena na Josepa natuna.” ");
INSERT INTO pwg_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Ma Yesu ivonesi bo, “Anotanotai da weni miibiina kota voneku, kota vona bo, ‘Yaboyabo kevi yawa meyem. Bera ghamaghamasi Kapeniyam kamonai kuberai na sisiyina kavi yanei. Mede tam mani am kwanatu kamonai berasi keberai da kana kitai.’ ");
INSERT INTO pwg_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Vonavaghata avonavonemi, God ina peroveta na tuna mani ina dobuwai wawaya ke ina vokaravei. ");
INSERT INTO pwg_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Kota notai da peroveta Elaidiya ina mariyai kwapukwapura moyamoyakisi ipeyari kirakai Israel kamonai ma ke sago iti vitesi. Nani maranai gomara ghamana itupuwa iyamna madegha aroba ma nawaravi miikovimasago na garewa kegha. ");
INSERT INTO pwg_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Ma God, Elaidiya ivonatawei da Israel ikiibutawei inae ku Zarepata kwanatuna Saidon kamonai da kwapura sago nani dobunai ivi vitei. ");
INSERT INTO pwg_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Ma bade peroveta Elaisiya ina mariyai wawaya ipeyari kirakai Israel kamonai gubaga sago kana vava giipo gwabisiyai ma ke sago kamosiyai iti yawasi. Tomowa sago kava ivi yawasi ma tuna na Siriya tomowa Neiman.” ");
INSERT INTO pwg_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Yesu weni nakanani ivivi sisiya ma iyavo kava kiki numana kamonai ivi yanei na nuwanuwasi ipughu kirakai. ");
INSERT INTO pwg_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Ivomiiri ma Yesu ivotabitabiri da kwanatu ikiibutawei. Ma inae ku koya kiiyagirina tawanoruwena kubiine. ");
INSERT INTO pwg_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Ma Yesu koroto kamosiyai ionagha da inae. ");
INSERT INTO pwg_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Yesu Nasaret ikiibutawei ioru ku Kapeniyam, tuna kwanatu sago Gariri kamonai. Ma viyakam maranai ivi karei da wawaya kurisi ivivi beyebeyena. ");
INSERT INTO pwg_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Sisiya ghamaghamasi iterei da wawaya ivi deyei, iyamna ina vibeyebeyena na ere rewapanina. ");
INSERT INTO pwg_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Ma kiki numana kamonai tomowa sago imakamakai, ma kanuma berona gwabinai irunuma. Ma ikiirara, ");
INSERT INTO pwg_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","ivona bo, “Aaa! Tam Yesu, Nasaret wawaya, avi kuna berai kurikai? Kupisi da kuna gwaramutukai, bo? Avogiinim da tam na God ina Wawaya Vovokaravim.” ");
INSERT INTO pwg_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Ma Yesu iyeghai, ivona bo, “Kawam epota! Tomowina kekiibutawei!” Ma koroto maghinosiyai kanuma berona tomowina itawei ku tano ma ikiibutawei inae. Ma tomowina na ke sago gubaga ita panani. ");
INSERT INTO pwg_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Wawaya peyarisi ivi deyei ma ti mani kamosiyai ivona bo, “Te! Ikikava da weni nakanani ibeyebeyena? Ma bade rewapana gwabinai da sisiya bagibagisi etereterei na kanuma beroberosi evovotekatekei ma ekiikiibau.” ");
INSERT INTO pwg_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Ma Yesu varana ikiibau da dobu ine yavui. ");
INSERT INTO pwg_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Yesu kiki numana ikuyowei ma inae Saimon ina ku numa. Ma Saimon rawana wavinena igubaga, ininina imuyamuya kirakai ma wawaya Yesu ivona tovoni da iti vitei. ");
INSERT INTO pwg_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Imiiririya wavinena kurina ma muyamuyana iyeghai da ikiibukuyowei ma iyawasa. Ma yaghiyaghinai ivomiiri da ikoyagha bubunisi. ");
INSERT INTO pwg_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Ravi ipika na wawaya peyarisi turaturasi gubagubagisi, kii gubaga bogii ma bogiiyai na ikavarapiyesi Yesu kurina. Ma sago sago duma imana ku tepasi iterei da ivi yawasisi. ");
INSERT INTO pwg_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Ma bade, kanuma beroberosi ikwavikwavinisi da wawaya peyarisi ikiikiibutawesi. Ma kanumisi ere kiikiirarisi ivonavona bo, “Tam God Natuna!” Tuna kubiine iyeghisi ma ivonatanisi da ke iti sisiya, iyamna ti na iakovi da Yesu na God ina Vivinevine Wawayina. ");
INSERT INTO pwg_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Mara tomtomwai na Yesu ikiibau ku dobu makiiwapana. Ma wawaya peyarisi Yesu iekwekwai da ipanani ma i kayowana da gwabisiyai iti tinatani da ke ita kuyowesi. ");
INSERT INTO pwg_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Ma ivonesi bo, “Kegha, ana nae da kwanatu viya kamosiyai God ina vikiivavona varana biibiina ana dimei, iyamna tuna bigana kubiine God ivonataweku.” ");
INSERT INTO pwg_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ma vaghina, Judiya dobuna ine yavui da kiki numasi nununai idimadima. ");
INSERT INTO pwg_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Mara sago Yesu, Genesaret tokana kikirinai imiimiiri ma koroto ghamana imiirigwagwari. Ma God vonana idimadimei kurisi da ivivi yana. ");
INSERT INTO pwg_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Ma Yesu ikitataweyana da waka ruwa kikirai ikitai, nani wakasi na wito damsi ikuyowei da i wito ititinakowa. ");
INSERT INTO pwg_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Ma inae da ku waka sago igeru, tuna wakana na Saimon rapenai. Ma Saimon kurina ivi nowi da kikira ita kuyowei gisina ita ghae. Muriyai Yesu wakana tepanai imakamakai da wawaya kikirai kurisi ivivi beyebeyena. ");
INSERT INTO pwg_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Ivi beyebeyena ikovi na ivona bo, “Saimon, takiibau ku bogapu ma wito kona tawei.” ");
INSERT INTO pwg_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Ma Saimon ivonapotei bo, “Bada, kawito mareba ma ke sago kata konai. Ma tam kuvona kubiine na ana tawe tovoni.” ");
INSERT INTO pwg_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Vaghina ma, itawei na iyana ikona kirakiiyei da wito ita tini na iti tamoyarayaragheyana. ");
INSERT INTO pwg_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Ma turaturasi waka kana viruwa tepanai ikwatusi da ita pisi ma iti vitesi. Ipisi na iyana iyuna da i waka ruwa ivi tupotupo da gisina kava ita monu. ");
INSERT INTO pwg_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Ma Saimon Pita weni berana ghamana ikitai na Yesu maghinonai ivi tuwaporeruruwana. Ma ivona bo, “Bada, kevotereku, iyamna taku na berabero wawayiku!” ");
INSERT INTO pwg_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Weni nakanani ivi sisiya iyamna Saimon ina bigabiga yavata ivi deyei da iyana ikona kirakiiyei. ");
INSERT INTO pwg_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Ma bade Zebedi natunatuna Jemes ma Jon na ti bade ivi deyei, ti na mara nonowa Saimon yavata iwiwito patapata. Ma Yesu, Saimon kurina ivona bo, “Ke kuna yabumana. Karako kuni karei da wawaya kuna konisi kubiiku.” ");
INSERT INTO pwg_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Damsi ivi yanei na i waka itinepepa ma i bera kudubina ikuyowei da Yesu ikivini. ");
INSERT INTO pwg_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Yesu na kwanatu sago kamonai ma tomowa sago gubagubagina ipisi, kana gubaga na giipo ma tupuwina kudubina ikanikani da namada ivivi beroi. Tomowina Yesu ikitai na maghinonai ivi tuwaporeruruwana ma maghighina ioru ku tano. Ma ivi nowi bo, “Bada, kekayokayowei da kuni yawasiku bo kegha? Akovi da tam kovokovoghim.” ");
INSERT INTO pwg_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Ma Yesu ivororona da tomowina ivotovoni ma ivonei bo, “Akayokayowei. Keyawasa.” Ma yaghiyaghinai gubagina ikuyowei da iyawasa. ");
INSERT INTO pwg_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Ma Yesu tomowina ivonatani bo, “Ke kuni mamatara da iyi ivi yawasim. Ma maninina kenae taparoro babadisi kurisi ma aviyavisina Moses ina vonaviyoyovana kamonai igirumi na kenunuri. Kevi debe meyem kurisi da ina kitim da kuyawasa ma bade am suwara keveresi da ina kapuni kubiim. Weni nakanani keberai da wawaya inakovi da kuyawasa.” ");
INSERT INTO pwg_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Ma kegha, Yesu varana irakata ikiibau da dobu inunui. Tuna kubiine mara nonowa koroto ghamaghamasi iriyeriyesi da Yesu iti yanei ma bade gubagubagisi ipipisi da iti yawasisi. ");
INSERT INTO pwg_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Ma mara ipeyari Yesu taraboga ipanapanani da ikiikiibau ku gawara makiiwapasi da iniponipowana. ");
INSERT INTO pwg_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Mara sago Yesu ivivi beyebeyena ma koroto kamonai na Perisi damsi ma vonaviyoyovana vibeyebeyena wawayisi ivivi makiiyana. Ti na i kwanatu bogii ma bogiiyai Gariri, Judiya ma Jerusalem kamonai ipisi. Ma tuna maranai na Bada God ina rewapana Yesu gwabinai da gubagubagisi iti yawasisi. ");
INSERT INTO pwg_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Nani kamonai tomotomowa viya ipisi, kwinasi digadigana ritowai ikavarapiyei. Ma ibera tovoni da ita rui ku numa kamona da digadigana Yesu ku maghinona ita terei. ");
INSERT INTO pwg_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Koroto irakata kirakai da keta iekwa kavai da ita rui na ighae ku numa tepana da taraboga iberai. Ma digadigana ere ritona ivi yoyowi da koroto ku kamona Yesu maghinonai ioru. ");
INSERT INTO pwg_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Yesu ikitisi da i vitumaghana irakata na digadigana kurina ivona bo, “Kwinaku, am bera beroberosi anotatawei.” ");
INSERT INTO pwg_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Ma Perisi damsi ma vonaviyoyovana vibeyebeyena wawayisi ivi karei da ivi nuwanotanota bo, “Weni tomowina ina rewapana kegha da nakanani iti sisiya. Tuna na God iavaberowei iyamna God ina kina kava berabero ina notatawei.” ");
INSERT INTO pwg_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Ma Yesu i nota iakovi ma ivonesi bo, “Avi kubiine weni nakanani koinuwanotanota? ");
INSERT INTO pwg_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Meni tuna itekateka da ana vonei, ‘Am bera beroberosi anotatawei,’ bo ‘Kevomiiri, kuna baba.’ ");
INSERT INTO pwg_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Ani beyemi da taku Wawaya Natusi aku rewapana dobuwai kovokovoghina da bade bera beroberosi ana notatawei.” Ma digadigana ivonei bo, “Avonavonem. Kevomiiri, am kepana kekavari ma kenae am ku numa.” ");
INSERT INTO pwg_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Yaghiyaghinai koroto matasiyai digadigana ivomiiri ma ina kepana ikavari. Ma ivi karei da God ivivi ghegheni ma ikiibau inae da ina ku numa. ");
INSERT INTO pwg_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Ma bade wawaya peyarisi ivi deye kirakiiyei ma God ivi ghegheni. Ma ivona bo, “Karako bera varatete takitai.” ");
INSERT INTO pwg_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Nani berasi murinai Yesu ikiibau da teks yuyuna wawayina sago kana vava Livai ipanani, tuna na ina bagibagi gawarinai imakamakai. Ma Yesu ivona bo, “Kekiviniku.” ");
INSERT INTO pwg_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Ma yaghiyaghinai Livai ina bera kudubina ivoterei, ivomiiri da Yesu ikivini. ");
INSERT INTO pwg_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Muriyai Livai ina numiiyai kam ghamana Yesu kubiine iberai. Koroto iriyesi da ikamkam ma kamosiyai na teks yuyuna wawayisi ipeyari. ");
INSERT INTO pwg_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Ma Perisi damsi ma vonaviyoyovana vibeyebeyena wawayisi Yesu kana kivikivina iyeghisi, ivona bo, “Avi kubiine teks yuyuna wawayisi ma berabero wawayisi yavata kokamkam ma koumuma?” ");
INSERT INTO pwg_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Ma Yesu ivonapotesi bo, “Wawaya yawayawasisi yaboyabo ke ita kayokayowei, kegha da gubagubagisi kava. ");
INSERT INTO pwg_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Ke wawaya maninisi kubiisi ata pisi. Taku apisi da berabero wawayisi ata kwatusi ma ata vonesi da i berabero itinimayei ma ita miirikupukuputei.” ");
INSERT INTO pwg_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Wawaya viya ipisi Yesu kurina ma ivi tarakiiyanei bo, “Mara ipeyari Jon kana kivikivina isiya ma eniponipowana. Ma Perisi damsi kii kivikivina bade nakanani eberaberai. Ma kam kivikivina na avi kubiine ke ita vivisiya da mara nonowa ekamkam ma eumuma?” ");
INSERT INTO pwg_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Ma Yesu miibiiyai ivonapotesi bo, “Tomowa ina tavine na turaturana ina kam ma ini nuwabiibai. Ke kona vonesi da ini siya iyamna tavine tomowina patana da gwabisiyai emakamakai. ");
INSERT INTO pwg_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Ma marana epipisi da tomowina ina kuyowesi, ma tuna maranai turaturana ini siya.” ");
INSERT INTO pwg_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Ma miiba sago iterei, ivona bo, “Wawaya ke gara vuna ina sikai ma sinamina ina viiya da gara katamanina tarabogina ina tupapotai. Nakanani ita berai na gara vuna iti beroi ma bade gara katamanina kitana iti beroi.” ");
INSERT INTO pwg_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","“Ma sago na ke vaghina da wain vuna ku beka katamanina ina tepoi. Nakanani ita berai na wain ita puropuroi da beka katamanina iti kwata da iti beroi ma wain ita sororo. ");
INSERT INTO pwg_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Kegha, wain vuna ku beka vuna pikapikana kona tepoi da beka ina dodo ma wain ina makai bubuna.” ");
INSERT INTO pwg_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ma damonai Yesu ivona bo, “Iyavo kava wain katamanina iumumai na wain vuna ina barei ma ina vona bo, ‘Katamanina imagi kirakai.’” ");
INSERT INTO pwg_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Viyakam marana sago Yesu ibaba inenae ma keta whiti vaona ikiiyaraghi. Ma kana kivikivina ivi karei da whiti vavina ivivi tinamuyana, iyogogo da bekasi ivivi votaweyana ma vavisi ikamkam. ");
INSERT INTO pwg_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Ma Perisi damsi viya ivonesi bo, “Vonaviyoyovana kovi kiigiiyei. Avi kubiine viyakam marana kamonai ma kovovobagibagi?” ");
INSERT INTO pwg_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Ma Yesu ivonapotesi bo, “Kiivavo David ina varagutugutu kovi yavi na kotakovi da rorova maranai turaturana yavata vitonara ikarisi na aviyavisina iberai. ");
INSERT INTO pwg_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Tuna irui God ina Yobe Vovokaravina garina ku kamona ma suwara parawisi iyuna. Nani parawisi taparoro babadisi kava ita kani. Ma David iyuna ma ikani ma bade viya turaturana iveresi da ti yavata ikam.” ");
INSERT INTO pwg_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Muriyai ivonesi bo, “Taku Wawaya Natusi na viyakam marana kana bada.” ");
INSERT INTO pwg_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Viyakam marana sago Yesu irui ku kiki numana da ivivi beyebeyena. Ma kamonai tomowa sago imakamakai na imana katagheyana gibegibesina. ");
INSERT INTO pwg_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Ma Perisi damsi ma vonaviyoyovana vibeyebeyena wawayisi keta iekwekwai da Yesu iti wavui, tuna kubiine ivivi matatetei da ita kitai da viyakam marana kamonai Yesu nani gibegibesina iti yawai bo kegha. ");
INSERT INTO pwg_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Ma Yesu i nota iakovi ma gibegibesina ivonei bo, “Kevomiiri da koroto maghinosiyai kuna miiri.” Vaghina ma, ivomiiri. ");
INSERT INTO pwg_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Ma Yesu ivonesi bo, “Kovoneku, avi taberai viyakam maranai da vonaviyoyovana tanunura bubuni? Bera biibiisi bo bera beroberosi? Wawaya tiyawasisi bo takiiviberosi?” ");
INSERT INTO pwg_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Ma Yesu ikitavirevire da koroto ikitakitisi ma muriyai gibegibesina ivonei bo, “Kevororona.” Ivororona da imana iyawasa ikovi. ");
INSERT INTO pwg_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Ma Perisi damsi ma vonaviyoyovana vibeyebeyena wawayisi nuwanuwasi ipughu kirakai, ma ivi ogatara da avi ita berai Yesu kurina. ");
INSERT INTO pwg_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Mara sago Yesu ivomiiri da nipowana kubiine ighae ku koya. Ma God kurina inipowana mareba. ");
INSERT INTO pwg_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Mara itom na kana kivikivina ikwaturiyariyesi. Ipisi ma kamosiyai ivi 12 ivinesi ma ivonesi da ti na ina aposol. ");
INSERT INTO pwg_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Wawayisi kii vava na weni. Saimon da Yesu ivi vavei Pita, ma tina kikei Anduru, Jemes ma Jon, Piripo, Batoromiya, ");
INSERT INTO pwg_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matiu, Tomas, Arupiyasi natuna Jemes, Saimon, tuna na Zelote wawayina, ");
INSERT INTO pwg_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Jemes natuna Judas, ma bade Judas Iskariyot, tuna karakava Yesu ini wawanei. ");
INSERT INTO pwg_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Yesu ina aposol yavata koyiyai ioru ku dobu ruvipikapikana ma imiiri. Ma kana kivikivina peyarisi ma koroto ghamanakina iriyei kurina. Kamosiyai na Judiya ma Jerusalem damsi ma bade kikira damsi, i kwanatu na Taya ma Saidon. ");
INSERT INTO pwg_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Ipisi da Yesu iti yanei ma kii gubaga iti yawasi. Ma iyavo kava kanuma beroberosi gwabisiyai irunuma da i nuwapoya irakata na Yesu ivi yawasisi. ");
INSERT INTO pwg_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Wawaya peyarisi i kayowana da Yesu ita votovoni, iyamna rewapana gwabinai ikiikiibau da kudubisi ivivi yawasisi. ");
INSERT INTO pwg_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Yesu kana kivikivina ikitakitisi ma ivona bo, “Tami moyamoyakimi bo kanuma ina ku nevaneva mitamitami na God ini biibiinimi da koni nuwabiibai, iyamna tami na God ina vikiivavona na rapemiyai. ");
INSERT INTO pwg_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Tami iyavo kava wekarakava vitonara ekarakarimi na God ini biibiinimi da koni nuwabiibai, iyamna kona kam dodo. Tami iyavo kava wekarakava kotutou na God ini biibiinimi da koni nuwabiibai, iyamna koni nama.” ");
INSERT INTO pwg_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","“Tami iyavo kava Wawaya Natusi koitumaghanei ma ami vitumaghana kubiine wawaya ebabaremi, itupaketowanemi, iavaberowemi, ma ina vona da tami na berabero wawayimi na God ini biibiinimi da koni nuwabiibai. ");
INSERT INTO pwg_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Nani berasi ina berai kurimi na kovi nuwabiibiiyei da nuwabiibiiyai koni kapokapoka iyamna kunumai God ini miiya bubunimi. Konotai da iyavo kava ini tupaketowanemi na i kaekiki mau berana sago iberai God ina peroperoveta kurisi.” ");
INSERT INTO pwg_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Ma tami mura wawayimi na koti nuwapoya kirakai, iyamna ami miiya kudubina namada koviiya ikovi. ");
INSERT INTO pwg_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Tami iyavo kava wekarakava kokamkamdodo na koti nuwapoya kirakai, iyamna vitonara ina karimi. Tami iyavo kava wekarakava koinama na koti nuwapoya kirakai, iyamna kona siyapa ma kona tou.” ");
INSERT INTO pwg_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","“Tami iyavo kava wawaya peyarisi ekawakawabiibiiyemi na koti nuwapoya kirakai, iyamna wawayisi i kaekiki mau nakanani iberai peroperoveta viviberosi kurisi.” ");
INSERT INTO pwg_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Tami iyavo kava koiyana na ana vonemi. Kami ghavighaviya nuwanuwasi koviiya. Iyavo kava ini agaberowemi na biibiina koberai kurisi. ");
INSERT INTO pwg_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Ma iyavo kava inimagimi na kovi biibiinisi. Ma bade iyavo kava ina kiiviberomi na konipowana kubiisi. ");
INSERT INTO pwg_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Wawaya nevanevam ina tapini na bade ketavira, kevi vaghinei da nevana ina tapini. Ma wawaya kam tarasovo ina yapini na kevoterei da bade gara viya ina yuna. ");
INSERT INTO pwg_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Wawaya ini nowi kurim na aviyavisina ekayokayowei na keverei. Ma bade wawaya am sawara sago ina kavari na ke kuna darui da ini vovirei. ");
INSERT INTO pwg_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Ikikava kekayokayowei da wawaya ina berai kurim na nakanani keberai kurisi.” ");
INSERT INTO pwg_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Wawaya ina nuwaviina ini debei kurimi na itekateka da ami nuwaviina koni debei kurisi. Ma ke kona notai da ami nuwaviina kubiine God ini biibiinimi. Berabero wawayisi nakanani turaturasi yavata inuwaviina. ");
INSERT INTO pwg_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Wawaya bera biibiina ina berai kurimi na itekateka da bera biibiina kona berai kurisi. Ma ke kona notai da ami bera biibiisi kubiine, God ini biibiinimi. Berabero wawayisi nakanani turaturasi kurisi biibiina eberaberai. ");
INSERT INTO pwg_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ma bade wawaya mane kubiine ini nowi kurimi ma koakovi da karakava ami mane ina kovoghi na itekateka da mane kona veresi. Ma ke kona notai da ami verena kubiine, God ini biibiinimi. Berabero wawayisi nakanani evereverena turaturasi kurisi, iyamna iakovi da karakava i verena ruvana kudubina ina vii meyei. ");
INSERT INTO pwg_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Ma tami na kami ghavighaviya nuwanuwasi kona viiya, bera biibiisi kona berai kurisi, ma maranai mane kona veresi na ke kona notai da ini kovoghi. Nakanani kona berai na mara sago ami miiya ghamana God gwabinai kona viiya ma koni debemi da tami na God Kiidamo Makamakiina natunatuna. God ina agabiibai irakata berabero ma notameyena wawayisi kurisi, tuna kubiine tami natunatuna bade nakanani koberai. ");
INSERT INTO pwg_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Ikikava ami Mamai wawaya ikamyuyuwesi, bade nakanani wawaya kovi kamyuyuwesi.” ");
INSERT INTO pwg_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Wawaya ke koni tupaviresi na God ke ini tupaviremi. Wawaya ke koni wavusi na God ke ini wavumi. Wawaya i berabero kona notatawei na God ami berabero ina notatawei. ");
INSERT INTO pwg_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Kona verena ma bade God ina veremi. Vonavaghata da God ina vere kirakiiyemi da ina sasara, tuna nakanani ma puwata ami dabira tepanai ita tura kirakai da vavai ita ririgha. Ikikava wawaya kurisi koberaberai na maghimaghighina God ina berai kurimi.” ");
INSERT INTO pwg_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Ma Yesu ivi miiba, ivonesi bo, “Wawaya matapotapotana kwinana matapotapotana ini nowe bubuni bo kegha? Ke kovokovoghina. Kegha, ivi ruwa ku bonagha ina peku. ");
INSERT INTO pwg_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Iyavo kava wekarakava egirugiruma na ke kovokovoghina da i vibeyebeyena wawayina ina ghekuyowei. Ma mara sago giruma ina voyavui ma tuna maranai ti na i vibeyebeyena wawayina maghimaghighina.” ");
INSERT INTO pwg_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Avi kubiine kwinam matanai vunavuna kekitakitai ma tam matamuwai kiibuta ghamanakina ikenapotai na damina ke kuta viiviiya? ");
INSERT INTO pwg_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Ke bera biibiina da kwinam kuna vonei bo, ‘Utomo, kepisi vunavuna matamuwai ana votawei,’ ma tam na ke damina kuta viiya da matamuwai na kiibuta ghamana ikenapotai. Tam miiriruwaruwam! Kunona kiibuta matamuwai kevotawei da kuna kita bubuna ma muriyai vunavuna kwinam matanai kuna votawei.” ");
INSERT INTO pwg_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Kii biibiina na ke meyani amena berona ina terei. Ma kii berona ke meyani amena biibiina ina terei. ");
INSERT INTO pwg_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Ma kii amena kava kuna kitai na kunakovi da tuna na avi kiina. Ke kovokovoghina da koweya amesi gampuwe kamosiyai kuta yuna. Ke kovokovoghina da puiya amesi rarava tepanai kuta pura. ");
INSERT INTO pwg_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Wawaya biibiina na nuwanuwana kamonai biibiina enuwanuwaghanei. Nuwanuwana ina ghetawei na sisiya biibiisi ini sisiyei. Ma wawaya berona na nuwanuwana kamonai berona enuwanuwaghanei. Nuwanuwana ina ghetawei na sisiya beroberosi ini sisiyei. Nakanani etuputupuwa iyamna aviyavisina wawaya nuwanuwana kamonai emakamakai na ini badei da ini sisiya.” ");
INSERT INTO pwg_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Avi kubiine kovonavoneku bo, ‘Bada, Bada,’ ma aku sisiya ke kota vovotekatekei? ");
INSERT INTO pwg_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Meni wawayina ina pisi kuriku ma aku sisiya ini yanei ma ina votekatekei na ana vonemi da tuna na ikikava. ");
INSERT INTO pwg_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Tuna nakanani ma tomowa numa ita vowai na kii biibiisi ma bagibagisi itarai da numa kana kowora. Ma tano bagibagina ere wakimina iyabai ioru kirakai ma irutona. Ina numa ivowai ikovi na mara sago okowa ghamana ikiibau da ina numa iravi ma ke kovokovoghina da ita nukei bo ita karuwei, iyamna nani numana ivowa bubuni da ivi rewapana kirakai. ");
INSERT INTO pwg_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Ma meni wawayina aku sisiya ini yanei ma ke ita votekatekei na nakanani ma tomowa numa ita vowai na ke sago kowora ita rutona, ina numa na tano tepanai ivowai. Ma mara sago okowa ghamana ikiibau da ina numa iravi ma yaghiyaghinai nani numana ituparikai ma ikaruwei da kudubina iwapa tuwanonowa.” ");
INSERT INTO pwg_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Yesu weni sisiyisi peyarina wawaya kurisi ivi beyebeyena ikovi ma inae da irui ku Kapeniyam kwanatuna. ");
INSERT INTO pwg_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Ma Kapeniyam kamonai senturiyon sago imakamakai. Ma ina bigabiga kiimatanina igubaga kirakai da gisina kava ita rabobo. ");
INSERT INTO pwg_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Senturiyon sisiya ivi yanei da Yesu inekiibau na Jiu damsi i babada ivonatawesi kurina da kubiine iti nowi da ita pisi ma ina bigabiga iti yawai. ");
INSERT INTO pwg_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Babadisi Yesu kurina inekiibau na ivi nowi kirakai. Ivona bo, “Ita senturiyon kuti vitei iyamna tuna na tomowa biibiina. ");
INSERT INTO pwg_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Tuna dam viruwa wawayina ma kegha da tota Israel damta kurita ina nuwaviina irakata kirakai. Ivi vitekai da akii kiki numana ivowai kubiikai.” ");
INSERT INTO pwg_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Nakanani ivi sisiya, tuna kubiine Yesu ivomiiri da babadisi yavata inae. Gisina kava da senturiyon ina ku numa ita nekiibau ma ina yonayona iverupotesi da ivona bo, “Bada, ke kuni paparana da kuriku kuna pisi. Ainimaya da aku ku numa kuta rui. ");
INSERT INTO pwg_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Ke taku mani ata pisi kurim da ati nowi, iyamna anota meyeku da taku ke wawaya kiimataniku. Ma akovim da sisiya kava kuna terei na aku bigabiga ina yawasa. ");
INSERT INTO pwg_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Akovi da tam kovokovoghim, iyamna taku bade wawaya ghamaghamasi gaburisiyai ma aku rewapana gaburinai na seri wawayisi emakamakai. Sago ana vonei bo, ‘Kenae’ da ina nae. Ma sago ana vonei bo, ‘Kepisi’ da ina pisi. Ma aku bigabiga ana vonei bo, ‘Keberai’ da ina berai.” ");
INSERT INTO pwg_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Yesu weni sisiyina ivi yanei na ivi deyei. Itavire da koroto ghamana ikivikivini na ivonesi bo, “Kovi yaneku. Israel damsi kamosiyai ke sago wawaya ata panani da ina vitumaghana ita rakata weni senturiyon nakanani.” ");
INSERT INTO pwg_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Vaghina ma yonayona wawayina ivovira senturiyon ina ku numa ma ipanani da bigabiga namada iyawasa ikovi. ");
INSERT INTO pwg_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Mara sago Yesu inae ku kwanatu sago kana vava Nein. Ma kana kivikivina ma koroto ghamana yavata inae. ");
INSERT INTO pwg_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Kwanatu kana ku gari matuketina inekiibau na kwanatu damsi peyarisi ikiikiibau na ipananisi. Tomowa sago irabobo tuna kubiine ti na tupuwina ikavari ikiibau da ita dogoi. Tomowina ina maduwa na kwapukwapurina ma tuna na natuna tupukeya. ");
INSERT INTO pwg_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Ma Bada Yesu kwapurina ikitai da ivi kamyuyuwei na ivonei bo, “Ke kuna tou.” ");
INSERT INTO pwg_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Muriyai inae ku rito ma ivotovoni ma iyavo kava ikavakavari na ivi kiimiiriyesi. Ma Yesu ivona bo, “Yaraga, avonavonem da kevomiiri.” ");
INSERT INTO pwg_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Ma tomowina ivi kiimakiiyei ma sisiya ivi karei. Ma Yesu kwapurina ivonei bo, “Wavine, natum weni.” ");
INSERT INTO pwg_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Wawaya peyarisi nani korotona kamonai iyabumana ma God ivokavakavari. Ivona bo, “Peroveta ghamana kurita inekiibau, God ipisi da tota ina wawaya ini viteta.” ");
INSERT INTO pwg_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ma Yesu varana ikiibau da Judiya kamonai sisiyina dobu ine yavui. ");
INSERT INTO pwg_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Jon kana kivikivina inae ma Yesu varana ivi sisiyei Jon kurina. Ivi yanesi na kana kivikivina ruwa ikwatusi ");
INSERT INTO pwg_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","ma ivonatawesi Bada kurina da iti tarakiiyanei bo, “God ina Vivinevine Wawayina kakoyakoyaghi na tam bo wawaya sago kubiine kana koyagha?” ");
INSERT INTO pwg_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Ivi ruwa Yesu kurina inekiibau na ivonei bo, “Jon Babataito ivonatawekai da weni nakanani kati tarakiiyanem. ‘God ina Vivinevine Wawayina kakoyakoyaghi na tam bo wawaya sago kubiine kana koyagha?’” ");
INSERT INTO pwg_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Ma nani maranai Yesu gubagubagisi peyarisi ivivi yawasisi, kanuma beroberosi wawaya gwabisiyai ikwavikwavinisi ma matapotapotasi peyarisi iberaberisi da ikitakita. ");
INSERT INTO pwg_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Tuna kubiine Jon ina yonayona ivonapotesi bo, “Kona vovira Jon kurina da aviyavisina wekarakava kokitakitai ma koiyanei na kovi sisiyei. Kovonei da matapotapotasi ekitakita, digadigasi ebababa, giigiiposi eyawayawasa, tinapotapotasi iyana, raborabobosi evovomiiri, ma moyamoyakisi God varana biibiina iyanei. ");
INSERT INTO pwg_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Kovi tumaghaneku ma ke koni notaruwa na God ini biibiinimi.” ");
INSERT INTO pwg_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Jon ina yonayona inae ma muriyai Yesu ivi karei da koroto kurisi Jon ivi sisiyei. Ivona bo, “Rorova avi kubiine kokiibau ku warere? Aviyavisina kota kitai? Rai yanunu itapitapini na kota kitai, bo? ");
INSERT INTO pwg_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Mikeda kegha na avi kubiine kokiibau? Tomowa gara biibiina ivi kote na kota kitai, bo? Kegha, iyavo kava gara biibiisi ikote na ke warereyai ita makamakai, ti na mumurisi ma i numa ghamaghamasi kamonai emakamakai. ");
INSERT INTO pwg_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Ma, kovoneku. Kokiibau na avi kota kitai? God ina peroveta, bo? E, vaghina, vonavaghata da Jon na God ina peroveta. Ma peroperoveta kamosiyai na Jon ighe kirakai. ");
INSERT INTO pwg_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Giruma katamana ivi sisiyei, ivona bo, ‘Aku yonayona maghinomuwai ana vonatawei. Tuna am keta ina vovunaghi.’ ");
INSERT INTO pwg_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Avonavonemi da Jon na wawaya ghamana, tuna kubiine dobu ku kudubina wawaya sago kotekwai da Jon ita ghekuyowei na kotekwa kavai. Ma kegha da God ina vikiivavona kamonai Jon na ke wawaya ghamana. Nani kamonai wawayota na Jon ighekuyowei.” ");
INSERT INTO pwg_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Wawaya peyarisi, teks yuyuna damsi yavata na Yesu ina sisiya ivi yanei ma ivi vaghinei. Ivona da God ina keta na keta vaghata iyamna Jon namada ibabataitosi. ");
INSERT INTO pwg_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Ma Perisi damsi ma vonaviyoyovana vibeyebeyena wawayisi na ke iti vaghinei, iyamna ti na God ina keta ibarei ma ke ita babataito. ");
INSERT INTO pwg_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Ma Yesu ina sisiya ikwapanatini. “Avi miibiina ana terei da karako weni kimtina ani sisiyesi? I bera na ikikava? ");
INSERT INTO pwg_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Ti nakanani ma ededa merewai ita vivirekwa ma turaturasi kurisi ita rurukwatukwatu bo, ‘Enava karavi kubiimi na ke kota riku. Kasiyasiyapa na ke kota tou.’ ");
INSERT INTO pwg_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Jon Babataito ipisi na isiya, parawa ke ita kanikani ma wain ke itumumai na kovonavona bo, ‘Kanuma berona gwabinai.’ ");
INSERT INTO pwg_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Ma Wawaya Natusi ipisi na ekamkam ma eumuma na kovonavona bo, ‘Kamonabanabana ma umaneghaneghana. Tuna na teks yuyuna ma berabero wawayisi kwinasi.’ ");
INSERT INTO pwg_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Ma iyavo kava God ina nuwagiura ekivikivini, ti na nuwagiura natunatuna. Ma i yawasa ini debei da nani nuwagiurina na vonavaghata.” ");
INSERT INTO pwg_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Perisi sago Yesu ivonei da ita pisi ina ku numa da yavata ita kam. Ma Yesu inae da nevanevanai ikenavipika da ita kam. ");
INSERT INTO pwg_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Ma nani kwanatuna kamonai wavine sago imakamakai, ma ina yawasa kamonai berabero irakata kirakai. Ma nani wavinena ivi yanei da Yesu ipisi da Perisi tomowina yavata ikamkam na diudeu sago ikavarapiyei ina ku numa, kamonai na oira ghabughabuna. ");
INSERT INTO pwg_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Irui da Yesu murinai ivi kiimiiriyei ma tou ivi karei. Matadogana Yesu kaena ivivi butai ma uyawinai ikiikiipupuni. Muriyai kaena iyoyoni ma oira ghabughabuna ku kaena itepotepoi da ivovovisiboi. ");
INSERT INTO pwg_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Ma Perisi tomowina weni berasi ikitai na ivi nuwanotanota bo, “Weni tomowina na ke God ina peroveta. Iti peroveta na akova God gwabinai ita viiya da nani wavinena evovotovoni na berabero wawayina.” ");
INSERT INTO pwg_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Ma Yesu ivonei bo, “Saimon, ana vonem.” Ma Saimon ivona bo, “Bada, kevona.” ");
INSERT INTO pwg_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Ma Yesu ivi miiba, ivona bo, “Mara sago mura wawayina tomotomowa ruwa ivi vitesi da mane iveresi, ma ivonesi da karakava mane ruvana kudubina iti kovoghi. Sago na silva riririghisi ivi 500 iverei ma sago na ivi 50 iverei. ");
INSERT INTO pwg_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Muriyai ivi ruwa ipanani da ke kovokovoghina da nani manena ita kovoghi, tuna kubiine mura wawayina ivi kamyuyuwesi da kii tupi ivi notawapei. Ma ivi ruwa kamosiyai na meni tomowina ina nuwaviina ina rakata mura wawayina kurina?” ");
INSERT INTO pwg_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Ma Saimon ivonapotei bo, “Agunai, tomowina kana tupi irakata na bade ina nuwaviina irakata mura wawayina kurina.” Ma Yesu ivonei bo, “Kuvonapote bubuniku.” ");
INSERT INTO pwg_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Ma itavira wavinena kurina ma ivona bo, “Saimon, weni wavinena kekitai. Arui am ku numa na tam, okowa ke kuta vereku da kaeku ata kowai. Ma weni wavinena matadoganai kaeku ikowai ma uyawinai ikiipupuni. ");
INSERT INTO pwg_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ma tam ke kuta yoniku, ma weni wavinena kaeku yonina ke ita voterei. ");
INSERT INTO pwg_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ma bade tam ke oira ku gayamiku kuta tepoi da kuti monaghiku. Ma weni wavinena oira ghabughabuna ku kaeku itepoi. ");
INSERT INTO pwg_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Vaghina ma ana vonem. Weni wavinena ina bera beroberosi ipeyari kirakai ma peyarina anotatawei. Tuna kubiine ina nuwaviina kuriku irakata. Ma meni wawayina ina bera beroberosi ke ita peyari kirakai ma anotatawei na ina nuwaviina igisi.” ");
INSERT INTO pwg_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Ma Yesu wavinena kurina ivona bo, “Am bera beroberosi anotatawei ikovi.” ");
INSERT INTO pwg_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ma Saimon turaturana viya na yavata ikamkam ma ti mani kamosiyai ivonavona bo, “Weni tomowina na wawayota, ina rewapana kegha da wawaya i berabero ita notatawei.” ");
INSERT INTO pwg_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Ma Yesu wavinena ivonei bo, “Am vitumaghana kubiine kuyawasa. Kenae ma nuwanuba gwabimuwai ina makai.” ");
INSERT INTO pwg_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Nani murinai Yesu ibababa da kwanatu ma meyagai nununai God varana biibiina ma ina vikiivavona idimadimei. ");
INSERT INTO pwg_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Kana kivikivina ivi 12 ma bade wivine viya yavata ibababa, wivinesi na kii gubaga Yesu ivi yawisi bo kanuma beroberosi gwabisiyai ikwavinisi. Wivine kamosiyai sago na Meri Magadarini, tuna gwabinai Yesu kanuma beroberosi miikovimaruwa ikwavinisi. ");
INSERT INTO pwg_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Ma sago na Jowana, tuna kawana na Kusa, Herodi ina numa kana koyakoyagha. Ma sago na Susana ma bade wivine viya yavata. Weni wivinesi na Yesu ma kana kivikivina ivivi vitesi da ima tepasiyai ibababa. ");
INSERT INTO pwg_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Koroto ghamana i kwanatu bogii ma bogiiyai iriyei, ma Yesu weni miibiina ivonesi bo, ");
INSERT INTO pwg_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Mara sago tomowa inae pei vonina kubiine. Ma pei irubusagha da viya ketiyai iririgha ma wawaya ivi tugudaguda ma kiu ipisi da pei ikam yavui. ");
INSERT INTO pwg_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Ma viya wakima ku tepasi iririgha. Igogo ma tano ke niginigina kubiine, yaghiyaghinai isivi. ");
INSERT INTO pwg_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Ma pei viya iyiyo ku kamosi iririgha. Iyiyo yavata igogo ma iyiyo irogusi. ");
INSERT INTO pwg_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ma pei viya ku tano biibiina iririgha ma igogo ma iuwa bubuna da pei sago sago duma na 100 iterei.” Yesu weni miibiina ivi kovini na ikiirara bo, “Wawaya ere tinimi na aku sisiya kovi yana bogai.” ");
INSERT INTO pwg_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Kana kivikivina Yesu ivi tarakiiyanei da pei miibiina na iyamna avai. ");
INSERT INTO pwg_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Ma ivonesi bo, “Tami kurimi God ina vikiivavona ina nota gavugavusi kudubina aidebei. Ma wawaya peyarisi kurisi miibiiyai kava aisisiya da ‘ina kita ma ina kita ma ke ina kitai. Ini yana ma ini yana ma ke inakovi.’” ");
INSERT INTO pwg_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Pei vonina miibiina iyamna na weni. Pei na God vonana. ");
INSERT INTO pwg_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Pei ketiyai na wawaya God vonana ivi yanei ma Devil ipisi da nuwanuwasi kamonai iviitawei da ke iti tumaghana ma yawasa makamakii nonowina ke ita panani. ");
INSERT INTO pwg_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Ma pei wakima tepasiyai na wawaya God vonana ivi yanei ma nuwabiibiiyai iviini ma ramramsi kegha. Ivi tumaghana da ke mara gurina iyamna rubu ma nuwapoya ipanani da vitumaghana ivoterei. ");
INSERT INTO pwg_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Pei iyiyo kamosiyai na wawaya God vonana ivi yanei ma i yawasa kamonai dobu ina mura, dobu ina nuwapoya ma dobu ina nuwabiibai inotanota kirakiiyei da God vonana irogui. Pei iuwa da mabusi. ");
INSERT INTO pwg_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Ma pei tano biibiinai na wawaya God vonana ivi yanei ma nuwanuwasi yagharisi ma biibiisi da ivotani. Ivotekateka ma imiirikikina inenae da iuwa bubuna.” ");
INSERT INTO pwg_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Wawaya rampa ini nawai na ke bayawa vivikuratabuna kamonai ina terei bo kemakema gaburinai ina terei. Kegha, ini rorokei da iyavo kava ku numa ina rui na yaseganina ina kitai.” ");
INSERT INTO pwg_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","“Aviyavisina kudubina gavugavuna na God ini debei. Ma aviyavisina kudubina guduguduna na God ina votawei da wawaya inakovi.” ");
INSERT INTO pwg_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","“Tuna kubiine kovi yana bubuna, iyamna iyavo kava akova vaghata gwabisiyai na God ku tepana ina veresi. Ma iyavo kava inotanotai da namada iakova kirakai na i akova kudubina ina viitawei.” ");
INSERT INTO pwg_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Mara sago Yesu ina maduwa ma titina yoghoyogho ipisi da ita kitai. Ma koroto irakata da ke kovokovoghina da ita rui. ");
INSERT INTO pwg_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Ma wawaya sago Yesu ivonei bo, “Am maduwa ma titim yoghoyogho matarai ekoyakoyaghim. I kayowana da ina kitim.” ");
INSERT INTO pwg_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Ma Yesu ivonapotesi bo, “Aku maduwa ma titiku yoghoyogho na iyavo kava God vonana iyanei ma evovotekatekei.” ");
INSERT INTO pwg_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Mara sago Yesu kana kivikivina ivonesi bo, “Toka tadamani ku nevana.” Ma peyarisi ku waka igeru da ivomiiri. ");
INSERT INTO pwg_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Idamadamana ma waka kamonai Yesu ikena nunuwapa. Ma yanunu berona ivomiiri ma tovava irakata da waka ku kamona irurui da gisina kava ita monu. ");
INSERT INTO pwg_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Ma kana kivikivina ikiimataki ma ivonei bo, “Bada, Bada, tamonumonu ma tuma dodo!” Yesu ivomiiri da yanunu ma tovava iyeghisi da ivi nubai ma toka kamonai biimara ikena. ");
INSERT INTO pwg_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Ma kana kivikivina ivonesi bo, “Ami vitumaghana kegha, bo?” Ma kana kivikivina iyabumana ma inota kavakavai. Ma ti mani kamosiyai ivonavona bo, “Wena tomowa sago, sisiya bagibagina iterei na bade yanunu da tovava ivotekatekei!” ");
INSERT INTO pwg_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Yesu kana kivikivina yavata ikuka inae da Gariri tokana nevanai Gerasa damsi i ku kikira inekiibau da iwota. ");
INSERT INTO pwg_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Yesu ku tano iororu na tomowa sago iverupotei. Tomowina gwabinai kanuma beroberosi irunuma ma mara iguri kirakai da kwanatu ikiibutawei da ina numa kegha ma iyuna kava karawaga kamonai imakamakai. ");
INSERT INTO pwg_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Tomowina Yesu ikitai na ikiirara ma maghinonai itawotei ma ivona bo, “Avi kuna berai kuriku? Tam Yesu, God Kiidamo Makamakiina Natuna. Ainowi da kovogha ke kuna vereku!” ");
INSERT INTO pwg_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Nakanani ivi sisiya, iyamna namada Yesu kanuma berona iyeghai da tomowina ita kiibutawei. Mara ipeyari wawaya ibera tovoni da tomowina kaena ma imana cheiniyai ita patumi ma kana potapota ita terei da ita makai bubuna. Ma ibera kavai, iyamna nani kanumina itowatowatepani da chein ivivi tinayaraghana ma iveraverau ku dobu makiiwapasi. ");
INSERT INTO pwg_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Ma Yesu tomowina ivi tarakiiyanei bo, “Kam vava iyai?” Ma kanuma beroberosi peyarisi tomowina gwabinai irunuma, tuna kubiine ivonapotei bo, “Kakii vava Koroto.” ");
INSERT INTO pwg_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Ma ivi nowi kirakai da ke ita vonatawesi itoru ku Abis bonaghina. ");
INSERT INTO pwg_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Ma koya baranai poro yavona ghamana ikamkam. Tuna kubiine kanuma beroberosi ivi nowi da Yesu ita vonatawesi ita nae poro kurisi da gwabisiyai ita runuma. Ma ivi vaghinei. ");
INSERT INTO pwg_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Vaghina ma peyarisi tomowina ikiibutawei inae da poro itowatepanisi. Ma porosi iverau ku koya kiiyagirina ma iririgha ku okowa da iumadodowana. ");
INSERT INTO pwg_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Poro kii koyakoyagha weni berana ikitai na iverau da wawaya kwanatu kamonai ma dipiiyai ivi akovisi. ");
INSERT INTO pwg_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Ma wawayisi ikiibau ita kitai da aviyavisina itupuwa. Inekiibau Yesu kurina ma ipanani da tomowina kanuma beroberosi ikiibutawei na Yesu kaena ririnai imakamakai, ivi gara ma gayamina imanini. Peyarisi ikitai ma iyabumana kirakai. ");
INSERT INTO pwg_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Ma iyavo kava matasiyai bera peyarina ikitai na wawayisi kurisi ivi mamatara da ikikava tomowina iyawasa. ");
INSERT INTO pwg_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Muriyai Gerasa damsi peyarisi ivi nowi da Yesu i dobu ita kiibukuyowei iyamna iyabumana kirakai. Tuna kubiine Yesu ku waka igeru da ita nae. ");
INSERT INTO pwg_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Ma nani tomowina iyawasa na ivi nowi da yavata ita geru ita nae. Ma Yesu ivi kegha ma ivonatawei ina ku dobu. Ivonei bo, ");
INSERT INTO pwg_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Kenae am ku numa ma am wawaya kevi akovisi da ikikava God bera ghamaghamasi iberai kubiim.” Ma vaghina, tomowina inae ina ku kwanatu ma aviyavisina peyarina Yesu iberai ma ikikava ivi vitei na wawaya kurisi ivi sisiya kirakiiyei. ");
INSERT INTO pwg_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Yesu toka idamani, ivovira ku nevana na koroto ghamana iverupotei da ivi kiikiiwei, iyamna ivivi koyakoyagha da ita nekiibau. ");
INSERT INTO pwg_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Nani kamonai kiki numana badana sago ipisi da Yesu maghinonai itawotei. Tuna kana vava Jairas ma ivi nowi Yesu kurina da yavata ita nae ina ku numa, ");
INSERT INTO pwg_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","iyamna gisina kava ma natuna wavinena ita rabobo. Natuna na tupukeya ma kana madegha 12. Yesu ivomiiri da yavata inenae ma koroto irakata kirakai da ivivi tapasipasiyei. ");
INSERT INTO pwg_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Ma koroto kamonai na wavine sago gubagubagina. Kana gubaga na nawaravi iviiya da madegha 12 tarana iverau ma ibunama kavai. ");
INSERT INTO pwg_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Yesu murinai ipisi da kana gara damona ivotovoni ma yaghiyaghinai tarana veru ivoterei da iyawasa. ");
INSERT INTO pwg_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Ma Yesu ivi tarakiiyana bo, “Iyi ivotovoniku?” Ma wawaya peyarisi iveyiyei, ma Pita ivona bo, “Bada, koroto ghamana etatagudagudim ma ekiikiitabitabirim.” ");
INSERT INTO pwg_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Ma Yesu ivona bo, “Kegha, wawaya sago ivotovoniku. Damiku aviiya da rewapana gwabikuwai ikiibau.” ");
INSERT INTO pwg_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Ma wavinena damina iviiya da ke kovokovoghina da gavunai itonagha da ita nae na ere kirokirorona ipisi Yesu kurina ma maghinonai itawotei. Ma koroto maghinosiyai ivi mamatara da avi kubiine Yesu ivotovoni ma ikikava yaghiyaghinai iyawasa. ");
INSERT INTO pwg_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Ma Yesu wavinena ivonei bo, “Natuku, am vitumaghana kubiine kuyawasa. Kenae ma nuwanuba gwabimuwai ina makai.” ");
INSERT INTO pwg_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Yesu patana da ivivi sisiya ma wawaya sago Jairas ina numiiyai ipisi ma ivona bo, “Jairas, natum namada irabobo. Bada kevoterei, ke kuni tinaviravirai.” ");
INSERT INTO pwg_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Yesu weni sisiyina ivi yanei ma Jairas kurina ivona bo, “Ke kuna yabumana. Kevi tumaghaneku ma natum ina yawasa.” ");
INSERT INTO pwg_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Jairas ina ku numa inekiibau na wawaya peyarisi ivonapotesi da matarai imakai. Ma Pita, Jon da Jemes, ma bade wavine kikei ina mamai da ina maduwa na ti kava ivinesi da yavata ita rui. ");
INSERT INTO pwg_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Ma wawaya peyarisi ivivi tutuwana ma isiyasiyapa na ti kurisi Yesu ivona bo, “Vitutuwana kovoterei. Wavine kikei ekenakena, ke ita rabobo.” ");
INSERT INTO pwg_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Ma peyarisi Yesu ivi namei, iyamna iakovi da wavine kikei namada irabobo ikovi. ");
INSERT INTO pwg_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Ma Yesu wavine kikei yarona iviiya ma ivonei bo, “Natuku, kevomiiri.” ");
INSERT INTO pwg_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Vaghina ma, wavine kikei kanumina ivovira kurina da yaghiyaghinai ivomiiri. Muriyai Yesu ivonesi da vavai ita verei da ita kam. ");
INSERT INTO pwg_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Ma ina maduwa da ina mamai ivi deye kirakiiyei da natusi iyawasa. Ma Yesu ivonatanisi da ke ini mamatara wawaya kurisi da aviyavisina itupuwa. ");
INSERT INTO pwg_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Nani murinai, Yesu kana kivikivina ivi 12 ikwaturiyariyesi. Rewapana iveresi da kanuma beroberosi ita kwavinisi ma gubaga bogii ma bogiiyai iti yawisi. ");
INSERT INTO pwg_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Ma ivonatawesi ikiibau da God ina vikiivavona ita dimei ma wawaya gubagubagisi iti yawasisi. ");
INSERT INTO pwg_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Ma ivonesi bo, “Ke avi sago kona viiya keta kubiine. Ke diwona, kutu, vavai, bo mane, ma ke gara kana viruwa. ");
INSERT INTO pwg_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Meni wawayina ina ku numa kona rui na tuna kava gwabinai komakai ina nenae da ami ku vomiiri marana na nani kwanatuna kona kiibutawei. ");
INSERT INTO pwg_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Ma wawaya ke ini kiikiiwemi na i kwanatu kokiibutawei, kaevunavunami kovi turirighakuyowei ma konae. Ini matakira da kovogha ina panani.” ");
INSERT INTO pwg_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Ma vaghina kana kivikivina ivomiiri inae da kwanatu nununai God varana biibiina idimadimei ma gubagubagisi ivivi yawasisi. ");
INSERT INTO pwg_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Gariri kana kiivavo Herodi weni berasi varana ivi yanei na ina nota iragharagha kirakai, iyamna wawaya viya ivonavona da Jon Babataito rabobowai ivomiiri, ");
INSERT INTO pwg_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","ma viya ivonavona da peroveta Elaidiya inekiibau, ma bade viya ivonavona da God ina peroveta katamana sago ivomiiri. ");
INSERT INTO pwg_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Tuna kubiine kiivavo Herodi ivona bo, “Akovi da Jon iwana akiiyaraghi. Ma weni tomowina varana aiyanei na iyai?” Ma ibera tovoni da Yesu ita kitai. ");
INSERT INTO pwg_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Yesu ina aposol ivi 12 ivovira kurina ma aviyavisina kudubina iberaberai na ivonaverei. Muriyai irutinisi da yavata ti mani kava ita nae ku kwanatu sago kana vava Betsaida. ");
INSERT INTO pwg_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Ma koroto ghamana ikitai da Yesu kana kivikivina yavata inenae na ikivinisi. Yesu ikitisi ma ivi kiikiiwesi. Ma God ina vikiivavona ivi sisiyei kurisi, ma bade iyavo kava igubaga ma ekayokayowei da ita yawasa na ivi yawasisi. ");
INSERT INTO pwg_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Ravi ipika ma kana kivikivina ivi 12 ipisi kurina ma ivonei bo, “Weni na dobu makiiwapana. Koroto kuta vonatawesi ita nae da iyavo kava kwanatu kamosiyai ma dipiiyai emakamakai na gwabisiyai ita kam ma ita kena.” ");
INSERT INTO pwg_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Ma Yesu ivonapotesi bo, “Tami vavai koveresi da ina kam.” Ma ivonapotei bo, “Parawa miikovi ma iyana ruwa kava gwabikiiyai. Tuna ke kovokovoghina iyamna koroto irakata kirakai. Kevonavonekai da kata nae da kii vavai kata gimari bo?” ");
INSERT INTO pwg_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Ma nani korotona kamonai tomotomowa ivi 5 tausan. Ma ivonesi bo, “Wawaya korereghisi da 50, 50 nununai ina makai.” ");
INSERT INTO pwg_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Irereghisi ikovi ma wawaya imakiipikapika. ");
INSERT INTO pwg_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Ma Yesu parawa ma iyana iviiya ma itepa ku kunuma ma God ivi kiikiiwei. Ma ivogimagimai ma kana kivikivina iveresi da ita reregha. ");
INSERT INTO pwg_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Irereghi da wawaya kudubisi koroto kamonai ikam da ikamdodo. Muriyai kana kivikivina puwata makiiterena iyuna da kode 12 ivi tupoi. ");
INSERT INTO pwg_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Mara sago Yesu iniponipowana ma kana kivikivina ipisi na ivi tarakiiyanesi bo, “Wawaya evonavona da taku iyai?” ");
INSERT INTO pwg_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Ma ivonapotei bo, “Wawaya viya evonavona da tam na Jon Babataito, ma viya evonavona da tam na Elaidiya, ma viya evonavona da tam na God ina peroveta katamana sago ma rabobowai kuvomiiri.” ");
INSERT INTO pwg_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Ma Yesu ivonesi bo, “Ma tami, kovonavona da taku iyai?” Ma Pita ivonapotei bo, “Tam na God ina Vivinevine Wawayim.” ");
INSERT INTO pwg_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Ma Yesu sisiya bagibaginai ivonatanisi da ke wawaya kurisi iti mamatara da tuna iyai. ");
INSERT INTO pwg_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Ivona bo, “Taku Wawaya Natusi ani kamaghi kirakiiyei. Jiu damsi i babada ma taparoro babadisi i babada ma vonaviyoyovana vibeyebeyena wawayisi ina bareku. Ini raboboku ma mara viarobina kamonai na rabobowai ana vomiiri.” ");
INSERT INTO pwg_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Ma bade ivonesi bo, “Iyi tam kekayokayowei da kuna kiviniku na kevere meyem, am korosi kekavara nonowei ma murikuwai kepisi. ");
INSERT INTO pwg_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Tam iyai am yawasa kuna nuwaghanei na kuni wapai. Ma tam iyai am yawasa kuna nuwatawei kubiiku na yawasa makamakii nonowina kuna panani. ");
INSERT INTO pwg_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Ma kam vava ina rakata ma dobu kana mura kuna wagiwagiye kirakiiyei ma kanumim kuni wapai na kam vava ma am mura ke ini vitem. ");
INSERT INTO pwg_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Iyi tam kuni muritina ma kuna vonaveyiyeku na mara sago taku bade ana vonaveyiyem. Tuna maranai aku Mamai kana kadara kona kitai iyamna taku Wawaya Natusi aneya vovokaravisi yavata ere kadarikai kana pisi. ");
INSERT INTO pwg_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Vonavaghata avonavonemi, wawaya viya weni kamonai God ina vikiivavona kona kitai ma muriyai kona rabobo.” ");
INSERT INTO pwg_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Yesu weni sisiyisi iterei ma mara 8 murinai Pita, Jon, ma Jemes irutinisi ighae ku koya nipowana kubiine. ");
INSERT INTO pwg_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Iniponipowana ma kamonai Yesu maghighina ivire ma kana gara ipoi kirakiiyei da ivovokeyakeyu. ");
INSERT INTO pwg_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Ma tomotomowa ruwa ere kadakadarisi inekiibau, ti na Moses ma Elaidiya, ");
INSERT INTO pwg_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","ma Yesu yavata ivivi sisiya. Ikikava Yesu Jerusalem kamonai God ina kayowana peyarina ina bera yavui ma muriyai dobu ina kuyowei na peyarina ivivi sisiyei. ");
INSERT INTO pwg_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Kunona Pita turaturana yavata, matasi ipota kirakai. Muriyai ikitabanenega da Yesu ere kadarina nani tomotomowisi ruwa yavata ivivi miiriyana na ikitisi. ");
INSERT INTO pwg_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Tomotomowisi ivomiiri da ita kuyowesi na Pita, Yesu ivonei bo, “Bada, ibiibii kirakai da tota weni. Yobe aroba tavowai. Sago tam, sago Moses ma sago Elaidiya.” Pita ivi sisiya wapawapa, ke itakovi da aviyavisina ivivi sisiyei. ");
INSERT INTO pwg_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Ivivi sisiya kamonai na kwavu ioru da peyarisi isovosi ma Pita turaturana yavata iyabumana kirakai. ");
INSERT INTO pwg_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Ma kwavu kamonai God gamona ivona bo, “Wena na natuku, tuna aku Vivinevine Wawayina. Ina sisiya kovi yana bubuni.” ");
INSERT INTO pwg_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Gamona ivi sisiya ikovi na kana kivikivina ikitame da Yesu ina kina kava imakamakai. Ma ti na weni berana ivi nuwanotanotei ma ke iti mamatarei wawaya kurisi. ");
INSERT INTO pwg_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Mara itom na Yesu kana kivikivina ivi aroba yavata koyiyai iororu ma koroto ghamana iverupotesi. ");
INSERT INTO pwg_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Ma tomowa sago nani korotona kamonai irukwatu bo, “Bada, ainowi da natuku tomowa tupukeya kuta kitai ma kuti vitei. ");
INSERT INTO pwg_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Kanuma berona gwabinai irunuma ma mara nonowa edagudagui na yaghiyaghinai ekiikiirara ma eparoparoro da kawapuropurona ekiikiibau. Nani kanumina edagudagui na gubaga epanapanani ma ke meyani da taraboga ita vereverei da ita viviyakam. ");
INSERT INTO pwg_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Kam kivikivina avi nowi kurisi da ita kwavini ma ibera kavai.” ");
INSERT INTO pwg_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Ma Yesu ivonapotesi bo, “Tami na kimta kawakiikiimi ma ami vitumaghana kegha. Ininiku ibara da namada ata voteremi.” Ma tomowa kikei ina mamai kurina ivona bo, “Natum kerutinapiyei.” ");
INSERT INTO pwg_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Tomowa kikei ibaba ipipisi na kanuma berona idagui da itawei ku tano ma ivivi tukosokosowana. Ma Yesu kanuma berona iyeghai na tomowa kikei ikiibutawei da iyawasa. Ma ina mamai kurina ivona bo, “Natum weni.” ");
INSERT INTO pwg_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Ma weni berana itupuwa na wawaya peyarisi God ina rewapana ghamana ikitai da ivi deyei. Wawaya Yesu ina bera kudubina patana da ivivi deyei ma nani kamonai Yesu kana kivikivina kurisi ivona bo, ");
INSERT INTO pwg_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Aviyavisina ana vonemi na kovi yana bogai. Wawaya sago, taku Wawaya Natusi ini wawaneku da kaku ghavighaviya ku imasi ina tereku.” ");
INSERT INTO pwg_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Ma kana kivikivina ke itakovi da aviyavisina ivivi sisiyei, God i nota ikiiviwapawapai da iyamna ke ita vii bubuni. Ma iyabumana kubiine na ke iti tarakiiyanei da ina sisiya na iyamna avai. ");
INSERT INTO pwg_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Mara sago Yesu kana kivikivina vigamowana ivi karei da kamosiyai iyi iti wawaya ghamana da turaturana ita ghekuyowesi. ");
INSERT INTO pwg_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Ma Yesu i nota iakovi, tuna kubiine wawaya kikei sago iviiya da ririnai ivi miirini. ");
INSERT INTO pwg_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Ma ivonesi bo, “Tami iyavo kava avakuwai wawaya kikei koni kiikiiwei na taku yavata koikiikiiweku. Ma iyavo kava koni kiikiiweku na bade wawayina ivonataweku na tuna yavata koikiikiiwei. Ma meni wawayina ina tereoruwe meyei, tuna wawayina na turaturana ina ghekuyowesi God ku matana.” ");
INSERT INTO pwg_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Ma Jon ivona bo, “Bada, tomowa sago kakitai, avamuwai kanuma beroberosi ikwavikwavinisi. Ma tuna na ke tota ita wawaya, tuna kubiine kavonei da ita voterei.” ");
INSERT INTO pwg_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Ma Yesu ivonesi bo, “Ke kona vonei da ina voterei. Meni wawayina ke ita vivikawapatemi na kwinami.” ");
INSERT INTO pwg_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Mara itupo da Yesu dobu ita kuyowei ma ita ghae ku kunuma, ma ina nota ivi rewapana da ivomiiri ku Jerusalem. ");
INSERT INTO pwg_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Ibaba inenae na yonayona ivonatawesi ivi nao Sameriya damsi i ku kwanatu sago da ita vovunagha da Yesu ita rui kurisi. ");
INSERT INTO pwg_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Ma Sameriya damsi iakovi da Yesu inenae ku Jerusalem, tuna kubiine ibara ma ke iti kiikiiwei. ");
INSERT INTO pwg_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Ma kana kivikivina Jemes da Jon ikitai da damsi Yesu ke iti kiikiiwei na ivona bo, “Bada, tinowi da God keyama karakaratina kunumai ina vonatawei inoru da weni damsi ina gwaramutusi.” ");
INSERT INTO pwg_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Ma Yesu imiiritavire ma iyeghisi. ");
INSERT INTO pwg_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Ma kana kivikivina yavata ivomiiri inae ku meyagai sago. ");
INSERT INTO pwg_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Yesu kana kivikivina yavata ibaba inenae ma ketiyai tomowa sago Yesu kurina ivona bo, “Mike kuna nenae na ana kivinim.” ");
INSERT INTO pwg_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Ma Yesu ivonapotei bo, “Kukou dipa kii buba emakamakai ma kiu kiidamowai kii nighu emakamakai ma taku Wawaya Natusi aku kenakena gawarina kegha.” ");
INSERT INTO pwg_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Ma Yesu tomowa sago kurina ivona bo, “Kekiviniku.” Ma ivonapotei bo, “Bada, vaghina bo kegha da aku mamai ana dogoi ma muriyai ana pisi da ana kivinim.” ");
INSERT INTO pwg_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Ma Yesu ivona bo, “Wawaya raborabobosi i biga da raborabobosi ina dogosi. Ma tam na am biga da God ina vikiivavona kuna dimei.” ");
INSERT INTO pwg_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Ma bade tomowa sago ivona bo, “Bada, ana kivinim ma karakava, iyamna ana nae da aku wawaya ani kiruruwesi.” ");
INSERT INTO pwg_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Ma Yesu ivonapotei bo, “Wayowa wawayina ina kayowana da ina tano inuwata bubuni na uwata sawarina ina votani da bagibagina maranai ox nani sawarina etitini. Ma bade ku maghinona kava ina kitakita da maninina ina nae ma ke ina tavire. Iyi tam am kayowana da God ina vikiivavona kubiine kuna biga ma mikeda kuna tavire na tam ke kovokovoghim da ina biga kuna berai.” ");
INSERT INTO pwg_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Yesu ivi sisiya ikovi ma kana kivikivina ivi 72 ivinesi. Ma ruwa ruwa duma ivonatawesi ivi nao ku kwanatu ma dobu bogii ma bogiiyai. ");
INSERT INTO pwg_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ma ivonesi bo, “Vavai itawagha ma iyavo kava ina yaba? Vao irakata ma yabayaba wawayisi iruwa kikei. Vao badana kurina kovi nowi da yabayaba wawayisi peyarisi ina vonatawesi da yavata tayaba. ");
INSERT INTO pwg_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Konae. Tami nakanani ma sipu gegeyisi ma kukou dipa ku kamosi avonavonatawemi. ");
INSERT INTO pwg_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Ma ami baba kubiine, mane kana kutu ke kona kavari, wagu kegha, ma kaemi kana terepapara kana viruwa ke kona kavari. Ma ketiyai wawaya kona panani na ke kona kweya da ina guri kirakai. ");
INSERT INTO pwg_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Ma wawaya i ku numa kona nekiibau da kii numataya na kovona bo, ‘Weni numanai God ina nuwanuba ina makai.’ ");
INSERT INTO pwg_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Ma mikeda wawayisi na biibiisi nani numanai na God ini biibiinisi da ina nuwanuba gwabisiyai ina makai. Ma mikeda ti na ke wawaya biibiisi na God ina nuwanuba ke ina viiya. ");
INSERT INTO pwg_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Ma meni ku numana kona nekiibau da kii numataya na nani numanai kava komakai. Ma aviyavisina ina veremi na kokani ma koumai. Koakovi da bera maninina da bagibagi wawayina kana miiya ina viiya. Ma ke koni gubamavuremi. ");
INSERT INTO pwg_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Ma maranai ku kwanatu sago kona rui ma wawaya ini kiikiiwemi na aviyavisina ku maghinomi ina terei na kokani, ");
INSERT INTO pwg_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","gubagubagisi nani dobunai kovi yawasisi, ma peyarisi kovonesi bo, ‘God ina vikiivavona enenekiibau kurimi.’ ");
INSERT INTO pwg_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Ma maranai ku kwanatu sago kona rui ma wawaya ke ini kiikiiwemi na ketiyai kona miiri ma kona vona bo, ");
INSERT INTO pwg_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Tami ami kwanatu vunavunana kaekiiyai kakiikiiririghatawei. Nuwanuwami ke ina wapa da God ina vikiivavona ita nekiibau kurimi ma kobarei.’” ");
INSERT INTO pwg_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Ma Yesu ina sisiya ikwapanatini, ivona bo, “Vonavaghata avonavonemi. Vitupavira kana mara ina nekiibau na meni kwanatuna God ina vikiivavona ina barei na kii kovogha ina rakata da Sodom damsi kii kovogha ina ghekuyowei.” ");
INSERT INTO pwg_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Koti nuwapoya kirakai, Korasin dami! Koti nuwapoya kirakai, Betsaida dami! Ami kwanatu kamosiyai bera ghamaghamasi aberai ma ami berabero ke kota miirikupukuputei. Nani berasi Taya ma Saidon kwanatusi kamosiyai ata berai na yaghiyaghinai i berabero itinimayei ma ita miirikupukuputei ma ere yapuyapukaresi mowamowasi ita vivikote, iti matakira da i berabero kubiine inuwapoya. ");
INSERT INTO pwg_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Ma vitupavira kana mara ina nekiibau na Korasin ma Betsaida dami kami kovogha ina rakata kirakai, ke Taya ma Saidon damsi kii kovogha nakanani. ");
INSERT INTO pwg_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ma Kapeniyam dami, konotanotai da kota ghae ku kunuma, bo? Kegha! God ina tawemi konoru ku keyama karata makamakii nonowina.” ");
INSERT INTO pwg_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Ma kana kivikivina ivonesi bo, “Iyavo kava ini yanemi na taku yavata iyaneku. Ma iyavo kava ina baremi na taku yavata ibareku. Ma iyavo kava ina bareku na wawayina ivonataweku na tuna yavata ibarei.” ");
INSERT INTO pwg_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Yesu kana kivikivina ivi 72 nuwabiibiiyai ivovira kurina da ivona bo, “Bada, avamuwai sisiya bagibagisi katerei ma kanuma beroberosi ivotekateka!” ");
INSERT INTO pwg_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Ma ivonapotesi bo, “Taku mani Seitan akitai, tuna namanamara nakanani kunumai ipeku. ");
INSERT INTO pwg_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Rewapana averemi da mota ma gwaghagwagha koni tugudaguda ma bade kata ghaviya ina rewapana kudubina kona ghekuyowei. Ma ke sago gubaga kona panani. ");
INSERT INTO pwg_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Ma ke koni nuwabiibai da kanuma beroberosi evovotekatekemi, iyamna tuna na ke bera ghamana. Kovi nuwabiibii kirakai da God kami vava kunumai igirumi.” ");
INSERT INTO pwg_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Nani maranai Yesu, Kanuma Vovokaravina damina iviiya da ivi nuwabiibii kirakai ma ivona bo, “O, Mamai, tam Bada kunumai ma dobuwai. Aikiikiiwem da vonavaghata kuteregavui da iyavo kava inotanotai da i nuwagiura ma i akovi irakata na ke itakovi. Ma iyavo kava ti nakanani ma ededa yoghoyogho na kurisi vonavaghata kuvi debei da iakovi. E, Mamai, am kayowana kuberai da nakanani itupuwa.” ");
INSERT INTO pwg_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","“Aku Mamai bera peyarina ivereku. Ma Mamai kava Natuna iakova bubuni. Ma Natuna na Mamai iakova bubuni. Ma iyavo kava Natuna ivinesi da ina Mamai ivi debei kurisi na ti yavata Mamai iakova bubuni.” ");
INSERT INTO pwg_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Ma Yesu imiiritavire ma kana kivikivina kava kurisi ivona bo, “Kovi nuwabiibai da God ivi biibiinimi da weni berasi peyarina matamiyai kokitakitai. ");
INSERT INTO pwg_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Avonavonemi da peroperoveta ma kiikiivavo peyarisi i kayowana da aviyavisina kokitakitai na ita kitai ma kegha. Ma bade i kayowana da aviyavisina kovi yanei na iti yanei ma kegha.” ");
INSERT INTO pwg_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Vonaviyoyovana vibeyebeyena wawayina sago ivomiiri da Yesu ita rubui. Ivona bo, “Bada, avi ana berai da yawasa makamakii nonowina ana panani?” ");
INSERT INTO pwg_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Ma Yesu ivonapotei bo, “Moses ina vonaviyoyovana kuvi yavi na kamonai aviyavisina iterei? Am nota ikikava?” ");
INSERT INTO pwg_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Ma ivonapotei bo, “‘God nuwanuwana kuna viiya. Nuwanuwam kudubina, kanumim kudubina, am nota kudubina ma am rewapana kudubina God kuna verei.’ Ma bade igiruma bo, ‘Ikikava tam mani kinuwaviina meyem, nakanani kwinam nuwanuwana keviiya.’” ");
INSERT INTO pwg_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Ma Yesu ivonei bo, “Kuvona bubuna. Nakanani keberai ma yawasa makamakii nonowina kuna panani.” ");
INSERT INTO pwg_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Ma tomowina ke iti nuwabiibai ma ina kayowana da tuna mani ku biibiina ita tere meyei. Tuna kubiine Yesu ivi tarakiiyanei bo, “Igiruma da kwinaku kurina ati nuwaviina na meni wawayisi kava kurisi ata berai?” ");
INSERT INTO pwg_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Ma Yesu ivonapotei bo, “Tomowa sago Jerusalemuwai ivomiiri, ibaba iororu ku Jeriko. Ma keta borinai yapiyapi wawayisi tomowina ivowai. Kana gara irupami ma ivi kiiyedarana kirakiiyei da gisina kava ita rabobo ma iverukuyowei. ");
INSERT INTO pwg_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Ma taparoro badana sago nani ketanai ibaba ipisi da tomowina ikitai. Ma iveruvuvurei da ibaba inae. ");
INSERT INTO pwg_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Muriyai Livai tomowina sago ipisi da meni gawarinai tomowina ikenakena nake na berana sago iberai, ikitai ma iveruvuvurei da ibaba inae. ");
INSERT INTO pwg_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Ma murina vaghata na Sameriya tomowa ibaba da meni gawarinai tomowina ikenakena na kurina inekiibau. Ikitai da ivi kamyuyuwei. ");
INSERT INTO pwg_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Inae kurina ma kana gubaga ibunami, oira ma wain itepoi ma igerei. Ma ikavari, ina ku donki ivi gerui ma ineyei numanumataya i ku numa. Ma yavata imakii mareba da ikoyagha bubuni. ");
INSERT INTO pwg_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Mara itom na ina kutu ivotawei da silva mane riririghisi ruwa iviiya. Ma numa kana koyakoyagha iverei ma ivonei bo, ‘Ita tomowa kekoyagha bubuni. Ma mikeda weni manena ke kovokovoghina na ana vovirame wike ma ku tepana ana terei.’” ");
INSERT INTO pwg_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Yesu weni miibiina ivi kovini ma vonaviyoyovana vibeyebeyena wawayina kurina ivona bo, “Am nota ikikava? Weni wawayisi ivi aroba kamosiyai na meni tomowina ivi kwinana bubuna gubagubagina kurina?” ");
INSERT INTO pwg_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Ma ivonapotei bo, “Nani tomowina ivivi kamyuyuwei.” Ma Yesu ivona bo, “Vaghina. Kenae ma tam bade nakanani keberai.” ");
INSERT INTO pwg_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Yesu kana kivikivina yavata ibaba inenae da ku kwanatu sago inekiibau. Ma nani dobunai wavine sago kana vava Mata ivi kiikiiwesi ma irutinisi da kana numataya. ");
INSERT INTO pwg_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Mata tina kikei kana vava Meri ma tuna inae da Yesu kaena ririnai imakai da ina vibeyebeyena ivivi yana bogai. ");
INSERT INTO pwg_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Ma Mata ina biga irakata da ivi tinavirai tuna kubiine ivi nuwapoya da inae Yesu kurina ma ivona bo, “Kuti kamyuyuweku. Tiku kikei ivotereku da biga kudubina ina kiku kava aberaberai. Kevonei da ini viteku.” ");
INSERT INTO pwg_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Ma Bada ivonapotei bo, “Mata, Mata. Kegiyagiyaguwa ma bera peyarina kinuwapoya kirakiiyei. ");
INSERT INTO pwg_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Bera sago kava ibiibii kirakai ma tuna kuta kayowei. Meri na bera biibiina ivinei da ke ini wapai.” ");
INSERT INTO pwg_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Mara sago Yesu inae ku dobu sago ma iniponipowana. Inipowana ikovi na kana kivikivina sago ivonei bo, “Bada, Jon kana kivikivina ivi beyebeyesi da ikikava ita nipowana. Ma nakanani kuti beyebeyekai da kata nipowana.” ");
INSERT INTO pwg_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Ma Yesu ivonesi bo, “Maranai kona niponipowana, kovona bo, ‘Mamai, Kam vava kavovokaravei. Kainowi da am vikiivavona dobuwai ina makai. ");
INSERT INTO pwg_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Mara nonowa kakii vavai keverekai. ");
INSERT INTO pwg_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Ma wawaya i bera beroberosi kurikai kanotatawei na nakanani akii bera beroberosi kenotatawei. Kevi nowekai da ruyagha ke kana panani.’” ");
INSERT INTO pwg_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Ma bade ivonesi bo, “Mikeda didibarai kwinam sago kurina kuta nae ma kuti nowi bo, ‘Kwinaku, puwata gisina kuta vereku ");
INSERT INTO pwg_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","iyamna kaku numataya sago wekarakava dobu rabarabai ipisi ma ke sago aviyavisina gwabikuwai da ata verei ita kam.’ ");
INSERT INTO pwg_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Iyi tam nakanani kuti nowi na kwinam numa kamonai ina kayowana da ita vonapotem bo, ‘Kenetaweyana! Ke ana vomiiri da ani vitem. Matuketa agudui ikovi, ma natunatuku yavata kakenakena.’ ");
INSERT INTO pwg_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Avonavonemi, nakanani ita vonapotem ma kegha da ina vomiiri da puwata ina verem. Avi kubiine? Ke tam kwinana kubiine da ini vitem ma kuvi nowi kirakai, kuvi tepatora ma ke kutinimaya, tuna kubiine ina vomiiri ma am nuwapoya kudubina ina berai. ");
INSERT INTO pwg_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Tuna kubiine avonavonemi da kovi nowi da God ina veremi. Koekwa da ami kayowana kona panani. Kokiipowapowara da God matuketa ina votawei. ");
INSERT INTO pwg_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Iyavo kava God kurina ini nowi na kudubisi kurisi ina verena. Iyavo kava inekwa na i kayowana ina panani. Ma iyavo kava ina kiipowapowara na matuketa ina votawei kubiisi. ");
INSERT INTO pwg_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Mikeda natum ita pisi ma iyana kubiine iti nowi kurim na mota kuta verei, bo? Kegha taweyana. ");
INSERT INTO pwg_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Bo kiu pupuna kubiine iti nowi kurim na gwaghagwagha kuta verei, bo? Kegha taweyana. ");
INSERT INTO pwg_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Tami na wawaya beroberomi ma kegha da koakovi da natunatumi kurisi puyo biibiisi kovereveresi. Ma ami Mamai kunumai na wawaya biibiina. Koni nowi na Kanuma Vovokaravina ina veremi.” ");
INSERT INTO pwg_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Mara sago Yesu kanuma berona tomowa sago gwabinai ikwavini, kanumina iberai da tomowina ke kovokovoghina da iti sisiya. Ikiibutawei inae na tomowina sisiya ivi karei ma koroto ghamana weni berana ikitai da ivi deyei. ");
INSERT INTO pwg_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Ma wawaya viya ivona bo, “Yesu ina rewapana kanuma beroberosi i kiivavo Berusiburu gwabinai iviiya da kanuma beroberosi ekwavikwavinisi.” ");
INSERT INTO pwg_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Ma viya na Yesu irubui, ivi nowi da bera ghamana ita berai, iti matakira da ina rewapana God gwabinai iviiya. ");
INSERT INTO pwg_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Ma Yesu i nota iakovi ma ivona bo, “Mikeda kiivavo sago ina wawaya ita totoyaraghi da dam ruwa na nani kiivavona ina rewapana ita gisi. Bo mikeda dam sago kamonai rakaraka ruwa iti kawapata na nani damna ke ita miirikikina, ita peku. ");
INSERT INTO pwg_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Seitan tuna mani ina wawaya yavata iti kawapata na ke kovokovoghina da ina vikiivavona ita miirikikina. Kovonavona da Berusiburu rewapana ivereku da kanuma beroberosi akwavikwavinisi, tuna kubiine weni nakanani aisisiya. ");
INSERT INTO pwg_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Ma mikeda Berusiburu rewapana ita vereku da kanuma beroberosi ata kwavinisi na kami kivikivina na rewapana iyi gwabinai iviiya da ekwavikwavinisi? Tami mani kami kivikivina ina vonemi da tami koibero. ");
INSERT INTO pwg_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Ma taku na God imana gwabikuwai da ina rewapanai akwavikwavinisi na aidebei kurimi da God ina vikiivavona inekiibau.” ");
INSERT INTO pwg_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Tomowa rewapanina ere kapiyina ina numa ini tarapaparanei na ina sawara kudubina ina makai bubuna. ");
INSERT INTO pwg_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Ma wawaya sago rewapana kirakiina ina kayaya kurina da ina ghekuyowei na ina sawara ma nani kapiyina tomowina ivivi tumaghanei na peyarina ina kavari ina nae da sawarisi turaturana yavata ina rereghi.” ");
INSERT INTO pwg_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Tuna kubiine meni wawayina ke kwinaku na ikawapateku. Ma meni wawayina ke iti viteku da yavata kata vivikiidaburana na aku biga eresoresotawei.” ");
INSERT INTO pwg_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Kanuma berona wawaya ina kiibukuyowei na warereyai ina baba yawara, gawara inekwai da ini yakam, ma ke ina panani. Ma ina vona bo, ‘Aku numa avoterei na ana vovira nake.’ ");
INSERT INTO pwg_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Ina nekiibau na ina kitai da wawaya numa igigiri ma bera peyarina itere bubuni. ");
INSERT INTO pwg_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Vaghina ma ina nae da kanuma beroberosi bero kirakiisi miikovimaruwa ina rutinisi ma peyarisi ina vovirame tomowina kurina da gwabinai ina runuma. Kunona tomowina ina yawasa ibero. Ma peyarisi ina runuma na ina yawasa ina bero kirakai.” ");
INSERT INTO pwg_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Yesu ivivi sisiya ma wavine sago koroto kamonai ikiirara bo, “Am maduwa iti nuwabiibai da ivi tuwem ma ivi susum.” ");
INSERT INTO pwg_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Ma ivonapotei bo, “Ma iyavo kava God vonana ini yanei ma ina votekatekei na God ini biibiinisi da i nuwabiibai ina rakata sasara.” ");
INSERT INTO pwg_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Yesu gwabinai koroto irakata kirakai ma ivonesi bo, “Weni kimtina na wawaya beroberosi, ekayokayowei da matakira ghamana ita kitai ma ke sago matakira ana veresi da sago kava ina kitai, tuna na Jona ina matakira. ");
INSERT INTO pwg_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Ikikava Jona ivi matakira Nineva damsi kurisi, nakanani Wawaya Natusi ini matakira weni kimtina kurisi. ");
INSERT INTO pwg_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Vitupavira kana mara ina pisi na Seba damsi i kiivavo wavinena ina vomiiri ma ina vonakiiyaragha da wawaya weni kimtina kamonai na berabero wawayisi. Mara katamaninai nani wavinena dobu rabarabai ibaba inae Kiivavo Soromon kurina da ina nuwagiura iti yanei. Ma karako weni maranai, wawaya sago inekiibau ma tuna na Soromon ighekuyowei. ");
INSERT INTO pwg_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Jona idima Nineva damsi kurisi na i berabero ivinimayei ma imiirikupukuputei. Ma mara damonai Nineva damsi ina vomiiri ma ina vonakiiyaragha da wawaya weni kimtina kamonai na berabero wawayisi. Ma karako wawaya sago inekiibau ma tuna na Jona ighekuyowei.” ");
INSERT INTO pwg_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Wawaya rampa ina kapuni na ke ina teregavui ma bade ke bayawa vivikuratabuna kamonai ina terei. Kegha, ini rorokei da iyavo kava ina rui ku numa na yaseganina ina kitai. ");
INSERT INTO pwg_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Matami na tupuwimi kana kibe. Matami biibiisi da kokitakita bubuna na yasegana gwabimiyai da tupuwimi inunui. Ma matami beroberosi da ke kota kitakita na nubakutuva gwabimiyai da tupuwimi inunui. ");
INSERT INTO pwg_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Tuna kubiine kokitaruvimi da yasegana gwabimiyai ina makai ma ke nubakutuva. ");
INSERT INTO pwg_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Mikeda yasegana gwabimiyai ma tupuwim kamonai nubakutuva kegha na yasegana gwabimiyai ina rakata da yaghiyaghinai tupuwimi kudubina ina yasegana yavui. Tuna nakanani ma kibe gweyurina ita kamowanimi.” ");
INSERT INTO pwg_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Yesu ivi sisiya ikovi ma Perisi sago ipisi kurina ma ivonei da yavata ita nae da ina numiiyai ita kam. Inae ma Yesu irui ina ku numa ma nevanevanai ikenavipika da ita kam. ");
INSERT INTO pwg_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Ma Perisi tomowina ivi deye kirakiiyei da Yesu i kiki ke ita nunuri, imana ke ita tepokowakowai. ");
INSERT INTO pwg_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Ma Bada Yesu ivona bo, “Tami Perisi dami dabira ma redu kupusi kotepotepokowakowa, ma kamosiyai na panikowa ma nota dowadowasi itupo. ");
INSERT INTO pwg_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Neghaneghami! God ke kupuna kava ita yamoni ma kamona yavata. ");
INSERT INTO pwg_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Aviyavisina ami dabira kamonai na konuwatawei ma moyamoyakisi kurisi koverena. Nakanani kona berai na kudubina kona gigiri da God ku matana na biibiina kavakava.” ");
INSERT INTO pwg_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Tami Perisi dami, koti nuwapoya kirakai iyamna bera gisigisisi konununura bogai ma bera ghamaghamasi ke kota beraberai! Vane ruguruguna ami vao kamonai koiyiyavi da viya ma ruguruguna imaruwa kamosiyai na sago koviiviiya da Taparoro Numana kamonai God kurina kosuwasuwara. Ma bera maninisi wawaya kurisi ke kota beraberai, ma bade God nuwanuwana ke kota viiya. Bera gisigisisi koberaberai na vaghina, ma bade ku tepana na bera ghamaghamasi yavata kota beraberai.” ");
INSERT INTO pwg_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Tami Perisi dami, koti nuwapoya kirakai, iyamna ami kayowana ghamana da koti wawayaghama, tuna kubiine kiki numasi kamonai wawaya ghamaghamasi kii gawarai komakamakiivipika ma bade vigimara gawarisiyai ami kayowana da wawaya ina vokaravemi. ");
INSERT INTO pwg_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Tami Perisi dami, koti nuwapoya kirakai, iyamna tami nakanani ma karawaga ke gwagwagwarina. Wawaya tepanai ina baba ma ke itakovi da kaesi gaburinai na wawaya tupuwina idogoi.” ");
INSERT INTO pwg_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Ma vonaviyoyovana vibeyebeyena wawayina sago ivona bo, “Bada, weni nakanani kisisiya na tokai yavata kevonavonavigibowikai.” ");
INSERT INTO pwg_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Ma Yesu ivonapotei bo, “Tami bade vonaviyoyovana vibeyebeyena wawayimi, koti nuwapoya kirakai, iyamna vita ghamaghamasi wawaya kovereveresi ma ke ruvaruvana da ita kavari. Ma bade ke kota vovororona da koti vitesi. ");
INSERT INTO pwg_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Koti nuwapoya kirakai, iyamna ami kaekiki mau God ina peroperoveta ivi kiivunuwana ma idogosi. Ma tami na meni gawarisiyai idogosi na kii matakira kopasipasi. ");
INSERT INTO pwg_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Nakanani koberaberai na koimamatara meyemi da ami kaekiki i berabero koivaghinei iyamna ti na ivi kiivunuwana ma tami na kii matakira kopasipasi. ");
INSERT INTO pwg_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","God namada iakovi da nakanani kota berai tuna kubiine ivona bo, ‘Aku peroperoveta ma aposol ana vonatawesi kurisi. Ma viya ini kiivunuwana ma viya ini tupaketowanesi.’ ");
INSERT INTO pwg_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Dobu karenai da ku karako peroperoveta peyarisi ivi kiivunuwana ma tarasi isororo na God weni kimtina ini wavumi, tami biwana kudubina kona viiya. ");
INSERT INTO pwg_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Abel tarana kubiine ma bade Zekaraya tarana kubiine, tuna suwara kapuna kana kema ma Taparoro Numana basunai ikiivunui da irabobo. Vonavaghata Abel ina mariyai ipisi da ku Zekaraya na kudubisi i rabobo kubiine na biwana God weni kimtina ina veremi.” ");
INSERT INTO pwg_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Tami vonaviyoyovana vibeyebeyena wawayimi, koti nuwapoya kirakai, iyamna koiketagudugudu da wawaya vonavaghata ina ku numa ke ina rui. Tami mani ke kota rui ma bade iyavo kava i kayowana da ita rui na koitarapaparanesi.” ");
INSERT INTO pwg_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Ma Yesu nani dobuna ivoterei da inae. Ma tuna maranai Perisi damsi ma vonaviyoyovana vibeyebeyena wawayisi ivi karei da Yesu kurina nuwanuwasi ipughupughu da yavata ivivi kawapata. Ma mara nonowa Yesu kurina vitarakiiyana bogii ma bogiiyai itereterei da ivivi kaetina. ");
INSERT INTO pwg_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","I kayowana da Yesu iti sisiya bero na ita paniya. ");
INSERT INTO pwg_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Nani maranai koroto ghamanakina ivi kiiriyeriyeyana da wawaya ivivi kiipasipasiyana. Ma Yesu sisiya ivi karei, kana kivikivina kava ivonesi bo, “Perisi damsi na miiriruwaruwasi ma viviberosi. Kokitaruvimi da nani yist na ke ina damana kurimi. ");
INSERT INTO pwg_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Ma mara sago wawaya i bera gavugavusi kudubina na God ini debei ma bade ina berai da aviyavisina kudubina guduguduna na ina votawei. ");
INSERT INTO pwg_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Aviyavisina didibarai koisisiyei na madeghai God sisiyisi ini debei da wawaya peyarisi ini yanei. Ma aviyavisina numa kamonai wawaya tinisiyai koisisiyakarakaravei na tuna matarai sisiyisi peyarina ina rukaghei.” ");
INSERT INTO pwg_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Turaturaku, avonavonemi da iyavo kava ina kiivunumi na ke kona yabumanesi. Ina kiivunumi ma murinai ke kovokovoghina da aviyavisina berona ina berai kurimi. ");
INSERT INTO pwg_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Ma ani beyemi da meni wawayina kota yabumanei. Tuna na God ma ina rewapana emakamakai da ina kiivunumi ma rabobo murinai ku keyama karakaratina ina tawemi. Vonavaghata, tuna wawayina kota yabumanei.” ");
INSERT INTO pwg_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Aririta miikovi kota gimari na miiyanisi igisi kirakai. Ma kegha da God na aririta sago kava ke ini notawapei. ");
INSERT INTO pwg_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Vonavaghata, God uyawim peyarina ivi yavi ikovi, iakovi da viya. Ke kona yabumana, tami God kurina miiyanimi irakata kirakai ma enotanotimi. God ku matana aririta peyarina koghekuyowesi.” ");
INSERT INTO pwg_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Avonavonemi, wawaya kurisi koni debei da tami na aku wawaya ma taku Wawaya Natusi nakanani ana berai kubiimi, God ina aneya maghinosiyai ani debei da tami na aku wawaya. ");
INSERT INTO pwg_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Ma kona vonaveyiyeku na God ina aneya maghinosiyai bade ana vonaveyiyemi.” ");
INSERT INTO pwg_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Wawaya ini avaberoweku na kovokovoghina da God i berabero ina notatawei. Ma Kanuma Vovokaravina ini avaberowei na God ke ina notatawei.” ");
INSERT INTO pwg_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Wawaya ina patumimi ma ina rutinimi da kiki numasi kamonai ma kwanatu babadisi ma kiikiivavo maghinosiyai kona miiri da ini tupavireviremi. Ma ke koni nuwapoya da ikikava kona vonapotesi bo kami papara kona vowai, ");
INSERT INTO pwg_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","iyamna nani marasiyai Kanuma Vovokaravina ini beyemi da ikikava koni sisiya.” ");
INSERT INTO pwg_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Tomowa sago koroto kamonai Yesu ivonei bo, “Bada, aku tuwa kevonei da akii mamai ina buderi nevanevana ina vereku.” ");
INSERT INTO pwg_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Ma Yesu ivonapotei bo, “Aku tomo, ke sago iyai rewapana ita vereku da ami mamai buderina ata rereghi.” ");
INSERT INTO pwg_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Ma peyarisi ivonesi bo, “Kokitaruvimi da ke kona vomatamatighana kirakai. Ami mura ma ami sawara ina rakata na yawasa vaghata ke ina veremi.” ");
INSERT INTO pwg_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Ma weni miibiina ivonesi bo, “Mura tomowina sago iyaba da iti maghara ");
INSERT INTO pwg_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","ma ina vavai irakata. Ma ivi nuwanotanota bo, ‘Avi ana berai? Numa kweta ke ruvaruvana.’ ");
INSERT INTO pwg_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Muriyai ivona bo, ‘Agunai weni nakanani ana berai. Aku numa kweta gisigisisi ana rika ma ghamaghamasi ana vowa da aku maghara ma aku sawara ana vovidaburana bubuna. ");
INSERT INTO pwg_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Ma ana vona bo, “Taku vaghina, aku mura irakata da mara gurina ana kam, anuma ma ani nuwabiibai.” ’ ");
INSERT INTO pwg_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Ma God nani tomowina ina vonei bo, ‘Tam neghanegham. Weni didibarinai am yawasa ana viitawei da kuna rabobo. Ma aviyavisina kudubina kuvovidaburi ma kuvivi maghari na iyi ini rapenei?’” ");
INSERT INTO pwg_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Ma bade ivonesi bo, “Iyavo kava enotanota meyesi ma dobu ina sawara ina vovidaburana na ikikava itupuwa nani mura tomowina kurina na nakanani ina tupuwa kurisi. God ita notanotai ma kanumisi ina mura ita vovidaburana na kegha.” ");
INSERT INTO pwg_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Muriyai Yesu kana kivikivina ivonesi bo, “Tuna kubiine avonavonemi da ami yawasa dobuwai na ke koni nuwapoyei da aviyavisina kona kani ma aviyavisina kona kotei. ");
INSERT INTO pwg_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Ami yawasa na ke kam kava kubiine ma tupuwimi na ke gara kava kubiine. ");
INSERT INTO pwg_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Oghogha kokitisi. Ke ita wayowayowa ma ke ita vivimaghara. Ma God ikanikanisi. Ma tami na ekayokayowana kirakiiyemi, ke kiu nakanani. ");
INSERT INTO pwg_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Ma nuwapoya notasi ke ini vitemi da ami yawasa gisi vaghina ini gurini. ");
INSERT INTO pwg_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Ma bade ke ini vitemi da bera gisi korekorena ina tupuwa. Tuna kubiine avi kubiine bera peyarina koinuwapoyei? ");
INSERT INTO pwg_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Saru kokitai, dipiiyai egogogo wapawapa. Ke ita vovobagibagi ma kii gara ke ita popopo ma kitasi ibiibii kirakai da Kiivavo Soromon kana gara biibii kirakiina ighekuyowei. ");
INSERT INTO pwg_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Inamona na karako egogogo ma maram wawaya ina kapuni ma kegha da God ikotevunaghisi. Inamona ikotevunaghisi ma tami iyavo kava ami vitumaghana igisi na bade ini kotevunaghimi.” ");
INSERT INTO pwg_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","“Kam ma uma ke kona nota kirakiiyei ma ke koni nuwapoyei. ");
INSERT INTO pwg_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Iyavo kava God ke ita vivitumaghanei na kam ma uma inuwapoyei ma ekwekwa kirakiiyei. Ma tami na ami Mamai namada iakovi da aviyavisina kokayokayowei. ");
INSERT INTO pwg_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","God ina vikiivavona konekwai na bade ku tepana ami kayowana dobuwai ina vokiibuwei.” ");
INSERT INTO pwg_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Tami aku sipu yavona na ke kona yabumana, iyamna ami Mamai inuwabiibai da ina ku vikiivavona korui ma rewapana evereveremi da yavata koni kiivavo patapata. ");
INSERT INTO pwg_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Ami mura kovi gimara ma mane na moyamoyakisi kona veresi. Ami kutu ku kamona na kunuma kana mura konuwani, ke dobu kana mura. Kunuma kana mura na ke ina ravuwa, ke meyani da ina kovi, yapiyapisi ke ina kavari, ma kaniketekete ke ina kani. ");
INSERT INTO pwg_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Meni dobunai ami mura kovovovidaburana na bade nuwanuwami na nani dobunai.” ");
INSERT INTO pwg_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Ami rampa kokapuna ma kokitaruvai da mara nonowa ina karakarata. Ma bade kovi gara, kovovunagha meyemi da biga kubiine. ");
INSERT INTO pwg_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Koberai da tami nakanani ma bigabiga wawayisi ita vivikoyakoyagha da i bada kamporaghai ina vovira ku numa. Kurisi ina nekiibau ma ina kiipowapowara na yaghiyaghinai matuketa ina votawei. ");
INSERT INTO pwg_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Ina kitisi da ebanebanenega na ini nuwabiibii kirakiiyesi. Vonavaghata avonavonemi, nani badana ina tereoruwe meyei da bigabiga kana gara ina kotei ma ina vonesi da ina makai ma ina kam ma tuna mani ina koyaghisi. ");
INSERT INTO pwg_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Vona bubuna da i bada didibarai ina vovira ku numa ma ina pananisi da patana da ebanebanenega na ini nuwabiibai. Namanaki kokorereko kana viruwa bo viarobina kamonai ina nekiibau kurisi ma kegha da matasi ina kitakita na ini nuwabiibii kirakiiyesi. ");
INSERT INTO pwg_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Ma sago ana vonemi, weni tuna damina kovii bubuni. Mikeda numa badana itakovi da avi maranai yapiyapi wawayina ita pisi na ina numa iti tarapaparanei da yapiyapina ke ita gavovori. ");
INSERT INTO pwg_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Tami bade nakanani kona vovunagha ma kona banebanenega. Mara sago kona notanotai da Wawaya Natusi ke ita pipisi ma nani kamonai ina nekiibau.” ");
INSERT INTO pwg_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Pita ivona bo, “Bada, weni miibiina na tokai kava kubiikai bo wawaya peyarina kubiisi?” ");
INSERT INTO pwg_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Ma Bada Yesu ivonapotei bo, “Numa badana bigabiga sago patupatutuna ma nuwanuwagiurina ina vinei da bigabiga peyarisi kii koyakoyagha. Ma rewapana ina verei da ini badesi ma kii miiya ma kii vavai ina rerereghi. ");
INSERT INTO pwg_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Numa badana ina vovira ma ina kitai da ekoyakoyagha bubunisi na ini nuwabiibiiyei. ");
INSERT INTO pwg_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Vonavaghata avonavonemi, rewapana ghamana ku tepana ina verei da aviyavisina kudubina rapenai na ku imana ina terei da ina koyaghi. ");
INSERT INTO pwg_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Ma mikeda bigabiga kii koyakoyagha ita vona bo, ‘Aku bada inae ma mara gurina murinai ina vovira,’ na iti karei da bigabiga wivinesi ma tomotomowisi ita widiwidi kirakiiyesi, ita guraguramodi ma itumuma neghanegha. ");
INSERT INTO pwg_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Mara sago nani berasi ina beraberai na ina bada ina nekiibau da ini tataghani. Ma kovogha ghamana ina verei ma ina kwavini da iyavo kava ke ita votekateka na ku kamosi ina rui da yavata ina makai.” ");
INSERT INTO pwg_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Meni bagibagi wawayina iakovi da avi bigana kava ina bada ekayokayowei da ina berai ma ke ita vovovunagha ma ke ita votekateka na kovogha ghamana ina viiya, kana widi ina peyari kirakai. ");
INSERT INTO pwg_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Ma meni bagibagi wawayina ke itakova bubuna da aviyavisina kava ina bada ekayokayowei, ma ina bera beroi na kana widi ke ita peyari. Tami iyavo kava puyo ghamaghamasi God gwabinai koviiya na ekayokayowei da kona vere meyemi da biga ghamaghamasi kona berai. Ma bade tam iyai da God itumaghanem ma bera peyarisi ku imam iterei da kuna koyaghi na ekayokayowei da nani vitana ghamana kuna kavara bubuni.” ");
INSERT INTO pwg_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Apisi ku dobu na keyama karakaratina akavarapiyei, ma aku kayowana da namada ita karata bubuna. ");
INSERT INTO pwg_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Ma kunona babataito sago damina ana viiya ma ere nuwapoyiku aikoyakoyagha da tuna berana ina kovi. ");
INSERT INTO pwg_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Konotanotai da apisi ku dobu da makiinuwapota ina tupuwa, bo? Kegha, avonavonemi da apisi na kubiiku vimakiibogebogeyana ina tupuwa. ");
INSERT INTO pwg_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Karako weni marana ma nake na rakaraka kamonai wawaya miikovi na ini makiibogebogesi da wawaya aroba ivi ruwa ini kawapatesi bo wawaya ruwa ivi aroba ini kawapatesi. ");
INSERT INTO pwg_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Wawaya ini kiitawetaweyana da mamai natuna tomowina ini ghaviyei ma bade natuna ina mamai ini ghaviyei. Maduwa natuna wavinena yavata ini ruwa ma bade natuna wavinena ina vomiiri da ina maduwa yavata ini ruwa. Ma kwabura rawana wavinena ini kawapatei, ma bade rawana wavinena ina vomiiri da kwabura ini kawapatei.” ");
INSERT INTO pwg_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Yesu koroto ivonesi bo, “Kwavu dumadumasi kona kitai da dipiiyai ighegheyana na kokayokayovona bo, ‘Garewa ina katuna,’ na kovonavona bubuna, nakanani ina tupuwa. ");
INSERT INTO pwg_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ma damina koviiviiya da yavara everaverau na kokayokayovona bo, ‘Madegha ina muyamuya kirakai,’ na kovonavona bubuna, nakanani ina tupuwa. ");
INSERT INTO pwg_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Tami miiriruwaruwami, iyamna dobu ma kunuma kokitakitai na akova koviiviiya da aviyavisina ina tupuwa. Ma avi kubiine karako aviyavisina etuputupuwa na damina ke kota viiviiya?” ");
INSERT INTO pwg_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Avi kubiine ke kota vivitarapiri meyemi da meni berana na maninina? ");
INSERT INTO pwg_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Wawaya yavata koni kawapata ma kona vomiiri da vitupavira badana kurina da ami vikawapata iti maniniya, na kobera tovoni da ketiyai tami mani ami piropiro koni maniniya. Ke koni maniniya na kam ghaviya ina tinakwarokwarom vitupavira badana kurina. Ma tuna ina vonakiiyaragha da kubera beroi ma seri wawayina ku imana ina terem. Ma tuna ina rutinim da ku gabura ina terem. ");
INSERT INTO pwg_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Avonavonemi da gabura kamonai kuna makii kirakai da kam kovogha kudubina kuni miiya yavui.” ");
INSERT INTO pwg_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Wawaya viya Yesu ivonei bo, “Pailat ina seri wawayisi inae da Gariri damsi viya ivi kiivunuwana maranai i ghamoghamo suwarisi ivovovunagha da ita kapuna. Ma wawayisi tarasi na ghamoghamosi tarasi yavata ivi sagoi.” ");
INSERT INTO pwg_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Ma Yesu ivonapotesi bo, “Weni nakanani irabobo kubiine na konotanotai da nani Gariri damsi na i berabero irakata, ke nakanani ma Gariri damsi viya, bo? ");
INSERT INTO pwg_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Avonavonemi da kegha! Ma tami na ami berabero ke koninimayei ma ke kona miirikupukuputei na peyarimi bade ami yawasa koni wapai. ");
INSERT INTO pwg_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Ma nani wawayisi ivi 18 Jerusalem kamonai irabobo maranai Silowam numana ipeku ku tepasi na konotanotai da ti i berabero irakata kirakai, ke nakanani ma wawaya viya Jerusalem kamonai, bo? ");
INSERT INTO pwg_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Avonavonemi da kegha! Ma tami na ami bera beroberosi ke koninimayei ma ke kona miirikupukuputei na peyarimi bade ami yawasa koni wapai.” ");
INSERT INTO pwg_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Ma Yesu weni miibiina ivonesi. “Tomowa sago ina vao kamonai koweya ivoni. Ma inae da koweya amena itekwai ma ke sago ita panani. ");
INSERT INTO pwg_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Ma ina vao kana koyakoyagha ivonei bo, ‘Taku madegha aroba avi veruvira wike da weni kiina arurupoti ma amena aekwekwa kavai. Ketaratawei! Avi kubiine tano muina kava eviviiya?’ ");
INSERT INTO pwg_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Ma vao kana koyakoyagha ivonapotei bo, ‘Bada, tavoterei da madegha sago ina miiri. Ma nani kamonai kiina ana koyagha bubuni, kunukununa ririnai ana koini ma mugu ana tawei da ramramna muina ina viiya. ");
INSERT INTO pwg_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Ma maram madeghinai iname boni na ibiibai. Ma kegha, na tataratawei.’” ");
INSERT INTO pwg_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Viyakam marana sago kiki numana kamonai Yesu ivivi beyebeyena. ");
INSERT INTO pwg_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Ma wavine sago nani kamonai, kanuma berona gwabinai iberai da madegha 18 igubaga, kuputuwana itinarukumi da ke kovokovoghina ita miirimanini. ");
INSERT INTO pwg_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Ma Yesu wavinena ikitai na ikwatui da koroto ku maghinosi ita pisi. Ma ivonei bo, “Wavine, avovotawem, karako weni gubagina ekiikiibutawem.” ");
INSERT INTO pwg_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Imana ku tepana iterei na yaghiyaghina wavinena kuputuwana ivi kiimaniniyei da God ivi ghegheni. ");
INSERT INTO pwg_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Ma kiki numana badana nuwanuwana ipughu da Yesu viyakam maranai wavinena ivi yawasi. Tuna kubiine koroto kiki numana kamonai ivonesi bo, “Mara miikovimasago kamonai na biga taberaberai. Nani marasiyai kona pisi da kona bunama. Ma ke viyakam maranai kona pisi.” ");
INSERT INTO pwg_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Ma Bada Yesu ivonapotei bo, “Tami miiriruwaruwami! Viyakam maranai peyarimi sago sago duma ami ghamoghamo uravisi kona rupama ma i numa kamonai kona rutinakiibuwesi ku okowa da inuma. ");
INSERT INTO pwg_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Weni wavinena na Abraham tupurereghina ma tuna Seitan ikutatani da madegha 18 ikovi. Kade aviyavisina ikutani na viyakam maranai kata rupami, bo kegha?” ");
INSERT INTO pwg_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Yesu weni nakanani ivi sisiya na iyavo kava ivivi kawapatei na ivinimaya. Ma wawaya peyarisi ivi nuwabiibai da bera ghamaghamasi ipeyari iberaberai. ");
INSERT INTO pwg_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Muriyai Yesu ivona tovonisi bo, “God ina vikiivavona na ikikava? Aviyavisina kurina ana vonagubai? ");
INSERT INTO pwg_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Tuna nakanani ma tomowa kiiroko peina iviiya da ina vao kamonai ivoni. Peina igogo da ivi kiidagima da kiu bogii ma bogiiyai ragharaghanai itowatowei.” ");
INSERT INTO pwg_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Ma Yesu ivona tovona meyesi bo, “God ina vikiivavona na aviyavisina kurina ana tere tovoni? ");
INSERT INTO pwg_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Tuna na nakanani ma yist. Wavine yist gisina iviiya ma parawa ghamana kamonai iterei ma ivoviravirai. Ma yist na parawa inunui da kapawina irakata.” ");
INSERT INTO pwg_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Yesu ivomiiri ku Jerusalem na keta borinai kwanatu ma meyagai kamosiyai ivivi beyebeyena. ");
INSERT INTO pwg_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Ma wawaya sago ivi tarakiiyanei bo, “Bada, wawaya ke peyarina yawasa makamakii nonowina ina panani, bo?” Ma ivonapotesi bo, ");
INSERT INTO pwg_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Kovi paparana da ku matuketa gisina kona rui, iyamna wawaya ipeyari ina bera tovoni da ina rui ma kara ke kovokovoghina. ");
INSERT INTO pwg_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Marana ina pisi da numa badana ina vomiiri da matuketa ina gudui. Ma matarai kona miiri ma kona kiikiipowapowara ma kona vivinowi kurina bo, ‘Bada, matuketa kevotawei kubiikai.’ Ma numa badana ina vonemi bo, ‘Ke atakovimi! Mimei kovi piyana?’ ");
INSERT INTO pwg_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Ma kona vonapotei bo, ‘Rorova takam ma tuma patapata ma akii meyagiyai kuvivi beyebeyena.’ ");
INSERT INTO pwg_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Ma numa badana ina vona meyemi bo, ‘Ke atakovimi. Mimei kovi piyana? Abaremi, konetaweyana. Peyarimi na berabero wawayimi!’ ");
INSERT INTO pwg_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Tuna maranai koni tutuwana ma okemi koni tarakikitei iyamna tami na kupunai, ma Abraham, Aisiki, Jeikap ma peroperoveta peyarisi kona kitisi da ti na God ina vikiivavona kamonai. ");
INSERT INTO pwg_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Ma dobu matatupina ruwamaruwa kamosiyai wawaya ina riyesi ma kamporagha kubiine ina makiivipika God ina vikiivavona kamonai. ");
INSERT INTO pwg_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Vonavaghata da wawaya viya karako imuri na nani maranai ini nao, ma wawaya viya karako inao na nani maranai ini muri.” ");
INSERT INTO pwg_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Nani maranai Perisi damsi viya ipisi Yesu kurina ma ivonei bo, “Weni dobuna kekiibutawei kenae iyamna Kiivavo Herodi ina kayowana da ina kiivunum.” ");
INSERT INTO pwg_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Ma ivonapotesi bo, “Konae da nani kukou dipa kovonei bo, ‘Karako ma maram na kanuma beroberosi ana kwavinisi ma wawaya gubagubagisi ani yawasisi, ma mara viarobina kamonai na aku biga ani kovini.’ ");
INSERT INTO pwg_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Vonavaghata da karako, maram ma mara kana viaroba na biga ke ana voterei, aku kayowanai ana nenae. Ma bade vona bubuna da peroperoveta na ke Jerusalem kupunai ita raborabobo.” ");
INSERT INTO pwg_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“O, Jerusalem, Jerusalem! Tami peroperoveta kovi kiivunuwana. Ma iyavo kava God ivonatawesi kurimi na wakimiyai koravisi da kovi rabobosi. Mara ipeyari akayokayowei da ikikava kokoreko wavinena mapemapena gaburinai natunatuna ekiikiividabudaburana da kii papara ita vowai na nakanani Jerusalem dami kubiimi ata berai. Ma tami kobara. ");
INSERT INTO pwg_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Damina kota viiya da God ivoteremi da ami numa kwebuna. Avonavonemi da ke kona kita meyeku ina nenae da mara sago kuriku kona vona bo, ‘God ini biibiinim, tam Bada avanai kepipisi!’” ");
INSERT INTO pwg_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Viyakam marana sago Yesu inae da Perisi damsi i bada ina numiiyai ita kam. Ma Perisi damsi viya ivivi matatete bubuni da ita kitai, vonaviyoyovana iti kiigiiyei bo kegha. ");
INSERT INTO pwg_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Ma tomowa sago ipisi Yesu ku maghinona, tomowina na tupuwina gwarugwaruna. ");
INSERT INTO pwg_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Ma Yesu vonaviyoyovana vibeyebeyena wawayisi ma Perisi damsi ivi tarakiiyanesi bo, “Vonaviyoyovana kamonai ivi vaghinei da viyakam maranai wawaya tiyawasi bo kegha?” ");
INSERT INTO pwg_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Ma peyarisi ivi kawapotapota. Vaghina ma Yesu tomowina ivotovoni da ivi yawai ma ivonatawei inae. ");
INSERT INTO pwg_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Ma ivonesi bo, “Viyakam maranai natum bo am ghamoghamo ita peku ku dogo kamona na kuta kitakuyowei bo yaghiyaghinai kuta tinepai?” ");
INSERT INTO pwg_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Ma ke sago ikikava ita vonapotei. ");
INSERT INTO pwg_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Yesu ikitai da kam kubiine na wawaya gawara biibiisi ivinevinei da ita makai na weni miibiina ivi isisiyei. ");
INSERT INTO pwg_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Iyi tam tavine kamna kubiine kam sisiya kuviiya ma kuna pisi na ke wawaya ghamaghamasi kii gawarai kuna makai. Mikeda wawaya sago kana vava irakata da ighekuyowem kana sisiya iviiya da ina pisi ");
INSERT INTO pwg_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","na kam badana ina vonem bo, ‘Kevomiiri ma ita tomowa weni gawarina ina viiya.’ Ma tam kuninimaya da wawayota kurisi kuna nae da kamosiyai kuna makai. ");
INSERT INTO pwg_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Ma weni nakanani kuta berai. Tavine kamna badana kam sisiya ita vonatawei da kuta pisi na wawayota kamosiyai kuta makai. Ma badana ita pisi da ita vonem bo, ‘Kwinaku, keghae ku gawara biibiina.’ Ma vaghina, wawaya maghinosiyai ita rutinim wawaya ghamaghamasi i ku gawara da kam vava ita rakata. ");
INSERT INTO pwg_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Iyavo kava ekayokayotata ma ekayokayowei da ini wawayaghama na God ina tereoruwesi. Ma iyavo kava eteretereoruwe meyesi na God ina terepisi da ini wawayaghama.” ");
INSERT INTO pwg_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Ma Yesu, Perisi damsi i bada kurina ivona bo, “Kam ghamana kuna berai na ke varevaresim, am rakaraka, damturam bo mura wawayisi kii sisiya kuna vonatawei da ina pisi, iyamna am agabiibai ina kovoghi. Karakava kam sisiya ina vonatawei da gwabisiyai kuna kam. Nakanani ina berai kurim na tam namada kam miiya kuviiya. ");
INSERT INTO pwg_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Tuna kubiine kam ghamana kuna berai na wawaya moyamoyakisi, digadigasi, gibegibesisi ma matapotapotasi kii sisiya kevonatawei da ina pisi. ");
INSERT INTO pwg_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Ti wawayisi na ke kovokovoghina da am agabiibai ina kovoghi, tuna kubiine God ini biibiinim. Ma maranai ina wawaya maninisi rabobowai ina vomiiri na kam miiya God gwabinai kuna viiya.” ");
INSERT INTO pwg_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Ma tomowa sago Yesu yavata ikamkam ma ina sisiya ivivi yanei. Ma ivonei bo, “Iyavo kava God ina vikiivavona kamonai ina kamkamporagha na ini nuwabiibii kirakai.” ");
INSERT INTO pwg_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Ma Yesu ivonapotei bo, “Tomowa sago ivovunagha da kam ghamanakina ita berai ma wawaya peyarisi ikwatusi da ita pisi. ");
INSERT INTO pwg_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Kam kana mara inekiibau na ina bigabiga ivonatawei da iyavo kava ikwatusi na ivonesi bo, ‘Kopisi ma takam, bera peyarina namada avovunagha ikovi.’ ");
INSERT INTO pwg_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Ma peyarisi ivi karei da ivonavonavurana. Wawaya sago ivona bo, ‘Taku aku dowa wekarakava agimari, tuna kubiine anenae da ana kitai. Tuna kubiine ainowi da kuna votereku.’ ");
INSERT INTO pwg_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Ma sago ivona bo, ‘Taku aku ox imaruwa wekarakava agimari. Anenae da ana bera tovonisi da uwata sawarina ina tina bubuni bo kegha. Tuna kubiine ainowi da kuna votereku.’ ");
INSERT INTO pwg_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Ma bade sago ivona bo, ‘Taku wekarakava atavine, tuna kubiine ke kovokovoghina da ana pisi.’ ");
INSERT INTO pwg_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Bigabiga ivovira ina bada kurina da weni sisiyisi ivi mamatarei. Ma ina bada nuwanuwana ipughu da ivonapotei bo, ‘Kenae, yaghiyaghinai kekiibau ku kwanatu da ketiyai wawaya moyamoyakisi, digadigasi, gibegibesisi ma matapotapotasi kuna rutinapiyesi.’ ");
INSERT INTO pwg_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Ina bigabiga ivovira ma ivona bo, ‘Bada, aviyavisina kuvoneku na aberai da wawayisi ipisi, ma gawara ke ita tupo.’ ");
INSERT INTO pwg_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Ma badana ivonei bo, ‘Kenae, kwanatu kekiibutawei da dipiiyai ma dobu rabarabai wawaya ketiyai kunekwisi da ina pisi ma aku numa ini tupoi. ");
INSERT INTO pwg_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Avonavonem da iyavo kava kunona akwatusi ma ibara na ke sago aviyavisina ina kuta tovoni weni kamna kamonai.’” ");
INSERT INTO pwg_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Koroto ghamana Yesu yavata ibaba inenae na imiiritavire da ivonesi bo, ");
INSERT INTO pwg_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Meni wawayina nota ina viiya da ita kiviniku na ina kayowana kirakiiyeku da ke nakanani ma ina mamai, ina maduwa, kawana ma natunatuna, varevaresina, novunovuna ma bade tuna mani ina yawasa. Ke ina kayowana kirakiiyeku na ke kovokovoghina da ina kiviniku. ");
INSERT INTO pwg_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ma bade meni wawayina kana korosi ke ita kavari da murikuwai ita pisi na ke kovokovoghina da ina kiviniku. ");
INSERT INTO pwg_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Mikeda wawaya sago weni korotona kamonai am kayowana da numa ghamana kuta vowai na kunona kuta makai ma am mane kuta ruvai da kovokovoghina da numa kana sawara kudubina kuta gimara yavui bo kegha. ");
INSERT INTO pwg_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Numa vowana kuti karei ma borinai am mane ita kovi na ke kovokovoghina da numa kuni kovini. Ma wawaya peyarisi ina kitai ma ina vonavinamem. ");
INSERT INTO pwg_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Ina vona bo, ‘Nani wawayina numa vowana ivi karei ma ke kovokovoghina da iti koviya.’ ");
INSERT INTO pwg_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Bo mikeda kiivavo ita nae da kiivavo sago yavata iti ghaviya na kunona ini nuwanotanota da ina seri wawayisi 10 tausan na kovokovoghina da kana ghaviya ina seri wawayisi 20 tausan ina miiripotesi bo kegha. ");
INSERT INTO pwg_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Ma sisiya ini yanei da kana ghavighaviya ina seri wawayisi namada ivomiiri epipisi na ina yonayona ina vonatawesi ini nao. Ma dobu rabarabai ina verupotesi ma ini nowi kurisi da keta inekwai da nuwanuba kamosiyai ita makai, iyamna ke kovokovoghina da ita miiripotesi. ");
INSERT INTO pwg_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Ma bade nakanani, iyi tam ke kuni vaghinei da am bera ma am yawasa kudubina ku imaku kuna terei, tam na ke kaku kivikivina.” ");
INSERT INTO pwg_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Yegai na biibiina. Ma mikeda yegai damina ina wapa na kara ke kovokovoghina da damina ina vovira. ");
INSERT INTO pwg_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Ma mikeda yegai damina kegha na tuna iyamna kegha. Tuna kubiine ke vao kamonai kuna tepotawei da dowa muina ini rakati. Kegha, tuna na berona, ketawei. Wawaya ere tinimi na aku sisiya kovi yana bogai.” ");
INSERT INTO pwg_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Mara sago teks yuyuna wawayisi ma berabero wawayisi Yesu imiiriviviri da ina sisiya iti yanei. ");
INSERT INTO pwg_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Ma Perisi damsi ma vonaviyoyovana vibeyebeyena wawayisi ivonavonakunukunura bo, “Weni tomowina berabero wawayisi i kiikiiwesi ma yavata ekamkam.” ");
INSERT INTO pwg_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Ma Yesu weni miibiina ivi sisiyei kurisi. Ivona bo, ");
INSERT INTO pwg_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Mikeda am sipu ivi 100 ma sago ita wapa na kade ivi 99 gawara yagharinai kuna kuyowesi da wapawapana kunekwai bo? ");
INSERT INTO pwg_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Ma kunekwai da kuna panani na kade ere nuwabiibiim ku katagheyam kuna tawanepai ");
INSERT INTO pwg_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","da kuna nae ku numa bo? Muriyai turaturam ma am rakaraka kuna kwaturiyariyesi ma kuna vonesi bo, ‘Tinuwabiibii kirakai, iyamna aku sipu iwapa ma apanani.’ ");
INSERT INTO pwg_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Avonavonemi da wawaya sago kava ina berabero ininimayei ma ina miirikupukuputei na kunumai nuwabiibai ina rakata kirakai, da ke wawaya maninisi ivi 99 i berabero kegha inuwabiibiiyesi nakanani.” ");
INSERT INTO pwg_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Ma miiba sago na wavine ina mane na silva riririghisi imaruwa, ma sago ina wapa na avi ina berai? Kade rampa ini nawai da numa ina rughirighiriya ma inekwai da ina panani bo? ");
INSERT INTO pwg_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Ma ina panani na wivine turaturana ina kwaturiyariyesi ma ina vonesi bo, ‘Tinuwabiibii kirakai iyamna aku mane sago iwapa na apanana meyei.’ ");
INSERT INTO pwg_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Avonavonemi da wawaya sago kava ina berabero ininimayei ma ina miirikupukuputei na kunumai God ina aneya ini nuwabiibii kirakiiyei.” ");
INSERT INTO pwg_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Yesu ina sisiya ikwapanatini, ivona bo, “Tomowa sago natunatuna tomotomowa ivi ruwa. ");
INSERT INTO pwg_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Ma murimurina ina mamai ivonei bo, ‘Mamai, buderim na kaku reregha da kevereku.’ Vaghina ma i mamai na aviyavisina kudubina rapenai na ivorereghi natunatuna kurisi. ");
INSERT INTO pwg_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Ke mara gurina ma murimurina ina sawara peyarina ivi gimarei da mane iviiya ma ivomiiri da ku dobu rabaraba. Ma nani dobunai berabero yawasina kamonai imakamakai da ina mane peyarina ivi rekwe wapawapai da ivi koviya. ");
INSERT INTO pwg_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Ivi koviya ma muriyai gomara itupuwa da nani dobuna kudubina ikamowana yavui. Gomara irakata kirakai ma yaragina mara nonowa vitonara ikarakarai. ");
INSERT INTO pwg_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Ma inae da biga iekwai ma wadubo wawayina gwabinai biga ipanani ma ivonatawei da ina poro iti kanisi. ");
INSERT INTO pwg_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Ere vitonarina poro ivivi kanisi ma ina kayowana ghamana da poro kii vavai ita kani ma ke kovokovoghina. Ma ke sago wawaya iti kamyuyuwei da vavai ita verei. ");
INSERT INTO pwg_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Ma nani kamonai nota iviiya. ‘Aku mamai ina bigabiga wawayisi kii vavai na ghamana, ma taku weni dobunai vitonara ekarakaravunuku. ");
INSERT INTO pwg_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Ibiibii kirakai da ana vovira aku mamai kurina, ma ana vonei bo, “Mamai, taku berabero aberai God kurina ma tam kurim. ");
INSERT INTO pwg_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Taku ke wawaya kiimataniku da kuna voneku bo, natuku. Tuna kubiine keviiniku da am bigabiga kamosiyai ana makai ma kubiim ana vobagibagi.” ’ ");
INSERT INTO pwg_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Vaghina ma yaragina ivomiiri inae ina mamai kurina.” “Karakava ita nekiibau ku numa ma ina mamai namada ikitataweyana da natuna ipipisi na ikitai. Ma ivi nuwapoya kirakai da natuna iverupotei, itaraghavui ma iyoni. ");
INSERT INTO pwg_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Ma yaragina ina mamai ivonei bo, ‘Mamai, taku berabero aberai God kurina ma tam kurim. Taku ke wawaya kiimataniku da kuna voneku bo, natuku.’ ");
INSERT INTO pwg_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Ma kegha, ina mamai bigabiga kurisi ivona bo, ‘Kovi yaghiyaghina! Gara biibii kirakiina kokavarapiyei ma natuku kovi kotei. Rini ku imadigedigena kovi runi ma kana kaeterepapara ku kaena kovi kotei. ");
INSERT INTO pwg_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Ma kau natuna dodona korutinapiyei ma kokiivunui. Peyarita takamporagha ma tinuwabiibai, ");
INSERT INTO pwg_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","iyamna natuku na irabobo ma iyawasa, tuna iwapa ma ivovira.’ Ma vaghina, kamporagha ivi karei.” ");
INSERT INTO pwg_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Peyarisi ivivi nuwabiibai na kamonai natuna tutuwaghina dipiiyai ikiibau. Ipipisi numa ku ririna na ivi yanei da wawaya enava iraravi ma ivivi rikuwana. ");
INSERT INTO pwg_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Ma bigabiga sago ikwatui ma ivi tarakiiyanei bo, ‘Aviyavisina etuputupuwa?’ ");
INSERT INTO pwg_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Ma ivonapotei bo, ‘Tim kikei ivovira ma tuna na yawayawasina, tuna kubiine am mamai kau natuna dodona ivowai.’ ");
INSERT INTO pwg_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Ma tutuwaghina nuwanuwana ipughu kirakai da ke ita rui. Tuna kubiine ina mamai ikiibau kurina da ita rutinaruwei. ");
INSERT INTO pwg_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Ma ibara ma ina mamai kurina ivona bo, ‘Kevi yana, weni marana gurigurina kubiim avovobagibagi kirakai ma ke meyani da am sisiya ata vonabarei. Ma ke avi biibiina kuta vereku da turaturaku yavata kata kam ma kati nuwabiibai, ke gote gubuna kava kuta vowai kubiiku. ");
INSERT INTO pwg_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Ma weni natum na am buderi kudubina ivi rekwe wapawapai na keta wivinesi igimagimaresi. Ma karako ivovira kurim na avi kubiine kana kau dodona kuvowai?’ ");
INSERT INTO pwg_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Ma ina mamai ivona bo, ‘Natuku, tam ma taku na weni marana gurigurina yavata tamakamakai, ma aku sawara kudubina namada averem da rapemuwai. ");
INSERT INTO pwg_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Ma tim kikei irabobo ma iyawasa, iwapa ma ivovira. Tuna kubiine bera biibiina taberai da yavata takamporagha ma tinuwabiibai.’” ");
INSERT INTO pwg_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Yesu kana kivikivina miibiiyai ivonesi bo, “Mura wawayina sago ina bigabiga ivinei da ina mane ma ina sawara kudubina ita koyaghi. Ma mara sago mura wawayina sisiya ivi yanei da bigabiga bera wapawapa iberaberai da ina mane ivivi rekwei. ");
INSERT INTO pwg_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Tuna kubiine ikwatui ma ivonei bo, ‘Sisiyim avi yanei da aviyavisina rapekuwai na ke kuta koyakoyagha bubuni. Ikikava kukoyaghi ma aviyavisina peyarina kuberai na kuni mamatareku da akovina ana viiya, iyamna gwabikuwai kubiga ikovi ma kuna nae.’ ");
INSERT INTO pwg_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Ma bigabiga tuna mani ivona meyei bo, ‘Aviyavisina ana berai? Aku bada weni bagibagina kamonai eviiviitaweku. Taku ke kovokovoghiku da ana wayowa, ma bade ainimaya da vinowi tepanai ana makai. ");
INSERT INTO pwg_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Akovi aviyavisina ana berai da maranai aku bagibagi ani wapai na turaturaku ina peyari ma ina koyagha bubuniku.’ ");
INSERT INTO pwg_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Vaghina ma, iyavo kava kii tupi ina bada gwabinai imakamakai na ikwatusi ipisi. Wawaya sago ikwatui ma ivonei bo, ‘Tam aku bada gwabinai kam tupi na aviyavisina kava?’ ");
INSERT INTO pwg_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Ivonapotei bo, ‘Taku na 3 tausan litas oliv oira am bada gwabinai aviiya.’ Ma bigabiga ivonei bo, ‘Am pepa weni, keviiya ma wekarakava girumina kevirai da kam tupi na 1 tausan 5 handred litas kava.’ ");
INSERT INTO pwg_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Ma wawaya kana viruwa ikwatui ma ivonei bo, ‘Tam kam tupi na viya?’ Ma ivonapotei bo, ‘Taku na 20 tausan kilos whiti aviiya.’ Ma bigabiga ivonei bo, ‘Am pepa weni, keviiya ma girumina kevirai da kam tupi na 16 tausan kilos kava.’ ");
INSERT INTO pwg_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Ma vaghina, aviyavisina nani bigabigana iberai na ina bada sisiyina ivi yanei ma ivi ghegheni iyamna tuna na yapiyapina ma viviberona ma kegha da ina nuwagiura irakata kirakai.” Ma Yesu ina sisiya ikwapanatini. Ivona bo, “Vonavaghata da iyavo kava dobu yawasina kamonai emakamakai na iakova kirakai da ikikava ini bero da turaturasi ini nuwabiibiinisi. Ma iyavo kava yasegana kamonai emakamakai na neghaneghasi, ke itakovi.” ");
INSERT INTO pwg_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","“Avonavonemi da dobu kana mura ke ina makii nonowa. Tuna kubiine kovorereghi da turaturami ina peyari. Nakanani kona berai da karakava kunumai wawaya peyarisi ini kiikiiwemi. ");
INSERT INTO pwg_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Iyavo kava bera gisina ina koyagha bubuni na kovokovoghina da titumaghanei da bade bera ghamana ina koyagha bubuni. Ma iyavo kava aviyavisina gisina gwabisiyai na ke ina koyagha bubuni na takovi da bade ghamana ke ina koyagha bubuni. ");
INSERT INTO pwg_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Iyi tam dobu kana mura ke kuta koyakoyagha bubuni na avi kubiine God mura makamakii nonowina ina verem? ");
INSERT INTO pwg_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Mura kudubina na God rapenai. Ma iyi tam dobu kana mura gisina iverem da kuta koyagha bubuni ma kuvi rekwei na God ke ini tumaghanem da mura vaghata ina verem da rapemuwai.” ");
INSERT INTO pwg_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Bigabiga wawayina ke kovokovoghina da babada ruwa kubiisi ina biga bubuna. Mikeda ina babada ruwa na bada sago ina barei ma sago nuwanuwana ina viiya. Bo sago kurina ini patutu ma sago ina miirikupukuputei. Ke kovokovoghina da ami babada ruwa, sago God ma sago mane.” ");
INSERT INTO pwg_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Ma Perisi damsi, ti na mane nuwanuwasi iviivii kirakiiyei. Tuna kubiine Yesu ina vibeyebeyena ivi yanei na ivonavonavinamei. ");
INSERT INTO pwg_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Ma tuna ivonesi bo, “Wawaya matasiyai koberaberai da tami nakanani ma wawaya biibiimi, ma God iakovi da nuwanuwami ikikava. Aviyavisina wawaya dobuwai enotanotai da bera ghamana na God kurina iyamna kegha.” ");
INSERT INTO pwg_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Moses ina vonaviyoyovana ma peroperoveta aviyavisina igirugirumi na tanununuri da Jon Babataito ina ku mara. Nani maranai ivi karei da ku karako na wawaya God ina vikiivavona edimadimei ma wawaya peyarisi ipaparana da ina rui. ");
INSERT INTO pwg_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Ikikava ibagibagi kirakai da dobu ma kunuma ita wapa na bade nakanani ke kovokovoghina da giruma gisi korekorena Moses ina vonaviyoyovana kamonai kata kiipupuni da ita wapa.” ");
INSERT INTO pwg_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Meni tomowina kawana ina barei ma muriyai wavine sago ina ravaghi na ipekana wapawapa ma tuna na berabero God ku matana. Ma bade meni wawayina kawana yavata ini kiitawetaweyana ma muriyai wavinena na tomowa sago ina ravaghi na ivi ruwa ipekana wapawapa, tuna bade na berabero God ku matana.” ");
INSERT INTO pwg_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Mura tomowina sago mara nonowa kana gara biibii kirakiisi ivivi kote, ikamkam bubuna ma ina kayowana kudubina rapenai. ");
INSERT INTO pwg_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Ma tomowa moyamoyakina ma ininina gubagubagina kana vava Lasaras. Tuna na mara nonowa mura tomowina ina matuketa ririnai ikenakena ma ivivi nowi wawaya kurisi. ");
INSERT INTO pwg_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Ma vitonara ikara kirakiiyei da ina kayowana da kamririgha mura wawayina ina kema gaburinai ita kani ma ke kovokovoghina. Ma kukou ivivi piyana da kana gubaga inemonemoi. ");
INSERT INTO pwg_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Mara sago Lasaras irabobo ma aneya ipisi da kanumina iviiya ineyei ku kunuma da Abraham yavata imakamakai. Ma bade mura wawayina irabobo ma wawaya tupuwina idogoi, ");
INSERT INTO pwg_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","ma kanumina na ku keyama karata makamakiina inae. Ma nani dobunai inivisi ghamana ipanani da ivovokwarakwara. Ma ita tepa da nokomanaki Abraham ikitai, tuna na Lasaras yavata imakamakai. ");
INSERT INTO pwg_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Ma ivi kwatu bo, ‘Mamai Abraham, kevi kamyuyuweku na Lasaras kevonatawei da imarakorakona ku okowa ina tupakutuvi ma pepaku ini nubanubai. Taku weni keyama karakaratinai ininiku ivisivisiyana.’ ");
INSERT INTO pwg_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Ma Abraham ivonapotei bo, ‘Natuku, kevi nuwanotanota da am yawasa dobuwai na biibiina, am kayowana kudubina rapemuwai. Ma Lasaras na ke sago biibiina rapenai. Ma karako na tuna inuwabiibai ma tam na inivisiyai kemakamakai. ");
INSERT INTO pwg_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ma sago na kawanagha ghamanakina emakamakai tam ma tokai kamoputiyai. Meni wawayina wimei ina kayowana da kurim ita damana na ke kovokovoghina. Ma bade wawaya namei ke kovokovoghina da kurikai ina damana.’ ");
INSERT INTO pwg_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Ma mura tomowina ivonapotei bo, ‘Mamai Abraham, ainowi kurim da Lasaras kevonatawei aku mamai ina ku numa. ");
INSERT INTO pwg_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Nani dobunai varevaresiku miikovi emakamakai ma aku kayowana da Lasaras ina vonaviakovisi da ina kitaruvisi da i rabobo murinai na ke weni ku inivisi dobuna ina pisi.’ ");
INSERT INTO pwg_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Ma Abraham ivonapotei bo, ‘Moses ma peroperoveta namada ivonaviakovisi da ita kitaruvisi. Aviyavisina ti damsi igiruma na namada varevaresim gwabisiyai ma kovokovoghina da ini yavi.’ ");
INSERT INTO pwg_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Ma mura tomowina ivona bo, ‘Kegha, mamai Abraham, ti na kara ke ini yava tovoni. Ma wawaya sago kuna vonatawei da rabobowai ina vovira kurisi na i berabero ina miirikupukuputei.’ ");
INSERT INTO pwg_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Ma Abraham ivona bo, ‘Moses ma peroperoveta i sisiya ke ini yanei na karakava wawaya rabobowai ina vomiiri na bade tuna ina sisiya ke ini yanei.’” ");
INSERT INTO pwg_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yesu kana kivikivina ivonesi bo, “Vonavaghata da wawaya i yawasa kamonai ruyagha ina panani da berabero ina berai. Ma meni wawayina kwinana ini nowe beroi da ruyagha ina panani da berabero ina berai na tuna iti nuwapoya kirakai, iyamna kovogha God gwabinai ina viiya. ");
INSERT INTO pwg_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Ita biibii kirakai da wakima ghamana iwanai ita kuni ma ku bogapu ita tawanoruwei da kara ke kovokovoghina da wawaya ina ruyaghisi, iyavo kava ti nakanani ma ededa yoghoyogho na ruyagha ke ina veresi da berabero ina berai. ");
INSERT INTO pwg_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Tuna kubiine kokitaruvimi.” “Varesim bera berona ina berai na keyeghai. Ma mikeda ininimaya ma ina berabero ina miirikupukuputei na tam na ina berabero kenotatawei. ");
INSERT INTO pwg_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Mikeda mara miikovimaruwa mara sago kamonai bera beroberosi kurim ina berai ma mara miikovimaruwa ina pisi kurim ma ina vonem da ina bera beroberosi inimayei ma ina miirikupukuputei na bade tam na mara miikovimaruwa ina berabero kenotatawei.” ");
INSERT INTO pwg_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Ma aposol Bada Yesu kurina ivona bo, “Akii vitumaghana kevi rakati.” ");
INSERT INTO pwg_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Ma ivonapotesi bo, “Mikeda ami vitumaghana gisi vaghina ita makai nakanani ma pei gisi korekorena ma weni kiina kota vonei bo, ‘Ketinaragu meyem ma kedamana ku yegai da kamonai kuna gogo,’ na vonavaghata, ina votekatekemi.” ");
INSERT INTO pwg_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Mikeda bada sago ina bigabiga wawayina ituwuwata bo sipu ita koyakoyaghi ma muriyai ita vovira ku numa na ina bada ke ita vonei bo, ‘Kepisi, kuna makai ma takam.’ Kegha, ");
INSERT INTO pwg_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","ita vonei bo, ‘Kaku vavai kevi tavi, kam gara biibiina kekotei ma kekoyaghiku da ana kam ma anuma. Ma muriyai tam kuna kam ma kunuma.’ ");
INSERT INTO pwg_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Ma bigabiga wawayina ina bada ina kayowana peyarina ina berai na ke ini kiikiiwei. ");
INSERT INTO pwg_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Bade tami nakanani, maranai Bada biga ina veremi ma koni kovini, kona vona bo, ‘Tokii na bigabiga, akii biga kava kaberaberai.’” ");
INSERT INTO pwg_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Mara sago Yesu inenae ku Jerusalem. Ma Sameriya da Gariri i viparaparatai ibababa. ");
INSERT INTO pwg_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Ku meyagai sago irurui na tomotomowa imaruwa gubagubagisi ipipisi kurina. Kii gubaga na giipo, tuna kubiine nokomanaki ma ivi kiimiiriyesi. ");
INSERT INTO pwg_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Ma gamotepasiyai ikiirara. “Yesu! Bada! Kevi kamyuyuwekai!” ");
INSERT INTO pwg_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Yesu ikitisi, ma ivonesi bo, “Konae da taparoro babada kurisi koni beye meyemi da koyawasa.” Ma ivivi neyana da keta borinai na iyawasamakai. ");
INSERT INTO pwg_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Kwinasi sago, maranai ikitai da iyawasa, ivovovira ma gamotepanai God kana vava ivovokavakavari. ");
INSERT INTO pwg_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Ma ipisi da Yesu maghinonai itawotei ma ivi kiikiiwei. Tuna na Sameriya wawaya. ");
INSERT INTO pwg_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Ma Yesu ivona bo, “Vonavaghata da wawaya imaruwa avi yawasisi. Ma ivi 9 na imapatana? ");
INSERT INTO pwg_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Weni tomowina na dobu viruwa wawayina, ma ina kina kava ivovira. Avi kubiine peyarisi ke ita vovira da God ita vokavakavari?” ");
INSERT INTO pwg_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Ma Yesu tomowina ivonei bo, “Kevomiiri ma kuna nae, am vitumaghana kubiine kuyawasa.” ");
INSERT INTO pwg_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Mara sago Perisi damsi Yesu ivi tarakiiyanei da avi maranai God ina vikiivavona ina nekiibau. Ma Yesu ivonapotesi bo, “God ina vikiivavona ina nekiibau na damina kona viiya, ma ke matamiyai kona kitai. ");
INSERT INTO pwg_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Ma wawaya ke kovokovoghina da ina vona bo, ‘Weni we,’ bo ‘Nokoniko!’ iyamna God ina vikiivavona namada nuwanuwami kamonai.” ");
INSERT INTO pwg_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Yesu kana kivikivina ivonesi bo, “Mara epipisi da ami vokwarakwara kamonai ami kayowana ghamana da Wawaya Natusi kota kitai. Ma kegha, ke kona kitai. ");
INSERT INTO pwg_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Wawaya ina vonemi bo, ‘Weni we,’ bo ‘Nokoniko!’ Ma ke koni tumaghanesi da kona kiibau da konekwai. ");
INSERT INTO pwg_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Maranai Wawaya Natusi ina nekiibau na nakanani ma namanamara ita vovokadari da dobu kudubina ita yasegani. ");
INSERT INTO pwg_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Ma kunona Wawaya Natusi ina kiivikamaghiyei ma weni kimtina ina barei. ");
INSERT INTO pwg_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Aviyavisina itupuwa Nowa ina mariyai, na bade nakanani ina tupuwa Wawaya Natusi ina mariyai. ");
INSERT INTO pwg_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Maranai Nowa ina ku waka igeru na wawaya ikamkam, iumuma, wivine ma tomotomowa itatavine. Ma kutukutuva ighae da peyarisi irukwa. ");
INSERT INTO pwg_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Bade berana sago Lot ina mariyai itupuwa. Wawaya ikamkam ma iumuma, igimagimara ma ivivi gimara, iwayowayowa ma inumanumavowa. ");
INSERT INTO pwg_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Ma maranai Lot, Sodom kwanatuna ikiibutawei, sulpa wakimisi karakaratisi kunumai ioru da wawaya peyarisi ikaragavogavovorisi. ");
INSERT INTO pwg_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Ma bade nakanani, wawaya dobu yawasina ina vivinuwabiibiiyei ma nani kamonai Wawaya Natusi ina rudeba da wawaya matasiyai ina kitai.” ");
INSERT INTO pwg_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Nani maranai wawaya matarai ke ina rui numa ku kamona da ina sawara ina yuna. Bade nakanani wawaya ina wayowayowa na ke ina vovira ku numa da aviyavisina ina viiya. ");
INSERT INTO pwg_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Ikikava itupuwa Lot kawana kurina na kota notai. ");
INSERT INTO pwg_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Wawaya iyai ina yawasa ina nuwaghanei na ini wapai, ma iyai ina yawasa ina nuwatawei na yawasa makamakii nonowina ina panani. ");
INSERT INTO pwg_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Avonavonemi, nani didibarinai wawaya ivi ruwa gawara sago ina kenakena na God sago ina viitawei ina ghae ma sago ina makai. ");
INSERT INTO pwg_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Wivine ivi ruwa whiti ina yaghayagha na sago ina viitawei ina ghae ma sago ina makai.” ");
INSERT INTO pwg_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","(-) ");
INSERT INTO pwg_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Ma kana kivikivina ivi tarakiiyanei bo, “Bada, weni berasi na imapatana ina tupuwa?” Ma Yesu miibiiyai ivonapotesi bo, “Oghogha kona kitisi da ini kiidaburana na konakovi da bowabowa nani dobunai.” ");
INSERT INTO pwg_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Muriyai Yesu miiba sago kana kivikivina kurisi iterei, ivi beyebeyena da mara nonowa ita niponipowana ma ke meyani i nota ina peku. ");
INSERT INTO pwg_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Ivona bo, “Kwanatu sago kamonai vitupavira badana sago imakamakai, tuna na God ke ita vovokaravei ma bade wawaya ke ita vivikamyuyuwesi. ");
INSERT INTO pwg_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Ma kwapura sago nani kwanatunai imakamakai ma mara nonowa ipipisi kurina ma ivivi nowi bo, ‘Kevi viteku. Wawaya sago yavata kavi kayotakurana na kuni maniniya.’ ");
INSERT INTO pwg_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Namadani kava vinowi ivi karei ma vitupavira badana ibara, ke ina kayowana da iti vitei. Ma turinai na ivona bo, ‘God ke ata vovokaravei ma wawaya ke ata vivikamyuyuwesi, ");
INSERT INTO pwg_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","ma namanaki, weni kwapurina mara nonowa inibariku. Tuna kubiine ani vitei da nani wawayina yavata ivi kayotakurana na ani tupaviresi da berana ani maniniya. Mikeda kwapurina ke ani vitei na ina kayovinibara kirakiiyeku!’” ");
INSERT INTO pwg_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Ma Bada Yesu ivona bo, “Weni vitupavira badana na ke maninina ma ina sisiya kovi yanei na kovi nuwanotanotei. ");
INSERT INTO pwg_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Ma God na maninina, ma ina wawaya vovinesi i tou kurina madeghai ma didibarai etereterei na iyanesi ma bera maninina eberaberai kubiisi. Ma ke meyani da ita vonavonesi da karakava. ");
INSERT INTO pwg_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Avonavonemi da yaghiyaghinai ini vitesi ma i nuwapoya ina tupavimaniniya. Ma Wawaya Natusi ina nekiibau ku dobu na kadeni da dobu kamonai vitumaghana damsi ina makamakai ina pananisi bo kegha?” ");
INSERT INTO pwg_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Wawaya viya enotanota meyesi, da God ku matana ti na maninisi da wawaya viya ekitakitaoruwesi. Tuna kubiine Yesu weni miibiina ivi sisiyei kurisi. ");
INSERT INTO pwg_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Tomotomowa ruwa inae ku Taparoro Numana, nipowana kubiine. Sago na Perisi tomowina ma kana viruwa na teks yuyuna tomowina. ");
INSERT INTO pwg_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Ma Perisi tomowina imiiri ma ina nipowana kamonai tuna mani ivi gheghena meyei. Ivona bo, ‘God aikiikiiwem da taku vaghina, ke wawaya viya nakanani. Ti na yapiyapisi, berabero wawayisi ma vipekana wapawapa wawayisi. Ma bade taku ke nokoni teks yuyuna tomowina nakanani. ");
INSERT INTO pwg_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Taku taparoro nununai aisiya da mara ruwa ma aku miiya aviiviiya na aku verena ruvanai atereterei.’ ");
INSERT INTO pwg_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Ma teks yuyuna tomowina imiiritaweyana. Idune ma ere nuwapoyina nuwakadana iravi ma ivona bo, ‘God, kevi kamyuyuweku, taku berabero wawayiku.’” ");
INSERT INTO pwg_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Ma Yesu ivona bo, “Avonavonemi da God weni tomowina ina bera beroberosi peyarina inotatawei da nuwanuwana yagharina ma ikiibau inae ina ku numa, ke nakanani ma Perisi tomowina. Iyavo kava ekayokayotata ma enotanotai da ighe kirakai na God ina tereoruwesi. Ma iyavo kava ina tereoruwe meyesi na God ina terepisi.” ");
INSERT INTO pwg_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Mara sago wawaya ededa yoghoyogho gisigisisi irutinapiyesi Yesu kurina da ita votovonisi ma iti biibiinisi. Ma kana kivikivina ikitisi na iyeghisi. ");
INSERT INTO pwg_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Ma Yesu ededa yoghoyogho ikwaturiyariyesi ma ivona bo, “Ke kona tarapaparisi, kovoteresi da ina pisi kuriku. Wawaya weni ededa yoghoyoghosi nakanani na God ina vikiivavona rapesiyai. ");
INSERT INTO pwg_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Vonavaghata avonavonemi, iyi tam kekayokayowei da God ina vikiivavona ku kamona kuna rui na kebera meyem da tam weni ededisi nakanani. Ke kuna berai na ke meyani kuna rui.” ");
INSERT INTO pwg_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Jiu damsi i bada sago ipisi ma Yesu ivi tarakiiyanei bo, “Bada biibiim, aviyavisina ana berai da yawasa makamakii nonowina ana viiya?” ");
INSERT INTO pwg_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Ma Yesu ivonei bo, “Avi kubiine kuvoneku da taku biibiiku? Ke sago wawaya biibiina da God ina kina kava. ");
INSERT INTO pwg_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Tam sisiya bagibagisi vonaviyoyovana kamonai kuakovi. ‘Ke kuni pekana wapawapa, ke kuna kiivunuwa, ke kuna yapi, ke kuni mamatara bero, ma am mamai da am maduwa kevopepetisi.’” ");
INSERT INTO pwg_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Ma tomowina ivonapotei bo, “Bada, gisikuwai avi karei ma patana da weni sisiyisi bagibagisi peyarina avovotekatekei.” ");
INSERT INTO pwg_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Ma Yesu weni sisiyina ivi yanei na ivona bo, “Bera sago kava emakamakai da kuta berai. Am sawara kudubina kevi gimarei ma mane na wawaya moyamoyakisi kuna veresi da mura makamakii nonowina kunumai kuna viiya. Muriyai kepisi da kuna kiviniku.” ");
INSERT INTO pwg_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Ma tomowina weni sisiyina ivi yanei na ivi nuwapoya kirakai, iyamna tuna na mura wawayina. ");
INSERT INTO pwg_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Yesu ikitai da tomowina ivi nuwapoya na ivona bo, “Ipiropiro da mura wawayisi God ina ku vikiivavona ina rui. ");
INSERT INTO pwg_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Vonavaghata, ipiropiro da kamel unubu ku bonaghina ita susura ma bade ipiropiro kirakai da mura wawayina ita rui God ina vikiivavona ku kamona.” ");
INSERT INTO pwg_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Iyavo kava weni sisiyina ivi yanei na ivi tarakiiyanei bo, “Nakanani na iyavo kava yawasa makamakii nonowina ina panani?” ");
INSERT INTO pwg_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Ma Yesu ivonapotesi bo, “Aviyavisina ipiropiro kirakai da wawaya ke kovokovoghina da ina berai na God kurina itekateka kirakai.” ");
INSERT INTO pwg_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Ma Pita ivona bo, “Ma tokai, na ikikava? Akii bera kudubina kavi verukuyowana da kakivikivinim.” ");
INSERT INTO pwg_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Ma Yesu ivonesi bo, “Vonavaghata avonavonemi, wawaya iyai God ina vikiivavona kubiine ina numa, ina rakaraka, kawana, varevaresina, ina mamai da ina maduwa bo natunatuna ina kuyowesi ");
INSERT INTO pwg_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","na aviyavisina peyarina ikuyokuyowei na weni yawasina kamonai God ini teparari ma ku tepana ina vere kirakiiyei. Ma bade kunumai yawasa makamakii nonowina ina panani.” ");
INSERT INTO pwg_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Yesu kana kivikivina ivi 12 itinavivirisi ku ririna ma ivonesi bo, “Tagheghae ku Jerusalem na aviyavisina peroperoveta igirugirumi Wawaya Natusi kubiine na ina tupuwa. ");
INSERT INTO pwg_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Ina paniya ma kupuna damsi ku imasi ina terei da ini namei, ini avaberowei, ina kanukanui, ina widiya ma ini raboboi. ");
INSERT INTO pwg_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Ma mara viarobina kamonai rabobowai ina vomiiri.” ");
INSERT INTO pwg_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Ma aviyavisina ivivi sisiyei na kana kivikivina damisi ke ita viiviiya. Sisiyina iyamna vaghata na gavugavuna, tuna kubiine ke itakovi. ");
INSERT INTO pwg_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Yesu kana kivikivina yavata ku Jeriko kwanatuna inenekiibau na tomowa matapotapotana keta baranai imakamakai da mane kubiine ivivi nowi. ");
INSERT INTO pwg_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Ma ivi yana da koroto ghamana ibaba ipipisi na ivi tarakiiyana da aviyavisina ituputupuwa. ");
INSERT INTO pwg_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Wawaya ivonei bo, “Yesu, Nasaret tomowa, epipisi.” ");
INSERT INTO pwg_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Ma ivi kwatu bo, “Yesu, tam David Tupurereghina, kevi kamyuyuweku!” ");
INSERT INTO pwg_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Ma wawaya viya ivi nao na iyeghai. Ivonei da kawana ita pota ma kegha, tuna ighekiirara bo, “David Tupurereghina, kevi kamyuyuweku!” ");
INSERT INTO pwg_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Ma Yesu ivi kiimiiriyei ma ivonesi da tomowina ita rutinapiyei kurina. Ipisi na Yesu ivona bo, ");
INSERT INTO pwg_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Aviyavisina kekayokayowei da ana berai kubiim?” Ma ivonapotei bo, “Bada, aku kayowana da ata kita.” ");
INSERT INTO pwg_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Ma Yesu ivona bo, “Kekita. Kuvi tumaghana kubiine kuyawasa.” ");
INSERT INTO pwg_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Yaghiyaghinai ikitabanenega ma ivi karei da God ivovokavakavari ma Yesu ikivikivini. Ma koroto ghamana weni berana ikitai na ti yavata God ivovokavakavari. ");
INSERT INTO pwg_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Yesu irui ku Jeriko kwanatuna ma kamonai ibaba inenae. ");
INSERT INTO pwg_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Ma nani kwanatunai na mura tomowina sago kana vava Zakiyas, tuna na teks yuyuna wawayisi i bada ghamana. ");
INSERT INTO pwg_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Ina kayowana da Yesu maghighina ita kitai, ma tuna itupo kirakai da ke kovokovoghina, iyamna koroto ghamana imiirirogurogui. ");
INSERT INTO pwg_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Tuna kubiine ivi nao, iveru inae da kii sago igheni da Yesu nani ketanai ipipisi na ita kitai. ");
INSERT INTO pwg_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Ma Yesu ipisi nani ku gawarina na itepa ma ivona bo, “Zakiyas, yaghiyaghinai keoru. Taku karako am numiiyai ana makiivipika.” ");
INSERT INTO pwg_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Yaghiyaghinai ioru ma ere nuwabiibiina Yesu ivi kiikiiwei ma irutinaneyei ina ku numa. ");
INSERT INTO pwg_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Ma wawaya peyarisi ikitai ma ivonavonakunukunura bo, “Yesu inae da berabero wawayina kana numataya.” ");
INSERT INTO pwg_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Ma Zakiyas ivomiiri ma ivona bo, “Bada, kevi yaneku! Aku mura nevanevana wawaya moyamoyakisi ana veresi. Ma mikeda wawaya avi beroberowesi da i mane gisina ayapiya na ana vere meyesi, ma ruwamaruwa ku tepana ana terei.” ");
INSERT INTO pwg_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Ma Yesu ivonapotei bo, “Karako wawaya weni numana kamonai yawasa makamakii nonowina ipanani, iyamna weni tomowina ivi tumaghana kubiine, tuna na Abraham tupurereghina vaghata. ");
INSERT INTO pwg_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Taku Wawaya Natusi apisi da wawaya siwasiwanisi atekwisi da ati yawasisi.” ");
INSERT INTO pwg_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Wawaya Yesu ivivi yanei na ina sisiya ikwapanatini. Ku Jerusalem inenekiibau, ma wawaya inotanotai da gisina kava God ina vikiivavona ita tupuwa. Tuna kubiine miiba sago kurisi ivi sisiyei. ");
INSERT INTO pwg_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Ivona bo, “Mara sago tomowa ghamana imakamakai da sisiya iviiya da ita numataya ku dobu rabaraba ma nani dobunai rewapana ita viiya da tuna mani ina dobuwai iti kiivavo. Ma muriyai ita vovira ina ku dobu. ");
INSERT INTO pwg_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Muriyai da ita nae na ina bigabiga imaruwa ikwatusi ma ina gold mane irereghisi da sago sago duma mane sago kava iviiya. Ma ivonesi bo, ‘Taku ana nae ma weni manena avereveremi na kotura da biga ina beraberai, ma kamonai viya kona panani kubiiku. Ma karakava ana vovira.’ Ma tomowina ivomiiri inae. ");
INSERT INTO pwg_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Ma ina dobu wawayisi na i babara tomowina. Tuna kubiine yonayona murinai ivonatawesi inae da kiivavo ghamana kurina ma ivonei bo, ‘Tokai ke kata kayokayowei da nani tomowina rewapana kuna verei da kubiikai ini kiivavo.’” ");
INSERT INTO pwg_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Ma kegha da tomowina ivi kiivavo ma ivovira. Ma ina bigabiga wawayisi ikwaturiyariyesi da itakovi da mane iveresi na ku tepana viya ipanani. ");
INSERT INTO pwg_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Nona wawayina ipisi na ivona bo, ‘Bada, gold mane sago kuvereku na ku tepana imaruwa apanani.’ ");
INSERT INTO pwg_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Ma ina bada ivonapotei bo, ‘Kubera bubuni, tam aku bigabiga biibiim. Kuvi patutu da bera gisina ma kubera bubuni. Tuna kubiine kwanatu imaruwa ana verem da kuni badei.’ ");
INSERT INTO pwg_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Ma bigabiga viruwina ipisi ma ivonei bo, ‘Bada, taku gold mane sago kuvereku na ku tepana miikovi apanani.’ ");
INSERT INTO pwg_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Ma ina bada ivonei bo, ‘Vaghina, tam kwanatu miikovi kuni badei.’” ");
INSERT INTO pwg_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Ma ina bigabiga sago ipisi ma ivonei bo, ‘Bada, am gold mane na weni, gara sinasinaminai akupotai ma ateregavui. ");
INSERT INTO pwg_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Tam wawaya bagibagim sago, tuna kubiine ayabumanem. Aviyavisina ke tam rapemuwai ma kegha da keviiviiya. Aviyavisina ke tam kuta vovoni ma kegha da keyabayaba.’ ");
INSERT INTO pwg_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Ma ina bada ivonapotei bo, ‘Tam bigabiga berom! Tam mani am sisiya ikikava kutereterei na nakanani ani wavum! Kuakoviku da wawaya bagibagiku sago. Aviyavisina ke rapekuwai ma kegha da aviiviiya, ma aviyavisina ke ata vovoni ma kegha da ayabayaba. ");
INSERT INTO pwg_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Avi kubiine aku gold manena averem na ke kuta terei da biga ita berai? Maranai avovira na gisina kava ku tepana yavata ata viiya.’” ");
INSERT INTO pwg_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“Ma wawaya ririnai ivivi miiriyana na ivonesi bo, ‘Nani gold manena gwabinai koviitawei ma bigabiga wawayina ina gold mane imaruwa gwabinai na tuna koverei.’ ");
INSERT INTO pwg_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Ma wawayisi ivonapotei bo, ‘Bada, tuna namada gold manena imaruwa gwabinai.’ ");
INSERT INTO pwg_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Ma badana ivonapotesi bo, ‘Avonavonemi da wawaya sago sago duma aviyavisina gwabisiyai ekoyakoyagha bubuni na bade God ku tepana ina terei. Ma wawaya aviyavisina gwabisiyai ke ita koyagha bubuni na God kudubina ina viitawei.’ ");
INSERT INTO pwg_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Ma iyavo kava ighaviyeku ma ke ita kayokayowei da ati kiivavo na korutinapiyesi wike ma maghinokuwai koni kiivunuwana.” ");
INSERT INTO pwg_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Yesu ivi sisiya ikovi ma ivi nao, kana kivikivina yavata inenae ku Jerusalem. ");
INSERT INTO pwg_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Namada inenekiibau ku Betipadi ma Betani kwanatusi, Oliv koyana baranai na kana kivikivina ruwa ivonatawesi da iti nao. Ivonesi bo, ");
INSERT INTO pwg_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“Konae, da nokoni kwanatuna maghinotai, ma kona rurui na donki votuna kona kitai, iwarimi ma emiimiiri. Ke meyani wawaya ita geru tovoni. Korupami ma korutinapiyei wike. ");
INSERT INTO pwg_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Mikeda wawaya ini tarakiiyanemi da avi kubiine koruparupami na kovonei da Bada ekayokayowei.” ");
INSERT INTO pwg_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Ivi ruwa inae da Yesu ikikava ivonavonesi na nakanani ipanani. ");
INSERT INTO pwg_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Ma donki uravina iruparupami na babadisi ivonesi bo, “Avi kubiine koruparupami?” ");
INSERT INTO pwg_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Ma ivonapotesi bo, “Bada ekayokayowei.” ");
INSERT INTO pwg_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Ma irutini inae da Yesu kurina. Kii tarasovo donki ku tepana ivi tawanepeyana ma Yesu igeru. ");
INSERT INTO pwg_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Ivomiiri inenae ma wawaya kii tarasovo ivi votaweyana ma ketiyai ikepana da Yesu tepanai ibababa. ");
INSERT INTO pwg_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Oliv koyanai iororu na kana kivikivina peyarisi nuwabiibiiyai God ivivi kiikiiwei, gamotepasiyai ivovokavakavari, iyamna bera ghamaghamasi Yesu iberai na matasiyai ikitai. Ivonavona bo, ");
INSERT INTO pwg_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","“Tam Bada avanai kepipisi, Akii kiivavo, God ini biibiinim, Kunumai nuwanuba ina makai, Ma God kiidamo makamakiina tavokavakavari ma tighegheni da kana kadara ina rakata!” ");
INSERT INTO pwg_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Koroto kamosiyai Perisi damsi viya Yesu ivonei bo, “Bada, kam kivikivina keyeghisi da kawasi ina pota!” ");
INSERT INTO pwg_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Ma ivonapotesi bo, “Avonavonemi, mikeda ti kawasi ita pota na wakima iti karei da iti kiirareyana.” ");
INSERT INTO pwg_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Yesu ipipisi Jerusalem ku ririna da kwanatuna ikitai na ivi nuwapoyei da ituwei. ");
INSERT INTO pwg_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Ma ivona bo, “Tami, kotakovi da aviyavisina karako kota berai da kota makiinuwapota ma kegha, namada vonavaghata igavui da ke konakovi. ");
INSERT INTO pwg_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Ma marana ina pisi da kami ghavighaviya ina nekiibau na ina garikunimi da ke meni taraboginai kona verau. ");
INSERT INTO pwg_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Ma ami kwanatu garina ini turikarikai ma natunatum yavata ini tugudagudimi. Ma ke sago wakima kana gawariyai ina makai. God ipisi kurimi da iti yawasimi ma tami kobarei, tuna kubiine weni nuwapoyisi kona panani.” ");
INSERT INTO pwg_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Muriyai Yesu irui Taparoro Numana garina ku kamona ma vigimagimara wawayisi ikwavinisi. ");
INSERT INTO pwg_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Ma ivonesi bo, “Giruma katamana kamonai evonavona bo, ‘Aku numa na nipowana numana.’ Ma tami koberai da yapiyapi damsi i numa.” ");
INSERT INTO pwg_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Nani murinai Yesu mara nonowa Taparoro Numana garina kamonai ivivi beyebeyena. Ma taparoro babadisi i babada, vonaviyoyovana vibeyebeyena wawayisi ma Jiu damsi i babada i kayowana ghamana da ita kiivunui. ");
INSERT INTO pwg_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Ma keta ke ita panani da ita berai, iyamna wawaya peyarisi ikayokayowei da ina sisiya kudubina iti yanei. ");
INSERT INTO pwg_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Mara sago Yesu Taparoro Numana garina kamonai wawaya ivivi beyebeyesi ma God varana biibiina idimadimei. Ma taparoro babadisi i babada, vonaviyoyovana vibeyebeyena wawayisi ma Jiu damsi i babada ipisi kurina, ");
INSERT INTO pwg_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","da ivi tarakiiyanei bo, “Kevonekai, am rewapana imapatana kuviiya da weni berasi keberaberai? Iyai weni rewapanina iverem?” ");
INSERT INTO pwg_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Ma ivonapotesi bo, “Taku bade ani tarakiiyanemi. Kovoneku, ");
INSERT INTO pwg_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Jon ina rewapana imapatana iviiya da ibabataito? God gwabinai bo wawaya gwabisiyai?” ");
INSERT INTO pwg_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Ma wawayisi ivi karei da ti mani kamosiyai ivivi sisiya bo, “Ikikava tavonapotei? Mikeda tavona bo, ‘God gwabinai,’ na ina voneta bo, ‘Ma avi kubiine da Jon ke koti tumaghanei?’ ");
INSERT INTO pwg_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Ma mikeda tavona bo, ‘Wawaya gwabisiyai,’ na weni korotona kudubina wakimiyai ina ravita da ini rabobota, iyamna ti namada ivi tumaghana da Jon na God ina peroveta.” ");
INSERT INTO pwg_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Tuna kubiine wawayisi ivonapotei bo, “Ke katakovi da imapatana iviiya.” ");
INSERT INTO pwg_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Ma Yesu ivonesi bo, “Nakanani na bade ke ana vonemi da imapatana aku rewapana aviiya da weni berasi aberaberai.” ");
INSERT INTO pwg_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Yesu miibiiyai ivi sisiya wawaya kurisi. Ivona bo, “Mara sago tomowa sago greipi ivoni ina vao kamonai ma vao na wawaya ku imasi iterei da ita koyaghi. Ma tuna inumataya ku dobu sago da imakii kirakai. ");
INSERT INTO pwg_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Greipi imenai da pura kana mara na vao badana ina bigabiga ivonatawei da kana reregha ita viiya. Ma koyakoyagha wawayisi ivomiiri da bigabigana iravi ma imana kwebuna kava ivonatawei ivovira. ");
INSERT INTO pwg_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Muriyai bigabiga kana viruwa ivonatawei. Ma bade tuna iravi ma iyeghaberoberoi ma imana kwebuna kava ivonatawei ivovira. ");
INSERT INTO pwg_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Ma bigabiga kana viaroba ivonatawei ma koyakoyagha wawayisi tuna bade iravi da ivi sidari ma gari ku kupuna itawanakiibuwei. ");
INSERT INTO pwg_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Vaghina ma, vao badana ivona bo, ‘Aviyavisina ana berai? Natuku, tuna nuwanuwaku ana vonatawei na mikeda ina vokaravei.’ ");
INSERT INTO pwg_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Koyakoyagha wawayisi natuna ikitai na ivi ogatara. Ivona bo, ‘Wena vao badana natuna. Takiivunui ma tano buderina tirapenei.’ ");
INSERT INTO pwg_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Vaghina ma, vao kamonai itawanakiibuwei da kupunai ikiivunui.” Ma Yesu ivi tarakiiyanesi bo, “Vao badana na aviyavisina ina berai koyakoyagha wawayisi kurisi? ");
INSERT INTO pwg_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Ina pisi da nani wawayisi ini kiivunuwana ma vao na dam viruwa ina veresi da ina koyaghi.” Koroto ghamana weni sisiyina ivi yanei na ivona bo, “Kara ke kovokovoghina da nakanani ina tupuwa!” ");
INSERT INTO pwg_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Ma Yesu ikitatupesi ma ivi tarakiiyanesi bo, “Giruma katamana weni nakanani evonavona na iyamna koakovi bo kegha? Ivona bo, ‘Vonura damsi wakima ibarei, Ma Bada nani wakimina iviiya ma iterei da tepanai numa vuna ivowai.’ ");
INSERT INTO pwg_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Meni wawayina ina peku wakimina ku tepana na ini kiigiigiiyei. Bo wakimina meni wawayina ku tepana ina peku na wawayina ina kiigudagudai.” ");
INSERT INTO pwg_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Vonaviyoyovana vibeyebeyena wawayisi ma taparoro babadisi i babada iakovi da Yesu miibiiyai ivivi avaberowesi. Tuna kubiine i kayowana da yaghiyaghinai ita patumi ma koroto ghamana iyabumanesi da ke kovokovoghina. ");
INSERT INTO pwg_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Tuna kubiine taraboga iekwai na wawaya viya ivonatawesi kurina, iti bero da nakanani ma wawaya maninisi. Iti kaetina da maranai Yesu iti sisiya bero na iti wavui ma Pailat ku imana ita terei, tuna tomowina Rome damsi ivinei da Judiya dobuna ivivi badei. ");
INSERT INTO pwg_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Ma vibero wawayisi ipisi Yesu kurina ma ivona bo, “Bada, kakovi da tam ke kuta vivimiiriruwaruwa ma am sisiya na maninina. Ke wawaya sago ku murina kuta miimiiri ma sago na kegha, tuna kubiine vonavaghata kava kibeyebeyena da God ina keta kidebei. ");
INSERT INTO pwg_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Ma, kivaghinei da teks kani miiyei Kiivavo Sisa kurina bo kegha?” ");
INSERT INTO pwg_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Ma Yesu iakovi da wawayisi ivivi kaetina na ivona bo, ");
INSERT INTO pwg_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Mane sago kovereku ana kitai.” Ikitai ma ivona bo, “Wena iyi maghighina, ma iyi kana vava?” Ma ivonapotei bo, “Kiivavo Sisa.” ");
INSERT INTO pwg_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Ma Yesu ivona bo, “Vaghina. Aviyavisina Sisa rapenai na Sisa kona verei. Ma aviyavisina God rapenai na God kona verei.” ");
INSERT INTO pwg_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Koroto ghamana maghinosiyai ma nakanani ivivi sisiya na vibero wawayisi ivi yanei na ivi deyei da kawasi ipota. Ma ke kovokovoghina da iti wavui. ");
INSERT INTO pwg_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Sadusi damsi inotanotai da wawaya ina rabobo na muriyai ke ina vomiiri. Ma viya ipisi Yesu kurina ma ivona bo, ");
INSERT INTO pwg_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Bada, Moses ita vonaviyoyovana kamonai weni nakanani igirumi. ‘Tomowa ina rabobo da kawana ina verukuyowei ma natunatusi kegha na varesina sago kwapurina ina ravaghi da ini tuwa. Ma nani ededisi na tomowina raborabobona natunatuna.’” ");
INSERT INTO pwg_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","“Vaghina, mara sago rakaraka sago kamonai na tomotomowa miikovimaruwa. Iyarokona itavine ma irabobo ma natunatuna kegha. ");
INSERT INTO pwg_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Ma kana kiitana kwapurina iravaghi da bade ke iti tuwa ma irabobo. ");
INSERT INTO pwg_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Ma kana viaroba bade nakanani. Vaghina, nakanani miikovimaruwa peyarisi kwapurina sago iravaghi ma ke sago iyai iti tuwa, ma peyarisi irabobomakai ma natunatusi kegha. ");
INSERT INTO pwg_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Turina vaghata na kwapurina irabobo. ");
INSERT INTO pwg_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Ma mara damonai wawaya ina vomiiri na wavinena na iyi kawana? Nani tomotomowisi peyarisi miikovimaruwa iravaghi.” ");
INSERT INTO pwg_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Ma Yesu ivonapotesi bo, “Karako dobuwai na tomowa ma wavine etatavine. ");
INSERT INTO pwg_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Ma mara damonai iyavo kava God ivinesi da ina wawaya kiikiimatanisi na rabobowai ina vomiiri. Mara vuna ini karei ma nani kamonai wawaya ke meyani ina tavine. ");
INSERT INTO pwg_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Ti na God ina aneya nakanani, ke meyani da ina rabobome. Ma rabobowai ivomiiri kubiine, ti na God natunatuna. ");
INSERT INTO pwg_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Ma Moses kiikiirukuna ikarakarai na ivi varagutugutui. Ma kamonai God ivona bo, ‘Abraham, Aisiki, ma Jeikap i God na Taku.’ Ivi beyebeyeta da raborabobosi ina vomiiri. ");
INSERT INTO pwg_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Tuna wawaya yawayawasisi i God, ke raborabobosi i God. Wawaya kudubisi na yawayawasisi God ku matana.” ");
INSERT INTO pwg_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Ma vonaviyoyovana vibeyebeyena wawayisi viya ivonapotei bo, “Bada, kuvona bubuna.” ");
INSERT INTO pwg_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Ma nani murinai na ke sago wawaya iti tepatora da iti tarakiiyanei. ");
INSERT INTO pwg_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Ma Yesu ivonesi bo, “Ikikava na wawaya evonavona da God ina Vivinevine Wawayina na David tupurereghina? ");
INSERT INTO pwg_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Ma David, Psalms kamonai igiruma bo, ‘Bada God aku Bada kurina ivona bo, Katagheyakuwai kuna makamakai ");
INSERT INTO pwg_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","da kam ghavighaviya kudubina ku kae gaburim ana teresi.’ ");
INSERT INTO pwg_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","David evonavona da God ina Vivinevine Wawayina na ina Bada. Ma ikikava da God ina Vivinevine Wawayina na bade David tupurereghina?” ");
INSERT INTO pwg_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Wawaya peyarisi ivivi yana ma Yesu, kana kivikivina ivonesi bo, ");
INSERT INTO pwg_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Kokitaruvimi! Ke kona berai da vonaviyoyovana vibeyebeyena wawayisi nakanani. I kayowana da ini wawayaghama. Tuna kubiine gara rurukarukaruwesi ikote ma ebababa, ekayokayogesiro. Ma i kayowana da vigimagimara gawarisiyai wawaya ina vokaravesi ma ini kiikiiwesi. Ma bade i kayowana da kiki numasiyai ma kamporaghai babada kii gawariyai ina makai. ");
INSERT INTO pwg_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Kwapukwapura iberoberowesi da i numa ma i sawara irapenei, ma ekayokayotata da eniponipowana guriguri. Wawaya nakanani na kovogha bero kirakiina ina viiya.” ");
INSERT INTO pwg_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Yesu Taparoro Numana garina kamonai ma mura wawayisi ivereverena na ikitakita. ");
INSERT INTO pwg_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Nani kamonai bade ikita da kwapura moyamoyakina iverena. Mane riririghina gisigisisi ivi ruwa kava iterei. ");
INSERT INTO pwg_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Ma Yesu ivona bo, “Vonavaghata avonavonemi, weni kwapurina moyamoyakina ina verena irakata kirakai, ke wawaya peyarisi nakanani. ");
INSERT INTO pwg_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Peyarisi i mura nevanevasi iverena. Ma weni kwapurina kana makii kavakava na kudubina itere yavui. Ivokoyona meyei.” ");
INSERT INTO pwg_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Yesu kana kivikivina Taparoro Numana ikitakitai ma ivivi sisiyei da wakima kiikiimatanisiyai ivowai. Ma wawaya sawara iverena God kurina na sawarisi itura da Taparoro Numana ivi monaghi da kitana ibiibii kirakai. ");
INSERT INTO pwg_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Ma Yesu ivonesi bo, “Weni Taparoro Numana kokitakitai na mara epipisi da peyarina ina kuririghi inoru ku tano, ke sago wakima kana gawariyai ina makai.” ");
INSERT INTO pwg_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Ma kana kivikivina Yesu ivi tarakiiyanei bo, “Bada, weni berasi na avi maranai ina tupuwa? Ma aviyavisina ini matakira da gisina kava ina tupuwa?” ");
INSERT INTO pwg_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Ma ivonapotesi bo, “Matami ekita da wawaya ke ini beroberowemi. Wawaya bogii ma bogiiyai ina pisi ma ina vonemi bo, ‘Taku na God ina Vivinevine Wawayina!’ bo ‘Marana ipisi da God ina Vivinevine Wawayina ina nekiibau.’ Ma ke koni tumaghanesi. ");
INSERT INTO pwg_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Sisiya koni yanei da dam ruwa ighaviya bo dobu sago kamonai ti mani kavakava iruwa na ke kona yabumana. Weni berasi ini nao ma ke kona notai da tuna na mara damona. Kegha, karakava.” ");
INSERT INTO pwg_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Ma ivona meyesi bo, “Dam ina vomiiri da dam sago kana ghaviya. Ma kiivavo ina vomiiri da kiivavo sago kana ghaviya. ");
INSERT INTO pwg_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Nukenuke ghamaghamasi, gomara ma gubaga beroberosi dobu bogii ma bogiiyai kamosiyai ina tupuwa. Ma kunumai bera ma matakira ghamaghamasi ina tupuwa da wawaya ina yabumana kirakai. ");
INSERT INTO pwg_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Ma weni berasi ini muri. Kunona ina votatanimi ma ini tupaketowanemi. Ina rutinimi da kiki numasiyai ini tupavireviremi ma ku gabura ina teremi. Ma kiikiivavo ma babada ghamaghamasi maghinosiyai kona miimiiri da ini tupavireviremi. Koitumaghaneku kubiine na weni berasi ina tupuwa kurimi. ");
INSERT INTO pwg_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Ma vitupavira kamonai na varaku biibiina koni mamatarei kurisi. ");
INSERT INTO pwg_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Ma ami nota ini rewapana ma ke koni nuwapoya da ikikava kami papara kona vowai, ");
INSERT INTO pwg_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","iyamna taku sisiya ma nuwagiura ana veremi da kami ghavighaviya ke ina ghetanimi. ");
INSERT INTO pwg_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Ma ami rakaraka vaghata, maduwa da mamai, varevaresimi bo turaturami ini wawanemi da babada ku imasi ina teremi ma tami viya ini rabobomi. ");
INSERT INTO pwg_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Taku kubiiku na wawaya peyarisi ina baremi. ");
INSERT INTO pwg_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Ma kegha da ke uyawimi sago kava ina wapa. ");
INSERT INTO pwg_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Komiirikikina da yawasa makamakii nonowina kona panani.” ");
INSERT INTO pwg_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Mara sago kona kitai da seri wawayisi Jerusalem kwanatuna ina miirigwagwari na konakovi da mara gisina kava ma ina gwaramutui. ");
INSERT INTO pwg_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Iyavo kava Judiya dobuna kamonai ina makamakai na ku koya ina verau. Ma iyavo kava Jerusalem kwanatuna kamonai na yaghiyaghinai ina kiibutawei. Ma iyavo kava kupunai na ke ina rui ku kwanatuna. ");
INSERT INTO pwg_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Tuna maranai na kovogha kana mara, ikikava giruma katamana kamonai peroperoveta ivona da ita tupuwa na ina tupuwa. ");
INSERT INTO pwg_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Nani kamonai wivine manamanawisi ma vivisususi ini kamyuyuwa kirakai. God nuwanuwana ina pughu Jiu damsi kurisi ma nuwapoya ina rakata Judiya dobunai. ");
INSERT INTO pwg_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Ma kupuna damsi ina vomiiri ma kepatiyai Jiu wawayisi viya ini kiivunuwana ma viya ina patumisi da ina rutinisi ku dobu bogii ma bogiiyai. Ma God kupuna damsi kii mara ina veresi da Jerusalem ini tugudagudai ma ina wawaya ini kayonogenogeyanesi ma nakanani ina makamakai da kii mara itereterei ruvana ina viiya na ina voterei.” ");
INSERT INTO pwg_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Mara sago matakira notakavakavasi ina tupuwa, madegha, nawaravi ma gwamegwame kurisi. Ma wawaya i dobu bogii ma bogiiyai debudebura gugurina ini yanei ma ini nuwapoya kirakai da i nota ina ragharagha. ");
INSERT INTO pwg_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Wawaya ina yabumana kirakai da ina voviparoparorosi. Ma nuwanuwasi ina karakarai ma ina banebanenega da aviyavisina ina tupuwa dobuwai, iyamna God madegha, nawaravi ma gwamegwame ina nukesi da kunumai kii keta ini wapai. ");
INSERT INTO pwg_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Nani maranai wawaya kudubisi ina kita da taku Wawaya Natusi kwavuwai ere rewapaniku ma ere kadariku ana nekiibau.” ");
INSERT INTO pwg_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","“Weni berasi ina tuputupuwa na kovomiiri ma kotepa, iyamna gisina kava ma God ini yawasimi.” ");
INSERT INTO pwg_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Yesu weni miibiina ivonesi bo, “Koweya ma kii peyarisi kokitai. ");
INSERT INTO pwg_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Kii enumonumoi na namada akova koviiya da kwamra kana mara epipisi. ");
INSERT INTO pwg_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Ma bade nakanani, weni matakirisi kona kitai na akova kona viiya da gisina kava ma God ina vikiivavona ina nekiibau. ");
INSERT INTO pwg_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Vonavaghata avonavonemi, weni kimtina ke ina rabobo yavu ma berasi ina tupuwa. ");
INSERT INTO pwg_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Kunuma ma dobu ina wapa ma vonaku na ke meyani da ina wapa.” ");
INSERT INTO pwg_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Kokitaruvimi da kamporagha ma uma neghanegha ke kona vodunenunuwapei. Ma dobu vitana ke koni nuwapoya kirakiiyei. Ke ita biibai da Wawaya Natusi ina vovira marana ini tataghanimi da tami nakanani ma puwari kamonai kota kona. ");
INSERT INTO pwg_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Weni berana na wawaya kudubina dobuwai ina kamowana yavusi. ");
INSERT INTO pwg_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Mara nonowa kona banebanenega ma kona niponipowana da ami rewapana kovokovoghina da kona miirikikina maranai weni berasi ina tuputupuwa kurimi. Ma bade konipowana da damonai Wawaya Natusi maghinonai kona miiri na ke koninimaya.” ");
INSERT INTO pwg_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Mara nonowa Yesu ivivi beyebeyena Taparoro Numana garina kamonai, ma didibarai na ikiikiibau da Oliv koyanai imakamakai. ");
INSERT INTO pwg_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Ma mara nonowa wawaya peyarisi ivivi mara ku Taparoro Numana da Yesu ina vibeyebeyena iti yanei. ");
INSERT INTO pwg_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Jiu damsi i kam ghamana kana vava Pasova inenekiibau. Damsi i kiki da Pasova kana parawa kapunina kubiine na yist ke ina terei. ");
INSERT INTO pwg_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Ma taparoro babadisi i babada ma vonaviyoyovana vibeyebeyena wawayisi keta iekwekwai da ikikava Yesu iti raboboi. Gavunai ita berai, iyamna wawaya iyabuyabumanesi. ");
INSERT INTO pwg_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Ma Yesu kana kivikivina ivi 12 kamosiyai na sago kana vava Judas Iskariyot. Ma nani maranai Seitan ivi karei da Judas itowatepani. ");
INSERT INTO pwg_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Ma inae da taparoro babadisi i babada ma Taparoro Numana kana potapota i babada kurisi ma yavata ivi sisiya da ikikava Yesu iti wawanei. ");
INSERT INTO pwg_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Babadisi ivi nuwabiibii kirakai ma ivi vaghinei da Judas imana ita kovoghi. ");
INSERT INTO pwg_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Ma bade Judas ivi vaghinei ma taraboga biibiina iekwekwai da maranai wawaya kegha na Yesu babadisi ku imasi ita terei. ");
INSERT INTO pwg_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Marana inekiibau da sipu gegeyisi iti kiivunuwana Pasova kamna kubiine. ");
INSERT INTO pwg_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Yesu kana kivikivina ruwa, Pita ma Jon ivonatawesi. Ivonesi bo, “Konae. Kona vovunagha da Pasova kamna kubiine.” ");
INSERT INTO pwg_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Ma ivi tarakiiyanei bo, “Imapatana kekayokayowekai da kana vovunagha?” ");
INSERT INTO pwg_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Ma ivonapotesi bo, “Korui ku Jerusalem ma tomowa sago kona panani, tuna okowa kibubuna ina kavakavari. Kokivini da meni ku numana ina rurui na yavata korui. ");
INSERT INTO pwg_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Ma numa badana kovonei bo, ‘Akii Bada ivona da tupayaraghina kuni beyekai da kamonai tuna yavata Pasova kubiine kana kam.’ ");
INSERT INTO pwg_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Tomowina na tupayaraghina ghamana kiidamowai ini beyemi. Kamonai na sawara kudubina ivovunaghi ikovi ma vokuya kava kona berai.” ");
INSERT INTO pwg_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Pita ma Jon ivomiiri ma irui ku Jerusalem ma Yesu ikikava ivonesi na nakanani ipanani. Ma nani dobunai ivokuya da Pasova kamna kubiine. ");
INSERT INTO pwg_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Ravi ipika ma kam kubiine Yesu kana kivikivina yavata nevanevasiyai ikenavipika. ");
INSERT INTO pwg_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Ma ivonesi bo, “Aku kayowana ghamana da weni Pasova kamna takam patapata ma muriyai da ani kamaghi kirakiiyei. ");
INSERT INTO pwg_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Avonavonemi da ke meyani Pasova kamna ana kam meyei ina nenae da maranai God ina vikiivavona ina nekiibau ma Pasova berasi iyamsi vaghata ini debe yavui na tuna maranai ana kani.” ");
INSERT INTO pwg_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Ma Yesu redu iviiya ma God ivi kiikiiwei ma ivona bo, “Wena koviiya ma kamomiyai kovi umavereyana. ");
INSERT INTO pwg_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Avonavonemi da ke meyani wain anuma meyei ina nenae da God ina vikiivavona ina nekiibau na tuna maranai anumai.” ");
INSERT INTO pwg_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Yesu parawa iviiya ma God ivi kiikiiwei ma ivogimagimai. Ireregha kurisi ma ivonesi bo, “Weni tuna na tupuwiku. Weni berana kona beraberai da kona notanotiku.” ");
INSERT INTO pwg_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Ma bade nakanani kam murinai redu iviiya ma ivona bo, “Weni reduna imatakira da tami kubiimi taraku ina sororo da God ina vivaghina makamakiina vuna ina wawaya yavata ina berai.” ");
INSERT INTO pwg_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","“Ma kovi yana, wawayina ini wawaneku na wekarakava yavata takamkam patapata. ");
INSERT INTO pwg_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","God ina kayowana ikikava itereterei na nakanani ina tupuwa taku, Wawaya Natusi kuriku da ana rabobo. Ma tam iyai kuni wawaneku na kuti nuwapoya kirakai, iyamna kovogha ghamanakina kuna panani.” ");
INSERT INTO pwg_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Ma kana kivikivina kamosiyai ivivi tarakiiyana meyesi da iyi weni berana ina berai. ");
INSERT INTO pwg_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Yesu kana kivikivina ti mani kavakava ivivi taghegheyanesi da kamosiyai meni wawayina na ghe kirakai. ");
INSERT INTO pwg_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Ma ivonesi bo, “Kupuna damsi i kiikiivavo i vibadana na ibagibagi kirakai ma ekayokayotata ma enotanotai da i wawaya ivite bubunisi. ");
INSERT INTO pwg_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Ma tami na ke nakanani kona berai. Kamomiyai wawaya ghamana ina tereoruwe meyei da tuna nakanani ma wawaya kikei. Ma meni wawayina ini bada na ina tereoruwe meyei da tuna nakanani ma bigabiga wawayina. ");
INSERT INTO pwg_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Meni wawayina na wawaya ghamana, wawayina kepanai imakai da ekamkam bo wawayina ebigabiga da vavai ererereghi? Wawaya ghamana na ekamkam, tabo? Ma taku, ke nakanani ata beraberai. Kamomiyai taku na ami bigabiga.” ");
INSERT INTO pwg_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Ma wawaya ivi tupaketowaneku na tami kovi patutu kirakai da ke meyani kota kuyoweku. ");
INSERT INTO pwg_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Ikikava aku Mamai vibadana ivereku na bade nakanani tami vibadana ana veremi. ");
INSERT INTO pwg_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Nani maranai na aku kepanai takam ma tuma ma kiikiivavo kii gawariyai kona makai da dam ivi 12 Israel kamonai koni badesi.” ");
INSERT INTO pwg_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Yesu ivona bo, “Saimon, Saimon, Seitan ivi nowi God kurina ma vivaghina gwabinai iviiya da ina ruyaghimi. ");
INSERT INTO pwg_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Ma anipowana kubiim da vitumaghana ke kuna voterei. Karakava kuna miiritavire kuriku na turaturam kuni vitesi da ti bade i vitumaghana ini rewapana.” ");
INSERT INTO pwg_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Ma Saimon Pita ivona bo, “Bada, taku kovokovoghiku da tam yavata ku gabura tarui bo yavata tarabobo.” ");
INSERT INTO pwg_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Ma Yesu ivonapotei bo, “Pita, avonavonem da karako mara aroba kuni bero da ke kutakoviku ma murinai kokoreko ina tou.” ");
INSERT INTO pwg_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Yesu kana kivikivina ivona tovonisi bo, “Rorova avonemi da kaeterepapara bo wagu bo mane kana kutu ke kota yuna ma avonatawemi. Kade ami baba kamonai nuwapoya kopanani bo kegha?” Ma ivonapotei bo, “Kegha.” ");
INSERT INTO pwg_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Ma ivonesi bo, “Ma wekarakava na mane kana kutu bo wagu gwabimuwai na kekavari. Ma mikeda tam seri gwabimuwai kegha na kam nuba garana kevi gimarei da seri kuna gimari. ");
INSERT INTO pwg_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Giruma katamana kamonai ivona bo, ‘Wawaya beroberosi yavata kovogha ina viiya. Ma avonavonemi da weni girumina na taku ivi sisiyeku. Vonavaghata, ikikava igiruma da ita tupuwa na peyarina wekarakava etuputupuwa.’” ");
INSERT INTO pwg_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Ma kana kivikivina ivona bo, “Bada, kekitai. Seri ruwa weni.” Ma Yesu ivona bo, “Vaghina, kovokovoghina.” ");
INSERT INTO pwg_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Yesu mara nonowa ikiikiibau ku Oliv koyana, tuna kubiine kana kivikivina yavata ivomiiri ma Jerusalem ikiibutawei da inae nake. ");
INSERT INTO pwg_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Inekiibau na ivonesi bo, “Konipowana da ruyagha kamonai ke kona peku.” ");
INSERT INTO pwg_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Kana kivikivina ikuyowesi ma inae ke gurina ma ivi tuwaporeruruwana ma inipowana bo, ");
INSERT INTO pwg_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Mamai, kivaghinei bo kegha da weni vokwarakwara reduna gwabikuwai kuta viitawei. Ma ke taku aku kayowana ma tam am kayowana ina tupuwa.” ");
INSERT INTO pwg_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Ma aneya kunumai ioru da rewapana iverei. ");
INSERT INTO pwg_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Ma nuwapoya ikiivunui kubiine na nuwanuwana kudubinai inipowana kirakai da poyagururu iterevunui. Ma poyapoyana ivivi toi na kitana nakanani ma tara. ");
INSERT INTO pwg_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Nipowana ivoterei ma ivomiiri da ivovira kana kivikivina kurisi, ma ipananisi da nuwapoya ikiivunusi da ivivi keneyana. ");
INSERT INTO pwg_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Ma ivonesi bo, “Avi kubiine kokenakena? Kovomiiri ma konipowana da ruyagha kamonai ke kona peku.” ");
INSERT INTO pwg_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Yesu ivivi sisiya kamonai ma koroto ghamana inekiibau. Judas ivi nowesi, tuna na kana kivikivina sago. Imiiririya Yesu kurina da ita yoni, ");
INSERT INTO pwg_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","na Yesu ivi tarakiiyanei bo, “Judas, viwawana kubiine taku Wawaya Natusi keyoyoniku, bo?” ");
INSERT INTO pwg_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Ma kana kivikivina ikitai da aviyavisina ituputupuwa na ivona bo, “Bada, akii seriyai kana ravisi, bo?” ");
INSERT INTO pwg_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Ma kana kivikivina sago taparoro badana ghamana ina bigabiga iravi da tinina katagheyana ikiiyaraghatawei. ");
INSERT INTO pwg_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Ma Yesu ivonesi bo, “Kovoterei!” Ma ivororona da tomowina tinina ivotovoni da iyawasa. ");
INSERT INTO pwg_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Ma Yesu taparoro babadisi i babada ma Taparoro Numana kana potapota i babada ma kwanatu babadisi peyarisi kurisi ivona bo, “Taku aighaviyemi bo, da kaku seri ma kaku kepata kokavarapiyei? ");
INSERT INTO pwg_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Mara nonowa tami ma taku Taparoro Numana garina kamonai tamakamakai, ma ke kota paniku. Ma wekarakava na kami mara ipisi na nubakutuva ina rewapana ibademi.” ");
INSERT INTO pwg_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Seri damsi Yesu ivotani ma irutini inae da taparoro badana ghamana ina ku numa. Ma Pita murisiyai ikivinisi inae. ");
INSERT INTO pwg_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Ma taparoro badana ina numa garina kamonai na wawaya keyama ikiiri da ivivi rarana. Ma Pita inae da kamosiyai imakai. ");
INSERT INTO pwg_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Bigabiga wavinena sago ikitai da Pita keyama ririnai imakamakai. Keyama gweyorinai ikita bubuni ma ivona bo, “Weni tomowina tuna Yesu yavata ibababa.” ");
INSERT INTO pwg_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Ma Pita ivi bero bo, “Wavine, taku nani tomowina ke atakovi!” ");
INSERT INTO pwg_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Imakai mara gisina ma tomowa sago Pita ikitai ma ivona bo, “Tam na Yesu kana kivikivina sago.” Ma Pita ivona bo, “Aku tomo, taku ke meyani ata kivini.” ");
INSERT INTO pwg_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Imakai da ke gurina ma bade wawaya sago ivona bo, “Vonavaghata, weni tomowina na Yesu kana kivikivina, iyamna tuna na Gariri wawaya.” ");
INSERT INTO pwg_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Ma Pita ivonapotei bo, “Aku tomo, kegha. Taku ke atakovi da aviyavisina kisisiyei!” Nakanani ivivi sisiya ma kokoreko itou. ");
INSERT INTO pwg_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Ma Bada Yesu itavire da Pita ikitatupei. Ma Pita ina nota ivovira da Yesu ina sisiya inotai. “Karako mara aroba kuni bero da ke kutakoviku ma muriyai kokoreko ina tou.” ");
INSERT INTO pwg_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Ma vaghina, Pita numa garina ikiibutawei ku kupuna ma itou kirakai. ");
INSERT INTO pwg_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Seri damsi Yesu ikoyakoyaghi na ivowavowai ma ivivi namei. ");
INSERT INTO pwg_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Matana igerepotai, iravi ma ivonei bo, “Tam peroveta bo? Mede kevonekai, iyi iravim?” ");
INSERT INTO pwg_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ma ivi avaberowei. ");
INSERT INTO pwg_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Mara itom ma Jiu damsi i babada, taparoro babadisi i babada, ma giruma wawayisi ivi kiidaburana ma seri wawayisi Yesu irutini inae ku maghinosi. ");
INSERT INTO pwg_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Ivonei bo, “Mikeda tam Keriso, kevonekai.” Yesu ivonapotesi bo, “Mikeda ana vonemi na ke koni tumaghana. ");
INSERT INTO pwg_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Ma mikeda ata vonatovonimi na ke kovokovoghina kota vonapoteku. ");
INSERT INTO pwg_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Ma karako da nokoni ku marana, Wawaya Natusi, God katagheyanai ina makai.” ");
INSERT INTO pwg_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Peyarisi Yesu ivi tarakiiyanei bo, “Nakanani na tam God natuna, bo?” Ivonapotesi bo, “Ikikava kovonavoneku na vonavaghata.” ");
INSERT INTO pwg_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Peyarisi ivona bo, “Avi kubiine vimamatara wawayisi tekwekwisi? Namada tuna mani kawanai ivi mamatara meyei.” ");
INSERT INTO pwg_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Ma babadisi kudubisi ivomiiri da Yesu irutinaneyei Pailat kurina. ");
INSERT INTO pwg_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Ma nani dobunai ivi karei da Yesu ivivi wavui, “Weni tomowina kapanani da akii wawaya inoraveraveyana berosi. Ivonesi da Kiivavo Sisa ina teks ke iti miiyei, bade ivona da tuna kiivavo, ma Keriso.” ");
INSERT INTO pwg_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Pailat Yesu ivi tarakiiyanei bo, “Tam Jiu damsi i kiivavo, bo?” Yesu ivona bo, “Vonavaghata, vaghina kevonavona.” ");
INSERT INTO pwg_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Ma Pailat ivi sisiya taparoro babadisi i babada ma koroto kurisi. Ivonesi bo, “Weni wawayina ina berona ke sago ata panani.” ");
INSERT INTO pwg_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Ma kegha da taparoro babadisi i babada ma koroto gamosi ibagibagi, “Weni tomowina ina vibeyebeyena kubiine, wawaya peyarisi Judiya kamonai nuwanuwasi eghakighaki. Gariri kamonai ivi karei ma ipisi da wike.” ");
INSERT INTO pwg_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pailat sisiyina ivivi yanei na ivi tarakiiyana bo, “Tomowina na Gariri wawaya bo?” ");
INSERT INTO pwg_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Pailat ivi yanei da Yesu tuna Herodi ina rewapana gaburinai na ivonatawei Herodi kurina, iyamna iakovi da Herodi wekarakava ipisi ku Jerusalem. ");
INSERT INTO pwg_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Maranai Herodi Yesu ikitai, nuwanuwana ibiibii kirakai, iyamna tuna namadani kava ina kayowana da Yesu ita kitai. Varana ivivi yanei na ina nota ghamana da Yesu bera ghamaghamasi ita berai da ita kitai. ");
INSERT INTO pwg_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Ivi taravirevire kirakiiyei ma Yesu ke ita vonapotei. ");
INSERT INTO pwg_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Taparoro babadisi i babada ma giruma wawayisi imiiririya ma Yesu ivi wavu patei. ");
INSERT INTO pwg_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Ma Herodi, ina seri wawayisi yavata Yesu ivi namei ma ivi kaekaeyei. Ma muriyai gara kiimatanina iviiya ma Yesu ivi kotei ma ivonatawei ivovira Pailat kurina. ");
INSERT INTO pwg_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Karenai Pailat da Herodi ivi kawapata ma nani maranai ivi karei da ivi turana. ");
INSERT INTO pwg_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pailat, Yesu iviiya na babadisi ma koroto kudubisi ikwaturiyariyesi, ");
INSERT INTO pwg_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","ma ivonesi bo, “Weni tomowina kopiyei na kovona da wawaya ivivi noraveyana berosi. Tomowina kovi wavui na maghinomiyai avi tupavirevirei ma ke sago ina berona ata panani. ");
INSERT INTO pwg_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Bade Herodi nakanani ke sago berona ita panani. Tuna kubiine ivonatawei ivovira kurita. Ke aviyavisina berona ita berai da kana rabobo kota vonei. ");
INSERT INTO pwg_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Tuna kubiine kovogha kava ana verei ma ana vonatawei ina nae.” ");
INSERT INTO pwg_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","(-) ");
INSERT INTO pwg_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Peyarisi marasago ikarayogosi, “Kokiivunui! Akii kayowana da Barabas kovotawei!” ");
INSERT INTO pwg_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(Barabas viruwa ma kiivunuwa kubiine ku gabura iterei.) ");
INSERT INTO pwg_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pailat babadisi ma wawayisi ivonatovonisi da Yesu ita votawei. ");
INSERT INTO pwg_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Ma kegha da koroto ere kiikiirarisi ivonavona bo, “Kotuparatui! Kotuparatui!” ");
INSERT INTO pwg_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Pailat ina vonatovona viarobina iterei, “Ikikava? Weni tomowina aviyavisina ibera beroi? Ke aviyavisina berona ita berai da kana rabobo kota vonei. Tuna kubiine ana vonesi da widi kava ina verei ma ina vonatawei ina nae.” ");
INSERT INTO pwg_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Ma kegha, ere nuwaghakighakisi koroto ikiikiirara ma ivonavona bo, “Kotuparatui!” Nani kiirarina kubiine, ");
INSERT INTO pwg_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Pailat i kayowana iberai. Yesu seri wawayisi ku imasi iterei da ita tuparatui. ");
INSERT INTO pwg_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Ma Barabas, viruwa ma kiivunuwa kubiine gabura kamonai imakamakai, ivotawei koroto i ku kayowanai. ");
INSERT INTO pwg_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Seri damsi Yesu irutini inenae. Nani kamonai tomowa sago, kana vava Saimon, ina dobu Sairini, ku Jerusalem irurui. Seri damsi imiiripotei ma Yesu kana korosi iviiya da Saimon ivi kavari. Ma ivonei da Yesu murinai ita baba. ");
INSERT INTO pwg_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Ma koroto ghamana ikivikivinisi ma kamonai na wivine Yesu itutuwei ma isiyasiyapei. ");
INSERT INTO pwg_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Yesu imiiritavire ma ivonesi bo, “Jerusalem wivine, ke kona tuweku. Tami ma natunatumi kubiimi kota tou. ");
INSERT INTO pwg_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Kokitai, mara epipisi ma wawaya ina vona bo, ‘Iyapoma da wivine gagarisi, manawisi kamonai pepeya ke ita kavari, ma ke iti susui.’ ");
INSERT INTO pwg_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Nani maranai wawaya koya ina vonei bo, ‘Koya ghamam, ketamogunewa da kuna dogokai! Koya kikei, agu etini ku tepakai!’ ");
INSERT INTO pwg_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Mikeda wawaya weni berasi ina berai maranai kii matinai, ma avi berana ina berai maranai kii na ina poki?” ");
INSERT INTO pwg_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Seri damsi tomotomowa beroberosi ruwa irutinisi ikiibau da Yesu yavata iti rabobosi. ");
INSERT INTO pwg_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Maranai inekiibau da gawara kana vava ‘Wawaya Teuteuna,’ ma nani dobunai Yesu ma tomotomowisi ruwa ituparatusi. Sago katagheyanai ma sago dugenai. ");
INSERT INTO pwg_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Yesu ivona bo, “Mamai, weni damsi i berabero kenotatawei. Ti ke itakovi da aviyavisina eberaberai.” Ma seri wawayisi virekwa sago iberai da kamosiyai Yesu kana gara irereghi. ");
INSERT INTO pwg_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Ma wawaya imiiri ikitakita ma babada ivonavonavinamei. Ivonei bo, “Kuvona da tam God ina Vivinevine Wawayim. Wawaya kuvivi yawisi na mede kevi yawa meyem!” ");
INSERT INTO pwg_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Seri damsi imiiririya ma ti yavata Yesu ivi namei. Wain tomatomana iverei da itumai ");
INSERT INTO pwg_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","ma ivonei bo, “Mikeda tam Jiu damsi i kiivavo na kevi yawa meyem.” ");
INSERT INTO pwg_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Ma gayamina vovonai, korosiyai, igiruma bo, ‘Weni tuna Jiu damsi i kiivavo.’ ");
INSERT INTO pwg_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Tomowa berona yavata irororoke na Yesu ivonavinamei, “Tam Keriso bo? Kevi yawita.” ");
INSERT INTO pwg_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Ma kana viruwa kwinana iyeghai bo, “Tam God keyabuyabumanei bo kegha? Ita viaroba na kovoghina sago taviiviiya. ");
INSERT INTO pwg_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Tota na ita berabero tepanai na kovogha taviiviiya ma weni tomowina na ina berona kegha.” ");
INSERT INTO pwg_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Ma ivonei bo, “Yesu, maranai kuni kiivavo na ke kuni notawapeku.” ");
INSERT INTO pwg_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Yesu tomowina ivonapotei bo, “Karako tam ma taku tarui ku Paradais.” ");
INSERT INTO pwg_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Vaghina ma madegha punai ma nubakutuva ioru da dobu kudubina isovo yavui, ma nakanani imakamakai da ku ravi madegha. ");
INSERT INTO pwg_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Maranai madegha rarana ivoterei Taparoro Numana kana tupayaragha garana basunai itamogosira da ruwa. ");
INSERT INTO pwg_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Ma Yesu gamona irakata ma ikwatu, “Mamai, kanumiku ku imam atereterei.” Ina sisiya turina iterei, nuwayaporina ighae ma irabobo. ");
INSERT INTO pwg_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Ma senturiyon sago weni berana ikitai, God ivokavakavari ma ivona bo, “Vonavaghata da weni tomowina na wawaya maninina.” ");
INSERT INTO pwg_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Vaghina ma, wawaya ivi kiidaburesi ma weni berana ikitai na peyarisi nuwapoyina iviiya da nuwakadasi iraravi ma ivovira i ku numa. ");
INSERT INTO pwg_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Wawaya viya Yesu iakova kirakiiyei ma bade wivine Yesu ikivini Gaririyai ipisi, imiiritaweyana ma ikitakita. ");
INSERT INTO pwg_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Tomowa sago kana vava Josepa, ina kwanatu Arimateya, Judiya kamonai. Tuna wawaya biibiina ma kiimatanina. Ma bade tomowa ghamana Jiu damsi babadisi kamosiyai. ");
INSERT INTO pwg_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Maranai babadisi ivi ogatara da Yesu iti raboboi na ke iti vaghinei. Ma bade tuna nimonimoriyai ikoyakoyagha da God ina vikiivavona kana mara ita pisi. ");
INSERT INTO pwg_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Inae Pailat kurina ma Yesu tupuwina kubiine ivi nowi. ");
INSERT INTO pwg_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Korosi itereoruwei ma igerei. Ma ikavari inae da buba vuna vaghata kamonai ivi kenai. ");
INSERT INTO pwg_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Ivovovunagha da viyakam marana kubiine. ");
INSERT INTO pwg_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Nani wivinesi Yesu Gaririyai ikivini ighae na bade wivinesi sago Josepa ikivini inae da buba ikitai ma ikikava Yesu tupuwina iterei. ");
INSERT INTO pwg_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Ivovira ku numa ma i oira ghabughabusi ivovunagha. Ma viyakam marana kubiine ivi yakam. ");
INSERT INTO pwg_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Sande mara boiboiyai wivine oira ghabughabusi ivovunagha na iyuna ma ivi mara ku karawaga. ");
INSERT INTO pwg_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Inekiibau na ikitai da buba vovotawena. Kana gudu na wakima ghamana ma wawaya itabiri ku ririna. ");
INSERT INTO pwg_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Irui ku buba kamona ma ikitavirevire da Bada Yesu tupuwina kegha. ");
INSERT INTO pwg_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Imiiri vaghata ma nuwanuwasi ivivi tetei na nani kamonai tomotomowa ruwa, kii gara matakamokamosi inekiibau da ririsiyai imiiri. ");
INSERT INTO pwg_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Wivinesi iyabumana kirakai da idune vaghata ma tomotomowisi ivona bo, “Avi kubiine wawaya yawayawana koekwekwai raborabobosi kamosiyai? ");
INSERT INTO pwg_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Yesu ke weni dobunai, tuna namada rabobowai ivomiiri. Kade konotanotai da Gariri kamonai yavata komakamakai na ikikava ivonemi? ");
INSERT INTO pwg_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Ivona bo, ‘Wawaya Natusi ina viiya da berabero wawayisi ku imasi ina terei ma korosiyai ina tuparatui. Ma mara viarobina kamonai rabobowai ina vomiiri.’” ");
INSERT INTO pwg_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Ma nani maranai wivinesi Yesu ina sisiya inotapanani. ");
INSERT INTO pwg_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Karawagiiyai ivovira ku numa ma Yesu ina aposol ivi 11 ma kana kivikivina viya yavata ivonesi. ");
INSERT INTO pwg_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Wivinesi na Meri Magadarini, Jowana ma Jemes ina maduwa Meri ma wivine viya yavata. ");
INSERT INTO pwg_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Weni wivinesi ivi sisiya na Yesu kana kivikivina ke iti tumaghanesi, inotai da ivivi sisiya wapawapa. ");
INSERT INTO pwg_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Ma Pita ina kina kava ivomiiri ma iverau da ku karawaga. Ma ku buba irugenara da Yesu tupuwina kana gere kava ikitai. Ma ivovovira ku numa ma aviyavisina itupuwa na inota kavakavai. ");
INSERT INTO pwg_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Ma bade nani maranai na Yesu kana kivikivina ruwa Jerusalem ikuyowei da ibaba inenae ku Emeyas kwanatuna. ");
INSERT INTO pwg_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Ma i baba kamonai na aviyavisina kudubina itupuwa na ivivi sisiyei. ");
INSERT INTO pwg_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Ivivi sisiya na Yesu kurisi inekiibau da yavata ibaba patapata. ");
INSERT INTO pwg_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Ma kana kivikivina matasi ikiivurei da Yesu ke ita vogiini. ");
INSERT INTO pwg_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Ma ivi tarakiiyanesi bo, “Aviyavisina koisisiyei?” Ma ere nuwadugarisi ivi kiimiiriyesi ma idune. ");
INSERT INTO pwg_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Ma sago, kana vava Kiriyopas ivi tarakiiyana bo, “Numanumataya peyarisi iakovi da aviyavisina Jerusalem kamonai etuputupuwa ma ikikava tam ina kim kava ke kutakovi?” ");
INSERT INTO pwg_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Ma ivi tarakiiyanesi bo, “Avi berasi?” Ma ivonapotei bo, “Aviyavisina itupuwa Nasaret wawaya Yesu kurina. Tuna na peroveta ma God ma wawaya ku matasi ina sisiya ma ina bera peyarina na ivi rewapana kirakai. ");
INSERT INTO pwg_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Ma taparoro babadisi i babada ma Jerusalem damkai akii babada na tomowina iviiya ma kupuna damsi ku imasi iterei. Ma ti na ivi tupavirei ma ivonakiiyaragha da ita rabobo ma korosiyai ituparatui. ");
INSERT INTO pwg_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Tokai kanotai da tuna tomowina Israel damta iti yawasita. Akii nuwapoya irakata, ma ku tepana na weni berasi murinai na ke sago biibiina ita tupuwa. Ma namada mara aroba ikovi. ");
INSERT INTO pwg_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Ma bade wivine viya kamokiiyai sisiya sago ivonekai na kavi deyei. Karako ivi mara ku karawaga ma irui ku buba kamona ");
INSERT INTO pwg_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","da Yesu tupuwina ikita kavai. Ma ivovira ivonekai da aneya ikitisi. Ma sisiya gwabisiyai iviiya da Yesu na yawayawana. ");
INSERT INTO pwg_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Ma akii wawaya viya inae ku karawaga ma ikikava wivinesi ivivi sisiya na nakanani ipanani. Ma Yesu ke ita kitai.” ");
INSERT INTO pwg_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Ma Yesu ivonesi bo, “Tami neghaneghami ma gayama butabutami da aviyavisina peyarina peroperoveta ivivi sisiyei na ke koti tumaghanei. ");
INSERT INTO pwg_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Kotakovi da God ina kayowana da ina Vivinevine Wawayina iti kamaghi kirakiiyei ma ita rabobo ma murinai kana ku kadara ita rui.” ");
INSERT INTO pwg_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Vaghina ma Yesu ivi karei da ikikava giruma katamana kamonai God ina Vivinevine Wawayina ivi sisiyei na peyarina kurisi ivi debei. Kunona Moses aviyavisina igirumi na ivi sisiyei ma muriyai peroperoveta viya i giruma na iyamsi ivi sisiyei kurisi. ");
INSERT INTO pwg_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Namada ku Emeyas inenekiibau ma Yesu iberai da nama maninina ita nenae. ");
INSERT INTO pwg_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Ma kegha da kana kivikivina ivonatani. Ivona bo, “Ke kuna nae. Takena iyamna mara ikovi, namada ravi ipika.” Vaghina, ivovira ma yavata irui da imakai. ");
INSERT INTO pwg_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Kam kubiine na parawa iviiya ma God ivi kiikiiwei ma ivogimai. Ma ivi karei da ita veresi. ");
INSERT INTO pwg_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Tuna maranai matasi ikiigigiri da kwinasi ikita bubuni da tuna na Yesu. Ikitakitai na iwapa. ");
INSERT INTO pwg_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Ma ti mani ivonavona bo, “Tuna kubiine ita baba kamonai giruma katamana kamonai miiba gavugavusi ivivi debei kurita na nuwanuwata itonatonai ma tavivi nuwabiibii kirakiiyei.” ");
INSERT INTO pwg_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Nani murinai ivi ruwa ivomiiri da maninina ivovirame ku Jerusalem. Ma nani dobunai kana kivikivina ivi 11 ma turaturasi viya namada ivi kiidaburana na ipananisi. ");
INSERT INTO pwg_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Ma ivi yanesi da peyarisi ivivi sisiya bo, “Vonavaghata da Bada rabobowai ivomiiri! Saimon kurina inekiibau!” ");
INSERT INTO pwg_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Ma ivi ruwa turaturasi ivi akovisi da aviyavisina tupuwa i baba kamonai, ma bade ikikava ivogiini da tuna Yesu, maranai parawa ivovogimai. ");
INSERT INTO pwg_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Ivivi sisiyei ma nani kamonai Yesu inekiibau da kamosiyai imiimiiri ma ivona bo, “Nuwanuba gwabimiyai ina makai.” ");
INSERT INTO pwg_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Ivi tataghanisi da iyabumana ma ogariri igheyesi ma inotai da nama momosika ita kitakitai. ");
INSERT INTO pwg_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Ma ivonesi bo, “Ke kona yabumana. Ami nota ke ina ragharagha ma ke ina gisi. ");
INSERT INTO pwg_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Imaku ma kaeku kokitai. Wena na taku! Kovotovoniku da damina kona viiya. Momosika viyosi ma tuwirisi kegha.” ");
INSERT INTO pwg_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Weni nakanani ivi sisiya kana kivikivina kurisi ma imana da kaena ivi beyesi. ");
INSERT INTO pwg_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Peyarisi inota kavakavai da ke nuwanuwasi kudubinai iti tumaghana ma kegha da ivi nuwabiibii kirakai. Tuna kubiine Yesu ivonatovonisi bo, “Kade, aviyavisina emakamakai da ata kani?” ");
INSERT INTO pwg_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Iyana gibugibuna iverei, ");
INSERT INTO pwg_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","ma kana kivikivina matasiyai Yesu nani iyanina ikani. ");
INSERT INTO pwg_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Ma ivonesi bo, “Rorova yavata tamakamakai na avonemi da aviyavisina Moses ina vonaviyoyovana ma peroperoveta ma Psalms kamonai igirugirumi da ita tupuwa kuriku na God ina kayowana da kudubina ina tupuwa.” ");
INSERT INTO pwg_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Muriyai i nota ivotawei da sisiya giruma katamana kamonai na iyamsi itakova bubuni. ");
INSERT INTO pwg_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Ivonesi bo, “Weni nakanani igiruma. ‘God ina Vivinevine Wawayina ini kamaghi kirakiiyei ma ina rabobo, ma mara viarobina kamonai na ina vomiiri.’ ");
INSERT INTO pwg_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Ma bade igiruma da kana kivikivina ina dima da wawaya i berabero ininimayei ma ina miirikupukuputei da God i berabero ina notatawei. Jerusalem kamonai dima ini karei ma muriyai ina kiibau da dam ma dam kurisi. ");
INSERT INTO pwg_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Tami na weni berasi kudubina kana vivimamatara wawayimi. ");
INSERT INTO pwg_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Ma aku Mamai ikikava vonakiiyapa bagibagina iterei da ita puyomi na taku berana ana berai, puyona ana vonatawei kurimi. Tuna kubiine Jerusalem kamonai kovi koyakoyagha da rewapana kunumai inoru da ina towatepanimi.” ");
INSERT INTO pwg_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Vaghina ma, Yesu kana kivikivina irutinisi da Jerusalem ikiibutawe inae ku gawara sago Betani kwanatuna ririnai. Imana ivororona ma ivi biibiinisi. ");
INSERT INTO pwg_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Ivivi biibiinisi kamonai na God iviitawei da ighae. ");
INSERT INTO pwg_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Ma kana kivikivina Yesu ivokavakavari ma nuwabiibiiyai ivovirame ku Jerusalem. ");
INSERT INTO pwg_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Nani murinai mara nonowa Taparoro Numana garina kamonai God ivivi kiikiiwei. ");
INSERT INTO pwg_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Karenai na Vona imakamakai. Tuna na God yavata imakamakai, ma tuna na God. ");
INSERT INTO pwg_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Ma karenai tuna na God yavata. ");
INSERT INTO pwg_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Tuniyai da bera kudubina iyamoni, mikeda tuna kegha na ke sago aviyavisina dobuwai ita yamoni. ");
INSERT INTO pwg_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Tuna gwabinai na yawasa, ma nani yawasina na wawaya i yasegana. ");
INSERT INTO pwg_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Ma yasegana gweyurina nubakutuva kamonai ekarakarata ma nubakutuva ke kovokovoghina da ita ghekuyowei. ");
INSERT INTO pwg_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Ma God ina yonayona ivonatawei, tuna kana vava na Jon Babataito. ");
INSERT INTO pwg_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Ipisi da nani yaseganina iti debei da wawaya peyarisi iti tumaghanei. ");
INSERT INTO pwg_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Ipisi da yasegana kurisi iti debei, ma tuna na ke yasegana. ");
INSERT INTO pwg_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Ma wawaya ivi akovisi da yasegana vaghata na ku dobu ina nekiibau da wawaya peyarisi yasegana ina veresi. ");
INSERT INTO pwg_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Namanaki da tuna tepanai God dobu iyamoni ma kegha da ku dobu inekiibau na wawaya dobuwai iveyiyei. ");
INSERT INTO pwg_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Ipisi ina ku dobu vaghata ma ina wawaya kurisi ma kegha da ibarei. ");
INSERT INTO pwg_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Ma wawaya viya kava ina sisiya iviiya ma ivi tumaghana na ti damsi ivonesi da God natunatuna. ");
INSERT INTO pwg_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Ma God natunatuna i yawasa na God gwabinai ipisi. Ma nani yawasina na ke kaekiki mau bo tomowa kawana yavata gwabisiyai ita pisi. ");
INSERT INTO pwg_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Ma Vonana ivi wawaya da yavata tamakii patapata. Tuna na God Natuna sago kava na kana kadara kakitai. Ma agabiibai ma vonavaghata gwabinai irakata kirakai. ");
INSERT INTO pwg_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Jon namada ivoneta bo, “Weni wawayina avivi sisiyei na, ‘Tuna murikuwai ina pisi. Ma ighekuyoweku, iyamna imakamakai ma muriyai da atupuwa.’” ");
INSERT INTO pwg_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Ma ina agabiibai kudubina peyarita damina taviiviiya ma ina vibiibiina mara nonowa everevereta. ");
INSERT INTO pwg_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Vonaviyoyovana na God ivi damani Moses kurina da iti debei wawaya kurisi. Ma agabiibai ma vonavaghata na Yesu Keriso gwabinai ipisi. ");
INSERT INTO pwg_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Ke meyani wawaya sago God ita kitai. Natuna sago kava na God yavata ivi kovokovoghana. Tuna ina Mamai yavata na sago. Ma ivi akakovita da God na iyai. ");
INSERT INTO pwg_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Jiu damsi i babada ghamaghamasi Jerusalem kamonai taparoro babadisi ma Livai damsi ivonatawesi Jon kurina ma ivi tarakiiyanei bo, “Tam na iyai?” ");
INSERT INTO pwg_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Ma Jon ke ita bara bo ita yabumana ma ivi debe meyei, ivonapotesi bo, “Taku na ke God ina Vivinevine Wawayina.” ");
INSERT INTO pwg_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Ma ivi tarakiiyanei bo, “Nakanani na tam iyai? Tam peroveta Elaidiya bo?” Ma ivonapotesi bo, “Kegha, taku ke tuna.” “Tam na nani perovetina kakoyakoyaghi bo?” Ma ivonapotesi bo, “Kegha.” ");
INSERT INTO pwg_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Ma damsi ivona bo, “Nakanani na tam iyai? Kevonekai da kana vovira akii babada kurisi ma kana vonesi da tam iyai.” ");
INSERT INTO pwg_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Jon ivonapotesi ikikava peroveta Aisaya igiruma na nakanani ivonesi bo, “Taku na wawaya gamona warereyai erurukwatu, ‘Keta maninina koberai, Bada kubiine.’” ");
INSERT INTO pwg_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Ma Perisi damsi wawaya viya ivonatawesi ma ");
INSERT INTO pwg_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","ivi tarakiiyanei bo, “Mikeda tam ke Keriso, ke Elaidiya bo ke peroveta na avi kubiine kebababataito?” ");
INSERT INTO pwg_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Ma Jon ivonapotesi bo, “Taku okowai abababataito. Ma kamomiyai wawaya sago ke kotakovi. ");
INSERT INTO pwg_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Tuna tomowina murikuwai epipisi. Ighekuyoweku, taku ke wawaya kiimataniku da kaena kana terepapara ata rupami.” ");
INSERT INTO pwg_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Weni berasi peyarina itupuwa Betaniyai, Jodan okowina nevanai, Jon nani dobunai ibababataito. ");
INSERT INTO pwg_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Ma mara itome na Jon, Yesu ikitai ipipisi kurina na ivona bo, “Kokitai, God Ina Sipu Gegeyina epipisi da dobu ina berabero ina viitawei. ");
INSERT INTO pwg_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Weni wawayina avivi sisiyei maranai avona bo, ‘Tomowina murikuwai epipisi na ighekuyoweku, tuna namada imakamakai ma muriyai da atupuwa.’ ");
INSERT INTO pwg_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Taku bade ke atakovi da tuna na nakanani, ma apisi da okowai abababataito, iyamna aidebei da Israel inakovi da tuna iyai.” ");
INSERT INTO pwg_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Ma Jon aviyavisina matanai ikitai na ivi debei, ivona bo “Kanuma Vovokaravina akitai nakanani ma gabubu kunumai ioru da tomowina ku tepana. ");
INSERT INTO pwg_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Taku patana da ke atakovi da tuna iyai ma kegha da Wawayina ivonataweku da okowai abababataito tuna ivoneku bo, ‘Tomowina kuna kitai ma Kanuma Vovokaravina inoru ku tepana na tuna wawayina Kanuma Vovokaravina ina veremi.’ ");
INSERT INTO pwg_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Taku akitai na aidebei da tuna na God Natuna.” ");
INSERT INTO pwg_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Mara itome ma Jon kana kivikivina ruwa yavata patana da nani gawarinai imakamakai. ");
INSERT INTO pwg_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Ma Jon ikitai da Yesu ibaba inenae na ivona bo, “Kokitai, tuna na God ina Sipu Gegeyina.” ");
INSERT INTO pwg_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Kana kivikivina ruwa ina sisiya ivi yanei na inae da Yesu ikivini. ");
INSERT INTO pwg_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Yesu imiiritavire ikitisi da ikivikivini na ivi tarakiiyanesi bo, “Aviyavisina kokayokayowei?” Ma damsi ivonapotei bo, “Rabai (iyamna vibeyebeyena wawayina), tam na meni dobunai kemakamakai?” ");
INSERT INTO pwg_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Yesu ivonapotesi bo, “Kopisi da kona kitai.” Ma tuna na namada ravi madeghinai. Damsi ikivini inae da ina makamakai ikitai, ma yavata nani dobunai imakii kupom. ");
INSERT INTO pwg_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Nani kamonai na Anduru, (tuna Saimon Pita tina kikei.) Maranai Jon Babataito ina sisiya ivi yanei na Yesu ikivini. ");
INSERT INTO pwg_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Ma yaghiyaghinai Anduru inae da ina tuwa Saimon ipanani ma ivonei bo, “God ina Vivinevine Wawayina kapanani.” (Tuna iyamna Keriso.) ");
INSERT INTO pwg_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Ma irutini ipisi Yesu kurina. Yesu ikitai ma ivona bo, “Tam Jon natuna Saimon, wawaya ina kwatum da Kepas.” Ma nani vavana Grik gamosiyai na Pita. (Kepas ma Pita ivi ruwa na iyamsi ‘wakima.’) ");
INSERT INTO pwg_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Mara itome na Yesu ivi karei da ita nae ku Gariri. Ibaba inenae da Piripo ipanani na ivonei bo, “Kekiviniku.” ");
INSERT INTO pwg_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Piripo na Anduru da Pita nakanani, peyarisi i kwanatu na Betsaida. ");
INSERT INTO pwg_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Ma Piripo inae da Nataniyera ipanani ma ivonei bo, “Wawayina kapanani. Moses vonaviyoyovana kamonai igirugirumi ma bade peroperoveta i giruma kamonai ivivi sisiyei. Tuna Yesu, Nasaret wawaya, Josepa natuna.” ");
INSERT INTO pwg_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Nataniyera ivona bo, “Nasaret. Kamonai aviyavisina biibiina ina tupuwa?” Ma Piripo ivonapotei bo, “Kepisi da kuna kitai.” ");
INSERT INTO pwg_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Maranai Yesu Nataniyera ikitai ipipisi na ivona bo, “Weni tomowina tuna Israel vaghata. Tuna na wawaya kiimatanina.” ");
INSERT INTO pwg_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Ma Nataniyera ivona bo, “Ikikava kuakoviku?” Yesu ivonapotei bo, “Muriyai da Piripo ita kwatum na akitim koweya rogunai kumakamakai.” ");
INSERT INTO pwg_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Ma Nataniyera ivonakiiyaragha bo, “Bada, tam God Natuna, Israel kana Kiivavo.” ");
INSERT INTO pwg_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Yesu ivonapotei bo, “Avonem da akitim koweya rogunai kumakamakai, tuna kubiine kuvi tumaghaneku, bo? Karakava bera ghamaghamasi kuna kitai ke nakanani ma weni berana.” ");
INSERT INTO pwg_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Ma ivonesi bo, “Vonavaghata avonavonemi da karakava kona kitai da kunuma ina tamotate ma God ina aneya ina gheghae ma inororu Wawaya Natusi kurina.” ");
INSERT INTO pwg_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Mara viarobina kamonai tavine itupuwa kwanatu kana vava Keina, Gariri dobunai. Ma Yesu ina maduwa na nani kamonai. ");
INSERT INTO pwg_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Ma bade Yesu kana kivikivina yavata ivonesi da nani ku kamna irui. ");
INSERT INTO pwg_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Ma wain ikovi na ina maduwa Yesu ivonei bo, “Wain ivi kovini.” ");
INSERT INTO pwg_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Ma Yesu ivonapotei bo, “Wavine, avi kubiine kuvoneku da aviyavisina ana berai. Aku mara ke ita pisi.” ");
INSERT INTO pwg_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Ma kegha da ina maduwa bigabiga wawayisi ivonesi bo, “Aviyavisina ina vonemi na koberai.” ");
INSERT INTO pwg_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Ma ririsiyai na okowa kibubusi ghamaghamasi miikovimasago iruwanamiimiiri. Nani kibubusi wakimiyai ipapa na Jiu damsi i kiki inununuri da imasi itepotepokowakowa, tuna ivi matakira da nuwanuwasi na yagharina. ");
INSERT INTO pwg_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Yesu bigabiga wawayisi ivonesi bo, “Kibubusi na okowa kovi tupotupo.” Damsi okowa itepo da ighe kawa barasiyai. ");
INSERT INTO pwg_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Ma ivonesi bo, “Wekarakava na gisina kotaraivui ma kokavari konae da kam badana kurina.” Ikavari inae da iverei, ");
INSERT INTO pwg_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","ma badana nani okowina ikaratovoni. Okowina na namada ivi viravira da wain. Ma ke itakovi da mimei ipisi ma bigabiga wawayisi na iakovi, iyamna okowa na ti ivui. Tuna kubiine kam badana tomowina itatavine ikwatui ma itinaviviri ku ririna. ");
INSERT INTO pwg_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Ma ivonei bo, “Wawaya peyarisi karenai na wain biibiina evereverena ma wawaya eumuma da damisi eviiviiya ma muriyai berona evovokiibuwei. Ma tam na biibiina kuvotani da wekarakava kuvokiibuwei.” ");
INSERT INTO pwg_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Weni tuna na Yesu ina bera ghamana karena iberai Keina kwanatunai, Gariri kamonai. Kana kadara ivi debei da kana kivikivina ivi tumaghanei. ");
INSERT INTO pwg_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Weni berana murinai Yesu ma ina maduwa, titina yoghyogho ma kana kivikivina yavata ioru ku Kapeniyam. Ma nani dobunai imakii mara gisina. ");
INSERT INTO pwg_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Marana inenekiibau da Jiu damsi i kamporagha kana vava Pasova ma Yesu ighae ku Jerusalem. ");
INSERT INTO pwg_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Ma Taparoro Numana garina kamonai ipanani da tomotomowa kau, sipu ma gabubu ivivi gimara. Ma viya na kemakema tepasiyai imakamakai ma mane ivivi vovivirana. ");
INSERT INTO pwg_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Tuna kubiine Yesu urava iviiya da wasira iyamoni ma peyarisi Taparoro Numana garina kamonai wawaya i sipu ma kau yavata ikugerisi. Ma bade mane vivovivirana wawayisi i mane ikiiririghi ma i kemakema ivi kuvirevire. ");
INSERT INTO pwg_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Ma iyavo kava gabubu ivivi gimara na kurisi ivona bo, “Weni sawarisi koturakiikiibuwana. Avi kubiine tami aku Mamai ina Numa koruvovirei da vigimagimara gawarina?” ");
INSERT INTO pwg_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Ma kana kivikivina inotapanani da giruma katamana ivona bo, “Am Taparoro Numana na aku kayowana ghamana, tuna kubiine nuwapoyina ekiikiivunuku.” ");
INSERT INTO pwg_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Ma Jiu babadisi ivonei bo, “Avi matakirina ghamana kuna berai da kanakovi da am rewapana imakamakai na weni berana kuberai?” ");
INSERT INTO pwg_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Yesu ivonapotesi bo, “Weni Taparoro Numana kona tinarikai ma mara viarobina kamonai ana ruepa meyei.” ");
INSERT INTO pwg_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Ma Jiu babadisi ivonapotei bo, “Weni Taparoro Numana madegha 46 kamonai ivowai ma tam, kovokovoghim da mara aroba kamonai kuna ruepa meyei, bo?” ");
INSERT INTO pwg_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Ma Yesu na ke Taparoro Numana ita vonavonei ma tuna mani tupuwina ivivi sisiyei. ");
INSERT INTO pwg_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Maranai rabobowai ivomiiri, kana kivikivina inotai da Yesu ikikava ivi sisiya. Ma nani sisiyina ma giruma katamana ivi tumaghanei da vonavaghata. ");
INSERT INTO pwg_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Yesu na Jerusalem kamonai Pasova kamna kubiine, ma matakira ghamaghamasi iberai da wawaya peyarisi ikitai ma ivi tumaghana da tuna na God ina Vivinevine Wawayina. ");
INSERT INTO pwg_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Ma Yesu na wawaya peyarisi i nota iakovi, tuna kubiine ke iti tumaghanesi. ");
INSERT INTO pwg_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Tuna ke wawaya gwabisiyai nota ita viiya da ti na ikikava, iyamna namada iakovi da aviyavisina nuwanuwasi kamonai emakamakai. ");
INSERT INTO pwg_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Jiu damsi i bada ghamana sago, tuna na Perisi ma kana vava Nikodimas. ");
INSERT INTO pwg_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Didibarai ipisi Yesu kurina ma ivonei bo, “Bada, kakovim da tam vibeyebeyena wawayim ma God ivonatawem, iyamna iyavo kava gwabisiyai God ke ita makamakai na ke kovokovoghina da weni berasi ghamaghamasi ina berai.” ");
INSERT INTO pwg_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Yesu ivonapotei bo, “Vonavaghata avonavonem da iyavo kava ina tupuwame na ti kava God ina vikiivavona ina kitai.” ");
INSERT INTO pwg_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Ma Nikodimas ivona bo, “Ikikava tomowa magurina ina tupuwame? Ke kovokovoghina da ina ruime ina maduwa ku manawina da ina tupuwame!” ");
INSERT INTO pwg_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Yesu ivonapotei bo, “Vonavaghata avonavonem da wawaya God ina ku vikiivavona ke ina rui da kunona okowai ma Kanuma Vovokaravinai ina tupuwame na ina rui. ");
INSERT INTO pwg_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Wawaya ina maduwa ini tuwei na wawayota. Ma wawaya Kanuma Vovokaravinai ina tupuwa na tuna God rapenai. ");
INSERT INTO pwg_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Aku sisiya ke kuna tataghanei. Ma ketupuwame. ");
INSERT INTO pwg_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Ikikava yanunu ina kayowanai everaverau, gugurina kuni yanei ma ke kutakovi da mimei epipisi bo mike enenae, bade nakanani wawaya Kanuma Vovokaravina ina rewapanai ina tupuwame.” ");
INSERT INTO pwg_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Ma Nikodimas ivi tarakiiyanei bo, “Weni berana na ikikava?” ");
INSERT INTO pwg_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Ma Yesu ivona bo, “Tam na Israel damsi i vibeyebeyena wawayina ghamana. Ma weni berasi ikikava na ke kutakovi? ");
INSERT INTO pwg_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Vonavaghata avonavonem da aviyavisina kakakovi na kaisisiyei, ma aviyavisina kakitakitai na kavonavonaverena. Ma kegha da tami na akii vonaverena ke kota kayokayowei. ");
INSERT INTO pwg_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Dobu kana bera aisisiyei na ke kota vivitumaghana, na bade kunuma berasi ati sisiyei na koti tumaghaneku bo kegha? ");
INSERT INTO pwg_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Ke sago iyai ku kunuma ita ghae, ma wawaya sago kava kunumai ioru, tuna na Wawaya Natusi.” ");
INSERT INTO pwg_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","“Ma ikikava Moses warereyai mota iyamoni ma kii tepanai iterei ma iruepai, nakanani Wawaya Natusi ina ruepai ina ghae, ");
INSERT INTO pwg_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","da wawaya iyavo kava ini tumaghanei na yawasa makamakii nonowina ina panani. ");
INSERT INTO pwg_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","God wawaya dobuwai nuwanuwasi ivii kirakiiyei da Natuna sago kava ma iverena da iyavo kava ini tumaghanei na ke ina rabobo ma yawasa makamakii nonowina ina viiya. ");
INSERT INTO pwg_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Ma God Natuna ivonatawei na ke dobuwai kovogha ita rereghi kubiine ma dobu iti yawai kubiine.” ");
INSERT INTO pwg_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","“Ma iyavo kava God Natuna itumaghanei na kovogha ke ina panani. Ma iyavo kava ke ita vivitumaghana na namada ivonakiiyaragha da kovogha ina veresi, iyamna Natuna sago kava ke iti tumaghanei. ");
INSERT INTO pwg_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Ikikava God wawaya ini tupaviresi ma ini wavusi na weni. Yasegana ipisi ku dobu, ma wawaya ibarei da didibara ekayokayowei, iyamna i bera na beroberosi. ");
INSERT INTO pwg_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Wawaya berabero eberaberai na yasegana ke ita kayokayowei, ma ku yasegana ke ina pisi, iyamna eyabuyabumana da i bera beroberosi ina kayovidebei. ");
INSERT INTO pwg_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Ma wawaya vonavaghata tepanai emakamakai na ekayokayowei da ku yasegana ina rui, iyamna yaseganina ini debei da ina bera kudubina na God ina kayowana kava eberaberai.” ");
INSERT INTO pwg_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Weni berana murinai Yesu ma kana kivikivina yavata inae ku Judiya, ma nani dobunai imakii gisina ma wawaya ibababataitosi. ");
INSERT INTO pwg_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Ma Jon na Ainon dobunai ibababataito. Tuna Salim kwanatuna baranai, iyamna nani gawarina na okowa dobuna. Tuna kubiine wawaya peyarisi inenae nani ku gawarina da ita babataito. ");
INSERT INTO pwg_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Weni berasi ivi nao, muriyai da Jon ku gabura iterei. ");
INSERT INTO pwg_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Mara sago Jon kana kivikivina ma Jiu wawaya sago yavata ivivi vonapasipasiyana da ikikava i kiki ita nunura bubuni da tupuwisi ita kowai da iti matakira da nuwanuwasi yagharina. ");
INSERT INTO pwg_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Ma inae Jon kurina ma ivona bo, “Bada, nani tomowina Yesu kenotanotai, tota Jodan okowinai ma wawaya kubababataitosi na tuna yavata nani dobunai ma bade kuvi sisiyei kurikai. Ma karako tuna ivi karei da wawaya ebababataitosi na peyarisi enenae kurina.” ");
INSERT INTO pwg_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Ma Jon ivonapotesi bo, “Wawaya puyo ke ina vii wapawapai. God kunumai ina kina kava biga ina rereghi. ");
INSERT INTO pwg_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Tami kovi yaneku da avi debeku, avona da taku ke God ina Vivinevine Wawayina. Ma God ivonataweku da avi nao. ");
INSERT INTO pwg_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Taku nakanani ma tomowa ita tavine na kana miiritana. Ma ina wavine ivopapari na tuna kava rapenai. Tuna kubiine maranai aiyanei da tuna ina wavine yavata ivi kiisagosi na ainuwabiibii kirakai kubiisi. ");
INSERT INTO pwg_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Tuna ini wawayaghama da kana kivikivina ina peyari ma taku na wawayota, aoru kirakai.” ");
INSERT INTO pwg_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Wawaya kunumai ipisi, tuna na ighe kirakai. Ma wawaya dobuwai ipisi, tuna na dobu rapenai ma dobu ina bera isisiyei. Ma meni wawayina kunumai ipisi na tuna na wawaya peyarisi ighekuyowesi. ");
INSERT INTO pwg_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Tuna aviyavisina ikitai ma ivi yanei na isisiyei ma wawaya ke peyarina ina sisiya ita viiya. ");
INSERT INTO pwg_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Ma iyavo kava ina sisiya iviiya na ivi debei da God na vonavaghata isisiyei. ");
INSERT INTO pwg_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Ma wawayina God ivonatawei na God vonana isisiyei, iyamna God, Kanuma Vovokaravina ivere kudubi. ");
INSERT INTO pwg_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Mamai God, Natuna nuwanuwana ivii kirakiiyei da rewapana kudubina iverei. ");
INSERT INTO pwg_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Ma tam iyai God Natuna kuni tumaghanei na yawasa makamakii nonowina kuna panani. Ma tam iyai God Natuna kuna barei na nani yawasina ke kuna panani, iyamna God ina nuwapughu kuna kamowani. ");
INSERT INTO pwg_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Perisi damsi ivi yanei da koroto ghamana inenae Yesu kurina ma ibababataitosi da kana kivikivina, ke nakanani ma Jon. ");
INSERT INTO pwg_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Ma kegha, vonavaghata da ke Yesu ita bababataito ma kana kivikivina kava iberaberai. ");
INSERT INTO pwg_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Maranai Bada Yesu akovina iviiya da Perisi damsi ivivi sisiyei na ivomiiri da Judiya ikuyowei inenae ku Gariri. ");
INSERT INTO pwg_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Sameriya dobuna kamonai ibaba inenae ");
INSERT INTO pwg_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","da ku kwanatu sago inekiibau, kana vava Saika. Nani kwanatuna ririnai na mara katamaninai Jeikap, natuna Josepa dowa iverei. Ma nani dobunai Jeikap kana okowa iyabai. ");
INSERT INTO pwg_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Namada madegha iveruvivira ma Yesu ibaba da ininina ibara, tuna kubiine dogo kawa baranai ivivi yakam. ");
INSERT INTO pwg_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Ma Sameriya wavine ipisi da okowa itivu. Ma Yesu ivona bo, “Kade, okowa kuta vereku atuma.” ");
INSERT INTO pwg_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Ma kana kivikivina na ke yavata, ti na namada inae ku kwanatu da vavai ita gimara. ");
INSERT INTO pwg_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Ma wavinena ivonapotei bo, “Tam na Jiu tomowa ma taku na Sameriya wavine. Ikikava na kuvoneku da okowa ana verem?” Nakanani ivi sisiya iyamna Jiu ma Sameriya damsi ke ita vivinuwaviina bubuna. ");
INSERT INTO pwg_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Ma Yesu ivonapotei bo, “God ina puyo ke kutakovi ma bade ke kutakovi da iyi uma kubiine kurim inowi. Mikeda kutakovi na kuti nowi da okowa yawayawana ita verem.” ");
INSERT INTO pwg_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Ma wavinena ivona bo, “Bada, tam ke sago taraivivu gwabimuwai da okowa kunivui. Ma bade dogo na ioru kirakai. Ma ikikava okowa yawayawana kuna viiya da wawaya inumai na yawasa ina panani? ");
INSERT INTO pwg_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Akii kaekiki Jeikap na wawaya ghamana ma tuna weni dogona iverekai. Rorova mara katamaninai natunatuna ma i ghamoghamo yavata weni dogonai iumuma. Ma tam, kevonavona da Jeikap kughekuyowei, bo?” ");
INSERT INTO pwg_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Ma Yesu ivonapotei bo, “Wawaya iyavo kava weni okowina inumai na kaiyosi ina kanakaname. ");
INSERT INTO pwg_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Ma wawaya iyai taku okowa ana verei inumai na ke meyani kaiyona ina kanakaname. Ma okowina ana verei na yawayawana ma ina yawasa kamonai ina vusivusira da yawasa makamakii nonowina ina viiviiya.” ");
INSERT INTO pwg_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Wavinena Yesu ivonei bo, “Bada, nani okowina kevereku da kaiyoku ke meyani ina kanakana ma ke ana vovirame wike da okowa anivu.” ");
INSERT INTO pwg_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Ma Yesu ivonei bo, “Kenae da kawam kuna vonei ma kona pisi.” ");
INSERT INTO pwg_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Ma wavinena ivonapotei bo, “Taku kawaku kegha.” Ma Yesu ivona bo, “Tam kuvonavaghata da kawam kegha. ");
INSERT INTO pwg_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Vonavaghata da kakawam miikovi. Ma tomowina wekarakava yavata komakamakai na ke kawam. Kuvi sisiya bubuna.” ");
INSERT INTO pwg_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Ma wavinena ivona bo, “Bada, wekarakava akovim da tam na peroveta. ");
INSERT INTO pwg_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Akii kaekiki mau na weni koyana tepanai ivovokavakavara, ma tami Jiu dami kovonavona da Jerusalem kamonai kava kata vokavakavara.” ");
INSERT INTO pwg_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Yesu ivona bo, “Wavine, kevi tumaghaneku. Mara epipisi da Mamai God ke weni koyanai bo Jerusalem kamonai kona vokavakavari. ");
INSERT INTO pwg_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Ma tami Sameriya dami ke kotakovi da iyi kovovokavakavari ma tokai na kakovi, iyamna God ina keta da wawaya ini yawasisi na Jiu damkai gwabikiiyai. ");
INSERT INTO pwg_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Ma marana ipipisi da inekiibau da vitumaghana damsi Kanuma Vovokaravinai ma vonavaghata tepanai Mamai ina vokavakavari, iyamna wawaya ekwekwisi da nakanani ina vokavakavara kurina. ");
INSERT INTO pwg_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","God na kanuma, tuna kubiine iyavo kava ina vovokavakavari na Kanuma ina rewapanai ma vonavaghata tepanai kava ina vokavakavari.” ");
INSERT INTO pwg_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Ma wavinena ivona bo, “Akovi da mara sago God Ina Vivinevine Wawayina ina pisi. Ina pisi na bera kudubina kurikai ini debei.” ");
INSERT INTO pwg_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Ma Yesu ivona bo, “Taku aisisiya kurim na vaghina wawayiku.” ");
INSERT INTO pwg_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Ma ivivi sisiya kamonai na Yesu kana kivikivina inekiibau ma ivi deyei da wavine sago yavata ivivi sisiya. Ma ke sago iti tarakiiyanei bo, “Wavine, avi kekayokayowei?” Bo, “Bada, avi kubiine weni wavinena yavata koisisiya?” ");
INSERT INTO pwg_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Ma wavinena kana okowa kibubuna ikuyowei ma ivovira ku kwanatu da wawaya kurisi ivi sisiya. ");
INSERT INTO pwg_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Kopisi ma tanae, tomowa sago kona kitai. Bera kudubina aberaberai na ivi debei. Tuna na God ina Vivinevine Wawayina, bo?” ");
INSERT INTO pwg_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Vaghina ma damsi kwanatu ikiibutawei ma ibaba inae Yesu kurina. ");
INSERT INTO pwg_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Nani kamonai na kana kivikivina ivonei bo, “Bada, vavai kekani.” ");
INSERT INTO pwg_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Ma ivonapotesi bo, “Taku kaku vavai emakamakai na tami ke kotakovi.” ");
INSERT INTO pwg_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Kana kivikivina ti mani kamosiyai ivi tarakiikiiyana meyesi bo, “Kade, iyi vavai iverei?” ");
INSERT INTO pwg_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Ma Yesu ivona bo, “Kaku vavai na weni. Wawayina ivonataweku na ina kayowana ana berai da bigana ivereku ani koviya. ");
INSERT INTO pwg_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Tami kovonavona bo, ‘Nawaravi ruwamaruwa ma kabiiyago kana mara.’ Avonavonemi da matami ekita, ma ku vao kokita da whiti namada ipoki da bori kana mara inekiibau. ");
INSERT INTO pwg_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Ma wekarakava na bori damsi namada evovovidaburana da i miiya eviiviiya. Ma aviyavisina evovovidaburana na wawaya, ti na iyavo kava yawasa makamakii nonowina eviiviiya. Ma nigu wawayina ma boribori wawayina inuwabiibai. ");
INSERT INTO pwg_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Vonavaghata isisiya da, ‘Sago enigunigu ma sago eboribori.’ ");
INSERT INTO pwg_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Ke kota nigu ma kegha da avonavonatawemi da kona bori ma kona vovidaburana. Wawaya viya biga ghamana iberai ikovi, ma tami na koboribori da i biga iyamna koviiviiya.” ");
INSERT INTO pwg_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Nani kwanatunai Sameriya damsi ipeyari kirakai Yesu ivi tumaghanei, iyamna wavinena ivonesi bo, “Aviyavisina aberaberai na kudubina Yesu ivi debeku.” ");
INSERT INTO pwg_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Tuna kubiine maranai Sameriya damsi ipisi kurina na ivi nowi da yavata ita makai na ivi vaghinei da mara ruwa gwabisiyai imakai. ");
INSERT INTO pwg_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Ma Yesu ina vibeyebeyena kubiine na bade ku tepana koroto ghamana ivi tumaghanei. ");
INSERT INTO pwg_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Damsi wavinena ivonei bo, “Wekarakava kavi tumaghana, ke tam kuta vonekai kubiine, ma takii mani ina sisiya kavi yanei kubiine. Wekarakava kakovi da vonavaghata, tuna na dobu kana Viviyawa.” ");
INSERT INTO pwg_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Mara viruwina murinai Yesu, Saika kwanatuna ikiibutawei ma inae ku Gariri dobuna. ");
INSERT INTO pwg_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Ma namada ivona bo, “Peroveta tuna mani ina dobuwai na wawaya ke ina vokaravei.” ");
INSERT INTO pwg_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Ma inekiibau ku Gariri na Gariri damsi ivi kiikiiwei, iyamna rorova ti na inae ku Jerusalem Pasova kamna kubiine ma Yesu bera ghamaghamasi nani dobunai iberai na matasiyai ikitai. ");
INSERT INTO pwg_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Yesu ivovirame ku Keina kwanatuna Gariri kamonai, rorova nani dobunai okowa iberai da ivi wain. Ma bada ghamana sago na ina kwanatu na Kapeniyam ma natuna igubaga kirakai. ");
INSERT INTO pwg_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Ma badana sisiya ivi yanei da Yesu Judiya ikuyowei ma ivovira ku Gariri. Tuna kubiine inae kurina ma ivi nowi da yavata ita nae da natuna iti yawasi, iyamna gisina kava ma ita rabobo. ");
INSERT INTO pwg_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Yesu tomowina ivonei bo, “Tami ami vitumaghana kegha, ma ami kayowana da bera ma matakira ghamaghamasi matamiyai kona kitai na koni tumaghana.” ");
INSERT INTO pwg_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Ma tomowina ivona bo, “Bada, kevi yaghiyaghina ma natuku ina rabobo.” ");
INSERT INTO pwg_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Ma Yesu ivonapotei bo, “Kenae ma natum ina yawasa.” Tomowina Yesu ina sisiya ivi tumaghanei ma inekuyowei. ");
INSERT INTO pwg_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Inenae ma keta borinai ina bigabiga wawayina ipanani ma sisiya biibiina ivonei da natuna namada iyawasa. ");
INSERT INTO pwg_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Badana ivi tarakiiyanei da mara avai natuna iyawasa. Ma ivonapotei bo, “Raviravi madegha imiimiirivivira na gubagina ikuyowei.” ");
INSERT INTO pwg_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Ma badana inotai da nani maranai Yesu ivonei bo, “Natum ina yawasa.” Tuna kubiine ina rakaraka yavata peyarisi Yesu ivi tumaghanei. ");
INSERT INTO pwg_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Weni berana ghamana na Yesu ina matakira kana viruwa maranai Judiya dobuna ivoterei ma ivovirame ku Gariri. ");
INSERT INTO pwg_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Nani murinai Yesu ighae ku Jerusalem Jiu damsi i kam kubiine. ");
INSERT INTO pwg_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Ma Jerusalem kamonai na toka sago kana vava Betesada, tuna na gari matuketina kana vava ‘Sipu’ ririnai. Ma nani tokana na tupatina miikovi imiiriviviri. ");
INSERT INTO pwg_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Nani gawarinai na koroto ghamana matapotapotasi ma digadigasi ivivi makiiyana. ");
INSERT INTO pwg_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","(-) ");
INSERT INTO pwg_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Ma kamosiyai na sago idigadiga da madegha 38 ikovi. ");
INSERT INTO pwg_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Ma Yesu tomowina ikitai ikenakena na iakovi da tuna namadani kava igubaga na ivona tovoni bo, “Kekayokayowei da kuna yawasa, bo?” ");
INSERT INTO pwg_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Ma digadigana ivonapotei bo, “Bada, ke sago iyai da iti viteku ku toka ita tereoruweku maranai okowa isewasewai. Aberabera tovoni da atoru na wawaya maghinoku epapapari.” ");
INSERT INTO pwg_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Ma Yesu ivonei bo, “Kevomiiri, am kepana kekavari ma kuna baba.” ");
INSERT INTO pwg_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Yaghiyaghinai tomowina iyawasa, ina kepana ikavari ma ibaba. Weni berana na viyakam maranai itupuwa. ");
INSERT INTO pwg_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Tuna kubiine Jiu babadisi tomowina ivonei bo, “Karako na viyakam marana ma vonaviyoyovana kuvi kiigiiyei da am kepana kukavari.” ");
INSERT INTO pwg_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Ma ivonapotesi bo, “Wawayina ivivi yawasiku na ivoneku bo, ‘Am kepana kekavari ma kebaba.’” ");
INSERT INTO pwg_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Babadisi ivi tarakiiyanei bo, “Iyi ivonem da am kepana kuta kavari ma kuta baba?” ");
INSERT INTO pwg_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Tomowina ke itakovi da iyi ivi yawasi, iyamna Yesu namada ionagha da koroto ghamana ku kamosi irui. ");
INSERT INTO pwg_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Nani berana murinai Yesu Taparoro Numana kamonai tomowina ipanani. Ma ivonei bo, “Kekitai, kuyawasa. Bera beroberosi kevoterei. Ke kuna voterei na nuwapoya ghamanakina ina tupuwa kurim.” ");
INSERT INTO pwg_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Vaghina ma tomowina inae ma Jiu babadisi kurisi ivi mamatara da wawayina ivi yawasi na Yesu. ");
INSERT INTO pwg_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Ma Yesu weni berasi iberaberai viyakam marasiyai, tuna kubiine Jiu babadisi ivi karei da ivivi tupaketowanei. ");
INSERT INTO pwg_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Ma Yesu ivonesi bo, “Aku Mamai mara nonowa ebigabiga, tuna kubiine taku bade nakanani ana biga.” ");
INSERT INTO pwg_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Weni sisiyina kubiine na Jiu babadisi ivivi paparana kirakai da ita kiivunui. Viyakam marana kana sisiya bagibagina ivi kiigiiyei ma ke tuna kava, ma bade ivonavona da God na ina Mamai vaghata, nakanani ma God yavata iti yavayavatesi. ");
INSERT INTO pwg_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Yesu, Jiu babadisi ivonesi bo, “Vonavaghata avonavonemi da God Natuna ke kovokovoghina da ina kina kava ina kayowana ina berai. Aviyavisina ekitakitai da ina Mamai eberaberai na tuna bade nakanani ina berai. Mamai ina berai na bade Natuna ina berai. ");
INSERT INTO pwg_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Ma Mamai Natuna nuwanuwana ivii kirakiiyei, tuna kubiine aviyavisina eberaberai na kudubina ini debei kurina. Vonavaghata da karakava matakira ghamaghamasi viya ini debei Natuna kurina da ina berai na ke weni matakirina nakanani. Kona kitai na koni deye kirakiiyei. ");
INSERT INTO pwg_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Ikikava Mamai eberaberai da wawaya raborabobosi evovomiiri ma yawasa evereveresi, bade nakanani Natuna iyavo kava ekayokayowesi na yawasa ina veresi. ");
INSERT INTO pwg_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Ma bade Mamai wawaya ke ini tupaviraviresi, iyamna nani rewapanina kudubina ivi damani Natuna kurina da tuna wawaya ini tupaviresi da meni tusi biibiisi ma meni tusi beroberosi. ");
INSERT INTO pwg_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Ivi damani da wawaya ikikava Mamai evovokaravei na bade nakanani Natuna ina vokaravei. Ma wawaya iyavo kava Natuna ke ina vokaravei na idebe meyesi da bade ina Mamai yavata ke ita vovokaravei, iyamna Mamai, Natuna ivonatawei.” ");
INSERT INTO pwg_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Vonavaghata avonavonemi, iyavo kava aku sisiya iyanei ma wawayina ivonataweku itumaghanei na yawasa makamakii nonowina namada iviiya ma God ke ini wavusi ma bade kovogha ke ina veresi. Ti damsi na rabobo ketana ivoterei ma idamana yawasa ku ketana. ");
INSERT INTO pwg_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Vonavaghata avonavonemi, marana epipisi na gisina kava ina nekiibau da wawaya kanumisi raborabobosi na God Natuna gamona ini yanei. Ma iyavo kava ini yanei na yawasa ina panani. ");
INSERT INTO pwg_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Ikikava Mamai gwabinai yawasa ekiikiibau na iberai da bade nakanani Natuna gwabinai yawasa ekiikiibau. ");
INSERT INTO pwg_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Ma rewapana kudubina iverei da wawaya ini tupaviraviresi, iyamna tuna na Wawaya Natusi. ");
INSERT INTO pwg_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Aviyavisina wekarakava avonemi na ke koni deyei. Marana epipisi da raborabobosi kii dogo kamosiyai ma gamona ini yanei, ");
INSERT INTO pwg_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","na kii dogo ina kiibutawei. Wawaya iyavo kava bera biibiisi iberaberai na ina vomiiri da yawasa makamakii nonowina ina viiya. Ma iyavo kava berabero iberaberai na ina vomiiri da vitupavira ma wavu ina viiya.” ");
INSERT INTO pwg_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“Taku ke kovokovoghina da ina kiku kava bera ana berai. Aviyavisina God ina voneku na ani yanei ma wawaya ani tupaviresi. Ma aku vitupavira na vonavaghata tepanai, iyamna ke taku mani aku kayowana ata beraberai ma Wawayina ivonataweku, tuna ina kayowana aberaberai.” ");
INSERT INTO pwg_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Taku mani ani mamatareku da taku iyai na ke konakovi da aku sisiya na vonavaghata bo kegha. ");
INSERT INTO pwg_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Ma Wawaya sago kubiiku imamatara da taku na iyai ma akovi da ina sisiya na vonavaghata. ");
INSERT INTO pwg_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Ma kana viruwa na ami yonayona wawayisi kovonatawesi Jon Babataito kurina ma tuna vonavaghata ivi mamatarei kurimi. ");
INSERT INTO pwg_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Ma wawaya dobuwai ini mamatara kubiiku na ke aku kayowana ghamana. Ma tami kubiimi Jon ivi mamatara na aisisiyei da tami yawasa kota panani. ");
INSERT INTO pwg_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Jon tuna nakanani ma rampa karakaratina ere yaseganina. Ma tami mara tupona nani yaseganina kokayowei da kovi nuwabiibiiyei. ");
INSERT INTO pwg_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Ma vimamatara kana viaroba idebei da taku na iyai. Ma tuna iyamna irakata kirakai, ke nakanani ma aviyavisina Jon ivi mamatarei kurimi. Bigasi aku Mamai ivereku da aberaberai na imamatara kubiiku da Mamai ivonataweku. ");
INSERT INTO pwg_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Ma Mamai tuna yavata imamatara kubiiku. Ma kegha da tami ke meyani gamona koti y