﻿USE sofia;
DROP TABLE IF EXISTS sofia.puu_vpl;
CREATE TABLE puu_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES puu_vpl WRITE;
INSERT INTO puu_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Mundumbe Tofile, batu bapwele bamamaange urende mambu amamalabene va ghari etu. ");
INSERT INTO puu_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Bamarende nane dimatutsingululu na bambedji abamalabe na misu, vane dibandu, na abamaveghu mufune ulonze musamu Nzambi. ");
INSERT INTO puu_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Nyimalabe yi diwelimine mewami, mu rombe burange mu motsu amamavyoghe ubongile va dibandu, mu wusonighile dyoni, mundumbe Tofile. ");
INSERT INTO puu_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Nyighurendili mambu meni, mumbari wukedjabe yi malongi ame wumadile mangenze. ");
INSERT INTO puu_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Mu temu adji Yirode amabilaange kaghe dji Sudé, wukebe muvaghulitsi paghu amanengulungu Sakari. Amabe mu dibuli di bavaghulitsi ba paghu di Abya. Mughatsi andi Lisabete, amabe mu kule dji Arone. ");
INSERT INTO puu_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Sakari na mughatsi andi, bamabangaange basungeme va wusu Nzambi na bamaghobisaange mighaghe myotsu na marume motsu ma Fumu. ");
INSERT INTO puu_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Tumbe basamabe na baane mumbari Lisabete amabe yingume, na djowubotsu babedji mbé bake binunu. ");
INSERT INTO puu_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Mwa yilumbu Sakari amasalilaange Nzambi, mumba temu dyandi dibuli di bavaghulitsi ba paghu mbé djimatole. ");
INSERT INTO puu_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Mu nzalusulu bavaghulitsi ba paghu, Sakari akesolu mu ukote o ghari yibuku ayi syeme yi Fumu mu yenyenze bime bi mbunge djiboti. ");
INSERT INTO puu_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","O dulombili, yinombu yi batu yikesambilaange mu temu adji Sakari amawendile mu uyébinyenze. ");
INSERT INTO puu_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Vane-vane, yanze yi Fumu yikesundughe na yikelabene na Sakari wune ghari ndaghu, diteli o mabaale ma yivaghululu yi paghu. ");
INSERT INTO puu_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Ave amayilabile, akeregheme na akebe na ghome djineni. ");
INSERT INTO puu_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Tumbe yanze yikemutsingule rye: «Sakari uyabe na ghome, mumbari Nzambi amawulu dusambu dwaghu. Mughatsi aghu Lisabete owuburile mwane dibaale, na wumulughe San. ");
INSERT INTO puu_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Mwane eni obe nzangu o murime aghu na bapwele wandi bobase na nzangu mu duburu dwandi. ");
INSERT INTO puu_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Mumbari obe musatsi wuneni wu Fumu. Djandi, aghonwaangange malamu amelanzi. Ne akeburu, obasu na Yinyuni Yisyeme. ");
INSERT INTO puu_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Oghabuse mirime mipwele mi bise Yisrayele ombu Fumu Nzambi owu. ");
INSERT INTO puu_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Orughe nane yilumbi yi Nzambi abasu na Yinyuni na mangolu ma Eli mubiyitsi Nzambi. Oghabuse dinonge va ghari baane na batadji bowu na obeghe bango dilenze o dighobe di batu abasungeme. Otsonzighe mukute awube uwelimine mu uduke Fumu.» ");
INSERT INTO puu_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Tumbe Sakari akewivule yanze rye: «Tsyeni nyudjabile yiri dyoni dingenze? Mumbari menu na mughatsi ami tuke binunu.» ");
INSERT INTO puu_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Yanze yike muwaghule rye: «Menu, la Ghabiryele, nyidji va wusu Nzambi na nyimusalili, atsinzindighe mu uyighuvosile na mu udjabise musamu wuboti. ");
INSERT INTO puu_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Kaboghu wube dibabe, kwange na temu adji mambu meni molabinine, mumba wughasinge mambu ame nziwutsingule, amodughusu mu temu adjimasikughu.» ");
INSERT INTO puu_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Vane yanze amavosilaange nandi, abamabe o dulombili bamavivaange Sakari, bakekambulu mu yitsingu yandi o ghari ndaghu Nzambi. ");
INSERT INTO puu_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Na epali, asamabwérunguse wuvosile batu, na djowu baketase bwena Sakari amadile dulasu o ghari ndaghu eni. Akebavosilaange yike na milembu mumbari mbé ake dibabe. ");
INSERT INTO puu_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Sakari na emani bilumbu byandi byusalile Nzambi, akeghabughe o ndaghu andi. ");
INSERT INTO puu_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Mu temu adjimadukaange, mughatsi andi Lisabete akabe na dimi na akesweme o ndaghu andi mu miweli miranu. Akevosaange rye: ");
INSERT INTO puu_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","«Labanu yese ayi Fumu amalase mu menu, amaghusule yisoni yami va wusu batu botsu.» ");
INSERT INTO puu_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Mu muweli awu musyamunu wu dimi di Lisabete, Nzambi akesindighe yanze Ghabiryele o musyengi Nasarete mu yinange yi Ngalile. ");
INSERT INTO puu_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Wune, wumabe tsyemi dji mughetu omabe yibande yi dibaale dimanengulungu Sosefe, awu amabe mu yifumbe yi Davide. Na tsyemi eni, dine dyandi Mari. ");
INSERT INTO puu_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Yanze yikerasune Mari o ghari ndaghu andi na yikemusimbe rye: «Mbolwa Mari! Fumu adji naghu amawubase na myule.» ");
INSERT INTO puu_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Mari amaregheme na akekambulu mu munongu mbolu adji yanze amamuveghe, na vane-vane, akekéwivulaange divindughulu di mbolu eni. ");
INSERT INTO puu_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Yanze yikemutsingule rye: «Wuyalabe ghome Mari, wumadile yese yi Nzambi. ");
INSERT INTO puu_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Na mapape, wube na dimi na wubure mwane dibaale awulughe Djesu. ");
INSERT INTO puu_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Djandi obe muneni na onengulu Mwane Nzambi-Pungu. Fumu Nzambi omubyatse kaghe nane Davide kule andi abilaange. ");
INSERT INTO puu_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Na djandi obyamaange mutubu na mutubu mu mukute Sakobe, na bukaghe bwandi bughobe tena disukusulu.» ");
INSERT INTO puu_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Mari akewivule yanze rye: «Dyoni tsyeni dyurungulile ubile, menu awu nyikivu tsyemi?» ");
INSERT INTO puu_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Yanze yike muwaghule rye: «Yinyuni Yisyeme yurughe mu ndedju na mangolu ma Nzambi-Pungu mowughumbe. Ladibandu mwane awubure wube wusyeme, onengulu Mwane Nzambi. ");
INSERT INTO puu_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Lisabete yiburu yaghu ne nane ake yinunu, djawandi ekelisi ubure mwane andi dibaale. Djandi awu bamanengilaange yingume ake na dimi di miweli misyamunu. ");
INSERT INTO puu_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Mumbari vagha dyambu divure ombu Nzambi.» ");
INSERT INTO puu_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Mu dyoni, Mari akevose rye: «Nyidji musatsi Fumu, kaboghu motsu madughusu nane wutsivosile.» Na yanze yikemusile. ");
INSERT INTO puu_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Mu bilumbu abimadukaange, Mari amareleme nowende mbangu-mbangu o mikongu o musyengi yinange yi Sudé. ");
INSERT INTO puu_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Anokote o ndaghu Sakari, akesimbe Lisabete. ");
INSERT INTO puu_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Lisabete anowulu mbolu Mari, mwane andi akekunge o ghari modji andi. Vane-vane, Lisabete akebase na Yinyuni Yisyeme. ");
INSERT INTO puu_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Na akebwaghe mughamu wuneni novose rye: «Mari, Nzambi amawupuyile myule wuvyoghulile baghetu botsu na mwane wandi amadile myule o modji aghu!» ");
INSERT INTO puu_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Mu dyoni, Lisabete akewivule rye: «Tembusu menu yi nyivu, mulabene na ngudji Fumu ami? ");
INSERT INTO puu_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Labati, ave nyiwululu mbolu aghu, mwane nosangughe na nzangu o modji ami. ");
INSERT INTO puu_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Mari, myule ombu ndedju awutsisinge mambu amanziwulu mumbari Fumu omadughusu nane amavosile.» ");
INSERT INTO puu_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Mari akevose rye: «Nyuyitsaange Fumu, mu monyu ami wotsu, ");
INSERT INTO puu_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","na nyibase na nzangu mu Nzambi, Mughobutsi ami. ");
INSERT INTO puu_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Nyudivaghanga, mumbari amatsune tembusu menu musatsi andi. Kaboghu, ubandile na muni, kule na kule bondengilaange mughetu myule, ");
INSERT INTO puu_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","mumbari Nzambi Mangolu amapayile mambu amaneni. Dine dyandi disyeme, ");
INSERT INTO puu_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","na yingebe yandi yubangage kule na kule mu djowu abemudumi. ");
INSERT INTO puu_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Amalase mambu maneni na mangolu mandi, amapanze bango dunangu, ");
INSERT INTO puu_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","amarambuse bakaghe mu bitsighe byowu, na amabyatse abakesunze. ");
INSERT INTO puu_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Amabase maboti ombu bango nzale, na akeghabuse bisine myowu na myowu. ");
INSERT INTO puu_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Amawamuse Yisrayele, musalitsi andi, asamalibene ulase yingebe yandi, ");
INSERT INTO puu_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","nane amavangenine na bakule betu, ombu Aberaame na bateghule bandi mutubu na mutubu.» ");
INSERT INTO puu_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Mari akevyose miweli miryeru ombu Lisabete, mbana akeghabughe o dimbu dyandi. ");
INSERT INTO puu_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Temu ubure djinotole, Lisabete akebure mwane dibaale. ");
INSERT INTO puu_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Biburu na bambatsi ba dimbu na bédjabi bwena Fumu amalase yingebe yandi ombu Lisabete, bakeyésaghe va mosi nandi. ");
INSERT INTO puu_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Yisambwali yi bilumbu yinovyoghe, ayi munane, bamarughe mu yirebe mwane na bamaronde umunengile Sakari nane tadji andi. ");
INSERT INTO puu_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Tumbe ngudji andi akevose rye: «Nesi, onengulu San.» ");
INSERT INTO puu_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Batu beni bakemuwaghule rye: «Mu biburu byaghu, vagha mutu amanengulungu mu dine dyeni dine.» ");
INSERT INTO puu_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Na bamaghebule tadji andi mu muwivule tsyeni onengilile mwane andi. ");
INSERT INTO puu_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Sakari akevonde yasi yi dusimbi na akerende rye: «San la dine dyandi.» Na botsu bamakambulu. ");
INSERT INTO puu_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Vane-vane, mbembu andi djikepandughe, akebande wuvose na akedodise Nzambi. ");
INSERT INTO puu_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Ghome djimabase mu botsu abamabe mu mighule. Mu mikongu myotsu mi Sudé, bakevosaange bilombi bi mambu meni. ");
INSERT INTO puu_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Botsu abamadiwulu, bakedikelulaange: «Munongu mwane yi obe?» Dingenze, Fumu amabe nandi. ");
INSERT INTO puu_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Sakari, tadji mwane eni, anobe abasu na Yinyuni Yisyeme, akebighe rye: ");
INSERT INTO puu_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","«Duyitsu ombu Fumu Nzambi dji Yisrayele. Djandi, amayilingule noghobule mukute andi. ");
INSERT INTO puu_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Amatutindile Mughobutsi mangolu va ghari bateghule ba Davide, musalitsi andi, ");
INSERT INTO puu_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","nane amavosile va kale mu babiyitsi bandi basyeme. ");
INSERT INTO puu_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Mutudjeyise ombu bavinitsi, notukawule va makake ma bambeni betu. ");
INSERT INTO puu_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Anane amalasile yingebe yandi ombu baghulu betu, akerangimine yivighu yandi yisyeme. ");
INSERT INTO puu_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Anane Nzambi amaghanine kaka ombu Aberaame tadji etu, ");
INSERT INTO puu_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","mu tugharusu wumusalile na mangolu, payi tumaghobughe va makake ma bavinitsi betu. ");
INSERT INTO puu_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Tukebangaange tuwelimine na tusyeme va wusu andi, bilumbu byotsu bi monyu etu. ");
INSERT INTO puu_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Na ndedju mwane kali, unengulungu “Mubiyitsi wu Nzambi-Pungu”, mumbari, uyenewendaange va wusu Fumu mu tsonzighe manzile mandi, ");
INSERT INTO puu_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","udjabise mukute andi dughobutsu dwandi na dutandu du mabi mandi. ");
INSERT INTO puu_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Yine, Nzambi mu yingebe na durondu dwandi, osunduse mu djetu, yidjalale yandi ayivu nane dimengi di nyangu adiruyili o djulu. ");
INSERT INTO puu_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Oyimonitse botsu abetsani otsi piseme na mu yidumbitsi yi dufu, mu tusungighe mu nzile duvotsu.» ");
INSERT INTO puu_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Mwane eni amaneghaange nowarange mu Yinyuni. Amatsanaange mu bakumu, kwange na yilumbu ayi amapalile va ghari mughungi wu Yisrayele. ");
INSERT INTO puu_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Ave Sesare Okisete amabyamilaange nane kaghe dji Rome, amarume dutalu du batu mu malongu mandi motsu. ");
INSERT INTO puu_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Sanzeme eni djiteghe, djimabile ave Kirinuse amabile yidjeti yi yinange yi Siri. ");
INSERT INTO puu_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Batu botsu bamerendusungu kale mutu o dyandi dimbu. ");
INSERT INTO puu_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Sosefe djawandi, amaghusughe yinange yi Ngalile o musyengi Nasarete noghabughe o musyengi kaghe Davide awinengulu Beteleme, o yinange yi Sudé. Mumbari amabe muteghule andi. ");
INSERT INTO puu_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Akeyerendusu djawandi na Mari yibande yandi omabe na dimi. ");
INSERT INTO puu_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Ave bamabile wune Beteleme, temu Mari djubure djiketole. ");
INSERT INTO puu_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Akebure mwane andi tsomi wu dibaale, akemupote mu tsande nomusilighe o ghari yililu yi bindombu, mumbari basamadile yitsighe o ndaghu beni. ");
INSERT INTO puu_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Wune yari yeni, vamabe bakelitsi ba bindombu bamavyosaange mikolu o kumu mu ukelisaange mighambe myowu. ");
INSERT INTO puu_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Yanze yi Fumu yimalabene nowu na yidjalale yi kembu andi yikebaghumbe. Bakebase na ghome. ");
INSERT INTO puu_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Tumbe yanze yimabasiyighe mirime rye: «Duyabe na ghome, mumbari nyidubeyili musamu wuboti awulase batu botsu ubwedji. ");
INSERT INTO puu_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Na mukolu ewuwu, o musyengi Davide Mughobutsi amaduburulu, djandi la Kirisete, Fumu. ");
INSERT INTO puu_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Lanu yilimbe ayi dumudjabile: durasunu mwane kali wupotu tsande na wusilughu o ghari yililulu yi bindombu.» ");
INSERT INTO puu_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Vane-vane, yinombu yi byanze bi djulu bimalabene. Bikedodisaange Nzambi rye: ");
INSERT INTO puu_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","«Bundumbe ombu Nzambi odjivu o djulu. Duvotsu ombu bise tsi abe djandi erondi.» ");
INSERT INTO puu_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Byanze binobasile mu ughabughe o djulu, bakelitsi ba bindombu bamatsingusene: «Twendyanu teno Beteleme mu uyélabe dyambu diboti adimarughe wune adi Fumu amatudjabise.» ");
INSERT INTO puu_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Bamawende maswasu, na bamarasune Mari na Sosefe na mwane kali wusilughu mu yililu yi bindombu. ");
INSERT INTO puu_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Bakelitsi ba bindombu banomulabe, bakevose ame yanze amabatsingule mu mwane eni. ");
INSERT INTO puu_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Botsu abamawulu mo bakelitsi beni bamavose, bamasutu. ");
INSERT INTO puu_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Tumbe Mari amaghangise mambu meni motsu nomarangiminaange temu tsyotsu. ");
INSERT INTO puu_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Vane-vane bamayeneghabughe, bakenedodisaange nowimbilaange mu uyitse Nzambi mu motsu ame bamawulu nolabe. Mumbari motsu mamalabene nane yanze amabatsingulile. ");
INSERT INTO puu_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Yisambwali yi bilumbu na yivyoghi, ayi munane, bamarebe mwane. Bakemulughe Djesu, nane yanze amabatsingulile ne ngudji andi akabe na dimi. ");
INSERT INTO puu_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Na yilumbu yi dulyomusu yitoli nane mughaghe Moyise wivosili, Mari na Sosefe bamabeghe mwane o Serusaleme o ndaghu Nzambi mu uyémuwakise ombu Fumu. ");
INSERT INTO puu_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Dibandu yi dimavaghulungu nane? Mumbari direndu mu mughaghe Fumu rye: «Tsomi tsyotsu tsi babaale tsyuwakusungu ombu Fumu.» ");
INSERT INTO puu_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Na bovaghulaange «makunde mabedji vo mabembi mabedji» nane mughaghe Fumu wirumini. ");
INSERT INTO puu_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Vane Serusaleme, vamabe mutu dine dyandi Simewu. Yinyuni Yisyeme yimabe nandi. Amabe asungeme na amadumange Nzambi. Amavivaange dubembughu du baane ba Yisrayele. ");
INSERT INTO puu_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Yinyuni Yisyeme, yimamutsingule bwena agholefu payi akalabe Kirisete, Yibyatsi yi Fumu. ");
INSERT INTO puu_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Simewu amabeghusu na Yinyuni mu uwende o ndaghu Nzambi. Va temu adji tadji na ngudji, bamarule na Djesu mu udughusu marume ma mughaghe. ");
INSERT INTO puu_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simewu amabonge Djesu va makake mandi. Amayitse Nzambi novose rye: ");
INSERT INTO puu_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","«Fumu tsyesili musalitsi aghu uwende mu duvotsu nane wumavosile. ");
INSERT INTO puu_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Nyimalabe Mughobutsi aghu umatutindile, na misu mami. ");
INSERT INTO puu_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Dughobutsu dwaghu adu wumatsonziyile batu botsu. ");
INSERT INTO puu_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Djandi obe yidjalale ayudughunu mu malongu motsu, na obe bundumbe bu mukute Yisrayele.» ");
INSERT INTO puu_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Tadji na ngudji bakekambulu mu motsu ama Simewu amavosaange mu mwane eni. ");
INSERT INTO puu_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simewu anobaveghe myule, amalubuse Mari ngudji Djesu rye: «Mwane eni wuwu obe tonu dji dufundusu du bapwele vo dji dughobutsu du bamosi o Yisrayele. Obe yilimbe yi Nzambi ayi bapwele bobuse. ");
INSERT INTO puu_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Tumbe ndebeni, munyongu wuneni wubembe murime aghu. Na matase ma batu molabene kengili va ghari botsu.» ");
INSERT INTO puu_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Vamabe yinunu yi mughetu, abangaange mubiyitsi dine dyandi Ane. Mwane Fanwele mwise yibandu yi Asere. Amatsane yisambwali yi bilime na mulumi andi omamuwele vane bungebi. ");
INSERT INTO puu_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Ane asyalilaange mukwili, amatsanaange pinze tena ave amatolisile yinane yi maghumi na bilime bine (84). Asamakakunungu na ndaghu Nzambi mu usalaange nyangu na mukolu, mu uwarilaange nzale nosambilaange. ");
INSERT INTO puu_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Anoyitole vane temu eni, amabande uyitse Nzambi. Na djandi amavosilaange mu mwane eni ombu botsu abamavivaange yi Nzambi akeghobule Serusaleme. ");
INSERT INTO puu_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Biburu bi Djesu banomane udughusu motsu ame mughaghe Fumu wumarumange, bamaghabughe na Djesu o yinange yi Ngalile o yari yi musyengi wu Nasarete. ");
INSERT INTO puu_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Mwane amabangughaange nowaraange. Amabe aweele, na yese yi Nzambi yimabe nandi. ");
INSERT INTO puu_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Kadi yilime, biburu bi Djesu bamawendaange o Serusaleme o mumengu Pake. ");
INSERT INTO puu_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Djesu anobe na dighumi na bilime bibedji, mu yuku yowu bamayenemubeghaange nowu. ");
INSERT INTO puu_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Na mumengu wisuki, bakene ghabughe, Djesu akesyale o Serusaleme. Tumbe tadji na ngudji basamadjabe. ");
INSERT INTO puu_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Bamatase yiri tangudji Djesu amabe nowu mu yinombu. Va temu tsisighe, bamabande umurombe va ghari biburu na bambatsi bowu. ");
INSERT INTO puu_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Dibila bwena basamamulabe, bakeghabughe o Serusaleme mu uyenemurombe. ");
INSERT INTO puu_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Bilumbu bibedji binovyoghe, ayimuryeru, bamamurasune o ndaghu Nzambi atsane va ghari milonzi mi mighaghe. Amabaghulungu nobawivulaange bivu. ");
INSERT INTO puu_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Botsu abamamuwulungu bamasutu mu dyele na mu kabusulu tsyandi. ");
INSERT INTO puu_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Ave ngudji na tadji andi bamamulabile, bamasutu, na ngudji amamuwivule rye: «Mwane ami, dibandu yi wutsituvayile nane? Tadji aghu na menu twiwurombi, mbé tumabase na keri.» ");
INSERT INTO puu_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Akebawake rye: «Dibandu yi dwitombili? Dughédjabi yiri temu djimatole, mu usale bisalu bi Tadji ami?» ");
INSERT INTO puu_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Tumbe djowu basamawulu adi amarondaange ubatsingule. ");
INSERT INTO puu_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Mbana amaghabughe nowu o Nasarete, akebadedilaange. Ngudji andi amakelisaange mambu motsu o ghari murime andi. ");
INSERT INTO puu_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Na Djesu amaneghaange, amabe na dyele, na amabe na yese va wusu Nzambi na va wusu batu. ");
INSERT INTO puu_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Mu dighumi na bilime biranu (15), bi durumu du kaghe dji Rome, Tibere, Ponze Pilate akabe yidjeti mu yinange yi Sudé. Yirode djandi wune akebe yidjeti yinange yi Ngalile. Filipe, mwane ngudji andi amabe yidjeti yi binange bi Yiture na Tarkonite, mbana Lisanyase djandi akebe yidjeti mu yinange yi Abilene. ");
INSERT INTO puu_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Ave Ane na Kayife bamabilaange bivunde bi bavaghulitsi ba paghu, va temu eni, mbembu Nzambi djimatsingulu San, mwane Sakari o kumu. ");
INSERT INTO puu_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Anodjidile, San akenange yinange ayimabe mu mughule mudjambe Sordani, mu yenelubusaange batu rye: «Kalughanu mutsanu na batuswanu. Nzambi odutande mabi menu.» ");
INSERT INTO puu_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Nane direndulu mu dibuku di mubiyitsi Yisayi rye: «Adidi la dyufi di mutu oyighamuyi o kumu rye: Tsonzighanu nzile Fumu na sungighanu manzile mandi. ");
INSERT INTO puu_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Bibususu byotsu byubasusu. Mikongu myotsu na bikundubughe byotsu byudyamusu. Manzile amarekeme mosungughu, na amavu bidune moghulene. ");
INSERT INTO puu_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Na batu botsu bolabe dughobutsu du Nzambi.» ");
INSERT INTO puu_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Yinombu yimawendaange o uyébatusu nandi, akebatsingulaange rye: «Dibure pili nane djenu, anyi amadulubuse urine kabu Nzambi adjiruyi? ");
INSERT INTO puu_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Lasanu mitsanu miwelimine amyulase rye dumakalughe dyele. Duyavose mu djenubeni rye: “Tudji baane ba Aberaame.” Ngenze nyidutsinguli bwena ne na mamani memama, Nzambi orungule ufikulile Aberaame baane. ");
INSERT INTO puu_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Dyumbi dimatsonzughu mu uwangile mwiri mu nganzi. Kaboghu mwiri wotsu awughéburi milunde miboti wuwangu nobwaghu o mudji.» ");
INSERT INTO puu_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Yinombu yimamuwivulaange rye: «Yike tsyeni tuvayile?» ");
INSERT INTO puu_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Akebawaghule rye: «Awu avu na bikutu bibedji akaveghe yimosi oghaane yikutu, na awu avu na bighudji, aghabi wandi.» ");
INSERT INTO puu_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Babolitsi ba lepu, djowandi bamawendaange o uyébatusu na bamawivule San rye: «Mulonzi, ka djetu yiturunguse uvaghe?» ");
INSERT INTO puu_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Akebawaghule rye: «Ave dubongilaange lepu, duyavyosulilaange mu adimaduveghu musughu.» ");
INSERT INTO puu_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Baghore wandi bakemuwivule rye: «Fumu, ka djetu, tsyé tuvayile?» Amabatsingule rye: «Duyabongaange mbongu ombu mutu na biwarile, vo na mfurulu, tumbe singenanu na fute tsyenu.» ");
INSERT INTO puu_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Batu botsu bamabe nzunzubaa na yitu! Mutu-mutu amatase rye tangudji San djandi Kirisete. ");
INSERT INTO puu_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Mbana San akebatsingule rye: «Menu nyidubatisi mu mambe, tumbe mususu awupyoghulile mangolu orughe. Nga nyiwelimine mu unyangule mikudu mi bapondu bandi. Djandi odubatise na Yinyuni Yisyeme na mudji. ");
INSERT INTO puu_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Aghange ngwangu adjivu nane musomu mu dikake dyandi mu ukakesune milunde amiboti na bipupu. Oghukighe milunde amiboti o yisweghulu yandi, tumbe obwaghe bipupu o mudji awughétsimi.» ");
INSERT INTO puu_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","San amalonzaange batu Musamu wuboti na akebawarisa mu mambu mamosi mapwele. ");
INSERT INTO puu_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Vane-vane, San amasyembaange Yirode awu amabe yidjeti mu yinange yi Ngalile mumbari amabonge na akewele Yirodyase mughatsi mwane ngudji andi, dibandu mambu mamosi mabive amamwévaghaange. ");
INSERT INTO puu_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Va djulu motsu mane, Yirode amabwese dibi disusu: amakotise San o tsughu. ");
INSERT INTO puu_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Batu botsu bamayibatusungu, na Djesu wandi akerughe mu uyibatusu. Ave amasambililaange, djulu djikedibughe. ");
INSERT INTO puu_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Na Yinyuni Yisyeme yimaruyile o djulu mu yibaghunu yi dibembi, yimasundughe mu djandi. Dyufi dimawulunu o djulu novose rye: «Wudji mwane ami murime, mu ndedju, nyimasunze durondu dwami dwotsu.» ");
INSERT INTO puu_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Ave Djesu amabandile yisalu yandi, amabe na maghumi-maryeru (30) ma bilime. Batu bamamulabaange nane, mwane Sosefe obangaange mwane Yili. ");
INSERT INTO puu_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Yili adji mwane Matate. Matate adji mwane Levi. Levi adji mwane Meleki. Meleki adji mwane Sanayi. Sanayi adji mwane Sosefe. Sosefe adji ");
INSERT INTO puu_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","mwane Matatyase. Matatyase adji mwane Amose. Amose adji mwane Nawume. Nawume adji mwane Yiseli. Yiseli adji mwane Naghayi. Naghayi adji ");
INSERT INTO puu_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","mwane Mate. Mate adji mwane Matatyase. Matatyase adji mwane Semeyine. Semeyine adji mwane Sodeke. Sodeke adji mwane Sode. ");
INSERT INTO puu_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Sode adji mwane Sowanane. Sowanane adji mwane Resa. Resa adji mwane Sorobabele. Sorobabele adji mwane Salatyele. Salatyele adji mwane Neri. Neri adji ");
INSERT INTO puu_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","mwane Meleki. Meleki adji mwane Adi. Adi adji mwane Kosame. Kosame adji mwane Lemadame. Lemadame adji mwane Eré. ");
INSERT INTO puu_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Eré adji mwane Djesu. Djesu adji mwane Lyesere. Lyesere adji mwane Sorime. Sorime adji mwane Matate. Matate adji mwane Levi. ");
INSERT INTO puu_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Levi adji mwane Simewu. Simewu adji mwane Suda. Suda adji mwane Sosefe. Sosefe adji mwane Soname. Soname adji mwane Lyakime. ");
INSERT INTO puu_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Lyakime adji mwane Meleya. Meleya adji mwane Mena. Mena adji mwane Matata. Matata adji mwane Natane. Natane adji mwane Davide. ");
INSERT INTO puu_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Davide adji mwane Djese. Djese adji mwane Sobede. Sobede adji mwane Bwase. Bwase adji mwane Sala. Sala adji mwane Nasone. ");
INSERT INTO puu_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nasone adji mwane Aminadabe. Aminadabe adji mwane Adimine. Adimine adji mwane Areni. Areni adji mwane Serome. Serome adji mwane Farese. Farese adji mwane Suda. ");
INSERT INTO puu_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Suda adji mwane Sakobe. Sakobe adji mwane Yisaake. Yisaake adji mwane Aberaame. Aberaame adji mwane Tera. Tera adji mwane Nakore. ");
INSERT INTO puu_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nakore adji mwane Seruke. Seruke adji mwane Raku. Raku adji mwane Faleke. Faleke adji mwane Ebere. Ebere adji mwane Sala. ");
INSERT INTO puu_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sala adji mwane Kayiname. Kayiname adji mwane Arefaghade. Arefaghade adji mwane Seme. Seme adji mwane Nowe. Nowe adji mwane Lameke. ");
INSERT INTO puu_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lameke adji mwane Matuselame. Matuselame adji mwane Yinoke. Yinoke adji mwane Sarede. Sarede adji mwane Maleleyele. Maleleyele adji mwane Kayiname. ");
INSERT INTO puu_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kayiname adji mwane Enose. Enose adji mwane Sete. Sete adji mwane Adame. Adame adji mwane Nzambi. ");
INSERT INTO puu_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Djesu anoghusughe mudjambe Sordani, amabe abasu na Yinyuni Yisyeme, ayimamubeghe o dukange. ");
INSERT INTO puu_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Aghune, Djesu akemangu na Dyabu mu maghumi-mana (40) ma bilumbu. Mu temu eni, asamadji yisalu. Bilumbu byeni binosuke, Djesu akebe na nzale. ");
INSERT INTO puu_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Kaboghu, Dyabu akemutsingule rye: «Payi wudji Mwane Nzambi, kaluse dimani dyédidi dipe.» ");
INSERT INTO puu_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Djesu amamuwaghule: «Bisonu bi Nzambi bivosi rye: “Mutu aghodilaange monyu andi, bu mu dipe.”» ");
INSERT INTO puu_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Dyabu, akemubeghe o djulu mukongu wuneni. Akemulase bulongu bwotsu bu butambe. ");
INSERT INTO puu_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Na Dyabu akemutsingule rye: «Nyuwuveghe bundumbe bwotsu na busine bu malongu meni mame mumbari byotsu bipeghu na nyurungule wuveghe mutu wotsu nane nyirondili. ");
INSERT INTO puu_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Kaboghu, payi wukutumine, byotsu bibi byube abyaghu.» ");
INSERT INTO puu_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Mu dyoni, Djesu akemuwaghule: «Bisonu bi Nzambi bivosi rye: “Yike Nzambi Fumu pinze wukutuminaange na djandi pinze wuyitsaange.”» ");
INSERT INTO puu_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Dyabu akebwémubeghe o Serusaleme, akemusunze o djulu ndaghu Nzambi. Akemutsingule rye: «Payi wudji Mwane Nzambi, kebwaghe kwange no tsi. ");
INSERT INTO puu_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Bisonu bivose yi: “Nzambi orume byanze byandi mu wughaghaange.” ");
INSERT INTO puu_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Na ebwévose rye: “Byanze byeni byuwuwake va makake mowu mumbari dikulu dyaghu dikeduku mu dimani.”» ");
INSERT INTO puu_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Djesu akemughabusile rye: «Bisonu bivosi: “Wuyamange Fumu Nzambi aghu.”» ");
INSERT INTO puu_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Anomumange mu motsu, Dyabu akekakene nandi tena amamwérombile tonu susu. ");
INSERT INTO puu_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Djesu amaghabughe o Ngalile, na mangolu ma Yinyuni Yisyeme. Na didume dyandi dikenyave mu yinange yotsu. ");
INSERT INTO puu_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Amenelonzaange mu mandaghu ma tsambu ma baSwife na batu bakenemudumisaange. ");
INSERT INTO puu_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Djesu amawende o Nasarete awu djandi amabanguyile. Mu yilumbu yuvume yi baSwife, Djesu, mu yuku yandi amakote o ndaghu owu dusambu. Amareleme mu urange Bisonu bi Nzambi. ");
INSERT INTO puu_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Bakemuveghe Dibuku di Bisonu bi mubiyitsi Yisayi. Akedidibule na akelabe yibuku ayimabe yirendu: ");
INSERT INTO puu_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","«Yinyuni yi Fumu yidji mu menu, yimambyatse mu ughabe musamu wuboti ombu bidjaghe. Amanzindighe muyebeluse abango manyoni mu mirime, mu yésamune dudjeghusu ombu bise tsughu, mu ubeluse bidunge na mu udjeyise djowu abekwanu. ");
INSERT INTO puu_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Mu uyisamune yilime yi yese ayi Fumu amaveghe.» ");
INSERT INTO puu_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Va djulu vane, Djesu anomane urange, akedibighe dibuku dyeni, akedighabusile musalitsi na aketsane. Botsu abamabe o ghari ndaghu eni dusambu dji baSwife bakemutsunaange yiswisu. ");
INSERT INTO puu_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Na akebande ubatsingule rye: «Na muni, mambu ma Bisonu byébibi mamadughusu nane dutsiwululu.» ");
INSERT INTO puu_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Mu dyoni, botsu bakemusingisile bumbedji na bakesutu mu mambu ma yese ame djandi amavosaange. Batu beni, bakevosaange rye: «Awuwu tsi mwane Sosefe?» ");
INSERT INTO puu_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Djesu akebawake rye: «Tangudji dumbukile nongu adjivosi bwena, “Mubuyitsi, tsyékebughe ndebeni.” Ta dubwévose: “Tumawulu motsu ame wumavaghe o Kapernawume, tsyémavayi vave o bulongu bwaghu.”» ");
INSERT INTO puu_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Yike Djesu akebwébatsingule rye: «Nyidutsinguli dingenze, mubiyitsi aghérondu o bulongu bwandi. ");
INSERT INTO puu_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Dingenze nyurunguse udutsingule yiri vamabe bakwili bapwele o Yisrayele va temu Eli ave mvule djimasikimine mu bilime biryeru na ngondi yisyamunu na ave dungosu dumabile mu bulongu bwotsu. ");
INSERT INTO puu_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Ne vane Nzambi asamasindighe Eli ombu bakwili botsu, tumbe ombu wumosi awumatsanaange o Sarepete mu bulongu bu Sidone. ");
INSERT INTO puu_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Wubangaange wandi pwele bibedu bi nyámbi o Yisrayele va temu mubiyitsi Elise. Ne nane botsu basamabelughe yike vane Namane mwise Siri.» ");
INSERT INTO puu_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Botsu abamabe o ghari ndaghu eni dusambu dji baSwife bakebase na kabu ave bamawululu mambu meni. ");
INSERT INTO puu_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Batu beni bakereleme bakenemusindilaange vale na musyengi na bakemubeghe va djulu mukongu ave Nasarete amabe arungulu, muyémusindile o mbengi. ");
INSERT INTO puu_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Tumbe Djesu akevyoghe va ghari owu na akenewende. ");
INSERT INTO puu_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Djesu amasundughe o Kapernawume musyengi Ngalile, na akelonzaange mu yilumbu yuvume yi baSwife. ");
INSERT INTO puu_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Batu bakebembu na ndonzulu andi, mumbari amavosaange na durumu. ");
INSERT INTO puu_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Vamabe o ghari ndaghu dusambu dji baSwife dibaale dimabe na yinyuni yibive va ghari owu. Yinyuni yikeghamughe na mangolu: ");
INSERT INTO puu_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","«Aa! Djesu mwise Nasarete, yi witurombi, utsirughe oyitubunge nyidjabi anyi wuvu, Yibyatsu ayimasindughu na Nzambi!» ");
INSERT INTO puu_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Djesu akenyangile yinyuni yeni yibi: «Vole na pale mu mutu ewune!» Yinyuni yike bete dibaale dyeni vatsi va ghari mughungi na yikepale, yisamamuvaghe bwali. ");
INSERT INTO puu_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Batu botsu bakeghangu na ghome na bakevosaange va ghari owu rye: «Posulu adjidji yi! Erumi binyuni bibive na musughe na mangolu na bipali?» ");
INSERT INTO puu_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Na didume di Djesu dikenyave mu yinange yotsu yi Ngalile. ");
INSERT INTO puu_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Djesu anoghusughe o ndaghu dusambu dji baSwife, akewende o ndaghu Simu. Bodji bu Simu abu mughetu amabe na dibaghu dineni, na batu abamabe vane, baketatile Djesu akemubeluse. ");
INSERT INTO puu_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Djesu akebandeme akebembe bodji bu Simu, akerume dibaghu mu usaghughe, na dibaghu dikesaghughe. Na vane-vane mughetu eni akesimbughe akebande ubasalile mu ubaveghe bighudji. ");
INSERT INTO puu_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Wisi unovindeme, botsu abamabangaange na bibedu bi minongu na minongu bakebabeghe ombu Djesu, na akesakighaange mutu-mutu makake na akeyenebabelusaange. ");
INSERT INTO puu_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Binyuni bibi wandi bikenepalaange ombu pwele bibedu noyeneghamughe bwena: «Ndedju wudji mwane Nzambi!» Tumbe Djesu akebarume na bukani na amabaghandisaange uvose, mumbari binyuni byeni bimamudjabaange bwena djandi la Kirisete. ");
INSERT INTO puu_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Na wisi witebuyi, Djesu akeghusughe musyengi eni na akewende ave mbure adjikakunu na batu. Yinombu yi batu yikenemurombaange, banomulabe, bamaronde umusikighe nobuse yiri Djesu akékakughe nowu. ");
INSERT INTO puu_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Tumbe Djesu akebawake rye: «Nyuyésamune Musamu Wuboti wu Bukaghe bu Nzambi o misyengi mimosi wandi, mumbari adine, Nzambi amanzindiyile.» ");
INSERT INTO puu_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Mbana, akewenda mu uyenesamunaange mu mandaghu ma tsambu ma baSwife wune bulongu bweni bu Sudé. ");
INSERT INTO puu_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Yilumbu, Djesu amabe va mughule yilibe yi Senesarete. Yinombu yimaghukume mu uwulu mbembu Nzambi. ");
INSERT INTO puu_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Akelabe matu mabedji va disabu na balobitsi bamasusaange masinge mowu. ");
INSERT INTO puu_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Anolabe bwena ake va mbake batu, akemate mu bwatu bumosi, abumabe bu Simu, na akemuwivule mu kwekise bwatu mwa vale na disimu. Djesu aketsane mu bwatu na akebande ulonze yinombu yeni musamu andi. ");
INSERT INTO puu_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Anomane ulonze, aketsingule Simu: «Kwekise bwatu bwaghu o yitsibe, ndedju na bambatsi baghu, tsyébwaghyanu bambuse benu mu uwabe.» ");
INSERT INTO puu_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simu akemuwake rye: «Fumu, tutsiwélighe wuwabe mukolu wotsu, tughadile nesi yughoke. Tumbe ave wumanzingule nane, yike masinge ngabwaghe mu mambe.» ");
INSERT INTO puu_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Yike, bakebwaghe masinge mowu mu mambe, bakeghaange banyame bapwele na mune masinge meni, vengu wupasighe. ");
INSERT INTO puu_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Bavubitsi beni, bakeghebule bambatsi bowu, abamabe mu bwatu bususu bakibawamuse. Bambatsi beni, banorughe, bakebase matu motsu mabedji na bayame, mamabe beli nodyame. ");
INSERT INTO puu_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Simu Pyere anolabe yimaghe nane yine, akighudume va wusu Djesu na akemutsingule rye: «Wusughe va wusu ami, Fumu, mumbari nyidji mutu mabi!» ");
INSERT INTO puu_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Simu, na botsu abamabe nandi, bakeghangu djobotsu na keri, dibandu pwele banyame abe bamaghaange. ");
INSERT INTO puu_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Keri eni, djimabe wandi mu bambatsi ba Simu, Sake na San, baane ba Sebede. Djesu aketsingule Simu rye: «Uyabe na keri mumbari ubongile na nyangu, wube yike mulobitsi batu.» ");
INSERT INTO puu_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Simu na bambatsi bandi bakeghabuse matu mowu o disimu, bakesile byowu byotsu na bakeduke Djesu. ");
INSERT INTO puu_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Djesu anobe o musyengi mosi, wukurughe dibaale dimabelaange nyámbi. Anomulabe, akighudume va wusu andi, mbami va butambe na akemulembiyile novose rye: «Fumu payi wirondi, ndyomisi.» ");
INSERT INTO puu_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Djesu akesambe dikake akemubembe na akevose rye: «Nyirondi, tsyélyomi.» Na vane-vane, nyámbi djikemughusughe. ");
INSERT INTO puu_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Yike, Djesu akemughandise rye: «Wuyaditsingule mutu. Tumbe wende yékelase ombu yivunde yi bavaghulitsi ba paghu, mbana vaghule paghu dulyomusu adji Moyise amarume mu ulase botsu rye wumabelughe.» ");
INSERT INTO puu_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Didume di Djesu dike bwelaange wunyave. Binombu bi batu bike wukemaange na bakebelusungu mu mali mowu. ");
INSERT INTO puu_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Tumbe Djesu, amabangaange na yufu yukakenaange na batu, mu uyésambilaange pinze. ");
INSERT INTO puu_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Yilumbu Djesu amalonzaange batu. BaFarisi na milonzi mi mighaghe bamabe batsane vane. Djowu abamarughusenaange mu mimbu motsu ma Ngalile na ma Sudé no musyengi Serusaleme. Mangolu ma Fumu Nzambi mamabe mu Djesu mu ubelusaange bibedu. ");
INSERT INTO puu_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Va marughe babaale, banangule yimbolutu mu dusyengi, bamarondaange umusunze va wusu Djesu. ");
INSERT INTO puu_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Tumbe basamadile dikotulu, mumbari yinombu yimabe yineni tena va mune ndaghu. Bakemate o djulu mwanze ndaghu, bakedibule dilute na bakemusunduse mu dusyengi va misu mowu, va wusu Djesu. ");
INSERT INTO puu_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Djesu anolabe yitu yowu, akevose na yimbolutu rye: «Mbatsi ami, mabi maghu mamatandu.» ");
INSERT INTO puu_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Yike baFarisi na milonzi mi mighaghe bakengungurunaange mu mirime myowu: «Mutu awuwu ni oyilenzi Nzambi, anyi orungule utande mabi, patsi Nzambi pinze?» ");
INSERT INTO puu_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Djesu anodjabe matase mowu, akevose rye: «Yi dubile na matase mabive nane mane? ");
INSERT INTO puu_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Dike divure mu uvose rye: “Mabi maghu mamatandu” vo uvose rye: “Releme yenewende”? ");
INSERT INTO puu_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Mumbari dukedjabe yiri Mwane Mutu ane musughe utande mabi ma batu vave butambe.» Mbana akevose na yimbolutu rye: «Nyighutsinguli, releme, bonge dusyengi dwaghu we o ndaghu aghu.» ");
INSERT INTO puu_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Vane-vane amareleme va wusu mughungi, nobonge dusyengi dwandi nowende o ndaghu andi, akenedodisaange Nzambi. ");
INSERT INTO puu_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Mughungi wotsu wuke kambulu, na wukenedodisaange Nzambi novose rye: «Na muni tumalabe mambu maboti ma muvingu!» ");
INSERT INTO puu_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Va djulu motsu mane, Djesu akepale, akelabe mubolitsi lepu dine dyandi Levi atsane va tavule bisalu. Djesu akemutsingule rye: «Nduki!» ");
INSERT INTO puu_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Levi akereleme, akesile byotsu nomuduke. ");
INSERT INTO puu_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Na vane, Levi akemuvayile mulambu o ndaghu andi. Yinombu yi babolitsi ba lepu na batu bamosi wandi bamabe nowu va tavule mu udji va mosi. ");
INSERT INTO puu_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Va ghari owu, baFarisi na milonzi mi mighaghe bakeneningaange na bakewivule badukitsi ba Djesu rye: «Dibandu yi dwilili nonu na babolitsi ba lepu na bavayitsi ba mabi?» ");
INSERT INTO puu_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Djesu akebawaghule rye: «Bango polu, baghaane nzale mubuyitsi, tumbe djowu abebeli. ");
INSERT INTO puu_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Kaboghu, menu, ngarughe mu djowu bana abekelabe yiri basungeme, tumbe dibandu djowu bana abevayi mabi bakekaluse mitsanu myowu.» ");
INSERT INTO puu_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","BaFarisi baketsingule Djesu rye: «Badukitsi ba San na betu, bewarili nzale na besambili; abaghu, udjibédji nonu.» ");
INSERT INTO puu_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Djesu akebawake rye: «Djenu, durunguse wuwimine bambatsi ba yiwetsi bighudji ne nane akivu nowu? ");
INSERT INTO puu_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Tumbe vorughe yilumbu ayi mulumi obarambusulu; mbana avane, borunguse wuwarile nzale na pwile.» ");
INSERT INTO puu_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Djesu akebwébabukile nongu eni djidji: «Wughaa mutu wipasi yirendi mu yikutu ayighone nolonde ayiwulu. Yike evayi nane, yirendi ayighone mbé yighosoghene mu yikutu ayighulu na yikutu yeni yupasighe. ");
INSERT INTO puu_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Wughaa mutu wandi orunguse uwitile malamu maghone mu batsuve aba ghulu. Kaboghu, malamu meni maghone mbé morubise batsuve, na makepumughe. ");
INSERT INTO puu_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Vengu owitile malamu amaghone mu batsuve abaghone! ");
INSERT INTO puu_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Na wughaa mutu mosi wandi omanu malamu amaghulu akeronde wunu amaghone, na yikevayi nane, ovose rye: “Amaghulu mamavyoghe amaghone.”» ");
INSERT INTO puu_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Mu yilumbu yuvume yi baSwife, Djesu akenevyoghaange na badukitsi bandi mu manungi ma putu mu utole o mimbu mamosi. Badukitsi beni, bakenedokulaange putu. Bakenetsisotulaange na bakeyenejangaange. ");
INSERT INTO puu_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Mwa dighuki di baFarisi bakebawivule rye: «Dibandu yi dwivayili mambu amaghandusu “kilikingi” yilumbu yuvume?» ");
INSERT INTO puu_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Djesu akebawaghule rye: «Ayi, dusamaraange mu bisonu bi Nzambi, adi Davide na batu bandi bamavaghe ave bamawululu nzale? ");
INSERT INTO puu_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Davide amakote o ndaghu paghu, akebonge mape amavaghululu Nzambi. Akedji na akemaveghe botsu abamabe nandi. Nenane, yike bu bavaghulitsi ba paghu pinze abamaveghu musughe mu umadji.» ");
INSERT INTO puu_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Djesu akebwétsingule baFarisi rye: «Mwane Mutu djandi, la Fumu yilumbu yuvume.» ");
INSERT INTO puu_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Yilumbu yisusu yuvume yi baSwife, Djesu akekote o ndaghu dusambu mu ulonze. O ghari ndaghu eni, wumabe dibaale dimabe na bubomfi mu dikake di mabaale. ");
INSERT INTO puu_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Milonzi mi mighaghe na baFarisi bamarombaange dyele dyufwengilile Djesu. Kaboghu bamamuketanga mu ulabe yeri obeluse mutu mu yilumbu yuvume. ");
INSERT INTO puu_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Tumbe Djesu, anodjabe matase mowu, aketsingule yibomfi yeni yi dikake rye: «Releme, rughe va wusu botsu!» Akereleme, akerughe. ");
INSERT INTO puu_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Djesu, akewivule milonzi mi mighaghe na baFarisi yeri: «Diwelimine mu mighaghe myenu mu vaghe diboti vo dibi yilumbu yuvume, wughobule monyu mutu vo ughusile wubungene?» ");
INSERT INTO puu_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Anobaghengise djowu botsu, aketsingule yibomfi yeni rye: «Simbule dikake dyaghu.» Akedisimbule, na dikake dyandi dikebelughe. ");
INSERT INTO puu_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Tumbe, milonzi mi mighaghe na baFarisi bakebase na kabu neni, bakewivusunaange rye: «Tsyeni tukedilile Djesu?» ");
INSERT INTO puu_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Mune temu eni, Djesu amamate o djulu mukongu mu uyésambile. Na akevyose mukolu wotsu mu usambilaange Nzambi. ");
INSERT INTO puu_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Na wisi etebuyi, Djesu akenengile badukitsi bandi va mughule andi, akesole va ghari owu dighumi na babedji (12) mu ubalughe Bilumbi. ");
INSERT INTO puu_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Djowu bamabe: Simu awu Djesu amalughe Pyere, Andere ngebi andi, Sake na San, Filipe na Batelemi, ");
INSERT INTO puu_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mati, Tome, Sake mwane Alefé, Simu mungo nyongi bulongu bwandi, ");
INSERT INTO puu_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Sudase mwane Sake na Sudase Yikalyote awu amasumbise Djesu. ");
INSERT INTO puu_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Djesu, anosundughe mukongu na bilumbi byandi, akesikeme va yidesi ave vamabe badukitsi bandi. Yinombu yineni yi batu yimarughesenaange o yinange yi Sudé, o musyengi Serusaleme, na mu misyengi mi Tire na Sidone amimabe mu mughule mubu. ");
INSERT INTO puu_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Botsu, bamarughaange mu uyiwulu Djesu na mu uyidile dubelusu. Akedjeyisaange bamosi wandi abamatsoghusungu na binyuni bibive. ");
INSERT INTO puu_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Yinombu yotsu yimarondaange umubembe, mumbari mangolu mamapalaange mu djandi mamababelusaange. ");
INSERT INTO puu_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Djesu, anoghengise badukitsi bandi, akevose rye: «Ubwedji ombu djenu aduvu bidjaghe, mumbari Bukaghe bu Nzambi buke bwenu. ");
INSERT INTO puu_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Ubwedji ombu djenu aduvu na nzale, mumbari dughukuru. Ubwedji ombu djenu abedwilili, mumbari dureke. ");
INSERT INTO puu_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Ubwedji ombu djenu abedwivinu na batu, abedwiwengulu, abedwisyengu, abedwisanzu novosulu mambu mabi, dibandu Mwane Mutu. ");
INSERT INTO puu_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Mu temu eni, saghanu na yinanu na nzangu, mumbari fute neni djidukelisi o djulu. Anane bakaaghe bowu bamakambisilaange babiyitsi va temu owu. ");
INSERT INTO puu_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Kamune maghughe ma ombu djenu bisine, mumbari dumadile menu maboti. ");
INSERT INTO puu_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Maghughe ombu djenu adumaghukuru, mumbari dube na nzale. Maghughe ombu djenu adwireki na muni, mumbari dube mu dikwili na dulile! ");
INSERT INTO puu_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Maghughe ombu djenu ave batu botsu bodusingisilaange, mumbari anane bakaaghe bowu bamayitsilaange babiyitsi ba mfurulu!» ");
INSERT INTO puu_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","«Tumbe djenu adwikulu nyidutsinguli: Rondanu bambeni benu. ");
INSERT INTO puu_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Veghanu myule ombu djowu abeduloyi; na sambilanu mu djowu abedukwani. ");
INSERT INTO puu_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Payi mutu atsighudimbe mbate mu dibange adi maghetu, muliyili adi mabaale. Payi mutu erondi ubonge yidjungi yaghu, wuyamughandise ubonge yikutu wandi. ");
INSERT INTO puu_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Ghabile botsu abeghuvondi, na payi mutu atsiwubonge yisalu, wuyamusuyighe. ");
INSERT INTO puu_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Vaghanu bambatsi mambu ame dwirondi bakeduvayile. ");
INSERT INTO puu_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Payi dwirondi yike abedurondi, kabusulu yi dwikelisi? Ne bavayitsi ba mabi wandi berondi yike abebarondi. ");
INSERT INTO puu_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Payi dwivayi diboti yike ombu djowu abeduvayi maboti, kabusulu yi dudile? Ne bavayitsi ba mabi wandi bevayi munongu mosi. ");
INSERT INTO puu_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Payi dwisombisi buke djowu aborunguse uduvanine, kabusulu yi dudile ombu owu? Ne bango mabi wandi besombisini, na bevaneseni munongu mosi. ");
INSERT INTO puu_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Tumbe, rondanu bambeni benu na bavayanu diboti, sombisanu abaghaane yime nenane baghorunguse wudughabusile. Fute enu djube djineni na dube baane ba Nzambi-Pungu, mumbari djabeni aboti ombu bango ninge na ombu mimbini. ");
INSERT INTO puu_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Banu na yingebe, nane Tadji enu abile na yingebe.» ");
INSERT INTO puu_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","«Duyasosise na baghodusosise; duyaveghe mbele, na baghoduveghe mbele. Batandyanu, na dutandu. ");
INSERT INTO puu_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Veghanu na boduveghe: bowitile yetsu yiwelimine mu yevi yenu. Yubatughu noghomu tena yuborumughe. Yetsu ayidumaghabile ayine Nzambi odughabile.» ");
INSERT INTO puu_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Djesu akebaveghe nongu: «Yidunge akebeghe yidunge nandi? Nesi, boyetsudeme djowu botsu o yidune! ");
INSERT INTO puu_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Mudukitsi aghovyoghulile Fumu andi, tumbe awu alongu burange, obaghunu na Fumu andi. ");
INSERT INTO puu_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Dibandu yi wilabili yike yiriri mu disu di mbatsi aghu, mba wughélabi dikutu adivu o dyaghu disu? ");
INSERT INTO puu_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Vo tsyeni wutsingulile mwane ngudji: “Mwane ngudji, rughe tuwusuli yiriri ayivu o ghari disu dyaghu”, ndedju awughélabi dikutu adivu o ghari dyaghu disu? Pende nane nde, lérele ughusule dikutu adivu o ghari disu dyaghu, avane ulabe nane wurambusile yiriri ayivu o ghari disu di mwane ngudji.» ");
INSERT INTO puu_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","«Mwiri wuboti wurunguse ubure milunde mibive? Nesi, wughorunguse ubure milunde mibive. Dedi mosi na mwiri wubive wughorunguse ubure milunde miboti. ");
INSERT INTO puu_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Kaboghu, kale mwiri widjabunu mu milunde myandi. Baghédoki tundu mu misumbi, mbanane baghédoki, tsafu wandi mu yifundi. ");
INSERT INTO puu_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Mutu awuboti, epalisi mambu maboti mu ubwedji wu murimandi. Mutu mubi, epalisi mambu mabi mu wubive wu murime andi. Mumbari mu dufunusu du matase ma murime, munu evosili.» ");
INSERT INTO puu_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","«Dibandu yi dwindengilili “Fumu, Fumu!” Mbana dughevayi motsu ame nyidutsinguli? ");
INSERT INTO puu_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Kaboghu, wotsu oyinduki, ewulu mambu mami na emadedili, nyudulase nani abaghunu. ");
INSERT INTO puu_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Adji nane mutu, amarunge ndaghu andi, aketime pwele ne mu dughunge. Nidu djinorughe, mupupile wukeghubene mu ndaghu eni, na djisamakunge mumbari djimarungu burange. ");
INSERT INTO puu_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Tumbe, djandi wune oyiwulu mambu mami na aghemadedili, adji nane mutu awirungi ndaghu va yisyeyi. Ave nyidu djiruyili, mupupile wighubeni mu ndaghu eni na djiberuyi tinde djotsu.» ");
INSERT INTO puu_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Ave Djesu amamani wuvosile motsu mane ombu mughungi, akekote o musyengi Kapernawume. ");
INSERT INTO puu_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Vane, vamabe yivunde yi baghore ayimabe na musatsi andi awu amarondaange pwele. Amabe na ubele wuneni beli nofu. ");
INSERT INTO puu_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Anowulu beranguni Djesu, yivunde yeni akesindighe mwa dikabu di bivunde bi baSwife uyémulende mu uyibeluse musatsi andi. ");
INSERT INTO puu_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","BaSwife beni banotole ombu Djesu, bakemutatile yiri: «Diwelimine wukemuvayile adi djandi evondi. ");
INSERT INTO puu_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Ngenze erondi mukute etu, mumbari djandi amarunge ndaghu etu dusambu.» ");
INSERT INTO puu_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Djesu amawende na batu beni. Banobe bebeli na ndaghu, yivunde yeni akesindighe bambatsi bandi mu uyémutsingule rye: «Fumu, wuyaketsoyise mu utole, mumbari nga nyiwelimine yiri wukekote o ndaghu ami. ");
INSERT INTO puu_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Ladibandu, ngaruyile mebeni ombu waghu. Tumbe tubule yike yighume yimosi na musatsi ami obelughe. ");
INSERT INTO puu_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Mewandi, nyidji otsi durumu du bivunde byami, na mewandi nyirumi baghore abendedili. Payi nyurume wumosi: “Wende!” Akewende. Payi nyunengile wune: “Rughe!” Akerughe. Payi nyurume musatsi ami, yiri “Vaghe yeyi!” Akeyivaghe.» ");
INSERT INTO puu_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Ave Djesu amawululu ame yivunde yi baghore amavose, akemusingisile, akeghelughe ombu yinombu ayimayenemudukaange. Akevose rye: «Nyidutsinguli: ne o bulongu bu Yisrayele, nyikalabaange yitu yineni nane.» ");
INSERT INTO puu_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Bambatsi ba yivunde yeni, ave bamaghabuyile ombu wandi, bakerasune musatsi eni amabelughe. ");
INSERT INTO puu_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Yilumbu ayimaduke, Djesu akewende o musyengi wu Nayine. Badukitsi bandi na yinombu yineni bakenewendaange nandi. ");
INSERT INTO puu_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Banotole va dikotulu di musyengi eni, bakebengunu na batu bamawendaange oyetswighe mvumbi, mwane divingu wu mukwili. Yinombu yineni yi musyengi eni yimabe nandi. ");
INSERT INTO puu_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Fumu, anolabe mukwili eni, akebase na yingebe novose rye: «Wuyalile.» ");
INSERT INTO puu_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Anobambene, akebembe yighare. Abamabe bayitsyete, bakesikeme. Akevose: «Mwane dibaale nyiwurumi, releme!» ");
INSERT INTO puu_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Mwane awumabe wufu, akereleme, aketsane nobande uvose. Djesu akemughabusile ngudji andi. ");
INSERT INTO puu_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Botsu bamaghangu na keri. Bakeyitsaange Nzambi novose rye: «Ka mune mubiyitsi wuneni wukuvu va ghari etu! Nzambi amayilingule mukute andi.» ");
INSERT INTO puu_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Didume di Djesu dikenyave mu Sudé djotsu kwange na mu mighule. ");
INSERT INTO puu_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","San-Batise anowulu motsu ame badukitsi bandi bamavose, akenengile babedji va ghari owu. ");
INSERT INTO puu_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Akebasindighe ombu Fumu mu yemuwivule rye: «Ndedju la Yisolu yi Nzambi etutindili vo tukelise mususu?» ");
INSERT INTO puu_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Na betoli ombu Djesu, bakevose: «San-Batise atsitutinde ombu awu mu uwivule rye: “Ndedju awu Nzambi etutindili vo tukelise mutu ususu?”» ");
INSERT INTO puu_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Banotole, bakerasune Djesu ebelusi pwele bibedu, bibomfi na abamabe na binyuni bibi na utyemuse bidunge. ");
INSERT INTO puu_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Akebawaghule bwena, wendanu, yétsingulanu San amedumalabe, amedumawulu: «Bidunge bimalabe, bitsyoku bimasungeme mwendu, bango nyámbi bamalyomusu, abamabe madibe bamawulu, abamabe bafu bamarambughe na musamu wuboti wumasamunu ombu bidjaghe. ");
INSERT INTO puu_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Ubwedji ombu djandi awu aghotsyemuse yitu yandi na aghodile tonu djuberuyile dibandu menu.» ");
INSERT INTO puu_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Abamatindu na San banoghabughe, Djesu akevose na yinombu ayimabe vane mu dyambu di San rye: «Yi dumelabe o dukange? Dundubi dwipupusu na mupunge? ");
INSERT INTO puu_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Yi dumayelabe? Mutu adware bikutu bi bandumbe? Nesi! Mumbari batu abedwari bikutu bi bandumbe na abavu na maboti mapwele, djowu betsani mu mandaghu ma bakaghe. ");
INSERT INTO puu_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Yike yi, dumayelabe? Mubiyitsi? Nine nyidutsinguli avyoghulile ne mubiyitsi! ");
INSERT INTO puu_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Dingenze, Bisonu bi Nzambi bivosi mu dyambu di San rye: “Lanu, nyutinde yilumbi yami va wusu aghu, mu uwutsonziyile nzile.”» ");
INSERT INTO puu_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Mbana Djesu akemwébwele ubatsingule: «Bwé dingenze nyidutsinguli, vasekaburu mutu awuvyoghulile San. Tumbe, awu agheyi mu Bukaghe bu Nzambi, amuvyoghe buneni. ");
INSERT INTO puu_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Batu botsu, ne babolitsi ba lepu abamamuwulu, bamasingisile Nzambi yiri asungeme na Fumu erondi ubaghobule na bakesinge ubatusu na San. ");
INSERT INTO puu_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Tumbe baFarisi na milonzi mi mighaghe bakebuse durondu du Nzambi mu djowu na bakebuse ubatusu na San.» ");
INSERT INTO puu_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Djesu akebwévose: «Na anyi nyurungule ubaghusunu batu ba temu adjidji? Nane yi bavu? ");
INSERT INTO puu_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Ba baghunu na baane abaghukume va mulebi, betsingusini rye: “Tumadusiyile milombu, dusamayine. Tumaduwimbilile nimbu tsi manyoni, dusamalile.” ");
INSERT INTO puu_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Ave San-Batise amaruyile, asamadjangaange bighudji nonu malamu, dumavose rye: “Ane Yinyuni yibive.” ");
INSERT INTO puu_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Mwane Mutu amarughe, edji nenu na dwivosi yiri Kamune mulitsi na munwitsi wu, djandi mbatsi babolitsi ba lepu na bavayitsi ba mabi. ");
INSERT INTO puu_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Tumbe botsu abegharu dyele di Nzambi, besingi yiri djandi evayi diboti.» ");
INSERT INTO puu_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Mufarisi wumosi amalende Djesu mu uyédji nandi. Djesu amakote o ndaghu andi na amavyoghe va metse. ");
INSERT INTO puu_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Vane, vakerughe mughetu yimbembu. Anodjabe yiri Djesu amayedji o ndaghu muFarisi, akebarasune na muyombu wubase mu yirure yi dighe. ");
INSERT INTO puu_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Mughetu eni anokote, akereleme o nzime Djesu nolile. Anobotse matambi mandi na matsange, akematsindulaange na nange tsyandi. Akemafife nowitile muyombu. ");
INSERT INTO puu_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Mufarisi eni awu amamunengile, anolabe nane, akengungurunaange o murime: «Mbeyi dibaale dyeni didi adji mubiyitsi awungenze, mbé atsidjabe munongu mughetu awutsimubembe nane avu.» ");
INSERT INTO puu_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Djesu akenangule dyufi nomunengile: «Simu, nyine mwa dyambu dyughutsingule.» Simu kamuwaghule rye: «Mulonzi, vose.» ");
INSERT INTO puu_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Na Djesu akevose rye: «Babaale babedji bamanwanaange mutu mbongu. Wumosi amanwanaange kame-yiranu tsi badoli, awune maghumi-maranu (50). ");
INSERT INTO puu_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Anolabe bwé baghorungule wumuvanine, akebasile mughanu wotsu na akebatande. Anyi omuronde pwele mu mubedji ewune?» ");
INSERT INTO puu_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simu akewaghule rye: «Nyitasi, djandi awu amabe na mughanu wuneni amatandu.» Djesu akemutsingule rye: «Wune ndunge.» ");
INSERT INTO puu_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Djesu anoghelughe ombu mughetu, akevose na Simu rye: «Wilabi mughetu ewuwu? Ave nyitsikotile o ndaghu aghu, wughapeghe mambe mosuse matambi. Tumbe djandi, amamabotse na matsange mandi, mbanane, amamatsindule na nange tsyandi. ");
INSERT INTO puu_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ndedju wughambumbe. Tumbe djandi nyikotilaange, aghedundi ufife matambi mami. ");
INSERT INTO puu_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ndedju wughakwitile matsi va djulu muru ami. Tumbe djandi atsikobise nowitile muyombu mu matambi mami. ");
INSERT INTO puu_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Ladibandu, nyighutsinguli bwena ne mabi mandi motsu mamamutandu, mumbari yirondu yandi yineni. Tumbe awubetandi mwa pesu, yirondu yandi yidji pesu.» ");
INSERT INTO puu_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Mbanane Djesu amavose na mughetu eni: «Mabi maghu mamatandu.» ");
INSERT INTO puu_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Abamadjangaange va mosi nandi, bamavosaange va ghari owu: «Awuwu ni oyitandi ne mabi?» ");
INSERT INTO puu_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Tumbe Djesu akevose na mughetu: «Yitu yaghu yimaghughobule, wendange mu duvotsu.» ");
INSERT INTO puu_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Va djulu vane, Djesu amanangaange misyengi na mimbu mu uyenesamune Musamu Wuboti wu Bukaghe bu Nzambi. Dighumi na badukitsi bandi babedji (12) bamabe nandi, ");
INSERT INTO puu_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","na mwa dikabu di baghetu abe Djesu amasanze binyuni bibi nobeluse mali diwendili yiri: Mari mwise Maghedale awu amasanzu yisambwali yi binyuni bibi, ");
INSERT INTO puu_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Sane, mughatsi Kuse mukelitsi maboti ma Yirode, Sisane na bamosi abamaveghaange maboti mowu mu uwamuse Djesu na badukitsi bandi. ");
INSERT INTO puu_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Yinombu yimarughaange yari na yari mu misyengi mu uyibengune na Djesu. Na mughungi wighukimi, akebabwayile nongu édjidji: ");
INSERT INTO puu_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","«Mukukitsi amapale nowende o nungi andi muyékuke tsangu. Ave amakukilaange, mwa dikabu dikebondughe mu nzile. Batu bakeditsyarile na batsoli abamarughusenaange o djulu bakidode. ");
INSERT INTO puu_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Dikabu dimosi, dikebondughe va yilale yi mamani. Tsangu tsyeni, tsinobende, tsikeneghe pesu na tsikenengene dibandu dighambu di posi mambe. ");
INSERT INTO puu_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Dikabu adine, dikebondughe va ghari matsyendi. Dikebende va mosi na matsyendi. Matsyendi meni maketsitutse. ");
INSERT INTO puu_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Tumbe dikabu adimasyale, dikebondughe va butambe buboti. Tsangu djikebende na kadi yivaru yikebure kame milunde.» Na Djesu yikemani uvose nane, akebwese unangule dyufi rye: «Wulwanu, wotsu avu na matudji limbe mu uwulu, awulu!» ");
INSERT INTO puu_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Mu dyoni badukitsi bandi, bakemuwivule divindughulu di nongu eni. ");
INSERT INTO puu_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Akebawake rye: «Dumaveghu yese yudjabe bikeke bi Bukaghe bu Nzambi, tumbe ombu bane, mambu meni, me batsingulu mu banongu mumbari: ");
INSERT INTO puu_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","«Lanu divindughulu di nongu eni: tsangu, mbembu Nzambi. ");
INSERT INTO puu_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Tsangu atsimabondughe mu nzile, djowu abewulu mbembu Nzambi. Tumbe Dyabu eyiwusule musamu eni mu mirime myowu, mumbari bakewusinge na bakeghobulu. ");
INSERT INTO puu_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Tsangu atsimabondughe mu mamani, djowu bane, payi bamawulu musamu, bakewuwake na nzangu. Tumbe mwa pesu temu, baghewughangisi nowutsanise mu mirime myowu. Ave dumangu dwiruyili, bakedunde yitu. ");
INSERT INTO puu_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Tsangu atsimabondughe va ghari matsyendi, djowu bane, abewulu mbembu Nzambi bedjighangisi na baghedjidedili dibandu munyongu, maboti na nzale tsi musoni. Na mutsanu owu wiburi milunde, tumbe migheweeli. ");
INSERT INTO puu_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Tsangu atsimabondughe mu butambe abu boti, djowu bane abewulu mbembu Nzambi na murime wusunde, bédjighangisi na yikanane na mutsanu owu wiburi milunde amiweeli.» ");
INSERT INTO puu_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","«Vagha mutu ebanzi lambi na edjisunzi otsi ponzi vo otsi tangi, tumbe mbé odjisunze va djulu dingase mumbari djikemonitse botsu abekoti o ghari ndaghu. ");
INSERT INTO puu_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Yime yotsu ayivu yikeke yudjabunu yilumbu; ayimusweghe, yubawulu va yimwani “velee”. ");
INSERT INTO puu_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Kebenanu mu kulusu enu, mumbari, wotsu avu na yime, bomubwese. Tumbe, djandi wune awu aghaane yisalu, opatulu ne mwa pesu adjivu nandi.» ");
INSERT INTO puu_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Ngudji na baane ba ngudji ba Djesu, bamaronde umulabe. Banotole ave amabe, basamarunguse ubambene nandi dibandu yinombu yeni. ");
INSERT INTO puu_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Baketsingule Djesu rye: «Ngudji na baane ba ngudji aghu djowu bane bavu o dulombili na bérondi uwulabe.» ");
INSERT INTO puu_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Tumbe Djesu akebatsingule djobotsu rye: «Ngudji na baane ba ngudji ami, djowu abewulu na bédedili mbembu Nzambi.» ");
INSERT INTO puu_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Mwa yilumbu, Djesu anonangeme mu bwatu na badukitsi bandi, akebatsingule rye: «Twendyanu o disimu dine di yilibe.» Na bakewende. ");
INSERT INTO puu_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Ave bamawendilaange, Djesu akewende yilu. Sundile mupunge wuneni wukeghumbe mu yilibe, bwatu bukebande wubase na mambe, na bakabe mu purulu. ");
INSERT INTO puu_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Dinobe nane, badukitsi bakebambene va mughule Djesu, bakemusimbule noghamughe rye: «Fumu, Fumu, yike ufu, tukefu!» Djesu anosimbughe, akenyangile mupunge na mibidji, bikesigheme. Na musighe wuneni wukabe «swii». ");
INSERT INTO puu_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Djesu aketsingule badukitsi bandi rye: «Yitu yenu yika?» Mu ghome adjimabe nowu, bakesutu na bakevosaange va ghari owu rye: «Mutu awuwu nyi wirumi ne mupunge na mambe na vane bimudedili!» ");
INSERT INTO puu_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Djesu na badukitsi bandi bamatsyekeme o bulongu bu baSeraseni o disimu dine di yilibe adisungesene na Ngalile. ");
INSERT INTO puu_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Ave Djesu amasunduyile vatsi, dibaale di musyengi eni, adimabe na binyuni bibi dikeyémubengusene. Vane kale asamamwédwaraange bikutu, amasileminaange mu dulombili, mu mambine. ");
INSERT INTO puu_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Anolabe Djesu, amaghamughe, amakebwaghe va makulu mandi na akevose o djulu rye: «Dyambu yi witombi, Djesu, Mwane Nzambi adjitinde djulu? Kokolu, nyighulendi, wuyanzoyise!» ");
INSERT INTO puu_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Mbana Djesu akerume binyuni bibive abimamukambisaange yi lenganu nopale. BaSeraseni, bamamutungaange myowu na makulu na bapange na mu bivangu bi madilu mu umukelise. Tumbe, akebitabulaange. Binyuni byeni bibi bimenemubeghaange mu mbure atsi amabilaange pinze o ghari dukange. ");
INSERT INTO puu_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Djesu akemuwivule: «Dine dyaghu yi?» Akemuwaghule: «Yinombu». Amawaghule nane, mumbari bamabe binyuni bipwele. ");
INSERT INTO puu_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Na bikelende Djesu, akébitinde o Mbengi. ");
INSERT INTO puu_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Vane, vamabe mughambe wuneni wu bangulu awumadjangaange o djulu mukongu. Binyuni byeni bikelende Djesu yiri bikekote mu bangulu. Na Djesu akebaveghe musughe. ");
INSERT INTO puu_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Binyuni bibi bikepale mu mutu eni, bikekote mu bangulu. Mughambe eni wukevindeme mukongu mbangu, wukeputume mu yilibe «mfughuu», wukevevughe. ");
INSERT INTO puu_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Abamakelisaange bangulu beni, banolabe nane, bamarine na bamenenyavise tsangu mu musyengi na mu masaku. ");
INSERT INTO puu_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Batu bamawende muyélabe adimavyoghe. Banotole ombu Djesu, bakerasune dibaale adimapalusu binyuni atsane va wusu andi, adware, asigheme na akepolu. Na batu beni bakeghangu na ghome. ");
INSERT INTO puu_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Abobamalabe yimaghe yeni, bakeyetsingule nane Djesu amabelusile dibaale dyeni. ");
INSERT INTO puu_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Bise Seraseni botsu, bakelende Djesu yiri arambuyi ombu wowu, mumbari bamaghangu na ghome adji neni. Djesu akenangeme mu bwatu noghabusile. ");
INSERT INTO puu_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Djandi awu amapalusu binyuni bibi, akelende Djesu akenewendaange nandi. Tumbe Djesu akemughabuse o ndaghu andi nomurume: ");
INSERT INTO puu_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","«Yenetsingule batu baghu botsu ame Nzambi amawuvayile.» Mu dyoni, amayenewende noyenevaghaange bumbedji mu motsu ame Djesu amamuvayile. ");
INSERT INTO puu_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Ave Djesu amaghabuyile o disimu dine di yilibe, yinombu yimamukelisaange mu umusangile. ");
INSERT INTO puu_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Na vakerughe dibaale, dine dyandi Sayirise amabe yivunde yi ndaghu dusambu dji baSwife. Yivunde yeni akekebwaghe va makulu ma Djesu na akemulende yiri: «Rughe o ndaghu ami.» ");
INSERT INTO puu_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Payi amavaghe nane, mumbari amabe na mwane divingu di mughetu wu dighumi na bilime bibedji (12) amamongaange. Ave Djesu amawendilaange, amabe va ghari yinombu na bakeyenemubandesenaange yari na yari. ");
INSERT INTO puu_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Va ghari owu, vamabe mughetu awumabe na muvuve malungu mu dighumi na bilime bibedji (12). Mughetu eni, akemane maboti mandi motsu na babuyitsi, tumbe ne wumosi asarunguse umubeluse. ");
INSERT INTO puu_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Anobambene va nzime Djesu, akebembe difubu di yikutu yandi. Vane-vane, muvuve malungu ukekamughe. ");
INSERT INTO puu_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Djesu akewivule rye: «Anyi atsimbembe?» Botsu bakeghale. Pyere akemuwake rye: «Fumu, yinombu yiwutsyenge, na yiwubandesene yari na yari.» ");
INSERT INTO puu_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Tumbe Djesu aketsiyise rye: «Mutu atsimbembe mumbari nyitsiwulu mangolu matsimapale mu menu.» ");
INSERT INTO puu_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Mughetu eni, anolabe yiri bamamubaghule, akerughe noregheme na akekebwaghe va makulu ma Djesu, aketubule dibandu adi amamubembile va wusu mughungi, na nane amasunde ubeluyile. ");
INSERT INTO puu_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Djesu akemutsingule rye: «Mwane ami, yitu yaghu yimaghughobule, wendangaange na duvotsu.» ");
INSERT INTO puu_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Djesu uvose mbé akivose na mughetu eni, vakerughe yilumbi o dimbu di yivunde yi baSwife novose rye: «Wuyabwékungise wa Mulonzi, mwane amafu.» ");
INSERT INTO puu_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Tumbe Djesu anowulu nane, aketsingule yivunde yeni: «Wuyalabe ghome, vaghe yike yitu, na mwane aghu oghobulu.» ");
INSERT INTO puu_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Anotole o ndaghu Sayirise, asamagharusu mutu ususu ukote nandi, yike vane Pyere, San, Sake, tadji na ngudji mwane. ");
INSERT INTO puu_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Botsu bamatataange nolilaange mwane eni. Djesu akebatsingule rye: «Duyabwelile, mwane agha afu, tumbe adji yilu.» ");
INSERT INTO puu_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Na batu beni bakemupedjingi, mumbari bamadjabaange yiri mwane afu kale. ");
INSERT INTO puu_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Tumbe Djesu akemughaange mu dikake novose na mangolu rye: «Mwane, releme!» ");
INSERT INTO puu_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Vane-vane, akeghabughe monyu, akereleme. Djesu akebarume umuveghe bighudji. ");
INSERT INTO puu_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Biburu bi mwane eni mughetu bakesutu, na Djesu akebaghandise yiri duyabile utsingule mutu adibanovyoghe. ");
INSERT INTO puu_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Djesu enengili dighumi na babedji (12) na ebaveyi mangolu na dirume mu binyuni byotsu bibi, na mu ubeluse bibedu. ");
INSERT INTO puu_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Akebatinde mu uyenesamune Bukaghe bu Nzambi na mu ubeluse bibedu. ");
INSERT INTO puu_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Akebatsingule rye: «Ave dulingile, duyabeghe yime: ne duvengu, ne komi, ne mbongu, ne dipe ne bidjunge bibedji. ");
INSERT INTO puu_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Ndaghu adjududile, tsananu mune tena durambughe. ");
INSERT INTO puu_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Mbure tsyotsu atsyubuse ududile, ghusughanu musyengi owu, mbana kukanu difufundu di makulu menu, dyoni dyube nane bumbedji abubafundise.» ");
INSERT INTO puu_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Badukitsi beni bamasogheme, na bamayenewendaange, mu mimbu, mu uyenesamunaange musamu wuboti noyenebelusaange bibedu. ");
INSERT INTO puu_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Yirode murumitsi wu Ngalile, anowulu motsu amamavaghungu, akesutu mumbari bapwele bamavosaange rye: «San-Batise amarambughe o dufu.» ");
INSERT INTO puu_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Bane bakevosaange yiri: «Eli amabwéghabughe monyu.» Bamosi bakevosaange yi: «Mubiyitsi wukale wumaghabughe monyu.» ");
INSERT INTO puu_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Tumbe Yirode amavosaange yiri: «Menu nyimarumise baketabule San-Batise muru. Yike nyi esalisi mambu ame menu nyiwulu?» Mu dyoni, amarondaange ulabe Djesu. ");
INSERT INTO puu_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Bilumbi djowandi bamatsingule Djesu motsu amebamadughusungu. Djesu akebanengile na bakevengeme o musyengi winengulu Besayide. ");
INSERT INTO puu_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Yinombu yinomulabe, yikemuduke. Djesu na badukitsi bandi bakebadile. Djesu amabasayimine na amalonze Bukaghe bu Nzambi, nobeluse botsu abamabe na nzale dubelusu. ");
INSERT INTO puu_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Wisi wunobande wutsime, dighumi na badukitsi bandi babedji (12) bakebambene na Djesu nomutsingule rye: «Tsyéghanini yinombu yikenewende mu mimbu na mu masaku, mu yenerombe bighudji na mambure ma yilatsi, mumbari tudji va kumu dukange.» ");
INSERT INTO puu_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Tumbe Djesu akebawaghule rye: «Djenubeni, baveyanu bighudji!» Bilumbi bakemuwalu rye: «Djetu, tune bu mape maranu na nyame bedji tsi mambe. Wirondi bwena tuwendi mu yésumbe bighudji bi batu botsu babe?» ");
INSERT INTO puu_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Vane, vamabe tosini-yiranu (5 000) tsi batu. Djesu aketsingule badukitsi bandi rye: «Batsanisyanu mu maghuki ma maghumi-maranu (50) ma batu.» ");
INSERT INTO puu_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Badukitsi bakemudedile na bakebatsanise. ");
INSERT INTO puu_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Djesu akebonge mape meni maranu na nyame tsyeni tsibedji. Akenangule misu na djulu, akeghabusile Nzambi diboti mu bighudji byeni, akebitabule na akebiwakise badukitsi bandi na bakeghabile yinombu. ");
INSERT INTO puu_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Botsu abamadji, bakeghukuru. Bibuku abimasyalulu, bikebase dighumi na ponzi bedji (12). ");
INSERT INTO puu_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Yilumbu yimosi Djesu amasambilaange pinze va mughule, badukitsi bandi wandi bamabe vane. Akebawivule rye: «Yi yinombu yivosi mu menu?» ");
INSERT INTO puu_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Bakemuwaghule rye: «Abane bévosi rye wudji San-Batise, bamosi bakevosaange rye wudji Eli mubiyitsi, basusu bakevosaange bwé wudji mubiyitsi wukale awumarambughe o dufu.» ");
INSERT INTO puu_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Akebwébawivule rye: «Ka djenu, yi dwitasi? Anyi nyivu?» Pyere akewake rye: «Wudji Kirisete, mwane Nzambi adjivu monyu.» ");
INSERT INTO puu_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Djesu amabaghandise kilikingi duyaditsingule mutu. ");
INSERT INTO puu_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Na amabwele rye: «Mwane Mutu olabe maghughe maneni. Bivunde bi baSwife, bivunde bi bavaghulitsi ba paghu na milonzi mi mighaghe bomubuse, oboku na mu yilumbu ayimuryeru orambughe o dufu.» ");
INSERT INTO puu_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Mba amatsingule mughungi rye: «Payi mutu erondi unduke, alekeghale djabeni, ananguli kurusu andi kale yilumbu na anduki. ");
INSERT INTO puu_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Nyidutsinguli: Wotsu oronde wughaghe monyu andi, owuvinde; tumbe djandi awu owutsyemuse dibandu menu, omwéwudile. ");
INSERT INTO puu_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Ubwedji yi wuvu ombu mutu awirondi udile maboti motsu ma butambe, mbana aketsyemuse vo akebunge monyu andi? ");
INSERT INTO puu_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Payi mutu olabe yisoni mu menu na mu mambu mami, Mwane Mutu omulabe yisoni ave oruyile mu bundumbe bwandi, na bu Tadji na bu byanze bi Nzambi abivu bisyeme. ");
INSERT INTO puu_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Dingenze, nyidutsinguli rye: bamosi abavu vave bagholefu, pa bakalabe dulasu du Bukaghe bu Nzambi.» ");
INSERT INTO puu_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Banovyose tsone, mu yilumbu ayi munane, Djesu akenengile Pyere, San na Sake na bakemate o mukongu muyésambile. ");
INSERT INTO puu_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Ave bamasambililaange yinzi yandi yikekademe na yikutu yandi yike veme «vee». ");
INSERT INTO puu_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Sundile, va malabene babaale babedji bamamoghaange nandi: Moyise na Eli. ");
INSERT INTO puu_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Djowu abamalabene va ghari bundumbe bu Nzambi, bakevosaange na Djesu mu djabe nane omanine yisalu yandi ne akeyefu o Serusaleme. ");
INSERT INTO puu_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Pyere na bambatsi, bamabe bilu. Tumbe banorambughe yilu nonyighe misu, bamalabe bundumbe bu Djesu na babaale babedji abamabe nandi. ");
INSERT INTO puu_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Yike babaale beni banobe beli nowende, Pyere amavose na Djesu rye: «Fumu, dibwedji yiri tubyanu vave. Turungyanu mirumbe miryeru: wumosi awaghu, wususu wu Moyise, awune wu Eli. Payi Pyere avose nane, mumbari asamadjabaange adi amavosaange.» ");
INSERT INTO puu_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Ave amavosilaange nane, dimungi dimasundughe na dimabaghumbe na yidumbitsi yandi. Pyere na bambatsi babedji bakeghangu na ghome ave bamalabile dimungi dimabaghumbe. ");
INSERT INTO puu_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","O ghari dimungi umawulunu dyufi dimavose rye: «Awuwu la Mwane ami awu nyimasole, muwululwanu!» ");
INSERT INTO puu_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Dyufi dyeni dinovole, bamalabe yike Djesu bwandi. Mu temu eni, Pyere na bambatsi babedji bakelévole, na basamatsingule batu adibamalabe. ");
INSERT INTO puu_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Yilumbu ayimaduke, Djesu na badukitsi baryeru bamavindeme mukongu. Yinombu yineni yimabengusunu Djesu. ");
INSERT INTO puu_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Va ghari yinombu, dibaale dimosi akeghamughe rye: «Mulonzi kokolu tsyaghu, lase mwane ami divingu yingebe! ");
INSERT INTO puu_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Payi Yinyuni yibive yimamughaange, mwane eghamuyingi, esibuyingi, epalisingi difwitse. Yimunemisingi, yibu umuboke na yighegharu umudunde. ");
INSERT INTO puu_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Nyitsilende badukitsi baghu bakeyisanze, tumbe bagharungule.» ");
INSERT INTO puu_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Djesu amawake rye: «Kamune paghe dji, djenu batu babi, dune mirime mighale. Temu kweni nyuwarilaange kemi tsyenu? Beghe mwane aghu.» ");
INSERT INTO puu_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Ave mwane amabambininaange na Djesu, Yinyuni yeni yibive yimamukungise na mangolu, yikemubete. Djesu akeyinyangile noyisanze. Mwane akebelughe, mbana Djesu akemughabusile tadji andi. ");
INSERT INTO puu_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Botsu bakesutu dibandu buneni bu Nzambi. Vo batu bamanyungilaange ame Djesu amavaghaange, aketsingule badukitsi bandi rye: ");
INSERT INTO puu_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","«Wulwanu na ghangisanu motsu ame nyikidutsingule vave: Mwane Mutu osumbusu na batu.» ");
INSERT INTO puu_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Tumbe basamatsiyise adi amavosaange. Basamawulu divindughulu mumbari dimabe yikeke mumba bakéjabe divindughulu. Bamalabe ghome mu mwémuwivule dyoni. ");
INSERT INTO puu_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Badukitsi baketsundaange mu djabe anyi avu yivunde mu djowu botsu. ");
INSERT INTO puu_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Djesu anodjabe matase ma mirime myowu, amabeghe mwane ngebi, akemurelighe va mughule andi, ");
INSERT INTO puu_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","novose rye: «Wotsu edili mwane nane wughu mu dine dyami, endili. Wotsu endili, edili djandi omanzindighe, mumbari wotsu odjivu agheyi va ghari enu, djandi la yivunde.» ");
INSERT INTO puu_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","San akevose rye: «Fumu, tutsilabe mutu atsisanzaange binyuni bibi na mangolu ma dine dyaghu. Tutsimughandise mumbari agha netu mukonge.» ");
INSERT INTO puu_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Tumbe, Djesu akemuwaghule rye: «Duyabwémughandise, mumbari wotsu agha mbeni enu, mutu enu.» ");
INSERT INTO puu_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Djesu anolabe yiri temu adji omatile o djulu yike wutole djitoli, akeghane kake djuwende o Serusaleme. ");
INSERT INTO puu_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Djesu akeretse bilumbi, bakewende, baketole o dimbu di bise Samari mu yemukunzile mbure. ");
INSERT INTO puu_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Tumbe batu ba dimbu dyeni, bakebuse wubadile mumbari bamadjabaange yiri o Serusaleme ewendi. ");
INSERT INTO puu_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Ave badukitsi Sake na San bamadighululu, bakewivule rye: «Fumu, wirondi yiri turumi mudji awu wiruli o djulu wukebasyeghesene?» ");
INSERT INTO puu_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Djesu akeghelughe ombu wowu, akebasyembe. ");
INSERT INTO puu_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Na bamawende o dimbu dimosi. ");
INSERT INTO puu_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Ave bamabile mu nzile, mutu amatsingule Djesu rye: «Nyuyenewendaange naghu mbure tsyotsu atsiwuwendaange.» ");
INSERT INTO puu_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Djesu akemuwaghule rye: «Bitsalale bine midunge na batsoli bane muve, tumbe Mwane Mutu aghaane mbure djuvumine nosikile muru.» ");
INSERT INTO puu_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Ombu wumosi, Djesu akevose rye: «Nduki.» Tumbe mutu eni akemuwaghule: «Kokolu Fumu, lépeghe musughe muleyétsighe tadji ami.» ");
INSERT INTO puu_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Djesu akemuwaghule rye: «Dunde abafu batswiyi bamvumbi nowu, tumbe ndedju wende, yesamune Bukaghe bu Nzambi.» ");
INSERT INTO puu_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Wususu akebwévose rye: «Fumu, nyirondi uwende naghu, tumbe nyileyeghanine batu ba ndaghu ami.» ");
INSERT INTO puu_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Djesu akemuwaghule rye: «Mutu wotsu oyibandi wusole yilu mu nungi na mukwati, yinzi na nzime, agha awelimine mu Bukaghe bu Nzambi.» ");
INSERT INTO puu_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Va djulu vane, Fumu akesole maghumi-dusambwali na badukitsi babedji (72) basusu. Akebasindighe babe babedji mu misyengi na mbure tsyotsu atsi djabeni mbé olingule. ");
INSERT INTO puu_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Akebatsingule rye: «Nungi djimawele, vake dighumbe, basatsi bagha pwele, kaboghu sambilanu Fumu nungi akebwese basatsi. ");
INSERT INTO puu_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Wendanu, lanu nyidusindiyi nane baane ba bindombu va ghari baminzi. ");
INSERT INTO puu_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Duyabonge dibumbe di mbongu vo komi ne bapondu. Mu nzile, duyasimbe mutu. ");
INSERT INTO puu_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Mu mandaghu motsu ameduyenekotaange, lévosanganu rye: “Duvotsu dubi mu ndaghu édjidji.” ");
INSERT INTO puu_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Pavadji mutu duvotsu, dwoni dubi mu mutu eni. Patsi nane, dwoni dudughabuyili. ");
INSERT INTO puu_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Tsananu mu ndaghu eni, djanganu na nwanganu byotsu abiboduveghe mumbari musatsi awelimine na fute andi. Duyabe duyawende ndaghu na ndaghu. ");
INSERT INTO puu_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Musyengi wotsu awu duyenekotaange, ave boduwakile, djanganu abiboduveghe. ");
INSERT INTO puu_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Belusanu bibedu abi durasunu, batsingulyanu rye: Bukaghe bu Nzambi bumabambene nenu. ");
INSERT INTO puu_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Tumbe, musyengi awughoduwake, palanu mu mbure tsi mighungi, batsingulyanu rye: ");
INSERT INTO puu_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Twighubuli mu djenu difufundu di musyengi enu aditsiname mu makulu metu, tumbe djabanu yiri Bukaghe bu Nzambi buke bebeli.” ");
INSERT INTO puu_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Nyidutsinguli rye: Mu yilumbu yi bunzonzi bu Fumu, bise musyengi eni bokilusu wuvyolile bise Sodome.» ");
INSERT INTO puu_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","«Maghughe ombu ndedju Korasi, maghughe ombu ndewandi Besayide. Mumbari, bimaghe abitsilabane ombu wenu, mbé o Tire na Sidone, yileme nabubu mbé bamadwarile basyele nogholene dibufu muvonde kokolu. ");
INSERT INTO puu_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Ladibandu, va yilumbu yi bunzonzi bu Nzambi, misyengi mi Tire na Sidone mighokambusu pwele nane djenu. ");
INSERT INTO puu_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Na ndedju wandi Kapernawume, witasi bwena wumatusu o djulu? Djabanu yiri dudyamusu nobwaghu o bulongu bu djowu abafu.» ");
INSERT INTO puu_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Djesu akebwétsingule badukitsi bandi rye: ");
INSERT INTO puu_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Maghumi-dusambwali na badukitsi babedji (72) bamaghabughe na nzangu novose rye: «Fumu, ne binyuni bibi bimatudedilaange ave tumabiruminaange mu dine dyaghu.» ");
INSERT INTO puu_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Djesu akebatsinguli rye: «Nyimalabe Dyabu amabondughaange o djulu nane dusyemu du kaki. ");
INSERT INTO puu_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Lanu, nyimaduveghe musughe utsyarile banyoghe, bakuru na mangolu motsu ma mbeni na vaghobe yime yudukambise. ");
INSERT INTO puu_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Tumbe duyabe na nzangu mumbari binyuni bidudedili. Tumbe saghanu mumbari mine menu masonughu o djulu.» ");
INSERT INTO puu_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Vane-vane, Djesu akebase na nzangu dji Yinyuni Yisyeme noghamughe rye: «Tate, nyiwudodisi, Fumu djulu na butambe mumbari wumasweghe mambu meni mama ombu bango dyele na dudjabu, wumamalase ombu bangebi. Nine Tate, mumbari wutsironde yiri dyube nane. ");
INSERT INTO puu_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Tate ami, amapeghe bimi byotsu. Vagha mutu edjabi Mwane payi tsi Tadji, vo Tadji payi tsi Mwane, na abe Mwane erondi udjabise Tadji.» ");
INSERT INTO puu_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Djesu anoghelughe ombu badukitsi bandi, o fundu akebatsingule rye: «Ubwedji ombu djenu abedwilabi mambu meni mame amedwilabi! ");
INSERT INTO puu_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Mbana, nyidutsinguli rye: babiyitsi na Kaghe tsipwele bamaronde wulabe abi djenu dwilabi tumbe basamabilabe. Na bamaronde uwulu amedwiwulu na basamamawulu.» ");
INSERT INTO puu_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Mulonzi wumosi wu mighaghe, amareleme mu wélighe Djesu. Akemutsingule rye: «Mulonzi yi nyuvaghe mudile monyu mutubu na mutubu?» ");
INSERT INTO puu_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Yike Djesu akemuwivule rye: «Mu mughaghe Moyise, yi basonighe? Tsyeni wiwuwululu?» ");
INSERT INTO puu_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Dibaale dyeni dikemuwaghule rye: «“Wurondaange Fumu Nzambi aghu na murime wotsu, na muvumu aghu wotsu, na mangolu maghu motsu, na matase maghu motsu.” Mba nane, “Wurondaange mutu naghu nane ndebeni.”» ");
INSERT INTO puu_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Djesu akemusingisile nomutsingule rye: «Vaghe nane, wudile monyu.» ");
INSERT INTO puu_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Tumbe djandi akeronde wukekaghule, nowivule Djesu rye: «Anyi avu mutu nami?» ");
INSERT INTO puu_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Djesu akebatsingule rye: «Wumabe mutu wune amarambuyilaange o Serusaleme mu vindeme o musyengi Seriku. Va ghari nzile akeghangu na bikongu, bakemudimbe nomupatule bikutu abimabe nandi na bakemusile peni, aketabughe nyambu, bakemusila noyenewende. ");
INSERT INTO puu_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Muvaghulitsi paghu amavyoyilaange mu nzile eni, anolabe mutu eni akemughonge, akenewende. ");
INSERT INTO puu_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Musalitsi wu ndaghu Nzambi wu mwise Levi, aketole vane, akelabe mutu eni, akemughonge djawandi akenewende. ");
INSERT INTO puu_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Tumbe mwise Samari amabe mu mulingu andi, aketole vane, anomulabe, akebase na yingebe. ");
INSERT INTO puu_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Anobambene nandi, akemutsindule malungu, akewitile matsi na malamu mu mubughe mapure. Akemunangighe va djulu buru adjimenemubeghaange, akemubeghe o ndaghu beni bakemukelise na burange. ");
INSERT INTO puu_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Ave kedi, amaveghe fumu ndaghu beni fure bedji novose rye: “Munkelisili na burange, byotsu abi wuvaghe mu djandi, nyughughabusile ave nyurule.”» ");
INSERT INTO puu_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Djesu akemuwivule rye: «Tsyeni witasili? Va ghari djowu baryeru, anyi amalase mutu awu bikongu bamadimbe yiri adji mutu nandi?» ");
INSERT INTO puu_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Mulonzi eni mighaghe akemuwaghule: «Djandi omamuwamuse.» Djesu akemutsingule rye: ");
INSERT INTO puu_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Djesu amabe mu nzile na badukitsi bandi, baketole va dimbu, mughetu benengili Marete akebawake o ndaghu andi. ");
INSERT INTO puu_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Mari mwane ngudji andi amabe bu atsane va ditoghu va wusu Fumu mu ulungu musamu awu djandi amalonzaange. ");
INSERT INTO puu_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Marete amavungilaange bu mu bisalu muwake beni. Akebambene na Fumu nomuwivule rye: «Fumu, nde wilabi ubwedji vane mwane ngudji ami enzili pinze na bisalu byotsu? Mutsinguli, akwamusi!» ");
INSERT INTO puu_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Fumu akemuwaghule rye: «Marete, Marete! Yi witsirili murime noketsoyise na matase mu mambu mapwele? ");
INSERT INTO puu_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Tumbe, dyambu dimosi bwandi diwelimine. Mari, atsisole dyambu diboti adighomupatulu.» ");
INSERT INTO puu_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Vamabe yilumbu, Djesu amasambilaange va mwa mbure. Anomane, wumosi mu badukitsi bandi amamuwivule rye: «Fumu, tulonzi wusambile Nzambi nane San amalonzile badukitsi bandi.» ");
INSERT INTO puu_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Djesu akebawaghule rye: «Lanu, ave dusambililaange, vosanganu rye: “Tate etu, adjivu o djulu, dine dyaghu dibi disyeme, bukaghe bwaghu buruyi. ");
INSERT INTO puu_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Tuveyi bighudji bi kadi yilumbu. ");
INSERT INTO puu_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Tutandi mabi metu, nane twitandili djetu wandi abetuvayi mabi, wuyatusile mu dumangu.”» ");
INSERT INTO puu_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Djesu amamwébatsingule rye: «Payi mutu wumosi va ghari enu ane mbatsi, na eyimukokumune va ghari wisi, nomunengile: “Mbatsi ami, nzombisi mape maryeru, ");
INSERT INTO puu_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","mbatsi ami mosi amarughe o wulinge, na ngaane yime yumuveghe.” ");
INSERT INTO puu_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Ka yike mbatsi eni emuwaghuli o ghari ndaghu andi rye: “Sile menu, nyimadibighe ndaghu, menu na baane bami tumabundeme, ngobwésimbughe muyighuveghe mape.” ");
INSERT INTO puu_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Nyidutsinguli, yike esimbuyi mu muveghe byotsu abi erondi, tsi mu yimbatsi ayivu va ghari owu, tumbe mumbari emuvondi na yiswebiri. ");
INSERT INTO puu_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Menu, nyidutsinguli bwé: Vondanu, na boduveghe; rombanu, na dubaghule; dukisanu na bodudibulile mune ndaghu. ");
INSERT INTO puu_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Mumbari, oyivondi, edili; oyirombi, ebaghuli; na bédibulili mune ndaghu ombu oyidukisi. ");
INSERT INTO puu_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Payi mwane evondi nyame mambe, tadji nyi va ghari enu orungule umuveghe pili? ");
INSERT INTO puu_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Vo omuveghe kuru payi emuvondi dyaki? ");
INSERT INTO puu_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Babi nane djenu dwidjabi uveghe bime bi bwedji ombu baane benu, tambusu na Tadji enu adjivu o djulu, tsyeni aghoveyile Yinyuni Yisyeme ombu djowu abemuvondi?» ");
INSERT INTO puu_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Djesu amasanze Yinyuni yibi ombu dibaale di dibabe. Yinyuni yeni yinopale, dibaale dyeni dikevose. Yinombu yi batu yikesutu yikebase na yinyunge. ");
INSERT INTO puu_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Tumbe bane bamavose rye: «Belesebule, yivunde yi binyuni bibi yimuveyi mangolu mosanze binyuni!» ");
INSERT INTO puu_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Bamosi, mu wélighe durumu dwandi, bamamuwivule yiri alasi yilimbe ayiruyili ombu Nzambi. ");
INSERT INTO puu_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Tumbe Djesu anodjabe matase mowu, amavose rye: «Bulongu bwotsu abu batu bétoyi djobeni na djobeni, butsyemughe, na mandaghu mowu merakuyi. ");
INSERT INTO puu_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Dwivosi yiri menu nyisanzi binyuni bibi na mangolu ma Belesebule. Payi ngenze Dyabu ekétoyise djabeni, mumbari yi bukaghe bwandi bubile buware? ");
INSERT INTO puu_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Payi dwitasi yiri menu, nyibisanzi na mangolu ma Belesebule, ka baane benu abebisanzi wandi nane menu, mangolu mowu anyi ebaveyi? Baane ba djenubeni bodufundise! ");
INSERT INTO puu_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Tumbe, payi na mangolu ma Nzambi nyibisanzili, Bukaghe bu Nzambi buke va ghari enu. ");
INSERT INTO puu_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Payi mutu mangolu na bitoghulu byandi, ekelisi ndaghu andi, busine bwandi bwotsu bukandu. ");
INSERT INTO puu_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Tumbe yikeveruyi mutu wumuvyoghulile mangolu, emubeti, emupatuli bitoghulu abi atsivayilaange yitu, eghabi byotsu abi mbé bikevu nandi. ");
INSERT INTO puu_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Awu agha nami, epini. ");
INSERT INTO puu_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","«Ave Yinyuni yibive yipalili mu mutu, yiwendi mu mbure tsi wumughe mu rombe yitsanunu. Payi yighaayidile, yivosi rye: “Nyughabughe o ndaghu ami adji nyitsirambuyile.” ");
INSERT INTO puu_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Eghabuyi, edjirasunu djimaghombulu, djimakunzu. ");
INSERT INTO puu_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Kaboghu yiwendi muyélande yisambwali yi binyuni abimuvyoghulile wubi. Béruyi va mosi, békoti mu ndaghu eni na bétsani. Na dighughe di mutu eni divyoghulili aditeghe.» ");
INSERT INTO puu_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Djesu anomane uvose mambu meni, mughetu akeghamughe va ghari yinombu rye: «Ubwedji ombu mughetu omaghukelise o modji na omaghunwise!» ");
INSERT INTO puu_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Djesu akemuwaghule rye: «Nesi, tumbe ubwedji ombu djowu abewulu mbembu Nzambi na bédjidedili nodjisalise!» ");
INSERT INTO puu_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Yinombu yi batu yimarughesene pwele va wusu andi, akevose rye: «Batu ba temu édjidji babive, bévondi yilimbe yi yimaghe, tumbe yimaghe yi yubalasu, patsi yi mubiyitsi Sonase? ");
INSERT INTO puu_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Ngenze nane Sonase amabile yilimbe yi bise Ninive, anane Mwane Mutu obe yilimbe mu batu ba temu édjidji. ");
INSERT INTO puu_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Mu yilumbu yi mufundu djulu, kaghe mughetu bise bande bulongu oreleme va wusu batu ba temu eni djidji, mu ubatabulile bunzonzi. Odisalise mumbari amarule o malongu ma vale mu uyiwulu malongi ma dyele di kaghe Salemu. Vave, vadji Mutu avyoghulile Salemu! ");
INSERT INTO puu_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Mu yilumbu yi mufundu, bise Ninive boreleme va wusu batu ba temu eni djidji na boduveghe mbele, mumbari djowu bamakalughe dyele mu musamu Sonase!» ");
INSERT INTO puu_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","«Vagha mutu ebanzi paghe mu udjisweghe otsi ponzi vo otsi tangi, tumbe edjisunzi va djulu dingase mumbari botsu abokotaange bakelaba yidjalale. ");
INSERT INTO puu_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Disu dyaghu la lambi dunyuru dwaghu. Payi disu dyaghu dighebeli, dunyuru dwaghu dudji mu yidjalale. Tumbe payi disu dyaghu dibeli, dunyuru dwaghu dudji otsi piseme. ");
INSERT INTO puu_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Kaboghu kebene, yidjalale ayivu mu ndedju yikebe piseme. ");
INSERT INTO puu_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Payi dunyuru dwaghu dwotsu dudji mu yidjalale, ughaane mbure djivu otsi piseme, udji ndedju wotsu mu yidjalale, nane mwinde wighumonitsili na yidjalale yandi.» ");
INSERT INTO puu_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Djesu anomane uvose, muFarisi wumosi akemunengile o udji o ndaghu andi. Djesu amakote akevyoghe va tavule. ");
INSERT INTO puu_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Anolabe bwena Djesu aghasuse makake ne akedji, muFarisi eni amakambulu. ");
INSERT INTO puu_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Kaboghu Fumu akemutsingule rye: «La nane duvu, djenu baFarisi, dwilyomisi yike yidju-djulu yi dimoyi na yi yipele, tumbe o ghari tsyenu, dubase na nzale udaghe na mambu mabive. ");
INSERT INTO puu_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Biduke bi batu nane djenu! Omasale yidju-djulu, tsiri djandi amasale ghari wandi? ");
INSERT INTO puu_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Kaboghu, diwelimine yiri duveghaange ombu bidjaghe byotsu abiwelimine mu bipele byenu, mbana menu motsu molyome. ");
INSERT INTO puu_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Maghughe ombu djenu baFarisi dwiveyi ombu Nzambi yimosi mu dighumi yi bivaru abibendi mu manyengi menu: ngambu, disosu na bimosi. Tumbe dwilibini usalise dusungughu na durondu du Nzambi. Abine mbé dwireli uvaghe na dugholibene mane. ");
INSERT INTO puu_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Maghughe ombu djenu baFarisi, dwirondingi bitsighe biteghe mu mandaghu ma dusambu, na dwirondingi uveghu mbolu va ghari mughungi. ");
INSERT INTO puu_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Maghughe ombu djenu, dudji nane bambine bamaghulene, na batu ave bévyoyili mune bétsyarile nzoruru mumbari mughaa bilimbe!» ");
INSERT INTO puu_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Mulonzi wumosi wu mighaghe akemutsingule rye: «Mulonzi, vo wivosili nane, djetu wandi wisyengi!» ");
INSERT INTO puu_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Djesu akewaghule: «Maghughe ombu djenu wandi milonzi mi mighaghe, dwinangusi batu mifune mirange ubeghu, mbana dughesisini ne mulembu wumosi mu ubawamuse. ");
INSERT INTO puu_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Kamune maghughe ma dulabe? Dwibumbi bangile tsi babiyitsi, abe batadji benu bamaboke. ");
INSERT INTO puu_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Kaboghu, dudji kingu mosi na batadji benu, mumbari djowu bamaboke babiyitsi beni, na djenu dwirungi bangile bowu. ");
INSERT INTO puu_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Ladibandu, Nzambi na dyele dyandi amavosile rye: “Nyubatindile babiyitsi na bilumbi, boboke bamosi, bakekwane basusu.” ");
INSERT INTO puu_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Kaboghu, batu ba temu eni djidji, boveghu mbele mu dyambu di babiyitsi abamaboku, ubongile vane dibandu di bulongu. ");
INSERT INTO puu_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Dimabandile vane bamavunine Abele kwange na dufu du Sakari, omaboku va ghari yinyenzulu yi paghu na ndaghu Nzambi. Nine, nyidutsinguli yiri, batu ba temu eni djidji, bowivulu dibandu di malungu meni! ");
INSERT INTO puu_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Maghughe ombu djenu milonzi mi mighaghe, adumasweghe sabi adjiveyi dudjabu du mambu ma Nzambi. Dughadukote djenubeni, mbana dwighandise ne bo mbé baronde ukote.» ");
INSERT INTO puu_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Djesu anopale o ndaghu eni, Milonzi mi mighaghe na baFarisi, bamabande wumutsuyise nomuwivule bivu mu mambu mapwele, ");
INSERT INTO puu_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","kwivululu dji dyele mu ulabe yiri bowulu mbembu bive djupale mu munu andi. ");
INSERT INTO puu_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Va temu eni, yinombu yi batu yimawungene tena yimayenetsyarsenaange. Djesu akelevose na badukitsi bandi nobatsingule rye: «Kebenanu na pende-pyalu baFarisi abavu nane yifunisi ayi bésobini mu pate-mape. ");
INSERT INTO puu_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Vagha dyambu disweme adighodjabunu, ne yikeke ayighobaghulu. ");
INSERT INTO puu_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Ladibandu: Motsu duvosaange otsi piseme, mowulunu o yidjalale; ame dungungerenaange mu bibuku bi mandaghu, motubulu va ngande, mbanane mowanzulu mwanzu.» ");
INSERT INTO puu_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","«Nyidutsinguli djenu aduvu bambatsi bami, duyabe na ghome ombu djowu abeboki dunyuru, mumbari baghorungule uduvaghe dyambu disusu. ");
INSERT INTO puu_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Nyudulase vengu awu dudume: dumanu Nzambi mumbari payi dumafu, orungule ubwaghe yinyuni wandi o dyange di mudji. Nine, djandi awu dudume. ");
INSERT INTO puu_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Baghesumbisi tsoli yiranu tsigheyi mu fure bedji? Nzambi aghélibini ne djimosi. ");
INSERT INTO puu_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Ne nange tsyenu tsyotsu tsi myuru tsitalu. Duyadume, djenu duvyoghulile batsoli.» ");
INSERT INTO puu_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","«Nyidutsinguli, wotsu onyeme menu va kande batu, Mwane Mutu wandi omunyeme va wusu byanze bi Nzambi novose rye: awuwu mutu ami. ");
INSERT INTO puu_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Tumbe owughale menu va misu ma batu, mewandi nyumughale va wusu byanze bi Nzambi. ");
INSERT INTO puu_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Awu ovose kulini mu Mwane Mutu, otandu, tumbe awu ulenze Yinyuni Yisyeme, aghotandu. ");
INSERT INTO puu_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Payi bodusosise mu mandaghu ma tsambu ma baSwife va wusu banzonzi na barumitsi, duyalabe ghome mu motsu duvose mu kekaghule. ");
INSERT INTO puu_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Yinyuni Yisyeme yuduveghe vane-vane mambu ame durungule uvose.» ");
INSERT INTO puu_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Mutu wumosi va ghari yinombu akevose na Djesu rye: «Mulonzi, tsingule mwane ngudji ami yiri tughabini disyale.» ");
INSERT INTO puu_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Djesu akemuwake rye: «Dibaale, anyi atsimbyatse nzonzi enu umudughabile disyale dyenu?» ");
INSERT INTO puu_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Mbana, akelubuse botsu rye: «Kebananu na nzale neni dji busine, mumbari monyu mutu wughaa mu durangu du bime abivu nandi.» ");
INSERT INTO puu_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Na akebabukile nongu: «Manungi ma yisine ma mabure bighudji bipwele. ");
INSERT INTO puu_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Na akekéwivulaange yiri: “Tsyeni ngavayile? Ngaane bitale biwelimine byusweyile dighumbe. ");
INSERT INTO puu_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Kaboghu, nyupanze bitale byotsu, na nyurunge bisweghulu abineni, mu ukelise bighudji na maboti mami motsu. ");
INSERT INTO puu_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Nyukésingisile mebeni: Labe, wuke na maboti mapwele bilime na bilime, tsyétsani, djangaange, nwangaange mbana saghaange.” ");
INSERT INTO puu_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Tumbe Nzambi akemutsingule: “Kamune yiduke yi, na mukolu eni wuwu wufu. Maboti motsu ameghutsighukighe na nyi mosyale?”» ");
INSERT INTO puu_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Djesu akebwévose rye: «Anane dyube ombu mutu oyighukiyi busine mu djabeni, tumbe aghaane busine mu mambu ma Nzambi.» ");
INSERT INTO puu_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Djesu akevose na badukitsi bandi rye: «Ladibandu, nyidutsinguli: duyabe na munyongu mu monyu enu mu dyambu di bighudji. Duyabe na munyongu mu dunyuru dwenu mu dyambu di bidwaru. ");
INSERT INTO puu_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Djabanu rye: monyu wuvyoghulile bighudji; dunyuru duvyoghulile bidwaru. ");
INSERT INTO puu_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Labatyanu bavange! Baghevari, baghedokuli milunde, baghaane bitale vo mireri, tumbe Nzambi ebabunguli. Tambusu na djenu batu, duvyoghulile batsoli dighobe. ");
INSERT INTO puu_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Anyi na manyoni mandi, orungule wukebwese mwa pesu temu mu monyu andi? ");
INSERT INTO puu_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Payi dughorungule wutsonzighe dyambu digheyi, dibandu yi dubile na manyoni mu masusu? ");
INSERT INTO puu_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Labatyanu nane tsangu tsifulili mu biriri bi musiru, tsighesali, tsigherariyi bikutu. Nyidutsinguli: ne kaghe Salemu, mu bundumbe bwandi bwotsu, asamadwaraange burange nane tsangu tsyeni. ");
INSERT INTO puu_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Kaboghu, yi dubile na yitu yi gheyi? Payi Nzambi ebwedjisi tsangu eni yilumbu yéyiyi adjunyenzu mughese, tambusu na djenu batu, tsyeni aghorungulile wududwisile? ");
INSERT INTO puu_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Djenu, duyalabe keri mu abi dudji vo abi dunu. ");
INSERT INTO puu_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Byotsu bine, bise bulongu abaghabaware mu Nzambi bebirombi. Tadji enu adjivu o djulu edjabi nzale tsyenu. ");
INSERT INTO puu_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Tumbe djenu, lerombanu Bukaghe bu Nzambi na byotsu bine, byuduveghu va djudjulu.» ");
INSERT INTO puu_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","«Djenu mughambe wugheyi wu bindombu, duyalabe keri, Tadji enu atsisole uduveghe Bukaghe bu Nzambi. ");
INSERT INTO puu_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Sumbisanu abivu nenu na veghanu mbongu ombu bidjaghe. Anane dukerungile komi adjighofu na dughukighe busine abughosuke o djulu, abughobembu na badayi, ne batsyelili baghobubunge. ");
INSERT INTO puu_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Mumbari ave busine bwenu buvu, avane murime wandi wuvu.» ");
INSERT INTO puu_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","«Warisanu matsande menu na banzanu lambi tsyenu. ");
INSERT INTO puu_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Banu nane basalitsi abevivi fumu owu atsiwende o mulambu udiwele, bebi batsonzeme mu umudibulile mune ndaghu ave oghabuyile na edukisi. ");
INSERT INTO puu_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Ubwedji ombu basalitsi abomoghaange mu uvive fumu owu. Payi ditsibe nane, dingenze, nyidutsinguli: owarise tsande andi, obanengile va tavule, na djabeni obaghabile bighudji. ");
INSERT INTO puu_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Akerughe va ghari wisi vo va matebughulu, ubwedji ombu basalitsi abe erasunu bemoyi.» ");
INSERT INTO puu_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","«Ghulwatyanu, fumu ndaghu mbé edjabi temu adji mudayi oruyili mu uyibule ndaghu, nyitasi rye mbé omoghe mu ughaghe ndaghu andi. ");
INSERT INTO puu_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Djenu wandi banu dukunzeme mumbari dughejabi temu adji Mwane Mutu oruyile.» ");
INSERT INTO puu_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Pyere akewivule rye: «Fumu, djetu wibukili nongu edjine vo batu botsu?» ");
INSERT INTO puu_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Fumu akemuwaghule rye: «Musalitsi wusigheme na awuvu na dyele anyi? Djandi o fumu oveghe musughe wukelise ndaghu andi noghabilaange basalitsi abane bighudji mu temu adjiwelimine. ");
INSERT INTO puu_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Ubwedji ombu musalitsi eni o fumu ndaghu oyirasunu ekelisi ndaghu andi. ");
INSERT INTO puu_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Dingenze nyidutsinguli: fumu ndaghu omuveghe musughe mu urumise busine bwandi bwotsu. ");
INSERT INTO puu_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Tumbe, musalitsi eni amavose mu murime andi rye: “Fumu ami agholerughe.” Djandi yikebi mu udimbise basalitsi ba babaale na ba baghetu, na yikebwébe mu udji, mu unu na mu ulange. ");
INSERT INTO puu_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Yikevayi nane, fumu andi orughe mu temu adji djandi aghodjabe. Omubinge mbana omughabile fute adjiwelimine na djowu abaghabasungeme. ");
INSERT INTO puu_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Kaboghu, musalitsi awidjabi adi fumu andi erondi, mba aghedivayi, odimbusu kube neni. ");
INSERT INTO puu_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Tumbe musalitsi awughesali bisalu abi fumu andi erondi, mumbari aghejabi adiwelimine ombu fumu andi, okilusu mwa pesu. ");
INSERT INTO puu_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","«Nzirughe o uyibwaghe mudji mu butambe, nyirondi bwena wukelulaange. ");
INSERT INTO puu_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Vengu nyubatusu, kamune munyongu wuvu nami tena dyoni dyudughusu! ");
INSERT INTO puu_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Dwitasi yiri nyimarughe mu butambe mu udubeyile duvotsu? Nesi, tsi duvotsu, tumbe dupasu. ");
INSERT INTO puu_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Ubongile na muni, mukute wu batu baranu wukakene, baryeru bovine babedji, na babedji bovine baryeru. ");
INSERT INTO puu_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Tadji ovine mwane andi na mwane ovine tadji andi; ngudji ovine mwane andi na mwane ovine ngudji andi. Ngudji mwane dibaale ovine mughatsi mwane andi; mughatsi mwane ovine ngudji mulumi andi.» ");
INSERT INTO puu_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Djesu akebwévose na yinombu rye: «Ave dwilabili didudumbi diruyisini o wisi eputumini, dwivosi bwena, “mvule onoghe”, na djoni djinoyi. ");
INSERT INTO puu_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ave dwiwululu mupunge wipepili o yari yi bande, dwivosi yiri “vobe yusile” na yusile yeni yibi. ");
INSERT INTO puu_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Bapende nane djenu, ave dwighengili djulu na butambe, dwidjabi wukelule yidenzi yi mvule na yi mungudi. Yike tsyeni dugherungusili wudjabile mambu ma temu édjidji?» ");
INSERT INTO puu_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","«Dibandu yi dughekelulingi djenubeni mambu na murime wuwelimine? ");
INSERT INTO puu_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Payi mutu naghu amaghufwengilile dyambu, ave eghubeyili o mufundu, ditsonziyi nandi mu nzile, ne duketole ombu nzonzi. Mumbari nzonzi akeghuwakise ombu yivunde yi baghore, na baghore beni bakeghukotise o tsughu. ");
INSERT INTO puu_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Nyighutsinguli: wugholepale o tsughu, payi wukamane ufute mughanu wotsu kwange na fure adji nzintu.» ");
INSERT INTO puu_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Va temu eni mwa dighuki di batu, bamarughe oyi tsingule Djesu adimavyoghe: ave batu bamosi ba Ngalile, bamavaghulilaange paghu ombu Nzambi, Pilate akerume batu bandi ubaboke vane, mu usobene malungu mowu na ama paghu. ");
INSERT INTO puu_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Djesu akebawake rye: «Dwitasi yiri, bise Ngalile beni abamaboku nane, bamabe bavayitsi ba mabi bavyoghulile bise Ngalile botsu? ");
INSERT INTO puu_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Nesi, payi dwitasi nane, dumakedunze. Nyidulubusi yiri, payi dughakaluse mutsanu, dufu nane djowu. ");
INSERT INTO puu_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Ka dighumi na yinane (18) yi batu abamaviku na ndaghu ndeki adjimarakughe o Siluwé, batu beni bamabe bavyoghulile bise Serusaleme djotsu uvaghe mabi? ");
INSERT INTO puu_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Nesi, nyidulubusi: payi dughakaluse mitsanu myenu, dufu nane djowu.» ");
INSERT INTO puu_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Djesu akebabukile nongu édjidji rye: «Umabe mutu amabe na mumange wuvaru o nungi andi. Akewende yilumbu mu uronde uyéboole mimange, tumbe misamabe. ");
INSERT INTO puu_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Mbana, amavose na musatsi nungi rye: “Labati, bilime bike biryeru, nyiruyingi muyidokule mimange mu mumange éwuwu ngedili ne wumosi. Uwangi, wivayi fuyi mwenzili.” ");
INSERT INTO puu_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Tumbe musalitsi akemuwaghule: “Fumu, lewusile yilime ayiyi, ngaghufutse byari byotsu na nyusobene butambe bweni na bu dibumbu. ");
INSERT INTO puu_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Tangudji, wubure yilime ayiruyi. Payi wughabure, tukewuwaange.”» ");
INSERT INTO puu_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Mu yilumbu yuvume yi baSwife, Djesu amalonzaange musamu wu Nzambi o ghari ndaghu wowu dusambu. ");
INSERT INTO puu_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Vane, vamabe mughetu wumaveghu bubomfi na yinyuni yibi mu dighumi na yinane (18) yi bilime. Amabelaange ngodju djimabe djimughorighe, asamabwérungulaange usimbughe. ");
INSERT INTO puu_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Na Djesu emulabi, akemunengile, akemutsingule rye: «Mame, bubomfi bwaghu bumaghusulu.» ");
INSERT INTO puu_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Akemusakighe makake. Vane-vane, nzime djikesungeme na akedodise Nzambi. ");
INSERT INTO puu_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Tumbe yivunde yi ndaghu eni dusambu akenyoghe, mumbari Djesu amabeluse mutu mu yilumbu yowu yuvume. Akevose na yinombu rye: «Vadji bilumbu bisyamunu byusalile, kaboghu rughenganu bilumbu byébine mu yibelusu. Payi yilumbu yuvume tsatsabi, duyabwérughaange.» ");
INSERT INTO puu_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Fumu anomuwulu, akemuwaghule: «Bapende nane djenu! Mu yilumbu yuvume, vagha mutu va ghari enu enyanguli ngombi vo buru andi mu umubeghe oghunu mambe mu yilumbu yeni? ");
INSERT INTO puu_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Mughetu éwuwu, mwane Aberaame awu Dyabu amatsoyise mu dighumi na yinane (18) yi bilime mbé aghapatulu va makake mandi mu yilumbu yuvume?» ");
INSERT INTO puu_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Djesu na evosi nane, bambeni bandi bakebase na yisoni. Yinombu yotsu yikesaghaange dibandu mambu amaboti maneni ame Djesu amadughusungu. ");
INSERT INTO puu_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Djesu akebwévose: «Bukaghe bu Nzambi na yi bubaghunu? Na yime yi nyububaghusunu? ");
INSERT INTO puu_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Bubaghunu na tsangu gheyi mutu eyekuke mu nungi andi. Ave djibendili, djipalisi mwiri wuneni wuvu na matayi na batsoli beyirunge muve mowu.» ");
INSERT INTO puu_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Djesu akebwele uvose rye: «Na yi nyubaghusunu Bukaghe bu Nzambi? ");
INSERT INTO puu_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Bubaghunu na yifunise ayi mughetu ebongi, akesobene mu ditingi di maghumi mabedji na byetsu biranu bi fufu mu ufunise pate-mape djotsu.» ");
INSERT INTO puu_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Ave Djesu amabile mu nzile mu wende o Serusaleme, akenesikemange mu misyengi na mu mimbu mu yenelongaange musamu Nzambi. ");
INSERT INTO puu_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Ave amenewendilaange, mutu wumosi akemuwivule bwena «Fumu, yike bu mwa pesu batu aboghobulu?» Djesu akebawaghule: ");
INSERT INTO puu_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","«Vovenanu mu ukote, va mune ndaghu awubandene. Mumbari nyidutsinguli, bapwele boronde ukote, tumbe baghorungule. ");
INSERT INTO puu_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Ave Fumu ndaghu orelimine, mudibighe mune ndaghu, djenu adube o dulombili, dudukise mu yabutsu novose rye: “Fumu tudibulili.” Oduwaghule rye: “Ngedjabi awudwiruyisini!” ");
INSERT INTO puu_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Mbana dumutsingule rye: “Djetu tumadji na tumanu va mosi naghu, na wumenelonzaange musamu mu manzile ma misyengi myetu.” ");
INSERT INTO puu_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Obwébawaghule rye: “Ngédjabi odwiruyisini. Ndundyanu, ghusughanu vane djenu botsu bavayitsi ba mabi!” ");
INSERT INTO puu_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Dulile na dughénighe minu ave dulabile Aberaame, Yisaake, Sakobe na babiyitsi botsu o Bukaghe bu Nzambi, mbana djenu dubwaghu o dulombili! ");
INSERT INTO puu_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Batu borusenaange tandu na bande, o wisi epalili, no wisi eputumini. Botsane va mosi va mulambu o Bukaghe bu Nzambi. ");
INSERT INTO puu_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Kaboghu, ");
INSERT INTO puu_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Va djulu vane, baFarisi bamarughe mu uyilubuse Djesu rye: «Rambughe na wusughe vave, mumbari Yirode erondi ughuboke.» ");
INSERT INTO puu_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Djesu akebawaghule rye: «Wendanu, yetsingulanu yitsalele yéyine: “Nyisanzi bayisi, na nyibelusi bibedu na muni na mughese, mu yilumbu ayimuryeru nyumane yisalu.” ");
INSERT INTO puu_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Tumbe, ubongile na muni, mughese na mune-mosi nyuyenewende, mumbari digha diwelimine yiri mubiyitsi akefwile yari yisusu patsi o Serusaleme. ");
INSERT INTO puu_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Serusaleme, djenu bise Serusaleme, dwiboki babiyitsi na dwitindi mamani ombu bobésindughu ombu wenu. Kumbu kweni mbé nyironde udughukighe mu dughumbe nane koku eghukiyili noghumbe baane bandi otsi mapapi mandi, tumbe dusamagharu. ");
INSERT INTO puu_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Kaboghu, ndaghu enu djusyale mududu. Tumbe dughobwéndabe tena duvose yiri “Nzambi apuyili myule ombu djandi oyiruyili mu dine di Fumu!”» ");
INSERT INTO puu_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Mu yilumbu yuvume yi baSwife, Djesu amakote o ndaghu yivunde yimosi yi baFarisi mu uyédji nandi. Botsu vane bamabe liyiyi mu ulabe adi Djesu ovaghe. ");
INSERT INTO puu_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Vane, vamabe mutu amabe na matindi. ");
INSERT INTO puu_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Djesu amabande uvose na akewivule milonzi mi mighaghe na baFarisi: «Divu diwelimine mu mughaghe Moyise, nine vo nesi, ubeluse mutu mu yilumbu yuvume?» ");
INSERT INTO puu_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Basamamuwaghule, bakebe «swii». Kaboghu Djesu akeghelughe nobembe yibedu, akemubeluse mbana akemutsingule yiri yenewende o ndaghu andi. ");
INSERT INTO puu_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Mbana akeghelughe ombu bobamamutsunaange, amabawivule: «Anyi va ghari enu, yike mwane andi vo ngombi andi ebonduyi o ghari yidune yilumbu yuvume, aghomupalise?» ");
INSERT INTO puu_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Na djowu basamarungule umuwaghule. ");
INSERT INTO puu_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Anolabe yiri botsu bamanengulu o mulambu, bamasolaange bitsighe biteghe bi bundumbe, amavose nongu édjidji: ");
INSERT INTO puu_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","«Yike mutu ewunengili o mulambu diwele, wuyatsutsile uyétsane o yitsighe yiteghe. Tangudji, va ghari botsu abamanengulu vakirughe mutu awu wuvyoghe dighobe, ");
INSERT INTO puu_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","na omadunengile djenu botsu babedji, yike eruyi mu wutsingule rye: “Muvyosi va yitsighe yaghu!” Ghureleme na yisonyi mu wende o yitsighe ayisuke o nzime. ");
INSERT INTO puu_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Nesi, payi unengulu, léwende o yitsighe ayinzime. Mbana omadunengile, ave okotile, oghutsingule rye: “Mbatsi ami, rughe va yitsighe ayi bwedji wunu wusu.” Avane, wube na dighobe va ghari botsu abavu vane. ");
INSERT INTO puu_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Nine, ");
INSERT INTO puu_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Djesu amamwévose na awu amamunengile: «Payi wiveyi mulambu wu mwangulu vo wu tsisighe, uyanengile bambatsi baghu, baane ba ngudji baghu, biburu byaghu vo bisine abibambene naghu. Yike wivayi nane, djowu wandi borungule uwunengile na uwughabusile diboti adiwumabavaghe. ");
INSERT INTO puu_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Nesi, payi wiveyi mulambu, nengile bidjaghe, bibomfi, bimbolutu na bidunge. ");
INSERT INTO puu_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Yike wivayi nane, wulabe nzangu mba ngenze, batu bebane baghorungule uwughabusile. Byonyi byuwughabusulu vo Nzambi orambusile bo basungeme o dufu.» ");
INSERT INTO puu_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Mu dyoni, mutu mosi amabe va tavule amavosile Djesu rye: «Ubwedji ombu mutu owudji mulambu o Bukaghe bu Nzambi!» ");
INSERT INTO puu_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Djesu amamuwaghule na nongu édjidji rye: «Vamabe yilumbu, mutu wumosi amavaghe mulambu wuneni. Akenengile batu bapwele. ");
INSERT INTO puu_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Diweru dyudji dinotole, akesindighe musatsi andi uyenengile bo mbé boyidji: “Tsyérughyanu, byotsu bimakunzeme!” ");
INSERT INTO puu_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Tumbe botsu abane, bamavonde kokolu mumbari bamabe na bibinde. Awuteghe akemutsingule rye: “Nyitsisumbe nungi, nyileyedjilabe. Wuyanzyembe, kokolu tsyaghu.” ");
INSERT INTO puu_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Wumosi akevose rye: “Nyibenodile dighumi di ngombi, nyileyetsi wétsighe, tandi.” ");
INSERT INTO puu_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Wumosi wandi akemwévose: “Menu nyibonowele mughatsi ami, kaboghu ngodile temu.” ");
INSERT INTO puu_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Vo musatsi amaghabuyile ombu yivunde yandi, amamutsingule bibinde byotsu bamamuveghe. Fumu ndaghu amanyoghe kabu na amavose na musatsi rye: Lenge! Wende mu mbure tsi mughungi na mu mimbambe mi musyengi na beghe bidjaghe, bibomfi, bidunge na bimbolutu! ");
INSERT INTO puu_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Mu mwa pesu temu, musatsi amarughe na amamutsingule rye: “Fumu, nyimavaghe nane wutsinzingulile, tumbe vakisyale mambure.” ");
INSERT INTO puu_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Kaboghu fumu andi akemutsingule rye: “Wende mu manzile, mu mighule bivaghe, ghome batu yi borughe mumba ndaghu ami djikebase. ");
INSERT INTO puu_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Mbana nyighutsinguli, vagha mutu ne wumosi mu bo bamarele unengulu, baghobwémimbe mulambu éwuwu!”» ");
INSERT INTO puu_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Binombu bineni bimawenda konge na Djesu. Amaghelughe nzime na amabitsingule rye: ");
INSERT INTO puu_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","«Payi mutu erondi unduke, aletonde pwele wuvyolile uronde tadji andi, ngudji andi, mughatsi andi, baane bandi, baane ba ngudji bandi, babaale vo baghetu, ne monyu andi. Patsi nane, aghorunguse ube mudukitsi ami. ");
INSERT INTO puu_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Na wotsu aghonangule kurusu andi mu unduke, aghobe mudukitsi ami. ");
INSERT INTO puu_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Payi mutu ane ditase dyurunge ndaghu ndeki, eletsane mu djabe durangu du mbongu na bisalulu nolabe yiri orungule umane. ");
INSERT INTO puu_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Ave obandile usale yibughe payi aghamwérunguse udjimane, bobamamulabe ubande urunge, bomusyembaange, ");
INSERT INTO puu_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","novose rye: “Mutu éwuwu amabande urunge ndaghu na aghamwédjimanisile!”» ");
INSERT INTO puu_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Na Djesu akebwévose rye: «Kaghe nyi, payi otoghe divite na kaghe susu, aghéletsane mu kelule yiri na dighumi di tosini baghore obenze uyébengusunu oyiruyi mu yimutoyise na maghumi mabedji ma tosini baghore? ");
INSERT INTO puu_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Payi aghaane mangolu mawelimine, otinde bilumbi mu uvonde duvotsu pa kaghe eni akivale! ");
INSERT INTO puu_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Kaboghu munongu mosi, wotsu aghorungule usile maboti mandi motsu, agha awelimine ube mudukitsi ami.» ");
INSERT INTO puu_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Djesu akebwévose rye: «Musayi yime yiboti, tumbe payi musayi wumasambughe, yike yi yubwémughabusile mughangu? ");
INSERT INTO puu_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Asane yisalu mu butambe vo o dibumbu, yike ubwaghu o dulombili. Wotsu avu na matudji limbaa, awulu!» ");
INSERT INTO puu_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Babolitsi ba lepu na bavayitsi ba mabi bamabambene na Djesu mu uyéwulu malongi mandi. ");
INSERT INTO puu_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","BaFarisi na Milonzi mi mighaghe bamavosaange ba fundu rye: «Mutu éwuwu akegharungu udji va mosi na bango mabi!» ");
INSERT INTO puu_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Tumbe, Djesu akebabukile nongu édjidji rye: ");
INSERT INTO puu_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","«Anyi va ghari enu, avu na kame bindombu, na akitsyemuse yimosi, aghesili maghumi-dufu na yifu (99) yi bindombu mu kumu, mu uyenerombe ayitsitsyemughe tena vo oyilabile? ");
INSERT INTO puu_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Ave eyilabili, ebasi na nzangu, eyinanguli no yisunze va masambeke. ");
INSERT INTO puu_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Anotole o ndaghu andi, akenengili bambatsi bandi na botsu ababambene nandi novose rye: “Rughanu, tusayanu: yindombu yami ayi mbé yimatsyemughe, yimalabene.” ");
INSERT INTO puu_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Divu munongu mosi o djulu, ave muvayitsi mabi wumosi ekaluyili mutsanu, nzangu neni djibi o djulu uvyoghulile adji maghumi-dufu na yifu (99) yi batu basungeme abasane nzale ukalughe mutsanu.» ");
INSERT INTO puu_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Djesu amamwébabukile nongu: «Payi mughetu ane dighumi di doli, yike etsyemusi dumosi, yi ovaghe? Obanze paghe, oghombule ndaghu, odurombe yari na yari tena odulabe. ");
INSERT INTO puu_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Yike edulabi, enengili bambatsi bandi ababambene nandi nobatsingule rye: “Rughanu, tusayanu, doli dwami adu mbé dumatsyemughe, nyimadulabe.” ");
INSERT INTO puu_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Munongu wumosi nyidutsinguli bwena: nzangu neni djibi ombu byanze bi Nzambi ave muvayitsi wumosi wu mabi ekaluyili mutsanu.» ");
INSERT INTO puu_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Djesu amamwébabukile nongu mosi rye: «Vamabe dibaale dimabe na baane babedji ba babaale, ");
INSERT INTO puu_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Awu ngebi amavose na tadji andi rye: “Tate, peyi dyami dikabu di disyale.” Tadji akebaghabile maboti mandi. ");
INSERT INTO puu_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Bilumbu binovyoghe, ngebi akesumbise byandi byotsu, akenewende na mbongu tsyandi o malongu ma vale. Aghune, akenyambesene mbongu tsyandi tsyotsu mu monyu dimbunge. ");
INSERT INTO puu_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Anonyambesene byotsu, dungosu du nzale dukabe o bulongu bweni na akebande ulabe maghughe na asamamwébe na ayi udji. ");
INSERT INTO puu_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Akewende oyevonde dibaale di mwise bulongu bweni bisalu. Tumbe dibaale dyeni, akemutinde o masaku o wumabe yivange yandi yi bangulu mu ubakelisaange. ");
INSERT INTO puu_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Djandi amarondaange ne udji bipupu bi bighudji bamaveghaange bangulu, tumbe vasamabe mutu amamugharusu. ");
INSERT INTO puu_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Amabande urangimine na amavose rye: “Basatsi ba tate bedji bighudji usyalulu, mbana menu wunu utopulu nyi topulu na nzale. ");
INSERT INTO puu_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Nyughabughe ombu tate na nyumutsingule rye Tate, nyimavaghe disumu va wusu Nzambi na va wusu awu. ");
INSERT INTO puu_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Nyisa nyiwelimine wunengulu mwane aghu, tumbe mbongi na nane musalitsi aghu.” ");
INSERT INTO puu_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Amareleme noghabughe ombu tadji andi. Tadji andi anomulabile, ne nane mbé akivale, akebase na yingebe. Akewende mbangu na nzangu mu uyémubumbe mu kingu. ");
INSERT INTO puu_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Vane-vane, mwane akevose rye: “Tate, nyimavaghe disumu va wusu Nzambi na va wusu aghu. Nyisa nyiwelimine unengulu mwane aghu.” ");
INSERT INTO puu_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Tumbe tadji akevose na basatsi bandi rye: “Lenganu nobeghe bikutu bi dufunu, mudwisyanu, muvakighyanu moru nomudwise bapondu. ");
INSERT INTO puu_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Beghanu ngombi adjivonge, djibokyanu, lambanu, tudjanu na tusayanu, ");
INSERT INTO puu_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","mumbari mwane ami wuwu mbé amafu, amaghabughe monyu; mbé amatsyemughe, amalabene.” Bakebande usaghe. ");
INSERT INTO puu_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Yivunde amabe o manungi. Ave amaghabuyile, anotole bebeli na ndaghu, amawulu nduku bisighu na miyinu. ");
INSERT INTO puu_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Amanengile musatsi wumosi, amamuwivule dyambu adivyoyi. ");
INSERT INTO puu_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Musatsi eni amamuwaghule rye: “Mwane ngudji aghu amaghabughe. Tadji aghu atsirume uboke ngombi djivonge, mumbari ngebi awu atsighabughe polu.” ");
INSERT INTO puu_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Yivunde akebase na kabu, akebuse ukote o ndaghu. Tadji akepale, akeyemulende akekote. ");
INSERT INTO puu_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Tumbe yivunde akewaghule tadji andi rye: “Labati, pwele bilime nyighusalili, ngekikuli ne dirume dyaghu dimosi. Ukapeghaange ne mwa tabe ‘vyaa’ nyikesaghe na bambatsi bami. ");
INSERT INTO puu_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Tumbe mwane awu aghabuyilaange, djandi omadji maboti maghu na bimbembu, tsya djandi wumabokile ngombi adjivonge!” ");
INSERT INTO puu_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Tadji akemuwaghule: “Aa! Ndewandi mwane ami, wudji nami temu djotsu, byotsu abivu nami, abyaghu wandi. ");
INSERT INTO puu_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Kaboghu diwelimine yiri tudjanu nosaghe va mosi, mumbari mwane ngudji aghu: ");
INSERT INTO puu_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Djesu etsinguli badukitsi bandi rye: «Yisine yimosi amabe na musatsi wumabe yivunde yi basatsi botsu. Batu bakemufunde bwena: “Musatsi aghu ebungi nonyambesene maboti maghu.” ");
INSERT INTO puu_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Fumu maboti akenengile musatsi eni, akemuwivule yiri: “Yi nyiwulu bévosili mu ndedju? Nzinguli nane wikelisili maboti mami mumbari wughobwémakelise.” ");
INSERT INTO puu_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Musatsi eni, akekéwivulaange: “Yivunde yami aghébwéronde yiri ngakelise maboti mandi. Yike tsyeni nyuvayile? Nyivayi manungi, ngaane mangolu; nyibi mu uvonde, nyube na yisoni. ");
INSERT INTO puu_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Kaboghu nyimadjabe adi nyikivaghe ave nyikighusululu mu bisalu, mu udilu na batu nami mu mandaghu mowu.” ");
INSERT INTO puu_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Musatsi eni amanengile mutu-mutu omabe na mughanu. Akewivule awuteghe: “Kweni winwani Fumu ami?” ");
INSERT INTO puu_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Djandi akemuwake rye: “Kame mireghe mi matsi.” Musatsi akemutsingule: “La mughande, lenge utsane na rende maghumi maranu.” ");
INSERT INTO puu_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Akebwéwivule wumosi wandi: “Ka ndedju, kweni winwani?” Dibaale dyeni akemuwake: “Kame saku tsi bighudji.” Musatsi akemutsingule: “La mughande, rende maghumi-dunana (80).” ");
INSERT INTO puu_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Kaboghu, fumu maboti akesingisile musatsi eni yifutsi mu dyele adi djandi amadile. Labatyanu nane batu ba bulongu bwébubu babile na mele maneni, wuvyoghulile ne baane ba yidjalale.» ");
INSERT INTO puu_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Djesu akebwese rye: «Nyidutsinguli, salisanu busine bwenu na mbongu tsi mfurulu, mu udile bambatsi, mumbari ave busukile, dudilu mu mandaghu ma Nzambi. ");
INSERT INTO puu_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Odjivu awelimine udughusu mambu amagheyi na musighe, awelimine wandi udughusu amaneni. Djandi oyifuri vo udyonge mu mambu magheyi, ofure na udyonge wandi mu mambu amaneni. ");
INSERT INTO puu_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Payi dusamabe dusigheme mu busine bu mfurulu, anyi oduveghe busine abu ngenze? ");
INSERT INTO puu_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Na payi dusamabe dusungeme mu maboti ma ngane, anyi oduveghe maboti amajenu beni? ");
INSERT INTO puu_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Vagha mutu orungule usalile fumu bedji: ovine wumosi, akeronde wune, vo oghobise wumosi na akelenze wune. Kaboghu, dughorungule usalile Nzambi nosalile mbongu va mosi.» ");
INSERT INTO puu_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","BaFarisi, na nzale mbongu, banowulu motsu ame Djesu amavosaange, bakemupedjingi. ");
INSERT INTO puu_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Djesu akebatsingule rye: «Djenu dudji batu békelase yiri basungeme va wusu batu nenu, tumbe Nzambi edjabi mirime myenu. Motsu, ame bédodisi va misu ma batu, madji nzoruru va wusu Nzambi. ");
INSERT INTO puu_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Mughaghe Moyise na mughande babiyitsi mimabe vane tena San-Batise. Ubandile va temu San-Batise, musamu wuboti wu Bukaghe bu Nzambi wisamunu. Mutu-mutu oghaghene mu uyékote wune. ");
INSERT INTO puu_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Djulu na butambe byurungule utsyemughe mbangu-mbangu, tumbe ne yirendu yimosi mu mughaghe yighorungule utsyemughe. ");
INSERT INTO puu_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Dibaale dyotsu adisanzi mughatsi andi na eweli wususu, etubi bukali. Mbana, wotsu eweli mughetu wusanzu na mulumi andi, djawandi etubi bukali.» ");
INSERT INTO puu_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","«Vamabe yisine yimadwaraange bikutu bi dufunu duneni. Bilumbu bi monyu andi wotsu, amabangaange mu nzangu, mumbari amabe na busine buvyoghulile. ");
INSERT INTO puu_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Vamabe wandi yidjaghe dine dyandi Lasare, amabe na mapure. Batu bakimusunzaange kale yilumbu va mune ndaghu yisine yeni. ");
INSERT INTO puu_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Lasare, amarondaange ubole nodji bikukuku abimabondughaange va tavule yisine. Tumbe bamondi bamayivendaange mapure mandi. ");
INSERT INTO puu_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Mwa yilumbu, yidjaghe akefu, akebeghu na byanze va tulu Aberaame. Yisine wandi akefu, bakemutsighe. ");
INSERT INTO puu_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Aghune bulungi bu mudji, yisine amatsoghaange pwele. O vale, amabilile Lasare va tulu Aberaame. ");
INSERT INTO puu_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Wune disimu dimosi, yisine akeghamughe rye: “Tate ami Aberaame, nda ngebe. Sindighe Lasare aputiyi kodu mulembu andi mu mambe na andekisi diberi va dulimi, mumbari ngorungule wuwarile ditsoghe adidi o ghari mudji éwuwu.” ");
INSERT INTO puu_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Tumbe Aberaame akemuwaghule rye: “Mwane ami, rangimine monyu aghu, wumabe mu maboti na maboti, mbana Lasare djandi amabe mu maghughe. Tumbe aghunu, Lasare yike wubembughu, ebembughu, mbana ndedju, temu awumaghughe djimatole. ");
INSERT INTO puu_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Va ghari djetu nenu vadji mbengi neni, mumbari djenu aduvu wune, dughorungule usabughe awutuvu. Djetu wandi, tughorungule wusabughe awuduvu.” ");
INSERT INTO puu_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Yisine akemutsingule bwena: “Tate Aberaame kokolu nyighulendi, kaboghu sindighe Lasare o ndaghu tadji ami. ");
INSERT INTO puu_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Mumbari nyine baane ba ngudji baranu ba babaale. Lasare awendi mu uyébalubuse yiri bakérughe djowu wandi o mbure adjidji dji maghughe.” ");
INSERT INTO puu_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Aberaame akemuwaghule rye: “Baane ba ngudji baghu bane musamu wu Moyise na awu babiyitsi awibalubusi, kaboghu bawughulu nowutsiyise!” ");
INSERT INTO puu_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Yisine akemuwake rye: “Nesi tate Aberaame tsinane. Mutu awu mbé wumafu, awendi ombu wowu, ayebatsingule, tangudji bokalughe mutsanu.” ");
INSERT INTO puu_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Aberaame akemutsingule djawandi rye: “Payi djowu baghagharu uwulu mambu ma Moyise na ma babiyitsi, baghogharu uwulu wandi musamu ne ame djandi omarambughe o dufu.”» ");
INSERT INTO puu_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Djesu amatsingule badukitsi bandi rye: «Vobangaange mambu amorobisaange batu uvaghe mabi. Kamune maghughe-ma, ombu mutu owurombise bambatsi uvaghe mabi! ");
INSERT INTO puu_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Mutu eni, yike erombisi ne ngebi mosi uvaghe mabi, mbé dyuwelimine mu djandi bakemutunge dimani dineni mu kingu nomubwaghe o mubu. ");
INSERT INTO puu_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Kebenanu, payi mwane tadji aghu evayi dibi, mughabusi mu nzile. Na yike edinyongi, mutandi. ");
INSERT INTO puu_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Payi eghuvayili dibi yisambwali yi kumbu mu yilumbu, na yikéghabuyi yisambwali yi kumbu wandi mu uyuvonde kokolu, mutandi.» ");
INSERT INTO puu_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Bilumbi bimatsingule Fumu rye: «Warise yitu yetu mu Nzambi.» ");
INSERT INTO puu_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Fumu akewaghule: «Payi yitu yenu yibaghunu na tsangu tsigheyi, durungule urume mwiri éwuwu yiri “kerubule, yekevare o mubu”, na wududedile.» ");
INSERT INTO puu_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","«Anyi, va ghari enu avu na musatsi, wivayi manungi vo wukelise bindombu, ave djandi eruyili o manungi, mu temu eni, akemutsingule rye: “Rughe, tsane na djange”? ");
INSERT INTO puu_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Vyaaghe, dumutsingule yiri: “Léndambile bighudji, mbana yevinze bikutu, yinzunzile bighudji ngadji, nganu. Avane wusu, ndewandi wudji na wunu.” ");
INSERT INTO puu_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Dusingisile musatsi mumbari atsisale byotsu abidutsimurume? ");
INSERT INTO puu_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Munongu mosi nenu. Ave dwidughusulu motsu ame bédurumi, vosanu rye: “Djetu, tudji basatsi abaghékelisi dusingusulu, mumbari twidughusu yike yisalu ayimaturumu.”» ");
INSERT INTO puu_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Ave Djesu amawendilaange o Serusaleme, amavyolaange va ndilu Samari na Ngalile. ");
INSERT INTO puu_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Ave amatolile va dimbu dimosi, dighumi di bibedu bi nyámbi dimamubengusunu tumbe, basamabambene nandi. ");
INSERT INTO puu_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Na bibedu byeni bikeghamughe rye: «Djesu, Fumu, tulabi wandi yingebe!» ");
INSERT INTO puu_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Ave Djesu amabalabile, akebatsingule rye: «Wendanu, yekelasanu menu ombu bavaghulitsi ba paghu.» Ave bamayene wendilaange, mu nzile bamabelughe. ");
INSERT INTO puu_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Wumosi va ghari owu, anolabe bwena amabelughe, akeghabusile mu nzile adji amavyole, akenedodisaange Nzambi na mighamu. ");
INSERT INTO puu_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Akeghudume va wusu Djesu, mbami na tsi, na akemughabusile diboti. Mutu eni amabe mwise Samari. ");
INSERT INTO puu_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Djesu akemuwivule: «Dighumi dyotsu ditsibelusu. Ka yifu yi bane yike wuka? ");
INSERT INTO puu_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Mu djowu botsu, yike mweni éwuwu awutsidjabe uyighabusile diboti ombu Nzambi?» ");
INSERT INTO puu_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Mbanane Djesu akemutsingule rye: «Releme, wendange, yitu yaghu yimaghughobule.» ");
INSERT INTO puu_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","BaFarisi bakewivule Djesu rye: «Temu yi, Nzambi obandile ulase bukaghe bwandi va ghari mukute andi?» Djesu akebawaghule rye: «Bukaghe bu Nzambi bughorughe nane yime ayulabene na misu. ");
INSERT INTO puu_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Baghovose bwena: “Budji vave vo budji wuna”. Tumbe djabanu yiri na muni, Bukaghe bu Nzambi bumakote mu mirime myenu.» ");
INSERT INTO puu_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Mbana Djesu aketsingule badukitsi bandi rye: «Mu bilumbu abyurughe, dube na nzale ulabe ne yilumbu yimosi yi Mwane Mutu, tumbe ne vane, dughoyilabe. ");
INSERT INTO puu_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Ave batu bodutsingulilaange rye: “Adji vave!” Vo: “Adji wuna!” Duyabawulu, duyabaduke. ");
INSERT INTO puu_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Kaboghu, yilumbu ayi Mwane Mutu oruyile, yube nane yivevedi yi kaki. Osundile ulabene, na yidjalale yandi yubase djulu djotsu kodu na kodu. ");
INSERT INTO puu_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Tumbe, diwelimine yiri Mwane Mutu oletsoghusu pwele, na obusu na batu ba temu édjidji. ");
INSERT INTO puu_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Adimalabene mu temu Nowe, dyumwébe munongu mosi mu yilumbu ayi Mwane Mutu oruyile. ");
INSERT INTO puu_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Batu bamadjangaange, bamanwangaange, bamawelesenaange na bamawetsaange baane bowu tena yilumbu ayi Nowe amakotile mu bwatu buneni. Mvule mutsoghu djikenoghe, nidu djineni djikerughe na botsu abamasyale bakefu. ");
INSERT INTO puu_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Yilumbu yi durughulu du Mwane Mutu, yumwébe munongu mosi nane va temu Lote mwise Sodome. Batu bamadjangaange na bamanwangaange; bamasumbaange na bamasumbisaange; bamavaraange na bamarungisaange. ");
INSERT INTO puu_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Tumbe yilumbu ayi Lote amaghusuyile musyengi Sodome, Nzambi akenoyise mvule maghaghele ma mudji na batu botsu bakefu. ");
INSERT INTO puu_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Dyoni dyube munongu mosi mu yilumbu ayi Mwane Mutu olabenine. ");
INSERT INTO puu_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Mu temu eni, diwelimine yiri mutu wotsu owube o djulu ndaghu andi, ayasundughe mu uyébonge bime byandi o ghari ndaghu. Munongu mosi ombu mutu owube o manungi, kilikingi ayaghabughe o dimbu. ");
INSERT INTO puu_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Rangiminanu mughatsi Lote! ");
INSERT INTO puu_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Wotsu owuronde ughaghe monyu andi, owuvinde; tumbe owughutsyemuse, owudile. ");
INSERT INTO puu_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Nyidutsinguli, mukolu eni, batu babedji bobe va tangi: wumosi obongu, awune osilu. ");
INSERT INTO puu_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Baghetu babedji borokaange va mosi, wumosi obongu, awune osilu.  ");
INSERT INTO puu_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Babaale babedji abobe o ghari nungi, wumosi obongu, awune osilu.» ");
INSERT INTO puu_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Badukitsi bakewivule Djesu rye: «Fumu, dyoni mbure yi dyuvyoyile?» Djesu akebawaghule rye: ");
INSERT INTO puu_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Djesu amababukile nongu mu ubalase bwena bosambilaange na yikanane na baghodede. ");
INSERT INTO puu_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Akebatsingule rye: «Vamabe nzonzi va musyengi, asamadumange Nzambi na asamaghobisaange mutu wotsu. ");
INSERT INTO puu_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Mune musyengi eni, wumabe mukwili wumawendaange kadi yilumbu ombu nzonzi eni mu uyemutsotsaange rye: “Tabulili bunzonzi va ghari menu na bavinitsi bami.” ");
INSERT INTO puu_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Vane kale, amalebusaange. Anokelonge, amavose rye: “Nénane ngédumi Nzambi na ngeghobisi mutu, ");
INSERT INTO puu_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","mu yiswebiri yi mukwili ewune, nyumutabulile bunzonzi mumbari akébwéyikomise muru.”» ");
INSERT INTO puu_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Fumu akebwévose rye: «Ghulwatyanu adi nzonzi djibive amavose! ");
INSERT INTO puu_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Tambusu na Nzambi, ovayile bunzonzi mu batu bandi abemulendi mu dusambu nyangu na mukolu! Tsiri nane? Ngenze, aghotsikedene mu ubawamuse. ");
INSERT INTO puu_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Menu, nyidutsinguli, Nzambi obatabulile bunzonzi mbangu-mbangu. Tumbe ave Mwane Mutu oruyile, oyirasunu mwa dikabu di batu bavu na yitu va butambe?» ");
INSERT INTO puu_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Djesu akemwébuke nongu ombu batu abekélabe bwena basungeme na belenzi basusu, akevose rye: ");
INSERT INTO puu_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","«Babaale babedji bamakote o ghari ndaghu Nzambi mu uyésambile. Wumosi amabe muFarisi, awune mubolitsi lepu. ");
INSERT INTO puu_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","MuFarisi, ave amasambililaange diteli, akebwaghaange mitsoki rye: “Tate Nzambi, nyiwughabusili diboti mumbari ngaa nane batu bamosi bavu badayi, bafutsi, bimbembu, vo nane mubolitsi éwuwu wu lepu. ");
INSERT INTO puu_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Mu uwughobise, nyiwarili nzale nyongu bedji mu tsone, nyiwuveyingi yimosi mu dighumi yi maboti mami motsu.” ");
INSERT INTO puu_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Kaboghu mubolitsi lepu anobe diteli, va mughule, asamarungusaange ne unangule misu na djulu, tumbe akedumange tulu andi na akevosaange rye: “Tate Nzambi ndabi ngebe muvayitsi mabi nane menu.”» ");
INSERT INTO puu_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Djesu akemwévose rye: «Nine, nyidutsinguli, yotsu mubolitsi lepu eghabuyili o ndaghu andi, Nzambi amamutande nomusungighe, wuvenguse muFarisi. ");
INSERT INTO puu_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Batu wandi bakebeghange baane bakali ombu Djesu mumbari akebasakighaange makake. Badukitsi bandi, banolabe nane, bakenyangilaange batu beni. ");
INSERT INTO puu_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Djesu amanengile baane beni va mughule andi na akevose bwena: «Silanu baane urughe ombu ami na duyabaghandise, mumbari Bukaghe bu Nzambi, budji mu batu ababaghunu nowu. ");
INSERT INTO puu_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Dingenze nyidutsinguli, wotsu aghodile Bukaghe bu Nzambi nane mwane ngebi, aghokote wune “vyaa”.» ");
INSERT INTO puu_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Yivunde yimosi yi baSwife, yike wivule Djesu rye: «Mulonzi wuboti, tsyeni nyuvayile mu udile monyu mutubu?» ");
INSERT INTO puu_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Djesu akemuwaghule rye: «Dibandu yi windengilili “Muboti”? Vagha mutu aboti, wuvengutse Nzambi pinze. ");
INSERT INTO puu_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Widjabi marume ma Nzambi: “Wuyatube bukali, wuyaboke, wuyadaghe, wuyafurile mutu naghu dyambu. Ghobise tadji na ngudji aghu.”» ");
INSERT INTO puu_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Yivunde yeni yi baSwife yikewaghule Djesu rye: «Ubongile bungebi bwami, dedi na vave nyikevu yivunde, nyighobisi mambu motsu.» ");
INSERT INTO puu_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Djesu anomuwulu, akemuwaghule rye: «Vaki dyambu dimosi diwusyali udughusu: byotsu abivu naghu, bisumbisi, ghaabile bidjaghe mbongu na Nzambi owuveghe busine o djulu, mbana rughe, nduki.» ");
INSERT INTO puu_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Dibaale dyeni, anowulu mambu meni, aketsore manyuru, mumbari amabe yisine yineni. ");
INSERT INTO puu_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Djesu, anomulabe yiri amatsore manyuru, akevose rye: «Divure ombu djowu abavu na maboti mapwele mu ukote o Bukaghe bu Nzambi! ");
INSERT INTO puu_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Nine, disavure ombu tsungu mu uvyoyile va dighole di tsongi; diweru dineni ombu yisine mu ukote mu Bukaghe bu Nzambi.» ");
INSERT INTO puu_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Batu abamamuwulu, bamamuwivule rye: «Kaboghu, yike nyi, orungulu ughobulu?» ");
INSERT INTO puu_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Djesu amabawaghule rye: «Adivu divure ombu batu, dighaa divure ombu Nzambi.» ");
INSERT INTO puu_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Pyere akevose rye: «Labati, djetu, tumasile byotsu na tumawuduke.» ");
INSERT INTO puu_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Djesu akebawaghule rye: «Dingenze, nyidutsinguli, mutu wotsu, aghorungule usile ndaghu andi, mughatsi na baane bandi, baane ba ngudji bandi na biburu byandi byotsu dibandu Bukaghe bu Nzambi, ");
INSERT INTO puu_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","yi aghodile bipwele mu temu édjidji, na monyu mutubu mu temu adjiruyi.» ");
INSERT INTO puu_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Djesu anonengile dighumi na badukitsi bandi babedji (12) va mughule andi, akebatsingule rye: «Wulwanu, o Serusaleme twiwendyanu, aghune motsu moyedughusu, ame babiyitsi bamarende mu dyambu di Mwane Mutu. ");
INSERT INTO puu_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Djandi, owakusu va makake ma djowu abaghédjabi Nzambi. Batu beni, bomudese, bomusyenge na bomufute matedji. ");
INSERT INTO puu_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Yikebemani wumudimbe na mikase mi batsilu, bomuboke. Mbana, mu yilumbu ayimuryeru, orambughe o dufu.» ");
INSERT INTO puu_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Tumbe badukitsi basamawulu ne dimosi mu mambu ame Djesu amavosaange. Payi basamawulu, mumbari divindughulu dimabasweghu. ");
INSERT INTO puu_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Djesu anobe bebeli na Seriku, vamabe yidunge yitsane va mughulu nzile yimabe muvondi. ");
INSERT INTO puu_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Yidunge yeni anowulu nduku yinombu yi batu bamavyoghaange, amabawivule rye: «Yine yi? Dyambu yi?» ");
INSERT INTO puu_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Batu bakemuwaghule rye: «Djesu mwise Nasarete evyoyi.» ");
INSERT INTO puu_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Na djandi amaghamughe: «Djesu, mwane Davide, ndabi wandi yingebe!» ");
INSERT INTO puu_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Batu abamavyoghaange va wusu andi, bakemughubisaange: Aa vole! Tumbe yidunge yeni akebwébwelaange ughamughe na mangolu: «Mwane Davide, ndabi wandi yingebe.» ");
INSERT INTO puu_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Djesu, anosikeme, amarume rye: «Mumbeyilyanu.» Yidunge anobambene, Djesu akemuwivule rye: ");
INSERT INTO puu_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","«Yi wirondi ngawuvayile?» Djandi akemuwaghule rye: «Fumu, nyirondi ubwélabe nane va teghe.» ");
INSERT INTO puu_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Djesu akemutsingule rye: «Tsyélabi! Yitu yaghu yimaghughobule.» ");
INSERT INTO puu_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Sundila, misu ma yidunge make tyemune, na akeduke Djesu noyeneyitsange Nzambi. Batu botsu na bédilabi, djowandi bakeyitse Nzambi. ");
INSERT INTO puu_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Djesu anokote o musyengi Seriku, akewunaange. ");
INSERT INTO puu_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Va musyengi eni, vamabe dibaale, dine dyandi Sase; djandi amabe yivunde yi babolitsi ba lepu na amabe yisine. ");
INSERT INTO puu_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Amarondaange ulabe na udjabe Djesu. Abilange aghufi, na yinombu yimabe yivyoghulile, asamarungule umulabe. ");
INSERT INTO puu_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Sase, anolabe nane, akerele mbangu o wusu, akemate mu mwiri awumabe vane mughule nzile adji Djesu amavyoyilaange mu umulabe burange. ");
INSERT INTO puu_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Ave Djesu amatolile va mbure eni, anonangule misu na djulu, akemulabe na akemutsingule rye: «Sase, lenge nosundughe! Na nyangu, yilatsi mu ndaghu aghu.» ");
INSERT INTO puu_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Sase anosundughe maswasu, akedile Djesu na nzangu djotsu mu ndaghu andi. ");
INSERT INTO puu_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Botsu abamadilabe, bamaningaange novose rye: «Mutu éwuwu amayekote novyose yilatsi o ndaghu muvayitsi mabi nane wune!» ");
INSERT INTO puu_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Sase anoreleme va wusu Fumu, aketsingule rye: «Fumu, la yasi yi maboti mami, nyuyighabile bidjaghe. Payi nyimadyonge mutu, nyumuvanine kumbu djine.» ");
INSERT INTO puu_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Djesu akewaghule rye: «Na muni, dughobutsu dumakote o ghari ndaghu édjidji, mumbari djawandi adji muteghule Aberaame. ");
INSERT INTO puu_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Mwane Mutu amarughe mu uyirombe noghobule abatsyemughe.» ");
INSERT INTO puu_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Abamabe vane, banowulu mambu meni, Djesu akebwele nongu mosi mumbari mbé ake bebeli na Serusaleme. Na batu beni bamatasaange yiri na mapape, Nzambi orughe mu uyibyatsu kaghe va ghari owu. ");
INSERT INTO puu_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Djesu akebatsingule rye: «Dibaale dimosi di mukute awumabe na didume, amawende o bulongu bu vale bakeyémubyatse kaghe bulongu bwandi, mbana mbé oghabusile. ");
INSERT INTO puu_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Ne akewende, akenengile dighumi di bidjeti byandi, akewakise kadi mutu dyandi dikabu di mbongu. Akebatsingule rye: “Salisanu mbongu tena nyughabughe.” ");
INSERT INTO puu_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Bise bulongu bwandi, basamadironde, baketinde batu o nzime kodu mu uyemutsingule rye: “Djetu, tugherondi urumusu na kaghe nane djandi.” ");
INSERT INTO puu_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Dibaale dyeni akebyatsu kaghe o bulongu bweni. Anoghabughe o mulingu andi, akenengile bidjeti byandi abe amawakise mbongu mu bawivule nane bamatsisalisile. ");
INSERT INTO puu_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Yidjeti ayiteghe akebambene na akevose rye: “Fumu, wumapeghe yikuru yimosi yi mbongu, va djulu yoni, nyitsidile dighumi di bikuru.” ");
INSERT INTO puu_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Kaghe eni, akemutsingule rye: “Diboti, wudji musatsi wungenze, wutsiwelemine mu mambu amagheyi, kaboghu nyuwubyatse mu dighumi di misyengi.” ");
INSERT INTO puu_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Yidjeti ayi mubedji yike rughe, akevose rye: “Fumu, wumapeghe yikuru yimosi yi mbongu, va djulu yoni, nyitsidile bikuru biranu.” ");
INSERT INTO puu_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Kaghe akemutsingule rye: “Ndedju, nyuwubyatse mu misyengi miranu.” ");
INSERT INTO puu_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Yidjeti ayine yike rughe novose rye: “Fumu, la yikuru yaghu, nyimayisweghe va disite di tsande. ");
INSERT INTO puu_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Nyimabe na ghome aghu, mumbari wudji mutu wurange: wibongi abi ndedju wughésunzi; wifuli abi ndedju wughévari.” ");
INSERT INTO puu_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Kaghe akemutsingule rye: “Mu posulu ndebeni nyiwusosisi, musatsi mubi nane ndedju! Wumadjabaange yiri nyidji mutu wurange: nyibongi abi nyisamasunze na nyifuli abi nyisamavare. ");
INSERT INTO puu_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Wumadjabe nane, mbé wumayesunze mbongu tsyami ombu bakoli, mbana ave mbé nyimaghabuyile, mbé nyimayitsibonge na bapite va djulu?” ");
INSERT INTO puu_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Na aketsingule botsu abamabe vane rye: “Mupatulyanu yikuru ayivu nandi, na yiveyanu ombu djandi awavu na dighumi.” ");
INSERT INTO puu_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Batu beni, bamasimine novose rye: “Fumu, ka djandi akane dighumi di bikuru!” ");
INSERT INTO puu_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Kaghe akebawaghule rye: “Menu nyidutsinguli: mutu wotsu awuvu na yime, bomubwese; tumbe wotsu aghaane yime, bomupatule nesi mwa pesu adjivu nandi. ");
INSERT INTO puu_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Tumbe bambeni bami abasamaronde yiri nyike byatsu nane kaghe owu, bambeyilyanu vave na batabulyanu bakingu va wusu ami.”» ");
INSERT INTO puu_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Djesu anomane uvose, akerele va wusu na akemate o Serusaleme. ");
INSERT INTO puu_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Ave amabambeninaange na mimbu ma Betefase na Betani, anobe bebeli na mukongu winengulu «mukongu wu miri mi Olive», akesindighe badukitsi bandi babedji na akebatsingule rye: ");
INSERT INTO puu_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","«Wendanu o dimbu adivu va wusu enu. Ave dutolile, durasune mwane yibulu atungu, awuskatsanunu na mutu. Munyangulyanu na mumbeyilyanu wunu. ");
INSERT INTO puu_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Payi mutu atsiduwivule rye: “Mumbari yi dwimunyangulili?” Duke muwaghule rye: “Fumu ane nzale woni.”» ");
INSERT INTO puu_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Djowu abasindughu bakewende, na bakerasunu byotsu nane Djesu amabatsingulile. ");
INSERT INTO puu_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Ave bamanyangulilaange mwane yibulu yeni, ba fumu, bakebawivule rye: «Dibandu yi dwinyangulili mwane yibulu?» ");
INSERT INTO puu_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Bakebawaghule rye: «Fumu ane nzale woni.» ");
INSERT INTO puu_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Banobeghe yibulu yeni ombu Djesu, bakene walange bikutu byowu va djulu yibulu, na bakematise Djesu. ");
INSERT INTO puu_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Ave Djesu amayene wendilaange, mu nzile djotsu, batu bakeyene walange bikutu byowu. ");
INSERT INTO puu_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Mu temu eni Djesu amabe bebeli na ukote o Serusaleme. Amavindeminange adu mukongu miri mi baOlive, binombu bi batu na badukitsi bandi, mu nzangu adjimavyoghulile mu djowu, bakesaghange nododise Nzambi na mighamu mineni. Bamasaghaange, dibandu bimaghe bineni abi djowu bamalabe. ");
INSERT INTO puu_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Mu duyitsu dwowu, bakevosange rye: «Nzambi aveyi myule ombu kaghe adjiruyi mu dine di Fumu! Duvotsu o djulu na bundumbe ombu Nzambi!» ");
INSERT INTO puu_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Yinombu yi baFarisi yimabe mukonge, baketsingule Djesu rye: «Mulonzi, votse badukitsi baghu!» ");
INSERT INTO puu_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Djesu akebawake rye: «Nyidutsinguli, payi djowu batsivole, mamani moghamughe mu uyitse Nzambi.» ");
INSERT INTO puu_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Djesu na ebambini na musyengi Serusaleme, na ewulabilili, akelile. ");
INSERT INTO puu_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Na akevose rye: «Serusaleme, nyinyongi mu ndedju, wusamadjabe nane mbé wumadilile duvotsu mu yilumbu yéyine, aa temu dji mavyoghe na dyoni dimawusweghu. ");
INSERT INTO puu_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Kaboghu, mu bilumbu abyurughe, bambeni baghu borungise bivaghe mu mighule myaghu, bowutsyenge na bowubandesene yari na yari. ");
INSERT INTO puu_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Bowunighe ndedju Serusaleme na batu baghu botsu. Mu ndedju, baghowusile ne dimani dimosi va djulu disusu, mumbari wusamakelule temu adji Nzambi mbé amawuwamusile.» ");
INSERT INTO puu_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Djesu anokote o ghari yivaghe yi ndaghu Nzambi, akesanze bakoli. ");
INSERT INTO puu_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Akebatsingule rye: «Bisonu bi Nzambi bivosi rye: Ndaghu ami djube ndaghu dusambu. Tumbe djenu dumadjikaluse yike yiswemunu yi bikongu.» ");
INSERT INTO puu_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Bilumbu byotsu, Djesu akelonzaange va dulombili du ndaghu Nzambi. Bivunde bi bavaghulitsi ba paghu, milonzi mi mighaghe na bivunde abimarumisaange mikute bakerombange tonu djubokile Djesu. ");
INSERT INTO puu_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Tumbe, basamadile tonu, mumbari mukute wotsu wumabe limbaa, mu uwulu malongi mandi. ");
INSERT INTO puu_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Mwa yilumbu, Djesu amalonzaange batu, akebatsingulaange musamu wuboti va dulombili du ndaghu Nzambi. Bivunde bi bavaghulitsi ba paghu, milonzi mi mighaghe na bivunde bi baSwife bimosi bakebarasune vane. ");
INSERT INTO puu_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Bivunde byeni bakemuwivule rye: «Awuni widilile musughe mu udughusu mambu mémane? Tutsinguli, anyi amawuveghe musughe ewune?» ");
INSERT INTO puu_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Djesu akebawaghule rye: «Menu wandi nyuduwivule yivu: ");
INSERT INTO puu_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Anyi amasindighe San nomuveghe musughe wu ubatise batu? Amasindughu na Nzambi vo na batu?» ");
INSERT INTO puu_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Batu beni, bakevosange va ghari djobeni rye: «Yike twisingi yiri Nzambi amamurume, djandi otuwivule rye: “Ka mumba yi dusamasingile ame San amavose?” ");
INSERT INTO puu_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Yike twimuwaghuli yiri musughe eni ombu batu wiruyili, mukute wotsu wututinde mamani mu utuboke, mumbari batu beni bédjabi yiri San amabe mubiyitsi.» ");
INSERT INTO puu_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Batu beni, bakewaghule Djesu rye: «Djetu, tughedjabi anyi amamuveghe musughe mu ubatise batu.» ");
INSERT INTO puu_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Na Djesu akebawaghule rye: «Menu wandi, ngodutsingule mu musughe nyi nyimavayili.» ");
INSERT INTO puu_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Djesu anomane uvose, akemwébukile mukute nongu rye: «Dibaale amavare nungi dji miri mi vinye, akedjisile va makake ma bisyele mu udjikelise, na amawende mu mulingu yitsingu. ");
INSERT INTO puu_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Temu dighumbe djinotole, fumu nungi akesindighe musatsi andi wumosi ombu bisyele abimasyale na nungi, Bakemuveghe dyandi dikabu di milunde mi vinye. Tumbe bisyele byeni bakedimbe musatsi eni kube na bakemughabuse myowu pavele. ");
INSERT INTO puu_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Fumu nungi, akesindighe awu mubedji, bisyele byeni bakedimbe wune wandi kube, bakemusyenge na bakemughabuse myowu na myowu. ");
INSERT INTO puu_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Akebwésindighe awu mutatu, awune wandi, bakemutsungule na bakemusyanze. ");
INSERT INTO puu_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Fumu nungi akekewivule: “Tsyeni ngavale? Nyusindighe mwane ami murime, tangudji bomughobise.” ");
INSERT INTO puu_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Tumbe ave bisyele byeni bamalabile mwane andi, baketsingusunaange rye: “Lanu mungo disyale! Tumubokyanu, tuke byalile nungi.” ");
INSERT INTO puu_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Bisyele, bakemughange, bakemupalise o ghari nungi na bakemuboke.» Djesu akebawivule rye: «Mu dyoni, yike yi fumu nungi obavaghe? ");
INSERT INTO puu_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Djandi, orughe na oboke bisyele byeni bine, na owakise nungi andi va makake ma bisyele bisusu.» Batu banowulu nane, bakemuwake rye: «Tsatsabi, dighorungule ube nane!» ");
INSERT INTO puu_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Djesu anobaghengile, akebawivule rye: «Divindughulu di Bisonu bi Nzambi, tsyeni diwendili? Labatyanu: “Dimani adimabwaghu na barungitsi ba mandaghu, yike dine diwarisi nziku yibughe?” ");
INSERT INTO puu_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Wotsu oduku dibaku mu dimani dyeni, oberughe na otsungughe. Djandi awu dimani dyeni dyubonduyile, onyighemughe.» ");
INSERT INTO puu_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Milonzi mi mighaghe na bivunde bi bavaghulitsi ba paghu bakerombange nane borungulile wughange Djesu mumbari bamatasaange yiri djowu, Djesu amatsokiyilaange mu nongu eni. Tumbe basamamughaange mumbari bamadumange mughungi. ");
INSERT INTO puu_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Batu bamabe numi-numi na Djesu. Bakemutindile batu abamafuraange ube basatsi ba Nzambi. Batu beni bamarombaange ubaghule batonu mu malongi ma Djesu mu umughange, na umuwakise ombu yidjeti yi baRome mu umusosise. ");
INSERT INTO puu_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Batu beni abamatindu, bakemuwivule yivu rye: «Mulonzi, twidjabi yiri wivosi nolonze na dusungughu; wughévayi dupasu va ghari batu, tumbe wilonzi na ngenze nzile Nzambi. ");
INSERT INTO puu_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Tutsinguli nine vo nesi, diwelimine mu ufute lepu ombu Kaghe Sesare?» ");
INSERT INTO puu_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Tumbe Djesu anobaghule dyele adi mbé bamusoghe, akebawaghule rye: ");
INSERT INTO puu_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","«Mbeyilyanu fure. Yinzi yi nyi? Na dine di nyi bisonughu mu fure eni?» Bakemuwaghule rye: «Bi Kaghe Sesare.» ");
INSERT INTO puu_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Djesu amabatsingule rye: «Ghabusilanu Kaghe Sesare abivu abyandi, mbana abi Nzambi, bi Nzambi.» ");
INSERT INTO puu_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Djowu bamakambulu mu posulu tsyandi na basamadile tonu mu umuveghe mbele. Bakevole «swii». ");
INSERT INTO puu_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Dighuki di baSadisi abamabe na bakemi mu durambughulu du abafu, banobambene na Djesu, bakemuwivulaange rye: ");
INSERT INTO puu_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","«Mulonzi, Moyise, mu mighaghe mi Nzambi, amatusoniyile rye: “Dibaale adiwele, payi aghaabure, yike efu, ngebi andi obyalile mukwili na bobure va yivinze yi awu amafu.” ");
INSERT INTO puu_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Vamabe yisambwali yi baane ba ngudji ba babaale. Awuteghe akewele na akefu, asamabure. ");
INSERT INTO puu_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Nduke tsomi akewele mukwili, akefu djandi wandi asamabure. ");
INSERT INTO puu_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Awu muryeru akemwébyalile mukwili eni, akefu djandi wandi, asamabure. Mu yisambwali yotsu ayi mabyalile mukwili, yikefu, yi samasile baane. ");
INSERT INTO puu_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","O nzitu, mughetu wandi akefu. ");
INSERT INTO puu_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Yilumbu ayi babaale beni borambuyile o dufu, anyi obe mulumi mughetu eni? Mumbari amabe mughatsi djowu botsu.» ");
INSERT INTO puu_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Djesu akebawaghule rye: «Mu butambe bwébubu, baghetu na babaale béwelisini, ");
INSERT INTO puu_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","tumbe bamosi abe Nzambi elabi yiri bawelimine mu urambughe o dufu nodile monyu awurughe, djowu baghomwéwele. ");
INSERT INTO puu_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Kaboghu, dufu mbé dughobwébabembe, mumbari bobe nane byanze bi Nzambi. Djowu bobe baane ba Nzambi, na djandi obarambuse o dufu nobaveghe monyu. ");
INSERT INTO puu_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Moyise amavose kengili yiri Nzambi orambuse abafu. Ave amavosile mu yilombi yi yivale yi mudji Nzambi, amanengile Fumu “Nzambi dji Aberaame, Nzambi dji Yisaake na Nzambi dji Sakobe.” ");
INSERT INTO puu_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Agha Nzambi dji bamvumbi, tumbe Nzambi adji djowu abavu monyu, mumbari djowu badji monyu dibandu djandi.» ");
INSERT INTO puu_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Dighuki di milonzi mi mighaghe baketsingule Djesu rye: «Mulonzi, wutsivose dingenze.» ");
INSERT INTO puu_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Na djowu, basamamwérungule umuwivule bivu bisusu. ");
INSERT INTO puu_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Djesu akewivule milonzi mi mighaghe rye: «Dibandu yi batu bévosili rye: “Kirisete, adji mwane Davide?” ");
INSERT INTO puu_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Davide etubuli djabeni mu mughande Nyimbu rye: “Fumu Nzambi etsinguli Fumu ami rye: Tsane va mabaale mami, ");
INSERT INTO puu_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","tena nyukutighe bambeni baghu, otsi makulu maghu.” ");
INSERT INTO puu_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Payi Davide enengili Yibyatsi yi Nzambi “Fumu andi”, ka tsyeni omwébile mwane andi?» ");
INSERT INTO puu_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Mughungi wotsu wunobe limbe mu umuwululu, Djesu aketsingule badukitsi bandi rye: ");
INSERT INTO puu_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","«Kebenanu na milonzi mi mighaghe, djowu aberondingi bu uyenelingaange mu bikutu bisakeme, djowu aberondingi usimbungu na dighobe mu mambure ma mighungi, djowu aberondingi utsane mu bitsighe abiteghe mu mandaghu ma tsambu na mbure tsi mimengu amineni, ");
INSERT INTO puu_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","djowu bédyongi nodayile bakwili, djowu bévayi tsambu tsisakeme mu ukelase yiri basungeme. Mu tonu adjine, Nzambi obakilisi pwele uvyoghulile bamosi.» ");
INSERT INTO puu_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Ave Djesu amabile o ghari ndaghu Nzambi, anoghengile batu abamasunzaange myenzili myowu, amalabe bisine abimapodulaange myowu mu yevi. ");
INSERT INTO puu_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Akebwélabe mukwili awuvu yidjaghe, djawandi amayisunzange doli bedji mu yevi yeni. ");
INSERT INTO puu_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Djesu amavose rye: «Ngenze nyidutsinguli, yidjaghe yi mukwili éwuwu, atsivyoghulile botsu uveghe. ");
INSERT INTO puu_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Payi nyivosi nane, mumbari bisine byeni, bamapodulaange mbongu atsimabe tsibavyoghulile. Tumbe mukwili ewune, mu budjaghe bwandi, atsipodule byotsu abimabe nandi.» ");
INSERT INTO puu_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Ave mwa batu bamavosilaange nonyungile ndaghu Nzambi, adjimarungusu na mamani mabwedji na bime abimaveghungu ombu Nzambi, Djesu akevose rye: ");
INSERT INTO puu_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","«Bilumbu byurughe, byotsu bine dwinyungili, byupanzu, va ghosyale ne dimani va djulu dimani nandi.» ");
INSERT INTO puu_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Djowu bamamuwivule rye: «Mulonzi, temu yi mambu meni molabenine? Na yilimbe yi, tudjabile yiri mambu memane makilabene na mapape?» ");
INSERT INTO puu_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Djesu akebawaghule rye: «Dukebene yiri batu bakedudunze. Mumbari bapwele borughe mu dine dyami na boyidufure yiri “Menu la Kirisete” na “Temu adji Nzambi amasikighe djikebebeli.” Tumbe duyabaduke. ");
INSERT INTO puu_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Ave duwululu nduku mavite, duyabe na ghome, mumbari mambu motsu mane mbé molelabene. Tumbe, tsi yiri disukusulu di bulongu.» ");
INSERT INTO puu_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Na amamwébatsingule rye: «Malongu na malongu motoghe; bulongu na bukaghe butoghe. ");
INSERT INTO puu_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Butambe wandi buregheme, na mu mambure mapwele, vobe bivunge na dungosu du nzale, vobe mambu mavure, ameveyi ghome noreyimise, na bilimbe bimuvingu byulabene o djulu. ");
INSERT INTO puu_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Tumbe, ne motsu mane makelabene, boledughaange, bakedutsoyise na boduwakise va makake ma bivunde bi mandaghu ma tsambu ma baSwife, bakedukotise o tsughu, bodubeghe va wusu bakaghe na va wusu bidjeti. Boduvayile motsu mane dibandu dine dyami. ");
INSERT INTO puu_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Moni moduvaghulu mumbari dukebe bambedji bami. ");
INSERT INTO puu_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Banu na duvotsu mu mirime myenu na duyadume mu motsu ameduyevose mu ukekaghule. ");
INSERT INTO puu_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Mumbari mebeni nyuduveghe bighume na dyele adi bavinitsi benu baghorungule ughaghene vo udukalile. ");
INSERT INTO puu_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Djenu, dusumbusu tangudji na biburu byenu, vo baane ba ngudji benu vo na botsu ba yibandu yenu na bambatsi benu. Batu beni boboke bapwele va ghari enu. ");
INSERT INTO puu_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Djenu, duvinu na botsu dibandu dine dyami. ");
INSERT INTO puu_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Tumbe ne dunange dumosi mu myuru myenu doghodokughe. ");
INSERT INTO puu_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Ladibandu, mu duwarulu dwenu, dughobule myonyu myenu.» ");
INSERT INTO puu_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Djesu amabatsingule rye: «Ave dulabile baghore ba bambeni ukande Serusaleme, djabanu yiri dutsyemughulu dwandi duke beli. ");
INSERT INTO puu_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Kaboghu, botsu abobe o yinange yi Sudé barini o mikongu, abobe va ngangele Serusaleme bapali. Djowu abobe mu misiru, bayaghabughe o mimbu. ");
INSERT INTO puu_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Mumbari, mu temu eni, mukilu Nzambi wudughusu mu motsu nane Bisonu byandi bivosili. ");
INSERT INTO puu_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Kamune maghughe-ma ombu baghetu abobe na mimi na djowu abonwisaange mu temu eni, mumbari bulongu bube mu manyoni maneni na kabu Nzambi djulabene va ghari mukute eni. ");
INSERT INTO puu_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Bapwele boboku na didjenge, bamosi bobongu nobeghu nane bavighe, mu misyengi myotsu. Na malongu masusu amaghedjabi Nzambi, monighe Serusaleme tena temu owu djusuke.» ");
INSERT INTO puu_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Djesu amamwévose rye: «Volabene bilimbe mu nyangu, mu tsungi na mu bambwelili. Malongu motsu, mu butambe mobe na keri dibandu nduku neni dji mibidji mi mubu. ");
INSERT INTO puu_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Batu boghangu na ghome neni, ave botasilaange adyodyulabene mu butambe, mumbari Nzambi okungise byotsu na mbulighe neni djube o djulu. ");
INSERT INTO puu_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Mbana, bolabe Mwane Mutu eruyi na mangolu na bundumbe va ghari madudumbi. ");
INSERT INTO puu_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Ave mambu meni molabenine, waranu na nangulanu myuru myenu, mumbari dudjeghusu dwenu duke bebeli.» ");
INSERT INTO puu_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Mbana Djesu akebabukile nongu rye: «Ghengilatyanu mwiri bafighe na miri misusu. ");
INSERT INTO puu_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Ave mifulili, dwidjabi yiri temu mvule djikebebeli. ");
INSERT INTO puu_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Munongu mosi, ave dulabile mambu meni, djabanu yiri na mapape Nzambi oyibyame nane kaghe. ");
INSERT INTO puu_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Ngenze, nyidutsinguli rye: dukulu dwedudu, dugholefu payi motsu mane, makalabene. ");
INSERT INTO puu_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Djulu na butambe byuvyoghe, tumbe bighume byami bighovyoghe “vyaa”.» ");
INSERT INTO puu_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Djesu amamwévose rye: «Lubughanu, duyasingene na mimengu, na malangi na manyoni ma myonyu myenu mumbari dukesutusu mu yilumbu yi mufundu. ");
INSERT INTO puu_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Mu yilumbu yeni, batu botsu bosutusu nane banyame o ghari mbuse. ");
INSERT INTO puu_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Moghanu na sambilenganu Nzambi temu tsyotsu mumbari, dukebe na mangolu morinine mambu motsu marange, na ave Mwane Mutu oruyile, akidurasunu duware.» ");
INSERT INTO puu_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Ave nyangu, Djesu amalonzaange batu o ghari ndaghu Nzambi. Tumbe, akevyosilaange mukolu o mukongu wu miri mi Olive. ");
INSERT INTO puu_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Bilumbu byotsu, batu bamawendaange o ndaghu Nzambi mu uyéwulu malongi ma Djesu. ");
INSERT INTO puu_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Temu mumengu mape maghambu dufunusu, winengulu Pake, djimabambenaange. ");
INSERT INTO puu_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Bivunde bi bavaghulitsi ba paghu na milonzi mi mighaghe bamarombaange uboke Djesu, tumbe bamabe na ghome mughungi. ");
INSERT INTO puu_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Dyabu akekote o murime Sudase, omanengulungu Yikalyote, djandi amabangaange mu yinombu yi dighumi na badukitsi babedji (12). ");
INSERT INTO puu_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Sudase amawende mu uyéwulusunu na bivunde bi bavaghulitsi ba paghu na bivunde bi baghore abamakelisaange ndaghu Nzambi mu udjabe nane ovayile mu usumbise Djesu. ");
INSERT INTO puu_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Bivunde bakebase na nzangu, bakewulusunu mu umuveghe mbongu. ");
INSERT INTO puu_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Sudase akesinge, akerombaange temu nane obawakisile Djesu ne yinombu yi batu yikedjabe. ");
INSERT INTO puu_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Yilumbu yi mumengu mape magha dufunusu, ayi mbé bobokile mwane yindombu wu mumengu Pake, yimatole. ");
INSERT INTO puu_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Djesu akesindighe Pyere na San, akebatsingule rye: «Wendanu, ye tutsonzilanu mulambu Pake, tukidji.» ");
INSERT INTO puu_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Pyere na San bakemuwivule rye: «Wuke wirondi tuketsonziyile mulambu eni?» ");
INSERT INTO puu_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Djesu abamawaghule rye: «Wulwanu, ave dukotile mu musyengi, dubengune na mutu eyenebeghe tsuve mambe, mudukyanu o ndaghu adji oyekote. ");
INSERT INTO puu_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Mbana tsingulanu mungo ndaghu rye: “Mulonzi atsitusindighe ombu aghu, wuketulase yibuku yi ndaghu ayi djandi na badukitsi bandi bolile mulambu Pake.” ");
INSERT INTO puu_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Djandi odulase yibuku yi ndaghu ndeki yeneni yitsonzughu kale, avane duvayile mulambu.» ");
INSERT INTO puu_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Badukitsi banowende, bakerasune bime byotsu bitsonzughu nane Djesu amabatsingulile na bakelambe mulambu Pake. ");
INSERT INTO puu_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Temu djinotole, Djesu na bilumbi byandi bakevyoghe va tavule mu udji. ");
INSERT INTO puu_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Djesu akebatsingule rye: «Nyitsirondaange pwele uledji mulambu éwuwu Pake nenu ne ngatsoghe. ");
INSERT INTO puu_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Dingenze nyidutsinguli, ngobwéwudji tena yilumbu ayi Nzambi obwévayile mulambu eni o bukaghe bwandi.» ");
INSERT INTO puu_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Akebonge dimoyi di malamu ma milunde mi vinye, akeghabusile Nzambi diboti, akevose rye: «Bonganu dimoyi dyédidi; mutu-mutu anwangi. ");
INSERT INTO puu_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Nyidutsinguli yiri ubandile na muni, ngomwenu malamu memame ma vinye tena yilumbu ayi Bukaghe bu Nzambi buruyile.» ");
INSERT INTO puu_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Akemwébonge dipe, anoghabusile Nzambi diboti, akedibukule, akeghabile bilumbi byandi na akebatsingule rye: «Dipe dyédidi, dunyuru dwami aduvaghulu mu yibile yenu. Djanu mumbari duketangiminaange.» ");
INSERT INTO puu_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Banomane udji dipe, Djesu akemwébawakise dimoyi na akevose rye: «Dimoyi dyédidi, dinonge adighone na Nzambi mumbari malungu mami mowiteme mu djenu. ");
INSERT INTO puu_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Kaboghu, djabanu yiri mutu owunzumbise, adji netu vave tavule. ");
INSERT INTO puu_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Ngenze, nenane Mwane Mutu ofwile mu duvangu du Nzambi, kamune maghughe mutu owumusumbise olabe!» ");
INSERT INTO puu_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Badukitsi bakebande wuwivusenaange: «Anyi va ghari etu orunguse uvaghe dyambu nane dine?» ");
INSERT INTO puu_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Va djulu vane, badukitsi bakemwébe na mutsundu wuneni, mu udjabe anyi va ghari owu orungule ube yivunde ayughobusu. ");
INSERT INTO puu_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Djesu akebatsingule rye: «Bakaghe ba malongu masusu bérumisi nodyamise batu ba misyengi myowu. Nane bivunde abivu na musughe mu djowu bérondi unengulungu: “Bambatsi ba mughungi.” ");
INSERT INTO puu_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Duyabe nane djowu. Tumbe, oyirondi ube yivunde va ghari enu, mbé okesunze nane mwane ngebi; mbana oyirondi urumise, mbé okevaghule nane musalitsi bambatsi. ");
INSERT INTO puu_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Kaboghu, anyi avu yivunde, djandi wune odjivu va tavule vo djandi oyikevaghule mu usalile bambatsi? Tsi djandi wune odjivu va metse? Tumbe menu, nyidji va ghari enu nane musalitsi. ");
INSERT INTO puu_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Djenu, dudji djowu bane abatsiware nami mu purulu. ");
INSERT INTO puu_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Ladibandu menu, nyiduveyili musughe wu urume Bukaghe bu Nzambi nane Tate ami ambyatsile. ");
INSERT INTO puu_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Nyivayile nane, mumbari dukedji, nonu va metse mami mu bukaghe bwami. Na dutsanusu mu bitsighe bi bukaghe mu utabule bunzonzi bu dighumi na bifumbe bibedji bi mukute Yisrayele.» ");
INSERT INTO puu_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Djesu akenengile Simu Pyere: «Simu, Simu, wulu: lanu, Dyabu erondi wudumange djenu botsu nane bésayili uresi mukakesene bipupu na misu. ");
INSERT INTO puu_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Tumbe menu, nyitsisambile mu ndedju mumbari yitu yaghu yikedede. Na ndedju, mu yilumbu ayiwughabusile dinonge nami, warise baane ba tadji baghu.» ");
INSERT INTO puu_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Pyere akemutsingule rye: «Fumu, nyitsonzeme uwende naghu o tsughu tena o dufu.» ");
INSERT INTO puu_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Djesu akemuwaghule rye: «Ndedju Pyere, nyighutsinguli: na muni, ne koku akevose, wukale kumbu yiryeru bwena wughenzyabi.» ");
INSERT INTO puu_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Mbana, Djesu akebawivule rye: «Ave nyimadusindiyili nenane nyisamaduveghe mbongu, komi vo bapondu, dumaghambu na yime?» Badukitsi bakewaghule rye: «Vyaaghe.» ");
INSERT INTO puu_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Yike Djesu akebatsingule rye: «Avave, wotsu avu na mbongu abongi, dedi mosi awu avu na komi, abongi na wotsu awu aghaane didjenge, asumbisi yidjungi yandi mu usumbe didjenge. ");
INSERT INTO puu_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Nyidutsinguli, nane Bisonu bi Nzambi bivosili mu menu: “Mutu éwuwu amatalu va ghari bikongu.” Kaboghu dyambu adivu adyami, dike beli nolabene.» ");
INSERT INTO puu_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Badukitsi bakemutsingule rye: «Fumu, tune madjenge mabedji.» Djesu akewaghule rye: «Avotsu, amane mawelimine.» ");
INSERT INTO puu_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Djesu anopale o musyengi, mu yuku yandi, akewende o mukongu wu baOlive. Badukitsi bandi bakemuduke. ");
INSERT INTO puu_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Ave bamatolile va mbure eni, Djesu akebatsingule rye: «Sambilanu mumbari dukebe mu dumangu.» ");
INSERT INTO puu_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Djesu akekakene mwa pesu nowu, akekutume, akebande usambile. ");
INSERT INTO puu_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Amavose rye: «Tate, payi wirondi, bonge na kakesene dimoyi dyédidi di maghughe nami. Mu dyoni, diyadughusu nane nyirondili, tumbe nane ndedju wirondili.»  ");
INSERT INTO puu_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Vane-vane, yanze yimosi yimarughe o djulu, mu uyimuwarise. ");
INSERT INTO puu_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Djesu, anoghangu na keri, aketsore manyuru. Akebwese usambile na mangolu na dirughume dyandi dikedekaange va butambe nane maberi ma malungu. ");
INSERT INTO puu_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Djesu anomane usambile, akeghabughe ombu badukitsi, akebarasune bilu, batsore manyuru na manyonyi. ");
INSERT INTO puu_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Djesu akebasimbule, akebawivule: «Dibandu yi dwiwendili yilu? Relemanu na sambilanu mumbari dukébe mu dumangu.» ");
INSERT INTO puu_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Djesu wuvose mbé akivose, sundile yinombu yi batu yikebarasune. Sudase awu amabe wumosi va ghari dighumi na badukitsi babedji (12), djandi amabe yibeghe ndonge. Akebambene na Djesu, akemubumbe na akemufwife. ");
INSERT INTO puu_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Djesu akemuwivule rye: «Sudase, mu ufwife waghu, wisumbisili Mwane Mutu?» ");
INSERT INTO puu_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Abamasyale na Djesu, ave bamalabile dyodikivyoghe, bakewivule Djesu rye: «Fumu, tupalisi madjenge mu utoghe nowu?» ");
INSERT INTO puu_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Wumosi va ghari owu, akepalise didjenge, aketabule ditudji di mabaale di musalitsi wu yivunde yi bavaghulitsi ba paghu. ");
INSERT INTO puu_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Tumbe Djesu akevose rye: «Dundanu, avotsu.» Na amabembe ditudji di musalitsi na akemubeluse. ");
INSERT INTO puu_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Mbana Djesu aketsingule bivunde bi bavaghulitsi ba paghu na bivunde bi baghore na bivunde bi baSwife abamarughe owuyimughaange rye: «Dumarughe na madjenge na mangwangu nane bwena yikongu dwiyighaange. ");
INSERT INTO puu_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Bilumbu byotsu, nyibetsi nenu o ghari ndaghu Nzambi, dughaakangaange. Temu adjidji, djike djenu adji mangolu ma pisime mesalili mukolu.» ");
INSERT INTO puu_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Na béghangi Djesu, bakemubeghe o ndaghu yivunde yi bavaghulitsi ba paghu. Pyere akenebadukaange va ghegheyi. ");
INSERT INTO puu_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Batu beni, banobanze mudji va ngangele dulombili, Pyere wandi akeyétsane va ghari owu. ");
INSERT INTO puu_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Musatsi wumosi wu mughetu wu yivunde yi bavaghulitsi ba paghu akemulabe atsane va mughule mudji, akemutsune «pii» na akevose rye: «Dibaale dyédidi wandi abetsi na Djesu!» ");
INSERT INTO puu_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Tumbe Pyere akeghale nomutsingule rye: «Mughetu, menu ngémudjabi.» ");
INSERT INTO puu_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Mwa pesu temu, mutu mosi anomulabe, akemutsingule rye: «Ndewandi, wudji nowu!» Tumbe Pyere akewaghule rye: «Nesi, menu nga nowu.» ");
INSERT INTO puu_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Mwa diweru dinovyoghe, mutu wususu akebwétsiyise bwena: «Nyitasi yiri, dingenze, dibaale dyédidi abetsi nandi mumbari djawandi adji mwise Ngalile.» ");
INSERT INTO puu_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Pyere akemuwaghule rye: «Ngedjabi adi wirondi uvose.» Ave Pyere amavosilaange, koku wandi novose. ");
INSERT INTO puu_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Fumu anoghelughe, yiswisu yandi na yi Pyere bikebengune. Sundile Pyere akerangimine adi Fumu amamutsingule: «Na muni, ne koku akevose, ndedju wukale kumbu yiryeru bwena wughenzyabi.» ");
INSERT INTO puu_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Pyere, anopale o dulombili, amalile «rodoo» na munyongu wotsu. ");
INSERT INTO puu_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Batu abamakelisaange Djesu, bamamupedjingi na bamamudimbaange. ");
INSERT INTO puu_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Djowu, banomudibighe yinzi bakemuwivulaange rye: «Bighe na tutsinguli anyi atsighudimbe?» ");
INSERT INTO puu_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Na bakebwélaange umusyenge nomutsingulaange mambu mamosi mabive. ");
INSERT INTO puu_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Mune kedi, fundu dji bivunde bi mukute, bivunde bi bavaghulitsi ba paghu na milonzi mi mighaghe bamaghukume, bakebeghe Djesu va wusu fundu dji banzonzi ba baSwife. ");
INSERT INTO puu_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Awune, bakemuwivule rye: «Ndedju, la Kirisete? Tutsinguli.» Djandi akebawaghule rye: «Yike nyidutsinguli, djenu dughosinge. ");
INSERT INTO puu_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Payi nyitsiduwivule yivu, djenu dughokwaghule. ");
INSERT INTO puu_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Ubandile vave, Mwane Mutu obe atsane o mabaale ma Nzambi-Pungu.» ");
INSERT INTO puu_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Djowu botsu bakeghamughe va mosi rye: «Kaboghu ndedju, wudji Mwane Nzambi?» Djesu akebawaghule rye: «Djenubeni dumatubule: Nine, menu.» ");
INSERT INTO puu_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Bakevose rye: «Twisane nzale bambedji! Djetubeni tumaghulwanu, mambu amatsipale va munu andi.» ");
INSERT INTO puu_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Yinombu yotsu yi batu yikereleme, mu ubeghe Djesu va wusu yidjeti bamanengilaange Pilate. ");
INSERT INTO puu_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Avane, djowu botsu bamamufwengile na bamatsingule Pilate rye: «Dibaale dyédidi, tutsimurasunu esibisi batu ba bulongu bwetu na ebaghandisi uvane lepu ombu Kaghe Sesare, na evosi yiri djabeni la Kirisete mbana adji Kaghe.» ");
INSERT INTO puu_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Pilate akemuwivule rye: «Ndedju la Kaghe baSwife?» Djesu akemuwaghule: «Ndebeni widivosi.» ");
INSERT INTO puu_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Pilate aketsingule bivunde bi bavaghulitsi ba paghu na yinombu rye: «Menu ngelabi mbele djufwengiyile mutu éwuwu.» ");
INSERT INTO puu_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Tumbe batu beni bakemwéghamungaange na mangolu rye: «Mu ndonzulu andi, djandi esibisi mukute bakebuse ughobise mighaghe mi kaghe Sesare. Mutu eni atsivaghe nane mu yinange yotsu yi Sudé, ubandile o yinange yi Ngalile, tena wunu tuvwanu.» ");
INSERT INTO puu_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Ave Pilate amawululu nane, akewivule rye: «Mutu éwuwu, mwise Ngalile?» ");
INSERT INTO puu_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Batu bakewaghule Pilate bwena Djesu adji mwise Ngalile. Pilate akemutinde ombu kaghe Yirode mwane Atipa. Kaghe adjimarumisaange yinange yi Ngalile na va temu eni, mbé aki o Serusaleme. ");
INSERT INTO puu_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Yirode akebase na nzangu ave amalabile Djesu mumbari yilemee amarondaange ubengune nandi. Mumba amawulu didume dyandi na amatasaange yiri Djesu omulase mwa yimaghe. ");
INSERT INTO puu_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Yirode akemuwivule pwele bivu, tumbe Djesu asamamuwaghule ne yimosi. ");
INSERT INTO puu_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Vane mbure eni, bivunde bi bavaghulitsi ba paghu na milonzi mi mighaghe bamabe djowu andi na kabu, bakemufwengiyilaange pwele mambu. ");
INSERT INTO puu_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Yirode na baghore bandi bakepedjingi nosyenge Djesu. Bakemudwise yikutu yi bukaghe na bakemughabuse ombu Pilate. ");
INSERT INTO puu_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Vane kale Yirode na Pilate bamabangaange bambeni, tumbe mu yilumbu yéyine, bakebwéghabusile bumbatsi. ");
INSERT INTO puu_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pilate akeghukighe bivunde bi bavaghulitsi ba paghu, bidjeti bimosi na mughungi, ");
INSERT INTO puu_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","akebatsingule rye: «Djenu dutsimbeyile dibaale dyédidi na djandi esibisi mukute na kande. Labatyanu, nyitsimusosisile va wusu enu, tumbe ngalabe mbele andi mu mambu ame djenu dwimufwengilili. ");
INSERT INTO puu_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Ne Yirode djawandi, aghalabe dibi mu Djesu yiri akeboku. Ladibandu atsimughabusile ombu etu. Mutu éwuwu aghaane dyambu adyumurombise dufu. ");
INSERT INTO puu_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Kaboghu nyurume bakemudimbise bwandi na batsilu mbana bakemudunde.»  ");
INSERT INTO puu_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Mu kadi mumengu Pake, Pilate amabangaange na yufu yupalisaange mwise tsughu wumosi. ");
INSERT INTO puu_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Tumbe yinombu ayimabe vane, wikeghamughe va mosi rye: «Bokise dibaale dyédidi, tupalisili Barabase.» ");
INSERT INTO puu_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Mu disibise adi Barabase amarombise mu musyengi eni, na uboke awu amabokile mutu, adine dimamukotise o tsughu. ");
INSERT INTO puu_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilate, mu nzale udunde Djesu, akemwébawivule adi mubedji. ");
INSERT INTO puu_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Tumbe mughungi wukebwéghamughe na mangolu: «Mughomini, mughomini va kurusu.» ");
INSERT INTO puu_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Pilate akemwébawivule adi muryeru rye: «Dibi dika, mutu éwuwu atsivaghe? Ngelabi dyambu adi djandi obokulu. Menu, nyumudimbise wandi mbana, nyumudunde.» ");
INSERT INTO puu_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Tumbe mughungi wukebwelaange ughamughe o djulu yiri Djesu aghomunu va kurusu. Yike mu posulu owu, dufu du Djesu dukesikughu. ");
INSERT INTO puu_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Vane-vane, Pilate akesinge adi mughungi wumarondaange. ");
INSERT INTO puu_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Pilate akebapalisile mutu awubamavondaange awu amasunzu o tsughu dibandu disibise na bukongu bwandi, na akebawakise Djesu bakemuvaghe adi bamarondaange. ");
INSERT INTO puu_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Ave bamabeyilaange Djesu, bakebengune na dibaale dinengulu Simu mwise musyengi Sirene amarughesenaange o manungi. Baghore bakemusikighe na bakemughome yiri akenangule kurusu mbana akenedukaange Djesu va nzime. ");
INSERT INTO puu_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Yinombu yineni yi batu yikenebadukaange. Va ghari mughungi eni vakebe mwa dighuki di baghetu bamenelilaange nonyongaange dibandu mukilu wu Djesu. ");
INSERT INTO puu_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Djesu akebaghengile na akebatsingule rye: «Baghetu ba Serusaleme, duyalile mu menu, lilenganu mu djenubeni na mu baane benu. ");
INSERT INTO puu_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Lanu, bilumbu byurughe ave batu bovosilaange rye: “Ubwedji ombu bingume, ombu djowu abasekalebure na djowu abasamanwise.” ");
INSERT INTO puu_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Mu temu eni, batu bovosaange na mikongu na milandu yiri: “Tuvikyanu na tughumbyanu.” ");
INSERT INTO puu_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Labatyanu, mu mwiri awu monyu bamavaghe mambu mabive, ka mu mukanzu, tsyeni bovayile?» ");
INSERT INTO puu_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Vane-vane, bakebeghe bikongu bibedji bakiboku va mosi na Djesu. ");
INSERT INTO puu_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Ave bamatolile va mbure adjimanengulungu «Dubengili», baghore bakeghomine Djesu va kurusu. Yike bakeghomine bikongu byeni mu tsyowu kurusu, wumosi o mabaale, awune o maghetu mandi. ");
INSERT INTO puu_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Mwa pesu temu, Djesu akevose rye: «Tate, batandi mumbari baghedjabi adi bévayi.» Baghore beni bakesole mutu mu udjabe anyi odile yikutu yi Djesu. Mu uyidile, bakevaghe dusolu du yese. ");
INSERT INTO puu_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Mughungi wumabe wughukeme na wukeghengilaange. Tumbe bivunde bi baSwife, bakepedjingi Djesu na bakevosange rye: «Amaghobule basusu, tsyé akeghobuli djabeni payi adji Kirisete awu Nzambi amasole!» ");
INSERT INTO puu_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Baghore wandi bakebambene, bakemupedjingi na Bakemuveghe dingibe dingani akenu. ");
INSERT INTO puu_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Bakevose rye: «Payi wudji Kaghe baSwife, tsyékeghobule ndebeni!» ");
INSERT INTO puu_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Mu yasi yi dusimbi ayimaghomunu va kurusu o djulu muru andi, bamasonighe: «Awuwu, Kaghe baSwife.» ");
INSERT INTO puu_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Yikongu yimosi ayimaghomunu va kurusu va mughule Djesu, akemubangulaange novose rye: «Ndedju, meta wudji Kirisete? Tsyékeghobule ndebeni na tughobuli!» ");
INSERT INTO puu_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Yikongu ayi mubedji ayimaghomunu wandi mu djandi kurusu, akesyembe mbatsi na akemutsingule rye: «Nenane wutsiveghulu mukilu nane mutu éwuwu, ndedju wughédumi Nzambi? ");
INSERT INTO puu_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Mu djetu naghu, tuwelimine mudile fute édjidji mu mambu ame tumavaghe. Tumbe djandi, aghavaghe dyambu dibi.» ");
INSERT INTO puu_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Mbana yikongu yeni akevose rye: «Djesu, wuyandibene ave wuruyile mu uyibyame nane kaghe.» ");
INSERT INTO puu_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Vane-vane, Djesu akemuwaghule rye: «Dingenze nyighutsinguli, na muni, wukote nami o Bukaghe bu Nzambi.» ");
INSERT INTO puu_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Va mwangulu, nyangu djikevole na pisime djikedughunu mu butambe bwotsu tena murekemunu wu wisi. ");
INSERT INTO puu_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Dimengi di nyangu dinotsyemughe, pisime djikebase mu butambe, dumbu du mbure adji Syeme va dikotulu di ndaghu Nzambi dukepasighe va ghari. ");
INSERT INTO puu_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Djesu akeghamughe mughamu wuneni, akevose rye: «Tate, nyiwakisi Yinyuni yami va makake maghu.» Anomane uvose nane, akefu. ");
INSERT INTO puu_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Yivunde yi baghore anolabe adimavyoghe, akedodise Nzambi novose: «Dingenze, mutu éwuwu abetsi asungeme.» ");
INSERT INTO puu_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Yinombu yi batu yimarughe pwele, yinolabe adimavyoghe, yikeneghabughe mu mimbu mowu, bakene dumange batulu dibandu munyongu wuneni mu mirime. ");
INSERT INTO puu_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Bambatsi botsu ba Djesu na baghetu abamawendaange nandi, ubongile o Ngalile, bamabe bavengeme djowu mbure na bakeghengilaange nane mambu mamavyoyilaange. ");
INSERT INTO puu_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Vamabe mutu dine dyandi Sosefe, amabe na musighe, asungeme, akevivaange durughulu du Bukaghe bu Nzambi. Djandi, amabe yivunde wandi va ghari fundu dji banzonzi ba baSwife na amabe mwise musyengi wu Arimate mu yinange yi Sudé. Asamasobene ditase na bambatsi mu uboke Djesu. ");
INSERT INTO puu_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Dibaale dyeni, akewende, mu uyélabe yidjeti Pilate, akemuveghe musughe mu ubonge dunyuru du Djesu. Pilate akemugharusu. ");
INSERT INTO puu_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Sosefe akesunduse dunyuru du Djesu va kurusu, akedupote va tsande na akedusunze o ngile adjimatimu o ghari tali o mbé wukatswighulu mutu. ");
INSERT INTO puu_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Amadivaghe, mu yilumbu ayiduki yilumbu ayireli yilumbu yuvume yi baSwife, ayi batu basamasalilaange. ");
INSERT INTO puu_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Baghetu abamenedukaange Djesu, ubongile o Ngalile, bakesobene konge na Sosefe na bakewende o ngile. Awune bamalabe nane bamasunzile dunyuru du Djesu. ");
INSERT INTO puu_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Banomane, bakeghabughe mu mandaghu, muyetsonzighe matsi na miyombu muyeghotse dunyuru du Djesu. Djowu, bamaghobise mughaghe awighandisi baSwife usale mu yilumbu yuvume. ");
INSERT INTO puu_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Mu yilumbu yiteghe yitsone, va matebughulu ma wisi, baghetu bamawende o ngile na birure bi matsi na miyombu ami bamatsonzighe. ");
INSERT INTO puu_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Ave bamatolile, bakerasunu dimani adi bamakibiyile ngile dimavengughu va mughule. ");
INSERT INTO puu_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Bakekote, basamarasunu dunyuru du Fumu Djesu. ");
INSERT INTO puu_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Baghetu, bakesutu. Sundile, babaale babedji badware bikutu bikadimi, bakelabene va wusu owu. ");
INSERT INTO puu_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Baghetu, bakeghangu na ghome, baketsokighe misu na tsi. Babaale beni bakebawivule rye: «Dibandu yi dwirombili odjivu monyu va ghari djowu abamafu? ");
INSERT INTO puu_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Asa vave, tumbe amarambughe o dufu. Kaboghu, rangiminanu ame amadutsingulanga ave mbé akivu o Ngalile. ");
INSERT INTO puu_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Avane, amavosaange rye: “Diwelimine yiri Mwane Mutu owakusu va makake ma bavayitsi ba mabi, oghomunu va kurusu, mbana mu yilumbu ayimuryeru, orambughe o dufu”.» ");
INSERT INTO puu_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Vane-vane, baghetu beni bamarangimine mambu ame Djesu amabatsingulaange. ");
INSERT INTO puu_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Banoghusughe o ngile, bakeghabughe muyetsingule dighumi na yilumbi yimosi na badukitsi botsu. ");
INSERT INTO puu_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Mu yinombu yi baghetu beni, vamabe Mari mwise musyengi wu Maghedale, Sane na Mari ngudji Sake, na baghetu bamosi. Djowu bane, abamayétsingule bilumbi nane bamayerasunine o ngile. ");
INSERT INTO puu_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Tumbe bilumbi byeni baketasange yiri motsu ame baghetu bamabatsingule, amofure na basamamavayile yitu. ");
INSERT INTO puu_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Vane-vane, Pyere akereleme, akatiremughe mbangu nowende o ngile. Anodokemine, akelabe yike matsande vatsi, na akeghabughe o ndaghu andi, akekambulu mu dyambu adi amayerasunu o ngile. ");
INSERT INTO puu_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Mune yilumbu yeni, badukitsi babedji bamawende o musyengi Yimayise, dimbu dimabe dikakene mu dighumi na take bedji na Serusaleme. ");
INSERT INTO puu_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Djowu bakenevosange mu mambu motsu amamavyoghe. ");
INSERT INTO puu_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Ave bamenevosilaange notsunde mu mambu meni, Djesu akebambene na akesobene konge nowu. ");
INSERT INTO puu_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Batu beni bamamulabaange, tumbe Nzambi akebavaghe muvuyisini yiri bakemujabe. ");
INSERT INTO puu_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Djesu akebawivule rye: «Dyambu yi dwiyenetsundile mu nzile?» Djowu, bakesikeme na munyongu wotsu. ");
INSERT INTO puu_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Wumosi va ghari owu, enengilu Kolopase, akemuwaghule rye: «Bu ndedju pinze awitsani va musyengi Serusaleme awughadjabe motsu amatsivyoghe mu bilumbu byébibi?» ");
INSERT INTO puu_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Djesu akebawaghule rye: «Ayii?» Djowu botsu bakemukanzuyile rye: «Dyambu aditsivyoghe mu Djesu mwise Nasarete. Amabe mubiyitsi wuneni avosange na mangolu nodughusungu bisalu bineni, va wusu Nzambi na va wusu batu. ");
INSERT INTO puu_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Bivunde bi bavaghulitsi ba paghu na bidjeti byetu, bamamusumbise yiri akekilusu na akeghomunu va kurusu. ");
INSERT INTO puu_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Djetu botsu mbé tukane yitu bwena djandi o mbé oyighobule mukute Yisrayele. Tumbe labatyanu, yilumbu ayiyi yike yi muryeru, mambu memane mamalabenine. ");
INSERT INTO puu_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Dingenze, baghetu bamosi va ghari etu, bamatusutusu ave bamawendile kedi neni o ngile. ");
INSERT INTO puu_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Banotole, basamarasunu yibindi yi Djesu. Bakeghabughe, bakebeghe tsangu bwena Byanze bitsibatsingule yiri Djesu adji monyu. ");
INSERT INTO puu_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Ladibandu, babaale bamosi abamabe netu, bamawendile djowandi o ngile, bakérasunu nane baghetu bamayitutsingulile bwena basamalabe yibindi yandi.» ");
INSERT INTO puu_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Djesu akevose nowu rye: «Dughejabi dyambu, durange usinge, na mirime myenu mighale, mu ughangise motsu ame babiyitsi bamadutsingule! ");
INSERT INTO puu_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Diwelimine yiri Kirisete mbé oletsoghusu ne akekote mu bundumbe bwandi.» ");
INSERT INTO puu_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Vane-vane, Djesu akebande ubatsingule motsu ame Bisonu bi Nzambi bimavose mu djabeni: ubongile mu mighande mi Moyise tena mu Bisonu bi babiyitsi botsu. ");
INSERT INTO puu_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Yike bebi bebeli na dimbu adi bamawendaange, Djesu akevaghe nane djandi evyoyi kwase. ");
INSERT INTO puu_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Mubedji ewune, bamamughome nomutsingule rye: «Wisi wumatsime, sikeme wukevyose mukolu netu.» Djesu amakote nowu o ndaghu. ");
INSERT INTO puu_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Ave bamavyoyile va metse, Djesu akebonge dipe, akeghabusile Nzambi diboti, akedibukule na akebaveghe. ");
INSERT INTO puu_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Vane-vane, misu mowu mamadibughe na bamamudjabe. Tumbe Djesu akesundile, utsyemughe va wusu owu. ");
INSERT INTO puu_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Badukitsi beni bakewivusunaange rye: «Tutsighulungu nane yusile mu mirime myetu ave atsiyene tuvosilaange mu nzile, na ave atsiyene tuvindiyilaange Bisonu bi Nzambi!» ");
INSERT INTO puu_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Badukitsi beni, bakereleme, bakesogheme o Serusaleme. Bakeye rasune dighumi na yilumbi yimosi na badukitsi botsu abamabe baghukeme nowu. ");
INSERT INTO puu_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Banobarasune, baketsingule badukitsi babedji rye: «Ame tutsighulu mangenze, Fumu adji monyu! Dingenze, atsilabene na Simu!» ");
INSERT INTO puu_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Badukitsi babedji bakemwébatsingule adimalabe mu nzile na nane bamadjabile Djesu ave amabukulile dipe. ");
INSERT INTO puu_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Ave bamavosilaange, Djesu djabeni akesundile upale va ghari owu na akebatsingule rye: «Duvotsu dubi nenu!» ");
INSERT INTO puu_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Banoghangu na keri, baketsaghemughe, mumbari bamatasaange yiri ditengu dimapale va ghari owu. ");
INSERT INTO puu_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Tumbe Djesu, akebawivule rye: «Dibandu yi, dwitsaghemuyili na mumbari yi, dubile na bakemi mu mirime myenu bwena nyidji monyu? ");
INSERT INTO puu_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Ghengilanu makake na matambi mami: dughélabi bwena menu? Ghengilanu na mbembyanu, ditengu aghaane dunyuru nane menu.» ");
INSERT INTO puu_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Anobatsingule nane, akebalase makake na matambi mandi. ");
INSERT INTO puu_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Djowu ne nane basamalesinge, dibandu nzangu na usutu awu bamasutu. Djesu akebawivule rye: «Avave, dughaane mwa yighudji yi udji?» ");
INSERT INTO puu_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Bakemuveghe yibuku yi nyame mambe djighoku na yasi yi yisile yi budji. ");
INSERT INTO puu_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Djesu akeyibonge, akeyidji va misu mowu. ");
INSERT INTO puu_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Mbana, akebatsingule rye: «Lanu, adi nyimadutsingulaange mbé ngi va ghari enu: mambu motsu amamasonughu mu menu mu mughaghe wu Moyise, mu bisonu bi babiyitsi na mu mughande Nimbu, mbé moledughusu.» ");
INSERT INTO puu_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Yike Djesu, akebadibule dudjabu, mumbari bakewulu notsiyise Bisonu bi Nzambi. ");
INSERT INTO puu_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Mbana akemwébatsingule rye: «Disonughu yiri Kirisete, otsoghusu na mu yilumbu ayimuryeru, osimbughe va ghari djowu abafu. ");
INSERT INTO puu_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Mu malongu motsu, ubandile o musyengi Serusaleme, musamu wu dukalusu du mutsanu na wu dutandulu du mabi ma batu, mbé wusamunu mu dine dyandi. ");
INSERT INTO puu_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Djenubeni, dudji bambedji ba mambu meni. ");
INSERT INTO puu_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Tumbe menu, nyudutindile pangini adji Tate ami amadulonge. Kaboghu, tsananu vave musyengi éwuwu tena dubase na mangolu ameruyi o djulu.» ");
INSERT INTO puu_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Djesu akebabeghe o yari musyengi Betani. Avane, akenangule makake na djulu, akesambile Nzambi na akebaveghe myule. ");
INSERT INTO puu_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Ave amabaveyilaange myule, akekakene nowu, akematusu o djulu. ");
INSERT INTO puu_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Badukitsi beni nabemani wumuyitse, bakeghabusile o Serusaleme na nzangu neni. ");
INSERT INTO puu_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Na temu tsyotsu bamabengunange va dulombili du ndaghu Nzambi mu umuyitsaange na mu umudodisaange.");
INSERT INTO puu_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Mundumbe Tofile, mu mughande ami wuteghe, nyimawulase motsu ame Djesu amadughusungu nolonzaange vane dibandu ");
INSERT INTO puu_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","tena yilumbu ayi amamatile o djulu. Mu yilumbu yeni, na mangolu ma Yinyuni Yisyeme, amaveghe marume mu botsu abe amasole mube bilumbi. ");
INSERT INTO puu_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Va djulu dufu dwandi, amalabene monyu nowu. Mu maghumi-mana (40) ma bilumbu, amabalasaange yi ngenze adji monyu. Mu temu eni, amalonzaange mambu ma Bukaghe bu Nzambi. ");
INSERT INTO puu_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Ave amabile nowu va mulambu, amabatsingule rye: «Syalanu wune musyengi Serusaleme, na dukelise pangini adji Tate amadulonze, adji mebeni nyimadutsingule kale. ");
INSERT INTO puu_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","San amabatise na mambe, tumbe djenu, mu mwa pesu bilumbu, dubatusu mu Yinyuni Yisyeme.» ");
INSERT INTO puu_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Djowu bamaghukeme na bamawivule Djesu rye: «Fumu, mu temu edjine wubyatsu kaghe mukute Yisrayele, mumbari wukeghabughe bulongu buneni nane va teghe?» ");
INSERT INTO puu_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Amabawaghule rye: «Dyambu dyenu tsiri udjabe batemu na maweru ame Tadji ami amatsonzighe mu ditase dyandi.» ");
INSERT INTO puu_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Tumbe dudile mangolu, Yinyuni Yisyeme yusundughe mu djenu, na dube bambedji bami ubandile o musyengi Serusaleme, o yinange yi Sudé, o yinange Samari teno masukusulu ma butambe. ");
INSERT INTO puu_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Yike emani uvose moni, amamatusu o djulu na va wusu owu, amatsyemughe o ghari madudumbi. ");
INSERT INTO puu_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Nenane djowu bamatsuninaange o djulu ave Djesu amenematilaange, babaale babedji na bidwaru biveme bamasundile wulabene nowu. ");
INSERT INTO puu_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Na bamavose nowu rye: «Bise Ngalile, dibandu yi dwisutulu na ughengile o djulu? Djesu adjitsimatusu o djulu va ghari enu, oghabughe munongu mosi nane atsimatile.» ");
INSERT INTO puu_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Bilumbi bamadusughe mukongu awinengulu Olive, na bakeghabughe o musyengi Serusaleme. Mukongu eni umabe va dyasu diveghu musughe ulinge yilumbu yi duvumu yi baSwife. ");
INSERT INTO puu_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Banotole o musyengi Serusaleme, bakemate o yibuku yi ndaghu ayi djulu, nane na kale. Vamabe Pyere, San, Sake na Andere, Filipe na Tome, Batelemi na Mati, Sake mwane Alefé, Simu awu benengili Selote, na Sudase mwane Sake. ");
INSERT INTO puu_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Djobotsu bamabengunungu temu na temu va mosi mu dusambu, na baghetu, na Mari ngudji Djesu, na baane ba ngudji ba Djesu. ");
INSERT INTO puu_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Mu bilumbu byeni, Pyere amareleme va ghari owu. Durangu du botsu dumabe kame na maghumi-mabedji (120). Na akevose rye: ");
INSERT INTO puu_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","«Baane ba tadji, diwelimine yi pangini adjimabighu mu Bisonu bi Nzambi djuduwusu. Mu Bisonu byeni, Yinyuni Yisyeme amavose vane kale mu munu Davide, mu dyambu di Sudase, awu amabe yibeghe ndonge yi abamarughe o uyighaange Djesu. ");
INSERT INTO puu_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Dibaale dyédine, amabe wumosi va ghari etu, na amasalaange va mosi netu. ");
INSERT INTO puu_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Na mbongu atsi amadile mu bukongu bwandi, amasumbe nungi andi. O ghari nungi eni amaberuyile maghuwusu, modji andi wuke pasighe na misopu myotsu mikebe layini va tsi. ");
INSERT INTO puu_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Batu botsu ba musyengi Serusaleme bamadiwulu, la dibandu o mbembu owu, bamanengilile nungi eni “Akeldama” diwendi yiri: “Nungi malungu”.» ");
INSERT INTO puu_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Na Pyere amabwele rye: «Mu mughande Nyimbu, disonu rye: “Batu badusuyi mu ndaghu andi, na vayabe mutu wutsane mu djoni.” Na disonu rye: “Mutu mususu abongi mbure andi.” ");
INSERT INTO puu_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Vengu tusolanu wumosi va ghari botsu abamayenewendaange konge netu, temu djotsu Fumu Djesu amanangilaange bulongu netu. ");
INSERT INTO puu_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Amabe netu ubandile temu adji San amabatisile Djesu, tena yilumbu ayi amamatile o djulu. Kaboghu, mutu mosi mu yinombu mbé obe mbedji netu, dji durambughu du Djesu o dufu.» ");
INSERT INTO puu_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Bamalase batu babedji: Sosefe awu bamanengilaange «Baresabase», dine dyandi dimosi «Susutuse» na Matyase. ");
INSERT INTO puu_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Bakevaghe dusambu dwedudu: «Fumu, widjabi mirime mi botsu. Tulasi ndebeni, anyi mu mubedji éwuwu, wusole. ");
INSERT INTO puu_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","Djandi obe yilumbi, na obonge yisalu va yivinze yi Sudase, omayisile mughabughe o mbure adjimabe djandi.» ");
INSERT INTO puu_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Va djulu vane, bakebwaghe mbande, na Matyase akebwesu mu yinombu yi dighumi na yilumbi yimosi. ");
INSERT INTO puu_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Ave yilumbu yi mumengu Patekote yimatolile, bango yitu bamabe baghukeme mbure mosi. ");
INSERT INTO puu_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Sundila, nduku djimarughe o djulu, djimabe nane mungudi wuneni. Nduku eni djimabase ndaghu adji bamabe baghukemine. ");
INSERT INTO puu_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Kaboghu, bakelabe ndimi nane milutsu mi mudji. Tsikekakunu, tsikesundughe na tsiketsane mu kale mutu. ");
INSERT INTO puu_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Botsu bamabasu na Yinyuni Yisyeme na bamabande uvose mambembu masusu, nane Yinyuni amaveyilaange kale mutu mumavose. ");
INSERT INTO puu_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","O Serusaleme, wumabe baSwife bamayitsaange Nzambi, bamarughesene mu malongu motsu ma butambe. ");
INSERT INTO puu_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Ave bamawululu nduku eni, yinombu yi batu yikeghukeme. Yimakambulu tinde ukambulu, mumbari kale mutu amabaghulungu uvose mu dilongu dyandi. ");
INSERT INTO puu_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Bamasutu na bakebanyungilaange, novosaange rye: «Batu bebabe, bise Ngalile! ");
INSERT INTO puu_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Yike tsyeni twibaghululu, uvose dilongu di mutu-mutu? ");
INSERT INTO puu_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Va ghari etu, bamosi bise Patese, Medese, Elame, Mesopotami, o Sudé na Kapadose, basusu bise Pon na Asi, ");
INSERT INTO puu_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Firisi, Pafili, Yisipete, bamosi o musyengi wu Libi adji bambene na Sirene, na botsu abamarughesene o Rome, ");
INSERT INTO puu_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","bise Kerete na Arabi. Va ghari etu, bane bamaburu baSwife, abane wandi bamarughesene o malongu masusu, bamavayile Nzambi baSwife yitu. Yike tsyeni twibaghululu uvose maboti ma Nzambi mu mambembu metu.» ");
INSERT INTO puu_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Botsu bamasutu na bamaghambu na dyuvose. Bamakewivulaange yiri: «Adidi tsyé diwendili?» ");
INSERT INTO puu_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Tumbe basusu, bamapedjingi botsu abamasinge Nzambi novose rye: «Badji mu malangi!» ");
INSERT INTO puu_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Pyere na dighumi na yilumbi yimosi, bamareleme va ghari mughungi, na Pyere akevose rye: «Bise Sudé, na djenu botsu abe dwitsani o Serusaleme, wulwanu adivyoyi na dyo ngadutsingule, limbighanu matudji. ");
INSERT INTO puu_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Batu beni babe bagha balange nane dwitasili, mumbari wisi aki kedi. ");
INSERT INTO puu_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Tumbe vave, adimavosu na mubiyitsi Sowele: ");
INSERT INTO puu_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","“Mu bilumbu bi musitu, me Nzambi, nyuveghe Yinyuni yami mu batu botsu. Baane benu babaale na ba baghetu bobighaange. Minzambu myenu myulabaange biryaryamu, mba binunu byenu byudoraange bandosi. ");
INSERT INTO puu_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Nine, mu bilumbu byébine, nyusunze Yinyuni yami, mu basalitsi bami botsu ba babaale na ba baghetu. Djowu botsu bobighaange. ");
INSERT INTO puu_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Menu nyulase bimaghe o djulu, na bilimbe mu butambe, vobe malungu, mudji, na dimungi di nzumbili. ");
INSERT INTO puu_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Nyangu djutsime nokalughe piseme, na tsungi djubenge nane malungu, ne yilumbu yi Fumu yike rughe, yilumbu ayube yineni mba yirange. ");
INSERT INTO puu_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Yike batu botsu abonengile Fumu, boghobulu.” ");
INSERT INTO puu_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Bise Yisrayele, wulwanu adi menu ngadutsingule. Djesu mwise Nasarete amabe mutu awu Nzambi amadulase munongu andi. Amadivaghe ave amamuveyile musughe wuvaghe bimaghe na bilimbe bi mangolu. Djandi amadughusu va ghari enu nane djenubeni dwididjabili. ");
INSERT INTO puu_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Nane djabeni Nzambi amakunzile mu dughanu dwandi ne mambu meni makelabene, djenu dumaghangise Djesu na batu baghane yitu, bakemughomine nomuboke va kurusu. ");
INSERT INTO puu_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Tumbe Nzambi amamudjeyise mu maghughe ma dufu, akemughabuse monyu, mumbari Djesu mbé aghorungule ughangu na mangolu ma dufu. ");
INSERT INTO puu_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Kaghe Davide amavose mu djandi rye: “Nyimalabaange Fumu va wusu ami, o mabaale mami, mumba ngéregheme. ");
INSERT INTO puu_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Ladibandu, murime ami wumabile mu nzangu, na munu ami wiwimbili na yinyunge. Ne dunyuru dwami dube dubase na yitu, ");
INSERT INTO puu_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","mumbari Fumu aghonzile o bulongu bu bobafu, na wughogharu bwé Yibyatsi yaghu Yisyeme, yikebungene wusulemughe o ghari mbine. ");
INSERT INTO puu_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Wumandase manzile amebeyi o monyu, wumbase na nzangu ave nyubile va wusu aghu.” ");
INSERT INTO puu_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Baane ba tadji, menu nine musughe wudutsingule na bureti mu dyambu di kaaghe etu Davide. Djandi amafu, na amatswighu na mbine andi djikilabene tena vave, va ghari etu. ");
INSERT INTO puu_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Djandi amabighe mumba amadjabaange yiri Nzambi amaleve pesi mu djabeni bwé, wumosi mu bateghule bandi obe yivinze yandi va yitsighe yi bukaghe. ");
INSERT INTO puu_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Mu posulu eni, Davide amabighe durambughulu du Kirisete o dufu. Adine amavosile rye: “Asamamusile o bulongu bu bobafu, na dunyuru dwandi dusamabole o ghari mbine.” ");
INSERT INTO puu_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Djesu eni nyiranguni, Nzambi amamughabuse monyu. Djetu botswanu tudji bambedji. ");
INSERT INTO puu_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Tate Nzambi amamatise Djesu o mabaale mandi. Djandi amamuveghe Yinyuni Yisyeme ayimavangenu. Djawandi amatupuyile yoni, adine dwilabi nowulu vave. ");
INSERT INTO puu_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Davide djabeni asamamate o djulu, tumbe amavose rye: “Fumu Nzambi amatsingule Fumu ami yiri: Yitsane omabale mami, ");
INSERT INTO puu_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","tena nyusunze bavinitsi baghu otsi makulu maghu.” ");
INSERT INTO puu_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Mukute wotsu wu Yisrayele widjabi na bureti yiri Nzambi amamubyatse Fumu na Kirisete. Djesu édjine adji dutsi ghomine noboke va kurusu.» ");
INSERT INTO puu_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Bapikile ba botsu abamawulu mbembu édjine baketsyemughe, na bamawivule Pyere na bilumbi bimosi yiri: «Bane ba tadji, yike tsyeni turungule wuvayile?» ");
INSERT INTO puu_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Pyere amabawaghule rye: «Fungulanu nodunde mabi menu, na kale mutu mbé obatusu mu dine di Djesu Kirisete. Vaghanu nane, mabi menu motandu, na dukedile Yinyuni Yisyeme. ");
INSERT INTO puu_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Nzambi amaghane wudivaghe ombu bane benu, djenubeni, na botsu abetsani o malongu mavale, batu botsu nane Fumu Nzambi obanengilile.» ");
INSERT INTO puu_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Pyere amabwévose pwele mambu, na amabawarise novose rye: «Singanu dughobutsu mumbari monyu enu, wukekakene na mutsanu wubive wu bulongu bwébubu!» ");
INSERT INTO puu_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Botsu abamawulu nosinge mbembu Pyere, bamabatusu. Mu yilumbu yeni, tangudji tosini-yiryeru (3 000) tsi batu bamasobene nowu mu yinombu. ");
INSERT INTO puu_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Temu tsyotsu, bamawulungu ndonzulu bilumbi na musighe, bakebeghange monyu dibure-ngudji, bamadjangaange nosambilaange va mosi. ");
INSERT INTO puu_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Kale mutu amawulungu keri, mumbari Nzambi amadughusungu pwele bilimbe na bimaghe mu nzalusulu bilumbi. ");
INSERT INTO puu_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Bango yitu botsu bamabangaange mbure mosi na bamaghabenaange byotsu abimabangaange byowu. ");
INSERT INTO puu_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Bamasumbisaange maboti mowu, na bakeghabenaange badoli djobotsu, nane kale mutu amabilaange na nzale. ");
INSERT INTO puu_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Bilumbu byotsu, na murime mosi, bamaghukemange o dulombili du ndaghu Nzambi. Bameneghabaange bighudji mu mandaghu mowu na bamadjangaange na nzangu na murime pwelele. ");
INSERT INTO puu_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Bamayitsaange Nzambi na mukute wotsu wumabanyungilaange. Na Fumu amabwesaange kale yilumbu mu yinombu yowu botsu abe amaghobulaange. ");
INSERT INTO puu_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Mwa yilumbu, va murekemunu wisi, Pyere na San bamawendaange o ndaghu Nzambi, va diweru di dusambu. ");
INSERT INTO puu_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Lake, bamatsyetaange dibaale dimaburu yikoyi, awu amasunzungu kadi yilumbu va dikotulu di ngande ndaghu Nzambi, va mune ndaghu awinengulu «Diwuyi Diboti». Djandi amavondaange mbongu na yingebe, ombu djowu abamakotaange o ghari ndaghu Nzambi. ");
INSERT INTO puu_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Anolabe Pyere na San bwé yikukote bakekote o ghari ngande eni, dibaale dyeni, akebavonde mbongu. ");
INSERT INTO puu_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Pyere djone San bakemughengise na bakemutsingule yi: «Tutsuni.» ");
INSERT INTO puu_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Djandi akebatsune, amatase yiri odile mwa yime mu djowu. ");
INSERT INTO puu_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Tumbe Pyere akemutsingule rye: «Ngane badoli vo lore, tumbe ayivu nami, nyighuve yoni. Mu dine di Djesu Kirisete mwise Nasarete, releme na wende!» ");
INSERT INTO puu_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Akemughaange mu dikake dyandi di mabaale, akemurelighe. Vane-vane, matambi mandi na bapanzi bandi bikesundile wuware, ");
INSERT INTO puu_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","akereleme fungelini na akebande uwende. Amakote nowu o ghari ngande ndaghu Nzambi, amayenewendaange djabeni, amayenedumughaange, noyitsaange Nzambi. ");
INSERT INTO puu_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Mukute wotsu wumamulabe uwende, noyitse Nzambi. ");
INSERT INTO puu_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Bamamudjabaange yiri djandi awu amabangaange atsane va Diwuyi Diboti di ndaghu Nzambi, mu vondaange mbongu. Banolabe adimamuruyile, batu bamakambulu na bamasutu. ");
INSERT INTO puu_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Tumbe djandi, asamamwékakene na Pyere na San. Mukute wotsu wumawende mbangu wukebakande o dulombili du ngande ndaghu Nzambi, o Pyasu dji Salemu, bamasutu. ");
INSERT INTO puu_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Ave Pyere amalabile nane, akevosile mughungi yi: «Batu ba Yisrayele, mumba yi dumasutulu mu aditsilabene? Yi dwitutsunini, nane bwé mu mangolu metu vo yitu yetu, mutu éwuwu atsirelemine? ");
INSERT INTO puu_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Nesi, tumbe Nzambi Aberaame, adji Nzambi Yisaake, Nzambi Sakobe na Nzambi baghulu betu, amabase Djesu musalitsi andi na bundumbe. Djesu eni adji dumasumbise ombu Pilate na dumamughale va wusu andi. Nenane Pilate mbé amudjeyisile. ");
INSERT INTO puu_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Yine dumamughale, djandi awu asyeme na asungeme. Va yivinze yandi, dumavonde musughe wudjeyise yikongu. ");
INSERT INTO puu_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Mu dyoni, dumaboke oyive monyu, tumbe Nzambi atsimurambuse o dufu, tudji bambedji. ");
INSERT INTO puu_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Kaboghu, dwilabi mutu éwuwu na dwimudjabi. Mu dine di Djesu atsiwarusulu, mumbari djetu twivali Djesu yitu. Mu yitu mu Djesu atsibelusu djandi wotsu, va wusu djetu botsu. ");
INSERT INTO puu_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Na vave, baane ba tadji, nyidjabi yiri dutsighambu na dudjabu mu nzalesulu tsyenu, nane bivunde byenu. ");
INSERT INTO puu_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Nzambi amadidughusu nane djabeni amadikunzile va dibandu mu munu babiyitsi botsu yi Kirisete adji otinde, otsoghusu. ");
INSERT INTO puu_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Kaboghu, fungulanu mabi menu na ghabughanu manzinzimze, mumbari mabi menu maketsindulu. ");
INSERT INTO puu_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Anane Fumu oduveghile duvotsu, na odutindile djandi awu amasolu, Djesu Kirisete. ");
INSERT INTO puu_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Diwelimine bwé Djesu mbé olebe o djulu na Nzambi, tena yilumbu ayi mambu motsu moghabuyile maghone, nane Nzambi amavosile mu munu babighitsi bandi basyeme. ");
INSERT INTO puu_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Dingenze Moyise amavose: “Fumu Nzambi enu odupalisile va ghari mukute enu mubiyitsi nane menu. Dumuwululu mu motsu ame odutsingule. ");
INSERT INTO puu_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Wotsu owubuse uwulu mubiyitsi, oboku na obungu va ghari mukute Nzambi.” ");
INSERT INTO puu_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Babiyitsi botsu, ubandile va Samwele na botsu abamarughe va yinzime yandi, bamavose djowandi mu temu adjidji tuvu anu. ");
INSERT INTO puu_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Djenu dudji baane ba babiyitsi, mba bibyalile bi disyale adi Nzambi amavangene na baghulu betu. Lanu adi Nzambi amatsingule Aberaame: “Bifumbe byotsu bi butambe na bakule bowu, bodile myule.” ");
INSERT INTO puu_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Pangini édjidji adji enu, adjimarombise Nzambi utinde musalitsi andi muduveghe myule, nodukakene mu mabi menu.» ");
INSERT INTO puu_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Bavaghulitsi ba paghu na yivunde yi baghore abamakelisaange ndaghu Nzambi, na bise dibuli di baSadisi bamaruyile ave Pyere djone San bamavosilaange mughungi. ");
INSERT INTO puu_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Djobotsu bamabase na kabu djineni, mumbari bamalabe Pyere djone San ulonze mukute yi: botsu abafu wandi boghabughe monyu, nane Djesu amaghabuyile monyu. ");
INSERT INTO puu_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Bakebaghaange na bakebabwaghe o tsughu tena kedi, mumbari wisi mbé wumatsime. ");
INSERT INTO puu_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Tumbe, bapwele va ghari botsu abamawulu mbembu Nzambi, bakesinge ube bango yitu. Durangu dwowu dumabe tangudji tosini-yiranu (5 000) tsi batu. ");
INSERT INTO puu_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Va kedi, bidjeti, bivunde bi baSwife na milonzi mi mighaghe bakeghukeme o Serusaleme. ");
INSERT INTO puu_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Va ghari owu vamabe: Ane yivunde yi bavaghulitsi ba paghu, Kayife, San, Alesandere na botsu abamabe mu mukute yivunde yi bavaghulitsi ba paghu. ");
INSERT INTO puu_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Bakebeghe bilumbi va wusu owu na bakebawivule rye: «Mu musughe nyi vo mu dine di nyi dutsidivayile?» ");
INSERT INTO puu_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Pyere, abasulungu na Yinyuni Yisyeme, akebatsingule rye: «Djenu bidjeti bi mukute na bivunde bi baSwife, ");
INSERT INTO puu_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","djetu tutsivaghe diboti ombu djandi awu abetsi yikoyi. Na nyangu yike wuwivule dwituwivuli, tsyeni dibaale dyédine ditsidilile dubelusu? ");
INSERT INTO puu_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Djenu botsu na mukute wotsu wu Yisrayele, dune dyambu dimosi adi mbé durungule udjabe: mu dine di Djesu Kirisete mwise Nasarete, dibaale adivu va wusu enu atsi dilile dubelusu. Djesu Kirisete adji djenu dumaghomine va kurusu, Nzambi akemughabuse monyu. ");
INSERT INTO puu_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Mu Dibuku di Mbembu Nzambi direndu: “Dimani adi djenu barungitsi dumabwaghe, dimakalughe yike dimani, adi neni adi siki yibughe yi ndaghu.” Djesu la dimani dyeni. ");
INSERT INTO puu_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Djandi wandi pinze, awu orungulu wutughobule. Adine, mu bulongu bwotsu, Nzambi asamaveghe mutu susu, awu djetu botwanu tughobululu.» ");
INSERT INTO puu_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Bidjeti byeni bike kambulu, binolabe Pyere djone San bévosi na musighe. Vane-vane, bimabwélabe yiri badji batu ba kulini, abasamanenge mba baghane dudjabu. Djowu, bamabadjabaange bwé bamayenewendaange na Djesu. ");
INSERT INTO puu_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Tumbe, ave bamalabilaange yikoyi ayi mabelusu, diteli va mughule bilumbi, bidjeti byeni bisamadile adi uvose. ");
INSERT INTO puu_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Kaboghu, baketsingule bilumbi yi: «Palanu o ndaghu dusosusu!» Na bakesyale djobeni notsunde. ");
INSERT INTO puu_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Bakewivusenaange: «Yike tsyeni turungule wuvayile batu bebabe? Dingenze, bamavaghe yimaghe, batu botsu ba musyengi Serusaleme bamadidjabe, na tughorungule udighale. ");
INSERT INTO puu_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Tumbe, turungule uvaghe yiri yilumbi yéyine yikényave va ghari mukute. Kaboghu, tubaghandisyanu nobanyangile bwé bayabwé bile uvosile mutu wotsu mu dine di Djesu.» ");
INSERT INTO puu_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Lake bakenengile Pyere na San, nobatsingule rye: «Duyabwévose vo ulonze mu dine di Djesu.» ");
INSERT INTO puu_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Tumbe Pyere na San bamabawaghule rye: «Va wusu Nzambi, yi yisungeme: wudughobise djenu, vo wughobise Nzambi? Sosanu djenubeni! ");
INSERT INTO puu_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Tumbe mu djetu, tughorungule ubuse uvose nolonze mu motsu ame tumalabe nowulu.» ");
INSERT INTO puu_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Bidjeti byeni bike bwévale Pyere na San mapemi maghone na bakebadunde, basamadile tonu djubakilisile. Yike mukute wotsu wumawimbilaange noyitse bundumbe bu Nzambi dibandu yimaghe ayimalabene. ");
INSERT INTO puu_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Dibaale adimabelusu na yimaghe yéyine mbé amavyoghe maghumi-mana (40) ma bilime bi duburu. ");
INSERT INTO puu_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Pyere djone San banodundu, bamawende kwase uyélabe bambatsi bowu, noyebatsingule motsu ame bivunde bi bavaghulitsi ba paghu, na bivunde bi baSwife bamabatsingule. ");
INSERT INTO puu_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Banomane ughuwulu ame Pyere na San bamabatsingule, djobotsu bamasambile Nzambi na murime wumosi, novose rye: «Mulonzi, ndedju wumasunde djulu, butambe, mubu na byotsu abivu mune. ");
INSERT INTO puu_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Ndedju, mu munu Davide kaaghe etu, musatsi aghu awumabase na Yinyuni Yisyeme, wumavose rye: “Mumbari yi mikute mimanyoyile? Mba mitungili Nzambi fundu, tumbe mambu motsu mane ma nzolu. ");
INSERT INTO puu_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Bakaghe ba butambe bamakunzeme mutoghe divite, bidjeti bimawulusunu mube mimbini mi Fumu Nzambi na Kirisete andi.” ");
INSERT INTO puu_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Dingenze, Yirode ayi Atipa na Ponze Pilate djowandi, bamaghukeme o musyengi éwuwu, djone beni na mukute Yisrayele, mu toyise Djesu. Djandi awu amabe musatsi awusyeme, awu ndebeni wumasole nane Kirisete. ");
INSERT INTO puu_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Yike bamadughusu motsu ame ndebeni, mu matase na mangolu maghu, wumakunze vane dibandu. ");
INSERT INTO puu_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Avave Fumu, labe nane bétukwanini, na veghe bisatsi byaghu mangolu moyenetsingulaange nolonze mbembu aghu na duvotsu vo na musighe. ");
INSERT INTO puu_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Kaboghu, lase mangolu maghu yi va ghari etu vakelabene biryaryamu, bimaghe, dubelusu na bilimbe bimosi mu dine di musalitsi aghu Djesu, djandi odjivu asyeme.» ");
INSERT INTO puu_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Ave bamamanine wusambile, butambe bumaregheme va mbure adji bamabe. Djobotsu bakebase na Yinyuni Yisyeme na bamayenetsingulaange mbembu Nzambi na musighe. ");
INSERT INTO puu_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Botsu abamakalughe bango yitu, bamawulusunungu, na dinonge di murime na ditase dimabe diware va ghari owu. Vagha mutu amavosaange rye: «Bime abibi, abyami!» Tumbe, bamaghabenaange byotsu abi bamadilaange. ");
INSERT INTO puu_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Yike na mangolu maneni, bilumbi bamayenesamunaange durambughulu du Fumu Djesu o dufu. Mba yese yi Nzambi yimalabenaange na mangolu mu kale mutu. ");
INSERT INTO puu_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Vasamabe mutu va ghari owu amaghambu na yime, mumbari botsu abamabe na banungi vo mandaghu, bamamasumbisaange na bamabeghaange badoli beni botsu ");
INSERT INTO puu_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","ombu bilumbi. Lake djowu bamatsighabaange, na kale mutu amadilaange dyandi dikabu. ");
INSERT INTO puu_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Nane yibaghunu yi dibaale bamanengilaange Sosefe, amabe na nungi. Djandi awu bilumbi bamalughe yike Barenabase, diwendili yi: «Mutu awiwarisi», amabaange musalitsi wu dilongu di Levi, mwise Sipere. ");
INSERT INTO puu_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Akesumbise nungi andi, akebeghe madila na akimaveghe bilumbi. ");
INSERT INTO puu_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Tumbe dibaale dimanengulungu Ananyase, na mughatsi andi Safire, bakesumbise nungi mosi. ");
INSERT INTO puu_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Banowulusunu, bakesweghe dikabu di mbongu, na bakelase dikabu adimasyale ombu bilumbi. ");
INSERT INTO puu_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Pyere akemuwivule rye: «Ananyase, tsyé dyabu amabasile murime aghu nane? Wumafure Yinyuni Yisyeme, mba wumasweghe dikabu di mbongu atsi dutsidile mu nungi enu. ");
INSERT INTO puu_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Ne wukedjisumbise tsya djibetsi djaghu? Wuno dji sumbise, ughabetsi na musughu wubonge badoli baghu? Yike tsyeni, wutsibile na ditase divelughe nane o ghari murime aghu? Tsi batu wutsifure, tumbe Nzambi!» ");
INSERT INTO puu_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Yike edighulu, Ananyase akeberughe na akesuke muvumu. Mba botsu abamadiwulu bakeghangu na dunzyenzi. ");
INSERT INTO puu_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Minzambu bakibonge mvumbi, bakedji pyete noyetswighe. ");
INSERT INTO puu_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Tangudji maweru maryeru manovyoghe, mughatsi Ananyase akerughe, asamadjabe adimavyoghe. ");
INSERT INTO puu_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Pyere akemuwivule yi: «Nzinguli, dufunu adu dutsisumbisile nungi enu adudu?» Akewake: «Yine, adune.» ");
INSERT INTO puu_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Kaboghu Pyere akemutsingule rye: «Tsyé dutsiwulusununu mumange Yinyuni yi Fumu? Wulu! Abatsiyetswighe mulumi aghu, bake va mune ndaghu, bowubeghe ndewandi.» ");
INSERT INTO puu_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Vane-vane akeberughe va makulu ma Pyere na akesuke muvumu. Minzambu mikekote, mikemurasunu amafu, mikemunangule na bakeyémutswighe va mughule mulumi andi. ");
INSERT INTO puu_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Dibundu dyotsu na botsu abamamawulu bakeghangu tindi na dunzyenzi. ");
INSERT INTO puu_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Bimaghe na bilimbe bipwele bimavaghungu na bilumbi va ghari mughungi. Bango yitu bamatsanaange va mosi o Pyasu Salemu. ");
INSERT INTO puu_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Djobotsu bamabaghobisaange pwele, yotsu yine, vagha ne mutu wumosi wumarondaange wusobene nowu. ");
INSERT INTO puu_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Baghetu na babaale bapwele, abamavayile Fumu yitu bamafunaange temu tsyotsu. ");
INSERT INTO puu_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Adine bamabeyilaange bibedu, mba bakebasunzaange mu tsyengi vo mu matoghu mu manzile. Bamavayilaange nane, mumbari ave Pyere ovyoyile, yidumbitsi yandi yikewumbe ne wumosi va ghari owu. ");
INSERT INTO puu_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Yinombu yineni yimarughaange o misyengi amibambene na Serusaleme. Yinombu yeni yimaghukeme o musyengi Serusaleme. Aghune, bamabeghaange bibedu, na batu abamakwanungu na binyuni bibive, na botsu bamabelughaange. ");
INSERT INTO puu_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Kaboghu, yivunde yi bavaghulitsi ba paghu na botsu abamabe nandi, diwendi yi na dibuli di baSadisi, bakebalabe ngusu na bakeghane kake. ");
INSERT INTO puu_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Va wusu batu botsu, bakebaghaange na bakebabwaghe o tsughu. ");
INSERT INTO puu_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Tumbe, vane mukolu, yanze yi Fumu yikedibule mune ndaghu, yikebapalise. Yanze yeni, yikebatsingule rye: ");
INSERT INTO puu_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","«Wendanu o ndaghu Nzambi, na tsingulanu mukute mambu motsu ma monyu wughone.» ");
INSERT INTO puu_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Bilumbi banomawulu, bamawende kedi neni o ndaghu Nzambi na bamalonzaange. Yivunde yi bavaghulitsi ba paghu na botsu abamabe nandi, bakerughe na bakeghukighe fundu dji banzonzi ba baSwife na bivunde bi dibundu di mukute Yisrayele. Bamatinde batu muyélande bilumbi o tsughu. ");
INSERT INTO puu_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Tumbe baghore banotole, basamabarasune o tsughu. Bakeghabughe ombu bidjeti muyebatsingule bikumbu. Na bakevose yi: ");
INSERT INTO puu_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","«Tutsirasene tsughu dji dibeme na burange, kale ghore abe va mbure andi va wusu byabutsu. Tumbe ave tutsidjidibulile, tugharasene mutu o ghari.» ");
INSERT INTO puu_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Banodighulu, yivunde yi baghore ba ndaghu Nzambi na yivunde yi bavaghulitsi ba paghu bakekambulu nokewivule adimavyoghe. ");
INSERT INTO puu_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Mba mutu akibatsingule yi: «Wulwanu! Batu abe dutsisunze o tsughu, badji o ndaghu Nzambi obélonzili batu mambu mowu.» ");
INSERT INTO puu_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Vane-vane yivunde yi baghore ba ndaghu Nzambi akewende na batu bandi muyéghange bilumbi. Tumbe basamavaghe buvape, mumba bamadumange yi mughungi wukébatinde mamani. ");
INSERT INTO puu_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Banobabeghe, bakebawakise ombu fundu dji banzonzi. Yivunde yi bavaghulitsi ba paghu akebafundise. ");
INSERT INTO puu_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","Djandi akebatsingule yi: «Tumadughandise kile-kingi ulonze mu dine di mutu ewune. Tumbe yi dumavaghe? Dumanyavise ndonzulu enu ombu batu botsu abetsani o musyengi Serusaleme, mba dwirondi usunze dufu du Djesu va djulu muru etu!» ");
INSERT INTO puu_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Pyere na bilumbi bimosi, bakebawaghule yi: «Diwelimine yi tughobisaange Nzambi, tsiri batu. ");
INSERT INTO puu_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Nzambi baghulu betu amarambuse Djesu adji djenu dumaghomine va kurusu mu muboke. ");
INSERT INTO puu_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Nzambi amamumatise o mabaale mandi, mba amamubyatse Yidjeti na Mughobutsi. Amavayile nane, muveghe Yisrayele yese yukalughe dyele nodile dutandu du mabi mandi. ");
INSERT INTO puu_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Tudji bambedji ba mambu meni, djetu na Yinyuni Yisyeme ayi Nzambi amaveghe abemughobisi.» ");
INSERT INTO puu_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Bivunde bi fundu dji banzonzi banowulu nane, bakenyoghe tinde unyoghe tena bamaronde ubabokise. ");
INSERT INTO puu_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Tumbe va ghari owu, vamabe muFarisi wumanengulungu Ghamalyele, mulonzi mighaghe wumaghobusungu na batu botsu. Djandi akereleme va ghari fundu dji banzonzi na akevaghe bakepalise bilumbi mwa temu. ");
INSERT INTO puu_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Mba aketsingule dibundu yi: «Bise Yisrayele, kebenanu na adi dwirondi uvaghe batu beni bane. ");
INSERT INTO puu_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Vasekabe yitsingu tumalabe Tedase ureleme vave, amavumbaange wube yidjeti. Tangudji vamabe ne kame-djine (400) tsi batu bamasobene nandi. Tumbe akeboku, botsu abamamuduke baketsyamughe mba vasamasyale ne yisalu mu dighane dyandi. ");
INSERT INTO puu_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Va djulu vane, va temu sanzeme, tumalabe Sudase mwise Ngalile, amadute tinde bapwele nandi. Tumbe akeboku djawandi, na botsu abamamuduke baketsyamughe. ");
INSERT INTO puu_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Vave nyidutsinguli: duyamwéghengile ame bévayi, basilyanu bayenewende. Mumba payi matase mowu na bisalu birambuyili ombu batu, byutsyemughe. ");
INSERT INTO puu_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Tumbe payi birambuyili ombu Nzambi, dughorungule ubipanze. Duyakubene utoghe na Nzambi». Bise dibuli dyeni bakeghululu Ghamalyele. ");
INSERT INTO puu_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Bakenengile bilumbi, bakebadimbise na mangwangu, bakebaghandise urangune dine di Djesu mba bakebadunde. ");
INSERT INTO puu_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Bilumbi banodusughe o ndaghu dusosusu. Bamayene wende na nzangu mumbari, bamadjabe yiri Nzambi atsibalabe yi bawelimine ukwanu mu dine di Djesu. ");
INSERT INTO puu_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Mba kale yilumbu, va dulombili du ndaghu Nzambi na mu ndaghu mowu, bamabwelaange ulonze na uwanze musamu wuboti wu Djesu Kirisete. ");
INSERT INTO puu_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Mu temu eni, durangu du badukitsi dumafunaange. Kaboghu baSwife abamavosaange mbembu baNgereke, bakengugerene mu djowu abamavosaange mbembu baEberu. Mumbari bakwili ba baNgereke, bamafwimbungu mu bighudji abimaghabungu kale yilumbu. ");
INSERT INTO puu_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Dighumi na babedji bakenengile yinombu yi badukitsi nobatsingule riye: «Dighadiwelimine yi tukedunde ulonze musamu wu Nzambi mughabaange bighudji. ");
INSERT INTO puu_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Ladibandu, baane ba tadji, solanu yisambwali yi babaale bavu na bumbedji buboti, babase na Yinyuni Yisyeme na dyele. Tukebaveghe yisalu yeni yine. ");
INSERT INTO puu_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Tumbe djetu, tuvyosaange temu mu dusambu nolonze musamu Nzambi.» ");
INSERT INTO puu_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Dibundu dyotsu dikesinge ditase dyeni. Bakesole Yityene, dibaale dibase na Yinyuni Yisyeme, divu na yitu yandi yotsu mu Nzambi. Bakemwésole Filipe, Porekore, Nikanore, Timone, Paremenase na Nikolase, mwise Atyose dji Siri, djandi awu amasinge Nzambi baSwife. ");
INSERT INTO puu_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Bakebawakise ombu bilumbi, bakebasambilile nobasakighe makake. ");
INSERT INTO puu_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Mbembu Nzambi djimanyavaange. Durangu du badukitsi dumafunaange o Serusaleme, na pwele bavaghulitsi ba paghu bamavayilaange Djesu yitu. ");
INSERT INTO puu_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Na mangolu na yese yi Nzambi amamuveghe, Yityene amalasaange bilimbe novaghe bimaghe bineni va ghari mukute. ");
INSERT INTO puu_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Mwa dikabu di batu, bakemutsundise. Djowu batu ba ndaghu dusambu adjimanengulu «Bavighe abamadjeghusu». Mu ndaweni, mumabe baSwife ba misyengi mi Sirene na Alesanderi. Dikabu dimosi baSwife ba binange bi Silisi na Asi. ");
INSERT INTO puu_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Tumbe basamarungule ughaghene nandi, mumbari amavosaange na dyele di Yinyuni Yisyeme. ");
INSERT INTO puu_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Kaboghu bakefute batu muyéfure bumbedji yi: «Tutsimughulu esyengi Moyise na Nzambi.» ");
INSERT INTO puu_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Anane bamarulile batu botsu, bivunde bi mukute na milonzi mi mighaghe. Mba bakesutusu Yityene nomughange, bakemubeghe va wusu fundu dji banzonzi. ");
INSERT INTO puu_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Bakebeghe bambedji ba ufure, abamavose yi: «Mutu éwuwu aghedundi ulenze ndaghu adjisyeme dji Nzambi, na mughaghe Moyise! ");
INSERT INTO puu_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Tutsimughulu evosi yi Djesu mwise Nasarete, opanze ndaghu Nzambi na osanze mutsanu awu Moyise amasile.» ");
INSERT INTO puu_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Batu botsu abamabe va ghari fundu dji banzonzi, bamalabe yinzi yi Yityene yimabaghunu nane ayi yanze. ");
INSERT INTO puu_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Mulonzi awuvu yivunde akemuwivule: «Adibevosi mu ndedju, dingenze?» ");
INSERT INTO puu_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Yityene akewaghule yiri: «Baane ba ngudji na batate nkululwanu, Nzambi bundumbe amalabene na kaaghe etu Aberaame, ave amabile o yinange yi Mesopotami ne akewende o musyengi Arane. ");
INSERT INTO puu_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Nzambi akemutsingule yiri: “Sile bulongu bwaghu na yifumbe yaghu, na wende o bulongu abu nyuwulase.” ");
INSERT INTO puu_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Na vane Aberaame akedjusughe bulongu bu Babilone na akewende oyétsane o musyengi Arane. Mba tadji Aberaame anofu, Nzambi akemubeghe o bulongu bughone abu dwitsanini na nyangu. ");
INSERT INTO puu_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Nzambi asamamuveghe disyale, ne mwa mbure djusunzile ditambi o bulongu bweni. Tumbe, amamuveghe pangini djudile bulongu bwotsu, djandi na bakule bandi. Yotsu yine, Aberaame mbé asekabe na baane. ");
INSERT INTO puu_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Nzambi amamutsingule rye: “Baane na bateghule baghu boyétsane o bulongu bu bweni, awu bobile bavighe na botsoghusulu mu kame-djine (400) tsi bilime. ");
INSERT INTO puu_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Tumbe menu Nzambi, nyusosise mukute awu djowu bobile bavighe. Na vane, bopale o bulongu bu buvighe, na bondumise va mbure eni djidji.” ");
INSERT INTO puu_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Nzambi amatunge pangini na Aberaame. Yilimbe yi pangini eni, urebe mwane. Mbana, Aberaame akerebe mwane andi Yisaake mu yilumbu yi munana. Yisake akerebe Sakobe wandi. Sakobe akerebe bandi baane, abavu dighumi na bifumbe bibedji bi bakaaghe betu. ");
INSERT INTO puu_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Bakaaghe betu bamavine mwane tadji owu Sosefe na bakemusumbise. Sosefe akenebeghu o bulongu bu Yisipete. Tumbe Nzambi amabe nandi. ");
INSERT INTO puu_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Akemughobule mu ditsoghe. Akemuveghe dyele na yese va wusu Farawu, kaghe Yisipete omamusole murumitsi Yisipete na ndaghu andi djotsu. ");
INSERT INTO puu_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Dungosu du nzale dukerughe o bulongu bu Yisipete na bu Kanane. Batu bamatsoghe pwele, ladibandu batadji betu basamamwédile bighudji. ");
INSERT INTO puu_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Sakobe anowulu yiri wudji bighudji o Yisipete, aketinde bane bandi wune, bakaaghe betu kumbu adji teghe. ");
INSERT INTO puu_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Adjimubedji, Sosefe akekedjabise na baane ba ngudji bandi. Na yilombi yandi yikedjabunu na Kaghe Farawu. ");
INSERT INTO puu_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Sosefe akenengile tadji andi Sakobe na yifumbe yandi yotsu. Djobotsu bamabe maghumi-dusambwali ma batu na batu baranu (75). ");
INSERT INTO puu_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Sakobe akewende o Yisipete. Akefwile wune, na bakaaghe betu wandi. ");
INSERT INTO puu_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Bakenebeghe bivisi bi bakaaghe bowu o musyengi Siseme noyétsighe o ngile adji Aberaame amasumbe na dufunu du mbongu na baane ba Emore tadji Siseme. ");
INSERT INTO puu_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Temu adji Nzambi amavangene na Aberaame djinobambene, mukute etu wumafune o Yisipete. ");
INSERT INTO puu_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Mba kaghe djighone adjisamadjabe Sosefe, akebonge yitsighe yi bukaghe bu Yisipete. ");
INSERT INTO puu_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Kaghe eni akedyonge bakaaghe betu, akebatsoyise o buvighe, tena amasile bane bowu ufu. ");
INSERT INTO puu_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Va temu eni, Moyise akeburu, mwane wumabe tinde ubwedji va wusu Nzambi. Amabungulu mu miweli miryeru va kane tadji andi. ");
INSERT INTO puu_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Anopalusu na biburu byandi, mwane mughetu wu Kaghe Farawu akemubonge na akemubungule nane mwane andi. ");
INSERT INTO puu_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Moyise akebungulu na dyele di bise Yisipete, mbana akebe dibaale dighobusu mu posulu na bisalu byandi. ");
INSERT INTO puu_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Anobe na maghumi-mana ma bilime (40), akeghane kake djuyélabe baane ba ngudji andi bandi, baYisrayele. ");
INSERT INTO puu_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Anolabe yiri mwise Yisipete yike wandi etsoyisi, akemuwamuse notoyise mwise Yisipete nomuboke. ");
INSERT INTO puu_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Amatase yiri baane ba ngudji bandi bowulu yiri Nzambi obaveghe dughobutsu mu djandi, tumbe basamadidjabe. ");
INSERT INTO puu_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Yilumbu ayimaduke, Moyise akebengune na batu babedji bamatoghaange. Anoronde ughabuse duvotsu va ghari owu, akebatsingule rye: “Bambatsi, dudji baane ba ngudji, dibandu yi dibokisini nane?” ");
INSERT INTO puu_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Omatsoyisaange mbatsi andi, akesindile Moyise novose: “Anyi atsyusole mube yivunde na nzonzi va ghari etu? ");
INSERT INTO puu_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Wirondi umboke menu wandi, nane wutsibokile mwise Yisipete masighe?” ");
INSERT INTO puu_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Mu posulu tsyeni, Moyise akerine, aketsane o bulongu bu Madyane. Akebure bane babedji wune. ");
INSERT INTO puu_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Maghumi-mana (40) ma bilime manovyoghe, o kumu dukange beli na mukongu wu Sinayi, yanze yi Nzambi yikelabene nandi o ghari mulutsu diningi adimalulaange. ");
INSERT INTO puu_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Moyise akesutu mune amalabile nane, tumbe ave amabambenine mu labe burange, akewulu dyufi di Fumu dimavosaange yi: ");
INSERT INTO puu_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","“Menu nyidji Nzambi baghulu baghu, Nzambi Aberaame, Nzambi Yisaake na Nzambi Sakobe.” Noregheme, Moyise asamarungule ughengile. ");
INSERT INTO puu_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Kaboghu Fumu akemuvaghe yi: “Vule bapondu baghu, mumba wudji va mbure djisyeme. ");
INSERT INTO puu_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Nyimalabe nane batu bami bétsoghusulu o bulongu bu Yisipete. Nyimawulu mighamu myowu, nyirughe muyibaghobule. Tsyéwendi, nyiwutindi o Yisipete.” ");
INSERT INTO puu_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Awuwu, Moyise, dibaale adi baane ba Yisrayele bamaghale novose yi: “Anyi atsyusole mube yivunde na nzonzi va ghari etu?” Nzambi amamutinde nane yivunde na mughobutsi wu mukute andi, va yinzime yi yanze ayimalabene nandi mu diningi. ");
INSERT INTO puu_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Moyise omapalise baane ba Yisrayele o bulongu bu Yisipete, novaghe bimaghe na bilimbe bipwele o bulongu bweni, o Mubu Wubenge, teno dukange. Mambu motsu mane, mamadughusu mu maghumi-mana (40) ma bilime. ");
INSERT INTO puu_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Moyise, dibaale adimatsingule mukute Yisrayele yi: “Va ghari mukute enu, Nzambi opalise mubiyitsi nane menu.” ");
INSERT INTO puu_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Ave mughungi wu Yisrayele wumabile o dukange, Moyise djandi amabe va ghari baghulu betu na yanze, ayimavosaange nandi o mukongu wu Sinayi. Akedile musamu Nzambi awiveyi monyu, mu tudjabise woni. ");
INSERT INTO puu_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Tumbe baghulu betu basamaronde umuwululu. Bakemuwengule na nzale ughabughe o Yisipete. ");
INSERT INTO puu_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Baketsingule Arone: “Tuvayili banyambi aboyenewendaange va wusu etu, mumbari tughedjabi aditsiruyile Moyise, otsitupalise o Yisipete.” ");
INSERT INTO puu_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Baketule kosi mu yibaghunu yi mwane ngombi na bakevaghule paghu va wusu andi. Bakevaghe mumengu mu yime ayi djobeni bamatule. ");
INSERT INTO puu_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Nzambi akebaliyili nzime, nobasile uyitse batsungi na bambwelili, nane disonunu mu mughande babiyitsi: “Mukute Yisrayele, tsiri ombu menu dumayivaghulili paghu tsyenu na bisaku, mu temu adjidumabile, mu maghumi-mana (40) ma bilime o dukange. ");
INSERT INTO puu_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Nesi, dumabeghe disambe di nyambi enu Moloke, na yibaghunu yi mbwelili nyambi enu Refane. Abine, bime abi dumatule mu biyitsaange. Ladibandu, nyudubeyile nane bise tsughu o vale, uvyoghe bulongu bu Babilone.” ");
INSERT INTO puu_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Mu kumu dukange, baghulu betu bamabe na ndaghu yibengunu. Moyise amadjirunge nane Nzambi amamusindiyile bwé akedjivaghe, mu yibaghunu ayi amalabe. ");
INSERT INTO puu_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Baghulu betu bamadile ndaghu eni. Mu dirume di Sosye, bakedjibeghe o bulongu bu batu abe Nzambi amasanze va wusu owu. Djikebe vane tena temu kaghe Davide. ");
INSERT INTO puu_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Djandi wughu akedile yese va wusu Nzambi. Akevonde musughe wurunge ndaghu djisyeme dji Nzambi Sakobe. ");
INSERT INTO puu_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Tumbe mwane andi Salemu amamurungile djoni. ");
INSERT INTO puu_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Yotsu yine Nzambi-Pungu, aghétsani mu mandaghu amarungu na makake ma batu. Mubiyitsi evosi yi: ");
INSERT INTO puu_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","“Divose Fumu Nzambi rye: Djulu yitsighe yi bukaghe bwami, Butambe yisunzulu yi makulu mami. Munongu ndaghu yi durungule utungile? Vo mbure yi djurungule ube yivumunu yami? ");
INSERT INTO puu_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Byotsu bine, tsiri mebeni nyimabisunde na makake mami?” ");
INSERT INTO puu_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Dune kande, mirime myenu mighale na matudji menu madibe va wusu mbile Nzambi! Dughededili Yinyuni Yisyeme! Dudji nane bakaaghe benu. ");
INSERT INTO puu_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Mubiyitsi awu batadji benu basamakwane anyi? Bamaboke abamabighe durughulu du Mutu awusungeme. Mutu eni wune, dumamusumbise nomuboke. ");
INSERT INTO puu_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Byanze bimaduveghe mughaghe Nzambi, tumbe dumabuse uwughobise!» ");
INSERT INTO puu_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Ave bamawululu posulu tsyeni, fundu dji banzonzi djikenyoyile Yityene. Na kabu, bakevaghaange duweriti na minu mowu. ");
INSERT INTO puu_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Tumbe Yityene, abasilange na Yinyuni Yisyeme, akeghengile o djulu, akelabe kembu Nzambi na Djesu diteli va mabaale mandi. ");
INSERT INTO puu_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Akevaghe yi: «Wulwanu, nyilabi djulu djidibughe na Mwane mutu diteli va mabaale ma Nzambi!» ");
INSERT INTO puu_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Kaboghu, bakebwaghe mughamu wuneni nodibighe matudji. Bakeyémuvike djowu botsu. ");
INSERT INTO puu_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Bakemupalise o musyengi nomutinde mamani bakemuboke. Bambedji bamasile bidwaru byowu na mwa mwane dibaale, wumanengulungu Sole. ");
INSERT INTO puu_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Ave bamamutindilaange mamani, Yityene akesambilaange yi: «Fumu Djesu, wake yinyuni yami!» ");
INSERT INTO puu_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Mba akekuteme noghamughe na mangolu mandi motsu: «Fumu, batandi dibi dyédidi!» Yikemani, akefu. ");
INSERT INTO puu_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Mba Sole amarondaange dufu du Yityene. Mune yilumbu akevyosulile ukwane dibundu di Serusaleme. Badukitsi botsu, uvenguse bilumbi, bakepanzighe mu byari byotsu bi Sudé na Samari. ");
INSERT INTO puu_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Batu abamaghobisaange Nzambi baketswighe Yityene na bakemulile tinde na munyongu. ");
INSERT INTO puu_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Sole, djandi, akevataange upanze dibundu. Amawendaange ndaghu na ndaghu, akeghangaange bango yitu, na baghetu na babaale, akebabwaghaange o tsughu. ");
INSERT INTO puu_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Bango yitu abamatsyamughe bamanangaange bulongu, noyenelonzaange musamu wuboti. ");
INSERT INTO puu_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Filipe akewende o musyengi Samari, akebasamunine Kirisete. ");
INSERT INTO puu_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Mighungi na mighungi va mosi mimawulu posulu tsi Filipe, mumba mimawulu nolabe bilimbe bi bimaghe abi amavaghaange. ");
INSERT INTO puu_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Na mighamu mineni, binyuni bibive bipwele bimapalaange mu batu. Bibomfi bipwele na bitsondu bimabelusu. ");
INSERT INTO puu_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Kaboghu nzangu djikebe djineni mu musyengi eni. ");
INSERT INTO puu_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Mutu winengulu Simu amaba vane kale o musyengi eni, amavandaange. Mavande mandi mamasutusungu mughungi wotsu wu Samari. Amakelabange nderi adji muneni. ");
INSERT INTO puu_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Mba botsu, ubongile o bangebi teno bivunde, bamamughobisaange pwele. Bamavosaange yi: «Mutu éwuwu mangolu ma Nzambi, amenengulu “Mboboghe”.» ");
INSERT INTO puu_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Bamamughobisaange pwele, mumba mbé amatsinge nobasutusu na mavande mandi. ");
INSERT INTO puu_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Tumbe banosinge musamu wuboti awu Filipe amasamunaange, mu dyambu di Bukaghe bu Nzambi na mu dine di Djesu Kirisete, baghetu na babaale bakebatusu. ");
INSERT INTO puu_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Djabeni Simu akesinge Djesu na akebatusu. Mune amalabilaange bimaghe bineni na bilimbe abi Filipe amavaghaange, amasutu na asamamwékakenange nandi. ");
INSERT INTO puu_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Bilumbi o Serusaleme bakewulu yi bise Samari bamadile musamu Nzambi na nzangu. Adine bamabatindile Pyere na San. ");
INSERT INTO puu_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Banotole o Samari, bakesambilile mu djowu abamasinge Nzambi, mumbari bakedile Yinyuni Yisyeme. ");
INSERT INTO puu_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Ne vane babatusulungu mu dine di Fumu Djesu, Yinyuni Yisyeme mbé yisekasundughe ne mu wumosi va ghari owu. ");
INSERT INTO puu_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Pyere na San bakebasakighe makake na bakedile Yinyuni Yisyeme. ");
INSERT INTO puu_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Simu anolabe yi Yinyuni Yisyeme yiveghu ombu bango yitu ave bilumbi bebasakiyili makake akeronde ubaveghe badoli. ");
INSERT INTO puu_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","Amabavaghe yi: «Peyanu ngudu, yi abe nyusakighaange makake bakedilaange Yinyuni Yisyeme.» ");
INSERT INTO puu_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Tumbe Pyere akemuwaghule yi: «Badoli baghu babungini na ndebeni, mumba wutsitase bwé peghulu dji Nzambi djisumbu na mbongu! ");
INSERT INTO puu_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Wughane dikabu vo musughe mu yisalu yéyiyi, mumba murime aghu wughaa wusungeme va wusu Nzambi. ");
INSERT INTO puu_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Vughule ditase dyaghu dibive na lende Fumu, lake pa dyurungule uvaghu, akewutande mu ditase dyédine. ");
INSERT INTO puu_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Mumba nyilabi na ngenze, yi wudji wubase na mele mabive mba wune mutsanu wubi.» ");
INSERT INTO puu_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Kaboghu Simu akevaghe Pyere na San yi: «Djenubeni lendanu Fumu, yiri motsu dutsivose makétuyile.» ");
INSERT INTO puu_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Yikebémani ughabuse bumbedji nosamune Musamu wu Fumu, bilumbi bibedji bakeghabughe o Serusaleme. Mu nzile bakeyenelonzaange Musamu Wuboti mu mimbu mapwele ma Samari. ");
INSERT INTO puu_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Yanze yi Fumu yikevaghe Filipe yiri: «Releme, wende o yari yibande, mu nzile adjirambuyili o Serusaleme teno musyengi Ghase. Nzile adjivu mududu, djighémwévyoghulu na batu.» ");
INSERT INTO puu_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Filipe akereleme, akewende na maswasu. Mu nzile, akebengune na muvangu wu Yityopi, yidjeti yineni yimakelisaange yilundulu yi Kandase, kaghe mughetu dji Yityopi. Djandi amarughe o Serusaleme mu yiyitse Nzambi, ");
INSERT INTO puu_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","na yikewughabughe amaghabughaange o dimbu dyandi. Amabe atsane va djulu dikalu dyandi dimayenedutungu na kabele. Na vane, amarangaange yibuku yi musamu wu mubiyitsi Yisayi. ");
INSERT INTO puu_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Yinyuni Yisyeme yiketsingule Filipe bwé: «Bambene na dikalu dyédine.» ");
INSERT INTO puu_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Filipe amabambene mbangu-mbangu na akewulu yidjeti yi Yityopi, yimarangaange dibuku di mubiyitsi Yisayi na dyufi dineni. Akemuwivule yi: «Wighulu na bureti amewirangi?» ");
INSERT INTO puu_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Yidjeti yeni akemuwaghule yiri: «Tsyeni nyurungulile uwulu, ta vagha mutu wupindiyile?» Vane-vane, amavaghe Filipe akenangeme notsane va mughule andi. ");
INSERT INTO puu_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Yibuku yi Bisonu ayi amarangaange ayiyi: «Amaba nane yindombu ayi bébeyi o uboke, Nane mwane yindombu awibi dibabe va wusu mufuyitsi, asamadibule munu andi. ");
INSERT INTO puu_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Amalenzu mba musughe andi wumadesu. Kule andi, anyi odjirangemine? Mumba batsimutabule monyu va butambe.» ");
INSERT INTO puu_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Yidjeti akewivule Filipe yi: «Kokolu, nzinguli anyi mubiyitsi eranguni nane, djabeni ekevosile vo mutu susu?» ");
INSERT INTO puu_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Filipe akemuwaghule, akemutsingule musamu wuboti wu Djesu, ubandile vane dibandu di Yibuku yeni yi Bisonu. ");
INSERT INTO puu_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Bakebwele wuwende na baketole va mbure djimabe mambe. Yidjeti akevaghe yi: «Labati mudjambe! Kaboghu wurungule umbatise, mbeyé?»  ");
INSERT INTO puu_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Filipe akemuvaghe yi: «Payi wune tinde yitu, wurungule ubatusu.» Yidjeti akewaghule yi: «Yine, nine yitu mu Djesu Kirisete, Mwane Nzambi.» ");
INSERT INTO puu_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Yidjeti akesikighe dikalu, bakesundughe djone Filipe mu mudjambe. Na Filipe akemubatise. ");
INSERT INTO puu_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Banosabughe, Yinyuni yi Fumu yiketsyemuse Filipe. Yidjeti asamamwémulabe, tumbe akeduke nzile andi na nzangu. ");
INSERT INTO puu_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Filipe akepalile o dimbu di Asote, mba akevyoghe misyengi na misyengi, noyenesamunaange Musamu Wuboti mbure tsyotsu tena ave amatole o yisyeni yi Sesaré. ");
INSERT INTO puu_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Mu temu eni, Sole amakwanaange pwele na amaghanaange uboke badukitsi ba Fumu. Amayérasene yivunde yi bavaghulitsi ba paghu, ");
INSERT INTO puu_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","nomuvonde mighande mi musughe wuwendile o mandaghu ma tsambu ma baSwife mu musyengi Damase. Na payi atsirasene babaale vo baghetu abeduki nzile Djesu, obaghange nobabeghe o Serusaleme. ");
INSERT INTO puu_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Abilaange mu nzile Damase, akebambene beli na musyengi. Sundile, yidjalale yinene ayi masundughe o djulu yikemuvedemine. ");
INSERT INTO puu_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Akeyideme vatsi, na akewulu dyufi dimavosile rye: «Sole, Sole, dibandu yi winkwanini?» ");
INSERT INTO puu_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Akewivule: «Nde la nyi, Fumu?» Na dyufi dimamuwawule rye: «Menu la Djesu, awu wikwani. ");
INSERT INTO puu_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Tumbe releme, kote o musyengi, aghune bowutsingule adiwudusu.» ");
INSERT INTO puu_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Bambatsi ba mulingu ba Sole bamasikeme, bamaghambu na dyambu dyuvose. Bamawulu dyufi, tumbe basamalabe mutu. ");
INSERT INTO puu_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Sole amareleme na amadibule misu, tumbe asamamwélabaange ne yime. Bamamughange mu dikake mu mubeghe o Damase. ");
INSERT INTO puu_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Mu bilumbu biryeru, asamarungule ulabe na amatsane nane, vagha wudji nonu. ");
INSERT INTO puu_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Wumabe o Damase mudukitsi wumosi dine dyandi Nanyase. Fumu amalabene nandi mu yiryaryamu na akemunengile: «Nanyase!» Akewaghule: «Me djanduwu, Fumu.» ");
INSERT INTO puu_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Fumu akemutsingule rye: «Lenge nowende mu nzile adjinengulu “Nzile Djisungeme”, o ndaghu Sudase. Aghune, wuyéwivule dibaale, mwise Tarese oyinengulu Sole. Usambile esambili. ");
INSERT INTO puu_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Mu yiryaryamu, atsilabe dibaale dinengulu Nanyase, atsikotaange nomusakighe makake mumba akebwélabe.» ");
INSERT INTO puu_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Nanyase amawaghule rye: «Fumu, batu bapwele bamaposile mu dibaale dyeni na nyidjabi dibi adi amavaghe mu bango yitu o Serusaleme. ");
INSERT INTO puu_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Na atsirughe wunu na musughe awu amasingusulu na bivunde bi bavaghulitsi ba paghu, muyighange botsu abeyitsi dine dyaghu.» ");
INSERT INTO puu_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Tumbe Fumu aketsingule Nanyase: «Wende, mumbari nyimasole dibaale dyédine, mube musalitsi ami. Na djandi odjabise dine dyami mu malongu masusu, na bakaghe bowu, na mu mukute Yisrayele. ");
INSERT INTO puu_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Nyumulase mebeni maghughe motsu ame olabe mu dyambu dyami.» ");
INSERT INTO puu_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Yike Nanyase amawende. Akekote o ghari ndaghu, akemusakighe makake, na akemutsingule rye: «Sole, mwane tadji ami, Fumu Djesu otsilabene naghu mu nzile ave wutsiruyilaange, atsinzindighe ombu aghu. Motsu mane, mumba wukebwélabe na wukebasu na Yinyuni Yisyeme.» ");
INSERT INTO puu_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Vane-vane, bime bibaghunu na maghaghele bimabondughe mu misu ma Sole na amamwélabe. Amareleme na amabatusu. ");
INSERT INTO puu_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Anodji, mangolu mandi, mamamughabuyile. Sole amatsane mwa bilumbu na badukitsi abamabe o Damase. ");
INSERT INTO puu_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Vane-vane, Sole amabande ulonze mu mandaghu ma tsambu ma baSwife, yiri Djesu adji mwane Nzambi. ");
INSERT INTO puu_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Botsu abamamuwulungu bamakambulu na bamawivulaange: «Tsi djandi otsikwanaange o Serusaleme botsu abamarangunaange dine di Djesu? Na agharughe wunu mu yibaghange nobabeghe va wusu bivunde bi bavaghulitsi ba paghu?» ");
INSERT INTO puu_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Sole mu posulu tsyandi, amakewarisaange kale yilumbu. Tumbe baSwife ba Damase basamamwébe na dyukale mumbari djandi amabalasaange na kengili yiri Djesu la Kirisete. ");
INSERT INTO puu_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Mwa pesu temu, baSwife bamaghane kake muboke Sole, ");
INSERT INTO puu_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","tumbe amalubusu mu fundu owu. Makotulu motsu ma musyengi mamakelusungu nyangu na mukolu, mu mubokise. ");
INSERT INTO puu_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Kaboghu badukitsi ba Sole bamamubeghe mukolu mu muvyose disimu dimosi di yivaghe yi musyengi, na bamamusunduse mu ponzi. ");
INSERT INTO puu_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Ave Sole amatolile o Serusaleme, djandi mbé aronde ufubene mu dighuki di badukitsi. Tumbe djobotsu bamabe na ghome andi, mumbari vasamabe ne wumosi wumatasaange yiri ngenze Sole amakalughe mudukitsi. ");
INSERT INTO puu_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Adine Barenabase amamubongile nandi, akemubeghe ombu bilumbi. Barenabase akebwébatsingule nane mu nzile, Sole amalabinine na Fumu, na nane Fumu amavosile nandi. Barenabase amabwese ubatsingule nane Sole o musyengi Damase, amasamunine na musighe mu dine di Djesu. ");
INSERT INTO puu_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Yike Sole amayenewendaange noghabughe nowu o Serusaleme, na amasamunaange na musighe mu dine di Fumu. ");
INSERT INTO puu_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Djandi amavosaange notsunde na baSwife abamavosaange mbembu baNgereke, tumbe djowu bamarondaange umubokise. ");
INSERT INTO puu_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Baane ba tadji bandi banodidjabe, bamabeghe Sole o yisyeni yi Sesaré, na bakemuwendise o yisyeni yi Tarese. ");
INSERT INTO puu_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Dibundu mu musyengi wotsu wu Sudé, wu Ngalile na wu Samari, dimabe mu duvotsu. Dimaneghaange mu yitu, dimabéghaange monyu mu dighobe di Fumu na dimafunaange na dwamusu du Yinyuni Yisyeme. ");
INSERT INTO puu_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Pyere wandi, amayenevyoyilangaange mbure tsyotsu, akesundughe ombu bango yitu abamatsanaange o musyengi Lide. ");
INSERT INTO puu_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Aghune, akerasene dibaale dinengulu Ené dimabe disileme va ditoghu mu yinane yi bilime, mumbari amabe yimbolutu. ");
INSERT INTO puu_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Yike Pyere akemutsingule: «Ené, Djesu Kirisete eghubelusi! Releme, kunze ditoghu dyaghu.» Sundile Ené akereleme. ");
INSERT INTO puu_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Ave bamamulabile, batu botsu bamatsanaange o musyengi Lide na kumu Sarone, bamasinge Fumu. ");
INSERT INTO puu_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Wumabe o musyengi Sopé, mudukitsi mughetu wumanengulu Tabite, vo «Dorkase» o mbembu Ngereke, diwendili bwé «Tsyesi». Amavyosaange temu andi novaghaange bisalu biboti nowamuse bidjaghe. ");
INSERT INTO puu_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Mu temu eni, amadimbene ubele na akefu. Dunyuru dunobwitsu, dumasunzu o yibuku yi ndaghu ayi djulu. ");
INSERT INTO puu_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Badukitsi abamabe o musyengi Sopé, badjabilaange yiri Pyere amabe o musyengi Lide, awuvu bébeli na Sopé, Bakemutindile babaale babedji muyémulende: «Wuyabwétsinge, lenge norughe ombu ghetu.» ");
INSERT INTO puu_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Pyere amawende nowu. Anotole, bamamubeghe o yibuku yi ndaghu ayi djulu. Bakwili botsu bamabambene nandi nolile. Bamamulase bikutu na bilinge, abi Dorkase amavaghaange ave amabilaange monyu. ");
INSERT INTO puu_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Pyere akepalise batu botsu, akekuteme na akesambile. Mba amaghelughe o yari yi mvumbi novose rye: «Tabite, releme!» Lake Tabite akedibule misu, anolabe Pyere, akesimbughe na aketsane. ");
INSERT INTO puu_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Pyere amamuveghe dikake na akemuwamuse ureleme. Amanengile bango yitu na bakwili, na amabalase Tabite monyu. ");
INSERT INTO puu_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Dimadjabunu mu musyengi wotsu wu Sopé na bapwele bamavayile Fumu yitu. ");
INSERT INTO puu_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","O musyengi eni, Pyere amatsane yitsingu yineni ombu Ngele-Bibande, djinengulu Simu. ");
INSERT INTO puu_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","O Sesaré wumabe dibaale dimanengulungu Korneye. Amabe yivunde yi kame baghore mu dibuli adimanengulungu «Mughungi baghore ba Yitali.» ");
INSERT INTO puu_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Amabe na dinonge na amadumaange Nzambi na kane andi djotsu. Amawamusaange bidjaghe bi baSwife na amasambilaange Nzambi temu tsyotsu. ");
INSERT INTO puu_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Mwa yilumbu, va murekemunu wisi va tsisighe, beli na maweru maryeru, amadile yiryaryamu. Na tsiyiri akelabe yanze yi Nzambi ukote ombu wandi na akemunengile yi: «Korneye!» ");
INSERT INTO puu_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Akeghengile na dunzyenzi na akewaghule rye: «Fumu, dyambu yi?» Yanze nomuwaghule yi: «Nzambi atsironde tsambu tsyaghu na dwamusu adu wiveyi bidjaghe, na eghurangemini. ");
INSERT INTO puu_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Tumbe, sindighe batu o musyengi Sopé, bakénengile Simu awu bénengili Pyere. ");
INSERT INTO puu_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Etsani ombu Simu Ngele-Bibande, ndaghu andi djidji va mughule mubu.» ");
INSERT INTO puu_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Yike yanze ayimavose nandi yiwendi, Korneye akenengile basatsi bandi babedji na ghore mosi djimamusalilaange, adjimabe mutu wunonge na Nzambi. ");
INSERT INTO puu_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Akebatsingule motsu amamavyoghe mba akebatinde o Sopé. ");
INSERT INTO puu_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Yilumbu ayimaduke, yotsu yine mbé baki mu nzile ave bamabambeninaange na musyengi Sopé, Pyere akemate o djulu ndaghu mu yésambile, va diweru di mwangulu. ");
INSERT INTO puu_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Akewulu nzale, mbé aronde udji. Temu adji bamamulambilaange bighudji, akelabe yiryaryamu. ");
INSERT INTO puu_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Amalabe djulu djimadibughe, na yime yimasundughaange. Yime yeni yimabe nane yibuku yi tsande djineni, djighangu mu kodu tsyotsu tsi djine, adjimasundughe tena vatsi. ");
INSERT INTO puu_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Mu tsande eni, mumabe minongu myotsu mi bibulu abivu na biname bina, minongu myotsu mi bilandile bi butambe, na minongu myotsu mi batsoli. ");
INSERT INTO puu_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Akewulu dyufi dimamuvosile yiri: «Pyere, releme! Boke bibulu byébibi na djange!» ");
INSERT INTO puu_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Tumbe Pyere akewake: «Tsatsabi! Fumu ami, nyisekadjangaange abivu yingitsi vo binzoruru.» ");
INSERT INTO puu_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Dyufi dikemwéghulunu nandi adi mubedji, na dikevose yiri: «Abi Nzambi amalyomise, ndedju wuyabilabe nzoruru.» ");
INSERT INTO puu_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Dyoni dimalabene kumbu yiryeru, mba yime yeni yikematusu o djulu. ");
INSERT INTO puu_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Pyere amakewivulaange divindughulu di yiryaryamu ayi abenolabe. Vane-vane, batu abe Korneye amatinde, banomane uwivule mu djabe ave ndaghu Simu Ngele-Bibande djivu, baketole va dikotulu. ");
INSERT INTO puu_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Bamadukise na bamawivule rye: «Avave Simu adjinengulu Pyere etsanini?» ");
INSERT INTO puu_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Pyere wukelule mbé akikelule yiryaryamu yandi, ave Yinyuni yimamutsingulile yiri: «Wulu, vadji batu baryeru béwurombi. ");
INSERT INTO puu_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Releme, vindeme na wende nowu, wuyatsikedene, mumba menu nyibasindiyi.» ");
INSERT INTO puu_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Pyere akevindeme ombu batu beni nobatsingule yi: «Nyidjandughu, menu dirombi. Dibandu yi dutsiruyile?» ");
INSERT INTO puu_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Bakewaghule yi: «Tutsitindu na Korneye, yivunde yi baghore. Dibaale disungeme, didumi Nzambi, na baSwife botsu bémurondi. Yanze yi Nzambi yimayimuveghe dilongi dyédidi: “Nengile Pyere o ndaghu aghu na wulu motsu ame owutsingule.”» ");
INSERT INTO puu_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Pyere akebakotise o ghari ndaghu na akebaveghe bitsighe byuvyosile mukolu. Va kedi dji yilumbu ayimadukaange, Pyere amasimbughe na amawende nowu. Baane ba tadji bamosi ba Sopé bamawende nandi. ");
INSERT INTO puu_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Djowu bamatole o musyengi Sesaré mu yilumbu ayi mubedji. Korneye amabavivaange na biburu byandi na bambatsi bandi ba murime, abe amanengile. ");
INSERT INTO puu_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Ave Pyere amatolile, Korneye akémubengusunu, amakébwaghe va makulu mandi mu muyitse. ");
INSERT INTO puu_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Tumbe Pyere akemurelighe nomutsingule yi: «Releme! Mumbari menu nyidji mutu nane ndedju.» ");
INSERT INTO puu_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Va djulu vane, amayenevosaange na Korneye. Anokote o ghari ndaghu, amarasunu batu bapwele baghukeme. ");
INSERT INTO puu_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Akebatsingule rye: «Dwidjabi yi muSwife aghane musughe wube mbatsi mweni, vo mu ukote o ndaghu andi. Tumbe Nzambi atsindonze yi, vagha mutu awu menu nyurungule wulabe yiri adji nzoruru vo agha awelimine ufwamu. ");
INSERT INTO puu_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Ladibandu, ave dutsitindile batu o wuyindengile, ngalabe diweru mu urughe. Kaboghu, nyirondi udjabe adi dutsindengilile.» ");
INSERT INTO puu_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Korneye akewaghule yiri: «Vake bilumbu bina, va temu dji maweru maryeru ma tsisighe, nyimasambilaange. Suka, mutu na bikutu bikademi akepale va wusu ami. ");
INSERT INTO puu_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Akenzingule: “Korneye, dusambu dwaghu dumadughusu, na Nzambi atsirangemine dwamusu du maboti amewivayili bidjaghe. ");
INSERT INTO puu_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Kaboghu sindighe mutu o Sopé mu uyenengile Simu awu bénengili Pyere. Etsani ombu Simu mosi, Ngele-Bibande adjitsani va mughule mubu.” ");
INSERT INTO puu_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Nzilenge notinde batu mu yiwulande na wutsisinge urughe. Vave, tudji djetu botsu va wusu Nzambi, mughulu motsu ame Fumu atsiwurume mu yitutsingule.» ");
INSERT INTO puu_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Anane Pyere amabongile mbembu novose yiri: «Mba nyimawulu bwé Nzambi aghane dupasu du batu. ");
INSERT INTO puu_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Mu malongu motsu, mutu awidumi Nzambi na avu asungeme, awune awelimine usingu nandi. ");
INSERT INTO puu_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Amatindile bise Yisrayele mbembu andi, mu yitusamune Musamu Wuboti wu duvotsu adutumadile mu Djesu Kirisete, odjivu Fumu batu botsu. ");
INSERT INTO puu_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Dwidjabi adimarele uvyoghe o Ngalile, mba dikebwélabene mu Sudé djotsu. Motsu mane mamavyoyile, yike San emani usamune musamu wu dubatusu. ");
INSERT INTO puu_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Dwidjabi nane Nzambi amasolile Djesu mwise Nasarete, nomuveghe mangolu ma Yinyuni Yisyeme. Dwidjabi wandi nane Djesu amanangile bulongu, noyenevaghaange diboti noghobulaange botsu abamabe baghangu na dyabu, mumba Nzambi amabe nandi. ");
INSERT INTO puu_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Mba djetu, tudji bambedji ba motsu ame amavaghe o bulongu bu baSwife, teno Serusaleme. Djandi awu bamabokise, nomulelighe va kurusu. ");
INSERT INTO puu_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Tumbe Nzambi, amamurambuse o dufu yilumbu ayimuryeru, na amavaghe yi akelabene. ");
INSERT INTO puu_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Asamalabene na mikute myotsu, tumbe yike na djetu abe Nzambi amasole vane dibandu mube bambedji. Anorambughe, tumadji nonu nandi. ");
INSERT INTO puu_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Amaturume ulonze Musamu Wuboti, ombu mukute na utsiyise yi, adji mutu awu Nzambi amabyatse, mu ufundise abavu monyu na abafu. ");
INSERT INTO puu_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Babiyitsi botsu bamavose mu djandi, botsu abemuvayili yitu, bodile dutandu du mabi dibandu djandi.» ");
INSERT INTO puu_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Pyere uvose mbé akivose, Yinyuni Yisyeme yikesundughe mu botsu abamawulungu musamu Nzambi. ");
INSERT INTO puu_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Bango yitu abamabe barebu, abamarughe na Pyere, bakekambulu mu ulabe yi, peghulu Yinyuni Yisyeme djimaghabulu djowu botsu abasamabe baSwife. ");
INSERT INTO puu_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Ngenze, bango yitu abarebu, bamabawulungu uvose mu mambembu masusu noyitse Nzambi. Kaboghu Pyere akevose yi: ");
INSERT INTO puu_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","«Tughorungule ughandise batu bébabe dubatusu du mambe, badililaange Yinyuni Yisyeme nane djetu!» ");
INSERT INTO puu_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Na akeveghe musughe ubabatise mu dine di Djesu Kirisete. Kaboghu bakemuwivule aketsane mwa bilumbu nowu. ");
INSERT INTO puu_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Bilumbi na baane ba tadji abamabe o yinange yi Sudé, bakewulu bwendiri bise malongu wandi bamadile musamu Nzambi. ");
INSERT INTO puu_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Ave Pyere amamatile o Serusaleme, bango yitu abarebu bamamutsundise ");
INSERT INTO puu_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","novose rye: «Ndedju wutsikote ombu batu abagha batabulu, na wutsidji va mosi nowu!» ");
INSERT INTO puu_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Yike Pyere akebatsingule na musighe, mambu motsu, ubongile o dibandu teno disukusulu, akebatsingule rye: ");
INSERT INTO puu_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","«Menu, nyimabe o musyengi Sopé na nyimasambililaange, nganingelene na ngadile yiryaryamu. Lake ngalabe yime nane yibuku yi tsande djineni, djighangu mu kodu tsyotsu tsi djine, djimasundughaange o djulu na djikerughe tena va wusu ami. ");
INSERT INTO puu_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Nyimadjitsune na burange na nyimalabe bibulu abivu na biname bina, minongu myotsu mi bibulu bi musiru, minongu myotsu mi bilandile bi butambe na batsoli. ");
INSERT INTO puu_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Mba nyimawulu dyufi dimapaghe yi: “Pyere, releme! Boke bibulu byébibi na djange!” ");
INSERT INTO puu_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Tumbe nyimawaghule yi: “Tsatsabi! Fumu ami, mumbari nyiburulu, nyisekadjangaange bibabi vo abivu yingitsi. Mumba byoni, bighorungule ukote o munu ami.” ");
INSERT INTO puu_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Mu dyoni, mbembu eni djimawulunu o djulu, djimabwéposile adi mubedji yi: “Abi Nzambi amalyomise, ndedju wuyabilabe nzoruru.” ");
INSERT INTO puu_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Dyoni dimalabene kumbu yiryeru, mba byotsu bikeghabughe o djulu.» ");
INSERT INTO puu_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Pyere akebwese uvose: «Vane-vane, babaale baryeru bamarughesene o musyengi Sesaré mu yimbonge, bamatole va wusu ndaghu adjitumabe. ");
INSERT INTO puu_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Yike, Yinyuni yimanzingule bwé wende nowu, wuyabe némwapesu na keri. Na baane ba tadji ba syamunu ababe, bamayinkelise, na tumakote djetu botsu ombu dibaale dyédidi. ");
INSERT INTO puu_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Djandi amatutsingule nane amalabile yanze o ghari ndaghu andi, ayi yimabe vane, na yimamutsingule yiri: “Sindighe mutu o musyengi Sopé, akéwunengilile Simu awu bénengili Pyere. ");
INSERT INTO puu_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Djandi oyiwutsingule musamu, awu ndedju na ndaghu aghu djotsu, dughobululu.” ");
INSERT INTO puu_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Ave nyimabandile uvose, Yinyuni Yisyeme yikesundughe mu djowu botsu, nane yimasunduyile mu djetu va dibandu. ");
INSERT INTO puu_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Yike nyimarangemine mbembu Fumu adjimavosaange yi: “San amabatise mu mambe, tumbe djenu, dubatusu mu Yinyuni Yisyeme.” ");
INSERT INTO puu_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Nzambi amabaveghe yisaku yine yimosi, nane amatuveyile djetu wandi, ave tumasunzile yitu yetu mu Fumu Djesu Kirisete. Tumbe anyi menu mbé nyimabe, murungule ughaghene na Nzambi?» ");
INSERT INTO puu_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Banowulu yilombi yeni, bango yitu abamabe barebu, bakevole «swii», bakesigheme. Djowu botsu bakeyitse Nzambi novose rye: «Kaboghu dingenze, Nzambi amaveghe bise malongu wandi abagha barebu, yese yukalughe mutsanu wubive, mu dile monyu mutubu na mutubu.» ");
INSERT INTO puu_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Yityene anoboku, bango yitu bamapanzighe dibandu dikwane, adimaduke dufu dwandi. Na djobotsu bamawende yari na yari: abane o yinange Fenisi, bamosi o ningi dji Sipere na o musyengi Antyose. Tumbe bamayenesamunaange musamu Nzambi, yike ombu djowu abamabe baSwife. ");
INSERT INTO puu_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Yike va ghari owu, vamabe bise Sipere na Sirene, djowu bakerughe o musyengi Antyose. Bamayenesamunaange Musamu Wuboti wu Fumu Djesu ombu djowu abamavosaange mbembu baNgereke. ");
INSERT INTO puu_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Mangolu ma Fumu mamabe nowu, adine bapwele bamasinge Fumu Djesu na bamakalughe mutsanu owu. ");
INSERT INTO puu_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Bivunde bi dibundu di Serusaleme banowulu yilumbi yeni, baketinde Barenabase o musyengi Antyose. ");
INSERT INTO puu_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Anotole wune, ave amalabile motsu ame yese yi Nzambi yimadughusu, amabase na nzangu djineni. Na vane, amawarise bango yitu botsu bakesunze yitu yowu mu Fumu, na bakébwéghabughe manzinzime. ");
INSERT INTO puu_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Barenabase amabangaange dibaale adisungeme, dibase na Yinyuni Yisyeme, divu na yitu yandi yotsu mu Nzambi. Yinombu yineni yimasinge Fumu Djesu mu monyu owu. ");
INSERT INTO puu_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Mba Barenabase amawende o musyengi Tarese oyérombe Sole. ");
INSERT INTO puu_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Ave amamulabile, akemubeghe o musyengi Antyose. Djobotsu bakevyose yilime yifwimbe o dibundu, nolonzaange batu bapwele yitu mu Nzambi. Aghune dibundu di Antyose, badukitsi bamanengululu aditeghe: «Bakereti». ");
INSERT INTO puu_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Mune temu eni, babiyitsi bamadusughe musyengi Serusaleme mu wende o musyengi Antyose. ");
INSERT INTO puu_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Mubiyitsi wumosi wumanengulu Aghabise, abasu na Yinyuni Yisyeme, amabighe bwé nzale djineni djube mu butambe bwotsu. Yike nzale eni djimalabene va temu adji Kolode amabile kaghe. ");
INSERT INTO puu_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Badukitsi bamakape disite, bwé kale mutu mbé oveghaange nane odilile na mangolu mandi, mu wamuse baane ba tadji abamatsanaange o yinange yi Sudé. ");
INSERT INTO puu_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Anane bamavayile. Baketinde Barenabase djone Sole bakebeghe dwamusu dweni, ombu bivunde bi dibundu di Sudé. ");
INSERT INTO puu_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Va temu eni, kaghe Yirode akeghangise mwa dikabu di batu ba dibundu mu bakwane. ");
INSERT INTO puu_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Na didjenge akebokise Sake, mwane ngudji San. ");
INSERT INTO puu_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Anolabe yi baSwife bamadironde, akeghangise Pyere va temu mumengu wu bapembi abagha dufunusu. ");
INSERT INTO puu_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Yirode akemughaange nomusunze o tsughu. Akesindighe binombu bine bi baghore mu mukelisaange. Kadi yinombu yimabe ghore djine. Amabe na ditase dyumufundise, va ghari batu yike mumengu Pake wivyoyi. ");
INSERT INTO puu_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Pyere abilange o tsughu, bise dibundu bamasambile Nzambi na yikanene mu djandi. ");
INSERT INTO puu_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Yirode amabe na ditase dyumubeghe va wusu banzonzi. Tumbe mune mukolu, Pyere amabe atungu pange bedji, na amabe yilu va ghari ghore bedji. Baghore bamosi, bamamoghaange va wusu mune ndaghu tsughu. ");
INSERT INTO puu_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Sundile, yanze yi Fumu yikekote mba tsughu djotsu djikekademe na yidjalale. Yanze yikekungise Pyere nomudimbe mbate o maghetu, mba akemutsingule yi: «Lenge noreleme!» Na bapange baketudughe mu makake mandi. ");
INSERT INTO puu_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Yanze yike muvaghe yiri: «Tunge beleti aghu na dware bapondu baghu.» Akedivaghe. Yanze yikemwémuvaghe yi: «Dware yikutu yaghu na nduki.» ");
INSERT INTO puu_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Pyere akeduke yanze na akepale o tsughu. Asamadjabaange yiri adi yanze amavaghaange dingenze, amatasaange yiri yiryaryamu. ");
INSERT INTO puu_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Bakevyoghe yinombu yi baghore ayiteghe, bakevyoghe ayi mubedji, baketole va yabutsu yi madilu ayi mune ndaghu awumusitu. Yabutsu yeni yikedibughe pinze va wusu owu na bakepale. Banosupughe mu nzile, yanze yikekakene nandi. ");
INSERT INTO puu_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Kaboghu Pyere akewulu adimavyoghaange, na akekévosile yi: «Mba nyimadjabe yi dingenze: Fumu atsitinde yanze yandi, na djandi, atsinkaghule va makake ma Yirode, na ame bivunde bi baSwife mbé baronde undase.» ");
INSERT INTO puu_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Ave amadiwululu nane, akewende o ndaghu Mari, ngudji San adjinengulu Mareke. Aghune, batu bapwele bamabe baghukeme na bamasambililaange. ");
INSERT INTO puu_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Ave Pyere amakokemunine mu yabutsu yi mune ndaghu, musatsi mughetu, awinengulu Rode, akebambene mughulu. ");
INSERT INTO puu_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Akedjabe dyufi di Pyere, tumbe na kini asamadibule, aketsingule abamabe o ghari yi Pyere adji va dulombili. ");
INSERT INTO puu_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Bakemuvaghe yi: «Wune bulaghu!» Tumbe amatsiyisaange yi ngenze. Kaboghu bakevaghe yi: «Awune tangudji yanze yandi.» ");
INSERT INTO puu_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Yotsu yina, Pyere ukokemune mbé akikokemune. Bakemudibulile yabutsu, na bakesutu ave bamamulabile. ");
INSERT INTO puu_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Akesambe dikake mubavotse, akebatsingule nane Fumu amamupalisile o tsughu, mba akebasindighe yiri: «Wendanu yétsingulanu Sake na baane ba tadji basusu.» Anomane, akepale nowende yari yisusu. ");
INSERT INTO puu_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Wisi anotebughe, vakebe nkumfu neni va ghari baghore. Djowu bamakewivulaange: «Pyere akewuke?» ");
INSERT INTO puu_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Yirode akeveghe dirume dyumurombe, tumbe basamamulabe. Akewave baghore, na akeveghe musughe wu baboke. Va djulu vane, akeghusughe o yinange yi Sudé novindeme o musyengi Sesaré mu yévume mwa temu. ");
INSERT INTO puu_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Yirode amabe na kabu neni na bise Tire na bise Sidone. Djowu bakewulusunu va mosi mu sumbe yivunde, ayimakelisaange bime byotsu bi kaghe, dine dyandi Balesetose. Bamavayile nane, mumbari bamarondaange uvonde duvotsu na kaghe Yirode, dibilaange yiri bighudji byowu byotsu, bimarughesenaange o bulongu bwandi. ");
INSERT INTO puu_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Mu yilumbu ayi bamasikighe, Yirode akedware yidjunge yi bukaghe, aketsane va yitsighe yandi yi bufumu, mba akebavosilaange. ");
INSERT INTO puu_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Yike yinombu yimaghamughe yiri: «Djandi evosi nane nyambi, tsiri nane mutu!» ");
INSERT INTO puu_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Tumbe vane-vane, yanze yi Fumu yikemudimbe, mumba amabonge bundumbe bu Nzambi: akelighu na misobe, na akefu. ");
INSERT INTO puu_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Musamu wu Nzambi wumanyavaange laviri. ");
INSERT INTO puu_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Barenabase na Sole yikebemani yisalu yowu o musyengi Serusaleme, bakeyeneghabughe, na bamabeghe nowu San awu amanengulungu Mareke. ");
INSERT INTO puu_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Mu dibundu ayimabe o musyengi Antyose, vamabe babiyitsi na milonzi: Barenabase, Simewu adjinengulu «Munombi», Lususe mwise Sirene, Manayene omabungughe va mosi na kaghe Yirode, na Sole. ");
INSERT INTO puu_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Mwa yilumbu ayi bamayitsilaange Fumu nowarile nzale, Yinyuni Yisyeme akebavaghe yiri: «Vengighanu Barenabase na Sole va mughule, bakedughusungu yisalu ayi nyimabanengilile.» ");
INSERT INTO puu_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Kaboghu, banomane uwarile nzale nosambile, bakebasakighe makake na bakebasile uyenewende. ");
INSERT INTO puu_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Banotindu na Yinyuni Yisyeme, Barenabase na Sole bakevindeme o disabu di Selesi. Avane, bamanangemine mu watange muwende o ningi dji Sipere. ");
INSERT INTO puu_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Ave bamatolile o Salemine, bamasamune musamu Nzambi mu mandaghu ma tsambu ma baSwife. San adjinengulu Mareke amabe nowu nane mukange. ");
INSERT INTO puu_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Vane wusu, banosabughe ningi djotsu bamatole o musyengi Pafose, bamayerasene muSwife, dibaale dimavagha bulosi. Dibaale dyeni dimabe mubiyitsi wumfurulu, dimanengulu «Bare-Djesu». ");
INSERT INTO puu_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Djandi, amabe yisatsi yi yidjeti yineni ayimarumisaange yinange, yi manenguluungu Sersyo Poluse, dibaale dimabe na dudjabu. Djandi akenengile Barenabase na Sole, mumbari amabe na nzale uwulu musamu Nzambi. ");
INSERT INTO puu_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Tumbe mulosi eni, awu bamanengilaange o mbembu Ngereke «Limase», amabalase maghughe. Adine djandi amabaghubitsilaange yi yidjeti akéwulu musamu Djesu. ");
INSERT INTO puu_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Kaboghu Sole omanengulungu «Pole» wandi, amabe abase na Yinyuni Yisyeme. Djandi akemughengile yiswisu mu misu, ");
INSERT INTO puu_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","mba akemutsingule rye: «Ndedju awubase na mele na bikumbu, mwane dyabu, mumbini! Ngenze, ndedju wusekamane urekighe manzile ma Fumu amasungeme? ");
INSERT INTO puu_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Avave, dikake di Fumu dike mu ndedju, wube yidunge. Mu mwa pesu temu, wughobwélabe dyénini di nyangu.» Sundila, misu ma Limase mamatsime, na piseme djimamughumbe, lake akeyenetsukemaange yari na yari, norombe mutu wumulonge nzile. ");
INSERT INTO puu_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Ave yidjeti yeni amalabile dyambu adibenovyoghe va wusu andi, djandi amavayile Djesu yitu. Vane-vane, ndonzulu musamu Fumu djimabembe murime andi. ");
INSERT INTO puu_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Pole na bambatsi bandi bamadusughe Pafose mu bwatu, muwendesene o disabu di Perse mu yinange yi Pafili. Aghune, San Mareke akebasile na akeghabughe o Serusaleme. ");
INSERT INTO puu_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Banodusughe musyengi Perse, Pole na bambatsi bandi bamatole o musyengi Antyose dji yinange yi Pisidi. Mu yilumbu yuvume, bakekote o ndaghu dusambu dji baSwife na baketsane. ");
INSERT INTO puu_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Banomane urange mughaghe Moyise na babiyitsi, bivunde bi ndaghu dusambu bakesindighe mutu muyebawivule rye: «Baane ba ngudji, payi dune mwa musamu mu warise batu, tsyévosyanu!» ");
INSERT INTO puu_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Pole akereleme, akenangule dikake mubaghebule mba akevose yi: «Bise Yisrayele na djenu abedwidumi Nzambi, nkulwanu! ");
INSERT INTO puu_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Nzambi baane ba Yisrayele, amasole baghulu betu. Amaroyise mukute eni, ave wumabilaange o bulongu bu Yisipete. Mba akewupalise na mangolu mandi o bulongu bweni. ");
INSERT INTO puu_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Mba Nzambi amabasinge na bingulu byowu mu maghumi-mana (40) ma bilime, ave bamenewendilaange mu kumu dukange. ");
INSERT INTO puu_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Va djulu vane, amadyamise yisambwali yi mikute o bulongu bu Kanane, na amaveghe mukute Yisrayele bulongu bweni nane disyale. ");
INSERT INTO puu_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Motsu mane mamatsinge tangudji kame-djina na maghumi-maranu (450) ma bilime.» «Va djulu vane, amaveghe bakaaghe betu banzonzi tena va temu mubyitsi Samwele. ");
INSERT INTO puu_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Kaboghu, bakaaghe betu bamavonde kaghe djubabeyise. Nzambi akebaveghe Sawule, mwane Kise, mu yifumbe yi Binzame. Djandi amarumise mukute Yisrayele mu maghumi-mana (40) ma bilime. ");
INSERT INTO puu_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Nzambi anodjusule Sawule va yitsighe yi bukaghe, amabaveghe Davide nane kaghe owu va yivinze yi Sawule. Nzambi amamughabusile bumbedji novose rye: “Menu nyimadile Davide, mwane Djese, dibaale diwelimine, adimpeyi nzangu o murime ami, odughusu mambu motsu ame nyirondi akedughusu.” ");
INSERT INTO puu_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Yike mu mukute Davide, Nzambi amasole muteghule andi wumosi, Djesu mube Mughobutsi wu baane ba Yisrayele, nane amabaveyile pangini. ");
INSERT INTO puu_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Ne Djesu akerughe, San-Batise amalonze mukute wotsu wu Yisrayele bwendiri: mbé boléfungule mabi mowu, nobatusu mu lase yiri bamakalughe myonu. ");
INSERT INTO puu_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Ave yisalu yi San yimabile bebeli nosuke, djandi amabawivule rye: “Anyi dwitasi yiri nyivu? Menu, nga djandi awu dwikelisi. Tumbe wulwanu! Djandi oyiruyi, djabanu yiri: menu nga nyiwelmine, nesi yike mu munyangule mikudu mi bapondu bandi.”» ");
INSERT INTO puu_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","«Bane ba tadji, djenu abe duvu baane ba Aberaame, na djenu wandi, adwiruyi mu mikute misusu mba dwidumi Nzambi, musamu éwuwu wu dughobutsu wutsitutindulu djetu botsu anu. ");
INSERT INTO puu_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Batu abamatsanaange o Serusaleme na bivunde byowu bamaghale Djesu, na djowu basamatsiyise malongi ma babiyitsi amamarangu mu kale yilumbu yuvume yi baSwife. Tumbe ave bamafundisile Djesu, bamadughusu motsu ame babiyitsi bamabighaange. ");
INSERT INTO puu_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Ne nane basamabe na tonu djumubokile, djowu bamavaghe Pilate yiri akeveghe musughe wumuboke. ");
INSERT INTO puu_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Ave bamamanine udughusu mambu motsu ame Bisonu bi Nzambi bimavosaange mu djandi, bamasunduse yibindi yandi va kurusu na bakemusunze o ngile. ");
INSERT INTO puu_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Tumbe Nzambi amamurambuse o dufu. ");
INSERT INTO puu_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Mu bilumbu bipwele, Djesu amalabene ombu djowu abamayenewendaange nandi ubandile o Ngalile teno Serusaleme. Avave, djowu bakevu bambedji ba Djesu va wusu baane ba Yisrayele. ");
INSERT INTO puu_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Na djetu, twidudjabisi Musamu Wuboti, pangini adji Nzambi amavangene na baghulu betu. ");
INSERT INTO puu_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Djandi amadjidughusu ombu djetu abe tuvu bateghule bowu, ave amarambusile Djesu o dufu. Nane direndulu mu mughande Nimbu awu mubedji yi: “Ndedju wudji mwane ami, na muni, nyimawubure.” ");
INSERT INTO puu_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Nzambi amarambuse Djesu va ghari djowu abafu, mumba dunyuru dwandi dukeyébole o ghari mbine. Djandi amavose rye: “Nyuduveghe myule, ami nyimavangene na Davide, amisyeme na mi ngenze.” ");
INSERT INTO puu_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Ladibandu, mbembu Nzambi djivosili mu kapu mosi yiri: “Ndedju wughosile Yibyatsi yaghu Yisyeme, yikebole o ghari mbine.” ");
INSERT INTO puu_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Yike Davide, anomane udughusu mu temu andi bisalu byotsu abi Nzambi amaronde bwé akedughusu, djandi amafu. Aketswighu mbure mosi adji bamatswiyile batadji bandi, na dunyuru dwandi dumabole. ");
INSERT INTO puu_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Tumbe Djesu awu Nzambi amarambuse o dufu, dunyuru dwandi dusamabole. ");
INSERT INTO puu_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","39","Baane ba ngudji, djabanu yiri: mu djandi, dutandu du mabi dwidulonzulu. Mu djandi, mutu wotsu awimuvayili yitu, eghobulu mu mabi motsu, ame ne mighaghe mi Moyise mbé mighorungule utande. ");
INSERT INTO puu_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Kaboghu, mbé dukebene yiri motsu amamabighu na babiyitsi makéduruyile. Djowu bamavose rye: ");
INSERT INTO puu_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","“Tsunanu, djenu abe dubase na dilenze. Sutwanu na fwanu! Mu temu adji dukidubile monyu, nyuvaghe mwa yisalu. Yisalu ayi mbé dughorungule usinge, ne mutu atsidutsingule yoni.”» ");
INSERT INTO puu_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Ave Pole djone Barenabase bamapalilaange o ndaghu dusambu dji baSwife, batu bamabawivule yeri, mbé bomwérughe oyibalonze mambu meni, mu yilumbu yuvume. ");
INSERT INTO puu_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Ave yibengunu yimasukile, baSwife bapwele na batu abamasinge Nzambi baSwife nomuyitse, bamayevetsighe Pole na Barenabase. Mu nzile, mubedji eni wumayenevosaange nowu, mu bawarise yiri bayakakene na yese yi Nzambi. ");
INSERT INTO puu_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Yilumbu yuvume ayimadukaange, batu botsu ba musyengi bamaghukeme mu yéwulu musamu wu mbembu Fumu. ");
INSERT INTO puu_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Ave baSwife bamalabile mughungi, djowu bamabase na ngusu, mba bamatumune bakemi mu mambu motsu Pole amavosaange na bamamusyenge. ");
INSERT INTO puu_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Yike Pole djone Barenabase bakebatsingule na musighe rye: «Mbembu Nzambi djimatindulu va téteghe ombu djenu baSwife. Tumbe dudjibusilaange, dwilasi yiri dughaduwelmine mudile monyu mutubu na mutubu! Adine djetu, tughéluyile yike ombu djowu abagha baSwife. ");
INSERT INTO puu_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Djabeni Fumu eturumi ave evosili rye: “Nyimawubyatse nane yidjalale yi malongu masusu, mubeghe dughobutsu teno masukusulu ma butambe!”» ");
INSERT INTO puu_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Ave bamadighululu, botsu abasamabe baSwife bakebase na nzangu, bakeyitsaange musamu Fumu. Na botsu abamasolu kale, mudile monyu mutubu na mutubu, bamavayile Djesu yitu. ");
INSERT INTO puu_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Musamu Fumu wumanyavaange mu bulongu bwotsu. ");
INSERT INTO puu_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Tumbe baSwife bakesibise bidjeti bi baghetu abamayitsaange Nzambi na bivunde bi musyengi. Djobotsu bakekwane Pole djone Barenabase, mba bakebasyanze o yinange yowu. ");
INSERT INTO puu_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Pole na Barenabase bakekuke difufundu di makulu mowu na bakewende o musyengi Yikonyome. ");
INSERT INTO puu_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Yotsu yine, badukitsi abamabe o musyengi Antyose, bamabase na nzangu djineni na Yinyuni Yisyeme. ");
INSERT INTO puu_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","O Yikonyome wandi Pole na Barenabase bakekote o ndaghu dusambu dji baSwife. Bamasamune musamu Nzambi, lake baSwife na baNgereke bapwele bamasinge musamu Djesu. ");
INSERT INTO puu_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Tumbe baSwife abasamasinge Nzambi, bakerombise matase mabive ombu djowu abasamabe baSwife, na bakebasibise bwé bakéwululu bango yitu. ");
INSERT INTO puu_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Tumbe dikalewube nane, Pole na Barenabase bamatsinge o musyengi Yikonyome. Bamasamunaange musamu Nzambi na musighe. Fumu amabaveghaange mangolu movaghe bimaghe na bilimbe bineni na makake mowu, mu ulase yiri, musamu awu bamalonzaange mu yese yandi, wungenze. ");
INSERT INTO puu_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","O musyengi Yikonyome, vakebe dupasu va ghari yinombu yi batu ba musyengi. Bamosi bakebe o yari yi baSwife, mba bane o yari yi bilumbi. ");
INSERT INTO puu_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Tumbe baSwife na bo basamabe baSwife na bivunde byowu bakekunzeme mukwane notinde mamani mu uboke bilumbi. ");
INSERT INTO puu_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Djowu badidjabilaange, bakeyesweme o misyengi mi Likoni, Lisetere na Derebe, na mu mighule myowu. ");
INSERT INTO puu_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Aghune, bakesamune Musamu Wuboti. ");
INSERT INTO puu_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","O musyengi Lisetere wumabe yikoyi, yimaburu mambolutu, asamarungulaange uwende diteli. Matsane, ");
INSERT INTO puu_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","amawulu nane Pole amavosilaange. Pole anomughengile, akelabe yiri ane yitu yiwelimine yughobululu. ");
INSERT INTO puu_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Pole akemutsingule rye: «Releme, sumbiti mu makulu maghu!» Yikoyi yeni akesundile ureleme na akevaghe mwa batake. ");
INSERT INTO puu_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Mughungi wunolabe adi Pole amavaghe, wukevose o mbembu dji bise Likoni yi: «Banyambi bamabonge manyuru ma batu na bamavindeme ombu etu!». ");
INSERT INTO puu_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Bamanengile Barenabase «Sese», mumbari Sese amabe yivunde yi banzambi bowu. Pole bakemunengile «Yirmese», mumba amabe djandi omavosaange pwele. ");
INSERT INTO puu_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Ndaghu dji nyambi Sese djimabe beli na dikotulu di musyengi. Anowulu mambu meni, muvaghulitsi paghu wu nyambi eni akebeghe bangombi abebamadwise na kembu, va wusu mughungi eni. Bamarondaange yi bangombi beni bakeveghu nane paghu ombu Barenabase djone Pole mu baghobise. ");
INSERT INTO puu_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Bilumbi Pole na Barenabase, banodidjabe, bakepase bikutu byowu mu kevongule na bakesobene mu mughungi, noghamughe: ");
INSERT INTO puu_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","«Bambatsi betu, mubayi dwivayili nane? Tudji batu nane djenu. Twidubeyili Musamu Wuboti, muvaghe yiri dukesanze mutsanu enu. Mbé dusile bakosi abaghane tsongu, nosinge Nzambi-Pungu omasunde djulu, butambe, mubu na byotsu abivu mune. ");
INSERT INTO puu_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Mu temu atsimavyoghe, Nzambi amasile malongu motsu wuyenewendaange kulini-kulini. ");
INSERT INTO puu_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Ne vane, Nzambi asamadunde udulase maboti mandi. Adine, amadutindilaange mamvule na bivaru mu temu adjiwelimine. Amabwéduveghe bighudji na amabase mirime myenu na nzangu.» ");
INSERT INTO puu_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Yike bakale uvose nane, bilumbi bamalabe diweru dyughandise mughungi, bwé akébavaghulile paghu. ");
INSERT INTO puu_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Va djulu vane, mwa baSwife bamosi bakerughesene o musyengi Antyose no Yikonyome, bakesibise mughungi mu kwane Pole djone Barenabase. Mba baketinde Pole mamani mu muboke. Na ditase yi Pole amafu, bakemudute mu mupalise o musyengi owu. ");
INSERT INTO puu_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Tumbe badukitsi banomukande, akereleme na akekote nowu o musyengi. Va kedi, akewende na Barenabase o musyengi Derebe. ");
INSERT INTO puu_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Pole na Barenabase bamasamune Musamu Wuboti o musyengi Derebe, awu bamadilile badukitsi bapwele. Mba bakeghabughe o Lisetere, o Yikonyome na Antyose. ");
INSERT INTO puu_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Bamayenewarisaange badukitsi, nobalonzaange ube na yikanene mu yitu ombu Nzambi. Na bamabwébalubusaange yi: «Tuvyolanu mu maghughe mapwele ne tukekote mu Bukaghe bu Nzambi.» ");
INSERT INTO puu_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Mu kale dibundu bamababyatsile bivunde, mba yikebemani uwarile nzale nosambile, bakebawakise va makake ma Fumu adji bamavayile yitu. ");
INSERT INTO puu_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Bakevyole o yinange yi Pisidi, na baketole o yinange yi Pafili. ");
INSERT INTO puu_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Banomane ulonze mbembu Nzambi o musyengi Perse, bamavindeme o musyengi Atali. ");
INSERT INTO puu_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Va djulu vane, bakenangeme mu watange mu wende o musyengi Antyose dji Siri, musyengi awu bamabyatsulu mu yese yi Nzambi dibandu yisalu ayi bamavaghe. ");
INSERT INTO puu_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Banotole o Antyose, Pole djone Barenabase bakeghukighe dibundu. Bakebatsingule motsu ame Nzambi amavaghe mu kake mowu, na nane amaghobulile batu bapwele abasamabe baSwife. ");
INSERT INTO puu_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Pole djone Barenabase bamavyose temu djineni va ghari badukitsi ba yinange yi Antyose. ");
INSERT INTO puu_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Mwa batu bamarughesene o musyengi Sudé, baketole o musyengi Antyose. Djowu bamalonzaange baane ba tadji botsu, novose rye: «Pa dugharebu nane mughaghe Moyise wivosili, dughorungule ughobulu.» ");
INSERT INTO puu_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Pole na Barenabase basamasinge ame djowu bamavosaange, na bamatsunde nowu. Ladibandu, bamawulusunu yi Pole na Barenabase na bango yitu ba musyengi Antyose, mbé bowende o Serusaleme oyevose dyambu dyeni ombu bilumbi na bivunde bi dibundu. ");
INSERT INTO puu_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Dibundu dimabaghanine nobasyende. Djowu bamavyoyile o yinange yi Fenisi teno Samari, noyenetsingulaange nane batu abasamabe baSwife, bamadilile duburu du ghone. Na dyoni, dimaveghe nzangu neni ombu baane ba ngudji botsu. ");
INSERT INTO puu_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Ave bamatolile o Serusaleme, bakesangulu na dibundu, na bilumbi na bivunde bi dibundu. Lake djowu bakebatsingule motsu ame Nzambi amadughusu nowu. ");
INSERT INTO puu_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Tumbe, mwa bamosi mu yinombu yi baFarisi, abamavayile Djesu yitu bamareleme. Djowu bamavose rye: «Bise malongu abagha baSwife vengu mbé borebu, nobaveghe dirume dyughobise mughaghe Moyise.» ");
INSERT INTO puu_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Bilumbi na bivunde bi ndaghu Nzambi bikeghukeme mu ukelule dyambu dyeni. ");
INSERT INTO puu_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Va djulu mutsundu eni wune, Pyere akereleme nobatsingule rye: «Baane ba ngudji, dwididjabi yi mu bilumbu abiteghe, Nzambi amanzole va ghari enu. Djandi amaronde yi ngalonze Musamu Wuboti ombu djowu abagha baSwife, bakewughuwulu na bakewusinge. ");
INSERT INTO puu_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Na Nzambi, oyidjabi mirime mi batu, amabalase yiri ebasingi, na amabaveghe Yinyuni Yisyeme nane amavayile netu. ");
INSERT INTO puu_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Nzambi asamavaghe duvyakusunu va ghari djowu na djetu. Bano vayile Nzambi yitu akebalyomise mirime. ");
INSERT INTO puu_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Mumbari yi dwimangili Nzambi? Dwirondi usunze mufune ewune mu masambeke ma badukitsi? Mufune awuwu, ne bakaaghe betu, ne djetubeni tusamarungule unangule! ");
INSERT INTO puu_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Mu dyoni, tune yitu yiri djetu botsu twighobululu mu yese yi Fumu Djesu, nane djowandi.» ");
INSERT INTO puu_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Yinombu yotsu yi batu yikevole «swii», mughulu Barenabase na Pole abamabatsingulaange bimaghe na bilimbe, abi Nzambi amadughusu nowu va ghari abasamabe baSwife. ");
INSERT INTO puu_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Yike bévoli, Sake akebonge mbembu novose rye: «Baane ba ngudji, kulwetyanu! ");
INSERT INTO puu_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simewu amatutasise mwa dyambu: vane dibandu, Nzambi amasolile va ghari abasamabe baSwife, mukute awube wandi. ");
INSERT INTO puu_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Posulu babiyitsi djiwelmine na dyambu dyeni. Direndulu mu Bisonu rye: ");
INSERT INTO puu_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","“Fumu Nzambi amavose yi: Va djulu vane nyubwérughe. Nyurelighe ndaghu Davide adjimaberughe. Nyurungulile abimapanzighe, nyudjikunze na djubwéreleme, ");
INSERT INTO puu_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","mba batu bamosi ba bulongu bakerombe Fumu. Nine, mikute myotsu ami nyimanengili mikebe myami. Lanu adi Fumu evosi. ");
INSERT INTO puu_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Djandi amadughusu mambu meni mane, vane kale.”» ");
INSERT INTO puu_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Sake akebwévosi yi: «Lanu adi menu nyitasi: diwelemine yi tuyamwékambise abagha baSwife, abekaluyi dyele na uduke Nzambi. ");
INSERT INTO puu_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Tumbe tubarendisilyanu mughande, mu ubatsingule rye: “Duyabwebile udji banyame abaveghu nane paghu ombu bakosi. Silanu monyu wu nzoruru na bumbembu, duyabwebile udji banyame abaghaghewu kingu mu upalise malungu.” ");
INSERT INTO puu_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Vaghanu nane mumbari, ubandile vane kale, mu kale musyengi awu batu bélonzili mughaghe Moyise, mughaghe eni wirangu kale yilumbu yuvume mu mandaghu ma tsambu ma baSwife.» ");
INSERT INTO puu_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Kaboghu, dimawelmine yiri bilumbi na bivunde, na dibundu dyotsu, bakesole va ghari owu, batu botinde na Pole djone Barenabase o musyengi Antyose. Bakesole baane ba tadji babedji va ghari bivunde bi dibundu: Silase na Sudase omanengulungu Barenabase, babaale bamaghobusungu. ");
INSERT INTO puu_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Bakebaveghe mughande eni awumabe wusonughu nane: «Djetu bilumbi na bivunde bi dibundu tudji baane ba ngudji benu. Yike twidutindili mughande éwuwu, djenu baane ngudji betu abagha baSwife, djenu adwitsani o musyengi Antyose o yinange yi Siri na Silisi, mbolwanu! ");
INSERT INTO puu_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Tumawulu yi bamosi va ghari etu bamayédupupise mirime na posulu tsyowu. Yotsu yine, tsiri djetu tumabasindighe. ");
INSERT INTO puu_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Ladibandu, tutsisolile batu bébane, nobasindighe ombu wenu na baane ba tadji betu ba murime, Barenabase na Pole. ");
INSERT INTO puu_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Djowu abamasumbise monyu owu mu dine di Fumu etu Djesu Kirisete. ");
INSERT INTO puu_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Na twidutindili Sudase na Silase, aboyidutsingule na musighe, mambu mane mamosi ame tutsidurendili mu mughande eni wune. ");
INSERT INTO puu_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Adine Yinyuni Yisyeme na djetubeni, tutsilabile yi tughobwérungule uduveghe mufune wumosi va djulu mambu meni ametumadurendili. Tumbe vengu, mbé dudedile mighaghe myeni mimi: ");
INSERT INTO puu_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","duyabwedji banyame abavaghulu ombu bakosi, silanu monyu wu nzoruru na bumbembu, duyabwebile udji banyame abaghaghewu kingu mu upalise malungu. Payi dutsivaghe nane mu byotsu bine, diwelimine yiri dutsisungighe. Kangwalyanu, yike vane wusu.» ");
INSERT INTO puu_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Banoghanine bise dibundu, bakewende o musyengi Antyose. Ave bamatolile wune, bakeghukighe dibundu dyotsu mba bakebaveghe mughande eni. ");
INSERT INTO puu_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Mughande eni wukerangu, na botsu bamabase na nzangu, mu duwarusu adu bamadile mu motsu amamabe marendu mune. ");
INSERT INTO puu_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Sudase na Silase, babilange djobeni babiyitsi, bamawamuse baane tadji na malongi mapwele, mu bawarise mu yitu yowu. ");
INSERT INTO puu_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Bamatsane nowu mwa temu, mba baane ba tadji yikebemani ubaveghe myule, bamabaghanine nobasile ughabughe ombu djowu abamabasindighe. ");
INSERT INTO puu_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Yike, Silase amaronde usyale o musyengi Antyose. ");
INSERT INTO puu_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Pole na Barenabase bakesyale o Antyose. Djowu na batu bamosi, bamayenelonzaange mbembu Fumu nosamune Musamu Wuboti. ");
INSERT INTO puu_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Mwa temu djinovyoghe, Pole aketsingule Barenabase yi: «Twendi tughabuyi o uyélingule misyengi myotsu ami tumayenesamunine musamu wu Fumu, mu uyélabe nane baane ba tadji bakevu.» ");
INSERT INTO puu_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Barenabase mbé aronde ubeghe nowu, San omanengulungu Mareke. ");
INSERT INTO puu_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Tumbe Pole amadibuse, mumbari San Mareke djawandi, amabuse uwende nowu. Adine amakakenine nowu vo bamabile o yinange yi Pafili, mumbari amabuse ubawamuse mu yisalu yowu. ");
INSERT INTO puu_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Mutsundu wumabe wuneni va ghari owu, la dibandu bamakakenine. Barenabase akebonge Mareke nandi, bakenangeme mu watange na bakeyenewende o ningi dji Sipere. ");
INSERT INTO puu_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Tumbe Pole akesole Silase, bakewakusu na baane ba tadji va makake na yese yi Fumu, mba bakeyenewende. ");
INSERT INTO puu_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Bamavyoyile o yinange yi Siri na yo yi Silisi, noyenewarisaange yitu yi mabundu. ");
INSERT INTO puu_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Pole aketole o misyengi mi Derebe na Lisetere. Vane vamabe mudukitsi dine dyandi Timote, ngudji andi mughetu muSwife awumasinge Djesu, tadji andi amabe muNgereke. ");
INSERT INTO puu_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Baane ba ngudji bise Lisetere na Yikonyome, bamamughabusilaange bumbedji buboti. ");
INSERT INTO puu_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Pole mbé aronde umubeghe nowu mu mulingu, adine amarebelu. Djandi amavayile nane, dibandu baSwife abamabe mu binange byeni, mumbari batu botsu bamadjabaange yiri tadji andi adji mwise Ngereke. ");
INSERT INTO puu_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Mu misyengi myotsu ami bamayenevyoyilaange, bamenelonzaange baane ba tadji mighaghe ami bilumbi na bivunde bi Serusaleme bamabonge, na bamatsiyisaange mumbari mikeghobusu. ");
INSERT INTO puu_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Mabundu mamawarusungu mu yitu, na durangu dwowu dumaneghaange kale yilumbu. ");
INSERT INTO puu_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Pole na bambatsi bandi ba mulingu, bamavyoyile o yinange yi Firisi na o Ghalasi, mumbari Yinyuni Yisyeme yimabaghandise ulonze musamu Nzambi o yari yi Asi. ");
INSERT INTO puu_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Ave bamatolile va mughule yinange yi Misi, bakedile ditase dyuwende o Bitini, tumbe Yinyuni yi Djesu yisamabagharusu. ");
INSERT INTO puu_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Adine bamavyole kwase yinange yi Misi tenave bamayesunduyile o disabu di Torwase. ");
INSERT INTO puu_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Va mukolu, Pole akebe na dulase. Akelabe sumbiti dibaale diteli, mwise Masedwane amamulendaange yi: «Vyoyile o Masedwane na rughe oyituwamuse!» ");
INSERT INTO puu_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Va djulu dulasu dweni, tumakunzeme mu uwende o Masedwane, mumbari tumalabe yiri Nzambi amatunengilaange wune, mu yésamune Musamu andi Wuboti. ");
INSERT INTO puu_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Yike, tunonangeme mu watange o Torwase, na tumawende sungingi o ningi dji Samotarase, mba yilumbu ayi mubedji, tumatole o musyengi Napolise. ");
INSERT INTO puu_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Tunodusughe vane, tumawende o musyengi Filipe, musyengi wuteghe wu yinange yi Masedwane, awumabe otsi durumu du Rome. Tumavyose mwa bilumbu va musyengi eni. ");
INSERT INTO puu_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Yilumbu yuvume yi baSwife, tumapale o musyengi mu wende o mughule mudjambe na ditase dyurasunu mbure adji batu bamasambililaange Nzambi. Tumatsane mu uvosile mwa baghetu, abamabe baghukeme vane. ");
INSERT INTO puu_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Mughetu wumosi va ghari owu amanengulungu Lidi, mwise Tyatire. Djandi amabe kooli tsande tsiboti tsimabe tsibenge. Mughetu eni amayitsaange Nzambi, adine amatuwululuungu. Na Fumu amamudibule murime, mumbari akewulu na musighe mambu ame Pole amalonzaange. ");
INSERT INTO puu_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Djandi amabatusu na batu botsu abamatsanaange mu ndaghu andi. Na amatunengile novose rye: «Payi dwitasi yiri menu wandi nyivayili Fumu yitu nane djenu, rughanu yitsananu mu ndaghu ami.» Amatunengile na yiswebiri na tumasinge uwende. ");
INSERT INTO puu_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Mwa yilumbu, ave tumawendilaange o mbure dusambu, tumabengunu na musatsi mughetu munzambu, amabe na yinyuni yi mbome. Yinyuni yeni ayi amayenebiyilaange, nodilisaange mbongu tsipwele ombu bafumu bandi. ");
INSERT INTO puu_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Munzambu eni amayenetudukaange, Pole na djetu, na amayeneghamughaange yiri: «Batu bebabe basatsi ba Nzambi djulu! Djowu bodulonze nzile dughobutsu!» ");
INSERT INTO puu_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Dyambu dyeni dikebe yike nane yiswebiri bilumbu byotsu. Va disukusulu, Pole akenyoghe, akeghelughe na akenyangile yinyuni yibi novose rye: «Mu dine di Djesu Kirisete, nyiwurumi lenge nopale mu djandi!» Na yinyuni yibi yimapale va temu eni. ");
INSERT INTO puu_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Vo bafumu ba munzambu eni bamalabile yiri mulilu owu wumatsyemughe, bakeghange Pole na Silase na bakebabeghe va mbure mughungi, va wusu fundu banzonzi mu utabule dyambu. ");
INSERT INTO puu_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Bakebabeghe va wusu banzonzi ba mighaghe na bakevose rye: «Batu bebabe bamayirombise dimbunge mu musyengi etu. Badji baSwife ");
INSERT INTO puu_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","na bélonzi mutsanu awughawuwelimine na mighaghe myetu, djetu abe tuvu bise Rome. Na tughane musughe wusinge vo wusalise moni.» ");
INSERT INTO puu_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Mughungi wukenyoyile Pole djone Silase. Banzonzi bamasindighe batu bakebavule bikutu, nobadimbise mikase. ");
INSERT INTO puu_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Banomane wubadimbise, bakebabwaghe o tsughu na baketsingule mukelitsi tsughu, yiri akebakelisaange babindeme o ghari tsughu. ");
INSERT INTO puu_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Anodile dirume dyeni, mukelitsi tsughu akebasunze o yibuku ayi ghari na akebavaghe makulu mu bivangu bi miri. ");
INSERT INTO puu_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Va ghari mukolu, Pole na Silase bamasambilaange na bamawimbilaange muyitse Nzambi. Botsu abamabe o tsughu bamabawulungu. ");
INSERT INTO puu_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Vane-vane, butambe bukeregheme norakule yibughe yi ndaghu tsughu. Myune mi ndaghu myotsu mikedibughe na bapange ba bise tsughu botsu bakenyangughe. ");
INSERT INTO puu_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Mukelitsi tsughu akerambughe. Anolabe yiri myune mi ndaghu mi tsughu midibughe, akedute didjenge dyandi mukéboke, mumbari amatase yi bise tsughu bamarine. ");
INSERT INTO puu_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Tumbe Pole akebwaghe mughamu wuneni novose rye: «Wuyakéboke! Djetu botsu tudji vave!» ");
INSERT INTO puu_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Mukelitsi tsughu akevonde mutotu paghe, akewemaswasu o tsughu noregheme, akekebwaghe va makulu ma Pole na Silase. ");
INSERT INTO puu_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Akebapalise o yibuku yi ndaghu na akebawivule: «Bafumu bami, tsyeni nyurungule uvayile mu ughobughe?» ");
INSERT INTO puu_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Bakemuwaghule yiri: «Vayile Fumu Djesu yitu, wughobulu, ndedju na mukute aghu wotsu.» ");
INSERT INTO puu_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Mba bakebalonze musamu Fumu, djabeni na botsu abamabe mu ndaghu andi. ");
INSERT INTO puu_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Mune mukolu eni, mukelitsi tsughu akebabeghe o ndawandi, akebasuse mapure na akebabughe. Vane-vane amabatusu, na mukute andi wotsu. ");
INSERT INTO puu_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Mukelitsi amabeghe Pole na Silase o ndaghu andi, amalambise, bakedji va mosi. Djandi na mukute andi, bamabase na nzangu djineni mumbari bamasinge Nzambi djobotsu. ");
INSERT INTO puu_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Wisi anotebughe, banzonzi baketinde baghore mu uyétsingule mukelitsi tsughu yi: «Palise batu bebane.» ");
INSERT INTO puu_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Mukelitsi tsughu aketsingule Pole rye: «Banzonzi batsitinde musughe wududjeyise. Kabo tsyewendyanu na duvotsu.» ");
INSERT INTO puu_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Tumbe Pole akebawaghule rye: «Djowu batsitudimbise va ghari batu. Wendanu dukebatsingule, bamatubwaghe o tsughu ne bunzonzi uvaghu. Djetu abe tuvu bise Rome! Mba vave, bérondi utudjeyise yike o musweghe? Nesi! Baruyi djobeni mu uyitudjeyise!» ");
INSERT INTO puu_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Baghore baketsingule banzonzi mambu meni, na djowu bakeregheme, badjabilaange yiri Pole na Silase bise Rome. ");
INSERT INTO puu_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Banzonzi bakerughe mu uyibavonde kokolu, bakebapalise o tsughu na bakebavaghe bwé bakedusughe musyengi. ");
INSERT INTO puu_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Banopale o tsughu, Pole na Silase bakewende ombu Lidi. Banomane uwarise baane ba tadji mu yitu, bamayenewende. ");
INSERT INTO puu_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Banovyoyile o misyengi mi Afipolise na Apoloni, Pole djone Silase bamatole o musyengi Tesalonike, tena ndaghu dusambu dji baSwife. ");
INSERT INTO puu_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Mu yuku yandi, Pole amakote o ndaghu dusambu. Kale yilumbu yuvumine, mu tsone yiryeru, amamoghe na amatsunde nowu mu dyambu di Bisonu bi Nzambi. ");
INSERT INTO puu_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Adine amabavindiyilaange nobalonzaange nane Bisonu bi Nzambi, bimalasilaange na kengili yiri, Kirisete mbé otsoghusu, akeboku, mbana va djulu vane, mbé orambughe o dufu. Pole akebwébatsingule rye: «Djesu adji menu nyidulonzi, djandi la Kirisete.» ");
INSERT INTO puu_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Mwa pesu baSwife bakesinge musamu eni, bamasobene na Pole djone Silase. Vamabe yinombu yineni yi baNgereke bamabande uyitse Nzambi, baghetu bapwele wandi bamabe bidjeti. ");
INSERT INTO puu_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Tumbe baSwife bakebase na ngusu. Bakeghukighe yinombu yi makwilisi bamarasunu mu mimbambe, bakesibisi dimbunge mu musyengi. Bakewende o ndaghu dji Sason mu yenerombe Pole na Silase, mubabeghe va wusu mukute. ");
INSERT INTO puu_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Basamarasunu Pole na Silase. Ladibandu, bamabeyile Sason na baane ba ngudji bamosi va wusu bivunde bi musyengi. Bakeghamughe, novose rye: «Batu bebabe batsisisene bulongu, bamatole wunu! ");
INSERT INTO puu_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Sason amabadile ombu wandi! Batu botsu babe bésalisi na duvyakusunu du mighaghe mi kaghe Sesare, mumbari bévayi yi vadji kaghe mosi, djinengulu Djesu.» ");
INSERT INTO puu_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Posulu eni, djikenyoyise mughungi na bivunde bi musyengi. ");
INSERT INTO puu_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Sason na batu bandi bakefute yisingu yi dyambu ombu bivunde ne bakebasile. ");
INSERT INTO puu_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Na mukolu witoli, baane ba tadji bakewendise Pole na Silase o musyengi Bere. Banotole, bakewende o ndaghu dusambu dji baSwife. ");
INSERT INTO puu_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Djobane bamabe na mutsanu wuboti tsinane baSwife ba Tesalonike. Bakedile Musamu Nzambi na durondu dwotsu. Kale yilumbu, bamakelulange Bisonu bi Nzambi mu ukelule yiri ame bamabatsingulaange mangenze. ");
INSERT INTO puu_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Durangu duneni du batu bakevayile yitu, na va ghari baNgereke: pwele baghetu baghobe na babaale djowandi bakevayile Djesu yitu. ");
INSERT INTO puu_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Tumbe ave baSwife ba Tesalonike bamawulu bwé Pole yike mbembu Nzambi elonzi o musyengi Bere wandi, bakesundili urughe mu yisibise dimbunge va ghari mughungi. ");
INSERT INTO puu_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Vane-vane, baane ba tadji bakewendise Pole o yari yi mubu. Silase na Timote bakesyale o musyengi Bere. ");
INSERT INTO puu_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Pole, amabatsingule djowu abaménebeghaange yi Silase djone Timote batasunu mbangu-mbangu. Bakemutolise o musyengi Atene, mba bakeghabughe o musyengi Bere. ");
INSERT INTO puu_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Temu adji Pole amakelisile Silase na Timote o musyengi Atene, amatsire murime mumbari musyengi wumabe wubase na bakosi. ");
INSERT INTO puu_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Amalonzaange baSwife o ndaghu dusambu na botsu abasamabe baSwife, tumbe bamadumaange Nzambi. Kale yilumbu, amayenelonzaange botsu abamenebengunu nandi. ");
INSERT INTO puu_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Balonzi ba dyele ba Pikire na ba Senu bakerughe muyivose nandi. Bamosi bakevose rye: «Yivovi ayiyi! Yi erondi ututsingule vave?» Abane bakewaghule rye: «Etubuli banyambi ba beni!» Djowu bamavosile nane, mumbari Pole amasamune Musamu Wuboti wu Djesu na durambughulu o dufu. ");
INSERT INTO puu_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Bakemubeghe nowu, tena va wusu fundu dji banzonzi ba musyengi owu, bamanengilaange «Yiropase». Bakemuwivule: «Turungule udjabe divindughulu di musamu éwuwu wughone witubeyili? ");
INSERT INTO puu_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Mumbari yitutsinguli mambu maghone, na twirondi udjabe divindughulu.» ");
INSERT INTO puu_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Bise Atene botsu na beni abamatsana o musyengi eni, temu djotsu yisalu yowu bu uvose vo uwulu musamu wughone. ");
INSERT INTO puu_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Pole, diteli va ghari fundu dji Yiropase, akebonge mbembu: «Bise Atene, nyimalabe yiri dudji batu, abe bédjabi tinde wuyitse bakosi benu. ");
INSERT INTO puu_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Ave nyiyene vyengililaange mu mimbambe myenu, nyiyenelabaange bitumbe bi dighobe abidwiyitsi, na nzirasunu ne yinyenzulu yi paghu na yisonu yéyiyi: “Ombu nyambi adjighédjabunu.” Adji dwiyitsi mba dughedjidjabi, adjine menu nyiruyi oyidulonze. ");
INSERT INTO puu_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Nzambi, djandi omavaghe bulongu na byobivu mune, adji Fumu djulu na butambe, djandi aghetsani mu mandaghu amarungu na batu. ");
INSERT INTO puu_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Aghésalulu na makake ma batu, mba aghane nzale yisalu wotsu. Mumbari djandi oyiveyi botsu monyu, muvumu na byotsu. ");
INSERT INTO puu_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Mu mutu wumosi, amasunde mikute myotsu yiri djowu bakebase butambe bwotsu. Mu bufumu bwandi, Nzambi amasikighe yitsingu yi monyu, na bandilu ma mbure motsanine. ");
INSERT INTO puu_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Nzambi amavaghe nane, yiri bakemurombe ne vadji diweru dyumulabe. Yotsu yine, Nzambi aghavale netu, ");
INSERT INTO puu_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","mumbari batu bévosi rye: “Mu djandi twivumini, twikungili, tubile monyu.” Dyoni dimavosu na bivovi byenu: “Djetu wandi tudji bakule bandi.” ");
INSERT INTO puu_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Kaboghu tubilange bakule ba Nzambi, toghorungule ubaghusunu Nzambi na bakosi ba lore, ba madilu vo ba mamani, abitulu na matase ma batu. ");
INSERT INTO puu_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Nzambi aghékipi temu adji mbé bakamudjabile, tumbe erondi yiri batu botsu, mu mbure tsyotsu, bakesanze mutsanu na umughobise. ");
INSERT INTO puu_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Mumbari Nzambi, amasikighe yilumbu ayi mutu awu djabeni amasole, ososisile batu botsu mu butambe mu dusungughu dwandi. Nzambi amalase kengili kake andi, ave amamurambusile o dufu.» ");
INSERT INTO puu_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Ave djowu bamawululu dyambu di batu abafu bwé boghabughe monyu, abane bamamupedji. Bamosi bamavose rye: «Djetu tuwuwululu mu dyoni temu susu.» ");
INSERT INTO puu_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Na vane, Pole akebasile. ");
INSERT INTO puu_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Va djulu vane, mwa dikabu di batu bamasobene nandi na bamakalughe bakereti. Mu yinombu yeni, vamabe dibaale dimosi mu fundu banzonzi bamanengilaange Deni, mughetu dine dyandi Damarise, na bamosi wandi. ");
INSERT INTO puu_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Va djulu vane, Pole akeghusughe musyengi Atene mu wende o musyengi Korinte. ");
INSERT INTO puu_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Akebengunu na muSwife dine dyandi Akilase, mwise Pon. Amabe na mughatsi andi Pirisile. Djowu mbé basekatsinge nobotughe o bulongu bu Yitali, mumbari kaghe Kolode amaveghe dirume ombu baSwife botsu bakedusughe musyengi Rome. Pole amasobene nowu, ");
INSERT INTO puu_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","mumbari avu na yisalu yimosi nowu, bamarungaange masambe. Adine Pole amatsanine nowu, lake bakesalaange va mosi. ");
INSERT INTO puu_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Kale yilumbu yuvume yi baSwife, Pole amalonzaange o ndaghu dusambu, na djandi amarombaange udute baSwife viri viri baNgereke ombu Fumu. ");
INSERT INTO puu_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Ave Silase na Timote bamadusuyile o yinange yi Masedwane mu tole o Korinte, Pole akesingene yike na yisalu yusamunaange Musamu Wuboti wu Nzambi. Djandi akevindighaange va wusu baSwife yiri Djesu adji Kirisete. ");
INSERT INTO puu_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Tumbe baSwife bamabuse musamu awu Pole, amabasamuninaange na bamamusyenge. Kaboghu Pole amakuke difufundu di bikutu byandi na amabatsingule yi: «Malungu menu mabi mu myuru myenu! Menu nyisyeme. Mudjonge enu bakole. Ubandile na nyangu, nyuwende ombu djowu abagha baSwife.» ");
INSERT INTO puu_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Akebotughe vane na akewende ombu dibaale dine dyandi Tityuse Susutuse, amayitsaange Nzambi. Ndaghu wandi djimabe va mughule ndaghu dusambu dji baSwife. ");
INSERT INTO puu_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Kirisepuse yivunde yi ndaghu dusambu, akevayile yitu ombu Fumu, na mukute andi wotsu. Batu bapwele bise Korinte, bamawululu Pole. Bakevayile yitu yowu mu Nzambi na bakebatusu. ");
INSERT INTO puu_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Mukolu mosi, Pole akedile dulasu, mune Fumu emutsinguli didi: «Wuyala ghome. Tumbe bwela uvose, wuyavole: ");
INSERT INTO puu_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","nyidji naghu. Vagha mutu oghudimbise vo oghukambise, mumbari bapwele bavu bami mu musyengi ewuwu.» ");
INSERT INTO puu_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Pole aketsane yilime yimosi na yibuku o Korinte, amalonzaange ombu botsu musamu Nzambi. ");
INSERT INTO puu_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Mu temu adji Ghalyone amabilaange yivunde yi musyengi Rome mu yinange yi Akaye, baSwife bamawulusunu mu ufwengilile Pole. Bakemubeghe o ndaghu bunzonzi. ");
INSERT INTO puu_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Baketubule yi: «Dibaale dyédidi erondi utsotse batu mu yitsaange Nzambi mu duvyakusunu du mughaghe etu.» ");
INSERT INTO puu_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Pole mbé aronde uvose, ave Ghalyone amawaghulili baSwife: «Djenu baSwife, mbé yi mutu atsiboke vo dyambu dibi atsivaghe, mbé nubo temu djuduwulu, notabule bunzonzi. ");
INSERT INTO puu_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Tumbe dibila yiri, mutsundu mu dyambu di bighume, mine, vo di mughaghe djenubeni, dyoni didutsuni. Nyibusi ube nzonzi dji mambu nane!» ");
INSERT INTO puu_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Na akebapalise. ");
INSERT INTO puu_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Kaboghu, botsu bakeghange Sosetene, yivunde yi ndaghu dusambu, na bakemudimbe va mune ndaghu mighaghe. Tumbe Ghalyone asamadilabe yi dyambu. ");
INSERT INTO puu_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Pole akesyale mu yitsingu o Korinte. Akekakene na baane ba ngudji, akenangeme mu watange djone Pirisile na Akilase na bakewende o Siri. Ne akebotughe musyengi, mu disabu di Senkire, amafughe muru, mumbari amava pangini ombu Nzambi. ");
INSERT INTO puu_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Banotole o musyengi Yifese, Pole akesile Pirsile na Akilase. Akewende o ndaghu dusambu na akevose na baSwife. ");
INSERT INTO puu_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Djowu bakemuwivule usyale yitsingu, tumbe asamasinge. ");
INSERT INTO puu_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Akebasile novose: «Nughabughe ombu wenu, pa Nzambi atsisinge.» Akenangeme mu watange mu botughe Yifese, na akewende. ");
INSERT INTO puu_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Anotole o musyengi Sesaré, akelewé o Serusaleme musimbe dibundu, mba akewende o Antyose. ");
INSERT INTO puu_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Akevyose mwa pesu temu o Antyose, mba akewende. Aketabe yinange yi Ghalasi na Firisi, mu warise yitu yi badukitsi botsu. ");
INSERT INTO puu_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Mu temu édjine, vamabe muSwife dine dyandi Apolose, mwise Alesanderi, aketole o Yifese. Amabe dibaale dimavosaange na buketi, amadjabaange burange Bisonu bi Nzambi. ");
INSERT INTO puu_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Amalongu mu dyambu di Nzile Fumu, amatubulaange nolonze na yusile yotsu mu dyambu di Djesu. Amalonzu yike musamu dubatusu du San. ");
INSERT INTO puu_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Amavose na ngenze djotsu o ndaghu dusambu. Banomane umuwulu, Pirisile na Akilase bakemubonge mu mutsingule kengili Nzile Nzambi. ");
INSERT INTO puu_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Va djulu vane, Apolose amaronde uwende o Akaye. Baane ba ngudji bandi ba babaale na baghetu bakemuwarise mu dwendu dweni. Bakerende mughande ombu badukitsi ba yinange yéyine, yiri bakemudile ndilulu djiboti. Na etoli, amawamuse pwele, abamasinge Fumu, bakela ubwedji mu yese yi Nzambi. ");
INSERT INTO puu_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Amavovene na baSwife mu ubuse mambu mowu va wusu batu botsu. Mu Bisonu bi Nzambi, amabalase yiri Djesu adji Kirisete. ");
INSERT INTO puu_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Temu adji Apolose abile o Korinte, Pole aketabe yinange yi mukongu na aketole o Yifese. Akerasunu badukitsi ");
INSERT INTO puu_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","na ewivuli: «Dutsidile Yinyuni Yisyeme, ave dutsivayile Fumu yitu?» Bakemuwaghule yi: «Vyaghe! Tukawulu uvose adi Yinyuni Yisyeme.» ");
INSERT INTO puu_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Kaboghu Pole akebawivule: «Dubatusu yi dumadile?» Bakewaghule: «Dubatusu du San.» ");
INSERT INTO puu_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Pole ebatsinguli: «San amabatise bobamasinge wukalughe mitsanu noghobise Nzambi. Amatsingule batu yiri: “Vayilanu yitu mu Djesu, owurughe va djulu ami.”» ");
INSERT INTO puu_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Banomane uwulu bighume byeni, akebabatusu mu dine di Fumu Djesu. ");
INSERT INTO puu_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Pole akesakighe makake mu djowu na Yinyuni Yisyeme yike baveghu. Bakevose mu mambembu masusu na bakebighe mu dikabu di Nzambi. ");
INSERT INTO puu_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Babaale beni bamabe dighumi na babedji (12) mu botsu. ");
INSERT INTO puu_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Kale yilumbu yuvume yi baSwife, Pole amawendaange o ndaghu dusambu. Mu ngondi yiryeru, amabonge mbembu na ngenze. Amavose mu Bukaghe bu Nzambi na amawarise ubawulusu. ");
INSERT INTO puu_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","BaSwife bamosi bamabuse uvayile yitu, bakepedji abamaduke Nzile Fumu va wusu dibundu. Mba Pole akekakene nowu, akenebeghe badukitsi nandi. Bilumbu byotsu akebavosilaange o ndaghu yinenge dji mutu, benengili Tiranuse. ");
INSERT INTO puu_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Dyoni dimatsinge bilime bibedji. Va disukusulu, batu botsu abamatsana mu yari yi Asi, baSwife na bagha baSwife, bakeghulu musamu Fumu. ");
INSERT INTO puu_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Nzambi amadughusu bimaghe bineni mu makake ma musatsi andi Pole. ");
INSERT INTO puu_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Bamasunzaange miswari vo bikutu abimabembaange dunyuru dwandi mu bibedu. Bibedu byeni bimabelughaange mu mali mowu na binyuni bibi bimapala mu djowu. ");
INSERT INTO puu_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","BaSwife bamosi, bamawendaange mbure na mbure mu syanze binyuni bibive. Bamaronde usyanze binyuni bibive mu dine di Fumu Djesu. Bamatsingula binyuni bibi: «Nyiduve dirume, dupale mu dine di Djesu adji Pole etubuli!» ");
INSERT INTO puu_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Vamabe yivunde yimosi yi bavaghulitsi ba paghu ba baSwife, dine dyandi Seva. Yisambwali yi bane bandi, djowu bamavaghe mambu meni. ");
INSERT INTO puu_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Tumbe yilumbu yimosi yinyuni yibi yimabawaghule: «Nyidjabi Djesu na nyidjabi anyi avu Pole. Tumbe djenu, bani duvu?» ");
INSERT INTO puu_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Na djandi omabe na yinyuni yibi, akekébwaghe mu djowu mu lase yi abavyoghulile djobotsu mangolu. Amabatsoyise na bukani, na bakerine ndaghu eni, peni-wangi na mapure. ");
INSERT INTO puu_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Adimavyoghe dimadjabunu na bise Yifese. BaSwife na baNgereke bamabase na ghome, bakedjabe durumu du Nzambi na buneni bu dine di Fumu Djesu. ");
INSERT INTO puu_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Bapwele abamavayile yitu, bamarunga mu yidjabise mabi ame bamavaghaange. ");
INSERT INTO puu_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Yinombu yeni yi batu ayimasalise ngalu, bamabeghe mabuku mowu na bamamanyenze va wusu batu botsu. Tumatale dufunu du mabuku meni: dumaveghe dighumi di senzu (50 000) tsi mbongu. ");
INSERT INTO puu_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","La nane mu mangolu ma Fumu, musamu wumanyavaange na wumalasaange mangolu mapwele. ");
INSERT INTO puu_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Va djulu mambu meni, Pole akeghane kake djutabe Masedwane na Akaye, nowende o Serusaleme. Amavose nane: «Nyinowende, mbé nyutole o musyengi Rome wandi.» ");
INSERT INTO puu_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Aketinde o yinange yi Masedwane Timote na Yirase, abamasala yisalu yowu nandi. Tumbe amasyale djabeni mwa temu o yari yi Asi. ");
INSERT INTO puu_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Va temu eni, vamabe kimbu djineni o Yifese, dibandu djowu abameneduka Nzile Fumu. ");
INSERT INTO puu_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Vamabe mutulitsi bapange, dine dyane Demeteyuse, amavaghe mandaghu magheyi ma nyambi owu mughetu, dine dyandi Artemise. Mandaghu meni mamavegha madile mapwele ombu batulitsi botsu. ");
INSERT INTO puu_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Akebaghukighe, na botsu abedjabi yisalu nane yine, na akebatsingule: «Bambatsi, dwidjabi yi maboti meruyili mu yisalu yéyiyi. ");
INSERT INTO puu_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Tumbe dwilabi na dwiwulu adivyoyi: mutu awu bénengili Pole etubuli yiri, banyambi abevaghu na makake ma batu, bagha banyambi bangenze! Aborungule ubembe bapwele tsike bu ghunu o Yifese, tumbe na mu yari yetu yotsu yi Asi. ");
INSERT INTO puu_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Dyoni mbé dyubivise yisalu yetu, notsyemuse didume di ndaghu nyambi etu Artemise, obeyitsi mbure tsyotsu mu yari yi Asi na mu bulongu bwotsu.» ");
INSERT INTO puu_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Mu mambu meni, abamawulu bakebase na kabu na bakeghamughe: «Yivunde djandi, Artemise dji bise Yifese!» ");
INSERT INTO puu_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Mupuki wukedughunu mu musyengi wotsu. Batu bakenebeghe Ghayise na Arisitareke, bise Masedwane babedji, bamabe nandi mu mulingu na Pole. Yinombu yikewé mbangu o mbure bibengunu bi mighungi. ");
INSERT INTO puu_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Pole amabe na nzale ulabene va wusu yinombu, tumbe badukitsi bakemughandise. ");
INSERT INTO puu_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Bidjeti bi Asi bamabe bambatsi bandi, bakemutindile yilumbi yumutsingule, akéwende o mbure bibengunu bi yinombu. ");
INSERT INTO puu_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Mu temu eni, dibundu bamabe mu nkumfu. Basusu bamaghamugha dyambu dimosi, bamosi dimosi. Bapwele va ghari owu basamadjabaange dibandu yi bamaghukimine. ");
INSERT INTO puu_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","BaSwife bamasindighe mutu o wusu, dine dyandi Alesandere. Akenangule dikake mu votse yinombu, mubavosile nobonge dikabu di baSwife. ");
INSERT INTO puu_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Tumbe na batu bédjabi yiri muSwife, bakeghamughe djobotsu va mosi mu maweru mabedji: «Yivunde djandi nyambi Artemise dji bise Yifese!» ");
INSERT INTO puu_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Anomanisile, yirende-rende yi musyengi akerungule usiyighe yinombu novose: «Bise Yifese, batu botsu bédjabi yi bise Yifese bakelitsi ba ndaghu Artemise, yibaghunu yandi yibonduyi o djulu. ");
INSERT INTO puu_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Vagha mutu wughale. Mu dyoni, mbé dusigheme notase ne duke salise. ");
INSERT INTO puu_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Dutsibeghe vave batu abaghabunge nosyenge Nzambi etu. ");
INSERT INTO puu_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Pa Demeteyuse na bambatsi bandi ba bisalu bane mufundu na mutu, bawendi ombu banzonzi aborungule utabule dyambu. Babeyi mufundu ghune. ");
INSERT INTO puu_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Na pa dune dyambu dimosi duvu na nzale ulase, tudinonze va ghari dibundu adiwelmine. ");
INSERT INTO puu_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Mbé tufwengululu yiri tudji mimbini, mu dyo ditsivyoghe na nyangu, mbé tughorungule ukekaghule. Va djulu mambu meni, akekungise mughungi.» ");
INSERT INTO puu_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Musighe wunoghabughe, Pole akeghukighe badukitsi nobawarise, mba akebaghanine nowende o Masedwane. ");
INSERT INTO puu_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Akesabughe yari yeni, nowarise bakereti bapwele ave amavosilaange nowu. Va djulu vane, akewende o Ngerese ");
INSERT INTO puu_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","o amatsanine miweli miryeru. Mbé aronde unangeme mu watange nowende o Siri, ave amawululu yi baSwife bamamutungile fundu. Kaboghu, akesitighe muvyoyile adu Masedwane. ");
INSERT INTO puu_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Batu abamawendaange nandi: Sopate mwane Pirise mwise Bere, Arisitareke Sekunduse bise Tesalonike, Ghayise mwise Derebe, Timote, Tisike na Torfime bise yari yi Asi. ");
INSERT INTO puu_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Bane bakerele notukele o musyengi Torwase. ");
INSERT INTO puu_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Yoyine djetu tumanangeme mu watange, mu wende o Filipe, yike mumengu wu bapembi abaghane dufunusu wisuki. Bilumbu biranu va djulu, tumabadale o Torwase o tumavyosile tsone mosi. ");
INSERT INTO puu_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Mu yilumbu yiteghe yi tsone, tumabe tughukeme mudji va mosi. Pole amalonze dibundu, amavose pwele tena ghari wisi, mumba mbé owende va kedi. ");
INSERT INTO puu_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Balambi bapwele bamabe o kilingu ndaghu adjitumabe. ");
INSERT INTO puu_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Mwa munzambu wumanengulungu Yitikise amatsane va nele ndaghu. Akewende yilu yineni ave Pole amavosila. Yilu yimavyoghulile, tena ave amabonduyile kilingu adji muryeru teno tsi. Akefu. ");
INSERT INTO puu_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Pole akevindeme, akemunaghule novose yi: «Dundanu wunyonge, adji monyu.» ");
INSERT INTO puu_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Mba akemate, akeghabe pembi nodji. Yike emani akemwévose tinde yitsingu tena kedi, mba akewende. ");
INSERT INTO puu_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Bakeghabuse munzambu monyu na dyoni dikebe tinde duwarusu ombu botsu. ");
INSERT INTO puu_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Tumarele uwende mu watange adjimatubeghe o musyengi Asose, o mbé tubongile Pole. Anane amakinzile, mumba amabe na nzale uwendile mu mumbambe. ");
INSERT INTO puu_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Anoturasene o Asose, tukemunangighe mu wende o musyengi Mitilene. ");
INSERT INTO puu_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Vane, tukewende mu watange. Yilumbu ayimaduke tukebambene na ningi Kyo. Yilumbu yi djulu, tuketole o ningi Samose, mba ayinzime tukedale musyengi Mile. ");
INSERT INTO puu_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Pole, asamaronde usikeme o musyengi Yifese, mumba diweru dikévyoghe o yari yi Asi. Amavungilaange utole o Serusaleme, pa mbé dyurungule ube yilumbu yi Patekote. ");
INSERT INTO puu_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","O musyengi Mile, Pole aketinde yilumbi o dibundu di Yifese mu yélande bivunde byowu. ");
INSERT INTO puu_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Banotole va mughule andi, akebatsingule yi: «Dwidjabi nane nyimatsanine nenu, ubongile va yilumbu yiteghe ayi nyimaruyile o yari yi Asi. ");
INSERT INTO puu_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Nyimasalile Fumu na divole-mbombu, na matsange na maghughe amenyimalabe dibandu bikumbu bi baSwife. ");
INSERT INTO puu_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Dwidjabi yi nyisamasweghe ne dimosi mu motsu amawelimine. Nyimadulonze notsingule motsu, na va ghari batu na mu mandaghu menu. ");
INSERT INTO puu_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Nyimanengile baSwife na baNgereke mukalughe dyele na Nzambi, novayile Fumu etu Djesu yitu. ");
INSERT INTO puu_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Mba vave, yike o Serusaleme nyiwendi, nane Yinyuni Yisyeme yinzindiyili. Tumbe, ngedjabi adyutuyile ghune. ");
INSERT INTO puu_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Nyidjabi yi mu kale musyengi, Yinyuni Yisyeme yindubusi yiri, tsughu na maghughe bikeli. ");
INSERT INTO puu_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Tumbe, monyu ami wughane tsongu va wusu ami. Adimbuli murime, uwende teno disukusulu mu manisile yisalu ayi Fumu Djesu amapeghe. Diwendili rye: wulonze Musamu Wuboti wu yese yi Nzambi.» ");
INSERT INTO puu_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","«Nyimavyose temu nolonzange Bukaghe bu Nzambi, tumbe nyimadjabe yi vagha ne wumosi va ghari enu omwéndabe. ");
INSERT INTO puu_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Ladibandu, nyidubongili na muni nane bambedji: yike wumosi va ghari enu etsyemuyi, nga mune dighénzuni. ");
INSERT INTO puu_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Mumba nyimadulonze motsu ame Nzambi amasitighe, ne dimosi nyisamasweghe. ");
INSERT INTO puu_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Dukebene djenubeni, na kelisanu mughambe, awu Yinyuni Yisyeme amaduveghe. Bandekenanu dibundu di Nzambi adi amadile mu malungu ma mwane andi. ");
INSERT INTO puu_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Nyidjabi yi ave nyuwendile, batu bavu nane baminzi ba bukani bokote va ghari enu mba mughambe wughovengusu. ");
INSERT INTO puu_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Mba ne va ghari enu, batu bofuraange mu dute badukitsi. ");
INSERT INTO puu_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Moghanu kaboghu! Rangeminanu yi, mu bilime biryeru, na nyangu na mukolu, nyisamadunde ulile mu ulubuse kale mutu. ");
INSERT INTO puu_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","Vave, nyiduwakise ombu Nzambi na musamu wu yese yandi. Ane musughe uduwarise mu yitu, noduveghe disyale adi asweyile bandi. ");
INSERT INTO puu_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Nyisamavonde badoli na lore, vo bikutu bi wotsu ke mutu. ");
INSERT INTO puu_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Dwidjabi yi nyimasale na makake mami, mu dile abimabe biwelimine na abamandukaange. ");
INSERT INTO puu_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Nyimadulase mu motsu yusale abwedji mu wamuse abadede. Mbé turangiminanu ame djabeni Fumu Djesu amavose: “Uveghe atsivyo uveghu nzangu.”» ");
INSERT INTO puu_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Yike emani uvose, Pole akekuteme nowu nosambile. ");
INSERT INTO puu_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Botsu bamalile pwele na matsange mu misu, bakevyunge Pole mu kingu nomughumbesene. ");
INSERT INTO puu_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Bamaningaange mumba Pole amavose yi aghoghabughe. Bakeyemuvetsighe tena o watange. ");
INSERT INTO puu_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Tunokakene nowu, tukesungeme o ningi Kose mu watange, yilumbu ayimadukaange tuketole o ningi Rode. Yilumbu ayimaduke tukewende o ningi Patare. ");
INSERT INTO puu_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Tumadale watange djimawendaange o yinange yi Fenisi, tumabwénangeme noyenewende. ");
INSERT INTO puu_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Tunolabilile ningi Sipere, tumavyole o maghetu mu wende o yari yi Siri. Tukesikeme o musyengi Tire o watange djimabe na mufune wusunduse. ");
INSERT INTO puu_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Tumarasene badukitsi na tumatsane tsone nowu. Banolubusu na Yinyuni Yisyeme, bamaghandise Pole uwende o Serusaleme. ");
INSERT INTO puu_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Tumbe tsone eni djinovyoghe, tukebongulile nzile. Djowu botsu bakétuvetsighe, na baghetu na bane, teno dikotulu di musyengi. Tuke kuteme va disimu di mubu nosambile Nyambi. ");
INSERT INTO puu_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Tunoghanesene kale mutu, tumanangeme mu watange. Djowu bamaghabughe mu mimbu mowu. ");
INSERT INTO puu_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Tumamane disabu dyetu, urambuyile o Tire teno musyengi Tolemayise. Tunomane usimbe baane ba ngudji o musyengi eni, tuketsane nowu yilumbu yimosi. ");
INSERT INTO puu_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Yilumbu ayimaduke, tukesogheme notole o musyengi Sesaré. Vane, tukekote o ndaghu Filipe, musamunitsi wu Musamu Wuboti na tuketsane ombu wandi. Amabe wumosi va ghari yisambwali yi batu, abamasolu o Serusaleme mu wamuse bakwili. ");
INSERT INTO puu_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Amabe na baane bana ba baghetu bamabe batsyemi, bamabighaange. ");
INSERT INTO puu_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Mbé tuke bilumbu bipwele vane, ave mubiyitsi winengulu Aghabise amaruyile o Sudé. ");
INSERT INTO puu_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Akebambene netu, akebonge beleti dji Pole, akekétunge makulu na makake na djoni novose yi: «La adi Yinyuni Yisyeme evosi: “Fumu beleti adjidji otungu nane na bivunde bi baSwife ba Serusaleme, mba bomuwakise ombu beni.”» ");
INSERT INTO puu_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Tunowulu mane, djetu na baane ba ngudji ba Sesaré tumalende Pole akéwende o Serusaleme. ");
INSERT INTO puu_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Tumbe akewake yi: «Mumba yi dililili nondetse manyuru? Nyikunzeme mutungu na muboku o Serusaleme dibandu Fumu Djesu.» ");
INSERT INTO puu_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Dibilaange yi tusamarungule umusanze ditase dyandi, tumadunde utsiyise novose yi: «Durondu du Fumu duvaghu.» ");
INSERT INTO puu_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Mwa bilumbu binovyoghe, tukekunzeme nomate o Serusaleme. ");
INSERT INTO puu_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Badukitsi ba Sesaré bamawende netu, baketutsanise ombu Nasone, mwise Sipere, awumabe mudukitsi vane kale. ");
INSERT INTO puu_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Ave tumatolile o Serusaleme, baane ba ngudji bamatusangile na nzangu. ");
INSERT INTO puu_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Yilumbu ayimaduke, Pole akewende netu ombu Sake, o bivunde byotsu bi dibundu bimaghukemine. ");
INSERT INTO puu_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Pole akebasimbe nobatsingule bikumbu byotsu nane Nzambi amasalile ombu abagha baSwife. ");
INSERT INTO puu_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Banomuwulu bakedodise Nzambi. Mba bakevaghe Pole yi: «Wilabi, mwane-ma, tosini kwe tsi baSwife bamasinge Djesu. Djobotsu baname na Mughaghe Moyise. ");
INSERT INTO puu_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Yotsu yine la adi bamabatsingule: “Wilongi baSwife botsu abetsani va ghari malongu masusu, yi badundi Mughaghe wu Moyise. Wibatsinguli yi bayamwérebaange baane bowu na bayamwéduke mighulu mi djetu baSwife.” ");
INSERT INTO puu_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Tsyé tuvale? Bodjabe yi wumarughe. ");
INSERT INTO puu_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Kaboghu, vaghe adi tiwutsinguli. Vave, vadji babaale bane netu batsi leve pesi ombu Nzambi. ");
INSERT INTO puu_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Babeyi, djenu botsu yétsyemuswanu va wusu Nzambi. Fute byotsu mumbari bakefughu myuru. Pa dutsivaghe nane, batu botsu bodjabe yi vagha ngenze mu adi batsiwuvosile, tumbe ndewandi wighobisi mughaghe Moyise. ");
INSERT INTO puu_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Mu bise malongu abamasinge Djesu, tutsibarendisile mu batsingule yi: bayabwedji banyame atsivaghulu ombu bakosi vo banyame atsighaghewu kingu mu palise malungu, mba bayavaghe bumbembu.» ");
INSERT INTO puu_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Yilumbu ayimaduke, Pole akebeghe batu beni babane bakekésyemise djobotsu. Akewende o ndaghu Nzambi notsingule yilumbu ayi bovaghulile paghu na dutsyemusu du mutu-mutu dusukile. ");
INSERT INTO puu_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Yisambwali yi bilumbu mbé yike usuke, ave baSwife ba yari yi Asi bamalabile Pole o dulombili du ndaghu Nzambi. Bakenangule mughungi wotsu, bakemughange, ");
INSERT INTO puu_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","noghamughe yi: «BaYisrayele, tuwamusyanu! La mutu awilonzi batu botsu mbure tsyotsu dilongi di kondenyonde na mukute Yisrayele, mughaghe etu na mbure djisyeme. Amakotise ne abagha baSwife mu mbure édjidji na bamadjibivise.» ");
INSERT INTO puu_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Pa bamadisalise, mbari bilumbu abiteghe bamalabe Torfime mwise Yifese djone Pole bamayenewendaange mu musyengi Serusaleme. Bamasingene yi Pole amamukotise o dulombili du baSwife, tumbe bamabe na mbele. ");
INSERT INTO puu_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Dimbunge dikelave mu musyengi wotsu, mba batu bakepalile yari na yari na bakeghukeme. Batu bakeghange Pole, nomupalise o dulombili du ndaghu Nzambi, adji bamalenge nobindighe dikotulu. ");
INSERT INTO puu_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Mbé baronde uboke Pole, mu temu eni abemoyi bamayétsingule yivunde yi baghore ba Rome, yi Serusaleme djotsu ukunge djikungi. ");
INSERT INTO puu_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Vane-vane yivunde akebonge baghore na bivunde byowu, nowende mbangu o mughungi. Banolabe yivunde, bakedunde udimbe Pole. ");
INSERT INTO puu_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Yivunde akebambene nandi, akemughangise nomutungise na pange bedji. Mba akewivulu dine dyandi na dyambu adi amavaghe. ");
INSERT INTO puu_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Tumbe mu mughungi, abéba bamaghamughaange didi, bane bamaghamughaange disusu. Yivunde mbé aghorungule ughangise dyambu na tsikiri dibandu nkumfu. Akeveghe dirume dyubeghe Pole o ndaghu baghore. ");
INSERT INTO puu_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Pole anotole vo bande yikadi, baghore bakemunangule, dibandu dikani di mughungi. ");
INSERT INTO puu_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Mumba batu bapwele bamamudukaange, noghamughe yi: «Afu!» ");
INSERT INTO puu_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Ave bamakotisilaange Pole o ndaghu baghore, akevaghe yivunde yi: «Nine musughe uvose mwa dyambu?» Yivunde amasutu, nomuwivule yi: «Widjabi uvose mbembu baNgereke? ");
INSERT INTO puu_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Kaboghu wughaa mwise Yisipete awumarombise didjunge, nobeghe tosini-djina (4 000) tsi batu na bitoghulu byowu o kumu dji ghumughe?» ");
INSERT INTO puu_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Pole amawaghule yi: «Menu muSwife, uburulu o Tarese dji Silisi, mutsighe musyengi awughélibunu. Kokolu tsyaghu, singe ngavose na mughungi.» ");
INSERT INTO puu_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Yivunde akemusingile dyoni. Pole, diteli va djulu yikadi, akesambe dikake ombu mughungi mudile duvotsu. Botsu bakevole «swii», mba akebavosile mu mbembu baEberu. ");
INSERT INTO puu_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","Pole akevose na mughungi yi: «Djenu duvu mukute wumosi nami, tséwulwanu adingivose mu kékaghule.» ");
INSERT INTO puu_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Banowulu yi ebavosili mu mbembu baEberu, bakebwele usigheme. Kaboghu Pole akeghamughe: ");
INSERT INTO puu_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","«Nyidji muSwife, uburulu o Tarese dji Silisi. Tumbe nyimabanguyile vave Serusaleme, na nyimalongu na Ghamalyele omandonze mughaghe ba tadji betu na tsikiri. Nyimabe na yusile mu dyambu di Nzambi, nane duvu na muni. ");
INSERT INTO puu_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Nyimakwane abamadukaange Nzile Fumu teno dufu. Nyimatinde baghetu na babaale o tsughu. ");
INSERT INTO puu_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Yivunde yi bavaghulitsi ba paghu na fundu djotsu dji bivunde bi mukute, borungule ughabuse bumbedji yi dingenze nyivosi. Djobeni bamapeghe ne mighande mi musughe muyéveghe baane ba ngudji ba baSwife ba Damase. Nyimawende o musyengi eni mughange badukitsi ba Nzile Fumu abamabe wune, nobabeghe batungu o Serusaleme mu bakilise. ");
INSERT INTO puu_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","Va mwangulu ave nyangu ebile va djulu muru, nyimabe mu nzile beli na Damase. Suke, yidjalale yineni ayimarambuyile o djulu yimankandile va mbure adji nyimabe. ");
INSERT INTO puu_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Nyimaberughe vatsi nowulu dyufi dimavose yi: “Sole, Sole, dibandu yi winkwanini?” ");
INSERT INTO puu_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Nyimawivulu yi: “Nde la nyi, Fumu?” Akekwaghule yi: “Menu la Djesu mwise Nasarete, awu wikwani.” ");
INSERT INTO puu_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Abamabe nami bamalabe yidjalale, tumbe basamawulu dyufi di djandi omavosaange. ");
INSERT INTO puu_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Nyimamuwivulie rye: “Yi nyuvaghe, Fumu?” Fumu amapaghe yi: “Releme, wende o musyengi Damase. Mba vane bowutsingule motsu ame wuvaghe.” ");
INSERT INTO puu_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Dibilaange yi yidjalale yeni yimapaghe yidunge, abamabe konge nami, bamankaange mu dikake teno musyengi Damase. ");
INSERT INTO puu_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","Vane vamabe Nanyase, dibaale dimaghobisaange Nzambi nodedile mughaghe. BaSwife botsu ba Damase bamamughobisaange. ");
INSERT INTO puu_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Amayitasene, akebe va mughule ami nopaghe yi: “Sole, mwane ngu ami, bongulile ulabe!” Vane temu eni, ngamwélabe. ");
INSERT INTO puu_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Amabwele yi: “Nzambi bakaaghe betu amawusole kale wukedjabe durondu dwandi, na wukelabe djandi o Asungeme nowulu dyufi dyandi. ");
INSERT INTO puu_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Mumba wube mbedji andi va wusu batu botsu, mu wanze adi wutsilabe nowulu. ");
INSERT INTO puu_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Ka mumba yi wumwékelise? Releme, batusu notandu mabi maghu, nonengile dine dyandi.”» ");
INSERT INTO puu_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","«Nyimaghabughe o Serusaleme, yoyine nyimasambilaange o dulombili du ndaghu Nzambi, ngadile dulasu du Nzambi. ");
INSERT INTO puu_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Nyimalabe Fumu omanzingule yi: “Lenge noghusughe Serusaleme, mumba abetsani wune baghosinge bumbedji bwaghu mu menu.” ");
INSERT INTO puu_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Menu nyimawake yi: “Fumu, bédjabi yi nyimawendaange mu mandaghu motsu ma tsambu ma baSwife, mu dimbise bango yitu mu ndedju, nobatinde o tsughu. ");
INSERT INTO puu_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Mba ave malungu ma mbedji awu Yityene mamadekila, me wa nyimabe vane. Nyimasingisile abamamubokaange, nyimakele ne bidwaru bi abamamuboke.” ");
INSERT INTO puu_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Fumu amanzingule yi: “Wende, mumba nyuwutinde vale, ombu mikute misusu!”» ");
INSERT INTO puu_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Mughungi wuke wulu Pole tena posulu djusite. Mba botsu bakeghamughe: «Tutsyemusyanu mutu eni wughu! Afu! Asawelemine utsane va butambe bwébubu!» ");
INSERT INTO puu_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Bamaghamughaange, bakevulaange bikutu byowu, mba baketindaange difufundu na djulu. ");
INSERT INTO puu_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Yivunde yi baghore akeveghe dirume dyukotise Pole o ndaghu baghore nomudimbe mikase, mumba akevose mu udjabe dibandu yi mughungi wimughamuyili. ");
INSERT INTO puu_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Tumbe ave bamamutungile mu umudimbe, Pole akewivule yivunde ayimabe vane yi: «Dune musughe wu udimbe mwise Rome mikase, awughaa ne wufundusu?» ");
INSERT INTO puu_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Na ewulu nane, yivunde yi baghore akelubuse yivunde yandi: «Akemuvaghe yi tsyé wuvale? Dibaale dyédidi mwise Rome!» ");
INSERT INTO puu_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Yivunde yi baghore akeyilabe Pole nomuwivule yi: «Nzinguli, ngenze wudji mwise Rome?» Pole akewaghule yi: «Yine.» ");
INSERT INTO puu_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Yivunde yi baghore akewake yi: «Nyimaveghe mbongu tsipwele mu udile musughe wunengulu “mwise Rome”.» Tumbe Pole akevose yi: «Menu mwise Rome mu duburulu dwami.» ");
INSERT INTO puu_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Suke, abe mbé baronde umudimbe mu umuvosise, bakekakene nandi. Djabeni yivunde yi baghore akebe na ghome, ave amadjabile yi amatungise mwise Rome na bapange. ");
INSERT INTO puu_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Yivunde yi baghore amabe na nzale udjabe tsikiri adibamafwengilile Pole. Ladibandu, va kedi amamunyangulile nonengile bivunde bi bavaghulitsi ba paghu na fundu djotsu dji banzonzi ba baSwife. Mba akebeghe Pole va wusu owu. ");
INSERT INTO puu_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Pole akesikighe yiswisu mu fundu dji banzonzi ba baSwife, novose yi: «Bane ba tadji, na matase malyome, nyisalili Nzambi tena na muni.» ");
INSERT INTO puu_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Yivunde yi bavaghulitsi ba paghu Ananyase, akeveghe musughe ombu bobamabe beli na Pole, wumudimbe mu munu. ");
INSERT INTO puu_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Kaboghu Pole akevaghe yi: «Nzambi aléwudimbe, na deti aghu! Wutsane vane mu ufundise nane mughaghe wirondili, mba wumabise mughaghe noveghe mu usughe wu undimbe!» ");
INSERT INTO puu_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Abamabe va mughule Pole, bakemutsingule yi: «Yivunde yi bavaghulitsi ba paghu yi Nzambi wisyengi!» ");
INSERT INTO puu_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Pole akewaghule yi, «Bane ba tadji, ngadjabaange yi yivunde yi bavaghulitsi ba paghu. Ngenze, Bisonu bi Nzambi bivosi yi: “Wughovose dibi mu yivunde yi mukute aghu!”» ");
INSERT INTO puu_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Pole amadjabaange yi fundu djimabe djibase yari ayéyi baFarisi, yari ayine baSadisi. Ladibandu, amaghamuyile va wusu fundu dji banzonzi: «Bane ba tadji, nyidji muFarisi, mwane muFarisi. Nyifundusulu, mumba nyivu na yitu mu durambughulu du abafu.» ");
INSERT INTO puu_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Mbé asekamane ne uvose, baFarisi na baSadisi bakebande utsunde, mba vakebe dupasu va ghari owu. ");
INSERT INTO puu_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","BaSadisi, bévosi yi vagha durambughulu o dufu, bemwévose yi vagha byanze na binyuni. Yotsu yine, baFarisi bémasingi yi mangenze. ");
INSERT INTO puu_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Mighamu yike la viri. Milonzi mi mighaghe, abamabe na baFarisi, bakereleme notsunde na yikanene: «Tughélabi dibi mu mutu éwuwu. Tangudji yinyuni vo yanze yitsimuvosile?» ");
INSERT INTO puu_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Mutsundu wukevyoghulile, tena yivunde yi baghore amawulu ghome bakéboke Pole. Ladibandu, amaveyile baghore bandi dirume dyuyébapatule Pole, nomughabuse o ghari ndaghu baghore. ");
INSERT INTO puu_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Mukolu awumaduke, Fumu akelabene na Pole nomutsingule yi: «Ware! Wutsikabusile bumbedji o Serusaleme, na diwelimine wukelase bumbedji o musyengi Rome wandi.» ");
INSERT INTO puu_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Va kedi adjimaduke, baSwife baketunge fundu. Bakeleve pesi yi baghodji vo unu, pa bakaboke Pole. ");
INSERT INTO puu_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Abamatunge fundu eni, bamabe bavyoghe maghumi-mana (40). ");
INSERT INTO puu_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Bakérasene bivunde bi bavaghulitsi ba paghu na bivunde bi baSwife, mu batsingule yi: «Tutsileve pesi va wusu Nzambi yi tughodji yisalu, pa tukaboke Pole. ");
INSERT INTO puu_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Kaboghu, djenu na fundu djotsu dji banzonzi, vaghanu yivunde yi baghore akebeghe Pole, dukefure yi dwirondi ukelule dyambu dyandi na burange. O yetu yari, tukunzeme mu muboke ne aketole vave.» ");
INSERT INTO puu_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Tumbe mwane-katsi Pole, mwane yibusi yandi, amawulu fundu eni. Akewende o ndaghu baghore, akekote nolubuse Pole. ");
INSERT INTO puu_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Kaboghu Pole akenengile yivunde yi baghore yimosi nomuvaghe yi: «Beghe munzambu éwuwu ombu yivunde, mumba ane mwa dyambu erondi umutsingule.» ");
INSERT INTO puu_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Yivunde akemubeghe ombu yivunde yandi, novose yi: «Mwise tsughu winengulu Pole, atsipaghe nga wubeyile munzambu eni wuwu, mungo dyambu dyuwutsingule.» ");
INSERT INTO puu_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Yivunde yi baghore akebonge munzambu mu dikake, akevengeme nandi nomuwivule yi: «Yi wirondi unzingule?» ");
INSERT INTO puu_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Akewake yi: «Bidjeti bi baSwife batsiwulusunu mu wuwivule yi wukebeghe Pole mughese va wusu fundu djotsu dji banzonzi. Bofure yi bérondi uwulu dyambu dyandi burange. ");
INSERT INTO puu_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Tumbe wuyabavayile yitu! Mumba abémutungili fundu bavyoghe ne maghumi-mana (40) ma batu. Batsileve pesi va wusu Nzambi yi baghodji vo unu, pa bakamuboke. Bamakunzeme na békeli yike musughe aghu.» ");
INSERT INTO puu_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Yike emani urume munzambu yi ayavose dyambu dyeni na mutu, yivunde yi baghore akemughabuse. ");
INSERT INTO puu_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Mba yivunde yi baghore akenengile batsyengi bandi babedji nobarume yi: «Ghukighanu kame-bedji (200) tsi baghore, na maghumi-dusambwali (70) ma babeyitsi ba bibulu na kame-bedji (200) tsi babaale na makongu, na banu djenu botsu na dubayi duwende o Sesaré, va maweru maryéru ma tsisighe. ");
INSERT INTO puu_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Kunzanu bibulu duke beghe Pole na burange ombu yivunde yami Felikese.» ");
INSERT INTO puu_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Mba akerende mughande eni wughu: ");
INSERT INTO puu_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","«Menu Kolode Lisyase, nyiwutindili mughade ewuwu mundumbe Felikese. ");
INSERT INTO puu_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Dibale dyédidi, BaSwife batsighaange mbé baronde umuboke, kaboghu tutsimupatule na baghore bami va makake mowu, mumba nyimawulu yi adji mwise Rome. ");
INSERT INTO puu_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Nyimaronde udjabe dibandu adi bamamufwengililaange, ngamubeghe va wusu fundu dji banzonzi ba baSwife. ");
INSERT INTO puu_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Nyimaghulu yi bémufwengilili mu mighaghe mi djobeni, tumbe aghane mbele dufu vo dji tsughu. ");
INSERT INTO puu_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Mba nyilubusi yi vadji fundu bamutungile. Nzilenge nomutinde ombu waghu na nyivayi bambeni bandi bakeyimufunde va wusu aghu.» ");
INSERT INTO puu_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Baghore bakededile marume ame bamadile. Bakebonge Pole nomubeghe mukolu o musyengi Atipareti. ");
INSERT INTO puu_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Yilumbu ayimaduke, baghore abamabe mu makulu bakeghabughe o ndaghu owu, nosile babeyitsi ba bibulu uwende na Pole. ");
INSERT INTO puu_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Na bétoli o Sesaré, babeyitsi ba bibulu bakeveghe yivunde mughande, nomuwakise Pole va makake mowu. ");
INSERT INTO puu_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Dipateme anomane urange mughande, akemuwivule yari yi dimbu dyandi. Anowulu yi mwise Silisi, ");
INSERT INTO puu_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","akemuvaghe yi: «Nyuwusosise pa bambeni baghu bamarughe.» Na akeveghe musughe wukelise Pole o ndaghu kaghe Yirode. ");
INSERT INTO puu_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Bilumbu biranu binovyoghe, yivunde yi bavaghulitsi ba paghu Ananyase, amarughe o musyengi Sesaré. Amarughaange va mosi na bivunde bi baSwife, na nzonzi mosi omanengulu Tertuluse. Bamayikelase ombu Dipateme Felikese mu ufunde Pole. ");
INSERT INTO puu_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Pole amanengulu, nzonzi Tertuluse akemufwengilile mu mame. Akevose yi: «Mundumbe, mu yese yaghu tubile na duvotsu duneni, na mu dyele di durumu dwaghu, mambu makaluyile burange mu bulongu bwébubu. ");
INSERT INTO puu_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Mu byotsu abi twidili temu tsyotsu, twiwughabusili diboti dyneni. ");
INSERT INTO puu_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Ngérondi wuvyosulile mu diweru dyaghu. Ladibandu, nyighulendi mu maboti maghu, mu utuwulu mwa pesu. ");
INSERT INTO puu_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Tutsikelule dibaale dyédidi na erombisi kindu. Abilaange yivunde yi mimbini mi dibuli di Nasarete, erombisi mbulighe ombu baSwife botsu ba bulongu. ");
INSERT INTO puu_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Atsiwélighe ubivise ndaghu Nzambi na tutsimughange. Tutsironde umusosise mu mughaghe etu, ");
INSERT INTO puu_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","tumbe yivunde Lisyase amarughe. Aketupatule woni na mangolu. ");
INSERT INTO puu_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Aketuvaghe yi tukemufunde va wusu aghu. Pa wumuwivule, wulabe ndebeni yi mfwengululu etu djotsu dji ngenze.» ");
INSERT INTO puu_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","BaSwife bamawarise mfwengululu owu, na bamavose yiri dingenze. ");
INSERT INTO puu_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Dipateme amaveghe Pole musughe uvose na amatubule rye: «Nyidjabi yiri wisalisi bunzonzi bwaghu mu bulongu bwetu mu pwele bilime, kaboghu na musighe nyiruyi mu ukéghanze. ");
INSERT INTO puu_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Nane wurungulile dikelulile ndebeni, vakavyoghe ne dighumi na bilumbu bibedji, nyimarughe o musyengi Serusaleme, mu ulembiyile Nzambi. ");
INSERT INTO puu_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Vagha mutu amandabe mbure nyitsundi na batu vo urume mughungi mu dimbunge, nesi o ndaghu Nzambi dji baSwife, vo mu musyengi. ");
INSERT INTO puu_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Batu bébabe baghorungule ulase dyambu adi béfwengilili. ");
INSERT INTO puu_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Ne nane, nyidjabi didi va wusu waghu: nyimakéveghe mu Nzile Fumu, adji bévosi yiri duyitsu du mfurulu. Tumbe, nyisalili Nzambi dji baghulu betu, nyivayili yitu mu motsu marendu mu Mabuku ma Mighaghe na ma Babiyitsi. ");
INSERT INTO puu_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Nyine yitu yi Nzambi orambuse batu botsu o dufu, bakebe baboti vo babi. Na djowu abémfwengilili wandi, bane ditase yi Nzambi obarambuse va ghari abafu. ");
INSERT INTO puu_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Ladibandu, nyilembinini ube na mutsanu wuwelimine va wusu Nzambi na va wusu batu.» ");
INSERT INTO puu_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","«Nyisamabe va ghari enu mwa bilime, nyimaghabusile o Serusaleme mu wamuse mukute ami na mbongu, nowakise paghu tsyami ombu Nzambi. ");
INSERT INTO puu_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Nyinomane ughabusile paghu, bamantasunu o dulombili du ndaghu Nzambi. Vane mbé nyimamane misusu mi manyuru. Vasamabe mughungi nami ne nkumfu. ");
INSERT INTO puu_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Tumbe, mwa dibuli di baSwife ba yari yi Asi dimabe vane wandi. Djowu, mbé batsikelase va wusu aghu mu mfwengilile, pa bane dyambu mu menu. ");
INSERT INTO puu_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Batu bébabe banzinguli dibi adi nyibile na mbele, adi nzibeghulu va wusu fundu dji banzonzi. ");
INSERT INTO puu_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Muvingu yike mbembu adji nzipalise na dwufi dineni, diteli va wusu owu: “Mumbari nyivayili yitu mu durambughulu du abafu, adine nyimabile na nyangu mu bunzonzi va wusu enu!”» ");
INSERT INTO puu_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Felikese, omadjabaange burange motsu ametsuni Nzile Fumu. Amavose na abémumfwengilili yi: «Ave yivunde Lisyase oruyile, nyusosise dyambu dyenu.» ");
INSERT INTO puu_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Amarume yivunde yi baghore mu kelisa Pole o tsughu, nomusingise dudjeghusu na musughe yiri bambatsi bandi bomusalile. ");
INSERT INTO puu_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Mwa bilumbu binovyoghe, Felikese amarughe na mughatsi andi Duresile, omabe muSwife. Amasindighe unengile Pole nowulu adi amavose mu dyambu di yitu mu Djesu Kirisete. ");
INSERT INTO puu_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Pole amavosile mu mutsanu wuboti awu Nzambi erondi, ube na murime usunde na mufundu Nzambi awiruyi. Mu temu eni, Felikese, asamalabe ubwedji, amamutsingule rye: «Wurungule uwende. Ave nyudilile temu, nyuwunengile.» ");
INSERT INTO puu_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Amatase yiri Pole omusumbe na mbongu. Ladibandu, amamunengililaange temu na temu mu vosaange nandi. ");
INSERT INTO puu_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Bilime bibedji bimavyoghe, va djulu vane Porekuse Fesetuse amavinze Felikese. Djandi, mu ulase baSwife ubwedji, amasile Pole o tsughu. ");
INSERT INTO puu_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Va djulu bilumbu biryeru bi durughu dwandi mu musyengi Serusaleme, kaghe Fesetuse amaghusughe o Sesaré na amawende o Serusaleme. ");
INSERT INTO puu_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Bivunde bi bavaghulitsi ba paghu na barumitsi ba baSwife bamarughe mu ufundise Pole. ");
INSERT INTO puu_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","Bamamuwivule ubasingise yese yi ughabuse Pole o Serusaleme. Na vane, bamatunge fundu mu djandi mu muboke mu nzile. ");
INSERT INTO puu_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Tumbe Fesetuse amawaghule yiri Pole adji o tsughu o Sesaré, na djabeni aghotambe ughabughe na mapape. ");
INSERT INTO puu_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Na amabwele: «Bivunde byenu bisobini konge nami o Sesaré na ghune bafwengilili mutu eni, pa atsisalise dibi.» ");
INSERT INTO puu_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Fesetuse amavyose yinane vo dighumi di bilumbu ombu wowu, mbana amaghabughe o musyengi Sesaré. Ave kedi, amatsane o mbure bunzonzi na amaveghe dirume bakebeghe Pole va wusu andi. ");
INSERT INTO puu_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Ave bamamubeyile, baSwife abamarughe o Serusaleme bamamutsyengile na bamamufwengilile mambu mapwele, ame djowu baghorungule ulase yi mangenze. ");
INSERT INTO puu_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Pole amakéghanze novose rye: «Ngasalise ne dibi dimosi: nesi mu mughaghe baSwife, nesi na ndaghu dji Nzambi, vo na kaghe Sesare.» ");
INSERT INTO puu_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Fesetuse, omaronde ulase baSwife ubwedji, amawivule Pole: «Wirondi uwende o Serusaleme mu usosusu va wusu ami mu dyambu dyeni?» ");
INSERT INTO puu_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Pole amawake: «Nyidji va ndaghu bunzonzi dji kaghe Sesare, avane nyutabululu bunzonzi. Ngavayile dibi ombu mukute baSwife, nane ndebeni wididjabili. ");
INSERT INTO puu_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Pa nine mbele na ta nyimasalise dyambu adi nyubokulu, ngébusi ufu. Tumbe pa vagha dyambu di ngenze adi batu beni bémfwengilili, vagha mutu avu na musughe wu ukwakise ombu owu. Nyibwayi mbile ombu kaghe Sesare aketabule dyambu dyami.» ");
INSERT INTO puu_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Kaboghu Fesetuse, anotabule dyambu na fundu banzonzi bandi, amawake: «Wumabwa mbile ombu kaghe Sesare, uwende va wusu andi.» ");
INSERT INTO puu_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Mwa bilumbu binovyoghe, kaghe Agheripa na, mwane ngudji andi mughetu Berenise, bamatole o Sesaré mu uyélingulu noyisimbe Fesetuse. ");
INSERT INTO puu_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Banotsane mwa bilumbu, Fesetuse amatolise dyambu di Pole ombu kaghe Agheripa: «Vadji mutu vave awu Felikese amasile o tsughu. ");
INSERT INTO puu_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Ave nyimawendile o Serusaleme, bivunde bi bavaghulitsi ba paghu na bivunde bi baSwife, bamamufwengilile na bamankwivule umukilise. ");
INSERT INTO puu_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Nyimabawaghule rye: “Bise Rome baghane yufu yuwakise oyifwengululu ombu banzonzi, pa akaveghu temu djukéghanze va wusu bafwengilitsi.” ");
INSERT INTO puu_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Batsirughe ghunu nami. Nyisamavyose temu kulini, nyimatsane va mbure bunzonzi, ave kedi, nyimarume yiri babeyi dibaale dyeni. ");
INSERT INTO puu_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Bafwengilitsi batsikélase, tumbe mu fwengululu owu, ngawulu mabi motsu nyimatase. ");
INSERT INTO puu_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Babetsi na mitsundu mu dyambu di munongu duyitsu doghu du Nzambi na dibaale dinengulu Djesu adjimafu, adji Pole amatubule yiri aki monyu. ");
INSERT INTO puu_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Mu menu, nyimakambulu yari ayi ngabe mu mutsundu eni. Adine nyimamuwivule yeri esingi uwende o Serusaleme, mu usosise dyambu dyandi ghune. ");
INSERT INTO puu_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Tumbe Pole amawivule, yiri dyambu dyandi dyutsonzughu mu kake dji kaghe Sesare. Ladibandu, nyimarumine yiri akekelusu o tsughu, tena nyumusindighe ombu kaghe Sesare.» ");
INSERT INTO puu_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Agheripa amatsingule Fesetuse rye: «Nyirondi uwulu mebeni mutu eni.» Fesetuse amawaghule yi: «Mughese wumuwulu.» ");
INSERT INTO puu_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Ave kedi, Agheripa na Berenise bamarughe na mughungi wuneni wumabayitsaange nobasangile na milolu. Yike djowu, bakekote o ndaghu bunzonzi na bivunde bi baghore na bi musyengi. Mu dirume di Fesetuse, Pole amabeghu. ");
INSERT INTO puu_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Mbana kaghe Fesetuse amavose: «Kaghe Agheripa, na djenu botsu aduvu vave netu, dwilabi dibaale dyédidi. Yinombu yotsu yi baSwife yi tsirughe, ubandile o Serusaleme tena ghunu, noghamughe yi mutu eni ayamwébe monyu. ");
INSERT INTO puu_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Tumbe menu, nyimalabe yiri asamavaghe dyambu adi mbé ofwile. Va djulu vane, djandi amabwa mbile ombu kaghe Sesare Okisete bwendiri djandi akemusosise. Ladibandu, nyimamutindile ombu kaghe Sesare. ");
INSERT INTO puu_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Vave, nyisane dyambu disusu dyusonine yivunde yetu mu mutu éwuwu. Ladibandu, nyimutindili va wusu enu, viri va wusu aghu, ndedju kaghe Agheripa. Pa wune bivu byumuwivule, mba nyube na dyambu dyusone. ");
INSERT INTO puu_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Nyilabi yiri digha diwelimine mu utinde mwise tsughu o Rome, ta vagha tonu adjitsiyisi mfwengululu andi.» ");
INSERT INTO puu_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Kaghe Agheripa amatsingule Pole: «Wune musughe wu uvose mu kéghanze.» Kaboghu Pole amasambe dikake la nane amakéghanzile. ");
INSERT INTO puu_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","Akevose rye: «Kaghe Agheripa, na muni nyilabi ubwedji mu ukéghanze va wusu aghu, mu motsu ame bivunde bi baSwife bémfwengilili. ");
INSERT INTO puu_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Mumbari widjabi burange nzalusulu tsyotsu tsi baghulu ba baSwife na nzundulu owu. Kokolu tsyaghu, nyighulendi kululwati na pughu. ");
INSERT INTO puu_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","BaSwife nami botsu bédjabi monyu ami wughulu, ubande bungebi bwami. Bédjabi nane nyimatsanine vane dibandu va ghari mukute ami o Serusaleme. ");
INSERT INTO puu_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Bénzyabi vane kale na borungule unkabusile bumbedji, pa batsironde. Bédjabi wandi, yiri nyimabeyise monyu ami va ghari mukute ami nodedili mighaghe mi baSwife mi bateme, diwendili yi: ami dibuli di baFarisi. ");
INSERT INTO puu_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Na muni, nyimasutusu va wusu bunzonzi, mumbari nyivayili yitu mu pangini adji Nzambi amavangene na baghulu betu. ");
INSERT INTO puu_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Dighumi na bibandu bibedji bi mukute etu, bévivi na yitu yiri pangini djuduwusu, ave béyitsili Nzambi na yikanene nyangu na mukolu. Wulwati kaghe Agheripa! Mu dyambu di yitu yeni, baSwife bémfwengilili. ");
INSERT INTO puu_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Dibandu yi wumosi va ghari enu, olabile yiri Nzambi aghorungule urambuse djowu abafu? ");
INSERT INTO puu_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","Mebeni, nyimatase utoyise Djesu mwise Nasarete na mangolu mami. ");
INSERT INTO puu_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Yine, adine nyimavaghe mu batu ba Djesu abamabe o Serusaleme. Nyimadile musughe wu muvingu na bivunde bi bavaghulitsi ba paghu, na nyimakotise yinombu yi djowu bango yitu mu djandi o tsughu. Ave bamaveyilaange musughe wu uboke batu beni, nyimabawarisaange. ");
INSERT INTO puu_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Temu na temu, nyimavyoghaange mu mandaghu mowu ma tsambu, na nyimabakilisaange mbana nyimabaghome ubunze yitu yowu. Mu bukanyi bwami, nyimabakwanaange tena misyengi mi beni.» ");
INSERT INTO puu_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","«Anane nyimawendile o musyengi Damase oyésale yisalu, mu durumu na musughe abimapeghu na bivunde bi bavaghulitsi ba paghu. ");
INSERT INTO puu_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Kaghe Agheripa, nyimabe mu nzile, mwangulu ave nyimalabile yidjalale yineni ayimaruyile o djulu, uvyolile ne nyangu. Yidjalale yeni yimavedemaange mba yiketughumbe, menu na balinzi nami. ");
INSERT INTO puu_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Djetu botsu tumaberughe vatsi na nyimawulu dyufi dimavose mu mbembu baEberu: “Sole, Sole, dibandu yi winkwanini? Wa mwenzile wiwarili, nane yibulu ewarili na ngwangu fumu andi.” ");
INSERT INTO puu_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","Nyimawivule: “Nde la nyi, Fumu?” Na Fumu amakwaghule: “Menu la Djesu, awu wikwani. ");
INSERT INTO puu_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Tumbe simbughe na releme, nyimalabene naghu, nyimawusole mu ube musatsi ami. Wube mbedji ami mu usamune nane wutsilabile na ame nyuwulase o wusu. ");
INSERT INTO puu_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Nyuwughobule va ghari mukute aghu, baSwife na mikute misusu ami nyuwusindiyile. ");
INSERT INTO puu_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","Nyiwusindiyi mu ubadibule misu, mu ubarambuse o piseme nobaghabuse o yidjalale, na mu ubadusule otsi durumu du Dyabu na mu ubakotise o bundumbe bu Nzambi. Pa batsimpayile yitu, mabi mowu motandu, bodile mbure na djowu abamatsyemusu mu yitu mu menu.”» ");
INSERT INTO puu_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","«Fumu ami Agheripa, va djulu vane, nyisamalenze dirume di yiryaryamu ayimaruyile o djulu. ");
INSERT INTO puu_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Tumbe téteghe, nyimalonze bise Damase na bise Serusaleme, na djowu abavu o yinange yi Sudé, tena batu ba malongu masusu. Nyimabatsingule yiri: “Kalughanu mutsanu enu, na ghélughanu ombu Nzambi na lasanu dukalughu dwenu mu bisalu byenu.” ");
INSERT INTO puu_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Ladibandu, baSwife bamakangile ave nyimabile o dulombili du ndaghu Nzambi na bamaronde umboke. ");
INSERT INTO puu_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Tumbe Nzambi amakaghe tena yilumbu yéyiyi na nyidji vave mu uveghe bumbedji bwami ombu botsu: bagheyi na baneni. Ngévosi masusu yike ame babiyitsi na Moyise bamatubule yiri morughe. ");
INSERT INTO puu_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","Diwendili yiri: Yibyatsi yi Nzambi otsoghe, obe awuteghe mu urambughe va ghari abafu na oyesamune yidjalale yi dughobutsu ombu mukute etu, nombu malongu masusu.» ");
INSERT INTO puu_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Ave Pole amavosilaange mu kéghanze, Fesetuse amaghamughe: «Nde wumalawughe, Pole! Wumawidji pwele, la dibandu wumalawuyile.» ");
INSERT INTO puu_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Pole amamuwake rye: «Menu nga dilaghu, mundumbe Fesetuse. Bighume abinyipalisi bingenze tsi mavovose. ");
INSERT INTO puu_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Kaghe Agheripa amadjabaange dyambu di Djesu adimavyoghe, adine mewandi ni divosili na musighe va wusu andi. Dyambu dyeni dimavyole va misu mandi, nine yitu bwé vagha yime ayi mbé aghorungule udjabe. ");
INSERT INTO puu_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Kaghe Agheripa, nde wivayili yitu mu motsu amamabighu na babiyitsi? Nyidjabi yiri wimavayili yitu!» ");
INSERT INTO puu_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Agheripa amatsingule Pole rye: «Witasi wupaghe Kereti, mu mwa pesu temu nane?» ");
INSERT INTO puu_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Pole amawaghule: «Dikebe na mapape vo vane wusu, nyisambili Nzambi tsike mu nde pinze, tumbe na botsu abénkulu na nyangu, dube nane menu, uvinguse bapange beni babe nyikapulu.» ");
INSERT INTO puu_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Kaghe na dipateme di musyengi, Berenise na botsu abamabe vane, bamareleme. ");
INSERT INTO puu_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","Banokakene, bamatsingusene djobeni na djobeni: «Mutu éwuwu aghavaghe dibi adyumurombise dufu nokotusu o tsughu.» ");
INSERT INTO puu_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Na Agheripa amatsingule Fesetuse: «Mutu éwuwu turungule umudjeyise, mbé agharonde yiri kaghe Sesare aketabule dyambu dyandi.» ");
INSERT INTO puu_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Dinotabulu yiri tuwende mu watange o bulongu bu Yitali, Pole na bise tsughu bamosi, bamawakusu yivunde yi baghore ba Rome, dine dyandi Sulyuse, yivunde mu dibuli di «Batoyitsi ba Kaghe.» ");
INSERT INTO puu_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Tumanangeme mu watange dji Aderamite, adjimawendesenaange o yisyeni yi Asi, na tumawende. Arisitareke, mwise Masedwane dji Tesalonike, amabe netu. ");
INSERT INTO puu_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Va kedi tumatole o musyengi Sidone. Sulyuse, omakélisaange Pole na musighe, amamusingise uwende ombu bambatsi bandi, mu udile ayi amabe na nzale. ");
INSERT INTO puu_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Tunoghusughe vane, tumanangeme mu watange novyoyile mu mughule ningi dji Sipere o yari ayi punge djisamabe djivyoghulile, mumbari djimaruyilaange o wusu yetu. ");
INSERT INTO puu_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Tunosabughe mubu beli na bulongu bu Silisi na Pafili, na tumatole o musyengi Mire wu Lisi. ");
INSERT INTO puu_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Vane, yivunde yi baghore ba Rome yimarasunu watange dji Alesanderi, adjimawendaange o bulongu bu Yitali na amatunangise mune. ");
INSERT INTO puu_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Mu pwele bilumbu, tumawendaange va ghéghéyi. Na maghughe maneni, tumarungulile utole va wusu musyengi Sinide. Tumbe punge djimatuvurise mu uwende na wusu. Tumavyoyile va dinzongi di Salmoné, teno divengi di ningi dji Kerete. ");
INSERT INTO puu_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Tumawende na maghughe maneni mu mughule disimu na tumatole va mbure djinengule «Masabu Maboti», beli na musyengi Lasé. ");
INSERT INTO puu_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Mulingu etu tena vave wumabonge pwele bilumbu. Va djulu vane, dimabe divure uwende mu watange na wusu. Yilumbu yimanegulu «yuwarile nzale» mbé yimavyoge. Kale yilime mu temu eni, punge djimabande uvotse pwele. Ladibandu, Pole amalubusili basalitsi ba watange: ");
INSERT INTO puu_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","«Bambatsi bami, nyilabi yiri mulingu wurange. Watange na bime byudyame na djetubeni wandi turungulu utsyemuse myoni.» ");
INSERT INTO puu_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Tumbe yivunde yi baghore amavayile yitu mu munu fumu watange na mubeyitsi djoni, divyakene na mbembu Pole. ");
INSERT INTO puu_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Va djulu vane, bapwele abamabe mu watange bamawulusunu mu wusughe vane, mumbari yisyeni yeni yisamabe yiwelimine mu vyosile mvule. Bamaronde utole o yisyeni yi Fenikese dji Kerete, o yari ayi mupunge wughépepili pwele, ayisungesene na awu wisi etsimini. Bamaronde usyale vane, tena mvule djuvyoyile. ");
INSERT INTO puu_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Mwa dupepi du bande dumavughe, bamatase udughusu mulingu owu. Na bamanyangule kunge adjimaghanga watange na bamavyoghe va mughule disimu di Kerete. ");
INSERT INTO puu_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Tumbe, punge djineni adjinengulu «Yirakilone», djimasundughe o mikongu mi ningi. ");
INSERT INTO puu_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Watange djimavevughe: dimabe divure mu djibeyise dibandu mungudi, tena tumakesilile ubeghusu. ");
INSERT INTO puu_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Tumavyoyile o bande ningi djigheyi djinengulu Koda, o disimu adi mupunge wusamabe mangolu, ave tumadilile yivumunu mwa pesu. Va djulu vane, na purulu tsipwele tumarungule usiyighe bwatu bugheyi abutungu mu watange. ");
INSERT INTO puu_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Basatsi banodute bwatu, bamabunangule na bamabunangighe o ghari watange, mbana bamavyose mikudu otsi notsyengise watange mu udji warise. Bamadumaange uyékébwaghe mu maghuki ma yisyeke ma Sirete amamabe mu yisyeni yi Lybi, la dibandu bamasundusile kunge mu udetse mwendu watange. ");
INSERT INTO puu_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Yilumbu ayimaduke, Mungudi wumabwela utupupise na mangolu, la dibandu basatsi bamabande ubwaghe dikabu di maboti amamabe mu watange mu mubu. ");
INSERT INTO puu_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Yilumbu ayimuryeru, bamabwaghe na makake mowu, bisalulu bi watange. ");
INSERT INTO puu_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Mu bilumbu bipwele, tusamamwélabaange ne nyangu, ne bambwuélili. Punge djimavyoghulile uvepe na mangolu. Na va djulu vane, tukane yitu yughobulu. ");
INSERT INTO puu_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Mu temu eni djine, botsu abamabe mu watange, mbé bakeyitsingu yineni nodji. Kaboghu Pole, amareleme va wusu owu na amavose: «Bambatsi bami, mbé dumakululu na mbé dusamarambughe o ningi Kerete, mungudi mbé usamadubembe na mbé tughatsyemuse nobunge bimi. ");
INSERT INTO puu_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Tumbe vave, nyidunengili mu ube na duwarusu, mumbari vaghobe ne wumosi awutsyemuse monyu. Muvingu yike watange adjubungene. ");
INSERT INTO puu_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Mu mukolu eni, yanze yi Nzambi adji ndile na adji nyisalili, yike bambene nami. ");
INSERT INTO puu_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","Na yitsinzingule: “Wuyalabe ghome, Pole! Vengu wuvyoghe va wusu kaghe Sesare. Mu maboti mandi mu ndedju, Nzambi ewusingisi monyu batu botsu abavu naghu.” ");
INSERT INTO puu_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Banu abaware, bambatsi bami, mumbari nyine yitu mu Nzambi. Dyube nane dimanzingululu. ");
INSERT INTO puu_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Watange djudyame ave tubile beli na mwa ningi.» ");
INSERT INTO puu_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Dimabe mukolu awu dighumi na mwina (14) bi mungudi wumatusindilaange o mubu wu Méditerane. Beli va ghari wisi, basalitsi ba watange bamatase yiri tuke beli na butambe. ");
INSERT INTO puu_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Bamawélighe ndonge na bamalabe yiri mambe mamabe madonge mu maghumi-maryeru na yisambwali (37) yi byetsu. Mwa pesu o wusu, bamamwéwélighe na bamalabe maghumi ma bedji na yinane (28) yi byetsu. ");
INSERT INTO puu_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Bamadumange yiri watange djikéwubene mu dimani. Ladibandu, bamabwayile kunge djine o nzime mu udetse mwendu watange na bakevivaange ditebughulu di wisi. ");
INSERT INTO puu_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Ne nane, basalitsi bamaronde urine mu watange. La dibandu, bamasunduse bwatu mu mambe na bakerombe yighume yusunzile kunge o wusu watange. ");
INSERT INTO puu_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Pole amatsingule yivunde na baghore basuse: «Pa batu bébaba baghatsane o ghari watange, dughorungulu ughobulu!» ");
INSERT INTO puu_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Kaboghu, baghore bamatabule mikudu amimasikigha watange na bamabusile uvevughe. ");
INSERT INTO puu_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Ne wisi uketébughe, Pole amabarume udji, novose rye: «Lanu, na muni dighumi na bilumbu bina (14), dwivivili na manyoni ughambu udji. ");
INSERT INTO puu_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Nyiduwarisi mu ubonge bighudji, mumbari dune nzale byonyi dukeghobulu. Vaghobe ne mutu wumosi awutsyemuse ne dunange dumosi du muru!» ");
INSERT INTO puu_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Anomane uvose, Pole amabonge dipe, amaghabusile Nzambi diboti va wusu botsu, mbana amabaghabile na amabande udji. ");
INSERT INTO puu_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Botsu bamadile duwarusu, na djowu bamadji. ");
INSERT INTO puu_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Tumabe mu watange, kame-bedji maghumi dusambwali na batu ba syamunu (276) mu botsu. ");
INSERT INTO puu_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Ave mutu-mutu amamanine udji na uwukuru, bamabwaghe byotsu abimasyale mu bakomi o mubu mu lengsene watange. ");
INSERT INTO puu_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Wisi wunotebughe, basalitsi ba watange basamamwédjabe ningi, tumbe bamalabile dukweku na bamaghane kake mu utsyekighe watange mu yisyeyi. ");
INSERT INTO puu_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Bamanyangule kunge na bamadjisile uwende mu mubu. Bamanyangule va mosi mikudu mi yivepi. Na bamatunge tsande o wusu watange, yiri punge odjisindile na bamawendusu o dukweku. ");
INSERT INTO puu_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Tumbe bamatole va yinzunze yi yisyeyi na watange djimasikeme. Wusu watange wukekote mu yisyeyi na djisamamwékunge, matine mamapanzighe na mangolu ma mibidji. ");
INSERT INTO puu_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Baghore bamaronde uboke bise tsughu, yiri ne wumosi aghodile urine noryale. ");
INSERT INTO puu_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Tumbe yivunde yi baghore, na nzale ughobule Pole, amabaghandise. Amarume botsu abédjabi uryale, bareli mu mambe mu usabughe o disimu. ");
INSERT INTO puu_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","Bane bamabadukaange banangeme va djulu tsimbi na basusu bamaryalaange ubongile ghune watange. Anane djetu botsu tumaghobuyile. ");
INSERT INTO puu_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Tunoghobulu, tumadjabe yiri ningi eni adjitumabe, djinengulu Malete. ");
INSERT INTO puu_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Bise ningi abasamavosaange mbembu Ngereke bamatudile na musighe. Mvule djimamwénoghe na wumabe yotsi, kaboghu bamabanze mudji wuneni na bamatudile djetu botsu. ");
INSERT INTO puu_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Pole anoboole dighuki di batsyenzu mu utume o mudji, pili djimapale na mbabisile na djimaghobe mu dikake dyandi. ");
INSERT INTO puu_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Ave bise ningi bamalabile pili djivyunge mu dikake di Pole, bamatsingusene yi: «Dibaale dyédidi adji yikongu, mumbari bunzonzi bu Nzambi bughémusingisi udile monyu, ne nana atsighobululu mu mubu.» ");
INSERT INTO puu_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Tumbe Pole amanyaghule nyoghe o ghari mudji, ne udile bwali. ");
INSERT INTO puu_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Bamatasa yiri orande vo ufu, tumbe banokélise yitsingu. Bamalabe yiri aghédili dyambu, bamavinze posulu novose, kaboghu adji wumosi va ghari banyambi. ");
INSERT INTO puu_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Beli na mbure eni vamabe kande dji yivunde yi ningi, dibaale dine dyandi Publyuse. Djandi amatudile burange na amatulatse bilumbu biryeru. ");
INSERT INTO puu_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Tadji Publyuse amabe va tangi, amabe na dibaghu na amavanze malungu. Pole amawende ombu wandi, anosambile Nzambi, amamusakighe makake na djandi amabelughe. ");
INSERT INTO puu_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Va djulu vane, batu basusu ba ningi abamabe nobele, bamarughe na bamabelughe. ");
INSERT INTO puu_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Bamatughobise mu minongu myotsu. Temu djuwende mu watange djinotole, bamatuveghe byotsu abimabe biwelimine na mulingu. ");
INSERT INTO puu_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Miweli miryeru minovyoghe, tumanaangeme mu watange dji Alesanderi, bamanengilaange «Mavase», djimavyose mvule va yisyeni yi ningi. ");
INSERT INTO puu_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Tumatole o musyengi Sirakuse, avane tumatsane bilumbu biryeru. ");
INSERT INTO puu_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Tunoghusughe vane, tumaduke mughule tena tumatole o musyengi Redjo. Ave kedi, punge adji bande dji mapepe, mbana tumatole mu bilumbu bibedji tena o musyengi Puzole otumasunduyile. ");
INSERT INTO puu_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Mune musyengi eni, tumadale baane ba ngudji, bamatulende uvyose tsone nowu. Anane tumatolile o bulongu bu Rome. ");
INSERT INTO puu_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Baane ba ngudji ba Rome banowulu bilumbi mu dyambu dyetu, bamayitubengusune va dibaghe dinengulu «Apyuse» na musyengi winengulu «Mandaghu Maryeru ma Beni». Pole anobalabe, amaghabusile Nzambi diboti na amawarusu. ");
INSERT INTO puu_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Tunotole o Rome, bamasingise Pole ube na djandi mbure vike, na ghore adjimamukelisaange. ");
INSERT INTO puu_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Bilumbu biryeru binovyoghe, Pole amanengile ombu wandi bivunde bi baSwife abavu o Rome. Banoghukeme, amabatsingule: «Bane batadji, ne nane nyisamavayile dyambu divyakene na mutsanu mukute etu vo na nzalusulu dji baghulu betu. Ne nane, nyimaghangu o Serusaleme, nowakusu ombu bise Rome. ");
INSERT INTO puu_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Banonkwivule byuvu, basusu mbé baronde undunde, mumbari basamadile dyambu mu menu adyumfundisile vo dyumbokile. ");
INSERT INTO puu_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Tumbe barumitsi ba baSwife bamabuse, kaboghu nyimanengile Kaghe Sesare. Nyisamabe na ditase dyufwengilili bise bulongu bwami. ");
INSERT INTO puu_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Ladibandu, nyimarondile ubengunu nenu no duvosile. Va djulu vane, nyitungu na bapange beni babe, dibandu djandi awu mukute Yisrayele wivivi.» ");
INSERT INTO puu_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Bamamuwawule rye: «Tusamadile mighande mi Sudé mu dyambu dyaghu, ne mwane tadji mosi asamarughesene ghune, mu ututsingule mambu vo mu uvosile dibi. ");
INSERT INTO puu_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Tumbe, twirondi wuketutsingule ndebeni dyambu adi witasi, mumbari twidjabi yiri mbure tsyotsu, wudji batu bévosi dibi mu nde.» ");
INSERT INTO puu_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Bamavangene na Pole, na yilumbu yi ndayi, bamarughe yinombu yineni nomurasune va mbure adji amatsanine. Ubande kedi tena tsisighe, Pole amabavindiyile mambu. Amabasamunine Bukaghe bu Nzambi, amarombe ubasungighe mu dyambu di Djesu, na akerangaange na dyufi dineni, mighaghe mi Moyise na mabuku ma Babiyitsi. ");
INSERT INTO puu_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Bamosi bamabembu na mambu ame amavosaange, tumbe basusu bamabuse umavayile yitu. ");
INSERT INTO puu_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Ave bamabandile uwende ughambu uwulusunu, Pole amabatsingule didi rye: «Yinyuni Yisyeme yimabe na ndunge, ave amavosilaange na baghulu benu mu munu mubiyitsi Yisayi! ");
INSERT INTO puu_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","Yimavosaange rye: “Yétsingule mukute éwuwu: Duwulu, tumbe dughotsiyise. Dughengile, tumbe dugholabe. ");
INSERT INTO puu_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Mumbari mukute éwuwu wuke mbike. Bamadibighe matudji, bamatsimise misu, yiri bakélabe na misu mowu, bakéwulu na matudji mowu, bakétsiyise na mirime myowu. Ubuse nane, mbé boghabughe ombu wami, yiri nyubabeluse.”» ");
INSERT INTO puu_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","Pole amabwese rye: «Djabanu didi Nzambi amatinde musamu wu dughobutsu ombu abagha baSwife. Bomuwululu djowu!»  ");
INSERT INTO puu_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","Mu bighume byeni bi Pole, baSwife bamawende notsundaange va ghari owu. ");
INSERT INTO puu_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Pole amatsane mipume mibedji mu ndaghu adji amafutaange. Amadile botsu abamarondaange umulabe. ");
INSERT INTO puu_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","Amalonzaange Bukaghe bu Nzambi na mambu ameghéngili Fumu Djesu Kirisete, na musighe wughambu ukungusu.");
INSERT INTO puu_vpl VALUES ("JM1_1","089_1_1","JAS","1","1","1","Awu menu Sake nyirendi mughande éwuwu. Nyidji musatsi Nzambi na Fumu Djesu Kirisete. Nyisimbi mukute wotsu wu Nzambi awuvu wupanzighe mu bulongu bwotsu. ");
INSERT INTO puu_vpl VALUES ("JM1_2","089_1_2","JAS","1","2","2","Baane ba tadji bami! Pa maghughe maminongu mipwele meduruyili, banu mu nzangu dji neni. ");
INSERT INTO puu_vpl VALUES ("JM1_3","089_1_3","JAS","1","3","3","Djabanu yiri, pa yitu yenu yitsiware mu maghughe, duware tinde uware. ");
INSERT INTO puu_vpl VALUES ("JM1_4","089_1_4","JAS","1","4","4","Vengu duware teno disukusulu, na dube duwelimine, djowu abamaneghe na bamaware mu yinyuni, mba dughoghambu na yime. ");
INSERT INTO puu_vpl VALUES ("JM1_5","089_1_5","JAS","1","5","5","Pa wumosi va ghari enu eghambu na dyele, avondi Nzambi, na djandi omuveghe dyele dyeni. Mumbari djandi, eveyi pwele na murime mosi. ");
INSERT INTO puu_vpl VALUES ("JM1_6","089_1_6","JAS","1","6","6","Tumbe ayivondi na yitu, ayabe na bakemi. Odjivu na bakemi, adji nane mibidji ami mupunge etinde yari na yari. ");
INSERT INTO puu_vpl VALUES ("JM1_7","089_1_7","JAS","1","7","7","Mutu ewune, ayatase yi Fumu omuveghe ne yime. ");
INSERT INTO puu_vpl VALUES ("JM1_8","089_1_8","JAS","1","8","8","Murime andi wughabunu, agha asigheme mu mutsanu andi. ");
INSERT INTO puu_vpl VALUES ("JM1_9","089_1_9","JAS","1","9","9","Mwane tadji odjivu yidjaghe, abi mu nzangu mumba Nzambi amamunangule. ");
INSERT INTO puu_vpl VALUES ("JM1_10","089_1_10","JAS","1","10","10","Yisine, abi djawandi mu nzangu, mumba Nzambi omudyamise. Mba ofu, nane biriri bi kembu bighumuyili. ");
INSERT INTO puu_vpl VALUES ("JM1_11","089_1_11","JAS","1","11","11","Nyangu djibali, na yusile wandi yighumusi biriri. Bibonduyi notsyemuse kembu. Munongu mosi, olebe na busine vengu ofu. ");
INSERT INTO puu_vpl VALUES ("JM1_12","089_1_12","JAS","1","12","12","Ubwedji ombu mutu oyiwarili mu dumangu. Mba ave dumangu dusukile, odile dughabe du monyu awu Nzambi amalonge bobemurondi. ");
INSERT INTO puu_vpl VALUES ("JM1_13","089_1_13","JAS","1","13","13","Ave mutu ebili mu dumangu, ayavose yiri Nzambi embangi, mumbari Nzambi aghorungule umangu, na aghémangi mutu. ");
INSERT INTO puu_vpl VALUES ("JM1_14","089_1_14","JAS","1","14","14","Nzale tsyandi tsibive mu murime, tsimubeyi mu uvaghe mabi. ");
INSERT INTO puu_vpl VALUES ("JM1_15","089_1_15","JAS","1","15","15","Dunyungi pa dumavyoghulile dwiburi dibi, dibi pa dimawele dibeyi o dufu. ");
INSERT INTO puu_vpl VALUES ("JM1_16","089_1_16","JAS","1","16","16","Baane ba tadji ba durondu, duyakedyonge. ");
INSERT INTO puu_vpl VALUES ("JM1_17","089_1_17","JAS","1","17","17","Nzambi oyiveyi peghulu tsyotsu atsiboti na bisaku abiwelemine. Djandi omasunde, nyangu, ngondi na bambwelili. Adji yidjalale aghékaluyi, aghéghéluyi nzime mu udusile o tsi piseme. ");
INSERT INTO puu_vpl VALUES ("JM1_18","089_1_18","JAS","1","18","18","Amaronde djabeni utuveghe monyu mu mbembu andi adjivu ngenze, mumbari tukebe abateghe, va ghari bisundu byandi. ");
INSERT INTO puu_vpl VALUES ("JM1_19","089_1_19","JAS","1","19","19","Baane ba tadji ba durondu, rangeminanu didi: kale mutu abi na pughu djuwulu, tumbe ayabe na maswasu movose, ayasunga unyoghe. ");
INSERT INTO puu_vpl VALUES ("JM1_20","089_1_20","JAS","1","20","20","Mutu na kabu aghorungule uvaghe mambu amasungeme va wusu Nzambi. ");
INSERT INTO puu_vpl VALUES ("JM1_21","089_1_21","JAS","1","21","21","Kaboghu, bwaghanu mambu motsu manzoruru amavu mu mirime myenu, bukani abwidubeyi o dibi, duyamwévaghe mabi. Dilanu na mirime misunde mbembu adji Nzambi amavare mu djenu. Mbembu eni, djine mangolu modughobule o dufu. ");
INSERT INTO puu_vpl VALUES ("JM1_22","089_1_22","JAS","1","22","22","Duyasingene bu mu uwulu mbembu Nzambi, tumbe djidughuswanu. Pa dwiwulu yike uwulu mba dughédughusu, dwikedyonge. ");
INSERT INTO puu_vpl VALUES ("JM1_23","089_1_23","JAS","1","23","23","Pa yi mutu esingini bu nowulu mbembu eni na aghédjidughusu, abaghunu na mutu oyikeghengili mu dumwenu na elabi nane avu, ");
INSERT INTO puu_vpl VALUES ("JM1_24","089_1_24","JAS","1","24","24","atsunina yinzi yandi, ewendi yari yisusu, na elibeni nane yinzi yandi yivu. ");
INSERT INTO puu_vpl VALUES ("JM1_25","089_1_25","JAS","1","25","25","Tumbe oyikeluli mughaghe Nzambi, na ewusalisi, Nzambi omusake mu yisalu yeni. Ayawulu yike uwulu mughaghe nowulibene, awudedili na Nzambi omuveghe myule. Mumbari mughaghe eni wuboti, wune mangolu motughobule mu mabi. ");
INSERT INTO puu_vpl VALUES ("JM1_26","089_1_26","JAS","1","26","26","Pa mutu etasi yi adji mudukitsi Nzambi, mba aghane yidamambe, kaboghu ekedyonge, bungange bwandi bughane tsongu. ");
INSERT INTO puu_vpl VALUES ("JM1_27","089_1_27","JAS","1","27","27","Bungange abuboti va wusu Tate Nzambi, bwiwendili yi mutu akelisi burange bisyane na bakwili abetsoyi. Djabeni wandi akebini mumba mambu mabive ma bulongu makemukotise mu dibi. ");
INSERT INTO puu_vpl VALUES ("JM2_1","089_2_1","JAS","2","1","1","Baane ba tadji, djenu bo dwivayili yitu mu Djesu Kirisete, Fumu etu bundumbe, duyabe na yimbambile. ");
INSERT INTO puu_vpl VALUES ("JM2_2","089_2_2","JAS","2","2","2","Tangudji, batu babedji bekoti o yibengunu yenu. Wumosi adware bikutu bi dufunu duneni na moru wikadimi. Awune yidjaghe, adware bikutu bi mwinzi. ");
INSERT INTO puu_vpl VALUES ("JM2_3","089_2_3","JAS","2","3","3","Pa wighobisi odjivu na bikutu bilyome, wimutsinguli dibaale: «Yitsane va mbure adjiboti.» Ombu yidjaghe wimutsinguli: «Ba diteli vo tsane va tsi.» ");
INSERT INTO puu_vpl VALUES ("JM2_4","089_2_4","JAS","2","4","4","Ave dwivayili nane, tsi dupasu dwivayi va ghari enu? Dughésosisi na mirime mibive? ");
INSERT INTO puu_vpl VALUES ("JM2_5","089_2_5","JAS","2","5","5","Baane ba tadji ba durondu, wulwanu burange: Nzambi asamasole bidjaghe va misu ma bulongu mumbari bakevayile yitu ombu Djesu Kirisete na bakebe na busine bungenze, bakedile bufumu bu djulu abu amalonge ombu djowu abemurondi? ");
INSERT INTO puu_vpl VALUES ("JM2_6","089_2_6","JAS","2","6","6","Tumbe djenu, dumalenze bidjaghe! Tsi bisine bedutsoyisi na bedubeyi va wusu banzonzi? ");
INSERT INTO puu_vpl VALUES ("JM2_7","089_2_7","JAS","2","7","7","Djowu belenzi boti dine adi Nzambi amaduveghe. ");
INSERT INTO puu_vpl VALUES ("JM2_8","089_2_8","JAS","2","8","8","Pa dwidughusu mughaghe awurendu, awiruyili ombu Nzambi na wivosi rye: «Ronde mutu naghu nane wikerondili ndebeni», dwivayi burange. ");
INSERT INTO puu_vpl VALUES ("JM2_9","089_2_9","JAS","2","9","9","Tumbe pa dwivayi yimbambile, dibi dwivayi, mughaghe Moyise widukilisi mumbari dwiwulenzi. ");
INSERT INTO puu_vpl VALUES ("JM2_10","089_2_10","JAS","2","10","10","Ne yi mutu ededili mighaghe myotsu mi Nzambi, tumbe pa atsi lenze ne wumosi, kaboghu ane mbele va wusu mughaghe wotsu. ");
INSERT INTO puu_vpl VALUES ("JM2_11","089_2_11","JAS","2","11","11","Dibile nane, mumba Nzambi omavose rye: «Wuyatube bukali», amamwévose rye: «Wuyaboke mutu.» Kaboghu, ne wughatube bukali tumbe wutsiboke mutu, wumabise mughaghe Nzambi. ");
INSERT INTO puu_vpl VALUES ("JM2_12","089_2_12","JAS","2","12","12","Mu dyoni, vosanu na salisanu nane djowu abe Nzambi otabulile bunzonzi. Olabe yeri dutsidedile mughaghe awuvu na mangolu modudjeyise. ");
INSERT INTO puu_vpl VALUES ("JM2_13","089_2_13","JAS","2","13","13","Pa mutu aghane yingebe ombu basusu, ave Nzambi omutabulile bunzonzi, aghomulabe ngebe wandi. Tumbe odjivu na yingebe ombu basusu, aghobe na ghome bunzonzi. ");
INSERT INTO puu_vpl VALUES ("JM2_14","089_2_14","JAS","2","14","14","Baane ba tadji, pa mutu evosi yiri ane yitu, tumbe aghévayi ame Nzambi etsinguli, yitu yandi yighane tsongu. Yoni yighorungule umughobule. ");
INSERT INTO puu_vpl VALUES ("JM2_15","089_2_15","JAS","2","15","15","Tangudji mwane tadji, mughetu vo dibale, aghane bikutu vo bighudji bi kale yilumbu. ");
INSERT INTO puu_vpl VALUES ("JM2_16","089_2_16","JAS","2","16","16","Pa mutu va ghari enu ebatsinguli: «Wendanu mu duvotsu, yotsi na nzale biyadughaange», tumbe aghébaveyi bime abibaghambu, banu na makure. Dyoni dighane tsongu. ");
INSERT INTO puu_vpl VALUES ("JM2_17","089_2_17","JAS","2","17","17","Munongu mosi na yitu ayighane bisalu, yifu. ");
INSERT INTO puu_vpl VALUES ("JM2_18","089_2_18","JAS","2","18","18","Tangudji, mutu ovose yi: «Ndedju wune yitu, menu nine bisalu.» Ndasi tsyeni wubile na yitu ayighane bisalu, menu ngawulase yitu yami mu bisalu byami. ");
INSERT INTO puu_vpl VALUES ("JM2_19","089_2_19","JAS","2","19","19","Widjabi yiri vadji bu Nzambi mosi? Wivayi diboti. Ne binyuni bibi bedidjabi wandi, na bereyimi na ghome. ");
INSERT INTO puu_vpl VALUES ("JM2_20","089_2_20","JAS","2","20","20","Yiduke nane nde, balemwéwulase yiri yitu ayighane bisalu, yifu? ");
INSERT INTO puu_vpl VALUES ("JM2_21","089_2_21","JAS","2","21","21","Tadji etu Aberaame amalabene asungeme va misu ma Nzambi ave amavaghulile mwane andi Yisaake. ");
INSERT INTO puu_vpl VALUES ("JM2_22","089_2_22","JAS","2","22","22","Wilabi yi yitu yandi yimawendaange va mosi na bisalu byandi, na mu byoni yitu yandi yimadughusu. ");
INSERT INTO puu_vpl VALUES ("JM2_23","089_2_23","JAS","2","23","23","Anane dyoni dimadughusu nane Bisonu bi Nzambi bivosili: «Aberaame amavayile Nzambi yitu, na mu yoni Nzambi amamusinge yiri asungeme.» Na Nzambi amamunengile mbatsi andi. ");
INSERT INTO puu_vpl VALUES ("JM2_24","089_2_24","JAS","2","24","24","Kaboghu, dwilabi yiri mutu amasungughu va wusu Nzambi, dibandu bisalu biboti byo evayi, tsike bu mu yitu yandi. ");
INSERT INTO puu_vpl VALUES ("JM2_25","089_2_25","JAS","2","25","25","Rangeminanu wandi Rabe yimbembu. Nzambi amamulabe asungeme mu dyo amavaghe. Amadile bilumbi, akebasweghe na amabalonge nzile susu djurinine. ");
INSERT INTO puu_vpl VALUES ("JM2_26","089_2_26","JAS","2","26","26","Nane dunyuru adughane muvumu dufwile, ");
INSERT INTO puu_vpl VALUES ("JM3_1","089_3_1","JAS","3","1","1","Baane ba tadji, bapwele va ghari enu bayarombe ube milonzi, mumbari dwidjabi yiri ave djetu milonzi tutabululu bunzonzi dyughale uvyoghulile adi basusu. ");
INSERT INTO puu_vpl VALUES ("JM3_2","089_3_2","JAS","3","2","2","Djetu botsu tune mbé rughulu tsi minongu mipwele twivayi amagha maboti. Pa mutu aghavaghe dibi mu uvose, mutu ewune asungeme, edjabi ukelise dunyuru dwandi. ");
INSERT INTO puu_vpl VALUES ("JM3_3","089_3_3","JAS","3","3","3","Bevakiyi budilu mu munu kabele, mumbari akebadedile, bakemubeyise djawotsu. ");
INSERT INTO puu_vpl VALUES ("JM3_4","089_3_4","JAS","3","4","4","Tasetyanu wandi bawatange, ne nane babile baneni mba mipunge amineni mibatsayisi, mudji yisalu yigheyi mune, na yoni mubeyitsi ebasungiyili mu uwende o yari ayi erondi. ");
INSERT INTO puu_vpl VALUES ("JM3_5","089_3_5","JAS","3","5","5","Munongu mosi na dulimi du mutu. Dulimi olembu ugheyi enyemi bisalu bi neni. Dighaghele di mudji dinyenzi musiru wotsu. ");
INSERT INTO puu_vpl VALUES ("JM3_6","089_3_6","JAS","3","6","6","Dulimi dudji nane mudji. Dibi di dineni divu mu manyuru metu. Ebivisi dunyuru dwotsu. Ebanzi mudji awibungi monyu wotsu wu mutu. Mudji eni wiruyili tindi wune bulungi bu mudji. ");
INSERT INTO puu_vpl VALUES ("JM3_7","089_3_7","JAS","3","7","7","Mutu orungule udyamise minongu myotsu mi bibulu, batsoli, bilandile na banyame ba mambe wandi. ");
INSERT INTO puu_vpl VALUES ("JM3_8","089_3_8","JAS","3","8","8","Tumbe djandi aghorungule udyamise dulimi. Dulimi yileme yibive yigha musighe. Dubase na ndombu adjiboki batu. ");
INSERT INTO puu_vpl VALUES ("JM3_9","089_3_9","JAS","3","9","9","Twiyitsi Fumu odjivu Tadji etu na dulimi na twiloghi batu abe djandi amasunde mu yibaghunu yandi na dulimi dweni wandi. ");
INSERT INTO puu_vpl VALUES ("JM3_10","089_3_10","JAS","3","10","10","Bighume bi duyitsu na bi miloghu bipali mu munu wune wumosi. Baane ba tadji, diyabe nane! ");
INSERT INTO puu_vpl VALUES ("JM3_11","089_3_11","JAS","3","11","11","Mambe maboti na mabive maghépali yileke yimosi. ");
INSERT INTO puu_vpl VALUES ("JM3_12","089_3_12","JAS","3","12","12","Baane ba tadji, mungengi orungule ubure minzunzebali? Munzunzibali aghobure mingengi wandi. Yileke yi mambe maboti yighopalise mambe makali. ");
INSERT INTO puu_vpl VALUES ("JM3_13","089_3_13","JAS","3","13","13","Vadji mutu va ghari enu etasi ube na dyele na dudjabu? Adilasi mu mutsanu wuboti, avayi bisalu na ukesunze na dyele. ");
INSERT INTO puu_vpl VALUES ("JM3_14","089_3_14","JAS","3","14","14","Tumbe pa wune ngusu djineni mu murime aghu, na wirondi wuvyoghulile ba mbatsi wandi, kaboghu uyakedodise, na uyavinze ufure va mbure ngenze. ");
INSERT INTO puu_vpl VALUES ("JM3_15","089_3_15","JAS","3","15","15","Dyele dyédine digheruyile ombu Nzambi, dyele di bulongu. Yinyuni yi Nzambi yigha mune, diruyili ombu Dyabu. ");
INSERT INTO puu_vpl VALUES ("JM3_16","089_3_16","JAS","3","16","16","Pa batu bane ngusu na berondi wuvyoghulile bambatsi, mambu maghomwéwelemine mba mabi ma minongu mipwele mobe vane wandi. ");
INSERT INTO puu_vpl VALUES ("JM3_17","089_3_17","JAS","3","17","17","Tumbe dyele adiruyili ombu Nzambi tetegha dilyome. Va djulu vane disigheme, divole, dine bilunzi, dibase na yingebe na bisalu biboti. Dighane yimbambile na pende. ");
INSERT INTO puu_vpl VALUES ("JM3_18","089_3_18","JAS","3","18","18","Batu aberondi duvotsu beveyi basusu duvotsu nane tsangu, na kabusulu adji bedili monyu wusungeme. ");
INSERT INTO puu_vpl VALUES ("JM4_1","089_4_1","JAS","4","1","1","Povini na mitsundu va ghari enu wuke biruyisini? Tsi nzale tsyenu tsibive tsivovini mu mirime myenu? ");
INSERT INTO puu_vpl VALUES ("JM4_2","089_4_2","JAS","4","2","2","Dwinyungili bime tumbe dughébidili. Ladibandu, dubile babokitsi. Dwinyungili bime, tumbe dughérunguli ubidile. Kaboghu dwitsundi na dwivovini. Dughédili ayi dwirombi, mumbari dughévondi Nzambi. ");
INSERT INTO puu_vpl VALUES ("JM4_3","089_4_3","JAS","4","3","3","Ave dwisambili dughédili, mumbari dwisambili na matase mabive, mu udugusu nzale tsyenu tsikulini. ");
INSERT INTO puu_vpl VALUES ("JM4_4","089_4_4","JAS","4","4","4","Djenu abe dugha dusigheme, dughédjabi yiri pa mutu erondi bulongu, adji mbeni Nzambi? Mutu oyirondi bime bi bulongu, ebi mbeni Nzambi. ");
INSERT INTO puu_vpl VALUES ("JM4_5","089_4_5","JAS","4","5","5","Dwitasi yiri Bisonu bi Nzambi bifuri ave bivosili yiri na diwavi Nzambi erondili pwele Yinyuni ayi amasunze mu djetu? ");
INSERT INTO puu_vpl VALUES ("JM4_6","089_4_6","JAS","4","6","6","Tumbe etuveyi yese yivyoghulile, nane barendile mu dibuku di Nzambi yiri: «Nzambi ekambisi abavu na dunangu, tumbe eveyi yese ombu djowu abakesunze.» ");
INSERT INTO puu_vpl VALUES ("JM4_7","089_4_7","JAS","4","7","7","Kaboghu, kesunzanu va wusu Nzambi. Waranu va wusu Dyabu, na odurine. ");
INSERT INTO puu_vpl VALUES ("JM4_8","089_4_8","JAS","4","8","8","Bambenanu na Nzambi, djawandi obambene nenu. Susanu makake menu, djenu abeduvu bavayitsi ba mabi. Lyomisanu mirime myenu, batu abavu na mirime mighabu. ");
INSERT INTO puu_vpl VALUES ("JM4_9","089_4_9","JAS","4","9","9","Labanu maghughe menu, lilanu, tatanu, dikyeki dyenu dikaluyi kondu, nzangu enu djibi munyongu. ");
INSERT INTO puu_vpl VALUES ("JM4_10","089_4_10","JAS","4","10","10","Kedyamisanu va wusu Fumu na odunangule. ");
INSERT INTO puu_vpl VALUES ("JM4_11","089_4_11","JAS","4","11","11","Baane ba tadji, duyaghélesenaange. Pa mutu evosi dibi mu mwane tadji andi na emugheli, kaboghu evosi dibi mu mughaghe Nzambi na ewugheli. Tumbe pa wigheli mughaghe, wughéwudedili, wiwusyembi yike usyembe. ");
INSERT INTO puu_vpl VALUES ("JM4_12","089_4_12","JAS","4","12","12","Bu Nzambi yiveyi mughaghe ombu batu. Nzonzi bu djandi. Djandi pinze o wurungule ughobule na orungule ubunge. Kaboghu ndedju anyi wuvu, ndedju wigheli mwane tadji aghu? ");
INSERT INTO puu_vpl VALUES ("JM4_13","089_4_13","JAS","4","13","13","Djenu, wulwanu mbembu ami, djenu abedwivosi: «Na nyangu vo mughese, tuwende o musyengi awune, tuyévyose yilime yimosi, tuvaghe bukoli mu udile mbongu.» ");
INSERT INTO puu_vpl VALUES ("JM4_14","089_4_14","JAS","4","14","14","Djenu abedwivosi nane, dughédjabi ne adwiyuduruyile mughese. Dudji nane mwa dimungi adipali mwa pesu temu, mba ditsyemuyi. ");
INSERT INTO puu_vpl VALUES ("JM4_15","089_4_15","JAS","4","15","15","Mbé dwivosi nane: «Pa Fumu atsironde, tube monyu, tuvaghe dyedi na dyedi.» ");
INSERT INTO puu_vpl VALUES ("JM4_16","089_4_16","JAS","4","16","16","Tumbe duvumbe dwenu dwiruyili mu dunangu, ave dwikerutsuli nane dyoni dilasi yiri dune dunangu, digha diboti. ");
INSERT INTO puu_vpl VALUES ("JM4_17","089_4_17","JAS","4","17","17","Pa mutu edjabi uvaghe diboti mba aghédivayi, kaboghu dibi evayi. ");
INSERT INTO puu_vpl VALUES ("JM5_1","089_5_1","JAS","5","1","1","Djenu bisine, wulwanu mbembu ami. Rodulanu ulile na tatanu! Dibandu maghughe amoduruyile. ");
INSERT INTO puu_vpl VALUES ("JM5_2","089_5_2","JAS","5","2","2","Busine bwenu bumabungene. Bikutu byenu bisyeghe na batsyelili. ");
INSERT INTO puu_vpl VALUES ("JM5_3","089_5_3","JAS","5","3","3","Mbongu tsyenu na mamani menu ma kembu bimabase maali. Dufundusu na maali meni. Dunyuru dwenu dubungu, dunyenzu. Dutsiwukighe busine yoyine tuke mu temu tsyusite. ");
INSERT INTO puu_vpl VALUES ("JM5_4","089_5_4","JAS","5","4","4","Dutsidyonge basatsi abatsisale mu manungi menu, dughabafute. Ulilebelili na mitatu myowu mimatole tena ombu Nzambi, Fumu mabadi. ");
INSERT INTO puu_vpl VALUES ("JM5_5","089_5_5","JAS","5","5","5","Dutsibeghe monyu wu maboti mu butambe, dwivayi mambu ame dwirondi, dwidji burange, mba dwivongi nane bibulu abibungulu, bikeboku mu ulighu. ");
INSERT INTO puu_vpl VALUES ("JM5_6","089_5_6","JAS","5","6","6","Dutsifundise batu abaghavaghe dibi, dutsibaboke wandi. Tumbe djowu baghaghaghene. ");
INSERT INTO puu_vpl VALUES ("JM5_7","089_5_7","JAS","5","7","7","Baane ba tadji, banu na pughu tena durughulu du Fumu. Tasanu muvaritsi ekeli na pughu milunde ami fwaru mi bivaru byandi, tena byubure. Ekeli mamvule amateghe na mamvule ma usite ameroyisi milunde. ");
INSERT INTO puu_vpl VALUES ("JM5_8","089_5_8","JAS","5","8","8","Djenu wandi banu na pughu, wangelenanu. Banu na yikanene mumbari yilumbu ayi Fumu etu oghabuyile yimabambene. ");
INSERT INTO puu_vpl VALUES ("JM5_9","089_5_9","JAS","5","9","9","Baane ba tadji, duyafundesenaange mumba Nzambi akédukilise. Wulwanu, nzonzi amabambene, ake va mune ndaghu. ");
INSERT INTO puu_vpl VALUES ("JM5_10","089_5_10","JAS","5","10","10","Baane ba tadji, mu dyambu di ditsoghe na pughu, bonganu yibaghunu yi babiyitsi abamavose mu dine di Fumu. ");
INSERT INTO puu_vpl VALUES ("JM5_11","089_5_11","JAS","5","11","11","Twivosyanu yi badji mu maboti, mumbari bamawarile. Mu Sobe, dumaghulu tsyeni amawarile mu temu ditsoghe. Djenu wandi, dwidjabi kabusulu adji Fumu Nzambi amamuveghe va disukusulu. Ngenze, Fumu Nzambi ane yingebe yi batu na ebavayi maboti. ");
INSERT INTO puu_vpl VALUES ("JM5_12","089_5_12","JAS","5","12","12","Baane ba tadji, viri-viri pa dwivosi dyambu, duyaleve pesi. Duyaleva Nzambi, duyaleva butambe, duyaleva pesi mu dyambu dyotsu. Pa dyambu didji ngenze, vosanu: «yine». Pa dyufure, vose yi «nesi». Vosanu nane mumbari bunzonzi bu Nzambi bukédughaange. ");
INSERT INTO puu_vpl VALUES ("JM5_13","089_5_13","JAS","5","13","13","Pa mutu va ghari enu etsoyi, asambili Nzambi. Pa mutu va ghari enu ane nzangu, awimbili noyitsi Fumu. ");
INSERT INTO puu_vpl VALUES ("JM5_14","089_5_14","JAS","5","14","14","Pa mutu va ghari enu ane ubele, anengili bivunde bi dibundu, bakemusinge matsi na usambile mu dine di Fumu. ");
INSERT INTO puu_vpl VALUES ("JM5_15","089_5_15","JAS","5","15","15","Dusambu nane dune dwivaghu na yitu, dubeluse yibedu mba Fumu omurelighe. Pa amavaghe mabi momutandu. ");
INSERT INTO puu_vpl VALUES ("JM5_16","089_5_16","JAS","5","16","16","Kaboghu tandesenanu mabi menu na sambilanu mu bambatsi, mumbari Nzambi akedubeluse. Dusambu du mutu odjivu asungeme va wusu Nzambi dune mangolu maneni. ");
INSERT INTO puu_vpl VALUES ("JM5_17","089_5_17","JAS","5","17","17","Tasetyanu Eli amabe mutu nane djetu. Amasambile Nzambi na yikanene mumba mvule djikémwénoghe. Ubandile va temu adjine mu bilime biryeru na yibuku, mvule djisamanoghe mu yinange yeni. ");
INSERT INTO puu_vpl VALUES ("JM5_18","089_5_18","JAS","5","18","18","Va djulu vane, Eli amamwésambile mba mvule djikenoghe, na bivaru bikemwébende. ");
INSERT INTO puu_vpl VALUES ("JM5_19","089_5_19","JAS","5","19","19","Baane ba tadji, pa mutu va ghari enu amasile nzile Nzambi vale, mba wumosi emughabusi mu nzile eni, ");
INSERT INTO puu_vpl VALUES ("JM5_20","089_5_20","JAS","5","20","20","djabanu yiri, mutu oyighabusi muvayitsi mabi mu nzile, emughobuli o dufu. Nesi mabi mandi mabe pwele, Nzambi omutande moni.");
ALTER TABLE puu_vpl ADD FULLTEXT(verseText);
UNLOCK TABLES;
