﻿USE sofia;
DROP TABLE IF EXISTS sofia.pub_vpl;
CREATE TABLE pub_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES pub_vpl WRITE;
INSERT INTO pub_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Hiwahi Pathien Sapa Jesu Christa jarra Chongkahoi kha e. ");
INSERT INTO pub_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Chongkachoipa Isaiah ning hi-ang hin aleimije: <<Pathien ning aleiti, <Keining chongkaron ninma a kitir sik nin lampui akabol sik a.> ");
INSERT INTO pub_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Nerdiram a mi inkhat ning a-ong a, <Puma sik a lampui kha bolturu; Ama asena lampui kha mintunru!> >> ");
INSERT INTO pub_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Khawa soa John nerdiram a ahong kinlar, baptized athole kinroi a Pathien chong aleiril. <<Ninsetna ria heikir inlang baptized thoru, khan Pathien ning ninsetna anarangai mindam pesik,>> tia mipuideng aleiti. ");
INSERT INTO pub_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Judea ramsunga le Jerusalem khopui a kaom mipui katamtak John chongril karangai sik a anleisuok. Anmani ning ansetna ngai anleirilsuok, khan Jordan Tuidung a anmani ngaikha John ning baptized aleitho. ");
INSERT INTO pub_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","John ning satingkui mul a anbol ponder aleikei, akonga sawun kongkhit aleikhit, khan ama bak le in khachu khai le ramkhoining alei e. ");
INSERT INTO pub_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Amaning mipuideng aleiminjet, <<Kei kunuk-a akahong sik miringpa khachu kei neknum akolok e, keichu ama kekokrui kinkunna kusutsik kutunga rohoi suokmang. ");
INSERT INTO pub_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Keining nangni tui-a baptized kanatho, takkha amaning chu Ratha Kinthenga baptized anathosik e.>> ");
INSERT INTO pub_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Khawasoli sotlei a Galilee ramsunga kaom Nazareth ria Jesu aheiwa khan John ning Jordan Tuidung a baptized aleitho. ");
INSERT INTO pub_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Jesu ning tui ria aheisuokli, amaning marwan akinlong le Ratha ning achunga wathu anga ahong chum kha aleimu. ");
INSERT INTO pub_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Khan marwan ria rasa inkhat ahonga, <<Nanghi kasapa mirit tak kha ni e. Nuchunga kumulung atai.>> ");
INSERT INTO pub_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Khawasoli Ratha ning amakha nerdiram a aleiminse, ");
INSERT INTO pub_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Khawa munkhan nisom-minli a-om a, Seitan ning aleimathem. Ramsa ngainum khana anlei om, takkha marwan tirle ngaining anhonga ama anleisen. ");
INSERT INTO pub_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","John mikhumna sunga anda sonuk a, Jesu ning Galilee ase-a khan Pathien ria Chongkahoi ngaikha aleiril. ");
INSERT INTO pub_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","<<Apha kha ahongtungjei, khan Pathien Rengram kha anaijei! Ninsetna ria mulung thul inlang Chongkahoi kha taksen ru!>> amaning aleiti. ");
INSERT INTO pub_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Jesu ning Galilee tuitham pangteng alonlai, amaning ngakusur miring inni, Simon le ama naipa Andrew, lenna nga ansur aleimu. ");
INSERT INTO pub_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Jesu ning anmanideng aleiti, <<Heiwaru kunuk nujuiru, khan keining mi kusur kinimin chusik.>> ");
INSERT INTO pub_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","khawalai takkhan anlen ngai anda a anmani ngaikha amale kinroia anleise. ");
INSERT INTO pub_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Khan amaning akalakdet aseli alop unai inni, Zebedee naite ngai, James le John aleimu. Anmani ning rukuong sunga anlen ngaikha wor thanasik anleibol. ");
INSERT INTO pub_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Khan Jesu ning anmani amuli, anmani kha aleikoi; khawa khan anmani ning anpa Zebedee le anlomroi ngaikha rukuong sunga anleida a Jesu nuk anleijui. ");
INSERT INTO pub_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Jesu le ama thiemroi ngai Capernaum khopui a anheiwa, khan aban Jehudi ngai Serni ning Jesu ning synagogue aseli aleiminchu. ");
INSERT INTO pub_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Ama minchudan akajet mi rikip ning anleingak, ajarchu amakha Dan Oja ngaile leikin angmak, khawa nek a, amaning thotorna le kinroi a aleiminchu. ");
INSERT INTO pub_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Khawapha takkhan ratha kathamak kulut mi inkhat synagogue aheilutli aleikheek, ");
INSERT INTO pub_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","<<Angmi keini denga numunom, Nazareth Jesu? Keini kimin mang sik hin naom mi? Keining nang kanajet, Nangchu akintheng Pathien chongkaron kha ni e!>> ");
INSERT INTO pub_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Jesu ning ratha deng chong ape, <<Omchenro, khan mipa deng ri heisuok ro!>> ");
INSERT INTO pub_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Ratha kathamak khaning mipa kha ranaktak a aleimin nok a, khan aong-akheekli mipa deng ria aheisuokjei. ");
INSERT INTO pub_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Mipui ngai ning anleingak, khawakhan anmani inkhatle inkhat ning ankinrakal, <<Hiwahi angmi? Hiwa minchuna hi athermi? Hiwa mipa hining ranak kaneitak a ratha kathamak ngaideng chongpena aleinei, khan anmani ning achong anleijui!>> ");
INSERT INTO pub_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Kha angkhan kinrem tak a Galilee ram pumpui a Jesu chong ngaihi alei kinthang. ");
INSERT INTO pub_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Khawasoli Jesu le ama thiemroi ngai, James le John kinroi a, synagogue anmathaanna khan Simon le Andrew ngai inteng anleise. ");
INSERT INTO pub_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Simon terpi kha ritun athoa phenchunga aleijal, Jesu aheitungli, khawanu chongkha amadeng anleiminjet. ");
INSERT INTO pub_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Amaning khawanu deng ase a, akut ning akei dinga khan aleikeithei. Ritun ning khawanu kha amathanjei, khan numeisanu khaning anmani aleirajen. ");
INSERT INTO pub_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Kini tasoa kholei ahongtung khan, mi ngaining akana le khori kulut rikip ngaikha Jesu deng anheiroi. ");
INSERT INTO pub_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Khawa khopui a kaom mipui rikip ngaikha khawa inma khan anleikinchun. ");
INSERT INTO pub_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Jesu ning ri-rai kana mikatamtak ngaikha aleimindam khan khori katamtak alei holsuok. Khori ngaining amakha atumi ti anleijet, khawa jarra amaning khori ngaikha ite leiminrilmak. ");
INSERT INTO pub_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Jingteng kini suokmak ma, Jesu athei-a inn kha aleimathaan jei. Khopui ria aheisuok a adai ngerna munkhan Pathien nina aleinei. ");
INSERT INTO pub_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Takkha Simon le akinroipui ngaining ansuok a amakha anlei entok, ");
INSERT INTO pub_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","khan anmani ning ama anhong mu karkhan, amadeng anleiti, <<Mirikip ning nangkha ana entok.>> ");
INSERT INTO pub_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Takkha Jesu ning aleimasang, <<Hiwa khosir khopang ria einining inkhat teng nisesik. Kei ning anmanideng chong kirilsik, khawa sik jarra kei kahong e.>> ");
INSERT INTO pub_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Khawa jarra amaning Galilee ramrikip sunga aleise, synagogues a chong aleiril khan khori ngai alei holsuok. ");
INSERT INTO pub_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Chi kaomtak kaphar ri koron mi inkhat Jesu deng ahonga, akinkunna, nasenro tia nina aleinei. <<Nangning nana nompe inchu, kei nimintheng ro,>> amaning aleiti. ");
INSERT INTO pub_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Jesu deng minreng kha aleisip, akut akadomma aleikotok. <<Keining konom jei, kintheng taro!>> tia aleiti. ");
INSERT INTO pub_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Khawalai takkhan kaphar ri koron kha mipa deng ria asuok a, khan amakha adamjei. ");
INSERT INTO pub_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Khan Jesu ning chong kanger kha amadeng arilla amakha aleiminse, ");
INSERT INTO pub_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","hi-ang hin amadeng ati sonuk, <<Rangairo, hiwahi atu deng khatnum rilmaro. Takkha thiempu deng wasero khan amaning nang na-en rase; khanchu mirikip deng nadamjei ti anjet nasik a, Moses chongpe dungjui a kinthoina kha hongtho ro.>> ");
INSERT INTO pub_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Takkha mipa kha asuok a amun rikip a akasuok chong ngai kha aleiril minthang, khawa jarra, Jesu kha kinlar a khopui khan leisuok tor mak jei. Khawa nek a, mun kadai-ngera aseli awa-om, tak amun rikip a kaom mipui ngaining ama kolla anheiwa. ");
INSERT INTO pub_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Nikho alek soa Jesu ning Capernaum teng aleikirnok, khan inna khan ama aom jei ti chong alei kinthang. ");
INSERT INTO pub_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Khawa jarra mi katamtak anheiwa a khawakhan tungnasik mun korok leiommak, inkhar ma kutunga amun leirok mak. Jesu ning Pathien chongkha anmanideng aleiril lai ");
INSERT INTO pub_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","pasal minli ngaining, alang kithipa inkhat Jesu deng anhei kadomma anhongpha. ");
INSERT INTO pub_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Mipui antam hei jarra, mipa kha ama kolla heilutpui tormuk. Khawa jarra anmani ning Jesu omna inchung khan anmin wenga mipa kha ajalna pher le kinroi a anhei makhai minchum. ");
INSERT INTO pub_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Anmani ngaikha kha-angtuk taksenna kha alei mukar, Jesu ning alang kithi mipa deng aleiti, <<Kasapa, nisetna ngaikha kanarangai mindam sojei.>> ");
INSERT INTO pub_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Khawa khan alei kin ong Dan oja alekning anbinga anleimindon, ");
INSERT INTO pub_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","<<Kho-ongmo amaning hi-anghin achong tor e? Hiwa hichu Pathien chunga arildek e! Pathien amabei e setna karangai mindam torchu!>> ");
INSERT INTO pub_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Khawa laitak a Jesu ning anmani mulung mindon kha ajet a, anmanideng aleiti, <<Angsikmi khawa angkhan nin mindon e? ");
INSERT INTO pub_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Alang kithi mipa deng, <Nisetna ngai kanarangai mindam pejei,> ti a-imakli, <Kinding inlang, napher kodom inlang, khan lonro, ti himo abeidet?> ");
INSERT INTO pub_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Keining nangni deng niril minchenpe kate, Miring Sapa ning leithoichunga setna rangai mindam sik ranak anei.>> khawa jarra amaning alang kithipa deng aleiti, ");
INSERT INTO pub_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","<<Keining nangdeng kiti, theiro, napher lei inlang, khan ni-inna setro!>> ");
INSERT INTO pub_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Anmani ning an-inna an-omlai, mi pakha atheili, apher kha akadomma kinnot a mipui maikunga aleisuok. Anmani rikip ning anleingak a Pathien anleiminpak, <<Eini ning hiwa anghi lumungai phitmakmi!>> anleiti. ");
INSERT INTO pub_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Jesu ning woikhat Galilee tuitham pangteng ahong kirnok a. Mipui katamtak amadeng anheiwa, khan amaning anmani kha minchuna aleiphut jei. ");
INSERT INTO pub_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Ama kha-ang khan asena, amaning ramsel karathai, Alphaeus sapa Levi ramsel telna inna aleikin ong kha aleimu. Jesu ning amadeng, <<Nujuiro,>> aleiti. Levi ning akinding a anuk aleijui. ");
INSERT INTO pub_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Khawa soa Jesu ning Levi inna bu aleibak. Ramsel karathai katamtak ngaile setkoron ngaining Jesu nuk anleijui, khanna anmani katamtak ning amale athiemroi ngaikha bu anlei bakbung. ");
INSERT INTO pub_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Dan Oja alek, Pharisees num aki e, Jesu ning ramsel karathai le setkoron ngaile bu anbak bungkha anleimu, khawa jarra ama thiemroi ngaideng anleirakal, <<Angsikmi amaning hiwa mi ngaile abakpui hi?>> ");
INSERT INTO pub_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Jesu ning hiwa ajet a anmanideng aleimasang, <<Akadam ngaisik chu thiempu rangaimak, takkha akana ngaisik bei arangai. Keining kahong hichu mikidik ngai akakoi kahong imong, takkha setkoron ngai akakoi kahong e.>> ");
INSERT INTO pub_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Rei inkhat a John Baptist anuk kujui ngai le Pharisees ngai ning bu anleingei. Mi alek ning Jesu deng anhonga anleirakal, <<John Baptist thiemroi ngaile Pharisees thiemroi ngaining bu an-ngei a, khan nang thiemroi ngaining angsik mi bu an-ngeimak e?>> ");
INSERT INTO pub_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Jesu ning aleimasang, <<Moiroina akahong khomol ngaikha bu baklei ankir sik ninti mi? Kha imak! Moipa ning anmanile aomlai sengchu, anmani ning kha-ang thononung. ");
INSERT INTO pub_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Takkha moipa kha anmanideng ria anroi sik nikho alahongsik e, khawa karkhan anmani bu anlangei sik e.>> ");
INSERT INTO pub_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","<<Atu inkhat ningnum pon kather awerkhat kha pon maro a kuthui delmuk, ajarchu pon kather awerkhat khaning pon maro kha akeirinna, akolok det a akinther sik. ");
INSERT INTO pub_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Khanok chu atute ningnum sawun juhai muro a juther dangaimak, ajarchu ju khaning sawun juhai aminkoi sik, khan ju le sawun juhaikha akinmang sikjei. Khawa nek a, juther kha sawun juhaither a thunsik e.>> ");
INSERT INTO pub_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Jesu ning Jehudi Serni kini khan sang billa aleise. Ama thiemroi ngai ning amale anheiwalai, anmani ning sawui kha anlei richil. ");
INSERT INTO pub_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Khawa jarra Pharisees ngaining Jesu deng anleiti, <<Enro, nang thiemroi ngai ning eini Dan le akintok mak Jehudi Serni ning antho hi!>> ");
INSERT INTO pub_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Jesu ning aleimasang, <<Nangni paalei mo nin e David ning angmo aleitho baksik inkhat amanompha? Ama le ami ngaining anwon acham karra, ");
INSERT INTO pub_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","amaning Pathien inn alut a khan Pathien denga anpe waipol kha aleibak. Hiwahi Abiathar ning Thiempu Chungnung achang laikhan aleisuok. Eini Senadan dungjui a hiwa waipol hichu thiempu beining anbak sik e tak David ning num aleibak, khan ama mi ngainum aleipe.>> ");
INSERT INTO pub_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Khan Jesu ning atorna ati, <<Jehudi Serni kini hichu miring ngai thanasik a anbol e; miring ngaihi Jehudi Serning kini sik a abol imak. ");
INSERT INTO pub_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Khawa jarra Miring Sapa hi Jehudi Serni kini ning sik num Puma e.>> ");
INSERT INTO pub_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Khan Jesu ning Synagogue aleikirnok, khawa khan akut kithi miring inkhat aleiom. ");
INSERT INTO pub_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Jesu ning akidikmak atho tia akitinom mi alek khawakhan anleiom; khawa jarra Jehudi Serni kini khan amaning mipa kha amindam sikmi tia akatha anlei ensui. ");
INSERT INTO pub_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Jesu ning mipa deng aleiti, <<Hiwa amateng hin hongkalro.>> ");
INSERT INTO pub_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Khan amaning mi ngaideng aleirakal, <<Jehudi Serni kini khan eini Senadan ning angmo tho atha ati e? Sansik mi a-imakli akathamak tho sikmi? Mi inkhat ringkho sansik a-imakli minmang sik mi?>> Takkha anmanining ite leirilmuk. ");
INSERT INTO pub_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Jesu ning amit alei kiwella anmanideng alei enna aleirang, tak anmani sik mulung leihoipui mak, ajarchu anmani mulung kanger le anthamak jarra aleipongpui. Khawasoli amaning mipa dengkhan aleiti, <<Nu kut keisoro.>> Amaning akut aheikeiso a, khan akutkha amasa anga aleidam. ");
INSERT INTO pub_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Khawa jarra Pharisees ngaining Synagogue anmathaanna anleise khan Herod mi alek ngaile kinnot a ankinmu a, anmanining Jesu thatnasik sin anleikinthok. ");
INSERT INTO pub_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Jesu ning athiemroi ngaile Galilee tuitham teng anleise, khan mipui katamtak ning anuk anleijui. Anmani ngaikha Galilee, Judea ria anleihong, ");
INSERT INTO pub_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Jerusalem, Idumea, Jordan nisotenga, khan Tyre le Sidon khopui asir-apang ria anhong kinphut. Hiwa mirikip ngaihi Jesu deng anleihong ajarchu amaning atho ngaikha anleijet. ");
INSERT INTO pub_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Mipui antamhei jarra ama an-uum maknasik Jesu ning athiemroi ngaideng rukuong inkhat amasik rathok ru aleiti. ");
INSERT INTO pub_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Amaning mi katamtak aleimindam, khan akana rikip ning ama kotok nasik anlei kin et-tarpui ama omnateng anlei nai. ");
INSERT INTO pub_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Khan Ratha kathamak kulut mirikip ning ama anmu karkhan, anmani ning amaikunga anleipur khan anlei-ong, <<Nangchu Pathien Sapa kha ni-e!>> ");
INSERT INTO pub_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Jesu ning ratha kathamak kulut anmani ngaideng ama atu mi tihi atu inkhat deng rilmuru tia chong kangertak aleipe. ");
INSERT INTO pub_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Khan Jesu ning chingmuol chunga akalla khan amaning amonom mi ngaikha aleikoi. Anmani ning amadeng anheiwo a, ");
INSERT INTO pub_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","khan amaning somle-inni ngaikha aleikadang, tirle tia aleipho. <<Kei le akaom sik a nangnihi kanakadang ejei,>> amaning anmanideng aleiti. <<Keining nangni chongkiril sik a kunumuso sik, ");
INSERT INTO pub_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Khan khori ngai holsuok nasik ranak ninnei sik.>> ");
INSERT INTO pub_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Hiwa senghi amaning akadang somle-inni ngaikha an e: Simon, Jesu ning Peter tia ariming apho; ");
INSERT INTO pub_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","James le anaipa John, Zebedee ngai naite, Jesu ning Boanerges tia ariming aleipho, hiwa tinachu <<Rokinri Mi>> ");
INSERT INTO pub_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andrew, Philip, Bartholomew, Matthew, Thomas, James Alphaeus sapa, Thaddaeus, khan Canan ria Simon, ");
INSERT INTO pub_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Khan mi khutchunga akapesuok sikpa Judas Iscariot, hiwa ngaihi an e. ");
INSERT INTO pub_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Khan Jesu inn teng aleise. Mipui akatamtak anhong kinchun nok a Jesu le athiemroi ngaikha bubak nasik pha leinei muk. ");
INSERT INTO pub_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Ama insung mi ngaining hiwa chong anjetkarra, anmani ning amakha roisuok nasik anleitho, ajarchu mipui ning anleiti, <<Amahi akinwetjei!>> ");
INSERT INTO pub_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Jerusalem teng ria akahong Dan Oja alek ngaining anleiti, <<Ama sunga Beelzebul aom! Anmani holsuok nasik amadeng ranak akape kha khori ngai lukakeipa e.>> ");
INSERT INTO pub_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Khawa jarra Jesu ning anmani ngaikha akolla akoi-a khan anmanideng chongtekak ngaikha aleirilpe: <<Seitan ning kho-ongmo seitan aholsuok tor sik? ");
INSERT INTO pub_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Rengram inkhat ning ankin khoithenna rupni ansuokli inkhatle inkhat ankinsol inchu, khawa rengram kha akoisik e. ");
INSERT INTO pub_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Insung inkhat akin khoithenna rupni ansuokli inkhatle inkhat ankinsol inchu, khawa insung kha akoisik e. ");
INSERT INTO pub_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Khawa jarra Seitan rengram hi rupni suok a ankin khoithen inchu, khawakha sotno ning, takkha koi ata ahekna amang ripsik e. ");
INSERT INTO pub_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","<<Tu inkhat ningnum akarat mipakha ankhit masa a adamak inchu; a-inna lutli neinak rikip kha khektor nonung. Kha inchu mipa kha ankhit masa inchu neinak kha ankhektor sik. ");
INSERT INTO pub_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","<<Akidik a keining nangnideng kiti hi e, khachu mi ngai setna le akathamak rikip anril angjet aleiom inum rangaimindam pesik e. ");
INSERT INTO pub_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Takkha atu inum Ratha Kintheng chunga akirildek ngaikha angtikkar inum rangaimindam penoning, ajarchu amaning kumleiko setna athojei.>> ");
INSERT INTO pub_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","<<Ama sunga ratha kathamak kha aom>> mi alek ning anti jarra, Jesu ning hiwahi aleiti. ");
INSERT INTO pub_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Khan Jesu anu le anaingai anhongtung. Anmani ning inn tolla anngirra khan ama kinmu pui sik a chong anlei muso. ");
INSERT INTO pub_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Jesu akolla mipui katamtak anlei kin ong, khan anmani ning amadeng anleiti, <<Enro, nunu le nu-u nanai, naser ngaining tolla nang ana kinmu puinom a an om.>> ");
INSERT INTO pub_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Jesu ning aleimasang, <<Atumi kei kunu? Atumi kei ku-u kanai ngai?>> ");
INSERT INTO pub_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Ama akolla akin-ong mipui ngaikha ahei enna aleiti, <<Enru! Hinna akaom ngaihi kei kunu le ku-u kanai ngaikha an e! ");
INSERT INTO pub_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Atu-tu inum Pathien lungdo kutho ngaikha ku-u, kanai, kunu le kaser ngaikha an e.>> ");
INSERT INTO pub_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Jesu ning Galilee tuitham panga minchuna aleiphut nok. Ama akolla anhong kinchun mipui ngaikha antam hei jarra amaning rukuong sunga alut a alei kin ong. Rukuong kha tuichung a aleiom, khan mipui ngaining tuipanga anleikintup. ");
INSERT INTO pub_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Amaning chongtekak ngai aneiman a anmanideng chong katamtak aleiminchu, khan anmanideng aleiti: ");
INSERT INTO pub_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","<<Rangairu! Phakhat a mipa ning muchiru kaworsik a aleisuok. ");
INSERT INTO pub_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Amaning lei a muchiru kha aheiworkar, alek ning lampui sirra ata, khan wa ngaining anhonga a anleibak. ");
INSERT INTO pub_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Alek ning lungkarra leipil tomna khan aleita. Muchiru kha kinranga ahongmong, ajarchu leipil kha lei kinthuk mak. ");
INSERT INTO pub_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Khan, kini ahongsuok karra, muchikek ngaikha akinwoi a aleicharjei; ajarchu anrujung kha akinthuk a alutmak jarra. ");
INSERT INTO pub_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Muchiru alekning riling-bil karra aleita, anhongmong takkha riling ning aleidiip a, kara leineimuk. ");
INSERT INTO pub_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Takkha muchiru alekchu leipil thana-a aleita, muchiru ngaikha anhongkek a, anhong kin-son khan kara anhongnei, alekning somthum, somruk, khan alekning reijakhat anhongkinra.>> ");
INSERT INTO pub_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Khan Jesu ning atorna aleiti, <<Kour ninnei inchu hiwahi rangai ru!>> ");
INSERT INTO pub_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Jesu kha abinga aleiom lai, achong leikajet alek ngaile athiemroi somle-inni ngai amadeng anheiwa khan Chongtekak ngaikha kinchenna rilchen nasik amadeng anleirakal. ");
INSERT INTO pub_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Jesu ning aleimasang, <<Pathien Rengram jarra akin-iip ngaikha anape jei.>> Takkha tu inum tolla kaom milak ngaisik chu, chongtekak hining hiwa rikip ngaihi anjetsik, ");
INSERT INTO pub_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","khawa jarra, << <Anmanining enchu an-en sik, takkha munonung; anmanining rangaichu anrangai sik, takkha jetnonung. Kha-ang antho inchu, anmani ning Pathien deng anheikir noksik, khan amaning anmani ngaikha arangai mindamsik.> >> ");
INSERT INTO pub_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Khan Jesu ning anmanideng aleirakal, <<Hiwa chongtekak hi nangni ning jetlei mo nin e? Kha inchu, nangni ning alak chongtekak ngai kho-ongmo ninjet torsik? ");
INSERT INTO pub_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Muchi kaworpa ning Pathien chongkha awor. ");
INSERT INTO pub_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Miring alek khachu lampui-sir a akata muchi ngaikhale akin-ang; anmani ning khawa chongkha kinranga anjetli, Seitan khan aheiwali amulung sunga kaom chongkha akhekjei. ");
INSERT INTO pub_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Miring alek ngaining lungkarra akata muchi khale akin-ang. Anmani ning khawa chongkha kinranga anjetli, rokpui tak a anleiralang. ");
INSERT INTO pub_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Takkha anmani mulung kinthuk a leilutmak, ajarchu anmani akasot a leidei tormuk. Khawa chong jarra khan, pongna a-imakli minpongna aheiwakar khanchu, anmani ning kinremma anmoso. ");
INSERT INTO pub_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Miring alek ngaikha riling bil karra akata muchi khale akin ang. Anmani ngaihi chong kajetjei ngaikha an-e, ");
INSERT INTO pub_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","takkha hiwa ringkho sik a mulung pongna, neile hoi kumunom, khan alalak munomna rikip ngaikha ahonglut a, khawa chongkha anminmang, khan anmani ning kara neimuk. ");
INSERT INTO pub_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Takkha miring alek khachu leithoi thana munna anwor muchi khale ankin-ang. Anmani ning chongkha anrangai, anleiralang, khan kara annei: alekning somthum, somruk, khan alekning reijakhat akara.>> ");
INSERT INTO pub_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Jesu ning arilminjom, <<Tu inkhat ning thangmei aheichoi a Taidon thoia a-imakli phenchung thoi a anda ngaimi? Thangmei mutungna chunga anda-ngai ileimi? ");
INSERT INTO pub_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Alei kinthup ngaikha alahong kinlar sik e, khan alei kinkhu rikip ngaikha ala kinlong sik e. ");
INSERT INTO pub_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Kuor kanei ning hiwahi rangairu!>> ");
INSERT INTO pub_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Amaning anmanideng aleiti, <<Nangni ninjet ngaikhan kinsing theiru! Nangni ning mi ngai chunga chong nintan anga nangni dengnum Pathien ning atansik e, takkha akikheldet sik e. ");
INSERT INTO pub_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Alek akanei ngaikha khella akinpe sik, khan akanei phitmak ngaikha ama anei alekkha akinkhek del sik e.>> ");
INSERT INTO pub_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Jesu ning aleirilnok, <<Pathien Rengram khachu hi-ang e, mipa inkhat ning ama leipuk a muchiru awor khale akin-ang. ");
INSERT INTO pub_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Amaning jaanna ajal, suun eli athei sik, khan khawa awor muchiru ngaikha anheikek a anheimong. Kha inum amaning kho-ongmo aheimonga aheikhang e ti leijetmak. ");
INSERT INTO pub_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Leipil khaning muchikek ngaikha aminmong khan anheikara; amasatak adon anheisuok, khanchu aheiper, khan atorna a sawui katha kha akara. ");
INSERT INTO pub_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Sang kha aminkara, mipa ning koite ning sang ka-at aleiphut, ajarchu sang-at phakha aheitungjei.>> ");
INSERT INTO pub_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Jesu ning aleirakal, <<Pathien Rengram hi anglemo akin-ang niti sik? Eini ning ang chongtekak mo nineiman li niril minchen sik e? ");
INSERT INTO pub_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Khawa khachu, Mipa khaning leithoichunga anchamru akisintak aru achoi a, khan leipilla awor khale akin-ang. ");
INSERT INTO pub_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Apha alek so a ahongkomong anser-leina ngai karra akaloktak inkhat ahongchang. Khan abaak kolok ngai ahongsuok a khawa khan wa ngaining anrubu anleisak.>> ");
INSERT INTO pub_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Jesu ning ama chongkha mi ngaideng aleiril, hiwa anga chongtekak katamtak ngaihi aneimanna; amaning anmani anjettor laiseng aleirilpe. ");
INSERT INTO pub_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Amaning chongtekak kinchallei a anmanideng ite inkhat num leirilpe mak, takkha ama thiemroi ngaile bei an om karkhan, amaning kinchenna angrikip ngaikha anmanideng aleirilpe. ");
INSERT INTO pub_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Khawa nitak kholeiteng khan Jesu ning athiemroi ngaideng aleiti, <<Eini tuitham ralkhat teng kai inlang se rangri.>> ");
INSERT INTO pub_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Khawa jarra anmani ning mipui ngaikha aleimathaan; athiemroi ngaining Jesu alei chuongna rukuong khan anlut a, khan anmani ning amakha anleiroi. Rukuong aleknum khawa munkhan aleiom. ");
INSERT INTO pub_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Jetlei theilei a phaiwo pui karat inkhat ahongranga, tui akinnok khan rukuong pangkha ahong jemma tuikulut aleiphut, rukuong kha tuining hongsip sik aleitho. ");
INSERT INTO pub_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Jesu ning rukuong nukteng khan, montum aneia aleijal. Athiemroi ngaining ama ankeithei a anleiti, <<Oja, keini thisik kintijei nadonlei sikmo ni-e?>> ");
INSERT INTO pub_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Jesu ning angir a phaiwo dengkhan chong aleipe, <<Omchenro!>> khan amaning tuikinnok dengkhan aleiti, <<Kinnok maro!>> phaiwo kha rangmak jei, khan arikip ahongdaijei. ");
INSERT INTO pub_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Khan Jesu ning athiemroi ngaideng aleiti, <<Angsikmi kha-angtuk ninchi e? Tunkutung nangni taksenna ninlaneimak e?>> ");
INSERT INTO pub_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Takkha anmani ning anchi hei a inkhatle inkhat deng anlei-kinril, <<Hiwa mipa hi atumi? Phaiwo le tuikinnok ningnum amachong anjui hi!>> ");
INSERT INTO pub_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Jesu le ama thiemroi ngai Galilee tuitham ralkhat teng, Gerasa ramkol teng anwatung je. ");
INSERT INTO pub_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Jesu rukuong ria kinrangtak a ahei suoklimli, thaan khur ria ahei kosuok pasal inkhat ning ama alei kintong pui. Hiwa mipa hi asunga ratha kathamak aleikoron a e, ");
INSERT INTO pub_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","khan thaanna alei kaom e. Tute ningnum thirrui khit a anda tormak je alei e; ");
INSERT INTO pub_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","ake le akut thirrui a anlei khitchak, tak apha rikip a thirrui kha aphoi chet a thir khaning ake alei rachak. Ama ranak aleirat rangra khana tu tening num leikhap tormuk. ");
INSERT INTO pub_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Sun le jan thaan le chingmoul kutung alonna, aleikheek a khan abinga lungning aleikin-at. ");
INSERT INTO pub_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Amaning akalakdet a-om lai Jesu kha aleimu; khanchu alei taanna, amai kunga kemorkhup athep a aleikinkun, ");
INSERT INTO pub_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","khana aleikheek a, <<Jesu, Akin Sangtak Pathien Sapa! Kei angmo nulo rong niti e? Pathien jarra, kinini e, kei nimin pong moro!>> ati. ");
INSERT INTO pub_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Amaning hi ati ajarchu Jesu ning aleiti, <<Ratha kathamak, hiwa mipa ria heisuokro!>> ");
INSERT INTO pub_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Khawa jarra Jesu ning amadeng aleirakal, <<Niriming angmi?>> Mipa ning aleimasang, <<Kei kiriming, <Akatam> ajarchu keini kintam!>> ");
INSERT INTO pub_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Khan khawa ram ria ratha kathamak ngaikha aholsuok mak nasik amaning Jesu deng akin ni a aleiom. ");
INSERT INTO pub_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Khawa kolla khan wok katamtak rup inkhat khawa chingkolla khan bu anbak a anleiom. ");
INSERT INTO pub_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Khawa jarra ratha kathamak ngai khan Jesu deng anleini, <<Wok ngai deng son numoso ro, asunga lutkinte,>> ");
INSERT INTO pub_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Amaning aminse jei, ratha kathamak ngai kha mipa deng ria ansuok a wok ngai sunga anhong lut je. Wok ngaikha akin chuna lising inni kopo an e, korolkham ankin chom thak a tuitham sunga anlut rip jei. ");
INSERT INTO pub_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Wok kakhal ngai kha antaan a khopui sunga le akho khoa anwaril minthang jei. Mipui ngaikha omchen akosuok aka-en sik anheiwa. ");
INSERT INTO pub_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Khana anmani ning Jesu deng anhong karra, akatam khori koronpa kha anleimu. Ama khana khan alei kin ong, pon akinsilla akilim senga aleiom; khan anmani rikip ning anlei chi. ");
INSERT INTO pub_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Khori kulutpa le wok ngai chunga kosuok omchen aleikumu ngaining mipui ngaideng anleiril pe. ");
INSERT INTO pub_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Khawa jarra anmani ning Jesu deng anram moso nasik a anleiti. ");
INSERT INTO pub_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Jesu ning rukuong sunga alutlai, khori koronpa khaning, <<Nangle sebung ri!>> tia aleikinni. ");
INSERT INTO pub_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Takkha Jesu ning leinom pe mak. Khawa nek a amaning aleiti, <<Nang na-inna kir-inlang na-insung mi ngaideng angtuk a Puma ning nangsik a anathope le anaminreng kha waminjet ro.>> ");
INSERT INTO pub_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Khawa jarra mipa kha Decapolis (tinachu Khopui som) kutungbit aleise, Jesu ning amasik angtuk a mo athope e ti kha awaril je. Khan akajet rikip ngaining anleingak. ");
INSERT INTO pub_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Jesu tuitham ralkhat teng rukuong a akirnok. Khawa tuitham kolla khan mipui katamtak akolla ankintup je. ");
INSERT INTO pub_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Jairus, khawa kho synagogue sik a sin koronpa, ahongtunga, khan Jesu amu a akekunga abinga ahongkinbok, ");
INSERT INTO pub_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Khan mulung kuluttak a aleikinni, <<Kasanu kisin ranak tak a ana je. Minreng tak a hong inlang adam nasik le aring nasik achunga nukut nawada pero!>> aleiti. ");
INSERT INTO pub_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Khan Jesu ama le kinroi a ase a, khan mi katamtak Jesu le kinroi a mipuining amakha anuk-ama ankin et-tarpui je. ");
INSERT INTO pub_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Khawa khan kum somle inni thi akosuok khodeng kathei tak numeisa inkhat aleiom, ");
INSERT INTO pub_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","mika en thiempu katamtak ning anlei en rawang leidam mak. Asumsan nei rikip aleineiman so je, tak akana adampui nek a apha rikip a akintet det je. ");
INSERT INTO pub_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Khawanu ning Jesu chungchanga aleijet, khawa jarra mipui karra ahonga anukteng ahei jui, ");
INSERT INTO pub_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","abinga alei kinti, <<Aponmor bei inum kokotok tor inchu damna kanei sik.>> ");
INSERT INTO pub_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Khawanu ning aponmor alei kotok a, athi kosuok kha khawa phatak a abang je; khana akana kha adamjei tikha abinga mulung sunga akinjet. ");
INSERT INTO pub_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Khawa laitak khan Jesu ning ama ria aranak akosuok kha aleijet je, khawa jarra amaning mipui ngaideng ahei kinhei a a-enna aleirakal, <<Atu ningmo kopon akotok e?>> ");
INSERT INTO pub_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ama thiemroi ngaining anheimasanga, <<Mipui hiseng hining ana-umtur numu; angsik a mo nangdeng anukotok kha nana rakal e?>> ");
INSERT INTO pub_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Takkha Jesu ning khawa akotok mikha amu nasik asir-apang alei en. ");
INSERT INTO pub_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Numeinu achunga omchen kosuok kha akin jet a, achi pumma ahonga, ake kunga akinkunna, akidik rikip kha amadeng awaril je. ");
INSERT INTO pub_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Jesu ning khawanu deng aleiti, <<Kasanu, nataksenna khaning animindam eje. Akahoi-akadai a setro, napongna ria dam rang ro.>> ");
INSERT INTO pub_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Jesu ning hi arillai, Jairus inn ria chongkoron mi alek anhonga amadeng anlei ti, <<Nasanu kha athijei, Oja kha angsik mo niminpong sik e?>> ");
INSERT INTO pub_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Angmi anmanining anleitikha Jesu ning leirangai pemak, takkha lamkakeipa deng aleiti, <<Chimaro, taksen bei taksen ro.>> ");
INSERT INTO pub_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Khan amaning Peter, Jame khan anaipa John ilei a tute anuk leimin juimak. ");
INSERT INTO pub_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Anmani ning Jairus inn anheitung je, khanna khan mingai kinhangna le chap ong rasa rikip Jesu ning aleijet. ");
INSERT INTO pub_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Insung alut a anmanideng aleiti, <<Angsik mo ankin hang e? Angsik mo ninchap e? Naipangnu hi akithi imak, akajal e!>> ");
INSERT INTO pub_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Anmani ning anlei munuipui, khawa jarra amaning anmani rikip tolla aleiminsuok, naipangnu anu le apa khan athiemroi inthum ngai aroi a naipangnu jalna den sunga anlut je. ");
INSERT INTO pub_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Amaning naipangnu akut ama-o a aleiti, <<Talitha, Koum,>> hiwa tina chu, <<Naipangnu, keining thei ro kiti!>> ");
INSERT INTO pub_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Khawa laitak khan naipangnu kha akinding a aleilon jel. Naipangnu kha kum somle-inni a ije. Khawa omchen asuoklai khan, anmani ning anleingak. ");
INSERT INTO pub_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Takkha Jesu ning atukhat dengnum rilmaknasik tia anmanideng chong kharna aleinei, khan Jesu ning aleiti <<Naipangnu kha baksik angmikhat peru.>> ");
INSERT INTO pub_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Jesu ning khawa munkha amathaanli ama khopui teng aleikir je, ama thiemroi ngai num anlei jui. ");
INSERT INTO pub_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Jehudi Serni kinining synagogue a minchuna aleiphut jei. Mikatam tak khana khan anlei om, achong kha anjet a anmani rikip ning kinlak ansak rip je. <<Hiwa ngaihi khonarimo apha e? Ang singna mi amadeng akin pehi? Kho-ong mi sinkinlak ngai athotor hi? ");
INSERT INTO pub_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Amahi thingsin kothopa, Mary sapa, James, Joseph, Judas, khan Simon ngai ulenai kha elei mi? Anainu ngai hin an-om elei mi?>> khanchu anmani ning ama leidon muk je. ");
INSERT INTO pub_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Jesu ning anmanideng aleiti, <<Pathien chongkachoi ngaihi, akhosung le a-insung, khan ulenai elei a, mun rikip achu kajana annei e.>> ");
INSERT INTO pub_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Khawa munnakhan amaning akadam mak alek chunga akut ada a amindam elei a, sinkinlak ite leitho tormak. ");
INSERT INTO pub_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Mipui ning taksenna anleineimak jarra, Jesu ning aleingak. Khawasoli Jesu ning ase a asir apanga kaom kho ngaideng aleiminchu. ");
INSERT INTO pub_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Amaning thiemroi somle-inni ngai kha akoitup a khan mi ini-ini-a aleimoso. Ratha kathamak ngai chunga thotorna ratha aleipe, ");
INSERT INTO pub_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","khan chong aleipe, <<Ninlam nin se na khengrol elei a neinak inkhat te ron dal muru, waipol, paitu, sumsankok a sumsan, choi muru. ");
INSERT INTO pub_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Keto chuongru, tak songkol akikhel choi muru.>> ");
INSERT INTO pub_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Amaning anmanideng arilnok a, <<Mingai ning analeidonna mun nakhan, amun kha nada mak laiseng khawa inna khan omru. ");
INSERT INTO pub_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Khopui inkhat a nahong lut karkhan mi ngai ning analeidon mak a-imakli nachong an rangaimak inchu, khawa mun kha leidaru khanna ninkepha ruhut leikithing thak ru. Khawa kha anmani sik mulungkoina achang sik!>> ");
INSERT INTO pub_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Khawa soli anmani ning anleisuok a mingai kha ansetna ria mulung thulnasik chong anleiril. ");
INSERT INTO pub_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Anmani ning khori katamtak holsuokna anleinei, khan akana mi katamtak ngai chunga Olive sarek akonot a anmindam jei. ");
INSERT INTO pub_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Tunchu Reng Herod ning angrikip chungchanga ajet je, ajarchu Jesu riming athana kha mun rikip a alei kinthang je. Mi alek ning anleiti, <<John Baptist thina ria ahong ringnok je! Khawa jarra hi-ang sinkinlak thonasik ranak hi anei e.>> ");
INSERT INTO pub_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Achang rawang alek ning anleiti, <<Amahi Elijah e.>> Alek ning anleiti, <<Amahi atenlai aleikaom Pathien chongkachoi anga Pathien chongkachoi inkhat ang e.>> ");
INSERT INTO pub_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Herod ning hiwo ajet a, amaning aleiti, <<Amahi John Baptist e! Keining alu kalei tan e je, tak ahong ringnok je!>> ");
INSERT INTO pub_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Herod atakning John surna sik chong aleimoso, khan thir rui ning aleikhit a khan mikhumna sunga aleida. Herod ning hi-ang aleitho hi anaipa Philip numei amaning alei kusut a alei ompui hi, Herodias jarra e. ");
INSERT INTO pub_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","John Baptist ning Herod deng hi-ang aril pe chak, <<Nanaipa numei na-ompui sik hi nangsik akidik imak!>> ");
INSERT INTO pub_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Khawa jarra Herodias ning John kha lei-en nommak khana that sik a aleimindon, tak Herod a-om jarra leitho tormak. ");
INSERT INTO pub_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Herod ning John kha aleichi ajarchu John kha mi katha le akintheng e ti aleijet. Herod ning John chongril arangai phakhan mulung aleipong inum ama chongril kha aleirangainom, khawa jarra amakha akathatak a aleida. ");
INSERT INTO pub_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Atorna Herodias ning apha kathatak aleimu je. Khawakha Herod aneining nikho e, khawa ning amaning ram waikaron akolok rikip, raal lamkakei, khan Galilee ram kakei ngai bak minchunna athopui na pha kha e. ");
INSERT INTO pub_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Herodias sanu aheilut a ahong laam, khan Herod le khomol ngaiseng kha anmulung aleimintai. Khawa jarra rengpa ning numeisanu deng aleiti, <<Angmi nangning nomonom? Kei ning nang nomonom rikip kanape sik.>> ");
INSERT INTO pub_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Khan amaning kintepna katamtak le akinhakserra aleiti, <<Nangning ninini rikip kei ning kanapesik, karengram aherkhat inum!>> ");
INSERT INTO pub_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Khawa jarra numeisanu ning asuok a anudeng aleirakal, <<Angmi keining kini sik?>> Anuning aleimasang, <<John Baptist lu.>> ");
INSERT INTO pub_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Numeisanu kha kinnot a aheikirra rengpa deng ahongni, <<Kei ning hiwa mun takhin khan atunhin John Baptist lu kha kheeng chunga nanape sik komonom!>> ");
INSERT INTO pub_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Hiwa hin Rengpa amulung apong je, tak ama khomol ngai maikunga alei kintep jarra khan numeisanu nina kha nang leititor mak je. ");
INSERT INTO pub_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Khan rengpa ning akangaak raalmi inkhat khawa laitak khan John lu heichoi sik a chong aleipe a aleitir je. Akangaak pa kha mikhumna a ahong se-a, khan John lu kha ahong tenjei; ");
INSERT INTO pub_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Khan kheeng inkhat chunga alu kha aheichoi minlut a numeisanu deng aleipe, amanu ning khawakha anudeng aleipe jei. ");
INSERT INTO pub_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","John thiemroi ngaining khawa chongkha anjetli, anmani anhonga khan akulong kha anlei-a khan thaan na anwaphum jei. ");
INSERT INTO pub_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Tirle ngai kha anhong kirra khan Jesu le anlei kinmu, khan ansintho rikip le mi anlei minchu ngaikha amadeng anlei ril. ");
INSERT INTO pub_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Khawakhan mi akase le akahong mikatam tak anlei-om jarra Jesu le athiemroi ngai bu baksik apha num leimutor muk. Khawa jarra Jesu ning anmanideng aleiti, <<Eini nibinga ni-om thei nasik munna se inlang pong hongminchum rangri,>> ");
INSERT INTO pub_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Khawa jarra mun daina inkhat a anmani bei rukuong anchuong a anleise je. ");
INSERT INTO pub_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Achang rawang anmani anse kha mi katamtak ning anmu a khan anmani an e tikha anleijet; khawa jarra khopui rikip a mi anhong suok a khan antaan a Jesu le athiemroi ngai makma amun kha anleitung masa jei. ");
INSERT INTO pub_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Jesu ning rukuong ria aheisuok pha, mipui katamtak ngaikha aleimu, khan anmani sik a amulung kha minrengna asip je, ajarchu anmani ngaikha keelmong kakhal kinchal lei keelmong anlei ang je. Khawa jarra amaning chong katamtak aminchu aphut je. ");
INSERT INTO pub_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Khan kholei aheitung phakhan, athiemroi ngai anhonga amadeng anleiti, <<Tunchu apha hi ommak je, khan amun hi mi daina mun e. ");
INSERT INTO pub_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Mipui ngai hi minse inlang, anmani ning anaina khosung a-imakli ruhonna se inlang anbak nasik kinrocho rusu.>> ");
INSERT INTO pub_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Jesu ning aleimasang, <<Nangni ning anmanideng angmikhat baknasik peru.>> Anmani ning anleirakal, <<Keinining kinseli sumsan reini ning waipol kinrachopeli anmani kinminbak sik hi nangning numunom mi?>> ");
INSERT INTO pub_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Khawa jarra Jesu ning anmanideng aleirakal, <<Waipol angjet mo ninnei e? Se inlang hong en ru.>> Anmani ning anhong entok a, <<Waipol ranga khanchu nga inni,>> tia anlei minjet. ");
INSERT INTO pub_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Khan Jesu ning athiemroi ngaideng mipui ngai kha arup-rup a khoithen nasik le aka-em sachik chunga min-ong nasik aleiminjet. ");
INSERT INTO pub_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Khawa jarra mipui ngaikha reikhat rup khan somranga rup mintaang a ankin-ong je. ");
INSERT INTO pub_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Khan Jesu ning waipol ranga le nga inni kha alei a, marwan teng a-inna, khan Pathien aminpak. Waipol kha aher akhoi a khan mingai deng semnasik athiemroi ngaideng ape je. Amaning nga inni khanum anmani rikip deng asem pe je. ");
INSERT INTO pub_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Mi rikip ning anbak a khan anlei khoprip. ");
INSERT INTO pub_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Khawa soa athiemroi ngaining mingai bak akinlek waipol le nga kha taidon somle inni akisip mer an rut. ");
INSERT INTO pub_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Khawaning Awai minkhop pasal seng ngaikha lising ranga an e. ");
INSERT INTO pub_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Amaning mipui ngai minse sik atilai, kinranga Jesu ning athiemroi ngaikha rukuong a aminlut a tuitham ralkhat, Bethsaida khopui ama modondet a aleiminse. ");
INSERT INTO pub_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Jesu ning mingai akinthen pui soli, amaning chingmuolla Pathien nina aleise. ");
INSERT INTO pub_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Kholeiteng ahong tunga, Jesu tuitham panga abinga alei omlai khan rukuong khachu tuitham lai a aleiom. ");
INSERT INTO pub_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Amaning athiemroi ngai pongna kha aleimu, ajarchu phaiwo karang karat kha anlei kintongpui; kha-ang khan jingteng pung inthum le pung kuruk karra Jesu ning tui chunga anmanideng aheiwa a amaning anmanikha aheikhel deng karkhan, ");
INSERT INTO pub_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Amaning tui chunga ahonglon kha anmukar khan, <<Hiwa hichu raikho e!>> antia anleikheek. ");
INSERT INTO pub_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Anmani ning anleimu karkhan anmani rikip anleikinlai. Khawa laitak khan Jesu ning anmanideng aleiti, <<Kin-ngam na nei ru! Chimuru, Kei ki e!>> ");
INSERT INTO pub_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Khan amaning anmani rukuong sunga aleilut, khan phaiwo kha aleibang jei. Khan athiemroi ngaining anleingak rangra, ");
INSERT INTO pub_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","ajarchu anmani ning mipui lising ranga awaikha ajar leijet muk; anmulung ning khawa kha leisur tormuk. ");
INSERT INTO pub_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Anmani ning tuitham anleirakaan a Gennesaret ramteng anheiwa, khanna khan rukuong kha tuitham panga anleikhit. ");
INSERT INTO pub_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Anmani ning rukuong anleida solimli, mi ngaining Jesu kha anleijet kalen. ");
INSERT INTO pub_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Khan khawa ram mipui ngaining anleijet karkhan khawa munteng anheitaanna anheiwa; khan khonna a-e inum ama aom ti anjet inchu, akana ngai amadeng anheiroi a apher chunga anleiminjal. ");
INSERT INTO pub_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Jesu sena mun rikip, kho, khopui, ruhon kutung achanga, mingai ning akana ngaikha keithel munna anheiroi a apon morbei inum mintok nasik anleini. Khan khawa pon mor aleikotok rikip ngaikha anleidam. ");
INSERT INTO pub_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Jerusalem ria akahong Pharisees le Dan Oja alek Jesu kolla anhong kintup. ");
INSERT INTO pub_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Ama thiemroi alek ning ankut soplei a bu anleibak kha anmani ning anleimu, hiwahi anmani senadan dungjui a akinthengmak e, tichu anmani ning ankut kha Pharisees ngaining mipuideng anminchu anga leithomuk. ");
INSERT INTO pub_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(Ajarchu Pharisees le Jehudi rikip ning pi le pu ngai leiminchu senadan anleijui: ankut kha akatha ansopmak laiseng anmani ning leibak muk; ");
INSERT INTO pub_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","khanchu keithel ria anheichoi neinak ngaikha amasa ansop mintheng mak laiseng leibak muk. Khale kinroi a anmani ning alak senadan akatam anleijui, tichu hai, bel, sumbel khan phenchung ngaihi anlei sop mintheng.) ");
INSERT INTO pub_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Khawa jarra Pharisees ngai le Dan Oja ngai ning Jesu deng anleirakal, <<Angsik jarrami nang thiemroi ngai ning eini pi le pu khanga anleida minchuna anleijui mak, takkha khawa nek a kut achok pumma anleibak?>> ");
INSERT INTO pub_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Jesu ning anmanideng aleimasang, <<Isaiah chongsaan kha kho-ongtuk akidikmi nangni jarra! Nangni akatha kinlem nin e, tia hi-anghin aleimije: <Hiwa mingai hining anmur bei ning anakaja, Pathien ning ati, Tak anmulung chu kei ria akalaak a an-om. ");
INSERT INTO pub_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Kei anukumuk hinum anmani sik anemna ommak, Ajarchu anmani ning miring senadan anminchu kha Pathien Dan anga anmani ning anminchu!> ");
INSERT INTO pub_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","<<Nangni ning Pathien chongpe kha ninda-a khan miring ngai minchuna kha ninjui.>> ");
INSERT INTO pub_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Khan Jesu ning atinok, <<Ninbing a minchuna kha minsethei nasik ninsing theina khaning Pathien Dan kha kinlep nasik lampui nin-neije. ");
INSERT INTO pub_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Ajarchu Moses chongpe nakhan, <Napa le nanu nakaja sik,> khan, <Napa le nanu akathamak a nirilset inchu, nangkha thina apesik e.> ");
INSERT INTO pub_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Takkha nang minchunna khachu mi inkhat ning ang-mikhat apa a-imakli anu santheina anei inum, tak nang ning niti, <Hiwa hi Corban> tinachu, Pathien ta e, ");
INSERT INTO pub_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Amaning anpa a-imakli annu sansik ria minsan mukchujei. ");
INSERT INTO pub_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Hi-ang hin minchuna kha milak ngaideng ninmintunga Pathien chongkha ninten jei. Khana hi-ang kupo neinak alalak akatam nangni ning nintho.>> ");
INSERT INTO pub_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Khan Jesu ning mipui ngaikha ama kolla akoinok a khan anmanideng aleiti, <<Nangni rikip kachongril hi rangairu, khan jet ru. ");
INSERT INTO pub_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Tol ria miring sunga alut khaning mi minchokmak. Miring sunga ria ahongkusuok khaning mi aminchok.>> ");
INSERT INTO pub_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Amaning mipui ngaikha aleimathaanli khan inn inkhat a aleilut, ama thiemroi ngaining achongril kha minchen nasik anleirakal. ");
INSERT INTO pub_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Jesu ning anmanideng aleiril, <<Nangni milak ngainek a jetna neidet muk chu. Jetlei mo nin e? Tol ria miring sunga alut khaning amakha amintheng edet mak, ");
INSERT INTO pub_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","ajarchu khawa kha amulung sunga lutmak tak awon sunga akulut e, khawa so-a ataksa ria tolla ahongsuok e.>> (Jesu ning hiwa aril nahi, baksik rikip akintheng tia amalar.) ");
INSERT INTO pub_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Khana amaning arilnok a, <<Miring ria aheikusuok khan amakha aminchok e. ");
INSERT INTO pub_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Ajarchu mi mulung sung ria, akathamak mindonna kha aheisuok a khawa khaning amakha akathamak amintho, hurna, muruk, mithatna, ");
INSERT INTO pub_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","mi numei-arother setpuina, phamrai kase, khan akathamak rikip akatho; wartheng kiril, ra-ot, omchen kathamak, mikirilset, kin-or, khan akapang, ");
INSERT INTO pub_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Hiwa akathamak rikip ngai hi miring mulung sung ria aheisuok e khana khawa khaning ama amintheng mak e.>> ");
INSERT INTO pub_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Khan Jesu ning khawa mun kha amathaanli Tyre khopui kolla a ase jei. Amaning inn inkhat sunga aleilut khan khawa mun na a-om kha tute ning anjet sik leimonom mak, tak akinthup a akasot leiom tor mak je. ");
INSERT INTO pub_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Asanu sunga ratha kathamak kulut nupuinu khaning Jesu chungchanga ajetli kinranga ahonga akekunga aleikinbok. ");
INSERT INTO pub_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Khawa nupuinu kha Syria ram a Phoenicia ramsung a akinte Jat-lop mi inkhat e. Khawanu khaning asanu ria khori kha Jesu ning aholsut penasik aleiti. ");
INSERT INTO pub_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Takkha Jesu ning aleimasang, <<Amasatak a naipang ngai wai minkhop di ri. Naipang ngai bu kha kusut a ui deng pesik chu akidik imak.>> ");
INSERT INTO pub_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Khawanu ning aleimasang, <<Oja, ui ngainum naipang ngai bakbang dokhang thoi-a akata ngai kha anbak e!>> ");
INSERT INTO pub_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Khawa jarra Jesu ning khawanu deng aleiti, <<Kha ang nana heimasang jarra, ni inteng kir toro, nasanu ria khori asuok kha nawamu sik jei!>> ");
INSERT INTO pub_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Khawanu kha inteng akirra asanu phenchunga ajal kha awamu; khori kha asanu ria adiktabak aleisuok jei. ");
INSERT INTO pub_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Khan Jesu ning Tyre ramsung kha aleimathaan a Sidon arakaan a, Decapolis (tinachu Khopui som) ramsunga aleise a khan Galilee tuitham teng aheiwa. ");
INSERT INTO pub_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Miring alek ning akuor kiset, khan akatha akachong theimak mi inkhat anheiroi a, Jesu ning achunga akut adape nasik anlei ni. ");
INSERT INTO pub_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Khawa jarra Jesu ning amakha mipui ngai ria abinga akoisuok a, akutchalla amichil thonna akuor sunga aleithun li, khan amalei kha aleikotok pe. ");
INSERT INTO pub_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Khawa soa Jesu ning marwan chungteng a-enna, kinthuktak aphuk asanna, pasalpa denga aleiti, <<Ephphatha,>> tinachu <<Kinlong taro!>> ");
INSERT INTO pub_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Khawa pha takkhan pasalpa akuor ajet je, amalei asur kha omleia chong arilsuok torjei. ");
INSERT INTO pub_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Khan Jesu ning atu inkhat deng anril mak nasik mipuideng chong ape jei; tak amaning chong ape kha akikhella rilmuru atikha akakhella anlei ril jei. ");
INSERT INTO pub_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Khana akajet rikip ning anleingak jei. <<Ang rikip hi kho-ongtuk a akatha atho mije!>> anti. <<Kuor kiset naknum aminjet, khan akachong theimak aminchong thei!>> ");
INSERT INTO pub_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Sot lei-a mipui alop katamtak anhei kintup. Anmani ning baksik ite anleineimak lai, Jesu ning athiemroi ngaikha akoichunna aleiti, ");
INSERT INTO pub_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","<<Hiwa mingai sik a kei kumulung apong, ajarchu anmani ngaihi kei le nithum kinhong ombung jarra, atunchu baksik ite neimuk jei. ");
INSERT INTO pub_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Keining anmani bu minbak lei-a inteng kitir inchu, ansena lampui a ankinwai sik, ajarchu anmani alekchu ram kalaak ria anhong e.>> ");
INSERT INTO pub_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ama thiemroi ngaining amadeng aleirakal, <<Mi hiwajet wonminkhop nasik bu hi nerdiram hin atuning mo amutor sik e?>> ");
INSERT INTO pub_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Jesu ning aleirakal, <<Waipol angjet mo ninnei?>> <<Waipol sari,>> tia anmanining anleimasang. ");
INSERT INTO pub_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Amaning mipui ngaikha leithoi-a kin-ongnasik chong aleipe. Khan amaning waipol sari kha alei a, Pathien minpakna anei, aherkhat akhoi a mipui ngaideng semnasik ama thiemroi ngai apejei; khan ama thiemroi ngaining kha-angkhan semna annei. ");
INSERT INTO pub_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Anmani ning nga akisin aleknum anlei nei. Jesu ning hiwa sik num Pathien minpak na anei-a khan khawa nga khanum thiemroi ngaideng mipui semnasik aleiti. ");
INSERT INTO pub_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","9","Mi rikip ning akakhop a anleibak, mi lising-minli kopo an e. Khan thiemroi ngaining anbak bang akinlek awer-awai taidon sari kisip anlei rut. Jesu ning mipui ngaikha aleiminse jei. ");
INSERT INTO pub_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Khan kinrang a thiemroi ngai le rukuong anchong a Dalmanutha ramteng anleise. ");
INSERT INTO pub_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Pharisee alek ning Jesu deng anheiwa a amale anleikinkher. Anmani ning anchang kam a min-ok sik anleimonom, khawa jarra Pathien ning minthana nanei tikha sinkinlak a naminmuro tia anleini. ");
INSERT INTO pub_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Takkha Jesu ning kinthuktak aphuk akasaanna aleiti, <<Ang jarra mi tunlai khang mingai ning sinkinlak sik anarakal? Kei ning nangnideng kidik a kiniti, kha imak! Hiwa mingaideng khawa angkopo mu minchenna kha kinpe noning!>> ");
INSERT INTO pub_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Amaning anmani ngaikha aleimathaanli, rukuong achuong nok a, khan tuitham ralkhat teng rakaan nasik anleitho jei. ");
INSERT INTO pub_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Thiemroi ngaining ankhop nasik waipol heichoi sik kha anlei mingil je, rukuong sunga anmani waipol inkhat bei anleinei. ");
INSERT INTO pub_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","<<Kinsingthei ru,>> Jesu ning anmanideng aleitipe, <<khan nangni ning Pharisees ngaile Herod Chol chunga kinsingthei inlang kinrin ru.>> ");
INSERT INTO pub_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Anmani seng kinbekna anleinei a anleiti, <<Eini ning waipol ninei mak jarra amaning hiwahi ati e.>> ");
INSERT INTO pub_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Jesu ning anmani ngai ankinbek kha aleijet, khawa jarra amaning anmanideng aleirakal, <<Waipol a-om mak jarra nangni ning angsik mo ninkinbek e? Tun kutung lumu lajetlei mo nin e? Ninmulung kho-ongtuk mo alanger e? ");
INSERT INTO pub_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Nangni mit ninnei, mu lei mo nin e? Kuor ninnei, rangailei mo nin e? Nangni ngaidon lei mo nin e ");
INSERT INTO pub_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","mi lising-ranga sik keining waipol ranga kakhoi kha? Akinlek awer-awai taidon kho-ongjet mo ninrut?>> Anmani ning anleimasang, <<Somle-inni,>> anti. ");
INSERT INTO pub_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","<<Khan keining mi lising-minli sik waipol sari kakhoi karra khan, akinlek awer-awai taidon kho-ongjet mo akisip ninrut?>> <<Sari,>> tia anmani ning anleimasang. ");
INSERT INTO pub_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","<<Khan tun kutung nangni ning lajet lei mo nin e?>> tia Jesu ning aleirakal. ");
INSERT INTO pub_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Anmani ning Bethsaida teng anheiwa phakhan, mi alekning Jesu deng amitkacho mi inkhat an heiroi-a amadeng nakatok pero tia anleini. ");
INSERT INTO pub_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Jesu ning mitkachopa kha akut ning akeiroi a khosung ri aleisuokpui. Amit kha amichil thon pe soa, Jesu ning ama chunga akut ada a aleirakal, <<Angmikhat numu mi?>> ");
INSERT INTO pub_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Mipa khaning chungteng ahei enna aleiti, <<O, Keining mi ngai kumutor jei, tak anmani kha thingkung kulon anga anpo.>> ");
INSERT INTO pub_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Jesu ning mipa mit a khan akut aleida nok a. Khawapha khanchu mipa kha amit aminsai kang a alei en, ama mit aleimunok a, angrikip akinthenga alei mutor jei. ");
INSERT INTO pub_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Jesu ning khawa soa mipa deng ati, <<Hiwa khosung hin kirnok rang maro.>> ");
INSERT INTO pub_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Khan Jesu le ama thiemroi ngai Caesarea Philippi anti kho modonna anleise. Lampui ansena amaning anmanideng aleirakal, <<Nitiru Keideng, mi ngaining Keihi atumo ki-e aniti?>> ");
INSERT INTO pub_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Anmani ning anleimasang; <<Mi alek ning nanghi John Baptist aniti, alek ning Elijah ni-e aniti, alek ning Pathien chongkachoi ngai karra inkhat ni-e aniti.>> ");
INSERT INTO pub_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Amaning anmanideng aleirakal, <<Nangni ningle kei hi atumo ki-e ninti e?>> Peter ning aleimasang, <<Nang Messiah ni-e.>> ");
INSERT INTO pub_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Khan Jesu ning anmanideng chong ape, <<Kei chungchang a atudeng num rilmuru.>> ");
INSERT INTO pub_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Khan Jesu ning athiemroi ngaideng minchuna aphut: <<Miring Sapa kha akapong tak a a-om sik e khan Upa ngaining, thiempu chungnung, khan Dan Oja ngai ningnum nom nonung. Khana amakha anthat sik, tak nithum soli ama aring nok sik e.>> ");
INSERT INTO pub_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Amaning hiwa hi kintheng tak a anmanideng aleirilpe. Khawa jarra Peter ning ama munlopteng aroi-a alei ren minphut je. ");
INSERT INTO pub_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Tak Jesu ning akinhei a, ama thiemroi ngaikha alei en, khan Peter kha alei ren khan aleiti. <<Komodon ria suokro, Seitan, Nang mindon kha Pathien ria imak tak miring senadan e!>> ");
INSERT INTO pub_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Khan Jesu ning mipui le ama thiemroi ngai kha amadonna akoi. Amaning anmanideng aleirilpe, <<Atu-tu inum mi inkhat ning kunuk jui kate ati inchu, ama abinga akindon mak sik e, a cross akadomma, khan kei anajui sik e. ");
INSERT INTO pub_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Ajarchu atu-tu inum abinga ringkho akinhuk nom ning akinmang sik; tak atu-tu inum kei sik le chong kintheng sik a aringkho akapesuok kha akinhuk sik e. ");
INSERT INTO pub_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Simleichung pumpui ata amin e inum, tak aringkho akinmang inchu amasik a anemna angmo a-om? Anemna om mak! ");
INSERT INTO pub_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Mi inkhat ning aringkho kha angle mo akinthul thei aom mi. ");
INSERT INTO pub_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Mi inkhat ning keijarra, kei minchunna jarra, em le hur apha akathamak sunga hin kei minchuna chungchang a akinjak inchu, Miring Sapa le Apa lurna sunga marwan tirle kintheng ngaile anhongning khan amaning num amachunga ankinjak sik e.>> ");
INSERT INTO pub_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Khan Jesu ning anmanideng aleiti, <<Keining akidiktak nirilpe kate, Pathien Rengram kha ranak le kinroi a akahong anmani ning anmumak laiseng khawakhan alek akithimaksik an-om.>> ");
INSERT INTO pub_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Niruk soa Jesu ning Peter, James khan John, anmani ngaikha ching kinsang chung a aleiroi, khawa munna anmani bei anleiom. Anmani maikunga Jesu maiso kha aleikinthul, ");
INSERT INTO pub_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","khan ama ponder ngaikha ahongcheklak, simleichunga atu inkhatning asop minchektor maksik nek a aleichek. ");
INSERT INTO pub_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Khan athiemroi inthum ngaining Moses le Elijah ning Jesu le ankinbek kha anleimu. ");
INSERT INTO pub_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Peter aheichong a Jesu deng aleiti, <<Oja, angtuk akathami keini ning hiwahin kin-omhi! Keini ning hiwa munhin pon-inn inthum kinbol sik, nang sik inkhat, Moses sik inkhat, khan Elijah sik inkhat.>> ");
INSERT INTO pub_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Ama le alak ngaikhan anchihei a amaning angmo atisik e leijet mak. ");
INSERT INTO pub_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Khan Sumphai inkhat ahongsuok a adaililip ning aleimukhu, khan Sumphai ria rasa inkhat ahonga, <<Hiwahi kasapa mirit tak e, ama achong rangai ru!>> ");
INSERT INTO pub_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Anmani ning kinrangtak ankol a anlei en tak atute leimu muk; Jesu bei kha ankarra aleiom. ");
INSERT INTO pub_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Anmani Ching ria anhei chum lai, Jesu ning anmanideng chong aleipe, <<Miring Sapa kha thina ria aring mak laiseng, ninmu ngaikha atu dengnum rilsuok muru.>> ");
INSERT INTO pub_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Anmani ning chongpe ngaikha anjui, tak anmani karra bei chongkha kinbekna anleinei, <<Thina ria ringna, atihi angmo atina e?>> ");
INSERT INTO pub_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Khana anmani ning Jesu deng anleirakal, <<Moses Dan Oja ngaining Elijah masatak ahong sik anti hi angsik jarra mi?>> ");
INSERT INTO pub_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Amaning aleimasang khachu, <<Elijah kha e angrikip kimintuk akahong masa sik e. Kha inchu angsik jarra mi Pathien chong kintheng ning Miring Sapa kha apong angjet adeisik, khan mi ngaining nompenonung atihi angsik jarra mi? ");
INSERT INTO pub_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Takkha Kei ning nangni deng kiniti, Elijah chu aleihong sojei, khan chong kintheng ning ama jarra aleiti anga, mi ngaining ama chunga anthonom kha aleithoso jei.>> ");
INSERT INTO pub_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Anmani ning thiemroi alak ngai deng anhong kar, mipui katamtak ngaining akihilla, Moses Dan Oja alek le anmanile ankinkher pui kha anleimu. ");
INSERT INTO pub_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Mipui ngaining Jesu anleimu pha, anmani ning anleingak, khan amadeng kinranga anse a anleidon. ");
INSERT INTO pub_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Jesu ning ama thiemroi ngaideng aleirakal, <<Ang jarra mi anmani le ninkin kherpui?>> ");
INSERT INTO pub_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Mipui ngai karra pasal inkhat ning aheimasang, <<Oja, keining kasapa nangdeng kaheiroi, ajarchu ratha kathamak asunga a-om khan achongnum suokmak. ");
INSERT INTO pub_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Ratha khaning ama asur katai a, leithoi a apur, abai a achilphon asuok, aha aleikarot, khan atak kha aleichangkhang: Khawa jarra keining nang thiemroi ngaideng ratha kha noholsuok penasik kaleiti, takkha anmani ning leiholsuok tor muk.>> ");
INSERT INTO pub_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Jesu ning anmanideng aleiti, <<Angtuk a taksenna kaneimak nangni ngai! Angtuk kosot kei ning nangni le kalaom bung sik mi? Angtuk kosot kei ning nangni kha kanaladei pui sik mi? Naipangpa kha keideng heiroi ru!>> ");
INSERT INTO pub_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Anmani ning amakha Jesu deng anheiroi. Ratha khaning Jesu aheimuli, naipangpa kha akeichanga ahong dengjuon, khan leithoi a ata a aleikinloi khan abai a achilphon aleisuok. ");
INSERT INTO pub_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","<<Angtuk kusot mijei hin atinahi?>> Jesu ning apa deng aleirakal. <<Naipang achang lai ria e tia,>> amaning aleimasang. ");
INSERT INTO pub_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","<<Apha angjet akathamak ratha ning amahi thatnasik a meisunga le tui sunga adenglut e jei. Nang ning nanatho petor inchu, niminreng inlang khan nasen ro!>> ");
INSERT INTO pub_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Jesu ning amadeng aleiti, <<Angsik mo niti e, nator inchu? Taksenna kanei amasik chu angrikip a ithei e.>> ");
INSERT INTO pub_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Apa ning kinranga ahei ong a, <<Kei taksenna kanei, tak pui tukmang. Akatam det kanei thei nasik nasen ro!>> ");
INSERT INTO pub_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Jesu ning mipui kha anmani omnateng anheinai amukar khan, amaning ratha kathamak deng khan chong aleipe. <<Kuorset le chong akasuokmak ratha,>> Jesu ning aleiti, <<Naipangpa ria nang hei suok inlang khan amadeng lutkhir nok moro tia kei ning chong kanape!>> ");
INSERT INTO pub_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Ratha khan akheek a, naipangpa kha mel kasetak akeichang er a ahong dengjuon na khan asuok jei. Naipangpa kha akithi anga, khan mirikip ning anleiti, <<Amahi athijei!>> ");
INSERT INTO pub_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Takkha Jesu ning naipangpa kha akut ama-o a aleikeiding, khan ama ahongngir jei. ");
INSERT INTO pub_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Khawa soa Jesu ning insung alut kar, ama thiemroi ngaining ruk a anleirakal, <<Angsik jarra mi keini ning ratha kha kinholsuok tor mak?>> ");
INSERT INTO pub_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Jesu ning aleimasang, <<Hiwa ngaihi Pathien nina bei ning aholsuok tor e, alak inkhatte ning tor mak.>> ");
INSERT INTO pub_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Jesu le ama thiemroi ngai ning khawa munkha anleimathaanna Galilee anrakaan a anleise. Jesu ning atudeng num ama sena leiminjet nommak, ");
INSERT INTO pub_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","ajarchu ama thiemroi ngaikha aleiminchu: <<Miring Sapa kha mikathat ngai kutchunga akinpe sik. Nithum soli ama ahongring nok sik.>> ");
INSERT INTO pub_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Tak anmani ning hiwa minchu nahi leijet tor muk, khan anmani ning amadeng akarakal sik anleichi. ");
INSERT INTO pub_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Anmani ning Capernaum a anheiwa a, khan insung anlut kar Jesu ning ama thiemroi ngaideng aleirakal, <<Nangni ning lampui ton-na ang jarrami nin kinkher?>> ");
INSERT INTO pub_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Takkha anmani ning leimasangmuk, ajarchu lampui a anhei kinkher na khachu anmani karra atumi akolok tak ti jarra e. ");
INSERT INTO pub_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Jesu ning akin-onga, athiemroi somle inni ngaikha aleikoi, khan anmanideng aleitipe, <<Atu achang inum amasa kachangnom khaning atorna le mi rikip sok abinga achang ngersik e.>> ");
INSERT INTO pub_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Khan amaning naipang inkhat aheiroi a khan anmani maikunga aleiminngir. Amaning akoko-a anmanideng aleiti, ");
INSERT INTO pub_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","<<Tu achang inum kei riminga hiwa naipang inkhat akaralang kha, kei anaralang e; khan tu inum kei anaralang mi khaning kei bei anaralang ilei a kei anahong kitirpa khanum aralang e.>> ");
INSERT INTO pub_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","John ning amadeng aleiti, <<Oja, mi inkhat ning khori ngai niriminga aholsuok keini ning kinmu, khan keini ning amakha kinleikhap, ajarchu amakha eini rup karra akinchal imak.>> ");
INSERT INTO pub_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Jesu ning anmanideng aleiti, <<Amakha khap nasik thomuru,>> ajarchu kei riminga sinkinlak kotho je mi ning khawa nukteng kinrangtak mi kha eini mi akathamak a nirilset noning. ");
INSERT INTO pub_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Ajarchu atu inum eini anikinhal puimak mi kha an e. ");
INSERT INTO pub_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Keining akidiktak a kiniril pe e, nangni keita ninchang jarra, tuidai hai inkhat bei anakape tu inum athoman kha aphang nger sik e. ");
INSERT INTO pub_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","<<Atu inum hiwa naipang kisin inkhat taksenna minmang nasik akatho mikha atu achang inum aringa chakri lung kolok inkhat khit makhai pe-a tui-ongpui sung matasik khawa khaning ama sik athadet. ");
INSERT INTO pub_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Khawa jarra nukut khaning nataksenna aminmang inchu, tanro! Nukut akikip a akithiphit maksik meikhur nulutsik nek chu kut kinchel lei-a kumsot ringna naphasik khaning athadet. ");
INSERT INTO pub_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Khan nike khaning nataksenna aminmang sik inchu, tuktan ro! Nike akikip a meikhur a nulutsik nek a nike kinchel lei-a kumsot ringna naphang sik khaning athadet. ");
INSERT INTO pub_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Khana nimit khaning nataksenna aminmang sik inchu, kelsuok ro! Mit akikip a meikhur a nulutsik nek chu mit inkhat bei le Pathien Rengram nulutsik khaning athadet. ");
INSERT INTO pub_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Khawakhan <anmani kabak rulung ngaikha thiphit muk, khan anmani anrona mei akakang khanum thiphit mak.> ");
INSERT INTO pub_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","<<Maicham neinak kha michi ning amintheng anga mi rikip num mei ning amintheng sik e. ");
INSERT INTO pub_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","<<Michi hi akatha e; Tak a-elna kha asep jei inchu, kho-ongmo ninmin el theinok sik e? <<Nangni sap ninchangna michi kha ninbinga kara nei ru, khan inkhat le inkhat kahoi kadai om ru.>> ");
INSERT INTO pub_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Khan Jesu ning amun kha aleimathaanli, Judea ramteng ase je, khan Jordan Tuidung arakaan je. Mipui ngai amadeng anhong kinchun nok je, amaning anga-ngai atho anga anmanideng aleiminchu. ");
INSERT INTO pub_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Pharisees alek amadeng anhonga khan anchangkhit a min ok nasik anlei tho. Amadeng anleirakal, <<Mi inkhat ning anumei akinthen pui sik hi eini Dan ning anom mi, niminjet ro?>> ");
INSERT INTO pub_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Jesu ning chong rakal le kinroi a aleimasang, <<Moses ning nangni kho-ong Dan mo anape?>> ");
INSERT INTO pub_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Anmani chong leimasang khachu, <<Pasal inkhat ning kinthen na jedet inkhat amije a anumei kha akinthen pui nasik Moses ning chong aleipe.>> ");
INSERT INTO pub_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Jesu ning anmanideng aleiti, <<Nangni hi minjetna ninkintet jarra hiwa Dan hi Moses ning aleimije e. ");
INSERT INTO pub_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Tak akinphut bi a, abol minphut phakhan, <Pathien ning pasal inkhat le numei inkhat abol,> Chongkintheng ning aleiril. ");
INSERT INTO pub_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","<Khawa jarra khan Pasal ning apa le anu ada a khan anumei le ankinchun sik e, ");
INSERT INTO pub_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","khan inni ngaikha inkhat anchang sik.> Khawa jarra anmani kha inni chang muk jei, tak inkhat bei anchang je. ");
INSERT INTO pub_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Khan Pathien ning aminchun je kha, miring tute ning khoithen muru su.>> ");
INSERT INTO pub_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Anmani ning insung anheilut karra, thiemroi ngaining Jesu deng khawa chong chungchang anleirakal. ");
INSERT INTO pub_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Jesu ning anmanideng aleirilpe, <<Pasal ning anumei akinthen pui-a khan numei alop a-ompui inchu anumei engset a akajong e. ");
INSERT INTO pub_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Khale akin anga, numei ning arother akinthen pui-a khan pasal alop a-ompui inchu arother engset a akajong e.>> ");
INSERT INTO pub_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Mi alek ning naipang ngaikha Jesu ning anchung a akut ada nasik anhei roi, tak thiemroi ngaining mi ngaikha anleiren. ");
INSERT INTO pub_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Jesu ning khawa amu karra, ama aranga athiemroi ngaideng aleiti, <<Naipang ngaikha kei komodonna hongrusu, anmanikha khap muru, ajarchu Pathien Rengram kha anmani kupo ang ta e. ");
INSERT INTO pub_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Keining akidiktak a kinirilpe e atu achang inum Pathien Rengram kha hiwa naipang inkhat kupo a aralang mak mikha khawa muna khan lut noning.>> ");
INSERT INTO pub_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Khan Jesu ning naipang ngai kha akako-a, anmani rikip chunga akut ada a, khan ralwantha aleipe. ");
INSERT INTO pub_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Jesu ning akase alei phut nok a, mi inkhat ning amadeng ahong taan a, amai kunga ahong kinkun a, khan amadeng aleirakal, <<Akatha Oja, kumsot ringna chan nasik keining ang-mo kotho sik e?>> ");
INSERT INTO pub_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Jesu ning amadeng aleirakal, <<Angsik mo keihi akatha nanakoi e? Pathien elei-a akatha atute om mak. ");
INSERT INTO pub_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Nang ning chongpena kha najet: <Mi that moro, jong moro, muruk moro, akidik mak ning mi maher moro; mi rilset moro; nanu napa chong juiro.> >> ");
INSERT INTO pub_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Mipa khaning aleiti, <<Oja, hiwa chongpena rikip ngai hichu kisin lai ria kahei jui ijei.>> ");
INSERT INTO pub_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Jesu ning ama minreng pum a a-en kang a, amadeng aleiti, <<Nang nupui tuk mak na inkhat bei a-om. Se ro khan nanei rikip kha wajor ro, khana sara akapong ngaideng sumsan wapero, khanna nang ning marwan na nei le hoina nanei sik; Khan hong inlang kunuk nujuiro.>> ");
INSERT INTO pub_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Mipa ning kha ajet karra, amaiso tai mak je, khan mulung kopong tak a alei se je, ajarchu mipa kha mikanei tak e. ");
INSERT INTO pub_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Jesu ning athiemroi ngai a-en kiwel a anmanideng aleiti, <<Mikanei ngai Pathien Rengram lut sik hi kho-ongtuk a akintet mi je!>> ");
INSERT INTO pub_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Thiemroi ngai kha khawa chong khaning anmulung alei katok je, tak Jesu ning ahei rilnok a, <<Naipang ngai, Pathien Rengram lut sik hi khongtuk a akintet mi je! ");
INSERT INTO pub_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Mikanei inkhat ning Pathien Rengram lut sik khanek a simphoi khur a Satingkui alut sik khaning abeidet.>> ");
INSERT INTO pub_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Chong kha anjet karra thiemroi ngai anleingak detje khan inkhat le inkhat anlei kin rakal je, <<Khan atu ning mi anuhuk tor sik?>> ");
INSERT INTO pub_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Jesu ning anmani ahei en-ngang a aleimasang, <<Hiwa hi miring sik a chu e tormak tak Pathien sik a chu aki e tormak om mak; Pathien sik a chu ang rikip a-ithei.>> ");
INSERT INTO pub_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Khan Peter ning ati, <<Enro, keinining ang rikip kinmathaanna nunuk kinjui e.>> ");
INSERT INTO pub_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Jesu ning anmanideng aleiti, <<Adik, khana kei ning hi kini rilpe e, kei sik a le chongkahoi sik jarra, atu inum a-inn, ulenai, anu-apa, anaite ngai khanna leipuk akamoso je mikha, ");
INSERT INTO pub_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","atun khang a hin akakhel det a apha sik e. Anmani ning reikhat kikhel inn, ulenai, nu le pa, salenai, khan leipuk anpha sik, khan pongna num amu sik; khan akahong sik khang a chu kumleiko ringna kha anchen sik e. ");
INSERT INTO pub_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Takkha atun ma kakei katamtak ning nuk akintong sik, khan nuk akintong katamtak ning ma ankei sik.>> ");
INSERT INTO pub_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Atun Jesu le ama thiemroi ngai Jerusalem lampui chungteng anleikal. Jesu ning athiemroi ngai nek a ma aleikei, khan anmani ning anleingak, khan anuk kujui alek ning chu mulung dongna le china anleinei. Woikhat nok Jesu ning athiemroi somle-inni ngaikha munlop tenga aroi je, khan achunga akosuok sik omchen aleiminjet. ");
INSERT INTO pub_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","<<Rangai ru,>> amaning anmanideng ati, <<Eini Jerusalem teng nise sik khawa munna Miring Sapa kha thiempu chungnung ngaile Dan oja ngai kut chunga akinpe sik. Anmani ning amakha thatnasik a anthosik khan Jat-lop ngai kut chunga anpe suok sik, ");
INSERT INTO pub_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","anmunui pui sik, anmichil thon sik, anrachak sik, khan anthat sik; tak nithumsoli aheiring nok sik e.>> ");
INSERT INTO pub_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Khan Zebedee naite ngai James le John Jesu deng anhonga. Anmani ning anleiti, <<Oja, keini sik angmikhat nanatho pesik kinmonom.>> ");
INSERT INTO pub_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","<<Khawa khachu angmi?>> Jesu ning anmanideng aleirakal. ");
INSERT INTO pub_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Anmani ning anleimasang, <<Narengram kulur nakhan nareng kin-ongna chunga nikin ong kar, keini inni inkhat nachangteng khan inkhat nawoiteng nini min-ong sik a kinmonom.>> ");
INSERT INTO pub_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Jesu ning anmanideng aleiti, <<Nangni ning ninini kha nangni ning jetmuk chu. Keining ki-in sik pongna hai kha nangni nin-intor sik mi? Kei baptized kotho anga nangni nintho tor sik mi?>> ");
INSERT INTO pub_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","<<Kintor sik,>> tia anleimasang. Jesu ning anmanideng aleiti, <<Nangni ning kei ki-in hai kha nin in sik khan kei baptized katho anga nintho sik e. ");
INSERT INTO pub_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Takkha kei kachangteng le kawoiteng kin-ong nasik kadangna khachu keining tormang. Hiwa mun hichu Pathien ning anompe mi ngaideng ape sik e.>> ");
INSERT INTO pub_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Alak thiemroi som ngaikha khawa chongkha anjet karra, James le John chunga anrang nom je. ");
INSERT INTO pub_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Khawa jarra Jesu ning ankholo tal amadeng akoi-a aleiti, <<Jat-lop waikaron kin-e akiti ngai khaning anmi ngai chunga ranak annei, khana lamkakei ngai num pui kutuk a ranak annei. ");
INSERT INTO pub_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Kha achang inum, nangni karra chu kha imak. Ninkarra inkhat ning akalok achang nom inchu, alak ngaiseng sok anchang sik e; ");
INSERT INTO pub_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","khan ninkarra inkhat ning ma akei nom inchu, mi rikip sok achang sik e. ");
INSERT INTO pub_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Ajarchu Miring Sapa kha ama sepa minthosik akahong imak; mikatamtak ngai sepa thosik le katansuok sik aringkho kape sik a akahong e.>> ");
INSERT INTO pub_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Khan anmani ning Jericho kutung anheiwa, khan Jesu le ama thiemroi ngaile mipuingaile kinroi a Jericho ria anhongsouk lai, Timaeus Sapa Bartimaeus mitkacho kutkodopa kha lampui kolla alei kin ong. ");
INSERT INTO pub_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Nazareth Jesu a-e ti ajet karkhan, ama aka-ong aphut je, <<Jesu! David Sapa! Kei niminreng ro!>> ");
INSERT INTO pub_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Mi katamtak ning anlei ren khan a-om chen nasik anleiti. Tak amaning rasa kusuokdet a alei ong, <<David Sapa, kei niminreng ro!>> aleiti. ");
INSERT INTO pub_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Jesu ning alei ngir a aleiti, <<Heikoi ru.>> Khawa jarra anmani ning mitkachopa kha anlei koi. <<Rokpui ro! Kinding ro, amaning nang anakoi hi.>> ");
INSERT INTO pub_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Amaning apon aheikalek a, ahei kinchomma, khan Jesu deng aheiwa. ");
INSERT INTO pub_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Jesu ning aleirakal. <<Angmo nangsik a kei ninimin thonom?>> <<Oja, Kei kimit kumunom nok,>> tia amit kachopa khaning aleimasang. ");
INSERT INTO pub_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Jesu ning amadeng aleiti, <<Setro,>> <<Nataksen khaning nang animindam e je.>> Khawa laitak khan amaning amit aleimu a khan lampui a Jesu nuk aleijui je. ");
INSERT INTO pub_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Anmani Jerusalem anheinai a, Bethphage le Bethany khopui modonna, Olive chingtang a anhong je. Jesu ning ama thiemroi inni ma aleitir ");
INSERT INTO pub_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","hi-ang hin aleiti: <<Ninma kho-a se ru, son nintung ri Salungdai atute ning anluchong mak inkhat ankhit ninmu sik. Khawa kha heisut inlang hin heikei ru. ");
INSERT INTO pub_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Khan atumi inkhat ning, <Ang sik mi kha nintho e?> anahei ti inchu, Akupu ning a aneiman nomna aom, khan aheithak nok kalen sik tiru.>> ");
INSERT INTO pub_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Khana anmani ning anse-a lamsir-a Salungdai inkhat innkol anleikhit kha anleimu, Anmani ning ansut lai, ");
INSERT INTO pub_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","khawa khan akingir alek ngaining anmanideng anleirakal, <<Angsik mo Salungdai ninsut e?>> ");
INSERT INTO pub_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Anmani ning anleimasang Jesu ning aleiminjet na ang a, khan alei kingir ngai khaning anlei minchoi je. ");
INSERT INTO pub_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Anmanining salungdai kha Jesu deng anhei roi-a, achunga anpon ngai salungdai chunga andap a, khan Jesu ning salungdai chunga aleichuong. ");
INSERT INTO pub_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Mi katamtak ngaining lampui a anpon anpha a, alek ngaining lei kolla thingbaak anwatuk a khan lampui-a anleipha pe. ");
INSERT INTO pub_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Khan amadonna akase le anuk kujui mingai khaning an-ong anleiphut, <<Pathien minpak ru! Puma riming a akahong amakha amachal atha! ");
INSERT INTO pub_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Akahong sik nipa Reng David rengram kha Pathien ning ralwantha pe rase. Pathien minpak ru!>> ");
INSERT INTO pub_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Jesu Jerusalem aheilut a, Bek-inn sunga alut a, khan amaning ang rikip a-en. Tak kholei ahongtung je jarra athiemroi somle-inni ngai le Bethany teng anleisuok je. ");
INSERT INTO pub_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Ajing kini-a, anmani ning Bethany ria anhong kir nok a, Jesu awon aleicham je. ");
INSERT INTO pub_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Akalaktak ria theichang kung abo kinbur inkhat aleimu, akara ngaikha a-om sik mi tia aka-en alei se. Tak amun atung karra, abo bei awamu je, ajarchu theichang ngai kinra pha lei imak. ");
INSERT INTO pub_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Jesu ning theichang kung deng khan aleiti, <<Nakara atute ning bak nok rang muru su!>> Khan ama thiemroi ngaining achongril kha anlei jet. ");
INSERT INTO pub_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Anmani Jerusalem anheitung karra, Jesu Bek-inna aleise, Bek-inna neinak akajor le akaracho ngaiseng kha akaholsuok aleiphut jei. Amaning sumsan kuthul ngai le pharphili kajor ngai ankin-ongna ngai kha amalet pe je, ");
INSERT INTO pub_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","khan Bek-inn sumpuk kutung khan neinak kuchoi atute inkhat num leiminlut mak je. ");
INSERT INTO pub_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Jesu ning khawa so-a mingai deng aminchu je: <<Khachu hiwa anghin akinje khachu Pathien ning aleiti, <Kei bek-inn hi jat rikip ngai nina inn akinti sik e.> Tak nangni ning muruk kinthupna ninminchang je!>> ");
INSERT INTO pub_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Thiempu kolok ngai le Dan oja ngaining khawakha anjet je, khawa jarra ama that nasik a lampui aka-entok anphut jei. Anmani ning amakha anchi, ajarchu mipui ngai ning ama minchuna kha kinlak anleisak. ");
INSERT INTO pub_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Kholei aheitung a, Jesu le ama thiemroi ngai khopui kha anleimathaan jei. ");
INSERT INTO pub_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Jingteng ma, anmani lampui a anse lai, theichang kung kha anleimu. Khawakha arujung kutung a aleichar je. ");
INSERT INTO pub_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Peter ning omchen akosuok kha amindon na Jesu deng aleiti, <<Oja, Enro, nahakser theichang kung kha achar je!>> ");
INSERT INTO pub_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Jesu ning anmanideng aleimasang, <<Pathien taksen na nei ru. ");
INSERT INTO pub_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Keining akidiktak kiniril pe e, atu-tu inum hiwa chingbung hi kinphuk inlang tui-ongpui lai-a tanasik chong ape a khan amulung kei-chi o na neilei-a, takkha aril na chung a asuok nger sik tia akataksen mi khadeng akintho sik e. ");
INSERT INTO pub_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Khawa jarra kini minjet e: nangni ning Pathien nina ninnei a angmikhat ninni karra, kinmu je tia taksen ru, khan ninni rikip ngaikha akinpe sik e. ");
INSERT INTO pub_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Khan ningir a Pathien deng nina ninnei karra, marwan na akaom Ninpa khaning nintho thel ngairikip ana rangai mindam nasik a, atumi inkhat chung a mulung hoimak na ninnei rikip kha rangai mindam ru.>> ");
INSERT INTO pub_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Anmani Jerusalem a woikhat anhong tung nok je. Khanna Jesu kha Bek-inn sunga aleilon lai, thiempu kolok, Dan oja ngai khan upa ngai amadenga anlei hong ");
INSERT INTO pub_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","khan amadeng aleirakal, <<Hiwa ngai thotor nasik a ang ranak mo nanei? Hiwa thotorna hi atu ningmo anape e?>> ");
INSERT INTO pub_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Jesu ning anmanideng aleimasang, <<Keining chong inkhatbei narakal kate, khan nangning khawa kha nana masang inchu, keining ang thotorna ngai ningmo hiwa ngai hi kathotor e ti kini minjet sik. ");
INSERT INTO pub_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","John ning baptized thotorna ranak anei kha khona ria mi, niti pe ru: Pathien ria a-imakli miring ria mi?>> ");
INSERT INTO pub_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Anmani inkhat le inkhat ankinkher phut je: <<Angmi niti sik? <Pathien ria e,> niti inle kha amaning, <Kha-inchu angsik mo John kha taksen lei nin e?> ati sik. ");
INSERT INTO pub_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Takkha miring ria niti inum>> (Anmani ning mipui ngai kha anlei chi, ajarchu mi rikip ning John kha chongkachoi pa e tia anlei.) ");
INSERT INTO pub_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Khawa jarra anmani ning Jesu deng aleimasang khachu, <<Keini jet mung.>> Jesu ning anmanideng aleiti, <<Kha inchu, kisintho ngai hi ang thotorna ningmo katho e nangnideng niminjet noning.>> ");
INSERT INTO pub_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Khan Jesu ning anmanideng chongtekak ngai aleirilpe: <<Pha inkhat a theiburbil kiling mi inkhat aleiom, theiburbil sarapal aleikhar, theibur musorna sik khur inkhat aleichei, khanna berte inkhat aleibol, Khan atheiburbil kha akotho ngaideng asaljei khana a-inn amusoli khomol asejei. ");
INSERT INTO pub_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Theibur khekpha kha ahongtung pha, amaning asok inkhat theiburbil kasaal ngaideng asaal kalei sik aleitir. ");
INSERT INTO pub_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Theiburbil kasaal ngai khaning asuokpa kha ansurra anleirachak, inkhatte palei a antir je. ");
INSERT INTO pub_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Khan theiburbil kupu khaning asok lop inkhat atir nok, theiburbil kasaal ngai khaning alu anlei rachak a kinjak anleipe. ");
INSERT INTO pub_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Akupu khaning suok lop inkhat atir nok, khan anmani ning amakha anlei that jei; khanna alak katam tak num kha-angkhan anlei tho jei, alekning anlei rachak, alekning an leithat jei. ");
INSERT INTO pub_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Tir sik-a inkhat bei akaom khachu asapa mirittak kha e, Atorna tak a asapa kha theiburbil kasaal ngai deng atir jei. Amaning aleiti, <Kasapa hichu anmani ning anlei kaja nger sik tia kikin ngam.> ");
INSERT INTO pub_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Takkha theiburbil kasaal ngai khaning inkhat le inkhat anlei kinbek, <Amahi theiburbil kupupa sapa e. Hongru that ri, khanna amaning phasik rikip hi einita achang sik jei!> anti ");
INSERT INTO pub_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Khawa jarra anmani ning sapa kha ansurra anthat je khanna akithi kha theiburbil ralteng andengjon jei. ");
INSERT INTO pub_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","<<Kha achang inchu theiburbil kupupa khaning angmo atho sik jei?>> tia Jesu ning aleirakal. <<Ama ahong sik khan theiburbil kasaal ngaikha athat sik je khanna theiburbil kha milop deng aminsaal nok sik jei. ");
INSERT INTO pub_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Akidik tak a hiwa chongkintheng hi nin leipa sik je?>> << <Inn kasak ngai ning thamakjei tia andengjon lungkha ankarra apui koron achang je. ");
INSERT INTO pub_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Hiwa hi Puma ning atho e; Eini mit mu-a kho-ongtuk a akinlak mi!> >> ");
INSERT INTO pub_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Jehudi lamkakei ngai khaning Jesu sur sik a anlei kin thok e, ajarchu amaning chongtekak aleitho ngai kha anmani chung nga aril e ti hi anleijet. Takkha anmani ning mipui ngaikha anleichi, khawa jarra amakha anlei mathaanli anse jei. ");
INSERT INTO pub_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Jesu deng chong anrakalli surna sik a, Pharisees alek le Herod mingai alek amadeng aleitir. ");
INSERT INTO pub_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Anmanining amadeng anhonga anleiti, <<Oja nangning mingai modonna inkhatte chilei-a akidik niril hi kinjet. Nangning atute mai enmak che, takkha mingai sik-a Pathien lungdo kha akidik a nalei minchu. Khanna Caesar denga ramsel pesik hi eini Dan akoi mi? Nipe sik mi? Nipe mak sik mi?>> ");
INSERT INTO pub_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Takkha Jesu ning anmani changkam kha ajet a aleimasang, <<Angsik mo kei niminkhit sik niti e? Roman sumsan inkhat kha heichoi ru, khan keining enkate.>> ");
INSERT INTO pub_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Anmanining sumsan inkhat anhei choi, khan amaning aleirakal, <<Tu milim le riming mo akinje e?>> <<Caesar>> tia anleimasang. ");
INSERT INTO pub_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Jesu ning aleiti, <<Caesar takha Caesar peru, khan Pathien takha Pathien deng peru.>> Khana anmani ning Jesu kha anleingak je. ");
INSERT INTO pub_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Khan Sadducee alekning, miring hi thi ria ring noning je akiti ngai, Jesu deng anhonga anleiti, ");
INSERT INTO pub_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","<<Oja, Moses ning hiwa dan hi keini sik-a aleimije: <Mi inkhat athi-a naite neilei-a anumei aleida inchu, anaipa inkhatning churmeinu kha aom pui nger sik, khawa jarra anmani inni annei naite ngai kha akithipa naite e tia anlei thei nasik e.> ");
INSERT INTO pub_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Pha inkhat a unai sari anlei om; upa tak khaning numei anei je khana naite neilei-a athi je. ");
INSERT INTO pub_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Khan inni changnapa khaning numei kha aom puinok je, ama khanum naite nei lei-a athi nok je. Khanna inthum changnapa annaipa khanum kha-ang tit a asuok nok je, ");
INSERT INTO pub_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","khana alak ngaiseng: unai sari khaning num numei nu kha an ompui rip a naite nei lei-a anthi rip je. Atorna tak a, numei nu khanum athi je. ");
INSERT INTO pub_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Atunchu, akithi rikip ringnok ning nikho khan khawanu kha atu numei mo achang sik e? Anmani sari ning numeinu kha an lei ompui rip.>> ");
INSERT INTO pub_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Jesu ning anmanideng aleimasang, <<Kho-ongtuk a nintho thel ije! Khana angsik jar mi ti hi ninjet mi? Hiwa hi nangni ning chongkintheng le Pathien ranak kha ninjet mak jarra e. ");
INSERT INTO pub_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Ajarchu akithi ngai kha anringnok pha, anmani ngai kha marwan tirle kupo anchang sik jei khan innei omno ning jei. ");
INSERT INTO pub_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Atunchu, akithi ngai anthei sik jarra: Moses jedet rubu a thingbur meikachoong chong akinje kha pangai lei mo nin e? Khawa khan hi-ang akinje tichu Pathien ning Moses deng, <Kei Abraham Pathien, Isaac Pathien, khanna Jacob Pathien ki-e,> ati. ");
INSERT INTO pub_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Amahi akiring ngai Pathien e, akithi ngai Pathien imak. Nangni ninthel rangra jei!>> ");
INSERT INTO pub_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Dan oja inkhat ahong a anmani ankinbek kha alei rangai. Jesu ning Sadducees ngai deng chong katha masang kha aleimu. Khawa jarra akolla ahonga chong aleirakal: <<Chongpena karra kho khamo akolok tak e?>> ");
INSERT INTO pub_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Jesu ning aleimasang, << <Israel ngai rangai ru! Puma eini Pathien bei kha e ni Puma. ");
INSERT INTO pub_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Puma ni Pathien kha numulung pumpui, naratha pumpui a, nimindonna pumpui, khanna naranak ratna pumpui ning minreng ro.> ");
INSERT INTO pub_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Khanna inni changna chongpena koloktak khachu: <Nang nabinga nikinreng anga nokho niweng minreng ro.> Hiwa inni ngai kikhella chongpena kolok alop om-mak.>> ");
INSERT INTO pub_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Dan oja khaning Jesu deng aleiril, <<Oja! Nangning akidik a niriljei, khachu Puma khabei e Pathien, ama ilei a alop Pathien ommak. ");
INSERT INTO pub_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Khan Pathien kha numulung pumpui, nimindonna pumpui khan naranak ratna pumpui a minrengro, khan nibing a nikinreng anga nokho niweng minrengro, Hiwa chongpe inni kujui hining Pathien deng ran le kinthoina kapenek a mei a natak pumpui aro minkang nek a atha det.>> ");
INSERT INTO pub_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Amaning kinsing thei tak a amasang kha Jesu ning amupha, amadeng aleiti, <<Nang Pathien Rengram ria akalak ommak che.>> Khanchu atute ning Jesu deng chong rakal tor muk jei. ");
INSERT INTO pub_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Jesu ning Bek-inn sunga aminchu lai, chong aleirakal, <<Dan oja ngaining Messiah kha David sonlepar kha e tia kho-ongmo anti thei? ");
INSERT INTO pub_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Ratha Kintheng ning David murtak a amin rilsuok: <Puma khaning kei Puma deng aleiti: Ninkin muda ngaikha nike thoi a kada mak kar seng kachang teng hin kin ongro> ");
INSERT INTO pub_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","David khet ning amakha <Puma> tia akoi; achang inchu kho-ongmo Messiah kha David sonlepar achang thei sik?>> Khana mipui ngaining Jesu chong kha rokpui a anlei rangai. ");
INSERT INTO pub_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Jesu ning anmani aminchu a anmanideng aleiril, <<Dan Oja ngai ri a kinsing thei ru, songkol kasei akinhak a akolon nom ngaikha keithella amin kajanom ");
INSERT INTO pub_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","khan synagogues le bak minchunna mun kahoitak khan akin ongnom. ");
INSERT INTO pub_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Anmani ning Churmei ngai ria nemna an-entok khan insung neinak ngai anlei-leipe, mi musik a Pathien nina kosot tak a anleinei. Anmani kha karakna akakhel anpha sik!>> ");
INSERT INTO pub_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Jesu kha sumsan dana mudonna akin ong lai mipui ngai sumsan minbuk na pelom kosuok anpe kha a-enlai mikanei katamtak ngai ning sumsan akatampui anlei mata; ");
INSERT INTO pub_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","khan sara churmeinu inkhat num ahong a ana inni sumsan inkhat dam awothun minlut. ");
INSERT INTO pub_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Jesu ning athiemroi ngai akoi mintup a anmanideng aleiril, <<keining akidik tak kinirilpe hiwa sara churmeinu ning sumsan minbukna akape ngai seng karra akatam akape kha e. ");
INSERT INTO pub_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Ajarchu alop ngai seng khaning akatam annei na ria ankhoi then li anpe e, takkha hiwa nu ning asara chang aneiseng, aringna sik a aminbuk rikip kha ape e.>> ");
INSERT INTO pub_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Jesu ning Bek-inn ria aheisuok pha, thiemroi inkhat ning amadeng aleiti, <<Enro, Oja! Lung ngaile innpui ngaihi kho-ongtuk a ennom kaom mi!>> ");
INSERT INTO pub_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Jesu ning aleimasang, <<Innpui kolok ansak ngaihi ninmu mi? Lung ngai hi inkhat nak num an omna ria leida noning; hi ngai rikip hi alachim sik.>> ");
INSERT INTO pub_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Bek-inn ralkhat teng Jesu kha Olive Chingtang chunga alei kin ong, Khawa pha Peter, James, John khan Andrew ruk-a amadeng anleihong. ");
INSERT INTO pub_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","<<Hiwa hi angtuk karra mo asuok sik e niminjet ro,>> anmanining anleiti, <<khana hi seng ahongsuok sik pha kha ahongtung jei ti hi jetna sik angmo ahongsuok sik nirilpero.>> ");
INSERT INTO pub_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Jesu ning anmanideng aleiti, <<Kinsing thei ru, khan atu khat ning nangni akalet teng ana roimak nasik tho ru. ");
INSERT INTO pub_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Mi katamtak ning, kei kiriminga anheiwa antisik, <Kei amakha ki-e!> khan mi katamtak ngaining akalet lampui a anroi sik. ");
INSERT INTO pub_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Raal kindei le, raal chong kinthang ninjet phakhan chimuru. Khawa kha ahongsuok nger sik e, takkha atorna li-imak. ");
INSERT INTO pub_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Ajarchu jat inkhat le inkhat anhong kinsol sik; khan Rengram inkhat le inkhat raal ankin dei sik. Amun rikip a ringnu akinnok sik, khan bak le in aboi sik. Kha ngai kha nai neisik teng naiha kuphu akana kinphutna pong anga a-e sik. ");
INSERT INTO pub_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","<<Nangni ninbing a nin kin singthei nger sik e. Nangni anasur sik khan chongtan na munna ana keiso sik. Synagogues a nangni anarachak sik; kei sik a waikaron ngaile rengngai maikunga ninlangir sik e, Chongkahoi anmanideng ninril jarra e. ");
INSERT INTO pub_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Tak atorna ahong tung makma chongkahoi hi mi rikip deng ninril nger sik e. ");
INSERT INTO pub_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Khana nangni anasur a khan chongtan na mun na anaroi sik, angmo kiril sik tia khawa pha khan ninmulung mindongmuru; apha kha ahong tung sung a chong akinpe ngai kha ril ru. Ajarchu nangni ninril sik chong kha nangni ria imak; ratha kintheng ria akahong suok sik e. ");
INSERT INTO pub_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Mingai ning ulenai tak kha that sik a anpesuok sik, khanna Pa ngaining num anaite ngai kha kha-ang khan anthosik. Sa le nai ngaining num Nu le Pa ngai chunga anranga that nasik anpesuok sik. ");
INSERT INTO pub_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Kei jarra mi rikip ning nangni anahal sik. Tak atu inum ahekna kutung angirtor inchu hukna achen sik e. ");
INSERT INTO pub_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","<<Kinrimna Chikaom tak kha, a-om makna sik mun a ahong ngirkha ninmu sik.>> Akapasuok khaning ang tina mi jet thei rase! <<Khawa phakhan Judea ram a kaom ngaikha Chingteng taan rang rusu. ");
INSERT INTO pub_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Inn chunga akaom mi khaning insunga aneinak kalei sik ahongchumli apha minmang marase. ");
INSERT INTO pub_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Khan leipuk a akaom mi khaning apon kalei sik a-inna hei kir-rang ma rase. ");
INSERT INTO pub_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Khawa phakhan nai koron ngai le naidong kanei sik a angtuk a chikaom sik mi! ");
INSERT INTO pub_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Hingai hi phelbi lai asuok mak nasik Pathien nina neiru! ");
INSERT INTO pub_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Ajarchu khawa kini ning a kinrimna ngaikha, Pathien ning Leithoichung abol phut lim ria kinphut atun kutunga miring ngai anjet kinrimna ngai, hiwa anghi ret suoknok no ningjei. ");
INSERT INTO pub_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Takkha Puma ning khawa kini ngaikha aminbong je; aminbong mak inchu, atute ringtor noning. Ama kadangsuok ngai sik jarra kini ngai kha amintom det e. ");
INSERT INTO pub_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","<<Khawa jarra tu achang inum mi inkhat ning, <Enru, Messiah kha hin a-om!> a-imakli, <Enru, son-na a-om!> antia achang inum taksen muru. ");
INSERT INTO pub_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Messiah akidikmak ngaile akidikmak pathien chongkachoi ngai anhong kinlarsik. Anmani ning sinkinlak le ngakna angjet anthosik khan a-ithei inchu Pathien akadangjei mi ngainum akalet teng roina sik antho sik e. ");
INSERT INTO pub_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Kinsing theitak a omru! Apha kha aheitung maklai angrikip kini minjet ijei. ");
INSERT INTO pub_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","<<Khawa pongnapha nikho ator inchu kini kha ajingsik, tha kha war noning je, ");
INSERT INTO pub_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","arsi ngaikha marwan ria anhong ta sik, khanna boirok a akaom ngai kha ahong kinnok sik. ");
INSERT INTO pub_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Khan Miring Sapa kha ahong kinlar sik, alurna thotorna le kinroi a Sumphai chunga ahong chum sik. ");
INSERT INTO pub_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Khan akadang so sa ngai akoi mintup nasik marwan tirle ngai leithoichung rikil minli amor inkhat teng ria aphut a inkhat teng kutung amaning atir sik je. ");
INSERT INTO pub_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","<<Theichang kung ria kinchuna neiru. Theichang abaak ngai ahong em a ajik ahong cher a khan abo ther ahongsuok inchu, kholum pha anai je ti hi nangni ning ninjet. ");
INSERT INTO pub_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Khawa le akin angrip a, hiwa omchen ngai hi ahongsuok ninmu je inchu, apha anai je, ahong nasik akinthok je. ");
INSERT INTO pub_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Akidik a keining nangni deng kinitipe e, miring akaring ngai anthiso maklai omchen rikip hi asuok sik e. ");
INSERT INTO pub_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Marwan le Leithoichung chu akin mang sik, takkha Kei kachong chu kinmang phit noning. ");
INSERT INTO pub_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","<<Khawa Kini le pha kha, marwan tirle ngai ning num, khan asapa ning num atute ning jetmuk, Apa bei ning ajet e. ");
INSERT INTO pub_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Kinsing thei tak a kinrin chak ru, ajarchu apha kha angtuk karra mo ahongtung sik nangni ning jet muk chu. ");
INSERT INTO pub_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Mi inkhat ning khomol sik a inn adadoi pha, asok ngai ansin thosik ape-a, inkhar kangakpa deng kinrinchak nasik chong ape ang kupo e. ");
INSERT INTO pub_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Khawa jarra kinrinchak ru, ajarchu inn kupupa kha kholei achanga, janchim achanga, jintengma a-imakli sun achanga angtuk karra mo ahong sik nangni ning jetmuk chu. ");
INSERT INTO pub_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Jet lei thei lei-a ama ahong tung inchu, najal naom kha numu marase. ");
INSERT INTO pub_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Khan nangdeng kiril hi mi rikip deng kiti e: Kinrin chak ru!>> ");
INSERT INTO pub_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Nini makma Rakan Reikahoi le cholphillei waipol, Thiempu kolok ngai le Dan oja ngai ning Jesu kha ruk a surna sik khan that nasik lampui anlei entok. ");
INSERT INTO pub_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Anmani ning anleiti, <<Hiwa reikahoi sunga hinchu thomiri, lakanchu mipui kinhangna ahong e thei.>> ");
INSERT INTO pub_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Bethany khopui-a chi kaomtak ri kaphar aleikoron Simon inna Jesu kha bu abak a alei omlai, numeisa inkhat lungwar ning anbol akok kisip akintheng nard kung ria ansom amankatam sarek anchoi a anheiwa. Khawanu ning sarek kok kha amalong a sarek rim kahoi kha jesu luchunga aleibun. ");
INSERT INTO pub_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Khawa mun na mi alekchu anmulung aleithei a inkhat le inkhat anlei kinbek a anleiril, <<Sarek rim kahoi aminmang hi anemna angmi? ");
INSERT INTO pub_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Hiwa Sarek hi sumsan reijathum kikhella nijor thei e khan sumsan kha sara khodeng kathei ngai pethei e!>> khana numeinu kha anlei rilset je. ");
INSERT INTO pub_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Tak Jesu ning aleiti, <<Khawanu kha abinga daru! Angsik mo ninkachok e? Numeinu hi ning akathatak kei sik a sin atho e. ");
INSERT INTO pub_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Sara ngai chu nangnile nin ompui chak sik, nangni ning nin monom pha rikip a nin sen thei e. Takkha kei chu nangni le pha rikip a ombung nomin. ");
INSERT INTO pub_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Khawanu ning ator seng kha atho e; Sarek rim kahoi kuchunga akanot hi kikinphum ning sik makma anakanot ijei. ");
INSERT INTO pub_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Tunchu, akidik tak a kini rilpe hi-e simleichung pumpui chongkahoi kinrilna munna, khawanu ning aleitho ngaikha ama mindonna le kinroi a akinril sik e je.>> ");
INSERT INTO pub_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Khan thiemroi somle inni ngai karra Judas Iscariot antipa khaning Jesu pesuok nasik thiempu kolok ngai deng alei se je. ");
INSERT INTO pub_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Anmani ning achong kha anjet pha anlei rokpui, sumsan pesik a kintepna annei je. Khawa jarra Judas khaning Jesu kha anmanideng pesuok thei nasik lampui alei-entok je. ");
INSERT INTO pub_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Chol phillei Waipol reihoi nikho amasatak ning, Rakan reikahoi bak nasik keelmong ngai that ning nikho khan, Jesu thiemroi ngaining anleirakal, <<Rakan rei bakbung nasik nangni jarra khon mo kinbol sik a nomonom?>> ");
INSERT INTO pub_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Khan Jesu ning ankarra miring inni aleitirra hi-ang aleiminjet: <<Nangni khopui a son seru, khanna tuibel kodom mi inkhat ninkin tongpui sik. Ama kunuk kha jui ru ");
INSERT INTO pub_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Ama lutna inn, kupupa deng khan tiru: <Oja ning ka thiemroi ngai le kei Rakan reikahoi kinbak nasik inn kha khon mi?> ");
INSERT INTO pub_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Khawa pha amaning inn chungden kolok tak, aminleng sa inkhat ani min musik, khanna khan ang rikip eini sik a ninmintuk sik e.>> ");
INSERT INTO pub_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Khawa munkha athiemroi ngai anlei mathaanli, khopui teng anlei se jei, khanna Jesu ning aminjet ang kopo-a angrikip anwamu je; khana Rakan reikahoi bakbung nasik a anmintuk je. ");
INSERT INTO pub_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Kholei ahong tung pha, Jesu ning thiemroi somle inni ngai le an hong jei. ");
INSERT INTO pub_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Anmani ning dokhang chunga anbak lai, Jesu ning aleiti, <<Akidik tak a kini rilpe e ninkarra kei le kinbakbung inkhat ning kei anape suok sik.>> ");
INSERT INTO pub_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Athiemroi ngai ning anmulung aleidong a, inkhat soli inkhat ning, <<Kei nini tina chu imak nu, a-e mi?>> antia amadeng anleirakal. ");
INSERT INTO pub_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Jesu ning aleimasang, <<Nangni somle inni karra inkhat, Kei le waipol kheeng sunga kinthun bungpa hi e. ");
INSERT INTO pub_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Chong kinthenga aleikinje ang a, Miring Sapa kha athi nger sik e; takkha miring sapa akapesuok sik mipa kha angtuk mo amachal kase-e! Ama sik a alei kinte mak ning atha det sik e!>> ");
INSERT INTO pub_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Anmani ning anbak lai, Jesu ning Waipol her kha alei a Pathien nina le minpakna anei a, aher akhoi a, khan a thiemroi ngai deng aleipe, <<Kinlei ru, hiwahi kataksa e,>> aleiti. ");
INSERT INTO pub_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Khan amaning hai kha alei a, Pathien minpakna anei a anmanideng aleipe; khana richu ankholo a anlei in. ");
INSERT INTO pub_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Jesu ning aleiti, <<Hiwa hi mi katamtak sik a akolong, Pathien le kinnomna jetnasik kithisen kha e. ");
INSERT INTO pub_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Akidik tak kiniril pe e, Pathien Rengram ma theiburju ther kha ki-in mak karseng hiwa theiburju hi inno ning jei.>> ");
INSERT INTO pub_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Khan anmani ning laa ansak a, Olive chingtang teng anleise jei. ");
INSERT INTO pub_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Jesu ning anmanideng aleiti, <<Nangni ninkholo a nintaan sik khanna kei nana mathaan sik je, ajarchu chong kintheng ning ati, <Pathien ning keelmong kakhal pa kha athat sik, khan keelmong ngaikha ankin chek chai sik jei.> ");
INSERT INTO pub_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Tak kei hi akiringa kathei nok li, Galilee a ninma a kalei se sik.>> ");
INSERT INTO pub_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Peter ning aleimasang, <<Alak ngai sengning analei mathaan inum keining chu nada phit noning!>> ");
INSERT INTO pub_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Jesu ning Peter deng aleiti, <<Keining nangdeng akidik tak kiniril pe e, atun jan tak hin arkhong ning woini akinram mak lai woithum rak kei hi jetmang niti sik.>> ");
INSERT INTO pub_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Peter ning rasa kanger det-a aleimasang, <<Nang le nithi bung sik achang inum, kha-ang chu tiphit noning!>> Khana thiemroi ankholo-a kha-anga anlei ti rip. ");
INSERT INTO pub_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Anmani ning Gethsemane anti munkhan anhong je, khan Jesu ning thiemroi ngai deng aleiti, <<Pathien nina kanei lai hiwa hin kin-ong ru.>> ");
INSERT INTO pub_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Amaning Peter, James le John aleiroi. Khana kinrimna le mulung pongna achunga ahong tung je, ");
INSERT INTO pub_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","khana amaning anmanideng aleiti, <<Kumulung hi adong hei-a thina sik kutung a ije. Hinnahin om inlang kinrinchak ru.>> ");
INSERT INTO pub_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Alek akalak det ase a, leithoi a akinbok-a, a ithei sik inchu khawa mulung pongna kha ama chunga asuok mak nasik a aleini. ");
INSERT INTO pub_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Amaning aleini, <<Apa, Kapa! Nang sik-a angrikip a-ithei rip. Hiwa mulung pongna hai hi kei ria nakhek pe ro. Khanum kei lungdo ilei a, nang nulungdo e rase.>> ");
INSERT INTO pub_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Khan ama ahong kirra thiemroi inthum ngai anleijal kha aleimu. Amaning Peter deng aleiti, <<Simon, nang najal mi je? Pung khatbei sik num akaher a om torlei mo ni-e?>> ");
INSERT INTO pub_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Khan amaning anmanideng aleiti, <<Kinrinchak ru, mathemna ninta makna sik Pathien nina neiru. Ratha ningchu amonom, tak taksa chu adol.>> ");
INSERT INTO pub_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Ama awasenok li Pathien nina, anga-ngai a aleineinok. ");
INSERT INTO pub_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Khan athiemroi ngaideng ahong kirnok a anleijal kha aleimunok; anmit lei malong tormuk. Khana anmani ning anmanideng angmo arilsik leijet mak. ");
INSERT INTO pub_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Woithum changna ahong kirnok a, amaning anmanideng aleiti, <<Nangni atun kutung ninlajal a pong ninla minchum mi? Ahun je! Apha kha ahong je! Enru, Miring Sapa kha setna kanei ngai kutchunga akinpe je. ");
INSERT INTO pub_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Thei ru, eini se rang ri. Enru, anakape suok sikpa kha hin-na a-om je!>> ");
INSERT INTO pub_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Jesu ning kha-ang chong arillai, thiemroi somle-inni ngai karra Judas kha ahongtung je. Ama le kinroi-a mipui ngai, Dan Oja ngai, upa ngai chemjamle luchei anchoi a thiempu kolok ngaining anhong tir je. ");
INSERT INTO pub_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Akape suokpa khaning mipui ngai kha anjet nasik inkit inkhat aleipe: <<Keining komojop sikpa kha ninmanom pa kha e. Sur ru khan khal inlang keiso ru.>> ");
INSERT INTO pub_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Judas ahei tunglimli, Jesu deng ase-a, <<Oja!>> atia awamojop. ");
INSERT INTO pub_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Khan anmani ning Jesu kha ansurra khan ankhit tit je. ");
INSERT INTO pub_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Tak amadonna akingir mi inkhat ning achemjam aheikalek a, Thiempu chungnung asokpa kuor atuk chet pe je. ");
INSERT INTO pub_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Khan Jesu ning anmanideng aleiti, <<Muruk malet kusur sik anga chemjam le luchei kinroi-a kei kusur sik ninhong mi? ");
INSERT INTO pub_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Aniso nangni le ni-ombunga Bek-inna kiniminchu jet, kei nalei sur muk chu. Tak Chongkintheng khachu pui alatung nger sik e.>> ");
INSERT INTO pub_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Khan thiemroi rikip ngaining anmathaanli antan del je. ");
INSERT INTO pub_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Pon kinnem bei kisil rother inkhat ning Jesu nuk aleijui. Anmani ning amakha sur sik a anleitho, ");
INSERT INTO pub_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","tak aponsil kha aleida li aroksai-a aleitaan. ");
INSERT INTO pub_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Khan anmani ning Jesu kha Thiempu Chungnung inna anroi je; khana khan thiempu kolok ngai seng le upa ngai khan Dan oja ngai le anlei kintup. ");
INSERT INTO pub_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Peter ning alek kin-karra ahei jui, Thiempu Chungnung tollai sung a aheilut. Khanna khan raalmi ngaile anlei kin onga mei anlei otbung. ");
INSERT INTO pub_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Thiempu kolok ngai le ankintup upa ngai seng ning Jesu that theina sik ajar anlei entok, tak inkhat te num leimumuk. ");
INSERT INTO pub_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Jesu thothelna wartheng sakhi katamtak anril, tak ansakhi pe ngaikha ite leikin angmak. ");
INSERT INTO pub_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Khan mi alek anhei ngir a Jesu thothelna hiwa wartheng sakhi hi anlei pe: ");
INSERT INTO pub_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","<<Keinining ama atikha kinjet, <Miring ning ansak hiwa bek-inn hi keining kithet sik, khan ni thum so-a miring ning ansak mak inkhat keining kasak sik.> >> ");
INSERT INTO pub_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Kha achang inum anmani ngai sakhi pe kha leikin angmuk. ");
INSERT INTO pub_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Thiempu Chungnung khaning anmani rikip maikunga angir a Jesu deng chong aleirakal, <<Anmani ning nang chunga thothelna anril hi masang lei sik mo ni-e?>> ");
INSERT INTO pub_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Takkha Jesu ning a-omchena chong inkhat lei rilmak. Ret Thiempu chungnung ning Jesu deng arakal nok, <<Nang hi ralwan katha Pathien Sapa Messiah kha mo ni-e?>> ");
INSERT INTO pub_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Jesu ning aleimasang, <<Kei ki-e, khana Miring Sapa kha akarat tak changteng akin-onga khana marwan sumphai le kinroi-a ahong chum kha ninkholo a ninmu rip sik e.>> ");
INSERT INTO pub_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Thiempu chungnung khaning apon akeitherra aleiti, <<Eini ning sakhi alop rangai mak je! ");
INSERT INTO pub_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Pathien arildek hi nangni ning ninjet je. Angmo ninmindon e?>> Ankholo ning amanom muk jei: anminthel a khan amakha nithat sik e anti. ");
INSERT INTO pub_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Alek ning Jesu kha anleimichil thon anleiphut, khan anmani ning amakha amit ankhitpe a anleisuk. <<Najetmi atuning mo anasuk e!>> anmani ning anleiti. Khan raalmi ngaining anleiroi a amakha anleikaben. ");
INSERT INTO pub_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Peter kha tollai a aleiom lai, Thiempu chungnung sok numeisa karra inkhat akolla aheiwa. ");
INSERT INTO pub_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Soknu khaning Peter mei a-ot kha amu-a, alei en nganga aleiti, <<Nang num, Nazareth Jesu le ninlei kin roi.>> ");
INSERT INTO pub_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Takkha Peter ning alei kinthing phirra aleimasang, <<Angkhami nangning niti kei jetmang,>> khan amaning inkhar tolteng aleise. Khawa laitak khan arkhong kha ahong kinram je. ");
INSERT INTO pub_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Soknu khaning ama amu nok-a amodon na akingir ngaideng khan arilnok, <<Hiwa mipa hi anmani karra inkhat e!>> ati. ");
INSERT INTO pub_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Takkha Peter akinthing phir nok je. Tomlak soa akolla akingir ngai ning Peter deng anleiti, <<Soilei-a nang anmani karra inkhat ni-e, ajarchu nang Galilee ria ni-e.>> ");
INSERT INTO pub_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Khan Peter ning aleiti, <<Kei akidik kiril e, kikin hakser hi-e! Akidik kiril mak inchu Pathien ning nakarak rase! Keining ninril mipa hi jetmang!>> ");
INSERT INTO pub_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Khawa laitak khan arkhong ning woini changna ahong kin ram je, khawa pha Peter deng Jesu ning aleiti, <<Arkhong woini ahong kinram mak lai nangning kei woithum rak jetmang niti sik.>> aleiti kha amindon jei. Khanna ama amulung kintok tak a aleichap. ");
INSERT INTO pub_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Jingteng ma a thiempu kolok ngaining upa ngai, Dan Oja ngai, khan upa rupngai ankholo a kinrangtak a ankintup a khan chong anleimintuk. Anmani ning Jesu kha thirrui a ankhit a anleiroi, khan Pilate kutchunga anleipe. ");
INSERT INTO pub_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilate ning chong aleirakal, <<Nang Jehudi ngai Reng mo ni-e?>> Jesu ning aleimasang, <<Nangning niti kha e je.>> ");
INSERT INTO pub_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Thiempu kolok ngaining Jesu kha akikhella anleirilset, ");
INSERT INTO pub_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","khawa jarra Pilate ning Jesu deng aleirakal nok, <<Nang namasanglei sik mo ni-e? Rangairo anmani rikip ning nuchunga anirilset hi!>> ");
INSERT INTO pub_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Jesu ning chongbai khat num leimasang nokmak, khawa jarra Pilate ning aleingak. ");
INSERT INTO pub_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Rakan Reikahoi anthoracham ansurra anda ngai karra mipui anmanomna miring inkhat kha Pilate ning aleimoso pe chak. ");
INSERT INTO pub_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Khawa lai khan Barabbas anti raalruk ngaile mikathat miring inkhat mikhumna a anlei om. ");
INSERT INTO pub_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Mipui ngai kha anhong kintup a aleitho ang a athonoknasik Pilate deng anhongti, ");
INSERT INTO pub_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pilate ning anmanideng aleirakal, <<Jehudi ngai Rengpa kha kunumoso pe sik nin monom mi?>> ");
INSERT INTO pub_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Thiempu kolok ngaining Jesu chunga thangse annei jarra akut chunga anhei pesuok e ti kha Pilate ning aleijet. ");
INSERT INTO pub_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Takkha thiempu kolok ngaining mipui ngai kha anleimathok a, Barabbas pot kha moso nasik a anlei minti. ");
INSERT INTO pub_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pilate ning mipui deng aleirilnok, <<khachu nangni ning Jehudi ngai Reng tia ninkoi padeng kei angmo ninimintho nom?>> ");
INSERT INTO pub_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Anmani ning anhei ong malet a, <<Cross a makhai ro!>> anti. ");
INSERT INTO pub_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Takkha Pilate ning aleirakal, <<Angsik jarra, amaning ang thothel namo anei e?>> Anmani ning akikhella an-onga anleiti, <<Cross a makhai ro!>> ");
INSERT INTO pub_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pilate ning mipui mulungkha aleimintai nom jarra Barabbas kha anmani sik a aleimoso pe jei. Khan Jesu kha anrachak a cross a makhai sik a aleipe jei. ");
INSERT INTO pub_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Raalmi ngaining Jesu kha Ramkoron pa inn tollai sunga ankei minlut a khan raalmi rikip anlei kinkoichun. ");
INSERT INTO pub_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Anmani ning pon sendup akinchuol kha Jesu anleiminsil, liling ria anbol lukhu, kha alu chunga anleiminkhu. ");
INSERT INTO pub_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Khan anmani ngaining <<Jehudi Rengpa niringsei sot rase!>> tia chibei anleitho. ");
INSERT INTO pub_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Anmani ngaining Jesu lukha luchei ning anleirachak, anleimichilthon, khan ankemorkhup anthep a ankinkun a anleikumuk. ");
INSERT INTO pub_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Anmani ning anmunuipui soli, pon sendup akinchuol kha anlik pe a, khan ama pon kha anminsil malet je. Khan cross a makhai thatsik a ankei so je. ");
INSERT INTO pub_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Lampui-a anmani ning mi inkhat ariming Simon anti aram ria khopui a akahong anlei kintonga, khan raalmi ngaining amakha namrop a Jesu cross kha anlei mindom. Simon kha Cyrene mi e khana Alexander le Rufus ngai pa e. ");
INSERT INTO pub_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Anmani ning Jesu kha Golgotha, hiwa tina chu <<Lusai mun>> antina khan anroi je. ");
INSERT INTO pub_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Khana khan theiburju le lei anminchun kha myrrh anti kha min innasik anleitho, tak Jesu khawa kha lei in mak. ");
INSERT INTO pub_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Khan Jesu kha cross a anmakhai a ama ponder kha anmani ning anleikinsem, atu ningmo pon kinlek kha anpha sik tia machal anlei-en. ");
INSERT INTO pub_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Cross a anmakhai kha jingteng pung ko a-e. ");
INSERT INTO pub_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ama cross chung a engset chonga hi-anghin anleitar: <<JEHUDI NGAI RENGPA.>> ");
INSERT INTO pub_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Ama le kinroi-a muruk inni, inkhat achangteng, inkhat awoiteng cross a anmakhai del. ");
INSERT INTO pub_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Mi akase akahong ngaining anlu ankalek a chong ero a Jesu deng anleiril: <<O-a! Bek-inn nithet li nithum sunga kasak sik niti khale! ");
INSERT INTO pub_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Atun cross chung ria hong chum inlang, nibinga kinhuk rang ro!>> ");
INSERT INTO pub_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Khawa angkhan thiempu kolok ngai le Dan oja ngai ning Jesu anmunui so-a, inkhat le inkhat ankinbek a, <<Amaning milak chu ahuk a, abinga chu kinhuk tor mak! ");
INSERT INTO pub_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Messiah Israel ngai Rengpa, cross chung ria atun hongchum ro, khan nahongchum kha kinmuli keini ning nataksen kinte!>> Khan cross a ama le anmakhai bung inni ngai khaning num ama anlei ril set. ");
INSERT INTO pub_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Sunchimma ram pumpui akijing ning aleimukhu, khawakha pung inthum kutung kha-angkhan aleiti je. ");
INSERT INTO pub_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Pung inthum a Jesu rasa kinlaktak a-onga, <<Eloi, Eloi, lema sabachthani?>> ati, hiwa tina chu, <<Ka Pathien, ka Pathien angsikmo kei nana dadoi e?>> ");
INSERT INTO pub_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Khana akaom mi alek ngaining anjet a anti, <<Rangai ru, amaning Elijah akoi hi!>> ");
INSERT INTO pub_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Ankarra mi inkhat ataanna ponlom kha theiburju kuthur kha amiche-a luchei inkhat mor a akithil a, khana ria Jesu ner katung amajop nasik apeli aleiti, <<Ngaakdiri! Elijah ahonga ama cross ria akadom mata sik mi, enri!>> ");
INSERT INTO pub_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Khana rasa kinringa a-onga Jesu kha athi jei. ");
INSERT INTO pub_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Bek-inna andong pon kha achung ria athoi kutung aher inni a akin ther je. ");
INSERT INTO pub_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Khawa mun a cross mudon akingir raalmi lamkakei inkhat ning Jesu thidan kha aleimu. Amaning aleiti, <<Akidiktak a hiwa mipa hi Pathien Sapa e!>> ");
INSERT INTO pub_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Akalakdet ria alei ka-en numei alek anlei om. Ankarra khan Mary Magdalene, anaipa James le Joseph annu Mary, khana Salome ngai an e. ");
INSERT INTO pub_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Anmani ning Jesu kha Galilee a aomlai anleijui khan anleisen. Khawa munna khan Jerusalem a ama le anhei kinroi numei katamtak num anlei om. ");
INSERT INTO pub_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Arimathea a Joseph ahong tung kha kholei teng a-e je. Amakha Pathien Rengram ahongtung sik alei kangaak, kaja ka-om upa rup karra inkhat e. Khawa kini kha kinrinni e (ti chu, Jehudi ngai Serni kini makma) khana Joseph ning kin-ngam tak a Pilate maikunga awase-a amadeng Jesu kulong kha aleini. ");
INSERT INTO pub_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pilate ning Jesu athi jei ti aleijet phakhan aleingak. Raalmi lamkakeipa kha akoi-a Jesu thina asot mije tia alei rakal. ");
INSERT INTO pub_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Raalmi lamkakeipa chong ajet so-a, Pilate ning Joseph deng Jesu kulong kha naleithei sik aleitipe. ");
INSERT INTO pub_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Joseph ning ruipon kinnem neng arocho-a, akulong kha akadamthak a pon khaning akusun a lunga ankiwit thaan sunga aware jei. Khana lung kolok inkhat aminlet a thaan inkhar suokna kha aleikhar. ");
INSERT INTO pub_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Mary Magdalene le Joseph nu Mary ning Jesu kulong anrena kha anleimu je. ");
INSERT INTO pub_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Jehudi Serni kini ator so-a, Mary Magdalene le James nu Mary khan Salome ngai Jesu kulong kunot nasik arim kahoi anlei rocho. ");
INSERT INTO pub_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Maapning jingteng matak a, kini ahong suokpha anmani thaan teng anlei se. ");
INSERT INTO pub_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","4","Anmani lampui tonna ansena inkhat le inkhat ankin bek a, <<Thaankhar lungkha atuningmo ana iltot pesik?>> (Khawa kha lung kolok inkhat e.) Khan anmani ning an-inna lungkha alei kinlet kha anleimu. ");
INSERT INTO pub_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Khan anmani ning thaan sunga alut a, pon kinchoul kabang kachek kinsil khangdong inkhat changteng panga akin-ong anleimu, khan anmani ning anlei kinlai. ");
INSERT INTO pub_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","<<Kinlai muru,>> amaning aleiti. <<Nangni ning Nazareth Jesu cross a anmakhai kha nin entok keining kajet. Ama athei a, hin om-mak je! Enru, amaning ajalna kha hi e. ");
INSERT INTO pub_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Atuntak se inlang hiwa chongkahoi hi ama thiemroi ngai le Peter deng warilru: <Ama Galilee teng ninma a aleise je; nang nideng aleiril anga khawa mun a ninwamu sik.> >> ");
INSERT INTO pub_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Anmani ansuok a thaan ria aheitaan je, anchi le anratha kinnok ning asip je. Anmani anchi hei-a atukhat deng inkhatte ril muk je.  ");
INSERT INTO pub_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Jesu thina ria atheinok nuktenga, maapning kini matak a Mary Magdalene, asung ria khori sari aholsuok penu deng masatak akinlar. ");
INSERT INTO pub_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Khawanu ning ase-a alei kinroipui asap ngaideng aleiril. Anmani anmulung leihoimak a anlei chap; ");
INSERT INTO pub_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","khana numeinu khaning Jesu aring amu-a arilpe ngaikha anjet inum anmani ning leitaksen muk. ");
INSERT INTO pub_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Khan, Jesu ning ankarra miring inni deng ankho sena lampui a anselai alop det a alei kinlar. ");
INSERT INTO pub_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Anmani ning anhei kirra mi alak deng anwaril pe, takkha anmani ning lei taksen muk. ");
INSERT INTO pub_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Nuktenga, Jesu thiemroi somle inkhat ngai bu anbak lai alei kinlar. Anmanideng aleiren, ajarchu anmani taksenna neimuk khan anmulung anger rangra, ama aring jei tia akumu ngai chong kha taksen tor muk. ");
INSERT INTO pub_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Jesu ning anmanideng aleiti, <<Simleichung pumpui a se inlang khan chongkahoi hi miring rikip deng warilru. ");
INSERT INTO pub_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Tu achang inum ataksen a baptized akatho mi kha hukminring achen sik; tu achang inum akataksen mak mi kha misetna achen sik. ");
INSERT INTO pub_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Akataksen ngai kha hiwa sin kinlak thotor na ranak akinpe sik; anmani ning kei riming a khori ngai holsuok torna annei sik; anmani ning anjetngaimak chonglop anchong sik; ");
INSERT INTO pub_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","murul ngai ansura a-imakli tur an-in inum ite tinonung; mi akana ngai chunga ankut anda sik khana akana ngai kha andam sik.>> ");
INSERT INTO pub_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Puma Jesu ning anmanideng chong aril so pha, amakha marwan chungteng anroi a khan Pathien akut changteng akin-ong je. ");
INSERT INTO pub_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Thiemroi ngai ning anse a amun rikip a chongkahoi anwaril, khan Puma ning anmani ngai kha akinroipui chak, khan antho sin kinlak ngai khaning anmani chongril kha adik tia amalar pe jei. ");
INSERT INTO pub_vpl VALUES ("MK16_21","071_16_21","MRK","16","21","21","Numeinu kha Peter le asap ngaideng ase a anmanideng aleikinti seng kha akabei a awamin jet. ");
INSERT INTO pub_vpl VALUES ("MK16_22","071_16_22","MRK","16","22","22","Khan, kumleiko hukminringna akintheng le akiring chak chongpui kha Jesu khet ning ama thiemroi ngaikha, niso teng ria taitak teng kutung aleimoso jei.");
ALTER TABLE pub_vpl ADD FULLTEXT(verseText);
UNLOCK TABLES;
