﻿USE sofia;
DROP TABLE IF EXISTS sofia.ptu_vpl;
CREATE TABLE ptu_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES ptu_vpl WRITE;
INSERT INTO ptu_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Wattunna napahandu' Puang Allataala umpadadi langi' anna lino, ");
INSERT INTO ptu_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","inde lino tä'pi ma'lesoam anna lo'bäpi; malillim pättä ussamboi le'bo' kalua', anna Penaba Masehona Puang Allataala ma'leba-leba yabona le'bo'. ");
INSERT INTO ptu_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Iya ma'kadam Puang Allataala naua: “La dadi masiä!” Iya dadim masiä. ");
INSERT INTO ptu_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Dadii indo masiä, iya mapia naita Puang Allataala. Napasibala'um indo malillim anna masiä. ");
INSERT INTO ptu_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Indo masiä nasangai allo anna indo malillim nasangai bengi. Lessu' bengi sule mebengngi', iam too uhuna allo. ");
INSERT INTO ptu_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Puhai ia too ma'kada oom Puang Allataala naua: “La dadi pesapa'na uwai yabo anna uwai dio.” ");
INSERT INTO ptu_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Iya napadadim indo pesapa' la ussapa' uwai yabo anna uwai dio. ");
INSERT INTO ptu_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Indo pesapa' nasangai lawwa. Lessu' oom bengi sule mebengngi', iam too allo kaduanna. ");
INSERT INTO ptu_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Puhai ia too ma'kada oom Puang Allataala naua: “Ingganna uwai dio ibi'na langi' la ma'mesa lako mesa ongeam anna mala deem ongeam tää'na keuwai.” Iya dadim ia too. ");
INSERT INTO ptu_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Nasangaim indo mabanginna galantangam anna indo keuwainna nasangai ia le'bo'. Iya mapia oom naita Puang Allataala. ");
INSERT INTO ptu_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Anna mane ma'kada Puang Allataala naua: “Galantangam la umpakende' ma'hupa-hupa tanangam susinna: tanangam ma'lise' anna kaju kembua ma'lise' anna mala dipopamulaam liu.” Iya dadim ia too. ");
INSERT INTO ptu_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Indo galantangam umpakende'um ma'hupa-hupa tanangam: tanangam ma'lise' anna kaju kembua ma'lise' anna mala deem liu pamulaam. Iya mapia oom naita Puang Allataala. ");
INSERT INTO ptu_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Lessu' oom bengi sule mebengngi', iam too allo katallunna. ");
INSERT INTO ptu_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","15","Puhai ia too ma'kada oom Puang Allataala naua: “La deem yabo langi' to la ma'pomasiä', la umpasibala' allo anna bengi. Anna la dipangngissanni wattu anna allo sola taum, anna la umpomasiä' lino.” Iya dadim ia too. ");
INSERT INTO ptu_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Napadadim Puang Allataala dua handam kasalle to la ma'pomasiä'. Indo kasallena isanga mata allo la umpahe' masiä anna isanga bulam la umpahe' bengi. Anna napadadii duka' ingganna bintä. ");
INSERT INTO ptu_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Ingganna ia too napadadi asam yabo langi' anna malai umballoi lino ");
INSERT INTO ptu_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","anna umpahe' allo anna bengi anna la umpasibala' masiä anna malillim. Iya mapia oom naita Puang Allataala. ");
INSERT INTO ptu_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Lessu' oom bengi sule mebengngi', iam too allo kaappa'na. ");
INSERT INTO ptu_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Puhai ia too ma'kada oom Puang Allataala naua: “Illaam le'bo' la naponnoi ma'hupa-hupa bau anna olo'-olo' senga', anna yabo lawwa la sikatia' ma'hupa-hupa dassi.” ");
INSERT INTO ptu_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Iya napadadim ma'hupa-hupa olo'-olo' le'bo' mengkalao kasallena sule lako bahinni'na umponnoi le'bo', anna umpadadi ingganna hupanna dassi. Iya mapia oom naita Puang Allataala. ");
INSERT INTO ptu_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Anna mane natamba' indo issinna le'bo' naua: “Pembea'koa' anna mala umponnoi liukoa' le'bo'.” Susi siam duka' untamba' indo ingganna mentia'na anna malai duka' membea' lako lino. ");
INSERT INTO ptu_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Lessu' oom bengi sule mebengngi', iam too allo kalimanna. ");
INSERT INTO ptu_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","25","Puhai ia too ma'kada oom Puang Allataala naua: “Inde lino la umpassubum ingganna olo'-olo' ma'bitti' appa'na anna tissollo'na, susi manahanna teem malaihanna.” Iya napadadim ingganna olo'-olo' ma'bitti' appa'na anna tissollo'na, susi manahanna teem malaihanna. Dadii ia too, iya mapia oom naita Puang Allataala. ");
INSERT INTO ptu_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Anna mane ma'kada Puang Allataala naua: “Tapapiaia' hupatau la susikia' anna la ia umpahe' ingganna bau dio le'bo', ingganna dassi yabo lawwa anna olo'-olo' manahanna anna tissollo'na sola ingganna issinna lino.” ");
INSERT INTO ptu_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Iya napapiam Puang Allataala hupatau susi hupanna. Natampa susi hupanna Puang Allataala. Muane anna baine napadadi. ");
INSERT INTO ptu_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Anna mane natamba' anna ma'kadai naua: “Pembea'koa' anna mala umponnoi lino pessubummu anna la ungkuasaia' ingganna issinna. La umpahe' ingganna bau dio le'bo', ingganna dassi yabo lawwa, anna ingganna olo'-olo' illaam inde lino. ");
INSERT INTO ptu_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Pehingngii! Kubeemmokoa' ingganna tanangam ma'lise' anna ingganna kaju kembua ma'lise' illaam inde lino la mendadi kinandemua'. ");
INSERT INTO ptu_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Anna lako ia ingganna olo'-olo' illaam lino sola ingganna dassi yabo lawwa, battu diua ingganna menabanna, kubeem duka' ingganna tanangam la mendadi kinandena.” Iya dadim ia too. ");
INSERT INTO ptu_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Iya naitam Puang Allataala indo ingganna pa'padadinna tä' deem pada samapia. Lessu' oom bengi sule mebengngi', iam too allo kaannanna. ");
INSERT INTO ptu_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Susim too napapuha umpadadi langi' anna lino sola ingganna issinna Puang Allataala. ");
INSERT INTO ptu_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Tappana lambi' allo kapitunna puha asammi indo ingganna aka-aka napadadi Puang Allataala. Iya allo iam too naongei tohho Puang Allataala aka dadi asammi pa'padadinna. ");
INSERT INTO ptu_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Natamba'um anna napasähä' allo kapitunna, aka allo iam too naongei Puang Allataala tohho aka dadi asammi pa'padadinna. ");
INSERT INTO ptu_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Susi inde tulasanna indo anna napadadi Puang Allataala langi' anna lino: Wattunna anna napadadi Puang Allataala DEBATAnta langi' sola lino, ");
INSERT INTO ptu_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","tä'pi deem humpu' tubo dio mai litä' anna tä'pi deem tanangam mukku' dio mai bela', aka tä'pi deem napatuhum Puang Allataala DEBATAnta uham. Anna pa'depi duka' hupatau ungkähä litä'. ");
INSERT INTO ptu_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Sapo' anggam deem susi langullo buttu dio mai litä' si umbossi'i ingganna aka-aka lako lino. ");
INSERT INTO ptu_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Iya mualam sobä' Puang Allataala DEBATAnta anna natampai mesa tau, mane nasimbuhu'i tama illäna penaba mepatubo nasuhum tubo. ");
INSERT INTO ptu_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Tappana puha ia too, umpapiam bela' Puang Allataala DEBATAnta dio tandai mata allo illaam Eden, anna napatadongkonni indo tau puha napadadi illaam indo bela'. ");
INSERT INTO ptu_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Iya napatubom Puang Allataala DEBATAnta ma'hupa-hupa kaju si mapi'dä' diita anna si mapia buana mala diande. Anna illaam tängäna indo bela' tubo satoo' kaju la mala mepatubo anna satoo' kaju la mala mepaissanni kamapiaam anna kakadakeam. ");
INSERT INTO ptu_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Deem mesa salu muola Eden si ullessä'i indo bela'. Umpellei indo bela', iya tibahe appa'um. ");
INSERT INTO ptu_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Mesa disangai Salu Pison. Salu ia too muola lako lembäna Hawila, indo ongeam si dipangngalai bulabam. ");
INSERT INTO ptu_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Bulabanna ongeam ia too mapia. Deem toi duka' dama' bubanau' anna batu masulli'. ");
INSERT INTO ptu_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Anna kaduanna disangai Salu Gihon. Salu ia too muola lako ia lembäna Kush. ");
INSERT INTO ptu_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Anna katallunna disangai Salu Tigris, mangngola lako ia tandai mata allona Asyur. Anna kaappa'na disangai ia Salu Efrat. ");
INSERT INTO ptu_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Naeli' Puang Allataala DEBATAnta indo tau anna napatadongkonni illaam bela' Eden, aka la nakähä anna najagai. ");
INSERT INTO ptu_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Mane napahentai Puang Allataala DEBATAnta naua: “Ingganna bua kaju illaam inde bela' mala asam muande. ");
INSERT INTO ptu_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","Anggam buana indo kaju mepaissanni kamapiaam anna kakadakeam, tä' si'da-si'da ia la mala muande. Aka maka' muande la mate eta siangko.” ");
INSERT INTO ptu_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Puhai ia too ma'kadam Puang Allataala DEBATAnta naua: “Tä' mapia ke anggam mesa-mesanna inde tau tubo. Dadi mapia ke dipapiaanni duka' solana, to la sihatam umpamoloi.” ");
INSERT INTO ptu_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Anna mane mualai litä' anna natampai ingganna hupanna olo'-olo' si diona galantangam sola ingganna hupanna dassi yabo lawwa. Puhai natampa, nababam lako olona Adam aka la pantam nasangai anna napehingngii Puang Allataala aka la nasangaiam. Iai too nasangaiam indo olo'-olo', ia lium too sanganna. ");
INSERT INTO ptu_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Iya nasangaim indo ingganna olo'-olo', susi manahanna teem malaihanna sola ingganna dassi. Sapo' tä'pi ia deem naita Adam la sihatanna nasi'dim la mala umpamoloi. ");
INSERT INTO ptu_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Iya napalimpe'um mamma' Puang Allataala DEBATAnta indo Adam. Mahassanni mamma' naäläim mesa usu'na, mane natampi'i sule indo pangngalaanna. ");
INSERT INTO ptu_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Indo usu' naala illaam mai kalena Adam natampa mesa baine, anna mane nababaam lako olona Adam. ");
INSERT INTO ptu_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Iya nauam Adam: “Mane inde hi pole' to kusihatangam, aka bukungku napobuku anna baleku napobale. Anna la disangai baine aka diala illaam mai kalena muane.” ");
INSERT INTO ptu_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Iam too anna lako mesa muane la umpellei indona sola ambena anna sialai mesa baine, nasuhum duai la mendadi mesa illaam ingganna-ingganna sia. ");
INSERT INTO ptu_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Wattu eta too indo muane sola bainena bassim ma'kambelä, sapo' tä' masihi'. ");
INSERT INTO ptu_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Ingganna olo'-olo' malaiha napadadi Puang Allataala DEBATAnta yabo galantangam ula'um handam manahhu' mantipu. Indo ula' mekutana lako indo baine naua: “Tappa' si'da haka nalahangkoa' Puang Allataala muande ingganna bua kaju illaam inde bela?” ");
INSERT INTO ptu_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Natimba'im indo baine naua: “Ingganna bua kaju illaam inde bela' mala asam kiande, ");
INSERT INTO ptu_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","sulibanna indo bua kaju illaam inde tängäna bela' aka naua Puang Allataala: ‘Tä' si'da-si'da mala uhhaka' dapaka ia la muande buana, aka maka' muande la matekoa'.’” ");
INSERT INTO ptu_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Iya nauam indo ula': “Setonganna tä'koa' la mate. ");
INSERT INTO ptu_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Sapo' ia hi tia anna nauai Puang Allataala, aka maka' muandea', la tibukka pikkihammua' anna la susikoa' Puang Allataala la muissam usse'la kamapiaam anna kakadakeam.” ");
INSERT INTO ptu_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Tappana naita indo baine bua kaju ia too tä' si'da deem pada samapia, la mammi' diande, anna la umpatibukka pikkiham, iya naponge' siaham indo bua kaju dipelahangam anna naandei. Puhai naande, iya nabeemmi duka' muanena naande. ");
INSERT INTO ptu_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Puhanna naande tappa tibukka siaham pikkihanna anna naissammi pole' naua: “Ma'kambelä haki' kita päläe'!” Iya mualam daunna kaju ara anna napasiampim-ampinni nasapu'iam kalena. ");
INSERT INTO ptu_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Tappana kahubenni uhhingngim pehhondona Puang Allataala DEBATAnta ma'lao-lao illaam indo bela'. Iya bassim le'ba'um tama alla' kaju illaam indo bela' umpembuniam Puang Allataala. ");
INSERT INTO ptu_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Sapo' natambai Puang Allataala DEBATAnta indo muane naua: “O Adam, umbako ngei?” ");
INSERT INTO ptu_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Natimba'im Adam naua: “Kuhingnginna pentekkamu illaam inde bela', iya le'ba' siahamä' membuni mahea' aka kuissammi kuua ma'kambelä hä' kao päläe'.” ");
INSERT INTO ptu_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Iya ma'kadam Puang Allataala naua: “Menna umpaissanniko anna muissanni muua: ‘Ma'kambelää'?’ Muande haka iko indo bua kaju kupelahangam la diande?” ");
INSERT INTO ptu_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Natimba'im Adam naua: “Indo baine umpadioannä' ampe'ku, iam too umbeennä' indo bua kaju anna kuandei.” ");
INSERT INTO ptu_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Iya mekutanam Puang Allataala DEBATAnta lako indo baine naua: “Akanna umpateenni?” Mentimba'um indo baine naua: “Aka natipuä' indo ula' nasuhum kuande indo bua kaju.” ");
INSERT INTO ptu_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Iya ma'kadam Puang Allataala DEBATAnta lako indo ula' naua: “Ingganna olo'-olo' manahanna anna malaihanna illaam inde lino anggam iko la ditädo. Dadi la tissollo'ko dio litä' tiasa dadammu anna la sobä' kinandemu sule lako matemu, aka taia gau' umpogau'. ");
INSERT INTO ptu_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Dadi mengkalao iko solakoa' inde baine la kupasipobali sule lako pessubummua'. La untikkuko kambutu'na pessubunna, anna pessubunna la nahäppu-häppusangko iko ulummu.” ");
INSERT INTO ptu_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Mane nauai lako indo baine: “La masussa si'da-si'dako iko ke kebättäko anna la ussi'dingko kamapi'disam kasalle ke keänä'ko. Sapo' moinna anna susi la tontä liu kende' kamohäeammu lako muanemu anna la napahe'ko muanemu.” ");
INSERT INTO ptu_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Anna mane ma'kada lako indo muane naua: “Aka umpehingngii puha hako iko bainemu anna la Kao, nasuhum muandeko indo bua kaju kupelahangam. Dadi la kutädo litä' aka natumä gau'mu, nasuhum la to'do appu' mahihimmu mengkähä mane deenni muande, sule lako matemu. ");
INSERT INTO ptu_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Litä' la umpakende' ingganna humpu' keduhi. Anna ingganna humpu' tubo lako pädä la umpokinande. ");
INSERT INTO ptu_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","La ullämmä'ko meangga sikummu mengkähä mane deenni muande, lambi' ma'pasuleko sule dokko litä', aka eta muongei buttu. Aka litä'ko ditampa, iya la dadi litä'ko sule.” ");
INSERT INTO ptu_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Adam ussangai bainena Hawa aka la mendadi indona ma'hupatau. ");
INSERT INTO ptu_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Iya napapiaammi Puang Allataala DEBATAnta poheba lollo' olo'-olo' anna napapohebaianni Adam sola bainena. ");
INSERT INTO ptu_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Ma'kadam Puang Allataala DEBATAnta naua: “Inde hupatau susingkia' naissammi pole' usse'la kamapiaam anna kakadakeam. Dadi temo pahallu la dijagai indana naalai duka' indo bua kaju mepatubo. Aka maka' mala naande, iya la tubo liu sule lako salako-lakona.” ");
INSERT INTO ptu_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Nasuhum nasua lao Puang Allataala DEBATAnta indo hupatau umpellei bela' Eden anna ungkähäi indo litä' naongei buttu. ");
INSERT INTO ptu_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Puhai nasua lao Puang Allataala indo hupatau, iya ussuam sanaka-naka kerub tohho dio indo ba'bana bela' Eden, tandai mata allo, sola pa'dam ma'nala-nala tiputa' lelem lao pali'. Muampai indo lalam lako too' kaju mepatubo. ");
INSERT INTO ptu_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Iya solam metindo Adam anna Hawa bainena lambi' kebättä Hawa sampe undadiam mesa muane. Iya ma'kadam Hawa naua: “Pa'kamasenam too DEBATA nasuhum malaä' undadiam mesa muane.” Iam too anna nasangaim Kain. ");
INSERT INTO ptu_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Mane undadiam polei mesa muane, nasangai ia Habel. Tappana kasalle indo dua änä'na, iya si ma'kambi' ia Habel anna si mengkähä litä' ia Kain. ");
INSERT INTO ptu_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Pissam wattu muala sabaheam bua pengkähäna indo Kain, anna napehumalasanni längäm DEBATA. ");
INSERT INTO ptu_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Naala duka' Habel sanaka-naka uhu änä'na dombana, natunu, anna naala asanni lompona napehumalasam. Lambi' tä' deem pada sanapohäe DEBATA Habel sola bua pemala'na. ");
INSERT INTO ptu_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","Sapo' Kain ia sola bua pemala'na tä' napohäe DEBATA. Tä' deem pada sameali-ali Kain anna hosso penabanna. ");
INSERT INTO ptu_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Iya ma'kadam DEBATA lako Kain naua: “Akanna keaha'ko anna umpahosso penabammu? ");
INSERT INTO ptu_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Aka indo kela ma'gau' mapiako la ussi'dim dako tia duka' kakassiam. Sapo' maka' tä'ko ma'gau' mapia, dosa sihhapam to mantoho' natoho'ungko la napentamai. Sapo' pahallu la umpentaloi.” ");
INSERT INTO ptu_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Iya ma'kadam Kain lako adinna naua: “Habel, talao lako bela'.” Sulei lako bela'na, tappa uhhopäi Habel adinna napatei. ");
INSERT INTO ptu_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Iya ma'kadam DEBATA lako Kain naua: “Umba ngei Habel adimmu?” Natimba' Kain naua: “Tä' kuissam. Aka kao haka too kao si unjagai?” ");
INSERT INTO ptu_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Iya ma'kada pole oom DEBATA naua: “Akanna umpogau'ko kakadakeam? Indo hahana adimmu sihhapam kamaha napengkaalaiä' dio mai naua: ‘Napateiä'.’ ");
INSERT INTO ptu_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Dadi temo kutädoko, tä'ungko la mala ungkähä litä', aka naongei titollo hahana adimmu indo anna umpatei. ");
INSERT INTO ptu_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Aka moiko la mantanam tä' siam la kembua. Dadi la laoko kalao-lao bäbä ussambai lino ma'dassi tahampo.” ");
INSERT INTO ptu_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Natimba' Kain naua: “O DEBATA moi kela daa itim pesämbä'mu tama kaleku tä' punala la kubela kupendudum. ");
INSERT INTO ptu_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Aka ussuamä' lao umpellei inde ongeam anna tä'ungki' deem la siita. Aka la kalao-lao bäbämä' ussambai lino, anna la napateimä' too tau ke deenni kusitammuam.” ");
INSERT INTO ptu_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Nauam DEBATA: “Tää'! Maka' deengko la umpatei, la dipabala'i pempitu tiluppi'.” Iya napapiaammi DEBATA tanda dio kalena anna mala tä' la napatei tau ke deenni nasitammuam. ");
INSERT INTO ptu_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Iya le'ba'um Kain umpellei DEBATA lu dekke tandai mata allona Eden anna tohhoi dio Nod. ");
INSERT INTO ptu_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Iya solam metindo Kain anna bainena, lambi' kebättä bainena sampe undadiam mesa muane nasangai Henokh. Pissananna umpapiam mesa kota anna nasangai Henokh napasikona änä'na. ");
INSERT INTO ptu_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Indo Henokh undadiam Irad, Irad undadiam Mehuyael, Mehuyael undadiam Metusael, Metusael undadiam Lamekh. ");
INSERT INTO ptu_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Indo Lamekh baju'. Isanga Ada mesa bainena, anna isanga Zila mesa. ");
INSERT INTO ptu_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Ada ia ungkeänäsam Yabal. Yabal-um too handam yolo umpatubo olo'-olo' anna si ma'pentieli'-eli'i mebahum. ");
INSERT INTO ptu_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Adinna Yabal isanga Yubal. Yubal-um too handam yolo ma'katapi anna ma'sulim. ");
INSERT INTO ptu_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Zila ia ungkeänäsam Tubal-Kain. Iam too handam yolo mendadi pande gällä anna bassi. Deempi adinna Tubal-Kain baine isanga ia Naama. ");
INSERT INTO ptu_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Pissam wattu ma'kada Lamekh lako indo dua bainena naua: “O Ada solakoa' Zila, patananniia' talinga inde tula'ku: Puhaä' umpatei mesa änä' muane aka nabasaiä'; umpaletta' sungnga'ä' mesa to mangnguha aka sukka'-sukka' kaleku nahabi'. ");
INSERT INTO ptu_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Maka' deem la umpatei Kain, la dipabala'i ia pempitu tiluppi', sapo' maka' kao deem tau la umpateiä' la dipabala'i ia pempitu pulona anna pitu tiluppi'.” ");
INSERT INTO ptu_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Iya sola oom metindo Adam anna Hawa lambi' undadiam pole oom mesa muane. Iya nasangaim ia Set, aka naua Hawa: “Nabala'iannä' Puang Allataala indo kakanna isanga Habel aka puha napatei Kain.” ");
INSERT INTO ptu_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Indo Set undadiam mesa muane isanga Enos. Wattu etam too anna napahandu'i hupatau umpenombai DEBATA. ");
INSERT INTO ptu_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","2","Wattunna anna untampai hupatau Puang Allataala, natampa susi kalena. Napapia dua hupa: muane anna baine. Puhai natampa, natamba'um anna nasangai “Hupatau”. Iya indem pessubunna Adam: ");
INSERT INTO ptu_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Tappana sahatu' tallu puloi taunna dadinna Adam, iya undadiammi mesa muane nasangai Set. Indo Set bangom kaju ambena. ");
INSERT INTO ptu_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Puhai undadiam Set, tubopi kahua hatu' taunna Adam anna undadiam polepi sanaka-naka änä', muane anna baine. ");
INSERT INTO ptu_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Ia ham mane matei kaseha hatu' tallu pulo taunna. ");
INSERT INTO ptu_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Tappana sahatu' limai taunna dadinna Set, undadiammi mesa muane nasangai Enos. ");
INSERT INTO ptu_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Puhai undadiam Enos, tubopi kahua hatu' pitu taunna Set anna undadiam polepi sanaka-naka änä', muane anna baine. ");
INSERT INTO ptu_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Ia ham mane matei kaseha hatu' sapulo dua taunna. ");
INSERT INTO ptu_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Tappana kaseha puloi taunna dadinna Enos, undadiammi mesa muane, nasangai Kenan. ");
INSERT INTO ptu_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Puhai undadiam Kenan, tubopi kahua hatu' sapulo lima taunna Enos anna undadiam polepi sanaka-naka änä', muane anna baine. ");
INSERT INTO ptu_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Ia ham mane matei kaseha hatu' lima taunna. ");
INSERT INTO ptu_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Tappana pitu puloi taunna dadinna Kenan, undadiammi mesa muane, nasangai Mahalaleel. ");
INSERT INTO ptu_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Puhai undadiam Mahalaleel, tubopi kahua hatu' appa' pulo taunna Kenan anna undadiam polepi sanaka-naka änä', muane anna baine. ");
INSERT INTO ptu_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Ia ham mane matei, tappana kaseha hatu' sapulo taunna. ");
INSERT INTO ptu_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Tappana annam pulo limai taunna dadinna Mahalaleel, undadiammi mesa muane, nasangai Yared. ");
INSERT INTO ptu_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Puhai undadiam Yared, tubopi kahua hatu' tallu pulo taunna Mahalaleel anna undadiam polepi sanaka-naka änä', muane anna baine. ");
INSERT INTO ptu_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Ia ham mane matei kahua hatu' kaseha pulo lima taunna. ");
INSERT INTO ptu_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Tappana sahatu' annam pulo dua taunna dadinna Yared, undadiammi mesa muane nasangai Henokh. ");
INSERT INTO ptu_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Puhai undadiam Henokh tubopi kahua hatu' taunna Yared anna undadiam polepi sanaka-naka änä', muane anna baine. ");
INSERT INTO ptu_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Ia ham mane matei kaseha hatu' annam pulo dua taunna. ");
INSERT INTO ptu_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Tappana annam pulo lima taunna dadinna Henokh, undadiammi mesa muane nasangai Metusalah. ");
INSERT INTO ptu_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Puhai undadiam Metusalah, tubopi tallu hatu' taunna Henokh silombum Puang Allataala anna natuhu'i pa'elo'na. Anna undadiam polepi sanaka-naka änä', muane anna baine. ");
INSERT INTO ptu_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","24","Dadi tallu hatu' annam pulo taunna naolaam tubo Henokh silombum liu Puang Allataala mane tä'i deem diita pole aka naäkä'um Puang Allataala längäm suhuga. ");
INSERT INTO ptu_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Tappana sahatu' kahua pulo pitu taunna dadinna Metusalah, undadiammi mesa muane nasangai Lamekh. ");
INSERT INTO ptu_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Puhai undadiam Lamekh, tubopi pitu hatu' kahua pulo dua taunna Metusalah anna undadiam polepi sanaka-naka änä', muane anna baine. ");
INSERT INTO ptu_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Ia ham mane matei kaseha hatu' annam pulo kaseha taunna. ");
INSERT INTO ptu_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Tappana sahatu' kahua pulo dua taunna dadinna Lamekh, undadiammi mesa muane ");
INSERT INTO ptu_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","nasangai Nuh aka naua: “Inde änä' la mebabaam pepakahangaam illaam pengkähänganta indo taongei madahha muasai pala'ta ungkähä inde litä' puha natädo DEBATA.” ");
INSERT INTO ptu_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Puhai undadiam Nuh, tubopi lima hatu' kaseha pulo lima taunna Lamekh anna undadiam polepi sanaka-naka änä', muane anna baine. ");
INSERT INTO ptu_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Ia ham mane matei pitu hatu' pitu pulo pitu taunna. ");
INSERT INTO ptu_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Tappana lima hatu' taunna dadinna Nuh, undadiammi tallu muane anna nasangai Sem, Ham, anna Yafet. ");
INSERT INTO ptu_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Tappana tuttuam membea' hupatau lako lino anna buda baine nadadiam, ");
INSERT INTO ptu_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","iya budam änä'-änä'na Puang Allataala muita indo änä' daha sikapi'däsam nasuhum napobaine bäbä ia siam anna ia napohäe. ");
INSERT INTO ptu_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Pissananna ma'kadam DEBATA naua: “Tä'um la si masäe kupatohho Penabangku illaam kalena hupatau aka taia to la da'da liu. Sapo' handam masäenam ke sahatu' dua puloi taunna kupatubo.” ");
INSERT INTO ptu_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Tappana sola metindo indo änä'-änä'na Puang Allataala anna änä' daha to lino, iya kebättäm lambi' napadadiam änä'. Indo änä'na mendadi to kuasa yolona anna buda pa'pogausanna molele-lele. Etam too napahandu' anna deenni tau tonggo illaam inde lino. ");
INSERT INTO ptu_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Tappana naita DEBATA tuttuam kadäkke' gau'na hupatau lako lino anna ingganna pattuju penabanna kadake liu, ");
INSERT INTO ptu_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","iya menassammi DEBATA anna mapi'di' penabanna aka puham untampa hupatau illaam inde lino. ");
INSERT INTO ptu_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Iam too anna nauam: “La kutallanni asam ingganna indo puha kupadadi inde lino susi hupatau susi olo'-olo' manahanna anna malaihanna sola olo'-olo' tissollo'na anna ingganna dassi yabo lawwa, aka menassannä' kela tä' oha kupadadi.” ");
INSERT INTO ptu_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Sapo' tä' ia la ditallanni Nuh aka angga ham ia umpomasannam penabanna DEBATA. ");
INSERT INTO ptu_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","10","Indem ia tulasanna Nuh: Deem tallu änä'na Nuh isanga Sem, Ham, anna Yafet. Indo Nuh mesa to malolo gau' anna anggam ia tä' deem sassainna illaam lino indo wattu eta too. Aka Nuh ia silombum liu Puang Allataala anna natuhu'i pa'elo'na. ");
INSERT INTO ptu_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Sapo' ingganna hupatau senga' ma'gau' kadake asam dio olona Puang Allataala, anna ingganna tau illaam inde lino anggam sikalla-kalla tä' deem untauam padanna. ");
INSERT INTO ptu_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Tappana naita Puang Allataala angga ham kakadakeam dadi illaam inde lino, aka angga hanni umpoelo' elo'na ingganna hupatau, ");
INSERT INTO ptu_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","iya ma'kadam lako Nuh naua: “Puham kukattu la kuhopui ingganna hupatau sola olo'-olo' illaam inde lino. Anna la kutallanni inde lino aka angga ham ma'gau' kadake ingganna hupatau. ");
INSERT INTO ptu_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Dadi papiai mesa kappala' le'bo' la muongei. La kaju gofir umpake anna la ma'sapa'-sapa' illaam hoäna. Anna la ullapi' panti' hindinna, sulibanna anna illaanna. ");
INSERT INTO ptu_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Indo kappala' la umpapia la susi indee: tallu hatu' singkum kalandona, lima pulo singkum kalua'na anna tallu pulo singkum malangka'na. ");
INSERT INTO ptu_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Anna la umpapia tallu todo'na anna la umpapai, malangka'na indo papana la sasingkum umpellei hindinna. Anna la umba'bai dio sa'dena. ");
INSERT INTO ptu_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","La kupasule mala'bu' umbussui inde lino anna mala tallam asam ingganna menabanna illaam inde lino, lambi' mate asam. ");
INSERT INTO ptu_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Sapo' iko-iko, ma'dandiä' la deem liu kasilombunganta. Anna la tamakoa' indo kappala' solakoa' bainemu, änä'mu anna manintummu. ");
INSERT INTO ptu_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","20","Anna la umbaba toi duka' sanda si sapasam ingganna olo'-olo' anna mala tubokoa' pada-pada illaam indo kappala'. Susi ingganna hupanna dassi teem ingganna hupanna olo'-olo' yabona galantangam, la sule asam napellambi'iko anna malai tubo. ");
INSERT INTO ptu_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Anna la uhhempum ingganna la malanna diande anna mala deenna' muande sola indo ingganna olo'-olo' umpasola.” ");
INSERT INTO ptu_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Iya napogau' asammi duka' Nuh ingganna indo nasuaam Puang Allataala. ");
INSERT INTO ptu_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Tappana dadi indo kappala', ma'kadam DEBATA lako Nuh naua: “Aka anggam iko to malolo penaba dio oloku temo, dadi pentamangkoa' inde kappala' sola ingganna sahapummu. ");
INSERT INTO ptu_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","3","La umbaba pitu pasanna ingganna olo'-olo' la sipäto'na umpake menomba di Kao anna pitu duka' pasanna ingganna hupanna dassi. Sapo' olo'-olo' senga'na anggam la si sapasam umbaba anna mala ingganna hupanna olo'-olo' illaam inde lino membea' asam. ");
INSERT INTO ptu_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Aka la pitu ham benginna anna kupatuhummi uham appa' pulo allona appa' pulo benginna. Tä' deem la monda allo bengi, anna mala hopu asam ingganna menabanna, indo puha kupadadi illaam inde lino.” ");
INSERT INTO ptu_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Iya napogau' asammi Nuh situhu' indo nasuaam DEBATA. ");
INSERT INTO ptu_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Annam hatu'um taunna dadinna Nuh anna nabussui uwai inde lino. ");
INSERT INTO ptu_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Iya le'ba'im tama kappala' Nuh sola bainena, änä'na, anna manintunna anna mala tä' ia tallam. ");
INSERT INTO ptu_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","9","Tamam duka' ingganna hupanna olo'-olo' sola Nuh susinna: olo'-olo' la sipäto'na dipake menomba, olo'-olo' tää'na sipäto' dipake menomba, ingganna hupanna dassi anna olo'-olo' tissollo'na. Le'ba' asam tama indo kappala' sanda si sapasam situhu' indo nasuaam Puang Allataala Nuh. ");
INSERT INTO ptu_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","12","Tappana lambi' pitu benginna, napahandu'um tuhum uham mähämbä' anna tesse asam uwai ma'kalimbuä dio mai litä'. Appa' pulo allona appa' pulo benginna uham liu napolalam bussu uwai sampe dadi le'bo' asam inde lino. (Wattu eta too tanggala' sapulo pitu bulam dua. Anna Nuh ia annam hatu'um taunna dadinna.) ");
INSERT INTO ptu_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Tappana lambi' indo allo puha dipa'tantu, iya tama asammi ia kappala' Nuh sola bainena anna änä'na isanga Sem, Ham, anna Yafet, sola tallu manintunna. ");
INSERT INTO ptu_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Anna ingganna olo'-olo' ma'bitti' appa'na anna tissollo'na, susi manahanna teem malaihanna, sola ingganna hupanna dassi. ");
INSERT INTO ptu_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Anna ingganna hupanna olo'-olo' illaam inde lino tungga' sule sanda si sapasam umpellambi'i Nuh illaam indo kappala'. ");
INSERT INTO ptu_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Anna indo ingganna hupanna olo'-olo' tama kappala', bihäna anna lakinna situhu' pahentana Puang Allataala lako Nuh. Tappana illaam asanni, natutu'iammi DEBATA ba'bana indo kappala'. ");
INSERT INTO ptu_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","18","Appa' pulo allona appa' pulo benginna naolaam uham mahämbä' anna ma'kalimbuä uwai umbussui lino lambi' tiäkä' indo kappala' muäbä lelem yabona uwai. ");
INSERT INTO ptu_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Anna tuttuam längäm liu uwai lambi' ingganna tanete malangka' nakabu' asam uwai. ");
INSERT INTO ptu_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Längäm liu uwai sampe nalambi' sapulo lima singkum malangka'na umpellei pusu' tanete handam malangka'. ");
INSERT INTO ptu_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","23","Napasusim too Puang Allataala untallanni ingganna menabanna illaam lino, susi ingganna hupatau, susi ingganna dassi, teem ingganna olo'-olo' tissollo'na, anna olo'-olo' manahanna anna malaihanna yabona galantangam. Sapo' anggam Nuh sola ingganna issinna kappala', tä' ia tallam. ");
INSERT INTO ptu_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Iya nabussuim uwai inde lino sahatu' lima pulo benginna masäena. ");
INSERT INTO ptu_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Sapo' tä' ungkalembei Nuh Puang Allataala sola ingganna olo'-olo' malaihanna anna manahanna indo napasola illaam kappala', lambi' napasule Puang Allataala hibu' ussimbuhu'i indo uwai nasuhum napahandu'um mehe. ");
INSERT INTO ptu_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","4","Aka mondam uham anna tä'um ma'kalimbuä liu uwai dio mai litä', nasuhum tuttuam mehe uwai. Tappana sahatu' lima puloi benginna muäbä indo kappala', iya tiandanga'um yabo pusu'na tanete Ararat. Allo eta too tanggala' sapulo pitu bulam pitu. ");
INSERT INTO ptu_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Iya tahhu' lium mehe uwai lambi' tanggala' mesai bulam sapulo, silosam pole' dokko diita sanaka-naka pusu'na tanete malangka'. ");
INSERT INTO ptu_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Lessu'i appa' pulo benginna, nabukkaim Nuh indo suleba'na kappala' ");
INSERT INTO ptu_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","anna ullappa'i mesa kadoaja. Sapo' tä'um ma'pasule indo kadoaja aka lao mandam katia'-tia' lako dio mai sampe matti' uwai. ");
INSERT INTO ptu_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Iya ullappa' pole oom mesa dangam-dangam, aka la napengngissanni battu la mehe gegem uwai. ");
INSERT INTO ptu_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Sapo' indo dangam-dangam ma'pasule ia sule umpellambi'i Nuh aka tä'pi deem naongei hampo, aka inde lino nalimbäi asampi uwai. Iya umpengkandoammi limanna Nuh tama sulibam anna nahampoi indo dangam-dangam anna malai tama sule kappala'. ");
INSERT INTO ptu_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Naampai oom pitu benginna anna mane nalappa' oi indo dangam-dangam. ");
INSERT INTO ptu_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Tappana kahubenni, sulem indo dangam-dangam untoä salamba' daum zaitun mane naala. Iam too anna naissammi Nuh naua: “Mehe gegem pole' uwai.” ");
INSERT INTO ptu_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Iya naampai oom pitu benginna mane nalappa' oi indo dangam-dangam, sapo' tä'um pole' deem ma'pasule. ");
INSERT INTO ptu_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Tappana tanggala' mesai bulam mesa, iya matti' lium pole' indo uwai. (Wattu eta too annam hatu'um mesa taunna dadinna Nuh.) Nabukkaim Nuh papana indo kappala' anna kanenne'-nenne'i lao. Iya naitam mabangim galantangam. ");
INSERT INTO ptu_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Tappana tanggala' dua pulo pitui bulam dua, mabangi asammi pole' lao galantangam. ");
INSERT INTO ptu_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Pissananna ma'kadam Puang Allataala lako Nuh naua: ");
INSERT INTO ptu_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Pessubummokoa' illaam mai kappala' sola bainemu, änä'mu anna manintummu. ");
INSERT INTO ptu_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Passubunni duka' ingganna indo olo'-olo' umpasola: ingganna dassi anna ingganna hupanna olo'-olo' si yabo galantangam anna mala membea' umponnoi lino.” ");
INSERT INTO ptu_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Iya messubummi Nuh sola änä'na anna bainena anna manintunna. ");
INSERT INTO ptu_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Messubum asammi duka' indo ingganna olo'-olo' ma'bitti' appa'na sola tissollo'na anna ingganna dassi pantam ma'mesa sahhupa oi. ");
INSERT INTO ptu_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Pissananna umpasitodo'-todo'um batu Nuh naongei mehumala'. Puhai, naalam sanda si sahhupa dassi anna olo'-olo' senga' indo la sipäto'na napake menomba dio olona DEBATA anna natunui yabo indo ongeam pehumalasam, napopemala'. ");
INSERT INTO ptu_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Iya bubanau' naudu' DEBATA indo tunuam. Napolalam nadandi illaam penabanna naua: “Tä'um la kutädo inde litä' anna tä'um la kutallanni ingganna issinna inde lino kahana gau' kadakena hupatau susi inde mane puha kupogau', moinna anna kuissam kuua kadake pattuju penabanna hupatau mengkalao dio mai bahinni'na. ");
INSERT INTO ptu_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Dadi maka' tontä liupi da'da' inde lino la deem liu wattu pantanangam anna wattu pamuppusanna bua pengkähä, wattu masäkke' anna wattu makula', wattu kulla' anna palauham, allo anna bengi.” ");
INSERT INTO ptu_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Puang Allataala untamba' Nuh sola änä'na naua: “Pembea'koa' anna mala umponnoi lao lino pessubummu. ");
INSERT INTO ptu_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","La nakahea'koa' ingganna olo'-olo' inde lino susi ingganna dassi yabo lawwa, susi ingganna olo'-olo' yabo galantangam, teem olo'-olo' dio uwai. Anna la ungkuasaia' ingganna indo olo-olo' aka la kupadokkoangkoa' lisu pala'mu. ");
INSERT INTO ptu_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Ingganna menabanna mala asanna' muande sola indo to puha kubeengkoa', ingganna daungkaju anna bua kaju. ");
INSERT INTO ptu_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Sapo' anggam sahhupa tä' la mala muandea', indo olo'-olo' tää'na diäläi hahana, aka indo haha ongeanna penaba. ");
INSERT INTO ptu_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","6","Sapo' diona hahamua' la kutuntu' bala'na. Aka iai too umpatitollo hahana hupatau, la napatitollo duka' hupatau hahana; la olo'-olo' daka umpatei, la padanna siangka hupatau. Aka dipapia hupatau susi hupanna Puang Allataala. ");
INSERT INTO ptu_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Pembea' lampa'koa' anna mala umponnoi lao lino pessubummu. ");
INSERT INTO ptu_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","9","Anna la kupadeengangkoa' pa'dandiam sola ingganna pessubummu, ");
INSERT INTO ptu_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","sola ingganna olo'-olo' tubo yabona inde lino susinna: ingganna dassi anna ingganna olo'-olo' manahanna anna malaihanna, indo umpasola messubum illaam mai kappala'. ");
INSERT INTO ptu_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Indem ia pa'dandiangku: Napahandu' temo tä'um la kupabussu uwai la untallanni lino sola issinna. ");
INSERT INTO ptu_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","13","Anna la mendadi tanda pa'dandiangku lako ikoa' sule lako ingganna pessubummua' anna ingganna menabanna indo si umpasola, la si kupakende' sahihangku illaam gabum la umpotandaa' diua la tontä liu pa'dandiangku lako lino sule lako salako-lakona. ");
INSERT INTO ptu_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Dadi kupamellum oi too allo anna tindä' oom sahiha, ");
INSERT INTO ptu_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","iya kukilalai oom indo pa'dandiangku matim anna lako ingganna menabanna: indo tä'um deem la kupabussu uwai untallanni ingganna menabanna. ");
INSERT INTO ptu_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Iya kende' oi too kuita sahiha illaam gabum, kukilalai oom pa'dandiangku, indo la tontä sule lako salako-lakona lako ingganna menabanna illaam inde lino. ");
INSERT INTO ptu_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Iam too inde la mendadi tanda pa'dandiangku kupadeengam lako ingganna menabanna illaam inde lino.” ");
INSERT INTO ptu_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","19","Indem ia änä'na Nuh napasola messubum illaam mai kappala': Sem, Ham, anna Yafet. Anna iam too inde to tallu nene to naponene hupatau lako lino. Ham ia ambena Kanaan. ");
INSERT INTO ptu_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Indo Nuh mendadi mesa to si mengkähä bela'. Iam too handam yolo ma'bela' anggur. ");
INSERT INTO ptu_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Pissam wattu muihu' anggur Nuh lambi' mäbo', iya lentem-lentem bäbäm ma'kambelä illaam bahunna. ");
INSERT INTO ptu_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Muitanna ambena ma'kambelä indo Ham ambena Kanaan, tappa messubummi umpa'tulasam indo kakanna dua. ");
INSERT INTO ptu_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Sapo' indo ia Sem anna Yafet muala ia sambu' anna naballa'i yabo palempenna anna ma'saha boko'i tama bahum ussambu'i ambena indo kambelängam. Napasindum mennenne' liu lako olona indana muitai ambena kambelängam. ");
INSERT INTO ptu_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Tappana kilala Nuh, iya naissammi indo gau'na Ham änä' tämpä'na. ");
INSERT INTO ptu_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","Nasuhum ma'kada naua: “La seda ia Kanaan. La naposabua' pälli' ingganna solasubunna. ");
INSERT INTO ptu_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Dipuji sanganna DEBATA, Puang Allataala to napenombai Sem. La diposabua' di too Kanaan naposabua' Sem. ");
INSERT INTO ptu_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","La Puang Allataala hi too la umpomalobäam ongeanna Yafet anna la masannam sitadongkongam Sem. Anna Kanaan ia la mendadi sabua'na.” ");
INSERT INTO ptu_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Tallu hatu'pi lima pulo taunna tubo Nuh balinna nabussui uwai inde lino. ");
INSERT INTO ptu_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Ia ham mane matei kaseha hatu' lima pulo taunna dadinna. ");
INSERT INTO ptu_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Iya indem ia tulasanna Sem, Ham, anna Yafet: Puhanna bussu uwai, iya indo tallu änä'na Nuh pantam undadiam änä', muane. ");
INSERT INTO ptu_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Yafet undadiam Gomer, Magog, Madai, Yawan, Tubal, Mesekh, anna Tiras. ");
INSERT INTO ptu_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Anna Gomer ia undadiam Askenas, Rifat anna Togarma. ");
INSERT INTO ptu_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Yawan naongei buttu Elisa, Taris, to Kitim, anna to Dodanim. ");
INSERT INTO ptu_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Iam inde mai peänäsanna Yawan kabuttuanna to umpangngissi bihim le'bo'. Iam too inde mai peänäsanna Yafet pantam untadongkonni litä'na, tungga' deem basana, situhu' kabuttuanna si mesa-mesa. ");
INSERT INTO ptu_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Ham undadiam Kush, Mizraim, Put, anna Kanaan. ");
INSERT INTO ptu_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Kush ia undadiam Seba, Hawila, Sabta, Raema, anna Sabtekha. Anna indo Raema undadiam Syeba anna Dedan. ");
INSERT INTO ptu_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Deem änä'na Kush muane isanga Nimrod. Iam too inde tau handam yolo bahani ma'bundu' illaam lino. ");
INSERT INTO ptu_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Napasilolem DEBATA kamatittaam, nasuhum mendadi mesa to matitta moasu lambi' si naua tau: “La susi hako too Nimrod matitta dio olona DEBATA moasu.” ");
INSERT INTO ptu_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Uhuna tallu kota natomahajai Nimrod dio Sinear, isanga: Babel, Erekh, anna Akad. ");
INSERT INTO ptu_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Iam too inde appa' kota napa'pahandu'i umpakalua' kahajaanna sule lako Asyur. Dioi Asyur umpadadim appa' kota: kota Niniwe, kota Rehobot-Ir, kota Kalah, ");
INSERT INTO ptu_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","anna kota Resen dio alla'na Niniwe anna Kalah. Indo Resen mesa kota kasalle. ");
INSERT INTO ptu_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Anna Misraim ia kabuttuanna to Ludim, to Anamim, to Lehabim, to Naftuhim, ");
INSERT INTO ptu_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","to Patrusim, to Kasluhim, anna to Kaftorim. Iya to Kasluhim-mi too naongei buttu to Filistin. ");
INSERT INTO ptu_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Anna Kanaan ia undadiam Sidon, änä' uluana, anna Het sola ");
INSERT INTO ptu_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","to Yebusi, to Amori, to Girgasi ");
INSERT INTO ptu_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","to Hewi, to Arki, to Sini, ");
INSERT INTO ptu_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","to Arwadi, to Semari, anna to Hamati. Indo pessubunna Kanaan mentale lao mambela, ");
INSERT INTO ptu_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","nasuhum malobä pa'bottoanna mengkalao dio Sidon le'ba' lako tandai Gerar, sule lako Gaza, lako tandai Sodom, Gomora, Adma, Zeboim, anna sule lako Lasa. ");
INSERT INTO ptu_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Iam too pessubunna Ham. Pantam untadongkonni litä'na, tungga' deem basana, situhu' kabuttuanna si mesa-mesa. ");
INSERT INTO ptu_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Undadiam duka' änä' Sem, kakanna Yafet. Iam ia naongei messubum to Eber. ");
INSERT INTO ptu_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Sem undadiam Elam, Asyur, Arpakhsad, Lud, anna Aram. ");
INSERT INTO ptu_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Aram ia kabuttuanna to Us, to Hul, to Geter, anna to Mas. ");
INSERT INTO ptu_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Anna Arpakhsad ia undadiam Selah. Selah undadiam Eber. ");
INSERT INTO ptu_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Indo Eber undadiam dua änä' bassim muane, mesa isanga Peleg, kalembasanna titaba-taba lao, aka titaba-taba lao issinna lino eta too. Anna mesa nasangai Yoktan. ");
INSERT INTO ptu_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Indo Yoktan undadiam ia Almodad, Selef, Hazar-Mawet, Yerah, ");
INSERT INTO ptu_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Hadoram, Uzal, Dikla, ");
INSERT INTO ptu_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Obal, Abimael, Syeba, ");
INSERT INTO ptu_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Ofir, Hawila, anna Yobab. Ingganna ia too pessubunna Yoktan. ");
INSERT INTO ptu_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Indo litä' natadongkonni pessubunna Yoktan mengkalao dio Mesa, sule lako ongeam matanete isanga Sefar, dio tandai mata allo. ");
INSERT INTO ptu_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Iam too inde pessubunna Sem. Pantam untadongkonni litä'na, tungga' deem basana, situhu' kabuttuanna si mesa-mesa. ");
INSERT INTO ptu_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Susim too pessubunna änä'na Nuh situhu' pentalena lako si mesa-mesa ongeam. Anna iam too naongei mentale hupatau lako lino puhanna bussu uwai. ");
INSERT INTO ptu_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Indo eta too anggapi sahhupa basana hupatau illaam lino. ");
INSERT INTO ptu_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Pissananna deem buda tau lao umpeä ongeam dekke tandai mata allo. Ullambi'um mesa hante pappa' illaam Sinear, iya hapa'im eta. ");
INSERT INTO ptu_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","4","Ma'pattujuim naua: “Tapapiaia' mesa kota kasalle anna tapapiaia' mesa ongeam ma'eham-eham la tapakende'a' längäm langi' malangka'na anna malakia' kaissangam anna ma'mesa liu. Tapapiaa' batu tela la tapomapia lälläna, anna malai makahha'.” Iya umpapiaim batu tela sola panti' la napopampanti' mane napahandu'i napake'de'. ");
INSERT INTO ptu_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Pissananna sulem DEBATA umpetua' indo kota sola ongeam ma'eham-eham napake'de' hupatau. ");
INSERT INTO ptu_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Tappana naita DEBATA, ma'kadam naua: “Taitanna' too inde mai hupatau aka ma'mesam anna mesa basana nasuhum mala napadadi susi indee. Inde mane pa'pahandusanna hi too. Senga'um tia ke dako'um, aka iai too napattuju tä' mala tala sule lako. ");
INSERT INTO ptu_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Dadi mapia ke tapentama alla'ia' anta pasisala-salaia' basana, anna malai tä' naissam sibasa-basai.” ");
INSERT INTO ptu_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Napateemmi too DEBATA nasuhum tisembu' indo hupatau lako lino, lambi' tä'um tahhu' mengkähä umpapia mesa kota kasalle. ");
INSERT INTO ptu_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Iam too anna disangaim indo kota “Babel”, aka etam too DEBATA umpasisala-sala basana ingganna hupatau anna napasisähä'-sähä'i ussambai lao lino. ");
INSERT INTO ptu_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Susi inde tulasanna pessubunna Sem: Dua taunni puhanna bussu uwai, wattu eta too sahatu'um taunna dadinna Sem, iya undadiammi mesa muane-ane nasangai Arpakhsad. ");
INSERT INTO ptu_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Puhai undadiam Arpakhsad, tubopi lima hatu' taunna Sem anna undadiam polepi sanaka-naka änä', muane anna baine. ");
INSERT INTO ptu_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Tappana tallu pulo limai taunna dadinna Arpakhsad, undadiammi mesa muane, nasangai Selah. ");
INSERT INTO ptu_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Puhai undadiam Selah, tubopi appa' hatu' tallu taunna Arpakhsad anna undadiam polepi sanaka-naka änä', muane anna baine. ");
INSERT INTO ptu_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Tappana tallu puloi taunna dadinna Selah, undadiammi mesa muane, nasangai Eber. ");
INSERT INTO ptu_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Puhai undadiam Eber, tubopi appa' hatu' tallu taunna Selah anna undadiam polepi sanaka-naka änä', muane anna baine. ");
INSERT INTO ptu_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Tappana tallu pulo appa'i taunna Eber, undadiammi mesa muane, nasangai Peleg. ");
INSERT INTO ptu_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Puhai undadiam Peleg, tubopi appa' hatu' tallu pulo taunna Eber anna undadiam polepi sanaka-naka änä', muane anna baine. ");
INSERT INTO ptu_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Tappana tallu puloi taunna Peleg, undadiammi mesa muane, nasangai Rehu. ");
INSERT INTO ptu_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Puhai undadiam Rehu, tubopi dua hatu' kaseha taunna Peleg anna undadiam polepi sanaka-naka änä', muane anna baine. ");
INSERT INTO ptu_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Tappana tallu pulo duai taunna Rehu, undadiammi mesa muane, nasangai Serug. ");
INSERT INTO ptu_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Puhai undadiam Serug, dua hatu' pitupi taunna tubo Rehu anna undadiam polepi sanaka-naka änä', muane anna baine. ");
INSERT INTO ptu_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Tappana tallu puloi taunna Serug, undadiammi mesa muane, nasangai Nahor. ");
INSERT INTO ptu_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Puhai undadiam Nahor, dua hatu'pi taunna tubo Serug anna undadiam polepi sanaka-naka änä', muane anna baine. ");
INSERT INTO ptu_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Tappana dua pulo kasehai taunna Nahor, undadiammi mesa muane, nasangai Terah. ");
INSERT INTO ptu_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Puhai undadiam Terah, sahatu' sapulo kasehapi taunna tubo Nahor anna undadiam polepi sanaka-naka änä', muane anna baine. ");
INSERT INTO ptu_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Pitu puloi taunna dadinna Terah undadiammi muane tallu nasangai Abram, Nahor, anna Haran. ");
INSERT INTO ptu_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Susi inde tulasanna pessubunna Terah: Terah undadiam Abram, Nahor, anna Haran. Inde Haran undadiam mesa muane isanga Lot. ");
INSERT INTO ptu_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Tubopi Terah ambena Haran anna matei Haran dio kota kadadianna isanga Ur dio Kasdim. ");
INSERT INTO ptu_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Abram sipobaine Sarai anna Nahor ia sipobaine Milka, änä'na Haran anna deempi änä'na Haran muane isanga Yiska. ");
INSERT INTO ptu_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Indo Sarai tämänä. ");
INSERT INTO ptu_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Iya le'ba'um Terah umpellei kota Ur-Kasdim la lako Kanaan sola Abram änä'na anna ampona isanga Lot sola Sarai manintunna, bainena Abram. Sapo' sulei lako kota Haran, iya hapa' dio ohi. ");
INSERT INTO ptu_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Dua hatu' limai taunna dadinna Terah, iya matem dio Haran. ");
INSERT INTO ptu_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Ma'kadam DEBATA lako Abram naua: “Pelleiko banuanna ambemu, sola botto litä'mu anna sahapummu ammu lao lako ongeam la kupatuhoiangko. ");
INSERT INTO ptu_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Anna la kupabudangko pessubummu anna la kupopa'mesa. La kutamba'ko anna la kupakaleleam mapia sangammu anna la iko napolalam ditamba' tau buda. ");
INSERT INTO ptu_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","La kutamba' ingganna to umpa'lambeangko, anna la kutädo ingganna to untädoko. Anna iko napolalam la ditamba' ingganna hupatau illaam inde lino.” ");
INSERT INTO ptu_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","5","Iya mengkalaom Abram dio Haran le'ba' lako lembäna Kanaan untuhu' pepahe'na DEBATA solai Sarai bainena, anna Lot änä' uhena, anna ingganna pakkulleanna, sola ingganna sabua'na indo naala dio Haran. Wattunna anna mengkalaoi Abram dio Haran pitu pulom lima taunna dadinna. ");
INSERT INTO ptu_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Tappana sulei lako Kanaan, naolam Abram indo botto lambi' sule lako too' kaju tumalumbum ma'sanga dio More sikahuku' Sikhem. Indo ongeam napangngissipi to Kanaan wattu eta too. ");
INSERT INTO ptu_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Iya umpa'paitaammi kalena DEBATA lako Abram anna ma'kadai naua: “Iam too inde ongeam la kubeem pessubummu.” Iya napapiam Abram mesa ongeam pehumalasam längäm DEBATA to puha umpa'paitaam kalena. ");
INSERT INTO ptu_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Puhai ia too umpatahhu'um pa'laoanna lu längäm mesa ongeam tipatanetena anna mebahunni eta. Indo ongeam naongei napaitängä kota Betel anna kota Ai. Tandai katampusam ia kota Betel anna tandai mata allo ia kota Ai. Napapia toi duka' eta too ongeam pehumalasam längäm DEBATA, anna umpenombai DEBATA. ");
INSERT INTO ptu_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Dako'i, napellei oom indo ongeam anna umpatahhu' oi pa'laoanna ullelei si mesa-mesa ongeam sule lako Negeb. ");
INSERT INTO ptu_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Pissam wattu nalambi' kakobeam tau dio Kanaan tä' deem pada samasäe, napolalam le'ba' Abram messihuhu lako lembäna Mesir. ");
INSERT INTO ptu_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Tappana la ullambam katonanna lembäna Mesir, iya umpakahi'dim Sarai bainena naua: “Sarai, abana mapi'dä' hupammu. ");
INSERT INTO ptu_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Dadi maka' naitako to Mesir, tä' mala tala naua: ‘Indee bainena!’ Dadi mannassa anna la dipateiä' kao anna la dipatuboko iko. ");
INSERT INTO ptu_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Dadi dotam muua: ‘Adinnaä',’ anna malaä' dipatubo anna napakamaja tau aka iko napengngitai.” ");
INSERT INTO ptu_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Tappana si'da landa' Abram lako lembäna Mesir, iya tä' deem pada sanapemapiaam to Mesir indo Sarai. ");
INSERT INTO ptu_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Susi siam duka' sanaka-naka to kasalle illaam kahajaam, muitanna Sarai tappa le'ba' natulasam Firaun tomahaja Mesir naua: “Mapia si'da-si'da indo baine sule.” Sampe dipasola Sarai lako banuanna Firaun. ");
INSERT INTO ptu_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Tä' deem pada saumpakamaja Abram indo Firaun aka umpohäe Sarai, nasuhum dibeem Abram buda sabua' susi baine susi muane anna buda duka' domba, sapim, keledai anna unta. ");
INSERT INTO ptu_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Sapo' napalambi'i DEBATA indo Firaun ma'hupa-hupa saki mabanda' sola ingganna to illaam banuanna, aka muala Sarai bainena Abram. ");
INSERT INTO ptu_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Iya untambai siaham Abram indo Firaun anna nauaanni: “Akanna ma'pateengko? Akanna tä'i umpandanni muua: ‘Baineku hi to kao?’ ");
INSERT INTO ptu_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Akanna muua hi iko: ‘Adingku’, nasuhum kuala kao kupobaine? Alai inde bainemu ammu le'ba'a'.” ");
INSERT INTO ptu_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Iya umpahentam sanaka-naka tau indo Firaun lao muanta' Abram sola bainena anna ingganna ebanganna. ");
INSERT INTO ptu_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Iya mengkalaom Abram sola bainena anna Lot dio Mesir lu lako lembäna Negeb umbaba asam ingganna ebanganna. ");
INSERT INTO ptu_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Indo Abram tä' deem pada sasugi' aka budam olo'-olo'na sola peha'na anna bulabanna. ");
INSERT INTO ptu_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Iya le'ba'um untete mobotto-bottoam susi lembäna Negeb, teem sikahuku'na Betel indo naongei uhu-uhuna umpake'de' bahum dio alla'na Betel anna Ai. ");
INSERT INTO ptu_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","Nalambi'i indo ongeam pehumalasanna lessu', iya etam naongei Abram umpenombai DEBATA. ");
INSERT INTO ptu_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Indo Lot to napasola Abram buda duka' dombana, bekena, sapinna, anna bahunna. ");
INSERT INTO ptu_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Sapo' indo ongeam naongei, tä' sihua la naongei sola aka buda sugali' olo'-olo'na. ");
INSERT INTO ptu_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Napolalam si sipengka-pengka to ma'kambi'na Abram anna to ma'kambi'na Lot. Indo botto napangngissipi to Kanaan anna to Feris wattu eta too. ");
INSERT INTO ptu_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Iya ma'kadam Abram lako Lot naua: “Setonganna tä' mapia kela sipengkaki', anna la sipengka-pengka to ma'kambi'ta aka to mesaki'. ");
INSERT INTO ptu_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Sapo' susi indee, mapia ke sisähä'ki'. Inde ongeam taongei, beba'ki', dadi iko la umpise'i. Maka' lu lakoko iko tandai kaihi, iya la lu lakoä' kao tandai kanam. Maka' lu lakoko iko tandai kanam, iya la lu lakoä' kao tandai kaihi.” ");
INSERT INTO ptu_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Napaleleim lao matanna Lot, iya naita asammi lao lembäna Yordan tä' deem pada sabuda uwainna, sihhapam bela' DEBATA, anggasanna lembäna Mesir ke lakoi tau kota Zoar. (Wattu eta too, tä'pi natallanni DEBATA Sodom anna Gomora.) ");
INSERT INTO ptu_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Iam too anna napohäem Lot indo lembäna Yordan, nasuhum mengkalaom ia lu dekke tandai mata allo. Susim too tulasanna Abram sola Lot wattunna anna sisähä'i. ");
INSERT INTO ptu_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Iya tohho diom ia lembäna Kanaan Abram, anna Lot ia mebahum dio sikahuku' Sodom, napasindum umpasibala'-bala' kota dio lembäna Yordan. ");
INSERT INTO ptu_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Indo kota Sodom napangngissi to si angga umpogau' kakadakeam dio olona DEBATA. ");
INSERT INTO ptu_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Tappana sisähä' Lot anna Abram, ma'kadam DEBATA lako Abram naua: “Paleleii lao pali' matammu, mengkalao itim muongei ke'de'. ");
INSERT INTO ptu_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Padai too nalambi'na matammu, padam too la kubeengko sule lako pessubummu, la muampuanna' sule lako salako-lakona. ");
INSERT INTO ptu_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Anna la kupalohom banne taummu lambi' tä' deem moi podo la mesa tau la nabela muissa'i. Aka pessubummu la susi budanna sobä', tä' la dibela diissa'. ");
INSERT INTO ptu_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Laongko leleii ingganna litä' ia too, aka la kubeemmoko.” ");
INSERT INTO ptu_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Puhai ia too, mentieli'um Abram anna mebahunni dio sikahuku' too' kaju tumalumbum ma'sanga dio Mamre, sikahuku' Hebron. Iya umpapia oom eta ongeam pehumalasam längäm DEBATA. ");
INSERT INTO ptu_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Pissam wattu, deem appa' tomahaja umpamesa buku, isanga Amrafel tomahajanna Sinear, Ariokh tomahajanna Elasar, Kedorlaomer tomahajanna Elam, anna Tideal tomahajanna Goyim; ");
INSERT INTO ptu_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","Umbundu' lima tomahaja senga' isanga ia Bera tomahajanna Sodom, Birsya tomahajanna Gomora, Syinab tomahajanna Adma, Syemeber tomahajanna Zeboim, anna tomahaja dio mai Bela battu diua Zoar. ");
INSERT INTO ptu_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Padam too duka' umpamesa kalena uhhempum sohodadunna dio lembäna Sidim, indo disangaim temo Le'bo' Mässi'. ");
INSERT INTO ptu_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Sapulo duam taunna nadakka' bata' ulunna Kedorlaomer tomahajanna Elam sapo' tamai kasapulo tallunna taunna, umpamesam buku anna mangngebai. ");
INSERT INTO ptu_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Tappana mentama kasapulo appa'na taunna, ma'mesa pole oom Kedorlaomer sola indo tallu solana tomahaja anna sohodadunna, lambi' untaloi to Refaim dio Asyterot-Karnaim, to Zuzim dio Ham, to Emim dio Syawe Kiryataim, ");
INSERT INTO ptu_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","anna to Hori yabo ongeam tipatanetena isanga Seir sule lako El-Paran bihinna pohiallasam. ");
INSERT INTO ptu_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Puhai ia too, ma'pasuleim lu lako En-Mispat, indo disangaim temo Kadesy, anna umpentaloi duka' ingganna to Amalek anna to Amori to tohho dio Hazezon-Tamar. ");
INSERT INTO ptu_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Pissananna indo lima tomahaja ingngena', tomahajanna Sodom, Gomora, Adma, Zeboim anna Bela (battu diua Zoar), umpamesa buku anna mengngebai dio lembä Sidim. ");
INSERT INTO ptu_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","Umbali Kedorlaomer, tomahajanna Elam, Tideal, tomahajanna Goyim, Amrafel tomahajanna Sinear, anna Ariokh, tomahajanna Elasar. Dadi lima tomahaja mueba appa' tomahaja. ");
INSERT INTO ptu_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Indo dio lembä Sidim naongei buda hano ter. Pissananna indo tomahajanna Sodom anna Gomora napeä lalanna anna lahii umpellei pa'bundusam, sapo' buda hi mate aka lämmä' dokko indo hano ter. Anna indo malannapi lahi, lu längänni tipatanetena. ");
INSERT INTO ptu_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","12","Indo appa' tomahaja umpamesa buku ingngena', patalo ia, sampe ingganna aka-aka dio Sodom anna Gomora susi membaham-bahanna teem mengkinandena, napamuhu asam lao sola taunna. Moi duka' Lot indo änä' uhena Abram dipahhim toi sola ingganna kullena, aka tohho dio duka' Sodom. ");
INSERT INTO ptu_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Iya sule siaham mesa to malahi dio mai pa'bundusam umpa'tulasam Abram diona indo kaha-kaha puha dadi. Indo Abram mesa to Ibrani tohho dio sikahuku' too' kaju tumalumbunna Mamre mesa to Amori. Indo Mamre sola solasubunna isanga Eskol anna Aner sangngim sihondä penaba Abram. ");
INSERT INTO ptu_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Tappana naissam Abram naua: “Disakka änä' uheku,” iya mengkalao siaham umpasola änä' isalinna to mateha' ma'bundu', tallu hatu' sapulo kahua tau budanna, anna le'ba'i muula' balinna sule lako Dan. ");
INSERT INTO ptu_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Bengii, umbahe-bahem taunna Abram dio Dan anna mane ma'bundu'. Iya umpahissim lium balinna sule lako Hoba tandai lakona Damsyik. ");
INSERT INTO ptu_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Sampe naala asam sule Abram indo ingganna kulle dipamuhu, duka' Lot indo änä' uhena, sola ingganna kullena anna ingganna baine sola tau senga'. ");
INSERT INTO ptu_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Puhai untaloi Kedorlaomer sola solana, ma'pasulem Abram. Iya le'ba'um tomahajanna Sodom natammui lako lembäna Syawe, si biasa diuaam Lembäna Tomahaja. ");
INSERT INTO ptu_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Susi duka' Melkisedek tomahajanna Salem mesa sandona Puang Allataala To handam matande le'ba' umbabaam hoti sola anggur Abram. ");
INSERT INTO ptu_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Anna indo Melkisedek umpa'lambeam Abram naua: “La natamba' dako too Puang Allataala To handam matande To umpadadi langi' anna lino. ");
INSERT INTO ptu_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Anna dipa'kasallei sanganna Puang Allataala To handam matande aka puhangko nabeem kapataloam.” Iya naalam Abram indo baham-baham pamuhunna Kedorlaomer anna napehumalasanni bahe sapulona nabeem Melkisedek. ");
INSERT INTO ptu_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Iya ma'kadam ia tomahajanna Sodom lako Abram naua: “Ala asammi tiko itim membaham-bahanna, sapo' kela mala anna umbeem asannä' ia sule ingganna hupataungku.” ");
INSERT INTO ptu_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Sapo' natimba' Abram naua: “Ma'pindaä' dio olona Puang Allataala DEBATAngku To handam matande, anna To umpadadi langi' anna lino, ");
INSERT INTO ptu_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","moi la dahum suppi tala kualai kullemu dapaka ia la baham-baham senga'. Aka indana muuai: ‘Kao hi to kao anna to makakai Abram.’ ");
INSERT INTO ptu_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Dadi, tä' kao deem la kuala. Tengkanammi ia indo puhannam naande änä'-änä'ku. Sapo' lu lakona solaku Aner, Eskol, anna Mamre, päbäi mammi ia naala tabana.” ");
INSERT INTO ptu_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Puhai ia too, iya nalipim DEBATA Abram anna napa'tula'i naua: “Daa ummahea' Abram, aka Kao la umpa'tippasangko anna la kubeengko mana' kasalle.” ");
INSERT INTO ptu_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","3","Sapo' natimba' Abram naua: “O Puang Allataala DEBATAngku, aka gunana la umbeennä' mana' ke tä'i deem änä'ku? Aka tä'pä' umbeem änä', dadi inde mai kulle puha umbeennä', indo hi tia sabua'ku Eliezer to Damsyik la umpomana'i.” ");
INSERT INTO ptu_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Natimba' DEBATA naua: “Taia sabua'mu la umpomana' kullemu, sapo' änä' ikalemu.” ");
INSERT INTO ptu_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Iya umpasolam messubum Abram anna nauaanni: “Pentongako längäm langi' anna uhhekengko bintä, ke umbelai. Aka padai too budanna bintä, la padam too duka' budanna pessubummu.” ");
INSERT INTO ptu_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Iya ungkatappa'im DEBATA Abram nasuhum nasangai DEBATA to malolo. ");
INSERT INTO ptu_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Mane ma'kada polei DEBATA naua: “Kaom too untässu'iko illaam mai Ur-Kasdim botto litä'mu anna kutetteko sule eta inde pa'bottoam aka la umpomana'.” ");
INSERT INTO ptu_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Natimba' Abram naua: “O Puang Allataala DEBATAngku, la kuaka susi anna mala kuissam kuua inde litä' la kupomana'?” ");
INSERT INTO ptu_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Natimba' DEBATA naua: “Alaannä' mesa sapim bihä, mesa beke bihä, anna mesa beke laki sapo' la sangngim tallu taummi dadinna. Anna mesapi duka' bukku' sola mesa dangam-dangam sapo' mangnguhannapi.” ");
INSERT INTO ptu_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Iya naalaammi Abram DEBATA ingganna indo olo'-olo'. Iya sangngim naseseannim, anna napaokko'i napadua bahhi' napasisabaliam. Anggam indo bukku' sola dangam-dangam tä' ia naseseanni. ");
INSERT INTO ptu_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Tappa sule siaham buda dassi to peande bale uhhampoi indo bale sapo' nahambai Abram. ");
INSERT INTO ptu_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Tappana la lendu'i allo, tikahu'du'um Abram sampe limpe' mamma'. Pissananna ham tä' deem pada sakähhä bulunna. ");
INSERT INTO ptu_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Iya ma'kadam DEBATA lako Abram naua: “Indem ia pahallu la umpengngissanni: pessubummu la mendadi to sule dio botto senga', la diposabua' anna la ullambi' pandahhaam appa' hatu' taunna masäena. ");
INSERT INTO ptu_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Anggam ia ke messubummi la buda kullena pa'botto nababa. Anna indo to la umposabua'i, la nalambi' duka' pesämbä'ku. ");
INSERT INTO ptu_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Sapo' iko-iko la mahendengko anna la ussi'dim kamasannangam sule lako matemu. ");
INSERT INTO ptu_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Anna la appa'pi too lapi'na pessubummu dio botto ia too, mane ma'pasulei sule eta inde. Aka etapi mane nalambi'i to Amori pesämbä'ku, aka la lempam polem kakadakeam napogau' illaam inde botto la naongei pessubummu.” ");
INSERT INTO ptu_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Tappana bengi anna malillim pättäm, iya diitam ongeam api pehambu anna ballo ma'lao-lao illaam alla'na indo bale. ");
INSERT INTO ptu_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Allo eta siam duka' anna umpadadii pa'dandiam DEBATA lako Abram naua: “Ingganna inde litä' la kubeem pessubummu mengkalao dio salunna Mesir sule lako salu Efrat. ");
INSERT INTO ptu_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","21","Nakala'pi litä'na to Keni, to Kenas, to Kadmon, to Het, to Feris, to Refaim, to Amori, to Kanaan, to Girgasi, anna to Yebus.” ");
INSERT INTO ptu_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Indo bainena Abram isanga Sarai tä' liupi keänä'. Sapo' deem mesa sabua'na isanga Hagar to Mesir, ");
INSERT INTO ptu_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","iya ma'kadam Sarai lako muanena naua: “Muissammi muua tä' dio pala'ku la keänä' aka tä' nabeennä' DEBATA. Dadi pobainei indo sabua'ku umba ke keänä'i anna mala deem änä'ku.” Iya untuhu'im duka' pattujunna Sarai Abram. ");
INSERT INTO ptu_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Naalam Sarai indo to Mesir, sabua'na isanga Hagar anna nabeenni muanena napobaine. Wattu eta too, sapulom taunna tohho Abram dio lembäna Kanaan. ");
INSERT INTO ptu_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Tappana sola metindo Abram anna Hagar, iya kebättäm. Naissanni Hagar naua: “Kebättämä',” iya napahandu'um malangka' penaba lako Sarai, puäna. ");
INSERT INTO ptu_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Iya ma'kadam Sarai lako Abram naua: “Inde kamapi'disangku, iko kasuhunganna. Aka kao umpadokkoangko lisu pala'mu inde sabua'ku, sapo' mane naissam Hagar naua: ‘Kebättää',’ anna napa'bahinni'imä'. Sapo' DEBATA ham la umpopa'tadongkonganni inde alla' tapoalla'.” ");
INSERT INTO ptu_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Tappa natimba' Abram naua: “Inde sabua'mu, iko ungkuasai. Iai too masannanna penabammu iam too la umpogausam.” Napolalam napakapi'di' Sarai indo Hagar lambi' le'ba' muäläi kalena. ");
INSERT INTO ptu_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Iya napellambi'im malaika'na DEBATA dio sikahuku' kalimbuä dio pohiallasam, lalam lako Sur. ");
INSERT INTO ptu_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Anna nauaanni: “O Hagar, sabua'na Sarai, buttu umbako ngei anna la lu umbako ngei?” Natimba' naua: “Laoä' mälläi umpellei puäku Sarai.” ");
INSERT INTO ptu_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Iya natimba'um malaika'na DEBATA naua: “Pa'pasuleko lako puämu sule ammu beho kalemu lako. ");
INSERT INTO ptu_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Aka Kao la umpalohom banne taummu, lambi' tä' pole la dibela dihekem tanda budanna. ");
INSERT INTO ptu_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Iko kebättängko. Anna tä'um la masäe anna undadiammoko mesa muane-ane. Anna la ussangai Ismael, aka nahingngiam DEBATA pengkaloa'mu. ");
INSERT INTO ptu_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Sapo' indo änä'mu la susi keledai malaiha. La sipobali asam ingganna hupatau, anna ingganna sahapunna.” ");
INSERT INTO ptu_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Puhanna napa'kadai DEBATA, mekutanam illaam penabanna Hagar naua: “Tappa' si'da-sia haka kuita indo To si meita?” Nasuhum ussangai DEBATA: Iko Puang Allataala To si meita. ");
INSERT INTO ptu_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Iam too anna nasangaim tau indo bujum dio alla'na Kadesy anna Bered, bujum Lahai-Roi (kalembasanna: bujum To tubo To si muitaä'). ");
INSERT INTO ptu_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Tappana undadianganni Abram änä' muane-ane indo Hagar, iya nasangaim Abram, Ismael. ");
INSERT INTO ptu_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Kahua pulo annam taunna dadinna Abram anna nadadianganni Hagar Ismael. ");
INSERT INTO ptu_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Tappana kaseha pulona kaseha taunna dadinna Abram, iya umpa'paitaammi kalena DEBATA lako Abram naua: “Kaom too Puang Allataala To Handam Kuasa. La manuhu'ko di Kao anna la tä' deem sassaammu. ");
INSERT INTO ptu_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","La kupadeem mesa pa'dandiam illaam alla'ta, anna la kupalohom banne taummu.” ");
INSERT INTO ptu_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Lambi' menomba Abram, iya ma'battakada pole oom Puang Allataala naua: ");
INSERT INTO ptu_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“Indem ia pa'dandiangku matim: la mendadiko pentoosanna hupatau to la umpangngissi lao mobotto-bottoam. ");
INSERT INTO ptu_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Dadi mengkalao temo tä'ungko la disangai Abram sapo' la disangaingko Abraham. Aka la kupadadiko pentoosanna hupatau to la umpangngissi lao mobotto-bottoam. ");
INSERT INTO ptu_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Anna la kupalohom banne taummu to la umpangngissi lao mobotto-bottoam, anna la buda mendadi tomahaja. ");
INSERT INTO ptu_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Dadi la kupadeem pa'dandiangku illaam alla'ta mengkalao iko sule lako pessubummu la tontä sule lako salako-lakona. Anna Kao Debatammu mengkalao iko sule lako pessubummu. ");
INSERT INTO ptu_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Aka inde dio mai to messihuhupoko illaam inde litä', sapo' kubeemmokoa' temo mengkalao iko sule lako pessubummu. Ingganna lembäna Kanaan la muampuanna' sule lako salako-lakona; anna Kao Debatanna pessubummu. ");
INSERT INTO ptu_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Anna napahandu' iko la pahallu muanda'i anna umpalako pa'dandiangku sule lako ingganna pessubummu. ");
INSERT INTO ptu_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","11","Anna la mendadi tanda pa'dandiangku, la pahallu umpogau'a' mengkalao iko sule lako pessubummu: ingganna muane la disunna'. Aka la mendadi tanda pa'dandiam illaam alla'ta. ");
INSERT INTO ptu_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Dadi kahuanna too benginna subunna änä'-änä' ke muanei, pahallum disunna'; susi änä'-änä' subum illaam banuammu susi sabua' mualli lako to sulibam, moi anna taia pessubummu. La dipateem lium too lako pada lapi'na pessubummu. ");
INSERT INTO ptu_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Susi änä' undadianna', susi änä' pangngallimmua', sangngim pahallu disunna' anna mala mendadi tanda lako balemua' pa'dandiangku sule lako salako-lakona. ");
INSERT INTO ptu_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Sapo' ingganna muane to tä' disunna' pahallu la muäläia' lao illaam mai alla'-alla'mu, aka tau ia too untekka pa'dandiangku.” ");
INSERT INTO ptu_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Mane ma'kada polei Puang Allataala lako Abraham naua: “Diona bainemu Sarai, tä'um la ussangai Sarai sapo' la disangaim Sara. ");
INSERT INTO ptu_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","La kutamba' lambi' undadiam mesa muane-ane la kubeengko. Anna la ia mendadi indona hupatau to la umpangngissi lao mobotto-bottoam. Anna la buda mendadi tomahaja pessubunna.” ");
INSERT INTO ptu_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Iya menombam Abraham napasindum metaba anna ma'kadai illaam penabanna naua: “La malapaka tia keänä' tau ke sahatu'um taunna? La malapaka tia keänä' Sara aka kaseha pulom taunna?” ");
INSERT INTO ptu_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Ma'kadam Abraham lako Puang Allataala naua: “Kela mala anna Ismael-i untahima mana'.” ");
INSERT INTO ptu_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Sapo' natimba' Puang Allataala naua: “Tää', aka bainemu hia Sara la undadiangangko mesa muane-ane anna la ussangai Ishak. Ia la kubeem pa'dandiangku anna la tahhu' liu lako pessubunna. ");
INSERT INTO ptu_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Anna diona Ismael la kuhingngiam duka' pelauammu. La kutamba' anna la kupabuda pessubunna anna la undadiam sapulo dua to ma'indo anna la kupadadi mesa kapahentaam kasalle. ");
INSERT INTO ptu_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Sapo' pa'dandiangku la lu lako hi tia Ishak indo to la nadadiangangko Sara ke taum polei, katenanna inde.” ");
INSERT INTO ptu_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Puhai ma'tula', iya le'ba'um Puang Allataala umpellei Abraham. ");
INSERT INTO ptu_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Puhanna ia too, allo eta siam untambaim änä'na Abraham isanga Ismael sola ingganna muane illaam banuanna, susi to subum illaam banuanna teem to naalli; anna nasunna' asanni, situhu' pahentana Puang Allataala. ");
INSERT INTO ptu_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Kaseha pulo kaseham taunna dadinna Abraham anna disunna'i. ");
INSERT INTO ptu_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","Anna Ismael ia, änä'na Abraham, sapulo tallum ia taunna. ");
INSERT INTO ptu_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Allo etam too anna disunna'i Abraham sola Ismael änä'na. ");
INSERT INTO ptu_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","Anna ingganna tau to subum illaam banuanna Abraham sola ingganna to naalli lako to sulibam, pada-pada sangngim disunna' sola Abraham. ");
INSERT INTO ptu_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Pissam wattu umpa'patandaam oom kalena DEBATA lako Abraham dio too' kaju tumalumbum ma'sanga dio Mamre. Eta too mahassam muokko' Abraham dio olo bahunna kalaoanna mapana' allo. ");
INSERT INTO ptu_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Tappana umbangonganni ulunna, iya naitam tallu tau ke'de'-ke'de' di olona. Tappana nakalesoi indo tau, kumondä siaham umpellei ba'ba bahunna anna lakoi olona ma'balinguntu' menomba. ");
INSERT INTO ptu_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","Anna ma'kadai naua: “Oa' puäku, kela mala ungkamaseiä', tä'koa' la melolo bäbä umpenggulebanni inde sabua'mua'. ");
INSERT INTO ptu_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","La dialaangkoa' uwai saidi' umbaseiam bitti'mu anna muokko'koa' mellube dio inde too' kaju. ");
INSERT INTO ptu_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","La kualapi hoti saidi' muandea' anna malakoa' maläppu' umpatahhu' pa'laoammu, aka sulekoa' inde ongeanna sabua'mu.” Natimba'um naua: “Pateemmi too, situhu' pa'elo'mu.” ");
INSERT INTO ptu_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Tappa le'ba' siaham Abraham tama bahunna umpellambi'i Sara anna nauaanni: “Kandi'i muala tappum setangnga lambusam anna ungkahesse'i umpapia hoti.” ");
INSERT INTO ptu_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Mane lumumpa'i Abraham lako ongeam sapinna anna umpise'i änä' sapim handam malompona anna nabeenni sabua'na nakandi'i natunu. ");
INSERT INTO ptu_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Puhai ia too, mualam bumbungam makko sola bumbungam la diihu' anna indo bale sapim anna napessohängänni dio olona indo tosabena. Anna ke'de'i Abraham dio indo too' kaju sikahuku' tosabena mahassam mangngande. ");
INSERT INTO ptu_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Puhai mangngande, ma'kadam lako Abraham naua: “Umbam Sara bainemu?” Natimba'im naua: “Illaam bahum.” ");
INSERT INTO ptu_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Iya ma'kadam naua: “Setonganna la sule oä' taum pole katenanna inde umpellambi'iko, anna wattu eta too, la keänä'um bainemu Sara, mesa muane-ane.” Sapo' nahingngi siam Sara dio ba'ba napemboko'i indo tosabe. ");
INSERT INTO ptu_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Indo Sara sola Abraham bassim matusse'um, anna Sara ia yabo palempäm. ");
INSERT INTO ptu_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Iya tappa metaba Sara aka naua illaam inabanna: “La deempaka tia kende' kamohäeam lako muane inde susim kamatuaangku? Anna muaneku duka' matusse'um.” ");
INSERT INTO ptu_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Ma'kada pole oom DEBATA lako Abraham naua: “Akanna metabai Sara napasindum naua illaam penabanna: ‘La malapakä' to kao keänä' inde yabo palempämä'?’ ");
INSERT INTO ptu_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Ingganna-ingganna sia tä' deem nakapusa'i DEBATA. Taum pole la suleä' umpellambi'iko anna wattu etam too la deemmi änä'na Sara muane-ane.” ");
INSERT INTO ptu_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Sapo' ma'baho Sara naua: “Tä' deem metabaä',” aka mahea'. Sapo' ma'kada DEBATA naua: “Ä, metaba siangko toda'.” ");
INSERT INTO ptu_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Iya ke'de'im indo tau anna mengkalaoi anna ma'pahandanni dokko Sodom. Iya natuhu'um Abraham lao naanta'. ");
INSERT INTO ptu_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Ma'pikki'um DEBATA naua: “La kubuniangam daka Abraham inde la kupogau'? ");
INSERT INTO ptu_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Tää', aka Abraham la bu'dä' pessubunna anna la pataloam. Anna ia napolalam la ditamba' ingganna hupatau. ");
INSERT INTO ptu_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Aka Kao puha umpilei anna mala napepaondongam lako ingganna pandadianna anna ingganna pessubunna la tontä liu ma'pogau' situhu' pa'elo'na DEBATA illaam umpogau' kamapiaam anna kamaloloam anna mala kuponnoi, aka puha kudandi lako Abraham.” ");
INSERT INTO ptu_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Puhai ia too ma'kadam DEBATA naua: “Budam pengkaloa'na tau diona Sodom sola Gomora, aka setonganna tä' deem pada samabanda' dosana. ");
INSERT INTO ptu_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","La lao kupetua' tappa' si'da manii susi gau'na situhu' indo pengkaloa'na tau sule längäm oloku. La kupengngissanni tappa' si'da haka tä' daka?” ");
INSERT INTO ptu_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Iya menggihi'um indo dua to napasola DEBATA anna le'ba'i lu dokko Sodom. Sapo' ke'de'-ke'de' liupi ia Abraham untingngajoi DEBATA. ");
INSERT INTO ptu_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Mengkahuku'um Abraham lako DEBATA anna mekutanai naua: “La umpempa'deam dakoka to malolo sola to kadake gau'? ");
INSERT INTO ptu_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Maaka ke hapam deempi lima pulo to malolo illaam indo kota, la untallanni siangka indo ongeam? Tä' daka la umpengngitai indo to lima pulo anna malai tä' dipempa'deam indo kota? ");
INSERT INTO ptu_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Tä' di too la nalambi' penabammu, DEBATA, la umpempa'deam to malolo sola-sola to kadake gau', indana angga' tontä bäbäm to mapia gau' anna to kadake gau'. Sapo' naua inabangku inna tä' siangko la ma'pogau' susi. Aka To Mahhotto'nako to lino tä' umpalako ke taiai malolona muundu'.” ");
INSERT INTO ptu_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Natimba' DEBATA naua: “Maka' deem kulambi' lima pulo to malolo gau' illaam Sodom, iya tä' la kutallanni aka ia la kupengngitai.” ");
INSERT INTO ptu_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Ma'kada pole oom Abraham naua: “Setonganna umpobahaniä' kaleku ma'tula' matim Debata moi anna kao indee sobä'ä' anna täiabu. ");
INSERT INTO ptu_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Pissananna ke kuhänni lima tau; anggam appa' pulo lima to malolo gau'. La untallanni siangka indo ongeam aka kuhämmi lima tau?” Natimba' naua: “Tä' la kutallanni ke kulambi'i appa' pulo lima to malolo gau' illaam Sodom.” ");
INSERT INTO ptu_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Mekutana pole oom Abraham naua: “Anna ke anggam appa' pulo?” Natimba' naua: “Tä' liupi la kutallanni aka indo to appa' pulo la kupengngitai.” ");
INSERT INTO ptu_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Naua pole oom Abraham: “O Debata, tä'ko la keaha' aka la mekutana polepä' pissam: Anna ke anggam tallu pulo to malolo dio?” Natimba' naua: “Tä' la kutallanni ke deenni tallu pulo.” ");
INSERT INTO ptu_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Ma'kada oom Abraham naua: “Setonganna Debata la umpobahani polepä' kaleku mekutana matim: Anna ke deenni dua pulo?” Natimba' naua: “Tä' la kutallanni ke deenni dua pulo.” ");
INSERT INTO ptu_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Naua pole oom Abraham: “Kela mala tä'ko la keaha' Debata, aka la mekutana polepä' pissam: Anna ke anggam sapulo to malolo gau' dio, la untallanni siangka?” Natimba' DEBATA naua: “Tä' la kutallanni ke deenni kulambi' sapulo to malolo gau' dio.” ");
INSERT INTO ptu_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Puhai ma'tula' lako Abraham, iya le'ba'um DEBATA anna ma'pasule ia Abraham lako ongeanna. ");
INSERT INTO ptu_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Tappana mahammo, iya landa'um indo dua malaika' dio kota Sodom. Siampu' eta too mahassam ma'oko'-oko' Lot dio ba'bana kota Sodom. Naitanna sia indo malaika' tappa ke'de' siahanni natammui anna ma'balinguntu'i menomba. ");
INSERT INTO ptu_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","Mane ma'kadai naua: “Kela malaa' puäku anna lempängkia' lako banuangku, baseingkoa' bitti'mu ammu pa'bengia'. Makale'pa mebengngi' mane untahhusangkoa' pa'laoammu.” Sapo' natimba' naua: “Damom, päbäim too ma'bengi lakokam inde pa'hanteam illaam tängä kota.” ");
INSERT INTO ptu_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Sapo' nakekke' liu Lot, nasuhum lempä lako banuanna. Iya napapiaammi pangngandeam mapia anna nagahaganni hoti takebibi' napandeam. ");
INSERT INTO ptu_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Tappana la mamma' kalei, iya tibombommi sule to Sodom, mengkalao dio änä' gassim sule lako tomatua muane ullebo banuanna Lot. ");
INSERT INTO ptu_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Anna sikatambai naua: “Umbam indo muane sule bengi itim banuammu Lot? Lappasangangkam mai aka la kibobo' kipasola metindo.” ");
INSERT INTO ptu_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Sapo' messubum siaham Lot napasindum ungkahabe' sule tutu' ba'ba anna ma'kadai naua: ");
INSERT INTO ptu_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","“Oa' solasubum, kamaseiä' daa umpogau'a' gau' kadake. ");
INSERT INTO ptu_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Dotam tia inde dua änä'ku baine mualaa', moi anna tä'pi deem lako muane. Sapo' päbäi bäbäm too ia kubeengkoa', anna ia mammoa' umpogausam anna ia, la mapiannaa' inabammu. Assala'na tä'koa' untumbu inde tosabeku aka tamahamu' illaam banuangku, iya kao ungkonai.” ");
INSERT INTO ptu_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Sapo' natimba' naua: “Päläiko lao Lot! Akanna iko to sule la meäto' pole? Maka' tä'ko le'ba', la kidahha puhako iko anna itim tau dua illaam banuammu.” Lambi' tuttuam umbussum Lot, anna la uhhubä'i ba'ba. ");
INSERT INTO ptu_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Sapo' bassim uhhuntu' Lot tama banua indo tosabe dua mane untutu'i ba'ba. ");
INSERT INTO ptu_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Anna mane umpabuta asam matanna indo tau dio olo ba'ba mengkalao to mangnguha sule lako tomatua, nasuhum sikasapu pole' umpeä ba'ba sapo' tä'um mala nalambi'. ");
INSERT INTO ptu_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Mane ma'kadai indo malaika' lako Lot naua: “Deempaka kasahapuammu inde, susinna manintummu haka, änä'mu haka muane, änä'mu haka baine; iya kasahapuam senga'mu haka illaam inde kota? Babai asanni le'ba' messubum illaam mai inde ongeam. ");
INSERT INTO ptu_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","Aka inde ongeam la kitallanni, aka makambammi gau' kadakena, sampe kende'um längäm olona DEBATA pengkaloa'na tau buda, nasuhum nasuakam sule DEBATA la untallanni inde ongeam.” ");
INSERT INTO ptu_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Iya le'ba' siaham Lot umpellambi'i indo dua tunanganna änä'na, anna nauaanni: “Pasihha'ia' mai anta le'ba'a' aka inde kota la natallanni DEBATA.” Sapo' nasanga hia indo dua tunanganna änä'na napaningoi. ");
INSERT INTO ptu_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Tappana tibukka'i baja, iya unggegannim Lot indo dua malaika', naua: “Pasihha'i bangom ammu pengkalao siahanna'! Le'ba'koa' sola bainemu anna itim dua änä'mu baine indena, indana dappo' sahapukoa' natumä gau' pepahitanna issinna inde kota.” ");
INSERT INTO ptu_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Sapo' bahakäpäm bäbä Lot nasuhum maela' mengkalao, lambi' naanda'im malaika' limanna sola bainena anna indo änä'na, natette sule lako sulibam kota, aka nakamasei DEBATA. ");
INSERT INTO ptu_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Iya messubunna illaam mai indo kota, ma'kada siaham indo mesa malaika' naua: “Lumpa'koa' lao indana matekoa', sapo' daa umpessaile anna daa untohhoa' dio tipalembäna. Sapo' tahhu' längäm liukoa' tipatanetena indana dappo' sahapukoa'.” ");
INSERT INTO ptu_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Sapo' natimba' Lot naua: “Ui le puäku, kela mala anna tä'kam ussua längäm tanete. ");
INSERT INTO ptu_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Abana puhamä' ungkamasei anna sumpu pa'kamasemu lako kaleku lambi' umpesäkäiä'. Sapo' aka inde yabo tanete umpassuaiä' mambela sugali', iya tä' ahamä' landa' längäm anna nalambi'mä' indo katilakaam, iya la mate siamä'. ");
INSERT INTO ptu_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Illaammi mesa kota bahinni', mahuku' siapi ia. Mala haka ke lu etangkam, anna malakam nasala kamateam?” ");
INSERT INTO ptu_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Iya natimba'um indo malaika' naua: “Io, la susim too kupatiolai pelauammu. Tä'um ia la kutallanni illaam kota bahinni'. ");
INSERT INTO ptu_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Pasihha'i lao aka tä'ä' mala ma'pogau' ke tä'ko landa' dekke.” Indo kota natuho Lot mesa kota bahinni', iam too anna disangaim Zoar. ");
INSERT INTO ptu_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Iya buttum allo anna landa'i Lot lako Zoar. ");
INSERT INTO ptu_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Tapakala, iya tibuloso siaham uba' susi mala'bu' sitonda api yabo mai langi' napatuhum DEBATA muä'bäi Sodom anna Gomora. ");
INSERT INTO ptu_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Nasuhum indo dua kota anna ingganna issinna lembä ia too dadi täiabu sule lako tanangam. ");
INSERT INTO ptu_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Sapo' messaile ohi ia indo bainena Lot, iya ke'de'-ke'de' ia dadi sia. ");
INSERT INTO ptu_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Mebengngi'-bengngi'i, le'ba' siaham Abraham lako indo ongeam naongei ke'de' sitingngajo DEBATA isamai', ");
INSERT INTO ptu_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","anna ma'pahandanni lako lembäna Sodom anna Gomora. Iya naitam tumbum hambu sondä' langi' sihhapam buttu dio mai dapo' kasalle. ");
INSERT INTO ptu_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Susim too wattunna anna natallannii Puang Allataala ingganna kota dio lembä ia too. Nahingngiam Puang Allataala pelauanna Abraham, napolalam untässu'i Lot dio mai katallanganna indo kota naongei. ");
INSERT INTO ptu_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Sapo' aka indo Lot mahea' tohho dio Zoar, nasuhum umbabai indo dua änä'na baine le'ba' längäm tipatanetena, anna tohhoi illaam mesa leä. ");
INSERT INTO ptu_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Pissam wattu, indo änä' uluana umpa'tula'i adinna naua: “Inde ambeta matuam, anna tä'um deem muane inde illaam pa'lembängam la tapomuane anna malaki' keänä'. ");
INSERT INTO ptu_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Dadi tapamäbo'i inde ambeta anna metindoki' sola anna mala deem ullombungam pessubunna ambeta.” ");
INSERT INTO ptu_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Tappana bengi, iya umbeemmi anggur ambena naihu'. Pissananna mamma'i, napengngoli'im indo änä' uluana sapo' indo ambena mäbo', nasuhum tä' deem nakilalai indo mahassam napogau'. ");
INSERT INTO ptu_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Masiäi, umpa'tula'im adinna naua: “Sabengi balimä' kao metindo sola ambe'. Maka' manii bengi, tapamäbo' polei anna metindoko iko duka' sola anna mala deem ullombungam pessubunna ambeta.” ");
INSERT INTO ptu_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Tappana bengi polei, iya napamäbo' oom anna indo opi adinna metindo sola, sapo' indo Lot mäbo' sampe tä' deem nakilalai aka napogau'. ");
INSERT INTO ptu_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Susim too anna bassim kebättäi indo baine, nakebättäi Lot, ambena. ");
INSERT INTO ptu_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Pissananna keänä' indo kakanna, iya dadi muane-ane nasangaim Moab. Iam too nene kabuttuanna to Moab sule lako temo. ");
INSERT INTO ptu_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Anna keänä' toi duka' indo adinna, iya muane duka', nasangaim ia Ben-Ami. Iya iam ia nene kabuttuanna to Amon sule lako temo. ");
INSERT INTO ptu_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Iya mengkalaom Abraham le'ba' lako lembäna Negeb anna tohhoi dio alla'na Kadesy anna Syur. Iya hapa' diom Gerar Abraham messihuhu. ");
INSERT INTO ptu_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Indo anna dioi Gerar, ma'tula' Abraham lako tau diona Sara bainena naua: “Indee solasubungku.” Nasuhum Abimelekh tomahaja dio Gerar umpopeala Sara. ");
INSERT INTO ptu_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Sapo' tappana bengi, iya sulem Puang Allataala illaam pangngimpi umpellambi'i Abimelekh anna ma'kadai naua: “Tä' mala tala mateko, aka mualako itim baine anna to kemuanem tia.” ");
INSERT INTO ptu_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Sapo' indo Abimelekh tadeempi uhhumbu-humbu Sara napolalam ma'kada naua: “O Debata la umpatei hakoka tiko hupataummu to tä' kasalaam, ");
INSERT INTO ptu_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","aka indo hi tia Abraham muuaannä': ‘Solasubungku,’ anna indo duka' baine muuaannä': ‘Solasubungku.’ Dadi inde kupogau' buttu di unä' penaba mapia anna pattuju malolo, aka kusanga tappa' tula'na.” ");
INSERT INTO ptu_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Iya natimba'um Puang Allataala illaam pangngimpi naua: “Io, abana kuissam kuua inde umpogau' buttu di unä' penaba mapia, nasuhum kulabaiko indana umpogau'ko dosa lako kaleku. Iya iam too anna tä'ungko kupäbäi la uhhumbu-humbu itim baine. ");
INSERT INTO ptu_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Dadi temo, itim baine pasuleanni lako muanena. Aka indo muanena mesa nabi, la napa'sambajangangko indana mateko. Sapo' angga hia, ke tä'i umpasuleam tä' mala tala mateko sola ingganna hupataummu.” ");
INSERT INTO ptu_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Tappana mebengngi', milli'na sia Abimelekh, untambai siahanni ingganna sabua'na anna natulasanni indo ingganna kada napalosaiam Puang Allataala illaam pangngimpi sabengi, lambi' sangngim tinggi'gi' mahea'. ");
INSERT INTO ptu_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Puhai ia too, iya untambaim Abraham indo Abimelekh anna nakutanai naua: “Aka isanga umpogausangkam? Aka kasalaangku matim nasuhum la umpaalaiä' kasalaam kasalle anna la ullambanni pakketauangku? Tä' sugali' sihatam la umpateennä'. ");
INSERT INTO ptu_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Aka pattujummu anna umpateenni?” ");
INSERT INTO ptu_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Iya natimba'um Abraham naua: “Aka kupenaba-nabaam kuua tä' manii si ungkahea' Puang Allataala tau illaam inde pa'bottoam, iya la napateimä' too ke deenni to umpohäe baineku. ");
INSERT INTO ptu_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Mane deenni, abana solasubum si'da hakam tia, aka sola ambekam sapo' tä'kam sola indo, sapo' sialangkam. ");
INSERT INTO ptu_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Tappana umpelleiä' banuanna ambeku anna laoä' ma'lele-lele lako botto senga', iya kuuaammi inde baineku: Maka' ungkaha'iä', la si muua ke deenni tasilambisam: ‘Indee solasubungku.’” ");
INSERT INTO ptu_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Iya napasulem Abimelekh indo Sara lako Abraham anna napasibeempi sanaka-naka sabua'na baine anna muane, anna domba sola sapim. ");
INSERT INTO ptu_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Anna mane nauai Abimelekh lako Abraham: “Illaam inde pa'bottoangku, beba'ko umpise'i ongeam la umpohäena.” ");
INSERT INTO ptu_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Anna mane naua lako Sara: “Puham kubeem solasubummu sasa'bu doi' peha', kamannassaanna lako tau tä'ko deem ma'gau' sala.” ");
INSERT INTO ptu_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Puhai ia too, ma'sambajammi Abraham längäm Puang Allataala lambi' bono' siaham Abimelekh anna bainena sola sabua'na nasuhum malam sule keänä'. ");
INSERT INTO ptu_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","Aka ingngena'na napatämänä asam DEBATA ingganna baine illaam banuanna Abimelekh kahana Sara, bainena Abraham. ");
INSERT INTO ptu_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Indo Sara, nakamasei anna natamba' DEBATA umba susi puha nadandi. ");
INSERT INTO ptu_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Tappana matuai Abraham, iya lambi'um duka' pa'dandianna Puang Allataala illaam indo wattu puha napa'tantu. Napolalam kebättä Sara anna undadianganni Abraham mesa muane-ane. ");
INSERT INTO ptu_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Iya nasangaim Abraham Ishak. ");
INSERT INTO ptu_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Tappana kahua benginna dadinna Ishak, iya nasunna'um Abraham situhu' pahentana Puang Allataala. ");
INSERT INTO ptu_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Sahatu'um taunna dadinna Abraham anna dadii Ishak änä'na. ");
INSERT INTO ptu_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Iya nauam Sara: “Puang Allataala umpopetabaä', anna ingganna to umpelelei, kassi duka'. ");
INSERT INTO ptu_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Ingngena'na tä' deem tau la muuaam Abraham: ‘La mala ma'pasusu Sara.’ Sapo' mala siamä' duka' undadiangam änä' Abraham, moi anna illaammi kamatuaam.” ");
INSERT INTO ptu_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Tappana dipalappa'i sumusu Ishak aka kasalle-sallem, iya ma'hame-hamem Abraham allo eta too. ");
INSERT INTO ptu_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Pissam wattu, naita Sara indo änä'na Hagar to Mesir ma'saleo sola Ishak. ");
INSERT INTO ptu_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Iya nauam Sara lako Abraham: “Suai lao indo sabua' sola änä'na. Aka indo änä' sabua' tä' sihatam la umpomana' sabaheam kulleta, aka mana'na asam änä'ku Ishak.” ");
INSERT INTO ptu_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Tä' deem pada samapi'di' penabanna Abraham uhhingngi tula' ia too, aka indo Ismael änä'na duka'. ");
INSERT INTO ptu_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Sapo' ma'kada Puang Allataala lako Abraham naua: “Daa ungkasussanni diona inde sabua'mu sola änä'na. Tuhu'i pa'elo'na Sara aka Ishak la naongei buttu pessubummu situhu' pa'dandiangku. ");
INSERT INTO ptu_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Susi duka' änä'na Hagar la kupabudaam pessubunna anna mala umpangngissi lao botto, aka änä'mu duka'.” ");
INSERT INTO ptu_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Masiäi, iya mebengngi'-bengngi'um bangom Abraham anna mualaanni tinallo Hagar sola Ismael, hoti anna uwai ponno pa'pongngeam, anna napasahihii. Mane nasuai lao sola änä'na. Iya le'ba'um Hagar anna kalao-laoi lako pohiallasam si diuaam Bersyeba, tadeem uwainna. ");
INSERT INTO ptu_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Pissananna puhai indo uwai napa'tinallo, iya umpaokko'um änä'na Hagar dio kationganna. ");
INSERT INTO ptu_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Mane le'ba' senga'i ia muokko', umbai' la sahatu' mete' alla'na, aka naua inabanna: “Tä' la kusaha kuita änä'ku la mate.” Iya kaoli-olim sumahho Hagar. ");
INSERT INTO ptu_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Nahingngi Puang Allataala sahhona Ismael, iya ma'kadam malaika'na yabo mai langi' lako Hagar naua: “Aka hiko umpomasussa Hagar? Daa ummahea', aka nahingngim Puang Allataala kamahanna änä'mu. ");
INSERT INTO ptu_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Laoko bangonganni anna umpakahangai aka la kupabu'dä' pessubunna.” ");
INSERT INTO ptu_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Iya napatibukkaammi Puang Allataala matanna Hagar, nasuhum muita mesa bujum. Tappa le'ba' siaham umpangngissi ongeam uwainna anna nabeenni änä'na naihu'. ");
INSERT INTO ptu_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","21","Indo Ismael naolaam Puang Allataala, iya tuttuam kasallem duka' anna si tohho dio pohiallasam isanga Paran, anna mendadi mesa to si manähä umbälä'du' olo'-olo'. Anna naalaam indona baine to Mesir napobaine. ");
INSERT INTO ptu_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Pissam wattu sule Abimelekh sola pangngulu sohodadunna isanga Pikhol, untungka Abraham anna nauaanni: “Si natamba' Puang Allataala ingganna pa'palakoammu. ");
INSERT INTO ptu_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Dadi temo pa'pindako dio olona Puang Allataala anna mala iannapi anna ia si untula' lako kaleku anna lako änä'ku sola ingganna pessubungku. Umba susi penaba mapiangku tama kalemu, la umpateemmi too duka' tama kaleku anna lako issinna inde ongeam muongei messihuhu.” ");
INSERT INTO ptu_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Iya natimba'um Abraham naua: “Abana la ma'pinda si'daä'.” ");
INSERT INTO ptu_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Puhai, umpenossoim Abimelekh aka deem mesa bujunna naala bäbä sabua'na Abimelekh. ");
INSERT INTO ptu_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Iya natimba'im Abimelekh naua: “Setonganna tä' kuissam menna umpogau'i kaha-kaha ia too. Anna tä' toi deem untulasannä' diona ia too. Maneanna kuissam temo.” ");
INSERT INTO ptu_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Iya naalam Abraham sanaka-naka domba sola sapim anna nabeenni Abimelekh mane sitalli'i. ");
INSERT INTO ptu_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Anna deempi pitu änä' domba bihä napasehe Abraham. ");
INSERT INTO ptu_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Iya nauam Abimelekh lako Abraham: “La muaka inde pitu änä' domba umpasehe?” ");
INSERT INTO ptu_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Natimba'im Abraham naua: “La kubeengko aka la kamakalesoanna diua indo bujum kao umbo'bä'i.” ");
INSERT INTO ptu_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Iam too anna disangaim indo ongeam Bersyeba, aka naongei sitalli' Abraham sola Abimelekh. ");
INSERT INTO ptu_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Puhai sitalli' dio Bersyeba, iya ma'pasulem Abimelekh sola pangngulu sohodadunna isanga Pikhol lako bottona to Filistin. ");
INSERT INTO ptu_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Natanammi Abraham satoo' kaju tamariska dio Bersyeba. Etam too si naongei umpenombai Puang Allataala DEBATAnta To la tontä sule lako salako-lakona. ");
INSERT INTO ptu_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Puhai ia too, masäepi tohho Abraham dio bottona to Filistin. ");
INSERT INTO ptu_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Lessu' asanni ia too, iya napangngitaim Puang Allataala kamanuhusanna Abraham. Ma'kada Puang Allataala naua: “O Abraham!” Natimba' naua: “Indeä' Debata.” ");
INSERT INTO ptu_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Iya nauaammi: “Le'ba'koa' lako lembäna Moria sola Ishak änä' mesammu anna pa'pakamajammu, aka la umpehumalasam dio oloku. La kupaissanningko too mesa tanete la muongei untunui.” ");
INSERT INTO ptu_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Makale'nai mebengngi'-bengngi', iya bangommi Abraham ullapi'i keledainna. Puhai, umbisä'um kaju la napake untunu bua pemala'na, mane mengkalaoi sola Ishak anna dua sabua'na lu lako indo ongeam puha natuhoam Puang Allataala. ");
INSERT INTO ptu_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Tappana tallungngalloi mellao, iya mennenne'um lao Abraham. Iya naita mambelam indo ongeam puha natuhoam Puang Allataala. ");
INSERT INTO ptu_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Ma'kadam Abraham lako indo dua sabua'na naua: “Tohhongkoa' tiko eta indee sola inde keledai, angki lao kami' sola Ishak menomba eta libam. Puhapi mane ma'pasulekam kipellambi'ikoa'.” ");
INSERT INTO ptu_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Iya naalam Abraham indo kaju la dipake untunu bua pemala' anna napapassannii Ishak änä'na, anna umbabai ia api sola piso anna le'ba'i situhu'. ");
INSERT INTO ptu_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Mahassanni mellao, iya ma'kadam Ishak lako ambena naua: “O ambe'!” Natimba' Abraham naua: “Aka änä'ku?” Mekutanam Ishak naua: “Deemmi inde api sola kaju sapo' umba hi änä' domba la dipake mehumala'?” ");
INSERT INTO ptu_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Natimba' Abraham naua: “Puang Allataala hi tia la umpatoka änä' domba la dipake mehumala'.” Iya umpatahhu' lium pa'laoanna. ");
INSERT INTO ptu_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Tappana landa'i Abraham sola änä'na lako indo ongeam napassuai Puang Allataala, iya napapiam Abraham ongeam pehumalasam. Anna napapiai lokona indo kaju, mane umpungoi Ishak änä'na anna napalängänni indo ongeam pehumalasam yabona indo kaju la ditunu. ");
INSERT INTO ptu_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Puhai, ussintä'um pisona Abraham aka la ussamballem änä'na. ");
INSERT INTO ptu_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Sapo' tappa metamba malaika'na DEBATA naua: “O Abraham, O Abraham!” Natimba' naua: “Indeä' Debata.” ");
INSERT INTO ptu_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Iya ma'kadam naua: “Daa umpatei itim änä'mu. Tä' deem la muaka, aka kuissammi pole' kuua umpa'kasallei si'da-siaä' anna umpengkahea'i, nasuhum ahu'ko la umbehoannä' änä'mu, moi anna anggam mesa-mesa.” ");
INSERT INTO ptu_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Mennenne'um lao Abraham iya muitam mesa domba laki dio boko'na, tikädä tandu'na lako kuhha. Iya naalam Abraham indo domba anna napehumalasanni, bala'na änä'na. ");
INSERT INTO ptu_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Iya nasangaim Abraham indo ongeam: “Napatoka DEBATA la dipahalluanna.” Iam too anna naua lium tau sule lako temo: “DEBATA la umpatoka kapahalluam yabo tanetena.” ");
INSERT INTO ptu_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","16","Iya metamba pole oom kapenduanna indo malaika'na DEBATA yabo mai langi' naua: “Ma'battakada DEBATA naua: Umpa'pindaiä' sangangku, aka untuhu' asammi ingganna kupahentaangko, anna tä' deem mabanda' penabammu umbehoannä' änä'mu moi anna anggam mesa-mesa. ");
INSERT INTO ptu_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","Dadi la kubeengko tamba' sanda silapi' tadipuha-puha anna la kupasusi budanna bintä yabo langi' pessubummu, anna la susi budanna bungim dio bihim le'bo'. Anna indo pessubummu la untaloi asam ingganna balinna. ");
INSERT INTO ptu_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Anna pessubummu la kupa'polalanni pa'tamba' lako issinna lino, aka untuhu' si'da-siangko pahentaku.” ");
INSERT INTO ptu_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Puhai ia too, ma'pasulem Abraham lako indo dua sabua'na, anna pada-padai mengkalao lu lako Bersyeba, anna tohho dioi. ");
INSERT INTO ptu_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Puhai indo kadadiam yabo tanete Moria, napelelem Abraham diua indo Milka bainena Nahor, solasubunna Abraham, undadiammi kahua änä' sangngim muane. ");
INSERT INTO ptu_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Uluana isanga Us, mane huntunnai isanga Bus, anna mane Kemuel, iam ia ambena Aram, ");
INSERT INTO ptu_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","mane sihuntum-huntunni Kesed, Hazo, Pildas, Yidlaf anna Betuel. ");
INSERT INTO ptu_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Iya Betuel-um ia ambena Ribka. Iam too indo kahua änä'na Milka nasibalii Nahor, solasubunna Abraham. ");
INSERT INTO ptu_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Anna deempi baine senga'na Nahor isanga Reuma, undadiam duka' änä'. Uluana isanga Tebah mane nahuntunnii Gaham, Tahash, anna Maakha. ");
INSERT INTO ptu_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Tappana sahatu' dua puloi pitu taunna dadinna Sara, ");
INSERT INTO ptu_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","iya matem dio Kiryat-Arba battu diua Hebron, lembäna Kanaan. Iya lakom Abraham nasahhoi anna ma'bahata. ");
INSERT INTO ptu_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Puhai ia too ke'de'um Abraham umpellei bainena, lao umpellambi'i to Het anna nauaanni: ");
INSERT INTO ptu_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“Kao-kao to messihuhuä' illaam alla'-alla'mua', kela mala anna umbeennä' kao duka' pa'ku'busam inde illaam bottomua', aka la kupallamunni baineku.” ");
INSERT INTO ptu_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Iya natimba'im naua: ");
INSERT INTO ptu_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“Pehingngii inde tula'ki matim: Iko mesako to kasalle illaam alla'-alla'ki, dadi petua' mammi pa'ku'busam handam mapianna la umpallamunni bainemu. Aka tä'kam deem moi podo la mesam ullabaiko.” ");
INSERT INTO ptu_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Iya menombam Abraham dio olona indo to Het, ");
INSERT INTO ptu_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","anna ma'kadai naua: “Oa' solasubungku, ke ahu'ungkoa' la kulamum inde baineku, kamaseiä' anna umpelauannä' lako Efron änä'na Zohar ");
INSERT INTO ptu_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","umba ke nabeennä' indo leä dio bihim bela'na, dio Makhpela. Aka la kualli situhu' angga'na, anna malai kupa'ku'bu'i lium kao duka' illaam alla'-alla'mua'.” ");
INSERT INTO ptu_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Wattu eta too, dio siam duka' heem Efron, illaam alla'-alla'na solana. Iya iam mentimba' lako Abraham, nasa'bii ingganna indo to Het to diona heem ma'hempum dio ba'ba tama kota, ");
INSERT INTO ptu_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","naua: “O puäku, pehingngii inde tula'ku matim: Indo bela' anna leä la kubeengko, mapianna hia aka nahingngi asam duka' solaku illaam inde kota. Dadi laongko too pallamunnii bainemu.” ");
INSERT INTO ptu_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Iya menomba pole oom Abraham dio olona indo to Het. ");
INSERT INTO ptu_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","Anna mane ma'kadai lako Efron nahingngi asam to dio heem naua: “Kela mala anna umpehingngii inde tula'ku: La kubaja'ko situhu' allinna indo bela'. Alai inde allinna anna malai kupallamunni to mateku.” ");
INSERT INTO ptu_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Natimba'um Efron naua: ");
INSERT INTO ptu_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“O puäku, setonganna, indo litä' anggam la appa' hatu' doi' peha' allinna, iya la dipoakam ia duka' pada. Pangku'bu'im too to matemu.” ");
INSERT INTO ptu_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Iya tä'um nataba'i Abraham, naissa' manda ham indo doi' peha' appa' hatu' situhu' timbangam doi' indo si biasa napake to ma'balu'. Mane nabaja'i lako Efron nasa'bii indo ingganna to Het mahassam ma'hempum. ");
INSERT INTO ptu_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Susim too tulasanna indo bela'na Efron dio Makhpela, tandai mata allona Mamre, anna mendadii bela'na Abraham. Indo litä', deem bela' deem leä anna ingganna kaju-kajunna sule lako tubo diona katonam. ");
INSERT INTO ptu_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","Indo litä' naakui asam indo ingganna to Het, to ma'hempum dio ba'ba kota eta too, napemammi'um Abraham. ");
INSERT INTO ptu_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Iya ungku'bu'um Sara Abraham napatama leä dio Makhpela, tandai mata allona Mamre, battu diua Hebron dio lembäna Kanaan. ");
INSERT INTO ptu_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Susim too tulasanna indo bela' sola leä anna mendadii pa'ku'busanna Abraham. ");
INSERT INTO ptu_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Pissananna matua punalai Abraham anna puham natamba' DEBATA illaam mentu' salu katuboanna, ");
INSERT INTO ptu_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","iya ma'kadam lako indo sabua'na handam matua, to si ullima'ianni kullena, naua: “Anda'i ahena too' apangku, ");
INSERT INTO ptu_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","aka la ma'pindako umpa'pindai Puang Allataala DEBATAnta To ungkuasai langi' anna lino, aka tä'ko la mualaam Ishak änä'ku baine illaam inde Kanaan, botto kuongei. ");
INSERT INTO ptu_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Sapo' la lu lakoko botto kadadiangku umpeänganni baine peänäsanna solasubungku.” ");
INSERT INTO ptu_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Iya mekutanam indo sabua'na naua: “Indo ke mokai indo baine la umpellei banuanna natuhu'ä' sule eta inde botto muongei? Iya la mala haka kubaba Ishak lako botto kadadiammu?” ");
INSERT INTO ptu_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Sapo' natimba' Abraham naua: “Jagako! Deem ai la umpasola änä'ku lako! ");
INSERT INTO ptu_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Puang Allataala DEBATAnta to ungkuasai langi', puhaä' natässu'i illaam mai banuanna ambeku sola botto kadadiangku. Anna puhaä' napa'tula'i anna ma'pinda naua: ‘Inde pa'bottoam la kubeem pessubummu.’ DEBATA hi too la ussua malaika'na muyoloangangko anna malai ullambisam baine änä'ku. ");
INSERT INTO ptu_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Sapo' maka' indo hi baine moka untuhu'ko, iya lappa'ungko iko dio mai inde pinda. Anggam ia tä' si'da-si'dako ia pole' mala la umbaba änä'ku lako.” ");
INSERT INTO ptu_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Iya muanda'im too' apanna Abraham indo sabua'na anna ma'pindai, la natuhu' asam ingganna indo nasuaam. ");
INSERT INTO ptu_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Iya mualam sapulo untana puäna indo sabua'na sola ma'hupa-hupa baham-baham keangga' anna le'ba'i lako Nahor mesa kota dio lembäna Aram-Mesopotamia. ");
INSERT INTO ptu_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Landa'i, iya napatohhom indo unta dio sulibanna kota ma'päsä dio ampe' bujum aka kahubemmi, anna biasa wattunnam si lao tumimba baine. ");
INSERT INTO ptu_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Mane mengkaalai längäm DEBATA naua: “O Puang Allataala DEBATA to napenombai puäku Abraham, pasule lakoannä' pattujungku allo temo. Pa'patandanni pa'kamasemu lako puäku Abraham. ");
INSERT INTO ptu_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Indemä' ampe' bujum ke'de' anna la suleim too änä' daha issinna inde kota la tumimba. ");
INSERT INTO ptu_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Kela mala anna dadii susi indee: maka' ma'kadaä' kuua: ‘O änä' daha, kamaseiä', beennä' itim uwaimmu la kuihu',’ anna natimba'i naua: ‘Io, ihu'i. Moi untamu la kupaihu' toi.’ Iya la iam too umpoelo' la napobaine sabua'mu Ishak. Anna la kuissammi too kuua Iko umpa'patandaam pa'kamasemu lako puäku.” ");
INSERT INTO ptu_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Tä'pi teppu' tula'na, iya sule siaham mesa änä' daha ussompo timbaanna isanga Ribka, änä'na Betuel. Indo Betuel änä'na Milka nasibalii Nahor, solasubunna Abraham. ");
INSERT INTO ptu_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Indo änä' daha tä' deem pada samapia anna tä'pi deem lako muane. Iya le'ba'um dokko indo ba'ba bujum anna umpangngissii timbaanna, mane ma'pasulei dio mai sule. ");
INSERT INTO ptu_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Iya lumumpa' siaham indo sabua' napellambi'i anna nauaanni: “Kamaseiä' beennä' saidi' itim uwai illaam timbaammu la kuihu'.” ");
INSERT INTO ptu_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","19","Natimba'im naua: “Io puäku.” Tappa napatuhum siaham anna nabeenni naihu' mane nauai: “La kutimbaam duka' uwai inde mai untamu anna dipasanta'i naihu'.” ");
INSERT INTO ptu_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Mane natolanni indo timbanna dokko pahabam anna lumumpa' polei lao tumimba, aka la napaihu' asam indo untana sabua'na Abraham. ");
INSERT INTO ptu_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Iya mengkamma'um indo sabua' napetua'-tua' aka la napengngissanni battu la napasule lako si'da hi DEBATA battu la tä' di indo nalaoi. ");
INSERT INTO ptu_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Tappana puha asanni mangngihu' indo unta, naalaammi indo sabua' antim-antim mesa sola ponto sapasam sangngim bulabam täsä', (la'bi lime gram mabanda'na indo antim-antim anna la'bi sahatu' gram mabanda'na indo ponto). ");
INSERT INTO ptu_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Anna mekutanai naua: “Tulasannä! Mennako keänä'? Deem daka la kiongei dio banuanna ambemu aka la ma'bengikam?” ");
INSERT INTO ptu_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Iya natimba'im naua: “Isanga ambeku Betuel änä'na Milka nasibalii Nahor. ");
INSERT INTO ptu_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Anna dio banua deem ongeam la malaa' muongei anna buda toi dalame la napa'päsäi untamu sola humpu' la naande.” ");
INSERT INTO ptu_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Tappa ma'balinguntu' siaham indo tau umpuji sanganna DEBATA ");
INSERT INTO ptu_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","naua: “Kupa'kasallei sangammu Puang Allataala DEBATA to napenombai puäku Abraham. Aka tontä liu pa'kamasemu anna kamanontongammu lako puäku, lambi' untetteä' lako banuanna solasubunna.” ");
INSERT INTO ptu_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Iya lumumpa' siaham indo änä' daha lako banuanna anna natula' asanni ingganna indo kaha-kaha ia too. ");
INSERT INTO ptu_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","30","Nahingnginna Laban änä' muanena Ribka tula'na indo tau napalanda' Ribka, anna naita toi indo antim-antim sola ponto napake, tappa le'ba' siaham lumumpa' umpellambi'i indo tau lako ampe' bujum. Iya nalambi'um tontäpi ke'de'-ke'de' dio ampe' untana sikahuku' bujum. ");
INSERT INTO ptu_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Napa'kadaim naua: “O to natamba' DEBATA, daa muindea' sulibam, maikoa' talulako banua aka dipatokaammokoa' ongeam anna ongeanna untamu dio!” ");
INSERT INTO ptu_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Iya le'ba'im tama banua indo tau. Naleppa'iammi Laban teke'na indo untana anna mane naalaanni dalame la napetindoi untana sola kinande la napandeam. Puhai ia too, nababaammi sule uwai nabaseiam bitti'na indo sabua'na Abraham sola solana. ");
INSERT INTO ptu_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Tappana dibabaanni sule kinande, ma'kadam indo tau naua: “Tä'pä' la mangngande ke tä'pi puha kupalanda' inde tula' kubaba.” Natimba'im Laban naua: “Iya maka' deem kada la umpalambi', iya pa'tula'ungko.” ");
INSERT INTO ptu_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Iya ma'kadam naua: “Kao-kao sabua'naä' Abraham. ");
INSERT INTO ptu_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Tä' deem pada sanatamba' DEBATA indo Abraham lambi' sugi' si'da-si'da. Aka nabeem buda domba, sapim, bulabam, peha', sabua' baine anna muane, unta anna keledai. ");
INSERT INTO ptu_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Anna Sara bainena indo puäku, moi anna matuam sapo' malapi keänä' mesa muane. Anna ingganna kullena indo puäku puha asammi nabeho lako änä'na. ");
INSERT INTO ptu_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Indo puäku puhaä' napopa'pinda naua: ‘Tä'ko la mualaam baine Ishak änä'ku illaam inde Kanaan, botto kuongei. ");
INSERT INTO ptu_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Sapo' la lu lakoko kasahapuanna ambeku umpeänganni baine peänäsanna solasubungku.’ ");
INSERT INTO ptu_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Iya kutimba'um kuua: ‘Maaka susi ke mokai sule indo baine?’ ");
INSERT INTO ptu_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Nauaammä': ‘DEBATA to kutuhu'i, la ussua malaika'na la umpasolaiko anna mala sule lako pa'laoammu anna malai ullambisam baine inde änä'ku, peänäsanna ambeku. ");
INSERT INTO ptu_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Iapi mane lappa'i pa'pindamu dio oloku ke le'ba'ungko lako kasahapuangku. Moi anna tä'ko la nabeem baine, sapo' la lappa'ungko dio mai pa'pindamu.’ ");
INSERT INTO ptu_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","Iya ingngena' suleku dio sa'dena indo bujum, ma'sambajammä' kuua: ‘O Puang Allataala DEBATA to napenombai puäku Abraham, kela mala Iko la umpasule lakoi inde to kulingkai tentomai illaam pa'laoangku. ");
INSERT INTO ptu_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Indemä' ampe' bujum ke'de'-ke'de', kela mala anna dadii susi indee: Maka' deem mesa änä' daha sule tumimba, anna kuuaanni: “Kamaseiä' beennä' itim uwaimmu saidi' la kuihu',” ");
INSERT INTO ptu_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","anna natimba'i naua: “Io, ihu'i. Moi la naihu'na untamu la kutimbaampi duka'.” Iya la iam too umpoelo' la napobaine änä'na puäku.’ ");
INSERT INTO ptu_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Tä'pi teppu' indo ma'sambajannä' illaam penabangku, iya sule siaham Ribka ussompo timbaanna anna le'ba'i dokko bujum tumimba. Kuuaammi: ‘Kamaseiä' beennä' kuihu'.’ ");
INSERT INTO ptu_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Tappa napatuhum siaham yabo mai palempenna indo timbaanna anna nauai: ‘Ihu'ko, moi untamu la kupaihu' toi.’ Iya kuihu'um anna napaihu'pi duka' untaku. ");
INSERT INTO ptu_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Puhai, kuuaammi: ‘Mennako keänä'?’ Natimba'um naua: ‘Isanga ambeku Betuel änä'na Nahor nasibalii Milka.’ Iya kupadekkesammi antim-antim dio illäna anna mane kupapontoi. ");
INSERT INTO ptu_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Mane ma'balinguntu'ä' umpuji anna umpa'kasallei sanganna Puang Allataala DEBATA to napenombai puäku Abraham. Aka natetteä' illaam inde pa'laoangku umpeä baine pessubunna solasubunna puäku la napobaine änä'na. ");
INSERT INTO ptu_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Dadi temo, tulasannä' la ungkamasei haka' indo puäku anna untuhu'i pa'elo'na la tä' daka, anna kuissanni menggihi' senga'.” ");
INSERT INTO ptu_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Iya natimba'im Laban sola Betuel naua: “Inde kaha-kaha buttu yabo mai DEBATA, tä'um kami' kiissam la kisangai pole. ");
INSERT INTO ptu_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Petua'i, diom olomu Ribka, pasolam too lao anna mala napobaine änä'na puämu, umba susi kadanna DEBATA.” ");
INSERT INTO ptu_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Nahingnginna sabua'na Abraham indo tula'na, tappa muoppä umpenombai DEBATA. ");
INSERT INTO ptu_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Mane mualai poheba bulabam sola peha' anna poheba sampim nabeem lako Ribka. Anna deempi duka' lako indona anna Laban. ");
INSERT INTO ptu_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Puhai ia too, mangngandeim anna muihu'i indo sabua' sola ingganna solana. Iya ma'bengiim eta. Mebengngi'i bangonnim anna ma'kadai indo sabua' naua: “La ma'pasulengkam lako puäku.” ");
INSERT INTO ptu_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Sapo' natimba' Laban sola indona naua: “Tä'pi tappa la umpasolaa' lao, la indepakia' moi podo si sapulom benginna mane le'ba'koa'.” ");
INSERT INTO ptu_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Iya natimba'um naua: “Tä'unna' la ullabai, aka napasule lakom DEBATA inde pa'laoangku. Dadi lappasammä' anna malaä' ma'pasule lako puäku.” ");
INSERT INTO ptu_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Iya nauam: “Mapia ke tatambaiia' Ribka anna iai dipopa'elo'.” ");
INSERT INTO ptu_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Iya untambaim Ribka anna nakutanai naua: “La maelo'ungko le'ba' sola inde tau?” Natimba'um naua: “Io, maelo'ä'.” ");
INSERT INTO ptu_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Iya le'ba'um Ribka sola indo to si untahinanai mengkalao bahinni'na sola indo sabua'na Abraham anna solana. ");
INSERT INTO ptu_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Iya napa'lambeammi solasubunna Ribka naua: “O Ribka la buda hi too pessubummu la massa'bu-sa'bu anna la makkatalo-talo aka la ia umpangngissi bottona ingganna balinna.” ");
INSERT INTO ptu_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Iya ma'kalili'um Ribka sola ingganna sabua'na baine anna mengkalaoi ussäkei unta le'ba' untuhu' indo tau. Susim too inde anna le'ba'i Ribka napasola sabua'na Abraham. ");
INSERT INTO ptu_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Siampu' eta too, sule Ishak buttu dio mai bujum Lahai-Roi aka tohho dioi lembäna Negeb. ");
INSERT INTO ptu_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Pissananna kahubenni messubummi Ishak anna kalao-laoi lako pa'kambisam. Pissananna ma'pahandammi lao, iya muitam unta sule ma'tuhu'-tuhu'. ");
INSERT INTO ptu_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Siampu' eta too mennenne' lao Ribka, iya muitam Ishak. Tappa tuhum siaham yabo mai untana ");
INSERT INTO ptu_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","anna mekutanai lako sabua'na Abraham naua: “Menna dipe muane umpenandaikia' dipe mai?” Iya natimba'im naua: “Iam too indo puäku.” Iya muala siaham lullunna Ribka anna napa'lullunni umbalu-balui lindona. ");
INSERT INTO ptu_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Pissananna silambi'i, iya umpa'tulasammi Ishak indo sabua' ingganna pa'palakoanna illaam pa'laoanna. ");
INSERT INTO ptu_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Iya untettem Ribka Ishak anna napasolai tama bahunna Sara indona Ishak, anna napobainei. Umpakamaja si'da-si'da Ribka indo Ishak, iya tipakahangam pole' pi'di' penabanna, indo puha mate indona. ");
INSERT INTO ptu_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Iya kebaine pole oom Abraham umpobaine isanga Ketura. ");
INSERT INTO ptu_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Indo bainena undadiangam änä' Abraham isanga Zimran, Yoksan, Medan, Midian, Isybak anna Suah. ");
INSERT INTO ptu_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Yoksan undadiam Syeba sola Dedan. Pessubunna Dedan to Asyur, to Letush, anna to Leum. ");
INSERT INTO ptu_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Midian undadiam Efa, Efer, Henokh, Abida, anna Eldaa. Padam too indee pessubunna Ketura. ");
INSERT INTO ptu_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Moinna anna napa'manasam asammi lako Ishak ingganna kullena Abraham, ");
INSERT INTO ptu_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","sapo' wattunna anna tubopi, deempi napebeem lako änä' senga'na, indo to nasibalii baine senga'na. Anna mane ussuai indo änä' senga'na le'ba' mentieli' dekke tandai mata allona Kanaan umpellei Ishak. ");
INSERT INTO ptu_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","8","Indo Abraham tä' deem pada samahendem. Sahatu' pitu pulo lima taunna tubo mane matei lambi' le'ba' sungnga'na ma'mesa sola nene to naponene. ");
INSERT INTO ptu_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Tappana matei, iya naku'bu'um änä'na, indo isanga Ishak sola Ismael. Napatama leä dio Makhpela tandai mata allona Mamre. Yolona, ongeam ia too litä'na Efron to Het, änä'na Zohar. ");
INSERT INTO ptu_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Sapo' litä' ia too naalli Abraham lako indo to Het. Iya etam too dipallamunni Abraham sola Sara bainena. ");
INSERT INTO ptu_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Puhai mate Abraham, iya natamba'um Puang Allataala Ishak, änä'na. Wattu eta too, si tohho dio sikahuku' bujum Lahai-Roi. ");
INSERT INTO ptu_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Indem ia tulasanna pessubunna Ismael, änä'na duka' Abraham nasibalii Hagar to Mesir, sabua'na Sara: ");
INSERT INTO ptu_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","16","Ismael undadiam sapulo dua änä', uluana isanga Nebayot, mane huntunnai Kedar, Adbeel, Mibsam, Misyma, Duma, Masa, Hadad, Tema, Yetur, Nafish anna Kedma. Indo sapulo dua änä'na Ismael, iam too kabuttuanna sapulo dua kahajaam, anna sanganna tondä'na sola ongeanna pantam dipakonai sanga kalena. ");
INSERT INTO ptu_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Sahatu' tallu puloi pitu taunna dadinna Ismael anna kattui penabanna lambi' le'ba'um sungnga'na ma'mesa sola nene to naponene. ");
INSERT INTO ptu_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Indo pessubunna umpangngissi alla'na Hawila anna Syur, tandai mata allona Mesir memba'ba lako Asyur. Tä' deem si siala penaba pessubum senga'na Abraham. ");
INSERT INTO ptu_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Indem ia tulasanna peänäsanna Ishak, änä'na Abraham: Abraham undadiam Ishak. ");
INSERT INTO ptu_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Indo Ishak appa' pulo taunna dadinna anna umpobainei Ribka, adinna Laban änä'na Betuel, mesa to Aram to buttu dio mai Padan-Aram. ");
INSERT INTO ptu_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Pissananna aka indo Ribka tämänä, iya mengkaalam Ishak längäm DEBATA umpa'sambajangam bainena. Nahingngiam DEBATA sambajanna Ishak napolalam kebättä Ribka. ");
INSERT INTO ptu_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Indo mahassam kebättä nasi'dimmi angga' si sibobo' indo änä'-änä' illaam tambu'na. Iya nauam Ribka: “Akanna malaä' nahua inde susi?” Napolalam mengkaala längäm DEBATA. ");
INSERT INTO ptu_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Iya ma'kadam DEBATA naua: “Itim ungkebättängam dua pentoosam kasalle. La undadiangko dua pentoosam kasalle la sisähä'. Adinna la mentondom anna la umpahe' leko' kakanna.” ");
INSERT INTO ptu_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Tappana lambi' wattunna, iya keänä'um hendu bassim muane. ");
INSERT INTO ptu_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Indo kakanna malea kuli'na anna kebulu susi poheba kebulu. Iam too anna disangaim Esau. ");
INSERT INTO ptu_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Natuhu' siam änä' kaduanna muanda'i kambutu'na kakanna. Iam too anna disangaim ia Yakub. Annam pulom taunna Ishak anna keänä'i bainena. ");
INSERT INTO ptu_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Indo dua änä'-änä' tuttuam lobo' anna kasalle. Pengkähänganna ia Esau to menduhu' anna si napohäe tohho lako kaliane. Sapo' Yakub ia hapa' penaba anna anggam ia si tohho dio bahum. ");
INSERT INTO ptu_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Indo Ishak umpakamaja puha ia Esau, aka bassa' si napande bale pesea'. Sapo' Ribka ia, umpakamaja puha ia Yakub. ");
INSERT INTO ptu_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Pissam wattu mahassam ma'nasu Yakub, iya sulem Esau buttu dio mai kaliane, anna tadea' punala nasi'dim. ");
INSERT INTO ptu_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Iya ma'kadam lako Yakub naua: “Tadea' punalaä', beennä' kao saidi' itim bue malea unnasu.” (Iam too anna si diuaammi duka' Esau, Edom.) ");
INSERT INTO ptu_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Iya natimba'im Yakub naua: “Io, mala sapo' la umbeennä' kakakaammu.” ");
INSERT INTO ptu_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Iya nauam Esau: “La kuaka duka' inde kakakaam, tä' siam deem gunana ke mate tadea'ä'.” ");
INSERT INTO ptu_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Iya nauam Yakub: “Pa'pindako yolo keta umbeem si'daä'.” Iya ma'pindam yolo Esau, anna napebeenni kakakaanna lako Yakub. ");
INSERT INTO ptu_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Puhai ia too, iya mualam hoti sola sabaheam indo bue malea anna nabeenni. Iya naandem anna mangngihu' mane ke'de'i le'ba'. Susim too lalanna umpa'bahinni'i kakakaanna Esau. ");
INSERT INTO ptu_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Pissam wattu sule oom kakobeam susi indo anna tubopi Abraham. Napolalam le'ba' Ishak lako Abimelekh tomahajanna to Filistin anna tohhoi dio Gerar, ");
INSERT INTO ptu_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","aka puha umpa'paitaam kalena DEBATA lako Ishak anna nauaanni: “Daa ullao lako Mesir, tohho dioko indo to la kutulasangko. ");
INSERT INTO ptu_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Etangko too pessihuhu anna la kukambi'ko sola kutamba'. Ingganna inde pa'lembängam la kupadokkoangko lisu pala'mu sule lako pessubummu. Aka la kupasule lako pa'dandiangku, indo puha kudandi lako ambemu Abraham. ");
INSERT INTO ptu_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Anna la kupalohom banne taummu susi budanna bintä yabo langi' anna inde pa'lembängam la kupadokkoam asam lisu pala'na pessubummu. Anna pessubummu la kupa'polalanni pa'tamba' lako issinna lino. ");
INSERT INTO ptu_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Ia anna la kutamba'koa' aka untuhu'i liu tula'ku Abraham anna naanti manda' natobe matoto' ingganna kada pepaondongangku, pahentaku, sola pelahangangku.” ");
INSERT INTO ptu_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Iya iam too anna tohho diom Gerar Ishak. ");
INSERT INTO ptu_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Tappana napekutanaanni pa'botto diona bainena, iya nauam Ishak: “Indee adingku hi to kao.” Moka muuai: “Baineku,” aka naua inabanna: “Deem manii pa'botto umpateiä' aka umpohäe Ribka aka mapi'dä' hupanna.” ");
INSERT INTO ptu_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Masäe-säei tohho Ishak dio indo ongeam, iya ma'pahandam-handammi Abimelekh tomahajanna to Filistin dio suleba'na, iya muitam Ishak sianda'i lelem Ribka. ");
INSERT INTO ptu_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Iya untambaim Ishak anna nauaanni: “Bainemu hiko päläe' itim baine, akanna muua hiko: ‘Adingku’?” Iya natimba'im Ishak naua: “Aka kupenaba-nabaam kuua deem manii umpateiä' ke kuuai: ‘Baineku’.” ");
INSERT INTO ptu_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Nauaammi Abimelekh: “Akanna ma'pateem ongko duka'? Kahapa too deemmi taungku umpempakoi bainemu, iya umpaalaingkam kami' sala.” ");
INSERT INTO ptu_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Iya napa'pahentaammi Abimelekh lako ingganna pakketauanna naua: “Menna-menna la ussägäi Ishak, battu haka bainena, tä' mala tala dipatei.” ");
INSERT INTO ptu_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Tappana lambi' wattunna pengkähängam, mangngambo'um duka' Ishak, iya tiluppi' sahatu' pa'taunna aka natamba' DEBATA. ");
INSERT INTO ptu_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Tuttuam kehängäm katomakakaanna, sampe sugi' tangkalantungam. ");
INSERT INTO ptu_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Tä' deem pada sabuda dombana, bekena, sapinna anna sabua'na, nasuhum nakembuhui to Filistin. ");
INSERT INTO ptu_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Lambi' natambunni asam to Filistin indo bujum puha nabo'bä' sabua'na Abraham, ambena Ishak, indo anna tubopi. ");
INSERT INTO ptu_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Iya ma'kadam Abimelekh lako Ishak naua: “Äläiko lao kalemu illaam mai inde botto litä'ki aka kuasa puha hangko iko anna la kami'.” ");
INSERT INTO ptu_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Iya le'ba'um Ishak lu lako lembä Gerar anna tohho dioi mebahum. ");
INSERT INTO ptu_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Dioi, iya nakahoi asammi sule Ishak indo bujum nabo'bä' Abraham indo anna tubopi, aka natambunni to Filistin tappana mate Abraham. Anna nasangai asam sule Ishak indo bujum susi passangainna Abraham. ");
INSERT INTO ptu_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Pissam wattu umbo'bä' bujum sabua'na Ishak dio lembä ia too, iya ullambi'um uwai tä' deem pada sabuda. ");
INSERT INTO ptu_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Sapo' keaha' indo to ma'kambi' dio Gerar lako indo to ma'kambi'na Ishak naua: “Anungki hi to kami',” sampe nasikalla-kallai. Iam too anna nasangaim Ishak indo bujum, Esek, kalembasanna Kasikallaam. ");
INSERT INTO ptu_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Iya nabo'bä' polem ia indo sabua'na Ishak bujum senga' sapo' napa'keahasam pole oo, sampe nasikalla-kallai oo. Iya nasangaim ia Ishak, Sitna, kalembasanna Kasipobaliam. ");
INSERT INTO ptu_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Mentieli' pole oom kapentallunna umbo'bä' bujum. Iya tä'um pole' napa'keahasam. Iam too anna nasangaim ia Ishak, Rehobot, kalembasanna Dipalonda, aka naua: “Temo nabeemmakia' DEBATA kalondaam tohho illaam inde pa'lembängam la membea' lampa'.” ");
INSERT INTO ptu_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Mane mengkalaoi Ishak lu lako Bersyeba. ");
INSERT INTO ptu_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Bengii umpa'paitaammi kalena DEBATA lako Ishak anna ma'kadai naua: “Kaom too inde Puang Allataala to napenombai ambemu Abraham. Daa ummahea' aka la kuundu'ko. La kutamba'ko anna lohonni banne taummu aka puha kudandi lako sabua'ku Abraham.” ");
INSERT INTO ptu_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Puhai ia too, umpapiam pehumalasam anna umpenombai DEBATA dio indo ongeam. Iya mebahummi Ishak eta, anna umbo'bä' polei bujum sabua'na. ");
INSERT INTO ptu_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Iya sulem Abimelekh dio mai Gerar napasola Ahuzat to si umbalii ma'pikki' anna Pikhol pangngulu sohodadunna umpellambi'i Ishak. ");
INSERT INTO ptu_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Iya mekutanam Ishak naua: “Akanna sulekoa' umpellambi'iä'? Kusanga ungkahi'di'ä' indo lessu' sampe ussuaä' illaam mai botto litä'mua'.” ");
INSERT INTO ptu_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Natimba'um naua: “Kiissam kiua iko to naundu'ko DEBATA. Dadi kiua: Mapia ke umpadeengkia' kasitallisam. La sitalli'kia' ");
INSERT INTO ptu_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","anna mala tä'ko deem la ma'pogau' kadake lako kami', umba susi kami' duka' tä'kam deem la ma'gau' kadake matim. Sapo' tontäkam ma'pogau' mapia matim anna kipäbäingko le'ba' sola kamasannangam indo lessu'. Anna abana hia to natamba'ko DEBATA.” ");
INSERT INTO ptu_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Iya natosabe manappam Ishak, napande anna napaihu'. ");
INSERT INTO ptu_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Makale'nai mebengngi', sitalli'um pole'. Puhai ia too, nauaammi Ishak: “La masakke hakoa' too illaam pangngola-lalangammu.” ");
INSERT INTO ptu_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Allo eta siam too anna sulei sabua'na Ishak ma'tula' naua: “Indo bujum kibo'bä' kilambi'um uwai.” ");
INSERT INTO ptu_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Iya nasangaim Ishak indo bujum, Syeba, kalembasanna Kasitallisam. Susim too tulasanna anna disangai indo kota Bersyeba sule lako temo. ");
INSERT INTO ptu_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Tappana appa' puloi taunna Esau, iya umpobainem dua änä' daha to buttu dio mai Het, isanga Yudit, änä'na Beeri, anna Basmat, änä'na Elon. ");
INSERT INTO ptu_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Baine ia too umpomasussa penabanna Ishak sola Ribka. ");
INSERT INTO ptu_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Tappana matuai Ishak anna tä' toom paita, untambaim Esau änä' uluana anna nauaanni: “O änä'ku.” Natimba'im naua: “Aka ambe'?” ");
INSERT INTO ptu_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Ma'kada oom Ishak naua: “Temo änä'ku illaammä' kamatuaam anna umbai' tä'um la masäe-säeä' tubo. ");
INSERT INTO ptu_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Dadi alai bälä'du'mu sola batunna anna laoko umpemäläiannä' olo'-olo' lako kaliane. ");
INSERT INTO ptu_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Anna umpapia-piannä' nasunna susi indo si kupohäena anna umbabannä' sule kuande. Puhai too kuande, iya kupa'lambeammoko baju anna tubopä'.” ");
INSERT INTO ptu_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Sapo' nahingngi Ribka indo mahassam ma'tula' Ishak lako Esau. Tappana lessu' Esau lako kaliane umpa'pemälängam ambena, ");
INSERT INTO ptu_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","iya naua siaham Ribka lako Yakub: “Mane balinna kuhingngi ambemu umpa'tula'i Esau naua: ");
INSERT INTO ptu_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","‘Pemäläiannä' olo'-olo' anna umpapia-piannä' nasunna. Puhai too kuande, iya kupa'lambeammoko dio olona DEBATA baju anna tubopä'.’ ");
INSERT INTO ptu_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Dadi temo, pehingngii manappai inde tula'ku, änä'ku, anna umpalakoi. ");
INSERT INTO ptu_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Lakoko pa'kambisanta ammu pise'i dua änä' beketa maloppä'na, angku papia-pianni nasunna ambemu indo si napohäena. ");
INSERT INTO ptu_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Anna umbabaanni lao ambemu. Puhai too naande ikom napa'lambeam baju anna tubopi.” ");
INSERT INTO ptu_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Sapo' natimba' Yakub naua: “O indo' la mala haka tia aka kebulu ia Esau anna tä' kao kebulu kaleku. ");
INSERT INTO ptu_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Indo ke nasapui ambe' kaleku anna naissanni pole' naua: ‘Natipuä',’ iya tä' ohi tia la mepa'lambeam sapo' la metädo hi.” ");
INSERT INTO ptu_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Natimba' indona naua: “O änä'ku, kao ham umpendudum asanni petädona. Tuhu' di inde tula'ku, laongko alai indo beke.” ");
INSERT INTO ptu_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Iya le'ba' siaham duka' Yakub naala indo beke anna nabeenni indona napapia-pia nasunna, susi indo si napohäe Ishak. ");
INSERT INTO ptu_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Mane naalai Ribka poheba handam mapianna Esau änä' uluana, indo si naanna dio banuanna, anna umpapohebai Yakub änä' tämpä'na. ");
INSERT INTO ptu_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Puhai, naalam indo lollo' beke nasapu'iam bahokona Yakub sola limanna aka tä' ia kebulu. ");
INSERT INTO ptu_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Mane nabeenni Yakub indo pa'nasunna sola hoti puha napapia. ");
INSERT INTO ptu_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Iya nababaammi lao ambena anna nauai: “O ambe'.” Natimba'im Ishak naua: “Mennako änä'ku?” ");
INSERT INTO ptu_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Natimba' Yakub naua: “Kao Esau änä' uluamu. Sulemä' aka indo ussuaannä' dadi asammi. Bangommoko ammu tadongkom anna muandei inde bale pesea' pa'nasungku anna malaä' umpa'lambeam.” ");
INSERT INTO ptu_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Natimba' Ishak naua: “O änä'ku, muaka hiko susi anna masimpanni muala?” Natimba' Yakub naua: “Aka nakamaseiä' Puang Allataala DEBATA to umpenombai nasuhum bale' deem kulambi'.” ");
INSERT INTO ptu_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Iya ma'kada oom Ishak naua: “Mahuku'-huku'ko mai änä'ku angku sapuko battu Esau si'da hako.” ");
INSERT INTO ptu_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Iya lakom duka' Yakub anna nasapui ambena, iya nauam: “Maka' pa'kadammu Yakub-ko, sapo' maka' limammu susi Esau.” ");
INSERT INTO ptu_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Tä' naissam Ishak naua Yakub dia, aka kebulu limanna susi limanna Esau. Iam too anna napa'lambeammi. ");
INSERT INTO ptu_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","Mekutana pole siapi Ishak naua: “Esau si'da hakoka isanga inde ä?” Natimba' Yakub naua: “Io, Esau-ä'.” ");
INSERT INTO ptu_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Iya nauam Ishak: “O änä'ku beemmä' itim bale kuande, anna puhapi kuande mane kupa'lambeangko.” Iya nabeemmi Yakub indo bale naande sola anggur naihu'. ");
INSERT INTO ptu_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Puhai, nauam ambena: “Maingko eta inde änä'ku anna muudunnä'.” ");
INSERT INTO ptu_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Iya lakom Yakub muudum ambena, iya naudu'um Ishak susi bauanna Esau aka pohebana napake, lambi' napa'lambeammi naua: “Tä' deem pada sabubanau' bauanna änä'ku, susi bauanna bela' natamba' DEBATA. ");
INSERT INTO ptu_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","La Puang Allataala hi too umpatuhungangko uham yabo mai langi' anna napomalompoangko bela'mu anna umpomahombo gandummu, nasuhum la kembua tiluppi'-luppi' anna anggurmu la lempam pole' pa'pongngeammu. ");
INSERT INTO ptu_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Anna ingganna hupatau, iko la napengkahea'i anna ingganna issinna mobotto-bottoam iko la napenombai. Iko toi la umpahe' ingganna solasubummu anna la napenombaiko pessubunna indomu. Anna la seda to untädoko, la ullambi' tamba' to umpa'lambeangko.” ");
INSERT INTO ptu_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Tappana puha napa'lambeam Ishak, iya le'ba' siaham Yakub. Tä' masäe le'ba'na Yakub, iya sulem duka' Esau kakanna umbaba indo pesea'na. ");
INSERT INTO ptu_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Iya napapia-piam duka' nasunna mane nababaanni lao ambena anna nauai: “Bangommoko ambe' anna muandei inde bale pesea' kubabaangko anna malaä' umpa'lambeam.” ");
INSERT INTO ptu_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Mekutanam Ishak naua: “Mennako?” Naua: “Kao ambe', Esau änä' uluamu.” ");
INSERT INTO ptu_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Tappa tikkedu' Ishak lumalla' anna ma'kadai naua: “Maka' susi, iya menna hi umpemäläii indo olo'-olo' anna nanasui nababaannä' sule ingngena'? Puham kuande indo tä'poko sule, anna puham kupa'lambeam la naampuam mengkalao temo sule lako salako-lakona.” ");
INSERT INTO ptu_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Tappana nahingngi Esau tä' deem pada samasussa penabanna lambi' kaoli-oli sumahho anna nauai: “Pa'lambeannä' kao duka' ambe'.” ");
INSERT INTO ptu_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Nauam Ishak: “Sule adimmu natipuä', iya balim naala indo pa'lambe la kubeengko.” ");
INSERT INTO ptu_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Nauam Esau: “Kapenduangkum natipu, naande sanganna Yakub. Puham naala kakakaangku, naala pole oom inde pa'lambe la dibeennä'. Tä'um isanga deem pa'lambe senga' la umbeennä', ambe'?” ");
INSERT INTO ptu_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Sapo' natimba' Ishak naua: “Aka iam kupadadi puämu anna ingganna solasubunna kupadadi sabua'na anna puham kupalahui gandum sola anggur. Dadi temo tä'um iko deem la kubeengko, änä'ku.” ");
INSERT INTO ptu_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Ma'kada oom Esau lako ambena naua: “Anggam isanga sahhupa pa'lambe muampuam ambe'? Pa'lambeannä' kao duka'!” Mane kaoli-oli oi sumahho. ");
INSERT INTO ptu_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Natimba'im Ishak naua: “Ongeammu iko la sikambela litä' malompo anna tä' la nalambi' uham yabo mai langi'. ");
INSERT INTO ptu_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Anggam iko la tubo dioko mai kabahaniammu anna la napahe'ko adimmu. Sapo' pissam wattu la umbela hi too ullappasam kalemu dio mai pampahe'na adimmu.” ");
INSERT INTO ptu_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Iya umpemannaammi Yakub Esau, aka indo pa'lambe la nabeem ambena lu lako hi Yakub adinna. Iya sipa'tula'um kalena naua: “Tä'um masäe anna matem ambe'. Lessu'i too pa'bahataam, kupateim Yakub.” ");
INSERT INTO ptu_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Tappana naissam Ribka pattujunna Esau, indo änä' uluana, iya untambaim Yakub, indo änä' tämpä'na, anna nauaanni: “Napemannaangko too Esau aka indo pa'palakoammu le, mohäe la napateiko. ");
INSERT INTO ptu_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Dadi la untuhu'i inde tula'ku: pasihha'i muäläi kalemu lako kakangku, indo isanga Laban dio Haran. ");
INSERT INTO ptu_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","45","Anna la masäeko tohho dio sampe mehe aha'na kakammu anna nakalembeim indo gau'mu, mane kusuai tau lako naalako. Aka tä' kusaha la simbaha änä'ku dua pa'de illaam allo sangngallo.” ");
INSERT INTO ptu_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Anna mane ma'kada Ribka lako Ishak naua: “Tä' punalam kusaha muita liu inde lako baine to Het napobaine Esau. Maka' la baine eta pole oo naala Yakub napobaine, dota pissammä' mate.” ");
INSERT INTO ptu_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Iya untambaim Yakub Ishak anna napa'lambeanni mane nauaanni: “Tä'ko too la umpobaine baine to Kanaan le. ");
INSERT INTO ptu_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Sapo' la le'ba' siahangko lako banuanna nenemu Betuel dio Padan-Aram anna umpobainei mesa änä'na muhemu Laban. ");
INSERT INTO ptu_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","La natamba' di too Puang Allataala To Handam Kuasa kasialaammua', lambi' membea' pessubummu anna mala mendadiko nene to naponene to la umpangngissi lao mobotto-bottoam. ");
INSERT INTO ptu_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Anna la Puang Allataala hi too untamba'ko sule lako pessubummu umba susi tamba'na Abraham anna la umpuängam inde botto litä' muongei messihuhu. Aka puham nabeem Puang Allataala Abraham.” ");
INSERT INTO ptu_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Susim too inde tulasanna anna le'ba'i Yakub nasua lao Ishak. Iya le'ba'um lako Padan-Aram lu lako Laban änä'na Betuel to Aram. Indo Laban kakanna Ribka. Ribka indona Yakub sola Esau. ");
INSERT INTO ptu_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Puhai ia too, iya naissammi duka' Esau naua puham umpa'lambeam Yakub Ishak mane nasuai le'ba' lako Padan-Aram, la umpeä baine dio. Naissam toi duka' naua indo anna umpa'lambeanni Yakub, napakahi'di naua: “Tä'ko la muala baine to Kanaan la umpobaine.” ");
INSERT INTO ptu_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Anna naissam toi Esau naua: “Indo Yakub untuhu'i pa'elo'na indo' sola ambe', nasuhum le'ba' lako Padan-Aram.” ");
INSERT INTO ptu_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Naissam pole' Esau naua: “Inde ambeku tä' päläe' umpohäe baine to Kanaan.” ");
INSERT INTO ptu_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Iam too anna le'ba'um lako Ismael änä'na Abraham anna napobainei änä'na isanga Mahalat, adinna Nebayot, sulibanna indo bainena dua. ");
INSERT INTO ptu_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Iya umpelleim Bersyeba Yakub le'ba' lako Haran. ");
INSERT INTO ptu_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Tappana ullambi' mesa ongeam, iya tohhom eta ma'bengi aka lendu'um allo. Pissananna la metindoi, mualam mesa batu napa'allongam. ");
INSERT INTO ptu_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Mamma'i napangngimpim deem mesa eham ke'de' mengkalao dio ampe'na sule längäm langi' tämpä'na. Anna naita buda malaika'na Puang Allataala ma'sisolä buso' lu längäm lu yabo mai indo eham. ");
INSERT INTO ptu_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Anna dio sa'dena ke'de' DEBATA ma'kada naua: “Kaom too Puang Allataala DEBATA to napenombai nenemu Abraham sola Ishak ambemu. Inde litä' muongei metindo la kubeengko anna la naampuam sule lako pessubummu. ");
INSERT INTO ptu_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Pessubummu la susi budanna sobä' illaam lino anna ia la umpakalua' inde ongeam lao pali'. Anna iko sola pessubummu la kupa'polalanni pa'tamba' lako ingganna hupatau illaam lino. ");
INSERT INTO ptu_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Pengkilalai, Kao la muundu'ko anna la kuolaam umba-umba muongei le'ba'. Anna la kutetteko sule eta inde. Tä'ko la kutampeam lambi' kupasule lako ingganna indo puha kudandiangko.” ");
INSERT INTO ptu_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Tappa kilala siaham Yakub anna nauai: “Mane kuissam di kao, inde siam ia päläe' DEBATA.” ");
INSERT INTO ptu_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Sapo' mahea' lambi' ma'kada naua: “Tä' deem pada samakähhä inde ongeam. Tä' mala tala banuanna Puang Allataala anna ba'bana suhuga.” ");
INSERT INTO ptu_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Tappana masiä, mebengngi'-bengngi'pi, iya bangommi Yakub anna mualai indo batu napa'allongam anna napake'de'i mane natolloi minnä' aka la napotanda pengkilalaam. ");
INSERT INTO ptu_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Indo ongeam nasangai Betel (si diuaam yolona kota Lus). ");
INSERT INTO ptu_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Anna mane ma'samaja Yakub naua: “Maka' naundu'ä' Puang Allataala anna naolaam illaam pa'laoangku, anna nabeennä' kinande sola poheba, ");
INSERT INTO ptu_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","lambi' ma'pasuleä' sule lako banuanna ambeku sola masakke, iya la Iam too DEBATA kupenombai. ");
INSERT INTO ptu_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Inde batu kupake'de' la mendadi ongeam kapenombaam längäm Puang Allataala. Anna la si kubeem liu DEBATA bahe sapulona ingganna aka-aka napadokkoannä' lisu pala'ku.” ");
INSERT INTO ptu_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Iya umpatahhu'um pa'laoanna Yakub le'ba' lako mesa botto tandai mata allona Kanaan. ");
INSERT INTO ptu_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Pissananna muitam mesa bujum dio pa'kambisam anna dio ampe'na ma'päsä tallu laoam domba aka si biasa dipaihu' eta. Indo bujum ditutu'i batu kasalle. ");
INSERT INTO ptu_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Maka' tihempum asammi ingganna domba dio indo ongeam, iya nabengka'im lao indo batu ingganna to ma'kambi' anna umpaihu'i dombana. Puhai too napaihu', natutu'i oom sule. ");
INSERT INTO ptu_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Iya mekutanam Yakub lako indo to ma'kambi' naua: “Oa' solasubum buttu umbakoa' ngei?” Natimba'im naua: “Buttu diokam mai Haran.” ");
INSERT INTO ptu_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Mekutana pole oom Yakub naua: “Muissam daka'i indo Laban ampona Nahor?” Naua: “Io, kiissam.” ");
INSERT INTO ptu_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Mane naua polei: “Masakke-sakke mammaka?” Natimba'i oom naua: “Io masakke-sakke mammi ia. O, dipe ham ia mai änä'na baineä, isanga Rahel sule duka' uhhamba dombana ambena.” ");
INSERT INTO ptu_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Iya nauam Yakub: “Budapi allo, taiapi wattunna pa'hambaam. Paihu'ia' mane laokoa' ungkambi' polei.” ");
INSERT INTO ptu_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Nauam: “Tä'pi la mala kipaihu' ke tä'i sule asam dombaki. Iapi mane kibengka'i tutu'na inde bujum anna kipaihu'i dombaki ke sule asammi.” ");
INSERT INTO ptu_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Mahassampi sipa'tula', sule siaham Rahel uhhamba dombana ambena aka abana ia duka' si ma'kambi'. ");
INSERT INTO ptu_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Naitanna Yakub indo Rahel änä'na Laban muhena, uhhamba dombana Laban, iya le'ba' siaham lako indo bujum anna nabengka'i tutu'na anna napaihu'i indo dombana. ");
INSERT INTO ptu_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Puhai, muudummi Rahel napasindum kaoli-oli sumahho aka tilalla' sugali'. ");
INSERT INTO ptu_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Anna muuaanni Rahel: “Kao änä'naä' Ribka solasubunna ambemu.” Iya lumumpa' siaham Rahel lako banuanna lao natulasam ambena. ");
INSERT INTO ptu_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Naissanna Laban naua: “Sule Yakub,” tappa lumumpa' siaham le'ba' natammui. Silambi'na änä' uhena, tappa nakalapu'i napasindum naudum mane napasolai lako banuanna. Iya natula' asammi Yakub kasuhunganna anna sulei umpellambi'i Laban. ");
INSERT INTO ptu_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Nauaammi Laban: “Tappa' si'da hi tia sikahuku' punalapakia' too kita.” Iya tohhom dio Yakub sabulam. ");
INSERT INTO ptu_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Pissananna ma'kadam Laban lako Yakub naua: “Taia lalanna la umpengkähängam bäbää', moi anna sipohapuki'. Tulasannä', sanaka la kusahoiangko?” ");
INSERT INTO ptu_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Indo Laban deem änä'na dua bassim baine. Indo kakanna isanga Lea anna adinna isanga Rahel. ");
INSERT INTO ptu_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Indo Lea maleke matanna, sapo' Rahel ia mapi'dä' pa'kaleanna anna hupanna. ");
INSERT INTO ptu_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Indo Yakub tä' deem pada saumpohäe Rahel nasuhum naua lako Laban: “La kupengkähängangko pitu taunna ke umbeennä' Rahel kupobaine.” ");
INSERT INTO ptu_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Natimba' Laban naua: “Dotam tia iko kubeem anna la tau senga'. Taindem sola.” ");
INSERT INTO ptu_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Iya mengkähäm Yakub pitu taunna ussaho Rahel. Sapo' indo pitu taunna naangga' anggam sanaka amo benginna tandana umpohäe sugali' Rahel. ");
INSERT INTO ptu_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Puhai ia too ma'kadam Yakub lako Laban naua: “Sundummi pa'tempoku matim pitu taunna. Beemmä' indo tunangangku aka la kupobainem.” ");
INSERT INTO ptu_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Iya untambai asammi tau Laban issinna indo kota aka la dipa'hame-hameim kasialaanna. ");
INSERT INTO ptu_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Sapo' bengii, taia Rahel dibeem sapo' Lea hi nababaam lao Laban. Iya iam napasola metindo Yakub. ");
INSERT INTO ptu_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","(Napasolaampi Laban mesa sabua'na baine isanga Zilpa la si napakasua-sua Lea.) ");
INSERT INTO ptu_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Tappana mebengngi' mane naissam di Yakub naua: “Lea hia inde nabeennä' kupobaine!” Tappa le'ba' siaham umpellambi'i Laban anna nauaanni: “Akanna umpateennä' pua'? Kusanga inna kuua la mengkähää' ke Rahel-i kusaho. Akanna untipuä'?” ");
INSERT INTO ptu_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Natimba'i Laban naua: “Situhu' kabiasaangki tä' tia mala adinna la muyoloi kakanna kemuane. ");
INSERT INTO ptu_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Dadi paganna'i yolo pitu benginna dihame-hamei kasialaammu Lea, mane kubeem poleko Rahel umpobaine, sapo' la ussaho polepi duka' pitu taunna.” ");
INSERT INTO ptu_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Iya natuhu'im Yakub. Tappana ganna'i pitu benginna, nabeemmi pole' Rahel änä'na napobaine. ");
INSERT INTO ptu_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","(Napasolaam duka' mesa sabua'na baine isanga Bilha la si napakasua-sua Rahel.) ");
INSERT INTO ptu_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Iya napasolam duka' Yakub indo Rahel metindo. Napohäe puha ia Rahel anna la Lea. Mane napahandu' oi umpengkähängam Laban pitu taunna. ");
INSERT INTO ptu_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Tappana naita DEBATA tangkaam ia dipohäe Lea, iya la dipakebättä ia, sapo' Rahel ia tämänä. ");
INSERT INTO ptu_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Iya kebättäm ia Lea lambi' undadiam mesa muane-ane nasangai Ruben aka naua: “Tandana naita DEBATA kamasussaangku anna temo tantu napohäemä' pole' muaneku.” ");
INSERT INTO ptu_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Iya kebättä pole oom lambi' undadiam oom mesa muane-ane, iya nasangai ia Simeon aka naua: “Nabeem poleä' DEBATA inde änä' aka nahingngi naua tä' liupi dipohäe.” ");
INSERT INTO ptu_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Kebättä pole oom kapentallunna anna undadiam oo mesa muane-ane, iya ma'kadam Lea naua: “La mendekke'um too pole' penabanna muaneku aka tallum änä'ki sangngim muane.” Iam too anna nasangaim Lewi. ");
INSERT INTO ptu_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Iya kebättä pole oom kapengngappa'na lambi' undadiam oo mesa muane-ane. Iya nauam Lea: “Inde temo la umpujiä' sanganna DEBATA.” Iam too anna nasangaim Yehuda. Lessu'i ia too tä'um pole' keänä'. ");
INSERT INTO ptu_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Tappana nasi'dim Rahel tä' liupi ia keänä', iya ungkembuhuim kakanna lambi' ma'kada lako Yakub naua: “Beennä' änä' aka maka' tää', iya la mateä'.” ");
INSERT INTO ptu_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Lambi' keaha' Yakub lako Rahel naua: “Kao haka to kao Puang Allataala to umpatämänäko?” ");
INSERT INTO ptu_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Ma'kada Rahel naua: “Inde Bilha sabua'ku, pasolai metindo anna mala nadadiangannä' änä' anna deenni kao duka' peänäsangku.” ");
INSERT INTO ptu_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Iya nabeemmi Yakub napobaine indo sabua'na anna napasolai metindo. ");
INSERT INTO ptu_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Iya kebättäm Bilha lambi' undadiangammi Yakub mesa muane-ane. ");
INSERT INTO ptu_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Ma'kada Rahel naua: “Ma'papada-pada Puang Allataala anna nahingngiam pelauangku lambi' nabeemmä' mesa änä' muane-ane.” Iam too anna nasangaim Dan. ");
INSERT INTO ptu_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Kebättä oom Bilha sabua'na Rahel, iya undadiangam pole oom Yakub mesa muane-ane, änä' kaduanna nasibalii Bilha. ");
INSERT INTO ptu_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Ma'kada Rahel naua: “Masäem kupeä lalanna la umpentaloi kakangku, iya kao patalo.” Iam too anna nasangaim Naftali. ");
INSERT INTO ptu_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Tappana nasi'dim Lea tä' lium keänä', muuaammi Yakub: “Pobainei inde Zilpa sabua'ku.” ");
INSERT INTO ptu_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Indo Zilpa sabua'na Lea undadiangam Yakub mesa muane-ane. ");
INSERT INTO ptu_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Ma'kada Lea naua: “Kehongko'ä'.” Iam too anna nasangaim Gad. ");
INSERT INTO ptu_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Pissananna keänä' pole oom Zilpa kapenduanna, undadiangam oom Yakub mesa muane-ane. ");
INSERT INTO ptu_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Iya ma'kada oom Lea naua: “Tä' deem pada samasannannä', tä' mala tala nauaannä' sabaineku: ‘To masannam.’” Iam too anna nasangaim Asyer. ");
INSERT INTO ptu_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Tappana matäsä' gandum wattunna la diäläi, le'ba'um ma'lao-lao Ruben lako pa'belasam. Iya ullambi'um sahhupa tanangam si dipopakuli, iya naalam anna nababaanni indona. Tappana naita Rahel, iya muuaammi Lea: “Beennä' kao saidi' itim tanangam pakuli indo nalambi' änä'mu.” ");
INSERT INTO ptu_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Sapo' natimba'i Lea naua: “Tä' liupaka tiko ussanga mualangko muaneku? Anna temo la umpelau oom inde tanangam pakuli nabeennä' änä'ku?” Nauam Rahel: “Maka' umbeennä' itim tanangam pakulinna änä'mu, iya manii too bengi iko opi napasola metindo Yakub.” ");
INSERT INTO ptu_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Sulei Yakub kahubem, natammuim Lea anna nauaanni: “La inde opaki' too sola metindo mani bengi le? Aka puham kusahoi Rahel kubeem tanangam pakuli indo nalambi' änä'ku.” Iya solam metindo indo bengi eta too. ");
INSERT INTO ptu_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Iya kebättä oom Lea aka nahingngiam Puang Allataala pa'sambajanna lambi' undadiangam pole änä' Yakub kalimanna. ");
INSERT INTO ptu_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Ma'kada Lea naua: “Nabeem pole omä' Puang Allataala änä' bala' penabangku aka kubeem Zilpa muaneku napobaine.” Iam too anna nasangaim indo änä'na, Isakhar. ");
INSERT INTO ptu_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Iya kebättä pole oom Lea lambi' undadiangam Yakub änä' kaannanna. ");
INSERT INTO ptu_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Naua oom Lea: “Tä' deem pada samapia inde hongko' nabeennä' Puang Allataala. La napa'kasalleimä' too pole' muaneku aka kudadiangammi änä' annam, sangngim muane.” Iam too anna nasangaim indo änä' kaannanna Zebulon. ");
INSERT INTO ptu_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Puhai ia too keänä' pole oom Lea undadiam mesa baine-ine, iya nasangaim ia Dina. ");
INSERT INTO ptu_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Indo Rahel nakilalaim duka' Puang Allataala, nasuhum nahingngiam pelauanna lambi' la malam duka' undadiam änä'. ");
INSERT INTO ptu_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Iya kebättäm Rahel lambi' undadiam mesa muane-ane. Iya nauam Rahel: “Nasamboiammä' sihi'ku Puang Allataala.” ");
INSERT INTO ptu_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Iya nasangaim Yusuf, aka naua: “Umba-umba aka nahängänniam polepä' DEBATA mesa änä' la muane.” ");
INSERT INTO ptu_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Tappana puha keänä' Rahel undadiam Yusuf, iya melaum Yakub lako Laban naua: “Kela mala anna umpäbäiä' ma'pasule lako tondä' kadadiangku. ");
INSERT INTO ptu_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Anna umpäbäiä' umbaba ingganna baineku sola änä'ku, aka puham kuasaiam pala'ku, anna kualloiam boko'ku kupengkähängangko.” ");
INSERT INTO ptu_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Sapo' natimba' Laban naua: “Pehingngii siai too tula'ku, maka' muua iko duka', tä'pä' la umpellei aka situhu' potikangku natamba'ä' DEBATA aka iko napolalam. ");
INSERT INTO ptu_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Dadi tula' mammi la pada umba kubeengko sahomu.” ");
INSERT INTO ptu_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Iya natimba'im Yakub naua: “Iko hi tia la muissanni, aka tä'ungko la kupa'tulasam kapandasangku nasuhum membea' olo'-olo'mu. ");
INSERT INTO ptu_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Aka indo anna tä'pä' sule, tä'pi susi kullemu. Sapo' temo to makakangko. Ia anna natamba'ko DEBATA aka pallima'ingku napolalam. Dadi pihampi kao la malaä' umpengkähängam dapo'ku?” ");
INSERT INTO ptu_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Iya nauam Laban: “Iya aka isanga la kubeengko?” Natimba'im Yakub naua: “Tä' manggi' deem aka-aka umbeennä', sapo' la tontä kukambisangko dombamu. Anggam ia la deem pelauangku matim ke malai. ");
INSERT INTO ptu_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Allo temo la umpäbäiä' ma'lao-lao tama alla'-alla'na dombamu anna kusähä'i ingganna änä' domba malotäna, anna ingganna domba sola beke dotinna anna buhitti'na. Iam too la mendadi sahoku. ");
INSERT INTO ptu_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Ia too la mendadi tanda kamaloloangku illaam allo la taoloinna. Aka maka' suleko dako' umpahessa sahoku anna muitam deem beke tä' doti anna tä' buhitti' anna änä' domba tää'na malotä, la muissammi too muua: ‘Pabokona.’” ");
INSERT INTO ptu_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Natimba' Laban naua: “Io, tapateemmi too.” ");
INSERT INTO ptu_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Sapo' napasähä' yolo Laban indo allo eta ingganna beke dotinna anna buhitti'na. Susi toi domba malotä napasehe anna ussuai änä'na najagai. ");
INSERT INTO ptu_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Mane nababai lao indo olo'-olo' umpellei Yakub, tallungngallo mellao mane tohhoi. Anna indo tohhona nakambi' ia Yakub. ");
INSERT INTO ptu_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Iya namaja-maja duka' Yakub muala täke tubona kaju hawar, kaju badam, anna kaju berangan anna naäläi kuli'na nasoha-soha sampe masuha' diita. ");
INSERT INTO ptu_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Mane napake'de'i dio indo pahabam si natingngajoinna indo bekena sola dombana ke mangngihu'i. Aka si sulei too muihu', sibihä-bihäim eta ke lambi' oom wattunna. ");
INSERT INTO ptu_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Dadi maka' ma'laki oom indo olo'-olo' dio sikahuku' indo täke kaju masuha', iya keänä' oi too, dotika, ma'balo-baloka, buhitti'ka. ");
INSERT INTO ptu_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Mane napasehei Yakub indo änä' domba, anna indo domba senga' napopengngolo lakoi ia indo ingganna domba dotinna anna malotäna Laban. Napateemmi too Yakub uhhempum indo la napotabana anna tä'i napasihau indo tabana Laban. ");
INSERT INTO ptu_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Anna maka' too indo oom olo'-olo' to mapia tubona ma'laki, naala oom Yakub indo täke kaju masuha' anna napadioi indo si napengngoloi ke mangngihu'i anna malai sikahuku' ke ma'lakii. ");
INSERT INTO ptu_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Sapo' maka' olo'-olo' malamma sule, iya si tä' ia napadio indo täke kaju masuha' indo si natingngajoinna, nasuhum ingganna malammana indo olo'-olo' tabana ia Laban. Anna ingganna mapia tubona tabana ia Yakub. ");
INSERT INTO ptu_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Susim too lalanna anna sugi'i Yakub muampuam buda beke, domba, unta, keledai, anna buda sabua'na muane anna baine. ");
INSERT INTO ptu_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Pissananna naissam Yakub tula'na änä'na Laban naua: “Naala asammi Yakub kullena ambetaa'. Ingganna katomakakaanna buttu dio mai kullena ambetaa'.” ");
INSERT INTO ptu_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Anna naita toi Yakub penabanna Laban tä'um tontä lako kalena. ");
INSERT INTO ptu_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Iya ma'battakadam DEBATA lako Yakub naua: “Pa'pasulengko lako botto litä'na ambemu sola kasahapuammu aka la kuolaam dako tia.” ");
INSERT INTO ptu_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Puhai ia too, umpopetambaim Rahel sola Lea Yakub anna mala napellambi'i dio pa'kambisanna. ");
INSERT INTO ptu_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Tappana silambi', napa'tula'im Yakub naua: “Kuita penabanna ambemua' senga'um, tä'um si susi inde dio mai lako kaleku. Sapo' naundu'ä' anna naolaam Puang Allataala to napenombai ambeku. ");
INSERT INTO ptu_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Anna la dipa'tulasampokoka' umba susi hesoku lako ambemua' inde dio mai. ");
INSERT INTO ptu_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Sapo' si napalilingam liu hä' tangnga' lambi' pembudam umpadende sahoku. Sapo' tä' napäbäi Puang Allataala la nakadakeiä'. ");
INSERT INTO ptu_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Aka maka' too naua oom ambemua': ‘Beke buhitti' la sahomu,’ iya beke buhitti' asam oom too dadi. Anna maka' too naua: ‘Beke ma'balo-balo la sahomu,’ iya beke ma'balo-balo oom too dadi. ");
INSERT INTO ptu_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Dadi napateemmi too Puang Allataala muala olo'-olo'na ambemua' anna napadokkoannä' lisu pala'ku. ");
INSERT INTO ptu_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Wattunna anna la ma'lakii olo'-olo', kupangngimpim kuita ingganna beke laki sule ma'bihä sangngim beke masuha', buhitti' anna ma'balo-balo. ");
INSERT INTO ptu_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Anna napalosaiä' malaika'na Puang Allataala illaam indo pangngimpi naua: ‘O Yakub.’ Iya kutimba'im duka' kuua: ‘Indeä' Debata.’ ");
INSERT INTO ptu_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Iya ma'kada pole oom indo malaika' nauaannä': ‘Petua'i! Eta siam too lako beke laki mahassam ma'bihä sangngim masuha', buhitti', anna ma'balo-balo. Abana too kupateengangko aka kuita asammi pa'pogausanna Laban lako kalemu. ");
INSERT INTO ptu_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Kaom too Puang Allataala to puha umpa'paitaam kaleku matim dio Betel. Eta too umpake'de'ko mesa batu untolloi minnä' umpotanda pengkilalaam. Anna eta toi duka' muongei ma'samaja lako kaleku. Dadi temo pa'kalili'ungko ammu pa'pasule lako botto litä'mu.’” ");
INSERT INTO ptu_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Iya natimba'um Rahel sola Lea naua: “Aka tä'um too kami' duka' deem la kipomana' kullena ambeki. ");
INSERT INTO ptu_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Aka nahekem to sulengkam to kami', aka tanda lakona napobalusammakam anna pada indo natahima puha asammi napake. ");
INSERT INTO ptu_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Anna indo katomakakaanna ambeki naäläi Puang Allataala, setonganna tabaki hi too kami' sola änä'ki. Dadi pogau'i aka napahesangko Puang Allataala.” ");
INSERT INTO ptu_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","18","Iya ma'kalili'um Yakub la ma'pasule lako Ishak ambena dio lembäna Kanaan. Ingganna bainena sola änä'na napopessäke längäm unta anna uhhambai ingganna olo'-olo'na anna umbaba ingganna ebanganna indo pallolonganna dio Padan-Aram. ");
INSERT INTO ptu_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Tappana la mengkalao kalei, iya le'ba'um Laban unggontinni bulu dombana. Etam anna le'ba'i Rahel umboko indo tau-tau si napa'debatai ambena si diuaam to si ungkambi' kasahapuam. ");
INSERT INTO ptu_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Iya naakkalanni Yakub indo Laban to Aram, tä' napaissanni pengkalaoanna. ");
INSERT INTO ptu_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Iya muala asammi kullena sola ingganna ebanganna anna napasihha'i le'ba' ullambam salu Efrat lu lako ongeam tipatanete isanga Gilead. ");
INSERT INTO ptu_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Tama ham allo katallunna lessu'na Yakub mane naissanni Laban naua: “Le'ba' membuni hia päläe' Yakub!” ");
INSERT INTO ptu_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Iya uhhempum siaham solasubunna muane anna le'ba'i muula' Yakub. Pitu allona mellao mane ullambi'i Yakub dio ongeam tipatanete isanga Gilead. ");
INSERT INTO ptu_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Bengii sulem Puang Allataala umpellambi'i indo Laban to Aram napalosai illaam pangngimpi naua: “Pissa'-pissa' ai la deengko umpakahea'-hea' Yakub moi la tula' sabatta le.” ");
INSERT INTO ptu_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Wattu eta too puham umpake'de' bahunna Yakub yabo indo ongeam tipatanete. Tappana ullambi' Yakub Laban, iya umpake'de'um duka' bahunna eta sola solasubunna. ");
INSERT INTO ptu_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Puhai, iya ma'tula'um Laban lako Yakub naua: “Akanna muakkalanniä' lambi' le'ba' bäbäko umbaba buni änä'ku anggasanna to umpamuhu? ");
INSERT INTO ptu_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Akanna umbuniangannä' tä' umpaissanni pengkalaoammu? Aka kela umpaissanniä', akanna tala kupäbäiko lao masannam nalahu to menani, to ma'gändä, anna to ma'katapi? ");
INSERT INTO ptu_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Sapo' palla' iko penabammu tä' umpäbäiä' muudum yolo ampoku sola änä'ku. Mengkalao to maho hako iko. ");
INSERT INTO ptu_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Setonganna moi aka la kupogausangko, sapo' sabengi napakilalaä' Puang Allataala to napenombai ambemu naua: ‘Deem aia' la umpakahea'-hea' Yakub.’ ");
INSERT INTO ptu_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Kuissam kuua: ‘Ia anna le'ba' bäbängko, aka mamalli' sugali'ungko lako ambemu. Sapo' akanna umbokoko tau-tau to si ungkambi' kasahapuangku?’” ");
INSERT INTO ptu_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Natimba' Yakub naua: “Setonganna mengkalao bäbää' tä'ko deem kupasaha' aka mahea'ä' kuua: ‘Uhhuntu'iko manii sule baineku aka änä'mu ka iko.’ ");
INSERT INTO ptu_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Anna indo tau-tau muuaannä': ‘Umboko,’ maka' deem ullambi' lako inde mai tau, la dipatei ia. Dadi pahessa asanni aka-akangku, nasa'bii inde mai kasahapuam. Maka' too ke deenni ullambi', alam too.” Aka tä' naissam Yakub naua Rahel dia umbokoi indo tau-tau. ");
INSERT INTO ptu_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Iya le'ba'um Laban tama bahunna Yakub anna nakängkäi. Puhai, lu tama opi bahunna Lea mane tamai bahunna indo dua sabua' to napobaine Yakub. Sapo' tä' deem nalambi' indo tau-tau. Katampasanna lu tama ongeanna Rahel. ");
INSERT INTO ptu_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Sapo' puha nabuni Rahel indo tau-tau napalutama ibi'na lapi' unta dio sali mane naokko'i yabona. Nakängkä asam Laban indo aka-akanna Rahel sapo' tä' deem nalambi'. ");
INSERT INTO ptu_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Iya nauam Rahel lako ambena: “Sa'baha'ko ambe', daa ungkeaha' aka tä'ä' mala ke'de' ullaoanni manappako temo aka nalambi' oom bulangku.” Napaellä' Laban napeä indo tau-tau sapo' tä' deem nalambi'. ");
INSERT INTO ptu_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Iya keaha'um pole' Yakub lako Laban naua: “Kakadakeam aka hi kao kupogau'? Aka sugali' di kao kasalaangku anna muula'ä'? ");
INSERT INTO ptu_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Puha asammi ungkängkä pahuhungku, iya umbam indo anummu pa'de? Paokko'um tentomai dio olona inde mai kasahapuanta anna mala naita asam makalesona mennanta malolo! ");
INSERT INTO ptu_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Dua pulom taunna kupa'kambisangko lambi' tä' mammi too deem la keänä' tassala dombamu sola bekemu. Anna tä' toi deem la kutunu moi la mesam beke lakimmu. ");
INSERT INTO ptu_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Ingganna naandena to peande tä' too kao deem la kutulasangko anna puha oom kubala'i. Susi siam indo nabokona tau naala bengi anna naala allo, kubala'i asam too aka si untuntu'. ");
INSERT INTO ptu_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Tä' deem si kupesi'dinni mapana'na allo ke masiäi anna dingim ke bengii, lambi' deemmä' si tä' siita kamammasam. ");
INSERT INTO ptu_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Kupetuttu'i dua pulo taunna kuolaam ma'pateem. Aka sapulo appa' taunna kuolaam kupengkähängangko ussaho dua änä'mu anna annam polepi taunna kuolaam ussaho indo beke sola domba umbeennä'. Ia toopi too pembuda umpadende sahoku. ");
INSERT INTO ptu_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Kela tä'i naundu'ä' Puang Allataala to napenombai Abraham anna to napenombai anna nakahea' ambeku Ishak, tä' mala tala ussua bäbää' lao ma'pala' lo'bä. Sapo' Puang Allataala puha muitai sussaku anna hesoku, nasuhum napalosaingko sabengi kattuanna.” ");
INSERT INTO ptu_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Iya natimba'im Laban naua: “Setonganna itim dua bainemu, Yakub, bassim änä'ku anna ingganna änä'na sangngim ampoku. Anna ingganna itim domba sola beke, kao asam muampuanni. Dadi pada inde lako aka-aka taitaa', sangngim kao puäna. Sapo' tä' deem lalanna la kuanda'-anda'i inde mai änä'ku sola ingganna peänäsanna. ");
INSERT INTO ptu_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Dadi mapiam ia ke tapadeenni kasitallisam anna tatombonni batu mendadi tanda kasitallisanta.” ");
INSERT INTO ptu_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Iya naalam Yakub mesa batu naosä' la mendadi tanda pengkilalaam. ");
INSERT INTO ptu_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Mane ma'kadai Yakub lako kasahapuanna naua: “Tombongangkia' batu.” Iya naalaim duka' anna natombonni. Puhai natombom indo batu, pada-padam mangngande dio sa'dena. ");
INSERT INTO ptu_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Iya nasangai ia Laban indo tombongam batu Yegar-Sahaduta. Sapo' nasangai ia Yakub Galed. ");
INSERT INTO ptu_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Iya ma'kadam Laban lako Yakub naua: “Iam too inde tombongam batu la mendadi tanda pengkilalaanta napahandu' allo temo.” Iam too anna disangaim indo ongeam Galed. ");
INSERT INTO ptu_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Mane naua polei Laban: “DEBATA hi too la unjagaiki' teem patomali moi anna sikambelaki'.” Iam too anna disangaim duka' indo ongeam Mizpa. ");
INSERT INTO ptu_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Anna naua polepi Laban: “Maka' deem kende' illaam penabammu la ungkahidi' inde mai änä'ku battu la muala poleko baine senga', moi la tä' deem muitako, kilalai Puang Allataala too la muita liuki'. ");
INSERT INTO ptu_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Anna indem ia batu kutombom sola batu kuosä' mendadi tanda illaam alla'ta. ");
INSERT INTO ptu_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Dadi susi inde tombongam batu teem inde batu diosä' la mendadi tanda pengkilalaanta tala kao anna tala iko la untekkai umbaba pattuju kadake. ");
INSERT INTO ptu_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Aka Puang Allataala to napenombai Abraham sola Nahor anna ambena la ma'pemalolo.” Iya ma'pindam Yakub naua: “Sola sanganna Puang Allataala to nakahea' Ishak ambeku, inde kasitallisanta la kuanda'i.” ");
INSERT INTO ptu_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Iya napamateim mesa tunuam anna napehumalasanni yabo indo tanete, anna untambai ingganna kasahapuanna mangngande pada-pada. Puhai, ma'bengiipi yabo indo tanete. ");
INSERT INTO ptu_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Tappana masiäi mebengngi'-bengngi'pi, iya muudummi änä'na sola ingganna ampona Laban anna napa'lambeanni mane ma'pasulei lako Haran. ");
INSERT INTO ptu_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Tappana umpatahhu' pa'laoanna Yakub, iya natammuim sanaka-naka malaika'na Puang Allataala. ");
INSERT INTO ptu_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Pissananna naita Yakub indo malaika', iya nauam: “Inde pebahunganna Puang Allataala.” Iam too anna nasangaim Yakub indo ongeam Mahanaim. ");
INSERT INTO ptu_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Puhai ia too, ussuam sanaka-naka tau mendiolo umpellambi'i Esau kakanna lako Seir battu diua Edom. ");
INSERT INTO ptu_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Naua Yakub ma'pakahi'di lako indo ingganna to nasua: “Uaanni puäku Esau: susi inde tula'na sabua'mu Yakub: ‘O puäku, si dioä' banuanna Laban mentihuham sule lako temo. ");
INSERT INTO ptu_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Tentomai deemmi kuampuam sapim, keledai, domba, beke, anna sabua' muane anna baine. Anna kupalambi'iko inde kaheba umba ke uhhäntängannä' bua anna malaä' untahima manappa.’” ");
INSERT INTO ptu_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Tappana ma'pasulei indo to nasua Yakub nauaammi: “Puhangkam le'ba' umpellambi'i Esau kakammu. Temo mahassammi muola lalam natammuiko umpasola appa' hatu' tau.” ");
INSERT INTO ptu_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Nahingnginna Yakub ia too tappa tinggi'gi' mahea' anna manangnga penabanna. Iya namaja-majam napa'dua indo taunna. Susi toi duka' ingganna dombana, bekena, sapinna, anna untana. ");
INSERT INTO ptu_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Aka naua inabanna: “Maka' sule Esau anna nagasa'i sabaheam, iya malapi lahi sabaheam.” ");
INSERT INTO ptu_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Anna mane ma'sambajam Yakub naua: “O Puang Allataala to napenombai neneku Abraham anna ambeku Ishak. O DEBATA, Iko puha muuaannä': ‘Pa'pasuleko lako bottomu anna kasahapuammu anna la kuolaangko.’ ");
INSERT INTO ptu_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Tä'ä' la sihatam untahima ingganna pa'kamasemu sola kamanontongammu to puha umpogausannä'. Aka indo anna mengkalaoä' umpellei bottoku ullambam inde Salu Yordan, tä' deem aka kubaba sulibanna tekkengku. Tentomai ma'pasulemä' umpasola inde dua lengkoam tau sitonda olo'-olo'. ");
INSERT INTO ptu_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Kupelau sola ponno penaba anna ullappasannä' dio mai aha'na kakangku Esau, aka mahea'ä' sule manii napateiä' sola baineku anna ingganna änä'ku. ");
INSERT INTO ptu_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Aka puha muuaannä': ‘La kuolaangko anna la buda pessubummu, lambi' tä' deem tau la umbelai naissa' aka la susi budanna bungim dio bihim le'bo'.’” ");
INSERT INTO ptu_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Iya ma'bengim Yakub dio. Mebengngi'i mualam sabaheam olo'-olo'na la nabeem Esau kakanna. ");
INSERT INTO ptu_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","Indo la nabeem, dua hatu' beke bihä, dua pulo beke laki, dua hatu' domba bihä, dua pulo domba laki, ");
INSERT INTO ptu_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","tallu pulo unta bihä kalaoanna umpasusu änä'na, appa' pulo sapim bihä, sapulo sapim laki, dua pulo keledai bihä, anna sapulo keledai laki. ");
INSERT INTO ptu_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Nabahe-bahem indo olo'-olo' pantam napopa'mesa mane nabeenni lako sabua'na tungga' najagai. Mane nauai: “Pendiolongkoa' lao sapo' la muäto'a' pellaomu, sallaoam oi too lalla oom alla'na solana.” ");
INSERT INTO ptu_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Anna ma'pakahi'dii Yakub lako indo sabua'na handam mendiolo naua: “Maka' sitammuko kakangku Esau anna nakutanaiko naua: ‘Menna puämu? La umbako? Menna puäna inde mai olo'-olo' uhhambaa'?’ ");
INSERT INTO ptu_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","La muuaam: ‘Olo'-olo'na Yakub sabua'mu la nabeengko. Anna indo Yakub diom duka' mai natuhu'kam.’” ");
INSERT INTO ptu_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Susi siam duka' pepakahi'dinna lako sabua' to mentuhu' kaduanna, katallunna anna ingganna tau to nasua uhhamba indo olo'-olo' naua: “La susi siam tula'mu lako Esau ke ullambi'i. ");
INSERT INTO ptu_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Anna la muuaa': ‘Sabua'mu Yakub diom duka' mai boko'ki.’” Aka napikki' Yakub naua: “Iam too inde pa'pebeem la umpamehe aha'na Esau. Umba-umba aka malaä' naihusam uwai sumule.” ");
INSERT INTO ptu_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Dadi napa'pakatuam yolo indo olo'-olo' pa'lalam penabanna anna ma'bengipi ia dio indo to naongei mebahum. ");
INSERT INTO ptu_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Bengi eta too bangom Yakub anna umpasolai lao bainena dua anna baine lolä'na dua anna sapulo mesa änä'na ullambam salu Yabok. ");
INSERT INTO ptu_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Puhai napalambam, ma'pasulem Yakub anna umpopebaba asanni aka-akanna dipalambam. ");
INSERT INTO ptu_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Sapo' tohho ia Yakub mesa-mesanna. Iya sulem mesa muane sibobo' Yakub sule lako moni mäne'. ");
INSERT INTO ptu_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Tappana nasi'dim indo tau tä' la patalo, iya uhhaka'um palona Yakub sampe silesa too' apanna. ");
INSERT INTO ptu_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Anna mane ma'kada indo tau naua: “Lappa'ä' aka la masiäm.” Sapo' natimba' Yakub naua: “Tä'ko la kulappasam ke tä'i umpa'lambeannä' yolo.” ");
INSERT INTO ptu_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Mekutanam indo tau naua: “Aka sangammu?” Naua: “Isangaä' Yakub.” ");
INSERT INTO ptu_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Iya nauam indo tau: “Tä'ungko la disangai Yakub aka puhangko umbali Puang Allataala anna hupatau, iya pataloko. Iam too anna la disangaingko Israel.” ");
INSERT INTO ptu_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Iya naua oom Yakub: “Tulasannä' duka' sangammu.” Sapo' natimba'i indo tau naua: “Tä' manggi' umpekutanaam sangangku.” Anna mane untamba' Yakub. ");
INSERT INTO ptu_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Iya nauam Yakub: “Puhamä' siita Puang Allataala, iya mala mammapä' tubo!” Iam too anna nasangaim indo ongeam Pniel. ");
INSERT INTO ptu_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Bihha'i allo umpelleim Pniel Yakub, sapo' heppä'um aka silesa too' apanna. ");
INSERT INTO ptu_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Iam too anna sule lako temo ingganna pessubunna Israel tä' lium ia muande bale too' apanna olo'-olo' aka too' apanna Yakub nahaka' Puang Allataala. ");
INSERT INTO ptu_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Pissananna mennenne' lao Yakub, iya naitam sule Esau natuhu' taunna appa' hatu'. Nasuhum umbahe-bahem änä'na lako Lea, lako Rahel, anna lako indo dua baine lolä'na. ");
INSERT INTO ptu_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Umpopendiolom indo dua baine lolä'na sola ia duka' änä'na, mane natuhu'i Lea sola änä'na anna mane Rahel sola Yusuf handam ibundi. ");
INSERT INTO ptu_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Mane mellaoi Yakub, ia handam dio olo untammui kakanna. Tappana la sidundui, napahandu'um Yakub umpenombai kakanna. Pempitu menomba mane sitammui. ");
INSERT INTO ptu_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Sapo' lumumpa' siaham Esau uhhopäi Yakub nakalapu'i bahokona naudum anna sisahhoanni adinna. ");
INSERT INTO ptu_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Tappana naita Esau indo baine sola änä'-änä', iya nauam: “Menna inde mai umpasola?” Natimba' Yakub naua: “Änä'-änä' pa'kamasena Puang Allataala tama kaleku, puäku.” ");
INSERT INTO ptu_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Puhai, bassim le'ba'um duka' lako indo baine lolä'na sola änä'na umpenombai Esau. ");
INSERT INTO ptu_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Anna mane Lea sola ingganna änä'na, katampasanna Rahel sola Yusuf, änä'na. ");
INSERT INTO ptu_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Iya mekutanam Esau naua: “Aka pattujummu anna deenni indo ingganna tau sola olo'-olo' ma'babangam pantam lao kusitammuam?” Natimba' Yakub naua: “La kupomasannangam penabammu.” ");
INSERT INTO ptu_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Iya nauam Esau: “O adingku, buda siam kao duka' kulleku, pokullem tiko duka' ia too.” ");
INSERT INTO ptu_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Natimba'im Yakub naua: “Tä' dako tia la ma'pateem, aka maka' ungkamasei si'daä' anna untahimaä' sule inde, iya la untahima hi tia duka' inde pa'lalam penabangku matim. Aka tappana kuita lindomu, kupasihhapam muitaä' lindona Puang Allataala aka tä' deem pada saungkaluseseiä'. ");
INSERT INTO ptu_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Dadi, la muala hi tia inde pa'lalam penabangku matim. Aka Puang Allataala ungkamaseiä' lambi' napalahuiä' ingganna kapahalluangku.” Iya mengkahumase lium Yakub lambi' natahimam duka' Esau indo pa'lalam penabanna Yakub. ");
INSERT INTO ptu_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Iya nauam Esau lako adinna: “Maingkoa' talao anna kuyoloangangkoa'.” ");
INSERT INTO ptu_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Sapo' natimba' Yakub naua: “O puäku, muitam inde mai änä'-änä' sangngim maluppu'pi. Anna la kupaela' inde mai domba sola sapim aka budapi kalaoanna sumusu änä'na. Maka' la dipasihha' dihamba, tä' la sangngallo mellao anna dappo'um. ");
INSERT INTO ptu_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Dadi pendiolongko too, puäku, anna kipaela'i kami' ibundi. Aka inde mai änä'-änä' sola sapim la unggantam lalam sakilambi'mupa dio Seir.” ");
INSERT INTO ptu_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Naua Esau: “Maka' susi, la kutampeangko sanaka-naka taungku.” Sapo' natimba' Yakub naua: “Tä'um tia manggi' umpasusi, assala'na masannammi penabammu untahimaä'.” ");
INSERT INTO ptu_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Iya mengkalao siam Esau indo allo eta too ma'pasule lako Seir. ");
INSERT INTO ptu_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Sapo' lu lako hia Sukot Yakub anna umpake'de'i banua dio anna umpebahungam duka' olo'-olo'na napentionganni. Iam too anna disangaim indo ongeam Sukot. ");
INSERT INTO ptu_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Napahandu'na Yakub mengkalao dio Padan-Aram, iya landa'um sitonda kamasakkeam lako Sikhem, dio lembäna Kanaan. Iya umpake'de'im bahunna sikahuku' kota Sikhem. ");
INSERT INTO ptu_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Indo litä' naongei mebahum naalli lako änä'na Hemor, ambena Sikhem, sahatu' doi' peha'. ");
INSERT INTO ptu_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Mane umpake'de'i ongeam pehumalasam eta, anna nasangai El Elohe Israel, kalembasanna Debatanna Israel, Puang Allataala. ");
INSERT INTO ptu_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Pissam wattu indo änä'na Yakub baine to nadadiangam Lea isanga Dina, le'ba' ma'saleo-leo sola baine to Kanaan. ");
INSERT INTO ptu_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Tappana naita Sikhem, änä'na Hemor, mesa to Hewi mendadi tomahaja illaam botto ia too, iya napellambi'im anna laoi nakondongam nabobo'. ");
INSERT INTO ptu_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Tä' deem pada saungkailui Dina, lambi' napeä lalanna umba ke malai napohäe duka' Dina. ");
INSERT INTO ptu_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Iya ma'kadam Sikhem lako Hemor ambena naua: “Kutanaiannä' indo baine aka mohäeä' la kupobaine.” ");
INSERT INTO ptu_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Naissam Yakub indo gau'na Sikhem puha ungkadakei Dina. Sapo' napengkamma'i aka muampaipi änä'na sulei dio mai pa'kambisanna. ");
INSERT INTO ptu_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Iya sulem Hemor ambena Sikhem umpellambi'i Yakub aka la napa'tula'i. ");
INSERT INTO ptu_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Iya suleim duka' ingganna änä'na Yakub muane dio mai pa'kambisanna. Nahingnginna kaha-kaha ia too sangngim tikkedu' anna mapi'di' penabanna lambi' keaha', aka indo gau'na Sikhem puha umbobo' änä' dahanna, tä' sihatam napogau' aka umpakasihi' to Israel. ");
INSERT INTO ptu_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Sapo' ma'kada Hemor naua: “Indo änä'ku Sikhem deem penabanna lako änä'mu, kupelau kela maelo'ko anta pasialai. ");
INSERT INTO ptu_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","La sipattuju manappaki' anna mala änä'ku anna änä'mu la siala-ala. ");
INSERT INTO ptu_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Anna malakia' tohho sola-sola illaam inde botto. Anna la beba'koa' umpise'i ongeam la muongeia' umpeä kulle.” ");
INSERT INTO ptu_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Iya ma'tula'um Sikhem lako ambena Dina sola änä' muanena naua: “Maka' untahimaa' inde pelauangku, iai too umpohäe iam kubeengkoa'. ");
INSERT INTO ptu_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Tula'ia' aka umpohäe anna la untulasam tooä' duka' sanaka sombanna. Aka la kuponnoi pada umpelau, assala'na maelo'koa' sipobaineä' inde änä' dahammua'.” ");
INSERT INTO ptu_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Sapo' napalilingam tangnga' indo änä' muanena Dina, aka indo Dina adinna puha nakadakei Sikhem. ");
INSERT INTO ptu_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Nasuhum ma'kada lako Hemor anna Sikhem naua: “Kiposihi' la kipasiala änä' dahangki to tadisunna'. ");
INSERT INTO ptu_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Anggam anna la kitahimai itim pelauammu ke muakuia' susikam. Kalembasanna inde tula'ki, ingganna muane illaam alla'-alla'mua' tä' mala tala disunna' asam. ");
INSERT INTO ptu_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Puhai too, iya kitahimam pole' pelauammu diona la siala-alakia'. La tohhokia' hapa' sola-sola anna la mendadikia' to mesa. ");
INSERT INTO ptu_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Sapo' maka' mokakoa' untahimai inde peadasangki, la mokakoa' disunna', iya la kibaba lao inde änä' dahangki.” ");
INSERT INTO ptu_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Iya natahimam Hemor sola Sikhem indo tula'na. ");
INSERT INTO ptu_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Nasuhum le'ba' siaham Sikhem nakähä ia too aka umpohäe sugali' änä'na Yakub. Anna indo Sikhem handam to dihingngiam illaam kasahapuam. ");
INSERT INTO ptu_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Iya le'ba'um Hemor sola Sikhem lako ongeam pa'hempungam dio ba'ba kota, anna umpa'tula'i issinna indo kota nauaam: ");
INSERT INTO ptu_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","“Ingganna to Israel to mesakia'. Dadi la tapäbäia' tohho illaam inde bottota sola-solakia' anna la beba' ullelei indo bottota; aka inde botto tä' deem pada samalobä la naongei. Malaa' tapobaine änä'na anna la mala duka' napobaine änä'taa'. ");
INSERT INTO ptu_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Sapo' anggam napohäe tohhokia' sola-sola ma'mesa illaam inde botto, ke taakuia' tatuhu'i mesa pelauanna naua: ‘Ingganna muane illaam alla'-alla'mua' la pahallu disunna' susi kabiasaangki.’ ");
INSERT INTO ptu_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Dadi la tatuhu'ia' indo pelauanna anna mala indekia' sola. Aka dako'i too ingganna olo'-olo'na sola pakkulleam senga'na la taampuam asanna'.” ");
INSERT INTO ptu_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Ingganna to ma'hempum eta too maelo' asam la untuhu'i pelauanna Hemor sola Sikhem sampe ingganna muane illaam indo kota disunna' asam. ");
INSERT INTO ptu_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Tallu bengii lessu'na, sangngim kaloasampi muane aka disunna'. Mengke'de' dua änä'na Yakub, kakanna Dina isanga Simeon anna Lewi, le'ba' muala pa'danna anna mengkamma-kamma'i le'ba' tama kota anna natepai pa'dam ingganna muane illaam. ");
INSERT INTO ptu_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Indo Hemor sola Sikhem napatei duka' anna umpasolai Dina umpellei banuanna Sikhem. ");
INSERT INTO ptu_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Puhai ia too, le'ba' asammi änä'na Yakub tama indo kota anna umpamuhu asanni issinna kota. Aka umpembalasam adinna puha nakadakei Sikhem. ");
INSERT INTO ptu_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Sangngim umpamuhu domba, sapim, beke, keledai, anna ingganna baham-baham, susi illaam kota teem lako ongeam senga'. ");
INSERT INTO ptu_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Muala ingganna baham-baham keangga' anna ingganna baine sola änä'-änä'. Naala asam issi banua illaam indo kota. ");
INSERT INTO ptu_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Ma'kada Yakub lako Simeon anna Lewi naua: “Poko'naa' iko mualaannä' saha-saha penaba aka la mekabassim too inde issinna botto. Indo ke umpamesai buku to Kanaan, to Feris, anna ingganna issinna inde pa'bottoam mebundu', dappo'kia' kita sahapu aka tä' dikia' pada umba.” ");
INSERT INTO ptu_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Sapo' natimba' naua: “Aka tä' kiaku la dipasusi passunda' adingki.” ");
INSERT INTO ptu_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Ma'battakada Puang Allataala lako Yakub naua: “Kaom too Puang Allataala to puha umpa'patandaam kaleku indo anna le'ba'ko umpembuniam kakammu Esau. Pa'kalili'ko ammu lako Betel, tohhoko dio anna umpake'de'ko mesa ongeam pehumalasam di Kao.” ");
INSERT INTO ptu_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","3","Iya nauam Yakub lako sahapunna sola lako ingganna pentuhu'na: “Pa'kalili'koa' aka la le'ba'kia' lako Betel. Diokia' too umpapiamä' ongeam pehumalasam längäm Puang Allataala to umpamoloiä' illaam kamasussaangku anna to ungkambi'ä' illaam pa'laoangku umba-umba kuongei. Sapo' tibe asannia' yolo indo tau-tau to si napa'debatai tau senga' anna umpomasehokoa' kalemu ammu bala'i asanna' pohebamu.” ");
INSERT INTO ptu_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Iya nahempummi indo tau-tau anna muäläi asanni antim-antinna nabeem Yakub nalamum dio too' kaju tumalumbum ma'sanga sikahuku' kota Sikhem. ");
INSERT INTO ptu_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Tappana mengkalao Yakub sola sahapunna anna pentuhu'na, iya napalambi'im Puang Allataala kamaheasam lako ingganna tau illaam pa'lembängam ia too, lambi' mahea'i muula' Yakub sola ingganna to napasola. ");
INSERT INTO ptu_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Iya landa'um Yakub sola ingganna to napasola lako lembäna Kanaan dio kota Betel (indo si diuaam yolona Lus). ");
INSERT INTO ptu_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Iya umpake'de'um ongeam pehumalasam anna nasangai El Betel. Aka etam too naongei Puang Allataala umpa'patandaam kalena lako Yakub indo anna le'ba'i umpembuniam kakanna. ");
INSERT INTO ptu_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Etam too mate Debora indo to si umpaliaha Ribka anna dilamum dio too' kaju tumalumbum ma'sanga, sau'na kota ia too. Iam too anna si diuaammi Too' Kaju Uwai Mata. ");
INSERT INTO ptu_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Tappana ma'pasule Yakub dio mai Padan-Aram, iya umpa'patandaam oom kalena Puang Allataala lako Yakub anna natamba'i. ");
INSERT INTO ptu_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Mane ma'kadai Puang Allataala naua: “Iko isangako Yakub, napahandu' temo tä'ungko la disangai Yakub, sapo' la disangaingko Israel.” Susim too Puang Allataala mueli' sanganna Yakub nasangai Israel. ");
INSERT INTO ptu_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Anna mane ma'kada polei naua: “Kaom too Puang Allataala To Handam Kuasa. La kupalohom banne taummu to la umpangngissi lao mobotto-bottoam, anna la buda mendadi tomahaja. ");
INSERT INTO ptu_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Anna indo pa'lembängam to puha kubeem Abraham sola Ishak la kubeengko sule lako pessubummu.” ");
INSERT INTO ptu_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Tappana puha, le'ba'um Puang Allataala umpellei indo ongeam naongei umpa'tula'i Yakub. ");
INSERT INTO ptu_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Iya muosä'um batu Yakub, tanda pengkilalaanna, mane natolloi anggur sola minnä' napehumalasam längäm Puang Allataala. ");
INSERT INTO ptu_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Mane nasangai Yakub indo ongeam naongei Puang Allataala ma'tula', Betel. ");
INSERT INTO ptu_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Puhai ia too le'ba'um Yakub sola ingganna to untuhu'i umpellei Betel. Tappana la landa' kalei lako Efrata, iya lambi'um wattunna la keänä' Rahel, sapo' mapahhi' keänä'. ");
INSERT INTO ptu_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Masäei mangnguhiba', tuttuam mapi'di' nasi'dim. Iya nauam indo to ma'pakeänä': “Pomatohoi penabammu Rahel aka la muane oo änä'mu.” ");
INSERT INTO ptu_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Sapo' abana inna la lambi'um ia tempona Rahel la mate. Tappana la kattu penabanna, iya nahakkusam siapi ussangai änä'na Ben-oni, sapo' nasangai ia ambena Benyamin. ");
INSERT INTO ptu_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Susim too kamateanna Rahel lambi' dilamum dio ampe' lalam lako Efrata. (Indo Efrata disangaim temo Betlehem). ");
INSERT INTO ptu_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Naosä'um batu Yakub natandaiam indo ku'bu'na Rahel anna da'da' liupi sule lako temo. ");
INSERT INTO ptu_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Puhai ia too, umpatahhu'um pa'laoanna Israel lambi' umpake'de' bahunna tando lakona Migdal-Eder. ");
INSERT INTO ptu_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Tappana tohhoi dio ongeam ia too, iya indo Ruben umpempakoi baine lolä'na ambena isanga Bilha. Kaha-kaha ia too naissam siam Israel. 35:22-26 Änä'na Yakub sapulo dua muane. ");
INSERT INTO ptu_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Lea undadiam Ruben (änä' uluana Yakub), Simeon, Lewi, Yehuda, Isakhar, anna Zebulon. ");
INSERT INTO ptu_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Rahel ia undadiam Yusuf anna Benyamin. ");
INSERT INTO ptu_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Bilha, sabua'na Rahel, undadiam ia Dan anna Naftali. ");
INSERT INTO ptu_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Zilpa, sabua'na Lea, undadiam ia Gad anna Asyer. Padam too inde peänäsanna Yakub muane dadi dio Padan-Aram. ");
INSERT INTO ptu_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Iya landa'um Yakub lako Mamre sikahuku' Kiryat-Arba (battu diua Hebron), ongeam naongei tohho Ishak, ambena. Ongeam iam too si naongei Ishak anna Abraham. ");
INSERT INTO ptu_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","29","Indo Ishak tä' deem pada samahendem. Sahatu' kahua pulo taunna tubo mane matei, lambi' le'ba' sungnga'na ma'mesa sola nene to naponene. Iya nalamummi Esau sola Yakub, änä'na. ");
INSERT INTO ptu_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Susi inde tulasanna peänäsanna Esau (biasa toi duka' diuaam Edom). ");
INSERT INTO ptu_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Esau umpobaine tallu to Kanaan: Ada, änä'na to Het isanga Elon, anna Oholibama, änä'na Ana, ampona Zibeon to Hewi, ");
INSERT INTO ptu_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","sola Basmat, adinna Nebayot bassim änä'na Ismael. ");
INSERT INTO ptu_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Indo Ada undadiam Elifas. Anna indo Basmat undadiam Rehuel, ");
INSERT INTO ptu_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","anna Oholibama undadiam Yeush, Yaelam, anna Korah. Iam too ingganna änä'na Esau nadadiangam bainena dio Kanaan. ");
INSERT INTO ptu_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Pissam wattu le'ba' Esau umpellei Yakub, adinna, lu lako botto senga'. Umpasola ingganna bainena sola änä'na muane anna baine anna ingganna issi banuanna. Susi toi ingganna dombana, bekena, sapinna, anna ingganna kullena indo pallolonganna dio Kanaan nababa asam. ");
INSERT INTO ptu_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Buda sugali' kullena nasuhum tä'um deem ongeam la mala naongei sola. Aka indo botto naongei tä'um sihua napa'kambi'i olo'-olo'na aka buda sugali'. ");
INSERT INTO ptu_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Iam too anna mentieli'um ia Esau, battu diua Edom, le'ba' lako ongeam tipatanete isanga Seir. ");
INSERT INTO ptu_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Indem ia tulasanna pessubunna Esau, nene kabuttuanna to Edom to tohho dio ongeam tipatanete isanga Seir: ");
INSERT INTO ptu_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Änä'na Esau nasibalii Ada isanga Elifas, anna nasibalii Basmat isanga Rehuel, bassim muane. ");
INSERT INTO ptu_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Elifas undadiam Teman, Omar, Zefo, Gaetam anna Kenas. ");
INSERT INTO ptu_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Deempi änä'na nadadiangam Timna baine lolä'na Elifas isanga Amalek. Iam too ampona Ada, bainena Esau. ");
INSERT INTO ptu_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Rehuel ia undadiam Nahat, Zerah, Syama anna Miza. Iam too ampona Basmat, bainena Esau. ");
INSERT INTO ptu_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Anna Oholibama änä'na Ana, ampona Zibeon undadiangam Esau änä' isanga Yeush, Yaelam anna Korah. ");
INSERT INTO ptu_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Indem ia änä'na sola ampona Esau nene to naponene to umpangngissi mobotto-bottoam: Elifas, änä' uluana Esau undadiam nene to naponene to Teman, to Omar, to Zefo, to Kenas, ");
INSERT INTO ptu_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","to Korah, to Gaetam anna to Amalek. Iam too peänäsanna Elifas pessubunna Ada, nasibalii Esau dio Edom. ");
INSERT INTO ptu_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Anna Rehuel ia, änä'na duka' Esau undadiam nene to naponene to Nahat, to Zerah, to Syama, anna to Miza. Iam too peänäsanna Rehuel, pessubunna Basmat, nasibalii Esau dio Edom. ");
INSERT INTO ptu_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Oholibama, bainena Esau undadiam nene to naponene to Yeush, to Yaelam, anna to Korah. Iam too peänäsanna Oholibama, indo änä'na Ana. ");
INSERT INTO ptu_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Iam too inde pessubunna Esau sangngim nene to naponene to Edom. ");
INSERT INTO ptu_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Indem ia änä'na Seir, to Hori, issi litä' dio Edom: Lotan, Syobal, Zibeon, Ana, ");
INSERT INTO ptu_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Disyon, Ezer, anna Disyan. Padam too inde peänäsanna Seir nene to naponene to Hori dio Edom. ");
INSERT INTO ptu_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Änä'na Lotan isanga Hori anna Heman. Solasubunna Lotan baine isanga Timna. ");
INSERT INTO ptu_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Änä'na Syobal isanga Alwan, Manahat, Ebal, Syefo anna Onam. ");
INSERT INTO ptu_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Änä'na Zibeon isanga Aya anna Ana. Ana iam too ullambi' kalimbuä kanam dio pohiallasam indo anna le'ba'i ungkambi' keledainna Zibeon ambena. ");
INSERT INTO ptu_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Änä'na Ana isanga Disyon anna Oholibama, baine ia. ");
INSERT INTO ptu_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Änä'na Disyon isanga Hemdan, Esyban, Yitran anna Keran. ");
INSERT INTO ptu_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Änä'na Ezer isanga Bilhan, Zaawan anna Akan. ");
INSERT INTO ptu_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Änä'na Disyan isanga Us anna Aran. ");
INSERT INTO ptu_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","30","Iam too inde nene to naponene to Hori: Lotan, Syobal, Zibeon, Ana, Disyon, Ezer anna Disyan situhu' kabuttuanna anna tadongkonganna dio pa'lembängam Seir. ");
INSERT INTO ptu_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","39","Indo anna tä'pi deem tomahajanna to Israel, deemmi ia tomahaja sibala'-bala' ma'pahenta dio Edom. Mate oi mesa, nabala' oom solana. Indo tomahaja isanga: Bela änä'na Beor buttu dio mai kota Dinhaba; Yobab änä'na Zerah buttu dio mai Bozra; Husyam buttu dio mai Teman; Hadad änä'na Bedad buttu dio mai Awit (iam too untaloi to Midian indo anna sibundu'i dio lembäna Moab); Samla to buttu dio mai Masreka; Saul to buttu dio mai Rehobot dio bihim salu; Baal-Hanan änä'na Akhbor; Hadar to buttu dio mai Pahu (bainena isanga Mehetabeel, änä'na Matred, ampona Mezahab). ");
INSERT INTO ptu_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","43","Anna indem ia sanganna botto anna kabuttuanna to umpangngissi Edom, pessubunna Esau: Timna, Alwa, Yetet, Oholibama, Ela, Pinon, Kenas, Teman, Mibzar, Magdiel anna Iram. Ia asammi too inde sanga dipakonaiam pessubunna anna tadongkonganna si mesa-mesa. ");
INSERT INTO ptu_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Indo Yakub si tohho dio lembäna Kanaan ongeanna ambena yolona. ");
INSERT INTO ptu_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Indem ia peänäsanna Yakub: Änä'na mesa isanga Yusuf mangnguhapi, mane sapulo pitu taunna dadinna, si ungkambisam dombana ambena sola-solai sanaka-naka kakanna, sangngim änä'na Bilha anna Zilpa bassim bainenapi duka' Yakub ambena. Ingganna gau' kadakena solasubunna si natula' asam Yusuf lako ambena. ");
INSERT INTO ptu_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Indo Israel umpakamaja puha ia Yusuf anna la änä' senga'na aka matua ham mane dadii. Pissam wattu napopepapiaam mesa baju tä' deem pada samapia. ");
INSERT INTO ptu_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Tappana naita solasubunna la'bi puha ia pa'pakamajanna ambena lako Yusuf, iya sangngim si nakabassim anna tä' si napa'kadai manappa. ");
INSERT INTO ptu_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Pissam wattu mangngimpi Yusuf. Indo pangngimpinna natula' lako solasubunna nasuhum tuttuam si nakabassii. ");
INSERT INTO ptu_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Aka ma'tula' Yusuf naua: “Pehingngiia' pangngimpingku: ");
INSERT INTO ptu_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Kuita mahassam diokia' kahi' bela' ungkutu'i gandum. Iya mellimbangommi pangkutu'ku, ke'de' längäm mane sule asanni kahi' pangkutu'mua' umpali'i umpenombai pangkutu'ku.” ");
INSERT INTO ptu_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Iya sangngim ma'kadam solasubunna lako naua: “Umbai' mohäeko battuam la untomahajaikanni le'? Umbai' mohäeko la ullumbäikam.” Iya saundu'um sangngim ungkabassi Yusuf aka indo pangngimpinna anna pa'tula'na. ");
INSERT INTO ptu_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Mane mangngimpi pole oi. Indo pangngimpinna natula' oo duka' lako solasubunna naua: “Mangngimpi omä': Kuita kahi' mata allo, bulam, anna sapulo mesa bintä sule kahi' menomba dio oloku.” ");
INSERT INTO ptu_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Tappana natulasam ambena sola solasubunna indo pangngimpinna, natappakadaim ambena naua: “Aka bäbä hia isanga itim pangngimpimmu iko? La maakam ia susi la solakam indomu anna solasubummu la menomba dio olomu?” ");
INSERT INTO ptu_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Sangngim ungkembuhui Yusuf indo solasubunna, sapo' napaillaam penaba ia ambena anna si napikki' liu naua: “Aka amo la kalembasanna?” ");
INSERT INTO ptu_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Pissam wattu le'ba'i oom solasubunna Yusuf ungkambi' dombana ambena, lu lako sikahuku' Sikhem. ");
INSERT INTO ptu_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","14","Tappana sanaka amoi benginna dio, iya nauam Israel lako Yusuf: “Dioi sikahuku' Sikhem solasubummu ma'kambi' domba. Dadi laoko lako pesi'dinnii, mane suleko untulasannä'.” Natimba' Yusuf naua: “Io ambe'.” Iya mengkalao siaham umpellei banuanna dio lembäna Hebron lu lako Sikhem. ");
INSERT INTO ptu_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Mahassanni ma'lao-lao lako mesa pa'kambisam dio Sikhem, iya silambi'um mesa tau. Iya mekutanam indo tau naua: “Aka hi iko umpeä?” ");
INSERT INTO ptu_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Natimba'im naua: “Umpeää' solasubungku. Muita haka iko naongei ungkambi' dombana?” ");
INSERT INTO ptu_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Nauam indo tau: “Io kuita, sapo' le'ba'im. Aka kuhingngi sipa'tula'-tula' naua: ‘Talulakoa' Dotan.’” Le'ba' siam Yusuf naula' lako, iya nalambi'um dioi Dotan. ");
INSERT INTO ptu_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Sapo' indo solasubunna, mane muita mambela Yusuf anna sipattuju-tujum la napatei. ");
INSERT INTO ptu_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Sipa'tula'-tula' naua: “Petua'ia' sulem to si mangngimpintaa'. ");
INSERT INTO ptu_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Tapateia' pole' anna tatibeia' dokko inde pambo'bä', mane tauaia': ‘Nasakka olo'-olo' to peande.’ Anna tapetua'ia' la maaka amo duka' susi indo pangngimpinna.” ");
INSERT INTO ptu_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Tappana nahingngi Ruben pattuju ia too, aka mohäe ia la nalappasam, iya nauam: “Daa tapateia', ");
INSERT INTO ptu_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","daa umpatitolloia' hahana. Tibe mammia' dokko itim pambo'bä' inde pohiallasam, sapo' daa untappai limaia'.” Illaam penabanna Ruben la umpesäkäi Yusuf dio mai pattuju kadakena solasubunna, anna la napopa'pasulei lako ambena. ");
INSERT INTO ptu_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Ia sia sulena Yusuf umpellambi'i solasubunna, naäläi siaham solasubunna indo baju mapi'dä'na illaam mai kalena. ");
INSERT INTO ptu_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Mane untibei Yusuf dokko pambo'bä' takeuwai. ");
INSERT INTO ptu_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Mahassannii mangngande, iya muita mambelam molengko to Midian pessubunna Ismael sola-sola untana unteke' dama', sahhupa pakuli isanga balsam, anna dama' si bubanau' isanga mur, buttu dio mai Gilead la lu lako Mesir ma'balu'. ");
INSERT INTO ptu_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Ma'kadam Yehuda lako solasubunna naua: “Akam gunana kela umpateikia' adinta mane tabuniia' hahana? ");
INSERT INTO ptu_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Tabalu' dia' lako to Midian sapo' daa tatappai limaia' aka buku hahataa'.” Iya nahingngiam solasubunna indo tula'na. ");
INSERT INTO ptu_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Tappana liu indo to Midian, iya muäläim sule Yusuf dio mai indo pambo'bä' anna nabalu'i dua pulo doi' peha' lako indo to Midian. Iya napasolam lako Mesir. ");
INSERT INTO ptu_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Tappana masäe-säe lessu'na, iya mane sule hia Ruben lako indo bujum. Napetua', iya ke pa'dem ia Yusuf dio. Umpessepäsammi bajunna aka mapi'di' penabanna ");
INSERT INTO ptu_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","mane umpellambi'i solasubunna anna nauai: “Pa'dem indo änä'-änä' dio! Iya akam la kupogau'?” ");
INSERT INTO ptu_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Mane sikaumpatei mesa beke anna naalai indo baju mapi'dä'na Yusuf anna napapuläii hahana. ");
INSERT INTO ptu_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Mane nababai indo bajunna Yusuf lako ambena anna nauai: “O Ambe', kilambi' inde baju dio pa'kambisam, pahessai taia mammaka bajunna änä'mu?” ");
INSERT INTO ptu_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Tappana napahessa Yakub indo baju, iya nauam: “Tungka iam too inde bajunna änä'ku, mannassa pa'dem tia, puham nasakka anna nasepä'-sepä'i olo'-olo' to peande.” ");
INSERT INTO ptu_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Umpessessesammi bajunna Yakub aka husa', anna ma'poheba bahatai. Ma'minggu-minggu naolaam ma'bahata aka kamapi'disanna illaam kamateanna Yusuf, änä'na. ");
INSERT INTO ptu_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Ingganna änä'na muane anna baine sule asam umpakahangai, sapo' moka dipakahanga aka naua: “La ma'bahata liuä' lambi' lako mateku sule lako ullambi'ä' ongeanna änä'ku illaam kamateam.” Iya sumahho lium ussahhoi änä'na. ");
INSERT INTO ptu_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Indo Yusuf nabalu' pole indo to Midian lako mesa to mengkähä illaam banuanna Firaun tomahaja dio Mesir, isanga Potifar. Indo Potifar kapalana sohodadu to unjagai banuanna Firaun. ");
INSERT INTO ptu_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Yehuda ia wattu eta too, umpellei ingganna solasubunna anna le'ba'i umpellambi'i mesa to Adulam isanga Hira anna tohhoi sola. ");
INSERT INTO ptu_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Etam naongei Yehuda muita mesa änä' daha, änä'na Syua to Kanaan. Napobainem Yehuda baine ia too, anna napasolai metindo. ");
INSERT INTO ptu_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Iya kebättäm indo baine lambi' undadiam muane-ane, nasangai Er. ");
INSERT INTO ptu_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Puhai ia too kebättä oom indo bainena, iya undadiam pole oo muane-ane, nasangai Onan. ");
INSERT INTO ptu_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Puhai ia too, kebättä oom lambi' undadiam oom muane-ane, nasangai ia Syela. Dio Kezib Yehuda anna dadii Syela. ");
INSERT INTO ptu_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Iya mualam baine Yehuda napasialaam Er änä' uluana. Indo baine isanga Tamar. ");
INSERT INTO ptu_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Sapo' indo Er änä' uluana Yehuda, mesa to si ma'gau' kadake dio olona DEBATA, nasuhum napakapodi' sungnga' ia DEBATA. ");
INSERT INTO ptu_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Pissananna ma'kadam Yehuda lako Onan naua: “Bala'i kakammu umpobaine indo bainena. La umpasola metindo aka tä' mala tala umpadadiangko änä' kakammu.” ");
INSERT INTO ptu_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Napobainem Onan, sapo' aka naissammi naua taia siam ia la ungkonai ke dadii änä'na. Nasuhum si napasola oi too metindo indo bainena kakanna, napeä oom lalanna anna mala tä' kebättä indana umpadadianni änä' kakanna. ");
INSERT INTO ptu_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Sapo' indo gau'na Onan nakahi'di' DEBATA naita, napolalam napakapodi' duka' sungnga'na DEBATA. ");
INSERT INTO ptu_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Iya ma'kadam Yehuda lako Tamar manintunna naua: “Lakongko too banuanna ambemu ammu kanonnä dio mepaiham to balu, anna kasallepa änä'ku Syela mane umpomuanei.” Sapo' naua hia illaam penabanna: “Mate pole oo duka' manii susi indo duam kakanna ke napobainei.” Iya le'ba'um duka' Tamar lako banuanna ambena anna tohhoi dio. ");
INSERT INTO ptu_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Masäe-säei, matem indo bainena Yehuda änä'na Syua. Tappana lendu' bahatanna, le'ba'um Yehuda lako Timna sola indo Hira to Adulam sammuanena la umpellambi'i indo to unggontinganni bulu dombana dio. ");
INSERT INTO ptu_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Iya napelelem Tamar dio mai tau nauaam: “Mahassam mangngola lalam Yehuda pasanammu la lako Timna, unggontinni bulu dombana.” ");
INSERT INTO ptu_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Muäläi siaham lao poheba balunna Tamar anna umbala'i pohebana ussapu'i kalena anna ma'lullunni. Mane le'ba'i muokko' dio sa'de ba'ba kota Enaim, sa'de lalam lako Timna. Aka naita kasallem indo Syela, sapo' tä' di dibeem napomuane. ");
INSERT INTO ptu_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Tappana naita Yehuda, iya nasangam baine passunda' aka umbuni lindona Tamar. ");
INSERT INTO ptu_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Iya napellambi'i siaham anna nauaanni: “Mohäeä' la umpasolako metindo.” Aka tä' naissam naua manintunna hia. Natimba' indo baine naua: “Aka la umbeennä' ke mohäeko la umpasolaä' metindo?” ");
INSERT INTO ptu_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Natimba' Yehuda naua: “La kupakatuko mesa änä' bekeku.” Iya nauam: “Assala'na deem la kuanda'i lambi' umpakatuä'.” ");
INSERT INTO ptu_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Ma'kada oom Yehuda naua: “Aka la kubeengko?” Natimba' naua: “Cap meteraimmu sola mani' anna itim tekkem dio limammu.” Iya nabeem asammi ingganna indo napelaunna sampe napasola metindo, lambi' kebättä indo baine. ");
INSERT INTO ptu_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Puhai ia too, le'ba'um indo baine muäläi pesapu' lindona anna umpa'pohebai sule indo poheba balunna. ");
INSERT INTO ptu_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Lessu'na ia too, nauam Yehuda lako sammuanena to Adulam: “Laoko babaangannä' indo baine inde änä' beke, anna mualaannä' sule cap meteraingku sola mani' anna tekkengku.” Sapo' pa'dem dio indo baine nalambi'. ");
INSERT INTO ptu_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Iya napekutanaam lelemmi ongeanna indo baine naua: “Si umba hia ngei naongei indo baine passunda' inde Enaim, indo si mangngampa eta inde bihim lalam?” Iya sikanatimba'um naua: “Aka tä' deem baine passunda' eta inde.” ");
INSERT INTO ptu_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Iya ma'pasulem anna umpellambi'i Yehuda naua: “Tä' deem kulambi' indo baine, anna naua toi indo to eta: ‘Tä' tia deem baine passunda' eta inde.’” ");
INSERT INTO ptu_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Iya nauam Yehuda: “Päbäim too naala indo baham-baham, assala'na tä'ki' kaissangam indo pa'pogausanta anna natula'-tula' tau. Malam tia aka kupakatu si'da-siam indo änä' beke, sapo' tää'na ham deem ullambi' indo baine.” ");
INSERT INTO ptu_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Tallu bulanni umbai' lessu'na, natulasammi tau Yehuda naua: “Indo Tamar manintummu kebättäm aka massunda'.” Nasuhum keaha' Yehuda aka naua: “Akanna massunda'i itim manintungku? Babaia' mai anna ditunu mampu'i.” ");
INSERT INTO ptu_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Tappana dibaba lako indo Tamar, iya ussuam tau mendiolo umpellambi'ianni pasananna, anna nauaanni: “La muuaam: ‘Iai too ade' muane umpuänganni inde baham-baham, iam too ungkebättäi. Pahessai ade' inde cap meterai sola mani' anna tekkem. Menna amo puäna?’” ");
INSERT INTO ptu_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Tappana napehupa Yehuda indo baham-baham, iya nauam: “Malolo puha hi tia anna kao, aka tä' si'da ohi deem kubeem indo änä'ku Syela.” Iya tä'um deem napasola pole metindo indo baine. ");
INSERT INTO ptu_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Pissananna la keänä' kalei indo baine, iya hendu hia indo änä' illaam tambu'na. ");
INSERT INTO ptu_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Tappana subum indo änä'-änä', mesa umpasubum yolo limanna sabali. Iya naanda'im indo to si ma'pakeänä' anna nasäke'i bännä malea, mane nauai: “Iam too inde la mendiolo subum.” ");
INSERT INTO ptu_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Sapo' tappa nahuntu' sule limanna indo änä'-änä'. Iya subummi indo solasubunna muane. Iya nauam indo to ma'pakeänä': “Matohomoko iko messubum.” Iya nasangaim Peres. ");
INSERT INTO ptu_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Puhai ia too, subummi duka' indo mesa, indo to disäke' bännä malea. Iya nasangaim ia Zerah. ");
INSERT INTO ptu_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Tappana nababa to Midian Yusuf lako Mesir, iya naallim to Mesir isanga Potifar, mesa to si mengkähä illaam banuanna tomahaja Firaun. Ia kapalana sohodadu to si unjagai tomahaja. ");
INSERT INTO ptu_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Indo Yusuf tohho illaam banuanna puäna anna nasahum DEBATA anna natamba' liu ingganna pa'palakoanna. ");
INSERT INTO ptu_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Tappana naita anna naissam Potifar naua: “Inde Yusuf to nasahum DEBATA aka ia nakähä ia katambasam,” ");
INSERT INTO ptu_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","iya saundu'um napakamaja anna ia naala si untahiai. Anna napakuasa illaam banuanna lambi' nabeho lako asam ingganna kullena, anna iai ullima'ianni. ");
INSERT INTO ptu_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Napahandu'na eta too, indo umbeenna kakuasaam Yusuf illaam banuanna, anna naanda'iam ingganna kullena, tappa natamba' DEBATA Potifar anna mellängäm kullena; susi illaanna banua, teem lakona bela'. ");
INSERT INTO ptu_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Iya ingganna-ingganna sia nabehoam asammi dokko lisu pala'na Yusuf anna ia asam umpoissanni. Tä'um ia deem aka-aka napikki' sulibanna indo la napohäena naande. Indo Yusuf mesa änä' muane mapia tubo. ");
INSERT INTO ptu_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Pissam wattu kende' penabanna bainena Potifar umpohäe Yusuf. Iya nababaim naua: “Maiko talao petindo.” ");
INSERT INTO ptu_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Iya nauam Yusuf: “Mokaä', aka issinna inde banua, äto'na pengkähängam anna kulle, nabeho asammi puäku dokko lisu pala'ku. ");
INSERT INTO ptu_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Mala diua diona kakuasaam illaam inde banua yabokam lemba' tasitolam. Tä' deem nahä'däsännä' napabehoi sulibanna iko aka bainenako. Maakam ia susi la umpogau'ä' kakadakeam kasalle anna la ungkähä dosa lako Puang Allataala?” ");
INSERT INTO ptu_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Indo bainena Potifar allo-allo si umpa'se'de'-se'de' liu Yusuf, sapo' moka Yusuf la napasola metindo anna tä'um si nakahuku'. ");
INSERT INTO ptu_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Deem pissam wattu tama banua Yusuf la ungkähä pengkähänganna anna siampu' lo'bä banua. ");
INSERT INTO ptu_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Sulem indo baine muanda'i bajunna Yusuf anna nauaanni: “Maiko anta petindo sola.” Sapo' ullendusam bajunna Yusuf, anna lumumpa'i tama sulibam. ");
INSERT INTO ptu_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Tappana naita indo bainena Potifar tohho bajunna Yusuf naanda'i anna le'ba' ia kalena kumondä tama sulibam, ");
INSERT INTO ptu_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","15","iya untambai asammi to si mengkähä illaam banuanna anna ma'tula'i naua: “Petua' siaia', indo sabua' to Ibrani nababa muaneku tama inde banua, sule hia la mepa'tomaho-mahoi, sule la nabobo'ä'. Nauaannä': ‘Talao petindo,’ sapo' tappa kaoli-oliä', iya le'ba' bäbäm lumumpa' taungkilalai bajunna.” ");
INSERT INTO ptu_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Indo baju naanna lium bainena Potifar sampe sule muanena. ");
INSERT INTO ptu_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Iya ma'tula'um lako muanena naua: “Indo sabua' to Ibrani umbaba sule, nasändä'-sändä' la nabobo'ä', ");
INSERT INTO ptu_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","sapo' kaoli-oliä', iya lumumpa'um tama sulibam taungkilalai bäbäm bajunna.” ");
INSERT INTO ptu_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Nahingnginna Potifar indo pa'tula'na bainena, tappa hede-hede aha'na. ");
INSERT INTO ptu_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Iya napopesakka siaham puäna anna napatamai tahungkum, pa'tahungkunganna ingganna to natahungkum Firaun. ");
INSERT INTO ptu_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Sapo' naolaam liu DEBATA Yusuf anna napasahonoi pa'kamasena, lambi' napakamäjjä indo kapalana to si unjagai tahungkum. ");
INSERT INTO ptu_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Ingganna pengkähängam anna pa'palakoam illaam tahungkum nabeho asam indo kapalana to si unjagai tahungkum lako Yusuf, nasuhum indo ingganna to ditahungkum illaam pala' limanna. ");
INSERT INTO ptu_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Tä'um ia deem aka-aka napikki' indo kapalana to si unjagai tahungkum aka napalako asammi Yusuf. Aka naundu' DEBATA nasuhum ingganna pa'palakoanna mapia asam anna kembua mapia. ");
INSERT INTO ptu_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Masäe-säei puhanna, deem kapalana to si umpaihu' Firaun sola kapalana to si umpandei, bassim umpogau' kasalaam lako tomahaja, ");
INSERT INTO ptu_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","napolalam keaha' Firaun lako indo dua kapala. ");
INSERT INTO ptu_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","Iya bassim napäsä'um tama tahungkum indo dipantahungkunni duka' Yusuf dio banuanna kapalana sohodadu to si unjagai tomahaja. ");
INSERT INTO ptu_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Masäe naolaam ditahungkunni eta, anna Yusuf nasua indo kapalana sohodadu la si umpamoloii indo dua tau illaam ingganna kapahalluanna. ");
INSERT INTO ptu_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Pissam wattu simbaha mangngimpi illaam mesa bengi indo dua tau, anna bassim deem kalembasanna indo pangngimpinna. ");
INSERT INTO ptu_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Tappana sule Yusuf mebengngi', muitam indo dua tau bassim nonno-nonno masussa. ");
INSERT INTO ptu_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Iya nakutanaim naua: “Maaka hia anna bassim masussakoa' diita?” ");
INSERT INTO ptu_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Bassim mentimba'um naua: “Mangngimpikam sapo' tä' deem tau mala umbittuiangkam.” Iya natimba'im naua: “Sapo' kuua hi kao Puang Allataala hia kuasa umbittui pangngimpi. Sändä'pi untulasannä' itim pangngimpimmua'?” ");
INSERT INTO ptu_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Iya indom yolo kapalana to si umpaihu' Firaun untula' pangngimpinna naua: “Kupangngimpi deem kahi' satoo' anggur dio oloku. ");
INSERT INTO ptu_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","Indo anggur tallu täkena, iya kendaum händä siaham, mane kembunganni, mane kembuai timbahutu-hutu si matässä'. ");
INSERT INTO ptu_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Mahassannä' kahi' muanda'i ihusam angngurna Firaun, iya kualam indo bua anggur anna kupahhai tama ihusanna, mane kubabaanni lao.” ");
INSERT INTO ptu_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Nauaammi Yusuf: “Susi inde kalembasanna itim pangngimpimmu: Indo tallu täke, kalembasanna tallu bengi. ");
INSERT INTO ptu_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Tallu bengii too, sulengko naala sule Firaun napassubungko illaam mai inde tahungkum, aka la napopengkähäko sule dio pengkähängammu. La si umbeem oo sule Firaun ihusam anggurna susi indo si umpaihu'. ");
INSERT INTO ptu_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Sapo' kilalai hämä' kao ke muongeingko sule ongeammu, pa'tula'iannä' Firaun lalanna anna ditahungkunnä', anna umpelauannä' lako, umba ke malaä' dipassubum illaam mai inde tahungkum. ");
INSERT INTO ptu_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Aka disakka bäbää' too dio bottoku, botto litä'na to Ibrani, anna tä' toi deem pa'pogausangku inde Mesir la sipäto'na ditahungkunnä'.” ");
INSERT INTO ptu_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Tappana nahingngi indo kapalana to si umpande Firaun naua: “Mapia hia kalembasanna pangngimpinna indo to si umpaihu' Firaun.” Iya untula'um duka' pangngimpinna naua: “Kupangngimpi kao mahassannä' kahi' undudum tallu bähä-bähä kinande. ");
INSERT INTO ptu_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Indo bähä-bähä handam yaboam ma'hupa-hupa kinandena Firaun dio. Sapo' mahassam siam kududum, iya sule siaham sanaka-naka dassi anna naandei.” ");
INSERT INTO ptu_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Natimba'i Yusuf naua: “Susi inde kalembasanna itim pangngimpimmu: Indo tallu bähä-bähä kalembasanna tallu bengi. ");
INSERT INTO ptu_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Tallu bengii too napassubummoko Firaun anna naäläi ulummu mane natoke'i bakkemu längäm mesa kaju pantokesam, anna la sulei dassi naande balemu.” ");
INSERT INTO ptu_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Tappana tallu bengi, ma'hame-hamem Firaun, umpande asam to mengkähäna illaam banuanna aka allo kadadianna. Napesuaammi Firaun dipassubum indo kapalana to si umpaihu'i anna kapalana to si umpandei. Bassim dipassubum illaam mai tahungkum anna dipaillaanni alla'-alla'. ");
INSERT INTO ptu_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Dipopa'pasule ia lako pengkähänganna indo to si umpaihu'i, lambi' si umpaihu' oo sule Firaun. ");
INSERT INTO ptu_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Sapo' indo ia kapalana to si umpandei, ditoke' ia susi indo pambittuinna Yusuf. ");
INSERT INTO ptu_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Sapo' lembe bäbäm ia indo kapalana to si umpaihu' Firaun, tä'um ungkilalai Yusuf. ");
INSERT INTO ptu_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Tappana dua taunni lessu'na, iya napangngimpim duka' Firaun mahassam kahi' ke'de'-ke'de' dio bihinna salu Nil. ");
INSERT INTO ptu_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Iya muitam pitu sapim si mapia kale anna si maloppä' buttu dio mai indo salu, kende' längäm bihim salu anna dioi ma'ande-ande. ");
INSERT INTO ptu_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Mane muita polei buttu dio mai indo salu pitu sapim senga' si kadäkke' anna si madokko'. Kende' duka' längäm bihim salu anna umpengngampe'i indo sapim si maloppä'. ");
INSERT INTO ptu_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Pissananna indo sapim si kädäkke' anna madokko' muande indo sapim si mapia kale anna malompo. Iya tikkedu'um Firaun. ");
INSERT INTO ptu_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Tappana mamma' sule, iya mangngimpi pole oom. Muita opi kahi' mesa bätä gandum ungkembuaam pitu bulinna gandum si mabulli' anna si maläppu'. ");
INSERT INTO ptu_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Mane muita pole boi kende' dio mai indo bätä ia siam, pitu oo bulinna gandum si läkko' anna malasso, nalasso hibu' malussu buttu illaam mai tandai mata allo. ");
INSERT INTO ptu_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Pissananna indo buli si läkko' muamma' indo buli si mapi'dä' anna si maläppu'. Tikkedu'i Firaun, iya ke mangngimpi hia. ");
INSERT INTO ptu_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Mebengngi'i makananom penabanna Firaun umpikki' indo pangngimpinna aka mohäe la naissam kalembasanna. Umpopetambaim ingganna to ma'issam-issam anna to manähä illaam kapahentaanna anna natulasanni indo pangngimpinna, sapo' tä' punala deem moi podo la mesa la naissam umbittuianni. ");
INSERT INTO ptu_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Iya ma'tula'um lako Firaun indo kapalana to si umpaihu'i naua: “Temo ham mane kukilalai kasalaangku. ");
INSERT INTO ptu_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Indo sanaka amo wattunna lessu' ungkeaha'ikam solakam kapalana to si umpande tomahaja anna untahungkungkam dio banuanna kapalana sohodadu to si unjagai tomahaja. ");
INSERT INTO ptu_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Deem pissam bengi bassim mangngimpikam anna bassim deem kalembasanna indo pangngimpingki. ");
INSERT INTO ptu_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Kitula'um indo pangngimpingki lako mesa änä' muane to Ibrani, sabua'na kapalana sohodadu to si unjagai tomahaja. Iya bassim natulasammakam kalembasanna indo pangngimpingki. ");
INSERT INTO ptu_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Iya indo ingganna pambittuinna sule lako asam. Dipopa'pasuleä' kao sule lako pengkähängangku, anna ditoke' ia indo kapalana to si umpande tomahaja.” ");
INSERT INTO ptu_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Tappa ussua siahanni tau Firaun untambai Yusuf. Dipassubum siaham duka' Yusuf illaam mai tahungkum. Iya ungkällu'im bulu lindona anna ma'pohebai mane dibabai lako olona Firaun. ");
INSERT INTO ptu_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Napa'tula'im Firaun naua: “Sabengi mangngimpiä' sapo' tä' deem tau muissanni umbittui. Sapo' kuhingngi si muissam umbittui pangngimpi.” ");
INSERT INTO ptu_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Natimba'im Yusuf naua: “Tä' duka' kuissam kela buttu di kaoi, sapo' Puang Allataala la umpaissanniko kalembasanna anna mala muissam manappa.” ");
INSERT INTO ptu_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Natula'um Firaun indo pangngimpinna naua: “Kupangngimpi ke'de'-ke'de'ä' kahi' dio bihinna salu Nil. ");
INSERT INTO ptu_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","Iya kuitam kahi' buttu dio mai indo salu pitu sapim si maloppä' anna mapia kale, anna ma'ande-andei kahi' dio indo bihim salu. ");
INSERT INTO ptu_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Dako'i buttu pole boom dio mai indo salu pitu sapim senga' si mahäkke'-häkke'. Tandana liba' madokko'na kupali'um inde Mesir, iya tä'pi deem kuita la susi kadakena. ");
INSERT INTO ptu_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Tä' masäe, iya kuitam indo sapim si kadäkke' anna si madokko'-dokko' muande indo pitu sapim si maloppä' to yolo buttu. ");
INSERT INTO ptu_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Tappana puha naande, iya tontä liu siam kahi' kuita kalena indo sapim madokko'. Tä' deem tidende tambu'na moi la sai'di'um. Iya tihambammä'. ");
INSERT INTO ptu_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Tä' masäe mamma' omä' sule, iya mangngimpi pole omä'. Mahassanna kuita kahi' illaam mai mesa bätä gandum buttu pitu bulinna gandum si mabulli' anna si maläppu'. ");
INSERT INTO ptu_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Sapo' tä' masäe, kuitam indo bätä ia siam naongei buttu pole boo pitu bulinna gandum si läkko' anna malasso napobua' hibu' buttu illaam mai tandai mata allo. ");
INSERT INTO ptu_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Anna mane kuita indo buli gandum si läkko' muamma' indo buli gandum si maläppu'. Inde pangngimpingku puha asammi kutula' lako ingganna to si ma'issam-issam, sapo' tä' tappa' deem moi podo la mesam tau la muissanni kalembasanna.” ");
INSERT INTO ptu_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Ma'kadam Yusuf lako Firaun naua: “Itim dua pangngimpimmu tontäm, aka mesa kalembasanna. Napalosaiko Puang Allataala kaha-kaha la napadadi inde lembäna Mesir. ");
INSERT INTO ptu_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Indo pitu sapim si maloppä' anna pitu bulinna gandum si maläppu' bassim kalembasanna pitu taunna. ");
INSERT INTO ptu_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Indo pitu sapim si madokko' anna kädäkke' anna pitu bulinna gandum si malasso anna läkko', kalembasanna la kende' pitu taunna naolaam kakobeam. ");
INSERT INTO ptu_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Puha kuua ingngena' napalosaiko Puang Allataala indo la napakende'. ");
INSERT INTO ptu_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Dadi muissammi inde pitu taunna la sule, la kende' alaangkinande, la bosa' tau illaam paluäna Mesir. ");
INSERT INTO ptu_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Mane sulei pitu taunna kakobeam, nasuhum indo wattu kabosasam la dikalembei tanda mapi'di'na. Ingganna lao mobotto-bottoam la natalappi' kalobahiam mapana'. ");
INSERT INTO ptu_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Indo kakobeam la liba' mapana'na, nasuhum tä'um la nakilalai hupatau naua: ‘Puha kiolai wattu kabosasam.’ ");
INSERT INTO ptu_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Penduangko mangngimpi moi anna mesa siam kalembasanna. Aka kaha-kaha ia too puha nakattum Puang Allataala anna la napadadi siaham. ");
INSERT INTO ptu_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Dadi la umpeäko mesa to manähä anna to keaka' la mampahe' illaam inde Mesir. ");
INSERT INTO ptu_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Maka' mala, la muäkä'ko si sanaka-naka tau umpatadongkom lako mobotto-bottoam anna uhhempunni bahe limanna ingganna bua pengkähäna hupatau illaam pitu taunna wattu kabosasam inde la sule. ");
INSERT INTO ptu_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Indo ingganna gandum pa'hempum la dipapiaam loko lako si mesa-mesa ongeam indo ungkuasainna anna dianna manappai. ");
INSERT INTO ptu_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Maka' too dipasusi, la mala deem kinande toka, la ganna' naande hupatau ke sulei indo kakobeam pitu taunna illaam inde Mesir.” ");
INSERT INTO ptu_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Indo tula'na Yusuf natahima mapia Firaun sola ingganna to mengkähäna illaam kapahentaam. ");
INSERT INTO ptu_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Tappana ditula' menna la diäkä', ma'kadam Firaun lako ingganna to mengkähä illaam kapahentaanna naua: “La deem daka talambi' polea' tau la susi inde Yusuf? Aka inde tau mannassa anna to nasahunni Penabanna Puang Allataala.” ");
INSERT INTO ptu_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Ma'kada Firaun lako Yusuf naua: “Ikom handam manähä anna keaka' illaam inde botto, tä' deem la susimmu, aka iko napalosai Puang Allataala diona kaha-kaha ia too. ");
INSERT INTO ptu_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Dadi temo kuäkä'ko la muanda'i kakuasaam illaam inde botto. Iai too muua, iam natuhu' ingganna hupatau to kulumbäi; angga ham kao untondongko aka tomahajaä' kao. ");
INSERT INTO ptu_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Dadi temo kuäkä'ko la muanda'i kakuasaam illaam lembäna Mesir.” ");
INSERT INTO ptu_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Iya untässu'im sissinna battu diua cap meterainna anna napatamaanni tahuno-hunona Yusuf. Anna napapohebai poheba handam mapia mane napamani'i mani' bulabam. ");
INSERT INTO ptu_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Mane napa'pahentaanni Firaun dipalängäm bendi mapi'dä' Yusuf, angga ham bendinna tomahaja untondonni, mane dipopenggulilinni anna metamba-tamba liui sanaka-naka tau dio olona naua: “Penombakoa'.” Susim too lalanna Yusuf naäkä' Firaun mendadi to kuasa dio Mesir. ");
INSERT INTO ptu_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Ma'kada pole oom Firaun lako Yusuf naua: “Kao tomahaja inde Mesir, sapo' ingganna kaha-kaha tä' mala napogau' hupatau ke taiai pa'elo'mu.” ");
INSERT INTO ptu_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","46","Ussangaim Yusuf Zafnat-Paaneah, anna napasialai Asnat änä'na Potifera sandona to Mesir dio On. Indo Yusuf tallu pulom taunna dadinna anna naäkä'i Firaun. Iya mengkalao siaham dio banuanna Firaun le'ba' ullelei mobotto-bottoam dio Mesir. ");
INSERT INTO ptu_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Napahandu' etam too, kende' alaangkinande dio Mesir, lambi' pitu taunna naolaam bosa' hupatau. ");
INSERT INTO ptu_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Illaam indo pitu taunna kabosasam, naolaam Yusuf ussua hupatau uhhempum kinande lako mobotto-bottoam dio lembäna Mesir, anna naannai illaam si mesa-mesa kota. ");
INSERT INTO ptu_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Indo gandum pa'hempum buda sugali'um, nasuhum tä' bäbäm nabela nahekem Yusuf aka mellitä' bäbäm budanna. ");
INSERT INTO ptu_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Tä'pi sule kakobeam anna dadii dua änä'na Yusuf sihuntum muane nasibalii Asnat. ");
INSERT INTO ptu_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Indo änä' uluana nasangai Manasye aka naua: “Napalembeä' Puang Allataala dio mai ingganna pi'di'ku indo di mangnguhangku anna kamamallisangku lako banuanna ambeku.” ");
INSERT INTO ptu_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Anna indo änä' kaduanna nasangai Efraim aka naua: “Namana'ä' kadeengam anna pandadiam Puang Allataala illaam botto kuongei dipakamase-mase.” ");
INSERT INTO ptu_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Tappana lessu' pitu taunna kabosasam, ");
INSERT INTO ptu_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","sulem kakobeam susi indo pa'tula'na Yusuf. Kende' kakobeam lako ingganna botto, sapo' dio ia Mesir deem ia kinande dipatoka. ");
INSERT INTO ptu_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Tappana nalambi' kakobeam pakketauanna Firaun, suleim umpelau kinande lako tomahaja. Iya nauaammi: “Pellambi'ikoa' Yusuf anna ia too napahesangkoa' ianna' too la untuhu'.” ");
INSERT INTO ptu_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Indo kakobeam tä' deem hupatau nasala illaam inde lino. Nabukkaim Yusuf indo ingganna loko gandum anna nabalu'i lako to Mesir aka kobe asammi duka' hupatau dio. ");
INSERT INTO ptu_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Susi toi duka' hupatau buttu dio mai mobotto-bottoam, sulei mangngalli gandum lako Yusuf aka mapana' kakobeam lako lino. ");
INSERT INTO ptu_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Tappana naissam Yakub naua deem ia gandum dio Mesir, nauam lako änä'na: “Akanna kanonnä bäbä hakoa' iko? ");
INSERT INTO ptu_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Kuhingngi kaheba deem ia ade' gandum dio Mesir. Laokoa' lako alliangkia' gandum indana matekia'.” ");
INSERT INTO ptu_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Iya le'ba'im lako Mesir indo sapulo solasubunna Yusuf la lao mualli gandum. ");
INSERT INTO ptu_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Anggam ia Benyamin indo sola indona Yusuf, tä' napäbäi Yakub lao sola solasubunna aka napa'kalallangam. ");
INSERT INTO ptu_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Dadi indo to sulei mangngalli gandum, dio duka' heem peänäsanna Israel aka nahua duka' kakobeam dio lembäna Kanaan. ");
INSERT INTO ptu_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Aka Yusuf to kuasa anna ungkapalai pa'balusam gandum, iya ia napellambi'i solasubunna anna napenombai. ");
INSERT INTO ptu_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Tappana muita solasubunna, tappa naissam naua: “Solasubungku.” Sapo' naägä'i lelem angga' tau senga' umpomato'do' pa'kadanna naua: “Botto umbaa' muongei buttu?” Mentimba'im naua: “Buttu diokam mai lembäna Kanaan, sulekam la mangngalli kinande.” ");
INSERT INTO ptu_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Muissam liu ia solasubunna, sapo' sangngim tä'um ia muissam Yusuf. ");
INSERT INTO ptu_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Tappa nakilalai Yusuf indo pangngimpinna. Iya nauaammi: “Mata-matakoa' inde ä. Sulekoa' la ummata-matai umba naongei malammana inde botto tää'na dijagai.” ");
INSERT INTO ptu_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Sapo' mentimba'i naua: “Tää' puäki! Anggangkam sule la mangngalli kinande. ");
INSERT INTO ptu_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Inde padakam mesa ambe, sangngim to malolokam, taiakam mata-mata.” ");
INSERT INTO ptu_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Sapo' naua: “Tää'! Sulekoa' la ummata-matai inde botto anna muitaia' umba ngei naongei kamalammaanna!” ");
INSERT INTO ptu_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Natimba'i oom naua: “Inde padakam sabua'mu, sapulo duakam ma'solasubum buttu dio mai Kanaan. Sapo' indo tämpä', tohho ia umpasolai ambeki, anna indo mesa pa'dem ia.” ");
INSERT INTO ptu_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Ma'kada oom naua: “Tä' deem gunana itim pa'tula'mua'. Puha kuua ingngena' to mammata-mataikoa'. ");
INSERT INTO ptu_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","La dipangngitai pa'tula'mua' battu la tappa' si'da hi. Ma'pindaä' umpolalam sanganna Firaun, tä'koa' mala le'ba' ke tä'i sule indo solasubummua' handam tämpä'! ");
INSERT INTO ptu_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Sala' mennammua' mala tässu' lao mualai itim adimmu anna senga'-senga'na la kutähämpi inde, anna diitai battu la tappa' si'da hi pa'tula'mua'. Anna maka' kaägä'-ägä'koa', taia too tomahaja Firaun ke tä'koa' kupassala, aka mata-mata si'dakoa' too.” ");
INSERT INTO ptu_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Sangngim dipatamam tahungkum, tallu bengi dipaillaam. ");
INSERT INTO ptu_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Tappana tallu bengii nauaammi Yusuf: “Kao duka' mesaä' to mengkahea' längäm Puang Allataala. Dadi anna malakoa' tubo la kupaolaikoa' lalam susi inde: ");
INSERT INTO ptu_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","La diolaam diissam diua tau mapia si'dakoa', patohhoia' mesa solasubummu ditähäm inde, anna ikoa' senga'na malam ma'pasule umbabaam kinande kasahapuammua' aka masussa sugali' nahua kakobeam. ");
INSERT INTO ptu_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Sapo' indo adimmua' tämpä' la umbabaa' sule inde anna tandaanni diua tappa' si'da pa'tula'mua', anna mala tä'koa' dipatei.” Iya natuhu'im indo tula'na Yusuf. ");
INSERT INTO ptu_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Iya sipa'tula'-tula'um naua: “Indee buanam too indo pa'pogau'taa' lessu'. Nalambi'kia' pole' buana gau' kadaketaa' lako adinta. Taita sianna' maaka susi mapi'di'na penabanna indo anna mengkahumase-masei lako kitaa'. Napelau la tahäntänganna' bua sapo' tä' di tapehingngiia', nasuhum nahuakia' kamasussaam temo.” ");
INSERT INTO ptu_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Ma'kadam Ruben naua: “Kuua siam indo eta: ‘Daa ungkähäa' dosa lako itim änä'-änä'!’ Sapo' tä'koa' mebollim. Temo nalambi'ungkia' pole' buana indo kamateanna adintaa' Yusuf.” ");
INSERT INTO ptu_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Sapo' sangngim tä' napelabillo naua indo pa'tula'na naissam siam Yusuf, aka naägä'i lelem si umpake guhu basa umpa'tula'i. ");
INSERT INTO ptu_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Menggihi' Yusuf umpassii uwai matanna, mane napatahhu' oi ma'tula'. Iya mualam Simeon anna napesuaanni dipungo dio olona solasubunna. ");
INSERT INTO ptu_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Puhai, napa'pahentaammi Yusuf dipangngissiam gandum kahunna, anna indo doi'na la sangngim dipasuleam tungga' dipatamaam kahunna, anna la dibeem tinallo naandena lako lalam. Iya napateemmi situhu' pahentana Yusuf. ");
INSERT INTO ptu_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Puhai, umpatteke'im keledainna gandum indo kakanna Yusuf anna le'ba'i sule lako tondä'na. ");
INSERT INTO ptu_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Tappana tohhoi la ma'bengi, deemmi mesa umbukkai kahunna aka la umpande keledainna, iya muitam doi'na illaam kahum ia handam yaboam. ");
INSERT INTO ptu_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Nauam lako solasubunna: “Dipasule doi'ku, petua' siaia' illaam inde kahungku.” Iya sinenne'-nenne'im, sangngim hosso penabanna anna sangngim lumalla' mahea' anna nauai: “Aka amo umbai' isanga napogausangkia' Puang Allataala!” ");
INSERT INTO ptu_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Tappana sule lako Kanaan, natula'um lako Yakub ambena indo ingganna kadadiam natammu dio Mesir, naua: ");
INSERT INTO ptu_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","“Indo to muanda'i kakuasaam dio Mesir nakahha'ikam napa'tula'i anna natanda'kam mata-mata. ");
INSERT INTO ptu_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Sapo' kiuaam: ‘Tau malolokam, taiakam mata-mata. ");
INSERT INTO ptu_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Sapulo duakam ma'solasubum mesa ambeki, sapo' pa'dem mesa anna indo tämpä' tohho ia sola ambeki dio Kanaan.’ ");
INSERT INTO ptu_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Iya nauaammakam: ‘Anna mannassai diua tau malolokoa', sala' mennammua' la tohho inde anna ikoa' senga'na mala ma'pasule umbabaam gandum kasahapuammua' aka masussa sugali' nahua kakobeam. ");
INSERT INTO ptu_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Anna umpasolaia' sule indo solasubummu tämpä' paha' anna makalesoi diua tau malolo si'dakoa' taia mata-mata. Etapi pole' mane kulappasangangkoa' indo solasubummu anna la beba'koa' pole' si sule tama inde botto.’” ");
INSERT INTO ptu_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Tappana undo'do'i kahunna, naitam indo doi' pealli gandunna tungga' illaam asam kahunna. Iya sangngim mahea'um solai ambena. ");
INSERT INTO ptu_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Iya nauaammi ambena: “Ikoa' buntu tumäna anna pa'dei änä'ku. Pa'dem Yusuf, pa'de pole oom Simeon, temo la umbaba pole boonna' lao Benyamin. Ingganna kaha-kaha ia too kao asam umpendudunni.” ");
INSERT INTO ptu_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Ma'kadam Ruben lako ambena naua: “Toko la umpatei indo dua änä'ku muane ke tä'i kupopa'pasuleangko Benyamin. Kao untanggunni.” ");
INSERT INTO ptu_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Sapo' natimba' naua: “Tä' deem la umpasolakoa' änä'ku lako, aka matem kakanna, iya ia mandam da'da'. Deem manii muakai lako lalam indo la muolaa'. Iya iam too la umpomapi'di'ä' napatei pissam illaam inde kamatuaangku.” ");
INSERT INTO ptu_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Sapo' tontä liupi ia mapana' kakobeam dio Kanaan. ");
INSERT INTO ptu_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Tappana puha indo gandum nababa dio mai Mesir, ma'kada oom Israel lako änä'na naua: “Laokoa' alliam polekia' gandum lako Mesir.” ");
INSERT INTO ptu_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Iya ma'kadam Yehuda naua: “La maaka susi aka napakahi'di mate-matekam indo to kuasa dio naua: ‘Tä'koa' mala sule umpellambi'i poleä' ke tä'i umpasola indo adimmua'.’ ");
INSERT INTO ptu_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Dadi maka' umpäbäikam kipasola adingki, bahanikam lako mualli pole kinande. ");
INSERT INTO ptu_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Sapo' angga hia ke tä'i, tä' kiaku la lako aka inna nauaangkam: ‘Tä'koa' mala sule ke tä'koa' sola adimmu.’” ");
INSERT INTO ptu_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Ma'kada Israel naua: “Akanna mualaannä' kamasussaam? Untula' ohia' iko muua: ‘Deempi adingki.’” ");
INSERT INTO ptu_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Mentimba'im naua: “Anu' napekanuttu'kam; Napekutanaam kasahapuantaa' naua: ‘Tubopaka ambemua', deempaka adimmua' mesa?’ Iya kitula' asam duka' setonganna. Aka tä' diissam diua la meuaam dia: ‘Pasolaia' sule indo adimmu.’” ");
INSERT INTO ptu_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Nauam Yehuda lako ambena: “Lappasam di itim änä'mu kipasola anna bale' mengkalaokam indana mate tadea' asangkia' sola ampomu. ");
INSERT INTO ptu_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Kao la untanggunni. Anna kao la umpanuntu'i ke tä'i kupasolaangko sule. Kao toi la umpendudunni kadakena sule lako mateku. ");
INSERT INTO ptu_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Indo kela bale' le'ba'ungkam, ambe', la kapenduangkim sule.” ");
INSERT INTO ptu_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Iya nauam ambena: “Maka' susi alaia' handam mapianna bua pengkähä illaam inde botto, susinna: balsam, duho, hampa-hampa, dama' bubanau', kamihi, anna buana badam. Patamai pa'pongngeammua' anna umbabaannia' indo to kuasa dio. ");
INSERT INTO ptu_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Babaia' penduam pada indo pealli gandum, anna umpasuleannia' sule indo doi' ullambi'a' illaam kahummu. Aka umbai' lembena hi tia. ");
INSERT INTO ptu_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Pasolaia' adimmu ammu laoa' lako indo tau. ");
INSERT INTO ptu_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Puang Allataala ham To Handam Kuasa la umpatamai penaba mapia indo tau anna malai nahäntängangkoa' bua, lambi' napasuleam manappakoa' Benyamin sola Simeon. Anna di kaona kao, maka' abana la dadi susi änä'ku, iya la diakam ia susi.” ");
INSERT INTO ptu_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Iya nababam indo pa'lalam penabanna lako indo to kuasa sola doi' penduam pada budanna indo lessu', anna umpasolai Benyamin le'ba'i lako Mesir umpellambi'i sule Yusuf. ");
INSERT INTO ptu_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Tappana muitai Benyamin sule sola solasubunna, nauam Yusuf lako to ungkapalai pengkähängam illaam banuanna: “La umpasola lako banua, aka la sola-solakam mangngande maniallo. Dadi la metunuko anna umpatokaangkam kinande.” ");
INSERT INTO ptu_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Iya napasolam tama banua indo solasubunna Yusuf anna nakähäi pada indo napahentaam Yusuf. ");
INSERT INTO ptu_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Iya dibabaim tama banuanna Yusuf, lambi' mahea'i aka naua: “Umbai' indo doi' dipasule sule tama kahuntaa' kasuhunganna anna dipasulekia' eta inde. Aka dipolalam la didahhakia' anna disakka la diposabua' anna dialaia' keledainta.” ");
INSERT INTO ptu_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Tappana dioi olo ba'ba, umpengkahuku'im indo kapalana to mengkähäna Yusuf anna nauaanni: ");
INSERT INTO ptu_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","“Deem la kiua tuam! Indo lessu' sulekam mualli kinande ");
INSERT INTO ptu_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","22","sapo' tappana ma'pasulekam, dioi indo si diongei ma'bengi, kilambi'um doi'ki illaam kahum dipatompo yabona gandum, tä' deem kuhäm. Tä' kiissam menna amo umpatamai. Sapo' indem indo doi' kipopa'pasule anna umbabapakam doi' la kipopangngalli pole kinande.” ");
INSERT INTO ptu_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Nauam indo kapalana to mengkähä: “Tä'koa' la mahea' anna manangnga, aka Puang Allataala to umpenombaia' anna napenombai ambemua', iam too umpatamaangkoa' kahummu doi'. Aka indo doi' peallimmua' balim ia kutahima.” Iya le'ba'um muala Simeon anna napasilambi'i solasubunna, ");
INSERT INTO ptu_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","mane napasolai tama banuanna Yusuf. Naalaammi uwai nabaseiam bitti'na anna mane napandeanni keledainna. ");
INSERT INTO ptu_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Naolaam muampai Yusuf la sule ke tängäi allo, iya napatokam solasubunna indo pa'lalam penabanna, aka puham dipaissanni diua la sola-solai mangngande. ");
INSERT INTO ptu_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Sulei Yusuf naalaim indo pa'lalam penabanna anna nabeenni napasindum menomba. ");
INSERT INTO ptu_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Nakutanaim Yusuf naua: “Masakke-sakke mammakoka', anna masakke mammaka ambemua' indo to muuaanna' matuam?” ");
INSERT INTO ptu_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Natimba'um naua: “Io, masakke mammi.” Anna mane sangngim menomba oo. ");
INSERT INTO ptu_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Tappana muita Benyamin adinna, mekutanam naua: “Iangka inde adimmua' indo to muuaanna' tämpä'?” Mane ma'kadai lako Benyamin naua: “Natamba' dangko Puang Allataala, änä'ku.” ");
INSERT INTO ptu_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Le'ba' siaham Yusuf tama tambinna sumahho, aka manabo inabanna muita adinna. ");
INSERT INTO ptu_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Puhai sumahho, mendau'um mane messubunni sule. Napengkatähhännim nabo inabanna anna ma'kadai naua: “Pamainna' toda' kinande.” ");
INSERT INTO ptu_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Ma'meja senga' ia duka' Yusuf mangngande anna ma'meja senga' duka' solasubunna. Anna ingganna to Mesir dipalao senga' ia duka' mejanna, aka nakahidi' la sola-sola to Ibrani mangngande. ");
INSERT INTO ptu_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Dipasitingngajo mejanna Yusuf anna mejanna solasubunna. Indo solasubunna muokko' dipopa'huntum kaka napahandu' ulua sule lako tämpä'. Tappana naita indo okko'na, iya sangngim mängä-mängä sinenne'-nenne'i. ");
INSERT INTO ptu_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Indo kinandena solasubunna sangngim buttu dio mai mejanna Yusuf. Anna kinande dibeem Benyamin pellima pada kinandena solasubunna. Iya kassi mangngande pada-pada sola Yusuf sampe dea'. ");
INSERT INTO ptu_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Napa'pahentaammi Yusuf lako kapalana to mengkähä illaam banuanna naua: “Pangngissiam asanni kahunna pada la nabelanna nababa, anna tungga' umpatamaanni sule doi'na, patompoi yabona indo gandum. ");
INSERT INTO ptu_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Petua'i kahunna indo to handam tämpä' anna umpa'patamai ihusam peha'ku, pasolai pealli gandunna.” Napateem asammi duka' indo to mengkähä pada indo dipahesam. ");
INSERT INTO ptu_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Makale'na mane tibukka' baja anna le'ba'im umpasola patteke'na. ");
INSERT INTO ptu_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Tää'ipi mambela naola umpellei indo botto, iya ma'kadam Yusuf lako kapalana to mengkähäna naua: “Kandi'i umpadondo anna ullambi'i too muuaammi: ‘Dibeengkoa' iko penaba mapia umbala' kadake hia'! ");
INSERT INTO ptu_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Akanna umbokokoa' ihusam peha'na puäku? Indo ihusam ia too si naihu'i anna si napanjappii uwai. Indee ungkähäkoa' gau' kadake!’” ");
INSERT INTO ptu_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Tappana ullambi' solasubunna Yusuf indo to disua, napa'tula'im susi indo puha napakahi'diam Yusuf. ");
INSERT INTO ptu_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Mentimba'im naua: “Tä' kiissam itim muuam tuam. Bahanikam ma'pinda keta tä'i deem umpogau'kam kakadakeam. ");
INSERT INTO ptu_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Aka moi indo doi' kilambi' pissam illaam kahungki dipayaboanna gandum, kipasule asam too sule. Dadi tä' punala ia pole' la umbokokanni peha' battu haka bulabam dio banuanna puämu. ");
INSERT INTO ptu_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Maka' toko deem sala'-sala' mennangki umpallambi'i indo ihusam, päbäii dipatei ia anna diposabua'kam kami'.” ");
INSERT INTO ptu_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Nauam indo to disua: “Mapia sapo' iai too dipallambi'i indo ihusam, iam kuposabua' anna senga'na mala ia le'ba'.” ");
INSERT INTO ptu_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Iya tungga' napasihha'um umpatuhum kahunna anna nabukkai. ");
INSERT INTO ptu_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Napahessa asammi indo pesuana Yusuf, nahihisam mengkalao kahunna to handam kaka, sule lako kahunna to handam tämpä'. Iya nalambi'um indo ihusam illaam dia kahunna Benyamin. ");
INSERT INTO ptu_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Sangngim häntä kakanna lambi' umpessessesannii pohebana. Umpatteke'i asammi sule keledainna anna ma'pasulei lako kota. ");
INSERT INTO ptu_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Landa'i Yehuda sola ingganna solasubunna lako banuanna Yusuf, diopi nalambi'. Iya silelem muoppä menomba dio olona. ");
INSERT INTO ptu_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Ma'kadam Yusuf naua: “Maaka anna ma'gau' susikoa'? Tä' daka' tiko muissam muua ingganna gau' kadakemua' kulosa asam aka pa'issangangku?” ");
INSERT INTO ptu_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Mentimba'um Yehuda naua: “Aka pole la kiua tuam? Anu' tä' deem la kiola ma'baho battu la ummaloloam kaleki. Napa'patandaam Puang Allataala kasalaangki. Temo taia indo mandi to dipallambi'i ihusam la umposabua', sapo' ia asangki.” ");
INSERT INTO ptu_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Sapo' ma'kada Yusuf naua: “Malomba' la kupateem, indo mandi to umboko ihusangku la kuposabua'. Ikoa' senga'na, la ma'pasule manappakoa' iko lako ambemu.” ");
INSERT INTO ptu_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Umpengkahuku'im Yusuf Yehuda anna ma'kadai naua: “O puäku, mala haka ma'tula'ä' dio olomu? Tä' la ungkeaha'iä' aka kuissam kuua pada siangko tomahaja Mesir. ");
INSERT INTO ptu_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Iko siam puha ungkutanaikam muua: ‘Tubopaka ambemu anna deempaka solasubummu mesa?’ ");
INSERT INTO ptu_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Kitimba'im kiua: ‘Tubopi sapo' matuam, anna mesapi adingki sapo' matua ham ambeki mane dadii. Anna deempi sola indona sapo' matem. Dadi ia mandam tubo anna napakamäjjä ambeki.’ ");
INSERT INTO ptu_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Muuaangkam: ‘Pasolaia' sule anna kuitai.’ ");
INSERT INTO ptu_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Kitimba'im kiua: ‘Indo änä'-änä' tä' mala sisähä' ambeki, aka maka' la sisähä' la mate ambeki.’ ");
INSERT INTO ptu_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Sapo' muuaam dakam: ‘Tä'koa' mala sule dio oloku ke tä'i solakoa' adimmu.’ ");
INSERT INTO ptu_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Tappana sulekam lako ambeki, kitulasammi indo tula'mu. ");
INSERT INTO ptu_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Pissananna nasua okam ambeki sule inde mualli kinande, ");
INSERT INTO ptu_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","kitimba'um kiua: ‘Tä'kam mala lao lako siita puäki ke tä'i kipasola adingki. Anggam anna malakam lako ke kipasolai.’ ");
INSERT INTO ptu_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Lambi' ma'kada ambeki naua: ‘Puha muissanna' anggam dua änä'na Rahel, indo balungku. ");
INSERT INTO ptu_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Indo kakanna napelleimä'. Tä' mala tapuham naande olo'-olo' to peande aka sule lako temo tä' liupi deem sule. ");
INSERT INTO ptu_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Maka' la umbaba pole boa' inde tämpä' anna deenni battu aka muakai, iam too la umpomapi'di'ä' napatei pissam illaam inde kamatuaangku.’ ");
INSERT INTO ptu_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","31","Maka' tä' la kupasola inde adingku ma'pasule lako ambeki, la matem too pole' ambeki. Aka matua punalam anna angga ham ia inde änä'na natisäke'i penabanna. Maka' la kipahuai kamapi'disam, iam pole' la umpatei. ");
INSERT INTO ptu_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Mane deenni, puhaä' ma'dandi lako ambe' kuua: ‘Kao untanggunni inde änä'mu. Maka' tä' kupopa'pasuleangko, kao umpendudunni kadakena sule lako mateku.’ ");
INSERT INTO ptu_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Dadi kupelau matim, puäku, anna kaoi tohho inde umposabua' bala'na adingki, anna päbäii ia ma'pasule sola inde mai kakanna. ");
INSERT INTO ptu_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Anu' la kuakam susi ma'pasule lako ambeki ke tä'i kipasola inde änä'na. Tä' la kusaha muita ambeki nahua pi'di' kamasussaam.” ");
INSERT INTO ptu_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Tappana tä'um nabela Yusuf untähäm penabanna, iya ussuam ingganna to mengkähäna messubum, aka la umpasoa penabanna anna la umpa'paissangam kalena lako solasubunna. Tappana lessu' asam lako sulibam indo to mengkähäna, ");
INSERT INTO ptu_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","uhhu'-uhhu'um sumahho Yusuf sampe nahingngi duka' indo to Mesir dio sulibam, anna lambi' kahebana lako banuanna Firaun. ");
INSERT INTO ptu_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Ma'tula'um Yusuf lako solasubunna naua: “Kaom too inde Yusuf. Tubopaka ambe'?” Sangngim tä' naissam mentimba' solasubunna aka mahea' sugali' tappana naissam naua Yusuf dia. ");
INSERT INTO ptu_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Ma'kada oom Yusuf naua: “Mai-maikoa'.” Iya lakoim umpengkahuku'i Yusuf. Naua oom: “Kaom too inde Yusuf indo to umbalu'a' indo lessu' lako tau to la sule inde Mesir. ");
INSERT INTO ptu_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Daa ummasussaa' sola ussosso kalemu aka indo pa'pogau'mua' lessu'. Aka setonganna Puang Allataala too umbabaä' sule eta inde umpendioloikoa' la umpesäkäi sungnga'na tau buda. ");
INSERT INTO ptu_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Temo mane kadua taunna kakobeam. Lima taumpi la diolaam tä' mengkähä anna tä' deem alaangkinande. ");
INSERT INTO ptu_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Napopendioloä' Puang Allataala la umpesäkäikoa' muolai inde kaha-kaha memängä-mängä, lambi' napatubokoa' sola pessubummu. ");
INSERT INTO ptu_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Dadi setonganna taikoa' nasuhum suleä' inde, sapo' Puang Allataala umbabaä' sule. Napatadongkonnä' untomatuai Firaun lambi' nabeennä' kakuasaam illaam banuanna anna illaam lembäna Mesir. ");
INSERT INTO ptu_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Temo, la umpasihha'a' ma'pasule lako ambe' anna muuaannia': ‘Naua änä'mu Yusuf: Naäkä'ä' Puang Allataala muanda'i kakuasaam illaam lembäna Mesir. Dadi la maiko masimpam. ");
INSERT INTO ptu_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Anna mala tohho diokoa' Gosyen, sola-sola änä'mu anna ampomu, patuboammu anna ingganna kullemu anna mala sikahuku'kia'. ");
INSERT INTO ptu_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Maka' tohho dioko Gosyen mala mahuku'koa' kubeem kapahalluammu, aka la limapi taunna kakobeam. Dadi inde, kupeä lalanna anna mala tä'koa' kakuhängam sola ingganna kasahapuammu anna pentuhu'mu.’ ");
INSERT INTO ptu_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Temo ungkannassaia' nasa'bii Benyamin, kao Yusuf ma'kale umpa'tula'ikoa'. ");
INSERT INTO ptu_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Tulasanni ambe' kamatandeangku inde Mesir anna pa'huttusanni pada muitannaa' diona kakuasaangku, mane umpasihha'ia' umpasola sule.” ");
INSERT INTO ptu_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Puhai, ungkalapu'im Benyamin adinna napasindum sumahho, iya sumahho duka' Benyamin ungkalapu'-lapu'i kakanna. ");
INSERT INTO ptu_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Anna mane ungkalapu'i asanni solasubunna napasindum sumahho anna naudunni. Puhai, sipa'tula'-tula'um pole'. ");
INSERT INTO ptu_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Tappana lambi' kahebana lako banuanna Firaun diua sulei solasubunna Yusuf, tilalla' duka' Firaun sola ingganna to mengkähä illaam kahajaanna. ");
INSERT INTO ptu_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Iya nauam Firaun lako Yusuf: “Suai solasubummu ma'pasule lako Kanaan unteke' gandum, ");
INSERT INTO ptu_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","anna umpasolai ambemu sola ingganna kasahapuanna sule inde. La kubeem handam mapianna litä' illaam inde Mesir anna napekamuandei. ");
INSERT INTO ptu_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Anna lako ingganna solasubummu, beenni sanaka-naka bendi anna napakei dio mai umbaba bainena sola änä'na anna ambemu. ");
INSERT INTO ptu_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Anna muuaanni: ‘Daa ungkasahaanna' kullemu umpellei, aka handam mapianna inde lembäna Mesir la muampuanna'!’” ");
INSERT INTO ptu_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Indo tula'na Firaun natuhu' asam änä'na Israel. Iya nabeemmi Yusuf sanaka-naka bendi situhu' pahentana Firaun, anna tinallo la naande muola lalam. ");
INSERT INTO ptu_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Nabeempi sandai si sapasam poheba bakahu. Anggam Benyamin dibeem ia tallu hatu' doi' peha' anna lima pasam poheba bakahu. ");
INSERT INTO ptu_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Umpakatupi duka' ambena sapulo keledai dipatteke'i sanda dio handam mapianna issinna Mesir, anna sapulo keledai bihä dipatteke'i gandum, hoti anna ande-ande senga' la naande muola lalam mengkalao dio Kanaan sule lako Mesir. ");
INSERT INTO ptu_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Muuaammi solasubunna: “Pengkalaongkoa', angga hia daa ussianu-anua' lako lalam.” ");
INSERT INTO ptu_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Le'ba'im umpellei Mesir, ma'pasule lako Kanaan umpellambi'i Yakub ambena. ");
INSERT INTO ptu_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Iya napa'tulasammi naua: “Tubopi Yusuf, anna ia to handam kuasa dio Mesir.” Tappana nahingngi Yakub kaheba ia too, iya mängä-mängä bäbä aka tä'pi ungkannangam pa'tula'na änä'na. ");
INSERT INTO ptu_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Sapo' tappana nahuttusam asam ingganna pa'tula'na Yusuf, anna naita toi indo bendi napa'pakatuam Yusuf la napake lako Mesir, iya sule sule sumanga'na anna ");
INSERT INTO ptu_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","ma'kadai naua: “Matehede, tubo si'dapi päläe' änä'ku Yusuf! La laoä' lako anna kuita siapi mane mateä'.” ");
INSERT INTO ptu_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Ma'pakahappim Israel anna mengkalaoi umbaba asam kullena. Sulei lako Bersyeba umbabam bua pemala'na lako Puang Allataala to napenombai Ishak, ambena. ");
INSERT INTO ptu_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Tappana mamma' bengi, iya nalipim Puang Allataala Israel anna napa'tula'i naua: “Yakub, Yakub.” Mentimba'um naua: “Indeä' Debata.” ");
INSERT INTO ptu_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Ma'kadam Puang Allataala naua: “Kaom too Puang Allataala to napenombai ambemu. Daa ummahea' le'ba' lako Mesir, aka la kupakembea' pessubummu dio. ");
INSERT INTO ptu_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","La kuundu'ko dio Mesir, anna la kubaba sule pessubummu ma'pasule tama inde botto. La ma'kale Yusuf untuhhungangko matammu ke mateko.” ");
INSERT INTO ptu_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Iya mengkalaom Yakub dio Bersyeba. Naalam änä'na indo bendi napakatuam Firaun anna napalängänni sola ingganna manintunna anna ampona. ");
INSERT INTO ptu_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","7","Iya sangngim nababam lako Mesir olo'-olo'na sola ingganna kulle senga' indo pallolonganna dio lembäna Kanaan. Anna ingganna pessubunna Yakub napasola asam susi ingganna änä'na teem ampona muane anna baine. ");
INSERT INTO ptu_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Indem ia pessubunna Israel (battu diua Yakub) to napasola lako Mesir: Ruben, änä' uluana; ");
INSERT INTO ptu_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Änä'na Ruben iam ia: Henokh, Palu, Hezron anna Karmi. ");
INSERT INTO ptu_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Änä'na Simeon iam ia: Yemuel, Yamin, Ohad, Yakhin, Zohar anna mesapi änä'na isanga Saul, to Kanaan indona. ");
INSERT INTO ptu_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Änä'na Lewi iam ia: Gerson, Kehat anna Merari. ");
INSERT INTO ptu_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Änä'na Yehuda iam ia: Er, Onan, Syela, Peres, anna Zerah. Sapo' Er anna Onan mate dio Kanaan. Peres undadiam Hezron anna Hamul. ");
INSERT INTO ptu_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Änä'na Isakhar iam ia: Tola, Pua, Ayub anna Simron. ");
INSERT INTO ptu_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Änä'na Zebulon iam ia: Sered, Elon anna Yahleel. ");
INSERT INTO ptu_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Padam too pandadianna Yakub to nadadiangam Lea dio Padan-Aram, anna deempi baine änä'na isanga Dina. Dadi ingganna pessubunna Yakub to buttu dio mai Lea tallu pulo tallu ia asanna. ");
INSERT INTO ptu_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Änä'na Gad iam ia: Zifyon, Hagi, Syuni, Ezbon, Eri, Arodi anna Areli. ");
INSERT INTO ptu_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Änä'na Asyer iam ia: Yimna, Yiswa, Yiswi, Beria anna mesapi baine isanga Serah. Änä'na Beria iam ia: Heber anna Malkiel. ");
INSERT INTO ptu_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Iam too sapulo annam pessubunna Yakub buttu dio mai Zilpa, indo sabua'na Lea to nabeem Laban ambena. ");
INSERT INTO ptu_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Rahel, bainena Yakub, dua ia änä'na isanga: Yusuf anna Benyamin. ");
INSERT INTO ptu_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Yusuf dio Mesir dua ia änä'na isanga: Manasye anna Efraim, nadadiangam Asnat änä'na Potifera, to muanda'i kasandoam dio On. ");
INSERT INTO ptu_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Änä'na ia Benyamin iam: Bela, Bekher, Asybel, Gera, Naaman, Ehi, Rosh, Mupim, Hupim anna Ared. ");
INSERT INTO ptu_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Iam too sapulo appa' pessubunna Yakub buttu dio mai Rahel. ");
INSERT INTO ptu_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Sitahhu'na änä'na ia Dan: Husim. ");
INSERT INTO ptu_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Änä'na ia Naftali appa' iam: Yahzeel, Guni, Yezer, anna Syilem. ");
INSERT INTO ptu_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Inde to pitu, pessubunna Yakub buttu dio mai Bilha, indo sabua'na Rahel to nabeem Laban ambena. ");
INSERT INTO ptu_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Dadi pessubunna Yakub to napasola le'ba' lako Mesir, annam pulo annam ia asanna, sulibam manintunna. ");
INSERT INTO ptu_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Anna änä'na ia Yusuf subum dio Mesir dua. Dadi pessubunna Yakub dio Mesir pitu pulo ia asanna sola kalena. ");
INSERT INTO ptu_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","29","Ussuam Yehuda Yakub mendiolo lao umpellambi'i Yusuf umpekutanaam lalam lako Gosyen. Tappana landa'i lako Gosyen längämmi bendinna Yusuf anna laoi untammui ambena. Silambi'na ambena nakalapu'im anna sumahhoi masäe. ");
INSERT INTO ptu_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Nauam Yakub lako Yusuf: “Temo ahu'mä' pole' mate, aka kuitangko anna kuissammi kuua tubo mammopoko.” ");
INSERT INTO ptu_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Ma'kadam Yusuf lako solasubunna anna kasahapuanna naua: “La laopä' kupaissanni Firaun kuua: ‘Suleim solasubungku anna ingganna kasahapuanna ambeku dio mai Kanaan.’ ");
INSERT INTO ptu_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","La kutulasam toi liu kuua: ‘Indo ingganna kasahapuangku muane sangngim to si umpatubo domba, beke anna sapim. Anna umbaba dombana, bekena, sola sapinna anna ingganna kullena dio mai Kanaan.’ ");
INSERT INTO ptu_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Dadi maka' too natambaikoa' Firaun anna napekutaanni pengkähängammua', ");
INSERT INTO ptu_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","la muuaanna': ‘Inna mengkalao bahinni'ki si umpatubokam olo'-olo' anna inna susi mengkalao dio mai tomatuangki,’ anna malakoa' napatohho inde Gosyen.” Ma'kada susi Yusuf aka indo to Mesir si nakahidi' la umpasola to si ma'kambi'. ");
INSERT INTO ptu_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","2","Umpasolam lima solasubunna Yusuf, anna le'ba'i umpellambi'i Firaun. Landa'i, ma'tula'um Yusuf naua: “Sulem ambeku anna solasubungku dio mai Kanaan, sitonda dombana, bekena, sapinna, anna ingganna kullena. Temo dioim Gosyen.” Iya umpa'paissangammi solasubunna lako Firaun. ");
INSERT INTO ptu_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Nakutanaim Firaun naua: “Aka pengkähängammua'?” Natimba'im naua: “To ma'kambi'kam susi tomatuangki anna nene to kiponene. ");
INSERT INTO ptu_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Sulekam la messihuhu inde aka mapana' kakobeam dio Kanaan. Anna pa'de polem humpu' naande patuboangki dio. Kela mala umpäbäikam tohho dio Gosyen.” ");
INSERT INTO ptu_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Ma'kadam Firaun lako Yusuf naua: “Temo sulem ambemu anna solasubummu. ");
INSERT INTO ptu_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Inde Mesir beba'ko. Päbäii tohho dioi Gosyen, aka etam handam mapianna ongeam inde Mesir. Anna muuaangannä' solasubummu handam manähäna ma'kambi' anna napahesannä' to la ungkambi' patuboangku.” ");
INSERT INTO ptu_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Umpasola duka' ambena Yusuf lao napa'paissangam lako Firaun. Iya umpa'lambeammi Firaun Yakub. ");
INSERT INTO ptu_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Nakutanaim Firaun naua: “Sanakam taummu ambe'?” ");
INSERT INTO ptu_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Natimba'im Yakub naua: “Sahatu' tallu pulom taunna illaannä' pangngola-lalangam. Inde katuboangku naponnoi kamasussaam, anna kappo'di' ke dipasibandinni katuboanna nene to kuponene illaam pangngola-lalanganna.” ");
INSERT INTO ptu_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Puhai, umpa'lambeam polepi Firaun Yakub, mane le'ba'i sule. ");
INSERT INTO ptu_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Iya le'ba'um Yusuf umbeem ambena anna solasubunna handam mapianna litä' dio Mesir sikahuku' kota Rameses, situhu' pahentana Firaun. ");
INSERT INTO ptu_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Napatoka asammi Yusuf la kinandena ambena anna solasubunna sola ingganna kasahapuanna, situhu' budanna änä'na. ");
INSERT INTO ptu_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Tuttuam mapana' kakobeam nasi'dingam hupatau susi dio Mesir susi dio Kanaan, nasuhum malamma pa'botto aka tä'um deem naande. ");
INSERT INTO ptu_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Ingganna doi' pebaja'na to Mesir anna to Kanaan to sule mualli gandum, nahempum asam Yusuf anna napadioi banuanna Firaun. ");
INSERT INTO ptu_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Tappana tappu' asanni doi'na tau dio Mesir anna Kanaan, suleim to Mesir umpellambi'i Yusuf melau naua: “Tappu'um doi'ki, sapo' beengkam kinande indana matekam.” ");
INSERT INTO ptu_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Natimba' Yusuf naua: “Maka' tappu'unna' ia doi'mu olo'-olo'mua' beennä', anna kubeengkoa' kinande.” ");
INSERT INTO ptu_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Iya umpebeennim olo'-olo'na lako Yusuf nasukasam kinande. Anna nabeenni kinande suka'na dahanna, dombana, sapinna, anna keledainna. Susim too anna malai deem naande taum eta too. ");
INSERT INTO ptu_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Kende'i taum, sule pole oom hupatau lako Yusuf naua: “Tä' kibuniangam setonganna tappu'um doi'ki anna olo'-olo'ki aka muala asammi. Angga ham deem kiampuam, kaleki anna litä'ki. ");
INSERT INTO ptu_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Pesäkäikanni indana matekam, tilaum toi litä'ki. Allikam sola litä'ki, kinande la umbeengkam, anna naposabua'kam Firaun. Beengkam banne kiambo' indana tohho bäbäi litä'ki anna malakam tubo.” ");
INSERT INTO ptu_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Ingganna litä' dio Mesir naalli Yusuf, anna napuänganni Firaun. Ingganna to Mesir umbalu' asammi litä'na aka mapana' sugali' kakobeam. Susim too anna naampuam asammi litä' Firaun dio Mesir. ");
INSERT INTO ptu_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Anna ingganna to Mesir naposabua' asam Yusuf. ");
INSERT INTO ptu_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Angga ham tä' naalli Yusuf ingganna litä'na sando aka abana si nabeem ia kapahalluanna Firaun. Iam too anna tä'um ia umbalu' litä'na. ");
INSERT INTO ptu_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Ma'kadam Yusuf lako hupatau naua: “Ikoa' anna litä'mu puham kualli, napuängam Firaun. Indem banne dibeengkoa' la muambo'a'. ");
INSERT INTO ptu_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Angga hia ke kende'um la umbahe limaa'; sambaheam la umbeenna' Firaun, anna appa' baheanna la umpobannea' taum pole anna la umpotuboa' sola änä'mu anna ingganna tau illaam banuammu.” ");
INSERT INTO ptu_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Mentimba'im naua: “Puhangkam umpesäkäi. Assala'na ungkamasei liukam, päbäi naposabua'kam Firaun.” ");
INSERT INTO ptu_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Susim too pa'ulalanna Yusuf muäto' diona bahe limanna bua pengkähä dio Mesir dibeem Firaun. Anna pangngätosam iam too naanda'i liu to Mesir sule lako temo. Angga ham litä'na sando tä' naampuam Firaun. ");
INSERT INTO ptu_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Susim too Israel untadongkonni Gosyen dio Mesir. Mellängäm asam salu katuboanna sahapunna anna membea' pessubunna dio. ");
INSERT INTO ptu_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Sapulo pitupi taunna tubo Yakub dio Mesir, nasuhum mala nalambi' sahatu' appa' pulo pitu taunna naolaam tubo. ");
INSERT INTO ptu_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","30","Tappana la mate kale, untambaim Yusuf, änä'na, anna napa'tula'i naua: “Maka' sule tama pa'kamasemu di kao, anda'i inde ahena too' apangku aka la ma'pindako. Anna mala umpasule lako liu pa'kamasemu tama kaleku, tä'ä' la ullamum inde Mesir ke mateä'. Aka kupemulu la dilamum sola tomatuangku dio ku'bu'na. La umbabaä' lako Kanaan anna ullamum dioä'.” Natimba' Yusuf naua: “La kupalako situhu' pa'elo'mu.” ");
INSERT INTO ptu_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Ma'kada Yakub naua: “Pa'pindako keta la umpasule lakoi.” Ma'pindam Yusuf, iya menombam Yakub längäm Puang Allataala dio pengnguluam petindoanna. ");
INSERT INTO ptu_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Pissam wattu sule tau untulasanni Yusuf naua: “Masaki ambemu.” Mengkalao siaham Yusuf umpasola indo dua änä'na, isanga Manasye anna Efraim, anna le'ba'i muolläi ambena. ");
INSERT INTO ptu_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Tappana naissam Yakub naua sule Yusuf, napengkabelaim bangom anna muokko'i yabo petindoanna. ");
INSERT INTO ptu_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Ma'kadam Yakub lako Yusuf naua: “Puham umpa'paitaam kalena Puang Allataala To Handam Kuasa lako kaleku dio Lus lembäna Kanaan, anna natamba'ä' ");
INSERT INTO ptu_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","naua: ‘La kupabuda pandadiammu anna la kupakembea' pessubummu la umpangngissi lao mobotto-bottoam. Anna inde botto la kubeem pessubummu la napomana' sule lako salako-lakona.’ ");
INSERT INTO ptu_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Anna inde dua änä'mu to dadi indem Mesir kulambi', Efraim anna Manasye, la kuala änä' ikale anna la kumana' susi Ruben anna Simeon. ");
INSERT INTO ptu_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Sapo' maka' deempi änä'mu undadiam pole, la iko ia duka' ungkonai. Anna diona mana'na änä' senga'mu, Efraim sola Manasye la umbeenni. ");
INSERT INTO ptu_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Ia anna kupateenni aka pa'lalam penabangku lako Rahel indomu. Muola lalannä' ma'pasule dio mai Padan anna matei indomu dio Kanaan sikahuku' Efrata anna nababa sugali' penabangku. Kulamum etam, dio ampe'na lalam lako Efrata.” (Indo Efrata disangaim temo Betlehem). ");
INSERT INTO ptu_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Tappana muita änä'na Yusuf, mekutanam Israel lako Yusuf naua: “Menna keänä' indee?” ");
INSERT INTO ptu_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Natimba' Yusuf naua: “Indee änä'ku nabeennä' Puang Allataala inde Mesir.” Nauam Israel: “Pomahukusannä' mai anna kupa'lambeanni.” ");
INSERT INTO ptu_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Tä'um masiä' naita Israel aka matuam anna makuhibo-hibom pennenne'na. Napakahuku'im Yusuf indo änä'na lako, iya bassim nakalapu'im Israel naudum. ");
INSERT INTO ptu_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Mane nauai Israel lako Yusuf: “Tä'um deem kubai-bai la kuitapoko, sapo' mangngeloham di Puang Allataala, lambi' malapokoa' kuita sola änä'mu temo.” ");
INSERT INTO ptu_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Mualam änä'na Yusuf dio mai abinganna Israel, mane ma'balinguntu'i menomba dio olona ambena. ");
INSERT INTO ptu_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Puhai, muala oom änä'na Yusuf, indo Efraim, änä' tämpä'na anna napaokko'i dio tandai kaihinna ambena. Anna Manasye ia, änä' uluana, napadio tandai kananna ambena. ");
INSERT INTO ptu_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Sapo' umpasisula' di limanna Israel, lima kananna napaokko' yabo ulunna Efraim, anna lima kaihinna napaokko' yabo ulunna Manasye, anna ia hi ulua. ");
INSERT INTO ptu_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Puhai, umpa'lambeammi Yusuf sola änä'na naua: “Puang Allataala to napenombai neneku Abraham anna ambeku Ishak, iam too to ungkambi' liuä' sule lako temo. ");
INSERT INTO ptu_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Ia toi Malaika' to ullappasannä' dio mai ingganna kakadakeam. Iam too duka' la untamba' inde änä'-änä' dua. Kela mala sangangku, sanganna neneku Abraham, anna sanganna ambeku Ishak tontä disa'bu' illaam kalena inde änä'-änä', anna la bakka' pessubunna umponnoi lao lino.” ");
INSERT INTO ptu_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Tä' masannam penabanna Yusuf tappana muita ambena umpaokko' lima kananna yabo ulunna Efraim. Naanda'im indo lima kananna ambena la naäkä' dio mai ulunna Efraim anna la napalulakoi ulunna Manasye. ");
INSERT INTO ptu_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Ma'kadam lako ambena naua: “Daa umpateenni ambe'. Inde hia änä' ulua la umpa'paokko'i lima kanammu yabo ulunna.” ");
INSERT INTO ptu_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Sapo' moka ambena naua: “Kuissam änä'ku, kuissam siam. Manasye la kasalle duka' kakuasaanna anna la buda pessubunna. Sapo' la kasalle puha ia kakuasaanna adinna anna la membea' umpangngissi lao mobotto-bottoam.” ");
INSERT INTO ptu_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Iya bassim napa'lambeammi Israel indo änä'na Yusuf naua: “La si natula' sangammua' to Israel ke umpa'lambeanni hupatau. La naua: ‘Ma'ulalam dam Puang Allataala anna napasusiko Efraim anna Manasye.’” Susim too napayolo ia Efraim anna napaibundi ia Manasye. ");
INSERT INTO ptu_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Nauam Israel lako Yusuf: “Muitam too inde abana mahuku'um kamateangku, sapo' Puang Allataala la muolaangkoa' anna la nababakoa' ma'pasule lako botto litä'na nenemu. ");
INSERT INTO ptu_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Anna iko kubeem ongeam mentamungku aka kupakalandoko iko anna la solasubummu. Indo litä' kuala dio mai to Amori aka kutalo illaam pa'bundusam.” ");
INSERT INTO ptu_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Untambaim änä'na Yakub naua: “Mai asangkoa' anna umpehingngii, angku tulasangkoa' la maaka susi katuboammua' sola ingganna pessubummu allo di dako'na. ");
INSERT INTO ptu_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Ikoa' änä'na Yakub pa'hempungkoa' anna umpatananniia' talinga tula'na Israel ambemu. ");
INSERT INTO ptu_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Ruben änä' uluaku, iko uhu kamatohoangku, pa'pahandusam läpu'ku. Ikom to handam matande anna kuasa. ");
INSERT INTO ptu_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Susiko uwai salu buntu' tä' umbela ungkuasai kalemu, nasuhum taikom dipaitoo'na aka umpasolako metindo bainena ambemu. Ullängänni anna ungkadakeiko petindoangku. ");
INSERT INTO ptu_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Simeon anna Lewi to siundu'; Pa'dammua' umpake ma'gau' makahha'. ");
INSERT INTO ptu_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Tä'kia' too sola pattuju anna tä'kia' sola pa'palakoam. Aka untuhu'ikoa' nassummu nasuhum umpangngula'koa' penabammu lao papateam anna uhhatta'ikoa' uha' kondesanna sapim. ");
INSERT INTO ptu_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","La napassalakoa' DEBATA aka penaba makahha'mua' anna aha' kadakemua'. La kusehangkoa' lako alla'-alla'na pessubunna Yakub anna la kutähhä'koa' tama alla'-alla'na pessubunna Israel. ");
INSERT INTO ptu_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Yehuda, la uhhuppu' balinna; la napa'kasallei anna napenombai solasubunna. ");
INSERT INTO ptu_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","O änä'ku, susingko singa mangnguha puhai muande pealanna, ma'pasulem sule längäm ongeanna lao mamma'. Tä' deem bahani la untundanni. ");
INSERT INTO ptu_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Yehuda la muanda'i liu tekkem kahajaam. Pessubunna la ma'pahenta sule lako kasuleanna To muanda'i kakuasaam. Anna hupatau buttu dio mai ingganna kahajaam la mentinaum lako pahentana. ");
INSERT INTO ptu_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Änä' keledainna Yehuda la disäke' lako handam mapianna too' anggur, anna uwai anggur la natappa'iam pohebana tandana bosa'. ");
INSERT INTO ptu_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","La malotä matanna napobua' anggur anna mabusa isinna napobua' bumbungam. ");
INSERT INTO ptu_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Zebulon la tohho dio bihim le'bo'; ongeanna la si naongei tisampo kappala' lempä mentulindum, anna attasa'na la sule lako Sidon. ");
INSERT INTO ptu_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Isakhar susi keledai matoho ma'päsä illaam alla' teke'na. ");
INSERT INTO ptu_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Tappana muita mapia pellubeanna anna malompona litä', iya ponno penabanna umbaba babaanna anna malängngo' penabanna diposabua' assala'na mala tohho eta. ");
INSERT INTO ptu_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Dan la tohho ma'bisaha anna uhhindim solana, aka pessubunna duka' Israel. ");
INSERT INTO ptu_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","La susi ula' lako lalam untikku buni kambutu' daham, nasuhum metobä boko' to ussäkei. ");
INSERT INTO ptu_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","O DEBATA, Iko kuhannuam la melappasam dio mai kamasussaam. ");
INSERT INTO ptu_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Gad, la napemäläiko tau napamuhui, sapo' iko hi la umpadondoi anna umpamuhui. ");
INSERT INTO ptu_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Asyer, la langa' kinandemu, iko la naongei buttu kinande si napohäe tomahaja. ");
INSERT INTO ptu_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Naftali la susiko jonga bihä dilappa', si mapia pa'änäsam. ");
INSERT INTO ptu_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Yusuf sihhapangko kaju paha' bua tubo dio sa'de kalimbuä, mahombo täkena mehhoe lao ullebam bala. ");
INSERT INTO ptu_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Napandasako balimmu, natalimbum tama nabälä'du'. ");
INSERT INTO ptu_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Sapo' tontä liu matogom bälä'du'mu anna matoho liu katea'mu, napasukum kuasanna To napenombai Yakub. To Ma'kambi'na anna Hindim Batunna Israel. ");
INSERT INTO ptu_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Puang Allataala To Handam Kuasa to napenombai ambemu la umpamoloiko, napatuhungam pa'tamba' yabo mai langi' anna dio mai le'bo' sola hongko' banne tau. ");
INSERT INTO ptu_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Hongko' buttu di DEBATA lako ambemu, mayaboam puha ia anna la hongko' buttu illaam mai ingganna tanete masäe. Ingganna hongko' ia too la lu lako Yusuf anna lu dokkoi lisu pala'na, aka ia tika'liu' mapianna pa'palakoanna illaam alla'-alla'na solasubunna. ");
INSERT INTO ptu_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Benyamin bahani susi serigala. Mebengngi' muande pealanna, kahubenni nataba-tabam la'binna.” ");
INSERT INTO ptu_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Iam too inde diona pessubunna Israel anna kada napayolo lambam natampeam sapulo dua änä'na situhu' la sihatanna si mesa-mesa pandadianna. ");
INSERT INTO ptu_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","30","Ma'pakahi'dim Yakub lako änä'na naua: “Mahuku'um kamateangku. Angga hia la ullamum dioä' too Kanaan siampe' neneku anna tomatuangku, illaam indo leä dio Makhpela sitingngajo Mamre. Indo leä sola bela' lako ampe'na puha naalli Abraham lako Efron to Het, la napa'ku'bu'i. ");
INSERT INTO ptu_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Etam naongei Abraham sola Sara bainena dilamum. Eta toi naongei Ishak sola Ribka bainena dilamum, anna eta duka' kupallamunni Lea. ");
INSERT INTO ptu_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Indo litä' anna ku'bu' pangngallinna neneku Abraham lako to Het.” ");
INSERT INTO ptu_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Tappana puha ma'pakahi'di lako änä'na, iya metindom anna ummaloloanni bitti'na anna kattui penabanna lambi' le'ba'um sungnga'na ma'mesa sola nene to naponene. ");
INSERT INTO ptu_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Ussämbäsammi kalena Yusuf sumahho napasindum ungkalapu'i ambena naudum. ");
INSERT INTO ptu_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Mane ussuai sabua'na to si biasa ullima'i to mate, ussussui bauam bubanau' bakkena Israel, ambena, anna malai tä' bosi. Iya napateemmi situhu' tula'na Yusuf. ");
INSERT INTO ptu_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Appa' pulo allona diolaam ungkähäi aka inna si pada masäena diolaam umpessussuam bauam bubanau' anna malai tä' bosi to mate. Anna pitu pulo allona naolaam to Mesir ma'bahata. ");
INSERT INTO ptu_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Tappana lendu'i pa'bahataam, nauam Yusuf lako to dipake illaam banuanna Firaun: “Kamaseiä' laoko uaangannä' Firaun: ‘Naua Yusuf: ");
INSERT INTO ptu_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","Indo anna la mate kalem ambeku napopa'pindaä' naua: “La ullamum dioä' too indo ku'bu' kupatoka dio Kanaan.” Dadi la laopä' ullamum ambeku anna balii too ma'pasulemä'.’” ");
INSERT INTO ptu_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Nauam Firaun: “Uaanni Yusuf: Laoko lamum ambemu situhu' pa'pindamu.” ");
INSERT INTO ptu_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Iya le'ba'um Yusuf la ullamum ambena napasolai ingganna to dipake anna matua ulunna illaam banuanna Firaun sola matua ulunna illaam lembäna Mesir. ");
INSERT INTO ptu_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Le'ba' asam duka' issi banuanna Yusuf, ingganna solasubunna sola ingganna issi banuanna ambena. Angga ham änä'-änä' anna olo'-olo'na tohho dio Gosyen. ");
INSERT INTO ptu_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Natuhu'pi buda to ma'bendi anna to ma'daham lambi' indo to le'ba' umpasolai ma'obim-obim. ");
INSERT INTO ptu_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Tappana sulei lako ongeam pallullusam gandum isanga Goren-Haatad, lambam libanna Salu Yordan, etam tohhoi umbatim anna ma'bahatai pitu benginna. ");
INSERT INTO ptu_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Tappana naita pa'botto dio Kanaan pa'bahataanna to Mesir dio, iya nasangaim indo ongeam Abel-Mizraim aka naua: “Naongei to Mesir umbatim anna ma'bahata.” ");
INSERT INTO ptu_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Susim too pa'palakoanna änä'na Yakub umpasule lako pepakahi'dinna ambena. ");
INSERT INTO ptu_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Nababa bakkena lako Kanaan anna nalamunni dio Makhpela sitingngajo Mamre, illaam leä naalli sola bela' Abraham lako Efron to Het napa'ku'bu'i. ");
INSERT INTO ptu_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Puhai melamum, ma'pasulem Yusuf lako Mesir sola solasubunna anna ingganna to napasola lao melamum lako Kanaan. ");
INSERT INTO ptu_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Tappana mate Yakub sangngim mahea'um solasubunna lako Yusuf naua: “La maakangkia' susi ke napaillaam penabai Yusuf indo gau' kadaketaa' lako kalena?” ");
INSERT INTO ptu_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Iya ussuam tau lao umpellambi'i Yusuf naua: “Indo anna tubopi ambemua', ma'pakahi'di naua: ");
INSERT INTO ptu_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","‘La untulasanna' Yusuf muua: La muampunni kasalaanna sola dosana solasubummu lako kalemu.’ Dadi kela mala muampunni kasalaanna inde mai sabua'na Puang Allataala to napenombai ambemua'.” Tappana dipalandasam Yusuf indo tula'na solasubunna, iya sumahhom aka mapi'di' penabanna. ");
INSERT INTO ptu_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Iya suleim solasubunna menomba lako Yusuf naua: “La umposabua'kanni.” ");
INSERT INTO ptu_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Sapo' naua Yusuf: “Daa ungkahea'ä', aka Puang Allataala hakä' too kao anna la kupasalakoa'? ");
INSERT INTO ptu_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Aka moi anna ungkalebuia' indo gau' kadake umpogausannä', sapo' gau' ia too napopangkakka' Puang Allataala tama kaleku, anna malaä' umpesäkäi sungnga'na tau buda tentomai. ");
INSERT INTO ptu_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Dadi, daa ummahea'a' aka ingganna kapahalluammu sola pandadiammua' la kubeengkoa'.” Malutte' Yusuf ma'kada lako solasubunna napamattangam penabanna. ");
INSERT INTO ptu_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Iya dio lium Mesir Yusuf anna solasubunna. Sahatu' sapulo taunna dadinna mane matei. ");
INSERT INTO ptu_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Muitapi peampoanna sule lako lapi' katallunna pessubunna Efraim anna muabimpi änä'na Makhir pessubunna Manasye. ");
INSERT INTO ptu_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Iya nauam Yusuf lako solasubunna: “Mahuku'um kamateangku, sapo' la naundu' dakoa' too Puang Allataala messubum illaam mai inde botto, lao lako botto puha nadandi sola umpa'pindai kalena lako Abraham, Ishak anna Yakub. ");
INSERT INTO ptu_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","La Puang Allataala hi too muundu'koa' messubum illaam mai inde botto.” Mane ussuai pessubunna Israel ma'pinda keta la nababai duka' bukunna lako Kanaan. ");
INSERT INTO ptu_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Wattunna anna matei Yusuf dio Mesir sahatu' sapulom taunna dadinna. Iya disussuim duka' bauam bubanau' bakkena indana bosii, mane dipatamai patti. ");
INSERT INTO ptu_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Susi inde kalohonganna Yesus Kristus peampoanna tomahaja Daud, peampoanna Abraham. ");
INSERT INTO ptu_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Keänä' Abraham undadiam Ishak, keänä' Ishak undadiam Yakub, keänä' Yakub undadiam Yehuda anna ingganna solasubunna. ");
INSERT INTO ptu_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Keänä' Yehuda undadiam Peres anna Zerah nasibalii Tamar, keänä' Peres undadiam Hezron, keänä' Hezron undadiam Ram, ");
INSERT INTO ptu_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","keänä' Ram undadiam Aminadab, keänä' Aminadab undadiam Nahason, keänä' Nahason undadiam Salmon, ");
INSERT INTO ptu_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","keänä' Salmon undadiam Boas nasibalii Rahab, keänä' Boas undadiam Obed nasibalii Rut, keänä' Obed undadiam Isai, ");
INSERT INTO ptu_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","keänä' Isai undadiam tomahaja Daud, keänä' Daud undadiam Salomo nasibalii indo bainena to mate Uria, ");
INSERT INTO ptu_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","keänä' Salomo undadiam Rehabeam, keänä' Rehabeam undadiam Abia, keänä' Abia undadiam Asa, ");
INSERT INTO ptu_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","keänä' Asa undadiam Yosafat, keänä' Yosafat undadiam Yoram, keänä' Yoram undadiam Uzia, ");
INSERT INTO ptu_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","keänä' Uzia undadiam Yotam, keänä' Yotam undadiam Ahas, keänä' Ahas undadiam Hizkia, ");
INSERT INTO ptu_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","keänä' Hizkia undadiam Manasye, keänä' Manasye undadiam Amon, keänä' Amon undadiam Yosia, ");
INSERT INTO ptu_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","keänä' Yosia undadiam Yekhonya anna ingganna solasubunna. Wattu eta too dipassa to Israel dipahhim lako Babel. ");
INSERT INTO ptu_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Puhai dipahhim lako Babel, iya keänä'um Yekhonya undadiam Sealtiel, keänä' Sealtiel undadiam Zerubabel, ");
INSERT INTO ptu_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","keänä' Zerubabel undadiam Abihud, keänä' Abihud undadiam Elyakim, keänä' Elyakim undadiam Azor, ");
INSERT INTO ptu_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","keänä' Azor undadiam Zadok, keänä' Zadok undadiam Akhim, keänä' Akhim undadiam Eliud, ");
INSERT INTO ptu_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","keänä' Eliud undadiam Eleazar, keänä' Eleazar undadiam Matan, keänä' Matan undadiam Yakub, ");
INSERT INTO ptu_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","keänä' Yakub undadiam Yusuf indo muanena Maria to undadiam Puang Yesus battu diua To dilanti' la mepasalama'. ");
INSERT INTO ptu_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Dadi, mengkalao dio Abraham sule lako tomahaja Daud, sapulo appa' lapi'na. Mengkalao dio Daud sule lako wattunna dipahhim to Israel napahhim to Babel, sapulo appa' lapi'na. Anna mengkalao dio wattunna dipahhim to Israel sule lako kadadianna To dilanti' la mepasalama', sapulo appa' oo duka' lapi'na. ");
INSERT INTO ptu_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Susi inde tulasanna indo anna dikebättänganni Yesus Kristus sule lako disubungam: Puhai mekutana Yusuf la umpobaine Maria, iya kebättä hia. Moi anna tä'pi deem sola muane, sapo' kebättä aka kakuasaanna Penaba Maseho. ");
INSERT INTO ptu_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Indo Yusuf mesa to meada', dadi maelo' la ungkattui Maria. Sapo' la mengkamma'-kamma' ungkattui aka moka la umpakasihi'i dio olona tau buda. ");
INSERT INTO ptu_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Mane mahassam ma'pikki'-pikki' Yusuf la ungkattui Maria, iya napalosaim mesa malaika' nasua Debata illaam pangngimpi nauaam: “O Yusuf peampoanna tomahaja Daud, daa ummahea' umpobaine Maria, aka indo bättäna, kakuasaanna Penaba Maseho umpadadii. ");
INSERT INTO ptu_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","La undadiam mesa änä' muane-ane anna la ussangai Yesus aka Ia la ullappasam umma'na dio mai dosana.” ");
INSERT INTO ptu_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Ia asanna ia too dadi anna mala sule lako indo kadanna Debata napalombum nabi naua: ");
INSERT INTO ptu_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Patananniia' talinga, indo änä' daha la kebättä lambi' undadiam mesa änä' muane-ane anna la disangai Imanuel, kalembasanna ‘Puang Allataala muundu'kia'.’” ");
INSERT INTO ptu_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Tappana milli' Yusuf, iya napalako siaham indo napahentaam malaika'na Debata lambi' umpobaine Maria. ");
INSERT INTO ptu_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Sapo' tä' deem moi podo la siampe'um metindo sule lako keänä' Maria. Tappana dadi, iya nasangaim Yusuf indo änä'-änä', Yesus. ");
INSERT INTO ptu_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Indo anna disubunganni Puang Yesus dio kota Betlehem illaam lembäna Yudea, wattu eta too Herodes mendadi tomahaja dio Yerusalem. Iya sulem dio Yerusalem sanaka-naka to tandai mata allo si manähä muita bintä napotanda. ");
INSERT INTO ptu_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Anna mekutanai naua: “Umba hia ngei naongei indo änä'-änä' mane subum, indo tomahajanna to Yahudi? Aka puha kiita bintäna dio bottoki dio tandai mata allo, nasuhum sulekam la kipenombai.” ");
INSERT INTO ptu_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Tappana naissam tomahaja Herodes tula' ia too, iya tä' deem pada satikkedu' anna husa' penabanna, susi toi duka' ingganna issinna Yerusalem sangngim tikkedu'. ");
INSERT INTO ptu_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Iya tappa nahempum siaham Herodes ingganna kapala sando anna to ullatta' Pepaondonganna Musa anna napelaui katähängam naua: “Situhu' Battakada Debata umba ngei la subum indo To dilanti' la mepasalama', indo puha nadandi Puang Allataala?” ");
INSERT INTO ptu_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Natimba'im naua: “Dio kota Betlehem illaam lembäna Yudea, aka abana inna susi Battakadanna Puang Allataala puha nasuha' mesa nabi naua: ");
INSERT INTO ptu_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘O kota Betlehem illaam lembäna Yehuda, tä'ko la mala dipa'bahinni'i illaam alla'-alla'na kota senga' to palumbängam illaam lembäna Yehuda. Aka iko la naongei kende' tomahaja to la ungkambi' umma'ku to Israel.’” ");
INSERT INTO ptu_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Puhai ia too, iya mengkamma'-kamma'um Herodes untambai indo to si manähä muita bintä napotanda anna nakutanai naua: “Piham anna uhunaia' muita indo bintä umpotanda?” ");
INSERT INTO ptu_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Puhai nakutanai, iya nasuam le'ba' lako Betlehem anna napakahi'dii naua: “Laongkoa' peä manappai indo änä'-änä', anna maka' too ullambi'unna', iya sulekoa' tulasannä' kao anna mala laoä' duka' kupenombai.” ");
INSERT INTO ptu_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","Tappana puha natahima indo pepakahi'dinna tomahaja Herodes, iya le'ba'im umpatahhu' pa'laoanna. Iya naita oom indo bintä to naita illaam tandai mata allo. Tä' deem la susi katilallasannai tappana muita indo bintä mellao yabo langi' umpendioloi lambi' tohho yabo sipatunna ongeanna indo änä'-änä'. ");
INSERT INTO ptu_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Tappa le'ba'i siaham tama indo banua, iya ullambi'um indo änä'-änä' sola Maria indona, iya ma'balinguntu'im dio olona indo änä'-änä' menomba. Mane umbukkai pa'pongngeanna anna mualai bulabam, lite kaju si bubanau', anna dama' si bubanau' isanga mur, pa'lalam penabanna lako indo änä'-änä', tanda pa'pakasallena. ");
INSERT INTO ptu_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Sapo' aka napalosai Debata illaam pangngimpi naua: “Daa muola lakoa' Herodes,” nasuhum lalam senga' naola ma'pasule lako bottona. ");
INSERT INTO ptu_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Tappana le'ba'i indo to si manähä muita bintä napotanda, iya ussuam mesa malaika' Debata umpalosai Yusuf illaam pangngimpi naua: “O Yusuf, bangom siahangko ammu pasihha'i umbaba lao inde änä'-änä' sola indona lako lembäna Mesir, aka mahassammi napeä Herodes inde änä'-änä' la napatei. La tohhokoa' dio lambi' kubeem pole oko pahenta la sitahhu'na umpogau'.” ");
INSERT INTO ptu_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Iya tappa bangom siaham duka' Yusuf indo bengi eta too anna le'ba'i umbaba indo änä'-änä' anna Maria indona lako Mesir. ");
INSERT INTO ptu_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Iya tohhoim dio sule lako mate Herodes. Kaha-kaha ia too dadi anna mala sule lako indo kadanna Debata puha natula' loppo' nabi naua: “Kutambai änä'ku dio mai Mesir.” ");
INSERT INTO ptu_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Tappana naissam Herodes naua: “Naakkalanniä' indo to si manähä muita bintä napotanda,” iya tä' deem pada sakeaha'. Nasuhum umpassubum mesa pahenta naua: “Ingganna änä'-änä' ke muanei mengkalao mane subum sule lako dua taum dadinna la dipatei asam, susi illaam kota Betlehem teem lako kota sikahuku'na.” Ia too napasikannai Herodes situhu' indo katähängam natula' indo to umpotanda bintä. ");
INSERT INTO ptu_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Iya sule lakom indo to puha natula' loppo' nabi Yeremia naua: ");
INSERT INTO ptu_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Ha'ba to umbatim dio kota Rama, Rahel ussahhoi änä'na anna moka si'da-si'da dipakahanga aka pa'deim änä'na naita.” ");
INSERT INTO ptu_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Indo anna matei Herodes, diopi Mesir Yusuf sahapu wattu eta. Iya napalosai oom mesa malaika'na Debata illaam pangngimpi naua: ");
INSERT INTO ptu_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“Bangongko ammu babai itim änä'-änä' sola Maria indona anna ma'pasulekoa' lako Israel, aka indo to la umpatei itim änä'-änä' puham mate.” ");
INSERT INTO ptu_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Iya bangommi duka' Yusuf anna umbabai indo änä'-änä' sola indona anna le'ba'i lako Israel. ");
INSERT INTO ptu_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Sapo' mahea' ma'pasule lako lembäna Yudea, aka napelele diua Arkhelaus umbala' Herodes ambena mendadi tomahaja dio. Iya napalosai pole oom mesa malaika'na Debata illaam pangngimpi naua: “Lu lakokoa' lembäna Galilea ammu tohho dioa'.” Iya lu lakom Galilea ");
INSERT INTO ptu_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","anna tohhoi illaam mesa tondä' diuaam Nazaret. Susim too anna mala sule lako indo tula'na Debata diona Änä'na napalombum nabi naua: “La diuaam to Nazaret.” ");
INSERT INTO ptu_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Masäei lessu'na ia too, iya sulem Yohanes to si mantedo' dio pohiallasam illaam lembäna Yudea anna napahandu'i umpalanda' kadanna Puang Allataala naua: ");
INSERT INTO ptu_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Tihokongannia' ingganna gau' kadakemu aka bambannam umpalako kapahentaanna Puang Allataala.” ");
INSERT INTO ptu_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Yohanes iam too inde indo puha napayolo lambam nabi Yesaya naua: “Deem tau dio pohiallasam metamba-tamba naua: ‘Patokaanni lalam Debata, maloloanganni lalam la naolanna.’” ");
INSERT INTO ptu_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Indo Yohanes to si mantedo' umpa'poheba bulu unta anna ma'beke' lollo'. Anna bati' sola duho si naande. ");
INSERT INTO ptu_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Iya sulem buda tau buttu yabo mai Yerusalem, anna dio mai lembäna Yudea anna ingganna tondä' dio sikahuku'na Salu Yordan umpellambi'i Yohanes. ");
INSERT INTO ptu_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Sangngim muakui dosana anna natedo'i dio Salu Yordan. ");
INSERT INTO ptu_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Anna buda toi duka' to illaam kakalebuanna Parisi anna to illaam kakalebuanna Saduki sule umpellambi'i Yohanes aka maelo' la ditedo'. Sapo' naitanna Yohanes sulei, iya nauaammi: “O inggammua' to si mambaba bulim, pessubunna to kadake gau'! Ussanga haka iko la malakoa' lappa' dio mai aha' kasallena Puang Allataala? ");
INSERT INTO ptu_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Pa'baju polekoa' anna pa'dodo pole anna mala tandaam diua ussosso si'dangkoa' gau'mu anna untingko' basabammu. ");
INSERT INTO ptu_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Daa muuaia': ‘Tä'kam la napassala Puang Allataala aka peampoannakam Abraham.’ Aka kutulasangkoa', inde mai batu la mala duka' napadadi Puang Allataala peampoanna Abraham! ");
INSERT INTO ptu_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Tentomai la dipembattaammi wase di ada'na Puang Allataala dilemposam ingganna kaju tää'na kembua manappa anna ditibei tama api. ");
INSERT INTO ptu_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Kao-kao uwai kupake untedo'koa' mendadi tanda katihokongammua'. Sapo' dako'i too sulem To kuasa puha Ia anna la kao. Aka moi la kubabaam sapatunna, tala sihatannä'. Ia-Ia Penaba Maseho anna api la napake natedosangkoa'. ");
INSERT INTO ptu_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Sihhapam to ma'tappi tokam dio limanna petappi la nase'laam banne maläpu' anna läkko'na. Ingganna banne maläpu' la dianna manappa tama loko, anna läkko'na la ditibe ia tama api tapi'de-pi'de.” ");
INSERT INTO ptu_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Wattu eta too, mengkalaom Puang Yesus dio Galilea le'ba' lako Salu Yordan. Dioi, umpellambi'im Yohanes anna napelaui la natedo'. ");
INSERT INTO ptu_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Sapo' moka salapi Yohanes untedo'i, naua: “Setonganna tuam, Iko hia la sihatam untedo'ä'! Maaka anna Iko ohi muuai: ‘Tedo'ä'’?” ");
INSERT INTO ptu_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Sapo' natimba'i Puang Yesus naua: “Päbäi untedo'ä' temo. Aka ia anna tapateenni aka pahallu la taponnoi asam ingganna pa'elo'na Puang Allataala.” Iya natuhu'im pelauanna lambi' natedo'. ");
INSERT INTO ptu_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Puhai ditedo', iya kende'um dio mai uwai. Iya naita siaham Puang Yesus tibukka langi' anna tuhunni Penabanna Puang Allataala susi dangam-dangam uhhampoi. ");
INSERT INTO ptu_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Iya dihingngi siaham kamaha buttu yabo mai suhuga naua: “Iam too inde Änä' pa'pakamajangku to umpomasannam penabangku.” ");
INSERT INTO ptu_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Puhai ia too, iya natettem Penaba Maseho Puang Yesus lako pohiallasam aka la napa'sändä'i tomahajanna setam. ");
INSERT INTO ptu_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Dioi, iya puasam Puang Yesus appa' pulo allona appa' pulo benginna nasuhum tadea'. ");
INSERT INTO ptu_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Iya sulem tomahajanna setam umpa'sändä'i naua: “Maka' Änä'na tongangko Puang Allataala, suai inde mai batu mendadi hoti!” ");
INSERT INTO ptu_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Sapo' natimba'i Puang Yesus naua: “Tää', aka puha tisuha' illaam Battakada Debata naua: ‘Taia kinande mandi la napotubo hupatau, sapo' setonganna too'-too'na katuboanna hupatau ingganna kadanna Puang Allataala.’” ");
INSERT INTO ptu_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Puhai ia too, umpasolam Puang Yesus lako indo Kota Maseho battu diua Yerusalem anna napayaboi bubunganna Banua Debata ");
INSERT INTO ptu_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","anna nauaanni: “Maka' Änä'na tongangko Puang Allataala, tobängangko kalemu inde dokko aka deem tisuha' illaam Battakada Debata naua: ‘Puang Allataala la ussua malaika'na unjagaiko; la natahimaiko anna mala moi bitti'mu tala tihuai lako batu.’” ");
INSERT INTO ptu_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Natimba' pole oom Puang Yesus naua: “Tää', aka puha tisuha' illaam Battakada Debata naua: ‘Daa umpa'sändä'i Puang Allataala Debatammu.’” ");
INSERT INTO ptu_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Iya umbabai pole oom Puang Yesus indo tomahajanna setam anna napasolai längäm tanete malangka'. Yaboi, napaitai asammi ingganna kapahentaam illaam inde lino sola kakasalleanna anna kamapiaanna ");
INSERT INTO ptu_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","anna nauai: “La kubeem asangko ingganna issinna inde lino ke ma'balinguntu'ko dio oloku umpenombaiä'.” ");
INSERT INTO ptu_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Natimba' pole oom Puang Yesus naua: “Päläiko lao Setam! Aka tisuha' illaam Battakada Debata naua: ‘Penombaiko Puang Allataala Debatammu anna anggam pa'elo'na la mala umpalako.’” ");
INSERT INTO ptu_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Iya le'ba' mandam indo tomahajanna setam umpellei Puang Yesus. Iya sulem sanaka-naka malaika' untahiai. ");
INSERT INTO ptu_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Tappana naissam Puang Yesus naua ditahungkum Yohanes to si mantedo', iya mengkalaom Ia dio Yudea le'ba' lako lembäna Galilea. ");
INSERT INTO ptu_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Tä'um hapa' dio Nazaret sapo' mentieli' lako kota Kapernaum anna tohho dioi. Indo Kapernaum dio bihinna le'bo' Galilea illaam attasa'na Zebulon anna Naftali. ");
INSERT INTO ptu_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Lu lako Kapernaum Puang Yesus anna mala sule lako indo kadanna Debata napalombum nabi Yesaya naua: ");
INSERT INTO ptu_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Attasa'na Zebulon anna Naftali illaam lembäna Galilea, dio lalam lako le'bo' Galilea, tandai libanna Salu Yordan, naongei buda tau taianna to Yahudi. ");
INSERT INTO ptu_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Anna tau ia too tubo illaam kamalillingam anna illaam lembäna kamateam. Sapo' nalambi'um pole' kamasiäsam kasalle, anna nadelle'im mata allo katuboam.” ");
INSERT INTO ptu_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Sulena Puang Yesus dio Kapernaum, iya napahandu'um napa'paissangam lako tau buda naua: “Tihokongannia' gau' kadakemu, aka bambannam umpalako kapahentaanna Puang Allataala!” ");
INSERT INTO ptu_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Mahassanni mellao Puang Yesus uhhuttu' bihinna le'bo' Galilea, iya muitam dua to ma'solasubum isanga indo kakanna Simon (biasa toi diuaam Petrus) anna isanga ia indo adinna Andreas mahassam modala, aka abana inna to si modala. ");
INSERT INTO ptu_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Iya napa'kadaim Puang Yesus naua: “Maikoa' ammu tuhu'ä' aka la kupadadikoa' to undala hupatau anna mala natuhu'ä'.” ");
INSERT INTO ptu_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Iya ullappa' siaham duka' dalana anna le'ba'i untuhu' Puang Yesus. ");
INSERT INTO ptu_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Napatahhu' oom mellao, iya muita oom to ma'solasubum isanga Yakobus anna Yohanes, änä'na Zebedeus, mahassam umpapia-piai dalana illaam lopinna. Iya natambaim duka' Puang Yesus, ");
INSERT INTO ptu_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","iya bassim umpellei siaham duka' lopinna sola ambena, anna le'ba'i untuhu' Puang Yesus. ");
INSERT INTO ptu_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Illaam lembäna Galilea, le'ba' Puang Yesus ullelei pa'sambajanganna to Yahudi ma'pa'guhu anna umpa'pakahebaam Kaheba Katilallasam naua: “Bambannam umpalako kapahentaanna Puang Allataala.” Anna umpabono' ingganna to masaki anna umpapia pole dadinna to sala dadi. ");
INSERT INTO ptu_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Indo pa'pogausanna Puang Yesus napelele asam tau dio lembäna Siria, nasuhum buda tau sule ullombai sangngim umbaba to masakinna. To masaki ia too nahua ma'hupa-hupa saki anna kamapi'disam susinna: to napentamai setam, to limpu mänesam, to mate kalena anna budapi saki senga'. Iya sangngim napabono' Puang Yesus, ");
INSERT INTO ptu_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","nasuhum tä' deem pada sabuda tau untuhu' lelenni. Deem to buttu dio mai lembäna Galilea, deem to buttu dio mai lembäna Sapulo Kota, deem to buttu yabo mai Yerusalem, deem to buttu dio mai lembäna Yudea, anna deem to buttu dipe mai lambam libanna Salu Yordan. ");
INSERT INTO ptu_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Tappana naita Puang Yesus buda tau sule ullombai, iya le'ba'um längäm mesa tanete. Muokko'i, iya sulem napellambi'i passikolanna. ");
INSERT INTO ptu_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Iya napahandu'um Puang Yesus ma'pa'guhu naua: ");
INSERT INTO ptu_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Kehongko' anna maupa' to umpopengkadio kalena dio olona Puang Allataala, aka tau ia too mendadim umma'na Puang Allataala illaam kapahentaanna. ");
INSERT INTO ptu_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Kehongko' anna maupa' to masussa penaba, aka tau ia too la napakahanga Puang Allataala. ");
INSERT INTO ptu_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Kehongko' anna maupa' to umpopengkadio penabanna, aka la napasule lakoam Puang Allataala indo puha nadandiam tau ia too. ");
INSERT INTO ptu_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Kehongko' anna maupa' to muinaba-naba kamaloloam, aka tau ia too la napaponnoiam Puang Allataala pa'pemulunna. ");
INSERT INTO ptu_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Kehongko' anna maupa' to si pa'häntängam bua, aka tau ia too la nakamasei Puang Allataala. ");
INSERT INTO ptu_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Kehongko' anna maupa' to satutu penabanna lako kamapiaam, aka tau ia too la silambi' Puang Allataala. ");
INSERT INTO ptu_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Kehongko' anna maupa' to umpasikapiai hupatau, aka tau ia too la mendadi änä'na Puang Allataala. ");
INSERT INTO ptu_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Kehongko' anna maupa' to dipahuai pandahhaam kahana untuhu'i pa'elo'na Puang Allataala, aka tau ia too mendadim umma'na Puang Allataala illaam kapahentaanna. ");
INSERT INTO ptu_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Kehongko'koa' anna maupa' ke disangai bäbäkoa' to kadake gau', dipahuai pandahhaam, anna dipakolo'-kolo'i aka untuhu'ä'. ");
INSERT INTO ptu_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Susi siam duka' yolona buda nabi didahha. Dadi la kassi mandakoa' ia anna tilalla' ke nalambi'koa' kaha-kaha ia too, aka la nabeengkoa' Puang Allataala mana' kasalle yabo suhuga.” ");
INSERT INTO ptu_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Anna mane naua: “Ikonna' too dipasihhapam sianna lino. Indo sia ke matämmä'um, la malapaka dipamasim sule? Tä'um tia deem gunana, angga ham la ditibe anna nasihondo-hondoi tau. ");
INSERT INTO ptu_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Anna ikonna' too dipasihhapam ballo ummasiä'i hupatau illaam inde lino. Mesa kota yabo tanete tä' mala tala naita hupatau. ");
INSERT INTO ptu_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Anna tä' deem tau la umpau' lampu anna mane nasalongo'i baka. Sapo' naala hi tia anna napayaboi matandena anna mala muindo ingganna issinna banua. ");
INSERT INTO ptu_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Susim too pa'pogausammua' la sihhapam ballo paindo naita tau buda napolalam dipuji anna dipa'kasallei Ambemu yabo suhuga aka naita pa'pogausam mapiammua'.” ");
INSERT INTO ptu_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Anna mane naua: “Daa ussangaia' suleä' inde lino la umpa'dei Pepaondonganna Musa anna pepa'guhuam illaam suha'na ingganna nabi. Tä' suleä' la umpa'dei, sapo' setonganna suleä' la kuganna'i. ");
INSERT INTO ptu_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Setongam-tonganna, assala'na hia tontä liupi langi' sola lino, tä' duka' deem la mala dikuhänni moi podo la sakini'um pahentana Puang Allataala ke tä'pi sule lako ingganna issinna. ");
INSERT INTO ptu_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Iam too anna kutulasammokoa' kuua: menna-menna untekka moi podo la sabaheam saidi'um issinna pahentana Puang Allataala, moi la handam bahinni'na, anna nauai lako solana: ‘Daa tatuhu'ia',’ tau ia too la dihekem to handam bahinni' illaam kapahentaanna Puang Allataala. Sapo' menna-menna umpalako pahentana Puang Allataala anna napepatuduanni lako solana, tau ia too la dihekem to keangga' illaam kapahentaanna Puang Allataala. ");
INSERT INTO ptu_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Dadi la pahallua' umpaillaam penaba inde tula'ku: Tä' siakoa' la mala mendadi umma'na Puang Allataala illaam kapahentaanna, ke tä'i mentondom puhaa' iko kamanuhusammu lako Puang Allataala anna la kamanuhusanna indo to ullatta' Pepaondonganna Musa sola to illaam kakalebuanna Parisi.” ");
INSERT INTO ptu_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Anna mane naua: “Muissammia' indo pepatuduam puha dibeem nene to taponene naua: ‘Daa umpapateam; menna-menna papateam, tau ia too la dihotto'.’ ");
INSERT INTO ptu_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Sapo' Kao-kao kuuaangkoa' tentomai: menna-menna keaha' lako solana, pahallu la dihotto'. Menna-menna muuaam solana: ‘Takegunako iko,’ tau ia too la dipopengngolo lako kakalebuanna To Mahhotto' Handam Malangka' illaam peadasam. Anna menna-menna muuaam solana: ‘To mahoko iko,’ sipäto' ia la dipatama api nahaka. ");
INSERT INTO ptu_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Dadi, maka' la memala'koa' dio ongeam pehumalasam, sapo' ungkilalai deempi to mapi'di' penaba tama kalemu, ");
INSERT INTO ptu_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","iya la pahallu umpatohho salapi yolo itim kapehumalasammu anna le'ba'poko yolo sikapiai indo solamu. Mapiapi sule alla'mua', anna mane suleko sule umpatahhu'i indo kapehumalasammu dio olona Puang Allataala. ");
INSERT INTO ptu_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Maka' hapanna deem tau umpahapa'koa' lako to mahhotto', iya la masimpangkoa' too sikapiai sule sumala tä'pokoa' landa' lako olona indo to mahhotto'. Aka maka' tä' ussimpannia' sikapiai yolo, iya la nabeho lakoko too indo to mahhotto'. Anna indo to mahhotto' la umpalulakoko pulisi. Anna mane indo pole' pulisi la untibekoa' tama tahungkum. ");
INSERT INTO ptu_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Setongam-tonganna, tä' siako la mala dipassubum illaam mai tahungkum kela deempi tohho moi podo la himi'um indammu.” ");
INSERT INTO ptu_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Anna mane naua: “Muissammia' indo pepatuduam puha dibeengkoa' naua: ‘Daa ullullu' pa'bannetauam.’ ");
INSERT INTO ptu_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Sapo' Kao-kao kuuaangkoa' tentomai: menna-menna unnenne'i mesa baine anna nakailui, tau ia too ullullu'um pa'bannetauam illaam penabanna aka hapammi bali ma'pogau'. ");
INSERT INTO ptu_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Maka' hapanna mata kanammu la umpomadosako, kalessu'i lao ammu tibei. Aka dotam tia sabali-bali matammu, anna la sakalebu kalemu sapo' iam nasuhum ditibeko tama nahaka. ");
INSERT INTO ptu_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Maka' lima kanammu la umpomadosako, poloi lao ammu tibei. Aka dotam tia sabali-bali limammu, anna la sakalebu kalemu sapo' iam nasuhum ditibeko tama nahaka.” ");
INSERT INTO ptu_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Anna mane naua: “Deem duka' mesa pepa'guhuam naua: Menna-menna untibe bainena, pahallu umbeem suha' kasisähäsam bainena. ");
INSERT INTO ptu_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Sapo' Kao-kao kuuaangkoa' tentomai: menna-menna untibe bainena sulibanna ke ullullu'i muanena indo baine anna kemuane polei, iya indo too muanena nasuhum ullullu' pa'bannetauam indo bainena. Anna menna-menna umpobainei indo baine to natibe muanena, tau ia too ullullu' duka' pa'bannetauam.” ");
INSERT INTO ptu_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Anna mane naua: “Muissammia' indo pepatuduam puha dibeem nene to taponene naua: ‘Daa umpa'pinda-pinda bäbä. Sapo' ia hia la pahallu umpasule lako indo to puha umpa'pindai dio olona Debata.’ ");
INSERT INTO ptu_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Sapo' Kao-kao kuuaangkoa' tentomai: Tä' si'da-si'dakoa' la mala ma'pinda-pinda, moi la suhuga tala malaia' umpa'pindai, aka suhuga ongeanna okkosam kahajaanna Puang Allataala. ");
INSERT INTO ptu_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Tä' tookoa' mala la umpa'pindai lino, aka inde lino pehhondoanna Puang Allataala. Anna tä' tookoa' la umpa'pindai Yerusalem, aka inde Yerusalem kota naongei Tomahajanna ingganna tomahaja. ");
INSERT INTO ptu_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Tä' tookoa' la umpa'pindai ulummu, aka tä' sia deem kakuasaammua' la umpomabusa beluä'mu battu haka la umpomalotä, moi podo la salamba'um. ");
INSERT INTO ptu_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Sapo' ia hia, uako: ‘Io,’ ke ioi, anna uako: ‘Tää',’ ke tä'i. Sulibanna ia too pengkähänganna ia To Kadake Gau' battu diua tomahajanna setam.” ");
INSERT INTO ptu_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Anna mane sitahhu'na tula'na naua: “Muissammia' indo pepatuduam puha dibeengkoa' naua: ‘Diäläiam matanna to muäläi matanna solana anna dihimpoiam isinna to uhhimpoi isinna solana.’ ");
INSERT INTO ptu_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Sapo' Kao-kao kuuaangkoa' tentomai: Daa umpabala'i to umpogausangkoa' kakadakeam. Sapo' ia hia, maka' deem tau untampilim papo kanammu, beem polepi duka' papo kaihimmu. ");
INSERT INTO ptu_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Anna maka' deem tau umpahapa'koa' lako to si mahhotto' aka nakailui bajummu, beem polepi duka' jubamu. ");
INSERT INTO ptu_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Maka' deem tau ussuako la umbabaam babaanna sakilo mambelanna, iya babaanni dua kilo mambelanna. ");
INSERT INTO ptu_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Maka' deem aka-akammu napelau tau, iya beenni. Anna maka' deem tau umpelau aka-akammu la naindam, daa untumpu pala'i pelauanna.” ");
INSERT INTO ptu_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Anna mane naua: “Muissammia' indo pepatuduam puha dibeengkoa' naua: ‘Kamaseia' ia solamu ammu kabassia' ia balimmu.’ ");
INSERT INTO ptu_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Sapo' Kao-kao kuuaangkoa' tentomai: Kamaseikoa' balimmu ammu pa'sambajanganni to undahhako. ");
INSERT INTO ptu_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Maka' umpateemmia', iya la tuttuam tandaammi too diua änä'na si'da-si'dangkoa' Ambemu yabo suhuga. Aka Puang Allataala umpadadiam mata allo lako to umpogau' kamapiaam anna susi toi lako to umpogau' kakadakeam. Ia toi umpatuhungam uham lako to umpogau' kamaloloanna Puang Allataala anna susi toi lako to umpogau' kakadakeam. ");
INSERT INTO ptu_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Aka maka' anggam to ungkamaseikoa' la ungkamasei, iya aka hi la napolalam Puang Allataala la nabala'iangkoa' hesomu? Aka moi indo tuam passima, si ussangaia' to madosa, si ungkamasei toi duka' to ungkamasei. ");
INSERT INTO ptu_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Susi toi, maka' angga mandi to ussipohäeanna' la umpa'kadai, iya tä' siam tia isanga deem alla'na pa'pogausammu anna pa'pogausanna tau senga'. Aka to tama'debata duka' anna napogau'i ia too, damo aham ia ikoa'. ");
INSERT INTO ptu_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Umba susi Ambemu yabo suhuga tepu pa'kamasena, la susingkoa' too duka' pahallu la tepua' pa'kamasemu.” ");
INSERT INTO ptu_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Anna mane naua: “Deem akoa' la umpalako tuntusam peadasammu kela muuaia': ‘Anna malaä' naita tau buda.’ Aka maka' ma'pogau' susikoa', iya tä'um deem la napolalam Ambemu yabo suhuga la nabala'iangkoa' hesomu. ");
INSERT INTO ptu_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Maka' deem la umpa'kamaseam lako to mase-mase, tä'koa' la susi to ma'dua tambu'. Aka si napohäe ia umpa'paita-itaam pa'pogausanna dio olona tau buda susi tama pa'sambajangam, teem lako lalam mahoa' aka naua: ‘Anna malaä' napuji tau buda.’ Setongam-tonganna tau susi ia too untahimam ia sahona ke napujim tau buda. ");
INSERT INTO ptu_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Sapo' maka' deenna' aka-akammu la umbeem to mase-mase, pahallu tala naudu' dali' tanahingngi kasisi'. ");
INSERT INTO ptu_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Anggam iko la muissanni sola Ambemu yabo suhuga, aka nalosa asam ia ingganna membuninna, nasuhum ia la umbala'iangko indo pa'pogau'mu tää'na naita tau senga'.” ");
INSERT INTO ptu_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Anna mane naua: “Maka' ma'sambajangkoa', tä'koa' la susi to ma'dua tambu' si napohäe ke'de' ma'sambajam illaam tängä-tängäna tau buda illaam pa'sambajangam, battu haka lako lalam mahoa' aka naua: ‘Anna malaä' naita tau buda.’ Setongam-tonganna, tau susi ia too untahimam ia sahona ke napujim tau buda. ");
INSERT INTO ptu_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Sapo' ikoa'-iko ke ma'sambajangkoa', la lu tamako tambimmu ammu tutu'i ba'bamu, anna mane ma'sambajangko längäm Ambemu to tadiita. Iya la nabala'iammoko too Ambemu to ullosa ingganna membuninna, indo pa'pogau'mu tää'na naita tau senga'. ");
INSERT INTO ptu_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Maka' ma'sambajangkoa', tä'koa' la susi indo to tä' ungkaleso manappa Debata si umpa'sule-sulei tula'na lambi' kalando sugali'. Nasanga hia la nahingngiam puha ia Debata sambajanna ke kalandoi tula'na. ");
INSERT INTO ptu_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Daa umpasusiia'! Aka setonganna tä'pia' deem lemba' dio pudu'mu anna naissammi Ambemu yabo suhuga indo umpahalluanna. ");
INSERT INTO ptu_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Sapo' la muua hia' ia ma'sambajam: ‘Ambeki yabo suhuga, dipa'kasallei sanga masehomu, ");
INSERT INTO ptu_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","kela mala Ikom ma'pahenta, anna dituhu'i pa'elo'mu illaam inde lino umba susi yabo suhuga. ");
INSERT INTO ptu_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Beengkanni kinande la sihuanna kiande allo temo. ");
INSERT INTO ptu_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Anna muampunniangkanni kasalaangki, umba susi muampunnikam duka' to kasalaam lako kaleki. ");
INSERT INTO ptu_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Anna daa ullappa'kam tama pa'sändäsam, sapo' la ullappasangkam dio mai kakuasaanna kakadakeam. Aka Iko to umpuängam kapahentaam, kakuasaam, anna kamatandeam sule lako salako-lakona. Amin.’ ");
INSERT INTO ptu_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Aka maka' muampunniko kasalaanna padammu ma'hupatau, la naampunniangkoa' duka' kasalaammu Ambemu yabo suhuga. ");
INSERT INTO ptu_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Sapo' maka' tä'koa' muampunni kasalaanna padammu, iya la tä'koa' too duka' la naampunniam kasalaammu Ambemu yabo suhuga.” ");
INSERT INTO ptu_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Mane nauai: “Maka' puasakoa', tä'koa' la susi to ma'dua tambu' si naägä'i lelem umpesahongko-hongkonganni kalena aka naua: ‘Anna mala naissam tau senga' naua ma'puasa.’ Setongam-tonganna, tau susi ia too untahimam ia sahona ke napujim tau buda. ");
INSERT INTO ptu_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Sapo' maka' puasakoa', pendau'koa' ammu pa'dakka, ");
INSERT INTO ptu_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","anna mala tä' naissam tau senga' naua: ‘Ma'puasa.’ Anna mala anggam Ambemu to tadiita la muissanni. Iya la nabala'iammoko too Ambemu, to ullosa ingganna membuninna, indo to umpogau' tää'na naita tau senga'.” ");
INSERT INTO ptu_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Anna mane naua: “Daa uhhempum kulle illaam inde lino. Aka kulle inde lino tontäm bu'busanna, takkasam, anna la naboko to maboko. ");
INSERT INTO ptu_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Sapo' la uhhempum yabo hia' ia suhuga kullemu. Aka tala naande ia bu'bu', tala takkasam, anna tä' toi la mala naboko to maboko. ");
INSERT INTO ptu_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Aka umba-umba naongei kullemu, la eta siam too duka' naongei penabammu.” ");
INSERT INTO ptu_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Anna mane naua: “Inde matanta sihhapam ballo illaam kaleta ma'pomasiä'. Aka maka' masiä' matammu, iya masiä' asam too duka' sakalebu kalemu. ");
INSERT INTO ptu_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Sapo' maka' kadakea' matammu, mannassa anna sihhapangko nabutai malillim. Maka' ussangaiko kalemu masiä' sapo' pi'de hi indo kamasiäsam illaam kalemu, mannassa anna tä'i deem pada samalillim katuboammu dio olona Puang Allataala. ");
INSERT INTO ptu_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Tä' deem mesa sabua' la nabela umpengkähängam dua puäna. Aka la natuhu'i manappam too mesa, anna la napaiboko'na bäbä mesa. Battu diua la napakalando puha ia mesa anna tä' bäbä la napehingngii mesa. La susingkoa' too duka', tä' siaa' la umbela umpalulängäm penabammu Puang Allataala ke anggakoa' umbumbu' kulle di lino.” ");
INSERT INTO ptu_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Iam too anna kuuaammokoa': Daa ummalallanna' diona salu katuboammu, la muua: ‘Aka amo la diande sola diihu'.’ Anna tä' toi la malallangkoa' diona bätä puntimmu, la muua: ‘Aka amo la dipa'poheba.’ Tä' daka tia kalando puha ia katuboammu anna la kinande? Anna bätä puntimmu kalando puha ia anna la poheba? ");
INSERT INTO ptu_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Penabaam siaia' too dassi-dassi yabo lawwa. Tä' deem mangngambo', tä' deem mepahe, damom ia ditula'i la deem ma'pakissim. Moinna anna susi, sapo' tontä liu duka' nabanneiam salu katuboanna Ambemu yabo suhuga. Tä' daka tia keangga' puhakoa' iko anna la dassi-dassi ia too? ");
INSERT INTO ptu_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Akam gunana la malallangkoa' diona kapahalluammu? Mennangka iko tau muita to malallam diona salu katuboanna la mala ullombunni sungnga'na moi podo la saidi'um? ");
INSERT INTO ptu_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Akanna malallangkoa' diona la umpa'pohebana? Penabaam siaia' too indo bunga-bunga lako kaliane. Tä' deem mengkähä, dapaka ia la umpapia poheba. ");
INSERT INTO ptu_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Sapo' mentondom puha ia mapianna anna la pohebana tomahaja Salomo yolona, moinna anna tä'i deem pada sasugi'. ");
INSERT INTO ptu_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Indo duka' kuhha tubo temo la bambanna siam ditibe tama api anna napomapi'dä'i Puang Allataala, damo ahanna' ia iko keangga' puha hakoa' tiko anna la indo kuhha. Kuhäm sugali'a' kamatappasammu! ");
INSERT INTO ptu_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Iam too anna tä'ungkoa' la malallam diona salu katuboammu, la muua: ‘Aka amom la kiande, aka amom la kiihu', anna aka amom la kipa'poheba.’ ");
INSERT INTO ptu_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Si naua asammi too ingganna hupatau to tä' ungkaleso manappa Puang Allataala. Sapo' tä' iko la umpasusia', aka inna naissam loppo'um Ia Ambemu yabo suhuga ingganna kapahalluammu. ");
INSERT INTO ptu_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Ia hia, paitoo'naia' illaam penabammu kapahentaanna Puang Allataala anna umpalako liui pa'elo'na, iya la napasondoingkoa' too ingganna la kapahalluammu. ");
INSERT INTO ptu_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Dadi tä'ungkoa' la malallam diona makale'na. Aka kamalallangam allo makale', eta opa ia duka' umpikki'i. Budam kamasussaammu allo temo, damom uhhängänni liui.” ");
INSERT INTO ptu_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Anna mane naua: “Daa umpasala padammu hupatau indana napasalako duka' Puang Allataala. ");
INSERT INTO ptu_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Aka umba susi umpasalako padammu hupatau, la susim too duka' napasalako Puang Allataala. Aka pempadai too umpasalako solamu, iya la pempada siam too duka' napasalako Puang Allataala. ");
INSERT INTO ptu_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Akanna la muita leko'ko butanna solamu pada tahubu' kaju anna tä'ko iko la ussi'dim butammu pada talakaju illaam matammu? ");
INSERT INTO ptu_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Maakam ia susi la malako muuaam solamu: ‘Maiko solaku anna kuäläiangko itim tahubu' kaju illaam matammu,’ moi kela daa pada iko talakaju illaam matammu? ");
INSERT INTO ptu_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","O, to ma'dua tambu'! Äläi yolo indo butammu pada talakaju anna mala masiä' pennenne'mu muäläiam butanna solamu pada nennu'.” ");
INSERT INTO ptu_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Puhai ia too, natula' polepi Puang Yesus mesa pehapangam naua: “Daa umbeenni asu ingganna masehona aka nasumbali'iko manii anna nahopäiko. Anna daa umbeenni babi mani' mutiarammu indana napa'kuttä'i.” ");
INSERT INTO ptu_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Mane naua pole oi: “Si pelaui kapahalluammu längäm Puang Allataala anna naponnoiangko. Peäi kapahalluammu anna ullolonganni. De'de'i ba'ba anna mala natungka'iangko. ");
INSERT INTO ptu_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Aka menna-menna melau la diponnoiam pelauanna, anna menna-menna mameä la nalolongam, anna menna-menna unde'de' ba'ba la ditungka'iam. ");
INSERT INTO ptu_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Tä' sia deem tau la palla' penabanna umbeem batu änä'na ke umpelaui hoti. ");
INSERT INTO ptu_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Susi toi duka' tä' deem tau la palla' penabanna umbeem ula' änä'na ke umpelaui bau. ");
INSERT INTO ptu_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Dadi ikoa' duka' to madosa anna muissanni umbeem änä'mu la napomapianna, damo aham Ia Ambemu yabo suhuga la umbeem indo la napomapianna lako si mesa-mesa hupatau to melau dio olona.” ");
INSERT INTO ptu_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Anna mane naua: “Iai too umpohäe la napogausangko solamu, iam too duka' la umpogau' lako solamu. Iam too inde pungngu' tannunna issinna suha' Pepaondonganna Musa anna suha'na ingganna nabi.” ");
INSERT INTO ptu_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Mane nauai: “Ola tamako ba'ba masiki'. Aka ba'ba kalua' anna lalam malobä diola tinanda tama nahaka. Anna buda tau muola eta. ");
INSERT INTO ptu_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Sapo' ba'ba masiki' anna lalam masiki' la diola tinanda lako katuboam sule lako salako-lakona, anna anggam sai'di' tau muola lalam ia too.” ");
INSERT INTO ptu_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Anna mane naua: “Jagai manappaia' to ussangai kalena nabi sapo' setonganna to mebaba bulim. Si sulekoa' napellambi'i ma'madotta'-dotta' lelem anggasanna domba, sapo' setonganna susi liu hia olo'-olo' to peande. ");
INSERT INTO ptu_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Sapo' la muissanna' untandai aka la muita dioa' pa'palakoanna. Aka la deem daka tia tau umpuppu' bua anggur dio mai balambane' battu haka la umpuppu' bua ara yabo mai kaju bahani? ");
INSERT INTO ptu_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Susi toi duka' mesa kaju ke mapiai, la mapia siam tia duka' buana, anna mesa kaju ke kadakei, la kadake siam tia duka' buana. ");
INSERT INTO ptu_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Aka tä' sia deem la mala mesa kaju mapia la ungkembuaam bua kadake, battu haka mesa kaju kadake la ungkembuaam bua mapia. ");
INSERT INTO ptu_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Ingganna kaju ke tä'i mapia buana, mannassa anna la dilellennii lao anna ditunui. ");
INSERT INTO ptu_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Susim too duka' nabi tatappa', la diita diopi yolo pa'palakoanna mane mannassai.” ");
INSERT INTO ptu_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Mane nauai: “Taia tia indo to anggam muuaam bäbää': ‘Debatangku Puang Yesus,’ la mendadi umma' illaam kapahentaam suhuga. Sapo' anggam tia indo to umpalako pa'elo'na Ambeku yabo suhuga la mala mentama kapahentaanna. ");
INSERT INTO ptu_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Aka illaam allo ma'katampasanna la buda tau sule dio oloku to tä' umpalako pa'elo'na Ambeku yabo suhuga anna nauaannä': ‘O Debata, tä' daka tia puhangkam mendadi pelombum pudu'mu illaam umpa'pakahebaam Battakada Debata, si uhhambaikam liu setam, anna umpadadikam tanda memängä-mängä?’ ");
INSERT INTO ptu_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Sapo' tappa la kulompä kuua: ‘Tä'koa' iko kuissam. Päläikoa' lao inggannakoa' to si umpogau' kakadakeam.’” ");
INSERT INTO ptu_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Anna mane naua: “Menna-menna umpehingngii manappa ingganna inde kadangku anna napatama tambu'i lambi' nakedoam, tau ia too sihhapam mesa to keaka' umpake'de' banuanna yabona batu. ");
INSERT INTO ptu_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Tappana tuhum uham sitonda hibu' tatta' nasuhum ma'butu-butu uwai unta'du indo banua sola natappi hibu'. Sapo' tä' deem tige'ge' aka napake'de' yabona batu. ");
INSERT INTO ptu_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Sapo' menna-menna uhhingngi gändä-gändä kadangku anna tä'i napaillaam tambu' dapaka ia la nakedoam, tau ia too dipasihhapam ia to maho kalebu umpake'de' banuanna yabona bungim. ");
INSERT INTO ptu_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Tappana tuhum uham sitonda hibu' tatta' nasuhum ma'butu-butu uwai unta'du indo banua anna la meliliam hibu' untappii, lambi' titale bangke' aka napake'de' yabona bungim.” ");
INSERT INTO ptu_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Tappana puha ma'tula' Puang Yesus, iya sangngim mängä-mängä tau uhhingngii pepa'guhuanna, ");
INSERT INTO ptu_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","aka tä' ia ma'pa'guhu susi indo to ullatta' Pepaondonganna Musa. Sapo' ma'pa'guhu Ia Puang Yesus sitonda kakuasaam. ");
INSERT INTO ptu_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Tappana tuhunni Puang Yesus yabo mai indo tanete, iya ma'silullu'um tau buda untuhu'i. ");
INSERT INTO ptu_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Iya sulem duka' mesa to dolengam umpellambi'i anna ma'balinguntu'i dio olona anna nauai: “O Tuam, kuissam kuua malaä' umpabono' ke umpoelo'i.” ");
INSERT INTO ptu_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Iya uhhaka'um indo tau napasindum naua: “Maelo'ä', bono'ungko!” Lambi' masapu eta siahanni indo sakinna. ");
INSERT INTO ptu_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Puhai, napakahi'dim Puang Yesus naua: “Pengkilalai manappai le, tä' too la mala untulasam tau senga' inde pa'pogau'ku. Sapo' la le'ba'ko umpa'paitaam kalemu lako sando anna la umbabako bua pemala'mu, umba susi puha napepaondongam Musa. Aka la mendadi tanda lako tau buda diona kabonosammu.” ");
INSERT INTO ptu_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Tappana mentamai kota Kapernaum Puang Yesus, iya sulem mesa punggabana sohodadunna to Roma untammui anna nauai: ");
INSERT INTO ptu_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“O tuam, kela malako ungkamaseiä' aka deem mesa sabua'ku dio banua metindo liu aka mate kalena anna tä' deem pada samasanta'!” ");
INSERT INTO ptu_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Natimba' Puang Yesus naua: “La lakoä' anna kupabono'i.” ");
INSERT INTO ptu_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Sapo' naua indo punggabana sohodadu: “O Tuam, tä' punalaä' sihatam la tamako banuangku. Pa'tula' mammoko moi podo sabattam aka la bono'um tia indo sabua'ku. ");
INSERT INTO ptu_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Setonganna, kuissam duka' diona pampahesam, aka kao duka' mesaä' to dipahe'. Sapo' deempi duka' tando dokkoku to kupahe'. Aka maka' kuuaam indo sohodadu to kupahe': ‘Le'ba'ko,’ iya le'ba' duka'. Anna maka' kuuaam: ‘Maiko,’ iya sule duka'. Susi siam too duka' sabua'ku ke kuuaanni: ‘Kähäi inde,’ iya tä' mala tala nakähä.” ");
INSERT INTO ptu_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Tappana nahingngi Puang Yesus indo pa'tula'na, iya tä' deem pada sanakapilla'i, nasuhum ma'kada lako indo tau buda to untuhu'i naua: “Setongam-tonganna, tä' punalapi deem la kulambi' to Israel moi podo la mesam la susi kamatappasanna inde dio tau! ");
INSERT INTO ptu_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Nasuhum kutulasangkoa' tentomai kuua: buda tau taianna to Yahudi la sule, buttu illaam mai tandai mata allo anna buttu illau' mai tandai katampusam, la mendadi umma' illaam kapahentaam suhuga, anna muokko'i ma'hame-hame sola-sola Abraham, Ishak, anna Yakub ke illaammi allo ma'katampasanna. ");
INSERT INTO ptu_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Anna indo to la muongei battuam ongeam ia too, to si disangai umma'na Puang Allataala, ia leko' di ditibe tama indo ongeam handam malillim anna illaanni sumahho lumoa' sikekko' isinna tamate tatubo.” ");
INSERT INTO ptu_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Anna mane ma'kada pole oo Puang Yesus lako indo punggabana sohodadu naua: “Le'ba'ungko aka la dadim tia lako kalemu situhu' kamatappasammu.” Iya bono' eta siaham duka' indo sabua'na. ");
INSERT INTO ptu_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Pissam wattu le'ba' Puang Yesus lako banuanna Petrus, iya ullambi'um pasananna Petrus baine, metindo aka lumalla'. ");
INSERT INTO ptu_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Iya le'ba' siaham lako ampe'na anna naanda'i limanna. Iya tappa masapu eta siaham sakinna lambi' bangommi maläppu' anna tappa untahiai Puang Yesus. ");
INSERT INTO ptu_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Tappana lendu' allo, iya suleim tau umpasola buda to napentamai setam. Iya angga mandi ma'tula' Puang Yesus uhhambai lao indo setam anna bono'im. Anna ingganna to masaki to dio heem eta too napabono' asam duka'. ");
INSERT INTO ptu_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Napogau' Puang Yesus kaha-kaha ia too anna mala sule lako indo kadanna Debata napalombum nabi Yesaya naua: “Ia umpassam kamapi'disanta anna Ia toi umpendudum sakinta.” ");
INSERT INTO ptu_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Tappana naita Puang Yesus tä' deem pada sabuda tau umpali'i lao, iya nauam lako passikolanna: “Talulibanna' kita lambam libanna le'bo'.” ");
INSERT INTO ptu_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Tappana la mengkalao, iya sulem mesa to ullatta' Pepaondonganna Musa umpellambi'i Puang Yesus anna nauai: “O Tuangguhu, la kutuhu' liuko illaam pa'laoammu, moi umba ngei muola.” ");
INSERT INTO ptu_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Iya natimba'um Puang Yesus naua: “Asu pangngala' ia deem leäna, anna ingganna dassi yabo lawwa deem sehäna, sapo' Kao-kao to disangai Änä' Mentolino tä' Kao deem la manontom kuongei metindo.” ");
INSERT INTO ptu_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Puhai, iya sule pole boom duka' mesa passikolanna anna nauai: “O Tuam, la mala haka ke laopä' yolo ullamum ambeku mane suleä' kutuhu'ko?” ");
INSERT INTO ptu_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Sapo' natimba' Puang Yesus naua: “Maingko ammu tuhu'ä'! Päbäi mammi ia duka' itim matim to mate ullamum to matena.” ");
INSERT INTO ptu_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Puhai ia too, le'ba'um längäm lopi Puang Yesus sola passikolanna. ");
INSERT INTO ptu_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Yaboi, iya sule siaham hibu' tatta' illaam indo le'bo', nasuhum natappi bombam indo lopi naongei lambi' saidi' tatallam. Sapo' wattu eta too mamma' Ia Puang Yesus. ");
INSERT INTO ptu_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Iya natundam siaham passikolanna Puang Yesus anna nauaanni: “O Tuangguhu, pesäkäikam, aka la tallam tau!” ");
INSERT INTO ptu_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Iya natimba'um Puang Yesus naua: “Akanna mahea' sugali' dakoa' iko? Kuhäm punalaa' kamatappasammu!” Anna mane ke'de' umpa'kadai indo bombam sola hibu' tatta'. Iya tappa mattam siaham. ");
INSERT INTO ptu_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Sangngim pilla' indo passikolanna anna sipa'tula'-tula'i naua: “Tau aka hia isanga indea'i? Aka moi hibu' sola bombam mala toi napahe'!” ");
INSERT INTO ptu_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Tisampoi lopinna Puang Yesus sola passikolanna lambam libanna le'bo' Galilea dio attasa'na to Gadara, iya natammui siaham dua tau buttu dio mai ku'bu' to napentamai setam. Indo tau ia too si ma'tatta' la umpongko tau, nasuhum tä' deem tau bahani la muolai indo lalam eta. ");
INSERT INTO ptu_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Muitanna Puang Yesus, iya bassim kaoli-oli siaham naua: “O Yesus Änä'na Puang Allataala, la muaka hakam kami' isanga? Maelo'ungko isanga la undahhakam moi anna tä'pi lambi' wattunna?” ");
INSERT INTO ptu_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Dio indo sikahuku' ongeam ia too deem babi buda mahassam menduhu'. ");
INSERT INTO ptu_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Iya napelaum indo setam lako Puang Yesus naua: “Maka' la umpassakam messubum illaam mai kalena inde tau, kipelau kela mala anna ussua tamakam kalena inde lako babi buda.” ");
INSERT INTO ptu_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Tappa naua siaham Puang Yesus: “Päläikoa' lao!” Iya tappa messubum siaham duka' indo setam anna umpentamai indo babi buda. Nasuhum sikakondä untobängam bäbä kalena dokko kumila' tahhu' dokko le'bo', lambi' mate asam napusa'i uwai. ");
INSERT INTO ptu_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Naitanna to unjagai indo babi kadadiam ia too, tappa le'ba' siaham sikakondä lako kota anna napalelei, susi indo babinna mate asammi napusa'i uwai, teem indo dua tau to napentamai setam. ");
INSERT INTO ptu_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Nahingnginna issinna kota indo kaha-kaha ia too, iya le'ba'i siaham umpellambi'i Puang Yesus. Silambi'na, iya nauaim: “Kipelau matim anna tä'ko inde bottoki.” ");
INSERT INTO ptu_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Puhai ia too, le'ba'um Puang Yesus sola passikolanna längäm lopi anna ma'pasulei-sule libam indo kota si biasa naongei tohho. ");
INSERT INTO ptu_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Tappana sulei libam, iya natammuim tau umbulle mesa to mate kalena metindo dio ampa'na. Tappana naita Puang Yesus kamatappasannai, iya ma'kadam lako indo to mate kalena naua: “Pomahannui penabammu änä'ku, aka diampunniammoko dosamu.” ");
INSERT INTO ptu_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Wattu eta too dio duka' heem sanaka-naka to ullatta' Pepaondonganna Musa uhhingngi tula'na Puang Yesus. Iya nauaim illaam penabanna: “Akanna deenni tau muangga' kalena sipadaam Puang Allataala?” ");
INSERT INTO ptu_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Sapo' tappa nalosa Puang Yesus issi penabannai nasuhum naua: “Akanna malaia' umpakende' pikkiham kadake illaam penabammu? ");
INSERT INTO ptu_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Mennaka la madomi' dadi lako inde tau, ke diuaanni: ‘Diampunniammoko dosamu,’ anna la diuaam: ‘Bangongko ammu pellao?’ ");
INSERT INTO ptu_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Sapo' la kupa'patandaam temo anna malaa' ungkaleso manappa muua illaam inde lino kuasaä' To diuaam Änä' Mentolino muampunni dosa.” Mane ma'kadai lako indo to mate kalena naua: “Bangongko, babai ampa'mu ammu le'ba' lako banuammu.” ");
INSERT INTO ptu_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Tappa bangom siaham duka' indo to mate kalena anna le'ba'i lako banuanna. ");
INSERT INTO ptu_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Tappana naita tau buda indo kadadiam ia too, iya sangngim mahea' anna umpuji Puang Allataala naua: “Tä' si'da deem untondonni kakuasaanna Puang Allataala nabeem lako hupatau!” ");
INSERT INTO ptu_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Puhai ia too, le'ba'um Puang Yesus umpellei indo ongeam. Mahassanni mellao, iya muitam mesa tuam passima isanga Matius muokko' illaam kätto'na. Iya napa'kadaim Puang Yesus naua: “Maiko anna untuhu'ä'.” Iya ke'de'um duka' anna le'ba'i natuhu'. ");
INSERT INTO ptu_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Mahassanni mangngande Puang Yesus sola passikolanna dio banuanna Matius, iya suleim sanaka-naka tuam passima sola tau senga' anna muokko'i sola-sola mangngande. Ingganna indo to sule si nasangai to Yahudi to madosa. ");
INSERT INTO ptu_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Tappana naita to mentama kakalebuanna Parisi, iya ma'kadam lako passikolanna Puang Yesus naua: “Akanna naakui tuangguhummua' sola-sola mangngande tuam passima anna to madosa senga'?” ");
INSERT INTO ptu_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Sapo' nahingngi Puang Yesus indo pekutanaanna, iya natimba'im naua: “Tä' tia deem to bono' la umpahalluam tuandotto', anggam tia to masaki. ");
INSERT INTO ptu_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Paela' siaia' too umpenabaam kalembasanna indo issinna Battakada Debata naua: ‘Handam kupaitoo'na, pa'kamase taia olo'-olo' dipehumalasam.’ Aka Kao-kao, suleä' inde lino taia to ussanga kalena malolo la kutambai, sapo' suleä' untambai to madosa.” ");
INSERT INTO ptu_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Puhai ia too, iya suleim passikolanna Yohanes to si mantedo' umpellambi'i Puang Yesus anna nauaanni: “Maaka hia anna si puasakam kami' situhu' peadasam sola to illaam kakalebuanna Parisi anna tä' ia passikolammu?” ");
INSERT INTO ptu_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Natimba' Puang Yesus umpake pehapangam naua: “Aka la deem daka tia to ullomba kakabengam la masussa penaba ke diopi heem indo to mane dipakebaine? Mannassa anna tä'i deem! Sapo' la deem wattunna indo to mane dipakebaine la diäläi illaam mai alla'-alla'na to ullombai. Iya etapi too pole' mane puasai. ");
INSERT INTO ptu_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Mane deenni, tä' tia deem tau la umpopetampi' sampim bakahu lako poheba malusa, aka tingkahussui too indo sampim bakahu, iya tuttuam kalua'um sesse'na indo poheba malusa. ");
INSERT INTO ptu_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Susi toi duka' tä' tia deem tau la muala anggur bakahu anna napatamai pa'pongngeam malusa. Aka indo anggur bakahu la untesseam pa'pongngeam malusa, katampasanna bassim labu', susi anggurna teem pa'pongngeanna. Anggur bakahu pahallu la dipalutama duka' pa'pongngeam bakahu anna mala bassim mapia.” ");
INSERT INTO ptu_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Mahassampi ma'tula' Puang Yesus, iya sule ham mesa to pebaba illaam pa'sambajanganna to Yahudi umpellambi'i Puang Yesus anna ma'balinguntu'i dio olona napasindum naua: “Deem mesa änä'ku baine, ia sia matena. Sapo' kela malako laoki' sola anna uhhaka'i anna mala tubo sule.” ");
INSERT INTO ptu_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Iya ke'de' siaham duka' Puang Yesus sola passikolanna anna le'ba'i sola indo tau. ");
INSERT INTO ptu_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","21","Muolai lalam, iya sulem mesa baine, sapulo duam taunna nahua saki baine. Naua illaam penabanna indo baine: “Assala'na mala moi podo kuantim bajunna, iya la malamä' bono'.” Iya le'ba'um lako boko'na Puang Yesus anna naantii tähämpä' bajunna. ");
INSERT INTO ptu_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Iya menggihi'um Puang Yesus lako boko'na anna nauai: “Pomatohoi penabammu, änä'ku! Bono'ungko aka ungkatappa'iä'.” Iya bono' eta siaham duka' indo baine. ");
INSERT INTO ptu_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Tappana landa' Puang Yesus lako banuanna indo to untambai, iya ullambi'um tau buda dio. Deem sanaka-naka to umponi sulim to mate anna buda tau umbatim. ");
INSERT INTO ptu_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Iya nauam Puang Yesus: “Le'ba'koa' aka inde änä'-änä' tä' tia mate sapo' mamma' bäbä hi tia!” Sapo' silele mandi umpetabai Puang Yesus. ");
INSERT INTO ptu_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Tappana messubunni indo tau buda, iya le'ba'um Puang Yesus tama tambinna indo änä'-änä'. Sulei tama, naanda'im limanna anna nabangonganni lambi' tubo sule. ");
INSERT INTO ptu_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Kaha-kaha ia too napelele asam ingganna hupatau illaam pa'lembängam ia too. ");
INSERT INTO ptu_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Puhai ia too, umpatahhu' oom pa'laoanna Puang Yesus. Iya muolai lalam nahingngim dio mai boko'na dua to buta katamba-tamba naua: “O peampoanna tomahaja Daud, kamaseikam kami'!” ");
INSERT INTO ptu_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Tappana tama banua Puang Yesus, iya sule siaham duka' indo dua to buta anna natuhu'i tama. Iya nakutanaim naua: “Ungkatappa'i haka la malakoa' kupabono'?” Natimba'im naua: “Io, kikatappa'i, Tuam.” ");
INSERT INTO ptu_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Iya nahakasammi matanna anna nauaanni: “Bono'ungkoa', situhu' kamatappasammu.” ");
INSERT INTO ptu_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Iya tappa masiä' siaham pennenne'na. Sapo' napakahi'di mate-mateam Puang Yesus naua: “Deem aia' la lao untula' inde kupogausangkoa' le!” ");
INSERT INTO ptu_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Sapo' tappa le'ba' dia napalele kaha-kaha ia too lako dio mai illaam pa'lembängam ia too. ");
INSERT INTO ptu_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Le'ba'na indo dua to buta, iya sule pole oom tau umpasola mesa to pepe. Ia anna pepei aka napentamai setam. ");
INSERT INTO ptu_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Tappana puha nahambai lao Puang Yesus indo setam illaam kalena, iya mala siaham ma'tula'. Nasuhum sangngim nakapilla'i pada to muitai kadadiam ia too anna sipa'tula'-tula'i naua: “Maneanna si'da pole' diita inde kadadiam susi illaam alla'-alla'na to Israel.” ");
INSERT INTO ptu_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Wattu eta too dio duka' heem sanaka-naka to mentama kakalebuanna Parisi muita kaha-kaha ia too. Iya sipa'tula'-tula'um naua: “Kuasanna hi tia tomahajanna setam illaam kalena nasuhum mala uhhambai lao setam.” ");
INSERT INTO ptu_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Puhai ia too, iya ulleleim mobotto-bottoam Puang Yesus si ma'pa'guhu illaam pa'sambajanganna to Yahudi anna umpa'pakahebaam Kaheba Katilallasam naua: “Bambannam umpalako kapahentaanna Puang Allataala.” Anna umpabono' ingganna to masaki anna umpapia pole dadinna to sala dadi. ");
INSERT INTO ptu_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Wattu eta too tä' deem pada sahäntä buana Puang Yesus tappana muita tau buda masussa penaba anna kattu hannu. Aka sihhapam domba tä' deem to ungkambi'i. ");
INSERT INTO ptu_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Iya umpa'tula'i siaham passikolanna naua: “Indo tau illaam inde lino sihhapam pahe matäsä'um. Buda indo pahe matäsä', sapo' saidi' to mepahe. ");
INSERT INTO ptu_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Dadi pelauia' längäm puäna indo pepaheam anna mala ussua buda tau umpepaheanni.” ");
INSERT INTO ptu_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Puhai ia too, untambaim indo sapulo dua passikolanna Puang Yesus anna nabeenni kakuasaam la uhhambai lao setam, umpabono' ingganna to masaki, anna umpapia pole dadinna to sala dadi. ");
INSERT INTO ptu_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","4","Indo to sapulo dua suhona Puang Yesus, isanga Simon, biasa toi duka' si diuaam Petrus, anna Andreas solasubunna Petrus, anna Yakobus sola Yohanes to ma'solasubum, bassim änä'na Zebedeus, anna Filipus, Bartolomeus, Tomas, Matius indo tuam passima yolona, Yakobus (änä'na Alfeus), Tadeus, Simon to illaam kakalebuanna Zelot, anna Yudas Iskariot to la umbalu' Puang Yesus. ");
INSERT INTO ptu_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Inde sapulo dua suhona Puang Yesus sangngim nasämpä limanna anna napakahi'dii naua: “Tä'koa' la mala lu lako tondä'na taianna to Yahudi, anna tä' tookoa' duka' la lu lako bottona to Samaria, ");
INSERT INTO ptu_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","sapo' la lu lakokoa' to Israel, indo to sihhapam domba bulim. ");
INSERT INTO ptu_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Sulekoa' too lako, iya muuammia': ‘Bambannam umpalako kapahentaanna Puang Allataala!’ ");
INSERT INTO ptu_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Pabono'koa' to masaki, patubokoa' sule to mate, sapuianni sakinna to dolengam, anna la uhhambaikoa' lao setam. Inde kakuasaam dibeem bäbäkoa'i, dadi la pahallukoa' duka' umpabono' bäbä to masaki. ");
INSERT INTO ptu_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Mane deenni, tä'koa' la mala umbaba doi' illaam pa'laoammu, susi doi' bulabam, doi' peha', battu haka doi' tembaga. ");
INSERT INTO ptu_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Angganna' poheba illaam kalemu la umpake. Tä'koa' la umbaba taa', tä' tookoa' la umbaba dua baju, sandala', anna tekkem. Aka ingganna to mengkähä abana sipäto' la diponnoiam kapahalluanna. ");
INSERT INTO ptu_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Maka' sulekoa' lako mesa kota battu haka tondä', iya la umpeäa' banua muongei indo la ahu'na untahima manappakoa', anna la tohho liukoa' eta sampe le'ba'koa' umpellei indo ongeam ia too. ");
INSERT INTO ptu_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Anna maka' la mentamakoa' mesa banua, la muuaa': ‘Handandanni Debata untamba'koa'.’ ");
INSERT INTO ptu_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Maka' natahima manappakoa' indo to ma'banua, iya la natahima si'da too indo pa'tamba' umpelauanna'. Sapo' maka' tä'koa' natahima, iya pelauia' längäm Puang Allataala anna naäläi sule indo pa'tamba' umpelauanna' ingngena'. ");
INSERT INTO ptu_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Anggam ia, maka' deem to ma'banua battu haka pa'tondä' tä' untahimakoa', battu haka tä' naaku umpehingngii tula'mua', iya la umpelleia' lao indo banua haka tondä' daka, anna la umpempassianna' sobä' dio bitti'mu, anna mala mendadi tanda diua ditumpu pala' ia indo tondä' ia too. ");
INSERT INTO ptu_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Aka setongam-tonganna, maka' too ke lambi'um indo allo la naongei Puang Allataala umpopa'tadongkongam hupatau, la mabanda' puha ia tahungkunna issinna indo tondä' ia too anna la issinna kota Sodom anna Gomora.” ");
INSERT INTO ptu_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Anna mane naua pole umpakahi'di suhona: “Pengkilalai manappaia', la sihhapangkoa' too domba kusua tama alla'-alla'na olo'-olo' to peande. La majaga liukoa' sihhapam langkasi anna la malunä' penabakoa' sihhapam dangam-dangam. ");
INSERT INTO ptu_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","La majaga polepokoa' too liu, aka la deem too tau ussakkakoa' anna nababakoa' lako olona to mahhotto' illaam peadasam, anna natembe'koa' illaam pa'sambajanganna. ");
INSERT INTO ptu_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Anna la dibabakoa' lako olona to ma'pahenta anna tomahaja aka untuhu'iä'. Iya wattu etam too la muongeia' mendadi sa'bingku dio olona anna lu lako hupatau to taungkaleso manappa Puang Allataala. ");
INSERT INTO ptu_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Sapo' maka' la dihotto'ungkoa', tä'koa' la umpakabeba penabammu la muua: ‘Aka amom isanga la diua mentimba'?’ Aka indo tula' la umpopentimba'a' taia tula' di kalemu bäbäa' sapo' la napasondoikoa' Puang Allataala. ");
INSERT INTO ptu_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Aka setonganna indo tula' la umpokada taia gatti kalemu bäbäa', sapo' la napalosaikoa' Penaba Masehona Ambemu yabo suhuga. ");
INSERT INTO ptu_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Anna la kende' too tatta' asu lambi' to ma'solasubum la palla' penabanna umpopepatei solasubunna. Susi toi duka' ambe la umpallasam änä'na anna änä' la umbali tomatuanna sampe napatei. ");
INSERT INTO ptu_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Anna la nakabassi asangkoa' too tau aka ungkatappa'iä'. Sapo' iai too mentobe manda' anna mengnganti matoto' illaam kamatappasam lako kaleku sule lako ma'katampasanna, tau iam too la dipasalama'. ");
INSERT INTO ptu_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Maka' too didahhakoa' dio mesa ongeam, iya la masimpangkoa' too muäläi kalemu anna le'ba'koa' lako ongeam senga'. Setongam-tonganna, tä'pi la ussambaa' ingganna ongeam illaam lembäna Israel, anna sulemä' sule to disangai Änä' Mentolino. ");
INSERT INTO ptu_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Mesa passikola tä' tia la matande puha ia anna la tuangguhunna, susi siam duka' mesa sabua' tä' tia la matande puha ia anna la puäna. ");
INSERT INTO ptu_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Handam malannam tia ke sipadaanni tuangguhunna indo mesa passikola, susi siam duka' indo sabua' anna puäna. Dadi Kao duka' to mampahe' anna si nasangaiä' ‘Beelzebul,’ battu diua tomahajanna setam, iya senga'unna' tiko to dipahe'. ");
INSERT INTO ptu_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Sapo' tä'a' la ungkahea' tau ia too. Aka ingganna aka-aka tisambona la dipakaleängam asam, anna ingganna aka-aka tibuninna, la dipatandaam. ");
INSERT INTO ptu_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Aka inde kupa'tula'ikoa' temo kada ditambimpi, sapo' la pahallua' lao umpa'paissangam. Inde tentomai mato-mato kupa'bisi'ikoa', sapo' la pahallua' lao umpebangkoam lako ingganna hupatau. ");
INSERT INTO ptu_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Anna tä' la ungkahea'a' indo to anggam mala umpatei bätä punti, aka tä' ia deem kakuasaanna la umpatei bätä sungnga'. La mahea' lako hakoa' Ia Puang Allataala to kuasa umpakahio-hio sungnga' anna bätä punti illaam nahaka. ");
INSERT INTO ptu_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Taissanna' pada-pada taua dua dena' sai'di' allinna aka anggam mesa himi'. Moinna anna susi, sapo' tä' la mala mate bäbä, moi podo la mesam, ke tä'i napoelo' Ambemu yabo suhuga. ");
INSERT INTO ptu_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Senga'unna' tiko, aka meanggaa' beluä'mu puha nahekem asam di tia. ");
INSERT INTO ptu_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Dadi, iam too anna tä'ungkoa' la mahea', aka moi la pada umba budanna dena' tala sipadaannia' angga'mu. ");
INSERT INTO ptu_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Menna-menna muakui kamatappasanna di Kao dio olona hupatau, tau iam too duka' la kuakui dio olona Ambeku yabo suhuga kuua: ‘Iam too inde pentuhu'ku.’ ");
INSERT INTO ptu_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Sapo' menna-menna umbahoiä' dio olona hupatau, tau iam too duka' la kubahoi dio olona Ambeku yabo suhuga.” ");
INSERT INTO ptu_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Tä' la ussangaa' suleä' inde lino anna la umbabaä' kasiolaam. Aka suleä' inde lino tä' umbaba kasiolaam, sapo' suleä' umbaba kasipengkaam. ");
INSERT INTO ptu_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","36","Kasuleangku inde lino la deem to ma'hapu illaam mesa banua natuhu'ä' piha anna la tä' piha nasuhum kende' kasipengkaam illaam alla'-alla'na. Susi änä'-änä' muane la sipengka ambena, teem änä'-änä' baine la sipengka indona, anna manintu baine la sipengka pasananna baine, battu diua to ma'hapu la sipengka-pengka paka ia. ");
INSERT INTO ptu_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Menna-menna umpaaha puha ia ambena sola indona anna la Kao, tau ia too tä' ia la sihatam mendadi umma'ku. Susi siam duka' to umpaaha puha ia änä'na muane battu haka änä'na baine, anna la Kao. ");
INSERT INTO ptu_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Menna-menna tä' umpassam kaju sitambenna anna natuhu'ä', tau ia too tä' duka' la sihatam mendadi umma'ku. ");
INSERT INTO ptu_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Menna-menna umpakalando puha ia katuboam di lino anna la Kao, tau ia too tä' ia la ullambi' katuboam sule lako salako-lakona. Sapo' menna-menna ahu' mate aka natuhu'ä', tau ia too la ullambi' indo katuboam sule lako salako-lakona. ");
INSERT INTO ptu_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Menna-menna untahimakoa', sihhapam siam tia Kao ma'kale natahima. Anna menna-menna untahimaä', sihhapam siam tia duka' indo To ussuaä' ma'kale natahima. ");
INSERT INTO ptu_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Menna-menna untahima manappa mesa nabi aka naissam naua mesa pelombum pudu'na Puang Allataala, tau ia too la untahima mana'na yabo mai Debata sipadaam mana'na mesa nabi. Anna menna-menna untahima manappa mesa to meada' aka naissam naua to si meada', tau ia too la untahima duka' mana'na sipadaam mana'na mesa to meada'. ");
INSERT INTO ptu_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Anna menna-menna umbeem pentuhu'ku to handam matuna moi podo uwai händäm aka naissam naua pentuhu'na Puang Yesus, mannassa anna tau ia too la untahima sahona.” ");
INSERT INTO ptu_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Tappana puha umpatudu indo sapulo dua suhona Puang Yesus, iya le'ba'um ullelei mobotto-bottoam illaam lembäna Galilea ma'pa'guhu anna umpa'pakahebaam Kaheba Katilallasam. ");
INSERT INTO ptu_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","3","Wattu eta too mahassam ditahungkum Yohanes to si mantedo'. Tappana naissanni naua si umpogau' tanda memängä-mängä Kristus, iya umpakahi'dim sanaka-naka passikolanna anna nasuai naua: “Laokoa' kutanai muua: ‘Ikongka indo To nalanti' Puang Allataala masäem diampai? Iya la tau senga' daka too?’” ");
INSERT INTO ptu_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Sulei lako umpellambi'i Puang Yesus, iya nakutanaim lambi' natimba'im naua: “Pa'pasulengkoa' anna untulasanni umba susi puhaa' uhhingngi anna muita. ");
INSERT INTO ptu_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Susinna to buta mala paita, to mate kalena mala mellao, to dolengam masapu dolenganna, to binga mala pahingngi, to mate tubo sule, anna Kaheba Katilallasam dipa'pakahebaam lako to handam matuna. ");
INSERT INTO ptu_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Kehongko' anna maupa' to tä' bata-bata lako kaleku.” ");
INSERT INTO ptu_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Tappana le'ba'i passikolanna Yohanes, iya umpa'tula'im tau buda Puang Yesus diona Yohanes naua: “Aka untungkaa' lako pohiallasam umpellambi'i Yohanes? Laokoa' umpetua' to ma'tille tipae'? ");
INSERT INTO ptu_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Iya aka haka' too untungka lako? Lao hakoka' too umpetua' to ma'poheba mapi'dä'? Sapo' situhu' Kao pikkihangku dio hi tia banuanna tomahaja indo to ma'poheba mapi'dä'. ");
INSERT INTO ptu_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Dadi aka hia' untungka lako? Lao hakoka' too umpetua' nabi? Maka' iaa' untungka, tappa' ia pole'. Aka kutulasangkoa' temo kuua setonganna indo Yohanes mentondom puha ia anna la nabi senga'. ");
INSERT INTO ptu_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Aka Yohanes-um too indo nauaam illaam Battakada Debata: ‘Indem ia pesuaku kupake'de' la umpendioloangangko, aka iam too to la umpatokaangko lalam la muola.’ ");
INSERT INTO ptu_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Setongam-tonganna, pempom dio mai ingganna hupatau illaam inde lino, tä' deem la untondom Yohanes to si mantedo'. Sapo' mentondom puha ia ingganna to mentamam kapahentaanna Puang Allataala moi anna matunai. ");
INSERT INTO ptu_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Mengkalao napahandu'na Yohanes to si mantedo' umpa'pakahebaam Kaheba Katilallasam sule lako temo, deem liu to kadake gau' umpobali kapahentaanna Puang Allataala anna si napeä liu lalanna la napentandolängänni. ");
INSERT INTO ptu_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Mengkalao suha' Pepaondonganna Musa anna tula'na ingganna nabi sule lako Yohanes sangngim ma'tula' diona inde dadi temo. ");
INSERT INTO ptu_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Anna maka' untahima inde tula', iya Yohanes-um too indo diuaam Elia to inna dipayolo lambam kasuleanna. ");
INSERT INTO ptu_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Lako ingganna ma'hupatau pahallu la umpatanam talinganna umpalempe sulim patomalinna anna napaillaam penabai inde tula'ku! ");
INSERT INTO ptu_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Akam la dipasihhapangam inde hupatau lapi' temo? Sihhapam liu indo änä'-änä' si ma'ko'bom-ko'bom lako pasa' anna metambai muuaam solana: ");
INSERT INTO ptu_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Kiponiammokoa' sulim sapo' moka hakoa' iko sumajo. Umpenaniammakam kelom bahata, sapo' moka hakoa' iko sumahho.’ ");
INSERT INTO ptu_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Aka sule Yohanes si bassa' puasa anna tä' toi muihu' anggur. Sapo' si nasangai hi tau: ‘To napentamai setam!’ ");
INSERT INTO ptu_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Pissananna suleä' to disangai Änä' Mentolino, iya si mangngandeä' Kao anna mangngihu' illaam pa'hame-hameam. Sapo' si nasangai bäbä hä': ‘To si mangngande sasa anna to si umpamäbo' kalena, sangkalamma'na tuam passima anna to madosa senga'.’ Moinna anna susi, sapo' tä' mala tala ma'tandaam kamanähänganna anna kakeakasanna Puang Allataala la lemba' illaam pa'palakoanna.” ");
INSERT INTO ptu_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Puhai ia too, iya napahandu'um Puang Yesus ussosso issinna kota to handam pembuda naongei umpadadi tanda memängä-mängä aka mokai untihokongam dosana, naua: ");
INSERT INTO ptu_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“La tilakakoa' iko ingganna issinna kota Korazim anna kota Betsaida aka mokakoa' muondo' gau' kadakemu. Aka indo tanda memängä-mängä kupadadi illaam alla'-alla'mua', kela kupadadi diom kota Tirus anna Sidon, la masäem untihokonganna gau' kadakena hupatau dio, lambi' ma'poheba bahata anna umpaponnoi täiabu ulunna aka ussosso gau'na. ");
INSERT INTO ptu_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Dadi kuuaangkoa' tentomai: maka' too ke lambi'um indo allo la naongei Puang Allataala umpopa'tadongkongam hupatau, la mahingngam leko' ia tahungkunna issinna kota Tirus sola Sidon anna la tahungkummua'. ");
INSERT INTO ptu_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Anna ikoa'-iko to Kapernaum, ussanga hia' iko umbai' la dipatiäkä' längängkoa' suhuga? Sapo' setonganna la ditibe tama hakoa' iko lembä bolom. Aka indo tanda memängä-mängä kupadadi illaam alla'-alla'mua', kela kupadadi diom indo kota Sodom yolona, iya tä' la natallanni Puang Allataala kota ia too. ");
INSERT INTO ptu_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Dadi kuuaangkoa' duka' tentomai: maka' lambi'um indo allo la naongei Puang Allataala umpopa'tadongkongam hupatau, la mahingngam leko' ia tahungkunna issinna kota Sodom anna la tahungkummua'.” ");
INSERT INTO ptu_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Wattu eta too ma'sambajam Puang Yesus naua: “O Ambe', Puäna langi' anna lino! Ma'kuhhu' sumanga'ä' matim olomu, aka indo kada ditambimmu tä' umpapähänni lako to naangga' manähä anna keaka' hupatau, sapo' umpapähänni leko' ia lako to naangga' matuna hupatau. ");
INSERT INTO ptu_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","O Ambe' abana inna ia pa'elo'mu.” ");
INSERT INTO ptu_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Puhai ma'sambajam, iya nauam: “Ingganna-ingganna sia puha asammi napadokkoannä' lisu pala'ku Ambeku. Tä' deem moi podo la mesa hupatau la muissam manappa Änä'na Puang Allataala sulibanna Ambe', anna tä' toi deem moi podo la mesa hupatau la muissam manappa Ambe' sulibanna Änä'na, anna to napoelo' Änä'na, anggam ia la muissam manappa Ambeku. ");
INSERT INTO ptu_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Maikoa' inggannakoa' to malupu' anna to umpendudum kabiasaam mabanda' illaam peadasam anna kupopellubekoa'. ");
INSERT INTO ptu_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Babai inde ajoka kupapassanniangkoa' ammu pe'guhua' lako kaleku. Aka Kao-kao malunä' penabaä' anna mahempo penaba. Aka maka' umpateenna', iya la tialaa' inabammu umba susi mesa to ussi'dim kamalubeam. ");
INSERT INTO ptu_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Aka indo ajoka la kupapassanniangkoa' mahingngam, anna indo dudungam la kupadudunniangkoa' tä' mabanda'.” ");
INSERT INTO ptu_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Pissam wattu illaam allo Katohhoam ma'lao-lao oom Puang Yesus sola passikolanna, iya umpa'tängäim mesa bela' gandum. Mahassam siam mellao napasindum siam ia passikolanna muala gandum anna naandei aka tadea'. ");
INSERT INTO ptu_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Tappana naita to illaam kakalebuanna Parisi, iya ma'kadam lako Puang Yesus naua: “Petua'pi inde lako passikolammu untekka pelahangam illaam peadasam umpogau' tala malanna dikähä illaam allo Katohhoam!” ");
INSERT INTO ptu_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Sapo' natimba'i naua: “Tä'paka' tiko deem umbata diona pa'pogausanna Daud sola pentuhu'na wattunna anna tadea'i? ");
INSERT INTO ptu_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Wattu eta too le'ba' Daud tama bahum kapenombaam anna naandei indo hoti puha dipehumalasam solai pentuhu'na, moi kela daa anggam tia sando mala muandei. ");
INSERT INTO ptu_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Tä'pia' duka' deem isanga umbata illaam Pepaondonganna Musa diona indo sando si ungkähä liu pengkähängam di ada' illaam allo Katohhoam illaam Banua Debata, nasuhum untekka indo pelahangam naua: ‘Tä' tau mala mengkähä illaam allo Katohhoam?’ Sapo' moinna anna susi, tä' siam duka' dipasala. ");
INSERT INTO ptu_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Patama tambu' manappaia' inde tula'ku kuua: eta inde temo deem mentondom puha Ia anna la Banua Debata. ");
INSERT INTO ptu_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Aka illaam Battakada Debata deem tisuha' naua: ‘Pa'kamase Kao handam kupaitoo'na, taia olo'-olo' dipehumalasam.’ Aka maka' la muissam manappaa' kalembasanna tula' ia too, iya mannassa anna tä'koa' la umpasala to tä' deem kasalaanna. ");
INSERT INTO ptu_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Aka setonganna, Kao hia Änä' Mentolino puäna allo Katohhoam.” ");
INSERT INTO ptu_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Tappana umpellei indo ongeam Puang Yesus sola passikolanna, iya le'ba'um lako mesa pa'sambajanganna to Yahudi. ");
INSERT INTO ptu_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Illaam indo pa'sambajangam, deem mesa tau mate limanna sabali. Eta too deem sanaka-naka to illaam kakalebuanna Parisi maelo' la umpeängam tuntungam su'be' Puang Yesus lambi' nakutanai naua: “Situhu' peadasam, la mala haka dipabono' tau illaam allo Katohhoam?” ");
INSERT INTO ptu_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Sapo' natimba'i Puang Yesus umpake mesa pehapangam naua: “Hapanna la deem mesa solamua' umpuängam mesa domba anna mehonno'i dokko gahoä sapo' illaam allo Katohhoam, iya tä' daka tia la napemäläi dio mai? ");
INSERT INTO ptu_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Kuua hi Kao keangga' puha siam tia hupatau anna la domba. Dadi setonganna tä' tau dilaham la umpogau' kamapiaam illaam allo Katohhoam.” ");
INSERT INTO ptu_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Puhai ia too, nauam Puang Yesus lako indo to mate limanna: “Äkä'i limammu!” Naäkä' siaham duka' indo limanna, iya bono' eta siaham susi indo lima sabalinna. ");
INSERT INTO ptu_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Tappa messubunni siaham indo to illaam kakalebuanna Parisi anna le'ba'i sipattuju-tuju la naaka susi anna malai dipatei Puang Yesus. ");
INSERT INTO ptu_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Sapo' naissam Puang Yesus indo pattuju kadakena to illaam kakalebuanna Parisi, nasuhum le'ba' umpellei indo ongeam. Iya naula'um tau buda, anna napabono' asanni Puang Yesus pada indo to masaki eta too. ");
INSERT INTO ptu_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Sapo' napa'pakahi'diam lako indo tau buda naua: “Tä' si'da-si'daa' too la mala untula' lako tau senga' diona Kaleku.” ");
INSERT INTO ptu_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Ia asanna ia too dadi anna mala sule lako indo kadanna Debata napalombum nabi Yesaya naua: ");
INSERT INTO ptu_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Petua'i, iam too inde Pesuaku to puha kupilei, to kupakamaja anna to umpomasannam penabangku; La kupatamai Penabangku, anna la umpa'pakahebaam diona indo kamaloloangku untingngajo hupatau. ");
INSERT INTO ptu_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Tä' Ia la naaku patelä-telä, anna tä' si kaoli-oli bäbä, anna tä' toi la naaku salle-salle kada lako ongeanna tau buda. ");
INSERT INTO ptu_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","La sa'baha' muoloi to matuna, sihhapam bulo sai'di' mandam tapolo tä' la napasilalla pissam, anna sihhapam lampu ma'miä'-miä' mandam tä' la napi'dei pissam. La napateem liu sampe sule lako indo pengkähänganna la umpopatalo kamaloloanna Puang Allataala. ");
INSERT INTO ptu_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Anna Ia la napassedanni hannu ingganna hupatau.” ");
INSERT INTO ptu_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Puhanna ia too, sulem sanaka-naka tau umpasola mesa to napentamai setam nasuhum buta anna pepe. Iya napabono' siaham Puang Yesus lambi' mala pole' paita anna mala toom ma'tula'. ");
INSERT INTO ptu_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Iya sangngim pilla' anna mängä-mängä ingganna to muitai kadadiam ia too naua: “Umbai' iangka tia isanga inde indo peampoanna tomahaja Daud masäem dipemmitai!” ");
INSERT INTO ptu_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Sapo' tappana nahingngi to illaam kakalebuanna Parisi diona kadadiam ia too, iya nauaim: “Kuasanna hi tia Beelzebul battu diua tomahajanna setam illaam kalena nasuhum mala uhhambai lao setam.” ");
INSERT INTO ptu_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Sapo' nalosa Puang Yesus tama pikkihannai nasuhum ma'tula' lako indo to illaam Parisi naua: “Maka' deem mesa kahajaam tä' mala mesa penaba hupataunna illaam, mannassa anna la kahenggängannai dadi. Susi toi duka' ke deenni mesa tondä' battu haka mesa pandaposam ke sikabassi-bassii issinna, mannassa anna la titale bangke'i issinna. ");
INSERT INTO ptu_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Susi siam too duka' kapahentaanna setam. Maka' la uhhambai lao setam indo tomahajanna setam, iya iam tia isanga sipobali-bali paka ia, nasuhum kende' kahenggänganna. ");
INSERT INTO ptu_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Tentomai untanda'ä' umpake kakuasaanna Beelzebul uhhambai lao setam. Dadi maka' susi, iya kuasanna haka duka' Beelzebul napake pentuhu'mua' uhhambai lao setam? Mannassa anna sala pikki'koa', aka taia duka' kakuasaanna setam napake pentuhu'mua' uhhambai lao setam! ");
INSERT INTO ptu_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Sapo' setonganna uhhambaiä' lao setam aka kakuasaanna Penabanna Puang Allataala muundu'ä'. Dadi mannassa diua umpalakom kapahentaanna Puang Allataala illaam alla'-alla'mua'. ");
INSERT INTO ptu_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Aka umba susi mesa to maboko mentama banuanna mesa to matoho la napabokoi, la napungo hi tia yolo indo to matoho mane naalai indo la nabokona, susimä' too duka' kutaloi yolo tomahajanna setam anna mane kuhambai lao indo pentuhu'na. ");
INSERT INTO ptu_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Menna-menna tä' untuhu'ä', tau ia too nabaliä'. Susi toi duka' lako to tä'kam pada kähä mahhempum, tau ia too, to mantaleam ia. ");
INSERT INTO ptu_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Iam too kasuhunganna anna kutulasammokoa' kuua: ingganna hupanna dosa anna pantelle mala asam naampunni Puang Allataala, sulibanna untelle Penaba Maseho. Aka to untelle Penaba Maseho tä' si'da-si'da ia la mala diampunni. ");
INSERT INTO ptu_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Deem sia ia paleleanna la diampunni to untelleä' to disangai Änä' Mentolino. Sapo' tä' si'da-si'da ia deem paleleanna la diampunni mengkalao illaam inde lino sule lako lino tando lako to untelle Penaba Maseho. ");
INSERT INTO ptu_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Maka' mapia satoo' kaju, mapia siam tia duka' buana. Sapo' maka' kadake, iya kadake siam tia duka' buana. Si mesa-mesa kaju diissam ditandai ke diitam buana. ");
INSERT INTO ptu_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","O inggammua' to si mambaba bulim pessubunna to kadake gau'! Tä' tia deem la mala mapia pessubungam pudu'mua' aka to kadake gau'koa'. Aka iai too tianna illaam unä' penabanna si mesa-mesa hupatau, ia siam tia duka' messubum dio pudu'na. ");
INSERT INTO ptu_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Lako to mapia gau', mannassa anna mapia siam tia duka' pessubungam pudu'na aka mapia illaam unä' penabanna. Sapo' lako to kadake gau', mannassa anna kadakei pessubungam pudu'na aka kadake illaam unä' penabanna. ");
INSERT INTO ptu_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Dadi kuuaangkoa' tentomai: Maka' lambi'um indo wattu la naongei Puang Allataala umpopa'tadongkongam hupatau, la nalambi' ia pekutanaanna Puang Allataala lako hupatau to nakabuttui ingganna tula' takeguna. ");
INSERT INTO ptu_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Aka pessubungam pudu'mu nasuhum tä'ko napasala Puang Allataala, anna pessubungam pudu'mu siam duka' nasuhum napasalako Puang Allataala.” ");
INSERT INTO ptu_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Wattu eta too ma'kada sanaka-naka to ullatta' Pepaondonganna Musa anna to illaam kakalebuanna Parisi lako Puang Yesus naua: “O tuangguhu, maelo' punalakam kela mala anna umpadadiko tanda memängä-mängä anna mala kiissam kiua buttu yabo si'dako mai Puang Allataala!” ");
INSERT INTO ptu_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Sapo' natimba'i naua: “Ia anna maelo'koa' la kupadadiam tanda memängä-mängä inde to tubokoa' lapi' temo aka sangngim ma'gau' kadakekoa' anna tä'koa' manontom lako Puang Allataala. Sapo' tä' la dipadadiangkoa' tanda memängä-mängä senga' sulibanna tanda memängä-mängä la dadi lako kaleku umba susi dadi lako kalena nabi Yunus yolona. ");
INSERT INTO ptu_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Aka umba susi nabi Yunus yolona tohho illaam tambu' bau tonggo tallungngallo tallum bengi, la susimä' too duka' to disangai Änä' Mentolino la tohho dio apa' mahihinna litä' tallungngallo tallum bengi. ");
INSERT INTO ptu_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Illaam indo wattu la naongei Puang Allataala umpopa'tadongkongam hupatau, la dipatibangom to Niniwe anna iai umpasalakoa' to tubo lapi' temo. Aka indo ia to Niniwe untihokongam ia gau' kadakena tappana uhhingngi kadanna Debata napalanda' nabi Yunus. Sapo' mokakoa' iko untihokongam gau'mu, moi kela daa inde to umpa'tula'ikoa' temo mentondom puha Ia anna la nabi Yunus. ");
INSERT INTO ptu_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Anna illaam indo wattu la naongei Puang Allataala umpopa'tadongkongam hupatau, la dipatibangom indo tomahaja baine to umpahenta paluäna Syeba yolona. Indo tomahaja ia too la napasalakoa' inde to tubokoa' lapi' temo, aka ahu' ia le'ba' umpehingngii kakeakasanna tomahaja Salomo moi anna mambela lalam naola. Sapo' ikoa'-iko mokakoa' umpehingngii inde tula'ku sitingngajokia' kita moi kela daa mentondom puha hä' Kao anna la tomahaja Salomo.” ");
INSERT INTO ptu_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Mane naua polei: “Maka' deem mesa setam messubummi illaam mai kalena tau, iya la le'ba' kalao-lao lako ongeam mabanginna umpeä ongeam la naongei tohho. Sapo' tä' deem nalambi' ongeam la mala naongei. ");
INSERT INTO ptu_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Iya nauam: ‘La ma'pasuleä' sule lako indo ongeangku ingngena'.’ Iya le'ba'um sule lako indo ongeanna, iya lo'bä liupi nalambi', sihhapam banua bahassi anna tiäto' mapia la naongei. ");
INSERT INTO ptu_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Iya le'ba' siaham untambai solana pitu, sapo' kadake puha ia indo solana anna la kalena. Anna tohho asanni illaam kalena indo tau. Ma'katampasanna, tau ia too la tuttuam tama kakajuanna indo kakadakeam illaam kalena anna indo anggapi mesa setam umpentamai. La susim too duka' ullambi'i to kadake gau' inde lapi' temo.” ");
INSERT INTO ptu_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Mahassampi ma'tula' Puang Yesus lako tau buda, iya sule ham indona sola solasubunna ke'de' dio sulibam maelo' la napellambi'i. ");
INSERT INTO ptu_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Iya ma'kadam mesa tau lako Puang Yesus naua: “O Tuangguhu, illaam sulibam indomu anna solasubummu. Maelo' ade' la napa'kadaiko.” ");
INSERT INTO ptu_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Iya natimba'im naua: “Aka mennaa' iko diuaam indoku? Anna menna diuaam solasubungku?” ");
INSERT INTO ptu_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Anna mane untuho lako ingganna passikolanna napasindum naua: “Indem ia mai diuaam indoku anna solasubungku ä. ");
INSERT INTO ptu_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Aka menna-menna umpalako pa'elo'na Ambeku yabo suhuga, tau iam too sihhapam solasubungku anna indoku.” ");
INSERT INTO ptu_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Allo eta siam too anna le'ba'i Puang Yesus umpellei indo banua lu lako le'bo' Galilea anna muokko'i dio bihinna. ");
INSERT INTO ptu_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Iya sulem buda tau ma'silullu' ullombai nasuhum tä'um ia deem naongei napobua' tau buda. Iya lu längämmi Ia lopi illaam le'bo' anna muokko'i. Anna yabo ia galantangam tau buda. ");
INSERT INTO ptu_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Iya umpalaom buda pepa'guhuam Puang Yesus sapo' nababa pehapangam naua: “Deem mesa tau le'ba' mangngambo'. ");
INSERT INTO ptu_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Tappana naambo' indo bannena, iya deemmi sabaheam tappa lako lalam. Iya suleim dassi naande sampe puha. ");
INSERT INTO ptu_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Deem tappa lako bobom batu, nasuhum masimpam tubo aka manipi' litä'na. ");
INSERT INTO ptu_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Sapo' tappana naalloi, iya malasso siaham nasuhum mabangi aka tä' mandalam waka'na. ");
INSERT INTO ptu_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Deem toi tappa lako alla' kuhha keduhi. Tappana tuttuam mahombo indo kuhha, iya umpissim indo tanangam sampe tä' mala kembua. ");
INSERT INTO ptu_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Sapo' deem duka' tappa lako litä' malompo, iya mapi'dä' ia tubona nasuhum kembua tiluppi'-luppi'. Deem tiluppi' sahatu', deem tiluppi' annam pulo anna deem tiluppi' tallu pulo. ");
INSERT INTO ptu_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Lako ingganna ma'hupatau pahallu la umpatanam talinganna umpalempe sulim patomalinna anna napaillaam penabai inde tula'ku!” ");
INSERT INTO ptu_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Puhai ia too, iya umpengngampe'im Puang Yesus indo passikolanna anna nakutanai naua: “O Tuangguhu! Akanna umbaba pehapanganni indo tula'mu lako tau buda?” ");
INSERT INTO ptu_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Iya natimba'im naua: “Aka angganna' iko dipaissanni indo kada ditambim diona kapahentaanna Puang Allataala, sapo' tä' ia dipaissanni tau buda. ");
INSERT INTO ptu_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Aka menna-menna umpaillaam penabai, tau ia too la dihängänniam polepi kapaissanganna, lambi' tuttuam buda naissam. Sapo' to moka umpaillaam penabai, iya la diäläi pissam ia lao indo kapaissangam nasanga deemmi illaam kalena. ");
INSERT INTO ptu_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Iam too kasuhunganna anna kubaba pehapangammi lako inde mai tau aka la naita liu sapo' tä' la naala akkalanna; anna la nahingngi liu sapo' tä' la naissam kalembasanna, anna tä' toi la napähäm. ");
INSERT INTO ptu_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Nasuhum la sule lako pole' indo kadanna Debata napalanda' nabi Yesaya naua: ‘La nahingngi liu, sapo' tä' la mala naala pikkihanna, anna la naita liu, sapo' tä' la mala naala akkalanna. ");
INSERT INTO ptu_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Aka inde mai tau makahha'um penabanna, anna si ma'binga-binga sola ma'buta-buta. Napateem indana paitai matanna, pahingngi talinganna, anna indana naalai penabanna, lambi' ma'pasule sule lako Kaleku nasuhum kupabono'.’ ");
INSERT INTO ptu_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Sapo' ikoa'-iko tä' deem pada sakehongko'koa' inggannakoa' passikolangku, aka paitaa' matammu anna pahingngi talingammu. ");
INSERT INTO ptu_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Aka setongam-tonganna, buda nabi anna to meada' yolona maelo' la naita inde to muitaa' temo, sapo' tä'um ia mala naita. Anna maelo' la nahingngi inde to uhhingngia' temo, sapo' tä'um ia mala nahingngi.” ");
INSERT INTO ptu_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Anna mane naua Puang Yesus: “Patananniia' talinga kalembasanna indo pehapangam diona to mangngambo'. ");
INSERT INTO ptu_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Indo diuaam banne tappa lako lalam, dipasihhapam to uhhingngi Battakadanna Puang Allataala diona kapahentaanna, sapo' tä' naissam napekalembasam. Iya sulem tomahajanna setam anna nahappai indo to puha diambo' illaam penabanna indo tau. ");
INSERT INTO ptu_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Indo banne tappa lako bobom batu, dipasihhapam ia mesa tau tappana umpehingngii Battakadanna Puang Allataala, iya tappa natahima sola ponno penaba. ");
INSERT INTO ptu_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Sapo' tä' siam masäe aka tä' kewwaka' illaam kalena. Deenna too kamasussaam anna pandahhaam uhhuai aka untuhu'i Battakadanna Puang Allataala, iya soho' boko' siaham aka tä' mandalam kapeimanganna. ");
INSERT INTO ptu_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Indo banne tappa lako alla' kuhha keduhi dipasihhapam ia to uhhingngi Battakadanna Puang Allataala, sapo' tä' mala kembua mapia aka nakadakei kamalallanganna diona salu katuboanna anna maelo' sugali' la to makaka lambi' umpa'lembeim ia Battakadanna Puang Allataala. ");
INSERT INTO ptu_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Anna indo banne tappa lako litä' malompo, dipasihhapam ia to uhhingngi Battakada Debata anna napekalembasam manappai, nasuhum kembua tiluppi'-luppi'. Deem tiluppi' sahatu', deem tiluppi' annam pulo, anna deem tiluppi' tallu pulo.” ");
INSERT INTO ptu_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Pehapangam senga' opi natula' Puang Yesus naua: “Kapahentaanna Puang Allataala dipasihhapam issinna inde tula': Deem mesa tau muambo' gandum dio bela'na. ");
INSERT INTO ptu_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Sapo' mamma' asanni tau, iya sulem balinna untantam bungam hea tama alla'na indo gandum, mane le'ba'i sule. ");
INSERT INTO ptu_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Tappana tubo indo gandum anna napahandu'um tuho-tuhoam buana, iya diitam duka' tubo indo hea. ");
INSERT INTO ptu_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Iya le'ba' siaham indo to mengkähäna umpellambi'i puäna indo bela' anna nauaanni: ‘O tuam, taia haka tia gandum asam indo muambo' dio bela'mu? Umpasiambo' isanga bungam hea anna tuboi duka'?’ ");
INSERT INTO ptu_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Iya natimba'im naua: ‘Balinta hi tia muambo' bungam hea.’ Mekutana pole oom indo to mengkähäna naua: ‘Muaku haka ke le'ba'kam kihebu'i indo heana?’ ");
INSERT INTO ptu_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Sapo' naua indo puäna bela': ‘Tä' mala, aka tihebu' duka' manii indo gandum ke uhhebuingkoa' hea. ");
INSERT INTO ptu_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Päbäi mammi bassim tubo sule lako disäe' indo gandum. Etapa mane kuuaanni to mengkähäku: Hempunnia' yolo itim hea anna umba'ba-ba'basannii mane untibeia' tama api. Anna mane uhhempungannä' ia indo gandum anna muannannä' tama loko.’” ");
INSERT INTO ptu_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Pehapangam senga' opi natula' Puang Yesus naua: “Kapahentaanna Puang Allataala sihhapam mesa lise'na sesawi natanam tau lako bela'na. ");
INSERT INTO ptu_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Ingganna tanangam ma'lise', lise'nam kaju sesawi handam bahinni'. Sapo' maka' tubom, iya kasalle puha ia anna la tanangam senga' illaam bela', nasuhum mala naongei dassi ma'sehä täkena.” ");
INSERT INTO ptu_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Anna mane muala pole mesa pehapangam senga' naua: “Kapahentaanna Puang Allataala mala duka' dipasihhapam bibi' hoti naala baine anna naboloianni appa' pulo lite' tehigu sampe nasamba asam lambi' sumbakka'.” ");
INSERT INTO ptu_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Ingganna ia too natula' asam Puang Yesus lako indo tau buda nababa pehapangam. Anna tä' deem si ma'tula' senga' ke tä'i nababa illaam pehapangam, ");
INSERT INTO ptu_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","anna mala sule lako indo kadanna Debata napalombum mesa nabi yolona naua: “La pehapangam kupake ke ma'pa'guhuä'; La kupomasiäsam pole' indo kaha-kaha to dipokada ditambimpi mengkalao dio mai dipadadinna inde lino.” ");
INSERT INTO ptu_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Puhai ma'tula' Puang Yesus lako indo tau buda, iya le'ba'um napellei anna lu tamai mesa banua. Iya napellambi'im passikolanna anna nauaanni: “Kela mala Tuangguhu anna untulasangkam kalembasanna indo pehapangam diona hea illaam alla' gandum.” ");
INSERT INTO ptu_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Iya napomasiäsammi duka' naua: “Indo to muambo' gandum, Änä' Mentolino diuaam battu diua Kao. ");
INSERT INTO ptu_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Anna indo ia bela', kalembasanna inde lino diuaam. Gandum ia, kalembasanna indo to mendadim umma'na Puang Allataala. Anna indo hea, kalembasanna indo to untuhu'i tomahajanna setam. ");
INSERT INTO ptu_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Anna balinna Puang Allataala battu diua to untantam hea, kalembasanna tomahajanna setam. Anna wattunna disäe' gandum, kalembasanna indo allo ma'katampasanna diuaam. Anna indo to massäe', kalembasanna malaika'. ");
INSERT INTO ptu_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Umba susi indo hea dihempum mane ditibei tama api, la susim too duka' ullambi'i lako pentuhu'na tomahajanna setam illaam allo ma'katampasanna. ");
INSERT INTO ptu_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Aka illaam allo ia too, Kao to disangai Änä' Mentolino la ma'kaleä' ussua malaika'ku uhhempum ingganna to si mebaba bulim sola ingganna to si umpogau' kakadakeam illaam kapahentaangku. ");
INSERT INTO ptu_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Anna ingganna tau ia too, la ditibe ia tama api tapi'de-pi'de. Anna illaanni sumahho lumoa' sikekko' isinna tamate tatubo. ");
INSERT INTO ptu_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Sapo' lako hupatau to umpalako pa'elo'na Puang Allataala la muampuam ia kamatandeam la mesilo susi mata allo illaam kapahentaanna Ambena yabo suhuga. Lako ingganna ma'hupatau pahallu la umpatanam talinganna umpalempe sulim patomalinna anna napaillaam penabai inde tula'ku!” ");
INSERT INTO ptu_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Anna mane untula' oi pehapangam Puang Yesus naua: “Indo kapahentaanna Puang Allataala sihhapam mesa baham-baham masuli' tilamum illaam bela'. Pissananna nalambi' mesa tau indo baham-baham masuli'. Tappa nalamum sule anna mane le'ba' umbalu' asam ingganna kullena aka tilalla' sugali' anna laoi naalliam indo bela'. ");
INSERT INTO ptu_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Mane deenni, to la mendadi umma' illaam kapahentaanna Puang Allataala sihhapam mesa pa'bulele umpeä mutiara handam masulli'. ");
INSERT INTO ptu_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Tappana nalambi', iya le'ba' siaham umbalu' asam kullena anna mane ma'pasule mualli indo mutiara.” ");
INSERT INTO ptu_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Anna mane untula' oi mesa pehapangam Puang Yesus naua: “Kapahentaanna Puang Allataala illaam allo ma'katampasanna, mala dipasihhapam mesa dala dipessämbäsam dokko le'bo' lambi' ussakka ma'hupa-hupa bau. ");
INSERT INTO ptu_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Tappana nasi'dinni indo to modala ponnom bau illaam indo dalana, iya nasibeso-besoim längäm galantangam mane nase'lai bau kadake anna bau mapia. Ia bau mapia napalutama pa'pongngeanna, anna ia bau kadake natibe lao. ");
INSERT INTO ptu_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","La susim too ke illaammi allo ma'katampasanna, aka la sule malaika' tama inde lino usse'la to kadake gau' anna to untuhu'i pa'elo'na Puang Allataala. ");
INSERT INTO ptu_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Indo to kadake gau' la ditibe ia tama api tapi'de-pi'de. Anna illaanni sumahho lumoa' sikekko' isinna tamate tatubo.” ");
INSERT INTO ptu_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Anna mane mekutanai Puang Yesus lako passikolanna naua: “Muissam daka' kalembasanna pada inde tula'ku?” Natimba'im passikolanna naua: “Io, kiissammi kalembasanna.” ");
INSERT INTO ptu_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Iya nauam Puang Yesus: “Mapia, dadi ingganna tuangguhu illaam peadasam to mendadim umma' illaam kapahentaanna suhuga mala dipasihhapam mesa puäna banua muala baham-bahanna illaam mai pa'pongngeanna susi malusanna teem bakahunna.” ");
INSERT INTO ptu_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Tappana puha asam natula' Puang Yesus ingganna indo pehapangam, iya le'ba'um ");
INSERT INTO ptu_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","sule lako tondä'na. Dioi, le'ba'um tama pa'sambajanganna to Yahudi anna ma'pa'guhui illaam. Iya mängä-mängä asam to uhhingngii tula'na lambi' sipa'tula'-tula' naua: “Menna hia umbai' umpa'guhui inde tau anna ma'pateem sugali'i manähäna? Anna menna hia umbai' umbeenni kuasa nasuhum ma'pateem inde kakuasaanna umpogau' tanda memängä-mängä? ");
INSERT INTO ptu_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Akanna malai susi, kusanga toda' änä'na tukam kaju anna Maria indona anna solasubunna isanga Yakobus, Yusuf, Simon, sola Yudas! ");
INSERT INTO ptu_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Anna kusanga si sola-sola siangkia' indo solasubunna baine. Menna isanga napangngalai inde kamanähängam anna kakuasaam?” ");
INSERT INTO ptu_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ma'katampasanna sangngim meali-ali nasuhum untumpu pala' Puang Yesus. Iya ma'kadam Puang Yesus naua: “Mesa nabi dipa'kasallei ke lakoi ongeam senga', sapo' tä' ia dipa'kasallei ke illaanni botto litä'na anna illaam banuanna.” ");
INSERT INTO ptu_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Iam too anna tä'um ia umpogau' buda tanda memängä-mängä dio tondä'na aka tä' nakatappa'i solana. ");
INSERT INTO ptu_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Wattu eta too napelele duka' Herodes indo tomahaja dio lembäna Galilea diona Puang Yesus. ");
INSERT INTO ptu_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Iya ma'kadam lako to mengkähä illaam banuanna naua: “Indo muuaanna' Puang Yesus, iya indo hi tia Yohanes to si mantedo' tubo sule! Iam too anna deemmi kakuasaanna umpogau' tanda memängä-mängä.” ");
INSERT INTO ptu_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Ia anna ma'pikki' susii Herodes, aka ia ussua tau ussakka Yohanes anna mane napopesangkala illaam tahungkum. Ditahungkum Yohanes aka nasalla Herodes indo anna natappakadai naua: “Tä' punala sipäto' mualako Herodias bainena Filipus solasubummu umpobaine, aka tä' sihondoi peadasantaa'.” ");
INSERT INTO ptu_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Setonganna maelo'um Herodes kela dipatei Yohanes eta too, sapo' mahea' ohi lako to Yahudi aka buda tau ussangai Yohanes nabi. ");
INSERT INTO ptu_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Tappana lambi' allo kadadianna Herodes, iya sumajom mesa änä'na Herodias baine dio olona Herodes sola tosabena. Iya tä' deem pada satiala inabanna Herodes muitai indo sajona, ");
INSERT INTO ptu_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","nasuhum ma'pinda yolo lako indo to sumajo mane nauai: “Pelaui situhu' pa'pohäemu, aka tä' mala tala kuponnoi pelauammu.” ");
INSERT INTO ptu_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Iya napatuduim indona indo to sumajo lambi' le'ba' lako tomahaja Herodes anna nauai: “Kupelau anna umpadioannä' baki ulunna Yohanes to si mantedo'.” ");
INSERT INTO ptu_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Tappana nahingngi Herodes indo pelauanna, tappa masussa siaham penabanna aka la dipatei Yohanes. Sapo' anu' aka puham ma'pinda lako indo baine nahingngi tosabena, nasuhum muuaam sohodadunna: “Paolaia' pelauanna. ");
INSERT INTO ptu_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Laokoa' äläianni ulunna Yohanes lako tahungkum.” ");
INSERT INTO ptu_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Tä' masäe, iya sulem dibaba ulunna Yohanes dipadio baki anna dibeenni indo baine. Iya naalam duka' anna nababaanni lako indona. ");
INSERT INTO ptu_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Lessu'i ia too, iya sulem passikolanna Yohanes naala indo bakkena anna nalamunni. Puhai, le'ba'um umpa'tulasam Puang Yesus diona kaha-kaha ia too. ");
INSERT INTO ptu_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Naissanna Puang Yesus diona kamateanna Yohanes, iya le'ba' siaham längäm lopi sola passikolanna aka la lao umpeä ongeam mabuninna. Sapo' tappana naissanni tau buda naua le'ba' Puang Yesus lambam libanna le'bo', iya mengkalaoi siaham dio kotana anna le'ba'i naula', sapo' mangngola galantanganni ia. ");
INSERT INTO ptu_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Tuhunna Puang Yesus yabo mai lopi, iya muitam tau buda lambi' häntä buana nasuhum napabono' asam pada indo to masaki eta too. ");
INSERT INTO ptu_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Kahubenni, iya napellambi'im passikolanna anna nauaanni: “La bengi kalem! Moi kela daa pohiallasam inde taongeia'. Umbai' mapia ke ussuam le'ba' inde lako tau buda anna mala lao mualli kinande lako tondä' sikahuku'na inde ongeam.” ");
INSERT INTO ptu_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Sapo' natimba' Puang Yesus naua: “Tä' manggi' le'ba' aka ikoa' la umpandei.” ");
INSERT INTO ptu_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Iya nauam indo passikolanna: “Aka angga ham lima hoti anna dua bau kiampuam.” ");
INSERT INTO ptu_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Natimba' oom Puang Yesus naua: “Babaannä' to mai o!” ");
INSERT INTO ptu_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Iya nasuam Puang Yesus indo tau buda muokko' lako alla' humpu' anna mane naala indo lima hoti anna dua bau, mane mentongai längäm langi' nakuhhu'i sumanga' längäm Puang Allataala. Puhai ia too, napiä'-piä'um indo hoti mane nabeenni passikolanna natabaam lako indo tau buda. ");
INSERT INTO ptu_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Iya mangngandeim sampe dea'. Tappana puhai mangngande, iya nahempummi passikolanna indo tää'nam naande, iya ponnopi sapulo dua baka. ");
INSERT INTO ptu_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Indo to mangngande eta too kiha-kiha lima sa'bu muane, tä'pi ia dihekem baine sola änä'-änä'. ");
INSERT INTO ptu_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Puhai ia too, muuaammi passikolanna Puang Yesus: “Längängkoa' inde lopi ammu pendiolonna' lambam,” napasindum siam ussua duka' lao indo tau buda. ");
INSERT INTO ptu_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Tappana puhai ussua indo tau buda ma'pasule, iya lu längämmi Ia tanete Puang Yesus ma'sambajam mesa-mesanna. Yabo liupi Ia tanete sule lako bengi. ");
INSERT INTO ptu_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Wattu eta too indo lopinna passikolanna mambelam naola umpellei bihim le'bo'. Sapo' natammui hibu' tatta', nasuhum napalusau' napaludekke bombam indo lopinna. ");
INSERT INTO ptu_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Tappana la tibukka' kalei baja, iya sulem Puang Yesus umpellambi'i passikolanna mellao yabona uwai. ");
INSERT INTO ptu_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Naitanna passikolanna mellao yabona uwai, iya sangngim mahea' anna sikakissä'i naua: “Äiii, anitu dio mai!” ");
INSERT INTO ptu_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Sapo' tappa ma'kada Puang Yesus naua: “Pahapa'ia' penabammu, daa ummahea' aka Kao hi to Kao!” ");
INSERT INTO ptu_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Naua siaham Petrus: “O Debata, maka' Iko si'da, popellaoä' kao duka' yabona uwai anna mala kupellambi'iko.” ");
INSERT INTO ptu_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Natimba' duka' Puang Yesus naua: “Maiko!” Iya tuhum siaham duka' Petrus yabo mai indo lopi anna le'ba'i la umpellambi'i Puang Yesus mellao yabona uwai. ");
INSERT INTO ptu_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Sapo' tappana nasi'dim indo hibu' kasalle, iya tappa mahea' lambi' napahandu' siaham la tallam, napolalam kaoli-oli metamba naua: “O Debata, kamaseiä' kao!” ");
INSERT INTO ptu_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Nakandoi siaham duka' Puang Yesus anna nauaanni: “Akanna bata-batai penabammu? Kuhäm sugali'pi kamatappasammu di Kao!” ");
INSERT INTO ptu_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Puhai nakandoi, iya bassim le'ba'um längäm lopi, iya mattam siaham duka' indo hibu'. ");
INSERT INTO ptu_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Nasuhum ingganna indo to yabo lopi umpenombai Puang Yesus napasindum naua: “Abana Änä'na si'dako Puang Allataala.” ");
INSERT INTO ptu_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Tisampoi lopinna Puang Yesus sola passikolanna, iya tappa Genesaret nalambi'. ");
INSERT INTO ptu_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Tappana naissam indo to eta naua sule Puang Yesus, iya napalele siaham illaam indo pa'lembängam ia too, nasuhum ingganna to masaki eta too dibaba asam lako Puang Yesus. ");
INSERT INTO ptu_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Anna napelaui lako Puang Yesus naua: “Kela mala anna naantii moi podo tähämpä' jubamum to masakingki, iya la malam too bono'.” Lambi' ingganna to muantii mala asam bono'. ");
INSERT INTO ptu_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Puhai ia too, sulem sanaka-naka to illaam kakalebuanna Parisi anna to ullatta' Pepaondonganna Musa buttu yabo mai Yerusalem umpellambi'i Puang Yesus anna nakutanai naua: ");
INSERT INTO ptu_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Maaka hia isanga anna untekkai ada' kabiasaam passikolammu indo puha napaondom nene to taponene naua: ‘Manggi' tau si umbasei yolo lima mane mangngande tau!’” ");
INSERT INTO ptu_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Natimba' Puang Yesus naua: “Sapo' akanna untekkakoa' duka' pahentana Puang Allataala anna tambum lakokoa' pepaondonganna nene to umponene? ");
INSERT INTO ptu_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Aka puha ma'battakada Puang Allataala naua: ‘Pa'kasalleiko ambemu sola indomu;’ anna: ‘Menna-menna umpakaänä'-änä' ambena battu haka indona, tau ia too la dipatei.’ ");
INSERT INTO ptu_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","6","Sapo' si muua hia' iko ma'patudu lako tau: ‘Tä' tau pahallu umpa'kasallei ambeta sola indota ke diuai: indo la kutahiaiangkoa' battuam, iya puham kupehumalasam lako Puang Allataala.’ Dadi, aka anggaa' iko ada' kabiasaammu umpaitoo'na, nasuhum umpa'pa'deingkoa' pole' pahentana Puang Allataala. ");
INSERT INTO ptu_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Ikoa'-iko sangngim to ma'pudu' pandengkoa' anna ma'lila manähä! Abana tappa' kadanna Puang Allataala natula' loppo' nabi Yesaya yolona diona panggauammua' naua: ");
INSERT INTO ptu_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Itim matim tau dio bäbä pudu'na napa'kasalleiä', sapo' setonganna illaam penabanna napemboko'iä'. ");
INSERT INTO ptu_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Alla'um napenombaiä' aka anggam pepa'guhuam hupatau napepatuduam, mato-mato ia kupepatuduam anna taia hia.’” ");
INSERT INTO ptu_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Puhai ia too, iya untambaim tau buda Puang Yesus anna napa'tula'i naua: “Pehingngii manappaia' inde tula'ku anna umpaillaam penabai! ");
INSERT INTO ptu_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Ingganna kinande lu tamanna kalena hupatau, tä' ia la nakadakei dio olona Puang Allataala. Sapo' indo hi tia messubunna dio pudu'na hupatau ungkadakei.” ");
INSERT INTO ptu_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Puhai ia too, iya napengngampe'im passikolanna anna nauaanni: “O Tuangguhu, muissam daka muua meali-ali indo to illaam kakalebuanna Parisi tappana nahingngi indo tula'mu ingngena'?” ");
INSERT INTO ptu_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","14","Sapo' natimba'i Puang Yesus naua: “Muakaa' tiko umpehingngii itim matim to illaam kakalebuanna Parisi! Aka ingganna tanangam ke taiai Ambeku yabo suhuga untananni, mannassa anna la dihebu'i sule dokko waka'na. Anna indo to illaam Parisi pebabammua', sihhapam di tia to buta aka tä' muita lalam la naolanna. Aka maka' tia to buta untette to buta, katampasanna bassim metobä dokko gahoä.” ");
INSERT INTO ptu_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Iya nauam Petrus: “Mala haka ke untulasangkam kalembasanna indo pehapangam, Tuangguhu?” ");
INSERT INTO ptu_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Natimba' Puang Yesus naua: “Aka tä'paka' tiko duka' isanga muissam! ");
INSERT INTO ptu_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Ingganna dipalutamanna sädä le'ba' dokko tambu' anna tahhu' ditibe lao. ");
INSERT INTO ptu_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Sapo' indo tula' mengkalao illaam penaba messubum dio pudu', iya ia hi tia ungkadakei hupatau dio olona Puang Allataala. ");
INSERT INTO ptu_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Aka illaam penabanna hupatau naongei kende' ma'hupa-hupa kakadakeam susinna: pikkiham kadake, papateam, lullusam bannetau, gau' sessu', maboko, sa'bi tatappa', anna ma'pakolo'-kolo'i. ");
INSERT INTO ptu_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Ingganna kaha-kaha ia too ungkadakei hupatau, taia hi tia indo tä' tau umbasei lima kela mangngandei tau.” ");
INSERT INTO ptu_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Puhai ia too, iya le'ba'um umpellei indo ongeam Puang Yesus anna lu lakoi lembäna Tirus sola Sidon. ");
INSERT INTO ptu_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Dioi, napellambi'im mesa baine to Kanaan, indo to si nakahidi' to Yahudi anna katamba-tambai naua: “O Tuam, peampoanna tomahaja Daud, kamaseiä' kao! Deem änä'ku baine napentamai setam anna tä' deem pada sanasussai.” ");
INSERT INTO ptu_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Sapo' tä' mandi deem natimba'i Puang Yesus. Iya napengkahuku'im passikolanna anna napelaui naua: “O Tuangguhu, kamase-maseikam anna ussuai lao inde dio baine, aka dio lium mai boko'taa' kaoli-oli mehahu'!” ");
INSERT INTO ptu_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Iya nauam Puang Yesus: “Kao-kao anggamä' nasua Puang Allataala la umpamoloi peampoanna Israel, aka sihhapam domba bulim.” ");
INSERT INTO ptu_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Iya sule siaham dio olona Puang Yesus indo baine anna ma'balinguntu'i napasindum naua: “O Tuam, häntängäm dä' kao bua!” ");
INSERT INTO ptu_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Natimba' Puang Yesus naua: “Aka tä' punala sihatam kela dialai kinande dipatokaam änä'-änä' anna ditibeanni lako asu.” ");
INSERT INTO ptu_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Natimba' oom duka' indo baine naua: “Abana tappa'ko, Tuam! Sapo' kuua hi kao, indo asu dio ibi' meja mala hi tia duka' muande kinande tikadanna puäna.” ");
INSERT INTO ptu_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Iya nauam Puang Yesus: “Matappa' si'dako, indo'! Abana si'da la dipatiolai pelauammu.” Iya bono' eta siaham duka' indo änä'na. ");
INSERT INTO ptu_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Tappana umpellei indo ongeam Puang Yesus, iya le'ba'um uhhuttu' bihim le'bo' Galilea mane lu längänni mesa tanete anna muokko'i yabo. ");
INSERT INTO ptu_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Yaboi, iya sulem tau buda ma'obim-obim umpasola to masakinna anna napadioi olona Puang Yesus. Indo to masaki, deem to mate sapolona, to buta, to kempo', to pepe, anna budapi to masaki senga', lambi' napabono' asam. ");
INSERT INTO ptu_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Iya mängä-mängä asammi indo tau buda muitai aka to pepe mala ma'kada, to kempo' bono', to mate sapolona mala mellao, anna to buta mala paita. Napolalam sangngim umpa'kasallei Puang Allataala Debatanna to Israel. ");
INSERT INTO ptu_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Puhai ia too, iya uhhempummi passikolanna Puang Yesus anna nauaanni: “Tä' deem pada sahäntä buaku muitai inde lako tau buda, aka tallungngallo tallu bengingkia' inde sola-sola, iya pa'dem la naande. Sapo' tä' ohi palla' penabangku la ussua bäbäi ma'pasule lako banuanna, aka lako manii lalam anna tissämbä'i malimpä.” ");
INSERT INTO ptu_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Natimba'im passikolanna naua: “Pusa'kam pole' umpikki'i aka indekia' pohiallasam. Dadi la umbam ia ngei diala kinande dipandeam inde lako tau pada budanna?” ");
INSERT INTO ptu_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Iya nauam Puang Yesus: “Aka sanakapia' hotimmu?” Natimba'um naua: “Angga ham pitu, anna deempi duka' sanaka-naka bau bahinni'.” ");
INSERT INTO ptu_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Iya nauam Puang Yesus lako indo tau buda: “Okko'koa' lako itim paha'baja.” ");
INSERT INTO ptu_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Anna mane naala indo hoti pitu sola bau anna nasambajannii längäm Puang Allataala, mane napiä'-piä'i anna mane nabeem passikolanna napa'tahiaam lako indo tau buda. ");
INSERT INTO ptu_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Dea' asanni indo tau buda, iya nahempummi passikolanna indo tää'na naande, iya ponno polepi pitu baka. ");
INSERT INTO ptu_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Indo to mangngande eta too appa' sa'bu muane, tä'pi ia diissa' baine sola änä'-änä'. ");
INSERT INTO ptu_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Puhai ia too, iya nasuam Puang Yesus ma'pasule lako banuanna indo tau buda, anna mane le'ba'i Ia längäm lopi la lu lako lembäna Magadan. ");
INSERT INTO ptu_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Deem sanaka-naka to illaam kakalebuanna Parisi sola to illaam kakalebuanna Saduki maelo' la umpeängam tuntungam su'be' Puang Yesus. Iya napellambi'im anna nauaanni: “Paitaikanni tanda memängä-mängä anna mala kiissam kiua buttu yabo si'dako mai suhuga.” ");
INSERT INTO ptu_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Sapo' natimba' di Puang Yesus naua: “Maka' la lendu' allo anna maleai bihim langi', mannassa anna la muuaia'i: ‘La kulla' opi makale'.’ ");
INSERT INTO ptu_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Anna maka' mebengngi' anna ma'ku'dunni kaliane, tä' mala tala muuaa': ‘E, la uham allo.’ Dadi muissanna' usse'la tanda kela uhanni anna la kulla', sapo' tä' leko'a' ia muissam umpekalembasam inde tanda dipadadi illaam alla'-alla'mua' tentomai. ");
INSERT INTO ptu_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Maelo'koa' la kupadadiam tanda memängä-mängä aka ikoa' to tubo lapi' temo sangngim ma'gau' kadakekoa' anna tä'koa' manontom lako Puang Allataala. Sapo' tä' la dipadadiangkoa' tanda memängä-mängä senga' sulibanna tanda memängä-mängä la dadi lako kaleku, umba susi dadi lako kalena nabi Yunus yolona.” Puhai ma'tula' Puang Yesus, iya le'ba'um umpellei indo tau. ");
INSERT INTO ptu_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Tappana landa'i libam lambam libanna le'bo' Galilea Puang Yesus sola passikolanna, iya mane nakilalai hi passikolanna naua: “Tä'kia' umbaba hoti.” ");
INSERT INTO ptu_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Wattu eta too siampu' umpakainga' passikolanna naua: “La majaga manappakoa' too indana nakadakeikoa' bibi' hotinna to illaam kakalebuanna Parisi anna to illaam kakalebuanna Saduki.” ");
INSERT INTO ptu_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Tappana nahingngii passikolanna, iya sipa'tula'-tula'um naua: “Umbai' ia hi tia anna ma'kada susii, aka tä'kia' umbaba hoti.” ");
INSERT INTO ptu_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Sapo' naissam Puang Yesus diona indo natula' passikolanna, nasuhum ma'kada naua: “Abana si'da pada nipi'pia' bulu la'lahi kamatappasammu. Akanna ussitimba'-timba'i hakoa' iko diona pa'dena hotimmu? ");
INSERT INTO ptu_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Tä' liupia' isanga natama pikkihammu? Anna tä' toia' umbai' ungkilalai indo lessu' le', lima hoti kupiä'-piä', iya malaa' umpa'tahiaam lako tau la'bi lima sa'bu, anna sanaka-naka polepi baka tää'nam diande uhhempunna'! ");
INSERT INTO ptu_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Anna susi toi duka' indo pitu hoti mala umpadea' la'bi appa' sa'bu tau anna sanaka-naka polepi duka' baka uhhempunna' tää'nam diande. ");
INSERT INTO ptu_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Akanna tä' liuia' mala natama pikkihammu, aka taia bibi' hoti diande kuuaam? Indo hia bibi' hotinna to illaam kakalebuanna Parisi anna to illaam kakalebuanna Saduki kuuaam la unjagai manappaa' indana nakadakeikoa'.” ");
INSERT INTO ptu_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Katampasanna naissam asam pole' passikolanna naua: “Taia hia bibi' hoti si dipake ma'hoti nauaam, sapo' setonganna indo hia pepa'guhuanna to illaam Parisi anna to illaam Saduki la dijagai.” ");
INSERT INTO ptu_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Puhai ia too, le'ba'um Puang Yesus lako lembäna Kaisarea Filipi. Muolai lalam mekutanam lako passikolanna naua: “Situhu' tula'na tau, menna diuaam Änä' Mentolino?” ");
INSERT INTO ptu_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Iya natimba'im naua: “Deem tau muuai: ‘Yohanes to si mantedo' tubo sule;’ deem muuai: ‘Nabi Elia sule sule;’ deem duka' muuai: ‘Nabi Yeremia tubo sule;’ anna piha muuai: ‘Mesa nabi senga' tubo sule.’” ");
INSERT INTO ptu_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Iya mekutana oom lako passikolanna naua: “Maka' susi, iya akaa' iko ussangaiannä'?” ");
INSERT INTO ptu_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Tappa natimba' Simon Petrus naua: “Ikom too indo To dilanti' la mepasalama', Änä'na Puang Allataala Debata tubo.” ");
INSERT INTO ptu_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Iya nauam Puang Yesus: “Kehongko'ko anna maupa' Simon, änä'na Yunus, aka taia hupatau umpaissanniko itim tula'mu temo, sapo' ma'kale Ambeku yabo suhuga umpalosaiko. ");
INSERT INTO ptu_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Dadi tentomai kusangaingko Petrus, (kalembasanna, batu longkahhim.) Anna yabona inde batu la kupake'de' kakalebuanna umma'ku. Anna kakalebuam ia too tä' ia la mala nataloi kamateam. ");
INSERT INTO ptu_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Anna la kupadokkoangko lisu pala'mu pegontinna kapahentaanna suhuga. Iai too umpekadakeam illaam inde lino, ia siam too duka' napekadakeam Puang Allataala. Anna iai too umpemapiaam illaam inde lino, ia siam too duka' napemapiaam Puang Allataala.” ");
INSERT INTO ptu_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Anna mane muuaam passikolanna: “Moi la menna tala untulasannia' muua: ‘Iam too indo To nalanti' Puang Allataala la mepasalama'.’” ");
INSERT INTO ptu_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Wattu etam too anna napahandu'i Puang Yesus umpaissanni loppo' passikolanna diona indo kamapi'disam la napendudum, naua: “Tä' mala tala längännä' Yerusalem anna la napahuaiä' pandahhaam matua ulunna to Yahudi anna ingganna kapala sando sola to ullatta' Pepaondonganna Musa lambi' la napateiä'. Sapo' illaam allo katallunna la dipatibangonnä' sule dio mai alla'na to mate.” ");
INSERT INTO ptu_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Tappa nababai siaham lao Petrus umpelle-pellei solana anna nauaanni: “Daa umpa'kada susi Debata, la tä' di too napahuaiko Puang Allataala kaha-kaha ia too! La napasikambela hako too.” ");
INSERT INTO ptu_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Iya umpenggihi'im Petrus anna nauaanni: “Päläiko lao Setam! Ullabaiko pengkähängangku! Aka taia iko pa'elo'na Puang Allataala umpikki', sapo' angga iko pikkiham hupatau illaam penabammu.” ");
INSERT INTO ptu_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Anna mane ma'tula' lako passikolanna naua: “Menna-menna maelo' untuhu'iä' pahallu la ullappa' pa'elo' kalena, anna umpassam kaju sitambenna, anna natuhu'ä'. ");
INSERT INTO ptu_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Aka menna-menna umpa'kadua-duai katuboam di lino, tau ia too tä' ia la ullambi' katuboam sule lako salako-lakona. Sapo' menna-menna ahu' mate aka natuhu'ä', tau ia too la ullambi' ia indo katuboam sule lako salako-lakona. ");
INSERT INTO ptu_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Tä' deem gunana lako mesa tau moi la muampuam ingganna issinna lino kela sägä hi sungnga'na. Aka setonganna tä' ia deem bala'inna sungnga'na hupatau. ");
INSERT INTO ptu_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Aka Kao to disangai Änä' Mentolino la suleä' naponnoi kamatandeanna Ambeku, anna la natuhu'ä' ingganna malaika'na. Wattu eta too, la kupalambi'i buana situhu' pa'pogausanna hupatau si mesa-mesa. ");
INSERT INTO ptu_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Setongam-tonganna, deengkoa' to dio heem temo tä'pi la mate anna muitam Änä' Mentolino sule mendadi Tomahaja ma'pahenta illaam kapahentaanna.” ");
INSERT INTO ptu_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Annanni benginna puhanna ia too, iya umbabaim Petrus Puang Yesus anna indopi to ma'solasubum isanga Yakobus sola Yohanes, anna le'ba'i längäm mesa tanete malangka', anna yaboi paka-paka ia. ");
INSERT INTO ptu_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Iya naitam indo to tallu tieli' hupanna Puang Yesus. Indo lindona pangkähhä susi mata allo anna indo pohebana mesilo mabussä'. ");
INSERT INTO ptu_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Pissananna, naita ham duka' indo dua nabi yolona isanga Musa sola Elia mahassam sipa'tula' Puang Yesus. ");
INSERT INTO ptu_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Iya ma'kadam Petrus lako Puang Yesus naua: “O Debata, tä'um deem la susi kamasannangantaa' eta inde. Kela muaku anna kupake'desangkoa' tallu bahum: mesa Iko, mesa Musa anna mesa Elia.” ");
INSERT INTO ptu_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Mahassampi ma'tula' Petrus, iya tuhummi gabum mabussä' ussikuku'i indo ongeam. Anna dihingngii kamaha buttu illaam mai indo gabum naua: “Iam too inde Änä' pa'pakamajangku to umpomasannam penabangku. Pahallua' la umpehingngii!” ");
INSERT INTO ptu_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Nahingnginna indo kamaha, iya sangngim muoppäm dokko litä' aka tä' deem pada samahea'. ");
INSERT INTO ptu_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Sapo' tappa napellambi'i Puang Yesus anna nahaka'i napasindum naua: “Bangongkoa', daa ummahea'!” ");
INSERT INTO ptu_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Umbangongam siaham duka' ulunna, iya angga ham mesa-mesanna Puang Yesus naita. ");
INSERT INTO ptu_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Tappana tuhunni Puang Yesus sola indo to tallu yabo mai indo tanete, iya napakahi'dim naua: “Deem aia' la untula' säkä indo to puhaa' muita yabo tanete le, ke tä'i puhaä' dipatibangom to disangai Änä' Mentolino dio mai alla'na to mate!” ");
INSERT INTO ptu_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Iya nakutanaim passikolanna naua: “Sapo' maaka hia anna nauai to ullatta' Pepaondonganna Musa: ‘Tä' mala tala sule yolo nabi Elia anna mane sule indo To dilanti' la mepasalama'?’” ");
INSERT INTO ptu_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Natimba' Puang Yesus naua: “Abana pahallu la sule yolo Elia umpatoka ingganna-ingganna sia. ");
INSERT INTO ptu_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Sapo' kuuaangkoa' tentomai: Abana puham sule Elia, sapo' tä' naissam hupatau nasuhum ia siam anna ia napogausam. La susimä' too duka' to disangai Änä' Mentolino, la ia siam anna ia napogausannä' hupatau.” ");
INSERT INTO ptu_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Tappana nahingngi passikolanna indo pa'tula'na, iya mane sikanapähäm di pole' naua: “Yohanes to si mantedo' päläe' nauaam: ‘Elia.’” ");
INSERT INTO ptu_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Tappana ma'pasule Puang Yesus sola indo tallu passikolanna lako indo tau buda, iya sule siaham mesa tau anna ma'balinguntu'i dio olona Puang Yesus ");
INSERT INTO ptu_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","napasindum naua: “O Tuam! Kamaseiannä' kao änä'ku anna umpabono'i, aka limpu mänesam anna tä' deem pada sanasussai. Aka si bassa' punala songka tama api anna deem toi lu dokko uwai. ");
INSERT INTO ptu_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Anna puham kubabaam lako passikolammu, sapo' tä' mala napabono'.” ");
INSERT INTO ptu_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Iya ma'kadam Puang Yesus naua: “Kukapusa'i si'dakoa' pole' inde to tubo lapi' temo, aka kuhäm sugali'a' kamatappasammu! Anna tä' liupia' muissam usse'la kamapiaam anna kakadakeam. La pada polepi isanga umba masäena sola-solakia' anna la pada polepi isanga umba masäena la kusa'bahasangkoa'?” Mane nauai: “Babaannä' mai itim änä'-änä'!” ");
INSERT INTO ptu_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Iya nakissä'im Puang Yesus indo setam illaam kalena indo änä'-änä'. Iya tappa bono' eta siaham. ");
INSERT INTO ptu_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Puhai, iya napellambi'im passikolanna sapo' paka-paka ia ham anna nakutanai naua: “Maaka hia isanga anna tä'i kami' mala kihambai lao indo setam?” ");
INSERT INTO ptu_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Iya natimba'im Puang Yesus naua: “Aka kuhäm sugali'a' kamatappasammu. Setongam-tonganna, maka' la deenna' kamatappasammu moi podo padam i'di', iya tä' deem aka-aka la ungkapusa'i. Maka' ussua inde dio buntu mentieli' lako ongeam senga', tä' mala tala tieli'. ");
INSERT INTO ptu_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Sapo' inde setam susi, tä' sia mala disua lao ke tä'i tau ma'sambajam yolo sola puasa.” ");
INSERT INTO ptu_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Tappana ma'mesai Puang Yesus sola passikolanna dio lembäna Galilea, iya nauam Puang Yesus: “Kao to disangai Änä' Mentolino la dibeho tama pala' limanna hupatau. ");
INSERT INTO ptu_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","La napateiä', sapo' illaam allo katallunna la dipatibangonnä' sule.” Tappana nahingngi ingganna passikolanna pa'tula'na, iya tä' deem pada samasussa nasi'dim. ");
INSERT INTO ptu_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Tappana sule Puang Yesus sola passikolanna lako kota Kapernaum, iya sule siaham indo to si uhhempum tanggunganna tau tama Banua Debata umpellambi'i Petrus anna nauaanni: “Si nabaja' daka duka' tuangguhummua' indo tanggungam tama Banua Debata?” ");
INSERT INTO ptu_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Natimba' Petrus naua: “Io, si nabaja'!” Tappana sule tama banua Petrus, iya tä'pi deem ma'tula' anna nakutanaim Puang Yesus naua: “Maaka iko susi pikkihammu Simon diona indo sima si dibaja' lako to ma'pahenta? La ha'ja' illaanna haka botto umbaja'i, la ha'ja' lakona haka ongeam senga', indo to puha nataloi?” ");
INSERT INTO ptu_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Natimba' Simon Petrus naua: “Indo ha'ja' lako ongeam senga'!” Iya nauam Puang Yesus: “Dadi maka' tä'um ia pahallu mamaja' ha'ja' illaam botto, iya la susingki' too duka' tä'ungki' pahallu la umbaja' tanggunganta tama Banua Debata aka issinnangki' kapahentaanna Puang Allataala. ");
INSERT INTO ptu_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Sapo' päbäim too tabaja', indana masussai penabanna. Dadi le'ba'ungko popekam lako le'bo' Galilea. Alai indo bau uhuna naala pekammu anna umbekkä'i sädäna, aka la ullambi'um too doi' illaam la ganna' tabajasam tanggunganta duaki' tama Banua Debata. Alai indo doi' anna laoko umbajasangki' tanggunganta.” ");
INSERT INTO ptu_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Wattu eta siam too duka' anna mekutanai passikolanna naua: “O Tuangguhu, menna handam la matande illaam kapahentaanna Puang Allataala?” ");
INSERT INTO ptu_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Iya untambaim mesa änä'-änä' Puang Yesus anna nasuai ke'de'-ke'de' dio olona passikolanna ");
INSERT INTO ptu_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","anna nauai: “Setongam-tonganna kutulasangkoa' tentomai kuua: maka' tä'koa' ma'baju pole anna ma'dodo pole lambi' ma'penaba susi inde änä'-änä', iya la tä'koa' too mala mendadi umma'na Puang Allataala illaam kapahentaanna. ");
INSERT INTO ptu_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Menna-menna umpomahempo penabanna la susi inde dio änä'-änä', tau iam too la handam matande illaam kapahentaam yabo suhuga. ");
INSERT INTO ptu_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Anna menna-menna untahima änä'-änä' susi inde aka umpolalam kamatappasanna di Kao, tau ia too sihhapam siam Kao natahima.” ");
INSERT INTO ptu_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Sapo' menna-menna umpabulim inde änä'-änä' to puha matappa' nasuhum la tä'um nakatappa'iä', tau ia too aha leko'um dipatoke'i batu peepe' bahokona anna ditibei dokko le'bo' mandalam. ");
INSERT INTO ptu_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Tä' deem pada satilaka hupatau illaam inde lino aka deem to umpabulinni. Moi anna abana inna la dadi susi, sapo' tilaka lako hupatau to umpakende'i. ");
INSERT INTO ptu_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Maka' hapanna limammu la umpomadosako battu haka bitti'mu, mapia leko'um tia ke umpoloi lao anna untibei. Aka aham tia sabali-bali limammu battu haka bitti'mu sapo' la ullambi'ko katuboam sule lako salako-lakona, anna la tontä liu dua limammu battu bitti'mu sapo' ditibe hako tama api tapi'de-pi'de. ");
INSERT INTO ptu_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Anna maka' matammu la umpomadosako, kalessu'i lao anna untibei. Aka aha leko'um tia sabali-bali matammu sapo' ullambi'ko katuboam sule lako salako-lakona, anna la tontä liu dua matammu sapo' ditibe hako tama api nahaka.” ");
INSERT INTO ptu_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Patananni manappaia' talinga inde tula'ku: tä'koa' too la mala umpa'basisii moi podo la mesam inde änä'-änä'. Aka pahallua' la umpengkilalai manappa muua deem malaika' yabo suhuga dio olona Ambeku si unjagai liu inde mai änä'-änä'. ");
INSERT INTO ptu_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Aka inde Änä' Mentolino sule inde lino la umpaitai lalam to bulim anna mala tä' ullambi' katilakaam. ");
INSERT INTO ptu_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Maakaa' iko susi pikkihammu, aka la napogau' ke deenni mesa tau muampuam sahatu' domba sapo' bulim mesa? Mannassa anna la napellei yabo tanete indo dombana kaseha pulo kaseha anna le'ba'i nahuttu' indo mesanna. ");
INSERT INTO ptu_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Anna maka' nalambi'um indo to bulim, tä' mala tala natilalla'i puha ia indo mesa to puha pa'de sala anna la indo to kaseha pulo kaseha to tä' bulim. ");
INSERT INTO ptu_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Susim too duka' Ambemu yabo suhuga, tä' napohäe kela deenni moi podo la mesam inde mai änä'na la bulim.” ");
INSERT INTO ptu_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Maka' deem solamu to matappa' kasalaam lako kalemu, iya laoko pellambi'i mesa-mesammu anna umpakilalai. Anna maka' natahima indo tula'mu, iya ikom too nasuhum mesa penabakoa' sule. ");
INSERT INTO ptu_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Sapo' maka' tä'ko napehingngii, iya babai solamu mesa haka dua haka anna napasolaiko. Aka situhu' Battakada Debata, maka' duam tau battu haka tallu sisa'bi-sa'biam diona mesa kaha-kaha, iya tä'um too la dibata-batai. ");
INSERT INTO ptu_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Anna maka' moka pole boo umpehingngii indo solamu, palulakoia' jumaa' indo kaha-kahana. Anna maka' moka duka' umpehingngii jumaa', iya pasusinna' too tuam passima battu haka tau senga' to tä' muissam Puang Allataala. ");
INSERT INTO ptu_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Aka kutulasangkoa' tentomai kuua: iai too umpekadakeam illaam inde lino, ia siam too duka' napekadakeam Puang Allataala. Anna iai too umpemapiaam illaam inde lino, ia siam too duka' napemapiaam Puang Allataala. ");
INSERT INTO ptu_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Anna mesa polepi la kutulasangkoa' tentomai kuua: maka' deem dua to matappa' illaam inde lino mesa penaba ma'sambajam, tä' mala tala napasule lako pelauanna Ambeku yabo suhuga. ");
INSERT INTO ptu_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Aka umba-umba naongei to ungkatappa'iä' dua haka tallu haka ma'hempum, la etamä' too duka' tohho illaam alla'-alla'na.” ");
INSERT INTO ptu_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Puhai ia too, iya sulem Petrus umpellambi'i Puang Yesus anna nakutanai naua: “O Debata, la pessanakaä' muampunni solaku ke deenni umpogau' kasalaam lako kaleku? La ganna'ungka ke pempitui?” ");
INSERT INTO ptu_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Natimba' Puang Yesus naua: “Tä'pi ganna' kela anggai pempitu, sapo' la pempitu pulo hia sanda si pitu. ");
INSERT INTO ptu_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Aka maka' umpalakom kapahentaanna Puang Allataala, iya la sihhapam mesa tomahaja la ussinga' pa'paindanna lako mesa to dipake illaam kahajaanna. ");
INSERT INTO ptu_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Tappana napahandu' la nahekem indo pa'paindanna, iya dipasolaammi sule mesa to dipake illaam kahajaanna aka kaindangam la'bi lima juta bidä. ");
INSERT INTO ptu_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Sapo' aka tä' la nabela nabaja' indo indanna pada buda, nasuhum naua indo tomahaja: ‘Balusannä' kalena, pasibalu'i bainena sola änä'na anna ingganna aka-akanna anna mala deem nabajasam indanna.’ ");
INSERT INTO ptu_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Lambi' muoppä dio olona indo tomahaja anna mengkahumase-masei naua: ‘O tuam, sa'bahasam salapä' yolo säpäi' aka tontäm kubaja'na asam indo indangku.’ ");
INSERT INTO ptu_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Iya häntä siaham buana indo tomahaja uhhingngi pengkahumasena indo tau, nasuhum naangga' puha bäbäm indo indanna, lambi' nauaam: ‘Le'ba'ungko, tä'um manggi' umbaja' indo indammu.’ ");
INSERT INTO ptu_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Tappana umpellei indo banuanna tomahaja, iya sitammum solana to dipake duka' illaam kahajaam. Sapo' ma'paindam ia indo to dilappasam ingngena' lako indo solana sapulo bidä. Iya tappa nahopäi siaham anna natekkei napasindum naua: ‘Baja' siaham temo indo indammu!’ ");
INSERT INTO ptu_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Iya muoppä siaham dio olona indo solana anna mengkahumase-masei naua: ‘Sa'bahasam salapä' yolo säpäi' aka tontäm kubaja'na indo indangku.’ ");
INSERT INTO ptu_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Sapo' moka hi umpehingngii pengkahumase-masena indo solana, lambi' napopetahungkum di sampe nabaja' asam indo indanna. ");
INSERT INTO ptu_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Tappana naita ingganna sola senga'na indo pa'palakoanna, iya tä' deem pada sahäntä buana lako indo to ditä'gähhä', nasuhum le'ba' lako indo tomahaja anna natulasanni ingganna indo pa'pogau'na. ");
INSERT INTO ptu_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Iya napopetambai siaham tomahaja indo tau anna nauaanni: ‘Tau kadake punalako iko! Puhangko kupa'deiam asam indammu aka mengkahumase-maseko dio oloku, iya palla' di iko penabammu umpateem solamu. ");
INSERT INTO ptu_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Mannassa anna tä' iko muissam umbajuam penabammu! Kusanga hi kao la muissammi duka' ungkamasei solamu aka puhangko duka' kukamasei.’ ");
INSERT INTO ptu_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Tä' deem pada sakeaha' indo tomahaja, lambi' napopetahungkum sampe puha asam nabaja' indo indanna. ");
INSERT INTO ptu_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Dadi, la napateemmokoa' too duka' Ambeku yabo suhuga, ke tä'koa' duka' muampunni padammu sola sakalebu penabammu.” ");
INSERT INTO ptu_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Tappana puha ma'pa'guhu Puang Yesus, iya umpelleim lembäna Galilea anna le'ba' lakoi lembäna Yudea, sapo' muola dipe lambam libanna Salu Yordan. ");
INSERT INTO ptu_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Iya ma'silullu'um tau buda muula'i, lambi' napabonosam indo to masakinna. ");
INSERT INTO ptu_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Eta too deem sule sanaka-naka to illaam kakalebuanna Parisi maelo' la umpeängam tuntungam su'be' Puang Yesus lambi' nakutanai naua: “La situhu' daka peadasam ke untibei bainena mesa muane ia mammo anna ia napolalam?” ");
INSERT INTO ptu_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Sapo' natimba' Puang Yesus naua: “Tä' daka' tiko deem umbata illaam Battakada Debata diona indo anna umpadadii lino Debata Metampa, inna napasilolemmi muane anna baine? ");
INSERT INTO ptu_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Puhai napadadi, iya nauam: ‘Iam too anna mesa muane la umpellei indona sola ambena anna sialai mesa baine, nasuhum duai la mendadi mesa illaam ingganna-ingganna sia.’ ");
INSERT INTO ptu_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Dadi, tä'um la dua sapo' la mendadi mesam. Iam too kasuhunganna anna iai too puha napamesa Puang Allataala tä'um mala napasisähä' hupatau.” ");
INSERT INTO ptu_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Iya mekutana pole oom indo to illaam kakalebuanna Parisi naua: “Maka' susi, iya maaka hi anna napa'pahentaanni Musa diona la umpapia suha' kasisähäsam mesa muane anna nabeenni bainena kela natibei?” ");
INSERT INTO ptu_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Natimba' Puang Yesus naua: “Ia hi tia anna napäbäikoa' Musa untibe bainemu aka kamakahhasam penabammua'! Sapo' setonganna tä' tia susi indo pahandu'na. ");
INSERT INTO ptu_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Pehingngii manappaia' inde tula'ku temo kuua: menna-menna untibe bainena sulibanna ke ullullu'i muanena indo baine anna kebaine polei, tau ia too ullullu' pa'bannetauam.” ");
INSERT INTO ptu_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Iya nauam passikolanna: “Maka' susi kasilombunganna muane anna baine, iya aha pissammi tä' tau sipobaine.” ");
INSERT INTO ptu_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Natimba' Puang Yesus naua: “Tä' ia asanna tau la mala untahima inde tula', sapo' anggam indo to nasahum Puang Allataala la mala untahimai. ");
INSERT INTO ptu_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Anu' deem tau tä' la kebaine aka inna silolem illaam mai tambu'na indona. Anna deem tau tä' kebaine aka napasalaam tau senga'. Anna deem duka' tau gatti kalena bäbä aka naua: ‘Anna malaä' umpasatutu penabangku lako kapahentaanna suhuga.’ Menna-menna umbelai natahima inde tula'ku, la pahallu napaillaam penaba manappa.” ");
INSERT INTO ptu_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Pissam wattu sule sanaka-naka tau umbaba änä'na lako Puang Yesus aka naua anna mala naanda'i anna napa'sambajangam. Sapo' nakeaha'i hi passikolanna Puang Yesus indo tau. ");
INSERT INTO ptu_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Iya nauam Puang Yesus: “Päbäi mammi napellambi'iä' itim matim änä'-änä'. Daa ullabai, aka tau susim too itim matim la mendadi umma'na Puang Allataala illaam kapahentaanna.” ");
INSERT INTO ptu_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Anna mane naanda'i anna napa'sambajanganni, mane le'ba'i Puang Yesus. ");
INSERT INTO ptu_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Pissam wattu sule mesa muane umpellambi'i Puang Yesus anna nakutanai naua: “O Tuangguhu, pa'pogausam mapia aka la kupogau' anna malaä' ullambi' katuboam sule lako salako-lakona?” ");
INSERT INTO ptu_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Natimba' Puang Yesus naua: “Akanna ungkutanaiä' diona pa'pogausam mapia? Tä' deem moi podo la mesa tau mapia gau' sulibanna Puang Allataala. Maka' maelo'ko la untahima katuboam sule lako salako-lakona, tuhu'i manappako ingganna pahentana Puang Allataala.” ");
INSERT INTO ptu_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Iya mekutana pole oo indo tau naua: “Pahenta umba kabam muuaam?” Natimba' Puang Yesus naua: “Daa umpapateam, daa ullullu' pa'bannetauam, daa umpaboko, daa ussa'bi tatappa' lako padammu hupatau, ");
INSERT INTO ptu_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","pa'kasalleiko indomu sola ambemu, kamaseiko padammu hupatau umba susi ungkamasei kalemu.” ");
INSERT INTO ptu_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Iya natimba'um indo to mangnguha naua: “Kutuhu'i asammi pahenta ia too! Akapi senga'na la pahallu kupogau'?” ");
INSERT INTO ptu_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Iya nauam Puang Yesus: “Maka' maelo'ko la tepu kamanuhusammu, iya le'ba'ko balu' asam ingganna kullemu anna umbeenni to mase-mase allinna. Aka maka' umpateem, iya la muampuammoko too kulle yabo suhuga. Puhai too, sulengko pole' untuhu'ä'.” ");
INSERT INTO ptu_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Tappana nahingngi indo to mangnguha tula' ia too, iya le'ba' siaham masussa penabanna aka buda kullena. ");
INSERT INTO ptu_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Iya nauam Puang Yesus lako passikolanna: “Setongam-tonganna, tä' deem pada samapahhi' mesa to makaka la mendadi umma'na Puang Allataala illaam kapahentaanna. ");
INSERT INTO ptu_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Anna mane deenni kuua: madomi' leko'um ia mesa unta muola tama tottä'na dahum, anna la mesa to makaka la mentama kapahentaanna Puang Allataala.” ");
INSERT INTO ptu_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Tappana nahingngi passikolanna indo pa'tula'na Puang Yesus, iya sangngim mängä-mängä anna sipa'tula'-tula'i naua: “Maka' susi, iya la menna bäbä hi umbai' la mala dipasalama'?” ");
INSERT INTO ptu_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Iya umpaleleim mata passikolanna anna nauai: “Nakapusa'i ia hupatau diona to la mala dipasalama', sapo' tä' Ia Puang Allataala.” ");
INSERT INTO ptu_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Iya nauam Petrus: “Kitampeam asammi kami' aka-akangki aka kituhu'ko! Iya akam kami' la sahoki?” ");
INSERT INTO ptu_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Natimba' Puang Yesus naua: “Setongam-tonganna, illaam indo wattu la dipadadi pole ingganna-ingganna sia, Kao to disangai Änä' Mentolino la muokko'ä' yabo okkosam kahajaangku. Wattu etam too duka' ikoa' inde to sapulo dua pentuhu'ku la dipatadongkongkoa' yabo sapulo dua okkosam kahajaam, aka la umpahe'koa' indo pessubunna sapulo dua too'na to Israel. ");
INSERT INTO ptu_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Anna lako to untampeam banuanna, battu haka solasubunna, battu haka tomatuanna, battu haka änä'na, battu haka bela'na aka natuhu'ä', tau ia too la dibala'iam pessahatu' tiluppi' anna la dimana'pi katuboam sule lako salako-lakona. ");
INSERT INTO ptu_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Sapo' la deem too dadi ke dako'i buda to matande tentomai, la mendadi to madio, anna to madio tentomai la mendadi to matande.” ");
INSERT INTO ptu_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Sitahhu'na tula'na Puang Yesus naua: “Kapahentaanna Puang Allataala dipasihhapam issinna inde tulasam: Deem mesa to ma'bela' mebengngi'-bengngi' le'ba' umpeä tau la nasahoi, aka la napopengkähä illaam bela' anggurna. ");
INSERT INTO ptu_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Tappana silambi' to mosaho, iya sipa'tula'um lambi' kattu tula'na la nasahoi mesa doi' peha' sangngallo. Puhai, iya nasuam tama indo bela'na. ");
INSERT INTO ptu_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Umbai' la tette' kasehai mebengngi', iya le'ba' pole oom indo puäna bela' umpeä pole to mosaho. Iya muitam tau ma'saleo bäbä dio pasa'. ");
INSERT INTO ptu_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Iya nauaammi: ‘Laokoa' duka' pengkähängannä' lako bela'ku angku sahoikoa' la sipäto'na.’ ");
INSERT INTO ptu_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Iya le'ba'im duka' napengkähängam. Umbai' la tette' sapulo duai, iya le'ba' pole oom umpeä to mengkähä. Anna umbai' la tette' tallui kahubem, iya napateem oom. ");
INSERT INTO ptu_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Kiha-kiha la tette' limai kahubem, iya le'ba' pole boom. Iya ullambi' oom tau ma'saleo bäbä. Iya nauaammi: ‘Akanna etakoa' inde mesangngallo ma'saleo bäbä, tä' mengkähä?’ ");
INSERT INTO ptu_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Natimba'im indo tau naua: ‘Aka tä' kami' deem kiongei mosaho.’ Iya nauam indo puäna bela': ‘Lakokoa' bela'ku anna umpengkähängannä'.’ ");
INSERT INTO ptu_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Tappana lendu' allo, iya untambaim mando'na anna nauaanni: ‘Tambai asanni indo to mengkähä ammu beenni sahona. Popengkalao dioi indo to handam ibundi mentama sule lako indo to handam yolo.’ ");
INSERT INTO ptu_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Sulei indo to mentama kiha-kiha la tette' lima kahubem, iya nabeemmi sahona sandai si mesa doi' peha'. ");
INSERT INTO ptu_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Puha asanni dibeem indo solana, iya suleim duka' indo to handam yolo mentama. Iya nauaim illaam penabanna: ‘La buda puha too kami' kitahima aka kipesangngalloi kami' mengkähä.’ Sapo' angga hi duka' sanda si mesa doi' peha' dibeem. ");
INSERT INTO ptu_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Tappana dibeenni sahona, iya sileleim ia keaha'-aha' lako indo puäna bela' naua: ");
INSERT INTO ptu_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘Palla' dako iko umpasipadaam sahoki inde lako to anggam satette' mengkähä, moi kela daa mesangngallo bantahikam kami' nadä'dä' allo.’ ");
INSERT INTO ptu_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Sapo' naua indo puäna bela' lako indo mesa to mengkähä: ‘O solaku! Setonganna tä' kao deem kasalaangku. Tä' daka tia kattunna' tula'ta la ahu'ungkoa' disahoi mesa doi' peha' sangngallo? ");
INSERT INTO ptu_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Alaia' inde sahomu ammu le'ba'a' aka abana inna kuua la pada siam duka' kubeem inde lako to ibundi mentama. ");
INSERT INTO ptu_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Aka la tä' daka tia mala kao muäto' kulleku situhu' pa'elo'ku? Kembuhukoa' isanga aka kukamasei indo to handam ibundi mentama?’” ");
INSERT INTO ptu_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Mane naalai Puang Yesus pungngu' tannunna inde pehapangam naua: “La susim too lako tau to madio tentomai, la ia pole' matande ke dako'i. Anna lako tau to matande tentomai, la tä'um matande ke dako'i.” ");
INSERT INTO ptu_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Tappana illaanni pangngola-lalangam Puang Yesus la längäm Yerusalem, iya untambaim indo sapulo dua passikolanna napasähä' anna napa'tula'i naua: ");
INSERT INTO ptu_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Inde tentomai la längämmakia' Yerusalem. Yabokia' too, iya dibehomä' to disangai Änä' Mentolino lako ingganna kapala sando sola to ullatta' Pepaondonganna Musa anna la nakattu naua: ‘Pahallu la dipopepatei.’ ");
INSERT INTO ptu_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Anna la nabehoä' lako to tamuissam Puang Allataala aka la natelleä' anna nadahha lambi' napateiä' yabo kaju sitambem. Sapo' illaam allo katallunna la dipatibangonnä' sule.” ");
INSERT INTO ptu_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Puhai ia too, iya sulem bainena Zebedeus sola indo dua änä'na umpellambi'i Puang Yesus anna ma'balinguntu'i dio olona napasindum naua: “O Tuangguhu, kela mala anna untahimai inde pelauangku!” ");
INSERT INTO ptu_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Natimba' Puang Yesus naua: “Aka umpelau?” Iya nauam indo baine: “Kupelau kela mala anna umpadioi tandai kanammu mesa inde änä'ku anna umpadio tandai kaihimmu mesa, ke mendadi tomahajangko.” ");
INSERT INTO ptu_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Sapo' natimba' Puang Yesus naua: “Setonganna tä' muissanna' itim pelauammu. La untuaka' duka' umpendudum indo kamapi'disam la kupendudum?” Iya natimba'um naua: “Kitua!” ");
INSERT INTO ptu_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Natimba' pole oom Puang Yesus naua: “Tappa' tula'mu, abana la umpendudunna' duka' indo kamapi'disam la kupendudum. Sapo' anggam ia indo diona la muokko' dio tandai kanangku battu tandai kaihingku, taia Kao issangku. Aka ongeam ia too dipatokaam lako hupatau to puha napa'tantu Ambeku.” ");
INSERT INTO ptu_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Tappana naissanni indo to sapulopi passikolanna kaha-kaha ia too, iya tä' deem pada sakeaha' lako indo to dua to ma'solasubum. ");
INSERT INTO ptu_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Nasuhum natambai asam Puang Yesus anna napa'tula'i naua: “Muissanna' muua illaam inde lino ingganna to ma'pahenta umpake palu-palu bassi umpahenta pakketauanna, anna ingganna to kasallena umpalao makahha' kakuasaanna lako to nalumbäi. ");
INSERT INTO ptu_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Sapo' ikoa'-iko, tä'koa' la mala ma'pateem. Aka iai too maelo' la diangga' illaam alla'-alla'mua', iam too la umpopengkadio kalena dio olona solana sihhapam mesa sabua'. ");
INSERT INTO ptu_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Anna menna-menna maelo' la mendadi to kasalle, tau ia too la pahallu umpomahempo penabanna anna la ahu' dipakasua-sua. ");
INSERT INTO ptu_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Aka susimä' Kao to disangai Änä' Mentolino tä' suleä' la dipamoloi, sapo' suleä' la umpamoloi hupatau anna la ahu'pä' dipakattu sungnga', aka la ussolonnä' tau buda dio mai dosana anna malai lappa'.” ");
INSERT INTO ptu_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Tappana le'ba' Puang Yesus sola passikolanna umpellei kota Yerikho, iya ma'silullu' oom tau buda untuhu'i. ");
INSERT INTO ptu_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Wattu eta too deem dua to buta muokko' dio bihim lalam. Tappana nahingngi diua liu Puang Yesus, iya katamba-tambam naua: “O Tuam, peampoanna tomahaja Daud, kamaseikam kami'!” ");
INSERT INTO ptu_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Sapo' nakuapai hi tau buda naua: “Pengkamma'koa'!” Sapo' tuttuam napekasallei mandi metamba naua: “O Tuam, peampoanna tomahaja Daud, kamaseikam kami'!” ");
INSERT INTO ptu_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Iya tohhom Puang Yesus anna natambai mane nauaanni: “Aka umpohäe la kupogausangkoa'?” ");
INSERT INTO ptu_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Natimba' naua: “O Tuam, maelo' punalakam duka' la paita.” ");
INSERT INTO ptu_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Iya häntä siaham buana Puang Yesus muitai, lambi' nahakasam matanna. Iya bassim paita siaham sampe le'ba' duka' untuhu' Puang Yesus. ");
INSERT INTO ptu_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Tappana la umpenandai Yerusalem Puang Yesus sola passikolanna, iya lempä salapi dio Betfage, mesa tondä' dio Tanete Zaitun, mane ussuai dua passikolanna ");
INSERT INTO ptu_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","naua: “Le'ba'koa' lako dio tondä' tapenandaia'. Aka sulekoa' too lako, iya ullambi'unna' mesa keledai bihä disäke' sola änä'na. Bukkaia' anna umbabaam duaä' sule. ");
INSERT INTO ptu_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Anna maka' too deengkoa' ungkutanai naua: ‘Akanna mualaia'?’ iya la muuaanna': ‘Aka napahalluam Debata, anna la bale' dipasule siam sule.’” ");
INSERT INTO ptu_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Ia asanna ia too dadi anna mala sule lako indo kadanna Debata napalombum nabi naua: ");
INSERT INTO ptu_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Palandasannia' inde tula' lako issinna kota Sion muua: ‘Petua'ia' tomahajammu sule napellambi'iko, tä' deem pada samahempo penaba anna ussäkei mesa keledai. Ussäkei mesa keledai lundaha.’” ");
INSERT INTO ptu_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Iya le'ba'um duka' indo dua passikolanna anna napalako asanni pada indo napakahi'diam. ");
INSERT INTO ptu_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Naalam indo keledai sola änä'na anna le'ba'i nababaam. Sulei lako, muäläiim jubana anna nalapi'ianni, mane nasäkei Puang Yesus. ");
INSERT INTO ptu_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Wattu eta too buda tau muäläi jubana anna naampa'i lako lalam la naolanna Puang Yesus tanda pa'pakasallena. Anna buda toi duka' tau senga' ussäppe'i palapa andulam anna naampa'i duka' lako lalam. ");
INSERT INTO ptu_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Ingganna tau to ullahui, susi yolona teem ibundinna sikaahhe naua: “Tapujia' peampoanna tomahaja Daud! Katambasam to sule illaam sanganna Debata! Tapa'kasalleia' Puang Allataala To Handam Matande!” ");
INSERT INTO ptu_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Tappana mentamai kota Yerusalem Puang Yesus, iya gege' siaham issinna indo kota anna nauai: “Menna hia umbai' isanga?” ");
INSERT INTO ptu_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Iya natimba'im indo tau buda to ullahu lelem Puang Yesus naua: “Iam too inde diuaam Puang Yesus, mesa nabi buttu dio mai Nazaret mesa tondä' illaam lembäna Galilea.” ");
INSERT INTO ptu_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Puhai ia too, le'ba'um Puang Yesus tama pa'hanteanna Banua Debata. Sulei tama, iya ullambi'um to si balu'-balu' illaam. Tappa nasua siaham lao Puang Yesus anna napembalisannii mejana indo to si ussuka'i doi'na to buttu dio mai botto senga' anna usseham okkosanna to si umbalu' dangam-dangam. ");
INSERT INTO ptu_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Anna mane umpa'tula'i indo tau buda naua: “Deem tisuha' illaam Battakada Debata naua: ‘Banuangku la naongei hupatau ma'sambajam,’ sapo' umpadadi hia' iko pa'mesaanna pa'bulele kalasi anna pa'tombonganna to maboko allo.” ");
INSERT INTO ptu_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Iya suleim to buta sola to mate sapolona umpellambi'i Puang Yesus illaam indo Banua Debata lambi' napabono' asam. ");
INSERT INTO ptu_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Iya sangngim keaha'um indo kapala sando sola to ullatta' Pepaondonganna Musa tappana naita indo tanda memängä-mängä napadadi Puang Yesus. Anna keaha' toi muita indo änä'-änä' sikaahhe illaam Banua Debata naua: “Tapujiia' anna tapa'kasallei peampoanna tomahaja Daud!” ");
INSERT INTO ptu_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Nasuhum ma'kada lako Puang Yesus naua: “Tä' isanga uhhingngi tula'na inde lako änä'-änä'?” Natimba' Puang Yesus naua: “Kuhingngi. Sapo' tä' daka' tiko deem umbata illaam Battakada Debata naua: ‘O Debata, Iko umpatudu änä'-änä' sola änä'-änä' malea anna malai naissam untula' pampujiam matim olomu!’” ");
INSERT INTO ptu_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Puhai ia too, iya le'ba'um Puang Yesus umpellei indo tau buda anna lu lakoi mesa tondä' isanga Betania, anna etai ma'bengi. ");
INSERT INTO ptu_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Mebengngi'i, iya le'ba'um Puang Yesus sola passikolanna ma'pasule lako Yerusalem. Wattu eta too tadea' Puang Yesus. ");
INSERT INTO ptu_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Iya muitam satoo' ara dio ampe' lalam. Iya le'ba'um lako too'na, sapo' tä' deem buana, anggam paka daum bäbä nalambi'. Nasuhum napanata'i Puang Yesus naua: “Tä'ungko iko deem la kembua sampe matemu!” Iya malasso siaham lambi' mate. ");
INSERT INTO ptu_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Tappana naita passikolanna kadadiam ia too, iya tä' deem pada sanakapilla'i nasuhum ma'kada naua: “Maaka hia umbai' anna malai tappa mahekko' bäbä inde dio kaju ara?” ");
INSERT INTO ptu_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Iya nauam Puang Yesus: “Setongam-tonganna, assala'na deenna' kamatappasammu anna tä' tookoa' la bata-bata, malaa' duka' umpogau' inde kupogau' tentomai. Anna tä' angga mandi ia too la malaa' umpogau', sapo' la malapokoa' duka' ussua inde dio buntu mentieli' tama le'bo', anna tä' mala tala dadi. ");
INSERT INTO ptu_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Aka iai too umpelaua' längäm Puang Allataala sola ponno kapahhannuam, tä' mala tala naponnoiangkoa' indo pelauammu.” ");
INSERT INTO ptu_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Puhai ia too, iya tahhu'um Puang Yesus sola passikolanna tama Banua Debata. Tappana ma'pa'guhu illaam, iya sulem sanaka-naka kapala sando sola matua ulunna to Yahudi umpellambi'i anna nakutanai naua: “Aka isanga umpolalam anna umpogau'i inde mai ingganna pa'pogausam, anna menna umbeengko kakuasaam?” ");
INSERT INTO ptu_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Sapo' natimba'i Puang Yesus naua: “La kukutanaikoa' duka'! Maka' too muissanna' untimba'i, iya etapi too anna mane kutulasangkoa' duka' menna umbeennä' inde kakuasaam. ");
INSERT INTO ptu_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Menna umbeenni kakuasaam Yohanes anna si mantedo'i? Puang Allataala haka hupatau haka?” Iya sipa'tula'-tula'um naua: “Mapahhi' la ditimba'i, aka taua hia' manii: ‘Kakuasaanna Puang Allataala,’ iya la nauaammakia' too: ‘Akanna tä'ia' ungkatappa'i?’ ");
INSERT INTO ptu_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Iya la taua hia' manii: ‘Kakuasaanna hupatau,’ iya tä' ohi aka mahea' tau lako tau buda. Aka inde Yohanes nakatappa'i asam tau naua: ‘Abana mesa nabi.’” ");
INSERT INTO ptu_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Lambi' angga ham pentimba'na lako Puang Yesus naua: “Tä' kiissam la kitimba'i indo pekutanaammu.” Nasuhum naua Puang Yesus: “Maka' susi, iya tä' duka' kuaku la kutulasangkoa' menna umbeennä' kakuasaam nasuhum kupogau' kaha-kaha ia too.” ");
INSERT INTO ptu_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Iya umpalao oom mesa pehapangam Puang Yesus naua: “Maakaa' iko susi pikkihammu diona inde kaha-kaha: Deem mesa tau dua änä'na bassim änä' muanem. Indo tau le'ba' umpellambi'i indo änä' uluana anna nauaanni: ‘O änä'ku, laoko temo pengkähängki' lako bela' anggurta.’ ");
INSERT INTO ptu_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Sapo' natimba' naua: ‘Mokaä'.’ Puhai naua: ‘Mokaä',’ iya ussossom kalena anna mane le'ba' lako indo bela'na ambena anna mengkähäi. ");
INSERT INTO ptu_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Puhai umpa'tula'i indo änä' uluana, iya lu lako opi indo änä' tämpä'na anna nauaanni duka' umba susi indo tula'na lako änä' uluana. Natimba' indo änä' tämpä'na naua: ‘Io, lao hamä' ambe'.’ Sapo' dio bäbä pudu'na naua: ‘Io,’ aka tä' di le'ba'. ");
INSERT INTO ptu_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Dadi situhu' pikkihammua', mennanna kabam umpalako pa'elo'na ambena inde dua änä'?” Mentimba'im naua: “Indo änä' ulua.” Iya nauam Puang Yesus: “Tappa' pentimba'mua'. Sapo' setongam-tonganna, mendiolo leko'um ia tuam passima sola baine passunda' mendadi umma'na Puang Allataala illaam kapahentaanna anna la ikoa'. ");
INSERT INTO ptu_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Aka sule Yohanes to si mantedo' umpaitaikoa' lalam kamaloloam, iya moka hakoa' ungkatappa'i. Sapo' nakatappa'i leko' ia tuam passima sola baine passunda'. Moinna anna muitanna' matappa' indo to si diangga' kadake gau', sapo' moka siangkoa' iko muondo' gau'mu anna tä' ungkatappa'i indo tula'na.” ");
INSERT INTO ptu_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Mane umpalao oi mesa pehapangam Puang Yesus naua: “Deem mesa tau muampuam sangngenam litä' lo'bä. Pissam wattu natanannim anggur anna nabalai lao pali'. Puhai, umbo'bä'um pallullusam anggur mane umpake'de'i lempo batu la naongei to mangngampana. Puha asanni, iya napa'petesangammi anna mane le'ba' lako botto mambela. ");
INSERT INTO ptu_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Tappana naagiam la matäsä' indo bua anggurna, iya ussuam sanaka-naka sabua'na le'ba' umpellambi'i indo to mantesanna, aka la natahimaam bahena. ");
INSERT INTO ptu_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Sapo' tappana sulei lako, iya ke nasakka hia indo to mantesam. Deem natembe' puso, deem naleba'i batu, anna deem napatei. ");
INSERT INTO ptu_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Iya ussua pole oom sabua'na indo puäna bela', buda puha ia anna la indo yolona. Sapo' napateem pole oo duka'. ");
INSERT INTO ptu_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Katampasanna, ussua änä' ikalena aka naua inabanna: ‘Tä'um tia pole' la napatei inde änä'ku aka la nakalaja' di tia.’ ");
INSERT INTO ptu_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Sapo' naitanna indo to mantesam, iya sipattuju-tuju oom naua: ‘Iam too inde to la ullombum kullena tomatuanna. Tapateia' anna mala taalaa' inde bela'na.’ ");
INSERT INTO ptu_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Lambi' nasakka anna napa'tibeanni lako bihim bela' mane naula'i napatei. ");
INSERT INTO ptu_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Dadi, maka' sule indo puäna bela', iya aka umbai' la napogau' lako indo to mantesanna?” ");
INSERT INTO ptu_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Iya natimba'im indo kapala sando sola matua ulunna to Yahudi naua: “Mannassam tia anna la umpatei indo to kadake gau', mane napa'petesangam polei indo bela'na lako tau senga' to la si umbeenni tabana ke lambi' oom wattunna.” ");
INSERT INTO ptu_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Iya nauam Puang Yesus: “Tä' daka' tiko deem umbata illaam Battakada Debata naua: ‘Indo batu natibe tukam, ia leko' di diala dipobatu longkahhim. Kaha-kaha ia too mala dadi aka pa'pogau'na Debata, anna takamängä-mängäia' kita pa'pogausam ia too!’ ");
INSERT INTO ptu_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Iam too anna kutulasammokoa' kuua: Indo pangngalatabamua' illaam kapahentaanna Puang Allataala la naäläi sule anna la napalulakoanni tau senga' to untuhu'i pahentana lambi' ungkembuaam bua la sihatanna. ");
INSERT INTO ptu_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Anna menna-menna metobä dokko indo batu la huppu'-huppu' bukunna, anna menna-menna natappai indo batu la dahi kapu'.” ");
INSERT INTO ptu_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Tappana nahingngi kapala sando sola to illaam kakalebuanna Parisi indo pehapangam napalao Puang Yesus, iya silele pole' naua: “Kita hia' kita päläe' napasihim indo pehapanganna!” ");
INSERT INTO ptu_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Lambi' umpeäim pole' lalam la ussakka Puang Yesus, sapo' mahea' ohi lako tau buda aka inde Puang Yesus nasangai tau buda mesa nabi. ");
INSERT INTO ptu_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Mane napatahhu' oi tula'na Puang Yesus lako to kasallena to Yahudi sapo' nababa illaam liupi pehapangam naua: ");
INSERT INTO ptu_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Kapahentaanna Puang Allataala dipasihhapam issinna inde tula': Pissam wattu deem mesa tomahaja umpatoka asam bannena saha kakabenganna änä'na. ");
INSERT INTO ptu_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Toka asanni, iya ussuam sanaka-naka sabua'na lao untambai indo ingganna to puha diuaam la ungkadioi heem indo pa'hame-hameanna änä'na. Sapo' mokai hi sule ullombai. ");
INSERT INTO ptu_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Iya ussua pole oom sabua' senga'na napasindum napakahi'di naua: ‘Tulasam manappai indo ingganna to ditambai muua: toka asammi ade' indo la dipa'tahiaam! Puha asammi natunu ingganna indo sapim malompona anna ingganna senga'-senga'na toka asammi. Maingkoa' ade' talako pa'pakabem!’ ");
INSERT INTO ptu_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Sapo' ma'lembe-lembei mandi indo to puha diuaam. Piha lu lako bela'na anna piha lu lako pengkähängam senga'na. ");
INSERT INTO ptu_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Anna deem piha ussakka indo sabua'na tomahaja lambi' nadahha anna deem napatei. ");
INSERT INTO ptu_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Tappana naissam tomahaja indo kadadiam ia too, iya tä' deem pada sakeaha' lambi' ussua sohodadunna anna le'ba'i umpatei indo to papateam anna mane nasobe kotana. ");
INSERT INTO ptu_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Puhai ia too, iya untambai oom sabua' senga'na anna nauaanni: ‘Toka asammi ingganna indo la dipakena illaam inde pa'pakabengam, sapo' indo to ditambai tä' ia sihatam la sule ullombai. ");
INSERT INTO ptu_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Dadi, la lu lakokoa' lalam mahoa' anna iai too liu ianna' untambai sule ullombai inde pa'pakabengam.’ ");
INSERT INTO ptu_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Iya mengkalao siaham ingganna indo sabua'na anna untambai asanni tau pada naitanna lako lalam. Susi to mapia gau' teem to kadake gau', sampe ponno tosabe indo ongeam diongei ma'hame-hame. ");
INSERT INTO ptu_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Sule asanni tau, iya le'ba'um tama indo tomahaja untammui tosabena. Sapo' sulei tama, iya muitam mesa tau tä' ia ma'poheba kakabengam. ");
INSERT INTO ptu_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Iya nauam indo tomahaja lako indo tau: ‘O solasubum, akanna suleko duka' ke tä'ko ma'poheba kakabengam?’ Sapo' kanonnä mandi indo tau. ");
INSERT INTO ptu_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Iya muuaammi sabua'na indo tomahaja: ‘Pungoia' inde dio tau anna untibeia' tama indo ongeam handam malillim anna illaanni sumahho lumoa' sikekko' isinna tamate tatubo.’” ");
INSERT INTO ptu_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Anna mane naala Puang Yesus pungngu' tannunna indo pehapangam naua: “Buda tau natambai Puang Allataala, sapo' saidi' napilei la mendadi umma'na.” ");
INSERT INTO ptu_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Puhai ia too, iya le'ba'im indo to illaam kakalebuanna Parisi sipattuju-tuju la naaka susi ungkutanai Puang Yesus aka napeä lalanna anna malai napetidom. ");
INSERT INTO ptu_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Kattui tula'na, iya ussuam sanaka-naka pentuhu'na sola sanaka-naka to muundu'i tomahaja Herodes umbaba mesa pekutanaam lako Puang Yesus. Sulei lako, iya untede-tedem yolo Puang Yesus naua: “O Tuangguhu, kiissam kiua mesako to umpake tappa' anna sindoho anna anggako umpepatuduam ulalanna Puang Allataala sola undu' lollä. Moi Iko menna tala ungkalaja'i aka umpapada-pada bäbäko hupatau. ");
INSERT INTO ptu_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Iam too anna kipelaum kiua kela mala anna untulasangkam issi penabammu. Situhu' peadasam tapendudunna', la sipäto' dakika' umbaja' sima lako tomahaja dio Roma, la tä' daka?” ");
INSERT INTO ptu_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Sapo' nalosa Puang Yesus pattuju kadakena lambi' ma'kada naua: “Oa' to ma'pudu' pandem anna ma'lila manähä, akanna umpalilingannä' tangnga'? ");
INSERT INTO ptu_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Paitaipä' mesa indo doi' si dipake umbaja' sima.” Iya mualam mesa doi' peha' anna nabeenni. ");
INSERT INTO ptu_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Iya mekutanam Puang Yesus naua: “Menna kegamba' anna menna kesanga inde dio doi'?” ");
INSERT INTO ptu_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Iya natimba'im naua: “Gamba'na anna sanganna tomahaja dio Roma.” Iya nauam Puang Yesus: “Maka' susi, iya beennia' tabana tomahaja dio Roma la sipäto'na umbeem, anna beennia' duka' Puang Allataala la sipäto'na umbeem.” ");
INSERT INTO ptu_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Nahingnginna indo to illaam kakalebuanna Parisi pentimba'na, tappa pilla' asam anna mängä-mängä, lambi' le'ba'i bäbä umpellei Puang Yesus. ");
INSERT INTO ptu_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Allo eta siam too duka' anna sulei sanaka-naka to illaam kakalebuanna Saduki battu diua to tä' ungkatappa'i katuboanna sule to mate umpellambi'i Puang Yesus, anna nakutanai naua: ");
INSERT INTO ptu_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“O Tuangguhu puham napaondom Musa naua: ‘Maka' deem mesa muane mate anna tä'i deem änä'na, iya indo bainena pahallu la napobaine solasubunna indo to mate, anna mala deem pessubunna.’ ");
INSERT INTO ptu_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Iya la maakam ia susi indee, aka pissam wattu deem pitu muane ma'solasubum. Uhuna kebaine indo handam ulua. Sapo' tä'pi deem änä' nasibalii indo bainena anna matem indo muane, nasuhum napembala' huntunna umpobaine indo baine. ");
INSERT INTO ptu_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Iya tä'pi keänä' anna mate pole boom duka' indo to umpembala' kakanna. Iya napobaine pole boom indo huntunna sapo' susi asam sule lako kapitunna. ");
INSERT INTO ptu_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Katampasanna mate duka' indo baine. ");
INSERT INTO ptu_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Dadi, maka' lambi'um wattunna la tubo sule to mate, iya mennannam kabam la napomuane indo baine, aka bali asam di napomuane pada indo to ma'solasubum.” ");
INSERT INTO ptu_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Natimba' Puang Yesus naua: “Abana si'da hi tia la muuaa' aka bulingkoa'. Aka tä'koa' muissam manappa kalembasanna Battakada Debata anna tuli tamuissangkoa' ia kakuasaanna Puang Allataala. ");
INSERT INTO ptu_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Aka susi hia' tia inde ä: maka' too lambi'um wattunna la tibangom sule to mate, iya tä'um tia deem to la siala anna tä' toi deem to la ma'pasiala. Sapo' umba susi katuboanna malaika' yabo suhuga tä' kemuane tä' kebaine, la susim too duka' hupatau. ");
INSERT INTO ptu_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Tä' paka' tiko deem umbata indo puha natula' loppo' Puang Allataala diona katibangonganna sule to mate, indo naua: ");
INSERT INTO ptu_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Kaom too inde Puang Allataala to napenombai Abraham, Ishak, anna Yakub’? Dadi moinna anna puham mate indo to tallu, sapo' mannassa anna tuboi temo aka anggam to tubo mala umpenombai Puang Allataala.” ");
INSERT INTO ptu_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Tappana nahingngi tau buda indo tula'na, iya tä' deem pada sanakapilla'i indo pepa'guhuanna. ");
INSERT INTO ptu_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Tappana naissam to illaam kakalebuanna Parisi naua umpopa'luttu' to illaam kakalebuanna Saduki Puang Yesus, iya ma'hempummi umpeä pole lalam. ");
INSERT INTO ptu_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Iya mekutanam mesa to ullatta' Pepaondonganna Musa lako Puang Yesus aka maelo' la napetidom naua: ");
INSERT INTO ptu_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“O Tuangguhu, umbanna handam pahallu la dipa'kasallei pada indo Pepaondonganna Musa?” ");
INSERT INTO ptu_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Natimba' Puang Yesus naua: “Kamaseikoa' Debata, Puang Allataala to umpenombai sola sakalebu penabammu anna mentu' pikkihammu. ");
INSERT INTO ptu_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Iam too inde handam too'na pahenta. ");
INSERT INTO ptu_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Anna pahenta kaduanna susi siam indo uhuna naua: ‘Kamaseikoa' padammu hupatau umba susi ungkamasei kalemu.’ ");
INSERT INTO ptu_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Iam too inde dua pahenta, pungngu' tannunna issinna Pepaondonganna Musa anna suha'na ingganna nabi.” ");
INSERT INTO ptu_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Mahassanni siapi ma'hempum to illaam kakalebuanna Parisi anna nakutanaim Puang Yesus naua: ");
INSERT INTO ptu_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Maakaa' iko susi pikkihammu diona indo To nalanti' Puang Allataala la mepasalama'? Menna kepessubum?” Iya natimba'im to illaam kakalebuanna Parisi naua: “Peampoanna tomahaja Daud.” ");
INSERT INTO ptu_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Iya nauam Puang Yesus: “Maka' susi, iya maaka hi anna nasangai tomahaja Daud ‘Debatangku,’ indo To dilanti' la mepasalama' wattunna anna nasahunni Penaba Maseho Daud? Aka naua Daud eta too: ");
INSERT INTO ptu_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Ma'kada Puang Allataala lako Debatangku naua: Okko'ko dio tandai kanangku sule lako wattunna la kupopa'bukku ingganna balimmu dio olomu lambi' uhhondoi dokko.’ ");
INSERT INTO ptu_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Dadi makaleso anna ma'kalei tomahaja Daud muuai: ‘Debatangku To nalanti' Puang Allataala.’ Iya maaka hi susi anna la ia ohi umpoampoi?” ");
INSERT INTO ptu_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Sapo' sangngim ma'luttu' mandi indo to illaam kakalebuanna Parisi. Allo etam too anna napahandu'i tä'um deem tau moi podo la mesam bahani mekutana pole lako Puang Yesus. ");
INSERT INTO ptu_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Puhai ia too, iya ma'kadam Puang Yesus lako tau buda anna lako passikolanna naua: ");
INSERT INTO ptu_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Indo to ullatta' Pepaondonganna Musa anna to illaam kakalebuanna Parisi dibeem kakuasaam la umpepa'guhuam Pepaondonganna Musa. ");
INSERT INTO ptu_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Dadi pahallukoa' la untuhu'i ingganna indo pepa'guhuanna. Sapo' ia hia, daa untuhu'i pa'palakoanna aka tä' sihondoi indo pepa'guhuanna anna pa'palakoanna. ");
INSERT INTO ptu_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Aka si umpapia pahenta mabanda' illaam peadasam anna umpadudunnii hupatau. Sapo' tä' punala deem la naaku umpamoloi hupatau, moi la sai'di'um, anna mala nabela napalako indo pahenta. ");
INSERT INTO ptu_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Napogau' indo ingganna pa'palakoanna aka naua: ‘Anna malaä' naita tau.’ Si naägä'i lelem umpakasalle pa'pongngeam Battakada Debata indo si nasäke' yabo kidena anna napakalando puha ia hombe-hombe tähämpä' jubana anna la indo biasanna. ");
INSERT INTO ptu_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Anna si umpise'i ongeam dipa'kasalleinna ke illaanni pa'hame-hameam, anna moka toi muokko' illaam pa'sambajangam ke tä'i dio olo. ");
INSERT INTO ptu_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Anggam anna si napohäei ke napa'kasallei hupatau illaam pasa', anna manggi' toi si diuaam ‘Tuangguhu.’ ");
INSERT INTO ptu_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Sapo' ikoa'-iko, daa umpäbäi solamu la nauaangko: ‘Tuangguhu,’ aka anggam mesa Tuangguhummu, anu' pada-padakoa' sangngim to ma'solasubum. ");
INSERT INTO ptu_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Anna tä' tookoa' la muuaam solamu ‘Ambe',’ aka anggam mesa Ambemu yabo suhuga. ");
INSERT INTO ptu_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Anna daa umpäbäi solamu la nauaangko: ‘to mampahe',’ aka anggam mesa To mampahe'mua', iam too indo To dilanti' la mepasalama'. ");
INSERT INTO ptu_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Iai too maelo' la handam diangga' illaam alla'-alla'mua', iam too la umpopengkadio kalena dio olona solana sihhapam mesa sabua'. ");
INSERT INTO ptu_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Menna-menna ussanga-sanga kalena la dipomahempo, sapo' menna-menna umpopengkadio kalena la dipomatande.” ");
INSERT INTO ptu_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“La ullambi'koa' iko katilakaam inggannakoa' to ullatta' Pepaondonganna Musa anna to illaam kakalebuanna Parisi, o inggannakoa' to ma'dua tambu' anna ma'tallu sumusu! Aka untutusangkoa' lalam hupatau la tinanda tama kapahentaanna Puang Allataala. Mokakoa' iko tama anna ullabai tookoa' duka' hupatau to la maelo' mentama. ");
INSERT INTO ptu_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","La ullambi'koa' iko katilakaam inggannakoa' to ullatta' Pepaondonganna Musa anna to illaam kakalebuanna Parisi, o inggannakoa' to ma'dua tambu' anna ma'tallu sumusu! Aka si umpamasingangkoa' tula' to balu-balu baine, lambi' sule lako banuanna si mualaa'. Si muägä'ia' umpakalando sambajammu aka muuaa' anna malaä' nauaam tau: ‘Tau mapia,’ anna ke tau kadake hakoa' iko. Nasuhum la nalambi'koa' pesämbä' mabanda'na Debata. ");
INSERT INTO ptu_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","La ullambi'koa' iko katilakaam inggannakoa' to ullatta' Pepaondonganna Musa anna to illaam kakalebuanna Parisi, o inggannakoa' to ma'dua tambu' anna ma'tallu sumusu! Aka ussambaikoa' lino umpeä hupatau la umpalutama peadasammua', moi la anggam mesa untuhu'koa', la ahu' tookoa'. Sapo' tappana sola peadasangkoa', iya umpadadinna' bannena nahaka aka penduam tiluppi'um ia pole' kakadakeanna ke dipasiitakoa'. ");
INSERT INTO ptu_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","La ullambi'koa' iko katilakaam inggannakoa' to pebaba sihhapam to buta. Aka muuaam dakoa' hupatau: ‘Tä'koa' nasäke' tula'mu ke umpa'pindaikoa' Banua Debata, anggam nasäke'koa' ke umpa'pindai indo pangkakka' bulabam illaanna.’ ");
INSERT INTO ptu_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Oa' to maho anna to buta pikkiham! Ussanga hia' iko keangga' puha ia indo pangkakka' bulabam anna la indo Banua Debata, moi kela daa indo hi tia Banua Debata umpomasehoi indo pangkakka' bulabam illaam! ");
INSERT INTO ptu_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Anna si muuapia' liu: ‘Tä'koa' nasäke' tula'mu ke umpa'pindaikoa' ongeam pehumalasam, anggam nasäke'koa' ke umpa'pindai indo bua pemala' yabo ongeam pehumalasam.’ ");
INSERT INTO ptu_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Oa' to buta pikkiham! Ussanga hia' iko keangga' puha ia indo bua pemala' anna la indo ongeam pehumalasam, moi kela daa indo hi tia ongeam pehumalasam umpomasehoi indo bua pemala' yabona! ");
INSERT INTO ptu_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Dadi menna-menna umpa'pindai ongeam pehumalasam, tau ia too umpa'pindai duka' indo bua pemala' yabona indo ongeam pehumalasam. ");
INSERT INTO ptu_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Anna menna-menna umpa'pindai Banua Debata, tau ia too umpa'pindai duka' Puang Allataala to tohho illaanna. ");
INSERT INTO ptu_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Anna menna-menna umpa'pindai suhuga, tau ia too umpa'pindai duka' okkosam kahajaanna Puang Allataala anna umpa'pindai polepi duka' Puang Allataala to untadongkonnii okkosam ia too. ");
INSERT INTO ptu_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","La ullambi'koa' iko katilakaam inggannakoa' to ullatta' Pepaondonganna Musa anna to illaam kakalebuanna Parisi, o inggannakoa' to ma'dua tambu' anna ma'tallu sumusu! Aka ikoa'-iko umpa'kasallei leko'a' ia kaha-kaha bahinni' susinna umpatamaa' peadasammu bahe sapulona hampa-hampa indo si tubo bäbä isanga selasih, adas matannim, anna jintan. Sapo' indo handam pahallunna la dipalako si'da-si'da illaam Pepaondonganna Musa, ia leko'unna' tä' umpalako, susinna undu' lollä anna pa'kamase lako padammu, anna kamanontongam längäm Puang Allataala. Moi kela daa iam too inde handam pahallua' la umpalako. Sapo' tä' sianna' duka' la umpa'kalembei indo senga'na. ");
INSERT INTO ptu_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Oa' to pebaba buta! Umbanna' iko naola pikkihammu anna muäläi leko'a' ia indo kasisi' illaam ihusammu, anna muamma' kalebua' ia indo unta pada tonggo illaam! ");
INSERT INTO ptu_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","La ullambi'koa' iko katilakaam inggannakoa' to ullatta' Pepaondonganna Musa anna to illaam kakalebuanna Parisi, o inggannakoa' to ma'dua tambu' anna ma'tallu sumusu! Aka sihhapangkoa' to umbasei tangkihi' anna pihim, nabasei leko' sulibanna anna tä' ia hoäna. Anna hoäna hi naponnoi kakadakeam. Susingkoa' too aka naponnoikoa' kakadakeanna indo pangngala kahha'mua' anna indo pa'podo kaoammua'. ");
INSERT INTO ptu_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","O inggannakoa' to illaam Parisi to buta di ada', bahassiia' yolo illaam hoäna tangkihi'mu sola pihimmu, aka la bahassim tia duka' sulibanna. ");
INSERT INTO ptu_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","La ullambi'koa' iko katilakaam inggannakoa' to ullatta' Pepaondonganna Musa anna to illaam kakalebuanna Parisi, o inggannakoa' to ma'dua tambu' anna ma'tallu sumusu! Aka sihhapangkoa' ku'bu' dipamillo' sulibanna lambi' mapi'dä' diita, sapo' illaanna ponno buku hekko' sola kabubosiam. ");
INSERT INTO ptu_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Susi liungkoa' too, maka' diitakoa' mato-mato tau mapiakoa' sapo' setonganna to ma'dua tambu' dakoa' anna ponnoa' penabammu kakadakeam. ");
INSERT INTO ptu_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","La ullambi'koa' iko katilakaam inggannakoa' to ullatta' Pepaondonganna Musa anna to illaam kakalebuanna Parisi, o inggannakoa' to ma'dua tambu' anna ma'tallu sumusu! Aka umpapiaammia' pole' ku'bu'na ingganna indo nabi yolona anna umpomapi'dä' tookoa' ku'bu'na indo to meada' yolona. ");
INSERT INTO ptu_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Anna mane si muua lelenna': ‘Kela kilambi'um indo nene to kiponene yolona, inna tä' sia la kiaku sola umpatei indo nabi.’ ");
INSERT INTO ptu_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Dadi maka' susi, iya iko sianna' tia isanga ma'kale muuai: ‘Kami'um too pessubunna indo to umpatei nabi.’ ");
INSERT INTO ptu_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Iya pasule lakonna' indo pa'pogausanna nene to umponene yolona umpogau' dosa. ");
INSERT INTO ptu_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","O inggannakoa' to si mambaba bulim, pessubunna to kadake gau'! Tä'um deem lalanna la messubungkoa' illaam mai pa'tahungkungam, aka abana inna la bannenakoa' nahaka! ");
INSERT INTO ptu_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Pehingngii manappaia' inde tula'ku: la kusua sule sanaka-naka nabi, to manähä, anna tuangguhu la umpellambi'ikoa'. Sapo' deenna' la umpatei, deenna' la umpäso' yabo kaju sitambem, deem toi la untembe'a' illaam pa'sambajangammu, anna deem piha la umpadondoa' lako kota senga' anna undahhaia'. ");
INSERT INTO ptu_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Nasuhum illaam ia too la ditahungkum pättä'koa' aka umpateikoa' tau tä' deem kasalaanna, mengkalao dio Habel napatei nene to umponene sule lako Zakharia indo änä'na Berekhya to napatei illaam alla'na Banua Debata anna ongeam pehumalasam. ");
INSERT INTO ptu_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Setongam-tonganna, ia asanna ia too la umpendudunna' inde to tubokoa' lapi' temo.” ");
INSERT INTO ptu_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“O inggannakoa' issinna kota Yerusalem! Palla' dia' iko penabammu umpatei buda nabi anna ulleba'ia' batu sampe mate to nasua Puang Allataala umpellambi'ikoa'. Si kunaba-naba liu la kuhempungkoa' sihhapam änä' mäne' napakumbäi pani'na indona, sapo' mokakoa'. ");
INSERT INTO ptu_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Patananniia' talinga inde tula'ku anna umpaillaam penabai: la natampeammi Puang Allataala tadongkongammua' lambi' la maitu-itu. ");
INSERT INTO ptu_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Kutulasangkoa', mengkalao temo, tä'mä' deem la muita pole sule lako wattunna suleä' sule lambi' muuaa': ‘Katambasam indo To sule illaam sanganna Debata!’” ");
INSERT INTO ptu_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Puhai ia too, messubummi Puang Yesus illaam mai Banua Debata. La napelleii, iya napengkahuku'im passikolanna anna nauai: “O Tuangguhu, petua' siai too inde lako banua illaam pa'hanteanna Banua Debata.” ");
INSERT INTO ptu_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Iya nauam Puang Yesus: “Ungkaleso asam daka' inde lako banua? Setongam-tonganna tä' deem moi podo la mesa batu la tiäto' liu sitodo' solana aka pissam wattu la ditaleam asam.” ");
INSERT INTO ptu_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Tappana muokko' Puang Yesus yabo Tanete Zaitun sulena lako, iya napengkahuku'im passikolanna anna nakutanai paka-paka ia naua: “O Tuangguhu, tulasampakam piham la dadi ingganna indo puha untula' ingngena'? Aka la tandana kela sulengko anna la kapuhaanna lino?” ");
INSERT INTO ptu_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Natimba' Puang Yesus naua: “Majagakoa' indana deenni tau la umbaba bulingkoa'! ");
INSERT INTO ptu_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Aka la buda too tau sule umboko sangangku anna la buda tau nababa bulim aka la naua: ‘Kaom too inde To nalanti' Puang Allataala.’ ");
INSERT INTO ptu_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Maka' too uhhingngingkoa' ahhena to sipate-patei anna kahebanna to sibundu'-bundu', iya tä'koa' too la mahea' aka abana hi tia inna la dadi kaha-kaha ia too, sapo' taiapi indo allo ma'katampasanna. ");
INSERT INTO ptu_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Aka la sipate-patei hupatau anna kahajaam pada kahajaam la sibundu'-bundu'. Anna umba-umba ngei ongeam la kende' kakobeam anna la dadi lino' kasalle. ");
INSERT INTO ptu_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Sapo' ia asanna ia too mane pa'pahandusanna kamapi'disam sihhapam mesa baine mane mahassam mangnguhiba'. ");
INSERT INTO ptu_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Wattu eta too, la disakkakoa' anna dibehokoa' lako to la undahhakoa' lambi' dipateikoa'. Anna la nakabassikoa' ingganna hupatau illaam inde lino aka untuhu'iä'. ");
INSERT INTO ptu_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Wattu eta too buda pentuhu'ku la ma'soho boko' lambi' la umpebeem solana didahha anna la sikabassi-bassi paka ia. ");
INSERT INTO ptu_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","La buda too kende' to ussangai kalena nabi sapo' setonganna taia nabi. Anna buda tau la nababa bulim. ");
INSERT INTO ptu_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","La tuttuam membea' gau' kadake, nasuhum buda hupatau la tuttuam tikuhu' pa'kamasena. ");
INSERT INTO ptu_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Sapo' iai too mentobe manda' anna mengnganti matoto' illaam kamatappasam lako kaleku sule lako ma'katampasanna, tau iam too la dipasalama'. ");
INSERT INTO ptu_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Anna inde Kaheba Katilallasam diona la ma'pahentam Puang Allataala, la dipaissanni asam yolo hupatau illaam inde lino. Puhai too, mane sule hi indo allo ma'katampasanna. ");
INSERT INTO ptu_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","La muitakoa' too indo ‘To ungkähä kakadakeam la metallangam,’ ke'de' illaam indo ongeam maseho. Kaha-kaha ia too puha napayolo lambam nabi Daniel yolona. (Inde kada la pahallu napasalui manappa penabanna to mambata.) ");
INSERT INTO ptu_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Wattu eta too ingganna indo to dio Yudea pahallu la sikalumpa' längäm tanete, ");
INSERT INTO ptu_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","anna to sulibam banua tä'um la tama banua muala pahuhunna, ");
INSERT INTO ptu_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","anna to mahassam dio bela'na tä'um la ma'pasule lako banuanna muala pohebana, anna mala masimpam muäläi kalena le'ba' umpellei indo kamasussaam. ");
INSERT INTO ptu_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Tä' ia deem pada samasussa lako baine to mahassam kebättä anna to ma'pasusu. ");
INSERT INTO ptu_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Pa'sambajangkoa' anna mala tä' dadi indo kadadiam ia too illaam wattu palauham battu haka allo Katohhoam. ");
INSERT INTO ptu_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Aka wattu eta too la kende' pi'di' tanggana-gana. Pi'di' susi ia too tä'pi deem nasi'dim hupatau mengkalao dio mai pa'pahandusanna inde lino sule lako temo. Sapo' lessu'i too, iya tä'um deem la kende' pole pi'di' susi. ");
INSERT INTO ptu_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Aka maka' hapanna la masäe wattunna mane napamondai Puang Allataala kaha-kaha ia too, iya tä'um deem la tubo hupatau moi podo la mesa. Sapo' kahana pa'kamasena lako hupatau to puha napilei, nasuhum la bale' napamonda kamasussaam ia too. ");
INSERT INTO ptu_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Mane deenni, maka' too deem tau muuaangkoa': ‘Indem indo To nalanti' Puang Allataala!’ battu haka naua: ‘Dionnä!’ iya tä' la umpehingngiia'. ");
INSERT INTO ptu_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Aka la buda too tau naägä'i naua: ‘Kaom too indo To nalanti' Puang Allataala.’ Anna deem toi la muuai: ‘Kaom too mesa nabi.’ Anna indo tau la deem duka' pa'pogausam mepilla'-pilla' napadadi anna tanda memängä-mängä, aka naua pattujunna: ‘Umba ke deenni tau to puha dipilei kubaba bulim.’ ");
INSERT INTO ptu_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Pengkilalai manappaia', aka puhangkoa' kupayolo lambangam kaha-kaha ia too. ");
INSERT INTO ptu_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Anna maka' too deem tau muuaangkoa': ‘Petua'i, dio pohiallasam indo To nalanti' Puang Allataala,’ iya tä'koa' la lako. Anna maka' deem tau muuaangkoa': ‘Illaam tambim,’ daa umpehingngii. ");
INSERT INTO ptu_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Aka kasuleangku to disangai Änä' Mentolino la naissam asam ingganna hupatau, aka la sihhapam liu tikiäna kila' mengkalao illaam mata allo sule sau' katampusam pangkähhäna. ");
INSERT INTO ptu_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Umba-umba naongei bakke, etam too duka' naongei dassi peande bakke ma'tombom.” ");
INSERT INTO ptu_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Puhai too indo kamasussaam, iya la pi'de mata allo anna tä'um la paindo bulam, anna la honno'i yabo mai langi' bintä anna ingganna issinna langi' la titehha' bäbä. ");
INSERT INTO ptu_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Anna mane naita hupatau tanda kasuleangku to disangai Änä' Mentolino yabo langi' lambi' la sikauhhu' ingganna hupatau ussahhoi kalena. Anna wattu eta too la naita hupatau inde Änä' Mentolino tuhum yabo mai langi' umpehhondoi gabum naponnoi kamatandeam taditondom anna naponnoi toi kakuasaam. ");
INSERT INTO ptu_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","La diponi mesa sangkakala kasalle anna la ussuaä' ingganna malaika'ku lao nahempungannä' ingganna hupatau to puha kupilei illaam inde lino mengkalao illaam mata allo sule sau' katampusam. ");
INSERT INTO ptu_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Diona kaha-kaha ia too, mala diala pehapangam dio mai mesa kaju ara. Maka' too mukku'um tähe'na anna kendaum händäm, iya la muissammia' too muua la bale' sulem kulla' kalando. ");
INSERT INTO ptu_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","La susim too ke muitanna' dadi asam indo puha kutulasangkoa', iya la muissammia' too duka' muua la bale' sule lakom indo pattujunna Puang Allataala. ");
INSERT INTO ptu_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Setongam-tonganna, ingganna kaha-kaha ia too la dadi yolo anna mane mate asam ingganna to tubo lapi' temo. ");
INSERT INTO ptu_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Langi' anna lino la pa'de ke dako'i, sapo' kadangku ia, la da'da' liu sule lako salako-lakona.” ");
INSERT INTO ptu_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Sapo' setonganna tä' deem moi podo la mesa tau muissanni wattunna kaha-kaha ia too. Moi malaika' yabo suhuga tala naissanni, moi Änä'na Puang Allataala, anggam mesa-mesanna Ambeku yabo suhuga muissanni. ");
INSERT INTO ptu_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Aka umba susi dadi indo anna wattunnai Nuh, la susim too duka' kasuleangku to disangai Änä' Mentolino. ");
INSERT INTO ptu_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Wattunna anna tä'pi bussu uwai, ingganna hupatau illaam inde lino ma'masannam-sannam mangngande mangngihu', siala-ala, anna ma'pasiala sule lako wattunna mentama kappala' Nuh. ");
INSERT INTO ptu_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Tappana nabussui uwai mane kilala hi pole' aka uhhuai. La susim too duka' kasuleangku to si disangai Änä' Mentolino. ");
INSERT INTO ptu_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Aka maka' deem dua muane mahassam mengkähä dio bela'na anna suleä', iya mesa la dipasola lao anna mesa la dipatohho. ");
INSERT INTO ptu_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Battu haka deem dua baine mahassam manggilim, mesa la dipasola lao anna mesa la dipatohho. ");
INSERT INTO ptu_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Dadi, iam too anna la majagangkoa' aka tä' la muissanna' wattunna kasuleanna Debatammu. ");
INSERT INTO ptu_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Penabaam siaia' too, maka' hapanna la naissam to ma'banua wattunna la sule to maboko, mannassam tia anna tä'i la mamma' anna mala tä' tama banuanna indo to maboko. ");
INSERT INTO ptu_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Iam too anna la pahallungkoa' duka' majaga liu, aka indo kasuleangku to disangai Änä' Mentolino tä' la umbai-baia'.” ");
INSERT INTO ptu_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Anna mane naua Puang Yesus: “La pahallukoa' sihhapam mesa sabua' manuhu' anna keaka' to naäkä' puäna mendadi punggabana ingganna solana, nasuhum ia la si untabaam kinande solana ke lambi' oom wattunna. ");
INSERT INTO ptu_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Kehongko' anna maupa' lako indo sabua' ke tontä liui manontom umpalako manappa pengkähänganna nalambi' puäna ke ma'pasulem. ");
INSERT INTO ptu_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Setongam-tonganna, tä' mala tala naäkä' puäna sabua' ia too la nalima'iam ingganna kullena. ");
INSERT INTO ptu_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Sapo' maka' kadake gau' indo sabua', iya la nauam too illaam penabanna: ‘Masäepi mane sulei puäku,’ ");
INSERT INTO ptu_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","lambi' umpongkoim solana anna mangngande mangngihu'i sola to si umpamäbo' kalena. ");
INSERT INTO ptu_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Pissananna tappa sule säkä-säkä ham indo puäna illaam wattu tadibai-bai. ");
INSERT INTO ptu_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Sulena, naala siaham indo sabua'na anna nadahhai napaambi' mate, mane napa'tibeanni tama ongeanna to ma'dua tambu', anna illaanni sumahho lumoa' sikekko' isinna tamate tatubo.” ");
INSERT INTO ptu_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Anna mane naua Puang Yesus: “Maka' lambi'um wattunna umpalako kapahentaanna Puang Allataala, la sihhapam issinna inde tulasam naua: Deem sapulo änä' daha muala oborna anna le'ba'i untammui mesa muane to la kebaine. ");
INSERT INTO ptu_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Indo sapulo änä' daha si limaam, lima matua tambu' anna lima tää'. ");
INSERT INTO ptu_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Indo lima to tä' matua tambu' umbaba oborna, sapo' tä' umbaba polepi minnä'. ");
INSERT INTO ptu_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Sapo' indo ia lima to matua tambu', umbaba ia oborna napasibabapi minnä'na. ");
INSERT INTO ptu_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Sapo' aka maela' sule indo to la kebaine, nasuhum silele tikahu'du' lambi' mamma'. ");
INSERT INTO ptu_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Tappana tängä bengi, iya katamba-tambam tau naua: ‘Sulem indo to la kebaine! Maikoa' tammui!’ ");
INSERT INTO ptu_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Bangom siaham indo sapulo änä' daha anna umpapia-piai oborna. ");
INSERT INTO ptu_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Iya nauam indo to tä' matua tambu': ‘Beengkam kami' itim minnä'mu saidi' aka la pi'dem kami' oborki.’ ");
INSERT INTO ptu_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Natimba' indo to matua tambu' naua: ‘Tä' mala aka la sikapui'i bäbäkia'. Dotam tia lao polekoa' iko duka' mualli minnä' lako to ma'balu'.’ ");
INSERT INTO ptu_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Tappana le'ba'i indo änä' daha to tä' matua tambu' mualli minnä', iya sule siaham indo to la kebaine. Lambi' le'ba'im indo lima änä' daha to matua tambu' sola-sola indo to la kebaine tama mesa banua la diongei ma'hame-hame. Sulei tama, iya ditutu'i siaham ba'ba. ");
INSERT INTO ptu_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Tä' masäe, iya sulem duka' indo lima änä' daha to tä' matua tambu' anna metamba-tambai naua: ‘O tuam! Tungka'ikam kami'!’ ");
INSERT INTO ptu_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Sapo' natimba'i indo to la kebaine naua: ‘Setongam-tonganna, tä'koa' iko kuissam.’” ");
INSERT INTO ptu_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Mane naalai Puang Yesus pungngu' tannunna inde pehapangam naua: “Iam too anna la majaga liungkoa' aka tä' deem tau la muissanni wattunna kasuleangku sule.” ");
INSERT INTO ptu_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Anna mane naua: “Maka' umpalakom kapahentaanna Puang Allataala dipasihhapam issinna inde tulasam susi naua: Pissam wattu, deem mesa tau la le'ba' lako botto senga'. La mengkalaoi, untambaim tallu sabua'na anna napadokkoanni lisu pala'na doi'na aka la nagihisam. ");
INSERT INTO ptu_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Sapo' umpetua' indo sabua'na anna nabeenni situhu' la kapa'belaanna. Mesa nabeem lima sa'bu doi' bulabam, mesa nabeem dua sa'bu, anna mesa nabeem sasa'bu. Puhai, iya le'ba'um. ");
INSERT INTO ptu_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Puhanna dibeem indo doi', iya le'ba' siaham ia nagihi' indo to dibeem lima sa'bu, sampe mala kehängäm lima sa'bu doi' bulabam. ");
INSERT INTO ptu_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Susi toi duka' indo to dibeem dua sa'bu, kehängäm ia dua sa'bu doi' bulabam. ");
INSERT INTO ptu_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Sapo' indo ia to dibeem sasa'bu, le'ba' ia umbo'bä' litä' anna nalamunni. ");
INSERT INTO ptu_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Masäei, iya sulem sule indo puäna. Sulena, iya sihekemmi sabua'na. ");
INSERT INTO ptu_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Indo to dibeem lima sa'bu doi' bulabam le'ba' lako olona puäna anna nauaanni: ‘O tuam, indo doi' umbeennä', iya kugihi' lessu'mu sampe tiluppi' dua mendadi sapulo sa'bu.’ ");
INSERT INTO ptu_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Natimba' indo puäna naua: ‘Mapia! Abana si'da sabua' mapiako anna manuhu'. Malako dikatappa'i, aka manuhu'ko illaam kaha-kaha bahinni', iya temo la kupadokkoangko lisu pala'mu babaam kasalle. Maiko anna mangngala tabako duka' illaam katilallasangku.’ ");
INSERT INTO ptu_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Puhai, iya sulem duka' indo to dibeem dua sa'bu doi' bulabam anna nauai: ‘Indo doi' dua sa'bu umbeennä', iya kugihi' lessu'mu sampe tiluppi' dua mendadi appa' sa'bu.’ ");
INSERT INTO ptu_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Natimba' indo puäna naua: ‘Mapia! Abana si'da sabua' mapiako anna manuhu'. Malako dikatappa'i, aka manuhu'ko illaam kaha-kaha bahinni', iya temo la kupadokkoangko lisu pala'mu babaam kasalle. Maiko anna mangngala tabako duka' illaam katilallasangku.’ ");
INSERT INTO ptu_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Katampasanna sule duka' indo to dibeem sasa'bu doi' bulabam anna nauai: ‘O tuam, kuissam kuua mesako to makahha'. Aka si umpepaheko iko pahe taiko muambo'i anna si umpakissingko pahe taiko untananni. ");
INSERT INTO ptu_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Iam too kasuhunganna anna le'ba'mä' kulamum dokko litä' indo doi'mu, aka kuua pa'de manii anna ungkeaha'iä'. Dadi alam too sule inde doi'mu.’ ");
INSERT INTO ptu_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Natimba' indo puäna naua: ‘O sabua' to kadake gau' anna to busungam! Muissammi le', muua kao mesaä' to si umpepahe pahe takao muambo'i anna si umpakissim pahe takao untananni! ");
INSERT INTO ptu_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Maka' susi, iya akanna tä'i umbeem inde doi' lako to si umpakeänä' doi', anna mala kutahima sitonda änä'na ke suleä'?’ ");
INSERT INTO ptu_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Anna mane naua lako sabua' senga'na: ‘Alai itim doi' anna umbeem polepi lako indo to muampuam sapulo sa'bu doi' bulabam. ");
INSERT INTO ptu_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Aka menna-menna mala dikatappa'i umpalako indo puha dibeem, tau ia too la dihängänniam polepi anna mala tuttuam buda naampuam. Sapo' menna-menna tä' mala dikatappa'i umpalako indo puha dibeem, iya la diäläi pissam ia lao illaam mai kalena. ");
INSERT INTO ptu_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Dadi tibei itim sabua' takeguna tama indo ongeam handam malillim anna illaanni sumahho lumoa' sikekko' isinna tamate tatubo.’” ");
INSERT INTO ptu_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Anna mane naua Puang Yesus: “Maka' sulemä' to disangai Änä' Mentolino naponnoi kamatandeam nalahuä' ingganna malaika', iya la muokko'ä' yabo okkosam kahajaangku tadisihanteam. ");
INSERT INTO ptu_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Iya wattu etam too ingganna hupatau illaam inde lino la tihempum dio oloku anna kuse'lai sihhapam mesa to ma'kambi' umpasisähä' dombana anna bekena. ");
INSERT INTO ptu_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Indo ia domba la kupalulako tandai kanangku anna indo ia beke la kupalulako tandai kaihingku. ");
INSERT INTO ptu_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Anna la ma'kadaä' to disa'bu' Tomahaja lako indo to dio tandai kanangku kuua: ‘Maikoa' inggannakoa' to puha natamba' Ambeku anna mendadikoa' umma'na illaam kapahentaanna indo inna puha dipatokaangkoa' handu' dipadadinna inde lino. ");
INSERT INTO ptu_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Aka wattungku tadea' umbeennä' kuande, wattungku mabähhäm umbeennä' kuihu', wattungku tama tondä'mua' umpatama manappaä' banuammua'. ");
INSERT INTO ptu_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Wattunna pa'de pohebaku umbeennä' poheba, wattungku masaki umpamoloiä', anna wattunna illaannä' tahungkum si le'ba'koa' muolläiä'.’ ");
INSERT INTO ptu_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Iya la natimba' indo to meimam naua: ‘O Debata, umba ngei kiitako tadea' anna kibeengko muande, battu mabähhängko anna kibeengko muihu'? ");
INSERT INTO ptu_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Umba ngei anna deengko kiita tama tondä'ki anna kipatamako banua? Anna umba ngei kiitako tä' ma'poheba anna kibeengko poheba? ");
INSERT INTO ptu_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Anna umba ngei anna kiitako masaki battu illaangko tahungkum anna kiolläiko?’ ");
INSERT INTO ptu_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Iya la kutimba'i kuua: ‘Setongam-tonganna, iai too umpogau'a' lako inde solasubungku to handam matuna, iya iam too umpogau'a' lako kaleku.’ ");
INSERT INTO ptu_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Puhai, iya la kuuaammi indo to dio tandai kaihingku: ‘Päläikoa' lao, daa muetaa' inde inggannakoa' to nahua tädona Puang Allataala, ammu le'ba'a' tama api tapi'de-pi'de indo to puha dipatokaam tomahajanna setam sola ingganna malaika'na. ");
INSERT INTO ptu_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Aka ikoa'-iko wattungku tadea' tä' umbeennä' kuande anna wattungku mabähhäm tä' umbeennä' kuihu'. ");
INSERT INTO ptu_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Wattungku tama tondä'mua' mokakoa' umpatamaä' banuammu, wattunna pa'de pohebaku tä' ussaha'daia' umbeennä' poheba. Susi toi wattunna masakiä' anna illaannä' tahungkum tä' deem si muolläiä'.’ ");
INSERT INTO ptu_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Iya la naua indo to dio tandai kaihingku: ‘Umba ngei deengko kiita tadea' Debata battu haka mabähhäm, battu haka tamako tondä'ki battu haka pa'de pohebamu battu haka masakiko battu illaangko tahungkum anna tä'ko kipamoloi?’ ");
INSERT INTO ptu_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Iya la kutimba'i kuua: ‘Setongam-tonganna, ingganna pa'palakoammua' indo tä'koa' umpamoloi inde solasubungku to handam matuna, iya setonganna tä' tia anggam ia tä' umpamoloia', sapo' Kaopi duka' tä' umpamoloi.’ ");
INSERT INTO ptu_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Anna ingganna indo tau ia too la dipalutama ia ongeam pandahhaam sule lako salako-lakona. Sapo' indo ia to umpalako pa'elo'na Puang Allataala, la ullambi' ia katuboam sule lako salako-lakona.” ");
INSERT INTO ptu_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Tappana puha asam natula' Puang Yesus ingganna indo pepa'guhuam, iya ma'kadam lako passikolanna naua: ");
INSERT INTO ptu_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Umba susi puha taissanna' pada-pada la dua bengi ham anna lambi' oi allo Kalappasam. Wattu eta too Kao to disangai Änä' Mentolino la dibehoä' tama pala' limanna to la umpateiä' yabo kaju sitambem.” ");
INSERT INTO ptu_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Wattu eta siam too duka' anna ma'hempunni ingganna kapala sando sola-sola matua ulunna to Yahudi dio banuanna sando too' isanga Kayafas. ");
INSERT INTO ptu_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Sipattuju-tuju umpeä lalam aka la ussakka membuni Puang Yesus anna la napopepatei. ");
INSERT INTO ptu_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Sapo' nauai: “Tä' la tapasipatuia' allo kasalle, indana kende'i passikallaam illaam botto.” ");
INSERT INTO ptu_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Tappana dioi tondä' Betania Puang Yesus illaam banuanna Simon indo to dolengam yolona, ");
INSERT INTO ptu_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","iya sulem mesa baine umbaba mesa buli-buli mapindäm kessi minnä'-minnä' bubanau' si masulli' allinna. Mahassanni mangngande Puang Yesus, iya le'ba'um indo baine lako ampe'na anna natolloianni ulunna indo minnä'-minnä'na tanda pa'pakasallena. ");
INSERT INTO ptu_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Tappana naita passikolanna Puang Yesus pa'palakoanna indo baine, iya silelem keaha' aka illaam penabanna naua: “Aka oom ia duka' gunana minnä'-minnä' masulli' dikatoa-toai bäbä? ");
INSERT INTO ptu_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Aka indo kela nabalu'um inde dio minnä'-minnä'na ma'pateem masuli'na anna natabanni to mase-mase, la mapia leko' ia.” ");
INSERT INTO ptu_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Sapo' nalosa Puang Yesus tama penabanna indo passikolanna nasuhum naua: “Akanna umpasalakoa' inde baine? Päbäi mammi napateem. Aka inde napateem, mesa pa'pogausam mapia lako kaleku. ");
INSERT INTO ptu_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Aka to mase-mase ia la sola-sola liukoa', sapo' Kao-kao tä'kia' la sola liu. ");
INSERT INTO ptu_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Aka inde natolloiä' minnä'-minnä'na temo, napogau' loppo'um ia indo la dipogau' ke dilamummä'. ");
INSERT INTO ptu_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Setongam-tonganna, umba-umba naongei Kaheba Katilallasam dipa'pakahebaam, etam too duka' la dipotulasam pa'pogausanna inde baine anna mala dikilalai liu.” ");
INSERT INTO ptu_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Puhai ia too, deem mesa to tihekem sapulo dua passikolanna Puang Yesus isanga Yudas Iskariot le'ba' umpellambi'i kapala sando, ");
INSERT INTO ptu_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","anna nauai: “Sanaka la umbeennä' ke kupamoloikoa' la ussakka Puang Yesus?” Iya natimba'im naua: “La kibeengko tallu pulo doi' peha'.” Iya nahekemmi anna mane nabeem. ");
INSERT INTO ptu_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Napahandu'um eta too umpeä liu lalam Yudas la umbalu' Puang Yesus. ");
INSERT INTO ptu_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Illaam pa'pahandusanna allo kasalle Hoti Tä' Diboloi Bibi' Hoti, sulem passikolanna Puang Yesus umpellambi'i anna nauai: “La umbakam ngei umpatokaangko kinande indo si diande ke umpengkilalai tau allo Kalappasam?” ");
INSERT INTO ptu_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Iya nauam Puang Yesus: “Le'ba'koa' libam kota Yerusalem anna umpellambi'ia' indo mesa solata anna muuaannia': ‘Naua Tuangguhu: la lambi'um wattunna indo to puha napa'tantu Puang Allataala diona kaleku. Dadi illaam banuammu la kiongei sola-sola passikolangku umpengkilalai allo Kalappasam.’” ");
INSERT INTO ptu_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Iya le'ba'um duka' indo passikolanna libam Yerusalem anna napalakoi pada indo nauaam Puang Yesus lambi' umpatoka kinande indo si diande illaam allo Kalappasam. ");
INSERT INTO ptu_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Tappana bengi, iya mangngandem Puang Yesus sola-sola indo sapulo dua passikolanna. ");
INSERT INTO ptu_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Mahassanni mangngande, iya nauam Puang Yesus: “Setongam-tonganna, deem mesa solamua' illaam inde alla'-alla'taa' la umbalu'ä'.” ");
INSERT INTO ptu_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Iya sangngim masussa siaham penabanna anna sibala'-bala'i mekutana lako Puang Yesus naua: “Takao mammaka kao, Tuam?” ");
INSERT INTO ptu_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Natimba' Puang Yesus naua: “Iai too kupasola unduho hoti dokko lojam-lojam, iya iam too la umbalu'ä'. ");
INSERT INTO ptu_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Abana hi tia Kao to disangai Änä' Mentolino inna la mateä', umba susi puha tisuha' illaam Battakada Debata. Sapo' tä' deem pada satilaka lako indo to umbalu'ä'. Mala leko'um ia kela tä'um ia didadiam!” ");
INSERT INTO ptu_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Iya nauam duka' Yudas indo to la umbalu' Puang Yesus: “Takao mammaka kao, Tuangguhu?” Natimba' Puang Yesus naua: “Iya pasaluim too penaba o!” ");
INSERT INTO ptu_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Mahassanni mangngande, iya mualam mesa hoti Puang Yesus anna nakuhhu'i sumanga' längäm Puang Allataala mane napiä'-piä'i anna nabeenni lako passikolanna napasindum naua: “Iam too inde baleku, alaia' ammu andei.” ");
INSERT INTO ptu_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Puhai, mualam mesa ihusam kessi anggur anna nakuhhu'i sumanga' mane nabeem oi lako passikolanna anna nauai: “Ihu'ia' indee, ");
INSERT INTO ptu_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","aka iam too inde hahaku la dipatitollo la umpomannassa pa'dandianna Puang Allataala lako buda hupatau anna mala naampunniam dosana. ");
INSERT INTO ptu_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Sapo' kuuaangkoa' tentomai: tä'mä' Kao deem la muihu' pole anggur sampe lambi' wattunna la muihu'ä' anggur bakahu sola-solakia' illaam kapahentaanna Ambeku.” ");
INSERT INTO ptu_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Puhai, iya umpenaniammi mesa pampujiam, mane le'ba'i la längäm Tanete Zaitun. ");
INSERT INTO ptu_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Iya umpatahhu'um tula'na Puang Yesus lako passikolanna naua: “Illaam inde bengi la le'ba'koa' umpelleiä' aka deem tisuha' illaam Battakada Debata naua: ‘La kupatei to ma'kambi'na anna ingganna dombana la tisembu' lao.’ ");
INSERT INTO ptu_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Sapo' maka' too dipatibangommä' sule, la kupendioloikoa' lako Galilea.” ");
INSERT INTO ptu_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Iya tappa ma'kada Petrus naua: “Moi la le'ba' asam solaku napelleiko aka indo kadadiam la uhhuako, inna tä' sia kao deem la kupelleiko.” ");
INSERT INTO ptu_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Natimba' Puang Yesus naua: “Setongam-tonganna, illaam inde bengi tä'pi la moni mäne' anna pentallummä' umbahoi.” ");
INSERT INTO ptu_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Iya naua oom Petrus: “Toko moiä' kao la dipatei solaki', tala kubahoiko!” Anna susi siam duka' tula'na ingganna solana Petrus. ");
INSERT INTO ptu_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Puhai ia too, iya le'ba'um Puang Yesus sola passikolanna lu lako mesa ongeam isanga Getsemani. Dioi, muuaammi passikolanna: “Okko'ungkoa' too eta inde angku laopa eta lako pa'sambajam.” ");
INSERT INTO ptu_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Iya umbabaim Petrus sola indo to dua änä'na Zebedeus napasola. Wattu eta too tä' deem pada samasussa anna husa' penabanna Puang Yesus nasi'dim. ");
INSERT INTO ptu_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Nasuhum naua lako indo passikolanna to napasola: “Masussa si'da-si'da penabangku kusi'dim, angga' la mateä'. Tohhongkoa' too eta inde, sapo' tä'koa' la lembe.” ");
INSERT INTO ptu_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Iya mentudendem saidi' anna untapposanni kalena dokko litä', anna ma'sambajanni naua: “O Ambe', kela mala anna muäläi illaam mai kaleku inde kamasussaam kupendudum. Sapo' la pa'elo'mu dadi, taia la pa'elo'ku.” ");
INSERT INTO ptu_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Puhai ma'sambajam, iya ma'pasulem lako indo tallu passikolanna sapo' mamma'i hi nalambi'. Iya ma'kadam lako Petrus naua: “Tä' siangka tiko isanga la umbela umpasolaiä' moi podo satette'um! ");
INSERT INTO ptu_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Majagakoa' ammu pa'sambajam indana napa'sändä'ikoa' setam. Aka abana hi tia mohäe penabammua' la umpalako kamaloloam, sapo' napomalammakoa' sipa' hupataummu.” ");
INSERT INTO ptu_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Puhai umpa'tula'i passikolanna, iya le'ba' pole oom kapenduanna ma'sambajam naua: “O Ambe', maka' abana inna la kuoloi inde kamasussaam anna lalam tä'um la mala kusalai, iya pa'elo'mum too isanga la dadi.” ");
INSERT INTO ptu_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Puhai, ma'pasule oom sule, iya nalambi' mamma' oo sule aka nataloi sugali'um matanna. ");
INSERT INTO ptu_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Iya le'ba' pole oom sule ma'sambajam kapentallunna, nasulei umba susi indo issi sambajanna ingngena'. ");
INSERT INTO ptu_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Tappana ma'pasule lako passikolanna, iya nauam: “Mamma' liupokoa' isanga? Tä' liupokoka' tiko malube! Petua'ia' tentomai lambi'um wattunna Kao to disangai Änä' Mentolino la dibehoä' tama pala' limanna to madosa. ");
INSERT INTO ptu_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Bangommokoa' anta laoa'. Petua'ia' diom mai indo to la umpopesakkaä'!” ");
INSERT INTO ptu_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Mahassampi ma'tula' Puang Yesus, iya sule ham Yudas indo to tihekem duka' sapulo dua passikolanna Puang Yesus umpasola tau bu'dä' sanda pa'dam sola bose, nasua kapala sando anna matua ulunna to Yahudi. ");
INSERT INTO ptu_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Indo Yudas to umbalu'i, puham untula' loppo' tanda lako indo to napasola naua: “Iai too kuudum, iam too la ussakkaa'.” ");
INSERT INTO ptu_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Sulena Yudas tappa umpellambi'i Puang Yesus anna nauai: “O Tuangguhu!” Anna mane muudum Puang Yesus. ");
INSERT INTO ptu_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Sapo' ma'kada Puang Yesus naua: “O solaku, aka untungka sule?” Iya le'ba' siaham lako indo tau buda anna ussakkai Puang Yesus. ");
INSERT INTO ptu_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Sapo' deem mesa solana Puang Yesus ussintä' pa'danna anna umbattai mesa sabua'na sando too', iya mäläi talinganna. ");
INSERT INTO ptu_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Naua siaham Puang Yesus: “Daa! Patamai sule banuanna pa'dammu! Aka menna-menna umpopanaka pa'dam, pa'dampi duka' muandei. ");
INSERT INTO ptu_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Ussanga haka' tiko tä' la mala kupelau längäm Ambeku yabo suhuga anna napatuhungannä' la'bi sapulo dua tuntunganna sohodadu malaika' napamoloiä' kela kupahalluanni? ");
INSERT INTO ptu_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Sapo' maka' la kupateem, iya tä' la sule lako indo puha tisuha' illaam Battakada Debata diona abana hi tia inna la dadi inde kadadiam temo.” ");
INSERT INTO ptu_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Anna mane naua Puang Yesus lako indo tau buda: “Ussangaa' isanga pehampo'ä' anna sulekoa' sanda pa'dam sanda bose la ussakkaä'? Kusanga allo-alloä' muokko' illaam Banua Debata ma'pa'guhu anna tä' di ussakkaä'. ");
INSERT INTO ptu_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Sapo' abana hi tia la susi anna mala sule lako indo puha nasuha' nabi illaam Battakada Debata.” Puhai, iya sikalumpa'um lao ingganna indo passikolanna napellei. ");
INSERT INTO ptu_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Tappana disakka Puang Yesus, iya dipasolam lako banuanna sando too' isanga Kayafas. Eta too mahassam ma'hempum to ullatta' Pepaondonganna Musa sola matua ulunna to Yahudi. ");
INSERT INTO ptu_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Iya natuhu' kalamba'um Petrus sule lako bihim pa'hanteanna sando too'. Sulei lako, iya tahhu'um tama anna muokko'i sola to unjagai Banua Debata, aka maelo' la napengngissanni aka la dadi lako kalena Puang Yesus. ");
INSERT INTO ptu_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Iya umpalilimmi tangnga' kapala sando sola ingganna solana to tihekem duka' To Mahhotto'na to Yahudi la umpeängam tuntungam su'be' Puang Yesus anna nadakasam pa'posanga-sanga anna mala dipatei. ");
INSERT INTO ptu_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Moinna anna budam tau sisolom-solom le'ba' lako olo mendadi sa'bi tatappa', sapo' tä' punala deem la siundu'-undu' kadanna la nasuhungam mala dipatei Puang Yesus. Ma'katampasanna le'ba' lako olo dua tau ");
INSERT INTO ptu_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","anna nauai: “Puha kihingngi inde tau naua: ‘Mala kukadakeam inde Banua Debata, sapo' la tallungngallo mandi kuolaam ungkähäi anna ke'de'um sule.’” ");
INSERT INTO ptu_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Iya ke'de'um siaham sando too' anna ungkutanai Puang Yesus naua: “Tä' liu siam isanga la untimba'i inde lako pa'pahapa'na tau?” ");
INSERT INTO ptu_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Sapo' mengkamma' mandi Puang Yesus. Iya ma'kada pole oom indo sando too' naua: “Pa'pindaipoko Puang Allataala Debata tubo ke abanai iko si'dam indo To dilanti' la mepasalama', battu diua Änä'na Puang Allataala!” ");
INSERT INTO ptu_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Natimba' Puang Yesus naua: “Ikom ma'kale muuai. Sapo' kuuaangkoa' duka' tentomai: illaam allo la taoloinna la muitakoa' Änä' Mentolino, battu diua Kao, la muokko' dio tandai kananna To Handam Kuasa anna la suleä' sule umpehhondoi gabum yabo langi'!” ");
INSERT INTO ptu_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Iya tappa umpessepäsam siaham pohebana sando too' aka keaha' anna nauai: “Tahingnginna' untelle Puang Allataala. Akapi gunana la umpeä liukia' sa'bi? Aka uhhingngi asammia' kadanna inde dio tau untelle Puang Allataala! ");
INSERT INTO ptu_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Dadi maakaa' iko susi pikkihammu?” Pada-pada mentimba' naua: “Abana sihatam la dipatei aka kasalaam!” ");
INSERT INTO ptu_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Iya deemmi sanaka-naka tau untikkudui lindona, deem piha undänggu'i, anna deem toi ussapu'i matanna Puang Yesus napasindum natampilim ");
INSERT INTO ptu_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","anna nauai: “O To dilanti' la mepasalama', pentopaipi menna untappai limako?” ");
INSERT INTO ptu_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Wattu eta too mahassampi duka' dio pa'hanteam Petrus, iya sulem mesa sabua' baine anna ungkutanai Petrus naua: “Iko duka' mesa to si sola liu indo Yesus to Galilea, le'?” ");
INSERT INTO ptu_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Sapo' tappa ma'baho Petrus dio olona ingganna tau eta too naua: “Tä' kuissam kalembasanna itim tula'mu!” ");
INSERT INTO ptu_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Mane le'ba'i lako ba'ba bala pa'hanteam. Dioi, naita pole oom mesa sabua' baine, iya nauam indo baine lako to dio heem eta too: “Inde dio tau abana solana Yesus indo to Nazaret.” ");
INSERT INTO ptu_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Iya ma'baho oom Petrus sampe ma'pinda. Anna mane naua: “Tä' si'da-si'da kuissam tau ia too.” ");
INSERT INTO ptu_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Tä' masäe, iya sangngim nauam indo to ke'de'-ke'de' dio ampe'na Petrus: “Mannassa anna solanako aka susi liua' loeam tula'mu.” ");
INSERT INTO ptu_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Iya ma'pindam pole' Petrus naua: “Naitaä' Debata, kela kuissanni indo tau!” Ia sia teppu'na dio pudu'na Petrus tula'na, iya moni siaham mäne'. ");
INSERT INTO ptu_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Tappa nakilalaim pole' Petrus indo pa'tula'na Puang Yesus naua: “Tä'pi la moni mäne' anna pentallummä' umbahoi.” Iya le'ba' siaham Petrus lako sulibam anna ma'pase'go'i sumahho. ");
INSERT INTO ptu_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Mebengngi'-bengngi'pi, iya umpasahandammi kada ingganna kapala sando sola matua ulunna to Yahudi la umpatei Puang Yesus. ");
INSERT INTO ptu_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Iya umpungom Puang Yesus anna nababai lako olona Pilatus, mesa Gubernur illaam kapahentaanna Roma. ");
INSERT INTO ptu_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Tappana naissam Yudas indo to umbalu' Puang Yesus naua dipasala Puang Yesus lambi' la dipatei, iya ussosso siaham kalena. Nasuhum napasule asam sule indo sahona tallu pulo doi' peha' lako ingganna kapala sando sola matua ulunna to Yahudi anna mane naua: ");
INSERT INTO ptu_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","“Abana madosa si'da-si'daä' aka umbalu'ä' tau tä' deem kasalaanna sampe la dipatei!” Sapo' nauai indo kapala sando sola matua ulunna to Yahudi: “Taia kami' issangki itim. Issammu oom tiko duka'!” ");
INSERT INTO ptu_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Iya napa'tibeammi Yudas indo doi' tama Banua Debata anna le'ba'i mentujo untoke' kalena. ");
INSERT INTO ptu_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Iya nahuhu'im kapala sando indo doi' anna nauai: “Inde doi' tä' la mala dipalutama pa'pongngeam pehumalasam illaam Banua Debata, aka doi' haha.” ");
INSERT INTO ptu_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Tappana sahandanni kadanna indo kapala sando, iya naalliammi sangngenam litä'na pa'tampa kuhim la si dipa'ku'bu'i to sule ke deenni mate. ");
INSERT INTO ptu_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Iam too anna disangai lium indo pa'ku'busam sule lako temo: “Litä' Haha.” ");
INSERT INTO ptu_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Iya sule lakom indo to puha natula' loppo' nabi Yeremia naua: “Ussahandanni kada to Israel la tallu pulo doi' peha' allinna lambi' natahima anna ");
INSERT INTO ptu_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","naallianni sangngenam litä'na pa'tampa kuhim, umba susi pahentana Debata lako kaleku.” ");
INSERT INTO ptu_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Tappana dio olona Pilatus Puang Yesus, iya nakutanaim naua: “Ikongka indo tomahajanna to Yahudi?” Natimba'i Puang Yesus naua: “Ikom ma'kale muuai.” ");
INSERT INTO ptu_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Sapo' indo ingganna tula' napakolo'-kolo'iam ingganna kapala sando sola matua ulunna to Yahudi, tuli tanatimba'i Puang Yesus. ");
INSERT INTO ptu_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Nasuhum mekutana pole oom Pilatus naua: “Tä' isanga uhhingngi inde lako tula'na to diposa'bi?” ");
INSERT INTO ptu_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Sapo' tä' mandi deem natimba'i Puang Yesus moi podo la sabattam kada, nasuhum mängä-mängä bäbäm pole' Pilatus. ");
INSERT INTO ptu_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Maka' lambi' oom allo Kalappasam si biasa nalappasam gubernur mesa to ditahungkum situhu' pelauanna tau buda. ");
INSERT INTO ptu_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Eta too deem mesa to ditahungkum molele-lele gau' kadakena, isanga Yesus Barabas. ");
INSERT INTO ptu_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Iya tihempum asanni tau buda, mekutanam Pilatus naua: “Mennanna kabam umpohäea' la kulappasam tentomai? La Yesus Barabas daka, la inde haka Yesus to si diuaam To dilanti' la mepasalama'?” ");
INSERT INTO ptu_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Ia anna ma'kada susii Pilatus aka naissam naua ia hi tia anna nababai sule aka nakembuhui. ");
INSERT INTO ptu_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Mahassam siapi muokko' Pilatus illaam okkosam si naongei mahhotto' anna nalambi'um pepasanna bainena naua: “Tä'ko too la ungkalako-lakoannii itim kaha-kahana tau to tä' deem kasalaanna le, aka iam napolalam mangngimpi kadakeä' sabengi.” ");
INSERT INTO ptu_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Sapo' indo ingganna kapala sando sola matua ulunna to Yahudi ussasungam liu tau buda melau lako Pilatus anna mala Barabas dilappasam, anna dipatei ia Puang Yesus. ");
INSERT INTO ptu_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Iya mekutana pole oom Pilatus lako indo tau buda naua: “Mennannam kabam indo to dua umpohäea' la kulappasangangkoa'?” Natimba'im naua: “Barabas!” ");
INSERT INTO ptu_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Mekutana oom Pilatus naua: “Maka' susi, iya aka ia la kupogausam indo Yesus si diuaam To dilanti' la mepasalama'?” Natimba'i oom naua: “Päso'i yabo kaju sitambem anna malai mate!” ");
INSERT INTO ptu_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Mekutana pole oom Pilatus naua: “Anu' aka hia kasalaanna?” Sapo' tuttuam sikaoli mandi naua: “Päso'i yabo kaju sitambem anna malai mate!” ");
INSERT INTO ptu_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Tappana tä'um deem lalam senga' naita pole Pilatus anna mala dilappasam Puang Yesus, anna naua toi: “Kende' manii kahusasam illaam pa'bottoam ke tä'i dipaolai lalam penabanna tau buda,” iya mualam uwai anna umbasei limanna dio olona indo tau buda napasindum naua: “Taia kao issangku kamateanna inde dio tau, issammu onna' tiko duka'!” ");
INSERT INTO ptu_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Natimba'i indo tau buda naua: “Yaboko iko tanahambui dioko tanato'doi kamateanna inde tau. Aka kami' oom too kami' duka' la umpendudunni pa'pogausam ia too sule lako peampoangki!” ");
INSERT INTO ptu_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Iya ullappasammi ia Barabas anna ussuai tau untembe' talukum Puang Yesus mane napesuaanni dipäso' yabo kaju sitambem. ");
INSERT INTO ptu_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Puhai ia too, nababam sohodadunna Gubernur Pilatus Puang Yesus lako Banua Gubernur, anna untambai asanni ingganna solana anna nalilinni lao pali'. ");
INSERT INTO ptu_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Mane muäläianni pohebana Puang Yesus anna nabala'ianni juba mellolo pao susi bajunna tomahaja, ");
INSERT INTO ptu_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","anna muananni songko' susi songko' tomahaja sapo' keduhi anna napasongko'ianni. Anna mane napatetäi tekkem lima kananna anna sangngim ma'balinguntu' lelenni menomba dio olona Puang Yesus anna natelle-tellei naua: “O tomahajanna to Yahudi, kipa'kasalleiko!” ");
INSERT INTO ptu_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Anna natikkudui mane naalai indo tekkem dio limanna anna nahabisanni ulunna. ");
INSERT INTO ptu_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Puhai natelle, naäläiammi sule indo juba napapakeiam anna napapohebai sule indo inna pohebana. Anna mane dibaba lao la dipäso' yabo kaju sitambem anna malai mate. ");
INSERT INTO ptu_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Mahassanni mellao umpellei kota, iya sitammum mesa tau isanga Simon buttu dio mai kota Kirene. Iya napapassaim sohodadu umpassam indo kaju sitambem. ");
INSERT INTO ptu_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Landa'i lako mesa ongeam si diuaam Golgota, kalembasanna ongeam kahohä' ulu, ");
INSERT INTO ptu_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","iya dibeemmi Puang Yesus anggur diboloi susi pa'du mapäi'na. Sapo' tappana nasi'dim, iya moka muihu'i. ");
INSERT INTO ptu_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Iya napäso'um lako indo kaju sitambem. Puhai, nataba-tabam sohodadu indo pohebana, sapo' naundi. ");
INSERT INTO ptu_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Anna mane muokko'i lako indo ampe'na kaju sitambem aka najagai. ");
INSERT INTO ptu_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Yabo tondom ulunna Puang Yesus tisuha' diona kasuhunganna anna dipäso'i yabo kaju sitambem naua: IAM TOO INDE YESUS TOMAHAJANNA TO YAHUDI. ");
INSERT INTO ptu_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Wattu eta too deem duka' dua pehampo' nasimbahaam dipäso' yabo kaju sitambem, mesa dio tandai kananna anna mesa dio tandai kaihinna. ");
INSERT INTO ptu_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Ingganna to muolai ongeam ia too si muillim-illim tandana untelle Puang Yesus napasindum ");
INSERT INTO ptu_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","naua: “Kusanga paha' la ungkadakeangko Banua Debata anna la tallungngallo muolaam umpake'de' sule! Maka' Änä'na tongangko Puang Allataala, iya lappasangko kalemu anna tuhungko yabo mai itim kaju sitambem!” ");
INSERT INTO ptu_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Susi toi duka' kapala sando anna to ullatta' Pepaondonganna Musa sola matua ulunna to Yahudi sangngim untelle Puang Yesus ");
INSERT INTO ptu_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","naua: “Maka' tau senga' mala napasalama', sapo' maka' kalena tä' ohi ia mala napasalama'. Maka' tomahajanna si'da to Israel, iya la tuhummi too yabo mai inde dio kaju sitambem, anna kikatappa'i pole'. ");
INSERT INTO ptu_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Anna angga ha ade' Puang Allataala si napassedanni hannu, iya la taitanna' too pole' battu la sule si'da hi Puang Allataala temo napasalama'. La'bi-la'binna aka puha naua: ‘Änä'naä' Puang Allataala.’” ");
INSERT INTO ptu_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Moi indo to dua pehampo' to nasimbahaam dipäso' yabo kaju sitambem untelle duka' Puang Yesus. ");
INSERT INTO ptu_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Tappana tängä allo, iya malillim pättäm dio indo pa'lembängam sule lako tette' tallu kahubem. ");
INSERT INTO ptu_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Tette' tallui kahubem, iya metambam Puang Yesus naua: “Eli, Eli, lama sabakhtani?” Kalembasanna, O Puang Allataala, Debatangku, aka hi anna untampeannä'? ");
INSERT INTO ptu_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Nahingnginna petambana indo to ke'de' eta too, iya deemmi sanaka-naka muuai: “Pehingngiia'i, untambai nabi Elia!” ");
INSERT INTO ptu_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Iya napasihha' siaham mesa tau muala bunga karang anna nahammei dokko anggur maissu', mane napadekke'i lako pesoka anna napadu'dui pudu'na Puang Yesus. ");
INSERT INTO ptu_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Sapo' deem piha muuai: “Dako'pa yolo anta petua'ia' battu la sule si'da hi Elia napasalama'!” ");
INSERT INTO ptu_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Iya metamba pole oom mane umbehoi sungnga'na, iya kattu pole' penabanna. ");
INSERT INTO ptu_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Wattu eta too, indo sampim pesapa' illaam Banua Debata tappa sesse' tipa'dua mengkalao yabo sule dokko. Anna tappa dadi lino' kasalle anna piä'-piä' batu kasalle. ");
INSERT INTO ptu_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Anna buda lokko' titungka' anna buda toi duka' umma'na Puang Allataala to puham mate dipatubo sule. ");
INSERT INTO ptu_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","(Puha ham tibangom sule Puang Yesus dio mai alla'na to mate mane le'ba' di duka' indo to tubo sule tama Yerusalem indo kota maseho, lambi' buda tau muitai.) ");
INSERT INTO ptu_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Tä' deem pada samahea' indo sohodadunna to Roma sola punggabana to mahassam unjagai Puang Yesus tappana nasi'dinni indo lino' kasalle anna muita ingganna indo kadadiam ia too, lambi' ma'kada naua: “Abana Änä'na si'da hia päläe' Puang Allataala!” ");
INSERT INTO ptu_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Deem duka' buda baine umpetua' mambelai, indo to si untuhu' liui napamoloi mengkalao dio Galilea. ");
INSERT INTO ptu_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Dio duka' heem eta too Maria Magdalena, indona Yakobus anna Yusuf isanga duka' Maria, anna bainena Zebedeus. ");
INSERT INTO ptu_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Tappana mahammo allo eta too, iya sulem mesa to makaka isanga Yusuf to Arimatea, mesa duka' passikolanna Puang Yesus. ");
INSERT INTO ptu_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Anna le'ba'i umpellambi'i Pilatus umpelau bakkena Puang Yesus. Iya napa'pahentaammi Pilatus anna mala dipaolai pelauanna. ");
INSERT INTO ptu_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Iya le'ba' siaham Yusuf muala indo bakkena Puang Yesus anna nabalunni sampim mabusa, ");
INSERT INTO ptu_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","anna mane laoi napandam tama lokko' kalena, tä'pi masäe anna napapiai dio mesa tanete batu. Puhai, iya ullolimmi batu kasalle natutu'iam ba'bana, mane le'ba'i. ");
INSERT INTO ptu_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Wattu eta too muokko' Maria Magdalena anna mesapi baine isanga duka' Maria dio olona indo lokko'. ");
INSERT INTO ptu_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Tappana illaanni allo Katohhoam masiäna indo kadadiam ia too, iya le'ba'im kapala sando sola to illaam kakalebuanna Parisi umpellambi'i Pilatus ");
INSERT INTO ptu_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","anna nauaanni: “O tuam, kikilalai tula'na indo to umbaba bulim hupatau, deem naua indo anna tubopi: ‘Illaam allo katallunna la tibangonnä' sule.’ ");
INSERT INTO ptu_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Dadi kela mala anna ussuako tau unjagai indo lokko' sule lako allo katallunna. Aka maka' tä' la dipateem, iya la sule too passikolanna anna nabokoi indo bakkena mane nauai lako tau buda: ‘Tubom sule.’ Nasuhum la tuttuam buda pole' tau dibaba bulim inde la ditingngajona anna la indo lessu'na.” ");
INSERT INTO ptu_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Natimba' Pilatus naua: “Pasolaia' sanaka-naka sohodadu anna le'ba'koa' sola unjagai manappai indo lokko'na.” ");
INSERT INTO ptu_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Iya le'ba'im lako indo lokko' anna napadekke'i mesa tanda indo batu ditutu'iam anna mala naissam ke deenni untungka'i. Anna najagai polepi ba'bana, aka naua deem manii tau untungka'i. ");
INSERT INTO ptu_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Tappana lessu' allo Katohhoam, la tibukka' kalei baja allo Minggu, iya le'ba'um Maria Magdalena anna mesa solana isanga duka' Maria lao umpetua' indo lokko'. ");
INSERT INTO ptu_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Wattu eta too pissananna toko dadi lino' kasalle. Aka tuhum mesa malaika'na Debata yabo mai suhuga anna nalolinni lao indo batu pelapa'na anna muokko'i yabona. ");
INSERT INTO ptu_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Indo malaika' pangkähhä susi kila' lindona anna mabusa susi kapa' jubana. ");
INSERT INTO ptu_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Anna indo to unjagai indo lokko' sangngim lumalla' mahea' lambi' sikalentem bäbä anggasanna to mate. ");
INSERT INTO ptu_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Sulena lako indo baine, tappa napa'kadai indo malaika' naua: “Daa ummahea'a'! Aka setonganna kuissam kuua sulekoa' umpeä Puang Yesus indo to puha dipäso' yabo kaju sitambem. ");
INSERT INTO ptu_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Sapo' pa'dem inde, aka puham tubo sule umba susi puha natula' loppo' yolona. Maikoa' anna umpetua'ia' indo ongeanna dipandam. ");
INSERT INTO ptu_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Pasihha'ia' le'ba' anna umpaissanni ingganna passikolanna muua: ‘Tubom sule Puang Yesus dio mai alla'na to mate anna le'ba'um lako Galilea napendioloikoa'. Diopi mane silambi'koa'.’ Pengkilalaia' inde tula' puha kuuaangkoa'.” ");
INSERT INTO ptu_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Napasihha' siaham indo baine umpellei indo lokko' la diua mahea' anna tilalla' ohi, anna kumondäi lao la umpa'paissangam kaha-kaha ia too lako ingganna passikolanna Puang Yesus. ");
INSERT INTO ptu_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Lakoi lalam, tappa napellambi'i siaham Puang Yesus anna nauai: “Sitammukia'!” Iya bassim uhhopäi siaham Puang Yesus anna nakalapu'i bitti'na napasindum napenombai. ");
INSERT INTO ptu_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Nauaammi Puang Yesus: “Daa ummahea', sapo' laokoa' paissannii ingganna solasubungku, anna mala le'ba'i lako Galilea. Diopi mane siitakam.” ");
INSERT INTO ptu_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Lessu'i indo baine, iya le'ba'um duka' tama kota Yerusalem indo to unjagai lokko'na Puang Yesus anna natula'i lako kapala sando ingganna indo kaha-kaha puha dadi. ");
INSERT INTO ptu_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Iya sipattuju-tuju siaham indo kapala sando sola matua ulunna to Yahudi. Sahandanni kadanna, iya umbeemmi buda doi' indo sohodadu to unjagai lokko'na Puang Yesus, ");
INSERT INTO ptu_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","anna nauaanni: “Uakoa': ‘Indo bakkena Puang Yesus sule naala bengi passikolanna tappana mamma'kam.’ ");
INSERT INTO ptu_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Pissananna hi manii anna naissanni gubernur kaha-kaha ia too, kipa'tula'i manappa ham anna mala tä'koa' naaka.” ");
INSERT INTO ptu_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Iya naalam duka' indo doi' anna napalako asanni pada indo dipakahi'diam. Nasuhum tula' iam too napalombum liu to Yahudi sule lako temo. ");
INSERT INTO ptu_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Puhai ia too, iya le'ba'um duka' indo sapulo mesapi passikolanna Puang Yesus lako mesa tanete dio Galilea indo puha natulasam loppo' Puang Yesus. ");
INSERT INTO ptu_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Tappana muita Puang Yesus, iya napenombai siaham. Sapo' deempi sanaka-naka solana bata-bata. ");
INSERT INTO ptu_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Iya napengkahuku'im Puang Yesus anna nauaanni: “Ingganna kakuasaam susi yabo suhuga teem illaam inde lino puha asammi dipadokkoannä' lisu pala'ku. ");
INSERT INTO ptu_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Dadi la le'ba'koa' umpellambi'i asam hupatau sule lako lili'-lili'na lino anna umpadadiia' passikolangku. Tedo'ia' sola sanganna Ambe', Änä'na, anna Penaba Maseho, ");
INSERT INTO ptu_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","anna umpa'guhuia' umpalako ingganna indo puha kupahentaangkoa'. Anna la umpengkilalaia', la tontä liuä' too manontom muundu'koa' sule lako allo ma'katampasanna.” ");
INSERT INTO ptu_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Iam too inde pa'pahandusanna Kaheba Katilallasam diona Yesus Kristus Änä'na Puang Allataala. ");
INSERT INTO ptu_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Deem tisuha' illaam suha'na nabi Yesaya naua: “Indem ia pesuaku kupake'de' la umpendioloangangko aka iam too to la umpatokaangko lalam. ");
INSERT INTO ptu_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","La dio pohiallasam metamba-tamba naua: ‘Patokaanni lalam Debata, maloloanganni lalam la naolanna.’” ");
INSERT INTO ptu_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Iam too nakähä Yohanes to si mantedo' anna mengke'de'i dio pohiallasam anna umpalanda' kadanna Puang Allataala naua: “Tihokongannia' ingganna kasalaammu ammu behoia' kalemu ditedo', anna mala naampunniangkoa' dosamu Puang Allataala.” ");
INSERT INTO ptu_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Iya sulem buda tau buttu dio mai lembäna Yudea anna Yerusalem umpellambi'i Yohanes. Sangngim muakui dosana anna natedo'i dio Salu Yordan. ");
INSERT INTO ptu_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Indo Yohanes to si mantedo' umpa'poheba bulu unta anna ma'beke' lollo'. Anna bati' sola duho si naande. ");
INSERT INTO ptu_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Anna si napa'pakahebaam naua: “Lessu'ä' too, iya la deemmi sule to kuasa puha Ia anna la kao, aka moi la ma'balinguntu'ä' dio olona umbukkaianni pekapu' sapatunna, tala sihatannä'. ");
INSERT INTO ptu_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Anna kao-kao uwai kupake untedo'koa'. Sapo' Ia-Ia Penaba Maseho la napake natedosangkoa'.” ");
INSERT INTO ptu_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Wattu eta too sule Puang Yesus dio mai tondä' Nazaret dio lembäna Galilea, iya natedo'um Yohanes dio Salu Yordan. ");
INSERT INTO ptu_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Tappana kende' dio mai uwai, naitam tibukka langi' anna tuhunni Penaba Maseho susi dangam-dangam uhhampoi. ");
INSERT INTO ptu_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Anna dihingngi siaham kamaha buttu yabo mai suhuga naua: “Ikom too inde änä' pa'pakamajangku to umpomasannam penabangku.” ");
INSERT INTO ptu_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Puhanna ia too natettem Penaba Maseho Puang Yesus lako pohiallasam. ");
INSERT INTO ptu_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Iya tohhom dio appa' pulo benginna napa'sändä'i tomahajanna setam. Wattu eta too illaam alla' olo'-olo' to peande Puang Yesus anna buda duka' malaika' muolaanni. ");
INSERT INTO ptu_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Puhai ditahungkum Yohanes, iya le'ba'um Puang Yesus lako Galilea umpa'pakahebaam Kaheba Katilallasam buttu yabo mai Puang Allataala. ");
INSERT INTO ptu_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Naua: “Lambi'um wattunna la umpalako kapahentaanna Puang Allataala. Pengkatoba'koa' ammu katappa'i Kaheba Katilallasam.” ");
INSERT INTO ptu_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Mahassanni mellao Puang Yesus uhhuttu' bihinna le'bo' Galilea, iya muitam to sipoadi isanga Simon anna Andreas mahassam modala aka abana inna to si modala. ");
INSERT INTO ptu_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Napa'kadaim naua: “Maikoa' ammu tuhu'ä' aka la kupadadikoa' to undala hupatau anna mala natuhu'ä'.” ");
INSERT INTO ptu_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Iya ullappa' siaham duka' dalana anna le'ba'i untuhu' Puang Yesus. ");
INSERT INTO ptu_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Napatahhu' oom mellao, iya tä'pi mambela naola anna muita oom to ma'solasubum isanga Yakobus anna Yohanes änä'na Zebedeus mahassam umpapiai dalana illaam lopi. ");
INSERT INTO ptu_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Natambai oom Puang Yesus iya mengkalao siaham umpellei ambena illaam lopi sola ingganna to mengkähäna anna le'ba'i natuhu'. ");
INSERT INTO ptu_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Landa'um Puang Yesus sola passikolanna lako Kapernaum. Tappana lambi' allo Katohhoam, le'ba'um Puang Yesus tama pa'sambajanganna to Yahudi anna ma'pa'guhui. ");
INSERT INTO ptu_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Iya sangngim mängä-mängä tau uhhingngii pepa'guhuanna, aka tä' ia ma'pa'guhu susi indo to ullatta' Pepaondonganna Musa. Sapo' ma'pa'guhu Ia Puang Yesus sitonda kakuasaam. ");
INSERT INTO ptu_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Siampu' eta too illaam indo pa'sambajangam, deem mesa tau napentamai setam. Indo tau kaoli-oli naua: ");
INSERT INTO ptu_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“O Yesus to Nazaret, la muaka hakam kami'? Abana isanga suleko la ungkadakeikam? Aka kuissam kuua iko To Masehoko buttu di Puang Allataala.” ");
INSERT INTO ptu_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Sapo' tappa nakuapai Puang Yesus naua: “Pengkamma'ko, pessubungko illaam mai kalena itim tau.” ");
INSERT INTO ptu_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Indo setam undodä' yolo indo tau mane messubunni napasindum kumissä'. ");
INSERT INTO ptu_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Tä' deem pada sanakamängä-mängäi tau buda, napolalam sipa'tula'-tula' naua: “Aka hia isanga indea'i anna malai umpahe' ingganna setam nasua lao? Mesa pepa'guhuam bakahu ponno kakuasaam!” ");
INSERT INTO ptu_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Napolalam tappa molele-lele kaheba diona Puang Yesus illaam lembäna Galilea. ");
INSERT INTO ptu_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Messubunna illaam mai pa'sambajangam, le'ba'um Puang Yesus sola Yakobus anna Yohanes lako banuanna Simon sola Andreas. ");
INSERT INTO ptu_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Sulei lako, iya ullambi'um pasananna Simon baine, mahassam metindo aka lumalla'. Natulasam siaham sakinna lako Puang Yesus. ");
INSERT INTO ptu_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Iya le'ba' siahanni lako ongeanna indo baine, naanda'i limanna anna nabangonganni, iya tappa masapu eta siaham sakinna anna tappa nabela ma'tahia. ");
INSERT INTO ptu_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Tappana lendu' allo, le'ba'im tau lako Puang Yesus umpasola ingganna to masakinna anna to napentamai setam. ");
INSERT INTO ptu_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Tapakala anna ma'silullu'um pa'tondä' dio olo ba'ba. ");
INSERT INTO ptu_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Iya buda tau napabono' eta too, to ussi'dim ma'hupa-hupa saki anna buda setam nahambai. Anna tä' napäbäi indo setam ma'kada-kada aka sangngim naissam naua Puang Yesus-um too indo To dilanti' la mepasalama'. ");
INSERT INTO ptu_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Makale'na mane nannahi anna bangommi Puang Yesus anna le'ba'i lako ongeam mabuni-buninna ma'sambajam. ");
INSERT INTO ptu_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Sapo' le'ba' nahuttu' Simon sola solana. ");
INSERT INTO ptu_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Tappana nalambi' nauaammi: “O Tuangguhu nasipeä-peäiko tau.” ");
INSERT INTO ptu_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Sapo' natimba' naua: “La lu lako opakia' ongeam senga' lako inde botto sikahuku'ta, anna mala kupa'guhu duka' to eta diona Kaheba Katilallasam, aka iam too kutungka sule.” ");
INSERT INTO ptu_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Iya ulleleim pa'sambajanganna to Yahudi dio lembäna Galilea umpa'paissangam Kaheba Katilallasam anna buda duka' setam nahambai. ");
INSERT INTO ptu_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Pissam wattu, deem mesa to dolengam sule umpellambi'i Puang Yesus anna ma'balinguntu'i dio olona anna nauai: “Kuissam kuua malaä' umpabono' ke umpoelo'i.” ");
INSERT INTO ptu_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Iya tappa tigaha' penabanna aka häntä buana, lambi' uhhaka' indo tau anna nauai: “Maelo'ä', bono'ungko!” ");
INSERT INTO ptu_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Iya masapu eta siahanni sakinna. ");
INSERT INTO ptu_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Tappa nasua le'ba' anna napakahi'dii ");
INSERT INTO ptu_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","naua: “Pengkilalai manappai le, tä' too la mala untulasam tau senga' inde pa'pogau'ku. Sapo' la le'ba'ko umpa'paitaam kalemu lako sando anna la umbabako bua pemala'mu, umba susi puha napepaondongam Musa. Aka la mendadi tanda lako tau buda diona kabonosammu.” ");
INSERT INTO ptu_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Sapo' indo tau le'ba' dia napalele diona ia too, anna natula' lako dio mai nasuhum tä'um pole' si ändä-ändängam Puang Yesus mentama kota, angga hanni tohho lako ongeam kasala-salaanna. Sapo' moi anna susi, tä' siam duka' kattu sule tau umpellambi'i dio mai ingganna ongeam. ");
INSERT INTO ptu_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Pissananna lessu'i sanaka amo benginna, sule pole oom Puang Yesus lako kota Kapernaum. Iya napelele siaham issinna kota kasuleanna dio indo banua. ");
INSERT INTO ptu_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Iya sule siahanni tau ma'silullu' ullombai lambi' sisippi'-sippi' illaam indo banua anna pihi' sule lako olo ba'ba napobua' tau buda. Iya ma'tula'um Puang Yesus umpalanda' kadanna Puang Allataala. ");
INSERT INTO ptu_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Mahassanni ma'tula', sule pole ohanni sanaka-naka tau umpasola mesa to mate kalena appa' tau umbullei. ");
INSERT INTO ptu_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Sapo' tä' deem naola umbabai lako olona Puang Yesus aka nalabai tau buda. Iya lu längännim ia papa anna naso'boii sipatunna Puang Yesus mane nalollohanni dokko olona indo to mate kalena sitonda ampa'na. ");
INSERT INTO ptu_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Tappana naita Puang Yesus kamatappasannai, iya ma'kadam lako indo to mate kalena naua: “O änä'ku, diampunnim dosamu.” ");
INSERT INTO ptu_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Sapo' eta too, dio duka' heem sanaka-naka to ullatta' Pepaondonganna Musa. Iya nauaim illaam penabanna: ");
INSERT INTO ptu_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Akanna deenni tau ma'kada susi? Aka hia umbai' anna muangga'i kalena sipadaam Puang Allataala? Aka tä' deem tau moi podo la mesa la mala muampunni dosa, sulibanna Puang Allataala!” ");
INSERT INTO ptu_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Sapo' tappa nalosa Puang Yesus issi penabanna indo to ullatta' Pepaondonganna Musa. Iya ma'kadam Puang Yesus naua: “Akanna ma'pikki' susi hakoa' iko? ");
INSERT INTO ptu_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Mennaka la madomi' dadi lako inde to mate kalena, ke diuaanni: ‘Diampunniammoko dosamu;’ anna la diuaam: ‘Bangongko, äkä'ko ampa'mu ammu pellao’? ");
INSERT INTO ptu_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Sapo' la kupa'patandaam temo anna malaia' ungkaleso manappa muua illaam inde lino kuasaä' To diuaam Änä' Mentolino muampunni dosa.” Mane ma'kadai lako indo to mate kalena naua: ");
INSERT INTO ptu_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Bangongko, babai ampa'mu ammu le'ba' lako banuammu!” ");
INSERT INTO ptu_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Iya bangom siaham indo to mate kalena muäkä' ampa'na anna messubunni naita indo tau buda. Iya sangngim pilla' to muitai anna umpa'kasallei Puang Allataala naua: “Maneanna si'da pole' diita inde susi.” ");
INSERT INTO ptu_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Puhai ia too le'ba' oom Puang Yesus lako bihinna le'bo' Galilea. Eta too buda oom tau sule untammui iya napa'guhum. ");
INSERT INTO ptu_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Pissananna mahassam oi mellao, iya muitam mesa tuam passima isanga Lewi änä'na Alfeus muokko' illaam kätto'na. Napa'kadaim Puang Yesus naua: “Maiko anna untuhu'ä'.” Iya ke'de'um duka' anna le'ba'i natuhu'. ");
INSERT INTO ptu_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Mahassanni mangngande Puang Yesus sola passikolanna dio banuanna Lewi, iya deem duka' sanaka-naka tuam passima sola tau senga' sola-sola mangngande, aka budam tau susi untuhu'i. Ingganna indo to sule si nasangai to Yahudi to madosa. ");
INSERT INTO ptu_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Tappana naita sanaka-naka to ullatta' Pepaondonganna Musa to mentama kakalebuanna Parisi, ma'kadam lako passikolanna Puang Yesus naua: “Akanna naakui tuangguhummua' sola-sola mangngande tuam passima anna to madosa senga'?” ");
INSERT INTO ptu_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Sapo' nahingngi Puang Yesus indo pekutanaanna, iya natimba'um naua: “Tä' tia deem to bono' umpahalluam tuandotto', anggam tia to masaki. Kao-kao suleä' inde lino taia to ussanga kalena malolo la kutambai, sapo' suleä' untambai to madosa.” ");
INSERT INTO ptu_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Pissam wattu mahassanni puasa passikolanna Yohanes anna passikolanna to illaam kakalebuanna Parisi. Iya sulem tau umpellambi'i Puang Yesus anna mekutanai naua: “Maaka hia anna puasai ia passikolanna Yohanes sola passikolanna to illaam kakalebuanna Parisi anna tä' ia passikolammu?” ");
INSERT INTO ptu_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Natimba'im umpake pehapangam naua: “Aka la deem daka tia to ullomba kakabengam tä' la mangngande ke diopi heem indo to mane dipakebaine? Mannassa anna tä'i deem! ");
INSERT INTO ptu_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Sapo' la deem wattunna indo to mane dipakebaine la diäläi illaam mai alla'-alla'na to ullombai. Iya etapi too pole' mane puasai. ");
INSERT INTO ptu_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Tä' tia deem tau la umpopetampi' sampim bakahu lako poheba malusa, aka tingkahussui too indo sampim bakahu, iya tuttuam kalua'um sesse'na indo poheba malusa. ");
INSERT INTO ptu_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Susi toi duka' tä' tia deem tau la muala anggur bakahu anna napatamai pa'pongngeam malusa. Aka indo anggur bakahu mala untesseam pa'pongngeam malusa. Iya katampasanna bassim labu'. Dadi anggur bakahu manggi' duka' dipalutama pa'pongngeam bakahu.” ");
INSERT INTO ptu_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Pissam wattu illaam allo Katohhoam umpa'tängäi bela' gandum Puang Yesus sola passikolanna. Mahassam siam mellao napasindum siam ia passikolanna muala gandum. ");
INSERT INTO ptu_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Iya ma'kadam sanaka-naka to illaam kakalebuanna Parisi lako Puang Yesus naua: “Petua'pi inde lako passikolammu, maaka hia anna untekkai pelahangam illaam peadasam umpogau' tala malanna dikähä illaam allo Katohhoam?” ");
INSERT INTO ptu_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","26","Natimba'im naua: “Tä'paka' tiko deem umbata diona pa'pogau'na Daud indo anna tadea'i wattunna Abyatar muanda'i babanganna sando too'? Wattu eta too le'ba' Daud tama bahum kapenombaam anna naandei indo hoti puha dipehumalasam mane nabeenni duka' lako pentuhu'na, moi kela daa anggam tia sando mala muandei. ");
INSERT INTO ptu_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Aka allo Katohhoam dipadeem la napakeguna hupatau, taia hupatau la napakeguna allo Katohhoam. ");
INSERT INTO ptu_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Setonganna Kao hia Änä' Mentolino puäna allo Katohhoam.” ");
INSERT INTO ptu_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Pissam wattu tama oom pa'sambajanganna to Yahudi Puang Yesus. Illaam indo pa'sambajangam deem mesa tau mate limanna sabali. ");
INSERT INTO ptu_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Eta too deem sanaka-naka tau maelo' umpeängam tuntungam su'be' Puang Yesus, iya napaolamata lium aka nauai: “Umba ke toko umpabono'i indo to masaki illaam allo Katohhoam anna mala deem dipa'palu'bi'i.” ");
INSERT INTO ptu_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Pissananna ma'kadam Puang Yesus lako indo to mate limanna sabali, naua: “Ke'de'ko illaam inde tängä-tängäna tau.” ");
INSERT INTO ptu_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Anna mane mekutana lako tau buda naua: “Umbanna la sihatam dipogau' ke illaanni allo Katohhoam, kamapiaam daka, kakadakeam daka? La umpesäkäi hakika solata, la dipatei haka?” Sapo' tä' deem tau mentimba' moi podo la mesa. ");
INSERT INTO ptu_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Iya keaha'um Puang Yesus lako to illaam kakalebuanna Parisi, sapo' häntä ohi buana aka tää'i ungkamasei solana. Unnenne'i asammi indo tau buda anna mane ma'kada lako indo to mate limanna naua: “Äkä'i limammu!” Iya muäkä'um duka' limanna, iya tappa bono' eta siaham. ");
INSERT INTO ptu_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Tappa messubunni siaham indo to illaam kakalebuanna Parisi anna le'ba'i sipattuju to muundu'i tomahaja Herodes la naaka susi anna mala dipatei Puang Yesus. ");
INSERT INTO ptu_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Lessu'na ia too muäläim kalena Puang Yesus sola passikolanna lu lako le'bo' Galilea. Iya buda tau muula'i, to buttu dio mai Galilea anna dio mai Yudea. ");
INSERT INTO ptu_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Susi duka' yabo mai Yerusalem, Idumea, dipe mai lambam libanna Salu Yordan tandai mata allo, dio mai lembäna Tirus anna lembäna Sidon. Aka napeleleim ingganna indo puha napogau' Puang Yesus. ");
INSERT INTO ptu_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Ussuam passikolanna napatokaam lopi la naongei aka indana nasisippi'-sippi'i tau buda. ");
INSERT INTO ptu_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Aka ingganna to masaki ma'silullu' lako sa'dena maelo' asam muantii aka budam napabono'. ");
INSERT INTO ptu_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Anna ingganna to napentamai setam muitanna Puang Yesus tappa menomba dio olona anna metambai naua: “Ikom too Änä'na Puang Allataala!” ");
INSERT INTO ptu_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Sapo' indo ingganna setam tä' si'da-si'da napäbäi Puang Yesus la naua pole susi indo to naua ingngena'. ");
INSERT INTO ptu_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Puhai, lu längämmi tanete Puang Yesus anna untambai tau pada indo to napohäe. Iya suleim. ");
INSERT INTO ptu_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Napileim sapulo dua to la napasola lelem anna nauaanni: “Ikonna' too inde la mendadi pesuaku la umpa'paissangam Kaheba Katilallasam ");
INSERT INTO ptu_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","anna la kubeengkoa' kakuasaam uhhambai setam.” ");
INSERT INTO ptu_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","19","Indem ia sanganna indo to sapulo dua: Simon (si nauaam toi Puang Yesus Petrus) Yakobus anna Yohanes (bassim änä'na Zebedeus nasangai Boanerges, kalembasanna “peänäsanna guntu' yabo langi'”). Andreas Filipus Bartolomeus Matius Tomas Yakobus (änä'na Alfeus) Tadeus Simon to illaam kakalebuanna Zelot, Yudas Iskariot indo to la umbalu' Puang Yesus. ");
INSERT INTO ptu_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Puhanna ia too ma'pasulem Puang Yesus anna tamai banua. Iya ma'silullu' oom tau buda ullombai lambi' tä'um napempakalai mangngande sola passikolanna. ");
INSERT INTO ptu_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Iya nauam piha tau: “Tatta'um.” Iya nahingnginna kasahapuanna, le'ba' siaham natambai. ");
INSERT INTO ptu_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Eta too sule duka' sanaka-naka to ullatta' Pepaondonganna Musa yabo mai Yerusalem. Iya nauaim: “Kuasanna hi tia Beelzebul battu diua tomahajanna setam illaam kalena anna malai uhhambai lao setam.” ");
INSERT INTO ptu_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Iya natambaim Puang Yesus anna natulasanni pehapangam naua: “La maakam ia susi tomahajanna setam la uhhambai lao setam? ");
INSERT INTO ptu_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Aka to mesa kapahentaam la pantam lao anna la sibali-bali paka iai, tä' tia la mala manontom. ");
INSERT INTO ptu_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Susi duka' to sahapu illaam dapo'. Maka' tä' deem kakalebuanna, kasahapuam ia too la henggä. ");
INSERT INTO ptu_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Susi siam too duka' kapahentaanna setam. Maka' tä' deem kamesaanna anna anggam sipobali-bali, kapahentaam ia too tä' la masäe anna pa'dem. ");
INSERT INTO ptu_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Umba susi mesa to maboko mentama banuanna mesa to matoho la napabokoi la napungo hi tia yolo indo to matoho mane naalai indo la nabokona, susimä' too duka' kutaloi yolo tomahajanna setam anna mane kuhambai lao indo pentuhu'na. ");
INSERT INTO ptu_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Aka kutulasangkoa' temo kuua: ingganna hupanna dosa anna pantelle mala asam naampunni Puang Allataala, sulibanna untelle Penaba Maseho. ");
INSERT INTO ptu_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Sapo' to untelle Penaba Maseho tä'um ia la mala diampunni aka pa'pogausam ia too dipodosam ia sule lako salako-lakona.” ");
INSERT INTO ptu_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Ma'kada susi Puang Yesus aka deem tau untellei naua: “Napentamai setam.” ");
INSERT INTO ptu_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Puhai ia too sulem indona anna solasubunna Puang Yesus. Iya naampaim dio sulibam anna nauai: “Pa'kadaiannä' Puang Yesus.” ");
INSERT INTO ptu_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Wattu eta too buda tau muokko' umpali'i. Iya nauaammi: “O Tuangguhu, illaam sulibam indomu anna solasubummu napeäko!” ");
INSERT INTO ptu_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Natimba' naua: “Aka mennaa' iko diuaam indoku anna solasubungku?” ");
INSERT INTO ptu_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Mane napalelei mata indo to umpali'i anna nauai: “Indem ia mai diuaam indoku anna solasubungku ä. ");
INSERT INTO ptu_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Aka menna-menna umpalako pa'elo'na Puang Allataala, tau iam too sihhapam solasubungku anna indoku.” ");
INSERT INTO ptu_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Pissam wattu ma'pa'guhu oom Puang Yesus dio bihinna le'bo' Galilea. Iya sulem buda tau ma'silullu' ullombai nasuhum tä'um ia deem naongei napobua' tau buda. Iya lu längämmi Ia lopi illaam le'bo' anna muokko'i. Anna yabo ia galantangam tau buda. ");
INSERT INTO ptu_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Iya umpalaom buda pepa'guhuam sapo' natula' umpake pehapangam. Ma'kada naua: ");
INSERT INTO ptu_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Pehingngiia', deem mesa tau le'ba' mangngambo'. ");
INSERT INTO ptu_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Tappana naambo' indo bannena, iya deemmi sabaheam tappa lako lalam. Iya suleim dassi naande sampe puha. ");
INSERT INTO ptu_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Deem tappa lako bobom batu, nasuhum masimpam tubo aka manipi' litä'na. ");
INSERT INTO ptu_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Sapo' tappana naalloi, iya malasso siaham nasuhum mabangi aka tä' mandalam waka'na. ");
INSERT INTO ptu_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Deem toi tappa lako alla' kuhha keduhi. Tappana tuttuam mahombo indo kuhha, iya umpissim indo tanangam nasuhum tä' mala kembua. ");
INSERT INTO ptu_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Anna sabaheam tappa lako litä' malompo. Iya mapi'dä' ia tubona nasuhum kembua tiluppi'-luppi'. Deem tiluppi' tallu pulo, deem tiluppi' annam pulo, anna deem tiluppi' sahatu'.” ");
INSERT INTO ptu_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Puhai ia too nauam Puang Yesus: “Lako ingganna ma'hupatau pahallu la umpatanam talinganna umpalempe sulim patomalinna anna napaillaam penabai inde tula'ku!” ");
INSERT INTO ptu_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Tappana angga ham Puang Yesus sola pentuhu'na anna sapulo dua pesuana, iya mekutanaim naua: “Aka hia kalembasanna indo pehapangam ingngena'?” ");
INSERT INTO ptu_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Iya natimba'im naua: “Angganna' iko dipaissanni indo kada ditambim diona kapahentaanna Puang Allataala. Sapo' ditula' pehapangam ia lako tau senga'. ");
INSERT INTO ptu_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Anna mala: ‘Moi la naita, tala naalai akkalanna, moi la nahingngi, tä' siam la naissam napekalembasam. Aka ma'pasule manii anna naampunnii Puang Allataala.’” ");
INSERT INTO ptu_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Mane nauai: “Tä' daka tiko muissanna' inde pehapangam? Aka maka' susi, iya la tä' dia' too muissam pehapangam senga'. ");
INSERT INTO ptu_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Indo to mangngambo' dipasihhapam to untula' Battakadanna Puang Allataala. ");
INSERT INTO ptu_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Banne tappa lako lalam dipasihhapam to uhhingngi Battakadanna Puang Allataala sapo' nahappai siam tomahajanna setam. ");
INSERT INTO ptu_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Banne tappa lako bobom batu, dipasihhapam ia to uhhingngi Battakadanna Puang Allataala anna tappa natahima sola ponno penaba. ");
INSERT INTO ptu_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Sapo' tä' siam masäe aka tä' kewwaka' illaam kalena. Deenna too kamasussaam anna pandahhaam uhhuai aka untuhu'i Battakadanna Puang Allataala, iya soho' boko' siaham. ");
INSERT INTO ptu_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","19","Banne tappa tama alla' kuhha keduhi dipasihhapam ia to uhhingngi Battakadanna Puang Allataala sapo' anggam malallam umpikki' salu katuboanna. Iya napakalandom ia kulle, muula' dam ia kamohäeanna lako ingganna-ingganna sia, ungkalembeim ia Battakadanna Puang Allataala nasuhum tä' mala kembua. ");
INSERT INTO ptu_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Anna banne tappa lako litä' malompo dipasihhapam ia to uhhingngi Battakadanna Puang Allataala anna natahima mapiai nasuhum kembua tiluppi'-luppi'. Deem tiluppi' tallu pulo, deem tiluppi' annam pulo, anna deem tiluppi' sahatu'.” ");
INSERT INTO ptu_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Iya ma'kada oom Puang Yesus lako tau buda naua: “Tä' tia deem tau la umpau' lampu anna nasalongo'i baka battu diua napadio ibi' sahigam sapo' napayabo hi tia inna ongeanna. ");
INSERT INTO ptu_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Anna mala tä' deem aka-aka la tibuni sapo' la dipatandaam asam anna tä' deem aka la disamboi sapo' la dipakaleängam asam. ");
INSERT INTO ptu_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Lako ingganna ma'hupatau pahallu la umpatanam talinganna umpalempe sulim patomalinna anna napaillaam penabai inde tula'ku! ");
INSERT INTO ptu_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Dadi pehingngii manappaia' inde pepatuduangku! Aka maka' deem kamohäeammu umpehingngii Battakadanna Puang Allataala la nahängänniam polepoko Puang Allataala. ");
INSERT INTO ptu_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Aka menna-menna umpaillaam penabai, tau ia too la dihängänniam polepi kapaissanganna. Sapo' to moka umpaillaam penabai, iya la diäläi pissam ia lao indo kapaissangam nasanga deemmi illaam kalena.” ");
INSERT INTO ptu_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Umpatahhu' liupi pepa'guhuanna Puang Yesus naua: “Kapahentaanna Puang Allataala sihhapam to muambo' banne lako litä'. ");
INSERT INTO ptu_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","28","Puhai naambo' napelleim lao. Iya napahandu'um mukku', lobo', kendaum, kembua, sule lako kessi, tä' ia naissam indo to mangngambo' aka abana inna litä' ia umpatuboi. ");
INSERT INTO ptu_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Tappana matäsä' buana, iya sulem indo puäna anna nakandaoi aka lambi'um wattunna dipepahe.” ");
INSERT INTO ptu_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Ma'kada pole oom Puang Yesus naua: “Akam la dipasihhapangam kapahentaanna Puang Allataala? ");
INSERT INTO ptu_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Kapahentaanna Puang Allataala sihhapam mesa lise'na sesawi ditanam lako bela'. Ingganna tanangam ma'lise', lise'nam kaju sesawi handam bahinni'. ");
INSERT INTO ptu_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Sapo' tappana ditanam dio bela', iya tubom dio mai mahombo lambi' kasalle ia anna la tanangam senga' illaam bela', nasuhum mala naongei dassi ma'sehä täkena aka kationgam.” ");
INSERT INTO ptu_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Susim too Puang Yesus umpalanda' kadanna Puang Allataala sola ma'hupa-hupa pehapangam la malanna naissam to uhhingngii. ");
INSERT INTO ptu_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Dadi tä' deem si ma'tula' senga' ke tä'i nababa illaam pehapangam. Anna maka' lu lako mandi passikolanna si napomasiä' si mesa ia. ");
INSERT INTO ptu_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Kahubenni indo allo eta too, ma'kada oom lako passikolanna naua: “Maikoa' anna ma'lopikia' lambam libam inde le'bo'.” ");
INSERT INTO ptu_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Iya umpelleim tau buda anna ma'mesai längäm indo lopi naongei muokko' Puang Yesus ingngena' aka la napasola lao. Yabo asanni, iya mengkalaom, anna budapi lopi senga' untuhu'i. ");
INSERT INTO ptu_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Sapo' tä'pi mambela-bela naola, anna sule ham hibu' tatta' sitonda bombam kasalle untappi indo lopinna, napolalam nasopa'i uwai, iya saidi' tatallam. ");
INSERT INTO ptu_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Wattu eta too mahassam Ia mamma' Puang Yesus dio ampa' illau' tämpä'na lopi. Iya natundammi napasindum naua: “O Tuangguhu akanna ma'lembe-lembe hako Iko? Moi kela daa la tallammakia'.” ");
INSERT INTO ptu_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Iya bangommi duka' anna umpamattanni indo hibu' tatta' anna mane ma'kada tama le'bo' naua: “Hapa'ko, mattangko!” Iya mattam siaham indo hibu' tatta' anna hapa' indo bombam sampe malino siaham indo le'bo'. ");
INSERT INTO ptu_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Puhai ia too ma'kadam lako passikolanna naua: “Akanna mahea' sugali' hakoa' iko? Tä' liu pokoka' tiko uhhannuannä'?” ");
INSERT INTO ptu_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Iya silelem mängä-mängä anna mane sipa'tula'-tula' naua: “Tau menna hia isanga inde! Aka moi hibu' sola bombam mala toi napahe'!” ");
INSERT INTO ptu_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Puhai ia too, iya landa'um Puang Yesus sola passikolanna libam bihinna le'bo' Galilea dio attasa'na to Gerasa. ");
INSERT INTO ptu_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Ia sia tuhunna Puang Yesus yabo mai lopi, iya napellambi'im mesa to napentamai setam, buttu dio mai ku'bu'. ");
INSERT INTO ptu_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Indo tau sitohho lakom ku'bu', anna tä'um mala disäke', aka moi hante bassi nakattu-kattu toi. ");
INSERT INTO ptu_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Aka deemmi si nasändä' tau nasangkala anna nahante bassii sapo' nakattu-kattu indo hante bassi anna napolo-polo indo sangkala. Iam too anna nasoho'i asammi tau. ");
INSERT INTO ptu_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Allo bengi si ussambai ku'bu' anna tanete-nete napasindum kaoli-oli, anna si untuttu'i kalena batu lambi' basa-basa. ");
INSERT INTO ptu_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Tappana muita mambela Puang Yesus tuhum yabo mai lopi, iya lumumpa'um napellambi'i anna menombai dio olona. ");
INSERT INTO ptu_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Iya ma'kadam Puang Yesus lako indo setam illaam kalena indo tau naua: “Pessubungko lao setam!” Iya kumissä' gegem anna meolii naua: “O Yesus Änä'na Puang Allataala To Handam Matande, la muaka hä' kao? Pa'pindaiko Puang Allataala keta tä'i la undahhaä'.” ");
INSERT INTO ptu_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Iya nakutanaim Puang Yesus naua: “Aka sangammu?” Natimba'um naua: “Isangaä' Legion aka budakam.” ");
INSERT INTO ptu_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Iya napa'sule-suleim mengkahumase-mase lako Puang Yesus anna napelaui naua: “Kela mala anna tä'kanni uhhambai lako lembä senga'.” ");
INSERT INTO ptu_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Sikahuku' indo ongeam naongei deem buda babi mahassam menduhu' lako pili' tanete. ");
INSERT INTO ptu_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Iya napelaum indo setam lako Puang Yesus naua: “Kela mala ussua tamakam kalena inde lako babi.” ");
INSERT INTO ptu_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Napatuhu'im duka' Puang Yesus pelauanna, iya messubum siaham illaam mai kalena indo tau anna umpentamai indo babi buda. Pissananna ham ia sikakondä indo babi buda untobängam bäbä kalena dokko kumila' tahhu' dokko le'bo', lambi' mate asam napusa'i uwai (umbai' deem la dua sa'bu budanna). ");
INSERT INTO ptu_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Iya sikalumpa'um le'ba' indo to unjagai babi napalele diona kaha-kaha ia too lako kota anna tondä' sikahuku'na. Iya le'ba'im duka' tau umpetua'i kadadiam ia too. ");
INSERT INTO ptu_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Sulei lako Puang Yesus indo tau, iya ullambi'um indo to bali napentamai setam mahassam muokko' anna ma'pohebam pole', aka malinom. Sangngim mahea'um tau muitai. ");
INSERT INTO ptu_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Ingganna to muitai umpa'tulasam indo to sule maaka susi indo to napentamai setam ingngena' anna indo babi buda. ");
INSERT INTO ptu_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Iya napelaum indo pa'botto lako Puang Yesus naua: “Kela mala anna tä'ko inde bottoki.” ");
INSERT INTO ptu_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","La längänni lopi Puang Yesus, iya napelaum indo to bali napentamai setam naua: “O Tuangguhu, mala haka ke umpasolaä' kao?” ");
INSERT INTO ptu_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Sapo' tä' napäbäi, anggam nauaam: “Pa'pasuleko lako tondä'mu anna untulasanni kasahapuammu anna satondä'mu indo puha napogausangko Debata, anna maaka susi pa'kamasena Debata tama kalemu.” ");
INSERT INTO ptu_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Iya le'ba'um indo tau anna natula'i illaam lembäna Sapulo Kota indo puha napogau' Puang Yesus tama kalena. Iya sangngim pilla' tau uhhingngii. ");
INSERT INTO ptu_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Tappana lambam Puang Yesus anna passikolanna ma'pasule, iya ma'silullu' oom tau ulleboi dio bihim le'bo'. ");
INSERT INTO ptu_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Iya sulem duka' mesa tau isanga Yairus. Tau ia too mesa to pebaba illaam pa'sambajanganna to Yahudi dio kota eta too. Muitanna Puang Yesus, iya sule siaham menomba dio olona anna ");
INSERT INTO ptu_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","mengkahumase-masei melau naua: “Deem mesa änä'ku baine mahassam masaki masanta' sapo' kela malako laoki' sola anna uhhaka'i anna mala bono'.” ");
INSERT INTO ptu_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Iya le'ba' siaham sola Yairus. Buda tau untuhu'i nasisippi'-sippi'i. ");
INSERT INTO ptu_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Sapo' illaam alla'-alla'na indo tau buda, deem mesa baine sapulo duam taunna nahua saki baine tä' deem monda. ");
INSERT INTO ptu_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Budam tuandotto' naongei ma'pakuli, iya puha mandam kullena napopamaja' sapo' tä' deem moi podo la mesam mala umpabono'i. Tuttuam kehängäm mandi sakinna. ");
INSERT INTO ptu_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Baine ia too pembudam uhhingngi tanda memängä-mängä si napogau' Puang Yesus. Iya umpealla'um tau buda anna umpengkahuku'i boko'na Puang Yesus ");
INSERT INTO ptu_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","aka naua: “Assala'na mala moi podo kuantim bajunna, iya la malamä' bono'.” ");
INSERT INTO ptu_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Iya naantinna bajunna, monda siaham sakinna anna maläppu'um nasi'dim. ");
INSERT INTO ptu_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Puhanna ia too, nasi'dim siaham Puang Yesus deem kuasa messubum illaam mai kalena. Iya menggihi'um lako boko'na anna mekutanai naua: “Menna hia muanti bajungku?” ");
INSERT INTO ptu_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Iya natimba'im passikolanna naua: “Muita haka inde mai tau mesisippi'-sippi'i, akanna mekutana ohako?” ");
INSERT INTO ptu_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Sapo' tontä umpalilim lao matanna umpeä indo to muantii bajunna. ");
INSERT INTO ptu_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Iya ussi'dingammi kalena indo baine to muantii, lambi' tappa lumalla' mahea' napasindum le'ba' lako olona menomba anna naakui naua: “O Tuangguhu, kao hi to kao muantiko aka maelo'ä' la bono'.” ");
INSERT INTO ptu_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Iya ma'kadam Puang Yesus lako indo baine naua: “O änä'ku, bono'ungko aka ungkatappa'iä'. Laongko, la naundu'ko masakke naapi' mahuhindim, aka bono' manappangko tia.” ");
INSERT INTO ptu_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Mahassampi ma'tula' anna sule hanni to untambai Yairus dio mai banuanna naua: “Indo änä'mu, matem. Damom too ussussai Tuangguhu.” ");
INSERT INTO ptu_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Tä' napehingngii Puang Yesus pada indo to ma'tula' anna ma'kadai lako Yairus naua: “Daa ummahea', pomanontonni kamatappasammu!” ");
INSERT INTO ptu_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Iya napatahhu' siam mellao sapo' anggam napäbäi untuhu'i Petrus anna indo to sipoadi Yakobus anna Yohanes. ");
INSERT INTO ptu_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Pissananna landa'i lako banuanna Yairus ullambi'um tau sikaoli muuhhu'. ");
INSERT INTO ptu_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Iya tamam banua Puang Yesus anna ma'kadai lako indo to sikauhhu' naua: “Daa ussahhoa' aka itim änä'-änä' tä' tia mate sapo' mamma' bäbä hi tia!” ");
INSERT INTO ptu_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Sapo' napetabai mandi. Iya nasuaim Puang Yesus messubum mane tamai tambinna indo to mate, anggam napasola indona sola ambena anna tallu passikolanna. ");
INSERT INTO ptu_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Sulena tama naanda'im limanna anna nauai: “Talita kum,” kalembasanna: O änä'ku, bangongko! ");
INSERT INTO ptu_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Iya tappa bangom siaham indo änä'-änä' anna kalao-laoi. (Indo änä'-änä' sapulo duam taunna.) Ingganna to muitai kadadiam ia too sangngim mängä-mängä. ");
INSERT INTO ptu_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Iya ma'pakahi'dim Puang Yesus lako indo to muitai naua: “Pissa'-pissa' ahanna' la untula' lako tau inde kadadiam.” Mane nauai: “Beennia' kinande.” ");
INSERT INTO ptu_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Iya umpelleim indo ongeam Puang Yesus anna lu lakoi tondä'na sola passikolanna. ");
INSERT INTO ptu_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Lambi'i allo Katohhoam napahandu'um Puang Yesus ma'pa'guhu illaam pa'sambajanganna to Yahudi. Eta too buda tau umpehingngii pepa'guhuanna. Sapo' mängä-mängä asam uhhingngii pepa'guhuanna aka naponnoi kuasa lambi' sipa'tula'-tula' naua: “Naala umba hia ngei isanga kamanähängam? Kakeakasam aka hia isanga illaam kalena? Maaka hia anna malai Ia umpapia tanda memängä-mängä? ");
INSERT INTO ptu_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Taia haka tia indo tukam kaju änä'na Maria, solasubunna Yakobus, Yoses, Yudas, anna Simon? Anna indo solasubunna baine sola-sola liukia' inde?” Ingganna to uhhingngii sangngim meali-ali nasuhum untumpu pala' Puang Yesus. ");
INSERT INTO ptu_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Iya ma'kadam Puang Yesus lako indo tau buda naua: “Mesa nabi dipa'kasallei ke lakoi ongeam senga', sapo' tä' ia dipa'kasallei ke illaanni botto litä'na, alla'-alla'na kasahapuanna anna illaam banuanna.” ");
INSERT INTO ptu_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Dadi tä'um umpogau' tanda memängä-mängä sulibanna uhhaka' sanaka-naka to masaki lambi' bono'. ");
INSERT INTO ptu_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Tä' deem pada samängä-mängä Puang Yesus muita satondä'na aka tä' nakatappa'i. 6:6-13 Iya le'ba'um Puang Yesus ullelei mobotto-bottoam napasindum ma'pa'guhu. ");
INSERT INTO ptu_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Untambai indo sapulo dua suhona anna nabeenni kakuasaam uhhambai setam, mane nasuai tungga' lao si dua. ");
INSERT INTO ptu_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","9","Anna napakahi'di naua: “Angganna' mala umbaba poheba illaam kalemu, tekkem, anna sapatummu. Sapo' tä'um ia la manggi'a' umbaba tinallo, ongeam tinallo, anna doi'.” ");
INSERT INTO ptu_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Mane napakahi'di polei naua: “Maka' mentamakoa' mesa tondä', iai too banua muongei, iya eta liungkoa' too lambi' umpelleia' indo tondä'. ");
INSERT INTO ptu_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Angga hia ke deenni mesa tondä' untumpu pala'koa', iya pelleia' lao indo ongeam sapo' pempassiannia' sobä' dio bitti'mu, aka la mendadi tanda lako tondä' ia too la natumpu pala' Puang Allataala.” ");
INSERT INTO ptu_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","13","Iya le'ba'im indo passikolanna anna napa'paissanganni lako ingganna tau naua: “La pahallukoa' untihokongam gau'mu.” Anna buda setam nahambai, buda to masaki si napasussui minnä'-minnä' anna napabono'i. ");
INSERT INTO ptu_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Napelele duka' tomahaja Herodes diona Puang Yesus aka molele-lelem sanganna anna buda tau muuai: “Indo Yohanes to si mantedo' tubo sule! Iam too anna deemmi kakuasaanna umpogau' tanda memängä-mängä.” ");
INSERT INTO ptu_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Piha tau muuai: “Nabi Elia hi tia.” Deem duka' muuai: “Mesa hi tia nabi yolona tubo sule.” ");
INSERT INTO ptu_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Tappana nahingngi Herodes diona kaha-kaha ia too, iya ma'kadam naua: “Yohanes to si mantedo' si'da hi tia itim, indo to bali kupopelempo'i ulunna sapo' tubo sule.” ");
INSERT INTO ptu_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Aka abana Herodes si'da hi tia ussua tau ussakka Yohanes napopesangkala illaam tahungkum aka nasalla indo anna natappakadai Yohanes diona indo umpobaine Herodias bainena Filipus, solasubunna. ");
INSERT INTO ptu_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Nauaam Yohanes eta too: “Tä' punala sipäto' mualako Herodias bainena Filipus solasubummu umpobaine, aka tä' sihondoi peadasantaa'.” ");
INSERT INTO ptu_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Iam too napolalam Herodias umpemannaam Yohanes, sapo' tä'pi mala tappa napatei, ");
INSERT INTO ptu_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","aka ungkalaja'pi Yohanes Herodes eta too, aka naissam naua inde tau to malolo anna to maseho. Dadi napengkamma'ipi. Sapo' uhhingngi oi too Yohanes, iya ma'dua penaba oom, pissam husa' penabanna, sapo' deem ohi napohäe. ");
INSERT INTO ptu_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Sapo' katampasanna sule lako duka' pattujunna Herodias wattunna anna umpakahoa'i allo kadadianna Herodes. Indo allo eta too untambai asam to kasallena illaam kapahentaam, anna ingganna pangngulunna sohodadu sola ingganna to kasalle illaam lembäna Galilea. ");
INSERT INTO ptu_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Illaam indo kamahoasam eta too, sumajo änä'na Herodias baine lambi' tä' deem pada salosso' inabanna Herodes sola ingganna tosabena muitai. Iya ma'kadam tomahaja lako indo to sumajo naua: “Iai too umpemulu iam kubeengko.” ");
INSERT INTO ptu_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Anna ma'dandi lako naua: “Ia mammo anna ia umpelau, moi la sasesena inde kapahentaangku kubeem tooko.” ");
INSERT INTO ptu_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Iya le'ba'um indo to sumajo ungkutanai indona naua: “Aka la kupelau?” Natimba' naua: “Ulunna Yohanes to si mantedo'.” ");
INSERT INTO ptu_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Iya napasihha' siaham le'ba' lako tomahaja anna nauai: “Temo kupelau anna umpadioannä' baki ulunna Yohanes to si mantedo'.” ");
INSERT INTO ptu_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Tappana nahingngi tomahaja pelauanna, tä' deem pada samasussa penabanna aka la dipatei Yohanes. Sapo' tä'um mala natumpu pala' aka puham ma'pinda lako indo baine nahingngi tosabena. ");
INSERT INTO ptu_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Ussua siaham mesa passappi'na indo tomahaja lao muäläi ulunna Yohanes. Iya le'ba' siaham indo tau lako tahungkum anna ullempo'i ulunna Yohanes. ");
INSERT INTO ptu_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Mane nababai sule indo ulu napadio baki anna nabeenni indo to sumajo. Iya naalam duka' anna nababaanni lako indona. ");
INSERT INTO ptu_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Tappana naissam passikolanna Yohanes diona ia too, iya le'ba'im naala indo bakkena anna nalamunni. ");
INSERT INTO ptu_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Tappana ma'pasulei indo suhona Puang Yesus, iya ma'hempummi anna natulasanni indo puha nakähä anna puha napepa'guhuam. ");
INSERT INTO ptu_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Anu' aka tuttuam buda tau sule anna le'ba', lambi' tä' deem mala mangngande Puang Yesus sola passikolanna. Iya ma'kadam lako passikolanna naua: “Maikoa' talulako ongeam kasala-salaanna anna malai pakakitaa' mellube säpäi'.” ");
INSERT INTO ptu_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Iya mengkalao siaham ma'lopi le'ba' lako ongeam kasala-salaanna umpasähä' kalena. ");
INSERT INTO ptu_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Sapo' naitanna tau buda le'ba' anna naissam la naongei lao, tappa sikakondä lao naheba' muola galantangam lambi' nayoloi landa'. Indo tau buda buttu dio mai kotana si mesa-mesa illaam pa'lembängam eta too. ");
INSERT INTO ptu_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Tuhunna Puang Yesus yabo mai lopi, iya muitam tau buda lambi' häntä buana aka sihhapam domba tä' deem to ungkambi'i. Nasuhum nabeem ma'hupa-hupa pepa'guhuam. ");
INSERT INTO ptu_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Kahubenni, iya napellambi'im passikolanna anna nauaanni: “La bengi bäbäm! Moi kela daa pohiallasam inde taongeia'. ");
INSERT INTO ptu_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Mapia ke ussuai inde lako tau buda anna mala lao mualli kinande lako tondä' anna lako to ma'liangam.” ");
INSERT INTO ptu_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Sapo' natimba'i naua: “Iko hanna' umpandei.” Iya nauam passikolanna: “Umba bäbäm too kami' ngei la kipangngalai pealli pada buda aka umbai' la pa'duapuloam bidä mane ganna'i dialliam hoti dipandeam?” ");
INSERT INTO ptu_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Iya nakutanaim naua: “Sanakapia' hotimmu? Petua'pi!” Puhai napetua', iya nauam: “Angga ham lima kalebu hoti anna dua käju bau.” ");
INSERT INTO ptu_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Lambi' naua Puang Yesus lako indo tau buda: “Äto'koa' kalemu, ammu okko'a' lako alla' humpu'.” ");
INSERT INTO ptu_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Iya muokko'im duka'. Deem sahatu' sallaoam, deem lima pulo. ");
INSERT INTO ptu_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Iya naalam Puang Yesus indo lima hoti anna dua bau mane mentongai längäm langi' nakuhhu'i sumanga' längäm Puang Allataala. Puhai ia too napiä'-piä'um indo hoti mane nabeenni passikolanna natabaam lako indo tau buda. Susi siam duka' indo bau. ");
INSERT INTO ptu_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Iya mangngandeim sampe dea'. ");
INSERT INTO ptu_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Tappana puhai mangngande, iya nahempummi passikolanna indo tää'nam naande, iya sapulo duapi baka ponno. Senga'pi la'bi bau. ");
INSERT INTO ptu_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","To mangngande wattu eta too lima sa'bu muane mandi dihekem. ");
INSERT INTO ptu_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Puhai ia too, muuaam siaham passikolanna Puang Yesus: “Längängkoa' inde lopi ammu pendiolonna' lambam libam Betsaida,” napasindum siam ussua duka' lao indo tau buda. ");
INSERT INTO ptu_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Iya lessu' asanni indo passikolanna sola tau buda, iya le'ba'um ia längäm tanete ma'sambajam. ");
INSERT INTO ptu_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Bengii, iya illaammi tängä le'bo' indo lopi naongei passikolanna anna Puang Yesus Ia tohho yabo galantangam mesa-mesanna. ");
INSERT INTO ptu_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Iya tappana la tibukka' kale baja, muitam passikolanna sängä' nabela umbose lopinna aka napobua' hibu' tatta'. Iya le'ba' siaham napellambi'i mellao yabona uwai sapo' mato-mato la tahhu' napelebanni. ");
INSERT INTO ptu_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","50","Naitanna indo passikolanna mellao yabona uwai, iya mahea'im anna kaoli-olii aka nasanga anitu. Sapo' tappa ma'kada naua: “Pahapa'ia' penabammu, daa ummahea', aka Kao hi to Kao!” ");
INSERT INTO ptu_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Lambi' le'ba' längäm lopi umpellambi'i passikolanna, iya mattam siaham hibu'. Lambi' tä' deem pada samängä-mängä anna tä' naala akkalanna. ");
INSERT INTO ptu_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Susi siam tanda memängä-mängä diona lima hoti tä' liupi mentama pikkihanna anna mapahhi' napenabaam aka tä' nalambi' penabanna diona kakuasaanna Puang Yesus. ");
INSERT INTO ptu_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","54","Tappana tisampo lopinna Puang Yesus sola passikolanna dio Genesaret, iya umpatuhunnim sampahajana anna mane le'ba'i längäm galantangam. Iya tappa naissam siaham tau naua: “O, sule Puang Yesus!” ");
INSERT INTO ptu_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Iya sikakondä siaham ullelei tondä'na, anna mualai to masakinna mane nababai le'ba' napasitonda ampa'na anna iai too naongei Puang Yesus etam too napambabai lako. ");
INSERT INTO ptu_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Umba-umba ongeam naongei sule, lako haka mesa tondä', lako haka kota, battu ongeam senga', buda liu tau sule umbaba to masakinna tihempum dio pasa' anna napelaui lako naua: “Kela mala anna naantii moi podo tähämpä' jubamum to masakingki, iya la malam too bono'.” Lambi' ingganna to muantii mala asam bono'. ");
INSERT INTO ptu_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Pissam wattu sulei yabo mai Yerusalem sanaka-naka to illaam kakalebuanna Parisi anna to ullatta' Pepaondonganna Musa umpellambi'i Puang Yesus. ");
INSERT INTO ptu_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Wattu eta too muita sanaka-naka passikolanna Puang Yesus mangngande bäbä, tä' umbasei yolo limanna situhu' kabiasaanna to Yahudi. ");
INSERT INTO ptu_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Aka situhu' kabiasaanna nene to naponene to illaam kakalebuanna Parisi anna to Yahudi senga', si tä' mala mangngande ke tä'i umbasei yolo limanna. ");
INSERT INTO ptu_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Anna maka' sule dio mai pasa' tä' mala mangngande ke tä'i membase yolo. Anna napepaondongam toi duka' lako peampoanna naua: “Manggi' tau umbasei ihusam, tehhesam, anna ingganna pangkakka' gällä,” anna budapi kabiasaam senga' manggi' natuhu'i. ");
INSERT INTO ptu_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Iam too anna mekutanam lako Puang Yesus naua: “Akanna tä'i untuhu'i kabiasaanna nene to taponene indo passikolammu, mangngandei bäbä, tä' umbasei yolo limanna?” ");
INSERT INTO ptu_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Natimba' naua: “Ikoa'-iko anggangkoa' ma'pudu' pandem anna ma'lila manähä. Abana tappa' kadanna Puang Allataala natula' loppo' nabi Yesaya yolona diona panggauammua' naua: ‘Itim matim tau dio bäbä pudu'na napa'kasalleiä' sapo' setonganna illaam penabanna napemboko'iä'. ");
INSERT INTO ptu_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Alla'um napenombaiä' aka anggam pepa'guhuam hupatau napepatuduam, mato-mato ia kupepatuduam anna taia hia.’” ");
INSERT INTO ptu_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","9","Mane nauai Puang Yesus: “Umpa'bahinni'ikoa' pahentana Puang Allataala anna muanda'-anda'ikoa' kabiasaam hupatau. Si manähhäkoa' untampeam pahentana Puang Allataala anna umpasulleia' kabiasaammu! ");
INSERT INTO ptu_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Puham napaondom Musa naua: ‘Pa'kasalleiko ambemu sola indomu;’ anna: ‘Menna-menna umpakaänä'-änä' ambena battu haka indona, tau ia too la dipatei.’ ");
INSERT INTO ptu_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","12","Sapo' si muua hia' iko ma'patudu lako tau: Tä' tau pahallu muola oloanta lako ambeta sola indota ke diuai: ‘Indo la kutahiaiangkoa' battuam, puham kupehumalasam lako Puang Allataala.’ ");
INSERT INTO ptu_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Kahana umpateenna', iya umpa'pa'deingkoa'i pahentana Puang Allataala anna kabiasaammuia' umpalako. Anna budapi susinna si umpogau'a'.” ");
INSERT INTO ptu_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Puhai ia too, iya untambaim tau buda Puang Yesus anna napa'tula'i naua: “Pehingngii manappaia' inde tula'ku anna umpaillaam penabai! ");
INSERT INTO ptu_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Ingganna lu tamanna kalena tau tä' ia la nakadakei, sapo' messubunna hi tia illaam mai kalena iam too ungkadakei. ");
INSERT INTO ptu_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Pehingngiia' anna umpaillaam tambu'ia' inde tula'ku!” ");
INSERT INTO ptu_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Puhai ma'tula', umpelleim indo tau buda anna lu tamai mesa banua, iya nakutanaim passikolanna naua: “Aka kalembasanna indo pehapangam untula' ingngena'?” ");
INSERT INTO ptu_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Iya natimba'um naua: “Aka tä'paka' tiko duka' muissam? Aka kinande dipatama sädä tä' ia ungkadakei hupatau, ");
INSERT INTO ptu_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","aka ia too tä' lu tama penaba sapo' lu tama tambu', anna tahhu' ditibe lao.” Naägä'i Puang Yesus natula' kada ia too, anna mala naissam tau buda naua tä' deem kinande pemali diande. ");
INSERT INTO ptu_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","22","Mane ma'kada polei Puang Yesus naua: “Indo hia mengkalao illaanna penabanna hupatau lemba' dio panggauanna ia hi tia ungkadakei, susinna: pikkiham kadake, gau' sessu', maboko, papateam, lullusam bannetau, mailu anna matinna, gau' kadake, manipu, mohäe sugali', kembuhu, ma'pakolo'-kolo'i, malangka' penaba, anna tä' muissam se'la. ");
INSERT INTO ptu_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Ingganna kakadakeam ia too mengkalao illaam penaba anna iam too ungkadakei hupatau.” ");
INSERT INTO ptu_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Puhai ia too umpelleim Galilea Puang Yesus anna le'ba'i lako lembäna Tirus. Sulei lako melolo tamam mesa banua, aka pattujunna indana deenni muissanni kasuleanna. Sapo' tä' dia mala aka naissam liu tau kasuleanna. ");
INSERT INTO ptu_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","Pissananna deem mesa baine tappa naissam kasuleanna, iya napellambi'im napasindum ma'balinguntu' dio olona anna nauai: “Kupelau kela mala umpabonosannä' änä'ku baine, aka napentamai setam.” (Indo baine taia to Yahudi sapo' to Siro-Penesia.) ");
INSERT INTO ptu_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Sapo' natimba'i Puang Yesus naua: “Päbäii duka' medea' yolo änä' ikale aka tä' mapia kela dialai kinande dipatokaam änä'-änä' anna ditibeanni lako asu.” ");
INSERT INTO ptu_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Naua oom indo baine: “Abana tappa'ko, Tuam! Sapo' kuua hi kao, indo asu dio ibi' meja mala hi tia duka' muande kinande honno'na änä'-änä'.” ");
INSERT INTO ptu_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Nasuhum ma'kada Puang Yesus naua: “Uhhuako kada, dadi le'ba'ungko aka indo setam to umpentamai änä'mu, mäläim illaam mai kalena.” ");
INSERT INTO ptu_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Iya le'ba'um indo baine lako banuanna. Sulei lako, ullambi'um änä'na metindo masannam, aka indo setam to umpentamai mäläim lao. ");
INSERT INTO ptu_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Lessu'i eta too, umpelleim lembäna Tirus Puang Yesus anna untahhusanni pa'laoanna lako le'bo' Galilea naola lako Sidon, muolai lembäna Sapulo Kota. ");
INSERT INTO ptu_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Wattu eta too deem sanaka-naka tau sule umpasola mesa tau ia binga ia mämä. Napelaum naua: “O Tuangguhu, antiangkam inde to bingangki anna mala bono'.” ");
INSERT INTO ptu_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Iya natässu'im duka' Puang Yesus indo to binga dio mai alla'na tau buda anna napalao senga'i mane napehhosisanni tahuno-hunona tama talinganna mane untikkudui tahuno-hunona anna natu'doanni lilana. ");
INSERT INTO ptu_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Anna mentongai längäm langi' napasindum umbussangam penabanna mane ma'kadai naua: “Efata!” (kalembasanna: “Titungka'ko!”). ");
INSERT INTO ptu_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Iya tappa titungka' siaham talinganna indo tau anna makalesom pole' pa'tula'na. ");
INSERT INTO ptu_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Ingganna indo to sule wattu eta too napakahi'di asam Puang Yesus nauaam: “Deem aia' untula' le, moi la menna tala untulasanni.” Sapo' tuttuam dilaham, tuttuam napalele mandi sau' dekke. ");
INSERT INTO ptu_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Ingganna to uhhingngii kaheba ia too sangngim pilla' anna mängä-mängä naua: “Tä' deem tanaissam napadadi. Mala umpopahingngi to binga anna mala umpatappa' tula'na to mämä.” ");
INSERT INTO ptu_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Pissam wattu, ma'hempum oom tau buda sola Puang Yesus. Indo tau buda tappu'um kinandena. Tappa untambaim passikolanna anna nauai: ");
INSERT INTO ptu_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Tä' deem pada sahäntä buaku muitai inde lako tau, aka tallungngallo tallu bengingkia' inde sola-sola, iya pa'dem la naande. ");
INSERT INTO ptu_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Sapo' maka' la kusua bäbä lako banuanna, iya lako manii lalam anna tissämbä'i malimpä. La'bi-la'binna to sule mambela.” ");
INSERT INTO ptu_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Sapo' natimba'i passikolanna naua: “Pusa'kam pole' aka diokia' inde pohiallasam, umbam ia ngei la dipangngalaiam kinande pada budanna?” ");
INSERT INTO ptu_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Iya nauam: “Anu' sanakapia' hotimmu?” Natimba' passikolanna naua: “Angga ham pitu.” ");
INSERT INTO ptu_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Iya nauam Puang Yesus lako indo tau buda: “Okko'koa' lako itim paha'baja.” Anna mane naala indo hoti pitu anna nasambajannii längäm Puang Allataala, mane napiä'-piä'i anna mane nabeem passikolanna natabaam lako indo tau buda. ");
INSERT INTO ptu_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Deempi duka' baunna saidi' sapo' si bahinni'. Iya naala oom duka' anna nakuhhu'i oi sumanga' mane nabeenni passikolanna anna nataba pole oi. ");
INSERT INTO ptu_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Dea' asanni indo tau buda, iya nahempummi passikolanna indo tää'nam naande, iya ponno polepi pitu baka. ");
INSERT INTO ptu_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Indo to mangngande kiha-kiha appa' sa'bunna. Puhai mangngande nasuam Puang Yesus ma'pasule lako ongeanna. ");
INSERT INTO ptu_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Lessu'na tau buda, längäm siaham lopinna solai passikolanna anna le'ba'i lako lembäna Dalmanuta. ");
INSERT INTO ptu_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Dioi, iya sulem sanaka-naka to illaam kakalebuanna Parisi umpellambi'i Puang Yesus anna nateläi tula'na aka la napa'sändä'i. Iya napellambi'im anna nauaanni: “Paitaikam tanda yabo mai suhuga.” ");
INSERT INTO ptu_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Tappa umbussangam penabanna anna ma'kadai naua: “Maaka hia inde mai hupatau temo anna umpelaui tanda? Aka kutulasangkoa', setonganna tä' deem la kupaitai tanda inde mai hupatau.” ");
INSERT INTO ptu_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Anna le'ba'i umpellei indo tau, längäm sule lopinna anna lambanni. ");
INSERT INTO ptu_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Tappana längänni lopi, iya tä' dia nakilalai indo passikolanna Puang Yesus umbaba hoti buda-buda, anggam sakalebu nababa. ");
INSERT INTO ptu_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Siampu' eta too umpakainga' passikolanna naua: “La majagakoa' too indana nasägäikoa' bibi' hotinna Herodes anna to illaam kakalebuanna Parisi.” ");
INSERT INTO ptu_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Tappana nahingngii passikolanna, iya sipa'tula'-tula'um naua: “Umbai' ia hi tia anna ma'kada susii aka tä'kia' umbaba hoti.” ");
INSERT INTO ptu_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Sapo' naissam Puang Yesus indo tula'na passikolanna iya tappa ma'kadam naua: “Akanna ussitimba'-timba'i hakoa' iko diona pa'dena hotimmu? Tä' liupia' isanga natama pikkihammu? Tä' liupia' isanga muissam manappaä'? ");
INSERT INTO ptu_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Kusanga siampuangkoa' mata, akanna tä'ia' umpetua'; siampuangkoa' talinga, akanna tä'ia' umpehingngii? Tä' daka tia ungkilalaia' ");
INSERT INTO ptu_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","indo anna kupiä'-piä'i lima hoti dipandeam lima sa'bu tau? Sanakapi baka ponno tää'nam naande tau buda indo uhhempunna'?” Natimba' naua: “Sapulo duapi.” ");
INSERT INTO ptu_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Mane naua polei: “Ungkilalai haka' anna kupandei appa' sa'bu tau anggam pitu hoti dipiä-piäsam, iya sanakapi baka tää'nam diande uhhempunna'?” Natimba' oom naua: “Pitupi baka gege.” ");
INSERT INTO ptu_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Iya nauam Puang Yesus: “Tä' liupaka' tiko umpähäm?” ");
INSERT INTO ptu_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Landa'i Puang Yesus sola passikolanna lako Betsaida, iya deem tau untette to buta lako Puang Yesus anna nauai: “O Tuangguhu, antiangkam inde to butangki anna malai paita.” ");
INSERT INTO ptu_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Iya naanda'im limanna anna natettei lako sulibam kota, anna mane natikkudui matanna napasindum naanda'i anna nakutanai naua: “Deemmaka aka-aka muita temo?” ");
INSERT INTO ptu_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Iya mennenne'um lako olona anna nauai: “Io, kuitam tau kalao-lao, sapo' susi bäbä too' kaju.” ");
INSERT INTO ptu_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Iya naanti pole oom matanna. Puhai, napengkalissä'-lissä'im mennenne' lao, iya masiä' siahanni naita anna makaleso asammi ingganna aka-aka. ");
INSERT INTO ptu_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Puhanna ia too, nasuam ma'pasule lako banuanna sapo' nauaam: “Anggam ia tä'ko la mala ma'pasule tama indo kota anna untulasanni solamu.” ");
INSERT INTO ptu_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Puhai ia too le'ba'um Puang Yesus sola passikolanna ullelei mobotto-bottoam lako Kaisarea Filipi. Muolai lalam, nauam Puang Yesus: “Situhu' tula'na tau, aka si nasangaiannä'?” ");
INSERT INTO ptu_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Iya natimba'im naua: “Deem tau muuai: ‘Yohanes to si mantedo' tubo sule;’ deem muuai: ‘Nabi Elia sule sule;’ deem duka' muuai: ‘Mesa nabi senga' tubo sule.’” ");
INSERT INTO ptu_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Iya mekutanam lako passikolanna naua: “Maka' susi, iya akaa' iko ussangaiannä'?” Tappa natimba' Simon Petrus naua: “Ikom too indo To dilanti' la mepasalama'.” ");
INSERT INTO ptu_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Iya nauam Puang Yesus: “Io, tappa', sapo' daa untula' poleia' lako tau senga'!” ");
INSERT INTO ptu_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Lessu'i ia too napahandu'um Puang Yesus ma'pa'guhu naua: “Kao to disangai Änä' Mentolino la ussi'dim ma'hupa-hupa pandahhaam anna la natumpu pala'ä' matua ulunna to Yahudi anna ingganna kapala sando sola to ullatta' Pepaondonganna Musa lambi' la napateiä'. Sapo' illaam allo katallunna la tibangonnä' sule dio mai alla'na to mate.” ");
INSERT INTO ptu_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Napomasissä' Puang Yesus natula' kaha-kaha ia too, sapo' tappa nababai lao Petrus umpelle-pellei solana anna nauaanni: “Daa umpa'kada susi.” ");
INSERT INTO ptu_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Iya tappa menggihi' Puang Yesus umpalelei mata passikolanna anna ungkeaha'i Petrus naua: “Pälläiko lao Setam! Aka taia iko pa'elo'na Puang Allataala umpikki', sapo' angga iko pikkiham hupatau illaam penabammu.” ");
INSERT INTO ptu_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Mane uhhempunni tau buda sola passikolanna anna nauaanni: “Menna-menna maelo' untuhu'iä' pahallu la ullappa' pa'elo' kalena anna umpassam kaju sitambenna, anna natuhu'ä'. ");
INSERT INTO ptu_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Aka menna-menna umpakalando puha ia katuboam di lino anna la Kao, tau ia too tä' ia la ullambi' katuboam sule lako salako-lakona. Sapo' menna-menna ahu' mate aka natuhu'ä' anna umpa'pakahebaam Kaheba Katilallasam, tau ia too la ullambi' indo katuboam sule lako salako-lakona. ");
INSERT INTO ptu_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Tä' deem gunana lako mesa tau moi la muampuam ingganna issinna lino kela sägä hi sungnga'na. ");
INSERT INTO ptu_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Aka setonganna tä' ia deem bala'inna sungnga'na hupatau. ");
INSERT INTO ptu_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Aka menna-menna umpa'kasihisannä' anna umpa'kasihisam pepa'guhuangku illaam inde alla'-alla'na to umpogau' kasedaam anna to sässä' lalam, tau ia too la kupa'kasihisam duka' ke sulemä' to disangai Änä' Mentolino naponnoi kamatandeanna Ambeku anna natuhu'ä' ingganna malaika' maseho.” ");
INSERT INTO ptu_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Mane nauai: “Aka kutulasangkoa', setonganna deengkoa' to dio heem temo tä'pi la mate anna muitam Puang Allataala umpalako kapahentaanna sola kakuasaanna.” ");
INSERT INTO ptu_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Annanni benginna puhanna ia too, iya umbabaim Petrus, Yakobus, anna Yohanes Puang Yesus le'ba' längäm mesa tanete malangka', anna yaboi paka-paka ia. Iya muitaim Puang Yesus tieli' hupanna. ");
INSERT INTO ptu_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Anna pangkähhä pohebana tä' deem tau illaam inde lino la mala umpasusii mabusanna. ");
INSERT INTO ptu_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Iya tappa muitam Puang Yesus mahassam sipa'tula' indo dua nabi yolona isanga Elia anna Musa. ");
INSERT INTO ptu_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Iya ma'kadam Petrus naua: “O Tuangguhu tä'um deem la susi kamasannangantaa' eta inde. Mapia ke kipake'desangkoa' tallu bahum: mesa Iko, mesa Musa, anna mesa Elia.” ");
INSERT INTO ptu_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Ia anna ma'kada susii Petrus aka tä' bäbä naissam aka la naua aka sangngim mahea'. ");
INSERT INTO ptu_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Iya nasikuku'im gabum anna nahingngii kamaha buttu illaam mai indo gabum naua: “Iam too inde Änä' pa'pakamajangku. Pahallua' la umpehingngii!” ");
INSERT INTO ptu_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Pissananna ham ia sikapeä indo passikolanna aka angga ham mesa-mesanna Puang Yesus naita, pa'de bäbäm ia indo to dua. ");
INSERT INTO ptu_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Tappana tuhunni Puang Yesus sola indo to tallu yabo mai indo tanete, iya napakahi'dim naua: “Deem aia' la untula' säkä indo to puhaa' muita yabo tanete le, ke tä'i puhaä' dipatibangom to disangai Änä' Mentolino dio mai alla'na to mate!” ");
INSERT INTO ptu_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Sangngim napehingngii indo pepakahi'dinna napasindum sipa'tula'-tula' naua: “Aka hia umbai' nasanga ‘la tubo sule dio mai alla'na to mate?’” ");
INSERT INTO ptu_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Iya nakutanaim passikolanna naua: “Sapo' maaka hia anna nauai to ullatta' Pepaondonganna Musa: ‘Tä' mala tala sule yolo nabi Elia anna mane sule indo To dilanti' la mepasalama'?’” ");
INSERT INTO ptu_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Natimba' Puang Yesus naua: “Abana pahallu la sule yolo Elia umpatoka ingganna-ingganna sia. Sapo' naala haka' ia inabammu indo to puha tisuha' diona Änä' Mentolino la ussi'dim ma'hupa-hupa kamasussaam anna la ia siam anna ia dipogausam? ");
INSERT INTO ptu_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Sapo' kuuaangkoa' tentomai: Abana puham sule Elia, anna ia siam napogausam tau anna ia, umba susi indo puha tisuha' illaam Battakada Debata.” ");
INSERT INTO ptu_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Tappana ma'pasule Puang Yesus sola Petrus, Yakobus, anna Yohanes, iya ullambi'um indo passikolanna to kasehapi nalebo tau buda sola sanaka-naka to ullatta' Pepaondonganna Musa mahassanni sitimba'-timba'. ");
INSERT INTO ptu_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Iya muitanna sia Puang Yesus indo tau buda sangngim pilla' anna sikalumpa' untammuii. ");
INSERT INTO ptu_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Iya mekutanam lako passikolanna naua: “Aka hia' iko ussitimba'-timba'ianna' inde lako tau?” ");
INSERT INTO ptu_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Iya ma'kadam mesa tau illaam mai alla'na indo tau buda naua: “O Tuangguhu, kubabangko sule inde änä'ku aka napentamai setam nasuhum maho. ");
INSERT INTO ptu_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Aka maka' too nasulei oom indo setam, iya si angga' dipehhabisam dokko litä', si ma'tambuha-buha sädäna, sikukku isinna anna mato'do' kalena. Iya puham kupelau lako itim matim passikolammu anna nahambaii lao indo setam sapo' tä' dia mala.” ");
INSERT INTO ptu_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Iya ma'kadam Puang Yesus naua: “Kukapusa'i si'dakoa' pole' inde to tubo lapi' temo, aka kuhäm sugali'a' kamatappasammu! La pada polepi isanga umba masäena sola-solakia' anna la pada polepi isanga umba masäena la kusa'bahasangkoa'?” Mane nauai: “Babaannä' mai itim änä'-änä'.” ");
INSERT INTO ptu_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Iya nababaammi lako. Muitanna sia Puang Yesus indo setam, tappa undodä' indo änä'-änä', iya tissämbä' siahanni anna tibalintam lelem ma'tambuha-buha sädäna. ");
INSERT INTO ptu_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Mekutanam Puang Yesus lako ambena indo änä'-änä' naua: “Masäengka ma'pateem?” Iya naum indo ambena: “Bahinni'pi anna napahandu'um ma'pateem. ");
INSERT INTO ptu_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Si kapuhaammi la umpatei inde änä'ku indo setam si natobängam tama api anna dokko uwai. Sapo' kela mala ungkamaseikanni anna umpamoloikam umba ke malai bono'.” ");
INSERT INTO ptu_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Iya natimba'im naua: “Akanna muuai: ‘Umba ke malai’? Aka kutulasangko, tä' ia deem nakapusa'i lako to deem kamatappasanna.” ");
INSERT INTO ptu_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Tappa ma'kada kasalle indo ambena naua: “Kukatappa'iko sapo' pamoloiä' anna malai tuttuam kehängäm kamatappasangku.” ");
INSERT INTO ptu_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Pissananna naita Puang Yesus tuttuam buda tau sule ulleboi, iya nakissä'im indo setam to si ma'pabinga anna ma'pamaho naua: “Pessubungko illaam mai kalena inde änä'-änä', anna tä'ungko mala la tama pole.” ");
INSERT INTO ptu_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Iya messubum eta siaham indo setam napasindum kumissä' anna undodä'i indo änä'-änä', iya diita siahanni anggasannam to mate. Iya budam tau muuai: “Matem.” ");
INSERT INTO ptu_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Sapo' tappa naanda'i Puang Yesus limanna indo änä'-änä' la nabangongam, iya bangom siahanni. ");
INSERT INTO ptu_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Pissananna illaanni banua Puang Yesus sola passikolanna paka-paka ia ham, iya nakutanaim passikolanna naua: “Maaka hia isanga anna tä'i kami' mala kihambai lao indo setam?” ");
INSERT INTO ptu_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Natimba'im naua: “Indo setam susi tä' mala dihambai ke tä'i ma'sambajam tau yolo.” ");
INSERT INTO ptu_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Iya mengkalaom Puang Yesus sola passikolanna umpatahhu' pa'laoanna muolai Galilea. Eta too napeä lalanna anna malai tä' naissam tau senga' ongeanna, ");
INSERT INTO ptu_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","aka angga opi passikolanna mahassam nabeem pepa'guhuam. Natula'um lako passikolanna naua: “Kao to disangai Änä' Mentolino la dibeho tama pala' limanna hupatau. La napateiä', sapo' illaam allo katallunna la tibangonnä' sule.” ");
INSERT INTO ptu_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Sapo' tula' ia too tä' natama akkalanna passikolanna kalembasanna, sapo' sangngim malaja' umpekutanaanni. ");
INSERT INTO ptu_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Pissam wattu landa' oom Puang Yesus sola passikolanna lako Kapernaum. Tappana illaanni banua, mekutanam lako passikolanna naua: “Aka hia' iko ussibetä'-betä'i dio mai lalam ingngena'?” ");
INSERT INTO ptu_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Sapo' sangngim mengkamma' aka indo nasibetä'-betä'i naua: “Mennakia' handam matande?” ");
INSERT INTO ptu_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Iya muokko'um Puang Yesus anna untambai indo to sapulo dua anna nauaanni: “Iai too maelo' la kesanga, la mengkadio anna maelo' dipahe'.” ");
INSERT INTO ptu_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Mane untettei änä'-änä' tama alla'-alla'na anna nakalapu'i mane nauai: ");
INSERT INTO ptu_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Menna-menna untahima änä'-änä' susi inde aka umpolalam kamatappasanna di Kao, tau ia too sihhapam siam Kao natahima. Anna menna-menna untahimaä', tä' anggam Kao natahima sapo' To ussuaä' duka' natahima.” ");
INSERT INTO ptu_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Iya ma'kadam Yohanes lako Puang Yesus naua: “O Tuangguhu deem kiita mesa tau uhhambai setam umpake sangammu, sapo' tä' kipäbäi aka taia indo to si tapasolaa'.” ");
INSERT INTO ptu_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Sapo' natimba' naua: “Daa ullahanni, aka tä' tia umpogau'na tanda memängä-mängä mesa tau umpake sangangku, iya la natelle-tellemä' Kao. ");
INSERT INTO ptu_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Aka iai too tä' umbalikia', iam too solata. ");
INSERT INTO ptu_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Kutulasangkoa' setonganna menna-menna umbeengkoa' uwai saihusam aka to untuhu'koa' Kristus, mannassa anna tau ia too la untahima sahona.” ");
INSERT INTO ptu_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Mane naua polei Puang Yesus: “Menna-menna umpabulim inde änä'-änä' to puha matappa' nasuhum la tä'um nakatappa'iä', tau ia too aha leko'um dipatoke'i batu peepe' bahokona anna dipa'tumbusanni tama le'bo'. ");
INSERT INTO ptu_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Anna maka' hapanna limammu la umpomadosako, mapia leko'um tia ke umpoloi lao. Aka aham tia sabali-bali limammu sapo' la ullambi'ko katuboam sule lako salako-lakona, anna la tontä liu dua limammu, sapo' ditibe hako tama nahaka api tapi'de-pi'de. ");
INSERT INTO ptu_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Aka ongeam ia too tala mate olli'na tala pi'de apinna. ");
INSERT INTO ptu_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Anna maka' hapanna bitti'mu la umpomadosako, mapia leko'um tia ke umpoloi lao. Aka aham tia kempo'ko sapo' la ullambi'ko katuboam sule lako salako-lakona, anna la tontä liu dua bitti'mu, sapo' ditibe hako tama nahaka. ");
INSERT INTO ptu_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Aka ongeam ia too tala mate olli'na tala pi'de apinna. ");
INSERT INTO ptu_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Anna maka' matammu la umpomadosako, kalessu'i lao. Aka aha leko'um tia sabali-bali matammu sapo' mendadiko umma'na Puang Allataala illaam kapahentaanna, anna la tontä liu dua matammu sapo' ditibe tama hako nahaka. ");
INSERT INTO ptu_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Aka ongeam ia too tala mate hia olli'na tala pi'de apinna. ");
INSERT INTO ptu_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Si mesa-mesa tau la disehoi umpake api umba susi tunuam disehoi umpake sia. ");
INSERT INTO ptu_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Setonganna sia mapia, sapo' maka' matämmä'um la malapaka tia dipamasim sule? Dadi la pahalluko too umpamasim liu kalemu, anna la tubokoa' sikamase mesa sola mesa.” ");
INSERT INTO ptu_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Mengkalao etam too Puang Yesus le'ba' lako lembäna Yudea anna lambanni libam Salu Yordan iya nalebo oom tau buda. Iya ma'pa'guhu oom, umba susi si napogau'. ");
INSERT INTO ptu_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Eta too deem sule sanaka-naka to illaam kakalebuanna Parisi maelo' la umpeängam tuntungam su'be' Puang Yesus lambi' nakutanai naua: “La situhu' daka peadasam ke untibei bainena mesa muane?” ");
INSERT INTO ptu_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Sapo' natimba' naua: “Akaka napaondongangkoa' Musa?” ");
INSERT INTO ptu_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Iya natimba'um naua: “Napäbäi Musa sisähä' sapo' manggi' napapiaam suha' kasisähäsam muanena.” ");
INSERT INTO ptu_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Iya nauam Puang Yesus: “Ia hi tia anna natuli'i Musa pepaondongam ia too aka kamakahhasam penabammua'. ");
INSERT INTO ptu_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Aka dadinna inde lino, iya napadadim Puang Allataala muane anna baine, ");
INSERT INTO ptu_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","8","anna nauai: ‘Iam too anna mesa muane la umpellei indona sola ambena anna sialai mesa baine, nasuhum duai la mendadi mesa illaam ingganna-ingganna sia.’ Dadi, tä'um la dua sapo' la mendadi mesam. ");
INSERT INTO ptu_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Iam too kasuhunganna anna iai too puha napamesa Puang Allataala tä'um mala napasisähä' hupatau.” ");
INSERT INTO ptu_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Tappana illaanni banua, mekutana oom passikolanna lako Puang Yesus naua: “Aka kalembasanna indo tula'mu ingngena'?” ");
INSERT INTO ptu_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Iya natimba'im naua: “Menna-menna untibe bainena anna laoi kebaine pole, tau ia too ullullu' pa'bannetauam. ");
INSERT INTO ptu_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Anna maka' baine untibe muanena anna kemuane polei, ullullu' duka' pa'bannetauam.” ");
INSERT INTO ptu_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Pissam wattu sule sanaka-naka tau umbaba änä'-änä' bahinni'na lako Puang Yesus anna mala natamba', sapo' nakeaha'i hi passikolanna. ");
INSERT INTO ptu_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Pissananna naitai Puang Yesus, iya keaha'um naua: “Päbäi mammi napellambi'iä' itim matim änä'-änä'. Daa ullabai, aka tau susim too itim matim la mendadi umma'na Puang Allataala illaam kapahentaanna. ");
INSERT INTO ptu_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Aka kutulasangkoa', setongam-tonganna, menna-menna tä' susi änä'-änä' untahima kapahentaanna Puang Allataala, tau ia too tä' la mendadi umma' petauanna.” ");
INSERT INTO ptu_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Iya nakalapu'im indo änä'-änä' anna naanda'i ulunna natamba'. ");
INSERT INTO ptu_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Tappana mengkalao Puang Yesus la umpatahhu' pa'laoanna, iya sulem mesa tau ma'sihha'-sihha' umpellambi'i anna ma'balinguntu'i dio olona, anna mekutanai naua: “O Tuangguhu to mapia gau', aka la kupogau' anna malaä' ullambi' katuboam sule lako salako-lakona?” ");
INSERT INTO ptu_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Natimba' naua: “Akanna muuaannä' to mapia gau'? Tä' deem mesa tau la mapia gau' sulibanna Puang Allataala. ");
INSERT INTO ptu_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Mannassa muissammi ingganna pahentana Puang Allataala naua: ‘Daa umpapateam, daa ullullu' pa'bannetauam, daa umpaboko, daa ussa'bi tatappa' diona padammu hupatau, daa untengko solamu, anna pa'kasalleiko indomu sola ambemu.’” ");
INSERT INTO ptu_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Iya natimba'um indo tau naua: “O Tuangguhu, kutuhu'i asammi pahenta ia too mengkalao bahinni'ku.” ");
INSERT INTO ptu_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Iya nanenne'im Puang Yesus nakamase-masei mane nauaanni: “Deempi mesa tä' umpogau', le'ba'ko balu'i ingganna aka-akammu, anna umbeenni to mase-mase. Aka maka' umpateem, iya la muampuammoko too kulle yabo suhuga. Puhai too, sulengko pole' untuhu'ä'.” ");
INSERT INTO ptu_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Sapo' tappana uhhingngi tula'na Puang Yesus, hosso siaham penabanna anna ma'pasulei masussa, aka buda kullena. ");
INSERT INTO ptu_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Iya umpaleleim mata passikolanna anna nauai: “Tä' deem pada samapahhi' to buda kullena la mendadi umma'na Puang Allataala illaam kapahentaanna.” ");
INSERT INTO ptu_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Iya sangngim mängä-mängäm passikolanna uhhingngii tula'na. Anna mane naua pole Puang Yesus: “Oa' änä'ku, mapahhi' si'da-si'da tau mentama kapahentaanna Puang Allataala. ");
INSERT INTO ptu_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Aka madomi' leko'um ia mesa unta muola tama tottä'na dahum, anna la mesa to makaka la mentama kapahentaanna Puang Allataala.” ");
INSERT INTO ptu_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Tuttuam mängä-mängäm pole' passikolanna uhhingngii, nasuhum sipa'tula'-tula' naua: “Maka' susi, iya menna bäbä hi umbai' la mala dipasalama'?” ");
INSERT INTO ptu_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Iya unnenne'im passikolanna anna nauai: “Nakapusa'i ia hupatau, sapo' tä' Ia Puang Allataala aka tä' ia deem tanaissam nagahagai.” ");
INSERT INTO ptu_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Iya ma'kadam Petrus lako Puang Yesus naua: “Kitampeam asammi kami' aka-akangki aka kituhu'ko!” ");
INSERT INTO ptu_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Natimba'im naua: “Kutulasangkoa': setonganna menna-menna umpellei banuanna, battu haka solasubunna, battu haka indona, battu haka ambena, battu haka änä'na, battu haka bela'na, aka natuhu'ä'i anna umpa'pakahebaanni Kaheba Katilallasam, ");
INSERT INTO ptu_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","la natahima siam sule bala' sullena tau ia too wattu temo tiluppi' sahatu': banua, solasubum, indo', änä', anna bela', moinna anna la silolem pandahhaam. Anna illaam wattu mane la sule la untahima katuboam sule lako salako-lakona. ");
INSERT INTO ptu_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Sapo' la deem too dadi ke dako'i buda to matande tentomai, la mendadi to madio, anna to madio tentomai la mendadi to matande.” ");
INSERT INTO ptu_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Tappana le'ba'i längäm Yerusalem Puang Yesus sola passikolanna, iya mendiolo Ia Puang Yesus. Muolai lalam sangngim tillä'bä' buana passikolanna, anna ingganna indo to untuhu'i sangngim mahea'. Iya untambaim indo sapulo dua passikolanna anna natulasanni aka la dadi lako kalena. ");
INSERT INTO ptu_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Naua: “Inde tentomai la längämmakia' Yerusalem. Yabokia' too, iya dibehomä' to disangai Änä' Mentolino lako ingganna kapala sando sola to ullatta' Pepaondonganna Musa anna la nakattu naua: ‘Pahallu la dipopepatei.’ Anna la nabehoä' lako to tamuissam Puang Allataala. ");
INSERT INTO ptu_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Aka la natelleä', la nasitikkudu-kuduiä', la nadahhaä', anna la napateiä', sapo' allo katallunnai too la dipatibangonnä' sule.” ");
INSERT INTO ptu_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Puhai ia too sulem Yakobus sola Yohanes, änä'na Zebedeus anna ma'kadai lako Puang Yesus naua: “O Tuangguhu kipelau kela mala anna untahimai pelauangki.” ");
INSERT INTO ptu_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Iya natimba'um naua: “Aka umpohäe la kupogausangkoa'?” ");
INSERT INTO ptu_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Iya ma'kadam naua: “Maelo'kam la muokko'kia' sola yabo kamatandeammu ke lambi'um wattunna, mesakam dio tandai kanammu, mesa dio tandai kaihimmu.” ");
INSERT INTO ptu_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Sapo' natimba' Puang Yesus naua: “Setonganna tä' muissanna' itim pelauammu. La untuaka' duka' umpendudum indo kamapi'disam la kupendudum anna umpassam indo pandahhaam la kupassam?” ");
INSERT INTO ptu_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Iya natimba'um naua: “Kitua!” Iya nauam Puang Yesus: “Tappa' tula'mu, abana la umpendudunna' duka' indo kamapi'disam la kupendudum anna la umpassam indo pandahhaam la kupassam. ");
INSERT INTO ptu_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Sapo' anggam ia indo diona la muokko' dio tandai kanangku anna tandai kaihingku, taia Kao issangku. Aka ongeam ia too dipatokaam lako hupatau to puha napa'tantu Ambeku” ");
INSERT INTO ptu_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Tappana naissanni indo to sapulopi passikolanna kaha-kaha ia too, iya tä' deem pada sakeaha' lako Yakobus anna Yohanes. ");
INSERT INTO ptu_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Nasuhum natambai asam Puang Yesus anna napa'tula'i naua: “Muissanna' muua indo to disangai to ma'pahenta umpahenta pakketauanna umpake palu-palu bassi, anna ingganna to kasallena umpalao makahha' kakuasaanna lako to nalumbäi. ");
INSERT INTO ptu_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Sapo' ikoa'-iko, tä'koa' la mala ma'pateem. Aka iai too maelo' la diangga' illaam alla'-alla'mua', iam too la umpopengkadio kalena dio olona solana sihhapam mesa sabua'. ");
INSERT INTO ptu_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Anna menna-menna maelo' la mendadi to kasalle, tau ia too la pahallu umpomahempo penabanna anna la ahu' dipakasua-sua illaam ingganna-ingganna sia. ");
INSERT INTO ptu_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Aka susimä' Kao to disangai Änä' Mentolino tä' suleä' la dipamoloi, sapo' suleä' la umpamoloi hupatau anna la ahu'pä' dipakattu sungnga' aka la ussolonnä' tau buda dio mai dosana anna malai lappa'.” ");
INSERT INTO ptu_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Pissam wattu Puang Yesus sola passikolanna lambi' lako kota Yerikho. Messubunni illaam mai indo kota, iya ma'silullu'um tau untuhu'i. Iya deemmi mesa to buta isanga Bartimeus änä'na Timeus, muokko' dio bihim lalam aka si kapelau-lau lako to liu lalam. ");
INSERT INTO ptu_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Tappana nahingngi dio hia heem Puang Yesus to Nazaret iya metamba-tamba siaham naua: “O Yesus peampoanna tomahaja Daud, kamaseiä' kao.” ");
INSERT INTO ptu_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Sapo' nakuapai hi tau buda naua: “Pengkamma'ko!” Sapo' tuttuam napekasallei mandi metamba naua: “O peampoanna tomahaja Daud kamaseiä' kao!” ");
INSERT INTO ptu_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Iya tohhom Puang Yesus anna ma'kadai naua: “Tambaiannä' mai.” Iya sikauntambaim duka' indo to buta anna nauaanni: “Pomahannui penabammu ammu ke'de' aka natambaingko!” ");
INSERT INTO ptu_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Iya untampe bäbäm bajunna anna napasihha'i ke'de' le'ba' napellambi'i. ");
INSERT INTO ptu_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Iya nakutanaim Puang Yesus naua: “Aka umpohäe la kupogausangko?” Iya natimba'um naua: “O Tuangguhu, maelo' punalaä' duka' la paita.” ");
INSERT INTO ptu_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Iya nauaammi: “Bono'ungko aka ungkatappa'iä'. Le'ba'ungko too.” Iya paita eta siahanni anna le'ba'i untuhu' Puang Yesus. ");
INSERT INTO ptu_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Tappana la umpenandai Yerusalem Puang Yesus sola passikolanna, sikahuku'pi tondä' Betfage anna Betania dio Tanete Zaitun, iya ussuam dua passikolanna mendiolo ");
INSERT INTO ptu_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","naua: “Le'ba'koa' lako dio tondä' tapenandaia'. Aka sulekoa' too lako, iya ullambi'unna' mesa keledai lundaha disäke' lombe', tadeempi disäkei. Bukkaia' anna umbabaia' dio mai. ");
INSERT INTO ptu_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Anna maka' too deengkoa' ungkutanai naua: ‘Akanna mualaia'?’ uaanni: ‘Aka napahalluam Debata, anna la bale' dipasule siam sule.’” ");
INSERT INTO ptu_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Iya le'ba'i siaham anna nalambi' si'da mesa keledai lundaha dio olo ba'ba disäke' lombe', dio bihim lalam. Iya nabukkaim. ");
INSERT INTO ptu_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Wattu eta too deem sanaka-naka tau dio nalambi'. Naitanna indo tau nabukkai, iya tappa nakambahoannim naua: “Akanna umbukkaia'?” ");
INSERT INTO ptu_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Iya natimba'im susi indo tula' bali napakahi'diam Puang Yesus. Iya nauai mandam indo tau: “O, iya babaia' lao.” ");
INSERT INTO ptu_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Iya naalam indo keledai anna le'ba'i nababaam Puang Yesus. Sulei lako, muäläiim jubana anna nalapi'ianni, mane nasäkei Puang Yesus. ");
INSERT INTO ptu_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Wattu eta too buda tau muäläi jubana anna naampa'i lako lalam la naolanna Puang Yesus tanda pa'pakasallena, anna deem toi duka' tau muampa' palapa andulam naala lako bela'. ");
INSERT INTO ptu_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ingganna tau to ullahui susi yolona teem ibundinna sikaahhe naua: “Tapujia' Puang Allataala! Katambasam to sule illaam sanganna Debata! ");
INSERT INTO ptu_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Natamba' Puang Allataala pessubunna tomahaja Daud to la dipotomahaja allo di dako'na. Tapa'kasalleia' Puang Allataala To Handam Matande!” ");
INSERT INTO ptu_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Landa'na Puang Yesus lako Yerusalem, tappa melolo tama Banua Debata anna napahessa asanni lao pali'. Sapo' aka la bengim, iya bale' le'ba' lako Betania solai sapulo dua passikolanna. ");
INSERT INTO ptu_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Masiä polei, mengkalao oom Puang Yesus sola sapulo dua passikolanna. Umpelleinna tondä' Betania, iya tadea'um ia Puang Yesus. ");
INSERT INTO ptu_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Mennenne'um lao, iya muita mambelam kaju ara tumalumbum daunna. Iya napenandaim lako aka naua inabanna: “Umba ke deenni buana.” Sapo' sulei lako, anggam daunna nalambi', tadeem buana aka abana taia opi wattunna la kembua. ");
INSERT INTO ptu_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Tappa napanata'i Puang Yesus naua: “Tä'um iko deem la naande hupatau buamu sule lako salako-lakona.” Iya indo tula'na nahingngi asam duka' passikolanna. ");
INSERT INTO ptu_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Tappana sulei lako Yerusalem Puang Yesus sola passikolanna, iya le'ba'im tama pa'hanteanna Banua Debata. Sulei tama, iya ullambi'um to si balu'-balu' illaam. Tappa nasua siaham lao Puang Yesus anna napembalisannii mejana indo to si ussuka'i doi'na to buttu dio mai botto senga' anna usseham okkosanna to si umbalu' dangam-dangam. ");
INSERT INTO ptu_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Anna ingganna to la umbaba aka-aka tä' napäbäi muola tama Banua Debata. ");
INSERT INTO ptu_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Mane ma'pa'guhui lako tau buda naua: “Tä' daka tia puha tisuha' illaam Battakada Debata naua: ‘Banuangku la naongei ingganna hupatau ma'sambajam,’ sapo' umpadadi hia' iko pa'mesaanna pa'bulele kalasi anna pa'tombonganna to maboko allo.” ");
INSERT INTO ptu_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Tappana nahingngi kapala sando sola to ullatta' Pepaondonganna Musa kadadiam ia too, iya ma'pattujuim la napeä lalanna anna mala dipatei Puang Yesus. Aka silele mahea' lako tappana muita buda tau nakapilla'i pepa'guhuanna. ");
INSERT INTO ptu_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Mahammoi, messubum oom Puang Yesus sola passikolanna umpellei Yerusalem. ");
INSERT INTO ptu_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Tappana masiä pole, mebengngi'-bengngi'pi anna liu oom Puang Yesus sola passikolanna lako indo kaju ara. Iya naitam mahekko'um sule dokko waka'na. ");
INSERT INTO ptu_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Iya nakilalai siaham Petrus indo puha naua Puang Yesus teem isamai' lako indo kaju ara. Iya ma'kadam Petrus naua: “O Tuangguhu, petua' siai dio kaju ara puhanna umpanata'i, iya mahekko' siaham.” ");
INSERT INTO ptu_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Iya nauam Puang Yesus: “Katappa'ikoa' Puang Allataala! ");
INSERT INTO ptu_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Aka maka' ussua inde dio buntu mentieli' tama le'bo', iya la mala si'da tiäkä' tama ke deennia' kamatappasammu. Sapo' maka' bata-batakoa', iya tä' la mala dadi. ");
INSERT INTO ptu_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Iam too anna kuuaammokoa', iai too umpelaua' längäm Puang Allataala sola ponno kapahhannuam, tä' mala tala untahimaa'. ");
INSERT INTO ptu_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Anna maka' la ma'sambajangkoa' anna deenni pi'di' penabammua' lako mesa tau, ampunniia' yolo mane ma'sambajangkoa' anna mala naampunniangkoa' kasalaammu Ambemu yabo suhuga.” ");
INSERT INTO ptu_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Sapo' maka' tä'koa' muampunni kasalaanna padammu, iya tä'koa' too duka' la naampunniam kasalaammu Ambemu yabo suhuga. ");
INSERT INTO ptu_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Iya ma'pasuleim sule lako Yerusalem Puang Yesus sola passikolanna. Pissam wattu mahassanni ma'lao-lao illaam Banua Debata, iya sulem sanaka-naka kapala sando anna to ullatta' Pepaondonganna Musa sola matua ulunna to Yahudi umpellambi'i Puang Yesus ");
INSERT INTO ptu_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","anna nauai: “Aka isanga umpolalam anna umpogau'i inde mai ingganna pa'pogausam, anna menna umbeengko kakuasaam?” ");
INSERT INTO ptu_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Sapo' natimba' naua: “La kukutanaikoa' duka' yolo, puhapia' untimba'i mane kutulasangkoa' duka' menna umbeennä' inde kakuasaam. ");
INSERT INTO ptu_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Menna umbeenni kakuasaam Yohanes anna si mantedo'i? Puang Allataala haka hupatau haka? Timba'ipia'!” ");
INSERT INTO ptu_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Iya sipa'tula'-tula'um naua: “Mapahhi' la ditimba'i, aka taua hia' manii: ‘Kakuasaanna Puang Allataala,’ iya la nauaammakia' too: ‘Akanna tä'ia' ungkatappa'i?’ ");
INSERT INTO ptu_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Iya taua hia' manii: ‘Kakuasaanna hupatau,’ iya tä' ohi aka inde Yohanes nakatappa'i asam tau naua: ‘Abana mesa nabi.’” ");
INSERT INTO ptu_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Lambi' angga ham pentimba'na lako Puang Yesus naua: “Tä' kiissam la kitimba'i indo pekutanaammu.” Nasuhum naua Puang Yesus: “Maka' susi, iya tä' duka' kuaku la kutulasangkoa' menna umbeennä' kakuasaam nasuhum kupogau' kaha-kaha ia too.” ");
INSERT INTO ptu_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Anna mane umpalao pehapangam Puang Yesus lako indo to mekutana ingngena' naua: “Pissam wattu deem mesa tau umbukka bela' anggur anna nabalai lao pali'. Puhai, umbo'bä'um pallullusam anggur mane umpake'de'i lempo batu la naongei to mangngampa. Puha asanni, iya napa'petesangammi anna le'ba'i lako botto mambela. ");
INSERT INTO ptu_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Tappana naagiam la matäsä' indo bua anggurna, iya ussuam mesa sabua'na le'ba' umpellambi'i indo to mantesanna aka la natahimaam bahena. ");
INSERT INTO ptu_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Sapo' sulei lako, iya ke nasakka hi ia, anna natembe' pusoi mane nasuai ma'pasule ma'pala' lo'bä. ");
INSERT INTO ptu_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Iya ussua pole oom mesa sabua'na le'ba' pole lako indo to mantesam. Sulei lako, natembe' pole oom lambi' basa-basa ulunna anna napakasihi'-sihi'i. ");
INSERT INTO ptu_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Iya ussua pole oom mesa sabua'na. Sapo' sulei lako, tä'um ia pole' angga natembe', sapo' toko napateim ia. Tä' angga ia mandi inde, sapo' budapi senga'na, deem natembe' anna deem napatei. ");
INSERT INTO ptu_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Nasuhum angga ham änä' pangkaha'na da'da'. Katampasanna nasua pissammi indo änä'na aka naua inabanna: ‘La nakalaja'um tia pole' inde änä'ku.’ Sapo' sulei lako indo änä'na, ");
INSERT INTO ptu_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","iya sipattuju-tuju oom indo to mantesam naua: ‘Iam too inde to la ullombum kullena tomatuanna. Tapateia' anna mala taalaa' inde bela'na.’ ");
INSERT INTO ptu_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Lambi' nasakka anna napatei, mane natibei lako bihim bela'.” ");
INSERT INTO ptu_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Puhai umpalao pehapangam Puang Yesus, iya ma'kadam naua: “Aka umbai' la napogausam indo puäna bela'? Tä' mala tala lao napempa'deam indo to mantesanna anna napa'petesangam polei indo bela'na lako tau senga'. ");
INSERT INTO ptu_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Tä' daka' tiko deem umbata illaam Battakada Debata naua: ‘Indo batu natibe tukam, ia leko' di diala dipobatu longkahhim. ");
INSERT INTO ptu_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Kaha-kaha ia too mala dadi aka pa'pogau'na Debata, anna takamängä-mängäia' kita pa'pogausam ia too!’” ");
INSERT INTO ptu_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Sapo' tappana nahingngi pangngulunna to Yahudi indo pa'tula'na Puang Yesus, iya nauam: “Kitaa' napasihim.” Iya umpeäm lalam anna mala disakka Puang Yesus sapo' mahea' lako tau buda sampe napellei bäbäpi. ");
INSERT INTO ptu_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Puhai ia too, ussuam sanaka-naka to illaam kakalebuanna Parisi anna to muundu'i tomahaja Herodes indo pangngulunna to Yahudi umbaba mesa pekutanaam lako Puang Yesus, aka pattujunna umba ke malai napetidom. ");
INSERT INTO ptu_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Iya umpellambi'im Puang Yesus indo to disua anna natede-tedei naua: “O Tuangguhu, kiissam kiua mesako to umpake tappa' anna sindoho anna moi menna tala ungkahea'i. Aka Iko to umpapada-pada bäbäko hupatau, anna anggako umpepa'guhuam ulalanna Puang Allataala sola undu' lollä.” Anna mekutanai naua: “Situhu' peadasam, sipäto' dakika' umbaja' sima lako tomahaja dio Roma, tä' daka?” ");
INSERT INTO ptu_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Sapo' naissam Puang Yesus pudu' pandenna lila manähäna lambi' ma'kada naua: “Akanna umpalilingannä' tangnga'? Babaampä' mai mesa doi' peha'mua' angku petua'i!” ");
INSERT INTO ptu_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Iya mualam doi' peha' anna nabeenni. Iya mekutana pole oom naua: “Menna kegamba' anna menna kesanga inde dio doi'?” Iya natimba'im naua: “Gamba'na anna sanganna tomahaja dio Roma.” ");
INSERT INTO ptu_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Iya nauam Puang Yesus: “Maka' susi, iya beennia' tabana tomahaja dio Roma la sipäto'na umbeem, anna beennia' duka' Puang Allataala la sipäto'na umbeem.” Iya pilla' asam uhhingngii lambi' ma'kada naua: “Tä' deem diola lako.” ");
INSERT INTO ptu_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Puhai ia too, iya sulem sanaka-naka to illaam kakalebuanna Saduki battu diua to tä' ungkatappa'i katuboanna sule to mate umpellambi'i Puang Yesus, anna nakutanai naua: ");
INSERT INTO ptu_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“O Tuangguhu, puhangkia' nasuhasam Musa illaam suha' pepaondonganna naua: ‘Maka' deem mesa muane mate anna tä'i deem änä'na, iya indo siam solasubunna la umpobainei indo bainena, anna mala deem pessubunna.’ ");
INSERT INTO ptu_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Iya la maakam ia susi indee: aka pissam wattu deem pitu muane ma'solasubum. Uhuna kebaine indo handam ulua. Sapo' tä'pi deem änä' nasibalii indo bainena anna matem indo muane. ");
INSERT INTO ptu_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Iya napessullem mesa solasubunna napobaine indo bainena. Sapo' tä'pi masäe napobainena anna mate pole oom duka', tä'pi duka' deem änä'na nasibalii indo baine. Iya susi siam duka' indo solasubum katallunna. ");
INSERT INTO ptu_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Ma'sahha' tula', sampe indo pitu to ma'solasubum sibala'-bala' umpobaine indo mesa baine sapo' sangngim tä' deem änä' nasibalii. Iya tappana tappu'i indo muane mate asam, iya matem duka' indo baine. ");
INSERT INTO ptu_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Dadi, maka' lambi'um wattunna la tubo sule to mate, iya mennannam kabam la napomuane indo baine, aka bali asam di napomuane indo to pitu ma'solasubum?” ");
INSERT INTO ptu_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Natimba' Puang Yesus naua: “Inna la muua hia' tia, aka bulingkoa'. Aka tä'koa' muissam manappa kalembasanna Battakada Debata anna tuli tamuissangkoa' ia kakuasaanna Puang Allataala. ");
INSERT INTO ptu_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Aka susi hia' tia inde ä: maka' too tubom tau sule dio mai alla'na to mate, iya tä'um tia deem to la siala anna tä' toi deem to la ma'pasiala. Sapo' umba susi katuboanna malaika' yabo suhuga tä' kemuane tä' kebaine, la susim too duka' hupatau. ");
INSERT INTO ptu_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Mane deenni, tä' paka' tiko deem umbata diona katuboanna sule to mate illaam suha' Pepaondonganna Musa, indo tulasanna api ma'nala-nala illaam satoo' kaju-kaju naongei buttu kadanna Puang Allataala lako Musa naua: ‘Kaom too inde Puang Allataala to napenombai Abraham, Ishak, anna Yakub?’ ");
INSERT INTO ptu_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Dadi moinna anna puham mate indo to tallu, sapo' mannassa anna tuboi temo aka anggam to tubo mala umpenombai Puang Allataala. Dadi mannassa anna bulim si'da-si'dakoa'!” ");
INSERT INTO ptu_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Tappana mahassam sipa'tula' Puang Yesus sola indo to illaam kakalebuanna Saduki, iya sulem mesa to ullatta' Pepaondonganna Musa anna napehingngii indo kasitimbasanna. Nahingnginna, tappa naakui illaam penabanna naua: “Tappa' inde pentimba'na Puang Yesus.” Nasuhum mekutana lako naua: “Umbannam kabam handam pahallu dipa'kasallei pada indo pahenta?” ");
INSERT INTO ptu_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Iya natimba'im naua: “Handam too'na pahenta indo to puha napepaondongam Musa naua: ‘Pehingngiia' to Israel, anggam mesa Debatanta, diuaam Puang Allataala. ");
INSERT INTO ptu_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","La ungkamaseia' sola sakalebu penabammu anna mentu' pikkihammu anna mentu' kamatohoammu.’ ");
INSERT INTO ptu_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Mane deenni: ‘La ungkamaseikoa' padammu hupatau umba susi ungkamasei kalemu.’ Iam too inde dua too'na pahenta. Tä'um deem tando längänna pole.” ");
INSERT INTO ptu_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Iya ma'kadam indo to ullatta' Pepaondonganna Musa naua: “Tappa' tula'mu Tuangguhu, Puang Allataala anggam mesa aka tä'um deem debata senga'. ");
INSERT INTO ptu_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Anna abana hupatau pahallu la ungkamasei Puang Allataala sola sakalebu penabanna anna mentu' pikkihanna anna mentu' kamatohoanna, anna la ungkamasei padanna hupatau umba susi ungkamasei kalena. Kalando hi tia pa'pogausam susi anna la umpadeem tunuam sola pemala' senga' lako olona Puang Allataala.” ");
INSERT INTO ptu_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Tappana nahingngi Puang Yesus indo tula'na mapia, iya nauaammi: “Saidi' danni anna tamendadingko pakketauanna Puang Allataala.” Lessu'na eta too tä'um pole' deem tau la bahani umpadeem pole pekutanaam lako Puang Yesus. ");
INSERT INTO ptu_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Mahassanni ma'pa'guhu Puang Yesus illaam Banua Debata, iya umpalaom pekutanaam naua: “Maaka hia anna nauai to ullatta' Pepaondonganna Musa: ‘Indo To nalanti' Puang Allataala la mepasalama' peampoanna Daud?’ ");
INSERT INTO ptu_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Aka Daud duka' to nasahum Penaba Maseho anna nauai: ‘Ma'kada Puang Allataala lako Debatangku naua: Okko'ko dio tandai kanangku sule lako wattunna la kupopa'bukku ingganna balimmu dio olomu lambi' uhhondoi dokko.’ ");
INSERT INTO ptu_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Dadi makaleso anna ma'kalei Daud muuai: ‘Debatangku To nalanti' Puang Allataala.’ Iya maaka hi susi anna la ia ohi umpoampoi?” Tula'na Puang Yesus napatananni talinga tau buda aka tä' deem pada sanapohäe. ");
INSERT INTO ptu_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Illaam pepa'guhuanna Puang Yesus naua: “Majagakoa' lako to ullatta' Pepaondonganna Musa indana napabulingkoa'. Aka si biasa too ma'lao-lao tama pasa' ma'baju tihui' anna maelo' dipa'kasallei. ");
INSERT INTO ptu_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Anna si moka muokko' illaam pa'sambajangam ke tä'i dio olo, anna si umpise'i toi ongeam dipa'kasalleinna ke illaanni pa'hame-hameam. ");
INSERT INTO ptu_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Anna si umpamasingam tula' to balu-balu baine lambi' sule lako banuanna naala. Si naägä'i umpakalando sambajanna anna mala nauaam tau: ‘Tau mapia’ anna ke tau kadake hia. Nasuhum la nalambi' pesämbä' mabanda'na Debata.” ");
INSERT INTO ptu_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Pissam wattu muokko' Puang Yesus untingngajoi patti pehumalasam illaam Banua Debata, anna umpetua'i to umpatama patti bua pemala'na. Iya sulem buda to makaka umbaba doi' anna si buda napatama. ");
INSERT INTO ptu_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Pissananna iya sulem duka' mesa to balu-balu baine anna mase-mase polepi, umbaba dua doi' gällä handam saidi' angga'na napatama. ");
INSERT INTO ptu_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Iya untambaim passikolanna anna nauai: “Kutulasangkoa', buda puha ia bua pemala'na inde to balu-balu baine anna la ingganna inde to umpatama bua pemala'na. ");
INSERT INTO ptu_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Aka inde lako tau la'binna ia kullena napatama. Sapo' inde ia to balu-balu baine moi anna mase-mase, napebeem asam ia indo deenna lako kalena, moi anna anggam ia la napotubo.” ");
INSERT INTO ptu_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Tappana messubum Puang Yesus illaam mai Banua Debata, iya ma'kadam mesa passikolanna naua: “Tuangguhu, petua'pi Iko inde dio hindim batu tä' deem pada samatoto' anna inde banua tä' deem pada samapia.” ");
INSERT INTO ptu_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Iya natimba'im naua: “Muita inde banua tä' deem la susi mapianna sapo' tä' deem moi podo la mesa batunna la tiäto' liu sitodo' solana aka pissam wattu la ditaleam asam.” ");
INSERT INTO ptu_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Anna mane le'ba' längäm Tanete Zaitun Puang Yesus sola Petrus, Yakobus, Yohanes, anna Andreas anna muokko'i yabo paka-paka ia, mengngolo libam Banua Debata. Iya mekutanaim naua: ");
INSERT INTO ptu_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“O Tuangguhu, tulasampakam piham la dadi ingganna indo puha untula' ingngena'? Anna aka la tandana kela lambi'um wattunna la ditaleam?” ");
INSERT INTO ptu_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Sapo' ma'kada Puang Yesus naua: “Majagakoa' indana deenni tau la umbaba bulingkoa'! ");
INSERT INTO ptu_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Aka la buda too tau sule umboko sangangku anna la buda tau nababa bulim aka la naua: ‘Kaom too inde To nalanti' Puang Allataala.’ ");
INSERT INTO ptu_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Maka' too uhhingngingkoa' ahhena to sipate-patei anna kahebanna to sibundu'-bundu', iya tä'koa' too la mahea' aka abana hi tia inna la dadi kaha-kaha ia too, sapo' taiapi indo allo ma'katampasanna. ");
INSERT INTO ptu_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Aka la sipate-patei hupatau anna kahajaam pada kahajaam la sibundu'-bundu'. Anna umba-umba ngei ongeam la dadi lino' kasalle anna la sule kakobeam. Sapo' ia asanna ia too mane pa'pahandusanna kamapi'disam sihhapam mesa baine mane mahassam mangnguhiba'. ");
INSERT INTO ptu_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Sapo' pahallukoa' majaga, aka la disakkakoa' anna dibehokoa' lako to mahhotto' illaam peadasam anna la ditembe'koa' illaam pa'sambajangam. Anna mane dibabakoa' lako olona to ma'pahenta anna tomahaja aka untuhu'ä'. Iya wattu etam too la muongeia' mendadi sa'bingku dio olona. ");
INSERT INTO ptu_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Aka Kaheba Katilallasam la dipa'paissangam yolo sule lako lili'-lili'na lino. ");
INSERT INTO ptu_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Mane deenni, maka' too disakkakoa' anna dibabakoa' lako to ma'pahessa, iya tä'koa' la umpakabeba penabammu la muua: ‘Aka amom isanga la diua mentimba'?’ Sapo' wattu eta too la untula'a' indo to napasondoiangkoa' Puang Allataala. Aka indo tula' la umpopentimba'a' taia tula' di kalemu bäbä, sapo' tula'na Penaba Maseho. ");
INSERT INTO ptu_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Anna la kende' too tatta' asu lambi' to ma'solasubum la palla' penabanna umpopepatei solasubunna. Susi toi duka' ambe la umpallasam änä'na anna änä' la umbali tomatuanna sampe napatei. ");
INSERT INTO ptu_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Anna la nakabassi asangkoa' too tau aka ungkatappa'iä'. Sapo' iai too mentobe manda' anna mengnganti matoto' illaam kamatappasam lako kaleku sule lako ma'katampasanna, tau iam too la dipasalama'.” ");
INSERT INTO ptu_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Maka' muitakoa' ‘To ungkähä kakadakeam la metallangam,’ ke'de' illaam ongeam tasihatanna la naongei, indo to dio Yudea pahallu sikalumpa' längäm tanete. (Inde kada la pahallu napasalui manappa penabanna to mambata.) ");
INSERT INTO ptu_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Anna to sulibanna banua tä'um la tama banua muala pahuhunna ");
INSERT INTO ptu_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","anna to mahassam dio bela' tä'um la ma'pasule lako banuanna muala pohebana, anna mala masimpam muäläi kalena le'ba' umpellei indo kamasussaam. ");
INSERT INTO ptu_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Tä' ia deem pada samasussa lako baine to mahassam kebättä anna to ma'pasusu. ");
INSERT INTO ptu_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Pa'sambajangkoa' anna mala tä' dadi indo kadadiam ia too illaam wattu palauham. ");
INSERT INTO ptu_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Aka wattu eta too la kende' pi'di' tanggana-gana. Pi'di' susi ia too tä'pi deem nasi'dim hupatau handu' napadadinna Puang Allataala inde lino sule lako temo. Sapo' lessu'i too, iya tä'um deem la kende' pole pi'di' susi. ");
INSERT INTO ptu_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Aka maka' hapanna la masäe wattunna mane napamondai Puang Allataala kaha-kaha ia too, iya tä'um deem la tubo hupatau moi podo la mesa. Sapo' kahana pa'kamasena lako hupatau to puha napilei mendadi umma'na, nasuhum la bale' napamonda kamasussaam ia too. ");
INSERT INTO ptu_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Mane deenni, maka' too deem tau muuaangkoa': ‘Indem indo To nalanti' Puang Allataala!’ battu haka naua: ‘Dionnä!’ iya tä' la umpehingngiia'. ");
INSERT INTO ptu_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Aka la buda too tau naägä'i naua: ‘Kaom too indo To nalanti' Puang Allataala.’ Anna deem toi la muuai: ‘Kaom too mesa nabi.’ Anna indo tau la deem duka' pa'pogausam mepilla'-pilla' napadadi anna tanda memängä-mängä, aka naua pattujunna: ‘Umba ke deenni tau to puha dipilei kubaba bulim.’ ");
INSERT INTO ptu_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Dadi la muissanna' unjagai aka puhangkoa' kupayolo lambangam ingganna kaha-kaha ia too.” ");
INSERT INTO ptu_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Puhai too indo kamasussaam, iya la pi'de mata allo anna tä'um la paindo bulam, ");
INSERT INTO ptu_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","anna la honno'i yabo mai langi' bintä anna ingganna issinna langi' la titehha' bäbä. ");
INSERT INTO ptu_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Anna wattu eta too ingganna hupatau la naitaä' to disangai Änä' Mentolino tuhum yabo mai langi' illaam gabum naponnoi kakuasaam taditondom anna kamatandeam. ");
INSERT INTO ptu_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Anna la ussuaä' ingganna malaika'ku lao nahempungannä' ingganna hupatau to puha kupilei illaam inde lino mengkalao illaam mata allo sule sau' katampusam anna mengkalao illaam inde lino sule lako handanna langi'. ");
INSERT INTO ptu_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Diona kaha-kaha ia too, mala diala pehapangam dio mai mesa kaju ara. Maka' too mukku'um tähe'na anna kendaum händäm, iya la muissammia' too muua la bale' sulem kulla' kalando. ");
INSERT INTO ptu_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","La susim too ke muitanna' dadi indo puha kutulasangkoa', iya la muissammia' too duka' muua la bale' sule lakom indo pattujunna Puang Allataala. ");
INSERT INTO ptu_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Setongam-tonganna, ingganna kaha-kaha ia too la dadi yolo anna mane mate asam ingganna to tubo lapi' temo. ");
INSERT INTO ptu_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Langi' anna lino la pa'de ke dako'i, sapo' kadangku ia, la da'da' liu sule lako salako-lakona. ");
INSERT INTO ptu_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Sapo' setonganna tä' deem moi podo la mesa tau muissanni wattunna kaha-kaha ia too. Moi malaika' yabo suhuga tala naissanni, moi Änä'na Puang Allataala, anggam mesa-mesanna Ambeku yabo suhuga muissanni. ");
INSERT INTO ptu_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Dadi la majaga si'da-si'dakoa' aka tä' la muissanna' wattunna. ");
INSERT INTO ptu_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","La sihhapam mesa puäna banua la le'ba', sapo' umbeem kakuasaam sabua'na anna nabahe-baheanni pengkähängam. Anna umpakahi'dii to unjagai ba'ba naua: ‘La majaga si'da-si'dako too le!’ ");
INSERT INTO ptu_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Iam too anna la majagangkoa' aka tä' la muissanna' wattu kasuleanna indo puäna banua. Battu la mahammo hi, battu la tängä hi bengi, battu la moni hi mäne', battu la mebengngi' di. ");
INSERT INTO ptu_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Aka toko sule säkä-säkä manii anna nalambi'koa' mamma'. ");
INSERT INTO ptu_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Inde tula'ku tä' anggam ikoa' kuuaam sapo' kuuaam asam duka' ingganna tau: La majagakoa'!” ");
INSERT INTO ptu_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","La dua bengipi mane lambi' oi wattunna dipakahoa' pengkilalaam allo Kalappasanna to Yahudi dio mai kasabuasam anna allo kasalle Hoti Tä' Diboloi Bibi' Hoti. Iya umpeäm lalam kapala sando sola to ullatta' Pepaondonganna Musa la ussakka membuni Puang Yesus aka la napatei. ");
INSERT INTO ptu_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Sapo' nauai: “Tä' la tapasipatuia' allo kasalle, indana kende'i passikallaam illaam botto.” ");
INSERT INTO ptu_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Pissam wattu dio tondä' Betania Puang Yesus mahassam mangngande illaam banuanna Simon indo to dolengam yolona. Iya sulem mesa baine umbaba mesa buli-buli mapindäm, kessi minnä'-minnä' bubanau' si masulli' allinna. Iya tappa napoloi siahanni ulunna indo buli-buli, anna natolloanni yabo ulunna Puang Yesus tanda pa'pakasallena. ");
INSERT INTO ptu_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Deem sanaka-naka tau meali-ali muitai, lambi' sipa'tula'-tula' naua: “Aka oom ia duka' gunana minnä'-minnä' masulli' dikatoa-toai? ");
INSERT INTO ptu_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Dotam tia dibalu' anna ditabaanni to mase-mase allinna, aka maka' la dibalu' deem la si tallu pulo bidä allinna.” Lambi' silele keaha' lako indo baine. ");
INSERT INTO ptu_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Sapo' naua Puang Yesus: “Akanna umpasalakoa' inde baine? Päbäi mammi napateem. Aka inde napateem, mesa pa'pogausam mapia lako kaleku. ");
INSERT INTO ptu_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Aka to mase-mase ia la sola-sola liukoa'. Malaa' umpamoloi ke abanai deenna' kamamaseammu. Sapo' Kao-Kao tä'kia' la sola liu. ");
INSERT INTO ptu_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Iya inde ia baine napogau' loppo'um ia indo malanna napogau'. Aka inde natolloiä' minnä'-minnä'na temo, napogau' loppo'um ia indo la dipogau' ke dilamummä'. ");
INSERT INTO ptu_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Setongam-tonganna, umba-umba naongei Kaheba Katilallasam dipa'pakahebaam, etam too duka' la dipotulasam pa'pogausanna inde baine anna mala dikilalai liu.” ");
INSERT INTO ptu_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Deem mesa to tihekem sapulo dua passikolanna Puang Yesus isanga Yudas Iskariot, le'ba' umpellambi'i sanaka-naka kapala sando aka illaam penabanna maelo' la umbalu' Puang Yesus. ");
INSERT INTO ptu_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Sangngim kassi uhhingngii anna ma'dandi la nabeem doi'. Iya umpeä lium lalam Yudas la umbalu' Puang Yesus. ");
INSERT INTO ptu_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Illaam pa'pahandusanna allo kasalle Hoti Tä' Diboloi Bibi' Hoti si ditunu domba pengkilalaam Kalappasanna to Yahudi dio mai Kasabuasam. Allo eta too ma'kada passikolanna lako Puang Yesus naua: “La lu umbakam ngei umpatokaangko kinande indo si diande ke umpengkilalai tau allo Kalappasam?” ");
INSERT INTO ptu_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Iya ussuam dua passikolanna naua: “Le'ba'koa' libam kota Yerusalem, iya la silambi'ungkoa' too mesa muane umbaba busso kessi uwai. Tuhu'ia' ");
INSERT INTO ptu_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","lako banua naongei anna muuaannia' indo to ma'banua: Nauaangkam Tuangguhu: ‘Uaanni: Umba ngei tambim to bali umpatoka la kiongei sola Tuangguhungki mangngande kinande allo Kalappasam?’ ");
INSERT INTO ptu_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Iya la napaitaingkoa' too mesa tambim kalua' tando längäm puha asammi napatoka sule lako pangkakka'. Etanna' too la muongei ma'patoka.” ");
INSERT INTO ptu_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Iya le'ba'um indo dua passikola libam Yerusalem. Sulei libam, nalambi' si'da susi liu indo tula'na Puang Yesus. Iya napatokam indo kinande si diande illaam allo Kalappasam. ");
INSERT INTO ptu_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Bengii, sulem Puang Yesus umpasola sapulo dua passikolanna. ");
INSERT INTO ptu_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Mahassanni mangngande, iya nauam Puang Yesus: “Setongam-tonganna, deem mesa solamua' illaam inde alla'-alla'taa' la umbalu'ä'.” ");
INSERT INTO ptu_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Iya sangngim masussa penabanna anna sibala'-bala'i mekutana naua: “Taia mammaka kao, Tuangguhu?” ");
INSERT INTO ptu_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Natimba'im naua: “Sala'-sala' mennammua' inde to sapulo duakoa'. Iai too kusolapihingam unduho hoti, iya iam too. ");
INSERT INTO ptu_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Abana hi tia Kao to disangai Änä' Mentolino inna la mateä', umba susi puha tisuha' illaam Battakada Debata. Sapo' tä' deem pada satilaka lako indo to umbalu'ä'. Mala leko'um ia kela tä'um ia didadiam!” ");
INSERT INTO ptu_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Mahassanni mangngande, iya mualam mesa hoti Puang Yesus anna nakuhhu'i sumanga' längäm Puang Allataala mane napiä'-piä'i anna nabeenni lako passikolanna napasindum naua: “Iam too inde baleku, alaia' ammu andei.” ");
INSERT INTO ptu_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Puhai, mualam mesa ihusam kessi anggur anna nakuhhu'i sumanga' mane nabeem oi lako passikolanna. Iya naalam duka' anna nasibala'-bala'i naihu'. ");
INSERT INTO ptu_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Anna mane ma'kadai naua: “Iam too inde hahaku la dipatitollo la umpomannassa pa'dandianna Puang Allataala lako buda tau. ");
INSERT INTO ptu_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Setonganna kutulasangkoa': Tä'mä' Kao deem la muihu' pole anggur sampe lambi' wattunna la muihu'ä' anggur bakahu illaam kapahentaanna Puang Allataala.” ");
INSERT INTO ptu_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Puhai, iya umpenaniammi mesa pampujiam, mane le'ba'i längäm Tanete Zaitun. ");
INSERT INTO ptu_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Iya umpatahhu'um tula'na Puang Yesus lako passikolanna naua: “La le'ba'koa' umpelleiä' aka deem tisuha' illaam Battakada Debata naua: ‘La kupatei to ma'kambi'na anna ingganna dombana la tisembu' lao.’ ");
INSERT INTO ptu_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Sapo' maka' too dipatibangommä' sule, la kupendioloikoa' lako Galilea.” ");
INSERT INTO ptu_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Iya ma'kadam Petrus naua: “Moi la le'ba' asam solaku napelleiko, inna tä' sia kao deem la kupelleiko.” ");
INSERT INTO ptu_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Natimba' Puang Yesus naua: “Setongam-tonganna, illaam inde bengi tä'pi la penduam moni mäne' anna pentallummä' umbahoi.” ");
INSERT INTO ptu_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Sapo' tuttuam napomatohhä mandi duka' pa'kadanna Petrus naua: “Toko moiä' kao la dipatei solaki', tala kubahoiko!” Anna ingganna solana Petrus ma'kada susi siam duka'. ");
INSERT INTO ptu_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Puhai ia too, iya le'ba'um Puang Yesus sola passikolanna lu lako mesa ongeam isanga Getsemani. Dioi, muuaammi passikolanna: “Okko'ungkoa' too eta inde anna laopä' ma'sambajam.” ");
INSERT INTO ptu_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Umbabaim Petrus sola Yakobus anna Yohanes napasola. Tä' deem pada samahea' Puang Yesus anna husa' penabanna nasi'dim. ");
INSERT INTO ptu_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Nauam: “Masussa si'da-si'da penabangku kusi'dim, angga' la mateä'. Tohhongkoa' too eta inde, sapo' tä'koa' la lembe.” ");
INSERT INTO ptu_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Iya mentudendem saidi' anna untapposanni kalena dokko litä' napasindum ma'sambajam kela mala anna lappa'i dio mai kamasussaam ia too. ");
INSERT INTO ptu_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Naua: “O Papa', O Ambeku, tä' Iko deem aka ungkapusa'i ke umpoelo'i. Lappasannä' dio mai inde kamasussaam kuoloi temo, sapo' la pa'elo'mu dadi, taia la pa'elo'ku.” ");
INSERT INTO ptu_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Puhai ma'sambajam ma'pasulem. Iya ullambi'um indo to tallu to napasola ingngena' mahassam mamma'. Iya ma'kadam lako Petrus naua: “Simon, mamma'ko isanga? Tä' dakoka tiko mala majaga moi podo satette'um? ");
INSERT INTO ptu_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Majagakoa' ammu pa'sambajam indana napa'sändä'ikoa' setam. Aka abana hi tia mohäe penabammua' la umpalako kamaloloam, sapo' napomalammakoa' sipa' hupataummu.” ");
INSERT INTO ptu_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Anna mane le'ba' pole oo ma'sambajam, susi siam indo pa'sambajanna ingngena'. ");
INSERT INTO ptu_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Puhai, ma'pasule oom sule, iya nalambi' mamma' oo sule aka nataloi sugali'um matanna. Iya sangngim tä' bäbä naissam aka la naua mentimba'. ");
INSERT INTO ptu_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Tappana ma'pasule kapentallunna iya nauam: “Mamma' liupokoa' isanga? Tä' liupokoka' tiko malube! Sihuam tia! Aka lambi'um wattunna Kao to disangai Änä' Mentolino la dibehoä' tama pala' limanna to madosa. ");
INSERT INTO ptu_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Bangommokoa' anta laoa'. Petua'ia' diom mai indo to la umpopesakkaä'!” ");
INSERT INTO ptu_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Mahassampi ma'tula' Puang Yesus, iya sule ham Yudas indo to tihekem duka' sapulo dua passikolanna Puang Yesus umpasola tau buda sanda pa'dam sola bose, nasua kapala sando anna to ullatta' Pepaondonganna Musa sola matua ulunna to Yahudi. ");
INSERT INTO ptu_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Indo Yudas to umbalu'i, puham untula' loppo' tanda lako indo to napasola naua: “Iai too kuudum, iam too la ussakkaa' anna umbabai, sapo' jagai manappai.” ");
INSERT INTO ptu_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","46","Iya landa'i lako, tappa umpellambi'im Puang Yesus anna nauai: “O Tuangguhu!” anna mane naudum, iya sikanasakkam. ");
INSERT INTO ptu_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Deem mesa tau eta too ussintä' pa'danna anna umbattai mesa sabua'na sando too', iya mäläi talinganna. ");
INSERT INTO ptu_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Iya ma'kadam Puang Yesus lako indo tau buda naua: “Ussangaa' isanga pehampo'ä' anna sulekoa' sanda pa'dam sanda bose la ussakkaä'? ");
INSERT INTO ptu_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Kusanga allo-allokoa' kupa'guhu illaam Banua Debata iya tä' dä' ussakka. Sapo' abana hi tia la susi anna mala sule lako indo puha tisuha' illaam Battakada Debata.” ");
INSERT INTO ptu_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Iya sikalumpa'um lao ingganna indo passikolanna napellei. ");
INSERT INTO ptu_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Deem mesa änä' muane anggam sambu' illaam kalena le'ba' ia untuhu' Puang Yesus. Naanda'im duka' tau buda la nasakka, ");
INSERT INTO ptu_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","sapo' nalappa' indo sambu'na anna lumumpa'i lao ma'kambelä bäbä. ");
INSERT INTO ptu_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Iya dipasolam Puang Yesus lako sando too'. Eta too ma'hempum ingganna kapala sando anna matua ulunna to Yahudi sola to ullatta' Pepaondonganna Musa. ");
INSERT INTO ptu_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Iya natuhu' kalamba'um Petrus sule lako pa'hanteanna sando too' anna muokko'i mendähä sola to unjagai Banua Debata. ");
INSERT INTO ptu_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Iya umpalilimmi tangnga' kapala sando sola ingganna solana to tihekem duka' To Mahhotto'na to Yahudi la umpeängam tuntungam su'be' Puang Yesus anna nadakasam pa'posanga-sanga anna mala dipatei, sapo' tä' deem nalambi'. ");
INSERT INTO ptu_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Budapi tau si umpakolo'-kolo'i Puang Yesus, sapo' tä' deem mala sipako-pako tula'na. ");
INSERT INTO ptu_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Sanaka-nakapi tau ke'de' uhhängänni pa'pakolo'-kolo'inna solana naua: ");
INSERT INTO ptu_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Deem kihingngi tula'na inde tau naua: ‘La kukadakeam inde Banua Debata pa'papianna hupatau angku papia polei senga'na, la tallungngallo liu anna dadim aka taia pa'papia hupatau.’” ");
INSERT INTO ptu_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Sapo' tä' asam deem mala mentama tula'na. ");
INSERT INTO ptu_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Iya ke'de'um sando too' illaam alla'-alla'na tau anna ungkutanai Puang Yesus naua: “Tä' liu siam isanga la untimba'i inde lako pa'pahapa'na tau?” ");
INSERT INTO ptu_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Sapo' mengkamma' mandi Puang Yesus. Iya mekutana pole oom sando too' naua: “Iko si'da haka To dilanti' la mepasalama', Änä'na Puang Allataala To handam dipa'kasallei?” ");
INSERT INTO ptu_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Iya natimba'im naua: “Kaom too, anna illaam allo la taoloinna la muitakoa' Änä' Mentolino, battu diua Kao, la muokko' dio tandai kananna To Handam Kuasa anna la suleä' sule illaam gabum yabo langi'!” ");
INSERT INTO ptu_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Iya tappa umpessepäsam siaham pohebana sando too' aka keaha' anna nauai: “Akapi gunana la umpeä liukia' sa'bi? ");
INSERT INTO ptu_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Aka uhhingngi asammia' kadanna inde dio tau untelle Puang Allataala! Dadi maakaa' iko susi lalam penabammu?” Sangngim umpasala Puang Yesus anna nauai: “La dipatei.” ");
INSERT INTO ptu_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Iya deem sanaka-naka tau untikkudui anna mane nasapu'iam matanna anna nadänggu'i napasindum naua: “O nabi, pentopaipi, menna untappai limako?” Anna to ma'honda duka' untampilinni Puang Yesus. ");
INSERT INTO ptu_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Wattu eta too mahassampi dio pa'hanteam Petrus, iya sulem mesa baine sabua'na sando too'. ");
INSERT INTO ptu_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Tappana muita Petrus mahassam mendähä, iya napengkaleso-lesoim lindona anna nauaanni: “Iko duka' si sola liuko indo Yesus to Nazaret.” ");
INSERT INTO ptu_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Sapo' tappa ma'baho naua: “Tä' kuissam aka hi iko isanga untula',” anna le'ba'i lako olo ba'ba, iya moni siaham mäne'. ");
INSERT INTO ptu_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Puhai ia too, naita pole oom mesa sabua' baine. Iya ma'kadam indo baine lako to dio heem eta too naua: “Inde dio tau abana solana.” ");
INSERT INTO ptu_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Iya nabahoi pole oom Petrus. Tä' masäe, iya ma'kadam duka' indo to dio heem eta too naua: “Mannassa anna solanako aka to Galileako duka'.” ");
INSERT INTO ptu_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Iya ma'pindam pole' Petrus naua: “Naitaä' Debata, kela kuissanni indo to muuaanna'!” ");
INSERT INTO ptu_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Iya moni siaham mäne' kapenduanna. Iya tappa nakilalaim pole' Petrus indo tula'na Puang Yesus naua: “Tä'pi la penduam moni mäne' anna pentallummä' umbahoi.” Iya ma'pase'go'um sumahho. ");
INSERT INTO ptu_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Mebengngi'-bengngi'pi anna umpasahandammi kada kapala sando sola matua ulunna to Yahudi anna to ullatta' Pepaondonganna Musa sola to si mahhotto' illaam peadasanna to Yahudi. Iya umpungom Puang Yesus anna nababai lako olona Pilatus. ");
INSERT INTO ptu_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Mekutanam Pilatus lako Puang Yesus naua: “Ikongka indo tomahajanna to Yahudi?” Natimba'um naua: “Ikom ma'kale muuai.” ");
INSERT INTO ptu_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Iya ma'tula'um ingganna kapala sando umpakolo'-kolo'i Puang Yesus. ");
INSERT INTO ptu_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Mekutana pole oom Pilatus naua: “Tä' isanga la untimba'i inde mai tau? Uhhingngi haka buda natandasangko?” ");
INSERT INTO ptu_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Sapo' tä' liu siam mentimba' nasuhum mängä-mängä bäbä Pilatus. ");
INSERT INTO ptu_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Maka' lambi' oom allo kasalle ia too, si biasa dilappasam mesa to ditahungkum situhu' pelauanna tau buda. ");
INSERT INTO ptu_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Wattu eta too deem mesa to ditahungkum isanga Barabas anna budapi solana to puha papateam aka umbali-bali to ma'pahenta. ");
INSERT INTO ptu_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Iya sulem tau buda melau lako Pilatus anna mala dipalako kaha-kaha ia too susi biasa. ");
INSERT INTO ptu_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Iya mekutanam Pilatus naua: “La muaku haka' ke kulappasanni inde tomahajanna to Yahudi?” ");
INSERT INTO ptu_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Ia anna ma'kada susii Pilatus aka naissam naua ia hi tia anna nababai sule ingganna indo kapala sando aka nakembuhui. ");
INSERT INTO ptu_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Sapo' umpatudui tau buda indo kapala sando naua: “Pelauia' anna mala Barabas dilappasam.” ");
INSERT INTO ptu_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Iya mekutana pole oom Pilatus lako indo tau buda naua: “Maka' susi, iya aka la kupogausam inde to ussangaia' tomahajanna to Yahudi?” ");
INSERT INTO ptu_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Iya sikatambam naua: “Päso'i yabo kaju sitambem anna malai mate!” ");
INSERT INTO ptu_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Mekutana pole oom Pilatus naua: “Anu' aka hia kasalaanna?” Sapo' tuttuam sikaoli mandi naua: “Päso'i yabo kaju sitambem anna malai mate!” ");
INSERT INTO ptu_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Mohäe Pilatus la umpalossosam penabanna tau buda lambi' ullappasam ia Barabas anna ussuai tau untembe' talukum Puang Yesus mane napesuaanni dipäso' yabo kaju sitambem. ");
INSERT INTO ptu_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Iya napasolam sohodadu Puang Yesus lako Banua Gubernur indo si diongei ma'bisaha, anna untambai asanni ingganna sohodadu ma'hempum. ");
INSERT INTO ptu_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Anna napapakei juba mellolo pao susi bajunna tomahaja anna muananni songko' susi songko'na tomahaja sapo' keduhi anna napasongko'ianni. ");
INSERT INTO ptu_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Anna mane napekatabe'i lelem naua: “O tomahajanna to Yahudi, kipa'kasalleiko!” ");
INSERT INTO ptu_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Nahabi' bulo ulunna, natikkudui anna ma'balinguntu' lelenni menomba. ");
INSERT INTO ptu_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Puhai natelle, naäläiammi sule indo juba mellolo pao napapakeiam anna napapohebai sule indo inna pohebana. 15:20-32 Anna mane dibaba lao Puang Yesus la dipäso' yabo kaju sitambem anna malai mate. ");
INSERT INTO ptu_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Wattu eta too deem mesa tau isanga Simon to Kirene, ambena Aleksander sola Rufus, mane sule dio mai sulibanna kota Yerusalem. Iya napassaim umpassam kaju sitambenna Puang Yesus. ");
INSERT INTO ptu_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Indo sohodadu umpasola Puang Yesus lako mesa ongeam isanga Golgota, kalembasanna ongeanna kahohä' ulu. ");
INSERT INTO ptu_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Anna mane nabeem anggur sihau mur, sapo' tä' naaku naihu'. ");
INSERT INTO ptu_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Iya napalängämmi kaju sitambem anna mane nataba-taba pohebana sapo' naundi. ");
INSERT INTO ptu_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Tette' kaseham mebengngi' anna dipalängänni kaju sitambem Puang Yesus. ");
INSERT INTO ptu_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Yabo indo kaju sitambenna dituli' kasuhunganna anna dipäso'i, naua: TOMAHAJANNA TO YAHUDI. ");
INSERT INTO ptu_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Deem duka' dua pehampo' nasimbahaam dipäso' yabo kaju sitambem, mesa dio tandai kananna anna mesa dio tandai kaihinna. ");
INSERT INTO ptu_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Iya diganna'im issinna Battakadanna Puang Allataala naua: “La dihekem duka' mesa tau kadake illaam alla'na tau kadake.” ");
INSERT INTO ptu_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Ingganna to muolai ongeam ia too si muillim-illim tandana untelle Puang Yesus napasindum naua: “Kusanga paha' la ungkadakeangko Banua Debata anna la tallungngallo muolaam umpake'de' sule! ");
INSERT INTO ptu_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Iya lappasangko kalemu anna tuhungko yabo mai itim kaju sitambem!” ");
INSERT INTO ptu_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Susi toi duka' kapala sando anna to ullatta' Pepaondonganna Musa sipa'tula'-tula' mantelle naua: “Maka' tau senga' mala napasalama', sapo' maka' kalena tä' ohi ia mala napasalama'. ");
INSERT INTO ptu_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Maka' abana si'da tomahajanna to Israel anna To nalanti' Puang Allataala, iya la tuhummi too yabo mai inde dio kaju sitambem anna mala taitaia' anta katappa'ia'.” Moi duka' indo to dua to nasimbahaam dipäso' yabo kaju sitambem untelle duka' Puang Yesus. ");
INSERT INTO ptu_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Tappana tängä allo, iya malillim pättäm dio indo pa'lembängam sule lako tette' tallu kahubem. ");
INSERT INTO ptu_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Tette' tallui kahubem, iya metambam Puang Yesus naua: “Eloi, Eloi, lama sabakhtani?” Kalembasanna, O Puang Allataala, Debatangku, aka hi anna untampeannä'? ");
INSERT INTO ptu_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Nahingnginna petambana indo to ke'de' eta too, iya deemmi sanaka-naka muuai: “Pehingngiia'i, untambai nabi Elia!” ");
INSERT INTO ptu_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Iya napasihha'um mesa tau muala bunga karang anna nahammei dokko anggur maissu', mane napadekke'i lako pesoka anna napadu'dui pudu'na Puang Yesus napasindum naua: “Taampaipia' anna tapetua'ia' battu la sule si'da hi nalappasam Elia.” ");
INSERT INTO ptu_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Iya metamba pole oom mane kattui penabanna. ");
INSERT INTO ptu_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Wattu eta too, indo sampim pesapa' illaam Banua Debata tappa sesse' tipa'dua mengkalao yabo sule dokko. ");
INSERT INTO ptu_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Deem mesa punggabana sohodadu mahassam ke'de' dio olona Puang Yesus. Tappana naitai maaka susi kamateanna, iya nauam: “Abana Änä'na si'da hia päläe' Puang Allataala!” ");
INSERT INTO ptu_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Deem duka' sanaka-naka baine umpetua' mambelai, susinna Maria Magdalena, Salome, anna Maria indona Yakobus Mangnguha sola Yoses. ");
INSERT INTO ptu_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Baine ia too sangngim to untuhu'um Puang Yesus, anna si natahiai indo anna si diopi Galilea. Anna budapi baine senga' dio duka' heem eta too, to napasola sule dio Yerusalem. ");
INSERT INTO ptu_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Allo eta too allo pa'patokaam la mentama allo Katohhoam. Tappana mahammo, ");
INSERT INTO ptu_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","iya deemmi mesa tau isanga Yusuf to Arimatea, mesa to kasalle illaam bilanganna To Mahhotto' Handam Malangka', napengkasahai umpellambi'i Pilatus anna umpelaui bakkena Puang Yesus. Indo Yusuf mesa to masäe allom muampai kapahentaanna Puang Allataala. ");
INSERT INTO ptu_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Mängä-mängä Pilatus tappana napekaheba diua matem Puang Yesus. Iya untambaim pangngulunna sohodadu anna nakutanai naua: “Mate si'dangka Yesus?” ");
INSERT INTO ptu_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Tappana nahingngi pa'tula'na, iya umpäbäim Yusuf lao muala bakkena Puang Yesus. ");
INSERT INTO ptu_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Iya muallim sampim mabusa Yusuf anna laoi napatuhum anna nabalunni. Anna mane laoi napandam tama lokko' dipapia dio mesa tanete batu. Puhai, iya ullolimmi batu kasalle natutu'iam ba'bana. ");
INSERT INTO ptu_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Indo ongeam dipampandanni bakkena naita Maria Magdalena sola Maria indona Yoses. ");
INSERT INTO ptu_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Tappana lessu' allo Katohhoam, muallim bauam bubanau' Maria Magdalena anna Maria indona Yakobus anna Salome aka la lao nasussuiam bakkena Puang Yesus illaam lokko'. ");
INSERT INTO ptu_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Buttunna allo indo allo Minggu eta too, iya le'ba'im lako ku'bu'. ");
INSERT INTO ptu_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Iya sipa'tula'-tula'um naua: “Mennangkia' la umbehoiam indo batu pelapa'na ku'bu'?” ");
INSERT INTO ptu_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Sapo' mahuku'i lako, iya naitam indo batu dilapasam ba'ba lokko' puham dilolim lao. ");
INSERT INTO ptu_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Iya le'ba'im tama indo ku'bu', iya naitam mesa to mangnguha ma'poheba mabusa muokko' dio tandai kanam, iya sileleim tikkedu' anna mängä-mängä. ");
INSERT INTO ptu_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Sapo' ma'kada indo to mangnguha naua: “Daa ummahea'a'! Kuissam kuua umpeäkoa' Yesus to Nazaret indo to puha dipäso' yabo kaju sitambem, sapo' pa'dem inde aka tubom sule. Petua'ia' indem ongeanna. ");
INSERT INTO ptu_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Dadi le'ba'ungkoa' temo anna umpaissanni Petrus sola passikola senga'na muua: ‘Mendiolom ia lako Galilea Puang Yesus, diopi mane silambi'koa' umba susi puha nauaangkoa'.’” ");
INSERT INTO ptu_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Iya le'ba'i siaham sikalumpa' umpellei indo lokko' aka tikkedu' lambi' lumalla' mahea' muita kadadiam ia too. Tandana mahea'i, iya tä' deem natula' lako tau. ");
INSERT INTO ptu_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Tappana puha tubo sule Puang Yesus indo mebengngi'-bengngi' allo Minggu eta too, iya uhu-uhuna umpa'paitaam kalena lu lako Maria Magdalena indo to puha nahambaiam pitu setam illaam mai kalena. ");
INSERT INTO ptu_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Iya tappa le'ba'um indo baine napa'paissangam lako ingganna to si untuhu'i anu' mahassannipi ma'bahata anna tää'i liupi tipoli' uwai matanna wattu eta too. ");
INSERT INTO ptu_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Sapo' tappana sikanahingngi naua tubom sule Puang Yesus anna deemmi umpa'paitaam kalena, tä' liu siaham nakannangam. ");
INSERT INTO ptu_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Lessu'i eta too umpa'paitaam pole oom kalena, sapo' senga'um hupanna, lako dua pentuhu'na wattunna anna le'ba'i umpellei tondä'. ");
INSERT INTO ptu_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Iya ma'pasulem sule aka la natula' lako solana indo pangngitanna. Sapo' tää'i liupi kannam. ");
INSERT INTO ptu_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Katampasanna umpa'paitaam kalena lako sapulo mesa passikolanna wattunna mahassanni mangngande. Sangngim nasosso Puang Yesus aka tä' ungkannangam pa'tula'na to puha muitai katuboanna sule. ");
INSERT INTO ptu_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Iya ma'kadam Puang Yesus lako naua: “Le'ba'koa' lako lili'-lili'na lino ammu pa'pakahebaannia' Kaheba Katilallasam lako ingganna hupatau. ");
INSERT INTO ptu_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Menna-menna ungkatappa'i anna ditedo'i iam too la salama', sapo' menna-menna tä' matappa' la ditahungkum ia. ");
INSERT INTO ptu_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Tanda-tandana to matappa' mala la umpogau' susinna: uhhambai lao setam umpake sangangku, anna la umpake basa maneanna natula', napalosaiam Penaba Maseho. ");
INSERT INTO ptu_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Moi anna la muanda'i ula' battu la muihu' hasum sapo' tä' la mala nasägäi, anna la uhhaka' to masaki napolalam bono'.” ");
INSERT INTO ptu_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Puhai ma'tula' lako passikolanna, iya tiäkä'um längäm suhuga anna muokko'i dio tandai kananna Puang Allataala. ");
INSERT INTO ptu_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Iya le'ba'im passikolanna umpa'pakahebaam Kaheba Katilallasam lako si mesa-mesa ongeam illaam lino anna napasolai Debata mengkähä umpakatoto' kadanna napa'patandaam umpadadi tanda memängä-mängä. ");
INSERT INTO ptu_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","O Teofilus to dipa'kasallei, budam tau umpeäi lalanna anna malai natuli' situhu' tonosanna ingganna indo kadadiam to puha dadi illaam alla'-alla'na hupatau. ");
INSERT INTO ptu_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Sikanatuli' situhu' indo puha natulasangkia' to umpa'pakahebaam Battakada Debata, indo to muitai sola mata mengkalao pahandu'na kadadiam ia too. ");
INSERT INTO ptu_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Dadi tappana kupellantunni manappa mengkalao pahandu'na kaha-kaha ia too, iya kuuam mapia ke kutuli'i situhu' tonosanna ingganna ia too anna malai umbata. ");
INSERT INTO ptu_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Kupateem anna malai muissam muua indo to puha dipa'guhuangko abana tappa' si'da. ");
INSERT INTO ptu_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Wattunna anna mendadi tomahajai Herodes dio lembäna Yudea, deem mesa sando isanga Zakharia, mentama duka' kamesaanna to mate Abia. Bainena Zakharia isanga Elisabet, mesa duka' pessubunna sando Harun. ");
INSERT INTO ptu_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Indo to dua, malolo pa'palakoanna dio olona Puang Allataala, aka bassim tä' deem sassainna kamanuhusanna untuhu'i ingganna pahentana Debata. ");
INSERT INTO ptu_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Sapo' indo to sipobaine tä' deem änä'na, aka abana tämänä Elisabet, anna bassim matuam. ");
INSERT INTO ptu_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Pissam wattu, lambi' oom wattunna la ma'palako sando to mentama kamesaanna to mate Abia, nasuhum Zakharia umpalako oloam sando dio olona Puang Allataala. ");
INSERT INTO ptu_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Situhu' kabiasaam, si diundi indo to la umpalako oloam sando illaam Banua Debata la untunu tunuam bubanau', iya Zakharia nahua eta too. ");
INSERT INTO ptu_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Mahassanni dipalako indo hettem tunuam bubanau', sulibam ia tau buda ma'sambajam. ");
INSERT INTO ptu_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Wattu etam too naongei umpa'paitaam kalena mesa malaika'na Debata lako Zakharia. Indo malaika' ke'de' dio tandai kananna indo meja dipantunui tunuam bubanau'. ");
INSERT INTO ptu_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Naitanna Zakharia indo malaika', tappa tikkedu' anna mahea'. ");
INSERT INTO ptu_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Sapo' ma'kada indo malaika' naua: “O Zakharia, daa ummahea', nahingngiammi Puang Allataala pa'sambajammu. Nasuhum la nadadiangangko bainemu Elisabet mesa änä' muane-ane anna la ussangai Yohanes. ");
INSERT INTO ptu_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Tä' deem pada la satiala inabammu ke dadim indo änä'-änä', anna la buda tau kassi wattu eta too. ");
INSERT INTO ptu_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Aka indo änä'mu, mesa to la keangga' dio olona Debata. La tä' mala muihu' anggur sola uwai senga' indo si mepamäbo'na. Anna subunna too, iya naponnoim Penaba Maseho. ");
INSERT INTO ptu_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","La buda to Israel napopengngolo sule lako Puang Allataala, Debata to napenombai nene to naponene. ");
INSERT INTO ptu_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Anna la umpendioloangam Debata sule naponnoi kuasa susi nabi Elia. La umpasikapiai ambe anna änä', anna lako tau to tä' manuhu' la napatinanda sule lako lalanna to si umpogau' kamaloloam. Pa'palakoam iam too umpaitai lalam hupatau anna mala toka penabanna la mendadi umma'na Debata.” ");
INSERT INTO ptu_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Iya natimba'im Zakharia lako indo malaika' naua: “Tä' natama pikkihangku itim tula'mu, aka kao illaammä' kamatuaam, susi siam duka' baineku.” ");
INSERT INTO ptu_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Natimba' indo malaika' naua: “Kaom too Gabriel to si nasua Puang Allataala. Anna nasua omä' temo umpalambisangko inde Kaheba Katilallasam. ");
INSERT INTO ptu_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Inde to puha kutula' tä' mala tala dadi ke lambi'um wattunna. Sapo' aka tä'ko kannam, nasuhum tä'ko la mala ma'kada sule lako diganna'i inde kaha-kaha puha kupokada.” ");
INSERT INTO ptu_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Wattu eta too, mamali'um tau buda muampai Zakharia anna sangngim mängä-mängä naua: “Akanna masäe sugali'i illaam Banua Debata?” ");
INSERT INTO ptu_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Pissananna ham ia messubum illaam mai tä'um mala ma'kada, iya napakana mandam lako tau buda indo to naita illaam Banua Debata. Naissam pole' tau buda naua: “Deem aka-aka napaitaiam Debata illaam.” ");
INSERT INTO ptu_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Tappana puha wattu pengkähänganna Zakharia illaam Banua Debata, iya ma'pasulem lako tondä'na. ");
INSERT INTO ptu_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Tä' masäe lessu'na ia too, iya kebättä si'da ham Elisabet bainena, lambi' ungkuhum kalena illaam banua lima bulanna. ");
INSERT INTO ptu_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Iya nauam Elisabet: “Inde kaha-kaha napadadi Debata tama kaleku, solanapi pa'kamasena di kao nasuhum tä'mä' pole' la si napa'bahinni'-hinni'i solaku.” ");
INSERT INTO ptu_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Annanni bulanna tambu'na Elisabet, iya nasuam Puang Allataala indo malaika' isanga Gabriel lao lako Nazaret, mesa tondä' dio lembäna Galilea. ");
INSERT INTO ptu_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Dioi, umpellambi'im mesa änä' daha isanga Maria. Indo Maria balim nakutanai muane isanga Yusuf, mesa duka' peampoanna tomahaja Daud. ");
INSERT INTO ptu_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Iya ma'kadam indo malaika' lako Maria naua: “O to kehongko'! Naundu'ko anna namana' Debata.” ");
INSERT INTO ptu_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Tikkedu' Maria uhhingngi tula'na indo malaika' lambi' mekutana illaam penabanna naua: “Aka hia umbai' kalembasanna indo tula' ingngena'?” ");
INSERT INTO ptu_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Iya nauam indo malaika': “O Maria, daa ummahea' aka iko mesako to napilei Puang Allataala la natamba'. ");
INSERT INTO ptu_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","La kebättäko anna la undadiangko änä' la muane-ane anna la ussangai Yesus. ");
INSERT INTO ptu_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","La mendadi mesa to kasalle anna la diuaam Änä'na Puang Allataala To Handam Matande. La napatadongkom Puang Allataala Debatanta mendadi tomahaja illaam kapahentaanna tomahaja Daud nene to naponene. ");
INSERT INTO ptu_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Anna la umpahenta pessubunna Yakub sule lako salako-lakona, anna kapahentaanna tä' deem la meangganna.” ");
INSERT INTO ptu_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Iya ma'kadam Maria lako indo malaika' naua: “La mala haka tia sule lako itim kadammu aka tä'pä' deem siisso muane.” ");
INSERT INTO ptu_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Sapo' naua indo malaika': “Penaba Maseho la ussalokko'ko anna kakuasaanna To Handam Matande la mengkähä illaam kalemu. Iam too anna la diuaammi indo änä'-änä' la undadiam: ‘To Malolo, Änä'na Puang Allataala.’ ");
INSERT INTO ptu_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Ungkilalai haka indo Elisabet sahapummu, annammi bulanna tambu'na temo, moi anna illaammi kamatuaam anna si naua asammi tau: ‘Tämänä.’ ");
INSERT INTO ptu_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Aka tä' ia deem nakapusa'i Puang Allataala.” ");
INSERT INTO ptu_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Iya nauam Maria: “Kao sabua'naä' Debata; iai too muua, iam too la dadi tama kaleku situhu' indo tula'mu.” Iya le'ba'um indo malaika' umpellei Maria. ");
INSERT INTO ptu_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Puhanna ia too, tappa le'ba' siaham Maria lako mesa kota dio lembäna Yudea yabo tipatanetena. ");
INSERT INTO ptu_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Sulei lako, iya le'ba'um tama banuanna Zakharia anna umpa'kadai Elisabet. ");
INSERT INTO ptu_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Nahingnginna Elisabet pa'kadanna Maria, tappa pahiu siaham indo änä'-änä' illaam tambu'na. Iya nasahum siaham Penaba Maseho Elisabet, ");
INSERT INTO ptu_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","lambi' metamba naua: “Ingganna baine iko handam ma'kalolosam tamba'mu, anna la ditamba' toi indo änä'-änä' la undadiam. ");
INSERT INTO ptu_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Setonganna tä' sihatannä' la napellambi'i indona Debatangku. ");
INSERT INTO ptu_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Aka kuhingnginna pa'kadammu, tappa pahiu siaham indo änä'-änä' illaam tambu'ku, kassi. ");
INSERT INTO ptu_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Kehongko'ko anna maupa', aka ungkatappa'i muua indo kadanna Debata tama kalemu tä' mala tala dadi!” ");
INSERT INTO ptu_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Iya ma'kadam Maria naua: “Mengkalao illaam unä' penabangku lemba' dio pudu'ku umpujiä' Debata, ");
INSERT INTO ptu_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","anna kutilalla'i sola sakalebu penabangku längäm Puang Allataala to umpasalama'ä', ");
INSERT INTO ptu_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","aka moinna anna mesaä' to handam matuna, sapo' tontää' napaillaam penaba. Napahandu' temo la nauaam asannä' ingganna lapi'na hupatau: ‘To kehongko'.’ ");
INSERT INTO ptu_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Aka Puang Allataala To Handam Kuasa puha umpogau' tanda memängä-mängä tama kaleku. Maseho sanganna! ");
INSERT INTO ptu_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Pa'kamasena Puang Allataala tihandu' lako ma'hupatau sule lako ampo-ampona to mengkahea' dio olona. ");
INSERT INTO ptu_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Katea' bassinna umpogau' pa'pogausam kasalle. Puha usseham ingganna to malangka' penaba anna ingganna pattujunna napompoi asam. ");
INSERT INTO ptu_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Buda tomahaja napatuhum yabo mai okkosam kahajaanna, sapo' to madio napomatande. ");
INSERT INTO ptu_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Umpadea' kamapiaam ingganna to tadea', sapo' to makaka nahambai ia lao ma'pala' lo'bä. ");
INSERT INTO ptu_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Umpamoloi pessubunna Israel sabua'na, tä' deem lembe nakamasei. ");
INSERT INTO ptu_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Aka Puang Allataala tä' ungkalembei pa'dandianna lako Abraham nene to naponene, sola ingganna pessubunna sule lako salako-lakona.” ");
INSERT INTO ptu_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Umbai' tallu bulampi tohho Maria dio sola Elisabet, mane ma'pasulei lako banuanna. ");
INSERT INTO ptu_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Tappana lambi' wattunna keänä' Elisabet, iya undadiammi mesa änä' muane-ane. ");
INSERT INTO ptu_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Naissanna ingganna sambanuanna sola kasahapuanna maaka susi pa'kamasena Debata lako Elisabet, iya tä' deem pada satilalla' duka' sola Elisabet. ");
INSERT INTO ptu_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Kahuai benginna subunna indo änä'-änä', iya suleim anna nasunna'i. Sangngim mohäe la nasangai Zakharia napasikona ambena, ");
INSERT INTO ptu_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","sapo' naua indona: “Tää', aka la disangai hi tia Yohanes.” ");
INSERT INTO ptu_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Natimba'iim naua: “Aka tä' deem kasahapuammua' ma'sanga susi.” ");
INSERT INTO ptu_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Iya umpa'pakana-kanam limanna lako Zakharia hapam nakutanai naua: “Aka la disangaiam inde änä'-änä'?” ");
INSERT INTO ptu_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Iya umpelaum batu tuli' anna natuli'i naua: “La disangai Yohanes.” Iya sangngim mängä-mängä pole'. ");
INSERT INTO ptu_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Wattu eta siam anna tibukkai sule pudu'na Zakharia, lambi' mala sule ma'kada anna umpujii Puang Allataala. ");
INSERT INTO ptu_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Ingganna sambanuanna sangngim mahea', anna ia mandam natula' lako dio mai ingganna tau dio tipatanetena Yudea. ");
INSERT INTO ptu_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Ingganna to uhhingngii kaha-kaha ia too sangngim mekutana illaam penabanna naua: “La dadi aka amo indo änä'-änä' ke dako'i?” Aka mannassa anna naundu'i Debata. ");
INSERT INTO ptu_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Indo Zakharia ambena indo änä'-änä' nasahum Penaba Maseho, nasuhum umpalombum kadanna Debata naua: ");
INSERT INTO ptu_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Tapujiia' sanganna Puang Allataala Debatanna to Israel, aka sulem umpellambi'i umma'na anna nalappasam. ");
INSERT INTO ptu_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Nabeengkia' To Mepasalama' tä'um deem tondonna, pessubunna tomahaja Daud sabua'na. ");
INSERT INTO ptu_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Umba susi puha nadandi Puang Allataala napalanda' ingganna nabi masehona yolona, ");
INSERT INTO ptu_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","la nalappasangkia' dio mai balinta anna kakuasaanna ingganna to ungkabassikia'. ");
INSERT INTO ptu_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Susim too umpatandaam pa'kamasena anna ungganna'i pa'dandiam masehona indo to puha nadandi lako nene to taponene. ");
INSERT INTO ptu_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Indo pa'dandiam to puha napa'pindai lako Abraham nene to taponene naua: ");
INSERT INTO ptu_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","‘La kulappasangkoa' dio mai balimmu, anna mala beba'koa' umpalako pa'elo'ku, ");
INSERT INTO ptu_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","anna la tontä liukoa' tubo situhu' pa'elo'ku anna umpogau' kamaloloam dio oloku upu' salu katuboammua'.’ ");
INSERT INTO ptu_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Anna iko änä'ku, la disangaiko nabinna Puang Allataala To Handam Matande; Aka ikom too disua mendiolo la umpatokaam lalam Debata. ");
INSERT INTO ptu_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","La umpa'paissangam lako umma'na muua la mala tau dipasalama' ke naampunnim Puang Allataala dosata. ");
INSERT INTO ptu_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Napateem aka tä' deem pada sakasalle pa'kamasena Puang Allataala lako kita, lambi' tuhum yabo mai suhuga napellambi'ikia' sihhapam bihha'na allo ke mebengngi'i, ");
INSERT INTO ptu_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","la muindo ingganna hupatau to tubo illaam kamalillingam anna illaam lembäna kamateam, la napatinanda lako lalam kamasannangam.” ");
INSERT INTO ptu_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Iya tuttuam kasallem indo änä'na Zakharia anna tuttuam manontom. Iya tohhom dio pohiallasam sampe lambi' wattunna umpa'patandaam kalena lako to Israel. ");
INSERT INTO ptu_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Wattu eta too umpassubum pahenta tomahaja Agustus la dihekem ingganna hupatau illaam kapahentaanna Roma. ");
INSERT INTO ptu_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Iam too inde uhu-uhuna dipadeem pahhekenganna hupatau wattunna Kirenius mendadi gubernur dio Siria. ");
INSERT INTO ptu_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Iya le'ba'um ingganna tau lako tondä'na si mesa-mesa anna mala dihekem dio. ");
INSERT INTO ptu_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Iya mengkalaom duka' Yusuf dio tondä' Nazaret dio lembäna Galilea le'ba' längäm kota Betlehem dio lembäna Yudea, ongeam kasubunganna tomahaja Daud, aka inna pessubunna tomahaja Daud. ");
INSERT INTO ptu_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Umpasola Maria to la napobaine la lao dihekem. Eta too mahassammi kebättä Maria. ");
INSERT INTO ptu_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Dioi, iya lambi'um wattunna la keänä'. ");
INSERT INTO ptu_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Iya ungkeänäsammi änä' uluana muane-ane. Iya nabe'be'im sampim anna nalole'i dokko pahabam, aka tä'um deem banua mala naongei tohho. ");
INSERT INTO ptu_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Dio indo ongeam deem sanaka-naka to ma'kambi' tohho dio pa'kambisanna ma'bengi unjagai dombana. ");
INSERT INTO ptu_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Pissananna ham ia umpa'paitaam kalena mesa malaika'na Debata lako indo to ma'kambi', anna kakuasaanna Debata pangkähhä umpali'i lao, lambi' sangngim mahea'. ");
INSERT INTO ptu_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Sapo' ma'kada indo malaika' naua: “Daa ummahea'a', aka suleä' umbaba kaheba mapia tä' deem pada saumpatilalla' ingganna hupatau: ");
INSERT INTO ptu_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Bengi temo dipadadiammokoa' dio botto litä'na tomahaja Daud mesa to la umpasalama'koa'. Iam too Kristus, Debatanta. ");
INSERT INTO ptu_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Anna la susi inde tandana: La ullambi'koa' mesa änä'-änä' malea dibe'be'i sampim dilole' dio pahabam.” ");
INSERT INTO ptu_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Iya tappa diita oham buda malaika' senga' sola indo mesa malaika' buttu yabo mai suhuga umpuji Puang Allataala naua: ");
INSERT INTO ptu_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Dipa'kasallei Puang Allataala yabo ongeam handam matande, anna la masannam hupatau illaam inde lino to napohäe Debata.” ");
INSERT INTO ptu_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Tappana le'ba' indo malaika' ma'pasule längäm suhuga, iya sipa'tula'-tula'um indo to ma'kambi' naua: “Maikoa' talako kota Betlehem anta petua'ia' indo kadadiam dio, indo puhakia' napaissanni Debata.” ");
INSERT INTO ptu_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Mengkalaoi siaham lako, iya ullambi'um Maria sola Yusuf anna indo änä'-änä' dilole' dio pahabam. ");
INSERT INTO ptu_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Tappana nalambi', iya natulasammi indo puha napaissanniam malaika' diona indo änä'-änä'. ");
INSERT INTO ptu_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Lambi' sangngim mängä-mängä ingganna tau uhhingngii indo tula'na to ma'kambi'. ");
INSERT INTO ptu_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Sapo' kaha-kaha ia too napaillaam penaba ia Maria anna napenaba-nabaam liui. ");
INSERT INTO ptu_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Iya ma'pasuleim indo to ma'kambi' lako ongeanna napasindum umpuji anna umpa'kasallei Puang Allataala aka ingganna indo puha nahingngi anna naita tä' deem la sisala indo puha natulasam malaika'. ");
INSERT INTO ptu_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Tappana kahua benginna dadinna indo änä'-änä', iya disunna'um anna disangai Yesus umba susi passangainna loppo' malaika' indo anna tä'pi nakebättängam indona. ");
INSERT INTO ptu_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Tappana lambi' wattunna la dibahassii Maria situhu' Pepaondonganna Musa aka mane puha keänä', iya nababam Yusuf sola Maria indo änä'-änä' längäm Yerusalem nabeho lako Debata ");
INSERT INTO ptu_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","umba susi puha tisuha' illaam Pahentana Debata naua: “Ingganna änä' ulua muane tabana ia Debata.” ");
INSERT INTO ptu_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Anna umbaba bua pemala'na situhu' indo puha napokada illaam Pahentana Debata naua: “sapasangka bukku' duaka änä'na dangam-dangam.” ");
INSERT INTO ptu_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Wattu eta too deem mesa tau dio Yerusalem isanga Simeon, mesa to meimam si mengkahea' längäm Puang Allataala anna nasahum Penaba Maseho, umpemmitai liu wattunna Puang Allataala la ullappasam to Israel. ");
INSERT INTO ptu_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Anna inna puham napalosai Penaba Maseho naua: “Tä'poko la mate ke tä'ko silambi' yolo indo To nalanti' Debata la mepasalama'.” ");
INSERT INTO ptu_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Iya nagaha'um Penaba Maseho Simeon nasuhum mentama Banua Debata. Wattu etam too duka' anna nababai tomatuanna Puang Yesus tama Banua Debata aka la umpalako indo situhu'na Pepaondonganna Musa. ");
INSERT INTO ptu_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Iya naalam indo änä'-änä' nakaleppe' anna napasindunni umpuji sanganna Puang Allataala naua: ");
INSERT INTO ptu_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“O Debata, umpasule lakom pa'dandiammu tama kaleku. Dadi masannammä', päbäimä' pole' mate. ");
INSERT INTO ptu_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Aka kusa'biim sola matangku To Mepasalama' buttu di Iko ");
INSERT INTO ptu_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","indo to umpatokaam lako ingganna hupatau. ");
INSERT INTO ptu_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Inde To Mepasalama' la sihhapam masiä' muindo taianna to Yahudi, anna la umbaba kamatandeam lako to Israel umma'mu.” ");
INSERT INTO ptu_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Iya bassim mängä-mängäm ambena sola indona uhhingngii indo tula'na Simeon diona indo änä'na. ");
INSERT INTO ptu_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Iya napelauammi tamba' Simeon indo to sahapu mane ma'kadai lako Maria, indona indo änä'-änä' naua: “Inde änä'mu puham natuho Puang Allataala la uhhonnosam buda to Israel, anna la buda napomatande. Anna la mendadi mesa tanda yabo mai Puang Allataala la natumpu pala' hupatau ");
INSERT INTO ptu_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","anna mala tandaam pikkihanna anna lalam penabanna lako si mesa-mesa hupatau. Anna iko-iko Maria, la ussi'dingko kamapi'disam sihhapam nabuno pa'dam.” ");
INSERT INTO ptu_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","37","Wattu eta too deem polepi mesa nabi baine isanga Hana, änä'na Fanuel, pessubunna Asyer. Indo Hana matusse'um aka kahua pulom appa' taunna dadinna. Iya masäem mendadi to balu baine aka anggam pitu taunna sola muanena balinna siala anna matem muanena. Tä' si'da-si'dapi deem la umpellei Banua Debata, allo bengi umpalako liu kapenombaam dio olona Puang Allataala, puasa anna ma'sambajam. ");
INSERT INTO ptu_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Eta siam too duka' anna sulei ma'kuhhu' sumanga' längäm Puang Allataala anna natula'i diona änä' ia too lako tau buda to muampai kalappasanna to Yerusalem. ");
INSERT INTO ptu_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Tappana puha napalako Yusuf sola Maria ingganna indo situhu'na Pahenta Debata, iya ma'pasulem lako tondä' Nazaret dio lembäna Galilea. ");
INSERT INTO ptu_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Indo änä'-änä' tuttuam kasalle anna matoho; ponno kakeakasam, anna napakamaja Puang Allataala. ");
INSERT INTO ptu_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Taum-taum le'ba' liu tomatuanna Puang Yesus längäm Yerusalem umpakahoa' allo Kalappasam. ");
INSERT INTO ptu_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Tappana sapulo dua taunna Puang Yesus, iya le'ba'i oom längäm Yerusalem ma'pakahoa' situhu' kabiasaanna. ");
INSERT INTO ptu_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Tappana puha allo kasalle ia too, iya ma'pasuleim, sapo' tohho ia Puang Yesus yabo Yerusalem tä' naissam tomatuanna. ");
INSERT INTO ptu_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Nasanga siam ia duka' sola tau buda muola lalam. Sangngallo ham mellao mane napeäi lako alla'-alla'na kasahapuanna anna issanganna. ");
INSERT INTO ptu_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Sapo' tä' deem nalambi', nasuhum ma'pasule sule längäm Yerusalem napeä. ");
INSERT INTO ptu_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Napetallungngalloi napeä mane nalambi'i illaam Banua Debata mahassam muokko' illaam alla'-alla'na tuangguhu illaam peadasam napehingngii tula'na anna nakutanai. ");
INSERT INTO ptu_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Ingganna to dio heem eta too sangngim mängä-mängä uhhingngi kamanähänganna anna pentimba'na indo änä'-änä'. ");
INSERT INTO ptu_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Anna mängä-mängä toi duka' tomatuanna muitai. Iya ma'kadam indona lako naua: “O änä'ku, akanna umpateem dakam kami'? Husa'kam sola ambemu umpeäko.” ");
INSERT INTO ptu_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Iya natimba'im Puang Yesus naua: “O ambe' solakoa' indo', akanna umpeää'? Tä' daka tiko muissanna' muua Kao pahalluä' la illaam banuanna Ambeku?” ");
INSERT INTO ptu_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Sapo' tä' naissam tomatuanna kalembasanna indo tula'na. ");
INSERT INTO ptu_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Puhai ia too, iya sola-solam ma'pasule lako Nazaret, anna tontä liu manuhu' lako tomatuanna. Anna ingganna indo kaha-kaha napaillaam penaba liu indona. ");
INSERT INTO ptu_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Tuttuam lobo' Puang Yesus anna tuttuam keaka'. Tuttuam napakamaja Puang Allataala anna napohäe hupatau. ");
INSERT INTO ptu_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Illaam taum kasapulo limanna ma'pahenta tomahaja Tiberius, eta too Pontius Pilatus mendadi gubernur dio Yudea, anna Herodes muanda'i kapahentaam dio Galilea, anna Filipus solasubunna Herodes muanda'i kapahentaam dio Iturea anna dio Trakhonitis, anna Lisanias muanda'i kapahentaam dio Abilene. ");
INSERT INTO ptu_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Anna to mendadi sando too' wattu eta too isanga Hanas anna Kayafas. Iya taum etam too anna ma'kadai Puang Allataala lako Yohanes änä'na Zakharia dio pohiallasam. ");
INSERT INTO ptu_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Nasuhum le'ba' Yohanes lako ingganna ongeam dio lembäna Salu Yordan umpalanda' kadanna Puang Allataala naua: “Tihokongannia' ingganna kasalaammu ammu behoia' kalemu ditedo' anna mala naampunniangkoa' dosamu Puang Allataala.” ");
INSERT INTO ptu_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Umba susi puha napayolo lambam nabi Yesaya illaam suha'na naua: “Deem tau dio pohiallasam metamba-tamba naua: ‘Patokaanni lalam Debata, maloloanganni lalam la naolanna. ");
INSERT INTO ptu_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Mellembäna la ditambunni, matanetena sola mabuntunna la dipomahante, anna ma'lekko-lekkona la dimaloloam anna ma'bo'bä'-bo'bä'na la dipomahampa'. ");
INSERT INTO ptu_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Anna ingganna hupatau illaam inde lino la muita kasalamasam buttu yabo mai Puang Allataala.’” ");
INSERT INTO ptu_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Ma'kada Yohanes lako tau buda indo to sule la ditedo' naua: “O inggammua' to si mambaba bulim, pessubunna to kadake gau'! Ussanga haka' iko la malakoa' lappa' dio mai aha' kasallena Puang Allataala? ");
INSERT INTO ptu_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Pa'baju polekoa' anna pa'dodo pole anna tandaanni diua ussosso si'dangkoa' gau'mu anna untingko' basabammu. Daa muuaia': ‘Tä'kam la napassala Puang Allataala aka peampoannakam Abraham.’ Aka kutulasangkoa', inde mai batu la mala duka' napadadi Puang Allataala peampoanna Abraham! ");
INSERT INTO ptu_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Tentomai la dipembattaammi wase di ada'na Puang Allataala dilemposam ingganna kaju tää'na kembua manappa anna ditibei tama api.” ");
INSERT INTO ptu_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Iya mekutanam tau buda lako Yohanes naua: “Maka' susi, iya aka pahallu la kipogau'?” ");
INSERT INTO ptu_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Natimba'im naua: “Menna-menna muampuam dua baju, la naala mesa anna nabeenni lako to tä' deem bajunna. Anna menna-menna muampuam kinande la napateem siam duka'.” ");
INSERT INTO ptu_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Deem duka' sule sanaka-naka tuam passima maelo' la ditedo', iya mekutanam duka' naua: “O tuangguhu, aka kami' la pahallu kipogau'?” ");
INSERT INTO ptu_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Natimba'im Yohanes naua: “Daa umpala'bii umpelau anna indo puha diuaangko.” ");
INSERT INTO ptu_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Iya mekutanam duka' sanaka-naka sohodadu naua: “Anna kami', aka kami' la kipogau'?” Natimba' Yohanes naua: “Daa umpangngala bäbäa' lako tau ke taiai lalanna anna tä' tookoa' la umpakolo'-kolo'i bäbä kakadakeam tau anna malai nabaja'. Paganna'unna' iko duka' indo sahomu!” ");
INSERT INTO ptu_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Iya sangngim mekutanam illaam penabanna indo tau buda naua: “Iangka tia umbai' indo To dilanti' la mepasalama' masäem diampai?” ");
INSERT INTO ptu_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Iam too anna nauam Yohanes lako indo tau buda: “Kao-kao uwai kupake untedo'koa'. Sapo' dako'i too sulem To kuasa puha Ia anna la kao. Aka moi la kubukkaiam pekapu' sapatunna tala sihatannä'. Ia-Ia Penaba Maseho anna api la napake natedosangkoa'. ");
INSERT INTO ptu_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Sihhapam to ma'tappi tokam dio limanna petappi la nase'laam banne maläpu' anna läkko'na. Ingganna banne maläpu' la dianna manappa tama loko, anna läkko'na la ditibe ia tama api tapi'de-pi'de.” ");
INSERT INTO ptu_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Anna budapi kada penännä' senga' natula' Yohanes wattunna anna umpa'pakahebaanni indo Kaheba Katilallasam. ");
INSERT INTO ptu_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Sapo' indo ia Herodes to muanda'i kakuasaam dio Galilea nakeaha'i ia Yohanes aka umpobaine Herodias, bainena solasubunna, anna dionapi kakadakeam senga' napogau'. ");
INSERT INTO ptu_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Sapo' uhhängänni mandi kakadakeanna aka umpatama tahungkum Yohanes. ");
INSERT INTO ptu_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Tappana puha natedo' Yohanes indo ingganna tau buda, iya untedo'um duka' Puang Yesus. Puhai natedo', iya ma'sambajammi Puang Yesus. Iya tappa tibukka siaham langi' ");
INSERT INTO ptu_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","anna tuhunni Penaba Maseho anggasanna dangam-dangam uhhampoi. Anna dihingngi siaham kamaha buttu yabo mai suhuga naua: “Ikom too inde änä' pa'pakamajangku to umpomasannam penabangku.” ");
INSERT INTO ptu_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Kiha-kiha tallu pulom taunna dadinna Puang Yesus anna umpahandu'i pengkähänganna. Anna situhu' passangainna tau, Puang Yesus änä'na Yusuf. Indo Yusuf änä'na Eli, ");
INSERT INTO ptu_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Eli änä'na Matat, Matat änä'na Lewi, Lewi änä'na Malkhi, Malkhi änä'na Yanai, Yanai änä'na Yusuf, ");
INSERT INTO ptu_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Yusuf änä'na Matica, Matica änä'na Amos, Amos änä'na Nahum, Nahum änä'na Hesli, Hesli änä'na Nagai, ");
INSERT INTO ptu_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai änä'na Maat, Maat änä'na Matica, Matica änä'na Simei, Simei änä'na Yosekh, Yosekh änä'na Yoda, ");
INSERT INTO ptu_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Yoda änä'na Yohanan, Yohanan änä'na Resa, Resa änä'na Zerubabel, Zerubabel änä'na Sealtiel, Sealtiel änä'na Neri, ");
INSERT INTO ptu_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri änä'na Malkhi, Malkhi änä'na Adi, Adi änä'na Kosam, Kosam änä'na Elmadam, Elmadam änä'na Er, ");
INSERT INTO ptu_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er änä'na Yesua, Yesua änä'na Eliezer, Eliezer änä'na Yorim, Yorim änä'na Matat, Matat änä'na Lewi, ");
INSERT INTO ptu_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Lewi änä'na Simeon, Simeon änä'na Yehuda, Yehuda änä'na Yusuf, Yusuf änä'na Yonam, Yonam änä'na Elyakim, ");
INSERT INTO ptu_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Elyakim änä'na Melea, Melea änä'na Mina, Mina änä'na Matata, Matata änä'na Natan, Natan änä'na Daud, ");
INSERT INTO ptu_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Daud änä'na Isai, Isai änä'na Obed, Obed änä'na Boas, Boas änä'na Salmon, Salmon änä'na Nahason, ");
INSERT INTO ptu_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nahason änä'na Aminadab, Aminadab änä'na Admin, Admin änä'na Arni, Arni änä'na Hezron, Hezron änä'na Peres, Peres änä'na Yehuda, ");
INSERT INTO ptu_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Yehuda änä'na Yakub, Yakub änä'na Ishak, Ishak änä'na Abraham, Abraham änä'na Terah, Terah änä'na Nahor, ");
INSERT INTO ptu_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nahor änä'na Serug, Serug änä'na Rehu, Rehu änä'na Peleg, Peleg änä'na Eber, Eber änä'na Salmon, ");
INSERT INTO ptu_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Salmon änä'na Kenan, Kenan änä'na Arpakhsad, Arpakhsad änä'na Sem, Sem änä'na Nuh, Nuh änä'na Lamekh, ");
INSERT INTO ptu_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamekh änä'na Metusalah, Metusalah änä' Henokh, Henokh änä'na Yared, Yared änä'na Mahalaleel, Mahalaleel änä'na Kenan, ");
INSERT INTO ptu_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kenan änä'na Enos, Enos änä'na Set, Set änä'na Adam, Adam änä'na Puang Allataala. ");
INSERT INTO ptu_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Puhai ditedo' Puang Yesus, iya umpelleim Salu Yordan. Wattu eta too naponnoi Penaba Maseho anna natettei lako pohiallasam. ");
INSERT INTO ptu_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Iya tohhom dio appa' pulo allona appa' pulo benginna napa'sändä'i tomahajanna setam. Padam too masäena dio tä' deem mangngande lambi' tadea'um nasi'dim. ");
INSERT INTO ptu_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Iya ma'kadam indo tomahajanna setam lako Puang Yesus naua: “Maka' Änä'na tongangko Puang Allataala, suai inde batu mendadi hoti!” ");
INSERT INTO ptu_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Natimba'um naua: “Tää', aka puha tisuha' illaam Battakada Debata naua: ‘Taia kinande mandi la napotubo hupatau.’” ");
INSERT INTO ptu_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Iya umbabaim Puang Yesus indo tomahajanna setam längäm ongeam malangka' anna napaitai säppälli' ingganna kapahentaam illaam inde lino, ");
INSERT INTO ptu_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","anna nauaanni: “Kakuasaanna anna kamatandeanna ingganna inde kapahentaam balim dipadokkoannä' lisu pala'ku. Anna kuasaä' la umpebeenni situhu' pa'elo'ku. ");
INSERT INTO ptu_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Dadi maka' umpenombaiä', la iko asam umpuänganni.” ");
INSERT INTO ptu_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Natimba' naua: “Tää', aka tisuha' illaam Battakada Debata naua: ‘Penombaiko Puang Allataala Debatammu anna anggam pa'elo'na la mala umpalako.’” ");
INSERT INTO ptu_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Puhai, iya umpasolam Puang Yesus lako Yerusalem anna napayaboi bubunganna Banua Debata anna nauaanni: “Maka' Änä'na tongangko Puang Allataala, tobängangko kalemu inde dokko, ");
INSERT INTO ptu_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","aka deem tisuha' illaam Battakada Debata naua: ‘Puang Allataala la ussua malaika'na unjagai manappako, ");
INSERT INTO ptu_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","anna la natahimaiko anna mala moi bitti'mu tala tihuai lako batu.’” ");
INSERT INTO ptu_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Natimba' pole oom Puang Yesus naua: “Tää', aka puha tisuha' illaam Battakada Debata naua: ‘Daa umpa'sändä'i Puang Allataala Debatammu.’” ");
INSERT INTO ptu_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Puha asanni napalako ingganna indo pa'sändäsam lako Puang Yesus indo tomahajanna setam, iya napelleim lao anna muampai polei wattu mapia. ");
INSERT INTO ptu_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Iya ma'pasulem Puang Yesus lako lembäna Galilea naponnoi kakuasaanna Penaba Maseho. Iya kaissangammi lako mobotto-bottoam dio pa'lembängam ia too. ");
INSERT INTO ptu_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Iya si ulleleim pa'sambajanganna to Yahudi naongei ma'pa'guhu anna tä' deem pada sanapohäe ingganna hupatau. ");
INSERT INTO ptu_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Puhai ia too, le'ba'um Puang Yesus lako Nazaret ongeanna dipalobo'. Tappana lambi' allo Katohhoam, iya le'ba'um tama pa'sambajanganna to Yahudi umba susi si napogau'. Illaanni, ke'de'um aka la umbata Battakada Debata. ");
INSERT INTO ptu_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Iya dibeemmi suha'na nabi Yesaya. Naalam indo suha' anna nabukkai, iya nalambi'um tisuha' naua: ");
INSERT INTO ptu_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Kao to nasahum Penabanna Debatanta; aka puhamä' nalanti' la umpa'paissangam Kaheba Katilallasam lako to mase-mase. Anna nasua tooä' umpa'paissangam kalappasanna to disakka, kabonosanna to buta, kalondaanna to dianda'i onggo'-onggo'na, ");
INSERT INTO ptu_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","anna umpa'paissangam diua lambi'um wattunna la umpa'patandaam pa'kamasena Debata lako hupatau.” ");
INSERT INTO ptu_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Puhai, nalulummi sule Puang Yesus indo suha' anna nabeenni lako indo to si mengkähä illaam pa'sambajangam mane muokko'i. Ingganna tau illaam indo pa'sambajangam unnenne'i asam Puang Yesus. ");
INSERT INTO ptu_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Mane ma'kadai Puang Yesus naua: “Ingganna indo issinna Battakada Debata diganna'im allo temo tappana uhhingngia'.” ");
INSERT INTO ptu_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Sangngim mängä-mängä anna napohäe nahingngi indo tula'na aka tä' deem pada samapia. Iya nauaim: “Taia haka tia änä'na Yusuf inde tau?” ");
INSERT INTO ptu_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Iya ma'kadam Puang Yesus naua: “Tä' mala tala deengkoa' umpahuaiä' inde pehapangam naua: ‘O tuandotto' kalemum too pabono'! Anna indo tanda memängä-mängä umpadadi dio Kapernaum, pogau'i duka' inde botto litä'mu.’” ");
INSERT INTO ptu_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Mane naua polei Puang Yesus: “Pengkilalaia', setonganna tä'pi deem mesa nabi la dipa'kasallei illaam botto litä'na. ");
INSERT INTO ptu_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Paillaam penabaia' inde tula'ku: wattunna anna mendadi nabii Elia, deem buda to balu-balu baine illaam Israel. Wattu eta too kulla' tallu taum anna annam bulanna lambi' kende' kakobeam lako mobotto-bottoam. ");
INSERT INTO ptu_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Sapo' tä' tia deem nasua Debata Elia la umpellambi'i indo to balu-balu baine illaam Israel, anggam tia lu lako mesa to balu-balu baine dio Sarfat, illaam lembäna Sidon. ");
INSERT INTO ptu_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Susi toi duka' indo anna mendadi nabii Elisa, buda to dolengam illaam Israel tä' duka' deem moi podo la mesa napabono' sulibanna Naaman to Siria.” ");
INSERT INTO ptu_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Iya ingganna tau illaam indo pa'sambajangam tä' deem pada sakeaha' nahingnginna indo tula'na, aka sangngim moka untahima Puang Yesus. ");
INSERT INTO ptu_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Pada-padam ke'de' anna umbussunni Puang Yesus lako sulibam tondä' anna napahissinni lako ulu kumila' dio ampe' tondä'na la nasulungam dokko. ");
INSERT INTO ptu_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Sapo' napa'tängäi bäbä Puang Yesus indo tau buda, le'ba' napellei. ");
INSERT INTO ptu_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Puhai ia too, le'ba'um Puang Yesus dokko kota Kapernaum dio Galilea. Tappana lambi' allo Katohhoam, iya umpa'guhum tau. ");
INSERT INTO ptu_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Sangngim mängä-mängä tau uhhingngi pepa'guhuanna Puang Yesus aka naponnoi kakuasaam pa'tula'na. ");
INSERT INTO ptu_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Illaam indo pa'sambajangam deem mesa tau napentamai setam. Indo tau kaoli-oli naua: ");
INSERT INTO ptu_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“O Yesus to Nazaret, la muaka hakam kami'? Abana isanga suleko la ungkadakeikam? Aka kuissam kuua iko To Masehoko buttu di Puang Allataala.” ");
INSERT INTO ptu_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Sapo' tappa nakuapai Puang Yesus naua: “Pengkamma'ko, pessubungko illaam mai kalena itim tau.” Iya ussämbäsammi yolo indo tau dokko litä' indo setam dio olona tau buda mane messubunni, sapo' tä' siam nasägäi. ");
INSERT INTO ptu_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Tä' deem pada sanakamängä-mängäi tau buda, napolalam sipa'tula'-tula' naua: “Aka hia isanga indea'i anna malai umpahe' ingganna setam nasua lao? Inde tula'na ponno kakuasaam anna kamatohoam!” ");
INSERT INTO ptu_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Iya kaissangammi indo pa'pogau'na Puang Yesus illaam indo pa'lembängam ia too. ");
INSERT INTO ptu_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Puhai ia too, messubummi Puang Yesus illaam mai pa'sambajangam anna le'ba'i lako banuanna Simon. Wattu eta too mahassam lumalla' pasananna Simon baine. Iya nauaim lako Puang Yesus: “Mala haka umpabono'?” ");
INSERT INTO ptu_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Iya le'ba'um lako sa'de petindoanna indo baine ke'de' anna nasuai lao sakinna. Iya tappa masapu eta siaham sakinna lambi' bangommi maläppu' anna tappa nabela ma'tahia. ");
INSERT INTO ptu_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Tappana lendu' allo, sulem buda tau umpasola solana to ussi'dim ma'hupa-hupa saki, iya napasibala'-bala'um Puang Yesus naanda'i lambi' sangngim bono' eta siaham. ");
INSERT INTO ptu_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Susi toi to napentamai setam, sangngim mäläi setanna napasindum kumissä' naua: “Änä'na tongangko Puang Allataala!” Sapo' sangngim nakuapai Puang Yesus anna tä'um napäbäi ma'kada-kada, aka sangngim naissam naua Puang Yesus-um too indo To dilanti' la mepasalama'. ");
INSERT INTO ptu_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Makale'na, mebengngi'-bengngi'pi anna bangommi Puang Yesus anna le'ba'i lako ongeam mabuni-buninna. Sapo' nasipeä-peäi tau buda. Tappana nalambi', nauaim: “Kela mala anna tä'kam umpellei.” ");
INSERT INTO ptu_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Sapo' natimba' naua: “Kaheba Katilallasam diona kapahentaanna Puang Allataala pahallu la kupa'paissangam lako kota senga', aka inna ia hi Kao nasuaannä' Puang Allataala mentama lino.” ");
INSERT INTO ptu_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Iya ulleleim pa'sambajanganna to Yahudi Puang Yesus dio lembäna Yudea ma'pa'guhu. ");
INSERT INTO ptu_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Pissam wattu ke'de' Puang Yesus dio bihinna le'bo' Genesaret ma'pa'guhu. Iya ma'silullu'um tau ullombai aka maelo' umpehingngii Battakadanna Puang Allataala. ");
INSERT INTO ptu_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Iya muitam dua lopi dio bihim le'bo' lo'bä, aka mahassam umbase-basei dalana indo puäna. ");
INSERT INTO ptu_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Indo lopi mesa, lopinna Simon. Iya längämmi Puang Yesus anna napelaui lako Simon anna nabussunni tama le'bo' saidi'. Iya muokko'um Puang Yesus anna umpa'guhui tau buda. ");
INSERT INTO ptu_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Puhai ma'pa'guhu, ma'kadam lako Simon naua: “Palutamai mandalanna lopimmu anna umpessämbäsanni dalamu anna mala deem bau muala.” ");
INSERT INTO ptu_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Sapo' natimba' Simon naua: “O Tuangguhu, kipesabengiim mengkähä kahha' ma'pemälä, sapo' moi mesa bau tadeenni kiala. Sapo' aka iko ussuakam, iya päbäi kipessämbäsam pole dalaki.” ");
INSERT INTO ptu_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Napalutamam duka' mandalanna anna umpessämbäsanni dalana. Iya tandana buda bau naala, napahandu'um sesse' dalana. ");
INSERT INTO ptu_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Iya ungka'bi'um solana lako lopi senga' anna sulei nabalii. Iya suleim indo solana nabalii. Tandana buda bau nasakka, bassim ponno indo lopinna sampe saidi' tatallam. ");
INSERT INTO ptu_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Tappana naita Simon Petrus kaha-kaha ia too, iya ma'balinguntu'um dio olona Puang Yesus anna ma'kadai naua: “O Debata, pelleiä' lao aka kao to madosaä'!” ");
INSERT INTO ptu_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Aka tä' deem pada sanakapilla'i Simon Petrus sola ingganna solana muita indo bau pada budanna nasakka. ");
INSERT INTO ptu_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Mängä-mängä toi duka' indo solana Simon isanga Yakobus anna Yohanes bassim änä'na Zebedeus. Iya nauam Puang Yesus lako Simon: “Pomahannui penabammu, daa ummahea', aka mengkalao temo la mendadiko to undala hupatau anna mala natuhu'ä'.” ");
INSERT INTO ptu_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Iya bassim napalängämmi galantangam lopinna Simon sola indo solana anna umpellei ingganna aka-akanna mane le'ba'i untuhu' Puang Yesus. ");
INSERT INTO ptu_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Pissam wattu, illaam oom mesa kota Puang Yesus, iya sulem duka' mesa to dolengam mentu' kalena. Tappana muita Puang Yesus, sule siahanni napellambi'i anna mendu'dunni dio olona anna mengkahumase-masei melau naua: “O Tuam, kuissam kuua malaä' umpabono' ke umpoelo'i.” ");
INSERT INTO ptu_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Iya uhhaka'um indo tau napasindum naua: “Maelo'ä', bono'ungko!” Lambi' masapu eta siaham indo sakinna. ");
INSERT INTO ptu_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Iya napakahi'dim Puang Yesus naua: “Moi la menna tala untulasanni inde kupogausangko. Anggam ia la laoko umpa'paitaam kalemu lako sando anna la umbabako bua pemala'mu umba susi puha napepaondongam Musa. Aka la mendadi tanda lako tau buda diona kabonosammu.” ");
INSERT INTO ptu_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Sapo' tuttuam kaissangam di lako mobotto-bottoam, nasuhum buda tau sule aka maelo' napehingngii pepa'guhuanna anna la dipabono' sakinna. ");
INSERT INTO ptu_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Sapo' Puang Yesus Ia si bassa' lao lako ongeam kasala-salaanna ma'sambajam. ");
INSERT INTO ptu_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Pissam wattu ma'pa'guhu oom Puang Yesus. Eta too dio duka' heem sanaka-naka to illaam kakalebuanna Parisi anna to ullatta' Pepaondonganna Musa. Tau ia too buttu yabo mai Yerusalem anna buttu dio mai ingganna tondä' dio lembäna Galilea anna lembäna Yudea. Puang Yesus nasahum Puang Allataala, nasuhum mala umpabono' to masaki. ");
INSERT INTO ptu_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Iya sulem sanaka-naka tau umbulle mesa to mate kalena metindo dio ampa'na. Napeä lalanna anna mala tama indo banua aka maelo' umbaba solana lako olona Puang Yesus. ");
INSERT INTO ptu_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Sapo' tä' deem naola aka nalabai tau buda, nasuhum lu längännim ia papa anna naso'boi dokko sipatunna Puang Yesus mane nalollohanni sitonda ampa'na dokko olona Puang Yesus illaam alla'-alla'na tau buda. ");
INSERT INTO ptu_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Tappana naita Puang Yesus kamatappasannai, iya ma'kadam lako indo to mate kalena naua: “O solaku, diampunnim dosamu.” ");
INSERT INTO ptu_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Iya sangngim nauam illaam penabanna indo to illaam kakalebuanna Parisi anna to ullatta' Pepaondonganna Musa: “Akanna deenni tau muangga' kalena sipadaam Puang Allataala? Aka tä' deem tau moi podo la mesa la mala muampunni dosa, sulibanna Puang Allataala!” ");
INSERT INTO ptu_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Sapo' nalosa Puang Yesus issi penabannai lambi' nauaam: “Akanna ma'pikki' susi hakoa' iko? ");
INSERT INTO ptu_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Mennaka la madomi' dadi lako inde tau, ke diuaanni: ‘Diampunniammoko dosamu,’ anna la diuaam: ‘Bangongko ammu pellao?’ ");
INSERT INTO ptu_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Sapo' la kupa'patandaam temo anna malaa' ungkaleso manappa muua illaam inde lino kuasaä' To diuaam Änä' Mentolino muampunni dosa.” Mane ma'kadai lako indo to mate kalena naua: “Bangongko, babai ampa'mu ammu le'ba' lako banuammu!” ");
INSERT INTO ptu_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Iya bangom siaham naita tau buda anna muäkä'i ampa'na messubum ma'pasule lako banuanna napasindum umpa'kasallei Puang Allataala. ");
INSERT INTO ptu_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Sangngim pilla' ingganna to dio heem eta too anna umpa'kasallei Puang Allataala. Sapo' mahea' ohi muuai: “Memängä-mängä si'da pole' inde kadadiam taitaa' allo temo.” ");
INSERT INTO ptu_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Puhai ia too, messubummi Puang Yesus, iya muitam mesa tuam passima isanga Lewi muokko' illaam kätto'na. Iya napa'kadaim naua: “Maiko anna untuhu'ä'.” ");
INSERT INTO ptu_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Iya ke'de'um duka' Lewi umpellei ingganna aka-akanna anna le'ba'i natuhu'. ");
INSERT INTO ptu_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Puhai ia too, iya umpadeemmi mesa hame-hame kasalle Lewi dio banuanna umpa'kasallei Puang Yesus. Iya buda tuam passima sola tau senga' napasola mangngande. ");
INSERT INTO ptu_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Tappana naita sanaka-naka to illaam kakalebuanna Parisi sola to ullatta' Pepaondonganna Musa to mentama kakalebuanna Parisi, iya sangngim ma'naum-naummi lambi' ma'kada lako passikolanna Puang Yesus naua: “Akanna muaku hia' iko sola-sola mangngande tuam passima anna to madosa senga'?” ");
INSERT INTO ptu_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Iya natimba'um Puang Yesus naua: “Tä' tia deem to bono' la umpahalluam tuandotto', anggam tia to masaki. ");
INSERT INTO ptu_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Kao-kao suleä' inde lino taia to ussanga kalena malolo la kutambai, sapo' suleä' untambai to madosa anna malai untihokongam gau'na.” ");
INSERT INTO ptu_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Puhai ia too, ma'kadam sanaka-naka tau lako Puang Yesus naua: “Passikolanna ia Yohanes si bassa' puasa anna ma'sambajam. Susi toi passikolanna to illaam kakalebuanna Parisi. Sapo' passikolammu iko si mangngande liu, tä' deem puasa.” ");
INSERT INTO ptu_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Natimba' Puang Yesus umpake pehapangam naua: “La mala haka tia dilaham mangngande to ullomba kakabengam ke diopi heem indo to mane dipakebaine? Mannassam tia anna tä'i! ");
INSERT INTO ptu_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Sapo' la deem wattunna indo to mane dipakebaine la diäläi illaam mai alla'-alla'na to ullombai. Iya etapi too pole' mane puasai.” ");
INSERT INTO ptu_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Mane muala polei mesa pehapangam senga' naua: “Tä' deem tau la ussesse'i baju bakahu mane natampisanni baju malusa. Aka maka' napateem la situmä bäbä indo baju, sesse'um indo baju bakahu anna tä' siam duka' la mapia diita indo baju malusa ditampi' sampim bakahu. ");
INSERT INTO ptu_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Susi toi duka' tä' tia deem tau la muala anggur bakahu anna napatamai pa'pongngeam malusa. Aka indo anggur bakahu la untesseam pa'pongngeam malusa. Iya katampasanna bassim labu' susi anggurna teem pa'pongngeanna. ");
INSERT INTO ptu_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Dadi anggur bakahu manggi' duka' dipalutama pa'pongngeam bakahu. ");
INSERT INTO ptu_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Tä' deem tau la maelo' muihu' anggur bakahu ke puham muihu' anggur masäe. Aka naua: ‘Mammi' puha ia anggur masäe.’” ");
INSERT INTO ptu_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Pissam wattu illaam allo Katohhoam umpa'tängäi bela' gandum Puang Yesus sola passikolanna. Mahassam siam mellao napasindum siam ia passikolanna muala gandum anna napuhidi'i kuli'na mane naandei. ");
INSERT INTO ptu_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Wattu eta too deem sanaka-naka to illaam kakalebuanna Parisi mekutana naua: “Akanna untekkaia' indo pelahangam illaam peadasam umpogau' tala malanna dikähä illaam allo Katohhoam?” ");
INSERT INTO ptu_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Natimba' Puang Yesus naua: “Tä'paka' tiko deem umbata diona pa'pogausanna Daud sola pentuhu'na wattunna anna tadea'i? ");
INSERT INTO ptu_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Wattu eta too le'ba' Daud tama bahum kapenombaam anna mualai indo hoti puha dipehumalasam anna naandei mane nabeenni duka' lako pentuhu'na, moi kela daa anggam tia sando mala muandei.” ");
INSERT INTO ptu_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Mane naua polei Puang Yesus: “Kao hia Änä' Mentolino puäna allo Katohhoam.” ");
INSERT INTO ptu_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Pissam wattu lambi' oom allo Katohhoam. Iya tamam pa'sambajanganna to Yahudi Puang Yesus ma'pa'guhu. Illaam indo pa'sambajangam deem mesa tau mate lima kananna. ");
INSERT INTO ptu_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Wattu eta too dio duka' heem sanaka-naka to ullatta' Pepaondonganna Musa anna to illaam kakalebuanna Parisi maelo' umpeängam tuntungam su'be' Puang Yesus. Iya sikanapaola mata lium aka naua: “Umba ke toko umpabono'i indo to masaki illaam allo Katohhoam anna mala deem dipa'palu'bi'i.” ");
INSERT INTO ptu_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Sapo' naissam Puang Yesus pikkihanna, iya ma'kadam lako indo to mate limanna naua: “Maiko anna ke'de'ko eta inde.” Iya ke'de' siaham duka' anna lakoi olona tau buda. ");
INSERT INTO ptu_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Mane mekutanai Puang Yesus lako tau buda naua: “Deem la kupekutanaam: Umbanna la situhu' peadasam dipogau' ke illaanni allo Katohhoam, kamapiaam daka kakadakeam daka? La umpesäkäi hakika solata la dipatei haka?” ");
INSERT INTO ptu_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Napalelei asammi yolo lao matanna indo tau buda mane ma'kadai lako indo to mate limanna naua: “Äkä'i limammu!” Iya muäkä'um duka' limanna, iya tappa bono' eta siaham. ");
INSERT INTO ptu_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Sangngim meali-ali muitai lambi' sipattuju-tuju naua: “Aka hia la dipogausam inde tau?” ");
INSERT INTO ptu_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Puhai ia too, längämmi tanete Puang Yesus aka la ma'sambajam. Yaboi, napesabengiim ma'sambajam längäm Puang Allataala. ");
INSERT INTO ptu_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Tappana masiä, untambaim ingganna passikolanna anna napilei sapulo dua la mendadi suhona. Indem ia sanga-sanganna: ");
INSERT INTO ptu_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","16","Simon (si nauaam toi Puang Yesus Petrus), Andreas, siundu'na Simon, Yakobus anna Yohanes, Filipus anna Bartolomeus, Matius anna Tomas, Yakobus (änä'na Alfeus), Simon, to illaam kakalebuanna Zelot, Yudas änä'na Yakobus, anna Yudas Iskariot indo to la umbalu' Puang Yesus. ");
INSERT INTO ptu_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Puhai ia too, ma'pasulem Puang Yesus sola suhona yabo mai indo tanete lu dokko tipahantena. Sulei dokko, ullambi'um buda passikolanna ma'hempum anna buda tau senga' napasola to buttu dio mai lembäna Yudea anna to yabo mai Yerusalem, anna to buttu dio mai kota Tirus sola kota Sidon to bassim dio bihim le'bo'. ");
INSERT INTO ptu_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Sule asam indo tau aka maelo' umpehingngii pepa'guhuanna Puang Yesus anna la napabonosam ingganna sakinna. Susi toi to napentamai setam sulei duka' anna napabono'i. ");
INSERT INTO ptu_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Sangngim napeä lalanna anna malai muanti Puang Yesus aka deem kakuasaam messubum illaam mai kalena umpabono'i. ");
INSERT INTO ptu_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Iya napaleleim lao mata indo ingganna passikolanna anna ma'kadai naua: “Kehongko' anna maupa' inggannakoa' to mase-mase, aka ikonna' too mendadim umma'na Puang Allataala illaam kapahentaanna. ");
INSERT INTO ptu_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Kehongko' anna maupa' inggannakoa' to tadea' temo, aka ikonna' too to la dipadea'. Kehongko' anna maupa' inggannakoa' to sumahho temo, aka la napessulle petaba. ");
INSERT INTO ptu_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Kehongko' anna maupa' inggannakoa' to dikabassi, tä' ditahima, disangai bäbä tau kadake, anna dikahidi' aka untuhu'ä' to disangai Änä' Mentolino. ");
INSERT INTO ptu_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Aka susi siam duka' yolona buda nabi nadahha nene to naponene to ungkabassikoa' temo. Dadi la kassi mandakoa' anna tilalla' ke nalambi'koa' kaha-kaha ia too, aka la nabeengkoa' Puang Allataala mana' kasalle yabo suhuga. ");
INSERT INTO ptu_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Sapo' la ullambi'koa' iko katilakaam inggannakoa' to makaka temo, aka ussi'dimmokoa' iko kamasannangam. ");
INSERT INTO ptu_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","La ullambi'koa' iko katilakaam inggannakoa' to dea' temo, aka la napessulle katadeasam. La ullambi'koa' iko katilakaam inggannakoa' to metaba temo, aka la napessulle pi'di' penaba anna uwai mata. ");
INSERT INTO ptu_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","La ullambi'koa' iko katilakaam inggannakoa' to napuji ingganna hupatau temo, aka susim too duka' yolona ingganna tau to ussangai kalena nabi napuji duka' nene to naponene ingganna indo to umpujikoa' temo.” ");
INSERT INTO ptu_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Sapo' ikoa'-iko inde to uhhingngi tula'ku temo, kupokadaangkoa' kuua: Kamaseikoa' balimmu; Pa'pogau' mapiakoa' lako to ungkabassikoa'. ");
INSERT INTO ptu_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Pelauanni tamba' to untädokoa', pa'sambajanganni to ma'pogau' kadake tama kalemu. ");
INSERT INTO ptu_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Maka' natampilim tau papomu sabali, beem polepi sabalinna. Anna maka' deem tau muala jubamu, beem polepi duka' bajummu. ");
INSERT INTO ptu_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Anna maka' napelau tau aka-akammu, beenni. Maka' naala bäbä tau aka-akammu, damom too umpelaui sule. ");
INSERT INTO ptu_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Iai too umpohäe la napogausangko solamu, iam too duka' la umpogau' lako solamu. ");
INSERT INTO ptu_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Maka' anggam to ungkamaseiko la ungkamasei, iya tä' deem lalanna la dibala'iangko hesomu. Aka moi to kadake gau' si ungkamasei toi duka' to ungkamasei. ");
INSERT INTO ptu_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Anna maka' angga hi to ma'pogau' mapia tama kalemu la umpa'gau' mapiai, iya tä' deem lalanna la dibala'iangko hesomu. Aka moi to madosa si ma'pogau' susi duka'. ");
INSERT INTO ptu_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Anna maka' la anggam to nabela umbala'i sule la umpahabe'i doi'mu, iya tä' deem lalanna la dibala'iangko hesomu. Aka indo duka' to kadake gau' si umpahabe'i hi tia duka' padanna to kadake gau', aka nahannuam la nabala'i sule. ");
INSERT INTO ptu_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Sapo' ikoa'-iko, pahallukoa' la ungkamasei balimmu, anna ma'pogau' mapia tama kalena. La umbeenna' pehhabesam anna tä'unna' la uhhannuam bala'inna. Aka ke susii tä' deem pada sakasallea' sahomu anna la mendadikoa' änä'na Puang Allataala To Handam Matande. Aka Puang Allataala mapia penaba liu Ia lako to tä' untilalla'i pa'pebeem anna lako to kadake gau'. ");
INSERT INTO ptu_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Umba susi Ambemu yabo suhuga ma'kamase, la susingkoa' too duka' pahallu ma'kamase.” ");
INSERT INTO ptu_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Anna mane naua: “Daa umpasala padammu hupatau indana napasalako duka' Puang Allataala. Daa umpassala padammu hupatau indana dipassalako duka'. Ampunniko padammu anna mala diampunniko duka'. ");
INSERT INTO ptu_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Pa'pebeengko lako solamu, anna dibeengko duka'. Anna indo dibeengko mala dipasihhapam bahha' dituntunni pegantam anna dihodä' sampe lempam pole. Aka indo pegantam umpake lako solamu, ia siam duka' dipakeangko.” ");
INSERT INTO ptu_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Puhai, iya mualam mesa pehapangam naua: “Maka' to buta la untette to buta, tä' mala tala bassim metobä dokko gahoä. ");
INSERT INTO ptu_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Mesa passikola tä' tia la matande puha ia anna la tuangguhunna. Sapo' maka' tamma'um mesa passikola, iya sipadaammi tuangguhunna. ");
INSERT INTO ptu_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Akanna la muita leko'ko butanna solamu pada tahubu' kaju anna tä'ko iko la ussi'dim butammu pada talakaju illaam matammu? ");
INSERT INTO ptu_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Maakam ia susi la mala muuaangko solamu: ‘Maiko solaku anna kuäläiangko itim tahubu' kaju illaam matammu,’ moi kela daa pada iko talakaju illaam matammu tä' ussi'dim? O, to ma'dua tambu'! Äläi yolo indo butammu pada talakaju anna mala masiä' pennenne'mu muäläiam butanna solamu pada nennu'.” ");
INSERT INTO ptu_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Puhai ia too, untula' pole oom mesa pehapangam Puang Yesus naua: “Tä' tia deem kaju mapia la ungkembuaam bua kadake, battu haka kaju kadake la ungkembuaam bua mapia. ");
INSERT INTO ptu_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Aka si mesa-mesa kaju diissam ditandai ke diitam buana. Anna tä'pi deem tau la umpuppu' bua ara yabo mai kaju bahani battu haka bua anggur dio mai balambane'. ");
INSERT INTO ptu_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Susim too duka' lako hupatau. Lako to mapia gau', mannassa anna mapia siam tia duka' pessubungam pudu'na, aka mapia illaam unä' penabanna. Sapo' lako to kadake gau', mannassa anna kadakei pessubungam pudu'na aka kadake illaam unä' penabanna. Aka iai too tianna illaam unä' penaba, ia siam too duka' messubum dio pudu'.” ");
INSERT INTO ptu_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Akanna si umpa'ua-ua bäbäia' dio pudu'mu: ‘O Debatangku, O Debatangku,’ moi kela daa tä' sianna' untuhu'i indo tula'ku? ");
INSERT INTO ptu_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Pehapangam aka la dipasusiam indo to sule umpellambi'iä' anna napehingngii pahentaku sola napalako? Pehingngii anna kutulasangkoa'. ");
INSERT INTO ptu_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Deem tau umpake'de' banua. Indo tau nabo'bä' dokko napellambi'i batu ampam mane napaokko'i batu longkahhinna dio. Tappana sule uwai buda unta'du indo banua, iya tä' mala henggä aka dipake'de' yabona batu ampam. ");
INSERT INTO ptu_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Sapo' menna-menna uhhingngi gändä-gändä kadangku anna tä'i napaillaam tambu' dapaka ia la nakedoam, tau ia too dipasihhapam ia to umpake'de' banuanna yabo litä' malunä'. Tappana sule uwai buda unta'du indo banua, iya tappa henggä anna tä'um dipohiakanna.” ");
INSERT INTO ptu_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Puhai ma'tula' lako tau buda diona kaha-kaha ia too, ma'pasulem Puang Yesus lako Kapernaum. ");
INSERT INTO ptu_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Eta too deem punggabana sohodadu Roma muampuam mesa sabua', anna tä' deem pada sanapakamaja. Indo sabua'na masaki sampe saidi' mandam penabanna. ");
INSERT INTO ptu_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Tappana nahingngi indo punggaba sohodadu diona Puang Yesus, iya ussuam sanaka-naka matua ulunna to Yahudi la umpellambi'i Puang Yesus la napelauam umba ke malai sule napabonosam indo sabua'na. ");
INSERT INTO ptu_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Tappana silambi' Puang Yesus, iya mengkahumase-maseim melau naua: “Kela mala ungkamasei indo punggabana sohodadu. Sihatam la dikamasei ");
INSERT INTO ptu_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","aka tä' deem pada sanakamaseikia' kita to Yahudi anna puhangkam kami' napapiaam pa'sambajangangki.” ");
INSERT INTO ptu_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Iya le'ba'um Puang Yesus sola-sola indo to untambai. Tappana la landa' kale Puang Yesus lako indo banuanna, ussua pole oom solana indo punggabana sohodadu umpellambi'i Puang Yesus naua: “O Tuam, damom too ade' ussussai kalemu la tahhu' lako banuanna, aka naua: ‘Tä' punala sihatam la tama banuangku. ");
INSERT INTO ptu_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Aka iam too anna tä'mä' bahani umpellambi'i.’ Dadi ua mammi ade' sabatta kada, iya la bono'um tia indo sabua'na. ");
INSERT INTO ptu_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Aka naissam ade' duka' diona pampahesam, aka ia duka' mesa to dipahe'. Sapo' deempi ade' duka' tando dokkona to napahe'. Aka maka' nauaam: ‘Le'ba'ko,’ iya le'ba' duka'. Anna maka' nauaam: ‘Maiko,’ iya sule duka'. Susi siam too ade' duka' sabua'na ke nauaanni: ‘Kähäi inde,’ iya tä' mala tala nakähä.” ");
INSERT INTO ptu_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Tappana nahingngi Puang Yesus kada ia too, iya tä' deem pada sanakapilla'i, nasuhum umpenggihi'i indo tau buda untuhu'i anna ma'kadai naua: “Kutulasangkoa', tä' punalapi deem la kulambi' to Israel moi podo la mesam la susi kamatappasanna indo tau!” ");
INSERT INTO ptu_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Tappana landa' sule lako banuanna punggabana sohodadu indo to disua, nalambi'um indo sabua'na bono'um. ");
INSERT INTO ptu_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Tä' masäe lessu'na ia too, iya le'ba'um Puang Yesus sola passikolanna lako mesa kota isanga Nain, anna budapi tau senga' ma'obim-obim untuhu'i. ");
INSERT INTO ptu_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Tappana la ullambi'i ba'bana kota, sitammum tau umbulle to mate aka la lao nalamum. Indo to mate, änä' mesa, änä'na to balu baine. Anna buda issinna kota untuhu'i indo to balu baine. ");
INSERT INTO ptu_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Tappana naita Puang Yesus indo to balu baine, iya tä' deem pada sahäntä buana. Iya napa'kadaim naua: “Daa ussaho.” ");
INSERT INTO ptu_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Mane umpenandai indo bulleam naanda'i, iya tohho siaham duka' indo to mamulle. Iya ma'kadam naua: “O, änä' muane, temo kuuaangko, bangongko!” ");
INSERT INTO ptu_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Iya bangom siaham indo tau anna tadongkonni ma'tula'-tula'. Mane nabeenni Puang Yesus lako indona. ");
INSERT INTO ptu_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Ingganna indo tau sangngim mahea' anna umpa'kasallei Puang Allataala naua: “Mesa nabi kasalle kende' illaam alla'-alla'taa'! Sulem Puang Allataala umpamoloi umma'na!” ");
INSERT INTO ptu_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Iya kaissangammi indo pa'pogausanna Puang Yesus, susi dio lembäna Yudea, teem lako ingganna botto senga' sikahuku'na. ");
INSERT INTO ptu_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Indo Yohanes to si mantedo' puha natulasam passikolanna diona ingganna indo to puha napogau' Puang Yesus. Nasuhum untambai dua passikolanna ");
INSERT INTO ptu_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","anna napakahi'dii naua: “Laokoa' pellambi'i Puang Yesus anna ungkutanai muua: ‘Ikongka indo To nalanti' Puang Allataala masäem diampai? Iya la tau senga' daka too?’” ");
INSERT INTO ptu_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Tappana ullambi' Puang Yesus indo to dua, iya nauam: “Nasuakam Yohanes to si mantedo' sule ungkutanaiko. Ikongka indo To nalanti' Puang Allataala masäem diampai? Iya la tau senga' daka too?” ");
INSERT INTO ptu_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Wattu eta too mahassam Puang Yesus umpabono' buda tau to ussi'dim ma'hupa-hupa saki, anna uhhambai setam illaam mai kalena to napentamai, anna buda to buta napabono' lambi' mala paita. ");
INSERT INTO ptu_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Iya natimba'im Puang Yesus naua: “Pa'pasulengkoa' anna untulasanni umba susi puhaa' muita anna uhhingngi. Susinna to buta mala paita, to mate kalena mala mellao, to dolengam masapu dolenganna, to binga mala pahingngi, to mate tubo sule, anna Kaheba Katilallasam dipa'pakahebaam lako to handam matuna. ");
INSERT INTO ptu_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Kehongko' anna maupa' to tä' bata-bata lako kaleku.” ");
INSERT INTO ptu_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Tappana le'ba' indo to nasua Yohanes, iya umpa'tula'im tau buda Puang Yesus diona Yohanes naua: “Aka untungkaa' lako pohiallasam umpellambi'i Yohanes? Laokoa' umpetua' to ma'tille tipae'? ");
INSERT INTO ptu_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Iya aka hia' maelo' umpetua'? Lao hakoka' too umpetua' to ma'poheba mapi'dä'? Sapo' situhu' Kao pikkihangku dio hi tia banuanna tomahaja indo to ma'poheba mapi'dä' anna to tä'um deem nakasepa-sepai. ");
INSERT INTO ptu_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Dadi aka hia' maelo' umpetua'? Lao hakoka' too umpetua' nabi? Maka' iaa' untungka, tappa' ia pole'. Aka kutulasangkoa' temo kuua setonganna indo Yohanes mentondom puha ia anna la nabi senga'. ");
INSERT INTO ptu_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Aka Yohanes-um too indo nauaam illaam Battakada Debata: ‘Indem ia pesuaku kupake'de' la umpendioloangangko aka iam too to la umpatokaangko lalam la muola.’ ");
INSERT INTO ptu_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Aka kupokadaangkoa', pempom dio mai ingganna hupatau illaam inde lino, tä' deem la untondom Yohanes to si mantedo'. Sapo' mentondom puha ia ingganna to mentamam kapahentaanna Puang Allataala moi anna matunai.” ");
INSERT INTO ptu_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Ingganna indo tau buda to uhhingngi pa'tula'na Puang Yesus, teem toi duka' tuam passima pada-pada muakui pattujunna Puang Allataala, aka puhaim umbeho kalena natedo' Yohanes. ");
INSERT INTO ptu_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Sapo' indo ia to illaam kakalebuanna Parisi anna to ullatta' Pepaondonganna Musa tä' ia untahima pattujunna Puang Allataala, aka tä' naaku umbeho kalena natedo' Yohanes. ");
INSERT INTO ptu_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Mane ma'kada polei Puang Yesus naua: “Akam la dipasihhapangam inde hupatau lapi' temo? Anna aka la nasusiam? ");
INSERT INTO ptu_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Sihhapam liu indo änä'-änä' si ma'ko'bom-ko'bom lako pasa' anna metambai muuaam solana: ‘Kiponiammokoa' sulim sapo' moka hakoa' iko sumajo. Umpenaniammakam kelom bahata, sapo' moka hakoa' iko sumahho.’ ");
INSERT INTO ptu_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Aka sule Yohanes to si mantedo' si bassa' ma'puasa anna tä' muihu' anggur. Sapo' si ussangai hia' iko: ‘To napentamai setam!’ ");
INSERT INTO ptu_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Pissananna suleä' Kao to disangai Änä' Mentolino, iya si mangngandeä' Kao anna mangngihu' illaam pa'hame-hameam. Sapo' si ussangai bäbä hä': ‘To si mangngande sasa anna to si umpamäbo' kalena, sangkalamma'na tuam passima anna to madosa senga'.’ ");
INSERT INTO ptu_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Moinna anna susi, sapo' tä' mala tala ma'tandaam kamanähänganna anna kakeakasanna Puang Allataala la lemba' illaam pa'palakoanna ingganna to untuhu'i.” ");
INSERT INTO ptu_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Deem mesa tau illaam kakalebuanna Parisi isanga Simon untambai Puang Yesus lako banuanna mangngande. Iya sulei lako banuanna metindo sapolom aka la mangngande. ");
INSERT INTO ptu_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Dio indo kota deem mesa baine si dipobungam bibi gau' kadakena. Tappana naissam naua dio banuanna to illaam kakalebuanna Parisi Puang Yesus mahassam mangngande, iya lako siaham umbaba mesa buli-buli mapindäm kessi minnä'-minnä' bubanau'. ");
INSERT INTO ptu_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Landa'i, iya le'ba'um lako boko'na Puang Yesus ke'de' dio ampe' bitti'na napasindum sumahho. Iya umbossi'im bitti'na Puang Yesus uwai matanna, mane napassiianni beluä'na napasindum naudum bitti'na. Anna mane natolloi indo minnä'-minnä' bubanau' tanda pa'pakasallena. ");
INSERT INTO ptu_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Tappana naita indo to illaam Parisi to untambai Puang Yesus, iya nauam illaam penabanna: “Kela nabi tongam inde tau, mannassa anna la muissam inde dio baine anna naissam toi naua mesa to madosa.” ");
INSERT INTO ptu_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Iya ma'kadam Puang Yesus lako naua: “Simon, deem la kukutanaiangko.” Iya natimba'im naua: “Aka la ungkutanaiannä', Tuangguhu?” ");
INSERT INTO ptu_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Iya nauaammi: “Deem dua tau ma'indam lako mesa to si umpa'paindangam doi'na. Mesa ma'indam lima pulo bidä, anna mesa lima bidä. ");
INSERT INTO ptu_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Sapo' bassim tä' nabela nabaja', iya napapa'deam bäbäm indanna. Dadi mennannam kabam indo to dua la handam umpohäe indo to umpaindannii doi'na?” ");
INSERT INTO ptu_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Natimba' Simon naua: “Indo to buda indanna.” Iya nauaammi: “Tappa' pentimba'mu.” ");
INSERT INTO ptu_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Mane unnenne'i indo baine anna ma'kadai lako Simon naua: “Muita haka inde baine? Kao suleä' inde banuammu, sapo' tä' deem umpatokaannä' uwai kubaseiam bitti'ku. Sapo' inde ia baine puham nabaseiannä' bitti'ku uwai matanna anna napassii beluä'na. ");
INSERT INTO ptu_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Iko-iko tä' deem muudunnä', sapo' ia-ia tamangku inde banua tä'um deem kattu muudum bitti'ku. ");
INSERT INTO ptu_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Anna iko-iko tä' deem untolloi ulungku minnä', sapo' ia-ia natolloiannä' bitti'ku minnä'-minnä' bubanau'. ");
INSERT INTO ptu_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Dadi setonganna kutulasangko: Pa'kamase kasallena inde baine, iam too umpa'paissanganni diua buda dosana diampunniam. Sapo' to saidi' dosana diampunni, saidi' duka' pa'kamasena.” ");
INSERT INTO ptu_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Mane ma'kadai lako indo baine naua: “Diampunniammoko dosamu.” ");
INSERT INTO ptu_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ingganna indo to napasola Puang Yesus mangngande sangngim nauai illaam penabanna: “Menna hia isanga inde anna la malai muampunni dosa?” ");
INSERT INTO ptu_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Mane nauai Puang Yesus lako indo baine: “Salama'ungko aka ungkatappa'iä'. Laongko, la naundu'ko kamasakkeam sola kamasannangam.” ");
INSERT INTO ptu_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Tä' masäe puhanna ia too, iya le'ba'um Puang Yesus ullelei buda kota anna tondä' umpa'pakahebaam Kaheba Katilallasam naua: “Bambannam umpalako kapahentaanna Puang Allataala.” Sapulo dua suhona napasola ");
INSERT INTO ptu_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","anna sanaka-naka baine to puha napabono' sakinna sola to puha naäläiam setam illaam mai kalena, susinna: Maria to disangai Magdalena to puha naäläiam pitu setam illaam mai kalena; ");
INSERT INTO ptu_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","anna deem toi isanga Yohana bainena Khuza, to muäto' pengkähängam illaam banuanna Herodes; anna Susana sola budapi baine senga'. Ingganna baine ia too si umpake kullena natahiaiam Puang Yesus sola ingganna to untuhu'i. ");
INSERT INTO ptu_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Pissam wattu ma'silullu' oom tau buda buttu dio mai mobotto-bottoam umpellambi'i Puang Yesus. Iya untula'um mesa pehapangam Puang Yesus naua: ");
INSERT INTO ptu_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Deem mesa tau le'ba' mangngambo'. Tappana naambo' indo bannena, iya deemmi tappa lako lalam sampe nasihondo-hondoi bäbä tau indo bannena anna napuha dassi naande. ");
INSERT INTO ptu_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Deem tappa lako bobom batu. Iya tubom dio mai, sapo' tä' siam masäe anna malasso bäbäm aka manipi' litä'na. ");
INSERT INTO ptu_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Anna deem duka' tappa lako alla' kuhha keduhi, iya tubom sola-sola. Sapo' tä' siam masäe tubo indo tanangam aka tuttuam mahombo indo kuhha umpissii. ");
INSERT INTO ptu_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Anna sabaheam tappa lako litä' malompo, iya mapi'dä' ia tubona nasuhum kembua tiluppi' sahatu'.” Puhai ia too, napekasalleim ma'kada Puang Yesus naua: “Lako ingganna ma'hupatau pahallu la umpatanam talinganna umpalempe sulim patomalinna anna napaillaam penabai inde tula'ku!” ");
INSERT INTO ptu_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Iya mekutanam passikolanna naua: “Aka hia kalembasanna indo pehapangam ingngena'?” ");
INSERT INTO ptu_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Iya natimba'im naua: “Angganna' iko dipaissanni indo kada ditambim diona kapahentaanna Puang Allataala. Sapo' ditula' pehapangam ia lako tau senga' aka ‘la naita liu, sapo' tä' la naala akkalanna, anna la nahingngi liu, sapo' tä' la naissam kalembasanna.’ ");
INSERT INTO ptu_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Indem ia kalembasanna indo pehapangam: Indo banne kalembasanna Battakadanna Puang Allataala. ");
INSERT INTO ptu_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Indo diuaam banne tappa lako lalam dipasihhapam to uhhingngi Battakadanna Puang Allataala, sapo' naäläi siam tomahajanna setam illaam mai penabanna, anna mala tä' matappa' anna tä' dipasalama'. ");
INSERT INTO ptu_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Indo banne tappa lako bobom batu dipasihhapam ia to umpehingngii Battakadanna Puang Allataala anna tappa natahima sola ponno penaba, sapo' tä' kewwaka' illaam penabanna. Iya tä' siam masäe matappa' aka sulena pa'sändäsam, iya soho' boko' siahanni. ");
INSERT INTO ptu_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Indo banne tappa lako alla' kuhha keduhi dipasihhapam ia to uhhingngi Battakadanna Puang Allataala, sapo' anggam malallam umpikki' salu katuboam di lino, umpakalando puha ham ia kulle, anna sipangngula' pangngua penabanna, nasuhum tä' mala kembua mapia. ");
INSERT INTO ptu_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Anna indo banne tappa lako litä' malompo, dipasihhapam ia to malolo anna mapia penabanna uhhingngi Battakadanna Puang Allataala anna napaillaam penabanna. Tau ia too tontä liu ia manontom manuhu', nasuhum kembua mapia.” ");
INSERT INTO ptu_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Tä' tia deem tau la umpau' lampu anna nasalongo'i baka battu haka napadio ibi' sahigam. Sapo' napayabo hi tia inna ongeanna anna mala paindo masiä' naita ingganna to mentama indo banua. ");
INSERT INTO ptu_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Aka ingganna pepa'guhuangku tibuninnapi la dipatandaam, anna ingganna indo tisambonapi la dipakaleängam asam anna dipa'paissanganni. ");
INSERT INTO ptu_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Dadi pehingngii manappaia' inde pepatuduangku! Aka menna-menna umpaillaam penabai, tau ia too la dihängänniam polepi kapaissanganna. Sapo' to moka umpaillaam penabai, iya la diäläi pissam ia lao indo kapaissangam nasanga deemmi illaam kalena.” ");
INSERT INTO ptu_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Iya sulem indona anna solasubunna Puang Yesus la umpellambi'i, sapo' tä' mala silambi' aka nalabai tau buda. ");
INSERT INTO ptu_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Iya natulasammi tau naua: “O Tuangguhu, illaam sulibam indomu anna solasubummu napeäko!” ");
INSERT INTO ptu_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Sapo' natimba' Puang Yesus naua: “Menna-menna umpehingngii Battakadanna Puang Allataala anna napogau'i illaam salu katuboanna, iam too indoku anna solasubungku.” ");
INSERT INTO ptu_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Pissam wattu längäm lopi Puang Yesus sola passikolanna, iya muuaammi passikolanna: “Talambanna' libam inde le'bo'.” Iya mengkalaoim. ");
INSERT INTO ptu_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Mahassanni mellao lopinna, iya mamma' ia Puang Yesus. Tappa sule siaham hibu' tatta' illaam indo le'bo' lambi' indo lopi nasopa'i uwai, iya saidi' tatallam. ");
INSERT INTO ptu_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Iya natundam siaham passikolanna Puang Yesus anna nauaanni: “O Tuangguhu, o Tuangguhu, la tallam tau!” Iya bangommi, napa'kadai indo hibu' sola uwai tibuha', iya tappa mattam siaham indo hibu' tatta' anna malino duka' indo le'bo'. ");
INSERT INTO ptu_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Mane ma'kadai lako passikolanna naua: “Umba hia' iko kamatappasammu?” Iya mahea'im anna mängä-mängä lambi' sipa'tula'-tula'i naua: “Tau menna hia isanga inde? Aka moi hibu' sola uwai mala toi napahe'!” ");
INSERT INTO ptu_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Puhai ia too, napatahhu'um pa'laoanna lako attasa'na to Gerasa dio tando libanna le'bo' Galilea. ");
INSERT INTO ptu_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","29","Dio Gerasa deem mesa muane to napentamai setam. Indo tau masäem ma'kambelä anna tä' deem tohho illaam banua, sapo' si tohho lako ku'bu'. Indo setam kapuhaam si umpalilli indo tau lambi' moi dihante bassii limanna anna bitti'na anna dijagai, sapo' si nakattu-kattu siam indo hante bassi, mane nahambai lako pohiallasam. Tappana muita Puang Yesus tuhum yabo mai lopi, iya napellambi'i siaham anna kumissä'i mane ussämbäsanni kalena dokko litä' muoppä dio olona Puang Yesus. Iya nasuam le'ba' indo setam illaam mai kalena nasuhum meoli naua: “O Yesus Änä'na Puang Allataala To Handam Matande, la muaka hä' kao? Kupelau kela mala anna tä'ä' undahha!” ");
INSERT INTO ptu_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Iya nakutanaim Puang Yesus naua: “Aka sangammu?” Iya natimba'im naua: “Isangaä' Legion,” aka napentamai buda setam. ");
INSERT INTO ptu_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Iya napa'sule-suleim mengkahumase-mase indo setam lako Puang Yesus naua: “Kela mala anna tä'kam ussua dokko indo gahoä handam mandalam.” ");
INSERT INTO ptu_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Sikahuku' indo ongeam naongei deem buda babi mahassam menduhu' lako pili' tanete. Iya napelaum indo setam lako Puang Yesus naua: “Päbäikam lu tama inde lako babi.” Iya napaolaim duka' Puang Yesus pelauanna. ");
INSERT INTO ptu_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Iya messubum siaham illaam mai kalena indo tau anna umpentamai indo babi buda. Pissananna ham ia sikakondä indo babi buda untobängam bäbä kalena dokko kumila' tahhu' dokko le'bo', lambi' mate asam napusa'i uwai. ");
INSERT INTO ptu_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Naitanna to unjagai indo babi kadadiam ia too, tappa le'ba' siahanni sikakondä napa'paissangam lako kota anna tondä' sikahuku'na. ");
INSERT INTO ptu_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Iya le'ba'im buda tau umpetua'i kadadiam ia too. Sulei lako Puang Yesus, iya ullambi'um indo to bali napentamai setam mahassam muokko' dio ampe' bitti'na Puang Yesus anna ma'pohebam pole' aka malinom. Iya sangngim mahea' tau muitai. ");
INSERT INTO ptu_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Ingganna to muitai umpa'tulasam indo to mane sule maaka susi indo to napentamai setam ingngena' dipabono'. ");
INSERT INTO ptu_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Iya napelaum ingganna tau dio attasa'na to Gerasa umba ke malai le'ba' Puang Yesus aka sangngim mahea'. Iya längämmi lopi Puang Yesus la ma'pasule. ");
INSERT INTO ptu_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Iya napelaum indo to bali napentamai setam naua: “O Tuangguhu, mala haka ke umpasolaä' kao?” Sapo' tä' napäbäi, anggam nauaam: ");
INSERT INTO ptu_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Pa'pasulengko lako banuammu anna untula' asanni ingganna indo puha napogausangko Puang Allataala.” Iya le'ba'um anna ussambai ingganna lalam dio kota natula' indo pa'pogau'na Puang Yesus lako kalena. ");
INSERT INTO ptu_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Tappana lambanni Puang Yesus ma'pasule, iya ma'silullu' oom buda tau untammui aka inna naampai. ");
INSERT INTO ptu_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Iya sulem duka' mesa tau isanga Yairus. Tau ia too mesa to pebaba illaam pa'sambajanganna to Yahudi dio kota ia too. Iya menomba siaham dio olona Puang Yesus anna mengkahumase-masei aka naua: “Umba ke malai lako banuangku,” ");
INSERT INTO ptu_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","aka deem änä'na mesa-mesa, baine, umbai' la sapulo duam taunna dadinna mahassam masaki masanta'. Iya muolai lalam Puang Yesus lako, nasisippi'-sippi'im indo tau buda untuhu'i. ");
INSERT INTO ptu_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Sapo' illaam alla'-alla'na indo tau buda deem mesa baine sapulo duam taunna nahua saki baine tä' deem mondanna, anna tä' deem moi podo la mesa tau mala umpabono'i. ");
INSERT INTO ptu_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Iya le'ba'um lako boko'na Puang Yesus anna naantii tähämpä' bajunna. Iya naantinna bajunna, tappa monda siaham sakinna. ");
INSERT INTO ptu_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Iya ma'kadam Puang Yesus naua: “Menna hia muantiä'?” Sapo' sangngim tä' deem mangngaku. Iya natimba'im Petrus naua: “Tuangguhu, inde lako tau buda ulleboko anna nasisippi'-sippi'i.” ");
INSERT INTO ptu_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Sapo' tontä liu duka' naua Puang Yesus: “Deem tau muantiä' aka kusi'dim deem kuasa messubum illaam mai kaleku.” ");
INSERT INTO ptu_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Tappana naissam indo baine naua naissam dia Puang Yesus, iya sule siahanni lumalla' menomba dio olona. Anna natula'i dio olona tau buda kasuhunganna anna naantii. Anna natula' toi naua: “Bono' eta siahamä' duka'.” ");
INSERT INTO ptu_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Iya ma'kadam Puang Yesus lako indo baine naua: “O änä'ku, bono'ungko aka ungkatappa'iä'. Laongko, la naundu'ko kamasakkeam sola kamasannangam.” ");
INSERT INTO ptu_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Mahassampi ma'tula' anna sule hanni to untambai Yairus dio mai banuanna naua: “Indo änä'mu, matem. Damon too ussussai Tuangguhu.” ");
INSERT INTO ptu_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Sapo' nahingngi Puang Yesus, iya ma'kadam lako Yairus naua: “Daa ummahea', pomanontonni kamatappasammu aka indo änä'mu la tubo.” ");
INSERT INTO ptu_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Tappana landa' lako banuanna Yairus, tä' deem tau senga' napäbäi Puang Yesus napasola tama, sulibanna Petrus, Yohanes, Yakobus, anna ambena sola indona indo änä'-änä'. ");
INSERT INTO ptu_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Wattu eta too ingganna tau to dio heem mahassam sikauhhu' anna umbatim aka matem indo änä'-änä'. Iya nauaammi Puang Yesus: “Daa ussikauhhu'a', aka inde änä'-änä' tä' tia mate, sapo' mamma' bäbä hi tia!” ");
INSERT INTO ptu_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Sapo' sangngim umpetabai mandi Puang Yesus aka naissam naua matem. ");
INSERT INTO ptu_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Iya naanda'im Puang Yesus limanna anna napa'kadai naua: “O änä'ku, bangongko.” ");
INSERT INTO ptu_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Iya menaba siaham sule anna bangonni ke'de'. Nauam Puang Yesus: “Beennia' kinande.” ");
INSERT INTO ptu_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Iya mängä-mängä pole' tomatuanna. Sapo' napakahi'di Puang Yesus naua: “Pissa'-pissa' ahanna' la untula' pole lako tau senga' inde kadadiam.” ");
INSERT INTO ptu_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Pissam wattu untambai indo sapulo dua suhona Puang Yesus anna nabeenni kamatohoam sola kakuasaam la uhhambai ingganna setam anna umpabono' ma'hupa-hupa saki. ");
INSERT INTO ptu_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Anna nasuai lao umpa'pakahebaam kapahentaanna Puang Allataala anna la umpabono' to masaki. ");
INSERT INTO ptu_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Anna napakahi'dii naua: “Tä'koa' deem la umbaba aka-aka illaam pa'laoammu, susinna tekkem, ongeam tinallo, tinallo, doi', anna poheba pembalasam. ");
INSERT INTO ptu_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Anna maka' mentamakoa' mesa tondä', iai too banua muongei, iya eta liungkoa' too lambi' umpelleia' indo tondä'. ");
INSERT INTO ptu_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Anna maka' deem tau tä' untahimakoa', iya pelleia' indo tondä'na sapo' pempassiannia' sobä'na indo tondä' dio bitti'mu, aka la mendadi tanda lako tondä' ia too la natumpu pala' Puang Allataala.” ");
INSERT INTO ptu_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Iya le'ba'um indo suhona ullelei mobotto-bottoam umpa'pakahebaam Kaheba Katilallasam napasindum umpabono' to masaki lako si mesa-mesa ongeam. ");
INSERT INTO ptu_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Wattu eta too, napelele duka' Herodes indo tomahaja dio lembäna Galilea diona pa'pogausanna Puang Yesus, nasuhum buntä bäbä pikkihanna aka buda tau muuai: “Indo to diuaam Puang Yesus, ia siam tia indo Yohanes to si mantedo' tubo sule.” ");
INSERT INTO ptu_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Anna deem piha tau muuai: “Nabi Elia hi tia sule sule.” Deem toi muuai: “Mesa hi tia nabi yolona tubo sule.” ");
INSERT INTO ptu_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Iya nauam Herodes: “Puham tia kupopelempo'iam ulunna indo Yohanes to si mantedo'. Dadi, menna amo hi tia isanga indo Yesus si dipelele umpogau' kaha-kaha ia too?” Iya napeäm lalanna anna mala umpellambi'i Puang Yesus. ");
INSERT INTO ptu_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Tappana ma'pasulei indo suhona Puang Yesus, iya ma'hempummi anna natulasanni indo puha napogau' lako mobotto-bottoam. Puhai ia too, iya umbabaim indo suhona Puang Yesus lako mesa kota isanga Betsaida aka la ma'hempum paka-paka ia dio. ");
INSERT INTO ptu_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Sapo' naissanna tau buda, iya le'ba'im untuhu' Puang Yesus. Iya natahimam Puang Yesus anna natulasanni diona kapahentaanna Puang Allataala anna umpabono' toi to masaki. ");
INSERT INTO ptu_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Tappana la lendu' allo, napellambi'im indo sapulo dua passikolanna anna nauaanni: “Umbai' la mapia ke ussuai inde lako tau buda anna malai lao umpeä kinande anna ongeam ma'bengi lako tondä' anna lako to ma'liangam aka inde ongeam taongeia' pohiallasam.” ");
INSERT INTO ptu_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Sapo' natimba' naua: “Iko hanna' umpandei.” Iya nauam passikolanna: “Pusa'kam aka anggam deem kiampuam lima hoti anna dua bau. Anggam ke laoi dipangngalliam anna la malai kipande inde tau buda.” ");
INSERT INTO ptu_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","(Indo tau buda, kiha-kiha lima sa'bu muane mandipi.) Iya muuaammi passikolanna: “Suai muokko' si lima pulo sallaoam oi.” ");
INSERT INTO ptu_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Iya nasuam duka' passikolanna, muokko' si lima pulo sallaoam oi. ");
INSERT INTO ptu_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Iya naalam Puang Yesus indo lima hoti anna dua bau, mane mentongai längäm langi' nakuhhu'i sumanga' längäm Puang Allataala. Puhai ia too, napiä'-piä'um indo hoti mane nabeenni passikolanna natabaam lako indo tau buda. ");
INSERT INTO ptu_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Iya mangngandeim sampe dea'. Tappana puhai mangngande, iya nahempummi passikolanna indo tää'nam naande, iya ponnopi sapulo dua baka. ");
INSERT INTO ptu_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Pissam wattu mahassam ma'sambajam Puang Yesus mesa-mesanna, iya sulem passikolanna napellambi'i. Iya nauam Puang Yesus: “Situhu' tula'na tau, aka si nasangaiannä'?” ");
INSERT INTO ptu_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Iya natimba'im naua: “Deem tau muuai: ‘Yohanes to si mantedo' tubo sule;’ sapo' deem duka' muuai: ‘Nabi Elia sule sule;’ anna piha muuai: ‘Mesa nabi yolona tubo sule.’” ");
INSERT INTO ptu_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Iya mekutana oom lako passikolanna naua: “Maka' susi, iya akaa' iko ussangaiannä'?” Iya natimba'im Petrus naua: “Ikom too indo To nalanti' Puang Allataala la mepasalama'.” ");
INSERT INTO ptu_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Iya umpakahi'dim passikolanna naua: “Tä' si'da-si'daa' too deem la mala untula' lako tau senga' le!” ");
INSERT INTO ptu_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Mane nauai: “Kao to disangai Änä' Mentolino la ussi'dim ma'hupa-hupa pandahhaam anna la natumpu pala'ä' matua ulunna to Yahudi anna ingganna kapala sando sola to ullatta' Pepaondonganna Musa lambi' la napateiä'. Sapo' illaam allo katallunna la dipatibangonnä' sule dio mai alla'na to mate.” ");
INSERT INTO ptu_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Puhai ia too, ma'kadam Puang Yesus lako tau buda naua: “Menna-menna maelo' untuhu'iä' pahallu la ullappa' pa'elo' kalena, anna allo-alloi umpassam kaju sitambenna, anna natuhu'ä'. ");
INSERT INTO ptu_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Aka menna-menna umpakalando puha ia katuboam di lino anna la Kao, tau ia too tä' ia la ullambi' katuboam sule lako salako-lakona. Sapo' menna-menna ahu' mate aka natuhu'ä', tau ia too la ullambi' indo katuboam sule lako salako-lakona. ");
INSERT INTO ptu_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Tä' deem gunana lako mesa tau moi la muampuam ingganna issinna lino kela sägä hi sungnga'na. ");
INSERT INTO ptu_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Aka menna-menna umpa'kasihisannä' anna umpa'kasihisam pepa'guhuangku, tau ia too la kupa'kasihisam duka' ke sulemä' to disangai Änä' Mentolino naponnoi kamatandeangku anna kamatandeanna Ambeku sola kamatandeanna ingganna malaika' maseho. ");
INSERT INTO ptu_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Setongam-tonganna, deengkoa' to dio heem temo tä'pi la mate anna muitam Puang Allataala umpalako kapahentaanna.” ");
INSERT INTO ptu_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Umbai' kahuai benginna lessu'na natula' Puang Yesus pepa'guhuam ia too, iya umbabaim Petrus, sola Yohanes, anna Yakobus le'ba' längäm mesa tanete malangka' ma'sambajam. ");
INSERT INTO ptu_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Mahassanni ma'sambajam, iya tieli'um hupanna Puang Yesus anna pangkähhä pohebana. ");
INSERT INTO ptu_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Pissananna, deem dua tau nasipa'tulasam Puang Yesus. Iam too indo nabi yolo isanga Musa sola Elia. ");
INSERT INTO ptu_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Indo to dua bassim pangkähhä duka' diita. Iya sipa'tula' loppo'um diona kamateanna Puang Yesus la napasule lako dio Yerusalem. ");
INSERT INTO ptu_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Wattu eta too mahassam ia mamma' Petrus anna indo solana. Tappana milli', iya muitam pangkähhäna Puang Yesus anna indo to dua ke'de' dio ampe'na. ");
INSERT INTO ptu_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Tappana la le'ba' indo to dua umpellei Puang Yesus, iya ma'kadam Petrus naua: “O Tuangguhu, tä'um deem la susi kamasannangantaa' eta inde. Mapia ke kipake'desangkoa' tallu bahum: mesa Iko, mesa Musa, anna mesa Elia.” Ia anna ma'kada susii Petrus, aka tä' bäbä naissam aka la naua. ");
INSERT INTO ptu_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Mahassampi ma'tula' anna sule ham gabum ussikuku'i indo ongeam. Iya mahea' indo passikola tappana nasikuku'i indo gabum. ");
INSERT INTO ptu_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Iya nahingngim kamaha buttu illaam mai indo gabum naua: “Iam too inde Änä'ku to puha kupilei. Pahallua' la umpehingngii!” ");
INSERT INTO ptu_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Puhai nahingngi indo kamaha, iya muitam Puang Yesus mesa-mesanna ham. Napahandu' etam too indo tallu passikolanna tä' deem natula' pole lako tau senga' indo kaha-kaha mane puha naita. ");
INSERT INTO ptu_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Tappana masiä, ma'pasuleim yabo mai indo tanete, iya ma'silullu' oom tau buda sule umpellambi'i Puang Yesus. ");
INSERT INTO ptu_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Pissananna metambam mesa tau illaam mai alla'-alla'na indo tau buda naua: “O Tuangguhu, inde änä'ku anggam mesa-mesa! Kela mala ungkamaseiä' anna umpetuasannä'! ");
INSERT INTO ptu_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Si bassa' napentamai setam nasuhum kakissä'-kissä' mane lumalla'i ma'patikingkim, ma'tambuha-buha sädäna. Indo setam undahha liu inde änä'ku anna mallam la napellei. ");
INSERT INTO ptu_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Anna puhamä' mengkahumase-mase lako inde mai passikolammu anna mala nahambaiam lao setanna, sapo' tä' dia mala.” ");
INSERT INTO ptu_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Iya ma'kadam Puang Yesus naua: “Kukapusa'i si'dakoa' pole' inde to tubo lapi' temo, aka kuhäm sugali'a' kamatappasammu! Anna tä' liupia' muissam usse'la kamapiaam anna kakadakeam. La pada polepi isanga umba masäena sola-solakia' anna la pada polepi isanga umba masäena la kusa'bahasangkoa'?” Mane nauai: “Babaannä' mai itim änä'mu!” ");
INSERT INTO ptu_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Mahassanni mellao indo änä'-änä' la umpellambi'i Puang Yesus, tappa napatissämbä' oham indo setam dokko litä' lumalla' ma'patikingkim. Iya nakissä'im Puang Yesus indo setam illaam kalena indo änä'-änä' anna napabono'i, mane nabeenni lako ambena. ");
INSERT INTO ptu_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Iya sangngim mängä-mängä indo tau buda muita kakuasaanna Puang Allataala tä' deem nasipadaangam. 9:43-45 Mahassampi mängä-mängä indo tau buda muita pa'pogausanna Puang Yesus, iya ma'kadam Puang Yesus lako passikolanna naua: ");
INSERT INTO ptu_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Pehingngiia' anna umpaillaam tambu'i inde tula'ku: Kao to disangai Änä' Mentolino la dibeho tama pala' limanna hupatau.” ");
INSERT INTO ptu_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Sapo' tula' ia too tä' natama akkalanna passikolanna kalembasanna. Aka tä'pi dipaissanni indana naissam säkäi. Anna sangngim malaja' umpekutanaanni kalembasanna indo tula'na. ");
INSERT INTO ptu_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Iya sibetä'-betä'um passikolanna Puang Yesus naua: “Mennakia' handam matande?” ");
INSERT INTO ptu_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Sapo' naissam Puang Yesus indo lalam penabanna passikolanna, nasuhum muala mesa änä'-änä' bahinni' anna napake'de'i dio ampe'na. ");
INSERT INTO ptu_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Mane nauai: “Menna-menna untahima inde änä'-änä' aka umpolalam kamatappasanna di Kao, tau ia too sihhapam siam Kao natahima. Anna menna-menna untahimaä', tau ia too untahima duka' To ussuaä'. Aka iai too ussanga kalena handam bahinni' illaam alla'-alla'mua', iam too la handam matande.” ");
INSERT INTO ptu_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Iya ma'kadam Yohanes lako Puang Yesus naua: “O Tuangguhu deem kiita mesa tau uhhambai setam umpake sangammu, sapo' tä' kipäbäi aka taia indo to si tapasolaa'.” ");
INSERT INTO ptu_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Sapo' natimba' naua: “Daa ullahanni, aka iai too tä' umbalikoa', iam too solamu.” ");
INSERT INTO ptu_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Tappana la lambi' wattunna la tiäkä' längäm suhuga Puang Yesus, iya napasatutum penabanna lu längäm Yerusalem. ");
INSERT INTO ptu_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Iya ussuam sanaka-naka solana mendiolo lu lako mesa tondä' illaam attasa'na to Samaria aka la napatokaam ingganna kapahalluanna. ");
INSERT INTO ptu_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Sapo' indo tau illaam tondä' eta too moka untahima Puang Yesus aka la lu längäm Yerusalem. ");
INSERT INTO ptu_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Tappana naissam indo dua passikolanna isanga Yakobus sola Yohanes naua tä' natahima indo pa'tondä', iya napelaum lako Puang Yesus naua: “O Debata, muaku haka ke kipatuhunganni api yabo mai langi' muä'bäi?” ");
INSERT INTO ptu_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Sapo' napenggihi'i Puang Yesus nakeaha'i. ");
INSERT INTO ptu_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Iya umpatahhu'um pa'laoanna muola lako tondä' senga'. ");
INSERT INTO ptu_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Mahassanni umpatahhu' pa'laoanna Puang Yesus sola passikolanna, iya ma'kadam mesa tau naua: “O Tuangguhu, la kutuhu' liuko illaam pa'laoammu, moi umba ngei muola.” ");
INSERT INTO ptu_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Iya natimba'im Puang Yesus naua: “Asu pangngala' ia deem leäna, anna ingganna dassi yabo lawwa deem sehäna, sapo' Kao to disangai Änä' Mentolino tä' Kao deem la manontom kuongei metindo.” ");
INSERT INTO ptu_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Mane ma'kada polei lako mesa tau senga' naua: “Tuhu'ä'.” Iya natimba'im indo tau naua: “Io, sapo' la mala haka ke laopä' yolo ullamum ambeku mane suleä' kutuhu'ko?” ");
INSERT INTO ptu_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Iya natimba'im naua: “Päbäi mammi ia duka' itim matim to mate ullamum to matena. Sapo' iko-iko, laoko pa'paissangam kapahentaanna Puang Allataala.” ");
INSERT INTO ptu_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Iya ma'kada pole oom mesa tau naua: “La kutuhu'ko kao Debata, sapo' la umpäbäipä' yolo lao kupasaha' kasahapuangku.” ");
INSERT INTO ptu_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Sapo' natimba' Puang Yesus naua: “Menna-menna sihhapam napahandu'um massalaga, sapo' messaile ohi lako boko'na, tau ia too tä' deem gunana illaam kapahentaanna Puang Allataala.” ");
INSERT INTO ptu_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Puhai ia too, untuho pole oom pitu pulo tau senga' Puang Yesus Debatanta anna nasuai lao pantam si dua umpendioloanganni lako si mesa-mesa kota anna ongeam la napellambi'i'. ");
INSERT INTO ptu_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Nauaammi Puang Yesus: “Indo tau illaam inde lino sihhapam pahe matäsä'um. Buda indo pahe matäsä', sapo' saidi' to mepahe. Dadi pelauia' längäm puäna indo pepaheam anna mala ussua buda tau umpepaheanni. ");
INSERT INTO ptu_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Pengkalaongkoa', sapo' pengkilalai manappaia', la sihhapangkoa' too domba kusua tama alla'-alla'na olo'-olo' to peande. ");
INSERT INTO ptu_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Daa umbabaa' ongeam doi'mu, ongeam tinallo, sapatu, anna tä' tookoa' la tohho lako lalam la sipa'tula' tau. ");
INSERT INTO ptu_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Maka' mentamakoa' mesa banua, la muuaa' yolo: ‘Natamba' dangkoa' Debata.’ ");
INSERT INTO ptu_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Anna maka' mapia penabanna untahima manappakoa' puäna indo banua, iya la natahima si'da too indo pa'lambemua'. Sapo' maka' too tä'koa' natahima, iya la tä' too duka' natahima indo pa'lambemu. ");
INSERT INTO ptu_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Tohho diokoa' indo mesa banua, tä'koa' la ma'pentieli'-eli' lako banua senga'. Iai too natahiaiangkoa' to ma'banua, iam muande anna muihu'. Aka ingganna to mengkähä abana sipäto' la diponnoiam kapahalluanna. ");
INSERT INTO ptu_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Maka' mentamakoa' mesa tondä' anna natahima manappakoa', iya andei indo kinande natahiaiangkoa'. ");
INSERT INTO ptu_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Pabono'i to masaki illaam indo tondä' anna umpaissannii tau eta too muua: ‘La bale' umpalakom kapahentaanna Puang Allataala illaam alla'-alla'mua'.’ ");
INSERT INTO ptu_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Sapo' maka' mentamakoa' mesa kota anna tä'koa' natahima, iya lu lakokoa' lalam mahoa' anna muuaia': ");
INSERT INTO ptu_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Moi sobä'na inde tondä'mua' dio bitti'ki, kipempassiam toi lao aka la mendadi tanda diua la natumpu pala'koa' Puang Allataala. Sapo' kipaissanni loppo'koa' kiua la bale' umpalakom too kapahentaanna Puang Allataala.’ ");
INSERT INTO ptu_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Kutulasangkoa' temo kuua, maka' too ke lambi'um indo allo la naongei Puang Allataala umpopa'tadongkongam hupatau, la mabanda' puha ia tahungkunna issinna indo tondä' ia too anna la issinna kota Sodom.” ");
INSERT INTO ptu_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“La tilakakoa' iko ingganna issinna kota Korazim anna kota Betsaida aka mokakoa' muondo' gau' kadakemu. Aka indo tanda memängä-mängä kupadadi illaam alla'-alla'mua', kela kupadadi diom kota Tirus anna Sidon, la masäem untihokonganna gau' kadakena hupatau dio, lambi' muokko' ma'poheba bahata anna umpaponnoi täiabu ulunna aka ussosso gau'na. ");
INSERT INTO ptu_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Maka' too ke lambi'um indo allo la naongei Puang Allataala umpopa'tadongkongam hupatau, la mahingngam leko' ia tahungkunna issinna kota Tirus sola Sidon anna la tahungkummua'. ");
INSERT INTO ptu_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Anna ikoa'-iko to Kapernaum, ussanga hia' iko umbai' la dipatiäkä' längängkoa' suhuga? Sapo' setonganna la ditibe tama hakoa' iko lembä bolom.” ");
INSERT INTO ptu_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Mane ma'kada oi lako indo to la nasua naua: “Menna-menna umpehingngiikoa', sihhapam siam tia Kao napehingngii. Menna-menna untumpu pala'koa', Kao siam tia natumpu pala'. Anna menna-menna untumpu pala'ä', untumpu pala' duka' indo To ussuaä'.” ");
INSERT INTO ptu_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Tappana ma'pasule indo pitu pulo passikolanna, iya tä' deem pada satilalla' ma'tula' lako Puang Yesus naua: “O Debata, moi ingganna setam napehingngii tookam ke kisuai lao umpake sangammu.” ");
INSERT INTO ptu_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Natimba' Puang Yesus naua: “Kuita tomahajanna setam mehonno' susi kila' yabo mai langi'! ");
INSERT INTO ptu_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Pehingngiia' aka setonganna puhangkoa' kubeem kakuasaam la ullullu'i ula' sola alipam, anna la untaloi kamatohoanna balimmu, nasuhum tä'um deem aka la untilakaikoa'. ");
INSERT INTO ptu_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Sapo' moi anna untaloingkoa' setam, tä' la ianna' untilalla'i, sapo' la indo hia tisuha'um sangammua' yabo suhuga.” ");
INSERT INTO ptu_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Wattu eta too naponnoi katilallasam Puang Yesus buttu di Penaba Maseho lambi' ma'sambajam naua: “O Ambe', Puäna langi' anna lino! Ma'kuhhu' sumanga'ä' matim olomu, aka indo kada ditambimmu tä' umpapähänni lako to naangga' manähä anna keaka' hupatau, sapo' umpapähänni leko' ia lako to naangga' matuna hupatau. O Ambe' abana inna ia pa'elo'mu.” ");
INSERT INTO ptu_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Puhai ma'sambajam, iya nauam: “Ingganna-ingganna sia puha asammi napadokkoannä' lisu pala'ku Ambeku. Tä' deem moi podo la mesa hupatau la muissam manappai menna Änä'na Puang Allataala sulibanna Ambe', anna tä' toi deem moi podo la mesa hupatau la muissam manappai menna Ambe' sulibanna Änä'na, anna to napoelo' Änä'na, anggam ia la muissam manappa Ambeku.” ");
INSERT INTO ptu_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Puhai ia too, umpenggihi'im passikolanna Puang Yesus anna nauai: “Kehongko'koa' aka muitaa' inde kaha-kaha. ");
INSERT INTO ptu_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Aka kutulasangkoa', buda nabi anna tomahaja yolona maelo' la naita inde to muitaa' temo, sapo' tä'um ia mala naita. Anna maelo' la nahingngi inde to uhhingngia' temo, sapo' tä'um ia mala nahingngi.” ");
INSERT INTO ptu_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Iya ke'de'um mesa to ullatta' Pepaondonganna Musa aka maelo' la umpetidom Puang Yesus ma'kada naua: “O Tuangguhu, aka la kupogau' anna malaä' ullambi' katuboam sule lako salako-lakona?” ");
INSERT INTO ptu_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Natimba'i Puang Yesus naua: “Aka naua illaam Pepaondonganna Musa? Aka naua pikkihammu tappana puha umbata?” ");
INSERT INTO ptu_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Iya nauam indo tau: “Dituli' naua: ‘Kamaseikoa' Debata, Puang Allataala to umpenombai sola sakalebu penabammu anna mentu' pikkihammu anna mentu' kamatohoammu,’ anna naua toi ‘Kamaseikoa' padammu hupatau umba susi ungkamasei kalemu.’” ");
INSERT INTO ptu_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Iya nauaammi Puang Yesus: “Tappa' itim pentimba'mu. Pogau'um too umba susi indo umbata anna malako tubo.” ");
INSERT INTO ptu_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Sapo' napeä lalanna la ummaloloam kalena lambi' mekutana pole oom lako Puang Yesus naua: “Iya menna isanga padangku hupatau la pahallu kukamasei?” ");
INSERT INTO ptu_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Natimba'um Puang Yesus sapo' pehapangam napake naua: “Deem mesa tau mengkalao yabo Yerusalem la lu dokko Yerikho. Muolai lalam, nahappaim to mangngabum pohebana anna ingganna aka-akanna. Anna tä' nahappai mandi sapo' nagasa'i polepi sampe saidi' tamate mane napellei bäbäi lao. ");
INSERT INTO ptu_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Siampu' eta too deem mesa sando muola eta duka'. Sapo' naitanna indo tau, napengkulio'i mandi muola dio bihim lalam anna tahhu'i. ");
INSERT INTO ptu_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Susi siam duka' deem mesa pessubunna Lewi liu dio lalam ia too. Tappana naita indo tau, napengkulio'i mandi duka' muola dio bihim lalam anna tahhu'i. ");
INSERT INTO ptu_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Sapo' deem mesa to Samaria muola dio duka' indo lalam ia too. Naitanna indo tau, tappa häntä buana. ");
INSERT INTO ptu_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Napenandai siaham indo to sägä anna nabasei anggur basana anna napakuliianni minnä' mane naba'basanni. Puhai, naäkä'um längäm keledainna mane nababai lako mesa ongeam si diongei ma'bengi anna nauhusanni kapahalluanna. ");
INSERT INTO ptu_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Masiänai, mualam dua doi' peha' anna nabeenni lako indo puäna banua naongei ma'bengi mane nauaanni: ‘Jappanniam manappaä', anna maka' deempi kapahalluam senga'na, iya ma'pasulepä' mane kubaja'i.’” ");
INSERT INTO ptu_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Puhai ia too, mekutanam Puang Yesus lako indo to ullatta' Pepaondonganna Musa naua: “Inde tallu tau, umbanna iko situhu' pikkihammu mala disangai padanna hupatau indo to nahappai to mangngabum aka-akanna ingngena'?” ");
INSERT INTO ptu_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Natimba' naua: “To ungkamasei indo to dihappai aka-akanna.” Iya nauaammi Puang Yesus: “Laongko ammu pogau'i susi.” ");
INSERT INTO ptu_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Iya umpatahhu' oom pa'laoanna Puang Yesus sola passikolanna sampe landa' lako mesa tondä'. Eta too deem mesa baine isanga Marta untambai tama banuanna. ");
INSERT INTO ptu_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Deem solasubunna isanga Maria, muokko' dio olona Puang Yesus Debatanta napehingngii tula'na. ");
INSERT INTO ptu_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Sapo' Marta ia anggam umpikki' kähänganna lako dapo' la napake ma'tahia, nasuhum umpellambi'i Puang Yesus anna nauai: “O Tuangguhu, akanna umpäbäi hi iko Maria napamesa-mesaä' mealaam lako dapo'? Uaanni anna nabaliiä'!” ");
INSERT INTO ptu_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Natimba' Puang Yesus Debatanta naua: “Marta, o Marta! Muaka tiko manangnga anna ungkasussaam buda kaha-kaha. ");
INSERT INTO ptu_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Anggam mesa handam pahallu. Anna napileim ia Maria indo handam mapianna. Anna ia oom ia duka' la napogau', tä' la mala dilabai.” ");
INSERT INTO ptu_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Pissam wattu ma'sambajam Puang Yesus dio mesa ongeam. Puhai ma'sambajam, ma'kadam mesa passikolanna naua: “O Tuangguhu, patudukam duka' ma'sambajam susi Yohanes umpatudu passikolanna ma'sambajam.” ");
INSERT INTO ptu_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Iya nauam Puang Yesus: “Maka' ma'sambajangkoa', la muuaa': Ambeki, dipa'kasallei sanga masehomu, kela mala Ikom ma'pahenta. ");
INSERT INTO ptu_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Beengkanni kinande la sihuanna kiande allo-allo. ");
INSERT INTO ptu_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Anna muampunniangkanni kasalaangki, aka muampunningkam duka' to kasalaam lako kaleki. Anna daa ullappa'kam tama pa'sändäsam.” ");
INSERT INTO ptu_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Mane ma'kada polei lako passikolanna naua: “Hapanna deengkoa' mesa le'ba' lako banuanna solamu tängä bengi anna muuaanni: ‘O solaku, pahabe'iä' kao tallu kalebu hotimmu, ");
INSERT INTO ptu_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","aka deem issangangku lempä sapo' katappusannä'.’ ");
INSERT INTO ptu_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Sapo' natimba' di indo issinna banua naua: ‘Daa unggangguä' aka puham kukädo' ba'baku anna metindongkam sola änä'ku. Tä'mä' mala la bangom umbeengko aka-aka.’ ");
INSERT INTO ptu_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Kutulasangkoa', moinna anna solamu, tä' siam la naaku bangom la nabeengko kapahalluammu, sapo' aka ungkekke' liu umpelau, iya bangommi duka' anna nabeengko ingganna pelauammu. ");
INSERT INTO ptu_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Dadi, si pelauia' kapahalluammu längäm Puang Allataala anna naponnoiangko. Peäi kapahalluammu anna ullolonganni. De'de'i ba'ba anna mala natungka'iangko. ");
INSERT INTO ptu_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Aka menna-menna melau la diponnoiam pelaunna, anna menna-menna mameä la nalolongam, anna menna-menna unde'de' ba'ba la ditungka'iam. ");
INSERT INTO ptu_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Tä' deem mesa ambe la palla' penabanna umbeem ula' änä'na ke umpelaui bau. ");
INSERT INTO ptu_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Susi toi duka' tä' deem tau la palla' penabanna umbeem alipam änä'na ke umpelaui tullu. ");
INSERT INTO ptu_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Dadi ikoa' duka' to madosa anna muissanni umbeem änä'mu la napomapianna, damo aham Ia Ambemu yabo suhuga la umbeem Penaba Maseho lako si mesa-mesa hupatau to melau dio olona.” ");
INSERT INTO ptu_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Pissam wattu uhhambai mesa setam Puang Yesus illaam mai kalena mesa to pepe. Messubunna indo setam, iya mala siaham ma'tula'. Nasuhum sangngim nakapilla'i tau buda. ");
INSERT INTO ptu_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Sapo' deem duka' muuai: “Kuasanna hi tia Beelzebul battu diua tomahajanna setam illaam kalena nasuhum mala uhhambai lao setam.” ");
INSERT INTO ptu_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Deem duka' sanaka-naka tau senga' maelo' la umpeängam tuntungam su'be' Puang Yesus, nasuhum napellambi'i anna nauaanni: “Paitaikam tanda memängä-mängä yabo mai suhuga.” ");
INSERT INTO ptu_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Sapo' nalosa Puang Yesus pikkihannai, nasuhum ma'kada naua: “Maka' deem mesa kahajaam tä' mala mesa penaba hupataunna illaam, mannassa anna la kahenggängannai dadi. Susi toi duka' ke deenni mesa pandaposam, ke sikabassi-bassii issinna, mannassa anna la titale bangke'i issinna. ");
INSERT INTO ptu_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Susi siam too duka' kapahentaanna setam. Maka' la sianu-anu paka ia illaam kahajaanna, iya iam tia isanga sipobali-bali paka ia, nasuhum kende' kahenggänganna. Ma'kada susiä' aka muua hia' iko: ‘Kakuasaanna hi tia Beelzebul napake uhhambai lao setam.’ ");
INSERT INTO ptu_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Maka' susi, iya kuasanna haka duka' Beelzebul napake pentuhu'mua' uhhambai lao setam? Mannassa anna sala pikki'koa', aka taia duka' kakuasaanna setam napake uhhambai lao setam! ");
INSERT INTO ptu_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Sapo' setonganna uhhambaiä' lao setam aka kakuasaanna Puang Allataala muundu'ä'. Dadi mannassa diua umpalakom kapahentaanna Puang Allataala illaam alla'-alla'mua'. ");
INSERT INTO ptu_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Maka' hapanna deem mesa to matoho anna ganna' pangkakka'na unjagai banuanna, iya la amam asam aka-akanna. ");
INSERT INTO ptu_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Sapo' maka' deem to matoho puha ia ungkatamai lambi' nataloi, iya la nahappai asam indo pangkakka' to nahannuam anna nabahe-bahei kullena. ");
INSERT INTO ptu_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Menna-menna tä' untuhu'ä', tau ia too nabaliä'. Susi toi duka' lako to tä'kam pada kähä mahhempum, tau ia too to mantaleam ia.” ");
INSERT INTO ptu_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Mane naua polei: “Maka' deem mesa setam messubummi illaam mai kalena tau, iya la le'ba' kalao-lao lako ongeam mabanginna umpeä ongeam la naongei tohho. Sapo' tä' deem nalambi' ongeam la mala naongei. Iya nauam: ‘La ma'pasuleä' sule lako indo ongeangku ingngena'.’ ");
INSERT INTO ptu_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Iya le'ba'um sule lako indo ongeanna, iya bahassi liupi nalambi', sihhapam banua bahassi anna tiäto', mapia la naongei. ");
INSERT INTO ptu_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Iya le'ba' siaham untambai solana pitu, sapo' kadake puha ia indo solana anna la kalena. Anna tohho asanni illaam kalena indo tau. Ma'katampasanna, tau ia too la tuttuam tama kakajuanna indo kakadakeam illaam kalena anna indo anggapi mesa setam umpentamai.” ");
INSERT INTO ptu_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Mahassampi ma'tula' Puang Yesus, iya metambam mesa baine illaam mai alla'-alla'na tau buda naua: “Kehongko' ia indo baine to undadiangko anna napasusu.” ");
INSERT INTO ptu_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Sapo' natimba' Puang Yesus naua: “Kehongko' puha ia to umpehingngii anna umpalako Battakadanna Puang Allataala.” ");
INSERT INTO ptu_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Mahassanni nalebo tau buda Puang Yesus, iya umpatahhu' oom pa'tula'na naua: “Ia anna maelo'koa' la kupadadiam tanda memängä-mängä inde to tubokoa' lapi' temo, aka sangngim ma'gau' kadakekoa'. Sapo' tä' la dipadadiangkoa' tanda memängä-mängä senga' sulibanna tanda memängä-mängä la dadi lako kaleku umba susi dadi lako kalena nabi Yunus yolona. ");
INSERT INTO ptu_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Aka umba susi nabi Yunus yolona dipotanda memängä-mängä lako issinna Niniwe, la susimä' too duka' to disangai Änä' Mentolino la mendadi mesa tanda memängä-mängä lako to tubo lapi' temo. ");
INSERT INTO ptu_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Anna illaam indo wattu la naongei Puang Allataala umpopa'tadongkongam hupatau, la dipatibangom indo tomahaja baine to umpahenta paluäna Syeba yolona. Indo tomahaja ia too la napasalakoa' inde to tubokoa' lapi' temo aka ahu' ia le'ba' umpehingngii kakeakasanna tomahaja Salomo moi anna mambela lalam naola. Sapo' ikoa'-iko, mokakoa' umpehingngii inde tula'ku sitingngajokia' kita moi kela daa mentondom puha hä' Kao anna la tomahaja Salomo. ");
INSERT INTO ptu_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Illaam indo wattu la naongei Puang Allataala umpopa'tadongkongam hupatau, la dipatibangom to Niniwe anna iai umpasalakoa' to tubo lapi' temo. Aka indo ia to Niniwe untihokongam ia gau' kadakena tappana uhhingngi kadanna Debata napalanda' nabi Yunus. Sapo' mokakoa' iko untihokongam gau'mu, moi kela daa inde to umpa'tula'ikoa' temo mentondom puha Ia anna la nabi Yunus.” ");
INSERT INTO ptu_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Mane naua polei: “Tä' deem tau la umpau' lampu mane nabunii battu haka la nasalongo'i baka. Sapo' napayabo hi tia inna ongeanna anna mala paindo masiä' naita ingganna to mentama indo banua. ");
INSERT INTO ptu_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Matammu sihhapam ballo illaam kalemu ma'pomasiä'. Aka maka' masiä' matammu, iya masiä' asam too duka' sakalebu kalemu. Sapo' maka' kadake matammu, iya malillim asam too kalemu. ");
INSERT INTO ptu_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Susim too duka' penabammu. Dadi jagai manappai indana indo ussangai kamasiäsam illaam kalemu, mendadi kamalillingam di. ");
INSERT INTO ptu_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Maka' masiä' asam penabammu anna tä' deem malillim sabaheam, iya masiä' asammi too, umba susi paindona lampu ummasiä'i asam kalemu.” ");
INSERT INTO ptu_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Puhai ma'pa'guhu Puang Yesus, natambaim mesa to illaam kakalebuanna Parisi la mangngande dio banuanna. Iya tamam indo banua anna muokko'i mangngande. ");
INSERT INTO ptu_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Mängä-mängä indo to illaam kakalebuanna Parisi aka muita Puang Yesus mangngande tä' umbasei yolo limanna, situhu' peadasanna to Yahudi. ");
INSERT INTO ptu_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Iya ma'kadam Puang Yesus naua: “Ikoa'-iko to illaam Parisi sihhapangkoa' to umbasei tangkihi' anna pihim, nabasei leko' sulibanna anna tä' ia hoäna. Anna hoäna hi naponnoi kakadakeam. Susingkoa' too aka naponnoikoa' kakadakeanna indo pangngala kahha'mua' anna indo pa'pogausam kadakemua'. ");
INSERT INTO ptu_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Oa' to maho! Tä' daka tia mesam Puang Allataala umpadadi bätä puntimmua' anna penabammu? ");
INSERT INTO ptu_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Indo hia pangngala malussummua' muampuam temo, ia hi tia la ungkamaseianna' lako to mase-mase. Aka iam too pole' la napolalam bahassi asanna' kalemu. ");
INSERT INTO ptu_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","La ullambi'koa' iko katilakaam inggannakoa' to illaam kakalebuanna Parisi! Aka ikoa'-iko umpa'kasallei leko'a' ia kaha-kaha bahinni' susinna umpatamaa' peadasammu bahe sapulona hampa-hampa indo si tubo bäbä isanga selasih, inggu, anna hampa-hampa senga'na. Sapo' umpa'lembeinna' ia umpalako undu' lollä lako hupatau anna ma'kamase lako Puang Allataala. Moi kela daa iam too inde handam pahallua' la umpalako. Sapo' tä' sianna' duka' la umpa'kalembei indo senga'na. ");
INSERT INTO ptu_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","La ullambi'koa' katilakaam inggannakoa' to illaam kakalebuanna Parisi! Aka si umpise'ikoa' ongeam dipa'kasalleinna ke illaanni pa'sambajangam. Angganna' si umpohäe ke napa'kasalleikoa' hupatau illaam pasa'. ");
INSERT INTO ptu_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","La ullambi'koa' katilakaam aka mapia bäbäkoa' diita anna kadake hia illaam penabammu, sihhapangkoa' ku'bu' tä' ditandai, dipa'ola-ola yabona aka tä' diissam diua kadake hia dio.” ");
INSERT INTO ptu_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Deem mesa to ullatta' Pepaondonganna Musa mentimba' naua: “O Tuangguhu, itim tula'mu, natunaikam duka'!” ");
INSERT INTO ptu_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Sapo' natimba' Puang Yesus naua: “La ullambi'koa' duka' katilakaam inggannakoa' to ullatta' Pepaondonganna Musa! Aka si umpapiakoa' pahenta mabanda' illaam peadasam anna umpadudunnii hupatau. Sapo' tä' punala hia' muaku umpamoloi hupatau, moi la sai'di'um, anna mala nabela napalako indo pahenta. ");
INSERT INTO ptu_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","La ullambi'koa' katilakaam aka umpapiaammia' pole' ku'bu'na ingganna indo nabi yolona, sapo' nenemu sianna' umpateii. ");
INSERT INTO ptu_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Kalembasanna ia too, muakuia' duka' anna ussangaa' hua indo pa'pogau'na nenemu, aka umpapiaammia' ku'bu'na indo to napatei. ");
INSERT INTO ptu_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Iam too anna nauam kamanähänganna Puang Allataala: ‘La kusua sule sanaka-naka nabi anna suho la umpellambi'i. Sapo' deem la napatei anna deem toi la nadahha.’ ");
INSERT INTO ptu_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Nasuhum inde to tubo lapi' temo la untanggum hahana ingganna nabinna Puang Allataala to puha titollo mengkalao uhu dadinna lino sule lako temo, ");
INSERT INTO ptu_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","battu diua mengkalao dio Habel sule lako Zakharia. Indo ia Zakharia dipatei illaam alla'na ongeam pehumalasam anna Banua Debata. Ia asanna ia too tä' mala tala umpendudunna' inde to tubokoa' lapi' temo. ");
INSERT INTO ptu_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","La ullambi'koa' katilakaam inggannakoa' to ullatta' Pepaondonganna Musa! Aka untutusangkoa' lalam hupatau la tama umpengngissanni diona Puang Allataala. Mokakoa' iko tama anna ullabai tookoa' duka' hupatau to la maelo' mentama.” ");
INSERT INTO ptu_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Tappana napellei Puang Yesus indo ongeam, iya napeä lium lalanna indo to illaam kakalebuanna Parisi sola to ullatta' Pepaondonganna Musa anna mala napetidom, umpake ma'hupa-hupa pekutanaam ");
INSERT INTO ptu_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","aka maelo' la umpeängam tuntungam su'be' Puang Yesus. ");
INSERT INTO ptu_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Wattu eta too massa'bu-sa'bu tau sisippi'-sippi' ma'hempum lambi' silullu'-lullu' bäbä. Mahassanni ma'silullu' tau, iya nauam Puang Yesus lako passikolanna: “La majaga manappakoa' too indana nakadakeikoa' bibi' hotinna to illaam kakalebuanna Parisi. Indo kuuaam bibi' hotinna, pudu' pandenna anna lila manähäna. ");
INSERT INTO ptu_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Sapo' indo pattuju penabanna la kaissangam. Aka ingganna aka-aka disamboi la dipakaleängam asam, anna ingganna aka-aka dibuni, la dipatandaam. ");
INSERT INTO ptu_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Anna indo kada ditambim untula' bengia' la dipa'paissangam illaam wattu masiä. Anna indo to umpa'bisisam lako solamu illaam tambim titutu', la dipebangkoam lao. ");
INSERT INTO ptu_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Pehingngiia' solaku! Daa ungkahea'i indo to anggam mala umpatei bätä punti, aka tä'um ia deem senga'na la mala napogausangkoa'. ");
INSERT INTO ptu_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","La kutulasangkoa' to la pahallu ungkahea'. La mahea' lako hokoa' Ia Puang Allataala to kuasa mampatei anna mane natibe tama nahaka. Abana, la Iaa' pahallu umpengkahea'i. ");
INSERT INTO ptu_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Taissanna' pada-pada taua lima dena' sai'di' allinna aka anggam dua himi'. Moinna anna susi, sapo' tä' deem moi podo la mesa la nakalembei Puang Allataala. ");
INSERT INTO ptu_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Senga'unna' tiko, aka meanggaa' beluä'mu puha nahekem asam di tia. Dadi, iam too anna tä'ungkoa' la mahea', aka moi la pada umba budanna dena' tala sipadaannia' angga'mu! ");
INSERT INTO ptu_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Pengkilalai manappaia' inde tula'ku: Menna-menna muakui kamatappasanna di Kao to disangai Änä' Mentolino dio olona hupatau, tau iam too duka' la kuakui dio olona ingganna malaika'na Puang Allataala kuua: ‘Iam too inde pentuhu'ku.’ ");
INSERT INTO ptu_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Sapo' menna-menna umbahoiä' dio olona hupatau, tau iam too duka' la kubahoi dio olona ingganna malaika'na Puang Allataala. ");
INSERT INTO ptu_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Deem sia ia paleleanna la diampunni to ma'tula' kadake diona Änä' Mentolino. Sapo' tä' si'da-si'da ia deem paleleanna la diampunni to untelle Penaba Maseho. ");
INSERT INTO ptu_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Maka' dibabakoa' lako olona to mahhotto' illaam peadasam, battu haka dipopengngolo lako to ma'pahenta battu to kuasa, iya tä'koa' la umpakabeba penabammu la muua: ‘Aka amom isanga la diua mentimba'?’ ");
INSERT INTO ptu_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Aka Penaba Maseho la umpatudukoa' indo la pahallunna untula' wattu eta too.” ");
INSERT INTO ptu_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Deem mesa tau illaam alla'-alla'na indo tau buda ma'kada lako Puang Yesus naua: “O Tuangguhu, uaanni indo solasubungku anna nabeennä' kao piha indo kulle natampeangkam tomatuangki.” ");
INSERT INTO ptu_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Sapo' natimba' Puang Yesus naua: “O solaku, menna hi kao muäkä'ä' la mendadi to mahhotto' battu diua to la untabaangkoa' mana'mu?” ");
INSERT INTO ptu_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Mane ma'kadai lako indo tau buda naua: “Majagakoa' anna mainga', indana lu lakoi kulle penabammu anna ma'podo kao. Aka moi la kende' langi' katomakakaanna mesa tau tala ia sia umbabai lako katuboam mapia.” ");
INSERT INTO ptu_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Anna mane untula' mesa pehapangam naua: “Deem mesa to makaka muampuam litä' si naongei kende' bu'dä' bua pengkähäna. ");
INSERT INTO ptu_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Iya mekutanam illaam penabanna naua: ‘Aka amom la kupogau' aka pa'de polem naongei inde bua pengkähäku?’ ");
INSERT INTO ptu_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Iya nauam: ‘O kuissammi. La kuhenggäi asam sule lokoku, anna kupake'de' polei kasallena, anna kupangngannai ingganna gandungku sola kulle senga'ku. ");
INSERT INTO ptu_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Mane la sipa'tula'ä' kaleku kuua: Kehongko'mä' kao! Kuampuam asammi ingganna mapianna anna moi la ma'taum-taum kupake tala puhai. La tä'mä' mengkähä, angga hamä' la mellube, mangngande mangngihu' anna umpalosso' inabangku.’ ");
INSERT INTO ptu_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Sapo' ma'kada Puang Allataala lako naua: ‘O to maho! La kuäläi siam penabammu inde bengi temo. Iya mennam la muampuanni ingganna indo kulle untombongam kalemu?’ ");
INSERT INTO ptu_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","La susim too ullambi'i lako to maelo' uhhempum kulle inde lino, ke tä'i uhhempum kulle di ada' dio olona Puang Allataala.” ");
INSERT INTO ptu_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Puhai ia too, ma'kadam Puang Yesus lako passikolanna naua: “Iam too anna kuuaammokoa': Daa ummalallanna' diona salu katuboammu, la muua: ‘Aka amo la diande.’ Anna tä' toi la malallangkoa' diona bätä puntimmu, la muua: ‘Aka amo la dipa'poheba.’ ");
INSERT INTO ptu_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Aka inde katuboam pahallu puha ia anna la kinande, anna inde bätä punti kalando puha ia anna la poheba. ");
INSERT INTO ptu_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Penabaam siaia' too indo kadoaja. Tä' deem mangngambo', tä' deem mepahe, tä' toi deem umpuängam loko battu haka talukum. Moinna anna susi, sapo' tontä liu duka' nabanneiam salu katuboanna Puang Allataala. Iya keangga' puha siangkoa' tiko anna la dassi-dassi! ");
INSERT INTO ptu_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Akam gunana la malallangkoa' diona kapahalluammu? Mennangka iko tau muita to malallam diona salu katuboanna la mala ullombunni sungnga'na moi podo la saidi'um? ");
INSERT INTO ptu_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Dadi maka' tä' muissanna' umpogau' indo kaha-kaha handam bahinni' ia too, iya akanna malallam dakoa' diona kaha-kaha senga'? ");
INSERT INTO ptu_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Penabaam siaia' too indo bunga-bunga lako kaliane. Tä' deem mengkähä, dapaka ia la umpapia poheba. Sapo' mentondom puha ia mapianna anna la pohebana tomahaja Salomo yolona, moinna anna tä'i deem pada sasugi'. ");
INSERT INTO ptu_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Indo duka' kuhha tubo temo lako bela' la bambanna siam ditibe tama api anna napomapi'dä'i Puang Allataala, damo ahanna' ia iko keangga' puha hakoa' tiko anna la indo kuhha. Kuhäm sugali'a' kamatappasammu! ");
INSERT INTO ptu_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Dadi daa ummalallanna' anna husa' diona la muandena anna la muihu'na. ");
INSERT INTO ptu_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Aka ingganna ia too napeä ia to tä' ungkaleso manappa Puang Allataala. Sapo' tä' iko la umpasusia', aka inna naissam loppo'um Ia Ambemu ingganna kapahalluammu. ");
INSERT INTO ptu_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Ia hia, paitoo'naia' illaam penabammu kapahentaanna Puang Allataala, iya la napasondoingkoa' too ingganna kapahalluammu. ");
INSERT INTO ptu_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","O inggannakoa' to kukambi' to saidi' hekengammu! Daa ummahea'a'! Aka situhu' pa'elo'na Ambemu puhangkoa' natamba' napopendadi umma'na illaam kapahentaanna. ");
INSERT INTO ptu_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Balu'i kullemu anna umbeennia' allinna lako to mase-mase. Papia kaleia' osse' la tää'na mala kadake, indo la umpa'pongngei kulle yabo suhuga. Kulle ia too tä' la mala pa'de aka tä' la mala naboko pa'boko anna tä' la naande bu'bu'. ");
INSERT INTO ptu_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Aka umba-umba naongei kullemu, la eta siam too duka' naongei pikkihammu.” ");
INSERT INTO ptu_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","36","Mane naua polei Puang Yesus: “La majaga liukoa' sihhapam to mengkähä muampai puäna la ma'pasule dio mai hame-hame pa'pakabengam. Indo to mengkähäna la makahappi liu pa'pohebana anna lekke' liu lampunna anna mala sulena too indo puäna unde'de' ba'ba, iya tappa natungka'i siaham. ");
INSERT INTO ptu_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Tä' deem pada sakehongko' lako indo to dilambi' mahassam mangngampa wattunna sule puäna. Kutulasangkoa' setonganna sulena too indo puäna tappa umpembeke'um sambu'na anna muuaanni indo to mengkähäna: ‘Okko'koa' aka la dipandekoa',’ mane natahiai. ");
INSERT INTO ptu_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Anna tä' deem pada sakehongko' indo to mengkähäna ke tontä liui mangngampa nalambi' puäna, moi anna tängä bengi haka nannahi haka mane sulei. ");
INSERT INTO ptu_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Penabaam siaia' too, maka' hapanna la naissam to ma'banua naua la tette' eta sule to maboko, mannassa anna tä'i la mamma' anna mala tä' tama banuanna indo to maboko. ");
INSERT INTO ptu_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Dadi iam too anna la pahallungkoa' duka' majaga liu, aka indo kasuleangku to disangai Änä' Mentolino tä' la umbai-baia'.” ");
INSERT INTO ptu_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Iya mekutanam Petrus lako Puang Yesus naua: “O Debata, anggangka kami' nahua itim pehapangam, iya ingganna haka hupatau?” ");
INSERT INTO ptu_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Natimba' Puang Yesus Debatanta naua: “To nahua inde pehapangam, indo to sihhapam to muäto' pengkähängam illaam banuanna puäna manuhu' anna keaka'. Iya naäkä'um puäna mendadi punggabana ingganna solana, nasuhum ia la si untabaam kinande solana ke lambi' oom wattunna. ");
INSERT INTO ptu_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Kehongko' anna maupa' lako indo to mengkähä ke tontä liui manontom umpalako manappa pengkähänganna nalambi' puäna ke ma'pasulem. ");
INSERT INTO ptu_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Setongam-tonganna, tä' mala tala naäkä' puäna sabua' ia too la nalima'iam ingganna kullena. ");
INSERT INTO ptu_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Sapo' maka' la naua illaam penabanna indo sabua': ‘Masäepi mane sulei puäku,’ lambi' umpongkoim solana muane anna baine, anna mangngande mangngihu'i anna si umpamäbo' kalena, ");
INSERT INTO ptu_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","iya pissananna sule säkä-säkä ham indo puäna illaam wattu tadibai-bai. Sulena, naala siaham indo sabua'na anna nadahhai napaambi' mate, mane napa'tibeanni tama ongeanna to tä' matappa'. ");
INSERT INTO ptu_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Lako sabua' to muissam pa'elo'na puäna, sapo' tä' taja anna tä' napalako indo pa'elo'na puäna, iya la ditembe' talukum. ");
INSERT INTO ptu_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Sapo' lako sabua' to tä' muissam pa'elo'na puäna anna umpalakoi pa'pogausam sala la napolalam la nalambi' pesämbä', iya la disämbä'i duka' sapo' tä' ia la dipekasallei. Aka lako to buda dibeem la buda siam tia duka' napebeem, anna to buda aka-aka dibehoam, la buda siam tia duka' dipemmitai lako.” ");
INSERT INTO ptu_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Mane naua polei: “Kao-kao suleä' umpellebasam api tama inde lino. Anna tä' deem pada sakupohäe kela lekke'um indo api! ");
INSERT INTO ptu_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Sapo' deempi kamapi'disam mabanda' la pahallu kuola. Lessu'pi kaha-kaha ia too mane tä'i masussa penabangku. ");
INSERT INTO ptu_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Ussanga haka' iko suleä' inde lino la umbaba kasiolaam? Tää'! Taia kasiolaam, sapo' kasipengkaam. ");
INSERT INTO ptu_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Napahandu' tentomai, la deem kasipengkaam illaam alla'na lima tau illaam mesa banua, aka tallu la untuhu'ä' anna dua tää', battu haka dua la untuhu'ä' anna tallu tää'. ");
INSERT INTO ptu_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Ambe la sipengka änä'na muane. Indo la sipengka änä'na baine. Anna pasanam baine la sipengka manintunna baine.” ");
INSERT INTO ptu_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Mane ma'kadai Puang Yesus lako tau buda naua: “Maka' muitanna' malillim kaliane illau' katampusam, iya tappa muissanna' muua: ‘La uham.’ Iya uham si'da-sia. ");
INSERT INTO ptu_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Anna maka' muita hibu' buttu dio mai tandai selatan, iya tappa muissanna' muua: ‘La kulla'.’ Iya kulla' si'da-sia. ");
INSERT INTO ptu_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","O inggammua' to ma'dua tambu' ma'tallu sumusu, akanna muissam leko'ia' usse'la tanda inde lino sola yabo langi', sapo' tä' leko' ia muissam umpekalembasam inde tanda dipadadi illaam alla'-alla'mua' tentomai?” ");
INSERT INTO ptu_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Akanna tä'ia' umpopa'tantu muua: ‘Indem lalam malolo?’ ");
INSERT INTO ptu_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Maka' hapanna deengkoa' la umbaba lako to mahhotto', iya peäia' lalanna anna sikapiaikoa' lako lalam. Aka maka' tä' umpateem, iya la nabehoko lako to mahhotto', mane napatahhu'ko indo to mahhotto' lako pulisi, anna natibeko tama tahungkum. ");
INSERT INTO ptu_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Setongam-tonganna tä' siako la mala dipassubum illaam mai tahungkum kela deempi tohho moi podo la himi'um indammu.” ");
INSERT INTO ptu_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Wattu eta too deem sanaka-naka tau dio heem untulasanni Puang Yesus indo kaheba diona sanaka-naka to Galilea napatei Pilatus wattunna mahassam untunu bua pemala'na längäm Puang Allataala. ");
INSERT INTO ptu_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Natimba' Puang Yesus naua: “Ussanga haka' iko indo to nalambi' katilakaam tä' nabai-bai anna matei, la kasalle puha ia dosana anna la dosana ingganna to Galilea senga'? ");
INSERT INTO ptu_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Tää'! Sapo' kutulasangkoa', maka' tä'koa' untihokongam gau' kadakemu, iya la ullambi'koa' duka' katilakaam tä' umbai-bai. ");
INSERT INTO ptu_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Mane deenni, ussanga haka' iko indo to sapulo kahua tau natappai banua maläkkä' dio Siloam, la kasalle puha ia kasalaanna anna la ingganna tau senga' yabo Yerusalem? ");
INSERT INTO ptu_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Tää'! Sapo' kutulasangkoa', maka' tä'koa' untihokongam gau' kadakemu, iya la ullambi'koa' duka' katilakaam tä' umbai-bai.” ");
INSERT INTO ptu_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Mane untula' polei mesa pehapangam Puang Yesus naua: “Deem mesa tau umpuängam satoo' ara tubo illaam bela' anggurna. Pissam wattu lao oom lako too'na indo ara napeä buana, sapo' tä' deem nalambi'. ");
INSERT INTO ptu_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Iya ma'kadam lako to si ungkähäi indo bela' anggurna naua: ‘Tallu taummi kuolaam umpeäi buana inde ara, sapo' tä' deem kulambi'. Lellemmi too, aka umpuhai bäbä lompona litä'!’ ");
INSERT INTO ptu_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Sapo' natimba' indo to mengkähäna naua: ‘O tuam, päbäipi yolo tubo illaam inde taum, anna kusändä'pi kukumbä lao pali' too'na mane kulompoi, ");
INSERT INTO ptu_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","umba-umba aka kembua taum pole. Anna maka' too tä' liu siam kembua, iya etapa pole' mane dilellenni.’” ");
INSERT INTO ptu_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Pissam wattu ma'pa'guhu oom Puang Yesus illaam mesa pa'sambajanganna to Yahudi illaam allo Katohhoam. ");
INSERT INTO ptu_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Wattu eta too deem mesa baine sapulo kahuam taunna napentamai setam, nasuhum masaki sampe bungku' anna tä'um mala malolo ke'de'. ");
INSERT INTO ptu_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Tappana naita Puang Yesus indo baine, natambaim anna nauaanni: “O indo', la dilappasammoko dio mai sakimmu.” ");
INSERT INTO ptu_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Mane naantii, iya tappa malolo siaham ke'de' indo baine, anna umpa'kasallei Puang Allataala. ");
INSERT INTO ptu_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Sapo' tappa keaha' indo to si muäto' pengkähängam illaam pa'sambajangam, aka umpabono' to masaki Puang Yesus illaam allo Katohhoam. Nasuhum ma'kada lako tau buda naua: “Deem annam allona diolaam mengkähä, dadi pise'ia' mesa allo ia too muolaam sule la dipabono'. Sapo' damom tia allo Katohhoam.” ");
INSERT INTO ptu_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Sapo' natimba' Puang Yesus naua: “O inggammua' to ma'dua tambu', tä' daka tia si ullappasam siangkoa' duka' sapimmu battu haka keledaimmu illaam mai balana anna laoia' umpaihu' illaam allo Katohhoam? ");
INSERT INTO ptu_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Dadi, tä' daka tia pahallu dilappasam duka' inde baine, mesa duka' peampoanna Abraham? Aka sapulo kahuam taunna napembalokko'i setam sihhapam nasäke', iya tä' daka tia mala la dilappasam duka' illaam allo Katohhoam?” ");
INSERT INTO ptu_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Ingganna to umpobali Puang Yesus sangngim ma'luttu' masihi', sapo' tilalla' asam ia tau buda aka ingganna indo kaha-kaha puha napogau' sangngim matande. ");
INSERT INTO ptu_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Iya nauam Puang Yesus: “Akam la dipasihhapangam kapahentaanna Puang Allataala? Anna aka la nasusiam? ");
INSERT INTO ptu_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Kapahentaanna Puang Allataala sihhapam mesa lise'na sesawi natanam tau lako bela'na. Lise' ia too tubo mendadi satoo' kaju anna naongei dassi täkena ma'sehä.” ");
INSERT INTO ptu_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Anna mane muala pole mesa pehapangam senga' naua: “Akapi la kupasihhapangam kapahentaanna Puang Allataala? ");
INSERT INTO ptu_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Kapahentaanna Puang Allataala mala duka' dipasihhapam bibi' hoti naala baine anna naboloianni appa' pulo lite' tehigu sampe nasamba asam lambi' sumbakka'.” ");
INSERT INTO ptu_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Illaam pa'laoanna Puang Yesus längäm Yerusalem, ullelei mobotto-bottoam ma'pa'guhu. ");
INSERT INTO ptu_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Iya deemmi mesa tau mekutana lako naua: “O Tuam, saidi' mandaka tau la dipasalama'?” Natimba' Puang Yesus naua: ");
INSERT INTO ptu_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Peäi lalanna anna malai muola indo ba'ba masiki', lalam kasalamasam! Aka kutulasangkoa' buda tau umpeäi lalanna la tama sapo' tä' mala. ");
INSERT INTO ptu_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Aka maka' untutu'im ba'bana indo to ma'banua, iya la dio mandangkoa' too sulibam ke'de'-ke'de' umpasindum ma'de'de' muua: ‘O Tuam, tungka'ikam kami'!’ Iya la natimba'i mandakoa' too indo to ma'banua naua: ‘Aka tä'koa' kuissam, buttu umbakoa' iko ngei?’ ");
INSERT INTO ptu_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Iya la untimba'inna' too muua: ‘Puhangkia' sola mangngande anna puhangko si ma'pa'guhu lako lalam illaam kotaki.’ ");
INSERT INTO ptu_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Sapo' la nauaam mandakoa': ‘Aka tä'koa' kuissam anna tä' toi kuissam buttu umbakoa' ngei. Päläikoa' lao inggannakoa' to si umpogau' kakadakeam!’ ");
INSERT INTO ptu_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Iya la muitangkoa' too indo nene to taponene susinna Abraham, Ishak anna Yakub sola ingganna nabi illaammi kapahentaanna Puang Allataala. Sapo' la sumahho lumoa'koa' iko sikekko' isimmu tamate tatubo aka la dipa'tibeangkoa' lao! ");
INSERT INTO ptu_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Anna buda tau taianna to Yahudi la sule illaam mai tandai mata allo, illau' mai katampusam, dio mai utara anna dio mai selatan, anna muokko'i ma'hame-hame illaam kapahentaanna Puang Allataala. ");
INSERT INTO ptu_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Anna setonganna la deem too ke dako'i to matande tentomai, la mendadi to madio, anna to madio tentomai la mendadi to matande.” ");
INSERT INTO ptu_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Wattu eta too sule sanaka-naka to illaam kakalebuanna Parisi anna ma'kadai lako Puang Yesus naua: “Le'ba'ko pellei inde ongeam aka maelo' tomahaja Herodes la napateiko.” ");
INSERT INTO ptu_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Natimba' Puang Yesus naua: “Laokoa' anna untulasanni itim to si mangkadakei muua: ‘Allo temo anna makale' la kupatahhu'pi pengkähängangku uhhambai setam anna umpabono' to masaki. Sapo' allo katallunnai too, kupasuppi'um pengkähängangku.’ ");
INSERT INTO ptu_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Moi anna maelo'mä' napatei, sapo' allo temo, makale', anna dua bengi tä' mala tala umpatahhu'ä' pa'laoangku längäm Yerusalem, aka anggam yabo sihatam naongei nabi dipatei. ");
INSERT INTO ptu_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","O inggannakoa' issinna kota Yerusalem! Palla' dia' iko penabammu umpatei buda nabi, anna ulleba'ia' batu sampe mate to nasua Puang Allataala umpellambi'ikoa'. Si kunaba-naba liu la kuhempungkoa' sihhapam änä' mäne' napakumbäi pani'na indona, sapo' mokakoa'. ");
INSERT INTO ptu_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Patananniia' talinga inde tula'ku anna umpaillaam penabai: la natampeammi Puang Allataala tadongkongammua'. Kutulasangkoa', mengkalao temo tä'mä' deem la muita pole sule lako wattunna suleä' sule lambi' muuaa': ‘Katambasam indo To sule illaam sanganna Debata!’” ");
INSERT INTO ptu_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Pissam wattu illaam allo Katohhoam le'ba' Puang Yesus lako banuanna mesa to kasalle illaam kakalebuanna Parisi la mangngande eta. Ingganna tau to dio heem eta too sangngim umpetua'-tua' liu pa'pogausanna Puang Yesus. ");
INSERT INTO ptu_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Wattu eta too sule mesa to kawwa umpellambi'i Puang Yesus anna ke'de'i dio olona. ");
INSERT INTO ptu_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Iya nalosa Puang Yesus tama penabanna indo to ullatta' Pepaondonganna Musa sola to illaam kakalebuanna Parisi naua: “Tä' tau si mala mengkähä illaam allo Katohhoam,” nasuhum ma'kada naua: “Situhu' peadasam, si mala haka dipabono' to masaki illaam allo Katohhoam, tä' daka?” ");
INSERT INTO ptu_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Sapo' tä' deem tau mentimba'. Iya nahaka'um Puang Yesus indo to masaki napabono', mane nasuai lao. ");
INSERT INTO ptu_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Puhai, ma'kadam lako indo to dio heem eta too naua: “Hapanna la deem mesa änä'mua' battu haka sapimmua' mehonno' dokko gahoä, sapo' illaam allo Katohhoam, iya tä' daka tia la umpemäläi dio mai?” ");
INSERT INTO ptu_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Sapo' moi mesa tadeenni naissam mentimba'. ");
INSERT INTO ptu_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Tappana naita Puang Yesus indo tosabe sangngim umpise'i ongeam handam dikasalleam la naongei muokko', iya untula'um mesa pehapangam lako indo tau naua: ");
INSERT INTO ptu_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Maka' deem tau untambaikoa' lako hame-hame pa'pakabengam, iya daa tappa muokko' dioa' ongeam handam dikasalleam. Aka deem manii ditambai to kasalle puha ia anna la ikoa'. ");
INSERT INTO ptu_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Indana nauaangko indo to untambaiko: ‘Läbänganni ongeam inde tau.’ Iya la masihi'ungko too aka tä' mala tala le'ba'ko muokko' lako ongeam handam madio. ");
INSERT INTO ptu_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Sapo' maka' deem untambaiko, lu lakoko ongeam handam madio, aka la napellambi'i hoko tia indo to ma'banua anna nauaangko: ‘O solaku, maiko anna muokko' illaangko pengnguluam.’ Dadi maka' susi ia too, iya dikasalleammoko naita solamu. ");
INSERT INTO ptu_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Aka menna-menna ussanga-sanga kalena la dipomahempo anna menna-menna umpopengkadio kalena la dipomatande.” ");
INSERT INTO ptu_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Puhai ia too, ma'kadam duka' Puang Yesus lako indo to untambai naua: “Maka' umpadeengko hame-hame susi iallo susi bengi, daa untambai sammuanemu battu solasubummu, battu kasahapuammu, battu sambanuammu to makaka. Aka la natambai siangko tia duka' ke ma'hame-hamei, iya ullambi' siam bala'na. ");
INSERT INTO ptu_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Sapo' maka' ma'hame-hameko, tambai to mase-mase, to kempo', to kungku, anna to buta. ");
INSERT INTO ptu_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Aka maka' umpateem, la natamba'ko Debata. Aka moi anna tä' deem aka-akanna la nabala'iangko, sapo' la ullambi' bala'na ke tibangommi sule dio mai kamateam to malolo gau'.” ");
INSERT INTO ptu_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Tappana uhhingngi tula'na Puang Yesus indo to napasola mangngande, iya ma'kadam mesa lako Puang Yesus naua: “Kehongko' anna maupa' to mangngande sola Puang Allataala ke illaammi kapahentaanna!” ");
INSERT INTO ptu_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Sapo' muala mesa pehapangam Puang Yesus napake untimba'i indo tau naua: “Deem mesa tau umpadeem pa'hame-hameam kasalle mane untambai tau buda. ");
INSERT INTO ptu_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Tappana la dipahandu', iya ussuam sabua'na lao untambai indo to puha diuaam anna nauaanni: ‘Maingkoa' aka toka asammi.’ ");
INSERT INTO ptu_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Sapo' sangngim taakanna indo to puha diuaam la ungkadioi heem indo hame-hame. Nauam ia indo to uhuna nalambi': ‘Issanganni, aka mane puhaä' mualli bela', iya pahallupi la lao kuita. Sa'baha'ko.’ ");
INSERT INTO ptu_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Deem muuai: ‘Issanganni, aka mane puhaä' mualli lima pasam sapim la dipopengkähä anna pahallu la laoä' temo kusändä'. Dadi sa'baha'ko.’ ");
INSERT INTO ptu_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Deem mesa muuai: ‘Issanganni, aka bakahuä' kebaine, dadi tä'ä' mala lao. Sa'baha'ko.’ ");
INSERT INTO ptu_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Iya ma'pasulem indo sabua' anna natulasanni puäna. Tappa keaha' indo to ma'banua anna muuaanni sabua'na: ‘Laoko sambai ingganna lalam kasalle anna lalam bahinni' illaam inde kota anna umpasola asanni sule ingganna to mase-mase, to kempo', to buta, anna to kungku.’ ");
INSERT INTO ptu_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Puhai napalako indo pahentana puäna, iya sulem indo sabua' natulasam puäna naua: ‘O tuam, moi anna puham kupalako indo pahentamu, sapo' deem liupi ongeam lo'bä.’ ");
INSERT INTO ptu_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Iya nauam indo puäna: ‘Laoko sambai ingganna lalam kasalle anna lalam bahinni' lako sulibanna kota anna ussuai tau sule inde banua anna mala ponno. ");
INSERT INTO ptu_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Aka kutulasangko, tä' deem moi podo la mesa indo to puha diuaam ingngena' la mala mangngande illaam pa'hame-hameangku.’” ");
INSERT INTO ptu_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Tappana buda oom tau ma'obim-obim untuhu' Puang Yesus illaam pa'laoanna, iya napenggihi'im anna ma'kadai naua: ");
INSERT INTO ptu_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Maka' deem tau maelo' untuhu'ä' sapo' umpakalando puha ia ambena, indona, bainena, änä'na, solasubunna, kalena anna la Kao, iya tä' mala la mendadi passikolangku. ");
INSERT INTO ptu_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Anna menna-menna tä' umpassam kaju sitambenna anna natuhu'ä', tau ia too tä' duka' mala mendadi passikolangku. ");
INSERT INTO ptu_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Hapanna deem mesa solamua' maelo' la umpake'de' banua maläkkä', iya tä' daka tia la muokko' yolo anna naissa'i la pada umba budanna doi' napake? Aka tä' manii sihua indo doi' sule lako puha indo banua. ");
INSERT INTO ptu_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Aka maka' napake'de' bäbä indo banua, sapo' tä' siam mala napatahhu', iya la napetaba-tabai ingganna to muitai ");
INSERT INTO ptu_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","naua: ‘Uuu! Napake'de' bäbä duka' sapo' tä' siam nabela napapuha!’ ");
INSERT INTO ptu_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Susi toi ke deenni mesa tomahaja la mueba tomahaja senga', tä' mala tala muokko' yolo anna napenabaanni naua: ‘La nabela haka inde sapulo sa'bu sohodadungku la mueba dua pulo sa'bu sohodadu?’ ");
INSERT INTO ptu_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Maka' tä' la nabela, iya la ussua sanaka-naka tau lao napellambi'i nakutanai naua: ‘La diaka susi sikapiai?’ baju anna muolapi lalam indo balinna. ");
INSERT INTO ptu_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Susi siangkoa' tiko duka' inggammua' to dio heem temo, ke tä'ia' umpellei ingganna aka-akammu, la tä'koa' mala mendadi passikolangku. ");
INSERT INTO ptu_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Indo sia abana mapia. Sapo' maka' matämmä'um, la malapaka tia dipamasim sule? ");
INSERT INTO ptu_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Tä'um tia deem gunana, aka tala malapi ia dipake lako bela', tala malapi dipolompo. Iya angga ham tia ditibe. Lako ingganna ma'hupatau pahallu la umpatanam talinganna umpalempe sulim patomalinna anna napaillaam penabai inde tula'ku!” ");
INSERT INTO ptu_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Pissam wattu buda tuam passima sola tau senga' ma'hempum la umpehingngii tula'na Puang Yesus. Ingganna tau ia too si nasangai to Yahudi to madosa. ");
INSERT INTO ptu_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Tappana naita sanaka-naka to illaam kakalebuanna Parisi anna to ullatta' Pepaondonganna Musa, iya sangngim ma'naum-naum naua: “Naaku siam ia duka' inde tau untahima to kadake gau' lambi' mangngande sola-sola!” ");
INSERT INTO ptu_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Iya untula'um mesa pehapangam Puang Yesus naua: ");
INSERT INTO ptu_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Hapanna deengkoa' mesa muampuam sahatu' domba. Pissananna bulim mesa, iya aka la umpogau'? Mannassa anna la umpellei dio pohiallasam indo dombamu kaseha pulo kaseha anna le'ba'i uhhuttu' indo to bulim sampe ullambi'. ");
INSERT INTO ptu_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Ullambi'i too, iya tä' mala tala tilalla'ko ussompoi ");
INSERT INTO ptu_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","ma'pasule lako banuammu. Iya untambaim ingganna solamu anna sambanuammu anna muuaanni: ‘La tilalla'kia' pada-pada aka indo dombaku pa'de sala, kulambi'um sule.’ ");
INSERT INTO ptu_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Kutulasangkoa', setonganna susim too duka' yabo suhuga, maka' deem mesa to madosa untihokongam gau' kadakena ditilalla'i puha ia anna la indo to kaseha pulo kaseha to malolo to tä'um manggi' untihokongam gau'na.” ");
INSERT INTO ptu_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Susi toi, hapanna deem mesa baine muampuam sapulo doi' peha', pissananna napa'deam mesa. Aka la napogau'? Mannassa anna la umpau'i lampu, mane ussapui banuanna umpeä indo doi'na sampe nalambi'. ");
INSERT INTO ptu_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Nalambi'i too, iya untambaim ingganna solana anna sambanuanna anna nauaanni: ‘La tilalla'kia' pada-pada aka indo doi'ku pa'de sala kulambi'um sule.’ ");
INSERT INTO ptu_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Kutulasangkoa', setonganna susim too duka' katilallasanna ingganna malaika'na Puang Allataala ke deenni mesa to madosa untihokongam gau' kadakena.” ");
INSERT INTO ptu_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Mane untula' polei mesa pehapangam Puang Yesus naua: “Deem mesa tau, dua änä'na bassim muane. ");
INSERT INTO ptu_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Ma'kadam indo änä' tämpä'na naua: ‘O ambe', beemmä' kao indo la ummanasannä'.’ Iya bassim nabeemmi tabana indo änä'na dua. ");
INSERT INTO ptu_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Sanaka amoi benginna lessu'na, iya nabalu'um ia indo änä' tämpä' mana'na, mane le'ba'i lako botto mambela ma'tobosa'-bosa' napuhai indo allinna, ia siam anna ia naua penabanna. ");
INSERT INTO ptu_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Tappana tappu' doi'na, siampu' duka' nahua kakobeam indo botto naongei lambi' ussi'dim kamasussaam. ");
INSERT INTO ptu_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Iya le'ba'um umpelau pengkähängam lako mesa tau illaam indo botto, lambi' nasua lako bela'na la ma'pande babi. ");
INSERT INTO ptu_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Tandana tadea' sugali' indo änä'-änä', iya mohäem la muande indo kinande babi. Moi anna susi, sapo' tä' deem mesa tau la umbeenni kinande. ");
INSERT INTO ptu_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Katampasanna kilala lambi' ma'kada naua: ‘Ingganna to mengkähäna ambeku bosa' kinande, anna etamä' kao inde la mate tadea'. ");
INSERT INTO ptu_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","La mengkalao siahamä' umpellambi'i ambeku anna kuuaanni: O Ambe', madosaä' längäm Puang Allataala anna madosaä' matim. ");
INSERT INTO ptu_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Tä'mä' sihatam la umpoänä'. Anggamä' kao la umpadadi to mosahomu.’ ");
INSERT INTO ptu_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Iya mengkalao siahanni le'ba' umpellambi'i ambena. Sikambelapi banua, iya naita ham ambena. Tä' deem pada sahäntä buana nasuhum kumondä siaham untammui änä'na. Sitammunna nakalapu'im anna naudunni. ");
INSERT INTO ptu_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Ma'kadam indo änä'na naua: ‘O Ambe', madosaä' längäm Puang Allataala anna madosaä' matim. Tä'mä' sihatam la umpoänä'.’ ");
INSERT INTO ptu_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Sapo' untambai siaham sabua'na indo ambena anna nauaanni: ‘Kandi'ia' muala poheba handam mapia anna umpabajui, umpasissinni anna umpasapatui. ");
INSERT INTO ptu_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Puhai too, laongkoa' umpise'i mesa sapim maloppä' ammu tunuia'. Aka la ma'hame-hamekia' ponno katilallasam. ");
INSERT INTO ptu_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Aka inde änä'ku sihhapam puham mate, sapo' mala tubo sule. Bulim sapo' mala dilambi' sule.’ Puhai napogau' asam ia too, iya ma'hame-hamem. ");
INSERT INTO ptu_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Mahassanni ma'hame-hame, iya sulem duka' indo änä' uluana dio mai bela'. Tappana dio ampe' banua, nahingngim moni poni-poniam anna to sumajo. ");
INSERT INTO ptu_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Iya untambaim mesa sabua'na anna nakutanai naua: ‘Aka hia dipogau' illaam banua?’ ");
INSERT INTO ptu_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Nauam indo sabua': ‘Ma'hame-hame tau aka malam sule sule adimmu. Mesa sapim maloppä' natunuam ambemu aka mala mammi ma'pasule masakke.’ ");
INSERT INTO ptu_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Tä' deem pada sakeaha' indo änä' ulua nasuhum moka tama banua. Iya messubummi ambena anna nase'de'i anna mala naaku tama banua. ");
INSERT INTO ptu_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Sapo' natimba'i mandi indo änä'na naua: ‘Ma'taum-taummä' umpengkähä kahhasangko anna tä' toi deem kubali-baliko. Iya tuli tadeempä' kao umbeem moi mesam beke la kupake ma'hame-hame sola solaku. ");
INSERT INTO ptu_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Anna indo leko'i änä'mu to puha untallangam kullemu si nabeem baine passunda' mane ma'pasulei, iya untunuam ia sapim maloppä'!’ ");
INSERT INTO ptu_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Iya nauam ambena: ‘O änä'ku, sola liungki' kita. Ingganna indo kuampuam, iko asam muampuanni. ");
INSERT INTO ptu_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Dadi sihatam di tia ma'hame-hamekia' anna tilalla' aka sihhapam puham mate adimmu, sapo' mala tubo sule. Bulim sapo' mala mammi dilambi' sule.’” ");
INSERT INTO ptu_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Mane untula' oi mesa pehapangam Puang Yesus lako passikolanna naua: “Deem mesa to makaka umpopengkähä mesa tau si muannanni doi'na anna naätosam kullena. Sapo' deem sule untulasanni naua: ‘Indo to muannaangko doi'mu si beba' bäbä napalusau' napaludekke indo doi'mu anna kullemu.’ ");
INSERT INTO ptu_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Iya untambaim indo to si muannanni doi'na anna nauaanni: ‘Nalambi'ä' kaheba diona pa'palakoammu, akanna ma'pateengko? Dadi temo la untulisam asannä' indo pa'palakoammu muäto' kulleku. Aka tä'ungko la kupopengkähä.’ ");
INSERT INTO ptu_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Iya ma'pikki'um indo to si muannanni doi'na naua: ‘Aka la kupogau' temo? Aka tä'mä' la napopengkähä punggabaku. La ma'bingkunnä' takubela, la kapelau-lauä' masihi'ä'. ");
INSERT INTO ptu_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","O, kuissammi aka la pahallu kupogau' yolo mane dipassubunnä' illaam mai pengkähängangku. La kupeäpi yolo buda sola anna mala buda si kuongei banuanna.’ ");
INSERT INTO ptu_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Iya untambai asammi ingganna tau to ma'indam lako indo punggabana. Uhuna sule, nakutanai naua: ‘Sanaka iko indammu lako punggabaku?’ ");
INSERT INTO ptu_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Iya naua: ‘Sahatu' busso minnä' zaitun.’ Iya nauaammi: ‘Indem suha' indammu, okko'ko anna ungkandii untuli' lima pulo busso.’ ");
INSERT INTO ptu_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Mane ma'kada polei lako indo kaduanna naua: ‘Anna iko, sanaka iko indammu?’ Natimba' naua: ‘Sasa'bu kahum gandum.’ Iya nauaammi: ‘Indem suha' indammu, tuli'i kahua hatu' kahum.’ ");
INSERT INTO ptu_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Nasuhum napekeakasam ohi punggabana indo to si muannanni doi'na, aka moi anna tä' malolo pa'palakoanna sapo' keakkalam ungkuhänniam indanna to ma'indam anna mala napohäe. Kutulasangkoa' inde pehapangam, aka ingganna to tä' matappa' illaam inde lino keaka' puha ia lako padanna anna la to matappa'. ");
INSERT INTO ptu_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Iam too anna kuuaammokoa': Pakegunaia' pakkulleam di lino anna mala deenna' solamu. Aka ke tä'um keguna indo kulle illaam inde lino, iya la natahima manappakoa' solamu illaam indo ongeam la da'da' sule lako salako-lakona. ");
INSERT INTO ptu_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Aka menna-menna mala dikatappa'i muuhu' kaha-kaha bahinni', tau ia too la mala duka' dikatappa'i muuhu' kaha-kaha kasalle. Sapo' menna-menna tä' malolo muuhu' kaha-kaha bahinni', tau ia too tä' duka' la malolo muuhu' kaha-kaha kasalle. ");
INSERT INTO ptu_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Dadi, maka' tä'koa' mala dikatappa'i muuhu' pakkulleam di lino, iya mennam la ungkatappa'ikoa' la muuhu' kulle di ada'? ");
INSERT INTO ptu_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Anna maka' tä'koa' mala dikatappa'i muuhu' kullena tau senga', iya mennam iko la umbeengkoa' kulle la umpokulle? ");
INSERT INTO ptu_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Tä' deem mesa sabua' la nabela umpengkähängam dua puä. Aka la natuhu'i manappam too mesa, anna la napaiboko'na bäbä mesa. Battu diua la napakalando puha ia mesa anna tä' bäbä la napehingngii mesa. La susingkoa' too duka', tä' siaa' la umbela umpalulängäm penabammu Puang Allataala ke anggakoa' umbumbu' kulle di lino.” ");
INSERT INTO ptu_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Ingganna indo tula'na Puang Yesus nahingngi asam to illaam kakalebuanna Parisi, sapo' napetabai aka sangngim anggam lu lako doi' penabanna. ");
INSERT INTO ptu_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Sapo' nauaam Puang Yesus: “Ikonna' too si umpomapia lelem gau'mu ke naitakoa' tau senga'. Sapo' nalosa Puang Allataala tama penabammua'. Anna indo si napuji hupatau, nakahidi' Ia Puang Allataala. ");
INSERT INTO ptu_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Issinna suha' Pepaondonganna Musa anna suha'na ingganna nabi, ia too dipehhondoi sule lako wattunna ma'pa'guhu Yohanes to si mantedo'. Iya napahandu' etam too Kaheba Katilallasam diona kapahentaanna Puang Allataala dipa'pakahebaam liu. Iya budam tau ma'bumbu' anna mala mendadi umma' illaam kapahentaanna. ");
INSERT INTO ptu_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Sapo' madomi' leko' ia langi' sola lino pa'de, anna la dikuhänni moi podo la satiti'um pahentana Puang Allataala. ");
INSERT INTO ptu_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Menna-menna untibe bainena anna laoi kebaine pole, tau ia too ullullu' pa'bannetauam. Anna menna-menna umpobaine baine to natibe muanena, tau ia too ullullu' duka' pa'bannetauam.” ");
INSERT INTO ptu_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Puhai ia too, ma'kada pole oom Puang Yesus naua: “Deem mesa to makaka umpa'poheba liu poheba masulli' allinna anna katuboanna allo-allo tä'um deem nakasepa-sepai. ");
INSERT INTO ptu_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Dio indo ba'ba balana, si dipadio mesa to mase-mase isanga Lazarus, kämbä asam kalena. ");
INSERT INTO ptu_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Anna tandana tadea' sugali' indo Lazarus, iya mohäem la muande indo kinande tikadanna indo to makaka. Tä' anggam ia, sapo' nalebopi asu nalepa'i indo kämbäna. ");
INSERT INTO ptu_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Pissananna mate indo to mase-mase, iya nababam malaika' längäm ongeam matande dio ampe'na Abraham yabo suhuga. Tä' masäe, matem duka' indo to makaka lambi' dilamum. ");
INSERT INTO ptu_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Anna tä' deem pada samadahha illaam lembä bolom indo to makaka. Pissananna mentongam längäm, iya muita mambelam Abraham muokko' sitehe Lazarus. ");
INSERT INTO ptu_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Iya kaoli-olim indo to makaka naua: ‘O ambeku Abraham, kamaseiä', suai Lazarus untu'do uwai anna maii natu'doannä' lilaku, aka tä' deem pada samadahhaä' illaam api ma'nala-nala!’ ");
INSERT INTO ptu_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Sapo' natimba'i Abraham naua: ‘O änä'ku, pengkilalai indo anna tubopoko illaam lino tä'um deem ungkasepa-sepai. Sapo' inde ia Lazarus anggam ia kamasussaam nasi'dim. Temo ussi'dimmi ia kamasannangam, sapo' iko-iko ussi'dingko kamadahhaam. ");
INSERT INTO ptu_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Anna illaam alla'taa' deem lembä mandalam mualla'ikia', nasuhum to maelo' la lambam matim tä' mala. Susi toi duka' to maelo' la lambam mai, tä' duka' mala.’ ");
INSERT INTO ptu_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Puhai ia too, ma'kada pole oo indo to makaka mengkahumase-mase naua: ‘O ambe', maka' susi kupelau kela mala anna ussuaannä' Lazarus lao lako banuanna ambeku. ");
INSERT INTO ptu_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Aka deempi lima solasubungku la napakilalaannä' indana naola pole oi duka' lalangku, nasuhum la tinanda tama inde ongeam kamadahhaam.’ ");
INSERT INTO ptu_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Sapo' natimba' Abraham naua: ‘Kusanga indo solasubummu muampuam duka' suha' Pepaondonganna Musa anna suha'na ingganna nabi. La natuhu' di tia duka' issinna indo tisuha' illaam.’ ");
INSERT INTO ptu_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Sapo' natimba' indo to makaka naua: ‘O ambeku Abraham, tää'. Aka tä'pi la ganna' ke anggam ia nabata, sapo' tappa la untihokongam siaham ia gau' kadakena indo solasubungku ke deenni to puham mate tubo sule lao umpakilalai.’ ");
INSERT INTO ptu_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Sapo' naua Abraham: ‘Maka' tä' untuhu'i indo Pepaondonganna Musa anna suha'na ingganna nabi, moi la to mate tubo sule lao umpakilalai, tala nakannanganni.’” ");
INSERT INTO ptu_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Ma'kadam Puang Yesus lako ingganna passikolanna naua: “Abana inna la deem kaha-kaha napolalam metobä tau tama dosa, sapo' tilaka lako to umbabai solana umpogau' dosa. ");
INSERT INTO ptu_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Aha leko'um ia dipatoke'i batu peepe' bahokona anna dipa'tumbusanni tama le'bo' anna la umpakendesam dosa inde mai to tadihingngiam. ");
INSERT INTO ptu_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Dadi la unjagai manappaa'! Maka' umpogau' dosa solasubummu, pakilalai. Anna maka' untihokongammi gau'na, ampunnii. ");
INSERT INTO ptu_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Maka' deem solasubummu umpogau' kasalaam lako kalemu pempitu sangngallo, anna pempitu siam duka' sule napellambi'iko naua: ‘Ampunniä'’, iya pahallu la muampunni.” ");
INSERT INTO ptu_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Iya sangngim ma'kadam indo suhona lako Puang Yesus Debatanta naua: “Pakatotosangkam kamatappasangki!” ");
INSERT INTO ptu_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Natimba' naua: “Maka' la deenna' kamatappasammu moi podo padam i'di', iya malanna' la muuaam inde kaju ara: ‘Tihebu'ko ammu pentieli' titanam illaam tängä le'bo'!’ Iya tä' mala tala natuhu'i tula'mu.” ");
INSERT INTO ptu_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Mane naua polei Puang Yesus: “Hapanna deengkoa' mesa muampuam sabua' lao massalaga battu haka lao nakambisangko dombamu. Pissananna ma'pasule lako banua, aka la muuaam? La muuaam daka: ‘Maiko ammu pasihha'i mangngande?’ ");
INSERT INTO ptu_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Tää', sapo' la muuaam mandi: ‘Patokaannä' kinandeku! Pembeke'ko sambu'mu anna untahiaiä'. Puhapä' kao mane mangngandeko iko.’ ");
INSERT INTO ptu_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Maka' puha pengkähänganna indo sabua', tä'um manggi' la dipuji aka anggam tia untuhu'i indo pahentamu. ");
INSERT INTO ptu_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Susingkoa' too duka' ke umpeloloikoa' pengkähängammu indo puha dibeengkoa'. La ma'kadakoa' muua: ‘Kami'-kami' anggangkam sabua' bäbä. Anggangkam umpalako indo pengkähängam puha dibeengkam.’” ");
INSERT INTO ptu_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Illaam pa'laoanna Puang Yesus längäm Yerusalem muolai katonanna lembäna Samaria anna lembäna Galilea. ");
INSERT INTO ptu_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Tappana mentama mesa tondä', natammuim sapulo to dolengam. Ke'de' mambela ");
INSERT INTO ptu_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","napasindum sikatamba naua: “O Puang Yesus, Tuangguhu! Kamaseikam kami'!” ");
INSERT INTO ptu_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Tappana naita Puang Yesus, iya ma'kadam naua: “Laongkoa' pa'paitaam kalemu lako sando.” Iya mahassanni mellao, tappa masapu eta siaham indo sakinna. ");
INSERT INTO ptu_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Tappana naita indo mesa to masaki bono'um sakinna, iya ma'pasulem katamba-tamba umpuji Puang Allataala. ");
INSERT INTO ptu_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Ullambi'i Puang Yesus, iya ma'balinguntu'um dio olona anna nauai: “Kuhhu' sumanga'.” Indo tau ia too to Samaria. ");
INSERT INTO ptu_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Ma'kadam Puang Yesus naua: “Tä' daka tia sapulo tau dipabono'? Umba hi kaseha? ");
INSERT INTO ptu_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Akanna angga hi mesa tau ma'pasule umpa'kasallei Puang Allataala? Taianna polepi to Yahudi!” ");
INSERT INTO ptu_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Mane ma'kadai Puang Yesus lako indo tau naua: “Ke'de'ko ammu le'ba'. Bono'ungko aka ungkatappa'iä'.” ");
INSERT INTO ptu_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Sanaka-naka to illaam kakalebuanna Parisi mekutana lako Puang Yesus naua: “Pihampi la umpalako kapahentaanna Puang Allataala?” Natimba' naua: “Tä' deem tanda la diita ke umpalakom kapahentaanna Puang Allataala. ");
INSERT INTO ptu_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Dadi tä' deem tau la ma'kada naua: ‘Maiko petua'i, indennä!’ battu haka la naua: ‘Dipennä!’ Aka ma'pahentam tia Puang Allataala illaam alla'-alla'mua'.” ");
INSERT INTO ptu_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Puhai, ma'kadam Puang Yesus lako passikolanna naua: “Dako' la deem wattunna mohäekoa' la muita Änä' Mentolino moi podo sangngallom, sapo' tä' mala la muitaa'. ");
INSERT INTO ptu_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Dako'i too nauaammokoa' tau: ‘Petua'i, indennä!’ La deem toi muuai: ‘Dionnä!’ Sapo' daa umpehingngii! ");
INSERT INTO ptu_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Aka kasuleangku to disangai Änä' Mentolino la naissam asam ingganna hupatau aka la sihhapam liu tikiäna kila' yabo langi' mengkalao illaam mata allo sule sau' katampusam pangkähhäna. ");
INSERT INTO ptu_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Sapo' la kusi'dim yolo ma'hupa-hupa pandahhaam anna la natumpu pala'ä' to tubo lapi' temo. ");
INSERT INTO ptu_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Aka umba susi dadi indo anna wattunnai Nuh, la susim too duka' wattunna kasuleangku to disangai Änä' Mentolino. ");
INSERT INTO ptu_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Wattu eta too ingganna hupatau illaam inde lino ma'masannam-sannam mangngande mangngihu', siala-ala, anna ma'pasiala sule lako wattunna mentama kappala' Nuh. Iya pissananna ham bussu uwai untallanni issinna lino. ");
INSERT INTO ptu_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Susi siam too duka' indo anna wattunnai Lot, eta too ingganna hupatau anggam mangngande, mangngihu', mangngalli, ma'balu', mantanam, anna ma'pake'de' banua. ");
INSERT INTO ptu_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Sapo' messubunna Lot illaam mai kota Sodom, iya tuhummi api sola susi dama' ditunu yabo mai langi' muä'bäi indo tau buda. ");
INSERT INTO ptu_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","La susim too duka' kasuleangku to si disangai Änä' Mentolino. ");
INSERT INTO ptu_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Allo eta too to dio sulibam banua tä'um la tama banua muala pahuhunna. Susi duka' to dio bela' tä'um la ma'pasule lako banuanna. ");
INSERT INTO ptu_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Pengkilalaia' indo puha dadi lako bainena Lot! ");
INSERT INTO ptu_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Menna-menna anggam katuboam bätä puntinna nabumbu', tau ia too tä' ia la ullambi' katuboam sule lako salako-lakona. Sapo' menna-menna ahu' umpellei katuboam bätä puntinna, la da'da' liu ia katuboanna. ");
INSERT INTO ptu_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Katappa'ia', illaam indo bengi kasuleangku maka' deem dua tau mamma' yabo petindoam, iya mesa la dipasola lao anna mesa la dipatohho. ");
INSERT INTO ptu_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Susi toi ke deenni dua baine mahassam manggilim, mesa la dipasola lao anna mesa la dipatohho. ");
INSERT INTO ptu_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","La susi siam too duka' ke deenni dua tau mahassam mengkähä dio bela'na, iya mesa la dipasola lao anna mesa la dipatohho.” ");
INSERT INTO ptu_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Iya mekutanam indo passikolanna Puang Yesus naua: “O Debata, umba ngei la dadi itim?” Natimba' Puang Yesus naua: “Umba-umba naongei bakke, etam too duka' naongei dassi peande bakke ma'tombom.” ");
INSERT INTO ptu_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Puhai ia too, muala oom mesa pehapangam Puang Yesus umpa'guhu passikolanna naua: “La bassa' liukoa' ma'sambajam, anna tä'koa' la kattu hannu. ");
INSERT INTO ptu_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Aka hapanna illaam mesa kota deem mesa to mahhotto' tä' ungkahea' Puang Allataala anna umpa'pa'dei hupatau. ");
INSERT INTO ptu_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Illaam indo kota deem mesa to balu-balu baine pembudam sule umpellambi'i indo to mahhotto' nauaam: ‘Kela mala umpopataloä' lako indo balingku.’ ");
INSERT INTO ptu_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Padam säena naolaam indo baine napelau anna malai napamoloi, sapo' moka liu indo to mahhotto'. Sapo' katampasanna napikki' naua: ‘Moi anna tä'ä' ungkahea' Puang Allataala anna umpa'pa'deiä' hupatau, ");
INSERT INTO ptu_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","sapo' naganggu liuä' indo to balu-balu baine, iya dotam kupopatalo. Aka maka' tää', la sule liuä' nahahu'.’” ");
INSERT INTO ptu_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Puhai umpalao indo pehapangam, iya nauam Puang Yesus Debatanta: “Paillaam penaba manappaia' tula'na indo to mahhotto' tä' malolo! ");
INSERT INTO ptu_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Tä' daka tia duka' Puang Allataala la umpopatalo hupatau to napilei to tontä liu melau allo anna bengi? La napa'lembe-lembei haka tia umpamoloi tau ia too? ");
INSERT INTO ptu_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Kutulasangkoa', la masimpammi napopatalo tau ia too. Sapo' maka' sulemä' to disangai Änä' Mentolino, la deempaka to ungkatappa'iä' kulambi' illaam inde lino?” ");
INSERT INTO ptu_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Napahuai duka' Puang Yesus pehapangam lako to ussanga kalena mapia gau' anna umpa'pa'de solana ");
INSERT INTO ptu_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","naua: “Deem dua tau le'ba' lako Banua Debata la ma'sambajam. Mesa to illaam kakalebuanna Parisi anna mesa tuam passima. ");
INSERT INTO ptu_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Indo to illaam Parisi ke'de' anna ma'sambajanni illaam penabanna naua: ‘O Puang Allataala, ma'kuhhu' sumanga'ä' matim aka tä' kao susiä' tau senga' umpogau' ma'hupa-hupa kakadakeam susinna: muakkalanni aka-akanna solana anna malai naala, ma'gau' sengko', anna ullullu' pa'bannetauam. Anna tä' tooä' susi inde tuam passima. ");
INSERT INTO ptu_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Anna puasaä' penduam saminggu anna kubaba bahe sapulona pallolongangku kupehumalasam dio olomu.’ ");
INSERT INTO ptu_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Sapo' indo ia tuam passima ke'de' mambela tukku-tukku napasindum umbusu'-busu' buana aka untihokongam gau' kadakena naua: ‘O Puang Allataala, kamaseiä' aka mesaä' to madosa.’” ");
INSERT INTO ptu_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Puhai umpalao indo pehapangam, iya nauam Puang Yesus: “Kutulasangkoa' tappana ma'pasule lako banuanna indo to illaam Parisi, tä' napomalolo Puang Allataala. Sapo' indo tuam passima, napomalolo ia Puang Allataala. Aka menna-menna ussanga-sanga kalena la napomadio Puang Allataala, sapo' menna-menna umpopengkadio kalena la napomatande ia Puang Allataala.” ");
INSERT INTO ptu_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Pissam wattu sule sanaka-naka tau umbaba änä'-änä' bahinni'na lako Puang Yesus anna mala natamba'. Sapo' tappana naita passikolanna, iya ungkeaha'im indo tau. ");
INSERT INTO ptu_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Sapo' natambai Puang Yesus indo änä'-änä' mane ma'kadai lako passikolanna naua: “Päbäi mammi napellambi'iä' itim matim änä'-änä'. Daa ullabai, aka tau susim too itim matim la mendadi umma'na Puang Allataala illaam kapahentaanna. ");
INSERT INTO ptu_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Aka kutulasangkoa', setongam-tonganna, menna-menna tä' susi änä'-änä' untahima kapahentaanna Puang Allataala, tau ia too tä' la mendadi umma' petauanna.” ");
INSERT INTO ptu_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Mesa pepungngu'na to Yahudi mekutana lako Puang Yesus naua: “O Tuangguhu to mapia gau', aka la kupogau' anna malaä' ullambi' katuboam sule lako salako-lakona?” ");
INSERT INTO ptu_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Natimba' naua: “Akanna muuaannä' to mapia gau'? Tä' deem mesa tau la mapia gau' sulibanna Puang Allataala. ");
INSERT INTO ptu_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Mannassa muissammi ingganna pahentana Puang Allataala naua: ‘Daa ullullu' pa'bannetauam, daa umpapateam, daa umpaboko, daa ussa'bi tatappa' diona padammu hupatau, pa'kasalleiko indomu sola ambemu.’” ");
INSERT INTO ptu_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Iya natimba'um indo tau naua: “Kutuhu'i asammi pahenta ia too mengkalao bahinni'ku.” ");
INSERT INTO ptu_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Tappana nahingngi Puang Yesus tula'na, iya nauaammi: “Deempi mesa tä' umpogau'. Balu' asanni ingganna kullemu anna untabaanni to mase-mase allinna. Aka maka' umpateem, iya la muampuammoko too kulle yabo suhuga. Puhai too, iya sulengko pole' untuhu'ä'.” ");
INSERT INTO ptu_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Sapo' nahingnginna indo tula' ia too, tä' deem pada samasussa penabanna aka mesa to sugi'. ");
INSERT INTO ptu_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Naitanna Puang Yesus tä' deem pada samasussa penabanna, iya ma'kadam naua: “Tä' deem pada samapahhi' to buda kullena la mendadi umma'na Puang Allataala illaam kapahentaanna. ");
INSERT INTO ptu_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Aka madomi' leko'um ia mesa unta muola tama tottä'na dahum, anna la mesa to makaka la mentama kapahentaanna Puang Allataala.” ");
INSERT INTO ptu_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Ingganna tau to uhhingngi tula'na Puang Yesus sangngim ma'kada naua: “Maka' susi, iya menna bäbä hi umbai' la mala dipasalama'?” ");
INSERT INTO ptu_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Iya natimba'um Puang Yesus naua: “Nakapusa'i ia hupatau diona to la mala dipasalama', sapo' tä' Ia nakapusa'i Puang Allataala.” ");
INSERT INTO ptu_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Iya ma'kadam Petrus naua: “Kitampeammi kami' dapo'ki aka kituhu'ko!” ");
INSERT INTO ptu_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Natimba' Puang Yesus naua: “Kutulasangkoa', setongam-tonganna menna-menna untampeam banuanna, battu haka bainena, solasubunna haka, tomatuanna haka, battu haka änä'na aka manuhu' lako kapahentaanna Puang Allataala, ");
INSERT INTO ptu_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","tau ia too la dibala'iam tiluppi'-luppi' illaam inde lino. Anna illaam wattu la sule la untahima katuboam sule lako salako-lakona.” ");
INSERT INTO ptu_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Iya untambaim indo sapulo dua passikolanna Puang Yesus anna ia mandi napa'tula'i naua: “Inde tentomai la längämmakia' Yerusalem, anna ingganna indo to puha nasuha' ingganna nabi diona Kao to disangai Änä' Mentolino tä' mala tala sule lako. ");
INSERT INTO ptu_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Aka la nabehoä' lako to tamuissam Puang Allataala anna la natelleä' anna natunai. La nasitikkudu-kuduiä' anna nadahha lambi' napateiä'. ");
INSERT INTO ptu_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Sapo' illaam allo katallunna la dipatibangonnä' sule.” ");
INSERT INTO ptu_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Tula' ia too tä' natama akkalanna passikolanna aka tibunipi kalembasanna, nasuhum tä' naissam tungka batunna indo tula'na. ");
INSERT INTO ptu_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Tappana la landa' kale Puang Yesus lako kota Yerikho, iya deemmi mesa to buta muokko' dio bihim lalam kapelau-lau. ");
INSERT INTO ptu_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Tappana uhhingngi indo tau buda liu dio ampe'na, iya mekutanam naua: “Aka hia anna budai tau?” ");
INSERT INTO ptu_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Natimba'im indo tau buda naua: “Liu Puang Yesus indo to Nazaret.” ");
INSERT INTO ptu_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Iya metambam indo to buta naua: “O Yesus, peampoanna tomahaja Daud, kamaseiä' kao!” ");
INSERT INTO ptu_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Sapo' nakuapai hi indo to mendiolo naua: “Pengkamma'ko!” Sapo' tuttuam napekasallei mandi metamba naua: “O peampoanna Daud, kamaseiä' kao!” ");
INSERT INTO ptu_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Tappa tohho siaham Puang Yesus anna ussuai tau lao untette indo to buta napasola sule. Tappana sule, nakutanaim ");
INSERT INTO ptu_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","naua: “Aka umpohäe la kupogausangko?” Natimba'um naua: “O Tuam, maelo' punalaä' duka' la paita.” ");
INSERT INTO ptu_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Iya ma'kadam Puang Yesus naua: “Paitangko! Bono'ungko aka ungkatappa'iä'.” ");
INSERT INTO ptu_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Iya paita siahanni lambi' untuhu' Puang Yesus napasindum umpa'kasallei Puang Allataala. Tappana naita tau buda bono'um indo to buta, sangngim umpa'kasallei duka' Puang Allataala. ");
INSERT INTO ptu_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Mentamai kota Yerikho Puang Yesus, iya mellao tahhu'um muola indo kota ia too. ");
INSERT INTO ptu_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Illaam indo kota deem mesa punggabana tuam passima tä' deem pada satomakaka isanga Zakheus. ");
INSERT INTO ptu_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Napemulu duka' la muita Puang Yesus, sapo' tä' mala aka patalo budanna tau, la'bi-la'binna mesa to mahempo. ");
INSERT INTO ptu_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Iya kumondäm umpendioloi tau buda anna unteka'i mesa kaju ara aka naua: “Anna malaä' duka' muita Puang Yesus ke lium.” ");
INSERT INTO ptu_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Tappana nalambi' Puang Yesus indo kaju ara, iya natongaim längäm anna napa'kadai naua: “O Zakheus, pasihha'i tuhum aka la pahalluä' tohho dio banuammu temo.” ");
INSERT INTO ptu_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Nakandi'i siaham duka' tuhum Zakheus anna untahimai Puang Yesus illaam banuanna sola naponnoi katilallasam. ");
INSERT INTO ptu_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Ingganna tau to muitai ma'naum-naum lambi' ma'kada naua: “Uuu, akanna naakui tohho dio banuanna to madosa?” ");
INSERT INTO ptu_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Iya ke'de'um Zakheus anna umpa'tula'i Puang Yesus naua: “O Tuam, bahe duanna kulleku la kupa'kamaseam lako to mase-mase. Anna lako to puha kupalängängam bäbä simanna, la kupasuleam pengngappa' tiluppi'.” ");
INSERT INTO ptu_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Natimba' Puang Yesus naua: “Allo temo nalambi'um kasalamasam issinna inde banua. Aka iko duka' ullombungangko kamatappasanna Abraham. ");
INSERT INTO ptu_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Aka Kao to disangai Änä' Mentolino suleä' umpeä anna la umpasalama' ingganna to bulim.” ");
INSERT INTO ptu_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Mahassam liupi indo tau buda umpehingngii tula'na Puang Yesus, iya umpalao oom pehapangam diona kapahentaanna Puang Allataala. Aka wattu eta too diom sikahuku' Yerusalem Puang Yesus anna nasanga tau kapahentaanna Puang Allataala la bale' napalakom illaam inde lino susi tomahaja lino ma'pahenta. ");
INSERT INTO ptu_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Iya ma'kadam Puang Yesus naua: “Deem mesa änä' puä la le'ba' lako botto mambela dilanti' mendadi tomahaja mane ma'pasulei. ");
INSERT INTO ptu_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","La mengkalaoi, untambaim sapulo sabua'na anna natabai sanda si mesa doi' bulabam anna nauaanni: ‘Popembea'ia' inde doi' sule lako ma'pasuleä'.’ ");
INSERT INTO ptu_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Sapo' buda tau illaam indo botto ungkabassii la napotomahaja. Iya, lessu'na indo änä' puä, ussuam tau lao lako indo to la naongei dilanti' nauaam: ‘Inde tau tä' kipohäe la kipotomahaja.’ ");
INSERT INTO ptu_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Sapo' dilanti' siam mendadi tomahaja mane ma'pasulei lako bottona. Sulei, untambaim indo sapulo sabua'na aka la sule natulasam sanaka amom pallolonganna. ");
INSERT INTO ptu_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Iya sulem mesa indo sabua'na anna ma'kadai naua: ‘O tuam, indo mesa doi' bulabam umbeennä', iya kupopembea'um lambi' mala tiluppi' sapulo.’ ");
INSERT INTO ptu_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Natimba' indo puäna naua: ‘Mapia! Abana si'da sabua' mapiako. Malako dikatappa'i umpalako kaha-kaha bahinni' nasuhum temo la kuäkä'ko la umpahenta sapulo kota.’ ");
INSERT INTO ptu_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Puhai, iya sulem duka' indo sabua' kaduanna anna ma'kadai naua: ‘O tuam, indo mesa doi' bulabam umbeennä', iya kupopembea'um lambi' mala tiluppi' lima.’ ");
INSERT INTO ptu_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Ma'kada oom indo puäna naua: ‘La kuäkä'ko la umpahenta lima kota.’ ");
INSERT INTO ptu_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Puhai, sule oom mesa indo sabua'na anna ma'kadai naua: ‘Indo doi' umbeennä', indem. Kuanna kuputu' sampim. ");
INSERT INTO ptu_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Aka kukahea'ko anu' kuissam kuua mesako to makahha'. Si muala bäbä indo taiko muampuanni anna si umpuppu' bäbäko tanangam moi anna taiko untananni.’ ");
INSERT INTO ptu_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Iya nauam indo puäna: ‘Iko mesako sabua' kadake gau'! Dadi indo siam tula'mu la umpopetahungkungko. Aka muissammi le' muua kao mesaä' to makahha' si muala bäbää' indo takao muampuanni anna si umpuppu' bäbää' tanangam moi anna takao untananni. ");
INSERT INTO ptu_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Iya akanna tä'i umbeem inde doi' lako to si umpakeänä' doi', anna mala kutahima sitonda änä'na ke suleä'?’ ");
INSERT INTO ptu_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Mane ma'kadai indo tomahaja lako indo tau sikadehe nauaam: ‘Alai itim doi' anna umbeem polepi lako indo to muampuam sapulo doi' bulabam.’ ");
INSERT INTO ptu_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Sapo' sangngim mentimba' indo tau naua: ‘Tuam, kisanga sapulom ia doi'na!’ ");
INSERT INTO ptu_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Natimba' indo tomahaja naua: ‘Kutulasangkoa', menna-menna mala dikatappa'i umpalako indo puha dibeem, tau ia too la dihängänniam polepi. Sapo' menna-menna tä' mala dikatappa'i umpalako indo puha dibeem, iya la diäläi pissam ia lao illaam mai kalena. ");
INSERT INTO ptu_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Anna temo baba asannia' mai itim balingku to moka umpotomahajaä'. Patei asannia' dio oloku.’” ");
INSERT INTO ptu_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Puhai ma'tula' Puang Yesus, le'ba'um umpendioloi indo tau buda lu längäm Yerusalem. ");
INSERT INTO ptu_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Tappana umpenandai tondä' Betfage anna tondä' Betania dio Tanete Zaitun, iya ussuam dua passikolanna mendiolo ");
INSERT INTO ptu_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","naua: “Pendiolokoa' lako dio tondä' tapenandaia'. Aka sulekoa' too lako, iya ullambi'unna' mesa keledai lundaha disäke' lombe', tadeempi disäkei. Bukkaia' anna umbabaia' dio mai. ");
INSERT INTO ptu_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Anna maka' too deengkoa' ungkutanai naua: ‘Akanna umbukkaia'?’ uaanni: ‘Aka napahalluam Debata.’” ");
INSERT INTO ptu_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Iya le'ba'um indo to dua, sampe nalambi' si'da umba susi indo puha natula' Puang Yesus. ");
INSERT INTO ptu_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Mahassanni nabukkai indo keledai, ma'kadam puäna naua: “Akanna umbukkaia' itim keledai?” ");
INSERT INTO ptu_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Natimba'im naua: “Aka napahalluam Debata.” ");
INSERT INTO ptu_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Iya nababam indo keledai lako Puang Yesus. Sulei lako, muäläiim jubana anna nalapi'ianni indo keledai, mane muäkä'i Puang Yesus längäm. ");
INSERT INTO ptu_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Mahassanni mellao ussäkei indo keledai, iya budam tau muäläi jubana anna naampa'i lako lalam la naolanna Puang Yesus tanda pa'pakasallena. ");
INSERT INTO ptu_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Tappana la landa' kale lako Yerusalem Puang Yesus dio indo lalam yabo mai Tanete Zaitun, iya napahandu'um sikatamba indo buda passikolanna umpa'kasallei Puang Allataala ponno katilallasam aka puham muita buda tanda memängä-mängä nakähä Puang Yesus. ");
INSERT INTO ptu_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Naua: “Katambasam tomahaja to sule illaam sanganna Debata! Masannammi pole' yabo suhuga. Dipa'kasallei To yabo ongeam handam matande!” ");
INSERT INTO ptu_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Sanaka-naka to illaam kakalebuanna Parisi illaam indo alla'-alla'na tau buda ma'kada naua: “O Tuangguhu, popengkamma'i inde lako passikolammu!” ");
INSERT INTO ptu_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Natimba' Puang Yesus naua: “Tää', aka kutulasangkoa', maka' la mengkamma' inde mai tau, iya inde mai batu la sikatamba!” ");
INSERT INTO ptu_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Tappana undundu lako Yerusalem Puang Yesus anna napahandammi indo kota, iya nasahhoim ");
INSERT INTO ptu_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","anna ma'kadai naua: “Oa' to Yerusalem pidaha kela muissanna' allo temo lalanna tungka kamasannangam. Sapo' temo tä' mala muita aka tibuni lako kalemua'. ");
INSERT INTO ptu_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","La deem wattunna sule balimmu umbundu'koa'. Iya la natampoi tembo' kotamu anna naolai nalebokoa' nasikuku'i. ");
INSERT INTO ptu_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","La napempa'deangkoa', susi issinna teem kotamu lambi' tä' deem mesa batu la tiäto' dio ongeanna. La dadi ingganna ia too aka tä' muissanna' muua wattunnam temo napellambi'ikoa' Puang Allataala.” ");
INSERT INTO ptu_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Puhai ia too, le'ba'um Puang Yesus tama pa'hanteanna Banua Debata. Sulei tama, tappa uhhambai siaham lao ingganna to si balu'-balu' illaam. ");
INSERT INTO ptu_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Anna mane umpa'tula'i indo tau buda naua: “Deem tisuha' illaam Battakada Debata naua: ‘Banuangku la naongei hupatau ma'sambajam,’ sapo' umpadadi hia' iko pa'mesaanna pa'bulele kalasi anna pa'tombonganna to maboko allo.” ");
INSERT INTO ptu_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Allo-allo ma'pa'guhu Puang Yesus illaam Banua Debata. Ingganna kapala sando sola to ullatta' Pepaondonganna Musa anna pepungngu'na to Yahudi sangngim maelo' la napatei, ");
INSERT INTO ptu_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","sapo' tä'pi deem naita lalanna la mala napatei, aka ingganna tau buda lu lako asam penabanna tula'na Puang Yesus. ");
INSERT INTO ptu_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Pissam wattu ma'pa'guhu oom Puang Yesus illaam Banua Debata lako tau buda untula' anna umpa'pakahebaam Kaheba Katilallasam. Iya sule ham sanaka-naka kapala sando anna to ullatta' Pepaondonganna Musa sola matua ulunna to Yahudi umpellambi'i ");
INSERT INTO ptu_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","anna nauai: “Tulasangkanni aka umpolalam anna umpogau'i inde mai ingganna pa'pogausam, anna menna umbeengko kakuasaam?” ");
INSERT INTO ptu_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Sapo' natimba' naua: “La kukutanaikoa' duka'! Tulasannä', ");
INSERT INTO ptu_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","menna umbeenni kakuasaam Yohanes anna si mantedo'i? Puang Allataala haka hupatau haka?” ");
INSERT INTO ptu_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Iya sipa'tula'-tula'um naua: “Mapahhi' la ditimba'i, aka taua hia' manii: ‘Kakuasaanna Puang Allataala,’ iya la nauaammakia' too: ‘Akanna tä'ia' ungkatappa'i?’ ");
INSERT INTO ptu_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Iya la taua hia' manii: ‘Kakuasaanna hupatau,’ la naleba'ingkia' too batu inde lako tau. Aka indo Yohanes, nakatappa'i asam tau naua: ‘Abana mesa nabi.’” ");
INSERT INTO ptu_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Iya natimba'im naua: “Tä' kiissam menna amo umbeenni kakuasaam Yohanes.” ");
INSERT INTO ptu_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Nasuhum naua Puang Yesus: “Maka' susi, iya tä' duka' kuaku la kutulasangkoa' menna umbeennä' kakuasaam nasuhum kupogau' kaha-kaha ia too.” ");
INSERT INTO ptu_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Puhai ia too, untula' oom mesa pehapangam Puang Yesus lako indo tau buda naua: “Deem mesa tau untananni bela'na anggur. Puhai natananni, iya napa'petesangammi lako sanaka-naka tau anna mane le'ba' lako botto mambela anna dioi masäe. ");
INSERT INTO ptu_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Tappana naagiam la matäsä' indo bua anggurna, iya ussuam mesa sabua'na le'ba' umpellambi'i indo to mantesanna, aka la natahimaam bahena. Sapo' sulei lako, iya ke natembe' puso hia indo to mantesam mane nasuai ma'pasule ma'pala' lo'bä. ");
INSERT INTO ptu_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Iya ussua pole oom mesa sabua'na le'ba' pole lako indo to mantesam. Sapo' sulei lako, natembe' puso pole boom anna napakasihi'-sihi'i, mane nasuai lao ma'pala' lo'bä. ");
INSERT INTO ptu_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Iya ussua pole oom sabua'na katallunna, sapo' napongko pole boo mane natibei lako sulibanna bela'. ");
INSERT INTO ptu_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Iya ma'kadam indo puäna bela' naua: ‘Aka opi umbai' la kupogau'? O, la kusua änä' pangkaha'ku aka tä' mala tala nakalaja' ia pole'.’ ");
INSERT INTO ptu_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Sapo' naitanna indo to mantesam sule indo änä'na, iya sipattuju-tujum naua: ‘Iam too inde to la ullombum kullena tomatuanna. Tapateia' anna mala taalaa' inde bela'na.’ ");
INSERT INTO ptu_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Nabalesom illaam mai indo bela' mane napatei.” Iya mekutanam Puang Yesus naua: “Akam la napogau' indo puäna bela' ke sulem? ");
INSERT INTO ptu_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Tä' mala tala lao napempa'deam indo to mantesanna anna napa'petesangam polei indo bela'na lako tau senga'.” Nahingnginna indo tau buda, tappa ma'kadam lako Puang Yesus naua: “Tä' si'da-si'da ia pole' la mala susi!” ");
INSERT INTO ptu_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Nalio-liom Puang Yesus indo tau buda mane ma'kadai naua: “Maka' susi, iya aka kalembasanna indo tula' puha tisuha' illaam Battakada Debata naua: ‘Indo batu natibe tukam, ia leko' di diala dipobatu longkahhim?’ ");
INSERT INTO ptu_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Anna ingganna tau to metobä dokko indo batu la huppu'-huppu' bukunna, anna menna-menna natappai indo batu la dahi kapu'.” ");
INSERT INTO ptu_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Tappana nahingngi ingganna to ullatta' Pepaondonganna Musa sola kapala sando indo tula'na Puang Yesus, iya nauaim: “Kitaa' päläe' napasihim.” Iya umpeäim lalam anna malai ussakka Puang Yesus eta too, sapo' sangngim mahea' ohi lako tau buda. ");
INSERT INTO ptu_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Ingganna indo to ullatta' Pepaondonganna Musa sola kapala sando umpeä liu lalam anna mala ussakka Puang Yesus. Iya ussuam sanaka-naka tau lao napellambi'i, mato-mato tau mapia la mekutana lako Puang Yesus anna ke napeä hia lalanna umba ke malai napetidom anna mala nasakka anna nabehoi lako pala' limanna gubernur. ");
INSERT INTO ptu_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Ma'kadam indo to disua lako Puang Yesus naua: “O Tuangguhu, kiissam kiua tula'mu anna pepa'guhuammu malolo asam. Kiissam toi duka' kiua umpepatuduangko ulalanna Puang Allataala sola undu' lollä lako ingganna hupatau, aka moi Iko menna tala ungkalaja'i aka umpapada-pada bäbäko Iko hupatau. ");
INSERT INTO ptu_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Dadi, deem la kipekutanaam: situhu' peadasam tapendudunna', la sipäto' dakika' umbaja' sima lako tomahaja dio Roma, la tä' daka?” ");
INSERT INTO ptu_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Sapo' nalosa Puang Yesus pudu' pandenna anna lila manähäna lambi' ma'kada naua: ");
INSERT INTO ptu_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Paitaipä' mesa doi' peha'!” Naitai, iya mekutanam naua: “Menna kegamba' anna menna kesanga inde dio doi'?” Iya natimba'im naua: “Gamba'na anna sanganna tomahaja dio Roma.” ");
INSERT INTO ptu_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Iya nauam Puang Yesus: “Maka' susi, iya beennia' tabana tomahaja dio Roma la sipäto'na umbeem, anna beennia' duka' Puang Allataala la sipäto'na umbeem.” ");
INSERT INTO ptu_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Iya tä' deem tula'na Puang Yesus la mala napetidom dio olona tau buda, lambi' sangngim mengkamma' mandam tä' naissam mentimba' aka pilla' uhhingngii pentimba'na. ");
INSERT INTO ptu_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Puhai ia too, iya sulem sanaka-naka to illaam kakalebuanna Saduki battu diua to tä' ungkatappa'i katuboanna sule to mate umpellambi'i Puang Yesus, ");
INSERT INTO ptu_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","anna nakutanai naua: “O Tuangguhu puhangkia' nasuhasam Musa illaam suha' pepaondonganna naua: ‘Maka' deem mesa muane mate anna tä'i deem änä'na, iya indo siam solasubunna la umpobainei indo bainena, anna mala deem pessubunna.’ ");
INSERT INTO ptu_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Iya la maakam ia susi indee: aka pissam wattu deem pitu muane ma'solasubum. Uhuna kebaine indo handam ulua. Sapo' tä'pi deem änä' nasibalii indo bainena anna matem indo muane. ");
INSERT INTO ptu_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Iya napobainem huntunna indo bainena, sapo' tä' pole oo keänä' lambi' mate. ");
INSERT INTO ptu_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Iya napobaine pole oom indo katallunna, sapo' susi pole oo sule lako kapitunna sangngim tä' deem keänä' anna matem. ");
INSERT INTO ptu_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Katampasanna, mate duka' indo baine. ");
INSERT INTO ptu_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Dadi, maka' lambi'um wattunna la tubo sule to mate, iya mennannam kabam la napomuane indo baine, aka bali asam di napomuane indo to pitu ma'solasubum?” ");
INSERT INTO ptu_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Natimba' Puang Yesus naua: “Ingganna to tubo illaam inde lino temo siala-ala anna ma'pasiala. ");
INSERT INTO ptu_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Sapo' dako'i too ingganna to tihekem la sipäto' dipatibangom dio mai kamateanna anna mangngala taba illaam lino bakahu, tä'um tia deem la siala anna tä' toi deem ma'pasiala. ");
INSERT INTO ptu_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Aka indo katuboanna la susim malaika', tä'um la mate. Mendadim änä'na Puang Allataala aka puham napatibangom dio mai kamateam. ");
INSERT INTO ptu_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Mannassa anna dipatibangonni sule to mate dio mai kamateam aka puha napatandaam Musa illaam tulasanna diona indo api ma'nala-nala illaam satoo' kaju-kaju. Eta too ma'tula' Debata naua: ‘Kaom too inde Puang Allataala to napenombai Abraham, Ishak, anna Yakub.’ ");
INSERT INTO ptu_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Dadi moinna anna puham mate indo to tallu, sapo' mannassa anna tuboi temo aka anggam to tubo mala umpenombai Puang Allataala. Aka situhu' Puang Allataala, ingganna hupatau tubo liu, moi anna matem.” ");
INSERT INTO ptu_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Iya ma'kadam sanaka-naka to ullatta' Pepaondonganna Musa lako Puang Yesus naua: “Tappa' pentimba'mu, Tuangguhu!” ");
INSERT INTO ptu_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Lessu'na eta too, tä'um pole' deem tau la bahani umpadeem pole pekutanaam lako Puang Yesus. ");
INSERT INTO ptu_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Iya mekutanam Puang Yesus naua: “Maaka hia anna diuai ‘Indo To nalanti' Puang Allataala la mepasalama' peampoanna tomahaja Daud?’ ");
INSERT INTO ptu_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Iya ma'kale hi Daud umpokadai illaam suha' Pampujiam naua: ‘Ma'kada Puang Allataala lako Debatangku naua: Okko'ko dio tandai kanangku, ");
INSERT INTO ptu_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","sule lako wattunna la kupopa'bukku ingganna balimmu dio olomu lambi' uhhondoi dokko.’ ");
INSERT INTO ptu_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Dadi makaleso anna ma'kalei tomahaja Daud muuai: ‘Debatangku To nalanti' Puang Allataala.’ Iya maaka hi susi anna la ia ohi umpoampoi?” ");
INSERT INTO ptu_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Mahassampi napehingngii tau buda tula'na, iya ma'kada pole oom Puang Yesus umpa'tula'i passikolanna naua: ");
INSERT INTO ptu_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Majagakoa' lako to ullatta' Pepaondonganna Musa indana napabulingkoa'. Aka anggam napohäe ma'lao-lao tama pasa' ma'baju tihui' anna maelo' napa'kasallei hupatau. Anna si moka muokko' illaam pa'sambajangam ke tä'i dio olo, anna si umpise'i toi ongeam dipa'kasalleinna ke illaanni pa'hame-hameam. ");
INSERT INTO ptu_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Anna si umpamasingam tula' to balu-balu baine lambi' sule lako banuanna naala. Si naägä'i umpakalando sambajanna anna mala nauaam tau: ‘Tau mapia’ anna ke tau kadake hia. Nasuhum la nalambi' pesämbä' mabanda'na Debata.” ");
INSERT INTO ptu_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Tappana mennenne' Puang Yesus illaam indo Banua Debata, iya muitam buda to makaka umpatama patti pehumalasam bua pemala'na. ");
INSERT INTO ptu_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Naitam duka' mesa to balu-balu baine anna mase-mase polepi umpatama dua ia doi' gällä handam saidi' angga'na. ");
INSERT INTO ptu_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Iya ma'kadam Puang Yesus naua: “Kutulasangkoa', buda puha ia bua pemala'na inde to balu-balu baine anna la ingganna tau senga'. ");
INSERT INTO ptu_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Aka inde lako tau la'binna ia kullena napatama. Sapo' inde ia to balu-balu baine moi anna mase-mase, napebeem asam ia indo deenna lako kalena, moi anna anggam ia la napotubo.” ");
INSERT INTO ptu_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Deem sanaka-naka tau untula' diona Banua Debata naua: “Tä' deem pada samapia aka dibunga-bungai buda batu maleke anna dibunga-bungai buda baham-baham dipehumalasam längäm Puang Allataala.” Iya ma'kadam Puang Yesus ");
INSERT INTO ptu_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","naua: “Dako'i too la deem wattunna ingganna inde muitaa' temo tä' deem moi podo la mesa batunna la tiäto' liu sitodo' solana, aka pissam wattu la ditaleam asam.” ");
INSERT INTO ptu_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Puhai ia too, mekutanam passikolanna lako Puang Yesus naua: “O Tuangguhu, tulasampakam piham la dadi ingganna indo puha untula' ingngena'? Anna aka la tandana anna diissanni diua lambi'um wattunna la dadi?” ");
INSERT INTO ptu_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Natimba' Puang Yesus naua: “Majagakoa' indana deenni tau la umbaba bulingkoa'! Aka la buda too tau sule umboko sangangku anna la buda tau nababa bulim aka la naua: ‘Kaom too inde To nalanti' Puang Allataala;’ anna la naua toi: ‘Mahuku'um wattunna allo ma'katampasanna.’ Sapo' daa umpehingngiia'. ");
INSERT INTO ptu_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Maka' too uhhingngingkoa' kaheba diona passibundusam anna to sianu-anu, iya tä'koa' too la mahea' aka abana hi tia inna la dadi yolo kaha-kaha ia too. Sapo' taiapi indo allo ma'katampasanna.” ");
INSERT INTO ptu_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Mane napatahhu'i tula'na Puang Yesus naua: “Aka la sipate-patei hupatau anna kahajaam pada kahajaam la sibundu'-bundu'. ");
INSERT INTO ptu_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Anna umba-umba ngei ongeam la dadi lino' kasalle anna la sule kakobeam anna la kende' ma'hupa-hupa saki lele makahha'. La dadi ma'hupa-hupa tanda mepakahea'-hea'na anna mehäntäinna yabo mai langi'. ");
INSERT INTO ptu_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Sapo' yolo anna la dadii kaha-kaha ia too, la disakkakoa' anna didahha. La dibabakoa' lako to mahhotto' illaam peadasam mane dipatamakoa' tahungkum. Anna la dibabakoa' lako olona tomahaja anna to ma'pahenta aka untuhu'iä'. ");
INSERT INTO ptu_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Etanna' too la muongei mendadi sa'bingku dio olona hupatau. ");
INSERT INTO ptu_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Sapo' pomanontonnia' penabammu temo anna mala tä'koa' mahea' muua: ‘Aka amom isanga la diua mentimba'?’ ");
INSERT INTO ptu_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Aka la kubeengkoa' tula' sola kakeakasam lambi' tä' deem moi podo la mesa balimmua' la nabela untimba'i tula'mu battu haka la nabahoi. ");
INSERT INTO ptu_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Wattu eta too la dibehokoa' lako pala' limanna balimmu. La nabehokoa' tomatuammu, solasubummu, kasahapuammu, anna solamu lambi' deem la palla' penabanna umpopepateikoa'. ");
INSERT INTO ptu_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Anna la nakabassikoa' ingganna tau aka untuhu'iä'. ");
INSERT INTO ptu_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Sapo' moi la salamba' beluä'mua', tala deenni honno' sule lako olona Puang Allataala! ");
INSERT INTO ptu_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","La mentobekoa' manda' anna mengnganti matoto' illaam kamatappasam anna malakoa' ullambi' katuboam sule lako salako-lakona.” ");
INSERT INTO ptu_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Maka' muitanna' kota Yerusalem natalimbum tama sohodadu, iya muissammia' too muua tä'um masäe anna la dipempa'deammi kota ia too. ");
INSERT INTO ptu_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Wattu eta too ingganna indo to dio Yudea pahallu la sikalumpa' längäm tanete. Ingganna to tohho illaam kota la pahallu le'ba' umpellei indo kota, anna to sulibanna kota tä'um la tama kota. ");
INSERT INTO ptu_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Aka wattu iam too indo la naongei Puang Allataala umpabala'i gau' kadakena hupatau anna mala sule lako indo puha tisuha' illaam Battakada Debata. ");
INSERT INTO ptu_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Wattu eta too tä' deem pada samasussa lako baine to mahassam kebättä anna to ma'pasusu. Aka inde botto la nalambi' kamasussaam kasalle anna issinna la napahuai aha' kasallena Puang Allataala. ");
INSERT INTO ptu_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Buda to Yahudi la dipatei pa'dam dipake anna deem la disakka anna dibabai lako mobotto-bottoam. Anna inde kota Yerusalem la napa'lullu' tau taianna to Yahudi anna nakuasai sule lako wattu puha napa'tantu Puang Allataala.” ");
INSERT INTO ptu_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Mane nauai: “La deem kende' tanda memängä-mängä yabo mata allo, bulam, anna ingganna bintä. Anna ingganna hupatau illaam inde lino la mahea' anna mängä-mängä muita bombanna le'bo' anna uhhingngi magahugunna uwai. ");
INSERT INTO ptu_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","La tisittä' hupatau aka muita indo to la dadi lako lino. Aka ingganna issinna langi' la titähhä' bäbä. ");
INSERT INTO ptu_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Anna wattu eta too ingganna hupatau la naitaä' to disangai Änä' Mentolino tuhum yabo mai langi' illaam gabum naponnoi kamatandeam taditondom anna naponnoi toi kakuasaam. ");
INSERT INTO ptu_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Maka' too napahandu'um dadi kaha-kaha ia too, iya ke'de'ungkoa' mentonga aka la dipasalama' kalengkoa'.” ");
INSERT INTO ptu_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Mane untula'i pehapangam Puang Yesus naua: “Petua'ia' kaju ara anna kaju senga'. ");
INSERT INTO ptu_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Maka' kendaum händä oom, iya la muissammia' too muua la bale' sulem kulla' kalando. ");
INSERT INTO ptu_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","La susim too duka' ke muitanna' dadi asam indo puha kutulasangkoa', iya la muissammia' too muua la bale' umpalakom kapahentaanna Puang Allataala. ");
INSERT INTO ptu_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Setongam-tonganna, ingganna kaha-kaha ia too la dadi yolo anna mane mate asam ingganna to tubo lapi' temo. ");
INSERT INTO ptu_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Langi' anna lino la pa'de ke dako'i, sapo' kadangku ia, la da'da' liu sule lako salako-lakona.” ");
INSERT INTO ptu_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","35","Mane nauai: “Majaga manappakoa' indana angga umpasatutui penabammu lako kamahoasam di lino anna si umpamäbo' kalemu, sola angga umpikki' anna uhhusasam salu katuboammu inde lino. Aka maka' susi, iya la lembe bäbäkoa' too, pissananna ham napatikkedu'koa' allo kasuleangku umba susi poja lu'bi' umpatikkedu' olo'-olo' nasakka. ");
INSERT INTO ptu_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Majagakoa' ammu pa'sambajam liu anna mala matoto'koa' muoloi ingganna indo kaha-kaha la dadi ke dako'i, anna mala ke'de'koa' dio oloku to disangai Änä' Mentolino.” ");
INSERT INTO ptu_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Wattu eta too si ma'pa'guhu Puang Yesus illaam Banua Debata ke ialloi anna lu libam Tanete Zaitun ma'bengi. ");
INSERT INTO ptu_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Mebengngi' oi too, sule asam oom tau illaam Banua Debata umpehingngii Puang Yesus ma'pa'guhu. ");
INSERT INTO ptu_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Tappana mahuku' allo kasalle Hoti Tä' Diboloi Bibi' Hoti battu diua allo Kalappasam, ");
INSERT INTO ptu_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","ingganna kapala sando sola to ullatta' Pepaondonganna Musa umpeä lalam la umpatei buni Puang Yesus aka sangngim ungkahea' tau buda. ");
INSERT INTO ptu_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Iya napentamaim ia tomahajanna setam Yudas Iskariot mesa duka' to tihekem sapulo dua passikolanna Puang Yesus. ");
INSERT INTO ptu_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Nasuhum le'ba' umpellambi'i sanaka-naka kapala sando sola sanaka-naka punggabana to si unjagai Banua Debata anna sipattuju-tujui la naaka susi Yudas umbalu' Puang Yesus. ");
INSERT INTO ptu_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Kattui pattujunna, iya sangngim tilalla'um lambi' ma'dandi la nasahoi doi'. ");
INSERT INTO ptu_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Iya naioim duka' Yudas lambi' tappa umpeä wattu tala naissanna tau buda la naolaam umbalu' Puang Yesus. ");
INSERT INTO ptu_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Pissananna lambi'um allo kasalle Hoti Tä' Diboloi Bibi' Hoti indo si naongei to Yahudi untunu domba la diande illaam allo Kalappasam. ");
INSERT INTO ptu_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Iya ussuam Petrus sola Yohanes Puang Yesus naua: “Laokoa' patoka indo kinande si diande ke umpengkilalai ongkia' allo Kalappasam.” ");
INSERT INTO ptu_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Iya mekutanam lako naua: “La umbakam ngei umpatoka indo kinande?” ");
INSERT INTO ptu_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Natimba' Puang Yesus naua: “Maka' tamakoa' kota la sitammungkoa' too mesa muane umbaba busso kessi uwai. Tuhu'ia' lako banua naongei ");
INSERT INTO ptu_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","anna muuaannia' indo to ma'banua: ‘Naua Tuangguhu: umba ngei tambim la kiongei mangngande kinande allo Kalappasam sola passikolangku?’ ");
INSERT INTO ptu_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","La napaitaingkoa' too mesa tambim kalua' tando längäm deem asammi pangkakka' illaam. Etanna' too la muongei ma'patoka.” ");
INSERT INTO ptu_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Iya le'ba'um Petrus sola Yohanes, iya nalambi' si'da susi liu indo tula'na Puang Yesus. Iya napatokam indo kinande si diande illaam allo Kalappasam. ");
INSERT INTO ptu_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Tappana lambi' wattunna, iya mangngandem Puang Yesus sola indo sapulo dua suhona. ");
INSERT INTO ptu_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Iya ma'kadam naua: “Abana kupemulu la ma'mesakia' muande kinande allo Kalappasam yolona anna la untammuä' pandahhaam. ");
INSERT INTO ptu_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Aka kutulasangkoa', diganna'ipi kalembasanna inde allo Kalappasam illaam wattunna ma'pahenta Puang Allataala mane kuande polei inde kinande allo Kalappasam.” ");
INSERT INTO ptu_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Iya mualam ihusam Puang Yesus kessi anggur anna nakuhhu'i sumanga' mane nauai: “Alai ammu paleleia' muihu'. ");
INSERT INTO ptu_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Aka kutulasangkoa': Mengkalao temo tä'mä' Kao deem la muihu' pole anggur sule lako sule kapahentaanna Puang Allataala.” ");
INSERT INTO ptu_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Puhai, mualam mesa hoti anna nakuhhu'i sumanga' längäm Puang Allataala mane napiä'-piä'i anna nabeenni lako suhona napasindum naua: “Iam too inde baleku kupebeem kahana kusolongkoa'. Pogau' liuia' susi indee anna malaä' ungkilalai.” ");
INSERT INTO ptu_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Susi siam tappana puha mangngande, muala ihusam kessi anggur anna nabeenni lako suhona napasindum ma'kada naua: “Inde ihusam kessi anggur, iam too dipasihhapam pa'dandiam bakahunna Puang Allataala lako hupatau. Indo pa'dandiam bakahu, hahaku la dipatitollo la umpomannassai diua dadim indo pa'dandiam. ");
INSERT INTO ptu_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Sapo' pehingngii manappaia'! Indo to la umbalu'ä', indekia' sola mangngande! ");
INSERT INTO ptu_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Abana hi tia Kao to disangai Änä' Mentolino inna la mateä' umba susi puha napa'tantu Puang Allataala. Sapo' tä' deem pada satilaka lako indo to umbalu'ä'.” ");
INSERT INTO ptu_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Iya sipa'tula'-tula'um indo suhona naua: “Mennangkia' umbai' la umpogau'i kaha-kaha ia too?” ");
INSERT INTO ptu_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Iya sibetä'-betä'um passikolanna naua: “Mennakia' la disangai handam matande?” ");
INSERT INTO ptu_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Nauaammi Puang Yesus: “Tomahaja inde lino umpake palu-palu bassi umpahenta pakketauanna anna ingganna to kasallena maelo' si disangai to ungkambi' hupatau. ");
INSERT INTO ptu_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Sapo' ikoa'-iko tä'koa' la susi. Aka to handam matande illaam alla'-alla'mua', tau ia too la umpopengkadio kalena. Anna to pepungngu' la umpopendadi kalena to ma'tahia. ");
INSERT INTO ptu_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Aka mennanna kabam disangai matande, to muokko' daka mangngande dio meja to ma'tahia haka? Mannassa anna indo to muokko'. Sapo' Kao-kao mendadiä' to ma'tahia illaam alla'-alla'mua'. ");
INSERT INTO ptu_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Illaam ingganna kamasussaangku tontä liukoa' manontom umpasolaiä'. ");
INSERT INTO ptu_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Umba susi nabeemmä' Ambeku kakuasaam la ma'pahenta, susim too duka' la kubeengkoa' kakuasaam ma'pahenta ");
INSERT INTO ptu_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","anna malakia' sola-sola mangngande anna mangngihu' dio mejaku illaam kapahentaangku. Anna la dipatadongkongkoa' yabo sapulo dua okkosam kahajaam, aka la umpahe'koa' indo pessubunna sapulo dua too'na to Israel.” ");
INSERT INTO ptu_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Mane ma'kadai lako Simon Petrus naua: “O Simon! Pehingngii! Dibeemmi lalam tomahajanna setam la napa'sändä'ikoa' dipasihhapam pahe ditappi dipasise'la läkko'na anna maläpu'na. ");
INSERT INTO ptu_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Sapo' balingko kupa'sambajangam Simon, indana pa'dei kamatappasammu. Sapo' maka' mengkatoba'ungko, iya la umpakatoto'ko penabanna ingganna solasubummu.” ");
INSERT INTO ptu_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Natimba' Petrus naua: “O Debata, ahu'ä' la ditahungkum lambi' la mateki' sola.” ");
INSERT INTO ptu_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Iya natimba'um Puang Yesus naua: “O Petrus, paillaam penabai inde tula'ku: tä'pi la moni mäne' anna pentallummä' umbahoi.” ");
INSERT INTO ptu_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Anna mane naua polei: “Indo anna kusuakoa'i indo lessu', tä'koa' kupäbäi umbaba ongeam doi', ongeam tinallo, anna sapatu. Iya deem dakoka' kakuhängam?” Sangngim mentimba' naua: “Tä' deem.” ");
INSERT INTO ptu_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Iya naua oom Puang Yesus: “Sapo' temo kuuaangkoa' pole': maka' muampuangkoa' ongeam doi', babaia'. Susi toi ongeam tinallo. Anna maka' pa'de pa'dammu, balu'i jubamu anna muallianni pa'dam. ");
INSERT INTO ptu_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Aka kutulasangkoa', puha tisuha' illaam Battakada Debata diona Änä' Mentolino naua: ‘Disangai Ia mesa to kadake gau'.’ Anna tula' ia too tä' mala tala dadi lako kaleku. Iya indo to puha tisuha' diona kaleku la lambi'um wattunna temo.” ");
INSERT INTO ptu_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Ma'kadam passikolanna naua: “O Debata, petua'i indem dua pa'dam.” Natimba' Puang Yesus naua: “Sihuam ia untula' liui.” ");
INSERT INTO ptu_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Puhai ia too, iya umpelleim kota Yerusalem Puang Yesus sola passikolanna le'ba' längäm Tanete Zaitun umba susi indo si napogau'. ");
INSERT INTO ptu_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Yaboi, ma'kadam Puang Yesus lako passikolanna naua: “Pa'sambajangkoa' indana napa'sändä'ikoa' setam.” ");
INSERT INTO ptu_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Mane le'ba'i umpellei passikolanna umbai' la dilambi' dileba' mambelanna, anna ma'balinguntu'i ma'sambajam. ");
INSERT INTO ptu_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Naua: “O Ambe', maka' umpoelo' lappasannä' dio mai inde kamasussaam kuoloi temo, sapo' la pa'elo'mu dadi, taia la pa'elo'ku.” ");
INSERT INTO ptu_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Iya tappa sule siaham mesa malaika' yabo mai suhuga umpakatoto'i. ");
INSERT INTO ptu_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Tuttuam masussa nasi'dim Puang Yesus, nasuhum tuttuam umbeho kalena ma'sambajam. Anna to'do appu'na susi haha dokko litä'. ");
INSERT INTO ptu_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Puhai ma'sambajam, iya ke'de'um anna ma'pasulei lako passikolanna. Sapo' mamma'i hi nalambi' aka masussa penabanna. ");
INSERT INTO ptu_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Iya nauaammi: “Akanna mamma'koa'? Bangongkoa' ammu pa'sambajam indana napa'sändä'ikoa' setam.” ");
INSERT INTO ptu_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Mahassampi ma'tula' Puang Yesus, iya sule ham buda tau nayoloangam Yudas indo to tihekem duka' sapulo dua passikolanna Puang Yesus. Iya tahhu'um ia Yudas umpellambi'i Puang Yesus anna naudunni. ");
INSERT INTO ptu_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Sapo' ma'kada hi Puang Yesus naua: “O Yudas, iangka inde pangngudummu umpake umpebeennä' to disangai Änä' Mentolino?” ");
INSERT INTO ptu_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Tappana naissam ingganna passikolanna naua la disakka Puang Yesus, iya ma'kadam naua: “O Debata, la kitepangka pa'dam?” ");
INSERT INTO ptu_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Pahopängam siaham mesa solana Puang Yesus ussintä' pa'danna anna umbattai mesa sabua'na sando too', iya mäläi talinga kananna. ");
INSERT INTO ptu_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Sapo' ma'kada Puang Yesus naua: “Sihuam!” Mane nahakasanni indo talinganna, iya tappa bono' siaham. ");
INSERT INTO ptu_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Puhai, umpatahhu'um tula'na Puang Yesus lako ingganna indo kapala sando, punggabana to si unjagai Banua Debata, sola matua ulunna to Yahudi, indo to sule la ussakkai naua: “Ussangaa' isanga pehampo'ä' anna sulekoa' sanda pa'dam sanda bose la ussakkaä'? ");
INSERT INTO ptu_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Kusanga allo-allokia' sola illaam Banua Debata anna tä' di ussakkaä'. Sapo' temo lambi'um wattunna la ma'palakokoa', aka wattunnam ma'kuasa kamalillingam.” ");
INSERT INTO ptu_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Puhai ma'tula' Puang Yesus, iya nasakkam anna nababai lako banuanna sando too'. Iya natuhu' kalamba'um Petrus. ");
INSERT INTO ptu_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Illaam indo tängä pa'hanteam deem sanaka-naka tau untubei api. Iya le'ba'um duka' Petrus lako muokko' sola-sola tau buda mendähä. ");
INSERT INTO ptu_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Deem mesa sabua' baine muita Petrus muokko' dio sa'de api. Iya napetua'-tua' lium lambi' ma'kada naua: “Inde tau si sola liu duka' inde dio Yesus.” ");
INSERT INTO ptu_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Sapo' tappa ma'baho Petrus naua: “Tä' too kao kuissam itim tau!” ");
INSERT INTO ptu_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Tä' masäe, naita pole oom mesa tau. Iya nauaammi: “Ikom duka' mesa solana.” Sapo' natimba' Petrus naua: “Tää'! Takao hi to kao!” ");
INSERT INTO ptu_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Umbai' mesai tette' lessu'na, iya sule oom mesa tau ma'kada kasalle naua: “Mannassa anna solana Yesus inde tau, aka to Galilea duka'!” ");
INSERT INTO ptu_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Sapo' natimba' liu Petrus naua: “Tä' kuissam itim tula'mu. Aka hi iko ussanga?” Iya tä'pi teppu' dio pudu'na Petrus tula'na, iya moni siaham mäne'. ");
INSERT INTO ptu_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Iya ussailem Petrus Puang Yesus, iya tappa nakilalaim pole' indo tula'na Puang Yesus naua: “Tä'pi la moni mäne' anna pentallummä' umbahoi.” ");
INSERT INTO ptu_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Iya le'ba' siaham Petrus lako sulibam anna ma'pase'go'i sumahho. ");
INSERT INTO ptu_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Puhai ia too, iya indo tau buda to unjagai Puang Yesus natelle anna natappai lima. ");
INSERT INTO ptu_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Mane nasapu'i matanna anna nauaanni: “O nabi, pentopaipi, menna untappai limako?” ");
INSERT INTO ptu_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Anna budapi pantelle senga'na lako Puang Yesus. ");
INSERT INTO ptu_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Mebengngi'-bengngi'i, ma'hempummi To Mahhotto' Handam Malangka' illaam peadasam eta too, susinna matua ulunna to Yahudi sola ingganna kapala sando anna to ullatta' Pepaondonganna Musa. Iya dipasolam Puang Yesus lako olona. ");
INSERT INTO ptu_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Iya nauaammi: “Tulasangkanni, ikongka indo To dilanti' la mepasalama'?” Natimba' Puang Yesus naua: “Maka' la kutulasangkoa', tä' sianna' la ungkatappa'i. ");
INSERT INTO ptu_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Anna maka' kukutanaikoa', tä' siangkoa' duka' la mentimba'. ");
INSERT INTO ptu_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Sapo' mengkalao temo Änä' Mentolino la muokko' dio tandai kananna Puang Allataala To Handam Kuasa.” ");
INSERT INTO ptu_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Iya ma'kadam indo to ma'hempum naua: “Maka' susi, ikongka Änä'na Puang Allataala?” Natimba' naua: “Susim too itim tula'mua'.” ");
INSERT INTO ptu_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Iya sangngim ma'kadam naua: “Tä'um pahallu deem sa'bi aka tahingnginna' tula'na buttu subum pudu'na.” ");
INSERT INTO ptu_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Puhai ia too, ke'de' asammi indo to ma'hempum anna umpasolai Puang Yesus lako olona Pilatus. ");
INSERT INTO ptu_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Dioi, napahandu'um napakolo'-kolo'i naua: “Inde tau si umpabulim tau buda. Si muuaam tau: ‘Daa umbaja'a' sima lako tomahaja dio Roma.’ Anna naua toi: ‘Kaom too indo To dilanti' la umpasalama' hupatau,’ battu diua mesa tomahaja.” ");
INSERT INTO ptu_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Mekutanam Pilatus lako Puang Yesus naua: “Ikongka indo tomahajanna to Yahudi?” Natimba' naua: “Ikom ma'kale muuai.” ");
INSERT INTO ptu_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Iya ma'kadam Pilatus lako ingganna kapala sando anna lako tau buda naua: “Tä' deem kulambi' kasalaanna inde tau la napolalam dipassala.” ");
INSERT INTO ptu_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Sapo' sangngim nakekke' liu naua: “Aka indo pepa'guhuanna, umpakende' kahusasam illaam lembäna Yudea, mengkalao dio Galilea anna lambi'um duka' inde.” ");
INSERT INTO ptu_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Tappana nahingngi Pilatus tula'nai, iya mekutanam naua: “To Galilea si'da haka inde tau?” ");
INSERT INTO ptu_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Tappana naissam Pilatus naua to buttu dio mai botto napahenta tomahaja Herodes, iya napopebabam lako aka wattu eta too siampu' dio Yerusalem Herodes. ");
INSERT INTO ptu_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Tä' deem pada satilalla' Herodes muitanna Puang Yesus, aka masäem nahingngi kahebana anna lalo mohäena la naita. Anna napemulu umba ke malai naita umpogau' indo tanda memängä-mängä si napogau'. ");
INSERT INTO ptu_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Iam too anna umpabudam pekutanaam lako Puang Yesus. Sapo' tuli tadeem natimba'i. ");
INSERT INTO ptu_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Ingganna indo kapala sando sola to ullatta' Pepaondonganna Musa sangngim ke'de' keaha' umpakolo'-kolo'i Puang Yesus. ");
INSERT INTO ptu_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Puhai ia too, umpetaba-tabaim Puang Yesus Herodes sola sohodadunna anna natelle-telle mane napapohebai poheba susi bajunna tomahaja, mane napopebabai ma'pasule lako Pilatus. ");
INSERT INTO ptu_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Napahandu' allo eta too sipakamajam pole' Herodes anna Pilatus, moinna anna yolona sikabassi. ");
INSERT INTO ptu_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Puhai ia too, nahempummi Pilatus ingganna kapala sando, to pepungngu'na to Yahudi sola tau buda ");
INSERT INTO ptu_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","anna napa'tula'i naua: “Sulekoa' umpasola inde tau aka muuaa': ‘Si umpakende' kahusasam.’ Anna puham kupahessa dio olomua', sapo' tä' deem kulambi' kasalaanna inde tau moi podo la mesam la sihondoi indo si untandasanna'. ");
INSERT INTO ptu_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Susi siam duka' Herodes. Iam too anna napasuleammakia' sule, aka inde tau tä' deem umpogau' kakadakeam napolalam la ditahungkum mate. ");
INSERT INTO ptu_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Anggam ia la kupopehabi' yolo mane kulappasanni.” ");
INSERT INTO ptu_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Maka' lambi' oom allo Kalappasam pahallu nalappasam Pilatus mesa to ditahungkum situhu' pa'elo'na tau buda. ");
INSERT INTO ptu_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Tappana nahingngi indo tula'na, iya sikatambam indo to ma'hempum naua: “Patei, anna ullappasangangkam Barabas!” ");
INSERT INTO ptu_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(Indo Barabas ditahungkum aka umbali-bali to ma'pahenta illaam indo kota anna papateam.) ");
INSERT INTO ptu_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Mohäe ia Pilatus la ullappasam Puang Yesus, lambi' ma'kada pole lako tau buda napekasallei. ");
INSERT INTO ptu_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Sapo' sikaoli mandi indo tau buda naua: “Päso'i, päso'i yabo kaju sitambem anna malai mate!” ");
INSERT INTO ptu_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Iya naua pole oom Pilatus kapentallunna: “Anu' aka hia kasalaanna? Tä' kao deem kulambi' kasalaanna inde tau napolalam la ditahungkum mate. Anggam ia la kupopehabi' yolo mane kulappasanni.” ");
INSERT INTO ptu_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Sapo' indo tau buda tuttuam sikaoli mandi naua: “Päso'i yabo kaju sitambem anna malai mate!” Katampasanna indo tau buda patalo. ");
INSERT INTO ptu_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Iya napatuhu'im Pilatus pelauanna. ");
INSERT INTO ptu_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Iya nalappasammi illaam mai tahungkum indo to umbali-bali to ma'pahenta anna papateam, mane umbehoi Puang Yesus lako indo tau buda anna mala ia siam anna ia napogausam situhu' pa'elo'na. ");
INSERT INTO ptu_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Puhai, iya dibabam Puang Yesus lako sulibam kota. Mahassanni mellao, sitammum mesa tau isanga Simon to Kirene mane sule dio mai sulibanna kota Yerusalem. Iya natähämmi anna napassai umpassam indo kaju sitambem untuhu' Puang Yesus. ");
INSERT INTO ptu_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Anna budapi tau untuhu' Puang Yesus, muane anna baine. Sikauhhu' indo baine ussahhoi Puang Yesus. ");
INSERT INTO ptu_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Iya nasailem Puang Yesus ingganna indo baine anna nauaanni: “Oa' baine to Yerusalem daa ussahhoiä', sapo' sahhoikoa' kalemu anna änä'mu aka la nalambi'koa' kamasussaam. ");
INSERT INTO ptu_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Aka la deem wattunna ma'kada tau naua: ‘Kehongko' ia lako ingganna baine to tämänä anna to tä' deem ma'pasusu!’ ");
INSERT INTO ptu_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Wattu etam too duka' la ma'kada tau naua: ‘O tanete, tambunnikam! O buntu, tampoikam!’ ");
INSERT INTO ptu_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Aka maka' dipa'kasubu-subuim kaju tubo, iya senga'um tia ke kaju matei.” ");
INSERT INTO ptu_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Deem toi dua to kadake gau' dipasibaba Puang Yesus la lao dipatei. ");
INSERT INTO ptu_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Landa'i lako indo ongeam si diuaam Kahohä' Ulu, iya silelem umpäso' Puang Yesus yabo kaju sitambem anna indo dua to kadake gau', mesa dio tandai kananna anna mesa dio tandai kaihinna. ");
INSERT INTO ptu_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Iya ma'sambajammi Puang Yesus naua: “O Ambe', ampunnianni kasalaanna inde mai tau aka balam tanaissanna too inde napogau'.” Mane nataba-tabai sohodadu indo pohebana, sapo' naundi. ");
INSERT INTO ptu_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Wattu eta too buda tau ke'de' umpetua'i. Iya budam pepungngu'na to Yahudi untelle Puang Yesus naua: “Maka' tau senga' mala napasalama', sapo' kela to natuho tongam Puang Allataala anna To nalanti' la mepasalama', la umpasalama'um duka' kalena.” ");
INSERT INTO ptu_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Susi toi duka' ingganna sohodadu to dio heem eta too sangngim untelle Puang Yesus anna nabeenni anggur maissu' ");
INSERT INTO ptu_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","napasindum ma'kada naua: “Maka' tomahajanna si'dako to Yahudi, iya lappasangko kalemu!” ");
INSERT INTO ptu_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Anna deem tisuha' yabo tondom ulunna naua: IAM TOO INDE TOMAHAJANNA TO YAHUDI. ");
INSERT INTO ptu_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Indo mesa to kadake gau' to nasimbahaam dipäso' yabo kaju sitambem untelle duka' Puang Yesus naua: “To dilanti'ko la mepasalama' le'? Iya pasalama'ko kalemu anna kami'!” ");
INSERT INTO ptu_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Sapo' nakeaha'i indo solana naua: “Tä' siapoko isanga mahea' lako Puang Allataala, moi kela daa pada-padangkia' dipahuai pa'tahungkungam mate? ");
INSERT INTO ptu_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Inna la sipäto'um too kita ditahungkum mateki' aka situhu' pa'pogausanta. Sapo' inde Ia tau, tä' Ia deem umpogau' kasalaam.” ");
INSERT INTO ptu_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Mane ma'kadai lako Puang Yesus naua: “O Puang Yesus, kilalaiä' kao le, ke ma'pahentangko illaam kapahentaammu!” ");
INSERT INTO ptu_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Natimba' Puang Yesus naua: “Kutulasangko setonganna allo temo solangki' illaam indo ongeam kamasannangam.” ");
INSERT INTO ptu_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Wattu eta too umbai' tängäm allo, iya malillim pättäm dio indo pa'lembängam sule lako tette' tallu kahubem, ");
INSERT INTO ptu_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","aka tä' tandaam mata allo. Iya indo sampim pesapa' illaam Banua Debata tappa sesse' tipa'dua. ");
INSERT INTO ptu_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Iya metambam Puang Yesus naua: “O Ambe', kupaludokko lisu pala'mu penabangku!” Puhai naua, iya kattu siaham penabanna. ");
INSERT INTO ptu_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Naitanna punggabana sohodadu indo kaha-kaha ia too, iya umpujim Puang Allataala naua: “Abana si'da hia tä' deem kasalaanna inde tau!” ");
INSERT INTO ptu_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Anna indo tau buda to sule umpetua'i sangngim umbusu'-busu' buana manosso ma'pasule. ");
INSERT INTO ptu_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Ingganna solana Puang Yesus muane anna baine napahandam mambela kaha-kaha ia too. Indo baine piha, ia siam indo to si untuhu' liui mengkalao dio Galilea. ");
INSERT INTO ptu_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Deem mesa tau isanga Yusuf to buttu dio mai kota Arimatea dio Yudea. Indo Yusuf mesa to mapia gau' anna malolo penaba muampai liu kasuleanna kapahentaanna Puang Allataala. Moi anna mesa duka' to mentama bilangam To Mahhotto' Handam Malangka', sapo' moka ia untahima kattuanna anna pa'palakoanna solana la umpatei Puang Yesus. ");
INSERT INTO ptu_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Indo Yusuf le'ba' umpellambi'i Pilatus umpelau bakkena Puang Yesus aka la napatama lokko'. ");
INSERT INTO ptu_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Iya laoim napatuhum indo bakkena Puang Yesus anna nabalunni sampim mabusa mane laoi napandam tama lokko' indo to puha napapia dio mesa tanete batu. Indo lokko', tä'pi deem dipatama to mate. ");
INSERT INTO ptu_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Wattu eta too allo pa'patokaam aka la lambi'um allo Katohhoam. ");
INSERT INTO ptu_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Tappana nababa Yusuf indo bakkena Puang Yesus tama lokko', iya natuhu'um duka' ingganna indo baine to napasola liu Puang Yesus dio mai Galilea. Sulei lako, iya naitam duka' indo ongeam dipampandanni bakkena. ");
INSERT INTO ptu_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Puhai ia too, ma'pasuleim lako banuanna umpatokaam bauam bubanau' anna minnä'-minnä' bubanau' bakkena Puang Yesus. Sapo' illaam allo Katohhoam tää'i mengkähä aka untuhu'i Pepaondonganna Musa. ");
INSERT INTO ptu_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Bengi-bengipi indo allo Minggu eta too, iya le'ba'um sanaka-naka baine lako indo ku'bu' umbaba bauam bubanau' indo puha napatoka. ");
INSERT INTO ptu_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Sulei lako, iya naitam indo batu dilapasam ba'ba lokko' puham dilolim lao. ");
INSERT INTO ptu_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Iya le'ba'im tama indo lokko', sapo' tä'um deem nalambi' indo bakkena Puang Yesus illaam. ");
INSERT INTO ptu_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Mahassanni ma'papusa'-pusa' muitai, iya pissananna ham ke'de' dio ampe'na dua tau bassim ma'poheba pangkähhä. ");
INSERT INTO ptu_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Naitanna, iya sangngim mahea' lambi' muoppä dokko litä' menomba. Sapo' ma'kada indo tau naua: “Akanna umpeäkoa' to tubo illaam alla'-alla'na to mate? ");
INSERT INTO ptu_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Pa'dem inde aka tubom sule! Tä' daka ungkilalai indo puha natulasangkoa' indo anna diopokoa' Galilea ");
INSERT INTO ptu_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","naua: ‘Änä' Mentolino la dibeho lako pala' limanna to madosa, la napatei yabo kaju sitambem, anna illaam allo katallunna la dipatibangom sule.’” ");
INSERT INTO ptu_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Mane nakilalai hi indo tula'na Puang Yesus. ");
INSERT INTO ptu_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Tappana sulei dio mai indo ku'bu', iya natula' asammi ingganna indo kaha-kaha naita lako indo to sapulo mesa suhona Puang Yesus sola ingganna to si untuhu'i. ");
INSERT INTO ptu_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Indo baine to sule untula' indo kaha-kaha ia too isanga Maria Magdalena, Yohana, Maria indona Yakobus, anna deempi sanaka-naka solana. ");
INSERT INTO ptu_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Sapo' indo ingganna suho tä' ungkatappa'i indo baine aka nasanga hia ma'tula' sasa bäbä. ");
INSERT INTO ptu_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Sapo' tappa ke'de' ia Petrus lumumpa' lako indo ku'bu'. Sulei lako, lumukkum naolläi tama indo lokko', iya naitam angga ham pebalunna tihongkä' illaam. Iya ma'pasulem Petrus napasindum napenaba-nabaam kaha-kaha ia too. ");
INSERT INTO ptu_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Allo eta too deem dua pentuhu'na Puang Yesus lao lako mesa tondä' isanga Emaus, umbai' sapulo mesa kilo alla'na Yerusalem. ");
INSERT INTO ptu_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Mahassanni mellao, natula'um indo ingganna kaha-kaha to puha dadi. ");
INSERT INTO ptu_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Mahassanni sipa'tula', sule ham Puang Yesus anna mellaoi sola-sola. ");
INSERT INTO ptu_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Muita Puang Yesus sapo' deem ullabai matanna nasuhum tä' naissam. ");
INSERT INTO ptu_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Iya ma'kadam Puang Yesus naua: “Aka hia' iko untula' mahassam mellao?” Iya bassim tohhom, manabo inabanna diita. ");
INSERT INTO ptu_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Ma'tula'um indo mesa isanga Kleopas naua: “Ingganna tau to längäm Yerusalem, umbai' anggam iko tä' muissanni indo kaha-kaha puha dadi yabo sanaka benginna lessu'!” ");
INSERT INTO ptu_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Nakutanaim Puang Yesus naua: “Kaha-kaha aka hia dadi?” Natimba' naua: “Diona indo Puang Yesus to Nazaret, mesa nabi to naponnoi kuasa susi illaam tula'na teem pa'palakoanna dio olona Puang Allataala anna ingganna hupatau. ");
INSERT INTO ptu_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Nabeho ingganna kapala sando anna pepungngu'ta lako to ma'pahenta anna mala natahungkum mate. Iya napäso'im yabo kaju sitambem lambi' mate. ");
INSERT INTO ptu_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Moi kela daa Ia ha kihannuam la ullappasam to Israel. Anna temo allo katallunnam anna dadii kaha-kaha ia too. ");
INSERT INTO ptu_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Mane deenni, sanaka-naka baine illaam kamesaangki sulekam napatikkedu'. Aka bengi-bengipi anna le'ba'um lako indo ku'bu', ");
INSERT INTO ptu_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","sapo' tä'um deem nalambi' bakkena. Iya ma'pasulem anna natulasangkanni naua: ‘Muitakam dua malaika' anna natulasangkam naua: Tubom sule Puang Yesus!’ ");
INSERT INTO ptu_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Iya le'ba' siaham sanaka-naka solaki lako indo lokko' anna nalambi' si'da susi liu indo pa'tula'na baine. Anna pa'dem Puang Yesus nalambi'.” ");
INSERT INTO ptu_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Ma'kadam Puang Yesus naua: “Abana mahokoa'! Aka tä' liupia' mala ungkatappa'i indo tula'na ingganna nabi. ");
INSERT INTO ptu_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Aka tä' daka tia indo To dilanti' la mepasalama' la pahallu ussi'dim yolo ingganna indo pandahhaam mane ullambi'i kamatandeanna?” ");
INSERT INTO ptu_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Mane napomakalesoanni Puang Yesus ingganna indo to puha tisuha' diona kalena illaam Pepaondonganna Musa anna suha'na ingganna nabi. ");
INSERT INTO ptu_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Mahassampi ma'tula', iya la lambi' kalem lako indo tondä' la naongei. Naägä'i lelemmi Puang Yesus la tahhu', ");
INSERT INTO ptu_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","sapo' bassim nakekke' naua: “Tatohhonna' pa'bengi aka la bengim.” Iya tohhom duka' Puang Yesus la ma'bengi sola. ");
INSERT INTO ptu_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Tappana muokko'i la mangngande, iya mualam hoti Puang Yesus anna nasambajannii mane napiä'-piä'i nabeem. ");
INSERT INTO ptu_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Mane naissam di pole' naua Puang Yesus siam ia, sapo' tappa pa'de bäbä naita. ");
INSERT INTO ptu_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Iya sipa'tula'um naua: “Iam päläe' anna susi sugali'um tialanna inabanta indo sipa'tula'kia' muola lalam anna napomakalesoangki' diona issinna Battakada Debata!” ");
INSERT INTO ptu_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Wattu eta too tappa ke'de' siaham mengkalao längäm Yerusalem indo to dua. Sulei längäm, nalambi'um indo to sapulo mesa passikola anna ingganna solana mahassam ma'hempum. ");
INSERT INTO ptu_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Ma'kada indo to ma'hempum naua: “Abana tubo si'dam sule Debata aka puham umpellambi'i Simon.” ");
INSERT INTO ptu_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Iya tappa natula'um duka' indo to dua diona indo puha dadi illaam pa'laoanna. Anna nauapi duka': “Ia ham mane kiissanni kiua Puang Yesus dia, tappana umpiä'-piä' indo hoti.” ");
INSERT INTO ptu_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Mahassam siapi sipa'tula'-tula', pissananna ke'de'-ke'de' bäbä ham Puang Yesus illaam alla'-alla'na anna ma'kadai naua: “Kehongko'koa' anna maupa' nalambi'ungkoa' kamasannangam.” ");
INSERT INTO ptu_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Sangngim tikkedu' anna mahea' aka nasanga anitu. ");
INSERT INTO ptu_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Sapo' ma'kada Puang Yesus naua: “Akanna mahea'koa'? Akanna bata-bataia' penabammu? ");
INSERT INTO ptu_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Petua' siaia' inde limangku sola pala' bitti'ku. Aka Kao hi to Kao. Haka'ä' ammu pengkalesoiä' anna muissam manappaia'. Aka anitu ia tä' deem balena anna tä' deem bukunna. Sisala inde muitaä' temo.” ");
INSERT INTO ptu_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Puhai naua, iya umpa'paitaammi limanna sola pala' bitti'na. ");
INSERT INTO ptu_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Sapo' tangkaam siapi nakatappa'i, napobua' katilallasanna anna kamängä-mängäanna. Iya mekutanam Puang Yesus naua: “Deem daka kinandemua' inde?” ");
INSERT INTO ptu_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Iya nabeemmi mesa bau tunu. ");
INSERT INTO ptu_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Naalam Puang Yesus anna naandei dio olona passikolanna. ");
INSERT INTO ptu_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Puhai, ma'kada oom naua: “Iam too inde indo kaha-kaha si kutulasangkoa' wattunna anna sola-solapakia', kuua: Ingganna indo puha tisuha' illaam Pepaondonganna Musa, suha'na ingganna nabi, anna illaam suha' Pampujiam diona kaleku tä' mala tala sule lako asam.” ");
INSERT INTO ptu_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Mane sangngim naissam manappa hi pole' kalembasanna issinna Battakada Debata aka nabukkaiammi Puang Yesus pikkihanna. ");
INSERT INTO ptu_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Mane ma'kada pole oi naua: “Puha tisuha'um illaam Battakada Debata naua: To dilanti' la mepasalama' la ussi'dim pandahhaam anna la tibangom sule dio mai kamateam illaam allo katallunna. ");
INSERT INTO ptu_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Anna illaam sanganna pahallu duka' dipa'pakahebaam lako ingganna tau illaam inde lino diua pahallu mengkatoba' hupatau anna mala naampunniam dosana Puang Allataala. Anna ingganna ia too la dipa'pakahebaam napahandu' inde Yerusalem. ");
INSERT INTO ptu_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Ikonna' too la mendadi sa'bi diona kaha-kaha ia too. ");
INSERT INTO ptu_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Anna la kupasuleangkoa' Penaba Maseho to puha nadandi Ambeku. Sapo' la hapa'pokoa' illaam inde kota sule lako napakatoto'koa' indo kakuasaam yabo mai suhuga.” ");
INSERT INTO ptu_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Lessu'i ia too, iya le'ba'um Puang Yesus umpasola passikolanna messubum illaam mai kota anna lakoi mesa ongeam sikahuku' tondä' Betania. Dioi, muäkä'um limanna anna untamba'i passikolanna. ");
INSERT INTO ptu_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Mahassanni natamba', iya tiäkä'um längäm suhuga umpellei passikolanna. ");
INSERT INTO ptu_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Iya sangngim menombam mane ma'pasulei lako Yerusalem naponnoi kakassiam. ");
INSERT INTO ptu_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Anna allo-allo illaam Banua Debata umpuji sanganna Puang Allataala. ");
INSERT INTO ptu_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Wattunna anna tä'pi dipadadi inde lino inna deemmi indo to diuaam Kadanna Debata. Indo Kada ia too inna solam Puang Allataala, anna Ia siam Puang Allataala. ");
INSERT INTO ptu_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Inna silolemmi Ia Puang Allataala mengkalao dio mai. ");
INSERT INTO ptu_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Ia ungkähäi anna deenni ingganna-ingganna sia. Tä' deem aka-aka dipadadi ke tä'i Ia ungkähäi. ");
INSERT INTO ptu_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Ia naongei buttu katuboam anna katuboam ia too umbaba kamasiäsam umballoi ma'hupatau. ");
INSERT INTO ptu_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Kamasiäsam ia too paindo illaam alla'-alla'na kamalillingam anna tä' mala napi'dei kamalillingam. ");
INSERT INTO ptu_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Iya sulem mesa tau nasua Puang Allataala isanga Yohanes ");
INSERT INTO ptu_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","la mendadi sa'bi ussa'bii diona indo kamasiäsam anna mala nahingngi ingganna hupatau nasuhum matappa'. ");
INSERT INTO ptu_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Indo Yohanes taia indo diuaam kamasiäsam sapo' to ussa'bii diona indo kamasiäsam. ");
INSERT INTO ptu_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Aka la sule illaam inde lino indo kamasiäsam si'da-sia ummasiä'i ingganna hupatau. ");
INSERT INTO ptu_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Indo Kadanna Debata tohho inde lino anna Ia siam ungkähäi indo anna dipadadi inde lino. Sapo' moinna anna susi, tä' di naissam to lino. ");
INSERT INTO ptu_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Sule mentama botto litä'na, sapo' natumpu pala' di solana. ");
INSERT INTO ptu_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Sapo' menna-menna untahimai anna ungkatappa'i, tau ia too napadadi änä'na Puang Allataala. ");
INSERT INTO ptu_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Taia kahana pa'padadinna hupatau nasuhum mendadi änä'na Puang Allataala, anna taia toi kahana pa'elo'na battu haka pattujunna hupatau, sapo' pa'elo'na Puang Allataala nasuhum napadadi änä'na. ");
INSERT INTO ptu_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Indo Kadanna Debata mengkubalimmi mendadi hupatau anna tohhom illaam alla'-alla'taa'. Taitam kamatandeanna. Anna kamatandeam ia too namanasam Puang Allataala aka Ia Änä' mesanna. Iam too taongei ungkaleso tongam diona Puang Allataala sola pa'kamasena. ");
INSERT INTO ptu_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Yohanes umpaissanni hupatau diona Kada ia too. Si metamba-tamba naua: “Iam too inde indo si kutula' kuua: ‘Deem la sule ibundingku sapo' matande puha Ia anna la kao, aka tä'pä' kao dadi anna inna deemmi Ia.’” ");
INSERT INTO ptu_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Anna tadisihanteam pa'kamasena napolalam tamonda-monda untamba'kia'. ");
INSERT INTO ptu_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Musa Ia napalandasangkia' pahentana Puang Allataala. Sapo' illaam Yesus Kristus taongei ungkaleso tongam diona Puang Allataala sola pa'kamasena. ");
INSERT INTO ptu_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Tä'pi deem tau moi podo la mesa muita Puang Allataala. Sapo' malakia' muissam Puang Allataala aka Änä' mesanna umpaissannikia', indo to sipadaam Puang Allataala anna to illaam kalena. ");
INSERT INTO ptu_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Susi inde passa'biinna Yohanes diona Puang Yesus. Deem sanaka-naka sando sola pessubunna Lewi nasua to kasallena to Yahudi dio Yerusalem le'ba' umpellambi'i Yohanes anna nakutanai naua: “Mennako iko isanga indee?” ");
INSERT INTO ptu_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Naakui anna nasindohoi Yohanes ma'tula' naua: “Kao-kao taiaä' indo To dilanti' la mepasalama'.” ");
INSERT INTO ptu_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Iya natimba'um naua: “Maka' susi, iya menna hako? Elia hakoka tubo sule?” Natimba' Yohanes naua: “Taia.” Iya mekutana pole oom naua: “Ikongka indo Nabi to puha didandi?” Natimba' oom Yohanes naua: “Taia.” ");
INSERT INTO ptu_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Mane mekutana oi naua: “Menna hako iko setonganna? Tulasangkam anna malai kiissam kitulasam lako to ussuakam. Menna hako iko isanga?” ");
INSERT INTO ptu_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Natimba'i Yohanes naua: “Kaom too indo puha natula' nabi Yesaya naua: ‘Deem to la metamba-tamba dio pohiallasam naua: hampasanni anna ummaloloanganni lalanna Debata.’” ");
INSERT INTO ptu_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Iya mekutana oom sanaka-naka indo pesuana to illaam kakalebuanna Parisi naua: ");
INSERT INTO ptu_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","“Maka' taiako indo To dilanti' la mepasalama', taiako Elia, taia toko indo Nabi to didandi, iya aka hi anna mantedo' dako?” ");
INSERT INTO ptu_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Natimba' Yohanes naua: “Kao-kao uwai kupopantedo', sapo' deemmi illaam alla'-alla'mua' tä'pi muissanna' ");
INSERT INTO ptu_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","ibundi Ia umpalako pengkähänganna. Sapo' moi la kubukkaiam pekapu' sapatunna tala sihatannä'.” ");
INSERT INTO ptu_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Ingganna ia too dadi dio Betania tandai mata allona Salu Yordan indo si naongei Yohanes mantedo'. ");
INSERT INTO ptu_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Masiänai, naitam Yohanes sule Puang Yesus la umpellambi'i. Iya ma'kadam Yohanes naua: “Petua'ia' indem dio indo Änä' Dombana Puang Allataala sule la umpa'dei dosana ma'hupatau. ");
INSERT INTO ptu_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Iam too indo to si kutula' kuua: ‘Deem la sule ibundingku sapo' la matande puha Ia anna la kao, aka tä'pä' kao dadi anna inna deemmi Ia.’ ");
INSERT INTO ptu_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Yolona tä' duka' kuissam kuua Iam too indo To dilanti' la mepasalama'. Sapo' ia anna suleä' umpopantedo' uwai, anna mala naissam to Israel naua Iam too indo To dilanti' la mepasalama'.” ");
INSERT INTO ptu_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","33","Ma'tula' polepi Yohanes ussa'bii naua: “Tä'pi duka' kuissam eta too kuua Puang Yesus-um too indo To dilanti' la mepasalama'. Sapo' Puang Allataala to ussuaä' untedo'i uwai ma'kada naua: ‘Maka' too muitam Penaba Masehona Puang Allataala tuhum hampo lako mesa tau, iya iam too to la umpopantedo' Penaba Maseho.’ Iya deem siam kuita Penaba Maseho tuhum yabo mai suhuga susi dangam-dangam hampo yabona anna tohho illaam kalena. ");
INSERT INTO ptu_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Ma'kalemä' muitai anna kusa'bii kuua Iam too Änä'na Puang Allataala.” ");
INSERT INTO ptu_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Masiäna polei, dio oom indo ongeanna Yohanes sola passikolanna dua. ");
INSERT INTO ptu_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Tappana muita liu Puang Yesus, iya ma'kadam naua: “Petua'i iam too dio indo Änä' Dombana Puang Allataala!” ");
INSERT INTO ptu_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Uhhingnginna tula'na Yohanes indo passikolanna dua, iya tappa le'ba' siahanni untuhu' Puang Yesus. ");
INSERT INTO ptu_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Tappana menggihi' Puang Yesus lako boko'na naitam indo to untuhu'i, iya nakutanaim naua: “Aka umpahalluanna'?” Iya natimba'um naua: “O Rabi, umba ngei si muongei tohho?” (Rabi kalembasanna: Tuangguhu.) ");
INSERT INTO ptu_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Ma'kada Puang Yesus naua: “Maikoa' anna ma'kalekoa' muitai.” Iya le'ba'im duka' sola anna napetua'i indo ongeam si naongei Puang Yesus. Wattu eta too tette' appa'um kahubem, iya tohhopi sola Puang Yesus sule lako bengi. ");
INSERT INTO ptu_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Indo mesa to uhhingngi tula'na Yohanes anna le'ba'i untuhu' Puang Yesus isanga Andreas, solasubunna Simon Petrus. ");
INSERT INTO ptu_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Iya tappa le'ba' siaham Andreas umpeä Simon anna napa'tulasanni naua: “Silambi'ungkam kami' indo Mesias,” (battu diua To dilanti' la mepasalama'). ");
INSERT INTO ptu_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Iya umpasolam Simon le'ba' umpellambi'i Puang Yesus. Sulei lako, napetua'-tua'um Puang Yesus anna napa'kadai naua: “Iko-iko Simon änä'na Yohanes, la disangaingko Kepas.” (Kepas illaam basana to Yahudi ditula' Petrus ia illaam basa Yunani. Kalembasanna: batu.) ");
INSERT INTO ptu_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Masiänai, mualam kattuam Puang Yesus la lako Galilea. Tä'pi mengkalao anna sitammum Filipus, iya nauaammi: “Maiko tuhu'ä'.” ");
INSERT INTO ptu_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Indo Filipus to buttu dio mai Betsaida kota kadadianna Andreas sola Petrus. ");
INSERT INTO ptu_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Iya le'ba'um Filipus umpellambi'i Natanael anna natulasanni naua: “Silambi'ungkam kami' indo to si natula' Musa illaam suha' pepaondonganna anna si napa'paissangam duka' ingganna nabi. Iam too indo to buttu dio mai Nazaret, änä'na Yusuf isanga Puang Yesus.” ");
INSERT INTO ptu_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Natimba' Natanael naua: “La deem daka tia to mapia buttu illaam mai tondä' Nazaret?” Nauam Filipus: “Maiko anna ma'kaleko iko duka' muitai.” ");
INSERT INTO ptu_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Naitanna Puang Yesus sule Natanael umpellambi'i, iya ma'kadam untula' diona Natanael naua: “Petua'ia' inde dio, mesa tungka to Israel to malolo penaba.” ");
INSERT INTO ptu_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Iya tappa mekutana Natanael lako naua: “Maaka hia susi anna malaä' muissam?” Natimba'i Puang Yesus naua: “Indo anna tä'poko natambai Filipus, iya kuitako illaam kakuasaangku muokko' dio ibi'na kaju ara.” ");
INSERT INTO ptu_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Mane ma'kadai Natanael lako Puang Yesus naua: “O Tuangguhu, Änä'nako Puang Allataala! Tomahajanna si'dangko to Israel!” ");
INSERT INTO ptu_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Natimba' Puang Yesus naua: “Matappa' dakoka aka kutulasangko kuua puhangko kuita dio ibi'na indo kaju ara? La deem polepi too muita dako' kaha-kaha memängä-mängä puha anna ia too. ");
INSERT INTO ptu_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Aka setongam-tonganna la muitakoa' langi' tibukka anna buda malaika'na Puang Allataala ma'sinule lu längäm lu yabo mai, Kao Änä' Mentolino napoeham.” ");
INSERT INTO ptu_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Dua bengii lessu'na ia too deem kakabengam dio Kana, lembäna Galilea. Anna indo kakabengam ia too lao duka' nalomba indona Puang Yesus. ");
INSERT INTO ptu_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Diuaam duka' Puang Yesus sola ingganna passikolanna. ");
INSERT INTO ptu_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Tappana naita indona puham anggurna indo puäna saha, iya umpa'tula'im Puang Yesus naua: “Tappu'um anggurna.” ");
INSERT INTO ptu_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Iya natimba'im naua: “Akanna Kaoi muuaam indo'? Tä'pi lambi' wattunna la umpa'paissangannä' kaleku.” ");
INSERT INTO ptu_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Iya umpa'tula'im ingganna to ma'tahia indona Puang Yesus naua: “Iai too napahesangkoa', ianna' untuhu'i.” ");
INSERT INTO ptu_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Eta too deem annam busso batu dipatoka si dipa'pengngei uwai si napembase to Yahudi situhu' kabiasaanna. Issinna indo mesa busso kiha-kiha la si sahatu' lite'. ");
INSERT INTO ptu_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Nauam Puang Yesus lako indo to ma'tahia: “Ponnoi asannia' uwai itim matim busso.” Iya naponnoi asammi duka'. ");
INSERT INTO ptu_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Puhai, naua oom Puang Yesus lako indo to ma'tahia: “Seosanni kapalana hame-hame itim uwai anna umbeenni.” Iya nababaammi lao indo kapalana hame-hame ");
INSERT INTO ptu_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","anna nasändä'i indo uwai mengkubalimmi mendadi anggur. (Sapo' tä' ia naissam kapalana hame-hame kabuttuanna indo anggur ia too. Anggam to usseo'i indo uwai muissanni). Puhai nasändä', iya untambai siaham indo muane to mahassam dipakebaine ");
INSERT INTO ptu_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","anna nauaanni: “Biasanna si napayolo to muola saha anggur handam mapia napaihusam tosabena. Nasanta'pi mane dibeenni anggur biasa. Sapo' iko-iko, deem liupi anggur handam mammi' umpatoka sule lako temo.” ");
INSERT INTO ptu_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Iam too uhu-uhuna tanda memängä-mängä napogau' Puang Yesus. Kaha-kaha ia too napogau' dio Kana lembäna Galilea. Napateemmi too umpa'paitaam kamatandeanna anna nakatappa'i ingganna passikolanna. ");
INSERT INTO ptu_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Puhai ia too, le'ba'um Puang Yesus dokko Kapernaum sola indona, ingganna solasubunna muane, anna ingganna passikolanna. Tohhoim dio sanaka-naka benginna. ");
INSERT INTO ptu_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Tappana la mahuku'i wattunna napakahoa' to Yahudi allo Kalappasanna dio mai kasabuasam, iya le'ba'um Puang Yesus längäm Yerusalem. ");
INSERT INTO ptu_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Sulei längäm ullambi'um Banua Debata naongei buda pa'balu' sapim anna pa'balu' domba, sola pa'balu' dangam-dangam. Buda toi tau muokko' umpa'pesukasam doi'na. ");
INSERT INTO ptu_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Umpapia siaham pesämbä' kahahham Puang Yesus anna nahahi asanni illaam mai Banua Debata indo ingganna olo'-olo' susi sapim teem domba. Anna napembalisanni ingganna mejana to si umpa'pesukasam doi' lambi' titantam asam lao indo doi'na. ");
INSERT INTO ptu_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Mane ma'kadai lako indo pa'balu' dangam-dangam naua: “Baba asannia' lao, daa umpadadi pasa'a' Banuanna Ambeku!” ");
INSERT INTO ptu_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Iya nakilalaim indo ingganna passikolanna issinna Battakada Debata naua: “O Puang Allataala, pangkaha'ku lako Banuammu la umpatatta' penabangku.” ");
INSERT INTO ptu_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Iya buda to kasallena to Yahudi umbali-bali Puang Yesus naua: “Paitaipakanni tanda memängä-mängä anna mala tandaam lako kami' kiua abana muampuam si'dako kakuasaam!” ");
INSERT INTO ptu_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Natimba'i Puang Yesus naua: “Kadakeannia' inde Banua Debata anna kupake'de'i sule illaam allo katallunna.” ");
INSERT INTO ptu_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Iya nauaim indo to Yahudi: “Appa' pulo annam taunna diolaam umpapiai inde Banua Debata, iya la mala iko tallungngallo muolaam umpake'de' sule?” ");
INSERT INTO ptu_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Sapo' indo nauaam Puang Yesus Banua Debata kalena hi tia. ");
INSERT INTO ptu_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Puha ham dipatibangom Puang Yesus dio mai alla'-alla'na to mate mane nakilalai ingganna passikolanna naua: “Puha siam tia naua.” Mane nakatappa'i hi pole' passikolanna issinna Battakada Debata anna ingganna kada puha natula' Puang Yesus. ");
INSERT INTO ptu_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Mahassanni umpakahoa' allo Kalappasam Puang Yesus yabo Yerusalem, iya buda tau ungkatappa'i aka deem tanda memängä-mängä napogau'. ");
INSERT INTO ptu_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Sapo' tä' Ia nakannangam Puang Yesus naua: “Nakatappa'i tongannä' indo tau buda,” aka ullosa Ia tama issi penabanna ingganna hupatau. ");
INSERT INTO ptu_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Tä'um pahallu la dipomasiäsam diona hupatau aka nalosam Puang Yesus tama issi penabanna. ");
INSERT INTO ptu_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Deem mesa tau isanga Nikodemus. Indo Nikodemus mesa to illaam kakalebuanna Parisi anna duka' mesa to kasallena to Yahudi. ");
INSERT INTO ptu_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Pissam wattu bengi le'ba' umpellambi'i Puang Yesus anna nauaanni: “O Tuangguhu, kiissammi kiua Iko to nasuako Puang Allataala aka abana tä' deem moi podo la mesa tau la mala umpogau' tanda memängä-mängä umba susi puha umpadadi ke tä'i nasahum Puang Allataala.” ");
INSERT INTO ptu_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Natimba'i Puang Yesus naua: “Setongam-tonganna tä' deem moi podo la mesa tau la mala mendadi umma' petauam illaam kapahentaanna Puang Allataala ke tä'i didadiam pole.” ");
INSERT INTO ptu_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Naua oom Nikodemus lako Puang Yesus: “La maakam ia susi, la mala haka tia mesa tomatua ma'pasule tama tambu'na indona mane disubungam polei!” ");
INSERT INTO ptu_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Iya natimba'i oom Puang Yesus naua: “Setongam-tonganna maka' deem tau tä' didadiam dio mai uwai anna Penaba Maseho, tau ia too tä' ia la mala mendadi umma' petauam illaam kapahentaanna Puang Allataala. ");
INSERT INTO ptu_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Bätä puntinna hupatau nadadiam tomatuanna, sapo' bätä sungnga'na nadadiam pole Penaba Maseho. ");
INSERT INTO ptu_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Tä'ko la mängä-mängä ke kuuaangko: la pahallukoa' didadiam pole. ");
INSERT INTO ptu_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Aka la susi hibu' ma'simbuhu' le'ba' untuhu'i pa'elo'na. Uhhingngia' uhhunna sapo' tä' muissanna' buttu umba ngei anna la lu umba ngei. Iya susim too duka' lako to nadadiam pole Penaba Maseho.” ");
INSERT INTO ptu_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Iya mekutana pole oom Nikodemus naua: “Akanna la malai dadi susi itim?” ");
INSERT INTO ptu_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Natimba'im Puang Yesus naua: “Iko mesako duka' tuangguhu malangka' dio Israel, akanna la tä' di iko muissam? ");
INSERT INTO ptu_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Kutulasangko setonganna, anggam kitula' anna kisa'bii indo kiissanna anna kiitanna. Sapo' mokakoa' ungkatappa'i tula'ki. ");
INSERT INTO ptu_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Kutulasammokoa' diona kaha-kaha inde lino anna tä' siam ungkatappa'ia'. Iya la maakam ia susi la ungkatappa'ia' ke kutulasangkoa' kaha-kaha diona suhuga? ");
INSERT INTO ptu_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Tä'pi deem mesa hupatau puha längäm suhuga, sapo' Kao, Änä' Mentolino, buttu yaboä' mai suhuga mentama lino. ");
INSERT INTO ptu_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Umba susi ula' gällä puha natandeam Musa yabo mesa kaju naosä' dio pohiallasam, la susimä' too duka' Kao, Änä' Mentolino la ditandeam, ");
INSERT INTO ptu_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","anna mala ingganna hupatau to ungkatappa'iä' la ullambi' katuboam sule lako salako-lakona.” ");
INSERT INTO ptu_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Aka tä' deem pada sakasalle pa'kamasena Puang Allataala lako ma'hupatau illaam inde lino nasuhum umpebeem Änä' mesanna, anna mala ingganna to ungkatappa'i tä'um la mate sungnga'na, sapo' la ullambi' katuboam sule lako salako-lakona. ");
INSERT INTO ptu_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Aka taia pattujunna Puang Allataala ussua Änä'na mentama inde lino la umpassala hupatau, sapo' sule hi tia la mepasalama'. ");
INSERT INTO ptu_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Ingganna to matappa' lako Änä'na Puang Allataala tä' ia la dipassala. Sapo' ingganna to tä' matappa' napassalam ia Puang Allataala aka tä' ia matappa' lako Änä' mesanna. ");
INSERT INTO ptu_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Ia anna dipassalai tau ia too aka mentamam inde lino indo Kamasiäsam sapo' umpohäe leko' ia kamalillingam aka pa'palakoanna hupatau kadake. ");
INSERT INTO ptu_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Menna-menna umpogau' kakadakeam, tau ia too ungkahidi' kamasiäsam anna moka lako, indana tandaanni gau' kadakena. ");
INSERT INTO ptu_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Sapo' lako hupatau to manontom umpogau' pa'elo'na Puang Allataala, lu tama ia kamasiäsam anna mala tandaam diua situhu' ia pa'elo'na Puang Allataala pa'pogausanna. ");
INSERT INTO ptu_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Puhai ia too, le'ba'um lako Yudea Puang Yesus sola ingganna passikolanna anna tohhoi masäe-säe dio napasindum mantedo'. ");
INSERT INTO ptu_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Anna Yohanes ia mantedo' duka' dio Ainon sikahuku' Salim aka buda uwai eta. Sule liu buda tau anna natedo'i. ");
INSERT INTO ptu_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","(Tä'pi ditahungkum Yohanes wattu eta too.) ");
INSERT INTO ptu_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Wattu eta too deem sanaka-naka passikolanna Yohanes sipengka mesa to Yahudi diona kabiasaam kamapattingam illaam peadasam. ");
INSERT INTO ptu_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Iya umpellambi'im Yohanes anna nauaanni: “O Tuangguhu, ungkilalaipaka Puang Yesus indo to umpasola dipe lambam libanna Salu Yordan, indo untulasangkam? Iya si mantedo'um duka' temo anna budam tau le'ba' lako.” ");
INSERT INTO ptu_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Natimba'im Yohanes naua: “Tä' deem aka-aka la mala dadi ke tä'i buttu yabo mai Puang Allataala. ");
INSERT INTO ptu_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Puha sianna' uhhingngi indo kuua: kao-kao taiaä' indo To dilanti' la mepasalama', sapo' disuaä' mendiolo la umpatokaanni lalam. ");
INSERT INTO ptu_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Aka sihhapam to dipakabem: Indo baine to mahassam dipakabem, muanena muampuanni. Anna sammuanena indo muane anggam tia ke'de' dio ampe'na ma'pehingngi. Anna tä' deem pada satilalla' uhhingngi tula'na indo sammuanena to mahassam dipakabem. Iya susimä' too duka' temo aka sihhapannä' sammuanena indo muane to dipakabem, sumpu katilallasangku. ");
INSERT INTO ptu_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Temo la Iam dipaitoo'na anna kao-kao la tuttuam tä'um.” ");
INSERT INTO ptu_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Puang Yesus buttu yabo mai suhuga kasalle puha Ia anna la ingganna-ingganna sia. Anna iai too buttu illaam mai inde lino iam disangai to lino. Si ma'tula' ia diona kaha-kaha di lino. Puang Yesus buttu yabo mai suhuga untondom ingganna-ingganna sia. ");
INSERT INTO ptu_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Natula' asammi ingganna naitanna anna nahingnginna, sapo' tä' deem moi podo la mesa tau ungkatappa'i indo tula'na. ");
INSERT INTO ptu_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Menna-menna ungkatappa'i indo tula'na Puang Yesus, tau ia too muangga' malolo Puang Allataala, ");
INSERT INTO ptu_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","aka Puang Yesus puha nasua Puang Allataala umpalanda' kadanna. Ia anna napalanda'i aka napaponnoi Puang Allataala Penaba Masehona. ");
INSERT INTO ptu_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Puang Allataala Ambeta ungkamasei Änä'na anna puham napadokkoam asam lisu pala'na ingganna kakuasaam. ");
INSERT INTO ptu_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Menna-menna matappa' lako Änä'na Puang Allataala, ullambi'um ia katuboam sule lako salako-lakona. Anna menna-menna tä' manuhu' lako, tä' ia la ullambi' indo katuboam. Sapo' tontä liu ia nahua aha'na Puang Allataala. ");
INSERT INTO ptu_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Napekaheba asam to illaam kakalebuanna Parisi naua tuttuam buda tau umpellambi'i Puang Yesus anna natedo'i lambi' buda puha ia passikolanna anna la Yohanes. ");
INSERT INTO ptu_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(Setonganna tä' deem ma'kale Puang Yesus mantedo', sapo' passikolanna mandi mantedo'.) ");
INSERT INTO ptu_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Tappana naissam Puang Yesus naua napekahebam to illaam kakalebuanna Parisi diona kaha-kaha ia too, iya umpelleim lembäna Yudea anna ma'pasulei lako lembäna Galilea. ");
INSERT INTO ptu_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Indo illaam pellaoanna Puang Yesus tä' mala tala muolai lembäna Samaria. ");
INSERT INTO ptu_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Iya dioi Samaria ullambi'um mesa kota isanga Sikhar sikahuku' indo litä' napa'manasam Yakub lako änä'na isanga Yusuf. ");
INSERT INTO ptu_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Dio ongeam eta too deem mesa bujum disangai bujunna Yakub. Tä' deem pada samalupu'um Puang Yesus mellao, iya muokko'um dio ampe'na indo ba'ba bujum. Wattu eta too umbai' la tette' sapulo duam iallo. ");
INSERT INTO ptu_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Tahhu' ia passikolanna lako kota mualli kinande. Pissananna sulem mesa baine to Samaria la tumimba. Ma'kadam Puang Yesus naua: “Indo', mala haka umbeennä' itim uwai kuihu'?” ");
INSERT INTO ptu_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Natimba'um indo baine naua: “O Tuam, iko to Yahudiko anna kao to Samariaä', akanna umpelau hä' kao uwai?” (Ia anna ma'kada susii aka si moka to Yahudi la deem kasilombunganna to Samaria.) ");
INSERT INTO ptu_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Natimba'im Puang Yesus naua: “Setonganna kela muissangko indo pa'pebeenna Puang Allataala anna menna umpelauiko uwai, tä' mala tala iko umpelauiä' uwai anna la kubeengko uwai katuboam.” ");
INSERT INTO ptu_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Natimba'i indo baine naua: “O Tuam, tä' deem peseo'mu anna inde bujum tä' deem pada samandalam. Iya la muala umbam iko ngei indo uwai katuboam? ");
INSERT INTO ptu_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Yakub nene to kiponene iam too umbeengkanni inde bujum. Si naala eta duka' inde uwai naihu', susi ingganna änä'na teem olo'-olo'na. Ussanga haka too kasalle puhako iko anna la Yakub?” ");
INSERT INTO ptu_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Iya nauam Puang Yesus: “Menna-menna muihu'i inde uwai bujum la tontä liu ia ussi'dim kamabähhängam. ");
INSERT INTO ptu_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Sapo' iai too muihu' indo uwai la kubeem tä'um ia deem la ussi'dim kamabähhängam sule lako salako-lakona. Aka indo uwai la kubeem la mendadim kalimbuä tamatti' illaam kalena la umbeenni katuboam sule lako salako-lakona.” ");
INSERT INTO ptu_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Natimba' indo baine naua: “O Tuam, beennä' kao indo uwai anna mala tä'mä' si mabähhäm, anna tä'mä' manggi' sule liu tumimba eta inde.” ");
INSERT INTO ptu_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Ma'kada oom Puang Yesus naua: “Laoko tambai muanemu ammu sulea' eta inde.” ");
INSERT INTO ptu_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Iya nauam indo baine: “Aka tä'um deem muaneku.” Ma'kada pole oom Puang Yesus naua: “Tappa' tula'mu. ");
INSERT INTO ptu_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Aka iko pellimangko kemuane, anna indo muane umpasola temo taia muanemu. Dadi indo tula'mu ingngena' tappa'.” ");
INSERT INTO ptu_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Iya nauam indo baine: “O tuam, kuissammi pole' kuua Iko mesako nabi. ");
INSERT INTO ptu_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Indo nene to kiponene sangngim umpenombai Puang Allataala eta inde tanete. Sapo' ikoa'-iko to Yahudi si muuaa': ‘Anggam yabo Yerusalem mala naongei hupatau menomba längäm Puang Allataala.’” ");
INSERT INTO ptu_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Ma'kada pole oom Puang Yesus naua: “O indo', katappa'iä' aka pissam wattu tä'um la angga eta inde tanete la naongei hupatau umpenombai Ambeta, anna tä' toi la anggam yabo Yerusalem. ");
INSERT INTO ptu_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Ikoa'-iko to Samaria umpenombaikoa' to tamuissam, sapo' kami'-kami' to Yahudi si umpenombaikam to kiissam, aka kasalamasam buttu dio mai to Yahudi. ");
INSERT INTO ptu_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Sapo' la deem wattunna ingganna tau to menomba si'da-sia la umpenombai Ambeta sola unä' penabanna situhu' kamaloloam. Anna wattu ia too sulem. Aka abana inna to menomba susi ia too napohäe Ambeta Puang Allataala. ");
INSERT INTO ptu_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Abana Puang Allataala Ia mempenaba. Dadi ingganna tau to la menomba lako, pahallu menomba sola unä' penaba situhu' kamaloloanna Puang Allataala.” ");
INSERT INTO ptu_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Iya naua oom indo baine: “Kuissam duka' kuua la sule To dilanti' la mepasalama', indo si diuaam Kristus. Maka' sulem, la napaissanni asangkia' ingganna-ingganna sia.” ");
INSERT INTO ptu_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Iya nauam Puang Yesus: “Kaom too inde, to umpa'tula'iko.” ");
INSERT INTO ptu_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Iya sulei siaham duka' passikolanna. Sangngim mängä-mängä muita Puang Yesus sipa'tula' baine. Sapo' tä' deem moi podo la mesa ungkutanai naua: “Aka umpahalluam?” battu haka la naua: “Akanna sipa'tula'koa' inde dio baine?” ");
INSERT INTO ptu_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Iya umpellei bäbäm timbaanna indo baine dio ampe' bujum, anna le'ba'i lako kota umpa'tulasam ingganna solana naua: ");
INSERT INTO ptu_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Maikoa' talao pellambi'i indo tau to untulasam asannä' pa'pogausangku lessu'. Umbai' la iangka indo To dilanti' la mepasalama'?” ");
INSERT INTO ptu_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Iya le'ba'im indo issinna kota lao umpellambi'i Puang Yesus. ");
INSERT INTO ptu_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Tappana le'ba' indo baine lako kota, iya nauaammi passikolanna: “O Tuangguhu, maingko tapangngandea'.” ");
INSERT INTO ptu_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Sapo' naua hi Puang Yesus: “Deem siam Kao duka' kinandeku tä' muissanna'.” ");
INSERT INTO ptu_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Iya sipa'tula'-tula'um indo passikolanna naua: “Deem siangka tia umbai' umbabaanni sule kinande?” ");
INSERT INTO ptu_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Naua oom Puang Yesus: “Indo Kao kinandeku, la untuhu'iä' pa'elo'na To ussuaä' anna la kupasuppi' indo pengkähängam puha nabeennä'. ");
INSERT INTO ptu_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Si naua tau: ‘Appa'pi bulanna mane pepaheanni,’ sapo' kutulasangkoa': pahandannia' ingganna uma sangngim matässä'um pahena la malam dipepahe. ");
INSERT INTO ptu_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Napahandu'um to mepahe la untahima sahona nasuhum ingganna to mangngambo' anna to mepahe pada-pada masannam nalambi' bua pengkähäna. Indo bua pengkähä kalembasanna to ullambi' katuboam sule lako salako-lakona. ");
INSERT INTO ptu_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Abana tappa' indo tula'na tomatua naua: ‘Senga' to mangngambo' senga' to umpepahei.’ ");
INSERT INTO ptu_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Kusuakoa' lao umpepahe uma taikoa' muambo'i. Aka tau senga' ungkähäi anna mala ikoa' nalambi' bua pengkähäna.” ");
INSERT INTO ptu_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Dadi buda to Samaria issinna indo kota matappa' lako Puang Yesus aka naua indo baine: “Natulasannä' ingganna pa'pogausangku indo puha kupogau'.” ");
INSERT INTO ptu_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Nasuhum silambi'i indo to Samaria Puang Yesus, iya napelauim anna mala tohhopi. Lambi' tohhopi duka' dua bengi eta too. ");
INSERT INTO ptu_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Iya tuttuam budam tau matappa' lako Puang Yesus aka nahingngim indo pepa'guhuanna. ");
INSERT INTO ptu_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Sangngim naua pole' lako indo baine: “Temo matappa'kam taia kahana indo mandi pa'tula'mu. Sapo' aka kihingngim sola talingangki, kiita sola matangki, anna kiissammi kiua abana Ia To la umpasalama' issinna inde lino.” ");
INSERT INTO ptu_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Tappana dua bengi tohho Puang Yesus dio Samaria, iya le'ba'um lako Galilea. ");
INSERT INTO ptu_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","(Abana deemmi naua Puang Yesus: “Mesa nabi tä' si dipa'kasallei illaam botto litä'na.”) ");
INSERT INTO ptu_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Sulei lako Galilea Puang Yesus, iya sangngim tilalla' to dio untahima manappai aka naita asammi indo napogau' yabo Yerusalem wattunna allo Kalappasam. Aka längänni duka' indo tau ma'pakahoa'. ");
INSERT INTO ptu_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Iya ma'pasulem Puang Yesus lako Kana dio Galilea indo naongei umpopengkubalim uwai mendadi anggur. Wattu eta too dio kota Kapernaum deem mesa to dipake mahassam masaki änä'na. ");
INSERT INTO ptu_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Tappana nahingngi diua sulem Puang Yesus dio mai Yudea, iya le'ba' siaham napellambi'i anna mengkahumase-masei melau naua: “Kela mala, ullombannä' änä'ku lako Kapernaum anna umpabonosannä' aka diampaim penabanna.” ");
INSERT INTO ptu_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Iya ma'kadam Puang Yesus lako indo tau naua: “Maka' tä'koa' si muita tanda memängä-mängä, iya si tä'koa' matappa'.” ");
INSERT INTO ptu_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Iya naua oom indo to dipake: “O Tuam kamaseiä', lombannä' änä'ku sumala illaampi penaba.” ");
INSERT INTO ptu_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Iya naua pole oom Puang Yesus: “Laongko, aka bono'um indo änä'mu.” Sampe ungkatappa'i tula'na Puang Yesus indo tau anna le'ba'i. ");
INSERT INTO ptu_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Mane muola lalam anna sitammum sanaka-naka sabua'na, iya nauaammi: “Bono'um indo änä'mu.” ");
INSERT INTO ptu_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Iya mekutanam lako indo to untammui naua: “Tette' sanaka anna bono'i?” Nauaim: “Tette' mesa loe allo isamai' anna bono'i lalla'na.” ");
INSERT INTO ptu_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Nakilalai siaham ambena indo änä'-änä', aka wattu etam too anna nauaanni Puang Yesus: “Bono'um änä'mu.” Nasuhum matappa' asam sahapunna lako Puang Yesus. ");
INSERT INTO ptu_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Iam too tanda memängä-mängä kapenduanna napogau' Puang Yesus dio Galilea sule polena dio mai Yudea. ");
INSERT INTO ptu_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Puhai ia too le'ba'um Puang Yesus längäm Yerusalem aka la ungkadioi heem mesa allo kasallena to Yahudi. ");
INSERT INTO ptu_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Yabo Yerusalem sikahuku' Ba'ba Domba deem mesa limbä disangai illaam basa Ibrani Betesda, lima sahia'na. ");
INSERT INTO ptu_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Dio indo sahia'na buda to masaki metindo; deem to buta, deem to kempo' anna deem to mate kalena. Indo to masaki muampai passe'bo'na indo limbä. ");
INSERT INTO ptu_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Aka si deem wattunna sule mesa malaika'na Puang Allataala dio indo limbä anna napopasse'bo'i uwainna. Anna iai too yolo indo to masaki dokko ke passe'bo'um, iya iam bono' moi maaka susi sakinna. ");
INSERT INTO ptu_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Dio indo ampe' limbä deem mesa muane tallu pulom kahua taunna masaki. ");
INSERT INTO ptu_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Tappana naita Puang Yesus indo to masaki anna naissam toi naua masäem masaki, iya nakutanaim naua: “Maelo'ko la bono'?” ");
INSERT INTO ptu_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Natimba'im indo to masaki naua: “O Tuam, aka tä' deem tau umpadokkoä' inde dio limbä ke passe'bo' oom. Aka mane si kupenandai la dokko anna nayoloi ohamä' tau senga'.” ");
INSERT INTO ptu_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Iya naua oom Puang Yesus lako indo tau: “Bangongko, babai ampa'mu ammu pellao.” ");
INSERT INTO ptu_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Iya tappa bono' siaham indo tau. Iya umbabam ampa'na anna mellaoi. Kaha-kaha ia too dadi illaam allo Katohhoam ");
INSERT INTO ptu_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","nasuhum nauaam to kasallena to Yahudi indo to mane bono': “Tentomai allo Katohhoam. Dadi tä'ko mala umbaba ampa'mu.” ");
INSERT INTO ptu_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Sapo' naua indo tau: “Aka indo hi tia to umpabono'ä' ingngena' ussuaä' naua: ‘Babai ampa'mu ammu pellao.’” ");
INSERT INTO ptu_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Nakutanaim naua: “Menna indo ussuako naua: ‘Babai ampa'mu ammu pellao?’” ");
INSERT INTO ptu_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Sapo' tä' naissam indo to mane bono' menna indo to umpabono'i, aka mengkapa'de bäbäm Puang Yesus illaam alla'-alla'na tau buda. ");
INSERT INTO ptu_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Dako'i, sitammum Puang Yesus indo tau illaam Banua Debata, iya nauaammi: “Temo bono'ungko. Dadi tä'ungko la umpogau' pole dosa, indana deenni napolalam nahua poleko mabanda' puha ia anna indo sakimmu lessu'.” ");
INSERT INTO ptu_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Iya le'ba' siaham indo tau anna natulasanni to kasallena to Yahudi naua: “Puang Yesus dia indo to umpabono'ä'.” ");
INSERT INTO ptu_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Napolalam sangngim napahandu'um pole' undahha Puang Yesus aka keaha' umpabono' tau illaam allo Katohhoam. ");
INSERT INTO ptu_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Iya ma'kadam Puang Yesus naua: “Ambeku mengkähä liu sule lako temo anna mengkähä liuä' duka'.” ");
INSERT INTO ptu_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Tula' iam too napolalam to kasallena