﻿USE sofia;
DROP TABLE IF EXISTS sofia.ptp_vpl;
CREATE TABLE ptp_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES ptp_vpl WRITE;
INSERT INTO ptp_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Yesu Kɨlisi tɨvae bue he lê yêp ga. Devit pum lec Eblaham dɨ Yesu pum lec Devit. ");
INSERT INTO ptp_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Eblaham nu Aisak. Dɨ Aisak nu Jekop. Dɨ Jekop nu Yuda he lie. ");
INSERT INTO ptp_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yuda nu Peles yuu Sila wê ta Tema ge. Dɨ Peles nu Heslon. Dɨ Heslon nu Lam. ");
INSERT INTO ptp_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Dɨ Lam nu Aminadap. Dɨ Aminadap nu Nason. Dɨ Nason nu Salmon. ");
INSERT INTO ptp_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Dɨ Salmon nu Boas wê ta Lehap ge. Dɨ Boas nu Obet wê ta Lut ge. Dɨ Obet nu Jesi. ");
INSERT INTO ptp_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Dɨ Jesi nu Devit wê tu Islel nên king. Dɨ Devit nu Solomon. Solomon ta ge wê lɨya Yulaia. ");
INSERT INTO ptp_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Dɨ Solomon nu Liaboam. Dɨ Liaboam nu Abaisa. Dɨ Abaisa nu Esa. ");
INSERT INTO ptp_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Dɨ Esa nu Jehosapat. Dɨ Jehosapat nu Jolam. Dɨ Jolam nu Asaia. ");
INSERT INTO ptp_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Dɨ Asaia nu Jotam. Dɨ Jotam nu Ehas. Dɨ Ehas nu Hesekaia. ");
INSERT INTO ptp_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Dɨ Hesekaia nu Manasa. Dɨ Manasa nu Emos. Dɨ Emos nu Josaia. ");
INSERT INTO ptp_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Dɨ Josaia nu Jekonaia he lie wê tɨbii Babilon vông vevac vô he dɨ hôm he Islel vɨhati xôn dɨ kô he mɨ la vac vɨgwe Babilon nêb he i vông yuac pɨleva vô he mɨ dô. ");
INSERT INTO ptp_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","He dô vac vɨgwe Babilon dɨ Jekonaia nu Sialtiel. Dɨ Sialtiel nu Selababel. ");
INSERT INTO ptp_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Dɨ Selababel nu Abaiat. Dɨ Abaiat nu Elaiakim. Dɨ Elaiakim nu Eso. ");
INSERT INTO ptp_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Dɨ Eso nu Sedok. Dɨ Sedok nu Ekim. Dɨ Ekim nu Elaiat. ");
INSERT INTO ptp_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Dɨ Elaiat nu Eliesa. Dɨ Eliesa nu Matan. Dɨ Matan nu Jekop. ");
INSERT INTO ptp_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Dɨ Jekop nu Josep wê vɨnê Malia. Dɨ Malia kô nu Yesu wê he nêl lê ên nêbê Kɨlisi. ");
INSERT INTO ptp_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Om bue wê pum lec Eblaham dɨ i la tyip vô Devit ge, he tɨyi xocbê vɨgê yuu dɨ tô mɨ la yuudɨyuu (14). Dɨ bue wê pum lec Devit dɨ i la tyip vô buc wê tɨbii Babilon vông vevac vô he Islel dɨ kô he mɨ la vɨgwe Babilon ge, he tɨyi xocbê 14. Dɨ bue wê dô vô buc wê he Islel dô vac vɨgwe Babilon dɨ i la tyip vô Kɨlisi buc ge, he tɨyi xocbê 14 êno. ");
INSERT INTO ptp_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Kɨyang lec wê Yesu Kɨlisi yubac ge bêga ên nêbê xomxo vɨnoo nêb Malia ob kô Josep. Lêc yuu gên o kôma lêm, dɨ he yê wê Malia xêyaa ge, lêc ge yuac wê Myakɨlôhô Ngɨbua vông. ");
INSERT INTO ptp_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Malia lɨya Josep ge xomxo nivɨha, om nêb ob vông Malia ni yoc vô xomxo manôn lêm, om xo ên nêb ob sea Malia lê, lêc nêb ob nêl kɨyang wê nu dô vac Malia xêyaa ge kɨtong vô xomxo tɨbeac lêm. ");
INSERT INTO ptp_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Josep gên dɨxo kɨyang wê nêb ob sea Malia ge vac nɨlô, mêdêc Apumtau vông angela ti lam nêl kɨyang vô Josep vac vɨvia bêga ên nêbê, “Devit nu Josep, le i lêc xona ên wê ông ob kô Malia ge lêm, ên nipwo wê Malia ob kô ge Myakɨlôhô Ngɨbua vaci vông vô Malia. ");
INSERT INTO ptp_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Om Malia ob kô nu tuc, dɨ ông ob nêl i lê ên nêbê Yesu, ên lê tige kehe bêga nêbê obêc vô lie vêx yuu vux vêl ên he nên nipaên.” ");
INSERT INTO ptp_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Angela nêl bêge, om kɨyang wê Apumtau nêl vô plopete ti ilage vô nôn lec. Plopete tige nêl bêga ên nêbê, ");
INSERT INTO ptp_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Wê lê. Vêxwo ti ob xêyaa dɨ kô nu ti dɨ ob nêl i lê nêbê Emanyuel.” Plopete nêl bêge, dɨ lê Emanyuel kehe bêga nêbê Anutu dô hɨxôn il. ");
INSERT INTO ptp_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Josep yêp mɨ kɨdi lec dɨ vông tɨyi xocbê Apumtau angela nêl vô i ge dɨ viac vɨnê Malia mɨ dô hɨxôn lê, ");
INSERT INTO ptp_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","lêc o yêp hɨxôn lêm dɨ i la tyip vô buc wê nu tuc yubac ge dɨ Josep nêl i lê nêbê Yesu. ");
INSERT INTO ptp_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Malia kô Yesu vac vɨgwe Betlehem vac vɨgwe levac Judia. Helot tu he Islel nên king mɨ dô vac vɨgwe Jelusalem. Mêdêc xomxo pɨyôp levac ya lam gê vɨgwe wê hɨyôv tyip lam ge mɨ val Jelusalem dɨ nêl ên nêbê, ");
INSERT INTO ptp_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","“Nipwo paha wê ob tu xam Yuda nêm king ge, tyo dô tina? Xe xê pɨtua wê i vông ge vac vɨgwe wê hɨyôv tyip lam ge, om xe lam ên xe nêb xe ob lam yev vɨxam kɨtu vô i.” ");
INSERT INTO ptp_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Helot ngô kɨyang wê he nêl ge dɨ nɨlô vô vɨyin mabu om tɨbii Jelusalem vɨhati ge, he nɨlô vô vɨyin hɨxôn. ");
INSERT INTO ptp_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Om Helot tyuc he Yuda levac wê mi si daa gee hɨxôn he wê xovô Moses xolac gee vɨhati lam dɨ kɨnêg vô he ên nêbê, “Xomxo ti wê lê nêbê Kɨlisi ge ob yubac vac vɨgwe tina?” ");
INSERT INTO ptp_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Om he nêl lax vô i ên nêbê, “Tyo ob yubac vac vɨgwe Betlehem vac vɨgwe levac Judia. Ên plopete ti kɨvuu kɨyang ilage i yêp bêga nêbê, ");
INSERT INTO ptp_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Ông Betlehem vac vɨgwe levac Judia, ông vɨgwe nipwo, lêc ông tu levac ngɨnoo Judia levac vêl, ên xomxo levac ti obêc val vac xam mahɨgun dɨ ob viac a lige Islel.’” ");
INSERT INTO ptp_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Helot ngô kɨyang tige, mêdêc vông kɨyang la xôpacên vô xomxo pɨyôp levac tigee ên nêb he i lam vô i. He lam om Helot kɨnêg vô he nêbê buc tina wê pɨtua val tyip lec ge? Om he nêl kɨtong vô i. ");
INSERT INTO ptp_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Mêd Helot nêl vô he ên nêbê, “Xam loc Betlehem dɨ loc vông yuac levac lec myagên nipwo tige, dɨ xam obêc wêvô ge od xam lôm nêl vô a ên a êno ob loc yev vɨxag kɨtu vô i.” ");
INSERT INTO ptp_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Om he ngô Helot vya dɨ loc mɨ la, dɨ pɨtua wê he yê vac vɨgwe wê hɨyôv tyip lam ge la mug ên he dɨ mɨla le kɨsii vôxumac ti wê nipwo tige dɨyêp vac ge. ");
INSERT INTO ptp_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","He yê pɨtua tige dɨ xêyaa vô nivɨha yang, ");
INSERT INTO ptp_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","dɨ he la vac xumac nɨlô dɨ la yê nipwo tyo yuu ta Malia, dɨ yev vɨxa kɨtu vô nu tige dɨ pɨmil i. Pyap dêc he hɨkwee susu vac he vɨxec dɨ tung la vô nipwo tyo. Susu wê he vông vô i ge gol dɨ xax myaluc, dɨ susu nivɨvea nivɨhavɨha hɨxôn. ");
INSERT INTO ptp_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Vô bucên Anutu nêl kɨtong vô he vac vɨvia ên nêbê, “Xam lôc vôên Helot tii vacên i ma.” Om he lax môp bangwe mɨ la ben. ");
INSERT INTO ptp_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Xomxo pɨyôp levac tigee la, mêdêc Josep yê Apumtau nên angela ti vac vɨvia dɨ angela tige nêl vô i ên nêbê, “Kɨdi lec mɨ kô nipwo yuu ta dɨ mon pec mɨ loc Isip mɨ loc dô dɨ i loc tyip vô buc wê a ob nêl kɨyang vô ông i tii vac ge, ên Helot ob myag nipwo tige ên nêb ob hi i yib.” ");
INSERT INTO ptp_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Josep ngô angela vya om kɨdi lec vô bucên dɨ kô nipwo tige yuu ta dɨ yon la vɨgwe levac Isip, ");
INSERT INTO ptp_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","dɨ la dô dɨ i la tyip vô buc wê Helot yib vêl ge. Om Apumtau kɨyang wê plopete nêl ilage vô nôn lec. Plopete nêl bêga ên nêbê, “A tyuc nug tuc gê Isip mɨ i lôm.” ");
INSERT INTO ptp_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Mêdêc Helot xovô nêbê xomxo pɨyôp levac tigee kɨtyoo dɨ o mɨlax vô i lêm, om xêyaa vô myavɨnê mabu. Om vông tɨbii la vɨgwe Betlehem dɨ la vac vɨgwe wê yêp nɨnyawehe vô Betlehem ge hɨxôn ên nêb he i loc hi vux nipwo wê klismas ti me yuu ge vɨhati i yib. Helot nêl bêge ên xomxo pɨyôp levac nêl vô i ên nêbê he yê pɨtua ila dɨ klismas yuu lam la vêl. ");
INSERT INTO ptp_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Om kɨyang wê plopete Jelemaia nêl ilage vô nôn lec. Kɨyang tige nêl bêga ên nêbê, ");
INSERT INTO ptp_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“He ngô vya vac vɨgwe Lama wê xomxo vông tɨlôt dɨ byag levac mabu ge. Lesel byag ên nue, dɨ xomxo ti o tɨyi wê ob vông i nɨlô vô vɨyin maên ge lêm, ên nue vɨhati yib mɨma.” ");
INSERT INTO ptp_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Tɨmuên wê Helot yib vêl ge od Apumtau angela ti nêl vô Josep vac vɨvia ên nêbê, ");
INSERT INTO ptp_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“Kɨdi lec dɨ kô nipwo yuu ta dɨ mon lôc mɨ loc vac vɨgwe Islel i tii vac, ên he wê nêb ob hi nipwo tige i yib ge, he yib vêl.” ");
INSERT INTO ptp_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Mêgem Josep kɨdi lec mɨ kô nipwo hɨxôn ta dɨ yon lax mɨ la Islel. ");
INSERT INTO ptp_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Lêc Josep ngô wê Akeleas kô ma Helot nipɨlêhê dɨ viac vɨgwe Judia, om xona ên nêb ob lax mɨ la vɨgwe tige lêm. Om Anutu nêl kɨyang vô Josep vac vɨvia tii vac, om Josep loc mɨ la vɨgwe levac Galili, ");
INSERT INTO ptp_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","dɨ la dô vac vɨgwe Nasalet. Om kɨyang wê he plopete nêl ilage vô nôn lec. Kɨyang tige nêl bêga ên nêbê, “He ob nêl bê i ge xomxo Nasalet ti.” ");
INSERT INTO ptp_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Vô buc tigee Jon Lipacên kɨdi mɨ la vac vɨgwe mahɨgun pɨleva vac vɨgwe levac Judia, dɨ nêl kɨyang vô xomxo bêga ên nêbê, ");
INSERT INTO ptp_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Xam pɨlepac xam, ên Anutu buc vô kwabo lec.” ");
INSERT INTO ptp_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Jon ge wê plopete Aisaia nêl i kɨtong ilage bêga ên nêbê, “Xomxo ti tyuc vya levac vac vɨgwe mahɨgun pɨleva ên nêbê, ‘Xam viac Apumtau môp wê obêc lam vac ge dɨ vông i môp i yêp bôbac.’” ");
INSERT INTO ptp_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Jon mi vɨnyum ngakwi wê he vông ya bwoc kamel nivɨluhu ge dɨ vêx let wê bwoc levac ninɨvi ge hɨxôn, dɨ yaên wê mi ya ge hɨveac hɨxôn vɨnoluc. ");
INSERT INTO ptp_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Dɨ xomxo Jelusalem dɨ xomxo vac vɨgwe levac Judia hɨxôn he vac vɨgwe toto wê yêp kwabo vô mia Jodan ge, he lam vô Jon vac mia Jodan, ");
INSERT INTO ptp_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","dɨ nêl he nên nipaên kɨtong, dɨ Jon lipac he ya mia Jodan. ");
INSERT INTO ptp_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","He Palisi hɨxôn Sadyusi tɨbeac lam ên nêb Jon i lipac he, lêc Jon yê dɨ nêl vô he ên nêbê, “Myel nipaên nue xam! Letya nêl vô xam ên nêbê xam ob pec ên Anutu xêyaa myavɨnê wê ob val vô xam tɨmuên ge? ");
INSERT INTO ptp_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Xam pɨlepac nɨlôm i vô paha lec lê, lêc vông môp nivɨha wê ob nêl kɨtong bêga bê xam pɨlepac xam pyap. ");
INSERT INTO ptp_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Dɨ le i lêc yong xacxam va dɨ xo bê Eblaham bue xam lêm. Ên a ob nêl vô xam bê Anutu tɨyi wê ob nêl dɨ ngɨdax tigae ob tu Eblaham bue ge. ");
INSERT INTO ptp_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Xam tɨyi xocbê xax wê xomxo ob vuv vêl ge. Ên xax wê o vuac nôn nivɨha lêm ge, xomxo ob vuv vɨhati vêl dɨ nêx i la vac ngwax. ");
INSERT INTO ptp_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“A lipac xam ya mia ên wê xam pɨlepac xam pyap ge, lêc xomxo ngwe wê ob val tɨmuên ge, xêkɨzêc wê i vông ge luu xêkɨzêc wê a vông ge vêl, dɨ a o nivɨha tɨyi wê a ob kɨlê i su ge lêm. Xomxo tyo ob lipac xam ya Myakɨlôhô Ngɨbua hɨxôn ngwax. ");
INSERT INTO ptp_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Xomxo tyo vɨgê obêc hôm nôn nivɨha dɨ tung i la vac xumac wê nôn nivɨha ob dô vac ge, dɨ ninɨvi pɨleva ge wê ob nêx i la vac ngwax wê yibên obêc ma ge, ên ngwax i ya vêl.” ");
INSERT INTO ptp_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Yesu sea vɨgwe Galili dɨ lam la Jodan vô Jon ên nêb i lipac i. ");
INSERT INTO ptp_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Lêc Jon kol i dɨ nêl vô Yesu ên nêbê, “Ông obêc lipac a ge od nivɨha, lêc bêna lêc ông lam vô a ên ông nêb a lipac ôngê?” ");
INSERT INTO ptp_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Lêc Yesu nêl lax vô i ên nêbê, “Ông vông i tɨyi wê a nêl ge dɨ lipac a, ên u obêc vông môp vɨhati wê Anutu vông vô u ge i vô nôn lec.” Om Jon ngô dɨ lipac i. ");
INSERT INTO ptp_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Yesu lipac mia pyap dêc lutibed sea mia dɨ lax kehe, mêdêc lag puunê tax dɨ Yesu yê Anutu Myakɨlôhô Ngɨbua tɨyi xocbê tucluu manôn ge dɨ i lam dô lec i. ");
INSERT INTO ptp_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Mêdêc vya ti lam gê lag puunê bêga nêbê, “A nug tige wê a xêgyaa vin lec i dɨ a xê i nivɨha.” ");
INSERT INTO ptp_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Mêdêc Myakɨlôhô Ngɨbua dɨdii Yesu mɨ la vac vɨgwe myadongên wê xomxo dô vacên ma ge ên nêb Seten i yaxên i. ");
INSERT INTO ptp_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Mêd Yesu o ya yaên ti lêm tɨyi vɨdiiên kehe yuu dɨ bucên kehe yuu, om vip den i. ");
INSERT INTO ptp_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Om Seten wê mi yaxên xomxo ge val dɨ nêl vô i ên nêbê, “Ông obêc Anutu nu ge od ông nêl dɨ ngɨdax tigae i tu yaên ên ông wa.” ");
INSERT INTO ptp_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Lêc Yesu nêl lax vô i ên nêbê, “Xolac nêl bêga ên nêbê, ‘Susu yaên vaci o tɨyi wê ob vông xomxo dô mavɨha ya ge lêm. Nge, xomxo ob dô mavɨha ya kɨyang vɨhati wê lam vac Anutu mya ge.’” ");
INSERT INTO ptp_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Yesu nêl bêge. Nang dêc Seten kô i mɨ yuu la vɨgwe ngɨbua Jelusalem dɨ lax i la lec Anutu xumac ngɨbua kɨtôn kɨsii, ");
INSERT INTO ptp_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","dɨ nêl vô i ên nêbê, “Ông obêc Anutu nu ge od ông sox mɨ loc kɨbun, ên kɨyang ti yêp vac xolac bêga ên nêbê, ‘Anutu obêc vông angela wê i vông ge lam viac ông, dɨ hôm ông kɨsii ya vɨgê ên nêb ông vɨnuxên vɨxam lec ngɨdax i ma.’” ");
INSERT INTO ptp_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Lêc Yesu nêl vô i ên nêbê, “Xolac nêl kɨyang ngwe hɨxôn bêga nêbê, ‘Le i lêc yaxên Apumtau wê ông Anutu ge lêm.’” ");
INSERT INTO ptp_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Nang dêc Seten kô Yesu mɨ yuu la lec kɨtôn dia ti kɨsii, dɨ Seten hɨlung vɨgwe wê yêp kɨbun ga ge vɨhati hɨxôn susu nivɨha vɨhati vô Yesu, ");
INSERT INTO ptp_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","dɨ nêl vô i ên nêbê, “Ông obêc yev vɨxam kɨtu vô a dɨ pɨmil a ge od a obêc vông vɨgwe hɨxôn susu tigae vɨhati vô ông dɨ ông ob tu kehe.” ");
INSERT INTO ptp_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Lêc Yesu nêl vô i ên nêbê, “Seten, pec mɨ loc vêl! Ên xolac nêl bêga ên nêbê, ‘Ông yev vɨxam kɨtu vô Apumtau wê ông Anutu ge vaci dɨ vông yuac wê ici va vông ge.’” ");
INSERT INTO ptp_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Yesu nêl bêge, mêdec Seten sea i mɨ la, dɨ angela ya val ngɨdu Yesu xôn. ");
INSERT INTO ptp_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Yesu ngô wê tɨbii tung Jon la dô vac xumac kalabuhu ge, om la vɨgwe levac Galili mɨ la dô vɨgwe Nasalet. ");
INSERT INTO ptp_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Mêdec sea vɨgwe Nasalet dɨ la vɨgwe Kapaneam wê yêp vô mia luaên nɨnya vac vɨgwe levac wê Sebyulan yuu Naptalai vông ilage. ");
INSERT INTO ptp_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Om kɨyang wê plopete Aisaia nêl ilage vô nôn lec. Kɨyang tige nêl bêga ên nêbê, ");
INSERT INTO ptp_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Vɨgwe Sebyulan hɨxôn vɨgwe Naptalai, yuu yêp vô mia luaên nɨnya, dɨ mia Jodan yêp vɨlu ganê. Tɨbii madɨluhu wê o xomxo Yuda lêm ge lam dô vac vɨgwe Galili tige. ");
INSERT INTO ptp_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Om he wê dô vac mapɨtoc ge he yê xêseac levac. Dɨ he wê dô vac vɨgwe yibên mapɨtoc ge, xêseac val vô he pyap.” ");
INSERT INTO ptp_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Kɨyang nêl bêge. Ge buc taxlee wê Yesu nêl xolac vô xomxo bêga ên nêbê, “Xam pɨlepac xam, ên Anutu buc vô kwabo lec.” ");
INSERT INTO ptp_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Yesu mɨla vô mia luaên Galili nɨnya dɨ yê xomxo yuu, Saimon wê lê ngwe nêbê Pita ge dɨ li vux lê nêbê Andlu. Yuu nêx leac ti vac mia luaên tige nêb ob hi pis, ên yuu mi vông yuac lec pis hiên ên nêb ob kô mone lec. ");
INSERT INTO ptp_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Mêdêc Yesu nêl vô yuu ên nêbê, “Muu lam tɨmu vô a vɨxag, ên a ob vông muu dɨdii xomxo mɨ lam vô a i tɨyi xocbê muu dɨdii pis vac leac ge.” ");
INSERT INTO ptp_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Om lutibed yuu sea leac dô xel dɨ la hɨxôn Yesu. ");
INSERT INTO ptp_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Mêd yon mɨla yê Sebedi nu Jems yuu Jon wê yuu dô lec dipac hɨxôn ma Sebedi dɨ duu leac wê tip sea ge xôn. Mêdêc Yesu keac yuu lam, ");
INSERT INTO ptp_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","om lutibed yuu sea dipac hɨxôn ma dɨ la hɨxôn Yesu. ");
INSERT INTO ptp_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Yesu la vɨlee vac vɨgwe levac Galili dɨ la nêl kɨyang vô xomxo vac he xumac lɨlo toto dɨ nêl xolac nivɨha lec Anutu ben lag puunê vô he, dɨ vông he wê yidac hɨxôn myavɨnê toto ge vɨhati vô nivɨha lec. ");
INSERT INTO ptp_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Om xomxo nêl Yesu lê la vac vɨgwe levac Silia vɨhati. Dɨ he kô xomxo wê yidac kehe toto ge vɨhati mɨ lam vô i, hɨxôn he wê kô myavɨnê ge, dɨ he wê vɨmwo nipaên dô vac he nɨlô ge, dɨ he wê yidac vông he vɨxog sea ge, dɨ he wê len vô xêlehe ge. Mêd Yesu vông he vɨhati vô nivɨha lec. ");
INSERT INTO ptp_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Dɨ xomxo kɨdu kɨdu wê lam gê Galili hɨxôn vɨgwe vɨgê yuu wê lê levac nêbê Dekapolis ge dɨ he Jelusalem dɨ he Judia dɨ he wê lam gê mia Jodan vɨlu ganê ge, he vɨhati la tɨmu vô Yesu vɨxa. ");
INSERT INTO ptp_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Yesu yê xomxo kɨdu levac wê kɨtuc lam vô i ge, om sea he mɨ la lec kɨtôn dɨ la dô kɨbun. Mêdêc nue ngɨvihi lec mɨ la vô i, ");
INSERT INTO ptp_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","dɨ i nêl kɨyang vô he bêga ên nêbê, ");
INSERT INTO ptp_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Xomxo wê xovô ên nêbê he tɨyiên ma wê Anutu ob yê he nivɨha ge, he i dô hɨxôn xêyaa nivɨha, ên Anutu ben lag puunê tu he ben. ");
INSERT INTO ptp_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","“Xomxo wê nɨlô vô vɨyin om he byag ge, he i dô hɨxôn xêyaa nivɨha, ên Anutu obêc vông he nɨlô vô vɨyin maên. ");
INSERT INTO ptp_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","“Xomxo wê o kô he lec lêm ge, he i dô hɨxôn xêyaa nivɨha, ên Anutu obêc nêl he lê lec kɨbun ga vɨhati. ");
INSERT INTO ptp_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","“Xomxo wê xêyaa vin lec môp nivɨha wê Anutu vông ge tɨyi xocbê he xêyaa vin lec nêb ob ya yaên dɨ num mia ge, he i dô hɨxôn xêyaa nivɨha, ên môp nivɨha wê he vông ge, Anutu ob vông i vô nôn lec. ");
INSERT INTO ptp_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","“Xomxo wê xo vɨgwe pɨsiv ên xomxo ge, he i dô hɨxôn xêyaa nivɨha, ên Anutu obêc xo vɨgwe pɨsiv ên he. ");
INSERT INTO ptp_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","“Xomxo wê nɨlô xêseac ge, he i dô hɨxôn xêyaa nivɨha, ên he obêc yê Anutu. ");
INSERT INTO ptp_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","“Xomxo wê vông kɨsoac vac xomxo wê kunacma ge, he i dô hɨxôn xêyaa nivɨha, ên Anutu obêc nêl ên nêbê he tu i nue. ");
INSERT INTO ptp_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","“Xomxo obêc tɨmu vô môp nivɨha wê Anutu vông ge, lêc tɨbii obêc vông vɨyin vô he ên môp tigee ge od he i dô hɨxôn xêyaa nivɨha, ên Anutu ben lag puunê tu he ben. ");
INSERT INTO ptp_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Xomxo obêc yê wê xam vông i vin a ge lêc obêc so vya vô xam dɨ vông vɨyin vô xam dɨ kɨtyoo kɨyang tɨbeac tɨbeac lec xam ge ");
INSERT INTO ptp_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","od xam dô hɨxôn xêmyaa i nivɨha, dɨ hi vɨxam i pec, ên nôn nivɨha wê xam ob kô ge dô bin xam vac Anutu ben lag puunê. Xam xovô ên xam nêbê xomxo vông vɨyin tibêge vô plopete wê dô mugên ilage. ");
INSERT INTO ptp_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Xam tɨyi xocbê sol wê ob vô nivɨha vô xomxo kɨbun ga vɨhati ge. Lêc sol obêc vô nyen maên ge, od il ob vông vatya vô ên i vô nyen nangê? Ge vô nipaên pyap, dɨ o tɨyi wê ob vô nivɨha tii vac dɨ vông yuac ti ge lêm, om xomxo ob nêx i la dô xel dɨ kê vac kɨbun. ");
INSERT INTO ptp_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Xam tɨyi xocbê ngwax xêseac wê ob linac lec vɨgwe vɨhati ge. Ên vɨgwe levac ti obêc yêp lec kɨtôn kɨsii ge od ob yêp xôpacên lêm. ");
INSERT INTO ptp_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Xomxo ti obêc byêx ngwax vac lam ge od obêc lax i la le xôpacên vac dêg nɨlô lêm. Nge, ob yu i la yux seac ên nêb i linac lec xomxo vɨhati wê dô vac xumac nɨlô ge. ");
INSERT INTO ptp_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Om xêseac wê xam vông ge i lêc linac vô xomxo vɨhati manôn êno bêge, ên he i yê môp nivɨha wê xam vông ge dɨ hi vɨxa i pec ên Mag Anutu wê dô lag puunê ge. ");
INSERT INTO ptp_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Le i lêc xo bê a lam ên a nêb a ob kɨtya Moses xolac hɨxôn plopete kɨyang vêl lêm. Ên a o lam ên a nêb a ob kɨtya kɨyang tigee vêl lêm. Nge, a nêb a ob vông i vô nôn lec. ");
INSERT INTO ptp_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","A nêl vɨxôhɨlôg nôn vô xam bê gwêbaga dɨ i loc tyip vô buc wê lag yuu kɨbun xôa obêc ma ge, kɨyang wê yêp vac Moses xolac ge, bo ti xôa obêc ma lêm. Nge, vɨhati ob yêp dɨ ob vô nôn lec tɨmuên. ");
INSERT INTO ptp_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Om xomxo ti obêc pwoo Moses xolac bo ti vac dɨ dɨdii xomxo vac ên nêb he i tɨmu vô i vɨxa ge od xomxo tige ob kô lê nipwo vac Anutu ben lag puunê. Lêc xomxo ti obêc tɨmu vô xolac vɨhati dɨ dɨdii xomxo vac ên nêb he i tɨmu vô ge od xomxo tige obêc kô lê levac vac Anutu ben lag puunê. ");
INSERT INTO ptp_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","A ob nêl vô xam bê môp nivɨha wê xam vông ge i luu wê xomxo xolac kehe hɨxôn he Palisi mi vông ge vêl. Lêc obêc ma ge od o tɨyi wê xam ob la vac Anutu ben ge lêm. ");
INSERT INTO ptp_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Xam ngô kɨyang pyap wê yêp vô bume ilage bêga nêbê, ‘Le i lêc hi xomxo i yib lêm. Xomxo ngwe obêc hi xomxo ngwe yib ge od ob la kot dɨ kô myavɨwen.’ ");
INSERT INTO ptp_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","He nêl bêge ilage, lêc a ob nêl vô xam bê xomxo ngwe obêc kunac li ngwe ge od ob la kot dɨ kô myavɨwen. Dɨ xomxo ngwe obêc so vya vô li ngwe ge od xomxo i vông i loc vô hɨzap levac ên i tɨtô i. Dɨ xomxo ti obêc nêl nipaên lec li ngwe nêb yacyac ge od ob la dô vac ngwax levac vac vɨgwe nipaên. ");
INSERT INTO ptp_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“Om ông obêc kô daa mɨ la le vô alta, lêc ông xovô bê muu lime ti kɨyang obêc yêp ge ");
INSERT INTO ptp_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","od ông sea daa tige i dô kwabo vô alta dɨ lôc mɨ loc, ên muu viac kɨyang vêl lê, lêc ông lôm tung daa tɨmuên. ");
INSERT INTO ptp_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Xomxo ti obêc kô ông mɨ la kot lêc muu ob gên dɨloc vô môp ge od muu viac kɨyang vôma. Lêc obêc ma ge od xomxo tyo obêc tung ông la vac hɨzap levac vɨgê, dɨ hɨzap levac ob vông ông la vac xêhɨpu vɨgê, dɨ xêhɨpu ob tung ông la dô vac kalabuhu, ");
INSERT INTO ptp_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","dɨ a nêl vɨxôhɨlôg vô ông bê ông obêc lop mɨ lôm vêl ên kalabuhu lêm. Nge, ông ob dô dɨ hi myavɨwen vɨhati i ma vêl lê. ");
INSERT INTO ptp_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Xam ngô kɨyang pyap wê xomxo nêl ilage bêga ên nêbê, ‘Le i lêc vông môp yôdac vêx yuu vux lêm.’ ");
INSERT INTO ptp_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","He nêl bêge, lêc a ob nêl vô xam bê vux ti obêc yê vêx ti dɨ nɨlô yetac ên ge od tɨyi xocbê vux tige vông yôdac vô vêx tige vac nɨlô. ");
INSERT INTO ptp_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Om ông mamnôn vɨlu hɨyôv obêc dɨdii ông mɨ la vac môp nipaên ge od ông pul vêl dɨ nêx i loc, ên ông nimnɨvi mya tige obêc la xôa ma ge od ông ob dô nimvɨha, lêc obêc dô ge od ông nimnɨvi vɨhati ob la vac vɨgwe nipaên. ");
INSERT INTO ptp_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Dɨ ông vɨgêm hɨyôv obêc dɨdii ông mɨ la vac nipaên ge od ông kɨtov vêl dɨ nêx i loc, ên ông nimnɨvi mya tige obêc la xôa ma ge od ông ob dô nimvɨha, lêc obêc dô ge od ông nimnɨvi vɨhati ob la vac vɨgwe nipaên. ");
INSERT INTO ptp_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Xomxo nêl ilage bêga ên nêbê, ‘Xomxo ti obêc nêb ob sea vɨnê ge od i kɨvuu kɨpihac wê nêbê yuu ob seama ge ti mɨ vông vô vɨnê lê, lêc yuu i seama.’ ");
INSERT INTO ptp_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","He nêl bêge ilage, lêc a ob nêl vô xam bê vux ti vɨnê obêc vông môp yôdac vô vux ngwe lêm, lêc lɨya sea vɨnê tyo dô ge od vux tige vông vɨnê la vac yôdac, dɨ vux ti obêc kô vêx ti wê lɨya sea i dɨ la ge od vux tige vông yôdac vô vêx tige. ");
INSERT INTO ptp_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Xam ngô kɨyang pyap wê yêp vô bume ilage bêga ên nêbê, ‘Le i lêc hɨlung vɨgê loc kɨsii dɨ nêl kɨyang kɨtyooên hɨxôn lêm. Nge, xam obêc hɨlung vɨgêm la kɨsii ge od xam tɨmu vô kɨyang wê xam nêl ge i yêp bôbac vô Apumtau manôn.’ ");
INSERT INTO ptp_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","He nêl bêge ilage, lêc a ob nêl vô xam bê le i lêc hɨlung vɨgê i loc kɨsii dɨ nêl kɨyang ti hɨxôn lêm. Dɨ le i lêc nêl kɨyang ti dɨ nêl vɨgwe lag puunê lê hɨxôn ên nêb i ngɨdu xam kɨyang xôn lêm. Ên vɨgwe lag puunê ge Anutu ben. ");
INSERT INTO ptp_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Dɨ le i lêc nêl kɨyang ti dɨ nêl kɨbun lê hɨxôn lêm. Ên kɨbun ga sia nipwo wê Anutu kê vɨxa lec ge. Dɨ le i lêc nêl kɨyang ti dɨ nêl vɨgwe Jelusalem lê hɨxôn lêm. Ên Jelusalem ge Anutu wê tu king levac ge ben. ");
INSERT INTO ptp_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Dɨ le i lêc hɨlung vɨgê lec bazub ên nêb i ngɨdu xam kɨyang xôn lêm. Ên xam o tɨyi wê xam ob vông bamzub lihi ti vô kwem me vô vɨliac lec ge lêm. ");
INSERT INTO ptp_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Om xam obêc nêl kɨyang ge od xam nêl bê ‘Nge’ me ‘Ma’, dɨ i pyap. Ên xam obêc nêl kɨyang ya luu tige vêl ge od ge môp wê Seten vông ge. ");
INSERT INTO ptp_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Xam ngô kɨyang pyap wê he nêl ilage bêga ên nêbê, ‘Xomxo ti obêc vông ông mamnôn vô nipaên ge od ông êno vông i manôn i vô nipaên. Dɨ xomxo ti obêc pwoo ông nɨvum pec ge od ông pwoo i nɨvu i pec êno.’ ");
INSERT INTO ptp_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","He nêl bêge ilage, lêc a ob nêl vô xam bêga bê le i lêc vông myavɨwen nipaên vac nipaên lêm. Nge, xomxo ti obêc pɨtap ông lia vɨlu ge od ông pɨlepac lia vɨlu i loc vô i hɨxôn. ");
INSERT INTO ptp_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Xomxo ti obêc vông kɨyang vô ông ên nêb ob kô ngakwi wê ông vông ge od ông vông saket mɨ i kô hɨxôn. ");
INSERT INTO ptp_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Xomxo ti obêc keac xêkɨzêc nêbê ông kɨlê i susu mɨ loc môp kwabo tya ge od ông kɨlê mɨ muu loc môp dia tya hɨxôn. ");
INSERT INTO ptp_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Xomxo ti obêc kɨtaa susu ti vô ông ge od ông vông vô i. Dɨ xomxo ti obêc kɨtaa susu ti vô ông ên nêb ob kô mɨ la lêc vông i lôm ge, od le i lêc hɨngoo kɨyang wê nêl ge lêm. ");
INSERT INTO ptp_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Xam ngô kɨyang pyap wê xomxo nêl ilage bêga ên nêbê, ‘Xam xêmyaa i vin lec lime, dɨ xêmyaa i vô nipaên vô tɨbii wê vông nipaên vô xam ge.’ ");
INSERT INTO ptp_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","He nêl bêge, lêc a ob nêl vô xam bêga bê xam xêmyaa i vin lec he wê yê xam nipaên ge, dɨ xam kɨtaa vô Anutu ên i vông nivɨha vô he wê vông vɨyin vô xam ge, ");
INSERT INTO ptp_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","ên xam obêc vông bêge ge od xam obêc tu Mag Anutu lag puunê nue, ên Anutu vông hɨyôv linac lec xomxo nipaên dɨ he wê nivɨha ge hɨxôn, dɨ vông lun tô lec he wê tɨmu vô môp bôbac ge dɨ tô lec he wê so môp bôbac ge hɨxôn. ");
INSERT INTO ptp_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Ên xam xêmyaa obêc vin lec xomxo wê xêyaa vin lec xam ge od xam ob kô nôn bêna? Ên tɨbii nipaên mi vông bêge êno. ");
INSERT INTO ptp_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Dɨ xam obêc nêl kɨyang vô lime vaci ge od xam ob luu tɨbii vêl bêna? Ên tɨbii madɨluhu êno mi vông bêge hɨxôn. ");
INSERT INTO ptp_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Mêgem xam viac xam mɨ dô nivɨha lee i tɨyi xocbê Mag Anutu lag puunê wê nivɨha lee ge.” ");
INSERT INTO ptp_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Yesu nêl vô nue ngɨvihi ên nêbê, “Xam xona nêm dɨ le i lêc vông môp nivɨha vô xomxo manôn bê he i yê xam nivɨha lêm. Ên xam obêc vông bêge ge od xam ob kô nôn nivɨha ti vô Mam Anutu wê dô lag puunê ge lêm. ");
INSERT INTO ptp_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Om xam obêc nêb xam ob vông susu ti vô xomxo wê nên susu maên ge, od xam o lêc vông xomxo ti i loc mug dɨ vê vuac bê xomxo i yê xam lêm. Ên xomxo kɨtyooên wê vɨyum nipaên vac nivɨha nɨlô ge mi vông môp tibêge vac xumac lɨlo dɨ vông vac môp hɨxôn ên nêb xomxo i yê dɨ yong he lê. Om a nêl vɨxôhɨlôg nôn vô xam bêga bê he kô nôn nivɨha pyap, om ob kô ngwe i tii vac vô buc tɨmuên nang lêm. ");
INSERT INTO ptp_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Om xam obêc vông susu ti vô xomxo wê nên susu maên ge od xam vɨgêm kêd i o lêc xovô yuac wê vɨgêm hɨyôv vông ge lêm. ");
INSERT INTO ptp_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Nge, yuac tibêge i yêp xôpacên, dɨ Mag Anutu wê yê susu yuu môp xôpacên vɨhati ge ob vông nôn nivɨha vô xam. ");
INSERT INTO ptp_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Xam obêc kɨtaa ge od le i lêc vông i tɨyi xocbê xomxo kɨtyooên wê vɨyum nipaên vac nivɨha nɨlô ge mi vông ge lêm. Ên he xêyaa vin lec nêb ob le kɨsii vac Anutu xumac ngɨbua dɨ kɨtaa, dɨ le vac môp buuên wê xomxo tɨbeac vɨlee vac ge dɨ kɨtaa ên nêb xomxo i yê. Lêc a nêl vɨxôhɨlôg nôn vô xam bêga bê he kô nôn nivɨha pyap, om obêc kô ngwe tii vac vô buc tɨmuên lêm. ");
INSERT INTO ptp_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Om xam obêc kɨtaa ge od xam loc vac xam bom xumac lôma dɨ tung vuayen lec dɨ kɨtaa vô Mag Anutu wê dô xôpacên ge, dɨ Mag Anutu wê yê susu yuu môp xôpacên vɨhati ge ob vông nôn nivɨha vô xam. ");
INSERT INTO ptp_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Xam obêc kɨtaa ge od le i lêc kɨtaa tɨyi xocbê kɨyang pɨleva wê nôn maên ge lêm. Ên kɨtaaên tibêge tɨyi xocbê môp wê tɨbii madɨluhu mi vông ge. Ên he xo ên he nêbê he ob kɨtaa dia ge od anutu wê he vông ge ob yê he nivɨha dɨ vông kɨyang wê he nêl ge vô nôn lec. ");
INSERT INTO ptp_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Om xam o lêc tɨmu vô môp wê he vông ge lêm. Ên susu wê ma ên xam lêc xam gên o kɨtaa mɨ nêl lêm ge, ge Mag Anutu xovô pyap. ");
INSERT INTO ptp_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","“Om xam kɨtaa bêga bê, Xe Mag ông, wê ông dô kɨsii ge, ông lêm i lam tu ngɨbua. ");
INSERT INTO ptp_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Ông lam tu Apumtau i tɨyi vɨgwe vɨhati. Ông kɨyang i lam vô nôn gê kɨbun ga xocbê yêp gê kɨsii ge. ");
INSERT INTO ptp_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Ông vông nyang vô xe i tɨyi buc vɨhati. ");
INSERT INTO ptp_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Xe nêm myavɨwen wê yêp vô xe ge, ông kɨtya vêl, xocbê xe kɨtya nêm nipaên vêl vôma ge. ");
INSERT INTO ptp_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Ông o lêc dɨdii xe mɨ loc vac kɨyang wê ob yaxên xe ge lêm. Nge, ông vô xe vêl ên nipaên vɨhati. Ông Apumtau, ông xêpɨlihi dɨ xêkɨzêc dɨ ông xêseac kehe dɨ luta lêc luta. Kɨyang nôn. ");
INSERT INTO ptp_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Wê lê. Xam obêc kɨtya xomxo nên nipaên vêl ge od Mag Anutu obêc kɨtya xam nêm nipaên vêl. ");
INSERT INTO ptp_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Lêc xam obêc kɨtya xomxo nên nipaên vêl lêm ge od Mag Anutu ob kɨtya xam nêm nipaên vêl lêm. ");
INSERT INTO ptp_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Buc wê xam obêc ngɨbua yaên lec ge od le i lêc dô ma yux yux tɨyi xocbê xomxo kɨtyooên ge lêm. Ên he mi vông môp tibêge ên nêb xomxo i yê he dɨ xovô bê he ngɨbua yaên. Lêc a nêl vɨxôhɨlôg nôn vô xam bêga bê he kô nôn nivɨha pyap, om obêc kô ngwe tii vac vô buc tɨmuên nang lêm. ");
INSERT INTO ptp_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Om xam obêc ngɨbua yaên ge od xam hɨvip bamzub dɨ lipac mamnôn hɨxôn, ");
INSERT INTO ptp_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","ên xomxo i yê, lêc o xovô wê xam ngɨbua yaên ge lêm. Lêcom Mag Anutu wê dô xôpacên ge vaci ob xovô, dɨ Mag Anutu wê yê susu yuu môp xôpacên vɨhati ge obêc vông nôn nivɨha vô xam. ");
INSERT INTO ptp_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Le i lêc kɨtuc susu nivɨhavɨha tɨbeac gê kɨbun ga lêm. Ên susu wê yêp kɨbun ga ge, gwaakivac ob lic sea dɨ guva ob iac sea, dɨ tɨbii yôdac ob dii xumac dɨ la vun susu tigee. ");
INSERT INTO ptp_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Om xam kɨtuc susu nivɨhavɨha i loc yêp vac Anutu ben lag puunê. Ên susu wê yêp vac Anutu ben lag puunê ge, gwaakivac ob lic lêm dɨ guva ob iac lêm, dɨ tɨbii yôdac ob dii xumac dɨ la vun lêm. ");
INSERT INTO ptp_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","A nêl bêge vô xam, ên vɨgwe wê xam susu nivɨhavɨha dô vac ge, ge xam ob vông nɨlôm la vô vɨgwe tige. ");
INSERT INTO ptp_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Xam mamnôn tɨyi ngwax xêseac wê linac lec nimnɨvi ge. Om mamnôn obêc dô nivɨha ge od nimnɨvi vɨhati ob dô vac xêseac. ");
INSERT INTO ptp_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Lêc mamnôn obêc vô nipaên ge od nimnɨvi vɨhati ob vô mapɨtoc. Dɨ xêseac wê dô vac xam nɨlôm ge obêc mapɨtoc ge od mapɨtoc ob vô levac dɨ hɨvun xam xôn. ");
INSERT INTO ptp_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Xomxo ti o tɨyi wê ob vông yuac vô xomxo levac yuu ge lêm. Ên xêyaa obêc vin lec ngwe dɨ ob yê ngwe nipaên, me obêc vông nɨlô la vô ngwe dɨ vô nɨmi vô ngwe. Om o tɨyi wê xam ob vông nɨlôm i loc vô Anutu hɨxôn mone ge lêm. ");
INSERT INTO ptp_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Om a nêl vô xam bê xam o lêc vông nɨlôm i vô vɨyin lec yaên yuu numên hɨxôn ngakwi lêm, ên môp wê il ob dô madvɨha ge luu yaên vêl, dɨ môp wê il ob viac nidnɨvi ge luu ngakwi vêl. ");
INSERT INTO ptp_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Xam wê menac dɨ xovô bê menac o xin yaên vê lêm, dɨ he o kô yaên nôn vac yuac lêm, dɨ he o kɨtuc yaên la dô vac xumac ti lêm. Lêc Mag Anutu wê dô lag puunê ge vaci vet he, dɨ Anutu xêyaa vin lec xomxo luu menac tigee vêl om Anutu ob viac xam nivɨha êno. ");
INSERT INTO ptp_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Xam ti o tɨyi wê xam ob xo kɨyang tɨbeac dɨ tɨtul buc wê xam ob dô mamvɨha ge i vô dia lêm. ");
INSERT INTO ptp_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Bêna lêc xam xo kɨyang tɨbeac lec ngakwi? Xam xovô nita wê vuac mavɨya ge. He o vông yuac ti lec ngakwi me he o duu nivɨmihi ti lêm. ");
INSERT INTO ptp_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Lêc a nêl vô xam bêga bê vunacên wê he vông ge luu vunacên nivɨhavɨha wê King Solomon vông ilage vêl. ");
INSERT INTO ptp_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Nita wê vuac mavɨya ge tyip vac yuac mɨ le gwêbaga, lêc tɨtige xomxo ob kɨtov vêl dɨ nêx la vac ngwax, lêc Anutu vunac vô he nivɨha. Xam ge, vông vinên wê xam vông ge nipwo lee tya, lêcom xam xovô bê Anutu obêc viac xam nivɨha luu mavɨya vêl. ");
INSERT INTO ptp_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Om le i lêc xo kɨyang tɨbeac dɨ nêl bêga bê, ‘Il ob xa vatya, dɨ il ob num vatya, dɨ il ob vɨnyum ngakwi tibêna?’ lêm. ");
INSERT INTO ptp_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Ên tɨbii madɨluhu ge wê xo kɨyang tɨbeac ên nêb ob tulec susu tibêgee. Dom Mag Anutu wê dô lag puunê ge xovô susu wê ma ên xam ge pyap. ");
INSERT INTO ptp_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Mêgem xam obêc vông nɨlôm i loc vô Anutu hɨxôn môp nivɨha wê i vông ge od Anutu obêc vông susu ninɨvi xen vô xam hɨxôn. ");
INSERT INTO ptp_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Om xam o lêc xo kɨyang tɨbeac lec buc tɨtige lêm, ên obêc tɨtige ge od xam ob xovô susu me vɨyin wê xam ob tulec tɨtige. Vɨyin wê buc toto vông ge i yêp lec buc titi ge bôbac.” ");
INSERT INTO ptp_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Yesu nêl vô nue ngɨvihi ên nêbê, “Le i lêc yaxên xomxo nên kɨyang lutibed lêm, ên Anutu i o lêc yaxên xam nêm kɨyang lêm. ");
INSERT INTO ptp_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Ên Anutu obêc yaxên xam nêm kɨyang tɨyi xocbê xam va yaxên xomxo nên kɨyang ge. Ên môp wê xam vông vô xomxo ge od Anutu obêc vông i tɨyi wê xam vông vô he ge vô xam. ");
INSERT INTO ptp_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Bêna lêc ông wê xax mavɨgen nipwo tya wê le vac lim manôn ge dɨ nêlê, dɨ ông lungên xax yatôv wê le vac ôcông va mamnôn ge? ");
INSERT INTO ptp_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Xax levac le vac ông mamnôn, bêna lêc ông nêl vô lim ên ông nêbê ông ob hôm xax mavɨgen nipwo tya wê le vac lim manôn ge vêl? ");
INSERT INTO ptp_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Ông xomxo kɨtyooên, ông hôm xax yatôv wê le vac ông mamnôn ge vêl tax ên mamnôn i seac, ge od ông tɨyi wê ông ob hôm xax mavɨgen nipwo tya wê le vac lim manôn ge vêl. ");
INSERT INTO ptp_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Le i lêc nêx susu ngɨbua i loc vô noo lêm. Dɨ le lêc nêx komkom wê mone levac ge i loc vô bwoc lêm, ên he ob kê i hɨbu sea dɨ ob pop mɨ nga xam. ");
INSERT INTO ptp_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Xam kɨtaa vô Anutu ên i vông susu vô xam, dɨ xam myag susu êdêc wêvô, dɨ hi vɨgêm lec vuayen ên i tax ên xam. ");
INSERT INTO ptp_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Ên xomxo vɨhati wê kɨtaa vô Anutu ge obêc kô nôn tɨyi wê he kɨtaa ge, dɨ xomxo ti wê myag susu ge obêc yêvô, dɨ xomxo ti wê hi vɨgê lec vuayen ge vuayen obêc tax ên i. ");
INSERT INTO ptp_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“Xam nume ti obêc kɨtaa ma ên nêb ob ya blet ge od ma ob vông ngɨdax ti vô, me? ");
INSERT INTO ptp_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Dɨ nu tige obêc kɨtaa ma ên nêb ob ya pis ge od ma ob vông myel ti vô, me? ");
INSERT INTO ptp_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Xam ga xomxo kɨbun nimpaên, lêc xam mi vông susu nivɨha vô nume. Om xam xovô bêga bê il Mag Anutu wê dô lag puunê ge ob vông susu nivɨhavɨha i luu vêl vô xomxo wê kɨtaa i ge. ");
INSERT INTO ptp_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Om môp vɨhati wê xam nêb xomxo i vông vô xam ge, xam vông môp bêge vô he êno, ên kɨyang wê Moses hɨxôn plopete nêl ge kehe bêge. ");
INSERT INTO ptp_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Xam loc vô môp vuayen nipwo, ên môp wê ob dɨdii xomxo la xôa ma ge, ge môp levac wê ob vông yuac levac vô xomxo lêm. Om xomxo tɨbeac la vô môp ngwe ge. ");
INSERT INTO ptp_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Lêc môp wê ob dɨdii xomxo la dô mavɨha ge, ge môp nipwo wê vông yuac levac vô xomxo. Om xomxo yuutyabed ob yêvô mɨ la vô môp tige. ");
INSERT INTO ptp_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Xam xona nêm ên plopete kɨtyooên, ên he tɨyi xocbê he vɨnyum bwoc sipsip nivɨluhu om xam so ên xam nêbê he xomxo nivɨha. Lêc he nɨlô tɨyi xocbê noo nipaên. ");
INSERT INTO ptp_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Xam obêc xovô he lec môp wê he vông ge. Ên xomxo ob yul myedanôn nôn lec kɨpomac yin yatôv lêm. Dɨ xomxo ob yul kɨsung nôn lec nyela yatôv lêm. ");
INSERT INTO ptp_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Ên xax nivɨha vɨhati ob vuac nôn nivɨha, dɨ xax nipaên vɨhati ob vuac nôn nipaên. ");
INSERT INTO ptp_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Xax nivɨha o tɨyi wê ob vuac nôn nipaên ge lêm, dɨ xax nipaên o tɨyi wê ob vuac nôn nivɨha ge lêm. ");
INSERT INTO ptp_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Xax vɨhati wê o vuac nôn nivɨha lêm ge, xomxo ob vuv vêl dɨ nêx i la vac ngwax. ");
INSERT INTO ptp_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Om xam obêc xovô plopete kɨtyooên lec môp nipaên wê he vông ge. ");
INSERT INTO ptp_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Xomxo wê mi nêl ‘Apumtau, Apumtau’ vac mya pɨleva ge, he ob la dô vac Anutu ben lêm. Nge, he wê tɨmu vô môp wê Mag Anutu lag puunê vông ge wê ob la dô vac Anutu ben. ");
INSERT INTO ptp_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Ôbêc vô buc levac tɨmuên ge od xomxo tɨbeac obêc nêl ên nêbê, ‘Apumtau, Apumtau, xe vông yuac plopete lec ông lêm, dɨ xe tii vɨmwo nipaên vêl ên xomxo lec ông lêm, dɨ xe vông do levac tɨbeac lec ông lêm.’ ");
INSERT INTO ptp_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Lêc a obêc nêl vô he bê, ‘A lungên xam. Xam ge xomxo nipaên, om xam pec vêl ên a magnôn.’ ");
INSERT INTO ptp_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Xomxo vɨhati wê ngô a kɨyang dɨ vông a vyag vô nôn lec ge, he tɨyi xocbê xomxo xovôên nivɨha ti wê lox xumac lec ngɨdax pɨtehe kɨsii. ");
INSERT INTO ptp_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Dɨ buc lun val dɨ mia butac, dɨ vɨgwe vɨyii, om xumac vô yocyoc, lêc o kɨpê lêm, ên lox xumac lec ngɨdax om xumac le xêkɨzêc. ");
INSERT INTO ptp_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Dɨ xomxo vɨhati wê ngô a kɨyang, lêc o tɨmu vô lêm ge, he tɨyi xocbê xomxo pɨyôp maên ti wê lox xumac lec luda pɨleva. ");
INSERT INTO ptp_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Dɨ buc lun val dɨ mia butac dɨ vɨgwe vɨyii, om xumac vô yocyoc dɨ kɨpê mɨ la dii sea.” ");
INSERT INTO ptp_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Yesu nêl kɨyang vɨhati gee pyap dɨ xomxo kɨdu levac wê kɨtucma dɨ ngô kɨyang ge yetac mabu ên kɨyang wê i nêl ge, ");
INSERT INTO ptp_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","ên Yesu o nêl kɨyang vô he tɨyi xocbê xomxo wê xovô Moses xolac ge lêm. Nge, nêl kɨyang hɨxôn xêkɨzêc. ");
INSERT INTO ptp_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Yesu sea kɨtôn dɨ lop mɨ la dɨ xomxo tɨbeac hɨwocên tɨmu vô i vɨxa mɨ lam. ");
INSERT INTO ptp_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Mêd xomxo wê kɨtyax mahɨzihɨzi ge ti val vô Yesu dɨ yev vɨxa kɨtu vô dɨ nêl vô i ên nêbê, “Xomxo levac, ông obêc nêb ông ob vông a nignɨvi i vô nivɨha lec ge od ông tɨyi.” ");
INSERT INTO ptp_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Mêgem Yesu tɨtô vɨgê mɨ la vyax lec i dɨ nêl ên nêbê, “A nêb ông vô nimvɨha lec.” Yesu nêl dɨ kɨtyax mahɨzihɨzi tige wax la vêl lutibed dɨ xomxo tyo ninɨvi vô nivɨha lec. ");
INSERT INTO ptp_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Mêdec Yesu nêl vô i ên nêbê, “Le i lêc nêl nimnɨvi wê vô nivɨha lec ge kɨtong vô xomxo ti lêm. Dɨ ông loc hɨlung nimnɨvi mô vô xomxo wê mi si daa vô Anutu ge dɨ vông daa i tɨyi môp wê Moses xolac nêl ge, ên xomxo vɨhati i yê dɨ xovô bê ông nimnɨvi vô nivɨha lec.” ");
INSERT INTO ptp_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Yesu loc mɨ la vɨgwe Kapaneam, mêdec Lom vevac levac wê viac nue vevac 100 ge ti lam vô Yesu dɨ kɨtaa i ên nêbê, ");
INSERT INTO ptp_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Xomxo levac, a nug yuac ti vông yidac levac mɨ yêp vac a bog, lêc vɨgê yuu vɨxa len vô xêlehe dɨ i yaxên myavɨnê levac.” ");
INSERT INTO ptp_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Om Yesu nêl vô i ên nêbê, “A ob loc vông i vô nivɨha lec.” ");
INSERT INTO ptp_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Lêc xomxo vevac tige nêl lax vô i ên nêbê, “Xomxo levac, a o nivɨha tɨyi wê ông ob lam vac a xumac lôma ge lêm. Om ông vyam i nêl dɨ a nug yuac i vô nivɨha lec. ");
INSERT INTO ptp_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Ên a ga êno wê a la vac xomxo levac kwa ngɨbi, dɨ a nuge vevac ge wê lam vac a kwa ngɨbi. Om a obêc nêl vô he ti ên a nêb i loc ge od ob la, dɨ a obêc nêl vô ti bê i lam ge od ob lam, dɨ a obêc nêl vô nug yuac ti bê i vông yuac ge od ob vông. Dɨ ông êno, ông ge xomxo xêkɨzêc, om a xovô ên a nêbê ông obêc le teva dɨ nêl ge od a nug yuac tige ob vô nivɨha lec.” ");
INSERT INTO ptp_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Yesu ngô kɨyang wê xomxo tyo nêl ge om yetac, dɨ nêl vô xomxo tɨbeac wê tɨmu vô i vɨxa ge ên nêbê, “A nêl vɨxôhɨlôg nôn vô xam bê a o xê xomxo Islel ti wê vông i vin xêkɨzêc tɨyi xocbê Lom tiga vông i vin ge lêm. ");
INSERT INTO ptp_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","“A nêl vô xam bêga bê tɨbii tɨbeac ob kɨdi vac vɨgwe wê hɨyôv tyip lam ge dɨ vɨgwe wê hɨyôv hoo la ge dɨ la dô mɨ ya hɨxôn Eblaham yuu Aisak yon Jekop vac Anutu ben lag puunê. ");
INSERT INTO ptp_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Lêc Islel wê he nêb he ob la dô vac Anutu ben ge, Anutu ob tii he la dô vac vɨgwe mapɨtoc. Vac vɨgwe tige he ob byag levac dɨ ob kic nɨvu lecma.” ");
INSERT INTO ptp_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Mêdec Yesu nêl vô Lom vevac levac tige ên nêbê, “Ông loc bom. Kɨyang wê ông nêl ge obêc vô nôn lec i tɨyi xocbê ông vông i vin dɨ kɨtaa a ge.” Om hɨyôv manôn tibed tige xomxo yuac tige vô nivɨha lec. ");
INSERT INTO ptp_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Yesu la vac Pita ben, lêc yê wê Pita yen vêxta vông yidac ngwax tum mɨ yêp. ");
INSERT INTO ptp_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Om la hôm lec vɨgê, dɨ yidac tip la, mêdec vêx tyo kɨdi lec dɨ viac yaên ên nêb i ya. ");
INSERT INTO ptp_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Vô hucên xomxo tɨbeac kô lie wê vɨmwo nipaên dô vac he nɨlô gee mɨ val vô Yesu. Mêd Yesu nêl dɨ vɨmwo nipaên tigee lop mɨ la vêl ên he, dɨ Yesu vông he wê yidac ge vɨhati vô nivɨha lec hɨxôn. ");
INSERT INTO ptp_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Om kɨyang wê plopete Aisaia nêl ilage vô nôn lec. Ilage Aisaia nêl bêga ên nêbê, “Ici va kô il nêd myavɨnê hɨxôn yidac wê vông il ge vêl.” ");
INSERT INTO ptp_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Yesu yê wê xomxo tɨbeac buu i ge, om nêl vô nue ngɨvihi ên nêbê, “Xam lam ên il ob la mia luaên vɨlu ganê.” ");
INSERT INTO ptp_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Mêdec xomxo wê xovô Moses xolac ge ti val vô Yesu dɨ nêl vô i ên nêbê, “Xolac kehe, vɨgwe vɨhati wê ông ob la vac ge, a ob loc hɨxôn ông.” ");
INSERT INTO ptp_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Lêc Yesu nêl vô i ên nêbê, “Le i lêc nêl decdec bê ông ob lam hɨxôn a lêm, ên lɨlii mi yêp vac yen, dɨ menac mi vông lɨwihi lec xax, lêc a, Xomxo Nu, a bog wê a ob xêp vac ge ma.” ");
INSERT INTO ptp_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Nang dêc xomxo wê mi tɨmu vô Yesu vɨxa ge ti nêl vô i ên nêbê, “Xomxo levac, ge tɨyi wê a ob la yev mag vêl lê, lêc lam tɨmu vô ông vɨxam, me?” ");
INSERT INTO ptp_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Lêc Yesu nêl vô i ên nêbê, “Ông lam tɨmu vô a vɨxag, dɨ xomxo yibên vaci i yev xomxo yibên.” ");
INSERT INTO ptp_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Nang dêc Yesu la lec dipac dɨ nue ngɨvihi la hɨxôn dɨ he la. ");
INSERT INTO ptp_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","He mɨla mia luaên mahɨgun lê, lêc lea mabu val, om mia kɨpyax la vac dipac nɨlô mɨ pup lec, dɨ Yesu dɨyêp, ");
INSERT INTO ptp_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","om nue ngɨvihi la tɨpi vô i dɨ nêl vô i ên nêbê, “Xomxo levac, ngɨdu xe xôn, ên il ob la xib.” ");
INSERT INTO ptp_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Lêc Yesu nêl vô he ên nêbê, “Xam xona ên va? Xam nêm vông vinên nipwo tya.” Mêd Yesu kɨdi lec dɨ pɨping lea yuu mia, om lea levac tip la dɨ mia tɨpiên ma. ");
INSERT INTO ptp_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Om nue ngɨvihi yetac mabu dɨ nêl vôma ên nêbê, “Xomxo tiga letya, lêc lea yuu mia vô nɨnya lehe vô i?” ");
INSERT INTO ptp_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Yesu he nue ngɨvihi dô lec dipac dɨ loc mɨ la tɨbii Gadala ben wê yêp mia luaên vɨlu ganê. Xomxo yuu wê vɨmwo nipaên dô vac yuu nɨlô ge dô vac vɨgwe tige. Yuu mi dô vac vɨgwe wê xomxo yibên mi yêp vac ge, lêc yuu yê wê Yesu val ge om yuu la vô i. Xomxo yuu ge la dô vɨmen, om xomxo xona ên yuu dɨ o vɨlee mɨ la vô môp tige lêm. ");
INSERT INTO ptp_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Mêdec yuu tyuc ên nêbê, “Anutu nu ông, ông ob vông bêna vô xe? Buc tige valên gên ma, lêc ông lam ên ông nêb ông ob vông xe vô nipaên tax, me?” ");
INSERT INTO ptp_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Yuu nêl bêge, mêd bwoc kɨdu levac dɨya gê teva tya. ");
INSERT INTO ptp_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Om vɨmwo nipaên wê dô vac yuu nɨlô gee kɨtaa Yesu ên nêbê, “Ông obêc tii xe vêl ge od ông vông xe la dô vac bwoc tiganêe nɨlô.” ");
INSERT INTO ptp_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Om Yesu nêl vô he ên nêbê, “Xam loc.” Mêgem vɨmwo nipaên tigee lop vêl ên xomxo yuu ge dɨ la vac bwoc nɨlô, mêdec bwoc tigee vɨhati tup mɨ la vac madia dɨ la tô vac mia dɨ yib mɨma vêl. ");
INSERT INTO ptp_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Mêd xomxo wê mi viac bwoc tigee pec mɨ la vɨyangtôv dɨ mɨla nêl kɨyang lec bwoc wê yib ge kɨtong dɨ nêl xomxo yuu wê vɨmwo nipaên dô vac yuu nɨlô ge kɨtong hɨxôn. ");
INSERT INTO ptp_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Om tɨbii wê dô vac vɨgwe tige vɨhati xona ên Yesu om lam myag i mɨ yêvô, dɨ nêl kɨyang xêkɨzêc vô i ên nêbê i sea he ben dɨ loc vac vɨgwe bangwe. ");
INSERT INTO ptp_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Yesu lec dipac mɨ lax mɨ la mia luaên vɨlu ganê mɨ la ben. ");
INSERT INTO ptp_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Mêdec tɨbii ken xomxo wê len vô xêlehe ge ti lec pêt wê i vông ge mɨ lam vô Yesu. Mêgem Yesu yê wê he vông i vin ge, om nêl vô xomxo tyo ên nêbê, “Nug, ông xêmyaa i vô nivɨha, ên a kɨtya ông nêm nipaên vêl pyap.” ");
INSERT INTO ptp_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Lêcom xomxo wê xovô Moses xolac gee dô hɨxôn om xo vac nɨlô ên nêbê, “Xomxo tige so vya vô Anutu.” ");
INSERT INTO ptp_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Lêc Yesu xovô kɨyang wê he xo vac nɨlô ge, om nêl vô he ên nêbê, “Bêna lêc xam xo kɨyang nipaên bêge vac nɨlômê? ");
INSERT INTO ptp_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Kɨyang bêna il ob nêl lutibedê? A ob nêl bê ‘a kɨtya ông nêm nipaên vêl,’ me a ob nêl bê ‘ông kɨdi lec mɨ loc’? ");
INSERT INTO ptp_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Mêlêc a nêb a ob vông xovôên vô xam bê a, Xomxo Nu, a tɨyi wê a ob kɨtya xomxo nên nipaên vêl gê kɨbun ga ge.” Mêgem Yesu nêl vô xomxo ti wê len vô xêlehe ge ên nêbê, “Kɨdi lec mɨ hôm ông guhu lec dɨ lôc bom.” ");
INSERT INTO ptp_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Mêd vux tyo kɨdi lec mɨ la ben. ");
INSERT INTO ptp_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Mêgem xomxo tɨbeac yê dɨ xona mabu dɨ pɨmil Anutu lê, ên wê i vông xêkɨzêc tibêge vô xomxo tige. ");
INSERT INTO ptp_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Pyap dêc Yesu loc mɨ la, lêc mɨla yê xomxo ti lê nêbê Matyu wê xeedô vac xumac wê he mi kô takis vac ge. Om Yesu nêl vô i ên nêbê, “Lam tɨmu vô a vɨxag.” Mêgem Matyu kɨdi lec dɨ la tɨmu vô Yesu vɨxa. ");
INSERT INTO ptp_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Mêdec Yesu la ya vac Matyu ben, dɨ tɨbii nipaên wê mi kô takis ge hɨxôn tɨbii nipaên tɨbeac, he lam dô mɨ ya hɨxôn Yesu he nue ngɨvihi. ");
INSERT INTO ptp_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Lêc he Palisi ge, he yê om nêl vô Yesu nue ngɨvihi ên nêbê, “Bêna lêc xam nêm xolac kehe la ya hɨxôn tɨbii nipaên wê mi kô takis ge yuu tɨbii nipaên tɨbeacê?” ");
INSERT INTO ptp_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Lêc Yesu ngô wê he nêl ge om nêl vô he ên nêbê, “Xomxo nivɨha ob la vô docta lêm. Nge, tɨbii wê yidac ge wê ob la vô docta. ");
INSERT INTO ptp_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Om xam loc dɨ xovô kɨyang wê yêp vac xolac bêga ên nêbê, ‘A o nêb xam si daa vô a lêm. Nge, a nêb xam xo vɨgwe pɨsiv ênma môci.’ Xolac nêl bêge, om a o lam ên a nêb a ob tyuc xomxo nivɨha lêm. Nge, a lam ên a nêb a ob tyuc xomxo nipaên.” ");
INSERT INTO ptp_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Nang dêc Jon Lipacên nue ngɨvihi val vô Yesu dɨ nêl vô i ên nêbê, “Xe hɨxôn Palisi, xe mi ngɨbua yaên tɨyi buc tɨbeac, lêc bêna lêc ông nume ngɨvihi o ngɨbua yaên lêm?” ");
INSERT INTO ptp_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Om Yesu nêl kɨyang pɨlepacên ti vô he ên nêbê, “Tɨbii lie ti obêc ii vêx lêc gên dô hɨxôn lie ge od he nɨlô ob vô vɨyin, me? Ma vêl. Lêc obêc buc tɨmuên wê tɨbii ob kô li tige vêl ên he ge od he ob ngɨbua yaên. ");
INSERT INTO ptp_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Dɨ xomxo ti nên ngakwi obêc tip ge od obêc kɨping ngakwi paha myahɨpu ti vêl mɨ la duu lec tɨkwê lêm. Ên obêc vông bêge ge od myahɨpu paha tige obêc tɨtê tɨkwê lêx dɨ tocên obêc vô myakɨpwoc. ");
INSERT INTO ptp_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Dɨ xomxo ti ob too wain paha vac bwoc ninɨvi tɨkwê lêm. Ên obêc too vac ge od wain obêc nyôn ninɨvi tɨkwê tige tip dɨ too la dɨ ninɨvi vô nipaên. Om wain paha ge, xomxo too vac bwoc ninɨvi paha, dɨ wain yuu xôn ninɨvi ob dô nivɨha.” ");
INSERT INTO ptp_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Yesu gên nêl kɨyang bêge vô he, mêdec tɨbii levac ti lam yev vɨxa kɨtu vô i dɨ nêl ên nêbê, “A nug vêx gên yib tya ga om ông lam vyax vɨgêm lec i, ên i kɨdi lec mavɨha i tii vac.” ");
INSERT INTO ptp_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Mêgem Yesu kɨdi lec hɨxôn nue ngɨvihi mɨ he la. ");
INSERT INTO ptp_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Mêd vêx ti dô vac he mahɨgun, lêc vêx tige, yidac kwatuacên ti vông i tɨyi klismas vɨgê yuu dɨ yuu tô mɨ la (12), lêc o ma lêm. Vêx tyo val le vô Yesu nɨmi dɨ vyax vɨgê lec Yesu ngakwi myahɨpu, ");
INSERT INTO ptp_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","ên xo ên nêbê, “A obêc hôm lec Yesu ngakwi myahɨpu ge od a obêc vô nivɨha lec.” ");
INSERT INTO ptp_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Mêdec Yesu pɨlepac dɨ yê vêx tyo, om nêl vô ên nêbê, “Nug, ông nɨlôm i vô nivɨha, ên vông vinên wê ông vông ge ob vông ông vô nimvɨha lec.” Mêdec lutibed vêx tige vô nivɨha lec. ");
INSERT INTO ptp_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Mêd Yesu loc mɨ la vac xomxo levac tige ben, dɨ yê he wê vê ngɨvêg ge hɨxôn kɨdu levac wê byag dɨ vông nidɨdun levac ge. ");
INSERT INTO ptp_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Om Yesu nêl vô he ên nêbê, “Xam kɨdi lec mɨ loc, ên nipwo tige o yib lêm. Nge, ici va dɨyêp.” Lêc he nap lec kɨyang wê i nêl ge. ");
INSERT INTO ptp_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Om Yesu tii he lop mɨ la vêl, dɨ la xumac lôma dɨ la hôm lec vêx tyo vɨgê, dɨ i kɨdi lec mavɨha. ");
INSERT INTO ptp_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Mêgem xomxo nêl kɨyang tige vô levac vac vɨgwe tigee vɨhati. ");
INSERT INTO ptp_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Yesu sea vɨgwe tige mɨ la, dɨ xomxo yuu wê manôn toc ge tɨmu vô i vɨxa, dɨ keac vya levac ên nêbê, “Devit nu, xo vɨgwe pɨsiv ên xii.” ");
INSERT INTO ptp_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Mêdec Yesu la vac xumac nɨlô, dɨ xomxo yuu ge val vô i, dɨ Yesu kɨnêg vô yuu ên nêbê, “Muu vông i vin ên muu nêb a tɨyi wê a ob vông muu mamnôn i seac ge, me?” Dɨ yuu lee yuu ên nêbê, “Apumtau, ông tɨyi.” ");
INSERT INTO ptp_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Mêgem Yesu vyax vɨgê lec yuu manôn dɨ nêl ên nêbê, “Muu mamnôn i seac i tɨyi xocbê vông vinên wê muu vông ge.” ");
INSERT INTO ptp_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Mêgem yuu manôn seac. Dɨ Yesu nêl xêkɨzêc vô yuu ên nêbê, “Le i lêc loc nêl wê a vông muu mamnôn seac ge kɨtong vô tɨbii lêm.” ");
INSERT INTO ptp_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Lêc yuu la dɨ la nêl Yesu lê vô levac vac vɨgwe vɨhati. ");
INSERT INTO ptp_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Yuu la dɨ xomxo kô vux ti wê vɨmwo nipaên vông kwa ma ge lam vô Yesu. ");
INSERT INTO ptp_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Mêdec Yesu tii vɨmwo nipaên la vêl om xomxo tige keac vya tyip nivɨha. Om xomxo tɨbeac ngô dɨ yetac mabu dɨ nêl ên nêbê, “Il o xê do levac bêga ti vac vɨgwe Islel ila lêm.” ");
INSERT INTO ptp_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Lêc he Palisi nêl ên nêbê, “Yesu tii vɨmwo nipaên vêl ya xêkɨzêc wê vɨmwo nipaên nên levac vông ge.” ");
INSERT INTO ptp_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Yesu mɨla vɨlee vac vɨgwe levac hɨxôn vɨgwe nipwo vɨhati, dɨ la nêl kɨyang vô xomxo vac he xumac lɨlo toto dɨ nêl xolac nivɨha lec Anutu ben vô he dɨ vông he wê yidac hɨxôn myavɨnê toto ge vɨhati vô nivɨha lec. ");
INSERT INTO ptp_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Yesu yê xomxo tɨbeac wê lam vô i ge dɨ xo vɨgwe pɨsiv ên he, ên he pɨyôp juda dɨ he dô hɨxôn vɨyin tɨyi xocbê bwoc sipsip wê xomxo ti o viac he lêm ge. ");
INSERT INTO ptp_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Om Yesu nêl vô nue ngɨvihi ên nêbê, “Yaên wê dô vac yuac ge vô nôn tɨbeac pyap, lêc nue yuac wê ob la kô nôn gee, he yuutyabed. ");
INSERT INTO ptp_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Om xam kɨtaa vô Apumtau wê viac yuac ge ên i vông nue yuac tɨbeac i loc kɨtuc yaên wê i vông ge i dô kɨdu tibed.” ");
INSERT INTO ptp_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Yesu tyuc nue ngɨvihi vɨgê yuu dɨ tô mɨ la yuu lam vô i, dɨ vông xêkɨzêc vô he tɨyi wê he ob tii vɨmwo nipaên vêl ên xomxo dɨ vông xomxo wê yidac hɨxôn myavɨnê toto ge vô nivɨha lec. ");
INSERT INTO ptp_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Nue ngɨvihi vɨgê yuu dɨ tô mɨ la yuu gee lê bêga nêbê, taxlee ge, Saimon wê lê ngwe nêbê Pita ge yuu li Andlu. Dɨ Jems wê ma Sebedi ge yuu li Jon. ");
INSERT INTO ptp_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Dɨ Pilip yuu Batolomyu, dɨ Tomas, dɨ Matyu wê mi kô takis ge, dɨ Jems wê ma Alpias ge, dɨ Tadias, ");
INSERT INTO ptp_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","dɨ Saimon Selot, dɨ Judas Iskaliot wê vông Yesu la vac tɨbii vevac vɨgê ge. ");
INSERT INTO ptp_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Yesu nêb ob vông nue ngɨvihi vɨgê yuu dɨ tô mɨ la yuu gee i loc, om nêl vô he ên nêbê, “Xam loc vôên tɨbii baba i ma, dɨ loc vacên tɨbii Samelia vɨgwe i ma. ");
INSERT INTO ptp_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Dɨ xam loc vô lime Islel mô, ên he tɨyi xocbê bwoc sipsip wê lung sea dɨ la xôa ma ge. ");
INSERT INTO ptp_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Om xam loc nêl kɨyang vô he bêga bê, ‘Anutu buc vô kwabo lec.’ ");
INSERT INTO ptp_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Xam loc vông xomxo yidac i vô nivɨha lec, dɨ tɨpi vô xomxo yibên i kɨdi lec, dɨ vông xomxo wê kɨtyax mahɨzihɨzi ge i vô nivɨha lec, dɨ tii vɨmwo nipaên i loc vêl ên xomxo. Xêkɨzêc tige a vông pɨleva vô xam, om xam vông pɨleva vô xomxo dɨ le i lêc kô mone lec lêm. ");
INSERT INTO ptp_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","“Le i lêc su mone gol yuu silva dɨ kapa vac xam vɨxec nu lêm. ");
INSERT INTO ptp_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Dɨ le i lêc bya vɨxec mɨ loc vô môp lêm, dɨ le i lêc kô nivɨmihi yuu lêm, dɨ le i lêc kô su hɨxôn pɨtoa lêm. Ên xomxo ti obêc vông yuac vô xomxo ge od ob kô xen yaên vô xomxo tigee. ");
INSERT INTO ptp_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Xam obêc la vac vɨgwe levac yuu nipwo ge od xam wêvô xomxo nivɨha dɨ loc dô hɨxôn, dɨ i loc tyip vô buc wê xam ob sea vɨgwe tige dɨ la ge. ");
INSERT INTO ptp_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Om wê xam obêc la vac xumac nɨlô tige ge od xam nêl kɨyang nivɨha vô he. ");
INSERT INTO ptp_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Dɨ xomxo wê dô vac xumac tige obêc lee yuu ên nêbê xam dô hɨxôn he ge od kɨyang nivɨha wê xam nêl ge i yêp vô he. Lêc he obêc tyuc lec lêm ge od kɨyang nivɨha wê xam nêl ge i lôm lam vô xacxam va. ");
INSERT INTO ptp_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Dɨ xomxo ti obêc kô xam lec nivɨha lêm dɨ ob ngô kɨyang wê xam nêl ge lêm ge od xam lɨloo vɨjuva vêl ên vɨxam, ên i nêl he nên nipaên kɨtong vô he, dɨ xam sea xumac yuu vɨgwe tige dɨ loc. ");
INSERT INTO ptp_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","A nêl vɨxôhɨlôg nôn vô xam bê vô buc tɨmuên wê Anutu obêc yaxên xomxo vɨhati nên kɨyang ge od Anutu obêc vông myavɨwen nipaên vô xomxo vɨyang tige luu Sodom yuu Gomola vêl. ");
INSERT INTO ptp_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“A ob vông xam loc i tɨyi xocbê bwoc sipsip wê xam ob la vac noo vɨmen mahɨgun ge. Om xam viac môp wê xam vông ge nivɨha, dɨ dô mamlehe i tɨyi xocbê tucluu ge. ");
INSERT INTO ptp_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Xam viac xam ên xomxo, ên he ob kô xam mɨ la vông kɨyang vô xam, dɨ he ob pɨsa xam ya yihi vac he xumac lɨlo, ");
INSERT INTO ptp_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","dɨ kô xam mɨ la lax vô gavman levac yuu king manôn dɨ vông kɨyang vô xam ên wê xam vông i vin a ge. Om xam ob nêl a kɨyang kɨtong vô he hɨxôn tɨbii madɨluhu. ");
INSERT INTO ptp_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Mêlêc buc wê he obêc kô xam mɨ la vac kot ge od xam o lêc myag môp yuu kɨyang wê xam ob nêl ge lêm. Ên kɨyang wê xam ob nêl ge Anutu ob vông vô xam vô buc tige. ");
INSERT INTO ptp_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Om xacxam va ob nêl kɨyang lêm. Nge, Myakɨlôhô Ngɨbua wê Mag Anutu vông ge vaci ob nêl kɨyang vac xam myam. ");
INSERT INTO ptp_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Vô buc tige xomxo obêc vông lie la vac tɨbii vɨgê ên nêb tɨbii i hi he yib, dɨ mae obêc vông bêge vô nue, dɨ nue ob yê tae mae nipaên dɨ vông he la vac tɨbii vɨgê ên nêb tɨbii i hi he yib. ");
INSERT INTO ptp_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Dɨ xomxo vɨhati xêyaa ob vô nipaên vô xam ên wê xam vông i vin a lêg ge. Lêc xomxo ti obêc le xêkɨzêc vac vɨyin dɨ i la tyip vô buc myahɨpu ge od Anutu obêc vông i la dô vac i ben. ");
INSERT INTO ptp_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","He obêc vông vɨyin vô xam vac vɨgwe ngwe ge od xam pec mɨ loc vac vɨgwe bangwe. Ên a nêl vɨxôhɨlôg nôn vô xam bêga bê xam obêc vông yuac vac Islel ben vɨhati lêm, dɨ a, Xomxo Nu, a ob vena tax. ");
INSERT INTO ptp_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Nipwo xumac xulacên ti ob luu ma wê hɨlung yuac vô i ge vêl lêm. Dɨ xomxo yuac ti ob luu xomxo levac wê viac yuac ge vêl lêm. ");
INSERT INTO ptp_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Lêc nipwo xumac xulacên ti obêc tɨyi ma wê hɨlung yuac vô i ge od pyap, dɨ xomxo ti obêc tɨyi xomxo levac wê viac yuac ge od pyap. A tɨyi xocbê xomxo levac wê a viac xumac ge, dɨ xomxo nêl Seten lê ngwe Bielsebul lec a, om xam xovô bêga bê he obêc nêl a nipaên ge od he ob nêl nipaên lec a nuge xam hɨxôn luu vêl. ");
INSERT INTO ptp_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Om xam o lêc xona ên xomxo lêm. Ên kɨyang vɨhati wê yêp vac xomxo nɨlô ge ob lam yêp seac, dɨ kɨyang wê yêp xôpacên ge, vɨhati ob lam yêp seac dɨ xomxo ob xovô. ");
INSERT INTO ptp_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Kɨyang wê a nêl xôpacên vô xam ge, xam loc nêl i yêp seac vô xomxo mɨ he i ngô. Dɨ kɨyang wê a nêl kɨmunaên vô xam ge, xam loc le lec wetôv dɨ nêl i yêp seac vô xomxo mɨ he i ngô. ");
INSERT INTO ptp_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Dɨ xam o lêc xona ên he wê ob hi xam nimnɨvi yib ge lêm, ên he o tɨyi wê he ob hi kɨnum yib hɨxôn ge lêm. Xam xona ên Anutu môci, ên Anutu tɨyi wê ob vông xam kɨnum yuu xôn nimnɨvi la vac vɨgwe nipaên. ");
INSERT INTO ptp_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","“Xomxo mi kɨsuu menac nipwo yuu ya mone tibed. Lêc Anutu obêc lee yuu lêm ge od menac nipwo tigee ti ob tô mɨ la kɨbun lêm. ");
INSERT INTO ptp_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Dɨ xam ge, Anutu kɨtong xam bamzub lihi vɨhati pyap. ");
INSERT INTO ptp_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Om xam xonaên i ma, ên Anutu xêyaa vin lec xam ngɨnoo menac nipwo vɨhati vêl. ");
INSERT INTO ptp_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Om xomxo ti obêc nêl a kɨtong vô xomxo ge od a ob nêl xomxo tige kɨtong êno vô Mag Anutu wê dô lag puunê ge. ");
INSERT INTO ptp_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Lêc xomxo ti obêc yax a vun vô xomxo ge od a ob yax i vun êno vô Mag Anutu wê dô lag puunê ge. ");
INSERT INTO ptp_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Xam o lêc xo bê a lam ên a nêb a ob kɨtov vevac i tip gê kɨbun ga lêm. Ên a o lam ên a nêb a ob kɨtov vevac i tip lêm. Nge, a kô yipac levac mɨ lam. ");
INSERT INTO ptp_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Ên a lam ên a nêb a ob vông xomxo i dô kɨdu kɨdu. Om ma yuu nu vux xêyaa ob vô myavɨnê vôma, dɨ ta yuu nu vêx xêyaa ob vô myavɨnê vôma, dɨ yen vêxwo yuu yen vêxta xêyaa ob vô myavɨnê vôma, ");
INSERT INTO ptp_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","dɨ xomxo wê dô vac xumac tibed gee, he ob yêma nipaên. ");
INSERT INTO ptp_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Xomxo ti xêyaa obêc vin lec ta yuu ma luu wê xêyaa vin lec a ge vêl ge od o tɨyi wê ob tu a xe ge lêm. Dɨ xomxo ti xêyaa obêc vin lec nue vêx yuu vux luu wê xêyaa vin lec a ge vêl ge od o tɨyi wê ob tu a xe ge lêm. ");
INSERT INTO ptp_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Dɨ xomxo ti obêc kɨlê xax pola wê i vông ge mɨ tɨmu vô a vɨxag lêm ge od o tɨyi wê ob tu a xe ge lêm. ");
INSERT INTO ptp_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Ên xomxo ti obêc viac ninɨvi ên yibên ge od ob yib mɨ la xôa ma. Lêc xomxo ti obêc yib lec a lêg ge od obêc dô mavɨha. ");
INSERT INTO ptp_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Xomxo ti obêc kô xam lec nivɨha ge od tɨyi xocbê kô a lec nivɨha êno. Dɨ xomxo ti obêc kô a lec nivɨha ge od tɨyi xocbê kô Anutu wê vông a lam ge lec nivɨha êno. ");
INSERT INTO ptp_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Xomxo ti obêc kô plopete ti lec nivɨha ên wê i plopete ge od yuu xôn obêc kô nôn nivɨha tɨyima, dɨ xomxo ti obêc kô xomxo nivɨha ti lec nivɨha ên wê i xomxo nivɨha ge od yuu xôn obêc kô nôn nivɨha tɨyima. ");
INSERT INTO ptp_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Dɨ xomxo ti obêc vông mia ningɨgooên vac kap vô a nuge yuac ti ên wê i tu a nug ge od a nêl vɨxôhɨlôg nôn vô xam bê nôn nivɨha obêc ma vô i lêm. Nge, ob kô nôn lec yuac wê i vông ge.” ");
INSERT INTO ptp_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Yesu nêl kɨyang vô nue ngɨvihi vɨgê yuu dɨ tô mɨ la yuu lec yuac wê he ob vông ge, pyap dêc sea vɨgwe tige mɨ la vɨlee vac vɨgwe toto wê yêp vac vɨgwe levac tige dɨ la nêl kɨyang vô xomxo dɨ tɨxuu he ya xolac. ");
INSERT INTO ptp_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Jon Lipacên dô vac xumac kalabuhu, dɨ ngô kɨyang lec yuac wê Kɨlisi vông ge. Om vông i nue ngɨvihi la vô Yesu, ");
INSERT INTO ptp_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","dɨ he la kɨnêg ên nêbê, “Xomxo ti wê plopete ilage nêl ên nêbê obêc val ge, ông tyo ga mê, me xe ob dô bin xomxo ngwe?” ");
INSERT INTO ptp_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Lêc Yesu luu he vya ên nêbê, “Xam lôc nêl yuac wê xam wê dɨ ngô gee kɨtong vô Jon bê ");
INSERT INTO ptp_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","xomxo wê manôn tocên gee, he manôn seac, dɨ xomxo wê vɨxa nipaên gee, he vɨxa vô nivɨha lec mɨ he la nivɨha, dɨ xomxo wê kɨtyax mahɨzihɨzi gee, he vô nivɨha lec, dɨ xomxo wê nɨnya vô kɨtu gee ngô kɨyang, dɨ xomxo yibên kɨdi lec mavɨha, dɨ xomxo wê nên susu maên gee ngô xolac nivɨha. ");
INSERT INTO ptp_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Vông vinên wê xomxo ti vông ge obêc vô nipaên ên a lêm ge od ob dô hɨxôn xêyaa nivɨha.” ");
INSERT INTO ptp_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Jon nue ngɨvihi lax mɨ la vêl, dɨ Yesu nêl kɨyang vô xomxo kɨdu levac tige lec Jon bêga ên nêbê, “Ilage wê xam la vô Jon vac vɨgwe mahɨgun pɨleva ge od xam la ên xam nêb xam ob la wê vatyaê? Xam la ên xam nêb xam ob la wê duvac wê lea kɨlê i la dɨ i hɨvip lec nang ge, me? Maê. ");
INSERT INTO ptp_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Om xam la ên xam nêb xam ob la wê vatya? Xam la ên xam nêb xam ob la wê xomxo wê vɨnyum ngakwi nivɨhavɨha ge ti, me? Maê. Xomxo wê mi vɨnyum ngakwi nivɨhavɨha ge he mi dô vac king ben. ");
INSERT INTO ptp_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Om xam la vô i ên va? Xam la ên xam nêb xam ob la wê plopete ti, me? Vɨxôhɨlôg, a nêl vô xam bê Jon ge plopete ti wê luu plopete vɨhati ge vêl. ");
INSERT INTO ptp_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Ilage xomxo kɨvuu kɨyang lec Jon mɨ i yêp vac xolac bêga ên nêbê, ‘Wê lê. A ob vông xomxo ti i kô a kɨyang mɨ loc mug ông nêm môp ên i viac môp wê ông obêc mɨla vac ge.’ ");
INSERT INTO ptp_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Kɨyang nêl bêge, dɨ a ob nêl vɨxôhɨlôg nôn vô xam bê Jon Lipacên ge xomxo levac luu xomxo kɨbun ga vɨhati vêl. Lêcom xomxo vɨhati wê vô nipwo lec vac Anutu ben ge wê ngɨnoo Jon vêl. ");
INSERT INTO ptp_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","“Vô buc wê Jon Lipacên val ge dɨ i lam tyip gwêbaga hɨxôn, Anutu xolac lam yêp seac om xomxo tɨbeac ngô dɨ vông he nɨlô la dɨluhu vô Anutu. ");
INSERT INTO ptp_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Ên Moses he plopete vɨhati nêl Anutu kɨyang kɨtong dɨ i val tyip lec Jon. ");
INSERT INTO ptp_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Dɨ xam obêc nêb xam ob ngô ge, od xam ngô bê Jon ge Ilaija wê he nêl ilage ên nêb ob val ge. ");
INSERT INTO ptp_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Xomxo nɨnya obêc yêp ge od i ngô kɨyang. ");
INSERT INTO ptp_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Lêc xomxo wê dô vac buc gwêbaga, a ob tɨxuu he lec vatya? He tɨyi xocbê nume nipwo wê dô lec wetôv dɨ tyuc la vô lie nipwo ên nêbê, ");
INSERT INTO ptp_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Xame, xe hi vyang, lêc xam o yoo lêm, dɨ xe vông tɨlôt, lêc xam o vông hɨxôn lêm.’ ");
INSERT INTO ptp_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Môp tibêge wê nume nipwo vông ge tɨyi xocbê xam vông vô xii Jon, ên Jon val, lêc o ya yaên dɨ num wain lêm, lêc xam nêl ên xam nêbê vɨmwo nipaên dô vac i nɨlô. ");
INSERT INTO ptp_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Nang dêc a, Xomxo Nu, a val, lêc a mi xa dɨ mi num, lêc xam nêl ên xam nêbê, ‘Wê lê. Xomxo tige mi ya levac dɨ mi num levac mɨ vô mavmav dɨ mi dô hɨxôn xomxo nipaên wê kô takis ge hɨxôn tɨbii nipaên tɨbeac.’ Xam mi nêl bêge, lêc yuac wê xii Jon vông ge ob hɨlung vô xam bê Anutu vông xovôên vô xii, dɨ xovôên wê i vông ge vɨxôhɨlôg nôn.” ");
INSERT INTO ptp_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Yesu vông do levac vac vɨgwe tɨbeac, lêc xomxo vac vɨgwe tigee o pɨlepac he nɨlô lêm. Om Yesu nêl he nên nipaên kɨtong vô he bêga ên nêbê, ");
INSERT INTO ptp_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Xam Kolasin, dɨ xam Betsaida, xam xona nêm, ên xam obêc tulec vɨyin. Ên do levac wê a vông vac xam bom ge, xomxo ti obêc vông vac tɨbii Taia yuu Saidon ben ilage ge od tɨbii Taia yuu Saidon obêc yê dɨ xovô he nên nipaên dɨ lipac vɨwev lec he dɨ pɨlepac he nɨlô la vô Anutu. ");
INSERT INTO ptp_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Om a ob nêl vô xam bê vô buc tɨmuên wê Anutu obêc yaxên xomxo nên kɨyang ge od Anutu obêc vông myavɨwen nipaên vô xam luu Taia yuu Saidon vêl. ");
INSERT INTO ptp_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Dɨ xam Kapaneam, xam nêb xomxo i kô xam lec i loc yêp kɨsiinê, me? Ma vêl. Xam ob la vac vɨgwe nipaên. Ên do levac wê a vông vac xam bom ge, xomxo ti obêc vông vac tɨbii Sodom ben ilage ge od vɨgwe Sodom ob yêp dɨ i val vô gwêbaga hɨxôn. ");
INSERT INTO ptp_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Om a ob nêl vô xam bê vô buc tɨmuên wê Anutu obêc tɨtô xomxo nên kɨyang ge od Anutu obêc vông myavɨwen nipaên vô xam luu Sodom vêl.” ");
INSERT INTO ptp_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Vô buc tige Yesu kɨtaa bêga ên nêbê, “Mag Anutu, ông lag yuu kɨbun kehe ông. Om a pɨmil ông ên wê ông o vông kɨyang tige vô xomxo wê xovôên yuu pɨyôp levac ge lêm. Nge, ông vông vô xomxo wê gên o xovô lêm ge, ");
INSERT INTO ptp_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","ên ôcông va xovô ên nêb ông ob vông bêge ge. ");
INSERT INTO ptp_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“Mag vông xêkɨzêc yuu xovôên vɨhati ge vac a vɨgêg. Xomxo ti o xovô nu a lêm. Nge, Mag vaci wê xovô a. Dɨ xomxo ti o xovô Mag lêm. Nge, aca va wê a xovô Mag, dɨ xomxo wê a nêb a ob hɨlung Mag vô he ge, he ob xovô Mag. ");
INSERT INTO ptp_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Xam wê xam vông yuac levac dɨ kɨlê vɨyin ge, xam lam vô a ên lam dô seac vêl. ");
INSERT INTO ptp_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Xam lam tu a nuge yuac dɨ kô xovôên nivɨha vô a, ên a ga xomxo malehe ti dɨ a o yong a lêm, om xam nɨlôm ob dô seac vêl. ");
INSERT INTO ptp_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Ên yuac wê a vông vô xam ge, ge o yuac vɨyin lêm ên a ngɨdu xam xôn. Dɨ xolac wê a vông vô xam ên a nêb xam vông ge, ge o vɨyin lêm.” ");
INSERT INTO ptp_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Vô buc wê sabat ge, Yesu he nue ngɨvihi la vɨlee mɨ la vac yuac lôma wê wit ge. Lêc vip den nue ngɨvihi, om he le yul wit nôn mɨ ya. ");
INSERT INTO ptp_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Lêc Palisi ya yê wê he vông ge om nêl vô Yesu ên nêbê, “Wê lê, gwêbaga buc sabat wê Moses xolac vɨbu nêb il ob vông yuac ti lec lêm ge, lêc nume ngɨvihi vông yuac lec.” ");
INSERT INTO ptp_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Lêc Yesu nêl vô he ên nêbê, “Mêd xam o kɨtong xolac wê nêl lec bug Devit ge lêm, me? Devit he lie dô, lêc vip den he, ");
INSERT INTO ptp_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","om he la vac Anutu xumac ngɨbua dɨ la ya blet wê xomxo daa siên tung vô Anutu manôn ge. Blet tige, Devit he lie o tɨyi wê ob ya ge lêm. Nge, xomxo daa siên gee, heche va ob ya. ");
INSERT INTO ptp_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Mêd xam o kɨtong kɨyang ti wê yêp vac Moses xolac ge lêm, me? Kɨyang tige nêl ên nêbê xomxo daa siên mi vông he yuac vac Anutu xumac ngɨbua lec buc sabat, om xocbê he pwoo kɨyang lec buc sabat vac ge, lêc he o vông i so lêm. ");
INSERT INTO ptp_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Om a ob nêl vô xam bê a ga a luu Anutu vông xumac ngɨbua tige vêl. ");
INSERT INTO ptp_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Kɨyang yêp vac xolac bêga ên nêbê, ‘A o nêb xam si daa vô a lêm. Nge, a nêb xam xo vɨgwe pɨsiv ênma môci.’ Kɨyang nêl bêge, om xam obêc xovô kɨyang tige kehe ge od xam obêc vông vɨyin vô he wê nên kɨyang maên ge lêm. ");
INSERT INTO ptp_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Ên a, Xomxo Nu, wê a tu sabat kehe.” ");
INSERT INTO ptp_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Yesu sea yuac lôma dɨ la vac Yuda xumac lɨlo ti. ");
INSERT INTO ptp_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Lêc xomxo wê vɨgê vɨlu vô xêlehe ge ti dô. Mêdêc xomxo ya nêb ob vông kot vô Yesu, om he kɨnêg vô i ên nêbê, “Ge tɨyi wê il ob vông xomxo i vô nivɨha lec vô buc sabat ge, me?” ");
INSERT INTO ptp_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Om Yesu nêl vô he ên nêbê, “Xomxo ti vac xam mahɨgun ge, bwoc sipsip tibed wê i vông ge obêc tô vac lôva lec buc sabat ge od xomxo tige obêc la pul i lôm kɨsii ên lôva, me? Nge, obêc pul i lôm. ");
INSERT INTO ptp_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Xomxo ngɨnoo bwoc sipsip vêl, om ge tɨyi wê il ob vông nivɨha vô xomxo lec buc sabat.” ");
INSERT INTO ptp_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Mêdec Yesu nêl vô xomxo ti wê vɨgê vɨlu vô xêlehe ge ên nêbê, “Tɨtô vɨgêm.” Om xomxo tyo tɨtô vɨgê, lêc vɨgê vô nivɨha lec tɨyi xocbê vɨgê vɨluo. ");
INSERT INTO ptp_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Om he Palisi kɨdi lec dɨ la kɨtucma dɨ myag môp wê nêb he ob hi Yesu i yib lec ge. ");
INSERT INTO ptp_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Lêc Yesu xovô kɨyang wê he Palisi nêl vôma ge om sea vɨgwe tige dɨ la. Lêc xomxo tɨbeac la tɨmu vô i vɨxa, om Yesu vông he wê yidac gee vɨhati vô nivɨha lec, ");
INSERT INTO ptp_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","lêc vɨbu he nêb he nêlên i kɨtong vôên xomxo i ma. ");
INSERT INTO ptp_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Om Anutu kɨyang wê plopete Aisaia nêl ilage vô nôn lec. Kɨyang tige nêl bêga ên nêbê, ");
INSERT INTO ptp_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Wê lê. Xomxo tige, a nug yuac wê a vɨnoo i pyap. A xêgyaa vin lec i, dɨ a xê i nivɨha. A ob vông Myakɨlôhô Ngɨbua wê a vông ge i hɨvun i xôn, dɨ i ob nêl a xolac nivɨha vô tɨbii madɨluhu. ");
INSERT INTO ptp_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Dɨ ob nêl kɨyang kunacên yuu hɨgacên lêm, dɨ ob hɨbap kɨyang vac wetôv bê xomxo i ngô lêm. ");
INSERT INTO ptp_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Xomxo ya tɨyi xocbê duvac wê hɨbu nipwo tya ge, lêc a nug yuac tige ob hɨbu he sea lêm. Dɨ xomxo ya tɨyi xocbê ngwax wê tum lec kɨlen ge, lêc xomxo tyo ob hi i yib lêm. Xomxo tyo ob vông yuac mɨ dô ên vông kɨyang nivɨha i pwoo nipaên i pec. ");
INSERT INTO ptp_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Dɨ tɨbii baba wê o Yuda lêm ge vɨhati ob vông i vin i lê dɨ dô bin i.” ");
INSERT INTO ptp_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Mêd he kô xomxo ti mɨ lam vô Yesu. Vɨmwo nipaên dô vac xomxo tyo nɨlô dɨ vông i manôn toc dɨ vông i dô yac dɨ keacên ma. Om Yesu vông xomxo tyo vô nivɨha lec dɨ manôn seac dɨ i yê vɨgwe dɨ keac. ");
INSERT INTO ptp_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Om xomxo vɨhati wê yê ge yetac mabu dɨ nêl vôma ên nêbê, “Xomxo tige Devit nu, me?” ");
INSERT INTO ptp_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Lêc he Palisi ngô om nêl vôma ên nêbê, “Bielsebul wê tu vɨmwo nipaên nên levac ge vông xêkɨzêc vô Yesu, om Yesu tii vɨmwo nipaên vêl ya xêkɨzêc wê Bielsebul vông ge.” ");
INSERT INTO ptp_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Lêc Yesu xovô kɨyang wê yêp vac he pɨyôp ge om nêl vô he ên nêbê, “Xomxo vɨyang ti obêc le kɨdu yuu dɨ vông vevac vôma ge od he ob dô nipaên. Dɨ xomxo vɨgwe ti me xumac ti obêc hɨbu he la yuu dɨ vông vevac vôma ge od he ob dô nivɨha lêm. ");
INSERT INTO ptp_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Dɨ Seten obêc tii lie dɨ hɨbuma sea ge od xêkɨzêc wê he vông ge ob ngɨduma xôn tibêna? ");
INSERT INTO ptp_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Dɨ a obêc tii vɨmwo nipaên vêl ya xêkɨzêc wê Bielsebul vông ge od xam lime mi tii vɨmwo nipaên vêl ya xêkɨzêc wê letya vông ge? Xam lime i yaxên kɨyang wê xam nêl lec a ge. ");
INSERT INTO ptp_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Lêc a obêc tii vɨmwo nipaên vêl ya xêkɨzêc wê Anutu Myakɨlôhô Ngɨbua vông ge od xam xovô bê Anutu buc val pyap vô xam. ");
INSERT INTO ptp_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Xomxo xêkɨzêc ti obêc dô vac ben xumac lôma ge od tɨbii yôdac ti ob la vac xumac lôma dɨ la vun i susu tibêna? Lêc obêc ku xomxo xêkɨzêc tige xôn ya yihi ge od tɨyi wê ob kô i nên susu vɨhati wê dô vac xumac nɨlô ge mɨ la. ");
INSERT INTO ptp_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Xomxo ti obêc vin a lêm ge od tɨyi xocbê vông vevac vô a. Dɨ xomxo ti obêc kɨtuc xomxo lam vô a lêm ge od tɨyi xocbê tii he moo sea ge. ");
INSERT INTO ptp_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","“Om a ob nêl vô xam bê Anutu tɨyi wê ob kɨtya nipaên vɨhati hɨxôn kɨyang wê xomxo so vya vô i ge vêl. Lêc xomxo ti obêc so vya vô Myakɨlôhô Ngɨbua ge od o tɨyi wê Anutu ob kɨtya i nên nipaên tige vêl ge lêm. ");
INSERT INTO ptp_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Dɨ xomxo ti obêc nêl kɨyang nipaên lec a, Xomxo Nu, ge od Anutu ob kɨtya i nên nipaên vêl. Lêc xomxo ti obêc nêl kɨyang nipaên lec Myakɨlôhô Ngɨbua ge od Anutu ob kɨtya i nên nipaên vêl lêm. Nipaên wê i vông ge, Anutu obêc hôm xôn mɨ i yêp dia dɨ i la tyip vô buc tɨmuên. ");
INSERT INTO ptp_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Xax obêc nivɨha ge od nôn obêc nivɨha, dɨ xax obêc nipaên ge od nôn obêc nipaên. Om xomxo obêc yê xax nôn wê vuac lec yatôv ge od ob xovô bê xax tige nivɨha, me xovô nêbê nipaên. ");
INSERT INTO ptp_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Xam myel nue xam! Xam xomxo nipaên, om xam ob nêl kɨyang nivɨha tibêna? Ên kɨyang wê pup vac xam nɨlôm ge, ge wê xam myam nêl seac. ");
INSERT INTO ptp_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Xomxo nivɨha ge, nivɨha yêp vac nɨlô om mi vông môp nivɨha. Dɨ xomxo nipaên ge, nipaên yêp vac nɨlô om mi vông môp nipaên. ");
INSERT INTO ptp_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","“A ob nêl vô xam bê vô buc tɨmuên wê Anutu obêc yaxên xomxo vɨhati nên kɨyang ge od ob yaxên kɨyang vaxvax wê xomxo nêl ge vɨhati. ");
INSERT INTO ptp_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Wê ông myam obêc nêl kɨyang nivɨha ge od Anutu ob yê ông nêb ông xomxo nivɨha. Dɨ ông myam obêc nêl kɨyang nipaên ge od Anutu ob yê ông nêb ông xomxo nipaên.” ");
INSERT INTO ptp_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Nang dêc xomxo wê xovô Moses xolac gee hɨxôn he Palisi ya nêl vô Yesu ên nêbê, “Xolac kehe, xe nêb ông vông do levac ti ên xe xê.” ");
INSERT INTO ptp_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Lêc Yesu nêl vô he ên nêbê, “Xam gwêbaga, xam ge xomxo nipaên wê xam o vông i vin lêm ge, om xam nêb xam ob wê do levac ti. Lêc a ob vông do levac ti mɨ xam wê lêm. Ên do levac tibed wê a ob hɨlung vô xam ge wê plopete Jona vông ilage. ");
INSERT INTO ptp_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Ên ilage Jona dô vac pis mabu yocên ti nɨlô tɨyi bucên yon dɨ vɨdiiên yon. Om a, Xomxo Nu, a obêc la xêp vac kɨbun nɨlô tɨyi bucên yon dɨ vɨdiiên yon. ");
INSERT INTO ptp_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Om buc tɨmuên wê Anutu obêc yaxên xomxo nên kɨyang ge od tɨbii Niniva obêc kɨdi lec dɨ nêl xam gwêbaga nêm nipaên kɨtong, ên ilage tɨbii Niniva ngô kɨyang wê Jona nêl vô he ge dɨ pɨlepac he, lêc gwêbaga a dô hɨxôn xam dɨ a ngɨnoo Jona vêl, lêc xam o pɨlepac xam lêm. ");
INSERT INTO ptp_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Om buc tɨmuên wê Anutu obêc yaxên xomxo nên kɨyang ge od vêx levac wê tu tɨbii Siba nên kwin ilage obêc kɨdi lec hɨxôn xam wê xam dô gwêbaga dɨ nêl xam nêm nipaên kɨtong. Ên vêx tige kɨdi vac vɨgwe kehe tevabanê ên nêb ob lam ên lam ngô kɨyang wê king Solomon nêl pɨyôp nivɨha ge. Lêcom gwêbaga, a lam dô hɨxôn xam dɨ a ngɨnoo Solomon vêl, lêc xam o ngô a vyag lêm. ");
INSERT INTO ptp_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Vɨmwo nipaên ti obêc lop mɨ la vêl ên xomxo ti ge od ob la vɨlee vac vɨgwe myadongên mɨ la myag vɨgwe wê ob la dô seac vêl vac ge. Lêc yêvôên vɨgwe ti obêc ma ge ");
INSERT INTO ptp_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","od ob nêl bêga bê, ‘A ob lax mɨ la dô vac bog wê a sea dɨ lam ge i tii vac nang.’ Mêd vɨmwo nipaên tige obêc lax mɨ la vô xomxo ti wê dô vac lêc sea mɨ la ge, dɨ ob lax yê wê xomxo tyo pɨtyep dɨ vunac vô pyap lêc dô pɨleva ge. ");
INSERT INTO ptp_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Om obêc lax mɨ la kô vɨmwo nipaên vɨgê vɨlu dɨ sec yuu wê heche va nipaên luu i vêl ge, dɨ kô he mɨ lam dɨ he xôn la dô vac xomxo tige nɨlô. Om xomxo tige dô vac nipaên nôn ngɨnoo vɨwen tax vêl. Om xam xomxo nipaên gwêbaga, xam ob tulec nipaên tɨyi bêge.” ");
INSERT INTO ptp_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Yesu gên nêl kɨyang vô xomxo mɨ dô vac xumac lôma, mêdec tae lie val le xumac kehe ên nêb ob keac vô i. ");
INSERT INTO ptp_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Om xomxo ti nêl vô Yesu ên nêbê, “Tame lime val le xumac kehe ên nêb ob nêl kɨyang vô ông.” ");
INSERT INTO ptp_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Lêc Yesu nêl vô xomxo tyo ên nêbê, “A tag letya? Dɨ a lige letyae?” ");
INSERT INTO ptp_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Mêd hɨlung vɨgê la vô nue ngɨvihi dɨ nêl ên nêbê, “A tage lige wê he dô ga. ");
INSERT INTO ptp_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Ên xomxo wê ngô Mag Anutu lag puunê kɨyang dɨ vông i vô nôn lec ge, he tu a tage lige vêx yuu vux.” ");
INSERT INTO ptp_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Vô buc tige Yesu sea xumac nɨlô dɨ lop mɨ la vɨxun dɨ la dô kɨbun vô mia luaên nɨnya. ");
INSERT INTO ptp_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Mêdec xomxo tɨbeac hɨwocên kɨtuc lam vô i, om Yesu la lec dipac ti dɨ la dô lec, dɨ xomxo kɨdu levac tigee le vô mia luaên nɨnya. ");
INSERT INTO ptp_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Mêd Yesu nêl kɨyang tɨbeac, lêc nêl tɨyi xocbê kɨyang pɨlepacên ge vôhe. Om nêl kɨyang pɨlepacên ti vô he bêga ên nêbê, “Xomxo ti la ên nêb ob la lɨloo susu vê vac yuac. ");
INSERT INTO ptp_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Om lɨloo i la lê, lêc vê ya tô vac môp, om menac lam ya. ");
INSERT INTO ptp_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Dɨ ya tô lec kɨbun nipwo tya wê dô lec ngɨdax kɨsii ge, om tyip lutibed, ");
INSERT INTO ptp_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","lêc ngɨlôhô la tulec ngɨdax ên kɨbun nipwo tya, om hɨyôv ya i vɨlôvac dɨ i yib. ");
INSERT INTO ptp_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Dɨ vê mangwe tô mɨ la dô vac hɨvu kehe, lêc tyip hɨxôn hɨvu, om hɨvu hɨvun i yib. ");
INSERT INTO ptp_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Dɨ ya tô mɨ la dô vac kɨbun nivɨha, om tyip dɨ vuac nôn nivɨha. Mêgem ya vuac nôn 100 dɨ ya vuac nôn 60 dɨ ya vuac nôn 30. ");
INSERT INTO ptp_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Xomxo ti nɨnya obêc yêp ge od i ngô kɨyang tiga.” ");
INSERT INTO ptp_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Om nue ngɨvihi lam kɨnêg vô Yesu ên nêbê, “Bêna lêc ông nêl kɨyang pɨlepacên vô he?” ");
INSERT INTO ptp_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Mêgem Yesu luu he vya bêga ên nêbê, “Kɨyang wê ob nêl Anutu ben kehe kɨtong ge yêp xôpacên, lêc Anutu hɨlung vô xam om xam xovô, lêc Anutu o hɨlung vô tɨbii baba lêm. ");
INSERT INTO ptp_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Ên xomxo ti obêc xovô xolac ge od Anutu obêc kɨtiv xovôên levac lec hɨxôn ên i xovô i luu vêl. Lêc xomxo ti obêc xovô xolac lêm ge od Anutu ob vô i nên xovôên nipwo tya ge vêl ên i. ");
INSERT INTO ptp_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Om a nêl kɨyang pɨlepacên vô he, ên he manôn yê lê, lêc xocbê he manôn o yê lêm, dɨ he ngô lê, lêc xocbê he nɨnya o ngô lêm, mêgem he o xovô kehe lêm. ");
INSERT INTO ptp_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Om he vông kɨyang wê plopete Aisaia nêl ilage vô nôn lec. Ilage Aisaia nêl bêga ên nêbê, ‘Xam obêc ngô kɨyang lê, lêc xam pɨyôp obêc xovô kehe lêm, dɨ xam mamnôn obêc yê lê, lêc xam ob xovô lêm. ");
INSERT INTO ptp_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Ên xam nɨlôm xêkɨzêc, dɨ nɨnyam vô kɨtu, dɨ mamnôn toc, ên xam nêb xam ob wê lêm, dɨ xam nêb xam ob ngô kɨyang ti lêm, dɨ xam nêb xam ob xovô kehe lêm, dɨ xam nêb xam ob pɨlepac nɨlôm i lôm vô a ên a vông xam vô nimvɨha lec lêm.’ ");
INSERT INTO ptp_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Asaia nêl bêge ilage, lêc xam xêmyaa i vô nivɨha, ên xam mamnôn yê a, dɨ xam nɨnyam ngô a kɨyang. ");
INSERT INTO ptp_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","A nêl vɨxôhɨlôg nôn vô xam bê plopete hɨxôn xomxo nivɨha wê dô ilage, he tɨbeac nêb he ob yê tɨyi xocbê xam wê gwêbaga, lêc he yêên ma, dɨ he nêb he ob ngô kɨyang tɨyi xocbê xam ngô gwêbaga, lêc he ngôên ma. ");
INSERT INTO ptp_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Xam ngô lê, ên a ob nêl kɨyang pɨlepacên lec xomxo wê lɨloo vê ge kehe kɨtong vô xam. ");
INSERT INTO ptp_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Vê wê tô vac môp ge, ge tɨyi xocbê xomxo wê ngô kɨyang lec Anutu ben lê, lêc xovôên ma ge, om Seten lam vô vêl ên he nɨlô. ");
INSERT INTO ptp_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Dɨ vê wê tô vac kɨbun nipwo tya wê dô lec ngɨdax kɨsii ge, ge tɨyi xocbê xomxo wê ngô xolac dɨ vông i vin lutibed mɨ xêyaa vô nivɨha, ");
INSERT INTO ptp_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","lêc he tɨyi xocbê ngec wê ngɨlôhô ma ge, om he dô nipwo tya, lêc he obêc tulec vɨyin me xomxo obêc vông myavɨnê vô he ên wê he vông i vin xolac ge od he sea vông vinên wê he vông ge lutibed. ");
INSERT INTO ptp_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Dɨ vê wê tô vac hɨvu kehe ge, ge tɨyi xocbê xomxo wê ngô xolac mɨ dô, lêc he nɨlô vô valval ên susu kɨbun ga yuu mone, om môp tige hɨvun xolac xôn, dɨ nôn ma. ");
INSERT INTO ptp_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Dɨ vê wê tô vac kɨbun nivɨha ge, ge tɨyi xocbê xomxo wê ngô xolac mɨ xovô kehe ge, om he vuac nôn nivɨha tɨyi xocbê 100 dɨ ya tɨyi 60 dɨ ya tɨyi 30.” ");
INSERT INTO ptp_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yesu nêl kɨyang pɨlepacên ngwe vô he bêga ên nêbê, “Anutu ben kehe tɨyi xocbê xomxo ti wê la lɨloo ngec vê vac i yuac ge. ");
INSERT INTO ptp_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Mêd vô bucên wê yêp ge xomxo nipaên ngwe val lɨloo vê nipaên la hɨxôn vac yuac dɨ lax mɨ la. ");
INSERT INTO ptp_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Mêdec buc ya lam la vêl dɨ ngec nivɨha tyip mɨ vô nôn, dɨ nita nipaên tyip hɨxôn. ");
INSERT INTO ptp_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Om xomxo levac tige nue yuac val kɨnêg vô i ên nêbê, ‘Xomxo levac, ông lɨloo vê nivɨha vac yuac wê ông vông ge, lêc bêna lêc nita nipaên tigee tyip hɨxônê?’ ");
INSERT INTO ptp_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","“Om xomxo levac tige nêl lax vô he ên nêbê, ‘Xomxo nipaên ti vông tige.’ Om nue yuac kɨnêg vô i ên nêbê, ‘Tɨyi wê xe ob la xuac nita nipaên tige vêl ge, me?’ ");
INSERT INTO ptp_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Lêc xomxo levac nêl vô he ên nêbê, ‘Ge o tɨyi lêm, ên xam obêc xuac nita nipaên ge od xam ob xuac ngec nivɨha hɨxôn. ");
INSERT INTO ptp_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Om xam vông yuu xôn i le dɨ i loc tyip lec buc wê il ob la kô nôn ge lê. Mêd obêc buc tige od a ob nêl vô he wê ob la kô nôn ge bê he i loc pul nita nipaên vêl mɨ tɨtup i loc bun ti dɨ nêx i loc vac ngwax, dɨ pul nôn nivɨha mɨ kô mɨ loc tung vac xumac wê nôn nivɨha dô vac ge.’” ");
INSERT INTO ptp_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Yesu nêl kɨyang pɨlepacên ti vô he bêga ên nêbê, “Anutu ben kehe tɨyi xocbê vɨxôô nôn wê xomxo ti kô mɨ la nêx vac yuac ge. ");
INSERT INTO ptp_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Vɨxôô nôn ge nipwopwo, lêc obêc tyip mɨ vô levac dɨ luu susu yaya vêl dɨ la tu xax, dɨ menac vɨyang vɨyang lam vông lɨwihi lec ngen mɨ dô lec dɨ ya nôn.” ");
INSERT INTO ptp_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Nang dêc Yesu nêl kɨyang pɨlepacên ngwe bêga ên nêbê, “Anutu ben kehe tɨyi xocbê yis nipwo tya wê vêx ti pɨlepac hɨxôn plaua, om vông plaua dung mɨ vô levac.” ");
INSERT INTO ptp_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Yesu nêl kɨyang tigee vɨhati vô xomxo kɨdu levac, lêc o nêl kɨyang kehe yêp seac vô he lêm. Nge, nêl kɨyang pɨlepacên pɨleva vô he. ");
INSERT INTO ptp_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Mêgem kɨyang wê plopete nêl ilage vô nôn lec. Plopete nêl bêga ên nêbê, “A ob nêl kɨyang pɨlepacên vô he. Dɨ kɨyang wê yêp xôpacên vô buc wê Anutu tung lag yuu kɨbun dɨ i val tyip gwêbaga hɨxôn ge, a ob nêl kɨyang tigee kehe kɨtong i yêp seac.” ");
INSERT INTO ptp_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Yesu sea xomxo kɨdu levac tige dɨ la dô vac xumac lôma. Mêd nue ngɨvihi val nêl vô i ên nêbê, “Kɨyang pɨlepacên lec nita nipaên wê tyip vac yuac ge, ông nêl kehe kɨtong vô xe ên xe xovô.” ");
INSERT INTO ptp_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Om Yesu nêl vô he ên nêbê, “Xomxo levac ti wê lɨloo vê nivɨha vac yuac ge, ge a, Xomxo Nu, ");
INSERT INTO ptp_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","dɨ yuac tyo ge tɨyi kɨbun, dɨ vê nivɨha ge tɨyi Anutu nue, dɨ nita nipaên ge tɨyi Seten nue, ");
INSERT INTO ptp_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","dɨ tɨbii nipaên ti wê lɨloo vê nipaên vac yuac ge tɨyi Seten, dɨ buc wê xomxo kô nôn lec ge tɨyi buc myahɨpu, dɨ xomxo yuac wê pul nôn ge tɨyi angela. ");
INSERT INTO ptp_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Dɨ wê he pul nita nipaên vêl mɨ si lec ngwax ge, tɨyi xocbê yuac wê he obêc vông vô buc myahɨpu ge. ");
INSERT INTO ptp_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Om vô buc myahɨpu tige a, Xomxo Nu, a ob vông a nuge angela he i loc vac vɨgwe vɨhati wê a vông ge ên he i loc kɨtuc xomxo nipaên wê dɨdii xomxo la vac môp nipaên ge hɨxôn he wê mi vông môp nipaên ge vɨhati, ");
INSERT INTO ptp_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","dɨ nêx he i loc vac ngwax levac. Vac ngwax tige he obêc byag dɨ nɨvu obêc kic lecma. ");
INSERT INTO ptp_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Mêd vô buc tige xomxo nivɨha obêc linac xêseac tɨyi xocbê hɨyôv ge vac Mag ben. Xam nɨnyam obêc yêp ge od xam ngô kɨyang tiga. ");
INSERT INTO ptp_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Anutu ben kehe tɨyi xocbê mone levac wê yêp vac kɨbun nɨlô, lêc xomxo ti la tulec lê, lêc vun i dô vac kɨbun nɨlô i tii vac. Xomxo tige xêyaa vô nivɨha, om la vông susu vɨhati wê i vông gee mɨ tɨbii kɨsuu i ma, dɨ kô mone mɨ la kɨsuu kɨbun tige ya. ");
INSERT INTO ptp_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Kɨyang pɨlepacên ngwe bêga nêbê Anutu ben kehe tɨyi xocbê xomxo ti wê vông yuac lec myagên komkom nivɨhavɨha nêb ob kɨsuu. ");
INSERT INTO ptp_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Yê komkom nivɨha ti wê mone levac ge, om la vông i susu mɨ tɨbii kɨsuu i ma, dɨ kô mone mɨ lax kɨsuu komkom tyo ya. ");
INSERT INTO ptp_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Kɨyang pɨlepacên ti bêga ên nêbê Anutu ben kehe tɨyi xocbê leac wê xomxo nêx la vac gwec ge dɨ pis toto la dô vac leac nɨlô, ");
INSERT INTO ptp_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","dɨ i pup lec, om he pul i lôm gwec nɨnya dɨ la dô kɨbun dɨ vɨnoo pis wê nivɨha ge dɨ tung la vac dêg, dɨ pis wê nipaên ge he nêx la. ");
INSERT INTO ptp_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Om tɨyi xocbê buc tɨmuên wê kɨbun ob tɨyôô vac ge, od angela ob vông yuac tibêge, ên he obêc val vô xomxo nipaên vêl vac xomxo nivɨha mahɨgun, ");
INSERT INTO ptp_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","dɨ nêx he la vac ngwax mahelac. Vac ngwax tige he obêc byag mabu dɨ nɨvu obêc kic lecma.” ");
INSERT INTO ptp_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Yesu kɨnêg vô nue ngɨvihi ên nêbê, “Xam xovô kɨyang pɨlepacên wê a nêl ge vɨhati kehe pyap, me?” Lêc he nêl ên nêbê, “Xe xovô.” ");
INSERT INTO ptp_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Om Yesu nêl vô he ên nêbê, “Om xomxo ti wê xovô xolac tɨkwê ge obêc ngô xolac paha wê a nêl lec Anutu ben kɨsiinê ge mɨ vông i vin ge od tɨyi xocbê xomxo tyo la vac xumac lôma dɨ la kô susu paha yuu tɨkwê vac susu wê i vông ge nɨlô dɨ vông vô xomxo ên nêb i ngɨdu he xôn.” ");
INSERT INTO ptp_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Yesu nêl kɨyang pɨlepacên tigee pyap dêc sea vɨgwe tige, ");
INSERT INTO ptp_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","dɨ lax mɨ la Nasalet wê ben kehe ge, dɨ la nêl xolac vô he Nasalet vac he xumac lɨlo, lêc he yetac mabu lê, lêcom he o vông i vin xolac wê i nêl ge lêm, om he nêl vôma ên nêbê, “Xomxo tiga kô xovôên nivɨha hɨxôn do levac vô letya? ");
INSERT INTO ptp_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Xomxo tiga kamundac nu, dɨ ta Malia, dɨ lie Jems yuu Josep dɨ Saimon hɨxôn Judas, ");
INSERT INTO ptp_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","dɨ lie vêx ge, he vɨhati dô hɨxôn il. Xomxo tiga xomxo kɨbun, lêc kô xovôên yuu xêkɨzêc ga gê na?” ");
INSERT INTO ptp_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Om he vô nɨmi vô i. Om Yesu nêl vô he ên nêbê, “Vac vɨgwe vɨyang vɨyang ge, tɨbii ob kô plopete lec, dom plopete tyo tae mae lie hɨxôn xomxo vac ici va ben kehe ob kô i lec lêm.” ");
INSERT INTO ptp_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Om Yesu o vông do tɨbeac vac ben kehe lêm, ên xomxo Nasalet o vông i vin i lêm. ");
INSERT INTO ptp_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Vô buc tige hɨzap levac Helot ngô kɨyang wê xomxo mi nêl lec Yesu ge, ");
INSERT INTO ptp_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","om nêl vô nue yuac ên nêbê, “Xomxo tige Jon Lipacên wê yib ge, lêc kɨdi lec mavɨha om vông do levac ya xêkɨzêc wê i vông ge.” ");
INSERT INTO ptp_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Helot nêl bêge, ên ilage Helot kô li Pilip vɨnê Helodias, om Jon nêl vô Helot vô buc tɨbeac ên nêbê, “Môp wê ông ii lim tuc vɨnê ge tɨyiên ma.” Mêgem Helodias kunac Jon dɨ nêl vô Helot, om Helot vông tɨbii la hôm Jon xôn dɨ tung i la vac xumac kalabuhu. ");
INSERT INTO ptp_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Dɨ Helot nêb ob hi Jon i yib, lêc xona ên xomxo tɨbeac, ên he yê Jon tɨyi xocbê plopete ti. ");
INSERT INTO ptp_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Mêdec Helot buc wê ta kô i lec ge, om Helot myêl vɨzid levac dɨ tyuc xomxo tɨbeac lam. He lam dô dɨ Helodias nu vêx lam yoo vac he mahɨgun mɨ he yê dɨ Helot xêyaa vô nivɨha. ");
INSERT INTO ptp_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Mêd Helot tɨtô vɨgê la kɨsii dɨ hɨlu kɨyang vô vêx tige ên nêbê, “A nêl hɨxôn nôn bêga bê ông obêc kɨtaa susu ti vô a ge od a obêc vông vô ông.” ");
INSERT INTO ptp_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Mêd Helodias nêl kɨyang xêkɨzêc vô nu vêx tige tax, om nu tyo nêl vô Helot ên nêbê, “A nêb ông kɨku Jon Lipacên kwa i tip dɨ tung bazub lec dipac ti mɨ vông vô a.” ");
INSERT INTO ptp_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Nêl bêge, om Helot nɨlô vô vɨyin, lêc xo i lax lec kɨyang wê hɨlu pyap dɨ xomxo tɨbeac dô mɨ ngô hɨxôn ge, om nêb ob vông i tɨyi kɨyang wê nêl vô vêx tige. ");
INSERT INTO ptp_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Om vông xomxo ti la vô Jon vac xumac kalabuhu mɨ la kɨku Jon kwa tip, ");
INSERT INTO ptp_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","dɨ tung bazub lec dipac ti dɨ kô mɨ lax vông vô Helodias nu vêx tige dɨ i kô mɨ la vông vô ta. ");
INSERT INTO ptp_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Mêd Jon nue ngɨvihi lam kô Jon nôn mɨ la yev, dɨ la nêl kɨtong vô Yesu. ");
INSERT INTO ptp_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Yesu ngô wê Jon yib ge, om sea vɨgwe tige dɨ la lec dipac ti mɨ la vɨgwe mahɨgun pɨleva wê xomxo ti do vacên ma ge. Lêc xomxo tɨbeac ngô wê Yesu la ge, om sea ben dɨ la vô Yesu vɨxa. ");
INSERT INTO ptp_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Yesu mɨla lop vêl ên dipac dɨ yê ma la xomxo tɨbeac wê val dô kɨdu kɨdu ge, om xo vɨgwe pɨsiv ên he, dɨ vông he wê yidac gee vô nivɨha lec. ");
INSERT INTO ptp_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Hɨyôv hoo la, mêd nue ngɨvihi lam nêl vô Yesu ên nêbê, “Vɨgwe ga, vɨgwe mahɨgun pɨleva ti, dɨ hɨyôv hoo la gwêba, om ông vông xomxo i loc vac vɨgwe nipwopwo vɨhati ên loc kɨsuu xen yaên wê he ob ya ge.” ");
INSERT INTO ptp_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Lêc Yesu nêl vô he ên nêbê, “He loc ên vatya? Xacxam va vông yaên mɨ he i ya.” ");
INSERT INTO ptp_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Om he nêl vô i ên nêbê, “Xe xom yaên o tɨbeac lêm. Nge, blet vɨgê vɨlu dɨ beac yuubed wê dô.” ");
INSERT INTO ptp_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Mêd Yesu nêl vô he ên nêbê, “Xam kô mɨ lam vô a.” ");
INSERT INTO ptp_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Yesu nêl om xomxo kɨdu levac tigee tô mɨ dô lec hɨsinac. Pyap dêc Yesu hôm blet vɨgê vɨlu ge dɨ beac yuubed ge dɨ yê ma la kɨsii dɨ kɨtaa lec blet hɨxôn beac, mêd hɨbu blet dɨ vông vô nue ngɨvihi, dɨ he kô mɨ la tɨtang vô xomxo tigee. ");
INSERT INTO ptp_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Mêd he vɨhati ya i den he pyap, mêdec nue ngɨvihi la kɨtuc myapɨpu wê dô gee mɨ la su vac sepac vɨgê yuu dɨ tô mɨ la yuu mɨ i pup lec. ");
INSERT INTO ptp_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Dɨ xomxo wê dô mɨ ya gee, he vux vaci tɨyi xocbê 5,000, lêc vêx yuu nipwopwo wê dô hɨxôn ge, he o kɨtong hɨxôn lêm. ");
INSERT INTO ptp_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Yesu nêl vô nue ngɨvihi nêb he i lec dipac mɨ le mug mɨ loc vɨlunê. Om he loc mɨ la, dɨ Yesu dô ên nêb ob vông xomxo kɨdu levac tige he i loc vêl lê. ");
INSERT INTO ptp_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","He la vêl, mêdêc Yesu loc mɨ la lec kɨtôn ti ên nêb ob la kɨtaa. Mêd vɨgwe buc dɨ Yesu vaci gên dô lec kɨtôn tige. ");
INSERT INTO ptp_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Lêc dipac wê nue ngɨvihi dô lec ge mɨla le vac mia luaên mahɨgun dɨ lea levac hôm dipac xôn dɨ vông i vô pɨlepac pɨlepac. ");
INSERT INTO ptp_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Vɨgwe kê pɨtoc vac vô kwabo lec wê ob vô xêseacseac ge, mêdec Yesu la lec mia kɨsii dɨ mɨla vô nue ngɨvihi. ");
INSERT INTO ptp_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","He yê ma lam Yesu wê lam lec mia kɨsii mɨ val ge, om he xona mabu dɨ nêl ên nêbê, “Ge vɨmwo nipaên ti.” Om he yetac dɨ iac. ");
INSERT INTO ptp_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Lêc lutibed Yesu nêl ên nêbê, “Xam xêmyaa vɨyin i ma, ên ga a, om xam xonaên i ma.” ");
INSERT INTO ptp_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Mêd Pita nêl vô i ên nêbê, “Apumtau, obêc ông ge od ông nêl ên a loc lec mia kɨsii mɨ loc vô ông.” ");
INSERT INTO ptp_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Om Yesu nêl ên nêbê, “Lamê.” Om Pita lop vêl ên dipac dɨ la lec mia kɨsii mɨ la vô Yesu. ");
INSERT INTO ptp_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Lêc yê lea levac om xona, dɨ hoo la vac mia, om iac dɨ nêl ên nêbê, “Apumtau, hôm a lec.” ");
INSERT INTO ptp_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Om lutibed Yesu tɨtô vɨgê dɨ hôm Pita xôn dɨ nêl vô i ên nêbê, “Vông vinên wê ông vông ge nipwo tya. Bêna lêc ông nɨlôm yuuê?” ");
INSERT INTO ptp_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Mêdêc yuu lec lax lec dipac, dɨ lea tip la. ");
INSERT INTO ptp_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Dɨ he wê dô lec dipac gee yev vɨxa kɨtu vô Yesu dɨ nêl vô i ên nêbê, “Vɨxôhɨlôg nôn, Anutu nu ông.” ");
INSERT INTO ptp_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Yesu he nue ngɨvihi la mia luaên vɨlu ganê mɨ la lop mɨ la vac vɨgwe Genesalet. ");
INSERT INTO ptp_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Xomxo tigee xovô ên nêb Yesu, om he vông dic la vac vɨgwe nipwopwo vɨhati ên nêb he i kô xomxo yidac vɨhati mɨ lam. ");
INSERT INTO ptp_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Dɨ he kɨtaa i ên nêb he ob hôm lec ngakwi wê i vông ge myahɨpu ên yidac i ma ên he, om he wê hôm vɨgê lec gee vɨhati vô nivɨha lec. ");
INSERT INTO ptp_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","He Palisi hɨxôn xomxo wê xovô Moses xolac gee lam gê Jelusalem dɨ val vô Yesu dɨ nêl ên nêbê, ");
INSERT INTO ptp_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Bêna lêc ông nume ngɨvihi sea môp wê buge vông ge dɨ ya hɨxôn vɨgê ningeacê? Ên he obêc ya ge od he o lipac vɨgê lêm, lêc xe mô ge, xe mi tɨmu vô buge vông môp dɨ lipac vɨgêm.” ");
INSERT INTO ptp_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Lêc Yesu nêl lax vô he ên nêbê, “Bêna lêc xam tɨmu vô bume vông môp dɨ pwoo Anutu kɨyang vacê? ");
INSERT INTO ptp_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Ên Anutu kɨyang ngwe nêl bêga ên nêbê, ‘Xam hôm tame mame lê lec dɨ ngô he kɨyang.’ Dɨ kɨyang ngwe nêl bêga ên nêbê, ‘Xomxo ti obêc nêl kɨyang nipaên lec ta yuu ma ge od xomxo i hi i yib.’ ");
INSERT INTO ptp_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Anutu kɨyang nêl bêge, lêc xam mi nêl ên xam nêbê xomxo ti obêc nêl vô ta yuu ma ên nêbê, ‘Susu wê a ob ngɨdu muu xôn ya ge dô, lêcom a ob vông daa vô Anutu, om muu nêm ob ma.’ Xomxo obêc nêl bêge ge od xam nêbê ge tɨyi dɨ xam o hôm tame mame lê lec lêm. ");
INSERT INTO ptp_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Lêc môp tige tɨyi xocbê xam la vô bume vông môp dɨ kɨtya Anutu kɨyang vêl. ");
INSERT INTO ptp_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Xam xomxo kɨtyooên wê xam vɨyum nipaên vac nivɨha ge. Kɨyang wê plopete Aisaia kɨvuu ilage nêl nôn lec xam bêga nêbê, ");
INSERT INTO ptp_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Xomxo tigee pɨmil a ya mya pɨleva, lêc he nɨlô le teva ên a. ");
INSERT INTO ptp_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","He mi nêl kɨyang wê xomxo vaci xovô ge, lêc he nêl ên nêbê he nêl Anutu kɨyang, om he yev vɨxa kɨtu vô a pɨsiv.’” ");
INSERT INTO ptp_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Yesu keac xomxo kɨdu levac lam vô i dɨ nêl vô he ên nêbê, “Xam ngô kɨyang wê a ob nêl ge dɨ xovô nivɨha. ");
INSERT INTO ptp_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Susu wê ob la vac xomxo mya ge o tɨyi wê ob vông xomxo vô nipaên ge lêm. Nge, susu wê lam vac xomxo mya ge wê ob vông he vô nipaên.” ");
INSERT INTO ptp_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Yesu nue ngɨvihi val nêl vô i ên nêbê, “Ông ngô wê he Palisi xêyaa vô myavɨnê lec kɨyang wê ông nêl ge, me?” ");
INSERT INTO ptp_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Om Yesu nêl vô he ên nêbê, “Susu vɨhati wê Mag lag puunê yevên ma ge i obêc pul hɨxôn ngɨlôhô. ");
INSERT INTO ptp_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Om xam vông he Palisi i dô, ên he nêb he ob dɨdii xomxo la vac môp, lêc he manôn toc. Dɨ xomxo ma tocên ngwe obêc dɨdii xomxo ma tocên ngwe ge od yuu xôn ob la tô vac madia.” ");
INSERT INTO ptp_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Pita nêl vô i ên nêbê, “Ông nêl kɨyang pɨlepacên tige kehe kɨtong vô xe ên xe ngô.” ");
INSERT INTO ptp_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Om Yesu nêl vô he ên nêbê, “Xam êno gên lungên kɨyang tige, me? ");
INSERT INTO ptp_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Susu vɨhati wê xomxo ob tung vac mya dɨ ya ge ob la dô vac xêyaa, dɨ lop mɨ la vêl. Lêc mêd xam lungên tige, me? ");
INSERT INTO ptp_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Lêc susu vɨhati wê yêp vac xomxo nɨlô dɨ lôm tyip vac mya ge wê vông xomxo vô nipaên. ");
INSERT INTO ptp_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Ên susu wê lam vac xomxo nɨlô ge bêga nêbê, xovôên nipaên, hi xomxo yib, vông môp iimaên vô nipaên, môp yôdac vêx yuu vux, vun xomxo susu, nêl kɨyang kɨtyooên, dɨ nêl kɨyang nipaên lec xomxo. ");
INSERT INTO ptp_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Môp nipaên tigee wê vông xomxo vô nipaên. Lêc xomxo ti obêc sea bue vông môp dɨ ya ya vɨgê ningeac ge od ob vông i vô nipaên lêm.” ");
INSERT INTO ptp_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Yesu sea vɨgwe tige mɨ la vɨgwe levac wê vɨgwe Taia yuu Saidon yêp vac ge. ");
INSERT INTO ptp_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Dɨ Kenan vêx ti wê dô vac vɨgwe tige lam vô Yesu dɨ keac levac ên nêbê, “O Apumtau, Devit nu ông, ông xo vɨgwe pɨsiv ên a, ên vɨmwo nipaên ti dô vac a nug vêx nɨlô dɨ vông i dô vac vɨyin mabu.” ");
INSERT INTO ptp_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Yesu ngô lêc o nêl kɨyang ti lax vô i lêm. Mêd nue ngɨvihi val kɨtaa i ên nêbê, “Vêx tyo vô byag byag dɨ mi tɨmu vô il vɨxad ga, om ông nêl ên i lôc.” ");
INSERT INTO ptp_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Om Yesu nêl vô vêx tyo ên nêbê, “Anutu vông a lam vô Islele vaci wê tɨyi xocbê bwoc sipsip wê lung sea ge.” ");
INSERT INTO ptp_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Lêc vêx tige lam yev vɨxa kɨtu vô i dɨ nêl ên nêbê, “Apumtau, ngɨdu a xôn.” ");
INSERT INTO ptp_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Lêc Yesu nêl vô i ên nêbê, “Ga o tɨyi wê il ob vô nipwo xen yaên vêl ên he dɨ nêx i loc vô noo ge lêm.” ");
INSERT INTO ptp_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Om vêx tyo nêl ên nêbê, “Apumtau, ông nêl kɨyang nôn. Lêcom noo mi ya myapɨpu wê xomxo vông i tô mɨ la vac pêt ngɨbi ge.” ");
INSERT INTO ptp_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Om Yesu nêl vô i ên nêbê, “O vêx, ông vông i vin xêkɨzêc ta, om kɨyang wê ông kɨtaa vô a ge ob vô nôn lec vô ông.” Yesu nêl bêge, dɨ vô hɨyôv manôn tibed tige vêx tyo nu vô nivɨha lec. ");
INSERT INTO ptp_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Mêdec Yesu sea vɨgwe tige dɨ la vô mia luaên Galili nɨnya, dɨ la lec kɨtôn dɨ la dô kɨbun. ");
INSERT INTO ptp_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Mêdec xomxo kɨdu kɨdu val vô i, dɨ he kô lie vɨxa nipaên, dɨ manôn tocên, dɨ vɨxa gecên, dɨ kwa maên hɨxôn yidac toto ge mɨ lam lii he vô Yesu vɨxa, om Yesu vông he vɨhati vô nivɨha lec. ");
INSERT INTO ptp_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Mêgem xomxo kɨdu levac tige yê dɨ yetac mabu ên wê xomxo kwa maên keac dɨ xomxo vɨxa gecên ge vɨxa vô bôbac lec, dɨ he wê vɨxa nipaên ge vô nivɨha lec dɨ la, dɨ wê manôn tocên ge manôn seac dɨ he yê vɨgwe. Om he hi vɨxa pec ên Islel vông Anutu. ");
INSERT INTO ptp_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Yesu keac ên nêb nue ngɨvihi lam vô i dɨ nêl vô he ên nêbê, “A xo vɨgwe pɨsiv ên xomxo kɨdu levac tigae ên he lam dô hɨxôn a tɨyi buc yon dɨ he xen yaên ma. Dɨ a xêgyaa o vin lec wê a ob vông he loc vip ge lêm, ên vip ob vông he vɨgê yuu vɨxa ma gê môp.” ");
INSERT INTO ptp_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Om nue ngɨvihi nêl vô i ên nêbê, “Vɨgwe ga vɨgwe mahɨgun pɨleva wê xomxo ti dô vacên ma ge, om il obêc kô yaên tɨbeac gê na ên vet xomxo tigae ya?” ");
INSERT INTO ptp_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Lêc Yesu luu he vya ên nêbê, “Xam blet vaba dô?” Dɨ he nêl ên nêbê, “Xe blet vɨgê vɨlu dɨ sec yuu hɨxôn beac nipwo yuutya dô.” ");
INSERT INTO ptp_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Om Yesu nêl vô xomxo kɨdu levac tigee ên nêbê, “Xam tô mɨ dô lec kɨbun.” ");
INSERT INTO ptp_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Mêd hôm blet vɨgê vɨlu dɨ sec yuu hɨxôn beac gee dɨ kɨtaa lec, mêd hɨbu dɨ vông vô nue ngɨvihi, dɨ nue ngɨvihi tɨtang vô xomxo tigee vɨhati. ");
INSERT INTO ptp_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Om he vɨhati ya i den he, dɨ myapɨpu wê dô ge he su vac sepac vɨgê vɨlu dɨ sec yuu mɨ i pup lec. ");
INSERT INTO ptp_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Xomxo wê dô mɨ ya gee, he vux vaci tɨyi xocbê 4,000, lêc vêx hɨxôn nue gee he o kɨtong hɨxôn lêm. ");
INSERT INTO ptp_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Pyap dêc Yesu vông xomxo kɨdu kɨdu lax vac ben ben, dɨ i va la lec dipac mɨ la vɨgwe Magadan. ");
INSERT INTO ptp_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","He Palisi yuu Sadyusi val vô Yesu ên nêb ob yaxên i, om nêl vô Yesu ên nêb i vông do lag puunê ti ên he ob yê. ");
INSERT INTO ptp_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Lêc Yesu nêl vô he ên nêbê, “Hɨyôv hoo la dɨ vɨgwe buc dɨ guva tum lec lag ge wê xam nêbê hɨyôv ob linac. ");
INSERT INTO ptp_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Vɨgwe obêc vɨdii lêc mavɨyob ge od xam nêbê lun ob val. Xam wê susu lec lag dɨ xovô nivɨha, lêc xam o tɨyi wê xam ob wê do levac wê nêl buc gwêbaga kɨtong mɨ xovô kehe ge lêm. ");
INSERT INTO ptp_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Xam gwêbaga, xam ge xomxo nipaên wê xam o vông i vin lêm ge, om xam nêb xam ob wê do levac ti. Lêc a ob vông do levac ti mɨ xam wê lêm. Ên do levac tibed wê a ob hɨlung vô xam ge wê Jona vông ilage.” Yesu nêl bêge, pyap dêc sea he dɨ la. ");
INSERT INTO ptp_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Yesu he nue ngɨvihi la mia luaên vɨlu ganê, lêc he o xovô mɨ kô blet ya hɨxôn lêm. ");
INSERT INTO ptp_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Mêd Yesu nêl vô he ên nêbê, “Xam xona nêm ên yis wê he Palisi yuu Sadyusi vông ge.” ");
INSERT INTO ptp_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Om nue ngɨvihi nêl vôma ên nêbê, “Yesu nêl kɨyang tibêge ên wê il o kô blet ti lêm ge.” ");
INSERT INTO ptp_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Lêc Yesu xovô kɨyang wê he nêl vôma ge, om nêl vô he ên nêbê, “Xam nêm vông vinên ge nipwo tya. Bêna lêc xam nêl vôma ên xam nêbê xam xom blet ma? ");
INSERT INTO ptp_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Xam gên o xovô lêm, me? Xam mêd lungên blet vɨgê vɨlu wê xomxo 5,000 ya ge, me? Xam su myapɨpu vac sepac vaba mɨ i pupê? ");
INSERT INTO ptp_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Dɨ xam mêd lungên blet vɨgê vɨlu dɨ sec yuu wê xomxo 4,000 ya ge, me? Xam su myapɨpu vac sepac vaba mɨ i pupê? ");
INSERT INTO ptp_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Bêna lêc xam lungênê? A o nêl kɨyang lec blet lêm. Nge, a nêb xam xona nêm ên blet wê he Palisi yuu Sadyusi vông ge.” ");
INSERT INTO ptp_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Yesu nêl bêge, om he xovô ên nêbê Yesu o nêb he i viac he nivɨha ên blet wê xomxo ob ya ge lêm. Nge, nêb he i viac he nivɨha ên kɨyang wê he Palisi yuu Sadyusi vông ge. ");
INSERT INTO ptp_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Yesu la vɨgwe ti lê nêbê Sisalia Pilipai dɨ kɨnêg vô nue ngɨvihi en nêbê, “Tɨbii nêl Xomxo Nu a nêb letya?” ");
INSERT INTO ptp_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Om he nêl vô i ên nêbê, “Xomxo ya nêl ên nêb ông ge Jon Lipacên, dɨ ya nêl ên nêb ông plopete Ilaija, dɨ ya nêl ên nêb ông ge plopete Jelemaia me plopete ba ti.” ");
INSERT INTO ptp_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Mêd Yesu kɨnêg vô he ên nêbê, “Dɨ xacxam va nêl a ên xam nêb a letya?” ");
INSERT INTO ptp_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Om Saimon Pita nêl lax vô i ên nêbê, “Ông Kɨlisi, Anutu mavɨha nu ông.” ");
INSERT INTO ptp_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Om Yesu nêl vô Pita ên nêbê, “Jona nu Saimon, ông xêmyaa i vô nivɨha, ên xomxo kɨbun ga ti o nêl kɨyang tige kehe kɨtong vô ông lêm. Nge, a Mag wê dô lag puunê ge wê nêl kɨtong vô ông. ");
INSERT INTO ptp_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Om a nêl vô ông bê ông lêm Pita, kehe nêbê ngɨdax. Om a ob lax xomxo vông vinên i loc lec ngɨdax kɨsii. Dɨ xêkɨzêc wê Seten vông ge o tɨyi wê ob pwoo he pec ge lêm. ");
INSERT INTO ptp_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","A ob vông ki Anutu ben lag puunê vô ông. Dɨ kɨyang yuu môp wê ông obêc kɨtya vêl gê kɨbun ga ge od Anutu êno ob kɨtya vêl gê kɨsii ganê. Lêc kɨyang yuu môp wê ông obêc hôm xôn mɨ i yêp gê kɨbun ga ge od Anutu êno ob hôm xôn mɨ i yêp gê kɨsii ganê.” ");
INSERT INTO ptp_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Om Yesu le vac nue ngɨvihi xôn nêb he i o nêl vô xomxo bê i Kɨlisi lêm. ");
INSERT INTO ptp_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Vô buc tige Yesu nêl i kɨyang taxlee vô nue ngɨvihi ên nêbê ob la Jelusalem, dɨ Yuda levac hɨxôn xomxo levac wê mi si daa gee dɨ he wê xovô Moses xolac gee he ob vông myavɨnê levac vô i dɨ hi i yib, dɨ buc yon ob lam la vêl dɨ i ob kɨdi lec mavɨha tii vac nang. ");
INSERT INTO ptp_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Om Pita kô Yesu mɨ yuu la dô vɨyonên, dɨ nêl xêkɨzêc vô Yesu ên nêbê, “Apumtau, Anutu i le vac kɨyang tige xôn. Ên vɨyin tibêge i o lêc tulec ông lêm.” ");
INSERT INTO ptp_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Lêc Yesu pɨlepac i dɨ vô nɨmi vô Pita, dɨ nêl vô Pita ên nêbê, “Seten, ông loc vêl! Ên ông le vac a xôn. Ông o nêl i tɨyi Anutu pɨyôp lêm. Nge, ông nêl i tɨyi pɨyôp wê xomxo kɨbun ga vông ge.” ");
INSERT INTO ptp_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Mêdêc Yesu nêl vô nue ngɨvihi ên nêbê, “Xomxo ti obêc nêb tɨmu vô a vɨxag ge od i vông i vô nipwo lec dɨ kɨlê xax pola wê i vông ge dɨ tɨmu vô a vɨxag. ");
INSERT INTO ptp_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Ên xomxo ti obêc viac ninɨvi ên nêb i dô mavɨha ge od obêc yib. Lêc xomxo ti obêc sea ninɨvi lec a lêg ge od ob dô mavɨha luta. ");
INSERT INTO ptp_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Ên xomxo ti obêc vɨlu vô susu kɨbun ga vɨhati tu i xe, lêc sea môp wê ob dô mavɨha ya ge od ob vô nivɨha vô i bêna? Xomxo ob vông vatya êdêc i kɨnu i dô mavɨha ya? ");
INSERT INTO ptp_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Ên a, Xomxo Nu, a obêc lop mɨ lôc hɨxôn a nuge angela dɨ lam hɨxôn xêseac wê Mag vông ge, dɨ a ob vông myavɨwen vô xomxo toto i tɨyi nipaên yuu nivɨha wê he vông ge. ");
INSERT INTO ptp_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Lêc a nêl nôn vô xam bê xomxo wê le ga, he ya yibên obêc ma dɨ obêc yê wê Xomxo Nu ob lam tu king ge lê, dêc yib tɨmuên.” ");
INSERT INTO ptp_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Buc vɨgê vɨlu dɨ sec ti lam la vêl, mêd Yesu kô Pita dɨ Jems yuu li Jon dɨ he la lec kɨtôn dia ti, mɨ heche va la dô. ");
INSERT INTO ptp_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Om yon yê wê Yesu ninɨvi pɨkwê mɨ vông bangwe, dɨ manôn linac xocbê hɨyôv, dɨ ngakwi xêseac dɨ vô hɨxelac hɨxelac. ");
INSERT INTO ptp_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Mêdec yon yê wê Moses yuu Ilaija val keac hɨxôn Yesu ge. ");
INSERT INTO ptp_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Om Pita nêl vô Yesu ên nêbê, “Apumtau, ga nivɨha wê il dô ga, om ông obêc tyuc lec ge od a ob lox xumac yon, ti vô ông, dɨ ngwe vô Moses dɨ ti vô Ilaija.” ");
INSERT INTO ptp_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Pita gên nêl kɨyang tibêge, mêdêc vɨyobtoc wê xêseac ge ti lam hɨvun he xôn, dɨ vya ti lam vac vɨyobtoc tige nɨlô dɨ nêl ên nêbê, “Ge a nug wê a xêgyaa vin lec i dɨ a xê i nivɨha ge om xam ngô kɨyang wê i vông ge.” ");
INSERT INTO ptp_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Nue ngɨvihi yon ge ngô vya tige mêdêc yon yev vɨxa kɨtu dɨ kɨpôm manôn lec kɨbun, dɨ yon xona mabu. ");
INSERT INTO ptp_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Lêc Yesu lam vyax vɨgê lec yon dɨ nêl ên nêbê, “Kɨdi lec, dɨ xonaên i ma.” ");
INSERT INTO ptp_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Om yon vêl manôn lec kɨsii, dɨ yê Yesu vaci le dɨ yuu xôa ma. ");
INSERT INTO ptp_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","He gên lop lec kɨtôn tige dɨ Yesu nêl xêkɨzêc vô yon ên nêbê, “Mon o lêc nêl kɨyang wê mon wê dɨ ngô ge kɨtong vô xomxo ti lêm. Nge, i lêc loc tyip lec wê a, Xomxo Nu, a obêc kɨdi vac yibên ge lê.” ");
INSERT INTO ptp_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Mêd yon kɨnêg vô i ên nêbê, “Bêna lêc xomxo wê xovô Moses xolac gee nêl ên nêbê Ilaija obêc val tax dɨ Kɨlisi wê Anutu vɨnoo i ge obêc val tɨmuên?” ");
INSERT INTO ptp_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Mêdêc Yesu nêl ên nêbê, “Vɨxôhɨlôg, Ilaija ob vena ên tɨtô môp vɨhati i yêp nivɨha i tii vac. ");
INSERT INTO ptp_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Lêc a nêl vô mon bê Ilaija lam pyap, lêc xomxo lungên i, dɨ he vông nipaên vô i tɨyi xovôên wê he vông ge. Om a, Xomxo Nu, a êno obêc tulec myavɨnê tɨyi bêge.” ");
INSERT INTO ptp_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Yesu nêl bêge, om nue ngɨvihi xovô ên nêbê kɨyang wê Yesu nêl lec Ilaija ge, nêl lec Jon Lipacên. ");
INSERT INTO ptp_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Mêdêc he lop kɨtôn tige mɨ la vô xomxo kɨdu levac ti, lêc xomxo ti val yev vɨxa kɨtu vô Yesu dɨ nêl vô i ên nêbê, ");
INSERT INTO ptp_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Xomxo levac, ông xo vɨgwe pɨsiv ên a nug vux, ên vông yidac mavên mɨ dô vac vɨyin mabu, ên mi vɨxog mɨ la vac ngwax dɨ la vac mia tɨyi buc tɨbeac. ");
INSERT INTO ptp_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Om a kô mɨ lam vô nume ngɨvihi ên a nêb he i vông i vô nivɨha lec lê, lêc he tɨyiên ma.” ");
INSERT INTO ptp_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Om Yesu nêl ên nêbê, “Xam gwêbaga, xam ge xomxo nipaên wê xam o vông i vin lêm ge. Om a ob dô hɨxôn xam dɨ i mɨloc vô buc tina lê? Dɨ a ob kɨlê vɨyin wê xam vông ge dɨ i mɨloc tina lê? Loc kô nipwo tige mɨ lam vô a.” ");
INSERT INTO ptp_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Om ma la kô nu tyo mɨ lam vô Yesu, dɨ Yesu pɨping vɨmwo nipaên la vêl ên nu dɨ i vô nivɨha lec lutibed. ");
INSERT INTO ptp_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Om tɨmuên ge, Yesu nue ngɨvihi vaci la kɨnêg vô i ên nêbê, “Bêna lêc xe mô o tɨyi wê xe ob tii vɨmwo nipaên tige vêl lêmê?” ");
INSERT INTO ptp_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Om Yesu nêl vô he ên nêbê, “Xam tɨyiên ma ên vông vinên wê xam vông ge tɨyiên ma. A nêl vɨxôhɨlôg nôn bê xam nêm vông vinên obêc nipwo tya tɨyi xocbê vɨxôô nôn ge od xam ob nêl vô kɨtôn tiga bê, ‘Ông pul mɨ loc le ganê,’ dɨ kɨtôn tiga obêc pul i mɨ la. Xam obêc vông i vin ge od xam obêc tɨyi wê xam ob vông yuac vɨhati. ");
INSERT INTO ptp_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Môp kɨtaaên yuu ngɨbua yaên ge tɨyi wê ob tii vɨmwo nipaên tibêge vêl ên xomxo, dɨ môp ngwe o tɨyi lêm.” ");
INSERT INTO ptp_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Yesu he nue ngɨvihi mɨla vɨgwe Galili, dɨ Yesu nêl vô he ên nêbê, “Xomxo ob vông a, Xomxo Nu, la vac tɨbii vɨgê, ");
INSERT INTO ptp_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","dɨ he ob hi a xib, lêc buc yon obêc lam la vêl ge od a obêc kɨdi lec magvɨha tii vac nang.” Yesu nêl bêge om nue ngɨvihi nɨlô vô vɨyin mabu. ");
INSERT INTO ptp_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","He val vɨgwe Kapaneam, mêd xomxo wê mi kô mone takis xumac ngɨbua ge lam vô Pita dɨ kɨnêg vô i ên nêbê, “Xam nêm xolac kehe mi vông mone takis xumac ngɨbua ge hɨxôn, me?” ");
INSERT INTO ptp_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Om Pita lee yuu ên nêbê, “Xe nêm xolac kehe mi vông.” Pyap dêc Pita lax mɨ la ben mɨ la vac xumac lôma, dɨ lutibed Yesu nêl vô i ên nêbê, “Saimon, ông nêbê va? Xomxo levac kɨbun ga, he mi kô mone takis vô letyae? He mi kô vô he nue, me he mi kô vô tɨbii ba?” ");
INSERT INTO ptp_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Mêd Pita nêl ên nêbê, “He mi kô mone takis vô tɨbii ba.” Om Yesu nêl ên nêbê, “Om heche va nue ge ob dô nên dɨ ob tung mone takis lêm. ");
INSERT INTO ptp_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Dɨ a ga, Anutu nu a, om yuac ti o yêp vô a wê a ob vông mone takis ên Anutu xumac ngɨbua ge lêm. Lêc ge o nivɨha wê il ob vông he wê mi kô mone takis xumac ngɨbua ge kunac il ge lêm. Om ông loc gwec dɨ loc pul pis ya huk. Dɨ pis taxlee wê ông ob pul ge, ông sux mya dɨ ông ob tulec mone wê dô vac mya ge, dɨ kô mɨ loc vông vô he wê mi kô mone xumac ngɨbua ge dɨ loc tung u nêd.” ");
INSERT INTO ptp_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Vô buc tige Yesu nue ngɨvihi val nêl vô i ên nêbê, “Letya ob tu levac vac Anutu ben kɨsiinê luu he ba vêlê?” ");
INSERT INTO ptp_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Om Yesu keac nipwo ti lam vô he dɨ lax i la le vac he mahɨgun, ");
INSERT INTO ptp_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","dɨ nêl vô nue ngɨvihi ên nêbê, “A ob nêl vɨxôhɨlôg nôn vô xam bê xam obêc pɨlepac xam mɨ vô nipwo lec tɨyi xocbê xomxo nipwo tiga lêm ge od xam ob la dô vac Anutu ben lag puunê lêm. ");
INSERT INTO ptp_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Lêc xomxo ti obêc pɨlepac i mɨ vô nipwo lec tɨyi xocbê nipwo tiga ge od ge wê ob tu levac vac Anutu ben lag puunê luu he ba vêl. ");
INSERT INTO ptp_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","“Xomxo ti obêc kô nipwo tibêga lec ên wê vông i vin a lêg ge od tɨyi xocbê kô a lec êno. ");
INSERT INTO ptp_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Lêc xomxo ti obêc dɨdii nipwo tigae wê vông i vin a ge ti mɨ la vac nipaên ge od ge tɨyi wê tɨbii ob nux ngɨdax levac lec i kwa dɨ nêx i la vac gwec madia wê vô mapɨtoc ta ge. ");
INSERT INTO ptp_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","“Xomxo kɨbun ga wê dɨdii xomxo mɨ la vac nipaên ge, myavɨwen nipaên ob tulec he vɨhati. Vɨxôhɨlôg, nipaên vɨyang vɨyang ge ob yaxên il, lêc xomxo ngwe obêc dɨdii xomxo ngwe mɨ la vac nipaên ge od i xona nên, ên obêc tulec myavɨwen nipaên. ");
INSERT INTO ptp_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Dɨ ông vɨgêm vɨlu me vɨxam vɨlu obêc dɨdii ông mɨ la vac nipaên ge od ông kɨtov mɨ nêx i loc vêl, dɨ ông dô ya vɨgêm vɨlubed me vɨxam vɨlubed, êdêc loc dô mamvɨha vac Anutu ben. Ên ông vɨgêm yuu xôn me vɨxam yuu xôn obêc dô, lêc dɨdii ông mɨ la vac nipaên ge od Anutu obêc nêx ông la vac ngwax wê dɨtum luta dɨ yibên ma ge. ");
INSERT INTO ptp_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Dɨ mamnôn vɨlu obêc dɨdii ông mɨ la vac nipaên ge od ông pɨsupac vêl mɨ nêx i loc, dɨ ông dô ya mamnôn vɨlubed, êdêc loc dô mamvɨha vac Anutu ben. Ên mamnôn yuu xôn obêc dô, lêc dɨdii ông mɨ la vac nipaên ge od Anutu obêc nêx ông la vac ngwax vac vɨgwe nipaên. ");
INSERT INTO ptp_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Xam viac xam dɨ le i lêc yê nume nipwo tigae i tɨyi xocbê susu pɨleva ge lêm, ên a nêl vô xam bê vac vɨgwe lag puunê he nên angela mi le vô Mag Anutu lag puunê manôn tɨyi buc vɨhati. ");
INSERT INTO ptp_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","A, Xomxo Nu, a lam ên a nêb a ob myag he wê xôa ma ge mɨ kô mɨ lôm. ");
INSERT INTO ptp_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Xam xo ên xam nêbê va? Xomxo ti obêc viac bwoc sipsip 100 lêc ti xôa obêc ma ge od xomxo tige ob vô va? Obêc sea sipsip 99 gee he ob le lec kɨtôn, dɨ ob la myag ti wê xôa ma ge. ");
INSERT INTO ptp_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Dɨ obêc la yêvô ge od a nêl nôn bê xomxo tyo ob pɨmil sipsip tige luu 99 wê le ge vêl. ");
INSERT INTO ptp_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Mêgem Mag Anutu wê dô lag puunê ge nêb nue nipwo tigae ti xôa ob ma lêm. ");
INSERT INTO ptp_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Ông lim ti obêc vông nipaên ti vô ông ge od ôcông va loc vô i dɨ muu dô dɨ ông nêl i nên nipaên kɨtong vô i. Dɨ obêc ngô ông kɨyang ge od tɨyi xocbê ông kô i mɨ lôm vac xam mahɨgun. ");
INSERT INTO ptp_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Lêc ngôên ông kɨyang obêc ma ge od ông kô xomxo yuu me yon dɨ xam loc vô lim tige ên he i ngɨduma xôn dɨ yaxên kɨyang wê muu ob nêl ge. ");
INSERT INTO ptp_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Lêc lim tige ngôên xam obêc ma ge od xam loc nêl i nên nipaên kɨtong vô konglegesen. Lêc ngôên konglegesen kɨyang obêc ma ge od xam wê i tɨyi xocbê tɨbii madɨluhu me tɨbii nipaên ge. ");
INSERT INTO ptp_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“A nêl vɨxôhɨlôg nôn vô xam bê kɨyang yuu môp wê xam obêc kɨtya vêl gê kɨbun ga ge od Anutu êno ob kɨtya vêl gê kɨsii ganê. Dɨ kɨyang yuu môp wê xam obêc hôm xôn mɨ i yêp gê kɨbun ga ge od Anutu êno ob hôm xôn mɨ i yêp gê kɨsii ganê. ");
INSERT INTO ptp_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“A ob nêl ti hɨxôn vô xam bê xomxo yuu gê kɨbun ga, yuu nɨlô obêc yêp tibed ên susu ti wê yuu nêb yuu ob kɨtaa vô Anutu ge od a Mag wê dô lag puunê ge ob vông i vô nôn lec vô yuu. ");
INSERT INTO ptp_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Ên xomxo yuu me yon obêc kɨtucma lec a lêg ge od a obêc dô vac he mahɨgun.” ");
INSERT INTO ptp_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Mêdêc Pita val vô Yesu dɨ kɨnêg vô i ên nêbê, “Apumtau, lige ti obêc vông nipaên vô a ge od a ob kɨtya i nên nipaên vêl i tɨyi buc vaba? Buc vɨgê vɨlu dɨ sec yuu obêc tɨyi, me?” ");
INSERT INTO ptp_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Lêc Yesu nêl vô i ên nêbê, “Maê. A nêl vô ông bê buc vɨgê vɨlu dɨ sec yuu ge o tɨyi lêm. Nge, ông kɨtya i nên nipaên vêl i tɨyi buc vɨhati. ");
INSERT INTO ptp_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“Om Anutu ben kehe tɨyi xocbê xomxo levac ti wê nêb ob kô mone vac i mone wê vông vô nue yuac ge. ");
INSERT INTO ptp_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Mêgem taxlee ge he kô nu yuac ti mɨ la le vô xomxo levac tige manôn. Nu yuac tige kô mone 10 milion vô xomxo levac tyo ilage, ");
INSERT INTO ptp_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","lêc o tɨyi wê ob vông mone vac ge lêm. Om xomxo levac tige nêl ên nêbê he i vông nu yuac tyo hɨxôn vɨnê nue dɨ he susu vɨhati ên tɨbii i kɨsuu dɨ he i vông mone tige vɨhati vac. ");
INSERT INTO ptp_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Lêc nu yuac tige yev vɨxa kɨtu vô xomxo levac tyo dɨ kɨtaa i ên nêbê, ‘Xomxo levac, ông hôm a nêg kɨyang xôn mɨ i yêp lê dɨ vông buc ya vô a ên a obêc vông mone vɨhati vac ông mone.’ ");
INSERT INTO ptp_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Om xomxo levac tige xo vɨgwe pɨsiv ên nu yuac tyo om pɨwelac i vêl dɨ hi kɨyang tyo yib dɨ vông i la. ");
INSERT INTO ptp_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Nang dêc nu yuac tyo lop mɨ la dɨ la tulec lie ti wê vông yuac hɨxôn i ge. Ilage li tige kô mone 100 vô i. Om nu yuac tyo hôm i xôn lec kwa dɨ nêl vô i ên nêbê, ‘Ông vông mone vac a mone vɨhati.’ ");
INSERT INTO ptp_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Om li tige yev vɨxa kɨtu vô i dɨ kɨtaa i ên nêbê, ‘Ông hôm a nêg kɨyang xôn mɨ i yêp lê dɨ vông buc ya vô a ên a obêc vông mone vɨhati vac ông mone.’ ");
INSERT INTO ptp_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Lêc xomxo tyo ngôên ma, dɨ tung li tige la dô vac kalabuhu ên nêb i loc dô mɨ i loc tyip lec buc wê ob vông mone vɨhati vac i xe ge. ");
INSERT INTO ptp_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","“Mêd xomxo ya wê vông yuac hɨxôn i ge yê, om he nɨlô vô nipaên, dɨ he la vô xomxo levac tige dɨ nêl kɨyang vɨhati kɨtong vô i. ");
INSERT INTO ptp_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Mêd xomxo levac tige tyuc nu yuac tyo lôm vô i, dɨ nêl vô i ên nêbê, ‘Ông xomxo yuac nipaên. Ông kɨtaa a, om a kɨtya ông nêm myavɨwen vɨhati vêl, ");
INSERT INTO ptp_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","dɨ a xo vɨgwe pɨsiv ên ông, lêc bêna lêc ông o xo vɨgwe pɨsiv ên lim tige lêmê?’ ");
INSERT INTO ptp_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Mêd xomxo levac xêyaa vô myavɨnê om vông nu yuac tyo la vac tɨbii wê viac xumac kalabuhu ge vɨgê ên nêb he i vông myavɨnê vô i dɨ i loc tyip vô buc wê ob vông mone vɨhati vac i xe ge.” ");
INSERT INTO ptp_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Yesu nêl kɨyang pɨlepacên tige pyap dɨ nêl hɨxôn ên nêbê, “Xam obêc kɨtya lime nên nipaên vêl hɨxôn nɨlôm yadɨluhu lêm ge od Mag kɨsiinê ob vông vô xam vɨhati tɨyi xocbê xomxo levac vông vô nu yuac tige.” ");
INSERT INTO ptp_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Yesu nêl kɨyang tigee vɨhati pyap dɨ sea vɨgwe Galili dɨ la vac vɨgwe levac Judia wê yêp mia Jodan sox laên. ");
INSERT INTO ptp_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Dɨ xomxo kɨdu levac la vô i vɨxa, om Yesu vông he wê yidac ge vô nivɨha lec vac vɨgwe tige. ");
INSERT INTO ptp_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Dêc he Palisi lam vô Yesu ên nêb ob yaxên i, om kɨnêg vô i ên nêbê, “Xomxo ti obêc sea vɨnê ên yucyuu va kɨyang nipwo tya wê yêp vac yuu mahɨgun ge od obêc tɨyi, me?” ");
INSERT INTO ptp_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Om Yesu nêl lax vô he ên nêbê, “Xam mêd o kɨtong kɨyang wê yêp vac xolac ge lêmê? Kɨyang tige nêl bêga ên nêbê vô buc taxlee ilage Anutu wê tung susu vɨhati gee tung xomxo vêx yuu xôn vux, ");
INSERT INTO ptp_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","dɨ nêl ên nêbê, ‘Môp yêp bêga, vux ob sea ta yuu ma dɨ la dô hɨxôn vɨnê dɨ yuu tu nôn tibed.’ ");
INSERT INTO ptp_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Anutu nêl bêge om yuu ob dô tɨyi xocbê xomxo yuu ge lêm. Nge, yuu ob tu nôn tibed. Mêgem môp wê Anutu vông xomxo yuu tu nôn tibed ge, xomxo ti i o lêc tax i tip lêm.” ");
INSERT INTO ptp_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Mêd he Palisi nêl vô i ên nêbê, “Om bêna lêc Moses nêl ên nêbê xomxo ti obêc nêb ob sea vɨnê ge od i kɨvuu kɨpihac wê nêbê yuu ob seama ge dɨ vông vô vɨnê lê, lêc yuu i sea ma?” ");
INSERT INTO ptp_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Mêlêc Yesu nêl vô he ên nêbê, “Xam nɨlôm xêkɨzêc ta, om Moses lee yuu ên nêbê tɨyi wê xam ob sea vɨnême ge. Lêc mugên ilage môp tibêge o yêp lêm. ");
INSERT INTO ptp_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Om a nêl vô xam bê vux ti vɨnê obêc vông môp yôdac vô vux ngwe lêm, lêc lɨya sea vɨnê dɨ la ii vêx paha ngwe ge od vux tige vông môp yôdac.” ");
INSERT INTO ptp_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Om Yesu nue ngɨvihi nêl vô i ên nêbê, “Om môp wê Anutu vông vô vux yuu vɨnê obêc yêp bêge ge od ge nivɨha wê vux ob ob dô gɨlon dɨ o ii vêx lêm.” ");
INSERT INTO ptp_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Lêc Yesu nêl vô he ên nêbê, “Xomxo vɨhati o tɨyi wê ob la vô kɨyang tibêge lêm. Nge, xomxo titi wê Anutu vông xêkɨzêc vô he ge wê he ob vông bêge dɨ ob ii vêx lêm. ");
INSERT INTO ptp_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Ên xomxo vɨyang vɨyang ge, titi o tɨyi wê ob ii vêx ge lêm. Ên he ya, tae kô he tɨyiên ma om he o tɨyi wê he ob ii vêx ge lêm. Dɨ he ya, tɨbii vêl he om he o tɨyi wê he ob kô vêx ge lêm. Dɨ he ya, he vông he nɨlô la vô Anutu xolac yuu ben, om he ngɨbua he ên nêb he ob ii vêx lêm. Om xomxo ti tɨyi wê obêc ngô kɨyang tige ge od i ngô.” ");
INSERT INTO ptp_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Mêd xomxo kô nue nipwopwo mɨ lam vô Yesu ên nêb i vyax vɨgê lec he dɨ kɨtaa lec he, lêc nue ngɨvihi pɨping he nêb he loc vôên Yesu i ma, ");
INSERT INTO ptp_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","lêc Yesu nêl vô he ên nêbê, “Vông nipwopwo i lam vô a dɨ le vac xônên i ma, ên xomxo tibêgee tu vɨgwe lag puunê kehe.” ");
INSERT INTO ptp_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Om Yesu vyax vɨgê lec he, pyap dɨ loc mɨ la vɨgwe ngwe. ");
INSERT INTO ptp_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Xomxo ngɨvihi ti val vô Yesu dɨ kɨnêg vô i ên nêbê, “Xolac kehe, a obêc vông môp nivɨha tina êdêc dô magvɨha luta lêc luta?” ");
INSERT INTO ptp_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Mêd Yesu nêl vô i ên nêbê, “Bêna lêc ông kɨnêg a lec môp wê nivɨha ge? Anutu tibed ge wê nivɨha, om ông obêc nêb la dô mamvɨha ge od ông viac xolac vɨhati.” ");
INSERT INTO ptp_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Om xomxo ngɨvihi tige nêl vô i ên nêbê, “Xolac tina?” Om Yesu nêl ên nêbê, “Xolac wê nêl ên nêbê le i lêc hi xomxo i yib lêm. Le i lêc vông môp yôdac vêx yuu vux lêm. Le i lêc vun xomxo ngwe susu lêm. Le i lêc nêl kɨyang kɨtyooên lec xomxo ngwe lêm. ");
INSERT INTO ptp_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Loc vac tam yuu mam kwa ngɨbi. Dɨ xêmyaa i vin lec xomxo vɨhati i tɨyi xocbê ông xêmyaa vin lec ôcông va ge.” ");
INSERT INTO ptp_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Mêd xomxo ngɨvihi tyo nêl vô i ên nêbê, “A viac xolac vɨhati gee pyap. Om môp tina gên yêp wê a ob vông hɨxôn ge?” ");
INSERT INTO ptp_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Lêc Yesu nêl vô i ên nêbê, “Ông obêc nêb ông ob tu xomxo wê nivɨha lee ge od ông lôc vông ông susu vɨhati mɨ tɨbii i kɨsuu dɨ vông mone vô xomxo wê nên susu maên ge êdêc kô nôn nivɨha gê lag puunê. Om ông lôc vông bêge dɨ lôm tɨmu vô a vɨxag.” ");
INSERT INTO ptp_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Xomxo ngɨvihi tyo ngô kɨyang tige dɨ nɨlô vô vɨyin mabu ên i susu tɨbeac, om sea Yesu dɨ la. ");
INSERT INTO ptp_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Mêd Yesu nêl vô nue ngɨvihi ên nêbê, “A nêl vɨxôhɨlôg vô xam bê xomxo wê susu tɨbeac ge obêc nêb la vac Anutu ben ge od obêc vông yuac levac vô he. ");
INSERT INTO ptp_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","A ob nêl kɨyang ti vô xam i tii vac hɨxôn bê bwoc kamel ti obêc nêb la vac yin kɨtu tocên ge od obêc yuac levac, mêlêc xomxo wê susu tɨbeac ge obêc nêb la vac Anutu ben ge od obêc tu yuac levac vô i luu vêl.” ");
INSERT INTO ptp_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Yesu nue ngɨvihi ngô kɨyang tige dɨ yetac mabu yocên dɨ kɨnêg i ên nêbê, “Obêc tibêge ge od letya tɨyi wê obêc la dô mavɨha vac Anutu ben ge?” ");
INSERT INTO ptp_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Lêc Yesu manôn la vô he dɨ i nêl vô he ên nêbê, “Xomxo mô o tɨyi lêm, dɨ Anutu môci tɨyi wê ob vông môp vɨhati.” ");
INSERT INTO ptp_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Mêd Pita nêl vô i ên nêbê, “Wê lê. Xe ga, xe sea susu wê xe vông ge vɨhati dô dɨ lam tɨmu vô ông vɨxam. Om xe obêc kô nôn vatya vô buc tɨmuênê?” ");
INSERT INTO ptp_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Mêd Yesu nêl vô he ên nêbê, “A nêl vɨxôhɨlôg nôn vô xam bê vô buc tɨmuên wê susu vɨhati obêc vô paha lec ge od a, Xomxo Nu, a ob kô lêg levac mɨ dô lec sia king. Dɨ xam wê xam tɨmu vô a vɨxag gee, xam êno obêc dô lec sia king vɨgê yuu dɨ tô mɨ la yuu, dɨ yaxên lime Islel wê xam hɨpu vɨgê yuu dɨ tô mɨ la yuu ge nên kɨyang. ");
INSERT INTO ptp_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Dɨ xomxo vɨhati wê sea ben hɨxôn tae mae lie dɨ nue dɨ sea yuac yaên wê he vông ge hɨxôn ên nêb ob vông a lêg i vô levac ge od Anutu ob vông nôn nivɨha 100 100 hɨwocên vô he dɨ ob vông he dô mavɨha luta lêc luta. ");
INSERT INTO ptp_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Lêc xomxo mugên tɨbeac obêc lax tɨmu, dɨ xomxo tɨmuên obêc lam la mug.” ");
INSERT INTO ptp_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Yesu nêl ên nêbê, “Anutu ben kehe tɨyi xocbê xomxo levac ti wê tu yuac wain kehe ge. Om pɨtoc yang ge la ên nêb ob la myag xomxo wê ob la vông yuac wain wê i vông ge. ");
INSERT INTO ptp_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Mêdêc la tulec he dɨ nêl vô he ên nêbê obêc vông mone kehe titi vô he tɨyi buc titi. Om he lee yuu dɨ i vông he la vac yuac. ");
INSERT INTO ptp_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Hɨyôv tyip lam 9 klok vɨdiiên, lêc xomxo tyo mɨla yê wê xomxo ya le vɨda vɨda lec wetôv ge, ");
INSERT INTO ptp_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","om nêl vô he ên nêbê, ‘Xam loc vông yuac wain dɨ a ob vông mone nivɨha vô xam.’ Om he la. ");
INSERT INTO ptp_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","“Hɨyôv lam tyip vɨdii pɨpumên dɨ xomxo tyo lax yê he ya hɨxôn, dɨ vông he la vac yuac. Dɨ hɨyôv manôn yon hucên i vông tibêge. ");
INSERT INTO ptp_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Nang dêc vô 5 klok hucên xomxo tyo la yê he ya wê le vɨda vɨda ge. Om nêl vô he ên nêbê, ‘Bêna lêc xam dɨle vaxvax dɨ yuac ma dɨ vɨgwe hucê?’ ");
INSERT INTO ptp_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Om he nêl vô i ên nêbê, ‘Xomxo ti o vông yuac vô xe lêm.’ Om nêl vô he ên nêbê, ‘Xam êno loc yuac wain.’ ");
INSERT INTO ptp_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Pyap dêc vɨgwe buc, mêdêc xomxo levac tyo wê vông yuac wain ge nêl vô xomxo ti wê viac nue yuac ge ên nêbê, ‘Ông tyuc a nuge yuac vɨhati i lam dɨ vông mone vô he. Taxlee ge ông vông mone vô he wê val vông yuac tɨmuên ge dɨ i mɨloc vô he wê val vông yuac tax ge.’ ");
INSERT INTO ptp_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","“Mêd he wê val vông yuac vô 5 klok hucên ge lam tax dɨ he vɨhati kô mone kehe titi tɨyima. ");
INSERT INTO ptp_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Pyap dêc he wê val vông yuac vô pɨtoc ge lam, dɨ he xo ên he nêb mêd he ob kô mone ngɨnoo he wê val vông yuac hucên ge vêl. Lêc he êno kô mone kehe titi. ");
INSERT INTO ptp_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","He kô mone pyap dɨ kunac xomxo levac tige wê i yuac wain ge, ");
INSERT INTO ptp_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","dɨ nêl vô i ên nêbê, ‘Xomxo tigae wê val vông yuac hucên ge he vông yuac tɨyi hɨyôv manôn tibed, lêc ông vông mone vô he tɨyi xocbê ông vông vô xe ge, lêc xe vông yuac pɨtoc yang dɨ vɨgwe buc lec mɨ hɨyôv ya xe nimnɨvi vô myavɨnê.’ ");
INSERT INTO ptp_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Lêc xomxo tyo nêl vô he ên nêbê, ‘Xam lige, a o vông ti so vô xam lêm. Xam lee yuu ên xam nêb a vông mone kehe titi vô xam titi. ");
INSERT INTO ptp_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Om xam kô nêm mone mɨ loc, ên a nêb a ob vông mone vô he wê lam tɨmuên ge i tɨyi xocbê a vông vô xam ge. ");
INSERT INTO ptp_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Ge aca mone om a obêc vông tɨyi xocbê a xovô ge od tɨyiên obêc ma, me? Xam ob wê a nipaên lec a vɨgêg yuac, me?’” ");
INSERT INTO ptp_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Yesu nêl kɨyang pɨlepacên tige pyap dɨ nêl ên nêbê, “Om he tɨmuên obêc lam la mug, dɨ he mugên ge ob lax tɨmu.” ");
INSERT INTO ptp_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Yesu he nue ngɨvihi loc mɨ la ên nêb ob la Jelusalem, om he mɨla môp ti dɨ Yesu kô nue ngɨvihi vɨgê yuu dɨ tô mɨ la yuu mɨ he la dô vɨyonên dɨ nêl vô he ên nêbê, ");
INSERT INTO ptp_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Xam ngô lê. Il ob la Jelusalem, dɨ xomxo ob vông Xomxo Nu la vac he levac wê mi si daa gee hɨxôn xomxo wê xovô Moses xolac gee vɨgê dɨ he ob vông kot vô a dɨ hɨlu kɨyang wê ob hi a xib ge xôn, ");
INSERT INTO ptp_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","dɨ he ob vông a la vac tɨbii wê o Yuda lêm ge vɨgê, mêd tɨbii tigee ob so vya vô a, dɨ pɨsa a ya yihi, dɨ tul a lec xax, dɨ buc yon ob lam la vêl dɨ a obêc kɨdi lec magvɨha.” ");
INSERT INTO ptp_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Vô buc tige Sebedi nu yuu, Jems yuu Jon, hɨxôn ta, yon lam vô Yesu, dɨ ta yev vɨxa kɨtu vô i dɨ nêl ên nêbê ob kɨtaa susu ti vô i. ");
INSERT INTO ptp_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Om Yesu nêl vô i ên nêbê, “Ông ob kɨtaa vatya vô a?” Mêd vêx tyo nêl vô i ên nêbê, “Ông lee yuu ên a nug yuu, yuu i kô lê levac vô buc wê ông ob tu levac ge, dɨ ngwe i dô vô ông vɨgêm hɨyôv dɨ ngwe i dô vô ông vɨgêm kêd.” ");
INSERT INTO ptp_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Lêc Yesu nêl ên nêbê, “Kɨyang wê mon kɨtaa vô a ge, mon o xovô kehe lêm. Vɨyin wê a ob kɨlê ge, muu tɨyi wê muu ob kɨlê hɨxôn, me?” Lêc yuu nêl vô i ên nêbê, “Xii tɨyi pyap.” ");
INSERT INTO ptp_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Mêd Yesu nêl vô yuu ên nêbê, “Vɨxôhɨlôg, muu ob kɨlê vɨyin. Lêc xomxo wê ob kô lê levac mɨ dô vô a vɨgêg hɨyôv dɨ dô vô a vɨgêg kêd ge, a o tu kehe lêm. Ên vɨgwe yuu ge, Mag Anutu vaci viac dɨ vɨnoo he wê ob kô lê levac ge.” ");
INSERT INTO ptp_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Mêdêc Yesu nue ngɨvihi vɨgê yuu ngô kɨyang wê Sebedi nu yuu nêl ge om he xêyaa vô myavɨnê ên kɨyang wê yuu nêl ge. ");
INSERT INTO ptp_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Lêc Yesu keac he lam dɨ nêl vô he ên nêbê, “Xam xovô ên xam nêbê tɨbii levac vac vɨgwe ya viac lie ya kɨyang xêkɨzêc, dɨ tɨbii levac ya yong he dɨ nêl kɨyang xonaên ên nêb lie i tɨmu vô. ");
INSERT INTO ptp_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Dɨ xam ga, xam o lêc vông môp bêge lêm. Nge, xam ti obêc nêb tu xam nêm levac ge od i tu xam nêm xomxo yuac, ");
INSERT INTO ptp_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","dɨ xam ti obêc nêb tu mugên wê xam vông ge od i tu xomxo wê ob vông yuac vɨdaaên vô xam ge, ");
INSERT INTO ptp_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","i tɨyi xocbê a, Xomxo Nu, a o lam ên a nêb xomxo i vông yuac vô a lêm. Nge, a lam ên a nêb a ob vông yuac dɨ ngɨdu xomxo xôn, dɨ a ob xib, ên vô xomxo tɨbeac vêl ên he nên nipaên.” ");
INSERT INTO ptp_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Yesu he nue ngɨvihi kɨdi gê Jeliko ên nêb ob la, dɨ xomxo kɨdu kɨdu tɨmu vô he vɨxa. ");
INSERT INTO ptp_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Lêc xomxo matocên yuu dô vô môp nɨnya, mêd ngô wê Yesu val ge om tyuc vya levac ên nêbê, “Devit nu, xo vɨgwe pɨsiv ên xii.” ");
INSERT INTO ptp_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Lêc xomxo tɨbeac hɨgac vô yuu ên nêbê, “Muu dô kɨyang maên.” Lêc yuu tyuc vya levac tii vac ên nêbê, “Xomxo levac, ông Devit nu, xo vɨgwe pɨsiv ên xii.” ");
INSERT INTO ptp_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Mêd Yesu le kɨzêc dɨ keac yuu lam vô i dɨ kɨnêg vô yuu ên nêbê, “Muu nêb a vông bêna vô muuê?” ");
INSERT INTO ptp_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Om yuu nêl vô i ên nêbê, “Xomxo levac, vông xii mamnôn i seac.” ");
INSERT INTO ptp_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Mêd Yesu xo vɨgwe pɨsiv ên yuu dɨ vyax vɨgê lec yuu manôn, dɨ lutibed yuu manôn seac dɨ yuu yê vɨgwe, om yuu tɨmu vô Yesu vɨxa mɨ he la. ");
INSERT INTO ptp_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Yesu he nue ngɨvihi mɨla kwabo vô Jelusalem. Mêd he val vɨgwe Betpasi wê yêp kwabo vô kɨtôn Oliv ge. Mêdêc Yesu nêb ob vông nue ngɨvihi yuu i loc, ");
INSERT INTO ptp_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","om nêl vô yuu ên nêbê, “Muu loc vɨgwe tiganê, dɨ muu obêc mɨla ge od lutibed muu ob wê mam la bwoc donki ti wê xomxo ku xôn mɨ i le vac môp hɨxôn nu ge. Om muu pɨwelac yihi vêl ên yuu dɨ dɨdii yuu mɨ lam vô a. ");
INSERT INTO ptp_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Lêc xomxo ti obêc nêl kɨyang ti vô muu lec wê muu kô donki ge od muu nêl vô i bêga bê, ‘Xomxo levac nêb ob kô mɨ vông yuac lec.’ Muu obêc nêl bêge ge od lutibed xomxo tige ob tyuc lec dɨ vông donki tige vô muu.” ");
INSERT INTO ptp_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Yesu nêl bêge ên nêb kɨyang wê plopete nêl ilage i vô nôn lec. Kɨyang tige bêga nêbê, ");
INSERT INTO ptp_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Xam nêl vô xomxo Saion bêga bê, ‘Xam wê lê. King wê xam vông ge val vô xam gwêbaga. Xomxo tige xomxo malehe, dɨ i dô lec bwoc donki. Xomxo tyo dô lec bwoc donki nu ti mɨ val.’” ");
INSERT INTO ptp_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Nue ngɨvihi yuu la vông i tɨyi xocbê Yesu nêl vô yuu ge. ");
INSERT INTO ptp_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Om yuu dɨdii bwoc donki ta hɨxôn nu mɨ lôm vô Yesu, dɨ yuu vax yuu ngakwi lec donki kɨsii dɨ Yesu dô lec. ");
INSERT INTO ptp_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Mêd xomxo tɨbeac vax he nivɨmihi lec môp dɨ he ya hup xax lihi mɨ vax i tup vô môp wê Yesu ob xoc vô ge tɨyi xocbê môp wê xomxo mi kô xomxo levac lec ge. ");
INSERT INTO ptp_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Dɨ xomxo kɨdu levac wê la mug dɨ kɨdu levac wê tɨmu vô Yesu vɨxa gee, he vɨhati tyuc vya levac ên nêbê, “Il ob pɨmil Devit nu. Il ob hi vɨxad i pec ên xomxo ti wê tu Apumtau manôn mɨ val ge. Il ob pɨmil Anutu lê i vô levac dɨ i loc yêp kɨsii.” ");
INSERT INTO ptp_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","He tyuc bêge, dɨ Yesu mɨla Jelusalem, dɨ xomxo Jelusalem vɨhati vô nidɨdun levac dɨ nêl vôma ên nêbê, “Xomxo tiga letya?” ");
INSERT INTO ptp_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Om xomxo kɨdu levac wê lam hɨxôn Yesu ge nêl lax vô he ên nêbê, “Xomxo tiga Yesu, plopete ti wê lam gê Nasalet vac vɨgwe levac Galili ge.” ");
INSERT INTO ptp_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Mêdêc Yesu la vac Anutu xumac ngɨbua nɨlô dɨ la tii tɨbii vɨhati wê dɨvông vɨtevac lec susu vac xumac ngɨbua nɨlô gee lop mɨ lam la vêl, dɨ tɨbii wê vông mone luuma gee, Yesu vông he nên tevol kɨpê sea, dɨ xomxo wê vông menac nêb tɨbii i kɨsuu ên tu xocbê daa ge, Yesu kɨpê he nên sia sea, ");
INSERT INTO ptp_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","dɨ nêl vô he ên nêbê, “Xolac nêl bêga ên nêbê, ‘A xumac tiga, xumac kɨtaa vacên.’ Xolac nêl bêge, lêc xam vông a xumac vô nipaên tɨyi xocbê xumac wê tɨbii yôdac xôpac vac ge.” ");
INSERT INTO ptp_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Yesu dô vac Anutu xumac ngɨbua nɨlô dɨ xomxo matocên hɨxôn xomxo vɨxa pecên val vô i dɨ i vông he vô nivɨha lec. ");
INSERT INTO ptp_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Lêc xomxo levac wê mi si daa gee hɨxôn he wê xovô Moses xolac gee, he yê do levac wê Yesu vông ge dɨ ngô kɨyang wê nue nipwo tyuc bêga ên nêbê, “Il ob pɨmil Devit nu.” Om xomxo levac tigee ni nyag ");
INSERT INTO ptp_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","dɨ nêl vô Yesu ên nêbê, “Kɨyang wê nipwopwo nêl ge, ông ngô, me?” Lêc Yesu nêl vô he ên nêbê, “Ge a ngô, lêc kɨyang wê yêp vac xolac ge, mêd xam o kɨtong lêmê? Kɨyang nêl bêga ên nêbê, ‘Nume nipwo dɨ he wê gên lul ge, ông nêl kɨyang pɨmilên vac he mya om he pɨmil ông.’” ");
INSERT INTO ptp_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Yesu nêl kɨyang tige vô he pyap dɨ loc mɨ la yêp gê Betani. ");
INSERT INTO ptp_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Yesu he nue ngɨvihi yêp dɨ kɨdi mɨ la pɨtoc ên nêb ob la Jelusalem, lêc mɨla môp ti dɨ vip den Yesu. ");
INSERT INTO ptp_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Mêd Yesu yê ma la hɨguc wê le vô môp nɨnya ge, om la kwabo nêb ob ya nôn, lêc nôn ti o yux lec lêm. Nge, yatôv hɨxôn lihi pɨleva le. Om Yesu nêl vô xax tyo ên nêbê, “Ông obêc vuac nôn ti i tii vac lêm.” Om lutibed xax tige mupac. ");
INSERT INTO ptp_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Nue ngɨvihi yê dɨ yetac dɨ kɨnêg vô Yesu ên nêbê, “Bêna lêc hɨguc tiganê mupac lutibedê?” ");
INSERT INTO ptp_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Om Yesu nêl lax vô he ên nêbê, “Xam obêc kɨtaa susu ti vô Anutu hɨxôn vông vinên ge od Anutu ob vông vô xam. Om a nêl vɨxôhɨlôg nôn vô xam bêga bê xam obêc vông i vin hɨxôn nɨlôm tibed ge od xam obêc nêl kɨyang tɨyi xocbê a nêl lec hɨguc ge dɨ obêc vô nôn lec. Lêc xam ob vông yuac tibed mô lêm. Nge, xam obêc nêl vô kɨtôn tiganê bê, ‘Ông pul mɨ loc vac gwec’ ge od ob la tɨyi xocbê xam nêl ge. ");
INSERT INTO ptp_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Ên xam obêc kɨtaa susu ti vô Anutu hɨxôn vông vinên ge od Anutu ob vông vô xam.” ");
INSERT INTO ptp_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Yesu la vac Anutu xumac ngɨbua nɨlô, dɨ la nêl xolac vô xomxo. Mêd xomxo levac wê mi si daa gee hɨxôn he Islel levac ya val kɨnêg vô i ên nêbê, “Ông kô xêkɨzêc vô letya lêc lam vông yuac tigae, dɨ ông tu letya manônê?” ");
INSERT INTO ptp_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Om Yesu nêl lax vô he ên nêbê, “A êno ob kɨnêg kɨyang ti vô xam, dɨ xam obêc nêl kɨtong ge od a êno ob nêl xomxo ti wê vông xêkɨzêc vô a ge kɨtong vô xam. ");
INSERT INTO ptp_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Om a ob kɨnêg vô xam bê mia lipacên wê Jon vông ge kehe yêp vô letya? Kehe lam vô Anutu lag puunê me xomxo kɨbun ga vông?” Om he ngaênma dɨ nêl vôma ên nêbê, “Il ob nêbê va? Ên il obêc nêl bê Anutu lag puunê vông ge od Yesu ob nêl vô il bêga bê, ‘Bêna lêc xam o vông i vin kɨyang wê Jon nêl ge lêmê?’ ");
INSERT INTO ptp_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Lêc il obêc nêl bê xomxo kɨbun ga vông ge od il ob xona ên xomxo vɨhati, ên he vông i vin ên he nêbê Jon ge plopete nôn.” ");
INSERT INTO ptp_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Om he nêl vô Yesu ên nêbê, “Xe o xovô mia lipacên wê Jon vông ge kehe lêm.” Mêd Yesu nêl vô he ên nêbê, “Om a êno ob nêl xomxo ti wê vông xêkɨzêc vô a ge kɨtong vô xam lêm. ");
INSERT INTO ptp_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“Xam xo ên xam nêbê va? Xomxo ti nu yuu dô, om ma la nêl vô nu tuc ên nêbê, ‘Tuc, gwêbaga ông loc vông yuac wain wê a vông ge.’ ");
INSERT INTO ptp_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Lêc nu tuc nêl lax vô ma ên nêbê, ‘A ob la lêm.’ Nu tuc nêl bêge dɨ tɨmuên lêc pɨlepac nɨlô dɨ la vông yuac wê ma nêl ge. ");
INSERT INTO ptp_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Nang dêc ma la vô nu môn dɨ nêl vô i tɨyi xocbê nêl vô nu tuc ge. Mêd nu môn nêl i lax vô ma ên nêbê, ‘Mag, a ob la.’ Lêc kɨtyoo dɨ o la vông yuac lêm. ");
INSERT INTO ptp_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Om nu yuu ngwe na wê ngô ma kɨyangê?” Om xomxo daa siên hɨxôn he Islel levac nêl vô Yesu ên nêbê, “Nu tuc.” Mêd Yesu nêl vô he ên nêbê, “A nêl vɨxôhɨlôg nôn vô xam bê tɨbii nipaên wê kô takis gee hɨxôn vêx yôdac gee, he ob mug ên xam mɨ la vac Anutu ben lag puunê. ");
INSERT INTO ptp_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Ên Jon Lipacên lam hɨlung môp bôbac vô xam, lêc xam o vông i vin kɨyang wê i nêl ge lêm. Lêc tɨbii nipaên wê kô mone takis gee hɨxôn vêx yôdac gee, he vông i vin, dɨ xam xovô wê he vông i vin ge, lêc xam o pɨlepac xam mɨ vông i vin lêm. ");
INSERT INTO ptp_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“Xam ngô kɨyang pɨlepacên ngwe. Xomxo ti bin yuac levac wê i vông ge dɨ xin wain vac dɨ ku xenac kɨsuu lec, dɨ yev lôva ti wê xomxo ob gig wain nôn vac ge dɨ lox xumac wê xomxo ob dô vac dɨ yê yuac xôn ge. Om vông yuac tige vac tɨbii ya vɨgê ên nêb he i viac. Pyap dêc xomxo tyo la dô vac vɨgwe teva ngwe. ");
INSERT INTO ptp_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Dɨ buc wê wain nôn huu ge vô kwabo lec, om vông nue yuac ya la vô tɨbii wê viac yuac wain gee ên nêb he i loc yul wain nôn wê huu ge dɨ kô mɨ lôm vô i. ");
INSERT INTO ptp_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Om he la, lêc tɨbii wê viac yuac ge hôm he xôn dɨ tax ti ninɨvi sea dɨ hi ngwe yib dɨ nêx ti ya ngɨdax. ");
INSERT INTO ptp_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Nang dêc tɨmuên xomxo levac tyo vông nue yuac ya la nang. He tɨbeac ngɨnoo he wê la tax ge vêl, lêc tɨbii wê viac yuac gee vông nipaên vô he tɨyi xocbê he vông vô xomxo yuac wê la tax ge. ");
INSERT INTO ptp_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","“Mêdêc tɨmuên xomxo levac tyo vông nu tuc la vô he, ên xo vac nɨlô bêga ên nêbê, ‘Ga aca va nug om he ob yê i xocbê xomxo levac dɨ ngô kɨyang wê ob nêl vô he ge.’ ");
INSERT INTO ptp_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Lêc tɨbii wê viac yuac gee yê nu tuc wê mɨla ge, om nêl vôma ên nêbê, ‘Xomxo tige wê ma ob nêl i lê lec yuac wain ga. Om il ob hi i yib ên yuac wain ga i tu il xe.’ ");
INSERT INTO ptp_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Om he hôm i xôn dɨ kô mɨ la nɨnyawehe dɨ la hi i yib. ");
INSERT INTO ptp_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Om xomxo levac tige obêc val ge od ob vông bêna vô tɨbii tigee wê viac i yuac gee?” ");
INSERT INTO ptp_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Om xomxo daa siên hɨxôn he Islel levac nêl vô Yesu ên nêbê, “Xomxo levac tige ob vông myavɨnê levac vô he dɨ hi he yib, dɨ ob vông yuac wain tige vac tɨbii ba vɨgê ên he i viac, dɨ he ob vông wain nôn vô xomxo levac tyo vô buc wê he obêc yul nôn ge.” ");
INSERT INTO ptp_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Mêd Yesu nêl vô he ên nêbê, “Kɨyang wê yêp vac xolac ge, xam mêd o kɨtong lêm, me? Ên kɨyang nêl bêga ên nêbê, ‘Ngɨdax ti wê xomxo xumac loxên yê nêbê tɨyiên ma ge, ge wê tu ngɨdax xêkɨzêc wê ob hôm xumac xôn ge. Apumtau vaci vông bêge, dɨ xe xê tɨyi xocbê susu nivɨha.’ ");
INSERT INTO ptp_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Xolac nêl bêge, om a ob nêl vô xam bê Anutu ob vô kɨyang yuu yuac wê i vông ge vêl ên xam Yuda dɨ ob vông vac tɨbii ba vɨgê, dɨ he ob vông i vô nôn lec. ");
INSERT INTO ptp_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Xomxo ti obêc mwoc mɨ hi i lec ngɨdax tige ge od ob hi i len vô pɨpu sea, dɨ ngɨdax tige obêc tô mɨ hi xomxo ti ge od ob hi i pɨtal sea.” ");
INSERT INTO ptp_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","He levac wê mi si daa gee hɨxôn he Palisi ngô kɨyang pɨlepacên tigee dɨ xovô ên nêbê Yesu nêl kɨyang lec he. ");
INSERT INTO ptp_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Om he nêb he ob hôm Yesu xôn, lêc he xona ên xomxo tɨbeac, ên he tɨbeac yê Yesu tɨyi xocbê plopete ti. ");
INSERT INTO ptp_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Nang dêc Yesu nêl kɨyang pɨlepacên ngwe vô he bêga ên nêbê, ");
INSERT INTO ptp_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Anutu ben kehe tɨyi xocbê môp wê xomxo levac ti vông. Xomxo tige nu vux ti nêb ob kô vêx om ma nêb ob myêl vɨzid levac. ");
INSERT INTO ptp_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Mêd vông kɨyang la vô tɨbii ya tax ên nêb ob myêl vɨzid levac ti. Om vô buc wê obêc myêl yaên ge od vông nue yuac la nêl vô tɨbii tigee nêb he i lam vac yaên levac. Lêc tɨbii tigee nêb ob lam lêm. ");
INSERT INTO ptp_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Om xomxo levac tige vông nue yuac ya la tii vac dɨ nêl vô he ên nêbê, ‘Xam lôc vô he wê a nêb he i lam vac vɨzid ge, dɨ nêl kɨtong vô he bê a viac a pyap, dɨ a hi bwoc kau dɨ bwoc nipwo levac levac hɨxôn dɨ viac yaên vɨhati pyap, om he i lam ya vɨzid a vông, ên a nug ob kô vêx.’ ");
INSERT INTO ptp_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","“Mêgem nue yuac tigee la nêl kɨyang vô tɨbii, lêc he ni ma lec kɨyang nêb ob ngô lêm. Om he la vaxvax, ti la yuac yaên dɨ ti la yuac mone, ");
INSERT INTO ptp_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","dɨ he ya hôm xomxo levac nue yuac xôn mɨ vông he vô nipaên dɨ hi he yib. ");
INSERT INTO ptp_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Om xomxo levac tige xêyaa vô myavɨnê, om vông nue vevac la vô he wê hi i nue yuac yib ge, dɨ nue vevac hi he yib dɨ nyuu he nên xumac, dɨ ngwax ya he ben ma vêl. ");
INSERT INTO ptp_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","“Mêd xomxo levac tyo nêl vô nue yuac ên nêbê, ‘A myêl vɨzid levac pyap mɨ i dô, lêc xomxo wê a tyuc he ên a nêb he i lam ya ge o tɨyi wê ob ya ge lêm. ");
INSERT INTO ptp_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Mêgem xam loc vac môp levac vɨhati, dɨ xomxo wê xam ob tulec ge, xam kô vɨhati mɨ lam vac vɨzid wê a vông ge.’ ");
INSERT INTO ptp_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Om nue yuac la le vac môp vɨhati dɨ la kɨtuc xomxo nivɨha yuu xôn nipaên wê he tulec ge dɨ kô he vɨhati mɨ la vac vɨgwe wê he ob ya vɨzid vac ge. Om he la pup lec xomxo levac tyo ben. ");
INSERT INTO ptp_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“He val dô, mêdêc xomxo levac tyo la vac xumac nɨlô ên nêb ob yê he, lêc yê xomxo ti wê o vɨnyum ngakwi vɨzid ya yaên ge lêm. ");
INSERT INTO ptp_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Om xomxo levac nêl vô i ên nêbê, ‘Lig, bêna lêc ông o vɨnyum ngakwi vɨzid ya yaên lêm, lêc lam dô hɨxônê?’ Lêc xomxo tyo o xovô kɨyang ti wê ob nêl lax vô i ge lêm. ");
INSERT INTO ptp_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Om xomxo levac tyo nêl vô nue yuac ên nêbê, ‘Xam ku xomxo tige vɨxa yuu vɨgê xôn dɨ nêx i loc vac vɨgwe mapɨtoc. Vac vɨgwe tige xomxo ob byag levac dɨ nɨvu kic lecma.’” ");
INSERT INTO ptp_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Yesu nêl kɨyang pɨlepacên tige pyap dɨ nêl ên nêbê, “Anutu tyuc xomxo tɨbeac lê, lêc ob vɨnoo nôn titi.” ");
INSERT INTO ptp_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Mêdêc he Palisi la kɨtucma dɨ keac lec kɨyang wê nêb ob kɨnêg vô Yesu ên i nêl kɨyang ti i so. ");
INSERT INTO ptp_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Om Palisi vông he nue ngɨvihi hɨxôn Helot nue ngɨvihi la vô Yesu dɨ he nêl vô i ên nêbê, “Xolac kehe, xe xovô ên xe nêbê ông wê ông mi nêl kɨyang hɨxôn nôn, dɨ ông tɨxuu xomxo ya môp wê Anutu vông ge dɨ ông o kɨtyoo lêm, dɨ ông o xona ên xomxo ti lêm, ên ông wê xomxo vɨhati tɨyima. ");
INSERT INTO ptp_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Om ông nêl vô xe bê ông xovô bêna? Il Yuda obêc vông takis vô king Sisa wê tɨbii ba ge od ob pwoo Moses xolac vac, me?” ");
INSERT INTO ptp_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Lêc Yesu xovô kɨyang nipaên wê yêp vac he nɨlô ge om nêl vô he ên nêbê, “Xam tɨbii kɨtyooên, bêna lêc xam nêb xam ob yaxên a? ");
INSERT INTO ptp_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Xam kô mone takis tyo mɨ lam a xê.” Om he vông mone ti vô i. ");
INSERT INTO ptp_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Dɨ Yesu kɨnêg vô he ên nêbê, “Letya kɨnu yuu lê wê yêp lec mone tiga?” ");
INSERT INTO ptp_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Lêc he nêl ên he nêbê, “Sisa kɨnu yuu lê wê yêp lec mone tiga.” Om Yesu nêl vô he ên nêbê, “Om susu wê Sisa xe ge, xam vông i loc vô Sisa, dɨ susu wê Anutu xe ge, xam vông i loc vô Anutu.” ");
INSERT INTO ptp_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","He ngô kɨyang wê Yesu nêl ge dɨ yetac mabu, dɨ sea i dɨ la. ");
INSERT INTO ptp_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Vô buc tyo xomxo Sadyusi ya val vô Yesu. He Sadyusi ge, he mi nêl ên he nêbê xomxo yibên ob kɨdi lec mɨ dô mavɨha lêm. Om he val kɨnêg vô Yesu ên nêbê, ");
INSERT INTO ptp_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Xolac kehe, Moses xolac nêl bêga ên nêbê, ‘Xomxo ti obêc yib dɨ nu ma ge od xomxo tyo li ngwe ob ii vêxôv tige ên yuu i kô nue dɨ nue i tu susu wê ma yibên vông ge kehe.’ Moses xolac nêl bêge. ");
INSERT INTO ptp_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Om ilage vux vɨgê vɨlu dɨ sec yuu wê ta yuu ma tibed ge dô vac xe mahɨgun. Mêdêc li tuc kô vêx ti lêc yib dɨ nu ma, om li môn kô vêx tyo nang. ");
INSERT INTO ptp_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Lêc li môn yib dɨ nu ma om li gwaa kô vêx tige tii vac nang, lêc yib dɨ nu ma, dɨ lie tɨmuên vɨhati kô vêx tige dɨ i mɨla vô li tɨmuên tyo hɨxôn, lêc nu ma dɨ he vɨhati yib. ");
INSERT INTO ptp_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Dɨ tɨmuên lêc vêx tyo yib. ");
INSERT INTO ptp_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Ông nêl ên ông nêbê xomxo ob kɨdi lec mavɨha vac yibên, om xe nêb xe ob kɨnêg ông bê buc wê xomxo yibên obêc kɨdi lec ge od vêx tige ob tu vux tina vɨnê? Ên vux vɨgê vɨlu dɨ sec yuu ii vêx tibed lec buc wê he dô mavɨha ge.” ");
INSERT INTO ptp_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Lêc Yesu nêl i lax vô he ên nêbê, “Xam o xovô kɨyang wê yêp vac xolac ge lêm dɨ xam o xovô xêkɨzêc wê Anutu vông ge lêm, om xam nêl kɨyang so. ");
INSERT INTO ptp_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Ên buc wê xomxo yibên ob kɨdi lec ge, he ob iima lêm. Nge, he ob dô tɨyi xocbê angela lag puunê. ");
INSERT INTO ptp_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Dɨ kɨyang lec wê xomxo yibên ob kɨdi lec mavɨha ge, xam mêd o kɨtong kɨyang wê Anutu nêl vô xam ge lêm, me? Ên Anutu nêl bêga ên nêbê, ");
INSERT INTO ptp_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Eblaham Anutu a, dɨ Aisak Anutu a, dɨ Jekop Anutu a.’ Anutu nêl bêge, lêc yon yib tax dêc Anutu nêl kɨyang tige tɨmuên om kɨyang tige nêl kɨtong ên nêbê Anutu o tu xomxo yibên nên Anutu lêm. Nge, tu xomxo mavɨha nên Anutu.” ");
INSERT INTO ptp_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Xomxo kɨdu levac tige ngô dɨ yetac mabu ên kɨyang wê Yesu nêl ge. ");
INSERT INTO ptp_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","He Palisi ngô wê Yesu kɨyang vông he Sadyusi dô kɨyang maên ge om he kɨtucma mɨ la vô Yesu. ");
INSERT INTO ptp_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Dɨ he wê tu Moses xolac kehe gee ti nêb ob yaxên Yesu om kɨnêg vô i ên nêbê, ");
INSERT INTO ptp_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Xolac kehe, xolac wê Anutu nêl vô Moses ge, tina wê ngɨnoo vêl ge?” ");
INSERT INTO ptp_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Om Yesu nêl vô i ên nêbê, “Xolac ti wê ngɨnoo vêl ge bêga nêbê ông xêmyaa i vin lec ông Apumtau Anutu dɨ ông vông nɨlôm yuu kɨnum dɨ pɨyôp i loc yadɨluhu vô Anutu. ");
INSERT INTO ptp_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Xolac tibed tiga wê yêp mugên dɨ ngɨnoo baba vêl. ");
INSERT INTO ptp_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Dɨ xolac ngwe wê vông yuu ge tɨyi xocbê ngwe wê yêp mugên ge nêl bêga ên nêbê ông xêmyaa i vin lec xomxo vɨhati i tɨyi xocbê ông xêmyaa vin lec ôcông va ge. ");
INSERT INTO ptp_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Xolac yuu ga tu kɨyang wê Moses he plopete nêl ilage vɨhati kehe.” ");
INSERT INTO ptp_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","He Palisi kɨtucma mɨ la dô hɨxôn Yesu, om Yesu kɨnêg vô he bêga ên nêbê, ");
INSERT INTO ptp_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Xam xo bêna lec xomxo levac wê lê Kɨlisi ge? Xam xo ên xam nêbê letya nu i?” Om he Palisi nêl vô Yesu ên nêbê, “Ge Devit nu ti.” ");
INSERT INTO ptp_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Mêd Yesu nêl vô he ên nêbê, “Obêc Devit bue tɨmuên ti ge od bêna lêc Myakɨlôhô Ngɨbua vông Devit nêl kɨyang lec Kɨlisi ên nêbê Apumtau? Ên Devit nêl bêga nêbê, ");
INSERT INTO ptp_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Apumtau Anutu nêl vô a lig Apumtau ên nêbê, “Ông lôm dô vô a vɨgêg hɨyôv dɨ a ob vông tɨbii wê vông vevac vô ông gee, he i loc dô vac ông kwa ngɨbi.” ’ ");
INSERT INTO ptp_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Devit nêl bêge, om Devit obêc nêl lec Kɨlisi ên nêbê Apumtau ge od bêna lêc xam nêbê Kɨlisi ge Devit bue ti?” ");
INSERT INTO ptp_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","He ngô kɨyang wê Yesu nêl ge, lêc ti o tɨyi wê ob luu kɨyang ti lax vô i ge lêm. Om vô buc tige he xona ên i om he o kɨnêg kɨyang ti vô i tii vac lêm. ");
INSERT INTO ptp_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Nang dêc Yesu nêl vô xomxo kɨdu levac hɨxôn i nue ngɨvihi ên nêbê, ");
INSERT INTO ptp_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“He wê xovô Moses xolac gee hɨxôn he Palisi, he le vac Moses nipɨlêhê dɨ vông Moses xolac vô xam, ");
INSERT INTO ptp_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","om kɨyang vɨhati wê he nêl vô xam ge, xam ngô dɨ tɨmu vô. Lêc le i lêc vông môp tɨyi xocbê he vông ge lêm. Ên he tɨxuu xam ya kɨyang nivɨha, lêc he o tɨmu vô kɨyang wê he mi nêl ge lêm. ");
INSERT INTO ptp_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Ên he vông vɨyin vô xam tɨyi xocbê he tɨtup susu vɨyin dɨ lii lec xam kɨdiac ên nêb xam kɨlê ge, lêc he o hôm nipwo ti vac vɨgê hɨxôn lêm. ");
INSERT INTO ptp_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Môp vɨhati wê he mi vông ge, he vông ên he nêb xomxo i yê dɨ pɨmil he. Om he kɨvuu Anutu xolac lec kɨpihac dɨ su vac vɨxec nu wê duu bwoc ninɨvi ge dɨ ku yêp lec mahɨgê maxooên, dɨ he duu myahɨlihi dia la yux lec ngakwi myahɨpu, ");
INSERT INTO ptp_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","dɨ he obêc la ya vɨzid levac me obêc la vac xumac lɨlo ge od he nêb he ob la dô lec sia wê xomxo levac mi dô lec ge, ");
INSERT INTO ptp_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","dɨ he xêyaa vin lec wê he ob la vɨlee lec wetôv ên nêb xomxo i kô he lec, dɨ xêyaa vin lec nêb xomxo i nêl bê he xolac kehe. ");
INSERT INTO ptp_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Lêcom a ob nêl vô xam bêga bê xomxo ti i o lêc nêl vô xam bê xam ge xolac kehe lêm. Ên xomxo tibed tu xam nêm xolac kehe, dɨ xam vɨhati xam lime. ");
INSERT INTO ptp_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Dɨ le i lêc vɨnoo xomxo kɨbun ga ti bê xam mam lêm, ên mam tibed wê dô lag puunê. ");
INSERT INTO ptp_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Dɨ xomxo ti i o lêc nêl vô xam bê xam xomxo levac lêm. Ên xam nêm xomxo levac tibed ge Kɨlisi. ");
INSERT INTO ptp_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Xomxo wê tu xam nêm levac ge i loc tu xam nêm tɨbii yuac hɨxôn lê, ");
INSERT INTO ptp_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","ên xomxo ti obêc kô i lec ge od Anutu ob vông i lê vô nipwo lec. Lêc xomxo ti obêc pɨlepac i dɨ vô nipwo lec ge od Anutu ob vông i lê vô levac. ");
INSERT INTO ptp_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Xam wê xam xovô Moses xolac gee hɨxôn xam Palisi, xam tɨbii kɨtyooên, xam nɨlôm pɨtal pyap. Xam tung vuayen lag puunê lec ên xomxo. Xacxam va ob la vac lêm, lêc he wê nêb ob la vac Anutu ben ge xam le vac he xôn. ");
INSERT INTO ptp_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Xam wê xam xovô Moses xolac gee hɨxôn xam Palisi, xam tɨbii kɨtyooên, xam nɨlôm pɨtal pyap. Xam vô vêxôv nên susu yuu xumac vêl ên he, dɨ buc wê xam obêc kɨtaa ge od xam mi vɨyum nêm nipaên vac kɨtaaên dia. Om xam obêc kô myavɨwen nipaên luu vêl. ");
INSERT INTO ptp_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Xam wê xam xovô Moses xolac gee hɨxôn xam Palisi, xam tɨbii kɨtyooên, xam nɨlôm pɨtal pyap. Xam la vac sip dɨ la vɨlee vac vɨgwe mɨ la ên xam nêb xam ob pɨlepac xomxo ti i tu xam nume ngɨvihi. Lêc xomxo tyo obêc tu nume ngɨvihi ge od xam vông i la vac nipaên levac luu wê xam vông ge vêl, om xam xôn vɨhati ob la vac vɨgwe nipaên. ");
INSERT INTO ptp_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Xam ge mamtocên, lêc xam nêb xam ob hɨlung môp vô xomxo, xam nɨlôm pɨtal pyap. Xam mi nêl ên xam nêbê, ‘Xomxo ti obêc tɨtô vɨgê la kɨsii dɨ nêl kɨyang ti dɨ nêl Anutu xumac ngɨbua lê hɨxôn ge od kɨyang wê i nêl ge kɨyang pɨleva. Lêc xomxo ti obêc tɨtô vɨgê la kɨsii dɨ nêl kɨyang ti dɨ nêl gol wê he lipac lec xumac ngɨbua ge lê hɨxôn ge od xomxo tyo i vông i tɨyi kɨyang wê i nêl ge.’ ");
INSERT INTO ptp_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Xam mi nêl bêge, lêc xam ge tɨbii yacyac wê manôn toc ge. Susu ngwe na wê ngɨnoo vêlê? Gol ngɨnoo vêl, me Anutu xumac ngɨbua wê vông gol tu ngɨbua ge ngɨnoo vêlê? ");
INSERT INTO ptp_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Xam mi nêl ên xam nêbê, ‘Xomxo ti obêc tɨtô vɨgê la kɨsii dɨ nêl kɨyang ti dɨ nêl alta lê hɨxôn ge od kɨyang wê i nêl ge kɨyang pɨleva. Lêc xomxo ti obêc tɨtô vɨgê la kɨsii dɨ nêl kɨyang ti dɨ nêl daa wê yêp lec alta ge lê hɨxôn ge od xomxo tige i vông i tɨyi kɨyang wê i nêl ge.’ ");
INSERT INTO ptp_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Xam mi nêl bêge, lêc xam ge tɨbii matocên. Susu ngwe na wê ngɨnoo vêlê? Daa ngɨnoo vêl, me alta wê vông daa tu ngɨbua ge ngɨnoo vêlê? ");
INSERT INTO ptp_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Om a nêl vô xam bê xomxo ti obêc tɨtô vɨgê la kɨsii dɨ nêl kɨyang ti dɨ nêl alta lê hɨxôn ge od tɨyi xocbê nêl daa wê yêp lec alta kɨsii ge lê hɨxôn. ");
INSERT INTO ptp_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Dɨ xomxo ti obêc tɨtô vɨgê la kɨsii dɨ nêl kɨyang ti dɨ nêl Anutu xumac ngɨbua lê hɨxôn ge od tɨyi xocbê nêl Anutu wê dô vac xumac tige lê hɨxôn. ");
INSERT INTO ptp_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Dɨ xomxo ti obêc tɨtô vɨgê la kɨsii dɨ nêl kɨyang ti dɨ nêl vɨgwe lag puunê lê hɨxôn ge od tɨyi xocbê nêl Anutu sia king lê dɨ nêl Anutu wê dô lec sia tige lê hɨxôn. ");
INSERT INTO ptp_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Xam wê xam xovô Moses xolac gee hɨxôn xam Palisi, xam tɨbii kɨtyooên, xam nɨlôm pɨtal pyap. Ên xam obêc tulec lehac yuu ngec dɨ xax ninɨvi nivɨvea ge od xam mi tung kɨdu vɨgê yuu dɨ vông ti la tu daa vô Anutu. Lêc xam sea môp levac wê Moses xolac nêl ge xocbê môp bôbac dɨ môp wê xam ob xo vɨgwe pɨsiv ên xomxo, dɨ môp wê xam ob vông i vin. Om a ob nêl vô xam bê xam o lêc vông môp ngwe dɨ sea ngwe lêm. Nge, xam vông yuu xôn tɨyima. ");
INSERT INTO ptp_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Xam ge mamtocên, lêc xam nêb xam ob hɨlung môp vô xomxo. Xam mi hôm vɨmeac vêl ên yaên, lêc bwoc levac xam ngôn dɨluhu. ");
INSERT INTO ptp_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Xam wê xam xovô Moses xolac gee hɨxôn xam Palisi, xam tɨbii kɨtyooên, xam nɨlôm pɨtal pyap. Xam mi lipac nimnɨvi pɨleva tɨyi xocbê xam lipac kap yuu pɨle nɨmi ge, dom xam nɨlôm ge, môp yôdac hɨxôn môp nipaên pup lec. ");
INSERT INTO ptp_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Xam Palisi matocên, xam lipac kap yuu pɨle nɨlô i vô nivɨha lê, êdêc nɨmi i vô nivɨha lec hɨxôn. ");
INSERT INTO ptp_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Xam wê xam xovô Moses xolac gee hɨxôn xam Palisi, xam tɨbii kɨtyooên, xam nɨlôm pɨtal pyap. Xam tɨyi xocbê vɨgwe yibên wê xomxo vunac vô nivɨha ge. Il xê vɨxun nêbê nivɨha, lêc nɨlô ge, xomxo yibên len hɨxôn susu ningeac vɨhati ge dô vac. ");
INSERT INTO ptp_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Om xam êno tɨyi bêge, ên xomxo mi yê xam nêbê xam xomxo nivɨha, lêc xam nɨlôm môci, môp kɨtyooên hɨxôn môp wê xam pwoo Anutu kɨyang vac ge yêp vac xam nɨlôm. ");
INSERT INTO ptp_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Xam wê xam xovô Moses xolac gee hɨxôn xam Palisi, xam tɨbii kɨtyooên, xam nɨlôm pɨtal pyap. Xam mi lox xumac nivɨha lec plopete wê yibên ge lôva kɨsii dɨ xam vunac vô xomxo nivɨha wê yibên ge lôva. ");
INSERT INTO ptp_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Dɨ xam mi nêl ên xam nêbê, ‘Xe obêc dô vac buge buc ilage od xe ob tɨmu vô môp wê he vông ge dɨ hi plopete yib lêm.’ ");
INSERT INTO ptp_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Xam nêl bêge, om xam nêm kɨyang nêl xam kɨtong nêbê xomxo wê hi plopete yib ge nue xam. ");
INSERT INTO ptp_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Om xam loc vêl dɨ loc vông môp nipaên i tɨyi xocbê mame bume vông ilage! ");
INSERT INTO ptp_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Myel nipaên nue xam! Anutu obêc yaxên xam dɨ vông xam la vac vɨgwe nipaên. Om xam ob pec ên myavɨwen nipaên tige tibêna? ");
INSERT INTO ptp_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","“Om a nêl vô xam bê a ob vông plopete dɨ xomxo pɨyôp levac hɨxôn xomxo wê xovô xolac kehe gee i loc vô xam. Lêc xam ob hi he mangwe yib, dɨ he mangwe, xam ob tul lec pola, dɨ mangwe, xam ob pɨsa ya yihi vac xumac lɨlo wê xam vông ge, dɨ tii he vac vɨgwe vɨyang vɨyang mɨ he la vêl. ");
INSERT INTO ptp_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Om xam ob kô myavɨwen nipaên lec wê bume hi xomxo nivɨha yib ilage. Xam bume hi Ebel wê o vông nipaên ti lêm ge yib taxlee dɨ i val vô Belekaia nu Sekalaia wê bume hi i yib vac xumac ngɨbua yuu alta mahɨgun ge. ");
INSERT INTO ptp_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Om a nêl hɨxôn nôn vô xam bê xam wê xam dô gwêbaga ge, xam obêc kô myavɨwen nipaên lec môp soên vɨhati wê bume vông ilage. ");
INSERT INTO ptp_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“O Jelusalem, Jelusalem, xam wê xam hi plopete yib, dɨ xam nêx he wê Anutu vông i loc vô xam ge ya ngɨdax mɨ he yib. Buc tɨbeac ge a keac ên a nêb xam lam vô a tɨyi xocbê kokɨlêx ta keac nue vɨlu lax vac vɨnihi kwa ngɨbi ge, lêc xam nêb a vôngên i ma. ");
INSERT INTO ptp_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Om xam ngô lê. Anutu ob sea xam bom i yêp pɨleva. ");
INSERT INTO ptp_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Om a nêl vô xam bê xam ob wê a i tii vac nang lêm, dɨ i loc vô buc tɨmuên wê xam ob nêl bêga bê, ‘Il ob pɨmil xomxo ti wê tu Apumtau manôn mɨ val ge.’” ");
INSERT INTO ptp_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Yesu lop vac Anutu xumac ngɨbua ên nêb ob la, lêc nue ngɨvihi mɨla vô i ên nêb ob hɨlung xumac nivɨha ya wê le hɨxôn xumac ngɨbua ge ên nêb i yê bê xumac nivɨha. ");
INSERT INTO ptp_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Lêc Yesu nêl vô he ên nêbê, “Gwêbaga xam wê xumac tigae vɨhati, lêc a nêl nôn vô xam bê obêc buc tɨmuên ge od xumac tigae ob dii sea dɨ ngɨdax ngwe ob dô lec ngwe kɨsii lêm.” ");
INSERT INTO ptp_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Yesu la dô lec kɨtôn Oliv kɨsii, dɨ nue ngɨvihi heche val nêl vô i ên nêbê, “Xe nêb ông nêl vô xe bê kɨyang wê ông nêl lec Anutu xumac ngɨbua ge ob vô nôn lec vô buc tina? Dɨ do tina wê obêc val tax ên xe xê dɨ xovô bê ông ob vena dɨ lag yuu kɨbun obêc pɨlepac ge?” ");
INSERT INTO ptp_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Om Yesu nêl lax vô he ên nêbê, “Xam viac xam nivɨha êdêc xomxo i o lêc kɨtyoo xam lêm. ");
INSERT INTO ptp_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Ên xomxo tɨbeac ob val nêl a lêg lec he lê nêbê he Kɨlisi, om he ob kɨtyoo xomxo tɨbeac. ");
INSERT INTO ptp_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Dɨ xam obêc ngô vevac nidɨdun val kwabo dɨ ngô kɨyang lec vevac wê teva ge od le i lêc yetac dɨ xona lêm. Ên vevac tigee ob val tax, lêc buc myahɨpu gên yêp dia. ");
INSERT INTO ptp_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Ên tɨbii vɨyang ngwe ob vông vevac vô tɨbii vɨyang ngwe, dɨ xomxo vɨgwe ti ob dô kɨdu kɨdu dɨ vông vevac vôma, dɨ vip levac ob den xomxo vac vɨgwe ya, dɨ ngɨyêg ob yoc vac vɨgwe ya, ");
INSERT INTO ptp_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","om vɨyin tigee wê ob val taxlee, lêc vɨyin tɨbeac gên yêp wê ob val tɨmuên hɨxôn. ");
INSERT INTO ptp_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Vô buc tige tɨbii ob hôm xam xôn dɨ vông xam la vac tɨbii vɨgê dɨ he ob vông myavɨnê vô xam dɨ hi xam wib. Dɨ tɨbii vac vɨgwe vɨhati yang xêyaa ob vô myavɨnê vô xam ên wê xam vông i vin a lêg ge. ");
INSERT INTO ptp_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Dɨ xomxo tɨbeac ob sea vông vinên wê he vông ge, dɨ he ob vông lie la vac tɨbii vevac vɨgê, dɨ he xêyaa ob vô myavɨnê vôma. ");
INSERT INTO ptp_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Dɨ plopete kɨtyooên tɨbeac obêc val kɨtyoo xomxo tɨbeac. ");
INSERT INTO ptp_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Dɨ môp nipaên obêc vô levac, om xomxo tɨbeac obêc sea môp xêyaa vin lec maên. ");
INSERT INTO ptp_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Lêc xomxo ti obêc le xêkɨzêc dɨ i la tyip vô buc myahɨpu ge od Anutu obêc kô i mɨ la tung vac ben. ");
INSERT INTO ptp_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Dɨ xomxo ob nêl xolac nivɨha lec Anutu ben kɨsiinê la vac vɨgwe vɨhati yang ên xomxo vɨhati i ngô. Pyap dêc buc myahɨpu obêc val tɨmuên.” ");
INSERT INTO ptp_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Xam wê xam kɨtong kɨyang tiga, xam xovô nivɨha, ên Yesu nêl bêga ên nêbê, “Obêc buc tɨmuên ge susu nipaên nôn wê ob vông vɨgwe vô nipaên ge ob la le vac xumac ngɨbua. Ilage plopete Danyel nêl kɨtong lec susu nipaên tige. ");
INSERT INTO ptp_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Om buc wê susu nipaên tige obêc val le seac ge od xomxo wê dô vac vɨgwe Judia ge he i pec mɨ loc lec kɨtôn, ");
INSERT INTO ptp_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","dɨ he wê dô lec xumac kɨsii ge he i o lêc lop mɨ lax kô he susu ti vac xumac nɨlô lêm. Nge, he i pec mɨ loc lutibed. ");
INSERT INTO ptp_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Dɨ he wê la vac yuac lôma ge he i o lôm kô vɨnyumên ti lêm. Nge, he i pec mɨ loc lutibed. ");
INSERT INTO ptp_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Dɨ xam xo vɨgwe pɨsiv ên vêx wê nu dô vac xêyaa ge dɨ vêx wê vông lul vô nue ge, ên vô buc tigee he ob dô vac vɨyin levac mabu luu vêl. ");
INSERT INTO ptp_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Om xam kɨtaa vô Anutu bê xam ob pec mɨ la vô buc sabat yuu buc ningɨgooên lêm, ");
INSERT INTO ptp_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","ên vô buc tige vɨyin levac mabu ob val. Vô buc mugên ilage dɨ i val gwêbaga hɨxôn, vɨyin tibêge o tulec xomxo lêm, dɨ vô buc tɨmuên ge vɨyin tibêge ob yêp i tii vac lêm. ");
INSERT INTO ptp_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Buc vɨyin tigee obêc yêp dia ge od ob kɨtya xomxo vɨhati vêl. Lêc Anutu ob xo he wê vɨnoo he pyap ge, om ob kɨtov buc tigee vô myabo. ");
INSERT INTO ptp_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Vô buc tige xomxo ti obêc nêl vô xam bê, ‘Wê lê, Kɨlisi dô ga’ me obêc nêl bêga bê, ‘Kɨlisi dô ganê’, ge od xam o lêc vông i vin kɨyang tige lêm. ");
INSERT INTO ptp_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Ên tɨbii kɨtyooên ya ob val nêl bê he Kɨlisi me plopete, dɨ he ob vông do levac toto ên nêb ob pɨlepac xomxo nɨlô i loc vô kɨyang kɨtyooên, dɨ he nêb he ob kɨtyoo xomxo wê Anutu vɨnoo pyap ge hɨxôn. ");
INSERT INTO ptp_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Xam ngô lê. Kɨyang tige gên o vô nôn lec lêm, lêc a nêl kɨtong vô xam tax. ");
INSERT INTO ptp_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Om xomxo obêc nêl vô xam ên nêbê, ‘Wê lê, Kɨlisi dô vac vɨgwe myadongên tiganê’, ge od xam o lêc loc vɨgwe tiganê lêm. Dɨ he obêc nêl vô xam ên nêbê, ‘Wê lê, Kɨlisi dô vac xumac nɨlô tiganê’, ge od xam o lêc vông i vin he kɨyang lêm. ");
INSERT INTO ptp_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Ên a, Xomxo Nu, a obêc vena tɨyi xocbê deac hɨxelac lutibed vac vɨgwe vɨhati wê hɨyôv tyip lam dɨ hoo la ge, om xomxo vɨhati obêc yê dɨ xovô. ");
INSERT INTO ptp_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","“Susu yibên ti obêc yêp vac vɨgwe ti ge od menac byang wê mi ya pɨtalên ge ob kɨtuc la lec. ");
INSERT INTO ptp_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Vɨyin levac wê ob val tɨmuên ge obêc tip la vêl. Nang dêc lutibed hɨyôv yuu dentuc obêc vô mapɨtoc dɨ linacên ob ma, dɨ pɨtua lag puunê obêc tô sea mɨ lam, dɨ susu xêkɨzêc lag puunê obêc vô yocyoc. ");
INSERT INTO ptp_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Mêd do levac wê hɨlung a Xomxo Nu ge obêc val yêp seac vac lag. Om xomxo vɨhati gê kɨbun ga, he ob yê dɨ nɨlô ob vô vɨyin dɨ he ob byag. Nang dêc he obêc yê a, Xomxo Nu, a dô vac vɨyobtoc mɨ lam gê kɨsii ganê dɨ lam hɨxôn xêkɨzêc yuu xêseac levac. ");
INSERT INTO ptp_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Mêd vuac ob tyuc nidɨdun levac, dɨ a ob vông a nuge angela he i loc tɨyi kɨbun myahɨpu vɨhati dɨ loc vɨlu vô xomxo vɨhati wê Anutu vɨnoo he pyap ge. ");
INSERT INTO ptp_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Xam xovô lec xax lɨvêl. Ên lɨvêl lihi obêc yal mɨma ge od xam xovô bê buc wê hɨyôv ob linac ge. ");
INSERT INTO ptp_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Mêgem buc tɨmuên wê susu tigee vɨhati wê a nêl vô xam ga obêc val vô xam ge od xam obêc wê dɨ xovô bê buc wê a ob vena lec ge vô kwabo lec. ");
INSERT INTO ptp_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","A nêl vɨxôhɨlôg nôn vô xam bê xomxo wê dô gwêbaga ge, he ob yib lêm dɨ kɨyang wê a nêl vô xam ga vɨhati obêc vô nôn lec pyap lê. ");
INSERT INTO ptp_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Lag yuu kɨbun xôa obêc ma, dɨ kɨyang wê a vông ge, bo ti xôa obêc ma lêm. Nge, vɨhati obêc yêp. ");
INSERT INTO ptp_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Buc wê a ob vena lec ge, xomxo ti o xovô buc yuu hɨyôv manôn tige lêm, dɨ angela lag puunê lungên buc tige, dɨ a, Xomxo Nu, a êno lungên. Dom Mag vaci tibed wê xovô buc tige. ");
INSERT INTO ptp_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Môp wê xomxo vông vô Nôa buc ilage, xomxo ob vông môp tibêge dɨ i loc vô buc wê a, Xomxo Nu, ob vena lec ge. ");
INSERT INTO ptp_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Vô buc ilage wê mia gên o hɨvun kɨbun xôn lêm ge, xomxo dô mɨ ya dɨ num dɨ iima, dɨ i la tyip lec buc wê Nôa la dô vac sip nɨlô ge, ");
INSERT INTO ptp_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","lêc he lungên wê mia ob hɨvun kɨbun xôn ge, dɨ lutibed mia butac dɨ hɨvun he vɨhati yib mɨma vêl. Om buc wê a, Xomxo Nu, ob vena lec ge ob tɨyi lec bêge. ");
INSERT INTO ptp_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Vô buc tige xomxo yuu ob la vac yuac yaên dɨ Anutu ob kô ngwe dɨ sea ngwe dô xel. ");
INSERT INTO ptp_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Dɨ vêx yuu ob dɨvông yebac, lêc Anutu ob kô ngwe dɨ sea ngwe dô xel. ");
INSERT INTO ptp_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Mêgem xam dô dɨ viac xam, ên xam o xovô buc wê xam Apumtau ob vena lec ge lêm. ");
INSERT INTO ptp_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Xam xovô bê xomxo ti wê i xumac ge obêc xovô hɨyôv manôn wê tɨbii yôdac ob val vô bucên ge od xomxo tyo ob dô bin ben ên nêb tɨbii yôdac i o dii xumac dɨ vun i susu lêm. ");
INSERT INTO ptp_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Om xam êno, xam viac xam, ên a, Xomxo Nu, a obêc vena lec buc wê xam xo ên xam nêbê a vena lecên ob ma ge. ");
INSERT INTO ptp_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Xomxo yuac letya dô wê viac i yuac nivɨha hɨxôn pɨyôp nivɨha ge? Xomxo levac wê viac nu yuac tige vɨnoo i ên nêb i viac lie yuac vɨhati dɨ vông yaên vô he tɨyi buc vɨhati. ");
INSERT INTO ptp_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Om xomxo levac tyo obêc vena lêc yê wê nu yuac tige viac yuac nivɨha ge od ob vông xêyaa nivɨha vô nu yuac tyo. ");
INSERT INTO ptp_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","A nêl vɨxôhɨlôg vô xam bê xomxo levac tyo ob vông susu vɨhati wê i vông ge vac nu yuac tige vɨgê ên nêb i viac. ");
INSERT INTO ptp_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Lêc xomxo levac obêc la dɨ nu yuac tyo obêc xo bêga nêbê, ‘Xomxo levac tyo ob vena lutibed lêm.’ ");
INSERT INTO ptp_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Nêl bêge om hi lie yuac, dɨ ya dɨ num hɨxôn tɨbii wê num mɨ vô mavmav ge. ");
INSERT INTO ptp_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Obêc vông bêge ge od xomxo levac ob vena lec buc hɨxôn hɨyôv manôn ti wê nu yuac tige xo ên nêb ob vena lec lêm ge. ");
INSERT INTO ptp_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Om xomxo levac obêc hi i vô nipaên dɨ vông i la dô vac vɨgwe nipaên hɨxôn xomxo kɨtyooên. Vac vɨgwe tige xomxo obêc byag dɨ kic nɨvu lecma.” ");
INSERT INTO ptp_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Yesu nêl vô nue ngɨvihi ên nêbê, “Buc wê a ob vena lec ge od xomxo wê nêb ob la vac Anutu ben kɨsii ganê ge he ob tɨyi xocbê vêxwo vɨgê yuu wê kô he lam mɨ la le vac môp ên nêb ob bin xomxo levac ti wê ob val ge. ");
INSERT INTO ptp_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Vêxwo vɨgê vɨlu wê pɨyôp maên, dɨ he vɨgê vɨlu wê pɨyôp nivɨha. ");
INSERT INTO ptp_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Om vêxwo vɨgê vɨlu wê pɨyôp maên ge kô he lam, lêc he o kô wel hɨxôn lêm. ");
INSERT INTO ptp_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Dɨ vêx vɨgê vɨlu wê pɨyôp nivɨha ge kô he lam dɨ kô wel hɨxôn vac butol titi. ");
INSERT INTO ptp_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","He vɨhati dô bin xomxo levac tyo, lêc valên ma, mêd he manôn yêp om he yêp. ");
INSERT INTO ptp_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Mêdêc vô vɨvuaên mahɨgun xomxo ti tyuc vya levac ên nêbê, ‘Xomxo levac tyo val. Om xam loc tulec xomxo tyo vac môp ên kô i mɨ lam.’ ");
INSERT INTO ptp_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Mêdêc vêx vɨhati kɨdi lec dɨ viac he lam, ");
INSERT INTO ptp_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","dɨ he wê pɨyôp nivɨha ge too wel vac he lam, dɨ he wê pɨyôp maên ge nêl vô he wê pɨyôp nivɨha ge ên nêbê, ‘Xam vông xe nêm wel ya ên xe too vac xe lam.’ ");
INSERT INTO ptp_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Lêc he wê pɨyôp nivɨha ge nêl i lax vô he ên nêbê, ‘Ma. Wel ga o tɨyi il xôn vɨhati lêm. Om xam loc kɨsuu nêm.’ ");
INSERT INTO ptp_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Mêdêc he wê pɨyôp maên ge loc mɨ la myag wel ên nêb ob kɨsuu nên. Mêd xomxo levac tyo val, om vêx wê viac he pyap ge la hɨxôn i mɨ he la vac xumac nɨlô dɨ la ya vɨzid levac, dɨ vuayen tung lec. ");
INSERT INTO ptp_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Lêc vêxwo vɨgê vɨlu wê pɨyôp maên ge vena tɨmuên dɨ vena tyuc ên nêbê, ‘Xomxo levac, xomxo levac, ông tax vuayen ên xe.’ ");
INSERT INTO ptp_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Lêc xomxo levac tige nêl i lax vô he ên nêbê, ‘A nêl nôn vô xam bêa lungên xam.’” ");
INSERT INTO ptp_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Yesu nêl kɨyang pɨlepacên tige pyap dêc nêl vô nue ngɨvihi ên nêbê, “Om xam dô dɨ viac xam, ên xam o xovô buc yuu hɨyôv manôn wê a obêc vena lec ge lêm. ");
INSERT INTO ptp_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Om buc wê a ob vena lec ge tɨyi xocbê xomxo levac ti wê nêb ob la vɨgwe tevabanê ge. Om nêl nue yuac lam vô i dɨ vông susu vɨhati wê i vông ge la vac he vɨgê ên nêb he i viac. ");
INSERT INTO ptp_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Xomxo levac tyo xovô yuac yuu xovôên wê nue yuac toto vông ge, om tɨtang mone vô he tɨyi bêge. Om vông K5,000 vô nu yuac ti, dɨ vông K2,000 vô ngwe dɨ vông K1,000 vô ti ên nêb yon i vông yuac lec mone tige. Pyap dêc loc mɨ la. ");
INSERT INTO ptp_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Mêdêc nu yuac ti wê kô K5,000 ge la vông yuac lec mone tige, om kô K5,000 lôm kɨtuc lec. ");
INSERT INTO ptp_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Dɨ nu yuac ti wê kô K2,000 ge la vông yuac lec mone tige, om kô K2,000 lôm kɨtuc lec. ");
INSERT INTO ptp_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Dɨ ti wê kô K1,000 ge la yev lôva mɨ lii mone la yêp vac dɨ hɨvun xôn. ");
INSERT INTO ptp_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Mêd buc dia lam la vêl, dɨ xomxo levac vena dɨ tyuc nue yuac lam vô i ên nêb ob ngô kɨyang lec yuac wê yon vông lec mone wê i vông vô yon ge. ");
INSERT INTO ptp_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Mêd nu yuac ti wê kô K5,000 ge kô mone vɨhati mɨ lam le vô xomxo levac tyo manôn dɨ nêl vô i ên nêbê, ‘Xomxo levac, ông vông K5,000 vô a, dɨ a vông yuac lec, om a kô K5,000 hɨxôn.’ ");
INSERT INTO ptp_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Mêd xomxo levac tige nêl vô i ên nêbê, ‘Ông xomxo yuac nivɨha, ên ông vô nɨnyamlehe vô a dɨ vông yuac nivɨha. Ông viac susu wê nipwo ge nivɨha om a ob vông susu tɨbeac vac ông vɨgêm ên ông viac. Om ông xêmyaa i nivɨha dɨ ông lam dô hɨxôn a.’ ");
INSERT INTO ptp_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Nang dêc nu yuac ti wê kô K2,000 ge lam le vô xomxo levac tyo manôn dɨ nêl vô i ên nêbê, ‘Xomxo levac, ông vông K2,000 vô a, dɨ a vông yuac lec, om a kô K2,000 hɨxôn.’ ");
INSERT INTO ptp_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Om xomxo levac tige nêl vô i ên nêbê, ‘Ông xomxo yuac nivɨha, ên ông vô nɨnyamlehe vô a dɨ vông yuac nivɨha. Ông viac susu wê nipwo ge nivɨha, om a ob vông susu tɨbeac vac ông vɨgêm ên ông viac. Om ông xêmyaa i nivɨha dɨ ông lam dô hɨxôn a.’ ");
INSERT INTO ptp_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Mêdêc nu yuac ti wê kô K1,000 ge lam le vô xomxo levac tyo manôn dɨ nêl vô i ên nêbê, ‘Xomxo levac, a xovô ên a nêbê ông xomxo wê ông mi keac myam pɨlihi. Dɨ yuac wê xomxo ti yev vê vac ge, ông la kô nôn vac, dɨ xomxo wê vông yuac ge od ông la kô nôn vac dɨ kô ya sola hɨxôn. ");
INSERT INTO ptp_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Om a xona ên ông dɨ a kô K1,000 wê ông vông vô a ge mɨ la yev lôva mɨ lii vac dɨ hɨvun xôn. Om ông hôm ông mone.’ ");
INSERT INTO ptp_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Lêc xomxo levac tige nêl lax vô i ên nêbê, ‘Ông xomxo yuac nipaên wê ông vô nim maên. Ông nêl ên ông nêbê a la kô nôn vac yuac wê xomxo yev vê vac ge, dɨ xomxo wê vông yuac ge od a la kô nôn vac dɨ kô ya sola hɨxôn. ");
INSERT INTO ptp_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Ông nêl bêge, lêc bêna lêc ông o kô mone a vông mɨ la lii vac xumac beng lêmê? Ên ông obêc vông bêge ge od buc wê a ob vena lec ge od a ob kô K1,000 wê a vông vô ông ge dɨ kô ya wê solaên ge hɨxôn.’ ");
INSERT INTO ptp_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Xomxo levac tyo nêl bêge, nang dêc nêl vô nue yuac ya bêga nêbê, ‘Xam vô K1,000 vêl ên xomxo yuac tige dɨ vông vô a nug yuac ngwe wê kô K5,000 pyap ge ên i kɨtuc lec. ");
INSERT INTO ptp_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Ên xomxo ti xovôên nivɨha obêc dô vô i ge od a obêc vông mangwe hɨxôn. Dɨ xomxo ti xovôên nivɨha obêc ma ge od a obêc vô xovôên wê i vông ge vêl ên i. ");
INSERT INTO ptp_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Om xam hôm xomxo yuac nipaên tige xôn dɨ nêx i loc vac vɨgwe mapɨtoc. Vac vɨgwe tige xomxo obêc byag dɨ kic nɨvu lecma.’ ");
INSERT INTO ptp_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Obêc buc tɨmuên ge Xomxo Nu ob lop mɨ lôm hɨxôn xêseac wê i vông ge dɨ angela vɨhati ob lam hɨxôn i, dɨ ob dô lec sia king dɨ yaxên xomxo nên kɨyang. ");
INSERT INTO ptp_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Vô buc tige xomxo vɨhati yang ob kɨtuc lam le vô i manôn, dɨ i ob vông he le kɨdu yuu tɨyi xocbê xomxo wê viac bwoc sipsip yuu memek ge od vɨnoo bwoc sipsip le kɨdu ngwe dɨ memek le kɨdu ngwe. ");
INSERT INTO ptp_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Om ob vông bwoc sipsip le vô vɨgê hɨyôv dɨ ob vông memek le vô vɨgê kêd. ");
INSERT INTO ptp_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Mêd xomxo levac tige ob nêl vô he wê dô vô vɨgê hɨyôv ge bêga nêbê, ‘Mag Anutu vông vɨzid nivɨha vô xam, om xam lam dô vac vɨgwe nivɨha wê Anutu nêl xam lêm lec ge. Vô buc mugên ilage wê Anutu tung lag yuu kɨbun taxlee ge, od viac vɨgwe tige pyap ên nêb ob vông vô xam. ");
INSERT INTO ptp_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Ên ilage vip den a om xam vông yaên mɨ a xa, dɨ a nêb a ob num mia om xam vông mia ningɨgooên vô a mɨ a num, dɨ a lam xocbê xomxo vɨtevac ge vô xam lêc xam viac a nivɨha, ");
INSERT INTO ptp_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","dɨ ngakwi ma ên a, om xam vông a nêg ngakwi, dɨ yidac vông a om xam vev ngwax vô a nivɨha, dɨ a la dô vac xumac kalabuhu dɨ xam lam wê a.’ ");
INSERT INTO ptp_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Om xomxo nivɨha ob nêl lax vô ên nêbê, ‘Apumtau, vô buc tina wê vip den ông om xe vông yaên mɨ ông wa? Dɨ vô buc tina wê ông nêb ông ob num mia om xe vông mia mɨ ông numê? ");
INSERT INTO ptp_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Dɨ vô buc tina wê ông lam xocbê xomxo vɨtevac ge vô xe om xe viac ông nivɨha? Dɨ vô buc tina wê ngakwi ma ên ông om xe vông ông nêm ngakwi? ");
INSERT INTO ptp_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Dɨ vô buc tina wê yidac vông ông mɨ xe vev ngwax vô ông dɨ viac ông nivɨha ge, dɨ vô buc tina wê ông la dô vac xumac kalabuhu om xe loc xê ôngê?’ ");
INSERT INTO ptp_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“Mêdêc xomxo levac tige ob nêl vô he bêga ên nêbê, ‘A nêl vɨxôhɨlôg nôn vô xam bê xam ngɨdu a lige wê lê nipwo ge xôn ya susu tibêgee, om tɨyi xocbê xam ngɨdu a xôn.’ ");
INSERT INTO ptp_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Pyap dêc obêc nêl vô he wê dô vô vɨgê kêd gee bêga nêbê, ‘Xam gee wê xam ob kô myavɨwen nipaên. Xam pec vêl ên a magnôn mɨ loc vac ngwax wê yibên obêc ma ge. Anutu viac ngwax tige pyap vô Seten he nue yuac. ");
INSERT INTO ptp_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Ên ilage vip den a lêc xam o vông yaên mɨ a xa lêm, dɨ a nêb a ob num mia lêc xam o vông mia mɨ a num lêm, ");
INSERT INTO ptp_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","dɨ a lam xocbê xomxo vɨtevac ge vô xam lêc xam o viac a nivɨha lêm, dɨ ngakwi ma ên a lêc xam o vông ngakwi vô a lêm, dɨ yidac vông a, dɨ a la dô vac xumac kalabuhu lêc xam o lam wê a lêm.’ ");
INSERT INTO ptp_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Mêd xomxo nipaên ob kɨnêg vô i ên nêbê, ‘Apumtau, vô buc tina wê vip den ông, dɨ ông nêb ông ob num mia, dɨ ông lam xocbê xomxo vɨtevac ge, dɨ ngakwi ma ên ông, dɨ yidac vông ông, dɨ ông la dô vac xumac kalabuhu, lêc xe o ngɨdu ông xôn lêmê?’ ");
INSERT INTO ptp_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“Om xomxo levac tyo obêc nêl i lax vô he bêga ên nêbê, ‘A nêl vɨxôhɨlôg nôn vô xam bê xam o ngɨdu xomxo wê lê nipwo ge xôn ya susu tibêgee lêm, om tɨyi xocbê xam o ngɨdu a xôn lêm.’ ");
INSERT INTO ptp_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Xomxo levac obêc nêl bêge, dɨ he wê nipaên ge obêc la yaxên myavɨnê levac luta lêc luta. Lêc xomxo wê nivɨha ge obêc la dô mavɨha luta lêc luta.” ");
INSERT INTO ptp_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Yesu nêl kɨyang tigee vɨhati pyap dêc nêl vô nue ngɨvihi ên nêbê, ");
INSERT INTO ptp_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Xam xovô bê buc yuu ob lam la vêl, nang dêc obêc buc Pasova, dɨ xomxo obêc vông Xomxo Nu la vac tɨbii vɨgê ên he i hi i yib lec xax pola.” ");
INSERT INTO ptp_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Mêdêc xomxo levac wê mi si daa gee hɨxôn he Yuda levac levac gee la kɨtucma vac Kaiapas ben. Kaiapas ge xomxo daa siên nên levac. ");
INSERT INTO ptp_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","He keac vôma dɨ myag môp wê nêb ob hôm Yesu xôn xôpacên dɨ hi i yib ge. ");
INSERT INTO ptp_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Lêc he nêl vôma ên nêbê, “Il ob hôm Yesu xôn lec buc ngɨbua wê il mi xovô buc Isip ilage lêm, ên xomxo tɨbeac lam dô hɨxôn om obêc yê wê il hôm Yesu xôn ge od ob yê nipaên dɨ nidɨdun levac obêc tyip.” ");
INSERT INTO ptp_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Yesu la vɨgwe Betani dɨ la dô vac Saimon ben. Saimon ge xomxo ti wê kɨtyax mahɨzihɨzi ya ninɨvi ilage lêc gwêbaga vô nivɨha lec. ");
INSERT INTO ptp_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Yesu dô mɨ ya hɨxôn i dɨ vêx ti kô butol nivɨha wê mia nivɨvea nivɨha le vac ge ti mɨ lam vô i. Mia tige mone levac, lêc vêx tige too lec Yesu bazub. ");
INSERT INTO ptp_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Lêc Yesu nue ngɨvihi yê dɨ xêyaa vô nipaên dɨ nêl vôma ên nêbê, “Bêna lêc vêx tige too mia tige sea? ");
INSERT INTO ptp_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Mia tige tɨyi wê il ob vông mɨ tɨbii i kɨsuu lec mone levac dɨ il ob vông mone vô he wê nên susu maên gee lê, lêc vêx tige too sea.” ");
INSERT INTO ptp_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Yesu xovô kɨyang wê he nêl vôma ge, om nêl vô he ên nêbê, “Bêna lêc xam vông vɨyin vô vêx tige? Môp wê vêx vông vô a ge nivɨha. ");
INSERT INTO ptp_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Ên xomxo wê nên susu maên ge ob dô hɨxôn xam luta. Lêc a ga, a ob dô xuhu dia hɨxôn xam lêm. ");
INSERT INTO ptp_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Vêx tige too mia nivɨvea lec a ên nêb ob viac a nignɨvi tax ên xomxo obêc yev a vac lôva. ");
INSERT INTO ptp_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","A nêl hɨxôn nôn vô xam bêga bê vac vɨgwe vɨhati wê xomxo obêc la nêl xolac tiga vac ge od xomxo ob nêl môp wê vêx tige vông ge kɨtong hɨxôn ên xomxo vɨhati i ngô dɨ xovô.” ");
INSERT INTO ptp_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Yesu nue ngɨvihi wê vɨgê yuu dɨ tô mɨ la yuu ge ti lê nêbê Judas Iskaliot la vô xomxo levac wê mi si daa gee, ");
INSERT INTO ptp_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","dɨ kɨnêg ên nêbê, “A obêc vông Yesu vac xam vɨgêm ge od xam ob vông vatya vô a?” Om he vông mone silva kehe ti dɨ vɨgê yuu vô i. ");
INSERT INTO ptp_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Om vô buc tige Judas myag môp wê ob vông Yesu vac he vɨgê ge. ");
INSERT INTO ptp_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Buc tigee buc ngɨbua wê he Yuda ob ya blet wê yis maên ge ên nêb ob xovô buc Isip ilage. Om vô buc ngɨbua taxlee ge Yesu nue ngɨvihi val kɨnêg vô i ên nêbê, “Ông nêb xe la viac yaên wê il ob xa lec buc Pasova ge vac xumac tina?” ");
INSERT INTO ptp_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Lêc Yesu nêl vô he ên nêbê, “Xam loc vac vɨgwe Jelusalem dɨ loc nêl vô xomxo tige bêga bê, ‘Xolac kehe nêl bêga ên nêbê, A nêg buc vô kwabo lec, om a hɨxôn nuge ngɨvihi, xe ob xa yaên vac ông bom vô buc Pasova wê il mi xovô buc Isip ilage.’” ");
INSERT INTO ptp_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Yesu nêl bêge, om nue ngɨvihi la vông i tɨyi wê i nêl ge dɨ la viac yaên wê he ob ya ge. ");
INSERT INTO ptp_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Mêdêc hɨyôv hoo la, dɨ Yesu he nue ngɨvihi vɨgê yuu dɨ tô mɨ la yuu, he dô mɨ ya, ");
INSERT INTO ptp_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","mêdêc Yesu nêl vô he ên nêbê, “A nêl vɨxôhɨlôg nôn bêga bê xam ti ob nêl a kɨtong dɨ vông a la vac tɨbii vɨgê.” ");
INSERT INTO ptp_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Om he nɨlô vô vɨyin dɨ he toto kɨnêg vô Yesu ên nêbê, “Apumtau, obêc a, me?” ");
INSERT INTO ptp_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Lêc Yesu nêl lax vô he ên nêbê, “Xomxo ti wê xii xôn vɨgêm obêc la vac dipac nɨlô ge wê ob nêl a kɨtong dɨ vông a vac tɨbii vɨgê. ");
INSERT INTO ptp_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Vɨxôhɨlôg, a Xomxo Nu, a ob xib tɨyi xocbê xolac nêl lec a ilage. Lêc xomxo ti wê ob nêl a kɨtong dɨ vông a la vac tɨbii vɨgê ge obêc kô myavɨwen nipaên lec. Ta obêc kô i ilage lêm ge od obêc vô nivɨha vô i, ên obêc tulec myavɨwen nipaên lêm!” ");
INSERT INTO ptp_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Mêdêc Judas wê ob nêl i kɨtong ge kɨnêg ên nêbê, “Xolac kehe, obêc a, me?” Om Yesu nêl lax vô i ên nêbê, “Ông nêl i tɨyi.” ");
INSERT INTO ptp_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Yesu he nue ngɨvihi dô mɨ ya, mêdêc Yesu hôm blet ti dɨ kɨtaa lec, mêdêc hɨbu dɨ vông vô he dɨ nêl ên nêbê, “Xam hôm mɨ wa. Ga a nignɨvi.” ");
INSERT INTO ptp_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Nang dêc hôm kap wê mia wain le vac ge, dɨ kɨtaa lec, dɨ vông vô he dɨ nêl ên nêbê, “Xam vɨhati hôm mɨ num, ");
INSERT INTO ptp_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","ên ga a hi wê ob vông kɨyang wê Anutu hɨlu ilage vô nôn lec. Om a obêc kɨpyax a hi sea ên i kɨtya xomxo tɨbeac nên nipaên vêl. ");
INSERT INTO ptp_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","A nêl vô xam bêga bê a obêc num mia wain ti i tii vac lêm dɨ i la tyip vô buc wê a ob num wain paha hɨxôn xam vac Mag Anutu ben ge.” ");
INSERT INTO ptp_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Pyap dêc he vông lɨlo ti dɨ la vɨxun dɨ la lec kɨtôn Oliv. ");
INSERT INTO ptp_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Mêdêc Yesu nêl vô nue ngɨvihi ên nêbê, “Vô bucên tiga xam vɨhati ob pec ên vɨyin wê ob val tulec a ge. Ên kɨyang yêp vac xolac bêga nêbê, ‘A ob hi xomxo ti wê viac bwoc sipsip ge om sipsip obêc pec dɨ moo sea.’ ");
INSERT INTO ptp_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Xolac nêl bêge, lêc a nêl vô xam bêga bê a obêc kɨdi lec magvɨha dɨ mug la Galili dɨ xam obêc tɨmu.” ");
INSERT INTO ptp_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Om Pita nêl vô Yesu ên nêbê, “He vɨhati obêc sea ông ge od he ob sea, lêc a mô ti, a ob sea ông lêm.” ");
INSERT INTO ptp_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Lêc Yesu nêl vô i ên nêbê, “A nêl vɨxôhɨlôg nôn vô ông bê vô bucên tiga ông obêc yax a vun lu yon tax dɨ kokɨlêx obêc dɨvô vya tɨmuên.” ");
INSERT INTO ptp_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Lêc Pita nêl vô i ên nêbê, “Tɨbii obêc hi a xib hɨxôn ông ge od pyap, lêc a ob yax ông vun lêm.” Dɨ nue ngɨvihi vɨhati nêl tɨyi xocbê Pita nêl ge. ");
INSERT INTO ptp_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Yesu he nue ngɨvihi loc mɨ la vɨgwe ti lê nêbê Getsemani, dɨ Yesu nêl vô nue ngɨvihi ên nêbê, “Xam dô ga ên a ob la ganê ên la kɨtaa.” ");
INSERT INTO ptp_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Mêd Yesu kô Pita hɨxôn Sebedi nu yuu mɨ he la, lêc Yesu nɨlô vô vɨyin mabu ên xovô vɨyin levac wê ob tulec i ge. ");
INSERT INTO ptp_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Om nêl vô yon ên nêbê, “A nɨlôg vô vɨyin levac tɨyi xocbê a ob xib ge. Om mon dô ga dɨ dô mamvɨha hɨxôn a.” ");
INSERT INTO ptp_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Mêd Yesu la teva tya, dɨ la kɨpôm manôn vac kɨbun dɨ kɨtaa ên nêbê, “Mag, obêc tɨyi ge od vɨyin levac tige i o lêc tulec a lêm. Lêc a nêb ông o lêc vông i tɨyi kɨyang wê a nêl ga lêm. Nge, ông vông i tɨyi xovôên wê ông vông ge.” ");
INSERT INTO ptp_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Pyap dêc Yesu mɨlax vô nue ngɨvihi yon dɨ yê wê yon yêp ge, om nêl vô Pita ên nêbê, “Bêna lêc mon wêpê? Mon o tɨyi wê mon ob dô mamvɨha hɨxôn a buc myabo tya ge lêmê? ");
INSERT INTO ptp_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Mon dô mamvɨha dɨ kɨtaa êdêc vɨyin ti i o lêc yaxên mon dɨ pwoo mon pec lêm. Ên nɨlôm nêb ob vông yuac lê, lêc nimnɨvi vô vɨyin.” ");
INSERT INTO ptp_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Nang dêc Yesu la teva tya nang dɨ la kɨtaa lu ngwe tii vac bêga ên nêbê, “Mag, ông obêc nêb vɨyin levac tiga i tulec a ge od pyap. A ob vông i tɨyi xocbê ông nêl ge.” ");
INSERT INTO ptp_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Pyap dêc vena yê wê yon manôn yêp om yon yêp ge. ");
INSERT INTO ptp_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Om Yesu sea yon dɨ lax mɨ la kɨtaa lu ti wê vông yon ge, dɨ lax kɨtaa tɨyi xocbê la kɨtaa taxlee ge. ");
INSERT INTO ptp_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Pyap dêc Yesu vena vô yon dɨ nêl vô yon ên nêbê, “Bêna lec mon dɨwêp seac vêlê? Mon wê lê, hɨyôv manôn ga wê xomxo ob vông a, Xomxo Nu, vac tɨbii nipaên vɨgê. ");
INSERT INTO ptp_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Om mon kɨdi lec ên il ob la. Wê! Xomxo ti wê ob vông a la vac tɨbii vɨgê ge val le kwabo.” ");
INSERT INTO ptp_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Yesu gên nêl kɨyang tibêge, dɨ Judas Iskaliot wê Yesu nue ngɨvihi ti ge val. Dɨ xomxo kɨdu levac wê hôm yipac yuu xax gee val hɨxôn, ên xomxo levac wê mi si daa gee hɨxôn he Yuda levac levac vông he lam hɨxôn Judas. ");
INSERT INTO ptp_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Om Judas wê nêb ob vông Yesu vac tɨbii vɨgê ge nêl kɨyang vô he tax ên nêbê, “Xomxo ti wê a ob nga i lia ge, ge xomxo tyo tige mê. Om xam hôm i xôn.” ");
INSERT INTO ptp_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Nêl bêge, mêdêc lutibed val vô Yesu dɨ nêl vô i ên nêbê, “Bucên xolac keheê” dɨ nga i lia. ");
INSERT INTO ptp_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Mêd Yesu nêl vô i ên nêbê, “Lig, môp wê ông lam ên nêb ông ob vông ge, ông vông lutibed.” Mêd xomxo kɨdu levac lam hôm Yesu xôn pɨlihi. ");
INSERT INTO ptp_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Lêc xomxo wê dô hɨxôn Yesu ge ti tul yipac vêl ên bwoc ninɨvi dɨ sap xomxo levac wê mi si daa ge nue yuac ti nɨnya lihi vɨlu la vêl. ");
INSERT INTO ptp_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Lêc Yesu nêl vô i ên nêbê, “Hoo yipac i lôc vac bwoc ninɨvi. Ên he wê vông vevac mɨ hi xomxo ge, vevac obêc tulec he mɨ hi he yib. ");
INSERT INTO ptp_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Lêc mêd ông xo ên ông nêb a tɨyiên ma wê a obêc kɨtaa vô Mag dɨ i vông angela tɨbeac hɨwocên luu xomxo vevac kɨdu levac vɨgê yuu dɨ tô mɨ la yuu vêl ge lam lutibed vô a ên he i lam ngɨdu a xôn. ");
INSERT INTO ptp_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Lêc a obêc vông bêge ge od kɨyang wê yêp vac xolac ge obêc vô nôn lec tibêna? Ên xolac nêl ên nêbê vɨyin levac obêc tulec a.” ");
INSERT INTO ptp_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Mêd Yesu nêl vô xomxo kɨdu levac tige bêga ên nêbê, “Xam kô yipac yuu xax dɨ val vô a tɨyi xocbê xam lam vô tɨbii yôdac ti. Lêc tɨyi buc vɨhati a mi dô hɨxôn xam vac Anutu xumac ngɨbua dɨ a nêl xolac vô xam, lêc xam o hôm a xôn lêm. ");
INSERT INTO ptp_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Lêc môp wê xam vông vô a gwêbaga ge vông xolac wê plopete kɨvuu ilage vô nôn lec.” Yesu nêl kɨyang tige pyap dɨ nue ngɨvihi pec mɨ moo sea. ");
INSERT INTO ptp_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Mêd he wê hôm Yesu xôn gee dɨdii i mɨ la vac Kaiapas ben. Kaiapas ge xomxo daa siên nên levac. Xomxo levac wê xovô Moses xolac ge hɨxôn he Yuda levac levac, he la kɨtucma mɨ dô tax. ");
INSERT INTO ptp_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Mêdêc Pita tɨmu vô Yesu vɨxa mɨ la, lêc le la teva teva, om mɨla vac xenac nɨlô wê Kaiapas ben yêp vac ge mɨ la dô hɨxôn Kaiapas nue yuac wê viac vɨgwe ge ên nêb ob yê bê xomxo ob vông bêna vô Yesu. ");
INSERT INTO ptp_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Mêd xomxo levac wê mi si daa gee hɨxôn he kaunsil vɨhati, he myag tɨbii wê ob vô nɨlô vô Yesu ge, ên he nêb he ob hi i yib. ");
INSERT INTO ptp_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Mêd tɨbii tɨbeac val so kɨyang lec Yesu, lêc he Yuda levac levac gee o tulec kɨyang ti tɨyi wê ob hi Yesu lec ge lêm. Nang dêc tɨmuên ge xomxo yuu val ");
INSERT INTO ptp_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","nêl ên nêbê, “Xomxo tige nêl bêga nêbê, ‘A tɨyi wê a ob dii Anutu xumac ngɨbua tiga vêl dɨ lox vac i tɨyi buc yon.’” ");
INSERT INTO ptp_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Om xomxo daa siên nên levac tige kɨdi lec dɨ nêl vô Yesu ên nêbê, “Ông ob nêl kɨyang ti lax vô he, me? Ông xovô kɨyang nipaên wê he nêl lec ông ge kehe, me?” ");
INSERT INTO ptp_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Lêc Yesu keacên ma. Mêdêc xomxo levac tige nêl vô i ên nêbê, “A nêl vô ông lec Anutu mavɨha lê bê ông nêl ông kɨtong vô xe bê ông Kɨlisi wê Anutu nu ge, me?” ");
INSERT INTO ptp_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Om Yesu nêl vô i ên nêbê, “Ông nêl i tɨyi. Lêc a nêl vô xam bêga bê obêc buc tɨmuên ge od xam ob wê a, Xomxo Nu, a obêc la dô vô Anutu xêkɨzêc kehe vɨgê hɨyôv, dɨ dô vac vɨyobtoc lag puunê dɨ lam.” ");
INSERT INTO ptp_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Mêd xomxo daa siên nên levac tige xêyaa vô myavɨnê, om lêx ici va ngakwi dɨ nêl ên nêbê, “Xomxo tige so vya vô Anutu ên nêbê Anutu nu i. Om il ob nêl xomxo ya i lam nêl kɨyang ti lec i i tii vac lêm. Ên ici va so vya vô Anutu mɨ xam ngô pyap. ");
INSERT INTO ptp_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Om xam nêb il ob vô bêna vô i?” Mêdêc he vɨhati nêl lax vô i ên nêbê, “Xomxo tige nêl nipaên tɨyi wê il ob hi i yib lec ge.” ");
INSERT INTO ptp_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Mêd he pɨsuv myaluc la vac Yesu manôn, dɨ he ya lun vɨgê dɨ hi i, dɨ ya pɨtap i manôn ya vɨgê, ");
INSERT INTO ptp_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","dɨ nêl vô i ên nêbê, “Ông nêl ên ông nêbê ông Kɨlisi, om nêl xomxo ti wê hi ông ge lê mɨ xe ngô.” ");
INSERT INTO ptp_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Pita dô vɨxun vac xenac nɨlô wê Kaiapas ben yêp vac ge, lêc dô kɨbun, mêd vêx yuac ti val nêl vô i ên nêbê, “Ông ga wê ông mi dô hɨxôn Yesu wê ben Galili ge ti mêê.” ");
INSERT INTO ptp_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Lêc Pita yax Yesu vun vô he vɨhati manôn dɨ nêl ên nêbê, “A lungên kɨyang wê ông nêl ge kehe.” ");
INSERT INTO ptp_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Nang dêc Pita kɨdi mɨ la dô xenac kehe kwabo vô vuayen, dɨ vêx yuac ngwe yê dɨ nêl vô tɨbii wê dɨle kwabo ge ên nêbê, “Xomxo tige wê mi dô hɨxôn Yesu Nasalet.” ");
INSERT INTO ptp_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Lêc Pita yax Yesu vun tii vac nang ên nêbê, “A nêl vɨxôhɨlôg nôn bê a o xovô xomxo tige lêm.” ");
INSERT INTO ptp_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","He dô mahɨgun dia tya dɨ tɨbii ya val nêl vô Pita ên nêbê, “Vɨxôhɨlôg, xe xovô ên xe nêbê ông ge Yesu nue ngɨvihi ti, ên ông mi keac vac tɨbii Galili vya om nêl kɨtong ên nêb ông ge ông xomxo Galili ti tɨyi xocbê Yesu ge.” ");
INSERT INTO ptp_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Lêc Pita nêl ên nêbê, “A obêc nêl kɨyang nôn lêm ge od Anutu i vông myavɨwen nipaên vô a. Om a nêl vɨxôhɨlôg bê a o xovô xomxo tige lêm.” Pita nêl kɨyang tige mɨ tɨyôô dɨ kokɨlêx hi vya. ");
INSERT INTO ptp_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Mêd Pita xovô kɨyang wê Yesu nêl vô i bêga nêbê, “Ông obêc yax a vun lu yon tax dɨ kokɨlêx obêc hi vya tɨmuên.” Pita xovô kɨyang tige om lop mɨ la xenac kehe dɨ la byag levac. ");
INSERT INTO ptp_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Vɨgwe vɨdii, dɨ xomxo levac wê mi si daa gee hɨxôn he Yuda levac levac, he vɨhati kɨtucma dɨ keac lec kɨyang wê ob hi Yesu i yib lec ge. ");
INSERT INTO ptp_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Om he ku Yesu xôn dɨ kô mɨ la vông vac gavman levac Pailat vɨgê. ");
INSERT INTO ptp_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Judas Iskaliot wê vông Yesu vac tɨbii vɨgê ge yê wê he nêb he ob hi Yesu i yib ge. Om nɨlô vô vɨyin ên môp nipaên wê i vông ge, om kô mone silva kehe ti dɨ vɨgê yuu mɨ la ên nêb ob tung i lax dô vô xomxo levac wê mi si daa gee hɨxôn he Yuda levac levac. ");
INSERT INTO ptp_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Om la nêl vô he ên nêbê, “A nêg nipaên, ên a vông xomxo ti wê nipaên ti o yêp vô i lêm ge loc vac xam vɨgêm dɨ xam ob hi i yib.” Lêc he nêl vô i ên nêbê, “Xe kɨyang ti o yêp vô xe lêm. Nge, ge yêp vô ôcông va.” ");
INSERT INTO ptp_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Mêd Judas nêx mone silva tige la lec kɨbun vac Anutu xumac ngɨbua nɨlô dɨ lop mɨ la dɨ la ku kwa dɨ yib. ");
INSERT INTO ptp_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Mêd xomxo levac wê mi si daa gee la hôm mone silva tigee mɨ kô, dɨ nêl vôma ên nêbê, “Mone tiga wê hi xomxo yib ge, om o tɨyi wê il ob tung hɨxôn mone daa ge lêm.” ");
INSERT INTO ptp_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Om he keac vôma dɨ hɨlu kɨyang ên nêb ob kô mone mɨ la kɨsuu kɨbun vô tɨbii wê pɨtii dêg ge ên nêb kɨbun tige i tu vɨgwe yibên wê he ob yev tɨbii vɨgwe teva vac ge. ");
INSERT INTO ptp_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Mêgem he nêl kɨbun tige lê nêbê kɨbun wê xomxo hi kɨpyax lec ge, dɨ lê tige yêp gwêbaga hɨxôn. ");
INSERT INTO ptp_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Om kɨyang wê plopete Jelemaia nêl ilage vô nôn lec. Jelemaia nêl bêga ên nêbê, “He kô mone silva kehe ti dɨ vɨgê yuu tige. He Islel nêl ên nêbê mone tige wê he kɨsuu xomxo ti ya. ");
INSERT INTO ptp_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","He kô mone tige mɨ la kɨsuu kɨbun vô tɨbii wê pɨtii dêg ge tɨyi xocbê Apumtau nêl vô a ge.” ");
INSERT INTO ptp_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","He vông Yesu la le vô gavman levac Pailat manôn, dɨ gavman levac tige kɨnêg vô i ên nêbê, “Ông ge king wê he Yuda vông ge, me?” Om Yesu lee yuu ên nêbê, “Ông nêl i tɨyi.” ");
INSERT INTO ptp_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Dɨ xomxo levac wê mi si daa gee hɨxôn he Yuda levac levac vô nɨlô vô Yesu, lêc Yesu o nêl kɨyang ti lax vô he lêm. ");
INSERT INTO ptp_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Mêdêc Pailat nêl vô i ên nêbê, “Ông ngô kɨyang tɨbeac wê he vô nɨlô vô ông ge, me?” ");
INSERT INTO ptp_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Lêc Yesu o keac ti lec kɨyang nipaên wê he nêl lec i ge lêm. Om gavman levac tige xo kɨyang tɨbeac lec Yesu. ");
INSERT INTO ptp_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Tɨyi klismas vɨhati vô buc ngɨbua wê he Yuda mi xovô buc Isip ilage, he Yuda mi nêl xomxo kalabuhu ti lê vô Pailat dɨ Pailat pɨwelac i vêl dɨ vông i la. ");
INSERT INTO ptp_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Dɨ vô buc tige xomxo nipaên ti lê nêbê Jisas Balabas dô vac xumac kalabuhu. Xomxo tɨbeac xovô i ên nêbê xomxo nipaên. ");
INSERT INTO ptp_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Xomxo Yuda tɨbeac hɨwocên kɨtucma vô Pailat, dɨ Pailat kɨnêg ên nêbê, “Xam nêb a pɨwelac xomxo yuu ga ngwe na i loc vô xamê? Xam nêb a pɨwelac Balabas me a pɨwelac Yesu wê he mi nêl lê nêbê Kɨlisi ge?” ");
INSERT INTO ptp_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Pailat xovô ên nêbê he Yuda levac yê Yesu nipaên, om vông i lam vac i vɨgê. ");
INSERT INTO ptp_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Pailat dô lec sia wê mi dô lec dɨ mi ngô xomxo kɨyang ge, mêdêc vɨnê vông kɨyang lam vô i bêga nêbê, “Ông o lêc vông xomxo nivɨha tige i vô nipaên lêm, ên gwêbaga a xê vɨvia bucên ti lec i om vông a nɨlôg vô vɨyin.” ");
INSERT INTO ptp_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Xomxo levac wê mi si daa gee hɨxôn he Yuda levac levac gee, he nêl kɨyang la vac xomxo tɨbeac nɨlô dɨ he hôm xôn nêbê he ob tyuc bê Pailat i pɨwelac Balabas vêl dɨ hi Yesu i yib. ");
INSERT INTO ptp_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Pailat kɨnêg vô he tii vac nang ên nêbê, “Xam nêb a pɨwelac xomxo yuu ga ngwe na vêl dɨ vông i lôc vô xamê?” Lêc he nêl ên nêbê, “Balabas.” ");
INSERT INTO ptp_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Om Pailat kɨnêg vô he ên nêbê, “Om Yesu wê he mi nêl lê nêbê Kɨlisi ge, a ob vông bêna vô i?” Lêc he vɨhati nêl ên nêbê, “Tul i lec xax pola!” ");
INSERT INTO ptp_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Lêc Pailat kɨnêg ên nêbê, “Il ob hi i yib lec kehe tina?” Lêc he tyuc levac ên nêbê “Tul i lec xax pola!” ");
INSERT INTO ptp_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pailat xovô wê he ngôên i kɨyang obêc ma ge, dɨ yaxên wê he obêc vông vevac vô i ge, om hôm mia dɨ lipac vɨgê vac mia vô he vɨhati manôn, dɨ nêl vô he ên nêbê, “Xomxo tiga hi obêc kɨpyax sea ge od myavɨwen obêc yêp vô a lêm. Nge, obêc yêp vô xacxam va.” ");
INSERT INTO ptp_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Mêd he vɨhati nêl lax vô i ên nêbê, “Myavɨwen tige i lam vô xe dɨ i yêp vô xe nuge hɨxôn!” ");
INSERT INTO ptp_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Om Pailat pɨwelac Balabas vêl dɨ vông i la, dɨ nêl om he pɨsa Yesu ya yihi. Pyap dêc Pailat vông i la vac nue vevac vɨgê ên nêb he i tul i lec xax. ");
INSERT INTO ptp_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Mêd gavman levac Pailat nue vevac kô Yesu mɨ la vac Pailat ben, dɨ he keac lie vevac kɨdu levac lam. ");
INSERT INTO ptp_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Mêd he lam kwax Yesu ngakwi vêl ên i, dɨ kô ngakwi hi ti tɨyi xocbê king mi vɨnyum ge mɨ la vɨnyum lec Yesu, ");
INSERT INTO ptp_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","dɨ he buu kɨpomac yin mɨ tung lec i bazub xocbê kɨlung ge, dɨ vông duvac ti vac i vɨgê hɨyôv ên nêb i kô. Mêd he yev vɨxa kɨtu vô dɨ pɨmil i pɨsiv dɨ nêl vô iên nêbê, “O king wê Yuda vông ge, ông dô nimvɨha.” ");
INSERT INTO ptp_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Mêd he pɨsuv myaluc lec i, dɨ vô duvac vêl dɨ hi i bazub ya. ");
INSERT INTO ptp_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","He so vya vô i pyap, dɨ kwax ngakwi hi vêl dɨ vɨnyum Yesu vaci ngakwi lec i, mêdêc kô i mɨ la ên nêb ob la tul i lec xax. ");
INSERT INTO ptp_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Dɨ he mɨla môp ti, lêc mɨla tulec tɨbii Sailini ti lê nêbê Saimon, mêdêc he kɨdu i nêb i kɨlê xax pola wê he ob hi Yesu lec ge. ");
INSERT INTO ptp_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Mêd he mɨla vɨgwe ti lê nêbê Golgota. Lê tige kehe bêga nêbê bazub len. ");
INSERT INTO ptp_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Mêdêc he pɨlepac kɨning kɨlin hɨxôn wain dɨ vông vô Yesu ên nêb i num, om Yesu tep mɨ yaxên lê, lêc nêbê i numên ob ma. ");
INSERT INTO ptp_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Mêd he tul i lec pola. Pyap dêc he nêb he ob tɨtang Yesu ngakwi vôma, om he tɨde mɨ yê dɨ tɨtang i tɨyi. ");
INSERT INTO ptp_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Dɨ he dô kɨbun dɨ dô bin i. ");
INSERT INTO ptp_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Dɨ he kɨvuu kɨyang wê he nêl lec i ge dɨ la tul vô i bazub kɨsii ên nêbê, “XOMXO TIGA YESU, KING WÊ HE YUDA VÔNG GE.” ");
INSERT INTO ptp_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Mêd he hi tɨbii yôdac yuu lec xax hɨxôn, ngwe le vô vɨgê hɨyôv dɨ ngwe le vô vɨgê kêd. ");
INSERT INTO ptp_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Mêd xomxo wê vɨlee mɨ la dɨ lôm ge tɨpi nɨba dɨ so vya vô Yesu ");
INSERT INTO ptp_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","ên nêbê, “Ông wê ông nêb ông ob dii Anutu xumac ngɨbua vêl dɨ lox vac i tɨyi buc yon ge, ông ngɨdu ôcông va xôn. Ông obêc Anutu nu ge od ông lop mɨ lam vêl ên xax.” ");
INSERT INTO ptp_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Mêd xomxo levac wê mi si daa gee hɨxôn he wê xovô Moses xolac gee dɨ he Yuda levac levac, he êno so vya vô Yesu dɨ nêl vôma ên nêbê, ");
INSERT INTO ptp_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Xomxo tige ngɨdu xomxo tɨbeac xôn, lêc o tɨyi wê ob ngɨdu ici va xôn ge lêm. Xomxo tige obêc Islel nên king ge od i lop vêl ên xax ên il xê dɨ vông i vin i. ");
INSERT INTO ptp_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Xomxo tige nêbê i Anutu nu, dɨ i vông i vin ên nêbê Anutu ob ngɨdu i xôn. Om Anutu xêyaa obêc vin lec i ge od i vô i vêl ên myavɨnê wê tulec i ge.” ");
INSERT INTO ptp_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","He nêl bêge, dɨ tɨbii yôdac yuu wê he tul lec xax hɨxôn Yesu ge, yuu so vya vô Yesu hɨxôn. ");
INSERT INTO ptp_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Hɨyôv tyip kɨtôn mêd vɨgwe vɨhati vô mapɨtoc dɨ i mɨla vô hɨyôv manôn yon wê hucên ge. ");
INSERT INTO ptp_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Vô kwabo lec hɨyôv manôn yon, Yesu tyuc vya levac ên nêbê, “Eli, eli, lama sabaktani?” Kɨyang tige kehe bêga nêbê, “A Anutu, a Anutu, bêna lêc ông sea a?” ");
INSERT INTO ptp_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Mêdêc xomxo wê le kwabo vô Yesu ge ngô kɨyang wê i nêl ge, om he ya so ên he nêbê, “Xomxo tige kɨyag vya lec Ilaija.” ");
INSERT INTO ptp_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Mêd lutibed he ti tup mɨ la kô mia myamɨlumac dɨ too mia kɨlin vac dɨ kɨlax vac ngɨsing dɨ hôm i la kɨsii vô Yesu mya ên nêb i num. ");
INSERT INTO ptp_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Lêc he ya nêl vô i ên nêbê, “Dô tya lê, ên il ob dô mɨ yaxên bê Ilaija ob val ngɨdu i xôn, me?” ");
INSERT INTO ptp_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Lêc Yesu tyuc vya levac tii vac dɨ vông myakɨlôhô la dɨ yib. ");
INSERT INTO ptp_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Mêd lutibed nivɨmihi levac ti wê yux vac Anutu xumac ngɨbua ge lêx la yuu vac kɨsii dɨ la tô vô myahɨpu, dɨ ngɨyêg yoc, dɨ ngɨdax levac hɨbu sea, ");
INSERT INTO ptp_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","dɨ lôva mya tax, dɨ xomxo vông vinên wê yib ilage, he tɨbeac kɨdi lec hɨxôn ninɨvi ");
INSERT INTO ptp_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","dɨ lam vac lôva mɨ la, dɨ buc tɨmuên wê Yesu kɨdi lec ge he la hɨlung he vô xomxo tɨbeac vac vɨgwe ngɨbua Jelusalem. ");
INSERT INTO ptp_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Yesu yib, dɨ tɨbii levac wê viac nue vevac 100 ge ti hɨxôn nue vevac ya dô bin Yesu wê yux lec xax ge, dɨ he yê wê ngɨyêg vông kɨbun yoc dɨ tɨxuu tɨxuu mangwe val hɨxôn, om he xona mabu dɨ nêl ên nêbê, “Vɨxôhɨlôg nôn, xomxo tige Anutu nu.” ");
INSERT INTO ptp_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Vêx tɨbeac le teva dɨ yê ma la Yesu. Vô buc wê Yesu dô Galili ge vêx tigee mi tɨmu vô i vɨxa dɨ viac i mɨ he la Jelusalem. ");
INSERT INTO ptp_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","He ti Malia wê ben Makdala ge, dɨ ngwe Jems yuu Josep ta Malia, dɨ ti Sebedi nu yuu ta. ");
INSERT INTO ptp_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Vɨgwe huc, dɨ xomxo Alimatia ti lê nêbê Josep wê vông i vin Yesu ge val. Josep ge xomxo wê i susu tɨbeac ge. ");
INSERT INTO ptp_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Josep la vô Pailat dɨ la kɨtaa Yesu ninɨvi nêb ob kô mɨ la lii vac lôva. Om Pailat tyuc lec dɨ he vông Yesu ninɨvi vô Josep. ");
INSERT INTO ptp_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Mêd Josep kô Yesu ninɨvi mɨ la lii vac nivɨmihi kwem paha yang ti ");
INSERT INTO ptp_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","mɨ la lii i la vac lôva paha wê i vông wê ici va kɨden vac ngɨdax ge. Pyap dêc vɨxog ngɨdax levac ti la le vac lôva mya xôn, dɨ i loc mɨ la. ");
INSERT INTO ptp_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Malia Makdala yuu Malia ngwe, yuu dô kwabo vô lôva dɨ yuu yê. ");
INSERT INTO ptp_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Buc wê he Yuda mi viac yaên wê he ob ya lec buc sabat ge lam la vêl, dɨ tɨtige xomxo levac wê me si daa gee hɨxôn he Palisi, he la kɨtucma vô Pailat, ");
INSERT INTO ptp_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","dɨ nêl vô i ên nêbê, “Xomxo levac, xe xovô kɨyang wê xomxo kɨtyooên tige nêl vô buc wê gên dô mavɨha ge. Xomxo tyo nêl bêga ên nêbê, ‘Buc yon obêc lam la vêl lê, lêc a obêc kɨdi lec magvɨha.’ ");
INSERT INTO ptp_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Nêl bêge, om ông nêl ên nume vevac he i viac lôva xêkɨzêc ta i tɨyi buc yon, ên Yesu nue ngɨvihi ob lam kô ninɨvi mɨ la vun dɨ kɨtyoo il ên nêbê Yesu kɨdi lec mavɨha vac yibên. He obêc vông bêge ge od kɨyang kɨtyooên wê he ob nêl ge obêc luu kɨyang kɨtyooên wê Yesu nêl ge vêl.” ");
INSERT INTO ptp_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Mêdêc Pailat nêl vô he ên nêbê, “Xam kô nume yuac mɨ loc pɨtii ngɨdax mya xôn ên i vô xêkɨzêc i tɨyi xocbê xacxam va xovô ge.” ");
INSERT INTO ptp_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Om he mɨla pɨtii lôva mya xôn dɨ vông vɨbuên xêkɨzêc ta dɨ xomxo le bin. ");
INSERT INTO ptp_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Buc sabat lam la vêl dɨ da pɨtoc yang, dêc Malia Makdala yuu Malia ngwe, yuu la ên nêb ob la yê lôva. ");
INSERT INTO ptp_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Mêdêc lutibed ngɨyêg mabu yoc, ên Apumtau nu angela ti lop mɨ lam gê lag puunê dɨ lam vɨxog ngɨdax la vêl ên lôva mya, dɨ la dô lec ngɨdax tige kɨsii. ");
INSERT INTO ptp_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Angela tige manôn xêseac tɨyi xocbê deac hɨxelac ge, dɨ ngakwi tɨyi xocbê vɨyobtoc kwem. ");
INSERT INTO ptp_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Om xomxo wê viac lôva gee yê dɨ xona mabu dɨ yetac dɨ tɨlii sea mɨ la yêp kɨbun tɨyi xocbê xomxo yibên. ");
INSERT INTO ptp_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Lêc angela tige nêl vô vêx yuu ên nêbê, “Muu xona ên i ma, ên a xovô wê muu myag Yesu wê he hi lec xax ge. ");
INSERT INTO ptp_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Lêc o dô ga lêm, ên kɨdi lec mavɨha tɨyi xocbê kɨyang wê i nêl ge. Muu lam wê vɨgwe wê yêp lec ge. ");
INSERT INTO ptp_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Om muu lôc lutibed dɨ lôc nêl kɨtong vô nue ngɨvihi bêga bê Yesu kɨdi lec mavɨha vac yibên, dɨ ob mug mɨ la Galili dɨ xam ob mɨla wê i gê tiganê. Kɨyang ga a nêl vô muu pyap.” ");
INSERT INTO ptp_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Yuu xona mabu, lêc yuu xêyaa vô nivɨha, dɨ yuu sea lôva lutibed dɨ tup mɨ la ên nêb ob la nêl kɨyang tige kɨtong vô Yesu nue ngɨvihi. ");
INSERT INTO ptp_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Yuu lax mɨ la, lêc Yesu mɨla vô yuu vac môp dɨ nêl vɨdiiên vô yuu. Om yuu val le kwabo vô Yesu dɨ vyax vɨgê lec Yesu vɨxa dɨ pɨmil i. ");
INSERT INTO ptp_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Mêdêc Yesu nêl vô yuu ên nêbê, “Muu xona ên i ma. Muu loc nêl kɨyang vô a lige bê he i loc Galili, ên he obêc yê a gê ganê.” ");
INSERT INTO ptp_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Om vêx yuu ge gên loc môp, lêc tɨbii vevac wê viac lôva gee ya la Jelusalem dɨ la nêl kɨyang tige vɨhati kɨtong vô xomxo levac wê mi si daa gee. ");
INSERT INTO ptp_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Om xomxo levac tigee la kɨtucma hɨxôn he Yuda levac, dɨ he keac lec kɨyang tige. Om vông mone levac vô tɨbii vevac wê viac lôva ge, ");
INSERT INTO ptp_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","dɨ nêl vô he ên nêbê, “Xam loc nêl vô xomxo bê, ‘Vô bucên xe xêp dɨ Yesu nue ngɨvihi lam kô ninɨvi mɨ la vun.’ ");
INSERT INTO ptp_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Xam loc nêl bêge, lêc gavman levac obêc ngô kɨyang tige dɨ kunac xam ge od xe ob vông i ma i tô ya kɨyang malehe mangwe dɨ ob kunac xam lêm.” ");
INSERT INTO ptp_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Om tɨbii vevac tigee kô mone mɨ la nêl kɨyang kɨtyooên tɨyi xocbê Yuda levac nêl vô he ge. Om kɨyang kɨtyooên tige la nêx lec Yuda ben vɨhati mɨ yêp, dɨ yêp gwêbaga hɨxôn. ");
INSERT INTO ptp_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Yesu nue ngɨvihi vɨgê yuu dɨ ti tô mɨ la ge, he loc mɨ la vɨgwe Galili mɨ la lec kɨtôn ti wê Yesu nêl ên nêbê he i lêc loc dô lec ge. ");
INSERT INTO ptp_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Om he mɨla tyip, dɨ yê Yesu om he yev vɨxa kɨtu vô i, lêc he ya nɨlô vông yuu yuu. ");
INSERT INTO ptp_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Mêdêc Yesu lam kwabo vô he dɨ lam nêl vô he ên nêbê, “Anutu vông xêkɨzêc lag yuu kɨbun vɨhati vô a pyap. ");
INSERT INTO ptp_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Om a nêl vô xam bê xam loc vac vɨgwe vɨhati yang dɨ loc nêl a xolac kɨtong vô xomxo vɨhati ên he i vông i vin dɨ tu a nuge. Dɨ xam loc lipac he lec Mag Anutu hɨxôn nu tuc dɨ Myakɨlôhô Ngɨbua yon lê. ");
INSERT INTO ptp_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Dɨ xam tɨxuu he ya kɨyang vɨhati wê a nêl vô xam ge ên he i tɨmu vô. Xam ngô lê. A obêc dô hɨxôn xam i tɨyi buc vɨhati dɨ i loc tyip lec buc wê lag yuu kɨbun myahɨpu obêc tɨyôô vac ge.” ");
INSERT INTO ptp_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Kɨyang tiga, xolac nivɨha wê nêl Yesu Kɨlisi wê Anutu nu ge kɨtong. ");
INSERT INTO ptp_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Xolac tiga, plopet Aisaia nêl kɨtong mugên ilage, om Anutu vya wê Aisaia kɨvuu ge yêp bêga nêbê, “Ngô lê. A ob vông xomxo ti i kô a kɨyang mɨ loc mug ông nêm môp, ên i viac môp wê ông obêc mɨla vac ge. ");
INSERT INTO ptp_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Om xomxo tige obêc tyuc vya vac vɨgwe mahɨgun pɨleva bêga nêbê, ‘Xam viac Apumtau môp wê ob lam vac ge dɨ vông i môp i yêp bôbac.’” ");
INSERT INTO ptp_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Kɨyang nêl bêge, mêgem Jon Lipacên la vac vɨgwe mahɨgun pɨleva dɨ la nêl xolac vô xomxo ên nêbê he i pɨlepac he dɨ lipac mia êdêc Anutu i kɨtya he nên nipaên vêl. ");
INSERT INTO ptp_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Om xomxo Jelusalem hɨxôn xomxo vac vɨgwe levac Judia vɨhati la vô Jon dɨ nêl he nên nipaên kɨtong vô i, om he la le vac mia Jodan dɨ Jon lipac he. ");
INSERT INTO ptp_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Jon vɨnyum ngakwi wê he duu bwoc kamel nivɨluhu ge dɨ vêx let wê bwoc ninɨvi ge, dɨ yaên wê mi ya ge, hɨveac hɨxôn vɨnoluc. ");
INSERT INTO ptp_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Mêd Jon nêl xolac vô xomxo bêga ên nêbê, “Xomxo ti obêc val tɨmuên, lêc xêkɨzêc wê i vông ge luu xêkɨzêc wê a vông ge vêl, dɨ a o nigvɨha tɨyi wê a ob pɨwelac yihi vêl ên su wê i vông ge lêm. ");
INSERT INTO ptp_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","A ga, a lipac xam ya mia pɨleva, lêc xomxo tige obêc lipac xam ya Myakɨlôhô Ngɨbua.” ");
INSERT INTO ptp_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Vô buc tigee Yesu sea ben Nasalet wê yêp vac vɨgwe levac Galili ge dɨ la vô Jon Lipacên dɨ Jon lipac i vac mia Jodan. ");
INSERT INTO ptp_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Lipac i pyap dɨ Yesu lec mɨ lôm kehe, lêc lutibed Yesu yê wê lag puunê tax dɨ Myakɨlôhô Ngɨbua tu tucluu manôn dɨ lam yêp lec i kɨsii. ");
INSERT INTO ptp_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Mêd vya ti lam hɨxôn gê lag puunê ên nêbê, “Ông a nug wê a xêgyaa vin lec ông dɨ a xê ông nivɨha ge.” ");
INSERT INTO ptp_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Mêd lutibed Myakɨlôhô Ngɨbua vông Yesu la vac vɨgwe mahɨgun pɨleva wê xomxo ti dô vacên ma ge, ");
INSERT INTO ptp_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","dɨ Yesu la dô tɨyi xocbê buc kehe yuu dɨ Seten yaxên i. Vɨgwe tige, bwoc mavɨhô dô hɨxôn, lêc angela lam viac Yesu. ");
INSERT INTO ptp_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Tɨbii tung Jon Lipacên la dô vac xumac kalabuhu, pyap dêc Yesu la vac vɨgwe levac Galili dɨ la nêl Anutu xolac vô xomxo ên nêbê, ");
INSERT INTO ptp_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","“Gwêbaga buc wê Anutu nêl ge ob vô nôn lec, dɨ vɨgwe kɨsiinê nu vô kwabo lec. Om xam pɨlepac xam dɨ vông i vin xolac.” ");
INSERT INTO ptp_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Yesu mɨla vô mia luaên Galili nɨnya lêc yê wê Saimon yuu li Andlu nêx leac vac mia luaên tige nêb ob hi pis, ên yuu ge, yuu mi vông yuac mone lec pis hiên. ");
INSERT INTO ptp_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Om Yesu nêl vô yuu ên nêbê, “Muu lam tɨmu vô a vɨxag, ên a ob vông muu dɨdii xomxo mɨ lam vô a i tɨyi xocbê muu dɨdii pis vac leac ge.” ");
INSERT INTO ptp_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Om lutibed yuu sea leac dô xel dɨ la hɨxôn Yesu. ");
INSERT INTO ptp_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Mêd yon sea vɨgwe ge dɨ la teva tya, lêc mɨla yê Sebedi nu yuu, Jems yuu Jon wê yuu dô lec dipac dɨ duu yuu leac wê tip sea ge xôn. ");
INSERT INTO ptp_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Mêd Yesu keac yuu lam om yuu sea ma Sebedi hɨxôn nue yuac he dô lec dipac dɨ yuu la hɨxôn Yesu. ");
INSERT INTO ptp_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","He la dô vac vɨgwe Kapaneam, dêc buc wê sabat ge od Yesu la vac he xumac lɨlo dɨ la nêl xolac vô xomxo. ");
INSERT INTO ptp_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Mêd xomxo tigee yetac ên kɨyang wê Yesu nêl vô he ge, ên Yesu o tɨxuu he tɨyi xocbê xomxo wê xovô Moses xolac ge lêm. Nge, Yesu nêl kɨyang hɨxôn xêkɨzêc. ");
INSERT INTO ptp_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Xomxo ti wê vɨmwo nipaên dô vac nɨlô ge dô hɨxôn he vac xumac lɨlo tige, om keac vya levac ên nêbê, ");
INSERT INTO ptp_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Yesu Nasalet, ông lam ên ông nêb ông ob vông bêna vô xe? Ông nêb ông ob kɨtya xe vêl, me? A xovô ông ên a nêbê ông ge xomxo ngɨbua wê Anutu vông ông lam ge.” ");
INSERT INTO ptp_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Lêc Yesu nêl kɨyang xêkɨzêc la vô i ên nêbê, “Keacên i ma, dɨ lam loc vêl ên xomxo tige.” ");
INSERT INTO ptp_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Mêgem vɨmwo nipaên tige vô kɨtiv kɨtiv xomxo tige dɨ tyuc vya levac dɨ sea i dɨ la. ");
INSERT INTO ptp_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Mêd xomxo wê dô mɨ yê gee yetac mabu dɨ nêl vôma ên nêbê, “Xomxo tige va nêl kɨyang bêna? Tige kɨyang paha ti. Ên i nêl kɨyang hɨxôn xêkɨzêc vô vɨmwo nipaên tɨyi xocbê xomxo levac ge, om vɨmwo nipaên ngô i vya dɨ vông i tɨyi wê nêl ge.” ");
INSERT INTO ptp_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Dɨ lutibed xomxo nêl Yesu lê vô levac vac vɨgwe Galili vɨhati. ");
INSERT INTO ptp_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","He sea xumac lɨlo dɨ lop mɨ la vɨxun, dɨ Jems yuu Jon, yuu la hɨxôn dɨ he xôn la vac Saimon yuu Andlu ben. ");
INSERT INTO ptp_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Lêc Saimon yen vêxta vông yidac ngwax tum mɨ dɨyêp lec pêt, om he nêl kɨtong vô Yesu. ");
INSERT INTO ptp_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Om Yesu la le kwabo vô i dɨ hôm lec i vɨgê dɨ vông i le kɨsii, dɨ yidac tige tip la dɨ i vô nivɨha lec, mêd la myêl yaên mɨ vet he ya. ");
INSERT INTO ptp_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Hɨyôv hoo la dɨ vɨgwe ob buc mêd xomxo tɨbeac kô xomxo yidac hɨxôn xomxo wê vɨmwo nipaên dô vac he gee mɨ la vô Yesu. ");
INSERT INTO ptp_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Om xomxo vɨhati wê dô vac vɨgwe tige la kɨtucma mɨ le kwabo vô xumac tige vuayen. ");
INSERT INTO ptp_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Mêd Yesu vông xomxo wê tulec yidac toto gee tɨbeac vô nivɨha lec dɨ tii vɨmwo nipaên vêl ên xomxo tɨbeac. Lêc vɨmwo nipaên xovô Yesu om Yesu vɨbu he nêb he i o lêc nêl i kɨtong vô xomxo lêm. ");
INSERT INTO ptp_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Vô pɨtoc yang Yesu kɨdi lec dɨ sea vɨgwe tige dɨ la vac vɨgwe mahɨgun pɨleva wê xomxo dô vacên ma ge, dɨ la kɨtaa. ");
INSERT INTO ptp_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Lêc Saimon he lie myag i la, ");
INSERT INTO ptp_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","dêc mɨla yêvô om nêl vô i ên nêbê, “Xomxo tɨbeac dɨmyag ông.” ");
INSERT INTO ptp_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Lêc Yesu nêl vô he ên nêbê, “Maê. Il ob la vac vɨgwe yaya wê yêp kwabo ge ên a nêl xolac vô he hɨxôn. Ên yuac ga wê a lam ên a nêb a ob vông ge.” ");
INSERT INTO ptp_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Mêgem Yesu la vɨgwe Galili vɨhati dɨ la nêl xolac vac Yuda xumac lɨlo toto ge dɨ tii vɨmwo nipaên vêl ên xomxo. ");
INSERT INTO ptp_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Xomxo wê kɨtyax mahɨzihɨzi ge ti la yev vɨxa kɨtu vô Yesu dɨ kɨtaa i ên nêbê, “Ông obêc nêb a vô nigvɨha lec ge od ông tɨyi wê ông ob vông a nignɨvi i vô nivɨha lec.” ");
INSERT INTO ptp_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Mêdêc Yesu xo vɨgwe pɨsiv ên i om vyax vɨgê lec dɨ nêl vô ên nêbê, “A nêb ông vô nimvɨha lec.” ");
INSERT INTO ptp_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Yesu nêl dɨ yidac tige tip la lutibed dɨ i ninɨvi vô nivɨha lec. ");
INSERT INTO ptp_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Mêd Yesu nêl kɨyang xêkɨzêc vô i ên nêbê, “Ông kɨdi lec mɨ loc, ");
INSERT INTO ptp_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","dɨ ông o lêc nêl nimnɨvi wê vô nivɨha lec ge kɨtong vô xomxo ti lêm. Dɨ ông loc hɨlung nimnɨvi mô vô xomxo wê mi si daa vô Anutu ge dɨ vông daa i tɨyi môp wê Moses xolac nêl ge, ên xomxo vɨhati i yê dɨ xovô bê ông nimnɨvi vô nivɨha lec om ông vông daa.” ");
INSERT INTO ptp_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Yesu nêl bêge lê, lêc xomxo tige la nêl kɨyang kɨtong vac vɨgwe vɨyang vɨyang, mêgem Yesu o tɨyi wê ob la hɨlung i seac vac vɨgwe levac tɨyi xocbê ilage lêm, om la dô vac vɨgwe mahɨgun pɨleva, lêc xomxo vac vɨgwe vɨyang vɨyang ge kɨtuc la vô i. ");
INSERT INTO ptp_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Buc mangwe la vêl lêc Yesu lax mɨ la ben Kapaneam, dɨ xomxo ngô wê i lax dô vac ben ge, ");
INSERT INTO ptp_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","om xomxo tɨbeac la pup lec i ben dɨ le vac vuayen hɨxôn, om môp ti o yêp lêm. Mêd Yesu nêl xolac vô he, ");
INSERT INTO ptp_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","lêc xomxo yuudɨyuu ken li ti wê len vô xêlehe ge mɨ lam, ên nêb ob kô i mɨ la vô Yesu. ");
INSERT INTO ptp_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Lêc xomxo pup lec vɨgwe om môp ti o yêp wê he ob kô i mɨ la vô Yesu ge lêm, om he lec xumac mɨ la kɨsii mɨ la dii xumac mya ti wê Yesu le ge vêl dɨ vông xomxo tyo lop mɨ la hɨxôn pêt dɨ la yêp vô Yesu manôn. ");
INSERT INTO ptp_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Mêd Yesu yê wê he vông i vin ge om nêl vô xomxo tyo ên nêbê, “Nug, a kɨtya ông nêm nipaên vêl pyap.” ");
INSERT INTO ptp_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Mêlêc xomxo wê xovô Moses xolac gee ya dô hɨxôn om ngô kɨyang wê Yesu nêl ge dɨ xo vac nɨlô bêga nêbê, ");
INSERT INTO ptp_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Bêna lêc xomxo tige nêl kɨyang tibêge? Ge so vya vô Anutu, ên xomxo ti o tɨyi wê ob kɨtya xomxo nên nipaên vêl ge lêm. Nge, Anutu vaci tibed tɨyi wê ob kɨtya xomxo nên nipaên vêl.” ");
INSERT INTO ptp_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Lêc Yesu xovô kɨyang wê he xo vac nɨlô ge, om nêl vô he ên nêbê, “Bêna lêc xam xo kɨyang tibêge vac nɨlômê? ");
INSERT INTO ptp_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Xam ngô lê. Kɨyang tina wê obêc vô vɨyin maên ge? Kɨyang wê nêbê, ‘A kɨtya ông nêm nipaên vêl’ ge, me kɨyang wê nêbê, ‘Ông kɨdi lec dɨ kô ông pêt lec dɨ loc’? ");
INSERT INTO ptp_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Mêlêc a nêb a ob vông xovôên vô xam bê a, Xomxo Nu, a xêkɨzêc tɨyi wê a ob kɨtya xomxo nên nipaên vêl gê kɨbun ga, om xam wê.” Om Yesu nêl vô xomxo ti wê len vô xêlehe ge ên nêbê, ");
INSERT INTO ptp_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“A nêl vô ông bê ông kɨdi lec dɨ hôm ông guhu lec dɨ lôc bom.” ");
INSERT INTO ptp_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Dɨ lutibed xomxo tige kɨdi lec vac he mahɨgun dɨ hôm i guhu lec dɨ loc mɨ la. Mêgem xomxo gee vɨhati yê dɨ yetac mabu dɨ pɨmil Anutu dɨ nêl ên nêbê, “Xe o xê susu bêga ti ila lêm.” ");
INSERT INTO ptp_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Yesu lax mɨ la mia luaên Galili tii vac mêd xomxo tɨbeac la vô i, dɨ i nêl xolac vô he. ");
INSERT INTO ptp_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Pyap dɨ Yesu loc mɨ la lêc mɨla yê Livai wê Alpias nu ge, wê xeedô vac xumac wê he mi kô mone takis vô tɨbii vac ge, om Yesu la nêl vô i ên nêbê, “Lam tɨmu vô a vɨxag.” Mêgem Livai kɨdi lec dɨ la hɨxôn Yesu mɨ yuu la. ");
INSERT INTO ptp_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Mêd Yesu hɨxôn i nue ngɨvihi la ya hɨxôn Livai vac i ben, lêc tɨbii wê mi kô mone takis ge hɨxôn xomxo nipaên, he tɨbeac la ya hɨxôn he, ên xomxo tibêgee tɨbeac mi tɨmu vô Yesu. ");
INSERT INTO ptp_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Lêc Palisi wê xovô Moses xolac ge he ya yê wê Yesu dɨya hɨxôn tɨbii nipaên yuu tɨbii wê mi kô takis gee, om nêl vô Yesu nue ngɨvihi ên nêbê, “Bêna lêc Yesu la ya hɨxôn tɨbii wê mi kô mone takis ge hɨxôn tɨbii nipaênê?” ");
INSERT INTO ptp_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Mêd Yesu ngô wê he nêl ge, om nêl vô he ên nêbê, “Xomxo nivɨha obêc la vô docta lêm. Nge, tɨbii yidac ge wê obêc la vô docta. Om xam xovô bêga bê a o lam ên xomxo nivɨha lêm. Nge, a lam ên tɨbii nipaên, ên a nêb a ob tyuc he lam vô a.” ");
INSERT INTO ptp_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Buc ti Jon Lipacên nue ngɨvihi hɨxôn Palisi he ngɨbua yaên tɨyi môp wê he Yuda mi vông ge, om xomxo mangwe la nêl vô Yesu ên nêbê, “Jon Lipacên nue ngɨvihi hɨxôn Palisi ge, he mi ngɨbua yaên, lêc bêna lêc nume ngɨvihi o ngɨbua yaên lêmê?” ");
INSERT INTO ptp_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Lêc Yesu nêl vô he ên nêbê, “Tɨbii vɨyang ti lie ti obêc ii vêx ti lêc gên dô hɨxôn he ge od he obêc ngɨbua yaên, me? Ma vêl. Ên li tige gên dô hɨxôn he, om he ob dô hɨxôn xêyaa nivɨha dɨ ob ngɨbua yaên lêm. ");
INSERT INTO ptp_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Lêc obêc buc tɨmuên wê tɨbii ob kô li tige vêl ên he ge od ge wê he ob ngɨbua yaên.” ");
INSERT INTO ptp_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Yesu nêl ên nêbê, “Xomxo ti nên ngakwi obêc tip ge od obêc kɨping ngakwi paha myahɨpu ti vêl mɨ la duu lec tɨkwê lêm. Ên obêc vông bêge ge od myahɨpu paha tige obêc tɨtê tɨkwê lêx dɨ tocên obêc vô levac. ");
INSERT INTO ptp_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Dɨ xomxo ti obêc too wain paha vac bwoc ninɨvi tɨkwê lêm. Ên obêc too vac ge od wain obêc vuac dɨ tax ninɨvi tɨkwê tip dɨ wain too la. Om wain paha ge, xomxo i too vac bwoc ninɨvi paha.” ");
INSERT INTO ptp_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Vô buc sabat ti Yesu he nue ngɨvihi la vô môp wê la vac yuac yaên ge ti, mêd he mɨla lê, lêc nue ngɨvihi le yul wit nôn wê tɨyi xocbê pɨdi nôn ge dɨ ya. ");
INSERT INTO ptp_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Lêc Palisi ya yê dɨ nêl vô Yesu ên nêbê, “Wê lê, gwêbaga buc sabat wê Moses xolac vɨbu nêb il ob vông yuac ti lec lêm ge, lêc bêna lêc nume ngɨvihi vông yuac lec?” ");
INSERT INTO ptp_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Lêc Yesu nêl vô he ên nêbê, “Môp wê bug Devit vông ilage, xam kɨtong, me xam lungên? Môp bêga nêbê Devit he lie dô, lêc vip den he. ");
INSERT INTO ptp_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Vô buc tige Abiata tu xomxo daa siên nên levac mɨ dô vac Anutu xumac ngɨbua, om Devit la vac xumac ngɨbua tige dɨ la hôm blet ti wê he tung vô Anutu manôn ge. Blet tige xomxo pɨleva o tɨyi wê ob ya ge lêm. Nge, xomxo wê mi si daa vô Anutu gee, heche va ob ya. Lêc Devit kô mɨ lax ya dêc vông mɨ lie ya hɨxôn. Lêc Devit môp ge tɨyi, ên Abiata vaci vông vô Devit mɨ i ya.” ");
INSERT INTO ptp_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Om Yesu nêl vô he ên nêbê, “Om xam xovô bê xe êno o vông i so lêm, ên Anutu o tung xomxo ên nêb he i ngɨdu buc sabat xôn lêm. Nge, vông buc sabat ên nêb i ngɨdu xomxo xôn. ");
INSERT INTO ptp_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Om a, Xomxo Nu, a tu buc sabat kehe hɨxôn.” ");
INSERT INTO ptp_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Yesu la vac Yuda xumac lɨlo lu ngwe tii vac, lêc xomxo wê vɨgê vɨlu vô xêlehe ge ti dô hɨxôn he vac xumac tige. ");
INSERT INTO ptp_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Dɨ xomxo wê xeedô gee yê Yesu xôn ên nêb ob yê bêc Yesu obêc vông xomxo tige vô nivɨha lec vô sabat ge, od he ob vông kot vô Yesu. ");
INSERT INTO ptp_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Mêd Yesu nêl vô xomxo vɨgê nipaên tige ên nêbê, “Kɨdi lec mɨ le vac mahɨgun.” ");
INSERT INTO ptp_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Om Yesu nêl vô he vɨhati ên nêbê, “Xolac wê il Yuda vông ge, nêb il vông bêna lec sabatê? Nêb il vông nivɨha, me nêb il vông nipaên? Il ob vông xomxo vô nivɨha lec, me il ob hi he i yib lec sabat?” Lêc he dô kɨyang maên dɨ o nêl kɨyang ti lax vô Yesu lêm. ");
INSERT INTO ptp_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Om Yesu yê he vɨhati manôn dɨ xêyaa vô myavɨnê vô he, dɨ nɨlô vô vɨyin ên wê he nɨlô xêkɨzêc ta dɨ he o vông i vin lêm ge, om nêl vô xomxo vɨgê nipaên tige ên nêbê, “Tɨtô vɨgêm.” Mêgem xomxo tyo tɨtô vɨgê lêc vɨgê vô nivɨha lec. ");
INSERT INTO ptp_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Mêd lutibed he Palisi kɨdi mɨ la, dɨ la kɨtucma hɨxôn Helot nue dɨ he xôn myag môp wê nêb ob hi Yesu i yib lec ge. ");
INSERT INTO ptp_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Yesu he nue ngɨvihi loc mɨ la mia luaên Galili dɨ xomxo tɨbeac tɨmu vô Yesu vɨxa. ");
INSERT INTO ptp_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Xomxo tigee lam gê vɨgwe Galili yuu Judia, dɨ lam gê Jelusalem, dɨ lam gê Idumia, dɨ lam gê mia Jodan vɨlu ganê dɨ lam gê vɨgwe Taia yuu Saidon, ên he ngô yuac wê Yesu vông ge om nêb ob lam ên lam yê. ");
INSERT INTO ptp_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Om Yesu nêl vô nue ngɨvihi ên nêbê, “Xomxo tɨbeac hɨwocên val dô om obêc hɨvun a xôn, om xam loc viac dipac ti, êdêc a sox la dô lec.” ");
INSERT INTO ptp_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Yesu nêl bêge, ên vông xomxo yidac tɨbeac vô nivɨha lec, om he wê yidac ge le i vivac i ên nêb he ob vyax vɨgê lec i ên he i vô nivɨha lec. ");
INSERT INTO ptp_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Dɨ vɨmwo nipaên wê dô vac xomxo ge yê Yesu om yev vɨxa kɨtu vô dɨ tyuc vya levac ên nêbê, “Ông ge Anutu nu.” ");
INSERT INTO ptp_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Lêc Yesu vɨbu he nêb he i o lêc nêl i kɨtong vô xomxo lêm. ");
INSERT INTO ptp_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Yesu la lec kɨtôn ti, mêd keac xomxo ya nêb he i loc vô i. Om he la vô i, ");
INSERT INTO ptp_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","dɨ Yesu vɨnoo he vɨgê yuu dɨ tô mɨ la yuu ên nêb he i dô hɨxôn i, dêc obêc vông he la nêl xolac, ");
INSERT INTO ptp_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","dɨ ob vông xêkɨzêc vô he i tɨyi wê he ob tii vɨmwo nipaên vêl ên xomxo ge. ");
INSERT INTO ptp_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Om he lê bêga, Saimon, wê Yesu nêl i lê ngwe nêbê Pita, ");
INSERT INTO ptp_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","dɨ Jems yuu Jon wê yuu ma Sebedi ge lêc Yesu nêl yuu xôn lê ngwe bêga nêbê Boanesis. Lê tige kehe bêga nêbê deac tugên, ên yuu ge wê mi hɨgac vô xomxo ge, ");
INSERT INTO ptp_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","dɨ Andlu yuu Pilip dɨ Batolomyu, dɨ Matyu yuu Tomas, dɨ Jems wê ma Alpias ge, dɨ Tadias yuu Saimon Selot, ");
INSERT INTO ptp_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","dɨ Judas Iskaliot wê obêc hɨlung Yesu vô tɨbii vevac tɨmuên ge. ");
INSERT INTO ptp_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Yesu lax mɨ la vac ben xumac lôma, mêd xomxo tɨbeac la kɨtucma hɨxôn i om hɨyôv manôn wê Yesu he nue ngɨvihi ob ya yaên lec ge ma. ");
INSERT INTO ptp_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Mêd Yesu lie ngô kɨyang tige om val ên nêb ob lam kô Yesu, ên xomxo ya nêl ên nêbê Yesu vô mavmav. ");
INSERT INTO ptp_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Dɨ xomxo wê xovô Moses xolac ge wê he lam gê Jelusalem ge, he nêl ên nêbê, “Bielsebul wê tu vɨmwo nipaên nên levac ge dô vac Yesu nɨlô, om Yesu tii vɨmwo nipaên vêl ên xomxo ya xêkɨzêc wê Bielsebul vông ge.” ");
INSERT INTO ptp_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Om Yesu keac xomxo vɨhati val kwabo vô i dɨ i nêl kɨyang pɨlepacên ya vô he bêga nêbê, “Bêna lêc Seten ob tii Seten vaci vêl? ");
INSERT INTO ptp_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Xomxo vɨyang ti obêc hɨbuma la yuu dɨ vông vevac vôma ge od he ob dô nivɨha lêm. ");
INSERT INTO ptp_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Dɨ xomxo wê xumac tibed ge obêc hɨbuma la yuu dɨ vông vevac vôma ge od he obêc dô nivɨha lêm. Nge, xêkɨzêc wê he vông ge ob tô mɨ la. ");
INSERT INTO ptp_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Om kɨyang wê xam nêl ge obêc kɨyang nôn ge od obêc tɨyi xocbê Seten vaci vông vevac vô Seten dɨ hɨbuma sea, lêc obêc bêge ge od xêkɨzêc wê Seten vông ge obêc tip vac. ");
INSERT INTO ptp_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Xomxo xêkɨzêc ti obêc dô vac i ben xumac lôma ge od xomxo ti o tɨyi wê ob la vun i susu ge lêm. Lêc obêc ku xomxo tige xôn pɨlihi ya yihi ge od tɨyi wê tɨbii ob la vac i ben xumac lôma dɨ la vun i nên susu vɨhati ge. ");
INSERT INTO ptp_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“A nêl hɨxôn nôn vô xam bê xomxo ti obêc vông môp nipaên, me obêc nêl kɨyang nipaên ge od Anutu tɨyi wê ob kɨtya nipaên tige vêl ge. ");
INSERT INTO ptp_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Lêc xomxo ti obêc nêl kɨyang nipaên lec Myakɨlôhô Ngɨbua ge od o tɨyi wê Anutu ob kɨtya i nên nipaên tige vêl ge lêm. Nge, nipaên tige ob yêp vô xomxo tige luta lêc luta.” ");
INSERT INTO ptp_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Yesu nêl kɨyang tige vô he ên wê he nêl ên he nêbê vɨmwo nipaên dô vac i nɨlô ge. ");
INSERT INTO ptp_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Yesu tae lie val le vɨxun, dɨ vông kɨyang la vô Yesu ên nêb i lam vô he. ");
INSERT INTO ptp_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Om xomxo wê dô ngɨvina Yesu gee nêl vô i ên nêbê, “Tame lime val le vɨxun ên nêb ob yê ông.” ");
INSERT INTO ptp_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Lêc Yesu nêl lax vô he ên nêbê, “Xomxo letya wê a tage lige ge?” ");
INSERT INTO ptp_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Mêd Yesu yê ma la xomxo wê dô i ngɨvina i ge dɨ nêl ên nêbê, “Wê lê, ga a tage lige. ");
INSERT INTO ptp_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Ên xomxo wê tɨmu vô Anutu kɨyang ge, ge wê tu a tage lige ge.” ");
INSERT INTO ptp_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Yesu lax mɨ la mia luaên Galili dɨ lax nêl xolac vô xomxo vô mia nɨnya. Lêc xomxo tɨbeac hɨwocên, om Yesu lec la lec dipac ti mɨ dô lec, dɨ du mɨ la mahɨgun dɨ nêl xolac vô xomxo wê dô kehe ge. ");
INSERT INTO ptp_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Yesu nêl kɨyang pɨlepacên tɨbeac vô xomxo om nêl ti vô xomxo tigee bêga nêbê, ");
INSERT INTO ptp_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Xam ngô lê. Xomxo ti la ên nêb ob la lɨloo susu vê vac yuac. ");
INSERT INTO ptp_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Om lɨloo i la lê, lêc vê mangwe tô mɨ la dô vac môp om menac lam ya. ");
INSERT INTO ptp_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Dɨ ya tô lec kɨbun nipwo tya wê dô lec ngɨdax kɨsii ge om tyip lutibed, ");
INSERT INTO ptp_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","lêc ngɨlôhô la tulec ngɨdax om buc wê hɨyôv linac ge od ya i vɨlôvac dɨ i yib. ");
INSERT INTO ptp_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Dɨ vê mangwe tô mɨ la dô vac hɨvu kehe lêc tyip hɨxôn hɨvu dɨ hɨvu hɨvun xôn om o vuac nôn nivɨha lêm. ");
INSERT INTO ptp_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Dɨ vê mangwe tô mɨ la dô vac kɨbun nivɨha om tyip dɨ vuac nôn nivɨha. Mêgem ya vuac nôn 30 dɨ ya vuac 60 dɨ ya 100.” ");
INSERT INTO ptp_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Yesu nêl bêge vô he dɨ nêl hɨxôn ên nêbê, “Xomxo ti nɨnya obêc yêp ge od i ngô dɨ xovô.” ");
INSERT INTO ptp_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Dêc tɨmuên Yesu vaci la dô vɨyonên, dɨ nue ngɨvihi hɨxôn xomxo wê mi dô hɨxôn i gee, he mɨla vô i dɨ la kɨnêg kɨyang pɨlepacên kehe ên nêb i nêl kɨtong vô he. ");
INSERT INTO ptp_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Om Yesu nêl vô he ên nêbê, “Kɨyang wê nêl lec Anutu môp yuu ben ge yêp xôpacên lê, lêc Anutu nêb ob hɨlung vô xam ên xam xovô. Dɨ xomxo baba ge ngô kɨyang tɨyi xocbê kɨyang pɨlepacên pɨleva. ");
INSERT INTO ptp_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Om ‘he ob yê lê, lêc ob yêvô nôn ti lêm, dɨ he ob ngô kɨyang lê, lêc he ob xovô kehe lêm, om he o tɨyi wê he ob pɨlepac he ên Anutu i kɨtya he nên nipaên vêl ge lêm.’” ");
INSERT INTO ptp_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Yesu nêl vô he ên nêbê, “Xam obêc lungên kɨyang pɨlepacên tige kehe ge od xam ob xovô kɨyang pɨlepacên vɨhati ge kehe tibêna? ");
INSERT INTO ptp_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Kehe bêga nêbê vê wê xomxo tige la lɨloo ge tɨyi xocbê Anutu xolac. ");
INSERT INTO ptp_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Dɨ vê wê tô vac môp ge, tɨyi xocbê xomxo wê ngô Anutu kɨyang lê, lêc lutibed Seten lam vô vêl ên he nɨlô. ");
INSERT INTO ptp_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Dɨ vê wê tô mɨ la dô lec kɨbun nipwo tya wê dô lec ngɨdax kɨsii ge, ge tɨyi xocbê xomxo wê ngô xolac dɨ vông i vin lutibed hɨxôn xêyaa nivɨha, ");
INSERT INTO ptp_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","lêc he tɨyi xocbê ngec wê ngɨlôhô maên ge, om he dô nipwo tya lêc xomxo obêc vông vɨyin vô he ên wê he vông i vin xolac ge od he sea vông vinên lutibed. ");
INSERT INTO ptp_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Dɨ vê wê tô mɨ la dô vac hɨvu kehe ge, ge tɨyi xocbê xomxo wê ngô xolac mɨ dô lê, ");
INSERT INTO ptp_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","lêc he vông nɨlô la vô susu yuu môp kɨbun ga dɨ he xêyaa vin lec wê he nêb ob kô susu tɨbeac hɨxôn mone ge, om môp tige hɨvun xolac xôn dɨ he o vô nôn nivɨha lêm. ");
INSERT INTO ptp_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Lêc vê wê tô mɨ la dô vac kɨbun nivɨha ge, ge tɨyi xocbê xomxo wê ngô xolac dɨ vông i vin dɨ vuac nôn tɨbeac, om vê ya vuac nôn 30 dɨ he ya vuac 60 dɨ ya vuac 100.” ");
INSERT INTO ptp_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Yesu nêl ên nêbê, “Xomxo ti obêc byêx ngwax vac lam ge od ob lax i la vac dêg, me lax i la le vac pêt ngɨbi, me? Ma, ob lax i le lec tevol kɨsii ên i linac vac vɨgwe. ");
INSERT INTO ptp_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Susu wê dô xôpacên ge vɨhati obêc val dô seac tɨmuên, dɨ kɨyang wê yêp xôpacên ge obêc val yêp vac xêseac. ");
INSERT INTO ptp_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Xam nɨnyam obêc yêp ge od xam ngô dɨ xovô.” ");
INSERT INTO ptp_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Dɨ Yesu nêl ên nêbê, “Kɨyang wê xam ngô ge, xam vyac xovô nivɨha lê. Ên môp wê xam vông vô xomxo ge Anutu obêc vông i tɨyi wê xam vông vô he ge vô xam, dɨ Anutu vaci obêc vông mangwe i luu wê xam vông vô lime ge vêl vô xam hɨxôn. ");
INSERT INTO ptp_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Ên xomxo obêc xovô xolac mɨ hôm pɨlihi ge od Anutu obêc kɨpyax tɨbeac lec hɨxôn vô i. Lêc xomxo obêc hôm xolac pɨlihi lêm ge, od nipwo tya wê yêp vac i nɨlô ge, Anutu obêc vô vêl.” ");
INSERT INTO ptp_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Yesu nêl ên nêbê, “Anutu ben kehe ge tɨyi xocbê xomxo ti wê la lɨloo vê vê vac yuac ge, ");
INSERT INTO ptp_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","lêc lax dô dɨ buc ya la vêl lêc mɨlax yê wê vê tyip mɨ vô levac ge, lêc o xovô kehe lêm. ");
INSERT INTO ptp_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Ên kɨbun vaci vông yuac lec, om vê tyip mɨ vô lihi lec dɨ vuac nôn, ");
INSERT INTO ptp_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","dɨ buc wê nôn huu ge od xomxo tyo la ên nêb ob la yul nôn.” ");
INSERT INTO ptp_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Yesu nêl ên nêbê, “Anutu ben kehe ge tɨyi vatya? Dɨ il ob nêl kɨyang pɨlepacên tibêna wê ob tɨyi môp tige? ");
INSERT INTO ptp_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Ge tɨyi xocbê vɨxôô nôn wê nipwo lee tya i luu nôn baba vêl ge, ");
INSERT INTO ptp_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","lêc xomxo obêc xin ge od obêc tyip mɨ vô levac luu susu baba vêl dɨ obêc sux ngen lec dɨ menac lam vông lɨwihi lec mɨ dô vac hɨnyena.” ");
INSERT INTO ptp_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Yesu obêc nêl xolac vô xomxo ge od mi nêl kɨyang pɨlepacên tibêge tɨbeac vô he tɨyi wê he ob xovô ge. ");
INSERT INTO ptp_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Lêc o nêl kɨyang kehe yêp seac vô he hɨxôn lêm. Nge, nêl kɨyang pɨlepacên pɨleva, dɨ tɨmuên wê he nue ngɨvihi vaci dô ge od Yesu nêl kɨyang pɨlepacên kehe kɨtong vô he. ");
INSERT INTO ptp_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Vô buc tibed tige vɨgwe huc om Yesu nêl vô nue ngɨvihi ên nêbê, “Il ob la mia luaên vɨlu ganê.” ");
INSERT INTO ptp_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Mêgem he sea xomxo tigee dô dɨ he lec dipac ti wê Yesu dô lec ge dɨ he xôn loc mɨ la, dɨ dipac ya la hɨxôn. ");
INSERT INTO ptp_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","He mɨla mahɨgun lê, lêc lea vɨyiiên mabu ti val om mia kɨpyax la vac dipac nɨlô dɨ la pup lec. ");
INSERT INTO ptp_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Lêc Yesu la dô lec dipac vɨwen tɨmuên dɨ kɨluu bazub lec kɨluuên ti dɨ yêp, om nue ngɨvihi la tɨpi vô dɨ nêl vô ên nêbê, “Xolac kehe, vô kwabo lec wê il ob xib ge, lêc mêd ông o xovô il lêm, me?” ");
INSERT INTO ptp_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Mêd Yesu kɨdi lec dɨ nêl vô lea yuu mia ên nêb lea i tip loc dɨ mia i yêp kɨzêc, om lea tip la dɨ mia yêp tɨpiên ma. ");
INSERT INTO ptp_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Mêd Yesu nêl vô nue ngɨvihi ên nêbê, “Bêna lêc xam xona? Vông vinên wê xam vông ge tyo nôn tina?” ");
INSERT INTO ptp_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Om he yetac mabu dɨ nêl vôma ên nêbê, “Xomxo tiga letya lêc lea yuu mia vô nɨnya lehe vô i?” ");
INSERT INTO ptp_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Yesu he nue ngɨvihi loc mɨ la tɨbii Gelasa ben wê yêp mia luaên vɨlu ganê ge. ");
INSERT INTO ptp_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","He mɨla lop vêl ên dipac lêc xomxo wê vɨmwo nipaên dô vac i nɨlô ge ti lam vac vɨgwe yibên dɨ lam vô Yesu. ");
INSERT INTO ptp_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Vuxtige ben wê mi dô vac ge, mi dô vac vɨgwe yibên, dɨ xomxo ti o tɨyi wê ob ku i xôn ge lêm. ");
INSERT INTO ptp_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Ên buc tɨbeac ge xomxo ku i vɨgê yuu vɨxa xôn ya sen lê, lêc xomxo tyo tax sen tip sea, dɨ xomxo ti o tɨyi wê ob hôm i xôn ge lêm, ên xêkɨzêc wê xomxo tige vông ge luu xêkɨzêc wê he vông ge vêl. ");
INSERT INTO ptp_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Vô vɨdiiên yuu bucên vɨhati ge xomxo tige mi vɨlee mɨ la vac vɨgwe yibên dɨ la lec kɨtôn dɨ mi iac dɨ gôl ninɨvi sea ya ngɨdax. ");
INSERT INTO ptp_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Xomxo tige yê wê Yesu val le teva ge om tup mɨ la vô dɨ la yev vɨxa kɨtu vô. ");
INSERT INTO ptp_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Lêc Yesu nêl vô i ên nêbê, “Vɨmwo nipaên, ông lam loc vêl ên xomxo tige.” Mêgem xomxo tyo iac mabu dɨ nêl ên nêbê, “Yesu, ông ge Anutu lag puunê nu ông, lêc ông ob vô vatya vô a? A le vô Anutu manôn dɨ a kɨtaa ông bê ông o lêc vông a vô nipaên lêm.” ");
INSERT INTO ptp_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Mêd Yesu kɨnêg vô i ên nêbê, “Ông lêm le?” Dɨ i nêl ên nêbê, “A lêg kehe bêga nêbê kɨdu levac, ên xe ga, xe tɨbeac.” ");
INSERT INTO ptp_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Mêd i kɨtaa Yesu tii vac vac ên nêb i o lêc tii vɨmwo nipaên i loc vêl ên vɨgwe tige lêm. ");
INSERT INTO ptp_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Bwoc kɨdu levac vông zuac mɨ le lec kɨtôn, ");
INSERT INTO ptp_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","om vɨmwo nipaên tigee kɨtaa Yesu ên nêbê, “Ông vông xe la dô vac bwoc tiganêe.” ");
INSERT INTO ptp_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Mêd Yesu tyuc lec om vɨmwo nipaên tigee lam la vêl ên xomxo tige dɨ la dô vac bwoc tyoe nɨlô, mêd bwoc tigee tup mɨ la vac vɨgwe madia dɨ la tô vac mia luaên dɨ num mia mɨ yib. Bwoc tigee tɨbeac hɨwocên tɨyi xocbê 2,000 lêc he yib mɨma vêl. ");
INSERT INTO ptp_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Mêd xomxo wê mi viac bwoc tigee ge pec mɨ la, dɨ mɨla nêl kɨyang tige kɨtong vô tɨbii vac vɨgwe levac hɨxôn vɨgwe nipwo vɨyang vɨyang ge. Om xomxo tɨbeac la ên nêb ob la yê han, ");
INSERT INTO ptp_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","om he val vô Yesu lêc val yê xomxo ti wê vɨmwo nipaên dô vac ilage, lêc vɨmwo sea i dɨ i pɨyôp vô nivɨha lec dɨ i vɨnyum nivɨmihi lec dɨ xeedô hɨxôn Yesu, om he yê dɨ xona ên. ");
INSERT INTO ptp_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Dɨ xomxo wê dô mɨ yê wê Yesu tii vɨmwo nipaên vêl ên xomxo tige, nêl kɨtong vô tɨbii wê val gee dɨ nêl lec bwoc hɨxôn. ");
INSERT INTO ptp_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Om tɨbii tigee vɨhati kɨtaa Yesu ên nêb i loc vêl ên he ben. ");
INSERT INTO ptp_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Mêgem Yesu lec dipac ên nêb ob lax mɨ la, lêc xomxo ti wê Yesu tii vɨmwo nipaên vêl ên i ge, lam kɨtaa Yesu ên nêb ob la hɨxôn i, ");
INSERT INTO ptp_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","lêc Yesu nêl vô ên nêbê, “Ông la hɨxônên a ob ma, dɨ ông lôc bom ên lôc nêl do levac wê Apumtau vông vô ông ge kɨtong vô lime dɨ nêl lec wê Apumtau xo vɨgwe pɨsiv ên ông ge hɨxôn.” ");
INSERT INTO ptp_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Mêgem xomxo tyo lax mɨ la ben dɨ la nêl kɨyang wê Yesu vông i vô nivɨha lec ge kɨtong vô xomxo vac vɨgwe levac Dekapolis vɨhati, om xomxo tigee ngô kɨyang wê i nêl ge dɨ yetac mabu. ");
INSERT INTO ptp_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Yesu la lec dipac mɨ lax mɨ la mia luaên vɨlu ganê, mɨ la dô vô mia nɨnya dɨ xomxo tɨbeac kɨtucma mɨ la vô i. ");
INSERT INTO ptp_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Mêd xomxo levac wê mi viac Yuda xumac lɨlo ge ti lê nêbê Jailas yê wê Yesu val ge, om lam yev vɨxa kɨtu vô ");
INSERT INTO ptp_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","dɨ kɨtaa vô i ên nêbê, “A nug vêx vông yidac mabu ti dɨ vô kwabo lec wê ob yib ge. Om a nêb ông lam vyax vɨgêm lec ên yidac i ma dɨ i vô nivɨha lec.” ");
INSERT INTO ptp_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Om Yesu la hɨxôn Jailas mɨ yuu la, lêc xomxo tɨbeac lam hɨvun Yesu xôn dɨ he xôn la. ");
INSERT INTO ptp_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Mêd vêx ti dô vac he mahɨgun, lêc vêx tige, yidac kwatuacên vông i tɨyi klismas 12, lêc yidac tige o ma lêm, ");
INSERT INTO ptp_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","dɨ i kô myavɨnê tɨbeac vô docta dɨ sea i mone la mɨma vêl, lêc yidac tige o tɨyôô ên i lêm. Nge, yidac tige vô levac dɨ dô xuhu dia. ");
INSERT INTO ptp_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Mêd vêx tyo ngô kɨyang wê xomxo mi nêl lec Yesu ge om la vac xomxo tigee mahɨgun dɨ la le vô Yesu nɨmi dɨ vyax vɨgê lec Yesu vɨnyumên. ");
INSERT INTO ptp_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Vông bêge ên xo ên nêbê, “A obêc vyax vɨgêg lec Yesu vɨnyumên ge od a obêc vô nigvɨha lec.” ");
INSERT INTO ptp_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Om lutibed yidac tyo tip la dɨ vêx tyo yaxên wê yidac tyo ma ên i ge. ");
INSERT INTO ptp_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Mêd Yesu yaxên wê xêkɨzêc wê i vông ge ya sea i, om pɨlepac i vac xomxo tigee mahɨgun dɨ kɨnêg ên nêbê, “Letya hôm vɨgê lec vɨnyumên wê a vông ge?” ");
INSERT INTO ptp_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Lêc nue ngɨvihi nêl vô i ên nêbê, “Xomxo tɨbeac le i ngɨvina ông xôn, lêc bêna lêc ông kɨnêg ên ông nêbê letya vyax vɨgê lec ôngê?” ");
INSERT INTO ptp_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Lêc Yesu yê i vivac vô he vɨhati ên nêb ob yê xomxo ti wê vyax vɨgê lec i ge, ");
INSERT INTO ptp_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","mêd vêx tige xovô wê xêkɨzêc wê Yesu vông ge la vông i vô nivɨha lec ge om xona dɨ la hɨxôn ni yetacên dɨ la yev vɨxa kɨtu vô Yesu dɨ nêl i kɨyang kɨtong vɨhati vô Yesu. ");
INSERT INTO ptp_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Mêd Yesu nêl vô i ên nêbê, “Nuge, vông vinên wê ông vông ge vông ông vô nivɨha lec, om ông lôc hɨxôn xêmyaa nivɨha, ên yidac wê ông vông ge tip la gwêba pyap.” ");
INSERT INTO ptp_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Yesu gên nêl kɨyang, dêc xomxo vac Jailas ben val nêl vô Jailas ên nêbê, “Num vêx yib gwêba, om le i lêc vông yuac levac vô xolac kehe lêm.” ");
INSERT INTO ptp_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Yesu ngô kɨyang wê he nêl ge lêc o vông i vin lêm, om nêl vô Jailas ên nêbê, “Xonaên i ma dɨ ông vông i vin.” ");
INSERT INTO ptp_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Mêd Yesu nêl ên nêbê xomxo vɨhati i dô om he dô dɨ Yesu kô Jems yuu li Jon dɨ Pita mɨ he la. ");
INSERT INTO ptp_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","He mɨla vô kwabo lec Jailas ben lêc Yesu ngô wê xomxo byag dɨ vô nidɨdun tɨbeac ge, ");
INSERT INTO ptp_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","om la xumac lôma dɨ la nêl vô he ên nêbê, “Bêna lêc xam byag dɨ vô nidɨdun tɨbeac? Vêx tige o yib ti. Nge, ici va yêp.” ");
INSERT INTO ptp_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Mêd he nap lec kɨyang wê Yesu nêl ge. Om Yesu vông he vɨhati la vɨxun, dɨ kô vêx tyo ta yuu ma hɨxôn nue ngɨvihi yon dɨ he la vac xumac nɨlô ti wê vêx tyo dɨyêp vac ge. ");
INSERT INTO ptp_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Mêd Yesu la hôm lec vêx tyo vɨgê dɨ nêl vô i ên nêbê, “Talita kumi.” Kɨyang tige kehe bêga nêbê, “Vêx, a nêl bê ông kɨdi lec.” ");
INSERT INTO ptp_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Om lutibed vêx tyo kɨdi lec mɨ vɨlee. Vêx tige, klismas wê i vông ge tɨyi xocbê 12. Dɨ he wê he dô mɨ yê gee yetac mabu. ");
INSERT INTO ptp_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Lêc Yesu nêl kɨyang xêkɨzêc vô he ên nêbê, “Xam o lêc nêl ga kɨtong vô xomxo ti lêm.” Dɨ nêl vô he ên nêbê, “Xam vông yaên vô vêx tyo ên i ya.” ");
INSERT INTO ptp_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Yesu sea vɨgwe tige dɨ lax mɨ la Nasalet wê i ben kehe ge, dêc nue ngɨvihi la hɨxôn. ");
INSERT INTO ptp_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","He dô dɨ buc sabat ge od Yesu la vac xumac lɨlo dɨ la nêl xolac vô xomxo. Om xomxo tɨbeac ngô i kɨyang dɨ yetac mabu dɨ nêl ên nêbê, “Xomxo tige kô kɨyang yuu pɨyôp vô letya lêc mi vông do levac tibêgee? ");
INSERT INTO ptp_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","I ge xomxo wê xumac loxên ge ti, wê Malia nu ge, om i lie Jems yuu Josis dɨ Judas yuu Saimon. Dɨ lie vêx dô hɨxôn il ga.” He nêl bêge dɨ he nɨlô vô vɨyin dɨ he yê Yesu nipaên. ");
INSERT INTO ptp_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Mêd Yesu nêl vô he ên nêbê, “Vac vɨgwe vɨyang vɨyang ge, xomxo ob kô plopet lec, dom plopet tyo tae mae lie hɨxôn xomxo vac i ben vɨgwe kehe obêc kô i lê lec lêm.” ");
INSERT INTO ptp_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Om Yesu o tɨyi wê ob vông do tɨbeac vac ben Nasalet ge lêm, dɨ i vyax vɨgê lec xomxo yidac titi dɨ vông he vô nivɨha lec. ");
INSERT INTO ptp_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Mêd Yesu yê wê lie Nasalet o vông i vin i lêm ge, om xo bêga nêbê, “Bêna lêc he o vông i vin a lêmê?” Mêgem Yesu sea Nasalet dɨ loc mɨ la vɨlee vac vɨgwe toto dɨ la nêl xolac vô tɨbii. ");
INSERT INTO ptp_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Yesu keac nue ngɨvihi vɨgê yuu dɨ tô mɨ la yuu la vô i, dɨ vông he yuu yuu loc mɨ la, dɨ vông xêkɨzêc wê i vông ge vô he ên nêb he i loc tii vɨmwo nipaên vêl ên xomxo, ");
INSERT INTO ptp_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","dɨ nêl vô he ên nêbê, “Xam hôm pɨtoa vac vɨgêm dɨ loc, dɨ xam o lêc kô susu ya hɨxôn lêm, xocbê yaên yuu vɨxec dɨ mone hɨxôn lêm. ");
INSERT INTO ptp_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Xam su su lec vɨxam, dɨ xam vɨnyum vɨnyumên tibed lec, dɨ xam o lêc kô vɨnyumên ngwe hɨxôn lêm. ");
INSERT INTO ptp_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Dɨ xam obêc la vac vɨgwe ti mɨ la dô vac xumac ti ge od xam dô vac xumac tige tibed i tɨyi buc wê xam ob dô ge. Pyap dêc xam sea vɨgwe tige dɨ loc bangwe. ");
INSERT INTO ptp_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Lêc xam obêc mɨla vac vɨgwe ti dɨ xomxo vɨyang tige o hôm xam lec nivɨha lêm dɨ o ngô kɨyang wê xam nêl ge lêm ge od xam lɨloo vɨjuva vêl ên vɨxam pɨtehe ên i nêl he nên nipaên kɨtong vô he dɨ loc.” ");
INSERT INTO ptp_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Om Yesu nue ngɨvihi loc mɨ la, dɨ la nêl xolac vô xomxo ên nêbê he i pɨlepac he, ");
INSERT INTO ptp_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","dɨ he tii vɨmwo nipaên vêl ên xomxo tɨbeac, dɨ xomxo yidac tɨbeac ge, he lipac wel lec he dɨ vông he vô nivɨha lec. ");
INSERT INTO ptp_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Hɨzap levac Helot ngô kɨyang wê tɨbii mi nêl lec Yesu ge, ên xomxo nêl Yesu kɨtong la vô levac vac vɨgwe tɨbeac, om he ya nêl ên he nêbê Yesu ge Jon Lipacên wê yib ge, kɨdi lec nang om vông do levac ya xêkɨzêc wê i vông ge. ");
INSERT INTO ptp_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Lêc xomxo ya nêl ên he nêbê ge plopet Ilaija, dɨ ya nêl ên nêbê Yesu ge plopet tɨyi xocbê plopet wê dô ilage ti. ");
INSERT INTO ptp_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Mêd Helot ngô kɨyang wê he mi nêl ge dɨ nêl ên nêbê, “Ge Jon Lipacên wê a kɨtov i kwa tip mɨ i yib ilage lêc kɨdi lec mavɨha vac yibên.” ");
INSERT INTO ptp_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Kɨyang wê Helot hi Jon yib ilage bêga nêbê ilage Helot kô li Pilip vɨnê Helodias om Jon Lipacên la nêl vô Helot ên nêbê, “Môp wê ông kô lim tuc vɨnê ge tɨyiên ma.” Mêgem Helodias kunac Jon dɨ nêl vô Helot om Helot vông tɨbii la hôm Jon xôn dɨ tung i la dô vac xumac kalabuhu. ");
INSERT INTO ptp_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Mêd Helodias xêyaa vô myavɨnê mabu vô Jon dɨ nêl nêb ob hi Jon yib, lêc tɨyiên ma, ");
INSERT INTO ptp_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","ên Helot xovô nêbê Jon ge xomxo nivɨha dɨ i ngɨbua, om Helot xona ên Jon dɨ viac i nivɨha ên nêb Helodias i o lêc vông i vô nipaên lêm. Mêd Helot obêc ngô kɨyang wê Jon mi nêl ge, od vông i nɨlô vô hɨmena hɨmena, lêc Helot xêyaa vin lec kɨyang wê Jon mi nêl ge om nêb ob ngô. ");
INSERT INTO ptp_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Mêd Helodias myag môp wê ob hi Jon i yib lec ge, om Helot buc wê ta kô i lec ge Helot myêl vɨzid levac dɨ tyuc gavman levac hɨxôn tɨbii vevac wê levac ge dɨ xomxo Galili levac vɨhati gee lam. ");
INSERT INTO ptp_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","He dô mɨ ya lêc Helodias nu vêx lam yoo vô he, dɨ Helot hɨxôn xomxo wê lam ya hɨxôn i ge vɨhati xêyaa vin lec i, om Helot nêl vô vêx tyo ên nêbê, “Ông obêc nêb kô susu ti ge od ông nêl kɨtong vô a dɨ a ob vông vô ông.” ");
INSERT INTO ptp_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Om Helot hɨlu kɨyang xôn vô i dɨ nêl ên nêbê, “A nêl hɨxôn nôn vô ông bêga bê ông obêc kɨtaa susu ti vô a ge, od a ob vông vô ông. Om ông obêc kɨtaa a ên ông nêbê a vông kɨbun wê a vông ge vɨwen i tu ông lêm i lec ge od a ob vông i tɨyi wê ông nêl ge.” ");
INSERT INTO ptp_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Mêd vêx tyo lax mɨ la kɨnêg vô ta ên nêbê, “Tag, ông nêb a kɨtaa susu vatya?” Om ta nêl vô ên nêbê, “Ông lôc nêl bê ông ob kô Jon Lipacên bazub.” ");
INSERT INTO ptp_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Mêd vêx tyo ngô kɨyang wê ta nêl ge om tup mɨ lax vô Helot dɨ lax nêl vô ên nêbê, “A nêb ông tung Jon Lipacên bazub lec pɨle ti mɨ vông vô a lutibed.” ");
INSERT INTO ptp_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Helot ngô kɨyang wê vêx tyo nêl ge dɨ nɨlô vô vɨyin mabu, lêc xovô kɨyang wê hɨlu xôn dɨ xomxo tɨbeac dô mɨ ngô hɨxôn ge, om nêb ob pwoo kɨyang wê nêl vô vêx tyo ge vac lêm. ");
INSERT INTO ptp_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Mêgem Helot vông tɨbii vevac ti la ên nêb i loc kô Jon bazub, om tɨbii tyo la vac xumac kalabuhu dɨ la kɨtov Jon kwa tip, ");
INSERT INTO ptp_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","dɨ tung bazub lec pɨle dɨ kô mɨ lax vông vô Helodias nu vêx tige dɨ i kô mɨ la vông vô ta. ");
INSERT INTO ptp_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Mêd Jon nue ngɨvihi ngô wê i yib ge om he val kô Jon nôn mɨ la yev. ");
INSERT INTO ptp_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Nue ngɨvihi wê Yesu vông he la ge vena nêl kɨyang wê he la nêl ge hɨxôn yuac wê he la vông ge kɨtong vô Yesu. ");
INSERT INTO ptp_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Lêc xomxo tɨbeac la dɨ lôm vô Yesu he nue ngɨvihi om hɨyôv manôn wê he ob dô seac vêl dɨ ya yaên ge ma. Mêgem Yesu nêl vô he ên nêbê, “Xam lam ên il ob la vac vɨgwe wê mahɨgun pɨleva dɨ xomxo ti dôên ma ge ên xam loc dô seac vêl.” ");
INSERT INTO ptp_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Om Yesu he nue ngɨvihi, heche va la lec dipac dɨ mɨla vac vɨgwe wê xomxo ti o dô vac ge lêm. ");
INSERT INTO ptp_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Lêc xomxo tɨbeac yê wê he la ge dɨ xovô he om xomxo vac vɨgwe buhu toto ge tup mɨ la ên nêb he ob la vac vɨgwe ti wê Yesu he nue ngɨvihi obêc mɨla vac ge. Om he mug la tax, ");
INSERT INTO ptp_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","dêc Yesu he nue mɨla tɨmuên, mêd he lop vêl ên dipac dɨ Yesu yê wê xomxo tɨbeac val dô ge om xo vɨgwe pɨsiv ên he, ên he dô tɨyi xocbê bwoc sipsip wê ma ti o viac he ge lêm om Yesu nêl kɨyang tɨbeac vô he. ");
INSERT INTO ptp_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Mêd hɨyôv hoo la dɨ vɨgwe huc om nue ngɨvihi la nêl vô Yesu ên nêbê, “Vɨgwe ga, vɨgwe mahɨgun pɨleva ti dɨ hɨyôv hoo la gwêba, ");
INSERT INTO ptp_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","om ông vông xomxo i loc vac vɨgwe vɨyang vɨyang ên loc kɨsuu xen yaên wê ob ya ge.” ");
INSERT INTO ptp_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Lêc Yesu nêl vô he ên nêbê, “Xacxam va vông yaên vô he ên he i ya.” Lêc he nêl vô i ên nêbê, “Obêc bêna? Ông nêb xe la kɨsuu blet lec mone yul yuu mɨ lôm vông vô he ên he i ya, me?” ");
INSERT INTO ptp_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Mêd Yesu kɨnêg lax vô he ên nêbê, “Blet vaba dô? Xam loc wê lê.” Om he lax yê dɨ vena nêl ên nêbê, “Blet vɨgê vɨlu dɨ beac nôn yuubed dô.” ");
INSERT INTO ptp_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Om Yesu nêl vô he ên nêbê, “Xam tô mɨ dô kɨbun lec hɨsinac dɨ xam dô kɨdu kɨdu.” ");
INSERT INTO ptp_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Om he tô mɨ dô kɨdu kɨdu lêc ya dô tɨyi xocbê 100 dɨ ya dô tɨyi xocbê 50. ");
INSERT INTO ptp_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Mêd Yesu hôm blet vɨgê vɨlu ge hɨxôn beac yuu ge dɨ lax ma la lag kɨsiinê dɨ kɨtaa lec blet yuu beac, mêd hɨbu blet dɨ vông vô nue ngɨvihi ên nêb he i tɨtang vô xomxo tigee. Nang dêc hɨbu beac dɨ vông vô nue nêb he i tɨtang vô xomxo tigee hɨxôn mɨ he ya. ");
INSERT INTO ptp_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Om xomxo vɨhati ya i den he, ");
INSERT INTO ptp_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","lêc blet yuu beac wê gên dô ge nue ngɨvihi su vac sepac vɨgê yuu dɨ tô mɨ la yuu mɨ i pup lec. ");
INSERT INTO ptp_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Xomxo wê dô mɨ ya gee, he vux tɨyi xocbê 5,000 ge. ");
INSERT INTO ptp_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Yesu nêl vô nue ngɨvihi nêb he i lec dipac dɨ loc mug mɨ loc vɨgwe Betsaida wê yêp mia luaên vɨlu ganê. Om he loc mɨ la dɨ Yesu dô ên nêb ob vông xomxo tigee i lôc ben vêl lê. ");
INSERT INTO ptp_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","He la vêl mêd Yesu loc mɨ la lec kɨtôn ên nêb ob la kɨtaa. ");
INSERT INTO ptp_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Mêd vɨgwe buc dɨ dipac wê nue ngɨvihi dô lec ge mɨla le vac mia luaên mahɨgun, dɨ Yesu vaci gên dô vô mia luaên nɨnya, ");
INSERT INTO ptp_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","dɨ yê wê lea levac hôm dipac xôn hɨxôn nue ngɨvihi om he vông yuac levac lec hɨsooên mia lêc dipac o vyac la lêm, dɨ vô kwabo lec wê vɨgwe ob vɨdii ge mêd Yesu lam lec mia kɨsii dɨ val vô nue ngɨvihi dɨ vông xocbê ob luu he vêl mɨ la ge. ");
INSERT INTO ptp_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Lêc nue ngɨvihi vɨhati yê wê Yesu lam lec mia kɨsii mɨ val ge om he so ên he nêb mêd xomxo wê yibên ge ti kɨnu val vô he, om he iac ");
INSERT INTO ptp_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","dɨ xona mabu. Lêc lutibed Yesu nêl vô he ên nêbê, “Xam xonaên i ma dɨ xam xêmyaa i vô nivɨha, ên ga a.” ");
INSERT INTO ptp_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Mêd Yesu lec la lec dipac hɨxôn he dɨ lea tip la. Lêc nue ngɨvihi yetac mabu, ");
INSERT INTO ptp_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","ên he o xovô môp wê Yesu vông blet vô tɨbeac vɨhevage lêm, ên he nɨlô yen xêkɨzêc om he vyac xovôên ma. ");
INSERT INTO ptp_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Mêd Yesu he nue ngɨvihi la lec dipac la mia luaên vɨlu ganê dɨ la vac vɨgwe Genesalet, dɨ ku dipac xôn mɨ i yêp ");
INSERT INTO ptp_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","dɨ he lop mɨ la, lêc lutibed xomxo vac vɨgwe tige xovô Yesu, ");
INSERT INTO ptp_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","om he tup mɨ la vac vɨgwe tigee vɨhati dɨ la ken lie wê yidac ge lec pêt mɨ la vac vɨgwe wê Yesu la dô vac ge. ");
INSERT INTO ptp_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Om Yesu ob la vac vɨgwe levac ti me nipwo ti me vɨgwe mahɨgun ti ge od xomxo ken lie yidac mɨ la lii lec wetôv dɨ kɨtaa Yesu nêb he ob hôm lec vɨnyumên wê i vông ge myahɨpu ên yidac i ma ên he, om he wê hôm vɨgê lec vɨnyumên wê Yesu vông ge he vɨhati vô nivɨha lec. ");
INSERT INTO ptp_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","He Palisi hɨxôn xomxo wê xovô Moses xolac ge wê he ben Jelusalem ge, he ya kɨtucma mɨ la vô Yesu, ");
INSERT INTO ptp_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","lêc yê wê Yesu nue ngɨvihi ya yaên lêc he o lipac vɨgê tɨyi xocbê môp wê he Yuda mi vông ge lêm. Om he nêl ên he nêbê he ya ya vɨgê ningeac. ");
INSERT INTO ptp_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Ên he Palisi hɨxôn Yuda vɨhati, he mi tɨmu vô môp wê bue ilage vông ge bêga nêbê xomxo obêc lipac vɨgê tɨyi xocbê môp wê bue mi vông ge pyap dɨ ya yaên tɨmuên. Lêc lipacên obêc ma ge od ob ya yaên lêm. ");
INSERT INTO ptp_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Dɨ he ob la kɨsuu yaên vac maket ge od ob vena lipac pyap lêc ya tɨmuên. Dɨ he mi tɨmu vô môp wê bue vông ge tɨbeac hɨxôn, xocbê môp wê ob lipac kap yuu pɨle hɨxôn dêg ge. ");
INSERT INTO ptp_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","He vông môp bêge om Palisi hɨxôn xomxo wê xovô Moses xolac gee nêl vô Yesu ên nêbê, “Bêna lêc ông nume sea môp wê buge vông ge dɨ ya hɨxôn vɨgê ningeacê?” ");
INSERT INTO ptp_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Lêc Yesu nêl vô he ên nêbê, “Kɨyang wê plopet Aisaia kɨvuu ilage nêl nôn lec xam xomxo kɨtyooên dɨ i yêp bêga nêbê, ‘Xomxo tigee pɨmil a ya mya pɨleva, lêc he nɨlô le teva ên a. ");
INSERT INTO ptp_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","He mi nêl kɨyang wê xomxo vaci xovô ge, lêc he nêl ên he nêbê he nêl Anutu kɨyang, om he yev vɨxa kɨtu vô a pɨsiv.’ ");
INSERT INTO ptp_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Om a nêl vô xam bêga bê xam sea Anutu xolac la yêp xel dɨ la tɨmu vô môp wê xomxo vaci mi vông ge.” ");
INSERT INTO ptp_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Dɨ Yesu nêl hɨxôn vô he ên nêbê, “Tyac xam so ên xam nêb môp wê xam sea Anutu xolac dɨ la tɨmu vô bume môp ge ob vô nivɨha vô xamê? ");
INSERT INTO ptp_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Ên xolac wê Moses nêl ge bêga nêbê, ‘Xam hôm tame mame lê lec dɨ ngô he kɨyang’, dɨ kɨyang ngwe nêl ên nêbê, ‘Xomxo ti obêc nêl kɨyang nipaên lec ta yuu ma ge od xomxo i hi i yib.’ ");
INSERT INTO ptp_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Anutu xolac nêl bêge, lêc xam mi nêl ên xam nêbê xomxo ti nên susu wê ob ngɨdu ta yuu ma xôn ya ge obêc dô, lêc xomxo tige obêc nêl vô yuu ên nêbê, ‘Susu tige a nêl pyap ên a nêb a ob vông vô Anutu, om muu nêm ob ma.’ ");
INSERT INTO ptp_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Om môp tige tɨyi xocbê xam le vac môp wê xomxo tige ob ngɨdu ta yuu ma xôn ge. ");
INSERT INTO ptp_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Om môp wê xam tɨmu vô bume vông xolac mɨ hôm xôn mɨ i yêp ge tɨyi xocbê xam kɨtya Anutu xolac vêl. Lêc xam mi vông môp tibêge tɨbeac hɨxôn.” ");
INSERT INTO ptp_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Yesu keac xomxo lam vô i dɨ nêl vô he vɨhati ên nêbê, “Xam vɨhati ngô kɨyang wê a ob nêl ge dɨ xovô lê. ");
INSERT INTO ptp_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Susu wê ob la vac xomxo nɨlô ge o tɨyi wê ob vông he vô nipaên ge lêm. Lêc susu wê yêp vac xomxo nɨlô dɨ lop mɨ lam seac ge wê ob vông he vô nipaên. ");
INSERT INTO ptp_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Xam nɨnyam obêc yêp ge od xam ngô nêm dɨ xovô.” ");
INSERT INTO ptp_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Mêd Yesu sea xomxo tigee dɨ la xumac lôma, lêc nue ngɨvihi la kɨnêg kɨyang pɨlepacên tige kehe vô i. ");
INSERT INTO ptp_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Om Yesu nêl vô he ên nêbê, “Ên xam êno, xam lungên kɨyang tige kehe? Susu wê xomxo ob ya mɨ i la vac he nɨlô ge o tɨyi wê ob vông he vô nipaên ge lêm, lêc mêd xam lungên tige? ");
INSERT INTO ptp_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Susu yaên ob vông xomxo vô nipaên lêm, ên ob la vac he pɨyôp yuu xovôên hɨxôn lêm. Nge, ob la dô vac xêyaa dɨ lop mɨ la vêl.” Yesu kɨyang tige nêl ên nêbê susu yaên vɨhati nivɨha tɨyi wê xomxo ob ya ge. ");
INSERT INTO ptp_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Dɨ Yesu nêl vô he ên nêbê, “Kɨyang wê yêp vac xomxo nɨlô lêc lop mɨ lam vɨxun ge wê ob vông he vô nipaên. ");
INSERT INTO ptp_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Ên kɨyang nipaên wê yêp vac xomxo nɨlô lêc lam le seac ge bêga nêbê xovôên nipaên, môp yôdac vêx yuu vux, vunên xomxo susu yôdac, hiên xomxo yib, ");
INSERT INTO ptp_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","vông môp iimaên vô nipaên, môp madoên, môp nipaên yaya, nêl kɨyang kɨtyooên, vông môp vaxvax, yê xomxo nipaên, nêl kɨyang nipaên lec xomxo, yong he, dɨ vông môp vaxvax tɨyi xocbê pɨyôp nivɨha ti o yêp vô he lêm. ");
INSERT INTO ptp_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Môp nipaên tigee wê mi yêp vac xomxo nɨlô, om obêc lop mɨ lam vɨxun ge od ob vông xomxo vô nipaên.” ");
INSERT INTO ptp_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Yesu sea vɨgwe tige dɨ loc mɨ la vɨgwe ti wê yêp kwabo vô Taia ge, mêd la dô vac xumac ti ên nêb ob dô dɨ xomxo yêên i i ma, lêc o tɨyi wê ob dô xôpacên ge lêm. ");
INSERT INTO ptp_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","Mêd vêx ti wê vɨmwo nipaên dô vac i nu vêx ge ngô wê Yesu lam dô vac xumac tige. Vêx tige o vêx Yuda lêm. Nge, i tɨbii Pinisia ti wê i ben vɨgwe kehe Silia ge. Lêc la vô Yesu dɨ la yev vɨxa kɨtu vô dɨ kɨtaa i ên nêbê i tii vɨmwo nipaên vêl ên nu vêx. ");
INSERT INTO ptp_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Lêc Yesu nêl vô i ên nêbê, “Il ob vông yaên vô nipwo mɨ he ya vêl lê, ên o tɨyi wê il ob kô nipwo xen yaên mɨ nêx i loc vô noo ge lêm.” ");
INSERT INTO ptp_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Lêc vêx tyo nêl ên nêbê, “Xomxo levac, ông nêl kɨyang nôn. Lêcom myapɨpu wê tô mɨ la dô vac tevol kwa ngɨbi ge, noo ya.” ");
INSERT INTO ptp_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Om Yesu nêl vô i ên nêbê, “Kɨyang wê ông nêl ge nivɨha, om ông lôc bom, ên vɨmwo nipaên sea num gwêba dɨ i vô nivɨha lec.” ");
INSERT INTO ptp_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Mêgem vêx tyo lax mɨ la ben dɨ yê wê nu tyo dɨyêp lec pêt ge dɨ xovô nêbê vɨmwo nipaên sea i dɨ la. ");
INSERT INTO ptp_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Yesu sea vɨgwe Taia ên nêb ob la mia luaên Galili, om la Saidon dɨ la Dekapolis dɨ mɨla mia luaên Galili. ");
INSERT INTO ptp_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Lêc xomxo kô vux ti wê nɨnya vô kɨtu dɨ vyac keacên ma ge mɨ la vô Yesu, dɨ kɨtaa Yesu nêb Yesu i vyax vɨgê lec xomxo tige ên i vô nivɨha lec. ");
INSERT INTO ptp_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Om Yesu kô xomxo tige mɨ yuu la le vɨyonên mêd Yesu kɨtiv vɨgê lɨyihi la vac xomxo tyo nɨnya vɨlu vɨlu, mêd pɨsuv myaluc lec vɨgê dɨ kɨtiv lec xomxo tyo get. ");
INSERT INTO ptp_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Mêd Yesu lax ma la lag kɨsii dɨ vê myakɨlôhô xêkɨzêc dɨ nêl vô xomxo tyo ên nêbê, “Epata.” Kɨyang tige kehe bêga nêbê, “Nɨnyam i toc dɨ ông ngô vɨgwe.” ");
INSERT INTO ptp_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Mêgem xomxo tige nɨnya toc dɨ i ngô kɨyang dɨ get vô vɨyin maên dɨ i keac nivɨha. ");
INSERT INTO ptp_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Lêc Yesu vɨbu xomxo tigee xêkɨzêc ta ên nêb he i o lêc nêl tige kɨtong vô xomxo ya lêm. Yesu nêl kɨyang tige tii vac vac vô he, lêc he o ngô lêm dɨ he la nêl kɨyang tige vô levac vô xomxo mɨ he ngô hɨxôn, ");
INSERT INTO ptp_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","om he yetac mabu dɨ nêl ên nêbê, “Môp wê i vông ge vɨhati nivɨha, dɨ ici va tɨyi wê ob vông xomxo nɨnya kɨtu, he nɨnya i toc ên he i ngô kɨyang, dɨ vông xomxo wê yac ge he i keac nivɨha.” ");
INSERT INTO ptp_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Vô buc ti nang xomxo tɨbeac kɨtucma vô Yesu mɨ dô hɨxôn i, lêc he xen yaên wê he ob ya ge ma, om Yesu nêl nue ngɨvihi lam dɨ nêl vô he ên nêbê, ");
INSERT INTO ptp_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“A xo vɨgwe pɨsiv ên xomxo tigae, ên he lam dô hɨxôn a tɨyi buc yon dɨ he xen yaên wê he ob ya ge ma, ");
INSERT INTO ptp_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","om he obêc dô vip dêc a vông he lax mɨ la ge od vip ob vông he vɨgê yuu vɨxa ma vac môp, ên he ya lam vac vɨgwe teva.” ");
INSERT INTO ptp_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Lêc nue ngɨvihi nêl vô i ên nêbê, “Om il ob la kô yaên gê na ên vông vô xomxo tigae mɨ he i ya? Ên vɨgwe ga, vɨgwe myadongên.” ");
INSERT INTO ptp_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Om Yesu kɨnêg vô he ên nêbê, “Xam blet vaba dô?” Dɨ he nêl ên nêbê, “Xe blet vɨgê vɨlu dɨ sec yuu dô.” ");
INSERT INTO ptp_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Om Yesu nêl vô xomxo tigee vɨhati ên nêb he i tô mɨ dô kɨbun, mêd hôm blet vɨgê vɨlu dɨ sec yuu ge dɨ kɨtaa lec mêd hɨbu dɨ vông vô nue ngɨvihi ên nêb he i tɨtang vô xomxo, om nue ngɨvihi kô mɨ la tɨtang vô he vɨhati. ");
INSERT INTO ptp_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Dɨ beac nipwo ya dô om Yesu kɨtaa lec dɨ vông vô nue ngɨvihi ên nêb he i loc tɨtang vô xomxo tigee ên he i ya hɨxôn. ");
INSERT INTO ptp_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Mêd xomxo tigee ya i tɨyi he dɨ myapɨpu dô om he tung vac sepac vɨgê vɨlu dɨ sec yuu mɨ i pup lec. ");
INSERT INTO ptp_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Xomxo tigee tɨyi xocbê 4,000 ge. Pyap dɨ Yesu vông he lax mɨ la ben, ");
INSERT INTO ptp_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","dɨ lutibed Yesu he nue ngɨvihi loc mɨ la lec dipac dɨ la vɨgwe Dalmanuta. ");
INSERT INTO ptp_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Palisi ya val vô Yesu, ên nêb ob yaxên i, om la nga ên kɨyang wê Yesu nêl ge dɨ nêl nêb Yesu i vông do lag puunê ti hɨxôn ên he ob yê. ");
INSERT INTO ptp_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Om Yesu nɨlô vô vɨyin dɨ i nêl ên nêbê, “Bêna lêc xomxo gwêbaga nêl nêb he ob yê do levacê? A nêl hɨxôn nôn vô xam bêga bê xomxo wê dô gwêbaga ob yê do levac ti lêm.” ");
INSERT INTO ptp_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Mêd Yesu sea he dɨ la lec dipac dɨ loc mɨ la mia luaên Galili vɨlu ganê. ");
INSERT INTO ptp_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Yesu nue ngɨvihi la hɨxôn lêc he o xovô mɨ kô xen blet ti hɨxôn lêm, dɨ blet nôn tibed yêp vac dipac. ");
INSERT INTO ptp_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Mêd Yesu nêl kɨyang xêkɨzêc vô he ên nêbê, “Xam xona nêm ên yis wê he Palisi hɨxôn Helot vông ge.” ");
INSERT INTO ptp_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Mêd Yesu nue ngɨvihi nêl vôma, ên he so ên he nêb mêd Yesu nêl kɨyang tige lec he xen blet wê ma ge. ");
INSERT INTO ptp_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Lêc Yesu xovô kɨyang wê he nêl vôma ge om nêl vô he ên nêbê, “Bêna lêc xam nêl ên xam nêbê xam xom blet ma? Mêd xam gên o xovô lêmê? Xam nɨlôm xêkɨzêc ên vatya? ");
INSERT INTO ptp_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Xam mamnôn yêp lêc mêd xam o wê lêm? Dɨ xam nɨnyam yêp lêc mêd xam o ngô kɨyang lêm? Dɨ yuac wê a vông vac xam mahɨgun ge, xam mêd lungên? ");
INSERT INTO ptp_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Om buc wê a hɨbu blet vɨgê vɨlu dɨ vet xomxo 5,000 ya ge, od xam su myapɨpu vac sepac vaba?” Om he nêl ên nêbê, “Sepac vɨgê yuu dɨ tô mɨ la yuu.” ");
INSERT INTO ptp_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Mêd Yesu nêl nang ên nêbê, “Dɨ buc wê a hɨbu blet vɨgê vɨlu dɨ sec yuu dɨ vet xomxo 4,000 ya ge od xam su myapɨpu vac sepac vaba?” Mêd he nêl ên nêbê, “Sepac vɨgê vɨlu dɨ sec yuu.” ");
INSERT INTO ptp_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Om Yesu nêl vô he ên nêbê, “Xam gên o xovô tige lêmê?” ");
INSERT INTO ptp_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","He mɨla vɨgwe Betsaida mêd xomxo kô vux wê manôn toc ge ti mɨ la vô Yesu dɨ la kɨtaa Yesu nêb i vyax vɨgê lec i ên manôn i seac. ");
INSERT INTO ptp_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Om Yesu la hôm lec xomxo tige vɨgê dɨ dɨdii i mɨ yuu la nɨnyawehe, mêd Yesu pɨsuv myaluc lec xomxo tyo manôn dɨ vyax vɨgê lec dɨ kɨnêg ên nêbê, “Ông mamnôn seac mɨ ông wê susu ya?” ");
INSERT INTO ptp_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Mêd xomxo tyo yê ma la dɨ nêl vô Yesu ên nêbê, “A xê xomxo lê, lêc a xê he tɨyi xocbê xax wê vô vɨdeba vɨdeba mɨ lam ge dɨ a o xêvô he nôn lêm.” ");
INSERT INTO ptp_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Mêd Yesu vyax vɨgê lec xomxo tyo manôn tii vac mêd xomxo tyo yê vɨgwe xêkɨzêc dɨ manôn vô nivɨha lec om i yê vɨgwe vɨhati yêp seac. ");
INSERT INTO ptp_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Mêd Yesu nêl vô i ên nêbê, “Ông lôc vac bom bôbac dɨ ông o lêc loc vɨgwe Betsaida lêm.” ");
INSERT INTO ptp_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Yesu he nue ngɨvihi loc mɨ la, nêb ob la vɨgwe Sisalia Pilipai om he mɨla môp ti, lêc Yesu kɨnêg vô nue ngɨvihi ên nêbê, “Xomxo mi nêb a letya?” ");
INSERT INTO ptp_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Om he nêl vô i ên nêbê, “Xomxo ya nêbê ông ge Jon Lipacên, dɨ ya nêbê ông plopet Ilaija, dɨ ya nêbê ông plopete ti.” ");
INSERT INTO ptp_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Om Yesu kɨnêg vô he ên nêbê, “Dɨ xacxam va nêb a letya?” Mêd Pita nêl ên nêbê, “Ông Kɨlisi ti wê Anutu vông ông lam ên nêb ông lam ngɨdu xomxo xôn ge.” ");
INSERT INTO ptp_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Mêgem Yesu vɨbu he nêb he i o lêc nêl i kɨtong vô xomxo lêm. ");
INSERT INTO ptp_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Yesu nêl kɨyang vô nue ngɨvihi ên nêbê, “A, Xomxo Nu, a obêc kô myavɨnê levac mabu, dɨ Yuda levac hɨxôn xomxo levac wê mi si daa vô Anutu gee dɨ xomxo wê xovô Moses xolac gee, he obêc vô nɨmi vô a dɨ hi a xib, dɨ buc yon obêc lam la vêl dɨ a obêc kɨdi lec magvɨha i tii vac.” ");
INSERT INTO ptp_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Yesu nêl kɨyang tige seac vô he om Pita kô Yesu mɨ yuu la dô vɨyonên, mêd Pita nêl xêkɨzêc vô Yesu ên nêb i nêlên kɨyang tibêge i ma. ");
INSERT INTO ptp_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Lêc Yesu pɨlepac manôn lax vô nue ngɨvihi dɨ nêl xêkɨzêc vô Pita ên nêbê, “Seten, ông loc vêl. Ên xovôên wê ông vông ge o tɨyi xocbê xovôên wê Anutu vông ge lêm. Nge, xovôên wê ông vông ge tɨyi xocbê xovôên wê xomxo kɨbun ga vông ge.” ");
INSERT INTO ptp_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Yesu keac nue ngɨvihi hɨxôn xomxo tɨbeac ên nêb he i loc vô i, om nêl vô he ên nêbê, “Xomxo ti obêc nêb tɨmu vô a vɨxag ge od i vông i vô nipwo lec dɨ kɨlê vɨyin i tɨyi xocbê kɨlê xax pola ge dɨ tɨmu vô a vɨxag. ");
INSERT INTO ptp_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Ên xomxo ti obêc nêb viac ninɨvi ên vɨyin yuu yibên ge od mavɨha wê i vông ge xôa obêc ma, lêc xomxo ti obêc sea ninɨvi lec a lêg yuu xolac ge od ob dô mavɨha. ");
INSERT INTO ptp_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Ên xomxo ti obêc kɨtuc susu kɨbun ga vɨhati tu ixe, lêc obêc sea môp wê ob dô mavɨha ya ge od ob vô nivɨha vô i tibêna? ");
INSERT INTO ptp_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Dɨ xomxo obêc vông vatya ên kɨsuu mavɨha wê ob dô ya ge? ");
INSERT INTO ptp_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Xomxo gwêbaga sea Anutu dɨ la vac môp nipaên, om xomxo ti vac he mahɨgun obêc vô nɨmi vô a hɨxôn a kɨyang ge od a, Xomxo Nu, a êno obêc vô nɨmig vô i lec buc wê a obêc lop mɨ lôm hɨxôn angela ngɨbua dɨ lam hɨxôn xêseac wê Mag vông ge.” ");
INSERT INTO ptp_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Mêd Yesu nêl vô he ên nêbê, “A nêl hɨxôn nôn vô xam bêga bê xam wê xam le ga, xam ya obêc dô mamvɨha dɨ wê xolac wê Anutu ben kɨsiinê ge obêc val hɨxôn xêkɨzêc.” ");
INSERT INTO ptp_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Buc vɨgê vɨlu dɨ sec ti lam la vêl mêd Yesu kô Pita yuu Jems yon Jon dɨ he la lec kɨtôn dia ti, dɨ heche va la dô, lêc yon yê wê Yesu ninɨvi pɨkwê mɨ vô bangwe, ");
INSERT INTO ptp_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","dɨ i ngakwi vô kwem vɨvea lecên luu ngakwi kɨbun ga wê xomxo lipac i vô kwem ge vêl. ");
INSERT INTO ptp_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Mêd yon yê wê Moses yuu Ilaija val keac hɨxôn Yesu ge. ");
INSERT INTO ptp_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Om Pita nêl vô Yesu ên nêbê, “Xolac kehe, ga nivɨha wê il dô ga, om xen ob lox xumac yon, ti vô ông, dɨ ngwe vô Moses dɨ ti vô Ilaija.” ");
INSERT INTO ptp_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Pita nêl bêge pɨleva, ên yon xona mabu om Pita o xovô kɨyang wê ob nêl ge lêm. ");
INSERT INTO ptp_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Mêd vɨyobtoc ti lam hɨvun he xôn, dɨ vya ti lam vac vɨyobtoc dɨ nêl ên nêbê, “Ge a nug wê a xêgyaa vin lec i ge om xam ngô i vya.” ");
INSERT INTO ptp_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Lêc lutibed yon yê ma la wê Yesu vaci le dɨ yuu xôa ma ge. ");
INSERT INTO ptp_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","He sea vɨgwe kɨtôn dɨ lax mɨ la, lêc Yesu vɨbu yon ên nêbê, “Mon o lêc nêl wê mon wê ge kɨtong vô xomxo ti lêm dɨ i loc vô buc wê a, Xomxo Nu, a obêc kɨdi lec vac yibên ge lê.” ");
INSERT INTO ptp_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Om yon hôm kɨyang tige xôn mɨ i yêp vô yon, lêc bo ti wê Yesu nêl ên nêb ob kɨdi lec vac yibên ge, yon ngô lê, lêc yon o xovô kehe lêm om yon keac lec. ");
INSERT INTO ptp_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Mêd yon kɨnêg vô Yesu ên nêbê, “Xomxo wê xovô Moses xolac gee mi nêl ên he nêbê Ilaija obêc val tax dɨ Kɨlisi obêc val tɨmuên, om he nêl tibêge ên va?” ");
INSERT INTO ptp_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Om Yesu nêl vô yon ên nêbê, “Vɨxôhɨlôg, Ilaija ge wê ob val mug ên vông môp yuu kɨyang i vô nivɨha lec lê. Lêc bêna lêc kɨyang yêp vac xolac hɨxôn bêga nêbê Xomxo Nu obêc kô myavɨnê mabu dɨ xomxo obêc yê i nipaên dɨ vô nɨmi vô i hɨxôn? ");
INSERT INTO ptp_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","A nêl vô xam bê Ilaija val pyap, lêc xomxo vông môp nipaên vô i tɨyi xovôên wê he vông ge, tɨyi xocbê kɨyang wê plopete kɨvuu lec i mɨ i yêp vac kɨpihac ge.” ");
INSERT INTO ptp_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Yesu hɨxôn nue ngɨvihi yon ge mɨlax vô nue vɨhati, lêc yê wê xomxo tɨbeac kɨtucma mɨ lam dô hɨxôn nue ngɨvihi ge, dɨ xomxo wê xovô Moses xolac gee val dô hɨxôn dɨ he hɨxôn Yesu nue ngɨvihi kɨnêgma lec kɨyang. ");
INSERT INTO ptp_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Mêd xomxo vɨhati gee yê Yesu dɨ yetac mabu om tup mɨ la vô i dɨ la nêl vɨdiiên vô i. ");
INSERT INTO ptp_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Mêd Yesu kɨnêg vô nue ngɨvihi ên nêbê, “Xam dɨkeac lec kɨyang vatya?” ");
INSERT INTO ptp_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Mêd xomxo ti kɨdi vac he mahɨgun dɨ nêl ên nêbê, “Xolac kehe, a kô a nug vux tiga mɨ lam vô ông, ên vɨmwo nipaên dô vac i nɨlô om vông i dô yac dɨ keacên ma, ");
INSERT INTO ptp_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","dɨ buc wê vɨmwo nipaên tyo ob vông yuac vac i nɨlô ge od hôm i xôn dɨ nêx i lec kɨbun dɨ mya ngɨmong lam vac mya dɨ i kic nɨvu lecma, dɨ ninɨvi vô xêkɨzêc lec. Om a kɨtaa nume ngɨvihi ên a nêb he i tii vɨmwo nipaên tige i loc vêl lê, lêc he tɨyiên ma.” ");
INSERT INTO ptp_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Mêd Yesu nêl vô he vɨhati ên nêbê, “Xam vêx yuu vux gwêbaga, vông vinên wê xam vông ge nôn ma. Om a ob dô hɨxôn xam dɨ i mɨloc vô buc tina lê, lêc xam vông i vinê? Dɨ a ob kɨlê vɨyin wê xam vông ge dɨ i mɨloc buc tina lê? Loc kô num tige mɨ lam.” ");
INSERT INTO ptp_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Om he la kô nu tige mɨ lam vô i, lêc vɨmwo nipaên wê dô vac nu tyo nɨlô ge yê Yesu om lutibed vông yuac makɨkun vac nu tyo nɨlô dɨ nêx i lec kɨbun dɨ vông i vô lɨyil lɨyil dɨ mya ngɨmong lam vac mya. ");
INSERT INTO ptp_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Mêd Yesu kɨnêg vô nu tige ma ên nêbê, “Vɨmwo nipaên tige dô vac num tige tɨyi klismas vaba?” Lêc xomxo tyo nêl vô Yesu ên nêbê, “Vô buc wê i gên nipwo. ");
INSERT INTO ptp_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Om buc tɨbeac vɨmwo nipaên nêx i la vac ngwax dɨ nêx i la vac mia ên nêb ob hi i yib. Om a kɨtaa ông bê ông obêc tɨyi ge od ông xo vɨgwe pɨsiv ên xii dɨ ngɨdu i xôn.” ");
INSERT INTO ptp_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Lêc Yesu nêl vô i ên nêbê, “Ông nêl ên ông nêbê mêd a obêc tɨyi? Lêc a nêl vô ông bê xomxo ti obêc vông i vin ge od tɨyi wê ob vông môp vɨhati ge.” ");
INSERT INTO ptp_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Mêd lutibed xomxo tige nêl ên nêbê, “A vông i vin, lêc a o vông i vin xêkɨzêc lêm, om ông ngɨdu vông vinên wê a vông ge xôn.” ");
INSERT INTO ptp_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Yesu yê wê xomxo tɨbeac val dô dɨ dɨval valên om nêl kɨyang xêkɨzêc vô vɨmwo nipaên ên nêbê, “Ông vɨmwo nipaên wê ông vông xomxo tiga nɨnya vô kɨtu dɨ keacên ma ge, a nêl vô ông bê ông lam lop mɨ loc vɨxun vêl ên nu tiga, dɨ ông o lêc lôc mɨ loc vac i nɨlô i tii vac lêm.” ");
INSERT INTO ptp_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Mêd vɨmwo nipaên iac mabu dɨ hi nu tyo lec kɨbun sea, dɨ sea i dɨ lam la vêl. Mêd nu tyo yêp tɨpiên ma tɨyi xocbê xomxo yibên om xomxo tɨbeac so ên nêb mêd nu tyo yib. ");
INSERT INTO ptp_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Lêc Yesu la hôm lec i vɨgê dɨ vông i le kɨsii. ");
INSERT INTO ptp_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Pyap dêc Yesu lax mɨ la xumac lôma dɨ lax dô hɨxôn nue ngɨvihi lêc nue kɨnêg vô i ên nêbê, “Bêna lê lêc xe mô o tɨyi wê xe ob tii vɨmwo nipaên tige vêl lêmê?” ");
INSERT INTO ptp_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Lêc Yesu nêl vô he ên nêbê, “Kɨtaaên tibed ge wê ob tii vɨmwo nipaên tibêge vêl, dɨ môp baba ge ti o tɨyi lêm.” ");
INSERT INTO ptp_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Yesu he nue ngɨvihi sea vɨgwe tige dɨ loc mɨ la vac vɨgwe Galili, lêc Yesu nêb xomxo i o lêc xovô vɨgwe wê he ob la vac ge lêm, ");
INSERT INTO ptp_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","ên Yesu nêb ob nêl kɨyang vô nue ngɨvihi vaci, om tɨxuu he ya kɨyang bêga nêbê, “Xomxo ob vông Xomxo Nu la vac tɨbii vɨgê dɨ he ob hi i yib, lêc buc yon obêc lam la vêl ge od obêc kɨdi lec mavɨha tii vac nang.” ");
INSERT INTO ptp_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Yesu nêl bêge lêc nue ngɨvihi lungên kɨyang tige kehe dɨ xona om he o kɨnêg kɨyang tyo kehe vô Yesu lêm. ");
INSERT INTO ptp_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","He mɨla Kapaneam dɨ la dô vac xumac lôma, lêc Yesu kɨnêg vô nue ngɨvihi ên nêbê, “Xam nêl kɨyang vatya vôma vac môpê?” ");
INSERT INTO ptp_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Lêc he dô xôa maên, ên buc wê he lam vô môp ge od he ngaênma ên nêb mêd letya obêc tu he nên mugênê? ");
INSERT INTO ptp_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Om Yesu tô mɨ dô dɨ keac nue ngɨvihi vɨgê yuu dɨ tô mɨ la yuu lam vô i dɨ nêl vô he ên nêbê, “Xomxo ti obêc nêb tu mugên ge od i loc le tɨmuên dɨ vông yuac wê ob ngɨdu lie vɨhati xôn ge.” ");
INSERT INTO ptp_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Mêd Yesu la kô nipwo ti mɨ lam vac he mahɨgun, dêc kɨva nipwo tyo lec dɨ nêl vô nue ngɨvihi ên nêbê, ");
INSERT INTO ptp_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Xomxo ti obêc hôm nipwo tibêga lec ên wê vông i vin a lêg ge od ge tɨyi xocbê hôm a lec êno, dɨ xomxo ti wê hôm a lec ge od o tɨyi xocbê hôm aca va lec lêm. Nge, hôm xomxo ti wê vông a lam ge lec hɨxôn êno.” ");
INSERT INTO ptp_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Jon nêl vô Yesu ên nêbê, “Xolac kehe, xe xê xomxo ti tii vɨmwo nipaên vêl ên xomxo lec ông lêm, om xe vɨbu i ên xe nêb i vôngên tibêge i ma, ên xomxo tige o mi dô hɨxôn xe mɨ tɨmu vô ông lêm.” ");
INSERT INTO ptp_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Lêc Yesu nêl ên nêbê, “Xam o lêc vɨbu i lêm, ên xomxo ti obêc vông do levac lec a lêg ge od o tɨyi wê ob nêl kɨyang nipaên lec a decdec ge lêm. ");
INSERT INTO ptp_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Ên xomxo wê o vông vevac vô il lêm ge, ge tɨyi xocbê il nidpɨpu wê ob ngɨdu il xôn ge. ");
INSERT INTO ptp_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","A nêl hɨxôn nôn vô xam bê xomxo ti obêc vông mia numên vô xam ên wê xam vông i vin Kɨlisi ge od xomxo tige obêc kô nôn nivɨha lec tɨmuên. ");
INSERT INTO ptp_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Xomxo ti obêc vông nipwo tigee ti sea vông vinên wê i vông ge dɨ la vac môp nipaên ge od xomxo i nux ngɨdax lec i kwa dɨ nêx i loc vac gwec madia. ");
INSERT INTO ptp_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Dɨ ông vɨgêm vɨlu obêc dɨdii ông mɨ la vac nipaên ge od ông kɨtov vêl dɨ dô ya vɨgêm vɨlubed êdêc loc dô mamvɨha vac Anutu ben. Ên ông vɨgêm yuu xôn obêc dô ge od ob nêx ông la vac vɨgwe nipaên wê ngwax tum xuhu dia dɨ ob yib lêm ge. ");
INSERT INTO ptp_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Vac vɨgwe nipaên tige, myel vêê wê yibên obêc ma ge ob nga xomxo, dɨ ngwax dɨtum hɨxôn dɨ yibên ma. ");
INSERT INTO ptp_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Dɨ ông vɨxam vɨlu obêc dɨdii ông mɨ la vac môp nipaên ge od ông kɨtov vêl dɨ dô ya vɨxam vɨlubed êdêc loc dô mamvɨha vac Anutu ben. Ên ông vɨxam yuu xôn obêc dô ge od ob nêx ông la vac vɨgwe nipaên. ");
INSERT INTO ptp_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Vac vɨgwe nipaên tige, myel vêê wê yibên obêc ma ge ob nga xomxo, dɨ ngwax dɨtum hɨxôn dɨ yibên ma. ");
INSERT INTO ptp_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Dɨ ông mamnôn vɨlu obêc vông ông la vac môp nipaên ge od ông pɨsupac vêl dɨ dô ya mamnôn vɨlubed êdêc loc dô vac Anutu ben, ên mamnôn yuu xôn obêc dô ge od ob nêx ông la vac vɨgwe nipaên. ");
INSERT INTO ptp_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Vac vɨgwe nipaên tige, myel vêê wê yibên obêc ma ge ob nga xomxo, dɨ ngwax dɨtum hɨxôn dɨ yibên ma. ");
INSERT INTO ptp_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Ngwax obêc la lec xomxo vɨhati tɨyi xocbê xomxo hɨlee sol lec yaên ge. ");
INSERT INTO ptp_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Sol ge nivɨha, lêc sol obêc vô nyen maên ge od il obêc vô vatya vô ên i vô nyen i tii vac nangê? Sol i dô vac xam, dɨ xam dô hɨxôn lime dɨ xêmyaa i vin lec he.” ");
INSERT INTO ptp_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Yesu sea vɨgwe tige dɨ la vac vɨgwe levac Judia dɨ la vac vɨgwe ti wê yêp mia Jodan vɨlu ganê. Mêd xomxo tɨbeac val kɨtucma vô Yesu om Yesu nêl xolac vô he tɨyi môp wê mi vông ila ila ge. ");
INSERT INTO ptp_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Mêd Palisi ya val, nêb ob yaxên i om kɨnêg nêbê, “Môp wê xomxo ob sea vɨnê ge, xolac nêb môp tibêge tɨyi, me tɨyiên ma?” ");
INSERT INTO ptp_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Lêc Yesu kɨnêg lax vô he ên nêbê, “Xolac wê Moses vông ge nêbê va vô xamê?” ");
INSERT INTO ptp_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Om he nêl ên nêbê, “Moses nêl ên nêbê xomxo ti obêc nêb sea vɨnê ge od ob kɨvuu kɨpihac wê nêbê yuu ob seama ge dɨ vông vô vɨnê lê dêc yuu seama.” ");
INSERT INTO ptp_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Lêc Yesu nêl vô he ên nêbê, “Moses kɨvuu xolac tige vô xam ên wê xam nɨlôm yen xêkɨzêc ta ge. ");
INSERT INTO ptp_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Ên buc mugên ilage wê Anutu tung lag yuu kɨbun ge, od Anutu tung xomxo vêx yuu xôn vux. ");
INSERT INTO ptp_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Mêgem môp yêp bêga nêbê vux ob sea ta yuu ma dɨ la dô hɨxôn vɨnê, ");
INSERT INTO ptp_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","dɨ yuu ob tɨyi xocbê nôn tibed. Om yuu ob dô tɨyi xocbê nôn yuu ge lêm. Nge, yuu ob dô i tɨyi xocbê nôn tibed. ");
INSERT INTO ptp_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Mêgem môp wê Anutu vông yuu tu nôn tibed ge, xomxo i o lêc tax i tip lêm.” ");
INSERT INTO ptp_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","He lax xumac lôma lêc nue ngɨvihi kɨnêg kɨyang tige vô Yesu tii vac nang. ");
INSERT INTO ptp_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Om Yesu nêl vô he ên nêbê, “Vux ti obêc sea vɨnê dɨ la kô vêx paha ngwe ge od ge vông môp yôdac vêx yuu vux. ");
INSERT INTO ptp_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Dɨ vêx ti obêc sea lɨya dɨ la kô vux paha ngwe ge od vêx tige vông môp yôdac vêx yuu vux.” ");
INSERT INTO ptp_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Xomxo kô nue nipɨpwo mɨ la vô Yesu, ên nêb i vyax vɨgê lec he dɨ kɨtaa lec he, lêc Yesu nue ngɨvihi kunac he nêb he loc vôên Yesu i ma. ");
INSERT INTO ptp_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Lêc Yesu yê môp wê nue ngɨvihi vông ge dɨ xêyaa vô myavɨnê om nêl vô he ên nêbê, “Vông nipɨpwo i lam vô a dɨ le vac xônên i ma, ên xomxo tibêgee wê tu kehe ên vɨgwe kɨsiinê. ");
INSERT INTO ptp_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","A nêl hɨxôn nôn vô xam bêga bê xomxo ti obêc vông i vin Anutu xolac mɨ la vac i kwa ngɨbi tɨyi xocbê nipɨpwo tigae lêm ge od o tɨyi wê ob la dô vac Anutu ben ge lêm.” ");
INSERT INTO ptp_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Mêd Yesu kɨva nipɨpwo tigee dɨ vyax vɨgê lec he dɨ kɨtaa lec he. ");
INSERT INTO ptp_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Yesu loc mɨ la vô môp mɨ la, dɨ xomxo ti tup mɨ la vô i vac môp, dɨ la yev vɨxa kɨtu vô dɨ kɨnêg ên nêbê, “Xolac kehe nivɨha, a obêc vông bêna êdêc dô magvɨha luta lêc luta?” ");
INSERT INTO ptp_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Lêc Yesu nêl vô i ên nêbê, “Bêna lêc ông nêl nivɨha lec a? Xomxo nivɨha ti o dô lêm. Anutu vaci nôn tibed wê nivɨha. ");
INSERT INTO ptp_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Ông xovô Moses xolac pyap wê nêl ên nêbê, ‘Ông o lêc hi xomxo i yib lêm. Ông o lêc vông yôdac vêx yuu vux lêm. Ông o lêc vun xomxo ngwe susu lêm. Ông o lêc nêl kɨyang kɨtyooên lec xomxo ti lêm. Ông o lêc kɨtyoo xomxo dɨ vô he susu vêl lêm. Ông loc vac tam yuu mam vya kwa ngɨbi.’” ");
INSERT INTO ptp_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Om xomxo tyo nêl vô Yesu ên nêbê, “Xolac kehe, buc wê a gên nipwo dɨ i val tyip gwêbaga, a viac xolac gee vɨhati mɨ vông i vô nôn lec.” ");
INSERT INTO ptp_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Mêd Yesu yê i manôn dɨ xêyaa vin lec i, mêd nêl vô i ên nêbê, “Môp ti gên yêp wê ông ob vông hɨxôn ge. Ông loc vông susu wê ông vông ge vɨhati mɨ tɨbii i kɨsuu, dɨ ông vông mone vô xomxo wê nên susu maên ge, ên ông obêc vông bêge ge od ông obêc kô susu nôn nivɨha gê kɨsii ganê. Ông loc vông bêge dɨ lôm tɨmu vô a vɨxag.” ");
INSERT INTO ptp_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Xomxo tyo ngô kɨyang tige dɨ nɨlô vô vɨyin levac ên i susu tɨbeac. Om sea Yesu dɨ la. ");
INSERT INTO ptp_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Mêd Yesu manôn yê nue ngɨvihi dɨ nêl vô he ên nêbê, “Xomxo wê susu tɨbeac ge obêc nêb la vac Anutu ben ge od obêc vông yuac levac vô he.” ");
INSERT INTO ptp_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Yesu nue ngɨvihi ngô kɨyang tige dɨ yetac mabu. Lêc Yesu nêl tii vac vô he ên nêbê, “Xam nuge, xomxo obêc nêb la vac Anutu ben ge od yuac levac. ");
INSERT INTO ptp_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Bwoc kamel obêc la vac yin kɨtu tocên ge, od obêc yuac levac, dɨ xomxo wê susu tɨbeac ge obêc nêb la vac Anutu ben ge od obêc yuac levac luu vêl.” ");
INSERT INTO ptp_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Om Yesu nue ngɨvihi yetac mabu yocên dɨ nêl vô i ên nêbê, “Obêc tibêge ge od letya tɨyi wê obêc la dô mavɨha vac Anutu ben ge?” ");
INSERT INTO ptp_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Lêc Yesu yê manôn la bôbac vô he dɨ nêl ên nêbê, “Xomxo vaci o tɨyi lêm, dom Anutu vaci ge od tɨyi pyap. Ên môp vɨhati yang ge, Anutu tɨyi wê ob vông ge.” ");
INSERT INTO ptp_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Mêd Pita nêl vô Yesu ên nêbê, “Om wê lê. Xe ga, xe sea susu wê xe vông ge vɨhati dô dɨ lam tɨmu vô ông vɨxam.” ");
INSERT INTO ptp_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Mêd Yesu nêl ên nêbê, “A nêl hɨxôn nôn vô xam bêga bê xomxo ti obêc sea ben hɨxôn tae mae lie dɨ nue hɨxôn yuac yaên wê i vông ge ên wê nêb ob vông a lêg yuu xolac i vô levac ge, ");
INSERT INTO ptp_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","od xomxo tige obêc kô xumac hɨxôn yuac yaên tɨbeac dɨ tae mae lie dɨ nue tɨbeac gê kɨbun ga, lêc tɨbii obêc vông myavɨnê vô i hɨxôn, dɨ buc tɨmuên ge od obêc la dô mavɨha luta lêc luta. ");
INSERT INTO ptp_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Lêc xomxo mugên tɨbeac obêc lax mɨ la tɨmu, dɨ xomxo tɨmuên tɨbeac obêc lam la mug.” ");
INSERT INTO ptp_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Yesu he nue ngɨvihi loc mɨ la ên nêb ob la Jelusalem. Om he mɨla vac môp, lêc Yesu la mug dɨ nue ngɨvihi hɨxôn xomxo ya he tɨmu vô i vɨxa. Mêd nue ngɨvihi xo kɨyang tɨbeac, dɨ xomxo wê la hɨxôn gee, he xona. Mêgem Yesu kô nue ngɨvihi vɨgê yuu dɨ tô mɨ la yuu mɨ he la dô vɨyonên dɨ Yesu nêl vɨyin wê ob tulec i ge kɨtong vô he, ");
INSERT INTO ptp_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","om nêl ên nêbê, “Xam ngô lê. Il ob la Jelusalem, dɨ xomxo ob vông Xomxo Nu vac xomxo levac wê mi si daa gee hɨxôn xomxo wê xovô Moses xolac gee vɨgê, dɨ he ob vông kot vô i dɨ hɨlu kɨyang wê ob hi i yib ge xôn dɨ vông i la vac tɨbii wê o Yuda lêm gee vɨgê, ");
INSERT INTO ptp_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","mêd tɨbii tigee ob so vya vô i dɨ pɨsuv mya lec dɨ pɨsa ya yihi dɨ hi i yib, dɨ buc yon obêc lam la vêl ge od obêc kɨdi lec mavɨha nang.” ");
INSERT INTO ptp_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Sebedi nu yuu Jems yuu Jon la vô Yesu dɨ nêl vô ên nêbê, “Xolac kehe, xii ob kɨtaa susu ti vô ông, ên ông vông vô xii.” ");
INSERT INTO ptp_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Om Yesu nêl vô yuu ên nêbê, “Om muu nêb a vông bêna vô muuê?” ");
INSERT INTO ptp_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Mêd yuu nêl vô i ên nêbê, “Buc wê ông ob dô vac xêseac ge, od xii nêb ông vông lê levac vô xii dɨ xii ngwe ob dô vô ông vɨgêm vɨlu hɨyôv dɨ ngwe ob dô vô vɨgêm vɨlu kêd.” ");
INSERT INTO ptp_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Lêc Yesu nêl vô yuu ên nêbê, “Susu wê muu kɨtaa vô a ge muu o xovô kehe lêm. Dɨ kap wê a ob num vac ge, muu tɨyi wê muu ob num vac hɨxôn, me? Dɨ mia lipacên wê a ob lipac ge, muu tɨyi wê muu ob lipac hɨxôn, me? Ên myavɨnê levac hɨxôn vɨyin obêc hɨvun a xôn.” ");
INSERT INTO ptp_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Mêd yuu nêl vô Yesu ên nêbê, “Xii tɨyi pyap.” Lêc Yesu nêl vô yuu ên nêbê, “Vɨxôhɨlôg, myavɨnê wê a ob kɨlê ge, muu ob kɨlê hɨxôn. Dɨ vɨyin wê a ob tulec ge, obêc tulec muu êno hɨxôn. ");
INSERT INTO ptp_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Lêc xomxo wê ob kô lê levac mɨ dô vô a vɨgêg hɨyôv dɨ dô vô a vɨgêg kêd ge, a o tɨyi wê a ob nêl ge lêm. Ên Anutu vaci ob nêl xomxo wê i viac vɨgwe pyap vô he ge.” ");
INSERT INTO ptp_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Yesu nue ngɨvihi vɨgê yuu ngô kɨyang wê Jems yuu Jon nêl ge om he xêyaa vô myavɨnê vô yuu. ");
INSERT INTO ptp_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Om Yesu keac he vɨhati la vô i dɨ nêl vô he ên nêbê, “Xam xovô ên xam nêbê xomxo wê tu tɨbii baba nên levac ge, he mi yong he ên lê levac wê he kô ge, dɨ he mi nêl kɨyang xêkɨzêc vô lie ên nêb he i loc vac kɨyang wê he nêl ge kwa ngɨbi. ");
INSERT INTO ptp_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Dɨ xacxam va, xam o lêc vông môp tibêge lêm. Xam ti obêc nêb tu xam nêm levac ge, od i tu xam nêm xomxo yuac. ");
INSERT INTO ptp_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Dɨ xam ti obêc nêb tu xam nêm mugên ge od i kô lê vɨdaaên dɨ vông yuac vô lie vɨhati. ");
INSERT INTO ptp_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Ên a, Xomxo Nu, a o lam ên a nêb xomxo i vông yuac vô a lêm. Nge, a lam ên a nêb a ob vông yuac vô xomxo ên ngɨdu he xôn, dɨ a ob xib ên vô xomxo tɨbeac vêl ên he nên nipaên.” ");
INSERT INTO ptp_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Yesu he nue ngɨvihi hɨxôn xomxo tɨbeac ge, he val Jeliko, nang dêc sea Jeliko dɨ la nang. Lêc xomxo matocên ti lê nêbê Batimias wê ma Timias ge dô vô môp nɨnya, ên mi dô dɨ mi kɨtaa mone vô tɨbii wê lam vô môp ge. ");
INSERT INTO ptp_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Lêc ngô wê Yesu Nasalet val ge, om tyuc vya levac bêga nêbê, “Yesu, Devit nu, ông xo vɨgwe pɨsiv ên a.” ");
INSERT INTO ptp_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Mêd xomxo tɨbeac hɨgac dɨ nêl ên nêbê, “Ông vyam i ma.” Lêc Batimias ngôên he ma dɨ tyuc vya levac tii vac vac ên nêbê, “Devit nu, ông xo vɨgwe pɨsiv ên a.” ");
INSERT INTO ptp_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Mêgem Yesu val le dɨ nêl ên nêbê, “Xam keac i lam.” Om he la nêl vô Batimias ên nêbê, “Ông xêmyaa i vô nivɨha dɨ ông kɨdi lec mɨ lam, ên Yesu nêl nêb ông loc vô i.” ");
INSERT INTO ptp_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Om Batimias kwax i kol siot vêl dɨ kɨdi lec lutibed dɨ la vô Yesu. ");
INSERT INTO ptp_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Mêd Yesu kɨnêg vô i ên nêbê, “Ông nêb a vông bêna vô ôngê?” Lêc xomxo ma tocên tige nêl vô i ên nêbê, “Xomxo levac, a nêb ông vông a magnôn i seac.” ");
INSERT INTO ptp_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Mêd Yesu nêl vô i ên nêbê, “Om ông lôc, ên vông vinên wê ông vông ge vông ông vô nimvɨha lec.” Om lutibed xomxo tyo manôn seac dɨ i yê vɨgwe mêd la hɨxôn Yesu mɨ he la. ");
INSERT INTO ptp_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Yesu he nue ngɨvihi loc mɨ la ên nêb ob la Jelusalem. He la vac vɨgwe Betpasi yuu Betani wê yêp kwabo vô kɨtôn Oliv ge. Vɨgwe yuu ge yêp kwabo vô Jelusalem. Om Yesu vông nue ngɨvihi yuu la, ");
INSERT INTO ptp_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","dɨ nêl vô yuu ên nêbê, “Muu loc vac vɨgwe ti wê yêp vɨlu ganê. Wê muu obêc mɨla ge od muu ob wê donki wê gên ligên ge ti wê xomxo vô yihi lec kwa dɨ i dɨle ge. Donki tige xomxo ti gên o dô lec ila lêm. Om muu pɨwelac yihi vêl ên dɨ dɨdii i mɨ lam. ");
INSERT INTO ptp_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Lêc xomxo ti obêc kɨnêg muu ên nêbê, ‘Muu ob pɨwelac yihi tige vêl ên va?’ ge od muu nêl vô bê ‘Apumtau nêb ob kô mɨ vông yuac lec dɨ obêc vông i lôm lutibed.’” ");
INSERT INTO ptp_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Yesu nêl bêge vô yuu dɨ yuu loc mɨ la, dɨ mɨla yê bwoc donki ti wê xomxo ku xôn dɨ ku lec xumac ti vuayen dɨ i dɨle kwabo vac môp ge, mêd yuu pɨwelac yihi vêl, ");
INSERT INTO ptp_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","lêc xomxo wê dɨle ge nêl vô yuu ên nêbê, “Bêna lêc muu dɨpɨwelac yihi vêl ên donki tige?” ");
INSERT INTO ptp_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Om yuu nêl i tɨyi kɨyang wê Yesu nêl vô yuu ge, mêd xomxo tigee tyuc lec, ");
INSERT INTO ptp_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","om yuu dɨdii donki tige mɨ lax vô Yesu, mêd yuu vax yuu ngakwi lec kɨsii dêc Yesu dô lec. ");
INSERT INTO ptp_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Mêd xomxo tɨbeac vax he nivɨmihi lec môp dɨ he ya kô xax lihi wê he la kô vac yuac ge mɨ vax vac môp wê Yesu ob xoc vô ge. Môp tige wê he mi kô xomxo levac lec ge. ");
INSERT INTO ptp_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Mêgem he wê la mug hɨxôn he wê tɨmu vô Yesu gee, he vɨhati tyuc ên nêbê, “Il ob pɨmil Anutu. Dɨ il ob hi vɨxad i pec ên xomxo ti wê tu Apumtau manôn mɨ val ge. ");
INSERT INTO ptp_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Il ob hi vɨxad ên il nêd king wê val gwêbaga, ên ob viac il tɨyi xocbê bug Devit viac il ilage. Il ob vông Anutu lê i vô levac dɨ i yêp kɨsii.” ");
INSERT INTO ptp_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Mêd Yesu mɨla Jelusalem dɨ la vɨlee vac Anutu xumac ngɨbua mɨ la yê susu vɨhati ge pyap, mêd hɨyôv hoo la dɨ vɨgwe ob buc, om Yesu hɨxôn nue ngɨvihi vɨgê yuu dɨ tô mɨ la yuu, he lax mɨ la vɨgwe Betani. ");
INSERT INTO ptp_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Vɨgwe vɨdiiên tɨtige Yesu he nue ngɨvihi sea Betani dɨ la, lêc vip den Yesu. ");
INSERT INTO ptp_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Om Yesu yê ma la hɨguc ti wê le teva ge dɨ lihi levac om la kwabo ên nêb ob yê bêc nôn ya yux lec ge od ob ya. Om la yê, lêc lihi pɨleva dɨ nôn ti o yux lec lêm, ên buc wê nôn ob yux lec ge gên yêp. ");
INSERT INTO ptp_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Om Yesu nêl kɨyang xêkɨzêc lec hɨguc ên nêbê, “Tɨyi buc vɨhati yang ge ông ob vuac nôn ti i tii vac lêm.” Yesu nêl bêge dɨ nue ngɨvihi ngô hɨxôn. ");
INSERT INTO ptp_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","He mɨla Jelusalem mêd Yesu la vac Anutu xumac ngɨbua dɨ la tii xomxo wê dɨvông vɨtevac gee la vêl, dɨ xomxo wê vông mone luuma gee, Yesu kɨpyax he nên tevol sea, dɨ xomxo wê vông vɨtevac lec menac gee, Yesu kɨpyax he nên sia sea, ");
INSERT INTO ptp_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","dɨ Yesu vɨbu xomxo nêb he i o lêc kɨlê he susu mɨ loc vac xumac ngɨbua lêm. ");
INSERT INTO ptp_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Mêd Yesu nêl vô he ên nêbê, “Anutu vya yêp vac xolac bêga nêbê, ‘Xumac wê a vông ge, xomxo vac vɨgwe vɨhati gee, he ob kɨtaa vac.’ Xolac nêl bêge, lêc xam vông i tu xocbê xumac wê tɨbii yôdac ob xôpac vac ge.” ");
INSERT INTO ptp_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Mêd xomxo levac wê mi si daa gee hɨxôn he wê xovô Moses xolac gee ngô kɨyang tige om myag môp wê ob hi Yesu yib lec ge, lêc he xona ên Yesu ên wê xomxo vɨhati yetac ên kɨyang wê Yesu nêl ge. ");
INSERT INTO ptp_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Yesu he nue ngɨvihi dô dɨ vɨgwe buc om he sea Jelusalem dɨ lax mɨ la Betani. ");
INSERT INTO ptp_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Vɨgwe vɨdiiên tɨtige, he lax mɨ la Jelusalem lêc yê wê hɨguc tige lihi yal vêl dɨ mupac vac kɨtôn dɨ i la tô kehe. ");
INSERT INTO ptp_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Mêd Pita xovô kɨyang wê Yesu nêl vɨhevage om nêl vô i ên nêbê, “Xolac kehe, wê lê. Xax ti wê ông nêl vyam lôt vɨhevage, tyo mupac.” ");
INSERT INTO ptp_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Lêc Yesu nêl vô he ên nêbê, “Xam vông i vin Anutu. ");
INSERT INTO ptp_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","A nêl hɨxôn nôn vô xam bêga bê xomxo ti obêc nêl vô kɨtôn tige bê i pul vêl mɨ loc vac gwec, dɨ xomxo tige nɨlô ob vông yuu lêm, nge, obêc vông i vin xêkɨzêc ên nêbê kɨyang wê i nêl ge ob vô nôn lec ge od ob vô nôn lec. ");
INSERT INTO ptp_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Om a nêl vô xam bêga bê xam obêc nêb kɨtaa susu ti vô Anutu ge od xam vông i vin xêkɨzêc bê xam obêc kô susu tige, ên xam obêc vông bêge ge od xam obêc kô i tɨyi wê xam kɨtaa ge. ");
INSERT INTO ptp_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","“Dɨ buc wê xam ob kɨtaa vô Anutu ge od lime ti nên soên obêc yêp vô xam ge od xam kɨtya nipaên tige vêl lê, êdêc Mag wê dô lag puunê ge i kɨtya xam nêm nipaên vêl hɨxôn. ");
INSERT INTO ptp_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Lêc xam obêc kɨtya lim tige nên nipaên vêl lêm ge od Mag wê dô kɨsiinê ge obêc kɨtya xam nêm nipaên vêl êno lêm.” ");
INSERT INTO ptp_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Yesu he nue ngɨvihi mɨlax Jelusalem tii vac, mêd Yesu la vɨlee vac Anutu xumac ngɨbua lêc xomxo levac wê mi si daa gee hɨxôn xomxo wê xovô Moses xolac gee hɨxôn he Yuda levac levac, he val vô Yesu, ");
INSERT INTO ptp_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","dɨ val kɨnêg vô i ên nêbê, “Letya vông ông lam ên nêb ông lam vông môp tibêgee? Ông tu letya manôn dɨ vông môp tibêge?” ");
INSERT INTO ptp_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Lêc Yesu luu he vya dɨ nêl lax vô he ên nêbê, “A êno ob kɨnêg kɨyang ti vô xam, dɨ xam obêc nêl kɨtong ge od a ob nêl xomxo ti wê vông a lam ge kɨtong vô xam. ");
INSERT INTO ptp_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Om a ob kɨnêg xam bêga bê môp wê Jon Lipacên lipac xomxo ge, môp tige kehe yêp vô letya? Ge yêp vô Anutu lag kɨsiinê, me yêp vô xomxo kɨbun ga? Xam nêl kehe kɨtong vô a.” ");
INSERT INTO ptp_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Om he ngaênma dɨ nêl vôma ên nêbê, “Il obêc nêb va? Ên il obêc nêl bê Anutu lag kɨsiinê vông Jon lam ge od Yesu obêc nêl vô il bê, ‘Bêna lêc xam o vông i vin kɨyang wê Jon nêl ge lêmê?’ ");
INSERT INTO ptp_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Lêc il obêc nêl bê xomxo kɨbun ga vông Jon la lipac xomxo ge od tɨyiên ob ma.” He nêl bêge, ên he xona ên xomxo, ên xomxo vɨhati vông i vin ên he nêbê Jon ge plopet nôn. ");
INSERT INTO ptp_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Mêgem he nêl vô Yesu ên nêbê, “Xe o xovô lêm.” Mêd Yesu nêl vô he ên nêbê, “Om a êno ob nêl xomxo ti wê vông xêkɨzêc vô a ge kɨtong vô xam lêm.” ");
INSERT INTO ptp_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Mêd Yesu nêl kɨyang pɨlepacên ti vô xomxo bêga ên nêbê, “Xomxo ti xin wain vac yuac dɨ ku xenac kɨsuu lec dɨ yev lôva ti wê xomxo ob gig xax nôn vac ge dɨ lox xumac wê xomxo ob dô vac dɨ viac yuac ge. Mêd xomxo tige nêb ob la dô vac vɨgwe teva ngwe, om vông yuac tige vac xomxo ya vɨgê ên nêb he i viac. Pyap dɨ xomxo tige la dô teva ngwe, ");
INSERT INTO ptp_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","dɨ buc wê wain huu ge om vông nue yuac ti lax mɨ la vô xomxo wê viac yuac wain ge ên nêb i loc kô wain nôn ya. ");
INSERT INTO ptp_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Xomxo tyo mɨla, lêc xomxo wê vông yuac lec wain ge hôm i xôn dɨ hi i dɨ vông i lax mɨ la pɨleva. ");
INSERT INTO ptp_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Nang dêc xomxo ti wê i yuac ge vông nue yuac ngwe la vô he nang, lêc he hi i lec bazub dɨ vô vya nipaên vô i dɨ vông i lax mɨ la nên. ");
INSERT INTO ptp_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Mêd xomxo levac vông nu yuac ti wê vông yon ge la nang, lêc xomxo tigee hi i yib. Mêd xomxo tyo vông nue yuac toto la lêc he hi he ya vô nipaên dɨ hi he ya yib. ");
INSERT INTO ptp_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Mêd xomxo tibed dô hɨxôn xomxo levac tige. Ge i nu tuc wê i xêyaa vin lec i ge om buc ti lêc xomxo levac tyo vông nu tuc la vô xomxo wê viac i yuac ge, ên nêl ên nêbê, ‘Ga aca va nug om he ob kô i lec nivɨha dɨ la vac kɨyang wê i vông ge kwa ngɨbi.’ ");
INSERT INTO ptp_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Lêc xomxo wê viac yuac tige nêl vôma ên nêbê, ‘Xomxo tige wê obêc tu yuac kehe om il ob hi i yib êdêc yuac ga i tu il xe.’ ");
INSERT INTO ptp_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Om he hôm i xôn dɨ hi i yib, dɨ nêx i nôn la yêp vô yuac nɨnya. ");
INSERT INTO ptp_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","“Om xomxo ti wê i yuac ge ob vô vatya? Ge ob la hi xomxo tigee yib dɨ vông i yuac vô xomxo baba mɨ he viac nang. ");
INSERT INTO ptp_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","“Kɨyang wê yêp vac Anutu xolac ge xam mêd o kɨtong lêm? Ên kɨyang yêp bêga nêbê, ‘Ngɨdax ti wê xomxo xumac loxên yê lêc nêbê tɨyiên ma ge, ge wê tu ngɨdax xêkɨzêc wê ob hôm xumac xôn ge. ");
INSERT INTO ptp_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Apumtau vaci vông tige om xe xê tɨyi xocbê susu nivɨha yang ge.’” ");
INSERT INTO ptp_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Xomxo levac wê mi si daa gee hɨxôn xomxo wê xovô Moses xolac gee, he xovô ên he nêbê Yesu nêl kɨyang pɨlepacên tige lec he, om he nêb he ob hôm Yesu xôn, lêc he xona ên xomxo tɨbeac, om he sea Yesu dɨ la. ");
INSERT INTO ptp_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","He vông Palisi ya hɨxôn Helot nue ya la vô Yesu ên nêb ob kɨtyoo Yesu ên vông i nêl kɨyang ya i so. ");
INSERT INTO ptp_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Om he val nêl vô i ên nêbê, “Xolac kehe, xe xovô ên xe nêbê ông ge wê ông nêl kɨyang hɨxôn nôn dɨ ông o xona ên xomxo ti lêm, ên ông wê xomxo vɨhati tɨyima, om ông mi nêl kɨyang nôn dɨ ông tɨxuu xomxo vɨhati ya kɨyang wê Anutu vông ge. Om xe nêb xe ob kɨnêg vô ông bê tɨyi wê il Yuda ob vông mone takis vô king Sisa ge, me il vôngên ob ma?” ");
INSERT INTO ptp_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Lêc Yesu xovô kɨyang kɨtyooên wê yêp vac he nɨlô ge om nêl vô he ên nêbê, “Bêna lêc xam nêb xam ob yaxên a? Xam kô mone ti mɨ lam ên a xê.” ");
INSERT INTO ptp_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Om he kô mone ti mɨ lam, dɨ Yesu kɨnêg vô he ên nêbê, “Letya kɨnu yuu lê wê yêp lec mone tiga?” Om he nêl ên nêbê, “Sisa kɨnu yuu lê.” ");
INSERT INTO ptp_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Mêgem Yesu nêl vô he ên nêbê, “Om susu wê Sisa xe ge, xam vông i loc vô Sisa, dɨ susu wê Anutu xe ge, xam vông i loc vô Anutu.” Mêd xomxo tigee ngô kɨyang wê Yesu nêl ge dɨ yetac mabu. ");
INSERT INTO ptp_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Xomxo Sadyusi ya val vô Yesu. He Sadyusi ge, he vông i vin ên he nêbê xomxo ob kɨdi lec vac yibên lêm. Om he la nêl vô Yesu ên nêbê, ");
INSERT INTO ptp_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Xolac kehe, Moses xolac nêl bêga vô il ên nêbê xomxo ti obêc kô vêx ti lêc nu ma dɨ lɨya yib dɨ vɨnê dô ge od vux tyo li tɨmuên ob ii vêx tyo nang dɨ vông nue, êdêc nue i tu susu wê ma yibên vông ge kehe. Moses xolac nêl bêge, ");
INSERT INTO ptp_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","om wê vux vɨgê vɨlu dɨ sec yuu ob dô lec ta yuu ma tibed, dêc li tuc obêc kô vêx ti lêc yib dɨ nu ma ge, ");
INSERT INTO ptp_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","od li môn ob ii vêx tige i tii vac nang, lêc wê obêc yib dɨ nu ma ge od li gwaa ob ii nang, lêc wê li gwaa obêc yib ge ");
INSERT INTO ptp_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","od lie tɨmuên vɨhati ob tɨmu vô môp tibed ge dêc ii vêx tige, lêc wê vɨhati obêc yib dɨ nue ma, dêc vêx tyo obêc yib tɨmuên. ");
INSERT INTO ptp_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Om xe nêb xe ob kɨnêg vô ông bê buc wê xomxo yibên obêc kɨdi lec ge od vêx tige obêc tu vux tina vɨnê? Ên vux vɨgê vɨlu dɨ sec yuu, he xôn ii vêx tibed lec buc wê he dô mavɨha ge.” ");
INSERT INTO ptp_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Lêc Yesu nêl vô he ên nêbê, “Xam nêl i so dɨ kehe bêga nêbê xam o xovô kɨyang wê yêp vac xolac ge lêm, dɨ xam o xovô xêkɨzêc wê Anutu vông ge lêm. ");
INSERT INTO ptp_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Ên buc wê xomxo obêc kɨdi lec mavɨha vac yibên ge, vêx yuu vux ob iima vô buc tige lêm. Nge, he ob dô tɨyi xocbê angela lag puunê ge. ");
INSERT INTO ptp_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","“Dɨ kɨyang lec môp wê xomxo yibên ob kɨdi lec mavɨha ge, xam mêd lungên kɨyang bo ti wê Moses kɨvuu lec xax wê ngwax dɨtum lec ge? Vac kɨyang tige Moses kɨvuu Anutu vya wê nêl vô i ge mɨ i yêp vac kɨpihac xolac bêga nêbê, ‘A ga, Anutu wê Eblaham yuu Aisak yon Jekop mi kɨtaa vô a.’ ");
INSERT INTO ptp_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Om kɨyang tige nêl kɨtong ên nêbê Anutu o tu xomxo yibên nên Anutu lêm. Nge, Anutu tu xomxo mavɨha nên Anutu. Om kɨyang wê xam nêl ên xam nêbê xomxo ob kɨdi lec vac yibên lêm ge, xam nêl i so.” ");
INSERT INTO ptp_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Xomxo wê xovô Moses xolac ge ti val ngô wê he ngaênma lec kɨyang ge dɨ ngô wê Yesu luu he kɨyang ya kɨyang nivɨha ge, om kɨnêg vô Yesu ên nêbê, “Xolac wê Anutu nêl vô Moses ge, tina wê ngɨnoo xolac baba vêl ge? ");
INSERT INTO ptp_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Om Yesu nêl vô i ên nêbê, “Xolac ti wê yêp tax dɨ ngɨnoo baba vêl ge bêga nêbê, ‘Xam xomxo Islel, xam ngô lê. Il Apumtau Anutu, i Apumtau tibed. ");
INSERT INTO ptp_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Ông xêmyaa i vin lec ông Apumtau Anutu dɨ ông vông nɨlôm yen yuu pɨyôp dɨ xêkɨzêc hɨxôn kɨnum i loc dɨluhu vô Anutu.’ ");
INSERT INTO ptp_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Dɨ xolac ti wê vông yuu ge yêp bêga nêbê, ‘Ông xêmyaa i vin lec xomxo baba i tɨyi xocbê ông xêmyaa vin lec ôcông va ge.’ Xolac baba ti o ngɨnoo xolac yuu ge vêl lêm.” ");
INSERT INTO ptp_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Mêd xomxo tige nêl vô Yesu ên nêbê, “Xolac kehe, ông nêl ge nivɨha. Ông nêl kɨyang nôn ên ông nêbê Anutu ge tibed dɨ ngwe o dô hɨxôn i lêm. ");
INSERT INTO ptp_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Om il xêdyaa ob vin lec i dɨ il ob vông nɨlôd yuu pɨyôp hɨxôn xêkɨzêc vɨhati i loc dɨluhu vô Anutu, dɨ il xêdyaa ob vin lec xomxo baba tɨyi xocbê il xêdyaa vin lec icil va ge, ên il obêc vông bêge ge od ob nivɨha luu daa wê xomxo mi si lec ngwax hɨxôn daa baba ya vêl.” ");
INSERT INTO ptp_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Mêd Yesu ngô wê xomxo tige nêl kɨyang hɨxôn pɨyôp nivɨha ge om nêl vô i ên nêbê, “Ông o dô teva ên Anutu ben kɨsiinê lêm.” Mêd xomxo vɨhati xona ên wê ob kɨnêg kɨyang ya vô Yesu nang ge. ");
INSERT INTO ptp_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Yesu la nêl xolac vô xomxo vac Anutu xumac ngɨbua dɨ nêl bo ti hɨxôn bêga nêbê, “Bêna lêc xomxo wê xovô Moses xolac ge nêl ên he nêbê Kɨlisi wê Anutu nêb ob vông i lam ge, ge Devit nu? ");
INSERT INTO ptp_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Ên Myakɨlôhô Ngɨbua vông xovôên vô Devit om Devit vaci kɨvuu kɨyang bêga nêbê, ‘Apumtau Anutu nêl vô a Apumtau ên nêbê, Ông dô vô a vɨgêg hɨyôv dɨ a obêc vông tɨbii wê vông vevac vô ông ge he i dô vac ông kwa ngɨbi.’ ");
INSERT INTO ptp_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Om kɨyang tige, Devit vaci nêl lec Kɨlisi ên nêbê i Apumtau. Om bêna lêc xomxo nêl ên nêbê Kɨlisi ge Devit bue tɨmuên ti?” Mêd xomxo tɨbeac nêb ob ngô kɨyang wê Yesu mi nêl ge. ");
INSERT INTO ptp_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Yesu nêl kɨyang vô xomxo bêga ên nêbê, “Xam xona nêm ên xomxo wê xovô Moses xolac gee, ên he xêyaa vin lec môp wê he ob vɨnyum ngakwi dia dɨ la vɨlee lec wetôv, ên he nêb xomxo i yê he dɨ kô he lec, ");
INSERT INTO ptp_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","dɨ he obêc la vac xumac lɨlo, me he ob la ya vɨzid levac ge, od he nêb he ob dô lec sia nivɨha wê xomxo levac mi dô lec ge. ");
INSERT INTO ptp_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Lêc he mi vô xomxo vêxôv nên susu yuu xumac vêl ên he, dɨ buc wê he ob kɨtaa ge od he vɨyum nên nipaên vac kɨtaaên dia. Om he ob kô myavɨwen levac mabu luu vêl.” ");
INSERT INTO ptp_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Yesu dô kwabo vô kɨlong wê xomxo mi tung mone daa vac ge dɨ yê wê xomxo tɨbeac lam tung mone vac ge. Mêd xomxo wê mone levac gee he lam tung mone levac vac kɨlong, ");
INSERT INTO ptp_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","mêd vêxôv wê nên mone ma ge ti val tung mone hi yuu tya vac kɨlong. ");
INSERT INTO ptp_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Mêd Yesu keac nue ngɨvihi lam vô i dɨ nêl vô he ên nêbê, “A ob nêl hɨxôn nôn vô xam bê mone hi nôn yuu tya wê vêxôv tiga lam tung vac kɨlong ge ngɨnoo mone wê xomxo baba lam tung ge vêl. ");
INSERT INTO ptp_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Ên he mone levac dô, lêc he lam tung vɨwen dɨ he xe levac dô, dɨ vêxôv tiga, i nên mone ma lêc lam tung mone yuu tya wê i vông ge la vac kɨlong, dɨ ti o dô wê ob kɨsuu xen yaên lec mɨ ya ge lêm.” ");
INSERT INTO ptp_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Yesu lop vac Anutu xumac ngɨbua ên nêb ob la, lêc nue ngɨvihi ti nêl vô i ên nêbê, “Xolac kehe, xumac tigae, nivɨha yang dɨ tɨbii lox ya ngɨdax nivɨhavɨha.” ");
INSERT INTO ptp_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Lêc Yesu nêl vô i ên nêbê, “Xumac levac wê xam dɨwê ga, a nêl vô xam bê obêc buc tɨmuên ge od ngɨdax tigae, ngwe ob dô lec ngwe kɨsii lêm. Ên tɨbii ob dii dɨ nêx sea.” ");
INSERT INTO ptp_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Mêd Yesu la dô lec kɨtôn Oliv wê yuu xôn Anutu xumac ngɨbua le tɨyima ge, lêc Pita yuu Jems dɨ Jon yuu Andlu mɨla vô Yesu dɨ heche va dô, dɨ he kɨnêg vô Yesu ên nêbê, ");
INSERT INTO ptp_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Xe nêb ông nêl vô xe bê kɨyang wê ông nêl lec xumac ngɨbua ge obêc vô nôn lec yelacna? Dɨ do tina wê obêc val vô xe tax ên xe xê dɨ xovô bê kɨyang tige obêc vô nôn lecê?” ");
INSERT INTO ptp_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Mêgem Yesu nêl vô he ên nêbê, “Xam viac xam nivɨha êdêc xomxo i o lêc kɨtyoo xam lêm. ");
INSERT INTO ptp_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Ên xomxo tɨbeac obêc val nêl a lêg dɨ nêl bêga nêbê he Kɨlisi om obêc kɨtyoo xomxo tɨbeac. ");
INSERT INTO ptp_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","“Dɨ xam obêc ngô kɨyang wê nêbê vevac tyip vac vɨgwe ya mɨ xomxo hima ge od le i lêc yetac dɨ xona lêm. Ên vevac tige obêc val, lêc ge o buc myahɨpu tyo lêm. Nge, buc tyo gên yêp. ");
INSERT INTO ptp_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Ên tɨbii vɨyang ngwe ob vông vevac vô vɨyang ngwe, dɨ tɨbii vɨyang vɨyang ob dô kɨdu kɨdu dɨ vông vevac vôma, dɨ ngɨyêg ob yoc vac vɨgwe ya dɨ vip ob den xomxo vac vɨgwe ya. Om vɨyin tigee wê ob val taxlee vô xomxo lêc vɨyin tɨbeac gên yêp wê ob val tɨmuên. ");
INSERT INTO ptp_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Xacxam va viac xam nivɨha, ên xomxo obêc hôm xam xôn dɨ vông xam la le kot vô kaunsil manôn, dɨ he ob hi xam vac xumac lɨlo nɨlô, dɨ he ob vông xam la le vô king hɨxôn gavman levac manôn mɨ he vông kot vô xam ên wê xam vông i vin a ge, om xam ob nêl a xolac kɨtong vô he. ");
INSERT INTO ptp_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Ên xomxo vɨhati ob ngô xolac pyap lê, dêc buc myahɨpu ob val tɨmuên. ");
INSERT INTO ptp_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Mêd buc wê he obêc hôm xam xôn dɨ vông xam la vac kot ge od le i lêc xona dɨ nêl bê ‘Xe ob nêl kɨyang bêna vô he?’ lêm. Buc wê xam ob la le vô he manôn ge od xam nêl i tɨyi kɨyang wê Myakɨlôhô Ngɨbua ob vông vô xam vô buc tige, ên kɨyang wê xam ob nêl ge obêc tɨyi xocbê xacxam va kɨyang ge lêm. Nge, ge kɨyang wê Myakɨlôhô Ngɨbua vông vô xam ge. ");
INSERT INTO ptp_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Vô buc tige xomxo ya obêc vông heche va lie la vac tɨbii vɨgê ên nêb tɨbii i hi he yib, dɨ mae obêc vông heche va nue vô tɨbii bêge êno, dɨ nue obêc yê tae mae nipaên dɨ vông he vac tɨbii vɨgê dɨ tɨbii obêc hi he yib. ");
INSERT INTO ptp_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Mêd xomxo vɨhati obêc yê xam nipaên ên wê xam vông i vin a lêg ge. Dɨ xomxo ti obêc le xêkɨzêc vac vông vinên dɨ i la tyip vô buc myahɨpu ge od Anutu obêc vông i la dô vac i ben. ");
INSERT INTO ptp_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Obêc buc tɨmuên ge, susu nipaên nôn wê ob vông vɨgwe vô nipaên ge obêc la le vac vɨgwe ngɨbua ti wê xomxo vɨbu nêbê susu nivɨha pɨleva ob le vac ge. (Xam wê xam kɨtong kɨyang tiga, xam xovô kɨyang tiga kehe lê.) Dɨ buc wê susu tige obêc val le seac ge od xomxo wê dô vac vɨgweJudia ge, he i pec mɨ loc lec vɨgwe kɨtôn, ");
INSERT INTO ptp_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","om he wê dô lec xumac kɨsii ge he i o lêc lop mɨ lax kô susu ti vac xumac nɨlô lêm, ");
INSERT INTO ptp_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","dɨ he wê dô vac yuac lôma ge he i o lêc pop mɨ lax kô vɨnyumên ti hɨxôn lêm. ");
INSERT INTO ptp_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Dɨ vêx wê nu dô vac xêyaa hɨxôn vêx wê vông lul vô nue ge, he ob dô vac vɨyin levac vô buc tige. ");
INSERT INTO ptp_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Mêgem xam kɨtaa vô Anutu bê vɨyin tige i o lêc val vô buc wê lun yuu ningɨgooên ge lêm, ");
INSERT INTO ptp_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","ên vɨyin wê ob val vô buc tige obêc levac mabu yocên luu vɨyin baba vɨhati vêl. Ên buc mugên ilage wê Anutu tung susu vɨhati ge dɨ i val vô buc gwêbaga, hɨxôn buc wê ob val tɨmuên ge, vɨyin tulec xomxo, lêc o tɨyi xocbê vɨyin wê a nêl ga lêm. ");
INSERT INTO ptp_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Vɨyin tige obêc levac mabu, lêc Anutu obêc xovô xomxo wê i vɨnoo pyap nêb he tu ixe ge om ob tax buc tige tip myabo. Ên buc obêc yêp dia ge od vɨyin tige obêc kɨtya xomxo vɨhati vêl. ");
INSERT INTO ptp_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Vô buc tige xomxo ti obêc nêl vô xam ên nêbê, ‘Xam wê lê. Kɨlisi dô ga,’ me obêc nêl bêga nêbê, ‘Kɨlisi dô ganê’ ge od xam o lêc vông i vin lêm. ");
INSERT INTO ptp_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Ên xomxo kɨtyooên ya obêc val nêbê he Kɨlisi me he plopete, dɨ he ob vông do levac hɨxôn do toto wê xomxo ob yetac ên ge dɨ pɨlepac xomxo nɨlô la vô kɨyang kɨtyooên wê he nêl ge, om obêc tɨyi ge od obêc kɨtyoo xomxo wê Anutu vɨnoo he pyap ge ya hɨxôn. ");
INSERT INTO ptp_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Mêgem xam xona ên xam dɨ viac xam nivɨha, ên kɨyang wê ob vô nôn lec tɨmuên ge a nêl vɨhati kɨtong yêp seac vô xam. ");
INSERT INTO ptp_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Vɨyin levac tige obêc tip la vêl, nang dêc hɨyôv yuu dentuc ob vô mapɨtoc dɨ linacên obêc ma, ");
INSERT INTO ptp_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","dɨ pɨtua lag puunê obêc tô sea mɨ lam, dɨ susu xêkɨzêc wê kɨsii ganê ge ob vô yocyoc mɨ la dɨ lôm. ");
INSERT INTO ptp_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Mêd vô buc tige xomxo ob yê Xomxo Nu ob lam vac vɨyobtoc hɨxôn xêseac yuu xêkɨzêc levac dɨ lam. ");
INSERT INTO ptp_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Mêd a ob vông angela loc vac vɨgwe vɨhati dɨ i loc tɨyi kɨbun yuu lag myahɨpu dɨ loc vɨlu vô xomxo wê Anutu vɨnoo he pyap ge vɨhati. ");
INSERT INTO ptp_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Xam xovô kɨyang lec xuc. Ên xuc obêc val ge od xam xovô ên xam nêbê buc wê susu ob vô nôn nivɨha lec ge val. ");
INSERT INTO ptp_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Mêgem xam obêc wê susu wê a nêl vô xam ga obêc vô nôn lec ge od xam obêc xovô bêga bê buc wê a obêc lop mɨ lôm ge vô kwabo lec. ");
INSERT INTO ptp_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","A nêl hɨxôn nôn vô xam bê xomxo wê dô gwêbaga ge obêc dô dɨ kɨyang wê a nêl ga vɨhati obêc vô nôn lec vêl lê. ");
INSERT INTO ptp_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Lag yuu kɨbun xôa obêc ma, dɨ a kɨyang ti xôa obêc ma hɨxôn lêm. Nge, vɨhati obêc yêp. ");
INSERT INTO ptp_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Buc ti wê kɨyang tige ob vô nôn lec ge, xomxo ti o xovô buc tige lêm, dɨ angela wê dô lag puunê ge êno o xovô buc tige lêm, dɨ Anutu nu a, a êno lungên, dɨ Mag vaci tibed wê xovô buc tige. ");
INSERT INTO ptp_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Om xam viac xam dɨ bin buc wê Xomxo Nu ob vena lec ge, ên buc tige xam o xovô lêm. ");
INSERT INTO ptp_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","“Ge tɨyi xocbê xomxo ti sea ben ên nêb ob la dô vɨgwe bangwe, om vông yuac wê i vông ge vac nue toto vɨgê ên nêb he i viac, dɨ nêl vô xomxo ti wê mi viac vuayen ge nêb i dô dɨ yaxên buc wê ob vena lec ge. ");
INSERT INTO ptp_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Mêgem xam êno, xam dô mɨ yaxên buc, ên xam o xovô buc wê xomxo levac tyo ob vena lec ge lêm, om mêd obêc vena vô bucên me vɨvuaên mahɨgun, me wê kokɨlêx ob vô vya ge me vɨgwe vɨdiiên, ge xam lungên. ");
INSERT INTO ptp_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Om xam dô mɨ yaxên, ên gec lêc xam dɨwêp dɨ i vena lutibed. ");
INSERT INTO ptp_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Om kɨyang ga, a nêl vô xam dɨ a nêl vô xomxo vɨhati hɨxôn bêga ên a nêbê xam dô dɨ yaxên buc tige.” ");
INSERT INTO ptp_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Buc yuu obêc lam la vêl ge od xomxo Yuda ob myêl levac dɨ ya blet xêkɨzêc wê yis maên ge ên nêb ob xovô buc Pasova. Mêd xomxo levac wê mi si daa gee hɨxôn xomxo wê xovô Moses xolac gee, he myag môp wê nêb ob hôm Yesu xôn xôpacên dɨ hi i yib ge. ");
INSERT INTO ptp_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Lêc he nêl ên he nêbê, “Il ob hôm i xôn lec buc levac Pasova lêm, ên xomxo obêc yê il nipaên dɨ vông vevac vô il.” ");
INSERT INTO ptp_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Yesu la vɨgwe Betani dɨ la dô vac Saimon ben. Saimon ge wê kɨtyax mahɨzihɨzi ya ninɨvi ilage, lêc gwêbaga vô nivɨha lec. Mêd Yesu dô mɨ ya hɨxôn i, dɨ vêx ti kô butol nivɨha wê mia nivɨvea nivɨha le vac ge ti mɨ lam vô i. Mia tige mone levac. Mêd vêx tige tax butol mya dɨ too mia nivɨvea tige lec Yesu bazub. ");
INSERT INTO ptp_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Lêc xomxo wê dô ge, he ya yê môp tige tɨyiên ma dɨ nêl vôma ên nêbê, “Bêna lêc vêx tige too mia tige sea? ");
INSERT INTO ptp_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Mia tige tɨyi wê il ob vông mɨ tɨbii i kɨsuu lec mone yul yon dɨ il ob vông mone vô tɨbii wê nên susu maên gee lê, lêc vêx tige too sea.” Om he xêyaa vô nipaên dɨ he kunac vêx tige. ");
INSERT INTO ptp_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Lêc Yesu nêl ên nêbê, “Bêna lêc xam vông vɨyin vô vêx tige? Xam vông i dô. Ên môp wê i vông vô a ge, nivɨha. ");
INSERT INTO ptp_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Ên xomxo wê nên susu maên gee ob dô hɨxôn xam luta, om xam obêc nêb vông môp nivɨha vô he ge, od buc tɨbeac yêp tɨyi wê xam ob vông ge. Lêc a ga, a ob dô hɨxôn xam buc dia lêm. ");
INSERT INTO ptp_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Vêx tige vông môp tɨyi xocbê yêp vô i ge, ên a gên o xib lêm, lêc i lam lipac mia nivɨvea lec a, om tɨyi xocbê viac a nignɨvi wê xomxo ob yev a vac lôva ge. ");
INSERT INTO ptp_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","A nêl hɨxôn nôn vô xam bêga bê vac vɨgwe vɨhati wê xomxo ob la nêl xolac vac ge, xomxo ob nêl vêx tiga kɨtong hɨxôn, om xomxo vɨhati ob xovô môp nivɨha wê i vông ge.” ");
INSERT INTO ptp_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Judas Iskaliot ge Yesu nu ngɨvihi ti, lêc la vô xomxo levac wê mi si daa gee, ên nêb ob vông Yesu i loc vac he vɨgê. ");
INSERT INTO ptp_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Mêd he ngô kɨyang wê Judas nêl ge dɨ nɨlô vô nivɨha, om he hɨlu kɨyang xôn nêb ob vông mone ya vô Judas. Mêd Judas myag môp wê ob vông Yesu vac he vɨgê ge. ");
INSERT INTO ptp_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Buc wê xomxo Yuda ob ya blet wê yis maên ge val, om buc taxlee ge wê he ob hi bwoc sipsip mɨ ya ên xovô buc Pasova ge, om Yesu nue ngɨvihi kɨnêg vô i ên nêbê, “Xe ob la viac xumac nɨlô tina wê il ob xa yaên vac lec buc Pasova ge?” ");
INSERT INTO ptp_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Om Yesu vông nue ngɨvihi yuu la dɨ nêl vô yuu ên nêbê, “Muu loc vac vɨgwe Jelusalem, dɨ muu obêc mɨla vô xomxo vux ti wê kɨlê mia vac dêg ge, od muu loc vô i vɨxa, ");
INSERT INTO ptp_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","dɨ obêc la vac xumac lôma ge od muu nêl vô xomxo ti wê i xumac ge bêga bê, ‘Xolac kehe nêb xii lam kɨnêg vô ông bê xumac nɨlô tina wê i hɨxôn nue ngɨvihi ob ya yaên vac lec buc Pasova ge?’ ");
INSERT INTO ptp_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Muu obêc kɨnêg bêge vô i ge od obêc hɨlung xumac nɨlô levac ti wê yêp kɨsii ge vô muu, dɨ susu wê il ob xa lec dɨ dô lec ge le vac xumac tige pyap, om muu viac yaên wê il ob xa ge vac xumac nɨlô tige.” ");
INSERT INTO ptp_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Yesu nêl bêge vô yuu om yuu loc mɨ la Jelusalem, dɨ mɨla yê tɨyi xocbê Yesu nêl ge, mêgem yuu la viac yaên wê he ob ya ge. ");
INSERT INTO ptp_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Hɨyôv hoo la dɨ vɨgwe ob buc, om Yesu hɨxôn nue ngɨvihi vɨgê yuu dɨ tô mɨ la yuu mɨla, ");
INSERT INTO ptp_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","mêd he la dô mɨ ya, lêc Yesu nêl ên nêbê, “A nêl hɨxôn nôn vô xam bêga bê xam wê il xa yaên hɨxônma ge ti obêc nêl a kɨtong vô xomxo levac levac.” ");
INSERT INTO ptp_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Kɨyang tige vông he nɨlô vô vɨyin om he toto kɨnêg lax vô Yesu ên nêbê, “Mêd a yuubê, me?” ");
INSERT INTO ptp_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Mêd Yesu nêl vô he ên nêbê, “Xam vɨgê yuu dɨ tô mɨ la yuu ge, ti obêc nêl a kɨtong. Ge xomxo ti wê xii xôn vɨgêm ob la vac dipac nɨlô ge. ");
INSERT INTO ptp_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Vɨxôhɨlôg, Xomxo Nu ob yib tɨyi xocbê xolac nêl ilage, lêc xomxo ti wê ob vông Xomxo Nu la vac tɨbii vɨgê ge, obêc kô myavɨwen nipaên lec tɨmuên. Om xomxo tige yubacên obêc ma ilage ge od obêc nivɨha.” ");
INSERT INTO ptp_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","He dɨya, dêc Yesu hôm blet ti dɨ kɨtaa lec mêd hɨbu dɨ vông vô he dɨ nêl ên nêbê, “Hôm mɨ wa. Ga a nignɨvi.” ");
INSERT INTO ptp_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Nang dêc hôm kap wê wain le vac ge dɨ kɨtaa lec mêd vông vô he dɨ he toto num vac. ");
INSERT INTO ptp_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Mêd Yesu nêl vô he ên nêbê, “Ga a hi wê a ob kɨpyax sea ên a nêb i ngɨdu xomxo tɨbeac xôn, om ob vông kɨyang wê Anutu hɨlu pyap ge i vô nôn lec. ");
INSERT INTO ptp_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","A nêl hɨxôn nôn vô xam bê a obêc num mia wain i tii vac nang lêm dɨ i loc tyip vô buc wê a ob num wain paha vac Anutu ben ge.” ");
INSERT INTO ptp_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","He vông lɨlo ti pyap dɨ loc mɨ la lec kɨtôn Oliv. ");
INSERT INTO ptp_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Yesu nêl vô he ên nêbê, “Xam vɨhati nɨlôm obêc vô vɨyin dɨ xam ob sea a, i tɨyi xocbê kɨyang wê yêp vac xolac bêga nêbê, ‘A ob hi xomxo ti wê viac bwoc sipsip ge, om sipsip vɨhati obêc pec dɨ moo sea.’ ");
INSERT INTO ptp_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Xolac nêl bêge, dɨ a nêl vô xam bêga bê a obêc kɨdi lec magvɨha dɨ mug la Galili dɨ xam obêc tɨmu.” ");
INSERT INTO ptp_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Mêd Pita nêl vô Yesu ên nêbê, “Xomxo vɨhati obêc nêb sea ông ge od he ob sea, dɨ a mô ge, a ob sea ông lêm.” ");
INSERT INTO ptp_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Lêc Yesu nêl vô i ên nêbê, “A nêl hɨxôn nôn vô ông bê vô bucên tiga kokɨlêx obêc hi vya lu yuu lêm dɨ ông obêc yax a vun lu yon.” ");
INSERT INTO ptp_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Lêc Pita luu Yesu vya dɨ nêl kɨyang xêkɨzêc lax vô ên nêbê, “Ma vêl. A ob yax ông vun lêm. Dɨ tɨbii obêc hi a xib hɨxôn ông ge od pyap, lêc a ob yax ông vun lêm.” Dɨ nue ngɨvihi vɨhati nêl tɨyi xocbê Pita nêl ge. ");
INSERT INTO ptp_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Yesu he nue ngɨvihi loc mɨ la vɨgwe ti lê nêbê Getsemani, mêd Yesu nêl vô nue ên nêbê, “Xam dô ga ên a ob la kɨtaa.” ");
INSERT INTO ptp_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Om Yesu kô Pita yuu Jems hɨxôn Jon dɨ he la, lêc Yesu nɨlô vô vɨyin mabu, ");
INSERT INTO ptp_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","om nêl vô yon ên nêbê, “A nɨlôg vô vɨyin levac tɨyi xocbê a ob xib ge. Om mon dô dɨ wê môp xôn dɨ le i yêp lêm.” ");
INSERT INTO ptp_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Mêd Yesu la teva tya dɨ la kɨpôm manôn vac kɨbun dɨ kɨtaa ên nêb obêc tɨyi ge od vɨyin tige i o lêc tulec i lêm. ");
INSERT INTO ptp_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Om kɨtaa bêga nêbê, “O mag, ông tɨyi wê ông ob vông môp vɨhati ge, om a nêb ông vô vɨyin tige vêl ên a, lêc ông o lêc vông i tɨyi wê a nêb ông vông ge lêm. Nge, ông vông i tɨyi xovôên wê ông vông ge.” ");
INSERT INTO ptp_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Pyap dɨ Yesu lax mɨ la vô nue ngɨvihi yon, lêc yê wê yon yêp nɨlô ma ge om nêl vô Pita ên nêbê, “Saimon, bêna lêc ông wêpê? Ông o tɨyi wê ông ob dô mamvɨha tya lê ge, me? ");
INSERT INTO ptp_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Om mon kɨdi lec mɨ kɨtaa, êdêc susu nipaên i o lêc yaxên mon lêm. Ên nɨlôm nêb ob vông yuac lê, lêc nimnɨvi vô vɨyin.” ");
INSERT INTO ptp_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Mêd Yesu lax mɨ la nang dɨ la kɨtaa tii vac, lêc kɨtaa tɨyi xocbê la kɨtaa lu ngwe tax ge. ");
INSERT INTO ptp_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Pyap dɨ lax mɨ la vô yon tii vac, lêc yê wê yon manôn yêp om yon yêp ge. Om Yesu tɨpi vô yon lêc yon o xovô kɨyang ti wê ob nêl vô Yesu ge lêm. ");
INSERT INTO ptp_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Mêd Yesu la kɨtaa dɨ vena lu ti wê vông yon ge, lêc yon yêp nɨlô ma om Yesu nêl vô yon ên nêbê, “Bêna lêc mon dɨwêp wêpênê? Ge pyap, ên buc wê xomxo ob vông Xomxo Nu la vac tɨbii nipaên vɨgê ge val vô kwabo lec. ");
INSERT INTO ptp_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Om mon kɨdi lec ên il ob la. Mon wê, xomxo ti wê ob vông a la vac tɨbii vɨgê ge val le ge.” ");
INSERT INTO ptp_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Yesu gên nêl kɨyang tige dɨ lutibed Judas wê nu ngɨvihi ti ge val. Dɨ xomxo tɨbeac wê hôm yipac yuu vɨgo ge val hɨxôn. Xomxo tigee, xomxo levac wê mi si daa gee hɨxôn xomxo wê xovô Moses xolac gee dɨ Yuda levac levac ge, he vông he lam. ");
INSERT INTO ptp_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Judas nêl kɨyang ti vô xomxo tigee pyap ên nêbê, “Xomxo ti wê a obêc nga lia ge, od xam xovô bê ge xomxo tyo mê. Om xam hôm i xôn dɨ wê i xôn dɨ kô mɨ loc.” ");
INSERT INTO ptp_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Mêd Judas val dɨ la kwabo vô Yesu dɨ nêl vô i ên nêbê, “Xolac kehe” mêd nga i lia. ");
INSERT INTO ptp_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Om xomxo tigee yê dɨ la hôm Yesu xôn. ");
INSERT INTO ptp_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Mêd xomxo ti wê le kwabo ge hôm i yipac dɨ sev xomxo daa siên nên levac nu yuac ti nɨnya lihi vɨlu la vêl. ");
INSERT INTO ptp_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Mêd Yesu nêl vô xomxo wê hôm i xôn gee ên nêbê, “Xam xo ên xam nêbê a tɨbii yôdac ti om xam kɨlê yipac hɨxôn vɨgo dɨ lam hôm a xônê? ");
INSERT INTO ptp_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Tɨyi buc vɨhati a mi dô hɨxôn xam vac Anutu xumac ngɨbua dɨ a mi nêl xolac vô xam, lêc xam o hôm a xôn lêm. Om gwêbaga, kɨyang wê yêp vac xolac ge ob vô nôn lec.” ");
INSERT INTO ptp_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Mêd Yesu nue ngɨvihi vɨhati sea i dɨ pec mɨ la. ");
INSERT INTO ptp_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Xomxo ngɨvihi ti wê duc nivɨmihi yêp yaên kwem ti ge mɨla vô Yesu vɨxa, om tɨbii nêb ob hôm i xôn, ");
INSERT INTO ptp_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","lêc ngɨvihi tyo pec mɨ la, dɨ nivɨmihi tô mɨ yêp dɨ i pec mɨ la xêtuac. ");
INSERT INTO ptp_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Mêd he dɨdii Yesu mɨ la vô xomxo ti wê tu xomxo daa siên nên levac ge, mêd xomxo levac wê mi si daa gee hɨxôn xomxo wê xovô Moses xolac gee dɨ xomxo levac levac gee, he vɨhati kɨtucma mɨ lam. ");
INSERT INTO ptp_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Mêd Pita tɨmu vô Yesu vɨxa mɨ la, lêc le lam teva tya om mɨla vô xomxo daa siên nên levac ben wetôv dɨ mɨla nyuu ngwax hɨxôn xêhɨpue. ");
INSERT INTO ptp_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Mêd xomxo levac wê mi si daa gee hɨxôn xomxo kaunsil vɨhati kɨtucma mɨ dô, mêd he keac xomxo ya lam ên nêb he i lam nêl kɨyang wê Yesu mi vông vô he ge kɨtong, ên he nêb he ob tulec kɨyang soên wê Yesu mi nêl ge ên hi i yib lec. Lêc he o tulec kɨyang ti lêm, ");
INSERT INTO ptp_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","ên xomxo tɨbeac vô nɨlô vô Yesu, lêc he nêl kɨyang kɨtyooên dɨ kɨyang wê he vông ge o tɨyima lêm. ");
INSERT INTO ptp_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Om he ya le kɨsii dɨ nêl kɨyang kɨtyooên bêga lec Yesu ên nêbê, ");
INSERT INTO ptp_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Xe ngô wê xomxo tige nêl ên nêbê, ‘A ob dii xumac ngɨbua ti wê xomxo lox ya vɨgê ge vêl, dɨ buc yon obêc lam la vêl ge od a ob lox vac, lêc a vɨgêg ob lox lêm.’” ");
INSERT INTO ptp_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Lêc xomxo wê nêl kɨyang tige, vɨhati o nêl kɨyang tɨyima lêm. ");
INSERT INTO ptp_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Mêd xomxo daa siên nên levac tige kɨdi mɨ la le vac he mahɨgun dɨ kɨnêg vô Yesu ên nêbê, “Xomxo nêl kɨyang nipaên lec ông, om ông ob nêl kɨyang ti lax vô he, me?” ");
INSERT INTO ptp_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Lêc Yesu le mya pɨlihi dɨ o nêl kɨyang ti lax vô he lêm. Om xomxo levac tige kɨnêg vô i tii vac ên nêbê, “Anutu wê il mi pɨmil ge, ông Kɨlisi wê i nu ge, me?” ");
INSERT INTO ptp_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Om Yesu nêl ên nêbê, “A Kɨlisi, Anutu nu. Dɨ xam ob wê a Xomxo Nu, a ob la dô vô Anutu, xêkɨzêc kehe, vɨgê hɨyôv, dɨ a ob vena vac vɨyobtoc kɨsii ganê.” ");
INSERT INTO ptp_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Mêd xomxo levac tige nɨlô vô nipaên om lêx ici va ngakwi dɨ nêl ên nêbê, “Om il ob keac xomxo ya mɨ he i lam nêl kɨyang hɨxôn i tii vac lêm. ");
INSERT INTO ptp_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Ên ici va so vya vô Anutu mɨ xam ngô pyap. Om xam nêb il vông bêna vô i?” Mêd he vɨhati nêl ên nêbê, “Yesu vông nipaên om il ob hi i yib.” ");
INSERT INTO ptp_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Mêd xomxo ya pɨsuv myaluc lec Yesu mêd vɨyum i manôn xôn ya nivɨmihi dɨ hi i dɨ nêl vô ên nêbê, “Nêl xomxo ti wê hi ông ge lê kɨtong.” Mêd xêhɨpu wê viac Anutu xumac ngɨbua ge kô i mɨ la dɨ la hi ya vɨgê. ");
INSERT INTO ptp_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Pita gên le kɨbun lec wetôv mêd vêx ti wê vông yuac vô xomxo daa siên nên levac ge val, ");
INSERT INTO ptp_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","lêc yê wê Pita dɨnyuu ngwax mɨ dô ge om yê i manôn dɨ nêl vô i ên nêbê, “Ông ge wê ông mi dô hɨxôn Yesu Nasalet ge.” ");
INSERT INTO ptp_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Lêc Pita nêl ên nêbê, “A lungên, dɨ a o xovô kɨyang wê ông nêl ge lêm.” Mêd Pita tɨtêc vêl ên he mɨ la le vô vuayen nɨnya dɨ kokɨlêx hi vya taxlee. ");
INSERT INTO ptp_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Mêd vêx yuac tige yê Pita tii vac nang om nêl vô xomxo wê dô kwabo ge ên nêbê, “Xomxo tige wê mi dô hɨxôn Yesu he nue.” ");
INSERT INTO ptp_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Lêc Pita yax Yesu vun nang dɨ nêb i lungên. Mêd he dô myabo tya nang mêd xomxo wê dô ge nêl vô Pita ên nêbê, “Vɨxôhɨlôg, xe xovô ên xe nêbê ông ge Yesu nu ngɨvihi ti, ên ông ge xomxo Galili ti.” ");
INSERT INTO ptp_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Lêc Pita nêl kɨyang xêkɨzêc ên nêbê, “A le vô Anutu manôn dɨ a nêl hɨxôn nôn bêga bê a o xovô xomxo ti wê xam nêl ge lêm.” ");
INSERT INTO ptp_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Mêd lutibed kokɨlêx hi vya tii vac nang. Om Pita xovô kɨyang wê Yesu nêl vô i bêga nêbê, “Kokɨlêx obêc vô vya lu yuu lêm dɨ ông obêc yax a vun lu yon.” Pita xovô kɨyang tige om byag levac. ");
INSERT INTO ptp_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Vô pɨtoc yang xomxo levac wê mi si daa gee dɨ xomxo wê xovô Moses xolac gee dɨ Yuda levac levac hɨxôn kaunsil baba, he xôn kɨtucma dɨ keac lec kɨyang pyap mêd ku Yesu xôn dɨ kô i mɨ la vô hɨzap levac Pailat. ");
INSERT INTO ptp_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Mêd Pailat kɨnêg vô i ên nêbê, “Ông ge king wê Yuda vông ge, me?” Lêc Yesu nêl vô i ên nêbê, “Ông nêl i tɨyi.” ");
INSERT INTO ptp_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Mêd xomxo levac wê mi si daa gee, he so vya tɨbeac lec Yesu, ");
INSERT INTO ptp_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","om Pailat kɨnêg vô Yesu ên nêbê, “Ông tɨyi wê ông ob nêl kɨyang ti lax vô he ge, me? Ngô lê. He nêl kɨyang tɨbeac lec ông.” ");
INSERT INTO ptp_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Lêc Yesu o nêl kɨyang ti lax vô i lêm, om Pailat yetac dɨ xo kɨyang tɨbeac. ");
INSERT INTO ptp_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Môp wê Pailat mi vông ge yêp bêga nêbê buc wê xomxo Yuda ob myêl vɨzid Pasova ge od he mi nêl xomxo wê dô vac kalabuhu ge ti lê vô Pailat dɨ Pailat pɨwelac i dɨ vông i lam vô he. ");
INSERT INTO ptp_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Vô buc tige xomxo ti lê nêbê Balabas dô vac xumac kalabuhu. Balabas hɨxôn xomxo ya, he vông vevac vô gavman Lom dɨ hi xomxo ya yib om tɨbii vông he la dô vac kalabuhu. ");
INSERT INTO ptp_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Mêd xomxo Yuda tɨbeac la vô Pailat dɨ nêl vô Pailat nêb i pɨwelac xomxo ti vêl i tɨyi xocbê môp wê Pailat mi vông ilage. ");
INSERT INTO ptp_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Om Pailat kɨnêg vô he ên nêbê, “Om xam nêb a pɨwelac xomxo ti wê xam Yuda nêm king ge, me?” ");
INSERT INTO ptp_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Pailat nêl bêge, ên xovô nêbê xomxo levac wê mi si daa gee vaci vông Yesu lam vô i ên wê he xêyaa vô myavɨnê vô Yesu ge. ");
INSERT INTO ptp_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Lêc xomxo levac wê mi si daa gee nêl kɨyang tɨbeac vô xomxo Yuda ên nêb he i nêl vô Pailat bê i pɨwelac Balabas vêl. Om he nêl bêge vô Pailat. ");
INSERT INTO ptp_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Om Pailat kɨnêg vô he nang ên nêbê, “Om xomxo ti wê xam nêl lê nêbê Yuda nên king ge, a ob vông bêna vô i?” ");
INSERT INTO ptp_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Mêd he tyuc vya levac la vô Pailat ên nêbê, “Hi i lec xax pola.” ");
INSERT INTO ptp_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Lêc Pailat nêl vô he ên nêbê, “Om il ob hi i ên vatya? Xomxo tyo vông nipaên tina?” Lêc he tyuc vya levac tii vac vac ên nêbê, “Hi i lec xax.” ");
INSERT INTO ptp_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pailat nêb ob vông he xêyaa vô nivɨha, om pɨwelac Balabas lax vô he mêd kô Yesu mɨ la hi i ya yihi, pyap dêc vông i la vac tɨbii vevac vɨgê ên nêb he i kô mɨ loc hi lec xax. ");
INSERT INTO ptp_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Mêd tɨbii vevac kô Yesu mɨ la vac gavman levac ben dɨ keac lie vevac vɨhati lam. ");
INSERT INTO ptp_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Mêd he kô ngakwi hi tɨyi xocbê king mi vɨnyum ge mɨ la vɨnyum lec Yesu dêc buu kɨpomac yin mɨ tung lec i bazub xocbê kɨlung ge. ");
INSERT INTO ptp_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Mêd he pɨmil Yesu pɨsiv dɨ nêl ên nêbê, “Ông king wê Yuda vông ge, ông dô nimvɨha.” ");
INSERT INTO ptp_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Mêd he hi Yesu bazub ya duvac dɨ pɨsuv myaluc lec dɨ yev vɨxa kɨtu vô i tɨyi xocbê pɨmil i pɨsiv ge. ");
INSERT INTO ptp_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","He so vya vô i pyap, mêd kwax ngakwi hi tige vêl dɨ vɨnyum ici va ngakwi lec i nang, mêd kô i mɨ la ên nêb ob la hi i lec xax. ");
INSERT INTO ptp_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","He kô Yesu mɨ la vô môp dêc he yê xomxo ti wê dɨlam ên nêb ob la vɨgwe levac ge. Xomxo tyo lê nêbê Saimon wê Aleksanda yuu Lupas ma ge dɨ i ben Sailini. Om he kɨdu i nêb i kɨlê xax pola wê he ob hi Yesu lec ge. ");
INSERT INTO ptp_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Mêd he kô Yesu mɨ la vɨgwe ti lê nêbê Golgota. Lê tige kehe bêga nêbê bazub len. ");
INSERT INTO ptp_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Mêd xomxo ya nêb ob vông mia wain wê he pɨlepac malasin hɨxôn ge vô Yesu ên i num, lêc Yesu nêbê numên ob ma. ");
INSERT INTO ptp_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Mêd tɨbii vevac hi Yesu lec xax pola, mêd he nêb he ob tɨtang Yesu ngakwi vôma om he tɨde mɨ yê dêc tɨtang i tɨyi. ");
INSERT INTO ptp_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","He hi Yesu lec xax vô pɨtoc, tɨyi xocbê hɨyôv manôn 9. ");
INSERT INTO ptp_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Mêd kɨyang wê ob nêl xomxo nên nipaên kɨtong ge, he kɨvuu i yêp kɨsii om kɨyang wê he kɨvuu lec Yesu ge, he kɨvuu bêga nêbê, “XOMXO TIGA, KING WÊ HE YUDA VÔNG GE.” ");
INSERT INTO ptp_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Mêd he hi tɨbii wê mi vun xomxo susu ge yuu lec xax hɨxôn Yesu, om ngwe yux lec xax vô Yesu vɨgê vɨlu hɨyôv dɨ ngwe yux vô vɨgê kêd. ");
INSERT INTO ptp_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Om kɨyang wê plopet kɨvuu ilage vô nôn lec. Kɨyang yêp bêga nêbê, “He nêl i lê hɨxôn xomxo nipaên.” ");
INSERT INTO ptp_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Mêd xomxo wê lam la ge tɨpi nɨba vô Yesu dɨ so vya vô bêga nêbê, “Ông tige wê ông nêb ông ob dii Anutu xumac ngɨbua vêl dɨ lox vac i tɨyi buc yon mê? ");
INSERT INTO ptp_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Om ông ngɨdu ôcông va xôn dɨ lop vêl ên xax.” ");
INSERT INTO ptp_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Mêd xomxo levac wê mi si daa gee ya hɨxôn xomxo wê xovô Moses xolac gee he êno so vya vô Yesu dɨ nêl vôma ên nêbê, “Xomxo tige ngɨdu xomxo ya xôn, lêc o tɨyi wê ob ngɨdu ici va xôn ge lêm. ");
INSERT INTO ptp_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Om xomxo ti wê nêbê i Kɨlisi wê Islel vông king ge, i lop vêl ên xax ên il xê dɨ vông i vin.” Mêd tɨbii yuu wê dɨyux hɨxôn Yesu ge, yuu êno nêl kɨyang nipaên lec Yesu hɨxôn. ");
INSERT INTO ptp_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Hɨyôv yev kɨtôn pux mêd vɨgwe ge vɨhati vô mapɨtoc ta dɨ i la vô hɨyôv manôn yon wê hucên ge. ");
INSERT INTO ptp_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Mêd hɨyôv manôn yon ge, Yesu tyuc vya levac ên nêbê, “Eloi, eloi, lama sabaktani?” Kɨyang tige kehe bêga nêbê, “Mag Anutu, mag Anutu, bêna lêc ông sea a?” ");
INSERT INTO ptp_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Mêd xomxo wê le kwabo vô Yesu ge ngô kɨyang wê i nêl ge, om he ya nêl ên nêbê, “Ngô lê, tige kɨyag vya lec Ilaija.” ");
INSERT INTO ptp_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Mêd xomxo ti tup mɨ la kô mia myamɨlumac dɨ tɨnyum vac mia kɨlin dɨ kɨlax vac ngɨsing dɨ hôm la kɨsii vô Yesu mya nêb i tep, dɨ nêl ên nêbê, “Om il ob dô mɨ yaxên bêc Ilaija obêc val vông i lop vêl ên xax, me?” ");
INSERT INTO ptp_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Mêd Yesu tyuc vya levac dɨ yib. ");
INSERT INTO ptp_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Mêd nivɨmihi levac ti wê yux vac Anutu xumac ngɨbua ge lêx vac kɨsii dɨ lam tô vô myahɨpu. ");
INSERT INTO ptp_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Mêd tɨbii levac ti wê viac tɨbii vevac vɨhati ge le vô Yesu manôn dɨ yê wê yib ge om nêl ên nêbê, “Vɨxôhɨlôg, xomxo tige Anutu nu.” ");
INSERT INTO ptp_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Dɨ vêx ya le teva lêc yê ma la Yesu. Vêx tige, Malia wê ben Makdala ge hɨxôn Malia wê Jems tɨmuên yuu Josis ta ge, dɨ Salomi. ");
INSERT INTO ptp_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Vô buc wê Yesu dô Galili ge od vêx tigee mi tɨmu vô i vɨxa dɨ viac i ya yaên. Dɨ buc wê Yesu la Jelusalem ge, vêx tɨbeac ya la hɨxôn om he xôn dô mɨ yê wê Yesu yib ge. ");
INSERT INTO ptp_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Buc tige, buc wê he Yuda ob viac he ge, ên tɨtige obêc buc sabat. Mêd vɨgwe huc, ");
INSERT INTO ptp_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","om Josep wê ben Alimatia ge la vô Pailat. Josep ge kaunsil ti om mi dô vac kɨtucmaên hɨxôn Yuda levac levac dɨ xomxo yê i nêb i xomxo nivɨha ti. Josep dô bin buc wê Anutu nu ob lam tu king gê kɨbun ga. Mêd Josep xonaên ma dɨ loc mɨ la vô Pailat dɨ la kɨtaa i ên nêb i vôngYesu ninɨvi vô i ên i ob la lii vac lôva. ");
INSERT INTO ptp_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Mêd Pailat yetac ên wê Josep nêl nêbê Yesu yib ge om keac tɨbii vevac levac tige lam dɨ kɨnêg vô i ên nêbê, “Yesu yib gwêba, me?” ");
INSERT INTO ptp_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Mêd tɨbii levac tyo nêl ên nêbê, “Yesu yib gwêba.” Om Pailat tyuc lec nêb Josep i kô Yesu ninɨvi mɨ loc lii vac lôva. ");
INSERT INTO ptp_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Mêd Josep la kɨsuu nivɨmihi kwem ti mêd la kwax Yesu vêl ên xax dɨ vɨyum vac nivɨmihi tige dɨ kô mɨ la lii vac lôva wê he kɨden vac ngɨdax ge ti. Pyap dêc vɨxog ngɨdax levac ti la le vac lôva mya xôn. ");
INSERT INTO ptp_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Mêd Malia wê ben Makdala ge hɨxôn Malia wê Josis ta ge, yuu la hɨxôn om yê vɨgwe wê Josep la lii Yesu yêp vac ge. ");
INSERT INTO ptp_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Buc sabat la vêl mêd Malia wê ben Makdala ge hɨxôn Malia wê Jems ta ge dɨ Salomi, yon kɨsuu wel hɨxôn susu nivɨvea ya ên nêb ob la lipac lec Yesu ninɨvi. ");
INSERT INTO ptp_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Mêd da pɨtoc yang ge yon kɨdi mɨ la, ên nêb ob la vac lôva. ");
INSERT INTO ptp_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Lêc yon kɨnêg vôma ên nêbê, “Letya obêc vɨxog ngɨdax vêl ên lôva mya ên xonê?” ");
INSERT INTO ptp_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Yon nêl bêge ên wê ngɨdax tige mabu yocên ge. Mêd yon yê ma la lêc yê wê ngɨdax vɨxog mɨ la vêl ên lôva mya ge. ");
INSERT INTO ptp_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Om yon la vac lôva nɨlô lêc yê xomxo ngɨvihi ti wê vɨnyum ngakwi kwem dia ge dô vô yon vɨgê hɨyôv, om yon yetac mabu. ");
INSERT INTO ptp_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Lêc xomxo tyo nêl vô yon ên nêbê, “Mon yetacên i ma. Ên mon myag Yesu Nasalet ti wê tɨbii hi lec xax ge. Lêc o dô ga lêm, ên kɨdi lec mavɨha vac yibên. Mon wê vɨgwe wê yêp lec ga pɨleva. ");
INSERT INTO ptp_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Om mon lôc, dɨ lôc nêl vô Pita hɨxôn Yesu nue ngɨvihi baba ge bêga bê Yesu ob mug la Galili dɨ xam obêc mɨla wê i gê Galili tɨyi xocbê nêl vô xam ilage.” ");
INSERT INTO ptp_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Mêd vêx yon ngô kɨyang wê i nêl ge dɨ yon kɨnu la dɨ yon yetac, om yon lop mɨ la vɨxun dɨ pec mɨ la, dɨ yon o nêl kɨyang kɨtong vô xomxo ti lêm, ên yon xona mabu. ");
INSERT INTO ptp_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Da pɨtoc yang ge wê Yesu kɨdi lec vac yibên ge od hɨlung i vô Malia wê ben Makdala ge taxlee. Malia ge wê Yesu tii vɨmwo nipaên vɨgê vɨlu dɨ sec yuu vêl ên i ilage. ");
INSERT INTO ptp_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Om Malia la vô xomxo wê mi dô hɨxôn Yesu ilage ên nêb ob nêl kɨyang tige kɨtong vô he. He dô hɨxôn nɨlô vɨyin dɨ byag mɨ dô, ");
INSERT INTO ptp_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","lêc Malia la nêl vô he ên nêbê, “Yesu kɨdi lec vac yibên om hɨlung i vô a mɨ a xê i.” He ngô kɨyang tige lê, lêc he o vông i vin lêm. ");
INSERT INTO ptp_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Nang dêc Yesu nue ngɨvihi yuu sea Jelusalem dɨ la vô môp, lêc Yesu ninɨvi pɨlepac bangwe dɨ i val vô yuu. ");
INSERT INTO ptp_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Om yuu lax mɨ la nêl kɨtong vô nue ngɨvihi baba, lêc he o vông i vin kɨyang wê yuu nêl ge lêm. ");
INSERT INTO ptp_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Nang dêc Yesu nue ngɨvihi vɨgê yuu dɨ ti tô mɨ la ge dô dɨ ya yaên, lêc Yesu mɨla vô he mêd nêl kɨyang xêkɨzêc vô he ên wê he nɨlô xêkɨzêc dɨ he o vông i vin lêm ge, ên xomxo wê yê Yesu vô buc wê kɨdi lec mavɨha ge nêl kɨtong vô he lê, lêc he o vông i vin lêm. ");
INSERT INTO ptp_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Mêd Yesu nêl vô he ên nêbê, “Xam loc vac vɨgwe vɨhati dɨ loc nêl xolac vô xomxo vɨhati yang. ");
INSERT INTO ptp_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Dɨ xomxo ti obêc vông i vin dɨ lipac mia ge od Anutu obêc kɨtya i nên nipaên vêl dɨ ob dô mavɨha luta. Lêc xomxo ti obêc vông i vin lêm ge od ob tulec myavɨwen nipaên wê ob kɨtya i vêl ge. ");
INSERT INTO ptp_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Om xomxo wê vông i vin ge ob vông do levac hɨxôn bêga bê he ob nêl a lêg dɨ tii vɨmwo nipaên vêl, dɨ he ob keac xomxo ba vya, ");
INSERT INTO ptp_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","dɨ he obêc hôm myel nipaên me he ob num mia kɨlin wê ob hi xomxo yib ge od susu tigee ob vông he vô nipaên lêm, dɨ he obêc vyax vɨgê lec xomxo yidac ge od yidac ob tip la.” ");
INSERT INTO ptp_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Apumtau Yesu nêl kɨyang vô nue ngɨvihi pyap, dêc Anutu kô i mɨ la lag puunê dɨ i la dô vô ma Anutu vɨgê hɨyôv. ");
INSERT INTO ptp_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Mêd nue ngɨvihi loc mɨ la nêl xolac vac vɨgwe vɨhati, dɨ Apumtau ngɨdu he xôn om he vông do tɨbeac vɨyang vɨyang, om do wê he mi vông ge nêl kɨtong nêbê he nêl kɨyang nôn. ");
INSERT INTO ptp_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","2","Xe levac Tiopilas, ông xovô pyap bê ilage kɨyang val le seac vac xe mahɨgun mɨ xomxo mangwe yê vô buc taxlee, om he nêl xolac wê he yê ge kɨtong vô xe. Nang dêc xomxo tɨbeac mangwe nêb he ob kɨtuc kɨyang ge vɨhati mɨ kɨvuu vac kɨpihac, om he toto kɨvuu kɨyang tɨyi wê xomxo taxlee nêl dɨ i val vô il ga hɨxôn. ");
INSERT INTO ptp_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Om a êno nêb a ob kɨvuu kɨyang ge vac kɨpihac mɨ vông i loc vô ông, ên buc tɨbeac a kɨnêg mɨ xovô kɨyang ge vɨhati kehe. Om a kɨvuu vɨhati bôbac yuu nivɨha vac kɨpihac, ");
INSERT INTO ptp_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","ên a nêb ông kɨtong mɨ xovô bê xolac wê xomxo nêl mɨ ông ngô ge, nôn vɨxôhɨlôg. ");
INSERT INTO ptp_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Vô buc wê Helot tu king mɨ viac vɨgwe Judia ge, xomxo ti dô lê nêbê Sekalaia dɨ vɨnê lê nêbê Ilisabet. Sekalaia ge xomxo wê mi si daa vô Anutu ge ti, vac kɨdu ti wê lê nêbê Abaisa ge, dɨ vɨnê kehe vac Elon. ");
INSERT INTO ptp_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Mêd yuu ge, Anutu yê manôn nivɨha lec yuu, nêb yuu xomxo nivɨha lee, ên yuu tɨmu vô Apumtau kɨyang yuu xolac vɨhati dɨ o vông ti so lêm. ");
INSERT INTO ptp_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Lêc yuu nu ma, ên Ilisabet o kô nipwo ti lêm, dɨ yuu lɨya vô kɨpwoc yuu vêxta. ");
INSERT INTO ptp_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Sekalaia he lie daa siên la vông yuac vac Anutu xumac ngɨbua, ên ge he nên buc wê ob vông yuac lec ge, om Sekalaia la si daa vô Anutu. ");
INSERT INTO ptp_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Môp wê he mi vông ge, he mi tɨde ên nêb i nêl kɨtong vô he bê he tina ob la vac xumac ngɨbua nɨlô ên la si daa nivɨvea nivɨha vô Apumtau. Om he tɨde, lêc nêb Sekalaia, om Sekalaia la vac xumac ngɨbua nɨlô, ");
INSERT INTO ptp_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","dɨ xomxo tɨbeac kɨtaa vô Anutu mɨ dô vɨxun, dɨ Sekalaia si daa nivɨvea nivɨha vô Anutu. ");
INSERT INTO ptp_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Mêd Apumtau angela ti val le vô alta wê si daa lec ge vô vɨgê hɨyôv, ");
INSERT INTO ptp_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","dɨ Sekalaia yê mɨ yetac ên dɨ xona ên. ");
INSERT INTO ptp_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Lêc angela tige nêl vô i ên nêbê, “Sekalaia, xonaên i ma, ên Anutu ngô kɨtaaên wê ông kɨtaa ge pyap. Om vɨnêm Ilisabet obêc kô num vux ti dɨ ông ob nêl lê nêbê Jon. ");
INSERT INTO ptp_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Mêd ông obêc pɨmil dɨ ông nɨlôm obêc vô nivɨha, dɨ buc wê num tige obêc yubac ge od obêc vông xomxo tɨbeac xêyaa vô nivɨha. ");
INSERT INTO ptp_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Ên num tyo, Anutu obêc yê nêb i tu xomxo levac, dɨ i o lêc num mia wain yuu mia xêkɨzêc lêm. Buc wê obêc gên dô vac ta xêyaa ge od Myakɨlôhô Ngɨbua obêc hɨvun i xôn pyap, ");
INSERT INTO ptp_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","dɨ tɨmuên ge od obêc pɨlepac xomxo Islel tɨbeac nɨlô lax vô he Apumtau Anutu. ");
INSERT INTO ptp_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Xomxo tige ob kô xovôên yuu xêkɨzêc i tɨyi xocbê Ilaija kô ge dɨ i mug Apumtau môp, om obêc pɨlepac mae nɨlô lax vô nue, dɨ obêc pɨlepac he wê pwoo kɨyang vac ge nɨlô dɨ he i loc kô xovôên yuu pɨyôp nivɨha wê xomxo vông vinên vông ge. Om môp ge wê ob viac xomxo nɨlô pyap, êdêc he i dô hɨxôn nɨlô nivɨha dɨ Apumtau i val.” ");
INSERT INTO ptp_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Angela nêl pyap, mêd Sekalaia kɨnêg vô i ên nêbê, “Kɨyang wê ông nêl ge ob vô nôn lec bêna? Ên xii vô kɨpwoc yuu vêxta ga mê.” ");
INSERT INTO ptp_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Mêd angela nêl vô i ên nêbê, “A ga Gebliel wê a mi le vô Anutu manôn ge, lêc Anutu vông a lam ên nêb a lam nêl kɨyang nivɨha tiga vô ông. ");
INSERT INTO ptp_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Om kɨyang wê a nêl ga obêc vô nôn lec vô buc wê Anutu nêl ge. Lêcom ông o vông i vin kɨyang tyo lêm, om ông ngô lê. Ông obêc dô tɨyi xocbê yac ge dɨ keacên ob ma, dɨ i mɨloc vô buc wê kɨyang obêc vô nôn lec ge lê.” ");
INSERT INTO ptp_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Xomxo wê kɨtucma mɨ dô vɨxun ge dô bin Sekalaia, dɨ kɨnêg vôma ên nêbê, “Sekalaia la vô va, lêc la dô gwêba ta vac xumac nɨlô?” ");
INSERT INTO ptp_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","He dô dêc Sekalaia lop mɨ lôm, lêc keacên ma vô he, ên mya vɨyin, om he xovô nêbê mêd yê vatya ti vac xumac ngɨbua nɨlô. Lêc Sekalaia hɨlung kɨyang ya vɨgê vô he, ên mya vɨyin. ");
INSERT INTO ptp_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Mêd buc wê Sekalaia yuac daa siên ge tɨyôô, om lax ben vɨyangtôv. ");
INSERT INTO ptp_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Mêd lax dô ben dɨ vɨnê Ilisabet, nu tuc dô vac xêyaa dɨ i mi dô vac xumac lôma tɨyi dentuc vɨgê vɨlu, dɨ nêl ên nêbê, ");
INSERT INTO ptp_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Anutu xo vɨgwe pɨsiv ên a ên wê a mi le top dɨ nipwo ma ge, om vông nivɨha vô a mɨ vô a nig yocên vêl.” ");
INSERT INTO ptp_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Ilisabet nu dô vac xêyaa tɨyi dentuc vɨgê vɨlu dɨ sec ti, lêc Anutu vông angela Gebliel la vac vɨgwe Nasalet vac vɨgwe levac Galili, ");
INSERT INTO ptp_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","dɨ i la vô vêxwo ti lê Malia. Malia ge, tae mae nêl i lê lec Josep ên nêb yuu i iima, lêc yuu gên dô teva. Josep ge, kehe vac king Devit. ");
INSERT INTO ptp_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Mêd Gebliel la nêl vô Malia ên nêbê, “Ông wê Anutu yê ông nivɨha ge, kɨyang malehe i hɨvun ông xôn, ên Apumtau dô hɨxôn ông.” ");
INSERT INTO ptp_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Malia ngô kɨyang tyo, lêc vông i nɨlô vô vɨyin levac, dɨ i xo ên nêbê, “Kɨyang malehe ga, kehe bêna?” ");
INSERT INTO ptp_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Mêd Gebliel nêl vô i ên nêbê, “Malia, xonaên i ma, ên Anutu yê ông nivɨha. ");
INSERT INTO ptp_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Om ngô lê. Ông obêc vɨvi num vux ti dêc obêc yubac ge, dɨ ông nêl lê bê Yesu. ");
INSERT INTO ptp_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Num tyo ob tu xomxo levac dɨ xomxo ob nêl i lê nêbê Anutu lag puunê nu, dɨ Apumtau Anutu obêc vông i tu king mɨ viac xomxo tɨyi xocbê bu Devit ilage, ");
INSERT INTO ptp_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","om obêc tu xomxo Islel wê Jekop nue bue gee nên king mɨ viac he luta lêc luta, dɨ i lê king obêc tɨyôô lêm.” ");
INSERT INTO ptp_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Mêlêc Malia kɨnêg vô angela tyo ên nêbê, “Kɨyang ga obêc vô nôn lec bêna? Ên a gên o kô vux ti lêm.” ");
INSERT INTO ptp_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Mêd angela luu i vya ên nêbê, “Myakɨlôhô Ngɨbua obêc lam vô ông, dɨ xêkɨzêc wê Anutu lag puunê vông ge obêc lam hɨvun ông xôn, om nipwo ti wê ông obêc kô ge, xomxo ob nêb i ngɨbua dɨ i Anutu nu. ");
INSERT INTO ptp_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","“Ngô lê. Gônam Ilisabet wê vô vêxta dɨ mi le top dɨ nu ma ge, gwêbaga vɨvi nu vux ti, lêc gên dô dɨ dentuc vɨgê vɨlu dɨ sec ti lam la vêl, om obêc kô nu tige. ");
INSERT INTO ptp_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Ên kɨyang yuu yuac ti o vô vɨyin vô Anutu lêm. Nge, Anutu tɨyi wê ob vông susu vɨhati vô nôn lec ge.” ");
INSERT INTO ptp_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Om Malia nêl vô angela ên nêbê, “Apumtau nu yuac a, om kɨyang wê ông nêl vô a ge i vô nôn lec.” Pyap dêc angela sea i dɨ lax. ");
INSERT INTO ptp_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Vac buc tige mahɨgun ti, Malia kɨdi dɨ tup la vac vɨgwe kɨtôn ti wê yêp vac vɨgwe Judia ge, ");
INSERT INTO ptp_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","dɨ la vac Ilisabet yuu Sekalaia ben xumac lôma dɨ la pul Ilisabet vɨgê dɨ nêl kɨyang malehe vô i. ");
INSERT INTO ptp_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Mêd Ilisabet ngô Malia vya dɨ nu wê dô vac i xêyaa ge yetac dɨ ngɨgax i, mêd Myakɨlôhô Ngɨbua lam hɨvun Ilisabet xôn, ");
INSERT INTO ptp_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","dɨ i nêl vya levac vô Malia ên nêbê, “Anutu vông vɨzid nivɨha vô ông luu vêx baba ge vêl. Dɨ num wê ông ob kô ge, vɨzid nivɨha wê Anutu vông ge obêc hɨvun i xôn. ");
INSERT INTO ptp_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","A ga bêna lê, lêc a Apumtau ta val vô a? ");
INSERT INTO ptp_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Om ngô lê. A nɨnyag gên ngô ông vyam wê ông val nêl vô a ge, lêc a nug wê dô vac a xêgyaa ga yetac mɨ ngɨgax i dɨ pɨmil. ");
INSERT INTO ptp_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Ông vông i vin pyap om ông hi vɨxam i pec, ên kɨyang wê Anutu nêl vô ông ge obêc vô nôn lec tɨmuên.” Ilisabet nêl bêge. ");
INSERT INTO ptp_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Malia nêl ên nêbê, “A nɨlôg pɨmil Apumtau lê, ");
INSERT INTO ptp_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","dɨ a kɨnug hi vɨxa ên Anutu wê ngɨdu a xôn ge. ");
INSERT INTO ptp_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Ên a ga Anutu nu yuac pɨleva, lêc Anutu xêyaa vin lec a, om gwêbaga dɨ tɨmuên ge, xomxo vɨhati obêc nêl a lêg la bê Anutu vông vɨzid nivɨha vô a, ");
INSERT INTO ptp_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","ên Anutu xêkɨzêc kehe vông do levac tige vô a, dɨ i lê ngɨbua. ");
INSERT INTO ptp_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Anutu xêyaa vin lec xomxo wê la vac i kwa ngɨbi ge, om môp bêge wê ob yêp vô xomxo tɨbeac tɨbeac vɨhati dɨ i loc vô myahɨpu. ");
INSERT INTO ptp_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Anutu vɨgê vông yuac xêkɨzêc, om tii xomxo wê nɨlô yong he ge moo sea mɨ la. ");
INSERT INTO ptp_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Dɨ Anutu vô xêkɨzêc vêl ên xomxo levac wê kô lê king ge, dɨ hôm xomxo pɨleva lê lec. ");
INSERT INTO ptp_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Mêd xomxo susu maên wê vip den he ge, Anutu vông susu nivɨha vô he, dɨ xomxo wê susu tɨbeac ge Anutu vông he la nên ya vɨgê pɨleva. ");
INSERT INTO ptp_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Anutu ngɨdu nue yuac Islele xôn, ên xovô kɨyang wê nêl pyap vô buge ilage ên nêbê i xêyaa ob vin lec Eblaham he nue bue tɨmuên dɨ i loc tɨyi buc myahɨpu.” Malia nêl bêge. ");
INSERT INTO ptp_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Malia dô hɨxôn Ilisabet tɨyi dentuc yon dêc lax mɨ la ben. ");
INSERT INTO ptp_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Buc wê Ilisabet nu ob yubac ge, om nu tyo yubac lêc nu tuc. ");
INSERT INTO ptp_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Mêd Ilisabet ngɨdêe lie hɨxôn xomxo vac ben vɨyangtôv ge ngô wê Apumtau vông nivɨha vô i ge, om he la pɨmil Anutu hɨxôn Ilisabet. ");
INSERT INTO ptp_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Buc vɨgê vɨlu dɨ sec yon la vêl, lêc he kɨtuc la nêb ob gôl nu tyo ninɨvi dɨ nêl i lê. Om he nêb he ob nêl lê lec ma Sekalaia vaci, ");
INSERT INTO ptp_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","lêc ta nêl ên nêbê, “Maê! Il ob nêl i lê bê Jon.” ");
INSERT INTO ptp_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Lêc he nêl vô i ên nêbê, “Letya lê tige? Lime ngɨdême ti lê o bêge lêm.” ");
INSERT INTO ptp_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Om he vô hɨlung hɨlung ya vɨgê kɨnêgên vô ma Sekalaia ên nêb i nêl bê he ob nêl nu tyo lê bêna. ");
INSERT INTO ptp_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Mêd Sekalaia vông he la kô taple nipwo ti dɨ i kɨvuu lê lec ên nêbê “Jon”. Mêd he yê dɨ yetac ên. ");
INSERT INTO ptp_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Mêd lutibed Sekalaia kwa tyip dɨ get vô xêlehe dɨ i keac, mêgem pɨmil Anutu. ");
INSERT INTO ptp_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Om xomxo wê dô vac vɨgwe tige xona, dɨ kɨyang tige la vac vɨgwe kɨtôn Judia vɨhati, ");
INSERT INTO ptp_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","om xomxo vɨhati wê ngô kɨyang tige xo kɨyang tɨbeac vac nɨlô dɨ nêl ên nêbê, “Nipwo tige obêc dô bêna tɨmuênê?” He nêl bêge, ên he xovô ên nêb xêkɨzêc wê Anutu vông ge ngɨdu i xôn. ");
INSERT INTO ptp_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Myakɨlôhô Ngɨbua hɨvun Sekalaia xôn dɨ i nêl kɨyang tɨyi xocbê plopete ti bêga ên nêbê, ");
INSERT INTO ptp_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Il ob pɨmil Apumtau wê tu il Islele nêd Anutu ge, ên i ge wê lam ngɨdu il wê il tu i nue ge xôn dɨ vô il vêl ên nipaên, ");
INSERT INTO ptp_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","om vông xomxo xêkɨzêc ti kɨdi vac kehe Devit wê i nu yuac ge, ên nêb i ngɨdu il xôn dɨ vông il dô vac nivɨha, ");
INSERT INTO ptp_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","i tɨyi xocbê Anutu nêl vô i plopete ngɨbua ilage mɨ he nêl kɨtong ge. ");
INSERT INTO ptp_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Kɨyang tige, Anutu nêl nêb ob vô il vêl ên tɨbii vevac wê ob hi il gee yuu tɨbii wê xêyaa vô myavɨnê vô il gee. ");
INSERT INTO ptp_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Om Anutu xo vɨgwe pɨsiv ên il buge mɨ ngɨdu he xôn, dɨ xovô i kɨyang wê zôô i tu ngɨbua ilage. ");
INSERT INTO ptp_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","74","Kɨyang tige wê Anutu hɨlu vô il bug Eblaham ilage, om ob vô nôn lec vô il bêga bê Anutu ob vô il vêl ên xomxo vevac wê nêb ob kɨtya il vêl ge, ên nêb il vông i yuac mɨ dô vac, dɨ xonaên i ma, ");
INSERT INTO ptp_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","dɨ il le ngɨbua yuu nivɨha vô Anutu manôn dɨ vông i yuac i tɨyi buc vɨhati wê il dô kɨbun ga ge. ");
INSERT INTO ptp_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Ông nipwo tige, tɨmuên xomxo ob nêl bê ông plopet wê Anutu kɨsii ganê vông ge, ên ông ob mug Apumtau dɨ tɨtô i nên môp i vô bôbac, ");
INSERT INTO ptp_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","dɨ ông ob nêl kɨtong vô xomxo wê tu Anutu nue ge ên he i xovô bê Anutu ob kɨtya he nên nipaên vêl dɨ vông he i dô vac nivɨha. ");
INSERT INTO ptp_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Il Anutu ob vông bêge ên wê xêyaa vin lec il ge, om ob vông xomxo ti wê xêseac lag puunê ge i lam vô il, ");
INSERT INTO ptp_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","ên i lam linac lec xomxo wê dô vac mapɨtoc ta dɨ he xona ên yibên ge. Om obêc dɨdii il dɨ il la tɨmu vô kɨyang malehe.” Sekalaia nêl bêge. ");
INSERT INTO ptp_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Om nipwo tige lig mɨ vô levac dɨ i pɨyôp xovô kɨyang nivɨha, dɨ i la dô vac vɨgwe mahɨgun pɨleva wê xomxo dô vacên ma ge dɨ i mɨla vô buc wê lam hɨlung i vô xomxo Islel ge. ");
INSERT INTO ptp_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Vô buc tigee King Sisa Ogastas vông kɨyang ti la vô xomxo vac vɨgwe vɨhati ên nêb he vɨhati i loc ên tɨbii i kɨvuu he lê. ");
INSERT INTO ptp_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Buc tige, ge wê he kɨvuu xomxo vɨhati lê taxlee, dɨ Sailinias tu gavman levac mɨ viac vɨgwe Silia vac buc tige mɨ dô. ");
INSERT INTO ptp_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Om xomxo toto lax ben ben ên nêb tɨbii i kɨvuu he lê. ");
INSERT INTO ptp_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Josep ge, kehe vac king Devit, mêd kɨdi vac Nasalet vac vɨgwe levac Galili mɨ la, dɨ mɨla vac vɨgwe levac Judia dɨ la bu Devit ben luta lê nêbê Betlehem. ");
INSERT INTO ptp_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Om Josep yuu xôn vɨnê Malia la Betlehem ên nêb gavman i kɨvuu yuu lê. Malia ge, nu dô vac i xêyaa, ");
INSERT INTO ptp_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","mêd yuu gên dô Betlehem dɨ buc vô kwabo lec wê Malia nu ob yubac ge. ");
INSERT INTO ptp_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Lêc xomxo pup lec xumac wê vɨtevac nên ge vɨhati, om yuu la dô vac bulmakau ben, mêdec nu tyo yubac lêc nu tuc, mêd Malia vɨyum vac nivɨmihi dɨ la lii i yêp vac bulmakau dipac wê mi ya vac ge. ");
INSERT INTO ptp_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Vac vɨgwe tige xomxo wê viac bwoc sipsip gee dô vô vɨgwe nɨnya dɨ viac he bwoc sipsip vô bucên mɨ dô. ");
INSERT INTO ptp_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Mêd Apumtau angela ti val vô he, dɨ xêseac wê Apumtau vông ge lam linac lec he, om he yê dɨ xona mabu. ");
INSERT INTO ptp_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Lêc angela tyo nêl vô he ên nêbê, “Xonaên i ma. Dɨ xam ngô lê. A ob nêl kɨyang nivɨha ti vô xam, dɨ kɨyang tyo wê ob vông xomxo vɨhati xêyaa vô nivɨha yang. ");
INSERT INTO ptp_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Om a ob nêl vô xam bêga bê vô buc gwêbaga vac vɨgwe wê king Devit mi dô vac ilage, nu ti yubac. Ge xam nêm xomxo wê ob vô xam vêl ên nipaên. Ge Apumtau Kɨlisi. ");
INSERT INTO ptp_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Om do wê xam ob xovô i lec ge bêga bê xam obêc wê nipwo tyo wê ta vɨyum vac nivɨmihi dɨ i dɨyêp vac bulmakau dipac wê mi ya vac ge.” ");
INSERT INTO ptp_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Angela nêl bêge vô he, dɨ lutibed angela lag puunê tɨbeac hɨwocên val le hɨxôn angela tyo dɨ pɨmil Anutu ên nêbê, ");
INSERT INTO ptp_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Anutu lê i vô levac gê lag puunê, dɨ kɨyang malehe i lam kɨbun ga vô xomxo wê Anutu yê nivɨha ge.” ");
INSERT INTO ptp_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Angela tigee sea he dɨ lax mɨ la lag puunê, mêd xomxo bwoc viacên tigee nêl vôma ên nêbê, “Xam kɨdi lec ên il ob la Betlehem ên la xê kɨyang ti wê Apumtau vông vô angela mɨ he val nêl vô il ge nôn.” ");
INSERT INTO ptp_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Om he kɨdi lec dɨ tup lutibed dɨ mɨla yê wê Josep yuu Malia xeedô dɨ nu tuc dɨyêp vac bwoc dipac wê mi ya vac ge. ");
INSERT INTO ptp_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","He yê pyap dɨ nêl kɨyang lec nipwo tyo tɨyi wê angela nêl kɨtong vô he ge. ");
INSERT INTO ptp_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Mêd xomxo vɨhati wê ngô kɨyang wê xomxo bwoc viacên tigee nêl ge ngô dɨ yetac ên dɨ xo kɨyang tɨbeac lec. ");
INSERT INTO ptp_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Mêlêc Malia ngô kɨyang dɨ viac i yêp vac nɨlô dɨ xovô i tɨyi buc vɨhati. ");
INSERT INTO ptp_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Mêd xomxo bwoc viacên tigee lax mɨ la, dɨ lax pɨmil Anutu dɨ hi vɨxa pec ên kɨyang vɨhati wê he ngô dɨ yê nôn tɨyi kɨyang wê angela nêl vô he ge. ");
INSERT INTO ptp_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Buc vɨgê vɨlu dɨ sec yon la vêl, om he gôl nipwo tige ninɨvi dɨ nêl i lê ên nêb Yesu. Lê tige wê Yesu gên o lam la vac Malia nɨlô lêm dɨ angela nêl tax vô Malia. ");
INSERT INTO ptp_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Buc wê Malia yuu nu tuc ob la lipac ningeac vêl i tɨyi kɨyang wê yêp vac Moses xolac ge, om Josep yuu Malia kô Yesu mɨ la vac xumac ngɨbua Jelusalem, ên nêb ob vông i loc vô Apumtau, ");
INSERT INTO ptp_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","i tɨyi Apumtau kɨyang wê yêp vac kɨpihac xolac bêga ên nêbê vêx ti obêc kô nu tuc taxlee ge od he ob vông i loc tu Anutu xe ngɨbua. ");
INSERT INTO ptp_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Dɨ yuu nêb yuu ob vông daa hɨxôn i tɨyi Apumtau kɨyang wê nêl ên nêbê yuu i lêc kô dea yuu me tucluu nu yuu mɨ loc si daa vô i ge. ");
INSERT INTO ptp_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Xomxo ti dô Jelusalem lê nêbê Simion. Simion ge, xomxo vông vinên nôn wê mi kɨtaa vô Anutu dɨ dô bin xomxo ti wê ob lam vô vɨyin vêl ên Islel ge, dɨ Myakɨlôhô Ngɨbua hɨvun Simion xôn. ");
INSERT INTO ptp_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Ilage Myakɨlôhô Ngɨbua nêl kɨtong vô i ên nêb i ob yib lutibed lêm. Nge, nêb ob dô mɨ yê Kɨlisi wê Apumtau ob vông i lam ge lec manôn lê, lêc yib tɨmuên. ");
INSERT INTO ptp_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Mêd Myakɨlôhô Ngɨbua kɨdu Simion nêb i loc vac Anutu xumac ngɨbua, om Simion la dô, dêc Yesu ta yuu ma kô i mɨ la vac xumac ngɨbua ên nêb ob vông i tɨyi môp wê Moses xolac nêl ge. ");
INSERT INTO ptp_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Mêgem Simion yê dɨ hôm Yesu mɨ kɨva lec, dɨ pɨmil Anutu ya vya tibêga ên nêbê, ");
INSERT INTO ptp_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“O Apumtau, gwêbaga a nêb ông kô ông num yuac a mɨ loc vô ông hɨxôn nɨlôg nivɨha, i tɨyi kɨyang wê ông nêl vô a ilage, ");
INSERT INTO ptp_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","ên gwêbaga a magnôn yê xomxo ti wê ông vông i lam ên ông nêb i vô xe vêl ên nipaên ge. ");
INSERT INTO ptp_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Ge ông viac pyap mɨ vông i lam le seac vô xomxo manôn ên ông nêb vɨhati i yê, ");
INSERT INTO ptp_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","ên i ge xêseac wê ob linac lec tɨbii madɨluhu ên he i xovô ông, dɨ i wê ob vông nume Islel lê i vô levac.” ");
INSERT INTO ptp_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Yesu ta yuu ma yetac ên kɨyang wê Simion nêl lec i ge, ");
INSERT INTO ptp_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","mêd Simion kɨtaa lec yon, dɨ nêl vô ta Malia ên nêbê, “Ngô lê. Num tiga wê obêc vông xomxo Islel tɨbeac tô mɨ la, dɨ obêc hôm xomxo tɨbeac lec mɨ he le nivɨha. Num tyo tɨyi do wê ob hɨlung Anutu môp vô xomxo ge, lêc xomxo tɨbeac obêc so vya vô i, ");
INSERT INTO ptp_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","om xomxo nên kɨyang wê xo vac nɨlô ge obêc lam le seac. Dɨ ôcông va nɨlôm, vɨyin obêc kɨtiv ông xocbê yii kɨtiv ông dɨ la vac ông nɨlôm ge.” Simion vya bêge. ");
INSERT INTO ptp_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Plopete vêx ti dô lê nêbê Ana. Ana ge, ma Panyuel dɨ kehe Asa. Lêc kô vux ti dɨ yuu dô klismas vɨgê vɨlu dɨ sec yuu, ");
INSERT INTO ptp_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","lêc lɨya yib om tu vêxôv mɨ dô dɨ vô vêxta dɨ i klismas 84. Mêd Ana mi dô vac Anutu xumac ngɨbua dɨ mi ngɨbua yaên dɨ mi kɨtaa vô Anutu tɨyi lec bucên yuu vɨdiiên vɨhati. ");
INSERT INTO ptp_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Lêc buc tya ge Ana val yê Yesu yon ta yuu ma, om pɨmil Anutu dɨ lax nêl Yesu kɨtong vô xomxo vɨhati wê dô bin buc wê Anutu ob vô Jelusalem vêl ên vɨyin ge. ");
INSERT INTO ptp_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Josep yuu Malia vông môp vɨhati tɨyi xocbê Anutu xolac nêl ge. Pyap mêd yon nu tuc lax mɨ la ben Nasalet vac vɨgwe levac Galili. ");
INSERT INTO ptp_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Yon dô dêc nu tuc lig levac dɨ vô xêkɨzêc lec hɨxôn pɨyôp levac, dɨ Anutu vɨzid hɨvun i xôn. ");
INSERT INTO ptp_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Yesu ta yuu ma mi la Jelusalem tɨyi klismas vɨhati, ên nêb ob la yê buc Pasova ên xovô buc wê he sea Isip ilage. ");
INSERT INTO ptp_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Mêd Yesu klismas vɨgê yuu dɨ tô mɨ la yuu, om yon ta yuu ma la Jelusalem ên nêb ob la yê buc Pasova tyo nang. ");
INSERT INTO ptp_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Buc Pasova vɨhati pyap, dɨ he nêb ob lax ben, lêc Yesu dô Jelusalem dɨ ta yuu ma lungên i. ");
INSERT INTO ptp_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Yuu xo ên yuu nêb mêd Yesu la hɨxôn lie ya mɨ he la, om vɨdiiên tige yuu myag i dɨ kɨnêg i vô lie hɨxôn nipɨpu wê he xôn la ge, ");
INSERT INTO ptp_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","lêc yuu o yêvô lêm, om yuu lax mɨ la Jelusalem mɨ lax myag i. ");
INSERT INTO ptp_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Yuu myag i tɨyi buc yon, lêc la yêvô i vac Anutu xumac ngɨbua nɨlô wê xeedô hɨxôn Yuda levac levac wê kɨtucma ge, dɨ ngô he kɨyang dɨ le kɨnêg kɨyang kehe vô he. ");
INSERT INTO ptp_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Mêd xomxo wê ngô Yesu kɨyang ge yetac ên i kɨyang yuu pɨyôp nivɨha wê luu he vya ge. ");
INSERT INTO ptp_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Mêd Yesu ta yuu ma val yê dɨ yetac ên i, om ta nêl vô i ên nêbê, “Tuce, ông vông bêna vô xii ga lê, lêc ông vông xii mam myag ông yoo mɨ xulac hɨxôn nɨlôm vɨyin mabu?” ");
INSERT INTO ptp_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Mêd Yesu nêl i lax vô yuu ên nêbê, “Muu myag a ên va? Muu o xovô bê a ob dô vac Mag xumac ga lêmê?” ");
INSERT INTO ptp_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Lêc yuu o xovô Yesu kɨyang ge kehe lêm. ");
INSERT INTO ptp_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Mêd Yesu kɨdi mɨ la hɨxôn yuu dɨ yon lax mɨ la ben Nasalet. Yon mɨlax dô Nasalet ge od Yesu vô nɨnya lehe vô ta yuu ma kɨyang tɨyi buc vɨhati, mêgem ta Malia xovô kɨyang tige vɨhati yêp vac nɨlô tɨyi buc vɨhati. ");
INSERT INTO ptp_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Yesu lig hɨxôn pɨyôp nivɨha, om Anutu hɨxôn xomxo vɨhati xêyaa vin lec i. ");
INSERT INTO ptp_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Vô buc tigee Taibilias Sisa tu king mɨ viac xomxo vac klismas vɨgê yuu dɨ vɨxa vɨlu (15) mɨ dô, dɨ xomxo ya tu gavman levac dɨ viac vɨgwe ya ya, he lê bêga, Pontias Pailat viac vɨgwe levac Judia dɨ Helot viac vɨgwe levac Galili dɨ li Pilip viac vɨgwe yuu lê Itulia yuu Tlakonaitis, dɨ Laisenias viac vɨgwe Abilini. ");
INSERT INTO ptp_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Dɨ Anas yuu Kaiapas tu xomxo wê mi si daa gee nên bazub mɨ dô. Vô buc tige Anutu kɨyang la vô Jon wê Sekalaia nu ge vac vɨgwe mahɨgun pɨleva. ");
INSERT INTO ptp_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Om Jon kɨdi mɨ la mia Jodan dɨ la vac vɨgwe vɨyang vɨyang dɨ la nêl xolac vô xomxo ên nêbê he i pɨlepac he dɨ lipac mia êdêc Anutu i kɨtya he nên nipaên vêl. ");
INSERT INTO ptp_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Om kɨyang wê plopete Aisaia kɨvuu ilage mɨ i yêp ge vô nôn lec bêga ên nêbê, “Xomxo ti tyuc vya levac vac vɨgwe mahɨgun pɨleva ên nêbê, ‘Xam viac Apumtau môp wê obêc lam vac ge dɨ vông i vô bôbac. ");
INSERT INTO ptp_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Om xam hɨvun vɨgwe madia xôn ên i vô bôbac, dɨ den kɨtôn levac yuu nipwo vɨhati vêl mɨ vông i vô nivɨha, dɨ tɨtô môp nigecên i vô bôbac lec, dɨ hôm ngɨdax wê dô vac môp ge vêl ên môp i vô nivɨha lec, ");
INSERT INTO ptp_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","ên xomxo vɨhati i yê Anutu môp wê ob vô xomxo vêl ên nipaên ge.’” ");
INSERT INTO ptp_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Xomxo tɨbeac la vô Jon ên nêb i lipac he, lêc Jon nêl vô he ên nêbê, “Myel nipaên nue xam. Letya nêl vô xam ên nêbê xam ob pec ên Anutu xêyaa myavɨnê wê ob tulec xam ge? ");
INSERT INTO ptp_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Xam pɨlepac xam dɨ vông môp nivɨha ên i nêl xam kɨtong bê xam pɨlepac xam pyap. Dɨ le i lêc yong xam dɨ nêl bê xam bum Eblaham lêm. A ob nêl vô xam bê Anutu tɨyi wê ob vông ngɨdax tigae i tu Eblaham nue bue ge. ");
INSERT INTO ptp_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Xam tɨyi xocbê xax wê xomxo hôm kov ên nêb ob vuv vêl ge, ên kov vô manôn mɨ yêp vô xax kehe. Ên xax wê o vuac nôn nivɨha lêm ge, xomxo ob vuv vêl dɨ nêx i loc vac ngwax.” ");
INSERT INTO ptp_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Jon nêl bêge vô he, om he vɨhati kɨnêg vô i ên nêbê, “Om xe ob vông bêna?” ");
INSERT INTO ptp_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Om Jon nêl vô he ên nêbê, “Xomxo ti, siot yuu obêc dô ge, od i vông ngwe vô xomxo ngwe wê nên siot ma ge. Dɨ xam ti yaên obêc dô vô xam ge od ông vông bêge vô xomxo wê xen yaên ma ge êno mêge.” ");
INSERT INTO ptp_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Mêd xomxo wê mi kô takis gee, ya val vô Jon ên nêb i lipac he, om kɨnêg vô i ên nêbê, “Xolac kehe, xe ob vông bêna?” ");
INSERT INTO ptp_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Mêd Jon nêl vô he ên nêbê, “Mone takis wê xam mi kô ge, xam kô i tɨyi wê gavman nêl ge, dɨ le i lêc kô i ngɨnoo loc lêm.” ");
INSERT INTO ptp_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Dɨ tɨbii vevac ya kɨnêg vô Jon ên nêbê, “Dɨ xe gae obêc vông bêna?” Lêc Jon nêl vô he ên nêbê, “Xam o lêc hi xomxo vax vax mɨ vun he mone lêm. Dɨ le i lêc vông kot kɨtyooên vô xomxo lec he mone lêm. Nge, xam kô mone lec yuac wê xam vông ge dɨ i pyap.” ");
INSERT INTO ptp_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Xomxo tigee dô bin Kɨlisi wê ob val ge om he ngô Jon kɨyang wê nêl ge dɨ nɨlô vô hɨnyoma hɨnyoma dêc he kɨnêg vôma ên nêbê, “Mêd ga Kɨlisi tyo mê, me?” ");
INSERT INTO ptp_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Lêc Jon nêl vô he ên nêbê, “A lipac xam ya mia pɨleva, dɨ tɨmuên xomxo ngwe obêc val, lêc i xêkɨzêc luu xêkɨzêc wê a vông ge vêl, dɨ a o nigvɨha tɨyi wê a ob pɨwelac yihi vêl ên su wê i vông ge lêm. Ên obêc val lipac xam ya Myakɨlôhô Ngɨbua yuu ngwax. ");
INSERT INTO ptp_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","I vɨgê vɨnoo vô ngec nôn wê nêb ob tung vac xumac wê nôn nivɨha ob dô vac ge, dɨ ninɨvi pɨleva ge wê obêc nêx i la vac ngwax wê mi tum luta ge ên ngwax i ya vêl.” ");
INSERT INTO ptp_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Mêd Jon nêl kɨyang tɨbeac hɨxôn ên nêb i vông xovôên vô he, dɨ nêl Anutu xolac vô he vɨhati. ");
INSERT INTO ptp_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Jon kunac gavman levac Helot wê viac vɨgwe Galili ge, ên Helot kô li tuc vɨnê Helodias dɨ vông môp nipaên tɨbeac hɨxôn. ");
INSERT INTO ptp_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Lêc Helot vông nipaên levac ti hɨxôn wê vông Jon vac kalabuhu. ");
INSERT INTO ptp_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Buc wê xomxo lipac mia ge od Yesu lipac mia hɨxôn. Lipac mia pyap dɨ lôm kɨtaa, dêc vɨgwe kɨsii ganê tax, ");
INSERT INTO ptp_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","dɨ Myakɨlôhô Ngɨbua tu xocbê tucluu manôn dɨ lam dô lec Yesu. Mêd vya ti lam gê lag puunê ên nêbê, “Ông a nug wê a xêgyaa vin lec ông dɨ a xê ông nivɨha ge.” ");
INSERT INTO ptp_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Yesu klismas 30, dɨ i nêl xolac vô xomxo taxlee. Dɨ xomxo mi nêl Yesu nêb i Josep nu. Dɨ Josep mae bue tɨvae he lê bêgae: Josep ma Hilai, ");
INSERT INTO ptp_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","dɨ Hilai ma Matat, dɨ Matat ma Livai, dɨ Livai ma Melkai, dɨ Melkai ma Janai, dɨ Janai ma Josep, ");
INSERT INTO ptp_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","dɨ Josep ma Matataias, dɨ Matataias ma Emos, dɨ Emos ma Neam, dɨ Neam ma Eslai, dɨ Eslai ma Nagai, ");
INSERT INTO ptp_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","dɨ Nagai ma Meat, dɨ Meat ma Matataias, dɨ Matataias ma Semen, dɨ Semen ma Josek, dɨ Josek ma Joda, ");
INSERT INTO ptp_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","dɨ Joda ma Joanan, dɨ Joanan ma Lesa, dɨ Lesa ma Selababel, dɨ Selababel ma Sialtiel, dɨ Sialtiel ma Nelai, ");
INSERT INTO ptp_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","dɨ Nelai ma Melkai, dɨ Melkai ma Edai, dɨ Edai ma Kosam, dɨ Kosam ma Elmadam, dɨ Elmadam ma El, ");
INSERT INTO ptp_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","dɨ El ma Josua, dɨ Josua ma Eliesa, dɨ Eliesa ma Jolim, dɨ Jolim ma Matat, dɨ Matat ma Livai, ");
INSERT INTO ptp_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","dɨ Livai ma Simion, dɨ Simion ma Yuda, dɨ Yuda ma Josep, dɨ Josep ma Jonam, dɨ Jonam ma Elaiakim, ");
INSERT INTO ptp_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","dɨ Elaiakim ma Melia, dɨ Melia ma Mena, dɨ Mena ma Matata, dɨ Matata ma Netan, dɨ Netan ma Devit, ");
INSERT INTO ptp_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","dɨ Devit ma Jesi, dɨ Jesi ma Obet, dɨ Obet ma Boas, dɨ Boas ma Salmon, dɨ Salmon ma Nason, ");
INSERT INTO ptp_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","dɨ Nason ma Aminadap, dɨ Aminadap ma Atmin, dɨ Atmin ma Anai, dɨ Anai ma Heslon, dɨ Heslon ma Peles, dɨ Peles ma Yuda, ");
INSERT INTO ptp_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","dɨ Yuda ma Jekop, dɨ Jekop ma Aisak, dɨ Aisak ma Eblaham, dɨ Eblaham ma Tila, dɨ Tila ma Neho, ");
INSERT INTO ptp_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","dɨ Neho ma Selak, dɨ Selak ma Leu, dɨ Leu ma Pelek, dɨ Pelek ma Ebe, dɨ Ebe ma Sela, ");
INSERT INTO ptp_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","dɨ Sela ma Kenan, dɨ Kenan ma Apaksat, dɨ Apaksat ma Siem, dɨ Siem ma Nôa, dɨ Nôa ma Lamek, ");
INSERT INTO ptp_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","dɨ Lamek ma Metusala, dɨ Metusala ma Inok, dɨ Inok ma Jalet, dɨ Jalet ma Mahalalel, dɨ Mahalalel ma Kenan, ");
INSERT INTO ptp_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","dɨ Kenan ma Inos, dɨ Inos ma Set, dɨ Set ma Adam, dɨ Adam kehe Anutu. ");
INSERT INTO ptp_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Myakɨlôhô Ngɨbua hɨvun Yesu xôn mêd i sea mia Jodan dɨ lax mɨ la. Lêc Myakɨlôhô Ngɨbua dɨdii i mɨ la vac vɨgwe mahɨgun pɨleva wê xomxo dô vacên ma ge. ");
INSERT INTO ptp_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Mêd Yesu la dô buc kehe yuu dɨ Seten yaxên i. Yesu yaên ti ma dɨ buc tɨbeac tige la vêl om vip den i. ");
INSERT INTO ptp_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Mêgem Seten nêl vô Yesu ên nêbê, “Ông obêc Anutu nu nôn ge od ông nêl ên ngɨdax tiga i tu yaên ti ên ông wa.” ");
INSERT INTO ptp_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Lêc Yesu nêl vô i ên nêbê, “Xolac nêl bêga ên nêbê, ‘Susu yaên vaci o tɨyi wê xomxo ob dô mavɨha ya ge lêm.’” ");
INSERT INTO ptp_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Mêd Seten dɨdii Yesu mɨ yuu lec mɨ la lec kɨtôn kɨsii mêd Seten hɨlung vɨgwe wê yêp kɨbun ga ge vɨhati vô Yesu lutibed, ");
INSERT INTO ptp_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","dɨ nêl vô i ên nêbê, “A ob vông vɨgwe gee vɨhati hɨxôn xêkɨzêc yuu lê levac wê he vông ge vô ông. Ên susu vɨhati ge tu axe pyap, om a obêc nêb vông vô xomxo ti ge od a ob vông. ");
INSERT INTO ptp_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Mêgem ông obêc yev vɨxam kɨtu vô a dɨ pɨmil a ge od vɨhati obêc tu ông xe.” ");
INSERT INTO ptp_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Lêc Yesu nêl vô i ên nêbê, “Xolac nêl bêga nêbê, ‘Ông yev vɨxam kɨtu vô ông Apumtau Anutu tibed, dɨ vông yuac wê ici va vông ge.’” ");
INSERT INTO ptp_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Mêd Seten dɨdii Yesu mɨ yuu la Jelusalem, dɨ i mɨla lax Yesu la lec Anutu xumac ngɨbua myahɨpu kɨsii, dɨ nêl vô i ên nêbê, “Ông obêc Anutu nu nôn ge od ông sox loc kɨbun. ");
INSERT INTO ptp_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Ên xolac nêl bêga ên nêbê, ‘Anutu obêc vông i angela lam viac ông, ");
INSERT INTO ptp_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","om he obêc hôm ông kɨsii ya vɨgê, êdêc ông o lêc vɨnux vɨxam lec ngɨdax lêm.’” ");
INSERT INTO ptp_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Lêc Yesu nêl vô i ên nêbê, “Xolac nêl bêga ên nêbê, ‘Ông o lêc yaxên Apumtau ông Anutu lêm.’” ");
INSERT INTO ptp_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Seten yaxên Yesu ya môp vɨhati ge pyap, dêc sea i dɨ la, ên nêb ob la dô dɨ buc ngwe nang lê. ");
INSERT INTO ptp_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Xêkɨzêc wê Myakɨlôhô Ngɨbua vông ge hɨvun Yesu xôn dɨ i lax mɨ la Galili, dɨ xomxo nêl i kɨtong vac vɨgwe gee vɨhati mɨ i la tɨyi vɨgwe myahɨpu. ");
INSERT INTO ptp_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Mêd Yesu la nêl Anutu xolac vac he xumac lɨlo vɨhati om xomxo pɨmil dɨ vông i lê vô levac. ");
INSERT INTO ptp_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Yesu mɨlax Nasalet vac ben wê i nipwo dɨ i dô vac lêc lig mɨ vô levac vac ge. Yesu lax dô, dɨ buc sabat ge od la vac xumac lɨlo tɨyi môp wê mi vông ge, mêd kɨdi lec ên nêb ob kɨtong xolac vô he, ");
INSERT INTO ptp_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","om he vông kɨpihac wê plopete Aisaia kɨyang yêp vac ge vô i, mɨ i tɨdii lêc yêvô kɨyang ti wê yêp bêga ên nêbê, ");
INSERT INTO ptp_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Myakɨlôhô Ngɨbua wê Apumtau vông ge lam lec a, ên Anutu vɨnoo a ên nêb a nêl i xolac kɨtong vô xomxo wê nên susu maên gee. Om vông a lam ên nêb a vô vɨyin vêl ên xomxo wê dô vac kalabuhu ge, dɨ vông xomxo wê manôn toc ge manôn i seac, dɨ vông a lam ên nêb a vô vɨyin levac wê hɨvun xomxo xôn ge vêl. ");
INSERT INTO ptp_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Dɨ nêb a nêl Apumtau buc wê ob vông vɨzid nivɨha vô xomxo ge kɨtong.” ");
INSERT INTO ptp_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Yesu kɨtong pyap, mêd vɨlun kɨpihac xôn dɨ vông i lax vô xomxo ti wê viac xumac lɨlo ge dɨ tô mɨ dô ên nêb ob nêl kɨyang vô he, om xomxo vɨhati wê dô vac xumac tige manôn la vô i tibed. ");
INSERT INTO ptp_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Mêd Yesu nêl vô he ên nêbê, “Xolac ti wê a kɨtong mɨ xam ngô ga, vô nôn lec gwêbaga.” ");
INSERT INTO ptp_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Mêd he pɨmil Yesu dɨ yetac ên kɨyang nivɨha wê Yesu nêl ge dɨ nêl vôma ên nêbê, “Ga bêna? Xomxo tiga Josep nu mê?” ");
INSERT INTO ptp_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Mêd Yesu nêl vô he ên nêbê, “Vɨxôhɨlôg, xam obêc nêl kɨyang pɨlepacên bêga vô a bê, ‘Docta, ông vông ôcông va nimnɨvi i vô nivɨha lec lê. Ên yuac yuu do wê ông la vông vac vɨgwe Kapaneam mɨ xe ngô ge, xe nêb ông vông vac il bed ga êno bêge lê.’ Xam obêc nêl bêge vô a lê, ");
INSERT INTO ptp_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","lêc a ob nêl hɨxôn nôn vô xam bê plopete ti obêc nêl kɨyang vac ici va ben ge, od lie ob vông i vin i kɨyang lêm. ");
INSERT INTO ptp_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","I tɨyi xocbê môp wê bume tɨvame vông vô plopet Ilaija ilage. Vô buc tige lun valên ma tɨyi klismas yon dɨ dentuc vɨgê vɨlu dɨ sec ti, om vip mabu yêp vac vɨgwe Islel vɨhati. Dɨ vêxôv tɨbeac dô Islel wê he xen yaên ma ge, ");
INSERT INTO ptp_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","lêc Anutu o vông Ilaija la vô vêxôv ti vac ici ben Islel ên nêb i loc ngɨdu i xôn lêm. Nge, vông i la vɨgwe Salepat vac tɨbii Saidon ben ên nêb i loc vô vêxôv Saidontige ên i ngɨdu i xôn. ");
INSERT INTO ptp_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Nang dêc buc wê plopete Ilaisa dô ge, od xomxo wê kɨtyax mahɨzihɨzi ge tɨbeac dô vac vɨgwe Islel, lêc Ilaisa o vông he ti vô nivɨha lec lêm. Nge, la vac tɨbii Silia ben dɨ la vông Neman tibed vô nivɨha lec.” ");
INSERT INTO ptp_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Yesu nêl bêge, mêd he wê dô vac xumac lɨlo mɨ ngô i kɨyang ge, he xêyaa vô myavɨnê mabu vô i, ");
INSERT INTO ptp_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","om he kɨdi lec dɨ kô i mɨ la nɨnyawehe. Vɨgwe tige yêp lec kɨtôn ti om he kô Yesu mɨ la vɨgwe nɨnya wê madia ge, ên nêb ob tɨyot i loc vac madia. ");
INSERT INTO ptp_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Lêc Yesu la vac he mahɨgun dɨ loc mɨ la. ");
INSERT INTO ptp_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Yesu loc mɨ la Kapaneam vac vɨgwe levac Galili, dɨ buc sabat ge od nêl xolac vô he vac he xumac lɨlo. ");
INSERT INTO ptp_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Mêgem he yetac ên kɨyang wê Yesu nêl ge, ên Yesu nêl kɨyang hɨxôn xêkɨzêc. ");
INSERT INTO ptp_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Vac xumac lɨlo tige xomxo wê vɨmwo nipaên dô vac nɨlô ge ti dô hɨxôn, om keac vya levac ên nêbê, ");
INSERT INTO ptp_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Yesu Nasalet, ông lam ên ông nêb ông ob vông bêna vô xe? Ông nêb ông ob kɨtya xe vêle? Ên a xovô ông ên a nêbê ông ge xomxo ngɨbua wê Anutu vông ông lam ge.” ");
INSERT INTO ptp_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Lêc Yesu keac xêkɨzêc ên nêbê, “Ông keacên i ma, dɨ lop mɨ loc vêl ên xomxo tige.” Mêgem vɨmwo nipaên tige vô makɨkun vac xomxo tige mêd hɨvip i dɨ vɨxog i la vac xomxo tɨbeac mahɨgun, dêc sea i dɨ la vêl, lêc o vông xomxo tyo ninɨvi vô nipaên lêm. ");
INSERT INTO ptp_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Mêd xomxo tɨbeac tigee yê dɨ yetac mabu dɨ nêl vôma ên nêbê, “Xomxo tige va nêl kɨyang bêna, lêc nêl kɨyang hɨxôn xêkɨzêc vô vɨmwo nipaên tɨyi xocbê i xomxo levac ge om vɨmwo nipaên ngô dɨ pec mɨ la vêl.” ");
INSERT INTO ptp_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Mêgem xomxo vông Yesu lê vô levac vac vɨgwe buhu toto ge dɨ i la tɨyi myahɨpu. ");
INSERT INTO ptp_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Yesu kɨdi vac xumac lɨlo dɨ la vac Saimon Pita ben. Lêc Saimon yen vêxta vông yidac levac ngwax tum, om he nêb Yesu i loc vông i vô nivɨha lec. ");
INSERT INTO ptp_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Om Yesu la le kwabo vô i dɨ pɨping i yidac ên nêbê, “Loc vêl.” Om yidac tip la lutibed dɨ vêx tyo vô nivɨha lec mɨ kɨdi lec, dɨ vông yebac vô he xen yaên hɨxôn. ");
INSERT INTO ptp_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Hɨyôv hoo la, dêc xomxo tɨbeac kô lie wê yidac kehe toto ge mɨ la vô Yesu, om Yesu vyax vɨgê lec he toto dɨ vông he vô nivɨha lec. ");
INSERT INTO ptp_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Dɨ xomxo tɨbeac wê vɨmwo nipaên dô vac he ge, vɨmwo nipaên tigee lop mɨ la vêl ên he dɨ tyuc vya levac ên nêbê, “Ông ge Anutu nu.” Lêc Yesu keac levac lec he nêbê, “Xam keacên i ma,” ên he xovô pyap ên nêbê Yesu ge Kɨlisi ti wê Anutu vông i lam ge. ");
INSERT INTO ptp_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Vɨgwe vɨdiiên pɨtoc yang tya ge, Yesu kɨdi mɨ sea vɨgwe tige dɨ la vac vɨgwe mahɨgun pɨleva wê xomxo maên ge. Lêc xomxo myag i, lêc mɨla vô i om nêl i xôn nêb i dô hɨxôn he dɨ seaên he i ma. ");
INSERT INTO ptp_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Lêc Yesu nêl vô he ên nêbê, “Mêlêc a ob la nêl Anutu ben kehe kɨtong vô xomxo vac vɨgwe baba hɨxôn. Ên yuac ga wê Anutu vông a lam ên nêb a vông ge.” ");
INSERT INTO ptp_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Om Yesu la nêl xolac vac Yuda xumac lɨlo vɨyang vɨyang ge vɨhati. ");
INSERT INTO ptp_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Buc ti Yesu mɨla le vô mia luaên Genesalet nɨnya, dɨ xomxo tɨbeac la dô dɨ hɨvun i xôn, ên nêb ob ngô Anutu xolac wê Yesu ob nêl ge. ");
INSERT INTO ptp_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Mêlêc Yesu yê dipac yuu wê yêp vô mia nɨnya ge, lêc xomxo wê mi kô dipac ge dô lecên ma, ên he la dɨlipac he leac wê mi hi pis vac ge. ");
INSERT INTO ptp_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Mêd Yesu lec la lec dipac ngwe wê Saimon vông ge dɨ nêl vô Saimon ên nêbê, “Vông dipac i du mɨ loc mahɨgun tya.” Om he vông i du mɨ la mahɨgun dɨ Yesu dô lec dipac dɨ nêl xolac vô xomxo wê dô kehe ge. ");
INSERT INTO ptp_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Yesu nêl xolac pyap, dêc nêl vô Saimon ên nêbê, “Vông dipac i loc vac gwec madia dɨ tung leac i loc vac mia ên hi lɨlii.” ");
INSERT INTO ptp_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Lêc Saimon luu i vya ên nêbê, “Xolac kehe, vɨhevage buc xuhu dia tiga xe vông yuac levac lec lɨlii myagên, vɨvuatɨtôv dɨ vɨgwe vɨdii lec, lêc xe o hi ti lêm. Lêc ga mô ông nêl om a ob lax tung leac i loc vac mia.” ");
INSERT INTO ptp_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Om he tung leac la, lêc lɨlii tɨbeac vac leac mɨ i pup lec xocbê ob tax i tip ge, ");
INSERT INTO ptp_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","om he tyuc lie dipac ngwe ên nêb he i lam kô lɨlii hɨxôn he. Om he lam dɨ he tung lɨlii vac dipac yuu xôn mɨ i pup lec tɨyi xocbê ob vông dipac tô mɨ la vac mia nɨlô ge. ");
INSERT INTO ptp_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Mêd Saimon Pita yê dɨ la yev vɨxa kɨtu vô Yesu dɨ nêl ên nêbê, “Apumtau, loc vêl ên a, ên a ga tɨbii nigpaên.” ");
INSERT INTO ptp_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Saimon nêl bêge, ên i hɨxôn lie wê dô hɨxôn i ge yetac mabu ên wê Yesu nêl dɨ he hi lɨlii tɨbeac ge. ");
INSERT INTO ptp_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Dɨ Sebedi nu Jems yuu Jon wê yuu mi vông yuac lɨlii hɨxôn Saimon ge, yuu yê dɨ yetac ên êno. Mêd Yesu nêl vô Saimon ên nêbê, “Xonaên i ma. Ên tɨmuên ge od ông obêc vông yuac bêga bê ông obêc kɨtuc xomxo i lam vô a.” ");
INSERT INTO ptp_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Mêd he soo mia mɨ la le kehe, pyap dêc susu vɨhati ge dô dɨ he la tɨmu vô Yesu. ");
INSERT INTO ptp_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Yesu la dô vac vɨgwe ti, lêc xomxo wê kɨtyax mahɨzihɨzi dô lec i ninɨvi ma vêl ge ti yê Yesu om lam yev vɨxa kɨtu vô i dɨ kɨtaa i ên nêbê, “Xomxo levac, ông obêc nêb vông a nignɨvi i vô nivɨha lec ge od ông tɨyi wê ông ob vông i vô nôn lec ge.” ");
INSERT INTO ptp_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Mêgem Yesu tɨtô vɨgê la vyax lec i dɨ nêl ên nêbê, “A nêb ông vô nimvɨha lec.” Yesu nêl dɨ kɨtyax mahɨzihɨzi tige wax la vêl dɨ i ninɨvi vô nivɨha lec lutibed. ");
INSERT INTO ptp_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Mêgem Yesu nêl kɨyang xêkɨzêc vô i ên nêbê, “Ông o lêc nêl kɨtong vô xomxo ti lêm. Dɨ loc hɨlung nimnɨvi mô vô xomxo wê mi si daa vô Anutu ge dɨ vông daa i tɨyi Moses xolac wê nêl ge, ên xomxo vɨhati i yê dɨ xovô bê ông nimnɨvi vô nivɨha lec.” ");
INSERT INTO ptp_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Yesu nêl bêge lê, lêc xomxo nêl i lê vô levac la vac vɨgwe vɨyang vɨyang ge, om xomxo tɨbeac mi kɨtuc la vô i, ên nêb ob ngô kɨyang wê i nêl ge, dɨ he nêb i vông he ninɨvi yidac i vô nivɨha lec. ");
INSERT INTO ptp_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Lêc buc ya Yesu le sea he dɨ la vac vɨgwe mahɨgun pɨleva dɨ la kɨtaa. ");
INSERT INTO ptp_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Buc ti Yesu nêl xolac vô xomxo tɨbeac, lêc Palisi yuu xomxo wê xovô Moses xolac gee lam vac vɨgwe Jelusalem dɨ Galili yuu Judia vɨhati mɨ lam dô hɨxôn. Dɨ xêkɨzêc wê Apumtau Anutu vông ge lam hɨvun Yesu xôn ên nêb i vông yidac i vô nivɨha lec ya. ");
INSERT INTO ptp_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Mêd xomxo ya ken xomxo ti wê len vô xêlehe ge lec pêt dɨ mɨla, ên nêb ob vông i loc vô Yesu manôn ên i vông i vô nivɨha lec. Lêc Yesu dô vac xumac nɨlô, ");
INSERT INTO ptp_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","dɨ xomxo tɨbeac pup lec, om môp ti o yêp wê he ob kô i mɨ la vô Yesu ge lêm. Om he lec xumac mɨ la kɨsii mɨ la dii xumac mya ti dɨ vông xomxo tyo tô mɨ la hɨxôn pêt vac tɨbii tɨbeac mahɨgun dɨ la yêp vô Yesu manôn. ");
INSERT INTO ptp_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Mêd Yesu yê wê he vông i vin ge om nêl vô xomxo tyo ên nêbê, “Lig, a kɨtya ông nêm nipaên vêl pyap.” ");
INSERT INTO ptp_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Mêlêc xomxo wê xovô Moses xolac gee yuu Palisi gee ngô dɨ nêl vôma ên nêbê, “Xomxo tige letya lêc so vya vô Anutu? Ên xomxo ti o tɨyi wê ob kɨtya xomxo nên nipaên vêl ge lêm. Nge, Anutu vaci tibed ge wê ob kɨtya vêl ge.” ");
INSERT INTO ptp_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Mêd Yesu xovô kɨyang wê he nêl vac nɨlô ge om nêl vô he ên nêbê, “Bêna lêc xam xo kɨyang bêge vac nɨlômê? ");
INSERT INTO ptp_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Xam xovô lê. Kɨyang ngwe na wê obêc vô vɨyin maên ge? Kɨyang wê nêbê, ‘A kɨtya ông nêm nipaên vêl’ ge, me kɨyang wê nêbê, ‘Ông kɨdi lec mɨ loc’ ge? ");
INSERT INTO ptp_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Mêlêc a nêb a ob vông xovôên vô xam bê a, Xomxo Nu, a xêkɨzêc tɨyi wê a ob kɨtya xomxo nên nipaên vêl gê kɨbun ga, om xam lêc wê.” Mêdêc Yesu nêl vô xomxo tyo wê len vô xêlehe ge ên nêbê, “A nêl vô ông bê ông kɨdi lec mɨ hôm ông guhu lec dɨ lôc bom.” ");
INSERT INTO ptp_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Mêdec lutibed xomxo tyo kɨdi lec vac he mahɨgun dɨ hôm i guhu lec dɨ la ben hɨxôn nɨlô pɨmilên. ");
INSERT INTO ptp_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Mêgem xomxo gee vɨhati yê dɨ yetac mabu, dɨ he pɨmil Anutu hɨxôn nɨlô yetacên dɨ nêl vôma ên nêbê, “Gwêbaga il xê mad lec do nivɨha vɨyonên ti.” ");
INSERT INTO ptp_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Yesu la, lêc mɨla yê xomxo ti lê nêbê Livai wê xeedô vac xumac wê he mi kô mone takis vô tɨbii vac ge, om Yesu la nêl vô i ên nêbê, “Kɨdi mɨ lam hɨxôn a.” ");
INSERT INTO ptp_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Mêgem Livai kɨdi lec dɨ sea i yuac yuu susu vɨhati dô xel dɨ la tɨmu vô Yesu vɨxa mɨ he la. ");
INSERT INTO ptp_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Mêd Livai myêl vɨzid levac vô Yesu vac ben, dɨ xomxo wê mi kô takis gee hɨxôn xomxo yaya la dô hɨxôn yuu mɨ he ya. ");
INSERT INTO ptp_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Lêc he Palisi hɨxôn he lie wê xovô Moses xolac gee yê tɨyiên ma, om nêl vô Yesu nue ngɨvihi ên nêbê, “Bêna lêc xam la wa dɨ num hɨxôn tɨbii wê mi kô mone takis gee yuu tɨbii nipaênê?” ");
INSERT INTO ptp_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Mêd Yesu ngô wê he nêl bêge, om nêl vô he ên nêbê, “Xomxo nivɨha obêc la vô docta lêm. Nge, tɨbii yidac ge wê obêc la vô docta. ");
INSERT INTO ptp_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Om a ob nêl vô xam bê a o lam ên a nêb a ob tyuc xomxo nivɨha lêm. Nge, a lam ên tɨbii nipaên, ên a nêb he i pɨlepac he.” ");
INSERT INTO ptp_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Mêd he nêl vô Yesu ên nêbê, “Jon nue ngɨvihi mi ngɨbua yaên dɨ mi kɨtaa tɨyi buc vɨhati, dɨ Palisi nue ngɨvihi mi vông bêge êno. Mêd ông va ge, nume ngɨvihi mi ya dɨ mi num dɨ o ngɨbua lêm.” ");
INSERT INTO ptp_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Mêlêc Yesu nêl vô he ên nêbê, “Buc ti wê tɨbii vɨyang ti lie ti obêc ii vêx ti lêc gên dô hɨxôn he ge, od he obêc ngɨbua yaên, me? Maê. ");
INSERT INTO ptp_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Lêc obêc buc tɨmuên wê tɨbii ob kô li tige vêl ên he ge, od ge wê he obêc dô hɨxôn vɨyin dɨ ngɨbua yaên.” ");
INSERT INTO ptp_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Mêd Yesu nêl kɨyang pɨlepacên ti vô he bêga ên nêbê, “Xomxo ti nên ngakwi obêc tip ge, od obêc kɨping ngakwi paha myahɨpu ti vêl mɨ la duu lec tɨkwê lêm. Ên obêc vông bêge ge od obêc vông ngakwi paha vô nipaên, dɨ myahɨpu paha tige obêc la tɨyi ngakwi tɨkwê lêm. ");
INSERT INTO ptp_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Dɨ kɨyang ngwe, xomxo ti obêc too mia wain paha vac bwoc ninɨvi tɨkwê lêm. Ên obêc too vac ge od wain obêc vuac dɨ tax ninɨvi tɨkwê tip dɨ wain too la. ");
INSERT INTO ptp_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Om wain paha ge, xomxo i too vac bwoc ninɨvi paha. ");
INSERT INTO ptp_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Dɨ xomxo wê num wain tɨkwê ge obêc nêb num wain paha nang lêm, ên he nêl ên he nêbê wain tɨkwê nyen nivɨha luu vêl.” ");
INSERT INTO ptp_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Vô buc sabat ti, Yesu he nue ngɨvihi la vô môp wê la vac yuac yaên ge ti. Mêd he mɨla lê, lêc nue ngɨvihi le yul wit nôn wê tɨyi xocbê pɨdi nôn ge dɨ hɨlii ninɨvi la vêl dɨ ya nôn. ");
INSERT INTO ptp_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Lêc Palisi ya yê dɨ nêl vô he ên nêbê, “Gwêbaga buc sabat wê Moses xolac ngɨbua nêb il ob vông yuac ti lec lêm ge, lêc bêna lêc xam vông yuac lecê?” ");
INSERT INTO ptp_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Lêc Yesu luu he vya bêga ên nêbê, “Môp wê bug Devit vông ilage, xam kɨtong, me xam lungên? Ên Devit he lie dô lê, lêc vip den he, ");
INSERT INTO ptp_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","om Devit la vac Anutu xumac ngɨbua dɨ la hôm blet ti wê he tung vô Anutu manôn ge. Blet tige, xomxo pɨleva o tɨyi wê ob ya ge lêm. Nge, xomxo wê mi si daa vô Anutu ge, heche va ob ya. Lêc Devit kô mɨ lax ya dêc vông mɨ lie ya hɨxôn. Lêc Devit o vông i so lêm, ên xomxo wê mi si daa ge vaci vông mɨ i ya.” ");
INSERT INTO ptp_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Dɨ Yesu nêl hɨxôn vô he ên nêbê, “Om xam xovô bê a, Xomxo Nu, a tu buc sabat kehe hɨxôn.” ");
INSERT INTO ptp_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Mêd sabat tɨmuên ngwe Yesu la vac Yuda xumac lɨlo mɨ la nêl xolac vô he. Lêc yê xomxo wê vɨgê hɨyôv len yuu kɨlôhô xêlehe ge ti dô hɨxôn he. ");
INSERT INTO ptp_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Lêc Yuda wê xovô Moses xolac gee hɨxôn he Palisi dô dɨ yê Yesu xôn ên nêb ob yê bêc obêc vông xomxo tige vô nivɨha lec vô sabat ge od he ob vông kɨyang vô i. ");
INSERT INTO ptp_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Lêc Yesu xovô he nɨlô ge om nêl vô xomxo vɨgê nipaên tige ên nêbê, “Kɨdi mɨ lam le mahɨgun tinê.” Mêgem xomxo tyo kɨdi lec mɨ la le vac he mahɨgun. ");
INSERT INTO ptp_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Om Yesu nêl vô he vɨhati ên nêbê, “A ob kɨnêg vô xam bê xolac wê il Yuda vông ge, nêb il vông bêna lec sabatê? Nêb il vông nivɨha me nêb il vông nipaên? Om il ob vông xomxo i vô nivɨha, me il ob vông he i vô nipaên xel lec sabat?” ");
INSERT INTO ptp_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Mêd Yesu vô yê yê he vɨhati dɨ nêl vô xomxo vɨgê nipaên tige ên nêbê, “Tɨtô vɨgêm.” Mêd xomxo tyo tɨtô vɨgê, lêc vɨgê vô nivɨha lec. ");
INSERT INTO ptp_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Om xomxo wê xovô Moses xolac gee yuu Palisi, he xêyaa vô myavɨnê mabu dɨ he nêl vôma ên nêbê, “Om il ob vông bêna vô Yesu?” ");
INSERT INTO ptp_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Vô buc tige Yesu la lec kɨtôn ti ên nêb ob la kɨtaa vô Anutu, om bucên tige yadɨluhu Yesu kɨtaa vɨvuatɨtôv mɨ dô dɨ vɨgwe vɨdii lec. ");
INSERT INTO ptp_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Vɨgwe vɨdii mêd Yesu tyuc nue ngɨvihi vɨhati lam vô i mêd vɨnoo he vɨgê yuu dɨ tô mɨ la yuu wê ob kô lê aposolo ge. ");
INSERT INTO ptp_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Om he lê bêga, Saimon, wê Yesu nêl lê ngwe nêbê Pita, dɨ Pita li Andlu, dɨ Jems yuu Jon, dɨ Pilip yuu Batolomyu, ");
INSERT INTO ptp_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","dɨ Matyu yuu Tomas, dɨ Jems ngwe wê ma Alpias ge, dɨ Saimon Selot, ");
INSERT INTO ptp_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","dɨ Judas wê ma Jems ge dɨ Judas Iskaliot wê obêc hɨlung Yesu vô tɨbii vevac tɨmuên ge. ");
INSERT INTO ptp_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Pyap dêc Yesu he nue ngɨvihi sea kɨtôn tyo dɨ lop mɨ lôm tô lec vɨgwe hɨbuhu ngwe. Dɨ xomxo wê mi tɨmu vô Yesu gee hɨxôn xomxo Judia vɨgwe nipwopwo hɨxôn vɨgwe levac Jelusalem, dɨ Taia yuu Saidon wê yêp kwabo vô gwec nɨnya ge, he tɨbeac val kɨtucma mɨ dô, ");
INSERT INTO ptp_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","ên he nêb he ob ngô Yesu kɨyang, dɨ he wê yidac ge nêb Yesu i vông he ninɨvi i vô nivɨha lec. Dɨ xomxo wê vɨmwo nipaên vông he vô nipaên ge, Yesu tii vɨmwo vêl ên he dɨ vông he vô nivɨha lec. ");
INSERT INTO ptp_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Mêgem xomxo gee vɨhati nêb obêc hôm lec Yesu ninɨvi, ên he yê wê xêkɨzêc wê Yesu vông ge la vông xomxo tɨbeac vô nivɨha lec ge. ");
INSERT INTO ptp_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Mêd Yesu yê ma la nue ngɨvihi dɨ nêl vô he ên nêbê, “Xam wê xam xo ên xam nêbê xam o nivɨha lêm ge, xam xêmyaa i nivɨha, ên xam tu Anutu nue pyap. ");
INSERT INTO ptp_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","“Xam wê vip den xam ge, xam xêmyaa i nivɨha, ên tɨmuên ge od xam obêc wa i den xam. “Dɨ xam wê xam nɨlôm vɨyin dɨ xam byag gwêbaga ge, xam nɨlôm i vô nivɨha, ên xam obêc nap hɨxôn xêmyaa nivɨha tɨmuên. ");
INSERT INTO ptp_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Buc wê xomxo obêc yê xam nipaên ên wê xam vông i vin Xomxo Nu ge dɨ obêc tii xam dɨ nêl kɨyang nipaên lec xam dɨ so vya vô xam ên nêb xam tɨbii nipaên ge od xam nɨlôm i nivɨha. ");
INSERT INTO ptp_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Om buc wê he obêc vông bêge vô xam ge od xam pɨmil dɨ xêmyaa i vô nivɨha lee, ên nôn nivɨha wê xam obêc kô ge yêp vac Anutu ben lag puunê. Môp bêge wê he bue vông vô plopete ilage êno. ");
INSERT INTO ptp_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Dom xam wê mone levac yuu susu tɨbeac ge, xam xona nêm, ên xam kô susu nivɨha mɨ dô hɨxôn xêmyaa nivɨha pyap, om xam obêc kô nivɨha ti tɨmuên nang lêm. ");
INSERT INTO ptp_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","“Dɨ xam wê xam wa i den ge, xam xona nêm, ên vip obêc den xam tɨmuên. “Dɨ xam wê xam nap mɨ dô gwêbaga, xam xona nêm, ên xam obêc byag dɨ dô hɨxôn nɨlôm vɨyin tɨmuên. ");
INSERT INTO ptp_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","“Om xomxo vɨyang vɨyang obêc pɨmil xam ge, od xam xona nêm, ên he bue vông bêge vô plopete kɨtyooên ilage êno mêgê.” ");
INSERT INTO ptp_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Yesu nêl vô he ên nêbê, “A ob nêl vô xam wê xam ngô a kɨyang ga bêga bê xam xêmyaa i vin lec xomxo wê vông vevac vô xam ge, dɨ xam vông nivɨha vô xomxo wê he xêyaa vô nipaên vô xam ge. ");
INSERT INTO ptp_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Dɨ xam kɨtaa lec xomxo wê nêl vya vô xam ge, dɨ xam kɨtaa vô Anutu bê i vông nivɨha vô xomxo wê so vya vô xam ge. ");
INSERT INTO ptp_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Xomxo ti obêc pɨtap ông lia vɨlu ge od ông vông vɨluo hɨxôn vô i, dɨ xomxo ti obêc kô ông saket ge od ông o lêc kol siot lêm. Nge, ông vông vô i hɨxôn. ");
INSERT INTO ptp_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Dɨ xomxo ti obêc kɨtaa susu ti vô ông ge od ông vông vô i, dɨ xomxo ti obêc kô ông nêm susu ti mɨ la ge od le i lêc kɨdu bê i vông i lôm vô ông lêm. ");
INSERT INTO ptp_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Môp nivɨha wê xam nêb xomxo i vông vô xam ge, od xam vông nivɨha vô he êno bêge. ");
INSERT INTO ptp_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Ên xam xêmyaa obêc vin lec xomxo wê xêyaa vin lec xam ge vaci dɨ xêmyaa o vin lec xomxo baba hɨxôn lêm ge od xam ob kô pɨmilên nivɨha lec môp tibêge tibêna? Ên tɨbii nipaên xêyaa vin lec xomxo wê xêyaa vin lec he ge êno. ");
INSERT INTO ptp_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Dɨ xam obêc vông nivɨha vô xomxo wê vông nivɨha vô xam ge vaci ge od xam ob kô pɨmilên nivɨha lec môp tibêge tibêna? Ên tɨbii nipaên êno mi vông môp tibêge. ");
INSERT INTO ptp_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Dɨ xam obêc vông susu pɨleva vô xomxo lêc xam nêb he i vông myavɨwen vac ge od xam ob kô pɨmilên nivɨha lec môp tibêge tibêna? Ên tɨbii nipaên mi vông susu pɨleva vô xomxo nêb he i vông myavɨwen vac êno mêgê. ");
INSERT INTO ptp_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Om a ob nêl vô xam bê xam xêmyaa i vin lec xomxo wê vông vevac vô xam ge dɨ vông nivɨha vô he, dɨ xam vông susu vô xomxo dɨ le i lêc xo bê he i vông myavɨwen vac vô xam lêm. Xam obêc vông bêge ge od xam ob kô nôn nivɨha luu vêl tɨmuên dɨ xam ob tu Anutu lag puunê nue. Ên Anutu ge wê vông nivɨha vô tɨbii nipaên wê o mi pɨmil i lêm ge. ");
INSERT INTO ptp_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Mêgem xam êno xo vɨgwe pɨsiv ên xomxo dɨ vông nivɨha vô he i tɨyi xocbê Mag Anutu xo vɨgwe pɨsiv ên il ge.” ");
INSERT INTO ptp_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Yesu nêl vô he ên nêbê, “Xam o lêc yaxên xomxo nên kɨyang lêm, êdêc Anutu i yaxên xam nêm kɨyang êno lêm. Dɨ xam o lêc nêl vyam nipaên lec xomxo bê he i kô myavɨwen nipaên lêm, êdêc Anutu i nêl vya nipaên lec xam lêm. Dɨ xam pɨwelac kɨyang nipaên wê xomxo vông ge vêl êdêc Anutu i pɨwelac vêl ên xam êno. ");
INSERT INTO ptp_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Om xam vông susu vô xomxo lê, êdêc Anutu i vông vô xam êno. Ên Anutu obêc vông tɨbeac vô xam tɨyi xocbê ob vông vac xam sepac mɨ i pup lec dêc kɨtiv i tô mɨ la, dêc kɨpyax ya lec hɨxôn mɨ i pup lec dɨ kɨpyax sea ge. Ên môp wê xam vông vô xomxo ge od Anutu obêc vông i tɨyi wê xam vông vô he ge vô xam.” ");
INSERT INTO ptp_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Mêgem Yesu nêl kɨyang pɨlepacên ti vô he bêga ên nêbê, “Xomxo manôn tocên ngwe o tɨyi wê ob dɨdii xomxo ma tocên ngwe ge lêm. Ên ge od yuu xôn ob la tô madia. ");
INSERT INTO ptp_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Dɨ nipwo xumac xulacên ti ob luu ma wê tɨxuu he ge vêl lêm. Lêc he obêc kô xovôên nivɨha vac xumac kɨpihac mɨ la tɨyôô lec myahɨpu ge od he obêc tɨyi xocbê ma wê tɨxuu he ge. ");
INSERT INTO ptp_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Om ông ge, bêna lêc ông wê xax mavɨgen wê le vac lim manôn ge dɨ lungên levac mabu ngwe wê le vac ôcông va mamnôn ge? ");
INSERT INTO ptp_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Bêna lêc ông ob nêl vô lim bê, ‘Lige, a ob vông xax mavɨgen wê le vac ông mamnôn ge vêl,’ dom dɨlungên levac ngwe wê le vac ôcông va mamnôn ge? Ông xomxo kɨtyooên, ông pul xax levac wê le vac ôcông va mamnôn ge vêl tax dɨ mamnôn i seac nivɨha lê, êdêc pul nipwo tya wê le vac lim manôn ge vêl.” ");
INSERT INTO ptp_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Yesu nêl nang ên nêbê, “Xax nivɨha ti obêc vuac nôn nipaên lêm, dɨ xax nipaên obêc vuac nôn nivɨha lêm. ");
INSERT INTO ptp_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Xax vɨhati ge il ob xovô lec nôn toto. Ên xomxo ob yul hɨguc nôn lec hɨzap yatôv lêm, dɨ xomxo ob yul vɨyodac nôn lec kɨpomac yatôv lêm. ");
INSERT INTO ptp_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Dɨ il xomxo tɨyi lec bêge. Ên xomxo wê pɨyôp nivɨha yêp vac he nɨlô ge od ob vông môp nivɨha, dɨ xomxo wê nipaên yêp vac he nɨlô ge od mi vông môp nipaên. Ên kɨyang yuu xovôên wê pup vac xomxo nɨlô ge, xomxo mya nêl i lam seac. ");
INSERT INTO ptp_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Bêna lêc xam nêl a ên xam nêbê, ‘Apumtau, apumtau,’ lêc xam o vông a vyag wê a nêl vô xam ge vô nôn lec lêmê? ");
INSERT INTO ptp_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Xomxo wê lam vô a mɨ lam ngô a kɨyang dɨ vông a vyag vô nôn lec ge, a ob nêl he kɨtong vô xam. ");
INSERT INTO ptp_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","He tɨyi xocbê xomxo ti nêb ob lox xumac om yev lôva madia ta dêc hoo teac vac dêc tung ngɨdax la nêb ngɨdax i hôm teac xôn, dêc lox xumac lec, lêc lun val om mia butac mabu, lêc xumac tige o kɨpê lêm, ên xomxo tige lox i xumac xêkɨzêc ta. ");
INSERT INTO ptp_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Lêc xomxo wê ngô a kɨyang lê, lêc o vông i vô nôn lec lêm ge, ge tɨyi xocbê xomxo ti lox xumac lec kɨbun pɨleva dɨ o yev hɨpu la vac kɨbun lêm, om mia butac mɨ val mabu ge od dii i nên xumac sea.” ");
INSERT INTO ptp_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Yesu nêl kɨyang vɨhati mɨ xomxo ngô, pyap dɨ i loc mɨ la vɨgwe Kapaneam. ");
INSERT INTO ptp_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Mêd Lom tɨbii vevac levac ti dô vac vɨgwe tige, lêc i nu yuac ti vông yidac levac tɨyi wê ob yib ge. Tɨbii vevac tyo xêyaa vin lec nu yuac tige, ");
INSERT INTO ptp_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","lêc ngô wê Yesu val vɨgwe tige, om vông Yuda levac ya la vô Yesu ên nêb he i loc nêl vô Yesu ên i lam vông nu yuac tyo i vô nivɨha lec. ");
INSERT INTO ptp_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Om he mɨla vô Yesu dêc mɨla kɨtaa i xêkɨzêc ên nêbê, “Vô nɨnyam lehe vô tɨbii vevac tiganê vya, ên i ge xomxo nivɨha, ");
INSERT INTO ptp_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","wê xêyaa vin lec il Yuda dɨ i lox il xumac lɨlo ge.” ");
INSERT INTO ptp_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Mêd Yesu ngô he vya dɨ la hɨxôn he mɨ he la, mêd he mɨla kwabo vô tɨbii vevac tyo ben, lêc tɨbii tyo vông lie ya lam nêl i vya vô Yesu bêga ên nêbê, “Xomxo levac, a xomxo nigpaên, om ông o tɨyi wê ông ob vac lam vac a bog xumac lôma ge lêm, ");
INSERT INTO ptp_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","om a xovô ên a nêb a ob loc le vô ông mamnôn lêm. Lêc a nêb ông le teva dɨ vyam pɨleva i nêl, ên a nug i vô nivɨha lec. ");
INSERT INTO ptp_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","A xovô bêge, ên a ga êno wê a la vac xomxo levac vɨlu kwa ngɨbi, dɨ a nuge vevac ge wê la vac a kwa ngɨbi. Om a obêc nêl vô he ti bê i loc ge od ob la, dɨ a obêc nêl vô ti bê i lam ge od ob lam, dɨ a obêc nêl vô a nug yuac ti bê i vông yuac tige ge od ob vông. Om a xovô ên a nêbê ông ge xomxo xêkɨzêc om ông obêc le teva dɨ nêl ge od a nug ge ob vô nivɨha lec.” ");
INSERT INTO ptp_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Yesu ngô kɨyang wê xomxo tige nêl hɨxôn vông vinên ge om yetac ên dɨ pop manôn lax vô xomxo tɨbeac wê dɨtɨmu vô i vɨxa ge dɨ nêl vô he ên nêbê, “Xame, a ob nêl vô xam bê a o xê Islel ti vông i vin xêkɨzêc tɨyi xocbê tɨbii tiga vông ge lêm.” ");
INSERT INTO ptp_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Om xomxo wê tɨbii levac tige vông he la ge lax mɨ la tɨbii levac tyo ben, lêc mɨlax yê wê nu yuac tyo vô nivɨha lec ge. ");
INSERT INTO ptp_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Nang dêc buc ti lêc Yesu la vɨgwe Nen, dɨ nue ngɨvihi hɨxôn xomxo tɨbeac hɨwocên la hɨxôn. ");
INSERT INTO ptp_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Mêd Yesu mɨla kwabo vô vuayen wê ob la vac vɨyangtôv ge, lêc xomxo ken xomxo yibên ti mɨ val ên nêb ob kô mɨ la yev. Vêx vêxôv ti nu tibed tige, om xomxo vɨyang tige tɨbeac lam hɨxôn i. ");
INSERT INTO ptp_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Mêd Apumtau Yesu yê vêx tige dɨ xo vɨgwe pɨsiv ên i om nêl vô i ên nêbê, “Byagên i ma.” ");
INSERT INTO ptp_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Mêd la vyax vɨgê lec pêt wê yibên yêp lec ge dɨ xomxo wê ken ge le, dêc Yesu nêl vô yibên tyo ên nêbê, “Nug, a nêl vô ông bê ông kɨdi lec.” ");
INSERT INTO ptp_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Om yibên tyo kɨdi lec mɨ dô dɨ keac vô he, dêc Yesu vông i lax vô ta. ");
INSERT INTO ptp_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Mêgem xomxo tigee yê dɨ xona mabu, dɨ pɨmil Anutu ên nêbê, “Il nêd plopete levac ti kɨdi vac il mahɨgun ga mê.” Dɨ he ya nêbê, “Gwêbaga Anutu val le seac vô il madnôn ên nêb ob hôm il wê il tu ixe ge lec.” ");
INSERT INTO ptp_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Mêd xomxo nêl Yesu lê kɨtong mɨ i vô levac mɨ la vac vɨgwe Judia vɨhati dɨ la vac vɨgwe nɨnya nɨnya hɨxôn. ");
INSERT INTO ptp_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Mêd Jon Lipacên nue ngɨvihi lax mɨ la nêl Yesu do levac wê vông ge kɨtong vô Jon, ");
INSERT INTO ptp_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","om Jon keac nue ngɨvihi yuu lam vô i dɨ nêl vô yuu nêbê yuu i loc vô Apumtau Yesu ên loc kɨnêg vô i bê, “Xomxo ti wê plopete ilage nêl ên nêb obêc val ge, ông xomxo tyo tiga mê, me xe ob dô bin xomxo ngwe?” ");
INSERT INTO ptp_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Mêgem yuu mɨla vô Yesu dɨ la nêl vô i ên nêbê, “Jon Lipacên vông xii lam ên nêb xii lam kɨnêg ông bê xomxo ti wê plopete ilage nêl ên nêb obêc val ge, ông xomxo tyo tiga mê, me xe ob dô bin xomxo ngwe lê?” ");
INSERT INTO ptp_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Vô buc tya ge Yesu dô dɨ vông xomxo yidac kehe toto tɨbeac vô nivɨha lec dɨ tii vɨmwo nipaên vêl ên xomxo tɨbeac, dɨ vông xomxo wê manôn tocên ge, manôn seac. ");
INSERT INTO ptp_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Mêgem Yesu nêl vô yuu ên nêbê, “Muu lôc mɨ loc dɨ nêl môp wê muu ngô yuu wê ge kɨtong vô Jon bê xomxo manôn tocên, manôn seac, dɨ xomxo vɨxa nipaên, vɨxa vô nivɨha lec mɨ he la nivɨha, dɨ xomxo wê kɨtyax mahɨzihɨzi ge, kɨtyax yôv dɨ he vô nivɨha lec, dɨ xomxo wê nɨnya vô kɨtu ge, ngô kɨyang, dɨ xomxo yibên kɨdi lec mavɨha tii vac nang, dɨ xomxo wê nên susu maên gee ngô xolac nivɨha. ");
INSERT INTO ptp_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Xomxo wê nɨlô o vông yuu lec a lêm ge wê obêc dô hɨxôn xêyaa nivɨha.” ");
INSERT INTO ptp_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Jon nue ngɨvihi yuu ge lax mɨ la vêl, dêc Yesu nêl Jon kehe kɨtong vô xomxo tigee ên nêbê, “Ilage wê xam la vô Jon vac vɨgwe mahɨgun pɨleva ge, xam nêb xam ob la wê va? Xam nêb xam ob la ên la wê duvac wê lea kɨlê i la dɨ i hɨvip lec nang ge, me? ");
INSERT INTO ptp_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Xam la ên xam nêb xam ob la wê vatya? Xam nêb xam ob la wê xomxo wê vɨnyum ngakwi nivɨhavɨha ge ti, me? Lêc xomxo wê vɨnyum ngakwi paha wê nivɨha ge wê mi dô vac king ben. ");
INSERT INTO ptp_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Xam la ên xam nêb xam ob la wê plopete ti? Vɨxôhɨlôg, a nêl vô xam bê i plopete ti, lêc luu plopete vɨhati vêl. ");
INSERT INTO ptp_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Ên Anutu nêl Jon kɨtong mɨ i yêp vac kɨpihac xolac bêga ên nêbê, ‘Ngô lê, a ob vông xomxo ti i kô a kɨyang mɨ loc mug ông nêm môp, ên i viac môp wê ông obêc mɨla vac ge.’ ");
INSERT INTO ptp_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Anutu kɨyang bêge, dɨ a ob nêl vô xam bê Jon ge xomxo levac luu xomxo kɨbun ga vɨhati vêl. Vɨxôhɨlôg, lêcom xomxo vɨhati wê vô nipwo lec vac Anutu ben ge obêc luu Jon vêl.” ");
INSERT INTO ptp_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Mêd xomxo wê mi kô takis gee hɨxôn xomxo vɨhati, he ngô Yesu kɨyang tige dɨ vô nɨnya lehe vô ên nêbê Anutu môp ge nivɨha, ên ilage he pɨlepac he dɨ Jon lipac he. ");
INSERT INTO ptp_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Lêc Palisi yuu xomxo wê xovô Moses xolac gee, he vô nɨmi vô Anutu môp nivɨha wê hɨlung vô he ge, om he nêb Jon i o lêc lipac he lêm. ");
INSERT INTO ptp_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Mêd Yesu nêl nang ên nêbê, “Xomxo buc gwêbaga, he va bêna? A ob tɨxuu he môp lec kɨyang ti. ");
INSERT INTO ptp_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","He tɨyi xocbê nue nipwo wê dô lec wetôv dɨ tyucma ên nêbê, ‘Xame, xe hi vyang lêc xam o yoo lêm, nang dɨ xe vông tɨlôt lê, lêc xam o byag lêm.’ He môp tɨyi xocbê môp wê xam nêl vô xii Jon ge, ");
INSERT INTO ptp_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","ên Jon Lipacên val, lêc mi ngɨbua yaên dɨ numên wain ma, lêcom xam nêl ên xam nêbê vɨmwo nipaên dô vac i nɨlô. ");
INSERT INTO ptp_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Nang dêc a, Xomxo Nu, a val lêc a mi xa dɨ num vô, dɨ a o ngɨbua ti lêm, lêc xam nêl ên xam nêbê, ‘Wê lê. Xomxo tige va mi ya levac dɨ mi num wain levac mɨ vô mavmav, dɨ mi dô hɨxôn xomxo wê mi kô takis lêc mi vun mangwe ge yuu tɨbii nipaên.’ ");
INSERT INTO ptp_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Xam mi nêl bêge, lêcom a ob nêl vô xam bê xomxo wê tɨmu vô pɨyôp nivɨha dɨ kô xovôên vô Anutu ge, he nêl ên nêbê xovôên wê Anutu vông ge nôn vɨxôhɨlôg.” ");
INSERT INTO ptp_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Palisi ti lê nêbê Saimon nêl vô Yesu ên nêb i loc vac i ben ên yuu ob ya. Om Yesu la vac i ben dɨ yuu dô dɨ ya. ");
INSERT INTO ptp_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Mêd vêx nipaên ti wê mi dô vac vɨgwe tige ngô wê Yesu la dô vac Palisi tyo ben dɨ la ya hɨxôn i ge, om kô butol nivɨha ti wê wel nivɨvea le vac ge dɨ la vac Palisi tyo ben, ");
INSERT INTO ptp_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","dɨ la le kwabo vô Yesu vɨxa dɨ byag mɨ dô, dɨ maluc yuc lec Yesu vɨxa pɨtehe. Om vêx tyo kɨtya maluc ya bazub lihi, dɨ hɨwaa Yesu vɨxa pɨtehe dɨ lipac wel nivɨvea tyo lec Yesu vɨxa. ");
INSERT INTO ptp_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Mêd Palisi ti wê nêl Yesu lam vac i ben tige yê môp wê vêx tyo vông ge, om xo bêga ên nêbê, “Xomxo tige obêc plopete ti vɨxôhɨlôg ge od obêc xovô vêx tige wê lam hôm vɨgê lec i ge dɨ obêc xovô i môp wê mi vông ge bê i vêx nipaên ti.” ");
INSERT INTO ptp_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Mêd Yesu nêl vô Palisi tyo ên nêbê, “Saimon, a ob nêl kɨyang ti vô ông.” Mêd Saimon nêl lax vô ên nêbê, “Om ông nêl kɨyang ti wê ông ob nêl ge.” ");
INSERT INTO ptp_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Om Yesu nêl ên nêbê, “Xomxo yuu la kô mone vô xomxo ti, ngwe kô mone yul ti (K100) dɨ ngwe kô mone kɨpihac ti (K10). Om yuu xôn myavɨwen yêp vô xomxo tige. ");
INSERT INTO ptp_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Lêcom yuu xôn o tɨyi wê yuu ob lax hi myavɨwen vêl ge lêm, om xomxo tyo vaci hi yuu myavɨwen vêl. Om a ob kɨnêg vô ông bê xomxo yuu ge, ngwe na xêyaa ob vin lec xomxo tyo luu vêlê?” ");
INSERT INTO ptp_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Mêd Saimon nêl ên nêbê, “Mêd obêc ngwe wê i myavɨwen levac ge.” Mêd Yesu nêl vô i ên nêbê, “Ông nêl lec bôbac.” ");
INSERT INTO ptp_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Mêd Yesu pɨlepac i vô vêx tige dɨ nêl vô Saimon ên nêbê, “Om wê vêx tiga. A lam dô vac ông bom ga lê, lêc ông o tɨmu vô môp wê il Yuda mi vông ge lêm dɨ vông mia ên a lipac vɨxag vac lêm. Dom vêx tiga lipac a vɨxag ya maluc dɨ kɨtya vêl ya bazub lihi. ");
INSERT INTO ptp_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Dɨ buc wê a lam vac ông bom ga ge, od ông o pul a vɨgêg dɨ hôm a lec nivɨha lêm. Dom vêx tige val lê, lêc hôm a lec nivɨha dɨ le hɨwaa a vɨxag. ");
INSERT INTO ptp_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Dɨ ông o lipac wel lec a bagzub lêm. Dom vêx tiga val lipac wel nivɨvea lec a vɨxag. ");
INSERT INTO ptp_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Om a ob nêl vô ông bê vêx tiga xêyaa vin lec a luu vêl om nêl i kɨtong ên nêbê i nên nipaên tɨbeac lê, lêc Anutu kɨtya vɨhati vêl om i xêyaa vin lec a luu vêl. Lêc xomxo ngwe wê Anutu kɨtya i nên nipaên yuutyabed vêl ge od xêyaa obêc vin lec Anutu nipwo tya.” ");
INSERT INTO ptp_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Mêd Yesu nêl vô vêx tyo ên nêbê, “A nêl vô ông bê a kɨtya ông nêm nipaên vêl pyap.” ");
INSERT INTO ptp_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Mêd xomxo wê dô mɨ ya hɨxôn Yesu gee xo bêga ên nêbê, “Xomxo tige letya lêc kɨtya xomxo nên nipaên vêlê?” ");
INSERT INTO ptp_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Mêd Yesu nêl vô vêx tyo ên nêbê, “Vông vinên wê ông vông ge, ge wê kɨtya ông nêm nipaên vêl dɨ vông ông vô nimvɨha lec. Om ông lôc hɨxôn xêmyaa nivɨha.” ");
INSERT INTO ptp_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Nang dêc Yesu he nue ngɨvihi vɨgê yuu dɨ tô mɨ la yuu tup vac vɨgwe levac yuu nipwo toto, dɨ Yesu nêl Anutu ben kehe kɨtong vô xomxo. ");
INSERT INTO ptp_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Mêd vêx ya mi la hɨxôn Yesu he nue ngɨvihi ên nêb ob viac he. Vêx tigee wê ilage Yesu tii vɨmwo nipaên vêl ên mangwe dɨ vông he mangwe yidac kehe toto ge vô nivɨha lec. Om he lê bêga, Malia Makdala ti wê Yesu tii vɨmwo nipaên vɨgê vɨlu dɨ sec yuu la vêl ên i ge, ");
INSERT INTO ptp_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","dɨ Joana wê lɨya Susa mi viac King Helot xumac ge, dɨ ti lê Susana, dɨ vêx tɨbeac yaya hɨxôn. Om vêx tigee wê viac Yesu he nue ngɨvihi ya he mone dɨ ngɨdu he xôn ên yuac wê he vông ge. ");
INSERT INTO ptp_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Om buc ti lêc xomxo tɨbeac vac vɨgwe toto toto ge kɨtuc la vô Yesu, mêgem Yesu nêl kɨyang pɨlepacên ti vô he bêga ên nêbê, ");
INSERT INTO ptp_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Xomxo ti kɨdi mɨ la ên nêb ob la lɨloo ngec vê vac yuac. Om lɨloo i la lê, lêc vê mangwe tô vac môp om xomxo kê dɨ menac lam ya. ");
INSERT INTO ptp_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Dɨ ya tô lec ngɨdax wê kɨbun nipwo tya dô lec ge, om tyip lutibed lêc kɨbun niluc ma om hɨyôv ya i vɨlôvac dɨ i yib. ");
INSERT INTO ptp_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Dɨ mangwe tô mɨ la dô vac hɨvu kehe om hɨvu tyip hɨxôn dɨ hi i yib. ");
INSERT INTO ptp_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Dɨ mangwe tô mɨ la dô vac kɨbun nivɨha om tyip nivɨha dɨ vuac nôn nivɨha 100 100 tɨyi kehe toto ge.” Yesu nêl bêge vô he dêc nêl ên nêbê, “Xomxo ti nɨnya obêc yêp ge od i ngô dɨ xovô.” ");
INSERT INTO ptp_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Mêd Yesu nue ngɨvihi kɨnêg kɨyang pɨlepacên tige kehe vô Yesu. ");
INSERT INTO ptp_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Om Yesu nêl vô he ên nêbê, “Kɨyang lec Anutu môp yuu ben ge yêp xôpacên lê, lêc Anutu nêb ob hɨlung kehe vô xam ên xam xovô. Dɨ xomxo baba ge ngô kɨyang tɨyi xocbê kɨyang pɨlepacên pɨleva, om he yê lê, lêc yêvôên nôn ti ma, dɨ he ngô kɨyang lê, lêc xovôên kehe ma. ");
INSERT INTO ptp_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Kɨyang pɨlepacên tyo kehe bêga nêbê vê ge Anutu kɨyang. ");
INSERT INTO ptp_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Dɨ vê wê tô vac môp ge, ge tɨyi xocbê xomxo ngô Anutu kɨyang lê, lêc lutibed Seten lam vô vêl ên he nɨlô, ên nêb he i o lêc vông i vin Anutu dɨ i vô he vêl ên nipaên lêm. ");
INSERT INTO ptp_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Dɨ vê wê tô mɨ la dô lec ngɨdax wê kɨbun nipwo tya dô lec ge, ge tɨyi xocbê xomxo ngô xolac dɨ vông i vin lutibed hɨxôn xêyaa nivɨha tax tyaa, lêc he tɨyi xocbê ngec wê ngɨlôhô maên ge, ên he vông i vin nipwo tya lêc Seten yaxên he ge od he sea vông vinên lutibed. ");
INSERT INTO ptp_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Dɨ vê wê tô mɨ la dô vac hɨvu kehe ge, ge tɨyi xocbê xomxo ngô xolac mɨ dô lê, lêc he nɨlô xovô susu nivɨhavɨha kɨbun ga yuu mone hɨxôn vɨyin ya wê ob tulec he ge om hɨvun xolac xôn dɨ nôn ma. ");
INSERT INTO ptp_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Dɨ vê wê tô mɨ la dô vac kɨbun nivɨha ge, ge tɨyi xocbê xomxo wê ngô xolac mɨ xovô dɨ hôm pɨlihi hɨxôn nɨlô yuu xovôên nivɨha, om he le xêkɨzêc ta dɨ vô nôn tɨbeac. ");
INSERT INTO ptp_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Xomxo ti obêc byêx ngwax vac lam ge od ob lax dêg lec me vun vac pêt ngɨbi lêm. Nge, ob yu i yux seac ên xomxo wê ob lam vac xumac nɨlô ge, he i lam yê xêseac. ");
INSERT INTO ptp_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Ên kɨyang vɨhati wê yêp xôpacên ge obêc lam le seac, dɨ kɨyang vɨhati wê yêp vac nɨlô ge obêc hɨvelac lec mɨ nôn lam le seac. ");
INSERT INTO ptp_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","“Mêgem kɨyang wê xam ngô ge, xam vyac xovô nivɨha lê. Ên xomxo wê xovô kɨyang mɨ hôm pɨlihi ge od Anutu obêc kɨpyax tɨbeac lec hɨxôn vô i. Lêc xomxo wê o xovô kɨyang mɨ hôm pɨlihi lêm ge od nipwo tya wê dô vô i ge, Anutu obêc vô vêl.” ");
INSERT INTO ptp_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Yesu tae lie val ên nêb ob la vô Yesu, lêc tɨyiên ma ên tɨbii tɨbeac kɨtucma om kɨsuu Yesu lec. ");
INSERT INTO ptp_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Om xomxo ya nêl vô Yesu ên nêbê, “Tame lime val le vɨxun ên nêb ob yê ông.” ");
INSERT INTO ptp_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Lêc Yesu nêl vô he ên nêbê, “Xomxo wê ngô Anutu xolac dɨ vông i vô nôn lec ge, ge wê tu a tage lige ge.” ");
INSERT INTO ptp_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Buc ti lê lêc Yesu he nue ngɨvihi lec dipac ti dɨ Yesu nêl vô he ên nêbê, “Il ob la mia luaên vɨlu ganê.” ");
INSERT INTO ptp_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Om he la lê, lêc Yesu yêp mêd lea vɨyiiên mabu ti val om vông mia vuac mabu tɨyi wê ob pup lec dipac dɨ kɨpyax he la vac mia ge. ");
INSERT INTO ptp_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Om nue ngɨvihi la tɨpi vô Yesu dɨ nêl ên nêbê, “Xomxo levac, il ob la xib ga.” Om Yesu kɨdi lec dɨ pɨping lea yuu mia vuacên dɨ i tip la dɨ mia vô malehe lec. ");
INSERT INTO ptp_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Mêgem Yesu nêl vô nue ngɨvihi ên nêbê, “Xam vông vinên tyo nôn tina?” Mêgem he xona dɨ yetac mabu dɨ nêl vôma ên nêbê, “Xomxo tiga letya lêc nêl vya lec lea yuu mia dɨ i vô nɨnya lehe vô i dɨ tip la lutibedê?” ");
INSERT INTO ptp_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Yesu he nue ngɨvihi loc mɨ la tɨbii Gegesa ben wê yêp mia luaên vɨlu ganê ge dɨ Galili ge yêp mia vɨlu. ");
INSERT INTO ptp_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","He mɨla lop vêl ên dipac dɨ xomxo ti vac vɨgwe tige val vô Yesu. Vux tige vɨmwo nipaên dô vac i nɨlô mɨ vông i pɨyôp vô yacyac om buc mahɨgun dia tige o mi vɨnyum vɨnyumên ti lêm, dɨ sea ben vɨyangtôv yuu xumac wê ob yêp vac ge dɨ la mi yêp vac vɨgwe wê xomxo yev yibên vac ge. ");
INSERT INTO ptp_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","Om xomxo mi ku i vɨgê yuu vɨxa xôn ya sen dɨ yê i xôn mɨ dô lê, lêc buc tɨbeac vɨmwo nipaên ngɨgax i xêkɨzêc dɨ tax sen tip sea dɨ kô i mɨ la vac vɨgwe myadongên. Mêd xomxo tyo yê Yesu dɨ la yev vɨxa vô i, dɨ Yesu pɨping vɨmwo nipaên nêb i loc vêl ên xomxo tyo. Om xomxo tyo iac mabu dɨ nêl ên nêbê, “Yesu, ông ge Anutu lag puunê nu ông, lêcom ông ob vô va vô a? A kɨtaa ông bê ông o lêc vông a vô nipaên lêm.” ");
INSERT INTO ptp_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Mêd Yesu kɨnêg vô i ên nêbê, “Ông lêm le?” Lêc tyo nêl ên nêbê, “A lêg kehe nêbê kɨdu levac.” Nêl lê bêge, ên vɨmwo nipaên tɨbeac dô vac i nɨlô. ");
INSERT INTO ptp_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Mêd vɨmwo nipaên tigee kɨtaa Yesu ên nêbê, “Ông o lêc tii xe la vac Seten ben nipaên lêm.” ");
INSERT INTO ptp_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Bwoc kɨdu levac dɨya mɨ le lec kɨtôn tige, om vɨmwo nipaên tigee kɨtaa Yesu ên nêb i vông he la dô vac. Om Yesu tyuc lec, ");
INSERT INTO ptp_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","dɨ vɨmwo nipaên tigee lam la vêl ên xomxo tyo dɨ la dô vac bwoc tyoe nɨlô, mêd bwoc tyoe tup mɨ la dɨ la vac vɨgwe madia dɨ la tô vac mia luaên dɨ num mia mɨ yib mɨma vêl. ");
INSERT INTO ptp_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Mêd xomxo wê mi viac bwoc tyoe ge yê wê bwoc la yib mɨma vêl ge, om pec mɨ la, dɨ mɨla nêl kɨtong vô tɨbii vac vɨgwe levac hɨxôn vɨgwe nipwo vɨyang vɨyang ge. ");
INSERT INTO ptp_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Om tɨbii wê ngô kɨyang ge la ên nêb ob la yê han, mêgem he mɨla vô Yesu lêc yê wê xomxo ti wê vɨmwo nipaên dô vac i ge, vɨmwo nipaên lop mɨ la vêl dɨ i dô hɨxôn pɨyôp nivɨha dɨ vɨnyum ngakwi lec dɨ xeedô kwabo vô Yesu dɨ ngô Yesu kɨyang. Om he yê tige dɨ xona mabu. ");
INSERT INTO ptp_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Mêgem xomxo wê dô mɨ yê wê Yesu tii vɨmwo nipaên vêl ên xomxo tige mɨ vông i vô nivɨha lec ge, nêl i tɨyi wê he yê ge kɨtong vô tɨbii wê val gee hɨxôn. ");
INSERT INTO ptp_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Om tɨbii Gegesa vɨhati kɨtaa Yesu ên nêb i loc vêl ên he ben. He nêl bêge ên he xona mabu, mêgem Yesu lec dipac ên nêb ob lax mɨ la. ");
INSERT INTO ptp_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Lêc xomxo ti wê Yesu tii vɨmwo nipaên vêl ên i ge, lam kɨtaa Yesu ên nêb ob la hɨxôn, lêc Yesu vông i lax mɨ la ben dɨ nêl vô i ên nêbê, ");
INSERT INTO ptp_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Ông lôc mɨ loc bom dɨ loc nêl do levac wê Anutu vông vô ông ge kɨtong vô xomxo vɨhati.” Mêgem xomxo tyo lax mɨ la ben dɨ la nêl kɨyang wê Yesu vông i vô nivɨha lec ge kɨtong vô xomxo vɨhati. ");
INSERT INTO ptp_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Yesu lax mɨ la mia luaên vɨlu Galili ge nang, lêc xomxo tɨbeac dɨbin i mɨ xeedô, om he xêyaa vô nivɨha ên wê Yesu vena ge. ");
INSERT INTO ptp_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Mêd xomxo levac ti lê nêbê Jailas val vô Yesu. Jailas ge wê tu levac dɨ mi viac lie Yuda hɨxôn xumac lɨlo ge, lêc lam yev vɨxa kɨtu vô Yesu dɨ kɨtaa i ên nêbê i loc vac i ben, ");
INSERT INTO ptp_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","ên nu byac vông yidac levac ti mɨ vô kwabo lec wê ob yib ge. Nu byac tige tibed dɨ i klismas 12. Om Yesu la hɨxôn Jailas mɨ yuu la, lêc xomxo tɨbeac lam vuac lec Yesu. ");
INSERT INTO ptp_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Mêd vêx ti dô vac he mahɨgun, lêc vêx tige, yidac kwatuacên vông i tɨyi klismas 12, lêc o ma lêm, dɨ vêx tyo vông i mone la mɨma vô docta lê, lêc ti o tɨyi wê ob vông i vô nivɨha lec ge lêm. ");
INSERT INTO ptp_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Mêgem vêx tyo val le vô Yesu nɨmi dɨ vyax vɨgê lec Yesu ngakwi myahɨpu mêgem lutibed hi tyo kwep lec. ");
INSERT INTO ptp_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Mêd Yesu nêl ên nêbê, “Letya vyax vɨgê lec a?” Lêc xomxo vɨhati nêl lax ên nêbê, “Maê, xe ga maê.” Mêgem Pita nêl ên nêbê, “Xolac kehe, xomxo tɨbeac le i ngɨvina ông dɨ vɨgwe tocên ma, om letya yêvô ti wê vyax vɨgê lec ông ge?” ");
INSERT INTO ptp_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Lêc Yesu nêl lax ên nêbê, “Ti vyax vɨgê lec a, om a yaxên lêc xêkɨzêc la vêl ên a.” ");
INSERT INTO ptp_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Mêgem vêx tige xovô nêbê o tɨyi wê ob yax i vun ge lêm, om la hɨxôn ni yetacên mɨ la yev vɨxa vô Yesu dɨ nêl i kehe wê vyax vɨgê lec Yesu ge kɨtong dɨ nêl lec wê i yidac ma lutibed ge kɨtong hɨxôn, dɨ xomxo tigee vɨhati yê hɨxôn. ");
INSERT INTO ptp_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Mêgem Yesu nêl vô i ên nêbê, “Nuge, vông vinên wê ông vông ge, ge wê vông ông vô nimvɨha lec. Om ông lôc hɨxôn nɨlôm nivɨha.” ");
INSERT INTO ptp_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Yesu gên dɨnêl kɨyang mɨ dô, dɨ xomxo ti vac Jailas ben val nêl vô Jailas ên nêbê, “Num byac yib gwêba, mêgem le i lêc vông yuac levac vô xolac kehe mɨ i lam lêm.” ");
INSERT INTO ptp_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Mêd Yesu ngô kɨyang tige dɨ nêl vô Jailas ên nêbê, “Le nɨlô i vô vɨyin lêm. Nge, ông vông i vin mô, ên num ge ob vô nivɨha lec.” ");
INSERT INTO ptp_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Mêgem Yesu mɨla Jailas ben lêc nêl vô xomxo vɨhati ên nêb he i dô vɨxun, dêc kô Pita yuu Jon dɨ Jems dɨ nu tige ta yuu ma hɨxôn dɨ he la vac xumac lôma. ");
INSERT INTO ptp_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Mêd xomxo vɨhati byag mɨ vông tɨlôt ên vêx tyo mɨ dô, lêc Yesu nêl vô he ên nêbê, “Byagên i ma, ên vêx ge o yib lêm. Nge, ici va yêp.” ");
INSERT INTO ptp_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Lêc xomxo tigee nap lec Yesu kɨyang ên he xovô ên he nêbê vêx ge yib vêl. ");
INSERT INTO ptp_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Mêlêc Yesu la hôm lec vêx tyo vɨgê dɨ nêl vya levac ên nêbê, “Byac, kɨdi lec.” ");
INSERT INTO ptp_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Mêgem vêx tyo myakɨlôhô lax mɨ la vac ninɨvi dɨ i kɨdi lec lutibed mɨ dô, dɨ Yesu nêl ên nêbê, “Xam vông yaên ti mɨ i ya.” ");
INSERT INTO ptp_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Mêd vêx tyo ta yuu ma yetac mabu ên wê nu kɨdi lec ge, lêc Yesu nêl vô yuu ên nêbê, “Muu o lêc nêl ga kɨtong vô xomxo ti lêm.” ");
INSERT INTO ptp_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Yesu tyuc nue ngɨvihi vɨgê yuu dɨ tô mɨ la yuu la vô i dɨ vông xêkɨzêc wê i vông ge vô he ên nêb he i loc tii vɨmwo nipaên vêl ên xomxo dɨ vông xomxo yidac i vô nivɨha lec. ");
INSERT INTO ptp_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Mêd Yesu vông he la ên nêb he i loc nêl Anutu ben yuu môp kɨtong vô xomxo i tɨyi vɨgwe vɨhati dɨ vông he wê yidac gee i vô nivɨha lec. ");
INSERT INTO ptp_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Mêd nêl vô he ên nêbê, “Xam o lêc kô susu ya hɨxôn lêc loc vô môp lêm, xocbê pɨtoa yuu vɨxec dɨ yaên yuu mone dɨ vɨnyumên yuu lêm. Nge, xam loc ya vɨgêm pɨleva dɨ vɨnyumên tibed. ");
INSERT INTO ptp_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Dɨ xam obêc mɨla vac vɨgwe ti mɨ la dô vac xumac ti ge od xam dô vac xumac tige tibed i tɨyi buc wê xam ob dô ge. Pyap dêc xam sea vɨgwe tige dɨ loc bangwe. ");
INSERT INTO ptp_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Lêc xam obêc mɨla vac vɨgwe ti lêc xomxo vɨyang tige o hôm xam lec nivɨha lêm ge od xam lɨloo vɨjuva vêl ên vɨxam ên i nêl he nên nipaên kɨtong vô he dɨ loc.” ");
INSERT INTO ptp_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Om Yesu nue ngɨvihi la vac vɨgwe vɨyang vɨyang ge dɨ la nêl xolac vac vɨgwe toto ge dɨ vông xomxo yidac vô nivɨha lec. ");
INSERT INTO ptp_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Hɨzap levac Helot ngô kɨyang wê xomxo mi nêl lec Yesu ge lêc vông i nɨlô vô juda juda, ên xomxo ya nêl ên nêbê Yesu ge Jon Lipacên wê yib ge lêc kɨdi lec nang, ");
INSERT INTO ptp_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","dɨ xomxo ya nêl ên nêbê ge plopete Ilaija wê dô ilage om vena nang, dɨ he ya nêl ên nêbê ge plopete ilage ti kɨdi lec vac yibên. ");
INSERT INTO ptp_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Mêd Helot nêl ên nêbê, “Jon Lipacên ge wê a kɨtov i kwa ilage, lêcom xomxo letya tiganê lêc tɨbii dɨnêl kɨyang tibêge lec i?” Om Helot myag ên nêb ob yê Yesu. ");
INSERT INTO ptp_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Mêd nue ngɨvihi wê Yesu vông he la yuac ge vena nêl he yuac kɨtong vô Yesu. Om Yesu kô heche va dêc sea xomxo baba dô dɨ he la vac vɨgwe ti lê nêbê Betsaida. ");
INSERT INTO ptp_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Lêc xomxo ngô wê he la ge om tɨmu vô Yesu he nue ngɨvihi vɨxa dêc mɨla vô he, mêd Yesu xêyaa vô nivɨha ên wê he mɨla ge, om nêl Anutu ben yuu môp kɨtong vô he dɨ vông he wê yidac ge vô nivɨha lec. ");
INSERT INTO ptp_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","He dô dɨ vɨgwe huc om nue ngɨvihi vɨgê yuu dɨ tô mɨ la yuu la nêl vô Yesu ên nêbê, “Vông xomxo tigae i loc, ên he i loc vac vɨgwe vɨyang vɨyang ge ên loc kɨsuu yaên dɨ loc yêp, ên vɨgwe ga, vɨgwe myadongên.” ");
INSERT INTO ptp_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Lêc Yesu nêl vô he ên nêbê, “Xacxam va ob vông yaên vô he mɨ he i ya.” Lêc he nêl lax vô Yesu ên nêbê, “Xe xom yaên ga o tɨbeac lêm, blet vɨgê vɨlu dɨ beac yuutyabed. Lêcom ông nêb xe la kɨsuu yaên vô xomxo tɨbeac tigae, me?” ");
INSERT INTO ptp_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","He nêl bêge ên xomxo tigee tɨbeac hɨwocên mêgem vux vaci, he 5,000. Mêgem Yesu nêl vô nue ngɨvihi ên nêbê, “Xam vông he i loc dô kɨdu kɨdu i tɨyi xomxo kehe yuu dɨ vɨgê yuu (50).” ");
INSERT INTO ptp_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Om he vông tɨbii la dô i tɨyi wê Yesu nêl ge. ");
INSERT INTO ptp_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Mêgem Yesu hôm blet vɨgê vɨlu ge hɨxôn beac yuu ge dɨ lax ma la lag kɨsiinê dêc kɨtaa lec blet yuu beac dɨ hɨbu mɨ vông vô nue ngɨvihi ên nêb he i kô mɨ loc tɨtang vô xomxo tyoe. ");
INSERT INTO ptp_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Mêd xomxo vɨhati ya i den he dêc nue ngɨvihi la kɨtuc myapɨpu wê gên dô ge mɨ su vac sepac vɨgê yuu dɨ tô mɨ la yuu mɨ i pup lec. ");
INSERT INTO ptp_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Buc ti Yesu he nue ngɨvihi la dô vac vɨgwe ti, mêd Yesu vaci kɨtaa vô ma Anutu mɨ dô. Pyap dêc kɨnêg vô nue ngɨvihi ên nêbê, “Xomxo mi nêb a letya?” ");
INSERT INTO ptp_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Mêd he nêl lax vô i ên nêbê, “Ya nêbê ông ge Jon Lipacên, dɨ ya nêbê ông Ilaija, dɨ ya nêb ông plopete ilage ti lêc ông kɨdi lec vac yibên mɨ dô gwêbaga.” ");
INSERT INTO ptp_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Mêd Yesu nêl vô he ên nêbê, “Dɨ xacxam va nêb a letya?” Mêlêc Pita nêl ên nêbê, “Ông ge Kɨlisi wê Anutu vông ông lam ge.” ");
INSERT INTO ptp_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Mêd Yesu nêl kɨyang xêkɨzêc vô he nêbê he i o lêc nêl i kɨtong vô xomxo ti lêm, ");
INSERT INTO ptp_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","dɨ nêl vô he ên nêbê, “A, Xomxo Nu, a obêc kô myavɨnê levac mabu, dɨ he Yuda levac levac hɨxôn xomxo levac wê mi si daa vô Anutu gee hɨxôn he wê xovô Moses xolac gee, he obêc vô nɨmi vô a dɨ hi a xib, dɨ buc yon obêc la vêl lêc a obêc kɨdi lec magvɨha i tii vac nang.” ");
INSERT INTO ptp_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Mêd Yesu nêl vô he vɨhati ên nêbê, “Xomxo ti obêc nêb tɨmu vô a kɨyang ge od i vông i vô nipwo lec i tɨyi buc vɨhati dɨ kɨlê vɨyin i tɨyi xocbê kɨlê xax pola ge mɨ tɨmu vô a vɨxag. ");
INSERT INTO ptp_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Ên xomxo ti obêc viac ici va ninɨvi nivɨha ên nêb ob dô mavɨha ge od kɨnu hɨxôn ninɨvi obêc yib. Lêc xomxo ti obêc sea ninɨvi lec a lêg ge od obêc dô mavɨha luta. ");
INSERT INTO ptp_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Ên xomxo ti obêc kɨtuc susu kɨbun ga vɨhati tu ixe, lêc ici va obêc yib mɨ la vac nipaên ge od obêc vô nivɨha vô i tibêna? ");
INSERT INTO ptp_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Ên xomxo ti obêc vô nɨmi vô a hɨxôn a xolac ge od a, Xomxo Nu, a êno obêc vô nɨmig vô i lec buc wê a obêc lop mɨ lôm hɨxôn xêseac wê Mag Anutu yuu angela ngɨbua vông ge. ");
INSERT INTO ptp_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Lêc a ob nêl hɨxôn nôn vô xam bê xam wê xam le ga, xam ya ob dô mɨ wê wê Anutu nu ob lam tu king ge lê dêc wib tɨmuên.” ");
INSERT INTO ptp_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Yesu nêl kɨyang tige pyap dêc da ti la vêl mêd kô Pita yuu Jon yon Jems mɨ he la lec kɨtôn ti ên Yesu nêb ob la kɨtaa. ");
INSERT INTO ptp_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Om Yesu kɨtaa mɨ dô, lêc ninɨvi pɨlepac mɨ vô bangwe dɨ i ngakwi vô makwem ta dɨ tee lec vɨgwe. ");
INSERT INTO ptp_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","31","Mêd lutibed xomxo yuu lam hɨxôn xêseac mɨ lam le hɨxôn Yesu dɨ yon keac. Ge Moses yuu Ilaija, om yuu nêl lec môp wê Yesu ob la vông gê Jelusalem dɨ nêl lec wê ob sea kɨbun ga ge. ");
INSERT INTO ptp_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Pita yon li yuu manôn vô yêp yêp lê, lêc yon manôn seac dɨ yon yê xêseac wê Yesu vông ge dɨ yê xomxo yuu wê le hɨxôn i ge. ");
INSERT INTO ptp_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Pyap mêd xomxo yuu ge nêl vô Yesu ên nêb yuu ob la, lêc Pita nêl vô Yesu ên nêbê, “Xolac kehe, ga nivɨha wê il dô ga, om xen ob lox xumac yon, ông nêm ti, dɨ Moses nên ti dɨ Ilaija nên ti.” Pita lungên kɨyang wê ob nêl ge om nêl kɨyang bêge pɨleva. ");
INSERT INTO ptp_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Pita gên nêl kɨyang tige dêc vɨyobtoc ti lam hɨvun he xôn om yon xona. ");
INSERT INTO ptp_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Mêd vya ti lam vac vɨyobtoc dɨ nêl ên nêbê, “Ge a nug wê a vɨnoo i ge om xam ngô i vya.” ");
INSERT INTO ptp_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Vya nêl pyap mêd yon yê wê Yesu tibed xeele ge. Mêd vô buc tigee yon o nêl kɨyang wê yon yê ge kɨtong vô xomxo ti lêm. ");
INSERT INTO ptp_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Vɨgwe vɨdiiên tɨtige he sea kɨtôn dɨ lax mɨ la, lêc mɨla vô xomxo tɨbeac wê dɨval vô môp ge, ");
INSERT INTO ptp_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","mêd xomxo ti vac he mahɨgun tyuc vya levac ên nêbê, “Xolac kehe, a kɨtaa ông bê ông wê a nug vux tiga lê, ên a nug nôn tibed ga mê. ");
INSERT INTO ptp_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Lêc buc tɨbeac vɨmwo nipaên ti hôm i xôn dɨ vông i iac mabu dɨ vô pwoo pwoo i mɨ hi i lec kɨbun dɨ mya ngɨmong lam, om vông i vô nipaên dɨ o sea i lutibed lêm. ");
INSERT INTO ptp_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Om a kɨtaa nume ngɨvihi ên a nêb he i tii vɨmwo nipaên tiga i loc vêl lêc he tɨyiên ma.” ");
INSERT INTO ptp_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Mêgem Yesu nêl vô he ên nêbê, “Xam gwêbaga, xam nêm vông vinên ma. Xam nɨlôm gên nipaên. Om a ob dô hɨxôn xam dɨ i mɨloc na lê lêc xam vông i vinê? Dɨ a ob kɨlê vɨyin wê xam vông ge dɨ i mɨloc na lê? Om kô num tyo mɨ lamê.” ");
INSERT INTO ptp_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Mêd nu tige gên kɨdi mɨ lam lêc vɨmwo nipaên tige hôm i dɨ nêx i la hi i sea lec kɨbun. Mêgem Yesu lec ni vô vɨmwo nipaên tige mɨ tii i la vêl dɨ vông nipwo tyo vô nivɨha lec dɨ vông i lax vô ma. ");
INSERT INTO ptp_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Om xomxo tigee vɨhati yê dɨ yetac mabu ên xêkɨzêc levac wê Anutu vông ge. Xomxo yetac mabu ên môp wê Yesu vông ge, dêc Yesu nêl vô nue ngɨvihi ên nêbê, ");
INSERT INTO ptp_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Xam vyac vô nɨnyam vô kɨyang wê a ob nêl ga bê xomxo obêc vông Xomxo Nu la vac tɨbii vɨgê.” ");
INSERT INTO ptp_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Lêc nue ngɨvihi lungên kɨyang tyo kehe, ên kehe yêp xôpacên om he vyac xovôên ma. Lêc he xona ên nêb ob kɨnêg kɨyang tyo kehe vô Yesu lêm. ");
INSERT INTO ptp_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Yesu nue ngɨvihi ngaênma ên nêb letya ob tu he nên levac? ");
INSERT INTO ptp_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Lêc Yesu xovô he nɨlô wê he nêl ge om la kô nipwo ti mɨ lam lax i le pɨkeb i, ");
INSERT INTO ptp_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","dɨ nêl vô he ên nêbê, “Xomxo ti obêc hôm nipwo bêga lec ên wê vông i vin a lêg ge od ge tɨyi xocbê hôm a lec ge. Dɨ xomxo ti obêc hôm a lec ge od ge tɨyi xocbê hôm xomxo ti wê vông a lam ge lec hɨxôn. Ên xomxo wê dô nipwo vac xam mahɨgun ge, ge wê ob tu xam nêm levac.” ");
INSERT INTO ptp_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Mêd Jon nêl vô Yesu ên nêbê, “Xolac kehe, xe xê xomxo ti tii vɨmwo nipaên vêl ên xomxo lec ông lêm, om xe vɨbu i nêb i vôngên tibêge i ma, ên o mi dô hɨxôn xe mɨ tɨmu vô ông lêm.” ");
INSERT INTO ptp_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Lêc Yesu nêl vô i ên nêbê, “Xam o lêc vɨbu i lêm. Ên xomxo wê o vông vevac vô xam lêm ge, ge xam nêm wê ob ngɨdu xam xôn ge.” ");
INSERT INTO ptp_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Buc vô kwabo lec wê Yesu ob lax mɨ la lag puunê ge, mêd Yesu nêb ob la Jelusalem, ");
INSERT INTO ptp_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","om vông xomxo ya le mug la. Mêd he mɨla vac tɨbii Samelia ben, ên he nêb he ob la yê vɨgwe ti wê Yesu ob la dô vac ge, ");
INSERT INTO ptp_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","lêc tɨbii vɨyang tige xovô nêbê Yesu ge xomxo Yuda ti wê nêb ob la Jelusalem ge, om he vɨbu nêbê Yesu loc vacên he ben i ma. ");
INSERT INTO ptp_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Mêd nue ngɨvihi Jems yuu Jon yê môp wê he vông ge om nêl vô Yesu ên nêbê, “Apumtau, ông nêb xii nêl dɨ ngwax i lam gê kɨsii ganê ên ya tɨbii tigae i ma vêl, me?” ");
INSERT INTO ptp_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Mêlêc Yesu pɨlepac i dɨ kunac yuu ên kɨyang wê yuu nêl ge. ");
INSERT INTO ptp_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Pyap dêc he la vɨgwe bangwe. ");
INSERT INTO ptp_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","He mɨla vô môp lê, lêc xomxo ti val nêl vô Yesu ên nêbê, “Vɨgwe wê ông ob la vac ge, a ob loc hɨxôn ông.” ");
INSERT INTO ptp_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Lêc Yesu nêl vô i ên nêbê, “Le i lêc nêl decdec bê ông ob lam hɨxôn a lêm. Ên lɨlii mi yêp vac yen, dɨ menac vông lɨwihi lec xax mɨ yêp lec, lêc a, Xomxo Nu, a bog wê a ob xêp vac ge ti yêpên ma.” ");
INSERT INTO ptp_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Yesu nêl vô xomxo ngwe ên nêbê, “Lam hɨxôn a.” Lêc xomxo tige nêl ên nêbê, “Xomxo levac, a ob loc hɨxôn ông lê, lêc ông vông a lax dô dɨ yev mag vêl lê.” ");
INSERT INTO ptp_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Lêc Yesu luu i vya dɨ nêl ên nêbê, “Xomxo yibên i yev yibên, dɨ ông loc nêl Anutu ben yuu môp kɨtong vô xomxo.” ");
INSERT INTO ptp_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Xomxo ngwe nêl vô Yesu ên nêbê, “Xomxo levac, a ob loc hɨxôn ông lê, lêc ông vông a lax bog mɨ lax nêl kɨtong vô lige lê.” ");
INSERT INTO ptp_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Lêc Yesu nêl vô i ên nêbê, “Xomxo ti obêc nêb i obêc vông Anutu yuac ge od i o lêc yê manôn i loc nɨnya nɨnya lêm, ên ge od o tɨyi wê ob tu Anutu nu mɨ vông i yuac ge lêm.” ");
INSERT INTO ptp_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Nang dêc Yesu vɨnoo xomxo kehe yon dɨ vɨgê yuu (70) hɨxôn mɨ vông he yuu yuu la vac vɨgwe titi, ên nêb he i mug mɨ loc vac vɨgwe vɨhati wê Yesu obêc mɨla vac ge. ");
INSERT INTO ptp_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Mêd nêl vô he ên nêbê, “Yaên wê dô vac yuac ge vô nôn tɨbeac pyap lê, lêc xomxo ti wê ob kô nôn tyo gee yuutyabed, om xam kɨtaa vô yuac tyo kehe bê i vông xomxo i loc vông yuac ên kɨtuc ixe nôn. ");
INSERT INTO ptp_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","“Om xam locê. Lêc xam xovô bê a ob vông xam loc xocbê bwoc sipsip nue wê la vac noo vɨmen mahɨgun ge. ");
INSERT INTO ptp_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Om xam o lêc kô mone yuu vɨxec dɨ su hɨxôn lêm, dɨ xam o lêc keac tôv vô xomxo ti vac môp lêm. ");
INSERT INTO ptp_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Xam obêc la vac xumac ti ge od xam nêl kɨyang tax bêga bê, ‘Kɨyang malehe i lam lec xomxo wê dô vac xumac tiga.’ ");
INSERT INTO ptp_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Mêd xomxo kɨyang malehe obêc dô vac xumac tige ge od kɨyang malehe wê xam kɨtaa lec he ge ob yêp lec he. Lêc obêc ma ge od kɨyang malehe obêc lôm vô xacxam va tii vac nang. ");
INSERT INTO ptp_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Mêd xumac wê xam obêc dô vac ge, xam dô vac xumac tige tibed, dɨ le i lêc dô tul tul vac xumac tɨbeac lêm. Nge, xam dô tige mɨ wa dɨ num wê xomxo ob vông vô xam ge, ên xomxo wê ob vông yuac ge obêc kô nôn lec yuac wê he vông ge. ");
INSERT INTO ptp_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","“Om xam obêc la vac vɨgwe ti lêc xomxo hôm xam lec ge od xam wa yaên wê he vông vô xam ge, ");
INSERT INTO ptp_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","dɨ xam vông he vɨyang tige wê yidac vông ge i vô nivɨha lec, dɨ xam nêl vô he bêga bê, ‘Anutu nu kɨsiinê val pyap vô xam.’ ");
INSERT INTO ptp_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","“Lêc xam obêc mɨla vac vɨgwe ti lêc xomxo o hôm xam lec lêm ge od xam lôc mɨ loc le vac môp, dɨ nêl vô he bêga bê, ");
INSERT INTO ptp_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Xam bom vɨjuva wê pɨtii lec xe vɨxam ge, xe ob lɨloo i lôc mɨ loc yêp vô xam. Mêlêc xam xovô bêga bê Anutu nu kɨsiinê val kwabo pyap.’ Xam nêl bêge vô he. ");
INSERT INTO ptp_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Om a ob nêl vô xam bê obêc buc tɨmuên wê Anutu ob yaxên xomxo ge, od xomxo vɨyang tige obêc kô vɨyin levac luu vɨyin wê tɨbii Sodom ob kô ge vêl.” ");
INSERT INTO ptp_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Yesu nêl ên nêbê, “Xam tɨbii Kolasin, xam xona nêm ên vɨyin wê xam obêc kô ge. Dɨ xam tɨbii Betsaida, xam êno xona nêm. Ên do levac wê a vông vac xam bom ge, xomxo ti obêc vông bêge vac tɨbii Taia yuu Saidon ben ilage ge od tɨbii Taia yuu Saidon obêc pɨlepac he dɨ lipac vɨwev lec he dɨ dô hɨxôn nɨlô vɨyin ên wê he xovô nên nipaên ge. ");
INSERT INTO ptp_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Lêc xam o pɨlepac xam lêm, om buc tɨmuên wê Anutu obêc yaxên xomxo ge, od xam obêc kô myavɨwen nipaên i luu wê tɨbii Taia yuu Saidon ob kô ge vêl. ");
INSERT INTO ptp_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Dɨ xam tɨbii Kapaneam, xam xo ên xam nêb xam ob kô lêm levac mɨ la dô vac Anutu ben lag puunê? Ma vêl, xam ob la vac vɨgwe nipaên.” ");
INSERT INTO ptp_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Mêgem Yesu nêl vô nue ngɨvihi ên nêbê, “Xomxo ti obêc ngô xam vyam ge od tɨyi xocbê ngô a vyag. Lêc xomxo obêc vô nɨnya kɨtu vô xam vyam ge od tɨyi xocbê he vô nɨnya kɨtu vô a vyag, dɨ xomxo wê vô nɨnya kɨtu vô a vyag ge tɨyi xocbê he vô nɨnya kɨtu vô xomxo ti wê vông a lam ge vya hɨxôn.” ");
INSERT INTO ptp_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Xomxo kehe yon dɨ vɨgê yuu wê Yesu vông he la yuac gee vena hɨxôn xêyaa nivɨha dɨ nêl vô Yesu ên nêbê, “Apumtau, xe nêl ông lêm ge od vɨmwo nipaên vô nɨnya lehe vô mɨ la vac xe vyam kwa ngɨbi.” ");
INSERT INTO ptp_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Lêc Yesu nêl vô he ên nêbê, “A xê Seten tô gê kɨsii ganê mɨ lam xocbê deac hɨxelac ge. ");
INSERT INTO ptp_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Om xam ngô lê. A vông xêkɨzêc vô xam pyap, om xam tɨyi wê xam obêc kê myel yuu kɨpyêc, dɨ xam obêc pwoo xêkɨzêc wê Seten vông ge i pec, dɨ susu ti o tɨyi wê ob vông xam vô nipaên ge lêm. ");
INSERT INTO ptp_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Vɨxôhɨlôg, lêc xam o lêc pɨmil xam bê vɨmwo nipaên la vac xam kwa ngɨbi lêm. Nge, xam pɨmil Anutu ên wê kɨvuu xam lêm yêp lag puunê ge.” ");
INSERT INTO ptp_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Vô buc tige Myakɨlôhô Ngɨbua vông Yesu xêyaa vô nivɨha dɨ i kɨtaa vô ma Anutu bêga ên nêbê, “Mag Apumtau, ông lag yuu kɨbun kehe ông, om a hi vɨxag pec ên ông, ên ông o vông kɨyang tige vô xomxo wê pɨyôp levac yuu xovôên nivɨha ge lêm. Nge, ông hɨlung vô xomxo wê lê nipwo ge. Mag, ông vông ya xovôên wê ôcông va vông ge.” ");
INSERT INTO ptp_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Pyap dêc Yesu nêl ên nêbê, “Mag vông susu ge vɨhati vô a. Mêlêc xomxo ti o xovô nu a lêm. Nge, Mag vaci xovô. Dɨ xomxo ti o xovô Mag lêm. Nge, nu aca va wê a xovô, dɨ xomxo wê a nêb a ob hɨlung Mag vô he ge, he ob xovô Mag.” ");
INSERT INTO ptp_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Mêd Yesu pɨlepac i vô nue ngɨvihi dɨ nêl vô heche va ên nêbê, “Xam xêmyaa i vô nivɨha ên wê xam wê môp wê a vông ge. ");
INSERT INTO ptp_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Ên a ob nêl vô xam bê plopete yuu king wê dô ilage, he tɨbeac nêb ob yê i tɨyi xocbê xam wê ge lê, lêc he yêên ma. Dɨ he tɨbeac nêb ob ngô kɨyang xocbê wê xam ngô ge lê, lêc he ngôên ma.” ");
INSERT INTO ptp_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Buc ti lêc xomxo wê xovô Moses xolac ge ti kɨdi lec dɨ nêl kɨyang vô Yesu ên nêb ob yaxên i, om nêl bêga ên nêbê, “Xolac kehe, a obêc vông bêna êdêc dô magvɨha luta lêc luta?” ");
INSERT INTO ptp_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Lêc Yesu nêl lax vô i ên nêbê, “Kɨyang wê yêp vac Moses xolac ge, ông kɨtong lêc nêbê va?” ");
INSERT INTO ptp_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Mêgem xomxo tyo nêl ên nêbê, “Xolac nêl bêga ên nêbê, ‘Ông xêmyaa i vin lec ông Apumtau Anutu dɨ ông vông nɨlôm yuu kɨnum dɨ xêkɨzêc yuu pɨyôp i loc dɨluhu vô Anutu, dɨ ông xêmyaa i vin lec xomxo baba i tɨyi xocbê ông xêmyaa vin lec ôcông va ge.’” ");
INSERT INTO ptp_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Mêgem Yesu nêl ên nêbê, “Ông nêl ge nivɨha pyap, om ông obêc vông bêge ge od ông obêc dô mamvɨha luta lêc luta.” ");
INSERT INTO ptp_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Lêc xomxo tige nêb ob viac i nivɨha om kɨnêg vô Yesu ên nêbê, “Kɨyang wê nêl ên nêbê il xêdyaa i vin lec xomxo baba ge, ge nêl lec xomxo nae?” ");
INSERT INTO ptp_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Om Yesu nêl kɨyang pɨlepacên ti vô i bêga ên nêbê, “Xomxo ti kɨdi gê Jelusalem ên nêb ob la Jeliko, om la vô môp mɨ la, lêc tɨbii yôdac wê mi vun xomxo susu ge hi i vô nipaên dɨ lêx i nên ngakwi sea dɨ kô i susu vɨhati mɨ la, dêc xomxo tyo la yêp vac môp dɨ vô kwabo lec wê ob yib ge. ");
INSERT INTO ptp_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Lêc vô buc tige xomxo wê mi si daa vô Anutu ge ti mɨla vô môp tige mɨ la yê lê, lêc sea i yêp dɨ luu vêl mɨ la. ");
INSERT INTO ptp_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Nang dêc xomxo Livai wê mi vông yuac vac Anutu xumac ngɨbua ge ti mɨla vô môp tige mɨ la yê lê, lêc sea i yêp dɨ luu vêl mɨ la. ");
INSERT INTO ptp_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","“Mêd tɨbii Samelia ti mɨla vô môp tige om val yê xomxo tyo wê yêp ge, lêc xo vɨgwe pɨsiv ên i, ");
INSERT INTO ptp_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","om la kwabo vô dêc vông malasin wel yuu wain vac xomxo tyo kɨtyax wê tɨbii vevac hi ge, mɨ vɨyum xôn, dêc tung i la lec i bwoc donki mêd kô mɨ la vac xumac wê xomxo kɨsuu dɨ yêp vac ge ti dɨ viac i. ");
INSERT INTO ptp_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Vɨgwe vɨdiiên mêd tɨbii Samelia tige vông mone kehe ti vô xomxo ti wê viac xumac tige dɨ nêl vô i ên nêbê, ‘Ông viac xomxo tiga nivɨha ya mone wê a vông ga, dêc ông obêc vông luu vêl ge od a obêc vena vông vac ông xe wê ông viac xomxo tiga ya ge.’” ");
INSERT INTO ptp_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Yesu nêl bêge dêc kɨnêg vô xomxo xolac kehe tige ên nêbê, “Om ông xo ên ông nêb xomxo yon ge, tina xêyaa vin lec xomxo ti wê tɨbii yôdac hi ge?” ");
INSERT INTO ptp_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Lêc xomxo tyo nêl lax ên nêbê, “Xomxo ti wê xo vɨgwe pɨsiv ên i ge.” Om Yesu nêl vô i ên nêbê, “Om ông lôc, dɨ loc vông môp i tɨyi bêge.” ");
INSERT INTO ptp_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Mêd Yesu he nue ngɨvihi la lêc mɨla vac vɨgwe ti wê vêx ti dô vac lê nêbê Mata. Om Mata kô Yesu mɨ la vac i ben. ");
INSERT INTO ptp_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Lêc Mata li vêx ngwe dô lê nêbê Malia, om Malia la dô hɨxôn Apumtau Yesu mɨ ngô i kɨyang. ");
INSERT INTO ptp_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Lêc Mata vông yuac levaclec yebac mɨ vô vɨlee vɨlee mɨ vông nɨlô vô vɨyin om la nêl vô Yesu ên nêbê, “Apumtau, nii Malia sea a mɨ vông aca tibed vông yuac lec yaên ga. Lêcom mêd ông wê ge nivɨha? Ông nêl ên i lam vông yuac hɨxôn a.” ");
INSERT INTO ptp_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Lêc Apumtau nêl vô i ên nêbê, “Mata, Mata, ông vông nɨlôm la vô susu vɨyang vɨyang ge om vông ông nɨlôm vô vɨyin lec. ");
INSERT INTO ptp_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Mêlêc môp tibed wê ông sea ge. Ge môp nivɨha wê Malia vông ge, om il obêc vô vêl ên i nang lêm.” ");
INSERT INTO ptp_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Buc ti Yesu la kɨtaa vac vɨgwe ti, pyap dêc nue ngɨvihi ti nêl vô i ên nêbê, “Apumtau, xe nêb ông nêl môp kɨtaaên kɨtong vô xe i tɨyi xocbê Jon Lipacên nêl vô nue ge.” ");
INSERT INTO ptp_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Mêgem Yesu nêl vô he ên nêbê, “Xam obêc kɨtaa ge od xam kɨtaa bêga bê, ‘Mag, ông lêm i lam tu ngɨbua. Ông lam tu Apumtau i tɨyi vɨgwe vɨhati. ");
INSERT INTO ptp_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Ông vông yaên vô xe i tɨyi buc vɨhati. ");
INSERT INTO ptp_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Xe nêm myavɨwen wê yêp vô xe ge ông kɨtya vêl, xocbê xe kɨtya nêm nipaên vêl vôma ge. Ông o lêc dɨdii xe mɨ loc vac kɨyang wê ob yaxên xe ge lêm.’” ");
INSERT INTO ptp_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Mêd Yesu nêl vô he ên nêbê, “Xam ti obêc la vô ngɨdêm ti vô vɨvuaên mahɨgun dɨ nêl vô i ên nêbê, ‘Ngɨdêg, a val ga vô ông ên a nêbê ông vông blet yon vô a, ");
INSERT INTO ptp_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","ên a ngɨdêg ngwe val vô vɨgwe bucên tya ga vô a, lêcom yaên wê a ob vông vô i ge ma.’ ");
INSERT INTO ptp_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Lêc ngɨdêm dô vac xumac nɨlô dɨ nêl bêga vô ông ên nêbê, ‘Ga vɨvuaên mahɨgun dɨ a tung xumac lec pyap dɨ xe nuge xêp ga mê, om o tɨyi wê a ob kɨdi lec mɨ vông yaên ti vô ông ge lêm. Mêgem ông lôcê.’ ");
INSERT INTO ptp_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Om a ob nêl vô xam bê ngɨdêm obêc kɨdi lec mɨ lam vông yaên vô ông ge od ob vông vô ông ên wê i ngɨdê ông ge lêm. Nge, obêc vông vô ông ên wê ông kɨtaa i ngɨnong ge. ");
INSERT INTO ptp_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Om a ob nêl vô xam bê xam kɨtaa susu ya vô Anutu ên Anutu i vông vô xam, dɨ xam myag susu êdêc wêvô, dɨ xam kɨtuu vuayen ên Anutu i tax vuayen ên xam. ");
INSERT INTO ptp_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Ên xomxo vɨhati wê kɨtaa vô Anutu ge obêc kô nôn tɨyi wê he kɨtaa ge, dɨ xomxo vɨhati wê myag susu ge obêc yêvô, dɨ xomxo vɨhati wê kɨtuu vuayen ge od Anutu obêc tax vuayen ên he. ");
INSERT INTO ptp_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“Xame, xam nume ti obêc kɨtaa xam nêb ob ya pis ge od xam obêc vông myel vô, me? ");
INSERT INTO ptp_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Me nume ti obêc kɨtaa xam ên nêb xam vông kokɨlêx nulen vô i ge od xam obêc vông kɨpyêc vô, me? Maê. ");
INSERT INTO ptp_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Xam ga xomxo kɨbun nimpaên, lêc xam mi vông susu nivɨhavɨha vô nume, om xam xovô bêga bê il Mag Anutu lag puunê nêb ob vông susu nivɨhavɨha luu vêl vô il om ob vông Myakɨlôhô Ngɨbua vô xomxo wê kɨtaa i ge.” ");
INSERT INTO ptp_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Yesu tii vɨmwo nipaên ti vêl ên xomxo ti. Vɨmwo tyo vông xomxo tige dô yac dɨ keacên ma, om buc wê Yesu tii vɨmwo tyo la vêl ge od xomxo tyo keac, dɨ xomxo wê yê gee yetac mabu. ");
INSERT INTO ptp_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Lêc xomxo ya nêl ên nêbê, “Bielsebul wê tu vɨmwo nipaên nên levac ge vông xêkɨzêc vô Yesu, om Yesu tii vɨmwo nipaên vêl ya xêkɨzêc wê Bielsebul vông ge.” ");
INSERT INTO ptp_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Dɨ xomxo ya nêb ob yaxên Yesu, om nêl vô i ên nêbê, “Xe nêb ông vông do levac ti mɨ xe xê ên i nêl kɨtong bê ông kô xêkɨzêc vô Anutu lag puunê.” ");
INSERT INTO ptp_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Lêc Yesu xovô kɨyang wê yêp vac he nɨlô ge om nêl vô he ên nêbê, “Xomxo vɨyang ti obêc hɨbuma sea mɨ hima ge od ob dô nivɨha nang lêm. Me xomxo xumac ti obêc hɨbuma sea mɨ hima ge od obêc vông he vô nipaên. ");
INSERT INTO ptp_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Bêge mêgem Seten he lie obêc hɨbuma sea mɨ hima ge od xêkɨzêc wê he vông ge ob yêp nivɨha tibêna? Ge he ob dô nipaên. A nêl bêge ên wê xam nêl ên xam nêbê a tii vɨmwo nipaên la vêl ên xomxo ya xêkɨzêc wê Bielsebul vông ge. ");
INSERT INTO ptp_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Lêc a ob kɨnêg vô xam bê a obêc tii vɨmwo nipaên vêl ya xêkɨzêc wê Bielsebul vông ge od letya wê vông xêkɨzêc vô lime lêc he tii vɨmwo nipaên vêl ya ge? Ge lime vaci ob yaxên kɨyang wê xam nêl ge lê. ");
INSERT INTO ptp_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Lêc Anutu vaci obêc vông xêkɨzêc vô a dɨ a tii vɨmwo nipaên la vêl ge od xam xovô bêga bê Anutu lam tu levac vac xam mahɨgun pyap. ");
INSERT INTO ptp_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Xomxo xêkɨzêc ti obêc hôm susu vevac vac vɨgê dɨ dô bin i xumac ge od susu wê i vông ge ob dô nivɨha. ");
INSERT INTO ptp_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Lêc xomxo ngwe wê xêkɨzêc luu vêl ge obêc val vông vevac vô i dɨ ngɨnoo vêl ge od ob vô susu vevac wê xomxo tige xo nêb ob ngɨdu i xôn ge vêl, dêc kô susu wê xomxo tige vông ge vɨhati mɨ la tɨtang vaxvax vô lie ya. ");
INSERT INTO ptp_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Om a ob nêl bêga bê xomxo ti obêc dô hɨxôn a mɨ ngɨdu a xôn lêm ge od ge tɨyi xocbê vông vevac vô a. Dɨ xomxo wê o vɨlu vô xomxo hɨxôn a lêm ge od ge tɨyi xocbê tii he moo sea ge. ");
INSERT INTO ptp_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Vɨmwo nipaên ti obêc lam la vêl ên xomxo ti ge od ob la vɨlee vac vɨgwe myadongên mɨ la myag vɨgwe ti wê ob la dô seac vêl vac ge. Lêc yêvôên vɨgwe ti obêc ma ge od ob nêl bêga bê, ‘A ob lax mɨ la dô vac bog wê a sea dɨ lam ge i tii vac nang.’ ");
INSERT INTO ptp_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Om vɨmwo tige obêc lax mɨ la vô xomxo ti wê i dô vac ilage mɨ lax yê wê pɨtyep mɨ viac nivɨha ge, ");
INSERT INTO ptp_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","od obêc la kô vɨmwo nipaên wê nên nipaên luu i vêl ge vɨgê vɨlu dɨ sec yuu, lêc he xôn lax dô vac xomxo tige, dɨ vông i vô nipaên levac luu vɨwen tax ge vêl.” ");
INSERT INTO ptp_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Yesu nêl kɨyang tige vô xomxo tɨbeac, lêc vêx ti tyuc vya levac vac he mahɨgun ên nêbê, “Ông tam ti wê kô ông mɨ vông lul vô ông ge, i dô hɨxôn xêyaa nivɨha.” ");
INSERT INTO ptp_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Lêc Yesu nêl ên nêbê, “Bêge mêlêc a nêl bê xomxo wê ngô Anutu kɨyang mɨ viac ge wê ob dô hɨxôn xêyaa nivɨha.” ");
INSERT INTO ptp_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Xomxo tɨbeac lam kɨtucma mɨ dô, mêgem Yesu nêl vô he ên nêbê, “Xomxo gwêbaga, xomxo nipaên nôn. He nêb he ob yê do levac lê, lêc a ob nêl bê he ob yê do tɨbeac lêm. Nge, do tibed wê he ob yê ge, tɨyi xocbê wê Jona vông ilage. ");
INSERT INTO ptp_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Ên môp wê Jona la dô vac lɨlii gwec nɨlô tɨyi buc yon ge, ge Anutu hɨlung vô tɨbii Niniva tɨyi xocbê do levac ge. Bêge mêgem a, Xomxo Nu, a obêc tu do levac bêge vô xomxo gwêbaga êno. ");
INSERT INTO ptp_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","“Om obêc buc tɨmuên wê Anutu obêc tɨtô xomxo ge, od vêx levac wê tu tɨbii Siba nên kwin vac buc ilage ge obêc kɨdi lec hɨxôn xam wê xam dô gwêbaga dɨ nêl xam nêm nipaên kɨtong. Ên vêx tige kɨdi vac kɨbun myahɨpu dɨ lam ên nêb ob lam ngô kɨyang wê King Solomon nêl hɨxôn pɨyôp nivɨha ge. Dɨ gwêbaga a wê a luu Solomon vêl ge a lam dô hɨxôn xam lê, lêc xam o ngô a vyag lêm. ");
INSERT INTO ptp_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Om obêc buc tɨmuên wê Anutu obêc tɨtô xomxo ge, od tɨbii Niniva êno obêc kɨdi lec hɨxôn xam wê xam dô gwêbaga dɨ nêl xam nêm nipaên, ên ilage tɨbii Niniva ngô kɨyang wê Jona nêl vô he ge dɨ pɨlepac he, dɨ gwêbaga a wê a luu Jona vêl ge a lam dô hɨxôn xam, lêc xam o pɨlepac xam lêm. ");
INSERT INTO ptp_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Xomxo ti obêc byêx ngwax vac lam ge od ob vun vac pêt ngɨbi me lax dêg lec xôn lêm. Nge, ob lax i le lec tevol kɨsii ên xomxo wê ob lam vac xumac nɨlô ge i lam yê xêseac. ");
INSERT INTO ptp_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Xam mamnôn tɨyi xocbê lam wê linac lec nimnɨvi ge, om mamnôn obêc dô nivɨha ge od obêc vông nimnɨvi vɨhati dô vac xêseac, lêc xam obêc vông mamnôn vô nipaên ge od nimnɨvi vɨhati obêc mapɨtoc. ");
INSERT INTO ptp_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Om xam viac xam êdêc xêseac wê dô vac xam ge i o lêc vô mapɨtoc lêm. ");
INSERT INTO ptp_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Ên nimnɨvi vɨhati obêc dô vac xêseac dɨ mapɨtoc ma ge od nimnɨvi obêc xêseac nivɨha xocbê lam xêseac linac lec ông ge.” ");
INSERT INTO ptp_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Yesu nêl kɨyang tige pyap dêc Palisi ti val nêl vô Yesu nêb i loc ya hɨxôn i, om Yesu la vac Palisi tyo ben mɨ la dô hɨxôn i mɨ ya. ");
INSERT INTO ptp_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Lêc Palisi tyo yê wê Yesu dɨya ge lê, lêc o lipac vɨgê tax tɨyi xocbê môp wê he Palisi mi vông ge lêm, om yetac mabu. ");
INSERT INTO ptp_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Lêc Yesu nêl vô i ên nêbê, “Xam Palisi ge, xam mi lipac nimnɨvi pɨleva tɨyi xocbê xam lipac kap yuu pɨle nɨmi ge, dom xam nɨlôm ge, môp yôdac yuu nipaên pup lec. ");
INSERT INTO ptp_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Xam tɨbii pɨyôp maên. Anutu ti wê tung il nidnɨvi ge o tung il nɨlôd hɨxôn lêmê? ");
INSERT INTO ptp_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Om a ob nêl vô xam bê xam vông susu wê dô vac pɨle yuu kap nɨlô ge vô xomxo wê nên susu maên ge ên i loc ngɨdu he xôn. Xam obêc vông bêge ge od xam nêm môp vɨhati obêc vô paha lec. ");
INSERT INTO ptp_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Om xam Palisi ge, xam xona nêm ên vɨyin wê ob val vô xam ge. Ên xam nêb xam ob tɨmu vô Moses xolac vɨhati, om xam obêc tulec susu xocbê lehac yuu ngec nipwopwo ge od xam mi tung kɨdu vɨgê yuu lêc mi vông kɨdu ti la tu daa vô Anutu. Xam mi vông bêge lê, lêc xam sea môp bôbac yuu môp xêyaa vin lecên Anutu. Om a ob nêl bê xam o lêc vông môp ngwe vô nivɨha dɨ sea ngwe lêm. Nge, xam vông yuu xôn i vô nivɨha. ");
INSERT INTO ptp_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Xam Palisi, xam xona nêm ên vɨyin wê obêc tulec xam ge. Ên buc wê xam la vac xumac lɨlo ge, od xam yong xam ên xam nêb xam ob dô lec sia nivɨha vô xomxo manôn, dɨ buc wê xam la vɨlee lec wetôv ge od xam nêb xomxo vɨhati i pɨmil xam ya vya nivɨha. ");
INSERT INTO ptp_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","“Mêgem xam xona nêm ên vɨyin wê obêc tulec xam ge. Ên xam nɨlôm tɨyi xocbê lôva wê le vac kɨbun nɨlô mɨ xomxo len yêp vac ge, mêlêc xomxo tɨbeac lungên dɨ xoc vô kɨsii mɨ la om vông he vô nipaên.” ");
INSERT INTO ptp_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Mêgem xomxo wê xovô Moses xolac ge ti nêl vô Yesu ên nêbê, “Xolac kehe, kɨyang wê ông nêl ge, ge ông nêl nipaên lec xe hɨxôn.” ");
INSERT INTO ptp_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Lêcom Yesu nêl vô he ên nêbê, “Xam wê xam xovô Moses xolac ge, xam xona nêm ên vɨyin wê obêc tulec xam ge. Ên xam nêl kɨyang tɨbeac vô xomxo ên xam nêb he i tɨmu vô, om xam lii vɨyin levac lec he, lêc xam vɨgêm o kɨlê vɨyin tige hɨxôn he lu ya lêm. ");
INSERT INTO ptp_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","“Om xam xona nêm ên vɨyin wê obêc tulec xam ge. Ên mame bume tɨvame, he hi plopete yib, lêc gwêbaga xam dɨvunac vô lôva wê plopete yêp vac ge. ");
INSERT INTO ptp_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Om môp tibêge nêl xam kɨtong ên nêbê xam xêmyaa vô nivɨha ên môp wê bume vông ilage, ên bume hi plopete yib, lêc gwêbaga xam vunac vô lôva wê plopete yêp vac ge. ");
INSERT INTO ptp_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","“Mêgem Anutu wê xovôên kehe ge nêl bêga ên nêbê, ‘A ob vông plopete yuu sinale i loc vô he lê, lêc he obêc vông vɨyin vô he dêc hi he ya yib.’ ");
INSERT INTO ptp_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Om xomxo wê dô gwêbaga, he ob kô myavɨwen nipaên lec wê he hi plopete yib ge. Ge nêl lec plopete vɨhati yang, he wê dô vô buc taxlee ilage wê Anutu tung lag yuu kɨbun ge dɨ i val tyip lec buc gwêbaga hɨxôn. ");
INSERT INTO ptp_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Kɨyang tige lec Ebel wê taxlee ge dɨ i val tyip lec plopete Sekalaia ti wê bume hi i yib vac xumac ngɨbua yuu alta mahɨgun ge. Vɨxôhɨlôg, a ob nêl hɨxôn nôn vô xam bê xomxo gwêbaga ob kô myavɨwen nipaên lec môp gee vɨhati. ");
INSERT INTO ptp_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Om xam wê xam xovô Moses xolac ge, xam xona nêm ên vɨyin wê xam ob kô ge. Ên môp wê xomxo ob ngô xolac kehe ge, xam le vac xôn, ên xacxam va lungên xolac kehe om xam le vac môp xôn ên xomxo wê nêb ob ngô mɨ xovô ge.” ");
INSERT INTO ptp_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Yesu nêl pyap dêc sea Palisi tyo ben dɨ loc mɨ la, dêc he wê xovô Moses xolac gee hɨxôn he Palisi yê Yesu nipaên om he le kɨnêg kɨyang vɨyang vɨyang vô i ");
INSERT INTO ptp_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","ên nêb ob yaxên bêc obêc nêl kɨyang ti so ge od ob vông i loc vac kot. ");
INSERT INTO ptp_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Vô buc tige xomxo tɨbeac hɨwocên la kɨtucma vô Yesu, om he la pup lec vɨgwe xocbê ob dô lecma vɨxa hɨxôn, dêc Yesu nêl vô nue ngɨvihi tax ên nêbê, “Xam viac xam ên môp nipaên wê Palisi mi vông ge, ên he mi vɨyum kɨyang nipaên vac kɨyang nivɨha, om môp tige tɨyi xocbê yis wê ob vông blet vuac mɨ vô levac ge. ");
INSERT INTO ptp_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Ên kɨyang vɨhati wê yêp xôpacên ge obêc lam le seac, dɨ kɨyang vɨhati wê yêp vac xomxo nɨlô ge obêc hɨvelac lec dɨ xomxo vɨhati xovô. ");
INSERT INTO ptp_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Om kɨyang vɨhati wê xam nêl vô bucên ge od xomxo obêc ngô vô vɨdiiên, dɨ kɨyang vɨhati wê xam kɨmuna vôma vac xumac lôma ge od obêc nêl i vô levac lec wetôv. ");
INSERT INTO ptp_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Xam lige, a ob nêl vô xam bê xam o lêc xona ên xomxo wê ob hi xam nimnɨvi yib ge lêm, ên he o tɨyi wê obêc vông vɨyin yaya vô xam hɨxôn tɨmuên ge lêm. ");
INSERT INTO ptp_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Lêc a ob nêl xomxo ti wê xam ob xona ên ge kɨtong vô xam bê Anutu tibed wê obêc hi xomxo yib, dêc obêc tɨmuên ge xêkɨzêc wê i vông ob nêx xomxo la vac vɨgwe nipaên. Om a nêl vô xam bê xam xona ên i tibed. ");
INSERT INTO ptp_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Xam xovô ên xam nêbê xomxo ti obêc kɨsuu menac nipwo vɨgê vɨlu ge od obêc kɨsuu ya mone nipwo tɨyi xocbê mone hi yuubed ge. Bêge mêlêc Anutu o lungên menac nipwopwo gee lêm. Nge, xovô gee vɨhati. ");
INSERT INTO ptp_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Dɨ Anutu o lungên xam êno lêm. Nge, kɨtong xam bamzub lihi vɨhati pyap. Om xam xonaên i ma, ên Anutu xêyaa vin lec xam ngɨnoo menac vɨhati vêl. ");
INSERT INTO ptp_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“A ob nêl vô xam bê xomxo ti obêc nêl a kɨtong vô xomxo ge od a, Xomxo Nu, a ob nêl i kɨtong vô Anutu nue angela. ");
INSERT INTO ptp_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Lêc xomxo ti obêc yax a vun vô xomxo manôn ge od a obêc yax i vun vô Anutu nue angela manôn êno bêge. ");
INSERT INTO ptp_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Xomxo ti obêc so vya vô a, Xomxo Nu ge od tɨyi wê Anutu obêc kɨtya nipaên tige vêl ge. Lêc xomxo ti obêc so vya vô Myakɨlôhô Ngɨbua ge od o tɨyi wê Anutu ob kɨtya i nên nipaên tige vêl ge lêm. ");
INSERT INTO ptp_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Mêd buc wê xomxo obêc kô xam mɨ la vô xomxo levac vac xumac lɨlo me gavman ti me xomxo levac ti ge od xam o lêc xona dɨ xo bêga bê ‘Xe ob luu he vya ya kɨyang tina, dɨ xe ob nêl kɨyang bêna vô he?’ Le i lêc xo kɨyang tibêge lêm. ");
INSERT INTO ptp_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Ên obêc hɨyôv manôn myabo tya ge od Myakɨlôhô Ngɨbua ob hɨlung kɨyang wê xam ob nêl ge vô xam.” ");
INSERT INTO ptp_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Xomxo ti vac xomxo tɨbeac mahɨgun nêl vô Yesu ên nêbê, “Xolac kehe, ông nêl vô a lig ngwe ge bê i vông susu wê mag vɨgê ge vɨwen vô a.” ");
INSERT INTO ptp_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Lêc Yesu nêl vô i ên nêbê, “Letya vɨnoo a nêb a tɨtô xam nêm kɨyang mɨ vông byed vô xam susu? Ge yêp vô xacxam va.” ");
INSERT INTO ptp_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Mêgem Yesu nêl vô he vɨhati ên nêbê, “Xam xona nêm ên mamdoên vô susu vɨyang vɨyang ge, ên susu tɨbeac wê xomxo vông ge o tɨyi wê ob vông he dô mavɨha ge lêm.” ");
INSERT INTO ptp_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Mêgem Yesu nêl kɨyang pɨlepacên ti vô he bêga ên nêbê, “Xomxo wê susu levac ge ti dô, lêc yuac wê i vông ge vô nôn tɨbeac, ");
INSERT INTO ptp_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","om xo bêga ên nêbê, ‘A ob vông bêna? Ên xumac wê a ob kɨtuc susu vɨhati nôn vac ge tɨyiên ma.’ ");
INSERT INTO ptp_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Om nêl bêga ên nêbê, ‘A ob vông môp bêga bê a ob dii xumac wê a kɨtuc susu nôn vac ge mɨ lox xumac levac levac pɨleva ên kɨtuc yaên nôn yuu susu vɨhati wê a vông ge i loc dô vac. ");
INSERT INTO ptp_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Pyap dêc a ob xo bêga bê a kɨtuc susu tɨbeac dɨ obêc dô tɨyi klismas tɨbeac om a ob dô seac vêl mɨ xa dɨ num hɨxôn xêgyaa nivɨha.’ ");
INSERT INTO ptp_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Mêlêc Anutu nêl vô i ên nêbê, ‘Ông xomxo pɨyôp maên. Bucên hig ge ông obêc wib, om susu tɨbeac wê ông kɨtuc ge obêc tu letya xe?’” ");
INSERT INTO ptp_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Mêgem Yesu nêl ên nêbê, “Kɨyang tige tɨyi xocbê xomxo ti kɨtuc susu tɨbeac tu ici va xe lêc o xovô Anutu lêm om Anutu yê i tɨyi xocbê xomxo pɨleva ti.” ");
INSERT INTO ptp_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Yesu nêl vô nue ngɨvihi ên nêbê, “Bêge mêgem a ob nêl vô xam bê xam o lêc vông nɨlôm i vô vɨyin lec yaên wê xam ob wa ge yuu ngakwi wê xam ob vɨnyum ge lêm, ");
INSERT INTO ptp_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","ên môp wê il ob dô madvɨha ya ge luu susu yaên vêl, dɨ il nidnɨvi luu ngakwi vêl. ");
INSERT INTO ptp_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","“Om xam xovô menac lê. Ên menac o xin vê vac yuac lêm, dɨ he o kô yaên nôn vac yuac lêm, dɨ he nên xumac wê ob kɨtuc yaên vac ge ti o le lêm. Mêlêc Anutu vet he tɨyi buc vɨhati. Dɨ Anutu xêyaa vin lec xomxo ngɨnoo menac gee vêl om ob viac xam nivɨha. ");
INSERT INTO ptp_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Xame, xam ti obêc xo kɨyang tɨbeac nêb xam ob dô mamvɨha ge od tɨyi wê xam ob tul lec buc wê ob dô mavɨha ge i loc dia, me? ");
INSERT INTO ptp_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Ma vêl, xam o tɨyi wê xam ob vông bêge ge lêm. Om bêna lêc xam xo kɨyang tɨbeac lec susu ninɨvi xen? ");
INSERT INTO ptp_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Dɨ xam xovô nita wê vuac mavɨya ge. Mavɨya o duu nivɨmihi lêm, dɨ he o vông yuac ti lec ngakwi lêm, lêc a ob nêl vô xam bê vunac vunac wê he vông ge luu vunac vunac nivɨha wê King Solomon vông ge vêl. ");
INSERT INTO ptp_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Nita wê vuac mavɨya mɨ le vac yuac gwêba dɨ obêc tɨtige pɨsaên vêl ge od ob nêx i la vac ngwax, lêc Anutu vunac vô he nivɨha. Mêgem xam xovô bêga bê Anutu ob viac xam nivɨha luu nita mavɨya vêl. Lêc vông vinên wê xam vông ge o xêkɨzêc lêm. ");
INSERT INTO ptp_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Om xam o lêc vông nɨlôm i loc vô susu yaên yuu numên lêm, me xam o lêc vông nɨlôm i vô vɨyin lec lêm. ");
INSERT INTO ptp_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Ên tɨbii madɨluhu ge wê vông nɨlô la vô susu ninɨvi xen ge, dom Mag Anutu xovô susu wê ma vô xam ge. ");
INSERT INTO ptp_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Mêgem xam vông nɨlôm i loc vô Anutu xolac yuu ben tibed lê, ge od Anutu obêc vông susu bêge vô xam hɨxôn. ");
INSERT INTO ptp_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Xam kɨdu nipwo tya ga, xam xona ên i ma. Ên Mag Anutu xovô pyap nêb xam ob tu xomxo levac hɨxôn i vac i ben lag puunê. ");
INSERT INTO ptp_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Om xam vông susu wê xam vông ge mɨ tɨbii i kɨsuu, dêc xam vông mone vô tɨbii wê nên susu maên ge ên i vô nivɨha vô he. Dêc xam kɨtuc susu nivɨhavɨha i loc yêp lag puunê i tɨyi xocbê mone yêp vac kɨlong nivɨha ge. Ên susu wê yêp lag puunê ge, tɨbii yôdac ti obêc vun lêm, dɨ gwaakivac yuu susu nipɨpaa ti obêc vông i vô nipaên lêm. ");
INSERT INTO ptp_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Ên vɨgwe wê susu nivɨhavɨha wê xam vông ge la dô vac ge, xam ob vông nɨlôm la vô vɨgwe tige. ");
INSERT INTO ptp_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Xam viac xam dêc xam vêx let lec dɨ byêx ngwax vac lam, ");
INSERT INTO ptp_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","dɨ xam dô i tɨyi xocbê tɨbii yuac wê dô bin xomxo levac wê ob vena vac vɨzid ge, ên xomxo tyo obêc vena hi vɨgê lec vuayen ge od he i tax xumac lutibed. ");
INSERT INTO ptp_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Om xomxo levac tyo obêc vena yê wê nue yuac dô mavɨha dɨ yêpên ma ge od ob hi vɨxa pec ên he. A ob nêl hɨxôn nôn vô xam bê xomxo levac tyo obêc vêx nivɨmihi tɨyi wê nue yuac mi vɨnyum ge dɨ vông he dô kɨdu ti dêc ici va obêc tɨtang yaên vô he. ");
INSERT INTO ptp_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Dɨ xomxo levac tyo obêc vena vô vɨvuaên mahɨgun me obêc vô kwabo lec wê kokɨlêx ob vô vya ge, lêc nue yuac obêc dô dɨ yêpên ma ge od ob hi vɨxa ên he. ");
INSERT INTO ptp_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","“Xam xovô lê. Xomxo ti wê i xumac ge obêc xovô buc wê tɨbii yôdac ob val lec ge od ob dô mavɨha mɨ bin i xumac êdêc tɨbii i o lêc loc vac i ben nɨlô mɨ vun i susu lêm. ");
INSERT INTO ptp_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Om xam êno viac xam mɨ dô bin buc wê a Xomxo Nu obêc vena lec ge, ên buc wê xam obêc xovô lêm ge wê a obêc vena lec ge.” ");
INSERT INTO ptp_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Pita kɨnêg vô Yesu ên nêbê, “Apumtau, ông nêl kɨyang pɨlepacên ga vô xecxe va, me ông nêl vô xomxo vɨhati?” ");
INSERT INTO ptp_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Lêc Yesu nêl ên nêbê, “Xomxo yuac letya wê viac yuac hɨxôn pɨyôp nivɨha ge? Xomxo levac obêc vɨnoo i ên nêb i viac lie yuac vɨhati dɨ vông yaên vô he i tɨyi buc vɨhati. ");
INSERT INTO ptp_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Om xomxo levac tyo obêc vena yê wê nu yuac tige viac yuac wê i vông ge nivɨha ge od ob hi vɨxa ên i. ");
INSERT INTO ptp_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","A ob nêl hɨxôn nôn vô xam bê xomxo levac tige obêc vông nu yuac tyo tu levac mɨ viac susu wê i vông ge vɨhati. ");
INSERT INTO ptp_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Lêc nu yuac tige obêc xo bêga vac nɨlô bê, ‘Tɨbii levac la dô ilatɨkwê dɨ o vena lutibed lêm’, om loc hi lie yuac vêx yuu vux, dɨ ya dɨ num levac dɨ mav ge ");
INSERT INTO ptp_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","od xomxo levac obêc vena lec buc wê nu yuac tige lungên dɨ o dô bin i lec ge lêm, om xomxo levac obêc vông myavɨwen vô i dɨ vông i la dô hɨxôn tɨbii wê o vông i vin lêm ge. ");
INSERT INTO ptp_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Tɨbii yuac ti obêc xovô môp wê i tɨbii levac vông vô i ge lêc o viac mɨ vông i vô nôn lec lêm ge od levac tyo obêc pɨsa i vô nipaên. ");
INSERT INTO ptp_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Lêc tɨbii yuac ti obêc lungên môp wê i tɨbii levac nêb i vông ge, dêc vông ti so tɨyi wê ob kô myavɨwen nipaên lec ge od tɨbii tyo obêc vông myavɨwen nipwo tya vô dɨ hiên i luu vêlên ob ma. Ên xomxo wê kô susu tɨbeac vô Anutu ge, ge wê Anutu nêb i vông myavɨwen tɨbeac vac. Dɨ xomxo obêc vông susu tɨbeac vô xomxo ti ên nêb i vông yuac ya ge od he obêc nêl nêbê, ‘Ông vông susu vô xe i luu vêl vac.’” ");
INSERT INTO ptp_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Yesu nêl bêga ên nêbê, “A lam ên a nêb a ob lii ngwax i yêp kɨbun ga, om a nɨlôg xo ên a nêbê i tum lutibed. ");
INSERT INTO ptp_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Mêlêc vɨyin ti vô kwabo lec wê a ob kɨlê ge, lêc gên o val lêm, om a ob dô hɨxôn nɨlôg vɨyin levac dɨ i mɨloc vô buc wê vɨyin tyo obêc lam la vêl ge lê. ");
INSERT INTO ptp_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Xam xo ên xam nêb a lam ên a nêb a ob vông kɨyang malehe i yêp gê kɨbun ga, me? Ma vêl, a lam ên a nêb xomxo i hɨbu he sea lec a. ");
INSERT INTO ptp_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Om gwêbaga dɨ obêc buc tɨmuên hɨxôn ge od obêc môp bêga bê xomxo vɨgê vɨlu vac xumac ti obêc hɨbuma sea lec a lêg, lêc yuu dô kɨdu ngwe dɨ yon dô kɨdu ngwe. ");
INSERT INTO ptp_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Om he obêc hɨbuma, dɨ ma yuu nu vux ob yêma nipaên, dɨ ta yuu nu vêx ob yêma nipaên, dɨ vêxta yuu yen vêx ob yêma nipaên.” ");
INSERT INTO ptp_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Pyap dêc Yesu nêl vô xomxo gee vɨhati ên nêbê, “Xam obêc wê mapɨtoc ti le vac vɨyobtoc ge od xam mi nêl ên xam nêbê lun ob val, dêc vɨxôhɨlôg, lun val tɨyi xocbê xam nêl ge. ");
INSERT INTO ptp_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Dɨ buc wê lea ob val ge od xam nêl ên xam nêbê hɨyôv ob linac nivɨha, dêc vɨxôhɨlôg, hɨyôv linac i tɨyi wê xam nêl ge. ");
INSERT INTO ptp_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Lêcom xam tɨbii kɨtyooên, ên xam wê susu wê dô vac lag ge lê, lêc xovô nivɨha, dɨ bêna lêc xam dɨlungên môp wê Anutu vông gwêbaga vô xam mamnôn ge?” ");
INSERT INTO ptp_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Yesu nêl ên nêbê, “Bêna lêc xam o vyac xovô môp nivɨha mô lê? ");
INSERT INTO ptp_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Xomxo ti obêc kô ông mɨ muu la kɨyang ge od muu hi kɨyang i yib lutibed vac môp wê muu gên loc ge, êdêc i o lêc vông ông loc le vô hɨzap manôn dêc hɨzap i vông ông loc vô xêhɨpu mɨ xêhɨpu i vông ông loc kalabuhu lêm. ");
INSERT INTO ptp_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","A ob nêl vô ông bê ông ob la dô vac kalabuhu dɨ hi myavɨwen vɨhati i ma vêl lê.” ");
INSERT INTO ptp_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Vô buc tige xomxo ya val vô Yesu mɨ val nêl xomxo Galili kɨtong vô i. Ge nêl lec he Galili ti wê he dɨhi bwoc sipsip ên he nêb ob si i tu daa vô Anutu lê, lêc gavman levac Pailat vông nue lam hi he dɨ kɨpyax he hi sea hɨxôn bwoc hi. ");
INSERT INTO ptp_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Mêgem Yesu nêl vô he ên nêbê, “Xam xo ên xam nêbê Galili tigee, he vông nipaên luu lie Galili vêl om he yib lec he nên nipaên. ");
INSERT INTO ptp_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Lêcom a ob nêl vô xam bê he o yib lec ngwe bêge lêm. Lêcom xam xovô bê xam obêc pɨlepac xam lêm ge od xam obêc wib bêge êno. ");
INSERT INTO ptp_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Dɨ xomxo Jelusalem vɨgê yuu dɨ vɨxa vɨlu dɨ sec yon (18) wê xumac vɨxa dia kɨpê mɨ hi he yib gê Siloam ge, xam xo ên xam nêbê he vông nipaên luu lie Jelusalem baba vêl om he yib lec he nên nipaên. ");
INSERT INTO ptp_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Lêcom a ob nêl vô xam bê he o yib lec kehe bêge lêm. Lêcom xam xovô bê xam obêc pɨlepac xam lêm ge od xam obêc wib bêge êno mê.” ");
INSERT INTO ptp_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Yesu nêl kɨyang pɨlepacên ti vô he ên nêbê, “Xax kwacsung ti le vac xomxo ti yuac om xomxo tyo la yê ên nêb ob la yul nôn, lêc nôn ma, ");
INSERT INTO ptp_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","om nêl vô xomxo ti wê mi viac i yuac ge ên nêbê, ‘Ngô lê. A lam ga tɨyi klismas yon ên a nêb a ob yul kwacsung tiga nôn lê, lêc nôn ti o yux lec lêm. Om ông vuv vêl ên i o vô kɨbun hɨzi vêl vaxvax lêm.’ ");
INSERT INTO ptp_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Lêc xomxo viacên tige nêl vô i ên nêbê, ‘Vông i le klismas ngwe ga hɨxôn dɨ a den kɨbun yuu kô bwoc yaa mɨ tung vac kehe mɨ xê lê. ");
INSERT INTO ptp_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Dɨ klismas ngwe tɨmuên u ob xê lê, lêc vuac ge od i le, lêc vuacên ma ge od ông nêl dɨ a vuv vêl.’” ");
INSERT INTO ptp_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Vô buc sabat ti Yesu nêl xolac vô xomxo vac xumac lɨlo ti. ");
INSERT INTO ptp_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Lêc vêx ti dô hɨxôn he, dɨ vɨmwo nipaên dô vac i nɨlô dɨ vông yidac vô i tɨyi klismas vɨgê yuu dɨ vɨxa vɨlu dɨ sec yon (18). Om vêx tyo nɨmi kɨzêc len gec om o tɨyi wê ob le bôbac ge lêm. ");
INSERT INTO ptp_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Lêc Yesu yê vêx tyo om keac i lam dɨ nêl vô i ên nêbê, “Vêx, a vông ông yidac la vêl.” ");
INSERT INTO ptp_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Mêgem vyax vɨgê lec i dɨ lutibed vêx tyo le bôbac dɨ pɨmil Anutu. ");
INSERT INTO ptp_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Lêc xomxo levac ti wê viac xumac lɨlo ge ni nyag vô Yesu ên wê vông vêx tige vô nivɨha lec vô buc sabat ge, om nêl vô xomxo tɨbeac gee ên nêbê, “Buc vɨgê vɨlu dɨ sec ti yêp wê il ob vông yuac lec ge om xam ti obêc vông yidac ge od xam lam lec buc yuac ên xomxo i vông xam vô nimvɨha lec, dɨ xam o lêc lam lec buc sabat lêm.” ");
INSERT INTO ptp_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Lêc Apumtau Yesu luu i vya ên nêbê, “Xam tɨbii kɨtyooên, ên xam mi la vac bwoc ben dɨ la pɨwelac xam kau yuu donki lec buc sabat dɨ dɨdii he mɨ la vô mia ên xam nêb he i num. ");
INSERT INTO ptp_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Lêc vêx tiga Eblaham bue ti, lêc Seten ku i xôn tɨyi klismas vɨgê yuu dɨ vɨxa vɨlu dɨ sec yon (18), om a pɨwelac vɨyin tige vêl ên i lec buc sabat. Lêc mêd xam wê ên xam nêb môp tibêge o nivɨha lêm?” ");
INSERT INTO ptp_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Yesu nêl bêge om xomxo wê yê i nipaên ge ni yoc ên he, dɨ xomxo vɨhati gee he xêyaa vô nivɨha ên do levac vɨhati wê Yesu vông ge. ");
INSERT INTO ptp_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Yesu nêl ên nêbê, “Anutu ben kehe ge tɨyi vatya? A ob tɨxuu lec kɨyang ti. ");
INSERT INTO ptp_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Ge tɨyi xocbê vɨxôô nôn nulen wê nipwo lee tya, lêc xomxo ti kô mɨ la nêx vac yuac mêd nôn tyo tyip mɨ vô levac dɨ menac vɨyang vɨyang lam vông lɨwihi lec ngen mɨ dô lec.” ");
INSERT INTO ptp_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Nang dêc Yesu nêl ên nêbê, “Anutu ben kehe ge, a ob tɨxuu lec va? ");
INSERT INTO ptp_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Ge tɨyi xocbê yis nipwo tya wê vêx ti pɨlepac hɨxôn plaua levac om vông plaua vuac mɨ vô levac ge.” ");
INSERT INTO ptp_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Yesu la ên nêb ob la Jelusalem, lêc la vac vɨgwe levac yuu nipwo toto mɨ la nêl xolac vô xomxo. ");
INSERT INTO ptp_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Lêc xomxo ti kɨnêg i ên nêbê, “Apumtau, xomxo wê Anutu obêc kô he mɨ he la dô mavɨha ge, obêc yuu tya, me?” Om Yesu nêl vô he ên nêbê, ");
INSERT INTO ptp_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Xam vông yuac xêkɨzêc êdêc vac loc vac vuayen nipwo. Ên xomxo tɨbeac obêc xo ên nêb he ob la vac vuayen nipwo tige lê, lêc tɨyiên ma wê he ob la vac ge. ");
INSERT INTO ptp_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Ên xomxo wê i xumac ge obêc kɨdi mɨ lam tung xumac lec, om xam ob le vɨxun dɨ kɨtuu vuayen dɨ nêl bêga bê, ‘Apumtau, tax vuayen ên xe.’ Lêc obêc nêl vô xam bêga bê, ‘Xam lam gê na? Xam ge a lungên xam.’ ");
INSERT INTO ptp_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Lêc xam obêc luu i vya bêga bê, ‘Xe ga wê il mi xa mɨ mi dô, dɨ ông mi nêl xolac vô xe vac xe bom ge.’ ");
INSERT INTO ptp_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Lêc obêc nêl vô xam bêga bê, ‘Xam ge a lungên xam. Xam ge tɨbii nipaên, om xam loc vêl ên a magnôn.’ ");
INSERT INTO ptp_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Om xam obêc wê bume Eblaham yuu Aisak dɨ Jekop hɨxôn plopete vɨhati wê he la dô vac Anutu ben, dom xam ge wê Anutu obêc tii xam la dô vɨxun, dɨ xam obêc byag dɨ kic nɨvum lecma. ");
INSERT INTO ptp_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Dɨ tɨbii obêc kɨdi vac vɨgwe nɨnya vɨlu vɨlu dɨ vɨwen wê hɨyôv tyip lam ge dɨ vɨwen wê hɨyôv hoo la ge, mɨ la ya dɨ dô vac Anutu ben. ");
INSERT INTO ptp_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Om xam wê lê. Tɨbii wê xam nêb he tɨmuên ge ya ob lam la mugên, dɨ xomxo wê mugên ge ya obêc lôm la tɨmuên.” ");
INSERT INTO ptp_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Vô buc mahɨgun tige Palisi ya val nêl vô Yesu ên nêbê, “Ông sea vɨgwe ga dɨ lam loc bangwe, ên Helot nêb ob hi ông wib.” ");
INSERT INTO ptp_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Lêc Yesu nêl vô he ên nêbê, “Xam loc nêl vô tɨbii kɨtyooên tige bêga bê gwêbaga dɨ tɨtige wê a obêc tii vɨmwo nipaên vêl ên xomxo dɨ vông xomxo yidac i vô nivɨha lec, dɨ duuma ge wê a obêc tɨyôô yuac. ");
INSERT INTO ptp_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Lêc gwêbaga dɨ tɨtige dɨ duuma ge wê a ob la, ên plopete wê xomxo hi he yib ge, he o yib vac vɨgwe ya lêm. Nge, he yib vac vɨgwe Jelusalem tibed. ");
INSERT INTO ptp_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“Dɨ xam Jelusalem, xam ge wê xam hi plopete yib, dɨ xomxo wê Anutu vông i loc vô xam ge, od xam nêx he ya ngɨdax. Buc tɨbeac ge a vông ên a nêb a ob kɨtuc xam lôm vô a tɨyi xocbê kokɨlêx wê mi kɨtuc nue lax vac vɨnihi ngɨbi ge, lêc xam nêb a vôngên i ma. ");
INSERT INTO ptp_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Om xam ngô lê. Anutu obêc sea xam bom i dô xel. Dɨ a ob nêl vô xam bê xam ob wê a i tii vac nang lêm, dɨ i mɨloc vô buc wê xam obêc nêl bêga bê ‘Il ob pɨmil xomxo ti wê tu Apumtau manôn mɨ val ge.’” ");
INSERT INTO ptp_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Buc sabat ti Yesu la vac Palisi levac ti xumac mɨ la ya hɨxôn i, lêc xomxo wê dô gee dɨyê i xôn. ");
INSERT INTO ptp_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","He dô lê, lêc xomxo wê ninɨvi vô vuac vuac ge ti val vô Yesu, ");
INSERT INTO ptp_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","om Yesu kɨnêg he wê xovô Moses xolac gee yuu he Palisi wê dô gee ên nêbê, “Tɨyi wê il ob vông xomxo wê yidac ge i vô nivɨha lec vô sabat, me?” ");
INSERT INTO ptp_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Lêc he o luu kɨyang ti lax vô i lêm, om Yesu la hôm xomxo yidac tyo dɨ vông i vô nivɨha lec dɨ vông i loc mɨ la. ");
INSERT INTO ptp_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Mêgem Yesu nêl vô xomxo gee ên nêbê, “Xam nume ti me bwoc ti obêc tô lôva madia lec buc sabat ge od tɨyiên ma wê xam ob pul i lôm lutibed lec sabat ge, me?” ");
INSERT INTO ptp_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Lêc he o luu kɨyang ti lax vô Yesu lêm. ");
INSERT INTO ptp_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Yesu yê xomxo wê lam ya vac Palisi tyo ben ge, lêc yê wê he ya yong he nêb he ob dô lec sia nivɨha wê xomxo levac mi dô lec gee, om Yesu nêl kɨyang pɨlepacên ti vô he ên nêbê, ");
INSERT INTO ptp_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Xomxo ti obêc nêl ông la vac vɨzid ti ge od ông o lêc yong ông mɨ loc dô lec sia nivɨha wê xomxo levac ob dô lec ge lêm. Ên xomxo levac ngwe obêc val ge ");
INSERT INTO ptp_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","od xomxo ti wê myêl vɨzid tige obêc nêl vô ông bê, ‘Kɨdi lec mɨ loc dô ganê dɨ vông sia vô xomxo levac tige mɨ i dô lec,’ dɨ ông nim obêc yoc ên wê ông la dô tɨmuên. ");
INSERT INTO ptp_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","“Om xomxo ti obêc nêl ông la vac vɨzid ti ge od ông loc dô tɨmuên ti lê, lêc xomxo ti wê myêl vɨzid tige obêc nêl vô ông ên nêbê, ‘Ngɨdêg, lam dô lec sia nivɨha ga’ od ông obêc tu xomxo levac ti vô xomxo gee manôn. ");
INSERT INTO ptp_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Ên xomxo ti obêc yong i nêb i xomxo levac ge od Anutu obêc yê i xocbê xomxo pɨleva, lêc xomxo ti obêc vông i vô nipwo ge od Anutu obêc pɨmil i dɨ vông i lê vô levac.” ");
INSERT INTO ptp_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Pyap dêc Yesu nêl vô Palisi ti wê myêl vɨzid tige ên nêbê, “Ông obêc myêl vɨzid ge od ông o lêc nêl tame mame lime ngɨdême, me xomxo wê susu tɨbeac ge i lam lêm, ên he ge wê he obêc myêl vɨzid nang mɨ vông myavɨwen vac vô ông. ");
INSERT INTO ptp_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Nge, ông obêc myêl vɨzid ge od ông tyuc xomxo wê nên susu maên hɨxôn he wê o xêkɨzêc lêm dɨ he wê vɨxa nipaên hɨxôn he wê ma tocên gee i lam. ");
INSERT INTO ptp_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Xomxo tigee o tɨyi wê ob vông myavɨwen vac vô ông ge lêm, lêc Anutu ob vông myavɨwen nivɨha vô ông vô buc tɨmuên wê xomxo nivɨha ob kɨdi lec vac yibên ge om ông ob dô hɨxôn xêmyaa nivɨha.” ");
INSERT INTO ptp_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","He gên ya mɨ dô vac Palisi tyo ben, lêc xomxo ti vac he mahɨgun ngô kɨyang wê Yesu nêl lec vɨzid ge om nêl vô Yesu ên nêbê, “Xomxo wê ob la ya mɨ dô vac Anutu ben lag puunê ge obêc dô hɨxôn xêyaa nivɨha.” ");
INSERT INTO ptp_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Lêc Yesu nêl kɨyang pɨlepacên vô i bêga ên nêbê, “Xomxo ti nêb ob myêl vɨzid levac ti om vông kɨyang la vô xomxo tɨbeac ên nêb he i lam ya. ");
INSERT INTO ptp_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Om buc wê ob ya yaên ge od vông nu yuac ti la nêl vô xomxo wê ob lam vac vɨzid ge ên nêbê, ‘Yaên noc pyap, om xam lam ên lam wa.’ ");
INSERT INTO ptp_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","“Lêc he toto nêl lax vô i ên nêbê he laên ob ma. Om ti nêl vô i ên nêbê, ‘A kɨsuu kɨbun ti, om a ob la xê, om ông lôc nêl vô tɨbii levac bê o tɨyi wê a ob loc ge lêm.’ ");
INSERT INTO ptp_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Dɨ ti nêl vô i ên nêbê, ‘A kɨsuu bwoc kau vɨgê yuu om a ob la tɨxuu mɨ xê bêc obêc vông yuac nivɨha, om ông lôc nêl vô xomxo levac bê o tɨyi wê a ob loc ge lêm.’ ");
INSERT INTO ptp_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Dɨ ti nêl ên nêbê, ‘A kô vêx paha ti om a locên ob ma.’ ");
INSERT INTO ptp_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Mêgem nu yuac tyo lax mɨ la nêl kɨtong vô i xomxo levac, mêd xomxo levac tyo ngô dɨ xêyaa vô myavɨnê dɨ i nêl vô nu yuac tyo ên nêbê, ‘Ông loc tup vô môp levac yuu nipwo vɨhati vac vɨgwe levac ga dɨ tyuc xomxo wê nên susu maên hɨxôn he wê o xêkɨzêc lêm ge dɨ he wê vɨxa nipaên hɨxôn he wê manôn tocên gee vɨhati i lam.’ ");
INSERT INTO ptp_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Om nu tyo la vông i tɨyi dêc lôm nêl vô i ên nêbê, ‘A vông i tɨyi wê ông nêl ge lê, lêc vɨgwe gên o pup lec lêm.’ ");
INSERT INTO ptp_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","“Mêgem xomxo levac tyo nêl vô i ên nêbê, ‘Om ông loc vô môp nipwopwo wê la vac yuac ge vɨhati dɨ loc kɨdu xomxo vɨhati ên he i lam pup lec a xumac. ");
INSERT INTO ptp_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Lêc a nêl vô ông bê xomxo wê a tyuc he taxlee lêc he o lam lêm ge, ti ob ya vɨzid wê a vông ge hɨxôn lêm.’” ");
INSERT INTO ptp_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Xomxo tɨbeac hɨwocên tɨmu vô Yesu vɨxa mɨ he la, lêc Yesu pop i dɨ nêl vô he ên nêbê, ");
INSERT INTO ptp_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Xomxo ti obêc nêb tɨmu vô a xolac, lêc vông nɨlô lax vô tae mae lie dɨ vɨnêe nue dɨ ici va, dɨ o vông nɨlô la dɨluhu vô a lêm ge od o tɨyi wê ob tu a nug ge lêm. ");
INSERT INTO ptp_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Dɨ xomxo wê o kɨlê vɨyin lec tɨyi xocbê kɨlê xax pola ge mɨ tɨmu vô a lêm ge, ge o tɨyi wê ob tu a nug ge lêm. ");
INSERT INTO ptp_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Om xam ngô lê. Xam ti obêc xo ên xam nêb xam ob lox xumac vɨxa dia ti ge od i dô mɨ xovô bê mone dô i tɨyi wê ob lox xumac tige ya dɨ i pyap ge, me? ");
INSERT INTO ptp_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Obêc xovô bêge tax lêm ge od obêc yev teac vac pyap, lêc o tɨyi wê ob lox xumac tige pyap ge lêm, dɨ xomxo vɨhati ob yê dɨ so vya vô ông ");
INSERT INTO ptp_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","dɨ nêl bêga nêbê, ‘Xomxo tige nêb ob lox xumac lê, lêc o lox i pyap lêm.’ ");
INSERT INTO ptp_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Dɨ kɨyang ngwe, king ti wê nue vevac 10,000 ge nêb ob la vông vevac vô king ngwe wê nue vevac 20,000 ge od i dô mɨ xovô bêga bê xêkɨzêc wê nue vông ge tɨyi wê obêc ngɨnoo king ngwe wê nue 20,000 ge vêl ge, me he tɨyiên ma. ");
INSERT INTO ptp_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Lêc obêc xovô bê tɨyiên ma ge od king ngwe ge i gên dô teva dɨ i vông xomxo mangwe i loc ên he i viac kɨyang bê vevac obêc ma. ");
INSERT INTO ptp_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","“Kɨyang bêge, mêgem xam xovô bê xam ti obêc vô nɨmim vô susu wê i vông ge vɨhati lêm ge od o tɨyi wê ob tu a nug ge lêm. ");
INSERT INTO ptp_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Sol ge nivɨha, lêc obêc vô nyen maên ge od il obêc vông bêna vô ên i vô nyen i tii vac nangê? ");
INSERT INTO ptp_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Ên sol wê nyen maên ge o nivɨha tɨyi wê il ob vông yuac ya ge lêm, om il ob nêx i la xel. Xam nɨnyam obêc yêp ge od xam ngô dɨ xovô.” ");
INSERT INTO ptp_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Tɨbii nipaên wê mi kô takis gee hɨxôn tɨbii nipaên yaya, he tɨbeac la vô Yesu ên nêb ob ngô i vya. ");
INSERT INTO ptp_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Lêc he Palisi yuu xomxo wê xovô Moses xolac gee yê dɨ vô mya nipaên vô dɨ nêl ên nêbê, “Xomxo tya ganê kô tɨbii nipaên lec dɨ ya mɨ dô hɨxôn he.” ");
INSERT INTO ptp_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Mêgem Yesu nêl kɨyang pɨlepacên ti vô he ên nêbê, ");
INSERT INTO ptp_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Xam ti obêc viac bwoc sipsip 100 lêc ti xôa obêc ma ge od obêc sea sipsip 99 gee i le dɨ lax myag ti wê xôa ma ge. ");
INSERT INTO ptp_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Dɨ obêc yêvô ge od obêc kɨlê lec kɨdiac dɨ lax mɨ la ben hɨxôn xêyaa nivɨha, ");
INSERT INTO ptp_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","dɨ lax nêl lie hɨxôn nipɨpu ya lam dɨ nêl vô he ên nêbê, ‘Xam lam ên il xôn ob dô hɨxôn xêdyaa nivɨha dɨ pɨmil a bwoc, ên a bwoc ga xôa ma lê, lêc a la xêvô mɨ kô mɨ vena nang.’ ");
INSERT INTO ptp_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Kɨyang bêge mêgem a ob nêl vô xam bê xomxo wê vông nipaên ge ti obêc pɨlepac i ge od he wê dô kɨsii ganê obêc hi vɨxa ên i, ngɨnoo xomxo 99 wê he nêb he vô nivɨha lec pyap om he ob pɨlepac he lêm ge.” ");
INSERT INTO ptp_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Yesu nêl ên nêbê, “Vêx ti mone vɨgê yuu, lêc ti xôa ma om byêx ngwax vac lam dɨ pɨtyep xumac nɨlô dɨ myag. ");
INSERT INTO ptp_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Myag lêc yêvô om nêl lie hɨxôn nipɨpu ya lam dɨ nêl vô he ên nêbê, ‘Xam xêmyaa i vô nivɨha hɨxôn a, ên a mone xôa ma, lêc a xêvô i tii vac nang.’ ");
INSERT INTO ptp_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Kɨyang bêge om a ob nêl vô xam bê xomxo wê vông nipaên ge ti obêc pɨlepac i ge od Anutu nue angela obêc hi vɨxa ên i tɨyi xocbê vêx tige hi vɨxa ên mone wê yêvô ge.” ");
INSERT INTO ptp_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Yesu nêl vô he ên nêbê, “Xomxo ti do, dɨ i nu tuc yuu nu môn. ");
INSERT INTO ptp_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Lêc nu môn nêl vô ma ên nêbê, ‘Mag, kɨbun yuu mone wê ông nêl a lêg lec ge, a ob kô vɨhati.’ Om ma vông byed vô susu vô yuu, om nu tuc kô vɨwen dɨ nu môn kô vɨwen. ");
INSERT INTO ptp_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","He o dô buc xuhu dia lêm. Nge, dô nipwo tya, lêc nu môn vɨduba i susu hɨxôn mone wê ma vông vô i ge vɨhati dɨ loc mɨ la vɨgwe teva ti, dɨ la nêx mone la sea lec môp nipaên. ");
INSERT INTO ptp_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","I nên mone ma vêl, dɨ vip mabu yêp vac vɨgwe tige dɨ susu ma ên i. ");
INSERT INTO ptp_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Om la vông yuac vô tɨbii vɨyang tige ti, lêc tɨbii tyo vông i la bwoc ben ên nêb i loc viac i bwoc. ");
INSERT INTO ptp_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Mêlêc vip den i mabu om xo ên nêb ob ya xax nôn wê bwoc mi ya ge ên i den i, lêc xomxo ti o vông yaên ti vô i mɨ i ya lêm. ");
INSERT INTO ptp_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“Mêd i pɨyôp vô nivɨha dɨ i xovô nang, om xo ên nêbê, ‘Nue yuac wê mag vông ge, yaên tɨbeac dô vô he, dom a va ga, vip obêc den a xib mê. ");
INSERT INTO ptp_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Mêgem a ob kɨdi mɨ lax mɨ la vô mag, mɨ lax nêl vô bê, “Mag, a vông i so vô Anutu dɨ vông i so vô ông hɨxôn, ");
INSERT INTO ptp_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","dɨ a o nigvɨha tɨyi wê ông ob nêl bê ông num a ge lêm. Om ông vông a tu ông num yuac ti.” ’ ");
INSERT INTO ptp_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","“Nêl kɨyang bêge pyap, mêd kɨdi mɨ la ên nêb ob lax mɨ la vô ma, lêc gên mɨla teva dɨ ma yê ma la wê nu môn val ge, om xo vɨgwe pɨsiv ên dɨ tup mɨ la dɨ mɨla kɨva xôn. ");
INSERT INTO ptp_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Mêd nu môn nêl vô ma ên nêbê, ‘Mag, a vông i so vô Anutu dɨ vông i so vô ông hɨxôn, om a o nigvɨha tɨyi wê ông ob nêl bê ông num a ge lêm.’ ");
INSERT INTO ptp_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Ma ngô lê, lêc nêl vô nue yuac ên nêbê, ‘Xam loc kô ngakwi dia nivɨha ti mɨ lam vɨnyum lec môn. Dɨ xam kô ling ti mɨ lam su lec i vɨgê dɨ kô su mɨ lam su lec i vɨxa xôn. ");
INSERT INTO ptp_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Dɨ loc kô bwoc kau nu wê gên ligên nivɨha ge ti mɨ lam hi, ên il ob xa hɨxôn xêdyaa nivɨha, ");
INSERT INTO ptp_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","ên a nug tiga xocbê la yib ila lê, lêc gwêbaga dô mavɨha, dɨ xôa ma ila lê, lêc gwêbaga il xêvô i nang.’ Om he myêl vɨzid mɨ ya dɨ dô hɨxôn xêyaa nivɨha. ");
INSERT INTO ptp_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Dɨ nu tuc la dô vac yuac dɨ val vô kwabo vô xumac lêc val ngô wê he yoo ge, ");
INSERT INTO ptp_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","om keac nu yuac ti lam dɨ kɨnêg vô i ên nêbê, ‘Xam vô va?’ ");
INSERT INTO ptp_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Lêc nu yuac tige nêl ên nêbê, ‘Lim môn val gwêba, om mam hi bwoc kau nu wê gên ligên nivɨha ge ti mɨ myêl vô lim môn ên wê la dô lê, lêc vena nivɨha vô i ge.’ ");
INSERT INTO ptp_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Li tuc ngô lêc xêyaa vô myavɨnê om nêb ob la vô ma yuu li môn vac xumac lôma lêm. Om ma lop mɨ lam vɨxun dɨ lam viac kɨyang vô nu tuc. ");
INSERT INTO ptp_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Lêc nu tuc nêl lax vô ma ên nêbê, ‘A ga wê a vông yuac levac vô ông tɨyi klismas tɨbeac dɨ a o pwoo ông vyam ti vac lêm, lêc ông o nêl a lêg lec bwoc vɨmek nu ti ên xe lige myêl mɨ xa dɨ dô hɨxôn xêmyaa nivɨha lêm. ");
INSERT INTO ptp_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Dɨ num môn ge wê kô ông mone mɨ la vông i la lec vêx yôdac lê, lêc gwêbaga vena om ông hi bwoc levac wê lig nivɨha ge ti vô i.’ ");
INSERT INTO ptp_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“Mêd ma nêl vô nu tuc ên nêbê, ‘Tuc, u mi dô ga luta, om susu wê a vông ge vɨhati tu ông xe. ");
INSERT INTO ptp_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Dɨ gwêbaga il vɨhati ob dô hɨxôn xêdyaa nivɨha ên wê lim môn vena ge, ên xôa ma ila om il xê xocbê la yib ge, lêc la dô mavɨha om vena gwêbaga dɨ il xê i manôn nang.’” ");
INSERT INTO ptp_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Nang dêc Yesu nêl vô nue ngɨvihi ên nêbê, “Xomxo susu tɨbeac ti dô, dɨ nu yuac ti viac i susu, lêc xomxo ya la nêl kɨtong vô xomxo levac tyo ên nêbê, ‘Num ti wê bin ông yuac ge mi vông ông susu yuu mone la vax vax.’ ");
INSERT INTO ptp_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Om xomxo levac tige keac nu yuac tyo lam dɨ kɨnêg vô i ên nêbê, ‘Ông vông bêna lêc a ngô xocbê kɨyang yêp vô ôngê? Ông loc kɨvuu a susu wê ông viac ge vɨhati lec kɨpihac ti dêc vông i lam ên a xê, ên ông ob viac a yuac i tii vac lêm.’ ");
INSERT INTO ptp_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“Om nu yuac tyo xo bêga ên nêbê, ‘Om a ob vông bêna? Ên xomxo levac obêc tii a vêl ên i yuac gwêbaga, lêc xêkɨzêc wê a vông ge tɨyiên ma wê a ob kɨden kɨbun ge, dɨ a nig yoc ên wê a ob kɨtaa susu vaxvax vô xomxo ya ge. ");
INSERT INTO ptp_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Lêcom ga a xovô môp wê a ob vông ge ti, êdêc buc wê xomxo levac obêc tii a vêl ên i yuac ge od xomxo ya i kô a mɨ loc vac ben dɨ viac a.’ ");
INSERT INTO ptp_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Om môp wê xovô ge bêga ên nêbê keac tɨbii wê i xomxo levac myavɨwen yêp vô ge he toto lam, dêc kɨnêg ti wê val taxlee ge ên nêbê, ‘Ông kô susu vaba vô xomxo levac lêc myavɨwen gên yêpê?’ ");
INSERT INTO ptp_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Om xomxo tyo nêl vô i ên nêbê, ‘Ge a kô wel vac dlam 100.’ Om nu yuac tyo nêl vô i ên nêbê, ‘Hôm kɨpihac wê ông myavɨwen yêp lec ge dɨ kɨvuu ông myavɨwen i tô mɨ loc xocbê dlam wel 50.’ ");
INSERT INTO ptp_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Nang dêc xomxo ngwe val om nu yuac tyo kɨnêg i ên nêbê, ‘Ông myavɨwen vaba yêpê?’ Lêc xomxo tyo nêl ên nêbê, ‘Pɨdi yul 100.’ Om nu yuac tyo nêl vô i ên nêbê, ‘Hôm kɨpihac ga dɨ kɨvuu ông myavɨwen bê pɨdi yul 80.’ ");
INSERT INTO ptp_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Om xomxo levac tyo yê môp nipaên wê nu yuac tige vông ge, lêc pɨmil nu yuac tige ên wê vông môp hɨxôn pɨyôp nivɨha ge. Ên xomxo wê vông nɨlô la vô susu kɨbun ga ge, he kô pɨyôp levac lec môp yuu yuac kɨbun ga luu xomxo wê dô vac xêseac ge vêl. ");
INSERT INTO ptp_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","“Om a ob nêl vô xam bê xam ngɨdu xomxo xôn ya mone yuu susu kɨbun ga ên he xêyaa i vô nivɨha vô xam, dɨ buc tɨmuên wê xam vɨgêm obêc sea mone ge od Anutu i kô xam mɨ xam loc dô vac i ben luta lêc luta. ");
INSERT INTO ptp_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Xomxo ti obêc viac yuac nipwopwo wê xomxo nêb i vông ge nivɨha ge od obêc viac yuac levac nivɨha êno bêge, lêc xomxo ti obêc viac yuac nipwopwo nivɨha lêm ge od obêc viac yuac levac êno nivɨha lêm. ");
INSERT INTO ptp_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Mone yuu susu kɨbun ga, ge susu pɨleva, lêc xam obêc viac nivɨha lêm ge od letya obêc vông vɨzid wê nôn nivɨha ge ti vac xam vɨgêmê? ");
INSERT INTO ptp_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Dɨ xam obêc viac xomxo ngwe susu nivɨha lêm ge od letya ob vông susu vô xam ên nêb i tu xam nêmê? ");
INSERT INTO ptp_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Xomxo ti o tɨyi wê ob vông yuac vô xomxo levac yuu ge lêm, ên xêyaa obêc vin lec ngwe dɨ ob yê ngwe nipaên, me obêc vông nɨlô la vô ngwe dɨ vô nɨmi vô ngwe. Om o tɨyi wê xam ob vông nɨlôm i loc vô Anutu yuu xôn mone ge lêm.” ");
INSERT INTO ptp_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Palisi ngô kɨyang wê Yesu nêl ge lêc vô mya nipɨpaa vô, ên he xêyaa vin lec mone luu vêl. ");
INSERT INTO ptp_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Om Yesu nêl vô he ên nêbê, “Xam ge wê xam yong xam ên xam nêbê xomxo i yê xam nêbê xam nivɨha, lêc Anutu xovô xam nɨlôm nêb nipaên, ên môp wê xomxo yê nêb nivɨha ge, ge wê Anutu yê ên nêb juda juda nipaên. ");
INSERT INTO ptp_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Moses xolac hɨxôn plopete kɨyang yêp dɨ i val tyip vô buc wê Jon lipac xomxo ge, dɨ vô buc wê Jon vông ge dɨ i val gwêbaga, a nêl xolac paha wê Anutu ben ge vô xomxo, mêgem xomxo tɨbeac nɨlô kɨdu he nêb he ob tu Anutu nue mɨ la dô vac i ben. ");
INSERT INTO ptp_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Lag yuu kɨbun obêc la xôa ma, lêc Moses xolac bo ti obêc la xôa ma hɨxôn lêm. ");
INSERT INTO ptp_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Xomxo ti obêc sea vɨnê dɨ la kô vêx bangwe ge od ge vông yôdac vêx yuu vux, dɨ xomxo ti obêc kô vêx ti wê lɨya sea i dɨ la ge od ge vông môp yôdac vêx yuu vux.” ");
INSERT INTO ptp_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Nang dêc Yesu nêl ên nêbê, “Xomxo susu tɨbeac ti dô dêc vɨnyum ngakwi nivɨhavɨha dɨ ya yaên nivɨhavɨha tɨyi buc vɨhati. ");
INSERT INTO ptp_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","21","Dêc xomxo susu maên ge ti dô lênêbê Lasalas, lêc mi yêp vô xomxo susu tɨbeac tyo vuayen, ên nêb ob ya yaên myapɨpu wê tô mɨ la vac tevol kwa ngɨbi ge, lêc kɨtyax dô lec Lasalas ninɨvi vɨhati om noo lam mi tep lec. ");
INSERT INTO ptp_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Yuu mi dô dɨ buc ti lê, lêc Lasalas yib dɨ angela lam kô i mɨ la tung i hɨxôn Eblaham vac Anutu ben lag puunê. Nang dêc xomxo susu tɨbeac tyo yib nang mɨ lie yev, ");
INSERT INTO ptp_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","dɨ i la dô vac vɨgwe nipaên dɨ kô myavɨnê levac mɨ dô, dêc yê ma la kɨsii lêc yê Eblaham wê dô tevabanê dɨ Lasalas dô hɨxôn i ge. ");
INSERT INTO ptp_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Mêgem tyuc vya levac ên nêbê, ‘Mag Eblaham, ông xo vɨgwe pɨsiv ên a, dɨ vông Lasalas i lam tɨnyum vɨgê lɨyihi vac mia dɨ kô mɨ lam kɨtiv lec a get ên i vô ningɨgooên vô a, ên ngwax ya a nignɨvi vô myavɨnê levac.’ ");
INSERT INTO ptp_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Lêc Eblaham nêl vô i ên nêbê, ‘Nuge, ông xovô lê. Ên buc wê ông dô kɨbun ge, od ông dô vac nivɨha hɨxôn susu nivɨha, dɨ Lasalas dô vac nipaên nôn, lêc gwêbaga Lasalas dô vac nivɨha yuu malehe dɨ ông va dô vac nipaên yuu myavɨnê. ");
INSERT INTO ptp_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Dɨ kɨyang ti yêp bêga nêbê vun madia ti yêp kɨsuu xe dɨ xam lec, om xomxo ti obêc nêb kɨdi vac ga dɨ loc vô xam ge od tɨyiên ob ma, dɨ ngwe obêc nêb kɨdi vac xam mɨ lam vô xe ge od tɨyiên ob ma.’ ");
INSERT INTO ptp_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Mêd xomxo susu tɨbeac tyo nêl ên nêbê, ‘Mag Eblaham, a kɨtaa ông bê ông vông Lasalas i lôc mɨ loc mag ben, ");
INSERT INTO ptp_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","ên a lige vux vɨgê vɨlu dô, om a nêb i loc nêl vô he bê he i sea môp nipaên êdêc he i o lêc lam kô myavɨnê nipaên hɨxôn a lêm.’ ");
INSERT INTO ptp_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“Lêc Eblaham nêl vô i ên nêbê, ‘Kɨyang wê Moses he plopete kɨvuu ge yêp pyap, om he i ngô.’ ");
INSERT INTO ptp_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Lêc xomxo tyo nêl ên nêbê, ‘Mag, ge tɨyiên ma, lêc xomxo ti obêc kɨdi lec vac yibên mɨ la nêl kɨyang vô he ge od he obêc pɨlepac he.’ ");
INSERT INTO ptp_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Lêc Eblaham nêl ên nêbê, ‘He ob ngô Moses he plopete kɨyang mɨ vông i vin lêm ge od xomxo ti obêc kɨdi lec vac yibên mɨ lax ge od he obêc vông i vin xomxo tige vya êno lêm.’” ");
INSERT INTO ptp_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yesu nêl vô nue ngɨvihi ên nêbê, “Môp nipaên toto yêp wê ob vông xomxo vô nipaên ge, lêc xomxo ti wê dɨdii xomxo vac nipaên ge obêc kô myavɨwen levac lec. ");
INSERT INTO ptp_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Xomxo tibêge, xomxo ob nux ngɨdax vɨyin lec i kwa dɨ nêx i la vac gwec madia ge od nivɨha, êdêc i o lêc vông xomxo wê xovôên ma ge ti i vô nipaên lêm. ");
INSERT INTO ptp_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Om xam viac xam nivɨha. Dɨ lime ti obêc vông i so ge od ông nêl i nên soên vô i, dɨ obêc pɨlepac i ge od ông kɨtya i nên nipaên vêl. ");
INSERT INTO ptp_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Dɨ lim tyo obêc vông i so vô ông lu vɨgê vɨlu dɨ sec yuu lec buc ti, dɨ lam vô ông lu vɨgê vɨlu dɨ sec yuu lêc nêl ên nêbê, ‘A vông i so vô ông’ ge od ông kɨtya i nên nipaên tigee vɨhati vêl.” ");
INSERT INTO ptp_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Apumtau Yesu nue ngɨvihi nêl vô i ên nêbê, “Xe nêb ông vông xe nêm vông vinên i vô levac.” ");
INSERT INTO ptp_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Lêc Apumtau nêl vô he ên nêbê, “Xam nêm vông vinên obêc nipwo tya tɨyi xocbê vɨxôô nôn nulen ge od xam tɨyi wê xam ob nêl vô xax levac tige bê, ‘Ông pul ông vêl ên kɨbun dɨ loc ên loc yev ông vac gwec’ ge od obêc vô nɨnya lehe vô xam.” ");
INSERT INTO ptp_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Yesu nêl ên nêbê, “Xam nume yuac ti obêc sap kɨbun me viac bwoc dɨ vena ge od ông ob nêl bêna vô i? Ông ob nêl vô bê, ‘Ông lam tô mɨ dô kɨbun mɨ wa yaên’? ");
INSERT INTO ptp_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Ông ob nêl tibêge lêm. Nge, ông ob nêl vô bê, ‘Ông viac ông dɨ myêl yaên mɨ duu, dɨ kô mɨ lam ên a ob xa dɨ num tax, dêc ông wa dɨ num tɨmuên.’ ");
INSERT INTO ptp_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Dɨ num yuac tige obêc nêl bêna vô ông? Ôbêc nêl bê ông pɨmil i ên wê vông yuac wê ông nêl ge, me? Ob nêl tibêge lêm, ên ge i yuac wê mi vông ge. ");
INSERT INTO ptp_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Om xam êno, xam obêc vông yuac vɨhati tɨyi xocbê Anutu nêl vô xam ge od xam o lêc nêl bê Anutu i pɨmil xam lêm. Nge, xam nêl bêga bê, ‘Xe tɨbii yuac pɨleva. Xe o tɨyi wê xe ob nêl bê Anutu i pɨmil xe ge lêm. Ên yuac wê xe vông ge, Anutu vông vac xe vɨgêm om xe vông.’” ");
INSERT INTO ptp_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Yesu la ên nêb ob la Jelusalem, lêc la vac Samelia yuu Galili ben yôg, ");
INSERT INTO ptp_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","mɨ la vac vɨgwe ti, lêc xomxo kɨtyax mahɨzihɨzi vɨgê yuu yê i, lêc le teva ");
INSERT INTO ptp_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","dɨ tyuc vya levac ên nêbê, “Apumtau Yesu, xo vɨgwe pɨsiv ên xe.” ");
INSERT INTO ptp_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Om Yesu yê he dɨ nêl vô he ên nêbê, “Xam loc ên loc hɨlung nimnɨvi vô xomxo wê mi dô vac xumac ngɨbua ge lê ên he i yê bê xam nimnɨvi vô nivɨha lec.” Om he dɨla vô môp lêc he ninɨvi vô nivɨha lec. ");
INSERT INTO ptp_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Om he yê wê ninɨvi vô nivɨha lec ge, lêc he ti pop mɨ lax mɨ la vô Yesu dɨ pɨmil Anutu ya vya levac, ");
INSERT INTO ptp_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","dɨ yev vɨxa kɨtu vac dɨ kɨpôm manôn vô Yesu vɨxa kwa ngɨbi dɨ pɨmil i ên wê vông i vô nivɨha lec ge. Xomxo tige tɨbii Samelia ti. ");
INSERT INTO ptp_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Mêd Yesu nêl ên nêbê, “A vông xomxo vɨgê yuu vô nivɨha lec lê, lêc he vɨgê vɨlu dɨ sec yuudɨyuu la na? ");
INSERT INTO ptp_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Tɨbii tibed ga wê vena pɨmil Anutu ge, dom he baba wê Yuda ge ti o vena lêm.” ");
INSERT INTO ptp_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Mêd Yesu nêl vô tɨbii Samelia tyo ên nêbê, “Kɨdi lec mɨ lôc bom, ên vông vinên wê ông vông ge wê vông ông nimnɨvi vô nivɨha lec.” ");
INSERT INTO ptp_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Palisi ya val kɨnêg vô Yesu ên nêbê, “Buc wê Anutu obêc lam tu king mɨ xomxo la vac i kwa ngɨbi ge obêc yelacna?” Lêc Yesu nêl ên nêbê, “Xam ob wê do ti lê lêc xovô bê Anutu buc wê ob tu king ge val ge lêm. ");
INSERT INTO ptp_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Dɨ xomxo tɨyiên ma wê ob yê mɨ nêl bê, ‘Wê, tyo val ga’ me ‘Tyo dô ganê’. Xam ngô lê. Anutu lam tu king vac xam mahɨgun pyap.” ");
INSERT INTO ptp_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Mêd Yesu nêl vô nue ngɨvihi ên nêbê, “Obêc buc tɨmuên ge od xam obêc zid bê Xomxo Nu buc i vena lutibed ên xam wê, lêcom xam wêên ob ma. ");
INSERT INTO ptp_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Dɨ xomxo ya obêc nêl vô xam bê, ‘Wê, tyo dô ganê,’ me ‘Tyo val ga.’ Lêc xam o lêc loc vô he vɨxa lêm. ");
INSERT INTO ptp_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Ên buc wê Xomxo Nu obêc vena ge od obêc vena tɨyi xocbê deac hɨxelac lutibed dɨ xêseac linac la vac vɨgwe vɨhati ge. ");
INSERT INTO ptp_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Mêlêc Xomxo Nu obêc kô myavɨnê levac tax dɨ xomxo wê dô gwêbaga obêc vô nɨmi vô i. ");
INSERT INTO ptp_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“Lêc buc tɨmuên wê Xomxo Nu obêc vena ge od xomxo obêc dô i tɨyi xocbê xomxo dô vô Nôa buc ilage dɨ Xomxo Nu ob vena. ");
INSERT INTO ptp_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Ên xomxo ilage ya dɨ num dɨ iima mɨ dô, dɨ i mɨla tyip lec buc wê Nôa la dô vac sip nɨlô ge lê, lêc lutibed mia butac mabu dɨ lam hi xomxo vɨhati yib mɨma vêl. ");
INSERT INTO ptp_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","“Dɨ Lot buc bêge êno, ên xomxo ya dɨ num dɨ kɨsuu susu vôma dɨ vông yuac lec yaên dɨ lox xumac mɨ dô, ");
INSERT INTO ptp_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","lêc buc wê Lot kɨdi gê Sodom mɨ la ge od ngwax yuu ngɨdax myavɨnê tô gê lag puunê tɨyi xocbê lun val ge mɨ lam hi xomxo gee yib mɨma vêl. ");
INSERT INTO ptp_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Om buc wê Xomxo Nu obêc vena le seac ge od xomxo obêc dô mɨ vông bêge êno. ");
INSERT INTO ptp_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Obêc buc tige lêc xomxo ti dô lec xumac kɨsii ge od i o lêc lop mɨ lax kô i susu vac xumac lôma lêm, me xomxo ti obêc la dô vac yuac ge od i o lêc lax mɨ la ben lêm. Nge, susu i dô dɨ xomxo i loc nên mô. ");
INSERT INTO ptp_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Xam xovô Lot vɨnê wê tu ngɨdax mɨ le vac môp ge. ");
INSERT INTO ptp_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Ên xomxo ti obêc nêb viac ninɨvi ên vɨyin yuu yibên ge od mavɨha wê i vông ge obêc yib. Lêc xomxo ti obêc sea i ninɨvi lec a lêg ge od obêc dô mavɨha yuu nivɨha. ");
INSERT INTO ptp_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","“A ob nêl vô xam bê obêc buc tige xomxo yuu ob dɨyêp lec pêt ti vô bucên, lêc Anutu obêc kô ngwe dɨ sea ngwe dô. ");
INSERT INTO ptp_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Dɨ vêx yuu obêc dɨvông yuac ti mɨ dô, lêc Anutu obêc kô ngwe dɨ sea ngwe dô. ");
INSERT INTO ptp_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Dɨ vux yuu obêc dô vac yuac ti lê, lêc Anutu obêc kô ngwe dɨ sea ngwe.” ");
INSERT INTO ptp_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Mêd nue ngɨvihi kɨnêg vô Yesu ên nêbê, “Apumtau, kɨyang tige obêc vô nôn lec gê na?” Lêc Yesu nêl vô he ên nêbê, “Xam xovô bê susu wê yib mɨ pɨtal ge obêc yêp vac vɨgwe ti ge od menac byang kɨtucma dɨ la lec vɨgwe tige.” ");
INSERT INTO ptp_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Mêd Yesu nêl kɨyang pɨlepacên ti vô nue ngɨvihi, ên nêb ob vông xovôên vô he bê he i kɨtaa i tɨyi buc vɨhati dɨ ni ma lecên i ma. ");
INSERT INTO ptp_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Om nêl kɨyang pɨlepacên bêga vô he ên nêbê, “Hɨzap ti dô vac vɨgwe ti, lêc o xona ên Anutu lêm dɨ yê xomxo vɨhati tɨyi xocbê susu vɨdaaên ge. ");
INSERT INTO ptp_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Dɨ vêxôv ti dô vac vɨgwe tige, lêc la mi kɨtaa hɨzap tige tɨyi buc vɨhati ên nêbê, ‘Tɨbii ti nêb ob vông kɨyang vô a, om a nêb ông ngɨdu a xôn ên a nêg kɨyang.’ ");
INSERT INTO ptp_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Lêc hɨzap o vông i vin i vya lutibed lêm, dɨ buc tɨbeac la vêl lê, lêc hɨzap tyo xo bêga ên nêbê, ‘A o xona ên Anutu lêm, dɨ a o xona ên xomxo ti lêm. Nge, a xê he tɨyi susu vɨdaaên. ");
INSERT INTO ptp_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Lêcom vêxôv tige môci lam mi kɨtaa a ngɨnong om a obêc ngɨdu i xôn ên i kɨyang, ên i o lêc lam ngɨnong ngɨnong mɨ vông a nig i ma lêm.’” ");
INSERT INTO ptp_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Mêd Apumtau Yesu nêl vô nue ngɨvihi ên nêbê, “Xam xovô kɨyang wê hɨzap nipaên tige nêl ge lê. ");
INSERT INTO ptp_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Om xam xo ên xam nêbê va? Xomxo wê Anutu vɨnoo he pyap nêb he tu ixe ge, he obêc kɨyag vya lec Anutu tɨyi bucên yuu vɨdiiên vɨhati ge od Anutu obêc ngô he vya lêmê? Dɨ obêc ngɨdu he xôn lutibed lêmê? ");
INSERT INTO ptp_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","A ob nêl vô xam bê Anutu obêc ngô he vya dɨ ngɨdu he xôn lutibed. Lêc a ob kɨnêg vô xam bê buc wê Xomxo Nu obêc lop mɨ lôm ge od obêc yê bê xomxo vông i vin, me o vông i vin lêm?” ");
INSERT INTO ptp_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Yesu nêl kɨyang pɨlepacên tiga vô xomxo ya wê nêb he tɨbii vông vinên nivɨha dɨ yê xomxo baba ên nêb he xomxo vɨdaaên ge, om nêl bêga vô he ên nêbê, ");
INSERT INTO ptp_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Xomxo yuu la vac Anutu xumac ngɨbua ên nêb ob la kɨtaa, Palisi ngwe dɨ tɨbii takis kôên ngwe. ");
INSERT INTO ptp_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Om Palisi tyo la le dɨ kɨtaa vac nɨlô bêga ên nêbê, ‘O Anutu, a pɨmil ông ên wê a o nipaên tɨyi xocbê xomxo baba ge lêm, ên he mi vông môp yôdac susu yuu yôdac vêx yuu vux dɨ môp nipaên yaya. Dɨ a o nipaên tɨyi xocbê tɨbii takis kôên ganê lêm. ");
INSERT INTO ptp_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Ên a ga wê a mi ngɨbua yaên lec buc yuu yuu tɨyi da vɨhati, dɨ a mone yuu susu wê a mi kô ge a mi tung vɨgê yuu yuu, om a mi vông kɨdu ti vô ông.’ ");
INSERT INTO ptp_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Dɨ tɨbii takis kôên ngweo mɨla le teva, dɨ o lax ma la kɨsiinê xocbê môp wê xomxo baba mi vông ge lêm. Nge, xovô nêb i tɨbii nipaên om kɨtuu pɨkopac dɨ kɨtaa bêga ên nêbê, ‘O Anutu, ông xo vɨgwe pɨsiv ên a dɨ kɨtya a nêg nipaên vêl, ên a ga tɨbii nigpaên.’” ");
INSERT INTO ptp_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Om Yesu nêl ên nêbê, “A nêl vô xam bê tɨbii takis kôên ge Anutu kɨtya i nên nipaên vêl dɨ yê i nivɨha dɨ i lax mɨ la ben, dɨ Palisi ge Anutu o yê nivɨha lêm. Ên xomxo wê ob yong ici va ge, ge wê Anutu obêc vông i vô nipwo lec, dɨ xomxo wê vông ici vô nipwo lec ge, ge wê Anutu ob pɨmil i dɨ vông i lê vô levac.” ");
INSERT INTO ptp_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Xomxo kô nue nipwo mɨ la vô Yesu, ên nêb i vyax vɨgê lec he dɨ kɨtaa lec he, lêc Yesu nue ngɨvihi yê dɨ vô mya nipaên vô he. ");
INSERT INTO ptp_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Lêc Yesu keac nipwo lam dɨ nêl ên nêbê, “Vông nipwo i lam vô a dɨ xam o le vac he xôn lêm, ên xomxo tibêge wê ob la dô vac Anutu ben ge. ");
INSERT INTO ptp_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","A nêl hɨxôn nôn vô xam bê xomxo ti obêc vông i vin Anutu mɨ la vac i kwa ngɨbi tɨyi xocbê nipwo mi la vac tae mae kwa ngɨbi lêm ge od o tɨyi wê obêc la dô vac Anutu ben ge lêm.” ");
INSERT INTO ptp_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Xomxo levac ti kɨnêg vô Yesu ên nêbê, “Xolac kehe nivɨha, a obêc vông bêna êdêc dô magvɨha luta lêc luta?” ");
INSERT INTO ptp_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Lêc Yesu nêl vô i ên nêbê, “Bêna lêc ông nêb a nivɨha? Xomxo nivɨha ti o dô lêm. Anutu vaci nôn tibed wê nivɨha. ");
INSERT INTO ptp_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Ông xovô xolac wê Anutu nêl vô Moses ên nêbê, Ông o lêc vông môp yôdac vêx yuu vux lêm. Ông o lêc hi xomxo i yib lêm. Ông o lêc vun xomxo ngwe susu lêm. Ông o lêc nêl kɨyang kɨtyooên lec xomxo ti lêm. Ông loc vac tam yuu mam vya kwa ngɨbi.” ");
INSERT INTO ptp_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Om xomxo levac tyo nêl ên nêbê, “Buc wê a gên nipwo dɨ i val tyip gwêbaga, a viac xolac gee vɨhati mɨ vông i vô nôn lec.” ");
INSERT INTO ptp_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Yesu ngô tige, dɨ luu i vya ên nêbê, “Môp ti gên yêp wê ông ob vông hɨxôn bêga bê ông loc vông susu tɨbeac wê ông vông ge mɨ tɨbii i kɨsuu dɨ ông vông mone vô tɨbii wê nên susu maên ge, ên ông obêc kô susu nivɨha gê kɨsii ganê. Pyap dêc ông lôm tɨmu vô a vɨxag.” ");
INSERT INTO ptp_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Xomxo levac tyo ngô kɨyang ge lê, lêc kɨyang tige vông i nɨlô vô vɨyin levac, ên wê i mone levac ge. ");
INSERT INTO ptp_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Om Yesu yê i dɨ nêl ên nêbê, “Xomxo wê susu tɨbeac ge obêc nêb la vac Anutu ben ge od obêc vɨyin levac vô he. ");
INSERT INTO ptp_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Môp wê bwoc kamel ti obêc la vac yin kɨtu tocên ge, vɨyin levac lê, lêc xomxo susu tɨbeac obêc nêb la vac Anutu ben ge od obêc vɨyin levac luu vêl.” ");
INSERT INTO ptp_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Mêgem xomxo wê ngô kɨyang tige nêl ên nêbê, “Obêc tibêge ge od letya tɨyi wê ob la dô mavɨha ge?” ");
INSERT INTO ptp_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Lêc Yesu nêl ên nêbê, “Môp wê xomxo tɨyiên ma wê ob vông ge, ge Anutu ob vông.” ");
INSERT INTO ptp_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Mêd Pita nêl vô Yesu ên nêbê, “Wê lê. Xe ga wê xe sea susu wê xe vông ge vɨhati dô dɨ lam tɨmu vô ông vɨxam.” ");
INSERT INTO ptp_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Lêc Yesu nêl vô he ên nêbê, “Vɨxôhɨlôg, a ob nêl vô xam bê xomxo ti obêc sea ben hɨxôn vɨnêe nue dɨ tae mae lie lec Anutu xolac yuu ben ge ");
INSERT INTO ptp_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","od obêc kô myavɨwen nivɨha luu vêl gê kɨbun ga, dɨ buc tɨmuên ge od obêc la dô mavɨha luta lêc luta.” ");
INSERT INTO ptp_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Yesu kô nue ngɨvihi vɨgê yuu dɨ tô mɨ la yuu mɨ he la, dêc Yesu nêl vô he ên nêbê, “Xam ngô lê. Il ob la Jelusalem lê, lêc kɨyang vɨhati wê plopete kɨvuu lec Xomxo Nu ilage obêc vô nôn lec. ");
INSERT INTO ptp_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Om xomxo obêc vông i la vac tɨbii wê o Yuda lêm ge vɨgê, dêc tɨbii obêc vô mya nipaên vô i dɨ pɨsuv myaluc lec, ");
INSERT INTO ptp_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","dɨ pɨsa i ya yihi dêc hi i yib, dɨ buc yon obêc lam la vêl ge od ob kɨdi lec mavɨha nang.” ");
INSERT INTO ptp_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Mêgem nue ngɨvihi ngô kɨyang tyo lêc he lungên, ên kɨyang kehe o yêp seac vô he lêm om he vyac xovôên ma. ");
INSERT INTO ptp_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Yesu mɨla kwabo vô vɨgwe Jeliko, lêc xomxo ma tocên ti dô vô môp nɨnya dɨ kɨtaa susu vô tɨbii, ");
INSERT INTO ptp_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","lêc ngô kɨyang ngena ngena wê lam hɨxôn Yesu ge om kɨnêg vô xomxo ya ên nêbê, “Tɨbii vô nidɨdun ên va?” ");
INSERT INTO ptp_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Lêc xomxo nêl vô i ên nêbê, “Yesu Nasalet valê.” ");
INSERT INTO ptp_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Om xomxo ma tocên tyo tyuc ên nêbê, “Yesu, Devit nu, ông xo vɨgwe vô pɨsiv ên a.” ");
INSERT INTO ptp_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Lêc xomxo wê lam mug ge nêl ên nêbê, “Dô kɨyang maên.” Lêc ma tocên tyo tyuc ngɨnong ngɨnong hɨxôn vya levac ên nêbê, “Ông Devit nu, xo vɨgwe vô pɨsiv ên a.” ");
INSERT INTO ptp_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Mêgem Yesu val le dɨ nêl vô xomxo nêb he i kô xomxo ma tocên tyo mɨ lam vô i. Om he kô mɨ val dɨ val lax i le vô Yesu manôn dêc Yesu kɨnêg vô i ên nêbê, ");
INSERT INTO ptp_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Ông nêb a vông bêna vô ôngê?” Om xomxo tyo nêl ên nêbê, “A nêb ông vông a magnôn i seac.” ");
INSERT INTO ptp_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Om Yesu nêl vô i ên nêbê, “Mamnôn i seac. Vông vinên wê ông vông ge vông ông vô nimvɨha lec.” ");
INSERT INTO ptp_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Mêgem lutibed xomxo tyo manôn seac, dɨ i la hɨxôn Yesu dɨ pɨmil Anutu. Dɨ xomxo wê yê ge vɨhati pɨmil Anutu ên wê xomxo ma tocên tige manôn seac ge. ");
INSERT INTO ptp_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Yesu la vac vɨgwe Jeliko, ");
INSERT INTO ptp_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","dɨ xomxo ti lê nêbê Sakias dô vac vɨgwe tige. Sakias ge xomxo takis kôên nên levac dɨ i mone yuu susu tɨbeac. ");
INSERT INTO ptp_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Sakias nêb ob yê Yesu om la lêc tɨyiên ma, ên myabo om xomxo tɨbeac le vac i manôn xôn, ");
INSERT INTO ptp_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","om tup mɨ la mug vô môp wê Yesu ob lam vô ge dɨ mɨla lec xax ti ên nêb ob la dô ên yê Yesu wê i val ge. ");
INSERT INTO ptp_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Yesu mɨla vac xax kwa ngɨbi wê Sakias dô lec ge dɨ lax ma lec dɨ nêl vô Sakias ên nêbê, “Sakias, lop lutibed ên a ob dô hɨxôn ông vac ông bom gwêbaga.” ");
INSERT INTO ptp_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Mêgem Sakias lop lutibed dɨ kô Yesu mɨ la vac ben hɨxôn xêyaa nivɨha. ");
INSERT INTO ptp_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Tɨbii yê wê Yesu la dô vac Sakias ben ge om he ni nyag dɨ nêl ên nêbê, “Bêna lêc xomxo tiganê la dô vac tɨbii nipaên tiganê ben dɨ la dô hɨxôn?” ");
INSERT INTO ptp_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Mêlêc Sakias le vô he vɨhati manôn dɨ nêl vô Apumtau Yesu ên nêbê, “Apumtau, ngô lê. Susu vɨhati wê a vông ge a ob vông vɨwen i loc vô xomxo wê nên susu maên ge. Dɨ a obêc kɨtyoo xomxo ya dɨ vô he mone vêl ila ge od a ob vông he xe vac i luu vêl, xocbê a obêc kô xomxo ti mone kehe ti ge od a obêc vông kehe yuudɨyuu vô i nang.” ");
INSERT INTO ptp_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Mêgem Yesu nêl vô i ên nêbê, “Gwêbaga Anutu kɨtya xam xumac tiga nêm nipaên vêl dɨ xam tu Anutu nue, ên ông ge, ông Eblaham tɨvae ti êno. ");
INSERT INTO ptp_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Ên a, Xomxo Nu, a lam ên xomxo wê lung la vac nipaên ge, ên a nêb a ob hôm he lec ên he i dô nivɨha.” ");
INSERT INTO ptp_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","He ngô kɨyang ngwe ge vêl, nang dêc Yesu nêl kɨyang pɨlepacên ti vô he, ên he mɨla kwabo vô Jelusalem lêc tɨbii wê dɨloc hɨxôn i ge so ên nêb mêd he ob mɨla Jelusalem ge od Yesu ob tu Anutu manôn dɨ tu king, om Yesu nêb he i xovô buc tige bê gên yêp teva, ");
INSERT INTO ptp_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","om nêl kɨyang pɨlepacên bêga vô he ên nêbê, “Xomxo levac ti dô vac vɨgwe ti, lêc nêb ob la vac vɨgwe teva ngwe ên xomxo i vông i tu king ên lôm viac vɨgwe wê mi dô vac ge. ");
INSERT INTO ptp_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Om buc wê nêb ob la ge od nêl nue yuac vɨgê yuu ge lam vô i dɨ vông mone kɨpihac yuu yuu vô he toto dɨ nêl vô he ên nêbê, ‘Xam vông yuac lec mone tigae dɨ i loc tyip lec buc wê a obêc vena ge.’ ");
INSERT INTO ptp_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","“Mêd xomxo levac tyo loc mɨ la, lêc tɨbii vɨgwe tige xêyaa vô nipaên vô i, om vông lie ya tɨmu vô i vɨxa mɨ la, ên nêb he i loc nêl bê, ‘Xe nêb xomxo tiga ob tu king mɨ viac xe lêm.’ ");
INSERT INTO ptp_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Lêc xomxo tyo mɨla kô lê levac pyap dɨ lax mɨ la vac ben wê ob viac ge. Mêd nêl nue yuac wê vông mone vô he ge lam vô i, ên nêb ob xovô mone wê he vông yuac lec ge bêc he tulec ya hɨxônê? ");
INSERT INTO ptp_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","“Om xomxo ti wê val taxlee ge nêl vô i ên nêbê, ‘Xomxo levac, ông vông mone kɨpihac yuu vô a, lêc a vông yuac lec om a tulec yul yuu hɨxôn.’ ");
INSERT INTO ptp_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Om xomxo levac nêl vô xomxo tyo ên nêbê, ‘Ông ge xomxo nivɨha wê ông viac a yuac nivɨha ge. Ông kô mone nipwo tya lêc ông viac nivɨha, om a ob vông ông tu levac dɨ viac vɨgwe levac vɨgê yuu.’ ");
INSERT INTO ptp_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","“Nang dêc nu yuac ngwe wê vông yuu ge val nang dɨ nêl ên nêbê, ‘Xomxo levac, ông vông mone kɨpihac yuu vô a, lêc a vông yuac lec om a tulec yul ti hɨxôn.’ ");
INSERT INTO ptp_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Om xomxo levac tyo nêl vô i ên nêbê, ‘Nivɨha, om a ob vông ông tu levac dɨ viac vɨgwe levac vɨgê vɨlu.’ ");
INSERT INTO ptp_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Nang dêc nu yuac ti wê vông yon ge val nang dɨ nêl ên nêbê, ‘Xomxo levac, ga ông mone kɨpihac yuu wê ông vông vô a ge, om ông hôm ông xe. Ông mone ga a vɨyum vac nivɨmihi mɨ tung i dô, ");
INSERT INTO ptp_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","ên a xona ên ông, ên a xovô ên a nêbê ông ge xomxo myampɨlihi, ên susu wê xomxo ngwe ob tung ge od ông ob kô, dɨ yaên wê xomxo ngwe yev he xe ge od ông la mi kô nôn.’ ");
INSERT INTO ptp_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","“Lêc xomxo levac nêl vô i ên nêbê, ‘Ông ge xomxo nipaên. Ên kɨyang wê ông nêl ga hɨlung ông nêm nipaên, ên ông xovô ên ông nêbê a ga xomxo myagpɨlihi om susu wê xomxo ngwe tung i dô ge, a la mi kô, dɨ yaên wê xomxo ngwe yev he xe ge od a la mi kô nôn. ");
INSERT INTO ptp_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Ông xovô bêge lê, lêc bêna lêc ông o la lii mone wê a vông ge vac xumac mone êdêc buc wê a vena ge od a kô mone wê a vông ge dɨ kô wê dô lecên ge hɨxônê?’ ");
INSERT INTO ptp_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Mêgem xomxo levac nêl vô xomxo wê he xôn le ge ên nêbê, ‘Xam hôm mone kɨpihac yuu ge vêl ên xomxo tige vɨgê dɨ loc vông vô xomxo ngwe wê mone yul yuu ge.’ ");
INSERT INTO ptp_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Lêc he nêl ên nêbê, ‘Xomxo levac, xomxo ganê mone levac tɨyi yul yuu.’ ");
INSERT INTO ptp_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","“Lêc xomxo levac nêl ên nêbê, ‘A ob nêl vô xam bê xomxo wê he susu dô ge, he ob kô ya hɨxôn, dɨ xomxo wê susu ma ên he dɨ nipwo tya dô vô he ge od a ob vô vêl ên he. ");
INSERT INTO ptp_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Dɨ xomxo wê xêyaa vô nipaên vô a ên nêb a o tu king lêm ge, xam loc kô he mɨ lam dɨ hi he i yib lec a magnôn.’” ");
INSERT INTO ptp_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Yesu nêl bêge pyap dɨ loc mɨ la ên nêb ob la Jelusalem. ");
INSERT INTO ptp_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Mêd mɨla kwabo vô vɨgwe yuu lê nêbê Betpasi yuu Betani wê yêp kwabo vô kɨtôn Oliv ge. Mêd vông nu ngɨvihi yuu la, ");
INSERT INTO ptp_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","dɨ nêl vô yuu ên nêbê, “Muu loc vac vɨgwe tiganê, dɨ muu obêc mɨla wê donki wê gên ligên ge ti wê tɨbii vô yihi lec kwa dɨ i dɨle ge. Donki tige xomxo ti o dô lec ila lêm. Mêgem muu pɨwelac yihi vêl ên dɨ kô mɨ lam. ");
INSERT INTO ptp_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Lêc xomxo ti obêc kɨnêg muu bê, ‘Muu ob pɨwelac yihi tige vêl ên va?’ ge od muu nêl vô bê, ‘Apumtau nêb ob vông yuac lec.’” ");
INSERT INTO ptp_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Yuu la i tɨyi wê Yesu nêl ge dɨ mɨla tulec donki, ");
INSERT INTO ptp_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","om yuu pɨwelac yihi vêl ên, lêc xomxo wê he donki ge kɨnêg yuu ên nêbê, “Muu pɨwelac ge ên va?” ");
INSERT INTO ptp_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Lêc yuu nêl ên nêbê, “Apumtau nêb ob vông yuac lec.” ");
INSERT INTO ptp_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Mêd yuu kô donki tyo mɨ lax vô Yesu, dɨ he vax he ngakwi lec kɨsii dêc Yesu dô lec. ");
INSERT INTO ptp_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Yesu dô lec dɨ la vô môp, mêd xomxo ya vax he nivɨmihi lec môp wê Yesu ob tup vô ge i tɨyi xocbê môp wê tɨbii mi vông vô he king ge. ");
INSERT INTO ptp_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Mêd Yesu lop vô môp kɨtôn Oliv dɨ mɨla kwabo vô Jelusalem, lêc xomxo vɨhati wê mi tɨmu vô Yesu kɨyang ge, he pɨmil Anutu hɨxôn xêyaa nivɨha ên do levac wê Yesu vông mɨ he yê ge, ");
INSERT INTO ptp_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","dɨ he nêl levac la kɨsii ên nêbê, “Il ob hi vɨxad i pec ên il nêd king wê tu Anutu manôn dɨ lam ge. Kɨyang malehe yêp lag kɨsiinê, dɨ Anutu wê dô lag kɨsiinê, il ob vông i lê i vô levac.” ");
INSERT INTO ptp_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","He nêl bêge, lêc Palisi wê dô hɨxôn he ge, he ya nêl vô Yesu ên nêbê, “Xolac kehe, ông nêl vô nume bê he i dô kɨyang maên.” ");
INSERT INTO ptp_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Lêc Yesu nêl ên nêbê, “A ob nêl vô xam bê he obêc dô kɨyang maên ge od ngɨdax obêc tyuc dɨ pɨmil a nang.” ");
INSERT INTO ptp_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Mêd Yesu mɨla kwabo vô Jelusalem dêc yê ma la dɨ byag, ");
INSERT INTO ptp_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","dɨ nêl ên nêbê, “Gwêbaga xam obêc xovô môp wê xam ob dô vac malehe ge od obêc nivɨha. Lêc ga xam lungên, ên kɨyang ga yêp xôpacên om xam o xovô lêm. ");
INSERT INTO ptp_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Xam ngô lê. Obêc buc ti lêc tɨbii wê yê xam nipaên ge obêc val ku xenac kɨsuu xam xôn dɨ o tɨyi wê xam ti ob la ge lêm. ");
INSERT INTO ptp_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Dɨ he ob hi xam hɨxôn nume wê xam dô vac vɨgwe ga vɨhati vô nipaên, dɨ ngɨdax wê xam lox xumac ya ge, ngwe ob dô lec ngwe kɨsii lêm. Kehe bêga bê xam o xovô Anutu wê lam ên nêb ob hôm xam lec ge lêm.” ");
INSERT INTO ptp_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Yesu la vac Anutu xumac ngɨbua dɨ la tii tɨbii wê vông vɨtevac vac nɨlô ge la vêl, ");
INSERT INTO ptp_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","dɨ nêl vô he ên nêbê, “Xolac nêl bêga nêbê, ‘A xumac ga, xumac kɨtaa vacên,’ lêc xam vông i tɨyi xocbê xumac wê tɨbii yôdac ob kɨtucma vac ge.” ");
INSERT INTO ptp_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Yesu mi nêl xolac vac Anutu xumac ngɨbua tɨyi buc vɨhati. Mêd xomxo levac wê mi si daa gee dɨ xomxo wê xovô Moses xolac gee hɨxôn xomxo levac levac ya, he xôn nêb he ob hi Yesu i yib, ");
INSERT INTO ptp_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","lêc he o tulec môp ti wê he ob hi Yesu lec ge lêm, ên xomxo tɨbeac vô nɨnya vô kɨyang wê Yesu nêl ge dɨ o sea i lêm. ");
INSERT INTO ptp_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Buc ti lêc Yesu la vac Anutu xumac ngɨbua dɨ la nêl xolac vô tɨbii, dɨ xomxo levac wê mi si daa vô Anutu gee dɨ xomxo wê xovô Moses xolac gee hɨxôn he Yuda levac levac val vô Yesu, ");
INSERT INTO ptp_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","dɨ val kunac i ên nêbê, “Ông tu letya manôn dɨ lam vông môp tigaê? Letya nêb ông vông môp tibêgaê?” ");
INSERT INTO ptp_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Lêc Yesu nêl lax vô he ên nêbê, “A êno ob kɨnêg kɨyang ti vô xam. Om xam nêl vô a bê ");
INSERT INTO ptp_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","letya vông Jon la lipac xomxo? Ge Anutu lag kɨsiinê vông, me xomxo kɨbun ga vông?” ");
INSERT INTO ptp_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Om he nêl vôma bêga ên nêbê, “Il obêc nêl bê Anutu lag kɨsiinê vông ge od Yesu obêc nêl vô il bê, ‘Lêc bêna lêc xam o vông i vin kɨyang wê Jon nêl ge lêmê?’ ");
INSERT INTO ptp_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Lêc il ob nêl bê xomxo kɨbun ga vông Jon la yuac tige, od xomxo obêc nêx il ya ngɨdax, ên he vɨhati vông i vin ên he nêbê Jon ge plopet wê Anutu vông i la ge ti.” ");
INSERT INTO ptp_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Om he nêl vô Yesu ên nêbê, “Xe o xovô Jon Lipacên kehe lêm.” ");
INSERT INTO ptp_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Mêd Yesu nêl vô he ên nêbê, “Om a êno ga, a ob nêl xomxo ti wê vông a lam ge kɨtong vô xam lêm.” ");
INSERT INTO ptp_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Mêd Yesu nêl kɨyang pɨlepacên ti vô xomxo bêga ên nêbê, “Xomxo ti xin wain vac i yuac ti, dɨ vông vô tɨbii ya nêb he i viac, ên nêb ob la vɨgwe teva ti dɨ la dô buc xuhu dia. ");
INSERT INTO ptp_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Mêgem loc mɨ la dô mêd buc wê wain ob huu ge om vông nu yuac ti lax mɨ la vô tɨbii wê dɨviac i yuac ge ên nêbê i loc kô i wain nôn ya, om xomxo tyo mɨla lêc xomxo wê viacên wain ge hi i dɨ vông i lax mɨ la pɨleva. ");
INSERT INTO ptp_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Nang dêc xomxo ti wê i yuac ge vông nu yuac ngwe lax vô he nang, lêc tɨbii yuac viacên pɨsa i dɨ vô mya nipaên vô i dɨ vông i lax mɨ la pɨleva. ");
INSERT INTO ptp_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Nang dêc xomxo levac tige vông nu yuac ti wê vông yon ge la nang, lêc he hi i vô nipaên dɨ nêx i la nɨnya. ");
INSERT INTO ptp_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Om xomxo ti wê i yuac ge xo bêga ên nêbê, ‘A ob vô va? Ga a ob vông a nug tuc wê a xêgyaa vin lec i ge i loc vô he, ên mêd he ob yê i xocbê xomxo levac dɨ la vac kɨyang wê i vông ge kwa ngɨbi.’ ");
INSERT INTO ptp_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Lêc xomxo wê viac i yuac ge yê wê xomxo levac tyo nu mɨla ge om he nêl vôma ên nêbê, ‘Xomxo ti wê ma obêc nêl i lê lec yuac ga ge val, om il ob hi i yib êdêc yuac ga i tu il xe.’ ");
INSERT INTO ptp_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Om he hôm i xôn dɨ kô mɨ la vô yuac nɨnya dɨ hi i yib. Om a ob kɨnêg vô xam bê xomxo ti wê i yuac ge obêc vô va vô he? ");
INSERT INTO ptp_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Ge obêc hi xomxo tigee yib dɨ vông i yuac vô xomxo baba mɨ he i viac nang.” Xomxo wê ngô kɨyang tige nêl ên nêbê, “Le i lêc vông tibêge lêm.” ");
INSERT INTO ptp_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Mêd Yesu yê he dɨ nêl ên nêbê, “Xam nêbê môp bêge i ma, mêlêc kɨyang wê plopete kɨvuu ilage, kehe bêna? Ên plopete ilage kɨvuu kɨyang mɨ i yêp bêga ên nêbê, ‘Ngɨdax ti wê xomxo xumac loxên yê lêc nêb tɨyiên ma ge, ge wê tu ngɨdax xêkɨzêc wê ob hôm xumac xôn ge.’ ");
INSERT INTO ptp_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","A ob nêl vô xam bê xomxo ti obêc tô mɨ hi i lec ngɨdax tige ge od ob hi i len vô pɨpu sea, dɨ ngɨdax tige obêc tô mɨ hi xomxo ti ge od obêc hi i pɨtal sea.” ");
INSERT INTO ptp_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Yesu nêl bêge dêc xomxo wê xovô Moses xolac gee hɨxôn xomxo levac wê mi si daa gee, he xovô ên he nêbê Yesu nêl kɨyang pɨlepacên tige lec he, om he nêb he ob hôm Yesu xôn lutibed, lêc he xona ên wê xomxo tɨbeac ge. ");
INSERT INTO ptp_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Mêd xomxo wê xovô Moses xolac gee hɨxôn xomxo levac wê mi si daa gee yê Yesu xôn dɨ vông xomxo ya la vô i ên nêb he i yê i xôn dɨ yaxên i kɨyang bêc obêc nêl ti so ge od he ob vông i loc vac gavman vɨgê dɨ vông kɨyang vô. Xomxo tigee kɨtyoo nêb he xomxo nivɨha, ");
INSERT INTO ptp_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","om la kɨnêg vô Yesu ên nêbê, “Xolac kehe, xe xovô ên xe nêbê xolac wê ông nêl vô xomxo ge, ông nêl bôbac dɨ nivɨha, dɨ ông o xona ên xomxo ti lêm. Nge, ông mi nêl Anutu kɨyang hɨxôn nôn vô xomxo vɨhati tɨyima. ");
INSERT INTO ptp_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Om xe ob kɨnêg vô ông bê tɨyi wê il Yuda ob vông mone takis vô king Sisa wê tɨbii madɨluhu ge, me il ob vông lêm?” ");
INSERT INTO ptp_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Lêc Yesu xovô kɨyang kɨtyooên wê yêp vac he nɨlô ge om nêl vô he ên nêbê, ");
INSERT INTO ptp_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Xam hɨlung mone ti mɨ a xê. Letya kɨnu yuu lê wê yêp lec mone ga?” Om he nêl ên nêbê, “Sisa kɨnu yuu lê.” ");
INSERT INTO ptp_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Mêgem Yesu nêl vô he ên nêbê, “Mêgem susu wê Sisa xe ge, xam vông i loc vô Sisa, dɨ susu wê Anutu xe ge, xam vông i loc vô Anutu.” ");
INSERT INTO ptp_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Mêd he o tɨyi wê he ob kɨtyoo Yesu ên i nêl kɨyang ya so lec xomxo manôn ge lêm, ên he yetac ên kɨyang wê Yesu nêl lax vô he ge om he dô kɨyang maên. ");
INSERT INTO ptp_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Xomxo Sadyusi ya val vô Yesu. He Sadyusi ge, he o vông i vin bê xomxo ob kɨdi lec vac yibên lêm. ");
INSERT INTO ptp_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Om he la nêl vô Yesu ên nêbê, “Xolac kehe, Moses xolac nêl bêga vô il ên nêbê xomxo ti obêc kô vêx ti lêc nu ma dɨ i yib dɨ vɨnê gên dô ge od vux tyo lie ti ob ii vêx tyo nang êdêc vông nue, dɨ nue i tu susu wê ma yibên vông ge kehe. Moses xolac nêl bêge. ");
INSERT INTO ptp_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Om wê vux vɨgê vɨlu dɨ sec yuu ob dô lec ta yuu ma tibed, mêdêc li tuc obêc kô vêx ti lêc yib dɨ nu ma ge, ");
INSERT INTO ptp_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","31","od li môn ob ii vêx tige i tii vac nang, lêc wê obêc yib dɨ nu ma ge od li gwaa ob ii nang, lêc wê li gwaa obêc yib ge od lie tɨmuên vɨhati ob tɨmu vô môp tibed ge dɨ ii vêx tige, lêc wê vɨhati obêc yib dɨ nue ma, ");
INSERT INTO ptp_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","dêc vêx tyo obêc yib tɨmuên ge. ");
INSERT INTO ptp_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Xam nêl ên xam nêbê xomxo obêc kɨdi lec vac yibên om xe nêb xe ob kɨnêg vô ông bê buc wê xomxo yibên obêc kɨdi lec ge, od vêx tige obêc tu vux tina vɨnê? Ên vux vɨgê vɨlu dɨ sec yuu, he xôn ii vêx tige lec buc wê he dô mavɨha ge.” ");
INSERT INTO ptp_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Mêgem Yesu nêl vô he ên nêbê, “Xomxo wê dô gwêbaga ge, he iima. ");
INSERT INTO ptp_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Lêc xomxo wê Anutu nêb he nivɨha tɨyi wê ob kɨdi lec vac yibên dɨ la dô mavɨha tɨmuên ge, he ob iima vô buc tɨmuên lêm. ");
INSERT INTO ptp_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Ên he obêc yib i tii vac nang lêm. Nge, he ob dô tɨyi xocbê angela ge, ên he kɨdi lec vac yibên dɨ he tu Anutu nue. ");
INSERT INTO ptp_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","“Moses kɨyang nêl kɨtong êno ên nêbê xomxo yibên obêc kɨdi lec i tii vac nang. Ge yêp seac vac kɨyang wê Moses kɨvuu lec xax wê ngwax dɨtum lec ge bêga ên nêbê, ‘Apumtau Anutu ge Eblaham yuu Aisak yon Jekop Anutu wê yon mi kɨtaa vô ge.’ ");
INSERT INTO ptp_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Yon yib tax dêc Moses kɨvuu kɨyang tige tɨmuên, lêc Moses kɨvuu i tɨyi xocbê yon xeedô ge. Om il ob xovô bê Anutu o tu xomxo yibên nên Anutu lêm. Nge, Anutu tu xomxo mavɨha nên Anutu, ên xomxo wê mavɨha hɨxôn he wê yibên ge, Anutu yê he vɨhati xocbê he dô mavɨha ge.” ");
INSERT INTO ptp_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Yesu nêl bêge dêc xomxo wê xovô Moses xolac gee, he ya nêl ên nêbê, “Xolac kehe, ông nêl ge bôbac la tɨyi.” ");
INSERT INTO ptp_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","He nêl bêge, ên he xona om he nêb he ob kɨnêg kɨyang i tii vac vô Yesu lêm. ");
INSERT INTO ptp_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Lêc Yesu nêl vô he ên nêbê, “Bêna lêc xomxo ya nêl ên nêbê Kɨlisi wê Anutu nêb ob vông i lam ge, ge Devit nu? ");
INSERT INTO ptp_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Ên Devit vaci kɨvuu vac kɨpihac Sam bêga ên nêbê, ‘Apumtau Anutu nêl vô a Apumtau ên nêbê, Ông dô vô a vɨgêg hɨyôv, ");
INSERT INTO ptp_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","dɨ a obêc vông tɨbii wê vông vevac vô ông ge he i dô vac ông vɨgêm vɨlu kwa ngɨbi.’ ");
INSERT INTO ptp_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Devit nêl ên nêbê Kɨlisi ge Apumtau, om bêna lêc xomxo nêl ên nêbê Kɨlisi ge Devit bue tɨmuên ti?” ");
INSERT INTO ptp_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Xomxo tɨbeac dô om he ngô kɨyang wê Yesu nêl vô nue ngɨvihi bêga ên nêbê, ");
INSERT INTO ptp_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Xam viac xam ên môp nipaên wê xomxo wê xovô Moses xolac gee mi vông ge. Ên he xêyaa vin lec môp wê he ob vɨnyum ngakwi dia nivɨha dɨ la vɨlee vac maket ên he nêb xomxo i yê he dɨ pɨmil he ya kɨyang malehe, dɨ he obêc la vac xumac lɨlo, me he ob la ya vɨzid levac ge od he nêb he ob dô lec sia nivɨha wê xomxo levac mi dô lec ge. ");
INSERT INTO ptp_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Lêc he ge wê he mi vô xomxo vêxôv nên susu yuu xumac vêl ge, dɨ buc wê he ob kɨtaa ge od he mi vɨyum nên nipaên vac kɨtaaên dia. Om myavɨwen nipaên wê he ob kô ge obêc levac mabu yocên luu vêl.” ");
INSERT INTO ptp_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Yesu dô dɨ yê wê tɨbii wê mone levac gee lam tung mone vac kɨlong wê tɨbii mi tung mone daa vac ge. ");
INSERT INTO ptp_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Mêd yê wê vêxôv wê mone ma ge ti val tung mone hi yuu tya vac kɨlong tyo. ");
INSERT INTO ptp_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Mêgem Yesu nêl ên nêbê, “A ob nêl hɨxôn nôn vô xam bê mone yuutyabed wê vêxôv tiganê tung vac kɨlong ge ngɨnoo daa wê xomxo baba tung ge vêl. ");
INSERT INTO ptp_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Ên he mone tɨbeac dô lê, lêc he vông nipwo tya dɨ he xe levac dô, dom vêx tiganê ge i nên mone ma dɨ hi yuu tya, lêc vông vɨhati tu daa, dɨ ti o dô wê ob kɨsuu xen yaên lec ge lêm.” ");
INSERT INTO ptp_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Xomxo ya nêl kɨyang lec Anutu xumac ngɨbua ên nêbê, “Xumac tiga, tɨbii lox ya ngɨdax nivɨhavɨha dɨ vunac vô ya susu nivɨhavɨha.” Lêc Yesu nêl vô he ên nêbê, ");
INSERT INTO ptp_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Susu wê xam wê ga, obêc buc tɨmuên ge od ngɨdax tigae ob dii sea, dɨ ngwe ob dô lec ngwe kɨsii lêm.” ");
INSERT INTO ptp_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Mêd he kɨnêg vô Yesu ên nêbê, “Xolac kehe, kɨyang tige obêc vô nôn lec yelacna? Dɨ do vatya obêc val tax ên xe xê dɨ xovô bê susu tige ob vô nôn lecê?” ");
INSERT INTO ptp_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Mêgem Yesu nêl ên nêbê, “Xam viac xam nivɨha êdêc tɨbii i o lêc kɨtyoo xam lêm. Ên xomxo tɨbeac obêc val kɨtyoo xam dɨ nêl a lêg dɨ nêl bê he Kɨlisi, dɨ nêl bê buc vô kwabo lec. Lêc xam o lêc vông i vin he vya dɨ tɨmu vô he lêm. ");
INSERT INTO ptp_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Dɨ xam obêc ngô kɨyang wê nêbê vevac tyip vac vɨgwe ya mɨ xomxo hima ge, od le i lêc yetac dɨ xona lêm. Ên vevac tige obêc val tax, lêc buc myahɨpu gên yêp dia.” ");
INSERT INTO ptp_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Nang dêc Yesu nêl vô he ên nêbê, “Vô buc tige tɨbii vɨyang ngwe ob vông vevac vô vɨyang ngwe, dɨ tɨbii vɨyang vɨyang ob dô kɨdu kɨdu dɨ vông vevac vôma. ");
INSERT INTO ptp_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Vac vɨgwe vɨyang vɨyang ge ngɨyêg ob yoc levac dɨ vip levac ob den xomxo dɨ yidac levac ob vông he. Dɨ do levac ya ob lam gê lag kɨsiinê dɨ vông xomxo xona mabu. ");
INSERT INTO ptp_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Vô buc wê susu tigee valên gên ma ge, od tɨbii obêc hôm xam xôn dɨ vông vɨyin levac vô xam, dɨ vông kɨyang vô xam vac xumac lɨlo wê Yuda vông ge dɨ tung xam la vac kalabuhu. He ob nêb vông a lêg i vô nipaên, mêgem he obêc kô xam mɨ la dɨ vông xam le vô king yuu gavman levac manôn dɨ vông kɨyang vô xam. ");
INSERT INTO ptp_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Lêc buc tige wê xam ob nêl a xolac kɨtong vô he, ");
INSERT INTO ptp_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","om le i lêc xo kɨyang wê xam ob nêl lax vô he ge lêm. ");
INSERT INTO ptp_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Ên a obêc vông xam pɨyôp yêp seac dɨ xam nêl kɨyang nivɨha, om he wê nêb ob vông vevac vô xam ge, he o tɨyi wê he ob pwoo kɨyang wê a nêl vô xam ge vac lêm. ");
INSERT INTO ptp_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","“Mêd xacxam va tame mame lime ngɨdême hɨxôn xam nimpɨpu, heche va obêc vông xam vac tɨbii vevac vɨgê dɨ he obêc hi xam ya wib. ");
INSERT INTO ptp_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Dɨ xomxo vɨhati xêyaa obêc vô nipaên nôn vô xam ên wê xam vông i vin a lêg ge. ");
INSERT INTO ptp_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Lêc xam obêc dô nimvɨha dɨ bamzub lihi ti tya obêc pul vêl lêm. ");
INSERT INTO ptp_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Om xam le xêkɨzêc êdêc dô mamvɨha tɨmuên. ");
INSERT INTO ptp_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Buc wê tɨbii vevac obêc lam buu vɨgwe Jelusalem xôn ge od xam xovô bê buc wê vɨgwe ob vô nipaên ge vô kwabo lec. ");
INSERT INTO ptp_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Om buc tige, xomxo wê dô vac vɨgwe Judia ge, he i pec mɨ loc lec vɨgwe kɨtôn, dɨ he wê dô vac vɨgwe Jelusalem ge, he i pec mɨ loc vêl, dɨ he wê dô Jelusalem nɨnya ge, he i o lêc dɨlôc vac vɨgwe Jelusalem lêm. ");
INSERT INTO ptp_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Ên buc tige wê Anutu ob vông myavɨwen nipaên vô xomxo Yuda i tɨyi kɨyang wê plopete kɨvuu ilage, om kɨyang gee vɨhati obêc vô nôn lec. ");
INSERT INTO ptp_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Om vêx wê nu dô vac xêyaa hɨxôn vêx wê dɨvông lul vô nue vô buc tige, he ob dô vac vɨyin levac. Ên xomxo kɨbun ga ob dô vac vɨyin levac dɨ xêyaa myavɨnê wê Anutu vông ge ob tulec he Yuda vɨhati. ");
INSERT INTO ptp_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Mêd tɨbii ob hi he ya yib ya yipac dɨ ku he ya xôn dɨ kô he mɨ la vac tɨbii ba ben dɨ he la dô dɨ vông yuac kalabuhu. Dɨ tɨbii wê o Yuda lêm ge ob vông vɨgwe Jelusalem vô nipaên dɨ heche va ob tu kehe dɨ viac i tɨyi buc wê Anutu nêl ge. ");
INSERT INTO ptp_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Mêd do toto ob val vac hɨyôv yuu dentuc dɨ pɨtua gê lag kɨsiinê, dɨ xomxo kɨbun ga vɨhati nɨlô ob vô vɨyin levac dɨ he ob xona ên mia gwec wê vuac dɨ vô dɨdun levac ge. ");
INSERT INTO ptp_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Dɨ pɨtua yuu susu wê lag ge ob yetac dɨ sea vɨgwe wê le lec ge dɨ la, om xomxo ob yê dɨ xovô susu nipaên wê ob val kɨbun ge om he ob xona mabu dɨ vɨxog mɨ la kɨbun. ");
INSERT INTO ptp_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","28","Mêd buc wê susu tigee obêc val ge, od xam nɨlôm i vô vɨyin maên dɨ xam wê mam i loc kɨsii, ên buc wê Anutu ob vô xam vêl ên vɨyin yuu nipaên ge vô kwabo lec. Mêd ge wê a, Xomxo Nu, a ob lam vac vɨyobtoc hɨxôn xêkɨzêc yuu xêseac dɨ lam kɨbun, dɨ xomxo vɨhati ob yê wê a val ge.” ");
INSERT INTO ptp_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Mêd Yesu nêl kɨyang pɨlepacên ti vô he ên nêbê, “Xam xovô xax wê ob pwoc lihi ge. ");
INSERT INTO ptp_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Ên xax lihi obêc pwoc lec ge od xam xovô ên xam nêbê ge buc wê hɨyôv ob linac nivɨha ge. ");
INSERT INTO ptp_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Mêgem xam xovô bêga bê môp wê xam ob xovô Anutu buc ge, tɨyi bêge êno. Om xam obêc wê do tigee wê val ge od xam xovô bê buc wê Anutu ob tu king dɨ vông xomxo vɨhati la vac i kwa ngɨbi ge vô kwabo lec. ");
INSERT INTO ptp_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“A nêl hɨxôn nôn vô xam bêga bê xomxo wê dô gwêbaga ge obêc dô dɨ kɨyang tigee vɨhati obêc vô nôn lec lê. ");
INSERT INTO ptp_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Lag yuu kɨbun xôa obêc ma, lêc kɨyang wê a vông ge, bo ti obêc la xôa ma lêm. ");
INSERT INTO ptp_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Xam viac xam nivɨha, dɨ le i lêc num mɨ vô mavmav lêm, dɨ xam o lêc xo kɨyang tɨbeac lec susu wê nimnɨvi xe ge dɨ nɨlôm i vô vɨyin lec lêm, ên xam obêc viac xam nivɨha lêm ge od Xomxo Nu obêc lop mɨ lôm lutibed ge od xam ob lungên, tɨyi xocbê pulac wê lɨlii lungên om mɨla mô, lêc vac ge. ");
INSERT INTO ptp_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Ên buc tige obêc val vô xomxo wê dô lec kɨbun ga vɨhati yang. ");
INSERT INTO ptp_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Om xam viac xam i tɨyi buc vɨhati, dɨ xam kɨtaa vô Anutu bê i vông xêkɨzêc vô xam i tɨyi wê xam ob le xêkɨzêc dɨ kɨlê vɨyin wê ob tulec xam ge êdêc le nivɨha vô Xomxo Nu manôn wê obêc vena ge.” ");
INSERT INTO ptp_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Mêd Yesu la mi nêl xolac vac Anutu xumac ngɨbua tɨyi vɨdiiên vɨhati, dɨ bucên ge mi sea Jelusalem dɨ la mi yêp lec kɨtôn Oliv. ");
INSERT INTO ptp_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Mêdêc pɨtoc yang ge xomxo tɨbeac mi kɨdi mɨ la vac Anutu xumac ngɨbua ên nêb ob la ngô Yesu kɨyang wê nêl ge. ");
INSERT INTO ptp_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Buc wê tɨbii Yuda ob myêl levac dɨ ya blet xêkɨzêc wê yis maên ge ên xovô buc Pasova ge vô kwabo lec. ");
INSERT INTO ptp_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Mêd xomxo levac wê mi si daa gee hɨxôn xomxo wê xovô Moses xolac gee he nêb he ob hi Yesu i yib, lêc he xona ên xomxo tɨbeac, om he myag môp wê he ob hôm i xôn ge. ");
INSERT INTO ptp_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Judas Iskaliot ge Yesu nue ngɨvihi ti lê, lêc Seten la vac i nɨlô. ");
INSERT INTO ptp_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Om Judas loc mɨ la vô xomxo levac wê mi si daa gee hɨxôn xêhɨpu levac wê mi viac Anutu xumac ngɨbua gee, dɨ he keac lec môp wê Judas ob vông Yesu vac he vɨgê ge. ");
INSERT INTO ptp_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Om xomxo levac tigee nɨlô vô nivɨha dɨ he nêb wê Judas ob vông Yesu vac he vɨgê ge od he ob vông mone vô i. ");
INSERT INTO ptp_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Mêgem Judas tyuc lec, mêd myag môp wê ob hôm Yesu xôn ge, lêc xovô wê xomxo tɨbeac mi dô hɨxôn Yesu ge om dô bin buc wê Yesu vaci obêc dô tamaên dɨ xomxo ma ge lê. ");
INSERT INTO ptp_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Buc wê tɨbii Yuda ob ya blet xêkɨzêc dɨ hi bwoc sipsip mɨ ya ên xovô buc Pasova ge, ");
INSERT INTO ptp_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","om Yesu nêl vô Pita yuu Jon ên nêbê, “Ga buc Pasova om muu loc myêl vɨzid ên il ob xa.” ");
INSERT INTO ptp_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Om yuu kɨnêg vô i ên nêbê, “Ông nêb xii la myêl vac xumac tina?” ");
INSERT INTO ptp_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Mêgem Yesu nêl vô yuu ên nêbê, “Muu ngô lê. Muu loc vac vɨgwe Jelusalem dɨ muu obêc wê wê xomxo ti dɨkɨlê mia mɨ la ge, od muu tɨmu vô xomxo tige vɨxa dɨ loc vac xumac wê xomxo tyo ob la vac ge, ");
INSERT INTO ptp_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","dɨ nêl vô xomxo ti wê i xumac ge bê, ‘Xolac kehe nêb xii lam kɨnêg vô ông bê xumac nɨlô tina wê i hɨxôn nue ngɨvihi ob ya vɨzid vac ge?’ ");
INSERT INTO ptp_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Muu obêc kɨnêg bêge vô i ge od obêc hɨlung xumac nɨlô levac ti wê yêp kɨsii ge vô muu. Susu wê il ob dô lec ge le vac xumac tige pyap, om muu loc myêl vɨzid wê il ob xa ge vac.” ");
INSERT INTO ptp_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Mêgem Pita yuu Jon loc mɨ la, dɨ mɨla yê i tɨyi wê Yesu nêl ge, mêgem yuu la myêl yaên wê he ob ya ge. ");
INSERT INTO ptp_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Buc wê he ob ya vɨzid ge om Yesu hɨxôn nue ngɨvihi, he xôn dô dɨ ya. ");
INSERT INTO ptp_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Mêd Yesu nêl vô he ên nêbê, “A xovô ên a nêbê a obêc kô myavɨnê levac om a nɨlôg kɨdu a ên a nêb a ob xa vɨzid tiga hɨxôn xam tax lê dêc kô myavɨnê tɨmuên. ");
INSERT INTO ptp_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","A nêl vô xam bêga bê a ob xa vɨzid tiga i tii vac lêm dɨ i loc tyip vô buc wê vɨzid tiga obêc vô nôn lec vac Anutu ben.” ");
INSERT INTO ptp_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Mêd Yesu hôm kap ti dɨ kɨtaa vô Anutu dɨ nêl vô he ên nêbê, “Xam hôm dɨ tɨtang vôma. ");
INSERT INTO ptp_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","A ob nêl vô xam bê a obêc num wain bêga i tii vac lêm dɨ i mɨloc vô buc wê a ob num mia vac Anutu ben ge.” ");
INSERT INTO ptp_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Nang dêc Yesu hôm blet ti dɨ kɨtaa lec mêd hɨbu dɨ vông vô he titi dɨ nêl ên nêbê, “Ga a nignɨvi wê a vông ên a nêb i ngɨdu xam xôn ge. Xam tɨmu vô môp bêga dɨ xovô a.” ");
INSERT INTO ptp_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","He ya pyap mêd Yesu vông bêge vô kap wain êno, dɨ nêl ên nêbê, “Mia wain ga a hi wê a ob kɨpyax sea ên xam ge. Mêgem kɨyang paha wê Anutu hɨlu ge, a obêc vông i vô nôn lec ya a hi. ");
INSERT INTO ptp_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","“Xam wê lê. Xomxo ti wê ob vông a vac tɨbii vevac vɨgê ge xeedô dɨ ya hɨxôn a lec tevol tiga. ");
INSERT INTO ptp_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","A, Xomxo Nu, a ob xib i tɨyi xocbê kɨyang wê Anutu nêl pyap ge lê, lêc xomxo ti wê ob vông a la vac he vɨgê ge obêc kô myavɨwen levac lec tɨmuên.” ");
INSERT INTO ptp_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Yesu nêl bêge pyap, mêd nue ngɨvihi nêl vôma ên nêbê, “Om il tina wê il obêc vông môp tibêge?” ");
INSERT INTO ptp_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Mêd Yesu nue ngɨvihi ngaênma ên nêb mêd he tina obêc tu levac i luu he baba vêl. ");
INSERT INTO ptp_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Lêc Yesu nêl vô he ên nêbê, “King kɨbun ga môp wê nêb tɨbii vɨyang vɨyang ge i loc vac he kwa ngɨbi, dɨ tɨbii wê tu levac ge nêb xomxo wê pɨleva ge i pɨmil he ên yuac wê he vông ge. ");
INSERT INTO ptp_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Lêc xam o lêc tɨmu vô môp bêge lêm. Nge, xam wê xam kô lêm levac ge, xam dô i tɨyi xomxo wê lê maên ge, dɨ xam wê xam tu levac ge, xam dô i tɨyi xocbê xomxo wê mi vông yuac vô xam ge. ");
INSERT INTO ptp_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","A ob kɨnêg xam bê xomxo ngwe na wê levac ge? Ge xomxo ngwe wê dô dɨ ya ge, me i nu yuac ngwe wê myêl i xen yaên dɨ kô mɨ lam ge? Ge xam xovô ên xam nêbê ge xomxo ngwe wê dô mɨ ya ge. Lêc a ga, a lam dô hɨxôn xam tɨyi xocbê xam num yuac ti. ");
INSERT INTO ptp_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Vɨyin tɨbeac tulec a, lêc xam o sea a lêm. Nge, xam kɨlê vɨyin hɨxôn a. ");
INSERT INTO ptp_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Mag Anutu nêb a tu king dɨ kô lêg levac, om a ob vông xam tu king dɨ kô lêm levac hɨxôn a êno bêge, ");
INSERT INTO ptp_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","om buc wê a ob tu king ge od xam ob dô hɨxôn a dɨ il xôn ob xa dɨ num, dɨ xam obêc dô lec sia king dɨ yaxên lime Islel wê xam hɨpu vɨgê yuu dɨ tô mɨ la yuu ge nên kɨyang.” ");
INSERT INTO ptp_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Yesu nêl vô Saimon Pita ên nêbê, “Saimon, ngô lê. Seten nêl ên nêbê ob yaxên xam, om Anutu tyuc lec ên nêb i yaxên. ");
INSERT INTO ptp_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Lêc a kɨtaa vô Anutu lec ông ên a nêbê ông o lêc sea vông vinên lêm. Dɨ buc wê ông ob pɨlepac ông mɨ lax vô Anutu ge od ông ngɨdu lime nên vông vinên xôn.” ");
INSERT INTO ptp_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Lêc Pita nêl vô i ên nêbê, “Apumtau, a obêc loc hɨxôn ông. Wê tɨbii ob vông ông la vac kalabuhu me hi ông wib ge, od a ob kô myavɨnê hɨxôn ông.” ");
INSERT INTO ptp_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Lêc Yesu nêl vô i ên nêbê, “Pita, a ob nêl vô ông bê vô bucên tya ga kokɨlêx vôên vya obêc gên ma dɨ ông ob yax a vun lu yon bê ông lungên a.” ");
INSERT INTO ptp_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Yesu nêl vô nue ngɨvihi ên nêbê, “Buc ilage wê a vông xam la vac yuac ge od a nêb xam kôên vɨxec yuu mone dɨ su i ma. Om a ob kɨnêg vô xam bê susu ya mi ma ên xam vô buc ya, me?” Lêc he nêl ên nêbê, “Maê, susu ti o ma ên xe buc ti lêm.” ");
INSERT INTO ptp_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Mêd Yesu nêl ên nêbê, “Dom gwêbaga, xomxo ob viac xam lêm, om xam vɨxec mone obêc dô ge, od xam kô hɨxôn mɨ loc. Dɨ vɨxec êno bêge. Dɨ xam ti yipac obêc ma ge od xam vông nêm kolsiot ên tɨbii i kɨsuu dɨ xam kô mone mɨ loc kɨsuu yipac lec. ");
INSERT INTO ptp_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","A nêl bêga vô xam, ên vɨyin obêc val i tɨyi kɨyang wê yêp vac xolac bêga ên nêbê, ‘Xomxo nêl nêb i ge tɨbii nipaên.’ Om a ob nêl vô xam bê kɨyang tiga obêc vô nôn lec vô a, ên kɨyang vɨhati wê he kɨvuu lec a ilage obêc vô nôn lec.” ");
INSERT INTO ptp_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Om he nêl vô Yesu ên nêbê, “Apumtau, wê. Yipac yuu yêp ga.” Mêd Yesu nêl ên nêbê, “Ge pyap.” ");
INSERT INTO ptp_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Pyap dêc Yesu sea Jelusalem dɨ la lec kɨtôn Oliv tɨyi xocbê mi vông ge, mêd nue ngɨvihi tɨmu vô i vɨxa mɨ he la. ");
INSERT INTO ptp_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Mêd he mɨla vɨgwe tige om Yesu nêl vô he ên nêbê, “Xam dô dɨ kɨtaa êdêc vɨyin wê ob yaxên xam ge i o lêc vông xam tô lêm.” ");
INSERT INTO ptp_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Mêd Yesu sea he dɨ la teva tya tɨyi xocbê xomxo ti ob nêx ngɨdax la tô ge, dêc la yev vɨxa kɨtu vac dɨ kɨtaa bêga ên nêbê, ");
INSERT INTO ptp_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“O Mag, ông obêc tyuc lec ge od ông vô vɨyin tiga vêl ên a. Lêc ông o lêc vông i tɨyi wê a nêb ông vông ge lêm. Nge, ông vông i tɨyi wê ôcông va xovô ge.” ");
INSERT INTO ptp_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Mêd angela ti lam gê kɨsiinê dɨ lam ngɨdu i xôn. ");
INSERT INTO ptp_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Yesu nɨlô vô vɨyin levac dɨ i kɨtaa xêkɨzêc dɨ nivɨnê tyip tɨyi xocbê hi ge dɨ yuc la kɨbun. ");
INSERT INTO ptp_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Yesu kɨtaa pyap dɨ kɨdi mɨ lax vô nue ngɨvihi, lêc yê wê he nɨlô vô vɨyin levac om he yêp. ");
INSERT INTO ptp_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Mêgem Yesu nêl vô he ên nêbê, “Bêna lêc xam dɨwêpê? Xam kɨdi lec dɨ kɨtaa êdêc vɨyin wê ob yaxên xam ge i o lêc vông xam tô lêm.” ");
INSERT INTO ptp_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Yesu gên dɨnêl kɨyang tige dɨ xomxo tɨbeac val mɨ lam. Judas wê Yesu nue ngɨvihi vɨgê yuu dɨ tô mɨ la yuu ge ti kô tɨbii mɨ he lam, dêc Judas val le hɨxôn Yesu ên nêb ob nga lia, ");
INSERT INTO ptp_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","lêc Yesu nêl vô i ên nêbê, “Judas, bêna lêc ông nga Xomxo Nu lia ên ông nêb tɨbii i lam hôm i xôn?” ");
INSERT INTO ptp_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Yesu nue ngɨvihi yê wê tɨbii tigee nêb ob hôm i xôn ge om he kɨnêg vô i ên nêbê, “Apumtau, ông nêb xe hi he ya yipac, me?” ");
INSERT INTO ptp_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Lêc lutibed nu ngɨvihi ti hôm yipac dɨ sap xomxo levac wê mi si daa ge nu yuac ti nɨnya lihi vɨlu hɨyôv vêl. ");
INSERT INTO ptp_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Lêc Yesu nêl ên nêbê, “Môp bêge i ma.” Mêd vyax vɨgê lec xomxo tige nɨnya dɨ i vô nivɨha lec. ");
INSERT INTO ptp_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Mêd xomxo wê lam ên nêb ob lam hôm Yesu xôn ge, ge he xomxo levac wê mi si daa gee dɨ xêhɨpu levac wê mi viac Anutu xumac ngɨbua gee, hɨxôn he Yuda levac levac ya, om Yesu nêl vô he ên nêbê, “Xam xo ên xam nêbê a tɨbii yôdac ti om xam lam hɨxôn yipac yuu vɨgo? ");
INSERT INTO ptp_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Ilage a mi dô hɨxôn xam vac Anutu xumac ngɨbua tɨyi buc vɨhati, lêc xam o hôm a xôn lêm. Lêc gwêbaga buc wê xam vông, om xêkɨzêc wê mapɨtoc vông ge vô levac.” ");
INSERT INTO ptp_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","He hôm Yesu xôn dɨ kô i mɨ la vô xomxo ti wê tu xomxo daa siên nên levac ge om he mɨla vac xomxo levac tyo ben, dɨ Pita tɨmu vô he vɨxa lêc le lam teva teva. ");
INSERT INTO ptp_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Mêd xomxo wê dô vac xomxo levac tige ben ge vev ngwax lec wetôv dɨ nyuu mɨ dô, dɨ Pita la dô hɨxôn he. ");
INSERT INTO ptp_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Mêdêc vêx yuac ti yê Pita wê xeedô dɨ ngwax linac lec ge om yê i kɨzêc dêc nêl ên nêbê, “Xomxo tya ga wê mi dô hɨxôn Yesu ge.” ");
INSERT INTO ptp_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Lêc Pita nêl ên nêbê, “A lungên xomxo tige.” ");
INSERT INTO ptp_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","He dô nipwo tya, nang dêc xomxo ngwe yê Pita nang dɨ nêl vô i ên nêbê, “Ông wê ông mi dô hɨxôn Yesu he nue.” Lêc Pita nêl ên nêbê, “Maê, o a lêmê.” ");
INSERT INTO ptp_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Hɨyôv manôn ti la vêl, nang dêc xomxo ti nêl xêkɨzêc nang ên nêbê, “Vɨxôhɨlôg, xomxo tiga wê mi dô hɨxôn Yesu, ên yuu xôn tɨbii Galili yuu.” ");
INSERT INTO ptp_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Lêc Pita nêl ên nêbê, “A lungên kɨyang wê ông nêl ge.” Pita gên o nêl kɨyang tɨyôô lêm, dɨ kokɨlêx hi vya lutibed. ");
INSERT INTO ptp_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Mêd Apumtau Yesu pɨlepac i dɨ yê Pita, om Pita xovô kɨyang wê Yesu nêl vô i ên nêbê, “Vô bucên tiga kokɨlêx vôên vya obêc gên ma dɨ ông obêc yax a vun lu yon dɨ nêl bê ông lungên a.” ");
INSERT INTO ptp_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Pita xovô wê i vông i so ge om sea vɨgwe tige dɨ la byag levac. ");
INSERT INTO ptp_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Mêd xomxo wê hôm Yesu xôn ge keac nipaên lec dɨ hi, ");
INSERT INTO ptp_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","dɨ ku i manôn vac nivɨmihi dɨ nêl vô i ên nêbê, “Ông nêl bê letya hi ôngê.” ");
INSERT INTO ptp_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Mêd he nêl kɨyang nipaên tibêge tɨbeac lec i. ");
INSERT INTO ptp_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Vɨgwe vɨdii mêd he Yuda levac levac nêb ob kɨtucma, om xomxo levac wê mi si daa gee dɨ xomxo wê xovô Moses xolac gee hɨxôn he levac levac ge mangwe, he kɨtucma mɨ dô, mêd tɨbii kô Yesu mɨ la lax vô he manôn. Mêd he kɨnêg vô Yesu ên nêbê, ");
INSERT INTO ptp_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","“Nêl vô xe bê ông ge Kɨlisi ti wê Anutu nêb ob vông i lam ge, me?” Lêc Yesu nêl vô he ên nêbê, “A obêc nêl kɨtong vô xam ge od xam ob vông i vin a vyag lêm, ");
INSERT INTO ptp_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","dɨ a obêc kɨnêg kɨyang vô xam ge od xam ob luu a vyag lêm. Nge, xam ob dô kɨyang maên. ");
INSERT INTO ptp_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Vɨwen wê tɨmuên ge, a, Xomxo Nu, a ob dô vô Anutu wê xêkɨzêc kehe ge vɨgê hɨyôv.” ");
INSERT INTO ptp_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Mêd he vɨhati kɨnêg ên nêbê, “Ông ge Anutu nu mê?” Mêd Yesu nêl ên nêbê, “Xam nêl i tɨyi, ên a ga Anutu nu.” ");
INSERT INTO ptp_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Mêd he nêl vôma ên nêbê, “Pyap om il ob kɨnêg kɨyang ya hɨxôn lêm. Ên ici va nêl i kɨtong vac mya mɨ il ngô pyap.” ");
INSERT INTO ptp_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Xomxo levac vɨhati kɨdi lec dɨ kô Yesu mɨ la dɨ la lax vô Pailat manôn. ");
INSERT INTO ptp_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Mêd he nêl kɨyang nipaên lec Yesu bêga ên nêbê, “Xecxe xê wê xomxo tiga vô pɨlepac pɨlepac vô xe dɨ nêb xe o vông mone takis vô il nêd king Sisa lêm, dɨ kɨtyoo xe ên nêbê i ge Kɨlisi wê tu king ge.” ");
INSERT INTO ptp_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Mêd Pailat kɨnêg vô Yesu ên nêbê, “Ông ge king wê he Yuda vông ge, me?” Mêd Yesu lee yuu ên nêbê, “Ông nêl i la tɨyi.” ");
INSERT INTO ptp_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Mêd Pailat nêl vô xomxo levac daa siên hɨxôn xomxo gee vɨhati ên nêbê, “A yaxên xomxo tiga nên kɨyang, lêc kɨyang ti o yêp vô i lêm.” ");
INSERT INTO ptp_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Lêc xomxo tigee nêl kɨyang xêkɨzêc ên nêbê, “Xomxo tige la nêl kɨyang vaxvax vô xomxo vac vɨgwe Galili dɨ i la vac vɨgwe Judia vɨhati dɨ val ga hɨxôn.” ");
INSERT INTO ptp_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pailat ngô kɨyang tige, dɨ kɨnêg vô he ên nêbê, “Xomxo tiga, tɨbii Galili ti, me?” ");
INSERT INTO ptp_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Lêc he nêl ên nêbê Yesu ben Galili wê Helot viac ge, om Pailat vông i loc mɨ la vô Helot, ên Helot lam dô Jelusalem vô buc tige. ");
INSERT INTO ptp_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Yesu mɨla vô Helot mêd Helot yê dɨ xêyaa vô nivɨha yang, ên ilage xomxo nêl Yesu kɨtong vô i om Helot nêb ob yê Yesu dɨ nêb i vông do ti ên i ob yê. ");
INSERT INTO ptp_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Mêgem Helot kɨnêg kɨyang tɨbeac vô Yesu, lêc Yesu o nêl kɨyang ti lax vô i lêm. ");
INSERT INTO ptp_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Mêd xomxo levac wê mi si daa gee hɨxôn xomxo wê xovô Moses xolac gee le kwabo dɨ vông kɨyang xêkɨzêc vô Yesu, ");
INSERT INTO ptp_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","dɨ Helot hɨxôn nue vevac yê Yesu nipaên dɨ so vya vô i mêd kô ngakwi nivɨha ti dɨ lam vɨnyum lec Yesu. Pyap dêc vông i lax mɨ la vô Pailat nang. ");
INSERT INTO ptp_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Ilage Helot yuu Pailat mi yêma nipaên, lêc buc tige yuu xêyaa vin lecma dɨ yuu keac nivɨha vôma nang. ");
INSERT INTO ptp_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pailat tyuc xomxo levac wê mi si daa gee hɨxôn xomxo levac levac dɨ tɨbii tɨbeac kɨtuc la vô i, ");
INSERT INTO ptp_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","mêd nêl vô he ên nêbê, “Xam kô xomxo tige mɨ lam vô a ên xam nêb mi nêl kɨyang vaxvax vô xomxo om vông he yê gavman nipaên, om a kɨnêg kɨyang vô i lec xam mamnôn, lêc a o tulec kɨyang xocbê xam nêl ge ti vô i lêm. ");
INSERT INTO ptp_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Dɨ Helot êno o tulec kɨyang ti lêm, om vông i lôm vô il nang. Xam ngô lê, xomxo tiga o vông ti so tɨyi wê il ob hi i yib lec ge lêm. ");
INSERT INTO ptp_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Om a ob pɨsa i ya yihi dɨ vông i lôc ben.” ");
INSERT INTO ptp_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Môp wê he Yuda vông ge yêp bêga nêbê buc wê he ob myêl vɨzid Pasova ge od he mi nêl xomxo wê dô vac kalabuhu ge ti lê vô gavman levac, dɨ gavman levac ob pɨwelac i vêl. ");
INSERT INTO ptp_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","He môp bêge, mêgem xomxo tɨbeac tyuc vya levac ên nêbê, “Hi xomxo tiga i yib dɨ vông Balabas i lôm vô xe.” ");
INSERT INTO ptp_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Ilage Balabas hɨxôn xomxo tɨbeac vông vevac vô gavman Lom vac vɨgwe tige dɨ hi xomxo ya yib om he vông i la dô vac kalabuhu. ");
INSERT INTO ptp_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pailat nêb ob pɨwelac Yesu om nêl bêge vô xomxo tɨbeac tigee nang, ");
INSERT INTO ptp_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","lêc he tyuc vya levac nang ên nêbê, “Hi i yib lec xax pola. Hi i yib lec xax pola.” ");
INSERT INTO ptp_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Mêgem Pailat nêl kɨyang ti wê vông yon ge vô he ên nêbê, “Ên xomxo tiga vông nipaên vatya? A o tulec i nên nipaên ti tɨyi wê il ob hi i yib lec ge lêm. Om a ob pɨsa i ya yihi dɨ vông i lôc nên.” ");
INSERT INTO ptp_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Lêc he tyuc vya levac ngɨnong ên nêbê, “Hi i lec xax”, om he vya hi Pailat vya tô, ");
INSERT INTO ptp_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","mêd Pailat tɨmu vô he vya, ");
INSERT INTO ptp_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","om Balabas wê vông vevac vô gavman dɨ hi xomxo yib ge, Pailat nêb he i pɨwelac i vêl i tɨyi wê he nêl ge, dɨ vông Yesu la vac he vɨgê ên nêb he i vông i tɨyi wê he xovô ge. ");
INSERT INTO ptp_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","He kô Yesu mɨ la vô môp, dêc he yê xomxo ti wê dɨlam ên nêb ob la Jelusalem ge. Xomxo tyo lê nêbê Saimon dɨ i ben Sailini. Om he hôm i xôn dɨ vông i kɨlê xax pola wê he ob hi Yesu lec ge dɨ tɨmu vô Yesu vɨxa. ");
INSERT INTO ptp_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Yesu mug mêd xomxo tɨbeac dɨtɨmu vô i vɨxa, dɨ vêx ya byag dɨ vông tɨlôt lec i. ");
INSERT INTO ptp_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Om Yesu pɨlepac i dɨ nêl vô he ên nêbê, “Xam vêx Jelusalem, le i lêc byag ên a lêm. Nge, xacxam va byag ên xam hɨxôn nume. ");
INSERT INTO ptp_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Ên obêc buc tɨmuên ge od tɨbii ob val vông vɨyin vô xam, om xam ob nêl bêga bê, ‘Vêx wê le pɨleva dɨ kôên nu ma ge, me vêx wê o vông lul vô nu lêm ge, he ob dô vɨyin maên tya.’ ");
INSERT INTO ptp_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Mêd vô buc tige xomxo ob nêl vô kɨtôn bê, ‘Pul mɨ lam hi xe.’ Dɨ ob nêl vô kɨtôn nipwo bêga bê, ‘Lam hɨvun xe xôn.’ ");
INSERT INTO ptp_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Gwêbaga he vông vɨyin vô a tɨyi xocbê ob vuv xax paha ge. Dɨ xam ge tɨyi xocbê xax mupacên om he ob vông bêna vô xam tɨmuên?” ");
INSERT INTO ptp_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Mêd he kô tɨbii nipaên yuu hɨxôn, wê ob hi yuu yib hɨxôn Yesu. ");
INSERT INTO ptp_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Mêd he mɨla vac vɨgwe ti lê nêbê bazub len, mêd he hi Yesu hɨxôn tɨbii nipaên yuu ge lec xax pola vac vɨgwe tige. Yesu yux vac mahɨgun dɨ tɨbii nipaên yuuo yux vɨlu vɨlu. ");
INSERT INTO ptp_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Mêd Yesu nêl ên nêbê, “Mag, ông kɨtya tɨbii gae nên nipaên vêl, ên he lungên om he vông.” Mêd tɨbii vevac tigee nêb ob tɨtang Yesu ngakwi vôma om he tɨde mɨ yê dêc tɨtang i tɨyi. ");
INSERT INTO ptp_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Mêd xomxo tɨbeac dô dɨ yê, mêd Yuda levac levac nêl nipaên lec Yesu ên nêbê, “Xomxo tige ngɨdu xomxo ya xôn ilage, om obêc Kɨlisi wê Anutu vɨnoo i nôn ge od i ngɨdu ici va xôn êno.” ");
INSERT INTO ptp_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Mêd tɨbii vevac êno nêl nipaên lec Yesu, dɨ he kô mia wain wê kɨlin ge mɨ la le kwabo vô Yesu nêb ob vông mɨ i num, ");
INSERT INTO ptp_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","dɨ nêl vô i ên nêbê, “Ông obêc xomxo Yuda nên king ge od ông ngɨdu ôcông va xôn.” ");
INSERT INTO ptp_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Mêd kɨyang ti yêp lec kɨsii vô Yesu bazub ên nêbê, “XOMXO TIGA, KING WÊ HE YUDA VÔNG GE.” ");
INSERT INTO ptp_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Tɨbii nipaên wê yux lec xax hɨxôn Yesu ge, ngwe nêl vya nipaên vô Yesu ên nêbê, “Ông Kɨlisi mê? Od ông ngɨdu ôcông va xôn dɨ ngɨdu xii xôn êno.” ");
INSERT INTO ptp_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Lêc ngwe kunac dɨ nêl ên nêbê, “Ông o xona ên Anutu lêmê? Xon xôn kô myavɨwen nipaên tɨyima lê, ");
INSERT INTO ptp_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","lêc u kô nipaên tɨyi môp nipaên wê u vông ge, om ge la tɨyi, dom xomxo tiga o vông nipaên ti lêm.” ");
INSERT INTO ptp_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Mêd nêl vô Yesu ên nêbê, “Yesu, buc wê ông ob tu king hɨxôn xêkɨzêc ge od ông xo a.” ");
INSERT INTO ptp_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Mêd Yesu nêl vô i ên nêbê, “A ob nêl hɨxôn nôn vô ông bê gwêbaga ông ob la dô hɨxôn a gê paladis.” ");
INSERT INTO ptp_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Hɨyôv tyip kɨtôn mêd hɨyôv linacên ma dɨ vɨgwe vɨhati vô mapɨtoc ta dɨ i la vô hɨyôv manôn yon wê hucên ge. ");
INSERT INTO ptp_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Mêd nivɨmihi levac ti wê yux vac Anutu xumac ngɨbua ge lêx la yuu vac mahɨgun. ");
INSERT INTO ptp_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Mêd Yesu tyuc vya levac ên nêbê, “O Mag, a kɨnug i loc vac ông vɨgêm.” Nêl bêge pyap mêd yib. ");
INSERT INTO ptp_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Mêd tɨbii levac wê viac nue vevac ge yê susu tigee dɨ pɨmil Anutu dɨ nêl ên nêbê, “Vɨxôhɨlôg, xomxo tiga nivɨha dɨ nipaên ti o yêp vô i lêm.” ");
INSERT INTO ptp_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Mêd xomxo wê val ên nêb ob yê ge, he tɨbeac le dɨ yê wê Yesu yib ge, pyap dêc he lax mɨ la ben, lêc he nɨlô vô vɨyin om he kɨtuu pɨkopac dɨ la. ");
INSERT INTO ptp_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Dɨ xomxo wê Yesu lie gee hɨxôn vêx wê sea Galili dɨ mi tɨmu vô Yesu vɨxa gee, he xôn le teva tya dɨ yê susu vɨhati yang wê tɨbii vông vô Yesu ge. ");
INSERT INTO ptp_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Xomxo ti dô lê nêbê Josep dɨ i ben Alimatia wê yêp vac vɨgwe Yuda ge. Josep ge Yuda levac ti wê tu kaunsil dɨ mi dô vac kɨtucmaên hɨxôn Yuda levac levac, lêc o tyuc lec kɨyang wê kaunsile hɨlu lec Yesu ge hɨxôn lêm. Ên Josep ge xomxo nivɨha ti wê dô bin buc wê Anutu nu ob lam tu king gê kɨbun ga. ");
INSERT INTO ptp_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Mêd Josep la vô Pailat dɨ la kɨtaa Pailat ên nêb ob kô Yesu ninɨvi mɨ la yev. ");
INSERT INTO ptp_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Mêgem Pailat tyuc lec dɨ Josep la kwax Yesu vêl ên xax dɨ la vɨyum vac nivɨmihi kwem ti dɨ la lii vac lôva wê he yev vac ngɨdax ge ti. Lôva tige, he o lii xomxo ti vac ila lêm. Nge, gên paha. ");
INSERT INTO ptp_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Buc tige, ge buc wê he Yuda ob viac he, ên vɨgwe obêc huc ge od he buc sabat wê ngɨbua ge myahɨpu ob val. ");
INSERT INTO ptp_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Mêgem vêx wê sea ben Galili dɨ mi tɨmu vô Yesu gee, he tɨmu vô Josep vɨxa dɨ la yê wê he lii Yesu ninɨvi vac lôva ge. ");
INSERT INTO ptp_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Pyap dɨ he lax mɨ la ben dɨ lax viac wel hɨxôn susu wê nivɨvea ge. Pyap dêc buc sabat, om he dô seac vêl tɨyi môp wê Moses xolac nêl ge. ");
INSERT INTO ptp_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Sabat la vêl dɨ da pɨtoc yang ge vêx tigee kô susu nivɨvea wê he viac pyap ge mɨ la. He mɨla vô lôva wê he lii Yesu vac ge, ");
INSERT INTO ptp_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","lêc yê ngɨdax wê tɨbii lax i le vac vuayen xôn ge vɨxog la vêl, ");
INSERT INTO ptp_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","om he vac la vac lôva nɨlô lêc he o yêvô Apumtau Yesu ninɨvi lêm. ");
INSERT INTO ptp_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Mêgem he xo kɨyang tɨbeac tɨbeac, lêc lutibed vux yuu wê vɨnyum ngakwi kwem wê teeên ge val le kwabo vô he. ");
INSERT INTO ptp_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Mêd vêx tigee yê dɨ xona mabu dɨ kɨlong kɨbun, lêc xomxo yuu ge nêl vô he ên nêbê, “Bêna lêc xam myag xomxo mavɨha tige vac xomxo yibên benê? Xomxo tige yêpên ga ma, dɨ i kɨdi lec mavɨha mɨ la. ");
INSERT INTO ptp_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Xam xovô i lôc vô kɨyang wê Yesu nêl vô xam dɨ xam gên dô Galili ge wê i nêl bêga ên nêbê, ");
INSERT INTO ptp_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‘He obêc vông Xomxo Nu la vac tɨbii nipaên vɨgê dɨ he hi i yib, dɨ buc ti wê vông yon ge od obêc kɨdi lec i tii vac nang i tɨyi kɨyang wê Anutu nêl pyap ge.’” ");
INSERT INTO ptp_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Mêgem vêx tigee xovô kɨyang wê Yesu nêl ilage nang, ");
INSERT INTO ptp_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","om he sea lôva dɨ lax mɨ la nêl kɨyang tigee vɨhati kɨtong vô nue ngɨvihi vɨgê yuu dɨ tô mɨ la ti ge hɨxôn xomxo yaya. ");
INSERT INTO ptp_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Vêx wê nêl kɨyang tige vô nue ngɨvihi ge, Malia Makdala yuu Joana yon Malia wê Jems ta ge dɨ vêx yaya. ");
INSERT INTO ptp_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Lêc nue ngɨvihi ngô kɨyang tige tɨyi xocbê kɨyang kɨtyooên, om he o vông i vin lêm. ");
INSERT INTO ptp_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Mêgem Pita kɨdi lec dɨ tup mɨ la vô lôva, dɨ mɨla kɨlong lôva nɨlô mɨ yê, lêc yê wê nivɨmihi ti wê he vɨyum Yesu vac ge dɨyêp pɨleva, mêgem lax mɨ la hɨxôn nɨlô vɨyin, ên lungên tige kehe. ");
INSERT INTO ptp_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Vô buc tige, xomxo wê mi dô hɨxôn Yesu ge yuu la vô môp ên nêb ob la vɨgwe ti lê nêbê Emeas. Môp wê ob sea Jelusalem dɨ la Emeas ge tɨyi xocbê 11 kilomita. ");
INSERT INTO ptp_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Yuu dɨla vô môp dɨ keac lec byed wê tɨbii vông vô Yesu ge. ");
INSERT INTO ptp_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Yuu dɨkeac, lêc Yesu val vô yuu dɨ yon xôn dɨla vô môp. ");
INSERT INTO ptp_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Yuu manôn yê Yesu lê, lêc yuu o xovô bê ge Yesu lêm. ");
INSERT INTO ptp_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Mêd Yesu kɨnêg vô yuu ên nêbê, “Muu dɨkeac lec vatya dɨ tup vô môpê?” Mêgem yuu le dɨ nɨlô vô vɨyin dɨ manôn vô nipaên. ");
INSERT INTO ptp_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Mêd ngwe wê lê nêbê Kliopas ge nêl vô Yesu ên nêbê, “Tɨbii vac vɨgwe vɨyang vɨyang ge la Jelusalem om he vɨhati yê dɨ ngô susu wê val vac buc mahɨgun tiga, dom mêd ông tibed wê ông dɨlungên?” ");
INSERT INTO ptp_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Mêd Yesu kɨnêg vô yuu ên nêbê, “Muu nêl lec susu vatya?” Om yuu nêl vô i ên nêbê, “Xii dɨnêl kɨyang lec Yesu Nasalet. Yesu ge plopete ti wê vông yuac xêkɨzêc dɨ nêl kɨyang hɨxôn xêkɨzêc, dɨ Anutu hɨxôn xomxo vɨhati yê i nivɨha. ");
INSERT INTO ptp_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Lêc xomxo levac wê mi si daa gee hɨxôn Yuda levac wê mi viac il gee, he vông i la vô gavman levac dɨ gavman levac tyuc lec nêb i yib om he hi i yib lec xax pola. ");
INSERT INTO ptp_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Ilage xe vông i vin ên xe nêbê Yesu ge xomxo wê ob vô Islel vêl ên nipaên ge, lêc mad xomxo tyo yib. Dɨ kɨyang bo ti hɨxôn bêga bê xomxo tyo yib nyop, om ga buc wê vông yon ge. ");
INSERT INTO ptp_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Mêd gwêbaga vêx wê xe xôn mi dô ge vông xe yetac mabu, ên he kɨdi pɨtoc yang mɨ la yê lôva ti wê he lii Yesu vac ge, ");
INSERT INTO ptp_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","lêc he o tulec Yesu lêm, om he vena nêl vô xe ên nêbê, ‘Xe xê angela ya dɨ he nêl vô xe ên nêbê Yesu kɨdi lec mavɨha nang.’ ");
INSERT INTO ptp_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Om xomxo wê xe xeedô gee ya kɨdi dɨ loc mɨ la yê lôva nang, lêc mɨla yê tɨyi xocbê vêx tigee nêl ge, dɨ he o tulec Yesu lêm.” ");
INSERT INTO ptp_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Mêd Yesu nêl vô yuu ên nêbê, “Muu pɨyôp maên. Bêna lêc muu gên o vông i vin kɨyang wê plopete nêl ilage lêmê? ");
INSERT INTO ptp_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Ên kɨyang yêp bêga nêbê Kɨlisi wê Anutu nêb ob vông i lam ge obêc kô myavɨnê, pyap dêc obêc la dô vac xêseac dɨ kô lê levac, lêc mêd muu o xovô tige lêm?” ");
INSERT INTO ptp_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Yesu nêl bêge pyap, nang dêc nêl Moses xolac dɨ nêl plopete kɨyang ge vɨhati kehe kɨtong hɨxôn vô yuu, ên nêbê kɨyang gee vɨhati nêl lec i. ");
INSERT INTO ptp_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Mêd yon mɨla kwabo vô vɨgwe wê yuu ob la ge, lêc Yesu vông xocbê ob luu yuu vêl dɨ loc mɨ la ge, ");
INSERT INTO ptp_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","om yuu nêl xôn ên nêbê, “Ông dô hɨxôn xiiê, ên hɨyôv hoo la gwêba om vɨgwe ob buc.” Om Yesu la hɨxôn yuu dɨ yon la dô vac yuu ben. ");
INSERT INTO ptp_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Mêd yon dô ên nêb ob ya yaên, dêc Yesu hôm blet dɨ kɨtaa lec dɨ hɨbu dɨ vông vô yuu. ");
INSERT INTO ptp_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Mêd yuu yê dɨ xovô nêbê ge Yesu, lêc lutibed Yesu xôa ma dɨ yuu o yê i tii vac nang lêm. ");
INSERT INTO ptp_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Dɨ yuu nêl vôma ên nêbê, “Buc wê Yesu keac hɨxôn u vac môp dɨ nêl xolac kehe vô u ge od kɨyang tige tɨpi vô u nɨlôd dɨ vông u xêdyaa vô nivɨha.” ");
INSERT INTO ptp_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Mêgem lutibed yuu kɨdi lec dɨ lax mɨ la Jelusalem vô nue ngɨvihi vɨgê yuu dɨ tô mɨ la ti hɨxôn lie ya wê he kɨtucma mɨ dô ge, ");
INSERT INTO ptp_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","mêd he nêl vô yuu ên nêbê, “Vɨxôhɨlôg, Apumtau Yesu kɨdi lec. Ge hɨlung i vô Saimon Pita gwêba.” ");
INSERT INTO ptp_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Mêd yuu nêl kɨtong vô he lec wê Yesu dɨla hɨxôn yuu vô môp ge, dɨ nêl wê Yesu hɨbu blet dɨ kɨtaa lec om yuu xovô i. ");
INSERT INTO ptp_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Yuu gên dɨnêl kɨyang tige, dɨ Yesu val le vac he mahɨgun dɨ nêl vô he ên nêbê, “Kɨyang malehe i hɨvun xam xôn.” ");
INSERT INTO ptp_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","He ngô kɨyang tige om he yetac dɨ xona mabu, ên he xo ên he nêbê ge xomxo yibên ti kɨnu. ");
INSERT INTO ptp_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Lêc Yesu nêl vô he ên nêbê, “Bêna lêc xam nɨlôm vô vɨyin dɨ xam xo kɨyang tɨbeacê? ");
INSERT INTO ptp_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Xam wê a vɨgêg yuu vɨxag ga dɨ xovô bê ga a, dɨ xam vyax vɨgêm lec a nignɨvi mɨ yaxên, ên xomxo yibên kɨnu ge od len yuu lɨyôhô o xocbê a ga lêm.” ");
INSERT INTO ptp_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Yesu nêl bêge pyap dɨ hɨlung vɨgê yuu vɨxa vô he. ");
INSERT INTO ptp_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","He yê bêge dɨ nɨlô vô nivɨha, lêc he gên o vông i vin lêm. Nge, he nɨlô vô tɨbeac. Om Yesu nêb he i xovô bê i o xomxo yibên kɨnu lêm, om kɨnêg vô he ên nêbê, “Yaên ya dô vô xamê?” ");
INSERT INTO ptp_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Mêgem he vông beac wê he si lec ngwax ge ti vô i, ");
INSERT INTO ptp_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","mêd i hôm dɨ ya vô he manôn. ");
INSERT INTO ptp_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Nang dêc Yesu nêl vô he ên nêbê, “Ilage wê a gên dô hɨxôn xam ge, od a nêl kɨyang bêga vô xam ên a nêbê kɨyang wê xomxo kɨvuu lec a mɨ i yêp vac Moses xolac yuu plopete kɨyang dɨ yêp vac kɨpihac Sam ge, ge vɨhati obêc vô nôn lec.” ");
INSERT INTO ptp_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Ge Yesu nêl i kɨtong vô he om he pɨyôp xovô kɨyang vɨhati wê yêp vac xolac ge, ");
INSERT INTO ptp_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","dɨ i nêl vô he ên nêbê, “Kɨyang yêp bêga nêbê Kɨlisi wê Anutu nêb ob vông i lam ge obêc kô myavɨnê dɨ yib, dɨ buc ti wê vông yon ge od obêc kɨdi lec mavɨha vac yibên nang, ");
INSERT INTO ptp_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","dɨ kɨyang yêp hɨxôn bêga nêbê xomxo i loc nêl xolac lec Kɨlisi lê vac vɨgwe vɨhati bêga bê xomxo i pɨlepac he êdêc Anutu i kɨtya he nên nipaên vêl. Xam vông yuac tige gê Jelusalem tax, ");
INSERT INTO ptp_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","dɨ xam ob nêl kɨyang wê xam wê dɨ ngô ge vɨhati kɨtong. ");
INSERT INTO ptp_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Xam ngô lê. Myakɨlôhô Ngɨbua wê Mag nêl nêb ob vông i lam ge, a obêc vông i lam vô xam, om xam dô Jelusalem dɨ i loc vô buc wê Anutu ob vông xêkɨzêc wê kɨsii ganê i lam hɨvun xam xôn lê.” ");
INSERT INTO ptp_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Mêd Yesu kô he dɨ he sea Jelusalem mɨ la Betani, mêd Yesu vông vɨgê la kɨsii dɨ kɨtaa lec he. ");
INSERT INTO ptp_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Yesu kɨtaa mɨ le, dɨ he yê wê Anutu kô i dɨ i lec mɨ la kɨsii ge. ");
INSERT INTO ptp_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Mêd he lax hɨxôn xêyaa nivɨha mɨ la Jelusalem, ");
INSERT INTO ptp_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","mêd tɨyi buc vɨhati ge he la pɨmil Anutu vac xumac ngɨbua. ");
INSERT INTO ptp_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Ilage vô buc taxlee ge, kɨyang tyo dô. Kɨyang tyo dô hɨxôn Anutu, dɨ ici va Anutu. ");
INSERT INTO ptp_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Vô buc mugên ilage i dô hɨxôn Anutu, ");
INSERT INTO ptp_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","dɨ Anutu nêl dɨ xomxo tyo tung susu vɨhati, dɨ susu ti o lam môp bangwe lêm. Nge, xomxo tyo tung susu vɨhati. ");
INSERT INTO ptp_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Dɨ ici va ge mavɨha kehe, dɨ mavɨha wê i vông ge linac vô xomxo mɨ he dô vac xêseac. ");
INSERT INTO ptp_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Xêseac wê i vông ge linac vac mapɨtoc, dɨ mapɨtoc o tɨyi wê ob hɨvun xêseac tige xôn ge lêm. ");
INSERT INTO ptp_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Anutu vông xomxo ti lam lê nêbê Jon. ");
INSERT INTO ptp_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Jon lam nêl xêseac kehe kɨtong vô xomxo ên nêb he vɨhati i ngô kɨyang wê i nêl ge dɨ vông i vin. ");
INSERT INTO ptp_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Ici va ge o xêseac tyo lêm. Nge, lam ên nêb ob nêl xêseac tige kɨtong vô xomxo. ");
INSERT INTO ptp_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Xêseac tige lop mɨ lam kɨbun ga, dɨ i xêseac nôn wê ob linac lec xomxo vɨhati ge. ");
INSERT INTO ptp_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Ici va tung susu kɨbun ga dɨ ici va lam dô kɨbun, lêc xomxo kɨbun ga, he o xovô i lêm. ");
INSERT INTO ptp_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","La vac ben vɨgwe kehe lê, lêc lie o kô i lec nivɨha lêm. ");
INSERT INTO ptp_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Lêc xomxo wê kô i lec nivɨha dɨ vông i vin ge, od vông he tu Anutu nue. ");
INSERT INTO ptp_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Môp wê he tu Anutu nue ge o tɨyi xocbê môp wê xomxo kɨbun ga kô nue ge lêm, dɨ kehe o yêp vac xovôên wê xomxo vông ge lêm. Nge, Anutu vaci vông he tu i nue. ");
INSERT INTO ptp_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Kɨyang lam tu xomxo gê kɨbun ga dɨ i dô vac xe mahɨgun, om xe xê xêseac wê i vông ge. Xêseac tige Anutu vông vô nu tuc tibed, dɨ xêyaa vin lecên yuu kɨyang nôn hɨvun i xôn. ");
INSERT INTO ptp_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Jon nêl xomxo tige kɨtong dɨ keac vya levac ên nêbê, “Xomxo tyo tiga, wê a nêl kɨyang lec ilage ên a nêbê xomxo ngwe wê ob val tɨmuên ge luu a vêl, ên buc wê a gên ma ge, xomxo tiga dô tax.” ");
INSERT INTO ptp_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Ici va tu vɨzid vɨyang vɨyang ge kehe om vông vɨzid tɨbeac vô il luu vêl. ");
INSERT INTO ptp_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Ilage Anutu nêl xolac vô Moses mɨ i nêl vô xomxo, lêc xêyaa vin lecên hɨxôn kɨyang nôn, Yesu Kɨlisi vaci kô mɨ lam. ");
INSERT INTO ptp_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Xomxo ti o yê Anutu lec manôn lêm. Nu tuc tibed wê dô hɨxôn Ma Anutu ge wê lam nêl Anutu kehe kɨtong vô il. ");
INSERT INTO ptp_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Yuda levac wê dô Jelusalem ge vông xomxo wê mi si daa gee hɨxôn xomxo Livai ya la vô Jon dɨ he la kɨnêg vô i ên nêbê, “Ông ge letya?” ");
INSERT INTO ptp_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Om Jon nêl i kehe kɨtong yêp seac vô he dɨ o yax vun lêm, om nêl i kɨtong ên nêbê i o Kɨlisi ti wê he dô bin ge lêm. ");
INSERT INTO ptp_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Om he kɨnêg ên nêbê, “Om ông letya? Ông tɨyi xocbê plopet Ilaija, me?” Lêc Jon nêl vô he ên nêbê, “A o Ilaija lêm.” Om he kɨnêg nang ên nêbê, “Ông ge plopet ti wê xe mi dô bin ge, me?” Lêc Jon nêl ên nêbê, “A o plopet tige lêm.” ");
INSERT INTO ptp_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Om he kɨnêg tii vac ên nêbê, “Ông ge letya? Xe obêc mɨlax nêl kɨyang tibêna vô xomxo wê vông xe lam ge? Om ông nêl ông kehe kɨtong vô xe.” ");
INSERT INTO ptp_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Om Jon nêl vô he tɨyi xocbê kɨyang wê plopet Aisaia kɨvuu ilage bêga nêbê, “A ga xomxo ti wê tyuc vya levac vac vɨgwe mahɨgun pɨleva ên nêbê, ‘Xam viac Apumtau môp wê ob lam vac ge i yêp nivɨha.’” ");
INSERT INTO ptp_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Xomxo tigee, tɨbii Palisi vông he lam, ");
INSERT INTO ptp_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","mêd he kɨnêg vô Jon ên nêbê, “Ông nêl ên ông nêbê ông o Kɨlisi lêm, dɨ nêl ên ông nêbê ông o Ilaija lêm, dɨ nêl ên ông nêbê ông o plopet tige lêm, lêc bêna lêc ông lipac xomxo ya mia?” ");
INSERT INTO ptp_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Om Jon nêl ên nêbê, “A lipac xomxo ya mia pɨleva, dɨ xomxo ti val le vac xam mahɨgun lêc xam o xovô lêm. ");
INSERT INTO ptp_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","A lam tax dɨ xomxo tige obêc val tɨmuên, lêc a o nigvɨha tɨyi wê aob pɨwelac yihi vêl ên su wê i vông ge lêm.” ");
INSERT INTO ptp_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Jon nêl kɨyang tige gê Betani wê yêp mia Jodan kehe vɨlu ganê. Vɨgwe tige wê Jon mi lipac xomxo vac ge. ");
INSERT INTO ptp_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Tɨtige Jon yê wê Yesu val ge om nêl ên nêbê, “Xam wê lê, ge bwoc sipsip nu wê Anutu vông i lam kɨbun ên nêb i lam yib dɨ kɨtya xomxo nên nipaên vêl ge. ");
INSERT INTO ptp_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Ge xomxo wê a nêl kɨyang lec ilage ên a nêbê, ‘A lam tax dɨ xomxo ti wê ob val tɨmuên ge luu a vêl, ên buc wê a gên ma ge, xomxo tige dô tax.’ ");
INSERT INTO ptp_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","A gên o xê xomxo tige lêm, lêc a lam lipac xomxo ya mia, ên a nêb a ob nêl xomxo tige kɨtong vô xomxo Islel.” ");
INSERT INTO ptp_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Nang dêc Jon nêl kɨtong bêga ên nêbê, “A xê wê Myakɨlôhô Ngɨbua lam gê kɨsii ganê tɨyi xocbê menac tucluu dɨ lam yêp lec Yesu kɨsii. ");
INSERT INTO ptp_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","A gên o xovô i lêm, lêc Anutu wê vông a lam lipac xomxo ya mia ge nêl vô a tax ên nêbê, ‘Ông obêc wê Myakɨlôhô Ngɨbua lop mɨ lam dô lec xomxo ti ge od ông xovô bê xomxo tige wê ob lipac xomxo ya Myakɨlôhô Ngɨbua.’ ");
INSERT INTO ptp_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","A xê wê kɨyang tige vô nôn lec ge om a nêl kɨtong bê xomxo tige, Anutu nu.” ");
INSERT INTO ptp_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Vɨgwe vɨdiiên tɨtige Jon le hɨxôn i nue ngɨvihi yuu, ");
INSERT INTO ptp_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","lêc yê wê Yesu val ge, om nêl ên nêbê, “Wê lê, ge bwoc sipsip nu wê Anutu vông ge.” ");
INSERT INTO ptp_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Nu ngɨvihi yuu ge ngô wê Jon nêl ge om la tɨmu vô Yesu mɨ he la. ");
INSERT INTO ptp_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Mêd Yesu pɨlepac i dɨ yê wê yuu la vô i vɨxa ge om kɨnêg vô yuu ên nêbê, “Muu lam ên vatya?” Lêc yuu nêl ên nêbê, “Labai, ông dô vac xumac tina?” Labai ge, kehe bêga nêbê xolac kehe. ");
INSERT INTO ptp_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Om Yesu nêl vô yuu ên nêbê, “Muu lam wê lê.” Om yuu la hɨxôn Yesu mɨ la yê xumac wê Yesu yêp vac ge. Ge hɨyôv manôn yuudɨyuu wê hucên ge om yuu dô hɨxôn Yesu dɨ vɨgwe buc. ");
INSERT INTO ptp_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Xomxo yuu wê ngô Jon vya dɨ la hɨxôn Yesu ge, ngwe Andlu wê Saimon Pita li ge, ");
INSERT INTO ptp_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","om Andlu la vô li Saimon dɨ nêl vô ên nêbê, “Xe xê Mesaia.” Mesaia ge, lê ngwe nêbê Kɨlisi dɨ kehe bêga nêbê xomxo ti wê Anutu vông i lam ge. ");
INSERT INTO ptp_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Mêd Andlu kô Saimon mɨ yuu la vô Yesu, mêd Yesu yê Saimon dɨ nêl vô ên nêbê, “Ông ge Saimon wê Jon nu ge, lêc a ob nêl ông lêm bê Sipas.” Lê Sipas ge, Glik vya nêl bêga nêbê Pita, dɨ kehe bêga nêbê ngɨdax. ");
INSERT INTO ptp_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Vɨgwe vɨdiiên tɨtige Yesu nêb ob la vɨgwe levac Galili om mɨla vô Pilip dɨ nêl vô ên nêbê, “Lam tɨmu vô a.” ");
INSERT INTO ptp_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Pilip yon Andlu yuu Pita, yon ben kehe Betsaida. ");
INSERT INTO ptp_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Mêd Pilip la myag Nataniel mɨ yêvô dɨ nêl vô ên nêbê, “Xomxo ti wê Moses kɨvuu kɨyang lec mɨ i yêp vac kɨpihac xolac dɨ plopete kɨvuu kɨyang lec hɨxôn ge, xe tulec i. Ge Yesu wê ma Josep vac vɨgwe Nasalet.” ");
INSERT INTO ptp_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Lêc Nataniel nêl ên nêbê, “Nôn nivɨha ti ob val tyip vac vɨgwe Nasalet lêm.” Lêc Pilip nêl vô i ên nêbê, “Lam loc wê lê.” ");
INSERT INTO ptp_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Mêd Yesu yê wê Nataniel val vô i ge, om nêl lec i ên nêbê, “Wê, ge xomxo Islel nivɨha ti, wê kɨyang kɨtyooên ti o yêp vac i nɨlô ge lêm.” ");
INSERT INTO ptp_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Mêd Nataniel nêl vô Yesu ên nêbê, “Ông xovô a gê na?” Om Yesu nêl vô i ên nêbê, “Buc wê Pilip gên o keac ông lam lêm ge, ông le vac hɨguc kehe dɨ a xovô ông pyap.” ");
INSERT INTO ptp_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Om Nataniel nêl ên nêbê, “Xolac kehe, ông ge Anutu nu. Ông tu xe Islel nêm xomxo levac.” ");
INSERT INTO ptp_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Mêd Yesu nêl vô i ên nêbê, “Ông vông i vin ên wê a nêl vô ông ên a nêbê a xê ông le vac hɨguc kehe ge. Lêc tɨmuên ông obêc wê susu ya obêc luu tiga vêl.” ");
INSERT INTO ptp_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Mêd Yesu nêl hɨxôn ên nêbê, “A nêl hɨxôn nôn vô xam bê tɨmuên xam obêc wê, lêc lag puunê obêc tax dɨ angela wê Anutu vông ge ob lec mɨ la kɨsii dɨ lop mɨ lôm vô Xomxo Nu.” ");
INSERT INTO ptp_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Buc yuu la vêl dɨ buc wê vông yon ge xomxo vux ti ii vêx vac vɨgwe Kena wê yêp vac vɨgwe levac Galili ge, dɨ Yesu ta la dô hɨxôn. ");
INSERT INTO ptp_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Dɨ he tyuc Yesu he nue ngɨvihi ên nêb he i lam dô hɨxôn. ");
INSERT INTO ptp_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Mêd xomxo num wain ma vêl, om Yesu ta la nêl vô Yesu ên nêbê, “He xen wain ma.” ");
INSERT INTO ptp_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Lêc Yesu nêl vô i ên nêbê, “Tag, le i nêl vô a lêm. Ge yêp vô a, ên buc wê a vông ge gên yêp.” ");
INSERT INTO ptp_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Mêd ta nêl vô nue yuac vɨhati ên nêbê, “Xam vông i tɨyi kɨyang wê Yesu ob nêl vô xam ge.” ");
INSERT INTO ptp_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Dêg ngɨdax vɨgê vɨlu dɨ sec ti le, wê he mi lipac vɨgê hɨxôn susu ya vac tɨyi môp wê Yuda mi vông ge. Dêg tige levac mabu om dêg toto ge tɨyi xocbê ob kɨlê mia vac dêg nipwo kehe ti, me kehe ti dɨ vɨgê yuu mɨ too vac lêc i pup lec. ");
INSERT INTO ptp_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Mêd Yesu nêl vô nue yuac tigee ên nêbê, “Xam loc kɨlê mia dɨ lam too vac dêg tigae dɨ i pup lec.” Om he la kɨlê mia mɨ lam too vac dêg tigee vɨhati mɨ i pup lec. ");
INSERT INTO ptp_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Mêd Yesu nêl vô he ên nêbê, “Xam ka mia vac dêg nipwo dɨ kô mɨ loc vô xomxo levac ti wê viac yaên ge.” Om he ka dɨ kô mɨ la vô xomxo levac tyo. ");
INSERT INTO ptp_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Mia tige pɨlepac wain pyap mêd xomxo levac wê viac yaên ge num lê lêc o xovô kehe lêm. Nue yuac wê ka wain tige, he xovô, lêc xomxo levac wê viac yaên ge lungên, om keac xomxo ti wê ii vêx ge lam ");
INSERT INTO ptp_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","dɨ nêl vô i ên nêbê, “Tɨbii vɨhati mi vông wain nyen vô xomxo tax mɨ he num. Dɨ he obêc num levac ge od ob kô wain wê nyen maên ge mɨ vông vô he tɨmuên. Dɨ ông va lax wain nyen le, lêc dɨvông i lam tɨmuên tya ga.” ");
INSERT INTO ptp_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Do levac tige Yesu vông gê Kena wê yêp vac vɨgwe levac Galili ge. Ge do taxlee wê Yesu vông ge, om hɨlung xêseac yuu xêkɨzêc wê i vông ge dɨ nue ngɨvihi yê dɨ vông i vin. ");
INSERT INTO ptp_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Pyap dêc Yesu he tae lie hɨxôn nue ngɨvihi he xôn la Kapaneam dɨ la dô buc ya. ");
INSERT INTO ptp_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Buc levac Pasova wê he Yuda ob xovô buc Isip ilage vô kwabo lec, om Yesu la Jelusalem ");
INSERT INTO ptp_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","dɨ la vac Anutu xumac ngɨbua nɨlô, lêc yê wê xomxo ya kô bwoc kau yuu sipsip dɨ menac mɨ lam tung ên nêb tɨbii i kɨsuu dɨ vông i tu daa ge, dɨ yê wê xomxo ya dô dɨ vông mone luuma ge. ");
INSERT INTO ptp_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Om Yesu hôm yihi viiên dɨ tii xomxo tigee hɨxôn bwoc kau yuu bwoc sipsip la vêl ên xumac ngɨbua, dɨ kɨpyax mone wê he vông i luuma ge hɨxôn tevol la sea, ");
INSERT INTO ptp_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","dɨ nêl vô he wê vông vɨtevac lec menac ge ên nêbê, “Xam kô xam susu gee mɨ loc vêl, dɨ le i lêc vông Mag xumac i tu xocbê vɨgwe maket lêm.” ");
INSERT INTO ptp_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Mêd Yesu nue ngɨvihi xovô lec kɨyang ti wê yêp vac kɨpihac xolac bêga ên nêbê, “A vông yuac xêkɨzêc ta ên a nêb ông xumac i yêp nivɨha.” ");
INSERT INTO ptp_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","He Yuda yê môp wê Yesu vông ge om la nêl vô i ên nêbê, “Ông vông tibêge om ông ob vông do tina ên i nêl ông kɨtong vô xe?” ");
INSERT INTO ptp_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Yesu nêl vô he ên nêbê, “Xam obêc dii xumac ngɨbua tiga vêl ge od a ob lox vac i tɨyi buc yon.” ");
INSERT INTO ptp_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Om he kɨnêg vô Yesu ên nêbê, “Xumac ngɨbua tiga, xomxo vông yuac lec tɨyi xocbê klismas kehe yuu dɨ vɨgê vɨlu dɨ sec ti (46), lêc ông nêl ên ông nêbê ông ob lox xumac tige vac i tɨyi buc yon bed mê?” ");
INSERT INTO ptp_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Lêc xumac ngɨbua wê Yesu nêl lec ge, ge nêl lec ici va ninɨvi, ");
INSERT INTO ptp_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","om buc tɨmuên wê Anutu tɨpi vô Yesu kɨdi lec vac yibên ge, Yesu nue ngɨvihi xovô lec kɨyang wê Yesu nêl lec xumac ngɨbua ge, om he vông i vin ên he nêbê kɨyang wê Yesu nêl ge hɨxôn kɨyang wê yêp vac xolac ge, ge kɨyang nôn vɨxôhɨlôg. ");
INSERT INTO ptp_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Yesu dô Jelusalem vô buc Pasova wê he ob xovô buc Isip ilage, dɨ xomxo tɨbeac yê do levac wê i vông ge om he vông i vin. ");
INSERT INTO ptp_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Lêc Yesu o vô nɨnya lehe vô he mɨ la vac kɨyang wê he nêl ge kwa ngɨbi lêm, ");
INSERT INTO ptp_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","ên xovô he vɨhati pyap, dɨ o kɨnêg xomxo ngwe kehe vô xomxo ngwe lêm. Ên ici va xovô xomxo vɨhati nɨlô la tɨyi pyap. ");
INSERT INTO ptp_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Xomxo ti dô lê nêbê Nikodimas. Nikodimas ge Palisi ti dɨ i xomxo levac wê he Yuda vông ge. ");
INSERT INTO ptp_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Lêc la vô Yesu vô bucên dɨ nêl vô i ên nêbê, “Ông gexolac kehe, dɨ xe xovô ên xe nêbê Anutu vông ông lam. Ên do levac wê ông mi vông ge Anutu obêc dô hɨxôn ông lêm ge od ông obêc vông do levac tibêge lêm.” ");
INSERT INTO ptp_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Mêd Yesu nêl vô i ên nêbê, “A nêl hɨxôn nôn vô ông bê xomxo ti obêc vô paha lec lêm ge od ob tu Anutu nu mɨ la dô vac i ben lêm.” ");
INSERT INTO ptp_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Lêc Nikodimas nêl vô i ên nêbê, “Xomxo wê vô levac pyap ge ob vô paha lec tibêna? Obêc lax vac ta nɨlô dɨ yubac i tii vac, me?” ");
INSERT INTO ptp_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Lêc Yesu nêl vô i ên nêbê, “A nêl hɨxôn nôn vô ông bê xomxo ti obêc vô paha lec ya mia hɨxôn Myakɨlôhô Ngɨbua lêm ge od ob tu Anutu nu mɨ la dô vac i ben lêm. ");
INSERT INTO ptp_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Xomxo kɨbun ga kô nue kɨbun ga, dom Myakɨlôhô Ngɨbua obêc vông xomxo vô paha lec ge, od vông he tu Anutu nue. ");
INSERT INTO ptp_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Kɨyang wê a nêl ên a nêbê xam vô paha lec ge, le i lêc yetac ên kɨyang tige lêm. ");
INSERT INTO ptp_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Lea la vac vɨgwe vɨyang vɨyang ge, lêc il ngô nidɨdun pɨleva dɨ kehe, il o xovô wê lam ge lêm, dɨ ob loc tina ge, il lungên. Dɨ môp wê Myakɨlôhô Ngɨbua vông xomxo vô paha lec ge tɨyi bêge.” ");
INSERT INTO ptp_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Mêd Nikodimas luu i vya dɨ kɨnêg ên nêbê, “Kɨyang tige obêc vô nôn lec tibêna?” ");
INSERT INTO ptp_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Lêc Yesu nêl vô i ên nêbê, “Ông mi tɨxuu lime Islel ya xolac, lêc bêna lêc ông lungên kɨyang tige kehe? ");
INSERT INTO ptp_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","A nêl hɨxôn nôn vô ông bê xe nêl kɨyang wê xe xovô ge dɨ xe nêl kɨtong lec susu wê xe mamnôn yê ge, lêc xam o vông i vin kɨyang wê xe nêl ge lêm. ");
INSERT INTO ptp_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","A nêl kɨyang tɨxuuên lec susu kɨbun ga, lêc xam o vông i vin lêm. Om a obêc nêl kɨyang lec susu kɨsii ganê ge od xam ob xovô tibêna? ");
INSERT INTO ptp_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Xomxo ti o lec mɨ la lag puunê lêm. Xomxo Nu tibed wê lop mɨ lam gê lag puunê ge wê ob lec mɨ lax lag puunê tii vac nang. ");
INSERT INTO ptp_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Ilage Moses tul myel kɨnu lec xax vac vɨgwe mahɨgun pɨleva. Om Xomxo Nu, tɨbii obêc tul lec xax tɨyi bêge êno, ");
INSERT INTO ptp_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","dɨ xomxo vɨhati wê vông i vin i ge, he ob dô mavɨha luta lêc luta.” ");
INSERT INTO ptp_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Anutu xo vɨgwe pɨsiv ên xomxo kɨbun ga vɨhati luu vêl om vông nu tuc tibed lam, ên nêb xomxo obêc vông i vin i ge od he obêc yib mɨ la vac nipaên lêm. Nge, he ob dô mavɨha luta lêc luta. ");
INSERT INTO ptp_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Ên Anutu o vông nu tuc lam kɨbun ên nêb i lam vông myavɨwen nipaên vô xomxo lêm. Nge, vông i lam ên nêb i lam hôm he lec. ");
INSERT INTO ptp_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Xomxo wê vông i vin Anutu nu ge kɨyang ti o yêp vô he lêm. Lêc xomxo wê o vông i vin lêm ge he hɨlu nên kɨyang wê he ob yib mɨ la vac nipaên tɨmuên ge, ên he o vông i vin Anutu nu tuc nôn tibed ge lêm. ");
INSERT INTO ptp_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Myavɨwen wê xomxo ob kô ge, kehe bêga nêbê Yesu kô xêseac mɨ lam kɨbun ga lê, lêc xomxo xêyaa vin lec mapɨtoc dɨ he xona ên xêseac, ên môp wê he vông ge nipaên. ");
INSERT INTO ptp_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Xomxo vɨhati wê vông môp nipaên ge, he xona ên xêseac nêb he ob la vac lêm, ên he nêb xêseac ob hɨlung nipaên wê he vông ge lam le seac. ");
INSERT INTO ptp_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Dɨ xomxo vɨhati wê vông môp bôbac ge he lam le vac xêseac, ên nêb xêseac i nêl he kɨtong bê he vông yuac ya xêkɨzêc wê Anutu vông ge. ");
INSERT INTO ptp_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Pyap dêc Yesu he nue ngɨvihi la vɨgwe levac Judia dɨ la dô dɨ lipac xomxo ya. ");
INSERT INTO ptp_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Jon êno lipac xomxo gê Inon wê yêp kwabo vô Selim ge, ên mia levac yêp vac vɨgwe tige om xomxo la vô Jon dɨ Jon lipac he, ");
INSERT INTO ptp_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","ên Helot gên o tung Jon la vac kalabuhu lêm. ");
INSERT INTO ptp_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Jon nue ngɨvihi hɨxôn Yuda ti ngaênma lec môp wê mia lipacên ge. ");
INSERT INTO ptp_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Om Jon nue ngɨvihi la vô Jon dɨ nêl vô i ên nêbê, “Xolac kehe, xomxo ti wê dô hɨxôn ông ilage vô mia Jodan vɨlu ganê dɨ ông nêl i kɨtong ge, xomxo vɨhati la vô xomxo tyo dɨ i lipac he. Bêna lêc tyo vông tibêge?” ");
INSERT INTO ptp_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Mêd Jon nêl lax vô he ên nêbê, “Anutu lag puunê obêc vông nôn ti vô xomxo ti lêm ge od o tɨyi wê ob kô nôn ti ge lêm. ");
INSERT INTO ptp_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Xacxam va ngô kɨyang wê a nêl vô xam ilage ên a nêbê, ‘A o Kɨlisi ti wê il dô bin ge lêm, lêc Anutu vông a lam mug Kɨlisi môp.’ ");
INSERT INTO ptp_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Xomxo ti obêc ii vêx ge od vêx tige ob tu ici va vɨnê, lêc li ngwe obêc dô dɨ ngô li ngwe wê ob kô vêx tige vya ge od xêyaa obêc vô nivɨha. Om gwêbaga, a tɨyi xocbê lig ngwe ge, ên a xêgyaa vô nivɨha yang ên Yesu. ");
INSERT INTO ptp_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Om Yesu lê i vô levac dɨ a lêg i vô nipwo lec.” ");
INSERT INTO ptp_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Xomxo ti wê lam gê lag puunê ge luu xomxo vɨhati vêl. Ên xomxo kɨbun ga, kehe yêp gê kɨbun om ob nêl kɨyang lec susu kɨbun ga. Dom xomxo ti wê lam gê lag puunê ge ngɨnoo susu vɨhati vêl. ");
INSERT INTO ptp_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Xomxo tige nêl kɨyang lec susu wê yê dɨ ngô pyap ge, lêc xomxo ti o ngô dɨ vông i vin kɨyang wê nêl ge lêm. ");
INSERT INTO ptp_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Lêc xomxo wê ngô dɨ vông i vin kɨyang wê i nêl ge, vông vinên wê he vông ge nêl kɨtong nêbê Anutu ge xomxo kɨyang nôn. ");
INSERT INTO ptp_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Xomxo ti wê Anutu vông i lam ge, nêl Anutu kɨyang, ên Anutu vông Myakɨlôhô Ngɨbua hɨvun i xôn. ");
INSERT INTO ptp_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Ma Anutu xêyaa vin lec nu tuc, om vông susu vɨhati vac i vɨgê. ");
INSERT INTO ptp_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Xomxo ti obêc vông i vin Anutu nu ge od ob dô mavɨha luta lêc luta, lêc xomxo ti obêc hɨngoo nu tuc vya ge, od ob dô mavɨha luta lêm, ên xêyaa myavɨnê wê Anutu vông ge hɨvun i xôn pyap. ");
INSERT INTO ptp_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","He Palisi ngô kɨyang wê nêb Yesu kô xomxo tɨbeac dɨ lipac he luu wê Jon lipac ge vêl. ");
INSERT INTO ptp_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Yesu o lipac xomxo ti lêm. Nge, nue ngɨvihi môci lipac xomxo. ");
INSERT INTO ptp_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Mêd Yesu ngô wê he Palisi ngô kɨyang tige, om sea vɨgwe levac Judia ên nêb ob lax mɨ la Galili, ");
INSERT INTO ptp_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","mêd la vô môp Samelia, ");
INSERT INTO ptp_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","dɨ mɨla vɨgwe ti lê nêbê Saika wê yêp vac vɨgwe levac Samelia ge. Vɨgwe tige yêp kwabo vô kɨbun ti wê Jekop vông vô nu Josep ilage. ");
INSERT INTO ptp_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Lôva ti wê Jekop yev ilage mɨ mia lua vac ge yêp vac vɨgwe tige om xomxo lam mi kɨlê. Yesu mɨla, lêc ni ma vêl lec môp dia wê lam ge om mɨla dô kwabo vô mia tige. Ge tɨyi xocbê hɨyôv tyip kɨtôn. ");
INSERT INTO ptp_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Yesu vaci mɨla dô dɨ nue ngɨvihi la mug mɨ la ên nêb ob la kɨsuu yaên, dɨ Samelia vêx ti val ên nêb ob kɨlê mia om Yesu nêl vô i ên nêbê, “Kɨlê mia mɨ lam ên a ob num.” ");
INSERT INTO ptp_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Lêc vêx tyo nêl vô i ên nêbê, “Ông vux Yuda dɨ a vêx Samelia. Bêna lêc ông kɨtaa mia vô a?” Nêl bêge, ên Yuda yuu Samelia o mi keac vôma lêm. ");
INSERT INTO ptp_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Mêd Yesu nêl vô i ên nêbê, “Ông obêc xovô vɨzid wê Anutu vông ge dɨ ông obêc xovô xomxo ti wê nêl vô ông ên nêbê ông vông mia mɨ i num ge od ông obêc kɨtaa mia vô i dɨ i vông mia mavɨha vô ông.” ");
INSERT INTO ptp_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Lêc vêx tyo nêl vô i ên nêbê, “Xomxo levac, ông nêm dêg ma, dɨ mia tô mɨ lax ngɨbi ganê, om ông ob kɨlê mia mavɨha tige gê na? ");
INSERT INTO ptp_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Bug Jekop vông lôva tiga vô xe, dɨ i hɨxôn nue dɨ i bwoc, he xôn mi num vac, lêc mêd ông luu Jekop vêlê?” ");
INSERT INTO ptp_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Lêc Yesu nêl vô vêx Samelia tyo ên nêbê, “Xomxo vɨhati wê num mia tiga, he ob xo mia tii vac. ");
INSERT INTO ptp_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Lêc xomxo ti obêc num mia wê a vông ge od ob xo mia bê ob num i tii vac lêm. Ma vêl. Ên mia wê a ob vông vô i ge obêc pɨtuv vac i nɨlô dɨ vông i dô mavɨha luta lêc luta.” ");
INSERT INTO ptp_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Om vêx tyo nêl vô i ên nêbê, “Xomxo levac, ông vông mia tige vô a mɨ a num êdêc a xoên mia tiga i ma dɨ a lam kɨlêên tii vacên i ma.” ");
INSERT INTO ptp_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Yesu nêl vô i ên nêbê, “Loc keac lɨyam dɨ muu xôn lôm.” ");
INSERT INTO ptp_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Lêc vêx tige nêl ên nêbê, “A lɨyag ma.” Mêd Yesu nêl vô i ên nêbê, “Ông nêl vɨxôhɨlôg ên ông nêbê ông lɨyam ma. ");
INSERT INTO ptp_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Ên ilage ông kô vux vɨgê vɨlu lêc sea he dɨ vux wê dô hɨxôn ông gwêbaga ge, o ông lɨyam lêm. Om kɨyang wê ông nêl ge, ông nêl nôn.” ");
INSERT INTO ptp_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Mêd vêx tyo nêl vô i ên nêbê, “Xomxo levac, ga a xovô ên a nêbê ông plopete ti. ");
INSERT INTO ptp_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Xe buge lam mi kɨtaa vô Anutu lec kɨtôn tiga, lêcom xam Yuda nêl ên xam nêbê vɨgwe wê il ob kɨtaa vô Anutu ge, vɨgwe Jelusalem tibed.” ");
INSERT INTO ptp_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Mêd Yesu nêl vô i ên nêbê, “Vêx, ông vông i vin kɨyang wê a ob nêl ga bê tɨmuên ge xam obêc kɨtaa vô Mag lec kɨtôn tiga lêm, dɨ xam ob kɨtaa gê Jelusalem êno lêm. ");
INSERT INTO ptp_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Xam Samelia mi kɨtaa lê, lêc xam lungên xomxo wê xam mi kɨtaa vô i ge. Dɨ xe Yuda, Anutu wê xe mi kɨtaa vô ge, xe xovô pyap, ên xomxo ti wê ob vô xomxo vêl ên nipaên ge lam vac xe Yuda. ");
INSERT INTO ptp_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Buc ti obêc val, om gwêbaga buc tyo val pyap, om xomxo wê ob kɨtaa nôn ge, Myakɨlôhô Ngɨbua ob ngɨdu he xôn dɨ he ob kɨtaa vô Mag hɨxôn kɨyang nôn. Ên xomxo tibêgee wê Anutu xêyaa vin lec nêb he i kɨtaa vô i. ");
INSERT INTO ptp_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Anutu ge Myakɨlôhô, om xomxo obêc nêb kɨtaa vô i ge od Myakɨlôhô Ngɨbua i ngɨdu he xôn dɨ he i kɨtaa hɨxôn kɨyang nôn.” ");
INSERT INTO ptp_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Mêd vêx tyo nêl vô Yesu ên nêbê, “A xovô ên a nêbê Mesaia ti wê Anutu vɨnoo ge wê he nêl lê nêbê Kɨlisi ge obêc val. Dɨ obêc val ge od ob nêl kɨyang vɨhati kehe kɨtong vô il.” ");
INSERT INTO ptp_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Yesu nêl vô i ên nêbê, “A tyo ga mê, wê a dɨnêl kɨyang vô ông ga.” ");
INSERT INTO ptp_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Yesu nêl kɨyang tige, dɨ nue ngɨvihi vena yê wê Yesu dɨkeac hɨxôn vêx tige dɨ he yetac ên. Lêc he ti o nêl vô i lêm bê “Ông ob kô vatya? Dɨ ông keac vô vêx tige ên va?” ");
INSERT INTO ptp_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Mêd vêx tige sea dêg le dɨ lax mɨ la vɨyangtôv dɨ lax nêl vô xomxo tɨbeac ên nêbê, ");
INSERT INTO ptp_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Xam lam loc wê xomxo ti wê nêl kɨyang a vông ilage vɨhati kɨtong. Ganê mêd Kɨlisi ti wê il dô bin ge yuubê?” ");
INSERT INTO ptp_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Om he sea ben dɨ lam vô Yesu. ");
INSERT INTO ptp_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","He gên dɨlam dɨ Yesu nue ngɨvihi nêl vô Yesu ên nêbê, “Xolac kehe, wa yaên lê.” ");
INSERT INTO ptp_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Lêc Yesu nêl vô he ên nêbê, “Yaên wê a vông ge dô, lêcom xam lungên.” ");
INSERT INTO ptp_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Om nue ngɨvihi kɨnêg vôma ên nêbê, “Mêd xomxo ti vông yaên vô i?” ");
INSERT INTO ptp_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Lêc Yesu nêl vô he ên nêbê, “Yaên wê ob den a ge bêga bê a ob vông kɨyang yuu yuac wê xomxo ti wê vông a lam ge nêb a vông ge i loc pyap lê. ");
INSERT INTO ptp_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Xam nêl ên xam nêbê dentuc yuudɨyuu obêc lam la vêl dɨ xam ob la kô yaên nôn vac yuac. Lêc a ob nêl vô xam bê xam vêl mamnôn lec mɨ wê yuac, ên xomxo viac he pyap tɨyi wê xam ob la nêl xolac vô he ge, tɨyi xocbê susu vô nôn vac yuac ge. ");
INSERT INTO ptp_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Xomxo wê ob la kô nôn vac yuac ge ob kô nôn nivɨha lec yuac wê he vông ge dɨ ob kɨtuc nôn tige la dô nivɨha luta lêc luta. Om xomxo wê xin vê ge hɨxôn xomxo wê kô nôn ge, yuu xôn xêyaa vô nivɨha. ");
INSERT INTO ptp_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Om kɨyang wê nêl ên nêbê xomxo ngwe ob xin vê dɨ ngwe ob la kô nôn ge, kɨyang nôn. ");
INSERT INTO ptp_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","A vông xam la ên a nêb xam kô nôn vac yuac wê xam o vông ilage lêm ge. Yuac wê xomxo mugên vông pyap ge, xam ob la kô nôn vac.” ");
INSERT INTO ptp_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Tɨbii Samelia wê dô vac vɨgwe tige, he tɨbeac vông i vin Yesu ên wê vêx tige nêl ên nêbê, “Yesu nêl kɨyang wê a vông ilage vɨhati kɨtong.” ");
INSERT INTO ptp_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Mêd tɨbii Samelia la vô Yesu dɨ la kɨtaa i nêb i dô hɨxôn he, om Yesu dô hɨxôn he tɨyi buc yuu, ");
INSERT INTO ptp_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","dɨ xomxo tɨbeac hɨwocên ngô kɨyang wê Yesu nêl ge om he vông i vin. ");
INSERT INTO ptp_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Mêd he nêl vô vêx tyo ên nêbê, “Xe o vông i vin lec ông vyam wê ông nêl ge lêm. Nge, xecxe va ngô i vya om xe xovô ên xe nêbê xomxo ti wê ob hôm xomxo kɨbun ga vɨhati lec ge, xomxo tyo tiga vɨxôhɨlôg nôn.” ");
INSERT INTO ptp_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Yesu dô vac vɨgwe tige buc yuu dêc sea dɨ la Galili. ");
INSERT INTO ptp_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Yesu vaci nêl ila ên nêbê plopete ti lie vac ici va ben ob kô i lec nivɨha lêm. ");
INSERT INTO ptp_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Mêd Yesu mɨla Galili, dɨ tɨbii Galili hôm i lec nivɨha, ên he êno la yê buc ngɨbua gê Jelusalem om he yê môp vɨhati wê Yesu vông vô buc tige. ");
INSERT INTO ptp_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Mêd Yesu lax mɨ la Kena wê yêp vac vɨgwe levac Galili ge. Kena ge vɨgwe wê Yesu pɨlepac mia tu wain vac ilage. King nu hɨzap ti dô vac vɨgwe Kapaneam, lêc nu vux ti, yidac vông. ");
INSERT INTO ptp_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Mêd xomxo levac tyo ngô wê Yesu sea Judia dɨ lam dô Galili ge, om la vô Yesu dɨ la kɨtaa i ên nêb i loc Kapaneam ên loc vông i nu i vô nivɨha lec, ên nu vô kwabo lec wê ob yib ge. ");
INSERT INTO ptp_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Lêc Yesu nêl vô xomxo levac tyo ên nêbê, “Xam wêên do levac obêc ma ge od xam nêb xam ob vông i vin lêm.” ");
INSERT INTO ptp_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Mêd xomxo tyo nêl vô i ên nêbê, “Xomxo levac, lam lutibed ên a nug obêc yib.” ");
INSERT INTO ptp_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Mêgem Yesu nêl vô i ên nêbê, “Ông lôc, ên ông num obêc vô nivɨha lec.” Mêd xomxo tyo vông i vin kɨyang wê Yesu nêl ge dɨ lax. ");
INSERT INTO ptp_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Mɨla môp mahɨgun ti dɨ nue yuac ya val nêl vô i ên nêbê, “Num vô nivɨha lec.” ");
INSERT INTO ptp_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Mêd xomxo tyo kɨnêg vô he ên nêbê, “Yidac sea i lec hɨyôv manôn tina?” Om he nêl ên nêbê, “Vɨhevage wê hɨyôv kɨlê ge num ninɨvi vô ningɨgooên lec.” ");
INSERT INTO ptp_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Mêd ma xovô nêbê hɨyôv manôn tige wê Yesu nêl vô i nêbê nu vô nivɨha lec ge. Mêgem xomxo tige he vɨnê nue vɨhati vông i vin. ");
INSERT INTO ptp_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Buc wê Yesu sea Judia dɨ lax mɨ la Galili ge od vông do tiga wê vông yuu ge vac vɨgwe Galili. ");
INSERT INTO ptp_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Buc ya lam la vêl mêd buc levac wê Yuda vông ge ti vô kwabo lec om Yesu la Jelusalem. ");
INSERT INTO ptp_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Jelusalem ge, mia luaên ti yêp kwabo vô bwoc sipsip vuayen. Mia luaên tige, Hiblu vya nêbê Betesda, dɨ xumac nipwo vɨgê vɨlu le vô mia luaên tige nɨnya. ");
INSERT INTO ptp_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Xomxo yidac tɨbeac yêp vac xumac tigee, ya manôn toc, dɨ ya vɨxa vô nipaên dɨ ya len vô xêlehe. Xomxo tigee dô bin buc wê mia obêc vô mahɨlevac ge, ");
INSERT INTO ptp_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","ên buc ya Apumtau vông angela ti lam la vac mia nɨlô dɨ vông mia vô mahɨlevac, dɨ xomxo yidac ti obêc la vac mia wê vô mahɨlevac ge tax ge, od ninɨvi obêc vô nivɨha lec. ");
INSERT INTO ptp_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Vux ti yêp vac xumac tige, lêc yidac vông i tɨyi klismas kehe ti dɨ vɨgê yuu dɨ vɨxa vɨlu dɨ sec yon (38). ");
INSERT INTO ptp_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Mêd Yesu yê xomxo tige wê dɨyêp ge dɨ xovô nêbê yidac vông i tɨyi klismas tɨbeac, om kɨnêg vô i ên nêbê, “Ông nêb ông nimnɨvi i vô nivɨha lec, me?” ");
INSERT INTO ptp_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Mêd xomxo tyo nêl vô i ên nêbê, “Xomxo levac, vô buc wê mia vô mahɨlevac ge od a lige wê ob vông a la vac mia ge ti o dô lêm, om a nêb a ob la vac mia lê, lêc xomxo le luu a vêl dɨ la vac mia tax.” ");
INSERT INTO ptp_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Om Yesu nêl vô xomxo tyo ên nêbê, “Kɨdi lec mɨ kô ông guhu lec dɨ loc.” ");
INSERT INTO ptp_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Mêd lutibed xomxo tyo ninɨvi vô nivɨha lec dɨ i kô i guhu lec dɨ la. Buc tige, buc wê sabat ge, ");
INSERT INTO ptp_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","om he Yuda nêl vô xomxo ti wê Yesu vông i vô nivɨha lec ge ên nêbê, “Gwêbaga buc sabat, dɨ kɨyang yêp bêga nêbê ông ob kɨlê guhu lec sabat lêm.” ");
INSERT INTO ptp_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Lêc xomxo tyo nêl vô he ên nêbê, “Xomxo ti wê vông a vô nigvɨha lec ge nêl vô a ên nêbê, ‘Hôm ông guhu lec dɨ loc.’” ");
INSERT INTO ptp_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Om he kɨnêg vô i ên nêbê, “Xomxo letya wê nêl vô ông ên nêbê ông hôm guhu lec dɨ loc ge?” ");
INSERT INTO ptp_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Lêc xomxo tyo lungên, ên xomxo tɨbeac dô vac vɨgwe tige dɨ Yesu loc mɨ la vac he mahɨgun dɨ la. ");
INSERT INTO ptp_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Nang dɨ buc ngwe lêc Yesu mɨla tulec xomxo tyo vac Anutu xumac ngɨbua om nêl vô ên nêbê, “Wê lê. Ông nimnɨvi vô nivɨha lec. Om le i lêc vông nipaên ti i tii vac lêm, ên vɨyin levac mabu obêc val vô ông i luu ilage vêl.” ");
INSERT INTO ptp_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Mêd xomxo tige lax mɨ la vô he Yuda dɨ nêl ên nêbê, “Xomxo ti wê vông a vô nigvɨha lec ge Yesu.” ");
INSERT INTO ptp_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Mêgem he Yuda nêb ob vông vɨyin vô Yesu ên wê vông môp tige lec buc sabat ge. ");
INSERT INTO ptp_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Lêc Yesu nêl vô he ên nêbê, “Mag vông yuac lec buc vɨhati, dɨ a êno vông yuac bêge.” ");
INSERT INTO ptp_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Mêgem he Yuda yê Yesu xôn ên nêb ob hi i yib, ên wê vông sabat vô nipaên ge, lêc o sabat kɨyang tibed lêm. Nge, Yesu nêl ên nêbê “Anutu ge a mag”, om Yuda yê i tɨyi xocbê yong i nêb yuu xôn Anutu tɨyima. ");
INSERT INTO ptp_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Mêgem Yesu nêl vô he Yuda ên nêbê, “A nêl vɨxôhɨlôg nôn vô xam bê a Anutu nu, a o tɨyi wê a ob vông môp i tɨyi xovôên wê aca va vông ge lêm. Nge, môp wê a vông ge a vông vɨhati tɨyi môp wê Mag vông mɨ a xê ge. Môp wê Mag vông ge, a êno ob vông i tɨyi. ");
INSERT INTO ptp_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Ên Ma xêyaa vin lec nu tuc om hɨlung môp vɨhati wê i vông ge vô i, lêc do levac wê luu môp tigee vêl ge, Ma obêc hɨlung vô nu dɨ i vông om xam obêc yetac mabu ên do wê i vông ge. ");
INSERT INTO ptp_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Mag vông xomxo kɨdi lec vac yibên dɨ vông he dô mavɨha, dɨ nu tuc obêc vông xomxo wê vɨnoo he ge i dô mavɨha bêge êno. ");
INSERT INTO ptp_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Dɨ Mag ob yaxên xomxo ti nên kɨyang lêm. Nge, vô vac nu tuc vɨgê ên nêb i yaxên xomxo vɨhati nên kɨyang. ");
INSERT INTO ptp_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Ma vông bêge ên nêb xomxo vɨhati i pɨmil nu tuc lê i tɨyi xocbê he pɨmil Ma lê ge. Xomxo ti obêc pɨmil nu lêm ge od tɨyi xocbê o pɨmil Ma wê vông i lam ge lê lêm. ");
INSERT INTO ptp_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“A nêl hɨxôn nôn vô xam bê xomxo wê ngô a kɨyang dɨ vông i vin xomxo ti wê vông a lam ge, xomxo tigee ob dô mavɨha luta lêc luta, dɨ he ob tulec myavɨwen nipaên ti lêm, ên Anutu xovô pyap nêb ob vô he vêl ên yibên dɨ vông he dô mavɨha luta lêc luta. ");
INSERT INTO ptp_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","“A nêl hɨxôn nôn vô xam bê buc ti obêc val om val gwêba pyap, mêgem xomxo wê dô vac môp mayibên ge he ob ngô Anutu nu vya, dɨ he wê ngô ge ob dô mavɨha. ");
INSERT INTO ptp_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Mag ge mavɨha kehe, om vông mavɨha wê i vông ge vô nu tuc. ");
INSERT INTO ptp_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Ma vɨnoo nu tuc pyap ên nêb i yaxên xomxo vɨhati nên kɨyang, ên i Xomxo Nu. ");
INSERT INTO ptp_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Xam o lêc yetac dɨ nga vɨgêm ên kɨyang tiga lêm. Ên buc ti obêc val, dɨ tɨbii vɨhati wê yêp vac lôva ge obêc ngô i vya ");
INSERT INTO ptp_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","dɨ kɨdi mɨ lam, om he wê vông môp nivɨha ge obêc kɨdi lec mɨ dô mavɨha, dɨ he wê vông nipaên ge obêc kɨdi lec dɨ kô myavɨwen nipaên.” ");
INSERT INTO ptp_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“A o tɨyi wê a ob vông môp ti ya xovôên wê aca va vông ge lêm. Nge, a yaxên xomxo nên kɨyang tɨyi xocbê kɨyang wê a ngô vô Mag ge. Dɨ a yaxên xomxo nên kɨyang ya môp bôbac, ên a o tɨmu vô pɨyôp wê a vông ge lêm. Nge, xomxo ti wê vông a lam ge, a tɨmu vô kɨyang wê i vông ge. ");
INSERT INTO ptp_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Aca va obêc nêl a kehe kɨtong ge od obêc tɨyi lêm. ");
INSERT INTO ptp_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Lêc xomxo ti wê nêl a kehe kɨtong ge dô, dɨ a xovô ên a nêbê kɨyang wê xomxo tige nêl lec a ge kɨyang nôn. ");
INSERT INTO ptp_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","“Xam Yuda, xam vông xomxo la vô Jon ilage, dɨ Jon nêl kɨyang nôn kehe kɨtong. ");
INSERT INTO ptp_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","A o xo ên a nêb xomxo kɨbun ga i nêl a kehe kɨtong lêm. Lêc a nêb Anutu i vô xam vêl om a nêl kɨyang tiga kɨtong vô xam. ");
INSERT INTO ptp_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Jon ge tɨyi xocbê ngwax wê linac xêseac vô xam ge, om xam xêmyaa vô nivɨha dɨ xam dô vac xêseac wê i vông ge myabo tya. ");
INSERT INTO ptp_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Dɨ gwêbaga a lam vông yuac om yuac tige nêl a kehe kɨtong luu kɨyang wê Jon nêl ge vêl. Ên a lam vông yuac wê Mag nêb a vông ge, om yuac tige nêl a kehe kɨtong nêbê Mag vông a lam. ");
INSERT INTO ptp_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Dɨ Mag wê vông a lam ge, nêl a kehe kɨtong hɨxôn. Xam o ngô i vya lêm dɨ xam o wê i nôn lêm, ");
INSERT INTO ptp_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","dɨ kɨyang wê i vông ge o yêp vac xam nɨlôm lêm, ên Mag vông a lam, lêc xam o vông i vin a lêm. ");
INSERT INTO ptp_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Kɨyang wê yêp vac kɨpihac xolac ge, xam mi kɨtong ên xam xo ên xam nêbê mavɨha kehe luta yêp vac kɨyang tige. Dɨ xolac tige wê nêl a kehe kɨtong, ");
INSERT INTO ptp_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","lêc xam nêb xam ob lam vô a êdêc dô mamvɨha lêm. ");
INSERT INTO ptp_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“A o lam ên a nêb xomxo i vông lê levac vô a lêm. ");
INSERT INTO ptp_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Lêc a xovô ên a nêbê xam xêmyaa o vin lec Anutu lêm. ");
INSERT INTO ptp_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","A tu Mag manôn mɨ lam vô xam, lêc xam o kô a lec nivɨha lêm. Dɨ xomxo ti obêc lam vô xam lec ici va lê ge od xam kô i lec nivɨha. ");
INSERT INTO ptp_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Xam kô lêm levac vô lime vaci, dɨ lê levac wê Anutu tibed ob vông vô xomxo ge, xam nêb xam ob kô lêm. Om xam obêc vông i vin tibêna? ");
INSERT INTO ptp_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Xam o lêc xo bê a ob vông kɨyang vô xam vô Anutu manôn lêm. Xomxo wê ob vông kɨyang vô xam ge, Moses ti wê xam vông i vin ên xam nêbê obêc ngɨdu xam xôn ge. ");
INSERT INTO ptp_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Xam obêc vông i vin kɨyang wê Moses vông ge od xam obêc vông i vin kɨyang wê a vông ge hɨxôn, ên Moses ge wê kɨvuu kɨyang lec a. ");
INSERT INTO ptp_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Lêc xam o vông i vin kɨyang wê Moses kɨvuu ge lêm, om xam obêc vông i vin kɨyang wê a nêl ge tibêna?” ");
INSERT INTO ptp_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Yesu nêl kɨyang tige vêl dɨ tô mɨ sox la mia Galili vɨlu ganê. Mia tige lê ngwe nêbê Taibilias. ");
INSERT INTO ptp_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Mêd xomxo tɨbeac hɨwocên tɨmu vô Yesu vɨxa mɨ la, ên he yê do levac wê Yesu vông xomxo yidac vô nivɨha lec ge. ");
INSERT INTO ptp_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Mêd Yesu he nue ngɨvihi lec kɨtôn ti mɨ la dô lec. ");
INSERT INTO ptp_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Mêd buc ngɨbua wê Yuda ob yê Pasova ên xovô buc wê he sea Isip ilage vô kwabo lec. ");
INSERT INTO ptp_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Lêc Yesu yê xomxo tɨbeac val om nêl vô Pilip ên nêbê, “Il ob kɨsuu blet gê na mɨ vet xomxo tigae ya?” ");
INSERT INTO ptp_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Yesu xovô môp wê nêb ob vông ge pyap, lêc nêl kɨyang tige vô Pilip ên nêb ob yaxên i. ");
INSERT INTO ptp_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Mêd Pilip nêl vô i ên nêbê, “Il obêc kɨsuu blet lec mone yul yuu (K200) mɨ vông nipwo tyatya vô he ge od yaên tige obêc tɨyi he vɨhati lêm.” ");
INSERT INTO ptp_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Mêd nue ngɨvihi ngwe lê nêbê Andlu, wê Saimon Pita li ge nêl ên nêbê, ");
INSERT INTO ptp_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“A xê xomxo nipwo ti wê kô blet vɨgê vɨlu dɨ beac yuu, lêc yaên tige o tɨyi xomxo tɨbeac tigae lêm.” ");
INSERT INTO ptp_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Mêd Yesu nêl ên nêbê, “Xam vông xomxo vɨhati i tô mɨ dô kɨbun lê.” Vɨgwe tige hɨsinac nivɨha dô om he dô kɨbun lec. Xomxo tigee tɨbeac hɨwocên om vux vaci tɨyi xocbê 5,000. ");
INSERT INTO ptp_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","He dô kɨbun pyap mêd Yesu hôm blet tige dɨ kɨtaa lec mêd tɨtang vô xomxo vɨhati. Nang dêc vông bêge vô beac hɨxôn, mêd xomxo vɨhati ya dɨ i den he. ");
INSERT INTO ptp_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","He ya pyap, mêd Yesu nêl vô nue ngɨvihi ên nêbê, “Xam vɨlu myapɨpu wê he ya dɨ i dô gee mɨ tung i dô kɨdu ti, ên ti i o loc dô sea lêm.” ");
INSERT INTO ptp_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Mêgem he kɨtuc myapɨpu wê xomxo ya dɨ i dô gee mɨ su vac sepac vɨgê yuu dɨ tô mɨ la yuu mɨ i pup lec. ");
INSERT INTO ptp_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Xomxo tigee yê do levac wê Yesu vông ge om nêl ên nêbê, “Plopet ti wê he nêb ob lam kɨbun ge, tyo tiga vɨxôhɨlôg nôn.” ");
INSERT INTO ptp_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Mêd Yesu xovô wê he nêb he ob hôm i xôn dɨ vông i tu he nên king ge, om sea he dɨ ici va lax mɨ la lec kɨtôn. ");
INSERT INTO ptp_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Vɨgwe huc dɨ Yesu nue ngɨvihi lop mɨ la mia luaên nɨnya, ");
INSERT INTO ptp_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","dɨ lec la lec dipac ti dɨ la, ên nêb ob lax mɨ la Kapaneam wê yêp mia luaên vɨlu ganê. Dɨ vɨgwe buc lêc Yesu o mɨla vô he decdec lêm. ");
INSERT INTO ptp_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Mêd lea levac ti val om vông mia vô mahɨlevac xocbê ob kɨpyax he vac, ");
INSERT INTO ptp_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","om he hɨsoo mia mɨ la mahɨgun dia tya tɨyi xocbê 5 kilomita ge, lêc he yê wê Yesu lam lec mia kɨsii mɨ val kwabo vô dipac ge om he xonamabu. ");
INSERT INTO ptp_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Lêc Yesu nêl vô he ên nêbê, “Ga a, om xam xona ên i ma.” ");
INSERT INTO ptp_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Mêd he nêl vô Yesu ên nêb i lec lam lec dipac, dɨ lutibed dipac mɨla le kehe vô vɨgwe ti wê he nêb he ob la ge. ");
INSERT INTO ptp_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Vɨgwe vɨdiiên tɨtige, xomxo tɨbeac gên dô vô mia luaên nɨnya vɨlu ganê dɨ dô bin Yesu, ên he xovô ên he nêbê dipac tibed sea vɨgwe tige vɨhevage dɨ la, dɨ Yesu nue ngɨvihi heche va la lec dipac tige dɨ Yesu o la hɨxôn he lêm. ");
INSERT INTO ptp_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Mêd dipac mangwe lam gê vɨgwe Taibilias dɨ lam le vô vɨgwe ti wê Apumtau Yesu kɨtaa lec blet mɨ xomxo ya vɨhevage. ");
INSERT INTO ptp_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Mêd xomxo tigee yê lêc Yesu he nue ngɨvihi o dô lêm om he la lec dipac ti dɨ la ên nêb ob la myag Yesu gê Kapaneam. ");
INSERT INTO ptp_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Xomxo tigee mɨla yêvô Yesu gê mia luaên vɨlu ganê dɨ kɨnêg vô i ên nêbê, “Xolac kehe, ông lam ga yelacna?” ");
INSERT INTO ptp_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Lêc Yesu nêl vô he ên nêbê, “A nêl hɨxôn nôn vô xam bê xam myag a, lêc xam o xovô do levac wê a vông ge lêc lam myag a lêm. Nge, xam xovô blet wê xam wa i den xam ge om xam lam myag a. ");
INSERT INTO ptp_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Le i lêc vông yuac levac ên yaên wê ob vô nipaên ge lêm. Nge, xam vông yuac lec yaên wê xam ob kô dɨ dô mamvɨha luta ya ge. Yaên tige, a, Xomxo Nu, a obêc vông vô xam, ên Mag Anutu vɨnoo a pyap ên nêb a vông i yuac.” ");
INSERT INTO ptp_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Om he nêl vô i ên nêbê, “Xe ob vông Anutu yuac ga tibêna?” ");
INSERT INTO ptp_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Om Yesu luu he vya bêga nêbê, “Yuac wê Anutu vông ge bêga bê xam vông i vin xomxo ti wê Anutu vông i lam ge.” ");
INSERT INTO ptp_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","31","Mêd he kɨnêg vô i ên nêbê, “Om ông ob vông do levac tina ên xe xê dɨ vông i vinê? Ên buge ilage ya yaên mana vac vɨgwe mahɨgun pɨleva, tɨyi xocbê kɨyang wê yêp vac xolac bêga nêbê, ‘Ici va vông yaên lag puunê vô he mɨ he ya.’ Om ông ob vông do levac tibêge, me?” ");
INSERT INTO ptp_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Lêc Yesu nêl vô he ên nêbê, “A nêl vɨxôhɨlôg nôn vô xam bê Moses o vông yaên lag puunê vô xam lêm. Nge, Mag vaci wê vông yaên nôn lag puunê vô xam ge. ");
INSERT INTO ptp_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Yaên wê Anutu vông ge, lam gê lag puunê dɨ lam vông xomxo kɨbun ga dô mavɨha.” ");
INSERT INTO ptp_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Om he nêl vô i ên nêbê, “Xomxo levac, ông vông yaên tige vô xe i tɨyi buc vɨhati ên va.” ");
INSERT INTO ptp_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Om Yesu nêl vô he ên nêbê, “Aca va ga, a yaên wê ob vông xomxo dô mavɨha ge. Xomxo ti obêc lam vô a ge od vip obêc den i tii vac nang lêm, dɨ xomxo ti obêc vông i vin a ge od obêc xo mia ti i tii vac lêm. ");
INSERT INTO ptp_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","A nêl gwêba vô xam ên a nêbê xam wê a pyap lê, lêc xam o vông i vin lêm. ");
INSERT INTO ptp_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Xomxo wê Anutu vɨnoo nêb he i tu axe ge, vɨhati obêc lam vô a, dɨ xomxo ti obêc val vô a ge, od a obêc tii i lêm. ");
INSERT INTO ptp_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Ên a o lop mɨ lam gê lag puunê ên a nêb a ob vông i tɨyi xovôên wê aca va vông ge lêm. Nge, a lam ên a nêb a ob tɨmu vô kɨyang wê xomxo ti wê vông a lam ge nêl ge. ");
INSERT INTO ptp_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Xomxo ti wê vông a lam ge nêb a o lêc sea xomxo wê i vɨnoo nêb he i tu axe ge ti i dô xel lêm. Nge, nêb a lêc tɨpi vô he vɨhati i kɨdi lec vô buc tɨmuên. ");
INSERT INTO ptp_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Ên Mag nêl kɨyang yêp bêga nêbê xomxo wê yê nu tuc dɨ vông i vin ge, he vɨhati obêc dô mavɨha luta lêc luta, dɨ a obêc tɨpi vô he kɨdi lec vô buc tɨmuên.” ");
INSERT INTO ptp_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Mêd he Yuda ngô kɨyang wê Yesu nêl ên nêbê, “Aca va yaên wê a lop mɨ lam gê lag puunê,” om he kunac i dɨ nêl kɨyang ni nyagên lec i ");
INSERT INTO ptp_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","dɨ nêl ên nêbê, “Xomxo tige Yesu wê Josep nu ge, dɨ ta yuu ma il xovô. Bêna lêc nêl ên nêbê i lam gê lag puunê?” ");
INSERT INTO ptp_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Lêc Yesu nêl vô he ên nêbê, “Le i lêc ngaênma lec a lêm. ");
INSERT INTO ptp_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Ên xomxo ti o tɨyi wê ici va ob lam tɨmu vô a ge lêm. Mag wê vông a lam ge obêc dɨdii xomxo ti ge od obêc lam tɨmu vô a, dɨ a obêc tɨpi vô i kɨdi lec vô buc tɨmuên. ");
INSERT INTO ptp_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Kɨyang yêp vac kɨpihac wê plopete kɨvuu ilage bêga nêbê, ‘Anutu ob tɨxuu xomxo vɨhati.’ Om xomxo vɨhati wê ngô Mag kɨyang dɨ kô xovôên vô i ge ob lam vô a. ");
INSERT INTO ptp_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Ên xomxo ti o yê Mag lec manôn lêm. Nge, a wê a lam vô Anutu ge a tibed wê a xê i. ");
INSERT INTO ptp_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","A nêl hɨxôn nôn vô xam bê xomxo wê vông i vin ge obêc dô mavɨha luta lêc luta. ");
INSERT INTO ptp_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","A ga, yaên wê ob vông xomxo dô mavɨha luta. ");
INSERT INTO ptp_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Bume ilage wê ya yaên mana vac vɨgwe mahɨgun pɨleva ilage, he ya lêc yib. ");
INSERT INTO ptp_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Lêc yaên wê lam gê lag puunê ge, xomxo ti obêc ya ge od ob yib lêm. ");
INSERT INTO ptp_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","A ga yaên mavɨha wê a lop mɨ lam gê lag puunê. Om xomxo ti obêc ya yaên tiga ge od ob dô mavɨha luta lêc luta. Yaên wê a ob vông vô i ge, aca va lɨyôhô wê a ob vông, ên xomxo kɨbun ga i dô mavɨha.” ");
INSERT INTO ptp_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Mêgem Yuda ngaênma lec kɨyang tige dɨ nêl vôma ên nêbê, “Xomxo tige obêc vông i lɨyôhô mɨ il xa tibêna?” ");
INSERT INTO ptp_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Om Yesu nêl vô he ên nêbê, “A nêl hɨxôn nôn vô xam bêga bê xam obêc wa a, Xomxo Nu, lɨyôhô dɨ num a hi lêm ge od xam ob dô mamvɨha lêm. ");
INSERT INTO ptp_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Xomxo wê ya a lɨyôhô dɨ num a hi ge, he ob dô mavɨha luta lêc luta, dɨ a obêc tɨpi vô he kɨdi lec mavɨha vô buc tɨmuên. ");
INSERT INTO ptp_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Ên a lɨyôhô tu yaên nôn, dɨ a hi tu mia numên nôn. ");
INSERT INTO ptp_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Xomxo wê ya a lɨyôhô dɨ num a hi ge, he ob dô vac a nɨlôg dɨ a ob dô vac he nɨlô. ");
INSERT INTO ptp_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Mag mavɨha vông a lam, dɨ a dô magvɨha ya xêkɨzêc wê Mag vông ge. Om xomxo ti obêc ya a ge, od ob dô mavɨha ya xêkɨzêc wê a vông ge. ");
INSERT INTO ptp_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Tiga, yaên wê lam gê lag puunê ge, lêc o tɨyi xocbê yaên wê bume ya ila ila lêc yib ge lêm. Nge, yaên tiga wê xomxo obêc ya ge od ob dô mavɨha luta lêc luta.” ");
INSERT INTO ptp_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Yesu nêl kɨyang tige vô xomxo vac Yuda xumac lɨlo gê Kapaneam. ");
INSERT INTO ptp_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Xomxo wê mi la hɨxôn Yesu gee he tɨbeac ngô kɨyang tige wê Yesu nêl ge, om he nêl ên nêbê, “Kɨyang tiga vɨyin levac, om letya tɨyi wê ob ngô ge?” ");
INSERT INTO ptp_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Yesu xovô wê he nêl kɨyang tɨbeac tɨbeac lec tige om nêl vô he ên nêbê, “Kɨyang tige juda xam, me? ");
INSERT INTO ptp_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Xam obêc wê Xomxo Nu lax mɨ la vac vɨgwe ti wê dô vac ilage ge od xam obêc xo bêna? ");
INSERT INTO ptp_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Myakɨlôhô Ngɨbua tibed wê ob vông xomxo dô mavɨha, dɨ xêkɨzêc wê xomxo vông ge ti o tɨyi lêm. Kɨyang wê a nêl vô xam ga ge, a nêl lec Myakɨlôhô Ngɨbua wê ob vông xomxo dô mavɨha ge. ");
INSERT INTO ptp_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Lêc xam ya o vông i vin lêm.” Yesu nêl bêge, ên ilage Yesu xovô xomxo wê vông vinên obêc ma ge, dɨ xovô xomxo tya wê ob vông i vac tɨbii vevac vɨgê ge pyap. ");
INSERT INTO ptp_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Mêd Yesu nêl ên nêbê, “Kɨyang yêp bêge, om a nêl gwêba vô xam ên a nêbê xomxo ti o tɨyi wê ici va ob lam tɨmu vô a ge lêm. Mag obêc vông xêkɨzêc vô i ge od obêc lam vô a.” ");
INSERT INTO ptp_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Yesu nêl kɨyang tige pyap mêd xomxo wê mi dô hɨxôn i ge tɨbeac sea i dɨ o dô hɨxôn i tii vac nang lêm. ");
INSERT INTO ptp_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Om Yesu kɨnêg vô nue ngɨvihi vɨgê yuu dɨ tô mɨ la yuu ên nêbê, “Dɨ xacxam va ob sea a êno dɨ la mê?” ");
INSERT INTO ptp_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Lêc Saimon Pita nêl vô i ên nêbê, “Apumtau, xe ob la vô letya? Ên kɨyang wê ông vông ge wê ob vông xomxo dô mavɨha luta lêc luta. ");
INSERT INTO ptp_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Om xe vông i vin dɨ xovô ên xe nêbê ông ge xomxo ngɨbua wê Anutu vông ông lam ge.” ");
INSERT INTO ptp_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Mêd Yesu nêl vô he ên nêbê, “A vɨnoo xam vɨgê yuu dɨ tô mɨ la yuu, lêcom xam ti tu Seten xe.” ");
INSERT INTO ptp_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Yesu nêl kɨyang tige lec Judas wê Saimon Iskaliot nu ge. Ên Judas ge he vɨgê yuu dɨ tô mɨ la yuu ge ti, wê ob nêl Yesu kɨtong vô tɨbii vevac ge. ");
INSERT INTO ptp_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Pyap dêc Yesu la vɨlee vac vɨgwe levac Galili. Ên he Yuda wê dô Judia ge nêb ob hi Yesu i yib om Yesu nêb ob la vɨlee vac vɨgwe Judia lêm. ");
INSERT INTO ptp_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Mêd Yuda buc ngɨbua ti wê he nêb ob xovô buc wê xumac sel ge vô kwabo lec, ");
INSERT INTO ptp_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","om Yesu lie so vya vô i ên nêbê, “Sea vɨgwe ga dɨ loc Judia, ên nume i yê yuac wê ông mi vông ge hɨxôn. ");
INSERT INTO ptp_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Ên xomxo ti obêc nêb xomxo i xovô i ge od ob vông yuac xôpacên lêm. Om yuac wê ông mi vông ge, ông loc vông vô he manôn ên he tɨbeac i yê dɨ xovô.” ");
INSERT INTO ptp_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","He ge Yesu lie, lêc he o vông i vin i lêm om he nêl kɨyang tibêge. ");
INSERT INTO ptp_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Mêd Yesu nêl vô he ên nêbê, “A buc gên o vô kwabo lec lêm, dom xam ge, xam tɨyi wê xam ob la tɨyi buc vɨhati ge. ");
INSERT INTO ptp_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Xomxo kɨbun ga xêyaa ob vô myavɨnê vô xam lêm. Lêc he xêyaa vô myavɨnê vô a ên wê a nêl he nên nipaên kɨtong ge. ");
INSERT INTO ptp_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Om xacxam va loc wê buc ngɨbua tige, ên a ob loc hɨxôn xam lêm, ên buc wê a vông ge gên o vô kwabo lec lêm.” ");
INSERT INTO ptp_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Yesu nêl kɨyang bêge vô he dɨ dô Galili. ");
INSERT INTO ptp_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Yesu lie la mug mɨ la yê buc levac, dɨ Yesu vaci tɨmu vô he vɨxa. Lêc o la seac vô xomxo manôn lêm. Nge, xôpac ên he mɨ la. ");
INSERT INTO ptp_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Lêc he Yuda myag Yesu vô buc tige om he kɨnêg ên nêbê, “Xomxo tyo dô tina?” ");
INSERT INTO ptp_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Xomxo wê dô gee he keac kɨyang tɨbeac lec Yesu, om he ya nêl ên nêbê, “Ge xomxo nivɨha ti,” dɨ he ya nêl ên nêbê, “O xomxo nivɨha lêm, ên mi kɨtyoo xomxo.” ");
INSERT INTO ptp_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Lêc xomxo ti o nêl kɨyang tige seac mɨ xomxo tɨbeac ngô lêm, ên he xona ên Yuda levac. ");
INSERT INTO ptp_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Mɨla vô buc levac tigee mahɨgun dɨ Yesu la vac Anutu xumac ngɨbua dɨ la nêl xolac vô xomxo. ");
INSERT INTO ptp_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","He Yuda levac wê dô gee ngô Yesu kɨyang dɨ yetac mabu om nêl ên nêbê, “Xomxo tige xovô xolac tige tibêna? Ên xomxo ti o tɨxuu i lêm.” ");
INSERT INTO ptp_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Lêc Yesu luu he vya ên nêbê, “Kɨyang wê a nêl ga, o a kɨyang lêm. Nge, xomxo ti wê vông a lam ge, i kɨyang. ");
INSERT INTO ptp_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Xomxo ti obêc xovô nêb ob tɨmu vô kɨyang wê Anutu vông ge od ob xovô kɨyang wê a nêl ga kehe bê a nêl Anutu kɨyang me a nêl aca va kɨyang. ");
INSERT INTO ptp_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Ên xomxo ti obêc nêl ici va kɨyang ge od xovô nêb ob vông ici va lê i vô levac. Lêc xomxo ti obêc vông xomxo ti wê vông i lam ge lê i vô levac ge od i xomxo kɨyang nôn dɨ kɨyang kɨtyooên ti o yêp vac i nɨlô lêm. ");
INSERT INTO ptp_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","“Moses vông xolac vô xam ilage, lêc xam ti o tɨmu vô xolac vɨhati lêm. Bêna lêc xam nêb xam ob hi a xibê?” ");
INSERT INTO ptp_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Mêd xomxo tigee nêl vô i ên nêbê, “Letya nêb ob hi ôngê? Mêd vɨmwo nipaên ti dô vac ông nɨlôm om ông nêl kɨyang tibêge.” ");
INSERT INTO ptp_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Lêc Yesu nêl vô he ên nêbê, “Xam nga vɨgêm ên do levac tibed wê a vông lec sabat mɨ xam wê ge. ");
INSERT INTO ptp_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Om xam ngô lê. Moses nêl vô bume ilage ên nêb he i gôl nue vux ninɨvi. Vɨxôhɨlôg, môp tige kehe o yêp vô Moses lêm. Nge, yêp vô tɨvame vaci. Lêc xam mi gôl nume ninɨvi lec sabat. ");
INSERT INTO ptp_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Xam nêb xam ob tɨmu vô Moses xolac om xam mi gôl nume ninɨvi lec sabat. Bêna lêc xam kunac a ên wê a vông xomxo ti ninɨvi vô nivɨha lec vô sabat ge? ");
INSERT INTO ptp_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Le i lêc yaxên xomxo nên kɨyang vaxvax lêm. Nge, xam hɨvip kɨyang kehe lec dɨ tɨtô i yêp bôbac.” ");
INSERT INTO ptp_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Xomxo Jelusalem ya kɨnêg ên nêbê, “Xomxo ti wê he Yuda levac nêb ob hi i yib ge, tyo tiganê, me? ");
INSERT INTO ptp_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Wê lê. Xomxo tyo nêl kɨyang seac vac xomxo mahɨgun lê, lêc xomxo levac o nêl kɨyang ti vô i lêm. Mêd he xo ên he nêb ge Kɨlisi tyo, me? ");
INSERT INTO ptp_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Lêc xomxo tyo, il xovô i ben kehe, dɨ Kɨlisi wê ob val ge, il ob xovô ben kehe wê ob val vac ge lêm.” ");
INSERT INTO ptp_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Om Yesu nêl xolac vac Anutu xumac ngɨbua dɨ keac levac hɨxôn ên nêbê, “Xam nêb xam xovô a, dɨ xam xovô a bog kehe hɨxôn, me? Ên a o lam ya xovôên wê a vông ge lêm. Xomxo ti wê vông a lam ge, i xomxo kɨyang nôn. Xam ge xam lungên i, ");
INSERT INTO ptp_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","dɨ a ga, a xovô i pyap, ên a dô hɨxôn i dɨ i vông a lam.” ");
INSERT INTO ptp_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Mêgem xomxo tigee nêb ob hôm Yesu xôn, lêc Yesu buc gên o vô kwabo lec lêm, om xomxo ti o tɨyi wê ob hôm vɨgê lec i ge lêm. ");
INSERT INTO ptp_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Lêcom xomxo tɨbeac vông i vin nêbê Yesu ge Kɨlisi om he nêl ên nêbê, “Il nêd Kɨlisi obêc val ge od ob vông do levac luu do levac wê Yesu vông ge vêl lêm. Om Yesu ge Kɨlisi tyo mê.” ");
INSERT INTO ptp_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","He Palisi ngô wê xomxo nêl kɨyang tibêge lec Yesu ge, om xomxo levac wê mi si daa gee hɨxôn he Palisi, he vông xêhɨpu ya la vô Yesu ên nêb he i loc hôm Yesu xôn. ");
INSERT INTO ptp_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Lêc Yesu nêl vô he ên nêbê, “A ob dô hɨxôn xam myabo tya, dɨ a obêc lax mɨ la vô xomxo ti wê vông a lam ge. ");
INSERT INTO ptp_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Xam obêc myag a, lêc xam wêvôên a obêc ma, dɨ vɨgwe wê a ob la dô vac ge, xam ti ob la vac lêm.” ");
INSERT INTO ptp_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Mêd he Yuda levac nêl vôma ên nêbê, “Xomxo tyo nêb ob la na, lêc il xêên obêc ma? Mêd ob la vô Yuda wê la dô Glik ben ge ên nêl xolac vô he Glik, me? ");
INSERT INTO ptp_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Xomxo tyo nêl ên nêbê il ob myag i, lêc il xêvôên obêc ma, dɨ vɨgwe wê ob la dô vac ge, il ob la vac lêm. Om kɨyang tige kehe tibêna?” ");
INSERT INTO ptp_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Buc levac tigee mɨla vô myahɨpu wê ob tɨyôô vac ge dɨ buc tige buc levac wê luu baba vêl ge, om Yesu kɨdi lec vac he mahɨgun dɨ keac vya levac ên nêbê, “Xomxo ti obêc nêb num mia ge, od i lam vô a lê, ên a obêc vông mia mɨ i num. ");
INSERT INTO ptp_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Tɨyi xocbê kɨyang wê yêp vac xolac bêga nêbê, ‘Xomxo ti obêc vông i vin a ge od mia mavɨha obêc lam vac i nɨlô dɨ lop mɨ la.’” ");
INSERT INTO ptp_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Yesu nêl kɨyang tige lec Myakɨlôhô Ngɨbua wê ob val vô he wê vông i vin Yesu ge. Lêc buc wê Yesu nêl kɨyang tige, Myakɨlôhô Ngɨbua valên gên ma, ên Yesu gên o lax mɨ la dô vac xêseac lag puunê lêm. ");
INSERT INTO ptp_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Xomxo ngô kɨyang tige dɨ ya nêl ên nêbê, “Xomxo tiga, plopet ti wê il dô bin ge vɨxôhɨlôg.” ");
INSERT INTO ptp_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Dɨ he ya nêl ên nêbê, “Ge Kɨlisi.” Lêc he ya nêl ên nêbê, “Kɨlisi ob lam gê Galili lêm. ");
INSERT INTO ptp_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Ên kɨyang yêp vac xolac bêga nêbê Kɨlisi kehe yêp vac Devit om obêc lam gê Betlehem vac Devit ben.” ");
INSERT INTO ptp_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Mêgem xomxo tigee hɨbu he la yuu lec Yesu, ");
INSERT INTO ptp_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","dɨ he ya nêb ob hôm i xôn, lêc xomxo ti o hôm vɨgê lec i lêm. ");
INSERT INTO ptp_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Mêd xêhɨpue lax mɨ la vô xomxo levac wê mi si daa gee hɨxôn he Palisi, dɨ he kɨnêg vô xêhɨpue ên nêbê, “Bêna lêc xam o kô i mɨ lamê?” ");
INSERT INTO ptp_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Lêc xêhɨpue nêl vô he ên nêbê, “Kɨyang wê xomxo tyo mi nêl ge, xomxo ti o nêl kɨyang tibêge ila lêm.” ");
INSERT INTO ptp_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Om he Palisi nêl vô he ên nêbê, “Xomxo ge kɨtyoo xam êno. ");
INSERT INTO ptp_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Xomxo levac gae hɨxôn xe Palisi, xe ti o vông i vin xomxo tyo lêm. Ma vêl. ");
INSERT INTO ptp_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Dɨ xomxo tɨbeac wê ngô Yesu vya ge, he o vyac xovô Moses xolac lêm, om he vô nipaên pyap.” ");
INSERT INTO ptp_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Lêc Palisi ti lê nêbê Nikodimas wê la vô Yesu ilage dô hɨxôn he, om nêl vô lie Palisi ên nêbê, ");
INSERT INTO ptp_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“O tɨyi wê il ob vông kɨyang vô xomxo ti vaxvax ge lêm. Ên xolac wê il vông ge nêl ên nêbê il ob ngô xomxo nên kɨyang mɨ xovô môp wê i vông ge pyap tax lê.” ");
INSERT INTO ptp_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Lêc he so vya vô i ên nêbê, “Ông ge tɨbii Galili ti om ông ngɨdu i xônê? Ông obêc kɨtong xolac wê yêp vac kɨpihac ge od ông ob xovô bê plopet ti ob lam gê Galili lêm.” ");
INSERT INTO ptp_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Pyap dêc he vɨhati sea dɨ toto ge la ben. ");
INSERT INTO ptp_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Mêd Yesu lec mɨ la lec kɨtôn Oliv, ");
INSERT INTO ptp_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","dɨ vɨgwe vɨdiiên tɨtige lax mɨ la vac Anutu xumac ngɨbua. Mêd xomxo tɨbeac kɨtuc la vô i om Yesu dô dɨ vông xolac vô he. ");
INSERT INTO ptp_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Mêd xomxo wê xovô Moses xolac gee hɨxôn he Palisi, he yê vêx ti wê vông yôdac ge om kô vêx tyo mɨ la lax vac he mahɨgun. ");
INSERT INTO ptp_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Mêd he nêl vô Yesu ên nêbê, “Xolac kehe, vêx tiga vông môp yôdac mɨ xe xê. ");
INSERT INTO ptp_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Moses nêl vac xolac ên nêbê vêx tibêga, xomxo ob hi ya ngɨdax ên i yib. Om ông ob nêl bêna lec i?” ");
INSERT INTO ptp_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","He nêl bêge, nêb ob yaxên Yesu bêc obêc nêl kɨyang ti so ge od he ob vông kɨyang vô i. Lêc Yesu yu kwa vac dɨ so kɨbun ya vɨgê lɨyihi. ");
INSERT INTO ptp_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Mêd he kɨnêg tii vac vac vô Yesu, om Yesu kɨdi mɨ le kɨsii dɨ nêl vô he ên nêbê, “Xomxo ti vac xam mahɨgun wê xovô nêb nipaên ti o yêp vô i lêm ge od i hôm ngɨdax mɨ nêx vêx tiga ya taxlee.” ");
INSERT INTO ptp_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Mêd Yesu yu kwa vac dɨ so kɨbun tii vac. ");
INSERT INTO ptp_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Xomxo tigee ngô kɨyang wê Yesu nêl ge dɨ xovô nên nipaên om ti ti le lop mɨ la vɨxun. He levac la mug dɨ he ba lop mɨ tɨmu vô he vɨxa, dɨ Yesu vaci hɨxôn vêx tyo wê yuu xeedô. ");
INSERT INTO ptp_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Mêd Yesu kɨdi mɨ le kɨsii dɨ nêl vô vêx tyo ên nêbê, “Vêx, xomxo tigae la na? Ti dô wê ob vông kɨyang vô ông ge, me?” ");
INSERT INTO ptp_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Lêc vêx tyo nêl vô i ên nêbê, “Xomxo levac, ti dôên ma.” Om Yesu nêl vô i ên nêbê, “Om a êno, a ob vông kɨyang vô ông lêm. Ông loc, dɨ le i lêc vông nipaên ti i tii vac lêm.” ");
INSERT INTO ptp_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Yesu nêl vô xomxo tigee tii vac ên nêbê, “A xêseac wê linac lec kɨbun. Xomxo ti obêc tɨmu vô a ge, od ob la vac mapɨtoc lêm. Nge, ob dô vac xêseac wê ob vông i vô paha lec dɨ vông i dô mavɨha ge.” ");
INSERT INTO ptp_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Om Palisi nêl vô i ên nêbê, “Ôcông va nêl ông kehe kɨtong om kɨyang wê ông nêl ge o tɨyi lêm.” ");
INSERT INTO ptp_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Mêlêc Yesu nêl vô he ên nêbê, “Vɨxôhɨlôg, aca va nêl a kehe kɨtong, lêc kɨyang wê a nêl ga, ge kɨyang nôn, ên a xovô vɨgwe kehe wê a lam vac ge, dɨ a xovô vɨgwe wê a ob lax mɨ la vac ge. Dɨ xam ge, xam o xovô a bog kehe wê a lam vac ge lêm, dɨ xam o xovô vɨgwe ti wê a ob lax vac ge lêm. ");
INSERT INTO ptp_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Xam yaxên xomxo nên kɨyang ya xovôên wê xacxam vông ge, dɨ a ga, a o yaxên xomxo ti nên kɨyang lêm. ");
INSERT INTO ptp_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Lêc a obêc nêb yaxên xomxo ti nên kɨyang ge od a ob yaxên i nên kɨyang ya môp bôbac, ên o aca va wê a ob yaxên xomxo nên kɨyang ge lêm. Nge, Mag wê vông a lam ge dô hɨxôn a. ");
INSERT INTO ptp_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Kɨyang ti yêp vac xolac wê xam vông ge bêga nêbê xomxo yuu obêc nêl kɨyang tɨyima lec kɨyang tibed ge od kɨyang wê yuu nêl ge kɨyang nôn. ");
INSERT INTO ptp_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","A nêl a kehe kɨtong dɨ Mag wê vông a lam ge nêl a kehe kɨtong hɨxôn.” ");
INSERT INTO ptp_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Mêd he kɨnêg vô Yesu ên nêbê, “Mam dô gê na?” Lêc Yesu nêl vô he ên nêbê, “Xam lungên a dɨ xam lungên Mag êno. Xam obêc xovô a ge od xam obêc xovô Mag hɨxôn.” ");
INSERT INTO ptp_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Yesu nêl xolac vô xomxo vac Anutu xumac ngɨbua, vac nɨlô ti wê he tung mone daa vac ge, om nêl kɨyang tige hɨxôn vô he. Lêc xomxo ti o hôm i xôn lêm, ên buc wê i vông ge o vô kwabo lec lêm. ");
INSERT INTO ptp_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Nang dêc Yesu nêl tii vac vô he ên nêbê, “A ob sea xam dɨ la, dɨ xam obêc myag a, lêc xam obêc wib hɨxôn nêm nipaên, ên vɨgwe wê a ob la vac ge xam obêc la vac lêm.” ");
INSERT INTO ptp_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Mêgem he Yuda nêl vôma ên nêbê, “Xomxo tige nêl ên nêb il ob la vac vɨgwe wê ob la dô vac ge lêm. Mêd ici va obêc hi i yib, me?” ");
INSERT INTO ptp_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Mêd Yesu nêl vô he ên nêbê, “Xam ge kɨbun, dɨ a ga kɨsii ganê. Xam xomxo kɨbun, dɨ a ga, a o xomxo kɨbun lêm. ");
INSERT INTO ptp_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Kɨyang bêge om a nêl vô xam gwêba ên a nêbê xam obêc wib hɨxôn nêm nipaên. Ên xam obêc vông i vin bê a Anutu nu lêm ge, od xam obêc wib hɨxôn nêm nipaên.” ");
INSERT INTO ptp_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Om he kɨnêg vô Yesu ên nêbê, “Ông letya?” Lêc Yesu nêl vô he ên nêbê, “Bêna lêc a ob nêl kɨyang tii vac vac vô xamê? A ga, xomxo ti wê a nêl vô xam ilage. ");
INSERT INTO ptp_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","A kɨyang wê a ob nêl vô xam dɨ yaxên xam ge tɨbeac yêp. Lêc xomxo ti wê vông a lam ge, i kɨyang nôn om kɨyang wê a ngô vô i ge, a nêl kɨtong vô xomxo kɨbun ga.” ");
INSERT INTO ptp_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Kɨyang wê Yesu nêl vô he ge, he o xovô bê Yesu nêl lec Ma Anutu lêm, ");
INSERT INTO ptp_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","om Yesu nêl vô he ên nêbê, “Buc wê xam obêc hi Xomxo Nu lec xax ge od xam obêc xovô bê a Anutu nu mê, dɨ xam obêc xovô bê yuac wê a vông ge a o vông ya xovôên wê aca vông ge lêm. Nge, a nêl kɨyang tɨyi kɨyang wê Mag vông vô a ge. ");
INSERT INTO ptp_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Mag wê vông a lam ge dô hɨxôn a dɨ o sea a dô tamaên lêm, ên a vông yuac wê Mag ob yê nivɨha ge tɨyi buc vɨhati.” ");
INSERT INTO ptp_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Yesu nêl kɨyang tige om xomxo tɨbeac vông i vin i. ");
INSERT INTO ptp_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Yesu nêl vô xomxo Yuda wê vông i vin i ge ên nêbê, “Xam obêc hôm a kɨyang xôn pɨlihi mɨ dô vac ge od xam tu a nuge vông vinên nôn. ");
INSERT INTO ptp_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Xam obêc xovô kɨyang nôn, dɨ kɨyang nôn obêc pɨwelac xam vêl dɨ xam dô nimvɨha.” ");
INSERT INTO ptp_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Lêc he nêl vô Yesu ên nêbê, “Xe ga Eblaham bue, om xe o la vac xomxo ti kwa ngɨbi ila mɨ tu he nue yuac lêm. Lêc bêna lêc ông nêl ên ông nêbê kɨyang tige obêc pɨwelac xe vêl ên tɨbii levac wê viac xe ge?” ");
INSERT INTO ptp_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Om Yesu nêl vô he ên nêbê, “A nêl hɨxôn nôn vô xam bê xomxo vɨhati wê dô vac nipaên ge, he tu nipaên tige nue yuac pyap. ");
INSERT INTO ptp_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Dɨ nue yuac ti o tɨyi wê ob dô vac xumac luta ge lêm. Nge, xomxo levac nu vaci wê ob dô vac luta. ");
INSERT INTO ptp_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Om Anutu nu obêc pɨwelac xam vêl ge, od xam obêc dô nimvɨha nôn dɨ nipaên ti ob pɨtii lec xam lêm. ");
INSERT INTO ptp_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","A xovô ên a nêbê xam ge Eblaham bue, lêcom xam nêb xam ob hi a xib, ên kɨyang wê a vông ge o yêp vac xam nɨlôm lêm. ");
INSERT INTO ptp_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Kɨyang wê a nêl ge a nêl i tɨyi wê a xê vô Mag ge, dɨ xam ge, xam vông i tɨyi wê xam ngô vô mam ge.” ");
INSERT INTO ptp_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Mêd he nêl vô Yesu ên nêbê, “Xe mag Eblaham.” Lêc Yesu nêl vô he ên nêbê, “Xam obêc Eblaham nue nôn ge od xam obêc vông môp i tɨyi wê Eblaham vông ge. Lêc xam o vông môp tɨyi wê Eblaham vông ge lêm. ");
INSERT INTO ptp_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","A nêl kɨyang nôn wê a ngô vô Anutu ge vô xam, lêc xam nêb xam ob hi a xib. Môp wê Eblaham vông ge ti o yêp bêge lêm. ");
INSERT INTO ptp_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Xam vông môp tɨyi xocbê mam mi vông ge.” Mêd he nêl vô Yesu ên nêbê, “Xe o tɨyi xocbê nipwo wê ta kô vax dɨ ma ma ge lêm. Xe mag Anutu tibed wê dô ge.” ");
INSERT INTO ptp_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Lêc Yesu nêl vô he ên nêbê, “Anutu obêc xam mam vɨxôhɨlôg nôn ge od xam xêmyaa obêc vin lec a, ên a dô hɨxôn Anutu lêc lam. Dɨ a o lam i tɨyi xovôên wê a vông ge lêm. Nge, Anutu vông a lam. ");
INSERT INTO ptp_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Xam o xovô kɨyang wê a nêl ga lêm, kehe bêga nêbê xam nêb xam ob ngô a vyag lêm. ");
INSERT INTO ptp_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","“Xam mam ge Seten, om kɨyang wê yêp vac mam nɨlô ge, xam nêb xam ob tɨmu vô mɨ vông i vô nôn lec. Buc taxlee ilage Seten mi hi xomxo yib dɨ o dô vac kɨyang nôn lêm, ên kɨyang nôn ti o yêp vac i nɨlô lêm. Dɨ kɨyang wê mi nêl ge, nêl i tɨyi kɨyang kɨtyooên wê yêp vô i ge, ên i xomxo kɨtyooên wê tu kɨyang kɨtyooên kehe. ");
INSERT INTO ptp_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Dɨ a ga, a lam nêl kɨyang nôn om xam nêb xam ob vông i vin kɨyang wê a nêl ge lêm. ");
INSERT INTO ptp_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Xam letya tɨyi wê xam ob nêl a nêg nipaên seac ge? A nêl kɨyang nôn lê, lêc bêna lêc xam o vông i vin a lêmê? ");
INSERT INTO ptp_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Anutu nue ob ngô kɨyang wê Anutu nêl ge. Lêc xam o Anutu nue lêm, om xam o ngô i vya lêm.” ");
INSERT INTO ptp_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","He Yuda luu Yesu vya ên nêbê, “Xe nêl vɨxôhɨlôg nôn ên xe nêbê ông tɨbii Samelia wê vɨmwo nipaên dô vac ông nɨlôm ge.” ");
INSERT INTO ptp_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Lêc Yesu nêl ên nêbê, “Vɨmwo nipaên ti o dô vac a nɨlôg lêm. A vông Mag lê vô levac, lêc xam vông a lêg tô sea. ");
INSERT INTO ptp_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","A o nêb a ob vông a lêg i vô levac lêm, lêc xomxo ti dô wê ob vông a lêg i vô levac, dɨ xomxo tige wê ob yaxên xomxo nên kɨyang. ");
INSERT INTO ptp_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","A nêl hɨxôn nôn vô xam bê xomxo ti obêc tɨmu vô kɨyang wê a vông ge od xomxo tige yibên obêc ma vêl.” ");
INSERT INTO ptp_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Mêgem Yuda tigee nêl vô Yesu ên nêbê, “Om gwêbaga xe xovô ên xe nêbê vɨmwo nipaên ti dô vac ông nɨlôm. Ên Eblaham hɨxôn plopete ilage, he yib mɨ la vêl, lêc ông nêl ên ông nêbê xomxo ti obêc tɨmu vô kɨyang wê ông vông ge od obêc yib gê kɨbun ga lêm. ");
INSERT INTO ptp_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Mêd ông ngɨnoo il bug Eblaham vêl, me? Ên Eblaham yib dɨ plopete êno yib. Dɨ ông nêb ông ob vông ông tɨyi letya?” ");
INSERT INTO ptp_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Mêd Yesu nêl vô he ên nêbê, “Aca va obêc pɨmil a lêg ge od obêc tɨyi xocbê kɨyang pɨleva, lêc xomxo ti wê pɨmil a lêg ge, Mag vaci, wê xam mi nêl ên xam nêbê xam Anutu. ");
INSERT INTO ptp_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Lêc xam o xovô i lêm. Dɨ a ga, a xovô i. A obêc nêl bê a lungên Mag ge od a obêc xomxo kɨtyooên tɨyi xocbê xam ge. Lêc a xovô i pyap om a tɨmu vô kɨyang vɨhati wê i vông ge. ");
INSERT INTO ptp_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","“Ilage bum Eblaham xêyaa vô nivɨha ên nêb ob yê buc wê a vông ge, om yê buc tige dɨ xêyaa vô nivɨha.” ");
INSERT INTO ptp_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Lêc he Yuda nêl vô Yesu ên nêbê, “Klismas wê ông vông ge gên o mɨla vô kehe yuu dɨ vɨgê yuu (50) lêm, lêc bêna lêc ông nêb ông wê Eblahamê?” ");
INSERT INTO ptp_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Mêd Yesu nêl vô he ên nêbê, “A nêl hɨxôn nôn vô xam bê buc wê Eblaham gên ma ge od a dô tax.” ");
INSERT INTO ptp_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","He ngô Yesu kɨyang tige om he hôm ngɨdax ên nêb ob nêx Yesu, lêc Yesu xôpac ên he dɨ sea Anutu xumac ngɨbua dɨ la vɨxun. ");
INSERT INTO ptp_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Yesu mɨla, lêc yê xomxo ti wê yubac hɨxôn ma tocên ge. ");
INSERT INTO ptp_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Mêd Yesu nue ngɨvihi kɨnêg vô Yesu ên nêbê, “Xolac kehe, letya vông nipaên lêc xomxo tige yubac hɨxôn ma tocên? Xomxo tige vaci vông nipaên, me ta yuu ma?” ");
INSERT INTO ptp_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Lêc Yesu nêl vô he ên nêbê, “Ge o ici va nên nipaên, me ta yuu ma nên nipaên wê vông i manôn toc ge lêm. Xomxo tige dô hɨxôn ma tocên ên Anutu nêb ob hɨlung xêkɨzêc wê i vông ge i yêp seac lec xomxo tige. ");
INSERT INTO ptp_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Xomxo ti wê vông a lam ge, il ob vông yuac wê i vông ge vô vɨdiiên xêseac, ên mapɨtoc obêc val dɨ a xib ge od xomxo ti o tɨyi wê ob vông yuac ge lêm. ");
INSERT INTO ptp_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Buc wê a dô kɨbun ga ge, od xêseac wê a vông ge linac vô xomxo gê kɨbun.” ");
INSERT INTO ptp_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Yesu nêl bêge dɨ pɨsuv myaluc lec kɨbun dɨ pɨlepac i vô niluc dɨ lipac vô xomxo matocên tyo manôn, ");
INSERT INTO ptp_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","dɨ nêl vô i ên nêbê, “Loc lipac mamnôn vac mia luaên Siloam.” Lê Siloam ge kehe bêga nêbê vông i la. Om xomxo tyo la lipac manôn dɨ manôn seac dɨ i lax mɨ la ben. ");
INSERT INTO ptp_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Mêd xomxo tige lie vɨyangtôv hɨxôn xomxo wê yê wê mi kɨtaa mone vô xomxo ge, he nêl vôma ên nêbê, “Xomxo ti wê mi dô dɨ kɨtaa mone vô xomxo ge, ge mêd xomxo tyo tige mê, me?” ");
INSERT INTO ptp_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Mêd he ya nêl ên nêbê, “Ge xomxo tyo tige mê.” Lêc he ya nêl ên nêbê, “Ge o xomxo tyo lêm. Ge xomxo wê yuu manôn tɨyima ge ngwe.” Om xomxo tyo nêl vô he ên nêbê, “A ga mê.” ");
INSERT INTO ptp_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Om he kɨnêg vô i ên nêbê, “Vatya vông ông mamnôn vô nivɨha lecê?” ");
INSERT INTO ptp_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Mêd xomxo tyo nêl vô he ên nêbê, “Xomxo ti lê nêbê Yesu ge pɨlepac myaluc hɨxôn kɨbun dɨ lipac lec a magnôn dɨ nêl vô a ên nêb a la lipac magnôn vac mia luaên Siloam. Om a la lipac dɨ a magnôn vô nivɨha lec dɨ a xê vɨgwe.” ");
INSERT INTO ptp_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Om he kɨnêg vô i ên nêbê, “Xomxo tyo dô gê na?” Lêc xomxo tyo nêl ên nêbê, “A lungên.” ");
INSERT INTO ptp_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Mêgem he kô xomxo ma tocên tyo mɨ la vô he Palisi. ");
INSERT INTO ptp_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Buc wê Yesu pɨlepac kɨbun vô nubuluc dɨ vông xomxo tyo manôn vô nivɨha lec ge, buc sabat, ");
INSERT INTO ptp_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","om he Palisi kɨnêg vô xomxo tyo tii vac ên nêbê, “Vatya vông ông mamnôn vô nivɨha lec?” Om xomxo tyo nêl vô he ên nêbê, “Xomxo tige lipac kɨbun nubuluc lec a magnôn dɨ a la lipac, lêc a magnôn seac.” ");
INSERT INTO ptp_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Mêd Palisi ya nêl ên nêbê, “Xomxo tige Anutu o vông i lam lêm, ên o tɨmu vô môp wê sabat ge lêm.” Lêc he ya nêl ên nêbê, “Xomxo tige obêc xomxo nipaên ge od o tɨyi wê ob vông do levac tibêge lêm.” Om he hɨbuma dɨ le kɨdu yuu. ");
INSERT INTO ptp_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Mêgem Palisi la kɨnêg vô xomxo tyo tii vac nang ên nêbê, “Xomxo ti wê vông mamnôn vô nivɨha lec ge, ông nêbê vatya lec i?” Mêd xomxo tyo nêl ên nêbê, “Ge plopete ti.” ");
INSERT INTO ptp_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","He Yuda o vông i vin bê xomxo tige manôn toc ila lêc vô nivɨha lec lêm, om he keac xomxo tyo ta yuu ma lam ");
INSERT INTO ptp_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","dɨ kɨnêg vô yuu ên nêbê, “Muu num tiga wê muu nêb yubac hɨxôn ma tocên mê? Vatya vông manôn seac mɨ i yê vɨgwe?” ");
INSERT INTO ptp_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Om ta yuu ma nêl ên nêbê, “Xii xovô ên xii nêbê ga xii nug wê yubac hɨxôn ma tocên ge. ");
INSERT INTO ptp_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Lêc môp wê manôn seac dɨ i yê vɨgwe ge, xii lungên, dɨ xii o xovô xomxo ti wê vông i manôn seac ge lêm. Xam loc kɨnêg vô ici va, ên vô levac pyap tɨyi wê ob nêl kɨyang kɨtong vô xam ge.” ");
INSERT INTO ptp_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Ta yuu ma nêl kɨyang bêge, ên yuu xona ên he Yuda levac. Ên he Yuda hɨlu kɨyang pyap ên nêbê xomxo ti obêc nêl Yesu kɨtong bê i Kɨlisi ge od he ob tii i vêl ên xumac lɨlo dɨ i loc dô nɨnya. ");
INSERT INTO ptp_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","He Yuda nêl bêge om xomxo tige ta yuu ma nêl ên nêbê, “Vô levac pyap om xam kɨnêg vô ici va.” ");
INSERT INTO ptp_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Om he Palisi keac xomxo ti wê manôn toc ilage lôm tii vac nang dɨ nêl vô i ên nêbê, “Ông pɨmil Anutu môci lê. Ên xe xovô ên xe nêbê xomxo tige nipaên.” ");
INSERT INTO ptp_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Lêc xomxo tyo nêl vô he ên nêbê, “A lungên, xomxo tige nivɨha me nipaên. Dɨ a xovô tibed bêga bê ilage a magnôn toc lêc gwêbaga a magnôn seac.” ");
INSERT INTO ptp_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Mêd he kɨnêg vô i ên nêbê, “Xomxo tige vô va vô ông lêc ông mamnôn seacê?” ");
INSERT INTO ptp_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Lêc xomxo tyo ni nyag vô he om nêl ên nêbê, “A nêl vô xam lê, lêc xam o ngô lêm. Bêna lêc xam nêb a nêl i tii vacê? Mêd xam êno, xam nêb xam ob tu i nue hɨxônê?” ");
INSERT INTO ptp_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Mêd he nêl kɨyang nipaên lec i ên nêbê, “Ông ge, ông tu xomxo tige nu ti, dɨ xe ga, xe tu Moses nue. ");
INSERT INTO ptp_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Xe xovô ên xe nêbê Anutu nêl kɨyang vô Moses, lêc xomxo tige, xe o xovô bê lam gê na?” ");
INSERT INTO ptp_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Mêd xomxo tyo nêl vô he ên nêbê, “Kɨyang tige obêc kehe tibêna? Ên xam nêl ên xam nêbê xam o xovô xomxo tige ben kehe lêm, lêc xomxo tige vông a magnôn seac. ");
INSERT INTO ptp_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Il xovô ên il nêbê xomxo wê vông môp nipaên ge, Anutu ob ngô he vya lêm. Lêc xomxo ti obêc kɨtaa vô Anutu dɨ tɨmu vô kɨyang wê i vông ge od Anutu ob ngô i vya. ");
INSERT INTO ptp_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Buc taxlee ilage dɨ i val tyip lec gwêbaga, il o ngô kɨyang lec xomxo ti wê yubac hɨxôn ma tocên lêc xomxo ngwe vông i manôn seac ge lêm. ");
INSERT INTO ptp_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Anutu obêc vông xomxo tige lam lêm ge od o tɨyi wê ob vông môp tibêge lêm.” ");
INSERT INTO ptp_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Mêd he Palisi nêl vô xomxo tyo ên nêbê, “Tam kô ông hɨxôn nipaên, lêc ông nêb ông ob nêl kɨyang vô xe?” Mêd he tii i la nɨnya. ");
INSERT INTO ptp_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Yesu ngô wê he tii xomxo tige la nɨnya ge om tulec i dɨ kɨnêg vô i ên nêbê, “Ông vông i vin Xomxo Nu, me?” ");
INSERT INTO ptp_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Lêc xomxo tyo nêl ên nêbê, “Xomxo levac, Xomxo Nu ge letya? Ông nêl kɨtong vô a ên a vông i vin i.” ");
INSERT INTO ptp_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Om Yesu nêl vô i ên nêbê, “Ông wê i pyap, ên xomxo tyo, a ga wê a keac vô ông mê.” ");
INSERT INTO ptp_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Mêgem xomxo tyo nêl ên nêbê, “Apumtau, a vông i vin.” Mêd yev vɨxa kɨtu vô Yesu dɨ pɨmil i. ");
INSERT INTO ptp_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Mêd Yesu nêl ên nêbê, “A lam kɨbun ên a nêb a ob yaxên xomxo nɨlô, ên xomxo wê manôn toc dɨ he lungên a ge he manôn i seac dɨ he wê manôn seac ge he manôn i toc.” ");
INSERT INTO ptp_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Palisi ya dô kwabo hɨxôn Yesu dɨ ngô kɨyang wê i nêl ge om nêl vô i ên nêbê, “Ông nêb xe êno mamnôn toc mê?” ");
INSERT INTO ptp_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Mêd Yesu nêl vô he ên nêbê, “Xam mamnôn obêc toc ge od nipaên ti ob yêp vô xam lêm. Lêc xam nêl ên xam nêbê xam mamnôn seac dɨ xam xovô kɨyang vɨhati, om nipaên levac gên yêp vô xam.” ");
INSERT INTO ptp_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Yesu nêl ên nêbê, “A nêl hɨxôn nôn vô xam bê xomxo ti obêc nêb la vac xenac wê bwoc sipsip vông ge nɨlô, lêc o la bôbac vô vuayen tyo lêm, dɨ lec xenac vac bangwe ge od xomxo tige tɨyi xocbê xomxo yôdac me tɨbii vevac. ");
INSERT INTO ptp_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Lêc xomxo ti wê obêc la bôbac vac vuayen wê sipsip vông ge, ge xomxo ti wê mi viac sipsip ge, ");
INSERT INTO ptp_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","mêgem xomxo ti wê mi viac vuayen ge ob tax vuayen ên xomxo tige, dɨ sipsip ob ngô xomxo tige vya wê keac mɨ nêl he toto lê ge om xomxo tyo ob dɨdii he mɨ la xenac kehe. ");
INSERT INTO ptp_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Dɨ bwoc sipsip wê i vông ge ob la xenac kehe pyap ge od xomxo tige ob la mug dɨ sipsip tɨmu vô i vɨxa mɨ he la, ên sipsip xovô i vya pyap. ");
INSERT INTO ptp_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Dɨ sipsip o tɨyi wê ob tɨmu vô xomxo bangwe vɨxa ge lêm. Nge, ob pec ên i, ên he o xovô i vya lêm.” ");
INSERT INTO ptp_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yesu nêl kɨyang pɨlepacên tige vô he, lêc he o xovô kehe lêm. ");
INSERT INTO ptp_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Mêgem Yesu nêl tii vac vô he ên nêbê, “A nêl hɨxôn nôn vô xam bêga bê a ga, a tɨyi xocbê vuayen wê bwoc sipsip vông ge. ");
INSERT INTO ptp_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Xomxo vɨhati wê lam tax tax ge he tɨyi xocbê xomxo yôdac hɨxôn tɨbii vevac, lêc sipsip o ngô he vya lêm. ");
INSERT INTO ptp_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","A tɨyi xocbê vuayen. Xomxo ti obêc lam vô a mɨ la vac xenac nɨlô ge od ob la dô nivɨha, dɨ obêc lop mɨ la vɨxun dɨ lôm la xenac lôma ge od ob tulec yaên. ");
INSERT INTO ptp_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Tɨbii yôdac lam ên nêb ob vun bwoc sipsip dɨ hi he yib dɨ vông he vô nipaên. Dɨ a ga, a lam ên a nêb sipsip i dô mavɨha dɨ kô vɨzid i luu vêl. ");
INSERT INTO ptp_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“A ga, a xomxo wê a ob viac bwoc sipsip nivɨha ge. Xomxo wê viac sipsip nivɨha ge ob sea i ninɨvi dɨ yib ên ngɨdu he xôn. ");
INSERT INTO ptp_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Xomxo ti obêc viac sipsip nêb ob kô mone lec, lêc i o xomxo viacên nôn lêm, dɨ sipsip o tu ixe lêm, om xomxo tige obêc yê wê noo nipaên val ge od obêc sea sipsip dô dɨ pec mɨ la, dɨ noo nipaên obêc lam nga sipsip dɨ tii he la sea. ");
INSERT INTO ptp_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Kehe bêga nêbê xomxo tige viac sipsip ên nêb ob kô mone lec dɨ o xo vɨgwe pɨsiv ên sipsip lêm. ");
INSERT INTO ptp_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","“A ga, a xomxo wê a ob viac bwoc sipsip nivɨha ge. A xovô sipsip wê a vông ge dɨ he xovô a, ");
INSERT INTO ptp_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","tɨyi xocbê Mag xovô a dɨ a xovô Mag ge, om a ob xib ên ngɨdu sipsip xôn. ");
INSERT INTO ptp_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","A bwoc sipsip ya dô lê, lêc he gên o lam dô vac xenac tiga lêm. Om a ob la kô he mɨ lam tung hɨxôn, dɨ he ob ngô a vyag, mêgem he xôn ob dô kɨdu tibed dɨ xomxo tibed ob viac he. ");
INSERT INTO ptp_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Mag xêyaa vin lec a dɨ kehe bêga nêbê a ob vông a dɨluhu vac yibên, nang dêc a ob kɨdi lec magvɨha nang. ");
INSERT INTO ptp_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Xomxo ti o tɨyi wê ob hôm a xôn dɨ hi a xib ge lêm. Nge, aca va ob vông a dɨluhu vac yibên. Aca va xêkɨzêc tɨyi wê a ob vông a la vac yibên ge, nang dêc aca va xêkɨzêc tɨyi wê a ob kɨdi lec ge. Kɨyang tige, Mag nêl vô a ên nêb a vông i vô nôn lec.” ");
INSERT INTO ptp_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","He Yuda ngô Yesu kɨyang tige om he hɨbu he mɨ le kɨdu yuu, ");
INSERT INTO ptp_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","dɨ he tɨbeac nêl ên nêbê, “Xomxo tige vɨmwo nipaên dô vac nɨlô om vông i pɨyôp juda. Bêna lêcom xam ngô i vya?” ");
INSERT INTO ptp_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Lêc he ya nêl ên nêbê, “Xomxo wê vɨmwo nipaên dô vac he nɨlô ge, he ob nêl kɨyang tibêge lêm. Vɨmwo nipaên o tɨyi wê ob vông xomxo ma tocên manôn i seac ge lêm.” ");
INSERT INTO ptp_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Ge buc levac wê Yuda ob xovô buc wê he tax xumac ngɨbua Jelusalem ge. Buc tige lea yuu ningɨgooên, ");
INSERT INTO ptp_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","mêd Yesu la Anutu xumac ngɨbua dɨ la vɨlee lec pêt myahɨpu ti wê he nêl King Solomon lê lec ge. ");
INSERT INTO ptp_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Mêd Yuda ya la le vivac vô Yesu dɨ nêl vô i ên nêbê, “Ông vông xe nɨlôm la yuu dɨ obêc mɨloc vô buc tina? Ông obêc Kɨlisi ge od ông nêl ông kɨtong seac vô xe ên va.” ");
INSERT INTO ptp_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Mêd Yesu nêl vô he ên nêbê, “A nêl vô xam pyap, lêc xam o vông i vin a lêm. Yuac vɨhati wê a vông lec Mag lê ge, nêl a kɨtong seac, ");
INSERT INTO ptp_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","lêc xam o vông i vin lêm, ên xam o tu bwoc sipsip wê a vông ge lêm. ");
INSERT INTO ptp_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Sipsip wê a vông ge ngô a vyag dɨ a xovô he, dɨ he tɨmu vô a vɨxag. ");
INSERT INTO ptp_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","A obêc vông he dô mavɨha luta lêc luta dɨ he ob yib lêm, dɨ xomxo ti ob vô he vêl ên a vɨgêg lêm. ");
INSERT INTO ptp_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Mag wê vông he vô a ge luu susu vɨhati vêl om xomxo ti o tɨyi wê ob vô he vêl ên Mag vɨgê ge lêm. ");
INSERT INTO ptp_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Xii xôn Mag, nôn tibed.” ");
INSERT INTO ptp_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Mêd he Yuda hôm ngɨdax nêb ob nêx Yesu ya. ");
INSERT INTO ptp_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Lêc Yesu nêl vô he ên nêbê, “A hɨlung yuac nivɨha wê Mag vông ge tɨbeac vô xam. Om xam wê yuac tina so lêc xam nêb xam ob nêx a ya ngɨdaxê?” ");
INSERT INTO ptp_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Lêc he Yuda nêl vô Yesu ên nêbê, “Xe ob nêx ông ya ngɨdax ên yuac nivɨha wê ông vông ge lêm. Nge, xe nêb xe ob nêx ông ên wê ông so vyam vô Anutu ge. Ên ông ge xomxo kɨbun ga ti, lêc ông nêb ông Anutu.” ");
INSERT INTO ptp_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Mêd Yesu luu he vya bêga ên nêbê, “Kɨyang ti yêp vac xolac wê xam vông ge bêga nêbê, ‘A nêl ên a nêb xam ge Anutu.’ ");
INSERT INTO ptp_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Anutu nêl kɨyang tige vô xomxo ilage, lêc nêb he Anutu. Dɨ il xovô ên il nêbê xomxo ti o tɨyi wê ob kɨtya Anutu vya vêl ge lêm. ");
INSERT INTO ptp_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Anutu nêb he Anutu, om bêna lêc xam nêl ên xam nêbê a so vyag vô Anutu ên wê a nêl ên a nêbê a Anutu nu ge? Ên a ga, Anutu vɨnoo a dɨ vông a lam kɨbun. ");
INSERT INTO ptp_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","“A vôngên Anutu yuac obêc ma ge od xam o lêc vông i vin a vyag lêm. ");
INSERT INTO ptp_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Lêc a mi vông yuac wê Mag vông ge, om xam obêc nêb vông i vin a vyag lêm ge od xam wê yuac wê a mi vông ge dɨ vông i vin. Ên xam obêc vông i vin ge od xam obêc xovô bê Mag dô vac a nɨlôg dɨ a dô vac Mag nɨlô.” ");
INSERT INTO ptp_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Mêd xomxo tigee nêb ob hôm Yesu xôn lê, lêc Yesu vô he vɨgê vêl dɨ loc mɨ la. ");
INSERT INTO ptp_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Mêd Yesu lax mɨ la mia Jodan vɨlu ganê tii vac nang dɨ la dô vac vɨgwe ti wê Jon lipac xomxo vac ilage. ");
INSERT INTO ptp_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Mêd xomxo tɨbeac la vô Yesu, dɨ nêl ên nêbê, “Jon o vông do levac ya lêm, lêc kɨyang vɨhati wê Jon nêl lec xomxo tige, kɨyang nôn.” ");
INSERT INTO ptp_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Mêgem xomxo tɨbeac vac vɨgwe tige, he vông i vin Yesu. ");
INSERT INTO ptp_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Xomxo ti lê nêbê Lasalas vông yidac mɨ yêp vac ben gê Betani. Betani ge Malia yuu li Mata ben. ");
INSERT INTO ptp_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Malia tige wê la too mia nivɨvea nivɨha lec Yesu vɨxa dɨ kɨtya ya nɨbavɨluhu ge, lêc Malia li vux Lasalas vông yidac. ");
INSERT INTO ptp_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Om li vêx yuu ge vông kɨyang la vô Yesu ên nêbê, “Apumtau, xomxo ti wê ông xêmyaa vin lec i ge vông yidac levac dɨ yêp.” ");
INSERT INTO ptp_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Yesu ngô kɨyang tige dɨ nêl ên nêbê, “Yidac tige ob vông xomxo tige yib lêm. Nge, yidac tige vông, ên nêb ob vông Anutu lê i vô levac dɨ ob vông Anutu nu lê i vô levac êno.” ");
INSERT INTO ptp_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Yesu xêyaa vin lec Mata yuu li vêx dɨ Lasalas. ");
INSERT INTO ptp_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Yesu ngô wê yidac vông Lasalas ge, lêc dô vɨgwe wê dô vac ge tɨyi buc yuu hɨxôn, ");
INSERT INTO ptp_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","nang dêc nêl vô nue ngɨvihi ên nêbê, “Il ob lax mɨ la Judia i tii vac nang.” ");
INSERT INTO ptp_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Lêc nue ngɨvihi nêl vô i ên nêbê, “Xolac kehe, nyop ge, xomxo Yuda nêb ob nêx ông ya ngɨdax, lêc ông nêb ông ob lax mɨ la vɨgwe tige i tii vac nangê?” ");
INSERT INTO ptp_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Mêgem Yesu luu he vya ên nêbê, “Hɨyôv manôn vɨgê yuu dɨ tô mɨ la yuu yêp vô vɨdiiên ti. Om xomxo ti obêc vɨlee vô vɨdiiên ge od ob mwoc lêm, ên xêseac linac lec kɨbun. ");
INSERT INTO ptp_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Lêc obêc la vô bucên ge od ob mwoc, ên xêseac o linac vô i lêm.” ");
INSERT INTO ptp_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Yesu nêl pyap, lêc nêl vô he nang ên nêbê, “Il lig Lasalas yêp, lêcom a ob la tɨpi vô i kɨdi lec.” ");
INSERT INTO ptp_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Om Yesu nue ngɨvihi nêl ên nêbê, “Apumtau, ici va obêc yêp ge od obêc vô nivɨha lec nang.” ");
INSERT INTO ptp_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Kɨyang tige, Yesu nêl lec wê Lasalas yib ge, lêc he so ên he nêb mêd Yesu nêl ên nêb Lasalas vaci yêp. ");
INSERT INTO ptp_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Om Yesu nêl seac vô he ên nêbê, “Lasalas yib, ");
INSERT INTO ptp_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","lêc a xêgyaa vô nivɨha ên wê a o la dô hɨxôn i ge lêm, ên a xo xam ên a nêb xam vông i vin a. Om xam lam ên il ob la xê Lasalas.” ");
INSERT INTO ptp_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Mêd Tomas wê ta kô yuu li ngwe ked ge, nêl vô lie ngɨvihi ên nêbê, “Xam lam ên il xôn la xib hɨxôn Yesu.” ");
INSERT INTO ptp_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Mêd Yesu loc mɨ la ên nêb ob la Betani, lêc ngô wê he lii Lasalas vac lôva dɨ buc yuudɨyuu la vêl ge. ");
INSERT INTO ptp_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betani yêp kwabo vô Jelusalem tɨyi xocbê 3 kilomita ge, ");
INSERT INTO ptp_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","om xomxo Yuda tɨbeac lam yê Mata yuu Malia ên wê li Lasalas yib ge, ên he nêb he ob vông yuu nɨlô i vô vɨyin maên. ");
INSERT INTO ptp_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Mêd Mata ngô wê Yesu val ge om mɨla vô i vac môp, dɨ Malia dô vac xumac. ");
INSERT INTO ptp_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Mêd Mata nêl vô Yesu ên nêbê, “Apumtau, ông obêc dô ga ge od a lig yibên obêc ma. ");
INSERT INTO ptp_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Lêc a xovô ên a nêbê gwêbaga ông obêc kɨtaa susu ti vô Anutu ge od Anutu obêc vông i tɨyi wê ông kɨtaa ge.” ");
INSERT INTO ptp_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Mêd Yesu nêl vô i ên nêbê, “Lim tuc obêc kɨdi lec i tii vac nang.” ");
INSERT INTO ptp_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Mêd Mata nêl vô i ên nêbê, “A xovô ên a nêbê obêc buc tɨmuên wê xomxo vɨhati obêc kɨdi lec i tii vac ge od Lasalas ob kɨdi lec hɨxôn.” ");
INSERT INTO ptp_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Om Yesu nêl vô i ên nêbê, “Kɨdi lecên yuu mavɨha dôên kehe a. Xomxo wê vông i vin a ge he obêc yib lê, lêc obêc kɨdi lec mavɨha. ");
INSERT INTO ptp_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Dɨ xomxo vɨhati wê dô mavɨha dɨ vông i vin a ge, he yibên obêc ma. Ông vông i vin kɨyang tiga, me?” ");
INSERT INTO ptp_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Mêgem Mata nêl vô Yesu ên nêbê, “Apumtau, a vông i vin ên a nêbê ông ge Kɨlisi. Dɨ ông Anutu nu, wê Anutu nêb ob vông ông lam kɨbun ga ge.” ");
INSERT INTO ptp_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Mata nêl kɨyang pyap dɨ la keac Malia lam dɨ lum nêl vô i ên nêbê, “Xolac kehe val, lêc nêb ông loc wê i.” ");
INSERT INTO ptp_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Malia ngô kɨyang tige mêd kɨdi lec lutibed dɨ la vô Yesu. ");
INSERT INTO ptp_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Yesu gên o val vɨyangtôv lêm. Nge, gên le vac môp wê Mata mɨla vô i ge. ");
INSERT INTO ptp_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Mêd he Yuda wê val ên nêb ob vông Malia yuu Mata nɨlô i vô nivɨha ge, he dô vac xumac lôma hɨxôn Malia dɨ yê wê Malia kɨdi lec lutibed dɨ la ge om he tɨmu vô i vɨxa mɨ la, ên he xo ên he nêb mêd Malia ob la byag lec lôva. ");
INSERT INTO ptp_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Malia mɨla vɨgwe wê Yesu val le ge dɨ yê Yesu, om mɨla kwabo vô i dɨ yev vɨxa kɨtu vô dɨ nêl ên nêbê, “Apumtau, ông obêc dô ga ge od a lig yibên obêc ma.” ");
INSERT INTO ptp_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Yesu yê wê Malia he Yuda wê lam hɨxôn i ge byag ge, om Yesu yetac dɨ nɨlô vô vɨyin mabu. ");
INSERT INTO ptp_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Mêd kɨnêg vô he ên nêbê, “Xam lii Lasalas loc yêp tina?” Mêd he nêl ên nêbê, “Apumtau, lam wê.” ");
INSERT INTO ptp_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Mêgem Yesu byag, ");
INSERT INTO ptp_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","om Yuda tigee nêl ên nêbê, “Wê, xomxo tige xêyaa vin lec Lasalas luu vêl.” ");
INSERT INTO ptp_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Lêc he ya nêl ên nêbê, “Xomxo tige vông xomxo ma tocên manôn seac, lêc mêd o tɨyi wê ob ngɨdu Lasalas xôn ên yibên i ma ge lêmê?” ");
INSERT INTO ptp_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Yesu nɨlô vô vɨyin levac dɨ i mɨla vô lôva wê he lii Lasalas yêp vac ge. Lôva tige le vac ngɨdax dɨ he lax ngɨdax ti le vac lôva mya xôn. ");
INSERT INTO ptp_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Mêd Yesu nêl ên nêbê, “Hôm ngɨdax tige vêl.” Lêc yibên tyo li vêx Mata nêl ên nêbê, “Apumtau, Lasalas yib mɨ xe yev, dɨ buc yuudɨyuu lam la vêl, om nuhu tyip.” ");
INSERT INTO ptp_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Lêc Yesu nêl vô i ên nêbê, “A nêl gwêba vô ông ên a nêbê ông obêc vông i vin ge od ông ob wê xêseac wê Anutu vông ge.” ");
INSERT INTO ptp_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Mêgem he hôm ngɨdax tige vêl dɨ Yesu lax ma la kɨsii dɨ nêl ên nêbê, “Mag, a hi vɨxag pec ên wê ông ngô kɨtaaên wê a vông ge. ");
INSERT INTO ptp_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Dɨ a xovô ên a nêbê tɨyi buc vɨhati ông vô nɨnyam vô a vyag, lêc a nêl kɨyang tiga ên a nêb xomxo wê val le gae, he i ngô dɨ vông i vin bê ông vông a lam.” ");
INSERT INTO ptp_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Yesu nêl bêge mêd tyuc vya levac ên nêbê, “Lasalas, kɨdi lec mɨ lam.” ");
INSERT INTO ptp_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Mêgem Lasalas kɨdi lec dɨ lam vɨxun lêc lam hɨxôn nivɨmihi wê he vɨyum vɨgê yuu vɨxa vac ge dɨ nivɨmihi nipwo ti wê he vɨyum manôn vac ge hɨxôn, om Yesu nêl vô he ên nêbê, “Xam pɨwelac nivɨmihi vêl dɨ vông i loc.” ");
INSERT INTO ptp_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Yuda wê la vô Malia ge, he yê wê Yesu tɨpi vô Lasalas ge, om he tɨbeac vông i vin Yesu. ");
INSERT INTO ptp_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Lêc he ya la vô Palisi dɨ la nêl môp wê Yesu vông ge kɨtong vô he. ");
INSERT INTO ptp_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Mêgem Palisi hɨxôn xomxo levac wê mi si daa gee, he kɨtucma hɨxôn kaunsil vɨhati dɨ nêl vôma ên nêbê, “Il ob vông bêna? Ên xomxo tyo vông do levac tɨbeac, ");
INSERT INTO ptp_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","om il obêc dɨxê ya madnôn dɨ i dô ge od obêc vông do levac ya hɨxôn dɨ xomxo vɨhati obêc vông i vin i, dɨ tɨbii Lom wê viac il ge obêc val kɨpê xumac ngɨbua wê il vông ge sea dɨ vông il vô nipaên hɨxôn.” ");
INSERT INTO ptp_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Lêc he ti lê nêbê Kaiapas wê tu xomxo daa siên nên levac lec klismas tige nêl vô he ên nêbê, “Xam o xovô kɨyang ti lêm, ");
INSERT INTO ptp_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","dɨ xam o xovô môp wê ob vô nivɨha vô xam ge lêm. Xam ngô lê. Xomxo tibed obêc yib ên xomxo vɨhati ge od obêc vô nivɨha vô il dɨ tɨbii Lom ob lam kɨtya il vêl lêm.” ");
INSERT INTO ptp_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Kaiapas o nêl kɨyang tige ya xovôên wê ici va vông ge lêm. Nge, tu xomxo wê mi si daa gee nên xomxo levac lec klismas tige om nêl kɨyang bo tige seac lec Yesu wê ob yib ên he Yuda ge. ");
INSERT INTO ptp_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Lêc ob yib ên Yuda vaci lêm. Nge, ob yib ên kɨtuc Anutu nue vɨhati wê dô vac vɨgwe vɨhati ge he lam dô kɨdu tibed. ");
INSERT INTO ptp_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Vô buc tige Yuda hɨlu kɨyang pyap nêb ob hi Yesu i yib. ");
INSERT INTO ptp_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Om Yesu o la vɨlee vac Yuda mahɨgun ti tii vac lêm. Nge, sea vɨgwe tige mɨ la vɨgwe ti lê nêbê Iplem wê yêp kwabo vô vɨgwe mahɨgun pɨleva ge, mêd Yesu he nue ngɨvihi la dô vac vɨgwe tige. ");
INSERT INTO ptp_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Buc levac wê Yuda ob xovô buc Pasova Isip ilage vô kwabo lec, om xomxo tɨbeac vac vɨgwe toto ge kɨtuc la Jelusalem tax, ên nêb ob la viac he ên buc tige. ");
INSERT INTO ptp_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Om he myag Yesu vac Anutu xumac ngɨbua dɨ nêl vôma ên nêbê, “Xam xo bêna? Xam nêb Yesu ob yê buc tiga hɨxôn, me?” ");
INSERT INTO ptp_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Xomxo levac wê mi si daa gee hɨxôn Palisi nêl kɨyang pyap ên nêbê xomxo ti obêc xovô vɨgwe ti wê Yesu la dô vac ge od i lam nêl kɨtong vô he ên he ob la hôm Yesu xôn. ");
INSERT INTO ptp_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Buc vɨgê vɨlu dɨ sec ti gên yêp dɨ obêc buc Pasova, dɨ Yesu lax mɨ la Betani wê tɨpi vô Lasalas kɨdi lec mavɨha vac yibên ge. ");
INSERT INTO ptp_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Mêd he myêl yaên vô Yesu, dɨ Mata duu yaên dɨ Lasalas dô hɨxôn he wê ob ya yaên hɨxôn Yesu ge. ");
INSERT INTO ptp_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Mêd Malia kô mia nivɨvea nivɨha vac butol ti. Mia tige he kɨsuu lec mone levac mabu. Mêd Malia kô mɨ la too lec Yesu vɨxa dɨ kɨtya ya nɨbavɨluhu. Om mia nivɨvea tige la pup vac xumac nɨlô. ");
INSERT INTO ptp_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Lêc Yesu nue ngɨvihi ti lê nêbê Judas Iskaliot wê ob vông Yesu vac tɨbii vevac vɨgê ge nêl ên nêbê, ");
INSERT INTO ptp_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Bêna lêc il o vông mia tige mɨ tɨbii kɨsuu ya mone yul yon (K300) ên il vông vô tɨbii wê nên susu maên geê?” ");
INSERT INTO ptp_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Judas nêl bêge lêc o xo tɨbii wê nên susu maên ge lêc nêl kɨyang tige lêm. Ên Judas ge tɨbii yôdac ti lê, lêc mi viac Yesu he nue ngɨvihi tin wê mone mi dô vac ge om mone wê he mi tung la vac tin ge Judas mi kô ya yôdac. ");
INSERT INTO ptp_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Lêc Yesu nêl vô i ên nêbê, “Vông vêx tige i dô, ên vông tɨxuuên lec buc wê he ob lipac mia nivɨvea lec a nignɨvi dɨ yev a ge. ");
INSERT INTO ptp_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Xomxo wê nên susu maên ge ob dô hɨxôn xam buc dia, dɨ a ga, a ob dô hɨxôn xam buc dia lêm.” ");
INSERT INTO ptp_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Yuda tɨbeac ngô wê Yesu la dô Betani ge om he lam vô i, lêc he o lam nêb he ob yê Yesu vaci lêm. Nge, he nêb ob yê Lasalas wê Yesu tɨpi vô i kɨdi lec vac yibên ge hɨxôn. ");
INSERT INTO ptp_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Mêgem xomxo levac wê mi si daa gee hɨlu kɨyang pyap ên nêb ob hi Lasalas i yib hɨxôn, ");
INSERT INTO ptp_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","ên Yuda tɨbeac xovô wê Lasalas kɨdi lec vac yibên ge om sea Yuda levac dɨ vông i vin Yesu. ");
INSERT INTO ptp_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Mêd vɨgwe vɨdiiên tɨtige xomxo tɨbeac wê lam dô ên nêb ob yê buc levac ge, he ngô wê Yesu ob mɨla Jelusalem ge, ");
INSERT INTO ptp_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","om he la kô xax lihi dɨ mɨla vô Yesu vac môp dɨ tyuc hɨxôn nêbê, “Il ob pɨmil Anutu dɨ hi vɨxad i pec ên xomxo ti wê tu Apumtau manôn dɨ lam ge, ên i ge tu xomxo levac wê ob viac il Islel.” ");
INSERT INTO ptp_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Mêd Yesu la kô bwoc donki nu ti mɨ dô lec, tɨyi xocbê kɨyang wê yêp vac xolac bêga nêbê, ");
INSERT INTO ptp_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Xam xomxo Saion, xam xona ên i ma. Xam wê lê. Xam xomxo levac wê ob viac xam ge dô lec bwoc donki nu ti mɨ val.” ");
INSERT INTO ptp_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Vô buc tige Yesu nue ngɨvihi gên lungên kɨyang tige kehe, lêc buc wê Yesu lax dô vac xêseac ge od he xo i lax lec kɨyang tige wê yêp vac xolac ge dɨ xovô nêbê kɨyang tige vô nôn lec vô Yesu. ");
INSERT INTO ptp_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Xomxo wê dô hɨxôn Yesu dɨ yê wê Yesu tɨpi vô Lasalas kɨdi vac lôva mɨ lam ge la nêl kɨyang tige kɨtong vô xomxo tɨbeac. ");
INSERT INTO ptp_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Om xomxo tɨbeac ngô wê Yesu vông do levac tige om he mɨla vô Yesu vac môp. ");
INSERT INTO ptp_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Mêd Palisi nêl vôma ên nêbê, “Xam wê lê. Il nêd kɨyang nôn ma, ên xomxo vɨhati la tɨmu vô Yesu.” ");
INSERT INTO ptp_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Xomxo tɨbeac la Jelusalem ên nêb ob la kɨtaa vô Anutu lec buc ngɨbua tige lêc Glik ya la hɨxôn. ");
INSERT INTO ptp_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Om Glik tigee la vô Pilip wê ben Betsaida vac vɨgwe levac Galili ge, dɨ la nêl vô i ên nêbê, “Xomxo levac, xe ob xê Yesu.” ");
INSERT INTO ptp_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Om Pilip la nêl vô Andlu, dɨ yuu la nêl vô Yesu. ");
INSERT INTO ptp_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Lêc Yesu nêl vô yuu ên nêbê, “Buc wê Xomxo Nu ob kô lê levac ge vô kwabo lec pyap. ");
INSERT INTO ptp_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","A nêl hɨxôn nôn vô xam bê skom nôn ti obêc la vac kɨbun lêm ge od ob dô ya nôn tibed. Lêc obêc la dô vac kɨbun nɨlô ge od ob tyip mɨ vô nôn tɨbeac. ");
INSERT INTO ptp_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Xomxo ti xêyaa obêc vin lec ici va ninɨvi ge od ninɨvi wê i vông ge obêc yib. Lêc xomxo ti obêc vông i vin Anutu dɨ yê ici va ninɨvi tɨyi xocbê susu pɨleva gê kɨbun ga ge od obêc la dô mavɨha luta lêc luta. ");
INSERT INTO ptp_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Xomxo ti obêc nêb vông yuac wê a vông ge od i lam tɨmu vô a, ên vɨgwe wê a ob dô vac ge, a nuge yuac obêc dô hɨxôn a. Dɨ xomxo ti obêc vông yuac wê a vông ge od Mag obêc vông lê levac vô i. ");
INSERT INTO ptp_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Gwêbaga a nɨlôg vô vɨyin levac om a ob nêl bêna? A ob nêl bê ‘Mag, ông vô vɨyin tiga vêl ên a’? Ma vêl, a ob nêl bêge lêm. Ên a lam ên a nêb a ob kô vɨyin tige. ");
INSERT INTO ptp_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Mag, ông vông ông lêm i vô levac.” Yesu nêl bêge mêd vya ti lam gê lag puunê ên nêbê, “A vông a lêg vô levac pyap dɨ a ob vông i vô levac tii vac nang.” ");
INSERT INTO ptp_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Lêc xomxo wê le kwabo gee ngô vya tige om he ya nêl ên nêbê, “Deac tug,” dɨ he ya nêl ên nêbê, “Angela ti keac vô i.” ");
INSERT INTO ptp_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Lêc Yesu luu he vya ên nêbê, “Vya tige o lam vô a ên nêb a ngô lêm. Nge, lam ên nêb xam ngô. ");
INSERT INTO ptp_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Gwêbaga Anutu ob yaxên xomxo kɨbun ga nên kɨyang dɨ ob tii Seten wê tu xomxo kɨbun ga nên levac ge i la vêl. ");
INSERT INTO ptp_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Gwêbaga a gên dô kɨbun, lêc buc wê a obêc yux lec xax ge od a ob dɨdii xomxo vɨhati lam vô a.” ");
INSERT INTO ptp_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Yesu nêl kɨyang tige ên nêb ob nêl môp wê ob yib ge kehe kɨtong vô he. ");
INSERT INTO ptp_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Mêd xomxo tigee luu i vya ên nêbê, “Xe ngô kɨyang wê yêp vac xolac bêga nêbê Kɨlisi ob dô mavɨha luta lêc luta. Bêna lêc ông nêb Xomxo Nu ob yux lec xaxê? Xomxo Nu ge letya?” ");
INSERT INTO ptp_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Mêd Yesu nêl vô he ên nêbê, “Xêseac ob dô hɨxôn xam myabo tya. Om buc wê xêseac dô hɨxôn xam ge od xam loc vac xêseac, ên mapɨtoc i o lêc hɨvun xam xôn lêm. Ên xomxo ti obêc la vac mapɨtoc ge od ob lungên môp wê ob la vô ge. ");
INSERT INTO ptp_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Om xam vông i vin xêseac wê dô hɨxôn xam ge, êdêc tu xêseac nue.” Yesu nêl kɨyang tige pyap mêd sea he dɨ la xôpac ên he. ");
INSERT INTO ptp_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Yesu vông do levac tɨbeac vô xomxo manôn mɨ he yê, lêc he o vông i vin i lêm. ");
INSERT INTO ptp_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Om kɨyang wê plopet Aisaia nêl ilage vô nôn lec. Kɨyang tige yêp bêga nêbê, “Apumtau, letya vông i vin kɨyang wê xe nêl ge? Apumtau hɨlung xêkɨzêc wê i vông ge lê, lêc letya vông i vin? Xomxo ti o vông i vin lêm.” ");
INSERT INTO ptp_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Xomxo tigee tɨyiên ma wê ob vông i vin Yesu ge dɨ kehe yêp vac kɨyang ngwe wê Aisaia kɨvuu bêga nêbê, ");
INSERT INTO ptp_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Anutu vông he manôn toc dɨ vông he pɨyôp vô xêkɨzêc, om he manôn yêên ma dɨ he pɨyôp xovôên kɨyang ti ma, dɨ he o pɨlepac he bê Anutu ob vông he dô nivɨha lêm.” ");
INSERT INTO ptp_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Aisaia yê xêseac wê Kɨlisi vông ge om nêl kɨyang tige lec Kɨlisi vaci. ");
INSERT INTO ptp_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Mêgem Yuda levac, he tɨbeac vông i vin Yesu, lêc he xona ên Palisi om he o nêl vông vinên wê he vông ge kɨtong seac lêm, ên he xona ên wê Palisi obêc tii he vêl ên xumac lɨlo dɨ vông he la dô nɨnya ge. ");
INSERT INTO ptp_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Ên Yuda tigee xêyaa vin lec nêb xomxo i yê he nivɨha, dɨ he o xovô nêbê Anutu i yê he nivɨha lêm. ");
INSERT INTO ptp_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Yesu keac vya levac yêp seac ên nêbê, “Xomxo ti obêc vông i vin a ge od o vông i vin aca va tibed lêm. Nge, vông i vin xomxo ti wê vông a lam ge hɨxôn. ");
INSERT INTO ptp_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Dɨ xomxo wê yê a ge od yê xomxo ngwe wê vông a lam ge hɨxôn. ");
INSERT INTO ptp_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","A lam dô kɨbun ga hɨxôn xêseac, ên a nêb xomxo wê vông i vin a ge, he i o lêc dô vac mapɨtoc nang lêm. ");
INSERT INTO ptp_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Xomxo ti obêc ngô a kɨyang lêc tɨmu vôên obêc ma ge od a ob tɨtô i lêm. Ên a o lam ên a nêb a ob yaxên xomxo nên kɨyang lêm. Nge, a lam ên a nêb a ob hôm he lec. ");
INSERT INTO ptp_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Xomxo ti obêc vô nɨmi vô a dɨ ngôên a kɨyang obêc ma ge od i nên wê ob yaxên i ge yêp, ên kɨyang wê a nêl ge obêc yaxên i vô buc tɨmuên. ");
INSERT INTO ptp_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Ên kɨyang wê a nêl ge a o nêl ya xovôên wê a vông ge lêm. Nge, Mag wê vông a lam ge, ici va nêl kɨyang vô a ên nêb a lam nêl seac. ");
INSERT INTO ptp_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Dɨ a xovô ên a nêbê kɨyang wê Mag nêl ge ob vông xomxo dô mavɨha luta lêc luta, om kɨyang wê a nêl ge a nêl vɨhati tɨyi xocbê Mag nêl vô a ge.” ");
INSERT INTO ptp_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Buc Pasova vô kwabo lec, om Yesu xovô nêbê buc wê ob sea kɨbun dɨ lax mɨ la vô Ma ge val vô kwabo lec pyap. Yesu xêyaa vin lec nue wê dô kɨbun ga tɨyi buc vɨhati dɨ i la tyip lec buc wê ob yib lec ge. ");
INSERT INTO ptp_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Vɨgwe huc mêd Yesu he nue ngɨvihi ya yaên mɨ dô. Lêc Seten vông xovôên vô Judas Iskaliot wê Saimon nu ge ên nêb i nêl Yesu kɨtong vô tɨbii vevac. ");
INSERT INTO ptp_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Yesu xovô nêbê Ma vông xêkɨzêc vô i pyap, dɨ xovô nêbê i lam vô Anutu dɨ obêc lax mɨ la vô Anutu i tii vac nang. ");
INSERT INTO ptp_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","He gên dɨya, lêc Yesu kɨdi lec dɨ kwax nivɨmihi vêl dɨ hôm taul dɨ vêx lec, ");
INSERT INTO ptp_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","mêd too mia vac pɨle levac ti dɨ la vô nue ngɨvihi toto dɨ la lipac he vɨxa dɨ kɨtya ya taul ti wê vêx lec i ge. ");
INSERT INTO ptp_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Mêd mɨla vô Saimon Pita lêc Pita kɨnêg vô i ên nêbê, “Apumtau, ông ob lipac a vɨxag?” ");
INSERT INTO ptp_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Mêd Yesu luu i vya ên nêbê, “Gwêbaga ông lungên môp wê a vông ga, lêc tɨmuên ge ông obêc xovô.” ");
INSERT INTO ptp_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Lêc Pita nêl vô i ên nêbê, “Tɨyiên ma vêl wê ông ob lipac a vɨxag ge.” Mêd Yesu luu i vya ên nêbê, “A lipacên ông obêc ma ge od o tɨyi wê ông ob dô hɨxôn a ge lêm.” ");
INSERT INTO ptp_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Om Pita nêl vô i ên nêbê, “Apumtau, obêc bêge ge od ông ob lipac a vɨxag pɨleva lêm. Nge, ông lipac a vɨgêg yuu bagzub hɨxôn.” ");
INSERT INTO ptp_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Lêc Yesu nêl vô i ên nêbê, “Xomxo wê lipac mia pyap ge ob lipac ninɨvi vɨhati tii vac lêm. Nge, ob lipac vɨxa pɨleva, ên ninɨvi vɨhati vô paha lec. Dɨ xam ge, xam vô paha lec pyap, lêcom o xam vɨhati lêm.” ");
INSERT INTO ptp_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Yesu xovô xomxo ti wê ob vông i la vac tɨbii vevac vɨgê ge om nêl ên nêbê, “Xam vô paha lec pyap, lêcom o xam vɨhati lêm.” ");
INSERT INTO ptp_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Yesu lipac he vɨxa pyap mêd vɨnyum nivɨmihi lec nang dɨ lax dô dɨ kɨnêg vô he ên nêbê, “Môp wê a vông vô xam gwêbaga, xam xovô kehe, me? ");
INSERT INTO ptp_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Xam mi nêl a ên xam nêb a xolac kehe dɨ a Apumtau, om xam nêl i la tɨyi, ên a bêge mêge. ");
INSERT INTO ptp_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","A ga Apumtau dɨ a xolac kehe, lêc a lipac xam vɨxam, om xam êno, xam lipac lime vɨxa. ");
INSERT INTO ptp_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Gwêbaga a hɨlung môp vô xam ên a nêb xam vông i tɨyi xocbê a vông vô xam ge. ");
INSERT INTO ptp_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","A nêl hɨxôn nôn vô xam bêga bê xomxo yuac ti ob luu i xomxo levac vêl lêm, dɨ xomxo ti wê la nêl xomxo ngwe kɨyang ge ob luu xomxo ti wê vông i la ge vêl lêm. ");
INSERT INTO ptp_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Xam obêc xovô kɨyang tiga mɨ vông i tɨyi ge od xam xêmyaa obêc vô nivɨha. ");
INSERT INTO ptp_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Lêc a o nêl kɨyang tiga lec xam vɨhati lêm. Xam wê a vɨnoo xam mɨ xam tu axe ge, a xovô xam pyap. Lêc kɨyang wê yêp vac xolac ge ob vô nôn lec, kɨyang wê nêl bêga nêbê, ‘Xomxo ti wê ya yaên hɨxôn a ge kô vɨxa lec kɨsii, nêb ob kê a.’ ");
INSERT INTO ptp_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Kɨyang tige gên o vô nôn lec lêm, lêc a nêb a ob nêl kɨtong vô xam tax, ên obêc vô nôn lec tɨmuên ge od xam xovô bê a xomxo tyo. ");
INSERT INTO ptp_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","A nêl hɨxôn nôn vô xam bê xomxo ti obêc hôm xomxo wê a vông he la ge lec nivɨha ge, od tɨyi xocbê hôm a lec nivɨha hɨxôn, dɨ xomxo ti obêc hôm a lec nivɨha ge od tɨyi xocbê hôm xomxo ti wê vông a lam ge lec nivɨha hɨxôn.” ");
INSERT INTO ptp_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Yesu nêl kɨyang tige pyap mêd nɨlô vô vɨyin mabu dɨ i nêl kɨyang seac vô he ên nêbê, “A nêl vɨxôhɨlôg nôn vô xam bêga bê xacxam ti obêc vông a vac tɨbii vevac vɨgê.” ");
INSERT INTO ptp_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Lêc Yesu nue ngɨvihi lungên kɨyang tige kehe om yêma manôn, ên nêb mêd nêl kɨyang tige lec letya? ");
INSERT INTO ptp_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","A, Jon wê Yesu xêyaa vin lec a luu vêl ge, a dô kwabo vô Yesu, ");
INSERT INTO ptp_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","om Saimon Pita nêx kwa vô a ên nêb a kɨnêg vô Yesu bê Yesu nêl kɨyang tige lec letya? ");
INSERT INTO ptp_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Om a du mɨ la kwabo vô Yesu dɨ kɨnêg vô i ên nêbê, “Apumtau, ông nêl kɨyang tige lec letya?” ");
INSERT INTO ptp_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Mêd Yesu nêl vô a ên nêbê, “Xomxo ti wê a ob tɨnyum blet vac mia mɨ vông vô ge, tyo tige mê.” Mêgem Yesu hôm blet ti dɨ tɨnyum vac mia dɨ vông vô Judas wê Saimon Iskaliot nu ge. ");
INSERT INTO ptp_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Judas hôm blet tige mɨ ya dɨ lutibed Seten la vac i nɨlô, mêd Yesu nêl vô Judas ên nêbê, “Môp wê ông nêb ông ob vông ge, ông vông lutibed.” ");
INSERT INTO ptp_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","He wê dô lec tevol ge, ti o xovô kɨyang wê Yesu nêl vô Judas ge kehe lêm. ");
INSERT INTO ptp_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","He xovô ên he nêbê Judas mi viac tin wê he mone mi dô vac ge om he ya xo ên he nêb Yesu mêd nêl vô Judas nêb i loc kɨsuu yaên wê he ob ya lec buc levac ge, me nêb i loc vông mone vô tɨbii wê nên mone maên ge. ");
INSERT INTO ptp_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Judas hôm blet tige mɨ ya vêl dɨ lop mɨ la vɨxun lutibed dɨ vɨgwe buc. ");
INSERT INTO ptp_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Judas la pyap mêd Yesu nêl ên nêbê, “Gwêbaga xêseac wê Xomxo Nu vông ge val le seac, dɨ Xomxo Nu vông xêseac wê Anutu vông ge val le seac hɨxôn. ");
INSERT INTO ptp_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Dɨ Xomxo Nu obêc hɨlung xêseac wê Anutu vông ge od Anutu vaci ob hɨlung xêseac wê Xomxo Nu vông ge lutibed. ");
INSERT INTO ptp_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Xam nuge, a ob dô hɨxôn xam myabo tya, dɨ xam obêc myag a, lêc kɨyang wê a nêl vô he Yuda ge, a ob nêl vô xam hɨxôn bêga bê vɨgwe wê a ob la dô vac ge, xam ti o tɨyi wê xam ob la vac ge lêm. ");
INSERT INTO ptp_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","A ob nêl xolac paha ti vô xam bêga bê xam xêmyaa i vin lecma. A xêgyaa vin lec xam om xam xêmyaa i vin lecma i tɨyi xocbê a xêgyaa vin lec xam ge. ");
INSERT INTO ptp_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Ên xam xêmyaa obêc vin lecma ge od xomxo vɨhati obêc xovô bê xam tu a nuge.” ");
INSERT INTO ptp_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Mêd Saimon Pita kɨnêg vô Yesu ên nêbê, “Apumtau, ông ob la na?” Mêd Yesu luu i vya ên nêbê, “Vɨgwe wê a ob la vac ge, gwêbaga o tɨyi wê ông ob tɨmu vô a vɨxag ge lêm. Lêc tɨmuên ge ông obêc tɨmu vô a vɨxag.” ");
INSERT INTO ptp_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Om Pita nêl vô i ên nêbê, “Apumtau, bêna lêc a o tɨyi wê a ob tɨmu vô ông gwêbaga lêmê? A tɨyi wê a ob xib ên ngɨdu ông xôn.” ");
INSERT INTO ptp_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Lêc Yesu nêl vô i ên nêbê, “Ông nêb ông ob wib ên ngɨdu a xônê? A nêl hɨxôn nôn vô ông bê kokɨlêx obêc gên vô vya lêm dɨ ông ob yax a vun lu yon.” ");
INSERT INTO ptp_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Yesu nêl vô he ên nêbê, “Xam nɨlôm i o lêc vô vɨyin lêm. Xam vông i vin Anutu, om xam vông i vin a hɨxôn. ");
INSERT INTO ptp_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Xumac wê Mag vông ge, nɨlô tɨbeac yêp. Obêc ma ge od a obêc nêl kɨtong vô xam ilage lê. Lêc yêp vɨxôhɨlôg, om a ob lax ên lax viac xam bom wê xam obêc mɨla dô vac ge. ");
INSERT INTO ptp_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Dɨ a obêc viac pyap ge, od a ob lôm kô xam, ên xam loc dô hɨxôn a vac vɨgwe wê a ob dô vac ge. ");
INSERT INTO ptp_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Dɨ vɨgwe wê a ob la vac ge, xam xovô môp pyap.” ");
INSERT INTO ptp_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Lêc Tomas nêl vô Yesu ên nêbê, “Apumtau, vɨgwe wê ông ob la vac ge, ge xe lungên, om xe ob xovô môp tige bêna?” ");
INSERT INTO ptp_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Om Yesu nêl vô i ên nêbê, “A ga môp, dɨ a kɨyang nôn kehe, dɨ a mavɨha dôên kehe. Om xomxo ti obêc la vô Mag vô môp bangwe lêm, ên môp wê ob la vô Mag ge a tibed. ");
INSERT INTO ptp_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Xam obêc xovô a ge od xam obêc xovô Mag hɨxôn, dɨ gwêba lêc xam xovô i, ên xam wê i pyap.” ");
INSERT INTO ptp_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Mêd Pilip nêl vô i ên nêbê, “Apumtau, ông hɨlung mam vô xe dɨ obêc pyap.” ");
INSERT INTO ptp_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Lêc Yesu nêl vô i ên nêbê, “Pilip, a dô hɨxôn xam buc xuhu dia, lêc xam gên lungên a? Xomxo wê yê a ge yê Mag. Bêna lêc ông nêb a hɨlung Mag vô xamê? ");
INSERT INTO ptp_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Mêd ông gên o vông i vin bê a dô vac Mag nɨlô dɨ Mag dô vac a nɨlôg lêm, me? Kɨyang wê a nêl vô xam ge, a o nêl ya xovôên wê a vông ge lêm. Nge, Mag wê dô vac a nɨlôg ge, a vông yuac wê i vông ge. ");
INSERT INTO ptp_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Xam vông i vin bêga bê a dô vac Mag nɨlô dɨ Mag dô vac a nɨlôg. Lêc xam obêc vông i vin kɨyang tige lêm ge od xam wê yuac wê a vông ge dɨ vông i vin. ");
INSERT INTO ptp_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","“A nêl vɨxôhɨlôg nôn vô xam bê xomxo wê vông i vin a ge ob vông do tɨyi xocbê a mi vông ge, dɨ obêc vông do levac luu wê a vông ge vêl, kehe bêga nêbê a ob lax vô Mag. ");
INSERT INTO ptp_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Dɨ susu vɨhati wê xam ob kɨtaa lec a lêg ge a obêc vông i vô nôn lec, ên a ob vông xêseac wê Mag vông ge i yêp seac. ");
INSERT INTO ptp_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Om xam obêc kɨtaa susu ti lec a lêg ge od a obêc vông i vô nôn lec. ");
INSERT INTO ptp_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Xam xêmyaa obêc vin lec a ge od xam obêc tɨmu vô xolac wê a nêl ge. ");
INSERT INTO ptp_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Dɨ a obêc kɨtaa vô Mag dɨ Mag obêc vông xomxo ngwe i lam vô xam. Xomxo tige wê ob ngɨdu xam xôn dɨ dô hɨxôn xam luta. ");
INSERT INTO ptp_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Ge Myakɨlôhô Ngɨbua wê ob nêl kɨyang nôn, lêc xomxo kɨbun ga o tɨyi wê ob kô i lec nivɨha ge lêm, ên he o xovô i lêm. Lêc xam xovô i pyap, ên mi dô hɨxôn xam dɨ obêc dô vac xam nɨlôm. ");
INSERT INTO ptp_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“A obêc sea xam dô tamaên xocbê xomxo pɨbua ge lêm. Nge, a obêc lôm vô xam i tii vac. ");
INSERT INTO ptp_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Buc myabo tya dɨ xomxo kɨbun ga ob yê a tii vac lêm, lêc xam ge, xam obêc wê a. A dô magvɨha om xam êno obêc dô mamvɨha. ");
INSERT INTO ptp_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Obêc buc tige od xam obêc xovô bê a dô vac Mag nɨlô dɨ xam dô vac a nɨlôg, dɨ a dô vac xam nɨlôm. ");
INSERT INTO ptp_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Xomxo ti obêc ngô a kɨyang dɨ viac nivɨha ge od xomxo tige xêyaa vin lec a, dɨ xomxo ti xêyaa obêc vin lec a ge od Mag xêyaa ob vin lec i dɨ a xêgyaa ob vin lec xomxo tige dɨ a obêc hɨlung a vô i.” ");
INSERT INTO ptp_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Yesu nêl bêge mêd Judas ngwe wê o Judas Iskaliot lêm ge nêl vô Yesu ên nêbê, “Apumtau, bêna lêc ông ob hɨlung ông vô xe dɨ ông ob hɨlung ông vô xomxo kɨbun ga vɨhati lêmê? Ge kehe bêna?” ");
INSERT INTO ptp_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Om Yesu luu i vya ên nêbê, “Xomxo ti xêyaa obêc vin lec a ge od obêc viac kɨyang wê a nêl ge nivɨha, dɨ Mag xêyaa obêc vin lec xomxo tige dɨ xii Mag ob la dô hɨxôn i. ");
INSERT INTO ptp_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Lêc xomxo wê xêyaa o vin lec a lêm ge ob viac a kɨyang nivɨha lêm. Dɨ kɨyang wê xam ngô ge, o a kɨyang lêm. Nge, Mag wê vông a lam ge, i kɨyang. ");
INSERT INTO ptp_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“A gên dô hɨxôn xam om a nêl kɨyang tiga vô xam. ");
INSERT INTO ptp_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Lêc xomxo ti dô wê ob ngɨdu xam xôn, ge Myakɨlôhô Ngɨbua wê Mag ob vông i lam lec a lêg om obêc lam tɨxuu xam ya kɨyang vɨhati, dɨ obêc vông xam pɨyôp yêp seac dɨ xam xovô kɨyang vɨhati wê a nêl vô xam ge. ");
INSERT INTO ptp_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“A ob sea kɨyang malehe i yêp vô xam, dɨ kɨyang malehe wê a vông ge, a ob vông vô xam. Kɨyang malehe wê a vông ge o tɨyi xocbê kɨyang malehe wê xomxo kɨbun ga vông ge lêm. Om xam nɨbum i o lêc tɨpi dɨ xam xona lêm. ");
INSERT INTO ptp_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Xam ngô wê a nêl vô xam ên a nêbê, ‘A ob sea xam dɨ la, dêc a obêc vena vô xam i tii vac.’ Xam xêmyaa obêc vin lec a ge od xam xêmyaa obêc vô nivɨha ên wê a ob la vô Mag ge, ên Mag ge xomxo levac luu a vêl. ");
INSERT INTO ptp_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Kɨyang ge gên o vô nôn lec lêm, lêc a nêl kɨtong vô xam tax, êdêc vô nôn lec tɨmuên ge od xam vông i vin. ");
INSERT INTO ptp_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","“A ob nêl kɨyang tɨbeac ti vô xam lêm, ên Seten wê tu xomxo kɨbun ga nên levac ge ob val, lêc o tɨyi wê ob pwoo a pec ge lêm. ");
INSERT INTO ptp_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","A nêb xomxo kɨbun ga vɨhati he i xovô bê a xêgyaa vin lec Mag, om a ob vông yuac vɨhati i tɨyi wê Mag nêl vô a ge. Om xam kɨdi lec ên il ob la. ");
INSERT INTO ptp_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“A xax wain wê nôn ge, dɨ Mag ge wê tu yuac kehe. ");
INSERT INTO ptp_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Om ngen wê a vông ge wê o vuac nôn lêm ge, Mag ob xoo vêl, dɨ ngen wê vuac ge, Mag ob yal mavɨgen vêl dɨ pɨtyep ên i vuac nôn tɨbeac. ");
INSERT INTO ptp_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Kɨyang wê a nêl vô xam ge vông xam vô paha lec pyap. ");
INSERT INTO ptp_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Xam dô vac a nɨlôg dɨ a ob dô vac xam nɨlôm. Ên xam obêc dô vac a nɨlôg lêm ge od xam ob vô nôn ti lêm, tɨyi xocbê xax ngen obêc kɨtiv lec xax yatôv lêm ge od ob vuac nôn ti lêm. ");
INSERT INTO ptp_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“A ga xax wain, dɨ xam ge ngen. Om xomxo ti obêc dô vac a nɨlôg dɨ a ob dô vac i nɨlô ge od ob vuac nôn tɨbeac, lêc xam obêc sea a ge od xam o tɨyi wê xam ob vông yuac nivɨha ti ge lêm. ");
INSERT INTO ptp_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Xomxo ti obêc dô vac a nɨlôg lêm ge od obêc tɨyi xocbê xax ngen wê he hup vêl dɨ byêx i la dɨ i la mupac dɨ he nêx i la vac ngwax dɨ ngwax ya vêl ge. ");
INSERT INTO ptp_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","“Xam obêc dô vac a nɨlôg dɨ a kɨyang obêc yêp vac xam nɨlôm ge od susu wê xam xêmyaa vin lec mɨ xam kɨtaa ge od ob vô nôn lec vô xam. ");
INSERT INTO ptp_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Xam obêc vô nôn tɨbeac ge od ob vông Mag lê vô levac dɨ xam tu a nuge. ");
INSERT INTO ptp_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","A xêgyaa vin lec xam tɨyi xocbê Mag xêyaa vin lec a ge, om xam dô vac xêyaa vin lecên wê a vông ge nɨlô i tɨyi buc vɨhati. ");
INSERT INTO ptp_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Xam obêc tɨmu vô kɨyang wê a nêl ge od xam ob dô vac xêyaa vin lecên wê a vông ge nɨlô, tɨyi xocbê a tɨmu vô kɨyang wê Mag vông ge om a dô vac xêyaa vin lecên wê i vông ge nɨlô. ");
INSERT INTO ptp_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","A nêl kɨyang tige vô xam ên a nêb xêyaa nivɨha wê a vông ge i loc vô xam dɨ i pup vac xam nɨlôm. ");
INSERT INTO ptp_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","“Xolac wê a ob nêl vô xam ge bêga bê xam xêmyaa i vin lecma i tɨyi xocbê a xêgyaa vin lec xam ge. ");
INSERT INTO ptp_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Xomxo ti obêc yib ên ngɨdu lie xôn ge od xêyaa vin lecên wê i vông ge levac luu vêl. ");
INSERT INTO ptp_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Dɨ xam obêc tɨmu vô kɨyang wê a nêl vô xam ge od xam tu a lige nôn. ");
INSERT INTO ptp_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Ilage a nêb xam tu a nuge yuac, lêc gwêbaga a ob nêl bê xam tu a lige. Ên nue yuac o xovô môp wê he nên xomxo levac nêb ob vông ge lêm, lêcom xam xovô a kɨyang vɨhati pyap, ên kɨyang wê a ngô vô Mag ge, a nêl vɨhati vô xam mɨ xam xovô pyap. ");
INSERT INTO ptp_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","“Xam o vɨnoo a lêm. Nge, a vɨnoo xam dɨ vông yuac vô xam ên a nêb xam loc vô nôn tɨbeac dɨ nôn wê xam vông ge i yêp luta. Dɨ xam obêc kɨtaa susu ti vô Mag lec a lêg ge od Mag obêc vông vô xam. ");
INSERT INTO ptp_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Om xolac wê a ob nêl vô xam ge bêga bê xam xêmyaa i vin lecma. ");
INSERT INTO ptp_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Xomxo kɨbun ga obêc yê xam nipaên ge od xam xovô bêga bê he yê a nipaên tax. ");
INSERT INTO ptp_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Xam obêc tɨyi xocbê tɨbii kɨbun ga ge od tɨbii kɨbun ga xêyaa obêc vin lec xam tɨyi xocbê he lie xam. Lêc xam o tɨyi xocbê tɨbii kɨbun ga lêm, ên a vɨnoo xam vac he mahɨgun ên a nêb xam o tu tɨbii kɨbun ga i tii vac lêm, om he xêyaa vô nipaên vô xam. ");
INSERT INTO ptp_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Xam xovô lec kɨyang wê a nêl vô xam ên a nêbê, ‘Nu yuac ti ob ngɨnoo xomxo levac wê i vông ge vêl lêm.’ Tɨbii tii a, om obêc tii xam êno. Dɨ he obêc tɨmu vô kɨyang wê a nêl ge od obêc tɨmu vô kɨyang wê xam nêl ge hɨxôn. ");
INSERT INTO ptp_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Xomxo obêc vông vaxvax vô xam ên wê xam tu axe ge, ên he o xovô xomxo ti wê vông a lam ge lêm. ");
INSERT INTO ptp_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","“A obêc lam nêl xolac vô he ilage lêm ge od he nên nipaên obêc yêp vô he lêm. Lêc a lam nêl xolac vô he, om o tɨyi wê he ob yax nipaên wê he vông ge ti vun lêm. ");
INSERT INTO ptp_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Xomxo ti obêc yê a nipaên ge od tɨyi xocbê yê Mag nipaên hɨxôn. ");
INSERT INTO ptp_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Do levac wê xomxo ti o vông ilage lêm ge, a obêc vông vac he mahɨgun lêm ge od he nên nipaên obêc yêp vô he lêm. Lêc a lam vông mɨ he yê pyap, lêc he yê xii Mag nipaên. ");
INSERT INTO ptp_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Môp wê he vông ge vông kɨyang wê yêp vac xolac wê he vông ge ti vô nôn lec. Kɨyang tige yêp bêga nêbê, ‘He xêyaa vô myavɨnê vô a pɨsiv.’ ");
INSERT INTO ptp_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Lêc xomxo wê ob ngɨdu xam xôn ge dô hɨxôn Mag om a obêc vông i lam vô xam. Ge Myakɨlôhô Ngɨbua wê ob nêl kɨyang nôn, om ob lam nêl a kɨtong vô xam. ");
INSERT INTO ptp_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Dɨ xam êno, xam ob nêl a kɨtong vô xomxo, ên xam dô hɨxôn a ilatɨkwê dɨ i val tyip gwêbaga hɨxôn. ");
INSERT INTO ptp_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“A nêl kɨyang tige vô xam ên a nêb xam o lêc sea vông vinên wê xam vông ge lêm. ");
INSERT INTO ptp_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Ên tɨbii obêc tii xam vêl ên xumac lɨlo dɨ vông xam la dô nɨnya, dɨ tɨmuên he ob hi xam wib dɨ so nêb he vông yuac nivɨha wê Anutu vông ge. ");
INSERT INTO ptp_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","He ob vông môp tibêge, ên he lungên Mag dɨ lungên a. ");
INSERT INTO ptp_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","A nêl kɨyang tiga vô xam, ên a nêb vɨyin tibêge obêc tulec xam tɨmuên ge od xam xovô bê a nêl kɨyang vô xam pyap. “A o nêl kɨyang tibêge vô xam ilage lêm, ên a dô hɨxôn xam, ");
INSERT INTO ptp_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","lêc gwêbaga a ob lax vô xomxo ti wê vông a lam ge. Lêc xam ti o kɨnêg a lêm bê ‘Ông ob la na?’, ");
INSERT INTO ptp_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","ên kɨyang wê a nêl vô xam gwêbaga vông xam dô hɨxôn nɨlôm vɨyin. ");
INSERT INTO ptp_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Lêc a nêl hɨxôn nôn vô xam bê a obêc la ge od ob vô nivɨha vô xam, ên a laên obêc ma ge od xomxo wê ob ngɨdu xam xôn ge valên obêc ma. Lêc a obêc la ge od a ob vông i lam vô xam. ");
INSERT INTO ptp_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Dɨ Myakɨlôhô Ngɨbua obêc val ge od ob nêl xomxo kɨbun ga nên nipaên kɨtong dɨ ob nêl môp nivɨha kɨtong dɨ ob nêl môp wê Anutu ob yaxên xomxo nên kɨyang ge kɨtong. ");
INSERT INTO ptp_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Om ob nêl xomxo nên nipaên kɨtong bêga bê he o vông i vin a lêm. ");
INSERT INTO ptp_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Dɨ ob nêl môp nivɨha kɨtong, ên a ob lax vô Mag dɨ xam ob wê a tii vac lêm. ");
INSERT INTO ptp_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Dɨ ob nêl kɨyang wê Anutu ob yaxên xomxo nên kɨyang ge kɨtong bêga bê Seten wê tu xomxo kɨbun ga nên levac ge, Anutu yaxên i nên kɨyang pyap om obêc vông myavɨwen vô i. ");
INSERT INTO ptp_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“A kɨyang tɨbeac yêp wê a nêb a ob nêl vô xam ge, lêc xam o tɨyi wê xam ob ngô ge lêm. ");
INSERT INTO ptp_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Lêc Myakɨlôhô Ngɨbua wê kɨyang nôn kehe ge obêc val ge od obêc dɨdii xam la vac kɨyang nôn. Lêc ob nêl ya xovôên wê ici va vông ge lêm. Nge, ob nêl kɨyang wê ngô ge kɨtong vô xam, dɨ ob nêl kɨyang yuu môp wê ob val tɨmuên ge kɨtong vô xam hɨxôn. ");
INSERT INTO ptp_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Myakɨlôhô Ngɨbua ob vông a lêg i vô levac, ên ob kô kɨyang wê a vông ge mɨ lam nêl kɨtong vô xam. ");
INSERT INTO ptp_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Kɨyang vɨhati wê Mag vông ge tu axe pyap om a nêl vô xam bê Myakɨlôhô Ngɨbua ob kô kɨyang vô a dɨ nêl kɨtong vô xam. ");
INSERT INTO ptp_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Buc myabo tya dɨ xam wêên a obêc ma, dɨ obêc buc myabo tya nang, lêc xam obêc wê a tii vac.” ");
INSERT INTO ptp_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Yesu nue ngɨvihi ya kɨnêg vôma ên nêbê, “Kɨyang tige kehe bêna? Ên nêl ên nêbê buc myabo tya dɨ il xêên i obêc ma, dɨ buc myabo tya nang lêc il obêc xê i tii vac. Dɨ nêl ên nêb i ob la vô Ma. ");
INSERT INTO ptp_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Om vya wê nêl ên nêbê buc myabo tya, ge kehe bêna? Il lungên kɨyang tyo kehe.” ");
INSERT INTO ptp_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Yesu xovô wê he nêb ob kɨnêg kɨyang vô i ge, om nêl vô he ên nêbê, “Kɨyang wê a nêl ên a nêbê buc myabo tya dɨ xam wêên a obêc ma, dɨ buc myabo tya nang lêc xam obêc wê a tii vac nang, xam dɨkɨnêgma lec kɨyang tige mê? ");
INSERT INTO ptp_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","A nêl vɨxôhɨlôg nôn vô xam bê xam obêc byag nôn, lêc tɨbii wê o vông i vin lêm ge ob dô hɨxôn xêyaa nivɨha. Xam obêc dô hɨxôn nɨlôm vɨyin lê, lêc nɨlôm vɨyin obêc pɨlepac dɨ vông xam nɨlôm vô nivɨha. ");
INSERT INTO ptp_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Obêc vô kwabo lec wê vêx ti nu obêc yubac ge od vêx tige dô hɨxôn vɨyin ên xovô nêbê buc wê ob yaxên myavɨnê ge vô kwabo lec, lêc nu obêc yubac vêl ge od ob xovô myavɨnê tii vac lêm. Nge, ob dô hɨxôn xêyaa nivɨha ên wê nu tige yubac vêl ge. ");
INSERT INTO ptp_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Om gwêbaga xam dô hɨxôn nɨlôm vɨyin, lêc a obêc xê xam tii vac nang, om xam ob dô hɨxôn xêmyaa nivɨha yang, dɨ xomxo ti o tɨyi wê ob vô xêyaa nivɨha tige vêl ên xam ge lêm. ");
INSERT INTO ptp_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Obêc vô buc tɨmuên ge xam obêc kɨnêg kɨyang ti vô a i tii vac nang lêm. A nêl hɨxôn nôn vô xam bê xam obêc kɨtaa susu ti vô Mag lec a lêg ge od obêc vông vô xam. ");
INSERT INTO ptp_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Ilage xam o kɨtaa susu ti lec a lêg lêm, om xam obêc kɨtaa ge od xam ob kô nôn dɨ xêmyaa obêc vô nivɨha yang. ");
INSERT INTO ptp_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“A nêl kɨyang tige vô xam tɨyi xocbê kɨyang pɨlepacên. Lêc obêc tɨmuên ge od a ob nêl kɨyang pɨlepacên ti i tii vac vô xam lêm. Nge, a ob nêl Mag kehe i yêp seac vô xam. ");
INSERT INTO ptp_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Vô buc tige xam obêc kɨtaa vô Anutu lec a lêg. A o nêl vô xam bê aca va ob kɨtaa vô Mag ên i ngɨdu xam xôn lêm, ");
INSERT INTO ptp_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","ên Mag vaci xêyaa vin lec xam ên wê xam xêmyaa vin lec a dɨ xam vông i vin ên xam nêbê a dô hɨxôn Mag lêc lam ge. ");
INSERT INTO ptp_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Ilage a dô hɨxôn Mag lêc a sea Mag dɨ lam kɨbun, dɨ gwêbaga a ob sea kɨbun dɨ lax mɨ la vô Mag i tii vac.” ");
INSERT INTO ptp_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Mêd nue ngɨvihi nêl vô i ên nêbê, “Gwêbaga ông nêl kɨyang yêp seac dɨ ông o nêl kɨyang pɨlepacên lêm. ");
INSERT INTO ptp_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Om gwêbaga xe xovô ên xe nêbê ông xovô kɨyang vɨhati pyap om ông o bin dɨ xomxo kɨnêg ông tax lêm. Om xe xovô ên xe nêbê ông dô hɨxôn Anutu lêc lam.” ");
INSERT INTO ptp_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Mêd Yesu luu he vya ên nêbê, “Gwêbaga xam vông i vin a mê? ");
INSERT INTO ptp_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Xam ngô le. Buc vô kwabo lec pyap om tɨbii ob tii xam sea dɨ xam toto ge ob la bom bom dɨ aca va ob dô tamaên. Lêcom obêc aca va lêm, ên Mag dô hɨxôn a. ");
INSERT INTO ptp_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","A nêl kɨyang tiga vô xam ên a nêb xam dô vac a nɨlôg hɨxôn kɨyang malehe. Xam obêc tulec vɨyin gê kɨbun ga, lêc xam nɨlôm i nivɨha, ên a pwoo nipaên kɨbun ga pec pyap.” ");
INSERT INTO ptp_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Yesu nêl kɨyang tige pyap dɨ manôn la kɨsii dɨ i nêl ên nêbê, “Mag, buc tyo val pyap, om ông vông a lêg i vô levac, êdêc a vông ông lêm i vô levac. ");
INSERT INTO ptp_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Ên ông vông xomxo vɨhati la vac a kwa ngɨbi ên ông nêb a vông he wê ông vɨnoo nêb he i tu axe ge vɨhati i dô mavɨha luta lêc luta. ");
INSERT INTO ptp_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Dɨ mavɨha luta dôên kehe bêga nêbê xomxo ob xovô ông bê ông Anutu nôn tibed vɨxôhɨlôg, dɨ ob xovô Yesu Kɨlisi wê ông vông i lam ge. ");
INSERT INTO ptp_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","A hɨlung xêseac wê ông vông ge gê kɨbun ga, dɨ yuac vɨhati wê ông nêb a vông ge, a vông i la tɨyi. ");
INSERT INTO ptp_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Mag, ilage wê kɨbun gên ma ge od a dô hɨxôn ông vac xêseac, om gwêbaga a nêb ông vông xêseac tige vô a i tii vac nang. ");
INSERT INTO ptp_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“A nêl ông lêm kɨtong vô xomxo wê ông vɨnoo nêb he tu axe gê kɨbun ga. He ge ông nume, dɨ ông vông he vô a. He viac ông kɨyang nivɨha, ");
INSERT INTO ptp_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","dɨ gwêbaga he xovô ên he nêbê kɨyang vɨhati wê ông vông vô a ge, lam vô ông. ");
INSERT INTO ptp_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Ên kɨyang wê ông nêl vô a ge, a nêl kɨtong vô he mɨ he vông i vin. Dɨ he xovô vɨxôhɨlôg nôn ên he nêbê a dô hɨxôn ông lêc lam, dɨ he vông i vin ên he nêbê ông vông a lam. ");
INSERT INTO ptp_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“Om a kɨtaa lec he. A o kɨtaa lec xomxo kɨbun ga vɨhati lêm. Nge, a kɨtaa ên xomxo wê ông vɨnoo nêb he i tu axe ge, ên he tu ông nume pyap. ");
INSERT INTO ptp_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Xomxo vɨhati wê tu a nuge ge tu ông nume, dɨ ông nume vɨhati tu a nuge. Dɨ môp wê he vông ge vông a lêg vô levac. ");
INSERT INTO ptp_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","A ob dô kɨbun ga i tii vac lêm. Nge, a ob loc vô ông. Dom he ge he ob dô kɨbun ga. Mag, ông ngɨbua, om ông viac he ên he i dô vac ông lêm ti wê ông vông vô a ge nɨlô, dɨ he i dô tibed tɨyi xocbê u tibed ge. ");
INSERT INTO ptp_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Buc wê a dô hɨxôn he ge a viac he dɨ he dô vac ông lêm ti wê ông vông vô a ge. A viac he nivɨha om he ti ob la xôa ma lêm. Lêc xomxo tibed ob kô myavɨwen mɨ la xôa ma, ên kɨyang wê yêp vac xolac ge i vô nôn lec. ");
INSERT INTO ptp_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Gwêbaga a ob lôc vô ông, dɨ a nêl kɨyang tige gê kɨbun ga, ên a nêb xêyaa nivɨha wê a vông ge i yêp vac he nɨlô. ");
INSERT INTO ptp_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","“A nêl ông kɨyang vô he mɨ he vông i vin om tɨbii kɨbun ga yê he nipaên, ên xomxo vông vinên kehe o kɨbun ga lêm, tɨyi xocbê a kehe o kɨbun ga lêm. ");
INSERT INTO ptp_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","A o kɨtaa ông bê ông kô he vêl ên kɨbun ga lêm. Nge, a kɨtaa ông ên a nêb ông viac he ên xomxo nipaên Seten. ");
INSERT INTO ptp_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","He kehe o kɨbun ga lêm, tɨyi xocbê a kehe o kɨbun ga lêm. ");
INSERT INTO ptp_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Ông vông he i tu ngɨbua ya kɨyang nôn. Ên kɨyang wê ông vông ge, kɨyang nôn. ");
INSERT INTO ptp_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Ông vông a lam dô vac xomxo kɨbun ga mahɨgun, om a vông he kô a kɨyang mɨ la vac xomxo mahɨgun êno bêge. ");
INSERT INTO ptp_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","A vông a dɨluhu vô ông ên he, ên a nêb he i tu nume ngɨbua nôn. ");
INSERT INTO ptp_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Lêc a o kɨtaa ên xomxo tigee vaci lêm. Nge, a kɨtaa ên tɨbii wê ob ngô he kɨyang dɨ vông i vin a hɨxôn ge. ");
INSERT INTO ptp_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Mag, a nêb xomxo tigee vɨhati, he i dô tibed. Ên ông dô vac a nɨlôg dɨ a dô vac ông nɨlôm, om a nêb he i dô vac u nɨlôd, ên xomxo kɨbun ga he i yê dɨ xovô bê ông vông a lam. ");
INSERT INTO ptp_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Xêseac wê ông vông ge, a vông vô he ên a nêb he vɨhati i dô tibed, tɨyi xocbê u dô tibed ge. ");
INSERT INTO ptp_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","A dô vac he nɨlô dɨ ông dô vac a nɨlôg, om a nêb he i dô nôn tibed, ên xomxo kɨbun ga he i yê dɨ xovô bê ông vông a lam, dɨ he i xovô bê ông xêmyaa vin lec he tɨyi xocbê ông xêmyaa vin lec a ge. ");
INSERT INTO ptp_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Mag, ông vɨnoo xomxo tigee nêb he i tu axe om a nêb he i dô hɨxôn a vac vɨgwe wê a ob dô vac ge, ên he i yê xêseac wê a vông ge. Vô buc wê kɨbun gên ma ge, ông xêmyaa vin lec a om ông vông xêseac tige vô a. ");
INSERT INTO ptp_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Mag, ông xomxo bôbac. Xomxo kɨbun ga lungên ông, lêc a xovô ông, dɨ xomxo tigee xovô nêbê ông vông a lam. ");
INSERT INTO ptp_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","A nêl ông lêm kɨtong vô he dɨ a ob nêl i tii vac vô he, ên môp wê ông xêmyaa vin lec a ge i yêp vac he nɨlô dɨ a dô vac he nɨlô hɨxôn.” ");
INSERT INTO ptp_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Yesu kɨtaa pyap mêd la hɨxôn nue ngɨvihi mɨ he la mia Kidlon vɨlu ganê dɨ la vac yuac ti wê yevên xax vac ge. ");
INSERT INTO ptp_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Lêc Judas ti wê nêl Yesu kɨtong vô tɨbii vevac ge xovô vɨgwe tige, ên Yesu he nue ngɨvihi mi kɨtucma vac vɨgwe tige tɨyi buc tɨbeac. ");
INSERT INTO ptp_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Om Judas kô tɨbii vevac Lom kɨdu ti dɨ kô xêhɨpu wê xomxo levac daa siên hɨxôn he Palisi vông ge mɨ he la, mêd he dii ngwax dɨ kɨlê susu vevac dɨ mɨla vac vɨgwe tige. ");
INSERT INTO ptp_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Yesu xovô môp wê he ob vông vô i ge vɨhati pyap om la kwabo vô he dɨ kɨnêg vô he ên nêbê, “Xam myag letya?” ");
INSERT INTO ptp_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Mêd he nêl vô i ên nêbê, “Xe myag Yesu Nasalet.” Om Yesu nêl vô he ên nêbê, “A ga mê.” Judas wê nêb ob vông Yesu vac he vɨgê ge le hɨxôn he. ");
INSERT INTO ptp_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Yesu nêl ên nêbê, “A ga xomxo tyo” mêd xomxo tigee du mɨ lax ya nɨmi dɨ vɨxog sea mɨ la yêp kɨbun. ");
INSERT INTO ptp_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Mêd Yesu kɨnêg vô he tii vac ên nêbê, “Xam myag letya?” Mêd he nêl vô i ên nêbê, “Yesu Nasalet.” ");
INSERT INTO ptp_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Mêd Yesu nêl vô he ên nêbê, “A nêl vô xam gwêba ên a nêb a ga mê, om xam obêc myag a ge od xam vông a nuge i loc vêl lê.” ");
INSERT INTO ptp_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Yesu nêl kɨyang tige ên nêb kɨyang wê nêl ilage i vô nôn lec, kɨyang ti wê nêl ên nêbê, “Xomxo wê ông vɨnoo ên ông nêb he i tu axe ge, a o sea ti mɨ i la dô xel lêm.” ");
INSERT INTO ptp_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Mêlêc Saimon Pita kô yipac ti om tul vêl ên ninɨvi dɨ sev xomxo levac wê mi si daa ge nu yuac ti nɨnya vɨlu hɨyôv la vêl. Nu yuac tige lê nêbê Malkas. ");
INSERT INTO ptp_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Mêd Yesu nêl vô Pita ên nêbê, “Hoo yipac i lôc vac ninɨvi. Mia kɨlin wê Mag vông vô a ge, mêd a numên ob ma?” ");
INSERT INTO ptp_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Tɨbii vevac tigee hɨxôn xomxo levac ti wê viac he ge dɨ xêhɨpu wê he Yuda vông ge he hôm Yesu xôn dɨ ku xôn ");
INSERT INTO ptp_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","dɨ kô mɨ la tax vô Anas wê Kaiapas yen ge. Kaiapas ge wê tu xomxo daa siên nên levac lec klismas tige. ");
INSERT INTO ptp_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Kaiapas ge wê nêl vô he Yuda ilage ên nêbê, “Xomxo tibed obêc yib ên ngɨdu xomxo vɨhati xôn ge od obêc nivɨha.” ");
INSERT INTO ptp_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Saimon Pita yuu li ngɨvihi ngwe, yuu la vô Yesu vɨxa. Xomxo wê mi si daa gee nên xomxo levac xovô nu ngɨvihi ngwe ge, om nu ngɨvihi tige la xenac lôma hɨxôn Yesu vac xomxo levac tige ben ");
INSERT INTO ptp_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","dom Pita le vɨxun. Om nu ngɨvihi ngwe wê xovôxomxo levac tige lôm nêl vô vêx ti wê viac vuayen ge om kô Pita mɨ lam vac xenac lôma. ");
INSERT INTO ptp_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Mêd vêx tige nêl vô Pita ên nêbê, “Ông ge mêd xomxo tiga nue ngɨvihi ti?” Lêc Pita nêl vô i ên nêbê, “Ma, a o tu i nue ngɨvihi ti lêm.” ");
INSERT INTO ptp_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Vɨgwe vô ningɨgooên om nue yuac hɨxôn xêhɨpu vev ngwax mɨ nyuu, dɨ Pita la le hɨxôn mɨ he nyuu ngwax. ");
INSERT INTO ptp_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Xomxo ti wê tu xomxo daa siên nên levac ge kɨnêg Yesu lec nue ngɨvihi dɨ kɨnêg kɨyang wê mi nêl vô xomxo ge. ");
INSERT INTO ptp_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Om Yesu nêl vô i ên nêbê, “Kɨyang wê a mi nêl ge, ge a nêl i yêp seac vô xomxo vɨhati. Tɨyi buc tɨbeac a la nêl kɨyang vac Yuda xumac lɨlo dɨ a nêl vac Anutu xumac ngɨbua wê Yuda tɨbeac lam mi kɨtucma vac ge, dɨ a o nêl kɨyang ti xôpacên lêm. ");
INSERT INTO ptp_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Bêna lêc ông kɨnêg kɨyang vô a? Ông kɨnêg vô xomxo wê ngô kɨyang gee bêc a nêl kɨyang vatya vô he. Ên he xovô kɨyang wê a nêl vô he ge.” ");
INSERT INTO ptp_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Yesu nêl kɨyang tige dɨ xêhɨpu wê le ge ti lam pɨtap Yesu lia dɨ nêl vô i ên nêbê, “Ông ob nêl kɨyang tibêge vô xomxo levac wê mi si daa ge lêmê.” ");
INSERT INTO ptp_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Lêc Yesu nêl vô i ên nêbê, “A obêc nêl kɨyang ti so ge od ông nêl kɨyang tige bê kɨyang tige so. Lêc kɨyang wê a nêl ge obêc nôn ge, od bêna lêc ông hi a pɨleva?” ");
INSERT INTO ptp_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Yihi gên dô lec Yesu vɨgê dɨ Anas vông i la vô Kaiapas wê tu xomxo daa siên nên levac ge. ");
INSERT INTO ptp_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Pita nyuu ngwax mɨ le, lêc xomxo tigee kɨnêg vô i ên nêbê, “Ông ge xomxo tige nue ngɨvihi ti?” Lêc Pita nêl ên nêbê, “A o i nue ngɨvihi ti lêm.” ");
INSERT INTO ptp_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Mêd xomxo ti wê tu xomxo daa siên nên levac ge, nue yuac ti dô. Nu yuac tige lie ti wê Pita sev nɨnya lihi vêl ge om nu yuac tige nêl vô Pita ên nêbê, “A xê ông dô hɨxôn i vac yuac lôma.” ");
INSERT INTO ptp_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Lêc Pita yax Yesu vun tii vac dɨ lutibed kokɨlêx vô vya. ");
INSERT INTO ptp_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Vô pɨtoc yang he sea Kaiapas ben dɨ kô Yesu mɨ la gavman levac ben, lêc he Yuda nêb ob la xumac lôma hɨxôn lêm, ên he xona nêb he obêc la vac tɨbii wê o Yuda lêm ge ben ge od ob pwoo he xolac vac dɨ o tɨyi wê he ob ya vɨzid Pasova ge lêm. ");
INSERT INTO ptp_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Om gavman levac Pailat lam vɨxun vô he dɨ kɨnêg vô he ên nêbê, “Xam ob vông kɨyang vô xomxo tiga lec kɨyang tina?” ");
INSERT INTO ptp_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Om he nêl vô i ên nêbê, “Xomxo tige vôngên nipaên obêc ma ge od xe ob kô mɨ lam vô ông lêm.” ");
INSERT INTO ptp_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Mêd Pailat nêl vô he ên nêbê, “Om xam kô mɨ loc dɨ loc yaxên i tɨyi xocbê xolac wê xam vông ge.” Lêc he Yuda nêl vô Pailat ên nêbê, “Xam Lom vɨbu xe ên xam nêbê o tɨyi wê xe ob hi xomxo ti i yib ge lêm.” ");
INSERT INTO ptp_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Ilage Yesu nêl môp wê tɨbii ob hi i yib ge om kɨyang wê he Yuda nêl ge vông kɨyang wê Yesu nêl ge vô nôn lec. ");
INSERT INTO ptp_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Mêd Pailat lax vac ben dɨ keac Yesu la vô i, dɨ kɨnêg i ên nêbê, “Ông ge king wê he Yuda vông ge, me?” ");
INSERT INTO ptp_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Lêc Yesu luu i vya ên nêbê, “Ôcông va xovô kɨyang tige lêc kɨnêg, me xomxo ya nêl a kɨtong vô ông?” ");
INSERT INTO ptp_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Mêd Pailat nêl vô i ên nêbê, “Bêna lêc ông kɨnêg kɨyang tiga vô a? A o Yuda ti lêm. Ông lime Yuda hɨxôn xomxo levac wê mi si daa gee wê he kô ông mɨ lam vô a. Om ông vô va lê?” ");
INSERT INTO ptp_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Lêc Yesu nêl vô i ên nêbê, “He wê la vac a kwa ngɨbi dɨ a tu he nên king ge, kehe o yêp gê kɨbun ga lêm. Ên kehe obêc yêp kɨbun ga ge od a nuge obêc vông vevac kɨsuu a lec ên nêb he Yuda i o lêc hôm a xôn lêm. Lêc o bêge lêm, ên môp wê a tu he nên king ge, o yêp gê kɨbun ga lêm.” ");
INSERT INTO ptp_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Om Pailat kɨnêg vô i ên nêbê, “Om ông ge king ti?” Mêd Yesu nêl vô Pailat ên nêbê, “Ôcông va nêb a king. A lam yubac gê kɨbun ga dɨ kehe bêga nêbê a ob nêl kɨyang nôn i yêp seac vô xomxo. Dɨ xomxo wê kɨyang nôn yêp vac he nɨlô ge wê ngô a vyag.” ");
INSERT INTO ptp_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Lêc Pailat kɨnêg vô Yesu ên nêbê, “Kɨyang nôn ge vatya?” Pailat nêl bêge mêd lop mɨ lôm vɨxun vô he Yuda dɨ nêl vô he ên nêbê, “A o tulec kɨyang ti lec xomxo tiga lêm. ");
INSERT INTO ptp_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Lêc môp wê xam vông ge mi yêp bêga nêbê buc Pasova ge a mi pɨwelac xomxo ti dɨ vông i loc vô xam. Om xam nêb a pɨwelac king wê xam Yuda vông ge vêl, me?” ");
INSERT INTO ptp_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Lêc he tyuc vya levac ên nêbê, “O xomxo tige lêm. Nge, ông vông Balabas i lôm vô xe.” Balabas ge wê mi hi xomxo dɨ vun he susu ge ti. ");
INSERT INTO ptp_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Mêd Pailat nêl dɨ nue vevac kô Yesu mɨ la pɨsa i ya yihi. ");
INSERT INTO ptp_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Mêd tɨbii vevac tigee buu kɨpomac yin dɨ tung lec Yesu bazub dɨ kô ngakwi hi tɨyi xocbê king mi vɨnyum ge mɨ la vɨnyum lec Yesu, ");
INSERT INTO ptp_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","mêd he la le vô i manôn dɨ nêl vô ên nêbê, “Ông king wê Yuda vông ge, ông dô nimvɨha.” He nêl bêge dɨ pɨtap i lia. ");
INSERT INTO ptp_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Mêd Pailat lop mɨ lôm vɨxun tii vac dɨ nêl vô he Yuda ên nêbê, “Xam ngô lê. A ob vông xomxo tige i lôm vô xam ên xam xovô bê a o tulec kɨyang ti lec i lêm.” ");
INSERT INTO ptp_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Mêd Yesu lop mɨ lam vɨxun, lêc kɨpomac yin wê he buu ge dô lec bazub dɨ i vɨnyum ngakwi hi wê king vông ge lec. Om Pailat nêl vô xomxo tigee ên nêbê, “Xam wê xomxo tinê.” ");
INSERT INTO ptp_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Mêd xomxo levac wê mi si daa gee hɨxôn xêhɨpu yê Yesu dɨ tyuc vya levac nêbê, “Tul i lec xax pola. Tul i lec xax pola.” Mêd Pailat nêl vô he ên nêbê, “Om xacxam va kô i mɨ loc tul lec xax, ên a o tulec soên ti vô i lêm.” ");
INSERT INTO ptp_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Mêd he Yuda nêl vô i ên nêbê, “Xolac wê xe vông ge ti yêp bêga nêbê xomxo tige ob yib, ên yong i ên nêb i Anutu nu.” ");
INSERT INTO ptp_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Pailat ngô kɨyang wê he nêl ge dɨ xona mabu, ");
INSERT INTO ptp_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","dɨ lax vac ben xumac lôma dɨ kɨnêg vô Yesu ên nêbê, “Ông vac vɨgwe tina?” Lêc Yesu vô myapɨlihi vô i. ");
INSERT INTO ptp_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Om Pailat nêl vô i ên nêbê, “Bêna lêc ông o nêl kɨyang ti vô a lêmê? Xêkɨzêc wê a vông ge tɨyi wê a ob pɨwelac ông vêl, dɨ xêkɨzêc wê a vông ge tɨyi wê he ob tul ông lec xax. Lêc mêd ông o xovô tige lêm?” ");
INSERT INTO ptp_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Lêc Yesu nêl vô i ên nêbê, “Anutu lag puunê obêc vông xêkɨzêc vô ông lêm ge od ông o tɨyi wê ông ob vông susu ti vô a lêm. Om xomxo ti wê vông a vac ông vɨgêm ge, nipaên wê i vông ge levac mabu luu nipaên wê ông vông ge vêl.” ");
INSERT INTO ptp_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Pailat ngô kɨyang tige mêd myag môp wê nêb ob pɨwelac Yesu vêl ge. Lêc he Yuda tyuc ên nêbê, “Ông obêc pɨwelac i vêl ge od ông o tɨmu vô kɨyang wê king Sisa vông ge lêm, ên xomxo ti obêc nêb i king ge od xomxo tige kô i lec vô Sisa.” ");
INSERT INTO ptp_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Pailat ngô kɨyang tige mêd kô Yesu mɨ la vɨxun dɨ lax dô lec sia wê xomxo mi dô lec dɨ tɨtô xomxo nên kɨyang ge. Vac he Yuda vya, he nêl vɨgwe tige lê nêbê Gabata, dɨ kehe bêga nêbê pêt ngɨdax. ");
INSERT INTO ptp_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Vô buc tige he Yuda viac he ên vɨzid Pasova wê he ob ya tɨtige mêd hɨyôv tyip kɨtôn dɨ Pailat nêl vô he Yuda ên nêbê, “Xam wê king wê xam vông ge lê.” ");
INSERT INTO ptp_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Lêc he tyuc ên nêbê, “Xam kô i mɨ loc vêl, dɨ loc hi i lec xax pola.” Mêd Pailat kɨnêg vô he ên nêbê, “Xam nêb a tul king wê xam vông ge lec xax pola, me?” Mêd xomxo levac wê mi si daa gee nêl vô i ên nêbê, “King wê xe vông ge, Sisa tibed dɨ king ngwe o dô hɨxôn lêm.” ");
INSERT INTO ptp_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Om Pailat vông Yesu la vac he vɨgê ên nêb he i tul i lec xax pola. ");
INSERT INTO ptp_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Mêgem he kô Yesu mɨ la, mêd Yesu kɨlê xax pola wê he ob hi i lec ge dɨ sea vɨgwe Jelusalem dɨ mɨla vɨgwe ti wê he nêl lê vac Yuda vya nêbê Golgota, kehe bêga nêbê bazub len. ");
INSERT INTO ptp_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Mêd he tul Yesu lec xax pola vac vɨgwe tige, dɨ tul tɨbii yuu lec xax hɨxôn Yesu, om Yesu yux vac mahɨgun dɨ tɨbii yuuo ge, ngwe yux vɨlu dɨ ngwe yux vɨlu. ");
INSERT INTO ptp_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Mêd Pailat kɨvuu kɨyang bo ti dɨ tul lec xax hɨxôn. Kɨyang tige nêl bêga nêbê, “YESU NASALET, KING WÊ HE YUDA VÔNG GE.” ");
INSERT INTO ptp_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Vɨgwe wê he hi Yesu lec xax ge yêp kwabo vô Jelusalem om xomxo tɨbeac kɨtong kɨyang tige, ên Pailat kɨvuu vac Yuda vya dɨ Lom vya dɨ Glik vya. ");
INSERT INTO ptp_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Mêgem Yuda levac wê mi si daa gee nêl vô Pailat ên nêbê, “Letya nêb ông kɨvuu bê king wê xe Yuda vông ge? Ông kɨvuu bêga bê xomxo tiga vaci nêl ên nêb i king wê Yuda vông ge.” ");
INSERT INTO ptp_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Lêc Pailat nêl vô he ên nêbê, “Kɨyang wê a kɨvuu pyap ge ob yêp ya wê a kɨvuu ge.” ");
INSERT INTO ptp_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Tɨbii vevac tul Yesu lec xax pyap mêd kô i ngakwi dɨ tung i dô kɨdu yuudɨyuu dɨ tɨtang vôma dɨ toto kô. Dom ngakwi dia wê i vông ge o duuên tɨyi xocbê siot yuu ngakwi baba lêm. Nge, duuên vac kwa dɨ i la tô lec vɨxa. ");
INSERT INTO ptp_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Om tɨbii vevac nêl vôma ên nêbê, “Il ob lêx nivɨmihi tige lêm, om il ob tɨde mɨ xê bêc letya ob kô.” He nêl bêge om kɨyang ti wê yêp vac kɨpihac xolac ge vô nôn lec, kɨyang wê nêl bêga nêbê, “He tɨtang a ngakwi tɨyi he dɨ he tɨde nêb he tina wê ob kô ngakwi dia wê a vông ge.” Tɨbii vevac vông môp tibêge. ");
INSERT INTO ptp_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Vêx yuudɨyuu le vac Yesu xax pola ngɨbi, Yesu ta yuu li vêx, dɨ Malia wê Klopas vɨnê ge yuu Malia Makdala. ");
INSERT INTO ptp_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Mêd Yesu yê wê ta le ge, dɨ a Jon, wê Yesu xêyaa vin lec a ge, a le hɨxôn om Yesu nêl vô ta ên nêbê, “Tag, wê. Ông num le ge.” ");
INSERT INTO ptp_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Nang dêc nêl vô a ên nêbê, “Wê, tam le ge.” Mêgem buc tige a kô Yesu ta mɨ i la dô hɨxôn a vac xumac wê a vông ge. ");
INSERT INTO ptp_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Tige pyap mêd Yesu xovô nêbê yuac vɨhati pyap, om nêl ên nêbê, “A ob num mia.” Yesu nêl bêge om kɨyang bo ti wê yêp vac kɨpihac xolac ge vô nôn lec. ");
INSERT INTO ptp_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Mia kɨlin le vac dêg om he kô myamɨlumac wê le vac gwec nɨlô ge dɨ tɨnyum vac mia kɨlin dɨ kɨlax vac xax ti dɨ hôm la kɨsii vô Yesu mya. ");
INSERT INTO ptp_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Yesu num mia kɨlin tige pyap dɨ nêl ên nêbê, “Pyap mêga.” Nêl dɨ kwa too dɨ i yib. ");
INSERT INTO ptp_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Buc tige, buc wê he Yuda ob viac he ên Pasova tɨtige, ên Pasova ge da levac wê ngɨnoo vêl ge, om he nêb xomxo ninɨvi i o yux lec xax pola vô buc levac lêm. Om he la nêl vô Pailat nêb tɨbii i loc hi he vɨxa i pec ên he i yib lutibed ên he ob kwax vêl. ");
INSERT INTO ptp_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Om tɨbii vevac la hi tɨbii yuu wê he hi lec xax hɨxôn Yesu ge vɨxa pec. ");
INSERT INTO ptp_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Dɨ he yê Yesu lêc yib om he o hi Yesu vɨxa pec lêm. ");
INSERT INTO ptp_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Lêc tɨbii vevac ti kɨtiv Yesu vac byeac dɨ hi yuu mia lam lutibed. ");
INSERT INTO ptp_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","A Jon, a xê tige lec magnôn om a nêl kɨtong ên a nêb xam êno vông i vin. Kɨyang wê a nêl ge kɨyang nôn, dɨ aca va xovô bêga bê kɨyang tige nôn vɨxôhɨlôg. ");
INSERT INTO ptp_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Môp wê tɨbii vevac vông ge vông kɨyang wê yêp vac kɨpihac xolac ge bo ti vô nôn lec, kɨyang wê yêp bêga nêbê, “I len ti pecên obêc ma.” ");
INSERT INTO ptp_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Dɨ kɨyang ngwe yêp bêga nêbê, “Xomxo ob yê manôn lec xomxo ti wê he kɨtiv i ge.” ");
INSERT INTO ptp_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Pyap mêd Josep wê ben Alimatia ge la kɨtaa Pailat ên nêb ob kô Yesu ninɨvi mɨ la yev. Josep ge vông i vin Yesu lêc o nêl kɨtong seac lêm, ên xona ên he Yuda. Mêd Pailat tyuc lec nêb Josep i kô Yesu ninɨvi om Josep la kwax Yesu ninɨvi vêl ên xax. ");
INSERT INTO ptp_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Mêd Nikodimas ti wê la vô Yesu vô bucên ilage la hɨxôn, om kô xax myaluc wê nivɨvea nivɨha ge yuu dɨ pɨlepac yuu xôn. Myaluc tige vɨyin mabu tɨyi xocbê 30 kilo. ");
INSERT INTO ptp_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Mêd yuu kô Yesu ninɨvi dɨ vɨyum vac nivɨmihi hɨxôn susu nivɨvea tige, tɨyi xocbê môp wê Yuda mi vông vô xomxo yibên ge. ");
INSERT INTO ptp_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Yuac ti yêp kwabo vô vɨgwe ti wê he hi Yesu yib vac ge. Dɨ lôva wê he kɨden vac ngɨdax ên nêb ob lii xomxo yibên vac ge ti yêp vac yuac tige mahɨgun, lêc he gên o lii yibên ti la vac lêm. ");
INSERT INTO ptp_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Buc tige, buc wê Yuda ob viac he ên sabat tɨtige, dɨ lôva tige yêp kwabo om yuu kô Yesu ninɨvi mɨ la lii vac lôva tyo. ");
INSERT INTO ptp_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Da pɨtoc yang, Malia wê ben Makdala ge loc mɨ la lôva, lêc yê wê ngɨdax tɨtêc la nɨnya vêl ên lôva mya ge. ");
INSERT INTO ptp_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Om tup mɨ lax vô Saimon Pita yuu li ngɨvihi ngwe wê Yesu xêyaa vin lec i ge dɨ nêl vô yuu ên nêbê, “He kô Apumtau vac lôva dɨ xe lungên vɨgwe wê he la lii vac ge.” ");
INSERT INTO ptp_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Mêd Pita yuu li ngɨvihi ngweo la nêb ob la yê vac lôva. ");
INSERT INTO ptp_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Yuu tup, lêc li ngɨvihi ngwe ge luu Pita vêl dɨ mɨla le vô lôva tax, ");
INSERT INTO ptp_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","om kɨlong lôva nɨlô lêc yê nivɨmihi wê vɨyumên Yesu ninɨvi vac ge dɨyêp, lêc o la vac lôva nɨlô lêm. ");
INSERT INTO ptp_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Mêd Saimon Pita mɨla tɨmuên dɨ la vac lôva nɨlô mɨ la yê nivɨmihi pɨleva wê dɨyêp ge, ");
INSERT INTO ptp_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","dɨ yê nivɨmihi ti wê he vɨyum Yesu bazub vac ge lêc o dô hɨxôn nivɨmihi wê he vɨyum Yesu nôn vac ge lêm. Nge, nivɨmihi tige buuên dɨ i la dô vɨyonên. ");
INSERT INTO ptp_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Nang dêc nu ngɨvihi ngwe wê mɨla lôva tax ge la vac lôva nɨlô dɨ la yê om vông i vin. ");
INSERT INTO ptp_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Lêc kɨyang wê yêp vac kɨpihac xolac ên nêbê Yesu ob kɨdi lec vac yibên ge, he gên o xovô lêm. ");
INSERT INTO ptp_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Mêd nu ngɨvihi yuu ge lax mɨ la ben. ");
INSERT INTO ptp_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Malia le kwabo vô lôva nɨvi dɨ byag. Byag dɨ kɨlong lôva nɨlô, ");
INSERT INTO ptp_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","lêc yê angela wê vɨnyum ngakwi kwem ge yuu dô lec vɨgwe wê Yesu ninɨvi yêp lec ge, ngwe dô vô bazub dɨ ngwe dô vô vɨxa. ");
INSERT INTO ptp_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Mêd yuu nêl vô Malia ên nêbê, “Ông byag ên vatya?” Om Malia nêl vô yuu ên nêbê, “He kô a Apumtau vêl dɨ a lungên vɨgwe wê he la lii vac ge.” ");
INSERT INTO ptp_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Malia nêl bêge mêd pɨlepac i, lêc yê wê Yesu le ge, lêc o xovô bê ge Yesu lêm. ");
INSERT INTO ptp_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Mêd Yesu nêl vô i ên nêbê, “Vêx, ông byag ên vatya? Ông myag letya?” Malia xo nêb mêd Yesu ge xomxo ti wê mi viac vɨgwe tige om nêl vô i ên nêbê, “Ông obêc kô xomxo tige ninɨvi mɨ la ge od ông nêl vɨgwe ti wê ông la lii vac ge kɨtong vô a, ên a ob la kô mɨ lôm.” ");
INSERT INTO ptp_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Mêd Yesu nêl vô i ên nêbê, “Malia.” Mêd Malia pɨlepac i dɨ nêl vô Yesu vac Yuda vya bêga ên nêbê, “Labonai.” Kehe bêga nêbê xolac kehe. ");
INSERT INTO ptp_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Mêd Yesu nêl vô i ên nêbê, “Le i lêc vyax vɨgê lec a lêm, ên a gên o lec mɨ lax vô Mag lêm. Om ông lôc vô a lige dɨ nêl vô he bê a ob lec mɨ lax vô a Mag dɨ xam Mam, dɨ a ob lax vô a Anutu dɨ xam Anutu.” ");
INSERT INTO ptp_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Mêgem Malia Makdala lax nêl vô Yesu nue ngɨvihi ên nêbê, “A xê Apumtau,” dɨ nêl kɨyang wê Yesu nêl vô i ge kɨtong vô he. ");
INSERT INTO ptp_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Da bucên ge Yesu nue ngɨvihi kɨtucma mɨ dô, lêc he xona ên Yuda om he tung xumac lec dɨ dô xumac lôma, mêd Yesu mɨla le vac he mahɨgun dɨ nêl vô he ên nêbê, “Xam nɨlôm i vô nivɨha.” ");
INSERT INTO ptp_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Yesu nêl kɨyang tige dɨ hɨlung vɨgê yuu byeac pɨyaha vô he om he xêyaa vô nivɨha ên wê he yê Apumtau ge. ");
INSERT INTO ptp_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Mêd Yesu nêl tii vac vô he ên nêbê, “Xam nɨlôm i vô nivɨha. Mag vông a lam om a ob vông xam êno loc.” ");
INSERT INTO ptp_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Yesu nêl kɨyang tige mêd vê myakɨlôhô lec he dɨ nêl vô he ên nêbê, “Xam kô Myakɨlôhô Ngɨbua. ");
INSERT INTO ptp_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Xam obêc kɨtya xomxo nên nipaên vêl ge od ob la vêl, lêc xam obêc hôm xomxo nên nipaên xôn ge od ob yêp vô he.” ");
INSERT INTO ptp_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Buc wê Yesu mɨla hɨlung i vô nue ngɨvihi ge, nue ngɨvihi ti lê nêbê Tomas wê ta kô yuu li ngwe ked ge o dô hɨxôn he lêm. ");
INSERT INTO ptp_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Om lie ngɨvihi ya nêl vô i ên nêbê, “Xe xê Apumtau.” Lêc Tomas nêl vô he ên nêbê, “A obêc xê bɨlem myayen wê le vac vɨgê ge, dɨ vông vɨgêg la vac, dɨ vông vɨgêg la vac byeac lêm ge od a ob vông i vin lêm.” ");
INSERT INTO ptp_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Da ti la vêl dêc nue ngɨvihi kɨtucma mɨ dô vac xumac tii vac dɨ Tomas dô hɨxôn he. He dô dɨ tung xumac lec, lêc Yesu val le vac he mahɨgun dɨ nêl vô he ên nêbê, “Xam nɨlôm i vô nivɨha.” ");
INSERT INTO ptp_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Mêd nêl vô Tomas ên nêbê, “Tɨtô vɨgêm i lam dɨ wê a vɨgêg ga, dɨ vông vɨgêm i lam vac a byeac. Ông nɨlôm i o vông yuu lêm. Nge, ông vông i vin.” ");
INSERT INTO ptp_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Mêd Tomas nêl vô i ên nêbê, “Ông ge a Apumtau, dɨ ông a Anutu.” ");
INSERT INTO ptp_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Mêd Yesu nêl vô i ên nêbê, “Ông wê a om ông vông i vin mê. Lêc xomxo wê o yê a lêm lêc he vông i vin ge, he ob dô hɨxôn xêyaa nivɨha.” ");
INSERT INTO ptp_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Yesu vông do levac tɨbeac hɨxôn mɨ nue ngɨvihi yê, lêc a o kɨvuu vɨhati vac kɨpihac tiga lêm. ");
INSERT INTO ptp_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Lêc kɨyang wê a kɨvuu vac kɨpihac ga, a kɨvuu ên a nêb xam vông i vin bê Yesu ge Kɨlisi ti wê Anutu vông i lam ge dɨ i Anutu nu, ên xam obêc vông i vin ge od xam ob dô mamvɨha ên wê xam vông i vin Yesu ge. ");
INSERT INTO ptp_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Yesu dô dɨ buc mahɨgun ti lêc hɨlung i vô nue ngɨvihi tii vac gê mia luaên Taibilias, om kɨyang yêp bêga nêbê ");
INSERT INTO ptp_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Saimon Pita dêc Tomas wê ta kô yuu li ngwe ked ge, dɨ Nataniel wê ben Kena vac vɨgwe levac Galili ge, dɨ Sebedi nu yuu, dɨ nue ngɨvihi yuu hɨxôn, he xôn dô. ");
INSERT INTO ptp_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Mêd Saimon Pita nêl vô he ên nêbê, “A ob la hi pis.” Lêc he nêl vô i ên nêbê, “Il xôn ob la.” Om he la lec dipac dɨ la tung leac vac mia vô bucên dia tige, lêc he o hi pis ti lêm. ");
INSERT INTO ptp_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Mêd vɨgwe vɨdiiên Yesu le vô mia nɨnya lêc nue ngɨvihi o xovô bê ge Yesu lêm. ");
INSERT INTO ptp_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Mêd Yesu kɨnêg vô he ên nêbê, “Xam nuge, xam kô pis ya?” Lêc he nêl vô i ên nêbê, “Ma vêl, xe o kô pis ti lêm.” ");
INSERT INTO ptp_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Mêd Yesu nêl vô he ên nêbê, “Xam nêx leac i loc vac mia vô dipac vɨlu wê vɨgêm hɨyôv ge od xam ob tulec pis.” Om he nêx leac la vac mia dɨ pis tɨbeac hɨwocên vac leac, om o tɨyi wê he ob pul leac i lôm ge lêm. ");
INSERT INTO ptp_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Mêd nu ngɨvihi ti wê Yesu xêyaa vin lec i ge nêl vô Pita ên nêbê, “GeApumtau.” Pita kwax siot vêl dɨ vông yuac mɨ dô, lêc ngô vya wê nêbê ge Apumtau, om vɨnyum ngakwi lec dɨ sox la vac mia dɨ la vô Yesu. ");
INSERT INTO ptp_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Dɨ nue ngɨvihi gên dô lec dipac om dipac dɨdii leac hɨxôn pis dɨ he lam. He lam dia tya tɨyi 90 mita dɨ mɨla vô mia nɨnya. ");
INSERT INTO ptp_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","He lop vêl ên dipac, lêc yê wê ngwax dɨtum dɨ pis yêp lec dɨ blet dô hɨxôn. ");
INSERT INTO ptp_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Mêd Yesu nêl vô he ên nêbê, “Pis wê xam hi gwêbaga, xam kô ya mɨ lam.” ");
INSERT INTO ptp_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Om Saimon Pita lec lax lec dipac nang dɨ he dɨdii leac lam mia nɨnya. Pis tigee tɨbeac hɨwocên tɨyi 153, lêc leac o tip lêm. ");
INSERT INTO ptp_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Mêd Yesu nêl vô he ên nêbê, “Xam lam wa yaên.” Nue ngɨvihi xona om he ti o kɨnêg Yesu bê i ge letya, lêc he xovô nêbê ge Apumtau. ");
INSERT INTO ptp_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Mêd Yesu la hôm blet dɨ vông vô he, dêc vông pis hɨxôn vô he. ");
INSERT INTO ptp_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Yesu kɨdi lec vac yibên dɨ hɨlung i vô nue ngɨvihi lu tige wê vông yon ge. ");
INSERT INTO ptp_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","He ya pyap mêd Yesu kɨnêg vô Saimon Pita ên nêbê, “Saimon, Jon nu, ông xêmyaa vin lec a luu he baba vêl, me?” Mêd Pita nêl vô i ên nêbê, “Apumtau, ông xovô ên ông nêbê a xêgyaa vin lec ông.” Om Yesu nêl vô Pita ên nêbê, “Ông viac sipsip nue wê a vông ge.” ");
INSERT INTO ptp_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Mêd Yesu kɨnêg vô i lu ngwe hɨxôn ên nêbê, “Saimon, Jon nu, ông xêmyaa vin lec a, me?” Mêd Pita nêl vô i ên nêbê, “Apumtau, ông xovô ên ông nêbê a xêgyaa vin lec ông.” Om Yesu nêl vô i ên nêbê, “Ông viac sipsip wê a vông ge.” ");
INSERT INTO ptp_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Nang dêc Yesu kɨnêg vô Pita lu ti wê vông yon ge ên nêbê, “Saimon, Jon nu, ông xêmyaa vin lec a, me?” Pita nɨlô vô vɨyin ên wê Yesu kɨnêg i lu yon ên nêbê, “Ông xêmyaa vin lec a, me?” Om nêl vô Yesu ên nêbê, “Apumtau, ông xovô kɨyang vɨhati dɨ ông xovô ên ông nêbê a xêgyaa vin lec ông.” Om Yesu nêl vô i ên nêbê, “Ông viac sipsip wê a vông ge. ");
INSERT INTO ptp_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","“A nêl hɨxôn nôn vô ông bê buc wê ông gên ngɨvihi ge, ôcông va vêx ông let dɨ la vɨgwe wê ông nêb ông ob la ge, lêc obêc tɨmuên wê ông ob vô kɨpwoc ge od ông ob tɨtô vɨgêm la kɨsii dɨ xomxo ngwe ob vêx let lec ông dɨ kô ông mɨ la vac vɨgwe wê ông nêb ông la vacên obêc ma ge.” ");
INSERT INTO ptp_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Yesu nêl kɨyang tige ên nêb ob nêl Pita nên môp wê ob yib dɨ vông Anutu lê i vô levac ge kɨtong. Nêl kɨyang tige pyap dêc nêl vô Pita ên nêbê, “Lam tɨmu vô a vɨxag.” ");
INSERT INTO ptp_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Pita pɨlepac i dɨ yê wê li ngɨvihi ngwe wê Yesu xêyaa vin lec i luu vêl ge tɨmu vô yuu vɨxa mɨ val. Li ngɨvihi tige wê ilage he xôn dô mɨ ya, lêc du mɨ la vô Yesu dɨ kɨnêg nêbê, “Apumtau, letya ob vông ông vac tɨbii vevac vɨgê?” ");
INSERT INTO ptp_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Pita yê li ngɨvihi tige om kɨnêg vô Yesu ên nêbê, “Apumtau, xomxo tige ob dô bêna?” ");
INSERT INTO ptp_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Lêc Yesu nêl vô Pita ên nêbê, “A obêc nêb xomxo tige i dô mavɨha dɨ a vena lê ge od ge yêp vô a. Om ông lam tɨmu vô a vɨxag.” ");
INSERT INTO ptp_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Mêd kɨyang la vô Yesu nue vɨhati bêga nêbê nu ngɨvihi tige ob yib lêm. Lêc kɨyang wê nêl nêbê ob yib lêm ge, Yesu o nêl bêge lêm. Nge, nêl ên nêbê, “A obêc nêb i dô mavɨha dɨ a vena lê ge od ge yêp vô a.” ");
INSERT INTO ptp_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","A, Jon, wê a nêl kɨyang tige vɨhati kehe kɨtong dɨ kɨvuu vac kɨpihac ga, dɨ xe xovô ên xe nêbê kɨyang wê a nêl dɨ kɨvuu ge nôn. ");
INSERT INTO ptp_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Yesu vông môp tɨbeac hɨxôn om a xo ên a nêbê xomxo obêc kɨvuu toto ge vɨhati vac kɨpihac ge od kɨpihac tigee obêc tɨbeac hɨwocên hɨvun vɨgwe kɨbun ga ma vêl. ");
INSERT INTO ptp_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Tiopilas, kɨpihac wê a Luk, a kɨvuu tax ge, a kɨvuu lec kɨyang yuu do vɨhati wê Yesu vông taxlee ge ");
INSERT INTO ptp_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","dɨ i val vô buc wê Yesu lec mɨ lax lag puunê ge. Buc tige Myakɨlôhô Ngɨbua ngɨdu Yesu xôn dɨ i vông yuac vô nue ngɨvihi wê vɨnoo he taxlee ge. Pyap dêc Anutu kô i dɨ i lax lag puunê. ");
INSERT INTO ptp_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Dɨ buc wê Yesu kô myavɨnê mɨ yib ge, od hɨlung i vô nue ngɨvihi ên nêb he i xovô bê kɨdi lec vac yibên. Dô hɨxôn he tɨyi buc kehe yuu (40) dɨ nêl Anutu ben kehe kɨtong vô he. ");
INSERT INTO ptp_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Yesu dô hɨxôn he dɨ nêl vô he ên nêbê, “Xam o lêc sea Jelusalem lêm, dɨ xam dô bin kɨyang wê a nêl vô xam ilage ên a nêb Mag Anutu obêc vông i lam vô xam. ");
INSERT INTO ptp_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Ilage Jon lipac xomxo ya mia, lêc gwêbaga buc vô kwabo lec wê Anutu ob lipac xam ya Myakɨlôhô Ngɨbua.” ");
INSERT INTO ptp_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Buc wê Yesu he nue ngɨvihi kɨtucma mɨ dô ge od he kɨnêg Yesu ên nêbê, “Apumtau, gwêbaga ông ob vông xecxe Islel tu levac dɨ viac xecxe va xocbê ilage, me?” ");
INSERT INTO ptp_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Lêc Yesu nêl vô he ên nêbê, “Buc tige o yêp vô xam bê xam ob xovô lêm. Buc tige Mag vaci xovô. ");
INSERT INTO ptp_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Lêc Myakɨlôhô Ngɨbua obêc lam dô vac xam nɨlôm dɨ vông xêkɨzêc vô xam, dɨ xam ob nêl a kɨtong gê Jelusalem tax dɨ i loc vac vɨgwe Judia vɨhati dɨ i loc vɨgwe Samelia dɨ i loc tɨyi vɨgwe vɨhati.” ");
INSERT INTO ptp_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Yesu nêl kɨyang tige pyap lêc nue ngɨvihi yê wê Yesu lec mɨ la kɨsii dɨ la vac vɨyobtoc nɨlô dɨ he o yê i tii vac lêm. ");
INSERT INTO ptp_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Nue ngɨvihi manôn vii lec Yesu wê lec mɨ la kɨsii ge dɨ yê xôn, dɨ lutibed xomxo yuu val le hɨxôn he. Yuu vɨnyum ngakwi kwem, ");
INSERT INTO ptp_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","dɨ yuu nêl vô he ên nêbê, “Xam xomxo Galili, xam wê mamnôn la kɨsii ên va? Yesu ti wê Anutu vông i lax mɨ la lag puunê ge obêc vena tɨyi xocbê xam wê i dɨ i lec mɨ lax kɨsii ganê ge.” ");
INSERT INTO ptp_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Yesu nue ngɨvihi sea kɨtôn Oliv dɨ lax mɨ la Jelusalem wê yêp kwabo vô kɨtôn Oliv tɨyi xocbê 1 kilomita ge. ");
INSERT INTO ptp_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","He la Jelusalem dɨ mɨla vô xumac ti wê buhu yuu ge, lêc he la dô vac ngwe kɨsii wê he mi dô vac ge. Xomxo tigee lê bêga nêbê Pita yuu Jon dɨ Jems yuu Andlu dɨ Pilip yuu Tomas dɨ Batolomyu yuu Matyu dɨ Alpias nu Jems dɨ Saimon Selot dɨ Jems nu Judas. ");
INSERT INTO ptp_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Yesu nue ngɨvihi tigee hɨxôn vêx ya dɨ Malia wê Yesu ta ge dɨ Yesu lie vux, he vɨhati mi kɨtucma dɨ kɨtaa vô Anutu. ");
INSERT INTO ptp_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Dɨ buc ti xomxo wê vông i vin Yesu ge tɨyi xocbê 120, he kɨtucma mɨ dô, lêc Pita kɨdi mɨ le vac he mahɨgun, ");
INSERT INTO ptp_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","dɨ nêl vô he ên nêbê, “Xam lige, ilage Myakɨlôhô Ngɨbua vông Devit kɨvuu kɨyang lec Judas wê dɨdii xomxo mɨ la vô Yesu dɨ he hôm i xôn ge. Om kɨyang tige vô nôn lec. ");
INSERT INTO ptp_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Judas ge wê mi dô hɨxôn xe dɨ xe xôn kô Yesu yuac tɨyima.” Pita nêl bêge vô he. ");
INSERT INTO ptp_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Judas ge kô mone lec nipaên wê nêl Yesu kɨtong ge, dɨ la kɨsuu kɨbun lec pyap, dêc mwoc dɨ hi xêyaa toc mɨ i kɨpyax sea. ");
INSERT INTO ptp_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Mêd xomxo Jelusalem vɨhati ngô wê Judas yib ge om nêl vɨgwe tige lê vac he vya nêbê Akeldama. Kehe bêga nêbê kɨbun wê hi kɨpyax lec ge. ");
INSERT INTO ptp_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Pita nêl vô he nang ên nêbê, “Kɨyang ti yêp vac kɨpihac Sam bêga ên nêbê, ‘I nên xumac ob dô pɨleva dɨ xomxo ti ob dô vac lêm.’ Dɨ kɨyang ngwe yêp vac Sam bêga ên nêbê, ‘Xomxo ngwe ob vông yuac wê i lê lec ge.’ ");
INSERT INTO ptp_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","Xolac nêl bêge, om il ob vɨnoo xomxo ti ên i le vac Judas nipɨlêhê, ên xe xôn la nêl kɨyang kɨtong vô xomxo bê Apumtau Yesu kɨdi lec vac yibên. Il ob vɨnoo xomxo ti vac he wê mi dô hɨxôn il tɨyi buc vɨhati wê Apumtau Yesu dô hɨxôn il ge, vô buc wê Jon lipac xomxo dɨ i lam tyip lec buc wê Anutu kô Yesu mɨ i lec mɨ lax lag puunê ge.” ");
INSERT INTO ptp_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Pita nêl bêge om he yê xomxo yuu, Josep (lê ngwe nêbê Basabas dɨ lê ngwe nêbê Jastas) yuu Mataias. ");
INSERT INTO ptp_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Dɨ he kɨtaa vô Apumtau bêga nêbê, “Apumtau, ông xovô xomxo vɨhati nɨlô om ông nêl vô xe bê ông vɨnoo xomxo yuu ga ngwe na ");
INSERT INTO ptp_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","wê ob le vac Judas nipɨlêhê dɨ vông yuac sinale hɨxôn xe ge, ên Judas sea yuac tige dɨ yib mɨ la vac ici va ben.” ");
INSERT INTO ptp_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Om he kɨvuu yuu lê lec ngɨdax yuu dɨ hɨlog lêc Mataias vôngo lam tô tax om he vông i la dô hɨxôn nue ngɨvihi vɨgê yuu dɨ tô mɨ la ti (11). ");
INSERT INTO ptp_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Lec buc Pentikos xomxo wê vông i vin Yesu gee he vɨhati kɨtucma vac xumac ti mɨ dô, ");
INSERT INTO ptp_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","lêc lutibed he ngô nidɨdun ti xocbê vɨgwe vɨyiiên ge lam gê kɨsii, dɨ nidɨdun tige lam hɨvun xomxo wê dô vac xumac gee ma vêl. ");
INSERT INTO ptp_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Mêd he yê xocbê ngwax mahelac ge lam dô lec xomxo toto bazub. ");
INSERT INTO ptp_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Dɨ Myakɨlôhô Ngɨbua lam la vac he vɨhati nɨlô dɨ he keac xomxo toto vya tɨyi xocbê Myakɨlôhô Ngɨbua vông vô he ge. ");
INSERT INTO ptp_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","He Yuda wê mi kɨtaa vô Anutu gee he tɨbeac dô vɨgwe Jelusalem. He lam vac vɨgwe vɨhati dɨ kɨtucma mɨ la Jelusalem. ");
INSERT INTO ptp_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","He ngô nidɨdun om he tɨbeac la yê, lêc ngô wê xomxo tigee keac he toto vya ge om he yetac. ");
INSERT INTO ptp_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","He yetac mabu dɨ nêl ên nêbê, “Xomxo wê dɨkeac ge, he vɨhati lam gê Galili, ");
INSERT INTO ptp_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","bêna lêc il ngô he keac vac il toto vyadê? ");
INSERT INTO ptp_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Ên il mangwe lam gê Patia dɨ Midia dɨ Ilam dɨ lam gê Mesopotemia yuu Judia dɨ Kapadosia dɨ Pontas dɨ Esia ");
INSERT INTO ptp_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","dɨ lam gê Plisia yuu Pampilia dɨ Isip dɨ vɨgwe Libia vɨwen wê yêp kwabo vô Sailini dɨ il mangwe lam gê Lom, ");
INSERT INTO ptp_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","dɨ il mangwe xomxo Yuda dɨ il ya tɨbii baba wê il tɨmu vô Yuda môp ge, dɨ il mangwe lam gê Klit yuu Alebia, lêc il vɨhati ngô he keac il toto vyad dɨ he nêl kɨyang lec do levac wê Anutu vông ge vô il.” ");
INSERT INTO ptp_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","He yetac dɨ vông he nɨlô juda dɨ he ya nêl vôma ên nêbê, “Susu tiga kehe tibêna?” ");
INSERT INTO ptp_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Lêc xomxo ya so vya vô he vông vinên dɨ nêl ên nêbê, “Ge he num wain levac om vông he vô mavmav.” ");
INSERT INTO ptp_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Pita kɨdi lec mɨ le hɨxôn Yesu nue ngɨvihi vɨgê yuu dɨ tô mɨ la ti dɨ keac vya levac vô xomxo tigee ên nêbê, “Xam lige Yuda hɨxôn xam vɨhati wê xam lam dô Jelusalem gee, a ob nêl susu tiga kehe kɨtong vô xam mɨ xam ngô lê. ");
INSERT INTO ptp_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Xam nêl ên xam nêbê xomxo tigae wain vông he vô mavmav, lêc o bêge lêm. Ên ga gên pɨtoc, 9 klok. ");
INSERT INTO ptp_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Susu tiga wê plopet Joel nêl lec ilage bêga nêbê, ");
INSERT INTO ptp_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Anutu nêl ên nêbê, “Obêc buc tɨmuên lêc a obêc vông Myakɨlôhô Ngɨbua wê a vông ge i loc hɨvun xomxo vɨhati xôn, dɨ nume vêx yuu vux obêc nêl kɨyang seac tɨyi xocbê plopete ge, dɨ a obêc hɨlung kɨyang kehe vɨhati vô nume ngɨvihi, dɨ mame kɨpwoc ob yê vɨvia lec kɨyang kehe. ");
INSERT INTO ptp_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Obêc vô buc tige a ob vông Myakɨlôhô Ngɨbua i loc vô a nuge yuac vêx yuu vux vɨhati dɨ he ob nêl kɨyang tɨyi xocbê plopete ge. ");
INSERT INTO ptp_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Dɨ a ob vông do levac gê kɨsii ganê, dɨ gê kɨbun ga hɨxôn, om hi yuu ngwax dɨ ngwaxlu levac obêc val, ");
INSERT INTO ptp_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","dɨ hɨyôv ob vô mapɨtoc vac dɨ dentuc ob vô ma hi. Dɨ buc levac wê Apumtau vông ge ob val tɨmuên hɨxôn xêseac levac. ");
INSERT INTO ptp_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Dɨ xomxo vɨhati wê ob kɨyag vya lec Apumtau ge, Apumtau obêc hôm he lec.” ’ ");
INSERT INTO ptp_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“Plopet Joel nêl Anutu kɨyang bêge, mêgem xam lige Islel, xam ngô kɨyang wê a ob nêl vô xam bêga bê Yesu Nasalet ge Anutu vông i lam vông do levac yuu yuac nivɨha ya xêkɨzêc wê Anutu vông ge, dɨ xam wê dɨ xovô pyap ên xam nêbê Anutu vông i lam. ");
INSERT INTO ptp_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Ilage Anutu xovô dɨ hɨlu kɨyang pyap nêb ob vông Yesu i lam vac xam vɨgêm dɨ xam vông i vac tɨbii nipaên vɨgê mɨ he hi i yib lec xax pola. ");
INSERT INTO ptp_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Lêc Anutu vô i vêl ên myavɨnê wê yibên ge dɨ tɨpi vô i kɨdi lec vac yibên, ên yibên o tɨyi wê ob hôm i xôn ge lêm. ");
INSERT INTO ptp_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Tɨyi xocbê kɨyang wê Devit nêl lec Yesu ilage bêga ên nêbê, ‘A xê Apumtau le vô a magnôn tɨyi buc vɨhati dɨ i le vô a vɨgêg hɨyôv, om susu ti o tɨyi wê obêc pwoo a pec ge lêm. ");
INSERT INTO ptp_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Om vông a xêgyaa vô nivɨha dɨ a pɨmil Anutu vac myag, dɨ a nignɨvi ob dô bin kɨyang nivɨha. ");
INSERT INTO ptp_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Ên ông ob sea a kɨnug i loc dô vac vɨgwe yibên lêm, dɨ ông ob sea num ngɨbua a nignɨvi i loc pɨtal lêm. ");
INSERT INTO ptp_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Ông hɨlung môp wê a ob dô magvɨha ge vô a, dɨ ông dô hɨxôn a tɨyi buc vɨhati om vông a nɨlôg vô nivɨha.’ ");
INSERT INTO ptp_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“Devit nêl kɨyang bêge mêgem xam lige, a ob nêl il bug Devit kɨtong vô xam bêga bê Devit o kɨvuu kɨyang tige lec ici va lêm, ên ilage Devit yib mɨ he yev i vac lôva, dɨ lôva wê i vông ge le vac il mahɨgun gwêbaga. ");
INSERT INTO ptp_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Lêc Devit ge plopet ti, om xovô kɨyang wê Anutu hɨlu pyap vô i ên nêb obêc vông Devit bue tɨmuên ti i tu king levac tɨyi xocbê Devit ge. ");
INSERT INTO ptp_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Devit xovô môp wê Anutu nêb ob vông tɨmuên ge om kɨvuu kɨyang lec wê Kɨlisi ob kɨdi lec vac yibên ge bêga ên nêbê, ‘Anutu ob sea i la dô vac vɨgwe yibên mɨ i ninɨvi i pɨtal lêm.’ ");
INSERT INTO ptp_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Yesu ge Anutu tɨpi vô i kɨdi lec vac yibên mɨ xe vɨhati xê dɨ xe nêl i kɨtong. ");
INSERT INTO ptp_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Yesu lec mɨ lax lag puunê dɨ la dô vô Anutu vɨgê hɨyôv, dɨ vông Myakɨlôhô Ngɨbua wê Ma nêl nêb ob vông ge lam vô xe om xam wê dɨ ngô gwêbaga. ");
INSERT INTO ptp_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Devit o la lag puunê tɨyi xocbê Yesu la ge lêm. Lêc Devit nêl kɨyang lec Yesu bêga ên nêbê, ‘Apumtau Anutu nêl vô a Apumtau bêga ên nêbê, “Ông dô vô a vɨgêg hɨyôv, ");
INSERT INTO ptp_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","dɨ obêc tɨmuên a obêc vông tɨbii wê vông vevac vô ông ge he i dô vac ông vɨgêm vɨlu kwa ngɨbi.” ’ ");
INSERT INTO ptp_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Mêgem xam Islel vɨhati, xam xovô bêga bê Yesu wê xam hi lec xax pola mɨ i yib ge Anutu vông i tu Apumtau dɨ i tu Kɨlisi.” Pita nêl kɨyang tige. ");
INSERT INTO ptp_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Xomxo tigee ngô kɨyang wê Pita nêl ge, lêc kɨyang tige vông he nɨlô hɨbu sea om he kɨnêg vô Pita he lie ên nêbê, “Xam lige, xe ob vông bêna?” ");
INSERT INTO ptp_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Om Pita nêl vô he ên nêbê, “Xam vɨhati pɨlepac nɨlôm i vô paha lec dɨ lipac mia lec Yesu Kɨlisi lê, ên i kɨtya xam nêm nipaên vêl. Dɨ Anutu obêc vông Myakɨlôhô Ngɨbua i lam vô xam. ");
INSERT INTO ptp_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Ên Anutu hɨlu kɨyang pyap ilage nêb ob vông Myakɨlôhô Ngɨbua vô xam hɨxôn xam nume dɨ xomxo wê dô teva ge hɨxôn, om ob vông vô he vɨhati wê il Apumtau Anutu tyuc he nêb he i lam vô i ge.” ");
INSERT INTO ptp_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Mêd Pita nêl kɨyang tɨbeac ya vô he dɨ nêl xêkɨzêc vô he ên nêbê, “Xam viac xam nivɨha ên xam o lêc vông xam vô nipaên hɨxôn xomxo nipaên wê dô gwêbaga lêm.” ");
INSERT INTO ptp_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Mêgem he wê vông i vin Pita kɨyang ge he lipac mia dɨ la dô hɨxôn xomxo vông vinên. He wê lipac mia lec buc tige, he tɨyi xocbê 3,000. ");
INSERT INTO ptp_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Tɨyi buc vɨhati xomxo vông vinên ngô Yesu nue ngɨvihi xolac dɨ viac nivɨha, dɨ he ngɨduma xôn dɨ ya mya yêp tibed dɨ le xêkɨzêc vac kɨtaaên. ");
INSERT INTO ptp_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Anutu vông Yesu nue ngɨvihi vông do tɨbeac om xomxo vɨhati yê dɨ xona. ");
INSERT INTO ptp_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Mêd xomxo vông vinên vɨhati dô hɨxônma dɨ susu wê he toto vông ge, he yê tɨyi xocbê he vɨhati xe. ");
INSERT INTO ptp_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Om susu hɨxôn kɨbun wê he vông ge, he vông mɨ tɨbii kɨsuu, dɨ he kô mone mɨ lax tɨtang vô lie vông vinên wê nên susu maên gee. ");
INSERT INTO ptp_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","He nɨlô tibed dɨ he kɨtuc la vac Anutu xumac ngɨbua tɨyi lec buc vɨhati, dɨ he la ya hɨxôn lie vac xumac toto hɨxôn xêyaa nivɨha. ");
INSERT INTO ptp_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","He pɨmil Anutu tɨyi buc vɨhati dɨ xomxo vɨhati xêyaa vin lec he dɨ yê he nivɨha. Mêd tɨyi buc vɨhati Apumtau vô xomxo ya vêl ên he nên nipaên dɨ vông he la dô hɨxôn i nue vông vinên. ");
INSERT INTO ptp_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Buc ti Pita yuu Jon la, nêb ob la kɨtaa vac Anutu xumac ngɨbua vô hɨyôv manôn 3 klok, wê he la mi kɨtaa lec ge. ");
INSERT INTO ptp_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Lêc yuu mɨla vô xomxo ti wê ta kô i hɨxôn vɨxa nipaên ge. Xomxo tyo, lie mi ken i mɨ la tɨyi lec buc vɨhati mɨ la tung i vô xumac ngɨbua vuayen ti wê he nêl lê nêbê vuayen nivɨha, ên xomxo tige mi kɨtaa nên mone vô xomxo wê la vac xumac ngɨbua ge. ");
INSERT INTO ptp_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Xomxo tyo yê wê Pita yuu Jon mɨla ge om kɨtaa yuu ên nêb yuu i vông mone vô i. ");
INSERT INTO ptp_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Mêd yuu yê xomxo tyo kɨzêc dɨ Pita nêl vô i ên nêbê, “Wê mam lam xii lê.” ");
INSERT INTO ptp_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Om tyo lax ma lec yuu, ên nêb mêd yuu ob vông susu ti vô i. ");
INSERT INTO ptp_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Lêc Pita nêl vô xomxo tyo ên nêbê, “A o kô mone ti lêm. Lêc susu wê dô vô a ge, a ob vông vô ông. Lec Yesu Kɨlisi Nasalet lê, a nêl vô ông bê ông kɨdi lec mɨ loc.” ");
INSERT INTO ptp_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Mêd Pita hôm lec xomxo tyo vɨgê hɨyôv dɨ vông i kɨdi lec, dɨ lutibed vɨxa kɨtu yuu vɨxa pɨtehe vôxêkɨzêc lec ");
INSERT INTO ptp_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","dɨ i sox mɨ la le dɨ vɨlee la, mêd la vac xumac ngɨbua hɨxôn yuu dɨ la vô sox sox dɨ pɨmil Anutu. ");
INSERT INTO ptp_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Mêd xomxo vɨhati yê wê xomxo tyo vɨlee mɨ la dɨ lôm dɨ pɨmil Anutu ge, ");
INSERT INTO ptp_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","dɨ he xovô ên nêbê ge xomxo ti wê mi dô vô xumac ngɨbua vuayen lê nêbê vuayen nivɨha ge dɨ mi kɨtaa susu vô xomxo ge om he yetac mabu dɨ nga vɨgê ên wê tyo vô nivɨha lec ge. ");
INSERT INTO ptp_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Xomxo tyo vii lec Pita yuu Jon mêd xomxo vɨhati yetac dɨ tup mɨ la vô yon lec xumac pêt myahɨpu nɨlô ti wê he nêl Solomon lê lec ilage. ");
INSERT INTO ptp_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Lêc Pita yê wê he kɨtuc lam ge om nêl vô he ên nêbê, “Xam lige Islel, xam yetac ên va? Bêna lêc xam wê xii kɨzêcê? Mêd xam so ên xam nêbê xomxo tige vô nivɨha lec ya xêkɨzêc yuu nivɨha wê xii vông ge, me? ");
INSERT INTO ptp_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Anutu ti wê Eblaham yuu Aisak dɨ Jekop dɨ il buge he Anutu, ge wê vông i nu yuac Yesu lê vô levac. Lêc xomxo tyo ti wê xam vông i la vac Pailat vɨgê dɨ Pailat nêb ob pɨwelac i vêl, lêc xam yax i vun vô Pailat manôn. ");
INSERT INTO ptp_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Yesu ge xomxo nivɨha dɨ i xomxo ngɨbua, lêc xam yax i vun dɨ kɨtaa Pailat ên xam nêb i pɨwelac tɨbii nipaên wê hi xomxo yib ge i lôm vô xam, ");
INSERT INTO ptp_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","dɨ xomxo ti wê mavɨha dôên kehe ge, xam hi i yib. Lêc Anutu tɨpi vô i kɨdi lec mavɨha vac yibên mɨ xe xê lec mamnôn. ");
INSERT INTO ptp_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Xomxo ti wê xam wê dɨ xovô i ge vông i vin Yesu, om Yesu lê ngɨdu xomxo tige xôn dɨ vông i vɨxa vô nivɨha lec. Vông vinên wê i vông ge vông i vô nivɨha lec mɨ xam vɨhati wê lec mamnôn. ");
INSERT INTO ptp_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Xam lige, a xovô ên a nêbê môp wê xam hɨxôn xam lime levac vông vô Yesu ge, xam lungên môp nivɨha om xam vông môp tibêge. ");
INSERT INTO ptp_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Ilage Anutu vông plopete vɨhati he nêl kɨtong ên nêbê Kɨlisi wê Anutu vông i lam ge ob kô myavɨnê, om môp wê xam vông ge vông kɨyang tyo vô nôn lec. ");
INSERT INTO ptp_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","“Mêgem xam pɨlepac xam nɨlôm i loc vô Anutu ên i kɨtya xam nêm nipaên vêl. ");
INSERT INTO ptp_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Xam obêc vông bêge ge od Apumtau obêc vông xam dô seac vêl dɨ xam ob kô xêkɨzêc, dɨ obêc vông Yesu Kɨlisi wê nêl lec xam pyap ge i lam vô xam. ");
INSERT INTO ptp_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Ên Yesu dô lag puunê om ob dô bin buc wê Anutu ob vông susu vɨhati i vô paha lec ge, tɨyi kɨyang wê Anutu nêl vac plopete ngɨbua mya ilage. ");
INSERT INTO ptp_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Moses nêl kɨyang bêga ên nêbê, ‘Apumtau Anutu obêc vông xam lime ti i tu plopet tɨyi xocbê a ge, om xam lêc vô nɨnyam lehe vô kɨyang vɨhati wê ob nêl vô xam ge. ");
INSERT INTO ptp_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Lêc xomxo vɨhati wê obêc vô nɨnya kɨtu vô plopete tyo vya ge, Anutu obêc kɨtya he vêl, dɨ he ob dô hɨxôn Anutu nue tii vac lêm.’ ");
INSERT INTO ptp_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Moses nêl kɨyang bêge, dɨ plopete ilage wê nêl Anutu kɨyang kɨtong ge, Samyuel hɨxôn plopet wê val tɨmuên ge, he vɨhati nêl kɨyang lec buc wê val gwêbaga mɨ il dô vac ge. ");
INSERT INTO ptp_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","“Xam ge plopete nue dɨ kɨyang wê Anutu hɨlu vô bume ilage ob lam vô xam hɨxôn, kɨyang ti wê Anutu nêl vô Eblaham ên nêbê, ‘A ob vông bume tɨmuên i tu xomxo kɨbun ga vɨhati nên vɨzid kehe.’ ");
INSERT INTO ptp_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Om Anutu vɨnoo i nu yuac mɨ vông i lam vô xam Yuda tax, ên nêb i vô nivɨha vô xam dɨ xam toto pɨlepac xam dɨ sea môp nipaên.” ");
INSERT INTO ptp_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Yuu gên nêl xolac vô xomxo tigee, lêc xomxo wê mi si daa vô Anutu gee hɨxôn xêhɨpu levac ti wê mi viac Anutu xumac ngɨbua ge dɨ xomxo Sadyusi mangwe val vô yuu, ");
INSERT INTO ptp_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","dɨ he xêyaa vô myavɨnê vô yuu ên wê yuu tɨxuu xomxo ya kɨyang bêga nêbê Yesu kɨdi lec vac yibên om xomxo yibên vɨhati obêc kɨdi lec mavɨha nang ge. ");
INSERT INTO ptp_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Om he kô yuu mɨ la tung vac xumac kalabuhu, nêb yuu i dô dɨ i vɨdii lê, ên ge vɨgwe huc. ");
INSERT INTO ptp_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Lêc xomxo wê ngô Pita kɨyang gee he tɨbeac vông i vin, om he vux wê vông i vin ge tɨyi xocbê 5,000. ");
INSERT INTO ptp_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Dɨ vɨgwe vɨdiiên he Yuda levac hɨxôn gyovɨxa dɨ he wê xovô Moses xolac kehe gee, he xôn kɨtucma gê Jelusalem. ");
INSERT INTO ptp_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","He kɨtucma hɨxôn xomxo levac wê mi si daa vô Anutu ge, Anas yuu Kaiapas dɨ Jon yuu Aleksanda hɨxôn lie ya. Anas ge wê tu he vɨhati bazub. ");
INSERT INTO ptp_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Om he kô Pita yuu Jon mɨ lam lax yuu le vô he manôn dɨ kɨnêg vô yuu ên nêbê, “Muu kô xêkɨzêc vô letya dɨ muu nêl letya lê, lêc muu vông xomxo tige vô nivɨha lecê?” ");
INSERT INTO ptp_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Mêd Myakɨlôhô Ngɨbua hɨvun Pita xôn om Pita nêl vô he ên nêbê, “Xam xomxo levac hɨxôn xam gyovɨxa, ");
INSERT INTO ptp_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","gwêbaga xam kɨnêg xii ên wê xii ngɨdu xomxo ti wê vɨxa vô nipaên ge xôn, ên xam nêb xam ob xovô bê xii vông i vô nivɨha lec tibêna? ");
INSERT INTO ptp_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Om xam vɨhati hɨxôn lime Islel vɨhati, xam xovô bêga bê xêkɨzêc wê Yesu Kɨlisi Nasalet vông ge wê vông xomxo tiga vô nivɨha lec mɨ i le vô xam mamnôn. Yesu ge, xam hi i yib lec xax pola, lêc Anutu tɨpi vô i kɨdi lec vac yibên. ");
INSERT INTO ptp_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Yesu ge ngɨdax ti wê xam xumac loxên wê ên xam nêbê nipaên ge, lêc i tu ngɨdax xêkɨzêc ti wê xumac ob le xêkɨzêc ya ge. ");
INSERT INTO ptp_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Ên xomxo ngwe o tɨyi wê ob hôm il lec ge lêm, ên Anutu o nêl xomxo kɨbun ga ti vô il ên nêb i kɨtya il nêd nipaên vêl lêm. Nge, Yesu tibed.” ");
INSERT INTO ptp_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Xomxo levac tigee, he yetac ên kɨyang wê Pita yuu Jon nêl ge, ên yuu ge xomxo vɨyangtôv yuu dɨ yuu o xulac xumac ti lêm, lêc yuu nêl kɨyang hɨxôn xêkɨzêc dɨ yuu o xona lêm. Om he xovô nêbê yuu ge wê mi dô hɨxôn Yesu ilage. ");
INSERT INTO ptp_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Dɨ he yê xomxo ti wê yuu vông i vô nivɨha lec ge le hɨxôn yuu, om he nên kɨyang ti o yêp wê ob nêl lax vô yuu ge lêm. ");
INSERT INTO ptp_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Om he nêl vô yuu nêb yuu i sea xumac kaunsil dɨ loc vɨxun. Yuu la vɨxun dɨ he nêl vôma ên nêbê, ");
INSERT INTO ptp_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","“Il ob vô vatya vô xomxo yuu ganê? Ên xomxo Jelusalem vɨhati xovô do levac wê yuu vông ge om o tɨyi wê il ob yax vun ge lêm. ");
INSERT INTO ptp_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Lêc il ob le vac kɨyang tige xôn, ên i o lêc vô levac mɨ loc vac xomxo vɨhati nɨnya lêm. Om il ob vông vɨbuên xêkɨzêc vô yuu bê yuu i o nêl kɨyang vô xomxo lec Yesu lê i tii vac lêm.” ");
INSERT INTO ptp_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Om he keac yuu lax vô he dɨ nêl kɨyang xêkɨzêc vô yuu ên nêbê, “Muu o lêc nêl kɨyang lec Yesu lê lêm, dɨ muu o lêc tɨxuu xomxo lec lê tige lêm.” ");
INSERT INTO ptp_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Lêc Pita yuu Jon nêl vô he ên nêbê, “Xam ngô lê. Xii obêc sea Anutu xolac dɨ vông i vin kɨyang wê xam nêl ge od mêd Anutu ob yê xii nivɨha? Xam xovô lê. ");
INSERT INTO ptp_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Xii o tɨyi wê xii ob dô kɨyang maên ge lêm. Nge, xii ob nêl kɨyang vɨhati wê xii ngô dɨ xê mamnôn lec ge kɨtong.” ");
INSERT INTO ptp_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Kaunsil tigee he nêl kɨyang xêkɨzêc vô yuu tii vac dɨ vông yuu la. He nêb he ob vông vɨyin vô yuu, lêc tɨyiên ma, ên xomxo vɨhati pɨmil Anutu ên nivɨha wê yuu vông ge. ");
INSERT INTO ptp_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Xomxo ti wê yuu vông i vô nivɨha lec ge, klismas wê i vông ge kehe yuu (40). ");
INSERT INTO ptp_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","He kaunsil vông Pita yuu Jon la, om yuu lax mɨ la vô lie vông vinên dɨ lax nêl kɨyang wê xomxo levac wê mi si daa vô Anutu gee hɨxôn he gyovɨxa nêl vô yuu ge kɨtong vô he. ");
INSERT INTO ptp_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","He ngô pyap dɨ he xôn nɨlô tibed dɨ he kɨtaa vô Anutu bêga nêbê, “O Apumtau, ông levac wê ôcông va tung lag yuu kɨbun dɨ gwec hɨxôn susu vɨhati yang. ");
INSERT INTO ptp_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Ilage Myakɨlôhô Ngɨbua wê ông vông ge vông xe bug Devit wê ông num yuac ge nêl ông kɨyang bêga nêbê, ‘Bêna lêc tɨbii madɨluhu xêyaa vô myavɨnê luu vêl? Bêna lêc he nêl kɨyang vaxvax wê nôn maên ge? ");
INSERT INTO ptp_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","King kɨbun ga vɨhati viac he ên vevac, dɨ xomxo levac kɨtucma ên nêb ob vông vevac vô Apumtau Anutu hɨxôn Kɨlisi wê i vông i lam ge.’ ");
INSERT INTO ptp_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Kɨyang tige vɨxôhɨlôg nôn, ên Helot yuu Pontias Pailat dɨ tɨbii wê o Yuda lêm gee hɨxôn xomxo Islel ya, he xôn kɨtucma vac vɨgwe ga ên nêb ob vông vɨyin vô Yesu, ông num yuac ngɨbua wê ông vɨnoo i ge. ");
INSERT INTO ptp_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","He kɨtucma ên nêb ob hi Yesu, tɨyi kɨyang wê ông nêl pyap ilage ya xêkɨzêc wê ông vông ge, ên ông nêb obêc vô nôn lec tɨmuên. ");
INSERT INTO ptp_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","O Apumtau, gwêbaga xe kɨtaa vô ông bê ông xovô kɨyang vɨyin wê he Yuda levac nêl ge dɨ ngɨdu xe xôn, ên ông nume yuac xe le xêkɨzêc dɨ nêl ông xolac i yêp seac dɨ xonaên i ma. ");
INSERT INTO ptp_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Dɨ ông vyax vɨgêm lec xomxo yidac ên he i vô nivɨha lec, dɨ ông vông do levac ya lec num yuac ngɨbua Yesu lê.” ");
INSERT INTO ptp_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","He kɨtaa pyap mêd xumac ti wê he dô vac ge yoc dɨ Myakɨlôhô Ngɨbua lam hɨvun he xôn dɨ he nêl Anutu xolac hɨxôn xêkɨzêc dɨ he o xona lêm. ");
INSERT INTO ptp_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Xomxo vông vinên vɨhati nɨlô tibed dɨ he xêyaa vin lecma, dɨ he ti o nêl ên nêbê susu wê i vông ge, ge ici xe lêm. Nge, susu wê he toto vông ge he yê tɨyi xocbê he vɨhati xe. ");
INSERT INTO ptp_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Mêd Yesu nue ngɨvihi nêl kɨyang hɨxôn xêkɨzêc nêbê Apumtau Yesu kɨdi lec vac yibên, dɨ xomxo vông vinên vɨhati, he dô vac xêyaa vin lecên nɨlô. ");
INSERT INTO ptp_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Dɨ he ti, susu o ma ên he lêm, ên xomxo vɨhati vông kɨbun hɨxôn xumac wê he vông ge mɨ tɨbii kɨsuu, dɨ he kô mone ");
INSERT INTO ptp_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","mɨ la vông vô Yesu nue ngɨvihi ên nêb he i tɨtang vô xomxo wê nên susu maên gee. ");
INSERT INTO ptp_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Xomxo ti dô lê nêbê Josep, lêc Yesu nue ngɨvihi nêl i lê ngwe nêbê Banabas. (Lê tige kehe bêga nêbê xomxo wê mi ngɨdu xomxo xôn ya kɨyang nivɨha ge.) Josep ge Livai ti dɨ i ben Saiplas, ");
INSERT INTO ptp_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","lêc Josep vông i kɨbun mya ti mɨ tɨbii kɨsuu dɨ i kô mone mɨ la vông vô Yesu nue ngɨvihi. ");
INSERT INTO ptp_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Xomxo ti lê nêbê Ananaias yuu vɨnê Sapaila, yuu vông kɨbun wê yuu vông ge ti mɨ tɨbii kɨsuu, ");
INSERT INTO ptp_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","lêc Ananaias vun mone vɨwen dɨ kô vɨwen mɨ la vông vô Yesu nue ngɨvihi, dɨ vɨnê xovô môp wê i vông ge. ");
INSERT INTO ptp_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Lêc Pita nêl vô i ên nêbê, “Ananaias, bêna lêc Seten dô vac ông nɨlôm dɨ vông ông vun mone wê ông kô lec kɨbun ge vɨwen dɨ ông kɨtyoo kɨyang vô Myakɨlôhô Ngɨbua? ");
INSERT INTO ptp_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Ilage wê tɨbii gên o kɨsuu kɨbun tige lêm ge, od kɨbun tige tu ôcông va xe. Dɨ buc wê tɨbii kɨsuu pyap ge od mone ge ôcông va xe. Bêna lêc ông xovô môp tibêge yêp vac nɨlômê? Ông o kɨtyoo xomxo lêm. Nge, ông kɨtyoo Anutu.” ");
INSERT INTO ptp_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Ananaias ngô kɨyang tige dɨ vɨxog mɨ la kɨbun dɨ la yib lutibed. Om xomxo wê ngô kɨyang tige vɨhati xona mabu. ");
INSERT INTO ptp_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Mêd xomxo ngɨvihi ya lam vɨyum i vac nivɨmihi dɨ kô mɨ la vɨxun mɨ la yev. ");
INSERT INTO ptp_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Hɨyôv manôn yon lam la vêl mêd Ananaias vɨnê val vô Pita, lêc lungên wê lɨya yib ge. ");
INSERT INTO ptp_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Om Pita kɨnêg vô i ên nêbê, “Mone wê muu kô lec kɨbun ge, muu vông i lam vɨhati, me?” Mêd Sapaila luu i vya ên nêbê, “Mone vɨhati ge, xii vông i loc.” ");
INSERT INTO ptp_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Om Pita nêl vô i ên nêbê, “Bêna lêc muu lɨyam nêb muu ob yaxên Apumtau Myakɨlôhô Ngɨbua? Wê lê. Xomxo wê yev lɨyam ge vena le vô vuayen om ob lam ken ông mɨ la êno bêge.” ");
INSERT INTO ptp_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Lutibed vêx tyo vɨxog mɨ la kɨbun mɨ la yêp vô Pita vɨxa dɨ yib, dɨ xomxo ngɨvihi wê yev lɨya ge lamyê wê yib ge om kô mɨ la yev i pɨkeb lɨya. ");
INSERT INTO ptp_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Om xomxo vông vinên hɨxôn xomxo wê ngô kɨyang tigee he vɨhati xona mabu. ");
INSERT INTO ptp_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Yesu nue ngɨvihi vông do levac tɨbeac vac xomxo mahɨgun, dɨ xomxo vông vinên dô kɨdu ti dɨ la mi kɨtucma vac Anutu xumac ngɨbua lec pêt myahɨpu nɨlô ti wê he nêl Solomon lê lec ilage. ");
INSERT INTO ptp_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Mêd xomxo baba xona dɨ o kɨtuc la hɨxôn he lêm, lêc xomxo tɨbeac pɨmil he dɨ yê he nivɨha, ");
INSERT INTO ptp_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","dɨ xomxo vêx yuu vux tɨbeac vông i vin Apumtau dɨ lam dô hɨxôn xomxo vông vinên. ");
INSERT INTO ptp_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Mêd xomxo mi ken lie wê yidac gee mɨ la lii vac môp dɨ he yêp lec pêt, ên he xo ên he nêbê Pita obêc val ge od hɨnyena wê i vông ge i lam lec he dɨ vông he i vô nivɨha lec. ");
INSERT INTO ptp_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Dɨ xomxo tɨbeac vac vɨgwe wê yêp kwabo vô Jelusalem ge, he kô xomxo wê yidac gee, hɨxôn xomxo wê vɨmwo nipaên dô vac he gee mɨ la vô Yesu nue ngɨvihi, dɨ he vɨhati vô nivɨha lec. ");
INSERT INTO ptp_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Mêd xomxo wê mi si daa vô Anutu gee, he nên xomxo levac hɨxôn he Sadyusi wê mi dô hɨxôn i gee he xêyaa vô nipaên vô Yesu nue ngɨvihi ên wê xomxo vɨhati pɨmil he ge, ");
INSERT INTO ptp_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","om he hôm Yesu nue ngɨvihi xôn dɨ tung he la vac xumac kalabuhu. ");
INSERT INTO ptp_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Om he dô dɨ vô bucên Apumtau vông angela ti lam tax xumac ên he dɨ kô he mɨ la vɨxun dɨ nêl vô he ên nêbê, ");
INSERT INTO ptp_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Xam lôc vac Anutu xumac ngɨbua dɨ loc nêl kɨyang mavɨha dôên kehe kɨtong i yêp seac vô xomxo vɨhati.” ");
INSERT INTO ptp_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Yesu nue ngɨvihi ngô angela vya dɨ kɨdi mɨ la pɨtoc yang dɨ la vac Anutu xumac ngɨbua dɨ nêl xolac vô xomxo. Mêd xomxo daa siên li levac tyo hɨxôn xomxo wê mi dô hɨxôn i gee, he keac kaunsil wê he Yuda vông ge hɨxôn Yuda levac vɨhati lam kɨtucma, dɨ he vông xomxo ya la xumac kalabuhu ên nêb he i loc kô Yesu nue ngɨvihi mɨ lam. ");
INSERT INTO ptp_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Om xêhɨpue la yê xumac kalabuhu nɨlô, lêc Yesu nue ngɨvihi o dô lêm. He xôa ma om he lax nêl vô he kaunsil ên nêbê, ");
INSERT INTO ptp_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Xe la xê xumac kalabuhu lêc xumac vuayen tung xôn vɨhati dɨ tɨbii viacên dɨle vô vuayen om xe tax vuayen mɨ xê xumac nɨlô lê, lêc xe o tulec xomxo ti xeedô lêm. Xumac nɨlô pɨleva.” ");
INSERT INTO ptp_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Mêd xêhɨpu levac ti wê mi viac Anutu xumac ngɨbua ge hɨxôn xomxo levac wê mi si daa vô Anutu gee, he ngô kɨyang tige dɨ nɨlô myag kɨyang tɨbeac dɨ he kɨnêg vôma ên nêbê, “Kɨyang tige obêc tibêna?” ");
INSERT INTO ptp_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Mêd xomxo ti mɨla vô he dɨ nêl ên nêbê, “Xam wê lê. Xomxo ti wê xam tung he la vac kalabuhu gee, he la le vac Anutu xumac ngɨbua dɨ nêl xolac vô xomxo.” ");
INSERT INTO ptp_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Om xêhɨpu levac tige hɨxôn xêhɨpu ya la kô Yesu nue ngɨvihi lêc hiên he ma, ên he xona ên he nêb xomxo obêc nêx he ya ngɨdax. ");
INSERT INTO ptp_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Mêd he kô Yesu nue ngɨvihi mɨ la lax he le vô kaunsil manôn, mêd xomxo daa siên nên levac nêl vô he ên nêbê, ");
INSERT INTO ptp_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Xe le vac xam xôn dɨ nêl xêkɨzêc vô xam ên xe nêbê xam o lêc nêl kɨyang lec Yesu lê lêm. Lêc xam o ngô kɨyang wê xe nêl ge lêm, dɨ xam nêl kɨyang tige vô levac vac vɨgwe Jelusalem vɨhati, dɨ xam nêb xam ob nêl kɨyang kɨtyooên lec xe bê xe hi Yesu yib.” ");
INSERT INTO ptp_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Lêc Pita hɨxôn lie luu he vya ên nêbê, “Xe ob tɨmu vô Anutu kɨyang, dɨ xe ob tɨmu vô kɨyang wê xomxo vông ge lêm. ");
INSERT INTO ptp_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Xam hi Yesu yib lec xax pola, lêc Anutu wê buge mi kɨtaa vô ge tɨpi vô i kɨdi lec, ");
INSERT INTO ptp_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","dɨ vông i la dô vô i vɨgê hɨyôv, dɨ i tu il nêd mugên wê ob hôm il lec ge, ên nêb il Islel pɨlepac il dɨ vông nɨlôd i loc vô Anutu ên i kɨtya il nêd nipaên vêl. ");
INSERT INTO ptp_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Kɨyang tige vɨhati, xe nêl kɨtong vô xomxo, dɨ Myakɨlôhô Ngɨbua nêl kɨyang tige hɨxôn. Myakɨlôhô Ngɨbua tige Anutu vông vô xomxo wê ngô i kɨyang dɨ tɨmu vô ge.” ");
INSERT INTO ptp_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","He kaunsil ngô Pita kɨyang tige dɨ he xêyaa vô myavɨnê mabu vô Yesu nue ngɨvihi om nêb ob hi he yib. ");
INSERT INTO ptp_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Lêc xomxo kaunsil ti lê nêbê Gameliel kɨdi lec ên nêb ob nêl kɨyang vô lie. Gameliel ge Palisi ti wê mi tɨxuu xomxo ya Moses xolac ge, om xomxo vɨhati pɨmil i dɨ vông i lê vô levac. Lêc Gameliel nêl ên nêb he i vông Yesu nue ngɨvihi i lop mɨ loc vɨxun vêl. ");
INSERT INTO ptp_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","He lop mɨ la vɨxun pyap dɨ Gameliel nêl vô he kaunsil ên nêbê, “Xam lige Islel, môp wê xam nêb xam ob vông vô xomxo tigee, xam vyac xovô nivɨha lê. ");
INSERT INTO ptp_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Xam xovô pyap wê ilage Tiudas yong i nêb i xomxo levac, dɨ xomxo tɨbeac tɨyi 400 tɨmu vô i vɨxa, lêc gavman hi i yib dɨ xomxo vɨhati wê tɨmu vô i gee pec sea dɨ yuac wê he vông ge tô mɨ la. ");
INSERT INTO ptp_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Nang dêc buc wê gavman kɨvuu xomxo lê ge, Judas gê Galili dɨdii xomxo tɨbeac la vô i, nêbê he ob vông vevac vô gavman, lêc gavman hi i yib dɨ xomxo wê tɨmu vô i vɨxa gee pec mɨ moo sea. ");
INSERT INTO ptp_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Om gwêbaga a ob nêl vô xam bê xam sea Yesu nue ngɨvihi tigee dɨ vông he i loc, ên yuac wê he vông ge, xomxo vaci obêc tu kehe ge od obêc vô nipaên. ");
INSERT INTO ptp_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Lêc Anutu obêc tu kehe ge od xam o tɨyi wê xam ob le vac xôn ge lêm, ên obêc tɨyi xocbê xam vông vevac vô Anutu.” ");
INSERT INTO ptp_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Mêd kaunsil tigee vɨhati lee yuu lec Gameliel kɨyang, om he keac Yesu nue ngɨvihi vena dɨ he nêl mɨ tɨbii hi he ya yihi, dɨ he nêl vya xêkɨzêc vô he ên nêb he i o lêc nêl kɨyang lec Yesu lê i tii vac lêm. Pyap dɨ vông he lop mɨ la. ");
INSERT INTO ptp_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Om Yesu nue ngɨvihi sea kaunsil dɨ lop mɨ la vɨxun hɨxôn xêyaa nivɨha, dɨ pɨmil Anutu ên wê Anutu xo nêbê he tɨyi wê ob kô vɨyin lec Yesu lê ge. ");
INSERT INTO ptp_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Mêd he la nêl Yesu Kɨlisi xolac vô xomxo vac Anutu xumac ngɨbua dɨ la nêl vac xomxo toto ben tɨyi buc vɨhati. ");
INSERT INTO ptp_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Vô buc tige xomxo tɨbeac vông i vin Yesu om xomxo vông vinên vô tɨbeac. Lêc he vɨlu wê keac vya Glik ge yê he wê keac vya Yuda ge nipaên ên nêbê, “Xam mi vông byed vô susu vô he wê nên susu maên gee tɨyi lec buc vɨhati, lêc xam o vông vô vêxôv wê xe vông ge hɨxôn lêm.” ");
INSERT INTO ptp_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Om Yesu nue ngɨvihi vɨgê yuu dɨ tô mɨ la yuu keac xomxo vông vinên vɨhati lam kɨtucma, dɨ nêl vô he ên nêbê, “Xe obêc sea yuac wê xe mi nêl Anutu xolac ge dɨ la vông byed vô susu yaên ge od tɨyiên ma. ");
INSERT INTO ptp_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Om xam lige, xam vɨnoo xomxo vɨgê vɨlu dɨ sec yuu vac xam mahɨgun, wê xam wê he nivɨha dɨ Myakɨlôhô Ngɨbua hɨvun he xôn dɨ he pɨyôp nivɨha ge, ên il ob vông yuac tige vac he vɨgê mɨ he i vông, ");
INSERT INTO ptp_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","ên xe wê Yesu nue ngɨvihi ge ob vông yuac lec kɨtaaên hɨxôn xolac nêlên.” ");
INSERT INTO ptp_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Mêd xomxo vông vinên vɨhati tyuc lec kɨyang wê he nêl ge, om he vɨnoo Stiven yuu Pilip dɨ Plokolas dɨ Naikena dɨ Taimon dɨ Pamenas dɨ Nikolas. Stiven ge xomxo ti wê vông i vin Yesu xêkɨzêc ge dɨ Myakɨlôhô Ngɨbua hɨvun i xôn, dɨ Nikolas ge tɨbii Antiok ti lêc mi tɨmu vô kɨyang wê he Yuda vông ge. ");
INSERT INTO ptp_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Om he lax xomxo tigee la vô Yesu nue ngɨvihi manôn mɨ he vyax vɨgê lec he dɨ kɨtaa lec. ");
INSERT INTO ptp_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Mêd Anutu xolac vô levac dɨ xomxo Jelusalem tɨbeac vông i vin Yesu dɨ xomxo wê mi si daa vô Anutu gee tɨbeac vông i vin hɨxôn. ");
INSERT INTO ptp_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Stiven ge, vɨzid yuu xêkɨzêc wê Anutu vông ge hɨvun i xôn, om mi vông do levac mɨ xomxo tɨbeac yê. ");
INSERT INTO ptp_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Lêc Yuda ya lam vô Stiven dɨ he ngaênma lec xolac. Xomxo tigee lam gê Sailini yuu Aleksandlia dɨ Silisia dɨ Esia lêc lam dô Jelusalem, dɨ he mi la vac Yuda xumac lɨlo ti wê nêl lê nêbê tɨbii pɨwelac he vêl. ");
INSERT INTO ptp_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Om he Stiven ngaênma lec xolac, lêc Myakɨlôhô Ngɨbua vông pɨyôp nivɨha vô Stiven om xomxo tigee tɨyiên ma wê ob kɨtya Stiven kɨyang vêl ge. ");
INSERT INTO ptp_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Mêd he vông xomxo ya la nêl kɨyang kɨtyooên lec Stiven bêga ên nêbê, “Xe ngô wê xomxo tige mi so vya vô Moses yuu Anutu.” ");
INSERT INTO ptp_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","He nêl bêge om he kɨyang la vông xomxo levac yuu xomxo wê xovô Moses xolac gee hɨxôn xomxo tɨbeac, he nɨlô vô nipaên vô Stiven, om he la hôm Stiven xôn dɨ kô i mɨ la vô he kaunsil. ");
INSERT INTO ptp_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Dɨ he vông xomxo ya la nêl kɨyang kɨtyooên lec Stiven bêga ên nêbê, “Xomxo tige mi nêl kɨyang nipaên lec Anutu xumac ngɨbua hɨxôn xolac wê Moses vông ge. ");
INSERT INTO ptp_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Xe ngô wê nêl ên nêbê Yesu Nasalet ob dii xumac ngɨbua vêl dɨ ob pɨlepac môp wê Moses vông vô il ilage vac.” ");
INSERT INTO ptp_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Mêd xomxo vɨhati wê dô vac kaunsil ben gee yê Stiven xêkɨzêc, lêc Stiven manôn tɨyi xocbê angela manôn. ");
INSERT INTO ptp_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Mêd xomxo daa siên nên levac kɨnêg vô Stiven ên nêbê, “Kɨyang wê he nêl lec ông ge, vɨxôhɨlôg, me?” ");
INSERT INTO ptp_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Lêc Stiven nêl ên nêbê, “Xam mage lige, xam ngô lê. Vô buc ilage wê il bug Eblaham gên dô Mesopotemia dɨ laên vɨgwe Halan gên ma ge od xêseac kehe Anutu hɨlung i vô Eblaham ");
INSERT INTO ptp_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","dɨ nêl vô i ên nêbê, ‘Ông sea bom dɨ sea tame mame lime dɨ loc vɨgwe ti wê a obêc hɨlung vô ông ge.’ ");
INSERT INTO ptp_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Om Eblaham sea tɨbii Kaldia ben dɨ la dô vɨgwe Halan. Dɨ buc wê Eblaham ma yib ge Anutu vông i lam vac vɨgwe tiga wê xam dô vac gwêbaga. ");
INSERT INTO ptp_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Lêc Anutu o vông kɨbun tiga tya vô Eblaham lêm. Nge, Anutu hɨlu kɨyang vô i ên nêbê obêc tɨmuên ge od obêc vông vɨgwe vɨhati i tu Eblaham hɨxôn bue tɨmuên xe. Eblaham nue gên ma, lêc Anutu hɨlu kɨyang tige tax vô i, ");
INSERT INTO ptp_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","dɨ nêl hɨxôn ên nêbê, ‘Nume bume tɨmuên obêc la dô vac tɨbii ben dɨ tu tɨbii tigee nue yuac dɨ he ob vông vɨyin vô he tɨyi klismas tɨbeac hɨwocên xocbê 400, ");
INSERT INTO ptp_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","lêc a obêc vông myavɨwen vô tɨbii wê bume ob tu he nue yuac ge, dɨ obêc tɨmuên bume ob sea tɨbii ben dɨ lôm lam vac vɨgwe tiga tii vac dɨ vông lɨlo dɨ kɨtaa vô a.’ ");
INSERT INTO ptp_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Nang dêc Anutu hɨlu kɨyang vô Eblaham ên nêbê he i gôl nue vux ninɨvi ên i nêl kɨtong bê he tu Anutu nue, om buc wê Eblaham nu Aisak yubac dɨ buc vɨgê vɨlu dɨ sec yon la vêl ge od Eblaham gôl Aisak ninɨvi. Nang dêc Aisak kô nu Jekop dêc Jekop kô nue vɨgê yuu dɨ tô mɨ la yuu wê tu il buge ge. ");
INSERT INTO ptp_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Lêc il buge xêyaa vô myavɨnê vô li Josep om he vông Josep mɨ tɨbii ya kɨsuu dɨ kô mɨ la vɨgwe Isip. Lêc Anutu dô hɨxôn Josep ");
INSERT INTO ptp_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","dɨ ngɨdu i xôn vac vɨyin wê tɨbii vông vô i ge, dɨ vông pɨyôp nivɨha vô Josep om tɨbii Isip nên king Pelo yê Josep nivɨha dɨ vông i tu Isip nên gavman levac dɨ i viac xumac hɨxôn susu vɨhati wê Pelo vông ge. ");
INSERT INTO ptp_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","“He dô lêc vip levac yêp vac vɨgwe Isip yuu Kenan vɨhati, ên he xen susu yaên ma vêl, om xomxo vɨhati dô vac vɨyin levac dɨ il buge o tulec yaên ti lêm. ");
INSERT INTO ptp_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Lêc Jekop ngô wê yaên dô Isip ge om vông nue la Isip taxlee. ");
INSERT INTO ptp_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Nang dêc he lax Isip lu ngwe tii vac dɨ Josep nêl i kɨtong vô lie, dɨ nêl vô king Pelo hɨxôn om Pelo xovô Josep he lie kehe. ");
INSERT INTO ptp_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Mêd Josep vông kɨyang la vô ma Jekop nêbê Jekop hɨxôn Josep lie he nue, he vɨhati i loc vô i gê Isip. Xomxo tigee he vɨhati tɨyi 75, ");
INSERT INTO ptp_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","mêd Jekop la dô Isip dêc yib. Nang dêc Jekop nue yib. ");
INSERT INTO ptp_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Jekop yuu Josep, nue bue kô yuu mɨ lax yev gê vɨgwe Sekem vac vɨgwe ti wê tɨbii Hemo vông mɨ Eblaham kɨsuu ya mone ilage. ");
INSERT INTO ptp_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Xomxo Islel dô Isip dɨ vô tɨbeac hɨwocên mêd buc vô kwabo lec wê Anutu ob vông kɨyang wê hɨlu vô Eblaham ilage i vô nôn lec ge. ");
INSERT INTO ptp_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","He dô Isip, lêc Isip paha ti tu king om lungên Josep, ");
INSERT INTO ptp_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","mêd kɨtyoo il buge dɨ vông vɨyin vô he ên nêbê he i sea nue paha i loc dô vaxvax ên he i yib. ");
INSERT INTO ptp_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Vô buc tige Moses yubac, lêc Moses ge nipwo nivɨha ti wê Anutu yê nivɨha ge, om ta yuu ma viac dɨ i dô vac xumac lôma dentuc yon, ");
INSERT INTO ptp_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","nang dêc he kô mɨ la lii vô mia nɨnya lêc Pelo nu vêx la kô mɨ la viac xocbê ici va nu ge dɨ i vô levac. ");
INSERT INTO ptp_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Mêd he tɨxuu Moses ya môp yuu xovôên vɨhati wê he Isip vông ge om Moses tɨyi xocbê xomxo wê mi nêl kɨyang dɨ vông yuac nivɨha ge. ");
INSERT INTO ptp_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Klismas wê Moses vông ge kehe yuu, lêc xo ên nêb ob la yê lie Islel ");
INSERT INTO ptp_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","om la yê, lêc yê wê tɨbii Isip ti hi li Islel ti ge, om Moses nêb ob ngɨdu li tige xôn dɨ ku i lu om la hi Isip tige yib. ");
INSERT INTO ptp_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Moses xo ên nêbê lie Islel xovô wê Anutu vɨnoo i nêb i vô he vêl ên vɨyin ge, lêc he o xovô lêm. ");
INSERT INTO ptp_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Mêd vɨgwe vɨdiiên tɨtige Moses lax mɨ la vô lie lêc yê wê Islel yuu dɨhima ge. Om nêb ob hi kɨyang wê yuu vông ge i yib om nêl vô yuu ên nêbê, ‘Letya nêb muu hima? Ên muu ge muu lim.’ ");
INSERT INTO ptp_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Lêc xomxo ngwe wê nêl vevac tax ge ngɨloo Moses dɨ nêl vô i ên nêbê, ‘Letya nêb ông ob tu xomxo levac wê xe vông dɨ tɨtô xe nêm kɨyangê? ");
INSERT INTO ptp_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Ông ob hi a xib tɨyi xocbê ông hi Isip ti yib vɨhevage?’ ");
INSERT INTO ptp_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Moses ngô kɨyang tige om pec mɨ la dɨ la dô tɨyi xocbê tɨbii ba vac vɨgwe ti lê nêbê Midian, mêd kô vêx dɨ nu vux yuu yubac vac vɨgwe tige. ");
INSERT INTO ptp_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“He dô Midian klismas kehe yuu, dɨ buc ti Moses la vac vɨgwe mahɨgun pɨleva ti wê yêp kwabo vô kɨtôn Sainai ge, lêc yê angela ti lam vac ngwax mahelac wê tum lec xax myabo ge. ");
INSERT INTO ptp_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Moses yê tige dɨ yetac om du mɨ la kwabo nêb ob la yê, lêc Apumtau vya nêl ên nêbê, ");
INSERT INTO ptp_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘A Anutu wê bume Eblaham yuu Aisak yon Jekop, yon Anutu a.’ Mêd Moses yetac dɨ xona dɨ vun manôn nêb yêên ob ma. ");
INSERT INTO ptp_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Mêd Apumtau nêl vô i ên nêbê, ‘Pɨwelac su vêl ên vɨxam, ên vɨgwe wê ông le lec ge vɨgwe ngɨbua. ");
INSERT INTO ptp_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","A xê wê a nuge dô vac vɨyin levac gê Isip dɨ a ngô wê he byag ge, om a lop mɨ lam ên a nêb a ob vô he vêl ên vɨyin tige. Om ông lam, ên a ob vông ông loc Isip.’ ");
INSERT INTO ptp_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Moses ge wê lie tii i la ilage dɨ nêl vô ên nêbê, ‘Letya vɨnoo ông ên nêb ông tu xomxo levac wê xe vông dɨ tɨtô xe nêm kɨyangê?’ He nêl bêge lê, lêc Anutu vông angela tige la vô Moses vac xax myabo dɨ vông i tu he Islel nên xomxo levac wê pɨwelac he vêl ên vɨyin ge. ");
INSERT INTO ptp_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Om Moses dɨdii he mɨ lam dɨ he sea vɨgwe Isip, dɨ Moses vông do levac gê Isip dɨ vông lec Gwec Hi dɨ vông vac vɨgwe mahɨgun pɨleva tɨyi klismas kehe yuu. ");
INSERT INTO ptp_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","“Moses ge wê nêl vô he Islel ên nêbê, ‘Anutu obêc vông xam lime ti tu plopet xocbê a ge.’ ");
INSERT INTO ptp_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Mêd Moses dô hɨxôn il buge vac vɨgwe mahɨgun pɨleva dɨ i lec mɨ la lec kɨtôn Sainai, lêc angela nêl Anutu kɨyang vô i dɨ i kô kɨyang mavɨha mɨ lôm nêl vô lie dɨ i lam vô il gwêbaga hɨxôn. ");
INSERT INTO ptp_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Lêc il buge vô nɨnya kɨtu vô Moses kɨyang dɨ pɨlepac nɨlô lax vô Isip nêb ob lax mɨ la, ");
INSERT INTO ptp_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","om he la nêl vô Moses li Elon ên nêbê, ‘Ông sev xe anutu ya, ên he i dɨdii il, ên Moses wê dɨdii il gê Isip mɨ il lam ge, xe lungên, mêd la dô na?’ ");
INSERT INTO ptp_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Om vô buc tige he sev bulmakau nu ti kɨnu dɨ tung daa vô anutu kɨtyooên tige dɨ pɨmil susu ti wê he vông ya vɨgê ge. ");
INSERT INTO ptp_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Om Anutu vô nɨmi vô he dɨ pɨlepac he nɨlô la vô hɨyôv yuu dentuc dɨ pɨtua dɨ he kɨtaa vô, tɨyi xocbê kɨyang wê plopet kɨvuu ilage mɨ i yêp vac kɨpihac bêga ên nêbê, ‘Xam Islel, xam la dô vac vɨgwe mahɨgun pɨleva tɨyi klismas kehe yuu, lêc xam o hi bwoc sipsip yuu bulmakau ya mɨ si daa vô a lêm. ");
INSERT INTO ptp_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Anutu kɨtyooên ti lê nêbê Molok ge, xam kô i xumac sel mɨ lam hɨxôn, dɨ kô pɨtua kɨnu wê anutu kɨtyooên lê nêbê Lepan vông ge hɨxôn, ên xam nêb xam ob kɨtaa vô, om a ob vông xam loc dô vac vɨgwe ti wê yêp Bebilon vɨlu ganê.’ ");
INSERT INTO ptp_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Vô buc wê il buge dô vac vɨgwe mahɨgun pɨleva ge Anutu xumac sel yêp vac he mahɨgun dɨ nêl kɨtong nêbê Anutu dô hɨxôn he. Xumac tige, he lox i tɨyi kɨnu wê Anutu hɨlung vô Moses ge. ");
INSERT INTO ptp_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Nang dêc Josua kô il buge mɨ he la vɨgwe Kenan, lêc tɨbii ya dô lec kɨbun tige om Anutu tii tɨbii tigee vêl dɨ he Islel la dô lec vɨgwe Kenan. Lêc xumac sel tige he kô mɨ la hɨxôn dɨ lax i le vac he mahɨgun dɨ i la tyip vô buc wê king Devit dô ge hɨxôn. ");
INSERT INTO ptp_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Mêd Anutu yê Devit nivɨha om Devit kɨtaa vô Anutu nêb ob lox xumac ti vô Anutu wê bu Jekop Anutu ge. Devit nêl bêge lê, ");
INSERT INTO ptp_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","lêc nu Solomon lox Anutu xumac tige. ");
INSERT INTO ptp_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“Lêc Anutu wê luu vɨhati vêl ge ob dô vac xumac wê xomxo lox ya vɨgê ge lêm. Tɨyi xocbê plopet kɨyang yêp bêga ên nêbê, ");
INSERT INTO ptp_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Anutu nêl ên nêbê, “Lag puunê ge tɨyi xocbê sia wê a ob dô lec ge, dɨ kɨbun ge tɨyi xocbê xax wê a vɨxag ob le lec ge. Om xam ob lox xumac ngwe bêna vô a? Dɨ a bog wê a ob dô seac vêl ge yêp gê na? ");
INSERT INTO ptp_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","A ga wê a vɨgêg tung susu tigee vɨhati.” ’ ");
INSERT INTO ptp_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","“Anutu kɨyang yêp bêge, lêc xam pɨyôp xêkɨzêc dɨ xam nɨlôm mapɨtoc dɨ xam vô nɨnyam kɨtu, dɨ xam tii Myakɨlôhô Ngɨbua tɨyi buc vɨhati. Xam vông môp tige tɨyi xocbê bume vông ilage. ");
INSERT INTO ptp_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Plopet tina wê bume o vông vɨyin vô he ilage lêm? He plopet ilage wê nêl kɨtong nêbê xomxo bôbac ti obêc val ge, xam bume hi he yib mɨma vêl. Dɨ xacxam va vông xomxo tyo vac tɨbii vevac vɨgê dɨ hi i yib. ");
INSERT INTO ptp_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Xam ge wê xam kô Anutu xolac vô angela ge, lêc xam o tɨmu vô lêm.” Stiven nêl kɨyang bêge vô he. ");
INSERT INTO ptp_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","He kaunsil ngô kɨyang wê Stiven nêl vô he ge mêd he xêyaa vô myavɨnê mabu vô Stiven dɨ he nga mya xôn nêb ob hi. ");
INSERT INTO ptp_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Lêc Myakɨlôhô Ngɨbua hɨvun Stiven xôn dɨ i lax ma lec lag, lêc yê xêseac wê Anutu vông ge dɨ yê Yesu le vô Anutu vɨgê hɨyôv, ");
INSERT INTO ptp_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","om nêl ên nêbê, “Xam wê lê. A xê lag puunê tax dɨ Xomxo Nu le vô Anutu vɨgê hɨyôv.” ");
INSERT INTO ptp_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","He ngô Stiven kɨyang dɨ iac mabu dɨ kɨyel nɨnya xôn ên nêb ob ngô Stiven kɨyang lêm. Dɨ lutibed he vɨhati kɨdi lec dɨ la hôm Stiven xôn, ");
INSERT INTO ptp_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","dɨ kô mɨ la vɨgwe Jelusalem nɨnya nêb ob la nêx i yib ya ngɨdax. Om he wê vông kɨyang vô Stiven gee kwax he ngakwi ngwe vêl mɨ la tung vô xomxo ngɨvihi ti lê nêbê Sol. ");
INSERT INTO ptp_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Mêd he nêx Stiven ya ngɨdax, lêc Stiven kɨtaa bêga nêbê, “Apumtau Yesu, ông hôm a myagkɨlôhô i loc vô ông.” ");
INSERT INTO ptp_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Mêd Stiven yev vɨxa kɨtu vac dɨ kɨtaa vya levac ên nêbê, “Apumtau, le i lêc hôm he nên nipaên wê he vông ge xôn lêm.” Stiven nêl bêge mêd yib. ");
INSERT INTO ptp_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Sol xêyaa vô nivɨha ên wê he hi Stiven yib ge. Dɨ buc mahɨgun tige xomxo kɨdi mɨ vông vɨyin mabu vô xomxo vông vinên wê dô Jelusalem gee, om he vông vinên vɨhati pec mɨ la dɨ la dô vɨgwe Judia yuu Samelia, dɨ Yesu nue ngɨvihi ge he dô Jelusalem. ");
INSERT INTO ptp_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Dɨ xomxo wê mi tɨmu vô Anutu kɨyang ge, he ya kô Stiven ninɨvi mɨ la yev dɨ byag mabu ên wê i yib ge. ");
INSERT INTO ptp_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Lêc Sol nêb ob kɨtya xomxo vông vinên vɨhati vêl om la vac he toto ben dɨ la hôm vêx yuu vux xôn dɨ kô mɨ la tung vac xumac kalabuhu. ");
INSERT INTO ptp_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Xomxo vông vinên wê pec sea gee la vac vɨgwe toto dɨ la nêl Yesu xolac kɨtong. ");
INSERT INTO ptp_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Mêd Pilip la vac vɨgwe ti wê yêp vac vɨgwe levac Samelia ge dɨ la nêl Yesu kɨtong vô he ên nêbê Yesu ge Kɨlisi wê Anutu vông i lam ge. ");
INSERT INTO ptp_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Dɨ xomxo tigee ngô kɨyang wê Pilip nêl ge dɨ yê do levac wê vông ge om vô nɨnya lehe vô i kɨyang. ");
INSERT INTO ptp_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Ên xomxo tɨbeac wê vɨmwo nipaên dô vac he nɨlô gee, vɨmwo tigee iac mabu dɨ lam lop mɨ la vêl ên he, dɨ xomxo tɨbeac wê len vô xêlehe gee hɨxôn he wê vɨxa vô nipaên ge, he vô nivɨha lec. ");
INSERT INTO ptp_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Mêgem xomxo vɨyang tige dô hɨxôn xêyaa nivɨha. ");
INSERT INTO ptp_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Xomxo ti dô Samelia lê nêbê Saimon. Saimon mi yong i nêbê i xomxo levac dɨ mi vông pɨleac om xomxo Samelia yê dɨ yetac ên. ");
INSERT INTO ptp_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Om xomxo levac hɨxôn xomxo vɨhati he vô nɨnya lehe vô Saimon kɨyang dɨ nêl bêga nêbê, “Xomxo tige kô xêkɨzêc levac vô Anutu.” ");
INSERT INTO ptp_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Dɨ he yetac ên do levac wê Saimon mi vông ila ila ge om he vô nɨnya lehe vô Saimon kɨyang. ");
INSERT INTO ptp_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Lêc Pilip la nêl Anutu ben kehe kɨtong vô he dɨ nêl Yesu Kɨlisi xolac nivɨha vô he, om xomxo vêx yuu vux tɨbeac vông i vin dɨ lipac mia. ");
INSERT INTO ptp_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Dɨ Saimon vông i vin hɨxôn dɨ lipac mia dɨ la hɨxôn Pilip dɨ yetac mabu ên do levac wê Pilip mi vông ge. ");
INSERT INTO ptp_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Mêd Yesu nue ngɨvihi wê dô Jelusalem gee ngô wê xomxo Samelia vông i vin Anutu xolac ge om he vông Pita yuu Jon loc mɨ la vô he, ");
INSERT INTO ptp_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","dɨ yuu la kɨtaa lec he ên nêbê Myakɨlôhô Ngɨbua i loc vô he. ");
INSERT INTO ptp_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Ên Myakɨlôhô Ngɨbua gên o la vô he lêm. He lipac mia lec Yesu Kɨlisi vaci lê. ");
INSERT INTO ptp_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Om yuu la vyax vɨgê lec he dɨ Myakɨlôhô Ngɨbua lam la vac he nɨlô. ");
INSERT INTO ptp_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Mêd Saimon yê wê Pita yuu Jon vyax vɨgê lec xomxo dɨ Myakɨlôhô Ngɨbua lam la vac he nɨlô ge, om Saimon kô mone mɨ la vô yuu ");
INSERT INTO ptp_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","dɨ la nêl vô yuu ên nêbê, “Muu vông xêkɨzêc tige vô a hɨxôn êdêc a vyax vɨgêg lec xomxo ge od Myakɨlôhô Ngɨbua i loc vac he nɨlô.” ");
INSERT INTO ptp_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Lêc Pita nêl vô i ên nêbê, “Xêkɨzêc ti wê Anutu nêb ob vông pɨleva ge ông nêb ông ob kɨsuu ya mone, om ông loc dɨ loc xôa ma hɨxôn ông mone. ");
INSERT INTO ptp_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Ông ob vông yuac tiga hɨxôn xe lêm, ên ông nɨlôm o yêp nivɨha vô Anutu manôn lêm. ");
INSERT INTO ptp_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Om ông pɨlepac ông dɨ vô nɨmim vô môp nipaên wê ông vông ge, dɨ ông kɨtaa vô Apumtau ên i kɨtya ông nêm nipaên wê yêp vac ông nɨlôm ge vêl, ");
INSERT INTO ptp_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","ên a xê wê kɨyang juda juda pup vac ông nɨlôm dɨ ông nêm nipaên hôm ông xôn pɨlihi.” ");
INSERT INTO ptp_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Mêd Saimon luu Pita vya ên nêbê, “Muu kɨtaa vô Apumtau lec a, ên nipaên wê muu nêl ge i o lêc tulec a lêm.” ");
INSERT INTO ptp_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Mêd Pita yuu Jon nêl Apumtau Yesu kɨtong vô xomxo. Pyap dɨ yuu la, nêb ob lax mɨ la Jelusalem. Om yuu la nêl Anutu xolac vac vɨgwe toto gê Samelia dɨ lax mɨ la Jelusalem. ");
INSERT INTO ptp_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Apumtau vông angela ti la nêl vô Pilip ên nêbê, “Ông kɨdi lec dɨ loc vô môp ngwe wê yêp vô vɨgê kêd wê ob sea Jelusalem dɨ la Gasa ge.” Môp tige yêp vac vɨgwe mahɨgun pɨleva wê tɨbii dô vacên ma ge. ");
INSERT INTO ptp_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Om Pilip kɨdi lec mɨ la, lêc mɨla tulec xomxo ti vac môp. Xomxo tige tɨbii Itiopia levac ti wê mi viac mone yuu susu wê he kwin Kandesi vông ge gê Itiopia. Xomxo tyo la kɨtaa vô Anutu gê Jelusalem, ");
INSERT INTO ptp_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","pyap dɨ lax nêb ob lax ben, om dô lec pêt ti wê xôhô dɨdii ge mêd kɨtong kɨpihac wê plopet Aisaia kɨvuu ilage dɨ la vô môp mɨ la. ");
INSERT INTO ptp_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Mêd Myakɨlôhô Ngɨbua nêl vô Pilip ên nêbê, “Loc kwabo vô xomxo tiganê dɨ loc hɨxôn.” ");
INSERT INTO ptp_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Om Pilip tup mɨ la dɨ mɨla le hɨxôn xomxo tige dɨ ngô wê xomxo tige dɨkɨtong Aisaia kɨyang, om kɨnêg vô i ên nêbê, “Kɨyang wê ông kɨtong ge, ông xovô kehe, me?” ");
INSERT INTO ptp_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Lêc xomxo tyo nêl ên nêbê, “Xomxo ti obêc nêl vô a ge od a ob xovô.” Om xomxo tige kɨtaa Pilip ên nêbê, “Ông lec lam dô hɨxôn a.” ");
INSERT INTO ptp_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Xolac wê xomxo tige kɨtong ge nêl bêga nêbê, “He dɨdii xomxo tige mɨ la tɨyi xocbê bwoc sipsip wê he ob kô mɨ la hi i yib ge, dɨ i tɨyi xocbê bwoc sipsip nu ti wê he ob kɨping nivɨluhu vêl ge lêc xomxo tige le xôa maên dɨ o keac ti lêm. ");
INSERT INTO ptp_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","He vông i lê vô nipaên, dɨ he o tɨtô i nên kɨyang vô nivɨha lêm. Om letya ob nêl i nue bue kɨyang? Ên i sea kɨbun ga dɨ la.” ");
INSERT INTO ptp_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Mêd tɨbii levac tige kɨnêg vô Pilip ên nêbê, “Ông nêl kɨtong vô a bê plopete kɨvuu kɨyang tiga lec letya? Kɨvuu lec ici va, me kɨvuu lec xomxo ngwe?” ");
INSERT INTO ptp_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Om Pilip nêl Yesu xolac nivɨha wê yêp vac plopete kɨyang tige yêp seac vô xomxo tyo. ");
INSERT INTO ptp_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Mêd yuu la vô môp mɨ la, dɨ mɨla vô mia ti, om xomxo tige nêl vô Pilip ên nêbê, “Wê lê. Mia yêp ga, om tɨyi wê ông ob lipac a ge, me?” ");
INSERT INTO ptp_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Mêd Pilip nêl ên nêbê, “Ông obêc vông nɨlôm la yadɨluhu vô Anutu dɨ vông i vin ge od tɨyi wê ông ob lipac mia.” Mêd tyo nêl ên nêbê, “A vông i vin ên a nêbê Yesu Kɨlisi ge Anutu nu vɨxôhɨlôg.” ");
INSERT INTO ptp_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Om nêl dɨ xôhô le dɨ yuu lop mɨ la vac mia dɨ Pilip lipac i. ");
INSERT INTO ptp_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Mêd yuu lôm tyip kehe dɨ Apumtau Myakɨlôhô Ngɨbua hôm Pilip vêl lutibed, om xomxo tige yê wê Pilip xôa ma ge dɨ i la hɨxôn xêyaa nivɨha dɨ la ben. ");
INSERT INTO ptp_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Mêd Pilip yê lêc val dô vɨgwe Asdot. Mêd loc mɨ la vac vɨgwe tigee vɨhati dɨ la nêl Anutu xolac vô xomxo dɨ mɨla Sisalia. ");
INSERT INTO ptp_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Vô buc tige Sol le nêl kɨyang xêkɨzêc nêb ob vông vɨyin vô xomxo vông vinên dɨ hi he yib, om la vô xomxo daa siên nên levac ");
INSERT INTO ptp_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","mɨ la nêl vô ên nêb i kɨvuu kɨpihac i loc vac he Yuda vac xumac lɨlo wê yêp vɨgwe Damaskas ge. Om kɨvuu kɨpihac bêga nêbê Sol obêc tulec vêx me vux wê mi tɨmu vô Yesu môp gee od i hôm he xôn dɨ kô mɨ loc Jelusalem dɨ loc tung vac xumac kalabuhu. ");
INSERT INTO ptp_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Mêd Sol la vô môp dɨ mɨla kwabo vô Damaskas, lêc lutibed xêseac xocbê deac hɨxelac ge lam gê kɨsii dɨ lam byêx Sol manôn ");
INSERT INTO ptp_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","dɨ i tɨlii mɨ la yêp kɨbun dɨ ngô vya ti lam nêl vô i ên nêbê, “Sol, bêna lêc ông vông vɨyin vô a?” ");
INSERT INTO ptp_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Lêc Sol kɨnêg ên nêbê, “Apumtau, ông letya?” Dɨ i nêl ên nêbê, “A Yesu wê ông vông vɨyin vô a. ");
INSERT INTO ptp_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Ông kɨdi lec mɨ loc vɨgwe Damaskas, ên xomxo ti obêc nêl kɨtong vô ông lec yuac wê a nêb ông ob vông ge.” ");
INSERT INTO ptp_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Mêd xomxo wê dô hɨxôn Sol gee ngô vya tige lêc he o yê xomxo ti nôn lêm om he le kɨyang maên. ");
INSERT INTO ptp_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Mêd Sol kɨdi lec dɨ vông manôn hɨxelac lêc manôn mapɨtoc, om he hôm lec Sol vɨgê dɨ dɨdii i dɨ he la Damaskas. ");
INSERT INTO ptp_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Mêd Sol la dô tɨyi buc yon lêc manôn dô mapɨtoc, dɨ yaên yuu numên ma. ");
INSERT INTO ptp_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Xomxo wê vông i vin Yesu ge ti dô Damaskas lê nêbê Ananaias, lêc Apumtau vông vɨvia vô dɨ nêl ên nêbê, “Ananaias.” Mêd Ananaias nêl ên nêbê, “Apumtau, a dô ga.” ");
INSERT INTO ptp_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Mêd Apumtau nêl vô i ên nêbê, “Ông kɨdi dɨ loc môp ti wê he nêl lê nêbê môp bôbac ge dɨ loc Judas ben dɨ loc kɨnêg xomxo Tasas ti lê nêbê Sol wê dô vac Judas ben dɨ kɨtaa mɨ dô. ");
INSERT INTO ptp_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Ên Sol yê vɨvia ti nêbê xomxo ti lê nêbê Ananaias ob kɨdi mɨ la vô i dɨ la vyax vɨgê lec, ên i manôn i seac dɨ i yê vɨgwe.” ");
INSERT INTO ptp_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Lêc Ananaias nêl ên nêbê, “Apumtau, a ngô wê xomxo tɨbeac nêl kɨyang lec xomxo tige nêbê mi vông nipaên tɨbeac vô ông nume vông vinên gê Jelusalem, ");
INSERT INTO ptp_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","dɨ xomxo daa siên nên levac tyuc lec xomxo tige nêb i lam vɨgwe ga dɨ lam hôm xomxo wê vông i vin ông ge xôn.” ");
INSERT INTO ptp_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Lêc Apumtau nêl vô i ên nêbê, “Ông kɨdi lec dɨ loc, ên xomxo tige a vɨnoo pyap ên a nêb i tu a nug yuac dɨ i loc nêl a lêg vô tɨbii vɨyang vɨyang hɨxôn he king dɨ i loc nêl vô lie Islel hɨxôn. ");
INSERT INTO ptp_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Dɨ vɨyin wê xomxo tige ob kô lec a lêg ge aca va obêc hɨlung vô i.” ");
INSERT INTO ptp_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Om Ananaias loc mɨ la, dɨ la vô Sol vac xumac nɨlô dɨ la vyax vɨgê lec dɨ nêl ên nêbê, “A lig Sol, Apumtau Yesu wê hɨlung i vô ông vac môp wê ông lam ge, ici va vông a lam vô ông ên nêb ông mamnôn i seac dɨ Myakɨlôhô Ngɨbua i lam hɨvun ông xôn.” ");
INSERT INTO ptp_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Om lutibed susu xocbê makɨkeng ge tô mɨ la vêl ên Sol manôn dɨ i manôn seac dɨ i yê vɨgwe, dɨ i kɨdi lec dɨ Ananaias lipac i lec Yesu lê ên wê vông i vin ge. ");
INSERT INTO ptp_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Pyap dɨ i ya susu yaên dɨ vô xêkɨzêc lec. Sol dô Damaskas hɨxôn xomxo vông vinên buc ya. ");
INSERT INTO ptp_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Om lutibed Sol la vac Yuda xumac lɨlo dɨ la nêl Yesu kɨtong vô he bêga nêbê, “Yesu ge Anutu nu.” ");
INSERT INTO ptp_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Om xomxo vɨhati wê ngô Sol kɨyang gee yetac dɨ nêl vôma ên nêbê, “Xomxo tige wê mi hi xomxo ên wê he mi kɨtaa vô Yesu ge. Hi gê Jelusalem dɨ lam ga hɨxôn ên nêb ob lam hôm xomxo xôn dɨ kô he mɨ lax vô xomxo levac wê mi si daa gee. Om mêd xomxo tyo tige.” ");
INSERT INTO ptp_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Lêc Sol nêl xolac hɨxôn xêkɨzêc dɨ nêl kɨyang yêp seac nêbê Yesu ge Kɨlisi wê Anutu vông i lam ge, om he Yuda wê dô Damaskas gee, he o tɨyi wê ob nêl kɨyang ti lax vô i ge lêm. ");
INSERT INTO ptp_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Mêd buc tɨbeac lam la vêl lêc he Yuda kɨtucma dɨ nêl kɨyang mɨ hɨlu xôn nêb ob hi Sol i yib. ");
INSERT INTO ptp_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Om Yuda ya la dô bin vuayen wê le vac xenac wê vivac vô vɨgwe Damaskas ge, om he dô bin vô bucên yuu vɨdiiên vɨhati ên nêb ob hi Sol i yib. Lêc Sol ngô wê he nêb ob hi i yib ge, ");
INSERT INTO ptp_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","om bucên ti xomxo wê mi dô hɨxôn Sol gee kô i mɨ he lec xenac tige mɨ la tyip kɨsii, mêd tung Sol vac sepac levac ti dɨ vông i lop mɨ la xenac kehe dɨ i pec mɨ la. ");
INSERT INTO ptp_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Sol loc mɨ la Jelusalem, nêb ob la dô hɨxôn xomxo wê vông i vin Yesu ge, lêc he vɨhati xona ên Sol, ên he o vông i vin nêbê Sol ge xomxo vông vinên ti lêm. ");
INSERT INTO ptp_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Mêd Banabas kô i mɨ yuu la vô Yesu nue ngɨvihi dɨ Banabas nêl kɨtong vô he lec wê Sol yê Apumtau vac môp dɨ Apumtau nêl kɨyang vô i ge dɨ nêl lec wê Sol nêl Yesu vya kɨtong vô tɨbii Damaskas dɨ xonaên ma ge. ");
INSERT INTO ptp_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Om Sol dô hɨxôn he dɨ la vac vɨgwe Jelusalem vɨhati dɨ nêl Apumtau lê kɨtong vô xomxo dɨ o xona lêm. ");
INSERT INTO ptp_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Mêd he Yuda wê keac Glik vya ge, he Sol ngaênma lec Yesu xolac dɨ he myag môp wê nêb ob hi Sol i yib ge. ");
INSERT INTO ptp_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Lêc xomxo vông vinên ngô wê he nêb ob hi Sol yib ge om he kô Sol mɨ la vɨgwe Sisalia dɨ vông Sol la ben Tasas. ");
INSERT INTO ptp_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Mêd xomxo vông vinên wê dô Judia yuu Galili dɨ Samelia ge he vɨhati dô vɨyin maên dɨ vevac ma ên he. He dô vac Apumtau vɨlu kwa ngɨbi dɨ Myakɨlôhô Ngɨbua ngɨdu he xôn, om he vô xêkɨzêc dɨ xomxo vông vinên vô tɨbeac hɨwocên. ");
INSERT INTO ptp_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Pita la vɨlee mɨ la vac vɨgwe vɨhati, dɨ buc ti lêc la yê xomxo vông vinên wê dô vɨgwe Lidia ge. ");
INSERT INTO ptp_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Vac vɨgwe tige yê xomxo ti lê nêbê Inias wê len vô xêlehe dɨ i yêp lec pêt tɨyi klismas vɨgê vɨlu dɨ sec yon ge. ");
INSERT INTO ptp_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Mêd Pita nêl vô i ên nêbê, “Inias, gwêbaga Yesu Kɨlisi vông ông vô nimvɨha lec. Om ông kɨdi lec mɨ vɨlun ông guhu.” Om Inias kɨdi lec lutibed. ");
INSERT INTO ptp_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Dɨ xomxo vɨhati vac vɨgwe Lidia yuu Salon yê dɨ pɨlepac nɨlô la vô Apumtau dɨ vông i vin. ");
INSERT INTO ptp_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Vêx vông vinên ti lê nêbê Tabita dô Jopa. Vac Glik vya he nêl vêx tige lê nêbê Dokas. Vêx tige vông môp nivɨha vô xomxo tɨyi lec buc vɨhati dɨ vông susu vô xomxo wê nên susu maên ge hɨxôn. ");
INSERT INTO ptp_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Vô buc tige yidac vông i dɨ i yib, mêd he lipac i ninɨvi dɨ lii i yêp vac xumac nɨlô ti gê kɨsii. ");
INSERT INTO ptp_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Mêd xomxo vông vinên ngô wê Pita la dô vɨgwe Lidia ge, lêc Lidia yêp kwabo vô Jopa om he vông vux yuu la vô Pita dɨ yuu la nêl vô ên nêbê, “Ông lam vô xe lutibed.” ");
INSERT INTO ptp_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Om Pita kɨdi mɨ la hɨxôn yuu dɨ yon loc mɨ la Jopa, dɨ he kô Pita mɨ lec mɨ la vac xumac nɨlô kɨsii tyo. Mêd vêxôv tɨbeac lam le hɨxôn Pita dɨ byag, dɨ kô nivɨmihi yuu ngakwi toto wê Dokas duu vac buc wê gên dô mavɨha ge mɨ hɨlung vô Pita. ");
INSERT INTO ptp_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Lêc Pita vông he vɨhati lop mɨ la vɨxun dɨ i yev vɨxa kɨtu vac dɨ kɨtaa vô Anutu, mêd pop manôn vô vêx tyo dɨ nêl bêga nêbê, “Tabita, ông kɨdi lec.” Mêd vêx tyo manôn seac dɨ i yê Pita dɨ kɨdi mɨ dô. ");
INSERT INTO ptp_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Mêd Pita hôm lec vɨgê dɨ i kɨdi lec mɨ le kɨsii. Mêd Pita nêl vêxôv hɨxôn xomxo vông vinên vɨhati lam dɨ hɨlung vêx tyo wê kɨdi lec mavɨha ge vô he. ");
INSERT INTO ptp_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Mêd xomxo Jopa vɨhati ngô wê vêx tyo kɨdi lec ge om he tɨbeac vông i vin Apumtau. ");
INSERT INTO ptp_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Mêd Pita dô Jopa buc tɨbeac dɨ dô hɨxôn xomxo ti lê nêbê Saimon wê mi vông yuac lec bwoc ninɨvi ge. ");
INSERT INTO ptp_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Tɨbii vevac levac ti lê nêbê Konilias dô vɨgwe Sisalia. Konilias viac nue vevac 100 vac he kɨdu ti wê nêl he nêbê he Itali ge. ");
INSERT INTO ptp_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Konilias he vɨnê nue vɨhati vông i vin Anutu dɨ kɨtaa vô Anutu tɨyi lec buc vɨhati, dɨ Konilias mi ngɨdu he Yuda wê nên susu maên gee xôn. ");
INSERT INTO ptp_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Dɨ buc ti xocbê hɨyôv manôn yon, lêc Anutu vông angela ti lam nêl vô Konilias ên nêbê, “Konilias.” ");
INSERT INTO ptp_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Mêd Konilias yê ma la angela tige dɨ xona mabu dɨ kɨnêg ên nêbê, “Xomxo levac, vatya?” Mêd angela tige nêl ên nêbê, “Anutu ngô wê ông mi kɨtaa ge dɨ yê wê ông vông susu vô he wê nên susu maên gee om xovô môp wê ông mi vông ge pyap. ");
INSERT INTO ptp_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Om ông vông xomxo ya i loc vɨgwe Jopa ên loc nêl Saimon wê lê ngwe nêbê Pita ge ên i lam. ");
INSERT INTO ptp_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Saimon Pita la dô vac Saimon ngwe ben, ngwe wê mi vông yuac lec bwoc ninɨvi ge ben wê yêp kwabo vô gwec nɨnya ge.” ");
INSERT INTO ptp_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Angela nêl kɨyang pyap vô Konilias dɨ loc mɨ la, mêd Konilias tyuc i nue yuac yuu dɨ lie vevac ti lam. Xomxo vevac tige, xomxo vông vinên ti wê mi dô hɨxôn Konilias tɨyi buc vɨhati ge. ");
INSERT INTO ptp_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Mêd Konilias nêl angela kɨyang kɨtong vô yon dɨ vông yon loc mɨ la Jopa. ");
INSERT INTO ptp_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Xomxo yon ge loc mɨ la, dɨ vɨgwe vɨdiiên tɨtige yon mɨla kwabo vô Jopa. Dɨ hɨyôv tyip kɨtôn lêc Pita lec mɨ la lec xumac kɨtôn kɨsii nêb ob la kɨtaa vô Anutu. ");
INSERT INTO ptp_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Dɨ vip den Pita om Pita nêb ob ya yaên, lêc he gên o viac yaên wê he ob ya ge lêm, om Pita xeedô, lêc tɨxuuên ti val vô i ");
INSERT INTO ptp_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","dɨ i yê ma la kɨsii, lêc lag puunê tax dɨ susu ti xocbê nivɨmihi levac ti lam gê kɨsii lêc lam xocbê xomxo hɨlu yihi lec myahɨpu vɨhati dɨ vông i lam tô kɨbun. ");
INSERT INTO ptp_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Lɨlii yuu menac dɨ bwoc yuu myel toto dô vac nivɨmihi tige nɨlô, ");
INSERT INTO ptp_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","mêd vya ti lam nêl ên nêbê, “Pita, kɨdi lec mɨ loc hi lɨlii tigee mɨ wa.” ");
INSERT INTO ptp_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Lêc Pita nêl ên nêbê, “Apumtau, a xaên ob ma. Ên a o mi xa yaên wê xe vɨbu ên xe nêbê ningeac ge lêm.” ");
INSERT INTO ptp_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Mêd vya tige lam tii vac nang ên nêbê, “Susu wê Anutu kɨtaa lec nêbê nivɨha ge, ông o lêc wê ên ông nêbê nipaên lêm.” ");
INSERT INTO ptp_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Anutu nêl kɨyang tige vông lu yon mêd nivɨmihi tige lec mɨ lax kɨsii lutibed. ");
INSERT INTO ptp_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Mêd Pita dô dɨ xo kɨyang tɨbeac lec susu wê yê ge ên nêbê, “Tige kehe bêna?” Mêd xomxo yon wê Konilias vông yon lam ge val Jopa, mêd kɨnêg xumac wê Saimon vông ge vô xomxo ya dɨ val le vô Saimon ben vuayen, ");
INSERT INTO ptp_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","dɨ keac ên nêbê, “Saimon ti wê lê ngwe nêbê Pita ge dô ga, me?” ");
INSERT INTO ptp_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Pita xeedô dɨ xo susu wê yê ge, mêd Myakɨlôhô Ngɨbua nêl vô i ên nêbê, “Ngô lê. Xomxo yon val myag ông, ");
INSERT INTO ptp_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","om ông kɨdi lec dɨ lop mɨ loc vô yon dɨ loc hɨxôn yon, dɨ ông o lêc nɨlôm yuu yuu lêm, ên aca va vông yon lam.” ");
INSERT INTO ptp_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Om Pita lop mɨ la vô yon dɨ nêl vô ên nêbê, “A Pita wê mon myag a ge. Mon lam ên vatya?” ");
INSERT INTO ptp_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Mêd yon nêl ên nêbê, “Konilias wê tu levac ên tɨbii vevac 100 ge wê vông xen lam. Konilias ge xomxo nivɨha ti wê mi kɨtaa vô Anutu dɨ xomxo Yuda vɨhati yê i nivɨha. Mêd Anutu vông angela ti lam nêl vô Konilias ên nêb Konilias i vông kɨyang i loc vô ông ên ông loc i ben dɨ loc nêl kɨyang vô i.” ");
INSERT INTO ptp_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Mêgem Pita keac yon la xumac lôma dɨ viac yon, dɨ vɨdiiên tɨtige Pita kɨdi mɨ la hɨxôn yon, dɨ xomxo vông vinên Jopa he ya la hɨxôn mɨ he la. ");
INSERT INTO ptp_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","He mɨla môp dɨ vɨgwe vɨdiiên tɨtige he mɨla Sisalia. Dɨ Konilias kɨtuc lie hɨxôn nipɨpu ya mɨ he lam dô vac i ben dɨ bin Pita. ");
INSERT INTO ptp_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Mêd Pita la vac Konilias ben dɨ Konilias lam yev vɨxa kɨtu vô Pita dɨ pɨmil i. ");
INSERT INTO ptp_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Lêc Pita nêl vô ên nêbê, “Kɨdi lec mɨ le kɨsii, ên a ga xomxo xocbê ông.” ");
INSERT INTO ptp_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Mêd Pita keac vô i dɨ yuu la xumac lôma dɨ Pita yê wê xomxo tɨbeac kɨtucma mɨ xeedô ge. ");
INSERT INTO ptp_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Mêgem Pita nêl vô he ên nêbê, “Xacxam va xovô pyap wê xolac wê xe Yuda vông ge vɨbu ên nêb xe ob dô hɨxôn xam tɨbii ba lêm. Lêc Anutu nêl kɨtong vô a ên nêb a o lêc nêl xomxo ti bê i nipaên lêm. ");
INSERT INTO ptp_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Om gwêbaga a val i tɨyi ông vyam wê ông tyuc a ge dɨ a o pwoo ông vyam vac lêm. Om a ob kɨnêg ông bê ông nêb a lam ên vatya?” ");
INSERT INTO ptp_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Mêd Konilias nêl ên nêbê, “Nyop ge wê hɨyôv manôn mɨla yon xocbê hucên bêga, a dô vac xumac lôma dɨ kɨtaa vô Anutu, lêc lutibed xomxo ti lam le vô a magnôn hɨxôn ngakwi kwem pɨleva, ");
INSERT INTO ptp_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","dɨ nêl vô a ên nêbê, ‘Konilias, Anutu ngô wê ông mi kɨtaa ge dɨ xovô susu nivɨha wê ông mi vông vô xomxo wê nên susu maên gee, ");
INSERT INTO ptp_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","om ông vông xomxo i loc Jopa ên loc nêl vô Saimon wê lê ngwe nêbê Pita ge ên i lam. Saimon Pita la dô vac Saimon ngwe ben, ngwe wê mi vông yuac lec bwoc ninɨvi ge ben wê yêp kwabo vô gwec nɨnya ge.’ ");
INSERT INTO ptp_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Om a ngô kɨyang tige dɨ vông xomxo loc lutibed vô ông, dɨ ông vô nɨnyam lehe vô a vyag dɨ lam vô a. Om gwêbaga xe vɨhati lam dô ga vô Anutu manôn ên xe nêb xe ob ngô kɨyang vɨhati wê Apumtau vông vô ông ge.” ");
INSERT INTO ptp_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Mêd Pita nêl vô he bêga ên nêbê, “Gwêbaga a xovô vɨxôhɨlôg ên a nêbê Anutu o yê xomxo mangwe nêb nivɨha dɨ yê mangwe nêb nipaên lêm. Nge, Anutu yê xomxo vɨhati tɨyima. ");
INSERT INTO ptp_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Om xomxo vac vɨgwe vɨhati gee, ti obêc xona ên Anutu dɨ vông môp wê nivɨha ge od Anutu obêc yê i nivɨha. ");
INSERT INTO ptp_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Xam xovô xolac nivɨha pyap wê Anutu nêl vô xe Islel bêga ên nêbê Yesu Kɨlisi wê tu il vɨhati nêd Apumtau ge, ge wê vông il la dô tibed hɨxôn Anutu vac kɨyang malehe. ");
INSERT INTO ptp_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Dɨ xam xovô ên xam nêbê buc wê Jon nêl mia lipacên kɨtong vô xomxo pyap ge, od xolac tige kehe le vac vɨgwe Galili dɨ i la vac vɨgwe Judia vɨhati hɨxôn. ");
INSERT INTO ptp_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Yesu Nasalet ge, Anutu vɨnoo i dɨ vông Myakɨlôhô Ngɨbua hɨxôn xêkɨzêc levac vô i, om Yesu la vac vɨgwe vɨhati dɨ la ngɨdu xomxo xôn dɨ vông he wê Seten ku he xôn gee vô nivɨha lec, ên Anutu dô hɨxôn i. ");
INSERT INTO ptp_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Dɨ yuac vɨhati wê Yesu vông gê Jelusalem dɨ vông vac xe Yuda bom vɨhati ge, xe xê om xe nêl kɨtong vô xomxo. Nang dêc he hi Yesu yib lec xax pola, ");
INSERT INTO ptp_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","dɨ buc yon lam la vêl lêc Anutu tɨpi vô i kɨdi lec vac yibên dɨ hɨlung i le seac vô xe, ");
INSERT INTO ptp_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","lêc o hɨlung i vô Yuda vɨhati lêm. Nge, hɨlung i vô xe mangwe wê Anutu vɨnoo xe pyap nêbê xe nêl i kɨtong vô xomxo ge. Om Yesu kɨdi lec vac yibên dɨ xe xa dɨ num hɨxôn i. ");
INSERT INTO ptp_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Dɨ Yesu nêl vô xe ên nêbê xe nêl xolac vô xomxo dɨ nêl bêga bê Yesu ge wê Anutu vɨnoo pyap ên nêb i tɨtô xomxo yibên yuu mavɨha vɨhati nên kɨyang. ");
INSERT INTO ptp_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Plopete vɨhati nêl Yesu kɨtong ilage ên nêbê xomxo vɨhati wê vông i vin Yesu ge od Yesu lê obêc kɨtya he nên nipaên vêl.” ");
INSERT INTO ptp_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Pita gên nêl kɨyang tige vô he, lêc Myakɨlôhô Ngɨbua lam dô vac he wê ngô kɨyang gee vɨhati nɨlô. ");
INSERT INTO ptp_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Mêd he Yuda vông vinên wê lam hɨxôn Pita ge yê dɨ yetac ên wê Anutu vông Myakɨlôhô Ngɨbua tɨyi xocbê vɨzid nivɨha vô xomxo wê o Yuda lêm ge hɨxôn. ");
INSERT INTO ptp_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Dɨ he Yuda ngô wê xomxo tigee keac xomxo vɨgwe toto ge vya dɨ pɨmil Anutu. Om Pita nêl ên nêbê, ");
INSERT INTO ptp_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Anutu vông Myakɨlôhô Ngɨbua vô xomxo tigee tɨyi xocbê vông vô il Yuda ilage, om letya tɨyi wê ob le vac he xôn nêb he lipacên mia i ma?” ");
INSERT INTO ptp_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Om Pita nêl dɨ he lipac mia lec Yesu Kɨlisi lê. Mêd he kɨtaa Pita nêb i dô hɨxôn he buc ya. ");
INSERT INTO ptp_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Yesu nue ngɨvihi hɨxôn xomxo vông vinên wê dô vɨgwe Judia vɨhati gee ngô wê tɨbii wê o Yuda lêm ge vông i vin Anutu kɨyang. ");
INSERT INTO ptp_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Mêd Pita la Jelusalem, lêc he Yuda wê mi le xêkɨzêc lec ninɨvi gôlên gee kunac Pita dɨ nêl vô ên nêbê, ");
INSERT INTO ptp_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","“Bêna lêc ông la vô tɨbii madɨluhu wê gôlên ninɨvi ma ge dɨ wa yaên hɨxôn he?” ");
INSERT INTO ptp_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Lêc Pita nêl kɨyang vɨhati ge kɨtong vô he bêga nêbê, ");
INSERT INTO ptp_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“A dô vɨgwe Jopa dɨ kɨtaa mɨ dô, lêc a xê tɨxuuên ti bêga lec susu ti xocbê nivɨmihi levac ti lam gê lag puunê lêc lam xocbê xomxo hɨlu yihi lec myahɨpu vɨhati dɨ vông i lop mɨ lam vô a. ");
INSERT INTO ptp_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Om a xê nivɨmihi tyo, lêc bwoc yuu lɨlii dɨ menac dɨ myel toto gee dô vac nɨlô. ");
INSERT INTO ptp_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Dɨ a ngô vya ti lam hɨxôn ên nêbê, ‘Pita, kɨdi lec mɨ loc hi tigee mɨ wa.’ ");
INSERT INTO ptp_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Lêc a nêl ên a nêbê, ‘Apumtau, a xaên ob ma. Ên a o mi xa yaên wê xe vɨbu ên xe nêbê ningeac ge lêm.’ ");
INSERT INTO ptp_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Lêc vya tige lam gê lag puunê tii vac nang ên nêbê, ‘Susu wê Anutu kɨtaa lec nêbê nivɨha ge, le i lêc nêl bê nipaên lêm.’ ");
INSERT INTO ptp_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Anutu nêl kɨyang tige vông lu yon mêd susu tige lax mɨ la lag puunê. ");
INSERT INTO ptp_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Mêd lutibed xomxo yon wê lam gê Sisalia wê Konilias vông yon lam vô a ge, yon val le vô xumac wê a la dô vac ge. ");
INSERT INTO ptp_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Om Myakɨlôhô Ngɨbua nêl vô a ên nêbê, ‘Ông loc hɨxôn yon dɨ le i lêc xo kɨyang tɨbeac lêm.’ Om xomxo Jopa vɨgê vɨlu dɨ sec ti ga la hɨxôn a dɨ xe xôn la Sisalia dɨ la vac Konilias ben. ");
INSERT INTO ptp_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Mêd Konilias nêl vô xe ên nêbê i yê angela ti lam vac i ben dɨ lam nêl vô i ên nêbê, ‘Vông xomxo i loc Jopa ên loc kô Saimon, lê ngwe nêbê Pita mɨ i lam, ");
INSERT INTO ptp_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","ên Pita ob nêl kɨyang kɨtong vô xam dɨ kɨyang tige obêc vô xam lime nume vêl ên nipaên dɨ tung xam vac nivɨha.’ Konilias nêl kɨyang bêge vô xe ");
INSERT INTO ptp_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","dɨ a gên nêl kɨyang vô he, lêc Myakɨlôhô Ngɨbua lam dô vac he nɨlô tɨyi xocbê lam dô hɨxôn il ilage. ");
INSERT INTO ptp_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Om a xovô i lax lec kɨyang wê Apumtau nêl ilage ên nêbê, ‘Jon lipac xomxo ya mia pɨleva, lêc Anutu ob lipac xam ya Myakɨlôhô Ngɨbua.’ ");
INSERT INTO ptp_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Buc wê il vông i vin Apumtau Yesu Kɨlisi ilage, Anutu vông Myakɨlôhô Ngɨbua vô il tɨyi xocbê vɨzid nivɨha ge, dɨ gwêbaga Anutu vông vɨzid tige vô tɨbii tigee hɨxôn, om a tɨyiên ma wê a ob le vac Anutu kɨyang tige xôn.” ");
INSERT INTO ptp_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Yuda tigee ngô Pita kɨyang om he sea nɨlô vɨyin dɨ pɨmil Anutu ên nêbê, “Anutu pɨlepac he wê o Yuda lêm gee nɨlô, ên nêb he êno, he i dô mavɨha.” ");
INSERT INTO ptp_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Vô buc wê he hi Stiven yib dɨ vông vɨyin vô xomxo vông vinên ge, xomxo vông vinên tɨbeac pec mɨ la dɨ la dô vac vɨgwe Pinisia yuu Saiplas dɨ Antiok. Dɨ he nêl xolac vô xomxo vac vɨgwe tigee, lêc he o nêl vô xomxo vɨhati lêm. Nge, he nêl vô he Yuda vaci. ");
INSERT INTO ptp_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Lêc xomxo vông vinên ya wê lam gê Saiplas yuu Sailini gee la Antiok dɨ la nêl Apumtau Yesu xolac kɨtong vô he Glik hɨxôn. ");
INSERT INTO ptp_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Mêd xêkɨzêc wê Anutu vông ge ngɨdu he xôn, om xomxo tɨbeac pɨlepac nɨlô la vô Apumtau dɨ vông i vin. ");
INSERT INTO ptp_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Mêd xomxo vông vinên wê dô Jelusalem gee ngô wê tɨbii Antiok vông i vin xolac ge om he vông Banabas la Antiok. ");
INSERT INTO ptp_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Banabas mɨla yê wê Anutu vông vɨzid nivɨha vô he Antiok ge, om xêyaa vô nivɨha dɨ i viac kɨyang vô he ên nêbê he i vông i vin Apumtau hɨxôn nɨlô yadɨluhu i tɨyi buc vɨhati. ");
INSERT INTO ptp_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Banabas ge xomxo nivɨha ti wê vông i vin xêkɨzêc dɨ Myakɨlôhô Ngɨbua hɨvun i xôn. Mêd xomxo Antiok tɨbeac pɨlepac he dɨ vông i vin Apumtau. ");
INSERT INTO ptp_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Mêd Banabas loc mɨ la Tasas ên nêb ob la myag Sol. ");
INSERT INTO ptp_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Yêvô om yuu lax mɨ la Antiok, mêd yuu dô hɨxôn xomxo vông vinên Antiok tɨyi klismas ti dɨluhu dɨ le vông xolac vô he tɨbeac. Gê Antiok he nêl xomxo vông vinên lê nêbê Klisten taxlee. ");
INSERT INTO ptp_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Vô buc tige plopete ya wê lam gê Jelusalem ge val Antiok. ");
INSERT INTO ptp_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Mêd he ti lê nêbê Agabas le vac he mahɨgun dɨ nêl kɨyang ti wê Myakɨlôhô Ngɨbua nêl vô i ge ên nêbê vip levac obêc val vac vɨgwe vɨyang vɨyang. Agabas kɨyang tige vô nôn lec vô buc tɨmuên wê Klodias tu he nên king ge. ");
INSERT INTO ptp_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Xomxo vông vinên Antiok ngô Agabas kɨyang om hɨlu kɨyang nêb he ob ngɨdu lie vông vinên wê dô Judia ge xôn, om xomxo toto yê lêc vông i tɨyi mone wê yêp vô he ge. ");
INSERT INTO ptp_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Om he kɨtuc mone pyap dɨ vông vô Banabas yuu Sol dɨ yuu kô mɨ la vông vô gyovɨxa Jelusalem. ");
INSERT INTO ptp_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Vô buc tige king Helot vông vɨyin vô xomxo vông vinên ya, ");
INSERT INTO ptp_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","om vông tɨbii la hi Jon li Jems ya yipac mɨ i yib. ");
INSERT INTO ptp_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Mêd Helot yê wê Yuda mangwe he xêyaa vin lec môp tibêge om Helot nêl dɨ tɨbii la hôm Pita xôn. He vông tige lec buc levac wê he Yuda ya blet wê yis maên ge. ");
INSERT INTO ptp_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Mêd he la hôm Pita xôn dɨ kô mɨ la tung vac xumac kalabuhu, dɨ tɨbii xêhɨpu vɨgê yuu dɨ vɨxa vɨlu dɨ sec ti (16) yê Pita xôn dɨ he kɨdu yuudɨyuu om he yuudɨyuu la bin pyap, nang dêc yuudɨyuu obêc la bin nang. Mêd Helot xo nêbê Pita ob dô vac kalabuhu dɨ buc wê Yuda ob myêl vɨzid ên xovô buc wê bue sea Isip ilage i loc vêl lê, lêc vông Pita i loc le vô Yuda manôn ên he i ngô i nên kɨyang. ");
INSERT INTO ptp_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Om xêhɨpu tigee viac Pita mɨ he dô vac xumac kalabuhu, lêc he vông vinên kɨtaa xêkɨzêc vô Anutu nêb i ngɨdu Pita xôn. ");
INSERT INTO ptp_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Mêd Helot xo nêbê tɨtige Pita ob la le vô he Yuda manôn, om bucên ge Pita yêp vac xumac kalabuhu dɨ sen yuu ku i xôn dɨ i yêp vac xêhɨpu yuu mahɨgun, dɨ xêhɨpu ya le bin vuayen. ");
INSERT INTO ptp_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Lêc lutibed Anutu vông angela ti val vô Pita dɨ xêseac linac vac xumac lôma, mêd angela vyax vɨgê lec Pita dɨ tɨpi vô ên nêbê, “Kɨdi lec lutibed.” Mêd lutibed sen pɨwelac vêl ên Pita vɨgê dɨ tô mɨ la kɨbun. ");
INSERT INTO ptp_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Mêd angela nêl vô Pita ên nêbê, “Vêx ông let lec dɨ su ông su lec.” Om Pita vông bêge pyap dɨ angela nêl nang ên nêbê, “Vɨnyum ông ngakwi ngwe kɨsii lec dɨ lam tɨmu vô a.” ");
INSERT INTO ptp_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Om Pita kɨdi lec dɨ tɨmu vô angela vɨxa dɨ yuu la. Lêc Pita lungên wê angela dɨdii i vêl ên xumac kalabuhu nɨlô ge dɨ so nêb mêd yê vɨvia pɨleva. ");
INSERT INTO ptp_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Mêd yuu luu xêhɨpu wê tax ge vêl mɨ la, nang dɨ mɨla luu mahɨgun ngweo vêl mɨ la nang, dɨ yuu val vô vuayen ain ti wê ob sea xumac kalabuhu mɨ la vɨxun ge, lêc vuayen tyo, ici va tax om yuu lop mɨ la vɨxun, dɨ tup vô môp mɨ la mahɨgun ti lê, lêc lutibed angela sea Pita dɨ la. ");
INSERT INTO ptp_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Mêd Pita kɨnu mɨlax vac i dɨ i xovô ên nêbê, “Ga a xovô vɨxôhɨlôg ên a nêbê Apumtau vông angela tige lam kô a vêl ên Helot vɨgê dɨ vô a vêl ên nipaên wê he Yuda nêb ob vông vô a ge.” ");
INSERT INTO ptp_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Pita xovô pyap om loc mɨ la vô Malia wê Jon ta ge ben. Jon lê ngwe nêbê Mak. Xomxo tɨbeac kɨtucma dɨ kɨtaa vô Anutu mɨ dô, ");
INSERT INTO ptp_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","om Pita hi vɨgê lec vuayen dɨ vêx yuac ti lê nêbê Loda ngô om lam nêb ob tax vuayen. ");
INSERT INTO ptp_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Lêc ngô Pita vya dɨ xovô nêbê ge Pita om xêyaa vô nivɨha yang, lêc taxên vuayen ma dom tup mɨ lax nêl vô he wê dô vac xumac lôma ge ên nêbê Pita val le vɨxun. ");
INSERT INTO ptp_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Lêc he nêl vô ên nêbê, “Ge ông pɨyôp vô yacyac.” Lêc vêx tige nêl xêkɨzêc ên nêbê, “Pita vɨxôhɨlôg.” Lêc he nêl vô ên he nêbê, “Ge Pita kɨnu.” ");
INSERT INTO ptp_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Mêd Pita le vɨxun dɨ hi vɨgê lec vuayen lu lu om he la tax vuayen lêc yê Pita vɨxôhɨlôg om he yetac mabu. ");
INSERT INTO ptp_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Mêd Pita vông vɨgê vô he nêb he dô kɨyang maên, mêd nêl wê Apumtau kô i vêl ên xumac kalabuhu ge kɨtong vô he dɨ nêl ên nêbê, “Xam loc nêl a kɨtong vô Jems he lie vông vinên hɨxôn.” Mêd Pita sea he dɨ la vɨgwe bangwe. ");
INSERT INTO ptp_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Mêd vɨgwe vɨdii dɨ xêhɨpu he yê wê Pita xôa ma ge om he yetac dɨ nêl vôma ên nêbê, “Pita la na?” ");
INSERT INTO ptp_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Mêd Helot vông yuac lec myagên Pita lêc tulecên ma, om kɨnêg vô he xêhɨpu wê viac Pita ge lêc he lungên, om Helot nêl dɨ tɨbii hi he yib. Pyap mêd Helot sea vɨgwe Judia dɨ la dô Sisalia. ");
INSERT INTO ptp_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Helot xêyaa vô myavɨnê vô xomxo Taia yuu Saidon, om he Taia yuu Saidon kɨtuc la vô Helot ên nêb ob hi kɨyang tige yib, ên he mi kɨsuu xen yaên vac vɨgwe wê Helot viac ge. He la viac nên kɨyang tax vô Blastas wê mi viac Helot xumac ge. Pyap mêd he la kɨtaa Helot, nêb i hi kɨyang wê he vông ge i yib. ");
INSERT INTO ptp_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Mêd buc wê Helot tung ge od vunac ngakwi king lec dɨ la dô lec sia king dɨ nêl kɨyang vô he vɨhati. ");
INSERT INTO ptp_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Mêd he wê ngô kɨyang tige tyuc vya levac ên nêbê, “Ga o xomxo kɨbun ti vya lêm. Nge, vya ga tɨyi anutu vya.” ");
INSERT INTO ptp_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Lêc Helot yong i dɨ o pɨmil Anutu lêm, om lutibed Apumtau vông angela ti lam hi Helot ya myel vêê om ya i nɨlô ma vêl dɨ i yib. ");
INSERT INTO ptp_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Mêlêc Anutu xolac la vô levac vac vɨgwe tɨbeac. ");
INSERT INTO ptp_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Mêd Banabas yuu Sol la vông mone vô gyovɨxa Jelusalem, pyap dêc yuu kô Jon Mak dɨ yon lax mɨ la Antiok. ");
INSERT INTO ptp_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Vac konglegesen Antiok, xomxo wê plopete dɨ he wê tɨxuu xomxo ya xolac ge, he ya dô. He lê bêga nêbê Banabas yuu Simion wê lê ngwe nêbê ninɨvi vɨliac ge, dɨ Lusias wê lam gê Sailini ge yuu Maneyen wê gavman levac Helot nipɨpu ti ge, dɨ Sol. ");
INSERT INTO ptp_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Buc ti lêc xomxo vông vinên vɨhati ngɨbua yaên dɨ kɨtaa vô Apumtau mɨ dô lêc Myakɨlôhô Ngɨbua nêl vô he ên nêbê, “Xam vɨnoo Banabas yuu Sol ên yuu i loc vông yuac wê a ob vông vô yuu ge.” ");
INSERT INTO ptp_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Om he ngɨbua yaên dɨ kɨtaa vô Anutu, pyap dêc vyax vɨgê lec yuu dɨ vông yuu la. ");
INSERT INTO ptp_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Myakɨlôhô Ngɨbua vông Banabas yuu Sol la, om yuu la vɨgwe Selusia dɨ lec sip gê Selusia dɨ la vɨgwe kɨtôn Saiplas wê yêp vac gwec mahɨgun ge. ");
INSERT INTO ptp_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Vac vɨgwe Saiplas yuu la dô vɨgwe Salamis dɨ nêl Anutu xolac vac xumac lɨlo wê he Yuda vông ge vɨhati. Jon Mak dô hɨxôn yuu om ngɨdu yuu xôn vac yuac. ");
INSERT INTO ptp_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Mêd yon la tup vac vɨgwe nipwo vɨhati dɨ mɨla vɨgwe ti lê nêbê Pepos. Mêd yon tulec xomxo Yuda ti lê nêbê Ba-Jisas. Ba-Jisas ge plopet kɨtyooên ti wê mi vông vɨloo hɨxôn yevac ge, ");
INSERT INTO ptp_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","dɨ mi dô hɨxôn gavman levac ti lê nêbê Sesias Polas. Sesias Polas ge, xomxo wê xovôên nivɨha ge om keac Banabas yuu Sol la vô i ên nêb ob ngô Anutu xolac. ");
INSERT INTO ptp_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Lêc Ba-Jisas wê lê ngwe vac Glik vya nêbê Elimas ge nêl nipaên lec Banabas yuu Sol, ên nêb ob pɨlepac gavman levac tyo nɨlô ên i o lêc vông i vin Yesu lêm. ");
INSERT INTO ptp_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Lêc Sol wê lê ngwe nêbê Pol ge, Myakɨlôhô Ngɨbua hɨvun i xôn om Pol yê Elimas kɨzêc, ");
INSERT INTO ptp_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","dɨ nêl vô ên nêbê, “Ông Seten nu, ông vông vevac vô kɨyang nivɨha vɨhati, dɨ kɨyang kɨtyooên yuu nipaên pup lec ông nɨlôm. Ông juda Apumtau kɨyang tɨyi buc vɨhati. Obêc buc tina lêc ông sea kɨyang kɨtyooên wê ông mi nêl ge? ");
INSERT INTO ptp_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Om wê lê. Gwêbaga Apumtau obêc hi ông dɨ vông ông mamnôn i toc, dɨ ông wêên vɨgwe ob ma dɨ buc ya i loc vêl lê.” Pol nêl bêge mêd lutibed Elimas manôn vô mapɨtoc dɨ i vô pɨlax pɨlax vɨgwe dɨ myag xomxo wê ob hôm lec i vɨgê mɨ hɨlung môp vô i ge. ");
INSERT INTO ptp_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Gavman levac yê tige dɨ yetac ên Apumtau xolac dɨ vông i vin. ");
INSERT INTO ptp_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Pol hɨxôn xomxo wê mi la hɨxôn i ge lec sip gê Pepos dɨ la Pega vac vɨgwe Pampilia. Lêc Jon Mak sea he dɨ lax mɨ la Jelusalem. ");
INSERT INTO ptp_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Mêd he kɨdi vac Pega dɨ la Antiok wê yêp vac vɨgwe levac Pisidia ge. Dɨ buc sabat ge he la vac Yuda xumac lɨlo dɨ la dô. ");
INSERT INTO ptp_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Xomxo wê viac xumac lɨlo ge kɨtong xolac wê Moses he plopete kɨvuu ilage. Pyap dêc he nêl kɨyang la vô Pol yuu Banabas ên nêbê, “Lig muu, muu obêc nêb nêl kɨyang ya vô xe ên i ngɨdu xe xôn ge od muu nêl.” ");
INSERT INTO ptp_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Om Pol kɨdi lec dɨ vɨgê la kɨsii dɨ i nêl vô he ên nêbê, “Xam lige Islel hɨxôn xam tɨbii ba wê xam xona ên Anutu ge, xam ngô lê. ");
INSERT INTO ptp_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Anutu ti wê il Islel vông ge vɨnoo mage buge ilage, dɨ buc wê he la dô Isip tɨyi xocbê xomxo vɨtevac ge od Anutu vông he vô tɨbeac hɨwocên. Dɨ tɨmuên Anutu vɨgê xêkɨzêc dɨdii he vêl dɨ vông he la. ");
INSERT INTO ptp_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","He la dô vɨgwe mahɨgun pɨleva tɨyi klismas kehe yuu, lêc Anutu o kɨtya he vêl ên wê he pwoo i vya vac ge lêm. ");
INSERT INTO ptp_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Nang dêc Anutu kɨtya tɨbii vɨyang vɨgê vɨlu dɨ sec yuu wê dô vac vɨgwe Kenan ge vêl dɨ vông kɨbun tige vô he Islel mɨ he dô vac i tɨyi klismas 450. ");
INSERT INTO ptp_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Nang dêc Anutu vɨnoo Islel levac dɨ he viac lie dɨ i val tyip vô buc wê plopet Samyuel dô ge. ");
INSERT INTO ptp_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","“Lêc he Islel nêb he ob vɨnoo king wê ob viac he ge om Anutu vɨnoo Kis nu Sol wê kehe yêp vac Bensamin ge, dɨ i tu king mɨ viac he tɨyi klismas kehe yuu. ");
INSERT INTO ptp_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Lêc Anutu kɨtya Sol lê king vêl dɨ vông i la lec Devit. Anutu nêl lec Devit bêga ên nêbê, ‘A xê Jesi nu Devit dɨ a xêgyaa vin lec i, ên i ge xomxo wê ob vông yuac vɨhati tɨyi xocbê a nêl ge.’ ");
INSERT INTO ptp_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","“Mêd Anutu hɨlu kɨyang nêbê Devit bue paha ti obêc lam hôm xomxo Islel lec. Om Yesu lam vông kɨyang tyo vô nôn lec. ");
INSERT INTO ptp_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","“Dɨ buc wê Yesu gên o lam lêm ge, Jon nêl kɨyang vô he Islel vɨhati ên nêbê he i pɨlepac he dɨ lipac mia. ");
INSERT INTO ptp_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Vô kwabo lec wê Jon yuac ob pyap ge om Jon nêl ên nêbê, ‘Xam xovô ên xam nêb a letya? A o xomxo ti wê xam dô bin ge lêm. Xomxo ti obêc val tɨmuên, dɨ a o nivɨha wê a obêc pɨwelac su vêl ên i vɨxa ge lêm.’ ");
INSERT INTO ptp_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“Jon nêl bêge, om xam lige wê xam tu Eblaham nue gee hɨxôn xam tɨbii ba wê xam xona ên Anutu gee, xam ngô lê. Kɨyang wê Anutu nêl nêb ob hôm il lec ge, Anutu vông i lam pyap vô il. ");
INSERT INTO ptp_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Ên xomxo Jelusalem hɨxôn he nên xomxo levac, he o xovô Yesu lêm, dɨ he o xovô plopete kɨyang wê he mi kɨtong vô buc sabat ge kehe lêm. Om he vông kɨyang vô Yesu nêb ob hi i yib, lêc môp wê he vông ge vông plopete kɨyang vô nôn lec. ");
INSERT INTO ptp_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","He o tulec i nên nipaên ti lêm, lêc he kɨtaa Pailat ên nêb i hi i yib. ");
INSERT INTO ptp_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","He vông i tɨyi kɨyang vɨhati wê plopete kɨvuu lec Yesu ilage, nang dêc he kwax Yesu ninɨvi vêl ên xax pola dɨ kô mɨ la lii vac lôva. ");
INSERT INTO ptp_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Lêc Anutu tɨpi vô i kɨdi lec vac yibên ");
INSERT INTO ptp_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","dɨ buc tɨbeac Yesu hɨlung i vô he wê he mi la hɨxôn i gê Galili mɨ la Jelusalem ge. Dɨ gwêbaga xomxo tigee nêl Yesu kehe kɨtong vô lie Islel. ");
INSERT INTO ptp_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","“Om xe ob nêl xolac nivɨha vô xam bêga bê kɨyang wê Anutu hɨlu vô buge ilage, ");
INSERT INTO ptp_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Anutu vông kɨyang tige vô nôn lec vô he bue il, ên wê tɨpi vô Yesu kɨdi lec vac yibên ge. Tɨyi xocbê kɨyang wê yêp vac Sam ngwe wê vông yuu lec ge bêga nêbê, ‘Ông ge a nug ông, dɨ gwêbaga a vông ông lêm vô levac.’ ");
INSERT INTO ptp_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","“Anutu tɨpi vô Yesu kɨdi lec vac yibên om Yesu ob yib i tii vac mɨ ninɨvi pɨtal lêm, tɨyi xocbê kɨyang wê Anutu nêl ilage ên nêbê, ‘Vɨzid nivɨha wê a nêl vô Devit ge a ob vông i vô nôn lec vô xam.’ ");
INSERT INTO ptp_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","“Dɨ kɨyang ti yêp vac Sam ngwe bêga nêbê, ‘Ông ob sea num ngɨbua ninɨvi i loc pɨtal lêm.’ ");
INSERT INTO ptp_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","“Il xovô ên il nêbê Devit vông i tɨyi kɨyang wê Anutu nêl vô i vô buc wê dô mavɨha gê kɨbun ga ge, lêc yib dɨ he yev i hɨxôn mae bue dɨ i ninɨvi pɨtal. ");
INSERT INTO ptp_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Lêc xomxo ti wê Anutu tɨpi vô i kɨdi lec vac yibên ge ninɨvi o pɨtal lêm. ");
INSERT INTO ptp_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Om xam lige, xam vyac xovô kɨyang wê xe nêl vô xam bêga bê xomxo tige wê ob kɨtya xam nêm nipaên vêl. ");
INSERT INTO ptp_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Xolac wê Moses vông ilage o tɨyi wê ob kɨtya xam nêm nipaên vêl ge lêm. Lêc Yesu ge, xomxo ti obêc vông i vin i ge od Anutu obêc pɨwelac i vêl ên nipaên dɨ vông i dô nivɨha. ");
INSERT INTO ptp_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Om xam xona nêm dɨ viac xam, ên kɨyang wê plopete kɨvuu ilage i o lêc tulec xam lêm, kɨyang wê nêl bêga nêbê, ");
INSERT INTO ptp_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Xam wê xam so vyam vô Anutu kɨyang ge, xam wê dɨ yetac dɨ nga vɨgêm vac myam, lêc xam obêc wib mɨ la vac nipaên. Ên yuac ti wê a vông vô buc wê xam dô ge, xomxo obêc nêl kɨtong vô xam lêc xam ob vông i vin lêm.’” ");
INSERT INTO ptp_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Pol nêl kɨyang pyap dɨ yuu Banabas nêb ob la vɨxun, lêc xomxo kɨtaa yuu ên nêbê, “Muu lôm lec sabat ngwe tɨmuên ên lôm nêl kɨyang tige i tii vac.” ");
INSERT INTO ptp_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","He vɨhati lop mɨ la vɨxun, mêd he Yuda hɨxôn tɨbii wê vông i vin Anutu dɨ mi tɨmu vô Yuda môp gee he tɨbeac tɨmu vô Pol yuu Banabas vɨxa. Mêd yuu viac kɨyang vô he ên nêbê he i dô vac vɨzid wê Anutu vông ge. ");
INSERT INTO ptp_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Vô buc sabat ngwe tɨmuên xomxo wê dô vɨgwe tige vɨhati kɨtucma ên nêb ob ngô Anutu xolac. ");
INSERT INTO ptp_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Lêc he Yuda yê wê xomxo tɨbeac kɨtucma vô Pol yuu Banabas ge om he xêyaa vô nipaên vô yuu dɨ he so vya vô Pol hɨxôn xolac wê nêl ge. ");
INSERT INTO ptp_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Lêc Pol yuu Banabas xonaên ma dɨ yuu nêl kɨyang xêkɨzêc vô he ên nêbê, “Ge nivɨha wê xe nêl Anutu xolac vô xam Yuda taxlee, lêc xam vô nɨmim vô, om tɨyi xocbê xam nêl ên xam nêbê xam o tɨyi wê xam ob dô mamvɨha luta lêc luta ge lêm. Om xam ngô lê. Gwêbaga xe ob sea xam dɨ la vô tɨbii wê o Yuda lêm gee, ");
INSERT INTO ptp_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","ên Apumtau nêl vô xe ên nêbê, ‘A ob vông ông loc tɨyi xocbê ngwax wê ob linac vô he wê o Yuda lêm ge, dɨ ông ob hɨlung môp mavɨha dôên vô xomxo kɨbun ga vɨhati.’” ");
INSERT INTO ptp_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Xomxo wê o Yuda lêm gee ngô kɨyang wê Pol nêl ge dɨ he xêyaa vô nivɨha yang dɨ he pɨmil Apumtau xolac, mêd he wê Anutu vɨnoo he ên nêb he ob dô mavɨha luta lêc luta gee he vɨhati vông i vin. ");
INSERT INTO ptp_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Mêd Apumtau xolac la vô levac vac vɨgwe tigee vɨhati. ");
INSERT INTO ptp_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Lêc he Yuda vông vêx wê lê levac wê mi kɨtaa vô Anutu gee hɨxôn xomxo levac vac vɨgwe tigee he nɨlô kɨdi lec nêb ob hi Pol yuu Banabas, om he vông vɨyin vô yuu dɨ tii yuu la vêl ên he ben. ");
INSERT INTO ptp_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Om yuu lɨloo vɨjuva vêl ên vɨxa pɨtehe ên nêbê he i xovô bê he nên nipaên yêp vô he. Mêd yuu loc dɨ la vɨgwe Aikoniam. ");
INSERT INTO ptp_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Dɨ xomxo vông vinên wê dô Antiok gee he xêyaa vô nivɨha dɨ Myakɨlôhô Ngɨbua hɨvun he xôn. ");
INSERT INTO ptp_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Gê vɨgwe Aikoniam Pol yuu Banabas vông i tɨyi wê yuu vông gê Antiok ge. Om yuu la vac xumac lɨlo wê he Yuda vông ge dɨ nêl kɨyang hɨxôn xêkɨzêc, om Yuda hɨxôn tɨbii ba he tɨbeac vông i vin Yesu. ");
INSERT INTO ptp_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Lêc he Yuda wê o vông i vin lêm ge nêl kɨyang vaxvax lec xomxo vông vinên om vông tɨbii wê o Yuda lêm gee he xêyaa vô nipaên vô xomxo vông vinên. ");
INSERT INTO ptp_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Mêd Pol yuu Banabas dô Aikoniam buc dia tya dɨ nêl Apumtau xolac hɨxôn xêkɨzêc, dɨ Apumtau vông xêkɨzêc vô yuu tɨyi wê yuu ob vông do levac toto ya ge, ên nêbê xomxo i yê dɨ xovô bê kɨyang wê yuu nêl lec xêyaa vin lecên wê Apumtau vông ge, kɨyang nôn vɨxôhɨlôg. ");
INSERT INTO ptp_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Lêc xomxo wê dô vɨgwe tigee hɨbu he la yuu, vɨlu vông i vin he Yuda dɨ vɨlu vông i vin sinale. ");
INSERT INTO ptp_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Mêd he Yuda hɨxôn tɨbii ba kɨdi lec hɨxôn lie levac, ên nêb he ob vông vɨyin vô Pol yuu Banabas dɨ nêx yuu ya ngɨdax mɨ yuu i yib. ");
INSERT INTO ptp_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Lêc yuu ngô wê he nêb ob hi yuu ge om yuu pec mɨ la Listla yuu Debi wê yêp vac vɨgwe levac Likionia ge, dɨ la vɨgwe wê yêp kwabo ge ya hɨxôn. ");
INSERT INTO ptp_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Mêd yuu nêl xolac vac vɨgwe tigee vɨhati. ");
INSERT INTO ptp_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Xomxo vux ti dô vɨgwe Listla, lêc ta kô i dɨ vɨxa vô xêlehelehe dɨ o mi vɨlee ti lêm. Mi dô kɨzêc. ");
INSERT INTO ptp_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Mêd xomxo tyo ngô kɨyang wê Pol nêl ge mêd Pol yê i xêkɨzêc dɨ xovô nêbê tyo vông i vin tɨyi wê ob vông i vô nivɨha lec ge, ");
INSERT INTO ptp_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","om nêl vya levac ên nêbê, “Ông kɨdi lec mɨ le kɨsii.” Mêgem tyo kɨdi lec lutibed dɨ vɨlee mɨ la. ");
INSERT INTO ptp_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Tɨbii tɨbeac yê wê Pol vông xomxo tige vô nivɨha lec ge om he tyuc vac Likionia vya ên nêbê, “Anutu tu xomxo manôn dɨ lop mɨ lam vô il.” ");
INSERT INTO ptp_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Om he nêl he anutu kɨbun ga yuu lê lec Banabas yuu Pol, om nêl lê Sus lec Banabas dɨ nêl lê Hemis lec Pol, ên Pol ge wê mi nêl kɨyang tɨbeac. ");
INSERT INTO ptp_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Xumac ngɨbua wê Sus vông ge yêp kwabo vô vɨgwe tige nɨnya. Mêd xomxo wê mi si daa vô Sus ge ti la kô bwoc levac vux ya hɨxôn ngaola dɨ kô mɨ la vô vuayen ên xomxo nêb ob hi bwoc levac mɨ tung daa vô yuu. ");
INSERT INTO ptp_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Lêc Banabas yuu Pol ngô kɨyang tige om yuu nɨlô vɨyin dɨ yuu lêx ngakwi wê yuu vông ge sea dɨ tup mɨ la le vac xomxo mahɨgun dɨ nêl vya levac ên nêbê, ");
INSERT INTO ptp_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Xamê, bêna lêc xam vông môp tibêge? Xii ga xomxo kɨbun ga xocbê xam ge. Lêc xii lam ên xii nêb xii ob nêl kɨyang nivɨha vô xam bê xam sea susu nôn maên tige dɨ pɨlepac nɨlôm i loc vô Anutu mavɨha wê tung lag yuu kɨbun dɨ gwec hɨxôn susu vɨhati yang ge. ");
INSERT INTO ptp_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Vɨxôhɨlôg, vô buc ilage xomxo vac vɨgwe vɨhati vông i tɨyi xovôên wê heche va vông ge, dɨ Anutu o le vac xôn lêm. ");
INSERT INTO ptp_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Lêc Anutu o xôpac ên xomxo dɨ vông he lungên i lêm. Nge, vông môp nivɨha vô il, xocbê vông lun lam gê kɨsii dɨ vông yaên vô nôn tɨbeac, om vông yaên tɨyi xam dɨ vông xam xêmyaa vô nivɨha.” ");
INSERT INTO ptp_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Yuu nêl kɨyang tige vô he, lêc he vô xêkɨzêc nêb he ob tung daa vô yuu, om yuu nêl kɨyang tige tii vac vac om he o tung daa vô yuu lêm. ");
INSERT INTO ptp_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Mêd Yuda ya lam gê Antiok yuu Aikoniam dɨ val pɨlepac xomxo nɨlô om he nêx Pol ya ngɨdax dɨ dɨdii i mɨ la vɨgwe nɨnyawehe ên he xo ên he nêb Pol yib. ");
INSERT INTO ptp_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Lêc xomxo vông vinên val le ngɨvina Pol dɨ i kɨdi lec dɨ lax vɨyangtôv, dɨ vɨgwe vɨdiiên ge yuu Banabas la vɨgwe Debi. ");
INSERT INTO ptp_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Yuu nêl xolac vô tɨbii Debi dɨ he tɨbeac vông i vin. Pyap dêc yuu lax mɨ la Listla yuu Aikoniam dɨ Antiok tii vac nang. ");
INSERT INTO ptp_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Yuu ngɨdu xomxo vông vinên xôn ya kɨyang dɨ nêl kɨyang xêkɨzêc vô he ên nêbê, “Xam le xêkɨzêc vac vông vinên dɨ xam o lêc sea lêm. Il ob kô vɨyin tɨbeac tax êdêc la dô vac Anutu ben tɨmuên.” ");
INSERT INTO ptp_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Mêd vac vɨgwe vɨhati yuu vɨnoo gyovɨxa wê ob viac xomxo vông vinên ge mêd yuu ngɨbua yaên dɨ kɨtaa lec he vɨhati ên nêb Anutu ti wê he vông i vin ge i viac he. ");
INSERT INTO ptp_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Pol yuu Banabas la vɨlee vac vɨgwe Pisidia dɨ la vac vɨgwe levac Pampilia ");
INSERT INTO ptp_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","dɨ la nêl Anutu xolac vô tɨbii Pega. Pyap dêc loc mɨ la Atelia, ");
INSERT INTO ptp_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","dɨ lec sip dɨ lax mɨ la Antiok. Antiok ge wê ilage xomxo vông yuu vac Anutu vɨgê nêb i viac yuu dɨ yuu vông yuac. Mêd yuu vông yuac tyo pyap om yuu lax mɨ la Antiok. ");
INSERT INTO ptp_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Yuu val Antiok mêd kɨtuc xomxo vông vinên dɨ nêl yuac vɨhati wê Anutu ngɨdu yuu xôn ge kɨtong vô he dɨ nêl hɨxôn ên nêbê, “Gwêbaga Anutu vông tɨbii wê o Yuda lêm ge he ngô xolac hɨxôn dɨ vông i vin.” ");
INSERT INTO ptp_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Mêd yuu dô buc ya hɨxôn xomxo vông vinên tigee. ");
INSERT INTO ptp_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","He Yuda wê dô Judia gee he ya la Antiok dɨ la nêl vô xomxo vông vinên bêga nêbê, “Xam obêc gôl nimnɨvi tɨyi xolac wê Moses vông ilage lêm ge od o tɨyi wê Anutu ob kô xam lec ge lêm.” ");
INSERT INTO ptp_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","He nêl bêge lêc Pol yuu Banabas yê kɨyang tige tɨyiên ma om he ngaênma levac lec kɨyang tige. Om xomxo vông vinên vɨnoo Pol yuu Banabas hɨxôn xomxo ya ên nêb he i loc Jelusalem vô Yesu nue ngɨvihi yuu gyovɨxa ên he i tɨtô kɨyang wê he ngaênma lec ge. ");
INSERT INTO ptp_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Xomxo vông vinên vông he la, om he la môp Jelusalem dɨ la vac vɨgwe toto vac Pinisia yuu Samelia dɨ he nêl lec wê tɨbii wê o Yuda lêm gee tɨbeac pɨlepac nɨlô dɨ vông i vin Yesu ge kɨtong vô xomxo vông vinên, om he wê ngô kɨyang tige, he xêyaa vô nivɨha. ");
INSERT INTO ptp_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Mêd he mɨla tyip Jelusalem dɨ xomxo vông vinên hɨxôn Yesu nue ngɨvihi dɨ gyovɨxa, he kô Pol yuu Banabas he lie lec nivɨha. Mêd Pol yuu Banabas nêl yuac vɨhati wê yuu vông dɨ Anutu ngɨdu yuu xôn ge kɨtong vô he. ");
INSERT INTO ptp_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Lêc Palisi ya wê vông i vin Yesu ge he kɨdi lec dɨ nêl ên nêbê, “Xomxo vông vinên wê o Yuda lêm gee, xam gôl he ninɨvi dɨ nêl vô he bê he i tɨmu vô xolac wê Moses vông ge.” ");
INSERT INTO ptp_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Mêgem Yesu nue ngɨvihi hɨxôn gyovɨxa kɨtucma ên nêb ob viac kɨyang tige. ");
INSERT INTO ptp_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","He nêl kɨyang tɨbeac lec kɨyang tige, pyap dêc Pita kɨdi lec dɨ nêl vô he ên nêbê, “Xam lige, xam xovô pyap ên xam nêbê ilage Anutu vɨnoo a vac xam mahɨgun ên nêb a la nêl xolac vô tɨbii wê o Yuda lêm gee ên he i ngô dɨ vông i vin. ");
INSERT INTO ptp_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Mêd Anutu wê xovô il vɨhati nɨlôd ge vông Myakɨlôhô Ngɨbua vô he tɨyi xocbê vông vô il Yuda ilage. Om il xovô ên il nêbê Anutu yê he nivɨha. ");
INSERT INTO ptp_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Dɨ Anutu o vông môp bangwe vô il Yuda dɨ vông bangwe vô he tɨbii ba lêm. Nge, he vông i vin om Anutu vông he vô paha lec. ");
INSERT INTO ptp_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Dɨ bêna lêc xam nêb xam ob yaxên Anutu? Moses xolac vông vɨyin vô buge ilage dɨ il gwêbaga hɨxôn, dɨ il o tɨyi wê il ob kɨlê vɨyin tige lêm. Dɨ bêna lêc xam nêb xam ob lii vɨyin tige lec he wê o Yuda lêm ge hɨxônê? ");
INSERT INTO ptp_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Il vông i vin ên il nêbê xêyaa vin lecên wê Apumtau Yesu vông ge ob vông il dô madvɨha dɨ he êno ob dô mavɨha.” ");
INSERT INTO ptp_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Pita nêl bêge mêd Yesu nue ngɨvihi hɨxôn gyovɨxa dô kɨyang maên dɨ ngô kɨyang wê Pol yuu Banabas nêl ge, om yuu nêl lec do levac wê Anutu ngɨdu yuu xôn dɨ yuu la vông vac tɨbii madɨluhu ben ge. ");
INSERT INTO ptp_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Yuu nêl kɨyang pyap mêd Jems nêl ên nêbê, “Xam lige, xam ngô kɨyang wê a ob nêl ge. ");
INSERT INTO ptp_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Saimon Pita nêl vô xam gwêba ên nêbê taxlee Anutu xo tɨbii wê o Yuda lêm ge ên nêb ob vɨnoo he ya tu i nue. ");
INSERT INTO ptp_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Dɨ kɨyang wê he plopete kɨvuu ilage nêl kɨyang tige bêga nêbê, ");
INSERT INTO ptp_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘Apumtau nêl ên nêbê, “Tɨmuên ge a obêc vena, dɨ Devit xumac wê kɨpê ge a ob vena lox paha vac. Dɨ susu wê vô nipaên vac xumac ge, a ob viac vô i tii vac. ");
INSERT INTO ptp_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Om he wê o Yuda lêm ge, he ob vông yuac lec myagên Apumtau. He ge wê a vɨnoo he ên a nêb he i tu a nuge.” ");
INSERT INTO ptp_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Kɨyang tige Apumtau vya wê nêl ilage mɨ i yêp.’ ");
INSERT INTO ptp_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","“Mêgem xovôên wê a vông ge bêga nêbê il ob vông vɨyin tɨbeac vô tɨbii ba wê pɨlepac he ge lêm. ");
INSERT INTO ptp_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Lêc il ob kɨvuu kɨpihac i loc vô he bêga bê he i kol he ên yaên wê xomxo tung i tu daa vô anutu kɨtyooên ge, dɨ he i o lêc vông môp yôdac vêx yuu vux lêm, dɨ he i o ya lɨlii wê he ngɨbina kwa dɨ hi dô vac nɨlô ge lêm, dɨ he yaên hi i ma. ");
INSERT INTO ptp_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Ên kɨyang wê yêp vac Moses xolac ge, xomxo mi nêl xolac tige vac vɨgwe vɨhati dɨ xomxo mi kɨtong xolac tige vac xumac lɨlo tɨyi buc sabat vɨhati. Môp tige yêp ilage dɨ i val tyip lec gwêbaga hɨxôn.” ");
INSERT INTO ptp_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Mêgem Yesu nue ngɨvihi hɨxôn gyovɨxa hɨxôn xomxo vông vinên vɨhati nêb ob vɨnoo lie ya ên vông he i loc hɨxôn Pol yuu Banabas mɨ loc Antiok. Om he vɨnoo Judas wê lê ngwe nêbê Basabas ge yuu Sailas, ên yuu ge xomxo levac wê he Yuda vông ge. ");
INSERT INTO ptp_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Yuu kô kɨpihac wê Yesu nue ngɨvihi hɨxôn gyovɨxa kɨvuu bêga nêbê, “Yesu nue ngɨvihi hɨxôn gyovɨxa kɨvuu kɨpihac tiga dɨ vông i loc vô xam tɨbii Antiok yuu Silia dɨ Silisia wê xam vông i vin Yesu gee. ");
INSERT INTO ptp_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Xe ngô wê xomxo ya kɨdi vac xe mahɨgun dɨ loc juda xam nɨlôm ya kɨyang dɨ vông xam nɨlôm vô vɨyin. Lêc xe o vông he loc vô xam lêm. ");
INSERT INTO ptp_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Mêgem xe kɨtucma dɨ hɨlu kɨyang bêga ên xe nêbê xe ob vɨnoo xomxo yuu i loc vô xam hɨxôn il lig Pol yuu Banabas wê xe xêmyaa vin lec yuu ge. ");
INSERT INTO ptp_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Pol yuu Banabas o xona ên wê xomxo nêb ob hi yuu yib lec Yesu Kɨlisi lê ge lêm. ");
INSERT INTO ptp_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Om xe vông Judas yuu Sailas loc vô xam dɨ yuu ob nêl kɨyang tiga hɨxôn vô xam. ");
INSERT INTO ptp_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Myakɨlôhô Ngɨbua dô hɨxôn xe dɨ xe hɨlu kɨyang bêga ên xe nêbê xe ob vông vɨyin tɨbeac vô xam lêm. Dom môp wê xam ob tɨmu vô ge bêga bê ");
INSERT INTO ptp_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","xam kol xam ên susu yaên wê xomxo kô mɨ la tung i tu daa vô anutu kɨtyooên ge, dɨ xam waên hi i ma, dɨ xam o wa lɨlii wê xomxo ngɨbina kwa dɨ hi dô vac nɨlô ge lêm, dɨ xam o lêc vông yôdac vêx yuu vux lêm. Xam obêc sea môp nipaên tigee, od obêc nivɨha. Vɨdiiên xam. Xam dô nivɨha.” ");
INSERT INTO ptp_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Mêd xomxo vông vinên vông he la mêd he mɨla Antiok dɨ kɨtuc xomxo vông vinên vɨhati dɨ vông kɨpihac tyo vô he. ");
INSERT INTO ptp_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","He kɨtong kɨpihac pyap dɨ he xêyaa vô nivɨha ên kɨyang nivɨha wê yêp vac kɨpihac ge. ");
INSERT INTO ptp_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Judas yuu Sailas ge plopete yuu om yuu nêl kɨyang tɨbeac mangwe vô he ên nêb i ngɨdu he xôn dɨ he i vông i vin xêkɨzêc. ");
INSERT INTO ptp_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Mêd Judas yuu Sailas dô Antiok buc dia hɨxôn he. Pyap dêc lie Antiok nêl kɨyang nivɨha vô yuu dɨ vông yuu lax vô he Jelusalem wê vông yuu lam ge. ");
INSERT INTO ptp_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Lêc Sailas nêb ob dô Antiok om dô. ");
INSERT INTO ptp_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Mêd Pol yuu Banabas dô Antiok, dɨ yuu hɨxôn xomxo tɨbeac mangwe nêl Apumtau xolac kɨtong vô he Antiok. ");
INSERT INTO ptp_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Buc ya la vêl dɨ Pol nêl vô Banabas ên nêbê “U ob lax mɨ la vô lige wê u la nêl Apumtau xolac vac he ben ilage, dɨ tup vac he mɨ xê bêc he dô nivɨha, me?” ");
INSERT INTO ptp_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Mêd Banabas nêb Jon Mak i loc hɨxôn yuu, ");
INSERT INTO ptp_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","lêc Pol nêl ên nêbê, “Jon Mak sea u gê Pampilia ilage dɨ o vông yuac ti hɨxôn u lêm, om ob la hɨxôn u lêm.” ");
INSERT INTO ptp_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Om yuu nêlma lec kɨyang tige dɨ seama, om Banabas kô Mak dɨ yuu lec sip mɨ la vɨgwe Saiplas, ");
INSERT INTO ptp_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","dɨ Pol kô Sailas ên nêb yuu ob la, om lie vông vinên vông yuu vac Apumtau vɨgê ên nêb i viac yuu. ");
INSERT INTO ptp_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Mêd yuu la vac vɨgwe Silia yuu Silisia vɨhati dɨ ngɨdu xomxo vông vinên xôn. ");
INSERT INTO ptp_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Pol kɨdi vac Antiok dɨ la Debi yuu Listla mɨ la tulec xomxo vông vinên ti lê nêbê Timoti. Timoti ta ge vêx Yuda ti wê vông i vin Yesu ge, dɨ ma ge tɨbii Glik ti. ");
INSERT INTO ptp_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Mêd Timoti lie vông vinên vac vɨgwe Listla yuu Aikoniam gee nêl i kɨtong nêbê i xomxo nivɨha. ");
INSERT INTO ptp_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Mêgem Pol nêb Timoti i loc hɨxôn i om kô Timoti mɨ la gôl ninɨvi tɨyi môp wê he Yuda vông ge. Pol xo he Yuda dɨ vông môp tige, ên he Yuda vac vɨgwe tigee vɨhati, he xovô wê Timoti ma ge tɨbii Glik. ");
INSERT INTO ptp_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Mêd he la tup vac vɨgwe vɨhati dɨ nêl kɨyang wê Yesu nue ngɨvihi hɨxôn gyovɨxa hɨlu gê Jelusalem ge kɨtong vô xomxo vông vinên ên nêb he i tɨmu vô. ");
INSERT INTO ptp_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Om xomxo vông vinên vac konglegesen vɨhati vông i vin xêkɨzêc dɨ naba levac wê he vông ge le lec mɨ la kɨsii tɨyi buc vɨhati. ");
INSERT INTO ptp_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Myakɨlôhô Ngɨbua le vac he xôn ên nêb he i o nêl xolac vô tɨbii Esia lêm, om he la tup vac vɨgwe Plisia yuu Galesia. ");
INSERT INTO ptp_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Mêd he mɨla vɨgwe Misia dɨ xo nêb he ob la vɨgwe Bitinia, lêc Myakɨlôhô Ngɨbua wê Yesu vông ge le vac he xôn nêb he locên Bitinia i ma. ");
INSERT INTO ptp_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Mêgem he luu Misia vêl dɨ la Tloas. ");
INSERT INTO ptp_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Mêd vô bucên tige Pol yê vɨvia ti nêbê xomxo Masedonia ti le kɨsii dɨ kɨtaa i ên nêbê, “Ông sox lam Masedonia ên lam hôm xe lec.” ");
INSERT INTO ptp_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Pol yê vɨvia tige pyap mêd lutibed a, Luk, hɨxôn he, xe myag môp wê xe ob la Masedonia ge, ên xe xovô ên xe nêbê Anutu keac xe ên nêb xe la nêl xolac vô tɨbii vɨyang tiganê. ");
INSERT INTO ptp_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Mêgem xe lec sip gê Tloas dɨ la bôbac vô vɨgwe Samotles. Mêd xe xêp dɨ vɨdiiên xe kô sip mɨ la Niapolis. ");
INSERT INTO ptp_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Mêd xe sea Niapolis dɨ mɨla vɨgwe levac Pilipai wê yêp vac vɨgwe levac Masedonia ge. Vɨgwe tige tɨbii Lom viac. Xe dô vɨgwe tige buc ya, ");
INSERT INTO ptp_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","dɨ buc sabat xe sea vɨgwe nɨlô dɨ mɨla vô mia ên xe xo ên xe nêb mêd vɨgwe wê xomxo mi kɨtaa lec ge yêp vô mia tige. Mêgem xe mɨla vô vêx ya wê kɨtucma mɨ xeedô ge, om xe la dô hɨxôn he dɨ nêl xolac vô he. ");
INSERT INTO ptp_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Vêx ti lê nêbê Lidia ngô kɨyang tige. Lidia lam gê vɨgwe Taiataila dɨ mi vông yuac bisnis lec nivɨmihi hi. Lidia mi kɨtaa vô Anutu dɨ Apumtau pɨlepac i nɨlô dɨ i vô nɨnya vô kɨyang wê Pol nêl ge. ");
INSERT INTO ptp_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Mêd Lidia hɨxôn xomxo wê mi dô hɨxôn i ge he vɨhati lipac mia. Mêd Lidia nêl vô xe ên nêbê, “Xam obêc wê bêc a vông i vin Apumtau nôn ge od xam lam dô vac a bog.” Nêl kɨyang xêkɨzêc vô xe om xe la dô hɨxôn i. ");
INSERT INTO ptp_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Buc ti xe nêb xe ob la vɨgwe ti wê xomxo mi kɨtaa vac ge, lêc xe mɨla tulec vêx yuac ti vac môp. Vêx tige, vɨmwo nipaên dô vac nɨlô dɨ nêl kɨyang vɨhati kɨtong om xomxo wê vêx tige vông yuac vô he ge, he kô mone levac lec kɨyang wê vêx tige mi nêl ge. ");
INSERT INTO ptp_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Mêd vêx tige tɨmu vô xe hɨxôn Pol vɨxam dɨ tyuc ên nêbê, “Tɨbii tigae, Anutu ti wê luu baba vêl ge nue yuac, om he lam nêl môp wê Anutu ob vô xam vêl ên nipaên ge kɨtong vô xam.” ");
INSERT INTO ptp_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Vêx tyo nêl kɨyang tibêge tɨyi buc tɨbeac om Pol ni nyag vô i dɨ pop dɨ nêl vô vɨmwo nipaên ên nêbê, “A nêl lec Yesu Kɨlisi lê bêga bê ông lop mɨ loc vêl ên vêx tige.” Mêgem lutibed vɨmwo nipaên lop mɨ la vêl ên vêx tige. ");
INSERT INTO ptp_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Mêd xomxo levac wê vêx tige vông yuac vô he ge he yê dɨ xovô nêbê he ob kô mone ti tii vac lêm, om he hôm Pol yuu Sailas xôn dɨ kô yuu mɨ la vô xomxo levac vac vɨgwe wê he mi kɨtucma vac ge. ");
INSERT INTO ptp_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","He kô yuu mɨ la vô gavman levac manôn dɨ nêl vô he ên nêbê, “Xomxo yuu ga, Yuda yuu. Yuu lam il bed ga nêb ob vông il vô nipaên. ");
INSERT INTO ptp_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Om yuu nêl kɨyang ya lec môp wê gavman vɨbu ên nêb il Lom ob tɨmu vô lêm ge.” ");
INSERT INTO ptp_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Mêd tɨbii wê lam kɨtucma gee vɨhati so vya vô Pol yuu Sailas, dɨ gavman levac tigee lêx yuu nên ngakwi dɨ nêl ên nêb xomxo i pɨsa yuu. ");
INSERT INTO ptp_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Mêd he hi yuu mɨ yuu kô myavɨnê levac, pyap dêc vông yuu la vac xumac kalabuhu dɨ nêl xêkɨzêc vô xomxo ti wê mi viac xumac kalabuhu ge ên nêb i yê yuu xôn. ");
INSERT INTO ptp_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Mêd xomxo tige ngô kɨyang wê he nêl xêkɨzêc vô i ge, om kô yuu mɨ la tung vac xumac nɨlô wê yêp mahɨgun ge dɨ ving yuu vɨxa xôn ya plang. ");
INSERT INTO ptp_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Vô vɨvuaên mahɨgun Pol yuu Sailas kɨtaa dɨ vông lɨlo vô Anutu, dɨ tɨbii vɨhati wê dô vac xumac kalabuhu gee he ngô hɨxôn. ");
INSERT INTO ptp_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Lêc lutibed ngɨyêg levac ti val dɨ xumac kalabuhu yoc, dɨ lutibed vuayen vɨhati tax dɨ sen wê dô lec tɨbii kalabuhu vɨgê gee tul vêl ên he. ");
INSERT INTO ptp_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Om tɨbii ti wê viac xumac kalabuhu ge kɨdi lec, lêc yê wê vuayen vɨhati tax mɨ la le myadongên ge, dɨ xo ên nêbê tɨbii kalabuhu pec mɨ la, om loc hôm yipac nêb ob hi ici va yib. ");
INSERT INTO ptp_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Lêc Pol keac vya levac vô i ên nêbê, “Hiên ông i ma, ên xe vɨhati dô.” ");
INSERT INTO ptp_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Om xomxo tyo keac dɨ he dii ngwax mɨ lam, dɨ i tup mɨ la vô Pol yuu Sailas vac xumac lôma dɨ la yev vɨxa kɨtu vô yuu hɨxôn ni yetacên. ");
INSERT INTO ptp_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Mêd kô yuu mɨ la vɨxun dɨ kɨnêg vô yuu ên nêbê, “Xomxo levac muue, a ob vông bêna êdêc Anutu i hôm a lec?” ");
INSERT INTO ptp_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Om yuu nêl lax vô i ên nêbê, “Ông vông i vin Apumtau Yesu dɨ Anutu ob hôm ông lec hɨxôn vɨnême nume.” ");
INSERT INTO ptp_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Mêd yuu nêl Apumtau xolac vô xomxo tige hɨxôn xomxo vɨhati wê mi dô vac i ben gee. ");
INSERT INTO ptp_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Vô buc tibed tige xomxo tige kô yuu mɨ la lipac yuu ninɨvi wê tɨbii hi i vô kɨtyax ge. Dɨ Pol yuu Sailas lipac xomxo tige hɨxôn vɨnê nue vɨhati. ");
INSERT INTO ptp_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Pyap dêc xomxo tyo kô yuu mɨ la vac ben xumac lôma dɨ la vông yaên vô yuu, dɨ he vɨnê nue vɨhati xêyaa vô nivɨha ên wê he vông i vin Anutu ge. ");
INSERT INTO ptp_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Vɨgwe vɨdiiên tɨtige gavman levac vông nue xêhɨpu val dɨ he nêl ên nêbê, “Ông pɨwelac xomxo yuu ge dɨ vông yuu i loc.” ");
INSERT INTO ptp_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Om xomxo wê viac xumac kalabuhu ge la nêl vô Pol ên nêbê, “Gavman levac vông kɨyang lam ên nêbê muu loc, om muu loc hɨxôn xêmyaa nivɨha.” ");
INSERT INTO ptp_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Lêc Pol la nêl vô xêhɨpu ên nêbê, “Xii ga tɨbii Lom yuu, lêc he hi xii vô xomxo tɨbeac manôn dɨ vông xii la dô vac kalabuhu vɨdaaên. Dɨ he o tulec soên wê xii vông ge ti lêm, dɨ gwêbaga he nêb he ob vông xii la kɨyang maên. Ge o tɨyi lêm. Om heche va i lam kô xii mɨ loc.” ");
INSERT INTO ptp_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Mêd xêhɨpu lax nêl kɨyang tige vô gavman levace om he ngô dɨ xona mabu ên bo ti wê nêl ên nêbê yuu ge tɨbii Lom yuu. ");
INSERT INTO ptp_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Om he la nêl kɨyang malehe vô yuu ên nêbê, “Xe vông i so vô muu,” mêd kô yuu mɨ he la vɨxun dɨ nêl vô yuu ên nêbê, “Muu sea vɨgwe ga dɨ loc.” ");
INSERT INTO ptp_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Pol yuu Sailas sea kalabuhu dɨ la vac xumac Lidia vông, dɨ yuu yê lie vông vinên dɨ nêl kɨyang wê ob ngɨdu he xôn ge ya vô he, pyap dɨ yuu la. ");
INSERT INTO ptp_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Pol yuu Sailas sea vɨgwe Pilipai dɨ la vɨgwe Ampipolis dɨ la vɨgwe Apolonia. Nang dɨ yuu mɨla vɨgwe Tesalonaika. Xumac lɨlo wê he Yuda vông ge ti le vac vɨgwe tige, ");
INSERT INTO ptp_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","om Pol la vac xumac tige tɨyi xocbê mi la vac ya ilage, om la vac xumac tige lu yon lec buc sabat dɨ he Yuda nêlma lec kɨyang wê yêp vac kɨpihac xolac ge. ");
INSERT INTO ptp_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Mêd Pol nêl xolac kehe kɨtong vô he dɨ nêl ên nêbê, “Kɨlisi ti wê xam dô bin ge, Anutu tyuc lec nêb ob kô myavɨnê dɨ yib dɨ kɨdi lec mavɨha vac yibên. Om Yesu wê a nêl i kɨtong vô xam gwêbaga ge, ge Kɨlisi tyo tige.” ");
INSERT INTO ptp_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Mêd xomxo wê ngô kɨyang gee he ya vông i vin kɨyang wê Pol nêl ge om he tɨmu vô Pol yuu Sailas vɨxa, dɨ tɨbii Glik wê mi kɨtaa vô Anutu gee hɨxôn tɨbii levac vɨnêe, he tɨbeac vông i vin hɨxôn. ");
INSERT INTO ptp_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Lêc he Yuda xêyaa vô myavɨnê vô yuu om he la kô tɨbii nipaên wê mi dô vax vac vɨgwe tigee mêd he kɨtuc xomxo tɨbeac dɨ he xôn vông nidɨdun levac vac vɨgwe Tesalonaika, dɨ la ka bua ên xumac wê Jeson vông dɨ myag Pol yuu Sailas ên nêb ob kô yuu mɨ la vô xomxo levac. ");
INSERT INTO ptp_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Lêc he o yêvô yuu lêm, om he dɨdii Jeson hɨxôn lie vông vinên ya mɨ la vô gavman levac wê viac vɨgwe Tesalonaika ge, dɨ nêl vô he ên nêbê, “Xomxo yuu wê la vac vɨgwe vɨhati mɨ la vông xomxo vô nipaên ge yuu val dô ga vac il bed. ");
INSERT INTO ptp_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Dɨ Jeson ga kô yuu mɨ la vac i ben dɨ he pwoo king Sisa kɨyang vac dɨ nêl ên nêbê king ngwe dô lê nêbê Yesu.” ");
INSERT INTO ptp_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Mêd gavman levac hɨxôn xomxo vɨhati ngô kɨyang tige dɨ yetac mabu. ");
INSERT INTO ptp_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Mêd he nêl vô Jeson he lie ên nêb he i kɨsuu kot, pyap dɨ he la. ");
INSERT INTO ptp_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Vô bucên tige xomxo vông vinên vông Pol yuu Sailas la, dɨ yuu la vɨgwe Belia. Yuu mɨla Belia mêd la vac xumac lɨlo wê he Yuda vông ge. ");
INSERT INTO ptp_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","He Yuda wê dô Belia gee he vô nɨnya lehe vô xolac luu Yuda wê dô Tesalonaika gee vêl, om he hôm kɨyang wê yuu nêl ge lec nivɨha dɨ he mi kɨtong kɨyang wê yêp vac kɨpihac xolac ge tɨyi lec buc vɨhati ên nêb ob xovô bê kɨyang wê yuu nêl ge, ge kɨyang nôn, me? ");
INSERT INTO ptp_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Mêgem he Yuda tɨbeac, he vông i vin, dɨ Glik levac wê dô hɨxôn he gee, vêx yuu xôn vux tɨbeac vông i vin hɨxôn. ");
INSERT INTO ptp_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Lêc he Yuda wê dô Tesalonaika gee ngô wê Pol la nêl Anutu xolac gê Belia ge, om he la Belia dɨ la nêl kɨyang vaxvax ya vô he Belia om vông he yetac dɨ xêyaa vô myavɨnê vô Pol. ");
INSERT INTO ptp_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Om lutibed xomxo vông vinên vông Pol la gwec nɨnya dɨ Sailas yuu Timoti dô Belia. ");
INSERT INTO ptp_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Mêd xomxo wê la hɨxôn Pol ge kô i mɨ la Atens, pyap dɨ he lax mɨ la ben Belia, lêc Pol vông kɨyang vô he nêbê Sailas yuu Timoti i loc lutibed vô i. ");
INSERT INTO ptp_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Pol dô bin Sailas yuu Timoti gê Atens, lêc yê wê anutu kɨtyooên tɨbeac dô vac vɨgwe tige om vông i nɨlô vô vɨyin. ");
INSERT INTO ptp_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Mêgem Pol la vac xumac lɨlo wê he Yuda vông ge dɨ he Yuda hɨxôn tɨbii ba wê vông i vin Anutu ge, he Pol nêlma lec xolac. Dɨ buc vɨhati Pol la nêl kɨyang vô xomxo wê kɨtucma mɨ dô lec wetôv ge. ");
INSERT INTO ptp_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Om tɨbii wê vông i vin kɨyang ti nêbê Epikulian ge hɨxôn he wê vông i vin kɨyang wê nêbê Stoik ge he Pol ngaênma lec kɨyang, dɨ he ya nêl lec Pol ên nêbê, “Xomxo ti wê nêl kɨyang vaxvax ge nêb ob nêl kɨyang vatya vô ilê?” Dɨ he ya nêl ên nêbê, “Mêd ob nêl kɨyang lec anutu wê xomxo ya vông.” He nêl bêge, ên he ngô xolac wê Pol nêl lec Yesu wê kɨdi lec vac yibên ge. ");
INSERT INTO ptp_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Om he kô Pol mɨ la vô kaunsil wê mi kɨtucma lec kɨtôn Aliopagas ge, dɨ he nêl vô Pol ên nêbê, “Xe ob ngô kɨyang paha wê ông nêl vô xomxo ya ge. ");
INSERT INTO ptp_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Ên kɨyang wê ông nêl ge, xe ngô dɨ yaxên lêc ge kɨyang ba ti wê xe lungên ge, om ông nêl kɨyang tyo kehe kɨtong ên xe ngô.” ");
INSERT INTO ptp_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Tɨbii Atens hɨxôn tɨbii wê la dô hɨxôn he gee, he mi kɨtucma tɨyi buc vɨhati ên he nêb he ob ngô kɨyang paha dɨ nêl kɨyang paha. Dɨ he o vông yuac ti hɨxôn lêm. Nge, he dô vac môp tige tibed. ");
INSERT INTO ptp_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Om Pol kɨdi mɨ la le vac he kaunsil mahɨgun dɨ nêl vô he ên nêbê, “Xam tɨbii Atens. A xê wê xam vông yuac levac lec kɨtaaên vô anutu ya, ");
INSERT INTO ptp_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","ên a tup vac vɨgwe wê xam vông ge dɨ a xê anutu wê xam mi kɨtaa vô ge, dɨ a xê alta ti wê kɨyang yêp lec bêga nêbê, ‘Alta tiga anutu wê xe lungên ge, ixe.’ Om Anutu tige wê xam lungên lêc xam mi kɨtaa vô ge, a ob nêl i kɨtong vô xam. ");
INSERT INTO ptp_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","“Anutu tige wê tung kɨbun hɨxôn susu vɨhati yang, dɨ i ge Apumtau wê viac lag yuu kɨbun om ob dô vac xumac wê xomxo lox ya vɨgê ge lêm. ");
INSERT INTO ptp_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Anutu ge, susu ti o ma ên i lêm, dɨ xomxo ti ob vông yuac ên ngɨdu i xôn lêm. Ên ici va vông myakɨlôhô hɨxôn mavɨha vô xomxo dɨ vông susu tɨbeac vô he. ");
INSERT INTO ptp_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Taxlee Anutu tung xomxo tibed dɨ xomxo vô tɨbeac lec, mêd Anutu vông mɨ he dô lec kɨbun ga kɨdu kɨdu dɨ ici va vông buc vô he dɨ vông yôg vac kɨbun wê he ob dô lec ge. ");
INSERT INTO ptp_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Anutu nêb xomxo vɨhati i vông yuac lec myagên i ên he obêc tulec i. Lêc Anutu o dô teva ên il lêm. ");
INSERT INTO ptp_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Anutu ge wê vông xêkɨzêc vô il dɨ il dô madvɨha dɨ il vɨlee mɨ la dɨ lôm. Tɨyi xocbê xam lime wê pɨyôp levac ge nêl ên nêbê, ‘Il vɨhati tu i nue.’ ");
INSERT INTO ptp_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Il ga Anutu nue om il ob nêl bê Anutu ge tɨyi xocbê susu wê xomxo vaci pɨyôp xovô, dɨ he tɨxuu lec gol yuu silva dɨ ngɨdax ge lêm. ");
INSERT INTO ptp_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Ilage xomxo o xovô Anutu lêm, lêc Anutu o nêl kɨyang ti lec he lêm. Lêc gwêbaga Anutu nêl kɨyang vô xomxo vac vɨgwe vɨhati ên nêbê he i pɨlepac he. ");
INSERT INTO ptp_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Ên Anutu vɨnoo buc ti pyap, om obêc yaxên xomxo vɨhati nên kɨyang i yêp bôbac vô buc tige. Anutu vông yuac tige vac xomxo ti vɨgê om tɨpi vô xomxo tyo kɨdi lec mavɨha vac yibên, ên nêbê xomxo vɨhati i xovô bê Anutu vɨnoo xomxo tige vɨxôhɨlôg.” ");
INSERT INTO ptp_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Xomxo tigee ngô kɨyang wê Pol nêl lec xomxo ti wê kɨdi lec mavɨha vac yibên ge, om he ya nêl kɨyang manôn nipaên ya lec Pol, lêc he ya nêl ên nêbê, “Buc ti xe ob ngô kɨyang tige i tii vac nang.” ");
INSERT INTO ptp_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Pyap dêc Pol sea he dɨ la. ");
INSERT INTO ptp_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Lêc xomxo ya vông i vin kɨyang wê Pol nêl ge dɨ tɨmu vô i vɨxa. He wê vông i vin ge ti lê nêbê Daionisias wê kaunsil vac vɨgwe Aliopagas ge ti, yuu vêx ngwe lê nêbê Damalis, dɨ xomxo ya hɨxôn. ");
INSERT INTO ptp_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Pol sea Atens dɨ la Kolin, ");
INSERT INTO ptp_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","dɨ mɨla tulec Yuda vux ti lê nêbê Akwila wê ben kehe Pontas ge. Ilage Akwila yuu vɨnê Plisila dô Lom wê yêp vac vɨgwe levac Itali ge, lêc king Klodias nêl ên nêbê he Yuda he i sea Lom. Om yuu sea Lom dɨ la dô Kolin. Buc ya lam la vêl dɨ Pol mɨla vô yuu, ");
INSERT INTO ptp_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","lêc yê yuac wê yuu vông ge tɨyi xocbê yuac wê i vông ge, om la dô hɨxônyuu dɨ yon duu xumac sel dɨ tɨbii kɨsuu. ");
INSERT INTO ptp_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Mêd buc sabat vɨhati Pol la vac xumac lɨlo wê he Yuda vông ge mɨ la nêl kɨyang tɨbeac vô he, ên nêb he Yuda hɨxôn tɨbii ba he i vông nɨlô i loc vô Yesu dɨ vông i vin. ");
INSERT INTO ptp_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Mêd Sailas yuu Timoti lam gê Masedonia dɨ val vô Pol, dɨ Pol nêl xolac vô he Yuda tɨyi lec buc vɨhati dɨ nêl vô he ên nêbê, “Yesu ge Kɨlisi wê Anutu vɨnoo i pyap ge.” ");
INSERT INTO ptp_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Lêc he Yuda pwoo Pol vya vac dɨ so vya vô i om Pol lɨloo vɨjuva vêl ên ngakwi wê i vông ge ên nêbê he i xovô nên nipaên wê he vông ge, dɨ nêl vô he ên nêbê, “Xam obêc wib mɨ la vac nipaên ge od ge myavɨwen wê xacxam va vông, ên a o vông nipaên ti vô xam lêm. Om gwêbaga a ob sea xam dɨ la nêl xolac vô tɨbii madɨluhu wê o Yuda lêm gee.” ");
INSERT INTO ptp_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Mêgem Pol sea he mɨ la dô vac tɨbii ti ben lê nêbê Tisias Jastas. Tisias ge mi kɨtaa vô Anutu, dɨ i xumac le kwabo vô xumac lɨlo wê he Yuda vông ge. ");
INSERT INTO ptp_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Dɨ xomxo levac ti wê mi viac he Yuda xumac lɨlo ge lê nêbê Klispas hɨxôn vɨnêe nue vông i vin Apumtau, dɨ tɨbii Kolin tɨbeac ngô xolac wê Pol nêl ge dɨ vông i vin dɨ lipac mia. ");
INSERT INTO ptp_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Vô bucên ti Anutu vông vɨvia ti lam vô Pol bêga nêbê, “Xonaên i ma. Ông nêl xolac dɨ le i o dô xôa maên lêm. ");
INSERT INTO ptp_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Ên a dô hɨxôn ông, om xomxo ti o tɨyi wê ob vông ông vô nipaên ge lêm, ên xomxo wê tu a nuge ge tɨbeac dô vac vɨgwe tiga.” ");
INSERT INTO ptp_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Om Pol dô Kolin tɨyi klismas ti dɨ dentuc vɨgê vɨlu dɨ sec ti, dɨ tɨxuu tɨbii Kolin ya Anutu xolac. ");
INSERT INTO ptp_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Vô buc wê Galio tu gavman levac dɨ viac vɨgwe Glik ge he Yuda tɨbeac kɨtucma dɨ la hôm Pol xôn dɨ kô mɨ la vông kɨyang vô ");
INSERT INTO ptp_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","dɨ nêl ên nêbê, “Xomxo tiga tɨxuu xomxo lec môp kɨtaaên lê, lêc la môp bangwe dɨ o tɨyi xocbê xolac wê xe vông ge lêm.” ");
INSERT INTO ptp_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Mêd Pol nêb ob nêl kɨyang, lêc gavman levac Galio nêl vô he Yuda ên nêbê, “Xam Yuda, xomxo tiga obêc pwoo kɨyang wê gavman vông ge vac, me obêc vông môp nipaên ya ge od a ob ngô kɨyang wê xam nêl ge. ");
INSERT INTO ptp_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Lêc xam lam kɨnêg a lec kɨyang hɨxôn lê dɨ xolac wê xacxam va vông ge, om xacxam va kô xam kɨyang mɨ loc viac, ên a ob ngô kɨyang tibêge lêm.” ");
INSERT INTO ptp_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Mêd Galio tii he vêl ên kot, ");
INSERT INTO ptp_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","dɨ he la hôm xomxo levac wê mi viac Yuda xumac lɨlo ge ti lê nêbê Sostenis xôn dɨ kô mɨ la hi vô gavman levac Galio manôn dɨ Galio yê lêc o nêl kɨyang ti lec lêm. ");
INSERT INTO ptp_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Pol dô Kolin buc ya, nang dêc sea xomxo vông vinên tigee, dɨ Pol hɨxôn Plisila yuu Akwila yon la Senklia ên nêb ob lec sip mɨ la Silia. Gê Senklia Pol hɨlu kɨyang ti vô Anutu om kɨping bazub lihi. ");
INSERT INTO ptp_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Yon mɨla Epesas, dɨ Pol sea yuu dô dɨ la vac xumac lɨlo wê he Yuda vông ge dɨ la nêl kɨyang vô he. ");
INSERT INTO ptp_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Mêd he nêl vô Pol ên nêb i dô hɨxôn he buc ya, lêc Pol nêl nêb ob la. ");
INSERT INTO ptp_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Om buc wê ob sea he ge od nêl vô he ên nêbê, “Anutu obêc tyuc lec ge od a obêc vena vô xam tii vac.” Pyap dɨ Pol sea he dɨ la lec sip mɨ la. ");
INSERT INTO ptp_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","La lec sip mɨ la Sisalia, lêc sip mɨla le dɨ i lop vêl ên sip dɨ la Jelusalem mɨ la keac vô xomxo vông vinên. Pyap dɨ i loc mɨ la Antiok. ");
INSERT INTO ptp_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Mêd Pol dô Antiok buc ya, nang dêc kɨdi vac Antiok dɨ la tup vac vɨgwe wê yêp vac vɨgwe levac Galesia yuu Plisia ge, dɨ la nêl kɨyang vô xomxo vông vinên ên nêb i ngɨdu he xôn. ");
INSERT INTO ptp_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Yuda ti lê nêbê Apolos wê ben Aleksandlia ge mɨla dô Epesas. Apolos ge mi nêl kɨyang nivɨha dɨ xovô kɨyang vɨhati wê yêp vac kɨpihac xolac ge. ");
INSERT INTO ptp_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Ilage xomxo nêl Apumtau Yesu môp kɨtong vô Apolos mɨ i xovô dɨ i nɨlô kɨdu i nêb ob tɨmu vô xolac vɨhati, om Apolos nêl Yesu kɨtong bôbac vô xomxo, lêc môp mia lipacên ge, xovô wê Jon lipac xomxo ge tibed. ");
INSERT INTO ptp_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Mêd Apolos la nêl xolac vac xumac lɨlo wê he Yuda vông ge dɨ xonaên ma, dɨ Plisila yuu Akwila ngô kɨyang wê Apolos nêl ge, om kô i mɨ la vac yuu ben dɨ la nêl Anutu môp yuu xolac wê Apolos lungên ge vɨhati kɨtong vô i. ");
INSERT INTO ptp_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Mêd Apolos nêb ob la vɨgwe Glik dɨ lie vông vinên Epesas tyuc lec nêb i loc. Om he kɨvuu kɨpihac ti dɨ vông i la vô xomxo Glik ên nêbê he i kô Apolos lec nivɨha. Mêgem Apolos mɨla Glik, dɨ xomxo wê Anutu xêyaa vin lec he mɨ he vông i vin gee, Apolos ngɨdu he xôn. ");
INSERT INTO ptp_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Apolos he Yuda ngaênma lec xolac vô xomxo tɨbeac manôn, lêc Apolos nêl kɨyang hɨxôn xêkɨzêc om hi he nên kɨyang tô mɨ la. Ên Apolos nêl kɨyang wê yêp vac kɨpihac xolac ge kɨtong vô he om vông xovôên vô he ên nêbê Yesu ge Kɨlisi wê Anutu vɨnoo pyap ge. ");
INSERT INTO ptp_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Apolos dô Kolin dɨ vô buc tige Pol la tup vac vɨgwe kɨtôn dɨ mɨla Epesas. Dɨ mɨla tulec xomxo vông vinên ya ");
INSERT INTO ptp_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","dɨ kɨnêg vô he ên nêbê, “Buc wê xam vông i vin taxlee ge, Myakɨlôhô Ngɨbua lam dô hɨxôn xam, me?” Lêc he nêl ên nêbê, “Xe o ngô kɨyang ti lec Myakɨlôhô Ngɨbua lêm.” ");
INSERT INTO ptp_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Om Pol kɨnêg vô he ên nêbê, “Om xam lipac mia tina?” Lêc he nêl ên nêbê, “Xe lipac mia tɨyi wê Jon vông ge.” ");
INSERT INTO ptp_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Mêd Pol nêl ên nêbê, “Ilage Jon lipac xomxo wê pɨlepac he dɨ vô nɨmi vô nipaên ge, dɨ nêl vô he ên nêbê he i vông i vin xomxo ti wê ob val tɨmuên ge. Xomxo tige Yesu.” ");
INSERT INTO ptp_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Xomxo tigee ngô kɨyang wê Pol nêl ge om he lipac mia lec Apumtau Yesu lê. ");
INSERT INTO ptp_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Mêd Pol vyax vɨgê lec he dɨ Myakɨlôhô Ngɨbua lam hɨvun he xôn dɨ vông he keac vac tɨbii toto vya wê he lungên ge dɨ he nêl kɨyang tɨyi xocbê plopet ge. ");
INSERT INTO ptp_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Xomxo tigee vɨgê yuu dɨ tô mɨ la yuu. ");
INSERT INTO ptp_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Mêd Pol la vac xumac lɨlo wê he Yuda vông ge dɨ la nêl Anutu xolac vô xomxo hɨxôn xêkɨzêc dɨ xonaên ma. Pol nêl Anutu ben kehe kɨtong vô he. Pol vông môp tibêge tɨyi dentuc yon. ");
INSERT INTO ptp_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Lêc xomxo ya nɨlô xêkɨzêc om he o vông i vin kɨyang wê Pol nêl ge lêm, dɨ he la nêl kɨyang nipaên lec môp wê Yesu vông ge vô xomxo tɨbeac manôn. Mêgem Pol hɨxôn xomxo vông vinên sea he dɨ la dô vac xumac wê Tilanas mi tɨxuu xomxo vac ge, dɨ Pol viac kɨyang nivɨha vô xomxo tɨyi buc vɨhati. ");
INSERT INTO ptp_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Pol vông môp tibêge tɨyi lec klismas yuu, om Apumtau xolac la vô he Yuda hɨxôn he Glik wê dô vac vɨgwe levac Esia ge vɨhati. ");
INSERT INTO ptp_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Anutu vông xêkɨzêc vô Pol om Pol vông do levac tɨbeac, ");
INSERT INTO ptp_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","om xomxo kô Pol nivɨmihi wê ka bazub ya ge hɨxôn i nên ngakwi ya mɨ la vông vô xomxo wê yidac ge dɨ he vô nivɨha lec, dɨ xomxo wê vɨmwo nipaên dô vac he nɨlô ge, vɨmwo nipaên pec mɨ la vêl ên he. ");
INSERT INTO ptp_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Yuda ya mi vɨlee vac vɨgwe vɨyang vɨyang dɨ la tii vɨmwo nipaên vêl ên xomxo, dɨ he ya tɨxuu nêb ob nêl Apumtau Yesu lê dɨ tii vɨmwo nipaên vêl lec Yesu lê. Om he nêl bêga nêbê, “Yesu ti wê Pol nêl i kɨtong ge, xe nêl vô ông lec i lê bêga bê ông lop mɨ loc vêl ên xomxo tige.” ");
INSERT INTO ptp_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Xomxo levac wê mi si daa vô Anutu ge ti lê nêbê Siva, nue vux vɨgê vɨlu dɨ sec yuu vông môp tibêge, ");
INSERT INTO ptp_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","lêc vɨmwo nipaên nêl vô he ên nêbê, “A xovô Yesu dɨ a xovô Pol, lêc xam ge letya?” ");
INSERT INTO ptp_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Mêd xomxo ti wê vɨmwo nipaên dô vac i nɨlô ge hôm he xôn dɨ hi he ninɨvi vô nipaên dɨ lêx he ngakwi sea, om he sea xumac tige dɨ pec mɨ la xêtuac. ");
INSERT INTO ptp_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Mêd he Yuda hɨxôn he Glik wê dô Epesas gee vɨhati ngô kɨyang tige om he xona mabu dɨ pɨmil Apumtau Yesu lê. ");
INSERT INTO ptp_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Mêgem xomxo vông vinên tɨbeac lam nêl he nên nipaên wê mi vông ge kɨtong seac, ");
INSERT INTO ptp_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","dɨ he wê mi vông yevac ilage kɨtuc he kɨpihac yevac lam dɨ si lec ngwax vô xomxo vɨhati manôn. Kɨpihac tigee, he kɨsuu lec mone levac tɨyi xocbê 50,000 kina. ");
INSERT INTO ptp_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Mêgem Apumtau xolac la vô levac vac vɨgwe tɨbeac. ");
INSERT INTO ptp_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Pyap dêc Myakɨlôhô Ngɨbua vông xovôên vô Pol, om Pol nêl ên nêbê, “A ob la tup vac vɨgwe Masedonia yuu Glik dɨ la Jelusalem. Pyap dɨ a ob la Lom hɨxôn.” ");
INSERT INTO ptp_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Mêd Pol vông Timoti yuu Elastas wê yuu mi ngɨdu i xôn ge yuu la Masedonia, dɨ Pol dô myabo tya gê Esia. ");
INSERT INTO ptp_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Vô buc tige xomxo ya vông vevac vô môp wê Apumtau vông ge dɨ vông nidɨdun levac. ");
INSERT INTO ptp_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Ên xomxo ti dô Epesas lê nêbê Demitlias wê mi vông yuac lec silva. Demitlias vông xumac nipwo ya silva tɨyi xocbê xumac ngɨbua wê anutu kɨtyooên Atemis vông ge. Demitlias he nue yuac kô mone mabu lec yuac tige, ");
INSERT INTO ptp_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","om Demitlias kɨtuc nue yuac hɨxôn tɨbii wê mi vông yuac tibêge lam dɨ nêl vô he ên nêbê, “Xame, xam xovô wê il kô mone mabu lec yuac wê il mi vông ge. ");
INSERT INTO ptp_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Lêc xam wê dɨ ngô wê Pol val pɨlepac xomxo tɨbeac nɨlô dɨ he vông i vin kɨyang wê nêl ge. Ên Pol nêl ên nêbê anutu wê xomxo vông ya vɨgê ge, ge o Anutu nôn lêm. Pol lam nêl kɨyang tige vac il bed dɨ nêl vac vɨgwe levac Esia vɨhati hɨxôn. ");
INSERT INTO ptp_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Om kɨyang wê Pol nêl ge ob vông yuac bisnis wê il vông ge lê vô nipaên, dɨ xumac ngɨbua wê anutu Atemis vông ge, xomxo ob yê tɨyi xocbê xumac pɨleva. Atemis ge il anutu vêx wê il Esia hɨxôn xomxo vac vɨgwe vɨhati mi kɨtaa vô ge, lêc Pol kɨyang ob vông lê levac wê Atemis vông ge vô nipaên.” ");
INSERT INTO ptp_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Xomxo tigee ngô kɨyang wê Demitlias nêl ge om he xêyaa vô myavɨnê dɨ he tyuc vya levac ên nêbê, “Atemis wê il Epesas vông ge i vêx levac.” ");
INSERT INTO ptp_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Mêd tyucên tige la vac vɨgwe Epesas vɨhati om tɨbii vɨhati vông dɨdun levac dɨ tup mɨ la hôm Gaias yuu Alistakas xôn dɨ dɨdii yuu dɨ he la vac vɨgwe wê he mi kɨtucma vac ge. Yuu ge Masedonia yuu wê mi la hɨxôn Pol ge. ");
INSERT INTO ptp_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Pol nêb ob la vac tɨbii wê kɨtucma gee mahɨgun, lêc xomxo vông vinên le vac xôn nêb i locên i ma. ");
INSERT INTO ptp_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Dêc gavman Esia mangwe wê Pol nipɨpu ge he vông kɨyang la vô Pol nêbê i loc vacên kɨtucmaên i ma. ");
INSERT INTO ptp_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Mêd xomxo wê kɨtucma gee, he tɨbeac o xovô kɨtucmaên tige kehe lêm, om he pɨyôp juda dɨ he ya tyuc kɨyang bangwe dɨ ya tyuc kɨyang baba ya. ");
INSERT INTO ptp_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Om Yuda ya kô lie ti lê nêbê Aleksanda mɨ la tung vac tɨbii kɨtucmaên mahɨgun ên nêbê i nêl kɨyang vô he, om Aleksanda vông vɨgê la kɨsii ên nêb ob nêl kɨyang. ");
INSERT INTO ptp_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Lêc xomxo tigee yê Aleksanda dɨ xovô nêbê ge Yuda ti, om he vɨhati tyuc vya yêp tibed ên nêbê, “Atemis wê il Epesas vông ge i vêx levac.” Mêd he tyuc vya tibêge tɨyi hɨyôv manôn yuu. ");
INSERT INTO ptp_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Mêd xomxo levac wê mi kɨvuu kɨyang wê he Epesas vông ge ti lam keac lec he dɨ he dô kɨyang maên, dɨ i nêl vô he ên nêbê, “Xam Epesas, bêna lêc xam tyuc vya lec Atemis? Xomxo vɨhati xovô ên nêbê il Epesas viac xumac ngɨbua wê Atemis vông ge dɨ il viac ngɨdax ngɨbua wê tô gê kɨsii ganê mɨ lam ge hɨxôn. ");
INSERT INTO ptp_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Xomxo ti tɨyiên ma wê ob pwoo kɨyang tige vac, om xam dô dɨdun maên, dɨ xam o lêc vông môp nipaên decdec lêm. ");
INSERT INTO ptp_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Xam kô xomxo yuu ge mɨ lam, lêc yuu o vun susu ti vac xumac ngɨbua lêm, dɨ yuu o so vya vô anutu wê il vông ge lêm. ");
INSERT INTO ptp_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Om Demitlias he nue yuac obêc nêb vông kot vô xomxo ti ge, od buc wê xomxo ob vông kot lec ge yêp, dɨ gavman levac dô, om he i loc vông kɨyang vô gavman levac ên i tɨtô he nên kɨyang. ");
INSERT INTO ptp_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Lêc kɨyang wê xam vông ge ya obêc gên yêp ge od buc wê kɨtucmaên ge xam nêl kɨyang tige dɨ il hi i yib. ");
INSERT INTO ptp_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Ên môp wê il vông gwêbaga tɨyi wê il ob tulec myavɨwen levac, ên il lam kɨtucma mɨ vông dɨdun levac, lêc gavman obêc kɨnêg kɨtucmaên tiga kehe vô il ge, od o tɨyi wê il ob nêl kɨyang ti lax vô he ge lêm.” ");
INSERT INTO ptp_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Xomxo levac nêl bêge vô he dɨ vông he toto la. ");
INSERT INTO ptp_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Nidɨdun wê Epesas vông ge tɨyôô, dɨ Pol keac xomxo vông vinên kɨtuc lam vô i dɨ viac kɨyang vô he ên nêb i ngɨdu he xôn. Pyap dêc pul he vɨgê dɨ sea he dɨ la Masedonia. ");
INSERT INTO ptp_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Mêd Pol tup vac vɨgwe Masedonia vɨhati dɨ nêl kɨyang tɨbeac vô xomxo vông vinên ên nêb i ngɨdu he xôn. Pyap dɨ i la Glik ");
INSERT INTO ptp_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","dɨ la dô dentuc yon. Nang dêc Pol nêb ob lec sip mɨ la Silia, lêc he Yuda wê dô Glik ge hɨlu kɨyang xôn nêb ob hi Pol i yib om Pol xo nêb ob lax mɨ la Masedonia. ");
INSERT INTO ptp_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Xomxo wê la hɨxôn Pol ge he lê nêbê Sopata wê ma Pilas wê lam gê Belia ge, dɨ Alistakas yuu Sekandas wê yuu lam gê Tesalonaika ge, dɨ xomxo Debi ti lê nêbê Gaias, dɨ Timoti, dɨ Tikikas yuu Tlopimas wê yuu lam gê vɨgwe levac Esia ge. ");
INSERT INTO ptp_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Xomxo tigee la dô bin xe gê Tloas. ");
INSERT INTO ptp_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Dɨ xe dô dɨ da levac wê Yuda mi ya blet wê yis maên ge lam la vêl, mêd xe lec sip gê Pilipai dɨ la, dɨ buc vɨgê vɨlu lam la vêl lêc xe mɨla Tloas dɨ dô da ti gê Tloas. ");
INSERT INTO ptp_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Xe kɨtucma lec da ên xe nêb xe ob xa yaên dɨ xa pasa hɨxôn, mêd Pol nêl xolac vô xe ên nêb vɨdiiên tɨtige ob sea xe dɨ la, om nêl xolac dia dɨ i la dɨ la vɨvuaên mahɨgun. ");
INSERT INTO ptp_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Xe kɨtucma vac xumac nɨlô wêyêp kɨsii ge dɨ lam tɨbeac tum vac. ");
INSERT INTO ptp_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Mêd xomxo ngɨvihi ti lê nêbê Yutikas la dô lec xumac vuayen nipwo kɨsii, mêd Pol nêl kɨyang dia om Yutikas manôn yêp dɨ i yêp nɨlô ma om tô lec vuayen nipwo tige dɨ la kɨbun. Xumac nɨlô tige yêp kɨsii dɨ nɨlô ti yêp vac mahɨgun dɨ ti yêp ngɨbi. Om he lop mɨ la yê ngɨvihi tige lêc yib. ");
INSERT INTO ptp_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Mêd Pol lop mɨ la vô xomxo tyo dɨ le ni xocên kɨsii dɨ hôm lec vɨgê dɨ nêl vô he ên nêbê, “Xam o vô vɨyin lêm, ên ga dô mavɨha.” ");
INSERT INTO ptp_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Mêd Pol lec mɨ lax kɨsii dɨ lax ya hɨxôn xomxo vông vinên. Pyap dɨ i nêl kɨyang dia vô he dɨ vɨgwe vɨdii lec, dɨ sea he dɨ la. ");
INSERT INTO ptp_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Mêd ngɨvihi tyo dô mavɨha dɨ he kô mɨ lax ben hɨxôn xêyaa nivɨha. ");
INSERT INTO ptp_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Mêd xe lec sip gê Tloas mɨ la mug mɨ la vɨgwe Asos, ên Pol nêl nêb ob la kɨbun mɨ la Asos dɨ xe xôn obêc lec sip gê Asos. ");
INSERT INTO ptp_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Om Pol mɨla vô xe gê Asos, dɨ xe kô i lec sip dɨ xe xôn la Mitilini. ");
INSERT INTO ptp_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Nang dêc xe sea Mitilini mɨ la, dɨ vɨgwe vɨdiiên tɨtige xe mɨla kwabo vô vɨgwe Kaios, dɨ xe xêp dɨ vɨgwe vɨdiiên xe mɨla Semos dɨ vɨdiiên xe mɨla Mailitas. ");
INSERT INTO ptp_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Xe luu vɨgwe Epesas vêl, ên Pol nêb ob dô vɨgwe levac Esia buc tɨbeac lêm, ên xo nêb ob la lutibed ên la yê buc Pentikos gê Jelusalem. ");
INSERT INTO ptp_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Vac vɨgwe Mailitas Pol vông kɨyang la vô gyovɨxa Epesas nêb he i loc vô i. ");
INSERT INTO ptp_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Om he mɨla dɨ Pol nêl vô he ên nêbê, “Xam xovô môp yuu yuac wê a lam vông vac xam mahɨgun vô buc wê a val Esia taxlee ge hɨxôn buc vɨhati wê a dô hɨxôn xam ge. ");
INSERT INTO ptp_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Dɨ buc tɨbeac he Yuda hɨlu kɨyang xôn nêb ob vông vɨyin vô a, om a dô vac vɨyin tɨbeac, dɨ a lêg vô nipwo lec, lêc a vông yuac wê Apumtau vông vac a vɨgêg ge. ");
INSERT INTO ptp_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Dɨ a o yax kɨyang ti vun ên xam lêm. Nge, a nêl kɨyang wê ob ngɨdu xam xôn ge vɨhati yêp seac vô xam. A tɨxuu xam vac kɨtucmaên dɨ a loc tɨxuu xam vac xam toto bom hɨxôn. ");
INSERT INTO ptp_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Dɨ buc tɨbeac a nêl kɨyang xêkɨzêc vô xam Yuda hɨxôn xam tɨbii ba ên a nêbê xam pɨlepac nɨlôm i loc vô Anutu dɨ xam vông i vin il lig Apumtau Yesu. ");
INSERT INTO ptp_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Om xam ngô lê. Gwêbaga Myakɨlôhô Ngɨbua nêl vô a nêb a la Jelusalem, lêc vɨyin wê xomxo ob vông vô a gê Jelusalem ge, a lungên. ");
INSERT INTO ptp_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Vac vɨgwe vɨhati wê a la dô vac ge Myakɨlôhô Ngɨbua nêl kɨtong vô a ên nêbê a ob kô vɨyin dɨ tɨbii ob tung a vac xumac kalabuhu. ");
INSERT INTO ptp_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Lêc a nêb a ob vông yuac vɨhati wê Apumtau Yesu vông vô a ge i loc tɨyi lec myahɨpu dɨ a o xo a nignɨvi lêm. Yuac wê a ob vông ge a ob nêl vɨzid nivɨha wê Anutu vông ge kɨtong vô xomxo. ");
INSERT INTO ptp_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","“Xam xovô bê ilage a loc tup vac xam dɨ loc nêl Anutu ben kehe kɨtong vô xam, lêc gwêbaga a xovô ên a nêbê xam obêc wê a magnôn tii vac lêm. ");
INSERT INTO ptp_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Om a ob nêl kɨyang xêkɨzêc vô xam bêga bê xam ti obêc wib mɨ la vac nipaên ge od kɨyang ti o yêp vô a lêm. ");
INSERT INTO ptp_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Ên a o yax kɨyang ti vun ên xam lêm. Nge, a nêl kɨyang wê Anutu vông ge vɨhati kɨtong vô xam. ");
INSERT INTO ptp_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Om xam viac xam dɨ xam viac Anutu nue vɨhati, ên Myakɨlôhô Ngɨbua vɨnoo xam nêb xam viac he. Xam viac he i nivɨha, ên Apumtau kɨsuu he ya hi wê ici va vông ge. ");
INSERT INTO ptp_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","A xovô ên a nêbê a ob sea xam dɨ a ob la, dɨ tɨmuên xomxo nipaên ya obêc lam vac xam mahɨgun dɨ lam vông xam vô nipaên tɨyi xocbê noo vɨmen la hi bwoc sipsip ge. ");
INSERT INTO ptp_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Dɨ xacxam va ya obêc kɨdi vac xam mahɨgun dɨ nêl kɨyang kɨtyooên vô xam dɨ dɨdii xam mɨ lax tɨmu vô he vɨxa. ");
INSERT INTO ptp_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Om xam viac xam nivɨha, dɨ xam xovô bê tɨyi klismas yon a dô hɨxôn nɨlôg vɨyin yuu byagên, lêc a nêl Anutu xolac vô xam tɨyi bucên yuu vɨdiiên vɨhati. ");
INSERT INTO ptp_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","“Dɨ gwêbaga a ob tung xam vac Anutu vɨgê dɨ xam dô vac kɨyang xêyaa vin lecên wê Anutu vông ge. Ên kɨyang tige tɨyi wê ob vông xam le xêkɨzêc, dɨ ob vông vɨzid wê Anutu nêb ob vông vô il vɨhati wê il tu i nue ge vô xam hɨxôn. ");
INSERT INTO ptp_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","“A o kɨtaa gol yuu silva hɨxôn nivɨmihi vô xomxo ti lêm. ");
INSERT INTO ptp_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Xam xovô ên xam nêbê aca va vɨgêg vông yuac dɨ a tulec susu wê ngɨdu a xôn dɨ ngɨdu xomxo wê dô hɨxôn a ge xôn. ");
INSERT INTO ptp_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Yuac vɨhati wê a vông ge nêl kɨtong vô xam bêga nêbê il ob vông yuac xêkɨzêc ên i ngɨdu xomxo wê he nên xêkɨzêc ma ge xôn. Dɨ il ob xovô kɨyang wê Apumtau Yesu nêl bêga nêbê xomxo ti obêc vông susu vô xomxo ngwe ge od xêyaa ob vô nivɨha luu môp wê ob kô susu vô xomxo ngwe ge vêl.” ");
INSERT INTO ptp_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Pol nêl kɨyang tige pyap dɨ yev vɨxa kɨtu vac dɨ he gyovɨxa kɨtaa. ");
INSERT INTO ptp_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Pyap dɨ he vɨhati byag mabu dɨ kɨva Pol xôn dɨ pul i vɨgê. ");
INSERT INTO ptp_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Dɨ he nɨlô vô vɨyin levac ên kɨyang wê Pol nêl vô he ên nêbê, “Xam obêc wê a magnôn tii vac lêm.” Mêd he kô Pol mɨ la tung lec sip. ");
INSERT INTO ptp_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Mêd xe lec sip dɨ sea he dɨ mɨla bôbac vô vɨgwe Kos, dɨ vɨgwe vɨdiiên ge xe kɨdi mɨ la vɨgwe Los, dɨ xe sea Los dɨ mɨla Patala. ");
INSERT INTO ptp_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Mêd xe tulec sip ngwe wê ob la vɨgwe Pinisia ge om xe lec sip tige dɨ la. ");
INSERT INTO ptp_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Mêd xe mɨla kwabo vô vɨgwe Saiplas wê yêp vô xe vɨgêm kêd ge dɨ xe luu Saiplas vêl dɨ la Taia vac vɨgwe levac Silia. Mêd tɨbii tul kupac vêl ên sip, ");
INSERT INTO ptp_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","dɨ xe lop vêl ên sip dɨ la myag xomxo vông vinên vac vɨgwe tige lêc xe tulec he ya om xe la dô hɨxôn he da ti. Myakɨlôhô Ngɨbua vông xovôên vô he om he nêl vô Pol ên nêbê, “Locên Jelusalem i ma.” ");
INSERT INTO ptp_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Mêd buc wê xe dô hɨxôn he ge tɨyôô om he vông vinên vɨhati hɨxôn vɨnêe nue, xe xôn sea he ben dɨ la gwec nɨnya, mêd xe vɨhati yev vɨxam kɨtu vac dɨ kɨtaa, ");
INSERT INTO ptp_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","pyap dɨ xe pulma vɨgêm dɨ xe lec sip dɨ he lax mɨ la ben. ");
INSERT INTO ptp_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Xe sea Taia dɨ mɨla Tolemes, dɨ xe la vô xomxo vông vinên wê dô vɨgwe tige dɨ keac vô he dɨ dô hɨxôn he buc tibed. ");
INSERT INTO ptp_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Dêc vɨgwe vɨdiiên ge xe sea Tolemes dɨ la Sisalia, dɨ mɨla dô hɨxôn sinale Pilip vac i ben. Pilip ge xomxo wê Yesu nue ngɨvihi vɨnoo he vɨgê vɨlu dɨ sec yuu gê Jelusalem ilage ên nêb he i ngɨdu Yesu nue ngɨvihi xôn ge. ");
INSERT INTO ptp_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Pilip nue vêxwo yuudɨyuu dô wê he mi nêl Anutu xolac ge. ");
INSERT INTO ptp_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Xe dô Sisalia buc ya la vêl mêd plopet ti lê nêbê Agabas kɨdi gê Judia dɨ val Sisalia vô xe, ");
INSERT INTO ptp_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","dɨ val hôm Pol let dɨ ku ici va vɨgê yuu vɨxa xôn ya, dɨ nêl ên nêbê, “Myakɨlôhô Ngɨbua nêl bêga nêbê he Yuda wê dô Jelusalem ge obêc ku xomxo ti wê i let tiga xôn tɨyi bêga, dɨ he obêc vông i la vac tɨbii wê o Yuda lêm ge vɨgê.” ");
INSERT INTO ptp_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Xe ngô kɨyang tige om xe wê xe la hɨxôn Pol ge, hɨxôn he wê dô vac vɨgwe tige xe kɨtaa Pol ên xe nêbê, “Locên Jelusalem i ma.” ");
INSERT INTO ptp_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Lêc Pol nêl vô xe ên nêbê, “Bêna lêc xam byag dɨ vông a nɨlôg vô vɨyin? A o xona ên wê tɨbii ob ku a xôn ge lêm. Dɨ he obêc hi a xib gê Jelusalem ge od ge pyap. A obêc xib lec Apumtau lê.” ");
INSERT INTO ptp_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Xe nêl kɨyang tɨbeac vô Pol, lêc o ngô lêm, om xe sea vyam wê xe nêl ge dɨ nêl bêga bê, “Anutu i vông i tɨyi wê xovô ge.” ");
INSERT INTO ptp_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Buc ya lam la vêl mêd xe kô xe susu lec ên xe nêb xe ob la Jelusalem. ");
INSERT INTO ptp_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Dêc xomxo vông vinên Sisalia ya la hɨxôn xe dɨ xe la Jelusalem, dɨ he kô xe mɨ la vac Neson ben wê xe ob xêp vac ge. Neson ge xomxo Saiplas ti wê vông i vin Yesu ilage. ");
INSERT INTO ptp_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Xe mɨla Jelusalem dɨ lige vông vinên wê dô Jelusalem gee kô xe lec hɨxôn xêyaa nivɨha. ");
INSERT INTO ptp_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Dɨ vɨgwe vɨdiiên ge xe hɨxôn Pol la xê Jems, dɨ gyovɨxa Jelusalem vɨhati la dô hɨxôn. ");
INSERT INTO ptp_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Mêd Pol pul he vɨgê dɨ nêl kɨyang lec yuac vɨhati wê Anutu ngɨdu i xôn dɨ i la vông vac tɨbii wê o Yuda lêm gee ben. ");
INSERT INTO ptp_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","He gyovɨxa ngô kɨyang wê Pol nêl ge om he pɨmil Anutu dɨ nêl vô Pol ên nêbê, “Lige, ông xovô bê Yuda tɨbeac xocbê 1,000 ge he vông i vin Yesu, lêc he tɨmu vô xolac wê Moses vông ge hɨxôn. ");
INSERT INTO ptp_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Dɨ xomxo ya nêl kɨyang kɨtyooên vô he ên nêbê ông la nêl kɨyang vô he Yuda wê la dô vac tɨbii ba ben gee ên ông nêbê he i sea Moses xolac dɨ sea môp wê ob gôl nue ninɨvi ge dɨ sea môp wê he Yuda mi vông ge. ");
INSERT INTO ptp_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Om il ob vông bêna? Ên gwêbaga he Yuda ob ngô wê ông val dô ga. ");
INSERT INTO ptp_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Om ông vông i tɨyi kɨyang wê xe ob nêl vô ông bêga bê xe lige yuudɨyuu dô wê he hɨlu kɨyang ti vô Anutu ge. ");
INSERT INTO ptp_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Om ông loc hɨxôn he dɨ xam loc vông i tɨyi môp wê yêp vac Moses xolac ge wê ob kɨtya xam nêm nipaên vêl dɨ xam vô paha lec, dɨ ông vông mone vô he, ên he i loc kɨping bazub lihi. Ông vông môp bêge, ên xomxo vɨhati i yê wê ông tɨmu vô Moses xolac ge dɨ he i xovô bê kɨyang wê xomxo kɨtyoo lec ông ge nôn maên. ");
INSERT INTO ptp_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","“Dɨ tɨbii vông vinên wê o Yuda lêm ge, ilage il hɨlu kɨyang dɨ vông kɨpihac ti la vô he ên il nêbê he i kol he ên susu yaên wê tɨbii vông i tu daa vô anutu kɨtyooên ge, dɨ he yaên hi i ma, dɨ he i o ya lɨlii wê he ngɨbina kwa dɨ hi dô vac nɨlô ge lêm, dɨ he i xona ên môp yôdac vêx yuu vux.” ");
INSERT INTO ptp_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","He nêl bêge vô Pol, om Pol kô xomxo yuudɨyuu tigee dɨ vɨgwe vɨdiiên tɨtige he xôn la tɨmu vô môp wê ob kɨtya he nên nipaên vêl ge, pyap dɨ he la vô xomxo wê mi si daa ge vac Anutu xumac ngɨbua dɨ la nêl buc wê he ob vô paha lec dɨ he toto ob vông daa vô Anutu ge kɨtong vô he. ");
INSERT INTO ptp_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","He dô dɨ buc vɨgê vɨlu dɨ sec yuu vô kwabo lec wê ob tɨyôô ge, lêc he Yuda wê lam gê Esia gee yê wê Pol la dô vac Anutu xumac ngɨbua ge, om he vông xomxo tɨbeac nɨlô juda sea dɨ he la hôm Pol xôn, ");
INSERT INTO ptp_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","dɨ tyuc vya levac ên nêbê, “Xam lige Islel, xam lam hɨxôn xe, ên xomxo tiga wê mi la vac vɨgwe vɨhati dɨ la so vya lec il Islel hɨxôn Moses xolac dɨ xumac ngɨbua tiga. Dɨ gwêbaga xomxo tiga vông môp nipaên bêga bê kô tɨbii wê o Yuda lêm ge mɨ he lam vac Anutu xumac ngɨbua ga om vông xumac tyo vô nipaên.” ");
INSERT INTO ptp_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","He nêl bêge, ên he yê wê Pol la vɨlee vac Jelusalem hɨxôn Tlopimas wê tɨbii Epesas ti ge, om he so nêbê mêd Pol kô Tlopimas mɨ yuu la vac Anutu xumac ngɨbua nɨlô. ");
INSERT INTO ptp_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Om xomxo Jelusalem vɨhati xêyaa vô myavɨnê vô Pol dɨ he kɨtucma mɨ la hôm Pol xôn vac Anutu xumac ngɨbua dɨ kô i mɨ la vɨxun dɨ tung vuayen lec lutibed. ");
INSERT INTO ptp_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Mêd xomxo tigee hi Pol ên nêb ob hi i yib, lêc kɨyang la vô Lom levac ti wê viac tɨbii vevac vɨhati ge ên nêbê xomxo Jelusalem vɨhati kɨtucma dɨ vông nidɨdun levac. ");
INSERT INTO ptp_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Om tɨbii levac tige kô tɨbii vevac levac ya hɨxôn he nue vevac dɨ he la lutibed dɨ mɨla le vac xomxo mahɨgun. Mêd xomxo yê wê he val ge om he sea Pol dɨ hiên ma. ");
INSERT INTO ptp_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Mêd tɨbii levac tige nêl vô nue vevac ên nêbê he i loc hôm Pol xôn dɨ ku i xôn ya sen yuu. Mêd tɨbii levac nêl ên nêbê, “Xomxo tiga letya? Dɨ i vô va lêc xam hi?” ");
INSERT INTO ptp_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Lêc xomxo ya tyuc kɨyang ngwe dɨ he ya tyuc kɨyang bangwe, dɨ he tyuc vac nidɨdun levac om tɨbii levac tige o ngô kɨyang wê he tyuc ge nivɨha lêm, om nêl vô nue vevac ên nêb he i kô Pol mɨ loc vac xumac wê he vông ge. ");
INSERT INTO ptp_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","36","Om he kô Pol mɨ la lec peb, lêc xomxo tɨbeac tɨmu vô he vɨxa dɨ tyuc ên nêbê, “Hi i yib.” Om tɨbii vevac tigee hôm Pol kɨsii dɨ kô mɨ la. ");
INSERT INTO ptp_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","He nêb he ob kô Pol mɨ la xumac lôma, lêc Pol nêl vô tɨbii vevac levac tige vac vya Glik ên nêbê, “A ob nêl kɨyang ti vô ông.” Mêd tɨbii vevac tyo nêl vô Pol ên nêbê, “Ông xovô vya Glik. ");
INSERT INTO ptp_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","A so ên a nêbê mêd ông Isip ti wê ông vông vevac vô gavman ilage dɨ i kô tɨbii 4,000 hɨxôn he yipac dɨ dɨdii he mɨ la vac vɨgwe myadongên.” ");
INSERT INTO ptp_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Mêd Pol nêl vô i ên nêbê, “A ga Yuda ti dɨ a bog vɨgwe levac Tasas wê yêp vac vɨgwe Silisia ge. Om a kɨtaa ông bê ông tyuc lec dɨ a nêl kɨyang ya vô xomxo tigae.” ");
INSERT INTO ptp_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Mêd tɨbii levac tige lee yuu om Pol le lec peb dɨ vông vɨgê la kɨsii dɨ xomxo vɨhati dô kɨyang maên, mêd Pol nêl kɨyang vô he vac Yuda vya. ");
INSERT INTO ptp_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","Pol nêl vô he bêga nêbê, “Xam mage lige, a ob nêl a kehe kɨtong om xam ngô.” ");
INSERT INTO ptp_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","He ngô wê Pol keac vac Yuda vya ge om he dô kɨyang maên, dɨ Pol nêl vô he ên nêbê, ");
INSERT INTO ptp_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“A ga Yuda ti dɨ a yubac gê Tasas vac vɨgwe levac Silisia, lêc a lig gê Jelusalem dɨ Gameliel tɨxuu a ya Moses xolac vɨhati wê il buge tɨmu vô ge om a vông i vin Anutu xêkɨzêc dɨ vông yuac wê i vông ge tɨyi xocbê xam vông gwêbaga. ");
INSERT INTO ptp_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Dɨ a vông vɨyin levac vô xomxo wê vông i vin Yesu ge ên a nêb a ob hi he i yib, dɨ a ku he vêx yuu vux xôn dɨ tung he vac xumac kalabuhu. ");
INSERT INTO ptp_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Xomxo daa siên nên levac hɨxôn kaunsil vɨhati xovô môp wê a vông ilage, om he tɨyi wê ob nêl a kɨtong. Mêd he kɨvuu kɨpihac vô he Yuda wê dô Damaskas ge dɨ a kô mɨ la Damaskas ên a nêb a ob hôm xomxo vông vinên wê dô vɨgwe tige xôn dɨ kô he mɨ lam Jelusalem ên he i lam kô myavɨnê. ");
INSERT INTO ptp_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","“A loc mɨ la dɨ a mɨla kwabo vô Damaskas vô vɨdiiên wê hɨyôv tyip kɨtôn ge, lêc lutibed xêseac ti lam gê kɨsii dɨ lam byêx a magnôn, ");
INSERT INTO ptp_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","dɨ a tɨlii mɨ la xêp kɨbun, dɨ a ngô vya ti lam nêl vô a ên nêbê, ‘Sol, bêna lêc ông vông vɨyin vô a?’ ");
INSERT INTO ptp_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Lêc a kɨnêg ên a nêbê, ‘Apumtau, ông letya?’ Dɨ i nêl vô a ên nêbê, ‘A Yesu Nasalet wê ông vông vɨyin vô a ge.’ ");
INSERT INTO ptp_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Mêd xomxo wê dô hɨxôn a gee yê xêseac lê, lêc he o ngôvô xomxo ti wê keac vô a ge vya lêm. ");
INSERT INTO ptp_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","“Mêd a kɨnêg ên a nêbê, ‘Apumtau, a ob vông bêna?’ Lêc Apumtau nêl vô a ên nêbê, ‘Ông kɨdi lec mɨ loc Damaskas, ên xomxo ti obêc nêl yuac wê Anutu nêb ông ob vông ge kɨtong vô ông.’ ");
INSERT INTO ptp_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Xêseac tige byêx a magnôn dɨ a o xê susu ti lêm, om he wê dô hɨxôn a gee hôm lec a vɨgêg dɨ dɨdii a dɨ xe la Damaskas. ");
INSERT INTO ptp_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","“Xomxo ti lê nêbê Ananaias dô Damaskas. Ananaias viac Moses xolac vɨhati dɨ tɨmu vô nivɨha om he Yuda wê dô Damaskas gee yê ên nêb i xomxo nivɨha. ");
INSERT INTO ptp_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Mêd Ananaias lam le vô a magnôn dɨ nêl ên nêbê, ‘A lig Sol, mamnôn i seac.’ Dêc lutibed a magnôn seac dɨ a xê Ananaias. ");
INSERT INTO ptp_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Dɨ i nêl vô a ên nêbê, ‘Anutu wê il buge vông ge vɨnoo ông ên nêb ông xovô kɨyang wê i vông ge dɨ ông wê xomxo nivɨha tyo wê ici va nêl kɨyang vô ông vac mya ge, ");
INSERT INTO ptp_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","ên ông obêc kô kɨyang wê ông wê dɨ ngô ge mɨ la nêl kɨtong vô xomxo vɨhati. ");
INSERT INTO ptp_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Om ông dɨbin vatya? Kɨdi lec mɨ loc lipac mia, dɨ ông kɨtaa vô Apumtau ên i kɨtya ông nêm nipaên vêl.’ ");
INSERT INTO ptp_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","“Mêd a lôm Jelusalem dɨ la kɨtaa vac Anutu xumac ngɨbua, lêc a xê vɨvia ti bêga nêbê ");
INSERT INTO ptp_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Apumtau nêl kɨyang ti vô a ên nêbê, ‘Ông sea Jelusalem dɨ loc lutibed, ên ông obêc nêl a kɨtong vô xomxo ge od he ob vông i vin lêm.’ ");
INSERT INTO ptp_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Mêd a nêl ên a nêbê, ‘Apumtau, he xovô wê ilage a la vac xumac lɨlo vɨhati dɨ a la hôm xomxo wê vông i vin ông ge xôn dɨ a hi he. ");
INSERT INTO ptp_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Dɨ buc wê he hi Stiven wê mi nêl ông kɨyang ge od a le hɨxôn dɨ viac he wê nêx Stiven ya ngɨdax ge nên ngakwi, dɨ a xê môp wê he vông ge ên a nêbê nivɨha.’ ");
INSERT INTO ptp_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Lêc Apumtau nêl vô a ên nêbê, ‘Ông loc ên a ob vông ông loc môp dia vô tɨbii madɨluhu wê o Yuda lêm gee.’” ");
INSERT INTO ptp_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","He Yuda ngô kɨyang wê Pol nêl ge, dɨ i val vô kɨyang ti wê nêb ob la vô tɨbii ba ge lêc he yê tɨyiên ma om he tyuc vya levac ên nêbê, “Hi xomxo tige i yib. Xomxo tibêge ob dô mavɨha lêm.” ");
INSERT INTO ptp_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","He tyuc levac dɨ nêx nivɨmihi kɨsii dɨ hôm vɨjuva mɨ nêx i la kɨsii hɨxôn. ");
INSERT INTO ptp_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Om tɨbii vevac tige nêl vô nue vevac ên nêbê, “Xam kô Pol mɨ loc vac il bed xumac lôma dɨ loc hi i ya yihi, ên i nêl kɨyang wêYuda tyuc lec i ge kehe vô il mɨ il ngô.” ");
INSERT INTO ptp_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Om he ku Pol vɨgê xôn ya let, lêc Pol kɨnêg vô tɨbii vevac ti wê le kwabo ge ên nêbê, “Xolac wê gavman vông ge yêp ên nêbê xam obêc hi xomxo Lom ti tax dêc i vông kot tɨmuên ge od obêc la tɨyi, me?” ");
INSERT INTO ptp_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Tɨbii tige ngô kɨyang wê Pol nêl ge om lax nêl vô tɨbii vevac levac ên nêbê, “Ông ob vông bêna vô xomxo tige? Ên xomxo tige Lom ti.” ");
INSERT INTO ptp_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Om xomxo levac tige la vô Pol dɨ kɨnêg vô i ên nêbê, “Ông nêl kɨtong vô a bê ông Lom ti vɨxôhɨlôg, me?” Om Pol nêl ên nêbê, “Vɨxôhɨlôg, a xomxo Lom ti.” ");
INSERT INTO ptp_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Mêd tɨbii levac tige nêl vô Pol ên nêbê, “A vông mone levac la vô gavman, om a dô tɨyi xocbê xomxo Lom.” Lêc Pol nêl ên nêbê, “Dɨ a mô, a o bêge lêm, ên tag kô a dɨ a Lom ti.” ");
INSERT INTO ptp_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Mêd nue vevac wê nêb ob hi Pol ge ngô kɨyang tige om xona dɨ sea Pol lutibed, dɨ tɨbii vevac levac tige ngô wê Pol Lom ti lêc he ku i xôn ge, om xona. ");
INSERT INTO ptp_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Tɨbii levac tige nêb ob ngôvô kɨyang wê he Yuda nêl lec Pol ge kehe, om vɨgwe vɨdiiên ge pɨwelac sen vêl ên Pol dɨ vông kɨyang la vô Yuda levac wê mi si daa gee hɨxôn kaunsil vɨhati ên nêbê he i lam kɨtucma, mêd tɨbii vevac levac tyo kô Pol mɨ lam lax vô he manôn. ");
INSERT INTO ptp_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Pol manôn la vô he kaunsil dɨ nêl kɨyang vô he nêbê, “Xam lige, môp wê a vông ilage dɨ i val tyip gwêbaga, Anutu yê nêb a o vông ti so lêm.” ");
INSERT INTO ptp_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Mêd xomxo daa siên nên levac lê nêbê Ananaias ngô Pol kɨyang, om nêl vô xomxo wê le kwabo vô Pol ge ên nêbê, “Pɨtap i mya.” ");
INSERT INTO ptp_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Lêc Pol nêl vô Ananaias ên nêbê, “Ông tɨyi xocbê xax wê xomxo lipac pên lec kɨsii lêc nɨlô pɨtal ge, om Anutu obêc hi ông, ên ông nêb ông ob tɨtô a kɨyang ya Moses xolac lê, lêc ông pwoo Moses xolac vac ên wê ông nêl dɨ xomxo hi a ge.” ");
INSERT INTO ptp_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Mêd xomxo wê le hɨxôn Pol ge nêl vô i ên nêbê, “Letya nêb ông nêl kɨyang nipaên lec xomxo levac wê mi si daa vô Anutu ge?” ");
INSERT INTO ptp_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Mêd Pol nêl ên nêbê, “Xam lige, a xovô kɨyang wê yêp vac kɨpihac xolac bêga nêbê, ‘Xam o lêc nêl kɨyang nipaên lec xomxo levac wê viac xam ge lêm.’ Lêc a o xovô bê xomxo tige xomxo levac wê mi si daa ge lêm om a nêl kɨyang bêge lec i.” ");
INSERT INTO ptp_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Pol xovô nêbê he ya Sadyusi dɨ he ya Palisi om keac levac vô he kaunsil ên nêbê, “Xam lige, mag ge Palisi dɨ a ga Palisi, dɨ a vông i vin ên a nêbê xomxo yibên obêc kɨdi lec tii vac, lêc gwêbaga xomxo vông kɨyang vô a lec kɨyang tige.” ");
INSERT INTO ptp_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Pol nêl bêge om he Palisi yuu Sadyusi kunacma dɨ le kɨdu yuu, ");
INSERT INTO ptp_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","ên he Sadyusi nêl nêbê xomxo yibên ob kɨdi lec i tii vac lêm, dɨ he nêl ên nêbê angela dɨ xomxo kɨnu o dô lêm. Lêc he Palisi vông i vin kɨyang tigee vɨhati. ");
INSERT INTO ptp_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Om he nêlma levac dɨ hɨgac vôma dɨ he Palisi wê tɨxuu xomxo ya Moses xolac gee he ya kɨdi lec dɨ nêl ên nêbê, “Xe o tulec soên ti vô xomxo tige lêm. Angela hɨxôn xomxo kɨnu mêd lam nêl kɨyang vô i.” ");
INSERT INTO ptp_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","He kunacma mabu yocên om xomxo vevac levac tyo xona nêbê he ob tɨtê Pol vôma lêc yib, om nêl vô nue vevac ên nêbê, “Xam loc kô Pol vac he mahɨgun dɨ kô mɨ loc vac xumac wê il vông ge.” ");
INSERT INTO ptp_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Vô bucên hig ge Apumtau lam le vô Pol manôn dɨ nêl ên nêbê, “Ông xonaên i ma, ên ông nêl a kɨtong gê Jelusalem om ông obêc la nêl a kɨtong gê Lom hɨxôn.” ");
INSERT INTO ptp_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Vɨgwe vɨdiiên he Yuda kɨtucma dɨ hɨlu kɨyang bêga nêbê, “Il ob hi Pol i yib, om il ob ngɨbua susu yaên hɨxôn mia numên dɨ i loc tyip lec buc wê il ob hi Pol i yib ge.” ");
INSERT INTO ptp_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","He wê hɨlu kɨyang tige tɨyi xocbê kehe yuu (40). ");
INSERT INTO ptp_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Mêd he la vô xomxo levac wê mi si daa gee hɨxôn he Yuda levace dɨ nêl vô he ên nêbê, “Xe vɨhati hɨlu kɨyang bêga ên xe nêbê xe ob xa yaên ti lêm dɨ i loc tyip lec buc wê xe ob hi Pol i yib ge. ");
INSERT INTO ptp_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Om xam hɨxôn kaunsil, xam vông kɨyang i loc vô xomxo vevac levac tyo bê i kô Pol mɨ lam vô xam ên xam ob ngôvô kɨyang kehe, dɨ xe ob viac xe pyap dɨ obêc val môp mahɨgun ti dɨ xe ob hi i yib.” ");
INSERT INTO ptp_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","He nêl bêge, lêc Pol vɨwa ngɨvihi ti ngô wê he nêb ob hi Pol i yib ge om la vac tɨbii vevac ben dɨ la nêl kɨyang tige kɨtong vô yihi. ");
INSERT INTO ptp_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Om Pol keac tɨbii vevac levac ti val dɨ nêl vô i ên nêbê, “Kô xomxo ngɨvihi tiga mɨ loc vô xomxo levac wê viac tɨbii vevac ge ên ob nêl kɨyang ti vô i.” ");
INSERT INTO ptp_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Om tɨbii tige kô i mɨ la vô tɨbii vevac levac tyo dɨ nêl vô i ên nêbê, “Pol ti wê il hôm i xôn ge keac a la vô i ên nêb a kô xomxo ngɨvihi tiga mɨ lam vô ông, ên xomxo ngɨvihi tiga ob nêl kɨyang ti vô ông.” ");
INSERT INTO ptp_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Mêd xomxo levac tige kô ngɨvihi tyo mɨ yuu la le vɨyonên dɨ kɨnêg vô i ên nêbê, “Ông ob nêl kɨyang vatya vô a?” ");
INSERT INTO ptp_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Om ngɨvihi tyo nêl vô i ên nêbê, “He Yuda hɨlu kɨyang xôn nêbê he ob vông kɨyang i lam vô ông ên nêb tɨtige ông kô Pol mɨ loc vô he kaunsil. He kɨtyoo ên he nêb he ob ngô i nên kɨyang kehe i tii vac. ");
INSERT INTO ptp_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Om ông o lêc ngô he vya lêm, ên he lie 40 dô vac môp ên nêb ob hi Pol i yib, ên he hɨlu kɨyang bêga nêbê he ob ngɨbua yaên hɨxôn numên dɨ i loc tyip lec buc wê he ob hi Pol i yib ge. Dɨ gwêbaga he dô bin ông nêb ông tyuc lec kɨyang wê he nêl ge.” ");
INSERT INTO ptp_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Mêd tɨbii vevac levac tyo vông ngɨvihi tige lax mɨ la dɨ nêl kɨyang xêkɨzêc vô i nêbê, “Ông o lêc nêl kɨtong vô xomxo ti bê ông lam nêl kɨyang tige vô a lêm.” ");
INSERT INTO ptp_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Mêd tɨbii vevac levac tige keac nue yuu wê mɨla le ngɨduên wê i vông ge lam dɨ nêl vô yuu ên nêbê, “Muu kô xomxo vevac 200 hɨxôn xomxo vevac 70 wê ob lec xôhô gee dɨ xomxo 200 wê ob kô yii ge, dɨ xam loc Sisalia vô bucên lec hɨyôv manôn xocbê 9 klok. ");
INSERT INTO ptp_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Dɨ xam viac xôhô ya ên Pol i dô lec ti, dɨ xam viac i nivɨha dɨ kô i mɨ loc vô gavman levac Piliks.” ");
INSERT INTO ptp_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Dɨ tɨbii levac tige kɨvuu kɨpihac ti vô Piliks bêga nêbê, ");
INSERT INTO ptp_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“A, Klodias Lisias, a kɨvuu kɨpihac tiga vô ông gavman levac Piliks. Vɨdiiên nivɨha i loc vô ông. ");
INSERT INTO ptp_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Xomxo tiga, he Yuda hôm i xôn dɨ hi i ên nêb ob hi i yib, lêc a ngô wê i Lom ti ge, om a hɨxôn nuge vevac, xe la kô i vêl ên he Yuda vɨgê. ");
INSERT INTO ptp_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","A nêb a ob ngô kɨyang wê he nêl lec xomxo tige kehe, om a kô i mɨ la vô kaunsil wê he Yuda vông ge. ");
INSERT INTO ptp_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Mêd a ngô kɨyang wê he nêl lec i ge, lêc kɨyang tige tɨyi xocbê xolac wê heche va vông ge, dɨ a xovô ên a nêbê kɨyang tige o tɨyi wê il ob tung i la vac kalabuhu dɨ hi i yib ge lêm. ");
INSERT INTO ptp_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Nang dêc xomxo ti lam nêl kɨtong vô a ên nêbê he Yuda hɨlu kɨyang nêb he ob hi xomxo tige i yib, om a vông i loc vô ông lutibed. Dɨ a nêl vô he Yuda wê vông kɨyang vô i ge ên a nêbê he i loc nêl kɨyang wê he nêl lec i ge vô ông.” Kɨpihac nêl bêge. ");
INSERT INTO ptp_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Mêd nue vevac vông i tɨyi wê tɨbii levac tige nêl vô he ge om he kô Pol dɨ la bucên dɨ mɨla vɨgwe Antipatlis. ");
INSERT INTO ptp_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Dɨ vɨgwe vɨdiiên tɨbii vevac wê la kɨbun gee hɨxôn he wê kô yii ge lax mɨ la ben, dɨ he wê dô lec xôhô gee la hɨxôn Pol mɨ he la. ");
INSERT INTO ptp_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","He mɨla Sisalia mêd vông kɨpihac vô gavman levac Piliks dɨ vông Pol la hɨxôn. ");
INSERT INTO ptp_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Mêd Piliks kɨtong kɨpihac tyo dɨ kɨnêg vô Pol ên nêbê, “Ông lam vac vɨgwe levac tina?” Om Pol nêl ên nêbê, “A bog Silisia.” ");
INSERT INTO ptp_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","Mêd Piliks nêl ên nêbê, “Xomxo wê nêl kɨyang lec ông ge obêc val ge od a ob ngô kɨyang wê ông vông.” Pyap mêd nêl vô nue vevac ên nêb he i kô Pol mɨ loc tung vac gavman xumac wê Helot lox ilage dɨ he i yê i xôn. ");
INSERT INTO ptp_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Buc vɨgê vɨlu lam la vêl dêc Ananaias wê xomxo daa siên nên levac ge hɨxôn Yuda levac ya dɨ xomxo ti wê ob nêl xomxo nên kɨyang vô gavman ge lê nêbê Tetalas, he la vô gavman levac Piliks ên he nêb he ob vông kɨyang vô Pol. ");
INSERT INTO ptp_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Om Piliks keac Pol lam dɨ Tetalas nêl kɨyang kɨtyooên ya lec Pol bêga nêbê, “Xomxo levac Piliks, ông viac xe nivɨha om xe dô nimvɨha dɨ vevac ti o tyip vac xe bom lêm, dɨ ông kɨtya môp nipaên vêl dɨ vông xe dô vac môp nivɨha wê ob vô nivɨha vô xe ge. ");
INSERT INTO ptp_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Om môp tige vông xe xêmyaa vô nivɨha dɨ xe hi vɨxam ên ông tɨyi buc vɨhati. ");
INSERT INTO ptp_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","“A ob nêl kɨyang dia vô ông lêm, lêc a kɨtaa ông bê ông xêmyaa i vô nivɨha dɨ ông ngô kɨyang bo ti wê a ob nêl vô ông ga. ");
INSERT INTO ptp_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Xomxo tige, xe xê ên xe nêb i xomxo judaên, ên la vông Yuda vac vɨgwe vɨhati he nɨlô juda dɨ he o dô nivɨha lêm, dɨ xomxo kɨdu ti wê nêbê Nasalet ge ici va tu he nên xomxo levac. ");
INSERT INTO ptp_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Dêc nêb ob vông Anutu xumac ngɨbua i vô nipaên om xe la hôm i xôn. Ên xe nêb xe ob vông kɨyang vô i lec kɨyang wê yêp vac Moses xolac ge, ");
INSERT INTO ptp_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","lêc tɨbii vevac levac Lisias val tii xe sea dɨ kô Pol mɨ la, ");
INSERT INTO ptp_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","dɨ nêl ên nêbê xomxo wê nêb ob vông kɨyang vô Pol ge, he i lam nêl kɨyang vô ông. Om ông obêc kɨnêg xomxo tyo ge od ông obêc ngô kɨyang wê xe nêl lec i ge vɨhati vac i mya.” ");
INSERT INTO ptp_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Tetalas nêl bêge dɨ Yuda vɨhati ngɨdu i kɨyang xôn dɨ nêl ên nêbê kɨyang vɨhati ge vɨxôhɨlôg nôn. ");
INSERT INTO ptp_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Mêd Piliks too kwa vô Pol ên nêb i nêl i kɨyang, om Pol nêl ên nêbê, “A xovô wê ông viac kɨyang wê xe Yuda vông ge vac ilage dɨ i val tyip gwêbaga hɨxôn, om a xêgyaa nivɨha ên wê a ob nêl kɨyang wê a vông ge vô ông. ");
INSERT INTO ptp_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Ông obêc kɨnêg vô xomxo ya ge od he ob nêl vô ông bê a la Jelusalem dɨ la kɨtaa vô Anutu dɨ buc vɨgê yuu dɨ tô mɨ la yuu lam la vêl dɨ i val gwêbaga. ");
INSERT INTO ptp_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Dɨ he Yuda o yê wê xe ngaênma lec kɨyang ya vac xumac ngɨbua ge lêm, dɨ a o kɨtuc xomxo tɨbeac vac xumac lɨlo me lec wetôv dɨ vông he xêyaa vô myavɨnê lêm. ");
INSERT INTO ptp_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Kɨyang kɨtyooên wê he nêl lec a ge, he o tɨyi wê he ob nêl kɨyang kehe kɨtong mɨ ông xovô bê kɨyang nôn lêm. ");
INSERT INTO ptp_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","“Lêc a ob nêl a kɨtong seac bêga bê kɨyang wê he Yuda yê tɨyiên ma ge, vɨxôhɨlôg, a mi tɨmu vô. Lêc a tɨmu vô môp tige dɨ a kɨtaa vô Anutu wê buge mi kɨtaa vô ilage, dɨ a vông i vin Moses xolac hɨxôn plopete kɨyang wê yêp vac kɨpihac ge vɨhati. ");
INSERT INTO ptp_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Dɨ a vông i vin dɨ dô bin kɨyang wê nêl ên nêbê xomxo vɨhati, nipaên yuu xôn nivɨha, obêc kɨdi lec mavɨha tii vac. Dɨ he Yuda êno vông i vin kɨyang tige mɨ dô bin. ");
INSERT INTO ptp_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Om a vông môp nivɨha tɨyi buc vɨhati ên a nêb a nɨlôg i yêp nivɨha, dɨ Anutu hɨxôn xomxo he i yê a nivɨha. ");
INSERT INTO ptp_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","“A la dô klismas ya la vêl vac vɨgwe ya, nang dɨ a la Jelusalem ên a nêb a ob vông mone vô lige Yuda wê nên susu maên gee dɨ a nêb a ob tung daa vô Anutu. ");
INSERT INTO ptp_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","A viac môp tige om a tɨmu vô môp wê ob vông a vô paha lec ge, pyap dɨ he Yuda yê wê a la vac Anutu xumac ngɨbua ge. Xomxo tɨbeac o dô hɨxôn a dɨ vô nidɨdun levac lêm, ");
INSERT INTO ptp_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","lêc he Yuda wê lam gê Esia ge he val hôm a xôn. Xomxo tigee, a nêg kɨyang ti obêc yêp vô he ge od he i lam nêl vô ông dɨ obêc nivɨha. ");
INSERT INTO ptp_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Lêc obêc ma ge od xomxo wê dô gae he i nêl a nêg soên wê he tulec vô buc wê a la le vô he kaunsil manôn ge. ");
INSERT INTO ptp_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Kɨyang tibed wê a le vô kaunsil manôn dɨ a nêl bêga ên a nêbê, ‘A vông i vin ên a nêbê Anutu obêc tɨpi vô xomxo yibên kɨdi lec i tii vac om gwêbaga xam vông kot vô a lec kɨyang tige tibed.’” ");
INSERT INTO ptp_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Pol nêl bêge, lêc Piliks xovô kɨyang yuu môp wê xomxo vông vinên vông ge om nêl vô he Yuda ên nêbê, “Xam dô dɨ xomxo levac Lisias obêc val ge od a obêc tɨtô kɨyang wê xam vông ge.” ");
INSERT INTO ptp_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Mêd Piliks nêl vô tɨbii vevac tige ên nêbê, “Viac Pol nivɨha dɨ ông wê i xôn dɨ i o lêc dô kɨzêc lêm, dɨ ông o lêc vɨbu lie wê nêb ob lam vông susu ya vô i ge lêm.” ");
INSERT INTO ptp_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Buc ya la vêl dêc Piliks yuu vɨnê Dlusila keac Pol lam vô yuu. Dlusila ge Yuda vêx ti. Om yuu ngô kɨyang wê Pol nêl lec môp wê xomxo ob vông i vin Yesu Kɨlisi ge kehe kɨtong. ");
INSERT INTO ptp_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Dêc Pol nêl kɨyang lec môp nivɨha hɨxôn môp wê xomxo ob kol he ên nipaên ge dɨ nêl lec wê Anutu obêc tɨtô xomxo nên kɨyang vô buc tɨmuên ge. Piliks ngô kɨyang tige dɨ xona om nêl vô Pol ên nêbê, “Kɨyang pyap om ông loc, dɨ obêc buc ngwe nang dɨ a obêc keac ông lôm i tii vac.” ");
INSERT INTO ptp_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Dêc Piliks xo vac nɨlô ên nêbê mêd Pol obêc vông mone ya vô i om keac Pol la vô i tɨyi buc tɨbeac dɨ yuu keac mɨ dô. ");
INSERT INTO ptp_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Klismas yuu lam la vêl dêc Posias Pestas la kô vɨgwe wê Piliks vông ge. Dɨ Piliks xo nêbê he Yuda i yê i nivɨha, om sea Pol dô vac kalabuhu dɨ i loc mɨ la. ");
INSERT INTO ptp_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Pestas val dô vac vɨgwe wê ob viac ge dɨ buc yon la vêl dɨ i sea Sisalia dɨ la Jelusalem. ");
INSERT INTO ptp_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Mêd xomxo levac wê mi si daa vô Anutu gee hɨxôn lie levac ya he la vô Pestas dɨ so kɨyang lec Pol dɨ nêl vô Pestas ên nêbê, ");
INSERT INTO ptp_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","“Xe kɨtaa ông bê ông vông Pol i lam Jelusalem.” He nêl bêge ên he nêb Pol obêc val vô he vac môp mahɨgun ti ge od he ob hi i yib. ");
INSERT INTO ptp_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Lêc Pestas nêl vô he ên nêbê, “Pol la dô kalabuhu gê Sisalia, dɨ a ob dô buc myabo tya dɨ a ob la Sisalia. ");
INSERT INTO ptp_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Om xam levac ya lam hɨxôn a, ên i nên soên ya obêc yêp ge od xam vông kot vô i.” ");
INSERT INTO ptp_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Om Pestas dô hɨxôn he tɨyi buc vɨgê vɨlu dɨ sec yon me buc vɨgê yuu dêc la Sisalia. Dɨ vɨgwe vɨdiiên Pestas la dô vac xumac kot dɨ nêl vô nue ên nêb he i loc kô Pol mɨ lam. ");
INSERT INTO ptp_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Pol val dɨ he Yuda wê lam gê Jelusalem gee le hɨxôn Pol dɨ so kɨyang tɨbeac lec i. Lêc kɨyang wê he nêl ge, nôn ti o yêp vac lêm. ");
INSERT INTO ptp_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Mêd Pol nêl vô he ên nêbê, “A o nêl kɨyang nipaên ti lec xolac wê il Yuda vông dɨ Anutu xumac ngɨbua dɨ Lom gavman lêm.” ");
INSERT INTO ptp_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Pestas ngô kɨyang tige lêc xo nêb he Yuda i yê i nivɨha om nêl vô Pol ên nêbê, “Ông obêc nêb ông ob la Jelusalem ge od a ob ngô kɨyang wê ông vông ge gê Jelusalem.” ");
INSERT INTO ptp_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Lêc Pol nêl ên nêbê, “Xumac wê a le vac ga, king Sisa xumac wê ob ngô kɨyang wê a vông. Ông xovô pyap bê a o vông soên ti vô he Yuda lêm. ");
INSERT INTO ptp_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","A nêg soên ti obêc yêp tɨyi wê xam ob hi a xib lec ge od pyap, lêc kɨyang wê he Yuda nêl lec a ge nôn obêc ma ge od xam ti tɨyiên ma wê xam ob vông a la vac he vɨgê ge. A nêl bêga bê king Sisa ob ngô kɨyang wê a vông ge i tii vac nang.” ");
INSERT INTO ptp_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Mêd Pestas he nue kaunsil viac kɨyang vôma, pyap dêc Pestas la nêl vô Pol ên nêbê, “Ông nêb ông ob la vô Sisa, om ông loc vô Sisa ên i ngô kɨyang wê ông vông ge.” ");
INSERT INTO ptp_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Buc ya la vêl dɨ Yuda gavman levac ti lê nêbê king Aglipa yuu li vêx Benaisi mɨla Sisalia nêb yuu ob la yê Pestas. ");
INSERT INTO ptp_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Yuu dô buc ya lam la vêl dɨ Pestas nêl Pol kɨyang kɨtong vô king Aglipa bêga nêbê, “Ilage Piliks tung xomxo ti la kalabuhu lêc sea i dô dɨ la, ");
INSERT INTO ptp_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","dɨ buc wê a la Jelusalem ge he Yuda levac wê mi si daa gee hɨxôn lie levac ya he nêl vô a ên nêb a tɨtô kɨyang wê i vông ge. ");
INSERT INTO ptp_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Lêc a nêl vô he ên a nêbê môp wê xe Lom vông ge ti o yêp wê xe ob vông myavɨwen vô xomxo ti vaxvax ge lêm. Xomxo ti kɨyang obêc yêp vô i ge od ob la le hɨxôn xomxo wê vông kɨyang vô i ge dɨ ici va ob nêl kɨyang wê i vông ge kɨtong. ");
INSERT INTO ptp_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","“Om he Yuda lam ga hɨxôn a, dɨ a o val dô seac vêl lêm. Nge, vɨgwe vɨdiiên a la dô vac xumac kot dɨ nêl mɨ he kô Pol mɨ lam vô a. ");
INSERT INTO ptp_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Mêd he Yuda kɨdi lec nêb ob vông kɨyang vô Pol, dɨ a xo ên a nêbê he ob nêl soên levac ti lec Pol, lêc he o nêl lêm, ");
INSERT INTO ptp_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","dɨ he nêl kɨyang lec môp wê he Yuda mi kɨtaa vô Anutu ge dɨ nêl lec xomxo ti lê nêbê Yesu wê yib lêc Pol nêl nêbê xomxo tige kɨdi lec, om he vông kot vô Pol lec kɨyang tige. ");
INSERT INTO ptp_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","A nêb a ob xovô kɨyang tige kehe, lêc a pɨyôp ob la tɨyi lêm. Om a nêl vô Pol ên a nêbê, ‘Ông obêc nêb ông ob la Jelusalem ge od a ob ngô ông nêm kɨyang gê Jelusalem.’ ");
INSERT INTO ptp_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Lêc Pol nêb ob dô kalabuhu dêc king Sisa vaci obêc ngô kɨyang wê i vông ge. Om a nêl vô a nuge vevac ên a nêb he i viac Pol nivɨha dɨ i mɨloc vô buc wê a obêc vông i loc vô king Sisa ge.” ");
INSERT INTO ptp_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Pestas nêl bêge dɨ Aglipa nêl vô Pestas ên nêbê, “Aca va ob ngô xomxo tige nên kɨyang.” Om Pestas nêl ên nêbê, “Tɨtige ông ob ngô i nên kɨyang.” ");
INSERT INTO ptp_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Mêd vɨgwe vɨdiiên Aglipa yuu li Benaisi val hɨxôn vunac vunac, dɨ yuu hɨxôn tɨbii vevac levac ya dɨ tɨbii Sisalia levac ya la vac xumac kɨtucmaên. Dɨ Pestas nêl dɨ tɨbii vevac kô Pol mɨ lam. ");
INSERT INTO ptp_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Mêd Pestas nêl ên nêbê, “King Aglipa, hɨxôn xam vɨhati wê xam val dô hɨxôn xe gee, xam wê xomxo tiga. Ên he Yuda wê dô ga hɨxôn he wê dô Jelusalem gee, he vɨhati so vya vô i dɨ nêl vya levac vô a ên nêb a hi i yib. ");
INSERT INTO ptp_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Lêc a o tulec kɨyang ti tɨyi wê il ob hi i yib lec ge lêm. Dɨ ici va nêb king Sisa vaci ob ngô kɨyang wê i vông ge, om a nêb a ob vông i loc vô king Sisa. ");
INSERT INTO ptp_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Lêc a o tulec kɨyang soên ti vô i wê a ob kɨvuu kɨpihac i loc vô il xomxo levac Sisa ge lêm. Om king Aglipa, a kô xomxo tige mɨ lam vô ông hɨxôn xam vɨhati ên a nêb il xôn vɨhati ob ngô kɨyang wê i vông ge dɨ il obêc tulec kɨyang ya vô i ge od a ob kɨvuu vac kɨpihac. ");
INSERT INTO ptp_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Ên a xo ên a nêbê a obêc vông xomxo ti i loc vô Sisa, lêc a obêc nêl kɨyang ti wê xomxo vông kot vô i ge kɨtong lêm ge, od ge tɨyiên ma.” ");
INSERT INTO ptp_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Mêd Aglipa nêl vô Pol ên nêbê, “Ông nêl ông kɨyang ên xe ob ngô.” Om Pol vɨgê la kɨsii dɨ i nêl i kɨyang kɨtong bêga nêbê, ");
INSERT INTO ptp_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","“King Aglipa, gwêbaga a xêgyaa vô nivɨha ên wê a ob nêl kɨyang wê he Yuda so lec a ge kɨtong vô ông, ");
INSERT INTO ptp_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","ên ông xovô môp wê xe Yuda vông ge vɨhati hɨxôn kɨyang wê xe mi nêlma lec ge, om a kɨtaa ông bê ông ngô kɨyang wê a ob nêl ga dɨ ông nim i o lêc ma lec lêm. ");
INSERT INTO ptp_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","“He Yuda vɨhati xovô ên he nêbê ilage wê a gên nipwo dɨ i lam tyip gwêbaga, a dô hɨxôn lige vac xe bom dɨ a la dô Jelusalem. ");
INSERT INTO ptp_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","He Yuda xovô a ilage om he obêc nêb nêl a kɨtong ge od he ob nêl bê a mi tɨmu vô môp wê xe Palisi vông ge vɨhati nivɨha. Xe Palisi ge, xe vông yuac levac lec môp kɨtaaên hɨxôn môp ya luu Yuda vông môp ya vêl. ");
INSERT INTO ptp_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Lêc gwêbaga he vông kɨyang vô a dɨ a lam le vô ông mamnôn ên wê a vông i vin dɨ a dô bin kɨyang wê Anutu hɨlu vô buge ilage nêb obêc vô nôn lec tɨmuên ge. ");
INSERT INTO ptp_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","He Yuda wê hɨpu vɨgê yuu dɨ tô mɨ la yuu ge he vông i vin kɨyang tige dɨ he kɨtaa xêkɨzêc vô Anutu tɨyi bucên yuu vɨdiiên vɨhati dɨ dô bin kɨyang tige. King Aglipa, a êno vông i vin kɨyang tige, lêc gwêbaga he Yuda vông kɨyang vô a lec kɨyang tige. ");
INSERT INTO ptp_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Bêna lêc xam ya xo ên xam nêbê Anutu o tɨyi wê ob tɨpi vô xomxo vac yibên ge lêmê? ");
INSERT INTO ptp_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","“Ilage a xo ên a nêbê a obêc vông Yesu Nasalet lê vô nipaên ge od obêc nivɨha, ");
INSERT INTO ptp_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","om a la vông môp tibêge gê Jelusalem. Dɨ xomxo levac wê mi si daa gee tyuc lec, nêb a la kô xomxo wê vông i vin Yesu ge mɨ lam tung he i loc vac kalabuhu, dɨ buc wê he hɨlu kɨyang nêb he ob hi xomxo vông vinên i yib ge od a tyuc lec. ");
INSERT INTO ptp_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Dɨ buc tɨb