﻿USE sofia;
DROP TABLE IF EXISTS sofia.prq_vpl;
CREATE TABLE prq_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES prq_vpl WRITE;
INSERT INTO prq_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Owakira itanta-nakari iwitsikan-taitzi, iriitakira Pawa owitsika-kirori inkiti aajatzi kipatsi. ");
INSERT INTO prq_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Tima tikatsi tzima-tsini kipatsiki, oyosiita inkaari, tsitiniki okantaka. Apatziro ikantakaaro Itasorinka Pawa, okinawaitzi inkaariki. ");
INSERT INTO prq_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Ari iñaa-waitanaki Pawa, ikantzi: “Onkitainkati”, mata-naka ikantakiri. ");
INSERT INTO prq_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Iñaatziiro Pawa kamiitha okantaka kitainkari. Inasi-takaro kitainkari, ti intsipatairo tsitinikiri. ");
INSERT INTO prq_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Ari ipai-takiro Pawa iroka kitainkari, “Kitaitiri”. Irooma tsitinkiri ipai-takiro “Tsitiniri”. Ari otsitini-tanaki ipoñaa okitai-tamanai. Iroo-taki aparo-nitain-tsiri iroka kitaitiri. ");
INSERT INTO prq_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Ipoñaa iñaa-waitanaji Pawa, ikantzi: “Ontzimi otziki-roni nijaa-payi, iroo-taki inasityaaroni.” ");
INSERT INTO prq_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Imata-kiro Pawa, tzima-naki otziki-rori nijaa. Tzimatsi nijaa saika-nain-tsiri jinokinta, pasini otapinaki. Mataka ikanta-kiri. ");
INSERT INTO prq_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Ipai-takiro Pawa otziki-rori nijaa “inkiti”. Ari otsitini-tanaki ipoñaa okitai-tamanai. Iroo-taki apiti-tanain-tsiri iroka kitaitiri. ");
INSERT INTO prq_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Ipoñaa iñaa-waitanaji Pawa, ikantzi: “Apatotyaa nijaa-payi okaratzi tzima-tsiri otapinaki inkiti, ontzimi tsika ompiryaa-pathati.” Mata-naka. ");
INSERT INTO prq_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Ipai-takiro Pawa tsika opiryaa-patha-tanaki “kipatsi”. Irooma tsika apatotanaka nijaa ipai-takiro “inkaari”. Ikanta yamina-kiro Pawa kamiitha okantaka. ");
INSERT INTO prq_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Ari ikantzi Pawa: “Oshooki kipatsiki nasiyita-chari inchato aajatzi pankirintsi, tzimatsini okithoki ithotaitziri aajatzi iwaityaari.” Matanaka ikantakiri. ");
INSERT INTO prq_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Ari oshookanaki kipatsiki nasiyita-chari inchato aajatzi pankirintsi. Tzimayi-tanaki okithoki inchato-payi. Ari okimitakari pankirintsi-payi. Yaminakiro Pawa iroka-payi kamiitha okantaka. ");
INSERT INTO prq_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Ari otsitini-tanaki ipoñaa okitai-tamanaji. Iro mawa-tanain-tsiri iroka kitaitiri. ");
INSERT INTO prq_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Ipoñaa ikantzi Pawa, ikantzi: “Intzimi inkitiki oorinta-chani, iriitaki inasi-takaityaa-roni kitaitiri aajatzi tsitiniri. Irootaki iyoi-tantyaa-rori kitaitiri-payi, osarintsi-payi, aajatzi kitaitiri yoimosirinkantaitari, ");
INSERT INTO prq_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","Iriitaki oorintaachani inkitiki inkitainkatairo kipatsiki.” Matanaka inkantakiri Pawa. ");
INSERT INTO prq_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Ari iwitsika-kiri Pawa apiti oorinta-chari. Aparoni antariiti oorinta-chani kitaitiriki, iriima pasini kiripiri oorinta-chani tsitiniriki. Ari iwitsika-kiriri aajatzi maaroni impokiro-payi. ");
INSERT INTO prq_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Iwakiri Pawa inkitiki, iriitaki kitainka-takayi-roni maaroni kipatsi, ");
INSERT INTO prq_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","kitaitiri aajatzi tsitiniri. Irootaki iyotan-taityaarori kitaitiri aajatzi tsitiniri. Ikanta yamina-kiri Pawa yoka-payi kamiitha ikantaka. ");
INSERT INTO prq_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Ari otsitini-tanaki ipoñaa okitai-tamanaji. Irootakira 4-tatsiri kitaitiri. ");
INSERT INTO prq_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Ipoñaa iñaa-waitanaji Pawa, ikantzi: “Ishikiti nijaaki nasiwai-tachari nijaawiri, aajatzi siwanki-ripayi arayi-tatsini kipatsiki.” ");
INSERT INTO prq_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Tima iwitsika-kiri Pawa antari-payi inkaari-wiri, aajatzi maaroni inasiwaitachari nijaawiri, oshiki-yitanaji, Iwitsika-kiri siwanki-tatsiri arayi-tatsiri. Ikanta yamina-kiri Pawa yoka-payi kamiitha ikantaka. ");
INSERT INTO prq_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Itasonka-nakiri Pawa, ikantziri: “Intzima-yitaji yanini-payi, ishikitan-tajyaari nijaaki-payi. Ari inkimitai-yaari aajatzi siwankiri-payi ishikiyitai kipatsiki.” ");
INSERT INTO prq_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Ari otsitini-tanaki ipoñaa okitai-tamanai. Irootaki 5-tatsi iroka kitaitiri. ");
INSERT INTO prq_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Ipoñaa iñaa-waitanaji Pawa, ikantzi: “Ishikitai kipatsiki ikaratzi nasitachari, piratsi-payi ipirai-tari, antami-wiri, konthaayi-tatsiri, maaroni tzimatsiri kipatsiki aajatzi.” Mata-naka ikantakiri. ");
INSERT INTO prq_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Ikanta iwitsika-yita-kiri Pawa yoka-payi kamiitha ikantaka. ");
INSERT INTO prq_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Ipoñaa iñaa-waitanaji Pawa, ikantzi: “Iroñaaka thami awitsiki atziri kimitaini aroka. Iri mati-roni yanairi nijaa-wiri, siwankiripayi, piratsi-payi ipiraitari, maaroni tzimatsiri kipatsiki, ari inkimi-tairiri ikaratzi konthaayitatsiri kipatsiki.” ");
INSERT INTO prq_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Imatakiri Pawa iwitsika-kiri atziri, ari ikimi-takiri tsika ikanta irirori. Iwitsikaki sirampari ipoñaa kooya. ");
INSERT INTO prq_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Ari itasonkanakiri Pawa ikantziri: “Piwaiyanti pishikitantyaari. Pinampi-taiyaaro maaroni kipatsiki, pimpinkathari-wintanti. Iyotani pinkantyaa panairi maaroni tzimatsini aka kipatsiki. Panairi siwankiri-payi, piratsi-payi ipirai-tari, antami-wiri, aajatsi ikaratzi konthaayitatsiri kipatsiki.” ");
INSERT INTO prq_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Ari ikanta-naki Pawa: “Nopi-miro okaratzi shookatsiri kipatsiki tzima-tsiri okithoki, aajatzi inchato-payi okaratzi kitho-yitatsiri. Iro piwa-yitajyaari awirokaiti. ");
INSERT INTO prq_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Iriima antami-wiripayi, konthaayitatsiri kipatsiki, siwanki-yita-tsiri, iwaitajyaaro incha-sipayi.” Mata-naka ikanta-kiri Pawa. ");
INSERT INTO prq_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Yamina-kiri Pawa ikaratzi iwitsika-kiri kamiitha ikantaka. Ari otsitini-tanaki ipoñaa okitai-tamanai. Iro 6-tatsiri iroka kitaitiri. ");
INSERT INTO prq_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Aritaki iwitsikai-takiro okaratzi tzimatsiri inkitiki aajatzi kipatsiki. ");
INSERT INTO prq_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Tima irootaki 7-tatsiri kitaitiri ithonkan-takarori Pawa maaroni iwitsika-yitakiri. Ari imakoryaa-paaki irirori. ");
INSERT INTO prq_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Itasonka-kiro Pawa iroka 7-tatsiri kitaitiri, ikantaki: “Tasonkaaro onatyii iroka kitaitiri.” Tima iroka kitaitiri irootaki imakoryaan-takari Pawa iwitsika-yitantaka-rori okaratzi tzimayi-tatsiri. ");
INSERT INTO prq_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Iroka ikinkitha-takoi-tziro owitsikan-takari inkiti aajatzi kipatsi. Tima pairani owakira iwitsika-kiro Pawa inkiti aajatzi kipatsi, ");
INSERT INTO prq_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","tikatsi pankirintsi shooka-tsini, tikatsi aajatzi towari-payi. Ti iwaryiiro inkani kipatsiki, tikatsi antawai-tatsini. ");
INSERT INTO prq_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Apatziro ositowaatzi nijaa kipatsiki, irootaki tsinka-patha-tzirori maaroni. ");
INSERT INTO prq_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Ipoñaa yaaki Pawa kipatsi iwitsika-kiri atziri. Itasonka-kiri ikirimasiki, añaanaki. Aripaiti yañaanaki itanakarori atziri. ");
INSERT INTO prq_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Ikantakaa-karo Pawa ontzimi pankirin-tsimasi tsika isitowa-piintzi ooryaatsiri, ipaitakiro Posiñaarini. Ari imisaika-kiri yoka atziri iwitsika-kiri. ");
INSERT INTO prq_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Ari ishookakaaki Pawa inasiwai-tachari pankirin-tsipayi, owaniinka-yitachari, okaratzi iwaitari okithoki. Ishookakaaki aajatzi niyaankiniki pankirin-tsimasi apiti pankirintsi. Aparoni yañaantaitari, pasini iyotantai-tarori kamiithari aajatzi kaaripirori. ");
INSERT INTO prq_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Tzimatsi anta Posiñaariniki aparoni nijaa, irootaki tsinkirori pankirin-tsimasi. Tzimatsi iroka nijaa okaratzi 4 ochiwaa. ");
INSERT INTO prq_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Itanakarori ochiwaa ipaitai-tziro Sinchaari, irootaki tapotachari anta Tapotaariniki, ari itzimiri ooro. ");
INSERT INTO prq_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Iriipirori inatzi ooro tzimatsiri anta, tzimatsi iriipirori tziritatsiri, tzimatsi aajatzi mapipayi poriryaa-tatsiri. ");
INSERT INTO prq_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Irooma apiti-tatsiri ochiwaa ipaitai-tziro Sipopojaarini, irootaki tapotachari anta Kisaapororiniki. ");
INSERT INTO prq_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Iroka pasini mawatatsiri ochiwaa ipaitai-tziro Tampishaarini, irootaki tapotachari anta tsika isitowa-piintzi ooryaatsiri Aatzikawiniki. Pasini 4-tatsiri ochiwaa, irootaki ipaitai-tziri Antaraani. ");
INSERT INTO prq_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Aritaki imisaika-kiri Pawa yoka atziri pankirin-tsimasiki Posiñaariniki, iriitaki kaankiityaa-kotzirori pankirin-tsimasi, yaamaakowin-tyaaro aajatzi. ");
INSERT INTO prq_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Iroka ikantakiri: “Kamiitha-tatsi pinthotiro okaratzi tzimatsiri pankirin-tsimasiki. ");
INSERT INTO prq_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","Irooma okithoki pankirintsi iyotantai-tarori kamiithari aajatzi kaaripirori, airo pithotziro. Aririka pinthotakiro, aritaki pinkamaki.” ");
INSERT INTO prq_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Ipoñaa ikantanaki Pawa: “Ti okamiithatzi isaikawaiti apaniroini atziri. Ontzimatyii nowitsiki-niri amitako-tirini.” ");
INSERT INTO prq_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Tima owakira iwitsikan-taka-riri Pawa maaroni ipiraitari-payi, aajatzi maaroni siwankiri-payi, kipatsi yaaki. Yamakiniri atziri ipaitai-tziri aajatzi Adán, iwiniri iwairo-payi. Okaratzi iwakiniriri iwairo-payi iwitsikani Pawa, irojatzi iwairoyitari iroñaaka. ");
INSERT INTO prq_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Imatakiro Adán iwakiniri iwairo maaroni antami-wiri-payi, maaroni siwankiri-payi, aajatzi ipiraitari-payi. Titzimaita iñii aparoni amitako-tirini irirori. ");
INSERT INTO prq_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Ikantakaa-karo Pawa impochokiti Adán. Ikanta imaapiro-tanaki Adán, yayitakiri imiriki, iwitana-jiri kamiitha iwathaki. ");
INSERT INTO prq_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Irootaki imiriki atziri iwitsika-kiri Pawa aparoni kooya. Yamakiro Pawa iñiiro atziri. ");
INSERT INTO prq_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Ikanta iñaawakiro Adán, ikantanaki: ¡Naaka asitaro nowatha iroka! Irootaki notonki. Kooya ompaityaa, Tima iwatha sirampari iwitsikai-taki. ");
INSERT INTO prq_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Irootaki airo isaikantaja mainari-payi asitaririki aririka yaawakaa-najyaa, tima aparoni inkanta-najyaa iwathaki osiyawaityaaro iwichaa-wakaa-jyaami. ");
INSERT INTO prq_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Tima kaanki-miriki ikantaka atziri aajatzi iina, titzimaita ipasikijii-tzi. ");
INSERT INTO prq_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Pairani yotani ikantawita maranki, yanairi maaroni antami-wiri ikaratzi iwitsika-kiri Pawa. Ikanta apaata maranki ari isampitakiro kooya, ikantziro: “¿Omaapiroma ikantzimi Pawa: ‘Airo pithotziro okaratzi pankitachari pankirin-tsimasiki?’ ” ");
INSERT INTO prq_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Akanakiri kooya, okantziri: “Kantacha nonthotiro okaratzi pankitachari anta, ");
INSERT INTO prq_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","irooma satikainchari niyaanki-masiniki, airo nothotziro. Tima ikantakina Pawa: ‘Airo pithotziro ironta, airo pairikiro kapichiini, pikami = kari.’ ” ");
INSERT INTO prq_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Ikantzi maranki: “Thaiyaantsi, airo pikami. ");
INSERT INTO prq_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Tima iyotzi Pawa aririka pinthotakiro chochoki, ari piyotana-kiro kamiithari aajatzi kaaripirori, ari pinkimi-tanakyaari ikantara irirori.” ");
INSERT INTO prq_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Oñaatziiro kooya iroka chochoki kamiitha okantaka, oniwitana-karo onthotiro, onintzi ontzimi oyotani. Aakiro chochoki, othotakiro. Aanakiniri oimi, ithotakiro aajatzi irirori. ");
INSERT INTO prq_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Ari opisaityiimo-tanakiro, oñaatyaa osaika-miriki-jiitatzii. Aajiitaki osi pankirintsi, ositzikakiro, irootaki owasita-nakari. ");
INSERT INTO prq_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Okanta otampyiityaa-paaki tsitinii-tiini, ikimawaa-tziiri Pawa yaniitapaji pankirin-tsimasiki. Siyajii-tanaka imana-pithatari. ");
INSERT INTO prq_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Ikaimapaa-kiri Pawa, ikantziri: “¡Adán! ¿Tsikama pisaikika?” ");
INSERT INTO prq_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Ari yakanaki irirori, ikantzi: “Notharowakaatyaami, Pawa, nokimawaimi paniitapaji pankirin-tsimasiki, tima kaanki-miriki noñaaka, irootaki nomana-pitha-tantamiri.” ");
INSERT INTO prq_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Ari isampitana-kiri, ikantziri: “¿Paitama kantakimiri pisaika-mirikitatzii? ¿Pithotaki-roma chochoki nopinka-kaimiri?” ");
INSERT INTO prq_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Ari yakanaki atziri, ikantzi: “Kaarima kooya pipakinari nontsipa-tyaaro, irootaki opakinarori iroka chochoki nothotan-takarori.” ");
INSERT INTO prq_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Isampitana-kiro Pawa iroka kooya, ikantziro: “¿Paitama pantakiri?” Okantanaki iroori: “Tima yamatawi-takina naaka maranki, irootaki nothotan-takarori chochoki.” ");
INSERT INTO prq_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Ikantana-kiri Pawa yoka maranki: “Okantakaan-tziro pamatawi-takiro kooya, Misha-piro-taari pinatyii awiroka, panaajiri maaroni antami-wiri. Pasi piwiro pinkonthaan-tajyaaro pinii osaawiki, Kipatsi-yina pinkantajyaa piitoki. ");
INSERT INTO prq_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Nonkan-takai-yaaro onkisaniin-taimi kooya. Ari inkantajyaari osarintajyaari, Inkisaniin-tairi pasi awiroka. Iriitaki tsitokai-miniri piitoki, Ipatzi-kontaki patsi-kamatsi-tairi awiroka.” ");
INSERT INTO prq_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Ikantana-kiro kooya: “Antaro pinkimaatsi-taiyaa aririka piwaiyantai. Oshiki ayimataimi pinintzi yapititaiyaami piimi, Iro kantacha, oshiki impira-waitajyaami irirori.” ");
INSERT INTO prq_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Ikantana-kiri atziri: “Tima paawako-takiro piina, Pithotan-takarori nopinka-kaawitamiri. Awiroka kantakaan-taki-rori nomisha-tantyaarori iroka kipatsi. Oshiki pinkimaatsi-taiyaaro pantawaiti, Piñaantajyaarori piyaari kitaitiriki-payi. ");
INSERT INTO prq_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Tima oshiki onkantaiyaa kitoochii-masi kipatsiki. Irootaki piwankiri piwayitaiyaa awiroka. ");
INSERT INTO prq_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Ari pasi piwiro pamasawi-wintairo onkarati piwajyaari, Irojatzi pinkipatsi-pani-tantaiyaari, Tima kipatsi yaitaki iwitsikan-taitaka-miri, Ontzimatyii pinkipatsi-panitai aajatzi.” ");
INSERT INTO prq_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Aritaki ipaitakiro iina yoka Adán “Añaantsi”, tima irootaki irinirotyaari inkarati añaayi-tatsiniri. Ikantai-tziro iñaaniki irirori-payi “Eva”. ");
INSERT INTO prq_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Ipoñaa yaaki Pawa misinantsi iwitsikakiniri iithaari, irootaki ikithaa-takiriri atziri aajatzi iina. ");
INSERT INTO prq_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Ipoñaa ikantzi Pawa: “Ikimitakai arokaiti yoka atziri, iyotanakiro kamiithari aajatzi kaaripirori. Kimitaka aritaki inthotakiro chochoki yañaantaitari, aritaki yañaanitai.” ");
INSERT INTO prq_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Irootaki imisito-wantaka-riri isaikawitakara pankirin-tsimasiki Posiñaariniki. Ontzimatyii yantawaitaji aka kipatsiki, tima kipatsi yaitaki pairani iwitsikan-taitaka-riri. ");
INSERT INTO prq_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Aritaki imisitowai-takiri atziri pankirin-tsimasiki Posiñaarini, iwanaki Pawa aparoni maninkari tsika isitowa-piintzi ooryaatsiri. Ari osaikitakari wisa-mintotsi iroowaitaki opaamatzi paamari. Irootaki shiwatachari anta airo yariitan-taitaaro chochoki añaakaan-tatsiri. ");
INSERT INTO prq_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Okanta apaata imaantakaro iina Adán. Ari omotyaataki iroori, tzimaki otomi. Okanta-siritzi Eva: “Nowaiyantaki iroñaaka notomi. Iriitaki Pawa kantakaaro nowaiyantiri.” Irootaki opaitan-takariri otomi “Waiyantaantsi”. Tima iroka wairontsi Waiyantaantsi, irootaki ikantziri iñaaniki irirori “Caín”. ");
INSERT INTO prq_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Ipoñaa itzimanaji pasini otomi, opaitakiri Abel, iriitaki iririntzi-tanakari Caín. Pirawai-tachari inaki Abel, iriima Caín pankiwai-taniri inatzi. ");
INSERT INTO prq_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Ikanta apaata Caín, yaanaki iwankiri yasitakai-yaari Pawa impinkatha-tantyaariri. ");
INSERT INTO prq_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Ari ikimitakari irirori Abel, yaanakiniri Pawa itarori itzimi ipira, iriipiro-tatsiri iwathatzi. Oshiki yaakamiitha-takiri Pawa Abel, ari ikimitaa-kiro yasitakaa-kariri. ");
INSERT INTO prq_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","Iriima Caín timachiini yaakamiithatiri, ari ikimitaa-kiro okaratzi yasitakaa-witakariri. Irootaki ikisantana-kari Caín. ");
INSERT INTO prq_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Ikantawi-takari Pawa: “¡Caín! ¿Paitama pikisawai-tantari? ¿Paitama pipasini-kyaatantari? ");
INSERT INTO prq_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Arimi pantiro kamiithari, airo pipasini-kyaawai-tzimi. Iro kantacha, aririka pantakiro pikinkithasiritari aritaki pinkaaripiro-siritaki. Ontzimatyii piitsinampairo iroka.” ");
INSERT INTO prq_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Ikanta apaata Caín, ikantakiri iririntzi Abel: “¡Iyí! Thami ankinawaiti owaantsiki.” Ari iwakiriri anta iririntzi. ");
INSERT INTO prq_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Isampitakiri Pawa, ikantziri: “¡Caín! ¿Tsikama ikinakika pirintzi?” Ikantzi Caín: “Ti noyoti. ¿Naakama kimpoyiiriri?” ");
INSERT INTO prq_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Ari yapiitziri ikantziri: “¿Paitama pantakiri? Tima nokimakiro iriraani pirintzi okimiwai-takaro onkaima-kaima-tatyiinami kipatsiki tsika piwakiri. ");
INSERT INTO prq_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Mishataari pinaatyii awiroka iroñaaka, airo pinampi-taaro aka tsika osiyakaro omiritakityii-yaaromi kipatsi iriraani pirintzi piwakiri. ");
INSERT INTO prq_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Pankiwai-rintzi pinawityaa, airomaita piñaayi-tairo onkitho-tzimo-taimi. Kinakina-waitaniri pinkantajyaa, airo pamita pisaikajiro pinampiki.” ");
INSERT INTO prq_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Yakanaki Caín, ikantzi: “Airo namawitziro okaratzi pikantaki-nari, pimapiro-takina. ");
INSERT INTO prq_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Pimisitowa-kina aka, kinakina-waitaniri nonkantajyaa, airo namitaja nosaikairo nonampiki. Inkarati ñaayitainani, aritaki iwaitajina.” ");
INSERT INTO prq_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Ikantzi Pawa: “Itzimi-rika owaji-mini awiroka, oshiki impiyatai-tyaari irirori.” Airo iwan-taitari Caín, ikimi-takaan-takari Pawa inkin-tawatha-tatyiirimi iyoitan-tyaariri. ");
INSERT INTO prq_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Jataki Caín ikinanakiro isitowa-piintzi ooryaatsiri ipaitai-tziro Kinawini. Ari inampitaka-rori anta, tira isaikairo Posiñaariniki tsika ikinkitha-waitakaa-kiri Pawa. ");
INSERT INTO prq_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Ari yaakiri iina anta Caín. Iwaiyan-takaa-kiro, ipaitakiri Enoc. Ari iwitsika-kiri inampi, ipaitakiro Enoc aakotakiri iwairo itomi. ");
INSERT INTO prq_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Iriitaki Enoc asitana-kariri Irad. Iriitaki Irad asitana-kariri Mehujael. Iriitaki Mehujael asitana-kariri Metusael. Iriitaki Metusael asitana-kariri Lamec. ");
INSERT INTO prq_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Iriima Lamec otzimaki irirori apiti iina. Opaita Ada, pasini opaita Zila. ");
INSERT INTO prq_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Itzimanaki otomi Ada opaitakiri Jabal, iriitaki ishininkai-titari pankothaantiwiri, aajatzi pirawai-nitachari. ");
INSERT INTO prq_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Tzimatsi Jabal pasini iririntzi paitachari Jubal, iriira ishininkai-titari piyompi-waitaniri aajatzi showiriwai-taniri. ");
INSERT INTO prq_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Owaiyantaki iroori Zila, opaitakiri Tubal-caín, iriitaki asiro-pakori, owitsika-yitzirori opaita-rika-payi asiro kitiri-tatsiri. Tzimatsi iritsiro Tubal-caín opaita Naama. ");
INSERT INTO prq_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Ikanta apaata Lamec ikinkitha-waitakaa-kiro apitiro iina, Ada aajatzi Zila, ikantziro: “Pinkimisantina nonkantimiri: Nowakiri atziri okantakaan-tziro ikichinka-kina. Nowamaaki awankari okantakaan-tziro imposakina. ");
INSERT INTO prq_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Oshiki impiyawin-taityaari Caín, Irooma naaka imaapiroiti impiyawin-taityaana. ");
INSERT INTO prq_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Ikanta yapiitajiro Adán imaantajaro iina, ari itzimaji pasini itomi opaitakiri “Opantaantsi”. Okanta-siri-tanaji iroori: “Ipajina Pawa pasini notomi iri impoyii-tyaarini notomini Abel, iwakiri Caín, iririntzi.” Tima iroka wairontsi Waiyantaantsi, irootaki ikantziri iñaaniki pairani iriroriiti “Set”. ");
INSERT INTO prq_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Ikanta iwaiyakaa-kiro iina irirori Set, tzimanaki itomi ipaitakiri Enós. Ari yitaitana-karo ipinkathatai-tziri Pawa. ");
INSERT INTO prq_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Yoka ikaratzi icharini-yita-nakari Adán. Tima owakira iwitsika-kiri Pawa yoka atziri, isiyakaa-kari tsika ikantawaita irirori. ");
INSERT INTO prq_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Iwitsikaki sirampari aajatzi kooya. Itasonka-wintakiri. Ipaitakiri “Atziri” owakira iwitsika-kiri. ");
INSERT INTO prq_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Tzimanaki Adán okaratzi 130 isarintsiti, ari itzimaji pasini itomi ipaitakiri Set. Iriitaki siyakariri tsika ikantawaita irirori. ");
INSERT INTO prq_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Aikiro yañaawaji Adán okaratzi 800 osarintsi. Tzimawaji itomi-payi aajatzi irisinto-payi. ");
INSERT INTO prq_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Iroka okaratzi yañaaki Adán 930 osarintsi, ari ikamajiri irirori. ");
INSERT INTO prq_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Tzimanaki irirori Set okaratzi 105 isarintsiti, ari itzimaki itomi ipaitakiri Enós. ");
INSERT INTO prq_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Aikiro yañaawaji Set okaratzi 807 osarintsi. Tzimawaji itomi-payi aajatzi irisinto-payi. ");
INSERT INTO prq_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Iroka okaratzi yañaaki Set 912 osarintsi, ari ikamajiri irirori. ");
INSERT INTO prq_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Tzimanaki irirori Enós okaratzi 90 isarintsiti, ari itzimaki itomi ipaitakiri Cainán. ");
INSERT INTO prq_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Aikiro yañaawaji Enós okaratzi 815 osarintsi. Tzimawaji itomi-payi aajatzi irisinto-payi. ");
INSERT INTO prq_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Iroka okaratzi yañaaki Enós 905 osarintsi, ari ikamajiri irirori. ");
INSERT INTO prq_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Tzimanaki irirori Cainán okaratzi 70 isarintsiti, ari itzimaki itomi ipaitakiri Mahalaleel. ");
INSERT INTO prq_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Aikiro yañaawaji Cainán okaratzi 840 osarintsi. Tzimawaji itomi-payi aajatzi irisinto-payi. ");
INSERT INTO prq_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Iroka okaratzi yañaaki Cainán 910 osarintsi, ari ikamajiri irirori. ");
INSERT INTO prq_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Tzimanaki irirori Mahalaleel okaratzi 65 isarintsiti, ari itzimaki itomi ipaitakiri Jared. ");
INSERT INTO prq_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Aikiro yañaawaji Mahalaleel okaratzi 830 osarintsi. Tzimawaji itomi-payi aajatzi irisinto-payi. ");
INSERT INTO prq_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Iroka okaratzi yañaaki Mahalaleel 895 osarintsi, ari ikamajiri irirori. ");
INSERT INTO prq_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Tzimanaki irirori Jared okaratzi 162 isarintsiti, ari itzimaki itomi ipaitakiri Enoc. ");
INSERT INTO prq_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Aikiro yañaawaji Jared okaratzi 800 osarintsi. Tzimawaji itomi-payi aajatzi irisinto-payi. ");
INSERT INTO prq_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Iroka okaratzi yañaaki Jared 962 osarintsi, ari ikamajiri irirori. ");
INSERT INTO prq_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Tzimanaki irirori Enoc okaratzi 65 isarintsiti, ari itzimaki itomi ipaitakiri Matusalén. ");
INSERT INTO prq_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Aikiro yañaatzii Enoc okarataki 300 osarintsi, yantapiin-tziro okaratzi inintziri Pawa. Tzimawaji pasini itomi-payi aajatzi irisinto-payi. ");
INSERT INTO prq_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Iroka okaratzi yañaaki Enoc 365 osarintsi. ");
INSERT INTO prq_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Tima yantapiin-takiro Enoc okaratzi inintziri Pawa, irojatzi yaantaariri Pawa, tira iñiitajiri. ");
INSERT INTO prq_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Tzimanaki irirori Matusalén okaratzi 187 isarintsiti, ari itzimaki itomi ipaitakiri Lamec. ");
INSERT INTO prq_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Aikiro yañaawaji Matusalén okaratzi 782 osarintsi. Tzimawaji itomi-payi aajatzi irisinto-payi. ");
INSERT INTO prq_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Iroka okaratzi yañaaki Matusalén 969 osarintsi, ari ikamajiri irirori. ");
INSERT INTO prq_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Tzimanaki irirori Lamec okaratzi 82 isarintsiti, ari itzimaki itomi irirori. ");
INSERT INTO prq_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Ikanta-siritzi Lamec: “Tima imapiro-takiro Pawa imishatakiro kipatsi, oshiki inkimaatsi-taityaaro yantawai-taiti, iro kantacha iriitaki yoka iinchaa-niki makoryaa-kaantaa-tsini.” Irootaki ipaitan-takariri itomi “Makoryaantsi”. Tima iroka wairontsi Makoryaantsi, irootaki ikantziri iñaaniki pairani irirori “Noé”. ");
INSERT INTO prq_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Aikiro yañaawaji Lamec okaratzi 595 osarintsi. Tzimawaji itomi-payi aajatzi irisinto-payi. ");
INSERT INTO prq_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Iroka okaratzi yañaaki Lamec 777 osarintsi, ari ikamajiri irirori. ");
INSERT INTO prq_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Tzimanaki irirori Noé okaratzi 500 isarintsiti, ari itzimaki itomi-payi, ipaitakiri: Sem, Cam, Jafet. ");
INSERT INTO prq_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Ikanta shikitanaji atziripayi aka kipatsiki, tzimayi-tanaki irisinto-payi. ");
INSERT INTO prq_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","Ari iñaakiro itomiyaayi-payi Pawa kamiithaa-niki okantayita irisintoiti atziripayi, ikoyaayitaki okaratzi onimotaki-riri, iinanta-yitakaro. ");
INSERT INTO prq_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Irootaki ikantan-tanakari Pawa: “Airo yañaa-yitaji atziri, tima wathatsi inamatsi-tatzii irirori. Apatziro yañaa-matsitaji onkarati 120 osarintsi.” ");
INSERT INTO prq_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Ikanta iinantayitakaro itomiyaayi Pawa irisinto-payi atziripayi, iwaiyan-takaa-yitakiro. Iriitaki antari-tawato-payi itanakarori inampiyitaro pairani, ñaapirori ikantajiitakani, oshiki ikimakoi-takiri. ");
INSERT INTO prq_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Tima iñaakiri Pawa omaapiro ikaaripirotaki atziripayi aka kipatsiki, iro yaakowin-tapiintaka ikinkithasiritaro yantayitiro kaaripiro-yitatsiri. ");
INSERT INTO prq_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Antaro okantzimo-niinta-kari Pawa iwitsika-kiri atziri. ");
INSERT INTO prq_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Ikantanaki: “Ontzimatyii napirotairi atziri ikaratzi nowitsika-kiri kipatsiki, ari nonkimitairi antami-wiripayi, konthaa-yitatsiri osaawiki, aajatzi siwanki-ripayi. Tima antaro okatsi-tzimo-niintakina nowitsika-kiri.” ");
INSERT INTO prq_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Iriima Noé, kamiitha-siri ikantzimo-takari Pawa. ");
INSERT INTO prq_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Iroka ikinkitha-takoi-tziri Noé. Kamiitha-siri ikantaka irirori, ikimisan-tapiintziri Pawa. Tima tikatsi pairani kimityaa-riniri Noé yantapiin-takiro inintziri Pawa. ");
INSERT INTO prq_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Tima ikaratzi mawa itomi Noé, iroka ipaitakiri: Sem, Cam, Jafet. ");
INSERT INTO prq_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Tima oshiki ikaaripiro-tzimo-takiri Pawa osaawi-satziiti, oshiki imaimani-tawakaaka. ");
INSERT INTO prq_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Ari yasi iwakiro ikaaripiro-yitaki atziripayi. Ikanta iñaakiri Pawa ithonka ikaaripiro-yitaki atziripayi, ");
INSERT INTO prq_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","ikantakiri Noé: “Nonintzi napirotairi atziripayi. Iriitaki kantakaan-tzirori imaimani-tawakaantari osaawiki. Nonintzi nonthonkairi atziripayi aajatzi maaroni kipatsi. ");
INSERT INTO prq_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Irooma awiroka pamini inchato tzimatsiri okasi, irootaki piwitsikiri pamaa-tako-minto. Pinasityaaro inthompointa pintanto-yitiro. Piwitsiñiiro maaroni intakiroini aajatzi inthompointa. ");
INSERT INTO prq_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Ari pinkantiro piwitsikiro. Onkarati pimonkaratiro osanthati 300 pikonaki, irooma oniiki onkarati 50 pikonaki, irooma tsika ojinokiti onkarati 30 pikonaki. ");
INSERT INTO prq_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Mawaminko pinkantiro piwitsikiro. Pimorontiro oshaawiini otapisiki inkini yaminaiti, onkarati okimiityaa aparoni pikonaki. Tima aparoni piwitsikaki asitakoro. ");
INSERT INTO prq_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Aritaki nowaryaaki antaro inkani, anairo maaroni kipatsi. Inthonka yapirotyaa inkami maaroni añaayi-tatsiri kipatsiki. ");
INSERT INTO prq_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Irooma awiroka Noé tzimatsi ankasiyakaa-wakaiyaari. Tima awiroka kyaatsi-ni amaatako-minto-tsiki pintsipa-tyaari pitomi-payi, piina, aajatzi paniro-payi. ");
INSERT INTO prq_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Piminkyii aajatzi apiti-payi nasiyitachari antami-wiriiti ikaratzi añaayi-tatsiri aka kipatsiki, aparoni sirampari aajatzi aparoni kooya, iriitaki tsipatyaa-mini yañaayiti aajatzi irirori. ");
INSERT INTO prq_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Tima apiti-payi piminkyii ikaratzi inasiyita siwanki-ripayi, ikaratzi inasiyita antami-wiripayi, ikaratzi inasiyita ipiraita-ripayi, aajatzi ikaratzi inasiyita konthaa-yitatsiri osaawiki, inkini yañaayiti irirori-payi. ");
INSERT INTO prq_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Ontzimatyii piwapithaantyaa oshiki piwariti. Irootaki piyaari awirokaiti aajatzi ikaratzi piminkyaa-yitiri.” ");
INSERT INTO prq_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Imatakiro Noé okaratzi ikantaki-riri Pawa. ");
INSERT INTO prq_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Ipoñaa ikantairi Pawa yoka Noé: “Tzimawi-tacha oshiki atziri aka kipatsiki, iro kantacha apatziro pikantakaa-karo awiroka pantapiin-takiro nonintziri naaka. Pinkyii amaatako-minto-tsiki awiroka, piina, pitomi-payi aajatzi paniro-payi. ");
INSERT INTO prq_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Piyosiitiri piminkyaa-yitiri aajatzi antami-wiri kaari ipinkai-tziri, inkarati 7 sirampari aajatzi 7 kooya. Iriima ikaratzi ipinkai-tziri piminkyaayiti inkarati apiti, aparoni sirampari aparoni kooya. ");
INSERT INTO prq_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Ari pinkimitaa-kiri aajatzi siwanki-ripayi, piminkyii inkarati 7 sirampari aajatzi 7 kooya. Airo ipyaanta tsika ikanta inasiyita irirori. ");
INSERT INTO prq_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Tima oyotapaaka 7 kitaitiri nowaryaan-tyaarori inkani, aakowin-tyaaro omparyii 40 kitaitiri aajatzi 40 tsitiniri. Napirotajiri kipatsiki maaroni añaayi-tatsiri nowitsikakiri.” ");
INSERT INTO prq_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Tima imatakiro Noé okaratzi ikantaki-riri Pawa. ");
INSERT INTO prq_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Aritaki tzimaki irirori Noé okaratzi 600 isarintsiti, oonkantyaari kipatsiki. ");
INSERT INTO prq_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Ari ikyaanaki Noé amaatako-minto-tsiki itsipatakaro iina, itomi-payi aajatzi iraniro-payi. ");
INSERT INTO prq_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Ikyaapaaki antami-wiripayi kaari ipinkaitzi aajatzi ipinkai-tziri, siwanki-ripayi, konthaa-yitatsiri kipatsiki, ");
INSERT INTO prq_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","Itiyitaka amaatako-minto-tsiki itsipatakari Noé, apiti-payi ikaratzi kyaintsiri, aparoni sirampari aparoni kooya. Omataka okaratzi ikantakiri Pawa. ");
INSERT INTO prq_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Ikanta omonkara-tapaaka awisawaji 7 kitaitiri, ari itanakaro oparyaapaaki inkani kipatsiki. ");
INSERT INTO prq_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Tima aritaki tzimaki Noé okaratzi 600 isarintsiti, awisanaki aparoni kasiri, aajatzi 17 kitaitiri, aripaiti otonkako-tanaki inkaari tzimatsiri osaawiki, aajatzi tzimatsiri jinoki. ");
INSERT INTO prq_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Aakowin-takaro oparyaaki okaratzi 40 kitaitiri aajatzi 40 tsitiniri. ");
INSERT INTO prq_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Irootaki kitaitiri ikyaantana-kari irirori Noé amaatako-minto-tsiki, itsipatakaro iina, itomi-payi: Sem, Cam, Jafet, aajatzi mawa iraniro. ");
INSERT INTO prq_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Tima itsipatakari nasiyitachari antami-wiripayi, nasiyitachari ipiraita-ripayi, ikaratzi nasiyitachari konthaa-yitatsiri osaawiki, aajatzi ikaratzi nasiyitachari siwanki-ripayi. ");
INSERT INTO prq_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Mataka ikyaayitaki amaatako-minto-tsiki apiti-payi ikaratzi añaayi-tatsiri kipatsiki, itsipatakari Noé. ");
INSERT INTO prq_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Itiyitaka aparoni sirampari aparoni kooya. Mataka okaratzi ikantaki-riri Pawa yoka Noé. Iriitakira Pawa asitanaki-rori amaatako-mintotsi. ");
INSERT INTO prq_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Mataka oparyaaki okaratzi 40 kitaitiri. Antaro okantanaka oonkanaro kipatsiki. Owankatanaka amaatako-mintotsi. ");
INSERT INTO prq_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Aikiro opokaatatzii oonkaro. Aikiro owankatyaa amaatako-mintotsi. ");
INSERT INTO prq_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","othonka anaanakiro jinokiyi-tatsiri otzisi, tima omaapiro oonkaka aka kipatsiki. ");
INSERT INTO prq_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Tima okaratzi 15 konakintsi anaakiro jinokiyi-tatsiri otzisi. ");
INSERT INTO prq_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Ari yapirotakari maaroni atziri aka kipatsiki, imataka siwanki-ripayi, antami-wiripayi, ipiraita-ripayi, aajatzi konthaa-yitatsiri osaawiki. ");
INSERT INTO prq_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Mataka yapirotaka ikaratzi aniinka-witachari aajatzi okaratzi tzimawi-tachari aka kipatsiki. ");
INSERT INTO prq_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Apatziro yawisakotaji Noé aajatzi ikaratzi itsipatakari amaatako-minto-tsiki. Tima ithonka yapiroi-takiri atziripayi saikawi-tachari kipatsiki, itsipatakari antami-wiripayi, siwanki-ripayi, konthaa-yitatsiri, maaroni. ");
INSERT INTO prq_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Tira ompiryaa-tzitajyaa oonkaro kipatsiki okaratzi 150 kitaitiri osamanitaki irojatzi opiryaa-tantajari. ");
INSERT INTO prq_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Tima isiriki iwiri Pawa Noé, aajatzi ikimitzi-takari maaroni antami-wiripayi, ipiraita-ripayi ikaratzi titainchari amaatako-minto-tsiki. Ikantakaa-karo Pawa ontasonkaa-tajiro tampyaa iroka oonkaro, irotaki ompiryaatan-tajyaari. ");
INSERT INTO prq_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Asitanaja tsika ositowa-yitanaki nijaa poñaayi-tanainchari inthompointa kipatsiki, ari okantzi-tanaari aajatzi poñaayi-tainchari jinoki inkitiki. Karataji oparyaaki inkani. ");
INSERT INTO prq_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Niitsikiroini okanta opyaata oonkaro. Tima awisaki okaratzi 150 kitaitiri opiryaa-tantaari oonkaro. ");
INSERT INTO prq_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Tima ikaratzi 5 kasiri awisaintsiri opiryaa-tako-tantaari amaatako-mintotsi tonkaariki otzisiki ipaitai-tziri Tasorintsii-toni. ");
INSERT INTO prq_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Aikiro opyaa-tatyaa oonkaro. Ari yawisawaji apiti kasiri, koñaayitaji maaroni otzisi jinokiyi-tatsiri. ");
INSERT INTO prq_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Okanta awisawaji aajatzi 40 kitaitiri, yasitaryaa-jiro Noé imorontakiro amaatako-mintotsi, ");
INSERT INTO prq_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","iwaraakiri koontzi-niro. Ari ishonkawita koontzi-niro iyaawinta ompiryaataji kipatsi. ");
INSERT INTO prq_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Ipoñaa iwaraaki aajatzi Noé aparoni siro iyotantyaari piryaataji-rika kipatsi. ");
INSERT INTO prq_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Titzimaita iñii siro tsika yookyaa, piyaja amaatako-minto-tsiki. Imisitowairo irako Noé, ookapaja siro, iminkyaawa-jiri amaatako-minto-tsiki. ");
INSERT INTO prq_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Ari iyaawin-tawaja aajatzi Noé okaratzi 7 kitaitiri, yapiitakiro iwaraajiri siro. ");
INSERT INTO prq_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Ikanta ipiyaa siro otsitiniityaaki, yamaji ithowaki inchasimpoki. Ari iyotziri Noé piryaa-tzimataji oonkaro. ");
INSERT INTO prq_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Aajatzi yapiitawa-iro iyaawin-tawaja Noé okaratzi 7 kitaitiri, yapiitairo iwaraajiri siro. Tira ipiyaaro siro amaatako-minto-tsiki. ");
INSERT INTO prq_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Okanta okyaapaji owakirari osarintsi, irootaki itanaarori kitaitiri, aajatzi itanaarori kasiri, ari tzimanaji Noé okaratzi 601 isarintsiti. Aripaiti yookairo Noé iwankotan-takarori amaatako-mintotsi, iñaatziiro koñaayitaji kipatsi. ");
INSERT INTO prq_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Ikanta yawisawaji aparoni kasiri, aajatzi 27 kitaitiri, aripaiti opiryaa-pirotaji oonkaro aka kipatsiki. ");
INSERT INTO prq_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Ikantairi Pawa Noé: ");
INSERT INTO prq_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Pisitowaji iroñaaka amaatako-minto-tsiki, pintsipa-tyaaro piina, pitomi-payi, aajatzi paniro-payi. ");
INSERT INTO prq_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Pimisitowairi maaroni antami-wiri ikaratzi pitsipa-takari: siwanki-ripayi, ipiraita-ripayi, aajatzi ikaratzi konthaa-yitatsiri osaawiki. Ijatai kipatsiki inampitapa-jyaaro, ishikitaita yokapayi anta.” ");
INSERT INTO prq_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Ari isitowanaji Noé amaatako-minto-tsiki itsipatakaro iina, itomi-payi, aajatzi iraniro-payi. ");
INSERT INTO prq_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Ari isitowana-iri aajatzi maaroni antami-wiripayi, ipiraita-ripayi, konthaa-yitatsiri osaawiki, siwanki-ripayi, maaroni. ");
INSERT INTO prq_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Ari iwitsika-paji Noé ipomi-pirini-minto ipinkatha-tapajiri Pawa. Yaaki aparoni-payi ikaratzi iwaitari, aajatzi siwanki-ripayi, kachaaryiinka ikanta ipomitapa-jiri ipomi-pirini-mintoki. ");
INSERT INTO prq_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Ikanta ikimainka-tawakiri Pawa iwosininka, ikantanaki: “Airo napirotzi-tantaja iroñaaka kipatsiki ikantakaan-tziro atziri-payi, tima iriintsi-takori iwiro ikinkithasirita yantayitiro kaaripirori. Aajatzi nonkimi-tajiri maaroni antami-wiripayi, airo napirotajiri nokimitaa-kiri iroñaaka. ");
INSERT INTO prq_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Ainiro iñaitiro iroka kipatsi, Irasi iwaitiro impanki-waitaiti, yawiitaiti iwankiri. Asi owajiro amasawirintsiti, onkatsinkaityii aajatzi. Asi owajiro onkyaarontsiti, osarintsiti aajatzi. Onkitaititi, ontsitinitai aajatzi.” ");
INSERT INTO prq_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Ari itasonkawinta-nakiri Pawa Noé aajatzi itomi-payi. Iroka ikantakiri: “Ishikitaji pitomi-payi, inthonkyaa inampitajyaaro kipatsiki. ");
INSERT INTO prq_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Oshiki intharowan-tyaami aajatzi maaroni antami-wiripayi, siwanki-ripayi, konthaa-yitatsiri kipatsiki, aajatzi nijaa-wiripayi. Tima awiroka noyotakaa-piroti panaayi-tairi maaroni yokapayi. ");
INSERT INTO prq_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Kamiitha-tatsi piwayitajyaari ikaratzi añaayi-tatsiri, aajatzi pankirin-tsipayi. Naaka opakimirori iroka-payi. ");
INSERT INTO prq_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Iriima añiinkari wathatsi, airo piwakowaitaro iriraani, irootaki añaakairiri. ");
INSERT INTO prq_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Tima omaapiro okowa-pirota iraantsi. Aririka pinkapathainkatakairi piwamairi pishininka, aritaki nomatakimi naaka. Ari nonkimi-tajiri pipira aririka iwamaanti, aajatzi nonkimi-tajiri atziri-payi owai-rini ishininka, nonkapathain-ka-takayiri irirori. ");
INSERT INTO prq_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Itzimi-rika owiriri atziri, Aritaki iwai-tairi irirori. Tima naaka owitsika-kiri atziri, Nokimi-takaan-takari tsika nokanta-waita naaka. ");
INSERT INTO prq_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Irooma awiroka, ishikitaji piwaiyani, Inthonka inampitajyaaro kipatsiki.” ");
INSERT INTO prq_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Aikiro ikinkitha-waitakaa-tziiri Pawa yoka Noé aajatzi itomi-payi, ikantziri: ");
INSERT INTO prq_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“¡Noé! Tzimatsi nonkasiya-kai-miri, irojatzi nonkasiyakai-riri inkarati pincharini-tajyaari. ");
INSERT INTO prq_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","Irojatzi nokasiya-kayi-tyaariri antami-wiripayi ikaratzi pitsipa-yitaari pisitowaji amaatako-minto-tsiki: siwanki-ripayi, ipiraita-ripayi, maaroni inkarati tzimayi-taatsi-ni kipatsiki. ");
INSERT INTO prq_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Iroka nokasiya-kai-miri iroñaaka: Airo napiitziro nowasankitaan-tyaari oonkaro yoka atziri-payi aajatzi antami-wiripayi. Tima airo apiita oonkajyaa kipatsiki, iñiitaji yapirotajyaa ikaratzi tzimayi-tatsiri.” ");
INSERT INTO prq_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Aikiro ikinkitha-waitakaa-tziiri Pawa yoka Noé, ikantziri: “Tzimatsi iñaitairi iyotantai-tyaari tzimatsi akasiyakaa-wakaari. Iriitaki piñaapiin-tairi awiroka aajatzi antami-wiripayi. ");
INSERT INTO prq_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Tima aririka piñiiri inkatziyi oyi ooryiinkatzi, piyotaji tzimatsi akasiyakaa-wakaari. ");
INSERT INTO prq_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Aririka piñiiro ooriinkatai, ari piñiiriri inkatziyi oyi minkoriki. ");
INSERT INTO prq_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","Tima osiriki nowajiro naaka nokasiyakai-miri, aajatzi nokasiyakaa-riri antami-wiripayi. Airo apiita iñaitairo oonkaro apirotai-roni kipatsi. ");
INSERT INTO prq_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Aririka noñiiri oyi inkatziyi minkoriki, osiriki nowairo okaratzi akasiyakaa-wakaari, irojatzi nokasiyakai-riri aajatzi ikaratzi añaayi-tatsiri kipatsiki. Asi owatyiiro, airo nowasiñaa-jiro. ");
INSERT INTO prq_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Iriitaki iñaayitairi maaroni añaayi-tatsiri kipatsiki, iyotai tzimatsi akasiyakaa-wakaari.” Irootaki iñaani Pawa iroka okaratzi ikamantaki-riri Noé. ");
INSERT INTO prq_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Yoka itomi-payi Noé ikaratzi sitowaa-tsiri amaatako-minto-tsiki: Sem, Cam, Jafet. Iriitakira Cam iririntana-kari Canaán. ");
INSERT INTO prq_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Ikaratakira mawa itomi Noé, iriitaki oshikitaa-tsiri aka kipatsiki. ");
INSERT INTO prq_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Pairani aparoni okanta ñaantsi iñaawai-taitziri kipatsiki. ");
INSERT INTO prq_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Ikanta ikinapajiro atziri-payi isitowa-piintzi ooryaatsiri, iñaapaakiro owintinitzi ipaitai-tziro Apijaari, ari inampitaka-rori anta. ");
INSERT INTO prq_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Ipoñaa ikantawakaajiitani atziri-payi: “Thami antayi kipatsi onkiso-nakiti.” Ari itanakaro itanto-taitaro kipatsi-naki, ti apatziro itantotaityaaro mapinaki. Aripaiti itanakaro aajatzi itsirikan-taitaro tziritatsiri, tira apatziro intsirikan-taityaaro pitzi-thatatsiri. ");
INSERT INTO prq_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Ipoñaa ikantawakajiitani aajatzi: “Thami awitsiki anampitsiti, awitsiki aajatzi antaroiti atiimintotsi ariitacha-ni inkitiki. Inthonkyaa inkimakoi-tajai. Aritapaaki akinakina-waiyitaki tsikari-payi.” ");
INSERT INTO prq_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Ikanta ipokaki Pawa yaminiro nampitsi aajatzi atiimintotsi iwitsika-kiri atziri-payi, ");
INSERT INTO prq_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","ikanta-siri-tanaki: “Aparoni okanta inampi, aparoni okanta iñaani, irootaki imatantarori iwitsika-yitziro inintziri. Tima okaratzi ikinkithasiritari yantiri, tikatsi washaan-takai-rini. ");
INSERT INTO prq_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Thami ankompi-takai-yaari iñaani, airo ikimatha-tawakaanta iñaana-tawakaiyaarika.” ");
INSERT INTO prq_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Ari iwashaan-takaa-kiri Pawa yoka atziri-payi otzimawitaka antaroiti inampitsiti, yoiwaraa-kiri ikinayi-tanaki tsika-rikapayi. ");
INSERT INTO prq_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Ikompi-takaa-yita-nakari Pawa iñaani-payi atziripayi ikaratzi nampitarori kipatsiki. Irootaki owaitakaan-tzirori iroka inampi Kompijaari. Aripaiti yoiwaraa-kiri Pawa atziri-payi, jataki inampityaaro maaroni kipatsiki. ");
INSERT INTO prq_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Yoka icharini-payi Sem itomi Noé. Tima aritaki awisaki apiti osarintsi oonkantakari kipatsi, tzimaki Sem okaratzi 100 isarintsiti, ari itzimaki itomi irirori ipaitakiri Arfaxad. ");
INSERT INTO prq_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Aikiro yañaawaji Sem okaratzi 500 osarintsi. Tzimawaji itomi-payi aajatzi irisinto-payi. ");
INSERT INTO prq_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Ari tzimanaki irirori Arfaxad okaratzi 35 isarintsiti, ari itzimaki itomi ipaitakiri Sala. ");
INSERT INTO prq_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Aikiro yañaawaji Arfaxad okaratzi 403 osarintsi. Tzimawaji itomi-payi aajatzi irisinto-payi. ");
INSERT INTO prq_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Ari tzimanaki irirori Sala okaratzi 30 isarintsiti, ari itzimaki itomi ipaitakiri Heber. ");
INSERT INTO prq_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Aikiro yañaawaji Sala okaratzi 403 osarintsi. Tzimawaji itomi-payi aajatzi irisinto-payi. ");
INSERT INTO prq_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Ari tzimanaki irirori Heber okaratzi 34 isarintsiti, ari itzimaki itomi ipaitakiri Peleg. ");
INSERT INTO prq_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Aikiro yañaawaji Heber okaratzi 430 osarintsi. Tzimawaji itomi-payi aajatzi irisinto-payi. ");
INSERT INTO prq_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Ari tzimanaki irirori Peleg okaratzi 30 isarintsiti, ari itzimaki itomi ipaitakiri Reu. ");
INSERT INTO prq_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Aikiro yañaawaji Peleg okaratzi 209 osarintsi. Tzimawaji itomi-payi aajatzi irisinto-payi. ");
INSERT INTO prq_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Ari tzimanaki irirori Reu okaratzi 32 isarintsiti, ari itzimaki itomi ipaitakiri Serug. ");
INSERT INTO prq_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Aikiro yañaawaji Reu okaratzi 207 osarintsi. Tzimawaji itomi-payi aajatzi irisinto-payi. ");
INSERT INTO prq_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Ari tzimanaki irirori Serug okaratzi 30 isarintsiti, ari itzimaki itomi ipaitakiri Nacor. ");
INSERT INTO prq_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Aikiro yañaawaji Serug okaratzi 200 osarintsi. Tzimawaji itomi-payi aajatzi irisinto-payi. ");
INSERT INTO prq_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Ari tzimanaki irirori Nacor okaratzi 29 isarintsiti, ari itzimaki itomi ipaitakiri Taré. ");
INSERT INTO prq_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Aikiro yañaawaji Nacor okaratzi 119 osarintsi. Tzimawaji itomi-payi aajatzi irisinto-payi. ");
INSERT INTO prq_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Ari tzimanaki irirori Taré okaratzi 70 isarintsiti, ari itzimaki itomi-payi ipaitakiri Abram, Nacor, Harán. ");
INSERT INTO prq_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Yoka icharini-payi Taré. Iriitaki Taré tomintaka-riri Abram, Nacor aajatzi Harán. Iriitaki Harán tomintaka-riri Lot. ");
INSERT INTO prq_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Irijatzi Harán itakarori ikamaji Kitainkaariki iipatsitiki Kiyamori-wini-satzi. Ikamitaka irirori tikiramintha inkami asitariri. Ikamaji tsika itzimaki pairani. ");
INSERT INTO prq_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Ikanta Abram iinantakaro Sarai. Iriima Nacor iinantakaro Milca, irisinto Harán. Iroora Milca irintotarori Isca. ");
INSERT INTO prq_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Iro kantacha Sarai ti owaiyan-taniti iroori, omaaniro-tatzii. ");
INSERT INTO prq_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Ikanta apaata Taré, inintaki ijataimi Owintiniki, yookanajiro inampiwi-takaro Kitainkaariki iipatsiti Kiyamori-wini-satzi. Yaanajiri Abram, iraniro, aajatzi icharini Lot. Ikanta yariitaka niyaanki-thaki ipaitai-tziro Awotzini, ari inampitapaa-karo anta. ");
INSERT INTO prq_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Iroka okaratzi yañaaki Taré 205 osarintsi, irojatzi ikamantaari irirori anta Awotziniki. ");
INSERT INTO prq_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Ikanta apaata Pawa, iñaanatakiri Abram, ikantakiri: “¡Abram! Tzimatsi pasini kipatsi noñaakaimiri, pijati anta, pookanajiro pinampi awiroka, irasi piri, aajatzi pishininka-payi. ");
INSERT INTO prq_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Aritaki noshikyaa-kiri picharini-payi anta. Ari nontasonka-wintakimi awiroka, iriipirori nonkan-takai-yaami. Awiroka kantakai-yaaro-ni intasonka-wintantai-tyaariri pasini-payi atziri. ");
INSERT INTO prq_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Aritaki nontasonka-wintajiri inkarati tasonka-wintai-mini awiroka. Ari nomisha-tairi inkarati mishatai-mini awiroka. Tima awiroka kantakai-yaaroni nontasonka-wintan-tajyaariri maaroni nasiyitacha-niri ishininka-tawakajyaa kipatsiki.” ");
INSERT INTO prq_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Aritaki tzimaki Abram okaratzi 75 isarintsiti. Jataki tsika yookotaki-niri Pawa, yookanairo Awotzini tsika inampi-witakaro. ");
INSERT INTO prq_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Itsipatanaaro iina Sarai, aajatzi Lot itominthori. Ithonka yaanajiro tzimimo-tziriri, yaanajiri maaroni yatziriti yamanan-takiri Awotziniki. Iroka okanta yariitan-takari Abram Owintiniki. ");
INSERT INTO prq_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Tima osamani yaniitaki anta, irotaki yariitan-takari Sikochaariniki osaiki inchato ipaitai-tziri Yotaan-taniri. Iroora inampiiti Owintini-satzi anta. ");
INSERT INTO prq_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Ari iñaakakari Pawa anta, ikantakiri: “¡Abram! Iroka kipatsi, iro nompiriri inkarati pincharini-tajyaari.” Ari iwitsika-naki Abram pomipirini-mintotsi impinkathatiri Pawa. ");
INSERT INTO prq_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Aikiro ijatatzii Abram ikinakiro otzisi-masiki isitowa-piintzi ooryaatsiri, ari iwatzika-pairo iwankothaanti-payi, yamina-kotapairo Pawapankoni ikyaapiintzi ooryaatsiri. Irooma Porokaarini yamina-kotapairo isitowa-piintzi ooryaatsiri. Ari iwitsika-pairi pasini ipomi-pirini-minto, ipairyaapajiro iwairo Pawa ipinkatha-tapajiri. ");
INSERT INTO prq_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Aikiro yaniijii-tatziini Abram, iyatziro Piryaariniki. ");
INSERT INTO prq_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Ashaaranta-pirori inatzi Abram, itzimi-motziri ooro, kiriiki, oshiki ipira-payi. ");
INSERT INTO prq_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Ikanta ipoñaajaro Piryaariniki irojatzi Pawapankoniki. Ipoñaa yawisanaji irojatzi niyaanki-thaki awotsi tsika inampiwitaro pairani okaakitapaji Porokaarini, ari iwankothaanti-yitapaari, ");
INSERT INTO prq_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","tsika iwitsika-naki pairani pomipirini-mintotsi. Ari ipairyaapa-jiro iwairo Pawa, ipinkatha-tapajiri. ");
INSERT INTO prq_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Ari ikantzi-takari aajatzi itominthori Lot, itzimi-motziri oshiki ipira-payi, aajatzi iwankothaanti-payi. ");
INSERT INTO prq_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Okanta anta tsika isaikajii-tapaji, ti onimotapa-jiri intsipa-tawakaiyaa, tima ti antitaiyaa iwariti ipira-payi. ");
INSERT INTO prq_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Tima ikaratzi aamawin-tariri ipira-payi Abram aajatzi irasi Lot, antawakaajiitakani. Aka tsika isaikajiitaki, irotaki inampiiti Owintini-satzi aajatzi Nampitsi-wini-satzi. ");
INSERT INTO prq_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Irootaki ikantan-takariri Abram itominthori Lot, ikantziri: “Notomithori nokashiimi awiroka, ti okamiithatzi ankisaniin-tawakaiyaa, ti okamiithatzi aajatzi yantawakaiyaa aamawin-tariri apira-payi. ");
INSERT INTO prq_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Tima antaro okanta kipatsi aka, pamini tsika pinampi-tyaaro. Aririka pinkinaki kirinka, nonkinanaki naaka katonko. Pinkinaki-rika katonko, nonkinaki naaka kirinka.” ");
INSERT INTO prq_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Yamina-kotakiro Lot Owintinitatsi othapyaaki Owaryiinkaarini, ari osaikiri anta nampitsi ipaitai-tziri Nampichaani. Oshiki okamiithataki anta, ari otzimapaji oshiki nijaa. Iroowaitaki Posiñaarini iwitsika-kiri pairani Pawa, iroowaitaki aajatzi nampitsi Apitantoni. Ari okantawita Paamajaari aajatzi Katsimaarini tikira intayiroota Pawa. ");
INSERT INTO prq_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Yookotakiro Lot inampityaaro isitowa-piintzi ooryaatsiri othapyaaki Owaryiinkaarini. Ari ikantakari Lot inasitan-takari isaikaji irirori, ti itsipatanajyaari iriri-thori Abram. ");
INSERT INTO prq_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Irojatzi isaikanaki Abram Owintiniki, jataki irirori Lot otaapiki iwankothaanti-yitaka, irojatzi inampitan-takyaarori apaata Paamajaa-riniki. ");
INSERT INTO prq_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Ari inampitapaarori anta atziri-payi antayitzirori kaaripirori kaari ininti Pawa. ");
INSERT INTO prq_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Okanta pairani anta Apijaariki ipinkatha-ritzi Amrafel, iriima Arioc ipinkatha-ritzi anta Owasankipawawiniki, iriima Quedorlaomer ipinkatha-ritzi anta Osamaniwiniki, aajatzi Tidal ipinkatha-ritzi irirori Pasinisawiniki. ");
INSERT INTO prq_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","Kamiitha yaapatyaa-wakaa-jiita yokaiti pinkathari, iriiyitaki jataintsiri iwayiritakari Bera pinkatha-ritatsiri Paamaa-riniki, Birsa pinkatha-ritatsiri Katsimaariniki, Sinab pinkatha-ritatsiri Kityonkapathariniki, Semeber pinkatha-ritatsiri Maniraariniki, aajatzi pinkatha-ritatsiri Niyawiniki, ipaitai-tzitari aajatzi Nampichaani. ");
INSERT INTO prq_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Ikanta yokaiti 5 pinkathari-payi iwayiritai-takari, yaapatyaa-wakaanaka irirori, yapatotakiri iwayiriti anta Mamiripankawiniki tsika osaiki Inkaari Mirityaaro. ");
INSERT INTO prq_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Tima tzima-kotaki 12 osarintsi yoka 5 pinkathari-payi impira-waitakari pinkathari Quedorlaomer, iro kantacha pasini osarintsi 13-tapain-tsiri, ikinkithasiri-jiitaka inkisako-wintajyaa impira-waitakari pinkathari. ");
INSERT INTO prq_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Okanta pasini osarintsi 14-tapain-tsiri, pinkathari Quedorlaomer itsipatakari pasini pinkathari-payi aapatyaa-kariri, ijajiitaki nampitsiki Impokiromara Apichiinari, ari yapirotakiri iwayiritari Antari-tawato-payi. Imatanakiri aajatzi Saikawaitaniriiti anta Saawaariniki, imatanakiri aajatzi Oimiraawiniriiti anta Omamiri-pathati Apinampiwini. ");
INSERT INTO prq_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","Imatanakiri Morowini-satzi anta otzisi-masiki osaiki Witzintzi-wini, ipatzimata-nakiri irojatzi Morontoniki tsipa-nampitarori otzisi-masiki. ");
INSERT INTO prq_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Ikanta ipiyajaro Quedorlaomer itsipataari pinkathari aapatyaariri, yariijiitaka Mishajaariniki ipaitai-tziri aajatzi Tasorinchaarini. Yapirota-nakiri ikaratzi iñaanakiri iipatsitiki Otinkanaawini-satzi, ari ikimita-nakiri aajatzi Tonkaarisatzi nampitarori Tsipana-jaariniki. ");
INSERT INTO prq_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Ikanta pinkatha-ritatsiri Paamaa-riniki, Katsimaariniki, Kityonkapathariniki, Maniraariniki, Niyawiniki (ipaitai-tziri aajatzi Nampichaani,) ijajiitaki iwayirityaa Mamiripankawiniki. ");
INSERT INTO prq_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","Yokaiti 5 pinkathari, iwayiritakari pasini 4 pinkathari: Quedorlaomer pinkatha-ritatsiri Osamaniwiniki, Tidal pinkatha-ritatsiri Pasinisawiniki, Amrafel pinkatha-ritatsiri Apijaariki, Arioc pinkatha-ritatsiri Owasankipawawiniki. ");
INSERT INTO prq_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Irooma anta Mamiripankawiniki tzimatsi amithori-patha. Ikanta isiya-pitha-witaro pinkatha-ritatsiri Paamaa-riniki aajatzi Katsimaariniki, ithonka ititaka amithori-pathaki, yapirotaka ikamaki. Iriima pasini pinkathari-payi, siyajiitaka anta otzisi-masiki. ");
INSERT INTO prq_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Ikanta pinkathari-payi apirotan-taintsiri, yayitanakiri iwaritiki, iwaararo pinapirota-chari okaratzi tzimatsiri Paamaa-riniki aajatzi Katsimaariniki. Jaitijiitaji. ");
INSERT INTO prq_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Tima anta Paamaa-riniki, ari inampitarori Lot itomin-thori Abram. Yaitanakiri aajatzi irirori, ari okaratzi yaitanakiro iwaararo. ");
INSERT INTO prq_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Iro kantacha tzimatsi aparoni siyanain-chari, ikamantakiri Abram, Heber-iiti, isaikira irirori iwankiri-masiki aparoni atziri paitachari Mamre, Tonkaarisatzi. Yoka Mamre, tzimatsi pasini iririntzi ipaita Escol pasini ipaita Aner. Yaapatyaani-payi inatzii Abram. ");
INSERT INTO prq_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Ikanta ikimawaki Abram inosikai-takiri itomin-thori, yapatotakiri itomi yawiinta-pirotani impiratani-payi, ikarajiitzi 318 atziri. Iyaatzisita-nakiri pinkathari irojatzi iipatsitiki Dan-iiti. ");
INSERT INTO prq_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Okanta otsitinitanaki, itsiparyaa-yitakiri iwayiriti Abram, imapokakiri iwayiritari 4 pinkathari-payi. Imatakiri yiitsinampaakiri, ipatzimata-nakiri irojatzi Pitakawiniki katonko Ontyaamairiniki. ");
INSERT INTO prq_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Tima yaawajiro maaroni awaararontsi yaawitai-tanakari. Yaawajiriri itomin-thori Lot, yaawajiro okaratzi yasitari. Yaawajiro kooya-payi, aajatzi pasini atziri-payi ikaratzi yaitai-tanakiri. ");
INSERT INTO prq_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Ikanta ipiyajaro Abram, imatakirira yiitsinampaakiri pinkathari Quedorlaomer, aajatzi pasini pinkathari-payi ikaratzi aapatyaa-kariri. Ari ijataki pinkatha-ritatsiri Paamaa-riniki imonthaa-waari otaapiiki omamiri-pathatzi, ipaitai-tziro aajatzi Pinkatha-ryaari. ");
INSERT INTO prq_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Ikanta Melquisedec pinkatha-ritatsiri Aapatyaawiniki, Impira-tasorintsitaa-riti Pawa Jinoki-satzi, yaanakiro yatantaitari aajatzi imiritaitari. ");
INSERT INTO prq_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Iwithata-waari Abram intasonka-wintai-tantyaariri, ikantawajiri: “Tasonka-winta inkantimi Jinoki-satzi Pawa, Owitsika-kirori inkiti aajatzi kipatsi. ");
INSERT INTO prq_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Owisiryaawintaari inatzii Jinoki-satzi Pawa, Iri kantakaarori piitsinampaan-takariri owayiritamiri.” Ikanta Abram yaaki kapichiini okaratzi yaapithatan-tawajiri iwayiritaka, ipakiri Melquisedec. Ipoñaa yaminakiro tsika okaratzi awaararontsi yaapithata-wajiriri iwayiritari, ontzimi-rika onkarati 10, aparoni yasitakai-yaari Melquisedec. Ari ikantakirori okaratzi yaapithatan-tawajiri, ontzimi-rika 10, aparoni yasitakai-yaari. ");
INSERT INTO prq_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Ikanta pinkatha-ritatsiri Paamaa-riniki ikantakiri Abram: “Pimpinari atziri-payi ikaratzi paawairi, payiro awiroka awaararontsi.” ");
INSERT INTO prq_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Iro kantacha yakanakiri Abram yoka pinkathari, ikantziri: “Tima nokaman-takiri Jinoki-satzi Pawa owitsika-kirori inkiti aajatzi kipatsi, ");
INSERT INTO prq_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","airo naawaitzi kapichiini okaratzi pasitari awiroka, airo naawaitzi aajatzi ompaityaa noosotan-tyaari nokyaa-piintari noitziki. Ari onkantyaa airo pikantanta apaata: ‘Nashaaranta-kaakari Abram.’ ");
INSERT INTO prq_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","tikatsi noninti naaka, apatziro nonintziro okaratzi iwayitakari nompiratani-payi. Iriima ikaratzi tsipayita-kanari, yoka Aner, Escol, Mamre, yaayitaki okaratzi inintakiri irirori.” ");
INSERT INTO prq_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Ari iñaanatairi Pawa imisiri-kiini Abram, ikantairi: “¡Abram! Airo pipinka-waitziro anta, naakataki kisakowin-tyaamini. Antaroiti onkarati nompina-tajimiri.” ");
INSERT INTO prq_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Ari yakanaki Abram, ikantanaki: “¡Pawá! Piyotzi awiroka tikatsi notomi. ¿Paitama apantyaa-roni pimpinatina? Tima iriitaki nonampiri Eliezer Ontyaamairini-satzi asitajyaa-roni okaratzi tzimimo-tanari.” ");
INSERT INTO prq_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Aikiro ikanta-nakitzi Abram: “Ti pininti intzimi nontomi-tyaari, irootaki yasitan-tajyaarori yoka Eliezer nonampiri okaratzi tzimimo-tanari.” ");
INSERT INTO prq_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Yakanaki Pawa, ikantziri: “Iri piwaiyani awiroka asitajyaa-roni maaroni tzimimo-tzimiri, kaari pasini-satzi asitajyaa-roni.” ");
INSERT INTO prq_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Ari imisitowa-kiri intakiroini iwanko, ikantziri: “¡Abram! Pamini inkitiki, pithotyiiri piyotiri tsika ikaratzi impokiro. Ari inkantajyaari ishikiti pincharini-tajyaari, tima inkimitajyaari ishikitzi impokiro.” ");
INSERT INTO prq_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Aripaiti yawintaa-nakari Abram yoka Pawa, irootaki ikimita-kaantaariri itampatzika-siritani. ");
INSERT INTO prq_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Okanta otsitiniityaa-naki, opokimo-takiri Abram antaroiti iwochokini, maanaki. Ari omapokakiri antaro tsitinikiri anaapaakiri, antaroiti itharowan-tana-karo. ");
INSERT INTO prq_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Ari iñaanatakiri Pawa, ikantziri: “¡Abram! Ontzimatyii piyotiro nonkantiri, inampita-kyaaro apaata pincharini-tajyaari pasiniki kipatsi, onkarati 400 osarintsi isaiki anta. Ari impira-waitaityaari, oshiki isintsiwin-taitiri yantawai-takai-tiri. ");
INSERT INTO prq_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Iro kantacha, ari nowasankitaa-kiri naaka ompirawai-tyaarini. Aririka onkaratapaaki, aritaki isitowaji, ontzimi-motairi oshiki iwaararo. ");
INSERT INTO prq_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Irooma awiroka, tikatsi awishi-motimi-ni, kamiitha pinkamaji pantyasipari-tapaaki, pintsipa-tajyaari picharinii-tini. ");
INSERT INTO prq_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Aririka osamanitaki apaata, aritaki impiyaji picharini-payi aka, tikira nosamana-kyaaroota iyaaripironka Tonkaarisatzi nampitarori iroñaaka aka.” ");
INSERT INTO prq_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Ti onkanti iwaiyan-takairo Sarai oimi Abram. Iro kantacha tzimatsi ompiratani, opaita Agar, Apitantoni-sato onatzii. ");
INSERT INTO prq_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Okanta Sarai okantakiri oimi: “¡Pikimakí! Kimitaka ti ininta-kayinaro Pawa nowaiyanti. Iro kantacha nonintaki pimaantyaaro ampiratani Agar, piwaiyan-takairo, iriitaki nonkimita-kaantiri nowaiyani inatzii naaka.” Tima onimotakiri Abram okantakiriri iina Sarai. ");
INSERT INTO prq_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Aakiro Sarai onampiri iroka Apitantoni-sato, opakiri Abram iinantyaaro. Tima tzimaki 10 osarintsi inampitakaro Owintiniki. ");
INSERT INTO prq_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Ikanta imaantakaro Abram impiratani Agar, imotyaata-kaakiro. Okanta oñaaka omotyaataki Agar, okisaniinta-nakiro Sarai. ");
INSERT INTO prq_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Iro okantan-takariri Sarai oimi Abram, okantziri: “Awiroka kanta-sitakaro okisaniintan-tanari Agar. Naakawitaka opakimirori piinantyaaro, okanta oñaaka omotyaataki, ari onintzi anaakotina iroopiroti. Iro kantacha iri Pawa yotzirori ipaita-rika kanta-sita-karori naaka, aama awiroka-rika.” ");
INSERT INTO prq_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Ikantzi Abram: “¡Kimakí! Tima pimpiratani onatzii iroka kooya, awiroka yotironi tsika-rika pinkantiro.” Iroora owasankitaan-takarori ompiratani, irojatzi osiyantakari Agar. ");
INSERT INTO prq_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Iro kantacha iñaakiro Imaninkariti Pawa otzisi-masiki, osaiki-motakiro nijaatinka awotsiki jatachari Tantotsiwiniki. ");
INSERT INTO prq_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Isampitakiro Agar, ikantziro: “¿Tsikama pikinapaakika? ¿Tsika pijatika?” Ari akanakiri iroori, okantanakiri: “Nosiya-pithatyaaro Sarai ompiratanari.” ");
INSERT INTO prq_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Ikantanakiro Imaninkariti Pawa: “¡Agar! Pimpiyi owankoki ompiratamiri, pantiniro onkarati ompiratyaamiri.” ");
INSERT INTO prq_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Aikiro ikantana-kitziiro Imaninkariti Pawa: Ari noshikyaa-pirotajiri piwaiyani, tikatsi yomitairini tsika inkarati tzimatsini, ishiki-pirotaji. ");
INSERT INTO prq_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Ari motyaatakimi iroñaaka, intzimi aparoni pitomi, Iri pimpaitiri “Ikimi Pawa,” tima ikimakimi Pawa pikimaatsi-waitaka. ");
INSERT INTO prq_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Inkimityaari pitomi katsimari ikyaakoitari, masirinka inkantyaa. Imaimanitajiri atziri-payi, ari inkimita-jyaari atziri-payi imaimanitairi irirori. Oisokiro iwajiro inampi, onkanta-wityaa airo onimotziri ishininka-payi. ");
INSERT INTO prq_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Ari okinkitha-waita-kaakiri Agar yoka Pawa, iro ipaitai-tantarori: “Pawa Ñaantsi,” tima onkanta-nakitzii iroori: “Iñaana Pawa, ainirotatsi nañai.” ");
INSERT INTO prq_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Irootaki ipaitan-taita-karori iroka nijaatinka: “Inijaati Añaanita-tsiri Ñaakinari.” Tima iroka nijaatinka osaiki niyaanki-thaki awotsi jatachari Tasorinchaariniki irojatzi anta Sharakawiniki. ");
INSERT INTO prq_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Okanta owaiyan-takiri itomi Abram, ipaitakiri Ismael. (Tima ari ikantziri iñaaniki iriroriiti “Ikimi Pawa.”) ");
INSERT INTO prq_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Tzimaki Abram okaratzi 86 isarintsiti, arira itzimakiri Ismael. ");
INSERT INTO prq_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Ari tzimaki Abram okaratzi 99 isarintsiti, ari iñaakajari Pawa, ikantairi: “Pisaiki-motina kamiitha. Airo otzimawaitzi kaaripirori pantzimo-tinari, tima naakataki Pawa Sintsi-pirori. ");
INSERT INTO prq_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Aritaki ontzimaki ankasiyakaa-wakaiyaari. Tima aritaki nomapiro-takiro noshikyaa-jimiri pincharini-tajyaari.” ");
INSERT INTO prq_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Ari ityiirowa-naka Abram, oiyootanaka kipatsiki. Aikiro iñaanata-tziiri Pawa, ikantziri: ");
INSERT INTO prq_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“Iroka nokasiyakai-miri. Awiroka incharinitaiyaa oshiki atziri-payi inkarati nasiyitachaniri ishininka-tawakaiyaa tsikari-payi, onkimiwai-taiyaaro awirokami iriri. ");
INSERT INTO prq_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Iroñaaka pimpaitaiyaa “Abraham”, tima irootaki owaitakaan-taimini “Iriri Oshiki-tatsiri”, airo ipaitai-tajimi “Apá Jinoki-satzi”. ");
INSERT INTO prq_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Oshiki inkarataji pincharini-tajyaari, tzimatsi matacha-ni impinkathariti, inasiyi-taiyaaro impiyotaiyaa inkarati ishininka-tawakaiyaa. ");
INSERT INTO prq_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Iroka nonkasiyakai-miri awiroka, irojatzi nonkasiya-kaiyaariri inkarati pincharini-tajyaari apaata. Naaka-tapiintaki Piwawanitaiyaa, naakatzitaka Iwawanitaiyaari inkarati pincharini-tajyaari. ");
INSERT INTO prq_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Nompaimiro maaroni Owintini tsika pisaikaki iroñaaka, ari pinampi-taiyaaro. Awirokataki asitajyaa-roni, irojatzi yasitajyaari inkarati pincharini-tajyaari. Irasi iwatyiiro yasitajyaaro, naakataki Iwawanitajyaa.” ");
INSERT INTO prq_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Aikiro iñaawai-tatzii Pawa ikantziri Abraham: “Pimatiro akasiyakaa-wakaa-kari, imatzitajyaaro aajatzi inkarati pincharini-tajyaari. ");
INSERT INTO prq_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Irojatzitaka akasiyakaa-wakaa-kari, ontzimatyii imatairo inkarati pincharini-tajyaari. Tima maaroni siramparipayi intomisi-taani-tajyaa. ");
INSERT INTO prq_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Pintoyi-tajiro opatzi-misina pisirampari-tantari. Irootaki iyotantai-tyaari tzimatsi akasiyakaa-wakaari arokaiti. ");
INSERT INTO prq_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Iroñaaka itanakyaaro intomisitaanitajyaa piinchaa-nikiti tzimako-taintsiri 8 kitaitiri itzimaki. Imataitiri aajatzi owaiyaniiti pitzika-tani owakira tzimayi-tatsiri, impoña pimatakiri pitzika-tani owakira pamananta-yitziri kaari pishininkatyaa. ");
INSERT INTO prq_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Ontzimatyii intomisi-taanii-tiri apitiroiti: iinchaa-niti pitzika-tani, iinchaa-niti aajatzi pamanan-tani. Irootaki iñaitan-tyaarori piwathaki okaratzi akasiyakaa-wakaa-kari. Asi owaitaa-tyiiro iroka. ");
INSERT INTO prq_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Iriima ikaratzi kaari totamisi-taani-tacha-niri, ontzimatyii imisitowai-tiri airo pitsipa-taari pinampiki, okantakaan-tziro ti imatiro akasiyakaa-wakaa-kari.” ");
INSERT INTO prq_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Ikantana-kiri Pawa aajatzi Abraham: “Iroñaaka ompaitaiyaa piina Sara, tima iro ompaitan-tajyaari iroñaaka “Irisinto Pinkathari”, airo opaitaja Sarai. ");
INSERT INTO prq_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Antaroiti nontasonka-wintiro, ari owaiyantaji iroori, intzimaji pitomi. Omaapiro nontasonka-wintairo. Oshiki inkarataji owaiyani, tzimatsi pinkatha-ritatsi-ni. Tima oshiki-piro inkantajyaa osarintajyaari inasitajyaaro impiyotajyaa ikaratzi ishininkatawakaajyaa, onkimiwai-tajyaaro iroomi inirontajii-tyaa.” ");
INSERT INTO prq_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Tyiirowa-naka Abraham, oiyootanaka kipatsiki, isironta-sirita ikantzi: “¿Kantatsima iwaiyan-takaanti antyasipari tzimaintsiri 100 isarintsiti? ¿Arima onkantaki aajatzi owaiyantaji Sara antyasiparotaki otzimaki 90 osarintsiti?” ");
INSERT INTO prq_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Ikantzi Pawa: “Nokanta-tziimi naaka ari owaiyantaki piina Sara intzimi pitomi, iriitaki pimpaitiri Isaac. Iriitaki mapirotai-roniri akasiyakaa-wakaari, airo nowashaan-takaa-jiri inkarati incharini-tajyaari irirori. ");
INSERT INTO prq_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Ikanta ithonkana-kiro Pawa ikinkitha-waitakaa-kiri Abraham, ari ipyaa-pitha-tanaari. ");
INSERT INTO prq_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Ikanta apaata, isaikawaitzi Abraham ikyaapiintaitzi iwankothaantiki tampatzika-paiti ooryaatsiri, iñaakaajari Pawa anta inchato-masiki ipaitai-tziri Yiinkantomasi. ");
INSERT INTO prq_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Ikanta yaminaki Abraham iñaatzii mawa atziri. Sintsiini isiyanaka imonthaa-wakari, ityiirowa-sitawakari, yoiyotanaka kipatsiki. ");
INSERT INTO prq_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","Ikantawa-kiri: “¡Nowinkatharití! Apaata pawishi, ");
INSERT INTO prq_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","namawakimi kapichiini nijaa pinkiwa-kiitzityaari, pisaikimai-tyaa ontsimankira inchatosi pimakoryaa-waitanaki. ");
INSERT INTO prq_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Tima naakataki pimpira-tani pariitakari iwankoki. Apaata naminawaki piwapaakyaari inkini pisintsiti pawisanaki.” Ikantajiitzi irirori: “Ariwí, kamiithataki.” ");
INSERT INTO prq_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Kyaanaki Abraham iwankothaantiki, ikantapaa-kiro iina: “¡Kooyá! Sintsiini pinkantyaa pamini pankirin-tsipani, pijaikitaki onkarati mawa piwan-tapiintarori, piwitsiki ayaari pintasi-yitakiro.” ");
INSERT INTO prq_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Isiyapainta Abraham isaiki ipira-payi, yamaki awankiri vaca, watha-tatsiri. Ipakiri inampiri, iriitaki oowosantirini sintsiini iyaari. ");
INSERT INTO prq_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Tira apatziro awankari vaca yamaki Abraham, yamitaka-niri aajatzi iyaaki othomi vaca. Iwakotaki-niri otsimankakira pankirintsi tsika isaikajiitaki ariitariri, ari iwajiitakani. ");
INSERT INTO prq_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Ikanta ithonkakiro iwajiitakani, yokaiti ariitzinkari isampitakiri Abraham, ikantziri: “¿Tsikama piina Sara?” Ikantzi Abraham: “Osaiki inthompointa.” ");
INSERT INTO prq_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Ikantzi ariitzinkari: “Aririka nompiyaji pasini osarintsi noñaapajiro Sara tzimaki otomi.” Kimisantaki Sara ikinkitha-waijiitzi Abraham, osaikaki antaki-ronta ikyaapiintaitzira owankothaantiki, itaapii-takara oimi. ");
INSERT INTO prq_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Antyasipari-jiitaki apitiroiti Abraham aajatzi Sara. Karatapaaki oñaawaita okooya-tantari. ");
INSERT INTO prq_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Irootaki kaari amawitan-tanakaro osirontyaa, okanta-siri-tanaki: “Tima antyasiparo-takina naaka, aajatzi ikimitakari noimi. ¿Arima onkantaki nowaiyantaji?” ");
INSERT INTO prq_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Isampitana-kiri Pawa yoka Abraham, ikantziri: “¿Paitama osirontantari Sara? ¿Tima onkimisanti ari owaiyantaji okantawitaka antyasiparo-witaka? ");
INSERT INTO prq_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","¿Tzimatsima pomirintsi-tzimo-tyaari-ni Pawa? Aririka nompiyaki pasini osarintsi nariityaami, ari noñaapajiro Sara tzimaki otomi.” ");
INSERT INTO prq_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Okanta okimawaki Sara, antaroiti otharowa-naki, okowawi-tanaka omaniro ikantai-takiri, okantanaki: “Ti nosirontyaa.” Ari ikantana-kiro irirori: “Noyotaki naaka pisirontaka.” ");
INSERT INTO prq_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Ikanta ithonkakiro Pawa ikinkitha-waitakairi Abraham, jataji. Piyaja irirori Abraham iwankothaantiki. ");
INSERT INTO prq_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Aritaki tsitini-tzimataki, ariijiitakani Paamaariniki apiti maninkari. Isaikaminthaitzi Lot okyaapiintzi awotsi anta nampitsiki, tsika ipiyo-tapiinta-jiita atziri-payi. Ikanta iñaawakiri, isiyanaka imonthaa-wakari, ityiirowa-sitawakari, yoiyootanaka kipatsiki, ipinkatha-tawakiri. ");
INSERT INTO prq_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","Ikantawa-kiri: “¡Pinkatharí! Thami nowanko-thaantiki nonintzi pimai-motanakina. Iroka nijaa pinkiwa-kiitzityaa. Onkitaiti-tamanairika pawishi.” Ikantajiitzi iriroriiti: “Aritaki, nomayi aka.” ");
INSERT INTO prq_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Aikiro isintsi-tatzii Lot, irojatzi ikowantana-kari ariitzinkari iyaatana-kiri iwankoki. Inkotsi-takaan-taki oshiki owaritintsi, aajatzi yatantyaariri, yakyoo-jiitakirini ariitzinkari. ");
INSERT INTO prq_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Tikira imaajiitiniita, ipokajii-tapaaki Paamaarini-satzi, ishonkapaa-kiro pankotsi isaikajiitakira, oshiki awankariiti itsipatakari antari-konapayi, maaroni. ");
INSERT INTO prq_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Ikaimapaa-kiri Lot, ikantziri: “¿Tsikama isaikika ariitapain-chari otsitiniityaaki piwankoki? Pimisitowiri, nokowatzii nomaimanitiri.” ");
INSERT INTO prq_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Ari isitowana-kiri Lot ikinkitha-waitakairi atziri-payi, yasitako-piro-takiri ariitzinkari. ");
INSERT INTO prq_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","Ikantziri: “¡Noyomparí! Paamaiyaa pantziro = kari kaaripirori. ");
INSERT INTO prq_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Tzimatsi apiti nosinto tikira oñiiriita sirampari. Pikowi-rika aritaki nomisitowa-kimiro, irootaki pimaimaniti pantiro pinintziri awiroka. Ti noninti pimaimanitiri ariitanari nowankoki, nokaimakaan-tani inatzii.” ");
INSERT INTO prq_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Kisajii-tanaka Paamajaa-risatzi ikimawakiri ikantaki Lot. Ikantawakaa-jiitanaka: “Paminiri yoka ayompari, owakira yariita irirori, ikowapaaki impira-tantapaa-kyaa.” Ikantajii-tanakiri aajatzi: “Pintainki, awirokataki nomapiroti nompasa-waitimi.” Ari itachaanka-nakiri Lot. Ipokajii-tapaaki okaakiini iwankoki, inintzi itanto-ryiiro yasitan-tarori iwanko. ");
INSERT INTO prq_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Ari yakotanaki ariitzinkari, yakatha-tajiri Lot iminkyaa-jiri iwankoki. Yasitana-kiro. ");
INSERT INTO prq_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Ithonka ikamaraakitanaki awankari-payi aajatzi antari-konapayi. Ari yamina-mina-witaaro asitakoro pankotsi isitowan-taiyaarimi, aasijii-takarini imakori. ");
INSERT INTO prq_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Iñaawai-tanaki ariitzinkari, ikantziri Lot: “¿Tzimatsima pasini pishininka aka? Paanakiri pitomi-payi, pisinto-payi, aajatzi pitziniri-payi. Paanakiri aajatzi pikarajiitzi pisaiki aka nampitsiki ");
INSERT INTO prq_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","Tima napirotatyiiro iroka nampitsi. Okimiwai-takaro onkaima-kaima-tatyiimi iyaaripironka atziri-payi nampitarori aka. Irotaki ityaankan-takanari Pawa napirotiro.” ");
INSERT INTO prq_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Ari ijatanaki Lot iñiiri itziniri-payi okasiyari irisinto-payi oimintyaari, ikantapaa-kiri: “Pisitowi nampitsiki, yapirotatyiiro Pawa.” Titzimaita inkimisanta-jiiti itziniri-payi Lot, isiyakaantzi ikantawaisita. ");
INSERT INTO prq_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Okanta okitaiti-tzimataki, yapiitana-jiro maninkari, ikantziri Lot: “¡sintsiini pinkantyaa! Tirika pinintzi pinkami iwasankitai-tiro iroka nampitsi, pisiyakairo piina aajatzi apiti pisinto.” ");
INSERT INTO prq_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Niitsikiroini ikanta Lot ti intharokyaati, akotanaki maninkari-payi yakatha-wako-tanakiri, tima itakoki iwiri Pawa yoka Lot. Ari ikimitana-kirori iina aajatzi irisinto-payi. Yookakiro intakironta nampitsi, awisako-tantajyaari. ");
INSERT INTO prq_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Aritaki saikapaaki Lot intakiroini nampitsiki, ari yapiitana-jiri maninkari, ikantziri: “Pisiyi. Apatziro piwanakiro pijati tonkaariki, airo pisaika-waitanaki niyaanki-thaki awotsi, airo paminawaitzi aajatzi pitaapiiki, pawisako-tajiita.” ");
INSERT INTO prq_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Ari yakanaki Lot, ikantana-kiri: “Airo okantzi nowinkathariti. ");
INSERT INTO prq_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Oshiki kamiithari pantzimo-takinari, antaro pinisironka-takana piwawisaako-tajana. Kimitaka airo nomatziro nosiyi tonkaariki, aritaki nonkamaki ariitawa-kyaana yapiroi-tantyaarori nampitsi. ");
INSERT INTO prq_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Tzimatsi aka okaakiini, yanini nampitsi. Ari nosiyiri anta. Pisinitina nojati airo nokamanta. Tima yanini onatzii nampitsi.” ");
INSERT INTO prq_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Ari ikantzi maninkari: “Nokimakimi, aritaki nomatakiro pikowako-takinari. Airo napirotziro iyaaniini nampitsi. ");
INSERT INTO prq_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Pijatana-kiita iroñaaka. Airo napirotzitaro nampitsi tikiramintha pariityaata tsika pisiritakaro.” Irootaki ipaitan-taitarori anta Nampi-chaaniki. ");
INSERT INTO prq_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Ikanta okitaiti-tamanaki, ariitaka Lot anta Nampi-chaaniki. ");
INSERT INTO prq_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Iwaryaaki Pawa paamari kitiri-moito okantapaaka anta Paamaariniki aajatzi Katsimaariniki. ");
INSERT INTO prq_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Yapirotakiri saikantarori nampitsi, imatakiro maaroni shookayi-tatsiri anta otaapiki. ");
INSERT INTO prq_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Pokawitacha iina Lot, oyaatakiri oimi, ari aminapaintzi otaapiiki, opyaanakaro tziwithantha. ");
INSERT INTO prq_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Ikanta okitaityaa-manaji, ananinka-manaka Abraham anta ikinkitha-waitakaa-kiri chapinki Pawa. ");
INSERT INTO prq_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Yaminapaaki antó otaapiki osaiki nampitsi Paamaarini, aajatzi Katsimaarini, iñaatziiro okachaa-rinkataki, okimiwai-takaro okachaatzi pomitaantsi. ");
INSERT INTO prq_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Imatakiro Pawa yapirotziro nampitsi inampiwitaro Lot. Titzimaita ipyaakotari Pawa yoka Abraham, iwawisaako-tajiri itominthori Lot yapirotajyaami irirori. ");
INSERT INTO prq_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Tima osiriki iwiro Pawa iroka Sara, mataka ikasiyakaa-karori. ");
INSERT INTO prq_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Motyaataki, monkarataka ikantaki-rori tsika-paiti intzimi. Owaiyan-takiri otomi okantawitaka antyasipari-witaka Abraham. ");
INSERT INTO prq_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Imatakiro Abraham ipaitakiri itomi Isaac. ");
INSERT INTO prq_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Ikanta imaakotapaaki 8 kitaitiri, yaanakiri itomisi-taani-tziri, tima irootaki ikantaki-riri Pawa. ");
INSERT INTO prq_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Aritaki tzimaki Abraham okaratzi 100 isarintsiti itziman-takari Isaac. ");
INSERT INTO prq_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Okanta osamanitaki, inintaki Pawa iñiiro yawintaa-sirinka Abraham. Ikaimakiri ikantziri: “¡Abraham! Ari yakanaki irirori, ikantzi: “Ipaitaka, aka nosaiki.” ");
INSERT INTO prq_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Ikantzi Pawa: “Pijati Pawaitoniki, paanakiri pitakopiro-tani pitomi. Nonintzi pimpomi-tinari onkatziyiin-kati ikachaa-rinka anta otzisiki tsika nookotimiro. Pinkimi-takaan-tiri iriimi atsipi-tako-wintyaa-mini pikaaripirotaki” ");
INSERT INTO prq_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Ikanta okitaiti-tamanaji ipiriin-tamanaka Abraham, iwitsika-kiri imorani. Iriitaki intsipa-tanakyaa apiti impira-tani, itomi Isaac. Yaanaki itsima impomitan-tyaariri. Jataki tsika yookotaki-niri Pawa. ");
INSERT INTO prq_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Ari yaniitaki okaratzi mawa kitaitiri, yamina-kotapaa-kiro antó tsika yariityaa. ");
INSERT INTO prq_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Ikantakiri impira-tani: “Ari pisaikawaki aka paminiri mora. Nojatawaki naaka nontsipa-tanakyaari notomi. Aririka nomatakiro nompinkathatiri Pawa, ari nompiyajiri.” ");
INSERT INTO prq_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Yaakiro Abraham tsitsi impomitan-tyaariri, yanatakaa-nakiri itomi. Yaanakiro irirori paamari, aajatzi kotsiro. Jaitijiitanakini apitiroiti. ");
INSERT INTO prq_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Tikira osamaniti isampitakiri Isaac iriri, ikantziri: “Apaa.” Ari yakanaki Abraham, ikantzi: “Ipaita pinintziri notomí.” Ikantzi Isaac: “Tzimatsi tsitsi, paamari, ¿tsikama ayika apira ampomitiri?” ");
INSERT INTO prq_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Ikantzi asitariri: “¡Notomí! Iyotzi Pawa tsika yayiri ipira ampomitiri.” Aikiro ijajiitatziini. ");
INSERT INTO prq_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Ikanta yariitapaaka tsika yookotaki-niri Pawa, iwitsiki ipomi-pirini-minto Abraham, ipiwirika-kiro itsima. Yaakiri itomi yoosotakiri, inaryaakiri pomipirini-minto-tsiki ipiwirika-kiro itsima. ");
INSERT INTO prq_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Iro itzinaa-witanakaro kotsiraaniki isataantyaarimi itomi, ");
INSERT INTO prq_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","ikaima-kotakiri imaninkariti Pawa, ikantziri: “¡Abraham! ¡Abraham!” Akanaki irirori ikantzi: “Ipaitaka, aka nosaiki.” ");
INSERT INTO prq_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Ikantzi maninkari: “Airo pisatairi iintsi, noyotakimi oshiki pipinkatha-tziri Pawa, tima ti pinthañaa-pitha-tyaari papintziti pitomi.” ");
INSERT INTO prq_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Ari yaminanaki Abraham, iñaatziiri ipiraitari yayiintaka ichiiki incha-maisiki. Yaakitziri, iriitaki impoyii-takariri itomi, kachaaryiinka ikantaka ipomitakiri. ");
INSERT INTO prq_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Irootaki ipaitan-tanakarori Abraham irontá otzisi: “Ipantzi Pawa.” Arira ikantapiin-taitanaki: “Impan-tapiintaiti kowityii-motairi itzisiti Pawa.” ");
INSERT INTO prq_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Ari yapiitakiro imaninkariti Pawa isaikakira inkitiki ikaima-kotajiri Abraham, ");
INSERT INTO prq_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","ikantziri: “¡Abraham! Okantakaan-tziro ti pinthañiiyaari papintziti pitomi, naaka pinkima-jaanti nopaantiki iroñaaka. Iroka nokantzi: ");
INSERT INTO prq_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","‘Omapiro nontasonka-wintimi Naaka. Naaka shikyaa-jirini pincharinita-jyaari inkimitajyaari ishikitzi impokiro, inkimitajyaaro oshikitzi impaniki nijaathapyaaki. Iriitaki iitsinampaa-jiri-niri iisaniin-tani. ");
INSERT INTO prq_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Iriitaki kantakaa-jyaaroni picharini-payi intasonka-wintantai-tyaariri maaroni nasiyitacha-niri ishininka-tawakaiyaa kipatsiki. Okamintha pikimisan-tajiro awiroka nokantzimiri.’ ” ");
INSERT INTO prq_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Okaratzi 127 osarintsi añaaki Sara. ");
INSERT INTO prq_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Ari okamajiri iroori anta ipaitai-tziro “4 Asitaro Inampitsiti”, irojatzi ipaitai-tziri “Aripiro-taarini” saikatsiri anta Owintiniki. Antaroiti iraako-waitakaro Abraham okamajira Sara. ");
INSERT INTO prq_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Ari mapirotaka antyasiparitaki Abraham, oshiki itasonka-wintakiri Pawa. ");
INSERT INTO prq_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Ikaimakiri antaripiro-taintsiri impira-tani, amininiriri okaratzi tzimimo-tziriri. Ikantakiri: “Pairika-chokitina”. ");
INSERT INTO prq_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","Pinkantapirotina, pimpairyiiri Pawa Iwawani-taitari inkitiki aajatzi kipatsiki, airo pisinitanari notomi iinantyaaro Owintini-sato saikatsiri aka. ");
INSERT INTO prq_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Ontzimatyii pijati nonampii-tiki, pamininiri noshininka naaka iinantyaari.” ");
INSERT INTO prq_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Ari yakanakiri impira-tani, ikantziri: “Airorika onintzi ompoki mainaro, ¿tsikama nonkantyaaka? ¿Naanakirima pitomi pinampii-tiki pipoñaaka pairani?” ");
INSERT INTO prq_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Ikantzi Abraham: “Airo, okantzi payinari notomi anta. ");
INSERT INTO prq_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Tima Pawa, Iwawanitari inkiti-satzi, amajanari pairani iipatsitiki asitanari, iipatsitiki aajatzi nocharini. Ikantakina pairani: ‘Ari nompajiri iroka kipatsi inkarati pincharini-tajyaari.’ Tima irootaki ikasiyakaa-kinari, aritaki intyaan-takimi imaninkariti, tsipatyaa-miniri pamantyaari kooya iinantyaari notomi. ");
INSERT INTO prq_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Airorika onintzi oyaatimi kooya, pimonkara-tzimaitakaro nompira-takamiri naaka. Titzimaita noninti payinari notomi anta.” ");
INSERT INTO prq_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Imatakiro impira-tani, yairika-chokitakiri Abraham, ikantaki: “¡Omaapiro nowinkatharití! Airo namatawi-tzimi, aritaki nantakiro okaratzi pikantaki-nari.” ");
INSERT INTO prq_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Ikoyaana-kiro tzimimo-tziriri ompiratariri, irootaki impasitan-tyaari. Yaanaki 10 ipira ikyaakoi-tari, jataki inampitsitiki Nacor ipaitai-tziro Osampanaaki anta Tonkariniki. ");
INSERT INTO prq_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Ikanta yarii-tzimataka nampitsiki, imakoryaa-kaapaa-kiri ipira-payi osaiki nijaatinka. Aritaki tsitiniityaaki, irootaintsi intityaa ooryaatsiri opokapiin-tzira kooya-payi ayi nijaa. ");
INSERT INTO prq_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Amanapaaki, ikantzi: “Pawa, Iwawani ompiratanari Abraham, awiroka kantakai-yaaro-niri omatantyaari nonintziri, pinisironka-tiri ompiratanari. ");
INSERT INTO prq_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Ari nosaikawaki aka ikaapiin-taitzi, tsika opokayitzi awankaropayi ayi nijaa. ");
INSERT INTO prq_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Awiroka kantakai-yaaro-niri aririka nonkantakiro aparoni mainaro: ‘Pisinitinaro piyowitziti nirawakiita nijaa.’ Onkantanaki iroori: ‘Pirawaiti. Kantatsi nompiri nijaa ikyaakoi-tari-payi.’ Irootaki mainaro pikowakaa-kiriri pimpira-tani Isaac. Ari noyotiri pitakotari ompiratanari.” ");
INSERT INTO prq_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Tikira ithonkiroota yamani, pokapaaki aparoni mainaro anatakiro oyowitziti oshimpaki. Irootaki Rebeca irisinto Betuel. Tima yoka Betuel iriitaki otomi Milca iwaiyan-takaa-kirori Nacor iririntzi Abraham. ");
INSERT INTO prq_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Kamiithaanto onatzi Rebeca, titzimaita oyotiri sirampari. Oirinkapaaka nijaatinkaki, okaapaaki nijaa, iro ompiyana-kimi. ");
INSERT INTO prq_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Ari isiyasi-tawakaro ompirataari, ikantapaa-kiro: “Pimpina kapichiini nijaa payiri piyowitzitiki nirawa-kiita.” ");
INSERT INTO prq_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Okantzi iroori: “Pirawaiti nowinkatharití.” Sintsini owayiitana-kiro oyowitziti, oitakiri nijaa airika-kotaki-niri. ");
INSERT INTO prq_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Ithonkakiro iraki nijaa ompirataari, okantana-kiri Rebeca: ‘¡Jiwari! Naawaki pasini nijaa nompiriri ikyaakoi-tari-payi, irojatzi irantakyaa maaroni irirori.” ");
INSERT INTO prq_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Intsipayini osiyapainta okai nijaa osakiro yirapiintzi piratsi, oshiki opiyapiyataka, ojaikitaki-niri irajiititiri ikyaakoi-tari-payi. ");
INSERT INTO prq_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Ari yaminamintha-takiro ompirataari tikatsi inkantiro, tima ikowatzii iyoti iriirika Pawa kantakaa-rori omatantakari iñaakiri. ");
INSERT INTO prq_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Ikanta thonkaka irajiitaki ipira, inosikana-kiri iwitsikai-tziri ooro, pinapiro-tachari. Ithatakiniro okirimasiki. Ipakiro apiti omatyaari akoki, pinapiro-tachari aajatzi. ");
INSERT INTO prq_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Ikantana-kiro: “Pinkantina, ¿Ipaitama asitamiri? ¿Antitachama iwanko nomayi-motimi nontsipa-tyaari nokarajiitaki?” ");
INSERT INTO prq_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Okantanaki iroori: “Naakataki irisinto Betuel, owaiyan-tani Milca irisinto Nacor. ");
INSERT INTO prq_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Tzimatsi tsika pimaajiiti, tzimatsi aajatzi oshiki iyaari pipira-payi.” ");
INSERT INTO prq_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Ari ityiirowa-naka ompirataari, ipinkatha-tanakiri Pawa. ");
INSERT INTO prq_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","Ikantanaki: “Kimosiri-wintaari pinatzi Pawa, Iwawani ompiratanari Abraham, ti pamatawi-tiri pinisironka-tani ompiratanari. Awiroka amakinari aka noñaantaka-rori iwanko ishininka-thori.” ");
INSERT INTO prq_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Ti osaikanaki Rebeca, osiya-piro-tanakityaa owankoki osaiki oniro, okamantapaa-kiro. ");
INSERT INTO prq_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Tzimatsi oyaariri Rebeca ipaita Labán, iriitaki siyanainchari ikaapiin-taitzira nijaa iñiiri atziri. ");
INSERT INTO prq_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","Tima iñaawakiri othataniki okirimasiki aajatzi omarintsi iwitsikai-tziri ooro omayitakari iritsiro akoki, ikimawakiro aajatzi okamantan-tapaa-ki ikantaki-rori ompirataari. Ikanta yariitapaa-kari Labán impira-tani Abraham isaikakaakiri ipira-payi ikaapiin-taitzira. ");
INSERT INTO prq_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Ikantapaa-kiri: “Pimpoki itasonka-wintani Pawá. ¿Ipaitama pisaikantari intyaatsikaini? Tzimatsi tsika pimaapaaki, tzimatsi aajatzi tsika piwapaakiri pipira-payi.” ");
INSERT INTO prq_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Ari ijatanaki ompirataari anta pankotsiki. Iwayiitaarantawakiri Labán ipira-payi ompirataari, ipakiri iyaari. Ipoñaa yamaitaki-niri nijaa ariitzinka-ripayi inkiwa-kijiityaari. ");
INSERT INTO prq_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Ikanta ipaitawa-kiri iwapaakyaari, ikantanaki impira-tani Abraham: “Airo nowitzita airorika nokaman-tzimiro nokowiri.” Ikantanaki Labán: “Intsityaa pimatiro.” ");
INSERT INTO prq_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Ikantzi ompirataari: “Naakataki impira-tani Abraham. ");
INSERT INTO prq_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Antaroiti itasonka-wintakiri Pawa ompiratanari, oshiki yashaaran-takaa-kari, tzimatsi ipira-payi, iiriikiti, ooro, ikyaakoi-tari-payi, tzimatsi oshiki yatziriti impiratari, tzimatsi aajatzi oshiki kooya-payi. ");
INSERT INTO prq_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Ari okimitzi-takari Sara okantawitaka antaro-konataki, owaiyantaji otomi. Iriitaki yasitakaa-jyaari ompiratanari okaratzi tzimimo-tziriri. ");
INSERT INTO prq_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Tima inintatzii ompirataka-nari nomonkara-piro-tiniri, ikantaki-nari: ‘Airo pisinitanari notomi iinantyaaro Owintini-sato saikatsiri aka. ");
INSERT INTO prq_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Apatziro pijatasitiri ishininka-thori asitanari, pamininiri notomi awankaro noshininka-payi naaka. Tima irootaki kamiitha-tatsiri iinantyaaro.’ ");
INSERT INTO prq_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Nokantanaki naaka: ‘¡Nowinkatharití! Aamaasityaa airo onintzi oyaatina mainaro. ¿Tsika nonkantyaaka?’ ");
INSERT INTO prq_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Ikantana-kina irirori: ‘Tima kamiitha nokantzimo-takari Pawa, aritaki intyaan-takimi imaninkariti intsipa-tyaami pijati, ari omatakyaa okaratzi nokantaki-miri. Aritaki pamaki kooya iinantyaari notomi, ishininka-thori asitanari. ");
INSERT INTO prq_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Airorika inintzi noshininka-thori impimiro irisinto, pimonkara-maitakaro awiroka nompira-takamiri’. ");
INSERT INTO prq_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","Ikanta nariitaka ikaapiin-taitzi, namanakiri Pawa Iwawani ompiratanari, nokantziri: ‘Omaapiro-rika pinisironkatana pimatakainaro nonintziri aka. ");
INSERT INTO prq_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Tima saikakina ikaapiin-taitzi, nonintzi pimatakainaro iroka mainaro pokaintsiri ayi nijaa, aririka nonkantawa-kiro: “Pimpina kapichiini nijaa piyowitzitiki, nirawakiita”, ");
INSERT INTO prq_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","aririka akanakina, onkantina: “Pirawaki, ari naaki pasini nompiriri pipira-payi irawakiri irirori”, irootaki iroka kooya ikowakaa-kiriri Pawa itomi ompiratanari.’ ");
INSERT INTO prq_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Tikira nonthonkiroota namani, noñaawakiro opokaki Rebeca anatakiro oyowitziti oshimpaki. Oirinkapaaka nijaatinkaki, okaapaaki. Ari nokantziro: ‘Pimpina pinijaati nirawakiita.’ ");
INSERT INTO prq_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Sintsiini owayiitana-kiro oyowitziti, okantana-kina: ‘Pirawaki, aritaki naaki pasini irawakiri aajatzi pipira-payi.’ Opakina nijaa nirawakiri, opitakari aajatzi nopira-payi. ");
INSERT INTO prq_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Ari nosampi-tanakiro, nokantziro: ‘¿Ipaitaka asitamiri?’ Okantzi iroori: ‘Naakataki irisinto Betuel itomi Nacor owaiyani Milca.’ Ari nokyaan-takaa-karo thatanintsi okirimasiki, nomatan-takaro akoki omarintsi-payi. ");
INSERT INTO prq_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Ari notyiirowa-nakari nopinkatha-tanakiri Pawa, nopanthaa-wintanakiri Iwawani ompiratanari Abraham, iriitaki amakinari nariitan-takari iwankoki ishininka-thori, namininiri iina itomi. ");
INSERT INTO prq_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Nonintzi pinkantina kamiitharika inintziri ompiratanari, tirika onimotimi pinkantina noyotan-tyaari ompaityaa nantiri.” ");
INSERT INTO prq_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Ikanta Labán aajatzi iriri Betuel, ikantanaki: “Iriitaki Pawa kantakaa-rori, tikatsi nonkanti naaka. ");
INSERT INTO prq_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Jiiroka Rebeca, paanakiro. Irootaki iinantyaari itomi ompiratamiri, irootaki inintakiri Pawa.” ");
INSERT INTO prq_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Ikanta ikimawaki impira-tani Abraham, oiyootanaka kipatsiki ityiirowa-naka ipinkatha-tanakiri Pawa. ");
INSERT INTO prq_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Imisitowana-kiro yamayitakiri iwitsikai-tziri ooro, kiriiki, kithaarin-tsipayi. Ipakiro maaroni Rebeca. Ipasitakari oyaariri aajatzi oniro. ");
INSERT INTO prq_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Owaajiitaka iroñaaka ompirataari, irawaijiitaki itsipatari oyaataki-riri. Maajiitaki. Okanta okitaiti-tamanaki, ipiriin-tamanaja, ikantanaji ompirataari: “¡Jiwarí! Irootaintsi nompiyaji iwankoki ompiratanari.” ");
INSERT INTO prq_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Titzimaita inintzi iyaariri Rebeca aajatzi iniro, okantanaki: “Apaata ojatzita niintsiti, nonintatzii omaanaji onkarati 10 kitaitiri. Irojatzi oyaatan-tanakyaamiri.” ");
INSERT INTO prq_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Ikantanaki ompirataari: “Airo pisamani-takaana, iriitaki Pawa kantakaa-karo nariitan-takari aka. Ontzimatyii nompiyi iwankoki ompiratanari.” ");
INSERT INTO prq_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Ikantajii-tanaki irirori: “Thami ankaimiro iroori, ankimiro tsika okantzi.” ");
INSERT INTO prq_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Ikaimai-takiro Rebeca, ari isampitai-takiro, ikantai-tziro: “¿Pinintzima piyaatana-kiri ompirataari?” Akanaki iroori, okantzi: “Jii, nonintzi noyaatana-kiri.” ");
INSERT INTO prq_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Ari isinitana-kiro Labán ojati iritsiro Rebeca ontsipa-tanakyaaro aamaakowin-tapiintarori pairani ainiro iintsitapaaki. Oyaatana-kiri impira-tani Abraham itsipatanaari ikaratzi oyaayitaki-riri. ");
INSERT INTO prq_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Iwithatawaaro oyaariri, ikantawa-jiro: Pijati chooki, Onkamintha iriniro-tyaami oshiki atziri. Onkamintha yaapitha-tajiri piwaiyani-payi inampi-payi ikisaniin-tani. ");
INSERT INTO prq_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Ari okyaako-tanakari Rebeca ipiraitari otsipatanakaro ompira-tanipayi aamaakowin-takarori pairani, oyaatana-kiri impira-tani Abraham. Imatakiro ompirataari yaanakiro Rebeca, piyanaja. ");
INSERT INTO prq_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Aritaki ariitzimataja irirori Isaac ipoñaajaro nijaatinkaki ipaitai-tziro “Añaani-tatsiri Ñaakinari”, inampiitiki irirori ipaitai-tziri Piryaariniki. ");
INSERT INTO prq_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Iyaatzii irirori yaniiwaitzi tsitinii-tiini. Ari yaminaki antó, iñaatziiri ipokayitaji ipira-payi ikyaakoi-tari. ");
INSERT INTO prq_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Ari okimatzi-takari Rebeca aajatzi, aminaki antó oñaakiri Isaac, ayiitanaki. ");
INSERT INTO prq_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","Osampitana-kiri ompira-taari, okantziri: “¿Itzimika yonta pokaintsiri?” Ikantanaki ompira-taari: “Iriitaki ompiratanari.” Ari aanakiro omanthaki, opasika-poro-pitha-tanakari. ");
INSERT INTO prq_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Tima ariitaja ompira-taari, ikamantapa-jiri Isaac okaratzi yantakiri tsika ijataitzi. ");
INSERT INTO prq_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Ari yaanakiro Isaac iroka Rebeca owankothaantiki irinironi, iinantakaro. Antaroiti yitakotakaro. Irootaki oimosirinka-pajiriri okamajira iriniro. ");
INSERT INTO prq_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Tima okaratzi 175 osarintsi yañaaki Abraham. ");
INSERT INTO prq_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Kamiitha ikamaji Abraham aakiri yantyasiparinka. ");
INSERT INTO prq_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Okanta ikamajira Abraham, itasonka-wintakiri Pawa Isaac. Inampitaaro Isaac ikaapiin-taitzi nijaa ipaitai-tziri “Añaani-tatsiri Ñaakinari.” ");
INSERT INTO prq_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Tima ti onkanti owaiyanti Rebeca, irootaki yamana-kotantaka-rori Isaac ikowako-tziri Pawa. Ikimakiniri yamanani Pawa, motyaataki Rebeca. ");
INSERT INTO prq_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Okanta okimakiri Rebeca yaatzika-wakaa iintsiti omotyaaki, okanta-siritzi: “Tima oshiki nokimaatsitakari iroñaaka, aririka onkantyaari apaata, ¿ipaitama nañaantyaari?” Jatanaki amaniri Pawa onintzi oyoti ipaita antiri. ");
INSERT INTO prq_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Ikantziro Pawa: Pimotyaatatziiri apiti shininka-tawakaacha-niri, Apiti oshiki-tatsi-niri maimani-tawakaacha-niri. Sintsi inkantyaa aparoni, iriima pasini airomachiini, Iriitaki ompiratan-tachaniri iyaapitsi, impiratyaari itarori itzimi. ");
INSERT INTO prq_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Okanta omonkarataka ontzimanintan-tyaari Rebeca, owaiyan-takiri otsipaa-niriiti. ");
INSERT INTO prq_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Itapaaka-rori itzimi kitisirinkari maaroni iwathaki, ithonka iwitzitaki. Irootaki ipaitan-takariri “Witzintzi”. Tima iroka wairontsi Witzintzi, irootaki ikantai-tziri iñaaniki pairani irirori “Esaú”. ");
INSERT INTO prq_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Ikanta itzimapaaki yoijatakirira pasini, airika iwakiri iitziki itapaaka-rori itzimi. Irootaki ipaitan-takariri “Airika-kiitzitantaniri”. Tima iroka wairontsi Airika-kiitzitantaniri, irootaki ikantai-tziri iñaaniki pairani irirori “Jacob”. Tima tzimaki 60 isarintsiti Isaac owaiyan-tanta-kari Rebeca. ");
INSERT INTO prq_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Ikanta apaata antarijiitaki iintsi-payi. Antawairintzi inanaki Esaú, kominthaantzi inaki aajatzi. Iriima Jacob apatziro onimowai-tziri irirori, yasi iwiro isaiki iwankothaantiki iriri. ");
INSERT INTO prq_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Oshiki yitakotakari Isaac yoka itomi, Esaú, tima oshiki iwakota-tapiinta-kari iyominthani. Irooma Rebeca otakopiro-tani owiri iroori Jacob. ");
INSERT INTO prq_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Okanta apaata, isaiki Jacob ikotsiwaitzi, ari yariitaari Esaú ipoñaajaro yantawairiki, makotaki. ");
INSERT INTO prq_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Ikantapaa-kiri: “¡Iyí! Pimpina kapichiini kityonka-pathari pikotsiri, aatyiina notashi.” (Irootaki owaitakaan-tziriri “Kitisiri” yoka Esaú) ");
INSERT INTO prq_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Ari ikantzi Jacob: “Pitawakyaaro awiroka pinkimi-takaan-tina naakami ityaaro-niri nontzimi.” ");
INSERT INTO prq_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Ari ikantzi Esaú: “¡Aatyiina notashiwí! Ti nomiraawintiro naaka nitawitakaro notzimaki.” ");
INSERT INTO prq_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Aikiro isintsi-tanakitzii Jacob, ikantziri: “Intsityaa pinkanta-pirotina iyí.” Ari inintanaki Esaú inkimi-takai-yaari Jacob iriitakimi ityaaro-niri intzimi, iriitaki ayiro-niri apaata maaroni tzimimo-tziriri iriri. ");
INSERT INTO prq_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Irootaki ipantaka-riri Jacob iwariti iririntzi, Esaú, ipitakari aajatzi yatantariri. Ikanta ithonkakiro iwaka Esaú, iranaki imiri. Katziyanaka, jatanaji. Ti imiraawin-tiro okaratzi ijiwawitakara itzimaki. ");
INSERT INTO prq_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Ari iñaakaari Pawa Isaac, ikantakiri: “¡Isaac! Airo pikinanaji Apitantoniki. Pinampi-tajyaaro tsika nookotimiro. ");
INSERT INTO prq_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Pisaiki aka pinkimi-tyaari kinakina-waitaniri. Tima aritaki ankarati asaiki, ari nontasonka-wintakimi. Aritaki nompakimiro maaroni iroka kipatsi, irootaki yasitajyaari apaata inkarati pincharini-tajyaari. Ari nomonkara-tajirori aka okaratzi nokasiyakaa-kiriri pairani piri Abraham. ");
INSERT INTO prq_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Aritaki noshikyaa-kimiri inkarati pincharini-tajyaari, inkimitajyaari ishikitzi impokiro inkitiki. Iriitaki nasitakaa-jyaari maaroni iroka kipatsi. Iriitaki kantakaa-jyaaroni picharini-payi intasonka-wintantai-tyaariri maaroni nasiyitacha-niri ishininka-tawakaiyaa kipatsiki. ");
INSERT INTO prq_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Tima imonkara-takiro pairani piri Abraham okaratzi nokantziriri. Ikimisan-takina nompiratariri, imatakiro nokantakaan-tani, nowinkakaan-tani, aajatzi okaratzi noyomitaayi-tziriri.” ");
INSERT INTO prq_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Aritaki antyasiparitaki Isaac, ti yokichaa-tapaji. Ikaimakiri yantariti itomi, ikantakiri: “¡Notomí!” Ikantzi Esaú: “¿Ipaita Apaá? Aka nosaiki.” ");
INSERT INTO prq_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Ikantzi Isaac: “¡Notomí! Aritaki antyasipari-takina, aamaasityaa irootaintsi nonkami. ");
INSERT INTO prq_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Nonintzi piyati pinkin-taitina posinirintzi. ");
INSERT INTO prq_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Pinkotsi-takinari, posini inkantyaa nonintziri, pamakinari nowawakyaata. Ari noyomitaa-najimi tikira nokamana-kiita, onkini intasonka-wintaitimi.” ");
INSERT INTO prq_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Kimaki iroori Rebeca ikantziriri itomi, Isaac. Ijaminthaitzi Esaú yaminaminatzi posinirintzi impiriri asitariri, ");
INSERT INTO prq_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","okantakiri Rebeca pasini otomi, okantziri: “¡Notomí! Nokimakiri piri ikinkitha-waitakairi pirintzi Esaú, ikantziri: ");
INSERT INTO prq_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","‘Pinkin-taitina posinirintzi pinkotsi-tinari, kamiitha imposiniti inkini noyaari, ari noyomitaa-najimi tikira nokamana-kiita onkini intasonka-wintimi Pawa.’ ");
INSERT INTO prq_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","¡Notomí! Pikimiisa-tina okaratzi nonkantimiri. ");
INSERT INTO prq_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Pijati pairikaiti apiti awankiri apira, pamakinari, nonkotsi-tiniri piri tsika ikanta iñaamatari irirori. ");
INSERT INTO prq_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Awiroka aanakini-rini iwawakyaa. Ari iyomitai-miri tikira ikamanakiita intasonka-wintaiti-miita awiroka.” ");
INSERT INTO prq_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Ikantana-kiro Jacob iriniro: “Tima witzintzi inatzii iyi, irooma naaka ti nowitziti. ");
INSERT INTO prq_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Aritaki iyotawakina apaa aririka impampi-tawakina, ari inkinkithasiri-takyaa nothainka-tziiri, ampinaa-sityaa iyomita-wityaana intasonka-wintaitina, añaatyii oshiki imishatina.” ");
INSERT INTO prq_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Okantana-kiri iriniro: “¡Notomí! Naaka imishati piri. Pantiro awiroka nokantaki-miri, pamakinari apiti apira.” ");
INSERT INTO prq_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Jatanaki Jacob ipiyotaka ipira-payi, yamakiniro iriniro. Onkotsi-tawakiri iroori tsika ikanta oyotziro iroori iñaamatari Isaac. ");
INSERT INTO prq_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Aakiro iroopirori iithaari antariti otomi iwiro pankotsiki, okithaa-takiri Jacob. ");
INSERT INTO prq_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Okyaan-takaa-kari imisina opira irakoki, aajatzi ikintsiki tsika ti iwitziti. ");
INSERT INTO prq_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Oyiitakiri onkotsi-takiri, opakiri otomi Jacob otsipataa-kiro yatantyaariri. ");
INSERT INTO prq_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Ari yaakotana-kiro Jacob isaikaki iriri, ikantapaa-kiri: “¡Apaá!” Ikantzi Isaac: “¿Tsika pipaitaka awiroka notomi?” ");
INSERT INTO prq_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Ikantzi Jacob: “Naakataki Esaú pantariti pitomi. Nomatakiro okaratzi pikantaki-nari. Pimpiriinti, piyaa noyintani, piyomitanaina intasonka-wintantai-tyaanari.” ");
INSERT INTO prq_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Ikantzi Isaac: “¿Okatzimaitaka pikin-tapaintzi posinirintzi?” Ikantzi Jacob: “Tima ikantakaa-karo Pawa pipinkatha-tapiintziri, irootaki noñaan-tapaintari sintsiini.” ");
INSERT INTO prq_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Ari ikantzi Isaac: “Pimpoki okaakiini nompampi-tawakimi, noyotan-tyaamiri awiroka-rika Esaú.” ");
INSERT INTO prq_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Pokapaaki okaakiini Jacob impampi-tawakiri. Ikantzi Isaac: “Iriiwaanti-waitaki iñaawaitzi Jacob, irooma irakosampiki Esaú inatzii.” ");
INSERT INTO prq_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Ti iyotawakiri, tima iwitzi-pakotatzii iriiwaitaki Esaú. Irootaki iyomitantanaka-riri onkini intasonka-wintaitiri. ");
INSERT INTO prq_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","Yapiitana-kiri isampitziri, ikantziri: “¿Omapirotatyaa awiroka Esaú?” Ari ikantzi Jacob: “Jii, naakataki.” ");
INSERT INTO prq_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Ikantanaki iriri: “¡Notomí! Piyii-tinari piyominthani nowawakyaata, ari noyomitanai-miri onkini intasonka-wintaitimi.” Iyii-takiro Jacob owaritintsi ipakiri iriri. Yamakiniri aajatzi irawakiri. Iwawakaro Isaac, iraki imiri aajatzi. ");
INSERT INTO prq_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Ikantzi Isaac: “Pimpoki okaakiini notomi, pintsitokyaana.” ");
INSERT INTO prq_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Ikanta itsitoka-paakari Jacob iriri, yasankawakiri iithaariki. Iyomitaa-kiri intasonka-wintaitan-tyaariri, ikantziri: Irootaki isankaani notomi. Okimiwai-takaro osankaani owaantsi itasonka-wintziri Pawa. ");
INSERT INTO prq_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Inkamintha Pawa owaryaa-piintaji-miro-niri inkani, Irootaki onkithoki-piro-tantajyaari pichochoki-tipayi. Aajatzi onkantajyaa piwanki-ripayi, aajatzi okaratzi pimiritari. ");
INSERT INTO prq_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Inkamintha intzimaji pimpira-waitani, Irootaki impinkatha-tantyaamiri poñaayi-tachari pasiniki nampitsi. Pijiwayi-tairi pirintzi-pirotari awiroka, Oshiki impinkathai-taimi irirori. Intzimi-rika mishataji-mini awiroka, aritaki imaitajiri irirori. Iriima inkarati kimosiriwinta-jiitii-mini awiroka, aritaki inkimii-tairi irirori. ");
INSERT INTO prq_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Ikaratakiro Isaac iyomitaa-kiri itomi Jacob onkini intasonka-wintaitiri. Iro isitowana-kitzii Jacob isaikira iriri, ariitapaaka Esaú ijatzi yamini posinirintzi. ");
INSERT INTO prq_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Ikotsitaki aajatzi irirori owaritintsi, yamakiniri iriri, ikantapaa-kiri: “¡Pimpiriinti, Apaá! Piyaa iyintani pitomi, piyomitairi intasonka-wintaitan-tyaariri.” ");
INSERT INTO prq_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Ari ikantanaki Isaac: “¿Tsikama pipaitaka awiroka?” Ikantzi: “Naakataki Esaú, pantariti pitomi.” ");
INSERT INTO prq_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Antaro oimiraana-kiri Isaac, ikantanaki: “¿Tsikama ipaitaka itakarori ipokaki amakinariri iyintani, nowakari tikira pariityaata awiroka? Noyomitaa-kiri, tasonka-wintaari inanaki irirori.” ");
INSERT INTO prq_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Ikanta ikimawakiro Esaú ikantakiri iriri, okatsi-tzimo-niintana-kiri, antaroiti iraawai-tanaka, ikantanaki: “¡Apaá! Piyomitanaina aajatzi naaka, intasonka-wintaiti-naata.” ");
INSERT INTO prq_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Ikantanaki Isaac: “Yamatawi-takina pirintzi, noyomitaa-kiri irirori, tima awiroka-witaka intasonka-wintaitimi.” ");
INSERT INTO prq_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Yakanaki Esaú, ikantzi: “Irootaki owaitakaan-tziriri Airika-kiitzitantaniri, tima apiti yaapithatakina. Itakaro yayitaki-naro nitantaka-rori notzimi, iroñaaka yayitaki-naro piyomitanai-narimi intasonka-wintaitan-tyaanari. ¿Airoma okantzi piyomitaina naaka?” ");
INSERT INTO prq_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Ikantzi Isaac: “Aritaki nomatakiri pirintzi Jacob ijiwataimi, iriitaki ompiratajyaa-ri-niri pincharini-tajyaari awiroka, noshikyaa-jiniri iwankiri, aajatzi imiri-payi. ¿Tikatsi nonkantajimi awiroka notomi?” ");
INSERT INTO prq_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Aikiro ikantana-kitzii Esaú: “¡Apaá! ¿Aparonima okaratzi piyomitaanti? Papiitiro, intasonka-wintaiti-naata naaka.” Yapiitana-kiro iiraawaita. ");
INSERT INTO prq_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Ikantzi Isaac: Pinampi-tajyaaro intaina, Airo pinampi-taaro otsinka-patha-tapajira kipatsi, aajatzi airo pinampi-taaro tsika ti omparyaapaji inkani. ");
INSERT INTO prq_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Piwisa-minto pimpiya-wintantajyaari. Impira-waitajyaami pirintzi. Irooma aririka piriipirotaji awiroka apaata, Aritaki pisaikasiwai-tajyaa. ");
INSERT INTO prq_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Ari yitanakaro Esaú ikisaniin-tziri iririntzi, okantakaan-tziro ikaminaa-kiri iriri intasonka-wintaitiri irirori. Ikanta-siri-tanaki: “Aririka inkamaki apaata apaa, aritaki nowajiri iyi.” ");
INSERT INTO prq_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Oyomaitaka Rebeca ipaita ikinkithasiritari Esaú, okaimakaan-takiri Jacob, okantakiri: “Ikowatziira pirintzi inkisawin-tajyaa, iwatyiimi. ");
INSERT INTO prq_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Pinkimisantina notomi nonkantimiri. Pijati intaina Awotziniki, ari isaiki anta pikonkiri Labán. ");
INSERT INTO prq_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Osamani pisaika-waiti anta awisawajiitaa imasirinka pirintzi. ");
INSERT INTO prq_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Impyaako-tawajiroota okaratzi pantakiri. Tima aritaki nonkaman-tajimi pimpiyan-tajyaari. Ti noninti impyaasityaa apiti notomi.” ");
INSERT INTO prq_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Okantakiri Rebeca oimi: “Oshiki nosamasiryaa-karo Tharowan-taari-nisato asitarori onampi aka iina Esaú. Irojatzi-rika Tharowan-taari-nisato iinantyaari aajatzi Jacob, aritaki nonkama-pitha-takiro.” ");
INSERT INTO prq_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Ikanta Isaac ikaimaikiri Jacob, iyomitaakiri intasonka-wintai-tantyaariri, ikantziri: “Airo piinantaro Owintini-sato. ");
INSERT INTO prq_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Pijati Owintinitzi Tonkaarini, inampiitiki picharinini Betuel, payi anta irisinto pikonkiri Labán. ");
INSERT INTO prq_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Iriitaki tasonka-winti-miniri Sintsi-pirori Pawa, ishikyaaji-miri piwaiyani-payi, iriitaki inasiyi-tajyaaro-niri ishininka-tawakaiyaa tsika-rikapayi. ");
INSERT INTO prq_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Irijatzi tasonka-wintaji-miniri awiroka, aajatzi inkarati pincharini-tajyaari, tima irootaki ikasiyakaa-kiriri pairani picharinini Abraham, pasitajyaaro maaroni kipatsi tsika asaikaki iroñaaka.” ");
INSERT INTO prq_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Ityaantakiri Isaac itomi, yoka Jacob, iwankoki irikonkiri Labán isaiki anta Owintinitzi Tonkaarini. Yoka Labán, iriitaki irikonkiri Jacob oyaariri Rebeca, iriitaki itomi Betuel Tonkaarini-satzi. Tima iroka Rebeca, irootaki iriniro Jacob aajatzi Esaú. ");
INSERT INTO prq_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Iñaakowintakiri Esaú iyomitai-tziri Jacob intasonka-wintaitan-tyaariri, ityaantai-takiri Owintinitzi Tonkaarini yayi iina. Iñaakowintaakiri aajatzi Esaú iririntzi iyomitairi iriri airo yaantaro Owintini-sato. ");
INSERT INTO prq_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Iñaakiri aajatzi Esaú ijatanaki iririntzi, Jacob, ikinanakiro Owintinitzi Tonkaarini, imatakiro okaratzi ikantaki-riri iriri. ");
INSERT INTO prq_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Antaroiti ikinkithasiri-waitanaka Esaú, tima ti onimotiri iriri iinantakaro apiti Owintini-sato. ");
INSERT INTO prq_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Jataki Esaú isaiki Ismael, iriitaki itomi Abraham, icharinini. Yaakiro Esaú irisinto Ismael paitachari Mahalat irinto Nebaiot, okantawitaka otzimi apiti iina, Owintini-sato. ");
INSERT INTO prq_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Tima aritaki jatanaki Jacob, ipoñaakaro Kanta-piro-jaariki ijatiro Awotziniki. ");
INSERT INTO prq_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Ikanta iwiraaka niyaanki-thaki awotsi, ari imaapaaki tima tsitini-tanaki. Inosikaki mapi, itziinatakaro, maanaki. ");
INSERT INTO prq_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Ari imisiwai-takiri, iñaaki atiimintotsi okinapaa-kiro inkitiki ayiitapaaki kipatsiki. Tzimatsi maninkari-payi ayiijii-tatsiri, pasini atiijii-tatsiri. ");
INSERT INTO prq_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Iñiitakari aajatzi Pawa ikatziyaka okaakiini, ikantziri: “Naakataki Pawa, Iwawani picharini Abraham, aajatzi piri Isaac. Aritaki nasitakaa-jyaamiro iroka kipatsi, ari nonkimitaa-kiriri aajatzi pincharini-tajyaari yasijii-tyaaro iroka kipatsi tsika pinaryaaka. ");
INSERT INTO prq_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Inkimitajyaaro pincharini-tajyaari oshikitzi kipatsi-pani. Inthonkyaa inampitajyaaro katonko aajatzi kiriinka, isitowa-piintzi ooryaatsiri aajatzi ikyaapiintzi. Tima awiroka aajatzi inkarati pincharinin-tajyaari, awirokaiti kantakai-yaaro-niri nontasonka-wintantajyaa-riri maaroni nasiyitachari ishininka-tawakaa-jiita aka kipatsiki. ");
INSERT INTO prq_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Naakataki tsipa-tapiintaka-miri, aritaki nonkimpoyaa-wintakimi tsika-rika pinkinayiti. Aritaki nomatakiro noipyaajimi aka pisaikaki. Ontzimatyii nomonkaratiro okaratzi nokantaki-miri, airo nookimi.” ");
INSERT INTO prq_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Ari isaakitanaki Jacob imisiwaitzi, ikanta-siritzi: “Omaapiroma isaiki Pawa aka, ti noyowityaa.” ");
INSERT INTO prq_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Antaroiti oimiraana-kiri, ikanta-siritzi: “Tasorintsi-patha onatzii aka. Irootaki iwanko Pawa. Iroowaitaki okyaapiintzi awotsi ajatantyaari inkitiki.” ");
INSERT INTO prq_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Ikanta ipiriin-tamanaka Jacob okitaityaaki, yaakiro mapi itziito-takari, ikatziya-thantha-tanakiro. Isaitan-tanakaro yiinkantsi, irootaki owaitakaan-tzirori tasorintsi-patha. ");
INSERT INTO prq_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Tzimawi-tacha anta nampitsi ipaitawi-taitaro Tirimpyaarini, iwanajiniro pasini owairo, ipaitana-jiro Pawapankoni. ");
INSERT INTO prq_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Ari iñaawai-tanaki Jacob, ontziman-tyaari inkasiya-kaiyaariri Pawa, ikantanaki: “Aririka intsipa-tapiintyaana Pawa, aririka inkimpoyaa-wintina tsika-rika nonkinayiti, aririka impina noyaari aajatzi nonkithaa-yityaari, ");
INSERT INTO prq_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","tikatsi-rika awishi-motina-ni, nompiyaji-rika kamiitha iwankoki asitanari, aritaki niriipiro-wintajiri nowawani-tajyaari Pawa. ");
INSERT INTO prq_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Iroka mapi nokatziya-thantha-takiri, iwanko Pawa onatyii.” Ari yamananaki, ikantzi: “¡Pawá! Onkarati pasitakai-yaanari naaka, aritaki noipyaajimi kapichiini.” ");
INSERT INTO prq_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Aikiro ijatatzii Jacob yaniitzi, ariitaka iipatsitiki nampithajiitaroni isitowa-piintzi ooryaatsiri. ");
INSERT INTO prq_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Ikanta yariitapaaka owaantsiki osaiki nijaa ikaapiin-taitziri, iñaapaaki oshiki piratzi irajiitzini nijaa, mawa inasitaka ipiyojiitaka. Antaroiti onatzi mapi itatakoi-tantarori nijaa. ");
INSERT INTO prq_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Ari ipiyojiitakani aamaakowin-tariri ipira-payi, yaapitha-tawakaaro yasitakotantarori nijaa. Aririka inthonka-kiro irakairi ipira-payi, aajatzi yasitako-tanajiro nijaa. ");
INSERT INTO prq_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Isampitapaa-kiri Jacob aamaakowin-tariri ipira, ikantziri: “¿Tsikama pipoñaaka awiroka ashininká?” Ikantajiitzi irirori: “Awotzini-satzi nonajiitzi.” ");
INSERT INTO prq_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Yapiitana-kiri isampitziri: “¿Piñiirima awiroka Labán itomi Nacor?” Ikantajiitzini irirori: “Jii, noñiiri.” ");
INSERT INTO prq_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Aikiro ikantana-kitzii Jacob: “¿Saikatsima Labán, ti imantsiya-waiti?” Ikantajiitzini aamaakowin-tariri ipira: “Tikatsi ikanta Labán. Pamini antó, irootaki irisinto pokaintsiri amakiri opira, opaita Raquel.” ");
INSERT INTO prq_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Ari ikantanaki Jacob: “Ainiro okitaititzi tikira ontsitini-tiita. ¿Ipaitaka pasitako-tantyaariri pipira-payi? ¿Ipaitama kaari pirakaan-tanaari nijaa pipira-payi, impoña piwakaa-panaatyaari aajatzi?” ");
INSERT INTO prq_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Ikantajiitzi iriroriiti: “Airo nomatziro, ontzimatyii noyiiri pasini aamaakowin-tariri ipira naawyaan-tyaarori nosirinkiro asitakoro nijaa. Nompamai-tyaari nijaa nopira-payi.” ");
INSERT INTO prq_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Ikinkitha-waiminthaitzi Jacob, ariitakaa-paakari Raquel ipira iri, irootaki aamaakowin-taniriri. ");
INSERT INTO prq_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Ikanta iñaawakiro Jacob iinathori, Raquel, ariitakaa-paakari ipirapayi iri, jatanaki isirinkiro otatakoro nijaa ikaapiin-taitziri, ipakiri nijaa opira-payi. ");
INSERT INTO prq_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Iwithatawa-karo iinathori, Raquel, ithoporo-tawakiro, irai-motawakaaro. ");
INSERT INTO prq_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Ikamantakiro Jacob iinathori, ikantziro: “Naakataki otomi Rebeca, naaka itziniri piri.” Osiyasi-tanakari Raquel iri, okamantapaa-kiri. ");
INSERT INTO prq_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Ikanta ikimaki Labán otomi iritsiro, isiyasi-tanakari irirori, yawithano-tawakiri, inintatha-tawakiri, yaanakiri iwankoki. Ari ikinkitha-waitakaa-kiri Jacob irikonkiri, ikamantakiri okaratzi awishi-motakiriri. ");
INSERT INTO prq_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Ikantanaki Labán: “Awirokataki noshininka okaakiini.” Aparoni kasiri isaikawai-tapaaki Jacob iwankoki irikonkiri. ");
INSERT INTO prq_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Ipoñaa ikantakiri Labán: “Ti onimotina airorika nopinatzimi pantawairi, noshininka-thori pinatzi. Pinkantina onkarati pikowiri nompinatimiri.” ");
INSERT INTO prq_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Tzimatsi apiti irisinto Labán: yantaroti opaita Lea, pasini awankaro opaita Raquel. ");
INSERT INTO prq_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Tima ti onkamiithakiti iroori Lea, irooma Raquel kamiithaanto onatzi iroori. ");
INSERT INTO prq_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Irootaki ikowasiryaaki Jacob iroka Raquel, ikantanaki: “Kantatsi nantawaiti 7 osarintsi, nantawaiwintiro awankaro pisinto.” ");
INSERT INTO prq_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Ikantzi Labán: “Irootaki kamiitha-tatsi nompimiro awiroka, ti noninti nompiri pasini-satzi. Pisaikimo-waitina nowankoki.” ");
INSERT INTO prq_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Imatakiro Jacob yantawaiwin-takiro Raquel okaratzi 7 osarintsi, ti iñaamai-tyaaro osamani-tzimotiri yantawaiwin-takiro, tima ininta-piro-tatziiro Raquel. ");
INSERT INTO prq_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Okanta omonkarataka 7 osarintsi, ikantakiri Jacob irikonkiri: “Pimpinaro pisinto noinantyaaro, nomonkara-takiro nokantakiri pairani onkarati nantawaiwintiro.” ");
INSERT INTO prq_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Ikaimakaan-takiri Labán ikaratzi nampitarori anta, ipokajiitaki maaroni yoimosirinkiri aawakaiyaa irisinto. ");
INSERT INTO prq_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Iro kantacha Labán ipasitakari irisinto Lea kaari inintawita Jacob, irootaki imaantakari tsitiniriki. ");
INSERT INTO prq_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Ari ityaantaki-niro Labán impira-tani paitachari Zilpa, ontsipa-tyaari irisinto Lea, irootaki ompirawai-tyaari. ");
INSERT INTO prq_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Okanta okitaiti-tamanaki iñaatziiro Jacob imaan-tasi-takaro Lea. Ijatasi-tanakiri irikonkiri, ikantakiri: “¿Ipaitama pamatawi-tantanari? Kaari Lea nantawaiwinti, iro nantawaiwintaki Raquel.” ");
INSERT INTO prq_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Yakanaki Labán, ikantzi: “Ti yamitaitaro aka iimin-takai-tyaaro awankaro sintotsi tikira oimintyaata itakarori otzimaki. ");
INSERT INTO prq_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Ontzimatyii pimonkaratiro kitaitiri-payi poimosirinkiro paakiro Lea, aritaki nompakimiro Raquel. Iro kantacha ontzimatyii panta-waiwinta-wairo aajatzi onkarati 7 osarintsi.” ");
INSERT INTO prq_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Imatakiro Jacob. Ikanta imonkara-takiro yaakiro Lea, ipaitakiri aajatzi Raquel. ");
INSERT INTO prq_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Ari ityaantaki-niro Labán irisinto Raquel impira-tani opaita Bilha, irootaki ompirawai-tyaari. ");
INSERT INTO prq_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Imatakiro Jacob yaakiro Raquel. Irootaki yitako-pirotari, anaanakiro yitakotaro Lea. Aajatzi yantawai-tawainiri irikonkiri okaratzi 7 osarintsi. ");
INSERT INTO prq_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Ikanta iñaakiri Pawa imaninta-waitziro Jacob itarori iina Lea, itarori yaakiro, iwaiyan-takaa-kiro otomi-payi. Irooma Raquel ti owaiyanti iroori. ");
INSERT INTO prq_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Okanta omotyaataki Lea, tzimaki otomi, okanta-siritzi Lea: “Iñaakina Pawa nowasiri-waita, aritaki inintajina noimi.” Irootaki owaitakaan-tziriri otomi “Ñiitaantsi”. Tima iroka wairontsi Ñiitaantsi, irootaki ikantziri iñaaniki iriroriiti “Rubén”. ");
INSERT INTO prq_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Ikanta apiitajiro omotyaataji Lea, tzimaki otomi, okanta-siritzi Lea: “Ikimakina Pawa imanintaitana, irootaki itziman-takari pasini notomi.” Irootaki owaitakaan-tziriri otomi “Kimaantsi”. Tima iroka wairontsi Kimaantsi, irootaki ikantziri iñaaniki iriroriiti “Simeón”. ");
INSERT INTO prq_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Aajatzi apiitajiro omotyaatzi, tzimaki pasini otomi, okanta-siritzi Lea: “Intsipa-tajyaana noimi, tima nowaiyan-takiniri mawa itomi.” Irootaki owaitakaan-tziriri otomi “Tsipataantsi”. Tima iroka wairontsi Tsipataantsi, irootaki ikantziri iñaaniki iriroriiti “Leví”. ");
INSERT INTO prq_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Aajatzi itzimawaji pasini otomi, okanta-siritzi Lea: “Nompanthaa-wintajiri Pawa.” Irootaki owaitakaan-tziriri otomi “Panthaantsi.” Tima iroka wairontsi Panthaantsi, irootaki ikantziri iñaaniki iriroriiti “Judá”. Tima ari okaratapaaki owaiyan-taki iroori Lea. ");
INSERT INTO prq_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Okisaniin-tanakiro Raquel irinto Lea oñaakiro ti owaiyanti iroori, okantakiri oimi: “Nonintzi piwakaina naaka, airorika piwakaa-sitana ari nonkama-pitha-takimi.” ");
INSERT INTO prq_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Ari ikisanakiro Jacob iina, Raquel, ikantana-kiro: “¿Naakama Pawa pikantan-tanari? Iriitaki Pawa kantakaaro kaari itzimanta piintsiti.” ");
INSERT INTO prq_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Okantzi Raquel: “Payiro nompira-tani Bilha, piwakairo. Aririka intzimaki iintsiti, nonkimi-takaan-tiri naakami asityaarini.” ");
INSERT INTO prq_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Opakiri otzika-tani Bilha iinantyaaro. Imatakiro Jacob iwakaakiro Bilha. ");
INSERT INTO prq_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Tzimanaki itomi Jacob iwakaaki-rori ompira-tani iina. ");
INSERT INTO prq_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Okantzi Raquel: “Ikimakina Pawa nokowako-takiri, owakowin-taaro nonaki, ipakina aparoni notomi.” Irootaki owaitakaan-tziriri otomi “Owakowin-taari”. Tima iroka wairontsi Owakowin-taari, irootaki ikantziri iñaaniki iriroriiti “Dan”. ");
INSERT INTO prq_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Ari apiitakiro Bilha owaiyan-tziri pasini itomi Jacob. ");
INSERT INTO prq_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Okantanaji Raquel: “Iñaakina Pawa osiyawai-takaro nomaina-nitakiromi nirinto, noitsinampaa-kiro.” Irootaki owaitakaan-tziriri otomi “Maimani-taantsi”. Tima iroka wairontsi Maimani-taantsi, irootaki ikantziri iñaaniki iriroriiti “Neftalí”. ");
INSERT INTO prq_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Okanta oñaaka Lea ti itzimanaji iintsiti iroori, okantakiri oimi: “Payiro nompira-tani Zilpa.” Opakiri, yaakiro Jacob ompira-tani iina Lea. ");
INSERT INTO prq_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Owaiyan-takiri Zilpa otomi iwakaaki-rori Jacob. ");
INSERT INTO prq_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Okantanaki Lea: “Ikaminthaa-matsitaka.” Irootaki owaitakaan-tziriri otomi “Kaminthaan-tsi”. Tima iroka wairontsi Kaminthaan-tsi, irootaki ikantziri iñaaniki iriroriiti “Gad”. ");
INSERT INTO prq_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Ari apiitakiro Zilpa owaiyantaki pasini itomi Jacob. ");
INSERT INTO prq_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Ari okantanaji Lea: “Kimosiri nokanta naaka. Ompaitajina kooya-payi kimosiriri.” Irootaki owaitakaan-tziriri otomi “Kimosiri-taantsi”. Tima iroka wairontsi Kimosiri-taantsi, irootaki ikantziri iñaaniki iriroriiti “Aser”. ");
INSERT INTO prq_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Ikanta iyataki Rubén yawiitiro iwankiri. Ari iñaaki iwinki-niro, yamakiniro iriniro, Lea. Okanta oñaawakiro Raquel iwinki-niro, okantakiro irinto: “¡Iintyó! Pimpina kapichiini yamakiri notominthori.” ");
INSERT INTO prq_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Ari akanaki Lea, okantzi: “¡Iintyó! ¿Tima okantzimonintyami paapitha-takinari noimi? Aikiro pinintatzii payitinaro yamakinari notomi.” Okantzi Raquel: “Aririka pimpakina yamakimiri notominthori, ari nosinitakiri aimi imaantyaami tsitiniriki.” ");
INSERT INTO prq_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Aritaki tsitiniityaaki, ariitapaja oimi, Jacob, ipoñaajaro iwaniki, osiyasi-tawajari Lea, okantawa-jiri: “Ontzimatyii pimaantyaana tsitiniriki ompinatyaari iwinki-niro yamakinari atomi.” Imatakiro Jacob imaantakaro Lea. ");
INSERT INTO prq_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Ari owaiyan-takiri Lea 5-tatsiri otomi, iwaiyan-takaa-kirori Jacob, tima ikimakiro Pawa okowako-takiri. ");
INSERT INTO prq_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Okantanaki Lea: “Iriitaki ipinataki-nari Pawa, napathatari noimi notsipa-takaro nompira-tani.” Irootaki owaitakaan-tziriri iintsiti “Pinataantsi”. Tima iroka wairontsi Pinataantsi, irootaki ikantziri iñaaniki iriroriiti “Isacar”. ");
INSERT INTO prq_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Omotyaataki Lea pasini otomi, iriitaki 6-tatsiri. ");
INSERT INTO prq_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Okantanaji Lea: “Ikamintha ipakinari Pawa kamiithaantzi notomi. Imaantajyaana iroñaaka noimi, tima nowaiyan-takiniri 6 itomi.” Irootaki owaitakaan-tziriri iintsiti “Apititaantsi”. Tima iroka wairontsi Apititaantsi, irootaki ikantziri iñaaniki iriroriiti “Zabulón”. ");
INSERT INTO prq_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Ari owiraan-tawaaro Lea owaiyantzi, tzimaki osinto, opaitakiro Dina. ");
INSERT INTO prq_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Tima kinkithasiri iwiro Pawa Raquel, imatakiniro okaratzi okowako-tziriri, motyaataji iroori. ");
INSERT INTO prq_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Ari itzimakiri itanakarori otomi, okantanaki: “Ipyaakinaro Pawa nopasiki-waitzi ti nowaiyantzi. ");
INSERT INTO prq_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Inkamintha yapiitinaro, inkan-takai-yaaro nowaiyanti pasini.” Irootaki owaitakaan-tziriri yoka iintsiti “Apiitaantsi”. Tima iroka wairontsi Apiitaantsi, irootaki ikantziri iñaaniki iriroriiti “José”. ");
INSERT INTO prq_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Ikanta itzimaki José, ikantakiri Jacob irikonkiri: “¡Kokí! Iro nojataji nonampiki. ");
INSERT INTO prq_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Pisinitinari naanajiri maaroni notomi aajatzi noina-payi, tima irootaki nantawai-wintakiri. Piyotana tsika nokanta namitako-tapiintakimi.” ");
INSERT INTO prq_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Ari yakanaki Labán, ikantzi: “Noñaakiro itasonka-wintakina Pawa. Airo pijatzi, pisaiki-motina, thami anampityaarori aka. ");
INSERT INTO prq_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Pinkantina pininti-rika nompinatimi pantawai-tani, aritaki nompina-takimi.” ");
INSERT INTO prq_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Ikantzi Jacob: “Piyotzi awiroka tsika nokanta naamaakowin-tamiri pipira-payi. ");
INSERT INTO prq_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Ti ishiki-tzimotimi pairani. Irooma nariitaka naaka, aripaiti ishikitanaki pipira, tima itasonka-wintakimi Pawa. ¿Tsika-paitima ontzimi-motina naaka nowakai-yaariri picharini-payi?” ");
INSERT INTO prq_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Aikiro isintsi-tatzii Labán ikantziri: “¿Tsika ikaratzika pinintziri nompina-timiri?” Ikantzi Jacob: “Ti noninti pimpinatina. Aritaki napiitakiro naamaakowin-tyaamiri pipira. Iro kantacha, thami ankinkitha-waiti aririka onimotakimi nonkantimiri. ");
INSERT INTO prq_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Nonintzi nojati ipiyotaka pipira, noyosiitiri yanini pipira ikaratzi kisaa-tatsiri. Noyosiitiri aajatzi pipira-payi kaninayi-tatsiri, iriitaki nasityaari naaka pimpina-tinari naamaakowin-tyaamiri pipira-payi. ");
INSERT INTO prq_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Inkarati kisaari-payi tzimanaa-tsiniri, kaninayi-tatsi-ni aajatzi, iriitaki nasityaari naaka. Ari aminiro inkarati pimpina-tinari, tima airo nayitzimiri pasitari awiroka. Ari piñiiri nopira-payi iyosiityaa kisaari, aajatzi nasiwai-tachari iyaninanka. Iriima kitamaarori, aajatzi kaari kanina-tatsi-niri, iriitaki pasi awiroka. Pinasityaari, tima kaari nasi.” ");
INSERT INTO prq_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Ikantanaki Labán: “Ariwí, kamiithataki pikantanari.” ");
INSERT INTO prq_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Iro kantacha Labán, inintaki yamatawitiri. Tikira impiriita itziniri ipira-payi, yitzitakari irirori inasitakari ikaratzi kanina-tatsiri aajatzi kisaa-tatsiri. Ipakiri itomi-payi impiratyaari. ");
INSERT INTO prq_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Yaanakiri itomi-payi ipira intaina, okaratzi mawa kitaitiri yaniitaki. Irojatzi isaikanaki Jacob yaamaakowin-taniri ipira-payi irikonkiri. Titzimaita iyoti tzimatsi pasini imanakiri irikonkiri. ");
INSERT INTO prq_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Yaaki Jacob airitonki inchasi-thaki, imisiryaa-kiro iñaitan-tyaarori onkitamaarosithakiti. ");
INSERT INTO prq_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Iwakiniri iramintoki ipira-payi, ari iwanki-tawakaari ipokira irajiitzi nijaa. ");
INSERT INTO prq_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Ikanta iwaiyan-tanaki ipira-payi, inasiyi-tanaka iyaninanka. ");
INSERT INTO prq_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Inasitakari ipiyotakiri Jacob nasiwai-tachari iyaninanka, aajatzi ikaratzi kisaayi-tatsiri. Inasitakari irasi ikonkiri, aajatzi ikimitakiri irasi irirori. ");
INSERT INTO prq_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Ari ikantatziiro Jacob iwiniri inchasi-thaki ikaratzi wathayi-tatsiri ipira ipokajiitzi irí imiri. Irootaki yantantarori Jacob onkini iñaayitiro ipira-payi inchasi-thaki iwanki-tawakai-yaarika. ");
INSERT INTO prq_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Irooma ipokawi-jiita mathari-payi ipira, ti iwiniri inchasi-thaki. Irootaki yasitan-tariri Labán mathari-payi, iriima wathari-payi irasi Jacob. ");
INSERT INTO prq_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Ari okanta ishikyaan-takariri Jacob ipira-payi, ikyaakoi-tari-payi, oshiki aajatzi impira-tani: tzimatsi sirampari-payi aajatzi kooya-payi. Antariiti ashaaran-taniri ikantanaka. ");
INSERT INTO prq_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Ikimaki Jacob iñaawaitzi iraniri-payi, ikantajiitzi: “Yayitakairi aniri maaroni ipira asitairi, ashaarantaka irirori.” ");
INSERT INTO prq_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Iñaakiri Jacob ikisa-siryaawaita ikonkiri, ti yaakamiitha-tajiri ikimiwitari pairani. ");
INSERT INTO prq_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Ari iñaanatajiri Pawa Jacob, ikantairi: “Pimpiyaji inampiitiki picharinini tsika isaiki pishininka-payi. Ari ankarati anta, airo nowapintaimi.” ");
INSERT INTO prq_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Owitsika-naka Jacob, yaanakiri ipirapayi ikyaakotakaanaari itomipayi aajatzi iinapayi. ");
INSERT INTO prq_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","Jataji Jacob Owintiniki isaikawita pairani iriri. Ari ikaratzi yamajiri maaroni ipira ipinaitaki-riri yantawaitaki anta Owintinitzi Tonkaarini. ");
INSERT INTO prq_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Okanta tsitiniriki tsika imaapaaki Jacob, piriintanaka, yaanakiro apiti iina, apiti impira-tani, aajatzi 11 itomi, yoimontyaa-kiro intatzikironta Sakochaaroni tsika imontyaapiin-taita. ");
INSERT INTO prq_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Tima ithonka yoimontyaa-kiro aajatzi okaratzi tzimimo-tziriri. ");
INSERT INTO prq_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Ari isaikanaki apaniroini Jacob, ari iñaasintsitakari aparoni atziri, irootaintsi inkitai-takotakairimi. ");
INSERT INTO prq_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Ikanta iñaakiro atziri ti yiitsinampaitiri Jacob, iposaikiri iporichokiki iñaasintsitakarira, ichokiryaa-kiri. ");
INSERT INTO prq_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Ari ikantzi atziri: “Papakaina, irootaintsi onkitaititi.” Ikantzi Jacob: “Airorika pitasonka-wintana, airo napakaimi.” ");
INSERT INTO prq_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Isampitana-kiri atziri, ikantziri: “¿Tsikama pipaitaka awiroka?” Ikantzi irirori: “Nopaita Jacob.” ");
INSERT INTO prq_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Ikantzi atziri: “Airo pipaitaja iroñaaka Jacob, pimpaitajyaa ‘Ñaasintsi-tasorintsiri’. Tima piñaasintsitakari Pawa, pikimitaa-piin-takiri atziri-payi, piitsinampaa-kiri.” Tima iroka wairontsi Ñaasintsi-tasorintsiri, irootaki ikantziri iñaaniki iriroriiti pairani “Israel”. ");
INSERT INTO prq_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Ari isampitana-kiri Jacob, ikantziri: “¿tsikama pipaitaka awiroka?” Ikantzi atziri: “¿Ipaitama pinintantarori piyotiro nowairo?” Ari itasonka-wintanakiri Jacob. ");
INSERT INTO prq_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Irootaki ipaitan-tanakarori Jacob anta “Pawaporoni,” tima ikantana-kitzii: “Noñaa-poro-takiri Pawa, titzimaita nokami.” ");
INSERT INTO prq_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Ikanta isitowapa-jira ooryaatsiri, awisanaki Jacob Pawaporoniki. Okantakaaro ichokiryaa-pori-takirira, ijashita-sitaka yaniitzi. ");
INSERT INTO prq_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Irootaki kaari iwantari icharini-payi Israel iporichoki posiniri, tima ari ichokiryai-takiri pairani Jacob. ");
INSERT INTO prq_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Ikanta ipiyajaro Jacob ipoñaajaro Okamiitha-pathatiki Tonkaarini, tikatsi awishimo-tirini, kamiitha yariitaka nampitsiki Sikochaarini saikatsiri Owintiniki. Ari iwanko-thaanti-yitapaari imontita-pajaro nampitsi Sikochaarini. ");
INSERT INTO prq_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Irootaki yamanan-takiniriri iipatsiti Siko-kintsi icharini-payi Hamor, owaitakaan-tziriri iñaaniki iriroriiti Siquem. Okaratzi ipinatakiro 100 ikithoki kiriiki, ari iwanko-thaanti-yitapaja. ");
INSERT INTO prq_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Ari iwitsika-pajiri pomipirini-mintotsi, ipaitakiro “Pawa iriitaki Iwawani Israel.” ");
INSERT INTO prq_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Ikanta ipiyaja Jacob ipoñaajaro Owintinitzi-pathati Tonkaarini, yapiitajiro Pawa iñaakaari, itasonka-wintairi. ");
INSERT INTO prq_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Ikantziri: “Piwairo onatzii Jacob, Airomaita pipaitaja tsika pipaitawita, Israel pimpaitajyaa.” Iwajiniri Pawa pasini iwairo Jacob. ");
INSERT INTO prq_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Ari ikantanajiri: “Naaka Pawa Sintsi-pirori. Ari noshikyaa-jiri pitomi aajatzi inkarati pincharini-tajyaari. Noshikyaa-jiri pincharinitajyaari inkarati shininka-tawakaacha-ni, aajatzi inkarati nasiyi-tajyaaro-ni ishininka-tawakaiyaa tsika-rikapayi. Nompinkatha-ritakaa-yitajiri inkarati pincharini-yitajyaari. ");
INSERT INTO prq_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Aritaki nasitakaa-jyaamiro kipatsi nopakiriri pairani picharinini Abraham aajatzi Isaac. Irojatzi nasitakaa-jyaariri inkarati pincharini-tajyaari.” ");
INSERT INTO prq_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Irojatzi ipiyantanajari Pawa tsika ikinkitha-waitakaa-kiri Jacob. ");
INSERT INTO prq_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Ari yaanaki irirori Jacob aparoni mapi, ikatziya-thantha-takiro tsika ikinkitha-waitakaa-kiri Pawa. Isaitan-tanakaro yiinkantsi, aajatzi imiritaitari ontasorintsi-tantyaari. ");
INSERT INTO prq_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Ipaitana-kiro Pawapankoni tsika ikinkitha-waitakaa-kiri Pawa. ");
INSERT INTO prq_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Ikanta yawisana-kiro Jacob Pawapankoni. Ariitzimataka Posini-pathaniki, ari okatsi-tako-tapaaki Raquel onintzi ontzimaa-niti. Oshiki okimaatsitaka owaiyantiri iintsiti. ");
INSERT INTO prq_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Okanta oñaakiro aminirori oshiki ikatsi-tzimo-takiro iintsiti, okantana-kiro: “Airo pitharowan-tari, tzimapaaki pitomi.” ");
INSERT INTO prq_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Aritaki kamimatanaki Raquel, opaitana-jiri otomi “Benoni”. Iriima asitariri ipaitakiri irirori “Benjamín.” ");
INSERT INTO prq_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Ari okanta okamantakari Raquel, ikitaitakiro awotsiki jatachari Posini-pathaniki, ipaitai-tziri aajatzi Tantapankoni. ");
INSERT INTO prq_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Ipiriintaki Jacob antaro mapi tsika ikitaitakiro. Irootaki iroka mapi iyoitantari ari okitataari Raquel. ");
INSERT INTO prq_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Aritaki saikapaji Jacob Owintiniki tsika inampitaro pairani iririni. ");
INSERT INTO prq_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Niroka ikinkitha-takoi-tziri itomi-payi Jacob. Aritaki mainaritaki José tzimanaki 17 isarintsiti. Iriitaki aminapiin-tziriri ipira-payi itsipatari iririntzi-payi, otomi Bilha aajatzi asi Zilpa, iinapayi iriri. Iriitaki José kaman-tapiintziriri iriri yantayi-tziro kaaripirori iririntzi-payi. ");
INSERT INTO prq_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Iriitaki José ininta-piro-tziri Israel, okantakaan-tziro itzimaki yantyasiparin-kakiini. Intyai-takiniri José aparoni waniinka-tachari iithaari. ");
INSERT INTO prq_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Ikanta iyojiitaki iririntzi iriitaki José ininta-piro-tziri iriri, ikisaniin-tanakiri ti iñaanatana-jiri. ");
INSERT INTO prq_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Okanta apaata, imisiwaitaki José, ikamantakiri iririntzi-payi. Irootaki ikisaniinta-piro-tantanaka-riri. ");
INSERT INTO prq_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Ikantaki José: “Pinkimi nonkaman-timiro nomisitakiri. ");
INSERT INTO prq_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Noñaakiro asaikajiitzi owaantsiki, oososinakitziro awankiri-payi. Omapoka-sitanaka opiriin-tanaka noosotakiri naaka, tampatzika okatziya-naka. Irooma pasipayi awiroka oshonkapaa-kiro nasi naaka, otsinkasi-tanakaro.” ");
INSERT INTO prq_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Ari yakanakiri iririntzi-payi, ikantziri: “¿Pimpinkatha-riwintatyii-nama? ¿Awirokama ompirawai-tyaana-niri?” Irootaki ikisaniinta-piro-tantanaka-riri, ikimakiri ikinkitha-takiro imisiri. ");
INSERT INTO prq_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Apiitaka imisiwaitzi José, ikamantajiri iririntzi-payi. Ikantziri: “Tzimatsi pasini nomisitakiri. Noñaakiri ishonkakina ooryaatsiri, kasiri aajatzi 11 impokiro, osiyawai-takaro impinkatha-tatyiinami.” ");
INSERT INTO prq_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Tima ti imanawityaaro José imisiri, ikamantakiri iriri aajatzi iririntzi-payi. Ari ikisatha-tanakiri iriri, ikantziri: “¿Ipaitama siyakaa-wintachari pimisitakiri? ¿Nompinkatha-taatyiimima naaka, piniro, aajatzi pirintzi-payi?” ");
INSERT INTO prq_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Tima kisaniinta iwakiri iririntzi-payi, iriima iriri pampitha-siri iwiro imisiri itomi. ");
INSERT INTO prq_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Okanta apaata, ijajiitaki iririntzi-payi José Sikochaariniki iwakaiyaari ipira-payi iriri. ");
INSERT INTO prq_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Ari ikantajiri Israel José, itomi, ikantziri: “¡Notomí! Nonintzi pijati Sikochaariniki, piñaatiri pirintzi-payi yaamaakowintari apira-payi anta.” Ikantzi José: “Aritaki nomatakiro.” ");
INSERT INTO prq_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Ikantzi Israel: “Pijati, piñaatiri pirintzi-payi tsika ikanta isaiki, aajatzi apira-payi. Impoña pimpiyi, pinkaman-tapajina.” Jatanaki José ipoñaakaro otaapiiki Aripiro-taariniki, irojatzi yariitan-takari Sikochaariniki. ");
INSERT INTO prq_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Ari itzimpinaka anta José, imonthaaka aparoni atziri, isampitawa-kiri, ikantziri: “¿Ipaita pikowakowa-tziri?” ");
INSERT INTO prq_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Ikantzi José: “Nokowakowa-tatziiri nirintzi-payi. ¿Tima piyotzi tsika isaiki yaamaakowintari ipira-payi?” ");
INSERT INTO prq_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Ikantzi atziri: “Jaitijiitaki, nokimakiri ikantzi ijajiiti Tsipajaariki.” Ari ijatanaki José ikowakowa-tajiri. Iñaajiri isaikajiitzi Tsipajaariki. ");
INSERT INTO prq_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Ikanta iririntzi-payi José iñaawakiri ipokaki, tikira yariityaata tsika isaikajiitaki, ikaman-tawakaa-jiitanaka intsitokiri. ");
INSERT INTO prq_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Ikantawakaa-jiita: “Awotsikitaki misiwai-tapiin-tatsiri. ");
INSERT INTO prq_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","¡Pimpoki! Thami antsitokiri, antitiri omoronaki. Ankantzi-maityaa: ‘Iwakari owantachari.’ Añaamatsiti tsika onkantyaa imisi-tapiintziri.” ");
INSERT INTO prq_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Ikanta ikimaki Rubén, inintzi yookakaa-wintirimi José airo iwasinonkaan-tari iririntzi-payi. Ikantanaki: “Airo awiri. ");
INSERT INTO prq_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Apatziro pintitiri impirita-moroki saikaintsiri tonkaariki, tima ti okamiithatzi pakotasitiri. Airo paparaa-waitziniri iriraani.” Iro ikantanta-witari Rubén ti ininti iwai-tiri José, impiyajiita iririki. ");
INSERT INTO prq_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Ikanta yariitapaaka José isaikajiitaki iririntzi, isapoka-waki-niri waniinka-chari oyaninanka iithaari. ");
INSERT INTO prq_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Ititakiri omoro-nakiki opiryaa-nakitaki. ");
INSERT INTO prq_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Ari isaikajiitzi iwajiita. Irojatzi iñaantawa-kariri ipokajiitaki Ismael-iiti ipoñaakaro Wakaniki. Ikyaakaa-yitakiri ipirai-tani, yamayitaki kasankari, aawinta-rontsi, owaaki inchato, ijatakairo Apitantoniki. ");
INSERT INTO prq_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Ikantana-kiri Judá iririntzi-payi: “¿Tikatsira ayi awiri aririntzi, apatziro-machii amanakotiro awa-kiri? ");
INSERT INTO prq_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Iro kamiitha-tatsi ampimantiri yayiri Ismael-iiti. Airo awa-waitziri, tima iriitaki aririntzi.” Onimotana-kiri iririntzi-payi okaratzi ikantakiri Judá. ");
INSERT INTO prq_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Ikanta yariitapaaka Maimaniwini-satzi iyompari-taniri, inosikapa-jiri José omoro-nakiki. Iwawisaa-kiniriri Ismael-iiti, ipinatana-kiri ikaratzi 20 ipiwiryaa kiriiki. Irootaki yaantai-tanakariri José Apitantoniki. ");
INSERT INTO prq_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Ikanta Rubén yaminawi-tapajari iririntzi, José, omoronaki, ti iñaapajiri, isara-nakiro iithaari okatsi-tzimo-niintana-kiri. ");
INSERT INTO prq_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Ipiyasi-tanakari isaikaki pasini iririntzi-payi, ikantapaa-kiri: “¿Ti añaajiri aririntzi? ¿Tsikama nonkantyaaka naaka?” ");
INSERT INTO prq_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Ipoñaa yaajiitakironi iithaari José, iriranitantakaro iriraani ipira iwamaakiri. ");
INSERT INTO prq_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Ityaankaji-niri iriri, ikantai-tapajiri Jacob: “Paminiro iroka kithaarintsi noñaakiro, piyotiro iroorika iithaari pitomi.” ");
INSERT INTO prq_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Iyotawajiro asitariri irootaki iithaari itomi, ikantanaki: “Irootaki iithaari notomi. Kimitaka iwakari owantachari, ithonka ipitharyaawaitakiri.” ");
INSERT INTO prq_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Isaara-nakiro iithaari Jacob, antaro okatsi-tzimo-niintana-kiri, yooso-thaki-tanakaro mirimasi-tatsiri manthakintsi, osamani iwasiri-tako-waita-kari itomi ikamaki. ");
INSERT INTO prq_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Oshiki poshinka-witaari itomi-payi, ari okimiwi-takari irisinto, titzimaita inintzi imposhinkai-tyaari. Aikiro iiraako-waita-tyaari itomi, ikantzi: “Airo nokara-takaaro nowasiri-tako-waityaari notomi, irojatzi noñaantapa-jyaariri naaka kaminkari-masiki.” ");
INSERT INTO prq_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Ikanta yariijiitaka iyompari-tantaniri Apitantoniki, ipimantapa-jiri aajatzi José, yamanantawakiri jiwatziriri owayiri-payi ipaita Potifar. Iriitaki yoka Potifar inampinatari Faraón pinkatha-ritatsiri Apitantoniki. ");
INSERT INTO prq_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Ikanta yaanakiri yompari-tantaniri José anta Apitantoniki, yamanan-tawakiri Apitantoni-satzi ipaita Potifar. Yoka Potifar ijiwari owayiri-payi inatzii, inampina iwiri pinkathari Faraón. ");
INSERT INTO prq_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Iro kantacha Pawa itsipa-tapiinta-kari José, kamiitha isaikaki iwankoki Potifar, Apitantoniki. ");
INSERT INTO prq_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Iyotaki Potifar ompiratariri José itsipata-taari Pawa, tima itasonka-wintziri maaroni yantayi-tziri. ");
INSERT INTO prq_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Irootaki yaakamiitha-piro-tantanaka-riri, iwakiri yaminiri yatziriti iwankoki, inintakaa-kiri aajatzi yaamaakowin-tyaaniri maaroni tzimimo-tziriri. ");
INSERT INTO prq_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Ikanta yitanakaro José yaamaakowin-taniri Potifar tzimatsiri iwankoki. Ari itasonka-winta-piro-tanakiri Pawa iwankoki yoka jiwari Potifar aajatzi iwaniki. ");
INSERT INTO prq_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Ikanta imatakiro José yaamaakowin-taniri Potifar maaroni tzimimo-tziriri, ti okantzimo-waitanaari Potifar opaita-rikapayi, apatziro yaminayitzi opaita-rika iyaari. Tima kamiithaa-niki ikanta irirori José, oshiki iniwisiryai-takari. ");
INSERT INTO prq_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Okanta apaata, aminamina-takiri iina ompiratariri, okantakiri: “Pimaantyaana.” ");
INSERT INTO prq_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Iro kantacha José ti yaapatyiiyaaro, ikantana-kiro: “Pinkimi nonkantimi. Nosaikira iwankoki ompiratanari, airo otzimawaitzi ompaityaa-rika kantzimo-tyaari-niri irirori. Tima inintakaa-kinaro naamawin-tyaaniri maaroni tzimimo-tziriri. ");
INSERT INTO prq_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Naaka yawintaaka iwankoki piimi, tikatsi inthañaa-pitha-tyaana. Apatziro ithañaami awiroka, tima iina iwimi. ¿Ipaitama nonkaaripiro-tzimo-tantyaariri Pawa?” ");
INSERT INTO prq_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Oshiki oñaasirinka-kiri José iroka kooya onintzi imaantyaaro. Titzimaita imaantyaaro. ");
INSERT INTO prq_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Okanta apaata, ikyaapaji José iwankoki ompiratariri yantawaiti. Tima apaniroini osaikaki iina Potifar. ");
INSERT INTO prq_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Ari airika-kotakiri iithaariki, okantamaitari: “Pimpoki pimaantyaana.” Isiya-pitha-tanakaro José, yookanakiro ikithaatari airikakiro iroori. ");
INSERT INTO prq_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Okanta oñaakiri isiya-pitha-tanakaro, yookanakiro ikithaatari airikakiro iroori, ");
INSERT INTO prq_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","okaimana-kiri ompira-tanipayi, okantakiri: “Yamaki noimi ishininka Heber-iiti inthainka-waitai. Ipokasi-takina inintzi imaantyaana, nokaima-kotakiri. ");
INSERT INTO prq_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Ikanta ikimaki nokaimanaki, siyanaka, niroka yookanakiro iithaari.” ");
INSERT INTO prq_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Ari owakiro iithaari José omaamintoki, irojatzi yariitan-tajari ompiratariri José iwankoki. ");
INSERT INTO prq_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Okamantawa-jiri oimi, okantziri: “Ikyaasi-takina amaapiintzi yoka ompira-tari ishininka Heber-iiti, inintawitaka ipinkatha-ryiinami. ");
INSERT INTO prq_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Ikanta nokaimanaki, siyanaka. niroka yookanakiro iithaari. ");
INSERT INTO prq_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Ari ikantawai-takinari pimpira-tani.” Antaro ikisanaka ompiratariri José ikimakiro okamantawa-jiriri iina. ");
INSERT INTO prq_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Yairikana-kiri José, yasitako-takaan-takiri tsika yasitakoi-tziri ityaan-tani irirori pinkatha-ripirori. Osamani isaikaki anta José. ");
INSERT INTO prq_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Okantawitaka yasitakoi-takiri, aikiro itasonka-winta-tziiri Pawa yoka José, oshiki ikawinthaa-kiri. Ikantakaa-karo Pawa yaapatyiiyaari ijiwari aamawin-tariri asitako-taari-payi. ");
INSERT INTO prq_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Ari inintakai-takiri José yaamaakowin-tyaari irirori asitako-taari-payi. Tima okaratzi inintakaan-tziri José, yantaitziro. ");
INSERT INTO prq_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Ti impomirintsi-waitanajyaa aamawin-tariri asitako-taari, tima iriitaki José aamaakowin-tanaa-riri maaroni. Tima ari yasi iwiro Pawa itsipatakari José, itasonka-wintapiin-takiri. ");
INSERT INTO prq_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Ikanta Pakotantaniri imiritaitari aajatzi kotsiwin-tziriri, iwatsimaa-kiri pinkatha-ritatsiri Apitantoniki. ");
INSERT INTO prq_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Tima yoka pinkathari Faraón, ikisakiri inampiri ijiwari pakotziriri imiri, aajatzi ijiwari kotsiwintziri. ");
INSERT INTO prq_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","Ityaantaki-niri jiwatziriri asitako-taari, yasitako-tawakiri. Ari isaikitzitari irirori José yasitakoi-tziri. ");
INSERT INTO prq_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Ikanta jiwatziriri asitako-taari, iwawisaa-kiniri José yaamaakowin-tyaari yokapayi. Oshiki osarintsi yasitakoi-takiri anta. ");
INSERT INTO prq_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Okantaka apaata, yoka asitako-taari pakotan-tziri aajatzi kotsiwin-tantatsiri, imisiwaitaki. Onasitaka imisitakiri aparoni-payi, onasitaka aajatzi okaratzi osiyakaa-wintari. ");
INSERT INTO prq_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Okanta okitai-tamanaji, pokamanaji José iñiiri yokapayi, iñaapaa-tziiri antaro iwasiritaka. ");
INSERT INTO prq_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Isampitapaa-kiri yokapayi, ikantziri: “¿Ipaita piwasiri-tantari?” ");
INSERT INTO prq_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Ikantajiitaji irirori: “Tzimatsi nomisitakiri, tikatsi-maita yotiro-niri ipaita siyakaa-wintachari.” Ikantzi José: “Pinkaman-tinaro pimisitakiri. Tima Pawa iriitaki matzirori iyotakaan-tziro misirintsi.” ");
INSERT INTO prq_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Ari yitanaka-rori ijiwari pakotan-taniri ikamantziri José okaratzi imisitakiri, ikantziri: “Noñaaki nomisiriki aparoni pankirintsi. ");
INSERT INTO prq_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","Tzimatsi mawa otiwa. Noñaatziiro otyaaki-tanaki, irakayitanaki okithoki. ");
INSERT INTO prq_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Ari nairikakiro naaka irira-minto Faraón. Naamaitaro okithoki pankirintsi, nokathowaa-takiro. Naakomai-taniri Faraón nopakotziri.” ");
INSERT INTO prq_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Ari ikantzi José: “Iroka siyakaa-wintachari pimisiri: Mawatatsiri otiwa pankirintsi, irootaki mawa kitaitiri. ");
INSERT INTO prq_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Aririka awisaki mawa kitaitiri yamina-kotajimiro Faraón okaratzi pantzimo-takiriri, inintzi papiitajiro pantawai-tajiniri. Aritaki pimpakotajiri imiri, pikimitziro pairani. ");
INSERT INTO prq_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Aririka omatakyaa nokantaki-miri, airo pipyaakotana naaka. Pinkamantiri Faraón nositowan-tajyaari naari. Pinkaminthaa-jataina. ");
INSERT INTO prq_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Tima piman-taari nonatzi naaka, nopoñaakaro inampiki Heber-iiti. Ti onkamiithati yasitakoi-tina, tima tikatsi kaaripirori nantiri.” ");
INSERT INTO prq_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Ikanta ikimaki ijiwari kotsiwai-tatsiri iroopirori ikamantan-takiri José. Ikantana-kiri irirori: “Nomisitaki aajatzi naaka nopiwirika-kiro noitoki mawa kantziri ojaikitaki kitamaarori owaritintsi. ");
INSERT INTO prq_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Irooma mawatatsiri kantziri nopiwirika-kiro, ari ojaikitakari nasiwai-yitachari owaritintsi nompiriri Faraón. Ikanta ipokapaaki tsimiri-payi iwapaakaro nowakotakiri noitoki.” ");
INSERT INTO prq_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Ikantzi José: “Iroka siyakaa-wintachari pimisiri awiroka. Mawatatsiri kantziri mawa kitaitiri onatzii. ");
INSERT INTO prq_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Aririka omonkara-tapaa-kyaa mawa kitaitiri, ari yamina-kotajimiro Faraón pantakiri pairani, intha-takaan-takimi inchatoki, impokamaityaa tsimiri-payi iyaaro piwatha.” ");
INSERT INTO prq_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Ari monkarataka mawa kitaitiri, ari yoimosirinkiro Faraón itziman-takari pairani. Antaro yoimosirinka-jiitaka itsipayi-takari inampiri-payi. Ari ikaimakaan-takiri ijiwari pakotatapiin-tziniriri imiritari aajatzi ijiwari kotsiwaintsiriri. ");
INSERT INTO prq_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Ikantajiri ijiwari pakotziriri imiritari: “Papiitajiro pimpakotajina nomiri.” Ari yapiitajiro ipakotajiri imiritari Faraón ikimitajiro pairani. ");
INSERT INTO prq_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Iriima ijiwari kotsiwai-taniri, ithatakaan-takiri. Tima monkarataka ikantaki-riri José siyakaa-wintachari imisiri. ");
INSERT INTO prq_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Iro kantacha yoka ijiwari pakotan-taniri, imaisan-takiri José, ti inkinkithasiri-tairi. ");
INSERT INTO prq_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Okanta awisaki apiti osarintsi. Ari imisitaki Faraón isaiki othapyaaki nijaa. ");
INSERT INTO prq_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Iñaatzii isitowapaaki nijaaki 7 wathantzi-payi vaca, owaniinka ikantayitaka. Ari iwajiitapaaka katarosi anta. ");
INSERT INTO prq_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Ipoñaa iñaaki isitowapaaki pasini 7 vaca, matha-poroki ikantayitaka, ikatziya-paaka tsika ikatziyaka pasini wathantzi-payi vaca. ");
INSERT INTO prq_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Ikanta mathari-payi vaca, iwanakari wathantzi-payi owaniinkatachari vaca. Ari isaakitanaki Faraón. ");
INSERT INTO prq_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Ikanta imaanaji aajatzi, imisitaki pasini. Iñaaki 7 opaki pankirintsi kamiitha okantayitaka, aparoni okanta owaato. ");
INSERT INTO prq_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Ipoñaa iñaaki pasini 7 opaki pankirintsi, tikatsi apantyaa-roniri, kamakiyitaki okantakaaro tampyaa kinapaintsiri isitowa-piintzi ooryaatsiri. ");
INSERT INTO prq_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Okanta pankirintsi kaari apantyaa-roniri opaki, owanakaro pasini 7 opaki kamiitha-tatsiri okithoki. Ari isaakitanaki Faraón, iñaatzii imisiwai-tatzii. ");
INSERT INTO prq_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Ikanta ipiriin-tamanaja okitai-tamanaji oshiki okantzimo-siri-takari, ikaimakaan-takiri ñaawyatan-tani-ripayi aajatzi yotan-tani-ripayi ikaratzi tzimatsiri Apitantoniki. Ikinkitha-takiro Faraón okaratzi imisitakiri, tikatsi yotiro-niri opaita-rika siyakaa-wintachari imisiri. ");
INSERT INTO prq_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Ikanta ijiwari pakotapiin-tziriri imiri Faraón, ikantakiri: “¡Pinkatharí! Tzimatsi nopyaako-takiri, owakira nokinkisiryaa-najiro. ");
INSERT INTO prq_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Tima pairani pikisakina, aajatzi pikimitaa-kiri jiwatziriri kotsiwai-tatsiri, pityaan-kakina isaiki jiwatziriri asitako-taari, pasitako-takaan-takina. ");
INSERT INTO prq_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Ari imisiwaitaki ijiwari kotsiwai-tatsiri, nomisitzitaka aajatzi naaka. Tzimatsi osiyakaa-wintari okaratzi nomisitakiri. ");
INSERT INTO prq_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Tzimatsi anta aparoni mainari ishininka Heber-iiti, impira-tani inawita jiwatziriri owayiri-payi. Iriitaki nokamantaki okaratzi nomisitakiri, ikamantaki-naro irirori opaita siyakaa-wintachari. ");
INSERT INTO prq_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Omonkarataka maaroni ikantaki-nari. Napiitajiro nantawai-tajimi, iriima pasini ithataitakiri.” ");
INSERT INTO prq_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Ikanta ikimaki Faraón, ikaimakaan-takiri José. Sintsiini imisitowai-takiri. Jatanaki yamii-takaan-tapainta José, ikithaa-tapainta pasini iithaari, jataki isaiki Faraón. ");
INSERT INTO prq_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Ikantawa-kiri Faraón: “Tzimatsi nomisitakiri, tikatsi-maita yotiro-niri opaita-rika siyakaa-wintachari. Iro kantacha nokimaki naaka pimatziro awiroka piyotziro siyakaa-wintachari misirintsi.” ");
INSERT INTO prq_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Ari yakanaki José, ikantanaki: “¡Pinkatharí! Ti noyotasi-tyaaro apaniroini, iriitaki Pawa yotakai-naroni osiyakaa-wintari pimisiri.” ");
INSERT INTO prq_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Ari ikinkitha-waitanaki Faraón, ikantana-kiri José: “Nomisitaki nosaiki othapyaaki nijaa. ");
INSERT INTO prq_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","Noñaaki isitowapaaki nijaaki 7 wathantzi-payi vaca, owaniinka ikantayitaka. Ari iwawaijii-tapaaka katarosi anta. ");
INSERT INTO prq_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Ipoñaa noñaaki isitowapaaki pasini 7 vaca, matha-poroki ikantayitaka. Ti noñaapiinti aka Apitantoniki siyaari-niri yokapayi vaca. ");
INSERT INTO prq_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Ikanta mathari-payi vaca, iwanakari pasini wathantzi-payi. ");
INSERT INTO prq_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Okantawitaka iwawitakari wathantzi-payi vaca, aikiro imathatatzii. Ari nosaaki-tanakiri. ");
INSERT INTO prq_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Ipoñaa nomisitaki pasini, noñaaki 7 opaki pankirintsi, okitho-piro-tatzii iroori, owaniinka okantayitaka oshookantaro aparoni owaato. ");
INSERT INTO prq_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Noñaatzii pasini pankirintsi oshookanaki 7 opaki, tikatsi apantyaa-roniri, kamakiyitaki okantakaaro tampyaa kinapaintsiri isitowa-piintzi ooryaatsiri. ");
INSERT INTO prq_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Okanta pankirintsi kaari apantyaa-roniri opaki, owanakaro pasini 7 opaki kamiitha-tatsiri okithoki. Tima nokamanta-witakari niwya-tani-ripayi, tikatsi yotiro-niri ipaita siyakaa-wintachari nomisitakiri.” ");
INSERT INTO prq_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Ikantanaki José: “¡Pinkatharí! Apiti okarawita pimisiri, iro kantacha aparoni okanta ikamantzimiri Pawa yantiri. ");
INSERT INTO prq_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Tima ikarataki 7 wathantzi-payi vaca, 7 osarintsi onatzi. Karatatsiri 7 opaki pankirintsi, 7 osarintsi onatzi aajatzi. Aparoni okanta pimisiri. ");
INSERT INTO prq_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Ari ikimitakari 7 mathari-payi vaca, oyaatapaa-kiriri wathantzi-payi, 7 osarintsi onatzii. Karataintsiri 7 opaki kamakiyi-taintsiri okantakaaro tampyaa kinapaintsiri isitowa-piintzi ooryaatsiri, iro 7 osarintsi iñaitiro tashitsi. ");
INSERT INTO prq_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Okaratzi nokaman-takimiri pinkatharí, irojatzi ikamantzimiri aajatzi Pawa onkarati yantiri. ");
INSERT INTO prq_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Tima onkarati 7 osarintsi oshikiti pankiwai-rintsi maaroni Apitantoniki. ");
INSERT INTO prq_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Impoña onkarati 7 osarintsi airo oshookaji pankirintsi. Tima piyakoityaaka onkantajyaa oshiki-witapaintyaa pankirintsi Apitantoniki. Aritaki ayimatakiri itashi ikaratzi nampitarori aka. ");
INSERT INTO prq_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Tima antaro onkantyaa tashitsi, airo iñaitajiro owaritintsi oshikiwi-tapainchari pairani. ");
INSERT INTO prq_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","¡Pinkatharí! Aparoni okanta osiyakaa-wintari apiti pimisitakiri. Sintsiini omatajyaa, tima irootaki ikowakiri Pawa yantiro. Irootaki yapiitan-takarori imisimpyiimi. ");
INSERT INTO prq_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","¡Pinkatharí! Pamini yotaniri atziri jiwatiro-niri maaroni nampitsi Apitantoniki. ");
INSERT INTO prq_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","¡Pinkatharí! Pamini jiwari-payi jatatsi-niri maaroni nampitsiki tzimatsiri aka Apitantoniki. Iriitaki piyotiro-ni pankirintsi, irojatzi omonkara-tantakyaari 7 osarintsi oshiki-tapainti. Tima tsika-rika ontzima-piroti pankirintsi, yayi kapichiini iwapithaan-tyaaro. ");
INSERT INTO prq_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Inthonka ikoyiiro okaratzi kithoki-tatsi-ni osarintsiki, impiri pinkatha-riyi-tatsiri nampitsiki iwapithaan-tyaaro, irootaki iyaari atziri-payi apaata. ");
INSERT INTO prq_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Pimatiro piwapithaan-tyaaro pankirintsi maaroni nampitsiki, airo aantari atziri-payi itashi ariitakyaa-rika 7 osarintsi intashaiti maaroni Apitantoniki.” ");
INSERT INTO prq_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Onimotana-kiri Faraón aajatzi inampina-payi okaratzi ikantakiri José. ");
INSERT INTO prq_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Ari ikantanaki Faraón: “¿Arima añaaki pasini atziri kimityaa-riniri José, isaikan-tasiri-tantari itasorinka Pawa?” ");
INSERT INTO prq_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Ipithoka-sitana-kari José, ikantana-kiri: “Tikatsi pasini yotaniri anaimi-ni awiroka, tima Pawa oyotani-takayimirori maaroni iroka. ");
INSERT INTO prq_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Awiroka jiwatatsi-niri nowinkatha-ripankotiki, inkimisan-tajimi maaroni atziri onkarati pinkantiriri. Apatziro nanaa-jimi naaka impinkathai-tina, tima pinkatha-ripirori nonatzii.” ");
INSERT INTO prq_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Aikiro ikanta-nakitzi faraón: “¡José! Naaka owakimi pijiwatiri maaroni Apitantoni-satzi.” ");
INSERT INTO prq_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Inothopaakiri Faraón iwiri irakoim-piki, iwakiniri irakoim-piki José. Ikithaa-taitakiri iroopirori, ithaano-takai-takari thatanintsi iwitsikai-tziri ooro. ");
INSERT INTO prq_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Ititaitakiri isiyako-mintoki inampiri pinkathari, ikantai-takiri atziri-payi inkaima-jiiti, inkanti: “Pintyiirowa-sityaari.” Ari yitanakaro José ijiwatziri maaroni Apitantoni-satzi. ");
INSERT INTO prq_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Ikantanaki aajatzi Faraón: “Okantawitaka naaka pinkatha-ritatsiri, iro kantacha awiroka inkimisanti maaroni Apitantoni-satzi, airo yantasi-waitaro inintziri irirori, onkarati pinkantiriri irootaki yantiri.” ");
INSERT INTO prq_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Iwakiniri Faraón pasini iwairo José, ipaitakiri Zafnat-panea. Ipakiri iinantyaaro Asenat irisinto Potifera antyawiyari-tatsiri nampitsiki Ñaapironiki. Ari yitanakaro José ipinkatha-riwintziri maaroni Apitantoni-satzi. ");
INSERT INTO prq_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Tima yaantai-tanakariri José iñiiri Faraón, aritaki tzimaki 30 isarintsiti. Ikanta iwithatana-kari José pinkathari Faraón, jataki yaniitiro maaroni Apitantoni. ");
INSERT INTO prq_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Oshikitaki pankirintsi okaratakira 7 osarintsi. ");
INSERT INTO prq_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Monkara-tapaaka 7 osarintsi. Ithonka ipiyo-takaan-takiro José okaratzi kithoki-taintsiri pankirintsi aka Apitantoniki. Iwapithaantaka maaroni nampitsiki okaratzi kithoki-yitaintsiri owaantsiki. ");
INSERT INTO prq_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Ipiyotaki José oshiki pankirintsi, osiyakaro impaniki tzimatsiri nijaaki. Omaapiro oshikitaki, ti iyotairo tsika-rika okaratzi. ");
INSERT INTO prq_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Tikira iñaitiro tashitsi, iwaiyan-takaa-kiro iina José paitachari Asenat, tzimaki apiti itomi. Iwaiyan-takaa-kirori irisinto antyawiyari-tatsiri nampitsiki Ñaapirorini. ");
INSERT INTO prq_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Itakarori itzimaki itomi ipaitakiri “Maisantaantsi”, tima ikantana-kitzii José: “Imaisan-takaa-kinaro Pawa nokimaatsi-waita, aajatzi inkimitajiri noshininka-payi.” Iroka wairontsi Maisan-taantsi, irootaki ikantziri iñaaniki iriroriiti “Manasés”. ");
INSERT INTO prq_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Iriima pasini itomi ipaitakiri “Kithotaantsi.”, tima aikiro ikantana-kitzii José: “Ikitho-takaa-kina Pawa nampitsiki tsika nokimaatsi-waitaka.” Iroka wairontsi Kithotaantsi, irootaki ikantziri iñaaniki iriroriiti “Efraín”. ");
INSERT INTO prq_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Aritaki monkara-tapaaki 7 osarintsi okithoki-piro-tanta-kari pankirintsi Apitantoniki. ");
INSERT INTO prq_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","Itanakaro karatatsiri 7 osarintsi iñaantai-takarori itashaaniin-taitaki, tima irootaki ikantzi-takari pairani José. Ithonka itashaitaki maaroni nampitsiki, irooma Apitantoniki ti iñiitiro, tima tzimatsi oshiki owaritintsi ipiyo-takaan-taitakiri. ");
INSERT INTO prq_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Ikanta iñaakiro Apitantoni-satzi tashitsi, ijatasi-takiri Faraón inkampitiri owaritintsi. Ikantawa-kiri Faraón maaroni Apitantoni-satzi: “Pijatasitiri José, pantiro onkarati inkantimiri.” ");
INSERT INTO prq_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Aritaki antitanaka tashitsi maaroni nampitsiki, yasitaryaa-kaantaki José tsika iwapithaan-taitakaro owaritintsi impiman-tiniri Apitantoni-satzi, tima aikiro omaapiro-tatyaa tashitsi. ");
INSERT INTO prq_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Ari ipokajiitaki Apitantoniki oshiki atziri poñaachari pasiniki nampitsi saika-nampi-tzirori, inintzi yamananti owaritintsi ipiyo-takaan-tani José, tima ti ontzimaji owaritintsi pasiniki nampitsi-payi. ");
INSERT INTO prq_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Ikanta ikimaki Jacob tzimatsi owaritintsi Apitantoniki, ikantakiri itomi-payi: “¿Ipaitama paminamintha-tawakaantari? ");
INSERT INTO prq_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Nokimaki tzimatsi owaritintsi Apitantoniki. Pijati pamanan-takiti, aajai = kari atashi.” ");
INSERT INTO prq_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Ari ijajiitanaki 10 iririntzi-payi José, itomira Jacob, yamananti owaritintsi Apitantoniki. ");
INSERT INTO prq_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Iro kantacha, ti isinitiri Jacob ijati Benjamín, iririntzi okaakiini José. Tima itharowakaa-tyaari iriri awishi-motziri = kari kowiinkari. ");
INSERT INTO prq_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Ikanta ijajiitakini itomi-payi Israel, ari ikarajii-tanakiri pasini-payi atziri jatatsiri yamananti owaritintsi. Tima maaroni Owintiniki iñaitakiro tashitsi. ");
INSERT INTO prq_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Iriitakira José jiwatatsiri Apitantoniki, iriitaki pimantzi-niriri owaritintsi atziri-payi poñaayi-tachari pasiniki nampitsi. Ikanta yariijiitaka iririntzi José, ityiirowa-sitapaa-kari, yoiyootapaaka kipatsiki. ");
INSERT INTO prq_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Iyotawakiri José iririntzi-payi iñaawaki-rira. Ikimi-takaan-takari ti iyotiri, isinchiin-kata-tziiri isampitziri, ikantziri: “¿Tsikama pipoñaaka awirokaiti?” Ikantajiitzi irirori: “Nopoñaaro Owintiniki, nopoki namananti owaritintsi.” ");
INSERT INTO prq_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Tima iyowitawakari José iririntzi-payi, titzimaita iyotapajiri irirori-payi. ");
INSERT INTO prq_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Ari ikinkisiryaa-nakiro imisitakiri pairani José, ikantana-kiri iririntzi-payi: “¡Iitaimpyaa-wairintzi pinajiitzi! Pipokajii-tatzii paminiro tzimatsi-rika nonampiki kaari kisakowin-tachani piwayiri-tyaaro.” ");
INSERT INTO prq_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Ikantajiitzi iririntzi: “¡Ti pinkatharí! Apatziro nopokajiitzi namananti owaritintsi. ");
INSERT INTO prq_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Maaroni nokarataki aparoni ikanta asitanari. Kamiitha-siri nonajiitzi. Ti naaka iitaimpyaa-wairintzi.” ");
INSERT INTO prq_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Aikiro isintsi-tatzii José ikantziri: “Pithaiyaa, pipokajii-tatzii paminiro nonampi.” ");
INSERT INTO prq_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Ikantajiitzi iririntzi: “Naakaiti, nopoñaa Owintiniki, nokarawi-jiita 12 nirintzi-tawakaa, aparoni ikanta asitanari. Irojatzi isaikanaki pasini iyaapitsi nirintzi itsipatari asitanari. Pyaaka aparoni, ti noñaajiri.” ");
INSERT INTO prq_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Yapiitana-kiro José ikantziri: “Aritaki nokantakimi. Iitaimpyaa-wairintzi pinatzi. ");
INSERT INTO prq_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Iroka noyotan-tyaamiri: Tima airo pijajiitaji pinampiki airorika pamanari iyaapitsi pirintzi. ¡Omaapiro-tatyaa! ");
INSERT INTO prq_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Apatziro impiyaji aparoni pirintzi yaakitiri iyaapitsi. Irojatzi isaikawaki pasini-payi yasitakoi-tiri. Ari noñiirori omaapiro-rika pikantaki-nari. Aririka pinthaiya-kyaa, awiroka iitaimpyaa-wairintzi. ¡Omaapiro-tatyaa!” ");
INSERT INTO prq_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Yasitako-takaan-takiri José maaroni iririntzi-payi okaratzi mawa kitaitiri. ");
INSERT INTO prq_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Okanta omonkarataka mawa kitaitiri, ikantajiri: “Nopinkatha-tziri naaka Pawa. Aririka pinkimisantina, airo pikamajiitzi. ");
INSERT INTO prq_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Omaapiro-rika pikamiitha-siri-jiitzi, pookanaki aparoni pirintzi yasitakoi-tiri, pijataji awiroka-payi paanaji owaritintsi iyaari piwaiyani-payi. ");
INSERT INTO prq_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Aririka pamakiri iyaapitsi pirintzi, ari noyotiri omaapiro pikantaki-nari. Airorika, aritaki pinkamaki.” Imajiitakiro okaratzi ikantaki-riri iririntzi, José. ");
INSERT INTO prq_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Ari ikantawakaa-naka irirori: “Tima omaapiro ti anisironkatiri aririntzi, ti ankimisantiri ikantawi-takairi pairani: ‘Airo piwasinonkaa-waitana,’ añaawitakari ikimaatsi-waitaka. Irootaki añaantarori iroñaaka asinonkaa-waita aroka-payi.” ");
INSERT INTO prq_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Ari ikantanaki Rubén: “Tima nokantawitakami pairani airo piwasinonkaa-waitziri aririntzi. Ti pinkimisanta-jiitina. Ontzimatyii atsipityaaro iroñaaka iwasankitaa-wintaitajiri ikamakira.” ");
INSERT INTO prq_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Titzimaita iyojiiti ikimakiri José okaratzi ikinkitha-waijiitziri. Tima inkinkitha-waitakayiri José iririntzi-payi tzimatsi owaaka-kotziriri iñaani inkimatha-tantyaariri. ");
INSERT INTO prq_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Ari ijapitha-tapaintziri José iririntzi-payi, iraanaka. Ipoñaa ipiyapaaka isaikajiitaki, ikinkitha-waitakaa-pajiri. Yaakiri Simeón, yooso-takaan-takiri, maaroni iñaajii-takiri. ");
INSERT INTO prq_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Ikantakiri impira-tani ijaikitiniri owaritintsi, yoipyaaji-niri iiriikiti, intiyitainiri owaritintsiki. Impawajiri aajatzi iwanajyaari awotsiki. Imataikiro ikantakiri José. ");
INSERT INTO prq_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Ari ikyaakaa-najiri ipira-payi owaritintsi, jaitijiitaji. ");
INSERT INTO prq_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Ikanta ariijiitajani tsika imaajii-tapaaki, yaminakiro ititantarori owaritintsi aparoni iririntzi, inintzi impiri iyaari ipira. Iñaatzii ititaka iiriikiti, iwaitaki-niri opaantiki ititaminto. ");
INSERT INTO prq_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Ikantziri iririntzi-payi: “Piñiiri noiriikiti yoipyaaja-nari. Yoka aka.” Antaroiti itharowa-jiitanaki, piyonkawaitanaka, ikantawakaa-jiita: “¿Tsikama inkantajairika Pawa?” ");
INSERT INTO prq_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Ikanta yariijiitaja Owintiniki, ikamantapa-jiri asitariri okaratzi awishi-motakiriri, ikantapa-jiri: ");
INSERT INTO prq_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","“Isinchiin-kawaitakina iñaanatana pinkatha-ritatsiri anta, isiyakaan-takina naakami iitaimpyaa-wairintzi, naminatziiro inampi. ");
INSERT INTO prq_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Ari nakanakiri naaka, nokantana-kiri: ‘Kamiithari atziri nonajiitzi, ti naaka iitaimpyaa-wairintzi. ");
INSERT INTO prq_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Nokarawi-jiita 12 nirintzi-tawaka, aparoni ikanta asitanari. Tzimatsi aparoni pyainchari, ti noñaajiri nontsipa-tajyaari. Iriima iyaapitsi irojatzi isaikanaki irirori Owintiniki itsipatari asitanari.’ ");
INSERT INTO prq_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Ikantana-kina irirori: ‘Ari noñaantakyaami omaapiro-rika pikantana kamiitha atziri pinajiitzi. Pookanakina aparoni pirintzi, pimpiyi awiroka-payi paanaji owaritintsi iyaari piwaiyani-payi. ");
INSERT INTO prq_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Ontzimatyii pamajinari iyaapitsi pirintzi. Ari noñiimiri omaapiro pikantanari kamiitha pinajiitzi, ti pikimityaari iitaimpyaa-wairintzi. Ari napakaajiri pirintzi, kantatsi pamananta-waiti nampitsiki tikatsi thañaa-pitha-tyaamironi.’ ” ");
INSERT INTO prq_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Ikanta isokapajiro owaritintsi, iñaatzii ititako-yitaka iiriikiti. Antaro itharowa-jiitanaki imatzitana-karo iriri, tima iñaakiri ititako-yitaka iiriikiti. ");
INSERT INTO prq_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Ikantzi Jacob: “Irootaintsi pinthonki-tinari pirintzi-payi. Ti añaajiri José, ari pikimitaa-kiri iroñaaka Simeón. Aikiro pikowatzii payitinari Benjamín. Antaro okantzimo-niintakana naaka.” ");
INSERT INTO prq_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Ikantana-kiri Rubén asitariri: “Pisinitinari Benjamín, naaka aamaakowin-tyaarini. Aritaki namajimiri. Airorika namajiri, piwamairi apitiroiti notomi naaka.” ");
INSERT INTO prq_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Yapiitana-kiro Jacob, ikantanaki: “Airo nosinitziri iyaatimi pirintzi. Tima kamaki José iririntzi okaakiini irirori, aparoni ikanta isaikanaji. Tzimatsi-rika awishi-motakirini, awiroka kantakaan-tironi nonkaman-tajyaari, kaari ayinani nantyasiparinka, nowasirinka aajinani. ");
INSERT INTO prq_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Aikiro ojatatzii itashaitzi maaroni nampitsiki. ");
INSERT INTO prq_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Tima inthonka-jiro Israel owaritintsi yaakitziri itomi-payi Apitantoniki. Ikantajiri itomi-payi: “Pijati, pamanan-taati kapichiini owaritintsi ayaari.” ");
INSERT INTO prq_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Ikantzi Judá: “¡Apaá! ikantawajana yoka atziri nopiyan-tajari: ‘Airorika pamanari iyaapitsi pirintzi, ti noninti pimpiya-sitajina.’ ");
INSERT INTO prq_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Aririka pisinitakiri naanakiri iyaapitsi, aritaki nojataki namanantaati owaritintsi. ");
INSERT INTO prq_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Airorika pisinitziri, airo nojatzi. Tima aritaki ikantzi-tawaana: ‘Airorika pamiri pirintzi, ti noninti pimpiya-sitajina.’ ” ");
INSERT INTO prq_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Ikantanaki Israel: “¿Ipaitama piwasinonkaan-tanari? ¿Ipaita pikaman-tantakariri tzimatsi iyaapitsi pirintzi?” ");
INSERT INTO prq_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Ari ikantajiitzi itomi: “Oshiki isampitakina tsika nokaratzi, ikantana: ‘¿Ainiro isaiki asitamiri? ¿Tzimatsima pasini pirintzi?’ Ti onkanti nonthaiyaa, ontzimatyii nakiri isampitanari. ¿Tsikama noyotan-takyaari inintatzii nayiniri iyaapitsi nirintzi?’ ” ");
INSERT INTO prq_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Ikantzi Judá: “¡Apaá! Anintzi-rika añaajiiti, pisinitiri iyaapitsi iyaatana-kina, naaka aamaakowin-tyaarini. Aritaki nojatanaki iroñaaka, ajai = kari atashi maaroni. ");
INSERT INTO prq_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Naaka pinatimini opaita-rika awishi-motakirini. Airorika noipyaaji-miri, naaka pooko-tapiintajiri irojatzi nonkama-kotajiri. ");
INSERT INTO prq_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","¡Apaá! Apiti-mi nompiyakimi namananti ayaari, airomi atzimawin-tziro akinkitha-waitzi.” ");
INSERT INTO prq_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Ari ikantanaki asitariri: “Tikatsi nonkinakairo nonthañiiyaari iroñaaka pirintzi, pimatiro. Payitanakyaa tzimatsiri anampiki pimpasi-tyaariri atziri. Pintiti kapichiini itziritaitari, yaarato, kasankari, kipishaari aajatzi pasotziki. ");
INSERT INTO prq_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Paanaji pasini kiriiki panaakairi ikaratzi paanakiri chapinki, pimpapajiri iiriikiti ititakaa-waji-miri, aamaiyaa ipyaakotakityaari ititakaantawajamiriri. ");
INSERT INTO prq_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Pijati piñaajatiri atziri, paanakiri pirintzi. ");
INSERT INTO prq_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Onkamintha inkan-takai-yaaro Pawa Sintsi-pirori inisironka-tantawajyaa-miri, isinitan-tajyaariri pasini pirintzi aajatzi Benjamín. Iroorika inintzi Pawa yapirotyaa notomi-payi, omatyaata.” ");
INSERT INTO prq_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Imatakiro itomi-payi Israel yaanaki impasityaariri José, yaanajiri iiriikiti yoipyaaji-niri, yaanaji pasini kiriiki impinatirori owaritintsi yamajiri. Yaanakiri aajatzi Benjamín, jaitijiitaki Apitantoniki. Yariitaaro isaikira José. ");
INSERT INTO prq_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Ikanta iñaawakiri José yariitapaaka Benjamín, ikantana-kiri inampiri irirori: “Paanakiri ariitapain-chari nowankoki, piwamaakaanti nopira, pinkotsi-takaan-tiri, nonintatzii nakyootiri yokapayi intampatzika-tapaakirika ooryaatsiri.” ");
INSERT INTO prq_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Imatakiro inampiri José okaratzi ikantaki-riri. Irijatzi aanakiriri iwankoki. ");
INSERT INTO prq_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Antaro itharowa-jiitanaki iñaakiro ikinakai-takiri iwankoki José. Ikantawakaa-jiita: “Piñiiri iitaimpyaawaita yoka. Iitaimpyaa-tyaari iiriikiti yoipyaakairi chapinki. Kimitaka yantawai-takaa-tyai inkimi-takaan-tairi yatziriti, ari inkantzi-takyaari aajatzi apira-payi.” ");
INSERT INTO prq_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Ikanta yariitapaaka iwankoki, ikinkitha-waitakaa-paakiri inampiri José. ");
INSERT INTO prq_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","Ikantziri: “¡Ñaamisa, Jiwarí! Ari nopokaitzi chapinki namanantzi owaritintsi. Ti nothaiya. ");
INSERT INTO prq_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Ikanta nopiyanajaro, ariijii-taana tsika nomaapaaki. Naminakiro nowantarori owaritintsi, noñaatziiri ititaka kiriiki. Titzimaita ipyaawaita, irojatzi ikaratzi noipyaaji-miri. ");
INSERT INTO prq_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Namaki pasini kiriiki nompina-tirori owaritintsi naanajiri. Ti noyomaityaa ipaita-rika otitajiriri kiriiki namitakari chapinki.” ");
INSERT INTO prq_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Ikantzi inampiri José: “Airo pitharowa-siwaita. Aamaiyaa iriitaki Piwawani, Iwawani Asitamiri otitajimiriri kiriiki. Tima naaka aawakiri kiriiki pipinataki-rori owaritintsi.” Ikanta inampina José, imisitowa-kaan-takiri Simeón, yamaitajiri isaikaki iririntzi-payi. ");
INSERT INTO prq_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Ari ikarajiitanaki ikyaanaki iwankoki José, ipapaakiri nijaa inkiwa-kiitzi-tyaari, ipakiri iwariti, aajatzi ipira-payi. ");
INSERT INTO prq_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Tima iyojiitaki aritaki inkarati iwajiityaa José, owitsika ikantajiitaka impawakiri ikaratzi yamakiniriri aririka yariitapaa-kyaa tampatzika ooryaatsiri. ");
INSERT INTO prq_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Ikanta yariitapaaka José iwankoki, ipakiri okaratzi yamayitakiri iririntzi inampiki. Ipinkatha-tanakiri, yoiyootanaka kipatsiki. ");
INSERT INTO prq_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Ari isampitana-kiri José, ikantziri: “¿Sintsijiitatsimi? ¿Saikatsi piri pikantaki-nari antyasiparitaki? ¿Katsi awishimotirini? ¿Irojatzima yañii irirori?” ");
INSERT INTO prq_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Ari yapiitana-kiro yoiyoo-tasitari ipinkatha-tziri, yakanakiri ikantziri: “¡Pinkatharí! Saikatsi pimpira-tani, asitanari. Ti imantsiya-waiti, irojatzi yañii.” ");
INSERT INTO prq_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Ari yaminanakiri José ikatziya-yitaka, iñaatziiri Benjamín iriitaki owaiyani iriniro irirori. Ikantanaki: “¿Iriima iyaapitsi pirintzi pikantanari?” Ari ipithoka-sitana-kari Benjamín, ikantana-kiri: “¡Mainarí! ¡Inkamintha Pawa tasonka-wintimini!” ");
INSERT INTO prq_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Antaro iraa-siri-tanaka José iñaawajiri iririntzi. Ikyaanaki shintsiini imaapiintzi, ari iraawai-takari. ");
INSERT INTO prq_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Ikanta itonkakiro iraaka, ikiwa-poro-tanaja, sitowapaji, ikantapaaki: “Piyiiti owaritintsi.” ");
INSERT INTO prq_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Onasita iwakoitaki-niri iwariti José, ari ikimitai-kiniri iririntzi-payi, aajatzi Apitantoni-satzi itsipa-tani José. Tima ipinkakaan-tani Apitantoni-satzi intzipatyari ishininka-payi Heber-iiti. ");
INSERT INTO prq_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Ari imisaika-kaan-takiri José iririntzi-payi, yitanakari itarori itzimi irojatzi iyaapitsiki. Okiryaantsi ikantajii-tanaka iririntzi-payi José, iñaakiri imisaika-kiri itarori itzimi irojatzi iyaapitsiki. ");
INSERT INTO prq_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Itsipa-takiri José iririntzi-payi okaratzi tzimatsiri iwamintoki. Iriitaki ipapiroi-taki Benjamín owaritintsi, anaanakiro okaratzi ipakiriri pasini-payi. Kimosiri ikantaka José itsipatakari iririntzi-payi, irawaijiitaki. ");
INSERT INTO prq_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Ari ikantajiri José inampiri: “Pintitawajiniri oshiki owaritintsi onkarati yaawyiiri ipira, pintitaji-niri aajatzi iiriikiti opaantiki itatiminto. ");
INSERT INTO prq_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Pintitakairi aajatzi opaantiki itiminto iyaapitsi niraminto kiriiki-naki, pintsipataa-kiniri iiriikiti ipinataki-rori owaritintsi.” Imatakiro inampiri José okaratzi ikantaki-riri. ");
INSERT INTO prq_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Okanta okitaiti-tamanaji, ityaantajiri José iririntzi-payi ikyaako-tanaari ipira-payi. ");
INSERT INTO prq_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Tikiramintha intainati ijataji, ikantajiri José inampiri: “Piyaatawa-jiri ananinka-naintsiri, pinkantiri: ‘¿Ipaitama pikositan-tanari, tima naakamiithatimi awiroka? ¿Ipaitama pikositan-tanakarori kiriiki-naki iramintotsi? ");
INSERT INTO prq_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Iriraa-minto onatzi nojiwariti, irootaki iñaawya-tantapiintari. ¡Kaaripirotakimi!’ ” ");
INSERT INTO prq_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Ikanta iyaatawa-jiri inampiri, ikantapaa-kiri okaratzi ikantawa-kiri José. ");
INSERT INTO prq_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Ikantajiitzi irirori: “¿Ipaitama pikantan-tanari? Ti namityaaro naaka pikantaki-nari. ");
INSERT INTO prq_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Tima piñaakina nopjyaaro Owintiniki, noipyaaji-miri kiriiki ikaratzi noñaakiri itita opaantiki notatiminto. ¿Ipaitama nonkosi-tantyaariri iiriikiti pijiwariti aajatzi yooroti? ");
INSERT INTO prq_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Paminiro irira-minto ompiratamiri, aririka piñaakiri itzimi amakironi, iwamaitiriita. Irooma naakapayi ompirataari nonatyii iwankoki pijiwariti.” ");
INSERT INTO prq_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Ikantzi inampina José: “Aritaki nomatakiro pikantakiri. Aririka noñaakiri amakirori iramintotsi, apatziro nompira-tyaari. Iriima pasini-payi tikatsi nonkantiri, ijatajiita.” ");
INSERT INTO prq_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Sintsiini iwayii-tanakiro itiminto, aparo-payi yosiryaa-yitanakiro. ");
INSERT INTO prq_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Tima yoka inampiri José ithonka yaminakiro itiminto-payi, yitanakari itakarori itzimi irojatzi iyaapitsiki. Iñaatziiro otitaka iramintotsi itimintoki Benjamín. ");
INSERT INTO prq_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Isaraa-nakiro iithaari-payi, tima oshiki okatsi-tzimo-siri-tanakiri. Ikyaakaa-najiri aparo-payi ipira, piyanaka nampitsiki. ");
INSERT INTO prq_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Ikanta ariitapaja Judá iwankoki José itsipatakari iririntzi-payi, ainiro isaiki José iwankoki. Ityiirowa-sitapaa-kari, yoiyootapaaka kipatsiki ipinkatha-tziri. ");
INSERT INTO prq_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Ari isampitawajiri José, ikantziri: “¿Ipaitama pantakiri? ¿Tima piyoti noyotziro naaka noñaawya-tantzi?” ");
INSERT INTO prq_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Ikantzi Judá: “¡Pinkatharí! Ti noyoti ipaita nonkantimiri ¿Tsika nonkantyaaka piyotan-tyaari? Apatziro iyotzi Pawa tzimatsirika nokinakaa-sita-kari. Yoka nokarajiitaki aka: naakataki pimpira-tyaa nontsipa-tyaari iñaakoi-takiri piraminto.” ");
INSERT INTO prq_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Ikantanaki José: “Airo omata pikowawitari awiroka. Apatziro nompira-tyaari iñaakoi-takiri niraminto. Irooma awiroka-payi tikatsi nonkantimi, kantatsi pijataji isaiki asitamiri. Tikatsi antawintha-timini.” ");
INSERT INTO prq_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Ikanta Judá itsitoka-paakari okaakiini José, ikantziri: “¡Ñaamisa, Pinkatharí! Nonintzi nonkantimi kapichiini. Ti noninti pinkishina, tima pikimitakari awirokami Faraón. ");
INSERT INTO prq_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Tima pisampi-takina chapinki, pikantakina: ‘¿Tzimatsi asitamiri? ¿Tzimatsi iyaapitsi nirintzi?’ ");
INSERT INTO prq_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Tima nokaman-takimi naaka: ‘¡Jii! Tzimatsi asitanari antari-kona-taintsiri, tzimatsi aajatzi iyaapitsi nirintzi owikaran-tarori itzimi irantyasiparin-kakiini asitanari. Iitako-tani iwiri asitanari, iriitaki owiraan-tarori itzimi pasiniki iina asitanari. Tzimawi-tacha pairani pasini nirintzi, kamaki irirori.’ ");
INSERT INTO prq_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Tima ari pikantana aajatzi: ‘Pamakiri nonintzi noñiiri.’ Tima pinintatzii piñiiri. ");
INSERT INTO prq_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Nokantaiyanakimi naakaiti: ‘¡Pinkatharí! Airo isinitziri asitanari impoki, aririka yookanakiri asitanari, aritaki inkamaki.’ ");
INSERT INTO prq_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Iro kantacha pikantakina awiroka: ‘Airorika pamiri pirintzi, airo okantzi papiitairo piñaajina.’ ");
INSERT INTO prq_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Okanta nojataji pairani, nokaman-tapajiri asitanari okaratzi pikantaki-nari. ");
INSERT INTO prq_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Ipoñaa ikantaana asitanari: ‘Pijati papiitiro pamanantaati kapichiini ayaari.’ ");
INSERT INTO prq_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Nokantana-kiri naaka: ‘Airorika nayiri iyaapitsi nirintzi, airo okantzi nojati. Airorika iyaatana irirori, airo isinitana atziri noñiiri.’ ");
INSERT INTO prq_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Ikantana-kina asitanari: ‘Piyotzi awirokaiti apitimachiini owaiyantaki piniro-thori. ");
INSERT INTO prq_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Aritaki ijapitha-takina aparoni, ti noñaajiri irojatzi iroñaaka. Tima nokantaki: “Omaapiro iwakari katsimari owantachari.” ");
INSERT INTO prq_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Aririka paanajiri pasini notomi, ompaityaa-rika awishi-motakirini, awiroka kantasi-tyaaroni nonkaman-tyaari, airo aajana nantyasiparinka, iro nowasirinka owamaajinani.’ ");
INSERT INTO prq_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","Piñaakiro, oshiki yitakari asitanari iyaapitsi, airorika naanajiri yoka nirintzi mainari, ");
INSERT INTO prq_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","ari inkamaki asitanari. Naakaiti kantasi-tyaaroni inkaman-tyaari, airo aajiri yantyasiparinka, irootaki wamairini iwasirinka. ");
INSERT INTO prq_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Nokantakiri aajatzi asitanari: ‘Naaka kantasi-tyaaroni ompaita-rika awishi-motakirini iyaapitsi. Airorika noipyaajiri nirintzika, naaka pooko-tapiintaji irojatzi nonkama-kotajiri.’ ");
INSERT INTO prq_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Irootaki nokowantari pinkimi-takaan-tina pimpira-tani. Naaka impoyii-tyaarini yoka mainari. Pisinitiri ijataji iyaatana-jiri nirintzi-payi. ");
INSERT INTO prq_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","¿Paitama noñaakapajiriri asitanari airorika naanajiri nirintzi? Tima ti noninti noñiiri iwasiri-waityaa asitanari.” ");
INSERT INTO prq_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Ti yamawitapajiro José kantzimotakariri, ikaimanaki ipiyojiitaka yatziriti, ikantzi: “¡Pisitowawaki maaroni!” Tikatsi aparoni yatziriti saikanain-tsini. Ari ikamantakiri iririntzi-payi, ikantziri: “Naaka pirintzi.” ");
INSERT INTO prq_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Antaro iraanaka. Ikimakiri maaroni Apitantoni-satzi, ikimitzitakari aajatzi saikatsiri iwinkatha-ripankotiki Faraón. ");
INSERT INTO prq_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Ari ikantziri iririntzi-payi: “Naaka José. ¿Irojatzima yañai asitairi?” Antaro itharowanaki iririntzi-payi itsipatakari okaakiini. Ti yakanakiri. ");
INSERT INTO prq_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Aikiro ikantatziiri José: “Pimpoka-jiiti okaakiini.” Ikanta ipokajii-tapaaki, ikantziri: “Naaka José, pirintzi. Naakataki pipimantaki pairani, yamanantakina Apitantoni-satzi. ");
INSERT INTO prq_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Iro kantacha, airo okantzimo-waitami pipimantakina. Tima Pawa ontyaantakinari aka nowawisaakotaji oshiki atziri. ");
INSERT INTO prq_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Aritaki awisaki apiti osarintsi iñaitziro tashitsi nampitsiki. Ainirotatsi 5 osarintsi airo okithotzi pankiwai-rintsi, onkanta-wityaa impanki-witaityaaro. ");
INSERT INTO prq_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Tima iriitaki Pawa kantakaarori nitantakarori nopokaki naka aka, airo yapirotanta piwaiya-nipayi aka kipatsiki. Irootaki piñaantaarori awiroka-payi iroopirori awisako-taantsi. ");
INSERT INTO prq_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Aritaki okantari, iriitaki Pawa amakinari aka, kaari awirokaiti. Irijatzi owakinari nonkamantapiintajiri Faraón inkimi-takayina naakami iriri, nojiwatiri impiratani-payi, nopinkatha-riwintakiri maaroni Apitantoni-satzi. ");
INSERT INTO prq_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Pijatanaki sintsiini asitairiki, pinkantapajiri: ‘Iroka ikantzi pitomi José: “Ipinkatha-ritakaakina Pawa aka Apitantoniki. Pimpokanaki sintsiini, piñiina. ");
INSERT INTO prq_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Pinampitapajyaaro aka Okaakijaariki, pintsipa-tajyaari pitomi-payi aajatzi picharini-payi, ari piwapajiriri pipira-payi, maaroni tzimimo-tzimiri. Ari pintsipatapajyaanari aajatzi naaka. ");
INSERT INTO prq_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Aritaki nompawajimi piyaari awiroka, pitomi-payi, aajatzi ikaratzi saika-panko-tzimiri, airo okowityii-motanta-waitami. Tima ainirotatsi 5 osarintsi intashiniin-taiti.” ’ ");
INSERT INTO prq_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Piñaakina awiroka pitsipatakari aririntzi Benjamín, naakajaantaki ñaawaitzirori iroka ñaantsi. ");
INSERT INTO prq_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Pinkamantapajiri asitairi piñaakina nopinkatha-riwintantzi Apitantoniki. Pinkamantapajiri aajatzi tsika okanta piñaakiro aka. ¡Pisintsitanaki pijati pajaatiri asitairi!” ");
INSERT INTO prq_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Ari yawithanotanakiri José iririntzi Benjamín, oshiki iraawaitaka. Ari ikimitzitakari aajatzi Benjamín oshiki iraawaitaka yawithanotakiri José. ");
INSERT INTO prq_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Ipoñaa inintaporotanakiri José maaroni iririntzi, yawithanotanakiri, oshiki irayimotakari aparo-payi. Okanta awisayitaki iroka-payi, yaripiro-tanaari iririntzi-payi José. ");
INSERT INTO prq_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Okanta anta iwinkatha-ripankotiki Faraón, ikimaitaki ikantaitzi: “Ari yariijiita iririntzi José.” Ari ikimosiritanaki Faraón, ari ikimitakari ikaratzi itsipa-nampitari. ");
INSERT INTO prq_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Ikantzi Faraón: “¡José! Pinkantiri pirintzi-payi inkyaakaa-yitanairi imorani ijatai Owintiniki. ");
INSERT INTO prq_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Yaajatiri asitamiri aajatzi maaroni pishininkapayi. Aritaki nompakiri iroopirori kipatsi aka Apitantoniki. Yanintai-yaaro okaratzi tzimatsiri aka. ");
INSERT INTO prq_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Iroka pinkantiri pirintzi-payi: ¡Iyí! Paanaki siyako-minto-tsipayi tzimatsiri aka Apitantoniki, irootaki paman-tajyaariri iinchii-riki, kooya-payi aajatzi asitairi. Impokajiiti maaroni. ");
INSERT INTO prq_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Airo pitakowaitasitaro okaratzi tzimimo-tzimiri anta, tima okaratzi yashaaran-taita-kari aka Apitantoniki, awirokaitira asitajyaaroni.’ ” ");
INSERT INTO prq_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Imatakiro itomi-payi Israel ikantakiri Faraón. Ipawajiri José siyako-minto-tsipayi. Ipawajiri aajatzi owaritintsi iwanajyaari awotsiki. ");
INSERT INTO prq_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Ipawajiri aajatzi owakira-ripayi kithaarintsi inkithaatanajyaari. Iriima Benjamín ipawajiri 300 ikithoki kiriiki, aajatzi 5 kithaarintsi. ");
INSERT INTO prq_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Ipakaantakiri asitariri ikaratzi 10 mora, ikyaakaa-yitakiniri iroopirori tzimatsiri aka Apitantoniki. Imataki pasini 10 mora kooya, ikyaakaakiro opani pankirintsi, aajatzi pasini owaritintsi, irootaki iyaari asitariri awotsiki, impokana-kirika. ");
INSERT INTO prq_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Iwitha-tawaari José iririntzi-payi ijajiitaji, ikantawajiri: “Ti noninti pinkisa-wakaiyaa awotsiki.” ");
INSERT INTO prq_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Ikanta ipiyajiitaa ipoñaajaro Apitantoniki, irojatzi yariitan-taari Owintiniki isaikira iriri. ");
INSERT INTO prq_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Ikamantapajiri asitariri, ikantapajiri: “¡Apaá, irojatzira yañii iyi José! Ipinkatha-riwintantzi irirori Apitantoniki.” Tikatsi inkantanaki asitariri, ti inkimisanta-wityaari ikantziriri. ");
INSERT INTO prq_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Aikiro ikamantatziiri okaratzi ikantawakiriri José. Iñaawakitziiro siyako-minto-tsipayi okaratzi ityaan-takaantakiri José isiyako-tantanakyaari, antaro ikimosiritanaji. ");
INSERT INTO prq_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Ikantanaki: “¡Nokimaki ainiro yañii notomi José! Ontzimatyii nojati noñaapajiri tikira nokamana-kiita.” ");
INSERT INTO prq_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Ari ijatanaki Israel, yaanakiro maaroni tzimimo-tziriri. Ikanta iwiraaka Kantapiro-jaariki, ipomitapa-jiniri yatsipitakaani Iwawani iririni. ");
INSERT INTO prq_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Okanta otsitinitanaki iñaanatakiri Pawa imisiriki Israel, ikantajiri: “¡Jacob!” Ari yakanaki irirori, ikantzi: “Ipaitaka Pawá” ");
INSERT INTO prq_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Ikantziri: “Naaka Pawa, Iwawani pirini. Airo pitharowa-waitzi pijati Apitantoniki, aritaki noshikyaa-kimiri anta inkarati pincharini-tajyaari. ");
INSERT INTO prq_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Aritaki ankarati anta Apitantoniki, tima naaka oipyaajirini apaata picharini-payi isaikawi-takyaa anta. Tima iriitaki pitomi, José tsipatyaamini apaata pinkama-jirika anta.” ");
INSERT INTO prq_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Ikanta yawisaki Jacob isaikawitapaaka Kantapiro-jaariki. Titanaka siyakominto-tsiki ityaantakiri Faraón aakitiri, itsipatakari iinchii-riki aajatzi kooya-payi. ");
INSERT INTO prq_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Ari ikaratzi yaanakiri ipira-payi, aajatzi okaratzi tzimimotakiriri Owintiniki. Jataki Jacob Apitantoniki itsipatakari ishininka-payi okaakiini irirori. ");
INSERT INTO prq_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","Ari ikaratzi yaanakiri maaroni itomi-payi irirori, irisinto-payi, icharini-payi, aajatzi irisaro-payi, maaroni. ");
INSERT INTO prq_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Tima tikira yariityaa Jacob Apitantoniki, ityaantakiri Judá inkantiri José: “Inintatzii apaa pimonthai-yaari Okaakijaariki.” Ikanta yariijiitaka Jacob Okaakijaariki, ");
INSERT INTO prq_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","ikantanakiri José impiratani-payi: “Piwitsikinaro nosiyako-minto, pamakinaro.” Jatanaki José imonthaa-wajyaari asitariri Okaakijaariki. Ikanta iñaawajiri iriri, yawithanotawajiri, antaro iirayimotawaari. ");
INSERT INTO prq_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Ari ikantakiri Israel itomi: “¡José! Kantatsi iroñaaka nonkami, tima noñaaporotajimi, ainiro pañii!” ");
INSERT INTO prq_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Ari ikantanakiri José iririntzi-payi aajatzi icharini-payi iriri, ikantziri: “Ari pisaika-jiitawaki aka, nonkamantawakiri Faraón, nonkantiri: ‘Ariitaka nirintzi-payi, itsipatakari icharini-payi asitanari, ipoñaayitakaro Owintiniki, ipokajii-tatzii intsipatapajyaana naaka. ");
INSERT INTO prq_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Yamayitakiri ipira-payi, maaroni tzimimo-tziriri irirori. Tima irootaki yamijiitari iriroriiti yaamaakowintari ipira-payi.’ ");
INSERT INTO prq_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Aririka inkaimakimi Faraón isampitimi, inkantimi: ‘¿Ipaita pantawai-ritari pinampiki?’, ");
INSERT INTO prq_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","pinkanta-jiiti awiroka: ‘Apatziro namijiitari naamaakowintari nopira, nosiyakotari ikantayita pairani nocharinini.’ Aritaki pimatakiro pinampityaaro Okaakijaariki. Tima ti inintziri Apitantoni-satzi intsipatyaari aamaakowin-tariri ipira-payi.” ");
INSERT INTO prq_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Jataki José ikamantziri Faraón, ikantakiri: “Ariitaka asitanari ipoñaakaro Owintiniki. Tima saikapaaki Okaakijaariki, itsipayitakari nirintzi-payi, yamayitakiri ipira-payi, aajatzi okaratzi tzimimo-yitziriri iriroripayi.” ");
INSERT INTO prq_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Ari iyoyaaki José 5 iririntzi, yamakiri isaiki Faraón iñiiri. ");
INSERT INTO prq_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Ikanta Faraón isampitawakiri iririntzi-payi José, ikantziri: “¿Ipaitama pantawaititari awiroka-payi?” Ikantajiitzi irirori: “¡Nowinkatharití! Pirawairintzi nonajiitzi naaka, nosiyakotari tsika ikanta pairani nocharinini.” ");
INSERT INTO prq_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Ikantzitanaka aajatzi: “¡Pinkatharí! Nopokatzii nonampityaaro aka, tima antaro okantaka tashitsi Owintiniki, tikatsi iwajyaa nopira-payi. Irootaki nonintantari pisinitina nonampityaaro Okaakijaariki.” ");
INSERT INTO prq_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Irootaki ikantantanakari Faraón ikantziri José: “Tima pokaki piri aajatzi pirintzi-payi intsipa-tajyaami. ");
INSERT INTO prq_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Tima maaroni kipatsi okaratzi tzimatsiri Apitantoniki, awirokataki aminakaan-tzirori. Piñaakiri Okaakijaari, ari inampityaaro irirori-payi, tima oshiki okamiithataki kipatsi anta, tikatsi siyaaroni. Tzimatsi-rika pishininka yotzirori yaamaakowintari ipiraitari, pinkantiri yaamaakowintyaanari nopira-payi naaka.” ");
INSERT INTO prq_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Ari yayitanakari aajatzi José asitariri iñiiri Faraón. Iwithatapaakari Jacob pinkathari Faraón. ");
INSERT INTO prq_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Isampitawakiri Faraón, ikantziri: “¿Tsikama okaratzika tzimain-tsiri pisarintsiti?” ");
INSERT INTO prq_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Ikantzi Jacob: “Tzimaki 130 nosarintsiti nokinakinataki tsikarika-payi. Tikira noñaamaitaro naaka ontzimi oshiki nosarintsiti ikimiyitaka nocharinini. Iro kantacha noñaamaitakaro kowiinka-yitatsiri.” ");
INSERT INTO prq_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Ikanta iwithatanaari Jacob pinkathari Faraón, ipiyapithatanaari. ");
INSERT INTO prq_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Ari ipakiri José ishininka-payi iroopirori kipatsi anta Apitantoniki, ari inampijiitakaro, imatakiro ikantakiriri Faraón. Ari okanta otzimantakari iipatsiti iriri aajatzi iririntzi-payi ipaitai-tziro ‘Itomyaani Ooryaatsiri’. ");
INSERT INTO prq_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Tima aikiro ipatziiri José iyaari iriri, iririntzi-payi aajatzi maaroni ishininka-payi, ipiri okaratzi kowityii-moyi-tariri. ");
INSERT INTO prq_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Ari ikaimakiri Jacob maaroni itomi-payi, ikantakiri: “¡Notomí! Pimpoka-jiiti okaakiini, tima nonkaman-tatyiimiro onkarati awishimo-timiri apaata. ");
INSERT INTO prq_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","¡Itomi-payi Jacob! Pimpoka-jiiti okaakiini pinkiman-tyaari. Pinkimisantiri asitamiri Israel. ");
INSERT INTO prq_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Awiroka Rubén, nojiwari notomi, Nosintsinka nowimi, tima awirokataki jiwatapain-tsiri, Awiroka itakaro ipinkathai-tzimi, otzimimo-tzimi piñaapironka. ");
INSERT INTO prq_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Ari okaratapaaki piriipirotzi, tima pikimi-tapiinta-witaro osinchaatzi nijaa. Okantakaaro piwinka-tharyaa-kinaro nomaa-minto, piman-takanaro notsipatari. ");
INSERT INTO prq_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Awiroka Simeón aajatzi Leví, pirintzi piwawakaa-jiita, Tima piwamaa-minto piwayitajiro pichakopiti. ");
INSERT INTO prq_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Airo notsipa-taami tsika papato-tapiinta. Tima oshiki otyaanakami pairani pimasirinka, piwamaaki oshiki atziri. Oshiki pisamasiryaakari, pikaraa-kitzi-yitanakiri ipira. ");
INSERT INTO prq_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Kowiinka okantanaka piyatsimanka, Tima omaapiro pikisanaka. Naaka oiwaraa-jimini, pinampi-tajyaaro tsika aakotajiro iwairo Jacob, Tima nonasiyi-tajyaari pincharini-tajyaari anta tsika impaitaitiro Israel. ");
INSERT INTO prq_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Irooma awiroka Judá, kantakaapiro iwajimi pirintzi-payi. Pairika-kintsiyi-tajiri inkarati kisaniin-timini. Ipinkatha-yitajimi pirintzi-tajyaari. ");
INSERT INTO prq_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Awiroka notomi, Judá, pikimityaari yanini kashikari inkara-takiro iwari yatsikani. Inaryaa-waita kipatsiki, yoiyoota ikimi-takotari antari kashikari. ¿Ipaitama matironi iñaasirinkajiri? ");
INSERT INTO prq_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","¡Notomí! ¡Judá! Ari intzimaji pincharini-tajyaari, irasi iwiro impinkatha-riwintanti, Tikatsi aapitha-tajirini iwinkatha-riminto yairikakiri, Irojatzi impokan-tajyaari asipiro-tyaaroni iwinkatha-riminto, Iriitaki inkimisan-tawajiri nasiyitachari ishininka-tawakaa. ");
INSERT INTO prq_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Iriitaki oosotako-tirini ipira anta oponkitziki pankirintsi imiritaitari, Ikiwantyaaro iithaari imiritaitari, tima oshiki-piro-tatzii chochoki. ");
INSERT INTO prq_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Tima kamiithaaki ikantaka, anaanakiro ochiinkaatzi imiritaitari. Kitamaaro okantayita iraiki anaanakiro okitamaarotzi oyaaki thomitsi. ");
INSERT INTO prq_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Iriima Zabulón inampi-tajyaaro inkaari-thapyaaki, Tsika aatapiintaji amaatako-mintotsi. Tsika anta owiraa-thapi-tajyaa Simaaki. ");
INSERT INTO prq_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Iriima Isacar inkimi-tajyaari sintsiri ipiraitari ikyaakai-tziri, Iriitaki otyiirowa-piintachani ikyaapiintaitzi airo inintzi yaniitaji. ");
INSERT INTO prq_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Ikanta iñaawakiro kamiitha okantanaka nampitsi, kamiitha imakoryaa-waitaitzi, Oiyootanaka yanatakaitiri. Tima mairi ikantaka ikimi-takai-takari ompirataari. ");
INSERT INTO prq_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Iriima Dan iwakowin-tajiri ishininka, Ikimitaakiro pasini-payi ipinkatha-riwin-tajiri ishininka-payi Israel-iiti. ");
INSERT INTO prq_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Inkimi-tajyaari Dan maranki isaiki awotsi-nampi, Iriitaki atsika-kitairini ikyaakoitari, Iwaryaa-maityaari kyaakotariri. ");
INSERT INTO prq_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","¡Pawá! Nawintaami awiroka piwawisaako-tajina. ");
INSERT INTO prq_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Yoka Gad, oshiki imaimani-tajiri owayiri-payi. Iro kantacha, aritaki pipiya-takyaari. ");
INSERT INTO prq_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Yoka Aser, oshiki-tzimo-tajiri iwankiri iwajyaari, Iroopirori owaritintsi onatyii, onkimi-tajyaaro iwariti pinkatha-ripirori. ");
INSERT INTO prq_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Yoka Neftalí, inkimi-tajyaari maniro tikatsi asitako-waitirini, Owaniinka ikantayitya iwaiyani. ");
INSERT INTO prq_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Yoka José, ikimitaro pankirintsi oshooka-thapyaa-tziro nijaa. Oshiki okithonitzi, Ithonka atiiyi-takiro otanto nampitsi. ");
INSERT INTO prq_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Oshiki ikisaniin-tajiri asiwinthatarori piyaamini, Imanatantaro chakopi, Yasi iwiro iñaasirinkai-tziri. ");
INSERT INTO prq_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Tima yoka José sintsishimpa ikantaka irirori, Oisokiro iwakiro ipyaamini. Ikamintha Iwawani Jacob Sintsi-pirori, Okamintha iwairo aamaakowin-tantaniri, kisakowin-tariri Israel. ");
INSERT INTO prq_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Inkamintha Iwawani piri, iriitaki nisironka-tajimini. Iriitaki Pawa Sintsi-pirori, tasonka-wintajimini. Opoñaaro itasonka-wintani jinoki inkitiki. Opoñaaro itasonka-wintani inthopoyaaki inkaariki. Opoñaaro itasonka-wintani owaaki thomitsiki aajatzi yamaarin-tsiki. ");
INSERT INTO prq_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Tima okaratzi iyomitaanajamiri piri intasonka-wintantai-tyaamiri, Anaanakiro okaratzi iyomitaakinari asitanari naaka. Airo othonkaa, irojatzi apaata ompyaan-tajyaari otzisi. Osiyawai-takaro osaika-patziito-tantyaarimi José iroka-payi yomitaantsi, Tima iriitaki iyoshitaikiri ikarajiitaki iririntzi-payi, iriitaki iriipiro-taatsini. ");
INSERT INTO prq_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Yoka Benjamín, inkimi-tajyaari atsikan-taniri. Yananinka iwawai-tamanaja yatsikani, Okanta oshiityaaki yanti-tawakaari tzimaaran-tapaintsiri.” ");
INSERT INTO prq_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Iriitaki itomi-payi Israel, tsika impoñiiyaa inkarati 12 nasitachani ishininka-tawakaa-jiita. Irootaki iroka ñaantsi-payi ikaminaa-kiriri iriri intasonka-wintaitan-tyaariri aparo-payi ikarajiitakira. ");
INSERT INTO prq_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Ikantakiri itomi-payi: “Kapichiini-tapaaki nonkaman-tyaari. Nonintzi nontsipa-tajyaari nocharinini, pinki-tataina anta impiritanakiki iwaniki Efrón ishininka Tharowan-taari-nisatzi. ");
INSERT INTO prq_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","Ipaitai-tziro anta Apitinaki, yaminakoi-tziri isitowa-piintzi ooryaatsiri, anta Yiinkantomasi Owintiniki. Tima irootaki yamanan-takiri pairani acharinini Abraham itsipataakiro iwani Efrón, aajatzi irasi Tharowan-taari-satzi tsika okitataaja iina. ");
INSERT INTO prq_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Tima ari ikitai-takiri nocharinini Abraham itsipataaro iinani Sara, aajatzi nirini Isaac itsipataaro asitanarini Rebeca. Aritaki noki-tatairori aajatzi naaka noinani Lea. ");
INSERT INTO prq_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Tima ironta kipatsi aajatzi omoronaki anta, iriitaki ishininka Tharowan-taari-satzi piman-taki-niriri pairani acharinini.” ");
INSERT INTO prq_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Ikanta ithonkakiro Jacob iyomiyi-tanajiri itomi-payi, onaryaanaka, kamanaki. Jataki itsipa-siri-tapaajari icharinipayi. ");
INSERT INTO prq_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Tima kamaji irirori Jacob, ari ikinkithasiri-jiitanaka itomipayi Jacob, ikanta-wakaajiita: “Kimitaka ari inkisaniin-tanakai iroñaaka José, ari impiyawin-tajyaa okaratzi awaaripiro-waitakiri pairani.” ");
INSERT INTO prq_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Irootaki ityaantantakari kantirini José: “Pinkimi okaratzi ikantaki piri tikira ikamiita, tima ikantaki: ");
INSERT INTO prq_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","‘Pinkowakotiri Jose’, pinkantiri: “Paapatyaajiri pirintzipayi, pimaisantiro iwaaripirowaitakimi, tima oshiki ikimaantsitakaawaitakimi.” Irootaki nokowantari paapatyaajyaari pirintzipayi, tima iriitzitaka impiratani Iwawani asitamiri.” Tima iraacha irirori José ikinkitha-waitakairira ityaan-kani iririntzi-payi. ");
INSERT INTO prq_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Irojatzi yariitan-tapaa-kari iririntzi-payi José, ityiirowa-sitapaa-kari, yoiyoo-tapaaka kipatsiki, ikantapaakiri: “Naakayitaki pimpira-tani.” ");
INSERT INTO prq_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Ari ikantzi José: “Airo pitharowan-tawaitana iyí. ¿Naakama Pawa? ");
INSERT INTO prq_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Tima pininta-jiiwitaka pairani awiroka piwaaripiro-tinami, iro kantacha iyotzimai-takaro Pawa okaratzi kaaripiro-tatsiri pantawi-takari, ikantakaakaro irirori kamiitha okantzimo-tantaa. Tima okaratzi awishimowi-takanari naaka, irootaki añaantaarori iroñaaka yawisako-yitaji oshiki atziri. ");
INSERT INTO prq_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Airo pitharowan-tawaitana. Aritaki nompayi-takimi piyaari awiroka, aajatzi piwaiya-nipayi.” Irootaki ikantakiri José ikinkitha-waitakaakiri kamiitha iririntzi-payi, inimo-takaajiri. ");
INSERT INTO prq_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Irojatzi inampijiitaro José anta Apitantoniki, aajatzi maaroni icharini-payi iriri. Tima okaratzi 110 osarintsi yañaaki José. ");
INSERT INTO prq_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Iñaayi-tanajiri icharini-payi itomi-payi irirori Efraín. Iñaanajiri aajatzi itomi-payi Maquir. Yoka Maquir, iriitaki itomi Manasés pasini itomi José. ");
INSERT INTO prq_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Okanta apaata, ikantakiri José iririntzi-payi: “Oyotapaaka kapichiini nonkaman-tyaari, iro kantacha awotsikitaki Pawa inisironka-tajimi, imisitowa-yitaimi pisaika-witaka iroñaaka aka nampitsiki, imisaikajimi pasiniki kipatsi ikasiyakaa-kiriri pairani acharinini Abraham, Isaac aajatzi asitairini.” ");
INSERT INTO prq_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Aikiro ikantana-kitziiri José iririntzi-payi, ikantziri: “Imapirotatyaa, aritaki impokaki Pawa inisironka-tajimi. Iro kantacha, nonintzi pinkanta-pirotina awiroka-payi. Paanajinaro apaata notonki-poroki.” ");
INSERT INTO prq_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Ari ikamajiri irirori José anta Apitantoniki, okaratzi 110 isarintsiti. Itziritai-takiri yiinkantsi iwathaki, iwakoi-takiri.");
INSERT INTO prq_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Okanta apaata, kamaji irirori José, iririntzi-payi, aajatzi ikaratzi itsipatakari ipokajiitaki pairani. ");
INSERT INTO prq_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","Iro kantacha aikiro ijatatzii ishikijiitzi irirori Israel-iiti, tikatsi kantirini. Tima ithonka inampitan-takaro maaroni Apitantoniki. ");
INSERT INTO prq_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Okanta apaata tzimaji Apitantoniki owakirari pinkathari, titzimaita inkimakotiri José okaratzi yantakiri inampiki. Iriitaki kantapaa-kiriri ishininka-payi Apitantoniki, ikantziri: ");
INSERT INTO prq_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","“¡Ashininká! Oshikitaki Israel-iiti anampiki, iriipiro ikantajiitaka, tima yanaanakai arokaiti. ");
INSERT INTO prq_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Ontzimatyii amini tsika ankinakairo airo ishikitanta, aamaiyaa ontzima-minthati owayiritaantsi, ari yaapatyaa-wakyaari ikaratzi kisaniintairi, impithoka-sitanakai arokaiti, aritaki ijayitaji isaikajiiwitakani anampiki.” ");
INSERT INTO prq_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Ari yitanakaro Apitantoni-satzi imapiro-tziri impira-waitari Israel-iiti, iwitsika-kaakiri apiti nampitsi, ipaitai-tziro “Manchakironi” pasini ipaitai-tziro “Itomyaani Ooryaatsiri”. Irootaki iwaaranta-pankoti pinkathari Faraón. Oshiki ikimaatsi-waitakaa-kari Israel-iiti impira-yitakari, iwayitaki aminayi-tirini tsika yantawai-takairi. ");
INSERT INTO prq_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Tima imapiro-witai-tatyaari Israel-iiti ikimaatsi-takaitari, aikiro ishikitatzii irirori. Tima itharowakaantatyaari Apitantoni-satzi yokaiti Israel-iiti. ");
INSERT INTO prq_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","Aikiro imapiro-wita-tyaari Apitantoni-satzi impira-waitari Israel-iiti. ");
INSERT INTO prq_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","Antaro iwatsimaakiri Israel-iiti impira-waitai-takari, yaakowin-takaro itaakaitziri kipatsi iwitsikan-taityaarori iwanko-payi, aajatzi yantawai-takai-tziri owaantsiki. Tima oshiki ikimaatsi-takaayi-takari. ");
INSERT INTO prq_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Ikanta pinkatha-ritatsiri Apitantoniki ikinkitha-waitakaakiro Sifra aajatzi Fúa, tima irootaki aminirori kooya-payi Heber-iiti owaiyantzi, ikantakiro: ");
INSERT INTO prq_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","“Paminiro kooya-payi Heber-iiti aririka owaiyan-tayiti. Iriirika sirampari tzimatsini, piwamairi. Iroorika kooya airo piwamairo.” ");
INSERT INTO prq_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Titzimaita antiro kooya-payi ikantawi-takarori pinkatha-ritatsiri Apitantoniki. Tima pinkatha owiri iroori Pawa, ti owamaayitiri sirampari iinchaaniki. ");
INSERT INTO prq_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Irootaki ikaimakaan-tantakarori pinkatha-ritatsiri Apitantoniki, ikantakiro: “¿Ipaita kaari piwamaantari sirampari iinchaaniki?” ");
INSERT INTO prq_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Okantajiitzi iroori: “¡Pinkatharí! Tima ñaapiro onajiitzi kooya Heber-iiti, ti onkimi-tyaaro Apitantoni-sato, tikira nariityaa naminiro owaiyanti, aritaki tzimaanitaki.” ");
INSERT INTO prq_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","Irootaki inisironka-tantakarori Pawa kooya-payi aminirori Heber-iiti otzimaa-niyitzi. Ari okanta ishiki-piro-tanta-kari Heber-iiti, tima aikiro ijatatzii otzimimo-tziri isintsinka. ");
INSERT INTO prq_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","Tima okimisantziri Pawa iroori kooya-payi aminirori owaiyan-tayitzi Israel-iiti, irootaki ishikyaan-takanirori owaiyani-payi iroori. ");
INSERT INTO prq_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Ikanta Faraón, ikantajiri ishininka-payi Apitantoniki, ikantziri: “¡Pinkimi Noshininka-payi! Pookiri nijaaki maaroni sirampari owaiyani Heber-iiti, iroorika kooya airo pookayi-tziro iroori, añaayiti.” ");
INSERT INTO prq_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Ikanta aparoni ishininka Leví-iti yaaki iina. Tima iroka iina irojatzi ishininka Leví-iti. ");
INSERT INTO prq_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Ari itzimaki otomi. Tima kamiithaa-niki ikanta iinchaaniki. Irootaki omananta-kariri iriniro. Tima mawa kasiri omanawi-takari. ");
INSERT INTO prq_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Tima ti onkantapaji omaniri iinchaaniti, aaki tsiwoo owitsiñaantakaro pitsi. Otitakiri iinchaaniti, owamaata-kotakiri osimpina-thapyaataki nijaa. ");
INSERT INTO prq_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Ari otyaan-kakiro iritsiro iinchaaniki, okatziyaka intyaatsikaini aminako-wintiri opaita-rika awishimo-tirini iinchaaniki. ");
INSERT INTO prq_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Ari ojataki nijaaki irisinto Faraón okaata. Kinawai-tapaaki ompiritatani-payi nijaa-thapyaaki. Oñaatziiro irisinto Faraón anta tsiwoo osiimpina-thapyaataki nijaa, okaimakiro ompiratani, okantziro: “Pimpoki, pamakiro tsiwoo amaataintsiri nijaaki.” ");
INSERT INTO prq_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Okanta asitaryaa-wakiro tsiwoo, oñaatziiri ititaka iinchaaniki, ayimatakiri ishinka. Oshiki itako-siri-tanakari iroori, okantanaki: “Iriinchaaniti inatzi Heber-iiti yoka.” ");
INSERT INTO prq_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Ari okantanaki iritsiro iinchaaniki, okantziro irisinto Faraón: “¿Ti pininti nonkaimimi noshininka thotaimirini iinchaaniki?” ");
INSERT INTO prq_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Okantzi irisinto Faraón: “Jii, nonintzi. Pijati pinkaimaiti.” Jatanaki mainaro, okaimapain-tziro iriniro iinchaaniki. ");
INSERT INTO prq_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Okanta opokapaaki okantawakiro: “¡Kooyá! Paanakiri yoka iinchaaniki pikimotatakainari, aritaki nompina-takimi.” Aanajiri iriniro iinchaaniki, okimotatakaajiri. ");
INSERT INTO prq_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Ikanta ikimotataki iinchaaniki, opajiro irisinto Faraón. Okimita-kaan-tari iriirikami owaiyani iroori, irootaki owaitakaan-tziriri “Aajaawiri” tima onkanta-jiitzii iroori: “Nijaaki naakiri”. Tima iroka wairontsi Aajaawiri, irootaki ikantziri iñaaniki irirori “Moisés”. ");
INSERT INTO prq_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Ikanta yantari-piro-tanaki Moisés, jataki yariitari ishininka-payi, iñaapaa-tziiri oshiki yantawai-takayi-tziri. Imonthaa-kotantaka ishininka Moisés ipasawai-tziri Apitantoni-satzi. ");
INSERT INTO prq_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Ithonka yaminanaki tikatsi-rika ñiirini, iwakiri Apitantoni-satzi, ikitata-nakiri impanikiitiki. ");
INSERT INTO prq_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Okanta okitaiti-tamanaji yapiitakiro ijataji, iñaapaa-tziiri yanta-wakaa-jiita ishininka irirori. Ikantziri antanta-tsiri: “¡Ashininká! ¿Ipaita piwatsinaa-waitantariri ashininkatari?” ");
INSERT INTO prq_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Ari yakanaki, ikantzi: “¿Ipaitama owakimiri awiroka pimpira-tyaana? ¿Pikowatziima piwina, pikimitaakiri chapinki Apitantoni-satzi?” Ikanta ikimawaki Moisés, antaroiti itharowanaki, isiyakaantzi iyotakoi-takiri iwakiri chapinki Apitantoni-satzi. ");
INSERT INTO prq_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Ari ikimaki irirori Faraón, inintanaki iwiri Moisés. Irootaki isiyantakari Moisés ikinanakiro Maimaniwiniki. Ari inintzi inampityaaro anta. Thointapaaka ikaapiin-taitzi nijaa. ");
INSERT INTO prq_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Tima anta Maimaniwiniki ari inampitarori antyawiyari ipaita Reuel, tzimatsi 7 irisinto irirori. Ari ojajiitaki iroori ayi nijaa irajiitiri ipirapayi asitarori. ");
INSERT INTO prq_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Ari ipokajii-tapaaki ikaratzi aamaakowin-tariri ipira-payi anta, ithañaa-pitha-takaro ayimi nijaa. Irootaki ijatantanakari Moisés inkisako-wintyaaro, yaapaaki irirori nijaa ipakiri nijaa opira-payi. ");
INSERT INTO prq_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Okanta opiyajiitaja mainaro-payi owankoki, isampita-wajiro asitarori: “¿Ikatzimaitaka pipiyapaaka?” ");
INSERT INTO prq_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Okantajiitzi iroori: “¡Apaá! Noñaaki Apitantoni-satzi anta, iriitaki kisakowin-takanari ithañaa-pitha-tanaro nijaa aamaakowin-tariri ipira-payi anta. Iriitaki kitatakinarori nijaa, yoitakiri apira-payi.” ");
INSERT INTO prq_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Ari ikantanaki Reuel: “¿Tsika iroñaaka irirori? ¿Pinkaimiri impoki iyaa. Ipaitama pookanta-nakariri?” ");
INSERT INTO prq_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Ari okanta isaikan-tapaa-kari Moisés iwankoki Reuel. Okanta apaata yoka Reuel, ipakiri Moisés irisinto, opaita Séfora, iinantakaro. ");
INSERT INTO prq_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Ari owaiyan-takiri itomi, ikantanaki Moisés: “Pasini-satzi nonatzii naaka aka, kaari nonampi.” Irootaki owaitakaan-tziriri itomi “Pasini-satzi”, tima iroka wairontsi Pasini-satzi, irootaki ikantai-tziri iñaaniki irirori “Gersón”. ");
INSERT INTO prq_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Okanta apaata kamaji pinkatha-riwi-tachari Apitantoniki. Aikiro ikaminthaajiitatyaa Israel-iiti tima omapiro isintsiwin-taitziri yantawai-takai-tziri. Irootaki ikimanta-kariri Pawa jinoki iwasiri-waijiitaka. ");
INSERT INTO prq_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Tima ikimakiri ikaminthaajiitsi, osiriki iwakiro Pawa ikasiyakaa-kiriri pairani Abraham, Isaac, aajatzi Jacob. ");
INSERT INTO prq_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Tima iñiiri Pawa maaroni Israel-iiti, iyota-kotziri okaratzi awishimo-yitziriri. ");
INSERT INTO prq_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Iriitaki Moisés aamaako-wintakariri ipira-payi irikonkiri, ipaitai-tziri Jetro. Antyawiyari inatzi anta Maimani-winiki. Ikanta yaanakiri Moisés ipira-payi otzisi-masiki yaminakairi iyaari. Yariitaka ipaitai-tziro Mamirii-toni, irootaki itzi-siti Pawa. ");
INSERT INTO prq_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Ari iñaaka-kari anta Imaninkariti Pawa ipaamatzimo-takiri. Ikanta yamina-piro-tanaki Moisés, iñaatziiro kitoochii-masi opaamatsi, titzimaita onkarati omoriki. ");
INSERT INTO prq_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Ari ikanta-siri-tanaki Moisés: “Intsityaa naminawakiro okaakiini kaari othonkanta omoriki, ti noñaapiintiro kimityaaroni.” ");
INSERT INTO prq_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Ikanta iñaakiri Pawa ipokanaki Moisés yaminiro okaakiini, ñaawaitanaki omorikaki kitoochii-masi, okantziri: “¡Moisés!” Akanaki Moisés, ikantzi: “¿Paitaa?” ");
INSERT INTO prq_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Ikantzi Pawa: “Airo pitsitokaro okaakiini morikain-tsiri. Paakonta-tasityaa, tima pikatziyan-tatyaaro tasorintsi-patha-tatsiri.” ");
INSERT INTO prq_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Aikiro ikantana-kitzii Pawa: “Naakataki Iwawani picharini-payi, Iwawani Abraham, Isaac, aajatzi Jacob.” Ari itzikaa-poro-tanaka Moisés, tima itharowan-tana-kityaari Pawa yamina-porotiri. ");
INSERT INTO prq_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Aikiro iñaanata-naki-tziiri Pawa, ikantziri: “¡Moisés! Noñaakiri ikimaatsi-waita ikaratzi nasitari naaka saikatsiri Apitantoniki. Nokimakiri ikaminthaakaari aminayi-tziriri yantawai-jiitzini. Noñaakiri yasinonkaa-waita. ");
INSERT INTO prq_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","Tima irootaki nopokan-takari kipatsiki, nookakaa-wintajiri yasiwita-kari Apitanto-nisatzi. Nomisitowajiri, naajiri pasiniki kipatsi posini-patha-tatsiri, kimoi-patha-tatsiri, tsika oshookapaji oshiki pankirintsi, aajatzi tsika itzimapaji oshiki ipiraitari. Tima irootaki inampitsi-witari iroñaaka Owintini-satzi, Tharowan-taari-nisatzi, Tonkaarisatzi, Nampitsi-wini-satzi, Thaantiwinisatzi aajatzi Kayaawinisatzi. ");
INSERT INTO prq_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","¡Moisés! Nokimakiniri ikaminthaajiitani Israel-iiti, noñaakiri aajatzi Apitanto-nisatzi oshiki ikimaatsi-takaa-waita-kari. ");
INSERT INTO prq_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Ontzimatyii pijati Apitantoniki tsika ipinkatharitzi Faraón, pimisitowajiri impira-waitaitari Israel-iiti, nasitari naaka.” ");
INSERT INTO prq_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Ikantanaki Moisés: “Ti niriipiroti naaka nojatasi-tantyaariri Faraón, nomisitowajiri noshininka-payi isaiki Apitantoniki.” ");
INSERT INTO prq_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Ikantzi Pawa: “Aritaki ankarati, iroka piyotant-yaari naakataki otyaantzimiri: Aririka pimisitowa-yitajiri ikaratzi nasitari naaka isaiki Apitantoniki, aritaki pimpinkatha-tajinari maaroni awirokaiti aka tonkaariki.” ");
INSERT INTO prq_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Ikantzi Moisés: “¡Pawá! Tzimatsi pomirintsi-tzimo-tanari aririka nojawitakyaa, nonkantapaakiri Israel-iiti: ‘Naaka ityaantani Iwawani acharinini.’ Aririka isampita-nakina, inkantina: ‘¿Tsikama ipaitaka irirori?’ ¿Ipaitama nonkantiriri naaka?” ");
INSERT INTO prq_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Ari yakanaki Pawa, ikantzi: “NAAKATAKI NAAKATA-PIINTA-TSIRI.” Aikiro ikantana-kitzii Pawa: “Iroka pinkantiriri Israel-iiti: ‘Yoka paitachari NAAKATAKI, iriitaki tyaanta-kinari nopokantari noñiimi awirokaiti.’ ” ");
INSERT INTO prq_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Aikiro iñaawai-tana-kitzii Pawa ikantziri Moisés: “Pinkantiri pishininka Israel-iiti: ‘Iroka ikantzi Awinkathariti, Iwawani acharini Abraham, Isaac, Jacob, iriitaki otyaantanari noñiimi awirokaiti.’ Tima asi owaatyiiro nowairo. Ari impaitainari apaata pishininkapayi aajatzi inkarati incharinitajyaari apaata irirori. ");
INSERT INTO prq_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","Pijati, papatotiri antari-konapayi Israel-iiti, pinkantiri: ‘¡Ashininká! Iñaakaana Awinkathariti, Iwawani acharini, Iwawani Abraham, Isaac, Jacob, ikamanta-kinaro tsika pikanta iñaakimi ikimaatsi-takaa-waitaitami Apitantoniki. ");
INSERT INTO prq_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","Jiiroka pasini ikantakinari: “Aritaki nookakaa-wintajimi ikimaatsi-takaitakami Apitantoniki, nomisaikajimi inampiitiki icharinini Owintini-satzi, Tharowan-taari-nisatzi, Tonkaarisatzi, Nampitsi-wini-satzi, Thaantiwinisatzi, aajatzi Kayaawinisatzi, tsika oshookapaji oshiki pankirintsi, aajatzi tsika itzimapaji oshiki ipiraitari.” ’ ");
INSERT INTO prq_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","Aririka piwintha-takaa-kyaari antari-konapayi, iriitaki pintsipa-tanakyaa pijatasitiri pinkathari Apitantoniki, pinkantapaakiri: ‘¡Pinkatharí! Iñaakaana Pawa, Iwawani noshininka-payi Heber-iiti. Ontzimatyii naniijiiti onkarati mawa kitaitiri, nojati otzisi-masiki nompomi-tajiniri natsipi-takaani Nowinkathariti Pawa.’ ");
INSERT INTO prq_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Noyomaitaka naaka, airo isinitzimi pijati pinkatha-ritatsiri Apitantoniki. Ontzimatyii nosintsiwintiri naaka. ");
INSERT INTO prq_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Iro kantacha, aritaki noñaaka-kimiro nosintsinka, nowamai oshiki Apitanto-nisatzi. Aririka iñaakiro onkarati nantiri inampiitiki, ari isinitaimi pinkathari Faraón pijataji. ");
INSERT INTO prq_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","Naaka kantakai-yaarini Apitanto-nisatzi impasitan-tawa-jyaariri opaita-rikapayi pishininka-payi aririka ijajiitaji, tima airo ijataimpikiwaitasitanaja. ");
INSERT INTO prq_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Tima onthonka onkampi-tanajiro kooya osaika-nampi-tziri, onkampi-tanajiro otsipata-piintari, ompayita-wajiro ooro, kiriiki, aajatzi kithaarin-tsipayi. Irootaki pinkithaa-tiriri piwaiya-nipayi, tima paapitha-tanajiri maaroni iwaararo Apitanto-nisatzi.” ");
INSERT INTO prq_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Ari ikantanaki Moisés: “¡Pawá! Airo imatziro nonkantiriri, oshiki impiyatha-tyaana. Apatziro inkanta-jiitina: ‘¡Moisés! Ti iñaakaiyaami Pawa.’ ” ");
INSERT INTO prq_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Yapiita-nakiri Pawa, ikantziri: “¡Moisés! ¿Ipaitama pairikakiri pakoki?” Ikantzi Moisés: “Nokotziki.” ");
INSERT INTO prq_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","Ikantzi Pawa: “Intsityaa pookiro osaawiki.” Yookakiro Moisés ikotzikiiri. Ari opyaana-kari maranki. Isiya-pitha-tanakaro ikotziki iñaakiro opyaana-kara maranki. ");
INSERT INTO prq_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Ikantzi Pawa: “Pairikiri ipatziki.” Imatakiri Moisés yairikakiri, aajatzi opyaanajaro ikotzikiiri. ");
INSERT INTO prq_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","Ikantzi Pawa: “Piñaakiro. Irootaki iyotantai-tyaari omaapiro noñaakakami, tima naaka Iwawani picharini Abraham, Isaac, aajatzi Jacob.” ");
INSERT INTO prq_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Ipoñaa ikantanakiri aajatzi Pawa: “¡Moisés! Pisati-wakotyaa pichokitariki.” Imatakiro Moisés, iñaatziiro irako ithonka opathaanaki, kitamaaro-wako ikantanaka, okimiwai-takaro okitamaarotzi jiriniki. ");
INSERT INTO prq_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Ikantzi Pawa: “Papiitajiro pisati-wako-tajyaa.” Yapiitakiro Moisés isati-wakotanaja. Isitanaji iwathaaro, okimitanaaro tsika ikanta maaroni iwathaki. ");
INSERT INTO prq_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Ikantzi Pawa: “Airorika ikimisan-taitzimi iñaawitai-takyaaro pitakyaari piñaakantiri, aritaki inkimisan-taitakimi aririka iñaitakiro pasini piñaakantiri. ");
INSERT INTO prq_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Airorika ikimisan-taitzimi piñaakan-tawi-takyaaro iroka apiti kaari iñaapiin-taitzi, paaki kapichiini nijaa, pisakotiro osaawiki. Aritaki onkimita-nakyaaro iraantsi.” ");
INSERT INTO prq_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Ikantzi Moisés: “¡Ñaamisa, Pinkatharí! Oshiki opomirintsi-tzimotana noñaawaiti, tima ari nokantzita pairani, aajatzi iroñaaka piñaana-tantakanari pimpira-tyaana. Tima oshiki noninta-piintawita nonkinkitha-waitimi, oshiki nokisowaantitzi noñaawai-tirika.” ");
INSERT INTO prq_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Ari ikantzi Pawa: “¡Moisés! ¿Ipaitama opayitakiriri atziri-payi iñaani? ¿Kaarima naaka kisowaanti-takairiri, atsikimpitya-takairiri, mawityaaki-takairiri aajatzi? ¿Kaarima naaka aminakaa-yitziriri aajatzi? ");
INSERT INTO prq_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Ontzimatyii pijati, aritaki noyomitaakimi tsika pinkantiri, naaka tsipatyaamini.” ");
INSERT INTO prq_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Aikiro ikantana-kitzii Moisés: “¡Ñaamisa, Pinkatharí! Pintyaanti pasini atziri.” ");
INSERT INTO prq_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Ari ikisatha-tanakiri Pawa yoka Moisés, ikantanakiri: “Aritaki isaikiri anta pirintzi Aarón, ishininka Leví-iti. Iyotziro iñaawaitzi kamiitha irirori. Pokaki imonthai-yaami, antaro inkimo-siriti aririka iñaawajimi. ");
INSERT INTO prq_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Tima awiroka kamantirini onkarati inkinkitha-takaantiri, ari nosaikitzityaari naaka nontsipatyaami, ari noyomitaa-kimiro onkarati pantiri. ");
INSERT INTO prq_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","Irootaki inkaman-tiriri Aarón maaroni atziripayi onkarati pikanta-kiriri awiroka. Tima onkarati pinkaman-tiriri Aarón onkimiwai-tyaaro naakami Pawa ñaanatirini atziripayi. ");
INSERT INTO prq_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Iroka pikotzikiiri pairikiri, irootaki pimatan-tyaarori kaari iñaapiin-taitzi.” ");
INSERT INTO prq_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Ari ipiyaaja Moisés iwankoki irikonkiri Jetro, ikantapajiri: “¡Kokí! Irootaintsi nojataji Apitantoniki tsika isaiki noshininka-payi. Nonintzi noñiiri ainiro-rika yañaayitzi.” Ikantzi Jetro: “Pimatiro ñotzí, onkamintha tikatsi awishimo-timini.” ");
INSERT INTO prq_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Tima ikantzi-takari Pawa yoka Moisés isaikantari Maimani-winiki, ikantakiri: “¡Moisés! Pimpiyi Apitantoniki, tima kamaji kowawita-chari iwimi.” ");
INSERT INTO prq_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Tima yaanajiro iina Moisés itsipataa-najiri itomi-payi, ikyaako-takaanaari ipira-payi, piyaaja Apitantoniki. Tima ti yookani iwiro ikotzikiiri Pawa. ");
INSERT INTO prq_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Ikanta Moisés itsipatari Aarón jataki ikinkitha-waitakairi Faraón, ikantapaakiri: “¡Pinkatharí! Pinkimiro iñaani Pawa, Iwawani Israel, ikantzimi: ‘Pisinitiri atziri nasitari naaka ijataji otzisi-masiki yoimosirinkajina.’ ” ");
INSERT INTO prq_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Ari yakanaki Faraón, ikantanaki: “¿Itzimika Pawa nonkimisantiri nosinitan-tyaariri pishininka-payi ijataji? Ti noyotiri tsika itzimi Pawatatsiri, airo nosinitziri ijataji pishininka-payi.” ");
INSERT INTO prq_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Ari ikantajiitzi irirori: “¡Pinkatharí! Iñaakaana Iwawani noshininka Heber-iiti. Ontzimatyii nojajiitini, onkarati mawa kitaitiri nariitan-tyaari otzisi-masiki. Ari nompomi-tajiniriri natsipi-takaani Nowawani, airo aantana mantsiya-rintsi, airo iwisai-tantana.” ");
INSERT INTO prq_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Ari yakanaki iwinkathariti Apitanto-nisatzi, ikantzi: “¡Moisés! ¡Aarón! ¿Ipaitama piwashaan-takaantyaariri yantawairi pishininka-payi? Ikantawa-kaajiita, ontzimatyii yantawaiti.” ");
INSERT INTO prq_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Aikiro ikantana-kitzii Faraón: “Oshiki pishininka Israel-iiti aka nampitsiki. ¿Kamiitha-tatsima piwashaan-takairi yantawairi?” ");
INSERT INTO prq_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Tima intsipayiini Faraón iyomitaakiri ikaratzi aminiriri Israel-iiti, jiwayitzirori antawai-rintsi, ikantziri: ");
INSERT INTO prq_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","“Aritapaaki pipakiri katarosi owitsika-yitzirori kisonakiri kipatsi, ijati irirori yayi katarosi. ");
INSERT INTO prq_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Pisintsiwin-tzimai-tyaari pinkantiri: ‘Ti nonintzi piwitsiki kapichiini, tima nonintatzii piwitsiki tsika okaratzi piwitsika-piintziri.’ Tima ipirata-jiitatyaani, irootaki ikaiman-tajiitari, ikantzi: ‘¡Thamiwí. Ampomita-jiniri atsipita-kaani Awawani!’ ");
INSERT INTO prq_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Pishikyaa-piro-tiniri yantawairi, airo pisinitziri isaikasi-waityaa. Airo ikimisanta-waitziro thaiyaan-tsipayi ñaantsi.” ");
INSERT INTO prq_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Jataki aminiriri Israel-iiti, jiwatakaan-tzirori antawai-rintsi, ikantapaakiri: “Pinkimi ikantakinari Faraón: ‘Tima airo nopayitajimi katarosi. ");
INSERT INTO prq_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Awiroka jatatsini payi. Iro kantacha ontzimatyii piwitsiki kisonakiri kipatsi okaratzi piwitsika-piintziri.’ ” ");
INSERT INTO prq_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Ithonka ikinayi-tanaki Israel-iiti tsika-rikapayi anta Apitantoniki, yaminaminatzi katarosi. ");
INSERT INTO prq_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Ari ikantapiin-tana-kityaa iwayitakiri Faraón isintsiwin-tantzi iwitsiki kisonakiri kipatsi okaratzi iwitsika-piintziri Israel-iiti. ");
INSERT INTO prq_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Tima oshiki ipasawai-taikiri Israel-iiti iwakiri Faraón ijiwatiri ishininka-payi, ikantziri: “¿Ipaita kaari pimonkara-tantaro okaratzi piwitsika-piintziri? Ti pimatiro chapinki, aajatzi iroñaaka.” ");
INSERT INTO prq_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Jaitijiitaki jiwatziriri Israel-iiti, ikantapaakiri Faraón: “¡Pinkatharí! ¿Ipaita piwasinonkaan-tariri patziriti? ");
INSERT INTO prq_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Tima ti impai-tajina katarosi, aikiro isintsiwin-tatyaana, ikantana: ‘Piwitsiki oshiki kisonakiri kipatsi.’ Ipasatzimai-taitana. Iri kantakaan-tzirori pinampiri-payi.” ");
INSERT INTO prq_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Ikantanaki Faraón: “Tima pipirata-jiitatyaa awiroka. Irootaki pikantantari: ‘¡Ajatiwí. Ampomita-jiniri atsipita-kaani Awawani!’ ");
INSERT INTO prq_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Pimpiyanaki, pantawai-jiitini. Onkanta-wityaa airo ipaitzimi katarosi, ontzimatyii piwitsiki kisonakiri kipatsi okaratzi piwitsika-piintziri.” ");
INSERT INTO prq_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Oshiki opomirintsi-tzimo-tanakari Israel-iiti jiwatziriri ishininka-payi yantawaiti, isintsiwin-taitziri irirori iwitsiki kisonakiri kipatsi okaratzi iwitsika-piintziri kitaitiriki. ");
INSERT INTO prq_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Iro isitowa-naki-tzii ikinkitha-waitakairi Faraón, iñaapaakiri Moisés aajatzi Aarón iyaawin-takari. ");
INSERT INTO prq_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","Ikantapaakiri: “Iriitaki Awawani owasankitaa-winti-mironi okaratzi pantakiri. Awiroka kantakaan-takiro ikisa-siri-tantairi Faraón aajatzi inampiri. Okimiwai-takaro awiroka opakinirimi ipathaka-minto iwantairi.” ");
INSERT INTO prq_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Ari yamananaki Moisés, ikantzi: “¡Asitanarí! ¿Ipaita piwasankitaan-tariri pasitari awiroka? ¿Ipaitama pityaan-tantakanari nopokan-takari noñiiri? ");
INSERT INTO prq_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Tima iwasankitaa-waitanakiri Faraón noshininka-payi noñaawin-tapaa-kiniri piwairo, tikatsi-maita panti pookakaa-wintan-tajyaariri pasitari awiroka.” ");
INSERT INTO prq_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Yakanakiri Pawa, ikantziri: “¡Moisés! Piñiiri nosintsiwintiri naaka Faraón isinitantajyaamiri pisitowaji inampiki, iriitaki sintsiwin-tajimini aajatzi awirokaiti pijataji.” ");
INSERT INTO prq_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Aikiro ikantana-kitziiri Pawa: “Tima naaka Pawa. ");
INSERT INTO prq_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Naaka oñaakakariri pairani Abraham, Isaac, Jacob, nokaman-takiri nowairo, nokantakiri: ‘Naaka Pawa Sintsi-pirori’, titzimaita nonkamantiri nowairo-pirori, nopaita ‘Naakataki.’ ");
INSERT INTO prq_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Tima tzimatsi nokasiya-kaakiriri irirori-payi, nonintaki inampita-jyaaro Owintiniki tsika ikimita-kaantai-takiri pasini-satziiti inatzii. ");
INSERT INTO prq_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Noyotzitaka aajatzi oshiki ikimaatsi-waitaka Israel-iiti, isintsiwinta-waitakiri Apitanto-nisatzi yantawai-takairi. Tima osiri nowiro nokasiya-kaakiriri. ");
INSERT INTO prq_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","Irootaki pinkantan-tyaariri Israel-iiti, pinkantiri: ‘Pinkimi ikantzimi Pawa: “Naaka Pawa, aritaki nookakaa-wintajimi isintsiwin-tzimi yantawai-takaimi Apitanto-nisatzi. Ari piñaakiro nosintsinka, kamiitha nowawisaa-koyi-tajimi nonkisa-wintajyaami. ");
INSERT INTO prq_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Naaka asitajyaamini, naaka Piwawani-tajyaa. Ari onkantyaa piyotan-tajyaari naakataki Piwawani, naaka ookakaa-wintajimiri impira-waitami Apitanto-nisatzi. ");
INSERT INTO prq_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Naajimi nampitsiki nokasiya-kaakiriri pairani picharini Abraham, Isaac, Jacob. Irootaki nompajimiri, pasitajyaaro. Naakataki Pawa.” ’ ” ");
INSERT INTO prq_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Irootaki yapiitakiri Moisés ikamantziri ishininka-payi, titzimaita inkimisanta-jiitini, tima antaroiti okantzi-motakari isintsiwin-taitziri yantawaiti. ");
INSERT INTO prq_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Ari yapiitajiro Pawa ikantairi Moisés: ");
INSERT INTO prq_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","“Pijati pinkantiri Faraón pinkatha-ritatsiri Apitantoniki, isinitiri ijataji pishininka-payi isaikawaitakira iipatsitiki.” ");
INSERT INTO prq_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Ari ikantanaki Moisés: “¡Pawá! Ti ininti inkimisantina noshininka-payi. Iri mapirotzirori Faraón airo ikimisantana, tima ti noyoti noñaawaiti kamiithaini.” ");
INSERT INTO prq_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Ari iñaanatajiri Pawa yoka Moisés, ikantairi: “¡Moisés! Naaka kantakai-yaaroni inkimita-kaan-tantyaamiri Faraón awirokami pawa. Iriima pirintzi Aarón, iriitaki pinkimi-takaantiri kamantan-tironi piñaani. ");
INSERT INTO prq_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Tima awiroka kamantirini Aarón onkarati nonkantimiri, iwawisayi-maityaaniri irirori Faraón isinitan-tajyaariri pishininka-payi isitowaji inampiki. ");
INSERT INTO prq_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Iro kantacha oshiki nonkiso-siri-takairi Faraón. Irojatzi noñaakan-tantyaarori kaari iñaapiin-taitzi Apitantoniki. ");
INSERT INTO prq_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","Airo ikimimaitami Faraón. Iro kantacha aritaki noñaakajiri nosintsinka maaroni Apitanto-nisatzi. Tima kamiitha nonkisa-wintaiyaari pishininka Israel-iiti, nasitari naaka, nokimita-kaari nowayiriti. Aritaki naayitajiri maaroni isaikawai-witaka Apitantoniki. ");
INSERT INTO prq_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Aririka noñaakan-takiro nosintsinka Apitantoniki, aririka naajiri pishininka Israel-iiti anta, aripaiti iyoti Apitanto-nisatzi naaka Pawa.” ");
INSERT INTO prq_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Imatakiro Moisés aajatzi Aarón okaratzi ikantakiriri Pawa. ");
INSERT INTO prq_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Tima tzimaki Moisés okaratzi 80 isarintsiti ikinkitha-waitakaan-takariri Faraón. Iriima Aarón tzimaki irirori okaratzi 83 isarintsiti. ");
INSERT INTO prq_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Ari yapiitajiro Pawa iñaanatairi Moisés aajatzi Aarón, ikantziri: ");
INSERT INTO prq_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","“Aririka inkantakimi Faraón: ‘Intsityaa piñaakaina kaari iñaapiin-taitzi,’ pinkan-tanakiri awiroka Aarón: ‘Pookiro pikotzikiiri ikatziyaka Faraón ompiyaari maranki.’ ” ");
INSERT INTO prq_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Jataki Moisés aajatzi Aarón iñiiri Faraón, imatakiro ikantakiriri Pawa. Yookakiro ikotzikiiri Aarón tsika ikatziyaka Faraón itsipayi-takari inampiri, opyaana-kari maranki ikotzikiiri. ");
INSERT INTO prq_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Ari ikaimakaan-takiri irirori Faraón yotaniri-payi aajatzi antyawiyari-payi Apitanto-nisatzi. Imawita-paakaro irirori-payi. ");
INSERT INTO prq_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Yookapaakiro ikotzikiiri aparo-payi irirori, opyaana-kari maranki. Iro kantacha ikotzikiiri Aarón oniyakiri irasi yokapayi yotaniri. ");
INSERT INTO prq_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Titzimaita inkimisanti Faraón, aikiro ikiso-siri-tana-kitzii. Tima mataka ikantzi-takari Pawa. ");
INSERT INTO prq_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Ari yapiitajiro Pawa ikantairi Moisés: “Oshiki ikiso-siritaki Faraón, ti isinitiri ijataji pishininka-payi. ");
INSERT INTO prq_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Pananinka-sitiri Faraón ijata-manaji irirori nijaaki. Pimonthai-yaari nijaa-thapyaaki pairikakiro pikotzikiiri pyaakariri maranki. ");
INSERT INTO prq_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","Pinkantiri: ‘¡Pinkatharí! Tima ityaanta-witakana Pawa, Iwawani Heber-iiti, nonkaman-timiro iñaani ikantzimi: “Pisinitiri nasitari naaka ijataji otzisi-masiki impinkatha-tajina.” Iro kantacha titzimaita pinkimi awiroka, oshiki pipiyathataka. ");
INSERT INTO prq_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Irootaki ikantan-takari aajatzi Pawa: “Iroka piyotan-tyaanari naaka Pawa.” Piñaakina nairikakiro nokotzikiiri, irootaki nomposan-tyaarori nijaa, aritaki ompyaana-kyaaro iraantsi. ");
INSERT INTO prq_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Ari yapirotakyaa inkami maaroni nijaa-wiri, osityaati nijaa. Tima oshiki impinki-matiro Apitanto-nisatzi aririka irajiitiro.’ ” ");
INSERT INTO prq_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Ikantanakiri Pawa yoka Moisés: “Pinkantiri pirintzi Aarón iwaankiro ikotzikiiri tsika otzimayitzi nijaa, inkaari, tsika oonka-naayita, tsika iwapithaan-taitaro Apitantoniki, tima apirotatyiiyaa ompiyaa iraantsi okaratzi tzimayi-tatsiri inchato-naaki aajatzi mapinakiki, maaroni.” ");
INSERT INTO prq_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Tima imatakiro Moisés aajatzi Aarón okaratzi ikantakiriri Pawa. Iñaakakiri Faraón itsipata-kari inampiri-payi, iposan-takaro ikotzikiiri nijaa, apirotaka opyaanakaro iraantsi okaratzi tzimatsiri anta. ");
INSERT INTO prq_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Apirotaka ikamayitaki maaroni nijaa-wiri, ithonka osityaataki nijaa, ti onkamiithati irirajiro Apitanto-nisatzi. Apirotaka iraantsitaki maaroni nijaa anta Apitantoniki. ");
INSERT INTO prq_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Iro kantacha imatakiro aajatzi yantyawiyari-tipayi Apitanto-nisatzi okaratzi yantakiri Moisés. Irootaki ikiso-siri-tantari Faraón, ti inkimisanti, tima mataka ikantzi-takari Pawa. ");
INSERT INTO prq_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Piyaaja irirori Faraón iwankoki, apatziro onimowai-tziri, ti onkantzi-motyaari okaratzi iñaawita-kari. ");
INSERT INTO prq_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Tima ikiyako-jiitakini othapyaaki nijaa maaroni Apitanto-nisatzi inintzi yayi kitijaari nijaa, irootaki iriri, tima ti onkamiithati irajiro antaraani. ");
INSERT INTO prq_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Ari maakotaki okaratzi 7 kitaitiri ipyaan-takaajarori Pawa iroka nijaa iraantsi. ");
INSERT INTO prq_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Ari yapiitajiro Pawa ikantairi Moisés: “Pijati isaikira Faraón, pinkantiri: ‘Ikantzi Pawa: “Pisinitiri ikaratzi nasitari naaka ijati impinkatha-tajina. ");
INSERT INTO prq_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Airorika pisinita-jiitziri, aritaki nowasankitaan-takyaamiri mashiro-payi maaroni piipatsitiki. ");
INSERT INTO prq_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Ari intzimaki oshiki mashiro nijaaki, inkyaayiti piwankoki, aajatzi tsika pimaapiintzi. Tima inthonka inkyaapaaki iwankoki pinampiri-payi, aajatzi iwankoki maaroni pishininka. Ari inkyaayitaki pitasi-mintoki, piyowitzitikipayi, maaroni. ");
INSERT INTO prq_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Inthonka yatiita-paakimi mashiro-payi, aajatzi inkimitaa-paakiri maaroni pishininka-payi. Imatakiri pinampiri-payi aajatzi.” ’ ” ");
INSERT INTO prq_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Ipoñaa ikantanakiri Pawa Moisés: “Pinkantiri Aarón iwaankiro ikotzikiiri tsika otzimayitzi nijaa, tsika iwapithaan-taitaro aajatzi. Ari impoñiiyaari mashiro-payi iñiitiri Apitantoniki.” ");
INSERT INTO prq_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Ari iwaanka-nakiro Aarón ikotzikiiri tsika otzimayitzi nijaaki anta Apitantoniki. Tima tonkaapaaki oshiki mashiro, ithonkantapaakaro nampitsi anta Apitantoniki. ");
INSERT INTO prq_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Iro kantacha imatzitakaro antyawiyari-payi, itonkakaaki yantyawiyarin-kakiini irirori oshiki mashiro anta Apitantoniki. ");
INSERT INTO prq_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Irootaki ikaimakaan-tantakariri Faraón impoki Moisés aajatzi Aarón, ikantawakiri: “Pinkowa-kotairi Pawa impyaajiri mashiro-payi ikaratzi oñaasirinka-kinari naaka aajatzi noshininka-payi. Aritaki nosinitakiri pishininka-payi ijati impomita-jiniri yatsipi-takaani Piwawani.” ");
INSERT INTO prq_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Ari yakanakiri Moisés pinkathari Faraón, ikantziri: “Pinkantina tsika-paiti pinintzi namanako-tajimi awiroka, pinampiri-payi aajatzi pishininka-payi, airo iñaasirinkan-taami mashiro-payi piwankoki, apatziro isaiki nijaaki.” ");
INSERT INTO prq_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","Ikantzi Faraón: “Onkitaiti-tamanaji.” Ikantzi Moisés: “Aritaki omatakyaa okaratzi pinintakiri, irootaki piyotan-tyaari tikatsi pasini monkara-tyaarini Nowawani. ");
INSERT INTO prq_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Tima airo itzimanaji mashiro-payi piwankoki, aajatzi iwankoki pinampiri-payi, imatakyaa iwankoki pishininka-payi, apatziro isaikayiti nijaaki.” ");
INSERT INTO prq_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Ikanta ipiyaaja Moisés aajatzi Aarón ipoñaajaro iwankoki Faraón. Ari yamananaki Moisés ikowako-tziri Pawa impyaajiri mashiro-payi ikaratzi oñaasirinka-kiriri Faraón. ");
INSERT INTO prq_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","Imatakiro Pawa okaratzi inintakiri Moisés. Ithonka ikamanaki mashiro-payi kyaintsiri pankotsiki, piyotain-chari okaankiityiira pankotsi, aajatzi owaantsi-kipayi. ");
INSERT INTO prq_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Tima ithonka ipiyota-kaan-taitakiri mashiro ikaratzi kamaintsiri, sitziin-kamasitaki. ");
INSERT INTO prq_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Tima tikatsi kantzimo-tana-jyaarini Faraón, kamiitha isaikanaji. Ari yapiita-najiro ikiso-siri-tanaji, ti yantiro ikantawi-taitariri, mataka okaratzi ikantzi-takari Pawa. ");
INSERT INTO prq_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Ari yapiitajiro Pawa ikantairi Moisés: “Pinkantiri pirintzi Aarón: ‘Piwaankiro pikotzikiiri, pimposhiro kipatsi-pani, tima irootaki pyaanain-chani tsiito, inthonka iñaitiri maaroni Apitantoniki.’ ” ");
INSERT INTO prq_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Tima imatakiro Aarón okaratzi ikantai-takiriri. Iwaankakiro ikotzikiiri, iposan-takaro kipatsi-pani, pyaanaka tsiito. Iriitaki oshikita-naintsiri maaroni Apitantoniki. Tima ithonka iñaasirinka-paakiri atziri-payi aajatzi ipiraitari-payi. ");
INSERT INTO prq_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Ari imawitakaro aajatzi antyawiyari-payi impyiiri tsiito yantyawiyarin-kakiini, titzimaita imatiro. Tima oshiki ikantanaka ini atziri-payi aajatzi ipira-payi. ");
INSERT INTO prq_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Ikantawi-takari antyawiyari-payi pinkathari Faraón, ikantziri: “Okaratzi piñaakiri, Pawa kantakaaro.” Titzimaita inkimi Faraón ikantawi-taitariri, tima mataka okaratzi ikantzi-takari Pawa. ");
INSERT INTO prq_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Ari yapiitajiro Pawa ikantairi Moisés: “Pananinka-sitiri onkitaiti-tamanaji Faraón ijata-manaji nijaaki, pinkantiri: ‘Iroka ikantzi Pawa: “Pisinitiri ijataji nasitari naaka impinkatha-tajina. ");
INSERT INTO prq_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Tima airorika pisinitziri ijati, aritaki nontyaantaki oshiki nasitachani simpoki-payi, iriitaki oñaasirinka-paakimini piwankoki, iwankoki pinampiri-payi aajatzi iwankoki maaroni pishininka-payi. Inthonkairo maaroni iipatsiti tsika inampiyitaro. ");
INSERT INTO prq_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","Airomaita itzimi simpoki-payi Okaakijaariki tsika isaiki Israel-iiti, ikaratzi nasitari naaka. Tima irootaki piyotan-tyaari naaka Pawa asitarori kipatsi. ");
INSERT INTO prq_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Tima naaka ookakaa-wintairini maaroni nasitari naaka, ikaratzi pasiwita-kari awiroka. Onkitaiti-tamanaji omatyaa iroka.” ’ ” ");
INSERT INTO prq_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Tima imatakiro Pawa okaratzi ikantakiri, pokapaaki oshiki simpoki iwankoki Faraón, iwankoki inampiri-payi, aajatzi iwankoki ishininka-payi, ithonkantapaakaro maaroni Apitantoni. Tima ithonka iyaaripiro-tantapaaki yokapayi simpoki. ");
INSERT INTO prq_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Irootaki ikaiman-takariri Faraón yoka Moisés aajatzi Aarón, ikantakiri: “Kantatsi pijati pimpomi-tajiniri patsipi-takaani Piwawani, iro kantacha airo pawishiro tsika owiraa nampitsi.” ");
INSERT INTO prq_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Ari ikantzi Moisés: “Ti onimotina pikantanari, tima piwinkani onatzii aririka nompomi-tiniri Nowawani. Aririka nomatakiro iwinkani Apitanto-nisatzi, aritaki iwa-wintakinaro. ");
INSERT INTO prq_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Ontzimatyii nojajiitini, tima onkarati mawa kitaitiri naniiti otzisi-masiki, nompomi-tajiniri natsipi-takaani Nowawani, nantajiro okaratzi ikantanari irirori.” ");
INSERT INTO prq_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Ikantzi Faraón: “Aritaki nosinitakimi pijati pimpomi-tajiniri patsipi-takaani Piwawani anta otzisi-masiki, airomaita pijapirotzi intaina. Pamanakotina aajatzi naaka.” ");
INSERT INTO prq_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Ikantzi Moisés: “¡Pinkathari! Aririka nositowanaji nokinkitha-waitakayimi, aritaki nonkowa-kotakiri Pawa impyaajiri onkitaiti-tamanaji yokapayi nasiyita-chari simpoki ikaratzi oñaasirinka-kimiri awiroka, pinampiri-payi aajatzi pishininka-payi. Onkamintha airo papiitziro pamatawitina, pinthañiiyaari noshininka-payi ijati impomita-jiniri yatsipi-takaani Nowawani.” ");
INSERT INTO prq_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Ari isitowanaji Moisés ikinkitha-waitakairi iwankoki Faraón, yamanairi Pawa. ");
INSERT INTO prq_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","Imatakiro Pawa okaratzi ikowakiri Moisés. Pyaanaja simpoki-payi ikaratzi oñaasirinka-kiriri Faraón, inampiri-payi aajatzi maaroni ishininka-payi, tikatsi aparoni tzimaaran-tanain-tsini. ");
INSERT INTO prq_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Iro kantacha Faraón, yapiita-najiro ikiso-siri-waitzi, ti inkimisanti ikantai-tziriri, ti isinitiri ijataji Israel-iiti. ");
INSERT INTO prq_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Ikanta Pawa yapiitajiri Moisés ikantairi: “Pijati piñiiri pinkathari Faraón, pinkantiri: ‘Ikantzi Pawa, Iwawani Heber-iiti: “Pisinitiri ikaratzi nasitari naaka, ijati impinkatha-taina. ");
INSERT INTO prq_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Tima airorika pisinitziri ijataji, irojatzi-rika pinthañiiyaari, ");
INSERT INTO prq_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","aritaki nowasankitaan-takyaamiro kowiinkapirotatsiri mantsiya-rintsi, irootaki apirota-jirini ikaratzi pipiratari piwaniki, ikyaakoi-taripayi, maaroni. ");
INSERT INTO prq_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Iriima ipira-payi Israel-iiti, airo ikamaraantzi aparoni. Tima nonasita-jyaari ikaratzi yasitari Israel-iiti, aajatzi irasi Apitantoni-satzi.” ’ ” ");
INSERT INTO prq_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Ari yookotaki Pawa kitaitiri, ikantaki: “Onkitaiti-tamanaji nomatiro okaratzi nokantakiri.” ");
INSERT INTO prq_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Okanta okitaiti-tamanaji, imatakiro Pawa okaratzi ikantakiri. Yapirotaka ikamaki ipira-payi Apitanto-nisatzi, iriima irasi Israel-iiti ti inkami aparoni. ");
INSERT INTO prq_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Ari isampita-kowin-takiri Faraón ipira-payi Israel-iiti, ikimatzii ikantaitzi: “Ti inkami aparoni.” Iro kantacha Faraón, aikiro ikiso-siri-tana-kitzii, ti isinitiri ijataji Israel-iiti. ");
INSERT INTO prq_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Ari yapiitajiro Pawa ikantairi Moisés aajatzi Aarón, ikantziri: “Pawiijiiti pakoki samampo, iri Moisés ñaakairini Faraón yooka-wanitiro jinoki. ");
INSERT INTO prq_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Irootaki oshikita-naintsini iroka samampo maaroni Apitantoniki. Irootaki pathaakaa-yitirini maaroni Apitanto-nisatzi aajatzi ipiraitari-payi.” ");
INSERT INTO prq_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Imatakiro Aarón aajatzi Moisés, yaanaki osamampoti paamari, jataki isaikira Faraón. Yooka-wani-takiro Moisés samampo jinoki. Irootaki opoñaan-tanakari ipathaa-waiyi-tanaki maaroni atziri-payi aajatzi ikimita-nakari ipiraitari-payi. ");
INSERT INTO prq_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Ti imatanajiro antyawiyari-payi imatiro yantakiri Moisés, tima ithonka ipathaa-waiyi-tanaki irirori, ikimita-nakari tsika ikantayi-tanaka maaroni Apitanto-nisatzi. ");
INSERT INTO prq_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Iro kantacha, ikantakaaro Pawa aikiro ikiso-siri-tatzii Faraón, ti ininti inkimiro ikantai-tziriri, monkarataka ikantzi-takariri Pawa pairani Moisés. ");
INSERT INTO prq_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Ipoñaa yapiitajiri Pawa ikantairi Moisés: “Pananinki onkitaiti-tamanaji piñiiri Faraón, pinkantiri: ‘Ikantzi Pawa, Iwawani Heber-iiti: “Pisinitiri ijataji ikaratzi nasitari naaka, impinkatha-tajina. ");
INSERT INTO prq_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Tima nontyaan-katyii iroñaaka oshiki mantsiya-rintsi patsipi-tyaari awiroka, pinampiri-payi, aajatzi maaroni pishininka-payi. Irootaki piyotan-tyaari tikatsi pasini kimityaanani naaka aka kipatsiki. ");
INSERT INTO prq_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Tima iroñaaka nowasankitaan-tyaamiro awiroka mantsiya-rintsi, aajatzi nonkimitaakiri maaroni pishininka-payi, tima kamaityaantsi pinkan-tajyaa aka kipatsiki. ");
INSERT INTO prq_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Omapiro-tatyaa, tima naaka kantakaaro pañaayiti, irootaki iyotantai-tyaanari otzimi-motana naaka nosintsinka, ari onkantyaa inkinkithata-koitan-tajyaanari naaka maaroni kipatsiki. ");
INSERT INTO prq_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Tima ari piñaawi-takaro kantain-chari, aikiro pithañaa-tyaari ikaratzi nasitari naaka, ti pisinitiri ijayitaji ");
INSERT INTO prq_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Tima onkitaiti-tamanaji, onkimityaaro iroñaaka iwiraaka ooryaatsiri, ari piñaakiro omparyii jiriniki, ti iñaitiro pairani aka Apitantoniki kimityaaroni iroka, omapokakimi iroñaaka. ");
INSERT INTO prq_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Ontzimatyii pintyaanti aajatirini pipira-payi, aajatzi maaroni tzimatsiri piwaniki. Tima aririka omparyaa-paaki jiriniki, onthonka owamaapaakiri atziri-payi, aajatzi ipiraitari-payi kaari saikatsini pankotsiki.” ’ ” ");
INSERT INTO prq_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Tima tzimatsi aparo-payi inampiri Faraón pinkatha-tana-kiriri Pawa ikimakiro ikantakiri, yamayitajiri impiratani aajatzi ipira-payi iwankoki. ");
INSERT INTO prq_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Iriima ikaratzi piyatha-tarori iñaani Pawa, ti yamajiri iwankoki impiratani aajatzi ipira-payi. ");
INSERT INTO prq_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Ari yapiitajiri Pawa ikantajiri Moisés: “Piwaanka-wakotyaa inkitiki, omparyiita Apitantoniki jiriniki, apirotiri atziri, ipira-payi aajatzi maaroni iwankiri Apitanto-nisatzi.” ");
INSERT INTO prq_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Ari itzinaa-wako-tanaka Moisés inkitiki yairikakiro ikotzikiiri, ikantakaakaro Pawa ookathatyaa. Ithonka ojiriniki-tanaki maaroni Apitantoniki. ");
INSERT INTO prq_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","Tima matanaka ojiriniki-tanaki, okonowakaro jiriniki ookatha-rontsi. Omaapiro okowiinkataki, ti iñaapiin-taitiro pairani Apitantoniki siyaaroni iroka. ");
INSERT INTO prq_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Tima ithonka owaaripiro-tapaakiro jiriniki iipatsiti Apitanto-nisatzi. Omatakiri maaroni atziri-payi, aajatzi ipiraitari-payi. Omatakiro owaaripiro-takiro pankirin-tsipayi shookatsiri owaantsiki, ochiworyaa-yitanakiro inchato-payi tzimatsiri nampitsiki. ");
INSERT INTO prq_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Irooma anta Okaakijaariki tsika inampijiitaro Israel-iiti, ti iñaitiro omparyii jiriniki. ");
INSERT INTO prq_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Ari ikaimakaan-tajiri Faraón yoka Moisés aajatzi Aarón, ikantairi: “Nokaaripirotaki naaka. Tima kamiithari inatzi irirori Pawa. Irooma naaka aajatzi maaroni nonampina-payi, kaari-pirori nonajiitzini. ");
INSERT INTO prq_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Pamaniri Pawa onkarata-jiita ookatha-rontsi, aajatzi jiriniki. Aritaki nosinitakimi pijayitaji, airo nothañaa-naami.” ");
INSERT INTO prq_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Ari yakanaki Moisés ikantanakiri: “Aririka noñaakiro nojapitha-tajiro pinampi, ari nowaanka-wako-tasi-tajyaari Pawa namanajiri. Aritaki onkarata-paaki ookathataka aajatzi jiriniki, irootaki piyotan-tyaari irasi Pawa onatzii iroka kipatsi. ");
INSERT INTO prq_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Iro kantacha noyotzi naaka, tikiramaita pimpinkathatiri awiroka Pawa, ari ikimita-kari aajatzi pinampiri-payi.” ");
INSERT INTO prq_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","Tima apirotaka okamaki pankirintsi okaratzi paiki-ryaawi-tainchari, okaratzi aajatzi tyaakiwi-tainchari. ");
INSERT INTO prq_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Iro kantacha, titzimaita onkamayiti okaratzi osamani-yitatsiri oshooka-yitzi. ");
INSERT INTO prq_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Ikanta ijataki Moisés ikinkitha-waitakairi iwankoki Faraón, itzinaa-wako-tanaja yamanairi Pawa. Awisain-katanaki jiriniki, ti omparyaanaji inkani, ti ookatha-tanajyaa. ");
INSERT INTO prq_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Ikanta iñaakiro Faraón ti omparyaanaji inkani, awisanaki jiriniki, ti ookatha-tanajyaa, ari ikaaripiro-tanaji aajatzi. Tima yapiita-najiro ikiso-siri-tanaji, ari ikimitzi-tanaari inampiri-payi. ");
INSERT INTO prq_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Antaro ikiso-siri-waitanaji Faraón, ti isinitiri ijataji Israel-iiti. Tima omonkarataka ikantakiriri Pawa pairani Moisés. ");
INSERT INTO prq_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Ipoñaa yapiitajiri Pawa ikantairi Moisés: “Pijati piñiiri Faraón, tima naaka kantakaari ikiso-siri-waitantari irirori aajatzi inampiri-payi, irootaki iñaantai-tyaarori kaari iñaapiintaitzi. ");
INSERT INTO prq_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","Irootaki pinkaman-tairiri pitomi-payi aajatzi picharini-payi onkarati nantayi-tajiri Apitantoniki, tima noñaaka-yitajiri kaari iñaapiin-taitzi. Ari piyoyitajiri awirokaiti naakataki Pawa.” ");
INSERT INTO prq_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Ari ijatanaki Moisés aajatzi Aarón iñiiri Faraón, ikantapaakiri: “Iroka ikantzi Pawa, Iwawani Heber-iiti: ‘¿Tsika-paitima piwashaantiro pikiso-siri-yitzi? Pisinitiri ijataji ikaratzi nasitari naaka, impinkatha-tajina. ");
INSERT INTO prq_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Aikiro-rika pinthañaatyiiyaari, ari namaki naaka onkitaiti-tamanaji oshiki tsitsiri pinampiki. ");
INSERT INTO prq_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","Yanaapaakiro kipatsi, airo okaankitaji kapichiini. Yapirota-paakiro iyaaro tzimaraan-tanaintsiri owamairomi jiriniki, inthonka-paakiro iyaaro okaratzi shookatsiri inchato-payi. ");
INSERT INTO prq_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Impiyota-paakyaa piwankoki, ari inkimitakyaa iwankoki pinampiri-payi, aajatzi maaroni iwankoki Apitanto-nisatzi. Iñiitajiro kaari iñaayitzi pairani asitamiri aajatzi picharinipayi.’ ” Ithonkakiro ikinkitha-waitakairi Faraón, piyanaka. ");
INSERT INTO prq_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Ikantanakiri inampiri-payi Faraón: “¡Pinkatharí! ¿Tsika-paitima inkaratiro yasaryii-matai yoka atziri? Pisinitiri ijataji ishininka-payi, impinkatha-tairi Iwawani. ¿Tima piñiiro iyaaripiro-taitakiro anampi Apitantoni?” ");
INSERT INTO prq_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Ari yapiitakiro Faraón ikaimakaan-tziri Moisés aajatzi Aarón, ikantakiri: “Pijati pimpinkathatiri Piwawani. Iro kantacha nonintzi pinkantina tsika-rika itzimi jatatsini.” ");
INSERT INTO prq_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Ikantzi Moisés: “Nonthonkyaa maaroni nojajiiti: iintsi-payi aajatzi antari-konapayi, notomi-payi aajatzi nosinto-payi. Ari naanajiri maaroni nopira-payi. Tima antaro onkantyaa noimosirinkajiri Nowawani.” ");
INSERT INTO prq_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Ikantzi Faraón: “Tima ti omañaa pinintzi pantiro kaari-pirori. ¿Pisiyakaantzi ari nosinitakimi pijataji, ari paayita-najiri aajatzi piinchaa-nitipayi? Omawitakyaa intsipa-tyaami Pawa awirokaiti. ");
INSERT INTO prq_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Airo omata pinintziri. Pijajiiti awiroka antari-payi, pimpinkathatiri Pawa, tima irootaki pikowajii-takiri.” Yoipyaakiri Faraón ti ininti iñiiri. ");
INSERT INTO prq_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Ari yapiitajiro Pawa ikantairi Moisés: “Piwaanka-wako-tajyaa tsika osaiki Apitantoni, tima namatyii oshiki tsitsiri, yapirotiro pankirintsi tzimaraan-tanaintsiri kaari owamaanaki jiriniki.” ");
INSERT INTO prq_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Ari iwaanka-wako-tanaka Moisés tsika osaiki Apitantoni yairikakiro ikotzikiiri, ikantakaakaro Pawa otampyaataki kitaiti aajatzi tsitini. Okanta okitaiti-tamanaji, iñiitatzii oshiki tsitsiri amakiri tampyaa kinapain-tsiri isitowa-piintzi ooryaatsiri. ");
INSERT INTO prq_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Tima piyotapaaka tsitsiri-payi Apitantoniki. Ti ontzimaji tsika onkaankiti kapichiini. Omaapiro ishikita-paaki, ti iñaitiri pairani, airo iñiitaji apaata aajatzi. ");
INSERT INTO prq_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Ithonka yanaapaakiro maaroni nampitsi, tsitinipiriniki ikantapaaka kipatsiki. Ithonka iwapaakaro pankirintsi, maaroni okithoki-payi inchato okaratzi tzimaraan-tanaintsiri kaari owamai jiriniki. Ithonka yapirotakiro, ti iñaitaji Apitantoniki tsika onatsiryaati inchatosi, omataka owaantsiki aajatzi antami-masiki. ");
INSERT INTO prq_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Ari isintsi-tanaki Faraón ikaimakaan-takiri Moisés aajatzi Aarón, ikantakiri: “Nokaaripiro-tzimo-takiri Piwawani, ari nokimitzi-takamiri aajatzi awiroka. ");
INSERT INTO prq_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Iro kantacha, nonintzi pimpyaako-tajinaro nantzimo-takimiri, airo napiitajiro. Pinkowa-kotiri Pawa, impyaajiri nowankoki naaka yokapayi wamaan-taniri.” ");
INSERT INTO prq_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Ikanta isitowanaji Moisés iwankoki Faraón ikinkitha-waitakairi, yamanajiri Pawa. ");
INSERT INTO prq_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Ari ikantakaakaro Pawa ontampyaati sintsiini okinapaakiro ikyaapiintzi ooryaatsiri, ithonka aanakiri tsitsiri-payi ookakiri Inkaariki Kiraankaaro. Ti iñiitanaji tsitsiri maaroni nampitsiki Apitantoniki. ");
INSERT INTO prq_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Iro kantacha Pawa, aikiro ikiso-siri-takaa-tziiri Faraón, ti isinitiri ijataji Israel-iiti. ");
INSERT INTO prq_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Ari yapiitajiro Pawa ikantairi Moisés: “Pintzinaa-wakoti inkitiki, ontsitinikiti maaroni Apitantoniki, tima tontakyaa onkantyaa tsitinikiri kantacha yantaitiro.” ");
INSERT INTO prq_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Ari itzinaa-wako-tanaka Moisés inkitiki, tima mawa kitaitiri otsitinikitaki maaroni Apitantoniki. ");
INSERT INTO prq_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Tima tikatsi matajironi iñiiri ishininka, okaratzi mawa kitaitiri ti onkanti yaniiwai-taiti tsika-rikapayi. Iriima Israel-iiti kitainka ikantakoyita iwankoki irirori-payi. ");
INSERT INTO prq_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Ari yapiita-najiro Faraón ikaimakaan-takiri Moisés, ikantakiri: “Pijati iroñaaka pimpinkatha-tairi Pawa, paanakiri pitomi-payi. Apatziro pookanakiri pipira-payi.” ");
INSERT INTO prq_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Ikantzi Moisés: “Awiroka opawakinani ipiraitari nompomitiri, irijatzi kachaaryiin-katatsini nompomi-tiniri Pawa. ");
INSERT INTO prq_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Tima ontzimatyii naanajiri ikaratzi nopiratari naaka. Airo nookanaji aparoni, iriitaki noimosirinkan-tapiintariri Nowawani. Tima airorika nayiri, ti noyoti ompaityaa noimosirinkan-tyaariri Pawa aririka nariitakyaa tsika nosiritaro.” ");
INSERT INTO prq_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Tima iriitaki Pawa kantakaakaro ikiso-siri-tantari Faraón, ti isinitiri ijayitaji. ");
INSERT INTO prq_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Ikantanakiri Faraón yoka Moisés: “¡Pijati! Ti noninti pimpiyi piñiina. Aririka napiitakiro noñiimi, aritaki pinkamaki.” ");
INSERT INTO prq_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Ikantzi Moisés: “¡Kamiitha pikantakiri! Airo napiitajiro noñiimi.” ");
INSERT INTO prq_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Ipoñaa yapiitajiri Pawa ikantairi Moisés: “Naaka kantakaan-tironi iñaantyaarori pinkathari pasini kowiinkari, irojatzi iñiiri maaroni Apitanto-nisatzi. Aririka iñaakiro inkowiinka-tako-tanaki Faraón, aritaki isinitajimi pijataji. Iriitaki Faraón sintsiwin-timini pijatantajyaari. ");
INSERT INTO prq_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Pinkantiri pishininka-payi inkampitiri pinatachari isaika-nampi-tziri, ari onkimitzi-tyaari kooya-payi onkampitiro osaika-nampi-tziri ompayita-wajiro iwitsikai-tziri kiriiki, ooro.” ");
INSERT INTO prq_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","Ikantakaakari Pawa Apitanto-nisatzi impasita-wajyaari Israel-iiti. Ari ikimitzi-taikari aajatzi Moisés, ikimita-kaitakari iriipirori. Oshiki ipinkatha-takiri inampiri-payi Faraón aajatzi maaroni atziripayi. ");
INSERT INTO prq_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Ari ikinkitha-waitakaakiri Moisés pinkathari Faraón, ikantakiri: “Pinkimi ikantzi Pawa: ‘Aririka oniyankiityaa-paaki tsitiniri, ari naniitiro maaroni nampitsi Apitantoni. ");
INSERT INTO prq_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","Tima inthonka inkami yantari-tipayi itomi Apitanto-nisatzi, imatzityaa yantariti iwaiyani Faraón, okantawitaka iriipirori isaikawitaka iwinkatha-rimintoki. Imatzityaa yantariti iwaiyani asinonkainkari otzikataari tononka-waitatsiri. Ari inkami-takyaa yantariti iwaiyani ipira-payi. ");
INSERT INTO prq_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Tima akiwainka inkantaityaa yirajiityaa Apitantoniki, ti iñiitiro pairani kimityaaroni, airo apiitaja aajatzi apaata. ");
INSERT INTO prq_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Iro kantacha, tikatsi maimani-tirini Israel-iiti, airo itzimi otsitzi tharotirini. Irootaki piyotan-tyaari iyotziri Pawa Apitanto-nisatzi, iyotzitari Israel-iiti ikaratzi yasitari irirori. ");
INSERT INTO prq_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Ari impokanaki pinampiri-payi iñiina, intyiirowa-paaki, inkanti: ‘Pijataji awiroka, paanajiri pishininka-payi ikaratzi pitsipa-takari.’ Aririka onkarataki awisatsini, aripaiti nojataji.” Tima antaro ikisanaka Moisés isitowanaji ikinkitha-waitakairira Faraón. ");
INSERT INTO prq_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Ipoñaa yapiitakiro Pawa ikantziri Moisés: “Oshiki inthainkimi Faraón, irootaki kantakaan-tironi iñaantyaarori okaratzi kaari iñaapiin-taitzi pairani Apitantoniki.” ");
INSERT INTO prq_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Imatakiro Moisés aajatzi Aarón, tima iñaakayi-takiri Faraón kaari iñaapiintzi. Iriitaki Pawa kantakaaro ikiso-siri-tantanaari Faraón. Ti isinitiri ijataji Israel-iiti isaikakira inampiki. ");
INSERT INTO prq_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Ikanta Pawa iñaanatairi Moisés aajatzi Aarón anta Apitantoniki, ikantajiri: ");
INSERT INTO prq_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“Iriipirori inatyii yoka kasiri, iriitaki itapiin-tajyaaroni kasiri osarintsiki. ");
INSERT INTO prq_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Pinkinkitha-waitakairi maaroni Israel-iiti, pinkantiri: ‘Aririka ariityaa kitaitiri 10 yoka kasiri, ari piyosiitiri aparoni pipira iwankoitiki aparo-payi pishininkapayi awiroka. ");
INSERT INTO prq_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Tirika pishikiti piwankoki pinthonkan-tyaariri piyaari pipira, kantatsi pinkaimiri saika-nampitzimiri, pantityaari pipira, iriitaki iyaari ikaratzi isaikajiitzi irirori iwankoki. ");
INSERT INTO prq_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Tima kamiitha inkantyaa yoka pipira, sirampari inatyii ontzimi aparoni isarintsiti. ");
INSERT INTO prq_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Ari isaikawaki yoka pipira irojatzi kitaitiri 14 yoka kasiri. Iriitaki piwamaa-yitiri aririka ontsitiniityaanaki aparo-payi piwankoki. ");
INSERT INTO prq_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Payiro iriraani, pimpotho-tantyaaro apitiro otzinkami-panki aajatzi okonompi-panki pasitakoro tsika piwayityaari pipira. ");
INSERT INTO prq_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Tima tsitiniriki piyaari pintasi-takiri, patantyaari kaari iwaitai-tziri siñakairori, aajatzi inchasi kipishitatsiri. ");
INSERT INTO prq_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Airo piwari naakirari, aajatzi pinkimi-tajiri kotsirintsi, apatziro piyaari tasirintsi. Tima kantatsi piyaaro aajatzi okaratzi tzimantayitariri inthompointa imotyaaki. ");
INSERT INTO prq_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Pinthon-katiri piyaari, airo piwapithaantari piyaari onkitaiti-tamanaji. Aririka intzima-raantapaaki kapichiini, pintayiri. ");
INSERT INTO prq_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Iroka pinkantyaa piyaari. Piwathakityaa, airo panii-kontatasita, pairikiro pikotzikiiri, sintsipayini piyaa. Tima iroka kitaitiri ampaitajiro “Anankoryaantsi,” irasi Pawa. ");
INSERT INTO prq_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","Tima iroñaaka tsitiniri nonkinanaki maaroni nampitsi Apitantoniki, ari nowamaakiri maaroni yantariti iwaiyani Apitantoni-satzi, aajatzi yantariti itomi-payi ipira-payi. Tima Pawa nonatzii naaka. Aritaki nowasankitaa-nakiniri iwawa-niroti Apitantoni-satzi. ");
INSERT INTO prq_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Tima irootaki iraantsi noyotan-tapaa-kyaarori piwanko tsika pisaika-yitzi awiroka. Aririka noñaapaakiro ompotho-takyaa iraantsi piwanko, nanankoryaa-nakiro. Airo piñiiro mantsiyarintsi wamaantatsiri yatsipi-tyaari Apitantonisatzi. ");
INSERT INTO prq_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","Tima irootaki pinkinkithasiri-tapiin-tajiri iroka kitaitiri, antaro poimosirinkajiro pisirita-jyaari Pawa. Irootaki imatajiri inkarati pincharini-tajyaari. Irasi iwiro yoimosirinkajiro. ");
INSERT INTO prq_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","Tima onkarati 7 kitaitiri piwapiin-tyaaro yatantaitari. Pookayitiro piwankoki okaratzi siñakairori itana-karori kitaitiri. Tzimatsi-rika atziri owakyaaroni siñatsiri yatantaitari itana-karori kitaitiri irojatzi omonkara-tantakyaa 7 kitaitiri, airo isinitai-tziri intsipa-tajyaari ishininka, yookaitakiri. ");
INSERT INTO prq_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Tima papatowintajyaana pimpinkathataina itana-karori kitaitiri. Ari pinkimi-tajirori aajatzi aririka omonkara-tapaakyaa 7 kitaitiri. Tikatsi antawai-tatsini, apatziro inkotsiti iyaari. ");
INSERT INTO prq_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","Poimosirinkajiro iroka kitaitiri iwantai-takarori yatantaitari kaari iwaitai-tziri siñakairori, tima irootaki kitaitiri naantaamiri pisaika-witaka Apitantoniki. Ontzimatyii piyomitaajiri inkarati pincharini-tajyaari, irasi iwiro yoimosirinkajiro irirori nokantakiri. ");
INSERT INTO prq_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Piwapiin-tajyaaro yatantaitari kaari iwaitai-tziri siñakairori kitaitiri 14 irojatzi kitaitiri 21 aririka yitana-kyaaro owakirariki osarintsi. ");
INSERT INTO prq_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","Tima airo otzimawaitzi kapichiini siñakairori yatantaitari piwankoki, irojatzi omonkara-tantakyaari 7 kitaitiri. Tzimatsi-rika owakota-kyaaroni siñakairori, airo inintaitajiri pinampiki, yookaitakiri. Onkanta-wityaa Israel-iiti inatyii, pasini-satzi-rika saikimo-tzimiri, ontzimatyii yookaitiri. ");
INSERT INTO prq_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Tima tsika-rika pinampi-yitajyaaro awiroka, airo piwako-waitaro siñakairori yatantaitari.’ ” ");
INSERT INTO prq_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Ari yapatotakiri Moisés maaroni antarikona-payi Israel-iiti, ikantakiri: “Pijati piyosiiyiti pipira piwamairi piwankoki, iriitaki oimosirinkyaari kitaitiriki ‘Anankoryaantsi.’ ");
INSERT INTO prq_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Payi inchasi, pashitan-tyaaro iriraani pipira piwako-takiri, pimpotho-tantyaaro apitiro otzinkami-panki aajatzi okonompi-panki pasitakoro. Aritaki pisaikawaki piwankoki, airo pisitowa-waitzi irojatzi osaikira. ");
INSERT INTO prq_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Tima inkinatyii Pawa iwamaanakiri yantariti iwaiyani Apitantoni-satzi. Aririka iñaapaakiro iraantsi pipotho-takiro apitiro otzinkami-panki aajatzi okonompi-panki pasitakoro, ari yawisanakiro piwanko-payi. Airo isinitziri Pawa inkyaa-pankotimi apirotan-tatsiri. ");
INSERT INTO prq_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","Poimosirinka-piintajiro awiroka nokantakimiri, irasi iwiro aajatzi inkarati pincharini-tajyaari yoimosirinka-yitajiro irirori. ");
INSERT INTO prq_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Aririka pariitajyaa kipatsi-kinta ikasiya-kaakimiri Pawa, irojatzi poimosirinki-tajyaari aajatzi anta. ");
INSERT INTO prq_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Aririka isampitajimi inkarati pincharini-tajyaari, inkantimi: ‘¿Ipaitama siyakaa-wintachari iroka oimosirinkaantsi?’ ");
INSERT INTO prq_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","Iroka pinkanti awirokaiti: ‘Ari yatsipi-takaitari ipiraitari yoimosirinkaitariri Pawa kitaitiriki Anankoryaantsi. Tima yanankoryaakiro pairani Pawa iwanko-payi ashininka Israel-iiti isaikan-tawitakari Apitantoniki, tima iwamaanakiri yantariti iwaiyani-payi Apitantoni-satzi, iriima ashininka-payi arokaiti ti iwamaanakiri.’ ” Ari ityiirowanaka Israel-iiti ipinkatha-tanakiri Pawa. ");
INSERT INTO prq_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Ikanta ijajiitaji Israel-iiti, imatakiro okaratzi ikantakiriri Pawa yoka Moisés aajatzi Aarón. ");
INSERT INTO prq_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Okanta niyaankiiti tsitiniri, ithonka iwamaakiri Pawa yantariti iwaiyani Apitantoni-satzi. Yitanakari yantariti iwaiyani pinkathari Faraón, imatzitakari yantariti iwaiyani yasitakoi-tziri. Ari ikimitaakiri itarori owaiyani ipira-payi. ");
INSERT INTO prq_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Ikanta isaakitanaki tsitiniriki Faraón, maaroni inampiri-payi, aajatzi Apitantoni-satzi, antaro okantaka iraantsi. Tima maaroni iwankoki ikamayitaki yantariti iwaiyani-payi. ");
INSERT INTO prq_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Ari ikaimakaan-takiri Faraón tsitini-paiti Moisés aajatzi Aarón, ikantakiri: “Pijataji, ti noninti pisaiki-motajina, paanajiri maaroni pishininka Israel-iiti, pimpinkathatiri Pawa, tima irootaki pikanta-piintakinari. ");
INSERT INTO prq_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Paanajiri maaroni pipira-payi. Pimatiro pinintapiin-takiri pantiri. Pijatana-kiita. Pamanako-wintajina aajatzi naaka.” ");
INSERT INTO prq_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Tima isinchinka-thatanakiri Apitantoni-satzi isintsi-tantyaari ijataji Israel-iiti, ikantziri: “¡Pijatanaki sintsiini! Ti noninti napirotyaa nonkami.” ");
INSERT INTO prq_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Ari yaanakiro Israel-iiti opatha yatanta-jiitantari kaari ikonowaitzi siñakairori, iponatan-tanakaro imanthaki, yanatanakiro. ");
INSERT INTO prq_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Imatakiro Israel-iiti okaratzi ikantakiriri Moisés, ikamita-nakiri Apitantoni-satzi ikaratzi iwitsikai-tziri kiriiki, ooro, aajatzi kithaarintsi. ");
INSERT INTO prq_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","Iriitaki Pawa kantakaakari Apitantoni-satzi ipasitan-tawaariri Israel-iiti, ipayita-wajiri okaratzi inintziri. Ari ikantakirori Israel-iiti yaapithatan-tanaariri Apitantoni-satzi iwaararo. ");
INSERT INTO prq_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Ari ijajiitaji Israel-iiti ipoñaanakaro Itomyaani Ooryaatsiri ijajiitiro Pankojaaki. Tima iyosiityaa antari-payi, ikarajiitzi 600,000 atziri. Ti iyoitiro tsika okaratzi kooya-payi aajatzi iintsi-payi. ");
INSERT INTO prq_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Ti apatziro iyosiityaa Israel-iiti ijajiitaji, ikonowa-nakari nasiyita-chari atziri kaari ishininkayita. Tima yaayitanaji oshiki ipiraitari-payi. ");
INSERT INTO prq_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Tima sintsiini imisitowakiri inampiki Apitantoni-satzi, ti inkonowa-nakiro siñakairori opatha yatantaitari, ti inkotsi-tanaki iwariti, apatziro itasitanaki yatantaitari. ");
INSERT INTO prq_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Tima okaratzi 430 osarintsi isaikaki Israel-iiti anta Apitantoniki. ");
INSERT INTO prq_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","Aripaiti isitowa-jiitaji maaroni iwayiri-takaani Pawa isaikawitaka anta Apitantoniki omonkara-tapaaka 430 osarintsi. ");
INSERT INTO prq_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Aamaako-winta iwakiri Pawa tsitiniriki Israel-iiti, tima aritaki imisitowajiri isaikawitakara Apitantoniki. Irootaki yaamaakowin-tantajyaariri Pawa iroka tsitiniriki Israel-iiti, irojatzi imaitajiri inkarati incharini-tajyaari. ");
INSERT INTO prq_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Ikanta yapiitajiro Pawa iñaanatairi Moisés, ikantziri: ");
INSERT INTO prq_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","“Pasita-kaiyaanari yantariti-payi iwaiyan-taitani. Tima maaroni ojiwatani owaiyani pishininka-payi Israel-iiti, aajatzi asi ipiraitari-payi, nasi inayitatzii yokapayi.” ");
INSERT INTO prq_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Ari yapiitajiro Moisés ikantairi ishininka-payi Israel-iiti, ikantziri: “¡Noshininkaiti! Pinkinkithasiri-tajiro kitaitiri pisitowan-taari Apitantoniki, tsika Impira-witaitakami. Tima isintsinka Pawa imisitowan-taami. Irootaki airo piwantajaro ikonowai-tziro siñakairori yatantaitari. ");
INSERT INTO prq_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Tima yoka kasiri ipaitai-tziri “Iiriki”, iriitaki pisitowan-tayitajyaari. ");
INSERT INTO prq_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","Iriitaki yoka kasiri poimosirinkan-tajyaari apaata aririka paajiro inampitsiti Owintini-satzi, Tharowan-taarini-satzi, Tonkaarisatzi, Thaantiwinisatzi, aajatzi Kayaawinisatzi. Tima irootaki ikasiya-kaakiriri Pawa pairani acharinini pasitajyaaro. Ari oshookapaji anta oshiki pankirintsi, aajatzi tsika itzimapaji oshiki ipiraitari. ");
INSERT INTO prq_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","Tima onkarati 7 kitaitiri piwajyaaro yatantaitari kaari ikonowaitzi siñakaironi. Iro kantacha aririka omonkara-tapaakyaa 7-tatsini kitaitiri, poimosirinkajiri Pawa. ");
INSERT INTO prq_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Tima onkarati 7 kitaitiri iwaityaaro yatantaitari kaari ikonowaitzi siñakaironi. Airo otzimawaitzi kapichiini pinampiki opatha ikonowai-tzirori siñakairori. ");
INSERT INTO prq_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","Ontzimatyii pinkaman-tajiri apaata pitomi, pinkantairi: ‘Opoñaantari aimosirinkiro iroka kitaitiri, tima tzimatsi yantzimota-kinari pairani Pawa nositowan-taari nosaika-witaka Apitantoniki.’ ");
INSERT INTO prq_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Pinkimi-takaan-tajiro iroka ñaantsi pinkinta-kotyaaromi pakoki aajatzi pitamakoki. Pinkinkitha-kotajiro iyotakaa-jimiri Pawa, tima isintsinka Pawa yaantaamiri pairani pisaika-witaka Apitantoniki. ");
INSERT INTO prq_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Ontzimatyii pamitajyaaro poimosirinkajiro osarintsiki-payi aririka omonkara-tapajyaa. ");
INSERT INTO prq_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","Ari yariita-kaajyaami Pawa iipatsitiki Owintini-satzi, tsika otzimi ikasiya-kaakimiri awiroka aajatzi picharinini. Aririka yasitakaa-jyaamiro awiroka, ");
INSERT INTO prq_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","pasita-kaajyaari awirokapayi Pawa maaroni ijiwaitziri iwaiyan-taitani. Ari pinkimi-tajiriri sirampari ojiwatziri owaiyani pipira-payi, tima iriitaki Pawa asitari. ");
INSERT INTO prq_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Iriima ojiwatziri owaiyani pipira ikyaakoitari, pimpoyii-tantyaari yanini pipira kaari ipinkaitzi. Airorika itzimi pimpoyii-tantyaariri, pinkatzikiri. Ari pinkimi-tajiriri aajatzi iwaiyani inkarati pincharini-tajyaari, pimpoyii-tantyaari yanini pipira iwaitari. ");
INSERT INTO prq_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","Aririka isampitimi piwaiyani, inkantimi: ‘Ipaita kantakota-chari iroka?’, pinkantiri awiroka: ‘Irootaki kantakotacha isintsinka Pawa imisitowan-tairi asaikawita Apitantoniki, impira-waitajai. ");
INSERT INTO prq_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Okantakaakaro ikiso-siri-waitaki pinkathari Faraón, ti isinitina nojataji, irootaki iwamaan-takariri Pawa yantariti iwaiyani Apitantoni-satzi, ari ikimitaa-kiniri aajatzi ojiwatziri owaiyani ipira-payi. Irootaki nopomitan-taaniriri Pawa sirampari ojiwatziri owaiyani nopira. Ari nokimita-jiriri itarori iwaiyani notomi-payi. ");
INSERT INTO prq_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Pinkimi-takaan-tajiro awiroka pinkinta-kotatyiiyaaromi ñaantsi pakoki aajatzi pitamakoki, tima sintsi ikanta Pawa yamantairi pairani asaikawitaka Apitantoniki.’ ” ");
INSERT INTO prq_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Ikanta isinitajiri pairani Faraón ijataji Israel-iiti, ti inkinakaa-najiri Pawa iipatsitiki Kinawai-taniriiti, ari ithakiryaapiintaitziro. Tima inkanta-kitzii Pawa: “Aririka iñaakiro Israel-iiti manataantsi-payi, ari inintanaji impiyanajiro Apitantoniki.” ");
INSERT INTO prq_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Irootaki itapota-kaantakariri Pawa otzisi-masiki irojatzi Inkaariki Kiraankaaro. Tima owitsikyaa ikantajiitaka Israel-iiti iwayirityaa isitowan-taari Apitantoniki. ");
INSERT INTO prq_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Tima yamajiro Moisés itonki-poroki José, irootaki inintakiri pairani José, Ikantaki: “Aririka inisironka-tajimi apaata Pawa, nonintzi pinkantina kamiithaini, paana-jinaro apaata notonki-poroki.” ");
INSERT INTO prq_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Ikanta yawisanaki Israel-iiti isaikawi-tapaaka Pankoshaaki, ariijiitaka Shiwamin-taaki tsika itanakaro otonkaaro otzisi-masi. Ari imajiita-paaki. ");
INSERT INTO prq_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Iriitaki Pawa jiwatapiin-takiriri. Tima iñiiro okantasamata kitaipaiti minkori, iyotzi ari inkinajiiti. Irooma tsitini-paiti opaamatzi minkori, irootaki okoñaatantari tsika ikini yaniijiiti. Ari okanta yaniitan-takari kitaitiriki aajatzi tsitiniriki. ");
INSERT INTO prq_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Tima ti ookani owiri Israel-iiti kitaipaiti okantasamataka minkori, ari okimitakari tsitini-paiti okitainka-takotziri opaamasamataki. ");
INSERT INTO prq_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Ari iñaawaitaki Pawa, ikantziri Moisés: ");
INSERT INTO prq_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","“Pinkantiri pishininka-payi Israel-iiti impiyajiita Kyaa-mori-winiki, tima ari oniyaanki-thatziri anta osaiki inkaari tsika omontita-paaro nampitsi ipaitai-tziri Iwaararo Inkaniwiri, ari Pankothanthaari anta. ");
INSERT INTO prq_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Irootaki inkantan-tyaari Faraón: ‘Tikatsi inkini isiyi Israel-iiti, otzikawakiri otzisi-masi.’ ");
INSERT INTO prq_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Ari nonkanta-kaakyaaro naaka yapiitiro inkiso-siri-tanaji Faraón, irootaki inintan-tyaari impatzima-tawajimi. Ari noñaakan-tirori nosintsinka, nontsipatairi iwayiriti-payi. Ari iyotiri Apitantoni-satzi naaka Pawa.” Imatakiro Israel-iiti okaratzi ikantakiriri Pawa. ");
INSERT INTO prq_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Ari ikamantai-takiri iwinkathariti Apitantoni-satzi, ikantai-tziri: “Siyaka Israel-iiti.” Antaro owatsimaa-nakiri Faraón ikimawaki, imatzita-nakaro inampiri-payi irirori, ikantajii-tanaki: “¿Ipaita asinitan-taariri ijataji Israel-iiti, tikatsi ampirata-jyaari?” ");
INSERT INTO prq_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Sintsiini iwitsika-nakiro isiyako-minto, ikaimakiri iwayiriti. ");
INSERT INTO prq_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","Iyosiitaki iroopirori siyako-mintotsi okaratzi 600. Yaanaki aajatzi pasini isiyako-minto-payi Apitantoni-satzi, ari ititanakari jiwayitziriri iwayiriti. ");
INSERT INTO prq_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Iriitaki Pawa kantakaarori ikiso-siri-tanta-naari Faraón, pinkatha-ritatsiri Apitantoniki, ipatzima-tanakiri Israel-iiti. Iro kantacha Faraón ti inkinkithasiri-tajiro antaro okantaka sintsin-kantsi isitowan-taari Israel-iiti inampiki. ");
INSERT INTO prq_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Jaitijiitaki Apitantoni-satzi ipatzima-tziri Israel-iiti. Ari ikaratanakiri iwayiriti-payi ikyaako-yitakari ipira-payi, aajatzi isiyako-minto-payi Faraón. Iyaatawajiri iwanko-thaanti-yitapaaka inkaari-thapyaaki Kyaa-moriwini, omontitakari nampitsi Iwaararo Inkaniwiri. ");
INSERT INTO prq_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Ikanta okaaki-tapaaki Faraón, yaminajiitaki Israel-iiti, iñaatziiri ipokajiitaki Apitantoni-satzi ipatzima-takiri. Antaro itharowa-jiitanaki Israel-iiti, ikowako-tanakiri Pawa yamitakotiri. ");
INSERT INTO prq_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Ikantanakiri Moisés: “¿Tikatsima Apitantoniki tsika nonkitatyaa pamantanari otzisi-masiki nonkamayiti? ¿Tsikama pinkantinaka? ¿Paitama pamantaanari nosaikawita Apitantoniki? ");
INSERT INTO prq_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Aritaki nokantzi-takami Apitantoniki: ‘Piñaasi-tyaana isintsiwinta-waitana Apitantoni-satzi nantawai-tiniri, irootaki kamiitha-witacha impira-tyaana Apitantoni-satzi, airo noñiiromi iroñaaka nonkami otzisi-masiki.’ ” ");
INSERT INTO prq_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Ari yakanakiri Moisés ishininka-payi Israel-iiti, ikantziri: “Airo pitharowan-tajiitari. Pintonta-siriti. Aritaki iwawisaa-kotakimi Pawa. Tima inkarati Apitantoni-satzi piñiiri iroñaaka, airo piñaajiri apaata. ");
INSERT INTO prq_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Airo okantzi-mowaitami, iriitaki Pawa kisakowin-tyaamini awirokaiti.” ");
INSERT INTO prq_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Ari ikantanaki Pawa: “¡Moisés! ¿Ipaitama pikaimakaimatantanari? Pinkantiri pishininka-payi Israel-iiti: ‘Pijajiiti.’ ");
INSERT INTO prq_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Irooma awiroka piwaankiro pikotzikiiri inkaariki, aritaki ontinka-ryaanaki. Tima piryaasaanti onkanta-nakyaa, ari inkinajii-tanaki Israel-iiti yaniijiitanaki. ");
INSERT INTO prq_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Naaka oomasontyaasiritirini Apitantoni-satzi, inintan-tyaari impatzima-tanakimi. Ari iñiirori nosintsinka Faraón, aajatzi maaroni iwayiriti. Napirotiro isiyako-minto aajatzi ipira-payi ikyaako-yitari-payi. ");
INSERT INTO prq_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Tima ari iyoti Apitantoni-satzi naakataki Pawa, aririka iñaakiro nosintsinka tsika nonkantakiri pinkathari Faraón, napirotzitiri isiyako-minto, iwayiriti aajatzi ipira-payi ikyaakoitari-payi” ");
INSERT INTO prq_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Ikanta Imaninkariti Pawa, aajatzi minkori jiwatapiin-takiriri Israel-iiti, impoitanaki itaapiiki tsika ikinajii-tapaakiro. ");
INSERT INTO prq_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","Satikanaka niyaankiniki ipokajiitzi Apitantoni-satzi ipatzima-tziri Israel-iiti. Tsitiniki okantzi-mojii-takari Apitantoni-satzi, iriima Israel-iiti koñiinka okanta iñiiro irirori tsitini-paiti. Irootaki kaari imatantaro Apitantoni-satzi iyaatiri Israel-iiti, tima tsitiniki ikantakotaka irirori. ");
INSERT INTO prq_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Ikanta iwaanka-nakiro Moisés irako inkaariki, ikantakaakaro Pawa ompoki antaro tampyaa tsitini-paiti okinapaakiro isitowa-piintzi ooryaatsiri, ari otinka-ryaanaki inkaari, awotsitanaki. ");
INSERT INTO prq_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","Yaniitan-tanakaro Israel-iiti tsika opiryaa-tanaki inkaari, tima osiyawai-tanakaro impirita okatziya-tantaa-tanaka yampatiki aajatzi irako-piroki. ");
INSERT INTO prq_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Iyaataa-jiitakiri Apitantoni-satzi, itsipayi-takari iwayiriti Faraón ikyaako-yitakari ipira-payi, isiyako-yitaka isiyako-mintoki-payi, wiraajiitaka niyaankiniki inkaari. ");
INSERT INTO prq_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Ikanta okitaitzi-mataki, yaminaki Pawa isaikaki okitainkataki minkori oorintasamatainchari, iñaakiri iwayiriti Apitantoni-satzi, ikantakaakaro ayima-jiitiri itharowanka. ");
INSERT INTO prq_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","Ikantakaaro aajatzi othopaa-yitanaki osiyantari isiyako-minto. Ari owatsi-pirotakiri itharowa-jiitanaki. Ikantajiitzi Apitantoni-satzi: “Thami ampiya-pithatiri Israel-iiti, tima inkisawin-tatyii-yaari Pawa.” ");
INSERT INTO prq_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Iro kantacha ikantakiri Pawa yoka Moisés: “Piwaankiro pako inkaariki, ompiyiita nijaa anairi maaroni Apitantoni-satzi, isiyako-minto-payi aajatzi ikaratzi kyaakotariri ipira-payi.” ");
INSERT INTO prq_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Aritaki kitaiti-tzimatanaki, iwaanka-nakiro irako Moisés inkaariki, sintsiini okantanaka inkaari osirinka-paaka. Isiyaminthaita Apitantoni-satzi, imonthaitaro inkaari. Ari ikantakirori Pawa yapirotan-takariri Apitantoni-satzi niyaankyaniki inkaari. ");
INSERT INTO prq_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Tima sintsiini osirinka-paaka inkaari, anaanakiro isiyako-minto-payi, ikaratzi kyaakotariri ipira-payi, aajatzi maaroni iwayiriti Faraón itsipatakari ipatzima-tziri Israel-iiti. Yapirotaka maaroni, tikatsi añaajatsini. ");
INSERT INTO prq_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Iriima irirori Israel-iiti kamiitha yaniitan-tanakaro inkaari tsika opiryaa-tanaki, osiyawai-takaro impirita okatziya-tantaa-tanaka yampatiki aajatzi irako-piroki. ");
INSERT INTO prq_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Ari ikantakirori Pawa iwawisaa-kotanta-kariri Israel-iiti impira-waitari Apitantoni-satzi. Iñaakiri Israel-iiti ikamajiitaki Apitantoni-satzi naryaa-masini inkaari-thapyaaki. ");
INSERT INTO prq_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Ikanta iñaakiro Israel-iiti iroopirori okantaka yantakiri Pawa yiitsinampaakiri Apitantoni-satzi, ipinkatha-tanakiri, yawintaa-nakari Pawa aajatzi ikimitaa-nakiriri Moisés, impiratani Pawa. ");
INSERT INTO prq_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Ari ipanthaa-kotanakiri Pawa yoka Moisés aajatzi ishininka-payi Israel-iiti. Iroka ikantzi ipanthaa-jiitzi: Nompanthaa-kotajiri Pawa, tima iriipirori ikantaka irirori yiitsinampaantaki. Iwiinkakiri ikyaakoitari aajatzi ikaratzi kyaakotariri. ");
INSERT INTO prq_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","Nompanthaa-wintajiri Pawa, Tima iriitaki sintsita-kayinari, iriitaki owawisaa-kotaanari. Iriitaki Nowawani, ontzimatyii nowisiryaa-wintajiri, Iriitaki Iwawani asitanari, ontzimatyii nokimosiriwintairi. ");
INSERT INTO prq_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Ikanta yaanajiri Moisés ishininka-payi Israel-iiti yookanajiro Inkaari Kiraankaaro. Ikinanaki otzisi-masiki ipaitai-tziro Tantotsi-wini, tima mawa kitaitiri yaniijiitaki, ti iñaaji nijaa otzisi-masiki irajiri. ");
INSERT INTO prq_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Ikanta yariijiitaka ipaitai-tziro Kipishaa, ti onkanti irapaakiro nijaa, tima kipishaa okantaka. Irootaki owaitakaan-tzirori anta Kipishaa. ");
INSERT INTO prq_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Ari ikisima-tanakiri ishininka-payi Moisés, ikantajii-tziri: “¿Ipaitama iriri?” ");
INSERT INTO prq_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Irootaki yamanan-tanakari Moisés ikowako-takiri Pawa. Ari iñaakakiriri aparoni inchasimpoki. Yaakiro Moisés, iwiinkakiro nijaaki, kamiitha-tanaki iriro. Ari inintanaki Pawa iñaanta-kaajyaari, ikantakaan-taki onkarati yamitajyaari. Tima iñaanta-tyiiyaari. ");
INSERT INTO prq_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","Ikantakiri: “Aririka pinkimisantiri Piwawani, tampatzika-siriri pinkantajyaa, pimonkara-tajiro ikantakaantani, noñaakimi piwashaan-tajiro okaratzi iwinkakaantani, airo patsipitaro awiroka mantsiyarintsi yatsipi-takari Apitantoni-satzi, tima naaka Pawa, wawisaako-tantziri.” ");
INSERT INTO prq_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Ikanta yariijiitaka Kompiro-jaariki, ari otzimiri anta okaratzi 12 nijaatinka, ari oshookiri aajatzi okaratzi 70 kompirosi. Ari iwanko-thaanti-jiitapaaka anta. ");
INSERT INTO prq_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Tima irootaki iroka kitaitiri 15 inkaran-tyaarimi apiti kasiri isitowan-tajari Israel-iiti Apitantoniki. Ari yawisajii-tanaki ipoñaanajaro Kompiro-jaariki irojatzi niyaanki-thakiniki otzisi-masi Kitoochiintoni. ");
INSERT INTO prq_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Okanta anta otzisi-masiki, maaroni Israel-iiti iñaanawai-tapaakiri Moisés aajatzi Aarón. ");
INSERT INTO prq_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","Ikantajiitzi: “Ari okamiithawita iwamaayi-tinami Pawa Apitantoniki, tsika nopiyota-kotapiin-tziri wathatsi noyowitzitiki, tsika nokimatzii-tapiinta-jiita nowawai-jiita. Irooma pama-jiiwitakana awiroka aka otzisi-masiki ari paakainaro notashi maaroni nokarajiitaki.” ");
INSERT INTO prq_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Ari yapiitajiri Pawa, ikantairi Moisés: “Ari nowaryaa-kiniri owaritintsi. Irootaki iyoyairi Israel-iiti onkarati iyaari aparoni kitaitiri. Ari noyotiriri ikimisan-tziro-rika nokantziriri. ");
INSERT INTO prq_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Iro kantacha iroka 6-tatsiri kitaitiri, ontzimatyii yanaakairo okaratzi iyoyaapiin-tziri pasiniki kitaitiri, irootaki iwapithaan-tyaari.” ");
INSERT INTO prq_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Irootaki iroka ñaantsi iwawisaa-kiniriri maaroni ishininka-payi Moisés aajatzi Aarón, ikantakiri: “Iroñaaka tsitinii-tiini ari piyotiri iriitaki Pawa omisitowa-jimiri Apitantoniki. ");
INSERT INTO prq_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","Irooma onkitaiti-tamanaji ari piñiirori iwaniinkaro Pawa, tima ikimakimi okaratzi pikisima-waitakiri. ¿Pisiyakaan-tzima naaka pikisima-waitzi?” ");
INSERT INTO prq_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Aikiro ikantana-kitzii Moisés: “Iroñaaka tsitinii-tiini impimi Pawa posiniri piyaari. Irooma onkitaityaa-manaji impimi oshiki yatantaitari, irootaki pinkima-niintyaari. Tima ikimakimi Pawa pikisima-waitakiri. ¿Pisiyakaantzi naaka pikisima-waitzi? Tima ti naaka pinkisimati, Pawa pikisimataki.” ");
INSERT INTO prq_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Ari ikantanakiri Moisés iririntzi Aarón, ikantziri: “Pinkaimiri maaroni ashininka-payi Israel-iiti, pinkantiri: ‘Pimpoki maaroni apatowin-tyaari Pawa, tima ikimakimi pikisima-waitakiri.” ");
INSERT INTO prq_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Iñaanaminthai-tziri Aarón maaroni Israel-iiti, iro yaminakimi otzisi-masiki, iñaatziiro iwaniinkaro Pawa anta minkoriki. ");
INSERT INTO prq_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Ari iñaanata-nakiri Pawa yoka Moisés, ikantziri: ");
INSERT INTO prq_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","“¡Moisés! Nokimakiri pishininka-payi Israel-iiti ikisima-waitana. Nonintzi pinkantiri: ‘Pinkimiri ikantzi Pawa: “Aritaki piwakyaa posiniri tsitinii-tiini, irooma onkitaityaa-manaji piyaa oshiki yatantaitari, irootaki pinkima-niintyaari. Tima irootaki piyotan-tajyaari naakataki Piwawani.” ’ ” ");
INSERT INTO prq_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Okanta otsitiniityaanaki, ari itonka-jiitapaaki posiniri, aniimasi-tapaaki opiyotaka iwanko-thaanti-payi Israel-iiti. Irooma okitaiti-tamanaji iñaatzii ashimasi-tapaaki itsini impokiro kipatsiki. ");
INSERT INTO prq_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Ikanta okaratapaakira itsini impokiro, iñiitatzii piyowani-tapain-chari okaankitaki otzisi-masiki, yaaniiriki okantayitaka. ");
INSERT INTO prq_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Ti iyotiro Israel-iiti tsika opaita, ikanta-wakaa-jiita: “¿Ipaitama iroka?” Ikantzi Moisés: “Irootaki owaritintsi ipimiri Pawa piyaari. ");
INSERT INTO prq_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Iroka ikantzi Pawa: ‘Pinkoyaayiti onkarati pantityaari piyaari tsika pikarajiitzi piwankoki. Pijaikiti aparoni pachakaki inkimyaari aparoni atziri.” ");
INSERT INTO prq_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Imatakiro Israel-iiti ikantai-takiriri. Tzimatsi aintsiri oshiki, pasini kapichini iyoyaaki. ");
INSERT INTO prq_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Iro imonkara-tanta pachaka ijayitzi, ti yaparawaitiro aintsiri oshiki, ti onkowityii-motyaari aintsiri kapichiini. Yaayitaki okaratzi inintziri iyaari. ");
INSERT INTO prq_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Ipoñaa ikantaki Moisés: “Airo piwapithaanta-waitaro piwamanai-yaaro onkitaiti-tamanaji.” ");
INSERT INTO prq_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Iro kantacha, ipiyatha-takaro Israel-iiti ikantawi-takariri Moisés, tzimatsi owapithaan-tainchari iwamana-jyaari onkitaiti-tamanaji. Tima onthonka okini-tanaki, sitziinka okantanaka. Irootaki ikisanta-kariri Moisés ikaratzi piyatha-takariri. ");
INSERT INTO prq_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Ari ikantatyaa ikoyii kapichikitaiti, yayi okaratzi inintziri iyaari. Aririka isaawata-paaki ooryaatsiri, othonka owyaanaka. ");
INSERT INTO prq_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Irooma 6-tatsiri kitaitiri, ari yanaakairo okaratzi ikoyaapiin-tziri pasini kitaitiri, apiti pachaka yaayitzi iyaari aparoni atziri. Ijatzimaita jiwari-payi ikamantziri Moisés okaratzi yaayitakiri. ");
INSERT INTO prq_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Ari ikantzi Moisés: “¡Jiwari-payi! Irootaki ikantakiri Pawa, ikantzi: ‘Onkitaiti-tamanaji, irootaki kitaitiri imako-ryaan-taitari iita-tasorintsitani Pawa. Pinintzi-rika pinkotsiti, pimatiro. Pinintzi-rika pintasitiro, pimatiro. Aririka ontzima-raanti, kantacha piwapitha-tyaaro piyaari onkitaiti-tamanaji.’ ” ");
INSERT INTO prq_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Imatakiro okaratzi ikantakiriri Moisés, iwapithaan-takaro, irootaki iyaari onkitaiti-tamanaji, titzimaita onkiniti, ti ositziti aajatzi. ");
INSERT INTO prq_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Ipoñaa ikantzi Moisés: “Piyaaro iroñaaka, tima irootaki kitaitiri tsika inintaitziri Pawa. Airo piñiiro ompiyo-wanityaa okimita-piinta. ");
INSERT INTO prq_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Tima apatziro onkarati 6 kitaitiri piyoyaa-piinti, irooma kitaitiri 7-tatsiri imako-ryaan-taitari, airo piñii ompiyo-wanityaa.” ");
INSERT INTO prq_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Iro kantacha, tzimatsi Israel-iiti jatamana-jatsiri kitaitiri imako-ryaan-taitari inkoyii, titzimaita iñii. ");
INSERT INTO prq_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Irootaki ikantan-tanakariri Pawa yoka Moisés, ikantziri: “¿Tsika-paitika pinkaratiro pipiyatha-waitaro nokanta-kaantani, aajatzi noñaani? ");
INSERT INTO prq_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Pinkinkithasirityaa, naaka Pawa owitsika-kimirori kitaitiri imako-ryaan-taitari. Irootaki otzimantari 6-tatsiri kitaitiri paantyaari oshiki piyaari apitiki kitaitiri. Irooma kitaitiri imako-ryaan-taitari, pisaiki piwankoitiki airo pisitowa-waitzi tsika-rikapayi.” ");
INSERT INTO prq_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Ari ikantakiro Israel-iiti imairi-jiitaka kitaitiriki imako-ryaan-taitari. ");
INSERT INTO prq_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Ikanta yokaiti Israel-iiti ipaitakiro iroka owaritintsi “ipaitama”. Tima kitamaaro onayitzi, iroowaitaki iyaaniiriki okitho pankirintsi, pocha okanta iwaitaki ochiirinkaantsi ikonowai-tziro yaarato. ");
INSERT INTO prq_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Ikanta yawisajii-tanaki maaroni Israel-iiti isaikawi-tapaaka otzisi-masiki Kitoochiintoni, niitsikiroini ikanta ijajiitzi, kimisanta iwakiro ikantziriri Pawa. Irojatzi yariijii-tantakari Maamintowiniki, ari isaikajii-tapaaki anta tsika ti ontzimapaji nijaa iriri. ");
INSERT INTO prq_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Ari yapiita-najiro Israel-iiti iñaanamintha-tanajiri Moisés, ikantziri: “¡Moisés! Pimpina nijaa niriri.” Ari ikantzi irirori Moisés: “¿Ipaitama piñaana-mintha-tantanari naaka? ¿Ipaita pantawinthatan-tyaariri Pawa?” ");
INSERT INTO prq_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Tima antaaro imirijiitaki Israel-iiti, aikiro iñaanamintha-tatziiri Moisés, ikantziri: “¿Ipaitama pamanta-janari nosaikawita Apitantoniki? ¿Irooma pamantanari aayitina nomiri naaka, imiri nowaiyani-payi aajatzi nopira-payi?” ");
INSERT INTO prq_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Irootaki yamanan-tanajari Moisés ikowako-takiri Pawa, ikantzi: “¡Pawá! ¿Tsikama nonkanti-rika yokapayi noshininka? ¡Aririka awishimo-tawajiri kapichiini opaita-rika, ari ishimyaan-takyaanaro mapi!” ");
INSERT INTO prq_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Ikantzi Pawa: “¡Moisés! Pijati tsika ipiyojiitaka pishininka-payi Israel-iiti, pintsipa-tanakyaari antari-konapayi. Paanakiro pikotzikiiri piposan-takarori pairani nijaa. ");
INSERT INTO prq_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Ari nosaikiri aajatzi naaka anta otzisiki Mamirii-toni. Pimposhiro mapitanta, aritaki oyowanaki nijaa iriri pishininka-payi.” Tima imatakiro Moisés okaratzi ikantakiriri Pawa, iñaakiri antari-konapayi Israel-iiti yantakiro. ");
INSERT INTO prq_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Irootaki owaitakaan-tzirori anta Koshikaa-rini, irootaki ipaitai-tzitari aajatzi Kisima-jaari, tima oshiki ikisawaitaka Israel-iiti, ikisima-waitakiri Pawa, ikantaki: “¿Omaapiroma itsipatajai Pawa, ti yamatawitajai?” ");
INSERT INTO prq_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","Aritaki awisanaki ikaratzi mawa kasiri imisitowai-tajiri Israel-iiti isaikawitaka Apitantoniki, ariijiitaka otzisi-masiki Kitoochiintoni. ");
INSERT INTO prq_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","Tima ipoñaakaro Maamintowiniki yokaiti Israel-iiti, irojatzi otzisi-masiki Kitoochiintoni tsika isaikajii-tapaaki. Ari iwanko-thaanti-jiitapaaka imontita-paakaro otsisi. ");
INSERT INTO prq_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Ari itonkaanaki Moisés imonthai-yaari Pawa inkinkitha-waitakairi. Ari iñaawai-tanaki Pawa isaikaki otsisiki, ikantziri: “¡Moisés! Pinkamantiri icharini-payi Jacob pinkantiri: ‘¡Israel-iiti! Iroka iñaani Pawa, ikantzi: ");
INSERT INTO prq_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","“Piñaayi-takiro tsika nokantakiri Apitantoni-satzi, tsika nokantakiro namanta-jamiri nosaiki naaka, tima osiyawai-takaro iriimi amajimini pakitha isiwankiki. ");
INSERT INTO prq_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Aririka pimonkara-tajiro okaratzi akasiyakaa-wakaari, airorika pipiyathatana, tima awirokaiti nitako-piro-tajyaa, ari anaanakiro okaratzi nitakotari pasini-satzi, tima naaka asitarori maaroni kipatsi. ");
INSERT INTO prq_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","Ompira-tasorintsi-taari pinayitaji awiroka pikaratzi ipinkathari-wintaitakimi. Kitisiri pinkanta-yitajyaa.” Irootaki iroka ñaantsi pinkantiriri pishininka Israel-iiti.’ ” ");
INSERT INTO prq_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Ari ipiyapaaka Moisés, ikaimakiri antari-konapayi, ikamantakiri okaratzi ikantakiriri Pawa. ");
INSERT INTO prq_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Ikantajii-tanaki maaroni Israel-iiti: “Ari amatakiro okaratzi ikantakiri Pawa.” Aajatzi ipiyanaja Moisés, ikamanta-pajiri Pawa, ikantziri: “Inintajiitaki noshininka-payi.” ");
INSERT INTO prq_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Ari ikantzi Pawa: “¡Moisés! Ari nonkanta-kaakyaaro ontsitinikiti minkori, ari nompokiri noñiimi, tima ari inkimakina pishininka-payi noñaanatimi. Ari yasi iwiro inkimisantimi.” Tima yapiita-nakiro Moisés okaratzi inintakiri Israel-iiti, ikamantakiri Pawa, ikantziri: “Omaapiro inintajiitaki noshininka.” ");
INSERT INTO prq_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","Ikantzi Pawa: “¡Moisés! Pijati, piwitsika-siri-takaa-jyaari pishininka-payi iroñaaka kitaitiri aajatzi onkitaiti-tamanaji. Inkiwayi-tairo aajatzi iithaari-payi. ");
INSERT INTO prq_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","Aamawinta inkanta-yityaa aajatzi pasini kitaitiri. Tima ari nayiitiri otsisiki Kitoochiintoni, iñiiro maaroni pishininka-payi. ");
INSERT INTO prq_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Pookotiniri pishininka-payi tsika owiraiyaa yaniiti, pinkantiri: ‘Airo pawishiro kapichiini tsika nookotakiro. Pimpinkathatiro, airo pitonkaa-waitzi. Tzimatsi-rika awisakironi tsika nookotakiro, ontzimatyii impyaakai-tyaari.’ ");
INSERT INTO prq_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Ti osinitaan-tsiti kapichiini yairikaitiro, aritaki ishimyii-tanta-kyaari mapi, tirika ontzimatyii inkintaitiri. Iriirika atziri, iriirika ipiraitari, ontzimatyii iwamaitiri. Apatziro osinitaan-tsita intonkaiti aririka intyootaiti.” ");
INSERT INTO prq_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Ari yoirinkaja Moisés tsika isaikajiitaki ishininka-payi, iwitsika-siri-takaa-yitakari. Ikiwakaa-yitakiri iithaari aparo-payi. ");
INSERT INTO prq_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","Ikantakiri aajatzi Moisés ishininka-payi, ikantziri: “¡Israel-iiti! Ontzima-tyiira paamawintyaa pasiniki kitaitiri, airo pimaantaro piinapayi.” ");
INSERT INTO prq_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Okanta okitaiti-tamanaji mawatatsiri kitaitiri, omapoka-sitaka omorikanaki sintsiini ookatha-rontsi, tsitiniki okantanaka minkori otzisiki. Ikimaji-tatzii tyootanain-tsiri sintsiini. Antaro itharowa-jiitanaki kimakirori. ");
INSERT INTO prq_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Ari yaanakiri Moisés maaroni ishininka-payi imonthaa-wakyaari Pawa. Katziya-jiitapaaka tsika itanakaro otonkaa otzisi. ");
INSERT INTO prq_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Tima kachaaryiinka okantanaka Kitoochiintoni yayiita-paakira Pawa. Iriiwaitaki ikachaa-ryiin-katzi opaama-pirotzi paamari. Ithonka ontziñaaka otzisi. ");
INSERT INTO prq_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Aikiro opoima-tatzii sintsiini tyoorintsi. Tima iñaawaitzira Moisés, akatsi irirori Pawa isiyakaro ookatha-taantsi. ");
INSERT INTO prq_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Yayiitaki Pawa otsisi Kitoochiintoni. Ari ikaimakiri Moisés impoki tonkaariki. Jatanaki Moisés tonkaariki. ");
INSERT INTO prq_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","Ikantzi Pawa: “¡Moisés! Pimpiyi otaapiki, pinkantiri pishininka-payi airo yawishiro tsika nookotakiro ininti iñiina. Aamaiyaa aritaki inkamayitaki. ");
INSERT INTO prq_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Ontzimatyii iwitsika-siri-tajyaa aajatzi Impira-tasorintsi-taari, impokan-tyaari iñiina. Aamaiyaa ari inthonkyaa nowasankitaakiri.” ");
INSERT INTO prq_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Ari ikantzi Moisés: “¡Pawa! Airo imatziro noshininka-payi intonkajiro otsisi Kitoochiintoni, tima awiroka kantain-tsiri: ‘Pookoti tsika owiraiyaa yaniitaiti otzisiki, tasorintsi onkantyaa.” ");
INSERT INTO prq_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Ari ikantzi Pawa: “¡Moisés! Poirinkaji. Impoña pintonkaaji aajatzi pintsipa-tajyaari Aarón. Iriima Impira-tasorintsi-taari aajatzi pishininka-payi, airo yanitajiro tsika pookotakiro, aamaiyaa aritaki nowasankitaajiri.” ");
INSERT INTO prq_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Ikanta yoirinkaja Moisés, ikamanta-pajiri ishininka-payi. ");
INSERT INTO prq_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Ari iñaawai-takirori Pawa iroka ñaantsi, ikantaki: ");
INSERT INTO prq_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“Naaka Piwawani, naaka aajimiri impira-waitaitami Apitantoniki. ");
INSERT INTO prq_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","Airo pipinkatha-waitziri pawaniro, apatziro pimpinkathatina naaka. ");
INSERT INTO prq_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","Airo piwitsika-waitzi siyakaa-rontsi, airo piitatasorintsi-waitziri tzimatsiri inkitiki, kipatsiki, nijaaki aajatzi otapi-naki kipatsi. ");
INSERT INTO prq_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Airo pipinkatha-waitziri, airo pityiirowa-siwaitari aajatzi. Tima naaka Piwawani, Sintsi-pirori, Aamaako-wintamiri. Naaka owasankitairiri kisaniin-tanari, aajatzi itomi-payi, icharini-payi, itomi-payi icharini-payi. ");
INSERT INTO prq_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","Iriima inkarati itakota-jiityaanani naaka, inkimisan-tajiro noñaani, oshiki nitakota-jyaari irirori, ari nonkimi-tajiriri maaroni incharini-tajyaari inkarati impoyii-tajyaarini apaata. ");
INSERT INTO prq_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","Naaka Piwawani, airo pipairyaa-siwaitana. Tima nonthonkiri nowasankitairi naaka ikaratzi pairyaa-siwai-tanari. ");
INSERT INTO prq_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","Pinkinkithasiri-tajiro kitaitiri imako-ryaan-taitari, piita-tasorintsi-tajiro. ");
INSERT INTO prq_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Tima tzimatsi 6 kitaitiri pantawai-tantyaari, pantajiro okaratzi pinintziri. ");
INSERT INTO prq_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","Irooma kitaitiri 7, ari pinkinkithasiri-tajinari Naaka, Piwawani. Ti onkamiithati pantawai-tantyaaro iroka kitaitiri, aajatzi pitomi, pisinto, pimpiratani, pipira-payi, aajatzi pasini-satzi ikaratzi saikimo-tzimiri piwankoki. ");
INSERT INTO prq_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Tima okaratzi 6 kitaitiri nowitsikan-takarori inkiti, kipatsi, inkaari aajatzi okaratzi tzimatsiri. Irooma kitaitiri 7, nomako-ryaan-takaro. No-tasorintsi-takiro iroka kitaitiri. ");
INSERT INTO prq_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","Pimpinkathatairi piri aajatzi piniro. Aritaki osamanitaki nañaakayimi kipatsiki nokasiya-kaakamiri nompajimiro. ");
INSERT INTO prq_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","Airo piwamaantzi. ");
INSERT INTO prq_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","Airo pimayimpitzi. ");
INSERT INTO prq_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","Airo pikositzi. ");
INSERT INTO prq_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","Airo pithaiya-kotanta. ");
INSERT INTO prq_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","Airo ayimawaitzimi piniwityaaro okaratzi tzimimo-tziriri pishininka, iwanko, iina, impiratani-payi, ipira-payi, maaroni.” ");
INSERT INTO prq_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Iñaakiro maaroni Israel-iiti ookatha-rontsi, ikimakiro tyoorintsi, iñaakiro aajatzi okachaataki otzisiki. Ikanta iñaayitakiro iroka-payi, antaro itharowa-jiitaki, intaina ikatziya-yitaka. ");
INSERT INTO prq_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","Ari ikantajii-tanakiri Moisés: “Piñaanatina awiroka, aritaki nantakiro onkarati pinkantinari. Ti noninti iñaanatina Pawa, iwamaanakari.” ");
INSERT INTO prq_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Jatanaki Moisés, ikamantakiri Israel-iiti okaratzi ikantakiriri Pawa, ikamantakiri Ikantakaantani. Ari yakajiitanaki maaroni Israel-iiti, ikantajiitzi: “Ari amatakiro okaratzi ikantakiri Pawa.” ");
INSERT INTO prq_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Ipoñaa isankinatakiro Moisés okaratzi ikantakiri Pawa. Okanta okitaitita-manaji, jataki iwitsikaki pomipirini-mintotsi tsika otonkai-matanaka otzisi, ipiwiryaaki okaratzi 12 mapithanthaa, imonkaratakiro ikaratzira 12 ishininka-mirinka Israel-iiti. ");
INSERT INTO prq_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Ipoñaa ityaantaki awankari-payi Israel-iiti, iriitaki pomitakiriri antari ipiraitari yatsipita-kaani onkantyaa yaapatyaan-tajyaariri Pawa. ");
INSERT INTO prq_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Yaakiro Moisés iriraani antari ipiraitari, isakiro niyankyaa iwajoniki. Yaakotakiro pasini niyankyaa iraantsi itsikiryaan-takaro pomipirini-mintotsi. ");
INSERT INTO prq_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Ipoñaa yaakiro tsika osankinata kasiyakaantsi, ikimajiitaki maaroni atziri iñaanatakiro, ikantajiitzi: “Aritaki amatakiro okaratzi ikantajairi Pawa.” ");
INSERT INTO prq_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Ari yaakotakiro Moisés iraantsi, itsikiryaan-takari Israel-iiti, ikantzi: “Iroka iraantsi irootaki ñaakanta-pirotironi ikasiya-kaantakiri Pawa, irootaki kinkithata-kota-chari maaroni aka.” ");
INSERT INTO prq_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Ikanta yapiitajiro Pawa ikantairi Moisés: “Pintonkaajiro otzisi, piyaajina anta. Ari nompimirori mapikota tsika nothapa-takiro noñaani aajatzi nokanta-kaantani, irootaki piyomitaa-yitajiriri pishininka-payi.” ");
INSERT INTO prq_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Ari ikatziyanaka Moisés itsipatakari Josué amitako-tziriri, owitsikanaka ijati yotzisitiki Pawa. ");
INSERT INTO prq_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","Ikantanakiri antari-konapayi: “Ari piyaawakina aka irojatzi nompiyan-tajyaari. Iriitaki saikakayimini Aarón intsipa-tyaari Hur. Tzimatsi-rika kantzimaniinta-wakaa-chani, pinkowa-kotiri irirori yaminako-timiro.” ");
INSERT INTO prq_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Ari itonkaanaji Moisés otzisiki. Opyaawakiri otsitinikitaki minkori. ");
INSERT INTO prq_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","Ari oshawiinka-paaki iwaniinkaro Pawa otsisiki otzisi-masi Kitoochiintoni. Okaratzi 6 kitaitiri ominkorikitaki. Okanta omonkarataka 7 kitaitiri, tzimatsi ñaanata-kiriri Moisés minkoriki. ");
INSERT INTO prq_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","Tima koñaaro iñaayitakiro Israel-iiti iwaniinkaro Pawa, osiyawai-takaro opaamatzi paamari tonkaariki otsisiki. ");
INSERT INTO prq_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Ikyaanta-nakaro Moisés minkori, tonkaanaki otsisiki, ari isaikakiri okaratzi 40 kitaitiri aajatzi 40 tsitiniri. ");
INSERT INTO prq_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","Ari yapiitajiro Pawa iñaanatairi Moisés, ikantziri: ");
INSERT INTO prq_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","“Pamini matironi iwitsikina Tasorintsi-thaanti, ari nosaikiri nontsipatyaari pishininka-payi. ");
INSERT INTO prq_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Pimatiro maaroni tsika onkanta-jaantyaa noñaakaimiro. Pimatiro piwitsikiro Tasorintsi-thaanti, aajatzi onkarati tzimatsini inthompointa. ");
INSERT INTO prq_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","Piwitsiki incha-moko, anaaniintiro apikonati osanthati, anaaniintiro aparoni akonaki okanta-chopinita, aajatzi onkarati ojinokiti. ");
INSERT INTO prq_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","Pintziritan-tyaaro ooro inthompointa aajatzi intakiroki. Piwasi-nampitan-tyaaro ooro onampi-naki. ");
INSERT INTO prq_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","Pintitiro incha-mokoki nopimiri nokanta-kaantani. ");
INSERT INTO prq_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","Piwitsiki otataro piyosiitakiri ooro. Irootaki impaitaitiri iroka otataro Nisironka-mintotsi. Anaaniintiro apikonati osanthati, irooma okanta-chopinita anaaniintiro apakonati. ");
INSERT INTO prq_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","Piwitsiki apiti isiyakaaro siwankiri Maninkari, iriitaki piwakiri apitiroki opatziki otataro. Iriitaki piyosiitiri ooro, niitsikiroini pinkanta-wintyaari pimposhiri piwitsikan-tyaariri. ");
INSERT INTO prq_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","Apatharokyaa onkantyaa piwitsikiro. Ari inkatziyiri apitiroki opatziki apiti siwankiri Maninkari piwitsikakiri. ");
INSERT INTO prq_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","Tima tzinaa siwanki inkatziya-yitaki imontita-wakaakyaa, iriitaki anaanta-kyaaroni isiwanki Nisironka-mintotsi, yaminaki osaawiki. ");
INSERT INTO prq_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","Irootaki pintatan-tyaarori incha-moko, ari pititakirori nokanta-kaantani nopimiri. ");
INSERT INTO prq_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","Ari noñiimiri awiroka anta, ari nonkinkitha-waita-kayimiri nosaikaki Nisironka-minto-tsiki, nosatikan-takyaari apiti siwankiri Maninkari saikain-tsiri otataroki Tasorintsi-moko. Ari nonkaman-timirori onkarati piyomitaa-yitairiri Israel-iiti.” ");
INSERT INTO prq_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","“Piwitsiki minkonchaa-niki, incha-kota payi. Apikonati onkarati osanthati, irooma okanta-chopinita onkarati apakonati, aajatzi ojinokiti anaaniintiro apakonati. ");
INSERT INTO prq_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","Piwayita-jinaro yatantaitari minkonchaa-nikiki, tima iro yatantaitari pasitakaa-piintyaanari kitaitiriki, nosaikapiintzira.” ");
INSERT INTO prq_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","“Iroka onkarati payiri piwitsikan-tyaarori Tasorintsi-thaanti. Tima onkarati 10 iroopirori kithaarintsi, simasirimankitatsiri, jonkiro-maki-tatsiri, kityonka-manki-tatsiri aajatzi. Ari pintsirika-kotirori isiyakaaro siwankiri Maninkari. ");
INSERT INTO prq_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","Iroka onkarati osanthayiti kithaarintsi-payi. Tima onkarati osanthati 28 konakintsi, irooma onii onkarati 4 konakintsi. ");
INSERT INTO prq_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Piwawiti 5 kithaarintsi, tima apamankiro onkanta-nakyaa, pimati piwawiti aajatzi pasini 5 kithaarintsi. ");
INSERT INTO prq_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","Ari pinkanta-kirori aajatzi iwitzi pipira, piwitsiki onkarati 11 kithaarintsi, irootaki pimpasikan-tyaarori Tasorintsi-thaanti. ");
INSERT INTO prq_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","Tima iroka onkarati osanthati aparoni kithaarintsi, onkarati 30 konakintsi. Irooma tsika oniita onkarati 4 konakintsi. ");
INSERT INTO prq_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","Payi onkarati 5 kithaarintsi, piwawitakiro. Pimati pasini onkarati 6 kithaarintsi, piwawitakiro aajatzi. Irootaki pimpasikan-tyaarori Tasorintsi-thaanti. Pitzipiyiro tsika awisapaaki, irootaki pimpasikan-tyaarori tsika inkyaapiin-taitira Tasorintsi-thaantiki. ");
INSERT INTO prq_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","Paaki aajatzi imisina ipiraitari pinthakan-takyaaro kityonkari, iriitaki pimpasikan-tyaarori tasorintsi-thaanti. Payitakyaa imisina nijaa-wiri, iriitaki piwiwiryaakotantyaarori pimpasikan-tyaaro. ");
INSERT INTO prq_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","Payi aajatzi incha-kotapayi omiriki-tyaari tasorintsi-thaanti, tampatzika onkanta-yityaa. ");
INSERT INTO prq_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","Ontzimatyii piwitsikiro tasorintsi-thaanti tsika okantajaanta noñaaka-kimiro otzisiki. ");
INSERT INTO prq_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","Pinthata-sitiro iroopirori kithaarintsi. Intyaani oyotajaan-tziro inkanina-tantyaaro simasirithatatsiri, jonkiro-thatatsiri aajatzi kityonka-thatatsiri. Tima intyaa-kotiro isiyakaaro siwankiri Maninkari. ");
INSERT INTO prq_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","Payi inchapanki piwatzika-sitirori onkarati 4, pitziri-tanta-kyaaro ooro. Piwitsiki aajatzi onkarati 4 ayiintironi tsika piwatzikiro, kiriiki inatyii. Piwitsikaki otsikonti-payi, ooro inatyii. Irootaki pisatikan-tyaarori kithaarintsi pinthata-sitirori. ");
INSERT INTO prq_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","Tima iroka kithaarintsi pithata-sitakirori, irootaki nasityaaroni apinati tasorintsi-thaanti, aparoni tasorin-tsitatsiri, pasini tasorintsi-piro-tatsiri. Ari piwirori Tasorintsi-moko tsika otasorintsi-pirotaki. ");
INSERT INTO prq_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","Pitatan-takyaaro tasorintsi-moko otataro nisironka-mintotsi piwakiri anta tsika otasorintsi-pirotaki. ");
INSERT INTO prq_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","“Piwitsikiro aajatzi pomitai-rontsi paakiro incha-kota, onkarati 5 konakintsi osanthati aajatzi onkarati oniiki, irooma ojinokitzi onkarati 3 konakintsi. ");
INSERT INTO prq_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","Piwitsiki onkarati 4 ochii onampi-naki. Airo payi pasini incha-kota piwitsikiri ochii, tima apakotatyaa onkantyaa. Pintziri-tantyaaro kitirita-tsiri asiro. ");
INSERT INTO prq_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","“Pinkaima-kaantiri pirintzi Aarón aajatzi itomi-payi Nadab, Abiú, Eleazar, Itamar. Tima iriitaki noyosii-takiri ikarajiitaki pishininka Israel-iiti nompira-tasorintsi-tajyaari. ");
INSERT INTO prq_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","Piwitsika-kaantiniri iithaari pirintzi Aarón inkasiya-kairori impira-tasorintsiti. Tima irootaki impinkatha-tantai-tyaariri, iwaniinka-tanakyaa-rika. ");
INSERT INTO prq_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","Pintyaa-kaanti simasirikimaitatsiri kithaarintsi. Irootaki iwiwiryaakotyaari. ");
INSERT INTO prq_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","Piwitsika-kithoyiti pinthata-sitirori opatzi-kiki wiwiryaakorontsi. Paayiti kityonka-thari kirithari, jonkiro-thatatsiri, simasirithatatsiri. Ari pinkimitaakiri aajatzi ooro, piwitsika-nakiyi-takiri, pinthayitiri opatzi-kiki. ");
INSERT INTO prq_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","Pinthati aparoni piwitsika-nakitiri ooro, pinthati aajatzi aparoni piwitsika-kitho-takiri kirithari. Ari pinkanta-kirori maaroni opatzi-kiki, kamiitha pintharakyaa-kiniro. ");
INSERT INTO prq_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","Irootaki inkithaa-tapiin-tyaari Aarón aririka yantajiro impira-tasorintsi-tantari. Aririka inkyii tasorintsi-thaantiki impinkathatiri Pawa, aririka isitowi aajatzi, irootaki inkimaitiri ompoimayiti ithanaki-yitakiri ooro, ari onkantyaa airo ikamanta. ");
INSERT INTO prq_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","Piwitsiki aajatzi ooro-mironta. Iriitaki yosiita-chani ooro piwitsikan-tyaari. Ari pinthapa-takotirori ñaantsi, kantatsini: “Itasorintsiti Pawa”. ");
INSERT INTO prq_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","Pinthato-tantyaaro simasirithatatsiri, piisantiniri yamathairiki, piwakiniri itamakoki. ");
INSERT INTO prq_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","Ari osaikapiin-taatyii yamathairiki itamakoki Aarón, iro onimotakairini Pawa. Tima iriitaki Aarón atsipityaaroni okaratzi iyaaripiro-yitakiro Israel-iiti itasorintsi-takaani Pawa, aajatzi okaratzi yasitakai-tariri Pawa itasorintsi-takaakiri. ");
INSERT INTO prq_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","“Iroka paakowin-tyaari kitaitiriki: Pintayi pomitai-rontsiki apiti ipiraitari tzimatsiri aparoni isarintsiti. Airo piwashaantziro. ");
INSERT INTO prq_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","Pimpomiti aparoni onkitaityaa-manaji, iriima pasini pimpomitiri ontsitiniityaanaji. ");
INSERT INTO prq_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","Yoka ipiraitari pityaari pimpomitiri, pintsipa-tairi yamiroka-pathaitani pankirintsi-pani ijaikitai-takiro apiti pamokoki, intsipa-taitiri aajatzi oyiinka inchakitho ijaikitai-takiri aparoni pachakaki, isaitan-takyaari aajatzi aparoni pachakaki iraitziri. ");
INSERT INTO prq_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","Ari pinkantiriri aajatzi pasini pimpomitiri aririka ontsitiniityaanaki. Pintsipa-tairi itayiitziri pasita-kaariri pankirintsi-pani, aajatzi imiritaitari. Pintayiro okaratzi yasitakai-tariri Pawa onkachaa-ryainkati onkini iñaaposini-tyaaro Pawa. ");
INSERT INTO prq_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","Ari irasi iwiro impomita-jinaro inkarati pincharini-tajyaari ikyaapiintaitzira Tasorintsi-thaanti, tsika anta nontsipa-tajyaami naaka, nonkinkitha-waitakayimi. ");
INSERT INTO prq_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","Ari napatota-piintajyaari nontsipa-tyaari pishininka-payi Israel-iiti. Tima tasorintsi onkanta-kaiyaaro anta nowaniinkaro. ");
INSERT INTO prq_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","Tima tasorintsi nonkanta-kaajiro tasorintsi-thaanti, aajatzi pomitai-rontsi. Ari nonkimitaa-jiriri Aarón aajatzi itomi-payi, tima iriitaki nompira-tasorintsi-taari naaka. ");
INSERT INTO prq_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","Tima nasi nowiro nontsipa-tajyaari incharinin-tajyaari Israel-iiti, naakataki Iwawani-tajyaa. ");
INSERT INTO prq_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","Ari iyotajiri Naaka Iwawani, naaka amajiriri isaikawitaka Apitantoniki nontsipa-tajyaari. Naaka Iwawani.” ");
INSERT INTO prq_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","“Piwitsiki pasini pomitai-rontsi payi incha-kota, irootaki intaantai-tyaari kasankari. ");
INSERT INTO prq_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","Omonkara-tawakaiyaa onampi-naki, onkarati aparoni konakintsi osanthati onampina-payi. Irooma ojinokiti onkarati apiti konakintsi. Airo payi pasini incha-kota piwitsikiri ochii, tima apakotatyaa onkantyaa. ");
INSERT INTO prq_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","Iriitaki yosiita-chani ooro pintziri-tantyaaro ominkota, onampina, aajatzi ochii-payi. Piwasi-thapi-tantyaaro ooro onampi-naki-payi. ");
INSERT INTO prq_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","Piwakiro pomitai-rontsi anta tsika ithatasii-takiro kithaarintsi tasorintsi-moko, omontityaaro otataro nisironka-mintotsi, tsika noñaapiin-timiri awiroka anta. ");
INSERT INTO prq_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","Ari intaapiin-tajirori Aarón kapichikitaitiri kasankari, aririka ijati yaminiri ootamintotsi. ");
INSERT INTO prq_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","Yapiita-panaatiro Aarón aririka ontsitiniityaanaji intayiro kasankari, aririka yoisa-panaatiri ootamintotsi. Irasi iwiro inkarati pincharini-tajyaari yantajinaro iroka. ");
INSERT INTO prq_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","Aparo-satzi osarintsiki isaitan-tajyaaro Aarón iriraani yatsipi-takaani ochii-payi pomitai-rontsi, inkini impyaakoitiro ikaaripiroitaki. Aparo-satzi aajatzi osarintsiki impomitaiti yatsipi-takaani impyaakoi-tantyaarori iyaari-pironka inkarati pincharini-tajyaari. Tima tasorintsi ikantakaakaro Pawa iroka pomitai-rontsi.” ");
INSERT INTO prq_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","Ari yapiitajiro Pawa ikantairi Moisés: ");
INSERT INTO prq_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","“Pinkinkitha-waitakairi awiroka pishininka, pinkantiri: ‘Pimpinkathatiro kitaitiri imako-ryaan-taitari, tima irootaki pinkinkithasiri-tapiin-tajiri awirokaiti aajatzi naaka aririka awisayiti osarintsi-payi, iro iyoitan-tyaari naaka Pawa kitisiri-yitajimiri awirokaiti. ");
INSERT INTO prq_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","Piita-tasorintsi-tajiro iroka kitaitiri imako-ryaan-taitari, pinkatha piwajiro. Inkarati thainka-kironi iroka kitaitiri, iwaitiri. Inkarati antawai-tantyaaroni iroka kitaitiri, airo itsipataari ikarajiitzi, impyaakai-takyiiyaari. ");
INSERT INTO prq_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","Kantatsi pantawaiti onkarati 6 kitaitiri. Irooma kitaitiri 7, piita-tasorintsi-tajiro, pimairi-tanta-jyaaro pinkinkithasiri-tajina Naaka. Tzimatsi-rika antawai-tantyaaroni iroka kitaitiri, iwaitiri.’ ");
INSERT INTO prq_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","Tima pinkatha iwajiro pishininka-payi iroka kitaitiri imairitan-taitari, irootaki imairi-minto. Irasi iwiro osarintsiki-payi inkasiyakainaro Naaka. ");
INSERT INTO prq_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","Asi owajiro inkinkithasiri-tapiin-tajina pishininka-payi, isiri-tajyaana Naaka.” Tima 6 kitaitiri yantawaitaki Pawa iwitsikan-takarori inkiti aajatzi kipatsi, irooma kitaitiri 7, ari ithonkatakiro yantawaitaki, imako-ryaaki. ");
INSERT INTO prq_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","Ikanta ithonkatakiro Pawa ikinkitha-waitakairi Moisés otsisiki Kitoochiintoni, ipakiri apiti mapikota tsika ithapatan-takaro Pawa irakoim-piki Ikantakaantani. ");
INSERT INTO prq_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Ikanta iñaakiro Israel-iiti osamani ikantaka Moisés ti yoirinkajiro otzisi, yapatowin-takari Aarón, ikantakiri: “Piwitsikina siyakaa-rontsi nowawani-tajyaari, iriitaki jiwatajinani. Tima ti ayojiiti opaita-rika antakiriri Moisés, amayitajairi asaikawita Apitantoniki.” ");
INSERT INTO prq_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Ari yakanaki Aarón, ikantanakiri: “Pamakinari aka maaroni ooro athayitiri oyimpitaki piinapayi, pitomipayi aajatzi pisintopayi.” ");
INSERT INTO prq_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Ithonka yaitakiri ooro ikaratzi ithatai-tziri iyimpitaki, yaana-kiniri Aarón. ");
INSERT INTO prq_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Tima iwiyaatakiri maaroni ooro. Iwinaa-sitakiri, ikimita-kaakari yanini ipiraitari. Ikantajiitzi Israel-iiti: “¡Ashininká! Yoka awawani amayitajairi asaikawitaka Apitantoniki.” ");
INSERT INTO prq_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Ikanta iñaakiro Aarón kantain-chari, iwitsikaki aajatzi Aarón pomitai-rontsi tsika isaikaki isiyakaaro yanini ipiraitari. Ikaimajiitzi sintsiini Israel-iiti, ikantzi: “Onkitaiti-tamanaji aimosirinkyaa ampinkathatiri Pawa.” ");
INSERT INTO prq_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Ikanta ipiriin-tamanaja okitaiti-tamanaji, ipomita-kiniri ipira-payi, aajatzi okaratzi yasitakaariri yaapatyaan-tajyaariri. Ari iwawaijiita atziri, yirawai-jiitzi, ikimosiriwinta-jiitaka. ");
INSERT INTO prq_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Ikantajiri Pawa yoka Moisés: “Pijataji otaapiki, tima kaaripirotaki pishininka-payi pamajiri isaikawitaka Apitantoniki. ");
INSERT INTO prq_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","Tima sintsini iwashaan-tanakiro nokantziriri yantiro. Iwitsikaki isiyakaaro yanini ipiraitari. Iriitaki ipinkathatzi, ipomita-kiniri yatsipi-takaani-payi. Ikantajiitzi: ‘¡Ashininká! Yoka awawani amayitajiri asaikawita Apitantoniki.’ ” ");
INSERT INTO prq_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Aikiro iñaawai-tatzii Pawa ikantziri Moisés: “Noyosiri-takiri pishininka-payi, piyathari inayitatzii. ");
INSERT INTO prq_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","¡Antaro iwatsimaakina iroñaaka, ontzimatyii napirotiri! Irooma awiroka aritaki noshikyaa-kimiri inkarati pincharini-tajyaari.” ");
INSERT INTO prq_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Irootaki yamanan-tanakari Moisés, ikantzi: “¡Pawá! ¿Ipaitama ayimatan-tamiri pimasirinka pinintzi papirotiri pasitari awiroka, tima iriitaki pamajiri awiroka isaikawitaka Apitantoniki, piñaakan-takiro pisintsinka pamantaariri? ");
INSERT INTO prq_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Tima ari inkanta-jiitanaki Apitantoni-satzi: ‘Tima iitaimpyatyaa Pawa yaantariri, inintzi yapirotiri iwamairi otzisi-masiki airo itzimantaja aka kipatsiki.’ Piitsimaryiiyaa, pinkaratiro okaratzi pikisakiri pasitari awiroka. ");
INSERT INTO prq_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Pinkinkithasiri-takotajiri pimpiratani-payi Abraham, Isaac, aajatzi Israel. Tima pimpairyaa-kityaa awiroka pikantakiri: ‘Omapiro noshikyaa-jimiri inkarati pincharini-tajyaari inkimita-jyaari impokiro-payi inkitiki, iriitaki asitajyaaroni maaroni iroka kipatsi nokasiya-kaakimiri, asi iwiro yasita-jyaaro iriroripayi.’ ” ");
INSERT INTO prq_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Ari iwashaan-tziro Pawa okaratzi ikantawi-takari yapirota-jirimi ikaratzi yasitari irirori. ");
INSERT INTO prq_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Ari yoirinkajari Moisés, yamaji apiti mapikota tsika osankinataka ñaantsi, tima apitiroiti osankinataka intakironta. ");
INSERT INTO prq_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","Iriitaki Pawa witsikakiro mapikota, irijatzi Pawa thapatakiro okaratzi osankina-tainchari mapikotaki. ");
INSERT INTO prq_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Ikanta ikimapajiri Josué ikaimajiitzi ishininka-payi, ikantziri Moisés: “Pinkimi ikaimajiitzi ashininka-payi kimitaka iwayiri-taitatyaa anta awanko-thaantiki.” ");
INSERT INTO prq_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Ari yakanaki Moisés, ikantzi: “Ipanthaa-jiitatzii nokimakiri naaka. Tima kaari kaimaantsi yiitsinampaitiri iwayiri-taityaari, kaari aajatzi kaimaantsi yiitsinampairi iwayiritani.” ");
INSERT INTO prq_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Ikanta yariitapaja Moisés iwanko-thaanti-jiitaka ishininka-payi, iñaatziiri isiyakaaro yanini ipiraitari, iriitaki ikimosiriwinta-jiitziri. Antaro ikisanaka, yookapaakiro mapikota tsika otonkai-matanaka otzisi, othonka otankawai-tapaaki. ");
INSERT INTO prq_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Yaapaakiri isiyakaaro yanini ipiraitari, itaakiri. Ipoñaa itononkakiri ipoowi-pani-takiri, iwiinka-wani-takiri nijaaki. Irakaakiri ishininka-payi. ");
INSERT INTO prq_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Ari isampitakiri Aarón, ikantziri: “¡Iyí! ¿Tsikama ikantakimika awiroka yokaiti ashininka-payi panta-kaantariri iroka antaroiti kaari-pirotaantsi?” ");
INSERT INTO prq_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Akanaki Aarón ikantzi: “¡Jiwarí! Airo pikisana. Piyotziri awiroka ashininka-payi oshiki iniwiki-takaro kaari-pirori. ");
INSERT INTO prq_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Tima iriitaki kantakinari: ‘Piwitsikina siyakaa-rontsi nowawani-tajyaari, iriitaki jiwatajinani. Tima ti ayojiiti ipaita-rika antakiriri Moisés, amajairi asaikawita Apitantoniki.’ ");
INSERT INTO prq_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Nokanta-nakiri naaka: ‘Ikaratzi itzimimo-tziri ooro, yamakinari.’ Imatakiro ipakinari ooro, notaakiri paamariki, ari iwitsika-nakari isiyakaaro yanini vaca.” ");
INSERT INTO prq_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Ikanta iñaakiri Moisés ti inkanta-pirotaji ishininka-payi, oshiki ithain-kawai-takiri iisaniintani. Ti imatajiro Aarón iyomitaa-yitanajiri. ");
INSERT INTO prq_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","Jataki tsika okyaapiinta awotsi inampi, ikantzi: “Ikaratzi awintaariri Pawa, impoki nokatziyaka naaka.” Tima iriitaki oyosiitaincha maaroni Leví-iti ijataki tsika ikatziyaka Moisés, itsipata-paakari. ");
INSERT INTO prq_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","Ikantakiri Moisés: “¡Ashininká! Iroka ikantzi Pawa, Iwawani Israel: ‘Payi aparo-payi awiroka piwisa-minto, pimpiyi piwanko-thaantiki, pinkyaayiti maaroni pankotsiki, piwamairi pirintzi, paapatyaani, aajatzi pishininka-payi.’ ” ");
INSERT INTO prq_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Imatakiro Leví-iti ikantakiriri Moisés. Tima inkarati 3000 ishininka iwamaakiri. ");
INSERT INTO prq_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Ari ikantzi Moisés: “Pimajii-takiro awirokaiti piwitsika-siri-wintaari Pawa, irootaki intasonka-wintantyaamiri, tima pimatakiro pimpira-tasorintsi-yitantari aparoni-payi awiroka pikimisan-takiri Pawa pakota-siyitakiri pitomi-payi aajatzi pirintzi-payi.” ");
INSERT INTO prq_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Okanta okitaiti-tamanaji, ikantakiri Moisés ishininka-payi: “Tima antaroiti pikaaripirotaki awirokaiti. Iroñaaka nojati otsisiki isaiki Pawa, onkamintha yaripiro-taimi.” ");
INSERT INTO prq_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Jataki Moisés isaiki Pawa, ikantapajiri: “Antaroiti ikaaripirotaki noshininka-payi, iwitsikakiri ooro, iriitaki iwawani-takari. ");
INSERT INTO prq_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Nokowako-tzimi paripiro-tairi ikaaripirotaki. Airorika paripiro-tairi, pishita-jinaro nowairo tsika pisankina-takotakina.” ");
INSERT INTO prq_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Ari yakanakiri Pawa yoka Moisés, ikantziri: “Apatziro noshita-kotajiri ikaratzi kaaripiro-tzimotanari naaka. ");
INSERT INTO prq_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Pimpiyi awiroka, paanajiri pishininka-payi tsika nookota-kimiro. Iriitaki jiwatimini Nomanin-kariti. Iro kantacha, aririka omonkara-tajyaa apaata nowasankitaantaji, aripaiti nowasankitaa-wintajiri iyaari-pironka.” ");
INSERT INTO prq_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Tima ikantakaakaro Pawa, ithonka imantsiya-tanaki Israel-iiti okantakaaro ipinkatha-takiri isiyakaaro yanini ipiraitari iwitsikakiri Aarón. ");
INSERT INTO prq_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Ari iñaanatajiri Pawa yoka Moisés, ikantairi: “¡Moisés! Paminaji awiroka apiti mapikota osiyaaro nopawita-kamiri, ari nonthapa-ta-jirori noñaani nothapawi-takari itarori mapikota pikotaakiri. ");
INSERT INTO prq_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Pananinki onkitaiti-tamanaji pintonkajiro otzisi Kitoochiintoni. Pimpoki ojinoki-pirotzi otsisi tsika nosaiki naaka. ");
INSERT INTO prq_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Apaniroini pimpoki, airo itzimawaitzi aniitatsini anta otzisiki, airo ikiinawaitzi ipiraitari-payi.” ");
INSERT INTO prq_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Yaaki Moisés apiti mapikota, iroowai-witaka itakarori ipawitakari. Okanta okitaiti-tamanaji, ananinkanaka yaanakiro apiti mapikota, itonkaanaki otzisiki Kitoochiintoni, imatakiro okaratzi ikantakiriri Pawa. ");
INSERT INTO prq_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Ari yayiita-paaki Pawa minkoriki, itsipata-paakari Moisés, ipairyaa-paaka Pawa, ikantzi: “¡Naakataki!”. ");
INSERT INTO prq_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Tima ikatziyi-motapaakari okaakiini Moisés, ikaimapaaki sintsiini ikantzi: “¡Naakataki Pawa! Sintsi-pirori, kaminthaan-taniri, nisironka-tantaniri, tsinampari, itakoki-tantaniri, iriipirori. ");
INSERT INTO prq_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","Nasi nowiro nitakotaari maaroni, nonthonkajiri nitakota-jyaari inkarati incharini-tajyaari. Nopyaako-tajiniri iyaari-pironka, ikinasi-waitaka, ipiyatha-waitani. Iro kantacha ti nomatiri nowasankitairi antzirori kaari-pirori, nothonkiri nowasankitaa-wintziri iyaari-pironka asitariri, icharini, itomi icharini-tanakari irirori, maaroni.” ");
INSERT INTO prq_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Tima sintsiini ityiirowanaka Moisés, oiyootanaka kipatsiki ipinkatha-tanakiri Pawa. ");
INSERT INTO prq_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","Ikantanaki: “¡Pawá! Omapiro-rika paakamiithatina, pintsipa-tajyaana nokarajiitaki. Tima yoka noshininka-payi thainka-waitaniri inayitzi. Iro kantacha nonintzi pimpyaako-tajinaro nokaaripiro-yitaki. Pinkimi-takaan-tajina awirokami asitaanari.” ");
INSERT INTO prq_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Ikantzi Pawa: “Pinkimi nonkantimiri. Tzimatsi nonkasiyakairiri pishininka-payi Israel-iiti, aritaki iñaayitajiro maaroni iriroripayi. Tima nantatyiiro kaari iñiitzi pairani aka kipatsiki, kaari iñiitzi pasiniki nampitsi. Tima inthonka iñiiro atziri-payi pisaiki-motajiri onkarati yantajiri Pawa, antaro onatyii onkarati noñaaka-jimiri maaroni awirokapayi.” ");
INSERT INTO prq_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Aikiro ikantana-kitzii Pawa: “Pantiro onkarati nonkantimiri. Aritaki piñaakina nomisitowajiri Tonkaarisatzi, Owintini-satzi, Tharowan-taarini-satzi, Nampitsi-wini-satzi, Thaantiwinisatzi, Kayaawinisatzi. ");
INSERT INTO prq_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Paamaiyaa paapatyaari = kari nampiyi-tarori aka tsika nookota-kimiro, yamatawi-tzimi = kari, tima osiyakaro owiirintsi yamatawi-minto. ");
INSERT INTO prq_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","Pimporoka-pithatiri ipomi-pirini-minto-payi, pimporoki-tiniri iwawa-niroti, pinthonkiri osiyakaaro-payi Inkaariwiro. ");
INSERT INTO prq_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","Airo pipinkatha-waitziri pasini-yitatsiri pawaniro-payi, tima yoka Pawa aamaawai-taniri inatzii, irootaki owaitakaan-tziriri ikantan-taitariri Pawa Aamaako-tantaniri. ");
INSERT INTO prq_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","Paamaiyaa aajatzi paapatyaari = kari nampiyi-tarori kipatsiki tsika pisiritakaro, imatakayimiro = kari yatsipirya-wajiita ipinkatha-tziri iwawa-niroti, ipomitziniri yatsipi-takaani-payi, pakyootziri = kari iyaari iwapithatari tzimaaran-tatsiri iwatha kaari ipomitzi. ");
INSERT INTO prq_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","Paamaiyaari ikaimiri = kari pitomi-payi yaakairi irisinto-payi. Tima aririka omayimpi-waiti opinkatha-witari owawa-niroti-payi, ari imatanakiro aajatzi pitomi-payi yatsipi-ryaawai-tyaari impinkathatiri irirori pawaniro-payi.” ");
INSERT INTO prq_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Osamani isaikaki Moisés itsipatari Pawa okaratzi 40 kitaitiri aajatzi 40 tsitiniri. Ti iwajyaa, ti yiraji nijaa. Ari ithapata-kirori ñaantsi-payi mapikotaki tsika okantakota ikasiyakaa-wakaitani. Tima irootaki iroka Ñaantsi karatatsiri 10. ");
INSERT INTO prq_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Ipoñaa yoirinkaja Moisés ipoñaajaro otzisiki Kitoochiintoni yamajiro apikotati mapi osankinataka Ikantakaan-taitani. Ikanta yoirinkaja Moisés, ti iyoti siparyaa okantaka iworo okantakaaro ikinkitha-waita-kaakiri Pawa. ");
INSERT INTO prq_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Ikanta iñaawajiri Aarón aajatzi Israel-iiti, isiparyaaki, antaroiti itharowan-tajiitakari, ti yatzirin-tawajyaari. ");
INSERT INTO prq_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Iro kantacha ikaimapajiri Moisés. Ari ipokapaakiri Aarón aajatzi jiwari-payi isaikaki Moisés, ikinkitha-waita-kaawakiri. ");
INSERT INTO prq_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Iro osamanitaki kapichiini, ipokajiita-paaki Israel-iiti, ikamantakiri Moisés okaratzi yantiri tima irootaki ikamanta-kiriri Pawa otzisiki Kitoochiintoni. ");
INSERT INTO prq_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Ikanta ithonka-kiro Moisés ikamantziri Israel-iiti, ipasika-porota-nakaro jinta-masiri. ");
INSERT INTO prq_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Tima inkyaa-piintzira Moisés Tasorintsi-thaanti inkinkitha-waita-kairi Pawa, ipasikaryaa-porota irojatzi inthonkan-takyaarori ikinkitha-waitzi. Ikamanta-tzimaitari Moisés atziri-payi okaratzi ikantakiriri Pawa. ");
INSERT INTO prq_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","Ikanta iñaawajiri Israel-iiti isiparyaa-porotzi Moisés, yapiita-najiro Moisés ipasika-porotaro jinta-masiri, irojatzi ikyaantakari inkinkitha-waita-kairi Pawa. ");
INSERT INTO prq_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","Ikanta Pawa iñaanatajiri Moisés, ikantairi: ");
INSERT INTO prq_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","“Aririka omonkarata-pajyaa itarori kitaitiri itapiintarori kasiri, aripaiti piwitsikirori Tasorintsi-thaanti. Tima iroka Tasorintsi-thaanti aritaki yapatowinta-piintyaanari Israel-iiti. ");
INSERT INTO prq_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","Arira paakotiriri yiinkantsi piwitsikakiri pisaitan-tantyaari, iro iñiitan-tyaarori okaratzi nasitari naaka. Iro yiinkantsi pisaitan-tantyaarori Tasorintsi-thaanti, aajatzi okaratzi tzimayita-tsiri inthompointa. Tima tasorintsi onkanta-yityaa. ");
INSERT INTO prq_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Impoña pisaitan-tyaaro yiinkantsi pomitai-rontsi ikachaa-ryiinkata-kayi-tziri yatsipita-kaitani. Ari pinkimitaakiro okaratzi yasitakai-tarori. Irootaki pasitakai-yaanari, tima tasorintsi-piro onkantyaa. ");
INSERT INTO prq_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Ari pinkimitaa-kirori kiwamintotsi aajatzi osaikantari, pisaitan-tyaaro yiinkantsi. Irootaki pasitakai-yaanari. ");
INSERT INTO prq_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","Impoña paanakiniri Aarón aajatzi itomi-payi ikyaa-piintai-tzira Apato-mintotsi, ari pinkiwaa-yityaari anta. ");
INSERT INTO prq_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","Ari pinkithaatiriri anta Aarón iroopirori iithaari. Impoña pisai-patzii-totan-tyaari yiinkantsi, pasitakai-yaanari, tima iriitaki nompira-tasorintsitaa-riti. ");
INSERT INTO prq_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","Ompoña pinkaimakiri itomi-payi, pinkithaa-yitakiri irirori kithaaritsi-payi. ");
INSERT INTO prq_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","Ari pisaitan-tyaari yiinkantsi, pikimitaakiri iriri, iriiyitaki pasitakai-yaanari nompira-tasorintsitaa-riti. Tima pisaitan-tayitakari yiinkantsi, irasi iwiro inkarati incharinita-jyaari nompira-tasorintsitaa-rita-jyaari.” ");
INSERT INTO prq_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Yantakiro Moisés okaratzi ikantakiriri Pawa. Imatakiro maaroni. ");
INSERT INTO prq_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","Tima awisaki aparoni osarintsi isitowantaitaari Apitantoniki, aripaiti ithonkai-takiro iwitsikai-takiro Tasorintsi-thaanti. ");
INSERT INTO prq_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Ari omapoka-sitaka itzikaapaakiro minkori Tasorintsi-thaanti, tima osaikan-tapaakaro iwaniinkaro Pawa.");
INSERT INTO prq_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","Ari iñaanatajiri Pawa yoka Moisés, isaikaki tasorintsi-thaantiki, ikantajiri: ");
INSERT INTO prq_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","“¡Moisés! Pinkinkitha-waitakayiri pishininka-payi Israel-iiti, pinkantiri: ‘Aririka pimpiri Pawa pasita-kaariri, pamakiniri pi-vaca-ti, airorika pamakiniri poishati. ");
INSERT INTO prq_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","Iriirika vaca pasita-kaariri katziyain-katatsini iyachaarinka pimpomitiri, sirampari inatyii, airo ikaari-piro-waitzi. Tima iriitaki ookimotyaarini Pawa pimpomi-takiniri ikyaapiintaitzira tasorintsi-thaantiki. ");
INSERT INTO prq_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","Pairikai-natiri katziyain-katatsini iyachaarinka pipomitani, tima iriitaki ookimotyaarini Pawa impyaako-tanta-jyaamiri pikaaripirotaki. ");
INSERT INTO prq_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","Piwamairi pipira tasorintsi-thaantiki. Yayimai-tyaaro itomi-payi Aarón, Ompira-tasorintsi-taari, iriraani pipira yasitakai-yaari Pawa, intsikiryaan-takyaaro onampi-naki-payi pomitai-rontsi osaikira ikyaapiintaitzira Tasorintsi-thaanti. ");
INSERT INTO prq_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","Aririka piwamaakiri, piimiryiiri, pintoyitiro maaroni iwatha. ");
INSERT INTO prq_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","Iriima itomi-payi Ompira-tasorintsi-taari Aarón, iriitaki oisatsini paamari pomitai-rontsiki, iriitaki piwiryiironi tsitsi-payi paamata-tsini. ");
INSERT INTO prq_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","Irijatzi itomi-payi Aarón Ompira-tasorintsi-taari, wankita-kirini iwatha ipira opaamatanaki tsitsi, intsipataakiri iito, aajatzi iyiinka-payi. ");
INSERT INTO prq_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","Awirokataki kiwironi ishiito-payi, aajatzi ipori-payi. Impomi-tzimai-tyaari Ompira-tasorintsi-taari pomitai-rontsiki. Katziyainka onkantyaa iyachaarinka itaara. Irootaki ookimotyaarini Pawa iñaaposini-tajyaari yasitakayi-tariri. ");
INSERT INTO prq_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","Iriirika oisha, iriirika cabra pasita-kaariri Pawa katziyain-katatsini iyachaarinka pimpomi-takiri, sirampari inatyii, airo ikaaripirowaitzi. ");
INSERT INTO prq_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","Piwamainiri Pawa tsika okatonko-tzira pomitai-rontsi. Yayimai-tyaaro itomi-payi Aarón, Ompira-tasorintsi-taari, iriraani ipiraitari intsikiryaan-takyaaro maaroni onampi-naki-payi pomitai-rontsi. ");
INSERT INTO prq_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","Ari pintoyi-takiri maaroni iwatha, iito aajatzi iyiinka-payi. Yayimai-tyaari Ompira-tasorintsi-taari, iwankitakiri opaamataki paamari pomitai-rontsiki. ");
INSERT INTO prq_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","Awirokataki kiwironi ishiito-payi, aajatzi ipori-payi. Impomi-tzimai-tyaari Ompira-tasorintsi-taari iwankitakiri pomitai-rontsiki. Katziyainka onkantyaa iyachaarinka itaara. Irootaki ookimotyaarini Pawa iñaaposini-tajyaari yasitakayi-tariri. ");
INSERT INTO prq_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","Iriirika siwankiri pasita-kaiyaariri katziyain-katatsini iyachaarinka pimpomi-takiri, pamakiniri, tookitzi, airorika yanini siro. ");
INSERT INTO prq_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","Iriitaki Ompira-tasorintsi-taari asitakai-yaariri Pawa. Inthatzinkakiri iitoki, impitinkan-takyaaro iriraani maaroni onampi-naki pomitai-rontsi, intaakiri pomitai-rontsiki. ");
INSERT INTO prq_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","Paawakiro ishino-kitziro iwariti, aajatzi isiwanki-payi. Pookakiro onampi-naki pomitai-rontsi isitowakirotzira ooryaatsiri, tsika opiyotaka isamampori ipomitaitani. ");
INSERT INTO prq_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","Pintankakiri iniiki, pimpishiiryaakiri airo pithatyaa-maitari. Impomi-tzimai-tyaari Ompira-tasorintsi-taari pomitai-rontsiki. Katziyainka onkantyaa iyachaarinka itaara. Irootaki ookimotyaarini Pawa iñaaposini-tajyaari yasitakayi-tariri. ");
INSERT INTO prq_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","Iroorika pankirintsi-pani pamaki pasita-kaiyaari Pawa, pamaki iroopirori opani, pinkonowakiro yiinkantsi aajatzi kasankari. ");
INSERT INTO prq_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","Pamakiniri itomi-payi Aarón, Ompira-tasorintsi-taari. Yawii-panitaki kapichi pikonowa-kirori yiinkantsi, aajatzi kasankari. Impomitakiro pomitai-rontsiki. Irootaki ookimotyaarini Pawa iñaaposini-tajyaaro ipomitai-takiniri yasitakayi-tariri. ");
INSERT INTO prq_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","Onkarati tzimaa-rantanain-tsini opani pasita-kaariri Pawa, tasorintsi-pani onatzii. Iriitaki owajyaaroni Aarón aajatzi itomi-payi. ");
INSERT INTO prq_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","Yapiitajiro Pawa iñaanatajiri Moisés aajatzi Aarón, ikantairi: ");
INSERT INTO prq_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","“Pinkinkitha-waitakayiri pishininka-payi Israel-iiti, pinkantiri: ‘Yoka antami-wiri-payi ikaratzi tzimatsiri kipatsiki kamiitha-tatsiri piyaari. ");
INSERT INTO prq_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","Tima maaroni posiniri tsipatzirori ishitaki, oipyiirori iwariti iniyawi-takaro, inaatajiro kamiitha onkini iniyajiro, ti impinkaitiri yokapayi, kamiitha-tatsi iwaityaari. ");
INSERT INTO prq_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","Iriima ikaratzi ikyaakoitari, tsipawi-tarori ishitaki, kaari oipyiirori iwariti inaapirotiro iniyantyaarori, ti inkamiithati piyaari, piwinkani piwiri. ");
INSERT INTO prq_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","Ari ikimitari osiyawi-tariri kochiro, kaari oipyiirori iwariti inaapirotiro iniyantyaarori, titzimaita ontsipati ishitaki, piwinkani piwiri. ");
INSERT INTO prq_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","Ari ikimitzitari osiyawi-tariri samani, kaari oipyiirori iwariti inaapirotiro iniyantyaarori, ti ontsipati ishitaki, piwinkani piwiri. ");
INSERT INTO prq_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","Aajatzi ikimitari chancho, tsipawi-tacha ishitaki, ti yoipyiiro iwariti inaapirotiro iniyantyaarori, piwinkani piwiri. ");
INSERT INTO prq_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","Airo piwayitari yoka posiniri, airo okantaa-jatzi pairikiri inkami-rika, piwinkani piwiri. ");
INSERT INTO prq_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","Yoka nijaa-wiri-payi saikantarori nijaa-payi, iriitaki kamiitha-tatsiri piyaari ti impinkaitiri. Tima maaroni tzimatsiri ipitaisi, aajatzi ipintaki, ikaratzi saikantarori inkaari aajatzi nijaa-payi, ti impinkaitiri yokapayi, kamiitha-tatsi piyaari. ");
INSERT INTO prq_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","Iriima kaari tzimatsini ipitaisi-payi, ipintaki-payi saikantarori inkaari aajatzi nijaa-payi, ikaratzi saikantarori inthomoyaaki nijaa, piwinkani piwiri. ");
INSERT INTO prq_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","Airo piwayitari yokapayi, piwinkani inatyii. Airo pairikiri aririka inkamayiti. ");
INSERT INTO prq_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","Tima piwinkani piwayitajiri maaroni nijaa-wiri kaari tzimatsini ipitaisi-payi, aajatzi ipintaki-payi. ");
INSERT INTO prq_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","Yoka siwankiri-payi inkarati pimpinka-yitajiri, kaari kamiitha-tatsini piyaari: pakitha, aro, simakowari, ");
INSERT INTO prq_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","tziso, ikaratzi osiyayi-tariri sirontzi, ");
INSERT INTO prq_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","ikaratzi nasiyita-chari koontzi-niro, ");
INSERT INTO prq_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","ikaratzi kimiyitariri mamaro, oshitotsikoo, chiripito, ikaratzi kimiyitariri pakitha, ");
INSERT INTO prq_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","poompootzi, tsipawairo, thoororo, ");
INSERT INTO prq_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","sanantzi, pachaka, amimpori, ");
INSERT INTO prq_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","thompari, ikaratzi kimiyitariri sanantzi, tsimpi, piiri. ");
INSERT INTO prq_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","Tima piwinkani iinayitaji maaroni inarapaki tzimatsiri isiwanki, tzimatsiri iitzi-payi yaniitantari. ");
INSERT INTO prq_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","Iriima maaroni osiyariri inarapaki tzimatsiri ipori, mitaachari, airo pipinka-yitziri piyaari. ");
INSERT INTO prq_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","Yoka inkarati piyaari: ikaratzi kimiyitariri tsitsiri, pitziro, tsinaro, kintori. ");
INSERT INTO prq_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","Iriima pasini-payi ikaratzi kaari apairyaaki inarapaki-witachari, arawita-chari, aniitatsiri, piwinkani piwiri. ");
INSERT INTO prq_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","Iroka-payi pasini matironi owitsintimi. Itzimi-rika airikakirini ikamayitzi iwinkaitani antami-wiri, iwinkaitani inkantyaa irojatzi tsitiniriki. ");
INSERT INTO prq_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","Itzimi-rika antakironi kapichiini iwatha kaminkari antami-wiri, ontzimatyii inkiwajiro iithaari, iwinkaitani inkantyaa irojatzi tsitiniriki. ");
INSERT INTO prq_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","Tima ti inkamiithati piwayityaari ikaratzi konthaa-chari kipatsiki, konthaa-yitatsiri kipatsiki, ontzima-wityaa iitziiriki-payi, piwinkani iinayiti. ");
INSERT INTO prq_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","Piwinkani inatyii ikaratzi konthaa-yitatsiri kipatsiki, ikaratzi kamatha-yitatsiri, tima aririka pairikakiri, iwinkaitani pinana-kitzii awiroka. ");
INSERT INTO prq_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","Tima Naaka Piwawani. Kitisiri pinkantajyaa awiroka-payi, tima kitisiri nokanta naaka. Ti onkamiithati iyaaripiro-waitimi antami-wiri-payi ikaratzi konthaa-yitatsiri kipatsiki. ");
INSERT INTO prq_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","Naakataki Pawa, naaka oimisitowa-jimiri Apitantoniki Piwawani-tajyaana. Kitisiri pinkantajyaa, tima kitisiri nokanta naaka.” ");
INSERT INTO prq_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","Irootaki iroka ñaantsi iyomitaan-tziri Pawa tsika ikantakota antami-wiri-payi, tsimiri-payi, maaroni añaayita-tsiri nijaaki, maaroni konthaa-yitatsiri kipatsiki. ");
INSERT INTO prq_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","Ari piyotajiriri ikaratzi ipinkai-tziri aajatzi ikaratzi kamiitha-yitatsiri. Ikaratzi iwaitari aajatzi kaari iwaitari. ");
INSERT INTO prq_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","Ari iñaawaitaki Pawa, ikantziri Moisés: ");
INSERT INTO prq_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","“¡Moisés! Piyomitairi pishininka-payi Israel-iiti, pinkantiri: ‘Aririka omotyaati kooya, sirampari iinchaa-niki owaiyan-takiri, iwinkaitani onatyii onkarati 7 kitaitiri. Ari osiyaaro ipinkai-tziro iyowapiintzi okooya-tantari iroori. ");
INSERT INTO prq_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","Aririka imaakota-paaki 8 kitaitiri itziman-takari iinchaa-niki, intomisi-taani-taitakiri. ");
INSERT INTO prq_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","Irooma kooya iriniro iinchaa-niki, ontzimatyii omairintyaa iroori onkarati 33 kitaitiri, irojatzi ompyaan-tajyaari iraani. Tima airo okamiithatzi airikajiro itasorintsi-takaitani-payi, airo okyaaji tasorintsi-thaantiki, irojatzi omonkaratan-takyaarori kitaitiri omairintyaa. ");
INSERT INTO prq_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","Iroorika owaiyanti kooya iinchaa-niki, iwinkaitani onatyii onkarati 14 kitaitiri. Ari osiyaaro ipinkai-tziro iyowapiintzi okooya-tantari iroori. Tima ontzimatyii omairintyaa onkarati 66 kitaitiri, irojatzi omonkaratan-takyaarori kitaitiri omairinta. ");
INSERT INTO prq_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","Aririka omonkaratairo omairi-wintari iinchaaniti sirampari, tirika kooya iinchaa-nikiti, ontzimatyii ayiniri Ompira-tasorintsi-taari aparoni ipiraitari tzimain-tsiri aparoni isarintsiti, ayiniri aajatzi yanini siro, tirika aparoni tookitzi. Iriitaki katziyain-katatsini iyachaarinka impomitakiri ikyaapiintaitzira tasorintsi-thaanti inkini yaripiroi-tajyaaro. ");
INSERT INTO prq_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","Iriitaki yaanakiri Ompira-tasorintsi-taari, impomita-kiniri Pawa tasorintsi-thaantiki yaripiroi-tairo kooya. Ari omonkarataari okaratzi omairinta ositowaki iraani.’ ” Irootaki iñaani Pawa iroka. Irootaki asi kooya-payi tzimayi-tatsiri iinchaa-niki sirampari, tirika kooya. ");
INSERT INTO prq_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","Airorika imonkarata amanantan-tyaari ipiraitari, kantatsi amananti apiti tookitzi, tirika apiti yanini siro. Iriitaki Ompira-tasorintsi-taari matironi yaripiro-takaan-tajiro iroori, kitisiri-tanaji. Tima impomitaki aparoni yaripiro-tantai-tyaarori kooya. Iriima pasini katziyainka iyachaarinka impomitai-takiri.” ");
INSERT INTO prq_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","Ari yapiitajiro Pawa iñaanatajiri Moisés, tima aritaki kamaki apitiro itomi Aarón okantakaaro itsitokakaro tsika isaiki Pawa. ");
INSERT INTO prq_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","Iroka ikantzi Pawa: “¡Moisés! Pinkantiri pirintzi Aarón, airo ipiya-piyata inkyii otasorintsi-pirotzi tasorintsi-thaanti tsika othataka tonta-masiri, osaikaki nisironka-mintotsi otataro tasorintsi-moko, ikami = kari. Tima ari noñaaka-kyaari nominko-ryiin-kataki nisironka-mintotsiki. ");
INSERT INTO prq_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","Aririka inkyii Aarón tasorintsi-thaantiki, ontzimatyii yaanaki aparoni kiripiri vaca impyaakoi-tanta-jyaariri kaaripiro-yitatsiri. Yaanaki aajatzi aparoni ipiraitari, iriitaki katziyain-katatsini iyachaarinka impomitiri. ");
INSERT INTO prq_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","Yamaita-kiniri Aarón kiripiri vaca, iriitaki iwamaakiri, impomiwin-takyaari impyaakoi-tantyaariri ikaaripirotaki irirori, aajatzi ikaratzi saikatsiri iwankoki. ");
INSERT INTO prq_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","Ari yaanakiro taamintotsi ijaikitakiro owaamari-minkiti pomitai-rontsi tsika isaikaki Pawa. Apiti yawii-pani-tanaki irakoki opomiki kasankari. Yaanakiro otasorintsi-pirotzi tsika othataka tonta-masiri. ");
INSERT INTO prq_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","Intaakiro opomiki kasankari tsika isaikaki Pawa. Inthonka onkachaarinkan-tanakiro nisironka-mintotsi otataro tasorintsi-moko. Irootaki airo ikamanta irirori Aarón. ");
INSERT INTO prq_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","Impoña yaanaki kapichiini iriraani kiripiri vaca, intsikiryaan-takyaaro nisironka-mintotsi tsika isitowakirotziro ooryaatsiri, imatakiro tsika imontitakaro irirori intsikiryiiro nisironka-mintotsi onkarati 7 yapii-yapiitiro. ");
INSERT INTO prq_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","Ari iwamaakiri pasini ipira, iriitaki impomiwin-taitiri iyaari-pironka atziri-payi. Yaanakiro iriraani inthompointa otasorintsi-pirotzira, intsikiryaan-takyaaro nisironka-mintotsi aajatzi intakiroini tsika imontitakaro. Imatakiro ikimitaan-takarora iriraani kiripiri vaca. ");
INSERT INTO prq_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","Irootaki iroopiro-tanta-jyaari tsika otasorintsi-witakara yaiwinta-waitakarora pishininka-payi. Ari inkanta-kirori aajatzi maaroni tasorintsi-thaanti, satikain-chari iwanko-thaanti-yitaka ikaratzi kaaripiro-yitaintsiri. ");
INSERT INTO prq_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","Aririka inkyii Aarón tsika otasorintsitaki yaripiro-takaan-tajiri kaaripiro-yitatsiri, airo isinitai-tziri isaiki pasini atziri anta tasorintsi-thaantiki, irojatzi isitowan-tajyaari Aarón. Tima imatakiro ipyaa-kotai-takiniri ikaaripirotakira irirori, ikaratzi saikatsiri iwankoki, aajatzi iyaari-pironka maaroni ishininka-payi Israel-iiti. ");
INSERT INTO prq_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","Ari ijatanaki osaikaki pomitai-rontsiki omontitakari tsika isaiki Pawa, intasorintsi-takayiro pomitai-rontsi. Yaakotanaki kapichiini iriraani kiripiri vaca aajatzi irasi ipiraitari, intziri-takiro ochii-payi pomitai-rontsi. ");
INSERT INTO prq_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","Intsikiryaan-takyaaro iraantsi pomitai-rontsi onkarati 7 yapii-yapiitiro. Inkitita-kaajiro ikaaripiro-waitakiro pishininka-payi Israel-iiti, intasorintsi-takaajiro. ");
INSERT INTO prq_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","Iroka nosankinatani irootaki pisirita-piintajyaari. Aririka omonkara-tajyaa kitaitiri 10, kasiri 7, ontzimatyii pintzi-wintajyaana, airo pantawaitaji. Ari inkimita-jyaari pishininka, aajatzi pasini-satzi atziri saikimo-tzimiri piwankoki. ");
INSERT INTO prq_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","Tima iroka kitaitiri aritaki impyaakoi-tajimiro pikaaripirotaki, kitisiri pinkantajyaa awiroka anta tsika isaikaki Pawa. ");
INSERT INTO prq_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","Tima asi owajiro nosankina-takaantani, pasi piwajiro pimako-ryaan-tajyaaro. Pintziwin-tajyaaro aajatzi. ");
INSERT INTO prq_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","Inkiti-siri-takaajimi Ompira-tasorintsi-taari isaipatzii-toitakiri, impoyii-takariri iriri impira-tasorintsitzi. Iriitaki matironi impyaako-tajiri kaari-piroripayi. Inkithaa-tajyaaro iroopirori iithaari tasorintsi-manki-tatsiri. ");
INSERT INTO prq_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","Iriitaki iriipiro-takaa-jironi otasorintsi-naki-pirotzi aajatzi tasorintsi-thaanti. Ari inkimitaa-jirori pomitai-rontsi yaiwinta-waitaitakaro. Imatajiri aajatzi Ompira-tasorintsi-taari, aajatzi maaroni pishininka-payi tsika pikarajiitzi. ");
INSERT INTO prq_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","Asi owajiro iroka nosankina-takaantani. Tima aparo-jatzi osarintsiki inkyiiti impyaakoi-tantyaarori ikaaripiro-yitaki Israel-iiti.” Tima imatakiro Moisés okaratzi ikantakiriri Pawa. ");
INSERT INTO prq_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","Ari iñaawaitaki Pawa, ikantziri Moisés: ");
INSERT INTO prq_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","Pinkinkitha-waita-kairi pishininka Israel-iiti, pinkantiri: “Kitisiri pinkantajyaa awiroka-payi, tima kitisiri nokanta naaka, piwinkathariti. ");
INSERT INTO prq_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","Ti onkamiithati pinkisa-niintiri pishininka. Ontzimatyii pinkisa-thatiri pishininka yantiro-rika kaari-pirori. Airo pakakotziri iyaari-pironka. ");
INSERT INTO prq_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","Ti onkamiithati pimpiyatantyaa, airo pisamawaitari pishininka-payi aajatzi. Pintakota-jyaari pishininka, pinkimita-kaantiri pitakota awiroka. Naaka Pawa kantzimiri. ");
INSERT INTO prq_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","Ari iñaawaitaki Pawa, ikantziri Moisés: ");
INSERT INTO prq_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","“Iroka pasini pinkantiriri pishininka-payi Israel-iiti: ‘Inkarati asitakai-yaarini iriinchaaniti pawaniro ipaitai-tziri “Pinkathari Itaawin-taitziri Iinchaa-niki-payi”, ontzimatyii iwamaitiri. Onkanta-wityaa iriirika Israel-iiti, iriirika pasini-satzi atsipatari anampiki, iwaitiri. ");
INSERT INTO prq_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","Tima kisaniinta nowajiri naaka yokapayi, aritaki napirotajiri inampiki, tima iriitaki okaaripiro-takirori tasorintsi-thaanti, iwinka-tharyaakiro nowairo, okantakaan-tziro yasitakaakari iriinchaa-nikiti pawaniro ‘Pinkathari Itaawin-taitziri Iinchaa-niki-payi’. ");
INSERT INTO prq_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","Aririka impiyatha-takyaa pasini-payi pishininka airorika iwiiri ikaratzi asitakaa-kariri iriinchaaniti pawaniro ‘Pinkathari Itaawin-taitziri Iinchaa-niki-payi’, ");
INSERT INTO prq_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","kisaniinta nowajiri naaka, ari nonkimi-tajiriri maaroni ishininka-payi irirori. Ari napirotajiri nontsipa-tajiri ikaratzi aapatyaa-kariri ikaaripirotaki, ipinkatha-waitasitakari pawaniro ‘Pinkathari Itaawin-taitziri Iinchaa-niki-payi’. ");
INSERT INTO prq_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","Ari nonkanta-jiriri atziri-payi inkarati awintyaarini antyawiyari-payi, aajatzi yotantaniri-payi, kaaripirotaki irirori yawintaakari. Tima kisaniinta nowiri naaka yoka atziri, aritaki napirotajiri inampiki. ");
INSERT INTO prq_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","Pinkamiitha-siri-yitaji, kitisiri pinkantajyaa, tima naaka Piwawanitari. ");
INSERT INTO prq_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","Pinkimisan-tajiro maaroni noñaani, pantayi-tajiro. Tima naaka Pawa, kitisiri-takayimini. ");
INSERT INTO prq_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","Inkarati mishatirini iriri aajatzi iriniro, ontzimatyii iwamaitiri. Tima onkanta-kaantiro imishatakiri iriri aajatzi iriniro, irootaki iwai-tantyaariri. ");
INSERT INTO prq_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","Inkarati mayimpi-tironi iinantsi-nintsi, ontzimatyii iwaitiri apitiro, kooya aajatzi sirampari.");
INSERT INTO prq_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","Okanta apitita-tsiri osarintsi isitowan-tajari Israel-iiti Apitantoniki, irootaki itarori kitaitiri, apitita-tsiri kasiri ithonkan-taita-karori tasorintsi-thaanti. Anta Kitoochiintoniki, ari yapiitajiro Pawa iñaanatajiri Moisés tasorintsi-thaantiki, ikantajiri: ");
INSERT INTO prq_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","“¡Moisés! Pinthonka pisankina-takotiri maaroni pishininka-payi, maaroni tsika ikaratzi ishininka-tawakaajiita, aajatzi iwaisatziti-payi. Tima isankina-takotyaa aparo-payi iwairo maaroni sirampari-payi. ");
INSERT INTO prq_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","Pitana-kyaari pisankina-takotiri tzimain-tsiri 20 isarintsiti, pinthonkiri maaroni. Pinasiyi-takyaari awiroka pisankina-takotiri jatatsini iwayirityaa. Pinkantiri Aarón yamitakotimi.” ");
INSERT INTO prq_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","Ari iñaawaitaki Pawa, ikantziri Moisés: ");
INSERT INTO prq_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","“Pinkamantiri Israel-iiti, pinkantiri: ‘Tzimatsi-rika aparoni sirampari, aajatzi aparoni kooya inkasiya-kayi-tyaanari naaka, impaitaitiri Kasiyakaa-wiri. ");
INSERT INTO prq_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","Airo irakaiyitziri kachoyita-tsiri. Airo ithoyitajiro chochoki-payi kachokiyitatsiri, aajatzi okaratzi itasitaitziri ");
INSERT INTO prq_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","Tima ainirora ikasiya-kaitanari naaka, intzita-kayi-tyaari okaratzi tzimatsiri iwitsikai-tziro chochoki-yitatsiri. ");
INSERT INTO prq_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","Airo isinitai-tziro intotaitiro iisi, asi owiro osanthati iisi irojatzi onkaran-takyaari okaratzi ikasiya-kaitanari naaka, tima iriitaki yasitakai-takanari. ");
INSERT INTO prq_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","Tima airo okantzi aajatzi intsitokyaari ikaratzi kamayita-tsiri.’ ” ");
INSERT INTO prq_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","Ikanta Pawa iñaanatajiri Moisés, ikantajiri: ");
INSERT INTO prq_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","“Pintyaanki aminai-tironi kipatsi Owintiniki, tima irootaki nasitakai-yaariri pishininka-payi Israel-iiti. Piyosiiti aparoni pikaratzi pishininka-tawakaa-jiita, jiwari iinayiti, iriitaki pintyaankiri”. ");
INSERT INTO prq_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","Imatakiro Moisés ikantakiriri Pawa, ityaankakiri ikaratzi iyosiitakiri, ipoñaanakaro otzisi-masiki Morontoniki. Tima ijiwariti inayitzi Israel-iiti. ");
INSERT INTO prq_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","Iroka iwairo-payi ikaratzi iyosiitakiri: Yaminakiri ikarajiitzi icharini-payi Rubén, iyosiitakiri Samúa, itomi Zacur. ");
INSERT INTO prq_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","Yaminakiri ikarajiitzi icharini-payi Simeón, iyosiitakiri Safat, itomi Horí. ");
INSERT INTO prq_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","Yaminakiri ikarajiitzi icharini-payi Judá, iyosiitakiri Caleb, itomi Jefone. ");
INSERT INTO prq_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","Yaminakiri ikarajiitzi icharini-payi Isacar, iyosiitakiri Igal, itomi José. ");
INSERT INTO prq_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","Yaminakiri ikarajiitzi icharini-payi Efraín, iyosiitakiri Oseas, itomi Nun. ");
INSERT INTO prq_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","Yaminakiri ikarajiitzi icharini-payi Benjamín, iyosiitakiri Palti, itomi Rafú. ");
INSERT INTO prq_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","Yaminakiri ikarajiitzi icharini-payi Zabulón, iyosiitakiri Gadiel, itomi Sodi. ");
INSERT INTO prq_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","Yaminakiri ikarajiitzi icharini-payi José (aajatzi Manasés), iyosiitakiri Gadi, itomi Susi. ");
INSERT INTO prq_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","Yaminakiri ikarajiitzi icharini-payi Dan, iyosiitakiri Amiel, itomi Gemali. ");
INSERT INTO prq_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","Yaminakiri ikarajiitzi icharini-payi Aser, iyosiitakiri Setur, itomi Micael. ");
INSERT INTO prq_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","Yaminakiri ikarajiitzi icharini-payi Neftalí, iyosiitakiri Nahbí, itomi Vapsi. ");
INSERT INTO prq_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","Yaminakiri ikarajiitzi icharini-payi Gad, iyosiitakiri Geuel, itomi Maqui. ");
INSERT INTO prq_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","Irootaki iwairo-payi ikaratzi ityaantakiri Moisés yaminaitiro kipatsi. Iriima Oseas, itomi Nun, iwajiniri pasini iwairo, ipaitajiri Josué. ");
INSERT INTO prq_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","Ityaanta-jiitakiri Moisés yaminaitiro kipatsi Owintiniki. Ikantawakiri: “Pijajiiti pinkinanaki okatonkotzi Piryaarini, pintonkajiro anta otzisi-masi. ");
INSERT INTO prq_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","Ari paminiro tsika okantawaita kipatsi. Piñiiri tsika ikantawaita nampitarori anta, sintsi-rika ikantajiita, oshiki-rika ikaratzi. ");
INSERT INTO prq_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","Paminiri tsika ikanta iwankoyita, kamiitha-rika kipatsi, iroopiro-rika iwanko, oyosiitasita-rika iwanko-shita. ");
INSERT INTO prq_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","Kamiitha-rika oshooki pankirintsi, tirika onkamayiti. Tzimatsi-rika inchato-payi. Tonta-siri pinkantyaa, kaari itharowaitzi. Pamayitajira chochoki okaratzi tzimatsiri anta.” Tima owakira itanaaro okitho-paitzi chochoki-payi iraitziri. ");
INSERT INTO prq_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","Ari ijajiitanaki, ipoñaanakaro Kitoochiintoniki yaminiro kipatsi, irojatzi Kaankiiriniki tsika okyaapiinta awotsi jatachari Manawiniki. ");
INSERT INTO prq_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","Ipampitha-tanakiro okatonkotzi Piryaarini, ariijiitaka nampitsiki Aripiro-taarini. Ari inampitarori anta Ahimán, Sesai aajatzi Talmai, icharini-payi Anac. Tima iroka nampitsi Aripiro-taarini, irootaki itarori inampitsi-taitaro, tzimakotaki okaratzi 7 osarintsi, ari yampoiwaitaji inampitsi-titaro Sitowaarini-satzi Apitantoniki. ");
INSERT INTO prq_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","Tima ariijiitaka nijaatinkaki ipaitai-tziri Tsintakiraani, ari ichikakotanaki apatsintakiro chochoki iraitziri. Tima apiti ikarawin-takiro yanatakotakiro incha-pankiki. Yamaji aajatzi okithoki pasini pankirintsi-payi. ");
INSERT INTO prq_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","Iriitaki paitana-kirori Tsintakiraani yoka Israel-iiti, tima ari ichikanaki apatsintakiro chochoki iraitziri. ");
INSERT INTO prq_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","Imatakiro yaminayi-takiro kipatsi, okaratzi imaakotaki 40 kitaitiri ipiyanta-yitajari. ");
INSERT INTO prq_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","Jaitijiitaki iñaapajiri Moisés aajatzi Aarón otzisi-masiki Morontoni saikatsiri anta Tasorinchaariniki. Tsika ipiyojiitaka aajatzi maaroni ishininka-payi. Ikamanta-pajiri tsika okanta yaminai-tziro, iñaakapajiri okithoki chochoki tzimatsiri anta. ");
INSERT INTO prq_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","Ikantapajiri: “Nomatakiro nariitaita tsika pityaan-takina. Ari oshookapaji oshiki pankirintsi, aajatzi ari itzimapaji oshiki ipiraitari. Iroka okithoki pankirintsi okaratzi shookatsiri anta. ");
INSERT INTO prq_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","Iro kantacha, antari-tawato-payi ikanta ikaratzi nampitarori anta, antaro-payi onatzii inampitsiti, iroopiro iwitsika-yitziro iwanko-payi. Noñaakiri aajatzi anta icharini-payi Anac. ");
INSERT INTO prq_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","Irooma anta Piryaariniki, ari inampitarori Otinkanaawini-satzi. Irooma otzisi-masiki, ari inampiyitaro Tharowan-taarini-satzi, Kayaawinisatzi, aajatzi Tonkaarisatzi. Irooma anta inkaari-thapyaaki aajatzi Owaryiinkaariniki, ari inampitarori Owintini-satzi.” ");
INSERT INTO prq_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","Ari itzinaa-wako-tanaka Caleb, imairitawakiri maaroni ishininka-payi yapatotakiri Moisés, ikantanaki: “¡Aritaki aakiro ironta kipatsi! ¡Aritaki amatakiro asitajyaaro!” ");
INSERT INTO prq_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","Iro kantacha akanaki ikarajiitzi ijajiitaki anta, ikantzi: “¡Airowí! Airo aitsinampairi yonta atziri. Omapiro isintsi-yitzi irirori, tima yanaajai aroka-payi”. ");
INSERT INTO prq_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","Tira inkinkitha-tapaji kamiitha Israel-iiti ityaantai-takiri yaminaitiro kipatsi, ikantapaji: “Oshiki okowiinkatzi kipatsi naminai-tziri, ti onkamithati. Tima antari-tawato-payi ikantajiita atziri-payi ikaratzi noñaaki-tziri anta. ");
INSERT INTO prq_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","Ari noñaakiriri aajatzi antari-tawato-pirori-payi atziri, iriitaki icharini-payi Anac. Ti nomonkara-tyaari naaka ikatziya, nokimi-matsi-takari naaka tsitsiri iñaakina irirori.” ");
INSERT INTO prq_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","Ari ikaimajii-tanaki Israel-iiti. Oshiki yiraawai-jiitaka tsitiniriki. ");
INSERT INTO prq_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","Ari yitanaaro ikisima-tanajiri Moisés aajatzi Aarón, ikantajiitzi: “¡Tima onkawinthaa-witakai ankamajiitimi pairani Apitantoniki! ¡Tima onkawinthaa-witakai aajatzi ankamajiitimi aka otzisi-masiki! ");
INSERT INTO prq_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","¿Paitaka yamantajairi Pawa aka yapiroitajai owayiri-taantsiki, inosika-nakiro owayiriiti ainapayi aajatzi awaiyani-payi? ¿Tima onkamiithati ampiyayitaji Apitantoniki?” ");
INSERT INTO prq_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","Ari ikanta-wakaa-jiitanaka: “Thami amini pasini jiwatajaini. Thami ampiyayitaji Apitantoniki.” ");
INSERT INTO prq_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","Ari ityiirowanaka Moisés aajatzi Aarón ipiyojiitaka ishininka-payi Israel-iiti, yoiyootanaka kipatsiki. ");
INSERT INTO prq_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","Ikanta Josué aajatzi Caleb, jataintsiri yaminai-tziro kipatsi, isaranakiro iithaari-payi iyotantai-tyaari oshiki okantzimo-siri-tanakari. ");
INSERT INTO prq_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","Ikantanakiri maaroni ishininka-payi: “¡Omapiro okamiithataki kipatsi naminai-tziri! ");
INSERT INTO prq_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","Iriirika Pawa nintakaironi, aritaki inisironka-takai ariitan-tyaari nampitsiki, arokataki asitajyaaroni. Tima ari oshookapaji oshiki pankirintsi, aajatzi ari itzimapaji oshiki ipiraitari. ");
INSERT INTO prq_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","Titzimaita onkamiithati pinkisima-waitiri Pawa. Airo pitharowan-tawaitari nampitarori anta, tima airo añaakaa-nakari arokaiti. Tikatsi kisakowin-tyaarini yokaiti, ti isiyai arokaiti tzimatsi Pawa kimpoyaa-wintairi. ¡Airo pitharowa-jiitzi!” ");
INSERT INTO prq_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","Ari inintajii-witanaka ishininka-payi ishimyaa-tyaarimi mapi. Irojatzi okoñaatan-tanakari isintsinka Pawa tasorintsi-thaantiki, ithonka iñaayitakiro maaroni Israel-iiti. ");
INSERT INTO prq_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","Ari iñaanatajiri Pawa yoka Moisés, ikantajiri: “¿Tsika-paitima inkaratiro yasaryii-matana pishininka-payi? ¿Tsika-paitima inkaratiro ithainka-waitana noñaaka-yiwitakari kaari iñaapiin-taitzi? ");
INSERT INTO prq_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","Ari iñaakiro mantsiyarintsi wamaanta-tsiri, napirotajiri ikarajiitaki. Irooma awiroka, aritaki noshikyaa-jimiri inkarati pincharini-tajyaari, ñaapiroki inkantajyaa yanaajiri ikarajiitzi yokapayi.” ");
INSERT INTO prq_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","Iro kantacha yakanaki Moisés ikantanakiri: “¡Pawá! Aritaki inkimako-takiro Apitantoni-satzi onkarati pantiri, tima maaroni iñaayitakiro pairani pisintsinka paantaariri noshininka-payi. ");
INSERT INTO prq_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","Aritaki inkaman-takiri irirori ikaratzi nampiyi-tarori kipatsiki. Tima ikima-kota-jiitakimi tsika pikantaka pairani pitsipa-takari noshininka-payi, pikanta-kaakaro iñaaporotimi. ¡Pawá! Awiroka tsimankanta-kariri minkori, pijiwatakiri kitaipaiti, irooma tsitini-paiti pipaama-takaakiro minkori kitainka-takota-kiriri. ");
INSERT INTO prq_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","Aririka papirotakiri piwamaa-yitiri yoka, aritaki iñaawai-tanaki atziri-payi ikaratzi kimakota-kimiri, okaratzi panta-yitakiri, inkanti: ");
INSERT INTO prq_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","‘Piñaa-matsitiri Pawa, ti imatatyiiro yasitakai-yaari Israel-iiti kipatsi ikasiya-kaakiriri pairani, yapirota-sitakari iwamairi maaroni otzisi-masiki.’ ");
INSERT INTO prq_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","¡Pawá! Nonintzi piñaakantiro pisintsinka, pimonkaratiro okaratzi piñaawai-takiri pairani, pikantaki: ");
INSERT INTO prq_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","¡Naakataki Pawa! Tsinampari-tatsiri, Itako-piro-tantatyaari. Nopyaako-tziri kaaripiro-yitatsiri, kinasi-waiyi-tachari. Iro kantacha, airotzimaita nowawisaasitanaka nowasankitairi ikaratzi antayitzirori kaari-pirori, Nowasankitaa-wintajiri iyaari-pironka iriri, Itomi, icharini, aajatzi itomi icharini. ");
INSERT INTO prq_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","Tima omapiro pinisironka-tanta awiroka, pimpyaako-tajiri iyaari-pironka yoka. Tima irootaki pimata-piintakiri pamantajariri yokaiti Apitantoniki irojatzi aka tsika isaikaki.” ");
INSERT INTO prq_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","Ikantanaki Pawa: “Kamiithataki. Tima nomatakiro pinintakiri, aritaki naripiro-tajiri. ");
INSERT INTO prq_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","Iro kantacha, tima omapiro-tatyiiyaa nañii naaka, omapiro-tatyaa aajatzi nanaantaro nosintsinka maaroni kipatsiki. ");
INSERT INTO prq_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","Airotzimaita itzimaji aparoni ikaratzi ñaayita-kirori nosintsinka, ikaratzi ñaayita-kirori Apitantoniki kaari iñaapiin-taitzi, okaratzi nantayi-takiri aajatzi otzisi-masiki. Tima inkarati apiipii-takirori yasaryii-matana otzisi-masiki, kaari nintatsini inkimisan-tajiro nokanta-witariri, ");
INSERT INTO prq_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","airo iñaayitajiro kipatsi nokasiya-kaakiriri pairani iwaisatziti. Tima inkarati asaryii-mawai-takanari airo itzimaji aparoni ñaayita-jironi. ");
INSERT INTO prq_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","Iriitaki nompiratani Caleb ñaajironi. Tima iriitaki nasitachari ikinkithasiritari, yawintaa-piro-takana. Irootaki nosinitan-tyaariri irirori yariitajyaa kipatsiki yaminai-tziri. Ari inampita-jyaarori maaroni incharini-tajyaari irirori. ");
INSERT INTO prq_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","Iro kantacha, nonintzi pimpiyanaki onkitaiti-tamanaji pinkina-najiro otzisi-masiki pijatiro Inkaariki Kiraankaaro. Tima anta otaapiki, ari inampitarori Otinkanaawini-satzi aajatzi Owintini-satzi.” ");
INSERT INTO prq_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","Aikiro iñaawai-tatzii Pawa iñaanatziri Moisés aajatzi Aarón, ikantziri: ");
INSERT INTO prq_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","“¿Aikiroma namawita-tyiiro ikisima-waitanari yokaiti kaari-pirori-payi Israel-iiti? Tima nokimakiri ikisima-waitakina. ");
INSERT INTO prq_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","Pijati pinkamantiri pishininka-payi, pinkantiri: ‘Iroka iñaani Pawa, ikantzi: “Omapiro-tatyaa, tima ari nonkanta-kaakyaaro awishimotimi okaratzi nokimakimiri pikanta-jiitakiri pinkami. ");
INSERT INTO prq_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","Inthonkyaa inkami otzisi-masiki maaroni antaritain-tsiri tzimain-tsiri 20 isarintsiti, ikaratzi sankina-takotain-chari, ikaratzi kisima-waitakinari aajatzi. Naryaa-masi inkantajyaa otzisiki inkamayiti. ");
INSERT INTO prq_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","Iriima Caleb itomi Jefone. Aajatzi Josué itomi Nun, iriitaki ñaayita-jironi inampita-jyaaro anta. Irooma maaroni awirokaiti, tikatsi aparoni ariitaa-chani kipatsiki nokasiya-kaawi-takamiri pinampi-jiityaaromi. ");
INSERT INTO prq_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","Iriima pitomi-payi pisiyakaan-tawitakari ari inosika-yitakiri owayiriiti, tima iriitaki nariita-kaayi-tajyaari kipatsiki pimanin-takiri awirokaiti. ");
INSERT INTO prq_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","Tima naryaa-masini pinkantajyaa awirokaiti otzisi-masiki pinkama-yitaji-rika. ");
INSERT INTO prq_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","Tima onkarati 40 osarintsi inkina-kina-waiyitaji piwaiyani-payi anta otzisi-masiki, yaamaakowin-tajyaari ipira-payi. Iriitaki atsipita-jyaaroni okaratzi pipiyatha-waitaka awirokaiti, irojatzi papirotan-takyaari pinkami awirokaiti aka otzisi-masiki. ");
INSERT INTO prq_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","Tima 40 kitaitiri okaratzi paminan-taitarori kipatsi, ari onkarati aajatzi 40 osarintsi patsipi-yitajyaaro okantakaaro pikaaripiro-waitaki: aparoni osarintsi iroowaitaki aparoni kitaitiri. Ari piyotajinari tsika nokanta nowasankitaantzi naaka.” ");
INSERT INTO prq_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","Tima Naaka Pawa, ñaawaita-tsiri. Aritaki nonkanta-jiriri maaroni kaari-piroriiti ikaratzi aapatyaa-wakaain-chari ikisima-waitana. Tima aka otzisi-masiki yapirotajyaa, ari inkamayi-tajiri maaroni.’ ” ");
INSERT INTO prq_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","Tima iroka awishimo-takiriri ikaratzi ityaantakiri Moisés yaminaitiro tsika okantawaita kipatsi, ipiyayitaka irirori yamajiro kaari-pirori ñaantsi, irootaki opoñaan-tanakari Israel-iiti ikisima-waitanakiri Moisés, imaninta-nakiro kipatsi, ti ininti ijatiro anta. ");
INSERT INTO prq_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","Irootaki iwamaan-takariri Pawa yokapayi omatanakiri mantsiyarintsi, okantakaan-tziro ithaiya-kota-pajaro kipatsi tsika okanta iñaakitziro. ");
INSERT INTO prq_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","Iriima Josué itomi Nun aajatzi Caleb itomi Jefone, ti inkamajiiti irirori. Apatziro ikamajiitaki pasini ikaratzi ijataki yaminiro tsika okantawaita kipatsi. ");
INSERT INTO prq_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","Ikamantakiri Moisés maaroni Israel-iiti okaratzi awisain-tsiri. Tima antaro iwasiri-jiitanaka maaroni Israel-iiti. ");
INSERT INTO prq_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","Okanta okitaiti-tamanaji. Kapichikitaiti itonkaa-jiitanaki otzisiki, ikantajiitzi: “Kaari-piro nokanta-jiitaka, nonintzi nojajiiti tonkaariki ikasiya-kaakayiri Pawa.” ");
INSERT INTO prq_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","Ikantzi Moisés: “¿Paitama pimpiya-thatantyaarori ikantakaantani Pawa? Tima airo okamiithatzi panta-wityaari aajatzi. ");
INSERT INTO prq_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","Airo pijatzi, tima ti intsipa-tyaami Pawa. Paamaiyaa imatawakimi = kari piwayiri-minthatari. ");
INSERT INTO prq_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","Tima ari pimonthaa-kyaari anta Otinkanaawini-satzi aajatzi Owintini-satzi, yapirotzimi = kari iwayiri-tyaami. Tima airo itsipatami Pawa anta, okantakaaro pipiyatha-takari awirokaiti.” ");
INSERT INTO prq_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","Titzimaita inkimi yokaiti, inintzi intonkajiro otzisi. Iriima Moisés aajatzi itasorintsi-mokoti Pawa, irojatzi isaikaki tsika iwanko-thaanti-jiitaka. ");
INSERT INTO prq_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","Ari yoirinka-jiitaka Otinkanaawini-satzi aajatzi Owintini-satzi nampiyi-tarori tonkaariki, tima oshiki ikintapaakiri, siyayitanaka pasini. Ipatzima-tanakiri irojatzi anta Sirijaariniki. ");
INSERT INTO prq_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","Tzimatsi aparoni Leví-iti ishininka-mirinka Coat, ipaita Coré, itomi Izhar. Yoka Coré tzimatsi mawa yaapatyaani, iriitaki ishininka-mirinka Rubén-iiti, ipaita Datán, Abiram, itomi Eliab. Aajatzi On itomi Pelet. ");
INSERT INTO prq_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","Ti inintajiiti ijiwariti Moisés, irootaki yapatotan-takari oshiki jiwari-payi Israel-iiti, iriiyitaki iwayitai-tziri ijiwata-kaanti, pinkathataari inayitatzii yokaiti. ");
INSERT INTO prq_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","Ikanta yapatojiitaka yokaiti, ijata-sitakiri Moisés aajatzi Aarón, ikantapaakiri: “¡Asiryaa-paakina naakaiti pikimita-kaanta-waitaka awirokaiti nojiwariti! Tima ari itsipatajai Pawa maaroni arokaiti. Ari akaratzi iyosiitakai impira-yitaji. ¿Ipaitama pinintantari apatziro awiroka piriipiro-waiti pijiwawintairi ikaratzi yasitari Pawa?” ");
INSERT INTO prq_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","Ikanta ikimawaki Moisés ikantakiriri, oiyootanaka, otsitoka-paakaro itamako kipatsiki. ");
INSERT INTO prq_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","Iñaanata-nakiri Coré aajatzi ikarajiitaki, ikantziri: “Onkitaitita-manai kapichikitaiti ari iñaakantiro Pawa itzimi-rika yasitari, itzimi-rika impira-tasorintsitaa-ritaitari, itzimi-rika matironi impiri ikaratzi yasitakaariri. Tima apatziro imatiro itzimi-rika iyosiiyitakiri irirori. ");
INSERT INTO prq_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","Awirokaiti ikarajiitziri Coré aajatzi irasi itsipa-minthari, pamayitaki onkitaitita-manai pitaa-minto-payi kasankainkari. ");
INSERT INTO prq_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","Pintiyitaki paamari-minki, pintiyiti kasankainkari, pamakota-kiniri Pawa. Intzimi-rika iyosiitakiri Pawa, iriitakira impira-tasorintsitaa-ritaitari. ¡Tima paasiryaa-paakina awirokaiti!” ");
INSERT INTO prq_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","Aikiro ikantana-kitziiri Moisés yoka Coré: “Pinkima-jiiti ishininka-mirinka Leví-iti. ");
INSERT INTO prq_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","Tzimatsi oshiki ashininka-payi Israel-iiti, iro kantacha awirokaiti Leví-iti, imatakimi iyosiiyitakimi Pawa pisaiki-motan-tyaariri pantawaitainiri Tasorintsi-thaantiki. ¿Kapichima okantzi-motakami awirokaiti? ");
INSERT INTO prq_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","Iyosiitakimi awiroka Pawa itsipataa-kimiri pirintzi aajatzi ishininka-payi, ari pisaiki-motairi okaakiini. ¿Ipaitama pikisako-niintan-tarori iroñaaka pimpira-tasorintsitaa-riti? ");
INSERT INTO prq_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","Tira iri pimaimaniti Aarón, Pawa pikisima-waitaki pitsipa-yitakari pikarajiitzi. ");
INSERT INTO prq_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","Ipoñaa ikantanajiri Moisés yoka Coré, ikantziri: “Airora pipyaa-kotaro awiroka aajatzi pikarajiitziri pimpoka-jiiti onkitaitita-manai isaiki-mota-kimira Pawa. Ari isaikityaari aajatzi Aarón anta. ");
INSERT INTO prq_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","Tima aparo-payi yamayitaki itaaminto, intiyitaki kasankari. Ari inkantzi-takyaari irirori Aarón. Impoña pintsipata-nakyaari pikarajiitzi oshiki aajatzi Aarón anta isaiki-mota-kimira Pawa.” ");
INSERT INTO prq_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","Ikanta yaayitanaki aparo-payi itaaminto-payi, itiyitanaki iwaamari-minkiti, ari itiyitakiro aajatzi kasankari, iwakoyita-paakiro ikyaa-piintai-tzira Tasorintsi-thaanti, itsipayitakari Moisés aajatzi Aarón. ");
INSERT INTO prq_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","Iriima Coré apatojiitaka irirori itsipayitakari pasini oshikita-tsiri ishininka imontitakaro Tasorintsi-thaanti. Ari okoñaata-paakiri iwaniinkaro Pawa tsika ipiyojiitakara. ");
INSERT INTO prq_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","Ari iñaanata-nakiri Pawa yoka Moisés aajatzi Aarón, ikantziri: ");
INSERT INTO prq_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","“¡Pintainanintyaari yokaiti piyotain-chari. Tima airo noshinta-kaari napirotiri iroñaaka!” ");
INSERT INTO prq_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","Iro kantacha yokaiti Moisés aajatzi Aarón, oiyoojiitanaka kipatsiki, ikantanakiri Pawa: “Asitanarí Pawa, awiroka opanaro nañaantari maaroni naakaiti. ¡Airo piwamairi maaroni yokaiti! ¿Irooma piwamaan-tyaariri ikantakaan-tziro aparoni atziri?” ");
INSERT INTO prq_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","Ari yakanakiri Pawa yoka Moisés, ikantziri: ");
INSERT INTO prq_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","“Pinkantiri maaroni pishininka-payi Israel-iiti yintainainintyaari iwanko-thaanti-payi tsika inampitaro Coré, Datán aajatzi Abiram.” ");
INSERT INTO prq_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","Ari ikatziyanaka Moisés, ari itsipata-nakari jiwayitziriri Israel-iiti, jatanaki tsika isaikajiitaki Datán aajatzi Abiram. ");
INSERT INTO prq_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","Ikantapaakiri maaroni Israel-iiti ikaratzi saikain-tsiri anta: “Pintainanintyaaro iwanko-thaanti-payi yokaiti kaari-pirori. Airo okantzi payitanakiri okaratzi yasiyitari irirori. Aamaa-sityaa aritaki okantakaan-takimi iyaari-pironka pinkaman-tyaari awirokaiti aajatzi.” ");
INSERT INTO prq_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","Imajiitakiro Israel-iiti ikaratzi tsipa-nampitariri Datán, Abiram aajatzi Coré, yintaina-pithata-nakari. Ari isaikawitari yoka Datán aajatzi Abiram tsika ikyaa-piintai-tziro anta itsipayitakaro iinaiti aajatzi iwaiyani-payi. ");
INSERT INTO prq_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","Aikiro ikantana-kitzii Moisés: “Iroka piyotan-tyaariri iroñaaka Pawa itzimi otyaanta-kinari nantayitiro iroka-payi. Tima ti nantasi-waityaaro noninta-kaani-kiini naaka. ");
INSERT INTO prq_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","Aririka inkamayitaki yokaiti atziri-payi ikimita-piintara ikamasi-waita, tira naaka ityaantani Pawa. ");
INSERT INTO prq_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","Iro kantacha tzimatsi-rika yantakiri Pawa kaari iñaapiintaitzi, aririka onkimita-nakyaaro oparaanka-tyiimi kipatsi, oniyayitakiri ikaratzi añaayita-tsiri jayitaki Sarinka-winiki, ari iyomitaitiri iriiyitakira kisimawaita-kiriri Pawa.” ");
INSERT INTO prq_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","Ikanta ikaratakiro iñaawaitakiro iroka-payi yoka Moisés, tankanaki kipatsi tsika isaikajiitaki yokaiti. ");
INSERT INTO prq_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","Okimiwaita-nakaro oparaanka-nakitziimi kipatsi. Tima ithonka oniyanakiri yokaiti, iwanko-payi, aajatzi ikaratzi aapatyaa-kariri Coré, maaroni okaratzi tzimimo-witariri. ");
INSERT INTO prq_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","Tima ainiro yañaawi-jiita yokaiti, ithonka oniyayitakiri inthompoitatzi kipatsi. Ari ikanta ipyaantakari sarinka-winiki maaroni yokaiti atziri. ");
INSERT INTO prq_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","Ikanta iñaakiro kantain-chari, isiyajiitanaka maaroni atziri, ikaimajiitanaki, ikantzi: “¡Thami ajapithatirowí! ¡Aama aritaki oniyanakai arokaiti aajatzi kipatsi!” ");
INSERT INTO prq_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","Ari ositowa-nakiri paamari osaiki-mota-kirira Pawa, ithonka otaapaakiri atziri-payi ikaratzira taawita-karori kasankainkari. ");
INSERT INTO prq_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","Okanta okitaitita-manaji, ikisi-mata-nakiri Israel-iiti yoka Moisés aajatzi Aarón, ikantziri: “Piwamaakiri awirokaiti ashininkaiti ikaratzi yasitari Pawa.” ");
INSERT INTO prq_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","Ikanta yapatojiitaka maaroni Israel-iiti ikaratzi kaari ookimotari yantakiri Moisés aajatzi Aarón, yaminajiitaki Tasorintsi-thaantiki, iñaatziiro othonka anaapaakiri minkori, ari okoñaatzi-mota-nakiri iwaniinkaro Pawa. ");
INSERT INTO prq_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","Ari ijata-sita-nakiro Moisés aajatzi Aarón apato-mintotsi. ");
INSERT INTO prq_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","Ari iñaawaitaki Pawa, ikantziri Moisés: ");
INSERT INTO prq_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","“Pintainanintyaari yokaiti atziri, airo noshinta-kaari napirotiri naaka.” Ari yoiyoojiitanaja aajatzi yokaiti. ");
INSERT INTO prq_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","Ikantanakiri Moisés yoka Aarón: “Pamakiro taamintotsi, pintiti owaamari-minkiti pomitai-rontsi, pintiti aajatzi kasankainkari. Paanakiro sintsiini tsika ipiyojiitaka Israel-iiti. Pinkowa-kotiri Pawa inisironkai-tairi yokaiti, tima ontyaana-kityii-yaari iyatsimanka Pawa, itanakaro mantsiyarintsi inkimaatsitai-tyaari.” ");
INSERT INTO prq_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","Imatakiro Aarón yaanakiro itaaminto tsika ikantakiri Moisés. Isiyanaka tsika ipiyojiitaka Israel-iiti. Aritaki itanakaro ikimaatsita-nakaro atziri-payi mantsiyarintsi. Iwapaakiro kasankainkari, ikowa-kotakiri Pawa inisironkata-jyaari Israel-iiti. ");
INSERT INTO prq_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","Satikanaka niyaankiniki tsika Aarón inaryaa-yitanaka atziri kamanain-tsiri, tsika isaikayitaki añaatsiri atziri. Ari awisanakiri mantsiyarintsi owasankitaa-witana-kariri. ");
INSERT INTO prq_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","Tima oshiki-piro ikaratzi owamaanakiri mantsiyarintsi, ti iyoitiri tsika ikaratzi kamaintsiri aapatyaa-kariri Coré. ");
INSERT INTO prq_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","Okanta okarata-paaki ikamawi-jiitaka, piyaja Aarón itsipataari Moisés anta tsika ikyaa-piintai-tzira Tasorintsi-thaantiki. ");
INSERT INTO prq_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","Ari iñaawaitaki Pawa, ikantziri Moisés: ");
INSERT INTO prq_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","“Pinkanta-jiitiri ijiwariti ikaratzi ishininkata-wakaa Israel-iiti yamayitaki aparo-payi ikotzikiiri, isankina-yitakiro iwairo. Onkarati 12 kotzikiirintsi. ");
INSERT INTO prq_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","Irooma kotzikiirintsi yasitari ishininka-mirinka Leví-iti, isankinatiro iwairo Aarón. Tima ontzimayiti aparo-payi ikotzikiiri jiwari. ");
INSERT INTO prq_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","Paanakiro iroka-payi kotzikiirintsi Tasorintsi-thaantiki, piwayitiro osaikakira Tasorintsi-moko, tsika anta noñaakyaami awirokaiti. ");
INSERT INTO prq_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","Aritaki nonkanta-kaakyaaro oshooki aparoni kotzikiirintsi. Iroka kotzikiirintsi shookatsini irootaki irasi noyosiitani jiwatairini Israel-iiti. Ari onkantyaa airo ikisima-waitan-taami Israel-iiti awiroka-payi.” ");
INSERT INTO prq_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","Imatakiro Moisés ikantakiri Israel-iiti iroka ñaantsi. Yamayitaki ikotzikiiri aparo-payi ijiwari ikaratzi ishininkata-wakaa, isankina-yitakiro iwairo, onkarati 12 kotzikiirintsi. Arira osaikitakari irasi Aarón. ");
INSERT INTO prq_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","Ikanta yamaitakiro kotzikiirintsi-payi, yaanakiro Moisés Tasorintsi-thaantiki, iwayitakiro tsika osaikaki Tasorintsi-moko. ");
INSERT INTO prq_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","Okanta okitaitita-manaji, ikyaa-manaji Moisés Tasorintsi-thaantiki, iñaatziiro ari oshookanaki ikotzikiiri Aarón, tzimaki otyaaki, ari antaikiyitaki okithoki osiwaitakaro pasotziki. ");
INSERT INTO prq_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","Ari yaajirori Moisés maaroni kotzikiirintsi-payi okaratzi iwayitakiri Tasorintsi-thaantiki, iñaakayitairi Israel-iiti. Ikanta yaminayita-wajiro ikotzikiiri jiwari-payi, yaayita-najiro aparo-payi. ");
INSERT INTO prq_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","Ipoñaa iñaawaitanaji Pawa ikantajiri Moisés: “Papiitiro piwajiro ikotzikiiri Aarón tsika osaikaki Tasorintsi-moko, irootaki iyotanta-yityaari yokaiti thainkan-taniri-payi. Ari onkantyaa iwashaantan-tyaaro ikisima-waitzimi. Tima aririka inkimisanta-yitajina, airo ikamayitzi.” ");
INSERT INTO prq_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","Tima imatakiro Moisés okaratzi ikantakiriri Pawa. ");
INSERT INTO prq_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","Ikanta maaroni Israel-iiti, sitowajiitanaki Tasorinchaariniki tsika ipiyojiita, ariijiitaka Otzisiitoniki. ");
INSERT INTO prq_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","Ikanta yawisajiitaki Israel-iiti ipoñaanaaro Otzisii-toniki inkinanajiro Inkaariki Kiraankaaro. Itapota-naatyaaro airo ikinantanaja iipatsitiki Kiraarini-satzi. Okanta niyaanki-thaki awotsi, ari okantzi-moniin-tapaakari Israel-iiti. ");
INSERT INTO prq_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","Ari yitanaaro ithainka-matanajiri Pawa aajatzi ikimitaakiri Moisés. Ikantajiitzi: “¿Paita pamanta-waitanari nosaikawita Apitantoniki? ¿Irooma pamantanari piwamaina otzisi-masiki? Ti noñaajiro opaita nirayitajiri aajatzi noyaari. ¡Aasiryaakina okaratzi nowapiin-takari!” ");
INSERT INTO prq_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","Ari ityaantaki Pawa oshiki kipiyari maranki, yatsika-paakiri. Tima oshiki Israel-iiti kamaintsiri. ");
INSERT INTO prq_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","Ijajiitaki isaiki Moisés, ikantapaakiri: “¡Moisés! Nokaaripiro-tzimotakiri Pawa, okantakaaro nothainka-mawai-takiri aajatzi nokimitaakimi awiroka. Pinkantajiri impyaajiri maranki, ti noninti noñiiri.” Ari yamanako-tairi Moisés maaroni ishininka-payi. ");
INSERT INTO prq_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","Ari ikantzi Pawa: “Piwitsiki kimityaarini kipiyari maranki, piwatzika-kotiri jinoki. Aririka yatsikanti maranki, yaminiri kimityaarini iwatzika-koitakiri, aritaki yawisako-yitanaji.” ");
INSERT INTO prq_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","Yaaki Moisés asiro kitirita-tsiri iwitsikaki kimitariri maranki, iwatzika-kotakiri. Ikanta yatsikantzi maranki, yaminai-tziro iwatzika-koitakiro kimitariri, awisako-yitanaji. ");
INSERT INTO prq_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","Ikanta yawisajiitaki Israel-iiti, iwanko-thaanti-jiitapaja Misinanchaariniki. ");
INSERT INTO prq_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","Okanta apaata ityaantaki Israel-iiti jatatsini iñiiri iwinkathariti Tonkaarisatzi, paitachari Sehón, inkantiri: ");
INSERT INTO prq_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","“¡Pinkatharí! Ari piñaayi-tawakina nonkina-jiitapaaki pipatsitiki. Ti iro nompokasiti piwankiri-payi, pichochokiti-payi, airo nirawai-tanaki aajatzi poonkanari pinijaati-payi. Apatziro nompampi-thatakiro awotsikitaki awotsi, irojatzi nawisan-tanakyaari tsika owiraa pipatsiti.” ");
INSERT INTO prq_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","Titzimaita ininti pinkathari Sehón inkinimotiri Israel-iiti iipatsitiki. Yapatota-nakiri iwayiriti, jataki iwayiri-tawakyaari Israel-iiti otzisi-masiki. Imonthaakari Aatzikaitoniki, ari iwayiri-taitakari Israel-iiti. ");
INSERT INTO prq_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","Ikanta ipiyawin-tanaka Israel-iiti, yapirota-nakiri iwisinakiri iwayiriti Sehón. Yayitakiri maaroni tsika owiraayita iipatsiti. Opoñaanakaro Poimaariniki irojatzi Sakochaaroniki. Ariitakaro owiraa-thapita iipatsiti ñaapiroriiti Pityaankaarini-satzi. ");
INSERT INTO prq_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","Ari okanta yaanta-karori Israel-iiti maaroni inampiiti Tonkaarisatzi. Inampitakaro otzinkami inampiiti ipaitai-tziri Kaawini, tima ithonka-kiro inampiyi-tantakaro yanini-payi nampitsi-payi tzimatsiri anta. ");
INSERT INTO prq_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","Awisajii-tanaki Israel-iiti, iwanko-thaanti-jiitapaja owintini-pathatzi iipatsitiki Athataa-wini-satzi, othapyaaki Owaryiinkaarini, imontita-paakaro Kasiryaari. ");
INSERT INTO prq_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","Tima iñaakiro Balac, itomi Zipor, tsika ikanta Israel-iiti yapirotan-takariri Tonkaarisatzi. ");
INSERT INTO prq_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","Antaro itharowanaki Athataa-wini-satzi itharowantari Israel-iiti, tima ishiki ikarajiitaki Israel-iiti. ");
INSERT INTO prq_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","Ari ikinkitha-waitakaa-nakiri Athataa-wini-satzi yantari-konati-payi Maimani-wini-satzi, ikantziri: “Ari inthonki-takayiro aipatsiti yoka atziri-payi, isiyaari vaca ithonkiro iwaro katarosi.” Tima yoka Balac itomi Zipor, iriitaki iwinkathariti Athataa-wini-satzi. ");
INSERT INTO prq_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","Ityaantaki jatatsini iñiiri Balaam itomi Beor, nampitarori Ñaawya-winiki othapyaaki Antaraani iipatsitiki Shininkawini, inkantiri: “Ikyaaki anampiki atziri-payi sitowaa-tsiri Apitantoniki, tima ithonka yanaapaakiro aipatsiti, imontita-paakaro nonampi iwanko-thaanti-yitapaaka. ");
INSERT INTO prq_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","Pimpokanaki sintsiini, pintakishiri yokapayi atziri, omapiro-tatziiri otzimi isintsinka, yanaakina naaka-payi. Onkamintha nomisitowajiri naaka noipatsitiki, aririka nowayiri-takyaari. Iro kantacha, noyotzi naaka ikaratzi pintasonka-wintiri awiroka, aritaki omatakyaa. Iriima ikaratzi pitakisa-yitziri awiroka takisaari inkantyaa.” ");
INSERT INTO prq_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","Jatanaki antari-kona-payi Athataa-wini-satzi, aajatzi antari-kona-payi Maimani-wini-satzi yaayitanaki impinatiriri ñaawyataniri. Ariijiitaka isaiki Balaam, ikamanta-paakiri ikantawa-kiriri Balac. ");
INSERT INTO prq_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","Ari ikantzi Balaam: “¡Arí! Osaikira nonkantimi opaita-rika inkantinari Pawa. Pimaawaiti.” Ari imaajii-tapaaki inampiri-payi Athataa-wini-satzi iwankoki Balaam. ");
INSERT INTO prq_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","Ari iñaakakari Pawa yoka Balaam, isampitakiri, ikantziri: “¿Paitama pitsipa-yitakari piwankoki?” ");
INSERT INTO prq_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","Yakanaki Balaam, ikantzi: “Ityaantani inayitzi Balac itomi Zipor, iwinkathariti Athataa-wini-satzi, ipokatzii, ikantana: ");
INSERT INTO prq_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","‘Yokapayi atziri-payi sitowaa-tsiri Apitantoniki ikyaaki anampiki ithonka yanaapaakiro aipatsiti. Pimpokanaki sintsiini, pintakishiri yokapayi. Onkamintha nomisitowajiri naaka noipatsitiki, aririka nowayiri-tyaari.’ ” ");
INSERT INTO prq_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","Ari ikantzi Pawa: “¡Balaam! Airo piyaatziri pokaintsiri. Airo pimisha-waitziri yokaiti, notasonka-wintani naaka inayitzi yokapayi.” ");
INSERT INTO prq_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","Okanta okitaiti-tamanaji ikantakiri Balaam inampiri-payi Balac: “¡Ayomparí! Pimpiyi pinampiki, ti ininti Pawa noyaata-nakimi.” ");
INSERT INTO prq_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","Ari ipiyajiitaja inampiri-payi Athataa-wini-satzi inampiki tsika isaiki Balac, ikantapajiri: “¡Pinkatharí! Ti ininti iyaatina Balaam.” ");
INSERT INTO prq_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","Yapiitakiro Balac ityaantzi pasini inampiri-payi, oshiki ikarajiitaki, omapiro yiriipirotzi yokaiti. ");
INSERT INTO prq_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","Ijajiitanaki iñiiri Balaam, ikantapaakiri: “¡Ayomparí! Pinkimiro iñaani nowinkathariti Balac itomi Zipor, ikantzimi: ‘Nonintzi pimpoki piñiina. ");
INSERT INTO prq_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","Aritaki nompina-takimi oshiki, ari nantakimiro onkarati pinkantinari. Pimpoki iroñaaka, pintakishiri yokaiti atziri-payi.’ ” ");
INSERT INTO prq_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","Yakanakiri Balaam ityaantani-payi Balac, ikantziri: “Onkanta-wityaa impinaromi Balac iwinkathari-pankoti tsika ijaikitaki kiriiki, aajatzi ooro, airo nopiyathatari Pawa, airo nanaakayiro nantiro inintakayinari, ti onkamiithati kapichiini nanaakayiro. ");
INSERT INTO prq_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","Iro kantacha, pimaawai-tapaaki awiroka, noñaawakiro opaita-rika inkanta-jinari tsitiniriki Pawa.” ");
INSERT INTO prq_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","Okanta tsitiniriki, iñaakaajari Pawa yoka Balaam, ikantakiri: “Tima awiroka ipokasi-jiitzi yokapayi atziri yaanakimi, piyaata-nakiri. Iro kantacha ontzimatyii pantiro onkarati nonkantimiri naaka.” ");
INSERT INTO prq_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","Okanta isaakita-manaji Balaam, iwankita-nakiniro saika-mintotsi ikyaakoitari. Iyaatanakiri inampiri-payi Athataa-wini-satzi. ");
INSERT INTO prq_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","Iro kantacha antaro ikisanaka Pawa ijatanaki Balaam. Iyaawin-takiri awotsiki Imaninkariti Pawa impiyata-wakyaari. Pokaki irirori Balaam ikyaako-takaro ipira, itsipatakari apiti impiratani. ");
INSERT INTO prq_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","Oñaapaakiri ikyaakoitari Imaninkariti Pawa, ikatziyaka awotsiki yairikakiro iwisa-minto, timpaawi-tanaka ikyaakoitari. Ipasata-nakiro Balaam ikyaakoitari inintzi ompampi-thatiro awotsi. ");
INSERT INTO prq_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","Yapiitakiro Imaninkariti Pawa itzikawakiri tsika okaamanchakitzi awotsiki, tsika itanto-taitziro apitiroki onampi-naki. Irootaki awotsi jatachari pankirintsi-masiki iraitziri. ");
INSERT INTO prq_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","Ari oñaapajiri aajatzi ikyaakoitari Imaninkariti Pawa, otzitanaka tantotsiki, anawyaakiri iporiki Balaam. Ari yapiita-nakiro ipasatziro ikyaakoitari. ");
INSERT INTO prq_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","Aikiro iwaaniin-tanakityaa Imaninkariti Pawa okaamanchaki-pirotzi awotsi, tikatsi onkini ontimpai ikyaakoitari, ti onkanti onkini yampatiki aajatzi irako-piroki. ");
INSERT INTO prq_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","Okanta oñaapajiri ikyaakoitari Imaninkariti Pawa, naryaanaka osaawiki. Antaro ikisanaka Balaam, ipasatan-tanakaro inchakii. ");
INSERT INTO prq_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","Ikantakaakaro Pawa, ñaawaitanaki ikyaakoitari, okantanakiri Balaam: “¿Tsikama nokantzimika naaka pipasawai-tantanari, tima mawa papiitakiro pipasatakina?” ");
INSERT INTO prq_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","Yakanakiro Balaam ipira, ikantziro: “Iro nopasatan-tamiri pithainkakina. Ari ontzimimi nosataa-minto, nosataa-kimimi.” ");
INSERT INTO prq_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","Ari okantzi ikyaakoitari: “¿Kaarima naaka pipira pikyaakota-piintari? ¿Arima nokanta-piintzimi pikyaakotana?” Ikantzi Balaam: “Ti.” ");
INSERT INTO prq_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","Ikantakaakaro Pawa iñiiri Balaam ikatziyaka Maninkari awotsiki yairikakiro iwisa-minto. Ari ityiirowanaka Balaam, yoiyootanaka osaawiki ipinkatha-tanakiri. ");
INSERT INTO prq_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","Isampita-nakiri Imaninkariti Pawa, ikantziri: “¡Balaam! ¿Ipaitama pipasawai-tantarori pipira, tima mawa papiitakiro pipasawai-tziro? Tima naaka pokaintsi nompiya-tyaami, tima kaari-pirori pinkantzi-motakana noñaakimi. ");
INSERT INTO prq_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","Iro pipira ñaapaakina, mawa apiitakiro otimpaa-pithatana. Airomi otimpaami, nowamaa-kimimi awiroka, irojatzi añii iroori.” ");
INSERT INTO prq_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","Ari yakanakiri Balaam Imaninkariti Pawa, ikantziri: “¡Nokaaripiro-tzimotakimi! Ti noyoti awirokataki otzikanari awotsiki. Iro kantacha, kaari-piro-rika okantzi-motakami nantziri, iroñaaka nompiyanaji.” ");
INSERT INTO prq_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","Ikantzi Imaninkariti Pawa: “¡Balaam! Piyaata-nakiri ityaantaitani-payi. Iro kantacha onkarati nonkanta-yitimiri naaka, irootaki piñaawaitiri awiroka.” Irootaki iyaatan-tanakiriri Balaam inampiri-payi Balac. ");
INSERT INTO prq_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","Ikanta ikimaki Balac pokaki Balaam, jatanaki imonthaa-wakyaari otzinkamiki inampiki Athataa-wini-satzi, saikatsiri othapyaaki Poimaarini, tsika owiraa-thapita iipatsiti. ");
INSERT INTO prq_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","Ikantawakiri: “¡Balaam! Nontyaantaki chapinki kaimimini. ¿Paitama kaari pipokanta piñiina? ¿Pisiyakaantzi airo noimosirinkimi? ");
INSERT INTO prq_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","Yakanaki Balaam, ikantzi: “¡Pinkimi niyomparí! Aritaki pokakina noñiimi. Iro kantacha ti ontzimi-motina nosintsinka noñaawai-tantyaarori okaratzi nonintziri naaka. Apatziro noñaawaitiro onkarati inintziri Pawa.” ");
INSERT INTO prq_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","Ikanta Balaam itsipatakari Balac jaitijiitaki Awotsiki-winiki. ");
INSERT INTO prq_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","Ari iwamaakaan-tapaaki Balac ipiraitari-payi. Ityaantaki yaita-nakiniri Balaam aajatzi inampina-payi. ");
INSERT INTO prq_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","Okanta okitaiti-tamanaji, yaanakiri Balac ikaimakaantani Balaam anta Inkani-wirii-toniki. Ari yaminako-takiro okoñaataki iwanko-thaanti-jiitaka Israel-iiti. ");
INSERT INTO prq_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","Ari ikantanaki Balaam: “Piwitsikina aka 7 pomitai-rontsi. Piwamaina 7 kiripiri vaca aajatzi 7 pasini ipiraitari.” ");
INSERT INTO prq_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","Imatakiro Balac okaratzi ikantakiriri Balaam. Ari itsipatakari Balac yoka Balaam ipomitakiri aparoni kiripiri vaca, aajatzi aparoni ipiraitari okaratakira 7 pomitai-rontsi. ");
INSERT INTO prq_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","Ikantzi Balaam: “¡Pinkatharí! Ari pisaika-wintawakiri pipomitani. Nojatawaki naaka, onkamintha imonthai-yaana Pawa. Aritaki nonkaman-takimi awiroka onkarati inkantinari.” Jatanaki Balaam ikinakiro opitziryaa-masitaka otzisi. ");
INSERT INTO prq_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","Ikanta imonthaakari Pawa yoka Balaam, ikantzi Balaam: “¡Pawá! Nokantaki iwitsikaiti 7 pomitai-rontsi, nopomitaki aparoni vaca aajatzi aparoni ipiraitari okaratakira 7 pomitai-rontsi.” ");
INSERT INTO prq_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","Ari ikantakaakaro Pawa iyotiro Balaam iñaawaitiri, ikantakiri: “Pimpiyi isaikaki Balac, pinkamantiri okaratzi nokanta-kimiri naaka.” ");
INSERT INTO prq_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","Ari ipiyaari Balaam iñaapajiri Balac isaikawin-tziri ipomitani, itsipayi-takari inampiri-payi Athataa-wini-satzi. ");
INSERT INTO prq_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","Ari iñaawai-tanakiro Balaam iyotakayi-takiriri ñaantsi, ikantanaki: Nopoñaakaro Tonkaariitoniki yamakina Balac, Nokinapaakiro otzisi-masiki tsika isitowa-piintzi ooryaatsiri, ikaimakaan-takina Iwinkathariti Athataa-wini-satzi, ikantakina: “¡Pimpoki, pintakishiri Israel-iiti! ¡Pimpoki, pimishatiri icharini-payi Jacob!” ");
INSERT INTO prq_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","¿Paitama nontakisan-tyaariri naaka kaari inintzi Pawa intakisaitiri? ¿Paitama nomisha-tantyaariri naaka kaari imishatzi irirori Pawa? ");
INSERT INTO prq_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","Tima yoka Pawa, ti isiyaari atziri-payi thaiyawaari, Ti inasityaaro okaratzi ikinkithasiri-takari. Aririka inkanti: “Iroka nantiri.” Aritaki yantakiro. Imonkara-tziro maaroni ikasiya-kaantziri. ");
INSERT INTO prq_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","Ikantai-takina naaka nontasonka-wintanti. Tima imatakiro Pawa itasonka-wintantaki irirori, airo nomatajiro naaka noipyaa-ñaani-tajiri. ");
INSERT INTO prq_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","Ti iñiitajiro iyaari-pironka icharini-payi Jacob, Ti iñiitajiro aajatzi ikowiinka-takowaitzi ishininka-payi Israel-iiti. Tima yasi iwiro itsipata-piintakari Iwawani. Iriitaki itharowin-tapiin-takari iwinkathari-titaari. ");
INSERT INTO prq_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","Tima yoka Pawa, amajiriri isaikawitaka Apitantoniki, Otzimimo-tziri isintsinka osiyaaromi isintsinka katsi-mari-payi. ");
INSERT INTO prq_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","Tikatsi ompaitzi-motyaarini icharini-payi Jacob takisaantsi, Tikatsi ompaitzi-motyaari Israel-iiti mishataantsi. Iroñaaka ankanta-taitiri Israel-iiti: ¡Oshiki yantzimota-kimiri Pawa kaari iñaapiin-taitzi! ");
INSERT INTO prq_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","Ikimitakari kashikari yokaiti, Ikatziya yasaryaanta. Airo imorinka irojatzi yatsikan-takyaariri yatsikani. Iiranakiro iriraani iwamaani-payi. ");
INSERT INTO prq_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","Ari ikantanaki Balac: “¡Balaam! Ti pinintatyii pimishatiri, airo pitasonka-wintairi aajatzi.” ");
INSERT INTO prq_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","Ikantzi Balaam: “¡Balac! Tima nokantzi-takami: ‘Onkarati inkantinari Pawa, irootaki nantiri.’ ” ");
INSERT INTO prq_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","Ari isaikajii-tapaaki Israel-iiti anta Inchatoniki. Imayimpi-waiyi-takiro Athataa-wini-sato. ");
INSERT INTO prq_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","Okaimakiri Israel-iiti intsipa-tyaaro opomitziniri atsipita-kaari pawaniro-payi. Yakyoo-tapiin-takiro Israel-iiti. Ipinkatha-waitakiri owawa-niroti-payi. ");
INSERT INTO prq_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","Ari okantakari ikimisan-tantakariri Israel-iiti pawaniro Inkaniwiri anta Paraankaitoniki. Irootaki ikisanta-nakariri Pawa yoka Israel-iiti. ");
INSERT INTO prq_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","Ari iñaanata-jiriri Pawa yoka Moisés, ikantajiri: “¡Moisés! Papatotiri maaroni ijiwariti-payi Israel-iiti, pisitzika-yitiri yokapayi osaikira, intaina-ryaajyaari nomasirinka maaroni Israel-iiti.” ");
INSERT INTO prq_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","Ipoñaa ikaimakiri Moisés pasini ijiwariti-payi Israel-iiti, ikantakiri: “Piwamairi ashininka-payi ikaratzi aapatyaa-kariri pawaniro Inkaniwiri saikatsiri Paraankaitoniki.” ");
INSERT INTO prq_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","Ikanta aparoni ishininka Israel-iiti yamaki Maimani-wini-sato tsika yapatojiitaka ishininka-payi, iñaawakiri Moisés, aajatzi maaroni Israel-iiti isaikajiitzi iraako-waijiita iriroriiti ikyaapiin-taitzira Tasorintsi-thaanti. ");
INSERT INTO prq_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","Ikanta iñaawakiri irirori Finees itomi Eleazar icharini Ompira-tasorintsi-taari Aarón, isitowa-sitanakiri ipiyojiitaka ishininka, yaanakiro iwisa-minto. ");
INSERT INTO prq_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","Ijatasitakiri yoka ishininka tsika iwanko-thaanti-yitaka ishininka-payi, isataakiri imotyaaki apitiroiti, sirampari aajatzi kooya. Aripaiti okarata-paaki mantsiyarintsi owamaayi-takiriri Israel-iiti. ");
INSERT INTO prq_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","Tima oshiki-piro ikaratzi Israel-iiti owamaakiri mantsiyarintsi. ");
INSERT INTO prq_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","Ari iñaanatajiri Pawa yoka Moisés, ikantajiri: ");
INSERT INTO prq_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","“Paanakiri maaroni Israel-iiti inkisawin-tajyaa, ijati iwayiri-tajyaari Maimani-wini-satzi. Aririka pimatakiro, aritaki pintsipa-siri-tajyaari piwaisatziti-payi.” ");
INSERT INTO prq_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","Ikaimakiri Moisés maaroni ishininka-payi, ikantakiri: “Piwitsika-yitajyaa awirokaiti, pijati pinkisa-wintajyaa piwayiri-tyaari Maimani-wini-satzi, tima irootaki inintakiri Pawa.” ");
INSERT INTO prq_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","Imatakiro iwayiritari Maimani-wini-satzi, yapirotakiri iwamaakiri maaroni, imatakiro okaratzi ikantakiriri Pawa yoka Moisés. ");
INSERT INTO prq_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","Ari ikaratzi iwamaanakiri iwinkathariti-payi Maimani-wini-satzi. Yoka ipaitawi-jiita: Evi, Requem, Zur, Hur, Reba. Tima inkarati 5 pinkathari iwamaakiri. Iwisa-nakiri aajatzi Balaam itomi Beor. ");
INSERT INTO prq_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","9","Ithonka-nakiro Israel-iiti inosika-nakiro kooya-payi Maimani-wini-sato, yaayita-nakiri iinchii-rikiti. Ari ikaratzi yaanakiri ipira-payi, i-vaca-ti aajatzi iwaararo-payi, maaroni. ");
INSERT INTO prq_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","Ari ikantawajiri Moisés ishininka-payi: “¡Ashininká! Ipaitama kaari piwamaantaro iroka-payi kooya? ");
INSERT INTO prq_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","Irooyitaki iyomitaa-naari Balaam kantakaan-takirori ikaaripiro-tzimotan-takariri ashininka-payi Pawa anta Paraankaitoniki. Irootaki iwasankitaan-takariri Pawa ashininka-payi ikamanta-yitakari.”");
INSERT INTO prq_vpl VALUES ("DT1_1","006_1_1","DEU","1","1","1","Iroka ikinkitha-waita-kaakiriri Moisés ishininka-payi Israel-iiti isaikan-tawitari otzisi-masiki isitowa-piintzi ooryaatsiri anta Owaryiinkaariniki, ipaitai-tziro Mamiriwini, omontitakaro Inkaari Kiraankaaro. Osaika-nampitziro Morontoni, Isiko-wini, Kitamaaro-jaari, Otantaarini aajatzi Oorowini. ");
INSERT INTO prq_vpl VALUES ("DT6_1","006_6_1","DEU","6","1","1","Iroka ikantakaantani, iwinkakaantani aajatzi isinita-kaantani Awawani. Ikantakina noyomitaa-jimiro, irootaki pimonkara-tapiin-tajiri anta kipatsiki pasitajyaari awirokaiti. ");
INSERT INTO prq_vpl VALUES ("DT6_2","006_6_2","DEU","6","2","2","Irootaki pimpinkatha-tanta-jyaariri Pawa, pimonkara-tajiro iwinkakaantani, aajatzi ikantakaantani okaratzi nokaman-tzimiri. Irasi iwiro yantapiin-tairo pitomi-payi, aajatzi inkarati pincharini-tajyaari. Irootaki pañaanta-jyaari oshiki osarintsi. ");
INSERT INTO prq_vpl VALUES ("DT6_3","006_6_3","DEU","6","3","3","¡Pinkimi Israel-iiti! Ontzimatyii pimonkara-tajiro nokanta-kimiri. Irootaki pisaikan-tajyaari kamiitha anta kipatsiki, tsika oshookapaji oshiki pankirintsi, tsika itzimapaji aajatzi oshiki ipiraitari. Aritaki noshikyaa-jimiri pishininka anta. Irootaki iñaani Piwinkathariti, Iwawani piwaisatziti. ");
INSERT INTO prq_vpl VALUES ("DT6_4","006_6_4","DEU","6","4","4","¡Pinkimi Israel-iiti! Yoka Awinkathariti Pawa, aparoni ikanta Ipinkatharitzi irirori. ");
INSERT INTO prq_vpl VALUES ("DT6_5","006_6_5","DEU","6","5","5","Pininta-piro-tajiri, pininta-siri-tajiri, pininta-sintsi-tajiri aajatzi. ");
INSERT INTO prq_vpl VALUES ("DT6_6","006_6_6","DEU","6","6","6","Osiriki piwapiin-tairo maaroni ñaantsi okaratzi nokanta-kimiri. ");
INSERT INTO prq_vpl VALUES ("DT6_7","006_6_7","DEU","6","7","7","Irootaki piyomitaa-najiriri awirokaiti pitomi-payi. Piñaawai-tapiin-tajiro piwankoitiki, aririka paniiti awotsiki, aririka piwitsika-najyaa pimaanta-najyaari, aririka pimpiriin-tamanaji. ");
INSERT INTO prq_vpl VALUES ("DT6_8","006_6_8","DEU","6","8","8","Poosota-kotyaaro pakoki pisankina-takiro, aajatzi pipankainaki. ");
INSERT INTO prq_vpl VALUES ("DT6_9","006_6_9","DEU","6","9","9","Pisankina-yitairo pitzinkamiki, aajatzi asitakoroki piwanko-payi. ");
INSERT INTO prq_vpl VALUES ("DT7_1","006_7_1","DEU","7","1","1","Aririka inkanta-kaakyaaro Piwawani, pinkyaaki-rika kipatsiki pasitajyaari awirokaiti, ari piñaakiri Pawa imisitowiri 7 iriipirori ishininkata-wakaa-jiita anta: Tharowan-taarini-satziiti, Pitzitharini-satziiti, Tonkaarisatziiti, Owintini-satziiti, Nampitsi-wini-satziiti, Thaantiwinisatziiti, aajatzi Kayaawinisatziiti. ");
INSERT INTO prq_vpl VALUES ("DT7_2","006_7_2","DEU","7","2","2","Aririka imatakiro Piwawani iitsinampaa-kayimiri yokaiti, pimapiro-tatyiiri papirotiri, airo paapatyaa-waitari, airo piwawisaako-waitzi aparoni. ");
INSERT INTO prq_vpl VALUES ("DT7_3","006_7_3","DEU","7","3","3","Airo pishininka-waita aparoni, pininti paakayiri pisintoiti itomiiti irirori, airo iinanta-waitaro irisintoiti irirori pitomiiti awirokaiti. ");
INSERT INTO prq_vpl VALUES ("DT7_4","006_7_4","DEU","7","4","4","Tima airo imiraawin-taana naaka pitomiiti, apatziro ininti impinkatha-waitiri pawaniro-payi. Irootaki nonkisan-tyaamiri awirokaiti, intsipaiti napiroo-tajimi. ");
INSERT INTO prq_vpl VALUES ("DT7_5","006_7_5","DEU","7","5","5","Irootaki pimporokan-tyaaniriri awirokaiti maaroni ipomi-pirini-minto, ari pinkimitaa-kiniri osiyakaaro iwawa-niroti Inkaariwiro. Papirotiri pintayi-tajiri isiyakaa-rontsiti-payi. ");
INSERT INTO prq_vpl VALUES ("DT7_6","006_7_6","DEU","7","6","6","Tima tasorintsi pinkantzi-motajyaari awirokaiti Piwawani. Iriitaki oyosiita-jimiri yasitajyaami maaroni, ti pisiyaari pasini-satzi atziri-payi ikaratzi saikatsiri aka kipatsi, panaajiri awirokaiti iyosiitajimi Pawa. ");
INSERT INTO prq_vpl VALUES ("DT8_1","006_8_1","DEU","8","1","1","Ontzimatyii pinthotyaajiro ikantakaan-taitani okaratzi nokanta-kimiri, aritaki pisaika-yitaji kamiitha. Aritaki piñaajiro pishiki-pirotaji. Irootaki pasitan-tajyaarori kipatsi ikasiya-kaakiriri Pawa pairani awaisatziti-payi. ");
INSERT INTO prq_vpl VALUES ("DT8_2","006_8_2","DEU","8","2","2","Osiriki piwiro otzisi-masi tsika ikinakaa-paakimi pairani Pawa, tima 40 osarintsi iñaanta-siri-takami, ikisa-siri-takaa-waitakami aajatzi. Iro iyotantyaari tsika pikanta-waita, aririka pimonkara-takiniri maaroni ikantakaantani. ");
INSERT INTO prq_vpl VALUES ("DT8_3","006_8_3","DEU","8","3","3","Tima oshiki ikisa-siri-takaa-waitakami, itashaaniin-takaa-waitakami. Iro kantacha ipakimi piwariti pipaitakiri ‘paitama’. Ti piñaawi-tapiin-tyaaro iroka owaritintsi aajatzi piwaisatziti-payi ti iñiiro irirori pairani. Ari iyomitaimiri Pawa ti apatziro owañaantzi okaratzi iwaitari, tima irootaki owañaa-pirotan-tatsiri ankimisantajirori okaratzi ikantairi Pawa. ");
INSERT INTO prq_vpl VALUES ("DT8_4","006_8_4","DEU","8","4","4","Tima okaratzi 40 pisarintsi-takotaki pairani otzisi-masiki, titzimaita pinthon-kakotyaa piithaari, ti pijaaniya-waiti piitzi aajatzi. ");
INSERT INTO prq_vpl VALUES ("DT8_5","006_8_5","DEU","8","5","5","Ontzimatyii piyotaji iriitaki Pawa otampatzika-siritzimiri. Ari isiyari iriritaitari, itampatzikatziri itomi. ");
INSERT INTO prq_vpl VALUES ("DT18_9","006_18_9","DEU","18","9","9","Aririka pinkyaaki kipatsiki ipimiri Pawa, paamaiyaa piyotziro = kari okaratzi yamiyitari nampitarori anta yantayitziro kowiinkari iisaniin-taitani. ");
INSERT INTO prq_vpl VALUES ("DT18_10","006_18_10","DEU","18","10","10","Airo itzimawaitzi aparoni pishininka nintatsini impomitiri iwaiyani paamariki yasitakai-yaari iwawani, nintatsini iñaawya-tantyaa, nintatsini yathataantyaa, nintatsini iyotanti, nintatsini yantyawiyariti, ");
INSERT INTO prq_vpl VALUES ("DT18_11","006_18_11","DEU","18","11","11","nintatsini imishatanti, nintatsini imatsikanti, nintatsini iniwyatantyaa, nintatsini inkinkitha-waita-kayiri kamatsiri. ");
INSERT INTO prq_vpl VALUES ("DT18_12","006_18_12","DEU","18","12","12","Tima oshiki okowiinkatzi-motziri Pawa ikaratzi antayitzirori akantakiri. Irootaki imisitowan-takariri Pawa asiwitarori inampi airo pitsipa-tantari yantayitziro kowiinkari-payi. ");
INSERT INTO prq_vpl VALUES ("DT18_13","006_18_13","DEU","18","13","13","Kamiitha-siri pinkantzi-motajyaari awirokaiti Piwawani. ");
INSERT INTO prq_vpl VALUES ("DT18_14","006_18_14","DEU","18","14","14","Tima yokapayi atziri-payi, asitarori iipatsiti pasitajyaari awirokaiti, ikimisantziri yotantaniri-payi, antyawiyari-payi. Irooma awirokaiti, ti isinitimi Piwawani pimayitajiro iroka-payi. ");
INSERT INTO prq_vpl VALUES ("DT18_15","006_18_15","DEU","18","15","15","Ari intyaankaki apaata Piwinkathariti Pawa pasini Kamantan-tzinkari, ari isiya-kota-paakyaanaro naaka ityaankakina. Ashininka inatyii. Ontzimatyii pinkimisan-tajiri. ");
INSERT INTO prq_vpl VALUES ("DT18_16","006_18_16","DEU","18","16","16","Irootaki pikampi-takiriri pairani Pawa Mamirii-toniki, papatojiitaka, pikantaki: “Ti noninti napiitiro nonkimiri iñaawaiti Pawa. Ti noninti noñiiro antaroiti paamari. Nokami = kari.” ");
INSERT INTO prq_vpl VALUES ("DT18_17","006_18_17","DEU","18","17","17","Irootaki ikantan-takanari naaka Pawa: “Kamiithataki ikantakiri pishininka-payi. ");
INSERT INTO prq_vpl VALUES ("DT18_18","006_18_18","DEU","18","18","18","Tima naaka kantakai-yaaroni iñiitaji Kamantan-tzinkari kimityaamini awiroka, ishininka inatyii pincharini-tajyaari. Nowajiniri noñaani ipaantiki. Iriitaki kinkitha-taironi onkarati nonkantiriri. ");
INSERT INTO prq_vpl VALUES ("DT18_19","006_18_19","DEU","18","19","19","Iro kantacha, itzimi-rika kaari kimisan-tairini Kamantan-tzinkari ipairyaajiro nowairo, aritaki nowasankitaajiri yokaiti.” ");
INSERT INTO prq_vpl VALUES ("DT19_15","006_19_15","DEU","19","15","15","Intzimi-rika mishakowintaari, impoña inintajiiti jiwari-payi tsika inkantiri iwasankitairi, ontzimatyii intzimi apiti ñaakotirini ikinakaa-sitakari. Iro kamiitha-pirota-tsiri intzimi-rika mawa atziri ñaakotirini. Irooma inkantyaa aparoni ñaakotirini, airo okanta-pirota. ");
INSERT INTO prq_vpl VALUES ("DT25_1","006_25_1","DEU","25","1","1","Ipoñaa iñaanatairi Moisés ishininka-payi, ikantziri: “Aririka pimaimanita-wakaiyaa, ontzimatyii pijata-sitiri jiwari, iriitaki amina-kotimini itzimi-rika tzimatsiri ikinakaa-sitani, irima kaari tzimatsini ikinakaa-sitani tikatsi inkantaitiri. ");
INSERT INTO prq_vpl VALUES ("DT25_2","006_25_2","DEU","25","2","2","Aririka inintaiti impasaitiri tzimatsiri ikinakaa-sitani, iriitakira kantatsini jiwari inaryiitiri osaawiki impasaitiri. Arira omonkaratyaaro impasaitiri tsika-rika okaratzi ikinakaa-sitakari. ");
INSERT INTO prq_vpl VALUES ("DT25_3","006_25_3","DEU","25","3","3","Onkarati 40 impasaitiri, airo yanaakai-tziro. Aririka yanaakai-takiro tira ari onkantyaa iwasankitai-tanti, iwasinonkai-tantatzii. ");
INSERT INTO prq_vpl VALUES ("DT25_4","006_25_4","DEU","25","4","4","Aririka pantawaita-kairi pipira, tima ti pintashi-niinta-kaawaitiri.” ");
INSERT INTO prq_vpl VALUES ("DT25_5","006_25_5","DEU","25","5","5","Aikiro ikantatzii Moisés: “Aririka pintsipatyaari pirintzi-payi piwankoki, ompoña ikamaki aparoni titzimaita iwaiyan-takairo iina. Iroka kinankaro kooya, airo osinitaa-ntsitzi aminaji pasini sirampari kaari yirintzita oimini. Iriitaki aajironi iririntzi okaakiini iroka kinankaro. Tima iriitaki oimithori iroori. ");
INSERT INTO prq_vpl VALUES ("DT25_6","006_25_6","DEU","25","6","6","Aririka intzimaji ityaaroni otomi, yaakotairi iwaironi kamaintsiri iririntzi, ari onkantyaa airo opyaakotanta iwairo ikarajiitzi ishininkata-wakaa Israel-iiti. ");
INSERT INTO prq_vpl VALUES ("DT31_1","006_31_1","DEU","31","1","1","Ari ikamanta-jiriri Moisés ishininka-payi iroka ñaantsi, ");
INSERT INTO prq_vpl VALUES ("DT31_2","006_31_2","DEU","31","2","2","ikantajiri: “Aritaki tzimaki 120 nosarintsiti, ti nosintsitaji naniitaji. Tima ikantakina Pawa: ‘Airo pimontyaaro awiroka Owaryiinkaarini.’ ");
INSERT INTO prq_vpl VALUES ("DT31_3","006_31_3","DEU","31","3","3","Iro kantacha, iriitaki Pawa jiwatajimini awiroka-payi. Iriitaki apirotairini atziri-payi tsika pinkinayiti, onkini paajiro iipatsiti. Iriima Josué, iriitaki pijiwariti-tajyaari awirokaiti. Tima ari ikantzi Piwawani.” ");
INSERT INTO prq_vpl VALUES ("DT34_5","006_34_5","DEU","34","5","5","Aritaki kamaji irirori Moisés, impiratani Pawa. Ikamajiro iipatsitiki Athataa-wini-satzi, tima irootaki ikantakiriri Pawa. ");
INSERT INTO prq_vpl VALUES ("DT34_6","006_34_6","DEU","34","6","6","Ikitaitajiri owintini-pathatzi anta Athataa-winiki, omontitakari otzisi Paraankaitoni-panko. Tikatsi ñiironi tsika ikitaitakiri irojatzi iroñaaka. ");
INSERT INTO prq_vpl VALUES ("DT34_7","006_34_7","DEU","34","7","7","Tima tzimaki 120 isarintsiti Moisés ikamantajari. Ainiro yokichaawita kamiitha, ainiro iñaapirowita kamiitha. ");
INSERT INTO prq_vpl VALUES ("DT34_8","006_34_8","DEU","34","8","8","Oshiki iiraawai-jiitaka Israel-iiti ikamajira Moisés anta iwintini-pathatiki Athataa-wini-satzi. Tima okaratzi 30 kitaitiri iraakoi-takari, irojatzi imonkara-tanta-karori iwasiri-takowai-taitari. ");
INSERT INTO prq_vpl VALUES ("DT34_9","006_34_9","DEU","34","9","9","Tima pairani tikira ikami Moisés, iwasi-patzii-totanajiri Josué, itomi Nun, iyomitaa-naanajiri intasonka-wintai-tantyaariri irirori. Irootaki ipinkatha-tanta-nakariri ishininka-payi Josué, yantayitziro okaratzi ikantayi-takiriri pairani Pawa Moisés.");
INSERT INTO prq_vpl VALUES ("JS1_1","007_1_1","JOS","1","1","1","Tima aritaki kamaji irirori Moisés, impiratani Pawa. Ari iñaanatajiri Pawa yoka Josué, itomi Nun, itsipata-piintari Moisés. Ikantajiri: ");
INSERT INTO prq_vpl VALUES ("JS1_2","007_1_2","JOS","1","2","2","“¡Josué! Tima aritaki kamaji nompiratani Moisés. Awiroka montyaakairini maaroni pishininka-payi intatzikiro Owaryiinkaariniki, pijati anta kipatsiki nasitakaajyaamiri maaroni awirokaiti. ");
INSERT INTO prq_vpl VALUES ("JS1_3","007_1_3","JOS","1","3","3","Naakataki opayitaki-mirori, tima irootaki nokantzi-takariri pairani Moisés, nokantakiri: ‘Naaka opimironi maaroni kipatsi tsika-rika pinkina-yitaki’. ");
INSERT INTO prq_vpl VALUES ("JS1_4","007_1_4","JOS","1","4","4","Iroka onkarataji pipatsiti. Ompoñaa-nakyaaro aka otzisi-masiki, Kitiniitoniki irojatzi Antaraa-niki, maaroni iipatsiti Tharowan-taarini-satzi, irojatzi anta Inkaariki Antaro tsika ikyaapiintzi ooryaatsiri. ");
INSERT INTO prq_vpl VALUES ("JS1_5","007_1_5","JOS","1","5","5","Airo itzimaji iitsinampaimini tsika-rika pisaika-yitaji. Naakataki tsipata-piintyaamini nokimitaakiri pairani Moisés notsipatakari. Airo nowapintaimi, nasi nowatyiiro nontsipata-jyaami. ");
INSERT INTO prq_vpl VALUES ("JS1_6","007_1_6","JOS","1","6","6","Piriipiroti, ñaapiroki pinkantyaa. Tima awiroka aakaajirini kipatsi maaroni pishininka-payi. Irootaki nokasiya-kaakiriri pairani piwaisatziti-payi. ");
INSERT INTO prq_vpl VALUES ("JS1_7","007_1_7","JOS","1","7","7","Apatziro nonintzi piriipiroti, ñaapiroki pinkantyaa. Pinkimisanta-najiro noñaani okaratzi iyomitaa-kimiri nompiratanini Moisés. Oisokiro piwajiro, irootaki ojatzimotan-tajyaamiri kamiitha onkarati pantayitajiri. ");
INSERT INTO prq_vpl VALUES ("JS1_8","007_1_8","JOS","1","8","8","Amiwaanti piñaawaita-piintairo sankinarintsi iñaani Pawa, tima osiriki piwairo kitaitiri aajatzi tsitiniri, irootaki pimatan-tajyaarori pantayitajiro okaratzi osankinatain-chari. Tima ari ojatzimotakimi kamiitha onkarati pantayitairi. ");
INSERT INTO prq_vpl VALUES ("JS1_9","007_1_9","JOS","1","9","9","Naakataki kantzimiri piriipiroti, ñaapiroki pinkantyaa. Airo ayimawaitzimi pitharowanka, airo piwashaanta-waita, tima naaka Piwawani, nasi nowajiro nontsipatyaami tsika-rika pinkina-yitaji.” ");
INSERT INTO prq_vpl VALUES ("JS2_1","007_2_1","JOS","2","1","1","Ikanta Josué ityaantaki manaan-tsikiini apiti atziri ipoñaanakaro Inchatoniki, ikantawakiri: “Pijati Owintiniki paminiro tsika okantawaita nampitsi Kasiryaari.” Ikanta ijajiitaki, ariitaka owankoki aparoni kooya mayimpiro paitachari Rahab, ari imaajiita-paaki. ");
INSERT INTO prq_vpl VALUES ("JS2_2","007_2_2","JOS","2","2","2","Iro kantacha tzimatsi kamanta-kiriri pinkatha-ritatsiri Kasiryaariki, ikantai-takiri: “Ari ipokiri Israel-iiti yaminiro tsitiniri anampi.” ");
INSERT INTO prq_vpl VALUES ("JS2_3","007_2_3","JOS","2","3","3","Ari ikaimakaan-takiro pinkathari iroka kooya, Rahab, ikantakiro: “Pimisitowiri ariitain-chari piwankoki, ipokatzii yaminiro anampi.” ");
INSERT INTO prq_vpl VALUES ("JS2_4","007_2_4","JOS","2","4","4","Iro kantacha omanakiri iroori yoka apiti atziri, okantanakiri pinkathari: “Omapiro yariitakana apiti atziri, iro kantacha ti noyoti tsika-rika ipoñaa. ");
INSERT INTO prq_vpl VALUES ("JS2_5","007_2_5","JOS","2","5","5","Jaitijiitaji otsitiniityaanaki, yasitai-tanajiro nampitsi, tira noyoti tsika-rika ikinanaji. Pinintzi-rika pimpatzimatiri, pimpatzimata-nakiri, aritaki piyaata-wajiri.” ");
INSERT INTO prq_vpl VALUES ("JS2_6","007_2_6","JOS","2","6","6","Iro kantacha iroka kooya, owatiitakiri ariitzinkari jinoki owankoki, omanakiri tsika owankita-kotziro owankiri-payi. ");
INSERT INTO prq_vpl VALUES ("JS2_7","007_2_7","JOS","2","7","7","Ikanta yokapayi ityaantani pinkathari, iyaatasita-nakiri ikinajiitanaki Owaryiinkaariniki, irojatzi montyii-rontsiki. Ikanta isitowa-jiita-nakira ityaantani pinkathari, yasitai-tanakiro nampitsi. ");
INSERT INTO prq_vpl VALUES ("JS2_8","007_2_8","JOS","2","8","8","Tikira imaajiiti, atiitapaaki Rahab, okantapaakiri: ");
INSERT INTO prq_vpl VALUES ("JS2_9","007_2_9","JOS","2","9","9","“Noyotzi iriitaki Pawa opajimirori iroka kipatsi, iri kantakaarori notharowa-kaantamiri. Ari ikantakari maaroni, oshiki itharowan-takami. ");
INSERT INTO prq_vpl VALUES ("JS2_10","007_2_10","JOS","2","10","10","Tima nokima-kotakimi tsika okantaka pisitowan-taari Apitantoniki, ikantakaakaro Pawa ompiryaati Inkaari Kiraankaaro otzikawakiri pawishimi. Nokima-kotakimi aajatzi piwa-nakiri Sehón aajatzi Og, papitiro-ryaanakiri iwinkathariti Tonkaarisatzi. Pimatanakiri ikaratzi nampitarori intatzikiro Tonkaarisatzi. ");
INSERT INTO prq_vpl VALUES ("JS2_11","007_2_11","JOS","2","11","11","Antaroiti notharowa-jiitanaki nokima-kotakimi, tikatsi matironi impiyatyaami awirokaiti. Tima yoka Piwawanitari awirokaiti, irijatzi Pawatatsiri inkitiki aajatzi aka kipatsiki. ");
INSERT INTO prq_vpl VALUES ("JS2_12","007_2_12","JOS","2","12","12","Irootaki nonintantari paakamiithatiri noshininka-mirinka naaka, pimatiri nokimitaa-wakimi awiroka. Pimpairyiiri iwairo Pawa noyotan-tyaari omapiro pimonkaratiro nonkampitimiri. ");
INSERT INTO prq_vpl VALUES ("JS2_13","007_2_13","JOS","2","13","13","Iroka nonintziri: Airo piwana nokarajiitaki! Asitanari, noyaariri, nirinto-payi, maaroni.” ");
INSERT INTO prq_vpl VALUES ("JS2_14","007_2_14","JOS","2","14","14","Ikantajiitzi irirori: “Aririka nawisakotaki naaka ari pawisakotzi-takyaa awirokaiti, airorika pikamanta-kotana. Aririka yasitakaa-kyaanaro Pawa iroka kipatsi, aritaki nonisironkatakimi, omapiro.” ");
INSERT INTO prq_vpl VALUES ("JS2_15","007_2_15","JOS","2","15","15","Tima otanto-nampiki nampitsi osaiki owanko Rahab, owaryaa-thataki siwitha intakiroki, ari inkinanakiri isoronka-najiro ijataji. ");
INSERT INTO prq_vpl VALUES ("JS2_16","007_2_16","JOS","2","16","16","Okantawajiri: “Pinkinanaji otzisi-masiki, airo iñaanta-waami amina-minatzimiri. Mawa kitaitiri pimañaa anta, irojatzi impiyan-tajyaari amina-minatzimiri. Aripaiti pijataji awiroka.” ");
INSERT INTO prq_vpl VALUES ("JS2_17","007_2_17","JOS","2","17","17","Ikantanakiro irirori: “Aritaki nomatakimiro pikowa-kota-kinari, airo namatawitzimi. ");
INSERT INTO prq_vpl VALUES ("JS2_18","007_2_18","JOS","2","18","18","Aririka nompiya-paaki nampitsiki, papiitiro piwaryaa-thatiro siwitha kityonka-tharo nosoronkan-tanajyaari. Papatotiri piwankoki piri, piniro, piyaariri, maaroni ishininka-payi asitamiri. ");
INSERT INTO prq_vpl VALUES ("JS2_19","007_2_19","JOS","2","19","19","Iriima kaari apatota-chani piwankoki aritaki iwai-takiri, iriitaki kanta-sityaaroni, tira naaka. Irooma iwai-takiri saikain-tsiri piwankoki, naaka kanta-sityaaroni. ");
INSERT INTO prq_vpl VALUES ("JS2_20","007_2_20","JOS","2","20","20","Aririka pikamantantaki awiroka, airo nomonkaratzimiro nokanta-kimiri naaka.” ");
INSERT INTO prq_vpl VALUES ("JS2_21","007_2_21","JOS","2","21","21","Ari okantanaki iroori: “Kamiithataki.” Aakiro kityonka-thari siwitha owaryaa-thatakiro tantotsiki, owithata-waari, jaitijiitaji apiti atziri. ");
INSERT INTO prq_vpl VALUES ("JS2_22","007_2_22","JOS","2","22","22","Ikanta ijajiitaki, ariitaka otzisi-masiki, okaratzi mawa kitaitiri imanajiitaka, irojatzi ipiyantaari amina-minatziriri. Oshiki yamina-mina-witakari awotsiki, titzimaita iñiiri. ");
INSERT INTO prq_vpl VALUES ("JS2_23","007_2_23","JOS","2","23","23","Ikanta yoirinka-jiitaja apiti atziri, imontyaa-naaro Owaryiinkaarini, ariijiitaja isaiki Josué, ikamanta-pajiri okaratzi awishi-mota-kiriri. ");
INSERT INTO prq_vpl VALUES ("JS2_24","007_2_24","JOS","2","24","24","Ikantapaji Josué: “Isinita-kairo Pawa maaroni kipatsi. Ayimatakiri itharonka maaroni nampitarori anta, oshiki itharowa-kaakai arokaiti.” ");
INSERT INTO prq_vpl VALUES ("JS3_1","007_3_1","JOS","3","1","1","Okanta okitaitita-manaji, yananinkanaka Josué itsipata-naari maaroni ishininka-payi yookanajiro isaikawita-paaka Inchatoniki, ariijiitaka Owaryiinkaarini. Ari imaajiita-paaki tikira imontyiiyaata intatzikiro. ");
INSERT INTO prq_vpl VALUES ("JS3_2","007_3_2","JOS","3","2","2","Okanta isaikapaaki mawa kitaitiri, ithotyaakiro ijiwariti Israel-iiti yaminakiro iwanko-thaanti-payi ishininka. ");
INSERT INTO prq_vpl VALUES ("JS3_3","007_3_3","JOS","3","3","3","Iyomitaakiri maaroni ishininka-payi, ikantakiri: “Aririka piñaakiri Ompira-tasorintsitaari Leví-iti yanatanakiro itasorintsi-mokoti Pawa, yashaata-kayiro, pijajiiti awirokaiti, piyaata-nakiri. ");
INSERT INTO prq_vpl VALUES ("JS3_4","007_3_4","JOS","3","4","4","Onkini piñiiro tsika pinkina-jiiti, tima tikatsi kinatsini pairani awirokaiti aka. Airotzimaita pitsitokaro tasorintsi-moko, intaina pinkantyaa pampoijiiti.” ");
INSERT INTO prq_vpl VALUES ("JS3_5","007_3_5","JOS","3","5","5","Ari ikantanakiri Josué ishininka-payi: “¡Piwitsika-siri-jiityaa maaroni, tima onkitaititamanaji iñaakaimiro Pawa kaari piñaapiintzi!” ");
INSERT INTO prq_vpl VALUES ("JS3_6","007_3_6","JOS","3","6","6","Ikantakiri aajatzi Ompira-tasorintsitaari-payi: “Paanakiro tasorintsi-moko, pijiwatiri maaroni ashininka-payi pashaa-jiiti.” Yaanakiro Ompira-tasorintsitaari-payi tasorintsi-moko, ijiwata-nakiri maaroni ishininka-payi ashaajiitanaka. ");
INSERT INTO prq_vpl VALUES ("JS3_7","007_3_7","JOS","3","7","7","Iñaanata-nakiri Pawa yoka Josué, ikantziri: “Iroñaaka nonkanta-kaiyaaro iñiimi pishininka-payi iriipirori pinatzii. Iro iyotantyaari ari notsipatami naaka nokimitaakiri pairani Moisés notsipatakari. ");
INSERT INTO prq_vpl VALUES ("JS3_8","007_3_8","JOS","3","8","8","¡Josué! Pinkantiri awiroka Ompira-tasorintsitaari-payi anatakirori tasorintsi-moko, pinkantiri: ‘Aririka paatzikaa-paakiro nijaa Owaryiinkaarini, ari paatzin-kajiita-paaki.’ ” ");
INSERT INTO prq_vpl VALUES ("JS3_9","007_3_9","JOS","3","9","9","Imatakiro Josué, ikantakiri ishininka-payi: “¡Noshininkaiti! Pimpoka-jiiti maaroni, pinkimi ikantzi Awawani. ");
INSERT INTO prq_vpl VALUES ("JS3_10","007_3_10","JOS","3","10","10","Iro piyotan-tyaari ari itsipatami awirokaiti Pawa Añaanita-tsiri, aritaki piñaayitajiri yapirotajiri Owintini-satzi, Tharowan-taarini-satzi, Thaantiwini-satzi, Nampitsiwini-satzi, Pitzitharini-satzi, Tonkaarisatzi aajatzi Kayaawinisatzi. ");
INSERT INTO prq_vpl VALUES ("JS3_11","007_3_11","JOS","3","11","11","Ari piñaajiitakiro yashaata-kaitiro Owaryiinkaariniki itasorintsi-mokoti Pinkatha-wintzirori maaroni kipatsi. ");
INSERT INTO prq_vpl VALUES ("JS3_12","007_3_12","JOS","3","12","12","Piyosiiti inkarati 12 ashininka, paayiti aparo-payi akaratzi ashininkata-wakaa-jiita. ");
INSERT INTO prq_vpl VALUES ("JS3_13","007_3_13","JOS","3","13","13","Tima aririka yashitanaki iitziki-payi Ompira-tasorintsitaari anatakirori itasorintsi-mokoti Pinkathari-wintzirori maaroni kipatsi, ari ompiryaatanaki Owaryiinkaarini. Airo osiyaatanaja nijaa, antaro oonkanakyaa katonko.” ");
INSERT INTO prq_vpl VALUES ("JS3_14","007_3_14","JOS","3","14","14","Ikanta isitowa-jiitanaki Israel-iiti iwanko-thaanti-yitaka yashaatiro Owaryiinkaarini, jiwajiitaki Ompira-tasorintsitaari yanatakiro tasorintsi-moko. ");
INSERT INTO prq_vpl VALUES ("JS3_15","007_3_15","JOS","3","15","15","Ikanta yaatzikaa-paakiro nijaa Ompira-tasorintsitaari anatakirori tasorintsi-moko, ashiyitanaki iitziki-payi. Tima okimaatatzii Owaryiinkaarini ikoyaan-tapiintai-tarori okithoki pankirintsi. ");
INSERT INTO prq_vpl VALUES ("JS3_16","007_3_16","JOS","3","16","16","Iro oonkanta-nakari, antaro okantanaka nijaa irojatzi katonko ariitaka Potsitaariki osaika-nampitziri Kimaantsi-jaari. Irooma kirinka Mamiriwiniki omontitari Inkaari Mirityaaro, piryaatanaki. Ari ikinajiitanaki Israel-iiti ijajiiti intatzikiro Kasiryaariki. ");
INSERT INTO prq_vpl VALUES ("JS3_17","007_3_17","JOS","3","17","17","Iriima Ompira-tasorintsitaari anatakirori itasorintsi-mokoti Pawa, irojatzi ikatziya-jiitaka tsika opiryaatanaki Owaryiinkaarini. Irojatzi ithonkan-takari imontyaa-jiita maaroni Israel-iiti opiryaatanaki Owaryiinkaarini. ");
INSERT INTO prq_vpl VALUES ("JS6_1","007_6_1","JOS","6","1","1","Tikatsi mataironi inkyaaji Kasiryaariki, tikatsi aajatzi matajironi isitowaji, tima yasitai-tanakiro sintsiini nampitsi, onkini impiyawintyaa aririka iwayirita-paakyaari Israel-iiti. ");
INSERT INTO prq_vpl VALUES ("JS6_2","007_6_2","JOS","6","2","2","Iro kantacha iñaanatajiri Pawa yoka Josué, ikantajiri: “¡Josué! Nosinita-kimiri papirotiri Kasiryaari-satzi, iwinkathariti aajatzi iwayiriti-payi. ");
INSERT INTO prq_vpl VALUES ("JS6_3","007_6_3","JOS","6","3","3","Pishonkiro nampitsi pintsipata-kyaari pishininka-payi owayirita-chani, aparo-satzi pishonkiro kitaitiriki. Tima onkarati 6 kitaitiri pishonkyaaro. ");
INSERT INTO prq_vpl VALUES ("JS6_4","007_6_4","JOS","6","4","4","Ijiwati 7 Ompira-tasorintsitaari yairika-yitaki ichii ipiraitari intyootan-tyaari. Iyaatzimaityaari ompira-tasorintsitaari-payi anatakirori tasorintsi-moko. Aririka omonkaratakyaa 7-tatsiri kitaitiri, 7 papiitiro pishonkiro nampitsi. Intyoojiitanaki Ompira-tasorintsitaari irirori. ");
INSERT INTO prq_vpl VALUES ("JS6_5","007_6_5","JOS","6","5","5","Aririka pinkima-wakiro opoimainka-tanaki tyoorintsi, pinkaima-jiiti sintsiini. Aritaki omporokanaki otantotari Kasiryaari. Ari pinkyaa-jiitanaki anta.” ");
INSERT INTO prq_vpl VALUES ("JS6_6","007_6_6","JOS","6","6","6","Ikaimakiri Josué Ompira-tasorintsitaari, ikantakiri: “Paanakiro itasorintsi-mokoti Pawa. Ijiwati 7 Ompira-tasorintsitaari yairika-yitaki ichii ipiraitari intyootan-tyaari. Iyaatzimaityaari Ompira-tasorintsitaari anatakirori tasorintsi-moko.” ");
INSERT INTO prq_vpl VALUES ("JS6_7","007_6_7","JOS","6","7","7","Iyomitaakiri ishininka-payi, ikantziri: “Pijajiiti, paniitiro Kasiryaari, pishonkiro. Iriima inkarati owayirita-chani iriitaki jiwatironi itasorintsi-mokoti Pawa.” ");
INSERT INTO prq_vpl VALUES ("JS6_8","007_6_8","JOS","6","8","8","Yantakiro Israel-iiti okaratzi ikantakiriri Josué. Jiwatanaki 7 Ompira-tasorintsitaari, ityoojiitzi. Pokakotatsi itasorintsi-mokoti Pawa itaapiiki. ");
INSERT INTO prq_vpl VALUES ("JS6_9","007_6_9","JOS","6","9","9","Jiwataki inkarati owayirita-chani, pokajiitatsi itaapiiki Ompira-tasorintsitaari ityoojiitaki. Tzimatsi pasini owayiri-payi ampoita-tsiri iyaatako-wintziro itasorintsi-mokoti Pawa. Ti omairitapainti tyoorintsi. ");
INSERT INTO prq_vpl VALUES ("JS6_10","007_6_10","JOS","6","10","10","Tima iyomitaa-yitakiri Josué ishininka-payi, ikantakiri: “Santzikoi-tiini paniijiiti, irojatzi nonkantan-takyaamiri: ‘¡Pinkaima-jiiti sintsiini!’ Aripaiti pinkaima-jiiti” ");
INSERT INTO prq_vpl VALUES ("JS6_11","007_6_11","JOS","6","11","11","Imatakiro ishonka-jiitakiro nampitsi yanatako-jiitakiro itasorintsi-mokoti Pawa. Ari ipiyajiitaja iwanko-thaantiki, irojatzi pasini kitaitiri. ");
INSERT INTO prq_vpl VALUES ("JS6_12","007_6_12","JOS","6","12","12","Ikanta ipiriinta-manaja Josué, yaanajiro Ompira-tasorintsitaari-payi itasorintsi-mokoti Pawa. ");
INSERT INTO prq_vpl VALUES ("JS6_13","007_6_13","JOS","6","13","13","Jiwatanaji 7 Ompira-tasorintsitaari yairika-yitakiri ityoori-payi, pokakotatsi itasorintsi-mokoti Pawa itaapiiki. Ti imakoryaa-painti yaniijiitzi, yaakowintakaro ityoojiitzi. Jiwatatsi inkarati owayirita-chani. Tzimatsi pasini owayiri-payi ampoita-tsiri iyaatako-wintziro itasorintsi-mokoti Pawa. Tima kapiniinka okantaka ityoojiitzi. ");
INSERT INTO prq_vpl VALUES ("JS6_14","007_6_14","JOS","6","14","14","Ari yapiitakiro ishonkaro nampitsi Kasiryaari, irootaki apitita-tsiri kitaitiri. Ari ipiyajiitaja iwanko-thaantiki. Irootaki yantapiintakiri okaratzi 6 kitaitiri yapiitakiro ishonkakaro. ");
INSERT INTO prq_vpl VALUES ("JS6_15","007_6_15","JOS","6","15","15","Okanta 7-tatsiri kitaitiri, ananinka-jiitanaka ishonkaro nampitsi, ikimita-piintakiro. Iroka kitaitiri, 7 yapiitakiro ishonkaro nampitsi. ");
INSERT INTO prq_vpl VALUES ("JS6_16","007_6_16","JOS","6","16","16","Okanta 7-tatsiri ityootaki Ompira-tasorintsitaari-payi, ikaimakota-nakiri Josué ishininka-payi, ikantziri: “¡Pinkaima-jiiti sintsiini! ¡Tima isinita-kimiri Pawa ikaratzi nampitarori aka!” ");
INSERT INTO prq_vpl VALUES ("JS6_20","007_6_20","JOS","6","20","20","Ari ikaimajiitanaki sintsiini ishininka-payi, poimatanaki ityootani Ompira-tasorintsitaari-payi. Ikanta ikimawakiri maaroni ishininka-payi opoimatanaki tyoorintsi, isintsipirotanakitzii ikaimanaki, irootaki oporokan-tanakari otantotari nampitsi Kasiryaari. Tampatzika iwanakiro ikyaajiitanaki nampitsiki. ");
INSERT INTO prq_vpl VALUES ("JS6_21","007_6_21","JOS","6","21","21","Yapirotakiri iwisakiri maaroni sirampari, kooya, mainari, antari-kona-payi, imatanakiri ipira-payi, maaroni. Ari ikaratzi ithonkakiri. ");
INSERT INTO prq_vpl VALUES ("JS6_22","007_6_22","JOS","6","22","22","Ikaimakiri Josué amina-itzirori chapinki kipatsi, ikantakiri: “Pinkyii owankoki mayimpiro, pimisitowiro iroori aajatzi okaratzi asitari, paanakiro, pimonkaratiniro okaratzi pikanta-kirori chapinki.” ");
INSERT INTO prq_vpl VALUES ("JS6_23","007_6_23","JOS","6","23","23","Ari ikyaajiitanaki apitika atziri, yaapaintziro Rahab, aajatzi iri, oniro, iyaariri-payi, oshininka-thori-payi iroori, yaanakiro tsika osaiki iwanko-thaanti-payi Israel-iiti. ");
INSERT INTO prq_vpl VALUES ("JS6_24","007_6_24","JOS","6","24","24","Ipoñaa itaanakiro owayiri-payi nampitsi Kasiryaari, yapirotakiro itaakiro okaratzi tzimatsiri. Apatziro yaakiri ooro, kiriiki, okaratzi iwitsikai-tziri yaitziri kitiriri kiriiki, asiro, ipiyotakiro tsika osaikayitzi okaratzi yasitakai-tariri Pawa. ");
INSERT INTO prq_vpl VALUES ("JS6_25","007_6_25","JOS","6","25","25","Iro kantacha iwawisaa-kotajiro Josué iroka kooya Rahab, ari ikimitaakiri oshininka-thori-payi. Tima irootaki omanakiriri ityaantani Josué yaminaitiro nampitsi Kasiryaari. Ari onampitaarori Rahab irojatzi iroñaaka otsipayitaari Israel-iiti tsika inampitaro irirori. ");
INSERT INTO prq_vpl VALUES ("JS6_26","007_6_26","JOS","6","26","26","Tima inthonkyaa iporokai-takiro nampitsi Kasiryaari, iroka ikantzi Josué iñaanatziri Israel-iiti: “Imishatani iwiri Pawa nintatsini iwitsikajiro nampitsi Kasiryaari. Tzimatsi-rika nintatsini iwitsikajiro, aritaki inkanta-kaakyaaro Pawa inkami maaroni iwaiyani yoka atziri.” ");
INSERT INTO prq_vpl VALUES ("JS6_27","007_6_27","JOS","6","27","27","Tima maaroni ikimakoi-tanakiri Josué anta, tima iriitaki Pawa tsipata-kariri. ");
INSERT INTO prq_vpl VALUES ("JS8_1","007_8_1","JOS","8","1","1","Ari iñaanatajiri Pawa yoka Josué, ikantajiri: “Ñaapiro pinkantyaa, airo pitharowa-waitzi. Paanajiri pishininka-payi inkarati owayirita-chani, pijati piwayirityaari Porokaarini-satzi, naaka kantakai-yaaroni piitsinampairi iwinkathariti, pinthonkiri papirotiri maaroni. Awiroka asitajyaaroni inampi aajatzi iipatsiti. ");
INSERT INTO prq_vpl VALUES ("JS8_2","007_8_2","JOS","8","2","2","Tima ari pimatakiri Porokaarini-satzi aajatzi iwinkathariti pikimitaakiri Kasiryaari-satzi aajatzi iwinkathariti. Nosinitakimi iroñaaka payiro okaratzi tzimimotziriri, payiri aajatzi ikaratzi ipirayitari. Piwitsikyaa, onkini pimapokiri pinkina-sitakiri itaapiiki.” ");
INSERT INTO prq_vpl VALUES ("JS8_3","007_8_3","JOS","8","3","3","Ari iwitsikanaka Josué aajatzi ikimitakari ishininka-payi jatatsini iwayirityaari Porokaarini-satzi. Iyosiitaki ikaratzi 30,000 ñaapirori ishininka-payi, ityaantakiri tsitini-paiti. ");
INSERT INTO prq_vpl VALUES ("JS8_4","007_8_4","JOS","8","4","4","Ikantawakiri: “Itaapiiki pinkina-sitakiri, pimanajiitakyaa okaakiini. Owitsika pinkanta-yitakyaa piwayiritiri. ");
INSERT INTO prq_vpl VALUES ("JS8_5","007_8_5","JOS","8","5","5","Iriima pasini ashininka owayirita-chani iyaatina naaka nojati nampitsiki. Aririka isitowanaki ininti imanata-wakina, nosiya-pitha-tzimaityaari, akimitajiro chapinki. ");
INSERT INTO prq_vpl VALUES ("JS8_6","007_8_6","JOS","8","6","6","Aririka impatzimata-nakina Porokaarini-satzi, yookanakiro intaina inampi, inkanta-jiiti: “Isiya-pithatatyai yokaiti ikimitajiro chapinki.” Nonkimita-kaanta-tzimaityaaro naaka-payi nosiya-pithata-tyiirimi. ");
INSERT INTO prq_vpl VALUES ("JS8_7","007_8_7","JOS","8","7","7","Irojatzi pisitowan-tanakyaari awiroka-payi tsika pimanajiitaka, pinkyaa-jiita-paaki inampiki. Tima isinita-kairi Pawa awayirityaari yokaiti. ");
INSERT INTO prq_vpl VALUES ("JS8_8","007_8_8","JOS","8","8","8","Aririka pinkyaaki inampiki, pintayiro. Pimatiro ikantakairi Pawa. Irootaki inintziri irirori.” ");
INSERT INTO prq_vpl VALUES ("JS8_9","007_8_9","JOS","8","9","9","Imatakiro Josué ityaantakiri owayirita-chani. Ikinajiitaki ishininka-payi ikyaapiintzi ooryaatsiri, manajiitaka niyaanki-thaki awotsi poñaachari Pawapankoniki irojatzi Porokaa-riniki. Iriima Josué, ti ijati irirori, aajatzi imaanaji iwanko-thaantiki. ");
INSERT INTO prq_vpl VALUES ("JS8_10","007_8_10","JOS","8","10","10","Okanta okitaitita-manaji, yananinkanaka Josué yaminiri ishininka-payi, inkarati owayirityaarini Porokaarini-satzi. Ipiyotakiri maaroni ishininka-payi, aajatzi antari-kona-payi. ");
INSERT INTO prq_vpl VALUES ("JS8_11","007_8_11","JOS","8","11","11","Ari itonkaa-jiitanaki owayirita-chani ikaratzi itsipata-nakari Josué. Tima imontita-paakaro nampitsi Porokaa-rini, ari iwanko-thaanti-yitapaaka okatonkotzi nampitsi. ");
INSERT INTO prq_vpl VALUES ("JS8_12","007_8_12","JOS","8","12","12","Ityaantaki 5,000 ishininka owayirita-chani ikyaapiintzi ooryaatsiri, manayitaka niyaanki-thaki awotsi poñaachari Pawapankoniki irojatzi Porokaa-riniki. ");
INSERT INTO prq_vpl VALUES ("JS8_13","007_8_13","JOS","8","13","13","Iroka ikanta itsiparyaakiri ishininka-payi Josué: Tzimatsi aparo-payi manajiitaka owayirita-chani ikyaapiintzi ooryaatsiri. Iriima pasini-payi iwanko-thaanti-yitaka okatonkotzi nampitsi. Irojatzi ijiwatan-tanakari Josué tsitini-paiti anta otinkanaaki. ");
INSERT INTO prq_vpl VALUES ("JS8_14","007_8_14","JOS","8","14","14","Ikanta iyotaki pinkatharita-tsiri Porokaa-riniki, sintsiini ikaimanakiri iwayiriti-payi, aninka-jiitanaka, ikamanta-wakaa-jiitaka tsika iwayiritantyaa. Ari ikaratzi yaanakiri iwayiriti impiyata-wakyaari Israel-iiti iwiraapaaka intatzikiro Mamiriwiniki. Ti iyojiiti manajiitaka pasini Israel-iiti nampitsiki tsika ikinapaakiro. ");
INSERT INTO prq_vpl VALUES ("JS8_15","007_8_15","JOS","8","15","15","Ikanta Josué itsipatakari iwayiriti, ikimita-kaakaro intharowa-nakityiimi, isiya-pithata-nakari Porokaarini-satzi ikinajiitanaki otzisi-masiki. ");
INSERT INTO prq_vpl VALUES ("JS8_16","007_8_16","JOS","8","16","16","Ari ikaimakotakiri iwayiriti-payi iwinkathariti Porokaarini-satzi, ikantziri: “¡Pimpatzimatiri!” Ikanta ipatzimai-tanakiri Josué, yookanakiro intaina inampi. ");
INSERT INTO prq_vpl VALUES ("JS8_17","007_8_17","JOS","8","17","17","Tikatsi aparoni owayiri saikanain-tsini kisakowintyaarini Porokaarini-satzi aajatzi Pawapankoni-satzi, tima maaroni ijatanaki iwayiriti ipatzimata-nakiri Israel-iiti. ");
INSERT INTO prq_vpl VALUES ("JS8_18","007_8_18","JOS","8","18","18","Ari yapiitakiro Pawa iñaanatziri Josué, ikantziri: “Piwaankiro pipathaka-minto pookotan-tyaaro Porokaa-rini, tima nosinita-kimiri naaka papirotiri.” Iwaanka-nakiro Josué iwisa-minto yairikakiri, yookotan-takaro nampitsi. ");
INSERT INTO prq_vpl VALUES ("JS8_19","007_8_19","JOS","8","19","19","Imapoka-sitanaka isitowa-jiitanaki owayiriiti ikaratzi omanain-chari, jatanaki Porokaa-riniki, kyaapaaki nampitsiki, itaapaakiro. ");
INSERT INTO prq_vpl VALUES ("JS8_20","007_8_20","JOS","8","20","20","Ari ipithoka-painta itaapiiki iwayiriti Porokaarini-satzi, iñaatziiro okachaaryii-nkataki otaa inampi. Tikatsi inkini isiyanaki otzisi-masiki, tima itzikakiri Israel-iiti isiyakaan-tziri inkaaranki imisiya-tziiri. Iriitaki pithoka-sitana-kariri iwayiritari. ");
INSERT INTO prq_vpl VALUES ("JS8_21","007_8_21","JOS","8","21","21","Iñaakiri Josué ikyaaki nampitsiki iwayiriti ikaratzi omanain-chari, imatakiro itaakiro nampitsi, ipiyasi-jiita-paakari Porokaarini-satzi, iwayirita-paakari. ");
INSERT INTO prq_vpl VALUES ("JS8_22","007_8_22","JOS","8","22","22","Ari isitowa-jiitanaki owayiri-payi kyaapain-tsiri nampitsiki, isatikai-tanakiri Porokaarini-satzi, tikatsi inkinaji isiyi, iwamaitakiri maaroni. ");
INSERT INTO prq_vpl VALUES ("JS8_23","007_8_23","JOS","8","23","23","Apatziro iwinkathariti Porokaarini-satzi yañaaki, ti iwamairi. Yairikai-takiri, yaanakiri isaikaki Josué. ");
INSERT INTO prq_vpl VALUES ("JS8_24","007_8_24","JOS","8","24","24","Yapiroi-takiri Porokaari-satzi ikaratzi jatanain-tsiri otzisi-masiki ipatzimatan-tawita. Ari ipiyapaaka maaroni Israel-iiti nampitsiki Porokaa-rini, yapirotakiri iwisakiri ikaratzi añaawita-nainchari. ");
INSERT INTO prq_vpl VALUES ("JS8_25","007_8_25","JOS","8","25","25","Tima apirotakaa ikamaki Porokaarini-satzi. Ikamayitaki sirampari aajatzi kooya. Ikarajiitzi 12,000 kamaintsiri. ");
INSERT INTO prq_vpl VALUES ("JS8_26","007_8_26","JOS","8","26","26","Ti inkaratiro Josué iwaankiro iwisa-minto yookotantaro nampitsi, irojatzi yapirotan-takariri ikaratzi nampitarori Porokaa-riniki. ");
INSERT INTO prq_vpl VALUES ("JS8_27","007_8_27","JOS","8","27","27","Tima yayitakiri Israel-iiti maaroni yasitari Porokaarinini-satzi aajatzi ipira-payi. Imatakiro Josué ikantakiriri Pawa. ");
INSERT INTO prq_vpl VALUES ("JS8_28","007_8_28","JOS","8","28","28","Itaakiro Josué nampitsi Porokaa-rini. Asi owiro iñiitziro iroñaaka opiyo-porokita tsika okanta iporokai-takiro pairani. ");
INSERT INTO prq_vpl VALUES ("JS8_29","007_8_29","JOS","8","29","29","Yaakiri Josué iwinkathariti Porokaarini-satzi, ithatakiri otiwaki inchato, irojatzi tsitinii-tiini. Ikanta ikyaanaji ooryaatsiri, ikantaki Josué: “Posiryaa-kotiri kaminkari, pookaitiri okyaapiintaki awotsi, panawyaan-tyaari oshiki mapi.” Asi owatyiiro iñiitziro iroñaaka mapi okaratzi yanawyaan-taita-kariri. ");
INSERT INTO prq_vpl VALUES ("JS9_1","007_9_1","JOS","9","1","1","Ari kimajiitaki okaratzi awisain-tsiri iwinkathariti-payi Tharowan-taarini-satzi, Tonkaarisatzi, Owintini-satzi, Nampitsi-wini-satzi, Thaantiwinisatzi aajatzi Kayaawinisatzi. Tima yokapayi pinkathari iriitaki saika-nampi-yitzirori Owaryiinkaariniki, othapyaaki Antaroiti Inkaari aajatzi Kitiniitoniki. ");
INSERT INTO prq_vpl VALUES ("JS9_2","007_9_2","JOS","9","2","2","Ari iyomitaa-wakaa-jiitaka yokaiti pinkathari, ikanta-wakaa: “Thami aapatyaa-wakaityaa, inkini ampiyata-wakyaari Josué jiwatziriri Israel-iiti.” ");
INSERT INTO prq_vpl VALUES ("JS9_3","007_9_3","JOS","9","3","3","Iriima Thaantiwinisatzi nampitarori Nampitsii-toniki, ikimakotakiri Josué tsika ikantakiri Kasiryaari-satzi aajatzi Porokaarini-satzi. ");
INSERT INTO prq_vpl VALUES ("JS9_4","007_9_4","JOS","9","4","4","Ikinkithasiri-jiitanaka yamatawitiri. Yaaki antyasiparo-payi itiminto aajatzi paisatori misinantsi, wawi-poroki ikantayitaka, ikithaa-yitanakaro, ikyaa-kota-nakari ipira-payi jaitijiitanaki. ");
INSERT INTO prq_vpl VALUES ("JS9_5","007_9_5","JOS","9","5","5","Tima wawi-poroki ikantajiitaka, ikyaanta-yitakari iitziki paisato-porokiri. Yaanaki kiso-porokiri iwariti, othonka opowaki. ");
INSERT INTO prq_vpl VALUES ("JS9_6","007_9_6","JOS","9","6","6","Ariijiitaka Pinaironchaariniki tsika iwanko-thaantitaka Josué aajatzi ishininka-payi, ikantapaakiri: “Awiroka nopokasitzi, tima intaina nopoñaa-yitaka. Nonintzi paapatyii-yaana.” ");
INSERT INTO prq_vpl VALUES ("JS9_7","007_9_7","JOS","9","7","7","Ari yakajiitanaki Israel-iiti ikantziri Thaantiwinisatzi pokaintsiri: “Kimitaka ti intaina pimpoñiiyaaro, okaakiini pisaiki. ¿Tsika inkini aapatyaa-wakaityaa?” ");
INSERT INTO prq_vpl VALUES ("JS9_8","007_9_8","JOS","9","8","8","Aikiro isintsita-nakitzii, ikantziri: “Nonintzi pimpiratyaana.” Ikantziri Josué: “¿Tsikama pipoñaaka? ¿Tsika pipaitaka? ¿Tsika osaiki pinampi?” ");
INSERT INTO prq_vpl VALUES ("JS9_9","007_9_9","JOS","9","9","9","Ikantajiitzi iriroriiti: “Intaina nopoñaaro, nokimakotakiri Piwawani. Ithonka nokimakiro aajatzi okaratzi yantakiri Piwawani Apitantoniki. ");
INSERT INTO prq_vpl VALUES ("JS9_11","007_9_11","JOS","9","11","11","Irootaki ityaantan-takanari nojiwari-payi, aajatzi noshininka-payi, ikantakina: ‘Pijati tsika isaikajiitzi Israel-iiti. Paanaki piyaari awotsiki. Aririka piñaakiri, pinkantiri: “Naaka pompiratani. Nonintzi aapatyaa-wakaityaa.” ");
INSERT INTO prq_vpl VALUES ("JS9_12","007_9_12","JOS","9","12","12","Tima owakira nopokajiitanaki namina-minatzimi, ainiro osaawawita nowariti. Irooma iroñaaka kiso-poroki okantaka, ithonka opowaki. ");
INSERT INTO prq_vpl VALUES ("JS9_13","007_9_13","JOS","9","13","13","Ari ikimiwitaka aajatzi misinantsi-naki owakirari inawita. Tima sanaryaaki iroñaaka. Ari okimitzi-takari aajatzi noithaari, noyaantakari noitziki, thonkaka tima intaina nopoñaa-yitaka.’ ” ");
INSERT INTO prq_vpl VALUES ("JS9_14","007_9_14","JOS","9","14","14","Yaakiro Israel-iiti iwariti Nampitsiitoni-satzi yamakiri inampiki, iwaka kapichiini. Titzimaita inkowakotiri Pawa opaita-rika yantiri. ");
INSERT INTO prq_vpl VALUES ("JS9_15","007_9_15","JOS","9","15","15","Imatakiro Josué isankinata-kotakiro okantakota yaapatyaa-wakaan-tyaari airo iwayirita-wakaanta. Ikantakiri: “Airo nowamaimi.” Irojatzi imatzitakari ijiwari-payi Israel-iiti ikantaki irirori-payi. ");
INSERT INTO prq_vpl VALUES ("JS9_16","007_9_16","JOS","9","16","16","Ikanta awisaki mawa kitaitiri, ikamantai-takiri Israel-iiti, ikantai-tziri: “Ti intaina isaikajiitzi Nampitsii-toni-satzi, iriitaki pitsipa-nampitari”. ");
INSERT INTO prq_vpl VALUES ("JS9_17","007_9_17","JOS","9","17","17","Jaitijiitaki Israel-iiti yamina-minatziri Nampitsiitoni-satzi. Ikanta awisaki mawa kitaitiri, yariitakari inampiki. Iroka ipaitziro inampi-payi: Nampitsii-toni, Manityaarini, Kaaronchaarini, Antami-jaari. ");
INSERT INTO prq_vpl VALUES ("JS9_18","007_9_18","JOS","9","18","18","Titzimaita iwayirita-paakyaari, tima yaapatyaa-wakari chapinki, inkantakiri: “Airo nowayiritami. Aririka nonthaiyakyaa nokantzimiri, iwasankitaina Pawa, Iwawani Israel.” Irootaki ikisima-waitan-tanakariri Israel-iiti yokapayi ijiwariti-payi. ");
INSERT INTO prq_vpl VALUES ("JS9_19","007_9_19","JOS","9","19","19","Iro kantacha, iroka ikantajiitzi ijiwariti yakayitziri Israel-iiti: “Airo nowayiritari. Tima aritaki nokantzi-takari chapinki: ‘Airo nowayiritami. Aririka nonthaiyakyaa nokantzimiri, iwasankitaina Pawa, Iwawani Israel.’ ” ");
INSERT INTO prq_vpl VALUES ("JS9_20","007_9_20","JOS","9","20","20","Aikiro ikantana-kitzii ijiwariti-payi Israel-iiti: “Airo amaimanitziri, isaikawaiti. Tima airorika amonkaratziniri akantakiriri Pawa, aritaki inkisakai. ");
INSERT INTO prq_vpl VALUES ("JS9_21","007_9_21","JOS","9","21","21","Airo piwamaa-kaanta-waitzi aparoni, apatziro pimpira-waityaari iwapiinti tsitsi, yayi aajatzi nijaa.” Ari ikinakayirori jiwari-payi imonkaratziro ikantakiriri Nampitsii-toni-satzi, yaapatyii-yaari. ");
INSERT INTO prq_vpl VALUES ("JS9_22","007_9_22","JOS","9","22","22","Ari ikaimakaan-takiri Josué Nampitsii-toni-satzi, isampitakiri ikantziri: “¿Paitama pamatawitan-tanari pikantaki: ‘Intaina osaiki nonampi.’? Tima okaakiini pisaika-jiiwita. ");
INSERT INTO prq_vpl VALUES ("JS9_23","007_9_23","JOS","9","23","23","¡Mishataari piinayitaji! Pasi piwairo nompira-waijiityaami. Ontzimatyii pintsimata-piintaji, paapiintaji nijaa asi iwanko Nowawani.” ");
INSERT INTO prq_vpl VALUES ("JS9_24","007_9_24","JOS","9","24","24","Yakanaki irirori ikantanaki: “Tima antaaro notharowan-takami piwamaana = kari, irootaki namatawitan-tamiri. Tima nokimakotakiri Piwawani okaratzi ikantakiriri pairani Moisés, ikantziri: ‘Ari napirotajiri ikaratzi nampitarori aka, nompajimiro awirokaiti maaroni iroka iipatsiti.’ ");
INSERT INTO prq_vpl VALUES ("JS9_25","007_9_25","JOS","9","25","25","Iro kantacha, pimatiro pimpira-waityaana awiroka-payi. Pantakayinaro okaratzi kamiithatzi-motimini.” ");
INSERT INTO prq_vpl VALUES ("JS9_26","007_9_26","JOS","9","26","26","Imatakiro Josué, ti isinitiri Israel-iiti iwayiritai-tyaari Nampitsiitoni-satzi. ");
INSERT INTO prq_vpl VALUES ("JS9_27","007_9_27","JOS","9","27","27","Iriijiitaki iwaki tsimata-piinta-tsini, irijatzi aapiinta-tsini nijaa irasi maaroni Israel-iiti, asi ipomitairontsiti Pawa tsika-rika anta yookotiniri Pawa. Irootaki yanta-wairi yamitanakari yantiro irojatzi iroñaaka. ");
INSERT INTO prq_vpl VALUES ("JS10_1","007_10_1","JOS","10","1","1","Ikanta Adonisedec pinkatharita-tsiri Aapatyaawiniki, ikimakotakiri Josué yaapithatakiri iipatsiti Porokaarini-satzi. Yapirotakiri maaroni, itsipataakiri iwinkathariti, ikimitaakiri pairani Kasiryaari-satzi, yapirotakiri itsipataakiri iwinkathariti. Tima ikimakotzi-takari yaapatyaakari Nampitsiitoni-satzi, itsipatakari iipatsitiki isaikan-tyaari kamiitha. ");
INSERT INTO prq_vpl VALUES ("JS10_2","007_10_2","JOS","10","2","2","Antaro itharowanaki. Tima ñaapirori ikantajiita. Antaro okanta iipatsiti, anairo irasi Porokaarini-satzi. Tima otzinkami nampitsi onatzi iroka Nampitsii-toni. ");
INSERT INTO prq_vpl VALUES ("JS10_3","007_10_3","JOS","10","3","3","Irootaki ityaantan-takari Adonisedec jatatsini iñiiri Hohan pinkatharita-tsiri Aripirotaa-riniki, iñiiri Piream pinkatharita-tsiri Watha-winiki, iñiiri Jafía pinkatharita-tsiri Kisosiryaa-riniki, iñiiri Debir pinkatharita-tsiri Waakaanikiki, ikantakiri: ");
INSERT INTO prq_vpl VALUES ("JS10_4","007_10_4","JOS","10","4","4","“Pimpoki pamitakotina awayirityaari Nampitsiitoni-satzi, tima yaapatyaakari Josué ijiwariti Israel-iiti, itsipata-wakari.” ");
INSERT INTO prq_vpl VALUES ("JS10_5","007_10_5","JOS","10","5","5","Ikanta yoka 5 pinkathari saikatsiri iipatsitiki Tonkaarisatzi. Pinkatharita-tsiri Aapatyaawiniki, Aripirotaa-riniki, Watha-winiki, Kisosiryaa-riniki, aajatzi Waakaanikiki, yaapatyaa-wakaanaka irirori, yaayita-nakiri iwayiriti. Jataki intzi-masitiri Nampitsiitoni-satzi iwayiri-tyaari. ");
INSERT INTO prq_vpl VALUES ("JS10_6","007_10_6","JOS","10","6","6","Ari ikimitakari aajatzi Nampitsiitoni-satzi, ityaantaki jatatsini isaikaki Josué iwanko-thaantiki Pinaironchaariniki, ikantapaakiri: “Pimpoki sintsiini, pinkisa-kowintyaari pimpiratani. Tima yaapatyaa-wakaa-kityaa pinkathari-payi saikatsiri tonkaariki iipatsitiki Tonkaarisatzi, inintzi iwayirityaana.” ");
INSERT INTO prq_vpl VALUES ("JS10_7","007_10_7","JOS","10","7","7","Ikanta ikimawaki Josué, pokanaki irirori itsipayitakari ñaapirori iwayiriti ipoñaakaro Pinaironchaariniki. ");
INSERT INTO prq_vpl VALUES ("JS10_8","007_10_8","JOS","10","8","8","Ari iñaanata-jiriri Pawa, ikantairi: “¡Josué! Airo pitharowan-tawaitari, nosinita-kimiri papirotiri. Tima tikatsi matimini yiitsinampaimi awiroka.” ");
INSERT INTO prq_vpl VALUES ("JS10_9","007_10_9","JOS","10","9","9","Ikanta ipokanaki Josué tsitini-paiti ipoñaakaro Pinaironchaariniki, imapokakiri iwayiritakari. ");
INSERT INTO prq_vpl VALUES ("JS10_10","007_10_10","JOS","10","10","10","Tima ikantakaakaro Pawa intharowan-taityaari Israel-iiti, iñiitakiri yapirotantaki iwamaantaki Nampitsii-toniki. Ipatzimata-nakiri ikinawitanaka awotsiki jatachari tonkaariki Moropankoniki, ari iwamaawaji oshiki, irojatzi yariitantaka Kiyaronchaariniki aajatzi Pirataironiki. ");
INSERT INTO prq_vpl VALUES ("JS10_11","007_10_11","JOS","10","11","11","Ikanta yoirinka-jiitaaro Moropankoniki isiya-pitha-witari Israel-iiti, iwaryaaki Pawa antaro jiriniki osiyakaro mapi, irojatzi anta Kiyaronchaariniki, apirotakiri owamaakiri anaanakiri ikaratzi iwamaayitakiri Israel-iiti. ");
INSERT INTO prq_vpl VALUES ("JS10_12","007_10_12","JOS","10","12","12","Ari ikowakota-kiriri Josué yoka Pawa yapirotiriri iwayiritiri Tonkaarisatzi. Tima ikimakiri maaroni ishininka-payi, ikantaki: “¡Ooryaatsiri! Paatzinki aka Nampitsii-toniki. ¡Kasirí! Paatzinki anta otaapiki Maniro-jaariki.” ");
INSERT INTO prq_vpl VALUES ("JS10_13","007_10_13","JOS","10","13","13","Ari imatzimaitaka yaatzinka-paaki ooryaatsiri aajatzi kasiri. Irojatzi ikaranta-karori Israel-iiti ipiyawinta iwayiritari iisaniintani. Irootaki osankinatain-chari pairani isankinariki Jaser, kantatsiri: “Osamani yaatzinkaka ooryaatsiri inkitiki, iroowitaincha omonkarata-jyaami aparoni kitaitiri.” ");
INSERT INTO prq_vpl VALUES ("JS10_14","007_10_14","JOS","10","14","14","Tira iñiiti pairani siyaaroni iñaakan-takiri Pawa yantakiro inintziri aparoni atziri, tima inkisako-winta-tyiiyaari Israel-iiti. ");
INSERT INTO prq_vpl VALUES ("JS10_15","007_10_15","JOS","10","15","15","Ari ipiyaari Josué itsipataari ishininka-payi iwanko-thaantiki anta Pinaironchaariniki. ");
INSERT INTO prq_vpl VALUES ("JS24_29","007_24_29","JOS","24","29","29","Okanta apaata, kamaki Josué itomi Nun, impiratani Pawa. Okaratzi 110 isarintsiti ikamantakari. ");
INSERT INTO prq_vpl VALUES ("JS24_30","007_24_30","JOS","24","30","30","Ikitaitakiri inampiki, ipaitai-tziri “Oshiki-piro Antitaantsi” saikatsiri otzisi-masiki iipatsitiki Efraín-payi, tsika okatonkotzi otzisi Onikariitoniki. ");
INSERT INTO prq_vpl VALUES ("JS24_31","007_24_31","JOS","24","31","31","Tima yoka Israel-iiti oshiki ipinkathata-piintakiri Pawa ainiro yañaawita Josué. Ari ikantzi-takarori aajatzi ikamajira Josué, tima ainiro yañaayitzi antari-kona-payi yotakotzirori okaratzi yantzimota-kiriri pairani Pawa. ");
INSERT INTO prq_vpl VALUES ("JS24_32","007_24_32","JOS","24","32","32","Ikanta yamajiro Israel-iiti itonki-porokini José anta Apitantoniki, ikitata-pajiri Sikochaariniki. Irootaki iipatsiti Jacob, iwaisatzitini, yamanantakiri pairani yasiwitaro icharini-payi Hamor, ipinatakiri ikaratzi 100 ikithoki kiriiki. Tima yoka Hamor iriri inatzii owaita-kaantai-tziri Siko-kintsi, ikantziri iñaaniki iriroriiti Siquem. Okanta apaata, iriitaki icharini-payi José asitaarori maaroni iroka kipatsi.");
INSERT INTO prq_vpl VALUES ("JG1_1","008_1_1","JDG","1","1","1","Aritaki kamaki Josué, inintaki Israel-iiti iyoti itzimi-rika ityaaroni iwayirityaa, ikowako-takiri Pawa, ikantziri: “¿Itzimika ityaaroni itonkairo iwayiri-tyaari Owintini-satzi?” ");
INSERT INTO prq_vpl VALUES ("JG1_2","008_1_2","JDG","1","2","2","Ari yakakiri Pawa ikantziri: “Iriitaki ityaaroni iwayiri-tyaari icharini-payi Judá, naaka kantakai-yaarini yaapitha-tantyaariri iipatsiti, iriitaki asitajyaaroni.” ");
INSERT INTO prq_vpl VALUES ("JG1_3","008_1_3","JDG","1","3","3","Ikanta icharini-payi Judá ikaimakiri maaroni icharini-payi Simeón, tima ishininka-thori inajiitzi, ikantakiri: “Thami antsipata-wakaiyaa antonkairo kipatsi ipaitakinari. Thami awayiri-tyaari Owintini-satzi. Ari nonkimi-tajirori naakaiti, aritaki noyaatakimi pipatsitiki ipaitakimiri awiroka.” Imatakiro icharini-payi Simeón, iyaataa-jiita-nakiri ishininka-thori-payi. ");
INSERT INTO prq_vpl VALUES ("JG1_4","008_1_4","JDG","1","4","4","Tonkajii-tanaki Judá-iti. Ikantakaakaro Pawa yapirotiri maaroni Owintini-satzi, aajatzi maaroni Nampitsi-wini-satzi. Tima oshiki-piro ikaratzi atziri iwamaakiri anta Poriryaarii-toniki. ");
INSERT INTO prq_vpl VALUES ("JG1_8","008_1_8","JDG","1","8","8","Ikanta iwayiri-takari Judá-iti yokaiti Aapatyaawini-satzi. Ikyaaki inampiki, yapirotakiri iwisakiri maaroni, itaanakiro inampitsiti. ");
INSERT INTO prq_vpl VALUES ("JG1_9","008_1_9","JDG","1","9","9","Ikanta yawisanaki Judá-iti iwayiri-tanakari Owintini-satzi nampiwi-tarori otzisi-masiki, Piryaariniki, aajatzi otaapiki owintini-pathatzi. ");
INSERT INTO prq_vpl VALUES ("JG1_10","008_1_10","JDG","1","10","10","Ikanta yawisanaki Judá-iti iwayiri-tanakari Owintini-satzi nampiwi-tarori Aripiro-taariniki, ipaitawi-taitari pairani “4 Asitarori Inampitsiti”, iwa-nakiri Sesai, Ahimán aajatzi Talmai, jiwari-payi inayitzi irirori. ");
INSERT INTO prq_vpl VALUES ("JG1_22","008_1_22","JDG","1","22","22","Ari ikantakari aajatzi icharini-payi José, iwayiri-takari Pawapankoni-satzi. Tima itsipatani iwiri Pawa yokaiti. ");
INSERT INTO prq_vpl VALUES ("JG1_23","008_1_23","JDG","1","23","23","Ityaantaki icharini-payi José jatatsini yaminaitiro Pawapankoniki, ipaitai-tziri pairani Tirimpyaari. ");
INSERT INTO prq_vpl VALUES ("JG1_24","008_1_24","JDG","1","24","24","Ikanta ijajiitanaki aminirori nampitsi, imonthaaka poñaanain-chari nampitsiki, ikantawakiri: “¡Ayomparí! Pinisironka-tyaana, nonintzi piyomitainaro tsika ikyaa-piintai-tziro nampitsiki, aritaki nomatakimi awiroka naakamiithatimi.” ");
INSERT INTO prq_vpl VALUES ("JG1_25","008_1_25","JDG","1","25","25","Imatakiro iñaakai-takiri tsika ikinaitzi ikyaantaitari nampitsiki, ithonka yapirotakiri iwisakiri nampitarori anta. Iriima atziri yomitaa-kiriri ikyaantakari nampitsiki, isinitakiri isiyi aajatzi ikaratzi ishininka-yitari irirori. ");
INSERT INTO prq_vpl VALUES ("JG1_27","008_1_27","JDG","1","27","27","Iriima Israel-iiti icharini-payi Manasés ti imatiri imisitowiri nampitarori Maranki-pankoniki, Impanikyaariki, Chariñaariki, Niyaitoniki aajatzi Owayirii-toniki. Irojatzi ikanta inampijiitaro Owintini-satzi anta. ");
INSERT INTO prq_vpl VALUES ("JG1_28","008_1_28","JDG","1","28","28","Ikanta ishikitanaki apaata Israel-iiti tzimanaki isintsinka, isintsiwintajiri yantawai-takairi Owintini-satzi, titzimaita imisitowiri inampiki. ");
INSERT INTO prq_vpl VALUES ("JG1_29","008_1_29","JDG","1","29","29","Ari ikimitakari aajatzi Israel-iiti icharini-payi Efraín ti imatiri imisitowiri Owintini-satzi nampitarori Pithatoniki. Iro inintaki intsipa-tyaari inampityaaro inampiki. ");
INSERT INTO prq_vpl VALUES ("JG1_30","008_1_30","JDG","1","30","30","Ari ikimitakari aajatzi Israel-iiti icharini-payi Zabulón ti imatiri imisitowiri Owintini-satzi nampitarori Sankaariniki, aajatzi ikaratzi nampitarori Katarosi-taariniki, irojatzi inampiyi-takaro Owintini-satzi inampiki itsipatakari icharini-payi Zabulón. Isintsiwintziri yantawai-takairi. ");
INSERT INTO prq_vpl VALUES ("JG1_31","008_1_31","JDG","1","31","31","Aajatzi ikimitaka Israel-iiti icharini-payi Aser ti imisitowiri nampitarori Tampatzikaariniki, Simaaki, Waiya-jaariki, Amatawyaariniki, Waiyajaaroki, Asitakotaariniki aajatzi Kaankiiriniki. ");
INSERT INTO prq_vpl VALUES ("JG1_32","008_1_32","JDG","1","32","32","Itsipatakari icharini-payi Aser inampitaro Owintini-satzi asitarori inampi anta, ti yoimisitowiri. ");
INSERT INTO prq_vpl VALUES ("JG1_33","008_1_33","JDG","1","33","33","Ari ikimitakari aajatzi Israel-iiti icharini-payi Neftalí ti imatiri imisitowiri nampitarori Ooryaa-pankoniki aajatzi Akapankoniki. Ari itsipatakari Owintini-satzi inampitaro iipatsitiki. Oshiki isintsiwintakiri impira-yitari Ooryaa-pankoni-satzi aajatzi Akapankoni-satzi. ");
INSERT INTO prq_vpl VALUES ("JG1_34","008_1_34","JDG","1","34","34","Iriima Tonkaarisatzi imisiyakiri Israel-iiti icharini-yitari Dan, inampiyi-tyaaro tonkaariki otzisi-masiki, ti isinitajiri yoirinki otaapiki owintini-pathatzi. ");
INSERT INTO prq_vpl VALUES ("JG2_6","008_2_6","JDG","2","6","6","Ikanta iwithata-kaanajari Josué maaroni ishininka-payi, jatayitanaki yaayitiro iipatsiti okaratzi ipayita-kiriri. ");
INSERT INTO prq_vpl VALUES ("JG2_7","008_2_7","JDG","2","7","7","Tima oshiki ipinkathata-piintakiri Israel-iiti yoka Pawa ainiro yañaawita Josué. Ari ikantzi-takarori ikamajira, tima ainiro yañaayitzi antaripiro-payi yotakotzirori tsika ikanta inisironka-takari pairani Pawa. ");
INSERT INTO prq_vpl VALUES ("JG2_10","008_2_10","JDG","2","10","10","Ikanta ikamayitaki ikaratzi tsipayi-takariri pairani Josué. Ari ikantzi-takari ikaratzi owakira tzimayi-witaa-chari, kaari yotako-piro-tirini Pawa tsika ikanta inisironkatari pairani ishininka-payi. ");
INSERT INTO prq_vpl VALUES ("JG2_11","008_2_11","JDG","2","11","11","Tima kowiinka okantzi-motari Pawa okaratzi yantayi-tanajiri Israel-iiti, ipinkatha-waita-sitakari isiyakaaro pawaniro Inkaniwiri. ");
INSERT INTO prq_vpl VALUES ("JG2_12","008_2_12","JDG","2","12","12","Ti imiraawinta-najiri Pawa, Iwawani pairani iwaisatzitini owawisaa-kotairiri isaikawitaka Apitantoniki. Ipinkatha-waita-sitakari iwawani asitarori inampi itsipataari inampijii-taaro. Irootaki iwatsimaan-takariri Pawa. ");
INSERT INTO prq_vpl VALUES ("JG2_13","008_2_13","JDG","2","13","13","Tima ipinkatha-waitakiri isiyakaaro pawaniro Inkaniwiri, aajatzi osiyakaaro pawaniro Impokiromara. Ti imiraawintajiri Pawa. ");
INSERT INTO prq_vpl VALUES ("JG2_14","008_2_14","JDG","2","14","14","Antaro ikisanaka Pawa, yooka-nakiri Israel-iiti. Ikantakaakaro impoki kosintzi-payi inampiki, ikositakiri okaratzi tzimimo-tziriri. Ipokapaaki owayiri-payi, ti onkanti impiyata-wakyaari. ");
INSERT INTO prq_vpl VALUES ("JG2_15","008_2_15","JDG","2","15","15","Ijatawijiitaka iwayirityaa, ti intsipa-tanajyaari Pawa imatantyaariri iwayirityaari. Irootaki ikantzi-takariri, imonkara-takiro Pawa okaratzi ikantakiriri. Tima oshiki ikimaatsi-waitaka Israel-iiti. ");
INSERT INTO prq_vpl VALUES ("JG2_16","008_2_16","JDG","2","16","16","Irootaki ikantakaan-takarori Pawa intzimi jiwari-payi, iriitaki saikakaa-yitajirini Israel-iiti. Iri ookakaa-witairini aririka inintaitimi yaapithaitiri iipatsiti. ");
INSERT INTO prq_vpl VALUES ("JG2_17","008_2_17","JDG","2","17","17","Titzimaita inkimisantiri ijiwariti-payi, iri ininta-pirotaki impinkatha-waitakiri pawaniro. Ti ishintanaki iwashaantziro tsika ikantayita pairani iwaisatziti ikimisantziro ikantakaantani Pawa. Iwashaanta-nakiro irirori-payi. ");
INSERT INTO prq_vpl VALUES ("JG2_18","008_2_18","JDG","2","18","18","Aririka inkanta-kaiyaaro Pawa intzimi ijiwariti Israel-iiti, tima iriitaki jiwayitziriri. Ainiro yañaayitzi ijiwariti, itsipata-piintari Pawa yoka jiwari, ikisako-wintari iwayiriyita. Tima oshiki inisironka-takari Pawa yokapayi Israel-iiti, ikimiri ikaminthaa-jiita okantakaaro impira-waitaitari, aririka inkimaatsita-kayi-tyaari aajatzi. ");
INSERT INTO prq_vpl VALUES ("JG2_19","008_2_19","JDG","2","19","19","Iro kantacha, aririka inkami-rika ijiwariti-payi Israel-iiti, yapiita-najiro ikaaripiro-waitzi, imapiro-tatziiro ikaaripiro-waitzi, yanaakiri ikaaripirotaki pairani iwaisatziti, ipinkatha-waita-sitari isiyakaaro pawaniro-payi. Ti ininti iwashaantajiro, oshiki ayimawai-tziri yantayitiro. ");
INSERT INTO prq_vpl VALUES ("JG2_20","008_2_20","JDG","2","20","20","Tima antaaro iwatsimaakiri Pawa yoka Israel-iiti, ikantanaki: “Ikantakaan-tziro Israel-iiti ithainka-kiro nokasiya-kayiriri pairani iwaisatziti-payi, ti ininti inkimisantajina, ");
INSERT INTO prq_vpl VALUES ("JG2_21","008_2_21","JDG","2","21","21","irootaki airo nomisitowan-taari asitarori pairani inampipayi, kaari itsinampai yoimisitowiri pairani Josué ainiro yañaawita.” ");
INSERT INTO prq_vpl VALUES ("JG2_22","008_2_22","JDG","2","22","22","Tima inintzi Pawa iñiirimi Israel-iiti impiya-siritaji inkimisantajiri, isiya-kota-jiityaari iwaisatziti ikimisantakiri pairani irirori. ");
INSERT INTO prq_vpl VALUES ("JG2_23","008_2_23","JDG","2","23","23","Irootaki ikantan-takari Pawa intsipa-tyaari Israel-iiti asitarori pairani inampi anta. Ti yoimisitowiri sintziini, tima ti isininitiri yapirotiri Josué. ");
INSERT INTO prq_vpl VALUES ("JG3_7","008_3_7","JDG","3","7","7","Imapirotakiro Israel-iiti ikaaripirotaki ti ookimota-jyaari Pawa, yooka-nakiri. Iwawani-waita-sitakari Inkaniwiri, aajatzi isiyakaaro Inkaari-wiri. ");
INSERT INTO prq_vpl VALUES ("JG3_8","008_3_8","JDG","3","8","8","Antaroiti iwatsimaakiri Pawa yokaiti Israel-iiti, isinita-nakiri imapirotiri impira-waityaari Cusan-risataim pinkatha-ritatsiri Osampanaaki saikatsiri Tonkaironiki. Tima osamani impira-waitakari okaratzi 8 osarintsi isaikawaitaki. ");
INSERT INTO prq_vpl VALUES ("JG3_9","008_3_9","JDG","3","9","9","Ari ikowa-kotairi Pawa yokaiti Israel-iiti intzimaji kisakowinta-jyaarini. Iriitakira itomi Cenaz, paitachari Otoniel, iyaapitsi iririntzi Caleb. ");
INSERT INTO prq_vpl VALUES ("JG3_10","008_3_10","JDG","3","10","10","Inampi-siritan-tanakari Itasorinka Pawa yoka Otoniel, itanakaro ijiwatziri Israel-iiti, jataki iwayirityaa. Isinita-kiniri Pawa iitsinampairi Cusan-risataim pinkatha-ritatsiri Tonkaironiki. ");
INSERT INTO prq_vpl VALUES ("JG3_11","008_3_11","JDG","3","11","11","Osamani isaikawaitaji kamiitha Israel-iiti okaratzi 40 osarintsi, irojatzi ikamantajari Otoniel itomi Cenaz. ");
INSERT INTO prq_vpl VALUES ("JG3_12","008_3_12","JDG","3","12","12","Yapiitajiro Israel-iiti ikaaripirotzi-motairi Pawa, ari ikantakaakaro Pawa ontzimi-motiri isintsinka Eglón pinkatha-ritatsiri Athataa-winiki, iriitaki owayirita-kariri Israel-iiti. Okantakaan-tzirori ikaaripirotzi-motakiri Pawa. ");
INSERT INTO prq_vpl VALUES ("JG3_13","008_3_13","JDG","3","13","13","Ikanta iwinkathariti Athataa-wini-satzi yaapatyaakari iwinkathariti Pityaankaarini-satzi, aajatzi Otinkanaawini-satzi, ipokajiitaki iwayiritari Israel-iiti, yaapithatakiri inampitsiti ipaitai-tziri Kapashaa. ");
INSERT INTO prq_vpl VALUES ("JG3_14","008_3_14","JDG","3","14","14","Tima okaratzi 18 osarintsi impiratai-takari Israel-iiti impiratari iwinkathariti Athataa-wini-satzi. ");
INSERT INTO prq_vpl VALUES ("JG3_15","008_3_15","JDG","3","15","15","Ikanta Israel-iiti ikowa-kotairi Pawa. Ikantakaakaro Pawa intzimaji pasini kisakowinta-jyaarini, iriitaki Aod itomi Gera, ishininka-mirinka Benjamín-iiti, ampatintsi inatzii. Ikanta ityaanta-kiniri Israel-iiti isintsiwintakiri yamaitiniri kiriiki yoka Eglón iwinkathariti Athataa-wini-satzi. ");
INSERT INTO prq_vpl VALUES ("JG3_16","008_3_16","JDG","3","16","16","Iwitsikaki Aod iyotsiro-miniti, apimini ithoyimpitakiro, ti osantha-piroti. Yoosota-kotakaro irakoki imana-kotan-takaro iithaariki. ");
INSERT INTO prq_vpl VALUES ("JG3_17","008_3_17","JDG","3","17","17","Ipoñaa ijataki yaanakiniri sintsiwintan-tziri yaitiniri kiriiki yoka Eglón iwinkathariti Athataa-wini-satzi. Iriipirori wathantzi ikanta atziri Eglón. ");
INSERT INTO prq_vpl VALUES ("JG3_18","008_3_18","JDG","3","18","18","Tima imatakiro ipakiri isintsitan-tziri yaitiniri kiriiki, ari iwithata-waari Aod ikaratzi itsipayitakari. ");
INSERT INTO prq_vpl VALUES ("JG3_19","008_3_19","JDG","3","19","19","Ikanta yariitaka isaikira iwawani-waita-sitari saikatsiri okaakitapaji Pinaironchaarini, ipiyaja Aod isaikinta Eglón, ikantapajiri: “Pinkatharí, tzimatsi ñaantsi nonintziri nonkaman-timiro apaniroini.” Ari yakanaki irirori, ikantzi: “¡Pisitowa-jiiti!” Sitowajiitanaki inampiri-payi irirori. ");
INSERT INTO prq_vpl VALUES ("JG3_20","008_3_20","JDG","3","20","20","Itsitoka-paakari okaakiini Aod isaiki yamasawiryaa-wajiita. Ikantzi Aod: “Namatziimi iñaani Pawa.” Ari ikatziyanaka Eglón. ");
INSERT INTO prq_vpl VALUES ("JG3_21","008_3_21","JDG","3","21","21","Iwaanka-nakiro Aod yampati irako, yaakiro kotsiro-mini imanakiri owiraari iithaari irako-piroki, isatairi imotyaaki, ");
INSERT INTO prq_vpl VALUES ("JG3_22","008_3_22","JDG","3","22","22","iponkitzita-kiniri, othonka okyaa-kotanaki okawi iyotsiro-mini, ti ositowajiro, jataki ishiito-thatoki. ");
INSERT INTO prq_vpl VALUES ("JG3_23","008_3_23","JDG","3","23","23","Ari isitowanaki Aod intakiroki, yasitanakiro kamiithaini, isatika-najiro asitako-rontsi. ");
INSERT INTO prq_vpl VALUES ("JG3_24","008_3_24","JDG","3","24","24","Ikanta isitowanaji, ari ipokajiita-paaki impiratani-payi pinkathari, iñaapaa-tziiro asitaka pankotsi, ikantajiitzi: “Aama isapokatyaa isita.” ");
INSERT INTO prq_vpl VALUES ("JG3_25","008_3_25","JDG","3","25","25","Ikanta iyaawinta ti iyoti opaita yantziri kaari yasitaryaan-taaro, yasitaryaa-kotakiri, iñaatziiri inaryaaka iwinkathariti, kamaki. ");
INSERT INTO prq_vpl VALUES ("JG3_26","008_3_26","JDG","3","26","26","Ikanta yaminajiitakiro opaita ikamantakari, siyanaka Aod. Ikinanaki isaikayitzi isiyakaaro pawaniro-payi, awisakotaji anta ipaitai-tziro Yawotsiti Witzintziwini. ");
INSERT INTO prq_vpl VALUES ("JG3_27","008_3_27","JDG","3","27","27","Ikanta yariitaja iipatsitiki ishininkaiti Efraín-iiti, ityoota-paaki. Oirinka-jiitaja Israel-iiti, iriitaki jiwatajirini maaroni. ");
INSERT INTO prq_vpl VALUES ("JG3_28","008_3_28","JDG","3","28","28","Ikantakiri: “Piyaatina, tima isinitakiri Pawa awayirityaari Athataa-wini-satzi.” Iyaataa-jiita-nakiri, ithonka yaapaakiro imontyiita-piinta Owaryiinkaariniki, ti isiniti aparoni awisatsini anta. ");
INSERT INTO prq_vpl VALUES ("JG3_29","008_3_29","JDG","3","29","29","Tima omapiro ishikitzi Athataa-wini-satzi iwamaitaki aajatzi iriipirori owayiriiti. Tima tikatsi aparoni siyatsini. ");
INSERT INTO prq_vpl VALUES ("JG3_30","008_3_30","JDG","3","30","30","Ari okanta yapiroi-tanta-kariri Athataa-wini-satzi, iriitaki apirotakiri Israel-iiti. Okaratzi 80 osarintsi isaikawaitaji kamiitha tikatsi maimanitirini. ");
INSERT INTO prq_vpl VALUES ("JG3_31","008_3_31","JDG","3","31","31","Ikanta imatantaki Aod, iriira matanajirori Samgar itomi Anat, iwamaaki irirori oshiki Kinawaita-niriiti imintharowan-takari ipira-payi. Irijatzi kisakowintaariri Israel-iiti. ");
INSERT INTO prq_vpl VALUES ("JG4_1","008_4_1","JDG","4","1","1","Aritaki kamaki Aod, ari yapiita-najiro Israel-iiti ikaaripirotzi-mota-najiri Pawa. ");
INSERT INTO prq_vpl VALUES ("JG4_2","008_4_2","JDG","4","2","2","Irootaki isinitan-takariri imaimanitiri Jabín pinkatha-ritatsiri nampitsiki Kaankiityaa-winiki saikatsiri Owintiniki. Tima tzimatsi jiwatziriri iwayiriti Jabín ipaita Sísara, iriitaki nampitarori anta ipaitai-tziro Oshironka-wini Irasi Pasini-satziiti. ");
INSERT INTO prq_vpl VALUES ("JG4_3","008_4_3","JDG","4","3","3","Ikanta yokaiti Israel-iiti ikowa-kotairi Pawa inkisako-winta-jyaari, tima iñaakiro otzimi-motziri pinkathari Jabín oshiki isiyako-minto asirota-tsiri iwayiritan-tyaari. Tima oshiki iwasinonkaa-waitakiri aajatzi Israel-iiti okaratzi 20 osarintsi. ");
INSERT INTO prq_vpl VALUES ("JG4_4","008_4_4","JDG","4","4","4","Ari opinkathari-wintziriri Israel-iiti aparoni kooya opaita Débora, Kamantantzinkaro onatzii, irootaki iina paitachari Lapidot. ");
INSERT INTO prq_vpl VALUES ("JG4_5","008_4_5","JDG","4","5","5","Iro amita-piintari Débora osaiki kompiro-tapisiki, irootaki ipaitai-tziri anta oyompirositi Débora, saikatsiri niyaanki-thaki awotsi jatachari Tonkaironiitoniki irojatzi Pawapankoniki iipatsitiki ishininka-mirinka Efraín-iiti. Ari ijata-sitzirori Israel-iiti amina-kotiniri imaimanita-wakaa-jiita. ");
INSERT INTO prq_vpl VALUES ("JG4_6","008_4_6","JDG","4","6","6","Okanta apaata pinkatharo Débora otyaantaki inkaimaitiri Barac itomi Abinoam, nampitarori Tasorintsiwiniki iipatsitiki ishininkaiti Neftalí-iti, okantziri: “¿Tima pinkimi ikantakaan-takimi Pawa, Iwawani Israel, ikantzimi: ‘Pijati, papatotiri pishininka tonkaariki ipaitai-tziro Piyopathaitoni, piyosiiti oshiki owayiriiti inkarati paanakiri, iriira ishininka-mirinka Neftalí-iti aajatzi ishininka-mirinka Zabulón-iiti. ");
INSERT INTO prq_vpl VALUES ("JG4_7","008_4_7","JDG","4","7","7","Ari nonkaima-siritakiri naaka Sísara nijaatinkaki Tirimpyaaroki, tima iriitaki jiwatziriri iwayiriti Jabín, tzimatsiri isiyako-minto-payi. Tima nosinita-kimiri naaka papirotiri.’ ” ");
INSERT INTO prq_vpl VALUES ("JG4_8","008_4_8","JDG","4","8","8","Ari yakanaki Barac ikantzi: “Aritaki nojataki aririka piyaatakina awiroka. Airorika piyaatana, airora nojatzi.” ");
INSERT INTO prq_vpl VALUES ("JG4_9","008_4_9","JDG","4","9","9","Okantzi Débora: “Aritaki noyaatakimi. Iro kantacha airora itharowintaitami awiroka, tima iro kooya isinitakiri Pawa owamairi Sísara.” Ari okatziyanaka Débora, jataki Tasorintsiwiniki, otsipata-nakari Barac. ");
INSERT INTO prq_vpl VALUES ("JG4_10","008_4_10","JDG","4","10","10","Ari yapatotakiri Barac ishininka-mirinka Zabulón-iiti aajatzi Neftalí-iti, oshiki ikarajiitzi owayiriiti ijiwatziri irirori. Ari otsipatakari Débora yoka Barac otonkaanaki. ");
INSERT INTO prq_vpl VALUES ("JG4_11","008_4_11","JDG","4","11","11","Ari isaikiri anta aparoni atziri paitachari Heber, iriitaki ishininka Asiropakoriiti, icharinita-nakari Hobab, irikonkiri Moisés, ti intsipatyaari ikarawi-jiitari ishininkaiti, iwitsika-jiitzi iwanko-thaanti otaapiki ipaitai-tziro Owayii-winiki, otsipa-nampitari Tasorintsiwini. ");
INSERT INTO prq_vpl VALUES ("JG4_12","008_4_12","JDG","4","12","12","Ari ikamantai-takiri Sísara, ikantai-takiri: “Ipoka-sita-tziimi Barac, itomi Abinoam, jiirinta itonkajiitaki otzisiki Piyopathaitoniki.” ");
INSERT INTO prq_vpl VALUES ("JG4_13","008_4_13","JDG","4","13","13","Ari yapatota-nakiro Sísara isiyako-minto-payi asirota-tsiri, yapatotakiri iwayiriti aajatzi ikaratzi aapatyaariri, nampitarori anta Oshironka-wini Irasi Pasini-satziiti, jaitijiitaki irojatzi nijaatinkaki Tirimpyaaroki. ");
INSERT INTO prq_vpl VALUES ("JG4_14","008_4_14","JDG","4","14","14","Okantanakiri Débora yoka jiwari Barac: “Pijati, irootaki iroka kitaitiri inintakaa-kimiri Pawa piitsinampairi Sísara. Tima iriitaki Pawa jiwatirini piwayiriti-payi.” Ari yoirinkanaka Barac ipoñaakaro otzisiki Piyopathaitoniki, yaanakiri maaroni iwayiriti. ");
INSERT INTO prq_vpl VALUES ("JG4_15","008_4_15","JDG","4","15","15","Ikanta yariitaka Barac itsipatakari owayiriti-payi imanata-paakiri Sísara, antaro ikompita-kaanakari Pawa iwayiriti Sísara, ti iyotanajiro otzimi isiyako-minto. Irootaki yayiitan-tanakari isiyako-mintoki Sísara, siyanaka. ");
INSERT INTO prq_vpl VALUES ("JG4_16","008_4_16","JDG","4","16","16","Iro kantacha Barac iyaariki iwanakiro isiyako-minto-payi aajatzi iwayiriti-payi Sísara, iyaatawajiri anta Oshironka-wini Irasi Pasini-satziiti. Ari yapirotakiri iwamaakiri maaroni iwayiriti Sísara. Tima tikatsi aparoni awisakotaa-tsini. ");
INSERT INTO prq_vpl VALUES ("JG4_17","008_4_17","JDG","4","17","17","Ikanta isiyawitaka Sísara ariiwitaka owanko-thaantiki Jael, iina Heber, ishininka Asiropakoriiti, tima kamiitha yaapatyaari Jabín yoka Asiropakoriiti. ");
INSERT INTO prq_vpl VALUES ("JG4_18","008_4_18","JDG","4","18","18","Okanta ojatanaki Jael omonthaa-wakari Sísara, owithata-wakari, okantziri: “Pimpoka-waiti nowinkathariti, airo pitharowa-waitzi.” Irootaki ikyaanta-paakari owanko-thaantiki, omanawakiri iroori opasikan-takari manthakintsi-masi. ");
INSERT INTO prq_vpl VALUES ("JG4_19","008_4_19","JDG","4","19","19","Ipoñaa ikantakiro irirori: “Nonintzi pimpina kapichiini nijaa, aatyiina nomiri.” Ashipiryaa-kota-kiniri misinantsi-nakiki ipyaatai-tziri owaaki thomitsi, opakiri irawaki. Aajatzi opasikan-tanaari manthakintsi-masi. ");
INSERT INTO prq_vpl VALUES ("JG4_20","008_4_20","JDG","4","20","20","Ipoñaa ikantziro Sísara iroka Jael: “Arira pinkatziyatyii ikyaa-piintai-tzira piwanko-thaanti, tzimatsi-rika pokatsini, isampita-paakimi inkantimi: ‘¿Tzimatsima saikatsiri aka?’ Pinkanti awiroka: ‘Tikatsi saikatsini.’ ” ");
INSERT INTO prq_vpl VALUES ("JG4_21","008_4_21","JDG","4","21","21","Tima ayimata-kitziri imakori Sísara, imaa-pirota-nakitzii imaanaki. Okanta Jael, iina Heber, aaki osataa-minto, aaki inchaki iwatzika-koitan-tarori owanko-thaanti, onosika-sita-nakari tsika inaryaaka imayira Sísara, opaikakiniri inchaki iitoki, owatzika-kotakiri kipatsiki. Ari okantakari ikamantakari Sísara. ");
INSERT INTO prq_vpl VALUES ("JG4_22","008_4_22","JDG","4","22","22","Ikanta yariita-paaka Barac yamina-minatziri Sísara, omonthaa-wakari Jael, okantawakiri: “Pimpoki, jiirinta atziri pamina-minatziri.” Ikanta ikyaapaaki Barac owanko-thaantiki Jael, iñaapaa-tziiri Sísara inaryaaka kipatsiki, owikakari iitoki inchaki, kamaki. ");
INSERT INTO prq_vpl VALUES ("JG4_23","008_4_23","JDG","4","23","23","Ari ikinakaa-kirori Pawa imatanta-karori Israel-iiti yiitsinampaakiri iwayiriti Jabín pinkatha-ritatsiri Owintiniki. ");
INSERT INTO prq_vpl VALUES ("JG4_24","008_4_24","JDG","4","24","24","Tima oshiki iñaasintsi-waitaka Israel-iiti imatanta-karori yiitsinampairi Jabín pinkatha-ritatsiri Owintiniki, irojatzi yapirotan-takariri. ");
INSERT INTO prq_vpl VALUES ("JG6_1","008_6_1","JDG","6","1","1","Ari yapiita-najiro Israel-iiti ikaaripirotzi-motairi Pawa, ikantakaari Pawa yokaiti Maimani-wini-satzi impira-waityaari Israel-iiti, okaratzi 7 osarintsi. ");
INSERT INTO prq_vpl VALUES ("JG6_2","008_6_2","JDG","6","2","2","Tima aikiro ijatakaa-tziiro Maimani-wini-satzi imapirotziri impira-waitari Israel-iiti. Oshiki itharowan-takari yokaiti, yaminajiitaki Israel-iiti tsika omorontayita impirita otzisi-masiki, omanajiitaka anta. ");
INSERT INTO prq_vpl VALUES ("JG6_3","008_6_3","JDG","6","3","3","Okanta otzimawita-piintara iwankiwairi Israel-iiti, ipokajiitzi Maimani-wini-satzi, Otinkanaawini-satzi, aajatzi poñaayita-chari isitowa-kirotzi ooryaatsiri, iwayiri-minthatari Israel-iiti. ");
INSERT INTO prq_vpl VALUES ("JG6_4","008_6_4","JDG","6","4","4","Inkyaayitaki iipatsitiki ithonki-tziri maaroni iwankiri, ithotyiiro ijayitaki okaratzi tzimayita-tsiri nampitsi anta Sintsi-winiki. Ithonki-tziri maaroni iwankiri, tikatsi iwajyaa, ithonki-tziri yayitziri ikaratzi ipirayitari, aajatzi ikyaakoitari. ");
INSERT INTO prq_vpl VALUES ("JG6_5","008_6_5","JDG","6","5","5","Tima oshiki ikaratzi ipokajiitzi, yamayitaki iwanko-thaanti-payi, ipira-payi, ti iyoitiri tsika-rika ikaratzi oshiki-piro ikarajiitzi. Iriiwaitaki tsitsiri-payi thonkirori owaantsiki iwaro pankirintsi. ");
INSERT INTO prq_vpl VALUES ("JG6_6","008_6_6","JDG","6","6","6","Irootaki ikowityaa-waitan-tajiitari Israel-iiti ikantakaan-tziro Maimani-wini-satzi. Ari ikowa-kotairi Israel-iiti inkisawinta-jyaari Pawa. ");
INSERT INTO prq_vpl VALUES ("JG6_7","008_6_7","JDG","6","7","7","Ikanta ikowa-kotairi Israel-iiti yookakaa-wintairi Pawa imaimani-waitziri Maimani-wini-satzi, ");
INSERT INTO prq_vpl VALUES ("JG6_8","008_6_8","JDG","6","8","8","ityaantaki Pawa aparoni Kamantan-tzinkari, iriitaki kamanta-paakiriri, ikantziri: “Iroka ikantzi Pawa, Iwawani Israel: ‘Naaka omisitowaimi Apitantoniki, naaka aajimiri impira-waitaitami. ");
INSERT INTO prq_vpl VALUES ("JG6_9","008_6_9","JDG","6","9","9","Tira apatziro nookakaa-wintajimi impira-waitami Apitantoni-satzi, nookakaa-wintzi-taami inintawi-jiita impira-waityaami pasini-payi. Piñaayitakina awirokaiti tsika ikanta nomisitowan-takariri naaka yokaiti, nasitakaa-jamiro maaroni iipatsiti. ");
INSERT INTO prq_vpl VALUES ("JG6_10","008_6_10","JDG","6","10","10","Iroka nokantaki: Naaka Piwinkathariti, Piwawani. Airo pipinkatha-waitziri iwawa-niroti-payi Otsisi-wini-satzi, aritaki saikajimi kipatsiki yasiwitari iriroriiti pairani. Iro kantacha ti pinkimisanta-jiitina awirokaiti.’ ” ");
INSERT INTO prq_vpl VALUES ("JG6_11","008_6_11","JDG","6","11","11","Ari ipokakiri Imaninkariti Pawa, isaikapaaki okanta-tapi-sitaka inchato anta Maniraaniki, iroka inchato irasi aparoni atziri paitachari Joás, ishininka-mirinka Abiezer. Tzimatsi aparoni itomi ipaita Gedeón, iriitaki saikain-tsiri ikawirinkaita-piintziro chochoki iraitziri, itikaki-waitzi iwankiri imananikiini, airo iñaantari Maimani-wini-satzi. ");
INSERT INTO prq_vpl VALUES ("JG6_12","008_6_12","JDG","6","12","12","Arira iñaakakari Imaninkariti Pawa yoka Gedeón, ikantapaakiri: “¡Ñaapirori pinatzii awiroka, irootaki itsipatan-tamiri Pawa!” ");
INSERT INTO prq_vpl VALUES ("JG6_13","008_6_13","JDG","6","13","13","Ari yakanaki Gedeón, ikantziri: “Ñaamisa, nowinkathariti, arimi intsipatyaana Pawa, ¿ipaitama awishi-motan-tanari iroka-payi? ¿Ipaitama kaari itasonka-wintantari ikimitaakiro pairani yookakaa-wintan-tairi Apitantoniki? Ikinkithata-kotakiro nowaisatzitini-payi okaratzi kaari iñaapiintaitzi imayitakiri pairani Pawa. Irooma iroñaaka, ti imiraawintajina, isinitakiri Maimani-wini-satzi impira-waityaana.” ");
INSERT INTO prq_vpl VALUES ("JG6_14","008_6_14","JDG","6","14","14","Ari yamina-nakiri Pawa, ikantanakiri: “Pijati, tima sintsiri pinatzii, aritaki piwawisaa-kotairi pishininka Israel-iiti impira-waitakari Maimani-wini-satzi. Naaka otyaantzimiri.” ");
INSERT INTO prq_vpl VALUES ("JG6_15","008_6_15","JDG","6","15","15","Iro kantacha Gedeón, yapiita-najiri ikantziri: “Ñaamisa pinkathari, ¿tsika nonkinika nowawisaa-kotajiri naaka noshininka Israel-iiti? Tima ti niriipiroti nokaratzi noshininkai-titari Manasés, naaka iyaapitsi.” ");
INSERT INTO prq_vpl VALUES ("JG6_16","008_6_16","JDG","6","16","16","Ikantzi Pawa: “Aritaki pimatakiro, tima naakataki tsipatyaamini. Aritaki piitsinampaakiri Maimani-wini-satzi pinkimita-kaantiri yiitsinampai-tziri aparoni atziri.” ");
INSERT INTO prq_vpl VALUES ("JG6_17","008_6_17","JDG","6","17","17","Ikantzi Gedeón: “Iriirika Pawa ninta-kayi-narori, nonintzi piñaakainaro noyotan-tyaari iriita-jaantaki kinkitha-waita-kayinari. ");
INSERT INTO prq_vpl VALUES ("JG6_18","008_6_18","JDG","6","18","18","Nonintzi piyaa-kota-wakina aka irojatzi nompiyan-takyaari, nonintzi naakitimi piyaari.” Ikantzi Pawa: “Ari nosaikawaki aka, irojatzi pimpiyan-takyaari.” ");
INSERT INTO prq_vpl VALUES ("JG6_19","008_6_19","JDG","6","19","19","Jataki Gedeón, iwamaaki kiripiri ipira, ikotsitakiri. Ipoñaa yaaki iwankiri-pani, irootaki yatantani kaari ikonowi siñatsini. Ititanakiri iwatha kantziriki, irooma iyaaki yookanakiro kowitziki. Yaakota-nakiri okanta-tapisita inchato, yasitakai-yaari Pawa. ");
INSERT INTO prq_vpl VALUES ("JG6_20","008_6_20","JDG","6","20","20","Ari ikantanaki Imaninkariti Pawa: “Payiri wathatsi aajatzi patantari kaari siñatsini, piwiri mapiki, pisaitan-tyaari iyaaki.” Imatakiro Gedeón ikantakiriri. ");
INSERT INTO prq_vpl VALUES ("JG6_21","008_6_21","JDG","6","21","21","Iwaanka-nakiro ikotzikiiri Imaninkariti Pawa, itzinkan-takari wathatsi, imatakiro yatantani kaari ikonowaitzi siñakaironi. Apatha-kiro opaamatanaki mapiki, apirotakiri otaakiri wathatsi aajatzi yatantani. Ari ipyaanakari Maninkari ti iñaawajiri tsika ikinanaki. ");
INSERT INTO prq_vpl VALUES ("JG6_22","008_6_22","JDG","6","22","22","Ikanta iyotanaki Gedeón omapiro iñaakiri Imaninkariti Pawa, itharowanaki, ikantanaki: “¡Ñaamisa Pawa, noñaa-porotajiri Pimaninkariti!” ");
INSERT INTO prq_vpl VALUES ("JG6_23","008_6_23","JDG","6","23","23","Ari ikantanakiri Pawa: “Airo pitharowan-tawaitari, airo pikami. Aritaki pisaika-waitaji kamiitha.” ");
INSERT INTO prq_vpl VALUES ("JG6_24","008_6_24","JDG","6","24","24","Arira ipiriintanaki Gedeón pomipirini-mintotsi ipinkathata-nakiri Pawa, ipaitanakiro Kamiitha Isaikakaantaji Pawa. Irojatzi okanta iñiitziro ipomi-pirini-minto anta Maniraaniki, inampitsitiki ishininkaiti Abiezer. ");
INSERT INTO prq_vpl VALUES ("JG6_25","008_6_25","JDG","6","25","25","Okanta otsitinitanaki, iñaanatajiri Pawa, ikantairi: “Payi iriipirori ipiratari piri. Pijati pimporokiro ipomi-pirini-minto pawaniro Inkaniwiri iwawani-waita-sitari piri, pintowa-pithatiri aajatzi osiyakaaro pawaniro Inkaariwiro otsipa-nampitari. ");
INSERT INTO prq_vpl VALUES ("JG6_26","008_6_26","JDG","6","26","26","Piwitsikaji awiroka anta tonkaariki pasini pomipirini-mintotsi tsika pimpinkathatairi Pawa. Paanakiri iriipirori ipiraitari, pimpomitiniri Pawa pintaan-tyaari osiyakaaro pawaniro Inkaariwiro pitowakiri.” ");
INSERT INTO prq_vpl VALUES ("JG6_27","008_6_27","JDG","6","27","27","Ari yaanaki Gedeón ikaratzi 10 impiratani, imatakiro ikantakiriri Pawa. Iro kantacha tira imatiro kitaipaiti, tsitini-paiti imatakiro, tima itharowan-tatyaari ishininka-payi iriri, aajatzi pasini-payi atziri nampitarori anta. ");
INSERT INTO prq_vpl VALUES ("JG6_28","008_6_28","JDG","6","28","28","Okanta okitaitita-manaji, ipiriinta-manaja atziri-payi, iñaatziiro ithonka oporokaki ipomi-pirini-minto pawaniro Inkaniwiri, ari okimitakari osiyakaaro pawaniro Inkaariwiro tsipa-nampitarori pomipirini-mintotsi, tyaaki. Iñiitatziiri ipomitai-takiri ipiraitari owakirariki pomipirini-minto-tsiki. ");
INSERT INTO prq_vpl VALUES ("JG6_29","008_6_29","JDG","6","29","29","Ari isampita-wakaa-jiita, ikantajiitzi: “¿Ipaitama matakirori iroka?” Ikanta ikaratakiro isampitako-winta-yitziro, ari iyotaki iriitaki Gedeón, itomi Joás matakirori. Ari ijata-sitai-tanakiri Joás, ikantai-tapaakiri: ");
INSERT INTO prq_vpl VALUES ("JG6_30","008_6_30","JDG","6","30","30","“Pamakiri pitomi, nonintatzii nowiri. Tima iporokakiro ipomi-pirini-minto nowawani Inkaniwiri, imatzitakaro osiyakaaro Inkaariwiro tsipa-nampita-karori anta.” ");
INSERT INTO prq_vpl VALUES ("JG6_31","008_6_31","JDG","6","31","31","Iro kantacha yakanakiri Joás maaroni yokaiti, ikantziri: “¿Iriima pikisa-kotari awirokaiti Inkaniwiri? Itzimi-rika kisakowaityaarini Inkaniwiri, inkamataiti onkitaititzi-mataki. Iriimi mapirotzirori ipawatzi inkisako-wintyaami apaniroini, tima iriitaki asitaro ipomi-pirini-minto iporoki-taita-kiriri.” ");
INSERT INTO prq_vpl VALUES ("JG6_32","008_6_32","JDG","6","32","32","Aripaiti iwaitai-tanakiri Gedeón, ikantai-tziri “Inkisako-wintyaa Inkaniwiri”, tima iriitaki Gedeón porokita-kiriri ipomi-pirini-minto Inkaniwiri. ");
INSERT INTO prq_vpl VALUES ("JG6_33","008_6_33","JDG","6","33","33","Ikanta Maimani-wini-satzi, Otinkanaawini-satzi, aajatzi pasini-payi atziri-payi poñainchari isitowa-kirotzi ooryaatsiri, yapatojiitaka, montyaa-paaka intatzikiro Owaryiinkaariniki, ari iwanko-thaanti-jiita-paaka otaapiki inampiitiki Panki-Pawa-wini. ");
INSERT INTO prq_vpl VALUES ("JG6_34","008_6_34","JDG","6","34","34","Iro kantacha isaika-siritan-tanakari Itasorinka Pawa yoka Gedeón. Ikanta ityootan-tanakaro ichii ipiraitari yaapatyaan-tyaariri maaroni ishininka-payi Abiezer. ");
INSERT INTO prq_vpl VALUES ("JG6_35","008_6_35","JDG","6","35","35","Ari ityaantaki aajatzi kaimirini ishininka-payi Manasés, impokiita yapatotyaa maaroni. Ityaantaki aajatzi kaimirini ishininka-payi Aser-iiti, Zabulón-iiti aajatzi Neftalí-iti, ari ikaratziri yapatojiitaka itsipatakari Gedeón. ");
INSERT INTO prq_vpl VALUES ("JG6_36","008_6_36","JDG","6","36","36","Ari ikowa-kotakiri Gedeón Pawa, ikantziri: “Omapiro-rika pintyaantina nowawisaa-kotajiri noshininka-payi Israel-iiti, okaratzi pikanta-kinari awiroka, ");
INSERT INTO prq_vpl VALUES ("JG6_37","008_6_37","JDG","6","37","37","iroka nowiri iwitzi-mampo ipiraitari anta tsika itikaita-piintai-tziro pankirintsi. Aririka noñaa-manajiri inthonka yashitaki iwitzi-mampo, irooma kipatsiki piryaa onkantyaa airo ashiwaitzi, ari noyoti omapiro pininta-kayinaro nowawisaa-kotajiri noshininka-payi Israel-iiti.” ");
INSERT INTO prq_vpl VALUES ("JG6_38","008_6_38","JDG","6","38","38","Tima omataka okaratzi ikantakiri. Ikanta isaakita-manaji Gedeón, ichoowairo iwitzi-mampo ipiraitari, ijaikitaki aparoni pajoki ichoowakiri nijaa. ");
INSERT INTO prq_vpl VALUES ("JG6_39","008_6_39","JDG","6","39","39","Iro kantacha Gedeón, ikantajiri Pawa: “Ti noninti nowatsimaimi aririka napiitiro nonkantimi. Nonintzi napiitiri noñiiri iroñaaka iwitzi-mampo ipiraitari. Apatziro ashiti maaroni kipatsiki, irooma maaroni iwitzi-mampo irojatzi impiryaati airo yashiwaitzi.” ");
INSERT INTO prq_vpl VALUES ("JG6_40","008_6_40","JDG","6","40","40","Okanta otsitinitanaki imatakiro Pawa inintakiri Gedeón. Ikanta ipiriinta-manaja, iñaatziiro ithonka ashitaki kipatsi, irooma iwitzi-mampo ipiraitari opiryaatzi kamiithaini ti ashiwaiti kapichiini. ");
INSERT INTO prq_vpl VALUES ("JG7_1","008_7_1","JDG","7","1","1","Ikanta Gedeón, ipaitakaantai-tziri Inkisako-wintyaa Inkaniwiri, itsipatakari ikaratzi oyaatakiriri, ananinkaka ainiro otsitiniin-katzi jataki iwankothaantiyityaa nijaatinkaki Piyonkawaitinkaariniki. Iriima Maimani-wini-satzi iwanko-thaanti-jiitaka irirori katonkoki otonkai-mata otzisi ipaitai-tziri Manatzinkai-toni. ");
INSERT INTO prq_vpl VALUES ("JG7_2","008_7_2","JDG","7","2","2","Ari iñaanatajiri Pawa yoka Gedeón, ikantairi: “Oshiki-piro ikaratzi atziri oyaatakimiri, airo piñaakaa-nakari Maimani-wini-satzi papirotiri, kimitaka ari intharowinta-nakyaa Israel-iiti isiyakaantzi iriitaki wawisaa-kotacha apaniroini. ");
INSERT INTO prq_vpl VALUES ("JG7_3","008_7_3","JDG","7","3","3","Papatotiri maaroni, inthonka inkimajiiti pinkantiri: ‘Tzimatsi-rika tharowa-sirita-tsiri, piyonkawaita-chari, impiyi ishininkaki anta Wakaniki.’ ” Ari ikinakairori Gedeón iñaantari atziri-payi. Iñaatziiri ikaratzi piyanain-chari ikarajiitzi 22000 atziri, apatziro isaikanaki ikarajiitzi 10000 atziri. ");
INSERT INTO prq_vpl VALUES ("JG7_4","008_7_4","JDG","7","4","4","Iro kantacha aikiro isintsitatzii Pawa, ikantziri Gedeón: “Ainiro ishikitzi atziri. Paanakiri nijaaki pirakairi nijaa, ari noñaantyaariri anta. Tima naaka kantimini itzimi-rika pintsipatyaari.” ");
INSERT INTO prq_vpl VALUES ("JG7_5","008_7_5","JDG","7","5","5","Yaanakiri Gedeón atziri-payi irakairi nijaa. Ikantzi Pawa: “Pinasiyityaari siyakotyaarini otsitzi irantarori inini. Piinasita-kyaari aajatzi oiyoota-painchani irapaakiro nijaa.” ");
INSERT INTO prq_vpl VALUES ("JG7_6","008_7_6","JDG","7","6","6","Tima inkarati awishaata-paakirori irakoki nijaa irapaaki, osiya-kota-kariri otsitzi iranta-karori inini nijaa, ikarajiitzi 300 atziri. Iriima pasini-payi ithonka yoiyoota-paaka irajiita-paaki nijaa. ");
INSERT INTO prq_vpl VALUES ("JG7_7","008_7_7","JDG","7","7","7","Ari yapiitziro Pawa ikantziri Gedeón: “Yokaiti karatain-tsiri 300 atziri, iriiyitakira nonkanta-kaiyaari yapirotajiri Maimani-wini-satzi, iriitaki wawisaa-koyita-jimini maaroni awirokaiti. Iriima pasini-payi, kantatsi ijayitaji ishininkaki” ");
INSERT INTO prq_vpl VALUES ("JG7_8","008_7_8","JDG","7","8","8","Imatakiro Gedeón ityaantajiri pasini-payi ijayitaji iwanko-thaantiki, apatziro imisaika-wajiri karatain-tsiri 300 atziri. Ikampita-wajiri jatayitaa-tsiri yookana-jiniri irira-minto-payi, aajatzi ityoo-minto-payi yaitziro ichii-payi ipiraitari. Tima panko-thaanti-jiitaka iriroriiti Maimani-wini-satzi otaapiki. ");
INSERT INTO prq_vpl VALUES ("JG7_9","008_7_9","JDG","7","9","9","Okanta otsitinitanaji, iñaanatajiri Pawa jiwari Gedeón, ikantairi: “Pimpiriinti, poirinki piwayirityaari Maimani-wini-satzi, nosinita-kimiri naaka. ");
INSERT INTO prq_vpl VALUES ("JG7_10","008_7_10","JDG","7","10","10","Ainiro-rika pitharowantari, pijata-sitiri iwanko-thaantiki pintsipata-nakyaari pimpiratani Furá. ");
INSERT INTO prq_vpl VALUES ("JG7_11","008_7_11","JDG","7","11","11","Pinkimisantiri opaita inkanta-wakai-yaari. Aririka piñaa-pirota-nakyaa, pimatiro piwayirityaari.” Imatakiro jiwari Gedeón oirinkanaka itsipata-nakari Furá, impiratani, yariitakari isaikaki iwayiri-minthatani. ");
INSERT INTO prq_vpl VALUES ("JG7_12","008_7_12","JDG","7","12","12","Ikanta Maimani-wini-satzi, Otinkanaawini-satzi aajatzi atziri-payi poñaayitain-chari isitowa-kirotzi ooryaatsiri, ithonka iwaraaka anta, ikimita-kotakari ishikitzi inarapakita-tsiri. Tzimatsi oshiki ipiraitari ikyaa-kotari, ikimiwaitakaro oshikitzi impaniki nijaa-thapyaaki. ");
INSERT INTO prq_vpl VALUES ("JG7_13","008_7_13","JDG","7","13","13","Ikanta yariita-paaka Gedeón iwanko-thaanti-jiita iisaniintani, ikimapaa-kitziiri ikinkitha-waitzi aparoni owayiri ikamantziri imisitakiri pasini, ikantziri: “Nomisitaki yatantaitari opinaapaaka tonkaariki irojatzi awanko-thaantiki, othonka anawyaa-paakiro maaroni.” ");
INSERT INTO prq_vpl VALUES ("JG7_14","008_7_14","JDG","7","14","14","Ikantzi = ya pasini: “Kimitaka isataa-minto onatzii Gedeón, itomi Joás, icharini Israel. Iriitaki Pawa sinitakiri Gedeón yapatoyitaji arokaiti Maimani-wini-satzi, yapirotairo maaroni awanko-thaantiki.” ");
INSERT INTO prq_vpl VALUES ("JG7_15","008_7_15","JDG","7","15","15","Ikanta ikimakiri Gedeón ikamanta-wakaa-jiita imisitakiri, ipaasoonkita-nakiri Pawa. Piyanaka iwanko-thaantiki Israel-iiti, ikaimapaaki, ikantzi: “¡Pimpiriinti, isinita-kairi Pawa maaroni Maimani-wini-satzi!” ");
INSERT INTO prq_vpl VALUES ("JG7_16","008_7_16","JDG","7","16","16","Inasita-nakari ikarajiitzira 300 atziri. Tima inkarati mawa ipiyotakiri, ipayitakiri ityoo-minto, ipayitakiri kowitzi yoisayitakiri ootamintotsi inthompointa. ");
INSERT INTO prq_vpl VALUES ("JG7_17","008_7_17","JDG","7","17","17","Ikantakiri: “Aririka nariitakyaa intatzikironta iwanko-thaantitaka owayiritani, naaka pitzika-natyaa, pimatiro onkarati nantiri. ");
INSERT INTO prq_vpl VALUES ("JG7_18","008_7_18","JDG","7","18","18","Aririka nontyootanaki nontsipata-kyaari ikaratzi oyaatakinari, irojatzi pimatiri awirokaiti, ashonkamaityaaro iwanko-thaanti-yitaka, pinkaima-jiiti, pinkanti: ‘¡Antyoowintiri Pawa itsipatari Gedeón!’ ” ");
INSERT INTO prq_vpl VALUES ("JG7_19","008_7_19","JDG","7","19","19","Imatakiro Gedeón ikarata-kirira 100 iwayiriti, ariijiitaka intatzikiro, niyaankiitiki, iroowitaincha yimpoyiitajyaa owayiri aamaako-winta-chari. Ari ityoojiitanaki, isataayita-nakiro kowitzi-naki yamayitakiri, ");
INSERT INTO prq_vpl VALUES ("JG7_20","008_7_20","JDG","7","20","20","imatzita-nakaro inasitakari inkaaranki, ityootanaki, isataayita-nakiro kowitzi-naki yairika-yitakiri. Pasiniki irako yairika-yitakiri iroota-minto, irako-piroki yairikakiri ityoo-minto, ikaimajiitzi, ikantzi: “¡Awayiri-wintyaari Pawa, itsipatakari Gedeón!” ");
INSERT INTO prq_vpl VALUES ("JG7_21","008_7_21","JDG","7","21","21","Ti ishiwajiityaa Israel-iiti, irojatzi ikatziyaka itapotakiro iwanko-thaanti-payi iwayiri-minthatanti, ithonka isiyanaka Maimani-wini-satzi, ikaimawaita-sitanaka. ");
INSERT INTO prq_vpl VALUES ("JG7_22","008_7_22","JDG","7","22","22","Aikiro ityoojiitatzii 300 Israel-iiti, ikantakaaro Pawa, irijatzi pithoka-sita-wakaa-naincha Maimani-wini-satzi. Ithonka isiyajiitanaka Inchapankoniki, saikatsiri awotsiki Ompirawiniki, irojatzi yariitantaka owiraa-thapitaka Amashaitaa-riniki, otsipa-nampitari Otipitokiwini. ");
INSERT INTO prq_vpl VALUES ("JG7_23","008_7_23","JDG","7","23","23","Ikaimakiri ishininka-mirinka Israel-iiti, yokaiti Neftalí-iti, Aser-iiti aajatzi icharini-payi Manasés, iriitaki patzi-matirini iwatsita-wajiri siyanain-chari Maimani-wini-satzi. ");
INSERT INTO prq_vpl VALUES ("JG7_24","008_7_24","JDG","7","24","24","Ityaantaki Gedeón kamantirini nampitarori iipatsitiki Efraín-iiti, ikantaki: “Poirinkayiti, piwayirityaari Maimani-wini-satzi, panaa-kotiri awirokaiti paayitajiro montyii-rontsi, irojatzi anta Awisapankoniki, aajatzi Owaryiinkaariniki.” Imatakiro ishininka-mirinka Efraín-iiti, okaratzi ikamantai-takiriri. ");
INSERT INTO prq_vpl VALUES ("JG7_25","008_7_25","JDG","7","25","25","Yairikaitaki apiti ijiwari Maimani-wini-satzi, ipaita Oreb, pasini Zeeb. Yaanakiri osaikira siranta, iwakiri. Anta tsika iwai-takiri, ipaitai-takiro Isirantaati Oreb. Irooma tsika iwai-takiri Zeeb, aakotajiro iwairoki irirori. Ari ikawirinkaita-piintziro chochoki iraitziri. Ikanta ipatzimaminthai-tziri Maimani-wini-satzi, yaanajiniri Gedeón iito Oreb aajatzi irasi Zeeb, isaikira irirori intatzikironta Owaryiinkaariniki. ");
INSERT INTO prq_vpl VALUES ("JG11_1","008_11_1","JDG","11","1","1","Tzimatsi aparoni ishininka Israel-iiti ipaita Jefté, iriipirori owayiri inatzi, iriitaki nampitarori Wakaniki, otomi aparoni mayimpiro, iwaiyan-takairo ipaitai-tziri Waka, ikantai-tziri iñaaniki iriroriiti Galaad. ");
INSERT INTO prq_vpl VALUES ("JG11_2","008_11_2","JDG","11","2","2","Iro kantacha yoka Waka tzimatsi pasini iina, irootaki iwaiyan-takaaki aajatzi. Ikanta yantari-yitanaki iwaiyani, imisitowai-takiri Jefté iwankoki asitariri, ikantai-takiri: “Pisitowi pisaiki iwankoki asitairi, awiroka owaiyani kooya mayimpiro.” ");
INSERT INTO prq_vpl VALUES ("JG11_3","008_11_3","JDG","11","3","3","Irootaki isiya-pithatan-takariri Jefté iririntzi-payi, jataki inampitaro Kamiithaariniki. Ari yapatotaki anta oshiki pirantziiti atziri, iriitaki itsipa-minthatari. ");
INSERT INTO prq_vpl VALUES ("JG11_4","008_11_4","JDG","11","4","4","Okanta apaata pokaki Pityaankaarini-satzi iwayiritari Israel-iiti. ");
INSERT INTO prq_vpl VALUES ("JG11_5","008_11_5","JDG","11","5","5","Ikanta iwayiri-jiitara, ari ityaantai-takiri jiwari-payi Wakani-satzi yaakitiri Jefté isaikira irirori Kamiithaarini. ");
INSERT INTO prq_vpl VALUES ("JG11_6","008_11_6","JDG","11","6","6","Ikantai-tapaakiri: “Pimpoki, nonintzi pijiwatina awiroka ankarajiiti owayirityaari Pityaankaarini-satzi.” ");
INSERT INTO prq_vpl VALUES ("JG11_7","008_11_7","JDG","11","7","7","Iroka ikantzi Jefté yakawakiri jiwari-payi poñaachari Wakaniki: “Airo okantzi, tima oshiki pikisa-niinta-jiitakina awirokaiti, pimisitowakina iwankoki asitanari. ¿Ipaitama pipoka-sitan-tanari piñaakiro imaimanitai-tzimi?” ");
INSERT INTO prq_vpl VALUES ("JG11_8","008_11_8","JDG","11","8","8","Ikantajiitzi jiwari-payi poñaachari Wakaniki: “Irootaki nopoka-sitan-tamiri iroñaaka. Pimpoki antsipata-wakaiyaa owayirityaari Pityaankaarini-satzi. Tima awiroka jiwatairini ikaratzi nampitarori anta Wakaniki.” ");
INSERT INTO prq_vpl VALUES ("JG11_9","008_11_9","JDG","11","9","9","Ikantzi Jefté: “Awiroka-rika nintatsi nojati owayirityaari Pityaankaarini-satzi, iriirika Pawa kantakai-yaaroni, aritaki nomatakiro nojiwatimi.” ");
INSERT INTO prq_vpl VALUES ("JG11_10","008_11_10","JDG","11","10","10","Ikantzi jiwari-payi: “Iriitaki Pawa yotatsi, aritaki nomatakimiro onkarati pinkantinari.” ");
INSERT INTO prq_vpl VALUES ("JG11_11","008_11_11","JDG","11","11","11","Jataki Jefté iyaatanakiri pokasita-kiriri, iwakiri atziri-payi iwinkathari-titajyaari aajatzi ijiwatairi iwayiriiti. Okanta anta Aminaironi, ari yapiitakiro Jefté okaratzi ikantakiriri owakira ipokanaki, iro inkiman-tyaariri pasini-payi owayiriiti. ");
INSERT INTO prq_vpl VALUES ("JG11_12","008_11_12","JDG","11","12","12","Ikanta ikaratakiro ikantayitakiri, ityaantaki jatasitirini iwinkathariti Pityaankaarini-satzi, isampitiri, inkantiri: “¿Ipaitama pikisako-niintari pinintantari piwayirityaana?” ");
INSERT INTO prq_vpl VALUES ("JG11_13","008_11_13","JDG","11","13","13","Iroka ikantzi iwinkathariti Pityaankaarini-satzi yakawakiri ityaantani Jefté: “Nopokatzii naajiro noipatsiti, opoñaanakaro katonko osaikira nijaa Poimarini irojatzi kiriinka osaikira nijaa Sakochaaroni. Ari okimitari isitowa-kirotziro ooryaatsiri, opoñaanakaro otzisi-masiki irojatzi tsika ikyaa-kirotziro ooryaatsiri osaikira nijaa Owaryiinkaarini. Tima irootaki yayitakinari pairani piwaisatziti isitowan-taari Apitantoniki. Nonintzi iroñaaka poipyaa-jinaro kamiitha-piroini.” ");
INSERT INTO prq_vpl VALUES ("JG11_14","008_11_14","JDG","11","14","14","Ipoñaa ityaantaki Jefté pasini jatasitirini iwinkathariti Pityaankaarini-satzi, ");
INSERT INTO prq_vpl VALUES ("JG11_15","008_11_15","JDG","11","15","15","ikantapaakiri: “Ikantakaan-tzimi Jefté: ‘Naakaiti-witaka icharini-payi Israel-iiti, tira noñaajiro yaapithatan-takariri iipatsiti Athataa-wini-satzi, aajatzi awirokaiti Pityaankaarini-satzi. ");
INSERT INTO prq_vpl VALUES ("JG11_16","008_11_16","JDG","11","16","16","Tima pairani isitowan-taari Apitantoniki nowaisatzitini, ikinanajiro otzisi-masiki irojatzi Inkaariki Kityonkaari, yawisanaki irojatzi yariitan-takari Tasorinchaariniki. ");
INSERT INTO prq_vpl VALUES ("JG11_17","008_11_17","JDG","11","17","17","Ityaanta-witaka jatasita-kiriri iwinkathariti Kiraarini-satzi, inkantiri: ‘Pisinitina nonkinanaki pipatsitiki.’ Iro kantacha ti isinitiri inkini-mota-nakiri. Ikantawitakari aajatzi iwinkathariti Athataa-wini-satzi, ti isinitiri aajatzi inkini-motiri. Irootaki isaikan-tapaakari Tasorinchaariniki. ");
INSERT INTO prq_vpl VALUES ("JG11_18","008_11_18","JDG","11","18","18","Ikinawaitaki otzisi-masiki, itapota-nakiro iipatsiti Kiraarini-satzi, ari ikimita-kirori iipatsiti Athataa-wini-satzi. Okanta iwiraaka anta Kamiñaariniki, iwitsika-paaki iwanko-thaanti intatzikiro. Titzimaita ijati intatzikiro, tima irootaki iipatsiti Athataa-wini-satzi. ");
INSERT INTO prq_vpl VALUES ("JG11_19","008_11_19","JDG","11","19","19","Ityaanta-witaka jatasitirini Sehón, iwinkathariti Tonkaarisatzi nampitarori anta Karawiniki, ikantawitakari isinitiri inkinanaki iipatsiti ijatantyaari iipatsitiki irirori. ");
INSERT INTO prq_vpl VALUES ("JG11_20","008_11_20","JDG","11","20","20","Ti ininti Sehón inkini-mota-nakiri iipatsitiki, yapatotaki iwayiriti, itzima-sitakiri Aatzikaitoniki, iwayirita-wakari. ");
INSERT INTO prq_vpl VALUES ("JG11_21","008_11_21","JDG","11","21","21","Iro kantacha ikamintha Pawa, Iwawani Israel, iriitaki kantakaa-karori, iwanakiri Sehón, yapirota-nakiri iwayiriti. Ari ikinakairori Pawa yaapithatan-tanakariri iipatsiti Tonkaarisatzi. ");
INSERT INTO prq_vpl VALUES ("JG11_22","008_11_22","JDG","11","22","22","Opoñaanakaro katonko osaikira nijaa Poimarini irojatzi kiriinka osaikira nijaa Sakochaaroni. Ari okimitakari isitowa-kirotziro ooryaatsiri, opoñaanakaro otzisi-masiki irojatzi tsika ikyaa-kirotziro ooryaatsiri osaikira nijaa Owaryiinkaarini. ");
INSERT INTO prq_vpl VALUES ("JG11_23","008_11_23","JDG","11","23","23","¿Pininta-tziima paapithainaro noipatsiti ipakinari pairani Pawa yaapithata-kiriri Tonkaarisatzi? ");
INSERT INTO prq_vpl VALUES ("JG11_24","008_11_24","JDG","11","24","24","Tima otzimi-rika yasitakai-yaamiri piwawa-niroti Kitsirinkan-taniri, pasi onatzi awiroka. Aritaki okanta. Ari nokimitari naakaiti aajatzi, nasiyitaro okaratzi yasita-kayinari Nowawani Pawa. ");
INSERT INTO prq_vpl VALUES ("JG11_25","008_11_25","JDG","11","25","25","¿Pisiyakaantzima panairi piriipirotzi yoka Balac, itomi Zipor, iwinkathariti Athataa-wini-satzi? Ti impokajiiti irirori, iwayirityaana. ");
INSERT INTO prq_vpl VALUES ("JG11_26","008_11_26","JDG","11","26","26","Tima awisaki oshiki osarintsi nonampitaro anta Karawiniki, Sapokaariniki, maaroni okaratzi otsipa-nampi-yitari anta, aajatzi anta othapyaaki Poimarini. ¿Ipaitama kaari paantaro pairani iroka kipatsi? ");
INSERT INTO prq_vpl VALUES ("JG11_27","008_11_27","JDG","11","27","27","Tira naakaiti poñaakaan-tyaamini, awirokaiti poñaakaantasitaro pinintzi piwayirityaana. Iro kantacha apatziro iyotzi Pawa, iriitaki amina-kota-jinani naakaiti aajatzi awirokaiti.’ ” ");
INSERT INTO prq_vpl VALUES ("JG11_28","008_11_28","JDG","11","28","28","Titzimaita inkimisanti iwinkathariti Pityaankaarini-satzi ikantawita-kariri Jefté. ");
INSERT INTO prq_vpl VALUES ("JG11_29","008_11_29","JDG","11","29","29","Ikanta Itasorinka Pawa, ikantakaa-nakari Jefté, jataki yaminiro iipatsiti Wakani-satzi, aajatzi irasi icharini-payi Manasés. Ari yapatotanaki ishininka-payi inintzi yaapithatantiro intsipatakyaa-rika irirori. Ipoñaa ipiyaaro ikinapajiro Aminaironiki saikatsiri anta Wakaniki. Ipoñaa yawisanaki Jefté ikinaki iipatsitiki Pityaankaarini-satzi. ");
INSERT INTO prq_vpl VALUES ("JG11_30","008_11_30","JDG","11","30","30","Tzimatsi ikasiya-kaakiriri Jefté Pawa, ikantakiri: “¡Pawa! Aririka pinkanta-kaakyaaro napirotiri Pityaankaarini-satzi, ");
INSERT INTO prq_vpl VALUES ("JG11_31","008_11_31","JDG","11","31","31","ari nompomita-kimiri itawajyaaroni iwithatyaana nowankoki aririka nariitajyaa nowayirityaa.” ");
INSERT INTO prq_vpl VALUES ("JG11_32","008_11_32","JDG","11","32","32","Ari ijatanaki Jefté yaapithatiri iipatsiti Pityaankaarini-satzi, iwayiritakari, ikantakaakaro Pawa yapirotakiri iwayiritani. ");
INSERT INTO prq_vpl VALUES ("JG11_33","008_11_33","JDG","11","33","33","Tima oshiki iwamaaki Jefté ikisaniintani, yasitaaro okaratzi 20 nampitsi tzimayita-tsiri anta ipaitai-tziro: Sapokaarini, Kashitaarini, aajatzi Chochokitinkaarini. Aripaiti impira-waitakari Israel-iiti maaroni Pityaankaarini-satzi. ");
INSERT INTO prq_vpl VALUES ("JG11_34","008_11_34","JDG","11","34","34","Ikanta ipiyaaro Jefté iwankoki anta Aminaironiki, osiya-sita-waari yapintoti irisinto, omitaa-mitaa-waita owisiryaa-winta-waari okampinita-kaakiro owisiryaa-minto-payi. Aparoni okanta irisinto, tikatsi pasini. ");
INSERT INTO prq_vpl VALUES ("JG11_35","008_11_35","JDG","11","35","35","Tima antaroiti iwasiritanaka iñaakiro irisinto, isara-nakiro iithaari, ikantziro: “¡Ñaamisa, nosinto, antaroiti piwasirita-kaana! ¡Awirokataki owaaripirotakaantinani, tima tzimatsi nokasiya-kaakiriri Pawa, ontzimatyii nomonkaratiniri nokanta-kiriri!” ");
INSERT INTO prq_vpl VALUES ("JG11_36","008_11_36","JDG","11","36","36","Akanakiri iroori, okantzi: “Apaá, pimatina okaratzi pikasiya-kaaki-niriri Pawa, tima imatakimiro irirori yiitsinampaa-kaakimiri Pityaankaarini-satzi piwayiritani. ");
INSERT INTO prq_vpl VALUES ("JG11_37","008_11_37","JDG","11","37","37","Apatziro nonintzi pisinitina apiti kasiri nojati otzisi-masiki, nonkarata-nakiri naapatyaa-minthatani, ari niraako-waityaa, tima nonkamatyii, airo noñiiro intzimi notsipatari.” ");
INSERT INTO prq_vpl VALUES ("JG11_38","008_11_38","JDG","11","38","38","Isinitakiro Jefté irisinto ojati apiti kasiri onkinawaiti otzisi-masiki, ari okaratanakiri otsipa-minthatani, antaroiti iraakowaitaka tima onkamatyii airo oñiiro ayi iroori oimi. ");
INSERT INTO prq_vpl VALUES ("JG11_39","008_11_39","JDG","11","39","39","Okanta apaata, piyaja owankoki, imatakiro asitarori okaratzi ikasiya-kaaki-niriri Pawa. Kamaki irisinto Jefté, tira oñaajiri iroori sirampari. ");
INSERT INTO prq_vpl VALUES ("JG11_40","008_11_40","JDG","11","40","40","Irootaki amitantarori mainaroiti Israel-iiti ojata-piintzi osarintsiki iraakowaita-jyaaro irisinto Jefté, Wakani-satzi, onkarati 4 kitaitiri osaikawaiti otzisi-masiki. ");
INSERT INTO prq_vpl VALUES ("JG13_1","008_13_1","JDG","13","1","1","Ikanta yapiita-najiro Israel-iiti ikaaripirotanaji, ikantakaakaro Pawa impirana-waityaari Kinawaita-niriiti onkarati 40 osarintsi. ");
INSERT INTO prq_vpl VALUES ("JG13_2","008_13_2","JDG","13","2","2","Ari isaikiri aparoni atziri anta Sanii-winiki, ishininka-mirinka inatzii Dan-iiti, ipaita Manoa. Ti owaiyanta-niti iina. ");
INSERT INTO prq_vpl VALUES ("JG13_3","008_13_3","JDG","13","3","3","Okanta aparoni kitaitiri iñaakakaro Imaninkariti Pawa, ikantakiro: “Ti intzima-wityaa piwaiyani, maaniro pinatzii, iro kantacha iroñaaka pimotyaati, aritaki intzimaki pitomi. ");
INSERT INTO prq_vpl VALUES ("JG13_4","008_13_4","JDG","13","4","4","Iro kantacha airo pirawaitziro awiroka kachori, airo piwayitari ikaratzi ipinkai-tziri. ");
INSERT INTO prq_vpl VALUES ("JG13_5","008_13_5","JDG","13","5","5","Tima piwaiyan-tatyiiri iinchaa-niki kaari isinitaiti intotaitiro iisi. Pasitakai-yaari Pawa yoka iintsi, tima Kasiyakaawiri inatyii tikira intzima-paaki. Iriitaki itanakyaaroni yookakaa-wintajiri ishininka-payi Israel-iiti impira-waitakari Kinawaita-niriiti.” ");
INSERT INTO prq_vpl VALUES ("JG13_24","008_13_24","JDG","13","24","24","Okanta omonkarata-paaka, tzimaki otomi iroka kooya, opaitakiri Sansón. Kamiitha ikanta ikimotatzi iinchaa-niki, itasonka-wintakiri Pawa. ");
INSERT INTO prq_vpl VALUES ("JG13_25","008_13_25","JDG","13","25","25","Okanta aparoni kitaitiri isaiki Sansón iwanko-thaantiki ishininka-mirinka Dan-iiti, anta niyaanki-thaki awotsiki jatachari Sanii-winiki irojatzi Amana-winiki, ari inampi-siritan-tanakariri Itasorinka Pawa. ");
INSERT INTO prq_vpl VALUES ("JG14_1","008_14_1","JDG","14","1","1","Ikanta ijataki Sansón nampitsiki ipaitai-tziri Antiwini, ari iñaaki aparoni kooya Kinawaitaniri-sato, inintasiryaakiro. ");
INSERT INTO prq_vpl VALUES ("JG14_2","008_14_2","JDG","14","2","2","Ikanta ipiyaaro iwankoki ikamanta-pajiri asitariri. Ikantapajiri: “Nonintzi paakainaro kooya Kinawaita-niriiti noñaakiri anta Antiwiniki.” ");
INSERT INTO prq_vpl VALUES ("JG14_3","008_14_3","JDG","14","3","3","Ikantanaki asitariri: “¿Ipaitama paantyaarori kooya Kinawaita-niriiti kaari yotakotirini Pawa? ¿Tikatsima kooya ashininka aroka-payi? ¿Tikatsima kooya aka anampiki?” Iro kantacha ikantzi irirori Sansón: “Irootaki nonintakiri ironta kooya, noninta-pirota-tziiro paakainaro.” ");
INSERT INTO prq_vpl VALUES ("JG14_4","008_14_4","JDG","14","4","4","Tira iyojiiti asitariri iriira Pawa kantakaarori omatyaa, yamina-minatatzii tsika inkinakairo iwayiritan-tyaari Kinawaitaniri-satzi impira-waita-karira Israel-iiti. ");
INSERT INTO prq_vpl VALUES ("JG14_5","008_14_5","JDG","14","5","5","Iro ijatantakari Sansón aajatzi asitariri anta Antiwiniki. Ikanta yariitzi-mataka Sansón nampitsiki, iwiraapaaka tsika ipankitai-tziro chochoki-masi, ari ikimapaakiri ikaimi kashikari, imitaa-sitakari inintzi yatsikiri. ");
INSERT INTO prq_vpl VALUES ("JG14_6","008_14_6","JDG","14","6","6","Iro kantacha ikantakaakari Sansón Itasorinka Pawa ontzimi-motiri isintsinka, yairikakiri kashikari, ikimita-kaantakiri isaraii-tziri kiripiri ipiraitari. Titzimaita inkamantiri asitariri okaratzi awisain-tsiri. ");
INSERT INTO prq_vpl VALUES ("JG14_7","008_14_7","JDG","14","7","7","Ikanta yariitaka osaiki inintakiri kooya, ikinkitha-waita-kaakiro. ");
INSERT INTO prq_vpl VALUES ("JG14_8","008_14_8","JDG","14","8","8","Okanta pasini kitaitiri, ipiyaaro Sansón yaantyaarori mainaro, ari itimpaa-painta awotsiki yamina-panaatiri kashikari iwamaakiri chapinki, iñaapaa-tziiri isaikan-takari yaarato iwatha kashikari. ");
INSERT INTO prq_vpl VALUES ("JG14_9","008_14_9","JDG","14","9","9","Yaakiri Sansón iyaaki yaarato, iriitaki ithotziri yaniitzira awotsiki. Ikanta yariita tsika isaikajiitzi asitariri, ipapaakiri iyaaki yaarato, ithotawakiri irirori. Iro kantacha ti inkamantiri iriitaki yaarato yaakiri saikanta-kariri kashikari iwamaakiri chapinki. ");
INSERT INTO prq_vpl VALUES ("JG14_10","008_14_10","JDG","14","10","10","Ari ijatzitaka aajatzi asitariri Sansón owankoki mainaro. Ari yoimosirinka-waitakari Sansón, tima irootaki yamijiitari mainariiti. ");
INSERT INTO prq_vpl VALUES ("JG14_11","008_14_11","JDG","14","11","11","Ikanta iñaakiri Kinawaita-niriiti yoka Sansón, yaanakiniri ikaratzi 30 mainariiti intsipatyaari. ");
INSERT INTO prq_vpl VALUES ("JG14_12","008_14_12","JDG","14","12","12","Ikantawakiri Sansón yokaiti mainariiti: “Tzimatsi aparoni kompitarintsi. Aririka piyotakiro omonkarata-paakyaa 7 kitaitiri noimosirinka-waityaa, aritaki nompakimi aparo-payi awirokaiti iroopirori ipiwiryaa-koitari, nompimi aajatzi okaratzi ikithaataitari yoimosirinka-jiita. ");
INSERT INTO prq_vpl VALUES ("JG14_13","008_14_13","JDG","14","13","13","Irooma airorika piyotziro kompitarintsi, awirokaiti opayitinani aparo-payi iroopirori ipiwiryaa-koitari, aajatzi okaratzi ikithaataitari karini-mankita-tsiri yoimosirinka-jiita.” Ikantajiitanaki mainariiti: “Pinkantinaro kompitarintsi, nonintzi nonkima-jiitiro.” ");
INSERT INTO prq_vpl VALUES ("JG14_14","008_14_14","JDG","14","14","14","Iroka ikantzi Sansón iñaawaitanaki: “Ipiyaaro owaritintsi yoka owantawita-chari. Ipyaaro pochari yoka tzimawita-chari isintsinka.” Okanta awisaki mawatatsiri kitaitiri, ti iyojiitiro kompitarintsi. ");
INSERT INTO prq_vpl VALUES ("JG14_15","008_14_15","JDG","14","15","15","Awisanaki pasini kitaitiri, oyotapaaka apiti kitaitiri, ikantai-takiro iina Sansón: “Pisampitiri piimi tsika okanta-kota iroka kompitarintsi. Ari onkantyaa airo notaa-kotantami piwankoki awiroka, aajatzi asitamiri. ¿Irooma pikaiman-tanari pinintzi paapitha-tinaro okaratzi nokithaatari naaka?” ");
INSERT INTO prq_vpl VALUES ("JG14_16","008_14_16","JDG","14","16","16","Jataki iroori oñiiri Sansón, irayi-mota-paakari, okantziri: “¡Ti pinintina awiroka! ¡Kisaniinta piwakina! Pikantakiri noshininka-payi iyotiro kompitarintsi. Titzimaita pinkaman-tinaro naaka opaita-rika kanta-kota-chari.” Ari yakanakiro Sansón, ikantziro: “Tima ti nonkaman-tanitiri apaa aajatzi ina, aajatzi awiroka airo nokaman-tzimiro.” ");
INSERT INTO prq_vpl VALUES ("JG14_17","008_14_17","JDG","14","17","17","Aikiro irayimo-waita-tyaari, irojatzi omonkaratan-tapaakari 7-tatsiri kitaitiri yoimosirinka-jiita, ikamantakiro kanta-kota-chari, tima oshiki oñaasirinkakiri. Jatanaki iroori okamantakiri mainariiti oshininka-payi. ");
INSERT INTO prq_vpl VALUES ("JG14_18","008_14_18","JDG","14","18","18","Okanta ontsitiniityaanaki 7-tapain-tsiri kitaitiri, jaitijiitaki Kinawaita-niriiti, ikantapaakiri Sansón: “Tikatsi anairini ipochanka yaarato, Tikatsi anairini isintsitzi aparoni kashikari.” Ikantzi irirori Sansón: “Okaminthaa nokasiyakari noinantyaaro, Irootaki piyotan-takarori kompitarintsi.” ");
INSERT INTO prq_vpl VALUES ("JG14_19","008_14_19","JDG","14","19","19","Ari ikantakaa-naari Sansón Itasorinka Pawa, tzimanaki isintsinka. Jataki ipaitai-tziro Jatashaariniki, ari iwakiri anta ikaratzi 30 atziri, yaapithatakiri iithaari-payi. Irootaki ipakiriri ikaratzi yotakirori kompitarintsi. Jataji iwankoki asitariri, oshiki owatsimaakiri okaratzi awishi-mota-kiriri. ");
INSERT INTO prq_vpl VALUES ("JG14_20","008_14_20","JDG","14","20","20","Irooma kooya ikasiya-witakari iinantyaaromi Sansón, yaakaakiro asitarori aparoni yaapatyaani Sansón. ");
INSERT INTO prq_vpl VALUES ("JG15_1","008_15_1","JDG","15","1","1","Okanta omonkara-paititaja, yawiikitan-taitarori pankirintsi, jataki Sansón yariityaaro iina, yaanaki kiripiri ipira. Ikanta yariitaka, ikanta-siritzi: “Nomaanta-wakyaaro noina.” Iro kantacha ti ininti asitarori kooya inkyaa-sitiro. ");
INSERT INTO prq_vpl VALUES ("JG15_2","008_15_2","JDG","15","2","2","Ikantakiri: “Nosiyakaantzi ti pinintajiro nosinto, iro nopanta-kariri pitsipa-minthari. Iro kantacha tzimatsi pasini awaankaro irinto, kamiithaa-niki okanta iroori, irootaki paajiri impoyiita-jyaaro irinto.” ");
INSERT INTO prq_vpl VALUES ("JG15_3","008_15_3","JDG","15","3","3","Ikantzi Sansón: “¡Tira naaka kanta-sityaaroni iroñaaka nowasankitaan-tyaariri pishininka-payi Kinawaita-niriiti!” ");
INSERT INTO prq_vpl VALUES ("JG15_4","008_15_4","JDG","15","4","4","Ikanta ipiyanaka Sansón, yamaki oshiki osiyariri kowincha, yoosoyitakiri apiti-payi itzinkoki, yoosota-kota-kiniri ootamintotsi opatziki itzinko. ");
INSERT INTO prq_vpl VALUES ("JG15_5","008_15_5","JDG","15","5","5","Yoisaiyitakiri ootamintotsi, imisiyakiri iwankiri-masiki Kinawaita-niriiti. Apirotaka otaaka iwankiri, otaaka ichochoki-masiti, maaroni. ");
INSERT INTO prq_vpl VALUES ("JG15_6","008_15_6","JDG","15","6","6","Ikanta isampita-kowintakiri Kinawaita-niriiti ipaita antakirori kantain-chari, ikimatzii ikantaitzi: “Iriitaki Sansón matakirori, iwatsimaa-tziiri irikonkiri Antiwini-satzi, tima yaapithatajiri irisinto, yaakaakiri itsipa-minthatari Sansón.” Ari ijajiitanaki Kinawaita-niriiti, itaakiro iina Sansón, aajatzi asitarori. ");
INSERT INTO prq_vpl VALUES ("JG15_7","008_15_7","JDG","15","7","7","Iro kantacha Sansón yasaryii-matakari Kinawaita-niriiti, ikantzi: “Okaratzi pantzi-mota-kinari awirokaiti, airora nokarata-kaaro naaka irojatzi napirotan-takyaamiri pikarajiitzi.” ");
INSERT INTO prq_vpl VALUES ("JG15_8","008_15_8","JDG","15","8","8","Ti ishintanaki Sansón, antaro ikisanaka, jataki imaimanitziri Kinawaita-niriiti. Tima oshiki iwamaaki. Ikanta ikaratakiro yantakiri, jataki impirita-moroki saikatsiri anta Shiwamintaaki. Ari isaikawaitzi. ");
INSERT INTO prq_vpl VALUES ("JG15_9","008_15_9","JDG","15","9","9","Ari ipokajiitanaki Kinawaita-niriiti, iwanko-thaanti-jiita-paaka iipatsitiki Judá-iti, oshiki-piro ikarajiitzi yaaritakaro iwanko-thaanti-jiita anta Tapinoitoniki. ");
INSERT INTO prq_vpl VALUES ("JG15_10","008_15_10","JDG","15","10","10","Ari isampita-wakiri Judá-iti, ikantziri: “¿Ipaitama pinintantari piwayirityaana?” Ikantajiitzi irirori: “Iri nopoka-sitzi Sansón nairikiri, nonintzi nonkisako-wintajyaa okaratzi yantzi-mota-kinari irirori.” ");
INSERT INTO prq_vpl VALUES ("JG15_11","008_15_11","JDG","15","11","11","Ikanta ikimaki Judá-iti, apatojiitanaka ikaratzi 3000 atziri, jaitijiitaki iñiiri Sansón isaiki impirita-moroki Shiwamintaaki. Ikantapaakiri Sansón: “Pimaimanita-kaantakina. ¿Tima piyoti ikimita-kaantai Kinawaita-niriiti impiratani?” Ikantzi Sansón: “Tikatsi nonkantiri naaka Kinawaita-niriiti, apatziro nokisako-winta okaratzi yantzi-mota-kinari naaka.” ");
INSERT INTO prq_vpl VALUES ("JG15_12","008_15_12","JDG","15","12","12","Ikantajiitzi iriroriiti: “Nopokajiitzi iroñaaka naanakimi isaiki Kinawaita-niriiti.” Ari ikantanaki Sansón: “Intsityaa pinkantina, airorika piwina awirokaiti.” ");
INSERT INTO prq_vpl VALUES ("JG15_13","008_15_13","JDG","15","13","13","Ikantajiitzi pokasita-kiriri: “Airo pikinkisiryaa-siwaita nopokatzii nowimi. Apatziro nonintzi naanajimi tsika isaikajiitaki Kinawaita-niriiti.” Ikanta yoosotan-takari apiti owakirari siwitha, inosikajiri tsika isaiki imanawitaka. ");
INSERT INTO prq_vpl VALUES ("JG15_14","008_15_14","JDG","15","14","14","Ikanta yariitzi-mata-kaajari Tapinoitoniki, pokajiitanaki Kinawaita-niriiti imonthaa-wakyaari Sansón, antaro ikaimajiitanaki kimosiritanaki. Iro kantacha ikantakaakaro Itasorinka Pawa, omakarata-siwaitanaka siwitha yoosotan-tawitai-takariri ishimpaki, iroowaitaki intayii-tiromi paamariki. Ari okimitakari yoosotan-tawitai-takariri irakoki. ");
INSERT INTO prq_vpl VALUES ("JG15_15","008_15_15","JDG","15","15","15","Iñaatziiro Sansón itapinoma ikyaakoitari, ainiro onaatzirotzi, yaakiro. Irootaki iwamaan-takari oshiki Kinawaita-niriiti. ");
INSERT INTO prq_vpl VALUES ("JG15_16","008_15_16","JDG","15","16","16","Ikantanaki: “Iro itapinoma ikyaakoitari nomatantaka oshiki. Irojatzi itapinoma ikyaakoitari nowamaantaka ikaratzi 1000 atziri.” ");
INSERT INTO prq_vpl VALUES ("JG15_17","008_15_17","JDG","15","17","17","Ikanta ikaratakiro iñaawaitaki, imanaitakiro itapinoma ikyaakoitari. Ari ipaitanakiro anta Tapinoitoni. ");
INSERT INTO prq_vpl VALUES ("JG15_18","008_15_18","JDG","15","18","18","Tima ayimatakiri imiri Sansón, ikowa-kotakiri Pawa, ikantziri: “Awiroka matakaa-kinarori noitsinampaan-tantakari, ¿kamiithama pisinitina nonkami ayina nomiri? ¿Pisinita-tyiinama imaimani-waitina yokaiti kaari yotimini Pawa?” ");
INSERT INTO prq_vpl VALUES ("JG15_19","008_15_19","JDG","15","19","19","Ikantakaakaro Pawa, sitowaatanaki nijaa omoro-nakiki anta Tapinoitoniki. Ikanta ikaratakiro iraki nijaa sintsitanaji Sansón. Irootaki ipaitan-taitarori Inijaati Kowakotan-tatsiri. ");
INSERT INTO prq_vpl VALUES ("JG15_20","008_15_20","JDG","15","20","20","Tima ijiwatakiri Sansón Israel-iiti okaratzi 20 osarintsi, impira-waitan-tariri Kinawaita-niriiti anta. ");
INSERT INTO prq_vpl VALUES ("JG16_1","008_16_1","JDG","16","1","1","Ikanta ijataki Sansón Sintsi-winiki. Ari iñaakiro aparoni mayimpiro, ikyaa-sitakiro tsitiniri owankoki imaantyaaro. ");
INSERT INTO prq_vpl VALUES ("JG16_2","008_16_2","JDG","16","2","2","Ikanta ikimajiitaki Sintsi-wini-satzi, ikantaitzi: “Ari ipokiri Sansón anampiki.” Pokajiita-paaki ikarajiitzi ithonka itzikapaakiri pankotsiki airo isitowanta, yaakowintakaro tsitini-paiti iyaawintari isitowa-piintai-tzira nampitsiki, ikantajiitzi: “Ari oyaawintyaari aka. Aririka añaawakiri onkitaititzi-matanaki, ari awiriri.” ");
INSERT INTO prq_vpl VALUES ("JG16_3","008_16_3","JDG","16","3","3","Iro kantacha yoka Sansón ti imaapiroti, piriintanaka niyaankiiti tsitiniri, jataki tsika ikyaa-piintaitzi, itatsinka-nakiro asitako-rontsi, ithopaa-kotakiro otzinkamitari. Yanatanakiro, yaanakiro tonkaariki otzisiki omontitakari nampitsi Aripirotaarini. ");
INSERT INTO prq_vpl VALUES ("JG16_4","008_16_4","JDG","16","4","4","Ikanta iñaaki Sansón pasini kooya paitachari Dalila, inintakiro. Iroka kooya onampitaro otaapiki ipaitai-tziro Shookaroni. ");
INSERT INTO prq_vpl VALUES ("JG16_5","008_16_5","JDG","16","5","5","Ari ijajiitaki ijiwariti Kinawaita-niriiti iñiiro Dalila, ikantakiro: “Pamatawitiri Sansón, pinkowa-kotiri opaita isintsitantari, tsika ankantiri aitsinampaan-tyaariri. Onkini oosotiri, airo apakaajiri. Aririka pimatakiri, oshiki kiriiki nompinatimiri.” ");
INSERT INTO prq_vpl VALUES ("JG16_6","008_16_6","JDG","16","6","6","Okanta Dalila osampitakiri Sansón, okantziri: “Pinkamantina, ¿tsikatyaa nonkantimika noosotimi airo posiryaa-kotanta? Aririka noninti noosotimi, airo poosoryaako-tzimaita.” ");
INSERT INTO prq_vpl VALUES ("JG16_7","008_16_7","JDG","16","7","7","Yakanakiro Sansón ikantziro: “Aririka yoosotan-taityaanaro owakirari osiwithati piyaamini onkarati 7, airo otzimanaji nosintsinka nonkimityaari pasini-payi atziri kaari tzimatsini isintsinka.” ");
INSERT INTO prq_vpl VALUES ("JG16_8","008_16_8","JDG","16","8","8","Ikanta ijiwariti-payi Kinawaita-niriiti yaanakiniro Dalila owakirari osiwithati piyaamini okaratzi 7, iro oosowitan-takariri Sansón. ");
INSERT INTO prq_vpl VALUES ("JG16_9","008_16_9","JDG","16","9","9","Tima omanaki Dalila omaapiintzi oshininka-payi, ari okaima-kotziri okantziri: “¡Sansón! ¡Yairika-tyiimi Kinawaita-niriiti!” Iro kantacha Sansón itzimpisa-nakiro yoosowitai-tanta-kariri, ikimita-kaantakiro ti onkisoti makarathataki. Ti iyojiiti Kinawaita-niriiti tsika opoñaaro isintsitantari Sansón. ");
INSERT INTO prq_vpl VALUES ("JG16_10","008_16_10","JDG","16","10","10","Opoñaa okantajiri Dalila yoka Sansón: “¡Pamatawitakina! ¡Ipaita pisiyakaan-tziri! Pinkamantina tsika nonkantyaa noosotan-tyaamiri.” ");
INSERT INTO prq_vpl VALUES ("JG16_11","008_16_11","JDG","16","11","11","Ikantzi Sansón: “Aririka yoosotan-taityaanaro sintsiini owakirari siwitha tikira yoosotan-taitaro, ari ompyaanakyaa nosintsinka, nonkimita-nakyaari atziri kaari tzimatsini isintsinka.” ");
INSERT INTO prq_vpl VALUES ("JG16_12","008_16_12","JDG","16","12","12","Okanta Dalila aaki owakirari siwitha ikantakirori Sansón, oosotan-takari. Ipoñaa okaima-kotziri okantzi: “¡Sansón, yairika-tyiimi Kinawaita-niriiti!” Apiiwitakaro omanaki oshininka-payi omaapiintzi. Itzimpisa-najiro Sansón oosowitan-takariri, ikimita-kaantakiro kiripithami onatyii siwitha. ");
INSERT INTO prq_vpl VALUES ("JG16_13","008_16_13","JDG","16","13","13","Okantziri Dalila yoka Sansón: “¡Aikiro pijatatzii pamatawitana! ¡Pinkamantina tsika onkantyaa noosotan-tyaamiri!” Iyomitaakiro Sansón, tsika onkantiri Dalila, ikantziro: “Pampithatiro noisi pintsipataakiro kirithari onkarati 7 pampithatakiro. Piwatzikaki inchaki, ari poosotirori noisi. Aritaki ompyaanakyaa nosintsinka nonkimita-nakyaari ikanta pasini atziri.” ");
INSERT INTO prq_vpl VALUES ("JG16_14","008_16_14","JDG","16","14","14","Ikanta imaanaki Sansón, ampithata-kiniri Dalila iisi otsipataakiro okaratzi 7 kirithari. Owatzikaki inchaki, oosotakiro iisi, okaimako-tzimaitari: “¡Sansón, yairika-tyiimi Kinawaita-niriiti!” Ikanta isaakitanaki Sansón, ithopaa-nakiro owatzika-witakari inchaki tsika oosowitakaro iisi. ");
INSERT INTO prq_vpl VALUES ("JG16_15","008_16_15","JDG","16","15","15","Ari apiitanajiri Dalila okantziri Sansón: “¡Thaiyawaari pinatzii! ¿Ipoñaa pikanta-piintana pinintana? Tima mawataki pamatawitakina, ti pininti pinkantina. Nonintzi noyoti tsika opoñaa pisintsitantari.” ");
INSERT INTO prq_vpl VALUES ("JG16_16","008_16_16","JDG","16","16","16","Oshiki osampi-sampitakiri Dalila, ti owashaanta-paintiri kapichiini osampitziri, oñaasirinkakiri Sansón, inintaki inkama-pithatiro. ");
INSERT INTO prq_vpl VALUES ("JG16_17","008_16_17","JDG","16","17","17","Okanta apaata Sansón, ikamantakiro Dalila, ikantakiro: “Tira namiita-nitiro noisi, tima pairani tikira notzima-paaki, okasiya-kaakari asitanari yasityaana Pawa, Kasiyakaawiri nonatyii. Aririka yamiitaitina, airo nosintsitanaji, nonkimita-nakyaari kaari sintsita-tsini.” ");
INSERT INTO prq_vpl VALUES ("JG16_18","008_16_18","JDG","16","18","18","Ari oyotanaki Dalila ti yamatawitiro iroñaaka Sansón, okaimakaan-takiri ijiwari Kinawaita-niriiti, okantziri: “¡Pimpoka-jiiti, tima ikamanta-kinaro iroñaaka Sansón!” Ikanta ipokajiitaki Kinawaita-niriiti yaanakiri iiriikiti. ");
INSERT INTO prq_vpl VALUES ("JG16_19","008_16_19","JDG","16","19","19","Okantajiri Dalila imayi Sansón intzii-tota-kyaaro oporiki. Ari okaimaki amiitirini iisiki, onkarati 7 yampitaisiro intotaitiri. Arira itanakari iroñaaka omaimanitziri. ");
INSERT INTO prq_vpl VALUES ("JG16_20","008_16_20","JDG","16","20","20","Okaima-kotakiri, okantziri: “¡Sansón, yairika-tyiimi Kinawaita-niriiti!” Ari isaakiwitanaja Sansón, isiyakaantaki airo yiitsinampai-tziri ikimita-piinta-witaro, ti iyoti yooka-nakiri Pawa. ");
INSERT INTO prq_vpl VALUES ("JG16_21","008_16_21","JDG","16","21","21","Ari ipokajiita-paaki Kinawaita-niriiti yairika-paakiri, ikithoryii-takiri irooki yaitanakiri nampitsiki Sintsi-winiki, yoosotan-taitakari asirotha kitiriri, yaitanakiri yantawaiti isaikayitzi asita-kotaari, ari isintsiwintai-tziri intononki pankirintsi-pani iwitsikaitiri yatantaitani. ");
INSERT INTO prq_vpl VALUES ("JG16_22","008_16_22","JDG","16","22","22","Iro kantacha itanaaro osanthatanaji iisi. ");
INSERT INTO prq_vpl VALUES ("JG16_23","008_16_23","JDG","16","23","23","Ari yapatojiitaka ijiwari Kinawaita-niriiti yoimosirinkyaa yiitsinampaakiri Sansón, inintzi impomitiniri yatsipita-kaani iwawa-niroti Kyaatsi. Iroka ikantzi ipanthaa-jiitzi: “Iriira awawani sinitakairi akisaniintani Sansón.” ");
INSERT INTO prq_vpl VALUES ("JG16_24","008_16_24","JDG","16","24","24","Ikanta iñaajiitakiro atziri-payi, imatanakiro irirori ipanthai, itharowinta-wintari iwawa-niroti, ikantajiitzi: “Iriitaki awawani sinitakairiri aisaniintani Sansón, Iriitaki iriipiro-witachari iyaaripirotzi-tairo awankiri, Iwamaaki oshiki ashininka-payi.” ");
INSERT INTO prq_vpl VALUES ("JG16_25","008_16_25","JDG","16","25","25","Okanta ikimo-siri-jiitanaki, ikantajiitaki: “Pamakiri Sansón asironta-mintha-waityaari.” Ikanta yaita-paintziri Sansón isaikira tsika yasitakoi-tziri, oshiki isironta-winta-waitakari. Ikanta ikaratakiro isironta-winta-waitakari, ikatziyakiri okatziyaka apiti otzinkami pankotsi. ");
INSERT INTO prq_vpl VALUES ("JG16_26","008_16_26","JDG","16","26","26","Ikanta iñaakiro Sansón oshiki isirontzita-winta-waitai-takari, ikantanakiri mainari akathata-kiriri: “Pisirinkina tsika okatziya-yitaka otzinkamiki karapapanko nairikiro. Nonintzi nontzityaaro.” ");
INSERT INTO prq_vpl VALUES ("JG16_27","008_16_27","JDG","16","27","27","Ari ipiyojiitakani oshiki ijiwari Kinawaita-niriiti karapapankoki, piyotaka aajatzi oshiki atziri-payi sirampari aajatzi kooya. Tzimitacha atziri jinoki pankotsi ikaratzi 3,000, iriitaki amina-minthatziri isironta-minthai-tarira Sansón. ");
INSERT INTO prq_vpl VALUES ("JG16_28","008_16_28","JDG","16","28","28","Ari yamanairiri Sansón, ikantzi: “¡Pawá Sintsi-pirori, apatziro nonintzi piwiraantyaaro pinkisa-wintyaana! Tima oshiki ithainka-mawaitakina Kinawaita-niriiti ikithoryaakiro apitiroiti noki, nonintzi iroñaaka Pawa pinkanta-kaiyaaro ontzimi-motina nosintsinka, nonkisa-winta-wajyaata.” ");
INSERT INTO prq_vpl VALUES ("JG16_29","008_16_29","JDG","16","29","29","Ikanta ikaratakiro ikowa-kotakiri Pawa, itzitanakaro apitira otzinkami otzitzirori maaroni pankotsi, ");
INSERT INTO prq_vpl VALUES ("JG16_30","008_16_30","JDG","16","30","30","ikaimanaki sintsiini, ikantzi: “¡Ari inkaratina naaka maaroni Kinawaita-niriiti inkami!” Itatsinka-maita-nakaro sintsiini tzinkamitsi, tyaanaki pankotsi anawyaa-paakiri atziri-payi piyotain-chari. Oshiki ikaratzi iwamaaki Sansón, anaanakiro ikaratzi iwamaa-piintakiri ainiro yañaawita. ");
INSERT INTO prq_vpl VALUES ("JG16_31","008_16_31","JDG","16","31","31","Ikanta ipokajiitaki iririntzi-payi Sansón itsipayitakari ikaratzi ishininka-yitari, yaitanajiri, inkitaitiri tsika ikitaita-kirira pairani Manoa, iriri Sansón, anta Sanii-winiki otsipa-nampitari Amanawiniki. Tima yoka Sansón osamani ijiwatakiri ishininka Israel-iiti okaratzi 20 osarintsi. ");
INSERT INTO prq_vpl VALUES ("JG21_25","008_21_25","JDG","21","25","25","Pairani tikira intzimanaki iriipirori iwinkathariti Israel-iiti, yantasi-yitakaro aparo-payi okaratzi inintayi-tziri.");
INSERT INTO prq_vpl VALUES ("S11_1","010_1_1","1SA","1","1","1","Tzimatsi pairani aparoni atziri nampitarori kiriinka Apitonkaironiki, iriitaki icharini Yaaratowini-satzi saikatsiri iipatsitiki Efraín-iti. Yoka atziri ipaita Elcana. Itomi Jeroham, icharini Eliú, asitaririni Eliú ipaita Tohu, asitaririni Tohu ipaita Zuph, ikantai-tziri aajatzi Yaarato. Iriitaki ishininka Efraín-iti. ");
INSERT INTO prq_vpl VALUES ("S11_2","010_1_2","1SA","1","2","2","Apiti okaratzi iina Elcana. Opaita Ana pasini opaita Penina. Waiyantaniro onatzii iroori Penina, irooma Ana ti owaiyan-taniti. ");
INSERT INTO prq_vpl VALUES ("S11_3","010_1_3","1SA","1","3","3","Ari ikanta-piintatyaa osarintsiki-payi Elcana, ipoñaaro inampiki irirori ijatziro tonkaariki nampitsiki Makoryiironi ipinkatha-tziri Ñaapirori Pawa, ipomitziniri yatsipi-takaani. Ari isaikiri anta itomi-payi Impira-tasorintsi-taari paitachari Elí, apiti ikaratzi, ipaita Ofni, pasini ipaita Finees. Impira-tasorintsiti inatzi Pawa. ");
INSERT INTO prq_vpl VALUES ("S11_4","010_1_4","1SA","1","4","4","Okanta omonkarata-piinta kitaitiri ipomitan-tariri Elcana yatsipi-takaani, yasitakaaro kapichiini iina Penina, ari ikimi-tzitari iwaiyani-payi yasitakaari kapichiini irirori-payi. ");
INSERT INTO prq_vpl VALUES ("S11_5","010_1_5","1SA","1","5","5","Irooma Ana ininta-pirotani onatzii irirori, yasitakaaro kamiitha-tatsiri, okantawitaka ti inkanta-kaiyaaro Pawa intzimi owaiyani. ");
INSERT INTO prq_vpl VALUES ("S11_6","010_1_6","1SA","1","6","6","Irootaki okisantari iroori Penina, okisawai-tziro Ana, owaasikyaa-waitziro ti inkanta-kaiyaaro Pawa owaiyanti. ");
INSERT INTO prq_vpl VALUES ("S11_7","010_1_7","1SA","1","7","7","Ari okanta-piintatyaa Penina osarintsiki, aririka ojati itasorintsi-pankotiki Pawa, okisa-niinta-waitziro. Irootaki iraawai-tantari Ana, ti owanajyaa. ");
INSERT INTO prq_vpl VALUES ("S11_8","010_1_8","1SA","1","8","8","Ari isampitakiro oimi, ikantziro: “¡Ana! ¿Paitama piraantari? ¿Paitama piwasiri-tantari kaari piwanta? ¿Tima naaka pasi awiroka anairi intzimimi 10 atomi?” ");
INSERT INTO prq_vpl VALUES ("S11_9","010_1_9","1SA","1","9","9","Okanta apaata anta Makoryiironiki, owakira apakaakiro owawaita Ana, iraki omiri aajatzi, okatziyanaka. Ari ithointakari Ompira-tasorintsi-taari Elí saika-mintotsiki ikyaa-piintai-tzira itasorintsi-pankotiki Pawa. ");
INSERT INTO prq_vpl VALUES ("S11_10","010_1_10","1SA","1","10","10","Oshiki okantzimo-siri-takaro Ana, ayimatakiro oshinka, amananakiri Pawa. ");
INSERT INTO prq_vpl VALUES ("S11_11","010_1_11","1SA","1","11","11","Okantzi: “¡Ñaapirori Pawá! Pinisironka-tajyaana, tima naaka pimpiratani, airo piwasinonkaana, nonintatzii intzimaji aparoni notomi. Iriitaki nasitakai-yaamiri awiroka, yantajimiro okaratzi pinintziri. Iroka iyoitan-tyaariri awiroka nasitakaari, tima airo nototziniri iisi.” ");
INSERT INTO prq_vpl VALUES ("S11_12","010_1_12","1SA","1","12","12","Osamani okantaka Ana amaniri Pawa, yamina-mintha-takiro Elí opaantiki. ");
INSERT INTO prq_vpl VALUES ("S11_13","010_1_13","1SA","1","13","13","Tima amana-siri-tatzii iroori, tikatsi kimironi oñaawaiti, oshiwa-chira-tasita. Isiyakaantzi Elí osinkitatyaa Ana. ");
INSERT INTO prq_vpl VALUES ("S11_14","010_1_14","1SA","1","14","14","Ikantanakiro: “¿Tsika-paitima awishimotimi pisinkiro? ¡Aritapaaki pirakiro kipishaari!” ");
INSERT INTO prq_vpl VALUES ("S11_15","010_1_15","1SA","1","15","15","Ari akanakiri Ana, okantziri: “¡Jiwarí. Ti ari onkantyaa! Tikatsi niri, ti nosinkityaa. Nosiri-piro-tatyaari naaka Pawa, okantakaan-tziro ayimawaitana nowasirinka. ");
INSERT INTO prq_vpl VALUES ("S11_16","010_1_16","1SA","1","16","16","Airo pikinkithasiri-waitasita pinkanti: ‘Kaari-pirori onatzii iroka kooya’, naakowinta-taaro namani, tima tzimatsi kantzimo-siri-waita-kanari, antaro nowasiri-waitaka.” ");
INSERT INTO prq_vpl VALUES ("S11_17","010_1_17","1SA","1","17","17","Ari yakanakiro Elí, ikantanakiro: “¡Pijataji kamiitha! Onkamintha imatimiro Iwawani Israel okaratzi pikampi-takiriri.” ");
INSERT INTO prq_vpl VALUES ("S11_18","010_1_18","1SA","1","18","18","Okantzi iroori: “¡Ariwí Jiwarí! Onkamintha omatyaa okaratzi pikanta-kinari.” Jataji Ana tsika opoñaakaro, owawaitapaja kamiitha, ti owasiri-waita-pajyaa. ");
INSERT INTO prq_vpl VALUES ("S11_19","010_1_19","1SA","1","19","19","Okanta apaata opiriinta-manaka kapichikitaiti, aritaki apakaakiro amana-manairi Pawa. Piyaja Tonkaironiitoniki osaikira owanko. Ari imaantakaro oimi. Imatakiro Pawa okaratzi okowako-takiriri. ");
INSERT INTO prq_vpl VALUES ("S11_20","010_1_20","1SA","1","20","20","Motyaataki Ana. Okanta apaata owaiyan-takiri otomi. Ari okantanaki “Iriitaki nokampi-takiriri Pawa.” Irootaki owaitakaan-tziriri otomi “Kamitaantsi”. Tima iroka wairontsi Kamitaantsi, irootaki ikantziri iñaaniki iriroriiti “Samuel”. ");
INSERT INTO prq_vpl VALUES ("S11_21","010_1_21","1SA","1","21","21","Ikanta Elcana, yapiitajiro itonkaji nampitsiki, ari yaanakiro iina tzimatsiri owaiyani-payi yantiro okaratzi yamita-piintari ipomitziniri Pawa yatsipi-takaani. ");
INSERT INTO prq_vpl VALUES ("S11_22","010_1_22","1SA","1","22","22","Ti ojati iroori Ana, tima okantakiri oimi: “Airo nojatzi naaka nookakaa-wakiriita nothotairi iintsi. Inkini naanakiri nasitakai-yaari Pawa, irasi iwiro isaiki anta airo ipiyaja.” ");
INSERT INTO prq_vpl VALUES ("S11_23","010_1_23","1SA","1","23","23","Ari ikantanakiro oimi: “Pantiro okaratzi kamiitha-tzimo-tzimiri awiroka. Aritaki pisaikawaki pookakaa-wakiri pithotairi iintsi. Onkamintha imatiro Pawa okaratzi inintakiri yantiri.” Aritaki okantaka, ti ojati Ana. Irojatzi ikimotan-takari intsiti, ookakaakiri ithotzi othomi. ");
INSERT INTO prq_vpl VALUES ("S11_24","010_1_24","1SA","1","24","24","Tima aritaki ookakaakiri intsiti ithotzi, ainiro iyaanitzi irirori, aanakiri Makoryiironiki osaiki itasorintsi-pankoti Pawa. Aanaki mawa kiripiri vaca, aanaki opani pankirintsi, aajatzi iraitziri owantakari misinantsi-naki. ");
INSERT INTO prq_vpl VALUES ("S11_25","010_1_25","1SA","1","25","25","Ikanta opomitakiri kiripiri vaca, aanakiri otomyaa-niki isaikaki Elí. ");
INSERT INTO prq_vpl VALUES ("S11_26","010_1_26","1SA","1","26","26","Okantapaakiri Ana: “¡Jiwarí! Omapiro-tatyaa nonkantimiri. Naakataki kooya piñaaki pairani namaniri Pawa aka. ");
INSERT INTO prq_vpl VALUES ("S11_27","010_1_27","1SA","1","27","27","Oshiki namanaki intzimi notomi, imatakinaro Pawa nokowakotakiriri. ");
INSERT INTO prq_vpl VALUES ("S11_28","010_1_28","1SA","1","28","28","Iriitaki nasitakai-yaariri, irasi iwatyiiro yasityaari Pawa ainiro yañii aka kipatsiki.” Ari ityiirowanaka ipinkatha-tanakiri Pawa. ");
INSERT INTO prq_vpl VALUES ("S12_18","010_2_18","1SA","2","18","18","Iriima iintsi Samuel, aikiro ijatakaa-tziiro yantayi-tziro inintziri Pawa. Ikithaata-piintaro yapitisamaatari karini-manki-tatsiri. ");
INSERT INTO prq_vpl VALUES ("S12_19","010_2_19","1SA","2","19","19","Ari okanta-piintatyaa osarintsiki ontyiiniri iriniro yanini kithaarintsi, irootaki aminiriri, aririka ompoki tonkaariki otsipatari oimi antziro amita-piintari opomitziri atsipita-kaani. ");
INSERT INTO prq_vpl VALUES ("S12_20","010_2_20","1SA","2","20","20","Tima oshiki yamanakota-piintziri Elí yoka Elcana aajatzi Ana intasonka-wintai-tantyaariri, ikantzi yamani: “Onkamintha inkanta-kaiyaaro Pawa intziman-tyaari pasini pitomi-payi, piwaiyan-takairo piina, impoyii-tajyaarini pasitakaa-kariri Pawa.” Ikanta okaratakiro opinkatha-takiri Pawa, opiya-maitaja owankoki. ");
INSERT INTO prq_vpl VALUES ("S12_21","010_2_21","1SA","2","21","21","Ari ikantakaakaro Pawa omotyaataji Ana. Itzimaji mawa otomi, apiti osinto. Iriima Samuel aikiro ijatatzii ikimotatzi, kamiitha ikanta isaikimo-tziri Pawa. ");
INSERT INTO prq_vpl VALUES ("S13_19","010_3_19","1SA","3","19","19","Aikiro ikimota-tatzii Samuel, itsipatani iwiri Pawa, ikantakaakaro omatayityaa okaratzi ikantziri Samuel. ");
INSERT INTO prq_vpl VALUES ("S13_20","010_3_20","1SA","3","20","20","Tima ithonkaa ikimakoi-tanakiri Samuel, iriitaki iriipiro-tatsi ikamantan-takiro inintakiri Pawa. Ikimaki maaroni Israel-iiti, tima ikimaitaki intaina iipatsitiki Dan-iti aajatzi anta Kanta-piro-jaariki. ");
INSERT INTO prq_vpl VALUES ("S13_21","010_3_21","1SA","3","21","21","Ari yapiita-jirori Pawa iñaakaari Samuel anta Makoryiironiki, ari ikamanta-piinta-kiriri iñaani. ");
INSERT INTO prq_vpl VALUES ("S18_1","010_8_1","1SA","8","1","1","Aritaki antaripiro-tapaaki Samuel, iwakiri itomi-payi ijiwatairi ishininka-payi. ");
INSERT INTO prq_vpl VALUES ("S18_2","010_8_2","1SA","8","2","2","Itarori itomi, ipaita Joel, pasini ipaita Abías. Tima jiwari inaki apitiro nampitsiki Kanta-piro-jaari. ");
INSERT INTO prq_vpl VALUES ("S18_3","010_8_3","1SA","8","3","3","Titzimaita isiya-kota-jiityaari asitariri, oshiki imasitha-waitaki, iniwiki-takari kiriiki, ti intampatzika-siriti. ");
INSERT INTO prq_vpl VALUES ("S18_4","010_8_4","1SA","8","4","4","Irootaki yapatotan-takari maaroni antari-kona-payi Israel-iiti, pokajiitaki Tonkaironiitoniki iñiiri Samuel. ");
INSERT INTO prq_vpl VALUES ("S18_5","010_8_5","1SA","8","5","5","Ikantapaakiri: “¡Jiwarí! Antaripiro-tapaakimi awiroka, ti isiyako-tajyaamiro pitomi-payi. Ontzimatyii pamini iriipirori pinkathari-winta-jinani, ikimitai-tziro pasiniki nampitsi tzimatsi iriipirori iwinkathariti.” ");
INSERT INTO prq_vpl VALUES ("S18_6","010_8_6","1SA","8","6","6","Ti onimota-nakiri Samuel ikantai-takiri yamini iriipirori pinkathari-wintan-taatsini. Yamananakiri Pawa. ");
INSERT INTO prq_vpl VALUES ("S18_7","010_8_7","1SA","8","7","7","Ari yakakiri Pawa, ikantziri: “Pimatiro inintako-tzimiri pishininka-payi. Ti awiroka imanintaiti, naaka imanintaitzi, tima ti ininti nompinkathari-wintajiri. ");
INSERT INTO prq_vpl VALUES ("S18_8","010_8_8","1SA","8","8","8","Ti yookiro ikanta pairani namantaariri Apitantoniki, irojatzi ikantziro yantayi-tziro inintasi-yitari irirori. Ti imiraawintina, apatziro ipinkatha-waita-sitari isiyakaaro pawaniro-payi. Ari ikantzi-takamiri awiroka. ");
INSERT INTO prq_vpl VALUES ("S18_9","010_8_9","1SA","8","9","9","Pimatiniri okaratzi ikowako-takimiri. Iro kantacha, ontzimatyii pisintsi-thata-wakiri, pinkantiri: ‘¡Ari piñaa-mai-takyaaro tsika inkanta-paakimi pinkathari-wintimini!’ ” ");
INSERT INTO prq_vpl VALUES ("S18_10","010_8_10","1SA","8","10","10","Imatakiro Samuel, ikamantakiri ishininka-payi iñaani Pawa ikowako-takiri yamini pinkathari-winta-jirini. ");
INSERT INTO prq_vpl VALUES ("S18_11","010_8_11","1SA","8","11","11","Ikantziri: “Iroka inkantyaa pinkathari-winta-jimini. Yaapaakiri pitomi-payi, intitakiri siyako-mintotsiki iyomitairi iwayirityaa, pasini inkyaa-kotanakyaari ipira-payi, iriima pasini iriitaki aamaako-wintyaarini. ");
INSERT INTO prq_vpl VALUES ("S18_12","010_8_12","1SA","8","12","12","Pasini iwakiri iriipiro inkantyaa ijiwariti, iriitaki jiwatajirini oshiki owayiri, iriima pasini inampiri-payi inatyii. Inkaimaki pankiwai-tatsini, iyoyaayi-tajiro iwankiri, pasini witsika-tsini iwayiri-minto, pasini witsika-tsini inkasiya-kairori isiyako-minto-payi iwayiri-tantari. ");
INSERT INTO prq_vpl VALUES ("S18_13","010_8_13","1SA","8","13","13","Yaanakiro aajatzi pisinto-payi yantawai-takairo, owitsika-yitiro kasanka-yitatsiri, pasini kotsiwai-tatsini, pasini amiroka-pitha-tironi iwariti. ");
INSERT INTO prq_vpl VALUES ("S18_14","010_8_14","1SA","8","14","14","Ari yasitapaa-kyaaro iroopirori pipatsiti, piwankiri-masi, aajatzi paapiintziri oyiinka. Impayitakiri inampiri-payi irirori. ");
INSERT INTO prq_vpl VALUES ("S18_15","010_8_15","1SA","8","15","15","Aririka oshookanaki piwankiri yatantaitari, isintsiwinta-piintajimi pimpiri kapichiini irirori. Ari inkimi-tzi-tyaamiri aririka oshookanaki okaratzi pajiri pirajiri, ");
INSERT INTO prq_vpl VALUES ("S18_16","010_8_16","1SA","8","16","16","Yasitajyaari pimpiratani-payi, sirampari aajatzi kooya. Yayiri iriipirori pipira pikyaakaa-piintziri tinari, yantawai-takairi irirori. ");
INSERT INTO prq_vpl VALUES ("S18_17","010_8_17","1SA","8","17","17","Aririka intzimi pipira-payi, isintsiwintajimi pimpiri aparoni-payi. Imatzita-jiityaami awirokaiti impira-jiityaami. ");
INSERT INTO prq_vpl VALUES ("S18_18","010_8_18","1SA","8","18","18","Airo ikisako-wintaami apaata Pawa tsika-rika inkanta-paakimi iriipirori pinkathari pinintakiri, onkanta-wityaa piraawai-jiityaa.” ");
INSERT INTO prq_vpl VALUES ("S18_19","010_8_19","1SA","8","19","19","Titzimaita inkimajiiti ishininka-payi Samuel ikantawi-tariri, ikantajiitzi: “Onkanta-wityaa, nonintzi intzimi iriipirori nowinkathariti. ");
INSERT INTO prq_vpl VALUES ("S18_20","010_8_20","1SA","8","20","20","Tima nonintatzii nosiyaari pasini-satzi atziri itzimi iwinkathariti, iriitaki jiwayitziriri iwayirita.” ");
INSERT INTO prq_vpl VALUES ("S18_21","010_8_21","1SA","8","21","21","Ikimakiri Samuel okaratzi ikantakiri ishininka-payi. Irootaki ikamanta-kiriri irirori Pawa. ");
INSERT INTO prq_vpl VALUES ("S18_22","010_8_22","1SA","8","22","22","Ikantzi Pawa: “Pantiniri inintziri, pamini pinkathari-wintirini.” Imatakiro Samuel, ikantairi ishininka-payi: “Pimpiya-yitaji pinampiki.” ");
INSERT INTO prq_vpl VALUES ("S19_1","010_9_1","1SA","9","1","1","Tzimatsi ishininka Benjamín-iti ipaita Cis, itomi Abiel, icharini Zeror, tomitariri Zeror ipaita Becorat, tomitariri Becorat ipaita Afía, itomi ishininka-payi Benjamín-iti. Yoka Cis iriipirori inatzi. ");
INSERT INTO prq_vpl VALUES ("S19_2","010_9_2","1SA","9","2","2","Tzimatsi itomi, kamiitha ikanta imainaritzi, ipaita Saúl. Ti intzimi pasini ishininka siyaarini yoka mainari, antari-tawato ikatziya tikatsi anairini. ");
INSERT INTO prq_vpl VALUES ("S19_3","010_9_3","1SA","9","3","3","Okanta apaata, ipyaa-pitha-takari ipira Cis. Ikantakiri itomi: “¡Saúl! Pintsipa-tanakyaari ompiratani, pijati paminaatiri apira.” ");
INSERT INTO prq_vpl VALUES ("S19_4","010_9_4","1SA","9","4","4","Jatanaki Saúl yaminairi ipira, yawisanakiro otzisi-masi iipatsiti Efraín-iti, ariitaka Mawaariniki, titzimaita iñaajiri ipira. Yawisanakiro Kowinchawini, ti iñiiri aajatzi anta. Ikanta ikinapajiro iipatsitiki Benjamín-iti, ti iñiiri aajatzi anta. ");
INSERT INTO prq_vpl VALUES ("S19_5","010_9_5","1SA","9","5","5","Ariitaka Yaarato-winiki, ikantakiri impiratani: “Thami ampiyi, kimitaka oshiki okantzi-motakari asitanari iñaakiro ti ampiyaji, anaanakiro okantzi-motari ipyaaka nopira.” ");
INSERT INTO prq_vpl VALUES ("S19_6","010_9_6","1SA","9","6","6","Yakanakiri impiratani, ikantziri: “Tzimatsi itomiyaayi Pawa aka nampitsiki, oshiki ipinkathai-tziri. Okaratzi ikantziri irirori, aritaki omatakyaa. Thami añaapaintiri, iriitaki kantawa-kaini tsika ankini aminairi pipira.” ");
INSERT INTO prq_vpl VALUES ("S19_7","010_9_7","1SA","9","7","7","Ikantzi Saúl: “Thami. Iro kantacha, ¿Paitama aanakiniriri? Athonka-kiro awariti. Tikatsi ampapaa-kiriri.” ");
INSERT INTO prq_vpl VALUES ("S19_8","010_9_8","1SA","9","8","8","Ikantzi impiratani: “Tzimatsi aparoni noiriikiti. Iriitaki ampinatiriri itomiyaayi Pawa iñaakan-tairori tsika ankini.” ");
INSERT INTO prq_vpl VALUES ("S19_9","010_9_9","1SA","9","9","9","(Pairani, yamitari Israel-iiti aririka ininti ijati inkampitiri Pawa, ikantzi: “Thami añiiri ñaawyataniri”, iriitaki ipaitai-tziri iroñaaka “Kamantan-tzinkari”, pairani ipaitai-tziri “ñaawyataniri”.) ");
INSERT INTO prq_vpl VALUES ("S19_10","010_9_10","1SA","9","10","10","Ikantzi Saúl: “Thami añiiri.” Jatanaki nampitsiki iñiiri itomiyaayi Pawa. ");
INSERT INTO prq_vpl VALUES ("S19_11","010_9_11","1SA","9","11","11","Ikanta itonkaa-jiitzi ijatziro nampitsiki, imonthaakaro mainaro-payi ayi nijaa, isampitawakiro, ikantziro: “¿Arima isaiki aka ñaawyataniri?” ");
INSERT INTO prq_vpl VALUES ("S19_12","010_9_12","1SA","9","12","12","Okantajiitzi iroori: “Jii, aritaki isaiki. Pijatanaki sintsiini ari pimonthaa-kyaari ipoki irirori ikaimakaan-tziri noshininka-payi impomitiniri yatsipi-takaani karapapankoki. ");
INSERT INTO prq_vpl VALUES ("S19_13","010_9_13","1SA","9","13","13","Aririka pariita-paakyaa nampitsiki, pamina-mina-tapaakiri, tikira ijatanaki tonkaariki karapapankoki iyaa. Tima airo iwitajiita ashininka-payi airorika yariita irirori. Iriitaki paasoonki-wintirini iyaari tzimaraanta-tsiri ipomitani yatsipi-takaani, yakyootiri ikaratzi ikaimayi-takiri. Pisintsiti pijati, aritaki piñaapaakiri.” ");
INSERT INTO prq_vpl VALUES ("S19_14","010_9_14","1SA","9","14","14","Aikiro itonkajiita-naki-tziini ijatiro nampitsiki. Ikanta yariitzi-matapaaka, pokanaki irirori Samuel ijati karapapankoki. ");
INSERT INTO prq_vpl VALUES ("S19_15","010_9_15","1SA","9","15","15","Tima chapinki tikira yariityaata Saúl, maakotaki aparoni tsitiniri, iñaakakari Pawa yoka Samuel, ikantakiri: ");
INSERT INTO prq_vpl VALUES ("S19_16","010_9_16","1SA","9","16","16","“Onkitaitita-manaji inkimita-kyaari ikaratakira iroñaaka ooryaatsiri, ari nontyaantimiri aparoni ishininka Benjamín-iti, iriitaki pisai-patzii-totiri inkini ijiwatairi pishininka-payi nasitari naaka. Iriitaki ookakaa-winta-jimini imaimani-yitzimi Kinawai-taniriiti. Tima antaaro nonisironka-takari, ariitako-takana ikaminthaa-waitzi ikimaatsi-takaitari.” ");
INSERT INTO prq_vpl VALUES ("S19_17","010_9_17","1SA","9","17","17","Ikanta iñaawakiri Samuel yariita-paaka Saúl, yapiita-nakiri Pawa, ikantziri: “Yoka pishininka pokaintsiri, iriitaki nokanta-kimiri chapinki. Iriitaki pinkathari-winta-jirini pishininka-payi nasitari naaka.” ");
INSERT INTO prq_vpl VALUES ("S19_18","010_9_18","1SA","9","18","18","Ariitapaaka Saúl nampitsiki, ipokasi-tapaakiri okaakiini Samuel, ikantziri: “¡Jiwarí! ¿Tsikama osaiki iwanko ñaawyataniri?” ");
INSERT INTO prq_vpl VALUES ("S19_19","010_9_19","1SA","9","19","19","Yakanaki Samuel, ikantzi: “Naakataki ñaawyataniri, pimpoki tonkaariki pakyootina. Onkitaitita-manaji nonkantimiro okaratzi pinintziri pisampi-tinari, pijatzimai-tajyaa pinampiki. ");
INSERT INTO prq_vpl VALUES ("S19_20","010_9_20","1SA","9","20","20","Tima iñiitajiri pipira pyaawitain-chari, tikatsi impaita-matsityaa onkantzi-motan-tyaamiri. Tzimatsi ninta-piro-tachari ayimatziriri ashininka-payi Israel-iiti. ¿Tzimatsima pishininka okaakiini ininta-piroi-tziri? Awirokataki.” ");
INSERT INTO prq_vpl VALUES ("S19_21","010_9_21","1SA","9","21","21","Ikantzi Saúl: “¿Paitama pikantan-tanari? Naakama-chiini ishininka Benjamín-iti, tima ti noshiki-jiiti. Yanaakina ishikijiitzi pasini Israel-iiti. Iri owatsipiro noshininka okaakiini naaka, ti niriipiro-jiiti ti isiyaari pasini-payi Benjamín-iti.” ");
INSERT INTO prq_vpl VALUES ("S19_22","010_9_22","1SA","9","22","22","Ikantzi Samuel: “Thami ankyii inthompointa.” Yaanakiri yapatojiita ikaratzi 30 atziri, itsipata-nakari impiratani. Imisaika-paakiri iwapiinta iriipirori ariitzinkari. ");
INSERT INTO prq_vpl VALUES ("S19_23","010_9_23","1SA","9","23","23","Ikantapaakiri Samuel kotsita-tsiri: “Pamakinari wathatsi nokanta-kimiri piinasi-tyaari.” ");
INSERT INTO prq_vpl VALUES ("S19_24","010_9_24","1SA","9","24","24","Akotanaki kotsiwai-tatsiri, yaakiro ipori wathatsi irasi Saúl. Ikantzi Samuel: “Yoka nowapithaan-takimiri, piyaari. Iriitaki nowakimiri awiroka, itsipatana yakyootana ashininka-payi saikatsiri aka.” Imatakiro Saúl, yakyoo-takiri Samuel. ");
INSERT INTO prq_vpl VALUES ("S19_25","010_9_25","1SA","9","25","25","Ikanta yoirinkajaro otaapikii nampitsi, ikinkitha-waita-kaakiri Samuel yoka Saúl pankotsi-pankaaki. ");
INSERT INTO prq_vpl VALUES ("S19_26","010_9_26","1SA","9","26","26","Ikanta okitaitita-manaji, ikaimajiri Samuel yoka Saúl anta pankotsi-pankaaki, ikantairi: “Pisaakiti, pawishi tsika pisiritaro.” Piriintanaka Saúl. Aniitanaki itsipata-nakari Samuel. ");
INSERT INTO prq_vpl VALUES ("S19_27","010_9_27","1SA","9","27","27","Ikanta yoirinka-jiitaka, iwiraaka othapiki nampitsi, ikantakiri Samuel yoka Saúl: “Pintyaantiri pimpiratani ijiwati, pinkatziyawaki kapichiini, nonkaman-timiro okaratzi ikantakinari Pawa.” ");
INSERT INTO prq_vpl VALUES ("S110_1","010_10_1","1SA","10","1","1","Ari yaakotakiri Samuel yiinkantsi, isaipatzii-totakiri Saúl, inintaa-takiri, ikantziri: “Iriitaki Pawa saipatzii-totzimi, iñaakan-tatziimi awirokataki iyosiitaki pimpinkathari-wintajiri ashininka-payi yasitari irirori.” ");
INSERT INTO prq_vpl VALUES ("S110_17","010_10_17","1SA","10","17","17","Okanta apaata, ikaimakaan-takiri Samuel maaroni ishininka-payi, impinkathatiri Pawa Aminaironiki. ");
INSERT INTO prq_vpl VALUES ("S110_18","010_10_18","1SA","10","18","18","Ari ikamantakiri, ikantziri: “¡Ashininká! Pinkimi ikantzi Pawa, Iwawani Israel: ‘Naaka amajimi pisaika-witaka Apitantoniki, nookakaa-wintajimi impira-waitami Apitantoni-satzi, nookakaa-wintajimi aajatzi inintawita pasini pinkathari-payi jiwatziriri ishininka-payi iwayiri-waityaami. ");
INSERT INTO prq_vpl VALUES ("S110_19","010_10_19","1SA","10","19","19","Iro kantacha, ti pimiraawintajiri Piwawani owawisaa-kotajimiri okantzimo-siri-waitami, pasinonkaa-waitaka aajatzi. Pikanta-jiitaki: “Nonintzi paminina iriipirori pinkathari-winta-jinani.” Pimatiro pijajiiti iroñaaka pimpinkatha-tairi Pawa, maaroni jiwari-payi aajatzi pikarajiitzi pishininkata-wakaa-jiita.’ ” ");
INSERT INTO prq_vpl VALUES ("S110_20","010_10_20","1SA","10","20","20","Ikanta yapatotakiri Samuel maaroni ikaratzi ishininkata-wakaa-jiita, ikimita-kaantakaro iñaariwintyaarimi. Ari iñaakiro iriitaki ishininka-payi Benjamín-iti inintakai-takiri. ");
INSERT INTO prq_vpl VALUES ("S110_21","010_10_21","1SA","10","21","21","Ikanta ipokajii-tapaaki okaakiini ishininka-payi Benjamín-iti, yapiitakiro ikimitaakiro inkaaranki, iñaatzii iriitaki inintakaitaki ishininkaiti Matri. Ari yapiitakiro, iñaatzii iriitaki Saúl, itomi Cis, inintakai-takiri. Ari yamina-mina-witai-takari tsika-rika isaiki, ti iñiitiri. ");
INSERT INTO prq_vpl VALUES ("S110_22","010_10_22","1SA","10","22","22","Yapiitakiro ikowakoi-tziri Pawa, ikantziri: “¿Tikirama impoki naminakiri?” ’ Ikantzi Pawa: “Pamina-minatiri tsika iwaarantaita, ari isaiki imanaka.” ");
INSERT INTO prq_vpl VALUES ("S110_23","010_10_23","1SA","10","23","23","Ari ijajiitanaki, yamaitakiri imanawitaka, ikatziyakiri ipiyojiitaka ishininka-payi, katziya-tawato-tapaaka, ishimpaki iwiraa-matsi-yitari pasini-payi ishininka. ");
INSERT INTO prq_vpl VALUES ("S110_24","010_10_24","1SA","10","24","24","Ikantanakiri Samuel maaroni ishininka piyotain-chari: “¿Piñaakiri inintakiri Pawa impinkathari-wintimi? Tikatsi pasini ashininka kimityaarini yoka.” Ari ikantajiitzi ishininka: “¡Inkamintha osamaniti impinkathari-wintanti!” ");
INSERT INTO prq_vpl VALUES ("S113_1","010_13_1","1SA","13","1","1","Antaripirotaki Saúl yitanta-nakarori ipinkathari-wintziri ishininka-payi. Okanta awisanaki apiti osarintsi ipinkatharitzi, ");
INSERT INTO prq_vpl VALUES ("S113_2","010_13_2","1SA","13","2","2","iyosiitaki 3,000 ishininka-payi iyomitairi iwayirityaa. Yookanaki 2,000 intsipa-tyaari Pitakaariniki otsipa-nampitari Pawapankoni. Ityaantaki 1,000 intsipa-tyaari Jonatán Otzisiwiniki iipatsitiki Benjamín-iti. Iriima pasini ishininka-payi, yoipyaajiri Saúl ijayitaji iwanko-thaantiki. ");
INSERT INTO prq_vpl VALUES ("S113_3","010_13_3","1SA","13","3","3","Ikanta irirori Jonatán, yapirotakiri iwayiritari Kinawai-taniriiti panko-thaanti-tachari omitzithaki otzisi. Ikimajiitaki ishininka Kinawai-taniriiti. Irootaki ikantan-takari Saúl intyootaiti iyotantyaari maaroni ishininka-payi, ikantakiri: “¡Pinkimi noshininkaiti Heber-iiti!” ");
INSERT INTO prq_vpl VALUES ("S113_4","010_13_4","1SA","13","4","4","Ikanta iyotaki Israel-iiti yapirotakiri Saúl iwayiriti Kinawai-taniriiti, ikantajiitzi: “Yapirotakiri Saúl iwayiritari Kinawai-taniriiti panko-thaanti-tachari omitzithaki otzisi.” Irootaki ikisanta-nakari Kinawai-taniriiti, tima kisaniinta iwanakiri Israel-iiti. Irootaki yapatotan-takariri Saúl maaroni ishininka Pinaironchaariniki ");
INSERT INTO prq_vpl VALUES ("S113_5","010_13_5","1SA","13","5","5","Imatakiro aajatzi Kinawai-taniriiti, yapatojiitaka iwayiri-tyaari Israel-iiti. Tzimatsi 30,000 isiyako-minto, 6,000 kyaakota-kariri ipira-payi, itsipatakari iwayiriti-payi kinatsiri osaawiki, isiyakaro oshikitzi impaniki. Ikanta itonkaa-jiitaki Pitakaa-riniki iwatzika-yitapajiro iwanko-thaanti ikyaa-piintzi ooryaatsiri tsika yaminakoi-tapajiro Kaaripiropankoniki. ");
INSERT INTO prq_vpl VALUES ("S113_6","010_13_6","1SA","13","6","6","Ikanta iñaakiro Israel-iiti ikowiinka-takotanaki, inintatzii Kinawai-taniriiti iwayiri-tyaari. Irootaki imananta-jiita-nakari Israel-iiti impirita-moroki, sirantaa-tapiki, otinkanaaki aajatzi owaanka-naata nijaa. ");
INSERT INTO prq_vpl VALUES ("S113_7","010_13_7","1SA","13","7","7","Tzimatsi Heber-iiti siyayitain-chari intatzikiro Owaryiinkaariniki, ikinaki iipatsitiki Gad-iti irojatzi Wakaniki. Iriima Saúl irojatzi isaiki Pinaironchaariniki, tima tharowa ikantajiitaka iwayiriti ikaratzi tsipata-kariri. ");
INSERT INTO prq_vpl VALUES ("S113_8","010_13_8","1SA","13","8","8","Tima okaratzi 7 kitaitiri yooyawintziri Saúl yariityaa Samuel, tima ari okaratzi kitaitiri yookotakiri Samuel yariitan-tyaari Pinaironchaariniki. Titzimaita yariityaa, irootaki ijatanta-yitanaari ishininka-payi. ");
INSERT INTO prq_vpl VALUES ("S113_9","010_13_9","1SA","13","9","9","Ari ikantzi Saúl: “Pamakinari pasitakaariri Pawa ampomitiniri Pawa yaapatyaan-tairi akaaripirotaki.” Iriitaki Saúl kachaaryiin-katakaa-kiriri ipomitziri. ");
INSERT INTO prq_vpl VALUES ("S113_10","010_13_10","1SA","13","10","10","Iro ithonka-kitziiri Saúl ipomitziri ipira, iñaatziiri Samuel ipokaki awotsiki. Jatanaki Saúl imonthaa-wakyaari. ");
INSERT INTO prq_vpl VALUES ("S113_11","010_13_11","1SA","13","11","11","Ikantapaakiri Samuel: “¿Paita pipomitan-tariri awiroka?” Ikantzi Saúl: “Iro nopomitan-tariri noñaakiri ashininka-payi ijayitaji, ti pariityaa awiroka pikanta-witaka. Tima apatojiitakaa irirori Kinawai-taniriiti anta Pitakaa-riniki. ");
INSERT INTO prq_vpl VALUES ("S113_12","010_13_12","1SA","13","12","12","Nosiyakaantzi ari impokaki Kinawai-taniriiti iwayiri-tyaana Pinaironchaariniki, irootaki nopomitan-takariri. Tima ti nitakaa-wakyaari Pawa. ");
INSERT INTO prq_vpl VALUES ("S113_13","010_13_13","1SA","13","13","13","Ikantzi Samuel: “¡Pisinki-wintatyaa pantanta-karori! Ari pinkimisantiromi ikantakaan-tziri Pawa, ari pasi piwiromi pimpinkathari-wintiri ashininka-payi. ");
INSERT INTO prq_vpl VALUES ("S113_14","010_13_14","1SA","13","14","14","Airotzimaita piñiiro iroñaaka osamaniti pimpinkathariti. Aritaki yaminaji Pawa pasini inimotakiri irirori, iriitaki iwajiri ijiwatairi yasitari. Tima pipiyatha-takari awiroka ikantawi-takamiri.” ");
INSERT INTO prq_vpl VALUES ("S115_1","010_15_1","1SA","15","1","1","Okanta apaata ikantajiri Samuel jiwari Saúl: “Pairani, ityaantakina Pawa nosai-patzii-totimi pimpinkathari-wintiri ashininka-payi. Tima, ontzimatyii pinkimiro iroñaaka iñaani Pawa. ");
INSERT INTO prq_vpl VALUES ("S115_2","010_15_2","1SA","15","2","2","Iroka ikantzi Ñaapirori Pawa: ‘Ari nowasankitaakiri Otinkanaawini-satzi imaimani-takiri Israel-iiti isitowan-taari Apitantoniki.’ ");
INSERT INTO prq_vpl VALUES ("S115_3","010_15_3","1SA","15","3","3","Pijati awiroka, piwayiri-tyaari Otinkanaawini-satzi, papirotiro okaratzi tzimimo-tziriri, airo pinisironkatari. Pinthonkiri piwiri, sirampari, kooya, iintsi, aajatzi owakira tzimatsiri. Pimatanakiri ipira-payi, ikyaakoitari-payi, maaroni.” ");
INSERT INTO prq_vpl VALUES ("S115_4","010_15_4","1SA","15","4","4","Ikaimakaan-takiri Saúl maaroni ishininka-payi. Yapatojiitaka Pirataariniki. Ikaratzi 200,000 owayiri apatotain-chari. Tima tzimatsi 10,000 ishininka-payi Judá-iti. ");
INSERT INTO prq_vpl VALUES ("S115_5","010_15_5","1SA","15","5","5","Jatanaki Saúl iipatsitiki Otinkanaawini, itzimasi-tapaakiri anta otinkanaaki. ");
INSERT INTO prq_vpl VALUES ("S115_6","010_15_6","1SA","15","6","6","Ikamantakiri Saúl Asiropakoriiti, ikantziri: “Pisitowi, airo pitsipatari Otinkanaawini-satzi, notsipataimiri = kari napirotiri. Tima awiroka nisironka-takari pairani noshininka-payi isitowan-taari Apitantoniki.” Imatakiro Asiropakoriiti, ti intsipa-tanajyaari Otinkanaawini-satzi. ");
INSERT INTO prq_vpl VALUES ("S115_7","010_15_7","1SA","15","7","7","Imatakiri Saúl iwayiritari Otinkanaawini-satzi, yitanakari Tapotaa-riniki irojatzi Tantotsiwini, saikatsiri tsika yaminakoi-tziro Apitantoni isitowa-piintzi ooryaatsiri. ");
INSERT INTO prq_vpl VALUES ("S115_8","010_15_8","1SA","15","8","8","Yairikakiri Agag iwinkathariti Otinkanaawini-satzi. Ithonka iwisakiri maaroni ishininka-payi. ");
INSERT INTO prq_vpl VALUES ("S115_9","010_15_9","1SA","15","9","9","Okanta itsipatakari Saúl maaroni ishininka-payi, inisironka-takari Agag, ti iwiri. Ari ikimitaakiri wathayi-tatsiri ipirayitari, ti iwamairi. Aajatzi maaroni okaratzi pinayita-chari iwaararo. Apatziro yapirotakiro kaari apantyaaroni kaari pinatachani. ");
INSERT INTO prq_vpl VALUES ("S115_10","010_15_10","1SA","15","10","10","Ari iñaanatajiri Pawa Samuel, ikantairi: ");
INSERT INTO prq_vpl VALUES ("S115_11","010_15_11","1SA","15","11","11","“Oshiki okantzi-motakana nopinkathari-takaakiri Saúl, oshiki ipiyathataka, ti yantiro nokantziriri.” Antaro okantzi-motanakari Samuel, yaakowintakaro tsitini-paiti yamaniri Pawa. ");
INSERT INTO prq_vpl VALUES ("S115_12","010_15_12","1SA","15","12","12","Okanta okitaitita-mani, ananinkanaka Samuel imonthai-yaari Saúl. Ikamantai-takiri Samuel, ikantai-tziri: “Ijatatzii Saúl Owaantsii-toniki. Tima ikatziya-paintzi mapithantha tsika isankina-takiro okaratzi yantayi-takiri yoka ñaapirori. Aritaki awisanaki, oirinkaja anta Pinaironchaariniki.” ");
INSERT INTO prq_vpl VALUES ("S115_13","010_15_13","1SA","15","13","13","Ari ijatanaki Samuel tsika isaikaki Saúl. Ikanta iñaawakiri Saúl ipokaki Samuel, ikantawakiri: “Onkamintha intasonka-wintimi Pawa, tima nomonkara-takiro naaka ikantakinari.” ");
INSERT INTO prq_vpl VALUES ("S115_14","010_15_14","1SA","15","14","14","Ikantzi Samuel: “¿Paita asitariri ipira nokimiri ikaimi?” ");
INSERT INTO prq_vpl VALUES ("S115_15","010_15_15","1SA","15","15","15","Ikantzi Saúl: “Iriitaki namakiri ipira-payi Otinkanaawini-satzi. Tima iriitaki onimota-kiriri ashininka-payi iriipirori ipirayi-takari, iriitaki ampomiti-niriri Piwawani. Iriima pasini-payi napirotakiri.” ");
INSERT INTO prq_vpl VALUES ("S115_16","010_15_16","1SA","15","16","16","Ikantzi Samuel: “¡Pimairi-tawaki! Pinkimi nonkamantimi ikantakinari tsitiniriki Pawa.” Ikantzi Saúl: “Pinkantinaro.” ");
INSERT INTO prq_vpl VALUES ("S115_17","010_15_17","1SA","15","17","17","Ikantanaki Samuel: “Pisiyakaantzi awiroka ti ampantyaami. ¿Tima pijiwatiri ashininka-payi Israel-iiti? ¿Tima isaipatzii-totimi Pawa pimpinkathari-wintairi? ");
INSERT INTO prq_vpl VALUES ("S115_18","010_15_18","1SA","15","18","18","¿Kaarima Pawa ontyaantakimi, ikantakimi: ‘Pijati, papirotiri kaari-piroriiti Otinkanaawini-satzi. Pimapirotiri piwayiri-tyaari pinthonkiri piwamairi.’? ");
INSERT INTO prq_vpl VALUES ("S115_19","010_15_19","1SA","15","19","19","¿Paitama pipiyatha-tanta-rori ikantzimiri Pawa? ¿Paitama paantarori yasitari piwayiritani? Kaari-piro pikanta iñaakimi Pawa.” ");
INSERT INTO prq_vpl VALUES ("S115_20","010_15_20","1SA","15","20","20","Ari yakanaki Saúl ikantanaki: “Nantakiro ikantakinari Pawa, nomatakiro okaratzi inintakaanari, namakiri Agag, iwinkathariti Otinkanaawini-satzi, napirotakiri nowamaakiri ishininka-payi nampitarori anta. ");
INSERT INTO prq_vpl VALUES ("S115_21","010_15_21","1SA","15","21","21","Apatziro-machii yamaki owayiri-payi iriipirori ipirayitari inkarati apirotirimi. Yamakiri Pinaironchaariniki, iriitaki ampomiti-niriri Piwawani.” ");
INSERT INTO prq_vpl VALUES ("S115_22","010_15_22","1SA","15","22","22","Ikantzi Samuel: “¿Tima inintziro Pawa inkimisantaitiri ikantayi-tziri? ¿Iriima ininta-pirotzi ipomitai-tziniri yatsipi-takaani, iriima ininta-pirotzi onkatziyainkati iyachaarinka ipomitai-tziniriri? Irootaki kowa-piro-tacha inkimisantaitiri, airo ipiyatha-taitari, Irootaki anairori okaratzi ipomitai-tziniriri, anairo iyiinka ipiraitari-payi. ");
INSERT INTO prq_vpl VALUES ("S115_23","010_15_23","1SA","15","23","23","Kaari-pirori ikanta piyathari, isiyawai-takari ñaawyatan-taniri. Kowiinka ikanta pinkatha-waitziriri pawaniro, isiyawai-takari kaari aamawinta-chani. Ari pikantakari awiroka, piwashaantakiro iñaani Pawa, Ari iwashaantakimi irirori, aritaki okarata-paaki pimpinkatharitaki.” ");
INSERT INTO prq_vpl VALUES ("S115_24","010_15_24","1SA","15","24","24","Ari yapiitziro ikantzi Saúl: “¡Ñaamisa! Nokaaripirotaki. Nopiyatha-takaro ikantakaan-tziri Pawa, aajatzi nokimitaakimi awiroka. Nantasi-takaniri ikowako-takinari ashininka-payi, oshiki notharowan-takari. Paripiro-tajina nokaaripirotaki. ");
INSERT INTO prq_vpl VALUES ("S115_25","010_15_25","1SA","15","25","25","Pintsipa-tajyaana, nonintzi nompiya-sitajiri Pawa nompinkatha-tajiri.” ");
INSERT INTO prq_vpl VALUES ("S115_26","010_15_26","1SA","15","26","26","Ikantzi Samuel: “Airo nayimi, tima pipiyatha-takaro ikantawi-takamiri Pawa. Tima piwashaantakiro iñaani. Aritaki iwashaantajimi irirori, airo piñiiro pimpinkathari-wintairi ashininka-payi.” ");
INSERT INTO prq_vpl VALUES ("S115_27","010_15_27","1SA","15","27","27","Iro impiyan-tanajyaarimi Samuel, akotanaki Saúl yairika-kotawakiri opatziki iithaari, isaraa-kotakiri. ");
INSERT INTO prq_vpl VALUES ("S115_28","010_15_28","1SA","15","28","28","Ari ikantanaki Samuel: “Pikimitaakina naaka pimanka-ryaako-takina, ari inkimitai-tiriri pishininka-payi pipinkathari-wintziri, onkimiwai-tajyaaro imankaryii-tajirimi. Yaapitha-tajimiri impajiri pasini pishininka, iriipirori inatzii irirori, yanaimi awiroka. ");
INSERT INTO prq_vpl VALUES ("S115_29","010_15_29","1SA","15","29","29","Tima yoka Waniinka-tachari Awawani arokaiti Israel-iiti, ti inthaiya-nityaa, ti iyotiro iwashaanta-waiti, tima kaari atziri iwashaantan-tyaari.” ");
INSERT INTO prq_vpl VALUES ("S115_30","010_15_30","1SA","15","30","30","Ari yapiita-nakiro Saúl, ikantzi: “Omapiro-tatyaa nokaaripirotaki. Nonintzi pintsipa-tajyaana ampinkatha-tajiri Piwinkathariti Pawa. Nonintzi aajatzi iñiimi antari-kona-payi ashininka, iñiimi aajatzi maaroni ashininka-payi pimpinkathata-kayinari Piwinkathariti Pawa.” ");
INSERT INTO prq_vpl VALUES ("S115_31","010_15_31","1SA","15","31","31","Ari yapiitajiro Samuel itsipata-naari Saúl, jataki ipinkatha-tziri Pawa. ");
INSERT INTO prq_vpl VALUES ("S115_32","010_15_32","1SA","15","32","32","Ari ikantzi Samuel: “Pamakinari Agag, iwinkathariti Otinkanaawini-satzi.” Kimosiri ipokaki Agag isaikaki Samuel, ikantapaakiri: “¿Tima awisako-tajina inintaitzi iwaitina?” ");
INSERT INTO prq_vpl VALUES ("S115_33","010_15_33","1SA","15","33","33","Ikantzi Samuel: “Tima oshiki iwamaitakiro owaiyani noshininka-payi iroka piwisa-minto, ari onkanta-jyaari aajatzi asitamiri airo oñaajiri owaiyani.” Ichikakiri Samuel pinkathari Agag Pinaironchaariniki. Tima ithonka ichikapithairikitakiri iwathaki, imatakiro okaratzi ikantakiriri Pawa. ");
INSERT INTO prq_vpl VALUES ("S115_34","010_15_34","1SA","15","34","34","Irojatzi ikinanta-nakari Samuel anta Tonkaironiitoniki. Iriima Saúl tonkaanaki iwankoki Otzisiwiniki. ");
INSERT INTO prq_vpl VALUES ("S115_35","010_15_35","1SA","15","35","35","Tima ti yapiitajiro Samuel iñiiri Saúl. Oshiki yiraako-waitakari. Oshiki okantzi-motakari Pawa isiniwi-takari Saúl impinkathari-wintiri Israel-iiti. ");
INSERT INTO prq_vpl VALUES ("S116_1","010_16_1","1SA","16","1","1","Ari yapiitajiro Pawa ikantairi Samuel: “¿Tsika-paiti pishiki piraakotari Saúl? Ti noninti naaka impinkathari-wintairi pishininka-payi. Paanaki yiinkantsi pichiinaki-tsitiki, piyaata-sitiri Isaí nampitarori Tantapankoniki, iriitaki noyosii-takiri itomi impinkathariti.” ");
INSERT INTO prq_vpl VALUES ("S116_2","010_16_2","1SA","16","2","2","Ikantzi Samuel: “¿Tsika nonkinika nojatan-tyaari isaiki irirori? Aririka iyotaki Saúl, aritaki iwakina.” Ikantzi Pawa: “Paanaki kiripiri vaca, pinkanta-paakiri: ‘Nopokatzii nompomi-tiniri natsipi-takaani Pawa.’ ");
INSERT INTO prq_vpl VALUES ("S116_3","010_16_3","1SA","16","3","3","Pinkaimamai-tyaari Isaí pintsipa-tyaari pimpomitiri patsipi-takaani vaca, naaka kantimini paita-rika pantiri. Naaka kantimini itzimi-rika nonintziri pisai-patzii-totiri impinkathari-tantyaari.” ");
INSERT INTO prq_vpl VALUES ("S116_4","010_16_4","1SA","16","4","4","Imatakiro Samuel ikantakiriri Pawa. Ikanta yariitaka Tantapankoniki, imonthaa-wakari jiwari-payi. Titzimaita yatzirin-tawakyaari, itharonkan-kiini isampitakiri, ikantziri: “¿Kamiithama pipoki pariitana?” ");
INSERT INTO prq_vpl VALUES ("S116_5","010_16_5","1SA","16","5","5","Ikantzi Samuel: “Ari okanta. Nopokatzii nompomi-tiniri Pawa natsipi-takaani. Piwitsika-sirityaa awiroka. Thami ampomitiri atsipita-kaani.” Imatakiro Samuel iwitsika-siri-takaari Isaí, aajatzi ikimitaakiri itomi-payi, itsipatakari ipomitziniri Pawa yatsipi-takaani. ");
INSERT INTO prq_vpl VALUES ("S116_6","010_16_6","1SA","16","6","6","Ikanta ipokajiitaki itomi-payi Isaí, imonthaakari Samuel itarori itomi Isaí paitachari Eliab, ikanta-siri-tanaki: “Jiirinta inintakiri Pawa nosai-patzii-totiri.” ");
INSERT INTO prq_vpl VALUES ("S116_7","010_16_7","1SA","16","7","7","Ikantzi Pawa: “¡Samuel! Airo iwapyii-motasitami tsika ikantawaita iwathaki, ikara-tawatotzi ikatziya, ti nonintiri naaka. Tima ti naminiri yaminiri atziri-payi. Tima apatziro yaminiro atziri-payi okaratzi iñaayitziri. Irooma naaka apatziro naminiri isiriki.” ");
INSERT INTO prq_vpl VALUES ("S116_8","010_16_8","1SA","16","8","8","Ari ikaimakiri Isaí pasini itomi paitachari Abinadab iñaawakiri Samuel. Ikantzi Samuel: “Ti inintiri Pawa.” ");
INSERT INTO prq_vpl VALUES ("S116_9","010_16_9","1SA","16","9","9","Yamaki Isaí pasini itomi paitachari Sama. Ikantzi Samuel: “Ti inintiri aajatzi Pawa yoka.” ");
INSERT INTO prq_vpl VALUES ("S116_10","010_16_10","1SA","16","10","10","Tima ikaratzi 7 itomi Isaí yamawitakari iñiiri Samuel, ikantzi Samuel: “¡Isaí! Ti inintiri Pawa yokapayi pitomi.” ");
INSERT INTO prq_vpl VALUES ("S116_11","010_16_11","1SA","16","11","11","Isampitakiri Samuel ikantziri Isaí: “¿Arima ikaratzi pitomi?” Ikantzi Isaí: “Ainiro aparoni iyaapitsi, ijatatzii yaminiri nopira.” Ikantzi Samuel: “Pinkaima-kaantiri, airo awita irojatzi yariitan-takyaa irirori aka.” ");
INSERT INTO prq_vpl VALUES ("S116_12","010_16_12","1SA","16","12","12","Ityaantaki kaimirini. Pokaki iñiiri Samuel. Iñaatziiri kamiitha ikiraa-porotzi, kamiitha ikantaka irooki, kamiithaa-niki ikantaka maaroni. Iñaana-siri-tanakiri Pawa Samuel, ikantziri: “Iriitaki pisai-patzii-totiri yoka.” ");
INSERT INTO prq_vpl VALUES ("S116_13","010_16_13","1SA","16","13","13","Ari yaakotakiri Samuel yiinkantsi, ithonka iñaakiri iririntzi-payi isaipatzii-toitakiri. Aripaiti isaika-siri-tanta-nakari Itasorinka Pawa David. Ikanta ithonka-kiro Samuel isaipatzii-totakiri David, jataji inampiki Tonkaironiitoniki. ");
INSERT INTO prq_vpl VALUES ("S116_14","010_16_14","1SA","16","14","14","Titzimaita isaika-siri-tanta-najyaari itasorinka Pawa yoka Saúl. Ikantakaa-nakaro Pawa ikamaari-siriti Saúl. ");
INSERT INTO prq_vpl VALUES ("S116_15","010_16_15","1SA","16","15","15","Ikantawi-takari impiratani Saúl: “Pawa kantakaakaro pikamaari-siri-tantakari. ");
INSERT INTO prq_vpl VALUES ("S116_16","010_16_16","1SA","16","16","16","Tima naaka pimpiratani, pintyaantina namini yotzirori ipiyompi-waitzi. Aririka pinkamaari-siri-waiti, pinkantiri impiyompi-wintimi, aritaki pawisako-siritaji.” ");
INSERT INTO prq_vpl VALUES ("S116_17","010_16_17","1SA","16","17","17","Ari ikantziri Saúl impiratani: “Pamini awiroka yotzirori, aririka piñaaki pamakinari.” ");
INSERT INTO prq_vpl VALUES ("S116_18","010_16_18","1SA","16","18","18","Ikantzi pasini impiratani: “Noñiiri naaka itomi Isaí poñaachari Tantapankoniki, iyotziro irirori ipiyompitzi, ñaapirori ikanta, sintsiri, iriipirori owayiri, yotaniri, kamiithaa-niki atziri, itasonka-wintziri Pawa. ");
INSERT INTO prq_vpl VALUES ("S116_19","010_16_19","1SA","16","19","19","Ityaantaki Saúl kamantirini Isaí, inkantiri: “Pintyaantinari pitomi David, aamaako-wintariri pipira-payi.” ");
INSERT INTO prq_vpl VALUES ("S116_20","010_16_20","1SA","16","20","20","Imatakiro Isaí, yaaki ikyaakoitari ikyaakaakiri oshiki yatantaitari, aajatzi iraitziri, wathatsi. Ipawakiri David yaanakiniri Saúl. ");
INSERT INTO prq_vpl VALUES ("S116_21","010_16_21","1SA","16","21","21","Jataki David iñiiri Saúl, yaawakiri impira-tyaari. Oshiki itakotakari Saúl yoka David. Tima onimotakiri Saúl, inkimita-kaantiri inampiri yoka David. ");
INSERT INTO prq_vpl VALUES ("S116_22","010_16_22","1SA","16","22","22","Ityaantaji Saúl ñaantsi inkaman-taitiri Isaí, ikantaki: “Nonintzi intsipa-tyaana pitomi David aka, oshiki inimotakina.” ");
INSERT INTO prq_vpl VALUES ("S116_23","010_16_23","1SA","16","23","23","Tima aririka ompokimo-tapajiri Saúl ikamaari-siri-waitzi, ipiyompi-wintziri David. Aririka inkimiro ipiyompi-waitzi, awishimo-tziri Saúl ikamaari-siri-waitzi, tharowinta ikanta ikimiri David. ");
INSERT INTO prq_vpl VALUES ("S117_1","010_17_1","1SA","17","1","1","Okanta apaata yapatotakiri iwayiriti Kinawai-taniriiti, ipiyojiitaka Incha-jaariki iipatsitiki Judá-iti. Iwanko-thaanti-jiitaka omontitakaro Kiyaronchaari saikatsiri Santzikoitoniki. ");
INSERT INTO prq_vpl VALUES ("S117_2","010_17_2","1SA","17","2","2","Imatakiro Saúl yapatotakiri irirori ishininka-payi, iwanko-thaanti-jiitaka otaapiki Pasotzii-toniki, owithainka ikantajiitaka iwayiri-tyaari Kinawai-taniriiti. ");
INSERT INTO prq_vpl VALUES ("S117_3","010_17_3","1SA","17","3","3","Tima tonkaariki otzisi isaikajiitaki Kinawai-taniriiti. Imatzitakaro aajatzi irirori Israel-iiti saikaki intatzikiro pasiniki otzisi imontita-kotakari. ");
INSERT INTO prq_vpl VALUES ("S117_4","010_17_4","1SA","17","4","4","Ari isitowiri iwanko-thaanti-yitaka Kinawai-taniriiti aparoni owayiri ñaapirori ipaitai-tziri Goliat poñaachari Inchatonaariki, antari-pinthakii ikatziya. ");
INSERT INTO prq_vpl VALUES ("S117_8","010_17_8","1SA","17","8","8","Katziya-paaka Goliat, ikaimako-takiri ipiyojiitaka intatzikiro iwayiriti Israel-iiti, ikantziri: “¿Paitama piwithain-kasitari piwayiri-tyaari? Aparoni nokanta naaka Kinawai-taniri, irooma awiroka oshiki pikarajiitzi impiratani Saúl. Nonintzi pamini aparoni pikarajiitzi, impoki iwayiri-tyaana. ");
INSERT INTO prq_vpl VALUES ("S117_9","010_17_9","1SA","17","9","9","Aririka imatakina iwayiri-tyaana, awirokaiti ompirata-jyaanani naakaiti. Irooma naaka-rika matakimini, awirokaiti nompira-tajyaa, nantawai-takaa-yitajimi.” ");
INSERT INTO prq_vpl VALUES ("S117_10","010_17_10","1SA","17","10","10","Aikiro ikantana-kitzii Kinawai-taniri: “Nopokatzii nonthainka-mawaitimi Israel-iiti. ¡Pintyaanti aparoni pishininka iwayiri-tyaana!” ");
INSERT INTO prq_vpl VALUES ("S117_11","010_17_11","1SA","17","11","11","Tima ikimaki Saúl aajatzi maaroni ishininka-payi ikantakiri Kinawai-taniri. Ontsinka-siryaa-nakiri, antaro itharowan-tajii-tanakari. ");
INSERT INTO prq_vpl VALUES ("S117_12","010_17_12","1SA","17","12","12","Tima yoka David itomi inatzii Isaí poñaachari Tantapankoniki saikatsiri Posinipathaniki iipatsitiki Judá-iti. Irojatzi ijiwariwita Saúl, antari-kona-tapaaki irirori Isaí. Tzimatsi 8 itomi yoka Isaí. ");
INSERT INTO prq_vpl VALUES ("S117_13","010_17_13","1SA","17","13","13","Aritaki isaikajiitzi aajatzi mawa itomi Isaí iyaatiri Saúl iwayirityaa. Iroka iwairo-payi ikaratzi pokaintsiri: Eliab itarori itzimi. Pasini ipaita Abinadab. Pasini ipaita Sama. ");
INSERT INTO prq_vpl VALUES ("S117_14","010_17_14","1SA","17","14","14","Iriima David iyaapitsi inatzii. Ari ipokajii-tziri yantariti-payi itomi Isaí iyaatakiri Saúl. ");
INSERT INTO prq_vpl VALUES ("S117_15","010_17_15","1SA","17","15","15","Ari ijawita-painta irirori David, aajatzi ipiyaaro. Tima iro ipiyantaari David yaamaakowi-tapajyaari ipira iriri anta Tantapankoniki. ");
INSERT INTO prq_vpl VALUES ("S117_16","010_17_16","1SA","17","16","16","Tima oshiki ipiya-piyataka Kinawai-taniri iñaasirinkiri Israel-iiti, ipoki kapichikitaiti aajatzi tsitinii-tiini. Ari yasi iwakiro ipiya-piyata, okarataki 40 kitaitiri ipiya-piyataka. ");
INSERT INTO prq_vpl VALUES ("S117_17","010_17_17","1SA","17","17","17","Okanta apaata ikantakiri Isaí yoka David: “¡Notomí! Pijati isaiki pirintzi-payi, paanakiniri posari pankirintsi-pani, aajatzi 10 yatantaitari. Sintziini paanakiniri isaikajiitzi pirintzi-payi. ");
INSERT INTO prq_vpl VALUES ("S117_18","010_17_18","1SA","17","18","18","Paanakiniri jiwatziriri owayiri inkarati 10 ikiso-pithatzi oyaaki othomi vaca. Nonintzi piñaajatiri tsika-rika ikanta pirintzi. Pamajina yasitari irirori, iro noyotan-tyaari tikatsi awishimo-tirini pirintzi.” ");
INSERT INTO prq_vpl VALUES ("S117_19","010_17_19","1SA","17","19","19","Irojatzi isaikaki Saúl otaapiki Pasotziitoniki itsipatakari iririntzi-payi David aajatzi maaroni ishininka-payi iwayiritari Kinawai-taniriiti. ");
INSERT INTO prq_vpl VALUES ("S117_20","010_17_20","1SA","17","20","20","Ari yananinkanaka David, yookanakiri ipira-payi yaamaako-wintyaari pasini atziri. Jataki irirori yaanakiro okaratzi ikantakiriri iriri. Ikanta yariita-paaka David iwanko-thaanti-jiitaka, ari imonthaa-paakari ijati iwithai-nkajiitaa. Ikaimajii-tatzii ijajiitzi intharowintan-tyaari pasini ikarajiitaki. ");
INSERT INTO prq_vpl VALUES ("S117_21","010_17_21","1SA","17","21","21","Taromaaka irirori Kinawai-taniriiti intatzikiro, imontita-kotakari Israel-iiti. ");
INSERT INTO prq_vpl VALUES ("S117_22","010_17_22","1SA","17","22","22","Tima ipanakiri David aamaako-winta-rori owayiri-mintotsi okaratzi yamakiri. Ti ishintanaki, osatika-paaka itaromaa-jiitaka. Iwithata-paakari iririntzi. ");
INSERT INTO prq_vpl VALUES ("S117_23","010_17_23","1SA","17","23","23","Ikinkithawai-minthaitzi, sitowanaki Kinawai-taniri Inchatonaarini-satzi paitachari Goliat. Yapiita-pajiro ikaimi ikimita-piintziro, ithainka-waitziri Israel-iiti. Ikimaki David ikantakiri. ");
INSERT INTO prq_vpl VALUES ("S117_24","010_17_24","1SA","17","24","24","Ari isiyajii-tanaka maaroni Israel-iiti iñaawakiri ipokaki. Tima ayimatakiri itharonka. ");
INSERT INTO prq_vpl VALUES ("S117_25","010_17_25","1SA","17","25","25","Ikantajiitzi: “¿Piñaakiri pokaintsiri? ¡Ipokatzii inthainka-matai arokaiti! Tzimatsi-rika matakirini iwamairi, oshiki awaararontsi impiriri ajiwariti, impiri aajatzi irisinto iinantyaaro. Ikantzitaka aajatzi ajiwariti: ‘Itzimi-rika wamaakirini, ari okarata-paaki isintsiwintziri pinkathari intyaantiniri kiriiki, aajatzi ishininka okaakiini ikaratzi inampijiitaro inampiitiki iwaisatzitini, ari okarata-paaki impinawintyaa.’ ” ");
INSERT INTO prq_vpl VALUES ("S117_26","010_17_26","1SA","17","26","26","Ari isampita-nakiri David itsipatakari ikatziya, ikantziri: “¿Omapiroma impaitiriri wamairini yoka Kinawai-taniri, aririka impyaajyaa thainkama-waitairi? ¿Tsikama ipaimatsitaka yoka kaari-pirori Kinawai-taniri inthainka-matan-tyaariri iwayiriti Pawa Añaanita-tsiri?” ");
INSERT INTO prq_vpl VALUES ("S117_27","010_17_27","1SA","17","27","27","Yakajii-tanaki ishininka-payi, irootaki yapii-yapii-takiri okaratzi ikanta-wakaa-jiitari, ikantzi: “Irootaki impaitiriri atziri wamairini Goliat.” ");
INSERT INTO prq_vpl VALUES ("S117_28","010_17_28","1SA","17","28","28","Ikimaki Eliab yantariti David ikantziri ishininka-payi, ikisanakiri David, ikantanakiri: “¿Paitama pipokantari awiroka aka? ¿Paitama pookanakiri aminirini pipira-matsiti anta otzisi-masiki? Noyotzimi tsika pikanta awiroka opaita pikinkithasiritari, pinintasita piñiiri owayiri-tachari.” ");
INSERT INTO prq_vpl VALUES ("S117_29","010_17_29","1SA","17","29","29","Akanaki David, ikantziri: “¿Paitama nantakiri? Apatziro noñaawai-matsitaki. ");
INSERT INTO prq_vpl VALUES ("S117_30","010_17_30","1SA","17","30","30","Ipiya-pitha-tanakari iririntzi, isampitakiri pasini. Irojatzi ikantzi-tariri ikantai-takiriri inkaaranki. ");
INSERT INTO prq_vpl VALUES ("S117_31","010_17_31","1SA","17","31","31","Ikanta ikimaitakiri ikantakiri David, ikamantai-takiri Saúl. Ikaimakaan-takiri irirori. ");
INSERT INTO prq_vpl VALUES ("S117_32","010_17_32","1SA","17","32","32","Ikinkitha-waita-kaakiri David jiwari Saúl, ikantziri: “¡Jiwarí! Airo atharowan-tawaitari yonta. Naaka pimpiratani jatasitirini, aritaki nowayiri-takyaari Kinawai-taniri.” ");
INSERT INTO prq_vpl VALUES ("S117_33","010_17_33","1SA","17","33","33","Ikantzi Saúl: “¡David! Airo okantzi pijati apaniroini piwayiri-tyaari yonta Kinawai-taniri, tikira pantari-piro-tita. Yitzitakaro pairani irirori iwayirita ainiro imainari-tapaaki.” ");
INSERT INTO prq_vpl VALUES ("S117_34","010_17_34","1SA","17","34","34","Ikantzi David: “Pimpiratani nonatzi, aamaako-tariri ipira-payi asitanari. Ipokawita kashikari, maini, yatsika-witari aparoni tsika ipiyojiita ipiraitari. ");
INSERT INTO prq_vpl VALUES ("S117_35","010_17_35","1SA","17","35","35","Ikanta nopatzima-takota-nakiri, naapitha-tawajiri ipaantiki. Inintzi yatsikinami naaka, nairikakiri itapinomaki, noposakiri. Kamanaki. ");
INSERT INTO prq_vpl VALUES ("S117_36","010_17_36","1SA","17","36","36","Inkanta-wityaa iriirika kashikari, maini, aritaki nowamaakiri. Ari nonkantzi-takyaari yonta’ kaari-pirori Kinawai-taniri. Tima oshiki ithainka-mawai-takiri iwayiriti Pawa Añaanita-tsiri. ");
INSERT INTO prq_vpl VALUES ("S117_37","010_17_37","1SA","17","37","37","Aikiro ikantatzii David: “Iriitaki Pawa ookakaawinta-kinari inkisawaraan-tyaanaromi irako-pako kashikari, inkisaraan-tyaanaromi irako-pako maini. Aritaki yookakaa-wintakina aajatzi inintawityaa inkisaraan-tyaanaromi irako-pako yoka Kinawai-taniri.” Ari ikantanaki Saúl: “Pijati, onkamintha yookakaa-wintimi Pawa.” ");
INSERT INTO prq_vpl VALUES ("S117_38","010_17_38","1SA","17","38","38","Ikantakaantaki Saúl yamaitakiro kithaarintsi inkithaa-takai-tyaari David. Yamathai-taitiri iwitsikai-tziro asiro kitirita-tsiri, inkyaanta-kayi-tyaari kisotaki-tatsiri iniiki. ");
INSERT INTO prq_vpl VALUES ("S117_39","010_17_39","1SA","17","39","39","Ikithaa-takowi-takaro David ithatzinka-minto, iñaanta-witakaro yaniiti. Tima ti imata-piintiro inkithaa-tyaaro. Ikantanakiri Saúl: “Ti onkanti naniita-kayiro, ti namityaaro.” Isapokajiro maaroni. ");
INSERT INTO prq_vpl VALUES ("S117_40","010_17_40","1SA","17","40","40","Yaanakiro ikotzikiiri, iyoyaanaki 5 kamiithakiri mapiki piyotachari nijaatinkaki, ititanakiro itharatiki. Yairikakiro iwaraka-thati, ijatasi-tanakiri Kinawai-taniri. ");
INSERT INTO prq_vpl VALUES ("S117_41","010_17_41","1SA","17","41","41","Nosikaka irirori Kinawai-taniri imonthai-yaari David. Iriitaki jiwatatsi impiratani. ");
INSERT INTO prq_vpl VALUES ("S117_42","010_17_42","1SA","17","42","42","Ikanta yaminaki Kinawai-taniri iñaatziiri ipokaki David, ithainka-wakiri. Tima awankari ikanta iñaakiri, kiraa-poro ikantaka, kamiithaa-nikitaki. ");
INSERT INTO prq_vpl VALUES ("S117_43","010_17_43","1SA","17","43","43","Ari ipairyaa-nakiri Kinawai-taniri iwawa-niroti, ikamaari-tanakiri David, ikantawakiri: “¿Naakama otsitzi pamasi-tantanari inchaki?” ");
INSERT INTO prq_vpl VALUES ("S117_44","010_17_44","1SA","17","44","44","Aikiro ikantana-kitzii Kinawai-taniri: “¡Pimpoki. Iroñaaka iyaami tziso, aajatzi katsikaniri antami-wiri!” ");
INSERT INTO prq_vpl VALUES ("S117_45","010_17_45","1SA","17","45","45","Yakanaki David, ikantziri: “Pamasi-takina awiroka piwisa-minto, pichakopiti aajatzi pithatzinka-minto. Irooma naaka nopoki nawintaari Pawa Ñaapirori, owayiri-takaariri Israel-iiti. Pithainka-piintakiri. ");
INSERT INTO prq_vpl VALUES ("S117_46","010_17_46","1SA","17","46","46","Tima isinitakimi iroñaaka Pawa noitsinampaimi, aritaki nowisakimi. Tima maaroni piwayiriti ari iwajyaari tziso, iwajyaari aajatzi katsikaniri antami-wiri. Aritaki iyotaki maaroni nampitarori kipatsiki tzimatsi Iwawani Israel-iiti. ");
INSERT INTO prq_vpl VALUES ("S117_47","010_17_47","1SA","17","47","47","Ari iyoti ikaratzi piyotain-chari aka ti apatziro iwawisaa-kotantaro Pawa chakopi, wisa-mintotsi. Tima iroka owayiri-taantsi irasi Pawa onatzii, iriitaki sinitakimiri awirokaiti nowamaimi.” ");
INSERT INTO prq_vpl VALUES ("S117_48","010_17_48","1SA","17","48","48","Ari isiyapaaka Kinawai-taniri, ipokasi-tziri David. Ti itsinampa-tanaki David, ijatzitanaka irirori impiyatyaari. ");
INSERT INTO prq_vpl VALUES ("S117_49","010_17_49","1SA","17","49","49","Ipampitanaki itharatiki David, yaanaki imapikiti, iwaraka-thatakiri, iposakiri ipankainaki Kinawai-taniri. Tyaanaki, naryaa-paaka kipatsiki, irojatzi owikapaaka mapiki ipankainaki. ");
INSERT INTO prq_vpl VALUES ("S117_50","010_17_50","1SA","17","50","50","Ari ikantakirori David yiitsinampaan-takariri Kinawai-taniri. Apatziro yaanaki iwaraka-thati aajatzi imapikiti, iwamaakiri. Ti ontzimi-mowityaari irirori David iwisa-minto. ");
INSERT INTO prq_vpl VALUES ("S117_51","010_17_51","1SA","17","51","51","Isiyasi-tapaakari David okaakiini Kinawai-taniri. Inosiki-tapaakiri iwisa-minto, iwisakiri iitoki. Ikanta iñaakowintakiri Kinawai-taniriiti iwamaitakiri iriipirori iwayiriti, siyajii-tanaka. ");
INSERT INTO prq_vpl VALUES ("S117_52","010_17_52","1SA","17","52","52","Ipatzimariki iwanakiri Judá-iti imatzita-nakaro aajatzi pasini-payi Israel-iiti, ikaima-kotanakiri sintsiini. Ipatzima-jiita-nakiri irojatzi otaapiiki. Iwamaaki oshiki iwayiriti Kinawai-taniriiti, yitanakaro nampitsiki Apitatakowiniki irojatzi yariitan-takari Inchatonaariki aajatzi Thokairoshaariki. ");
INSERT INTO prq_vpl VALUES ("S118_5","010_18_5","1SA","18","5","5","Tima inthonkiro David ijayitziro tsika-rika ityaantziri Saúl, ti impiyatha-waityaa. Irootaki inintan-tanakari Saúl ijiwatiri iwayiriti-payi. Tima oshiki onimotakiri iwayiriti aajatzi inampiri-payi Saúl. ");
INSERT INTO prq_vpl VALUES ("S118_6","010_18_6","1SA","18","6","6","Ikanta ipiyajaro owayiri-payi iwamaan-takariri David Kinawai-taniri, osiyasi-tawajari kooya-payi poñaayi-tainchari inampiki-payi Israel-iiti. Owithata-waari pinkathari Saúl, kimosiri opanthaa-jiitanaki, tharowinta otziron-kajiita amashai-jiitzi. poimainka ikantanaka othatani-payi. ");
INSERT INTO prq_vpl VALUES ("S118_7","010_18_7","1SA","18","7","7","Iroka okantzi owanthaani kooya-payi: Iwamaaki Saúl oshiki akisaniintani, Iriima David, iwamaakiri irirori oshiki-piro-tatsiri. ");
INSERT INTO prq_vpl VALUES ("S118_8","010_18_8","1SA","18","8","8","Irootaki owatsimaa-nakiriri Saúl ikimakiro panthaantsi. Ikantanaki irirori: “Tima ikantaitaki, iwamaakiri David oshiki-piro-tatsiri. Irooma naaka nowamaa-matsitaki oshiki. ¡Apatziro kapichiini iwinkatharititaitakyaarimi David!” ");
INSERT INTO prq_vpl VALUES ("S118_9","010_18_9","1SA","18","9","9","Aripaiti ikatsima-kyaawai-tanakiri Saúl yoka David. ");
INSERT INTO prq_vpl VALUES ("S118_10","010_18_10","1SA","18","10","10","Okanta pasini kitaitiri, ikantakaakaro Pawa ikamaari-siriti Saúl, tima sinkiwintaka iwinkathari-pankotiki. Pokaki David ipiyompi-wintziri ikimita-piintziro apatha-kiroini. Yairikakiro irirori Saúl iwisa-minto. ");
INSERT INTO prq_vpl VALUES ("S118_11","010_18_11","1SA","18","11","11","Yaanakiro Saúl iwisa-minto, inintzi iyontaa-kotirimi David tanto-tsiki, apiti-satzi ikominkakiro David wisa-mintotsi. ");
INSERT INTO prq_vpl VALUES ("S118_12","010_18_12","1SA","18","12","12","Oshiki itharowan-takari Saúl yoka David, tima inisironkatani inatzii Pawa. Iriima Saúl yooka-nakiri irirori Pawa. ");
INSERT INTO prq_vpl VALUES ("S118_13","010_18_13","1SA","18","13","13","Irootaki yookanta-kariri Saúl yoka David, ityaantakiri ijiwatiri oshiki iwayiriti. Iriitaki piyapiya-tachani iwayiri-tantyaa. ");
INSERT INTO prq_vpl VALUES ("S118_14","010_18_14","1SA","18","14","14","Iriitaki Pawa tsipata-kariri David, tima okaratzi yantayi-tziri kamiitha okantaka. ");
INSERT INTO prq_vpl VALUES ("S118_15","010_18_15","1SA","18","15","15","Irootaki ipinkan-tanakariri Saúl yoka David, tima iñaakiri kamiitha okanta yantayi-tziri. ");
INSERT INTO prq_vpl VALUES ("S118_16","010_18_16","1SA","18","16","16","Tima oshiki itakojii-takari David maaroni Judá-iti aajatzi ikimitaakiri pasini-payi Israel-iiti, iriitaki jiwatakiriri tsika-rika ikinayitzi iwayirita. ");
INSERT INTO prq_vpl VALUES ("S119_1","010_19_1","1SA","19","1","1","Ari ikinkitha-waita-kaakiri Saúl itomi aajatzi maaroni impiratani, ikantakiri itomi: “¡Jonatán! Nonintzi piwamairi David.” Iro kantacha Jonatán, oshiki itakotakari David. ");
INSERT INTO prq_vpl VALUES ("S119_2","010_19_2","1SA","19","2","2","Ikamantakiri David, ikantziri: “Inintatzii iwamaimi asitanari. Paamaiyaari onkitaitita-manaji, pijati pamini tsika pimañaa. ");
INSERT INTO prq_vpl VALUES ("S119_3","010_19_3","1SA","19","3","3","Ari nojataki naaka nontsipa-tyaari asitanari tsika-rika pisaikaki. Ari nonkanta-kowintakimi, nonkimiri tsika-rika inkanti. Aritaki nonkaman-takimiro onkarati inkantinari. ");
INSERT INTO prq_vpl VALUES ("S119_4","010_19_4","1SA","19","4","4","Ikinkitha-waita-kaakiri Jonatán iriri, ikantako-wintakiri David. Ikantziri: “¡Pinkatharí! Ti onkamiithati piwaaripirotiri pimpiratani David. Tikatsi inkantimi irirori, yanta-piinta-kimiro kamiitha-tatsiri. ");
INSERT INTO prq_vpl VALUES ("S119_5","010_19_5","1SA","19","5","5","Tima isinitakiro yañaan-tari imatanta-kariri iwamairi Kinawai-taniri. Ari ikinakairori Pawa ikisawintari maaroni ashininka Israel-iiti. Piñaakiro awiroka antaro pikimo-siri-tanaki. ¿Paitama pinkaaripiro-tantyaari pimaimanitiri kaari tzimatsini ikinakaa-sitani? Tikatsi yanti irirori.” ");
INSERT INTO prq_vpl VALUES ("S119_6","010_19_6","1SA","19","6","6","Ikanta ikimaki Saúl ikantakiriri Jonatán, ikantanaki: “¡Omapiro-tatyaa nonkantimiri, tima añaatsi Awawani. Airo ikami David!” ");
INSERT INTO prq_vpl VALUES ("S119_7","010_19_7","1SA","19","7","7","Ari ikaimajiri Jonatán yoka David, ikamantakiri okaratzi ikinkitha-waita-kaakiriri iriri. Irijatzi Jonatán aanajiriri isaiki iriri, saikapaji David ikimita-piintziro pairani. ");
INSERT INTO prq_vpl VALUES ("S119_8","010_19_8","1SA","19","8","8","Ari apiitanaja owayiri-taantsi. Jataki David iwayiritari Kinawai-taniriiti, yiitsinampaakiri. Imapiro-takiri imisiyakiri. ");
INSERT INTO prq_vpl VALUES ("S119_9","010_19_9","1SA","19","9","9","Ari ikantakaa-najaro Pawa ikamaari-siriti Saúl. Tima saikaki iwankoki yairikakiro iwisa-minto, ikima-mintha-tziri David ipiyompi-waitzi. ");
INSERT INTO prq_vpl VALUES ("S119_10","010_19_10","1SA","19","10","10","Ari yapiiwi-takaro Saúl inintzi iyontaa-kotirimi David tanto-tsiki. Ikominka-najiro David iwisa-minto Saúl, oshitaa-sitapaaka tanto-tsiki. Ti ishintanaki David, siyaka tsitini-paiti. ");
INSERT INTO prq_vpl VALUES ("S119_11","010_19_11","1SA","19","11","11","Irootaki ityaantan-takari Saúl iwayiriti, ikantakiri: “Pijati paminiri David anta iwankoki. Tima onkitaitita-manaji piwamairi.” Iro kantacha, okimaki iina David paitachari Mical, okamantakiri, okantziri: “Airorika pisiya iroñaaka tsitiniri, onkitaitita-manaji iwamaitimi.” ");
INSERT INTO prq_vpl VALUES ("S119_12","010_19_12","1SA","19","12","12","Aaki Mical siwitha, iro owayiita-kotan-takariri intakiroini David, siyaka. ");
INSERT INTO prq_vpl VALUES ("S121_1","010_21_1","1SA","21","1","1","Ikanta David jataki nampitsiki Omitzithai-toni iñiiri Ompira-tasorintsitaari paitachari Ahimelec. Imapokakiri isitowa-sitakiri iwankoki, ikantawakiri Ompira-tasorintsitaari: “Tikatsi pintsipatyaa pipoki, ¿ipaitama pipokantari apaniroini?” ");
INSERT INTO prq_vpl VALUES ("S121_2","010_21_2","1SA","21","2","2","Ari yakanakiri David yoka Ahimelec, ikantziri: “Iriira pinkathari otyaantanari, ikantakina: ‘Ti noninti iyoiti opaita notyaan-tantamiri, opaita nokantzimiri.’ Irootaki nokaima-kaantan-takari yokaiti atziri tsika anta noñiiri. ");
INSERT INTO prq_vpl VALUES ("S121_3","010_21_3","1SA","21","3","3","¿Ipaitama pimpawa-kinari? Nonintzi noyaa.” ");
INSERT INTO prq_vpl VALUES ("S121_4","010_21_4","1SA","21","4","4","Ikantzi Ompira-tasorintsitaari: “Tikatsi nowariti, apatziro otzimi yatantaitari tasorin-tsita-tsiri anta Tasorintsi-thaantiki. Ari nompakimi piyaaro, tirika imaantyaaro kooya ikaratzi pitsipa-yitakari.” ");
INSERT INTO prq_vpl VALUES ("S121_5","010_21_5","1SA","21","5","5","Ikantzi David: “Chapinkitaki ti noñaajiro kooya. Kaarira opitsintaari yokaiti notsipatakari. Tima ti noñaanakiro notsipatari-payi nopokayita-nakira nokina-kina-yitaki, owatsipiro iroñaaka aka ti noñaajiro nompitsintaa-riti.” ");
INSERT INTO prq_vpl VALUES ("S121_6","010_21_6","1SA","21","6","6","Ipakiri yatantaitani Ompira-tasorintsitaari yasitakai-tariri Pawa. Irootaki iroka yatantaitani yaitairi minkontsitaa-niki Tasorintsi-thaantiki, onkini iwaiti owakirari saawata-tsiri. ");
INSERT INTO prq_vpl VALUES ("S128_3","010_28_3","1SA","28","3","3","Aritaki kamaki Samuel. Oshiki iwasiri-takotakari maaroni ishininka-payi. Ikitatakiri Tonkaironiitoniki inampiitiki Israel-iiti. Aritaki imisitowakiri irirori Saúl maaroni antyawiyaripayi, aajatzi ñaawyatan-taniri-payi. ");
INSERT INTO prq_vpl VALUES ("S128_4","010_28_4","1SA","28","4","4","Ikanta yapatojiitaka Kinawai-taniriiti, pokajiitaki iwanko-thaanti-yitaka Apimakoryaariniki. Iriima Saúl yapatotakiri maaroni ishininka-payi irirori, iwanko-thaanti-yitaka Jaaniya-piyoi-toniki. ");
INSERT INTO prq_vpl VALUES ("S128_5","010_28_5","1SA","28","5","5","Ikanta iñaakiro iwanko-thaanti-payi Kinawai-taniriiti, antaro oimiraa-siri-tanakiri, ayimatakiri itharonka. ");
INSERT INTO prq_vpl VALUES ("S128_6","010_28_6","1SA","28","6","6","Ari yamanawi-tanaka Saúl, titzimaita yakiri Pawa, ti imisimpyaa-najiri aajatzi. Ti oyotakaa-najiri mapiki poriryaari aajatzi Kamantan-tzinkari-payi, ti yakiri. ");
INSERT INTO prq_vpl VALUES ("S128_7","010_28_7","1SA","28","7","7","Irootaki ikantan-takariri Saúl impiratani, ikantziri: “Pijati, paminaiti ñaawyatan-taniro, irotaki nojatasiti nosampitiro.” Yakanakiri impiratani, ikantziri: “Tzimatsi ñaawyatan-taniro anta Chariñaariki.” ");
INSERT INTO prq_vpl VALUES ("S128_8","010_28_8","1SA","28","8","8","Ikithaa-tanaka Saúl pasini iithaari, airo iyotantaitari, itsipata-nakari pasini apiti ishininka, jatanaki tsitiniriki iñiiro kooya. Ikantapaakiro: “¡Ayomparó! Awiroka nopokasitzi piñaawya-tyaana. Nonintzi pinkaima-siritiri nonkantimiri naaka.” ");
INSERT INTO prq_vpl VALUES ("S128_9","010_28_9","1SA","28","9","9","Akanakiri kooya, okantziri: “Piyotzi awiroka opaita yantakiri Saúl aka. Tima ithonka ipyaakaa-sitakari yotantaniri-payi aajatzi ñaawyatan-taniri. ¿Irooma pikoshikan-tanari pinintzi iwamaitina aajatzi naaka?” ");
INSERT INTO prq_vpl VALUES ("S128_10","010_28_10","1SA","28","10","10","Ikantanakiro Saúl: “¡Omapiro-tatyaa nonkantimiri! Tikatsi kowiinkari awishimo-timini.” ");
INSERT INTO prq_vpl VALUES ("S128_11","010_28_11","1SA","28","11","11","Nintanaki kooya okantzi: “¿Paitama pinintziri nonkaima-siri-timiri impoki?” Ikantzi Saúl: “Nonintzi pinkaiminari jiwarini Samuel.” ");
INSERT INTO prq_vpl VALUES ("S128_12","010_28_12","1SA","28","12","12","Oñaatziiri kooya kaminkarini Samuel, antaroiti okaimanaki. Okantanakiri Saúl: ");
INSERT INTO prq_vpl VALUES ("S128_13","010_28_13","1SA","28","13","13","“¿Paitama pamatawi-tantanari? Saúl pinatzii awiroka.” Ikantanakiro irirori: “Airo pitharowantari. ¿Paitama piñaakiri?” Okantzi iroori: “Noñaakiri siritsi isitowa-paakiro kipatsiki.” ");
INSERT INTO prq_vpl VALUES ("S128_14","010_28_14","1SA","28","14","14","Ikantzi Saúl: “¿Tsika ikantawaitaka?” Okantzi iroori: “Antyasipari inatzii, ikithaataro yapitisamaatari.” Ari iyotanaki Saúl iriitaki jiwarini Samuel, ityiirowanaka ipinkatha-tanakiri, yoiyootanaka. ");
INSERT INTO prq_vpl VALUES ("S128_15","010_28_15","1SA","28","15","15","Ari iñaawai-tanaki kaminkarini Samuel, ikantziri: “¡Saúl! ¿Paita piñaasirinkan-tanari pikaima-kaantana?” Ikantzi Saúl: “Tima antaaro okantzimo-siri-takana, tima oshiki iwayiri-mintha-takana Kinawai-taniriiti. Yookanakina Pawa, ti yakajina nokowako-witari, ti imisimpyiina aajatzi. Nokanta-witari Kamantan-tzinkari, tikatsi akinani. Irootaki nokaima-kaantan-tamiri awiroka pinkantina paita-rika nantiri.” ");
INSERT INTO prq_vpl VALUES ("S128_16","010_28_16","1SA","28","16","16","Ikantzi jiwarini Samuel: “¿Paitama pisampi-tantanari naaka? Aritaki yooka-nakimi Pawa, kisaniinta iwanakimi. ");
INSERT INTO prq_vpl VALUES ("S128_17","010_28_17","1SA","28","17","17","Imatakimi Pawa okaratzi ikamanta-kinari naaka tsika inkantimi. Yookakaa-jimiro pipinkathariwita, ipinkathari-takaajiri David, pitsipa-minthatani. ");
INSERT INTO prq_vpl VALUES ("S128_18","010_28_18","1SA","28","18","18","Tima ti pinkimisantiri awiroka Pawa ikantawi-takamiri, ti pimonkaratiro papirotiri Otinkanaawini-satzi. Irootaki piñaantarori awiroka okaratzi awishimo-tzimiri iroñaaka. ");
INSERT INTO prq_vpl VALUES ("S128_19","010_28_19","1SA","28","19","19","Inintaki Pawa inthonkanti Kinawai-taniriiti. Iwamaajimi awiroka intsipataimiri pishininka-payi. Ari pintsipa-tajyaana naaka onkitaitita-manaji, aajatzi pitomi-payi. Tima isinitakiri Pawa Kinawai-taniriiti yiitsinampairi iwayiriti ashininka Israel-iiti.” ");
INSERT INTO prq_vpl VALUES ("S128_20","010_28_20","1SA","28","20","20","Antaro itharowanaki Saúl, ikimakiri jiwarini Samuel. Ithonka isipita-waitanaki, tyaanaki osaawiki, naryaa-tawato-tapaaka. Tima ti iwajyaa, maakotaki aparoni kitaitiri aajatzi aparoni tsitiniri. ");
INSERT INTO prq_vpl VALUES ("S128_21","010_28_21","1SA","28","21","21","Okanta oñaakiri kooya itharowanaki Saúl, opokasi-takiri, okantziri: “¡Pinkatharí! Nokimisanta-kimiro okaratzi pikowako-takinari, nosiniwintakami naaka, ");
INSERT INTO prq_vpl VALUES ("S128_22","010_28_22","1SA","28","22","22","ontzimatyii pinkimisantina awiroka. Nonintzi namimi piwawakyaari kapichiini, onkini pisintsitaji, pijatan-tajyaari.” ");
INSERT INTO prq_vpl VALUES ("S128_23","010_28_23","1SA","28","23","23","Ti inintawityaa iyaa Saúl, ikantzi: “Ti noninti noyaa.” Ari osintsiwintziri kooya aajatzi impiratani-payi iyaa. Irojatzi inintan-tanakari. Piriintanaka, thointaka imaapiintaitzi. ");
INSERT INTO prq_vpl VALUES ("S128_24","010_28_24","1SA","28","24","24","Owamaaki kooya wathantzi opira, otasitaki yatantaitari. ");
INSERT INTO prq_vpl VALUES ("S128_25","010_28_25","1SA","28","25","25","Aanakiniri Saúl iwawakyaa. Ari ikaratzi yakyoo-takiri impiratani-payi. Ikanta ithonka-kiro iwajiitaka, jaitijiitaji tsitini-paiti. ");
INSERT INTO prq_vpl VALUES ("S131_1","010_31_1","1SA","31","1","1","Ikanta Kinawai-taniriiti, iwayiri-mintha-takari Israel-iiti. Ari isiyanaka Israel-iiti iñaakiro oshiki ishininka iwamaitaki otzisiki Jaaniyapiyoitoniki. ");
INSERT INTO prq_vpl VALUES ("S131_2","010_31_2","1SA","31","2","2","Ipatzima-tanakiri Kinawai-taniriiti yoka Saúl aajatzi itomi-payi. Ari iwai-takiri Jonatán, Abinadab aajatzi Malquisúa itomi-payi Saúl. ");
INSERT INTO prq_vpl VALUES ("S131_3","010_31_3","1SA","31","3","3","Ari yapathawintai-tanakari Saúl imanaitziri, ikintaitakiri. Oshiki itharokan-taitakari. ");
INSERT INTO prq_vpl VALUES ("S131_4","010_31_4","1SA","31","4","4","Ikantanakiri iwayiriti inampiritari Saúl: “Pinosikiro piwisa-minto, pinthatzinkan-tyaanaro. Ti noninti iwisan-tyaanaro irasi kaari-piro-siriri-payi, ti noninti inthainka-mawaitina.” Titzimaita ininti iwayiriti inampiritari, tima oshiki itharowakan-takari aajatzi irirori. Yaakiro Saúl iwisa-minto irirori, isataakaro. ");
INSERT INTO prq_vpl VALUES ("S131_5","010_31_5","1SA","31","5","5","Ikanta owayiri inampiritari iñaakiri kamaki Saúl, isataanakaro irirori iwisa-minto. Ari itsipatakari ikamaki. ");
INSERT INTO prq_vpl VALUES ("S131_6","010_31_6","1SA","31","6","6","Ari okanta ikamantajari irirori Saúl, tima ari ikaratairi mawa itomi, inampiri, aajatzi maaroni iwayiriti-payi.");
INSERT INTO prq_vpl VALUES ("S25_1","011_5_1","2SA","5","1","1","Ikanta maaroni inasiyitachari icharini-payi Israel ijatasi-takiri David isaiki irirori Aripiro-taariniki, ikantapaakiri: “¡Pinkimi, naaka pishininkaiti okaakiini! ");
INSERT INTO prq_vpl VALUES ("S25_2","011_5_2","2SA","5","2","2","Tima awiroka jiwatakinari pairani awayirita ipinkathari-tantari pinkatharini Saúl. Irijatzi Pawa ñaanata-kimiri, ikantakimi: ¡David! Awiroka jiwatairini pishininka Israel-iiti, Pimpinkathari-wintajiri nasitari naaka.” ");
INSERT INTO prq_vpl VALUES ("S25_3","011_5_3","2SA","5","3","3","Imatakiro aajatzi antari-konaiti Israel-iiti, ijatasi-takiri David anta Aripiro-taariniki, ikantakiri: “¡Thami aapatyaa-wakaityaa! ¡Iriitaki yotatsi Pawa airo amatawita-wakaa!” Ari isaipatzii-totanakiri David impinkathari-wintairi maaroni ishininka-payi Israel-iiti. ");
INSERT INTO prq_vpl VALUES ("S25_4","011_5_4","2SA","5","4","4","Tima tzimaki David okaratzi 30 isarintsiti yitanta-nakarori ipinkatharitzi. Onkarati 40 osarintsi impinkathari-wintanti. ");
INSERT INTO prq_vpl VALUES ("S25_5","011_5_5","2SA","5","5","5","Tima anaanakiro 7 osarintsi ipinkathari-wintakiri Judá-iti Aripiro-taariniki. Irooma Aapatyaawiniki onkarati 33 osarintsi impinkathari-wintiri maaroni ishininka-payi Judá-iti aajatzi pasini-payi ishininka Israel-iiti. ");
INSERT INTO prq_vpl VALUES ("S25_6","011_5_6","2SA","5","6","6","Ikanta ijataki David Aapatyaawiniki itsipata-nakari iwayiriti imanatiri Kayaawinisatzi asitarori inampi anta. Isiyakaantzi Kayaawinisatzi airo imatziro David inkyii inampiki, ikantawakiri: “Airo pimatziro pinkyii nonampiki. Iri owayiri-matsi-tawakimini mawityaakiri-payi intsipa-takyaari kisoporokiri-payi.” ");
INSERT INTO prq_vpl VALUES ("S25_9","011_5_9","2SA","5","9","9","Iro kantacha David, imatakiro ikyaaki owayiri-pankoki tsika isaiki inkisako-wintyaaro nampitsi, ipaitakiro “Inampi David”. Itanto-takaan-takiro nampitsi, itanakaro otaapiki Tamakopathaniki irojatzi tonkaariki. ");
INSERT INTO prq_vpl VALUES ("S25_10","011_5_10","2SA","5","10","10","Tima aikiro otzimimo-tanaki-tziiri isintsinka David. Ari yasi iwiro Ñaapirori Pawa itsipatakari David. ");
INSERT INTO prq_vpl VALUES ("S27_1","011_7_1","2SA","7","1","1","Aritaki saikaki iwankoki pinkathari David. Ikantakaakaro Pawa imakoryaawaki kapichiini iwayiri-minthatari iisaniintani. ");
INSERT INTO prq_vpl VALUES ("S27_2","011_7_2","2SA","7","2","2","Ikinkitha-waita-kaakiri pinkathari David Kamantan-tzinkari Natán, ikantakiri: “Piñaakiro awiroka nowanko oyosiita santari-kota, irooma itasorintsi-mokoti Pawa iwanko-matsi-taitan-takaro misinantsi aajatzi manthakintsi.” ");
INSERT INTO prq_vpl VALUES ("S27_3","011_7_3","2SA","7","3","3","Ikantanaki Natán: “¡Pinkatharí! Pantiro awiroka okaratzi pikinkithasiritari, tima Pawa kantakai-yaaroni omatantyaari kamiithaini pantiri.” ");
INSERT INTO prq_vpl VALUES ("S27_4","011_7_4","2SA","7","4","4","Okanta otsitini-tanaki, iñaanatakiri Pawa Kamantan-tzinkari Natán, ikantziri: ");
INSERT INTO prq_vpl VALUES ("S27_5","011_7_5","2SA","7","5","5","“Pijati piñiiri nompiratani David, pinkantiri: ‘Pinkimi ikantzi Pawa. ¿Awirokama witsikainani pankotsi nosaikan-tyaari? ");
INSERT INTO prq_vpl VALUES ("S27_6","011_7_6","2SA","7","6","6","Tima irojatzi pairani naantaariri pishininka-payi isaikawitaka Apitantoniki, ti nosaikan-tyaaro pankotsi, apatziro nosaikanta-matsi-takaro tasorintsi-thaanti nokina-kina-waitaki tsika-rika-payi. ");
INSERT INTO prq_vpl VALUES ("S27_7","011_7_7","2SA","7","7","7","Tima oshiki notsipa-takari pishininka-payi, ti nonkowa-kotiri ikaratzi nowakiri ijiwatiri pishininka-payi iwitsikina santari-panko nosaikan-tyaari.’ ");
INSERT INTO prq_vpl VALUES ("S27_8","011_7_8","2SA","7","8","8","Pinkantiri iroñaaka nompiratani David: ‘Ikantzimi Ñaapirori Pawa: “Naakataki amakimiri pisaikawita paamaako-wintari pipira-payi, pipinkathari-wintairi pishininka-payi nasitari naaka. ");
INSERT INTO prq_vpl VALUES ("S27_9","011_7_9","2SA","7","9","9","Nasi nowiro notsipatami tsika-rika pikinayitzi, nasiryaakari ikaratzi owayiri-mintha-takamiri. Tima naaka kantakai-yaaroni inthonka inkimakoi-tantyaamiri tsika-rika-payi, pisiyako-taari iriipiroriiti saikatsiri aka kipatsiki. ");
INSERT INTO prq_vpl VALUES ("S27_10","011_7_10","2SA","7","10","10","Noñaaki tsika nowiriintajiri pishininka-payi nasitari naaka. Ari inampita-jyaaro, tikatsi oñaasirinkairini. Airo itzimaji kaari-pirori maimani-waitairini ikimitai-tziri pairani, ");
INSERT INTO prq_vpl VALUES ("S27_11","011_7_11","2SA","7","11","11","owakira nowayitakiri ikaratzi jiwayita-kiriri pishininka-payi Israel-iiti. Aritaki nonkanta-kaakyaaro pimakoryaa-waitaji awiroka iwayiri-mintha-waitami pikisaniintani.” ’ Ikantzi aajatzi Pawa: ‘Naaka witsikaimini piwanko pasi awiroka. ");
INSERT INTO prq_vpl VALUES ("S27_12","011_7_12","2SA","7","12","12","Niroka nosiyakaa-winta-kimiri piwanko: Aririka omonkara-tajyaa onkarati pantiri, pimakoryaaki-rika, aritaki intzimaji pitomi awiroka, iriitaki impoyii-tajyaamini impinkathariti irirori. ");
INSERT INTO prq_vpl VALUES ("S27_13","011_7_13","2SA","7","13","13","Iriitaki witsikinani nowanko tsika impinka-thaitairo nowairo. Aritaki nonkanta-kaakyaaro naaka, irasi iwiro impinkatha-wintanti incharini-tanajyaari. ");
INSERT INTO prq_vpl VALUES ("S27_14","011_7_14","2SA","7","14","14","Naaka tomitajyaarini, iriritajyaana irirori. Yantakiro-rika kaari-pirori, naakataki wasankitairini nosiyaari tsika ikanta atziri ipasatziri itomi. ");
INSERT INTO prq_vpl VALUES ("S27_15","011_7_15","2SA","7","15","15","Airotzimaita nokarata-kaaro nonisironka-tajyaari irirori. Airo nosiyakaari Saúl nokaratakiro nonisironkatari. Tima naaka pinkatharitakaakimiri pairani awiroka pimpoyii-tajari iroñaaka. ");
INSERT INTO prq_vpl VALUES ("S27_16","011_7_16","2SA","7","16","16","Irootaki nosiyakaa-wintzimiri piwanko. Tima iriitaki pitomi aajatzi pincharini-tajyaari pinkathari-taatsini. Inkimita-jyaami awiroka pipinkathari-wintantzi. Irasi iwiro ontzimi iwanko aajatzi iwinkathari-minto.’ ” ");
INSERT INTO prq_vpl VALUES ("S27_17","011_7_17","2SA","7","17","17","Imatakiro Natán, ikamantakiri David okaratzi ikantai-takiriri, okaratzi iñaakai-takiri aajatzi. ");
INSERT INTO prq_vpl VALUES ("S211_1","011_11_1","2SA","11","1","1","Okanta pasini osarintsi, ari omonkara-paititaja ijatanta-piintari pinkathari-payi imanatyaa. Ari ityaantakiri David jiwatziriri iwayiriti-payi ipaita Joab, itsipataakiri impiratani-payi aajatzi maaroni Israel-iiti. Tima ithonka yasiryaakari Pityaankaarini-satzi, itzimasi-takiri anta Oshikiwiniki. Iriima David irojatzi isaikaki irirori Aapatyaawiniki. ");
INSERT INTO prq_vpl VALUES ("S211_2","011_11_2","2SA","11","2","2","Okanta itainkaki ooryaatsiri, ipiriintanaka David inaryaa imaamintoki. Jataki okanta-pankaataka iwinkathari-pankoti yaminawaiti. Yaminaki antó, iñaaki okaawaita kooya, kamiithaa-niki okantaka. ");
INSERT INTO prq_vpl VALUES ("S211_3","011_11_3","2SA","11","3","3","Ityaantaki David sampiko-wintironi iroka kooya. Ikimatzii ikantaitzi: “Iroka kooya opaita Betsabé, irisinto Eliam. Iina Urías ishininka Tharowan-taarini-satzi.” ");
INSERT INTO prq_vpl VALUES ("S211_4","011_11_4","2SA","11","4","4","Ityaantaki David aakitironi kooya. Yakitai-tziro. Okanta ariitaka, imaanta-waitakaro David. Ikanta omonkara-takiro iroori omairinta, jataji owankoki. ");
INSERT INTO prq_vpl VALUES ("S211_5","011_11_5","2SA","11","5","5","Ari omotyaataki iroka kooya. Ontyaantaki kantirini David: “Motyaatakina.” ");
INSERT INTO prq_vpl VALUES ("S211_6","011_11_6","2SA","11","6","6","Ityaantaki David kantirini Joab: “Ikantzi pinkathari: ‘Paakitiri Urías, ishininka Tharowan-taarini-satzi.’ ” Imatakiro Joab, yaakitziri. ");
INSERT INTO prq_vpl VALUES ("S211_7","011_11_7","2SA","11","7","7","Ikanta yariitaka Urías isaiki pinkathari David, isampita-wakiri, ikantziri: “¿Saikatsi Joab, ti imantsiya-waiti? ¿Ti imantsiya-waiti owayiri-payi? ¿Tsika okantakotaka owayiri-taantsi?” ");
INSERT INTO prq_vpl VALUES ("S211_8","011_11_8","2SA","11","8","8","Aikiro ikantatzii David: “¡Urías! Pijati piwankoki, pimakoryaapaji kapichiini.” Ikanta isitowanaji Urías pinkathari-pankoki, ikantziri David impiratani: “Paanakiniri Urías iroopirori owaritintsi iwankoki.” ");
INSERT INTO prq_vpl VALUES ("S211_9","011_11_9","2SA","11","9","9","Titzimaita ijati Urías iwankoki, ari imaaki pinkathari-pankoki itsipayitari aamaako-wintariri pinkathari tsitini-paiti. ");
INSERT INTO prq_vpl VALUES ("S211_10","011_11_10","2SA","11","10","10","Ikamantai-takiri David, ikantai-tziri: “Ti imaapaji Urías iwankoki.” Ari isampitakiri David, ikantziri: “¡Urías! Owakira pariita awiroka. ¿Tsikapaitama kaari pijatanta pimaapaji piwankoki?” ");
INSERT INTO prq_vpl VALUES ("S211_11","011_11_11","2SA","11","11","11","Yakanaki Urías, ikantzi: “¡Pinkatharí! Atsipiryaantsi panko-thaantintsi osaikantari tasorintsi-moko, ari okantzitaka isaikantari owayiri-payi Judá-iti aajatzi pasini-payi Israel-iiti. Ari okantzitaka isaikantari Joab jiwatziriri piwayiriti. Tima aritaki nonkantzi-tyaari naaka. Irootaki kaari onimotantana nowawai-tapajyaa naaka nowanko, nomaapaji nomaanta-pajyaaro noina. ¡Omapiro-tatyaa nokantzimiri, tima awiroka pinkatharí. Airo nantzimiro pikanta-witanari!” ");
INSERT INTO prq_vpl VALUES ("S211_12","011_11_12","2SA","11","12","12","Ikantzi David: “Kamiithataki. Pimaanaji aajatzi iroñaaka, onkitaitita-manaji pijatai.” Imatakiro Urías, aajatzi imaanaji Aapatyaawiniki irojatzi pasini kitaitiri. ");
INSERT INTO prq_vpl VALUES ("S211_13","011_11_13","2SA","11","13","13","Ikantakiri David yoka Urías: “Pakyootina.” Ikaratakiro iwakaa, ipakotakiri oshiki iraitziri, isinkitakiri. Ikanta otsitini-tanaki, jatanaki Urías imayi tsika imaayitzi iwayiriti pinkathari, titzimaita ijataji iwankoki. ");
INSERT INTO prq_vpl VALUES ("S211_14","011_11_14","2SA","11","14","14","Okanta okitaitita-manaji, isankinataki David intyaantiniri Joab, iriitaki aanakirori Urías. ");
INSERT INTO prq_vpl VALUES ("S211_15","011_11_15","2SA","11","15","15","Iroka okantzi isankinari: “Iriitaki pijiwati Urías piwithainkiri tsika okowiinka-pirotzi owayiri-taantsi. Ari pikatziyiri apaniroini inkini inkintaitiri, inkamiita.” ");
INSERT INTO prq_vpl VALUES ("S211_16","011_11_16","2SA","11","16","16","Imatakiro Joab. Isonkakiro nampitsi itzimasi-tziri iwayiri-tyaari, iwakiri Urías tsika isaikaki iriipirori iwayiritani. ");
INSERT INTO prq_vpl VALUES ("S211_17","011_11_17","2SA","11","17","17","Ikanta isitowa-jiitanaki kisakotarori inampi, yitanakari imanatziri iwayiriti Joab. Ikintaitaki jiwayitziriri iwayiriti David, ikintai-takiriri aajatzi Urías. ");
INSERT INTO prq_vpl VALUES ("S211_18","011_11_18","2SA","11","18","18","Ityaantaki Joab ñaantsi iyotan-tyaari David ipaita awisain-tsiri manataantsiki. ");
INSERT INTO prq_vpl VALUES ("S211_19","011_11_19","2SA","11","19","19","Ikantawakiri aanakirori ñaantsi: “Aririka pinthonkakiro pinkamantiri pinkathari awisain-tsiri manataantsiki, ");
INSERT INTO prq_vpl VALUES ("S211_20","011_11_20","2SA","11","20","20","aamaasityaa ari inkisanakyaa. Ari inkanta-nakimi: ‘¿Paita pijatasi-tantariri okaakiini piwayiritari? ¿Tima piyoti kantatsi imanatimi atiitakaa-kirori ichakopiti otantoki nampitsi? ");
INSERT INTO prq_vpl VALUES ("S211_21","011_11_21","2SA","11","21","21","¿Pimaisanta-kiroma awisain-tsiri pairani Kitamaaro-winiki iwantai-takariri Abimelec, itomi Jerobaal? ¿Tima ookimotakiri kooya opitoki tononka-mintotsi osaikaki jinoki otantoki nampitsi? ¿Paitama pijatasi-tantariri okaakiini otantota inampi piwayiritani?’ Aririka imatiro inkantimi, pinkanta-nakiri aajatzi: ‘Kamaki Urías ishininka Tharowan-taarini-satzi jiwatziriri piwayiriti.’ ” ");
INSERT INTO prq_vpl VALUES ("S211_22","011_11_22","2SA","11","22","22","Tima jataki kamantirini pinkathari. Ikanta yariitaka, ikamantakiri David okaratzi ikantakiriri Joab ontyaanta-kiriri. ");
INSERT INTO prq_vpl VALUES ("S211_23","011_11_23","2SA","11","23","23","Ikantapaakiri: “¡Pinkatharí! Yanaako-takina isitowa-jiitanaki owayiriiti kisakotarori inampi. Iriitaki itawakaro imanata-wakina. Ikanta nopiyata-nakari, nomisiyakiri. Nopatzima-tanakiri, ariitakana ikyaa-piintzi inampiki. ");
INSERT INTO prq_vpl VALUES ("S211_24","011_11_24","2SA","11","24","24","Imanata-wakina saikain-tsiri jinoki otantoki inampi. Ari ikintai-takiri jiwatziriri piwayiriti. Imatzitai-takari aajatzi Urías ishininka Tharowan-taarini-satzi, kamaki.” ");
INSERT INTO prq_vpl VALUES ("S211_25","011_11_25","2SA","11","25","25","Ikantanakiri David amakirori ñaantsi: “Iroka noñaani pinkantiriri Joab. Pinkantiri, ikantzi pinkathari: ‘Airo okantzimo-siri-waitami. Ari asi owiro manataantsi. Ontzimatyii pijatakairo piwayiri-tyaari, irojatzi papirotan-takyaariri akisaniintani.’ Piwintha-takai-yaari awiroka ijatakairo iwayirityaa.” ");
INSERT INTO prq_vpl VALUES ("S211_26","011_11_26","2SA","11","26","26","Ari okimaki iina Urías, ikantai-takiro: “Kamaki piimi.” Antaro owasiri-takowai-takari. ");
INSERT INTO prq_vpl VALUES ("S211_27","011_11_27","2SA","11","27","27","Okanta okaratzi-motakiro omairi-wintari oimini, ikaimakaan-takiro David, imisaikairo iwinkathari-pankotiki, iinantakaro. Owaiyan-takiri itomi. Iro kantacha, ti onimotiri Pawa okaratzi yantakiri David. ");
INSERT INTO prq_vpl VALUES ("S212_1","011_12_1","2SA","12","1","1","Ikanta Pawa ityaantakiri Natán iñiiri David. Ikanta yariitaka Natán isaiki pinkathari, ikinkitha-waita-kaakiri, ikantziri: “Tzimatsi apiti atziri isaikiro nampitsiki. Ashaarantaniri inatzi aparoni, iriima pasini asinonkai-nkari inatzi. ");
INSERT INTO prq_vpl VALUES ("S212_2","011_12_2","2SA","12","2","2","Itzimimo-tziri oshiki ipira-payi yoka ashaarantaniri. ");
INSERT INTO prq_vpl VALUES ("S212_3","011_12_3","2SA","12","3","3","Iriima asinonkai-nkari apatziro yamanantaki aparoni yanini ipira. Ipiratakari. Ti yookani iwiri iintsiti-payi, yakyoo-tziri iwariti, yirakotziri imiri, ari itsipatari imaapiintzi, ikimita-kaantakari iroomi irisinto. ");
INSERT INTO prq_vpl VALUES ("S212_4","011_12_4","2SA","12","4","4","Okanta apaata, ipokaki ariitariri iwankoki ashaarantaniri. Ti ininti iwamai ipira iwapaakyaari ariitariri iwankoki. Iri yayitakiri ipira asinonkai-nkari. Iwamaakiri iwakaiyaari ariitariri.” ");
INSERT INTO prq_vpl VALUES ("S212_5","011_12_5","2SA","12","5","5","Antaro ikisanaka David ikimako-takiri yantakiri ashaarantaniri, ikantanakiri Natán: “¡Omapiro-tatyaa nonkantimi, ontzima-tyiira iwamaitiri antakirori iroka! ");
INSERT INTO prq_vpl VALUES ("S212_6","011_12_6","2SA","12","6","6","Ontzimatyii yoipyaaji 4 ipira, impinatan-tajyaariri asitariri, tima omapiro iwasinonkaakiri.” ");
INSERT INTO prq_vpl VALUES ("S212_7","011_12_7","2SA","12","7","7","Ari ikantzi Natán: “¡Pinkatharí! Awirokataki yoka atziri. Iroka iñaani Pawa, Iwawani Israel, ikantzimi: ‘Naaka owakimi pimpinkathari-wintiri pishininka-payi Israel-iiti, naaka ookakaa-winta-kimiri iwimimi Saúl. ");
INSERT INTO prq_vpl VALUES ("S212_8","011_12_8","2SA","12","8","8","Nopakimiro pinkathari-panko isaikan-tawitari piwinkathariti pairani, nopajii-takamiro iinanta-witari irirori. Nowakimi pimpinkathari-wintairi Judá-iti aajatzi pasini-payi Israel-iiti. Ti ari onkarati iroka, ari nompajimimi pasini anaironi iroka. ");
INSERT INTO prq_vpl VALUES ("S212_9","011_12_9","2SA","12","9","9","¿Paitama pipiyatha-tanta-kanari? ¿Paitama pikaaripiro-tzimo-tanta-kanari? Pikinta-kaantakiri Urías ishininka Tharowan-taarini-satzi piwayiri-tanta-kariri Pityaankaarini. Payitakiri iina. ");
INSERT INTO prq_vpl VALUES ("S212_10","011_12_10","2SA","12","10","10","Asi owatyairo iroñaaka iwamaan-taiti piwankoki, okantakaan-tziro pipiyatha-takana, payitzitakiri iina Urías, piinantakaro awiroka.” ");
INSERT INTO prq_vpl VALUES ("S212_11","011_12_11","2SA","12","11","11","Ikantaki aajatzi Pawa: “Naaka kantakai-yaaroni intzimi piwaiyani maimani-timini. Naaka kantakai-yaarini pishininka-payi yaapitha-tajimiro piina-payi. Iñaakawai-tajimiro imaantawai-tyaaro kitaipaiti. ");
INSERT INTO prq_vpl VALUES ("S212_12","011_12_12","2SA","12","12","12","Pimanani-kiini pantawi-takaro awiroka. Irooma naaka, airo nomanakaaro nantayi-tajiro, inthonka iñaayitajiro pishininka-payi Israel-iiti, kitaipaiti nantajiro.” ");
INSERT INTO prq_vpl VALUES ("S212_13","011_12_13","2SA","12","13","13","Ikantanaki David: “¡Omapiro-tatyaa! ¡Nokaaripiro-tzimo-takiri Pawa!” Ikantzi Natán: “Ipyaako-tajimiro awiroka Pawa piyaari-pironka, airo pikami. ");
INSERT INTO prq_vpl VALUES ("S212_14","011_12_14","2SA","12","14","14","Iriitaki kamatsini piinchaaniti owakira tzimain-tsiri. Okantakaan-tziro pantakiro kaari-pirori, ikisima-waita-nakiri iisaniintani Pawa.” ");
INSERT INTO prq_vpl VALUES ("S212_15","011_12_15","2SA","12","15","15","Ikanta ipiyaaro irirori Natán iwankoki, ikantakaakaro Pawa, omapoka-sitanaka imantsiya-tanaki yiinchaaniti David iwaiyan-takaakirori iina Urías. ");
INSERT INTO prq_vpl VALUES ("S212_16","011_12_16","2SA","12","16","16","Oshiki yamanawi-tanaka David ikowako-tziri Pawa airo ikamanta yiinchaaniti. Imashika-wintakiri. Ti imaaji tsika imaapiintzi, inaryaa-waitaka kipatsiki. ");
INSERT INTO prq_vpl VALUES ("S212_17","011_12_17","2SA","12","17","17","Ipokawitaka antari-kona-payi saika-panko-tziri iwiriintairi inaryaa-waitaka kipatsiki, ti ininti impiriinti. Ti yakyoo-tiri iwajiita antari-kona-payi. ");
INSERT INTO prq_vpl VALUES ("S212_18","011_12_18","2SA","12","18","18","Okanta omonkarataka 7 kitaitiri, kamaki iinchaa-niki. Ti inkaman-taitiri David, tima intharowa-kaita-tyiiyaari. Ikanta-wakaa-jiita impiratani: “Ainiro yañaawita iinchaa-niki, ti ininti inkimisantai akantawi-tariri. Ari imapirotyaa iroñaaka onkantzimo-siri-tyaari, ikamakira yiinchaaniti.” ");
INSERT INTO prq_vpl VALUES ("S212_19","011_12_19","2SA","12","19","19","Iro kantacha David, iñaakiri ikamanta-wakaa-jiita impiratani, iyotanaki kamaki yiinchaaniti. Isampitakiri, ikantziri: “¿Kamakima iinchaa-niki?” Ikantajiitzi impiratani: “Jii, kamaki.” ");
INSERT INTO prq_vpl VALUES ("S212_20","011_12_20","2SA","12","20","20","Ari ipiriintanaja David inaryaa-waitaka kipatsiki, ikaataka, itziritaka kasankari, ikithaataka pasini iithaari. Jataki itasorintsi-pankotiki Pawa, ipinkatha-takiri. Ipiyapaaka iwankoki, ikantapaaki: “Pimpina noyaari.” Ipaitakiri owaritintsi, owaka. ");
INSERT INTO prq_vpl VALUES ("S212_21","011_12_21","2SA","12","21","21","Ikanta impiratani-payi David, isampitakiri ikantziri: “¿Paitama pantziri? Ainiro yañaawita iinchaa-niki, ti pininti piwajyaa, oshiki piraawaitaka. Irooma piñaakiri ikamaki, ari pipiriintanaja, owawaita-najami.” ");
INSERT INTO prq_vpl VALUES ("S212_22","011_12_22","2SA","12","22","22","Yakanaki David, ikantzi: “Ainiro yañaawita iinchaa-niki, oshiki nomashika-wintakiri, niraawaitaka, nokanta-siritzi: ‘Inkamintha inisironka-tajyaana Pawa, airo ikami iinchaa-niki.’ ");
INSERT INTO prq_vpl VALUES ("S212_23","011_12_23","2SA","12","23","23","Iro kantacha, kamaki iroñaaka, ¿paitama nomashika-wintiri? ¿Arima nopiriintajiri? ¡Apatziro noyaawintyaa nojati noñaapajiri. Tima airo ipiyaja irirori iñaapajina!” ");
INSERT INTO prq_vpl VALUES ("S212_24","011_12_24","2SA","12","24","24","Ikanta iwoshinkaaro David iina Betsabé, imaantajaro. Ari itzimairi pasini itomi, ipaitakiri Salomón. Oshiki inisironka-takari Pawa. ");
INSERT INTO prq_vpl VALUES ("S212_25","011_12_25","2SA","12","25","25","Ityaantajiri Pawa yoka Natán, ikantairi David: “Iriitaki Pawa owaitakaan-takiriri pitomi ‘Nisironka-taari’ ”. Tima iroka wairontsi Nisironka-taari, irootaki ikantziri iñaaniki iriroriiti “Jedidías”.");
INSERT INTO prq_vpl VALUES ("K11_1","012_1_1","1KI","1","1","1","Tima antari-kona-piro-tapaaki pinkathari David, oshikitaki isarintsiti. Ipiwiryaa-kowitaitari oshiki iithaari, titzimaita isaawati. ");
INSERT INTO prq_vpl VALUES ("K11_2","012_1_2","1KI","1","2","2","Ikantakiri impiratani: “¡Pinkatharí! ¿Pinintzi naminimi mainaro? Irootaki aminimini, ompasikaimi, ontsipa-tyaami pimayi osaawantimi.” ");
INSERT INTO prq_vpl VALUES ("K11_3","012_1_3","1KI","1","3","3","Jataki yamina-minatzi kamiithaa-niki mainaro maaroni inampiki Israel-iiti. Iñaaki mainaro paitachari Abisag poñaachari Apimakoryaariniki. Irootaki yamakiniriri pinkathari. ");
INSERT INTO prq_vpl VALUES ("K11_4","012_1_4","1KI","1","4","4","Omapiro okamiithaa-nikitzi Abisag. Irootaki aminapaa-kiniriri okaratzi inintayi-tziri pinkathari, titzimaita iinantyaaro. ");
INSERT INTO prq_vpl VALUES ("K11_32","012_1_32","1KI","1","32","32","Ipoñaa ikantaki pinkathari David: “Pinkaiminari Ompira-tasorintsi-taari Sadoc, Kamantan-tzinkari Natán, Benaía itomi Joiada.” Ari ipokajiitaki irirori iñiiri pinkathari. ");
INSERT INTO prq_vpl VALUES ("K11_33","012_1_33","1KI","1","33","33","Ikantawakiri: “¡Ashininká! Pintsipa-tanakyaari nompiratani-payi, inkyaakai-yaari nopira notomi Salomón, paanakiri Sipopo-jaariniki. ");
INSERT INTO prq_vpl VALUES ("K11_34","012_1_34","1KI","1","34","34","Awiroka Sadoc Ompira-tasorintsi-taari aajatzi Kamantan-tzinkari Natán, pisai-patzii-totiri notomi Salomón omatantyaari impinkathari-wintairi ashininka-payi Israel-iiti. Pintyoo-jiiti anta, pinkaima-jiiti aajatzi, pinkanti: ‘¡Yokawí pinkathari Salomón!’ ");
INSERT INTO prq_vpl VALUES ("K11_35","012_1_35","1KI","1","35","35","Impoña piyaataa-jiitiri itaapiiki impiyi, irojatzi isaikan-tapaa-kyaari nowinkathari-mintoki, tima iriitaki impoyii-tajyaanani. Tima iriitaki noyosii-takiri impinkathari-wintairi ashininka-payi Judá-iti, aajatzi pasini-payi Israel-iiti.” ");
INSERT INTO prq_vpl VALUES ("K11_36","012_1_36","1KI","1","36","36","Ari yakanaki Benaía itomi Joiada, ikantzi: “¡Pinkatharí! Aritaki onkantyaari. Iriitaki Piwawani nintakaan-tzirori. ");
INSERT INTO prq_vpl VALUES ("K11_37","012_1_37","1KI","1","37","37","Iriitaki Pawa tsipata-piintakami awiroka, onkamintha ari inkimitairiri aajatzi Salomón, inkanta-kaiyaaro imapirotiro impinkatharitai irirori.” ");
INSERT INTO prq_vpl VALUES ("K11_38","012_1_38","1KI","1","38","38","Ikanta Ompira-tasorintsi-taari Sadoc, Kamantan-tzinkari Natán, Benaía itomi Joiada, Piyakaasitaniri-payi, Shintsiri-payi, ikyaakaakari Salomón ipira pinkathari David, yaanakiri Sipopo-jaariniki. ");
INSERT INTO prq_vpl VALUES ("K11_39","012_1_39","1KI","1","39","39","Ari yaaki Ompira-tasorintsi-taari Sadoc chiitsi aajatzi yiinkantsi, saikatsiri tasorintsi-thaantiki, isaipatzii-totakiri Salomón. Ari ikaratzi ityoojii-tanaki maaroni anta, ikaimajii-tanaki ikantajiitzi: “¡Yokawí pinkathari Salomón!” ");
INSERT INTO prq_vpl VALUES ("K12_1","012_2_1","1KI","2","1","1","Tima irootaintsi inkami pinkathari David, ikaimakaan-takiri Salomón, ikantziri: ");
INSERT INTO prq_vpl VALUES ("K12_2","012_2_2","1KI","2","2","2","“¡Notomí! Kimitaka irootaintsi nomoronki, nojatatyii tsika ikinayitzi maaroni atziri. Tonta-siri pinkantyaa awiroka, sirampari pinatyii. ");
INSERT INTO prq_vpl VALUES ("K12_3","012_2_3","1KI","2","3","3","Panta-piintairo impira-tamiri Pawa, pinthotyaa-yitairo iwinkakaantani, ikantakaantani, isinita-kaantani aajatzi isintsi-thatan-tziri, okaratzi osankina-tainchari ñaantsi iyomitaajairi awaisatzitini Moisés, irootaki ojatan-tyaari kamiitha opaita-rika pantayi-tajiri, tikatsi awishimo-timini tsika-rika pinkinayiti. ");
INSERT INTO prq_vpl VALUES ("K12_4","012_2_4","1KI","2","4","4","Ari imonkara-tirori Pawa okaratzi ikasiya-kaakinari, ikantakina: “Iriipiro-rika inkimisantajina inkarati pincharini-tajyaari, kamiitha-rika isirita-jyaana, yawintaa-siri-tajyaana, irasi iwiro inkarati pincharini-tajyaari impinkathari-wintairi pishininka-payi Israel-iiti.” ");
INSERT INTO prq_vpl VALUES ("K12_10","012_2_10","1KI","2","10","10","Aritaki makoryaaki David. Ikitaitakiri ipaitai-tziro “Inampi David”. ");
INSERT INTO prq_vpl VALUES ("K12_11","012_2_11","1KI","2","11","11","Osamani ipinkathari-wintakiri David pairani ishininka-payi Israel-iiti okaratzi 40 osarintsi. Yitakaro ipinkatharitaki nampitsiki Aripiro-taariniki okaratzi 7 osarintsi, aajatzi nampitsiki Aapatyaawiniki okaratzi 33 osarintsi. ");
INSERT INTO prq_vpl VALUES ("K12_12","012_2_12","1KI","2","12","12","Ikanta yitanakaro ipinkathari-tanaki Salomón, impoyii-taari iriri. Iriitaki matakirori isaikakaantaki kamiitha. ");
INSERT INTO prq_vpl VALUES ("K15_1","012_5_1","1KI","5","1","1","Ari ikimakiri Hiram pinkathari-tatsiri Mapiniki ikantaitzi: “Isaipatzii-toitakiri Salomón, impoyii-taari iriri.” Tima yoka Hiram oshiki itakota-piintakari pinkatharini David, ityaantaki inampiri-payi iñiiri Salomón. ");
INSERT INTO prq_vpl VALUES ("K15_2","012_5_2","1KI","5","2","2","Ikanta Salomón irirori, ityaantaki kamantirini Hiram, inkantiri: ");
INSERT INTO prq_vpl VALUES ("K15_3","012_5_3","1KI","5","3","3","“Piyotzi awiroka ti imatiro asitanarini David iwitsikiniri itasorintsi-pankoti Pawa tsika impinka-thaitiro iwairo, okantakaan-tziro imana-mintha-tziri iisaniintani. Iro kantacha, Pawa kantakaarori yiitsinampaan-takariri maaroni owayirita-piintariri. ");
INSERT INTO prq_vpl VALUES ("K15_4","012_5_4","1KI","5","4","4","Irootaki isaikakaan-taanari Pawa kamiitha. Tikatsi owayiri-tajinani, ti natsipi-tajyaaro kowiinkari-payi. ");
INSERT INTO prq_vpl VALUES ("K15_5","012_5_5","1KI","5","5","5","Irootaki nonintantari nowitsikiniri itasorintsi-pankoti Pawa tsika impinka-thaitairo iwairo, tima ikasiya-kaakiri pairani asitanari, ikantakiri: ‘Iriitaki pitomi impoyii-tajyaamini apaata impinkathari-wintanti, iriitaki witsikai-naroni notasorintsi-pankoti, tsika impairyai-tairo nowairo anta.’ ");
INSERT INTO prq_vpl VALUES ("K15_6","012_5_6","1KI","5","6","6","¡Pinkatharí! Pinkantiri patziriti-payi intowina inchato-payi tzimatsiri anta Kitiniitoniki, aritaki yamitako-takiri natziriti-payi naaka. Tsika-rika onkarati pinintiri nompinatimi yanta-wairi patziriti, aritaki nomatakiro. Piyotzi awiroka tikatsi noshininka-payi yotironi intowiro kamiitha isiyako-tyaari pisaika-nampi-tziri Simaa-satziiti.” ");
INSERT INTO prq_vpl VALUES ("K16_1","012_6_1","1KI","6","1","1","Aritaki imatakiro Salomón ipinkathari-wintziri ishininka-payi Israel-iiti okaratzi 4 osarintsi, iriitaki apitita-tsiri kasiri, ipaitai-tziri “Sipakiryaari”. Aripaiti yitanakaro Salomón iwitsikiniri itasorintsi-pankoti Pawa. Tima aritaki osamanitaki okaratzi 480 osarintsi isitowan-taari Israel-iiti Apitantoniki. ");
INSERT INTO prq_vpl VALUES ("K16_38","012_6_38","1KI","6","38","38","Ikanta awisaki 11 osarintsi ipinkatharitzi Salomón, iriitaki 8-tatsiri kasiri ipaitai-tziri “Awiitaantsi”, ithonkai-takiro iwitsikai-tziro tasorintsi-panko, iwitsikai-takiro tsika okanta ikinkitha-siri-taitaka iwitsikaitiro. Tima okaratzi 7 osarintsi osamanitaki ithonkan-taita-karori iwitsika-kaantakiro pinkathari Salomón. ");
INSERT INTO prq_vpl VALUES ("K110_1","012_10_1","1KI","10","1","1","Okanta pinkatharo poñaachari ipaitai-tziro Sabá okima-kotakiri ikinkithata-koitziri pinkathari Salomón, tima okaratzi iyota-nitari irirori irootaki kantakaarori iroopirori isintsinka Pawa. Irootaki onintan-tanakari oñiiri. Onintzi onkompita-kaiyaari onkarati osampiyitiriri, oñaantyaariri omapiro-rika iyota-nita. ");
INSERT INTO prq_vpl VALUES ("K110_2","012_10_2","1KI","10","2","2","Okanta ariitaka nampitsiki Aapatyaawini otsipayitakari onampiri-payi, amayitaki oshiki ikyaakoitari-payi okyaakaa-yitakiri owaararo, amaki kasankari, oshiki ooro, aajatzi pinapiro-yitachari mapi. Okanta oñaapaakiri Salomón, omatakiro osampita-paakiri Salomón okaratzi okinkithasiritzi-takari osampitiriri. ");
INSERT INTO prq_vpl VALUES ("K110_3","012_10_3","1KI","10","3","3","Tima ithonkaa yakakiro Salomón okaratzi osampita-paakiriri. Tikatsi aparoni kompitzi-motyaarini. ");
INSERT INTO prq_vpl VALUES ("K110_4","012_10_4","1KI","10","4","4","Okanta iroñaaka iroka pinkatharo poñaachari Sabá, oñaakiri omapiro iyota-nitaka Salomón, oñaakiro aajatzi iwinkathari-pankoti okaratzi iwitsika-kaantakiri. ");
INSERT INTO prq_vpl VALUES ("K110_5","012_10_5","1KI","10","5","5","Tima añaakiro aajatzi okaratzi iwayitari, okaratzi isaikan-tayitari inampiri-payi, tsika ikantayita impiratani-payi okaratzi ikithaa-yitari aajatzi, ikaratzi kitapiintzi-niriri iraitziri. Añaakiro ipomitai-tziri yatsipita-kayitani katziyain-kata-chari anta Tasorintsi-pankoki. Tima okiryaantsi okantanaka iroori. ");
INSERT INTO prq_vpl VALUES ("K110_6","012_10_6","1KI","10","6","6","Ari okantanakiri pinkathari: “Okaratzi nokima-kotzimiri nonampiki okaratzi pantayitakiri, okaratzi piyota-nitari, omapirotatyaa. ");
INSERT INTO prq_vpl VALUES ("K110_7","012_10_7","1KI","10","7","7","Tira nonkimisanta-wityaaro, iro kantacha noñaakiro iroñaaka, nokitakaro naaka, ari noyotzi omapirotatyaa. Tira ithotyii-tinaro inkaman-taitinaro maaroni. ¡Omapiro piyota-nitaka awiroka, omapiro otzimi-motzimi piwaararo okaratzi nokima-kota-kimiri! ");
INSERT INTO prq_vpl VALUES ("K111_1","012_11_1","1KI","11","1","1","Okanta apaata, yoka pinkathari Salomón oshiki kooya inintaki. Inintakiro irisinto iwinkathariti Apitantoni-satzi. Imatzitakaro inintakiro Athataa-wini-sato, Pityaankaarini-sato, Kiraarini-sato, Simaa-sato, Tharowan-taarini-sato. ");
INSERT INTO prq_vpl VALUES ("K111_2","012_11_2","1KI","11","2","2","Irootaki ipinkakaa-witakariri Pawa pairani Israel-iiti, ikantakiri: “Piwinkani piwiro maaroni kooya poñaachari pasiniki nampitsi, omata-kayimiro = kari pimpinkathatiri awiroka pawaniro-payi.” Iro kantacha Salomón, oshiki inintakiro iroka-payi kooya, iinantakaro. ");
INSERT INTO prq_vpl VALUES ("K111_3","012_11_3","1KI","11","3","3","Okaratzi 700 iinapiro-takari, pasini okaratzi 300 kaari iinapirota, irootaki iinapayi oitzinampa-siri-takiriri. ");
INSERT INTO prq_vpl VALUES ("K111_4","012_11_4","1KI","11","4","4","Ikanta yantyasipari-tapaaki Salomón, oitzinampa-siri-takiri iinapayi impinkatha-waitiri pawaniro-payi. Ti inkamiitha-siri-tzimo-tajiri Pawa, ti isiyaari David, iririni. ");
INSERT INTO prq_vpl VALUES ("K111_5","012_11_5","1KI","11","5","5","Ipinkatha-waitakiri Salomón pawaniro Impokiromara, iwawa-niroti Simaa-satzi. Ipinkatha-waitakiri aajatzi pawaniro ipaitai-tziri “Pinkathari Itaawintai-tziri Iinchaa-niki-payi”, iriitaki iwawa-niroti Pityaankaarini-satzi. Iriiyitaki pawaniro-payi impinka-yitimi. ");
INSERT INTO prq_vpl VALUES ("K111_6","012_11_6","1KI","11","6","6","Yantasi-takaro Salomón kaari onimotirini Pawa, ti yiriipiroti isirityaari, ti isiyaari David, iririni. ");
INSERT INTO prq_vpl VALUES ("K111_7","012_11_7","1KI","11","7","7","Iwitsikaki Salomón iyarapapankoti pawaniro ipaitai-tziri “Oitsinampaan-taniri” anta tonkaariki Aapatyaawiniki tsika isitowa-piintzi ooryaatsiri. Tima pinkaari inatzii iwawa-niroti Athataa-wini-satzi. Ipoñaa iwitsikakiri aajatzi isiyakaaro pawaniro ‘Pinkathari Itaawintai-tziri Iinchaa-niki-payi’, tima pinkaari inatzii aajatzi iwawa-niroti Pityaankaarini-satzi. ");
INSERT INTO prq_vpl VALUES ("K111_8","012_11_8","1KI","11","8","8","Ari ikimitaakiri aajatzi asi maaroni iinapayi poñaayi-tachari pasiniki nampitsi, iriitaki otaapiintziniri kasankai-nkari, opomiyi-tziniriri owawa-niroti atsipita-kaani-payi. ");
INSERT INTO prq_vpl VALUES ("K111_9","012_11_9","1KI","11","9","9","Ari ikisanakiri Pawa yoka pinkathari Salomón, okantakaan-tziro ti imiraawinta-jyaari, ti inkinkithasiri-tairi Iwawani Israel, iwashaantakiri ikimisantziri, tsika itzimi oñaakawi-takariri apiti-satzi. ");
INSERT INTO prq_vpl VALUES ("K111_10","012_11_10","1KI","11","10","10","Ikantawi-takari: “Airo pipinkatha-tziri pawaniro-payi.” Iro kantacha Salomón, ipiyatha-takari Pawa ikantawi-tariri. ");
INSERT INTO prq_vpl VALUES ("K111_11","012_11_11","1KI","11","11","11","Irootaki ikantan-takariri Pawa, ikantziri: “¡Salomón! Omapiro pipiyathataka, ti pinthotyiiro nokasiyakaimiri, ari pikimitaakiro nosankina-takaantani nokanta-witakamiri. Ari okarata-paaki nopinkathari-takaakimi, iriitaki nompinkathari-takaaji iroñaaka pimpiratani. ");
INSERT INTO prq_vpl VALUES ("K111_12","012_11_12","1KI","11","12","12","Iro kantacha, airo nooka-kayi-tamiro awiroka, oshiki notakotakari asitamiri David, iriitakira pitomi nooka-kayiri ipinkatharitzi tikira-mintha imonkaratiro. ");
INSERT INTO prq_vpl VALUES ("K111_13","012_11_13","1KI","11","13","13","Airotzimaita nowashaanta-kairi maaroni ipinkathariti. Aritaki nookanaki aparoni ikaratzi ishininkata-wakaiyita, iriitaki Judá-iti. Irootaki nantiri tima oshiki notakotakari pairani David, nompiratani. Notakotzi-takaro aajatzi inampi, Aapatyaawini.” ");
INSERT INTO prq_vpl VALUES ("K111_26","012_11_26","1KI","11","26","26","Imatakiro Jeroboam, itomi Nabat, poñaachari Posini-pathaniki. Tima yoka Jeroboam, impiratani Salomón, ipoñaaro nampitsiki Katsinkawiniki, ishininka inatzii icharini-payi Efraín. Kinankaro onatzii asitariri opaita Zerúa. ");
INSERT INTO prq_vpl VALUES ("K111_27","012_11_27","1KI","11","27","27","Iroka opoñaantari Jeroboam imaimani-tziri pinkathari: Tima itanto-takitziiro Salomón maaroni inampi David, iririni, iwitsikakiro Tamako-pathani. ");
INSERT INTO prq_vpl VALUES ("K111_28","012_11_28","1KI","11","28","28","Yoka Jeroboam, sintsiri inatzii atziri, tikatsi pomirintsi-tzimo-tyaarini. Ikanta iñaakiri Salomón yoka mainari siritha ikantaka, impira-takari yaminayitiro okaratzi yasiyitari icharini-payi José, iwaisatzitini. ");
INSERT INTO prq_vpl VALUES ("K111_29","012_11_29","1KI","11","29","29","Okanta apaata, jataki Jeroboam ikinawaitzi ipoñaanakaro Aapatyaawiniki. Ari imonthaakari Kamantan-tzinkari Ahías, poñaachari Makoryiironiki. Iñaakiri ipokaki ipasikakaro owakira-mairi ipasika-minto. Apaniro imonthaa-wakaaka, tikatsi intsipatyaa. ");
INSERT INTO prq_vpl VALUES ("K111_30","012_11_30","1KI","11","30","30","Yaakiro Ahías owakirari ipasikakari, isaraakiro, okaratzi 12-kotamasiti. ");
INSERT INTO prq_vpl VALUES ("K111_31","012_11_31","1KI","11","31","31","Ikantziri Jeroboam: “Payi awiroka 10 okota, tima irootaki ikantakiri Pawa, Iwawani Israel, ikantzi: ‘Ari nosaraajiro naaka iwinkathari-minto Salomón, tima awiroka nonintaki pimpinkathari-wintairi inkarati 10 ishininkata-wakaa-jiita Israel-iiti. ");
INSERT INTO prq_vpl VALUES ("K111_32","012_11_32","1KI","11","32","32","Iriima Salomón, apatziro aparoni impinkathari-wintairi irirori ikantakaan-tziro notakotani nompiratani David, impinkathari-wintairo aajatzi Aapatyaawini, tima irootaki nampitsi nonintakiri. Ti osiyaaro pasini inampitsiti ishininka-payi Israel-iiti. ");
INSERT INTO prq_vpl VALUES ("K111_33","012_11_33","1KI","11","33","33","Tima ipiyatha-takana Salomón, itharowinta-sitaka ipinkatha-waitziri Impokiromara, iwawa-niroti Simaa-satzi, Oitsinampaan-taniri, iwawani Athataa-wini-satzi. Imatzitakari “Pinkathari Itaawintai-tziri Iinchaa-niki-payi”, iwawani Pityaankaarini-satzi. Okaratzi yantakiri Salomón, ti onimo-tina noñaakiro, ti inthotyaa-kotina nosankina-takaantani aajatzi nosinita-kaantani, ti isiyaari David, iririni. ");
INSERT INTO prq_vpl VALUES ("K111_34","012_11_34","1KI","11","34","34","Iro kantacha, airo naapitha-tziri ipinkatharitzi. Tima tikira iñiiro inkami, aikiro ijiwari-tatyii, okantakaaro notakotari pairani asitaririni, David, nompiratani, tsika itzimi nasitakari naaka, tsika itzimi othotyaa-kirori nokanta-kaantani aajatzi nosankina-takaantani. ");
INSERT INTO prq_vpl VALUES ("K111_35","012_11_35","1KI","11","35","35","Airotzimaita ipinkatharitaji itomi Salomón, awiroka nonintaki pimpinkathari-wintairi inkarati 10 ishininkata-wakaa-jiita Israel-iiti. ");
INSERT INTO prq_vpl VALUES ("K111_36","012_11_36","1KI","11","36","36","Apatziro nosinita-wajiri itomi impinkathari-wintiri aparoni ikaratzi ishininkata-wakaa-jiita, airo otsiwakanta itaa-minto David Aapatyaawiniki, tima irootaki nampitsi nasitakari tsika osaikakotaki nowairo.’ ” ");
INSERT INTO prq_vpl VALUES ("K111_40","012_11_40","1KI","11","40","40","Irootaki kantakaan-tzirori, inintantari Salomón iwiiri Jeroboam. Iro kantacha siyaka Jeroboam ikinaki Apitantoniki tsika ipinkatharitzi Sisac. Ari isaikakiri anta irojatzi ikamantaari Salomón. ");
INSERT INTO prq_vpl VALUES ("K111_42","012_11_42","1KI","11","42","42","Iroka okaratzi ipinkathari-wintakiri Salomón maaroni Israel-iiti nampitsiki Aapatyaawini okaratzi 40 osarintsi. ");
INSERT INTO prq_vpl VALUES ("K111_43","012_11_43","1KI","11","43","43","Ikanta imakoryaaji irirori, ikitaitakiri inampitsitiki asitaririni, David. Iimpoyiitari ipinkatharitaji itomi, ipaita Roboam. ");
INSERT INTO prq_vpl VALUES ("K112_1","012_12_1","1KI","12","1","1","Jataki Roboam anta Sikochaariniki, ari ithonka ijayitaki maaroni ishininka-payi irirori iwinkathariti-tyaari anta. ");
INSERT INTO prq_vpl VALUES ("K112_2","012_12_2","1KI","12","2","2","Oyotzimaitaka Jeroboam itomi Nabat, isaikakira irirori Apitantoniki isiya-pithatari pinkathari Salomón, ari inampita-karori anta. ");
INSERT INTO prq_vpl VALUES ("K112_3","012_12_3","1KI","12","3","3","Ari ityaantaitaki kaimirini Jeroboam. Pokaki tsika yapatojiitaka maaroni ishininka-payi irirori. Ari isampitai-takiri Roboam, itomi pinkatharini Salomón, ikantai-tziri: ");
INSERT INTO prq_vpl VALUES ("K112_4","012_12_4","1KI","12","4","4","“Oshiki imapiro-takina iwasinonkaa-waitana asitamirini. Nonintzi piwatsinaryaa-kotajina okaratzi isintsiwinta-waitana impiratana. Aririka pimatakinaro, awiroka ompirata-jyaanani.” ");
INSERT INTO prq_vpl VALUES ("K112_5","012_12_5","1KI","12","5","5","Yakanaki Roboam, ikantziri: “Pimpiyanaki maaroni awirokaiti ashininká. Aririka awisaki mawa kitaitiri, ari nonintzi pimpoki piñiina.” Piyajii-tanaka maaroni ishininka-payi. ");
INSERT INTO prq_vpl VALUES ("K112_6","012_12_6","1KI","12","6","6","Ikanta pinkathari Roboam, inintaki iyomitaa-najiri antari-kona-payi inampinatari pairani Salomón, iririni, ainiro yañaawita irirori. Ikantakiri: “¡Ashininká! ¿Paitama piyomitaa-najinari awirokaiti nonkantiriri atziri-payi?” ");
INSERT INTO prq_vpl VALUES ("K112_7","012_12_7","1KI","12","7","7","Ikantajiitzi antari-kona-payi: “Aririka pisiyako-tyaari tsika ikantayita impiratani pishininka-payi, aritaki pantinirimi inintayi-tziri, ari pakakirimi kamiithaini isampitakimi, pasi piwiromi pimpira-jiityaarimi iriroriiti.” ");
INSERT INTO prq_vpl VALUES ("K112_8","012_12_8","1KI","12","8","8","Iro kantacha Roboam, ti inkimisantiri antari-kona-payi iyomitaa-witanaariri. Iri inintaki iyomitaa-najiri mainari-payi ikaratzi ikimota-jiitaki pairani, tsika itzimi inampina-yitari irirori. ");
INSERT INTO prq_vpl VALUES ("K112_9","012_12_9","1KI","12","9","9","Isampiyi-takiri, ikantziri: “¿Paitama piyomitaa-najinari awiroka-payi nonkantiriri ashininka-payi ikantakina: ‘Piwatsinaryaa-kotajina okaratzi impira-waitakana pairani asitamirini.’?” ");
INSERT INTO prq_vpl VALUES ("K112_10","012_12_10","1KI","12","10","10","Yakanaki mainari-payi ikaratzi pairani Roboam ikimota-jiitaki, ikantzi: “Iroka pinkantiri pakiri ashininka-payi kantzimiri: ‘Imapiro-takina asitamiri impira-waitakana pairani.’ Pinkantiri awiroka: ‘Isintsiwintakimi pairani asitanarini impiratami, naaka mapirotimini nompira-tyaami. ");
INSERT INTO prq_vpl VALUES ("K112_11","012_12_11","1KI","12","11","11","Imapiro-takimi asitanarini ikima-tina-takaami, aikiro nonkima-tina-takaa-tyiiyaami naaka. Ipasawai-tanta-kamiri asitanarini wathaki-rontsi, irooma naaka nompasa-tanta-jyaamiro opatzitha asiro.’ ” ");
INSERT INTO prq_vpl VALUES ("K112_12","012_12_12","1KI","12","12","12","Okanta awisaki mawa kitaitiri piyaja Jeroboam itsipataari maaroni ishininka-payi tsika isaiki pinkathari Roboam, tima aritaki ikantzi-takari chapinki, ikantakiri: “Aririka awisaki mawa kitaitiri, pimpiyi piñiina.” ");
INSERT INTO prq_vpl VALUES ("K112_13","012_12_13","1KI","12","13","13","Iro kantacha, titzimaita yaki kamiitha Roboam itomi pinkatharini Salomón, ikowako-witariri ishininka-payi, ti inkimisantiri ikampinaa-witakariri antari-kona-payi. ");
INSERT INTO prq_vpl VALUES ("K112_14","012_12_14","1KI","12","14","14","Yakanta-sitakari okaratzi iyomitaa-nakiriri mainari-payi, ikantakiri: “Imapiro-takimi asitanari ikima-tina-takaami, aikiro nonkima-tina-takaa-tyiiyaami naaka. Ipasawai-tanta-kamiri asitanari wathaki-rontsi, irooma naaka nompasa-tanta-jyaamiro opatzitha asiro.” ");
INSERT INTO prq_vpl VALUES ("K112_15","012_12_15","1KI","12","15","15","Ti inkimi pinkathari ikowako-witariri ishininka-payi, tima irootaki inintakiri Pawa awishi omonkara-tantyaari ikantzi-takari Jeroboam, itomi Nabat, ikamanta-kiriri Ahías Makoryiironi-satzi. ");
INSERT INTO prq_vpl VALUES ("K112_16","012_12_16","1KI","12","16","16","Ikanta maaroni Israel-iiti, iñaakiri pinkathari ti inkimi, yakanakiri, ikantziri: Ti noshininka-piro-tyaari naakaiti pirini David. Airo naapatyaami pikarajiitzi icharinitami itomi Isaí. Aikiro ikantajii-tanakitzii: ¡Israel-iiti anaajiitzi aroka, thami ampiyi awanko-thaantiki-payi! ¡Iriima ishininka-payi pinkatharini David, impinkatha-matsita-wakaiyaa ikaratzi ishininkata-wakaa irirori! Ari ipiyajii-tanaka Israel-iiti iwanko-thaantiki-payi. ");
INSERT INTO prq_vpl VALUES ("K112_17","012_12_17","1KI","12","17","17","Irootaki ipinkathari-wintan-tariri Roboam ishininka-payi Israel-iiti ikaratzi nampitarori iipatsitiki Judá-iti. ");
INSERT INTO prq_vpl VALUES ("K112_18","012_12_18","1KI","12","18","18","Ari ityaanta-witakari pinkathari Roboam inampina, Adoram, inkowakotiri ishininka-payi yasitakaariri iwinkathariti. Isitowanaki maaroni Israel-iiti ishimyaan-takari mapi, iwamaakiri. Ari ititanakiri sintzini pinkathari Roboam isiyako-mintoki, siyanaka Aapatyaawiniki. ");
INSERT INTO prq_vpl VALUES ("K112_19","012_12_19","1KI","12","19","19","Ari okantakari yooka-wakaan-takari Israel-iiti, ti intsipa-tajyaari ikaratzi icharini-yitari pinkatharini David irojatzi iroñaaka. ");
INSERT INTO prq_vpl VALUES ("K112_20","012_12_20","1KI","12","20","20","Ikanta ikimaki pasini ishininka-payi Israel-iiti, ikantaitzi: “Piyaja Jeroboam.” Ikaimakaan-takiri impoki tsika ipiyotaka maaroni ishininka-payi. Ari iwakiri impinkathari-wintairi maaroni ishininka Israel-iiti. Tira impinkatha-wintairi pasini ikarajiitzi ishininkata-wakaa-jiita icharini-yitari David, apaniro ikanta isaikawaitzi Judá-iti. ");
INSERT INTO prq_vpl VALUES ("K112_21","012_12_21","1KI","12","21","21","Ikanta yariitaka Roboam Aapatyaawiniki yapatota-paakiri Judá-iti aajatzi Benjamín-iti, oshiki-pirori ikarajiitzi iwayiriti iyosiitakiri. Inintzi iwayiri-tyaari pasini ishininka-payi Israel-iiti, imatanta-jyaa-rorimi Roboam, itomi Salomón impinkathari-wintairi maaroni ishininka-payi. ");
INSERT INTO prq_vpl VALUES ("K112_22","012_12_22","1KI","12","22","22","Iro kantacha, iñaanatakiri Pawa itomiyaayi paitachari Semaías, ikantakiri: ");
INSERT INTO prq_vpl VALUES ("K112_23","012_12_23","1KI","12","23","23","“Pinkinkitha-waita-kairi Roboam, itomi pinkatharini Salomón, iwinkathariti Judá-iti aajatzi Benjamín-iti. Pimatzi-tyaari pinkamantiri maaroni nampitarori anta, pinkantiri: ");
INSERT INTO prq_vpl VALUES ("K112_24","012_12_24","1KI","12","24","24","‘Iroka ikantzi Pawa: Ti onkamiithati pijati piwayirita-wakaiyaa pikaratzi pishininkata-wakaa-jiita awiroka Israel-iiti. Pimpiyi maaroni piwanko-thaantiki, tima irootaki nantawairi naaka.’ ” Ikanta ikimajii-takiro ñaantsi ikantziriri Pawa, piyayitanaka iwanko-thaantiki-payi, imatakiro tsika ikantakiri Pawa. ");
INSERT INTO prq_vpl VALUES ("K112_25","012_12_25","1KI","12","25","25","Yapiitajiro Jeroboam iwiriintairo nampitsi Sikochaarini saikatsiri tonkaariki iipatsitiki Efraín-iti. Ari inampitaarori irirori. Ikanta apaata yookanajiro inampiwi-takaro Sikochaarini, jataji, iwiriintajiro nampitsi Pawaporoni. ");
INSERT INTO prq_vpl VALUES ("K112_26","012_12_26","1KI","12","26","26","Ari ikinkithasiri-tanaka Jeroboam, ikantzi: “Kimitaka aritaki yapiitajiro impinkathari-wintajina Roboam, icharini pinkatharini David, ");
INSERT INTO prq_vpl VALUES ("K112_27","012_12_27","1KI","12","27","27","tima irojatzi ijata-piinta-jiitzi Aapatyaawini noshininka-payi impomitiri yatsipi-takaani itasorintsi-pankotiki Pawa, kimitaka aritaki inisironka-takiri Roboam, pinkathari-tatsiri iipatsitiki Judá-iti. Aamaiyaa aritaki iwa-kaantakina naaka, impiyasi-tairi Roboam iwinkathariti Judá-iti.” ");
INSERT INTO prq_vpl VALUES ("K112_28","012_12_28","1KI","12","28","28","Ari yaminaki pinkathari impaityaa yomitaa-najirini, iwitsika-kaantaki apiti isiyakaaro kiripiri vaca iyosiita ooro, ikantakiri maaroni ishininka: “¡Ashininka Israel-iiti! Aritapaaki pipiyapiyataka Aapatyaawiniki. Yoka piwawani-tajyaari aka, iriitaki amajimiri pisaika-witaka pairani Apitantoniki.” ");
INSERT INTO prq_vpl VALUES ("K112_29","012_12_29","1KI","12","29","29","Iwaki aparoni isiyakaaro vaca Pawapankoniki, iriima pasini iwakiri iipatsitiki Dan-iti. ");
INSERT INTO prq_vpl VALUES ("K112_30","012_12_30","1KI","12","30","30","Irootaki inkaaripiro-waitan-tyaari Israel-iiti, ijayitaji Pawapankoniki aajatzi iipatsitiki Dan-iti impinkatha-tairi isiyakaaro kiripiri vaca. ");
INSERT INTO prq_vpl VALUES ("K112_31","012_12_31","1KI","12","31","31","Iwitsika-kaanta-yitaki aajatzi tonkaariki iyarapapankoti. Iyosiiyitaki ishininka impira-tasorintsi-tyaari, kaari-tzimaita ishininka-payi Leví-iti. ");
INSERT INTO prq_vpl VALUES ("K115_9","012_15_9","1KI","15","9","9","Tima awisaki oshiki osarintsi ipinkathari-wintakiri Jeroboam maaroni pasini ishininka-payi Israel-iiti. Iriima ishininka-payi Judá-iti yaminaji iriroriiti pasini pinkathari-witairini, ipaita Asa. ");
INSERT INTO prq_vpl VALUES ("K116_23","012_16_23","1KI","16","23","23","Aritaki tzimaki 31 osarintsi ipinkatharitzi irirori Asa iipatsitiki Judá-iti. Aripaiti yitanakaro irirori Omri ipinkathari-wintziri pasini ishininka-payi Israel-iiti. Okaratzi 12 osarintsi ipinkatharitaki. Irooma anta nampitsiki Aakamiithawiniki ipinkatharitaki okaratzi 6 osarintsi. ");
INSERT INTO prq_vpl VALUES ("K116_24","012_16_24","1KI","16","24","24","Yamanantakiro Omri iipatsiti Ositikii-toni-satzi, ikaratzi apikithoti kiriiki opinatakari. Ari iwiriintakiri inampitsiti ipaitakiro Ositikii-toni, tima iro owaitakaan-tzirori iwairo asitarori iipatsiti pairani ipaita Ositiki, ikantai-tziri iñaaniki irirori ‘Semer’. ");
INSERT INTO prq_vpl VALUES ("K116_25","012_16_25","1KI","16","25","25","Ti onimotiri Pawa okaratzi yantziri pinkathari Omri. Omapiro ikaaripirotaki yanaakiri ikaaripirotaki itakarori pairani ipinkatharitzi. ");
INSERT INTO prq_vpl VALUES ("K116_26","012_16_26","1KI","16","26","26","Isiyako-taari ikaaripirotaki Jeroboam itomi Nabat, tima ikaaripiro-takaakiri aajatzi maaroni ishininka-payi Israel-iiti, iwatsimaakiri Iwawani Israel iñaakiri ipinkatha-waitziri siyakaa-rontsi. ");
INSERT INTO prq_vpl VALUES ("K116_28","012_16_28","1KI","16","28","28","Ikanta imakoryaaji irirori Omri, ikitaitakiri Ositikii-toniki. Iimpoyii-taari ipinkatharitaji Acab, itomi irirori. ");
INSERT INTO prq_vpl VALUES ("K116_30","012_16_30","1KI","16","30","30","Tima okaratzi 22 osarintsi ipinkathari-wintakiri Acab ishininka-payi Israel-iiti anta Ositikii-toniki. Titzimaita onimotiri Pawa ipinkathari-witaka Acab itomi Omri, omapiro ikaaripirotaki, yanaanakiri ikaratzi itakarori pairani ipinkatharitzi. ");
INSERT INTO prq_vpl VALUES ("K116_31","012_16_31","1KI","16","31","31","Ti yookiro yantayi-tziro kaari-pirori isiyako-taari pinkatharini Jeroboam, itomi Nabat, tima iinantakaro Jezabel, irisinto pinkathari-tatsiri Simaaki, ipaitai-tziri “Itsipa-minthari Inkaniwiri”. Tima ijataki pairani Jeroboam, ipinkatha-waitakiri pawaniro Inkaniwiri. ");
INSERT INTO prq_vpl VALUES ("K116_32","012_16_32","1KI","16","32","32","Iwitsika-kaantaki pomipirini-mintotsi anta Ositikii-toniki, iwitsika-kaantzitaka iyarapapankoti tsika impomiwintaitiri pawaniro Inkaniwiri. ");
INSERT INTO prq_vpl VALUES ("K116_33","012_16_33","1KI","16","33","33","Imatakiro aajatzi pinkathari Acab iwitsika-kaantaki osiyakaaro pawaniro Inkaariwiro, irootaki iwatsimaa-piro-tanta-kariri Iwawani Israel, tima yanaanakiri itayita-karori pairani ipinkathari-yitzi iwatsimairi Pawa. ");
INSERT INTO prq_vpl VALUES ("K117_1","012_17_1","1KI","17","1","1","Ikanta Elías Onimowini-satzi poñaachari Wakaniki, ikinkitha-waita-kaakiri pinkathari Acab, ikantziri: “¡Pinkatharí! Omapiro-tatyaa nonkantimiri, tima Iwawani Israel, iriitaki ompiratanari naaka. Ari awisaki osarintsi-payi airo omparyaaji inkani, airo iñiitaji kapichiini itsini impokiro irojatzi nonkantan-tajyaari naaka: ‘Omparyaaji.’ ” ");
INSERT INTO prq_vpl VALUES ("K117_2","012_17_2","1KI","17","2","2","Ari iñaanata-kiriri Pawa irirori Elías, ikantziri: ");
INSERT INTO prq_vpl VALUES ("K117_3","012_17_3","1KI","17","3","3","“¡Elías! Pisiyi, pinkinaki isitowa-piintzi ooryaatsiri. Pimañaa nijaatinkaki Chikaaroniki, saikatsiri intatzikiro Owaryiinkaariniki. ");
INSERT INTO prq_vpl VALUES ("K117_4","012_17_4","1KI","17","4","4","Irootaki pimirityaari nijaatinka. Ari nonkanta-kaakyaari koontzi-niro yayimiro piyaari anta.” ");
INSERT INTO prq_vpl VALUES ("K117_5","012_17_5","1KI","17","5","5","Imatakiro Elías ikantakiriri Pawa, jataki, isaikaki nijaatinkaki Chikaaroniki saikatsiri intatzikiro Owaryiinkaariniki. ");
INSERT INTO prq_vpl VALUES ("K117_6","012_17_6","1KI","17","6","6","Pokatsi koontzi-niro yaminiri posiniri iyaari aajatzi yatantyaariri. Yaminiri okitaityaa-manaji aajatzi tsitinii-tiini. Irootaki iriri nijaatinka. ");
INSERT INTO prq_vpl VALUES ("K117_7","012_17_7","1KI","17","7","7","Okanta awisaki tsika okaratzi kitaitiri, piryaatanaki nijaatinka, tima ti iñiitairo omparyaaji kipatsiki. ");
INSERT INTO prq_vpl VALUES ("K117_8","012_17_8","1KI","17","8","8","Opoñaa iñaanatairi Pawa yoka Elías, ikantajiri: ");
INSERT INTO prq_vpl VALUES ("K117_9","012_17_9","1KI","17","9","9","“Pijati Wiyaaroniki otsipa-nampitari Simaani, aritaki pisaikiri anta. Tima ari nonkanta-kaakyaaro kooya kinankaro ompimi piyaari.” ");
INSERT INTO prq_vpl VALUES ("K117_10","012_17_10","1KI","17","10","10","Jataki Elías Wiyaaroniki. Ikanta yariitzi-mataka nampitsiki, imonthaakaro kooya kinankaro aawaitzi saimpiki. Ikaimako-tapaakiro, ikantziro: “¡Ayomparó! Nonintzi pimpakotina kapichiini nijaa nirawaki.” ");
INSERT INTO prq_vpl VALUES ("K117_11","012_17_11","1KI","17","11","11","Irootaintsi ojatanaki ayiniri imiri, yapiita-nakiro, ikantziro: “¡Pamaki aajatzi kapichiini noyaari!” ");
INSERT INTO prq_vpl VALUES ("K117_12","012_17_12","1KI","17","12","12","Akanakiri iroori, okantziri: “¡Omapiro-tatyaa nonkantimi, tima añaatsi Piwawani, tikatsi yatantaitari nompimiri! Apatziro otzimi opanikiini pankirintsi-pani kowitziki, aajatzi yiinkantsi tzimatsi kapichiini. Irootaki naantari kapichiini saimpiki nonkotsitiro nakyootiri notomi, aririka nonthonkakiro, ari noyaawintyaa ayina notashi.” ");
INSERT INTO prq_vpl VALUES ("K117_13","012_17_13","1KI","17","13","13","Ikantzi Elías: “Airo pitharowa-waitzi. Pijati pimatiro pikantakiri. Iro kantacha naaka pitawakyaa pintasi-tinaro, pamakinaro nowawakyaa. Impoña pampoiti pintasiti pasi awiroka pakyootiri pitomi. ");
INSERT INTO prq_vpl VALUES ("K117_14","012_17_14","1KI","17","14","14","Tima ikantakina Pawa, Iwawani Israel, airo othonka pankirintsi-pani aajatzi yiinkantsi, irojatzi iwaryaan-tajyaarori Pawa inkani kipatsiki.” ");
INSERT INTO prq_vpl VALUES ("K117_15","012_17_15","1KI","17","15","15","Tima omatakiro kinankaro ikantakirori Elías. Oshiki kitaitiri awisaintsi ti onkowityiiyaa owariti otsipatakari Elías aajatzi otomi. ");
INSERT INTO prq_vpl VALUES ("K117_16","012_17_16","1KI","17","16","16","Ti onthonkyaa pankirintsi-pani oyowitzitiki aajatzi ikimitakari yiinkantsi, tima monkarataka iñaani Pawa ikantakiriri Elías. ");
INSERT INTO prq_vpl VALUES ("K117_17","012_17_17","1KI","17","17","17","Okanta apaata imapoka-sitaka imantsiyataki otomi kinankaro, mapirokitaka, ti onkanti yaniinka-tanaji. ");
INSERT INTO prq_vpl VALUES ("K117_18","012_17_18","1KI","17","18","18","Oñaanata-nakiri kinankaro yoka Elías, okantziri: “¡Itomiyaayi Pawá! ¿Paitama pipokasi-tantanari? ¿Irooma pipokantari pinkinkithasirita-kayinaro noyaaripironka inkaman-tajyaari notomi?” ");
INSERT INTO prq_vpl VALUES ("K117_19","012_17_19","1KI","17","19","19","Ari yakanakiro Elías, ikantziro: “Pamakinari aka pitomi.” Yaawakiri Elías othomaakiri iriniro, yatiita-kaanakiri imaapiintzi inaryaa-paakiri imaamintoki. ");
INSERT INTO prq_vpl VALUES ("K117_20","012_17_20","1KI","17","20","20","Ichiraanaki Elías, ikantzi: “¡Pawá! ¡Asitanarí! ¿Pimatzi-tyaaroma piwasinonkairo kinankaro nomayimo-tziri piwamaitiro otomi?” ");
INSERT INTO prq_vpl VALUES ("K117_21","012_17_21","1KI","17","21","21","Tima mawa yapiitakiro Elías iwanki-sipanii-takari iintsi. Yapiita-nakiro ichiraanaki, ikantzi: “¡Pawá! ¡Asitanarí! Poipyaa-siri-tairi iintsi.” ");
INSERT INTO prq_vpl VALUES ("K117_22","012_17_22","1KI","17","22","22","Ikimakiri Pawa ikantakiriri Elías, yoipyaa-siri-tairi iintsi, añaanaji. ");
INSERT INTO prq_vpl VALUES ("K117_23","012_17_23","1KI","17","23","23","Ithomaa-najiri, yayiita-kaanajiri osaawiki, ipapajiro asitariri, ikantziro: “Yoka pintsiti, añaaji.” ");
INSERT INTO prq_vpl VALUES ("K117_24","012_17_24","1KI","17","24","24","Okantzi kooya: “Ari noyotziri iroñaaka awiroka itomiyaayi Pawa, tima omapiro-tatyiiyaa iñaani Pawa okaratzi piñaawai-tziri awiroka.” ");
INSERT INTO prq_vpl VALUES ("K118_1","012_18_1","1KI","18","1","1","Tima osamanitaki, awisaki okaratzi mawa osarintsi, yapiitajiro Pawa iñaanatairi Elías, ikantairi: “Pijati, piñiiri pinkathari Acab, tima irootaa-tsi nowaryaajiro inkani tsinkaironi kipatsi.” ");
INSERT INTO prq_vpl VALUES ("K118_2","012_18_2","1KI","18","2","2","Jataki Elías iñiiri pinkathari Acab. Tima antaroiti okantaka tashitsi Ositikii-toniki. ");
INSERT INTO prq_vpl VALUES ("K118_3","012_18_3","1KI","18","3","3","Ikaimakiri Acab inampiri paitachari Abdías, tima imapiro-tatziiro irirori ipinkatha-tziri Pawa. ");
INSERT INTO prq_vpl VALUES ("K118_4","012_18_4","1KI","18","4","4","Tima owakaantan-takariri Jezabel Kamantan-tzinkari-payi, yoka Abdías iriitaki omanakiriri impirita-moro-nakiki ikaratzi 100 Kamantan-tzinkari, inasitaka apipiyoti ikaratzi 50 Kamantan-tzinkari, ari ipiriri iwari aajatzi iriri. ");
INSERT INTO prq_vpl VALUES ("K118_5","012_18_5","1KI","18","5","5","Ikinkitha-waita-kaakiri Acab yoka Abdías, ikantakiri: “Thami aniitiro maaroni nampitsi amini tsika owaapathata, amini aajatzi nijaatinka tsika oshooki katarosi yañaantyaari apira-payi ikyaakoitari. Airorika añaasita, ari inthonka-kyaari inkami apira-payi.” ");
INSERT INTO prq_vpl VALUES ("K118_6","012_18_6","1KI","18","6","6","Tima ikinanaki Acab pasiniki awotsi, iriima Abdías ikinakiro irirori pasiniki awotsi tikatsi intsipa-tanakyaa. ");
INSERT INTO prq_vpl VALUES ("K118_7","012_18_7","1KI","18","7","7","Ikanta ijatanaki Abdías awotsiki, imonthaakari Elías. Tima iyotawajiri, ityiirowa-sitawaari, ikantziri: “¿Tima awiroka Elías?” ");
INSERT INTO prq_vpl VALUES ("K118_8","012_18_8","1KI","18","8","8","Yakanaki Elías, ikantzi: “Naakataki. Pimpiyanaki, pinkantiri piwinkathariti: ‘Noñaajiri Elías.’ ” ");
INSERT INTO prq_vpl VALUES ("K118_9","012_18_9","1KI","18","9","9","Ikantzi Abdías: “¿Tzimatsima nokinakaa-sitani pityaantan-tanari nonkamantiri pinkathari Acab iwan-tyaanari? ");
INSERT INTO prq_vpl VALUES ("K118_10","012_18_10","1KI","18","10","10","¡Omapiro-tatyaa nonkantimiri, tima añaatsi Piwawani! Oshiki yamina-mina-takaan-takimi pinkathari Acab maaroni nampitsiki. Ikaratzi kantatsiri: ‘Ti noñaajiri,’ isintsiwintziri ikantziri: ‘Pinkanta-piro-tina tirika piñaajiri’! ");
INSERT INTO prq_vpl VALUES ("K118_11","012_18_11","1KI","18","11","11","Aikiro pikanta-tyaana awiroka iroñaaka: ‘Pijati pinkamantiri piwinkathariti, pinkantiri: “Noñaajiri Elías.” ’ ");
INSERT INTO prq_vpl VALUES ("K118_12","012_18_12","1KI","18","12","12","Kimitaka aririka nojatanaki, yaanajimi itasorinka Pawa, airo noyotzi tsika pisaiki. Aririka nonkaman-tawita-kyaari pinkathari Acab, airorika iñaasitami irirori, aritaki iwakina. Tima naaka, nasi nowiro nopinkatha-tziri Pawa owakira nomainari-tapaaki. ");
INSERT INTO prq_vpl VALUES ("K118_13","012_18_13","1KI","18","13","13","¿Tima inkaman-taitimiro okaratzi nantakiri otsitoka-kaantan-tariri Jezabel Kamantan-tzinkari-payi? Tima nomanaki impirita-moro-nakiki ikaratzi 100. Nonasitaka apipiyoti ikaratzi 50 Kamantan-tzinkari, ari nopiriri iwari aajatzi irirí. ");
INSERT INTO prq_vpl VALUES ("K118_14","012_18_14","1KI","18","14","14","Aikiro pikanta-tyaana awiroka iroñaaka: ‘Pijati pinkamantiri piwinkathariti, pinkantiri: “Noñaajiri Elías.” ’ ¿Pininta-tziima iwina?” ");
INSERT INTO prq_vpl VALUES ("K118_15","012_18_15","1KI","18","15","15","Ikantzi Elías: “¡Omapiro-tatyaa nokantzimiri, tima añaatsi Pawa Ñaapirori ompiratanari naaka. Iroñaaka nojati noñiiri Acab!” ");
INSERT INTO prq_vpl VALUES ("K118_16","012_18_16","1KI","18","16","16","Ikanta Abdías yamina-mina-tairi pinkathari Acab, ikamantakiri. Jatanaki irirori Acab imonthai-yaari Elías. ");
INSERT INTO prq_vpl VALUES ("K118_17","012_18_17","1KI","18","17","17","Ikanta iñaawajiri, ikantawakiri: “¿Awirokama ñaasirin-kayitakiriri ashininka-payi Israel-iiti? ");
INSERT INTO prq_vpl VALUES ("K118_18","012_18_18","1KI","18","18","18","Ikantzi Elías: “Tira naaka ñaasirin-kirini. Awiroka pitsipatari ishininka-payi piwaisatzitini, okantakaaro piwashaantairo ikantakaantani Pawa, pipinkatha-waita-sitakari osiyakaaro Inkaniwiri-payi. ");
INSERT INTO prq_vpl VALUES ("K118_19","012_18_19","1KI","18","19","19","Pinkaima-kaantiri maaroni ashininka-payi Israel-iiti yapatojiityaa Owaantsii-toniki. Pinkaimiri anta iñaawya-takaani Inkaniwiri inkarati 450, pinkaimiri oñaawya-takaani Inkaariwiro inkarati 400, aajatzi ikarajiitzi akyoota-piintzirori Jezabel.” ");
INSERT INTO prq_vpl VALUES ("K118_20","012_18_20","1KI","18","20","20","Ikaimakaan-takiri Acab maaroni ishininka-payi Israel-iiti, yapatotakiri maaroni ñaawyawai-taniri-payi Owaantsii-toniki. ");
INSERT INTO prq_vpl VALUES ("K118_21","012_18_21","1KI","18","21","21","Ari ipokakiri irirori Elías tsika ipiyotaka ishininka-payi, ikantapaakiri: “¿Tsika-paiti piwashaantairo pipitho-pitho-waitaka okantakaami otzimi apiti pikinkithasiritani? Iriirika iriipirori Pawa pinkimisantiri, pimatiro. Iriirika Inkaniwiri, pinkimisantiri irirori.” Ari imairijiitaki ishininka-payi tikatsi akatsini. ");
INSERT INTO prq_vpl VALUES ("K118_22","012_18_22","1KI","18","22","22","Aikiro iñaanata-tziiri Elías ishininka-payi, ikantziri: “Aparoni nokanta naaka iyamanta-niriti Pawa, iriima Inkaniwiri ikaratzi 450 iñaawya-taniriti. ");
INSERT INTO prq_vpl VALUES ("K118_23","012_18_23","1KI","18","23","23","Pamajiiti aka apiti ipiraitari. Iyosiitaki ñaawyariiti aparoni ipiraitari inintiri, intopitha-yitakiri, iwankitakiri itsimaki, airo itaan-tzimaitari paamari. Ari nonkimitaakiri naaka pasini ipiraitari, nowanki-takiri tsitsiki, airo nowaama-tantari aajatzi paamari. ");
INSERT INTO prq_vpl VALUES ("K118_24","012_18_24","1KI","18","24","24","Impoña pinkowa-kotiri piwawani-payi awirokaiti, pimpairyiiro iwairo. Irooma naaka nompairyiiro iwairo Nowawani. Itzimi-rika Pawa kimatsini, owayiita-kironi paamari, iriitaki mapirotzirori Ipawatzi.” Ikantajiitzi maaroni Israel-iiti: “¡Ariwí!” ");
INSERT INTO prq_vpl VALUES ("K118_25","012_18_25","1KI","18","25","25","Ikantanakiri Elías iñaawya-takaani Inkaniwiri: “Piyoyii pinintziri ipiraitari, pityaari awiroka piwamairi, tima oshiki pikarajiitzi. Pinkowa-kotiri piwawani pimpairyaajiro iwairo, airotzimaita poisantari paamari.” ");
INSERT INTO prq_vpl VALUES ("K118_26","012_18_26","1KI","18","26","26","Imatakiro ikantakiriri, yaakiri ipiraitari, iwamaakiri. Yitanakaro kapichikitaiti, tampatzika-takotaki ikowako-witari iwawani Inkaniwiri, ikantziri: “¡Inkaniwirí, pakina!” Tikatsi-tzimaita akirini. Aikiro imitaa-jiiwitatyaa ishonka-shonkawintziro iwitsikakiri ipomi-pirini-minto. ");
INSERT INTO prq_vpl VALUES ("K118_27","012_18_27","1KI","18","27","27","Tampatzika-takotaki, oshiki isironta-wintari Elías yokaiti, ikantziri: “Pisintsiti pinkaimiri piwawani. Aamaasityaa tzimatsi yantziri, ijatatzii ikiwan-tawaitzi. Piwasaakiryiiri aamaasityaa imaatzii.” ");
INSERT INTO prq_vpl VALUES ("K118_28","012_18_28","1KI","18","28","28","Aikiro ikaimajii-tatzii, itotakaa-waiyi-takaro kotsiraa-niki, ipathakawai-takaro thoyimpi-thowa-yitatsiri, iyowayitaki iriraani, aritaki okanta yamijiitari iriroriiti. ");
INSERT INTO prq_vpl VALUES ("K118_29","012_18_29","1KI","18","29","29","Irootzi-mataki omonkaratyaa tsika owiraa kitaitiri ipomitanta-piintariri yatsipi-takaani, aikiro ikaimawi-jiitatyaa sintsiini, titzimaita yakaitiniri yamanani. Tikatsi akirini, tikatsi kimirini aajatzi. ");
INSERT INTO prq_vpl VALUES ("K118_30","012_18_30","1KI","18","30","30","Ikaimanakiri Elías maaroni ishininka-payi, ikantziri: “Pimpoka-jiiti maaroni aka.” Pokajii-tapaaki ishininka-payi. Ari iwitsikajiri Elías ipomi-pirini-minto Pawa iporoki-taitakiri pairani. ");
INSERT INTO prq_vpl VALUES ("K118_31","012_18_31","1KI","18","31","31","Yaaki mapipayi okaratzi 12. Ikaratzira pairani aajatzi itomi-payi Jacob 12. Tima irijatzi Jacob ikantakiri pairani Pawa, ikantziri: “Israel pimpaitajyaa.” ");
INSERT INTO prq_vpl VALUES ("K118_32","012_18_32","1KI","18","32","32","Ipiwirikairo mapipayi iwitsikaji itaapirini-minto Pawa, antaro ikiya-thapi-takiro, kantacha impanki-taitimi oshiki okitho pankirintsi. ");
INSERT INTO prq_vpl VALUES ("K118_33","012_18_33","1KI","18","33","33","Itaromaakiro tsitsi, itowatha-yitakiri ipiraitari, iwankitakiri tsitsiki. ");
INSERT INTO prq_vpl VALUES ("K118_34","012_18_34","1KI","18","34","34","Ikantzi Elías: “Pamakiro antaro 4 kowitzi owantakari nijaa, pisaitiro pomitai-rontsi aajatzi tsitsi.” Aikiro ikantatzii Elías: “Papiitiro pisaitiro.” Yapiitziro ikantzi: “Papiitiro pisaitiro.” Imataitakiro okaratzi ikantakiri Elías. ");
INSERT INTO prq_vpl VALUES ("K118_35","012_18_35","1KI","18","35","35","Jaikita-paaka nijaa ikiya-thapi-taitakiro pomipirini-mintotsi, siyaata-paaka nijaa. ");
INSERT INTO prq_vpl VALUES ("K118_36","012_18_36","1KI","18","36","36","Aritaki monkara-tapaaka owiraa kitaitiri ipomita-piintziri ipira pomipirini-mintotsiki, pokanaki Elías. Ichiraa-paaki, ikantzi: “¡Pawá! Iwawani Abraham, Isaac aajatzi Israel. Pimatiro nokowako-tzimiri, irootaki iyotantai-tyaari awiroka Iwawani Israel-iiti, naakataki aajatzi pimpiratani. Okaratzi nantziri naaka, awirokataki ompiratanari nantimiro. ");
INSERT INTO prq_vpl VALUES ("K118_37","012_18_37","1KI","18","37","37","Pimatiro Pawa, pimatinaro nokowako-tzimiri. Irootaki iyotantyaari atziri-payi awirokataki Pawa, awiroka kaima-siri-yitziriri inkimisantaimi.” ");
INSERT INTO prq_vpl VALUES ("K118_38","012_18_38","1KI","18","38","38","Omapoka-sitanaka ookatha-tanaka, otaapaakiri wathatsi, tsitsi, mapi, samampo, maaroni, paamatanaki aajatzi nijaa jaikitain-chari ikiya-thapi-tasitai-takiro. ");
INSERT INTO prq_vpl VALUES ("K118_39","012_18_39","1KI","18","39","39","Ikanta iñaakiro maaroni Israel-iiti opaamatanaki, oiyotanaka, otsitoka-paaka itamako kipatsiki, ikantajiitzi: “¡Pawa inatzi yokawí! ¡Iriitaki Pawá!” ");
INSERT INTO prq_vpl VALUES ("K118_40","012_18_40","1KI","18","40","40","Ari ikantzi Elías: “Pairikiri iñaawyataniriti Inkaniwiri. Tikatsi aparoni siyatsini.” Ari yairikai-tanakiri maaroni, yaanakiri Elías nijaatinkaki Tirimpyaaroki, iwisakiri maaroni. ");
INSERT INTO prq_vpl VALUES ("K118_41","012_18_41","1KI","18","41","41","Ari ikinkitha-waita-kaakiri Elías pinkathari Acab, ikantziri: “Pijati piwankoki, piwapajyaa, pirapaji aajatzi iraitziri. Tima poimainkata-paaki antaro inkani.” ");
INSERT INTO prq_vpl VALUES ("K118_42","012_18_42","1KI","18","42","42","Ari itonkaanaki kapichiini pinkathari Acab, owawaitaka, iraki aajatzi iraitziri. Ari itonkaa-piro-tanaki irirori Elías omitzithaki Owaantsii-toniki, thointa-paaka yoiyoota-paaka anta, itsitoka-kaakaro iworo iyirito. ");
INSERT INTO prq_vpl VALUES ("K118_43","012_18_43","1KI","18","43","43","Ikantziri impiratani: “Pinkatziya-niinti jinokiini, pamini inkaari-kinta.” Jatanaki, yaminaki inkaariki, ikantzi: “Tikatsi noñii.” Aikiro isintsi-tatzii Elías, ikantziri: “Papii-piitiro pamini, onkarati 7 papiitiro.” ");
INSERT INTO prq_vpl VALUES ("K118_44","012_18_44","1KI","18","44","44","Irotaki 7-tatsiri ipiya-piyataka impiratani, ikantziri: “Noñaaki inkaari-kinta yanini minkori, osiyaro akotsi.” Ikantzi Elías: “Pijati isaiki pinkathari Acab pinkantiri: ‘Paanajiro pisiyako-minto, tikira oparyaa-paaki inkani.’ ” ");
INSERT INTO prq_vpl VALUES ("K118_45","012_18_45","1KI","18","45","45","Ari otsitini-kitanaki inkiti, antaro otampyaa-tanaki, paryaapaaki antaro inkani. Titanaka Acab isiyako-mintoki, jataki Panki-pawa-winiki. ");
INSERT INTO prq_vpl VALUES ("K118_46","012_18_46","1KI","18","46","46","Iriima Elías, ikantakaakari Pawa ontzimi isintsinka, yooso-thaki-tanakaro iithaari. Isiyana-kityaa ijatanaki, iriitaki itakaro yariitaka Panki-pawawiniki tikira-mintha yariityaa irirori Acab.");
INSERT INTO prq_vpl VALUES ("K25_1","013_5_1","2KI","5","1","1","Tzimatsi aparoni atziri ipaita Naamán, iriitaki jiwatziriri iwayiriti pinkatha-ritatsiri Tonkaironiki. Itakotani iwiri pinkathari, yantziniri opaita-rika inintziri, tima iriitaki kantakaarori Naamán ikaminthaan-takariri Pawa yoitsinampaan-takariri iwayiri-minthatani-payi. Iro kantacha yoka ñaapirori atziri, omatatziiri kowiinkari pathaa-rontsi. ");
INSERT INTO prq_vpl VALUES ("K25_2","013_5_2","2KI","5","2","2","Ikanta ijajiitaki Tonkaironi-satzi imaimanitziri Israel-iiti, ari inosikaki aparoni iintsi, irootaki ipimantaitaki ompirawaityaaro iina Naamán. ");
INSERT INTO prq_vpl VALUES ("K25_3","013_5_3","2KI","5","3","3","Okanta iroka iintsi okantakiro iina Naamán: “Aririka ijatimi jiwari iñiiri Kamantan-tzinkari saikatsiri anta Ositikii-toniki, aritaki yisita-kotaji aakiri kowiinkari pathaa-rontsi.” ");
INSERT INTO prq_vpl VALUES ("K25_4","013_5_4","2KI","5","4","4","Ikanta ikimaki Naamán okantakiri iintsi, ijata-sitakiri pinkathari, ikamantakiri irirori okaratzi okantakiri iintsi. ");
INSERT INTO prq_vpl VALUES ("K25_5","013_5_5","2KI","5","5","5","Ari ikantanaki pinkatha-ritatsiri Tonkaironiki: “Kamiithataki. Pijati piñaa-kitiri. Aritaki notyaantaki naaka sankinarintsi paanakiniri iwinkathariti Israel-iiti.” Ikanta Naamán, yaanaki oshiki ikaratzi impinatiriri aajatzi kithaarintsi-payi, jataki iñiiri iwinkathariti Israel-iiti. ");
INSERT INTO prq_vpl VALUES ("K25_6","013_5_6","2KI","5","6","6","Iriitaki aanakirori sankinarintsi ityaantai-tziniriri iwinkathariti Israel-iiti, ikantai-tziri: “Iroka sankinarintsi nontyaan-timiri onkantyaa piyotan-tyaariri yoka Naamán, jiwatziriri nowayiriti, naakataki otyaantziriri, nonintatzii pisita-kota-kaajiri omatakiri kowiinkari pathaa-rontsi.” ");
INSERT INTO prq_vpl VALUES ("K25_7","013_5_7","2KI","5","7","7","Ikanta iñaanata-wakiro iwinkathariti Israel-iiti iroka sankinarintsi, isaraa-nakiro iithaari tima oshiki okatsitzimo-sirita-nakiri, ikantanaki: “¡Ti naaka Pawa! Ti nomatiro nowañaanti, aajatzi nowamaanti. ¿Ipaitama ityaantan-tanariri iwinkathariti Tonkaironi-satzi yoka atziri nisitakotaajiri omatakiri kowiinkari pathaa-rontsi? Kimitaka iitaimpyaa-waitatyaa ompoñaan-tyaari iwayirityaana.” ");
INSERT INTO prq_vpl VALUES ("K25_8","013_5_8","2KI","5","8","8","Ikanta ikimaki Kamantan-tzinkari Eliseo, ikantaitzi: “Oshiki okantzimo-siri-waitakari pinkathari.” Ityaanta-kiniri irirori sampitirini, inkantiri: “¿Ipaitama pisaraan-tanakarori pithaari? Piwawisaa-najiri naaka yoka atziri iñaajina, ari onkantyaa iyotantyaari tzimatsi Kamantan-tzinkari aka inampiki Israel-iiti.” ");
INSERT INTO prq_vpl VALUES ("K25_9","013_5_9","2KI","5","9","9","Irootaki ijatanta-nakari Naamán, yaanaki isiyako-minto-payi, aajatzi ipira-payi ikyaakoitari. Ikatziya-kaapaakari tsika ikyaita-piintzi iwankoki Eliseo. ");
INSERT INTO prq_vpl VALUES ("K25_10","013_5_10","2KI","5","10","10","Ikanta yoka Kamantan-tzinkari Eliseo, ityaantaki irirori kantirini Naamán: “Pijati, pintsitsiyi Owaryiinkaariniki onkarati 7 papiitiro pintsitsiyi. Aritaki ompiyajyaa opathaa-kaakimi kowiinkari pipathaaro.” ");
INSERT INTO prq_vpl VALUES ("K25_11","013_5_11","2KI","5","11","11","Ari ikisanaka Naamán, iñaawaita-tziira ijatanaki, ikantzi: “Nosiyakaantzi ari isitowa-sita-wakina, katziya-paaka inkowa-kotiri Pawa. Ari intzinaa-wakota-nakyaa, yantakinaro nopathaaro, isitanaki. ");
INSERT INTO prq_vpl VALUES ("K25_12","013_5_12","2KI","5","12","12","Tima tzimatsi apiti nijaa anta nonampiki Ontyaamairini, iroka Kyaaryoshaari aajatzi Maasinchaarini. Irootaki kamiitha-pirota-tsiri anta, anairo nijaa-payi okaratzi tzimatsiri aka iipatsitiki Israel-iiti. Aririka nonkiwakyaa-rika anta, ¿airoma opyaaja nopathaaro?” Oshiki otyaanakari iyatsimanka ipiyanaka. ");
INSERT INTO prq_vpl VALUES ("K25_13","013_5_13","2KI","5","13","13","Iro kantacha ipoka-sita-paakiri impiratani-payi irirori, ikantapaakiri: “¡Nowinkathariti! Aririka intyaan-timimi Kamantan-tzinkari pantiromi kompita-pirota-chari, ¿tima aritaki pantakiromi? ¿Kaarima pantantaro iroñaaka, ikantakimira: ‘Pijati pinkiwyaa nijaaki, aritaki ompiyajyaa piwathaaro?’ ” ");
INSERT INTO prq_vpl VALUES ("K25_14","013_5_14","2KI","5","14","14","Ari yoirinka-nakari iroñaaka Naamán, tsitsiya-paaki Owaryiinkaariniki, okaratzi 7 yapiitakiro itsitsiyaataki, imonkaratakiro okaratzi ikantakiriri itomiyaayi Pawa. Matanaka ikantai-takiriri, osiyawaita-naaro iwatha aparoni iintsi, pyaanaja okaratzi ipathaa-waiwitaka. ");
INSERT INTO prq_vpl VALUES ("K25_15","013_5_15","2KI","5","15","15","Ikanta ipiyaaro Naamán itsipayii-taari ikarata-nakiri anta isaikira itomiyaayi Pawa, iñaakapajiri Kamantan-tzinkari, ikantapajiri: “Ari noyotzi iroñaaka tikatsira pasini Pawa maaroni kipatsiki, apatziro itzimi aka iipatsitiki Israel-iiti. Nonintzi paawakotina nopasitamiri, naakataki iroñaaka pimpiratani.” ");
INSERT INTO prq_vpl VALUES ("K25_16","013_5_16","2KI","5","16","16","Iro kantacha akanaki Kamantan-tzinkari Eliseo, ikantanakiri Naamán: “¡Omapirotatyaa nonkantimiri! Airo naawakotzimiro pimpinari.” Okantawitaka opomirinchaa-witakari yaawakotiro opawitariri, tira inintiro Eliseo. ");
INSERT INTO prq_vpl VALUES ("K217_6","013_17_6","2KI","17","6","6","Okanta apaata, aritaki awisaki okaratzi 9 osarintsi ipinkatharitzi Oseas, ipokaki pinkathari-tatsiri Aatzika-winiki ikyaaki Ositikii-toniki. Tima ithonka inosikakiri Israel-iiti yaanakiri Aatzika-winiki. Tzimatsi Israel-iiti yookakiri Kamiithawiniki saikatsiri Apatotaa-riniki omontitari Mapishitani. Pasini Israel-iiti yookakiri inampiki Niyanki-wini-satzi. ");
INSERT INTO prq_vpl VALUES ("K217_7","013_17_7","2KI","17","7","7","Irootaki awishimo-tanta-kariri Israel-iiti, tima ti onimotiri Pawa yantayi-takiro kaari-pirori. Tima iwawisaa-kowitakari pairani impira-waitari Faraón, iwinkathariti Apitantoni-satzi. Aikiro ijatatzii ipinkatha-waitziri pawaniro-payi. ");
INSERT INTO prq_vpl VALUES ("K217_8","013_17_8","2KI","17","8","8","Yantasi-takaro yamiyitari asiwitarori pairani iipatsiti, yantasi-takaro kaaripiro-yitatsiri yamiyitari ikaratzi pinkathari-winta-kiriri Israel-iiti. ");
INSERT INTO prq_vpl VALUES ("K217_9","013_17_9","2KI","17","9","9","Iroka pasini yantayi-takiri Israel-iiti imananikiini, ikisima-waitakiri Iwawani. Iwitsika-yitaki iyarapapankoti maaroni nampitsiki-payi. Imatakiro antaroki-payi nampitsi, aajatzi nampichaanikiki-payi tsika itzimasita-piintziri owayiri-payi. ");
INSERT INTO prq_vpl VALUES ("K217_10","013_17_10","2KI","17","10","10","Imatzitakaro maaroni omitzitha otzisi aajatzi oponkitziki antaro-payi inchato, iwitsika-yitaki antaropayi mapithantha aajatzi osiyakaaro pawaniro Inkaariwiro. ");
INSERT INTO prq_vpl VALUES ("K217_11","013_17_11","2KI","17","11","11","Yantakiro yamiyitari pasini-satzi atziri imisitowakiri pairani Pawa, yantayi-takiro aajatzi kaari kamiithatatsini. Itaayitziro kasankai-nkari tonkaariki-payi. Irootaki iwatsimaa-piro-tanta-kariri Pawa. ");
INSERT INTO prq_vpl VALUES ("K217_12","013_17_12","2KI","17","12","12","Tima ipinkatha-waitakiri aajatzi pawaniro. Ikamanta-witakari pairani Pawa, ikantziri: “Airo pimatziro awiroka iroka, piwinkani piwiro.” ");
INSERT INTO prq_vpl VALUES ("K217_13","013_17_13","2KI","17","13","13","Yapiiwi-takari Pawa ikamantziri Judá-iti aajatzi pasini ishininka-payi Israel-iiti, ityaanta-kiniri oshiki Kamantan-tzinkari-payi, oshiki ñaawyataniri, ikantziri: “Pimpiya-siri-yitaji, pimonkara-tairo nokanta-kaantani aajatzi nosinita-kaantani, pimonkara-tairo maaroni noñaani nosankina-takaa-kiriri pairani piwaisatziti, okaratzi ikamanta-yitajimiri Kamantan-tzinkari-payi.” ");
INSERT INTO prq_vpl VALUES ("K217_14","013_17_14","2KI","17","14","14","Titzimaita inkimajiiti, oshiki ikiso-siri-jiitaki, isiyako-taari tsika ikantaka pairani iwaisatziti-payi, ti yawintyaari Pawa. ");
INSERT INTO prq_vpl VALUES ("K217_15","013_17_15","2KI","17","15","15","Yaparatakiro ikasiya-kaita-kiriri pairani iwaisatziti-payi, ti inthotyiiro isankinata-kaantaitani isintsi-thawi-takariri imonkaratiro. Ipinkatha-waita-sitakari pawaniro tikatsi apantyaarini, ari ikimitakari irirori-payi tikatsi apantajyaarini. Isiyako-takari atziri-payi itsipa-nampi-takari, tima iro ikantawi-takariri pairani Pawa: “Ti noninti pisiyako-tyaari asitarori inampi anta.” ");
INSERT INTO prq_vpl VALUES ("K217_16","013_17_16","2KI","17","16","16","Iwashaantakiro okaratzi ikantakaan-takiri Pawa. Yaaki kitiriri kiriiki, iriitaki iwitsikaki apiti isiyakaaro kiripiri ipiraitari, iwitsikaki aajatzi osiyakaaro pawaniro Inkaariwiro. Ipinkatha-waitakiri aajatzi ikaratzi oorinta-chari inkitiki, imatzitakari pawaniro Inkaniwiri. ");
INSERT INTO prq_vpl VALUES ("K217_17","013_17_17","2KI","17","17","17","Itaakaan-tziri iwaiyani pomitai-rontsiki, isiyasitari niwyatan-taniri, aajatzi yotantaniri. Tima iñaakiri Pawa omapiro ikaaripiro-waitaki, irootaki iwatsimaa-piro-tanta-kariri. ");
INSERT INTO prq_vpl VALUES ("K217_18","013_17_18","2KI","17","18","18","Imatakiro Pawa itsimaakari pasini-payi Israel-iiti, yooka-nakiri. Ti ininti iñiiri. Apatziro inintziri Judá-iti. ");
INSERT INTO prq_vpl VALUES ("K217_19","013_17_19","2KI","17","19","19","Ti imatzimai-tyaaro aajatzi Judá-iti inthotyiiro ikantakaantani Pawa, yantasi-yitakaro iyomitaan-takiri pasini-payi Israel-iiti. ");
INSERT INTO prq_vpl VALUES ("K217_20","013_17_20","2KI","17","20","20","Irootaki yookan-tanakariri Pawa maaroni Israel-iiti. Oshiki iwasankitaa-yitakiri, isinitakiri inosika-yitakiri ikaratzi kisaniintziriri, tima imatakiri yookanakiri ti ininti iñiiri. ");
INSERT INTO prq_vpl VALUES ("K217_21","013_17_21","2KI","17","21","21","Ikanta itsiparyaa-wakaaka icharini-payi pinkatharini David. Yaminaki pasini ishininka-payi Israel-iiti iwinkathariti, iwakiri Jeroboam, itomi Nabat. Iriitaki Jeroboam mapirota-kiriri itzimpina-siri-takiri Israel-iiti ti impinkatha-tajiri Pawa, omapiro ikaaripirotaki. ");
INSERT INTO prq_vpl VALUES ("K217_22","013_17_22","2KI","17","22","22","Yantasi-waitakaro Israel-iiti okaratzi kaaripiro-yitatsiri ikimitakari Jeroboam, ti ininti iwashaantairo, ");
INSERT INTO prq_vpl VALUES ("K217_23","013_17_23","2KI","17","23","23","irootaki yookan-tanakariri Pawa yoka Israel-iiti. Tima imonkara-takiro Pawa ikantzi-takariri pairani impiratani, Kamantan-tzinkari-payi. Irootaki inosikai-tanta-kariri Israel-iiti anta Aatzika-winiki. Irojatzi isaikayitzi iroñaaka. ");
INSERT INTO prq_vpl VALUES ("K217_24","013_17_24","2KI","17","24","24","Ikanta iwinkathariti Aatzika-wini-satzi, yaanaki ishininka-payi nampitarori Kompi-jaariki, Tharowa-winiki, Poroka-winiki, Owayiri-winiki aajatzi Apisankinaniki. Iriitaki yosiita-paincha inampita-paakaro Ositikii-toniki, iriiyitaki impoyii-tapaa-kariri Israel-iiti. Irootaki yasitan-tarori kipatsi Ositikii-toni, tima inthonka inampitakaro okaratzi nampitsi tzimatsiri anta. ");
INSERT INTO prq_vpl VALUES ("K217_25","013_17_25","2KI","17","25","25","Iro kantacha, titzimaita impinkathatiri Pawa yokaiti atziri. Ikanta itawitapaakaro inampiyitaro anta, ityaantaki Pawa owantaniri, yatsika-yitakiri. ");
INSERT INTO prq_vpl VALUES ("K217_26","013_17_26","2KI","17","26","26","Irootaki ikamantan-takariri iwinkathariti Aatzika-wini-satzi, ikantziri: “Ikaratzi pamakiri atziri-payi inampityaaro Ositikii-toniki, ti iyotakotiro iñaani Iwawani asitarori inampi anta. Ityaantaki Pawa owantaniri, oshiki ashininka yatsikakiri, okantakaan-tziro ti iyotakotiro iñaani Pawa asitarori kipatsi.” ");
INSERT INTO prq_vpl VALUES ("K217_27","013_17_27","2KI","17","27","27","Ari ikantanaki iwinkathariti Aatzika-wini-satzi, ikantzi: “Paanaji inampiki aparoni Impira-tasorintsi-taari isaikapaji anta, iriitaki yomitaa-pajirini ashininka-payi iñaani Pawa anta.” ");
INSERT INTO prq_vpl VALUES ("K217_28","013_17_28","2KI","17","28","28","Ikanta aparoni Impira-tasorintsi-taari yamaitakiri Ositikii-toniki, ipiyanaaro inampiitiki, saikapaji Pawapankoniki. Iyomitaa-yitapajiri tsika inkantyaa impinkathatiri Pawa. ");
INSERT INTO prq_vpl VALUES ("K217_29","013_17_29","2KI","17","29","29","Iro kantacha anta Ositikii-toniki, iwitsika-yitaki iwawa-niroti-payi tsika inampiyi-takaro, iwayitakiri tonkaariki tsika iwitsika-sitakiri karapapanko-payi. ");
INSERT INTO prq_vpl VALUES ("K217_32","013_17_32","2KI","17","32","32","Imatziwitaro aajatzi ipinkatha-tziri Pawa. Iwayitaki ikarajiitzi irirori ompira-tasorintsi-tatsini, iriitaki antawai-tatsini iyarapapankotiki pawaniro-payi anta tonkaariki-payi tsika iwitsika-sitakiri. ");
INSERT INTO prq_vpl VALUES ("K217_33","013_17_33","2KI","17","33","33","Tima onkanta-witakyaa ipinkatha-witakari Pawa, imatzitari aajatzi pawaniro ipinkatha-tziri. Yantasi-yitaro okaratzi yamitari asitarori inampi tsika inosikai-takiri. ");
INSERT INTO prq_vpl VALUES ("K224_1","013_24_1","2KI","24","1","1","Ikanta Nabucodonosor pinkathari-wintziriri Kompijaari-satzi, jataki iwayiri-minthatyaari Judá-iti. Ari impira-waitai-takari iwinkathariti Judá-iti, paitachari Joacim. Arira impira-waitai-tariri Judá-iti okaratzi mawa osarintsi, iro kantacha apaata, imatajiro irirori Joacim imaimanitairi Nabucodonosor. ");
INSERT INTO prq_vpl VALUES ("K224_2","013_24_2","2KI","24","2","2","Ipoñaa ikantakaakaro Pawa, ipokayitaki kapichiini owayiri poñaachari Kiyamoriwiniki, Tonkaironiki, Athataa-winiki aajatzi Pityaankaariniki. Iriitaki maimani-waitirini Judá-iti, yapirotiri. Ari imonkaratzirori iñaani Pawa ikamantantakiri Kamantan-tzinkariiti. ");
INSERT INTO prq_vpl VALUES ("K224_6","013_24_6","2KI","24","6","6","Ikanta ikamajira Joacim, impoyiitaari itomi ipinkatha-ritai, ipaita irirori Joaquín. ");
INSERT INTO prq_vpl VALUES ("K224_8","013_24_8","2KI","24","8","8","Okanta apaata, tzimaji pasini pinkathari, ipaita Joaquín. Tima tzimaki okaratzi 18 isarintsiti yitanta-nakarori ipinkatharitzi Aapatyaawiniki. Ikaratzi mawa kasiri ipinkatharitaki. Opaita iriniro Nehusta, irootaki irisinto Elnatán, poñaachari Aapatyaawiniki. ");
INSERT INTO prq_vpl VALUES ("K224_9","013_24_9","2KI","24","9","9","Titzimaita onimotiri Pawa, iñiiri Joaquín yantayi-tziro kaari-pirori. Ari isiyako-taari tsika ikanta pairani iriri. ");
INSERT INTO prq_vpl VALUES ("K224_10","013_24_10","2KI","24","10","10","Ipinkathari-minthaitzi Joaquín, aripaiti ipokajiitaki iwayiriti Nabucodonosor, pinkathari-tatsiri Kompi-jaariki, iwayiri-tyaari Aapatyaawini-satzi. Tima inthonka ishonka-paakiro nampitsi. ");
INSERT INTO prq_vpl VALUES ("K224_11","013_24_11","2KI","24","11","11","Ari yariita-paakari irirori Nabucodonosor, pinkathari-tatsiri Kompi-jaariki, itapota-paakiro iwayiriti-payi nampitsi Aapatyaawini. ");
INSERT INTO prq_vpl VALUES ("K224_12","013_24_12","2KI","24","12","12","Ikanta Joaquín, iwinkathariti Judá-iti, ti imatiri impiyatyaari iwinkathariti Kompi-jaari-satzi. Isinitanaka inosikiri yaanakiri inampiki, itsipatakaro iriniro, jiwatziriri iwayiriti-payi, pasini jiwari-payi, maaroni inampiri-payi. Tima tzimaki 8 osarintsi ipinkathari-wintantzi irirori Nabucodonosor anta Kompi-jaariki. ");
INSERT INTO prq_vpl VALUES ("K224_13","013_24_13","2KI","24","13","13","Tima ithonka yaanakiri maaroni kiriiki ikaratzi tzimatsiri itasorintsi-pankotiki Pawa, aajatzi okaratzi tzimatsiri iwankoki pinkathari. Ari omonkaratari okaratzi ikantakiri pairani Pawa. Tima ithonka isataanakiri ooronaki yasitakai-tarori itasorintsi-pankoti Pawa, iwitsika-kaantakiri pairani Salomón, iwinkathariti Israel-iiti. ");
INSERT INTO prq_vpl VALUES ("K224_14","013_24_14","2KI","24","14","14","Tima inosikai-tanakiri Aapatyaawini-satzi, jiwari-payi, ñaapirori-payi owayiri, ikaratzi 10,000. Inosikai-tanakiri ikaratzi yotzirori iwitsika-waitzi, asiro-pakori-payi. Iroowitaincha yapirotirimi inosikiri maaroni, apatziro yooka-matzii-tanakiri asinonkai-nkari-payi. ");
INSERT INTO prq_vpl VALUES ("K224_15","013_24_15","2KI","24","15","15","Tima imataitakiri inosikai-takiri pinkathari Joaquín, itsipatai-tanakiri iinapayi, iriniro, inampiri-payi, aajatzi ñaapirori-payi nampitarori Aapatyaawiniki. Yaitanakiri Kompi-jaariki. ");
INSERT INTO prq_vpl VALUES ("K224_16","013_24_16","2KI","24","16","16","Yoka ikaratzi ñaapirori owayiri-payi inosikakiri iwinkathariti Kompi-jaari-satzi, ikaratzi 7,000. Iriima asiro-pakori-payi, witsika-waitaniri-payi ikaratzi 1,000. Tima ari ikaratzi inosikakiri ñaapirori-payi tharowinta-chari iwayirityaa. ");
INSERT INTO prq_vpl VALUES ("K224_17","013_24_17","2KI","24","17","17","Ikanta iwinkathariti Kompi-jaari-satzi iwakiri Matanías impinkathariti, impoyii-taari itomi-thori Joaquín, iwainiri pasini iwairo, ipaitajiri Sedequías. ");
INSERT INTO prq_vpl VALUES ("K224_18","013_24_18","2KI","24","18","18","Tima tzimaki okaratzi 21 isarintsiti Sedequías yitanta-nakarori ipinkatharitzi. Ipinkatharitaki Aapatyaawiniki okaratzi 11 osarintsi. Tima opaita iriniro Hamutal, irisinto Jeremías, poñaachari anta Kitamaroitoniki. ");
INSERT INTO prq_vpl VALUES ("K224_19","013_24_19","2KI","24","19","19","Titzimaita onimotiri Pawa iñiiri Sedequías yantayi-tziro kaari-pirori. Ari isiyako-taari tsika ikanta pairani irirori Joacim. ");
INSERT INTO prq_vpl VALUES ("K224_20","013_24_20","2KI","24","20","20","Irootaki ikisa-piro-tanta-nakariri Pawa yokaiti Aapatyaawini-satzi aajatzi maaroni Judá-iti. Ti ininti iñiiri. Ikanta apaata Sedequías, ipithoka-sitaari iwinkathariti Kompi-jaari-satzi, iwayiri-taari irirori. ");
INSERT INTO prq_vpl VALUES ("K225_1","013_25_1","2KI","25","1","1","Okanta awisaki 9 osarintsi ipinkathari-tantari Sedequías. Irootaki 10-tatsiri kitaitiri, kasiri 10, ari yariitakari Nabucodonosor pinkathari-tatsiri Kompi-jaariki, yamaki oshiki iwayiriti iwayiri-tyaari Aapatyaawini-satzi. Tima ithonka ishonka-paakiro nampitsi, iwitsika-yitapaaki yatii-minto-payi. ");
INSERT INTO prq_vpl VALUES ("K225_2","013_25_2","2KI","25","2","2","Tima aparoni osarintsi iwayiri-taitakiri Aapatyaawini-satzi, irojatzi okaranta-paakari ipinkatharitzi Sedequías. ");
INSERT INTO prq_vpl VALUES ("K225_3","013_25_3","2KI","25","3","3","Tima inkarati 6 kasiri iwayiri-jiitaka, ayimatakiri itashi maaroni Aapatyaawini-satzi, ti ontzimapaji iwajyaari. ");
INSERT INTO prq_vpl VALUES ("K225_4","013_25_4","2KI","25","4","4","Ari imoronta-jiitakiro Aapatyaawini-satzi apitantoti inampitsiti. Itzimasi-witakari iwayiriti Kiyamori-wini-satzi. Imatzimai-takaro isiyayitaka iwayiriti Aapatyaawini-satzi tsitini-paiti, aajatzi pinkathari. Ikinajiitaki iwankiri-masiki pinkathari, ipampitha-tanakiro awotsi jatachari Mamiriwiniki. ");
INSERT INTO prq_vpl VALUES ("K225_5","013_25_5","2KI","25","5","5","Ikanta iwayiriti Kiyamori-wini-satzi ipatzima-tanakiri, iyaatawajiri owintini-pathatzi Kasiryaari. Tima ithonka yoiwaraa-jiitanaka iwayiriti pinkathari-tatsiri Aapatyaawiniki, yooka-nakiri apaniroini. ");
INSERT INTO prq_vpl VALUES ("K225_6","013_25_6","2KI","25","6","6","Yairikai-takiri pinkathari, yaanakiniri iwinkathariti Kompi-jaari-satzi isaiki irirori Owaiyawiniki. Ari imishakowintakiri Nabucodonosor iwasankitaitiri Sedequías. ");
INSERT INTO prq_vpl VALUES ("K225_7","013_25_7","2KI","25","7","7","Tima iñaakowintakiri pinkathari Sedequías tsika ikanta iwisai-takiri itomi-payi. Ipoñaa ikantanaki pinkathari Nabucodonosor: “Pinkitho-ryiitiri irooki Sedequías. Poosotiri, paanakiri Kompi-jaariki.” ");
INSERT INTO prq_vpl VALUES ("K225_8","013_25_8","2KI","25","8","8","Okanta awisaki 19 osarintsi, irootaki 7-tatsiri kitaitiri, kasiri 5, ipinkathari-wintantzi Nabucodonosor Kompi-jaariki. Aripaiti yariitakari Nabuzaradán Aapatyaawiniki. Tima yoka Nabuzaradán iriitaki jiwatziriri owayiri-payi, inampina inatzi pinkathari Nabucodonosor. ");
INSERT INTO prq_vpl VALUES ("K225_9","013_25_9","2KI","25","9","9","Tima ithonka itaapaakiro tasorintsi-panko, iwanko pinkathari, yapirotakiro itaakiro maaroni iwanko Aapatyaawini-satzi. Itaakiro aajatzi iwanko-payi ñaapiroriiti inampiri-payi pinkathari. ");
INSERT INTO prq_vpl VALUES ("K225_10","013_25_10","2KI","25","10","10","Imatakiro iwayiriti-payi Kiyamori-wini-satzi oyaatakiriri Nabuzaradán, ithonka iporoka-paakiro otantotari nampitsi Aapatyaawini. ");
INSERT INTO prq_vpl VALUES ("K225_11","013_25_11","2KI","25","11","11","Tima inosikakiri Aapatyaawini-satzi yoka Nabuzaradán, yaanakiri Kompi-jaariki. Ari ikaratzi yaanakiri yamaawi-taitakari nampitsiki, akawita-kariri iwinkathariti Kompi-jaari-satzi. ");
INSERT INTO prq_vpl VALUES ("K225_12","013_25_12","2KI","25","12","12","Apatziro yookaita-nakiri asinonkai-nkari-payi. Iriitaki impira-tajiita yantawaiti owaantsiki, inthamai-takotiro pankirintsi-payi. ");
INSERT INTO prq_vpl VALUES ("K225_13","013_25_13","2KI","25","13","13","Tima ithonkakiri Kiyamori-wini-satzi iporokakiri kitirita-tsiri asiro iwitsikan-taitarori tasorintsi-panko: otzinkami, owankyaaro-payi, antaro iwantai-tarori nijaa. Ithonka yaanakiro iroka-payi Kompi-jaariki. ");
INSERT INTO prq_vpl VALUES ("K225_14","013_25_14","2KI","25","14","14","Yaanakiro aajatzi Kiyamori-wini-satzi samampo-mintotsi, itsikotan-taitarori samampo, iwantai-tarori paamari-minki, ikitantai-tarori samampo, maaroni okaratzi iwitsikai-tziri asiro kitirita-tsiri saikatsiri anta ipinkatha-taita-piintziri Pawa. ");
INSERT INTO prq_vpl VALUES ("K225_15","013_25_15","2KI","25","15","15","Tima ithonka yaanakiri ijiwariti owayiri iwitsikai-tziri ooro aajatzi kiriiki, taamintotsi-naki aajatzi iramintotsi-naki-payi. ");
INSERT INTO prq_vpl VALUES ("K225_18","013_25_18","2KI","25","18","18","Ikanta ijiwari owayiri, yairikakiri aajatzi Seraías iriipirori Impira-tasorintsi-taari, ari ikimitaakiri Sofonías pasini iriipirori Impira-tasorintsi-taari, ari ikimitaakiri aajatzi mawa aamaako-winta-rori ikyaapiintaitzira tasorintsi-panko. ");
INSERT INTO prq_vpl VALUES ("K225_19","013_25_19","2KI","25","19","19","Inosikakiri aajatzi ijiwariti owayiri-payi, ari ikimitaa-kiriri 5 inampiri pinkathari saikatsiri, sankina-takoyi-tziriri atziri-payi saikatsiri nampitsiki. Imatakiri inosikai-takiri aajatzi 60 iriipirori atziri asitarori inampi anta. ");
INSERT INTO prq_vpl VALUES ("K225_20","013_25_20","2KI","25","20","20","Ikanta Nabuzaradán, ijiwariti owayiri-payi, yaanakiri maaroni inosikani-payi Owaiyawiniki tsika isaiki iwinkathariti Kompi-jaari-satzi. ");
INSERT INTO prq_vpl VALUES ("K225_21","013_25_21","2KI","25","21","21","Ikanta yaawakiri yamaita-kiniriri iwinkathariti Kompi-jaari-satzi, itsitoka-kaantakiri Owaiyawiniki iipatsitiki Owayiriwini-satzi. Ari okanta awishimo-takiriri Judá-iti inosikan-taita-kariri pasiniki kipatsi. Tima ithonka yaitakiri intaina iipatsitiki pasini-satzi atziri.");
INSERT INTO prq_vpl VALUES ("R224_1","015_24_1","2CH","24","1","1","Okanta apaata anta Aapatyaawiniki, yitanakaro ipinkathari-wintantzi Joás. Apatziro okara-matsitaki 7 isarintsiti Joás itanta-nakarori ipinkatharitzi. Tima oshiki osarintsi ipinkatharitaki Aapatyaawiniki, okaratzi 40 osarintsi. Sibia opaita iriniro, opoñaaro iroori Kanta-piro-jaariki. ");
INSERT INTO prq_vpl VALUES ("R224_2","015_24_2","2CH","24","2","2","Tima onimotakiri Pawa okaratzi yantayi-takiri Joás, ainiro yañiira Joiada, Impira-tasorintsi-taari. ");
INSERT INTO prq_vpl VALUES ("R224_4","015_24_4","2CH","24","4","4","Okanta osamanitaki apaata, ikinkithasiritaka Joás iwitsikairo itasorintsi-pankoti Pawa. ");
INSERT INTO prq_vpl VALUES ("R224_5","015_24_5","2CH","24","5","5","Yapatotakiri Ompira-tasorintsi-taari-payi aajatzi maaroni Leví-iti. Ikantakiri: “Pijatiro maaroni inampitsitiki Judá-iti, pinkampitiri kiriiki pishininka-payi. Iriitaki awitsikan-tyaarori itasorintsi-pankoti Pawa. Aritaki ankanta-tyiiro osarintsiki awitsika-yitairo. Tharowinta pinkantyaa, airo pisamanitzi.” Iro kantacha, ti intharowintyaa Leví-iti, ti inthaanki-wintiro ikantakiriri Pawa. ");
INSERT INTO prq_vpl VALUES ("R224_6","015_24_6","2CH","24","6","6","Ikanta pinkathari Joás, ikaimakiri iriipirori Ompira-tasorintsi-taari paitachari Joiada, ikantakiri: “¿Ipaita kaari piwintha-takaantari Leví-iti impiyota-kairi Aapatyaawini-satzi inkarati yasitakai-tyaariri Pawa, irojatzi imatakiri maaroni Judá-iti? Tima irootaki inintakaantani pairani Moisés, impiratani Pawa, ikantakiri Israel-iiti iyosiiti kiriiki inkasiya-kairo tasorintsi-thaanti.” ");
INSERT INTO prq_vpl VALUES ("R224_7","015_24_7","2CH","24","7","7","Tima okotaawai-takiro itasorintsi-pankoti Pawa kaari-pirori kooya Atalía, otsipatakari otomi-payi. Aanakiniri isiyakaaro owawa-niroti maaroni itasorintsi-takai-tziri itasorintsi-pankotiki Pawa. ");
INSERT INTO prq_vpl VALUES ("R224_8","015_24_8","2CH","24","8","8","Ari iwitsika-kaantaki pinkathari incha-moko, ithointakiro ikyaa-piintai-tzira itasorintsi-pankotiki Pawa. ");
INSERT INTO prq_vpl VALUES ("R224_9","015_24_9","2CH","24","9","9","Ipoñaa ikamantai-takiri maaroni Aapatyaawini-satzi aajatzi pasini-payi Judá-iti, yamayitiri yasitakaariri Pawa, imonkara-tairo ikantakiriri pairani Moisés maaroni Israel-iiti, isaikan-takari otzisi-masiki. ");
INSERT INTO prq_vpl VALUES ("R224_10","015_24_10","2CH","24","10","10","Ari ipokajiitaki maaroni jiwari, maaroni atziri, tharowinta ikanta yamayitaki yasitakaariri Pawa, itiyitakiri incha-mokoki, ijaikitakiro. ");
INSERT INTO prq_vpl VALUES ("R224_11","015_24_11","2CH","24","11","11","Iriitaki Leví-iti ayirori incha-moko isaiki pinkathari, yaminiri kiriiki. Ikanta iñaakiri ishikitaki kiriiki, ikaimakaan-tziri inampina pinkathari, aajatzi osankina-ryaantzi, irijatzi inampiri iriipirori Ompira-tasorintsi-taari. Iriitaki sokirini kiriiki jaikitain-chari, yaanakiri. Iwaitanajiro incha-moko tsika osaiki. Tima irootaki yaakowinta maaroni kitaitiri, oshiki kiriiki yayiri kitaitiriki-payi. ");
INSERT INTO prq_vpl VALUES ("R224_12","015_24_12","2CH","24","12","12","Ikanta pinkathari itsipatari Ompira-tasorintsi-taari, ipapiintakiri kiriiki jiwatziriri witsikaironi tasorintsi-panko. Impoña yamini yotzirori iwitsikairo, yaminaki irirori kiriipakori aajatzi asiro-pakori, inkarati owitsikaironi tasorintsi-panko. ");
INSERT INTO prq_vpl VALUES ("R224_13","015_24_13","2CH","24","13","13","Ari yitanakaro yantawai-tanaki maaroni antawai-rintzi-payi. Ti ishinta-kaiyaaro iwitsikairo, iwakira-tajiro itasorintsi-pankoti Pawa, imatairo tsika okanta iwitsikai-takiro pairani. Kamiitha okanta iwitsikai-tairo. ");
INSERT INTO prq_vpl VALUES ("R224_14","015_24_14","2CH","24","14","14","Ikanta ithonkai-takiro iwitsikai-tziro, yaitanajiri kiriiki tzimaraanta-paintsiri isaiki pinkathari itsipatakari Ompira-tasorintsi-taari. Iriitaki iwitsikai-takiri okaratzi kowityaa-chari itasorintsi-pankotiki Pawa. Iriitaki yasitakai-tarori tsika yapatowinta-piintaitari Pawa. Yaitaki ooro aajatzi kiriiki iwitsikaitaki iramintotsi aajatzi owamintotsi. Tima ainiro yañii irirori Joiada, oshiki yaakowintai-takaro ipomitai-tziri yatsipi-takaitani itasorintsi-pankotiki Pawa. ");
INSERT INTO prq_vpl VALUES ("R224_15","015_24_15","2CH","24","15","15","Aritaki antyasipari-tapaaki Joiada, kamaki. Tima oshiki yañaaki okaratzi 130 osarintsi. ");
INSERT INTO prq_vpl VALUES ("R224_16","015_24_16","2CH","24","16","16","Ikitaitakiri Inampi David, itsipa-siri-taari pinkathari-payi, tima kamiitha isaikimo-takiri Israel-iiti, aajatzi Pawa. Iriitaki owitsika-kaantairori tasorintsi-panko. ");
INSERT INTO prq_vpl VALUES ("R224_17","015_24_17","2CH","24","17","17","Tima kamaki Joiada, ari yariijiitaka ijiwariti Judá-iti. Oshiki ipinkatha-tapaakiri pinkathari, irootaki inintan-tanakari pinkathari iyomitaa-najiri ikaratzi ariitain-chari. ");
INSERT INTO prq_vpl VALUES ("R224_18","015_24_18","2CH","24","18","18","Aripaiti iwashaanta-nakiro itasorintsi-pankoti Pawa, imatzitakari Iwawanitari pairani iwaisatziti-payi. Ipinkatha-tasitakari osiyakaaro pawaniro Inkaariwiro aajatzi isiyakaaro pasini-payi pawaniro. Ari iwatsimaa-piro-tanakiriri Pawa yokaiti Aapatyaawini-satzi aajatzi Judá-iti iñaakirira ikaaripirotaki. ");
INSERT INTO prq_vpl VALUES ("R224_19","015_24_19","2CH","24","19","19","Ari ityaanta-witai-takaniri Kamantan-tzinkari-payi, iriitaki kantakai-yaaroni inkimisantan-tajyaari impiyasi-tanta-jyaariri Pawa. Titzimaita inkimisanta-jiiti iyomitaawi-tariri Kamantan-tzinkari-payi. ");
INSERT INTO prq_vpl VALUES ("R224_20","015_24_20","2CH","24","20","20","Yoka aparoni Kamantan-tzinkari ityaantakiri Pawa, iriitaki Zacarías, itomi Ompira-tasorintsi-taari Joiada, isaikasiri-tanta-nakari itasorinka Pawa, ikatziyaka tonkaariki, ikinkitha-waita-kaakiri ishininka-payi, ikantziri: “Jiroka ikantzi Pawa: ‘¿Paitaka kaari pikimisantantaro noninta-kaantani? ¿Paita pinintantari pasinonkaa-waitajyaa? Awiroka itakaro pookanakina, aritaki nonkimitaimiri aajatzi naaka, aritaki nookanakimi.’ ” ");
INSERT INTO prq_vpl VALUES ("R224_21","015_24_21","2CH","24","21","21","Iro kantacha, ikamanta-wakaa-jiitaka ishininka-payi imaimanitiri. Irootaki ikantan-takari pinkathari iwaitiri Kamantan-tzinkari ikyaa-piintai-tzira itasorintsi-pankotiki Pawa.");
INSERT INTO prq_vpl VALUES ("ER1_1","016_1_1","EZR","1","1","1","Aritaki tzimaki aparoni osarintsi ipinkatharitzi Ciro inampiki irirori Kyaakowiniki. Ari omonkara-tyaari iñaani Pawa ikamantan-takiri pairani Jeremías. Ikantakaakari Pawa pinkathari Ciro, inkamantanti maaroni tsika ipinkathari-wintantzi, isankinatiro isinita-kaantani irirori, inkanti: ");
INSERT INTO prq_vpl VALUES ("ER1_2","016_1_2","EZR","1","2","2","“Naaka Ciro, iwinkathariti Kyaakowini-satzi, iroka noñaani nokantzi: Iriitaki Pawa, Inkiti-satzi, nintakaa-kinarori nojiwatiri pinkathari-payi kipatsiki. Isinitakina aajatzi nopiriintajiro itasorintsi-pankoti Aapatyaawiniki saikatsiri iipatsitiki Judá-iti. ");
INSERT INTO prq_vpl VALUES ("ER1_3","016_1_3","EZR","1","3","3","Tzimatsi-rika yasitari Pawa, aritaki inisironka-takiri. Ijati Aapatyaawiniki iipatsitiki Judá-iti, yamitako-tantiro impiriintaitiro itasorintsi-pankoti Pawa, Iwawani Israel, saikatsiri anta Aapatyaawiniki. ");
INSERT INTO prq_vpl VALUES ("ER1_4","016_1_4","EZR","1","4","4","Tzimatsi-rika awisako-taintsiri iwayiri-taitan-takariri, ainiro-rika yañaayitzi tsika-rika-payi, yamitako-tawajiri isaika-nampitziri, impayitiri: kiriiki, ooro, ipira, pasini ipasitan-taitari inkasiya-kairori itasorintsi-pankoti Pawa witsika-chani Aapatyaawiniki.” ");
INSERT INTO prq_vpl VALUES ("ER1_5","016_1_5","EZR","1","5","5","Ikanta iwitsika-jiitanaka ishininka-payi Judá-iti aajatzi Benjamín-iti, jiwari-payi, Impira-tasorintsi-taari-payi, Leví-iti, tima iriiyitaki iwintha-takaakari Pawa iwitsikairo itasorintsi-pankoti Pawa anta Aapatyaawiniki. ");
INSERT INTO prq_vpl VALUES ("ER1_6","016_1_6","EZR","1","6","6","Yamitako-tawajiri ikaratzi isaika-nampi-yitziri anta, ipawajiri kiriiki, ooro, ipira, okaratzi pinayita-chari, aajatzi pasini okaratzi ipasitan-taitakari. ");
INSERT INTO prq_vpl VALUES ("ER1_7","016_1_7","EZR","1","7","7","Iriima pinkathari Ciro, yamajiri okaratzi asitari itasorintsi-pankoti Pawa, yaanakiri pairani Nabucodonosor iwayiri-tanta-karori Aapatyaawini. Ikaratzi ipiyotakiri iyarapapankotiki iwawa-niroti irirori. ");
INSERT INTO prq_vpl VALUES ("ER1_8","016_1_8","EZR","1","8","8","Tima ithonka yoipyaa-yitairi pinkathari Ciro, ipakiri Mitrídate kimpoyiiriri kiriiki yaminayitiro kamiitha-rika okantayita, onkini yamayitairo. Ipapajiri irirori Sesbasar, ijiwariti Judá-iti. ");
INSERT INTO prq_vpl VALUES ("ER1_11","016_1_11","EZR","1","11","11","Iroka ikaratzi ipiyotaka kiriiki aajatzi ooro, ikaratzi 5400. Tima iriitaki yamajiri Sesbasar yoipyaajiri Aapatyaawiniki, itsipayi-taari nosikaari-payi impira-waitaitari Kompi-jaariki. ");
INSERT INTO prq_vpl VALUES ("ER2_68","016_2_68","EZR","2","68","68","Ikanta ipokajiitaki jiwari-payi iñaapaakiro itasorintsi-pankoti Pawa anta Aapatyaawiniki, yapatoyi-tapaaki impasiyi-tyaarori iwitsikan-taita-jyaarori itasorintsi-pankoti Pawa tsika osaikaki. ");
INSERT INTO prq_vpl VALUES ("ER2_70","016_2_70","EZR","2","70","70","Ari isaikajii-tapaji yokaiti Impira-tasorintsi-taari-payi, Leví-iti, maaroni ishininka-payi, panthaa-waitaniri, aamaako-winta-rori ikyaa-piintaitzi, aajatzi ikaratzi antawai-tatsini Tasorintsi-pankoki. Ari isaikajii-tapaji maaroni Israel-iiti inampiitiki irirori. ");
INSERT INTO prq_vpl VALUES ("ER3_8","016_3_8","EZR","3","8","8","Tima awisanaki aparoni osarintsi, iriitaki apitita-tsiri kasiri isaikajii-tapaji itasorintsi-pankotiki Pawa Aapatyaawiniki, ari itaita-nakaro yantawai-jiitzi Zorobabel itomi Salatiel, Jesúa itomi Josadac, aajatzi iririntzi-payi, Impira-tasorintsi-taari-payi, aajatzi Leví-iti. Maaroni ikaratzi piyayitaa-chari Aapatyaawiniki inosika-witai-takari. Ari iwaitakiri maaroni Leví-iti, yitaita-nakari tzimayi-taintsiri 20 isarintsiti, tima iriiyitaki jiwatakaan-tironi iwitsikai-tajiro itasorintsi-pankoti Pawa. ");
INSERT INTO prq_vpl VALUES ("ER6_14","016_6_14","EZR","6","14","14","Ari ikantakari maaroni yantari-konati Judá-iti, aikiro ijatakaa-nakitziiro yanta-wairi iwitsika-yitairo, imonkara-tziro okaratzi ikantziri Kamantan-tzinkari Hageo aajatzi Zacarías itomi Iddo. Tima imatajiro iwitsika-yitajiro, irojatzi ithonkan-takarori yanta-wairi, imatakiro ikantakiriri Pawa Iwawani Israel. Imatakiro aajatzi ikantakiriri pinkathari Ciro, Dario, aajatzi Artejerjes, pinkathari-wintan-tatsiri Kyaakowiniki. ");
INSERT INTO prq_vpl VALUES ("ER6_15","016_6_15","EZR","6","15","15","Tima inthonkai-tajiro iwitsikai-tairo tasorintsi-panko kitaitiri mawa, kasiriki ipaitai-tziri “Sipakiryaari”. Tima irootaki 6-tatsiri osarintsi ipinkathari-wintantari Dario Kyaakowiniki. ");
INSERT INTO prq_vpl VALUES ("ER6_16","016_6_16","EZR","6","16","16","Tima antaro yoimosirinka-jiitakiro maaroni Israel-iiti, itasorintsi-pankoti Pawa, itsipayi-takari ishininka-payi nosikaari-payi ikaratzi piyayitaa-chari, aajatzi Impira-tasorintsi-taari-payi, Leví-iti, tharowinta ikanta-winta-jiitakaro.");
INSERT INTO prq_vpl VALUES ("JB1_1","019_1_1","JOB","1","1","1","Tzimatsi anta Kaminaa-winiki aparoni atziri ipaita Job. Kamiitha-siri ikantaka yoka atziri, tampatzika-siriri inaki, pinkatha iwiri Pawa, iwinkani iwiro kaaripirori. ");
INSERT INTO prq_vpl VALUES ("JB1_2","019_1_2","JOB","1","2","2","Tzimatsi ikaratzi 7 itomi, mawa irisinto. ");
INSERT INTO prq_vpl VALUES ("JB1_3","019_1_3","JOB","1","3","3","Iriipirori inatzi yoka atziri yanairi ikaratzi nampitajiitaroni isitowa-piin-tzira ooryaatsiri. Itzimi-motziri oshiki ipira-payi, oshiki aajatzi impira-tanipayi. ");
INSERT INTO prq_vpl VALUES ("JB1_4","019_1_4","JOB","1","4","4","Tima yaakowin-takaro iwawaijiitani itomi-payi iwankoki, itanakaro aparoni itomi, pasini kitaitiri pasini itomi, imatakiro maaroni itomi. Ikaimakaan-tziro mawa iritsiro akyootiri yoimosirinkajiitani, irawaitaiyini aajatzi. ");
INSERT INTO prq_vpl VALUES ("JB1_5","019_1_5","JOB","1","5","5","Ikanta imonkara-takiro yoimosirinka-waita ikarajiitaiyakini, ikaimiri Job itomi-payi, iwitsika-siri-takaa-yityaari. Kapichikitaiti ipiriinta. Kachaaryiinka ikanta ipomiwin-tziri itomi, itanakari aparoni, imatakiri pasini, ari ikantziri maaroni tsika ikarataiyini. Tima ikanta-siri-tatzii Job: “Aamaasityaa kaaripirotaki notomi-payi, ikisima-waitakiri Pawa.” Aritaki ikantapiin-tatziiro Job. ");
INSERT INTO prq_vpl VALUES ("JB1_6","019_1_6","JOB","1","6","6","Okanta apaata ijajiitakini maninkari-payi inkimiri Pawa opaitarika inkantiriri, ari imatzitakaro Mishatantaniri ijataki irirori. ");
INSERT INTO prq_vpl VALUES ("JB1_7","019_1_7","JOB","1","7","7","Isampitawa-kiri Pawa yoka Mishatantaniri, ikantziri: “¿Tsikama pipoñaana-karoka?” Ikantzi Mishatantaniri: “Nopoñaakaro anta nokinakina-waitzi naniitziro maaroni kipatsi.” ");
INSERT INTO prq_vpl VALUES ("JB1_8","019_1_8","JOB","1","8","8","Ikantzi Pawa: “¿Piñaakirima nompira-tani Job? Tikatsi osiyaari-ní irirori anta kipatsiki, kamiitha-siri inatzi yoka notomiyaayi, tampatzika-siriri ikantaka, pinkatha iwana naaka, iwinkani iwiro kaaripirori.” ");
INSERT INTO prq_vpl VALUES ("JB1_9","019_1_9","JOB","1","9","9","Yakanaki Mishatantaniri, ikantzi: “¡Jhí! ¿Pisiyakaan-tzima, ipinkatha-waitasitami Job?” ");
INSERT INTO prq_vpl VALUES ("JB1_10","019_1_10","JOB","1","10","10","¿Tima piñiiro oshiki paamaakowin-takari irirori, aajatzi ikaratzi saika-wanko-tziriri, maaroni tzimimo-tziriri? Pitasonka-wintakiniri maaroni yantawairi, irootaki oshikitan-takari otzimi-motziri opaiyita-rika anta kipatsi-kinta. ");
INSERT INTO prq_vpl VALUES ("JB1_11","019_1_11","JOB","1","11","11","Intsityaa pakotasitiri iroñaaka, paapithatiri okaratzi tzimimo-takiriri, aritaki piñaakiri inkisima-waitanakimi awiroka.” ");
INSERT INTO prq_vpl VALUES ("JB1_12","019_1_12","JOB","1","12","12","Ikantzi Pawa: “Piñaakiro awiroka okaratzi tzimimo-takiriri, intsityaa pimatiro okaratzi pikowakiri awiroka. Airomaita pantziri iwathaki irirori.” Piyanaka Mishatantaniri ikinkitha-waitakairi Pawa. ");
INSERT INTO prq_vpl VALUES ("JB1_13","019_1_13","JOB","1","13","13","Ikanta isaikajiitzi itomi-payi Job itsipayi-taro iritsiro iwawaijiita, irawaitaiyini imiri iwankoki yantariti iririntzi. ");
INSERT INTO prq_vpl VALUES ("JB1_14","019_1_14","JOB","1","14","14","Ari yaritapaakari kamanti-rini Job tsika isaiki irirori, ikantapaa-kiri: “Nosaika-minthaitzi owaantsiki noshiwa-takairi kipatsi pivacati, ari iwawaijiita aajatzi pimorani-payi okaakiini. ");
INSERT INTO prq_vpl VALUES ("JB1_15","019_1_15","JOB","1","15","15","Ari imapoka-sitapaaka yarii-jiitapaakani kosintzipayi, ithonka iwapaakiri pimpira-tanipayi, yaanakiri maaroni pipira-payi. Apatziro nosiyanaka naaka namimiro iroka ñaantsi.” ");
INSERT INTO prq_vpl VALUES ("JB1_16","019_1_16","JOB","1","16","16","Tikiramintha inthonkiroota ikinkitha-waiti siyainchari ikamantantzi, ariitapaaka pasini, ikantapaakiri: “Ayiitaki ookatha-rontsi, othonka otaapaakiri pipira-payi aajatzi ikaratzi aamaakowin-tariri, othonkakiri owamaakiri maaroni. Apatziro nosiyaka naaka namimiro iroka ñaantsi. ");
INSERT INTO prq_vpl VALUES ("JB1_17","019_1_17","JOB","1","17","17","Tikiraata inthonkiro inkinkitha-waiti siyainchari ikamantantzi, ariitapaaka pasini, ikantapaakiri: “Ipokajiitaki mawa ipiyo-tani Kiyamori-wini-satzi, iwayiri-tapaa-kina, ithonka yaanakiri ikyaakoi-tari pipira-payi, iwamaana-kiri ikaratzi aamaakowin-tariri iwisayi-tapaakiri. Apatziro nosiyaka naaka namimiro iroka ñaantsi. ");
INSERT INTO prq_vpl VALUES ("JB1_18","019_1_18","JOB","1","18","18","Aikiro ikinkitha-waitatzii siyainchari ikamantantzi, ariitapaaka pasini, ikantapaakiri: “Isaikajiitzini pitomi-payi itsipayi-taro iritsiro iwawaijiita, irawai-jiitzi imiri iwankoki pantariti pitomi. ");
INSERT INTO prq_vpl VALUES ("JB1_19","019_1_19","JOB","1","19","19","Ari omapoka-sitaka antaro tampyaa okinapaa-kiro otzisi-masiki, othonka oshiwatapaa-kiro pankotsi, osintaryaana-kiro, anawyaakiri maaroni pitomi-payi, kamaki. Apatziro nosiyaka naaka namimiro iroka ñaantsi.” ");
INSERT INTO prq_vpl VALUES ("JB1_20","019_1_20","JOB","1","20","20","Katziyanaka Job, isaraa-nakiro iithaari okatsi-tzimo-niintana-kiri, yamiitana-kiro iisi. Ipoñaa ityiirowa-naka kipatsi, amananaki, ");
INSERT INTO prq_vpl VALUES ("JB1_21","019_1_21","JOB","1","21","21","ikantzi: “Kaanki-miriki nokanta iwaiyantakina asitanari, Sapoka-miriki nonkantajyaa aajatzi nompiyajiro anta. Iriitaki Pawa opakinarori, irijatzi Pawa aapitha-tajinarori. ¡Kimosiri inkanta-wintaityaaro iwairo Pawa! ");
INSERT INTO prq_vpl VALUES ("JB1_22","019_1_22","JOB","1","22","22","Okantawitaka awishimotakari maaroni iroka-payi, ti inkaaripiro-waitanaki Job, ti iñaawaiti aparoni ñaantsi kowiinka-tatsiri inkisimatiri Pawa. ");
INSERT INTO prq_vpl VALUES ("JB2_1","019_2_1","JOB","2","1","1","Okanta pasini kitaitiri yapiitakiro ijajiitzini maninkari-payi inkimiri Pawa opaita inkantiriri, ari imatzitanaaro aajatzi Mishatantaniri ijataki irirori inkimiri Pawa inkantiriri. ");
INSERT INTO prq_vpl VALUES ("JB2_2","019_2_2","JOB","2","2","2","Ikantawa-jiri Pawa yoka Mishatantaniri: “¿Tsikama pipoñaana-jaroka?” Ikantzi Mishatantaniri: “Nopoñaajaro anta nokinakina-waitzi naniitziro maaroni kipatsi.” ");
INSERT INTO prq_vpl VALUES ("JB2_3","019_2_3","JOB","2","3","3","Ikantziri Pawa yoka Mishatantaniri: “¿Piñaakirima nompira-tani Job? Tikatsi siyaari-ni irirori anta kipatsiki, kamiitha-siri inatzi yoka notomiyaayi, tampatzika-siriri ikantaka, pinkatha iwana, iwinkani iwiro kaaripirori, aamawinta ikanta ti ininti iyaaripiro-tanti. Ainiromaita ikamiitha-siritzi, okantawitaka pinintakaa-witakana awiroka nosinitimiri pinkaaripiro-takairimi.” ");
INSERT INTO prq_vpl VALUES ("JB2_4","019_2_4","JOB","2","4","4","Yakanaki Mishatantaniri, ikantzi: “Airorika yantaitsiniri iwathaki aparoni atziri, apatziro onimowaitiri. Tima kantacha isinitiro aparoni atziri maaroni tzimimo-tziriri iwawisaako-tantyaarori yañaan-tari airo ikamanta. ");
INSERT INTO prq_vpl VALUES ("JB2_5","019_2_5","JOB","2","5","5","Intsityaa pantiniri itonki-payi aajatzi iwatha. Ari piñaakiri inkisima-waitanakimi awiroka.” ");
INSERT INTO prq_vpl VALUES ("JB2_6","019_2_6","JOB","2","6","6","Ikantzi Pawa: “Piñaakiri awiroka pimatiri tsika okanta pikowakiri. Airomaita pantsitiniri yañaa-mintoki.” ");
INSERT INTO prq_vpl VALUES ("JB2_7","019_2_7","JOB","2","7","7","Piyanaka mishatantaniri ikinkitha-waitakairi Pawa, ikantakaa-karo omatiri kowiinka-piro-tatsiri mantsiya-rintsi, ithonka ipathaa-waitanaki iwathaki itanakaro iitziki irojatzi ipatziitoki. ");
INSERT INTO prq_vpl VALUES ("JB2_8","019_2_8","JOB","2","8","8","Jataki Job kaarasi-masiki, saikawaitaki samampoki. Yaaki kowitzishitaki, irootaki ikaintantari iwathaki. ");
INSERT INTO prq_vpl VALUES ("JB2_9","019_2_9","JOB","2","9","9","Okantakiri iina: “¿Irojatzima pikantziro pikamiitha-siritzi? ¡Pinkisimatiri Pawa, pinkami!” ");
INSERT INTO prq_vpl VALUES ("JB2_10","019_2_10","JOB","2","10","10","Ikantanaki irirori: “¡Kooyá! Pisiya-kotakaro piñaawaitaki aparoni kooya kaari iyowai-matsi-tatsini. ¿Tima ipairo Pawa okaratzi kamiitha-tzimo-tairi, airoma ipairo aajatzi okaratzi kowiinka-tzimo-yitai-ni?” Okantawitaka awishimotakiri Job maaroni iroka-payi, ti inkaaripiro-waiti, ti iñaawaiti aparoni ñaantsi kowiinka-tatsiri. ");
INSERT INTO prq_vpl VALUES ("JB3_1","019_3_1","JOB","3","1","1","Ikanta iñaakiro Job okaratzi awishimo-yitakiriri, tira imairitanaji, ñaawaitanaki imishatziro kitaitiri itziman-takari pairani. ");
INSERT INTO prq_vpl VALUES ("JB3_2","019_3_2","JOB","3","2","2","Iñaawai-tanaki sintsiini, ikantanaki: ");
INSERT INTO prq_vpl VALUES ("JB3_11","019_3_11","JOB","3","11","11","¿Paitama kaari ookantana pairani asitanari ainiro omotyaatana? ¿Paitama kaari nokaman-tapaaka owakira notzimapaaki? ");
INSERT INTO prq_vpl VALUES ("JB19_25","019_19_25","JOB","19","25","25","Iro kantacha, noyotzi naaka añaatsi Owawisaakotaanari. Iriitaki kisakowin-tajyaana-ni apaata aka kipatsiki. ");
INSERT INTO prq_vpl VALUES ("JB19_26","019_19_26","JOB","19","26","26","Onkanta-witakyaa omparyaa-pithayiti iroka nomisina, Aritaki noñaajiri Pawa koñaaroini nowathaki. ");
INSERT INTO prq_vpl VALUES ("JB27_1","019_27_1","JOB","27","1","1","Aikiro iñaawai-tanakitzii Job, ikantanaki: ");
INSERT INTO prq_vpl VALUES ("JB27_6","019_27_6","JOB","27","6","6","“Nasi nowiro nokamiitha-siritzi, tikatsi ookakai-naro-ni, Noyotzi naaka, ti ontzimi kaaripirori nantzimo-tantiri inkantakoitinari.” ");
INSERT INTO prq_vpl VALUES ("JB30_26","019_30_26","JOB","30","26","26","Nosiyakaa-minthai-tzi oshiki nonkimo-siri-waiti, opokimo-tasi-takana kaaripirori. Noyaako-minthai-tziro nonkitainka-takoti, opokimo-tasi-takana tsitinikiri. ");
INSERT INTO prq_vpl VALUES ("JB30_27","019_30_27","JOB","30","27","27","Ti onkarati oimiraa-siritana, Tima oshiki kitaitiri nonkimaantsiwaityaa. ");
INSERT INTO prq_vpl VALUES ("JB30_28","019_30_28","JOB","30","28","28","Owasiri nokantaka, ti noñaajiri ooryaatsiri, Nokatziyaka yapato-tapiinta ashininka-payi, nokowako-witakari inisironkatina. ");
INSERT INTO prq_vpl VALUES ("JB31_2","019_31_2","JOB","31","2","2","¿Tsikama inkantinaka Pawa Inkiti-satzi? ¿Paitama yantzimo-tinari Sintsi-pirori poñaachari jinoki? ");
INSERT INTO prq_vpl VALUES ("JB31_3","019_31_3","JOB","31","3","3","¿Tima iwasankitairi irirori antzirori kowiinkari? ¿Tima iwasinonkairi antzirori kaaripirori? ");
INSERT INTO prq_vpl VALUES ("JB31_4","019_31_4","JOB","31","4","4","¿Tima iyotziro Pawa okaratzi nantziri? ¿Tima iñiiro okaratzi naatzika-yitzi tsika-rikapayi naniitzi? ");
INSERT INTO prq_vpl VALUES ("JB31_5","019_31_5","JOB","31","5","5","“¿Nokinkisiritama naaka nonthaiya-waityaa? ¿Nosiyatyaama nojayiti namatawi-tanti?” ");
INSERT INTO prq_vpl VALUES ("JB31_6","019_31_6","JOB","31","6","6","¡Yaajina Pawa imonkarata-mintoki, Irootaki tampatzika-tatsiri omonkaratantzi, otinatziro okaratzi nantziri kamiitha-tatsiri! ");
INSERT INTO prq_vpl VALUES ("JB38_1","019_38_1","JOB","38","1","1","Ari yakanakiri Pawa yoka Job isaikantakaro tampyaa, ikantziri: ");
INSERT INTO prq_vpl VALUES ("JB38_4","019_38_4","JOB","38","4","4","“¿Tsikama pisaikika awiroka owakira nowitsikan-taka-rori kipatsi? ¡Pakina, omaapiro-rika piyotanita! ");
INSERT INTO prq_vpl VALUES ("JB38_5","019_38_5","JOB","38","5","5","¿Kaarima naaka nintaintsi tsika owiraa-thapi-yityaa kipatsi? ¿Kaarima naaka monkara-tantakarori siwitha iroka kipatsi? ");
INSERT INTO prq_vpl VALUES ("JB38_6","019_38_6","JOB","38","6","6","¿Kaarima naaka kisotakaa-kirori kipatsi nowitsikan-taka-rori? ¿Osiyawai-takaro nowakiromi mapipayi onampinaki pankotsi onkisotan-tyaari? ");
INSERT INTO prq_vpl VALUES ("JB38_7","019_38_7","JOB","38","7","7","Tima irootaki nantakiri pairani nowitsikan-taka-rori iroka kipatsi, yakiwainka-jiitara ipanthaa-jiitzi kitaitakori impokiropayi, Tima kimosiri ikantajiita yokaiti imaninkariti Pawa. ");
INSERT INTO prq_vpl VALUES ("JB42_1","019_42_1","JOB","42","1","1","Yakanaki Job ikantana-kiri Pawa: ");
INSERT INTO prq_vpl VALUES ("JB42_2","019_42_2","JOB","42","2","2","Noyotzimi naaka pithonkiro pantayitziro maaroni, Noyotzimi awiroka asitarori maaroni kinkisiryantsi. ");
INSERT INTO prq_vpl VALUES ("JB42_3","019_42_3","JOB","42","3","3","¿Tsikama nopaitaka naaka, airo otzimi-motantana noyotani, nonkiso-siri-wintantyaarori piyomitaa-nari? Noñaawai-tasi-waitaka naaka, titzimaita nonkima-thatiro noñaawai-tziri, Tima omapokakina ti noñaapiintiro naaka awisi-mota-kinari, oshiki okompi-tzimo-takana. ");
INSERT INTO prq_vpl VALUES ("JB42_4","019_42_4","JOB","42","4","4","Pinkimi, nonintzi noñaanatimi. Pakina onkarati nosampi-timiri. ");
INSERT INTO prq_vpl VALUES ("JB42_5","019_42_5","JOB","42","5","5","Apatziro nokima-sitami piñaawaitzi, ti noñaa-maityaami, Irooma iroñaaka noñaakimi, naminakimi koñaaroini. ");
INSERT INTO prq_vpl VALUES ("JB42_6","019_42_6","JOB","42","6","6","Irootaki nokisa-siryaawaitan-takari naaka, Noñiiro nosaika-waimatsitaki samampoki, aajatzi kaarasi-masiki iñaantai-tyaanari nowashaan-tajiro noñaawai-tasi-waitakari. ");
INSERT INTO prq_vpl VALUES ("JB42_10","019_42_10","JOB","42","10","10","Ikanta yamana-kotairi Job itsipamintha-tanipayi, ikantakaa-karo Pawa awishi-motairi ikimaatsi-waita-kari. Imaapiro-takiniri ishikyaaji-niri tzimimo-tairi-ni Job, anaanakiro oshiki-pirotzi okaratzi tzimimo-witariri owakiraini. ");
INSERT INTO prq_vpl VALUES ("JB42_11","019_42_11","JOB","42","11","11","Ipokajiitakini iririntzi, iritsiro-payi, aajatzi ikaratzi ñiiriri pairani. Yakyoo-jiitapajirini iwankoki. Oshiki oimosirinka-yitakiriri, ikantziri: “¡Ñaamisa! Oshiki iwasinonkaa-kimi Pawa, patsipi-takaro pikimaatsi-waita-kari.” Oshiki ipasiyi-takari ikaratzi ariitaka-riri iwankoki, tzimatsi opakiriri kiriiki, pasini ipayitakiri ikantatipoyita ooro. ");
INSERT INTO prq_vpl VALUES ("JB42_12","019_42_12","JOB","42","12","12","Itasonka-wintajiri Pawa yoka Job, yanaakaa-kiri tsika ikantawita owakiraini. Oshiki-piro-tanaji ipirayitari. ");
INSERT INTO prq_vpl VALUES ("JB42_13","019_42_13","JOB","42","13","13","Itzimaji 7 itomi, aajatzi mawa irisinto.");
INSERT INTO prq_vpl VALUES ("PS5_4","020_5_4","PSA","5","4","4","Iwaamthaani David ¡Pawá! Ti piniwityaaro awiroka kowiinka-tatsiri, Airo okantzi yaapatyaa-jimi kaaripiro-tatsiri. ");
INSERT INTO prq_vpl VALUES ("PS5_5","020_5_5","PSA","5","5","5","Airo okantzi intsipa-tyaami kanta-pirowairitsi-payi. Tima kisaniinta piwiri awiroka ikaratzi antzirori kaari-pirori. ");
INSERT INTO prq_vpl VALUES ("PS22_1","020_22_1","PSA","22","1","1","¡Pawá! ¡Pawá! ¿Paitama pookantanakanari? ¿Paita kaari pipokanta piwawisaa-kotajina? ¿Paita kaari pikimantana nasinonkaa-waita? ");
INSERT INTO prq_vpl VALUES ("PS22_2","020_22_2","PSA","22","2","2","¡Pawá! Nokaima-witami kitaitiri, titzimaita pakina. Nomawitakaro tsitini-paiti, titzimaita nisitakoti, ");
INSERT INTO prq_vpl VALUES ("PS22_3","020_22_3","PSA","22","3","3","Iro kantacha, tasorintsi pinatzii awiroka, Tima pisaiki awiroka tsika ipanthaa-jiitzi Israel-iiti. ");
INSERT INTO prq_vpl VALUES ("PS22_4","020_22_4","PSA","22","4","4","Awiroka yawintaaka pairani nowaisatziti-payi. Yawintaa-yitakami, pookakaa-winta-yitakiri awiroka. ");
INSERT INTO prq_vpl VALUES ("PS22_5","020_22_5","PSA","22","5","5","Ikowako-takimi pinkisa-wintyaari, pimatakiro pookakaa-winta-yitakiri awiroka. Yawintaa-yitakami awiroka, tikatsi owasiwintaa-waitairini. ");
INSERT INTO prq_vpl VALUES ("PS22_6","020_22_6","PSA","22","6","6","Tima atziri nonawitaka naaka, iro kantacha ikimita-kaita-kanari kinitsi. Oshiki imaninta-waitakina atziri-payi, ithainka-siri-waitakina. ");
INSERT INTO prq_vpl VALUES ("PS22_7","020_22_7","PSA","22","7","7","Isironta-winta-waitakana ikaratzi ñaayitanari, Ithainka-mawai-taitakina, itikaina-waita, ikanta-wakaa-jiitaka: ");
INSERT INTO prq_vpl VALUES ("PS22_8","020_22_8","PSA","22","8","8","“Piñaa-matsitiri awintaariri Pawa. Añaawakiri aririka yamitako-tairi. Tima inkanta-wakaa-jiitajaa oshiki inisironkatari, añaawakiri aririka iwawisaa-kotairi.” ");
INSERT INTO prq_vpl VALUES ("PS22_9","020_22_9","PSA","22","9","9","Tima awiroka kantakaakaro notziman-takari imotyaa-taitakina. Awiroka kantakaakaro nawintaan-tamiri ainiro nothotziro owaaki othomi asitanari. ");
INSERT INTO prq_vpl VALUES ("PS22_10","020_22_10","PSA","22","10","10","Awiroka asitakanari tikira-mintha nontzimiita. Ainiro nosaiki omotyaaki asitanari, awiroka Nowawani. ");
INSERT INTO prq_vpl VALUES ("PS22_11","020_22_11","PSA","22","11","11","Airo pisaika-pithatana intaina, tima okaakitaki nonkimaatsi-waityaa. Tikatsi kisakowintyaanani. ");
INSERT INTO prq_vpl VALUES ("PS22_12","020_22_12","PSA","22","12","12","Tima ithonka itzikakina kisaniintanari, ikimitakari ipiyojiita ipiraitari, Isiyakari iyatsimanka poñaachari Kithoki-jaariki, ithonka ishonkasijii-takina. ");
INSERT INTO prq_vpl VALUES ("PS22_13","020_22_13","PSA","22","13","13","Paraanka ikantajiitaka ikaratzi kisaniintanari, Ikimitakari kashikari iwari iwathatsiti, iraikithanthaiki. ");
INSERT INTO prq_vpl VALUES ("PS22_14","020_22_14","PSA","22","14","14","Tima nokimitakaro naaka nijaa isakoitziri, Tima ithonka okithoryaa-yitaki notonki. Okimiwai-takaro nasankani owyaata-tyiiyaa, tima ithonka owyaataka inthompointa. ");
INSERT INTO prq_vpl VALUES ("PS22_15","020_22_15","PSA","22","15","15","Tima piryaa-kintsi nokantaka, osiyawai-takaro opiryaa-pitokitzi kowitzi. Otsirikaka nonini nopanti-waantiki. Tima pookakina tsika opiryaa-panitzi kipatsi nonkami. ");
INSERT INTO prq_vpl VALUES ("PS22_16","020_22_16","PSA","22","16","16","Tima ikimitakari otsitzi ipiyo-winta-jiitakana kaari-pirori, ithonka ishonka-paakina. Imorontawai-takina nakoki aajatzi noitziki. ");
INSERT INTO prq_vpl VALUES ("PS22_17","020_22_17","PSA","22","17","17","Oyosiita-sitaka nomisina, koñaa-porokitaki notonki. Oshiki yamina-mintha-takina kisaniintanari. ");
INSERT INTO prq_vpl VALUES ("PS22_18","020_22_18","PSA","22","18","18","Ipawakaakaro nomanthaki. Iñaariwintakaro noithaari. ");
INSERT INTO prq_vpl VALUES ("PS22_19","020_22_19","PSA","22","19","19","¡Irooma awiroka Pawa, airo pookana! Awiroka sintsi-takaa-janari. Pimpoki sintziini pinkisa-winta-jyaana. ");
INSERT INTO prq_vpl VALUES ("PS51_1","020_51_1","PSA","51","1","1","¡Pawá! Awiroka nisironka-taniri, pinkaminthaajina. Kaminthaan-taniri pinatzii, pimpyaako-tajinaro nokinakaasitani. ");
INSERT INTO prq_vpl VALUES ("PS51_2","020_51_2","PSA","51","2","2","Piwashaanta-kainaro nantakiro kaari kamiitha-tatsiri. Pinkimi-takairo pishita-jinaromi nokaaripirotaki. ");
INSERT INTO prq_vpl VALUES ("PS51_3","020_51_3","PSA","51","3","3","Noyotzi oshiki nopiyatha-waitakami. Ti onkanti nomaisantiro nokaaripirotaki. ");
INSERT INTO prq_vpl VALUES ("PS51_4","020_51_4","PSA","51","4","4","Apatziro nokaaripiro-tzimo-takimi awiroka. Nantasi-takaro okaratzi pipinka-kaanari. Tima onkarati pinkantajiri awiroka, tampatzika onkantyaa, Kitisiriri pinatzii awiroka pimatan-tarori pikisawintanta. ");
INSERT INTO prq_vpl VALUES ("PS51_5","020_51_5","PSA","51","5","5","Kaari-pirori nokantaka, nasi nowiro owakira notzimaki. Tima omotyaa-takina asitanari tsika yantayi-taitziro kaari kamiithatatsini. ");
INSERT INTO prq_vpl VALUES ("PS51_6","020_51_6","PSA","51","6","6","Pinisironkatari awiroka kaari amatawi-tanta-tsini kapichiini. Pikanta-kaakaro awiroka noyotani-siri-tajyaa. ");
INSERT INTO prq_vpl VALUES ("PS51_7","020_51_7","PSA","51","7","7","Pinkimi-takajyaana pinkaatan-tajyaa-naromi kaasi-rontsi, airo noipatsi-siri-waitanta. Pisiyakairo pinkiwa-jinaromi nañaa-minto, kitii onkantajyaa osiyaaro sharaka. ");
INSERT INTO prq_vpl VALUES ("PS51_8","020_51_8","PSA","51","8","8","Pinkanta-kaiyaaro nonkimajiro tsika inkimo-siri-taiti, aajatzi tsika intharowintaityaa. Piwiriinta-poroki-tajina piwatsi-naawai-takina. ");
INSERT INTO prq_vpl VALUES ("PS51_9","020_51_9","PSA","51","9","9","Pinkimi-takaan-tairo pintzikaa-pitha-jiityaaromi noyaaripironka airo piñaantaaro, Pinkimi-takaantiro pishi-pitha-tajinaromi okaratzi owaaripiro-takinari. ");
INSERT INTO prq_vpl VALUES ("PS51_10","020_51_10","PSA","51","10","10","¡Pawá! Piiti-siri-tajina. Pisiyakaantiro piwakira-tajinaromi nosiri, tampatzika-siri nonkantajyaa. ");
INSERT INTO prq_vpl VALUES ("PS51_11","020_51_11","PSA","51","11","11","Airo pookana. Airo paapitha-tanaro kitikiri pitasorinka. ");
INSERT INTO prq_vpl VALUES ("PS51_12","020_51_12","PSA","51","12","12","Papiitajiro panintaa-kaiyaana pikimitajiro owakira piwawisaa-kotaana. Piwasi-tapii-tanta-jyaanaro iroopirori pitasorinka. ");
INSERT INTO prq_vpl VALUES ("PS51_13","020_51_13","PSA","51","13","13","Irootaki noyomitaan-tajyaariri ikaratzi kisimawai-tzimiri ikimisantajimi, Impiyasi-tajimi ikaratzi kaaripiro-witain-chari. ");
INSERT INTO prq_vpl VALUES ("PS51_14","020_51_14","PSA","51","14","14","¡Ñaamisa Pawá, owawisaa-kotaanarí! Pimpyaako-tajinaro nowakantaki. Kamini-waanti nompanthaa-wintajimi awiroka pitampatzika-siri-tzira. ");
INSERT INTO prq_vpl VALUES ("PS51_15","020_51_15","PSA","51","15","15","¡Pawá! Piwinthachiratakaina. Pinkatha-waanti nonkantajyaa nompanthaa-wintajimi. ");
INSERT INTO prq_vpl VALUES ("PS51_16","020_51_16","PSA","51","16","16","Tima ti onimotajimi namasi-waityaamiri nompomitiri natsipi-takaani. Ti pinintajiri okatziyainkati iyachaaryiinka nopomita-siwai-tamiri. ");
INSERT INTO prq_vpl VALUES ("PS51_17","020_51_17","PSA","51","17","17","Iro pininta-piro-tajiri awiroka Pawa piñiina onkatsi-tzimo-siri-tajina okaratzi nantzimo-tzimiri. Tima inkarati ikimita-kaantaitari iriipirori yatsipi-takaitani ipomitai-tziniriri Pawa, iriitaki atziri okatsitzimo-siri-tziri iyaari-pironka. ");
INSERT INTO prq_vpl VALUES ("PS51_18","020_51_18","PSA","51","18","18","Pinkimi-takaantiro paakamiitha-tairimi Kisakowintoni-satzi, pinisironka-tairi. Pisiyakaantiro papiita-jiromi pimpiriintairo otanto-payi Aapatyaawini. ");
INSERT INTO prq_vpl VALUES ("PS51_19","020_51_19","PSA","51","19","19","Ari inimota-jimiri ipomitai-tziri yatsipi-takaitani kamiitha-piro-tatsiri, Iriitaki mapirotaironi onkatziyainkati iyachaaryiinka impomitai-timiri, maaroni ikaratzi yasitakai-tamiri ipomitai-tziri. Aritaki impomitai-tajimiri ipiraitari pomitai-rontsiki. ");
INSERT INTO prq_vpl VALUES ("PS89_1","020_89_1","PSA","89","1","1","Ari nasi nowajiro nompanthai, nompanthaa-wintajiro inisironka-taana Pawa. Panthaa-waanti nonkanta-winta-jyaami, nonkantajiri inkarati incharini-tajyaari: “Ti yookantaniti Pawa.” ");
INSERT INTO prq_vpl VALUES ("PS89_2","020_89_2","PSA","89","2","2","Nonkantaji aajatzi: “Pasi piwatziiro pitakotanta. Ti pimpasini-taniti, pikimitakaro inkiti asi owiro tsika okanta iroori.” ");
INSERT INTO prq_vpl VALUES ("PS89_3","020_89_3","PSA","89","3","3","Ikantzi Pawa: “Tzimatsi nokasiyakairiri ikaratzi noyosii-tajiri naaka. Nokanta-piro-tajiri nompiratani David, nokantziri: ");
INSERT INTO prq_vpl VALUES ("PS89_4","020_89_4","PSA","89","4","4","‘Airo nookanajiri inkarati pincharini-tajyaari, Naaka kantakai-yaaroni irasi iwiro impinkathari-wintantaji.’ ” (Pishowiri-jiiti, pimpiyompi-jiiti kapichiini.) ");
INSERT INTO prq_vpl VALUES ("PS89_5","020_89_5","PSA","89","5","5","¡Pawá! Oshiki ikimo-siri-wintakiro inkiti-satzi okaratzi pitasonka-wintantzi. Oshiki ikinkitha-takotakimi kitisiririiti pasi piwiro awiroka ti pookantaniti. ");
INSERT INTO prq_vpl VALUES ("PS89_6","020_89_6","PSA","89","6","6","¿Tzimatsima inkiti-satzi monkara-tyaarini Pawa? ¿Tzimatsima siyaarini Pawa? Tima yanairi iriipirori jinoki-satzi.’ ");
INSERT INTO prq_vpl VALUES ("PS89_7","020_89_7","PSA","89","7","7","Tima yapatojiityaa tasorintsi-payi ipinkatha-tziri Pawa. Omapiro yiriipirotzi irirori yanaanakiri ikaratzi piyowintariri. ");
INSERT INTO prq_vpl VALUES ("PS89_8","020_89_8","PSA","89","8","8","¡Pawá Ñaapirorí! ¿Tzimatsima kimityaamini awiroka? Sintsi-pirori pinatzii. Pasi piwatziiro piriipiro-wintantzi. ");
INSERT INTO prq_vpl VALUES ("PS89_9","020_89_9","PSA","89","9","9","Otzimimo-tzimi awiroka pisintsinka pimairyan-tarori otamakaani inkaari. Pimatzitaro aajatzi osinkyaa-takaani tampyaa. ");
INSERT INTO prq_vpl VALUES ("PS89_10","020_89_10","PSA","89","10","10","Piitsinampaakiri Tharowintaa-rini, pikimita-kaantakari kaminkari. Sintsi-shimpa pikantaka, pimisiyakiri pimaimanitani. ");
INSERT INTO prq_vpl VALUES ("PS89_11","020_89_11","PSA","89","11","11","Tima awiroka asitaro maaroni inkiti aajatzi kipatsi. Awiroka owitsikakiro kipatsi, aajatzi maaroni tzimatsiri. ");
INSERT INTO prq_vpl VALUES ("PS89_12","020_89_12","PSA","89","12","12","Awiroka owitsikakiro okaratzi tzimatsiri tsika okatonkotzi aajatzi tsika okirinkatzi. Kimiwaitaka ompanthaa-tyiimi otzisi Piyopathaitoni aajatzi Pinkaitoni, opairyiiro piwairo. ");
INSERT INTO prq_vpl VALUES ("PS89_13","020_89_13","PSA","89","13","13","Tima sintsi-shimpa pikantaka, aajatzi okimitaka pako. Tima oshiki oitsinampaantaki pakopiro. ");
INSERT INTO prq_vpl VALUES ("PS89_14","020_89_14","PSA","89","14","14","Kamiitha-siri pikanta pipinkathari-wintantzi, tampatsika-siri pinatzii. Oshiki pitakotanta, osiyawaitaro iroomi jiwata-piinta-jimini piriipirotani. ");
INSERT INTO prq_vpl VALUES ("PS89_15","020_89_15","PSA","89","15","15","¡Pawá! Tima kimosiri ikanta atziri tharowinta-chari ipanthaa-wintzimi, Osiyawai-takaro yaniitajimi tsika pikoñiin-katako-tairi awiroka. ");
INSERT INTO prq_vpl VALUES ("PS89_16","020_89_16","PSA","89","16","16","Ari yasi iwairo ikimo-siritzi ipairyiiro piwairo. Tharowinta iwajimi, tima awiroka tampatzika-siriri. ");
INSERT INTO prq_vpl VALUES ("PS89_17","020_89_17","PSA","89","17","17","Omapiro, tsika pikanta awiroka, ari okanta pisintsinka, aajatzi piwaniinkaro. Tima apatziro pikanta-kaaro awiroka, aririka pininti, pimatziro pisintsita-kayina. ");
INSERT INTO prq_vpl VALUES ("PS89_18","020_89_18","PSA","89","18","18","Ikimitaro Pawa iriimi tzikaako-mintotsi. Iriitaki Itasorintsiti Israel, Awinkathariti. ");
INSERT INTO prq_vpl VALUES ("PS89_19","020_89_19","PSA","89","19","19","Pairani pikinkitha-waita-kaakiri piitisiririti, ikimakimi isiriki. Pikantziri: “Nonisironka-takari ñaapirori. Nopinkathari-takaakiri ikaratzi noyosii-takiri nasitari naaka.” ");
INSERT INTO prq_vpl VALUES ("PS89_20","020_89_20","PSA","89","20","20","Noñaakiri nompiratani David. Nosai-patzii-totan-takari notasorintsijaati. ");
INSERT INTO prq_vpl VALUES ("PS89_21","020_89_21","PSA","89","21","21","Nasi nowiro notapi-wako-tanta-jyaari nako. Sintsi-shimpa onkanta-kaiyaari noshimpa. ");
INSERT INTO prq_vpl VALUES ("PS89_22","020_89_22","PSA","89","22","22","Airo imatziri yitsinampairi ikaratzi maimani-tziriri. Ari inkimita-jyaari kaari-pirori, airo yiitsinampairi. ");
INSERT INTO prq_vpl VALUES ("PS89_23","020_89_23","PSA","89","23","23","Naaka apirotirini inkarati owayiri-tyaarini. Nonthonkajiri inkarati kisaniintirini. ");
INSERT INTO prq_vpl VALUES ("PS89_24","020_89_24","PSA","89","24","24","Tima kisokiro nonkantajyaa nonisironka-tajiri, Okantakaaro ipairyaa-piintajiro nowairo ontzimi-motan-tajyaariri isintsinka. ");
INSERT INTO prq_vpl VALUES ("PS89_25","020_89_25","PSA","89","25","25","Ari nonkanta-kaakyaaro impinkathari-wintantaji isaiki inkaariki. Imatiro aajatzi impinkathariti isaiki nijaaki-payi. ");
INSERT INTO prq_vpl VALUES ("PS89_26","020_89_26","PSA","89","26","26","Ari inkantai-tajina: “¡Pawá! Awiroka asitanari, Awiroka Nowawani, pisiyaro mapi nopitakaminto omatantari nawisakotaji.” ");
INSERT INTO prq_vpl VALUES ("PS89_27","020_89_27","PSA","89","27","27","Nonkimi-takaan-tajiri naaka nantariti notomi. Iriitaki anairini inkarati pinkatha-wintaironi kipatsi. ");
INSERT INTO prq_vpl VALUES ("PS89_28","020_89_28","PSA","89","28","28","Irasi iwiro nonisironka-tajiri irirori. Airo ampinaasita okaratzi nokasiya-kaakiriri. ");
INSERT INTO prq_vpl VALUES ("PS89_29","020_89_29","PSA","89","29","29","Tima irasi iwiro impinkathari-yitaji inkarati incharini-tajyaari. Ari inkanta-jitatyiiro ainiro iñiitziri ooryaatsiri inkitiki. ");
INSERT INTO prq_vpl VALUES ("PS89_30","020_89_30","PSA","89","30","30","Aririka iwashaantakiro itomi noñaani, Airorika ijatakairo inthotyiiro noyomitaa-kiriri, ");
INSERT INTO prq_vpl VALUES ("PS89_31","020_89_31","PSA","89","31","31","Aririka impiyatha-takyaaro nowinka-kaantani, Airorika ikimisantziro nokanta-kaantani, ");
INSERT INTO prq_vpl VALUES ("PS89_32","020_89_32","PSA","89","32","32","Ari nowasankitaakiri ipiyatha-takana, Nompasa-wintajiri ikaaripirotaki. ");
INSERT INTO prq_vpl VALUES ("PS89_33","020_89_33","PSA","89","33","33","Airotzimaita nowashaantziro nontako-tajyaari. Noisokiro nowajiri, nasi nowiro nontsipa-tajyaari. ");
INSERT INTO prq_vpl VALUES ("PS89_34","020_89_34","PSA","89","34","34","Airo nomaisantziro okaratzi nokasiya-kaakiriri. Airo noshiki nonkantiri okaratzi nokaman-takiriri. ");
INSERT INTO prq_vpl VALUES ("PS89_35","020_89_35","PSA","89","35","35","Tima Naaka Tasorintsi kasiyakaa-kiriri, Airo namatawi-tziri David, nokantakiriri: ");
INSERT INTO prq_vpl VALUES ("PS89_36","020_89_36","PSA","89","36","36","“Irasi iwiro picharini impinkatharitaji pinampiki, Ari inkanta-jitatyiiro impinkatharitaji ainiro iñiitziri ooryaatsiri aajatzi kasiri. ");
INSERT INTO prq_vpl VALUES ("PS89_37","020_89_37","PSA","89","37","37","Ari inkantai-tatyiiro isaiki, isiyaari kasiri, Irasi iwiro isaiki inkitiki. (Pishowiri-jiiti, pimpiyompi-jiiti kapichiini.) ");
INSERT INTO prq_vpl VALUES ("PS91_9","020_91_9","PSA","91","9","9","Panthaantsi Tima pisiyakaakari Pawa iriimi itikatsi-tantaitari, iro pawisako-tantaari. Pisiyakaakari Pawa Jinoki-satzi iriimi pinampi. ");
INSERT INTO prq_vpl VALUES ("PS91_10","020_91_10","PSA","91","10","10","Airo othonkaimi kaari-pirori, Airo omataimi imantsiyari ikaratzi saika-nampi-tzimiri. ");
INSERT INTO prq_vpl VALUES ("PS91_11","020_91_11","PSA","91","11","11","Ari intyaan-takimiri Pawa Imaninkariti, yaamaako-wintyaami tsika-rika pinkinayiti. ");
INSERT INTO prq_vpl VALUES ("PS91_12","020_91_12","PSA","91","12","12","Tima iriitaki thomaimini airo pantziwa-tantaro mapi piitziki. ");
INSERT INTO prq_vpl VALUES ("PS95_6","020_95_6","PSA","95","6","6","Panthaantsi Thami antyiirowa-sityaari Pawa. Thami ampinkathatiri owitsika-kairi. ");
INSERT INTO prq_vpl VALUES ("PS95_7","020_95_7","PSA","95","7","7","Tima iriitaki Awawani, iriitaki asitairi aroka-payi. Aroka osiyariri ipiratari, yaaji iwakaayitai. Pinkimairi iroñaaka Pawa iñaawaitzi, ikantzi: ");
INSERT INTO prq_vpl VALUES ("PS95_8","020_95_8","PSA","95","8","8","Airo pikiso-siri-waitzi. Pikimitari = kari pithoka-sita-kanari pairani Kisimajaariniki, iñaanta-siri-waitakana otzisi-masiki Tainkariniki. ");
INSERT INTO prq_vpl VALUES ("PS95_9","020_95_9","PSA","95","9","9","Arira ithainka-siritakina piwaisatzitini, iñaanta-siri-waitakana, iñaawijiitakaro nonisironkatakari. ");
INSERT INTO prq_vpl VALUES ("PS95_10","020_95_10","PSA","95","10","10","Okaratzi 40 osarintsi nokisakiri piwaisatziti, Nokantaki: Irasi iwiro intzipina-siri-waiti, Ti yanta-piintajiro nokowakairiri. ");
INSERT INTO prq_vpl VALUES ("PS95_11","020_95_11","PSA","95","11","11","Noyatsima-nikiini nokantanaki: Airora nariita-kaayitaari nomakoryaa-mintoki. ");
INSERT INTO prq_vpl VALUES ("PS103_20","020_103_20","PSA","103","20","20","Iwanthaani David ¡Maninkariiti, tzimatsiri isintsinka, pintharowinta-jyaari Pawa! Tima awirokaiti antzirori okaratzi ikantzimiri. Aamawinta pikanta, ti pimpiyatha-tyaari impira-tamiri. ");
INSERT INTO prq_vpl VALUES ("PS103_21","020_103_21","PSA","103","21","21","¡¡Awirokaiti maaroni iwayiriti, pinkimo-siri-wintairi Pawa! ¡¡Awirokaiti impiratani, panta-piintainiri inintziri irirori! ");
INSERT INTO prq_vpl VALUES ("PS103_22","020_103_22","PSA","103","22","22","¡Awirokaiti maaroni iwitsikani Pawa, Pintharowinta-jyaari maaroni tsika-rika-payi ipinkathari-wintantzi! ¡Tima nontharowintyaari naaka Pawa nosiriki! ");
INSERT INTO prq_vpl VALUES ("PS110_1","020_110_1","PSA","110","1","1","Iwanthaani David Iñaawaitanaki Pawa, ikantawajiri Nowinkathariti: Pisaikapaji nakopiroki ampinkathari-wintanti, Irojatzi noitsinampaan-tajyaariri kisaniintzimiri, Aripaiti intyiirowa-sita-jyaami, pimakoryaa-kitzitan-tajyaari. ");
INSERT INTO prq_vpl VALUES ("PS110_2","020_110_2","PSA","110","2","2","Iriitaki Pawa kantakai-yaaroni piitsinampaan-tajyaariri kisaniintzimiri. Pisitowa-najiro Kisakowintoniki pairikakiro owaniinkari pikotzikiiri iyotantai-tyaamiri pinkathari pinatzii. ");
INSERT INTO prq_vpl VALUES ("PS110_3","020_110_3","PSA","110","3","3","Inkimisantaimi piwayiriti, Aririka pijiwatajiri piwayirita-kaiyaari. Sintsiri pinkantajyaa irirowaitaki ikanta aparoni awankari, Osiyawaitajyaa pisintsinka amapoka-sita-jyaami, okantaranki iñiitziro itsini impokiro aririka isitowa-manaji ooryaatsiri. ");
INSERT INTO prq_vpl VALUES ("PS110_4","020_110_4","PSA","110","4","4","Iriitaki Pawa pairyii-wintzimiri, ti yoipithoka-nitiro iñaani. Awiroka asi owaironi pimpira-tasorintsitai, Ari pinkimityaari ikanta pairani Melquisedec. ");
INSERT INTO prq_vpl VALUES ("PS110_5","020_110_5","PSA","110","5","5","Isaikaki Pawa pakopiroki. Aririka inkisanakyaa, aritaki yapirotajiri pinkathari-payi. ");
INSERT INTO prq_vpl VALUES ("PS118_19","020_118_19","PSA","118","19","19","Panthaantsi Pasitaryiinaro Tasorintsi-panko, Nonkyaan-tyaari nompaasoonkitiri Pawa. ");
INSERT INTO prq_vpl VALUES ("PS118_20","020_118_20","PSA","118","20","20","Irootaki omoro iroka tsika ikyaa-piintaitzi impinka-thaitiri Pawa. Ari inkyaayitajiri tampatzika-siriri. ");
INSERT INTO prq_vpl VALUES ("PS118_21","020_118_21","PSA","118","21","21","¡Pawá! Oshiki nopaasoonkitakimi, pakakina nokowa-kotakimi. Awiroka owawisaa-kotanari. ");
INSERT INTO prq_vpl VALUES ("PS118_22","020_118_22","PSA","118","22","22","Imaninta-witakaro kipayi witsikirori pankotsi, Iro kantacha irojatzi yaitairi iroka otzinkami-pirori. ");
INSERT INTO prq_vpl VALUES ("PS118_23","020_118_23","PSA","118","23","23","Iriitaki Awinkathariti Pawa matajirori, Irootaki okiryaa-wintan-tariri. ");
INSERT INTO prq_vpl VALUES ("PS118_24","020_118_24","PSA","118","24","24","Irootaki iroka kitaitiri iwitsikakiri Pawa, Thami awisiryaawinta-jyaari, ankimo-siri-wintajiri iroñaaka iroka kitaitiri. ");
INSERT INTO prq_vpl VALUES ("PS118_25","020_118_25","PSA","118","25","25","¡Pawá! ¡Piwawisaa-kotajina! Pinkaminthayina Pawa, ari onkantyaa ojatantyaari kamiitha onkarati nantayitiri! ");
INSERT INTO prq_vpl VALUES ("PS118_26","020_118_26","PSA","118","26","26","¡Tasonka-wintaari ikantaja, tima Pinkathari inatzii otyaanka-kiriri! Ari nosaika-jiitaki Tasorintsi-pankoki namanako-wintzimi intasonka-wintaitimi. ");
INSERT INTO prq_vpl VALUES ("PS118_27","020_118_27","PSA","118","27","27","Pinkathari inatzii Pawa, iriitaki oorinta-kota-kairi. Ajati antsipata-jyaari airikayita-kirori kompiro-pina-payi. Thami ajajiiti irojatzi pomitai-rontsiki tzimatsiri ochii onampi-naki. ");
INSERT INTO prq_vpl VALUES ("PS148_1","020_148_1","PSA","148","1","1","Panthawintaantsi ¡Pinpathawintajiri Pawa inkitiki! ¡Pintharowinta-jyaari jinokinta! ");
INSERT INTO prq_vpl VALUES ("PS148_2","020_148_2","PSA","148","2","2","¡Pimatajiro awirokaiti maninkariiti, pintharowinta-jyaari! ¡Awirokaiti iwayiriti inkiti-satzi, pintharowintyaari! ");
INSERT INTO prq_vpl VALUES ("PS148_3","020_148_3","PSA","148","3","3","¡Aajatzi awiroka ooryaatsiri, kasiri, pintharowintyaari Pawa! ¡Pimatajiro awiroka ikaratzi oorinta-chari, pintharowintyaari! ");
INSERT INTO prq_vpl VALUES ("PS148_4","020_148_4","PSA","148","4","4","¡Pintharowinta-jyaari awiroka, Jinoki-piro-satzi, Pimatajiro awiroka, nijaa saikatsiri inkitiki! ");
INSERT INTO prq_vpl VALUES ("PS148_5","020_148_5","PSA","148","5","5","Pintharowinta-jyaaro iwairo Pawa, Tima apatziro iñaawaitaki irirori, owitsika-yitanakami awiroka-payi.");
INSERT INTO prq_vpl VALUES ("IS1_1","024_1_1","ISA","1","1","1","Iroka ikinkitha-takiri Isaías, itomi Amós, iñaakai-takiri onkarati awisatsini Aapatyaawiniki, aajatzi pasiniki inampitsiti-payi Judá-iti, ainiro ipinkatharitzi Uzías, Jotam, Acaz aajatzi Ezequías. ");
INSERT INTO prq_vpl VALUES ("IS6_1","024_6_1","ISA","6","1","1","Ikanta ikamaji pinkathari Uzías, ari iñaakakana Pawa ithointaka jinoki iwinkathari-mintoki, yanaantakaro opatzi iithaari Tasorintsi-panko. ");
INSERT INTO prq_vpl VALUES ("IS6_2","024_6_2","ISA","6","2","2","Tzimatsi inkiti-wiri-payi paamathai-taintsiri yaatzinkaka ipatziitoki Pawa. Otzimimo-tziri 6 isiwanki. Apiti isiwanki ipasika-poro-tantari, apiti ipasikantaka iitziki, apiti yarantari. ");
INSERT INTO prq_vpl VALUES ("IS6_3","024_6_3","ISA","6","3","3","Iriitaki apiiyapii-tzirori ikaimajiitzi, ikantzi: “¡Tasorintsí! ¡Tasorintsí! ¡Tasorintsi inatzii Pawa Ñaapirori! Iñiitairo maaroni kipatsiki iwaniinkaro.” ");
INSERT INTO prq_vpl VALUES ("IS6_4","024_6_4","ISA","6","4","4","Okanta ikampini-tanaki iñaawaitzi, antaroiti onikanaka asitakoro Tasorintsi-panko, kachaaryiinka okantanaka. ");
INSERT INTO prq_vpl VALUES ("IS6_5","024_6_5","ISA","6","5","5","Ari nokanta-siri-tanaki: ¡Ikanta-machiitana, kamakina! Tima noñaajiri Nowinkathariti Pawa Ñaapirori. Kaari-piro-waantiri nonatzii, nosaiki-motziri kaari-piro-waantiri.” ");
INSERT INTO prq_vpl VALUES ("IS6_6","024_6_6","ISA","6","6","6","Ari ipokasi-tapaakina aparoni inkiti-wiri. Yamakina paamari-minki yaakiri pomitai-rontsiki yairikan-takari yawita-minto. ");
INSERT INTO prq_vpl VALUES ("IS6_7","024_6_7","ISA","6","7","7","Itzinkan-takanaro paamari-minki nopaantiki, ikantana: “Pamini, itsitokakami pipaantiki paamari-minki. Iriitaki apirota-jimironi pikowiinkataki, Ipyaako-tajimiro pikaaripiro-witaka.” ");
INSERT INTO prq_vpl VALUES ("IS6_8","024_6_8","ISA","6","8","8","Nokimatzii iñaawai-tanaki Awinkathariti, ikantzi: “¿Paitama nontyaantiri? ¿Paitama antyaantiri inkamantanti?” Ari nakanakiri naaka, nokantziri: “Naaka pintyaanti.” ");
INSERT INTO prq_vpl VALUES ("IS6_9","024_6_9","ISA","6","9","9","Ari ikantanakina: “Pimatiro, pinkamantiri atziri-payi, pinkantiri: ‘Ari pinkima-wityaa, airotzimaita pikimathatziro. Ari paminawityaa, airotzimaita piñiiro.’ ");
INSERT INTO prq_vpl VALUES ("IS6_10","024_6_10","ISA","6","10","10","Awiroka kantakai-yaaroni inkiso-siri-tajitan-tyaari, Atsikimpitya inkantaityaa, imawityaakiyiti. Irootaki airo yokichaa-tanta, Airo ikimi, Airo ikimatha-tantaro, Tima airo ikimisantai, airo yawisakotai aajatzi.” ");
INSERT INTO prq_vpl VALUES ("IS6_11","024_6_11","ISA","6","11","11","Nokantziri: “¡Nowinkatharití! ¿Onkaratika osamaniti pikantakiri?” Ikantzi irirori: “Oshiki osamanitaki, ari asi owiro irojatzi apaata yapiroi-tanta-jyaariri ikaratzi saikatsiri nampitsiki, Tima kaanki-panko onkantajyaa pankotsi-payi, Miritzi-patha onkantajyaa kipatsiki tikatsi tzimatsini. ");
INSERT INTO prq_vpl VALUES ("IS6_12","024_6_12","ISA","6","12","12","Nosikaari inkantajyaa atziri-payi, tima naaka Pawa kantakai-yaaroni. Kaanki onkantajyaa nampitsi-payi tikatsi nampita-jyaaroni. ");
INSERT INTO prq_vpl VALUES ("IS6_13","024_6_13","ISA","6","13","13","Intzimi-rika añaanain-tsini, kapichiini inkarati, Ari yapiroi-tajiri aajatzi yokaiti, inkimitai-yaaro itowaitziro inchato, Intowawi-taita-kyaaro inchato irojatzi osaikimaityaa oponkitzi, Irootaki opirini oshootiki-yaanta-jyaari, osiyakaa-wintaro okithoki tasorintsi-tatsiri.” ");
INSERT INTO prq_vpl VALUES ("IS7_1","024_7_1","ISA","7","1","1","Okanta inampitsiti Judá-iti ipinkathari-tantari Acaz, itomi Jotam, icharini Uzías, ikinkithasiritaka Rezín, iwinkathariti Tonkaironisatzi, yaapatyii-yaari Peka, itomi Remalías, iwayiri-tyaari Aapatyaawini-satzi. Inintzi inkyii inampitsitiki, titzimaita imatiri. ");
INSERT INTO prq_vpl VALUES ("IS7_2","024_7_2","ISA","7","2","2","Ari ikamantai-takiri pinkathari Acaz aajatzi icharini pinkatharini David, ikantai-tziri: “Yaapatyaakari Tonkaironisatzi ashininka-thori Efraín-iti.” Antaro oimiraa-nakiri pinkathari, piyonkawaitanaka, ari ikantakari aajatzi saika-panko-tziriri, ikimita-kotanakaro otasonkiro tampyaa inchatosi. ");
INSERT INTO prq_vpl VALUES ("IS7_3","024_7_3","ISA","7","3","3","Ikanta Pawa iñaanatairi Isaías, ikantajiri: “Paanakiri pitomi Sear-jasub, pimonthai-yaari pinkathari Acaz othapiki owaanka-naata nijaa, pinkina-nakiro anta Kiwaaronchaaki. ");
INSERT INTO prq_vpl VALUES ("IS7_4","024_7_4","ISA","7","4","4","Pinkanta-wakiri: ‘Piriipiroti, tikatsi pintharowantyaa. Tonta-siri pinkantyaa, airo pitharowantari apiti kimitakariri ikachaatzi paamari. Yokapayi Rezín, Tonkaironisatzi, aajatzi itomi Remalías. Tima katsimaki-witaka ayimatziri imasirinka. ");
INSERT INTO prq_vpl VALUES ("IS7_5","024_7_5","ISA","7","5","5","Tima yaapatyaakari Tonkaironisatzi ashininka-payi Efraín-iti, aajatzi itomi Remalías, inintajiitaki iwasinonkaimi. Ikantajiitaki: ");
INSERT INTO prq_vpl VALUES ("IS7_6","024_7_6","ISA","7","6","6","“Thami ajati iipatsitiki Judá-iti. Thami amintharowiri onkini ankyaayiti. Aririka amatakiri aitsinampairi, iriitaki itomi Tabeel awiri impinkathari-wintairi.” ");
INSERT INTO prq_vpl VALUES ("IS7_7","024_7_7","ISA","7","7","7","Iro kantacha, ikantzi irirori Pawa: ¡Airo omata irokawí! ");
INSERT INTO prq_vpl VALUES ("IS7_8","024_7_8","ISA","7","8","8","Tima yoka Rezín apatziro impinkathari-matsiti Ontyaamairiniki, Otzinkami nampitsi Tonkaarini. Aririka awisaki 65 osarintsi, yapiroitiri Efraín-iti airo iñiitairo inampitsiti. ");
INSERT INTO prq_vpl VALUES ("IS7_9","024_7_9","ISA","7","9","9","Tima iriitaki itomi Remalías pinkathari-matsi-tatsi Ositikii-toniki, otzinkami inampi Efraín-iti. Airorika piriipiro-jiitzi, ari yapiroi-takimi aajatzi awirokaiti.” ");
INSERT INTO prq_vpl VALUES ("IS7_10","024_7_10","ISA","7","10","10","Ari yapiitakiro Pawa iñaanatziri Acaz, ikantziri: ");
INSERT INTO prq_vpl VALUES ("IS7_11","024_7_11","ISA","7","11","11","“Iroka pimatan-tyaarori pawintaa-jyaana, pinkampitina noñaakaimiro kaari piñaa-piintzi. Kantacha noñaakaimiro osaawikinta, aajatzi ojinoki-piro-tzinta.” ");
INSERT INTO prq_vpl VALUES ("IS7_12","024_7_12","ISA","7","12","12","Ari yakanaki Acaz, ikantzi: “Ti onkamiithati noñaanta-waityaari Pawa nonkowa-kotiri iñaakaina kaari noñaa-piintzi.” ");
INSERT INTO prq_vpl VALUES ("IS7_13","024_7_13","ISA","7","13","13","Ikantzi Isaías: “¡Awiroka icharini pinkatharini David! Pinkimina. Tima aasiryiimi piñaasirinkiri atziri-payi. ¿Aikiro pinintatzii piñaasirinkiri aajatzi Awawani? ");
INSERT INTO prq_vpl VALUES ("IS7_14","024_7_14","ISA","7","14","14","Ti pinintatyii awiroka pinkowa-kotiri kaari piñaa-piintzi, iriita-jaantaki Awinkathariti ñaakaimironi inintziri irirori. Iroka iñaakaimiri: Ari owaiyantaki kooya kaari yotirini sirampari, Intzimi otomi, ipaitaitiri “Itsipatai Pawa”. Tima iroka wairontsi, irootaki ikantziri iñaaniki iriroriiti “Emanuel”. ");
INSERT INTO prq_vpl VALUES ("IS8_1","024_8_1","ISA","8","1","1","Ari ikantakina Pawa: “Payi antaro incha-kota pisankinatiro, kamiitha onkoñaati pisankinari, onkanti: ‘Mahersalal-hasbaz’. Ikantai-tziro: ‘Irootaintsi inosikan-taiti, yapirotan-taiti’. ");
INSERT INTO prq_vpl VALUES ("IS8_2","024_8_2","ISA","8","2","2","Pawintyaari Ompira-tasorintsi-taari Urías aajatzi Zacarías itomi Jeberequías, iriitaki kantatsini: ‘Jii, ari okanta.’ ” ");
INSERT INTO prq_vpl VALUES ("IS8_3","024_8_3","ISA","8","3","3","Okanta osamanitaki, naaki noina ñaawyawai-taniro. Nowaiyan-takaakiro, itzimaki otomi. Ikantakina Pawa: “Pimpaitiri wairontsi pisankina-takiri: ‘Mahersalal-hasbaz’. ");
INSERT INTO prq_vpl VALUES ("IS8_4","024_8_4","ISA","8","4","4","Tikira iyotanaki iinchaa-niki inkanti: ‘apaa,’ ‘ina,’ yapiroi-takiro nampitsi Ontyaamairini aajatzi Ositikii-toni. Yaitakiro owaararontsi tzimawi-tachari anta yasityaari pinkathari-tatsini Aatzika-winiki.” ");
INSERT INTO prq_vpl VALUES ("IS8_5","024_8_5","ISA","8","5","5","Yapiitakiro Pawa, ikantana: ");
INSERT INTO prq_vpl VALUES ("IS8_6","024_8_6","ISA","8","6","6","“Yoka atziri-payi imanintakiro nijaa Tyaantaa-riniki amatsinka-chari osiyaata, Okantakaan-tziro itharowa-kaari Rezín, aajatzi itomi Remalías, ");
INSERT INTO prq_vpl VALUES ("IS8_7","024_8_7","ISA","8","7","7","Irootaki ityaantan-tyaariri Pawa ñaapirori iwinkathariti Aatzika-wini-satzi, Intsipa-takyaari iwayiriti, inkimita-paakyaaro antaroiti amaraniti nijaa Antaraani. Otarankayiti tsika okinaayitzi. Anonkaayiti tsika owiraa-chiraata nijaa. ");
INSERT INTO prq_vpl VALUES ("IS8_8","024_8_8","ISA","8","8","8","Anonkaati irojatzi iipatsitiki Judá-iti, onthonkiro anairo maaroni tsika owiraayita. ¡Ñaamisa Emanuel! Yoka pinkathari pokaintsiri, inkimityaari siwanki-tatsiri yaagatziri iyominthani. Irootaki siyakaa-wintacha tsika onkantyaa yapiroitiro apaata maaroni pipatsiti.” ");
INSERT INTO prq_vpl VALUES ("IS8_9","024_8_9","ISA","8","9","9","¡Pasini-satziiti! Papatojiityaa, antaroiti pintharowa-jiiti. ¡Intaina-satziiti! Pinkimisantiro iroka: Ontzimi-mowityaami pitonka-mintoiti, antaroiti pintharowa-jiiti, Omaa-piro, ontzimi-mowityaami pitonka-minto, pasi piwatyiiro pintharowa-jiiti. ");
INSERT INTO prq_vpl VALUES ("IS8_10","024_8_10","ISA","8","10","10","Pinkinkithasiri-wityaa pantiri, tikatsi ompai-tzimaityaa. Pininta-wityaa pantirimi airo omatzimaita, tima iriitaki Pawa tsipayitajairi arokaiti. ");
INSERT INTO prq_vpl VALUES ("IS8_11","024_8_11","ISA","8","11","11","Isintsiwintakina Pawa ti okamiithatzi nonkimita-kotyaari ikinkithasiritari pasini-satzi atziri-payi. Ikantakina: ");
INSERT INTO prq_vpl VALUES ("IS8_12","024_8_12","ISA","8","12","12","“Ti okamiithatzi pinkanta-waiti awiroka: ‘Kamanta-wakaantsi onatzi.’ Okantawitaka irootaki ikantayitakiri atziri-payi. Airo pitharowa-kaawaitaro awiroka itharowa-kaari iriroriiti. ");
INSERT INTO prq_vpl VALUES ("IS8_13","024_8_13","ISA","8","13","13","Intaini pintharowa-kaiyaari Pawa Ñaapirori matzirori otzimi-motziri isintsinka, matzirori Itasorintsitzi. Iriitaki pintharowa-kaiyaa, iriitaki pintharowa-kaiyaa intsipata-tyaami. ");
INSERT INTO prq_vpl VALUES ("IS8_14","024_8_14","ISA","8","14","14","Iriitaki kimitzi-motyaamini yoka anta isaikaitzi tikatsi awishi-motimini. Iriima Israel-iiti, ikarataki apiti ipinkathari-wintantzi, Iriitaki kimityaaroni kisotatsiri yantziwataitari, soompikintsi owaryaan-tatsiri. Iriima Aapatyaawini-satziiti, onkimitzi-motyaari iriroriiti owasirintsi. ");
INSERT INTO prq_vpl VALUES ("IS8_15","024_8_15","ISA","8","15","15","Oshiki antziwatan-tyaarini, imparyaa-yitan-tyaari, inkamayiti. Oshiki aachani owasirin-tsiki, ari isitsikayityaari.” ");
INSERT INTO prq_vpl VALUES ("IS9_1","024_9_1","ISA","9","1","1","Iroñaaka ikimaatsi-takaa-waitari Pawa yonta ashininka-payi nampitarori iipatsitiki Zabulón-iti aajatzi Neftalí-iti. Airo osamani-tzimaita inkimaatsi-waityaa. Tima ari iñiitaki apaata iroopirori waniinka-taantsi anta Tapowiniki, inampiitiki iriroriiti, tsika impiyota-jyaari pasini-satziiti, anta inkaari-thapyaaki, aajatzi intatzikironta Owaryiinkaariniki. ");
INSERT INTO prq_vpl VALUES ("IS9_2","024_9_2","ISA","9","2","2","Ikaratzi kimiwita-kariri inkinaki-tyiimi otsitini-kitzi, Ari iñaayitajirori iroopirori ootamintotsi. Otsiman-kakowi-takari yaampari kathatayiri inkinajimi sarinkawiniki. Okimiwai-taaro isaikajimi okitainkatzi. ");
INSERT INTO prq_vpl VALUES ("IS9_3","024_9_3","ISA","9","3","3","Tima pishikyaa-yitakiri atziri-payi, Poimosirinka-piro-tairi irirori. Oshiki inkimo-siri-winta-jiitimi, osiyawai-tajyaaro ikimo-siri-wintai-tziro yawiitai-tziro pankirintsi, Onkimiwai-tajyaaro ikimo-siri-wintai-tziro ipawakaaro owayiri-payi iwaararo. ");
INSERT INTO prq_vpl VALUES ("IS9_4","024_9_4","ISA","9","4","4","Tima pintsiparyaa-kowintairi awiroka impira-waitaitari, Piwatsinaryaa-kotajiri isintsiwinta-waitai-tziri, Ikaratzi ikimaatsi-takaitaka ijiwawintai-tziri, Osiyawai-takaro papirotan-takariri pairani Maimani-wini-satzi. ");
INSERT INTO prq_vpl VALUES ("IS9_5","024_9_5","ISA","9","5","5","Aritaki isaikaji kamiitha, tikatsi owayiri-tajyaarini, intaayi-tairi ikyaantari iitziki owayiriiti. Impomitainiri iithaari-payi iwayiri-tantari, okaratzi iriraanitakiri iraantsi. Inkimita-kaita-jyaaro itayiitziro katarosi-masi. ");
INSERT INTO prq_vpl VALUES ("IS9_6","024_9_6","ISA","9","6","6","Tima tzimataiki iinchaa-niki, Iriitaki ikasiya-kaakairi Pawa. Sintsinkantsi impinkathari-wintanti. Iwaitakiniri iwairo impaitaitiri Yomitaa-naantaniri Pampoyaari, Pawa Ñaapirori, Añaanita-tsiri Asitaaniri, Pinkathari-wintan-tatsiri isaikan-taitari kamiitha. ");
INSERT INTO prq_vpl VALUES ("IS9_7","024_9_7","ISA","9","7","7","Irijatzi pinkathari-wintairini incharini-yitajyaari David, Inthonka inkimakoi-tairo isintsinka. Ari onkanta-jitatyiiro isaikaitaji kamiitha, Asi owatyiiro ijiwawintantaji, Tampatzika-siri inatyii, kamiitha-siri inkantanti, Ari onkantaitatyiiyaani itanakyaaro iroñaaka. Tharowinta imatairo, Pawa Ñaapirori. ");
INSERT INTO prq_vpl VALUES ("IS13_1","024_13_1","ISA","13","1","1","Iroka ikamantai-takiriri Isaías, itomi Amós, onkarati awisatsini apaata Kompi-jaariki. ");
INSERT INTO prq_vpl VALUES ("IS13_5","024_13_5","ISA","13","5","5","Ipoñaajiita intaina pasiniki kipatsi, Tsika othapiki-tapaaja inkiti, Iriitaki yokaiti imonkara-tanta-jyaarori Pawa iyatsimanka, Tima yapirotajiro maaroni tzimatsiri aka kipatsiki. ");
INSERT INTO prq_vpl VALUES ("IS14_3","024_14_3","ISA","14","3","3","¡Israel-iití! Apaata aririka iwatsinaryaa-kotaimi Pawa pikimaatsi-waitaka, piwasiri-niinta-waita, isintsiwintai-tzimi impira-taitami pantawaiti, ");
INSERT INTO prq_vpl VALUES ("IS14_4","024_14_4","ISA","14","4","4","aritaki piñaawai-tairo iroka kinkithasiri-taantsi pinthain-kawai-tairi pinkathari-tatsiri Kompi-jaariki, pinkanti: ¡Piñaa-matsitiri aisaniintani, ari okarata-paaki ikimaatsi-takaanta! ¡Ari owiraapaaka ikantakaa-piro-waitari irirori! ");
INSERT INTO prq_vpl VALUES ("IS14_12","024_14_12","ISA","14","12","12","¡Awiroka ipaitawi-taitaka Parya, kitaitita-kori! Tima inkitiki pipoñaaka iwaryii-takimi. Awiroka iitsinampaan-tawita-chari, Itziryii-takimi kipatsiki. ");
INSERT INTO prq_vpl VALUES ("IS14_13","024_14_13","ISA","14","13","13","Pikanta-siri-witaka: “Natiiti inkitiki, Nowitsiki nowinkathari-minto, nawisanakiri impokiro-payi isaiki Pawaki. Ari nosaikiri antó okatonko-tziro, otzisiki tsika yapatota-piinta tasorintsi-tatsiri. ");
INSERT INTO prq_vpl VALUES ("IS14_14","024_14_14","ISA","14","14","14","Nojapiroti jinoki nawisanakiro ojinokitzi minkori, Nonkimi-tajyaari Jinoki-piro-satzi.” ");
INSERT INTO prq_vpl VALUES ("IS14_15","024_14_15","ISA","14","15","15","¡pijatasitaka inthopointapirotzi tsika ipinkathari-wintai-tziri kaminkariiti! ");
INSERT INTO prq_vpl VALUES ("IS29_1","024_29_1","ISA","29","1","1","¡¡Ñaamisa! ¡Iyashikariti Pawá! ¡Owaitakaantani pomitai-rontsi saikatsiri inampiki pinkatharini David! Ari awisa-matsitaji pasini osarintsi yoimosirinka-waitaityaa. ");
INSERT INTO prq_vpl VALUES ("IS29_2","024_29_2","ISA","29","2","2","Ari nowasinonkaakiri Noyashikariti, Oshiki iraawai-tachani, owasiri-niinta inkanta-jityaa, Ari onkantajyaa Aapatyaawiniki onkimita-jyaaro pomitai-rontsi, impomitaitiri maaroni. ");
INSERT INTO prq_vpl VALUES ("IS29_13","024_29_13","ISA","29","13","13","Ikantakina Pawa: “Okaratzi ichirachiraa-waitzi atziri-payi nasitari, iñaajaantaitzi okaaki-siri iwana. Ipinkatha-waanti-tasitana atziri-payi, Titzimaita isirityaana kamiitha, intaina-siri iwana. Ampinaasi-waita ipinkatha-witana, Iyomitaan-tasiwaitaro yamitari irirori. ");
INSERT INTO prq_vpl VALUES ("IS29_14","024_29_14","ISA","29","14","14","Irootaki napiitan-tajyaarori, Noñaakairi kaari iñaapiintzi atziri-payi, Pampoyaa-mintha inkanta-jiitiro kowiinka-tatsiri. Naapithatiri iyotani ikaratzi yotaniwita-chari. Nomaisanta-kayiri ikinkithasiritani kinkithasiri-witachari.” ");
INSERT INTO prq_vpl VALUES ("IS40_1","024_40_1","ISA","40","1","1","Jiroka ikantzi Piwawani: “Poimosirinka-jiri nasiyitari. Poimosirinka-jiri. ");
INSERT INTO prq_vpl VALUES ("IS40_2","024_40_2","ISA","40","2","2","Pininta-thatiri piñaanatiri Aapatyaawini-satzi. Pinkaman-tairi, pinkantiri: ‘Ari okarata-paaki impira-taitami, ipinako-wintai-takiro pikowiinkataki, Tima imapiro-takimi iwasankitaa-wintzimiro pikaaripirotaki.’ ” ");
INSERT INTO prq_vpl VALUES ("IS40_3","024_40_3","ISA","40","3","3","Tzimatsi kaimapain-tsini otzisi-masiki, inkantan-tapaaki: Piwamiithatainiri Awinkathariti tsika inkinapaaki. Pinkimi-takaan-tainiri Pawa itampatzikai-tziro awotsi. ");
INSERT INTO prq_vpl VALUES ("IS40_4","024_40_4","ISA","40","4","4","Omamiri-pathatai otinkanaa-yitzi, Owintini-yitaji otzisi, Okaratzi otzisiyitzi iroñaaka Kamitha-pathani onkantajyaa. ");
INSERT INTO prq_vpl VALUES ("IS40_5","024_40_5","ISA","40","5","5","Tima iñaakan-tajiro Pawa iwaniinkaro, inthonka yapatotajyaa atziri-payi iñaajiro. Tima iriitaki Pawa ñaawaitzirori iroka ñaantsi.” ");
INSERT INTO prq_vpl VALUES ("IS40_6","024_40_6","ISA","40","6","6","Ikantaitana: Pinkaimi. Nokantzi naaka: ¿Tsika nonkanti nonkaimi? Pinkanti: Ikimitaro atziri-payi towarisi. Tzimawitacha owaniinkaro, ikimiwaitaro towari otzimi otyaaki. ");
INSERT INTO prq_vpl VALUES ("IS40_7","024_40_7","ISA","40","7","7","Iro kantacha okama-sitzi towari, ipoñaa oparyaa-tyaakitzi, intasonkiro-rika Pawa. Iro isiyari atziri-payi towarisi. ");
INSERT INTO prq_vpl VALUES ("IS40_8","024_40_8","ISA","40","8","8","Okama-sitzi towari ipoñaa oparyaa-tyaakitzi. Irooma iñaani Pawa, asi owairo. ");
INSERT INTO prq_vpl VALUES ("IS40_9","024_40_9","ISA","40","9","9","Kisakowintoni-satzí, pintonkaji otzisiki, pikamantantiro kamiithari ñaantsi. Aapatyaawini-satzí, airo pitharowantaro piñaawaita-nakiro kamiithari ñaantsi. Pinkamantiri nampitarori iipatsitiki Judá-iti, pinkantiri: ¡Yokataki Piwawanitari awirokaiti! ");
INSERT INTO prq_vpl VALUES ("IS40_10","024_40_10","ISA","40","10","10","Ariitaka Pawa tzimatsiri isintsinka, Sintsi-pirori inatzi pinkathari Pawa. Yamajiri ikaratzi yasiyitari, yookakaa-wintakiri. ");
INSERT INTO prq_vpl VALUES ("IS40_11","024_40_11","ISA","40","11","11","Pokaki ikimitakari aamaako-wintariri ipira, ithomaa-yitajiri kiripiri, Iwajiri iniiki, kamiitha yaminajiri owakira yaninita-tsiri. ");
INSERT INTO prq_vpl VALUES ("IS52_13","024_52_13","ISA","52","13","13","Paminiri nompiratani, kamiitha onkantzi-motajyaari, Oshiki impinkatha-piro-taitiri, Impiriintai-tairi isaikaji jinoki. ");
INSERT INTO prq_vpl VALUES ("IS52_14","024_52_14","ISA","52","14","14","Oshiki tharowa-kaakariri iñaaporo-takiri, Tima kowiinka-porotaki, ti inkimitai-yaari atziri, ");
INSERT INTO prq_vpl VALUES ("IS52_15","024_52_15","ISA","52","15","15","Tima ari yokiryaa-winthajiitajiri pasini-satzi-payi, Aririka iñaayitakiri iwinkathariti, tikatsi inkanti iñaanatiri, Ari iñaajiro kaari ikinkitha-tako-witaita pairani, Inkimatha-tairo kaari ikimako-witaita pairani. ");
INSERT INTO prq_vpl VALUES ("IS53_1","024_53_1","ISA","53","1","1","¿Itzimima kimisantironi añaani? ¿Itzimima iñaakakiri isintsinka Pawa? ");
INSERT INTO prq_vpl VALUES ("IS53_2","024_53_2","ISA","53","2","2","Inkimota-tzimo-tairi Pawa inkimita-jyaaro owakira oshooki pankirintsi. Tsika okanta oparithatzi opiryaa-patha-tzira kipatsi. Ti yiriipiroti kamiitha, tikatsi miraawintyaarini, Ti iwaniinka-tzimo-tantyaa. ");
INSERT INTO prq_vpl VALUES ("IS53_3","024_53_3","ISA","53","3","3","Tima maninta iwakiri maaroni atziri, ti inintiri. Oshiki iwatsinaa-waitai-takiri, yamitakaro ikimaatsi-waita. Ikimitakari kaari inintaitzi iñiitiri. Manintaari inatzi, tikatsi nisironka-tyaarini. ");
INSERT INTO prq_vpl VALUES ("IS53_4","024_53_4","ISA","53","4","4","Iro kantacha, iriitaki aanakiro amantsiyari, Irijatzi aanakiro okaratzi akimaatsi-yitari. Asiyakaantzi arokaiti iriitaki Pawa owatsinaa-waitziriri, Iriitaki owasankitaa-waitziriri, iriitaki atsipita-kaawai-tariri. ");
INSERT INTO prq_vpl VALUES ("IS53_5","024_53_5","ISA","53","5","5","Ikintakoi-takiri okantakaan-tziro apiyatha-waiyitaka, Ikimaatsi-takai-takari okantakaan-tziro ayaari-pironka. Oshiki ikimaatsi-takai-takari, irootaki kaari añaantaaro arokaiti atsipityaarimi. Oshiki iwatsinaa-waitai-takiri, irootaki añaantaarori aroka-payi atikatsitaji. ");
INSERT INTO prq_vpl VALUES ("IS53_6","024_53_6","ISA","53","6","6","Tima maaroni arokaiti akina-waita-sitaka, Asiyakari ipiraitari ikinasi-waita. Iro kantacha Pawa, ikantakaakari yatsipi-tyaaro ayaaripironka maaroni arokaiti. ");
INSERT INTO prq_vpl VALUES ("IS53_7","024_53_7","ISA","53","7","7","Ipasawai-taitakiri, titzimaita impiyawintyaa. Ti inkimaitiri iñaawaita-painti. Ikimita-kaitakari yaitziri ipiraitari iwamaitiri. Mairi ikantaka, ti inkaima-waiti, Isiyakari ipiraitari yamiitai-tziro iwitzi. ");
INSERT INTO prq_vpl VALUES ("IS53_8","024_53_8","ISA","53","8","8","Tima yaakaan-tasitai-takari, ti ontzima-wityaa ikinakaa-sitani. Tikatsi kisakowintyaarini. Tikatsi miraawintyaarini aajatzi. Iriitaki iwamaitakiri aka kipatsiki, akantakaan-tziro arokaiti akaaripiro-yitaki. ");
INSERT INTO prq_vpl VALUES ("IS53_9","024_53_9","ISA","53","9","9","Itsipatai-takiri kaari-piro-siriri-payi itaitakiri, Isaikimowita-paintari ashaarantaniri-payi ikamawita-paintara. Tikatsi kimakotirini yantiro kaari-pirori. Tikatsi aparoni yamatawita-painti. ");
INSERT INTO prq_vpl VALUES ("IS53_10","024_53_10","ISA","53","10","10","Iriitaki Pawa nintaintsi inkimaatsi-waityaa impiratani. Iriitaki nintasi-taincha yatsipi-tyaaro kaari-pirori, Tima osamani yaminawaiti, ari iñaayita-najiri icharini-payi. Iriitaki kantakai-yaaroni omatanta-jyaari kamiitha okaratzi ikinkitha-siri-takari Pawa. ");
INSERT INTO prq_vpl VALUES ("IS53_11","024_53_11","ISA","53","11","11","Oshiki inkimaatsi-waiwityaa, ari iñaamai-tajyaaro kitainkari, Irootaki onimoniintairini. Iriitaki nompiratani tampatzika-siriri, iriitaki wawisaa-kotajirini oshiki atziri, Irijatzi atsipita-jyaaroni inkima-tina-tajyaaro iyaari-pironka-payi. ");
INSERT INTO prq_vpl VALUES ("IS53_12","024_53_12","ISA","53","12","12","Irootaki nomisaikan-tajyaariri saika-mintotsiki irasi iriipirori-payi. Intsipa-yitajyaari ñaapirori-payi owayiri yoimosirinkyaa yiitsinampaantaki. Iriitaki sinitachani inkamimo-tanti, Ari inkimita-kaitairi iriimi kaari-pirori. Tima iriitaki mataironi inkima-tina-tyaaro iyaari-pironka oshiki atziri, Irijatzi kantako-wintairini maaroni kaari-piro-siriri. ");
INSERT INTO prq_vpl VALUES ("IS54_11","024_54_11","ISA","54","11","11","¡Iwasinonkaitani nampitsí! Atsipitarori tampyaa. Tikatsi poshinkyaamini. Tima naaka witsikai-mironi pinampi, Nowitsikan-tajyaaro poriryaata-kiri mapi. Oshiki ompinata-jyaari iroka-payi mapi piyotain-chari. ");
INSERT INTO prq_vpl VALUES ("IS54_12","024_54_12","ISA","54","12","12","Nowitsikan-tajyaaro pinapiro-tachari mapi iroka atiimintotsi tsika yaminako-tantaitzi, Ari nonkanta-jirori aajatzi ikyaa-piintaitzi, nowitsikan-tajyaaro poriryaata-kiri mapi. Ari nonkimitaa-jirori aajatzi otanto nowitsikan-tajyaaro pinapiro-tachari mapi. ");
INSERT INTO prq_vpl VALUES ("IS54_13","024_54_13","ISA","54","13","13","Iriitaki Pawa yomitairiri piwaiyani-payi nampitarori anta. Ari isaikayitaji kamiitha. ");
INSERT INTO prq_vpl VALUES ("IS54_14","024_54_14","ISA","54","14","14","Tonta-siri pinkantajyaa pintampatzika-siri-yitaji. Pisaika-siwai-tajyaa, airo isintsiwinta-waitai-tzimi, Airo pitharowa-siwaita, airo okantzimo-siri-waitami tharowan-taantsi. ");
INSERT INTO prq_vpl VALUES ("IS54_15","024_54_15","ISA","54","15","15","Aririka imaimanitaitimi, ti naaka kantakai-yaaroni, Iro kantacha, aritaki piitsinampaakiri awiroka nintawi-tachani iwayiri-tyaami. ");
INSERT INTO prq_vpl VALUES ("IS61_1","024_61_1","ISA","61","1","1","Isaikantana Itasorinka Pawa, Tima Pawa saipatzii-totakinari. Ityaankakina nonkinkithata-kaajiri asinonkainkari Kamiithari Ñaantsi. Nowatsinaryaa-kotajiri okantzimo-siri-waitari. Nonkaman-tajiri inosikaitani nonkantajiri: “Aritaki pisaika-siwaitajyaa yasitako-witai-takami. Aritaki imisitowai-taimi yaakaan-tawitai-takami.” ");
INSERT INTO prq_vpl VALUES ("IS61_2","024_61_2","ISA","61","2","2","Ityaankakina nonkinkithati: “Iroñaaka osarintsiki ari inkaminthaajairi aroka-payi Pawa. Irootaki iroka kitaitiri inkisawintan-tairi Awawani.” Ityaantakina noimosirinkajiri iraakowai-tariri iyaminkariti. ");
INSERT INTO prq_vpl VALUES ("IS61_3","024_61_3","ISA","61","3","3","Ityaantakina namathai-tajiri Kisakowintoni-satzi okantzimo-siri-waitakari, Airo isaikawai-tanta samampoki. Kimosiri inkantajyaa yaniinka-tairo kasankai-nkari, airo iwasiri-waita, Kampinainka impanthaa-jiiti, airo isintsi-waitzi. Impaitaitiri ‘inchato tampatzika-siriri’, Pawa pankitakiri, iriitaki ñaakantaironi iwaniinkaro.");
INSERT INTO prq_vpl VALUES ("JR23_23","025_23_23","JER","23","23","23","Jiroka ikantaki Pawa iñaawaitzi, ikantzi: “¿Kaarima naaka Pawa saikatsiri intaina, saikita-chari aajatzi okaakiini? ");
INSERT INTO prq_vpl VALUES ("JR23_24","025_23_24","JER","23","24","24","¿Tzimatsima matironi imanapithatyaana? Apatziro naaka nothotyiiro nosaikantaro maaroni, nosaiki kipatsiki aajatzi inkitiki. Tima naaka Pawa ñaawaitzirori iroka ñaantsi.” ");
INSERT INTO prq_vpl VALUES ("JR25_1","025_25_1","JER","25","1","1","Ari tzimakotaki 4 osarintsi ipinkatharitaki inampiki Judá-iti yoka Joacim, itomi Josías. Ari iñaanatakiri Pawa Jeremías ikamantakiri opaita awishimo-tirini ishininka-payi Judá-iti. Tima owakira otzimi aparoni osarintsi ipinkatharitzi Nabucodonosor Kompi-jaariki. ");
INSERT INTO prq_vpl VALUES ("JR25_2","025_25_2","JER","25","2","2","Ikamantan-takiro Jeremías iñaani Pawa, ithonka ikimayitaki Aapatyaawini-satzi, aajatzi pasiniki inampiki-payi Judá-iti, ikantaki: ");
INSERT INTO prq_vpl VALUES ("JR25_3","025_25_3","JER","25","3","3","“Pairani awisaki okaratzi 23 osarintsi yitanta-nakarori Pawa ikamantanaro iñaani. Tima owakira yitanta-nakarori Pawa ikamantana irootaki osarintsi 13 ipinkathari-tantari Josías, itomi Amón anta inampiitiki Judá-iti. Irootaki iñaani nowawisayimiri awiroka-payi, oshiki napiita-kimiro nokaman-tzimiro. Iro kantacha, ti pinkima-jiiti. ");
INSERT INTO prq_vpl VALUES ("JR25_4","025_25_4","JER","25","4","4","Tima ityaantaki impiratani Pawa, iyamanta-niriti, titzimaita pinkimisantiri awirokaiti, oshiki pipiyatha-takari. ");
INSERT INTO prq_vpl VALUES ("JR25_5","025_25_5","JER","25","5","5","Iroka ikamantai-takiriri, ikantai-tziri: ‘Piwashaantiro pikaaripiro-waitzi, ti ampantyaaro. Aririka piwashaantairo, aritaki pisaikaji kamiitha anta kipatsiki ikasiya-kaakimiri Pawa, pasi piwairo pisaikaji anta. Tima irootaki ikasiyakai-takimiri awirokaiti, aajatzi inkarati pincharini-tajyaari. ");
INSERT INTO prq_vpl VALUES ("JR25_6","025_25_6","JER","25","6","6","Airo pipinkatha-waitziri pawaniro. Airo impira-waitami aajatzi. Airo payimata-kairi imasirinka Pawa, pipinkatha-waitziri piwitsikani-payi awiroka. Aririka pinkimisantakiro iroka, airo iwasankitaimi.’ ");
INSERT INTO prq_vpl VALUES ("JR25_7","025_25_7","JER","25","7","7","Pinkimi ikantzi Pawa: ‘Oshiki pipiyatha-takana awiroka-payi. Omapiro piwatsimaakina pipinkatha-waitakiri piwawa-niroti. Tima onkanta-kaiyaaro pipinkatha-waitakiri, aritaki piñaakiro opaita awishimo-timini.’ ");
INSERT INTO prq_vpl VALUES ("JR25_8","025_25_8","JER","25","8","8","Irootaki ikantantari Pawa Ñaapirori, ikantzi: ‘Tima pipiyatha-takana nokanta-witamiri, ");
INSERT INTO prq_vpl VALUES ("JR25_9","025_25_9","JER","25","9","9","piñiina nonkaimiri maaroni nampitarori katonkonta, nonkaimiri nompiratani Nabucodonosor, pinkathari-tatsiri Kompi-jaariki, impoki, yapirotimi iwayiri-tyaami pinampiki, yapirota-nakiri aajatzi nampitsi-payi saika-nampi-tzimiri. Pasi piwiro inthonkai-taimi, irootaki intharowa-kaita-piintyaa, oshiki impinkaitiro. ");
INSERT INTO prq_vpl VALUES ("JR25_10","025_25_10","JER","25","10","10","Naaka kantakai-yaaroni inkyaan-tyaari yokapayi pinampiki, airo ikimaitai tharowinta-waita-chani inkimo-siriti, tikatsi aawakaa-chani, airo ikimaitaji tononka-waita-tsini, tikatsi nampita-jyaaroni ootajachani tsitiniri. ");
INSERT INTO prq_vpl VALUES ("JR25_11","025_25_11","JER","25","11","11","Kaanki onkantajyaa nampitsi, tikatsi iñiitaji inthonkairo maaroni. Onkarati 70 osarintsi impira-waityaami pinkathari-tatsiri Kompi-jaariki. ");
INSERT INTO prq_vpl VALUES ("JR25_12","025_25_12","JER","25","12","12","Aririka omonkara-takyaa 70 osarintsi Kompi-jaariki, ari nonkimitairi maaroni nampitarori Kiyamori-winiki, nomatiri napirotajiri, ari napirotajiri airo iñiitajiri. Naaka Pawa, asitarori iñaani iroka. ");
INSERT INTO prq_vpl VALUES ("JR29_1","025_29_1","JER","29","1","1","Iroka isankinari Kamantan-tzinkari Jeremías. Irootaki isankina-takiri isaiki Aapatyaawiniki, ityaantziniri antarikona-payi inosikai-takiri. Ityaantziniri aajatzi Impira-tasorintsi-taari, Kamantan-tzinkari, aajatzi Aapatyaawini-satzi inosikakiri pairani Nabucodonosor yaanakiri Kompi-jaariki. ");
INSERT INTO prq_vpl VALUES ("JR29_2","025_29_2","JER","29","2","2","Aripaiti ityaantaki sankinarintsi isitowan-taari pinkathari Jeconías inosikai-tantariri pasiniki nampitsi, aajatzi ikimitai-takiro iina pinkathari, ikaratzi inampinatari iwankoki pinkathari, jiwayita-tsiri Aapatyaawiniki, maaroni Judá-iti, yotzirori iwitsika-waitzi aajatzi asiro-pakori-payi. ");
INSERT INTO prq_vpl VALUES ("JR29_3","025_29_3","JER","29","3","3","Iriitaki amakirori sankinarintsi Elasa, itomi Safán, itsipatakari Gemarías, itomi Hilcías. Iriitaki ityaantaki Sedequías, iwinkathariti Judá-iti, ijatiro Kompi-jaariki iñiiri Nabucodonosor. Iroka okantzi sankinarintsi: ");
INSERT INTO prq_vpl VALUES ("JR29_4","025_29_4","JER","29","4","4","“Iroka iñaani Pawa Ñaapirori, Iwawani Israel. Irootaki inintawi-takari inkamantiri nampiwi-tarori Aapatyaawiniki, ikantakaakaro inosikaitiri Kompi-jaariki, ikantairi: ");
INSERT INTO prq_vpl VALUES ("JR29_5","025_29_5","JER","29","5","5","‘Piwitsiki piwanko-payi, pinampi-tyaaro anta. Pimpankiti piwayityaari. ");
INSERT INTO prq_vpl VALUES ("JR29_6","025_29_6","JER","29","6","6","Paawakaiyaa, intzimi pitomi-payi aajatzi pisinto-payi, ari inkimityaa irirori-payi yaawakaiyaa intzimi iwaiyani. Pishikiti, airo pisinita inthonkaitimi. ");
INSERT INTO prq_vpl VALUES ("JR29_7","025_29_7","JER","29","7","7","Pantawaiti airo pimaimani-tantzi tsika pisaikaki, pinkantina nonisironka-tyaami. Aririka nonisironka-tyaari asitarori inampi, irootaki nisironka-taantsi piñiiri awirokaiti. ");
INSERT INTO prq_vpl VALUES ("JR29_8","025_29_8","JER","29","8","8","Naaka Pawa Ñaapirori, Iwawani Israel, pinkimi nonkanti: Paamaiyaa yamatawi-tzimi = kari kamantan-tanirori, ñaawyataniri-payi ikaratzi pisatikan-takari. Airo pakakotziri imisiri. ");
INSERT INTO prq_vpl VALUES ("JR29_9","025_29_9","JER","29","9","9","Aririka inkinkithati impairyiiro nowairo, thaiyaantsi inatzi. Ti naaka tyaantirini.’ Irootaki ikantakiri Pawa. ");
INSERT INTO prq_vpl VALUES ("JR29_10","025_29_10","JER","29","10","10","Yapiitakiro Pawa, ikantzi: ‘Aririka pimonkara-takiro awirokaiti pisaika-jiiti Kompi-jaariki onkarati 70 osarintsi, aripaiti nonisironka-tajimi, aritaki noipyaajimi pinampiitiki, irootaki nokantzi-takamiri pairani.’ ");
INSERT INTO prq_vpl VALUES ("JR29_11","025_29_11","JER","29","11","11","Ikantzi aajatzi Pawa: ‘Tima noyotzi naaka nokinkithasirita tsika nonkantimi pisaika-yitan-tajyaari kamiitha, airo pasinonkaa-waitanta, aritaki panintaajyaa apaata. ");
INSERT INTO prq_vpl VALUES ("JR29_12","025_29_12","JER","29","12","12","Aripaiti pinkampi-tajina, pamanaana, aritaki nonkimakimi pinkowa-kotinari. ");
INSERT INTO prq_vpl VALUES ("JR29_13","025_29_13","JER","29","13","13","Pamina-mina-taina, aritaki piñaajina. Tima omapiro piriipiro-winta-siri-tajina. ");
INSERT INTO prq_vpl VALUES ("JR29_14","025_29_14","JER","29","14","14","Aritaki, piñaajina. Airo apiita okaratzi piñiiri iroñaaka. Ithonka naajimi tsika pisaika-yitaki nampitsiki. Napatotajimi. Aritaki pimpiyi tsika pinampitaro pairani inosikan-taita-kamiri. Naaka Pawa, kantatsi.’ Irootaki iñaawaitakiri Pawa. ");
INSERT INTO prq_vpl VALUES ("JR30_4","025_30_4","JER","30","4","4","Iroka iñaani Pawa ikinkithata-kotziri Israel-iiti aajatzi Judá-iti. ");
INSERT INTO prq_vpl VALUES ("JR31_15","025_31_15","JER","31","15","15","Iroka ikantzi Pawa: Ikimaitaki Tonkaironiitoniki antaro iraajiita-chari. Irootaki osaro-payi kaminkaroni Raquel iraakotariri intsiti-payi. Tima tikatsi mataironi yoimosirinka-jyaaro, tima ithonka iwamai-tzitai-takiro iinchaaniti-payi. ");
INSERT INTO prq_vpl VALUES ("JR31_31","025_31_31","JER","31","31","31","Ikantzi Pawa: Paminiro onkarati awisatsini apaata, Tzimatsi owakira nonkasiya-kaajiriri Judá-iti, aritaki nomatajiro nasitakaa-jyaari maaroni Israel-iiti. ");
INSERT INTO prq_vpl VALUES ("JR31_32","025_31_32","JER","31","32","32","Airo okimitaaro nokasiya-kaakiri iwaisatzitini. Tima pairani nokimita-kaantaari nakathata-tyiirimi, Naaka jiwatairiri nomisitowan-taariri Apitantoniki. Ti imonkara-tzimaityaaro nokasiya-kaariri. Ari nosaika-witaka naaka nokimiwaitakari naakami iimi. Ari ikantaki iñaawaitaki Pawa. ");
INSERT INTO prq_vpl VALUES ("JR31_33","025_31_33","JER","31","33","33","Yapiitakiro iñaawaitaki, ikantzi: Iroka owakirari nokasiya-kaakiriri apaata incharinita-jyaari Israel: Ari noyosirita-kaayitajiri kamiithari onkarati yantayitairi. Onkimiwaityaaro nosankina-siritaa-tyiinirimi Nokanta-kaantani, Naaka inkimita-kaantai Iwawani, Iriiyitaki nasitajyaari Naaka. ");
INSERT INTO prq_vpl VALUES ("JR31_34","025_31_34","JER","31","34","34","Ti onkowa-jaantajyaa iyomitaa-wakaa-waitajyaa, Apatziro ikantayitairi ishininka: Piyosiri-pirotairi Awinkathariti. Tima maaroni iyotaitajina. Ari iyoyitajina iriipiroriiti aajatzi asinonkain-kariiti, maaroni. Oshiki naripirotajiri ikaaripiro-siri-yiwitaka, Ari nompyaakota-jiniri. ");
INSERT INTO prq_vpl VALUES ("JR32_1","025_32_1","JER","32","1","1","Okanta osarintsi 10 ipinkathari-tantari Sedequías iipatsitiki Judá-iti, ari iñaanatairi Pawa yoka Kamantan-tzinkari Jeremías. Tzimaki 18 osarintsi ipinkatharitzi irirori Nabucodonosor. ");
INSERT INTO prq_vpl VALUES ("JR32_2","025_32_2","JER","32","2","2","Tima ishonkakaro Aapatyaawini iwayiriti-payi pinkathari Kompi-jaari-satzi, yasitakoi-takiri irirori Kamantan-tzinkari Jeremías ikaankiirin-tsitiki pinkathari-tatsiri iipatsitiki Judá-iti. ");
INSERT INTO prq_vpl VALUES ("JR32_3","025_32_3","JER","32","3","3","Tima iriitaki Sedequías pinkathari-tatsiri iipatsiti Judá-iti asitako-takaan-takiriri, ikantziri: “¿Paitama pikamantantari awiroka pikantzi: ‘Iroka ikantzi Pawa: Nosinitakiro iroka nampitsi imaimani-waitiro iwinkathariti Kompi-jaari-satzi, aritaki inkyaaki aka nampitsiki.’ ” ");
INSERT INTO prq_vpl VALUES ("JR33_1","025_33_1","JER","33","1","1","Ari yapiitajiro Pawa iñaanatairi Jeremías, isaiki owaankiirintsiki tsika yasitakoi-takiri, ikantairi: ");
INSERT INTO prq_vpl VALUES ("JR33_14","025_33_14","JER","33","14","14","“Apaata aritaki nontyaantajimi kamiithari ñaantsi okaratzi nokasiya-kaakiriri pairani iwinkathariti Israel-iiti, aajatzi iwinkathariti Judá-iti. ");
INSERT INTO prq_vpl VALUES ("JR33_15","025_33_15","JER","33","15","15","Apaata aritaki nonkanta-kaakyaaro intzimi incharini-tyaari David, siyaaroni oshooka-pirinitzi inchato kamawitain-chari. Kamiitha-siri inkantajyaa impinkathari-wintantai irirori, tampatzika-siri inatyii. ");
INSERT INTO prq_vpl VALUES ("JR33_16","025_33_16","JER","33","16","16","Aripaiti yawisako-yitaji ishininka-payi Aapatyaawini-satzi ari inkanta-jyaari aajatzi maaroni Judá-iti, airo itharowa-waitaji inampiki. Irootaki owaitakaan-tirini inkantaitiri: ‘Pawa tampatzika-siri-tanta-tsiri’.” ");
INSERT INTO prq_vpl VALUES ("JR33_17","025_33_17","JER","33","17","17","Ari ikantzi Pawa iñaawaitaki, ikantzi: “Aritaki intzimaji icharini David irasi iwiro impinkathari-wintajiri ishininka Israel-iiti.”");
INSERT INTO prq_vpl VALUES ("EK28_12","027_28_12","EZK","28","12","12","Iroka iñaani Pawa, ikantzi: Awiroka oñaakan-tzirori ikamiitha-siri-taitzi, Awiroka matzirori piyotanita, waniinka-kitachari. ");
INSERT INTO prq_vpl VALUES ("EK28_13","027_28_13","EZK","28","13","13","Pinampi inawitaka Posiñaariniki, iwankiri-masiki Pawa. Pikithaa-takowitaro awiroka poriryaari mapiki nasiyita-chari oyaninanka. Pithata-nitari ooro ipaitakimiri owakira iwitsikai-takimi. ");
INSERT INTO prq_vpl VALUES ("EK28_14","027_28_14","EZK","28","14","14","Awiroka, iriipirori siwankiri kimpoyaa-wintanirí, Nowakimi tonkaariki tsika notasori-tsita-kaakiro. Iriitaki impokiro-payi pitsipata paniiwaitzi. ");
INSERT INTO prq_vpl VALUES ("EK28_15","027_28_15","EZK","28","15","15","Tikatsi pinkina-kaasityaa. Pasi piwiro owakira iwitsikai-takimi, Irojatzi pantanta-karori kaari-pirori.");
INSERT INTO prq_vpl VALUES ("DN1_3","028_1_3","DAN","1","3","3","Ikanta pinkathari Nabucodonosor ikamantakiri inampiri paitachari Aspenez, ijiwari aamaako-wintarori pinkathari-panko, ikantziri: “Pinosikiri ishininkaiti iriipirori Israel-iiti, aajatzi irasi jiwari-payi. ");
INSERT INTO prq_vpl VALUES ("DN1_4","028_1_4","DAN","1","4","4","Iriira pinosika-yitiri mainari-payi kaari amasiwaita-chani, kamiitha-yitatsiri, yotayitzirori okaratzi iyomitai-tziri, inintai-tziri pinkathari-pankoki yaamaako-wintyaaro. Iriiyitaki piyomitaa-kaantiri añaani arokaiti Kiyamoriwini-satzi, aajatzi osankinari-payi.” ");
INSERT INTO prq_vpl VALUES ("DN1_5","028_1_5","DAN","1","5","5","Ikantaki aajatzi pinkathari: “Pimpiri maaroni kitaitiri iwariti aajatzi imiri yokaiti okaratzi nowari naaka. Iriitaki iyomitaitiri onkarati mawa osarintsi. Aririka onkarataki iyomitaa-yitiri, iriira impiratani-payi iwinkathari-pankotiki.” ");
INSERT INTO prq_vpl VALUES ("DN1_6","028_1_6","DAN","1","6","6","Yoka 4 tsipata-kariri ikaratzi yaitanakiri iwinkathari-pankotiki pinkathari, ipaiyita: Daniel, Ananías, Misael aajatzi Azarías. Iriira ishininka-mirinka Judá-iti. ");
INSERT INTO prq_vpl VALUES ("DN1_17","028_1_17","DAN","1","17","17","Yokaiti mainari-payi ikantakaakari Pawa iyota-nityaa, kantatsi iyota-kotiro okaratzi isankinai-tziri anta, okaratzi iyota-nitaitari. Tima kantatsi Daniel iyota-kotiro opaita osiyakaa-wintari misirintsi-payi. ");
INSERT INTO prq_vpl VALUES ("DN1_18","028_1_18","DAN","1","18","18","Okanta omonkarataka ikantakiriri pinkathari iñaantai-tyaariri mainari-payi, yoka ijiwari aamaako-wintarori pinkatharitsi-panko, yaanakiri mainari-payi iñiiri pinkathari. ");
INSERT INTO prq_vpl VALUES ("DN1_19","028_1_19","DAN","1","19","19","Ikinkitha-waita-kaawakiri pinkathari yokaiti mainari, aajatzi ikimitaakiri maaroni mainariiti. Ti iñaamaityaa pasini-payi siyaarini Daniel, Ananías, Misael aajatzi Azarías. Irootaki isaikan-takari iwankoki pinkathari yompiratyaari. ");
INSERT INTO prq_vpl VALUES ("DN1_20","028_1_20","DAN","1","20","20","Tima inthotyiiro iyoyitziro okaratzi ikowa-kotziriri pinkathari. Yanaakiri ikaratzi saikatsiri iwankoki pinkathari yotaniyita-chari, yotantaniri aajatzi antyawiyari. ");
INSERT INTO prq_vpl VALUES ("DN5_1","028_5_1","DAN","5","1","1","Ikanta pinkathari Belsasar ikaimakiri ikaratzi iriipirota-tsiri inampiri-payi yoimosirinkyaa iwinkathari-pankotiki. Tima oshiki jataintsiri yoimosirinka-jiita, yirajiitaki oshiki iraitziri. ");
INSERT INTO prq_vpl VALUES ("DN5_2","028_5_2","DAN","5","2","2","Ikanta isinkitanaka Belsasar, ikantaki: “Pamakiri ooronaki, kiriiki-naki ikaratzi yaakiri pairani nowaisatzitini Nabucodonosor Itasorintsi-pankotiki Aapatyaawini-satzi.” Irootaki ikantantari tima inintatziiri inkitan-tyaari iraitziri, impakotan-tyaariri jiwari-payi, iinapayi aajatzi inintani-payi. ");
INSERT INTO prq_vpl VALUES ("DN5_3","028_5_3","DAN","5","3","3","Ikanta yamaita-kiniri Belsasar ooronaki-payi ikaratzi yamaitakiri pairani Itasorintsi-pankotiki Pawa, saikatsiri Aapatyaawiniki. Imatakiro ikitantari iraitziri, ipakoyitakiri ikaratzi jiwari-payi, iinapayi aajatzi inintani-payi. ");
INSERT INTO prq_vpl VALUES ("DN5_4","028_5_4","DAN","5","4","4","Tima maaroni yirajiitaki iraitziri. Ipinkatha-waitakiri iwawani-payi iwitsikai-tziri ooro, kiriiki, asiro, inchato aajatzi mapipayi. ");
INSERT INTO prq_vpl VALUES ("DN5_5","028_5_5","DAN","5","5","5","Ari omapoka-sitaka okoñaata-paaki osiyarori akotsi osankinata-paaki tantotsiki. Tima kamiitha ikoñaataki ootamintotsi, koñaaro iñiitakiro okaratzi isankinai-tziri. Ikanta iñaakiro pinkathari osiyakarori akotsi, ");
INSERT INTO prq_vpl VALUES ("DN5_6","028_5_6","DAN","5","6","6","kitiryaa-niki ikantanaka. Tima antaro itharowanaki, piyonkawaitanaka maaroni iwathaki. ");
INSERT INTO prq_vpl VALUES ("DN5_7","028_5_7","DAN","5","7","7","sintsiini ikaimanakiri yotantaniri, antyawiyari aajatzi ñaawyataniri-payi saikatsiri Kompijaari. Ikantawakiri: “Tzimatsi-rika matironi iñaanatiro sankinatain-chari, aririka ikamantantakinaro siyakaa-winta-chari, ari inkithaatan-taita-kyaari waniinkata-chari ikithaatari pinkathari-payi, inthaa-taitakiri oorotatsiri thatanintsi. Iriitaki nowajiri nonampina. Tikatsi pasini anairini yiriipiroti, apatziro yanairi nonampiri-pirori, aajatzi naaka.” ");
INSERT INTO prq_vpl VALUES ("DN5_8","028_5_8","DAN","5","8","8","Iro kantacha tikatsira yotironi sankinatain-chari, tikatsi kantirini pinkathari opaita-rika siyakaa-winta-chari. ");
INSERT INTO prq_vpl VALUES ("DN5_9","028_5_9","DAN","5","9","9","Irootaki imapirotan-tanakari okantzimo-siri-waitari pinkathari, aikiro itharowan-tanaki-tyaaro. Ari ikimitakari inampiri-payi, ti iyoti opaita-rika awisatsiri. ");
INSERT INTO prq_vpl VALUES ("DN5_10","028_5_10","DAN","5","10","10","Okanta okimakiri iina pinkathari ikaimanaki itsipatakari inampiri-payi, kyaapaaki iroori tsika yoimosirinka-jiita, okantapaakiri: “¡Pinkatharí! ¡Aritapaaki okantzimo-siri-waitami, aritapaaki pitharowa-waitaki! ");
INSERT INTO prq_vpl VALUES ("DN5_11","028_5_11","DAN","5","11","11","Tzimatsi aka Kompijaariki aparoni mainari oshiki iyota-nita. Iriitaki inampi-siritantari Itasorinka aparoi-nita-tsiri Pawa. Iyotziri pairani awaisatzitini awinkathariti Nabucodonosor. Iriitaki iwaki pairani ijiwatiri ikaratzi yotaniri-payi. ");
INSERT INTO prq_vpl VALUES ("DN5_12","028_5_12","DAN","5","12","12","Yoka mainari kantatsi iyotiro kompiyita-chari misirintsi, kaari iyotako-witaita. Ipaita Daniel. Iriitaki iwajiniri pairani Nabucodonosor pasini iwairo, ipaitajiri Aamaa-kotariri Pinkathari. Iriitaki pinkaimiri iroñaaka, aritaki inkantakimi ipaita siyakaa-winta-chari piñaakiri. ");
INSERT INTO prq_vpl VALUES ("DN5_13","028_5_13","DAN","5","13","13","Ikanta ikaimakaan-taitakiri Daniel. Ti ishintanaki ijatanaki irirori, ariitaka isaikaki pinkathari, isampita-wakiri, ikantziri: “Ari, ¿awirokatakima ishininka-payi Judá-iti inosikakiri pairani nowaisatzitini? ");
INSERT INTO prq_vpl VALUES ("DN5_14","028_5_14","DAN","5","14","14","Nokimaki ikantaitana inampi-siritantami Itasorinka Pawa. Iriitaki matakayi-mirori piyota-nitantari. ");
INSERT INTO prq_vpl VALUES ("DN5_15","028_5_15","DAN","5","15","15","Tima namakaan-tawitakari maaroni yotaniri-payi, ñaawyawaitaniri, nonintawita inkantinaro opaitari sankinata-chari otantotsiki, iro kantacha ti imatiro. ");
INSERT INTO prq_vpl VALUES ("DN5_16","028_5_16","DAN","5","16","16","Tima nokimaki aritaki pimatakiro awiroka pinkantinaro okaratzi kompitan-tachari. Aririka pinkaman-takinaro siyakaa-winta-chari sankinatain-chari otantotsiki, ari inkithaatan-taita-kyaamiro waniinkata-chari ikithaa-yitari pinkathari-payi, inthaano-taita-kyaamiri oorotatsiri thatanintsi. Awiroka nowaji nonampiri. Tikatsi pasini anaimini piriipiroti, apatziro yanaimi nonampina-pirori, aajatzi naaka. ");
INSERT INTO prq_vpl VALUES ("DN5_17","028_5_17","DAN","5","17","17","Ari yakanaki Daniel, ikantanakiri: “Pinkatharí. Aritaki nonkanta-kimiro opaita-rika siyakaa-winta-chari sankinatain-chari otantotsiki. Iro kantacha ti nonintiro pimpasityaanari, airo pininta-siwaita pinkimita-kaantina iriipirori. ");
INSERT INTO prq_vpl VALUES ("DN5_18","028_5_18","DAN","5","18","18","Iriira Pawa Jinoki-satzi oyotakaa-kiriri piwaisatzitini Nabucodonosor, ipinkatha-ritaki, iriipirori ikantaka, otzimi-motziri isintsinka aajatzi iwaniinkaro. ");
INSERT INTO prq_vpl VALUES ("DN5_19","028_5_19","DAN","5","19","19","Tima ikantakaakaro Pawa ontzimi-motiri isintsinka, irootaki ipinkathatan-takariri maaroni atziri-payi, piyonkawaitaka nampiyitarori tsikari-payi, kimathata-wakaarori iñaani tsika-rika-payi. Tima inkarati inintziri irirori airo iwamairi, airorika inintziri kantatsi iwamairi. Ikaratzi inintziri yiriipirota-kairi, aritaki imatakiro. Airorika inintziri, airo imatziniri. ");
INSERT INTO prq_vpl VALUES ("DN5_20","028_5_20","DAN","5","20","20","Iro kantacha yoka pinkathari Nabucodonosor itharowinta-waitanaka, yitanakaro iwasankitaa-waitziri atziri. Irootaki kaari ipinkatha-ritantaja, yaapithai-tairi okaratzi iwaniinkatan-tawitakari. ");
INSERT INTO prq_vpl VALUES ("DN5_21","028_5_21","DAN","5","21","21","Tima yookaitakiri Nabucodonosor, ti isaiki-motairi atziri. Ti onkamiithatanaji okaratzi yantayitziri, ikimita-kota-nakari antami-wiri kaari kimatsini. Isaikawaitzi itsipayitari katsimari, iwayitakaro katarosi ikimitakari ipiraitari. Ashiwaitakiri itsini impokiro. Ari ikantakari isaikawaitaki, irojatzi iyotantaari aparoni ikanta Pawa Jinoki-satzi ipinkathari-wintziro maaroni nampitsi-payi. Apatziro inintziri itzimi-rika ininta-kayiri impinkathariti. ");
INSERT INTO prq_vpl VALUES ("DN5_22","028_5_22","DAN","5","22","22","Pinkatharí, Belsasar, awiroka icharini Nabucodonosor, yotzirori opaita awisain-tsiri, titzimaita pintsinampa-siri-waiti. ");
INSERT INTO prq_vpl VALUES ("DN5_23","028_5_23","DAN","5","23","23","pipithoka-sitakari Pawa Inkiti-satzi, pamakaan-takiro ooronaki-payi saikawita-chari Tasorintsi-pankoki, pitsipatakari pikarajiitzi pijiwari, piinaiti, aajatzi pinintani-payi. Ari omapirotari pipinkatha-waitakiri pawaniro-payi. Pimatzi-takaro pipinkatha-waitziri piwawanitari ooro, kiriiki, asiro, kitiriri asiro, inchato, mapi, ti iñaanti, ti inkima-niti. Titzimaita pimpinkathatiri Pawa, tzimatsiri isintsinka, matzirori yañaakaa-yitzimi. ");
INSERT INTO prq_vpl VALUES ("DN5_24","028_5_24","DAN","5","24","24","Irootaki ityaantan-takarori irirori kimitakarori akotsi isankinaiti. ");
INSERT INTO prq_vpl VALUES ("DN5_25","028_5_25","DAN","5","25","25","Iroka ikantaitzi aka: ‘Mene, Mene, Tekel, Parsin’. ");
INSERT INTO prq_vpl VALUES ("DN5_26","028_5_26","DAN","5","26","26","Kanta-kota-chari ‘Mene’. Ikantai-tatzii: ari okarata-paaki inintzi Pawa pipinkatha-ritzi. ");
INSERT INTO prq_vpl VALUES ("DN5_27","028_5_27","DAN","5","27","27","Kanta-kota-chari ‘Tekel’. Ikantai-tatzii: tzimatsi isiniwitai-takamiri, paparatakiro pinkatharí. ");
INSERT INTO prq_vpl VALUES ("DN5_28","028_5_28","DAN","5","28","28","Kanta-kota-chari ‘Parsin’. Ikantai-tatzii: iporoka-tyiiro Pawa piwinkathari-pankoti, yasitakai-yaari kashitani Niyanki-wini-satzi pasini kashitani yasitakai-yaari Kyaakowini-satzi, ikantai-tziro iñaaniki pairani iriroriiti Parsin. ");
INSERT INTO prq_vpl VALUES ("DN5_29","028_5_29","DAN","5","29","29","Ti ishintanaki pinkathari Belsasar, ikantakaantaki inkithaataitiri Daniel jonkiro-masita-tsiri osiyarori irasi pinkathari, ithaanota-kaitakari thatanintsi iwitsikai-tziri ooro. Ikamantai-takiri maaroni nampitarori anta, iriitaki iwairi yoka inampiri. Tikatsi pasini anairini yiriipiroti, apatziro yanairi inampina-pirori, aajatzi irirori. ");
INSERT INTO prq_vpl VALUES ("DN5_30","028_5_30","DAN","5","30","30","Okanta otsitinitanaki, ari iwamaitakiri Belsasar iwinkathariti Kiyamoriwini-satzi. ");
INSERT INTO prq_vpl VALUES ("DN5_31","028_5_31","DAN","5","31","31","Iriira Darío poñaachari Niyanki-winiki yimpoyiitaari ipinkatha-ritai, okaratzi 62 isarintsiti yitanta-nakarori ipinkatha-ritzi. ");
INSERT INTO prq_vpl VALUES ("DN6_1","028_6_1","DAN","6","1","1","Ari inintaki pinkathari Darío iwayiti inampiri-payi inkarati 120, iriitaki amita-kotirini impinkathari-wintanti. ");
INSERT INTO prq_vpl VALUES ("DN6_2","028_6_2","DAN","6","2","2","Ikaratakira 120 inampiri-payi, tzimatsi ikaratzi mawa jiwatirini yokaiti, ari onkantyaa imatantyaarori pinkathari inintziri yantakaantiri. Iriitakira Daniel karatirini mawa jiwatirini 120 inampiri-payi Darío. ");
INSERT INTO prq_vpl VALUES ("DN6_3","028_6_3","DAN","6","3","3","Iro kantacha omapirota-tziiri irirori Daniel ikamaitaro inintziri pinkathari yantiro, yanaanakiri pasini-payi, iwakiri pinkathari ijiwatiri maaroni. Ikinkisiryaaka aajatzi pinkathari kantacha Daniel impinkathari-wintiri maaroni atziri-payi. ");
INSERT INTO prq_vpl VALUES ("DN6_4","028_6_4","DAN","6","4","4","Irootaki inintan-takari pasini inampiri-payi pinkathari iñiiri Daniel opaita-rika inkinakaa-sityaari, iro ompoñaan-tyaari inkamanta-kotiri pinkathariki. Iro kantacha ti ontzimi ompaityaa inkanta-kotiriri, tima imapirota-tyiiro Daniel ithotyiiro okaratzi yantayitziri. ");
INSERT INTO prq_vpl VALUES ("DN6_5","028_6_5","DAN","6","5","5","Iro kantacha ikanta-wakaaka pasini inampiri-payi pinkathari, ikantzi: “Tira ontzimatyii ompaityaa ankamanta-kotiriri Daniel, apatziro ankanta-kotiri ipinkatha-waitzirira iwawani irirori.” ");
INSERT INTO prq_vpl VALUES ("DN6_6","028_6_6","DAN","6","6","6","Ikanta yokaiti jiwatziriri inampiri-payi jatanaki iñiiri pinkathari Darío, iwithata-paakari ipinkathata-paakiri, ikantziri: ");
INSERT INTO prq_vpl VALUES ("DN6_7","028_6_7","DAN","6","7","7","“Pinkatharí. Maaroni jiwari-payi, aajatzi pinampiri-payi, ikinkisiryaaka ontzimi pikanta-kaantani. Airo oshinta imatantai-tyaarori pinkanta-kaantiri, onkarati aparoni kasiri, airo itzimaji aparoni pinkathatairini iwawa-niroti, aajatzi aparoni atziri, apatziro impinka-thaitajimi awiroka. Tzimatsi-rika piyathata-kyaamini, intitaitiri omoro-naki tsika ipiyota kashikari. ");
INSERT INTO prq_vpl VALUES ("DN6_8","028_6_8","DAN","6","8","8","Pinkatharí, ontzimatyii pakina noninta-kotzimiri. Pisankinatiro piwairo airo ipyaakotan-taitaro yantaitiro pikanta-kaantakiri. Tima iro okantziri ikantakaantani Niyanki-wini-satzi, aajatzi irasi Kyaakowini-satzi, tikatsira wasiñaa-jironi.” ");
INSERT INTO prq_vpl VALUES ("DN6_9","028_6_9","DAN","6","9","9","Tima isankinatakiro iwairo pinkathari Darío ikantakaan-taniki. ");
INSERT INTO prq_vpl VALUES ("DN6_10","028_6_10","DAN","6","10","10","Ikanta iyotaki Daniel isankinatakiro iwairo pinkathari Darío ikantakaan-taniki, jataki iwankoki, yasitaryaa-paakiro yaminawaita-piintzi, tsika yamina-kotai-tziro Aapatyaawini. Ari ityiirowari yamaniri Pawa, tima mawa yapiitziro kitaitiri, imatakiro tsika ikanta-piintziro. ");
INSERT INTO prq_vpl VALUES ("DN6_11","028_6_11","DAN","6","11","11","Ikanta yapatojiitaka jiwari-payi, iñaakiri yamani Daniel, oshiki iwisiryaawintakari Iwawani. ");
INSERT INTO prq_vpl VALUES ("DN6_12","028_6_12","DAN","6","12","12","Sintsiini ijatanaki yokaiti inkamantiri pinkathari, ikantapaakiri: “Pinkatharí, pisankinatakiro piwairo airo ipyaakotan-taitaro yantaitiro pikanta-kaantakiri. Tima tikira ontzima-kotanaki aparoni kasiri airo itzimawaitzi aparoni pinkathata-jirini iwawa-niroti, aajatzi aparoni atziri, apatziro impinka-thaitaimi awiroka. Tzimatsi-rika piyathata-kyaamini, yookaitiri omoro-naki tsika ipiyota kashikari. ¿Tima ari?” Ikantzi pinkathari: “Ari okanta. Ontzimatyii imataitiro, tima iro okantziri ikantakaantani Niyanki-wini-satzi, aajatzi irasi Kyaakowiniki, tikatsira wasiñaa-jironi.” ");
INSERT INTO prq_vpl VALUES ("DN6_13","028_6_13","DAN","6","13","13","Aikiro ikantajiitatzii: “Yoka Daniel, Judá-iti, inosikai-takiri pairani, ti inkimisantiro pikanta-kaantani, tima noñaakiri yaakowintakaro yamani, mawa yapiitziro yamani maaroni kitaitiri.” ");
INSERT INTO prq_vpl VALUES ("DN6_14","028_6_14","DAN","6","14","14","Ikanta ikimaki pinkathari ikantai-takiriri, antaro iwasiritanaka, ikamaitakaro irojatzi ititan-tanakari ooryaatsiri, ikinkisiryaa-waitaka tsika inkinakairo iwawisaa-kotan-tyaariri Daniel. ");
INSERT INTO prq_vpl VALUES ("DN6_15","028_6_15","DAN","6","15","15","Iro kantacha yokaiti jiwari-payi, yapiitakiro yapatojiita, ijata-sitakiri pinkathari, ikantapajiri: “Pinkatharí, piyopirotzi awiroka aririka isankinatakiro iwairo pinkathari, tikatsira matironi iwasiñaajiro.” ");
INSERT INTO prq_vpl VALUES ("DN6_16","028_6_16","DAN","6","16","16","Iroora ikantan-tanakari pinkathari: “Pijati, paakitiri Daniel, pintitiri omoroki tsika ipiyota kashikari.” Ikanta yamaita-paakiri Daniel, ikantawakiri pinkathari: “Daniel, onkamintha yookakaa-wintimi Piwawani, pipinkathata-piintziri.” ");
INSERT INTO prq_vpl VALUES ("DN6_17","028_6_17","DAN","6","17","17","Ikanta yaitanakiri Daniel, ititaitakiri omoro-naki tsika ipiyota kashikari. Yasitakoi-tanta-nakari antaro mapi, iwitsiña-koita-nakiri. Ari ikantzi-taikari pasini mawa inampiri-payi pinkathari, ari onkantyaa airo itzimanta impaityaa nintatsini inosikairi Daniel ititaitakiri omoro-naki. ");
INSERT INTO prq_vpl VALUES ("DN6_18","028_6_18","DAN","6","18","18","Ikanta ijatajira pinkathari otsitinitanaki iwinkathari-pankotiki, titzimaita iwapajyaa. Ti ininti inkimiro panthaa-mintotsi. Awisanaki iwochokini ti onkanti imayi. ");
INSERT INTO prq_vpl VALUES ("DN6_19","028_6_19","DAN","6","19","19","Ikanta isaakita-manaji kapichikitaiti pinkathari, sinsitsinira ijatanaki omoroki tsika ipiyota kashikari. ");
INSERT INTO prq_vpl VALUES ("DN6_20","028_6_20","DAN","6","20","20","Ariitapaaka osaiki omorona, iwasirin-kakiini ikaimapajiri, ikantziri: “¡Daniel! ¡Impiratani Pawa Añaanita-tsiri! ¿Yookakaa-wintakimi Piwawani pikamaita-piintari pamaniri? ¿Ti iwyaami kashikari? ");
INSERT INTO prq_vpl VALUES ("DN6_21","028_6_21","DAN","6","21","21","Arira iwithata-waari ipinkathata-wajiri, ikantziri: ");
INSERT INTO prq_vpl VALUES ("DN6_22","028_6_22","DAN","6","22","22","“Tima ityaantakina Imaninkariti Pawa, ishipika-waantitakiri kashikari, ti yatsikina. Tima iyotzi Pawa tikatsi nonkinakaa-sityaa, ti nompithoka-siwaityaami awiroka pinkathari.” ");
INSERT INTO prq_vpl VALUES ("DN6_23","028_6_23","DAN","6","23","23","Ikanta ikimaki pinkathari ikantakiri Daniel, antaro ikimo-siritanaji, ikantaki inosikai-tajiri omoro-naki. Ikanta imisitowai-tajirira, ithonka iñaakiri atziri-payi ti inkisaraawaitiri kashikari, tima omapiro yawintaakari Iwawani. ");
INSERT INTO prq_vpl VALUES ("DN6_24","028_6_24","DAN","6","24","24","Ipoñaa ikaimakaan-takiri pinkathari ikaratzi kantako-waita-kiriri Daniel, ititaita-kiriri irirori ipiyota kashikari, ari itsipatai-takiri iina aajatzi iwaiyani-payi. Tira ishintanaki kashikari, yaa-wakiri, ikaraawaita-wakiniri itonki tikira-mintha yariityaa kipatsiki, ithonka ipitharyaa-wakiri. ");
INSERT INTO prq_vpl VALUES ("DN6_25","028_6_25","DAN","6","25","25","Ari isankinataki pinkathari Darío aparoni ñaantsi inkimaitiri maaroni kipatsi, inkimiri aajatzi ikaratzi ipinkathari-wintziri. Iroka okantzi ñaantsi: “Onkamintha isaikaitai kamiitha maaroni. ");
INSERT INTO prq_vpl VALUES ("DN6_26","028_6_26","DAN","6","26","26","Nokanta-yitziri ikaratzi nampitarori tsika nopinkathari-wintantzi, inkimisantairi, impinkathatairi aajatzi Iwawani Daniel. Yasi iwiro yañaanitzi, tikatsi matajirini yiitsinampairi. Asi owajiro isintsinka. ");
INSERT INTO prq_vpl VALUES ("DN6_27","028_6_27","DAN","6","27","27","Tima kantatsi Iwawani Daniel iwawisaa-kotanti, yookakaa-wintanti aajatzi. Yantayitziro kaari iñaapiintaitzi inkitiki aajatzi kipatsiki. Tima añaakiri yoka Daniel iriitaki Iwawani ookakaa-winta-kiriri kaari yatsikantari kashikari.” ");
INSERT INTO prq_vpl VALUES ("DN6_28","028_6_28","DAN","6","28","28","Ari ikanta-kotakari Daniel, tima aikiro ijatatzii yiriipirotzi ipinkatha-ritantari Darío. Ari ikimitakari aajatzi ipinkatha-ritantari Ciro anta Kyaakowiniki. ");
INSERT INTO prq_vpl VALUES ("DN7_1","028_7_1","DAN","7","1","1","Owakira yitanakaro ipinkatharitzi Belsasar Kompi-jaariki. Ari imisiwai-takiri Kamantan-tzinkari Daniel. Tima isankina-takotakiro okaratzi imisitakiri. ");
INSERT INTO prq_vpl VALUES ("DN7_2","028_7_2","DAN","7","2","2","Iroka ikantzi isankinataki: “Noñaakiro nomisiriki osinkyaatzi antaro inkaari. Irootaki tampyaa sinkyaa-takairori inkaari okinapaakiro kirinka, katonko, isitowa-piintzi ooryaatsiri, aajatzi tsika ikyaa-piintzi. ");
INSERT INTO prq_vpl VALUES ("DN7_3","028_7_3","DAN","7","3","3","Imapoka-sitaka isitowanaki antariiti inkaari-wiri, ikarajiitzi 4. Inasiyita aparo-payi, ti isiya-wakaiyaa. ");
INSERT INTO prq_vpl VALUES ("DN7_9","028_7_9","DAN","7","9","9","Ari namina-piro-tanaki, Noñaatzii yamaitaki saika-mintotsi waniinka-tachari, Ari isaikapaaki Antaripiro-taintsiri. Kitamaaroiniki okantaka iithaari, iroowaitaki okitamaarotzi jiriniki. Kitamaaro-powainka okantaka iisi, iroowaitaki okitamaarotzi iwitzi ipiraitari. Tima paama-porinthataki saika-mintotsi, ari okantzitari aajatzi osiyantari. ");
INSERT INTO prq_vpl VALUES ("DN7_10","028_7_10","DAN","7","10","10","Osiyawai-takaro omorikaa-tyiimi nijaa sitowain-tsiri isaikakira. Ari ipiyotakari oshiki oshiki-piro-tatsiri impiratani, Jataki intaina ikaratzi katziyain-chari tsika isaikaki. Ari yitaita-nakaro yapatojiita, Ipanaryaitanakiro tsika isankina-taitaki. ");
INSERT INTO prq_vpl VALUES ("DN7_13","028_7_13","DAN","7","13","13","Aikiro noñaatziiro noñaawya-takari tsitiniriki. Omapokasita: Koñaata-naintsiri minkoriki, Isiyakari itomi atziri, Iriitaki jataintsiri isaikaki Antari-kona-taintsiri. Isinitai-takiri yokaaki-tyaari irirori. ");
INSERT INTO prq_vpl VALUES ("DN7_14","028_7_14","DAN","7","14","14","Ipaitakiri iwinkathari-minto, ipasankyii-takiri sintsi-nkantsi, aajatzi waniinka-taantsi. Irootaki opoñaantari ipinkathari-wintziri maaroni atziri saikayi-tatsiri tsika-rika-payi, ikaratzi kimathata-wakaarori iñaani tsika-rika-payi. Ari inkantai-tatyiiyaani irirori, Tikatsi matairini iwashaanta-kairi ipinkatharitaki. ");
INSERT INTO prq_vpl VALUES ("DN9_1","028_9_1","DAN","9","1","1","Okanta owakira yitanta-nakarori ipinkatha-ritzi Kiyamoriwiniki pinkathari Darío, itomi Asuero, iriitaki ishininka-mirinka Niyanki-wini-satzi. ");
INSERT INTO prq_vpl VALUES ("DN9_2","028_9_2","DAN","9","2","2","Ikanta yitanakarori Darío ipinkatha-ritzi, ari noñaanatzirori naaka Daniel isankinari Kamantan-tzinkari Jeremías, tsika okanta-kota omonkaratajyaa 70 osarintsi imporokai-takirora Aapatyaawini, tima iro ikantakiriri pairani Pawa yoka Kamantan-tzinkari. ");
INSERT INTO prq_vpl VALUES ("DN9_3","028_9_3","DAN","9","3","3","Ari nokowa-kotakiri Pawa namananiki, notziwintakari. Nokithaata-nakaro mirimasita-tsiri manthakintsi, saikawaitakina samanpoki. ");
INSERT INTO prq_vpl VALUES ("DN9_4","028_9_4","DAN","9","4","4","Nokamaitakari namaniri Pawa, nokamanta-kotakiro noyaaripironka, nokantzi: “Asitanarí, awirokataki iriipirori, tzimatsi pisintsinka. Pimata-piintziro okaratzi pikasiya-kaantziri, poiñaarontziro pitakotanta, pitakota-piintari ikaratzi nintzimiri awiroka, ikaratzi kimisantzimiri. ");
INSERT INTO prq_vpl VALUES ("DN9_5","028_9_5","DAN","9","5","5","Oshiki nokaaripiro-waijiitaki, nantasi-waijiitakaro nonintziri ti nosirita-kota-jyaami awiroka, nowashaanta-nakiro piñaani aajatzi pininta-kaantani. ");
INSERT INTO prq_vpl VALUES ("DN9_6","028_9_6","DAN","9","6","6","Ti nonkimisanta-jiitiri pimpiratani-payi Kamantan-tzinkari-payi, iriitaki kinkithata-kowita-kamiri, ikimayi-witakari nowinkathariti, jiwari-payi aajatzi nowaisatziti-payi, maaroni naakaiti Israel-iiti. Iro kantacha oshiki nopiyatha-yitakami. ");
INSERT INTO prq_vpl VALUES ("DN9_11","028_9_11","DAN","9","11","11","Tima maaroni Israel-iiti ipiyathatakaro piñaani, ti ininti inkimayitiro pikantziriri. Irootaki noñaanta-yitakarori naakaiti imishatai-takina, tima irootaki isankina-yitakiri pairani Moisés, pimpiratani. Tima oshiki nokaaripirotzi-mowaitakimi. ");
INSERT INTO prq_vpl VALUES ("DN9_16","028_9_16","DAN","9","16","16","Pawá, pimatziro awiroka pikamiitha-siritzi pantzirora kamiitha-yitatsiri, pimpyaajiro piyatsimati okaratzi pitsimaa-waitakari Aapatyaawini-satzi, tima irootaki pinampi, irootaki pitasorintsita-kaani otzisi. Tima maaroni atziri ikaratzi saika-nampitzirori, ithainkima-waitakiro Aapatyaawini, okantakaan-tziro nokaaripiro-yitaki, aajatzi irasi nowaisatzitini-payi. ");
INSERT INTO prq_vpl VALUES ("DN9_19","028_9_19","DAN","9","19","19","¡Pinkimajina, Asitanari! ¡Pimpyaakota-jinaro nokaaripiro-waitaki! ¡Pinkimajina, pimpokanaki pinkisa-winta-jyaana! ¡Pantiro awiroka Asitanarí, tima awirokataki anintaa-waita-chani!” ");
INSERT INTO prq_vpl VALUES ("DN9_20","028_9_20","DAN","9","20","20","Namanako-minthaitziro Aapatyaawini, nokanta-kowinta impyaakoi-tajinaro noyaaripironka, aajatzi irasi ashininka-payi, ");
INSERT INTO prq_vpl VALUES ("DN9_21","028_9_21","DAN","9","21","21","tima aritaki siityaanaki, ari noñaakiri Maninkari ipaitai-tziri Gabriel yarapaaki, iriitaki noñiitakari chapinki nomisiriki. ");
INSERT INTO prq_vpl VALUES ("DN9_22","028_9_22","DAN","9","22","22","Ari ikantanakina Maninkari Gabriel: “Pinkimisanta-wakina Daniel, nopokatzii namitakotimi ontzimi piyotani pikimathatairo iroka-payi. ");
INSERT INTO prq_vpl VALUES ("DN9_23","028_9_23","DAN","9","23","23","Oshiki ikowa-pirotakimi Asitairi, tima owakira pitanakaro pamani, ti ishintyaa yakakimi Pawa. Irootaki nopokantari noyotakaa-jimiro. Oninta-pirota pinkimisantawaki, ari onkantyaa piyotan-tyaari opaita-rika siyakaa-winta-chari pimisiri: ");
INSERT INTO prq_vpl VALUES ("DN9_24","028_9_24","DAN","9","24","24","Ontzimatyii osamaniti onkarati 7, iro kantacha apiita-piintiro onkarati 70, ari piñiirori onkarataji iwasankitai-tziri pishininka pinampi-tsitiki tasorin-tsita-tsiri. Ari piñiirori onkarataji pipiyatha-waitaka, aajatzi pikaaripiro-waitaki. Ari impyaakota-jimirori Pawa pikaaripiro-waitaki. Tampatzika-siri inkantajyaa pinkatha-ritaa-tsini, ari inkanta-jita-tyiironi irirori, Ari omonkarata-jyaari okaratzi piñaawya-yitakari, okaratzi ikasiya-kaantakiri Pawa. Tzimatsi isaitaitiri, Tasoritsi-pirota-tsini. ");
INSERT INTO prq_vpl VALUES ("DN9_25","028_9_25","DAN","9","25","25","Ontzimatyii pikimathatiro kamiithaini iroka: Tima awisaki osamaniti onkarati 7, itanakyaaro aririka inintaitaki iwitsikai-tairo nampitsi Aapatyaawini, Irojatzi yariitan-tajyaari iyosiitai-takiri Jiwari. Tima inthonkai-tajiro owaankiiri-tsiti Aapatyaawini, Aajatzi ikimitai-tajiro otanto-payi ithonka iwitsikai-tairo, Osamaniti onkarati 7, iro kantacha apiita-piintiro onkarati 62. ¡Oshiki iñiitiro yasinonkaityaa, antaro owasiritaantsi onkantyaa! ");
INSERT INTO prq_vpl VALUES ("DN9_26","028_9_26","DAN","9","26","26","Aririka awisanaki onkarati 7, iro kantacha apiita-piintiro onkarati 62. Ari impokajiri pinkathari inkaratajiri iwayiriti, Ari intsitoka-pajiri jiwari iyosiitai-takiri. ¡Yapiitajiro imporokaitiro Aapatyaawini aajatzi Tasorintsi-panko, Yapiroi-tajiro airo iñiitairo, Omapoka-sitajyaa onthonkajyaa, Iroowaitaki omapokantzi amarani, ¡Manataantsi aajatzi apirotan-tatsiri, Okaratzi ikamanta-jitzi-tantakari Aikiro ijatakai-tatyiiro irojatzi onkaran-tapaa-kyaari! ");
INSERT INTO prq_vpl VALUES ("DN9_27","028_9_27","DAN","9","27","27","Tima awisawaji onkarati 7, Yoka kaari-pirori pinkathari tzimatsi ikasiya-kaantakiri irirori, Tima oshiki tzimatsi yatziriti, Iro kashitani awisawaji onkarati 7, Airo isinitai-tantai ampajiri Pawa asitakaariri. Anta pomitai-rontsiki itayiitziri atsipita-kaantsi, Aritaki asitakaa-jyaari mapirotzirori ipinkai-tziri Pawa. Ari onkarata-paaki iroka-payi, yapirotairi Pawa ipaitai-tziri Pinkaari Apirotan-taniri.”");
INSERT INTO prq_vpl VALUES ("JH1_1","033_1_1","JON","1","1","1","Ikanta Pawa iñaanatakiri Jonás, itomi Amitai, ikantziri: ");
INSERT INTO prq_vpl VALUES ("JH1_2","033_1_2","JON","1","2","2","“Pijati Inawiniki, pinkamantiri atziri-payi nonintzi napirotiri, tima nokimaki naaka tsika ikanta ikaaripirotaki.” ");
INSERT INTO prq_vpl VALUES ("JH1_3","033_1_3","JON","1","3","3","Iro kantacha Jonás, ti inkimisanti. Ikinkitha-siritaka isiya-pithatiri Pawa inkinaki Owaniinkaariniki. Ari iñaaki antaro amaatako-mintotsi, irootzi-mataki ojati Makaariniki. Ipinatakiro intitan-tyaari, jataki. ");
INSERT INTO prq_vpl VALUES ("JH1_4","033_1_4","JON","1","4","4","Iro kantacha, ikantakaakaro Pawa ontampyaati inkaariki, antaro osinkyaa-tanaki. Tima iro onkotaimi amaatako-mintotsi. ");
INSERT INTO prq_vpl VALUES ("JH1_5","033_1_5","JON","1","5","5","Antaro itharowanaki aminirori amaatako-mintotsi, yamanawi-takari atziri-payi iwawa-niroti. Iwiinkaki iwaararo airo otsitsiyanta amaatako-mintotsi. Tima ikyiitzitapaaka inkaaranki Jonás inthompoi-ki amaatako-mintotsi. Imaapiro-tapaa-kitzii anta. ");
INSERT INTO prq_vpl VALUES ("JH1_6","033_1_6","JON","1","6","6","Jatanaki ijiwariti aminirori amaatako-mintotsi tsika inaryaaka Jonás, ikantapaakiri: “¡Ipaita pantziri aka pochokintzí! ¡Pimpiriinti! Pinkowa-kotiri Piwawani. Inisironka-taita, apiinki = kari.” ");
INSERT INTO prq_vpl VALUES ("JH1_7","033_1_7","JON","1","7","7","Ari ikantanaki aminirori amaatako-mintotsi, ikantzi: “Pimpoki, thami añaarityaa ayotant-yaari ipaita kantasi-tarori añaantarori iroka kowiinkari.” Imatakiro iñaarijiita. Iñaatziiri iriitaki Jonás kantakaan-tzirori. ");
INSERT INTO prq_vpl VALUES ("JH1_8","033_1_8","JON","1","8","8","Isampitakiri, ikantziri: “Pinkamantina, ¿Ipaita añaantarori kowiinkari? ¿Ipaitama pipokantari aka? ¿Tsika pipoñaa-nakari? ¿Tsika ipaitaka pishininka?” ");
INSERT INTO prq_vpl VALUES ("JH1_9","033_1_9","JON","1","9","9","Akanaki Jonás, ikantziri: “Naaka ishininka Heber-iiti, nopinkatha-tziri Inkiti-satzi Pawa, iriitaki owitsikakiro inkaari aajatzi kipatsi.” ");
INSERT INTO prq_vpl VALUES ("JH1_10","033_1_10","JON","1","10","10","Antaroiti itharowanaki, ikantajiitzi: “¿Tsika pinkanta-taitinaka?” Tima yotanaki isiya-pitha-tatyaari Pawa, tima aritaki ikantzi ikamantaki. ");
INSERT INTO prq_vpl VALUES ("JH1_11","033_1_11","JON","1","11","11","Aikiro ikantai-tanaki-tziiri: “¿Tsika nonkantimika oshikan-tajyaari otamakaani?” Tima aikiro omapiro-tanakityaa osinkyaatzi inkaari. ");
INSERT INTO prq_vpl VALUES ("JH1_12","033_1_12","JON","1","12","12","Ari ikantanaki Jonás: “Pookina inkaariki, aritaki oshikanaki otamakaani. Naaka kantasitaro añaantarori okowiinkatzi otampyaatzi.” ");
INSERT INTO prq_vpl VALUES ("JH1_13","033_1_13","JON","1","13","13","Ari iyomajiitzi sintsiini inintzi yaatakoti othapyaaki inkaari. Titzimaita imatiro. Ainiro omapiro-tanakityaa osinkyaatzi inkaari. ");
INSERT INTO prq_vpl VALUES ("JH1_14","033_1_14","JON","1","14","14","Ikowako-tanakiri Pawa, ikantajiitzi: “¡Pawá! Airo pisinitana nompiinki ikantakaan-tziro yoka atziri. Tikatsi-rika iyaari-piroriti, ti noninti piwasankitaa-wintinari ikamaki. Pimatziro awiroka Pawa okaratzi pinintziri.” ");
INSERT INTO prq_vpl VALUES ("JH1_15","033_1_15","JON","1","15","15","Ithonka-kiro ikowako-tziri Pawa, yookaitakiri Jonás inkaariki. Tima awisanaki otamakaani inkaari. ");
INSERT INTO prq_vpl VALUES ("JH1_16","033_1_16","JON","1","16","16","Ikanta iñaakiro atziri-payi, antaroiti ipinkatha-tanakiri Pawa. Ipomita-kiniri iratsipi-takaani, ikantajiitzi: “¡Pawá! Omapiro nonkimisantajimi.” ");
INSERT INTO prq_vpl VALUES ("JH1_17","033_1_17","JON","1","17","17","Iwaki Pawa antari nijaa-wiri niyawakirini Jonás. Mawa kitaitiri aajatzi mawa tsitiniri saikaki imotyaaki nijaa-wiri. ");
INSERT INTO prq_vpl VALUES ("JH2_1","033_2_1","JON","2","1","1","Ikanta yamanaji Jonás isaikaki imotyaaki nijaa-wiri, ");
INSERT INTO prq_vpl VALUES ("JH2_2","033_2_2","JON","2","2","2","ikantzi: ¡Pawá! Noñaakiro nokimaatsi-waitaka, nokampi-takimi. Pikaminthaakina awiroka. Pikimakina nokaimi kaminkari-masiki. ");
INSERT INTO prq_vpl VALUES ("JH2_3","033_2_3","JON","2","3","3","Pookawi-takana osaankanatzi inkaari, Onosika-nakina osinchaari. Aanakina omoitonkari. ");
INSERT INTO prq_vpl VALUES ("JH2_4","033_2_4","JON","2","4","4","Ari nokantziri: ¡Pawá! Pookakina. Airo noñaajiro pitasorintsi-pankoti. ");
INSERT INTO prq_vpl VALUES ("JH2_5","033_2_5","JON","2","5","5","Othonka anaakina nijaa, Opyaakina osaankanatzi inkaari. Tima inthonkyaa ankowiinatakina samantosha. ");
INSERT INTO prq_vpl VALUES ("JH2_6","033_2_6","JON","2","6","6","Notsitsiyanaki inthompointa nariita-paintaro kipatsi. Kimiwaitaka nasi nowiro nosaikimi tsika yasitakoi-takinami. Iro kantacha Nowinkathariti Pawa, awiroka owawisaa-kotaana nonkamimi. ");
INSERT INTO prq_vpl VALUES ("JH2_7","033_2_7","JON","2","7","7","Ikanta nokamimataki, nokinkithasiri-tanajimi awiroka, Pawa. Pikimakiro namanani pitasorintsi-pankotiki. ");
INSERT INTO prq_vpl VALUES ("JH2_8","033_2_8","JON","2","8","8","Ikaratzi pinkatha-waitziriri isiyakaaro pawaniro, Ti itsipatzimaityaami. ");
INSERT INTO prq_vpl VALUES ("JH2_9","033_2_9","JON","2","9","9","Irooma naaka, kaminiinka nompaasoonkitimi, Nompomi-tajimiri natsipi-takaani nasitakaamiri. Aritaki nantajimiro nokantzimiri. Tima apatziro pikanta-kaaro Pawa, piwawisaa-kotantzi. ");
INSERT INTO prq_vpl VALUES ("JH2_10","033_2_10","JON","2","10","10","Ari ikantakaajari Pawa yoka nijaa-wiri, ikamarankairi Jonás othapyaaki inkaari. ");
INSERT INTO prq_vpl VALUES ("JH3_1","033_3_1","JON","3","1","1","Ari yapiitajiro Pawa iñaanatairi Jonás, ikantziri: ");
INSERT INTO prq_vpl VALUES ("JH3_2","033_3_2","JON","3","2","2","“Pijati Inawiniki, pinkamantantiro onkarati nonkantimiri.” ");
INSERT INTO prq_vpl VALUES ("JH3_3","033_3_3","JON","3","3","3","Jataki Jonás Inawiniki, imatakiro ikantakiriri Pawa. Tima antaro nampitsi Inawini, mawa kitaitiri aniitan-tyaarori maaroni. ");
INSERT INTO prq_vpl VALUES ("JH3_4","033_3_4","JON","3","4","4","Ariitaka Jonás nampitsiki, aniitaki aparoni kitaitiri, ikantzi ikinkithatzi: “Oyotapaaka 40 kitaitiri, yapiroi-tantyaariri ikaratzi nampitarori Inawiniki.” ");
INSERT INTO prq_vpl VALUES ("JH3_5","033_3_5","JON","3","5","5","Ikanta ikimaki nampitarori Inawiniki: antari-payi aajatzi iinchirii-riki, ikimisanta-nakiri Pawa, ikanta-wakaa-jiita: “Thami antziwintyaa.” Ikithaa-tanakaro paisato-poroki iithaari, irootaki iyotanta-jyaari iwasiri-tatyaa. ");
INSERT INTO prq_vpl VALUES ("JH3_6","033_3_6","JON","3","6","6","Ikanta ikimaki pinkathari-tatsiri Inawiniki, yookanakiro iwinkathari-minto, ikithaa-tanakaro paisato-poroki iithaari, saikanaki samampoki. ");
INSERT INTO prq_vpl VALUES ("JH3_7","033_3_7","JON","3","7","7","Ikamantantaki inampina-payi pinkathari, iyotantyaari maaroni nampitarori, ikantzi: “Intziwintyaa maaroni atziri, tikatsi owaachani. Ari inkimitairiri ipira-payi, airo ipiri kapichiini iyaari aajatzi imiri. ");
INSERT INTO prq_vpl VALUES ("JH3_8","033_3_8","JON","3","8","8","Ontzimatyii inkithaa-porokityaa atziri-payi aajatzi ipira-payi. Inchiraa-piro-tatyii yamanairi Pawa. Iwashaantairo ikaaripiro-waitzi aajatzi imaimani-tantzi. ");
INSERT INTO prq_vpl VALUES ("JH3_9","033_3_9","JON","3","9","9","Aamaasityaa aritaki inisironkatai Pawa, intsimaryaa-siri-tajyaa. Airo añaantaro yapathakirotai.” ");
INSERT INTO prq_vpl VALUES ("JH3_10","033_3_10","JON","3","10","10","Iñaakiri Pawa tsika ikantanaja Inawini-satzi, tima iwashaanta-najiro ikaaripiro-witaka. Ti inintanaji Pawa iwasankitairi. ");
INSERT INTO prq_vpl VALUES ("JH4_1","033_4_1","JON","4","1","1","Ti onimotiri Jonás iñaakiri Pawa ti iwasankitairi Inawini-satzi, otyaanakari imasirinka. ");
INSERT INTO prq_vpl VALUES ("JH4_2","033_4_2","JON","4","2","2","Ikowako-takiri Pawa, ikantzi: “¡Pawá! Ari noyotzitaka pantiri ainiro nosaiki nonampiki. Irootaki nonintantari noyaatimi Makaariniki. Tima noyotzi awiroka Pawa nithaan-tatsiri, nisironka-tantatsiri, ti pinkisa-nityaa. Antaro pitakotanta, pinkanta-wityaa: ‘Ari nowasankitaakimi’, iro osamaniitaki ti pinintanaji piwasankitaanti. ");
INSERT INTO prq_vpl VALUES ("JH4_3","033_4_3","JON","4","3","3","Irootaki noñaasirinkan-tamiri Pawa, nonintzi nonkami. Irootaki noninta-pirotzi nonkami, ti noninti nañai.” ");
INSERT INTO prq_vpl VALUES ("JH4_4","033_4_4","JON","4","4","4","Ari yakanaki Pawa, ikantzi: “¡Jonás! ¿Irooma kamiitha-tzimo-tzimiri pikisawaita?” ");
INSERT INTO prq_vpl VALUES ("JH4_5","033_4_5","JON","4","5","5","Jatanaki Jonás isitowa-piintziro ooryaatsiri owiraa-thapita nampitsi. Iwitsika-paaki iwanko-shita. Ari isaiki yaimpyaa, iyaawinta paita awisatsini nampitsiki. ");
INSERT INTO prq_vpl VALUES ("JH4_6","033_4_6","JON","4","6","6","Ikantakaakaro Pawa omapoka-sityaa oshooki siwitha-maisi, anaakotakiri Jonás. Irootaki tsimanka-kiriri iitoki, ari yaimpyaari airo iñaasirinkantari ooryaatsiri. Oshiki ikimo-siri-winta-nakiro Jonás shookain-tsiri. ");
INSERT INTO prq_vpl VALUES ("JH4_7","033_4_7","JON","4","7","7","Ikanta okitaitita-manaji, ikantakaakaro Pawa yapiyiro chapitzi shookain-tsiri, sampiyasi-tanaki. ");
INSERT INTO prq_vpl VALUES ("JH4_8","033_4_8","JON","4","8","8","Ikanta isintsi-tapaaki ooryaatsiri, itampyaa-takaakiro Pawa sintsiini okinapaakiro tsika isitowiro ooryaatsiri. Iriitaki taakiriri sintsiini iitoki Jonás, iwamaima-takiri. Ikantzi: “Irootaki nokowa-pirotzi nonkami, ti noninti nañii.” ");
INSERT INTO prq_vpl VALUES ("JH4_9","033_4_9","JON","4","9","9","Iroka ikantzi Pawa yakiri Jonás: “¿Irooma kamiitha-tzimo-tzimiri pikisakotaro okamaki incha-maisi?” Ikantzi Jonás: “Jii, tima kamiitha noñaakiro ayimawaitana nomasirinka.” ");
INSERT INTO prq_vpl VALUES ("JH4_10","033_4_10","JON","4","10","10","Ikantzi Pawa: “Ti awiroka pankitironi siwita-maisi, ti awiroka shookakaironi aajatzi. Apatziro-machii piñaakiro oshookaki, piñaakiro okamaki aajatzi. Irootaki pitako-waitari. ");
INSERT INTO prq_vpl VALUES ("JH4_11","033_4_11","JON","4","11","11","¿Airoma nonisironkatari naaka Inawini-satzi? Oshiki ikarajiitzi. Tzimatsi aajatzi oshiki iinchirii-riki, ikaratzi 120,000, tikira iyotziro tsika otzimi yampati aajatzi irako-piro. Tzimatsi aajatzi oshiki ipiraitari anta.”");
INSERT INTO prq_vpl VALUES ("MC1_1","034_1_1","MIC","1","1","1","Iroka iñaani Pawa ikamantziriri Miqueas Kasiya-kaarini-satzi, ikantziri: “Noñaakimiro opaita awisatsini apaata Ositikii-toniki aajatzi Aapatyaawiniki.” Aripaiti iñaakiri ipinkathari-tantari Jotam, Ahaz aajatzi Ezequías anta Judá-iti-ki. ");
INSERT INTO prq_vpl VALUES ("MC5_1","034_5_1","MIC","5","1","1","¡Irisinto owayiriiti! Pinkisa-winta-jyaaro tapotakimiri otantotsi, Tima iwayiri-taitatyai. Antaroiti iwasankitaitiri ijiwariti ashininka Israel-iiti, Imposawai-tantyaari pasamintotsi iporoki. ");
INSERT INTO prq_vpl VALUES ("MC5_2","034_5_2","MIC","5","2","2","Irooma awiroka, Tantapankoni saikatsiri Posini-pathaniki, Yanaakimi ishikijiitzi pishininka Judá-iti. Ari impoñii-yaami pinkathari-wintairini Israel-iiti. Iriitaki itakarori itzimaki pairani, Itziman-tayitakari añaanita-tsiri. ");
INSERT INTO prq_vpl VALUES ("MC5_3","034_5_3","MIC","5","3","3","Kapichiini yooka-paintziri yasiyitari, Irojatzi apaata ontzimaa-nitan-takyaari kooya yaminai-takiri owaiyanti. Iyosiitaitani kooya owaiyanti. Aripaiti impokayitaji ishininka, Intsipa-yitajyaari Israel-iiti. ");
INSERT INTO prq_vpl VALUES ("MC5_4","034_5_4","MIC","5","4","4","Ari yitanakyaarori pinkathari yaamaako-winta-jyaari ishininka-payi, Irootaki imatanta-jyaari isintsinka Pawa. Ari inkantzi-taityaari impinkatha-taitiro iwairo Iwawani. Aritaki isaikawaitaji kamiitha, Tima antaroiti impinka-thaitairi Pawa, Imaitairo maaroni tsika-rika owiraa-thapi-tapaja kipatsi.");
INSERT INTO prq_vpl VALUES ("ML1_1","040_1_1","MAL","1","1","1","Iroka iñaani Pawa ikantakiriri Kamantan-tzinkari Malaquías, irootaki iyotajiri maaroni Israel-iiti. ");
INSERT INTO prq_vpl VALUES ("ML3_1","040_3_1","MAL","3","1","1","Ikantzi Pawa Ñaapirori: Ari nontyaantaki ityaaroni inkaman-takotina, Iriitaki witsikironi tsika nonkina-paaki. Omapoka-sityaa inkyii itasorintsi-pankotiki, Piwinkathariti pamina-mina-tziri. Ariitzi-mataka pikowajii-tziri, iriitaki nontyaantiri inkinkitha-takoyi-tairo kasiyakaa-wakaantsi. ");
INSERT INTO prq_vpl VALUES ("ML4_1","040_4_1","MAL","4","1","1","Iroka iñaani Pawa Ñaapirori, ikantzi: Okaakitaki kitaitiri iñiitiro siyariri opaamatzi paamari, Ari intaajyaari kantakaa-pirori aajatzi kaari-pirori, inkimitai-yaaro opaamatzi tsipanasi. Ari inthonkyaari intaajyaa, isiyaaro ipomitai-tziro inchato, Tima inthonkaitiro maaroni ochiwo aajatzi oparitha. ");
INSERT INTO prq_vpl VALUES ("ML4_2","040_4_2","MAL","4","2","2","Irooma awirokaiti pikaratzi pipinkatha-tajiro nowairo, Ari onkoñaa-tzimo-taimi kamiitha-siri-taantsi osiyaari isiparyii ooryaatsiri, Irootaki isiparyaani wawisaako-tajimini osiyawai-tajyaaro iroomi isiwanki iwaankakiri tsika pisaikaki awiroka. Antaro pinkimo-siri-yitai, pinkimi-tyaari itharowinta yanini pipira aririka isitowi kapichikitaiti tsika pasitako-tziri. ");
INSERT INTO prq_vpl VALUES ("ML4_3","040_4_3","MAL","4","3","3","Aritaki paatzika-yitairi kaari-piro-siriri, Pinkimi-takaan-tajiri yaatzika-waitai-tziro samampo-pani, Aririka omonkara-tapaakyaa kitaitiri nomatan-tajyaarori onkarati nantayitiri. Ari ikantzi iñaawaitzi Pawa Ñaapirori. ");
INSERT INTO prq_vpl VALUES ("ML4_4","040_4_4","MAL","4","4","4","Pinkinkithasiri-tairo noñaani, Nopakiriri pairani nompiratani anta Mamirii-toniki. Irootaki nosinita-kaantani, irootaki noñaani irasiiti maaroni Israel-iiti! ");
INSERT INTO prq_vpl VALUES ("ML4_5","040_4_5","MAL","4","5","5","Aritaki nontyaanta-kimiri Kamantan-tzinkari Elías, Tikira omonkara-tapaakya kitaitiri inintziri Pawa, tima kowiinka onkantajyaa, omapiro-kitajyaa onkaaripiro-paititai. ");
INSERT INTO prq_vpl VALUES ("ML4_6","040_4_6","MAL","4","6","6","Aritaki yoipyaa-siri-tairi Pawa ikaratzi iriritaitari, oshiki imiraawintairi itomi-payi. Ari ikantajyari itomitaitari, oshiki inkaminthaa-siri-tairi asitariri-payi. “Paamaiyaa, nompiyaki-rika, nowasankitairi = kari ikaratzi saikantarori kipatsi.”");
INSERT INTO prq_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Iroka iwairo-payi ikaratzi icharini-takari Jesús, Saipatzii-totaari. Tima yoka Jesús iriitaki icharini David aajatzi Abraham. ");
INSERT INTO prq_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Ikanta pairani Abraham, itzimaki itomi ipaitakiri Isaac. Ikanta Isaac tzimanaki itomi irirori, ipaitakiri Jacob. Ikanta Jacob tzimanaki itomi irirori, ipaitakiri Judá. Tima oshiki iririntzi tzimain-tsiri Judá. ");
INSERT INTO prq_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Ikanta Judá itzimakaakiro Tamar, ipaitakiri Fares, iriima pasini ipaitakiri Zara. Ikanta Fares tzimanaki itomi irirori, ipaitakiri Esrom. Ikanta Esrom tzimanaki itomi irirori, ipaitakiri Aram. ");
INSERT INTO prq_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ikanta Aram tzimanaki itomi irirori, ipaitakiri Aminadab. Ikanta Aminadab tzimanaki itomi irirori, ipaitakiri Naasón. Ikanta Naasón tzimanaki itomi irirori, ipaitakiri Salmón. ");
INSERT INTO prq_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Ikanta Salmón itzimakaakiro Rahab, ipaitakiri Booz. Ikanta Booz itzimakaakiro Rut, ipaitakiri Obed. Ikanta Obed tzimanaki itomi irirori, ipaitakiri Isaí. ");
INSERT INTO prq_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Ikanta Isaí tzimanaki itomi irirori, ipaitakiri David. Tima yoka David iriitaki pinkathari-taintsiri. Ikanta pinkathari David itzimakaakiro iina Urías, ipaitakiri Salomón. ");
INSERT INTO prq_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Ikanta Salomón tzimanaki itomi irirori, ipaitakiri Roboam. Ikanta Roboam tzimanaki itomi irirori, ipaitakiri Abías. Ikanta Abías tzimanaki itomi irirori, ipaitakiri Asa. ");
INSERT INTO prq_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Ikanta Asa tzimanaki itomi irirori, ipaitakiri Josafat. Ikanta Josafat tzimanaki itomi irirori, ipaitakiri Joram. Ikanta Joram tzimanaki itomi irirori, ipaitakiri Uzías. ");
INSERT INTO prq_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Ikanta Uzías tzimanaki itomi irirori, ipaitakiri Jotam. Ikanta Jotam tzimanaki itomi irirori, ipaitakiri Acaz. Ikanta Acaz tzimanaki itomi irirori, ipaitakiri Ezequías. ");
INSERT INTO prq_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ikanta Ezequías tzimanaki itomi irirori, ipaitakiri Manasés. Ikanta Manasés tzimanaki itomi irirori, ipaitakiri Amón. Ikanta Amón tzimanaki itomi irirori, ipaitakiri Josías. ");
INSERT INTO prq_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Ikanta Josías tzimanaki itomi irirori, ipaitakiri Jeconías. Tima ti aparoni ikanta Jeconías oshiki iririntzi tzimain-tsiri. Aripaiti inosikai-tanakiri yaitanakiri maaroni anta Kompi-jaariki. ");
INSERT INTO prq_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Ikanta ipiyajaara inosikan-taita-karira Kompi-jaariki. Ari itzimapajiri itomi Jeconías, ipaitakiri Salatiel. Ikanta Salatiel tzimanaki itomi irirori, ipaitakiri Zorobabel. ");
INSERT INTO prq_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Ikanta Zorobabel tzimanaki itomi irirori, ipaitakiri Abiud. Ikanta Abiud tzimanaki itomi irirori, ipaitakiri Eliaquim. Ikanta Eliaquim tzimanaki itomi irirori, ipaitakiri Azor. ");
INSERT INTO prq_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Ikanta Azor tzimanaki itomi irirori, ipaitakiri Sadoc. Ikanta Sadoc tzimanaki itomi irirori, ipaitakiri Aquim. Ikanta Aquim tzimanaki itomi irirori, ipaitakiri Eliud. ");
INSERT INTO prq_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Ikanta Eliud tzimanaki itomi irirori, ipaitakiri Eleazar. Ikanta Eleazar tzimanaki itomi irirori, ipaitakiri Matán. Ikanta Matán tzimanaki itomi irirori, ipaitakiri Jacob. ");
INSERT INTO prq_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Ikanta Jacob tzimanaki itomi irirori, ipaitakiri José. Iriitaki José oimithori María. Tima iroka María irootaki tzimakiriri Jesús, irijatzi ipaitai-tziri Saipatzii-totaari. ");
INSERT INTO prq_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Iriitaki yokapayi iwaisatzititakari yitanakaro Abraham irojatzi David, ikarajiitzi 14. Ipoñaanaro David irojatzi inosikan-taitana-kariri Kompi-jaariki, ikarajiitzi 14. Ikanta ipiyajara inosikan-taita-kariri Kompi-jaariki, irojatzi itziman-takari Saipatzii-totaari, ikarajiitzi 14. ");
INSERT INTO prq_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Iroka okanta itziman-takari pairani Jesús, Saipatzii-totaari. Tzimatsi iinathori José opaita María, irootaki ikasiyakari iinantyaaro. Titzimaita iñiiro itsipa-tyaaro. Iro kantacha, motyaataki María ikantakaakaro Tasorinkantsi. ");
INSERT INTO prq_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Tima tampatzika-siri inatzii José irirori, inintawitaka iwashaantiro María imananikiini, ti ininti iwasinonkairo inkimakoi-takiro itzimasi-waitaka iintsiti. ");
INSERT INTO prq_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Ikanta ikinkisiryaa-waita José tsitiniriki, iñaakakari Imaninkariti Pawa imisiri-kii, ikantakiri: “José, icharini pinkatharini David. ¿Paitama pikinkisiryaa-tantari piwashaantiro María? Payiro, tima Tasorinkantsi kantakaarori omotyaa-tantakari. ");
INSERT INTO prq_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Aririka intzimaki iinchaa-niki, pimpaitiri “Iwawisaa-kotajai Pawa”. Tima iriitaki wawisaa-kotairini ishininka-payi ikaaripirotaki. Tima iroka wairontsi “Iwawisaa-kotajai Pawa”, irootaki ikantziri iñaaniki iriroriiti “Jesús”. ");
INSERT INTO prq_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Tima omatanta-yitakari iroka-payi, ari omonkaratari okaratzi isankina-takaakiri Pawa pairani Kamantan-tzinkari, ikantaki: ");
INSERT INTO prq_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Ari otzimanitaki kooya kaari ñiirini sirampari, intzimi otomi, Impaitaitiri Emanuel, irootaki paitakaan-tairini inkantaitiri: “Itsipatai Pawa.” ");
INSERT INTO prq_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Ikanta isaakitanaji José, imatakiro okaratzi ikantakiriri Imaninkariti Pawa, iinantakaro María. ");
INSERT INTO prq_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Titzimaita imaantyaaro irojatzi itziman-takari itakari otzimakiri otomi. Ipaitai-takiri JESÚS. ");
INSERT INTO prq_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Tima tzimaki Jesús nampitsiki Tantapankoniki, iipatsitiki Judá-iti tsika ipinkathari-wintantzi Herodes. Ari yariijiitaka yotanikiri-payi Aapatyaawiniki ikinapaakiro isitowa-piintzi ooryaatsiri. ");
INSERT INTO prq_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Isampitan-tapaaki, ikantzi: “¿Tsika isaikika iwinkathariti Judá-iti owakira tzimain-tsiri? Tima anta nonampiki tsika nopoñaaka, noñaaki impokiro noyotan-takari tzimaki. Irootaki nopokan-tanakari nompinkathatiri.” ");
INSERT INTO prq_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Ikanta ikimaki pinkathari Herodes antaro okantzimo-siryaa-nakari, ari ikimi-tzita-nakari maaroni Aapatyaawini-satzi. ");
INSERT INTO prq_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Ikaimakaan-takiri Herodes maaroni ijiwariti Ompira-tasorintsi-taari, aajatzi maaroni Yomitaan-taniri, isampitakiri, ikantziri: “¿Tsikama intzimika Saipatzii-totaari?” ");
INSERT INTO prq_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ari ikantajii-tanaki irirori: “Ari intzimiri anta Tantapankoniki iipatsitiki Judá-iti, tima ari okantzi isankinari Kamantan-tzinkari, ikantaki: ");
INSERT INTO prq_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Irooma awiroka Tantapankoni saikatsiri iipatsitiki Judá-iti, Tikatsi thainkimini, inkantaitimi: ‘Ti piriipiroti awirokaiti, anaimi pasini pinkathari-wintziriri ashininka Judá-iti.’ Tima aritaki impoñii-yaari pinkathari-pirori anta. Iriitaki jiwatajirini Israel-iiti nasitari naaka.” ");
INSERT INTO prq_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Tima imananikiini ikaimakaan-takiri Herodes pokaintsiri yotanikiri-payi, isampitakiri, ikantziri: “¿Tsika-paitika piñaakiri impokiro piyotan-takari tzimaki pinkathari?” ");
INSERT INTO prq_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Ari ikamantakiri tsika-paiti iñaakiri. Ikantzi Herodes: “Kamiithataki, pimatiro pijati Tantapankoniki paminiri tsika isaiki iinchaa-niki. Aririka piñaakiri aajatzi pinkinapaji aka pinkaman-tanajina, nojatiita naaka nompinkathatiri.” ");
INSERT INTO prq_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Ikanta ikimaki yotanikiri-payi ikantakiri pinkathari, awisajii-tanaki. Aajatzi iñaanajiri impokiro iñaakiri chapinki inampiki. Ikanta yariitzi-matapaaka, iñaatziiri yaatzinka-paaki tsika isaikaki iinchaa-niki. ");
INSERT INTO prq_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Ikanta iñaakiri yaatzinka-paaki impokiro, antaro ikimo-siri-jiitanaki. ");
INSERT INTO prq_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Ari ikyaajii-tapaaki pankotsiki, iñaapaa-kitziiri iinchaa-niki aajatzi María, iriniro. Otyiirowa-jiita-paaka, ipinkatha-tapaakiri. Ipoñaa iwayiitapaakiro okaratzi yamakiniriri, ipapaakiri ooro, kasankari, aajatzi kipishaari. Oshiki owinaro iroka-payi. ");
INSERT INTO prq_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Ikanta imaajii-tapaaki, ari imisimpyai-takiri, ikantai-tziri: “Airo pikinasi-tanajiri Herodes.” Irootaki ikinanta-naari pasiniki awotsi ipiyanta-naari inampiki. ");
INSERT INTO prq_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Aritaki piyajiitaja yotanikiri-payi. Yapiitajiro Imaninkariti Pawa iñaanatairi José imisiriki, ikantziri: “¡José! Pisiyakairi iinchaa-niki aajatzi iriniro, pijati nampitsiki Apitantoniki. Ari pisaikiri anta irojatzi nonkantan-tajyaamiri: ‘Pimpiyaji.’ Tima awotsikitaki Herodes inintzi iwiiri iinchaa-niki.” ");
INSERT INTO prq_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Ikanta isaakitanaki José, ikamantakiro María, tima tsitiniki isiyaka Apitantoniki yaanakiri iinchaa-niki. ");
INSERT INTO prq_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Ari isaikakiri anta, irojatzi ikamantaari Herodes. Ari omonkaratari isankina-takiri pairani Kamantan-tzinkari, ikantaki: Isaikawitaka notomi nampitsiki Apitantoni, tima nonkaimajiri impiyaji. ");
INSERT INTO prq_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Ikanta iyotaki Herodes yamatawi-takiri yotanikiri-payi, otyaanakari imasirinka. Ari ityaankaki apirotirini iwiiri intsi-payi, ikantakiri: “Pijati Tantapankoniki aajatzi maaroni nampitsi okaratzi otsipa-nampitari, piwiiri maaroni iinchaa-niki owakira tzimain-tsiri, aajatzi ikaratzi tzimain-tsiri apiti isarintsiti.” Tima ikamantakiri chapinki yotaniriki-payi tsika-paiti iñaanta-kariri impokiro. ");
INSERT INTO prq_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Ari omonkaratari ikamantan-takiri pairani Kamantan-tzinkari Jeremías, ikantaki: ");
INSERT INTO prq_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Ikimaitaki Tonkaironiitoniki antaro iraajiita-chari. Irootaki osaro-payi kaminkaroni Raquel iraakotariri intsiti-payi. Tima tikatsi mataironi yoimosirinka-jyaaro, tima ithonka iwamai-tzitai-takiro iinchaaniti-payi. ");
INSERT INTO prq_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Okanta apaata, kamaji irirori Herodes. Irojatzi isaikaki José Apitantoniki. Ari yapiitajiro Imaninkariti Pawa iñaanatairi imisiriki. ");
INSERT INTO prq_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Ikantajiri: “¡José! Kantacha pimpiyi iipatsitiki Israel-iiti, paanajiri pintsiti aajatzi iriniro. Tima kamaji nintawi-tachari iwiiri.” ");
INSERT INTO prq_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Ikanta isaakitanaki José, jataji iipatsitiki Israel-iiti, yaanajiri iinchaa-niki aajatzi iina. ");
INSERT INTO prq_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Iro kantacha, ikimaki José ikantaitzi: “Iriitaki pinkathari-taatsi Arquelao inampiitiki Judá-iti, yimpoyii-taari Herodes, iririni.” Oshiki itharowanaki, ti ininti isaikapaji anta. Ari yapiitai-tziri iñaanai-tajiri imisiriki, ikantai-tziri: “Paamaiyaari Arquelao.” Irootaki ikinanta-najari Tapowiniki. ");
INSERT INTO prq_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Ari inampita-pajaro nampitsiki Kasiyakaa-wini. Tima ari omonkaratari ikantakiri pairani Kamantan-tzinkari-payi, ikantaki: Ikasiyakaitaitakiriri impaitaitiri. ");
INSERT INTO prq_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Okanta pairani anta iipatsitiki Judá-iti, ari ipokaki Juan Kiwaatantatsiri, ikamantantzi. ");
INSERT INTO prq_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Iroka ikantan-tapaaki: “Piwashaantairo pikaaripiro-siri-waitaki, tima irootaintsi impinkathari-wintantaji aka Inkiti-satzi.” ");
INSERT INTO prq_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Tima irootaki ikinkitha-takotaki pairani Kamantan-tzinkari Isaías, ikantzi: Tzimatsi kaimapain-tsini otzisi-masiki, inkantan-tapaaki: Piwamiithatainiri Awinkathariti tsika inkinapaaki. Pinkimita-kaantiro itampatzikai-tziro awotsi. ");
INSERT INTO prq_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Irootaki ithaaritari pairani Juan, intyii-tziro iwitzi ikyaakoitari, iwathata-kitari misinantsi-masi. Iwari kintori, iriri iyaaki pitsi. ");
INSERT INTO prq_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Oshiki pokaintsiri pairani iñiiri Juan, Aapatyaawini-satzi, aajatzi poñaanain-chari pasiniki inampi-payi Judá-iti, ipokanaki ikaratzi nampi-thapyaa-tarori Pariñaa. ");
INSERT INTO prq_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Ikinkitha-takoyi-takiro ikaaripiro-siri-waitzi, irootaki ikiwaatantakariri Juan yokapayi anta Pariñaaki. ");
INSERT INTO prq_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Ikanta iñaawakiri Juan ipokajiitaki Nasitantaniri aajatzi Sadoc-iti, inintzi inkiwaatiri iyotaitan-tyaariri kitisiritaji, ikantawakiri: “Ti pinkamiitha-siri-jiiti awiroka, pikimita-sitakari maranki. ¿Piñaa-jaantzi airo iwasankitaitajimi? ");
INSERT INTO prq_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Omapiro-rika piwashaantajiro pikaaripiro-siri-waitzi, pinkamiitha-siritaji, pisiyako-tajyaaro pankirintsi kithota-tsiri. ");
INSERT INTO prq_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Airo pikanta-siri-waitzi: ‘Naaka icharini nowaisatzitini Abraham.’ Pinkimi nonkantimi: ‘Airo pikantakaa-piro-waitasita pinkimi-takaantyaa awiroka ininta-pirotani Pawa, kantatsi yatziri-takairo iroka mapi, irootaki impoyii-tajyaarini incharini-yitajyaari awaisatzitini Abraham.’ ");
INSERT INTO prq_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Airorika pisiyaaro pankirintsi kithoki-tatsiri, ichikakai-tatyiiyaro shiicha pankirintsi-ponkitziki kaari kithoki-tatsini, yaitakiro intaitiro. ");
INSERT INTO prq_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Aririka iwashaantajiro ikaaripiro-siriwita atziri, aritaki nonkiwaatantaiyaari nijaa. Iro kantacha, awotsikitaki matzirori ipinkathari-tsitzi, nopinkatha-tzitaikari naaka, ti onkanti inkimita-kaantina impiratani nonthopaan-tyaaniriri ikyaantari iitziki. Tima iriitaki kimitakaan-tyaaroni inkiwaatantaityaarimi Tasorinkantsi, yoiti-siri-tantyaairimi paamari. ");
INSERT INTO prq_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Tima yairikakiro irirori itikaiki-minto, irootaintsi inkaratiro intikai-kiwaiti. Iwakoyi-tairo kamiithari okithoki pankirintsi, intaimai-tajyaaro otakii-riki.” ");
INSERT INTO prq_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Ipoñaa ipokaki Jesús anta Pariñaaki, ipoñaakaro Tapowiniki. Ipokasi-takiri Juan inkiwaatiri. ");
INSERT INTO prq_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Ti inintawityaa Juan inkiwaatiri Jesús, ikantawakiri: “¿Paitama pipokasi-tantanari naaka nonkiwaatimi? Awiroka kiwaatinani naaka.” ");
INSERT INTO prq_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Yakanaki Jesús, ikantzi: “Noninta-piro-tatzii pinkiwaatina. Irootaki inintakaa-kinari Pawa.” Ari inintanaki Juan, ikantziri: “Aritaki nonkiwaatakimi.” ");
INSERT INTO prq_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Yaanakiri, ikiwaatakiri. Isitowanajiira nijaaki Jesús, kimiwaitaka asitaryaa-nakyaami inkiti, iñiitatzii ipokasi-takiri Tasorinkantsi ikinapaaki inkitiki ikimita-paakari siro. ");
INSERT INTO prq_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ikimaitatzii inkitiki ikantai-tanaki: “Nitakokitani inatzii yoka notomi, oshiki nokimo-siri-wintakiri.” ");
INSERT INTO prq_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Ikantakaa-nakari Jesús Tasorinkantsi jatanaki otzisi-masiki, ari inintawi-takari Kamaari inkaaripiro-siri-takairimi. ");
INSERT INTO prq_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Oshiki kitaitiri isaikawaitaki, tikatsi iwajyaari, ayimatakiri itashi. Tima onkaratzi 40 kitaitiri isaikawaitaki anta. ");
INSERT INTO prq_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Ikanta Kamaari, ipokasi-takiri Jesús inkaaripiro-siri-takairimi. Ikantapaakiri: “Omapiro-tatyaa-rika Itomitami Pawa, pimpyiiro owaritintsi iroka mapi, piyaaro.” ");
INSERT INTO prq_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Ari yakanaki Jesús, ikantanakiri: “Tzimatsi sankinarintsi kantatsiri: Ti apatziro owañaantzi okaratzi iwaitari, tima irootaki owañaa-pirotan-tatsiri ankimisantajirori okaratzi ikantairi Pawa.” ");
INSERT INTO prq_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Ikanta Kamaari yaanakiri nampitsiki tasorintsi-tatsiri, yatiita-kaapaakiri jinoki otawantoki tasorintsi-panko. ");
INSERT INTO prq_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Ikantawi-tapajari: “Omapiro-rika Itomitami Pawa, pimitayi osaawikinta. Pinkinkithasiritiro isankinai-takiri pairani okantzi: Ari intyaan-takimiri Pawa Imaninkariti yaamaako-wintyaami. Iriitaki thomaimini airo pantziwa-tantaro mapi piitziki.” ");
INSERT INTO prq_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Ari yakanajiri Jesús, ikantziri: “Okantzi aajatzi isankinai-takiri pairani: Ti onkamiithati piñaan-tyaari Piwinkathariti Pawa.” ");
INSERT INTO prq_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Yapiiwi-takari Kamaari yaanajiri Jesús tonkaariki otzisiki. Iñaakakiri maaroni nampitsi ipinkathari-yitzi atziri, tima kamiitha okanta owaniinka-yitaka. ");
INSERT INTO prq_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Ikantapajiri: “Piñiiro okaratzi tzimatsiri anta. Aririka pintyiirowa-sitakyaana pimpinkathatina, aritaki nompakimiro maaroni.” ");
INSERT INTO prq_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Ari yakanajiri Jesús, ikantziri: “¡Pijati intaina! Kamaari pinatzii awiroka. Tima isankinaitaki pairani, kantatsiri: Ampinkatha-tajiri Awinkathariti, apatziro ankimisantajiri irirori.” ");
INSERT INTO prq_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Ari yintainainiwita-paintari Kamaari. Pokajii-tapaaki Imaninkariti Pawa, yaminapaa-kiniri inintziri Jesús. ");
INSERT INTO prq_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Ari ikimakiri Jesús yasitakoi-takiri Juan. Irootaki ipiyanta-naari irirori Tapowiniki. ");
INSERT INTO prq_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Ti isaikapaji Kasiyakaa-winiki, ikinanaji Capernaum-ki, ari isaikapajiri. Tima inkaari-thapyaaki osaiki Capernaum, inampiitiki iwaisatzitini Zabulón-iti aajatzi Neftalí-iti. ");
INSERT INTO prq_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Ari omonkaratari okaratzi ikinkitha-takiri pairani Kamantan-tzinkari Isaías, ikantaki: ");
INSERT INTO prq_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Osaiki inkaari-thapyaaki inampitsiti Zabulón-iti aajatzi Neftalí-iti, Intatzikironta Pariñaaki, Saikatsiri Tapowiniki, tsika impiyota-jyaari pasini-satziiti. ");
INSERT INTO prq_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Ikaratzi kimiwita-kariri inkinaki-tyiimi otsitini-kitzi, Ari iñaayitajirori iroopirori ootamintotsi. Otsiman-kakowi-takari yaampari ñaawakai-nkari inkinaimi sarinkawiniki. Okimiwai-taaro isaikajimi okitainkatzi. ");
INSERT INTO prq_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Aripaiti yitanakaro Jesús ikinkitha-takairi atziri-payi, ikantziri: “Piwashaantairo pikaaripiro-siri-waitzi, tima irootaintsi impinkathari-wintantaji aka Inkiti-satzi.” ");
INSERT INTO prq_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Ikanta isiri-thapyaa-tanakaro inkaari anta Tapowiniki, irojatzi iñaanta-pajariri Simón, ipaitai-tziri aajatzi Pedro, itsipatari iririntzi ipaita Andrés, ikithajiitzi. Tima simaatzinkari inajiitzi. ");
INSERT INTO prq_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Ikantapaakiri: “Piyaatina, osiyawai-tajyaaro iroñaaka iriimi atziri nosimaa-takaa-jiityaami.” ");
INSERT INTO prq_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Tima ti ishintanaki, yookanakiro iithari iyaatanakiri. ");
INSERT INTO prq_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Iro yawisanintanakimi, iñaapaa-tziiri Jacobo aajatzi Juan, iririntzi. Ari isaikajiitzi irirori iwitoki iwawithai-tziro iithari-minto itsipatakari iriri paitachari Zebedeo. Yamiñanakiri aajatzi irirori, ");
INSERT INTO prq_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","yookanakiri iriri iwitoki, iyaatanakiri Jesús. ");
INSERT INTO prq_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Ithonka-kiro yaniitakiro Jesús anta Tapowiniki, iyomitaantaki maaroni nampitsiki tsika yapatota-piintaita, ikamantan-takiro Kamiithari Ñaantsi tsika okantakota ipinkathari-wintantaji Pawa. Yisitako-takaa-yitaji ikaratzi mantsiya-yitatsiri nampitsiki. ");
INSERT INTO prq_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Tima ithonka ikima-kotai-tanakiri Jesús anta. Ikimajiitaki aajatzi Tonkaironisatzi, yamayitakiri ishininka ikaratzi mantsiya-tatsiri, yisitako-takaa-yitawakiri. Yamakiri ikaratzi aayitziri kantasi-waita-chari mantsiyarintsi, katsiwai-tatsiri, kamanawai-tatsiri, kisoporoki-waita-tsiri. Yamakiri aajatzi ikyantasiritari piyari. Tima inthonkiri iwawisakota-wakiri Jesús. ");
INSERT INTO prq_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Tima iyaataa-jiitakiri oshiki Tapowini-satzi, Apipakowinisatzi, Aapatyaawini-satzi, poñaayi-tanain-chari pasiniki inampiki-payi Judá-iti, aajatzi intatzikiro Pariñaaki. ");
INSERT INTO prq_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Ikanta iñaakiri Jesús oshiki apatowinta-kariri, tonkaanaki otzisiki, ari isaikapaaki anta. Pokapaaki iyomitaani-payi, ipiyotzi-minta-paakari. ");
INSERT INTO prq_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Ari iyomitaa-yitakiri, ikantziri: ");
INSERT INTO prq_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Kimosiri inkantajyaa sipita-siriri, tima iriitaki ñaajironi ipinkathari-wintantaji Inkiti-satzi. ");
INSERT INTO prq_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Kimosiri inkantajyaa iraaniinta-waita-chari, tima iriitaki yoimosirinkai-tajiri. ");
INSERT INTO prq_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Kimosiri inkantajyaa tsinampa-siriri, tima iriitaki saikaatsini kamiitha kipatsiki ikasiya-kaita-kiriri. ");
INSERT INTO prq_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Kimosiri inkantajyaa amina-mina-tzirori inkamiitha-siriti, tima aritaki iñaajiro inintziri. ");
INSERT INTO prq_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Kimosiri inkantajyaa nisironka-tantatsiri, tima aritaki inisironkai-tairi irirori. ");
INSERT INTO prq_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Kimosiri inkantajyaa kitisiriri, tima iriitaki ñaajirini Pawa. ");
INSERT INTO prq_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Kimosiri inkantajyaa oitsimaryaan-taniri, tima iriitaki inkantaitiri: “itomiyaayi Pawa inajiitzi.” ");
INSERT INTO prq_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Kimosiri inkantajyaa inkimaatsita-kayi-tyaari ikamiitha-siritzi, tima iriitaki ñaajironi ipinkathari-wintantaji Inkiti-satzi. ");
INSERT INTO prq_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Kimosiri pinkantajyaa imaninta-waitaitimi, inkimaatsi-takai-tyaami, inthaiya-kowai-taityaami okantakaan-tziro pikimisantaana. ");
INSERT INTO prq_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Tharowinta pinkanta-yityaa, tima Pawa pinatajimini inkitiki. Pinkinkithasiritiro tsika ikantai-takiri pairani ikimaatsi-takaitari itanakarori Kamantan-tzinkari-payi.” ");
INSERT INTO prq_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Pisiyakaro awiroka-payi tziwi. Aririka inkonowaitiro tziwi tsika ompaityaa, airo apatanaaro inkatyokan-taityaaro. Ontzimatyii imanintaitiro, yookaitakiro osaawiki yaatzika-waitaitiro.” ");
INSERT INTO prq_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Aririka osaiki nampitsi tonkaariki, okoñaatzi maaroni aririka ootyaa tsitini-paiti, ti omañaa nampitsi. Tima kitainka-takotaniri pinatzii, awiroka yomitaa-najirini maaroni atziri, airo pimanimo-tziri okaratzi piyotanajiri. ");
INSERT INTO prq_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Ari okimitari aajatzi, aririka oishiri ootamintotsi, ti antatakotiri. Tima owakotziri jinoki inkitainka-takotan-tyaari ikaratzi saikatsiri pankotsiki. ");
INSERT INTO prq_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Ari pinkanta-najyaari awiroka, pisaika-yitanaji kamiitha iñaantyaamiri pishininka-payi okamiithatzi okaratzi pantayi-tanajiri. Irootaki impinkatha-tanta-jyaariri irirori Asitairi Inkiti-satzi.” ");
INSERT INTO prq_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Airo pikinkithasiri-tasita nopokatzii nowashaanta-kayimiro Ikantakaan-taitsiri, airo nowashaanta-kayimiro aajatzi ikinkitha-takotakiri pairani Kamantan-tzinkari. Apatziro nopoki nomonkara-takaa-yitajyaaro okaratzi ikinkitha-takoi-takiri pairani. ");
INSERT INTO prq_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Omapiro onthonkajyaa kipatsi aajatzi inkiti, airotzimaita awisasita Ikantakaan-taitsiri irojatzi omonkara-tanta-kyaari maaroni. ");
INSERT INTO prq_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Airorika pithotyiiro Ikantakaan-taitsiri, airorika pikaman-tajiri pishininka inkiman-tajyaarori irirori, airo panintaajaro ipinkathari-wintantaji Inkiti-satzi. Iriima matakirori ithotyiiro iyomitaan-tajiro, iriitaki iriipiro-taatsini tsika impinkathari-wintantaji Inkiti-satzi. ");
INSERT INTO prq_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","¿Pisiyakaan-tzima kamiitha-siri ikanta Yomitaan-taniri aajatzi Nasitantaniri? Airorika panaajiri awiroka pinkamiitha-siritaji, airo piñaajiro ipinkathari-wintantaji Inkiti-satzi.” ");
INSERT INTO prq_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Piyojii-tziro awiroka okaratzi ikantai-takiriri pairani awaisatzitini, ikantai-tziri: Airo piwamaantzi. Aririka piwamaantaki, aritaki iwasankitai-takimi awirori. ");
INSERT INTO prq_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Iroka nokantzi naaka: Airo pikishiri pishininka, iwasankitai-tzimi = kari. Airo pikanta-waitziri: ‘Ti piyowaiti awiroka.’ Aritaki iwasankitai-takimi pinkatharintsiki. Ti onkamiithati pinkisa-niinta-waitiri pishininka piitamasontzi-waitiri, patsipitaro = kari pintaajyaa sarinkawiniki. ");
INSERT INTO prq_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Tima paapiintziri pipira pasitakaari Pawa pimpomi-tiniri, iro kantacha aririka pinkinkithasiri-tapaakiro tzimatsi kisanitzimiri pishininka, ");
INSERT INTO prq_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","pookanakiri pipira pasitakaariri, pijatasitiri kisakimiri. Pinkantairi: ‘Ashininká, thami aakamiithata-wakaajyaa.’ Aririka paapatyaa-wakaajyaa, pimpiyi pomitai-rontsiki, pimpomi-tapajiniri Pawa pasitakaariri pipira. ");
INSERT INTO prq_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Tzimatsi-rika kishimini, piñaatyiiri yaanakimi pinkatharintsiki, pintharo-wakoti awotsiki, pinkantiri: ‘Airo pikisawaita, thami aakamiithata-wakaajyaa.’ Tima aririka yariita-kaakyaami pinkatharintsiki, inkantakiri impiratani: ‘Paanakiri yoka.’ Aritaki yaitanakimi yasitakoitimi. ");
INSERT INTO prq_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Airorika pipinata-sitari ikaratzi ikowako-takimiri, airo yoimisitowa-kaantajimi. Omapiro.” ");
INSERT INTO prq_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Piyotziro awirokaiti ikantakaan-taitakiri pairani, ikantaitzi: Airo pimayimpitzi. ");
INSERT INTO prq_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Iroka nokantzi naaka: Aririka piñiiro kooya, ompoña ayimawaitimi piniwi-siri-tyaaro, pimayimpi-siri-takiro. ");
INSERT INTO prq_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Iroka nosiyakaan-timiro. Iroorika pokipiro kaaripirota-kayimiri, piwashaantajiro, pinkimi-takaantiro pinkitho-ryaatyiiromi, piroki. Tima ti pininti patsipi-tajyaaro sarinkawini onkanta-kaantiro poki, tima irootaki kamiitha-tatsi pisaika-pityaakitaji. ");
INSERT INTO prq_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Iroorika pakopiro kaaripirota-kayimiri, piwashaantajiro, pinkimitaan-tairo pinchika-tyiiromi pako, pookiro. Tima ti pininti patsipi-tajyaaro sarinkawini okantakaan-tziro pako, tima irootaki kamiitha-tatsi pisaikaponthokitai. ");
INSERT INTO prq_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Ikantaitaki aajatzi pairani: Aririka yookawa-kaityaa, ontzimatyii impaitiri tsika osankina-takota yooka-wakaan-tyaari. ");
INSERT INTO prq_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Iroka nokantzi naaka. Kaaripiro-siritaki ikaratzi ookasitarori iina, irooma iñiiro-rika omayimpitaki kantacha yookiro. Aririka aawitajyaa iroori pasini oimi, omayimpi-tzimo-takiri itawitari oimintari. Ari inkanta-jyaari aajironi, mayimpitaki irirori.” ");
INSERT INTO prq_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Piyojii-tziro ikantai-takiriri pairani awaisatzitini: Airo pipairyaa-siwaitari Pawa. Tima aririka ontzimi pinkasiya-kairiri Pawa, ontzimatyii pimonkara-tiniri. ");
INSERT INTO prq_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Iroka nokantzi naaka: Ti onkamiithati pimpairyaa-siwai-tyaari Pawa pimatan-tyaarori pikanta-yitziri. Airo pipairyaa-siwaitaro inkiti, tima ari isaikiri Pawa anta. ");
INSERT INTO prq_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Airo pipairyaa-waitziro kipatsi, tima iriitaki asitaro Pawa, irootaki ikatziya-chinti-tanta-piintari. Airo pipairyaa-siwaitaro Aapatyaawini, tima aritaki ipinkathari-wintantaji Pinkathari-pirori. ");
INSERT INTO prq_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Airo pipairyaa-siwaitaro piito, pinkanti: ‘Airorika nomatziro nokantziri, inthatzinkai-tinaro noito.’ Tima ti awiroka matironi pishooka-kairo pipai, ipoñaa pinkisaisitakaajiro. ");
INSERT INTO prq_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Airo pamatawi-tantzi. Omapiro-rika pantiro pikanta-yitziri, pinkanti: ‘Jii, nomatiro.’ Airorika pantziro, pinkanti: ‘Airo nomatziro.’ Tima ti onkamiithati pishikyiiro piñaani.” ");
INSERT INTO prq_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Piyojii-tziro awiroka ikantai-takiri pairani: Aririka pinkitho-ryiitiri irooki pasini atziri, okamiithatzi inkisako-wintai-tyaari, inkitho-ryiitai-timiro poki awiroka. Aririka pinkiryaa-kotiri pasini atziri, okamiithatzi inkisako-wintai-tyaari ikiryaakoitimi awiroka. ");
INSERT INTO prq_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Iroka nokantzi naaka. Ti onkamiithati pimpiya-tyaari kisaniintzimiri. Aririka impasaitimi kashita-poroni, pisinitiniri imonti-porotimi impasatimi. ");
INSERT INTO prq_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Aririka yaitimi pinkatharintsiki ininti yaapithai-timiro pithaari, pisinitiniri yaanakiro aajatzi piwiwiryakota-piintari. ");
INSERT INTO prq_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Aririka impirai-tyaami paanakiro owaararontsi pookiro niyaanki awotsi, paanakiro owaararontsi panaakairo tsika ikantai-takimi pookiromi. ");
INSERT INTO prq_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Aririka inkantaitimi: ‘Pimpina,’ okamiithatzi pimpiri. Aririka inkantaitimi: ‘Pimpawakina, ari noipyaajimi,’ okamiithatzi pimpiri airo pithañaa-pithatari. ");
INSERT INTO prq_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Piyojii-tziro awiroka ikantaitaki pairani: Pintakota-jyaari pishininka. Iriima ikaratzi kishimiri, pinkishiri irirori. ");
INSERT INTO prq_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Iroka nokantzi naaka: ‘Pintako-tyaari kishimiri. Pamana-kotairi maaroni inisironka-tanta-jyaariri Pawa. Airo pipiyatari kisaniintzimiri, paakamiitha-tairi.’ ");
INSERT INTO prq_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Irootaki ikowa-kayi-takiriri itomiyi-taari Asitairi Inkiti-satzi. Tima iriitaki owitsika-kiriri ooryaatsiri kitaityaa-kotziriri maaroni atziri: kamiitha-siriri, aajatzi kaari-piro-siriri. Irijatzi owitsika-kirori inkani, iwaryiiniri maaroni atziri: tampatzika-siriri aajatzi kowiinka-siriri. ");
INSERT INTO prq_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Apatziro-rika pitakotari ikaratzi otakotamiri awiroka, ¿pisiyakaantzi aritaki impinataimi Pawa? Tima airo, irootaki yanta-piintakiri sintsiwintziriri atziri impinatiri iriitaki yasitakai-yaari iwinkathariti wirakocha. ");
INSERT INTO prq_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Apatziro-rika piwitha-tapaa-kyaari pishininka, ¿aminaasi-waitaantsi iroka? Tima irootaki imata-piintakiri pasini-satzi atziri. ");
INSERT INTO prq_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Pinkamiitha-siri-yitaji awiroka, pisiyako-tajyaari Asitairi Pawa, omapiro ikamiitha-siritaki irirori.” ");
INSERT INTO prq_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Piwashaantajiro piwapyii-motari atziri-payi pikamiithasiri-taimi. Aikiro-rika pijatakaa-tyiiro, tikatsi impinata-jimiri Asitairi Inkiti-satzi. ");
INSERT INTO prq_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Aririka pimpasi-tantyaa, airo pikanta-kanta-waitzi: ‘Nopasitantaka naaka.’ Apatziro ikanta-kanta-waitzi owapyiimo-tantaniri tsika yapatota-piintaita aajatzi tsika ikinaita-piintzi, irootaki impinka-thaitan-tyaariri irirori. Tzimaki pinkatha-matsi-takiriri irirori. ");
INSERT INTO prq_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Aririka pimpasi-tyaari awiroka asinonkai-nkari, airo pikanta-kanta-waitzi, ");
INSERT INTO prq_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","omanani-kiini onkantyaa pipasitan-takari. Apatziro iyotzi Pawa, tima iriitaki pinatajimini.” ");
INSERT INTO prq_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Aririka pamaniri Pawa, airo pisiyakotari kantasiwairintzi. Tima inkatziya-piinta irirori yapatota-piintaita aajatzi niyaankiniki nampitsi iñaantyaariri ishininka-payi. Tzimaki pinkatha-matsi-takiriri irirori. Omapiro. ");
INSERT INTO prq_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Irooma awiroka aririka pamani, pasitakotyaa piwankoki pinkowa-kotiri Asitairi tsipata-kamiri. Iriitaki ñiimini apaniroini, aritaki inisironka-takyaami, iriitaki pinatajimini. ");
INSERT INTO prq_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Aririka pamani, airo papii-pii-tziro okaratzi pikantakiri. Apatziro yapii-pii-tziro pasini-satzi atziri. Iñaajaantzi yapii-yapii-tziro ikantakiri aritaki inkimakiri Pawa. ");
INSERT INTO prq_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Paamawintyaa pisiyakotari = kari awiroka. Tima tikira pinkowa-kotiriita Asitairi kowityii-motamiri, iyotzita-waitakaro irirori okaratzi kowityii-motamiri. ");
INSERT INTO prq_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Iroka pinkanti pamana-piinti awiroka: Asitanarí, nampitarori inkitiki, Tasorintsi onatzii piwairo awiroka. ");
INSERT INTO prq_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Pimpinkathari-wintajina naaka. Pantakainaro aka kipatsiki okaratzi pininta-kainari awiroka, Pinkimi-takaan-tajinari inkiti-wiri, pantakairi irirori maaroni pininta-kairiri awiroka. ");
INSERT INTO prq_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Pimpa-piintina kowityii-motanari noyaari. ");
INSERT INTO prq_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Pimpyaako-tajinaro nokaaripiro-siri-waitaki, Tima nomatakiro naaka, nopyaako-tajiri ikaratzi owaaripiro-siri-tanari. ");
INSERT INTO prq_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Airo pisinitana iñaantai-tyaana, inintaiti yanta-kayi-tinaro kaari-pirori. Tima pasi piwajiro pimpinkathari-wintantaji awiroka. Ari pikanta-jitatziiro otzimimo-tzimi pisintsinka, aajatzi piwaniinkaro. Aritaki okantari. ");
INSERT INTO prq_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Aririka paripiro-tajyaari ikaratzi kishimiri, aritaki yaripiro-taimi awiroka Asitairi Inkiti-satzi. ");
INSERT INTO prq_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Irooma airorika paripirotari ikaratzi kishimiri, tima airo yaripiro-taami awiroka Asitairi.” ");
INSERT INTO prq_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Aririka pintziwintyaa pisirita-kotyaari Pawa, airo pikanta-kanta-waitzi: ‘Notziwinta-tyaari Pawa.’ Paamaiyaa pisiyari = kari awiroka kantasiwaitsinkari. Itziwinta-piintawita irirori mantsiya ikantayita, irootaki iyoitan-tariri itziwintatyaa. Tzimaki pinkatha-matsi-takiriri irirori. Omapiro. ");
INSERT INTO prq_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Irooma awiroka aririka pintziwin-tyaari Pawa, pinkiwa-porotyaa, pinkisityaa kamiitha, ");
INSERT INTO prq_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","airo iyotantaitami pitziwintatyaa. Apatziro iyotimi Asitairi Inkiti-satzi, tima iriitaki pinatajimini.” ");
INSERT INTO prq_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Airo pashaaranta-siwaita aka kipatsiki, oshiki opirikitanaki, ompowanaki, tima tzimatsi oshiki kosintzi aka. ");
INSERT INTO prq_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","iro kamiitha-tatsi pantayi-tairo pisaikan-tajyaari kamiitha inkitiki. Irootaki kimitajyaaroni pashaarantaa-tyiiyaami inkitiki tsika ti opiriniki-tapaji, opowani-tapaji aajatzi, tima ti intzimapaji kosintzi anta. ");
INSERT INTO prq_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Tima tsika-rika piwaa-rantaka, aritaki pisirita-piinta-jyaaro.” ");
INSERT INTO prq_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Irootaki oki osiyariri ootamintotsi awathaki. Kamiitha-rika okanta poki, piñaantaro kamiitha, okimiwai-takaro pinkoñiityaa-kotatyiimi. ");
INSERT INTO prq_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Tirika ampantyaaro poki, airo piñaantaro kamiitha, okimiwai-takaro pintsitini-kitako-tatyiimi.” ");
INSERT INTO prq_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Tikatsi matironi yantawai-tiniri apiti opiratan-tachari. Tima aparoni ininta-piroti imonkara-tiniri ompira-tantachari, iriima pasini inkisaniinta-nakiri. Ari okantari aajatzi: Tikatsi matironi yantiniri Pawa inintziri irirori, aririka inkinkithasiri-takotai-tyaaro awaararontsi onkimiwai-tanakyaaro iroomi ompiratyaarini.” ");
INSERT INTO prq_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Pinkimi nonkanti: Airo okantzimo-siri-waitami pinkanti: ‘¿Paitama noyaari, opaitama niriri, opaitama nonkithaa-tyaari?’ Tima tzimatsi ankinkithasirita-piintajiri, irootaki kowapiro-tachari, anairo okaratzi awayita-piintari, aajatzi akithaayita-piintari. ");
INSERT INTO prq_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Thami ankinkisiryaa-takotiri tsimiri-payi. Ti impankitiro iyaari, ti iwitsiki iwanko iwantyaarori iwankiri. Iro kantacha, Pawa opapiintziriri okaratzi iwayitari. ¿Tima intako-piro-tyaami awirokaiti Pawa? ");
INSERT INTO prq_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Aikiro-rika pijatakaa-tyiiro onkantzimo-siri-waityaami ¿arima pinkantakiro piwawi-niinta-wairo pisarintsiti? ");
INSERT INTO prq_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Thami ankinkithasiri-takotiro incha-tyaaki-payi, ti añiiro antawaiti, ti ontyaawintyaa onkithaa-tyaari. Titzimaita onkantzimo-siri-waityaaro, onkanti: ‘¿Opaitama nonkithaa-tyaari?’ ");
INSERT INTO prq_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Owaniinka kamiitha, anairi iwaniinkata Salomón, pinkathari-tatsiri pairani. ");
INSERT INTO prq_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Tima iriitaki Pawa owaniinka-tzirori. Okantawita kapichiini añaawitaro owaniinkata-painta, iro osamani tikatsi apantyaaroni aririka onkama-tyaa-tanaki, inchikai-takiro, intayii-takiro. ¿Airoma ikimpoyaa-wintzimi awiroka Pawa? Aritaki, airo pikiso-siritzi. ");
INSERT INTO prq_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Aritapaaki okantzimo-siri-waitami, pikantzi: ‘¿Paitama noyaari, opaitama niriri, opaitama nonkithaa-tyaari?’ ");
INSERT INTO prq_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Apatziro okantzimo-siri-waitari pasini-satzi-payi. Irooma awirokaiti, iyotako-tzimiro Asitairi Inkiti-satzi opaita-rika kowityii-motamiri. ");
INSERT INTO prq_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Tima irootaki kowapiro-tachari impinkathari-wintajimi Pawa, iwamiitha-siri-taimi aajatzi, aritaki impayita-jimiro okaratzi kowityii-motamiri. ");
INSERT INTO prq_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Aritaki okantari, airo okantzimo-siri-waitami opaita-rika awishimo-timini onkitaitita-manaji, aritaki piñaakiro. Tima maaroni kitaitiriki-payi piñaa-piintakiro okaratzi kantzimo-siri-yitamiri.” ");
INSERT INTO prq_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Ti onkamiithati pimishakowintanti, paamaiyaa imishakowintai-tzimi = kari awiroka. ");
INSERT INTO prq_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Aririka pinkanta-kotiri pishininka, aritaki inkanta-kota-nakimi awiroka. Ontzimatyii paamaiyaa, otzimi-kari pantzi-motantani, imapiroi-tajimi = kari apaata impiyatai-tyaami. ");
INSERT INTO prq_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Tima osiyawaitakaro aririka ontyaa-kitimi antaro incha-pitoki pokiki, ¿kantachama paminiri pasini tyaakita-chari kapichiini irokiki? ");
INSERT INTO prq_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","¿Kantachama pinkantiri: ‘Pimpoki naajimiro otyaa-kita-kimiri?’ Otyaaki-taikimi awiroka antaro incha-pitoki. ");
INSERT INTO prq_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Tima pisiyakari awiroka kantasiwaitsinkari. Ontzimatyii pitawakyaaro awiroka paawairo antaro inchato otzikaa-kimiri pokiki, paminaji kamiitha paanta-jyaaniriri otyaakita-chari kapichiini. ");
INSERT INTO prq_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Ti impaitiri otsitzi okaratzi tasorin-tsita-tsiri yasitari Pawa. Ti impaitiri aajatzi chancho okaratzi poriryaa-yitatsiri pinapirota-chari, ti iyoti inithaa-wainiti oshiki yoipatsi-waitiro yaatzika-waitakiro. Ti impaita-tyiiri inintawitari, oshiki inkatsimati, aritaki yatsikantaki.” ");
INSERT INTO prq_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Pikamiti, pamina-minatai aajatzi, aritaki impaita-jimiro pinintziri. Pisiyakaantiro aririka pariityaa pankotsiki, pinkanta-paakiri asitarori: ‘Pasitaryiinaro piwanko.’ Aritaki yasitaryaa-kimiro iwanko. ");
INSERT INTO prq_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Tima aritaki impaitajiri kamitan-tatsiri. Inkarati amina-minataironi, aritaki iñaakai-tairi. Aririka inkantanti: ‘Pasitaryiinaro.’ Aritaki yasitaryaaitakiniri. ");
INSERT INTO prq_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Aririka inkamitimi pitomi, inkantimi: ‘Apaá, pimpina noyaari.’ ¿Arima pimpakiri mapi? ");
INSERT INTO prq_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Aririka inkantimi: ‘Pimpina sima.’ ¿Arima pimpakiri maranki iyaari? ");
INSERT INTO prq_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Tima piyotziro pitakotari awiroka pitomi-payi, kaari-piro-siri pinawita. Iriitaki mapirotzirori Asitairi Inkiti-satzi, itakotari maaroni amanayitairiri. ");
INSERT INTO prq_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Aririka pininti intakoi-tajyaami, pitawakyaaro awiroka pintakotantyaa. Tima irootaki kanta-kota-chari Ikantakaan-taitani, irojatzi ikantakiri pairani Kamantan-tzinkari-payi.” ");
INSERT INTO prq_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Aririka pininti pinkyaa-pankotairi Pawa, pisiya-kayiro pimpampi-thata-tyiiromi awotsi-manchaki. Tima tzimatsi pasini awotsipirori, kaari pomirintsita-chani inkinan-taityaaro. Tima oshiki pampithata-kirori, iriitaki asinonkaa-chani sarinka-winiki. ");
INSERT INTO prq_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Irooma awotsi-manchaki, ti ishikiti kinantyaaroni, iriitaki ariitaa-chani anta tsika irasi iwiro yañaaji.” ");
INSERT INTO prq_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Paamawinta-jiityaa awirokaiti yamatawitzimi = kari osiyawitariri Kamantan-tzinkari, isiyapaa-kyaari ipiraitari ti ikatsima-waiti. Iro kantacha kaari-piro-siriri inatzii, isiyakari owantaniri. ");
INSERT INTO prq_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Ontzimatyii ayotiiri kamiitha-rika okaratzi yantayitziri, irootaki ayotantyaari kamiitha-siriri inatzii. ¿Añiiroma chochoki iraitsiri onkitho-kitan-tyaaro owaato kitoochii? Tima ti. ¿Kantachama onkitho-kitan-tyaaro pasini chochoki-payi iroori? Tima airo. ");
INSERT INTO prq_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Iroorika inchato saankanata-tsiri oshooki, okitho-kitzi kamiitha. Irooma inchato karipirori, ti ampantyaaro okithoti. ");
INSERT INTO prq_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Tima maaroni inchato saankanata-tsiri oshooki, ti onkaaripiroti okithoki. Ari okantari aajatzi inchato sampiya-sita-tsiri osi, ti onkamiithati okithoki. ");
INSERT INTO prq_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Tima intowaitatyiiro inchato kaari kithokita-tsini kamiitha, yaitziro intayiitiro. ");
INSERT INTO prq_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Aritaki piyojiita-wakiri awiroka-payi amatawiriri aririka piñaayitakiro okaratzi yantayitiri.” ");
INSERT INTO prq_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Tzimawitacha oshiki kantanari: ‘Nowinkathariti pinatzii awiroka, nopinkathatzimi.’ Airotzimaita ikyaaji inkitiki tsika ipinkathari-wintantai Pawa. Apatziro inkyaaji ikaratzi antanajirori inintziri Asitanari Inkiti-satzi. ");
INSERT INTO prq_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Apaata aririka namina-kotajiri maaroni yantayitakiri, tzimayitatsi kantayita-jinani: ‘Nowinkathariti, nopairyaa-kimiro piwairo nokinkithata-kotzimi. Nopairyaakimi nisita-kota-kayiri isakasiritantari piyari. Ari nokimita-jiriri aajatzi noshininka-payi, oshiki notasonka-winta-yitaki nopairyiiniri piwairo.’ ");
INSERT INTO prq_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Nonkan-tzimaityaari naaka: ‘Ti noyotimi. Pijati intyaatsikaini, omapiro pikaaripiro-siritaki.’ ” ");
INSERT INTO prq_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Pinkimi. Aririka pinkinkithasiritiro maaroni nokanta-kimiri, aririka pinkimisanta-najiro maaroni, ari okamiithatzi. Irootaki piyota-nityaari. Pisiyaari witsika-tsiri iwanko okiraawiro-pathatzi kipatsi. ");
INSERT INTO prq_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Oparyaa-witaka antaroiti inkani, amaraaniwitaka. Antaro otampyaa-witaka, ookanta-witapaakaro pankotsi, ti aawyiiro. Tima owatzika-pirotyaa kamiitha okiraawiro-pathataki kipatsi. ");
INSERT INTO prq_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Ari okimitari aajatzi airorika pikinkithasiritziro okaratzi nokanta-yitakimiri, airorika pinkimisanta-najiro, airo piyota-nita. Pisiya-kotakari witsika-tsiri iwanko impaniki-pathatzi. ");
INSERT INTO prq_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Okanta oparyaa-paaki inkani, amaaranita-paaki. Ari otampyaata-paaki, ookanta-paakaro pankotsi, tyaanaki. Ti iñiitajiro.” ");
INSERT INTO prq_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Irootaki iyomitaa-kiriri Jesús ikaratzi apatowinta-kariri. Okiryaantzi ikantajiita atziri-payi ikimiri. ");
INSERT INTO prq_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Tima ti omañaa isintsinka iyomitaantzi, yanairi iyomitaantzi Yomitaan-taniri-payi. ");
INSERT INTO prq_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Ikanta yoirinkajaro Jesús ikinkithatakira tonkaariki, iyaatajiri oshiki atziri. ");
INSERT INTO prq_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Ari ipoka-sitakiri omatziri pathaa-rontsi, ityiirowa-sita-paakari, ikantapaakiri: “Pinkatharí, pinintzi-rika, aritaki onkantaki pisita-kota-kaajina.” ");
INSERT INTO prq_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Irootaki yakotan-tanakari Jesús, itzinkakiri kapichiini, ikantziri: “Nonintzi, pisita-kotaji.” Isitanaki ipathaa-waiwita. ");
INSERT INTO prq_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Ikantawita-waari Jesús pathaa-waiwita-chari: “Airo pikamanta-kotana. Apatziro piwanakiro pijata-sitiri Ompira-tasorintsitaari, pimatan-tyaarori Ikantakaantani pairani Moisés, paanakiniri Pawa pasitakaariri pipira, irootaki iyotantai-tyaari isita-kotajimi.” ");
INSERT INTO prq_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Ikanta yawisanaki Jesús, ariijiitaka nampitsiki Capernaum. Ari ipokaki ijiwari iwayiriti wirakocha iñiiri Jesús, ");
INSERT INTO prq_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","ikantapaakiri: “Nowinkatharití, tzimatsi naaka nompiratani nowankoki, omapiro imantsiyataki, kisoporokitaki.” ");
INSERT INTO prq_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Ari yakanakiri ikantziri: “Aritaki nojataki nowawisaakotajiri.” ");
INSERT INTO prq_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Ikantanaki irirori: “Oshiki nopinkathatakimi awiroka, tima tikatsi miraawintyaanani naaka, airo okantzi pinkyaa-wankotina. Apatziro nonintzi pinkanta-kaantiri yisita-kotai, aritaki omatakyaa pinkantiri. ");
INSERT INTO prq_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Tzimatsi ompiratanari naaka, tzimatsi aajatzi owayiri-payi nompiratari naaka. Aririka nonkantiri: ‘Pijati,’ aritaki ijataki. Aririka nonkanti pasini: ‘Pimpoki,’ aritaki impokaki. Aririka nonkantiri nompiratani: ‘Pantiro iroka,’ imatziro yantziro.” ");
INSERT INTO prq_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Okiryaantzi ikantanaka Jesús ikimakiri ikantaki ijiwariti owayiri. Ikantanakiri ikaratzi oyaatakiriri: “Iriitaki matakirori yoka ikimisantzi, tima aka inampiitiki Israel-iiti tikira noñii aparoni siyaarini. Omapiro. ");
INSERT INTO prq_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Pinkimi, aririka impinkathari-wintantai Inkiti-satzi, aritaki intzimaki oshiki pasini-satzi poñaachani pasiniki nampitsi, yanintaajyaa isaikakaajiri awaisatzitini Abraham, Isaac aajatzi Jacob. ");
INSERT INTO prq_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Airotzimaita itzima-pirotaji ashininka saikaatsini anta. Iriitaki inintawitaitari impinkathari-wintairi maaroni anta, tima oshiki ipiyathataka, irootaki yookanta-jyaariri otsitini-kitaki. Ari iraawaita-jyaari, yatsikai-kiwaitajyaa inkimaatsitajyaa.” ");
INSERT INTO prq_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Ipithoka-sita-naari ijiwariti owayiri, ikantziri: “Pimpiyi piwankoki. Pimatakiro pikimisantzi awiroka, irootaki yisita-kotan-tajyaari pimpiratani.” Apatha-kiro yisita-kotanaki impiratani iwankoki. ");
INSERT INTO prq_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Ikanta ikinanaki Jesús iwankoki Pedro. iñaapaa-tziiro irayiro onaryaaka, omatatziiro okatsirinkawaitsi. ");
INSERT INTO prq_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Itzinka-paakiro kapichiini irakoki, isita-kotanaki. Piriintanaka, aminayita-wakiniri ompaita opawakiriri. ");
INSERT INTO prq_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Okanta otsitiniityaanaki, yamaita-paakiniri oshiki yaayiri piyari. Yisita-kota-kaayitairi ikisatha-yitakiri iwiyariti. Yisita-kota-kaaki aajatzi ikaratzi mantsiyayita-tsiri. ");
INSERT INTO prq_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Ari omonkaratari ikamantantakiri pairani Kamantan-tzinkari Isaías, ikantaki: Iriitaki aanakiro amantsiyari, Irijatzi aanakiro okaratzi akimaatsi-yitari. ");
INSERT INTO prq_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Ikanta iñaakiri Jesús ishiki-pirota-paaki atziri apato-tawintariri, ikantanakiri iyomitaani: “Thami amontyaaji intatzikironta.” ");
INSERT INTO prq_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Ikantawita-waari Yomitaan-taniri: “Yomitaanarí, nonintzi noyaata-nakimi tsika pinkinayiti awiroka.” ");
INSERT INTO prq_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Yakanaki Jesús, ikantziri: “Tzimatsi imoro kowincha imaanta-piintari, aajatzi ikimita tsimiri-payi tzimatsi imayiro. Iriima yoka Itomi Atziri ti ontzimi iwanko imaanta-piintyaari irirori.” ");
INSERT INTO prq_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Ari ikantanaki iyomitaani: “Yomitaanarí, noninta-witaka naaka noyaata-nakimi, airotzimaita iroñaaka, nonintatzii noñiiro nonkitata-najiri asitanari, aripaiti noyaatimi.” ");
INSERT INTO prq_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Ikantanaki Jesús: “Piyaatina. Tima inkarati kamasirita-tsiri, aritaki inkitatairi irirori kaminkari-payi.” ");
INSERT INTO prq_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Ari ititanaka Jesús pitotsiki, itsipatakari iyomitaani-payi. ");
INSERT INTO prq_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Ikanta imontyaa-kotanaka, maanaki Jesús pitotsiki. Iro iwiraako-witaka niyankyaaki, omapokakiri iyomitaani-payi antaro tampyaa, otitapaaka nijaa pitotsiki otamaakata-nakira inkaari. ");
INSERT INTO prq_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Ijata-sitai-takiri Jesús, iwakiryii-paakiri, ikantai-tziri: “¡Yomitaanarí, ampiinkatyii! ¡Piwawisaa-kotajina!” ");
INSERT INTO prq_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Ikantanakiri irirori: “¿Paitama pitharowantari? ¿Tikirama pikimisanta-pirotzi?” Piriintanaka, imairintakiro tampyaa aajatzi otamakaani inkaari, awisanaki, mairyaatanaji kamiitha. ");
INSERT INTO prq_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Okiryaantzi ikantawinta-nakari Jesús, antaro ipinkathata-nakiri, ikanta-wakaa-jiita: “¿paitama atzirita-tsiri yoka? Imairintziro tampyaa, aajatzi inkaari.” ");
INSERT INTO prq_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Ariijiitaka intatzikiro, aatakota-paaki nampitsiki ipaitai-tziri Gadara. Ari isiya-sita-wakari apiti atziri yaakiri piyari ipoñaakaro kitataari-masiki. Katsima ikantakaakari piyari, oshiki itharowakaitari, ti onkanti inkinaiti anta. ");
INSERT INTO prq_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Ikaimaa-pirotatzii ikantzi: “¡Jesús, Itomi Pawá! ¿Piwasankita-tyiinama tikirata omonkaratyaata? ¿Tsikama nokanta-kimika awiroka?” ");
INSERT INTO prq_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Ari isimoka-waijiitzi oshiki chancho anta. ");
INSERT INTO prq_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Ñaawaitanaki iwiyariti, ikantzi: “Aririka pisita-kota-kaajiri naaka, pintyaantina ipiyotaka chancho.” ");
INSERT INTO prq_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Ikantzi Jesús: “¡Pijati piyarí!” Jatanaki piyari-payi chanchoki, isaikantapaakiri, irootaki isiyanta-nakari impiritaki, mitaajiita-paaka maaroni inkaariki, apirotaka ipiinkaki. ");
INSERT INTO prq_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Ikanta iñaakiro aamaako-wintariri chancho okaratzi kantain-chari, siyanaka nampitsiki, ikamanta-paakiri maaroni atziri okaratzi iñaakiri. ");
INSERT INTO prq_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Irootaki iyatanta-nakariri atziri-payi, iñaapaakiri Jesús, ikantapaakiri: “Ti noninti pisaiki nonampiki, pamini tsika pinkini.” ");
INSERT INTO prq_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Ikanta ititanaaro Jesús pitotsiki, imontyaaja inampiki. ");
INSERT INTO prq_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Ari yamaita-kiniri kisoporokiri, yanatakoi-takiri inaryaa-mintoki. Iyosirita-wakiri Jesús ikaratzi anata-kota-kiriri oshiki yawintaa-paakari, iñaanata-wakiri mantsiyari, ikantziri: “Pinkimo-siriwintyaa ashininká, tima impyaakoi-takimiro pikaaripiro-siri-witaka.” ");
INSERT INTO prq_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Kimawaki Yomitaan-taniri-payi, ikanta-siritanaki: “Ithainka-tasorintsitatzii yoka.” ");
INSERT INTO prq_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Yotaki Jesús tsika ikanta-siritzi, isampita-nakiri, ikantziri: “¿Opaita pikaaripiro-siritantari? ");
INSERT INTO prq_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","¿Tima onkamiithati nonkanti: ‘Ipyaakoi-tajimiro pikaaripiro-siri-witaka?’ ¿Irooma pinintzi nonkantiri: ‘Pinkatziyi, pijatai?’ ");
INSERT INTO prq_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Iroñaaka piyotiri Itomi Atziri otzimi-motziri isintsinka aka kipatsiki, aritaki impyaakotairi kaaripiro-siri-witachari.” Ipithoka-sita-nakari kisoporokiri, ikantziri: “Pinkatziyi, paanajiro pinaryaa-minto, pijatai piwankoki.” ");
INSERT INTO prq_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Ari ikatziyanaja mantsiya-witachari, jataji iwankoki. ");
INSERT INTO prq_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Tima iñaakiri maaroni piyotain-chari, okiryantzi ikantajiitanaka iñaawajiri ijataji. Ikantajiitanaki: “Imapirota-tziiro Pawa, iriitaki matakirori otzimi-motan-tariri itasorinka yoka atziri.” ");
INSERT INTO prq_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Ikanta yawisanaki Jesús, irojatzi iñaanta-paariri Mateo, iriitaki yoka sintsiwintan-tatsiri yamaitiniri kiriiki. Ikantapajiri: “Piyaatina.” Ari ikatziyanaka Mateo iyaatanakiri. ");
INSERT INTO prq_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Ariitaka iwankoki Mateo iwakaiyaari Jesús, ari itsipatakariri iyomitaani-payi. Tima oshiki sintsiwintan-tatsiri yamaitiri kiriiki jatanain-tsiri, ijatzitaka aajatzi oshiki antayitzirori kaari-pirori. Ari ikaratzi itsipajiitakari Jesús. ");
INSERT INTO prq_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Ikanta iñaakiri Nasitantaniri, ikaimakiri iyomitaani Jesús, isampitakiri, ikantziri: “¿Paitama itsipatan-tariri Jesús sintsiwintan-tatsiri yamaitiniri kiriiki aajatzi antayitzirori kaari-pirori? Ti onkamiithati.” ");
INSERT INTO prq_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Ikimaki irirori Jesús, ikantzi: “Aririka imantsiyati atziri ipoka-sitziri aawintan-tzinkari, iriima atziri kaari mantsiyatatsi tikatsi ininti irirori. ");
INSERT INTO prq_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Ontzimatyii pinkinkithasiritiro Ikantakaantani Pawa, kantatsiri: Ti apatziro nonintzi pamayitajina patsipita-kaani. Iro nokowa-pirotajiri pinisironkatairi pishininka. Tima ti nompoka-sitiri ikimita-kaantai-tziri kamiitha-siriri inawita, nopoka-sita-tziiri kaari-piro-siriri nonkaima-siritajiri iwashaantairo kaari-pirori.” ");
INSERT INTO prq_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Ari ipokajiitaki iyomitaani Juan, isampita-paakiri Jesús, ikantziri: “¿Ipaitama kaari itziwintanta piyomitaani? Tima nontziwinta-piintyaa naaka, ari ikimi-tzitari iyomitaani Nasitantaniri.” ");
INSERT INTO prq_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Ari yakanakiri Jesús, ikantanakiri: “Aririka ajati aawakaan-tsiki, ¿arima awasirita-paakyaa? Aryaajaini apaata, aririka yaitakiri iimintaitari, aripaiti intziwintaityaa. ");
INSERT INTO prq_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Tima aparoni paisatori ikithaataitari, aririkami iwapatankai-tantyaaro owakirari manthakintsi, aritaki osaraa-pirotanaki aririka ampithata-nakyaa owakirari manthakintsi. ");
INSERT INTO prq_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Ari okimitari aajatzi, ti inkanta-pirotyaa paisatori misinantsi-naki iwantai-tyaari airyaari iraitsiri. Aririka iwantai-tyaari, aritaki isanaryaanaki, aparata-siwaitakyaa iraitsiri aajatzi misinantsi-naki. Iriitaki kamiithatatsi owakirari misinantsi-naki iwantai-tyaari, apitiro inithaa-wakaa airo oyaaripirota-wakaa.” ");
INSERT INTO prq_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Ikinkithawai-minthaitzi Jesús, ariitapaaka ijiwariti Judá-iti, ityiirowa-paaka impinkathata-paakiri, ikantziri: “Kamaki nosinto, irootaki nopokantari pijati nowankoki pantanta-jyaaro kapichiini pako, añaajiita.” ");
INSERT INTO prq_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Ari ijatanaki Jesús, aajatzi iyomitaani-payi, iyaatanakiri. ");
INSERT INTO prq_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Ari opokapaaki kooya mantsiyata-tsiri, tima oshiki osarintsi asinonkaawaitaka, tzima-kotaki 12 osarintsi, okina-sita-paakiri itaapiiki Jesús, antakiro kapichiini opatziki iithaari. ");
INSERT INTO prq_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Okanta-siritzi: “Aririka notzinki-takiri kapichiini iithaari, aritaki nisita-kotaji.” ");
INSERT INTO prq_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Ari ipithoka-sita-nakaro Jesús, ikantziro: “Kimosiri pinkanta-najyaa noshininka, irootaki isitakotaa-jimiri pawintaajana.” Apatha-kiro isitanaki omantsiyari kooya. ");
INSERT INTO prq_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Ikanta yariita-paaka Jesús iwankoki ijiwariti Judá-iti, iñaapaa-tziiri showiriwintzirori kamaintsiri, oshiki atziri akiwai-nkatain-chari iraajiita. ");
INSERT INTO prq_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Ikantapaakiri: “Pishikajiiti, ti onkami piraako-jiitakari, omakoryaatzii.” Tima thainkaitakiri Jesús. ");
INSERT INTO prq_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Imisitowa-paakiri maaroni, kyaapaaki Jesús, yairika-wakota-paakiro, piriintanaja iintsi. ");
INSERT INTO prq_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Tira imanakoitanakiri Jesús, ikimakoi-tanakiri maaroni anta. ");
INSERT INTO prq_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Ikanta yawisanaki Jesús, iyaatanakiri apiti mawityaakiri, ikantzi ikaimi: “¡Ikasiya-kaitani pinkatharini David, pinisironkata-jyaana!” ");
INSERT INTO prq_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Irojatzi yariitan-tapaakari pankotsiki. Ipokapaaki okaakiini mawityaakiri, ari isampitakiri Jesús, ikantziri: “¿Tima pawintaakana awiroka aritaki nomatakiro pinintziri?” Ikantajiitzi irirori: “Jii, ari pimatakiro Nowinkathariti.” ");
INSERT INTO prq_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Akotanaki Jesús, itzinkakiri kapichiini irokiki, ikantziri: “Isita-kota-kaajimi pawintaana.” ");
INSERT INTO prq_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Apatha-kiro yaminanaji kamiitha. Isintsi-thawita-waari, ikantziri: “Airo pikamanta-kotana nisita-kota-kaajimi.” ");
INSERT INTO prq_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Iro kantacha jaitijiitanaki yokapayi ikamantantanaki, ithonka ikimakoi-tanakiri Jesús anta. ");
INSERT INTO prq_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Ikanta yamaita-paakiniri Jesús yaayiri piyari, kisowaanti ikantaka. ");
INSERT INTO prq_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Tima yisita-kota-kaawakiri Jesús yoka atziri, ñaawaitanaji, imisitowainiri iwiyariti. Okiryaantzi ikantanaka atziri-payi, ikanta-siri-jiitzi: “Tira añaapiintiri ashininka-payi imatiro kimityaaroni yantakiri yoka.” ");
INSERT INTO prq_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Iriima Nasitantaniri-payi, ikantajiitzi irirori: “Ipajiinkatyaari ijiwariti piyari yisita-kota-kaantariri yayiri.” ");
INSERT INTO prq_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Tima ithonka yaniitakiro Jesús maaroni nampitsi, iyomitaan-tayitaki tsika yapatota-piintaita. Ikinkithata-piintakiro Kamiithari Ñaantsi, tsika okanta ipinkathari-wintantai. Yisita-kota-kaayitakiri maaroni, tikatsi aparoni mantsiyarintsi pomirintsitzi-motyaarini. ");
INSERT INTO prq_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Ikanta iñaakiri Jesús oshiki apatowinta-kariri, antaro itako-sirita-nakari, ikantanaki: “Omapiro yasinonkaayita yoka atziri-payi. Ikimitakari ipiraitari airorika itzimi aamaako-wintyaarini.” ");
INSERT INTO prq_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Aikiro ikantana-kitziiri iyomitaani-payi: “Isiyakaro yokapayi atziri osampai-nkatzi pankirintsi, titzimaita intzima-piroti atziri koyaajironi. ");
INSERT INTO prq_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Pamanairi awirokaiti Awinkathariti, intyaankiita oshiki jatasitirini atziri-payi, tima tzimatsi oshiki kimisantaa-tsini.” ");
INSERT INTO prq_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Ipoñaa iyoyaaki Jesús 12 iyomitaani, ipajiinkakiri isintsinka. Imatanakiro irirori yisita-kota-kaayitziri maaroni kantasi-waita-chari imantsiyari aajatzi ikaratzi ikyaantasiritari piyari. ");
INSERT INTO prq_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Yoka ikaratzi 12 iyoyaakiri Jesús, iriiyitaki ipaitakiri Tyaantaariiti: Itanakarori Simón, ipaitakiri Pedro. Ipoñaapaaka Andrés, iririntzi Pedro. Ipoñaapaaka Jacobo itomi Zebedeo itsipatakari Juan iririntzi. ");
INSERT INTO prq_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Ipoñaapaaka Felipe, Bartolomé, Tomás, Mateo sintsiwintan-tawita-chari yamaitiniri kiriiki, ipoñaapaaka Jacobo itomi Alfeo, Tadeo, ");
INSERT INTO prq_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","ipoñaapaaka Simón, ipaitai-tziri aajatzi Kisakotan-taniri. Ipoñaapaaka owiraanta-paakarori Judas Nampitsiwiri, iriitakira pithoka-sita-kariri Jesús. ");
INSERT INTO prq_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Ipoñaa ityaankakiri Jesús karatatsiri 12, iyomitaa-yitawakiri, ikantziri: “Airo pikini isaiki pasini-satzi atziri, airo pikinanaki aajatzi inampiki Ositikii-toni-satzi. ");
INSERT INTO prq_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Apatziro pinkina-yitanaki inampiki Israel-iiti, osiyakariri ipiraitari ipyaawitaka. ");
INSERT INTO prq_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Aririka pijatanaki, iroka pinkanti pikamantanti: ‘Irootaintsi impinkathari-wintantaji Inkiti-satzi aka.’ ");
INSERT INTO prq_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Pisita-kota-kaayitajiri mantsiyari, pañaakaa-yitairi kamatsiri, pisita-kota-kaajiri pathaa-waita-tsiri, aajatzi ikyaantasiritari piyari. Tima Pawa nisironkataami awirokaiti, ti ininta-kotimi. Irootaki pimatanajiri awiroka airo pikowa-kotantzi, pinisironkatan-tajyaa. ");
INSERT INTO prq_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Airo paanaki nasiyita-chari piiriikiti, ");
INSERT INTO prq_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","aajatzi piyaari awotsiki. Airo paanaki pasini pithaari, aajatzi pasini pinkyaan-tyaari piitziki, pikotzikiiri. Tikatsi pasini paanakiri. Tima inkantaiti: Ipaitziri antawaita-tsiri iwariti. ");
INSERT INTO prq_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Aririka pariitakyaa nampitsiki, paminapaaki aakamiithata-wakimini, iriitaki pisaiki-mota-paaki, irojatzi pawisan-takyaari pasiniki nampitsi. ");
INSERT INTO prq_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Aririka pariitakyaa pankotsiki, piwithatan-tapaakyaa. ");
INSERT INTO prq_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Aririka yaakamiithata-wakimi piwithata-paakari, aritaki isaikaji kamiitha. Airorika yaakamiithata-wakimi, aminaa-sitaka piwitha-witapaakari. ");
INSERT INTO prq_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Airorika yaakamiithatzimi, airorika ikimisantzimi aajatzi, pawisa-pithatiri, pintika-najiro pipatsi-kitziti. ");
INSERT INTO prq_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Iriitaki imapiroiti apaata aririka yaminakoi-tairi maaroni yantayitakiri. Aritaki anaanakiro ikantai-takiri pairani Paamaarini-satzi aajatzi Katsimaarini-satzi. Omapiro.” ");
INSERT INTO prq_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Notyaan-tzimira iroñaaka, pikimitakari ityaantai-tziri ipiraitari tsika ipiyota owantaniri. Iro kantacha, ontzimatyii pisiya-kotyaari awiroka-payi kokintzi maranki, pisiya-kotyaari aajatzi siro itsinampa-siri-waitzi. ");
INSERT INTO prq_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Paamaiyaa. Tima yaitatyiimi jiwariki, impasawaitaitimi tsika yapatota-piintaita. ");
INSERT INTO prq_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Ompoña yaitanakimi isaiki pinkathari-piroriki okantakaan-tziro pawintaajana. Ari pinkinkithata-koyita-jinari anta, inkimayitaji aajatzi pasini-satzi atziri-payi. ");
INSERT INTO prq_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Aririka piñaakiro yaitanakimi, airo pikanta-siri-waitzi: ‘¿Opaitama noñaawaita-paakiri?’ Tima tzimatsi iyosirita-kayi-mironi opaita piñaawaitiri. ");
INSERT INTO prq_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Airo piyota-sitaro awiroka ompaityaa piñaawaitiri, iriitakira Tasorinkantsi poñaachari Asitamiriki yotakayi-mironi onkarati piñaawaitiri. ");
INSERT INTO prq_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Aritaki iñiitaki aakaantirini iririntzi iwa-kaantiri. Aakaantirini itomi. Tzimatsi owa-kaantirini asitariri ikisaniinta-nakiri. ");
INSERT INTO prq_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Oshiki kisaniintimini okantakaaro pikimisantaana. Iro kantacha, ikaratzi oijatanari yawintaajana, iriitaki awisakotaa-tsini. ");
INSERT INTO prq_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Aririka inkisaniintai-tanakimi anta, pawisa-pithatiri. Tima tikira pinthotyiiro pijayiti inampiki Israel-iiti, piyapaaka yoka Itomi Atziri. Omapiro. ");
INSERT INTO prq_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Tira iñiiti aparoni iyomitaai-tziri yanairi yomitairiri. Tira iñiiti aajatzi aparoni ompirataari yanairi ompiratariri impinka-thaitiri. ");
INSERT INTO prq_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Apatziro añiiri aparoni iyomitaai-tziri inkimita-jyaari yomitairiri pairani. Ari ikantari aajatzi ompirataari. Tima oshiki ikisaniintai-takina iroñaaka naaka, ikimita-kaitakina naakami Nantatsiri. Awiroka imapiroiti inkisaniintaitimi pikimisantaana.” ");
INSERT INTO prq_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Airo pitharowan-tawaitari yokapayi, tima ontzimatyii onkoñaata-koyitai okaratzi manakowitain-chari, oiñaarontairo kaari ikimatha-witaita pairani. ");
INSERT INTO prq_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Tzimatsi-rika nonkaman-timiri tsitiniriki, pikamantantairo awiroka kitaipaiti. Tzimatsi-rika nonkinkithata-kayimiri awirokaiti nomananikiini, pinkaman-tairi awiroka maaroni atziri. ");
INSERT INTO prq_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Airo pitharowan-tawaitari nintatsini iwimi, tima airo imatziro yooka-siritimi irirori sarinka-winiki. Apatziro pintharowan-tyaari Pawa matzirori yapirotantzi, yooka-siritantzi sarinka-winiki. ");
INSERT INTO prq_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Tima ti impina-piro-wityaa tsimiri-payi, iro kantacha iyotzi Pawa aririka inkamakaranti aparoni. ");
INSERT INTO prq_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Tima iyotzityaaro Pawa tsika okaratzi tzimatsiri aisi. ");
INSERT INTO prq_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Piñaakiro, tima yaamaa-kotyaari Pawa tsimiri-payi, awiroka imapirotzi yaamaako-wintami. Airo pitharowan-tawaitari kisaniintzimiri. ");
INSERT INTO prq_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Aririka pinkantiri pishininka: ‘Nopinkathatajiri Jesús,’ aritaki nonkantajiri Asitanari Inkiti-satzi: ‘Apaá, ipinkathataana yoka.’ ");
INSERT INTO prq_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Irooma pinkantiri-rika pishininka: ‘Ti nompinkathatiri Jesús,’ aritaki nonkantzi-tyaari naaka, nonkantajiri Asitanari: ‘Apaá, ti impinkathatina yoka.’ ” ");
INSERT INTO prq_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Airo pikinkithasiri-waita awirokaiti, ti apatziro nopoki noyomitaa-yitajiri atziri-payi yaakamiithata-wakaiyaa aka kipatsiki, okimiwaitakaro namatyiimi wisa-mintotsi imaimanita-wakaan-taityaari. ");
INSERT INTO prq_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","iroka nopokan-takari: Inkisaniintajiri atziri iriri, Onkisaniintajiro kooya iniro, Onkisaniintajiro kooya ayiro. ");
INSERT INTO prq_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Impithoka-sita-wakaiyaa atziri-payi inkisaniinta-wakajyaa ikaratzi isaikajiitzi iwankoki. ");
INSERT INTO prq_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Irootaki kamiitha-witacha pintakotyaari piri, piniro, pintsiti-payi. Iro kantacha, iroorika paakowinta-nakyaa pintakotyaari pishininka-payi, anaanakiro-rika okaratzi pitakotana naaka, airo nokimita-kaami naapatyaani. ");
INSERT INTO prq_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Airorika patsipita-kowintaana pinkimisantajina awiroka, pinkimita-kaantairomi ipaikakoi-tatyiimimi, tira pinkamiithati nasitajyaami naaka. ");
INSERT INTO prq_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Tima inkarati itakowaita-chari apaniroini irootaki yantantarori inintasi-waitari irirori, aritaki impyaa-sitajyaa. Iriima ikaratzi atsipiwintarori yantanajiro nonintziri naaka irootaki ikamawintan-takanari, aritaki yawisako-siritai.” ");
INSERT INTO prq_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Tzimatsi-rika aapatyii-yaamini, naaka yaapatyaaka. Ari okantari aajatzi, tzimatsi-rika aapatyii-yaanani naaka, iriitaki yaapatyaaka Asitanari otyaanka-kinari aka. ");
INSERT INTO prq_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Tzimatsi-rika yotimini Kamantan-tzinkari pinatzii irootaki yaapatyaan-tamiri, aritaki pinkaratairi apaata impinatajimi Pawa. Ari okanta aajatzi, tzimatsi-rika yotakimini kamiithasiriri pikanta pikimisantai irootaki yaakamiithatan-tamiri, aritaki pintsipatyari apaata impinataimi Pawa. ");
INSERT INTO prq_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Aririka iyoitimi awiroka noyomitaani, irootaki ipantai-tamiri piriri okantawitaka ti piriipiro-wityaa awiroka, aritakira impinai-tajiri apaata yoka itakota-kamiri. Omapiro.” ");
INSERT INTO prq_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Ikaratakiro Jesús iyomitaakiri 12 iyomitaani. Awisanaki ikamantanti maaroni nampitsiki okaratzi tzimatsiri anta. ");
INSERT INTO prq_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Tima yasitakoi-takiri irirori Juan kiwaatan-tsiri, ari ikima-kotakiri Saipatzii-totaari okaratzi yantayitakiri. Ityaankaki apiti iyomitaani, ");
INSERT INTO prq_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","isampitiri, inkantiri: “¿Awirokama ipaitai-tziri, ‘Pokatsini?’ Kaari-rika awiroka, ¿Tzimatsima pasini noyaa-kotiri?” ");
INSERT INTO prq_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Ikanta yariijiitaka, isampita-paakiri Jesús. Ari yakanaki irirori, ikantzi: “Aririka pimpiyanaji, pinkaman-tapajiri Juan okaratzi pikimakiri awiroka, okaratzi piñaakiri nantayitakiri. ");
INSERT INTO prq_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Tima naminakaa-yitajiri mawityaakiri, naniita-kaayitajiri kisoporokiri, nisita-kota-kaayitairi pathaa-waita-tsiri, nokimakaa-yitajiri atsikimpityari, nañaakaa-yitajiri kaminkari, nokinkithata-kota-jiniri Kamiithari Ñaantsi asinonkainkari-payi. ");
INSERT INTO prq_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Kimosiri inkantajyaa inkarati kaari kisosiri-wintainani.” ");
INSERT INTO prq_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Ikanta ipiyaaro iyomitaani Juan, isampita-nakiri Jesús ikaratzi piyowinta-kariri, ikinkithata-kotziri Juan, ikantzi: “¿Paitama piñaakiri chapinki otzisi-masiki? ¿Iriima piñaaki kimitarori saworo opiyonka-tonkita-kaaro tampyaa? ");
INSERT INTO prq_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","¿Piñaakirima iwaniinkata ikithaata? Ti. Tima inkarati waniinkata-chari ikithaata, isaika-pankotziri pinkathari. ");
INSERT INTO prq_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Irootaki pijata-sitan-tariri piyotzi Kamantan-tzinkari inatzii. Tima imapirota-tziiro irirori yanaanakiri pasini Kamantan-tzinkari-payi. ");
INSERT INTO prq_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Tima iriitaki isankinata-koitakiri pairani, ikantaitaki: Pamini, aritaki nontyaantaki ityaaroni inkamanta-kotimi, Iriitaki witsikaan-timini tsika pinkina-paaki. ");
INSERT INTO prq_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Pinkimi nokantzi naaka: Pairani oshiki atziri tzimawitain-chari, tikatsi anairini Juan Kiwaatan-tatsiri okaratzi iyota-nitakari. Iriima inkarati tsinampa-siritaa-tsini, impinkathari-wintairi Pawa inkitiki, aritaki yanaa-kotairi irirori Juan. Omapiro. ");
INSERT INTO prq_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Tima owakira yitanta-nakarori Juan ikinkithata-kaimi irojatzi iroñaaka, tzimatsi oshiki nintatsiri sintsiini iñiiro impinkathari-wintairi Inkiti-satzi. Osiyawaitakaro isintaitzi aririka iwayiritaityaa. ");
INSERT INTO prq_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Pairani tzimayitatsi Kamantan-tzinkari-payi aajatzi Ikantakaan-taitani, irootaki ikamantantai-takiri irojatzi itziman-takari Juan. ");
INSERT INTO prq_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Iriitakira Juan ikinkithata-koitakiri pairani, tima iriitaki Elías-tatsiri pokatsini. ¿Pikimisantziroma? ");
INSERT INTO prq_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Kowirori inkimathatiro, inkimisanti. ");
INSERT INTO prq_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","¿Ipaitama nosiyakaan-tiriri yokaiti atziri? Isiyakari washaantawai-rintzi iintsi aririka isiyakaa-waityaa owaankiirin-tsiki, ikaima-kota-wakaa-jiita, ");
INSERT INTO prq_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","ikanta-wakaa-jiita: ‘Thami ashowiriti amashaitan-tyaari.’ Ti ininti. Ikantawita: ‘Thami ampanthai awasiritan-tyaari.’ Ti ininti. ");
INSERT INTO prq_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Aritaki pikanta-jiitaka awirokaiti. Piñaawitakari Juan, itziwinta-paaka, ti imirityaaro kachori, pikanta-jiitakiri: ‘Ikyantasirityaari piyari, irootaki itziwaitantari.’ ");
INSERT INTO prq_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Ipokawitaka Itomi Atziri, ti intzityaaro irirori owaritintsi, iriro kachori. Pikanta-jiitakiri: ‘Kaari-pirori inatzii, niyawai-rintzi, sinki-ryaantzi. Yaapatyaari sintsiwintan-tatsiri yamaitiniri kiriiki, yaapatyaari aajatzi kaari-piro-siriri.’ Tikatsi ompaityaa, tima aririka iñiitairo onkarati awisatsini apaata, ari iyoitairi omapiro iyota-nita.” ");
INSERT INTO prq_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Ipoñaa ikinkithata-kota-nakiri Jesús ikaratzi ñaawita-karori itasonka-wintantzi nampitsiki, titzimaita iwashaantiro ikaaripiro-siri-jiitzi. Ikantzi: ");
INSERT INTO prq_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Ikanta-machiitzimi Simapankoni-satzi aajatzi nampitarori Corazín. Oshiki piñaawitakaro notasonka-wintantaki, titzimaita pinkimisanta-jiiti. Iriimi ñaakinani Mapini-satzi aajatzi Simaa-satzi, aritaki inkithaata-nakyaaromi mirimasita-tsiri kithaarintsi, saikawaita-nakimi samanpoki iwasirita-kotyaa ikaaripiro-siri-yitaki, inkimisantajimi maaroni iriroriiti. ");
INSERT INTO prq_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Awirokataki imapiroiti iwasankitaitiri apaata aririka yaminakoi-tairi maaroni yantayitakiri. Aritaki anaanakiro ikantai-takiri pairani Mapini-satzi aajatzi Simaa-satzi. ");
INSERT INTO prq_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Aajatzi awirokaiti nampitarori Capernaum, pikinkithasiriwita pijatai inkitiki, apatziro pijamatsitaji tsika ikinayitzi kaminkari. Iriimi ñaakinani pairani Paamaarini-satzi okaratzi piñaawitakari awirokaiti, irojatzi osaikimi inampiiti. ");
INSERT INTO prq_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Awirokataki imapiroiti iwasankitaitimi apaata aririka yaminakoi-tairi maaroni yantayitai-takiri. Aritaki anaanakiro ikantai-takiri pairani Paamaarini-satzi aajatzi Katsimaarini-satzi.” ");
INSERT INTO prq_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Irootaki yamananta-nakari Jesús, ikantzi: “Apaá, tima awiroka pinkathari-wintziriri inkiti-satzi aajatzi kipatsi-satzi, oshiki notharowintakami. Tima awiroka omani-motakiri yotaniriiti iroka-payi, iriitaki piyotakaa-yitai osiyariri iintsi itsinampa-siritzi. ");
INSERT INTO prq_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ari okanta, tima irootaki onimota-kimiri awiroka Asitanarí.” ");
INSERT INTO prq_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Ikantanakiri piyowinta-kariri: “Iriitaki Asitanari oyotakaa-narori maaroni. Apatziro iyotana irirori, tima Itomi iwana. Ari nokimitari naaka apatziro noyotziri Asitanari, kantacha noyotakaa-yitajiri nonintziri naaka iyotajiri. ");
INSERT INTO prq_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Aririka piñiiro onkantzimo-siri-waityaami, ompomirintsitzi-mowaityaami, pimpoki nosaiki naaka, aritaki nomakoryaa-sirita-kaayitaimi. ");
INSERT INTO prq_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Okimiwaitakaro ontzimi-rika opaita nonkima-tinata-kaiyaamiri. Tima tzimatsi nonintziri noyomitaimiri: tima naaka tsinampa-siri. Aritaki piñaajiro nomakoryaa-sirita-kaajimi. ");
INSERT INTO prq_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Tima okaratzi nokima-tinata-kaamiri naaka, ti ompomirintsi-pirotyaa.” ");
INSERT INTO prq_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Okanta kitaitiriki imakoryaan-taitari, ikini-mota-nakiro Jesús pankirintsi-masi. Ari isapiryanaki okithoki pankirintsi iyomitaani Jesús, tima intashaa-jiitatzii. ");
INSERT INTO prq_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Iñaakiri Nasitantaniri, ikantanakiri Jesús: “Paminiri piyomitaani isapirya-kiwaitatzii kitaitiriki imakoryaan-taitari, tima ti osinitaa-ntsiti isapirya-waitaiti.” ");
INSERT INTO prq_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Akanaki Jesús ikantziri: “Tima piñaanata-kotiri pinkatharini David aantawita-kariri itashi itsipatari ikarajiitzini. ");
INSERT INTO prq_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Ikyaaki tasorintsi-pankoki, iwakaro tasorin-tsita-tsiri owaritintsi, ipakiri ikarajiitzi. Ti osinitaan-tsiwityaa, apatziro iwapiintaro Ompira-tasorintsitaari. ");
INSERT INTO prq_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Tima piñaanatiro Ikantakaan-taitsiri, tima yantawaita-piinti Ompira-tasorintsitaari kitaitiri imakoryaan-tairi tasorintsi-pankoki, tikatsi kisantyaarini. ");
INSERT INTO prq_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Nokantzi naaka, tzimatsi aka ipinkatha-piroi-tziri, iriitaki anairori tasorintsi-panko. ");
INSERT INTO prq_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Irootaki isankinata-koitakiri pairani, ikantaitzi: Ti noninti pamajina pipira pintaajinari, Irootaki noninta-pirotajiri pintakota-jyaari pishininka. Aririka pikimathatiromi iroka, airo pikisan-tarimi yokapayi, tima ti inkaaripiro-siriti. ");
INSERT INTO prq_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Tima yoka Itomi Atziri pinkathari-pirori inatzii, yanairo kitaitiri imakoryaan-taitari.” ");
INSERT INTO prq_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Ipoñaa yawisanaki Jesús, kyaapaaki yapatota-piintaita. ");
INSERT INTO prq_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Ari isaikakiri anta kisowakori. Ikanta Nasitantaniri-payi, isampitakiri Jesús, ikantziri: “¿Sinitaa-ntsita-tsima yisita-kota-kaantaiti kitaitiri imakoryaan-taitari?” Irootaki isampitan-tariri okantantyaari inkanta-kotiri. ");
INSERT INTO prq_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Yakanaki Jesús, ikantziri: “Tira pamina-sityaari awiroka pipira aririka intityaa omoro-naki kitaitiri imakoryaan-taitari, pitakotari, pinosikiri. ");
INSERT INTO prq_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Iriitaki itako-piroitari atziri, yanairi ipiraitari. Tima sinitaa-ntsitatsi anisironkatantyaa kitaitiri imakoryaan-taitari.” ");
INSERT INTO prq_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Iñaanata-nakiri kisowakori, ikantziri: “Pintharyaawakotai.” Kantanaka ikantakiri, akotanaji kamiitha atziri, okimita-naaro pasini irako. ");
INSERT INTO prq_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Ari isitowa-jiitanaki Nasitantaniri yapatojiitaka, ikinkitha-tawakaa-jiitakani, ikanta-wakaa-jiita: “¿Tsikama ankanti-rika Jesús ampyaakaan-tyaariri?” ");
INSERT INTO prq_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Yotaki Jesús ikowaitatzii iwaitiri, irootaki yawisan-tanakari. Iyaatanakiri oshiki atziri, yisita-kota-kaayitaki oshiki mantsiyari. ");
INSERT INTO prq_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Isintsi-thawitakari ikantziri: “Airo pikamanta-kotana.” ");
INSERT INTO prq_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Ari omonkaratari ikinkithatakiri pairani Kamantan-tzinkari Isaías, ikantzi: ");
INSERT INTO prq_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Yoka nompiratani, iriitaki noyoyaakiri. Notakotani inatzii, iriitaki oimosirinkanari. Oisokiro iwiro Notasorinka, Ikinkithata-kaajiri pasini-satziiti atziri ikamantairi tampatzika-siritan-tatsiri. ");
INSERT INTO prq_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Airo ikaima-waitzi irirori, Airo ikimaitziri isinchii-nkawaiti inkinkithata-kotyaa owaankiirin-tsiki-payi. ");
INSERT INTO prq_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Airo iwatsi-piroitziro isatairo sonkari sataawita-chari, Airo iitsiwakiro paamari-minki tsiwaki-matain-tsiri, Irojatzi imatanta-jyaarori yitsinampairi iñiitairo iroopirori. ");
INSERT INTO prq_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Iriitaki iyaakoniintairi pasini-satziiti atziri. ");
INSERT INTO prq_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Ari yamaita-kiniri Jesús yaakiri piyari. Tima mawityaaki ikantakaakari, ikiso-waantita-kaakiri. Imatawajiri yisita-kota-kaawajiri, aminanaji kamiitha, ñaawaitanaji. ");
INSERT INTO prq_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Okiryaantzi ikantanaka maaroni atziri, ikantajiitzi: “¿Iriima yoka ikasiya-kaita-kiriri pinkatharini David?” ");
INSERT INTO prq_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Kimajiitaki irirori Nasitantaniri, ikantajiitzi: “Yoka atziri isintsitakaa-tziiri Nantatsiri, irootaki yisita-kota-kaantariri ikaratzi yaakiri piyari.” ");
INSERT INTO prq_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Yotzimaitaka irirori Jesús ikinkithasiritakari Nasitantaniri, ikantanakiri: “Aririka imaimanita-wakaiyaa atziri tsika ipinkathari-wintai-tziri, aritaki yooka-wakaanakyaa. Aririka imaimanita-wakaiyaa atziri inampiki, aritaki yooka-wakaanakyaa. Aririka imaimanita-wakaiyaa atziri tsika isaika-wankota-wakaa, aritaki yooka-wakaanakyaa. ");
INSERT INTO prq_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ari ikantzitari aajatzi piyari aririka imaimanita-wakai-yaami. Aritaki yooka-wakaanakyaa, ¿airoma ithonka yooka-wakaanakyaa? ");
INSERT INTO prq_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Iriirikami Kamaari Nantatsiri osintsitakainari naaka, ¿irijatzima sintsitakairiri piyomitaani awiroka yisita-kota-kaantariri ikaratzi yaakayitziri? Aririka okanta pikamanta-kota-tziiri piyomitaani, aritaki inkisan-takyaamiro okaratzi pikantakiri. ");
INSERT INTO prq_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Irooma naaka ipanaro isintsinka Tasorinkantsi poñaachari Pawaki, irootaki nomatan-tariri nisita-kota-kaayitziri ikaratzi yaakiri piyari. Tima imapokakimi awiroka-payi Pawa ipinkathari-wintantai. ");
INSERT INTO prq_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Tima aririka inintaiti inkositaitiri atziri sintsita-tsiri kamiitha, ontzimatyii yitaita-wakyaari yoosotaitiri, airo ikantanaja inkisako-wintyaaro yasiyiwitari yayitaitiri. ");
INSERT INTO prq_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Tima inkarati kaari aapatyaanari naaka, iriitaki kisaniintanari. Ikaratzi kaari amitakotinari inkoyaa-kotina, yaparata-kota-tyaana. ");
INSERT INTO prq_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Pinkimi nokantzimiri naaka: Kantatsi Pawa yaripirotyaari antayitzirori kaari-pirori, ari inkimitairiri ñaawaitzirori kaari-pirori-payi. Iriima kisimata-kirini Tasorinkantsi, airo yaripiroi-taari. ");
INSERT INTO prq_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Ari okantari aajatzi: Kantatsi yaripirotyaari Pawa kisimatirini Itomi Atziri, iriima kisimata-kirini Tasorinkantsi, airo yaripirotaari. ");
INSERT INTO prq_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Tima osiyawaitakaro aririka iñiitiro kamiithari chochoki, iyotaitzi kamiitha okanta owaato. Irooma piyanta-tsiri chochoki, iyotaitzi kaari-pirori onatzii owaato. ");
INSERT INTO prq_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Tima pisiyakari maranki awirokaiti, kaari-piro-siri pikanta-jiitaka. Tikatsi pinkantyaa piñaawaitiro kamiithari, ti onkamiithati okaratzi pikinkithasiri-yitari, irootaki okaaripirotantari piñaawai-yitziri. ");
INSERT INTO prq_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Tima aparoni kamiithasiriri ikinkithasiritaro kamiithari, irootaki okamiithatantari yantayitziri. Iriima kaari-piro-siriri ti inkinkithasirityaaro kamiithari, irootaki okaaripirotantari yantayitziri. ");
INSERT INTO prq_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Iro kantacha nokantantari naaka, apaata aritaki yaminakoi-tairo kowiinka-yitatsiri ñaantsi okaratzi iñaawai-yitziri atziri-payi. ");
INSERT INTO prq_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Kamiitha-rika okanta piñaawai-yitziri, aritaki yaakamiithai-tajimi. Tirika onkamiithati, inkantai-taimi: ‘Kaari-pirori pinatzii, oshiki pinkimaatsi-waitajyaa.’ ” ");
INSERT INTO prq_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Ari yakanaki Nasitantaniri aajatzi Yomitaan-taniri, ikantzi: “¡Yomitaanarí! Nonintzi noñaajimi pintasonka-wintanti.” ");
INSERT INTO prq_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Ikantzi Jesús: “Tima kaari-piro-siriri pinajiitzi awiroka, oshiki pithainkakiri Pawa pinintzira piñiina nontasonka-wintanti. Airotzimaita nomatziro, apatziro piñiiro awishi-mota-kiriri pairani Kamantan-tzinkari Jonás. ");
INSERT INTO prq_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Tima iniyakiri antari kyaatsi, okaratzi mawa kitaitiri aajatzi mawa tsitiniri isaikaki imotyaaki. Aritaki inkanta-jyaari yoka Itomi Atziri inkitawita-paintyaa kipatsiki onkarati mawa kitaitiri aajatzi mawa tsitiniri. ");
INSERT INTO prq_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Apaata aririka yaminakoi-tajiro okaratzi yantaitziri, aritaki imishakowintaimi Inawini-satzi, tima ikimisantakiri pairani irirori Jonás, iwashaanta-najiro yantayitziro kaari-pirori. Tima yoka saiki-mota-kimiri awiroka-payi yanairi Jonás. ");
INSERT INTO prq_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Apaata aririka yaminakoi-tajiro okaratzi yantaitziri, aritaki omishakowintaimi kooya pinkatha-rotatsiri pairani kirinkanta, tima opokaki pairani iroori isaiki yotaniri pinkathari Salomón, okimisantakiri. Tima yoka saiki-mota-kimiri awiroka yanairi Salomón.” ");
INSERT INTO prq_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Tima osiyawaitakaro isaika-siritan-tyaarimi piyari aparoni atziri, iwankotsi-titakaro yañaa-minto. Aririka yookawitai-takyaari, isitako-witaja atziri. Jatanaki piyari inkinawaiti otzisi-masiki, ti iñii tsika isaiki. ");
INSERT INTO prq_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Ari inkanta-siritai piyari: ‘Nompiyaji nowankoki tsika nopoñaaka.’ Piyaaja piyari, iñaapaa-tziiro kamiitha opisitaka isiri atziri, owaniinka okantaka, tikatsi saikantyaaroni. ");
INSERT INTO prq_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Ijata-sita-nakiri mapirotzirori ipiyaritzi, ikantakiri: ‘Thami ajati nowankoki, pintsipatyaana ampinkathariti.’ Yamaki ikaratzi 7 piyari. Aritaki yasinonkaa-pirotyaari atziri, anaanakiro yasinonkaawita pairani. Aritaki pinkanta-jyaari awirokaiti.” ");
INSERT INTO prq_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Aikiro ikinkithata-kaatziiri Jesús atziri-payi piyowinta-kariri, ariitapaaka iriniro otsipatakari iririntzi-payi, okatziya-paaka intakiroki, okaimakaan-tapaakiri. ");
INSERT INTO prq_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Ikantawitai-takari Jesús: “Ari opoki piniro otsipatari pirintzi-payi, onintzi oñiimi.” ");
INSERT INTO prq_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Yakanaki Jesús, ikantzi: “¿Otzimikama nonirotari, itzimi nirintzitari?” ");
INSERT INTO prq_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Yookota-nakiri ikaratzi iyomitaa-piintakiri, ikantzi: “Yokaiti, iriitaki nokimita-kaajari nirintzi, irojatzi nokimita-kaajari noniro. ");
INSERT INTO prq_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Tima inkarati antanajirori inintziri Asitanari Inkiti-satzi, iriitaki nirintzitaari, irootaki notsirotaari aajatzi noniron-taari.” ");
INSERT INTO prq_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Ipoñaa yawisanaki Jesús isaikawita-paaka pankotsiki, ikinanaki inkaari-thapyaaki. Ari isaikapaaki. ");
INSERT INTO prq_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Ari ipiyowinta-paari oshiki atziri. Ari ititanta-nakari irirori pitotsiki, saikapaaki. Katziya-jiitaka atziri-payi inkaari-thapyaaki. ");
INSERT INTO prq_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Isiyakaa-winta-tziiniri okaratzi ikinkithata-kairiri, ikantziri: “Tzimatsi pankiwai-rintzi jatatsiri impanki-waiti. ");
INSERT INTO prq_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Ikanta yookaikitakiro iwankiri, tzimatsi ooka-painchari awotsiki, ipokapaaki tsimiri, iwapaakaro. ");
INSERT INTO prq_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Tzimatsi pasini ookaikita-painchari omapi-poro-kitzi ti ontzima-piroti kipatsi, sintsiini oshooka-witanaka. Ti ontonta-pathatatyii kipatsi, ");
INSERT INTO prq_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","sampiya-sitanaki pankirintsi isintsita-paaki ooryaatsiri, tima ti ontzima-piroti oparitha. ");
INSERT INTO prq_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Tzimatsi pasini ookaikita-painchari kitoochii-masiki, anaanakiro kitoochii oshookanaki, kamanaki pankirintsi. ");
INSERT INTO prq_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Irooma pasini ookaikita-painchari okamiitha-pathatzi kipatsi, saankana oshookanaki, kithotanaki maaroni. Tzimanaji okithoki shookapain-tsiri. Aparoni otzima-pirotatzii okithoki, pasini oshikiniintzi okithoki, pasini kapichiini okitho-kitzi. ");
INSERT INTO prq_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Kowirori inkimathatiro, inkimisanti.” ");
INSERT INTO prq_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Ari isampita-nakiri iyomitaani, ikantziri: “¿Paitama pisiyakaa-wintan-taniriri atziri-payi pikinkithata-kairi?” ");
INSERT INTO prq_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Yakanaki Jesús, ikantzi: “Isinitai-takimiro awiroka piyota-kotairo ipinkathari-wintantai Inkiti-satzi, iriima yokaiti ti isinitai-tanitiri irirori. ");
INSERT INTO prq_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Ikaratzi otzimi-motakiri, aritaki ontzimimo-pirotairi. Iriima kaari otzimi-motzi, imapiroi-tairi yaapithai-tajiri okaratzi tzimimo-witariri. ");
INSERT INTO prq_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Irootaki nosiyakaa-wintan-tarori okaratzi nokinkithatziri, aririka yaminawityaa yokaiti, airo iñaamaitaro. Ari inkimawityaaro, airo ikimathata-wakiro nokanta-witariri. ");
INSERT INTO prq_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Iriitaki ikinkithata-kotaki pairani Kamantan-tzinkarini Isaías, ikantaki: Pinkima-jiiwityaa, airotzimaita pikimathatziro. Paminaa-jiiwityaa, airotzimaita piñiiro. ");
INSERT INTO prq_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Kisosiri ikanta yokaiti. Atsikimpitya ikantajiitaka. Mawityaaki-yitaki. Irootaki airo yokichaa-tanta, Airo ikimi, Airo ikimatha-tantaro, Tima airo ikimisantai, airo nowawisaakotajiri aajatzi. ");
INSERT INTO prq_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Irooma awirokaiti pinkimo-siri-wintairo poki aajatzi piyimpita, tima piñaayitajiro, pikimayitairo aajatzi. ");
INSERT INTO prq_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Irootaki inintawitakari pairani Kamantan-tzinkari-payi aajatzi kamiithasiriri-payi iñiiromi okaratzi piñaakiri, okaratzi pikimayitairi awirokaiti. Titzimaita inkimajiitiro. Omapiro.” ");
INSERT INTO prq_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Pinkimi nonkaman-timiro nosiyakaa-wintakiri pankiwai-rintzi. ");
INSERT INTO prq_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Tzimatsi kimirori nokinkithata-kotziro ipinkathari-wintantai Pawa, titzimaita inkimathatiro. Aritaki pokaki Kaari-pirori, iwashaanta-kaapaakiri ikimisantawita. Iriitaki kimitakarori ookaikita-painchari awotsiki. ");
INSERT INTO prq_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Tzimatsi nintawitarori ñaantsi, ikimisantzi sintsiini owakira ikimawakiro. Iriitaki kimitakarori ookaikita-painchari omapi-poro-kitzi. ");
INSERT INTO prq_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Ti iyotako-pirota-tyiiro ñaantsi, ti inkisa-sityaaro ikimaatsi-winta-nakaro ikimisantzi, iwashaanta-nakiro. Isiyakaro pankirintsi sampisitain-tsiri kaari tzima-pirota-tsini oparitha. ");
INSERT INTO prq_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Tzimatsi kimirori ñaantsi, iro kantacha oshiki iniwitaro yoimosirinkawaitya, ikinkithasirita-kotaro iwaararo, irootaki ipyaakotan-takarori ñaantsi, ti inkimisanti. Ikimitakaro ookaikita-painchari kitoochii-masiki, kaari kithota-tsini. ");
INSERT INTO prq_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Tzimatsi pasini kimirori ñaantsi, ikimisanta-nakiro. Yiriipiro-winta-nakiro. Iriitaki osiyakarori pankirintsi shookapain-tsiri okamiitha-pathatzi kipatsi, oshiki-pirotanaki okithoki, pasini amataja oshikiniintzi, pasini kapichiini okithotanaki.” ");
INSERT INTO prq_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yapiitakiro Jesús isiyakaa-wintziniri, ikantzi: “Iroka osiyari aajatzi ipinkathari-wintantai Inkiti-satzi, osiyari atziri pankitzirori kamiithakiri pankirintsi. ");
INSERT INTO prq_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Ikanta imaajiitzi tsitini-paiti aamaako-wintarori, pokaki ikisaniintani yamaki towarisi, ipankitakiro itsipataakiro pankirintsi, piyanaka. ");
INSERT INTO prq_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Okanta oshookanaki pankirintsi, kithokitanaki. Ari okimitakari aajatzi towarisi itsipatai-takirori pankirintsi. ");
INSERT INTO prq_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Ikanta iñaakiro impiratani, ikamantakiri asitarori, ikantakiri: ‘Tira onkanti okithoti pankirintsi apankitakiri piwaniki, ¿paitama tsipataa-kirori towarisi?’ ");
INSERT INTO prq_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Ikantanaki asitarori iwani: ‘Iriitaki pankita-kirori kisaniintanari.’ Ikantzi impiratani: ‘¿Pinintzima nojati nonthoka-yitajiro?’ ");
INSERT INTO prq_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Ikantzi asitarori: ‘Airo, kimitaka ari pinthoka-kotakiro pankirintsi. ");
INSERT INTO prq_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Ari onkakarati ontsipatyaaro oshooki, irojatzi osampatan-takyaari pankirintsi. Aripaiti nonkantimi: Pichikiro towarisi, pintayiro. Pawiikitairo pankirintsi, piwakoyitairo.’ ” ");
INSERT INTO prq_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Ari yapiitakiro Jesús isiyakaa-wintziro ikinkithatziri, ikantzi: “Iroka ikanta ipinkathari-wintantai Inkiti-satzi, ikimitakari pankitzirori yaninikita-tsiri okithoki. ");
INSERT INTO prq_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Tima yanini okantawita okithoki, aririka oshookanaki, anaanakiro pasini iwankiri iwaniki, antaro ochiwotanaki, aritaki imawosi-yityaari tsimiri-payi.” ");
INSERT INTO prq_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Yapiitakiro isiyakaa-wintziro Jesús ikinkithata-kaantziri, ikantzi: “Iroka ikanta ipinkathari-wintantai Inkiti-satzi, isiya-kotaro kooya amiroka-pathatzirori yatantaitari. Aakotakiro pankirintsi-pani okaratzi mawa matzitaki, okonowakiro siñakairori, irojatzi osiñanta-kyaari maaroni opatha.” ");
INSERT INTO prq_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Ari ikanta-piintatyaa Jesús ikinkithata-kairi atziri-payi okaratzi iyomitairiri. Airorika otzimi kinkitharintsi tikatsira iyomitairi. ");
INSERT INTO prq_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Ari omonkaratari ikantakiri pairani Kamantan-tzinkari ikinkithata-kotziri Pawa, ikantaki: Nosiyakaa-winta-tyiiniri atziri-payi onkarati nonkinkithati-niriri. Noyomitaajiri kaari iyowita pairani owakira owitsikan-takari kipatsi irojatzi iroñaaka. ");
INSERT INTO prq_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Ikanta iwithata-naari Jesús ikaratzi piyowinta-kariri, kyaapaaki pankotsiki. Ipiyowinta-paakari iyomitaani, ikantziri: “Piyomitainaro okaratzi pisiyakaa-wintakiri. ¿Paitama osiyakaa-wintari towarisi itsipatai-takirori pankirintsi ipankitai-tziro?” ");
INSERT INTO prq_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Ari yakanaki Jesús, ikantzi: “Yoka Itomi Atziri iriitaki osiyariri pankita-kirori pankirintsi iwaniki. ");
INSERT INTO prq_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Irooma owaantsi irootaki osiyarori kipatsi asaikantari. Irooma pankirintsi osiyakaa-wintari ikaratzi ipinkathari-wintairi Pawa. Irooma towarisi osiyakaa-wintari ikaratzi yasiyitari Kaari-pirori. ");
INSERT INTO prq_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Iriima kisaniintan-tsiri pankita-kirori towarisi isiyakaa-wintari Kamaari. Irooma ikoyaitairo okithoki pankirintsi, osiyakaa-wintaro onthonkajyaa apaata kipatsi. Ikaratzi koyaajirori okithoki pankirintsi isiyakaa-wintari Maninkariiti. ");
INSERT INTO prq_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Piñaakiro tsika ikantai-takiro ithokai-takiro towarisi, yaitanakiro itayiitziro. Osiyakaa-wintaro tsika inkantai-tajiro apaata kipatsi aririka onthonkajyaa. ");
INSERT INTO prq_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Intyaan-kairi Imaninkariti Itomi Atziri, yapatotairi kaaripiro-yitatsiri, aajatzi kaaripiro-sirita-kairiri pasini, airo itsipataari ikaratzi ipinkathari-wintairi Inkiti-satzi. ");
INSERT INTO prq_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Yookairi tsika opaamataki pomitaantsi. Ari iraawaitajyaa, yatsikai-kiwaityaa. ");
INSERT INTO prq_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Iriima kamiitha-siri-yitain-tsiri isaiki-motairi Asitariri tsika ipinkatha-ritzi, siparyaa inkantajyaa inkimita-jyaari ooryaatsiri. Kowirori inkimathatiro, inkimisanti.” ");
INSERT INTO prq_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Yapiitakiro Jesús, ikantzi: “Iroka ikanta ipinkathari-wintantai Inkiti-satzi, isiya-kotari kiriiki imanaitziri owaantsiki. Tzimatsi atziri ñaakiriri, ti onkanti yaanakiri, aajatzi imananajiri, tikatsi inkamanti. Antaro ikimo-siri-winta-nakiri kiriiki, jataki ipimantziro okaratzi tzimi-motziriri, yamanantakiro owaantsi.” ");
INSERT INTO prq_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Ikantzi aajatzi Jesús: “Iroka ikanta aajatzi ipinkathari-wintantai Inkiti-satzi, ikimitari nintatsiri yamananti iriipirori poriryaari. ");
INSERT INTO prq_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Iñaaki iriipirori poriryaari, inintaki yamanantiri. Piyaja inampiki, ipimanta-paakiro okaratzi tzimi-motziriri, yamanantakiri poriryaari.” ");
INSERT INTO prq_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Ikantaki aajatzi Jesús: “Iroka ikanta aajatzi ipinkathari-wintantai Inkiti-satzi, isiyari kithata-tsiri. Yaaki oshiki kantasiwaita-chari sima. ");
INSERT INTO prq_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Inosika-kotakiri othapyaaki, ikoyaakiri kamiithata-tsiri itiyitakiri kantziriki. Ikaratzi kaari kamiithata-tsini, yookayitakiri. ");
INSERT INTO prq_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Aritaki onkanta-jyaari apaata aririka onthonkajyaa kipatsi. Impokaki Maninkariiti, iyosiitairi kamiithasiriri aajatzi kaari-piro-siriri. ");
INSERT INTO prq_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Yookairi kaari-piro-siriri tsika opaamataki paamaripirori, ari iraawaita-jyaari, yatsikai-kiwaitajyaa.” ");
INSERT INTO prq_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Ari ikantzi Jesús: “¿Pikimathatakiro okaratzi nokantakiri?” Ikantajiitzi iyomitaani: “Nokimathatakiro.” ");
INSERT INTO prq_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Aikiro ikantana-kitzii Jesús: “Nosiyakaa-wintiri iriritaitari tzimatsiri iwaararo pinapirota-chari. Tima yaapiintzi paisatori iwaararo, yaapiintzi aajatzi owakirari. Ari inkantyaari aajatzi yomitaantani-payi ipinkathari-wintairi Inkiti-satzi, iyomitaan-tairo okaratzi itarori iyomitaan-taitziro pairani, iyomitaan-tairo aajatzi owakirata-tsiri.” ");
INSERT INTO prq_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Ikaratakiro Jesús isiyakaa-wintakiro okaratzi ikinkithata-kotakiri, awisanaki. ");
INSERT INTO prq_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Ariitaja inampiki. Iyomitaan-tapaji yapatota-piintaita. Okiryaantzi ikanta ikaratzi kimiriri, ikantajiitzi: “¿Paitama kantakaa-kiriri yoka iyota-nitantari, itasonka-wintantaki aajatzi? ");
INSERT INTO prq_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","¿Kaarima itomi oshironkirori incha-kota? ¿¿Kaarima otomi María? ¿Kaarima iririntzi Jacobo, José, Simón, aajatzi Judas? ");
INSERT INTO prq_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","¿Kaarima atsipatari iritsiro-payi aka? ¿Tsikama yaakiroka okaratzi iyota-nitakari?” ");
INSERT INTO prq_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Tima oshiki ithainkai-takiri, ikisaniintai-tanakiri. Irootaki ikantan-tanakari Jesús: “Asi owiro ti impinkathataitiri Kamantan-tzinkari inampiki aajatzi iwankoki irirori. Irooma pasiniki nampitsi, oshiki impinkathataitiri.” ");
INSERT INTO prq_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Tima oshiki ithainka-matai-takiri Jesús inampiki, irootaki kaari imatantaro intasonka-wintanti. ");
INSERT INTO prq_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Ikanta pinkathari Herodes, ikima-kotakiri Jesús. ");
INSERT INTO prq_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Ikantakiri impiratani: “Yoka Jesús iriitakira Juan Kiwaatan-taniri. Iriitaki añaatsi, irootaki otzimantari itasorinka.” ");
INSERT INTO prq_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Tima iriitaki Herodes aakaantzi-takariri chapinki-paiti Juan, yoosota-kaantakiri, iminkyaa-kaantakiri, okantakaan-tziro Herodías iinanta-witari Felipe, iririntzi irirori. ");
INSERT INTO prq_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Tima iyomitaa-witana-tyaari pairani Juan yoka Herodes, ikantawitari: “Ti onkamiithati payitiri iina pirintzi.” ");
INSERT INTO prq_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Ari inintawitaka Herodes iwa-kaantiri, iro kantacha oshiki itharowakaakari atziri-payi, tima iyojiitzi atziri-payi Kamantan-tzinkari inatzii Juan. ");
INSERT INTO prq_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Okanta apaata, irootaki kitaitiri yoimosirinka-witaro itzimantari Herodes. Ipiyojiitaka ishininka, yoimosirinka-jiita. Ari opokapaaki osinto Herodías, owisiryaa-paaka. Oshiki okamiithatzi-motakiri Herodes. ");
INSERT INTO prq_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Ikantanakiro: “Tzimatsi-rika pinkampitinari, aritaki nompakimiro. Omapiro, iyotzi Pawa airo namatawitzimi.” ");
INSERT INTO prq_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Tima oyomitaakiro iniro tsika onkanti. Irootaki okantan-takariri: “Nonintziro pimpinaro iito Juan Kiwaatan-taniri, piwakinaro matzitaki.” ");
INSERT INTO prq_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Ari iwasirita-nakari Herodes, ti inintawityaa. Iro kantacha, tima ikimajiitakiri inkaaranki ishininka ikantakirori, ikantanakiri impiratani-payi: “Pamakiniro onintakiri mainaro.” ");
INSERT INTO prq_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Iwisai-takiri Juan anta tsika yasitakoi-takiri. ");
INSERT INTO prq_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Yamakoi-takiro iito matzitaki, ipaitakiro mainaro, aanakiniro iniro. ");
INSERT INTO prq_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Ikanta ipokajiita-paaki iyomitaani Juan, ikitatairi. Jaitijiitanaki isaiki Jesús, ikamantakiri. ");
INSERT INTO prq_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Ikanta ikima-kotakiri Jesús iwamaitakiri Juan, titanaka pitotsiki, ijati yositaa-waityaa. Iro kantacha ikimajiitaki atziri-payi tsika ijati, iyaatzisita-nakiri ikinajiitanaki awotsiki. ");
INSERT INTO prq_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Iro yaata-kota-paaki-tzii Jesús, iñaapaa-tziiri oshiki oyaawinta-kariri. Itako-sirita-paakari, yisitakotaaki oshiki mantsiyari. ");
INSERT INTO prq_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Okanta otsitiniityaanaki, ipokapaaki iyomitaani, ikantziri: “¡Yomitaanarí! Asaikatziira otzisi-masiki, aritaki tsitiniityaaki. Pinkaratiro pikinkithatzi, ijataita atziri-payi nampitsiki yamananti iyaari.” ");
INSERT INTO prq_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Ari yakanaki Jesús, ikantziri: “¿Paitama yatsipitan-tyaarori ijayitaji? Pimpiri awiroka iyaari.” ");
INSERT INTO prq_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Ikantzi iyomitaani: “Tikatsi nopiriri naaka apatziro itzimi apiti sima aajatzi okaratzi 5 yatantari.” ");
INSERT INTO prq_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Ikantzi Jesús: “Pamakinari.” ");
INSERT INTO prq_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Ipoñaa ikantakiri maaroni atziri-payi piisaikajiiti katarosi-masiki. Yaakiri sima aajatzi yatantari, aminanaki inkitiki, ipaasoonki-wintakiro. Ipitoryaakiro, ipayitakiri iyomitaani, iwawisaa-kiniri irirori atziri-payi piyotain-chari. ");
INSERT INTO prq_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Tima maaroni iwajiitaka, kimaniinta-jiitaka. Iyoyaajiro okaratzi tzimaraanta-naintsiri, itiyitajiro okaratzi 12 kantziri jaikitaa-tyari. ");
INSERT INTO prq_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Kimitaka ikaratzi 5000 sirampari-payi owainchari, titzimaita iyoitiro tsika-rika okaratzi kooya-payi aajatzi intsi-payi owainchari. ");
INSERT INTO prq_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Ipoñaa ikantanajiri Jesús iyomitaani: “Pitajyaaro pimontyaaji intatzikiro.” Iwithayita-waari ikaratzi piyowinta-kariri, ikantawajiri: “Kantatsi pijayitai iroñaaka.” ");
INSERT INTO prq_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Ikanta ithonkakiri iwithata-waari atziri-payi, tonkaanaki Jesús otzisiki yamani. Ari isaikakiri irirori tonkaariki yamani irojatzi otsitinitan-tanakari. ");
INSERT INTO prq_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Owiraa-kota-jiitaka iyomitaani-payi niyankyaani inkaari, antaro okantaka osinkyaatani inkaari, tima imonthaa-kityii-yaaro tampyaa. ");
INSERT INTO prq_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Okanta okitaititzi-mataki, ipoka-sitajiri Jesús iyomitaani-payi yaniitan-taaro inkaari. ");
INSERT INTO prq_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Ikanta iñaawajiri iyomitaani yaniitan-taaro inkaari, ti iyotawajiri, itharowan-tawaari, ikaimajiitanaki, ikantzi: “¡Koraakitaki siritsiwí!” ");
INSERT INTO prq_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Iro kantacha, iñaanata-pajiri Jesús iyomitaani-payi, ikantziri: “Naaka pokaatsi, tonta-siri pinkantyaa airo pitharowan-tawaitana.” ");
INSERT INTO prq_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Ari yakanaki Pedro, ikantziri: “Nowinkatharití, awiroka-rika, pinkanta-kaiyaaro naniitan-tyaaro naaka inkaari nomonthaa-waami.” ");
INSERT INTO prq_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Ikantzi Jesús: “Pimpokanaki.” Ayiitanaki Pedro, yaniitan-tanakaro inkaariki jataki isaikaki Jesús. ");
INSERT INTO prq_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Iro kantacha, ikinkithasirita-nakiro Pedro antaro-payi otamakaani inkaari, itharowan-tanakaro, tsitsiyanaki. Ari ikaimanaki, ikantzi: “Pinkatharí, paawajina.” ");
INSERT INTO prq_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Yakota-sita-nakiri Jesús, yairika-wajiri. Ikantziri: “Kapichiini pawintaana. ¿Paitama pikiso-siritantari?” ");
INSERT INTO prq_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Ikanta itijiitapaja pitotsiki, awisai-nkatanaki tampyaa. ");
INSERT INTO prq_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Tima antaro ipinkathata-nakiri ikaratzi titainchari pitotsiki, ikantajiitziri: “Omapirotatyaa awiroka Itomi Pawa.” ");
INSERT INTO prq_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Ariijiitaka intatzikiro, osaiki nampitsi ipaitai-tziri Piyompi-jaari. ");
INSERT INTO prq_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Tima iyotawakiri atziri-payi ikaratzi nampitarori anta iriitaki Jesús, ikamantakiri maaroni atziri saikatsiri anta, yamayita-paakiniri ikaratzi mantsiya-yitatsiri. ");
INSERT INTO prq_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Ikantai-takiri Jesús: “Pisinitiri mantsiyari-payi yantawakiro kapichiini opatzi-kaaki pithaari.” Tima inkarati antzita-kiriri iithaari Jesús, isitako-yitaji. ");
INSERT INTO prq_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Ikanta Nasitantaniri-payi aajatzi Yomitaan-taniri-payi poñaayitain-chari Aapatyaawiniki, isampita-nakiri Jesús, ikantziri: ");
INSERT INTO prq_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“¿Paitama kaari ikantantaro piyomitaani-payi okaratzi amiyitari arokaiti iyomitaairi awaisatzitini? Tima ti inkiwaa-kotyaa aririka iwajiityaa.” ");
INSERT INTO prq_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Yakanakiri Jesús, ikantziri: “¿Paitama pipiyathatan-tarori awiroka Ikantakaantziri Pawa, apatziro paako-wintaro okaratzi iyomitaajairi pairani awaisatzitini? ");
INSERT INTO prq_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Iroka ikantzi Pawa: Pimpinkathatairi piri aajatzi piniro. Ikantaki aajatzi: Inkarati mishatirini iriri aajatzi iriniro, ontzimatyii iwamaitiri. ");
INSERT INTO prq_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Iro kantacha, pikanta-piinta-jiitzi awiroka: ‘Kamiithatatsi ankantiri asitairi: “¡Apaá! Nasitakaakari Pawa maaroni noiriikiti, airo okanta nonisironkatyaami.” ’ ");
INSERT INTO prq_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","piyomitaa-sitakari okaratzi yamitaitari pairani, ti piyomitaantiro inintziri Pawa. Irootaki kaari inisironkatan-taari ashininka-payi iriri. Piñaakiro. ");
INSERT INTO prq_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Tima owapyiimotan-taniri pinajiitzi. Awiroka ikinkithata-kotaki pairani Isaías, ikantaki: ");
INSERT INTO prq_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Ipinkatha-waanti-tasitana atziri-payi, Titzimaita isirityaana kamiitha, intaina-siri iwana. ");
INSERT INTO prq_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Aminaa-sita ityiirowayita ipinkathatana, Iyomitaanta-sitakaro yamiyitari irirori.” ");
INSERT INTO prq_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Ikaimakiri Jesús maaroni piyowinta-kariri, ikantziri: “Piwakimpita-yityaa, pikimathatan-tyaanari: ");
INSERT INTO prq_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Tima inkarati awayitari ti okaaripiro-siritanti, irooma okaratzi añaawai-yitziri, irootaki kaaripirosiritantatsiri.” ");
INSERT INTO prq_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Ikanta iyomitaani-payi Jesús ipoka-sita-paakiri okaakiini, ikantapaakiri: “Tira onimotiri Nasitantaniri-payi ikimakimi pikantaki.” ");
INSERT INTO prq_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Ikantanaki Jesús: “Aritaki inthokairo Asitanari Inkiti-satzi maaroni pankirintsi kaari ipankitzi irirori. ");
INSERT INTO prq_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Pamina-sityaari. Tima inkimitatyaari aparoni mawityaakiri akathata-wakaa-chari. Aririka yakathata-wakaiyaa mawityaakiri, ti iyoti tsika inkini, tima apitiroiti intijiityaa omoro-nakiki.” ");
INSERT INTO prq_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Ikantzi Pedro: “Piyomitainaro okaratzi pisiyakaa-wintakiri.” ");
INSERT INTO prq_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Ikantzi Jesús: “¿Pimatzi-takama awiroka-payi ti ontzimi-motimi piyotani? ");
INSERT INTO prq_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","¿Tima piyoti okaratzi awapiintari okini ashiitoki, irojatzi ositowan-tajyaari? ");
INSERT INTO prq_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Iro kantacha aririka añaawai-yitiro kaari-pirori akinkithasiritari, irootaki kaaripirosiritantatsiri. ");
INSERT INTO prq_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Tima asiriki akinkithasiri-yitaro kaari-pirori, owan-taantsi, mayimpitaantsi, kaaripirori ñathatantachari, kositaantsi, thaiya-kotaantsi, kisimataantsi. ");
INSERT INTO prq_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Irootaki kaaripirosiritantatsiri iroka-payi. Irooma airorika akiwaa-kota aririka ayaa, ti okaaripiro-siritanti iroori.” ");
INSERT INTO prq_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Ikanta yawisanaki Jesús, jataki anta Mapiniki aajatzi Simaaki. ");
INSERT INTO prq_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Ari osiya-sita-wakari Owintini-sato nampitarori anta, okaimapaa-kitzii iroori, okantziri: “¡¡Pinkatharí, Ikasiya-kaitani pinkatharini David. Nonintzi pinisironkatyaana! Tima mapirotaka nosinto okimaatsi-waita yaakiro piyari.” ");
INSERT INTO prq_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Titzimaita yakiro Jesús. Ari ipokapaaki iyomitaani, ikantapaakiri: “Pintyaan-tairo, oshiki oñaasirinkai okaima-kaimatzi oyaata-kayira.” ");
INSERT INTO prq_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Ari yakanakiro Jesús, ikantzi: “Apatziro ityaantai-takina nonisironkatajiri noshininka Israel-iiti osiyakariri ipiraitari ipyaawai-yitaka.” ");
INSERT INTO prq_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ari otyiirowa-sita-nakari Jesús iroka kooya, okantanakiri: “¡Pinkatharí, pinisironkatyaana!” ");
INSERT INTO prq_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Ari ikantzi Jesús: “Tima ti aapithatiri iwariti intsiti apiri otsitzi iyaaro.” ");
INSERT INTO prq_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Akanakiri iroori, okantziri: “Omapiro pikantaki Pinkatharí. Iro kantacha, iwapiintaro otsitzi okaratzi iwaryiiri otapinaki piratariri.” ");
INSERT INTO prq_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Aikiro ikantana-kitziiro Jesús: “¡Kooyá, omapiro pawintaakana! Irootaki nomatan-tyaarori pikowa-kota-kinari.” Apatha-kiro isita-kotanaji isinto. ");
INSERT INTO prq_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Ikanta yawisanaki Jesús, ikinanaki inkaari-thapyaaki saikatsiri Tapowiniki. Ipoñaa itonkaanaki otzisiki, ari isaikapaakiri anta. ");
INSERT INTO prq_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Ari ijatakiri oshiki atziri, yamayitaki kantawai-yitachari imantsiyariti: kisoporiwaita-tsiri, mawityaakiri, kisowaantiri, pisaponthokiri, maaroni. Ipiyota-kiniri ikatziyaka Jesús, tima inthonkiri yisita-kota-kaayitairi. ");
INSERT INTO prq_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Okiryaantzi ikantawintai-takari Jesús iñaawaita-kaajirira kisowaantiri, isitako-yitaji pisaponthokiri, yaniita-kaayitairi kisoporokiri aajatzi kisoporiwaita-tsiri, yaminakaa-yitairi mawityaakiri. Ikantajiitzi atziri: “Omapiro ikamiithataki Iwawani Israel.” ");
INSERT INTO prq_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Yapatotakiri Jesús iyomitaani, ikantakiri: “Oshiki nonisironkatakari atziri-payi, tima okaratzi mawa kitaitiri isaikajiitaki ikimisantana, tikatsi iwajyaa. Ti noninti ijata-sitajyaa airo iwanaja, ayiri = kari itashi awotsiki.” ");
INSERT INTO prq_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Ikantajiitzi iyomitaani: “¿Tsikama ayika yatantaitari awakaiyaariri aka otzisi-masiki? Oshiki ikarajiitzi.” ");
INSERT INTO prq_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Ari isampitziri Jesús iyomitaani, ikantziri: “¿Tsikama okaratzi yatantaitari tzimatsiri?” Ikantzi iyomitaani: “Tzimatsi okaratzi 7, tzimatsi aajatzi kapichiini simaa-niki.” ");
INSERT INTO prq_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Ipoñaa ikantakiri ikaratzi piyotain-chari isaikajiiti osaawiki. ");
INSERT INTO prq_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Yaakiro 7 yatantaitari aajatzi simaa-niki, ipaasoonki-wintakiro. Ipitoryaa-yitakiro, ipayitakiri iyomitaani, iwawisaa-kiniri piyotain-chari atziri. ");
INSERT INTO prq_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Owaajiitaka maaroni, kimajiitaka. Yawiitajiro tzimaraanta-paintsiri, ijaikitaji okaratzi 7 kantziri. ");
INSERT INTO prq_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Ikaratzi 4000 sirampari owainchari. Ti iyotaitiro tsika okaratzi kooya-payi aajatzi intsi-payi owainchari. ");
INSERT INTO prq_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Ikanta iwithata-waari Jesús ikaratzi owainchari, titanaja pitotsiki, montyaanaka Pankothanthaariki. ");
INSERT INTO prq_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Ikanta Nasitantaniri-payi aajatzi Tampatzika-wiri-payi, inintajiitaki inkompita-kaiyaarimi Jesús. Ikantakiri: “Intsityaa pintasonka-wintanti noyotan-tyaari omapiro ityaantakimi Pawa aka.” ");
INSERT INTO prq_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Yakanakiri Jesús ikantzi: “Aririka piñiiro onkirainkaitzii tsitinii-tiini, pikanta-piinta-jiiti: ‘Oryaa-manaatyii onkitaitita-manaji.’ ");
INSERT INTO prq_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Irooma piñiiro-rika kapichikitaiti onkityonkaityii minkori inkitiki, pikantzi: ‘Omparyaatyii inkani.’ Tima piyotako-wityaaro inkiti, piyotako-witaro aririka omparyii inkani. Titzimaita piyoyitiro okaratzi piñaayi-witakari iroñaaka aka. ");
INSERT INTO prq_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Ti pinkamiitha-siri-jiiti awiroka, oshiki pithainkakiri Pawa, pininta-sijiita piñiina nontasonka-wintanti, airotzimaita noñaakimiro. Apatziro piñiiro siyaaroni awishi-mota-kiriri pairani Kamantan-tzinkari Jonás.” Yapakaakiro Jesús ikantayitakiri, awisanaki. ");
INSERT INTO prq_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Ikanta yariijiitaka iyomitaani Jesús intatzikiro, ti yaanaki yatantaitari, imaisanta-nakiro. ");
INSERT INTO prq_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Ikantzi Jesús: “Paamaiyaaro siñakairori yatantari Nasitantaniri aajatzi irasi Tampatzika-wiri.” ");
INSERT INTO prq_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Ikanta-wakaa-jiita iyomitaani: “¿Paitama ikantan-tairi Jesús? ¿Irooma ikantan-tairi tira amaki yatantaitari?” ");
INSERT INTO prq_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Yotaki Jesús ikanta-wakaari iyomitaani, ikantziri: “Tikira pisiri-piro-tyana awiroka-payi, irootaki pikinkithasiri-waitantari, pikanta-jiitzi: ‘Tira amaki yatantaitari.’ ");
INSERT INTO prq_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Tikirama pikimatha-jiitziro? Chapinki otzimawita yatantaitari okaratzi 5, iro kantacha nowakaaka ikaratzi 5000 atziri. Pikoyaajiro tzimaraanta-paintsiri. ¿Tsikama okaratzika kantziri pijaikitajiri? ");
INSERT INTO prq_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Aajatzi nokimitaakiro karatatsiri 7 yatantaitari, nowakaaka ikaratzi 4000 atziri. ¿Tsikama okaratzika kantziri pijaikitajiri? ");
INSERT INTO prq_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿Paitama kaari pikimathatantaro awiroka-payi? Tira nonkinkithata-kotiro iwaitari yatantaitari. Nokanta-tziimi: ‘Paamaiyaaro siñakairori yatantatari Nasitantaniri aajatzi irasi Tampatzika-wiri.’ ” ");
INSERT INTO prq_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Ari iyotanaki iyomitaani, tira inkinkithata-kotiro Jesús siñakairori yatantaitari, isiyakaa-winta-tziiro okaratzi iyomitaan-tayitziri Nasitantaniri aajatzi Tampatzika-wini. ");
INSERT INTO prq_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Ikanta yariitaka Jesús Cesarea-ki, inampitsitiki Filipo. Ari isampitakiri iyomitaani, ikantziri: “¿Paitama ikinkithasirita-koitariri Itomi Atziri?” ");
INSERT INTO prq_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Akaajiitanaki iyomitaani, ikantzi: “Tzimatsi atziri kantatsiri, ‘Juan Kiwaatan-taniri pinatzii.’ Ikantzi pasini, ‘iriitaki koñaataatsi Elías.’ Ikantzi pasini ‘iriitaki Jeremías.’ Tzimatsi kantayita-tsiri aajatzi, pasini Kamantan-tzinkari pinatzii.” ");
INSERT INTO prq_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Ikantzi Jesús: “¿Tsikama pikanta-jiitzi awiroka?” ");
INSERT INTO prq_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Ari yakanaki Simón Pedro, ikantzi: “Awiroka Saipatzii-totaari Itomi Pawa Añaanita-tsiri.” ");
INSERT INTO prq_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Ikantzi Jesús: “Kimosiri-wintaari pinatyii Simón itomi Jonás, kaari atziri oyota-kayi-mirori, iriitaki Asitanari Inkiti-satzi oyotakaa-kimirori. ");
INSERT INTO prq_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Nompaitajimi Kisopathari, tima pisiyakaro awiroka okiso-pathatzi kipatsi, aritaki nowitsikairori nowanko. Inkarati kimisantaa-tsini apaata, iriitaki siyayita-jyaaroni pankotsi. Airo imataitziri yitsinampairi impyaakaa-sitai-tyaari sarinka-winiki. ");
INSERT INTO prq_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Pisiyaari aamaako-wintarori asitakoro pankotsi, kantatsi yasitaryiiro, yasitiro, yantsiriitiro sintsiini. Irootakira pankotsi siyakaa-winta-chari impinkathari-wintantai Inkiti-satzi. Tima inkarati pisinitairi awiroka aka kipatsiki, iriitaki isinitaiti inkitiki. Iriima kaari pisiniyitaji awiroka aka kipatsiki, airo isinitai-tziri aajatzi anta inkitiki.” ");
INSERT INTO prq_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Aikiro ikantana-kitziiri Jesús maaroni iyomitaani: “Apaata pikamantantzi, pinkanti: ‘Iriitaki Saipatzii-totaari yoka Jesús.’ ” ");
INSERT INTO prq_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Ari yitanakaro Jesús ikamantziri iyomitaani-payi, ikantziri: “Oninta-pirotatyaa ajati Aapatyaawiniki, tima antaro inkimaatsita-kaiyaana antari-kona-payi, ijiwa-piroriti Ompira-tasorintsitaari, aajatzi ijiwari Yomitaan-taniri-payi, aritaki iwa-kaantinari. Iro awisawitakyaa mawa kitaitiri añaajana.” ");
INSERT INTO prq_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Ikanta Pedro, yaanakiri Jesús intyaatsikaini, ikantakiri: “Pinkatharí, ti onimo-tina pikantziri, ti noninti awishi-motimi pikantakiri.” ");
INSERT INTO prq_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Ari ipithoka-pithata-nakari Jesús yoka Pedro, ikantanakiri: “Pijati Kamaarí. Ti pisirityaaro awiroka inintakaanari Pawa, apatziro pisiritaro ininta-piintziri atziri-payi.” ");
INSERT INTO prq_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Ikantanakiri Jesús pasini-payi iyomitaani: “Tzimatsi-rika nintatsiri intsipatyaana, iwashaantajiro inintasi-yitari yantiro, onkanta-wityaa ipaikakoi-tirimi, intsipatyaana. ");
INSERT INTO prq_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Tima inkarati itakowaita-chari yantayitziro inintayitziri irirori, aritaki impyaa-sitajyaa. Iriima ikaratzi atsipiwintarori yantanajiro nonintziri naaka irootaki ikamawintan-tanari, aritaki yawisako-siritai. ");
INSERT INTO prq_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Aminaasi-waita otzimi-motantzi owaararontsi aka kipatsiki, aritaki ompyaakaa-sita-jyaari. ¿Kantatsima impinako-wintaityaa airo ipyaasi-waitan-taita? ");
INSERT INTO prq_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Aririka impiyi apaata yoka Itomi Atziri yamajiro iwaniinkaro Asitariri, intsipata-jyaari Maninkariiti, iriitaki pinatapa-jironi okaratzi yantaitakiri. ");
INSERT INTO prq_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Omapirotatyaa, tzimatsi pikaratziri aka, tikira pinkamiita aritaki piñaakiri Itomi Atziri tsika inkantyaa impinkathari-wintanti.” ");
INSERT INTO prq_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Okanta awisaki 6 kitaitiri, yaanajiri Jesús Pedro, Jacobo, Juan iririntzi Jacobo. Tonkaanaki otzisiki. ");
INSERT INTO prq_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Ari isiparyaa-porotzi-motakiri iyomitaani, isiyanakari ooryaatsiri, omatzitanaka iithaari kitamaarokini okantanaka. ");
INSERT INTO prq_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Iñaatziiri Moisés itsipatakari Elías ikinkitha-waita-kairi Jesús. ");
INSERT INTO prq_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Ari ikaimanaki Pedro, ikantzi: “¡Pinkatharí! Omapiro okamiithatzi pamakina aka. Kamiitha nowitsikimi mawa panko-shitantsi: Aparoni pasityaa awiroka, aparoni yasityaa Moisés, yasityaa aparoni Elías.” ");
INSERT INTO prq_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Iñaawai-minthaitzi, anaapaakiri oorinta-chari minkori. Ikimatzii iñaawaitai-tanaki minkoriki, ikantaitzi: “Notomi inatzii yoka nitakokitari, oshiki nokimo-siri-wintakiri. Pinkimisantairi.” ");
INSERT INTO prq_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Ikanta ikimajiitaki ikantai-takiri, oiyojiitanaka osaawiki, antaro itharowanaki. ");
INSERT INTO prq_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Ari ipokapaaki Jesús, itzinka-paakiri iyomitaani-payi, ikantziri: “Pinkatziyi, airo pitharowa-jiitzi.” ");
INSERT INTO prq_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Ari yaminawita-naari, tikatsi iñaanaji, apaniro ikatziyaka Jesús. ");
INSERT INTO prq_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Ikanta yoirinka-jiitaja, ikantakiri Jesús iyomitaani: “Airo pikamantantziro piñaakiri irojatzi apaata aririka yañaaji yoka Itomi Atziri inkamawitakyaa-rika.” ");
INSERT INTO prq_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Isampita-nakiri iyomitaani, ikantziri: “¡Yomitaanarí! ¿Paitama ikanta-kotziri Yomitaan-taniri-payi, ikantzi: ‘Aririka impoki-mataki Saipatzii-totaari, iriitaki jiwatapain-tsini Elías impoki?’ ” ");
INSERT INTO prq_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Yakanaki Jesús, ikantzi: “Omapiro ikantziri, iriitakii jiwatapain-tsini Elías impoki, itampatzika-siritan-tapaaki. ");
INSERT INTO prq_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Pinkimi nonkanti naaka: Ariiwitaka Elías, tikatsi yotawakirini, oshiki iwasankitai-takiri. Ari inkantai-tiriri Itomi Atziri, oshiki iwasankitaitiri irirori.” ");
INSERT INTO prq_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Ari iyojiitanaki iyomitaani iriitaki Juan Kiwaatan-taniri ikinkithata-kotziri. ");
INSERT INTO prq_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Ikanta yariijiitapaja ipiyojiita atziri. Pokapaaki aparoni atziri iñiiri Jesús. Ityiirowa-sita-paakari, ikantapaakiri: ");
INSERT INTO prq_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“¡Pinkatharí! Pinisironkata-jyaanari notomi, oshiki ikamana-waitzi, antaro ikimaatsi-waitaka, itaawaita-piintaka, ipiinka-waitzi nijaaki. ");
INSERT INTO prq_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Namawita-kaniri piyomitaani yaawinta-jinari. Titzimaita ikantiri.” ");
INSERT INTO prq_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Ari yakanaki Jesús, ikantanaki: “Ti pinkimisanta-jiiti awiroka, pikinasi-waitaka. ¿Tsika-paitima piyoti? Pamakiri aka pitomi.” ");
INSERT INTO prq_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Ikanta ikisawakiri Jesús piyari, iwashaanta-najiri mainari. Isita-kotanaji. ");
INSERT INTO prq_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Ikanta iyomitaani-payi Jesús yaanakiri intyaatsikaini, isampitakiri, ikantziri: “¡Yomitaanarí! ¿Paitama kaari nomatantari naaka nomatiri noitsinampairi piyari?” ");
INSERT INTO prq_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Ikantzi Jesús: “Tima tikira pawintyaarita kamiitha Pawa, irootaki kaari paawyaantari. Pinkimi nonkanti: Onkanta-wityaa kapichiini pawintyaari Pawa, aritaki pisirinkakiro otzisi, pinkantiro: ‘Pisirinki.’ Aritaki osirinkanaki. Tima tikatsi kompitzi-motyaamini aririka pinkimisanta-piroti. Omapiro. ");
INSERT INTO prq_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Iro kantacha, aririka pininti pisita-kota-kairi kimitariri yoka mainari, ontzimatyii pamani iro-piroini, pintziwintyaari.” ");
INSERT INTO prq_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Ikanta yariijiitaka Jesús anta Tapowiniki, yapiitakiri ikantziri iyomitaani: “Impimantai-tatyiiri ");
INSERT INTO prq_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Ari iwaitiri. Iro awisawitakyaa mawa kitaitiri, aritaki yañaaji.” Antaro iwasiritanaka iyomitaani-payi ikimakiri ikantaki. ");
INSERT INTO prq_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Ikanta yariitaka Jesús nampitsiki Capernaum, ari ipokaki sintsiwintanta-tsiri impaitiri kiriiki yasita-kayi-tarori tasorintsi-panko, isampita-paakiri Pedro, ikantziri: “¿Ipinata-piintziro yomitaimiri ikasiya-kaitarori Tasorintsi-panko?” ");
INSERT INTO prq_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Ikantanaki Pedro: “Ipinata-piintziro.” Ikanta ipiyaaro tsika isaikajiitzi, iriitaki tharo-wakota-waincha Jesús isampita-wajiri Pedro, ikantziri: “¿Paitama pikinkithasiritari Simón? ¿Paitama isintsiwintziri pinkathari-payi impinatiri kiriiki? ¿Iriima isintsiwintziri ishininka-piro-payi irirori? ¿Iriima isintsiwintzi pasini-satziiti ariitzinkari-payi?” ");
INSERT INTO prq_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Ari yakanaki Pedro, ikantzi: “Iriitaki isintsiwin-tziri ariitzinkari-payi.” Ikantzi Jesús: “Ari okanta. Tima ti onkowa-pirotyaa impinatiro ishininkatari irirori. ");
INSERT INTO prq_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Iro kantacha, ti noninti inkisawaityaa sintsiwintanta-tsiri impaitiri kiriiki. Pijati inkaariki pinkachaati. Aririka pinosikaki, pamina-waantitiri, aritaki piñaajiri kiriiki. Paanakiniri sintsiwintanta-tsiri impaitiri kiriiki. Iriitaki pimpina-wintyaari awiroka aajatzi naari.” ");
INSERT INTO prq_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Ikanta iyomitaani-payi Jesús ipiyowinta-paakari, ari isampitakiri, ikantziri: “¡Yomitaanarí! Aririka impinkathari-wintantai Inkiti-satzi. ¿Itzimikama iriipirotatsi intsipatyaari impinkathariti?” ");
INSERT INTO prq_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Ari ikaimaki Jesús aparoni iintsi, ikatziyakiri tsika isaikajiitaki irirori, ");
INSERT INTO prq_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","ikantziri: “Airorika piwashaantairo tsika pikanta pairani, airorika pikimitaari tsika ikanta yoka iintsi, airo ipinkathari-wintaimi Inkiti-satzi. Omapirotatyaa. ");
INSERT INTO prq_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Tima inkarati tsinampa-sirita-tsini inkimita-jyaari yoka iintsi, iriitaki iriipirota-tsini tsika ipinkatha-ritai Inkiti-satzi. ");
INSERT INTO prq_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Ikaratzi aakamiithatairiri osiyakariri iintsi yawintaajana, naaka yaakamiithataki.” ");
INSERT INTO prq_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Tzimatsi-rika antakairini kaari-pirori osiyakariri iintsi yawintaajana, onkamintha inthatai-tiniri mapi ikintsiki, iwiinkai-takiri osaankanaatzi inkaari. ");
INSERT INTO prq_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Omapirotatyaa onkowiinkati kipatsiki. Ari intzimaki antakaan-tayitironi kaari-pirori. Inkanta-machiitiri antakaan-tironi kaari-pirori. ");
INSERT INTO prq_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Iroorika pako, piitzi pikaaripirotanta, piwashaantiro, pinkimita-kaantiro pinthatzinkairomi, tima irootaki kamiithatatsi pawisakoritaji, ti ampantyaaro otzimawita apiti pako, apiti piitzi, ompoña onkanta-kaantaimi apaata pasi piwanta-jyaarori pintaajyaa. ");
INSERT INTO prq_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Iroorika poki pikaaripirotanta, piwashaantiro, pinkimita-kaantiro pisorya-kita-jyaami, tima irootaki kamiithatatsi pawisako-pityaakitai, ti onkanti otzimawita apiti poki, ompoña onkanta-kaantaimi apaata yookaitaimi opaamataki sarinka-wini.” ");
INSERT INTO prq_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Paamaiyaa pimaninta-waitziri = kari osiyayita-kariri iintsi. Tima yaamaa-kowintani inatzii Maninkari itsipata-piintari Asitanari Inkiti-satzi. ");
INSERT INTO prq_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Tima irootaki ipokantari Itomi Atziri iwawisaa-koyitairi ikaratzi pyaawitain-chari. ");
INSERT INTO prq_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Pinkimi nosiyakaa-wintimiro. Tzimatsi piratachari ikaratzi 100 ipiraitari. Ikanta ipyaaraantaka aparoni, ikaratanaji 99 ipira. Yookanakiri 99 ipira otzisi-masiki, jataki yamina-minatairi pyainchari. ");
INSERT INTO prq_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Ikanta iñaajiri, antaro ikimo-siritaji yaajirira pyaawitain-chari, tima anaanakiro ikimo-siri-wintziri pasini 99 ipira kaari pyaachani. ");
INSERT INTO prq_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Ari ikantari aajatzi Asitairi Inkiti-satzi, ti ininti impyaa aparoni osiyakariri yoka iintsi.” ");
INSERT INTO prq_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Aririka inkaaripirotzi-motimi kimisantzinkari, pijata-sitiri isaiki apaniroini, ari pinkinkitha-waita-kairi, iyotantyaari opaita ikaaripirotakari. Aririka inkimimi piyomitaa-najiriri, pinkimita-kaantairi pirintzi okaakiini inatyiimi. ");
INSERT INTO prq_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Irooma airorika ikimimi piyomitaa-witanariri, paanaki pasini kimisantzinkari, airorika apiti, iriitaki pintsipatyaari piyomitaa-najiri. Tima ontzimatyii inkarati apiti, airorika mawa iriitaki akakotimini piyomitaa-najiri. ");
INSERT INTO prq_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Airorika ikimimi piyomitaa-witanari, pinkamantiri maaroni kimisantzinkari. Aikiro-rika ijatakaa-tyiiro, pinkimita-kaantiri pasini-satzi atziri kaari pishininkatyaa, tima isiyakari sintsiwintanta-tsiri impaitiri kiriiki. ");
INSERT INTO prq_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Tima inkarati pisinitairi awiroka aka kipatsiki, iriitaki isinitaiti inkitiki. Iriima kaari pisiniyitaji awiroka aka kipatsiki, airo isinitai-tziri aajatzi anta inkitiki. Omapirotatyaa. ");
INSERT INTO prq_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Napiitiro nonkantimi: Aririka pinkarati apiti paapatyaa-kota-wakai-yaaro pikinkithasiritari pikamitantiri, impoña pikamitiri Asitanari Inkiti-satzi, aritaki imatakaa-kimiro irirori. ");
INSERT INTO prq_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Tsika-rika yapatota apiti, tirika mawa atziri ipinkathataana naaka, aritaki nosaikitari naaka anta notsipatari.” ");
INSERT INTO prq_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Ikanta Pedro isampita-nakiri Jesús, ikantziri: “¡Pinkatharí! Aririka iwaaripirotina nokaratzi nokimisanta-jiitzi, ¿tsikama onkarati nompyaakotiri naripirotan-tajyaariri? ¿Apatziroma onkarati 7?” ");
INSERT INTO prq_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Ari yakanaki Jesús, ikantanakiri: “Tira apatziro pimpyaakotiri onkarati 7, tima oshiki papiitiri pimpyaakotairi.” ");
INSERT INTO prq_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“Iroka ikanta ipinkathari-wintantai Inkiti-satzi, tima isiya-kotyaari pinkathari ikowa-kotziri impiratani impinatairi iriiwitziri. ");
INSERT INTO prq_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Ikanta yitanakaro pinkathari ikowa-kotziri iriiwitziriri, yamaita-paakiri iriiwi-pirota-tsiri. ");
INSERT INTO prq_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Tima tikatsi yayi impinawinta-jyaari. Ikantanaki pinkathari: ‘Paanakiri yoka atziri, iina, itomi-payi, aajatzi okaratzi tzimi-motziriri, pimpimantiri. Ari naajiri naaka kiriiki ikaratzi iriiwitanari.’ ");
INSERT INTO prq_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Ari ityiirowanaka ompirataari, ikantanakiri pinkathari: ‘Airo pipimantana, piyaa-kota-wakina kapichiini, aritaki nompinatajimi.’ ");
INSERT INTO prq_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Ari inisironkata-nakari pinkathari yoka impiratani, ikantziri: ‘Kamiithataki, ti piriiwitajina.’ Tima ipyaakotakiri okaratzi iriiwitziriri. ");
INSERT INTO prq_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Ikanta ijatanaji ompirataari, imonthaakari iriiwitziriri irirori kapichiini. Yairika-kintsita-wakiri, ikantziri: ‘Pimpinatajina piriiwitanari.’ ");
INSERT INTO prq_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Ari ityiirowa-siwita-nakari, ikantziri: ‘Piyaawakina kapichiini, aritaki nompinatajimi.’ ");
INSERT INTO prq_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Titzimaita ininti iyaawintyaa, yaanakiri, iminkyaa-kaantakiri, ikantziri: ‘Aritaki nomisitowa-kaantajimi aririka pimpinatajina.’ ");
INSERT INTO prq_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Iñaakiri ikarajiitzi, ti onimota-nakiri, jatanaki ikamantziri iwinkathariti. ");
INSERT INTO prq_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Ikanta pinkathari, ikaimakaan-takiri impiratani, ikantawakiri: ‘Kaari-pirori pinatzii awiroka. Nopyaakota-kimiro piriiwitanari awiroka, pikantakina: piyaawinta-wakyaana.’ ");
INSERT INTO prq_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Ari pinkantantimi awiroka, pinisironkatantyaa. ");
INSERT INTO prq_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Tima antaro ikisanaka pinkathari, ipasata-kaantakiri, iminkyaa-kaantakiri, ikantziri: ‘Aririka pimpinatajina awiroka, aritaki nomisitowa-kaantajimi.’ ");
INSERT INTO prq_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Ari inkanta-jimiri apaata Asitanari Inkiti-satzi, airorika pipyaakotairi iriipiroini owari-pirotzimiri pikaratzi pikimisantzin-karitzi.” ");
INSERT INTO prq_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Ari ithonka-nakiro Jesús iyomitaantzi Tapowiniki, awisanaki intatzikiro Owaryiinkaariniki iipatsitiki Judá-iti. ");
INSERT INTO prq_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Ipiyotzi-wintai-tawaari. Yisita-kota-kaapaji oshiki mantsiyari-payi anta. ");
INSERT INTO prq_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Ari ipoka-sitakiri Nasitantaniri-payi inintzi inkompita-kaiyaarimi Jesús, isampita-paakiri, ikantziri: “¡Jesús! ¿Sinitaa-ntsita-tsima yookasi-waityaaro iina atziri?” ");
INSERT INTO prq_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Ari yakanaki Jesús, ikantziri: “¿Tima piñaanata-kotiri owakira iwitsikan-taita-kariri atziri? Tima iwitsikaitaki sirampari aajatzi kooya. ");
INSERT INTO prq_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Ikantaitaki: Irootaki airo isaikantaja mainari-payi asitaririki aririka yaawakaa-najyaa, tima aparoni inkanta-najyaa iwathaki osiyawaityaaro iwichaa-wakaa-jyaami. ");
INSERT INTO prq_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Tima inkarati aawakaa-naachari tira apiti inkanta-najyaa, aparoni ikantana iwathaki. Irootaki airo okantanta yookajiro atziri iina itsipata-kaakariri Pawa.” ");
INSERT INTO prq_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Yapiitakiri Nasitantaniri isampitziri, ikantziri: “¿Opaitama ikanta-kotziri pairani Moisés, ikantaki: Aririka yooka-wakaityaa, ontzimatyii impaitiri tsika osankinata-kota yooka-wakaan-tyaari?” ");
INSERT INTO prq_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Ikantzi Jesús: “Okantakaaro pipiyatha-waita, irootaki isinitan-tamirori Moisés pookiro piina. Tima pairani owakira iwitsikan-taita-karori maaroni, ti ari onkantyaa. ");
INSERT INTO prq_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Nokantzi naaka: Kaaripiro-siritaki ikaratzi ookasitarori iina, irooma iñiiro-rika omayimpitaki kantacha yookiro. Aririka aawitajyaa iroori pasini oimi, omayimpitzi-motakiri itawitari oimintari. Ari inkanta-jyaari aajironi, mayimpitaki irirori.” ");
INSERT INTO prq_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Ikantzi iyomitaani: “Aririka okanta, airo yaawakaitami.” ");
INSERT INTO prq_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Ikantzi Jesús: “Iriirika Pawa kowakai-mironi aritaki pinkima-thatakiro. Tira maaroni inkimathaitiro tsika-rika okanta-kota aawakaantsi. ");
INSERT INTO prq_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Tzimatsi atziri ari ikantzita itzimapaaki ti onkanti yayi iina. Tzimatsi pasini yaithokitai-tziri, ti onkanti yayi iina. Tzimatsi pasini nintatsiri isaikasi-waityaa, tima yiriipiro-winta-tyiiri pinkatha-ritatsiri inkitiki. Nintatsiri inkimathatiro nokantakiri, imatiro.” ");
INSERT INTO prq_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Ari yamaita-paakiniri Jesús intsi-payi, ikantai-tapaakiri: “Nonintzi pamana-kotinari nintsiti, piwasi-patzii-totiri pintasonka-wintiri.” Ikantzi iyomitaani Jesús: “Airo piñaasirinkiri Awinkathariti.” ");
INSERT INTO prq_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Ikantzi Jesús: “Airo pitzikiri, nonintzi naaka yamaitinari iintsi. Tima inkarati osiya-kota-naariri iintsi, iriitaki ñaajironi tsika ipinkathari-wintantai Inkiti-satzi.” ");
INSERT INTO prq_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Ikanta ithonkakiri Jesús iwasi-patzii-totakiri intsi-payi, jatanaji irirori. ");
INSERT INTO prq_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Ari ipokapaaki aparoni mainari iñiiri Jesús, ikantapaakiri: “¡Kamiithari yomitaan-taniri!. ¿Paitama nantajiri nasi nowanta-jyaarori nañaaji?” ");
INSERT INTO prq_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Ari yakanaki Jesús, ikantzi: “¿Paitama pikantan-tanari ‘kamiithari?’ Tira intzimi aparoni kamiithari, apatziro ikantakaaro Pawa ikamiithatzi. Pinintzi-rika pasi piwiro pañaaji, pimonkara-yitairo ikantai-takiri Ikantakaan-taitaniki.” ");
INSERT INTO prq_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Inintanaki mainari iyota-kotiro, ikantziri: “¿Otzimikama pikantziri?” Ikantzi Jesús: Airo piwamaantzi. Airo pimayimpitzi. Airo pikositzi. Airo pithaiya-kotanta. ");
INSERT INTO prq_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Pimpinkathatairi piri aajatzi piniro. Pintakota-jyaari pishininka pinkimita-kaantiri pitakota awiroka. ");
INSERT INTO prq_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Ikantzi mainari: “Nomatakiro maaroni iroka, irojatzi nitanakaro pairani ainiro nintsita-paaki. ¿Paitama kowityaa-chari iroñaaka?” ");
INSERT INTO prq_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Ikantzi Jesús: “Pinintzi-rika pintampatzika-siriti, pijati, pimpimantiro maaroni tzimi-motzimiri, pimpiri asinonkainkari, tima osiyawaitakaro piwaa-ranta-jyaami inkitiki. Aririka pimatakiro pimpoki, piyaatina.” ");
INSERT INTO prq_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Ikanta ikimaki mainari, owasiri ikanta ipiyanaka, tima ashaarantzinkari inatzii. ");
INSERT INTO prq_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Ikantanakiri Jesús iyomitaani: “Oshiki ompomirintsitzi-motyaari ashaarantaniri ijatai ipinkatha-ritai Inkiti-satzi. Omapiro.” ");
INSERT INTO prq_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Yapiita-nakiro Jesús, ikantzi: “Tima oshiki ipomirintsitaro ikyaakoitari inkyaan-tyaaro yanini omoro. Iri mapirota-chani ashaarantaniri impomirintsita-jyaaro inkyaaji ipinkathari-wintantzi Pawa.” ");
INSERT INTO prq_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Ikanta ikimaki iyomitaani-payi, okiryaantzi ikantanaka, ikanta-wakaa-jiita: “¿Paitama awisakotaa-tsini?” ");
INSERT INTO prq_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Ari itsikanatakari Jesús iyomitaani-payi, ikantziri: “Airo imatziro yitsinampairi atziri-payi, iriima Pawa tikatsi pomirintsitzi-motyaarini irirori.” ");
INSERT INTO prq_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Ari yakanaki Pedro, ikantzi: “Yoka nokarajiitzi nonintzi noyaatakimi, tima nookayita-nakiro okaratzi tzimi-motanari. ¿Paitama impinai-tajinari apaata?” ");
INSERT INTO prq_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Ikantzi Jesús: “Aririka owakirataji apaata maaroni, impinkatha-ritai Itomi Atziri isaikan-tajyaaro waniinkata-chari isaika-minto. Aritaki pinkimita-jyaari awirokaiti pikaratzi piyaatakina, pimpinkathari-wintairi maaroni inkarati incharinita-jyaari Israel, ikaratzira 12 inasiyita. Omapiro. ");
INSERT INTO prq_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Tima tzimayitatsi awintaa-janari, irootaki yookanta-nakarori iwanko, iririntzi, iritsiro, asitariri, iina, iintsiti, iipatsiti. Aritaki iñaajiro ontzimi-motairi oshiki, irasi iwiro yañaayitaji. ");
INSERT INTO prq_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Iro kantacha, tzimatsi iroñaaka oshiki itayiwitarori, iriitakira ampoita-tsini iñaayitairo. Tzimatsi pasini ampoiyita-tsiri iroñaaka, iriitakira itayita-jyaaroni iñaayitairo.” ");
INSERT INTO prq_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Iroka okanta-kota impinkathari-wintantai Inkiti-satzi, osiyari atziri tzimatsiri ichochoki-masiti. Yananinkanaki yamini antawaita-tsini iwankiri-masiki. ");
INSERT INTO prq_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ikanta iñaaki nintatsiri yantawaiti, ikantakiri: ‘Pitanakyaaro iroñaaka pantawaiti irojatzi tsitiniiti, nompinatimi aparoni kiriiki ikaratzi ipinatanta-piintai-tziri yantawaitaiti aparoni kitaitiri.’ Ikantajiitzi antawai-rintzi: ‘Kamiithataki.’ Ityaantakiri iwankiri-masiki. ");
INSERT INTO prq_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Ikanta ijinokita-paaki ooryaatsiri aajatzi ipiyanaja asitarori iwankiri-masi nampitsiki. Iñaapaji pasini ikatziya-jiita tikatsi yantawairi. ");
INSERT INTO prq_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Ikantapaakiri: ‘Pijati pantawaiti nowankiri-masiki, aritaki nompinatakimi okaratzi ipinatanta-piintaitzi.’ Jaitijiitaki yantawaiti. ");
INSERT INTO prq_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Ari ikantakiro itampatzikata-paaki ooryaatsiri, aajatzi itainkanaki ooryaatsiri. ");
INSERT INTO prq_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Ari ikantakirori aajatzi otsitiniityaanaki, iñaapaji atziri isaikajiitzi, tikatsi yantawairi, isampita-paakiri: ‘¿Tikatsima pantawairi pisaika-siwaitantari kitaitiriki?’ ");
INSERT INTO prq_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Yakajiitanaki, ikantzi: ‘Tikatsi antawaita-kayinani.’ Ikantzi irirori: ‘Pijati pantawaiti nowankiri-masiki, aritaki nompinatakimi okaratzi ipinatanta-piintaitzi.’ ");
INSERT INTO prq_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Okanta otsitinitanaki, ikantakiri asitarori iwankiri-masi kimpoyii-niriri iiriikiti, ikantziri: ‘Pinkaimiri maaroni antawai-rintzi pimpinatiri aparoni kiriiki ikaratzi ipinatanta-piintai-tziri yantawaitaiti aparoni kitaitiri. Iriitaki pitawakyaa pimpinatiri ampoita-paintsiri yantawaitaki, irojatzi pimatan-takyaariri itakarori kapichikitaiti yantawaitaki.’ ");
INSERT INTO prq_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Ari ipokajiita-paaki ampoita-paintsiri yantawaitaki, kapichiini yantawai-witaka ipinaitakiri aparoni kiriiki. ");
INSERT INTO prq_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Ipokajiita-paaki itakarori yantawaitaki kapichikitaiti, isiyakaantzi iriitaki impina-piroiti. Ti, ari ikimitakari pasini-payi tsika ikaratzi ipinaita-kiriri. ");
INSERT INTO prq_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Ikanta ipinawitai-takari, ikisanakiri asitarori yantawairi, ");
INSERT INTO prq_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","ikantanakiri: ‘Ti yantawai-piroti ampoita-paintsiri, iro kantacha imonkaratakana pipinata-kinari, naaka atsipiwita-kariri ooryaatsiri.’ ");
INSERT INTO prq_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Ikantzi asitarori iwankiri-masi: ‘Ashininká, nopinatakimi kamiitha, ¿tima nokantzi-takami kapichikitaiti nompinatimi aparoni kiriiki? ");
INSERT INTO prq_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Yoka aparoni kiriiki nopinatzimiri, pijatai. Tima naaka ninta-sitacha nompinatiri aparoni kiriiki ampoita-paintsiri yantawaitzi, ");
INSERT INTO prq_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","¿Airoma okantzi nompinatanti nonintziri naaka? ¿Pikisako-niinta-tyaaroma nonisironkatantzi naaka?’ ");
INSERT INTO prq_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Tima oshiki jiwatatsiri iñaayitajiro, iriitaki ampoita-tsini. Tzimatsi oshiki ampoiyita-tsiri iñaayitajiro, iriitaki jiwatatsini. Tima oshiki inkaima-witaityaa, iro kantacha kapichiini inkarati iyosiitaitiri.” ");
INSERT INTO prq_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Ikanta itonkaanaji Jesús ijatiro Aapatyaawiniki, iriitaki itsipatanaja 12 iyomitaani, ikantakiri awotsiki: ");
INSERT INTO prq_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Ajatatziira Aapatyaawiniki. Ari yaakaan-taitiriri Itomi Atziri, yayiri ijiwari Ompira-tasorintsitaari, intsipata-kyaari Yomitaan-taniri, iriitaki mishakowintirini iwaitiri. ");
INSERT INTO prq_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Iwawisaa-kiniri pasini-satziiti atziri iwashaya-mintha-waityaari, impasawaitiri, ipaika-kotakiri. Iro awisawitakyaa mawa kitaitiri, aritaki yañaaji.” ");
INSERT INTO prq_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Okanta iina Zebedeo opoka-sitakiri Jesús, otsipatakari otomi-payi, yoka Jacobo aajatzi Juan. Otyiirowa-paaka, okantapaakiri: “Nonintzi pinisironkatyaana.” ");
INSERT INTO prq_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Ari isampita-nakiro Jesús, ikantziro: “¿Paitama pikowa-kotanari?” Okantzi iroori: “Tima irootaintsi pimpinkatharin-tsiti awiroka, nonintzi intsipatyaami notomi impinkathari-wintanti, isaiki-motimi aparoni pakopiroki, iriima pasini isaiki pampatiki.” ");
INSERT INTO prq_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Ikantzi Jesús: “Tira piyotiro opaita pikowa-kotanari. Tima oshiki nonkimaatsityaari naaka. ¿Arima pamawitakiro awiroka onkarati pinkimaatsityaari? ¿Arima pisiyakyaana nonkami naaka?” Ikantajiitzi irirori: “Aritaki nomatakiro.” ");
INSERT INTO prq_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Ikantzi Jesús: “Omapiro, tima irootaintsi pinkimaatsityaaro onkarati nonkimaatsityaari naaka. Irooma pintsipatyaana ampinkathari-wintanti pisaiki aparoni nakopiroki, pasini nampatiki, tira naaka nintakai-yaaroni itzimi nontsipatyaari, apatziro iyotzi Asitanari tsika itzimi ikasiya-kaakiri.” ");
INSERT INTO prq_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Ikanta ikimajiitaki pasini iyomitaani, ikisaita-nakiri Juan aajatzi Jacobo. ");
INSERT INTO prq_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Yapatota-najiri Jesús iyomitaani-payi, ikantziri: “Piyojiitzi awiroka tsika ikanta iwinkathariti pasini-satziiti, oshiki impiratanta. Ari ikimitari aajatzi iriipirota-tsiri ipinkathatai-tziri irirori. ");
INSERT INTO prq_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Irooma awiroka-payi, aririka pininti piriipiroti, pisiya-kotyaari tsika ikanta ompirataari. ");
INSERT INTO prq_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Iroorika pinintzi pijiwata-kaanti, pisiya-kotyaari ompirataari. ");
INSERT INTO prq_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Ti iro impokan-tyaari Itomi Atziri impiratantyaa, iro ipokantakari isiya-kotyaari ompirataari, inkamawintanti, iriitaki pinakowintan-tatsini, yookakaa-wintairi maaroni.” ");
INSERT INTO prq_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Ikanta yawisajiitanaki Kasiryaariki, oshiki atziri oyaatana-kiriri. ");
INSERT INTO prq_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Ari isaiki awotsi-nampiki apiti mawityaakiri. Kimaki irirori, ikantaitzi: “Ari inkinapaaki Jesús aka awotsiki.” Irootaki ikaiman-tanakari, ikantzi: “¡Pinkatharí, Ikasiya-kaitani pinkatharini David, pinisironkata-jyaana naaka!” ");
INSERT INTO prq_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Oshiki ikisatha-witai-takari. Ti imairiti, aikiro ikaimatzi sintsiini: “¡Pinkatharí, Ikasiya-kaitani pinkatharini David, pinisironkata-jyaana naaka!” ");
INSERT INTO prq_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Katziya-paaka Jesús, ikaimakiri ikantziri: “¿Paitama pinintziri?” ");
INSERT INTO prq_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ikantajiitzi irirori: “Pinkatharí, nonintzi naminawaitaji kamiitha.” ");
INSERT INTO prq_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Antaro inisironkata-nakari Jesús yoka mawityaakiri, ipampita-kiniri irooki. Apatha-kiro yaminawaitanaji kamiitha, iyaatanakiri Jesús. ");
INSERT INTO prq_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Aritaki okaakitzi-mata-paaki yariitan-tyaari Jesús Aapatyaawiniki. Tima ariijiitaka Chochokipankoniki omontitakari otzisi Yinkaitoni. Ari ityaantakiri Jesús apiti iyomitaani, ");
INSERT INTO prq_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","ikantakiri: “Pijati nampitsiki amontitakari, ari piñiiro onthata-kotyaa ikyaakoitari ontsipata-kyaari yanini. Pinthataryaa-kotiro, pamakinaro. ");
INSERT INTO prq_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Tzimatsi-rika sampitimini, pinkantiri awiroka: ‘Inintatziiro pinkathari. Aritaki yoipyaa-jimiro.’ ” ");
INSERT INTO prq_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Ari omonkaratari isankinatakiri pairani Kamantan-tzinkari, ikantaki: ");
INSERT INTO prq_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Pinkaman-tairo maaroni Kisakowintoni-sato, pinkantiro: Awotsikitaki Piwinkathariti ipoka-sitakimi, Tsinampa-siri ikanta ipokaki ikyaa-kotaka, Kiripiri inatzii owaiyani yaakaitziri tinari. ");
INSERT INTO prq_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Ikanta ijatanaki apiti iyomitaani, imatakiro okaratzi ikantawa-kiriri Jesús. ");
INSERT INTO prq_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Yamakiro ikyaakoitari otsipataakari oyaaniti. Iwankita-kiniri manthakintsi imitzikaraki, ikyaa-kota-nakari Jesús. ");
INSERT INTO prq_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Ikanta atziri-payi saikain-tsiri anta, imaaronka-sita-nakiri imanthaki awotsiki tsika inkinanaki. Tzimatsi pasini chikanain-tsiri inchasi imaaronka-sitziri. ");
INSERT INTO prq_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Tima inkarati atziri jiwatain-tsiri, ikaratzi oyaatakiriri itaapiiki, ikaimajiitzi, ikantzi: ¡Korakitataiki awinkathariti, Ikasiya-kaitani pinkatharini David! ¡Tasonka-wintaari ikantaja, tima Pinkathari inatzii otyaanka-kiriri! ¡Korakitataiki awinkathariti, awisiryaawinta-jyaari Inkiti-satziwí! ");
INSERT INTO prq_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Ikanta yariita-paaka Jesús Aapatyaawiniki, isampita-wakaanaka ikaratzi nampitarori, ikantajiitzi: “¿Tsikama ipaitaka yoka?” ");
INSERT INTO prq_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Tzimatsi kantanain-tsiri: “Iriitaki Jesús, Kamantan-tzinkari inatzii, iriitaki poñaachari Kasiyakaawiniki saikatsiri Tapowiniki.” ");
INSERT INTO prq_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Tima kyaapaaki Jesús tasorintsi-pankoki, imisitowa-paakiri pimanta-waita-tsiri, aajatzi ikaratzi amananta-waita-tsiri. Yooka-yitapaakiro iwantariri kiriiki, ari ikimitaakiro tsika iwaitziri siropayi. ");
INSERT INTO prq_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ikantapaakiri: “Isankinai-takiro pairani iñaawaitzi Pawa, ikantzi: Nowanko onatzii iroka, aritaki yamana-piintai-tinari. Iro kantacha awirokaiti, aritaki pamatawitanta-piintaki pipimanta-yitzi, pikimita-kaantakiro kosintzi-panko.” ");
INSERT INTO prq_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Ari ipokajiita-paaki tasorintsi-pankoki oshiki mawityaakiri, kisoporokiri, maaroni yisita-kota-kaayitairi. ");
INSERT INTO prq_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Tima okiryaantzi ikantawintai-tanakaro okaratzi yantakiri Jesús. Ari ikaimajiitanaki intsi-payi, ikantajiitzi: ¡Thami apinkathatajiri Ikasiya-kaitani pinkatharini David! Iro kantacha ijiwari-payi Ompira-tasorintsitaari, aajatzi Yomitaan-taniri, ikisajiitanaka irirori, tima ti onimotiri. ");
INSERT INTO prq_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Isampitai-tanakiri Jesús, ikantai-tziri: “¿Pikimakiro ikantajiitziri mainari-payi?” Ikantzi Jesús: “Nokimakiri. ¿Tima piñaanatiro awiroka sankinarintsi? kantatsiri: Iriitaki intsi-payi aajatzi thotatsiri ithomi, Pimatakaakiri ipinkatha-yitaimi.” ");
INSERT INTO prq_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Ari yawisanaki Jesús, ikinanakiro Asinonkaa-pankoniki. Ari imaakiri anta. ");
INSERT INTO prq_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Okanta okitaitita-manaji, piyaja Jesús nampitsiki. Ari itashaa-paaki niyaanki-thakiniki awotsi. ");
INSERT INTO prq_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Iñaapaaki awotsi-nampiki pankirintsi, ijata-sita-nakiro, iñaatziiro ti onkithokiti, oyosiita-sita osi. Ikantanakiro: “Pasi piwiro airo pikitho-kitai.” Okanta pankirintsi, kamasitanaki. ");
INSERT INTO prq_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Ikanta iñaakiro iyomitaani, okiryaantzi ikantajiitanaka, isampita-nakiri, ikantziri: “¿Paitama okama-sitan-tanakari pankirintsi?” ");
INSERT INTO prq_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Yakanaki Jesús, ikantziri: “Omapiro nonkantimi, iroopiro-rika pawintyaana, airorika pikiso-siri-waitzi, aritaki pimatajiro awiroka, aritaki anaanakiro tsika okanta piñaakiro pankirintsi. Kantatsi piñaanatiro otzisi, pinkanti: ‘Osirinki otzisi, ompiinki inkaariki.’ Aritaki omatakyaa. ");
INSERT INTO prq_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Tima onkarati pinkowako-tairi pamana-nikii, aririka pawintaa-nakyaari Pawa, aritaki impakimiro.” ");
INSERT INTO prq_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Ikanta yariitaaro Jesús Tasorintsi-pankoki, iyomitaan-tapaji. Ari ipokakiri ijiwari Ompira-tasorintsitaari, aajatzi antari-kona-payi, isampita-paakiri: “¿Paitama ontyaan-kakimiri piñaakantiro pitasorinka?” ");
INSERT INTO prq_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Ari yakanaki Jesús, ikantziri: “Aajatzi naaka tzimatsi nosampitimiri. Aririka pakakinaro, aritaki nonkantakimi ipaita otyaanka-kinari. ");
INSERT INTO prq_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Ikiwaatantaki pairani Juan, ¿Paitama otyaanka-kiriri? ¿Iriima Pawa? ¿Atzirima?” Ari ikanta-wakaa-jiitanaka: “Aririka ankantiri Pawa otyaankakiri, aritaki inkanta-nakai: ‘¿Paita kaari pikimisantantari?’ ");
INSERT INTO prq_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Aririka ankanti: ‘Atziri ontyaan-kakiri,’ aritaki inkisanakai atziri-payi.” Tima inkanta-jiiti atziri-payi Kamantan-tzinkarini inatzii Juan. ");
INSERT I