﻿USE sofia;
DROP TABLE IF EXISTS sofia.priNT_vpl;
CREATE TABLE priNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES priNT_vpl WRITE;
INSERT INTO priNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Wà Iésu *Kériso, âna é té gée goo wà Davita, pwi gòobàra *Abéraama. Â wàilà-ni diri tèpa jojooro Iésu: ");
INSERT INTO priNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abéraama Isaaka Iakobo *Juda (ma wà tèpa aéjii kêe) ");
INSERT INTO priNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Pérès (ma wà aéjii kêe Zéra; nyaa kàru, âna wà Tamar) Hesron Ram ");
INSERT INTO priNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aminadab Nachon Salma ");
INSERT INTO priNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Booz (nyaa kêe, âna wà Rahab) Obed (nyaa kêe, âna wà Ruth) Jessé ");
INSERT INTO priNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Davita. Wà *Davita, âna é pwi ukai naa *Isaraéla. Â gée na càùé, â wà tèpa jojooro Iésu, âna: *Solomona (nyaa kêe, âna tô wâdà Urie béaa) ");
INSERT INTO priNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Roboam Abia Asa ");
INSERT INTO priNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Josaphat Joram Ozias ");
INSERT INTO priNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Yotam Akaz Ézékias ");
INSERT INTO priNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Manassé Amon Josias ");
INSERT INTO priNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Yekonia (ma wà tèpa aéjii kêe). Â, na pàara-bà, âna pacòobé tèpa Isaraéla gée napô kàra, â rà pâra nau pwa karapuu naa napô *Babulona. ");
INSERT INTO priNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Â gée na càùé, â wà tèpa jojooro Iésu, âna: Chéaltiel Zorobabel ");
INSERT INTO priNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Abihou Éliakim Azor ");
INSERT INTO priNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Sadok Akim Élioud ");
INSERT INTO priNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Éléazar Matthan Iakobo ");
INSERT INTO priNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Ioséfa. Wà tô wâdà Ioséfa, âna wà Maria, tô nyaa kà Iésu, na pitunee têe pâ Kériso. ");
INSERT INTO priNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Wàilà diri pwiri, ê jéû tèpa jojooro Iésu Kériso. Tapoo gée goo Abéraama, tèepaa naa goo Davita, âna po 14 naneeâboro. Â tapoo gée goo Davita, tèepaa naa goro pai còobé kâra ê Ba Isaraéla gée Juda pâ naa Babulona, âna po 14 naneeâboro. Â géewê, â po 14 naneeâboro tèepaa naa goo pai pitèpa wà pwi *Mesia. ");
INSERT INTO priNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Wàéni ê jèkutâ goro pai pitèpa wà Iésu Kériso, pwi Mesia: Wà Maria, tô nyaa kêe, âna ru bwaa ipwa câbawâdé ma wà Ioséfa. Â béaari ê pai piéa kàru, âna é jèe nyarana wà Maria, na é naigé mee ê *Nyuâaê Pwicîri. ");
INSERT INTO priNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Â é niimiri wà Ioséfa pâ, na ée panuâ Maria. Êco na é pwi âboro na é pitòimiriê, êkaa na câé caa inapàpari, ba na câé caa kamu wà Maria na ara âboro. ");
INSERT INTO priNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","É dau pinünüma naa goo, â géewê, â é mwa côo naa na naurune pwi jè *angela kà Pwi Ukai, na é ina têe pâ: «Ioséfa, pwi gòobàra Davita, gà cibwaa piwâ na gà popa wà Maria. Ba napwa naa goo ê èpo paao na wâgooé, âna é me gée goro ê Nyuâaê Pwicîri. ");
INSERT INTO priNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Â naa mwa pitèpaé, â gà mwa pitunee têe pâ Iésu. Ba o mwa wàé kaa na upa ê Ba kêe gée na tojii.» ");
INSERT INTO priNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Â diri ê pâ muru bèepwiri, âna tèepaa, ba na pacoo i pwi ia é ina wà Pwi Ukai, na é naigé mee pwi *péroféta kêe, pâ: ");
INSERT INTO priNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Ée mwa nyarana wà i tô èpo dopwa. Â ée mwa pitàmari pwi nari âboro èpo paao. Â o pitunee têe pâ Émanuéla, na pai ina wèe pâ, wà Pwiduée, âna é wâjaajè. ");
INSERT INTO priNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Ûna é tàcî wà Ioséfa, â é pacoo ê pwina é ina têe i pwi angela. Â é popa wà Maria ma é wâdèe. ");
INSERT INTO priNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Êco na càru caa ipuu, tiagoro na wà Maria, âna é mwa pitàmari i pwi nari èpo. Â wà Ioséfa, âna é nama nee Iésu. ");
INSERT INTO priNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Pitèpa Iésu naa Bétéléma wâ *Judée, na pàara kà ukai *Héroda. Â wà pàra tèpa maagoi—tèpa tàmanga na rà câmu goro îricò—âna rà me gée na é too wê i tòotù. Â rà tèepaa naa *Iérusaléma. ");
INSERT INTO priNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Â rà pitawèeri tèpa âboro wê pâ: «É wâpà pwi nari èpo na pitèpaé, wà pwina ée mwa pâra nau pwi ukai kà tèpa *Juif? Ba bà côo ê îricò kêe, na é tèepaa, câmu kâra pai pitèpaé. Êkaa na bà me nau pipwamainaê, ma naa têe âraimeai kâbà.» ");
INSERT INTO priNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Â wà ukai Héroda, âna é têre ê jèkutâ goro pai tèepaa me kà tèpa maagoi ma ê pwina rà ina. Â gùmagù ê pwâranümee. Â wà diri tàpé Iérusaléma, âna wâgotàra. ");
INSERT INTO priNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Â é papitiri diri tèpa caa kà tèpa pwa *ârapwaailò wà Héroda, ma wà tèpa *dotée goro ê Naèà. Â é tawèerirà pâ: «Pwiri wâpà ê ére na o pitèpa naawê i pwi *Mesia na guwà tapacîê?» ");
INSERT INTO priNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Â rà tòpi têe pâ: «Naa Bétéléma, wâ Judée. Ba wàéni ê popai kà Pwiduée, na ia é jèe wii wà pwi *péroféta, pâ: ");
INSERT INTO priNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Cidòri nyuâa napô Bétéléma, napô gée *Juda! Pwamuru naa googà jii pàra napô! Ée còobé gée jaagà pwi ukai na maina; pwi a wéaari ê Ba Isaraéla, pwi Ba na Ba kôo.» Michée 5.1 ");
INSERT INTO priNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Géewê, â é todà tèpa maagoi wà Héroda. Ûna wàilà co, â é ina tàra pâ: «Guwà ina tôo bwàti i pwi pàara na guwà tapoo côo na i îricò.» ");
INSERT INTO priNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Ûna rà ina têe, â é panuârà pâ naa Bétéléma, ma ina tàra pâ: «Guwà pâ nau mudàra bwàti i pwi nari èpo. Â wiàna guwà pâmariê, â guwà wâjué me côwâ, nau ina tôo. Ba nümoo mwara dàra pâra, nau ipwamainaê ma naa têe âraimeai kôo.» ");
INSERT INTO priNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Nabwé, â rà còpòo wà tèpa maagoi. Â rà jèu côo mwara i pwi îricò, â é tòcia tàra ê naigé. Â rà pâra wiâê, â na é tèepaa pâ, naa gòro i pwi wâ na tâa na i pwi nari èpo, â é coo. ");
INSERT INTO priNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Ûna rà côo pâ é coo wê i îricò, â rà nye dau ipwàdée kaa. ");
INSERT INTO priNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Â rà tò naa na i wâ, â rà pâmari i pwi nari èpo ma Maria, tô nyaa kêe. Â rà tùu jùrurà ma ipwamaina i pwi nari èpo. Â rà pwa ma èrù pâ êre atà kàra, â rà naa têe ê jèpa âraimeai kàra, na dau maina wâri wèe—mwani mii, ma encens pâ dà na ûrea na jè cîri ma ê jawé ûrea na nee myrrhe. ");
INSERT INTO priNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Gée na càùé, â é ina tàra wà Pwiduée naa na naurune pâ, na rà cibwaa wâjué côwâ naa jaa Héroda. Â rà pa cè naigé na ité, ba na rà wâjué côwâ naa napô kàra. ");
INSERT INTO priNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Ûna rà jèe wâjué côwâ wà tèpa maagoi, â é pwa naurune wà Ioséfa. Â é côo wà pwi *angela, na é ina têe pâ: «Gà wàcî! Gà cimadò, â gà popa i du duanaî, â gà uparu, pâ naa *Aigupito! Ba wà Héroda, âna é pwa na é mudàra i pwi nari èpo, ba na pòtàmwereê. Â guwà tâa wê tiagoro tòotù na go mwa patùragà.» ");
INSERT INTO priNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Â é cimadò wà Ioséfa, â é popa i du duanaî, â rà pâra na ne, naa napô Aigupito. ");
INSERT INTO priNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Â rà tâa wê, tiagoro pai bà kà Héroda. Diri pâ muru bèepwiri, âna tèepaa, ba na pacoo i pwi ia é ina wà Pwi Ukai, na é naigé mee pwi péroféta kêe, pâ: Go jèe todà me pwi naîô, â go pacòobée gée Aigupito. ");
INSERT INTO priNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Wà Héroda, âna é côo pâ rà ipwa tûâ têe wà tèpa maagoi. Â é nye dau putàmu kaa. Â é nama pòtàmwara diri pâ nari èpo paao, na wâboo côwâ kâra ârailu naja, wâna diri Bétéléma, ma pâ napô goro jènereê. Ba é tâmogòori gée goo tèpa maagoi i pàara na é tèepaa na, i îricò. ");
INSERT INTO priNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Â, na wàrapwiri, â é pacoo i pwi ia é ina wà Pwiduée, na é naigé mee wà péroféta Iéremia, pâ: ");
INSERT INTO priNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Pwâra i ma pijinünü na Rama! É imuru pâ èpo kêe Rachel. Pwacoé ma patàmarùé, ba jèe tiàurà diri. Jérémie 31.15 ");
INSERT INTO priNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Gée na càùru ê pai bà kà Héroda, â é pwa naurune wà Ioséfa na Aigupito. Â é côo pwi angela kà Pwi Ukai, ");
INSERT INTO priNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","na é ina têe pâ: «Gà cimadò, â gà popa i du duanaî, â gà wâjué côwâ paru pâ naa napô *Isaraéla. Ba rà jèe bà wà tàpé na ia nümarà na rà pòtàmwara i nari èpo.» ");
INSERT INTO priNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Â é cimadò wà Ioséfa, â é poparu wâjué naa napô Isaraéla. ");
INSERT INTO priNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Êco na é têre pâ wà Arkélaos, pwina naî Héroda, âna é popa pwâra ukai naa Judée, gée na càùru pai bà kà caa kêe. Â wâgotêe na é wâjué côwâ naawê. Â é ina têe mwara wà Pwi Ukai naa na naurune pâ, na rà pâra naa napô Galilée. ");
INSERT INTO priNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Â rà tâa na jè village na ina goo pâ Nazareth. Êkaa na pacoo ê pai jèe ina kà tèpa péroféta pâ, wà pwi Mesia, âna o pwi âboro gée Nazareth. ");
INSERT INTO priNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Gée na càùru pâ naja na wâru, â é cimadò wà pwi âboro na nee *Ioane Pwi a piupwaa. Â é tâa namaré wâ *Judée, â é picémara târa pâ âboro na rà medarié. Â é ina tàra pâ: ");
INSERT INTO priNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","«Guwà pinünüma ma guwà pitòotéri ê wâro kàwà! Ba jèe wâmwünyabwe ê *Mwaciri napwéretòotù!» ");
INSERT INTO priNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Wà Ioane, âna wàé kaa, na ia é jèe picémaraê wà *péroféta Isaia, pâ: Pwa pwi âboro naa namaré na é tomara too: “Ée me Pwi Ukai. Pwabwàti ê naigé! Pwa ma bàracaari pwi ére na ée pâ wê!” Ésaïe 40.3 ");
INSERT INTO priNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Napwa naa goo Ioane, âna é coona ê ârabwée na pwa goro wàra kaamela. Â é piié goro karapuu parawére macii. Â é uti kòrée ma wâdo narapuutâ. ");
INSERT INTO priNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Â po dau wâru pâ âboro na rà nye tà medarié naa namaré—gée *Iérusaléma, ma diri ê napô Judée, ma ê pâ ére goro nairiwâ Ioridano. ");
INSERT INTO priNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Â rà inapàpari ê pâ èpà kàra, na ara ê pâ âboro diri. Â é *upwaarà naa nairiwâ Ioridano. ");
INSERT INTO priNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Wâru mwara tèpa âboro gée na du ditàra pwapwicîri kà tèpa *Juif, wà tèpa *Farasaio ma tèpa *Sadukaio, na rà medari Ioane, ba na é upwaarà. Ûna é côorà, â é ina tàra pâ: «Guwà pâ tèpa nari dòèa, ma tèpa pwâ! Wàilàapà na ina tàwà pâ, guwà o udò jii ê wârimuru, na ée mwa naa tàwà wà Pwiduée? ");
INSERT INTO priNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Bwa! Guwà mara pwa cè tûâ cèna wâdé, târa ma o paari pâ, jèe pitòotéri ê wâro kàwà! ");
INSERT INTO priNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","É, gona guwà tà niimiri pâ, guwà udò, gée goo na wà *Abéraama, âna é pwi jojoorowà? Bwa! Piticèmuru naa goo. Ba wiàna nümee, â o pâri wà Pwiduée ma é bii ê pâ atü bèeni ma rà o tèpa gòobàra Abéraama! ");
INSERT INTO priNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","«É jèe tà pwabwàti ê gi kêe wà Pwiduée. Â ée mwa tépàgà naa na wàé diri ê pâ upwâra na càcaa wâdé ê pâ pwêe, ma cîri naa na ânye!» ");
INSERT INTO priNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","«Wâgo, âna go upwaawà goro jawé, târa ma o paari pâ guwà pitòotéri ê wâro kàwà. Êco na wà pwina ée mwa me pwicò kôo, âna ée mwa upwaawà goro Nyuâaê Pwicîri ma ânye. Wàé, âna dau pwa pàtàmee jiio, â càcaa pâriô ma go tipi ê otàpwe goro du wâraâê ba é Pwi Ukai. ");
INSERT INTO priNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","É jèe nye tà pwabwàtié, ba na é pitèi tèpa âboro. Â ée mwa naaitiri tàpé na rà wâdé jii tàpé na rà èpà, pwacèwii pai pinaaitiri ê pudòro upwâra jii ê parawée. Â é tòimiri ê pudòé, â é cîri parawée naa na ânye na ticè pwâadèreè.» ");
INSERT INTO priNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Gée na càùé, â é pâra wà Iésu gée napô Galilée, naa nairiwâ Ioridano. Â é pâdari wà Ioane, ba na é upwaaé. ");
INSERT INTO priNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Êco na càcaa nüma wà Ioane na é pwa, â é ina tà Iésu pâ: «Gona cina gà medario? Na càcaa pâri ma go upwaagà. Wâdé na gà upwaao.» ");
INSERT INTO priNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Â é tòpi têe wà Iésu pâ: «Nye wâdé ê pwina gà ina. Êco na, ni, âna wâdé na ju pacoo ê pwina *tàrù na ara Pwiduée.» Êkaa na é upwaaé wà Ioane, wàra pai ina kêe. ");
INSERT INTO priNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Ûna é cimadò gée najawé wà Iésu, â nye tàpirié kaa ê napwéretòotù, â é côo ê Nyuâaê Pwicîri kà Pwiduée, na é gére boome naa gòé, pwacèwii ê déamu. ");
INSERT INTO priNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Â é têre ê pwâratùra me gée napwéretòotù na ina pâ: «Wà pwi bèepwiri, âna Pwina naîô na caapwi co na go dau meaarié. Wàé kaa na go jèe nye pitòrigarié, ba dau wânümoo têe.» ");
INSERT INTO priNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Gée na càùé, â é popa wà Iésu ê Nyuâaê Pwicîri kà Pwiduée naa namaré, ba na é tacaié wà *Caatana, pwi a cicarajè. ");
INSERT INTO priNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Â câé caa ija wà Iésu naa na 40 tòotù, ba é *ipwanya. Â é tapoo copwa. ");
INSERT INTO priNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Â é pâdarié wà Caatana, pwi a tacaijè, â é ina têe pâ: «Wiàna gà *Pwina naî Pwiduée, â gà bii ê pâ atü bèeni ma poloa!» ");
INSERT INTO priNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Â é tòpi têe wà Iésu pâ: «Jèe nye wii naa na *Tii Pwicîri pâ: Câé caa wâro co goro poloa wà pwi âboro, â é nye wâro goro diri pâ popai na é ina wà Pwiduée.» ");
INSERT INTO priNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Â é popa Iésu pâ naa *Iérusaléma, ville na pwicîri. Â é popaé too naa gòro pûru *Wâra pwapwicîri. ");
INSERT INTO priNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Â é ina têe pâ: «Wiàna gà Pwina naî Pwiduée, â gà êgò géeni! Ba jèe wii naa na Tii Pwicîri pâ: Ée mwa tûâri tà tèpa *angela kêe, wà Pwi Ukai Pwiduée, ba na rà wéaarigà. Rà mwa tapigà. O càcaa tanoori âgà naa gòro atü.» Psaume 91.11–12 ");
INSERT INTO priNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Â é tòpi têe wà Iésu pâ: «Bwa. Ba jèe nye wii mwara naa na Tii Pwicîri pâ: Gà cibwaa pigàdà Pwi Ukai Pwiduée'gà.» ");
INSERT INTO priNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","É popaé mwara wà Caatana naa gòro jè jaa na dau wâdòiti. Â é paari têe diri ê pâ napô ma mwaciri gòropuu bau ê pwényuâa kàra ma ê neemururà. ");
INSERT INTO priNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Â é ina têe pâ: «Wiàna gà tùu jùrugà arao ma gà ipwamainaô, â go mwa naa tâgà diri ê pâ pwi bèepwiri.» ");
INSERT INTO priNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Â é ina têe wà Iésu pâ: «Gà pâra jiio, co Caatana! Ba jèe nye wii naa na Tii Pwicîri, pâ: Gà ipwamaina Pwi Ukai Pwiduée'gà, â nye wàé co, na gà ipwa âboro kîri kêe.» ");
INSERT INTO priNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Nabwé, â é panuâ Iésu wà Caatana, â rà medari Iésu pâ angela, â rà ipwa âboro kîri kêe. ");
INSERT INTO priNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Gée na càùé, â é têre wà Iésu pâ, jèe tòpò wà *Ioane Pwi a piupwaa naa na karapuu. Â é pâra wà Iésu naa napô Galilée. ");
INSERT INTO priNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Â câé caa tâa Nazareth, â é pâra nau pitâa Capernaüm, bàra nawià Galilée, wâna ére Zabulon ma Neftali. ");
INSERT INTO priNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Êkaa na pacoo i pwi ia é ina wà Pwiduée, na é naigé mee *péroféta Isaia pâ: ");
INSERT INTO priNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Têre, co du napô Zabulon ma Neftali— gàu wâmwünyabweri nawià; na ére gée côwâ kâra Ioridano; wâgàu na Galilée; napô na piwâru Ba na, na càra caa pwi Ba kôo. ");
INSERT INTO priNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Go ina târa pwi Ba kôo: Ba kôo na tâa na bàutê —bàutê na dau cikautê. Té mariê ê tòotù; èpàparié pwéelaa na pwâra. É pawâroé côwâ wà Pwiduée! Ésaïe 8.23–9.1 ");
INSERT INTO priNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Â nye tapoo kaa naawê, na wà Iésu, âna é picémara ê popai târa pâ âboro. Â é ina tàra pâ: «Guwà pinünüma ma pitòotéri ê wâro kàwà! Ba jèe wâmwünyabwe ê *Mwaciri napwéretòotù!» ");
INSERT INTO priNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Na jè tòotù, â é pâra wii bàrawià Galilée wà Iésu. Â é côo tupédu âboro na tupédu a taa ârawéà—wà Simona na ina gooé pâ Pétéru, ma wà André, pwi aéjii kêe. Â ru gére tòpò puà kàru naa nawià. ");
INSERT INTO priNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Â é ina tàru pâ: «Gàu me wiâô, â go mwa nama gàu tupédu a pwapuàri âboro.» ");
INSERT INTO priNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Â ru nye naaco kaa ê puà kàru, â ru pâra wiâ Iésu. ");
INSERT INTO priNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Rà tàpo dau pipâra pâ, â wà Iésu, âna é côo Jacques ma Ioane, tupédu naî Zébédée. Rà tàgére pwàni puà gòro wànga ma wà caa kàru. Â é todàru wà Iésu, ");
INSERT INTO priNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","â ru nye naaco kaa wà caa kàru, ma i wànga, â ru pâra wiâê. ");
INSERT INTO priNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","É pâra pitiri napô Galilée wà Iésu, â é pacâmuri tèpa âboro naa na pâ *wâra pitapitiri. Â é picémara ê *Picémara Wâdé goro ê Mwaciri napwéretòotù. Â é nama tiàu diri pâ maagé ma aré kâra pâ âboro. ");
INSERT INTO priNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Â rà têre jèkutâ gooé pitiri na province Syrie. Â rà cia medarié wà tàpé na rà aré, ma ê pâ na jèpapara maagé—wà tàpé na tâa goorà ê pâ duée, ma wà tàpé na rà céca ma wà tàpé na rà pitàbwamwa. Â é cau nama tiàu maagé kàra wà Iésu. ");
INSERT INTO priNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Wâru pâ âboro, na rà pé gére pâra wiâ Iésu—âboro me gée Galilée, ma gée na ére goro Dix Villes. Â rà me mwara gée Iérusaléma, ma diri ê napô *Judée, ma gée na ére pâ côwâ kâra nairiwâ Ioridano. ");
INSERT INTO priNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Ûna é côo pâ âboro na wâru wà Iésu, na rà gére me, â é too naa gòrojaa, â é tâaboo, ba na é pacâmurirà. Â rà me naa jaaé tàpé na rà pâra wiâê. ");
INSERT INTO priNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Â é ina tàra pâ: ");
INSERT INTO priNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","«Cidòri nyuâa tàpé na rà ipakîrirà, ba o kàra ê *Mwaciri napwéretòotù! ");
INSERT INTO priNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Cidòri nyuâa tàpé na rà i, ba ée mwa patàmarùrà wà Pwiduée! ");
INSERT INTO priNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Cidòri nyuâa tàpé na moo pwâranümarà, ba o mwa kàra ê gòropuu diri! ");
INSERT INTO priNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Cidòri nyuâa tàpé na rà copwa dàra câbawâdé kà Pwiduée, ba ée mwa naa tàra diri pwina nümarà goo! ");
INSERT INTO priNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Cidòri nyuâa tàpé na rà imeai, ba ée mwa imeairà wà Pwiduée! ");
INSERT INTO priNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Cidòri nyuâa tàpé na tâbawêe pwâranümarà naa goo Pwiduée, ba rà o mwa côoê! ");
INSERT INTO priNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Cidòri nyuâa tàpé na rà pinaanapô bèepirà, ba ée mwa tunee tàra wà Pwiduée pâ, tèpa naîê! ");
INSERT INTO priNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Cidòri nyuâa tàpé na pièpàrirà gée goro pai pitêre dàra kàra ê popai kà Pwiduée. Ba o mwa kàra ê Mwaciri napwéretòotù. ");
INSERT INTO priNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Cidòri nyuâawà, wiàna rà tobapwâwà ma pièpàriwà, gée goro na guwà tèpa âboro kôo. ");
INSERT INTO priNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Ba rà jèe nye wàrapwiri tà tèpa *péroféta na rà pâbéaa kàwà. Â guwà ipwàdée ma piêgòtùru, ba o maina pumara wakè kàwà naanidò *napwéretòotù!» ");
INSERT INTO priNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","«Guwà tèpa còo târa gòropuu. Â wiàna ê còo, âna tubatiàu ê nümee, â jè o wànau târa ma jè o pwa ma tèepaa côwâ ê nümee? Bwa. O jèe piticèmuru naa goo. Â o tü naa gòroigé, â rà o mwa pâra gò pâ âboro. ");
INSERT INTO priNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","«Guwà tèpa pwéelaa kâra gòropuu, pwacèwii ê jè ville na é tâa gòrojaa, ba o pwacoé ma jè cîdaée. ");
INSERT INTO priNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Â ipaiwà mwara naa goo ê jè wâra ânye. Ba câjè caa nuri, ma jè mwa caa naapwàniri ê pwéelaa kêe! Bwa! Jè nye tòpò dòiti. Â é pwéelaa goo diri ê pâ âboro, na rà tâa na ê wâ. ");
INSERT INTO priNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Â wâdé na wàrapwiri ê pwéelaa kàwà! Wâdé na é tèepaa na ara diri tèpa âboro. Â géewê, âna rà o côo ê pâ muru na wâdé na guwà pwa. Â rà o pwamaina Pwiduée, Caa kàwà, na é wânidò napwéretòotù.» ");
INSERT INTO priNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","«Guwà cibwaa niimiri pâ, go tèepaa nau nama tiàu ê *Naèà kà Moosé, ma ê pâ auina kà tèpa péroféta. Bwa, go tèepaa, ba na go pacoo. ");
INSERT INTO priNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Guwà têre bwàti, ba go ina tàwà ê âjupâra pâ: Ûna bwaa tâa ê napwéretòotù ma gòropuu, â o càcaa câtùra cè ji caapwi âmu gée goro ê Naèà, tiagoro na pacoo diri ê pâ namuru. ");
INSERT INTO priNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","«Gée goo pwiri, â wà pwi âboro na é tajii ê ji caapwi naèà na dau kîri, â é picòo tà pàra tàpé ma rà ipwacèwiié, âna wà pwiibà, âna ée dau kîri naa na Mwaciri napwéretòotù. Â wà pwi âboro na é pâra wiâra bwàti ê Naèà, ma picòo tà pàra tàpé ma rà wàrapwiri, âna wà pwiibà, âna ée dau maina naa na Mwaciri napwéretòotù. ");
INSERT INTO priNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Üu, wâdé na guwà pitêre dàra ê câbawâdé kà Pwiduée, jii pai pwa kà tèpa *dotée goro ê Naèà ma wà tèpa *Farasaio. Ba wiàna càcaa wàrapwiri, â o câguwà caa tò naa na Mwaciri napwéretòotù.» ");
INSERT INTO priNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","«Guwà tâmogòori bwàti pâ é jèe ina wà Pwiduée tà tèpa jojoorojè, pâ: Gà cibwaa tétàmwara âboro. Â wà pwina é tétàmwara pwi jèpwi, âna o popaé pâdari pwi a pitèimuru, ma é pwa wârimuru têe. ");
INSERT INTO priNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Â wâgo, âna go ina pâ: Wiàna gà putàmu naa goo pwi a cèikî béegà, â gà o mwa coo ara Pwiduée, na ée mwa pitèigà. Â wiàna gà ina tà pwi a cèikî béegà, pâ, “Gà pé pigù!” âna o popagà pâ naa na wâra pitèimuru kà Pwiduée. Â wiàna gà piduri pwi a cèikî béegà, â gà tapacîri wârimuru na dau maina, naa na ére na jèe maagé ma tòina naawê. ");
INSERT INTO priNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","«Jè jèe côo cai ni: Gà pame ê âraimeai'gà naa na wâra pwapwicîri. Â tèepaa me naa na pwâranümagà ê pwina wânabibiu kàu ma wà pwi a cèikî béegà. ");
INSERT INTO priNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","Â, na wàrapwiri, wâdé na gà tàpo naaco naawê ê âraimeai'gà. Â gà wâjué côwâ, ma gàu mara pinaanapô ma wà pwi aéjii'gà. Â nabwé, â gà mwa wâjué côwâ, ma gà mwa bàra naa i âraimeai'gà. ");
INSERT INTO priNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","«Wiàna é piciapwâ googà wà pwi jèpwi, â gàu mara pinaanapô ma wàé, wiàna gàu bwaa gére wâ naigé pâ naa na aupitèimuru. Ba é péa panuâgà tà pwi a pitèimuru, na ée mwa panuâgà târa pwàliici ma tòpògà naa na karapuu. ");
INSERT INTO priNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Â go ina tâgà ê âjupâra pâ: O câgà caa còobé gée na karapuu, wiàna ina pâ, bwaa câgà caa pé wâri diri ê wârimuru'gà!» ");
INSERT INTO priNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","«Guwà tâmogòori bwàti pâ é jèe ina wà Pwiduée pâ: Gà cibwaa toomura (gà cibwaa cîâa jii tô wâdàgà, é, wà pwi éagà). ");
INSERT INTO priNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","«Â wâgo, âna go ina pâ: Wiàna gà ucâri wâdà pwi jèpwi, â gà wâdéarié, â pwacèwii na gàu jèe pipuu. ");
INSERT INTO priNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Ba wiàna majoroé ê âraporomeegà, na gà pitanami goo, ma gà pwa na èpà, â gà èrù tâjii, â gà tütâjii naaiti jiigà! Ba o wâdé ba kâgà wiàna tiàu jè ére naiigà, jii wiàna tâbawêe ê naiigà, â tügà naa na ére na gà pwamaagé côo naawê! ");
INSERT INTO priNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Â wiàna majoroé ê îgà étò na gà pwa na èpà, â gà tépàgà, â gà tütâjii naaiti jiigà! Ba bwaa wâdé ba kâgà wiàna tiàu ê jè ére naiigà, jii wiàna tâbawêe ê naiigà, â gà pâra naa na ére na jè maagé ma tòina naawê!» ");
INSERT INTO priNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","«Jèe ina mwara pâ: Wà pwina é tü târa ê wâdèe, âna wâdé na é pwa cè tii târa ma pitapàgà piéa. ");
INSERT INTO priNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Êco na wâgo, âna go ina pâ: Gà cibwaa tü tà tô wâdàgà na càcaa tô a toomura (câé caa cîâa jiigà). Ba gà péa panuâê, ba na é toomura, wiàna é jèu piéa ma cè pwi jèpwi. Â wà mwara pwi jè âboro na é popaé ma é wâdèe, âna é toomura.» ");
INSERT INTO priNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","«Guwà tâmogòori bwàti pâ é jèe ina wà Pwiduée tà tèpa jojoorojè, pâ: Gà cibwaa pwâ goo ê pai pwataâboro'gà. Wâdé na gà pacoo ê *auipwataâboro'gà na ara Pwi Ukai. ");
INSERT INTO priNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Â wâgo, âna go ina pâ: Wiàna gà *ipwataâboro, â gà cibwaa ina neere ére pwicîri, ba na *paâjupâra ê auipwataâboro'gà. «Gà cibwaa ina “napwéretòotù” ba autâa pwicîri kà Pwiduée; ");
INSERT INTO priNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","é, “gòropuu” ba aucò kêe; é, “*Iérusaléma” ba ville kêe, wàé na é Ukai maina kâjè. ");
INSERT INTO priNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Â gà cibwaa ina mwara pâ: “Go ipwataâboro gòro pûruô” ba càcaa wâgà na gà tâmogòori nama pwaa, é, duu ê caapwi wàrapûrugà. ");
INSERT INTO priNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Wiàna nümagà na gà üuri, â gà ina co pâ “üu”. Â wiàna tàutâgà, â gà ina co pâ “bwa”. Ba cè gòobèreè, âna me gée jaa *Caatana, wà Pwi âboro èpà.» ");
INSERT INTO priNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","«Guwà tâmogòori pâ jèe ina pâ: Âraporomee târa âraporomee, ma poropwâ târa poropwâ. ");
INSERT INTO priNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","«Êco na wâgo, âna go ina pâ: Wiàna é pwa na èpà tâgà wà pwi jè âboro, â gà cibwaa pitôowâri têe. Â wiàna é tamagéri ê upwaégà étò, â gà panuâ têe mwara jèpwi. ");
INSERT INTO priNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Â wiàna é popagà pâ naa na wâra pitèimuru pwi jè âboro, ma é popa cimiici'gà, â gà naa têe mwara ê palito'gà. ");
INSERT INTO priNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Â wiàna é tacoo googà wà pwi jè coda roma ma gà popa ê atà kêe naa na caapwi kilomètre, â gà popa naa na ârailu kilomètres. ");
INSERT INTO priNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Wiàna é ilari jiigà cè jè muru, wà pwi jè âboro, â gà naa têe. Â wiàna é ilari târa mwa pitôowâri, â gà cibwaa iauri jiié.» ");
INSERT INTO priNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","«Guwà tâmogòori bwàti ê auina bèeni: Gà meaari tèpa jèneregà. Â rà ina mwara pàra tàpé pâ: “Â gà èpàri tàpé na rà èpàrigà.” ");
INSERT INTO priNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Êco na wâgo, âna go ina pâ: Gà meaari tàpé na rà èpàrigà, â gà pwapwicîri ba kà tàpé na rà pwa tâgà na èpà. ");
INSERT INTO priNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Â wiàna gà wàrapwiri, â gà pwi âji naî pwi Caa'gà, na é wânidò napwéretòotù. Ba é nye nama té ê tòotù kêe, naa gò tàpé na rà wâdé, ma wà tàpé na rà èpà. Â é nye nama popaa, naa gò tàpé na rà papwicîriê, ma wà tàpé na càra caa papwicîriê. ");
INSERT INTO priNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","«Ba wiàna gà wâdéari co tàpé na rà wâdéarigà, â cina gà tapacîri cè câmagà jii Pwiduée? Ba wà tèpa *tò mwani wâripû na rà tèpa pwâ ma iau âna rà nye pwa mwara ê pwiibà. ");
INSERT INTO priNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Â wiàna gà nye pwabwàcu ma pacidòri co tèpa béegà, â pé dà cèna gà pwa cèna piwéna? Ba wà tàpé na càra caa tâmogòori Pwiduée, âna rà nye pwa mwara ê pwiibà! ");
INSERT INTO priNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Â wâgà, âna wâdé na gà tâbawêe naa na pimeaari kà Pwiduée. Â gà ipwacèwii pwi Caa'gà na é wânidò napwéretòotù, na é tâbawêe.» ");
INSERT INTO priNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","É ina mwara wà Iésu pâ: «Wâdé na gà pwa ê câbawâdé kà Pwiduée ma pacoo ê *Naèà. Êco na gà ipwacôoco! Gà cibwaa pwa na ara pâ âboro, ma rà o pi-inagà ba wâdé. Ba wiàna wàrapwiri, â o câgà caa tòpi ê câmagà naa jaa Caa, na é wânidò *napwéretòotù. ");
INSERT INTO priNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Êkaa na, na gà naa mwani tà tàpé na ticè kàra, â gà cibwaa ipaarigà, pwacèwii tèpa ‘pwàniri èpà’. Ba rà pwa naa na ê pâ *wâra pitapitiri, ma ê pâ autâa kâra âboro na pâ village. Ba rà imudàra, ba na rà ipwamainarà wà tèpa âboro. Â go ina âjupâra pâ: Rà jèe nye tòpi ê câmarà! ");
INSERT INTO priNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","4","«Â wâgà, âna gà cibwaa ipaarigà na gà pwa na wâdé. Na gà naa mwani tà tàpé na ticè kàra, goro îgà étò, â càcaa wâdé na é tâmogòori ê îgà aèmwü! Â wà Pwiduée Caa'gà, na é wânidò napwéretòotù, na é côo diri pâ muru, âna ée mwa naa cè câmagà.» ");
INSERT INTO priNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","«Na guwà pwapwicîri, â guwà cibwaa pwacèwii tèpa ‘pwàniri èpà’. Ba rà cima nau pwapwicîri, naa na pâ wâra pitapitiri ma autâa kà tèpa âboro na pâ ville. Ba wâdé tàra na rà o côorà pâ âboro. Â guwà têre bwàti, ba go ina tàwà ê âjupâra pâ: Rà jèe nye tòpi ê câmarà. ");
INSERT INTO priNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Â wâgà, âna wiàna gà pwapwicîri, â gà tò naa na wâ'gà, wâna cè naditàrawâ. Â gà târi goropwârawâ, â gà pwapwicîri tà Pwiduée Caa'gà, na câjè caa côoê. Â é côo ê pwina gà pwa, naa na wâbinyiri, â ée mwa naa cè câmagà. ");
INSERT INTO priNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","«Â, na guwà pwapwicîri, â guwà cibwaa pwa nyakâra tùra, pwacèwii pàra tèpa âboro, na càra caa tâmogòori pwi âji Pwiduée na é caapwi co. Ba rà tà niimiri pâ é têrerà, gée goro pai wâru ê pâ pwina rà ina. ");
INSERT INTO priNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Â guwà cibwaa ipwacèwiirà. Ba wà Pwiduée Caa kàwà, âna é tâmogòori ê pwina nümawà goo, béaari ê pai pi-ila kàwà. ");
INSERT INTO priNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","«Â guwà o wàrani târa cè pai pwapwicîri kàwà: “Pwi Caa kâbà na wânidò napwéretòotù; Wâdé naa papwicîri ê neegà. ");
INSERT INTO priNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Wâdé naa pacoo ê Mwaciri'gà. Wâdé naa pwa câbawâdé'gà naani gòropuu, ma pwacèwii naanidò napwéretòotù. ");
INSERT INTO priNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Gà naa tâbà cè utimuru cèna pâribà na diri pâ tòotù. ");
INSERT INTO priNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Gà pwanauri pâ èpà kâbà, pwacèwii na bà pwanauri tàra ê pâ èpà kàra. ");
INSERT INTO priNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Gà cibwaa panuâbà târa tacai. Gà upabà jii ê èpà. {Ba nye tâa tâgà ê Mwaciri, ma pàtàmee, ma pwényuâa, dàra gòiri awé. Amen.}” ");
INSERT INTO priNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","«Ba go ina tàwà pâ: Na guwà pwanauri tà pàra tàpé ê pâ èpà na rà pwa, â é pwanauri tàwà mwara wà Pwiduée Caa kàwà nidò napwéretòotù. ");
INSERT INTO priNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Â wiàna câguwà caa pwanauri ê èpà kà pàra tàpé, â wà pwi Caa kàwà, âna o câé caa pwanauri tàwà ê èpà kàwà.» ");
INSERT INTO priNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","«Na gà *ipwanya (na gà panuâ ija'gà ba na gà pwapwicîri), â gà cibwaa ipaarigà, pwacèwii tèpa ‘pwàniri èpà’. Ba rà paari naa na naporomeerà pâ rà ipwanya, ba na o côorà diri ê âboro! Êkaa na go ina âjupâra pâ: Rà jèe nye tòpi câmarà. ");
INSERT INTO priNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Â wâgà, âna, na gà ipwanya, â gà nuwa naporomeegà, â gà tuti pûrugà. ");
INSERT INTO priNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Â o càra caa côo pâ âboro pâ, gà ipwanya. Êco na wà Pwiduée Caa'gà, na câjè caa côoê, âna é côo ê pwina gà pwa naa na wâbinyiri, â ée mwa naa cè câmagà.» ");
INSERT INTO priNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","«Gà cibwaa mudàra pâ wâdé gòropuu, ba péa mura jiigà, é, péa wai ma botére ma tiàu. ");
INSERT INTO priNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Gà wéaari pâ wâdé'gà naa jaa Pwiduée naa napwéretòotù. Ba ticè madé na uti, ma ticè waaca na iri. Â o càcaa wai ma botére, â ticè a mura wê. ");
INSERT INTO priNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Ba ê pwâranümagà, âna, é wâna é wêe ê wâdé'gà. ");
INSERT INTO priNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","«Guwà têre, ê âraporomeejè, âna ê pwéelaa kâra naiijè. Â wiàna nye wâdé ê âraporomeejè, â diri ê naiijè, âna é tâa na pwéelaa. ");
INSERT INTO priNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Â wiàna èpà ê âraporomeejè, â diri ê naiijè, âna é tâa na bàutê. Â wiàna ê pwéelaa naa wâgoojè âna é pâra nau bàutê, â o mwa nye dau bàutê kaa!» ");
INSERT INTO priNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","«Nye ticè âboro cèna pâri ma é piênawéna bwàti kâra ârailu ukai, gée na diri ê pwâranümee. Ba ée mwa tà piênawéna bwàti kà pwi jèpwi, â ée pwa-imudiri tà pwi jèpwi. Üu, o càcaa pâri ma guwà cau piênawéna kà Pwiduée ma ê mwani!» ");
INSERT INTO priNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","«Wàépwiri ê majoroé ma go ina tàwà pâ: Guwà cibwaa géaa goro ê wâro kàwà, ma ê naiiwà. Guwà cibwaa pitawèeri pâ: “Jè o mwa ija dà?” ma “Jè o mwa coona dà?” Ba ê wâro kàwà, âna é âjimuru jii ê utimuru; â ê naiiwà, âna é âjimuru jii ârabwée! ");
INSERT INTO priNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","«Guwà jèe côo cai ê pâ marü. Ba càra caa picâmi, ma piûnya, ma càra caa tòpò cè bwà târa pâ tòotù. Êco na wà Pwiduée Caa kàwà nidò napwéretòotù, âna é nye pa-ijarà. Â gona câguwà caa dau piwéna jii ê pâ marü? Akaé! ");
INSERT INTO priNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Càcaa gée goro pai géaa goro ija ma wâdo, na guwà o nama gòiri ê wâro kàwà! ");
INSERT INTO priNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","«Â gorodà na guwà géaa mwara goro cè ârabwée kàwà? Guwà jèe côo cai ê pai cipu kâra pâ murubuké na-araé. Ba càra caa pàti, ma càra caa ta ârabwée. ");
INSERT INTO priNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Â go ina tàwà pâ: Wà pwi ukai *Solomona, naa na diri ê muugère kêe, âna ê pâ ârabwée kêe, âna càcaa dau wâdé jii ê pwi caapwi murubuké. ");
INSERT INTO priNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","«Â guwà jèe côo cai ê pâ aramwatò: É cipu nabà, â o cîri widàuru naa gòro ânye. Â wà Pwiduée, âna é naa ârabwée kàra. Â gona o câé caa naa ârabwée kàwà na piwéna jii? Nye dau kîri kaa ê cèikî kàwà! ");
INSERT INTO priNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","«Üu, guwà cibwaa géaa ma guwà ina pâ: “Jè o ija dà?” ma “Jè o wâdo dà?” ma “Jè o coona cè dà?” ");
INSERT INTO priNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Ba wà tàpé na càra caa tâmogòori Pwiduée, âna càra caa nao goro mudàra ê pâ pwiibà. Êco na wâguwà, âna wà Pwiduée Caa kàwà na é wânidò napwéretòotù, âna é nye tâmogòori ê pwina nümawà goo. ");
INSERT INTO priNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Guwà mudàra béaa ê *Mwaciri napwéretòotù, â guwà pwa ê pwina nüma Pwiduée goo, â ée mwa naa tàwà ê pwina tiàu jiiwà. ");
INSERT INTO priNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Êkaa na go ina tàwà pâ: Guwà cibwaa géaa goro tòotù widàuru, ba ê tòotù widàuru, âna ée mwa nye pwa wakè kêe. Ê géaa târa nabà, âna nye târa nabà!» ");
INSERT INTO priNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","É ina mwara wà Iésu pâ: «Gà cibwaa pitèi ma pitòti pàra tàpé, ba na o câé caa pitèigà wà Pwiduée. ");
INSERT INTO priNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Ba é pitèigà, pwacèwii ê pai pitèi kâgà wà pàra tàpé, â ée mwa pwa tâgà ê pwina gà pwa tàra! ");
INSERT INTO priNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","4","Gà dau côo bwàti ê mapûpûru na wâna âraporomee pwi aéjii'gà. Â gà niâ jai ê diopwaa kâra pàara upwâra na âraporomeegà! Â gà wànau pai ina tà pwi aéjii'gà pâ: “Nama go jèe patâjii i mapûpûru bèepwiri na âraporomeegà”? ");
INSERT INTO priNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","«Gà pwi a-ipwacôwârimuru! Gà mara patâjii béaa ê diopwaa kâra pàara upwâra bèepwiri na âraporomeegà! Â géewê, mwa bàra pwéelaa tâgà cè pai patâjii wàra ê mapûpûru wâna âraporomee pwi aéjii'gà! ");
INSERT INTO priNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","«Gà wéaari bwàti ê pwina wâdé na me gée goo Pwiduée. Ba câjè caa naa târa pâ akàna ê pâ pwina wâdé, ba rà péa biirà dàjè côwâ, ma utijè. Â câjè caa tü târa puàkà ê pâ perle na dau maina wâri wèe. Ba rà péa còogai.» ");
INSERT INTO priNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","«Wâdé na guwà nye tà ilari taaci jii wà Pwiduée, ba ée mwa naa tàwà. Â guwà nye tà mudàra taaci, ba guwà o mwa pâmari. Â guwà nye cùu taaci ê goropwârawâ, ba o mwa tàpiri tàwà. ");
INSERT INTO priNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Üu, ba wà pwina é ilari, âna o naa têe. Â wà pwina é mudàra, âna é pâmari. Â wà pwina é cùu ê goropwârawâ, âna o tàpiri têe. ");
INSERT INTO priNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","«O wàilàapà nawà, na o naa cè atü târa èpo kêe, wiàna é ilari jiié cè poloa? ");
INSERT INTO priNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","O wàilàapà na o naa têe cè dòèa, wiàna é ilari cè ârawéà? ");
INSERT INTO priNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Ba wâguwà, tèpa âboro èpà, âna guwà tâmogòori naa ê pwina wâdé tà tèpa nari èpo kàwà. Â wà Pwiduée Caa kàwà nidò *napwéretòotù, na é wâdé, âna ée mwa naa pâ muru na dau wâdé awé tà tàpé na rà ilari jiié.» ");
INSERT INTO priNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","«Guwà pwa tà pàra tàpé ê pâ muru na nümawà na rà pwa tàwà. Wàé kaa pwiri, ê ére ê *Naèà kà Moosé, ma êdiri pâ tii kà tèpa *péroféta.» ");
INSERT INTO priNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","«Guwà tò na ê goropwârawâ na é picu. Ba maina ê goropwârawâ pâ naa na ére na tubatiàujè awé naawê. Â ticècoé ê pai pâ naa pwi naigé-bà. Â wâru tàpé na rà pâ na. ");
INSERT INTO priNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Â nye dau picu kaa ê goropwârawâ pâ naa na ê *âji wâro. Â pwacoé ê pai pâra wii. Â càcaa wâru tàpé na rà pâmari.» ");
INSERT INTO priNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","«Guwà ipwagorocôo tèpa péroféta a pwâ na rà ina pâ, rà pame ê popai kà Pwiduée! Ba rà o pâmariwà, âna rà pwacèwii mutô, êco na rà pâ tèpa macii a piuti. ");
INSERT INTO priNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Guwà o nye côoinarà gée goro ê pwâra wakè kàra. Ba câjè caa pétâ pwâra dipâa gée goro ê upwâra aru! Â câjè caa pétâ pwâra î gée goro ê upwâra na pwa daaé! ");
INSERT INTO priNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","18","Ba ê upwâra na wâdé, âna é nye tòpò pwêe na wâdé târa uti â pwacoé ma é tòpò pwêe na èpà. Â ê upwâra na èpà, âna é nye tòpò pwêe na èpà, â pwacoé ma é tòpò pwêe na wâdé. ");
INSERT INTO priNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Â wà pwi upwâra na câé caa naa cè pwêe cèna wâdé, âna o tépàgàé, â tüê naa gòro ânye. ");
INSERT INTO priNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","«Â ipaiwà naa goo tèpa péroféta a pwâ. Ba guwà o côoinarà gée goo ê pwâra wakè kàra.» ");
INSERT INTO priNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","«Wiàna nümagà na gà tèepaa naa na *Mwaciri napwéretòotù, â câgà caa po ciburà ina co pâ: “Pwi Ukai, Pwi Ukai!” Wâdé na gà pwa mwara câbawâdé kà Caa kôo na wânidò napwéretòotù! ");
INSERT INTO priNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Ba, na Tòotù na o mwa pitèi tèpa âboro, âna o wâru tàpé na rà o ina tôo pâ: “Pwi Ukai, Pwi Ukai, bà mu picémara, ma tü târa pâ duée naa na neegà. Â wâru pâ wakè na bà pwa goro pàtàmagà!” ");
INSERT INTO priNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","«Â go o mwa po ina tàra gée pâ: Câgo caa mu tâmogòoriwà. Guwà pâra jiio, ba guwà tèpa pwa ê pâ tûâ na èpà! Ba câguwà mu caa pwa ê câbawâdé kôo.» ");
INSERT INTO priNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","«Wà pwina é têre diri pâ popai kôo bèeni ma pitêre dàra, âna é pwacèwii pwi âboro na é tèi bwàti muru. Ba é bari ê wâ kêe naa gòro atü. ");
INSERT INTO priNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Â coo boo ê popaa, ma ca i jèpé, â uu ê pòu, â coo ma ti goro ê wâ. Êco na câé caa tûu, ba bari naa gòro atü. ");
INSERT INTO priNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Â wà pwina é têre popai kôo, â câé caa pitêre dàra, âna é pwacèwii pwi a pimwüru, na é pacima ê wâ kêe naa namarawâ. ");
INSERT INTO priNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Â coo boo i popaa, â ca i jèpé, â uu i pwéretòotù, â coo ma ti goro i wâ. Â é nye tûu kaa i wâ, â nye tònoori diri kaa.» ");
INSERT INTO priNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Ûna é ina diri pâ popai bèepwiri wà Iésu, â rà dau pò goro ê pai pacâmurirà kêe wà tèpa âboro. ");
INSERT INTO priNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Ba câé caa pwaduwà kà tèpa *dotée goro ê Naèà na rà ina ê pwina rà ina wà pàra tàpé. Ba é nye tùra gée gooé. ");
INSERT INTO priNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Gée na càùé, â é tàbàtù boome gée gòrojaa wà Iésu, â rà pâra wiâê ê pâ âboro na dau wâru. ");
INSERT INTO priNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Â é me burèe pwi jè a pwa maga. Â é tùu jùrué ara Iésu, â é ina têe pâ: «Pwi Ukai, wiàna nümagà, â gà o nama tiàu maagé kôo!» ");
INSERT INTO priNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Â é tu pâ wà Iésu, â é tu naa gooé, â é ina têe pâ: «Üu kaa, nümoo na tiàu jiigà maga'gà!» Â é nye wâdé kaa. ");
INSERT INTO priNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Â é ina têe wà Iésu pâ: «Gà cibwaa pwa jèkutâri! Êco na gà pâra nau ipaarigà tà pwi a pwa ârapwaailò. Â gà naa tà Pwiduée i pwi *ârapwaailò na ia é ina wà Moosé naa na *Naèà kêe. Ba na wàrapwiri, â rà o côo diri wà tèpa âboro pâ gà jèe wâdé.» ");
INSERT INTO priNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","É paé wà Iésu, â ûna é tò naa Capernaüm, â é me mariê wà pwi jè caa kâra coda kà tèpa *Roma. Â é tacoo gooé, ba na é pitu têe, ");
INSERT INTO priNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","â é ina pâ: «Gà côo pwi ênawéna kôo, âna é tà puu wâ pwârawâ, ba é nye dau maagé kaa, â é pitàbwamwa.» ");
INSERT INTO priNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Â é tòpi têe wà Iésu pâ: «Wâdé, paé ma ju pâra, ba go mwa nama tiàu maagé kêe.» ");
INSERT INTO priNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Â é tòpi têe pwini pâ: «Bwa, càcaa pâri naa gooò ma gà tèepaa naa pwârawâ kôo. Â gà nye po tùra co, â o tiàu maagé kà pwi ênawéna kôo. ");
INSERT INTO priNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Ba wâgo, âna go pitêre dàra pwi a pitûâ kôo, â go caa pitûâ kà tèpa coda. Â, na go ina tà pwi jèpwi pâ: “Gà pâra!” â é pâra. Â, na go ina tà pwi jèpwi pâ: “Gà me!” â é me. Â, na go ina tà tèpa ênawéna kôo pâ: “Guwà pwa ni” â rà nye pwa.» ");
INSERT INTO priNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Â é dau pò wà Iésu, â é câdiri i pwi caa kâra coda. Â é ina tà tèpa gére pâra wiâê pâ: «Guwà têre bwàti, ba go ina tàwà ê âjupâra pâ: Câgo caa pâmari cè pwi âboro cèna maina cèikî kêe, pwacèwii pwini, tia na mwara ê âji Ba kà Pwiduée *Isaraéla. ");
INSERT INTO priNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Üu, o wâru diri cè tàpé cèna rà o mwa me naa na *Mwaciri napwéretòotù, gée na diri gòropuu. Â rà o mwa tâa na ê pi-ija na maina ma wà tèpa jojoorojè *Abéraama, ma Isaaka, ma Iakobo. ");
INSERT INTO priNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Â napwa naa goo wà pàra tèpa âji nari Mwaciri, âna càcaa pârirà ma rà tò. Â o mwa türà naa gòroigé, naa na bàutê, iti jii Pwiduée! Â rà o mwa i ma tòngüru poropwârà gée goro pai maagé kàra.» ");
INSERT INTO priNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Â nabwé, â é ina wà Iésu, tà i pwi caa kâra coda, pâ: «Gà wâjué côwâ naa pwârawâ'gà! Gée goo ê cèikî'gà, âna o tèepaa ê pwina gà ilari!» Â, na ji pàara bèepwiri, âna nye tiàu kaa i maagé kà i pwi ênawéna. ");
INSERT INTO priNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","É pâra naa pwârawâ kà Pétéru wà Iésu. Â é pâmari tô nyaa kà wâdà Pétéru na é gére puu, ba é pitòoka. ");
INSERT INTO priNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Â é tu naa goro îê wà Iésu, â nye tiàu jiié kaa i pai pitòoka kêe. ");
INSERT INTO priNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Na bàrane kêe, â cia medari Iésu ê pâ âboro na wâru, na pwa duée goorà. Â é tûâri târa pâ duée, na rà còobé gée goorà. Â é nama tiàu diri mwara pâ maagé goo pàra tàpé. ");
INSERT INTO priNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Êkaa na pacoo i pwi ia é ina wà Pwiduée, na é naigé mee *péroféta Isaia, pâ: É jèe popa jiijè ê aré kâjè. É jèe tétâjii ê pâ maagé kâjè. Ésaïe 53.4 ");
INSERT INTO priNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Na jè tòotù, âna wâru pâ âboro na rà tâbèepi Iésu. Ûna é côorà, â é ina tà tèpa *câmu kêe pâ, na rà capai gée, naa na ére gée côwâ kâra nawià. ");
INSERT INTO priNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Â géewê, â é medarié pwi jè *dotée goro ê Naèà, â é ina têe pâ: «Pwi a pwa pupûra, nümoo na go pwi a câmu'gà, â go pâra wiâgà, naa na diri cè ére cèna gà o pâ wê.» ");
INSERT INTO priNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Â é tòpi têe wà Iésu pâ: «Ê pâ macii a piugà, âna pwa aucârü kàra, â pâ marü, âna pwa na wânaîrà. Â napwa naa gooò, *Pwina naîri âboro, âna nye ticè aunao kôo.» ");
INSERT INTO priNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Â ipaiwà naa goo pwi jè ârapàara tàpé na rà pâra wiâ Iésu, na é ina têe pâ: «Nye pâri ma go jèe mara pâra nau ipwàniri caa kôo?» ");
INSERT INTO priNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Â é tòpi têe wà Iésu pâ: «Bwa, gà me wiâô. Â gà naaco tèpa bà, ma rà nye ipwànirirà côwâ!» ");
INSERT INTO priNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","É nye tò kaa naa gòro i wànga wà Iésu, â rà pâra wiâê wà tèpa câmu kêe. ");
INSERT INTO priNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Â, na rà tèepaa naa nabibiu kâra nawià, â é nye nama tüê kaa i pwéretòotù. Â jèe tò naa na wànga ê pâ wià. Â napwa Iésu, âna é tàgére puu na wànga. ");
INSERT INTO priNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Â rà patàcîê wà tèpa câmu kêe. Â rà ina têe pâ: «Pwi Ukai! Gà nama jè udò! Ba jè o mwü!» ");
INSERT INTO priNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Â é ina tàra pâ: «Wànau? Cina wâgotàwà? Nye dau kîri kaa ê cèikî kàwà!» Â é cimadò, â é pwa i pwéretòotù ma i nawià. Â é coo i napô, â nye po èaau kaa. ");
INSERT INTO priNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Â rà po pò, â rà pi-ina tàra pâ: «Wàilàapà pwi âboro bèeni, na é pacoo ê pwéretòotù bau i wià?!» ");
INSERT INTO priNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Rà tèepaa wà Iésu ma wà tèpa câmu kêe naa Gadara, wâna ére gée côwâ kâra *nawià Galilée. Na napô bèepwiri, âna pwa tupédu ârailu âboro na pwa duée gooru. Â dau wâgo tà tèpa âboro gooru, ba ru tupédu âboro gòo ma tupédu a putàmu. Â càra caa mu piwédò na ére bèepwiri. Ûna ru côo Iésu, â ru nye còobé kaa gée nacârü, â ru boome caraé. ");
INSERT INTO priNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Â ru nye wiikau ma ina pâ: «*Pwina naî Pwiduée, dà cèna nümagà na gà pwa tâbu? Nümagà na gà pwa wârimuru tâbu, béaari kâra ê pàara târa pwa wârimuru?» ");
INSERT INTO priNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","31","Â rà tacoo gooé mwara wà tèpa duée, ma ina têe pâ: «Na gà tü tâbà, â gà nama bà gée naa goro ê pâ puàkà nadòbà!» Ba pwa ê pé pubu puàkà na dau maina, na rà tàgére ija gée paé côwâ ni. ");
INSERT INTO priNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Â é tòpi tàra pâ: «Îguwà!» Â rà còobé gée goo i tupédu âboro, â rà tò naa na i pâ puàkà. Â rà nye tàbàtù kaa i pâ puàkà, gée goro i jaa, boo naaniboo nawià. Â rà cau mwü naawê. ");
INSERT INTO priNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Wà tàpé na rà piwéaari i pâ puàkà, âna rà nye uru pâ kaa, naa na village. Â rà piwiâ diri ê jèkutâ bèepwiri. ");
INSERT INTO priNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Rà nye cau me diri kaa dari Iésu ê pâ âboro gée na village. Ûna rà côoê, â rà tacoo gooé pâ, na é pâra gée na napô kàra. ");
INSERT INTO priNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","É wâjué côwâ wà Iésu gòro wànga naa na village Capernaüm wâna é pitâa wê. ");
INSERT INTO priNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Â wà pàra tèpa âboro na napô-bà, âna rà pitûri medarié naa na aupuu pwi âboro na é pitàbwamwa. Ûna é côo ê cèikî kàra, â é ina tà pwi a pitàbwamwa pâ: «Gà gòo, co pwi béeò! Ba jèe pwanauri ê pâ èpà'gà!» ");
INSERT INTO priNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Â wà pàra tèpa *dotée goro ê Naèà na rà tâa wê, âna rà piniimiri pâ, ‘Wà pwi âboro bèeni, âna é pi-ina ba èpà Pwiduée ba é nama ipaiwàilu ma wàé!’ ");
INSERT INTO priNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","É tà tâmogòori pwina rà niimiri wà Iésu, â é ina tàra pâ: «Cina èpà ê pwâranümawà? ");
INSERT INTO priNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Piticècoé na go ina têe pâ: “Jèe pwanauri ê pâ èpà'gà” jii na go ina têe pâ: “Cimadò, â gà pâra!” ");
INSERT INTO priNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Â wiàna pâri ma go nama é pâra, na arawà diri â guwà mwa tâmogòori pâ, pwa tàrù kà *Pwina naîri âboro, ma é pwanauri ê pâ èpà kà tèpa âboro naani gòropuu.» Â é ina tà pwi a pitàbwamwa pâ: «Gà cimadò, â gà popa ê aupuu'gà, â gà pâra naa jaagà.» ");
INSERT INTO priNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Â é nye cimadò kaa i pwi âboro, â é pâra naa pwârawâ kêe. ");
INSERT INTO priNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Ûna rà côo pwiri wà tèpa âboro, â wâgotàra. Â rà pwamaina Pwiduée, ba é naa ê pàtàmee na maina tà tèpa âboro! ");
INSERT INTO priNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","É pâra wà Iésu, â é côo pwi âboro na nee Mataio, na é gére tâa na wâra *tò mwani wâripû. Â é ina têe wà Iésu pâ: «Gà me wiâô!» Â é nye cimadò kaa, â é pâra wiâê. ");
INSERT INTO priNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Gée na càùé, â rà ija wà Iésu ma wà tèpa *câmu kêe, jaa Mataio. Â wâru pâ âboro na rà pi-ija ma wàilà—wà tèpa tò mwani, ma wà pàra tèpa âboro na èpà wâro kàra. ");
INSERT INTO priNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Ûna rà côo ê pwiibà wà pàra tèpa *Farasaio, â rà ina tà tèpa câmu kà Iésu pâ: «Gorodà na wà pwi ukai kàwà, âna rà picaaija ma pibéerà ma tèpa tò mwani, ma wà tàpé na èpà wâro kàra?» ");
INSERT INTO priNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Â é tà têrerà wà Iésu, â é ina pâ: «Càra caa bu dotée wà tàpé na rà wâdé. Â nye wàco tàpé na rà maagé. ");
INSERT INTO priNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Wâdé na guwà tâmogòori ê auina kà Pwiduée, pâ: Càcaa ê *ârapwaailò goro macii na wâdé tôo. Â nümoo goo pimeaari. «Wâgo, âna câgo caa me nau todà tàpé na rà niimiri pâ wâdé ê wâro kàra. Go me nau todà tàpé na rà tâmogòori pâ èpà ê wâro kàra.» ");
INSERT INTO priNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Rà tèepaa medari wà Iésu, wà pàra tèpa câmu kà *Ioane Pwi a piupwaa. Â rà ina têe pâ: «Wàibà ma tèpa Farasaio, âna bà nye ciburà *ipwanya. Bà panuâ ê ija, ba na bà pwapwicîri tà Pwiduée. Â gorodà na càra caa ipwanya wà tèpa câmu'gà?» ");
INSERT INTO priNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Â é tòpi tàra wà Iésu pâ: «Gona rà o pikîri wà tàpé na todàra naa goro piéa, wiàna é bwaa tâa jaarà wà pwi a piéa? Bwa! Êco na o mwa me ê pàara, na ée mwa pâra jiirà wà pwi a piéa. Â géewê, â rà o mwa bàra ipwanya.» ");
INSERT INTO priNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","«Nye ticè jè âboro, cèna é popa ê pâ noo kâra imwaano na càcaa pâji nuwa, ma é taiti naa goro ê pwina jèe dòroé. Ba wiàna jè nuwa i imwaano, â o dàdàpa ê gòobàra ê imwaano na jèe dòroé. Â o mwa dau maina kaa ê audàdàpa goo! ");
INSERT INTO priNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Â guwà côo ê *wâra jawé na pwa goro parawére macii: Câjè caa popa ê dipâa na bwaa âmuê, ma jè upwâwii ê wâra jawé na jèe dòroé. Ba o taaò i wâra jawé, ba pwacoé ma é tèe. Â ée joro wii napuu i dipâa, â jèe èpà i wâra jawé. Bwa! Wâdé na jè tòpò ê dipâa na bwaa âmuê, naa na ê wâra jawé na bwaa bwùu, ba na o wéaari bwàti i dipâa bau i wâra jawé.» ");
INSERT INTO priNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Ûna é bwaa gére ina tàra pwiri wà Iésu, â é medarié wà pwi jè âboro imaina kâra napô. Â é tùu jùrué ara Iésu, â é ina têe pâ: «Gà me wài! Ba wà tô èpo kôo, âna é mwa nye tàgére bà ni. Êco na, wiàna gà me nau tòpò îgà naa gòé, â ée wâro.» ");
INSERT INTO priNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Â rà cimadò wà Iésu ma wà tèpa câmu kêe, â rà pâra wiâ pwi âboro-bà. ");
INSERT INTO priNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Na rà gére pâra wii naigé, â é tèepaa me tô ilàri na jèe po 12 naja kêe goro maagé, ba, mu tèepaa me ê pàara na mu itàa domii gooé. Â é pwicò kàra, â é tu naa goro gòobàra ârabwée kà Iésu. ");
INSERT INTO priNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Ba é nye cèikî pâ é nye po wàrapwiri co, â o jèe tiàu i maagé kêe. ");
INSERT INTO priNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Â é tabiié wà Iésu, â ûna é côoê, â é ina têe pâ: «Gà gòo, co tôoni! Gà jèe wâdé côwâ goo ê cèikî'gà!» Â nye tiàu kaa i maagé kêe. ");
INSERT INTO priNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Nabwé, â é tèepaa pâ wà Iésu, naa pwârawâ kà i pwi âboro imaina. Â é pâmari pâ âboro na rà gére cipacîri ipwàni, ma wà tèpa pwanyabi. Â nye dau wâru kaa ê pâ pwâratùra wê. ");
INSERT INTO priNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Â é ina tàra pâ: «Guwà pâra! Ba wà tôoni, âna câé caa bà. Â é nye po puu.» Êco na rà pitaurèe gooé. ");
INSERT INTO priNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Â é cau pacòobérà wà Iésu, â é tò naa na ê naditàrawâ. Â é tu pâ naa goro îri i èpo, â é nye cimadò kaa wà tôoni. ");
INSERT INTO priNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Â rà nye piwiâ pitiri kaa na ére-bà, ê jèkutâ goo. ");
INSERT INTO priNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Géewê, â é pâra wà Iésu. Ûna é tèepaa naa na jè ére, â ru gére pwicò kêe tupédu a bwi. Â ru nye tà uu ma ina pâ: «*Pwina naî Davita, gà meaaribu, ma pitu tâbu!» ");
INSERT INTO priNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Ûna é tèepaa naa jaaé wà Iésu, â ru medarié tupéeni. Â é ina tàru pâ: «Gona gàu nye cèikî kaa pâ, pâri ma go nama tiàu i maagé kàu?» Â ru tòpi têe pâ: «Üu, co Pwi Ukai.» ");
INSERT INTO priNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Â é tu naa goro i du âraporomeeru wà Iésu, â é ina tàru pâ: «Wâdé na wàra ê pwina gàu nye cèikî naa goo!» ");
INSERT INTO priNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Â ru nye niâ kaa. Â é ina ba gòo tàru pâ: «Gàu pwacôoco! Gàu cibwaa pwa jèkutâ goo ê pwina go pwa tàu!» ");
INSERT INTO priNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Êco na, ûna ru còobé, â ru pwa jèkutâ goo Iésu pitiri ê napô-bà. ");
INSERT INTO priNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Ûna ru gére pâra jii Iésu wà tupéeni, â rà popa me têe pwi âboro na é kûukû, ba pwa duée gooé. ");
INSERT INTO priNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Â é tü târa i duée wà Iésu, â é nye tùra kaa i pwi a kûukû. Â rà pò gooé diri pâ âboro na rà tâa wê, â rà pi-ina pâ: «Câjè caa mu côo cèna wàrani, na napô kâjè *Isaraéla!» ");
INSERT INTO priNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Êco na rà ina tèpa Farasaio pâ: «É tü târa ê pâ duée goro ê pàtàma *Caatana, pwi ukai kâra pâ duée!» ");
INSERT INTO priNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Wà Iésu, âna é pâra wii pâ ville ma village. Â é pacâmuri pâ âboro, naa na pâ *wâra pitapitiri. Â é picémara ê *Picémara Wâdé goro ê Mwaciri napwéretòotù. Â é nama tiàu ê pâ maagé ma aré, na wâru pai pwa goo. ");
INSERT INTO priNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Â é côo ê pâ âboro na dau wâru, â é dau meaarirà. Ba jèe oratàra, â rà pidumapiê, pwacèwii pâ mutô, na ticè cèna wéaarirà. ");
INSERT INTO priNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Â é ina tà tèpa câmu kêe pâ: «Dau maina ê ârapiûnya na o pwa. Êco na càcaa wâru awakè. ");
INSERT INTO priNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Wâdé na guwà pwapwicîri ma ilari cai jii Pwi apooro aupwanapô, ma é panuâ me mwara cè pàra tèpa wakè, ba na rà pitu.» ");
INSERT INTO priNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","É todà tèpa câmu kêe wà Iésu na rà po 12, â é naa tàra ê tàrù, ba na rà tü târa cè pâ duée, ma rà o nama tiàu diri pâ maagé ma aré kâra pâ âboro. ");
INSERT INTO priNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Wàéni ê nee tèpa 12 *apostolo: Simona, na ina gooé pâ Pétéru; André, pwi aéjii kêe; Jacques, pwina naî Zébédée; Ioane, pwi aéjii kà Jacques; ");
INSERT INTO priNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filipo; Barthélemy; Toma; Mataio, pwi a mu *tò mwani wâripû; Jacques, pwi naî Alphée; Thaddée; ");
INSERT INTO priNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simona, pwi Zélote; Judas Iscariote, wà pwina ée mwa ipwa tûâ tà Iésu. ");
INSERT INTO priNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Tèpa 12 apostolo bèepwiri, âna é cùrurà wà Iésu, naa na pâ napô, â é tûâri tàra pâ: «Guwà cibwaa pâra dari tèpa âboro na càra caa tèpa *Juif. Â guwà cibwaa tò mwara, naa na pâ village na napô *Samaria. ");
INSERT INTO priNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Â guwà nye pâra dari co tèpa âboro *Isaraéla, ba rà pwacèwii tèpa mutô na rà imwüru. ");
INSERT INTO priNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Â guwà picémara wii naigé, pâ: “Jèe wâmwünyabweriwà ê *Mwaciri napwéretòotù.” ");
INSERT INTO priNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","«Â guwà nama tiàu pâ maagé, â guwà pawâro tèpa bà, â guwà pwa ma rà wâdé tèpa pwa maga, â guwà tü târa pâ duée gée goro pâ âboro. Ba po muru naa tàwà, â wâdé mwara na guwà naa, naa goro piticèmuru naa goo. ");
INSERT INTO priNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Â, na guwà pâra, â guwà cibwaa pa mwani—wâpà wiàna mwani mii, é mwani pwaa, é cè jè mwani. ");
INSERT INTO priNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Â guwà cibwaa pa cè atà, ma cè wâraâwà, ma cè tâjò kàwà. Guwà nye coona co caapwi ârabwée. Ba wà pwi a wakè, âna wâdé na é tòpi ê ârawakè kêe. ");
INSERT INTO priNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","«Wiàna guwà tò naa na cè jè village, â guwà mudàra cawi cè pwi âboro cèna nümee na é tòpiwà. Â guwà tâa jaa pwiibà, tiagoro cè tòotù cèna guwà mwa pâra gée na ére-bà. ");
INSERT INTO priNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Â, na guwà tò naa na i pwârawâ-bà, â guwà ilari jii Pwiduée ê *aupwényunyuâari ma pinaanapô kêe, naa gò tàpé na rà tâa wê. ");
INSERT INTO priNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Â wiàna rà tòpiwà bwàti, â o mwa tâa tàra ê aupwényunyuâari. Â wiàna càra caa tòpiwà bwàti, â guwà pacôwâri ê aupwényunyuâari kàwà. ");
INSERT INTO priNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","«Â wiàna nye ticè caapwi âboro na é tòpiwà, ma têre ê pwâratùra kàwà, naa na cè jè pwârawâ, ma naa na cè jè village, â guwà còobé géewê. Â guwà tauri ê dàuru puu gée goro du âwà. ");
INSERT INTO priNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Â go ina tàwà ê âjupâra pâ: Ée mwa pwa wârimuru tàra wà Pwiduée, na Tòotù na ée mwa pitèi pâ âboro. Â o dau maina ê wârimuru kàra, jii tàpé gée *Sodoma ma Gomora na ia dau miiri ê tûâ kàra.» ");
INSERT INTO priNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","«Guwà têre! Go cùruwà pwacèwii pâ mutô naa nabibiu kâra macii a piuti. Wâdé na guwà tèpa âboro na guwà moo, êco na wâdé na guwà tèpa ipwacôowà mwara. ");
INSERT INTO priNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Ba rà o tâjùruwà ma popawà pâ naa na wâra pitèimuru. Â rà o pâdiwà goro ubati naa na pâ *wâra pitapitiri. ");
INSERT INTO priNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Â rà o dàtiwà pâ na ara tèpa kupénoo ma wà tèpa ukai, ba na rà pitèiwà, gée goro na guwà tèpa âboro kôo. Â guwà o tèpa *paâjupâraô, na ararà, ma na ara mwara tàpé na càra caa tèpa Juif. ");
INSERT INTO priNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","«Â, na diri pâ pàara na rà o mwa tâjùruwà, â guwà cibwaa pidumapiê goro cè pai tòpirà. Ba wà Pwiduée, âna ée mwa naa tàwà cè pwina guwà ina na ji pàara bèepwiri. ");
INSERT INTO priNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Ba o jèe càcaa wâguwà na o tùra, â o jèe ê Nyuâaê Pwicîri kà Caa kàwà, na é tùra goowà. ");
INSERT INTO priNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","«Na pwi pàara bèepwiri âna wà pwi jè âboro, âna ée panuâ pwi aéjii kêe, ba naa tétàmwereê. Â wà pwi caa kâra èpo, âna é wàrapwiri tà pwina naîê. Â wà tèpa èpo, âna rà o pipaa ma du nyaa ma caa kàra. Â rà o pwa ma rà pwa wârimuru, tiagoro pai pòtàmwararà. ");
INSERT INTO priNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Â rà o miiriwà diri ê pâ âboro, ba guwà tèpa âboro kôo. Êco na wà pwina é cimwü tia pwâadèreè, âna ée mwa pa-udòé wà Pwiduée ma naa têe ê *wâro dàra gòiri jaaé. ");
INSERT INTO priNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","«Wiàna rà tubaèpà tàwà naa na cè jè village, â guwà uru naa na jèpwi. Â guwà pâpitiri ê pâ village naa napô Isaraéla, â guwà picémara popai kôo. Â guwà têre, o bwaa câguwà caa pâji tubanabwé pwiri, béaari ê pai o wâjué côwâ kôo. Ba go ina tàwà ê âjupâra pâ: Wâgo *Pwina naîri âboro, âna go o mwa wâjué côwâ naa na pwényuâa kà Pwiduée.» ");
INSERT INTO priNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","«Go ina tàwà pâ: Wà pwi a *câmu, âna câé caa piwéna jii pwi a pacâmuriê. Â wà pwi ênawéna, âna câé caa piwéna jii pwi ukai kêe. ");
INSERT INTO priNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Ba wà pwi a câmu, âna wâdé na é pwacèwii pwi a pacâmuriê. Â wà pwi ênawéna, âna wâdé na é pwacèwii pwi ukai kêe. Ba wiàna rà ina goo wà pwi apooro pwârawâ pâ *Caatana, â rà o nye dau ina ba èpà mwara tèpa tâa na pwârawâ bèepwiri.» ");
INSERT INTO priNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","«Guwà cibwaa nama wâgotàwà goro pâ âboro. Diri pâ muru na tàbinyiri, âna o mwa paari. ");
INSERT INTO priNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Â ê muru na go ina tàwà pwàniri, âna guwà inapàpari naa na pwéelaa. Â ê muru na pitànunuuri na pwâranyüruwà, âna guwà inapàpari naa na gomu kàwà. ");
INSERT INTO priNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Üu, guwà cibwaa nama wâgotàwà goro pâ âboro. Ba wiàna pâri ma rà pòtàmwara naiiwà, â o càra caa tâmogòori ma rà tubatiàu awé ê wâro naa wâgoowà. Wâdé na guwà nama wâgotàwà goo Pwiduée. Ba wàé co na pâri ma é tubatiàu ê naiiwà, bau ê wâro na wâgoowà, naa na ére na jè maagé ma tòina naawê. ");
INSERT INTO priNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","«Guwà jèe côo cai pâ marü na kîri: Jè icuri du ârailu marü, naa goro caapwi mwani. Êco na nye ticè gée goorà, cèna é tûuboo naa napuu, wiàna câé caa tâmogòori wà Pwiduée Caa kàwà. ");
INSERT INTO priNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Â wâguwà, âna é nye cau tâmogòoriwà bamwara, tiagoro mwara jéûru wàrapûruwà. ");
INSERT INTO priNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Êkaa na go ina tàwà pâ: Guwà cibwaa nama wâgotàwà! Ba dau pwamuru naa goowà na ara Pwiduée, jii ê pâ marü na dau wâru!» ");
INSERT INTO priNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","«Wiàna é inapàpari cè pwi jèpwi, na ara pâ âboro pâ, é pwi âboro kôo, â wâgo mwara, âna go o ina pâ, é pwi âboro kôo, na ara Caa na é wânidò *napwéretòotù. ");
INSERT INTO priNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Â wiàna é ina cè pwi jèpwi, na ara pâ âboro pâ, câé caa pwi âboro kôo, â wâgo mwara, âna go o ina pâ, câé caa pwi âboro kôo, na ara Caa na é wânidò napwéretòotù.» ");
INSERT INTO priNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","«Guwà cibwaa niimiri pâ go tèepaa me naani gòropuu, ba na go pame pinaanapô. Bwa! Go me, ba na rà mwa pitadàrùrà tèpa âboro gooò. ");
INSERT INTO priNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Ba go me nau pinaaitiri tupé duanaî, ma du duanaî, ma du duatâa. ");
INSERT INTO priNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Â rà o pièpàrirà pa paénaî, ma pa paétâa, naa na pwârawâ kàra.» ");
INSERT INTO priNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","«Wà pwina é dau wâdéari du nyaa ma caa kêe jiio, âna càcaa pâri ma é pwi a câmu kôo. Â wà pwina é dau wâdéari pwi naîê ma wà tô èpo kêe jiio, âna càcaa pâri ma é pwi a câmu kôo. ");
INSERT INTO priNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Wà pwina câé caa kâa ê *kurucé kêe, ma é me wiâô, âna wà pwiibà, âna càcaa pâri ma é pwi a câmu kôo. ");
INSERT INTO priNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Â wà pwina nümee na é wéaari ê wâro kêe, âna ée mwa tubatiàu. Â wà pwina é panuâ ê wâro kêe ba kôo, âna ée mwa pâmari ê *âji wâro.» ");
INSERT INTO priNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","«Wiàna é tòpiwà cè pwi jè âboro, âna é tòpio mwara. Â wà pwi âboro na é tòpio, âna é tòpi mwara wà Pwina é cùruo me. ");
INSERT INTO priNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Â wiàna é tòpi cè pwi *péroféta, gée goo na é pwi péroféta, â o mwa pwa cè câmaê, cèna wàra na naa tà tèpa péroféta. Â wiàna é tòpi cè pwi jè âboro cèna é *tàrù na ara Pwiduée, gée goo na é tàrù, â o mwa pwa cè câmaê, wàra na o naa tà pwina é tàrù. ");
INSERT INTO priNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Â go ina tàwà ê âjupâra pâ: Wiàna é naa cè wârado jawé moo, târa ji pwi ênawéna kôo bèepwiri, gée goo na é pwi a câmu kôo, â o pwa cè câmaê.» ");
INSERT INTO priNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Ûna é ina diri ê autûâri kêe bèepwiri wà Iésu tà tèpa 12 a *câmu kêe, â rà cau pâra géewê, naa na pâ ville na pwi ére-bà. Â é pacâmuri tèpa âboro wà Iésu, ma picémara tàra ê *Picémara Wâdé. ");
INSERT INTO priNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Ûna é tâa na karapuu wà *Ioane Pwi a piupwaa, â é têre ê jèkutâ goo Kériso, ma ê pâ pwina é pwa. Â é panuâ pâ pàra tèpa câmu kêe, ");
INSERT INTO priNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","ba na rà tawèeri Iésu pâ: «Pwiri nye wâgà kaa pwi *Mesia, *pwi a pa-udò na ée mwa tèepaa? É, na bà bwaa nye tapacîri cè pwi jèpwi?» ");
INSERT INTO priNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Â é tòpi tàra wà Iésu pâ: «Guwà wâjué côwâ nau piwiâ tà Ioane ê pwina guwà têre, ma ê pwina guwà côo. ");
INSERT INTO priNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Ba wà tèpa bwi, âna rà jèe niâ; wà tàpé na rà bee, âna rà jèe pâra bwàti; wà tàpé na rà pwa maga, âna rà jèe wâdé; wà tèpa kee, âna rà jèe têrejè; â wà tèpa bà, âna rà jèe wâro côwâ; â wà tàpé na ticè kàra, âna rà jèe tòpi ê Picémara Wâdé. ");
INSERT INTO priNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Cidòri nyuâa pwina é côoinaô, ma cèikî naa gooò!» ");
INSERT INTO priNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Ûna rà wâjué côwâ wà tèpa câmu kà Ioane, â é ina wà Iésu târa pâ âboro na rà gére tâa wê, pâ: «Na ia guwà pâra naa namaré nau têre Ioane â dà cèna guwà pâra nau ucâri?—Pwi âboro na pipwaée kêe na é pwacèwii ê bàra watü na pòbagù pwéretòotù? ");
INSERT INTO priNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Bwa! Â gona dà na guwà pâra nau côo?—Pwi jè âboro na é coona pâ ârabwée na po wâdé? Bwa! Wà tèpa âboro na wàrapwiri, âna rà tâa na ê wâra ukai! ");
INSERT INTO priNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Nye dà cèna guwà pâra nau côo? Pwi jè *péroféta? Üu kaa, â go ina tàwà pâ: Wà pwiibà, âna é pwi péroféta maina! ");
INSERT INTO priNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Ba nye wà kaa Ioane, na é inaê wà Pwiduée, naa na *Tii Pwicîri, pâ: Go mwa panuâ paé pwi a pa popai kôo. Ée mwa pâbéaa'gà ma pwabwàti naigé'gà. Malachie 3.1 ");
INSERT INTO priNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","«Guwà têre bwàti, ba go ina tàwà ê âjupâra pâ: Nye ticè pwi jè âboro gòropuu, cèna é piwéna jii Ioane Pwi a piupwaa. Êco na wà pwina ée dau kiriwi naa na *Mwaciri napwéretòotù, âna o mwa tâa têe ê pwina piwéna jii Ioane. ");
INSERT INTO priNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Tapoo na pàara na é tapoo picémara wà Ioane, tèepaa naa na pàara nabà, âna wà tèpa âboro gòo, âna rà mudàra ma rà tòpò goro nii kàra naani gòropuu ê Mwaciri napwéretòotù. ");
INSERT INTO priNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Ba béaa kà wà Ioane, âna ê *Naèà kà Moosé, ma wà diri tèpa péroféta, âna rà picémara târa pâ âboro pâ, ée jèe tòpò ê Mwaciri kêe wà Pwiduée. ");
INSERT INTO priNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Guwà cèikî naa gooò na go ina pâ: Ûna wii naa na Tii Pwicîri pâ, ée mwa wâjué côwâ wà péroféta *Élia, âna tàgére inapàpari ê pai tèepaa kà Ioane. ");
INSERT INTO priNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","«Wà pwi âboro na pwa pwâranyüruê, âna wâdé na é têre!» ");
INSERT INTO priNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","17","«Go ina pâ, rà wànau tèpa âboro nabà? Rà pwacèwii pâ nari èpo na rà gére pipuburirà naa na aupitapitiri â tàutàra dàra kòcò ma wà tèpa béerà, na rà pitakàna ma ina tàra pâ: “Bà tòjò tàwà, â tàutàwà dàra câbu. Bà nyabiri tàwà nyabi târa ipwàni, â tàutàwà dàra i!” «Â ipaiwà naa goo wà tèpa âboro nabà. ");
INSERT INTO priNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Ba é tèepaa me wà Ioane Pwi a piupwaa, â é tàpo panuâ ija na pàra pàara, â câé caa wâdo dipâa, â rà ina tèpa âboro pâ: “Pwa duée gooé!” ");
INSERT INTO priNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","«Ûna é tèepaa me, wà *Pwina naîri âboro, â é ija ma wâdo pwacèwii pàra tàpé. Â rà ina wà tèpa âboro pâ: “Wà pwini, âna é dau pwi a wâdo ma pwi a-ija! Â é nye pabée tèpa tò mwani, ma wà pàra tèpa âboro èpà.” «Êco na âjupâra ê pwina jè mu ina pâ: “Ê tàmanga, âna jè côo taaci naa na ê pwâra wakè kêe.”» ");
INSERT INTO priNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","É tapoo tùra ba gòo târa ê pâ âboro na pàra village wà Iésu. Ba wâru pâ wakè na é pwa naawê goro pàtàmee, êco na càra caa pitòotéri ê tûâ kàra. ");
INSERT INTO priNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Â é ina tàra pâ: «Guwà ipwacôoco, wâguwà tèpa âboro na Korazine ma Bethsaïda! Ba o naa wârimuru tàwà! Go jèe pwa pâ muru na dau maina naa jaawà, â câguwà caa cèikî! Â wiàna rà côo ê pwina go pwa naa jaawà, wà tàpé gée Tyr ma Sidon, â pwiri jèe gòiri cè pai pitòotéri ê wâro kàra, ma naaco ê pâ tûâ kàra na dau èpà. Â pwiri rà paari mwara naa na cè pai coona dodà kàra, ma pitâmirà goro dà. ");
INSERT INTO priNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Â go ina tàwà ê âjupâra pâ: Na ê Tòotù na ée mwa pitèi ê pâ âboro wà Pwiduée, âna o dau maina ê wârimuru kàwà, jii tàpé Tyr ma Sidon. ");
INSERT INTO priNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","«Ipaiwà naa goowà, wâguwà tèpa âboro naa na village Capernaüm. Ba guwà niimiri pâ guwà pwacèwii Pwiduée. Êco na ée mwa naawà boo dari tèpa bà! Ba é pwa pâ muru na dau maina naa jaawà. Â wiàna é gére pwa pâ muru bèepwiri na *Sodoma, â pwiri é bwaa nye gére tâa nabà ê ville-bà. ");
INSERT INTO priNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Â go ina tàwà ê âjupâra pâ: Na ê Tòotù na ée mwa pitèi ê pâ âboro wà Pwiduée, âna o dau maina ê wârimuru kàwà, jii tàpé Sodoma!» ");
INSERT INTO priNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Pwa ji pàara géewê, â é ina wà Iésu pâ: «Caa, gà Pwi Ukai kâra *napwéretòotù ma gòropuu! Â go ipwaolé tâgà, ba gà naapwàniri pâ muru bèepwiri jii tèpa tâmogòorimuru ma wà tèpa tàmanga, â gà paari tà tàpé na càra caa câmu. ");
INSERT INTO priNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ba nye auniimiri'gà pâ, naa wàrapwiri.» ");
INSERT INTO priNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Â é ina wà Iésu tà pàra tàpé pâ: «Êdiri ê pwina tâa tà Caa kôo, âna é jèe naa tôo. É jèe nye ipaarié tôo, ba na go tâmogòorié bwàti. Nye wàé co na é tâmogòorio, wâgo Pwina naîê. Â nye ticè pwi jèpwi cèna é tâmogòorié, â nye wâgo co pwina Naîê. Â go paarié tà pàra tàpé, ba na rà tâmogòorié mwara.» ");
INSERT INTO priNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","«Guwà medario, wâguwà na dau tòina ê nakake kàwà, ma dau oratàwà. Ba go mwa nama guwà nao. ");
INSERT INTO priNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Guwà pa nakake na go naa tàwà, â guwà pâra naa goo ê autûâri kôo. Ba pwi a moo pwâratùra kôo, â go pwi a-ipakîriô. Â wiàna guwà me mariô, â guwà o pâmari âji nao. ");
INSERT INTO priNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Üu, ba ê nakake na go naa tàwà, âna o puràra cè pai popa wèe, â ê autûâri kôo, âna ticècoé pai pâra wiâra.» ");
INSERT INTO priNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Na jè *tòotù pwicîri, â rà pâra wii ê naigé na tapàgà na aupwanapô wà Iésu ma wà tèpa *câmu kêe. Â rà copwa wà tèpa câmu, â rà tàpo pétâ ê pâ pwâra blé, â rà uti. ");
INSERT INTO priNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Ûna rà côorà wà tèpa *Farasaio, â rà ina tà Iésu pâ: «Gà côo ê pwina rà pwa tèpa câmu'gà! Âna muru na pwicîri, na ê tòotù pwicîri!» ");
INSERT INTO priNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Â é tòpi tàra wà Iésu pâ: «Gona câguwà caa pûra naa na Tii Pwicîri, ê pwina é pwa wà ukai *Davita? Ba, na jè tòotù, âna rà copwa, wàilà ma wà tèpa bée. ");
INSERT INTO priNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Â é tò naa na wâra pwapwicîri pwa goro imwaano. Â é pa ê poloa na naa kà Pwiduée, â rà ija ma wà tèpa bée. Â ê poloa-bà, âna nye wàco wà tèpa pwa *ârapwaailò, na nye pwa tàrù kàra ma rà ija. ");
INSERT INTO priNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","«Â guwà pûra mwara naa na ê *Naèà kà Moosé pâ: Wà tèpa caa kà tèpa pwa ârapwaailò, âna rà wakè naa na *Wâra pwapwicîri, na tòotù pwicîri. Ê tûâ-bà, âna rà còbèedari ê pwi tòotù-bà. Êco na càcaa èpà na ara Pwiduée! ");
INSERT INTO priNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ba go ina tàwà pâ: É tà wâni ê Pwina dau piwéna jii ê Wâra pwapwicîri! ");
INSERT INTO priNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Â é ina wà Pwiduée naa na *Tii Pwicîri pâ: Càcaa ê ârapwaailò goro macii na wâdé tôo. Â nümoo goo pimeaari. «Â wâguwà, âna câguwà caa tâmogòori ê êre popai-bà, ba guwà pitòti tèpa âboro bèeni, na càra caa pwa cèna èpà na ara Pwiduée. ");
INSERT INTO priNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Â wà *Pwina naîri âboro, âna é pwi apooro ê tòotù pwicîri.» ");
INSERT INTO priNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Gée na càùé, â é tò naa na *wâra pitapitiri wà Iésu. ");
INSERT INTO priNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","É tâa wê mwara wà pwi âboro na bà ê îê. Â wà tèpa âboro, âna nümarà na rà côo cè pwina é pwa Iésu, ba na o cè pai pitòtié. Â rà pwa ma tawèerié pâ: «Pwiri nye tàrù ma jè nama tiàu maagé kà pwi jèpwi na tòotù pwicîri?» ");
INSERT INTO priNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Â é tòpi tàra pâ: «Guwà jèe côo cai ni: Wiàna caapwi co cè mutô'gà, na é tûu naa na pwêe, na tòotù pwicîri, â gà o pwa dà? O câgà caa pâ nau dàgòtùé? ");
INSERT INTO priNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Â napwa pwi âboro, âna é dau piâjimuru jii mutô! Gée goo pwiri, na o pwa cè tàrù kâjè, ma jè pwa pwina wâdé, na tòotù pwicîri.» ");
INSERT INTO priNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Â é ina tà i pwi âboro pâ: «Gà patàrù ê îgà!» Â é patàrù îê, â nye wâdé kaa, wàra jè îê. ");
INSERT INTO priNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Wà tèpa Farasaio na rà tâa wê, âna rà còobé gée na wâra pitapitiri. Â rà pâra côwâ nau ipitiri, ba na rà mudàra cè pai o pòtàmwara Iésu. ");
INSERT INTO priNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Ûna é têre wà Iésu pâ, rà gére imudàra cè pai pwa tûâ têe, â é pâra gée na ére-bà. Â wâru tàpé na rà pâra wiâê. Â é nama tiàu maagé kàra. ");
INSERT INTO priNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Â é tûâri tàra pâ: «Guwà cibwaa inapàpario!» ");
INSERT INTO priNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Â ê pâ muru bèepwiri, âna tèepaa, ba na pacoo i pwi ia é ina wà Pwiduée, na é naigé mee *péroféta Isaia, pâ: ");
INSERT INTO priNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Wàéni pwi âboro, pwi âboro kîri, pwi ênawéna kôo. Wàé na go tòpòé, pitòrigarié ba kôo. Dau wânümoo têe; wâdé tôo wàé. Go tòpò naa gooé ê Nyuâaê Pwicîri. Ée mwa pame ê popai goo pai udò kâra Ba naa na *âji wâro. ");
INSERT INTO priNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ée pwi a tùra ba moo. O càra caa têreê naa na auipitiri. ");
INSERT INTO priNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","O câé caa dàciò bàra watü na ora. O câé caa utàmwara doromara ânye na pâra naa piboo. O câé caa tanoori pâ âboro kîri na ticè nii kàra. O mwa piétò naa gooé tàrù kôo, wâgo Pwiduée. O paari pâ wàé na é *pwi a pa-udò. ");
INSERT INTO priNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Rà mwa cèikî naa gooé êdiri pâ Ba. Ésaïe 42.1–4 ");
INSERT INTO priNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Rà cia medari Iésu pwi jè âboro na é bwi ma kûukû, ba pwa duée gooé. Â é nama é wâdé wà Iésu. Â é jèe tùra, â é jèe niâ. ");
INSERT INTO priNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Â êdiri pâ âboro, âna rà pò goo, â rà pi-ina tàra pâ: «Napwa pwini, âna pwiri Pwi gòobàra Davita na jè gére tapacîê?» ");
INSERT INTO priNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Êco na wà tèpa Farasaio, âna rà ina pâ: «Bwa! Wà pwi âboro bèeni, âna é wakè goo ê pàtàma *Caatana, pwi ukai kà tèpa duée! Êkaa na é tü târa pâ duée.» ");
INSERT INTO priNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Â é tâmogòori auniimiri kàra wà Iésu. Â é ina tàra pâ: «Wiàna é pipaa dèe côwâ ê jè mwaciri, â o tédidirié. Â wiàna é picicaraé côwâ ê caapwi ville, é, caapwi tâa, â o pwacoé ma é cimwü. ");
INSERT INTO priNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Wiàna wà Caatana, pwi ukai kà tèpa duée, âna é tü târa pâ duée, â é pipaa dèe côwâ! Â o wànau târa cè pai cimwü wàra ê mwaciri kêe?! ");
INSERT INTO priNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Guwà ina pâ, wà Caatana na é naa tôo ê pàtàmee ma go tü târa ê pâ duée. Â gona wàilàapà, na naa tà tèpa béewà ê pàtàmee, ma rà tü târa pâ duée? Ba ê pwina rà pwa, âna paari tàwà pâ guwà tàgére pitanami naa gooò. ");
INSERT INTO priNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","«Â napwa wâgo, âna ê Nyuâaê Pwicîri kà Pwiduée, na é naa tôo ê pàtàmee ma go tü târa ê pâ duée. Â wiàna wàrapwiri, â jè cau côo bwàti pâ wà Pwiduée, âna é jèe mara tòpò ê Mwaciri kêe naa jaawà! ");
INSERT INTO priNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","«Â wiàna nümajè na jè tò naa na ê wâ kà pwi âboro na pwa nii kêe, ma jè popa neemuruê, â wâdé na jè mara piié. Â géewê, â jè o mwa bàra pa ê pâ muru na tâa na wâ kêe. ");
INSERT INTO priNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Wà pwina câé caa wâjaao, âna é cicarao. Â wà pwina câé caa pitu tôo ma bu pipanaimari, âna é tédidiri.» ");
INSERT INTO priNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","«Go ina tàwà pâ: O pâri ma pwanauri pâ âboro, na rà tùra ba èpà naa goo Pwiduée ma pwa na èpà tà tèpa béerà. Êco na wà pwina é tùra ba èpà naa goo ê Nyuâaê Pwicîri, âna o càcaa pwanauri ê èpà kêe. ");
INSERT INTO priNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Â o pâri ma pwanauri wà pwina é tùra ba èpà naa goo Pwina naîri âboro. Êco na, wiàna é tùra ba èpà naa goro ê Nyuâaê Pwicîri, â o càcaa pâri ma pwanaurié, naa na wâro bèeni, ma naa na *wâro dàra gòiri awé.» ");
INSERT INTO priNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","«Ê upwâra na wâdé, âna é nye tòpò pwêe na wâdé târa uti. Â ê upwâra na èpà, âna é nye tòpò pwêe na èpà. Ba jè o tâmogòori ê upwâra gée goo ê pwêe. ");
INSERT INTO priNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Â wàrapwiri naa goowà. Ba guwà o wànau târa cè pai ina wàra cè muru cèna wâdé, na guwà tèpa nari dòèa ma tèpa pwâ? Ba ê pwina tabawâbé ê pwâranüma pwi âboro goo, âna wàépwiri na o còobé pwêe, na é tùra. ");
INSERT INTO priNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Ê pâ muru na wâdé, âna me gée goo pwi âboro na é wâdé, ba wâdé pwâranümee. Â ê pâ muru na èpà, âna me gée goo wà pwi âboro na é èpà, ba èpà pwâranümee. ");
INSERT INTO priNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","«Üu, nye âjupâra na go ina tàwà pâ: O mwa pwa ê Tòotù na ée mwa pitèi ê pâ âboro ni gòropuu wà Pwiduée. Â ée mwa jèpa pitèirà goo ê pâ popai èpà na rà ina imudi. ");
INSERT INTO priNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Nye gée goo kaa ê pâ popai'gà, na ée mwa tûâri wà Pwiduée pâ pwiri gà o pwa wârimuru, é, gà o udò ma tâa tâgà ê âji wâro.» ");
INSERT INTO priNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Gée na càùé, â wà pàra tèpa *dotée goro ê Naèà ma wà pàra tèpa Farasaio, âna rà ina tà wà Iésu, pâ: «Pwi a pwa pupûra, paari tâbà cè *câmu kâra pàtàmee na wâgoogà.» ");
INSERT INTO priNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Â é tòpi tàra pâ: «Wâguwà tèpa âboro nabàni, âna guwà dau èpà, â câguwà caa pitêre dà wà Pwiduée. Gorodà na guwà ciburà ilari jiié cè câmu kâra pàtàmee? O nye ticè câmu na guwà mwa caa côo mwara jii i pwi ia é tèepaa tà péroféta Iona biu. ");
INSERT INTO priNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Ba wà Iona, âna ia âracié tòotù ma âracié ne kêe, nanaara i ârawéà. Â o ipaiwà mwara naa goo Pwina naîri âboro, ba o âracié tòotù ma âracié ne kêe, nanaara napuu. ");
INSERT INTO priNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","«Â napwa naa goo wà Iona, âna é picémara ê popai tà tàpé Ninive. Â rà nye pinünüma ma pitòotéri ê wâro kàra. Â guwà côo, é wâni, pwi jè âboro na é dau piwéna jii Iona. Â o tèepaa ê Tòotù na ée mwa pitèi tèpa âboro na wà Pwiduée. Â, na tòotù-bà, âna wà tàpé Ninive, âna rà o cimadò arawà, wâguwà tèpa âboro nabàni, â rà o piciapwâ goowà! ");
INSERT INTO priNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","«Wà tô ilàri ukai naa napô Saba na pàara biu, âna ia é me gée napô kêe na dau wâiti, ba na é têre popai kà ukai *Solomona na tâbawêe goro autâmogòori kêe. Â guwà côo, é wâni jaawà pwi jè âboro na é dau piwéna jii Solomona. Â wàépwiri, na Tòotù na ée mwa pitèi ê pâ âboro na, wà Pwiduée, âna wà tô ilàri ukai-bà, âna ée mwa cimadò na arawà, wâguwà tèpa âboro nabà. Â ée mwa piciapwâ goowà. Ba tàutàwà na guwà têre.» ");
INSERT INTO priNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","«Guwà têre cai ni: Wiàna pwa duée, goo pwi jè âboro; â wiàna é còobé gée gooé, â gona é pâ naapà? É paé ma me, na pâ ére na aupiticia. Ba é mudàra cè ére cèna é tâa wê. Êco na câé caa pâmari. ");
INSERT INTO priNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Â é niimiri pâ, ‘Go wâjué pâ côwâ, naa na i pwârawâ kôo.’ Â é wâjué, â é pâmari i wâ, âna bwaa nye ticè cèna tâa na, âna nye po baléri bwàti, ma pitòimiri bwàti. ");
INSERT INTO priNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Â é wâjué nau mudàra tèpa 7 duée bée, na rà dau èpà jiié. Â rà tò nau pitâa na i wâ. Â wà pwi âboro-bà, âna é mwa dau èpà kaa jii béaa! Â o wàrapwiri, cèna o tèepaa medariwà, wâguwà tèpa âboro nabàni! Ba o dau èpà naa goowà nabàni jii béaa.» ");
INSERT INTO priNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Ûna é bwaa gére patùra tèpa âboro wà Iésu, â rà tèepaa me wà nyaa kêe ma wà tèpa jiié. Â rà coo boo gòroigé, â rà mudèe, ba na rà pitùra. ");
INSERT INTO priNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Â é ina têe wà pwi jè âboro pâ: «Gà côo! Rà wâboo gòroigé wà nyaa'gà ma wà tèpa aéjii'gà. Â rà mudàgà.» ");
INSERT INTO priNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Â é tòpi têe pâ: «Wàilàapà cè nyaa kôo? Â wàilàapà cè tèpa aéjii kôo?» ");
INSERT INTO priNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Â é tòcia tèpa câmu kêe, â é ina pâ: «Guwà côo, wàilà-ni pa nyaa kôo ma tèpa aéjii kôo. ");
INSERT INTO priNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Ba wà pwina é pwa ê câbawâdé kà Pwiduée Caa kôo na é wânidò *napwéretòotù, âna wàé kaa pwiri, ê pwi aéjii kôo, ma tô naigé kôo, ma nyaa kôo.» ");
INSERT INTO priNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Na tòotù bèepwiri, âna é còobé gée na pwârawâ na é pitâa wê wà Iésu, â é boo naaniboo bàrawià. Â é tâaboo ba na é pacâmuri pâ âboro. ");
INSERT INTO priNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Â jèe pâra nau dau wâru ê pâ âboro na rà medarié. Â gée goo pwiri, â é tò naa gòro ê jè wànga na tâa niboo najawé â é tâaboo, ba na é patùrarà. Â wà tèpa âboro, âna rà tâa nidò bàrawià. ");
INSERT INTO priNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Â é pwa ucina wà Iésu na é pacâmurirà, goro ê pâ muru na wâru. Â é ina tàra pâ: «Guwà têre! É mwa tâa wà pwi jè âboro, â é uri ê arapwüru. Â é uri, â é uri, â é uri… ");
INSERT INTO priNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Â napwa ê pàra arapwüru, âna rà tûu naa gòro nyi nari naigé na aupwanapô. Â rà me pâ marü, â rà uti diri. ");
INSERT INTO priNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Â napwa ê pàra pwi, âna rà tûu naa gòrotàrarà. Â rà pò ma cipu, ba càcaa wâru puu wê. ");
INSERT INTO priNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Êco na, na é té ê tòotù, â tòo ê pâ nari arapwüru, â rà marü, ba ticè wàawà kàra. ");
INSERT INTO priNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Â napwa ê pàra pwi, âna rà tûu naa nabibiu kâra pâ nari upwâra na pwa daarà. Â, na rà cipu i pâ nari upwâra bèepwiri, â rà câtàmwara i arapwüru. ");
INSERT INTO priNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Â napwa ê pàra pwi, âna rà tûu naa na napuu na wâdé. Â rà tòpò pwârà—pàra pwi, âna rà tòpò 100 pwêe; â pàra tàpé, na 60; â pàra tàpé, na 30.» ");
INSERT INTO priNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Â é pwa ma ina tàra wà Iésu pâ: «Wà pwina pwa pwâranyüruê, âna wâdé na é têre!» ");
INSERT INTO priNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Wà tèpa *câmu kà Iésu, âna rà dau gée medarié, â rà tawèerié pâ: «Cina gà mu pwa ucina tà pàra tàpé, na gà patùrarà?» ");
INSERT INTO priNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Â é tòpi tàra pâ: «Wà Pwiduée, âna é paari tàwà ê âji pai pwa goo ê Mwaciri kêe. Êco na câé caa paari târa diri ê pâ âboro. ");
INSERT INTO priNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Ba wà pwina jèe pwa têe ê autâmogòorimuru âna o nye piâjagò têe côwâ. Â pwa têe muru na piêdò ma piwéna. Â wà pwina kîri pwina tà têe, âna o nye dàgòtù jiié côwâ ê ji dàramuru na tà têe. ");
INSERT INTO priNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Êkaa pwiri na go pwa ucina tàra na go patùrarà. Ba rà ucâri, êco na càra caa côoinari, â rà têre, â càra caa têreinari. Ba nye âji ticè cèna rà tâmogòori. ");
INSERT INTO priNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Â wàépwiri na rà pacoo i pwi ia é ina wà Pwiduée naa goorà, na é naigé mee wà pwi *péroféta kêe, Isaia, pâ: Rà têre taaci, â càra caa têreina. Ucâri taaci, â càra caa côoina. ");
INSERT INTO priNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Go ina naa goorà— goo pwi Ba kôo bèeni: Pwâranümarà na gòo, pwâranyürurà na kee, âraporomeerà na bwi. Ba péa rà côo ma côoina bwàti. Â péa rà têre ma têreina diri. Â péa rà biirà ma medario côwâ. Péa nama tiàu pâ maagé kâra Ba.» Ésaïe 6.9–10 ");
INSERT INTO priNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Â é ina tà tèpa câmu kêe wà Iésu pâ: «Dau wâdé ba kàwà, ma cidòri nyuâawà, ba guwà côo goro du âraporomeewà, â guwà têre goro du pwâranyüruwà. ");
INSERT INTO priNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Guwà têre bwàti, ba go ina tàwà ê âjupâra pâ: Wâru tèpa péroféta ma tèpa âboro *tàrù na dau nümarà na rà côo ê muru na pwényuâa na guwà côo, êco na càra caa côo. Â nümarà na rà têre ê pâ popai na guwà têre, êco na càra caa têre.» ");
INSERT INTO priNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","«Guwà têre cai ê êre i ucina goro pwi a picâmi: ");
INSERT INTO priNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Ê pàra arapwüru na é tü, âna rà tûu naa gòro naigé. Ê naigé, âna é ipwacèwii naa goo pwi âboro, na é têre popai goro Mwaciri napwéretòotù â câé caa tâmogòori. Â é tèepaa me Pwi âboro èpà, wà *Caatana, â é tàu côwâ ê popai na câmi naa na pwâranümee. ");
INSERT INTO priNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","«Â ê pàra arapwüru, âna rà tûu naa gòrotàrarà. Ê gòrotàrarà, âna pwi âboro na é têre ê popai, â é nye nama tòpi naa na ipwàdée. ");
INSERT INTO priNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Êco na é pwi a tà còmacò, â càcaa wàawà naa gooé, ê popai na é têre. Â ûna tèepaa me mariê ê tacai, ma ûna pwa na èpà têe, majoroé ê pai pitêre dàra kêe ê popai, â é nye nama panuâ cèikî. ");
INSERT INTO priNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","«Â ê pàra arapwüru, âna rà tûu naa na ê pâ na nari upwâra na pwa daaé. Ê napuu bèepwiri, âna pwi âboro, na é têre ê popai. Êco na é còmacò ba é pidumapiê, goro ê pâ namuru, na tèepaa naa na pwi gòropuu bèeni. Â é itàa burà ê pâ neemuru gòropuu, na càcaa âji êkêe. Â câamwara ê popai naa gooé, â o câé caa tòpò cè pwêe. ");
INSERT INTO priNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","«Êco na, napwa naa goo pàra arapwüru, âna rà tûu naa na ê napuu na wâdé. Ê pwi napuu bèepwiri, âna pwi âboro na é têre ê popai, â é tâmogòori. Â pwa pwâra ê popai naa gooé—Pàra pwi, âna rà tòpò 100 pwêe; pàra tàpé na 60; â pàra tàpé mwara na 30.» ");
INSERT INTO priNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","É pwa mwara jè ucina târa pâ âboro wà Iésu, â é ina tàra pâ: «Ê *Mwaciri napwéretòotù, âna pwacèwii ni: «É mwa tâa pwi jè âboro na é pwi a pwa napô. Â é mwa uri ê arapwüru na wâdé, naa na i aupwanapô kêe. ");
INSERT INTO priNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Êco na, na ne, ûna é puu, â wà pwi a èpàrié, âna é tèepaa me. Â é uri ê arapwüru na èpà, naa nabibiu kâra arapwüru na wâdé. Â nabwé, â é pâra. ");
INSERT INTO priNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","«Â rà cipu pâ arapwüru na wâdé, â rà tòpò ê pwârà. Â rà nye cipu mwara i arapwüru na èpà. ");
INSERT INTO priNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Ûna rà côo pwiri wà tèpa wakè goro aupwanapô, â rà ina tà pwi apooé pâ: “Gà côo, co pwi ukai, ia gà uri i arapwüru wâdé, naa na i aupwanapô'gà. Â gona me géepà, ê pâ arapwüru na èpà na wâna?” ");
INSERT INTO priNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","«Â é tòpi tàra pâ: “Bwa, wà pwi a pièpàrio na pwa pwiri.” «Â rà ina têe pâ: “O nye nümagà na bà pâ nau tàu tâjii ê pâ arapwüru na èpà?” ");
INSERT INTO priNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","«Â é tòpi tàra pâ: “Bwa! Ba wiàna guwà tàu ê arapwüru na èpà, â guwà péa tà tàu mwara i arapwüru wâdé. ");
INSERT INTO priNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Â guwà naarà ma rà picipu naima, tèepaa naa goro cè pai piûnya. Ba na pàara bèepwiri, âna go mwa ina tà tèpa wakè kôo pâ, na rà panaimari ê arapwüru na èpà, ma cîri. Â rà tòpò ê arapwüru wâdé, naa na wâra arapwüru kôo.” Nabwé.» ");
INSERT INTO priNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","É pwa tàra mwara jè ucina wà Iésu, â é ina pâ: «Ê Mwaciri napwéretòotù, âna pwacèwii ni: «É mwa tâa pwi jè âboro. É mwa popa ji pudòro moutarde, â é câmi naa na aupwanapô kêe. ");
INSERT INTO priNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Nye ji pwi nara upwâra na dau kîri, jii diri ê pâ naramuru na jè câmi. Êco na, na é cipu, â é jèe pâ nau dau maina jii diri pâ pwina jè câmi naa na aupwanapô. Â rà me pâ marü, na pwa wânaîrà naa gò pâ na ditèe, ba é jèe pâ nau pé upwâra maina.» ");
INSERT INTO priNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","É pwa tàra mwara jè ucina wà Iésu, â é ina pâ: «Ê Mwaciri napwéretòotù, âna pwacèwii mwara ni: Wà tô jè ilàri, âna é popa ê nyaa kâra poloa, â é biinaimari bau 25 kilo goro dàuru poloa. Â é tü tiagoro na é tùu too i poloa!» ");
INSERT INTO priNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Diri ê pâ pwiibà, âna é ina tàra goro pâ ucina, wà Iésu. Â é nye ciburà pwa ucina tàra naa nümee na é patùrarà. ");
INSERT INTO priNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","É wàrapwiri, ba na pacoo i pwi ia é ina wà Pwiduée, na é naigé mee pwi péroféta kêe, pâ: Go mwa pwa ucina na go patùrarà. Go mwa ina tàra pâ muru na cârü gée na autapoo goro gòropuu. Psaume 78.2 ");
INSERT INTO priNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Rà pâra jii tèpa âboro wà Iésu ma wà tèpa câmu kêe, naa pwârawâ. Â naawê, â rà ina têe pâ: «Gà ina tâbà cai ê êre i ucina na ia gà ina naa goro arapwüru na èpà.» ");
INSERT INTO priNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Â é tòpi tàra pâ: «Wà pwina é câmi i arapwüru na wâdé, âna wâgo *Pwina naîri âboro. ");
INSERT INTO priNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Ê aupwanapô, âna pé gòropuu. Napwa ê arapwüru na wâdé, âna wà tèpa naîri Mwaciri. Â wà pwi a pièpàri, âna wà Caatana, Pwi âboro èpà. Â ê arapwüru na é câmi, âna wà tèpa naîê. ");
INSERT INTO priNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Â napwa naa goo ê piûnya, âna pwâadàra gòropuu. Â wà tèpa wakè, âna wà tèpa *angela, tèpa ênawéna kà Pwiduée. ");
INSERT INTO priNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Â rà mwa tòri arapwüru na èpà, â cîri naa gòro ânye. Â o wàrapwiri pai pwa goo tèpa naî Caatana naa pwâadàra gòropuu. ");
INSERT INTO priNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","«Ba wâgo Pwina naîri âboro, âna go mwa cùru me tèpa angela kôo. Â rà mwa patâjii gée na Mwaciri kôo, wà tàpé na rà pwa na èpà—ma diri tàpé na rà nama tubatiàu ê cèikî kà pàra tàpé. ");
INSERT INTO priNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Â rà o mwa türà naa na ânye na maina. Â naawê, âna rà o i ma tòngüru poropwârà wà tàpéebà gée goro pai maagé kàra. ");
INSERT INTO priNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","«Napwa naa goo wà tàpé na rà *tàrù na ara Pwiduée, âna rà o pwâra pwacèwii i tòotù, naa na Mwaciri kà Caa kàra. Wà pwi âboro na pwa pwâranyüruê, âna wâdé na é têre!» ");
INSERT INTO priNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","«Ê Mwaciri napwéretòotù, âna pwacèwii naa goo pâ wâdé na pwàniri naa na jè aupwanapô. Â é pâmari pâ wâdé-bà wà pwi a wakè na aupwanapô. Â é dau ipwàdée kaa. Â é jèu naapwàniri côwâ. Â é icuri diri ê pâ pwina tâa têe, ba na é wâri i aupwanapô-bà.» ");
INSERT INTO priNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","«Ê Mwaciri napwéretòotù, âna pwacèwii mwara ê perle na dau wâdé awé, ma dau too wâri wèe. Â pwa pwi jè a pi-icu na é mudàra ê pâ perle. ");
INSERT INTO priNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Â é pâmari i perle-bà na dau wâdé. Â é nye icuri diri kaa ê pwina tà têe, â é wâri i perle.» ");
INSERT INTO priNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","«Ê Mwaciri napwéretòotù, âna pwacèwii mwara ê puà, na tâa na, na jèpapara ârawéà. ");
INSERT INTO priNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Â jè popa too naa namwari. Â jè tòri ê ârawéà na wâdé, â jè tòpò naa na atà. Â jè tütâjii ê ârawéà na èpà. ");
INSERT INTO priNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Â o wàrapwiri naa na ê pwâadàra gòropuu. Ba ée mwa cùru tèpa angela kêe wà Pwiduée. Â rà o pinaaitiri tàpé na rà tàrù na araé, ma wà tàpé na càra caa pitêre dèe. ");
INSERT INTO priNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Â rà o mwa tü tàpé na càra caa pitêre dèe, naa na ânye na maina. Â naawê, âna rà o i ma tòngüru poropwârà gée goro pai maagé kàra.» ");
INSERT INTO priNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","É tawèeri tèpa câmu kêe wà Iésu, pâ: «Gona guwà nye tâmogòori ê pâ ucina-bà?» Â rà tòpi têe pâ: «Üu.» ");
INSERT INTO priNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Â é ina tàra pâ: «Jè jèe côo cai ni: Pwiri wà pwi *dotée goro ê Naèà, âna é pâ nau pwi âboro na Mwaciri napwéretòotù. Â wiàna wàrapwiri, â é pwacèwii pwi jè apooro pwârawâ, na é côo ê pâ na wâdé kêe na bwaa âmuê, ma ê pâ pwina jèe gòiri jaaé.» ");
INSERT INTO priNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Ûna é ina diri pâ ucina bèepwiri wà Iésu, â é pâra gée na pwi ére-bà. ");
INSERT INTO priNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Â é pâra naa Nazareth, wâna na é maina naawê. Â é pacâmuri pâ âboro goro ê popai kà Pwiduée wâna *wâra pitapitiri. Â rà dau pò gooé, â rà picocoorié ma pi-ina tàra pâ: «Gona wàilàapà na pacâmuriê? Wàilàapà na naa têe ma é pwa ê pâ wakè goro pàtàmee? ");
INSERT INTO priNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Ba wàé pwina naî pwi a wakè goro upwâra, pé pwina naî wà Maria; pwi cià wà Jacques, ma José, ma Simona, ma Jude! ");
INSERT INTO priNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Â wà pa naigé kêe, âna wàilà-ni gére wâro jaajè! Â wàilàapà na naa têe ê autâmogòori ma pàtàmee bèepwiri?» ");
INSERT INTO priNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Â tàutàra na rà cèikî naa gooé. Â é ina tàra pâ: «Wà pwi péroféta, âna càcaa pitòpié bwàti naa na napô kêe.» ");
INSERT INTO priNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Càcaa wâru pâ wakè goro pàtàmee na é pwa wà Iésu na Nazareth, ba càra caa cèikî naa gooé. ");
INSERT INTO priNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Na pàara-bà, âna wà *Héroda Antipas, pwi ukai naa Galilée, âna é pitêre ê jèkutâ goro ê pâ pwina é gére pwa ma ina wà Iésu. ");
INSERT INTO priNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Â é ina tà tèpa ênawéna kêe pâ: «Wà pwi Iésu bèepwiri, âna wà *Ioane Pwi a piupwaa, â é wâro côwâ gée na aubà. Â wàé kaa pwiri ê majoroé ma é pwa ê pâ câmu bèepwiri kâra ê pàtàmee.» ");
INSERT INTO priNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Wàéni ê jèkutâ goro majoro pai bà kà Ioane. Ba wà Héroda, âna ru piéa ma Hérodiade, tô wâdà Filipo, pwi aéjii kêe. Â é nye tà ciburà ina tà Héroda wà Ioane pâ: «Nye ticè tàrù'gà ma gà popa tô ilàri bèepwiri.» Â é nama tâjùru wà Ioane wà Héroda, ma piié ma tòpòé naa na karapuu. ");
INSERT INTO priNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Â nüma Héroda na é pòtàmwereê, êco na wâgotêe goro tèpa âboro, ba wâru gée goorà na rà niimiri pâ é pwi *péroféta me gée goo Pwiduée. ");
INSERT INTO priNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Êco na ticè pai pwa wèe. Â, na pwi tòotù na rà pwamaina ê pai pitèpa Héroda, âna wà tô èpo ilàri kà Hérodiade, âna é câbu ara pâ âboro. Â po dau wâdé tà Héroda. ");
INSERT INTO priNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Â é *ipwataâboro têe pâ: «Go naa tâgà diri cè pwina gà o ilari jiio.» ");
INSERT INTO priNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Â wà tô nyaa kêe, âna é cètùué, ba na é ina tà ukai Héroda pâ: «Gà naa tôo ni i pûru wà Ioane naa na cè jè ngapò.» ");
INSERT INTO priNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","10","Â wà Héroda, âna é piwâ ma pikîri. Êco na é jèe nye ipwataâboro na ara pâ âboro diri. Â é panuâ pwi jè coda naa na karapuu, ba na é tépàgà i nya wà Ioane, ");
INSERT INTO priNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","ma pame i pûruê, ma naa târa i èpo ilàri. Â é popa wà tôoni, â é naa tà nyaa kêe. ");
INSERT INTO priNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Gée na càùé, âna rà mwa caa me nau popa i naii wà Ioane wà tèpa *câmu kêe, ma rà pwàniriê. Â rà pâ nau piwiâ tà Iésu ê pwina tèepaa mari Ioane. ");
INSERT INTO priNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Wà Iésu, âna é têre ê pwina tèepaa mari Ioane. Â é pâra acari gòro wànga naa na jè ére na wâiti, na ticia wê. Êco na, na rà nye pitêre pâ âboro, â rà còobé gée na pâ village, â rà po pâra wiâê wii bàrawià. ");
INSERT INTO priNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Ûna é boo gée na wànga, â é côo i pâ âboro-bà, na dau wâru wàilà, â é po dau meaarirà. Â é pwa ma rà wâdé côwâ wà tàpé na rà maagé. ");
INSERT INTO priNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Jèe pwa na é duu i tòotù, â rà medarié wà tèpa câmu kêe, â rà ina têe pâ: «Ée jèe duu i tòotù, â na, aupiticia ni. Gà panuâ pâ ê pâ âboro bèeni naa na pâ village na tàmwünyabwe, ba na rà o pa cè uti kàra.» ");
INSERT INTO priNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Â é tòpi tàra wà Iésu pâ: «Bwa, càcaa pâri ma rà pâra. Â guwà naa cè uti kàra.» ");
INSERT INTO priNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Â rà ina têe pâ: «Càcaa pâri, ba nye 5 poloa co ma ârailu ârawéà na wâjaabà!» ");
INSERT INTO priNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Â é ina tàra pâ, na rà pame têe. ");
INSERT INTO priNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Â nabwé, â é ina târa pâ âboro pâ, na rà tâaboo naawê. Â é pa i 5 poloa ma i du ârawéà. Â é tagòtùé too naa napwéretòotù, â é pwaolé tà Pwiduée. Â é tubiti i poloa, â é naa tà tèpa câmu kêe, â rà ipâdi târa pâ âboro. Â é wàrapwiri tàra mwara i du ârawéà. ");
INSERT INTO priNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Â rà cau ija diri, tiagoro na rà jèe po cau pwàro diri. Â rà panaimari côwâ ê dàra uti kàra, â rà pwaai 12 nakébò goo. ");
INSERT INTO priNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Êdiri jéû tèpa paao na rà ija, âna po 5 000 kaamwara, â càcaa pûra ilàri ma èpo kîri. ");
INSERT INTO priNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Gée na càùé, â é ina wà Iésu tà tèpa câmu kêe pâ: «Guwà tò naa gò i wànga. Â guwà tàmara gée naanigée na ére gée côwâ.» Ba é bwaa tà tâa, ba na é pawâjuéri côwâ ê pâ âboro. ");
INSERT INTO priNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Ûna é picijiirà diri, â é too naa gòrojaa, ba na é pwapwicîri. Â tòpò ne gooé naawê. ");
INSERT INTO priNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Napwa tèpa câmu kêe, na rà tâa gò i wànga, âna rà jèe wâiti jii napô. Â é pò me cararà ê pwéretòotù, â jèe pwii wià, naa na i wànga. ");
INSERT INTO priNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Na jèe gòropwaa, â é pâra darirà gòro parawére jawé wà Iésu. ");
INSERT INTO priNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Â rà cau côoê, â rà kâa too, ba rà niimiri pâ pé duée, â po dau wâgotàra! ");
INSERT INTO priNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Êco na é nama patùrarà wà Iésu, ma ina tàra pâ: «Tàpéeni, guwà cibwaa nama wâgotàwà! Ba wâgo! Guwà gòo!» ");
INSERT INTO priNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Â é ina têe wà Pétéru pâ: «Pwi Ukai, wiàna wâgà, â gà tûâri tôo pâ go boopaé darigà naa gòro parawére jawé.» ");
INSERT INTO priNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Â é ina têe wà Iésu pâ: «Îgà, boome!» Â é boo gée gòro wànga wà Pétéru, â é tapoo pâra cara Iésu gòro parawére jawé. ");
INSERT INTO priNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Êco na wâgotêe goro i pwéretòotù ma i wià na maina, â é tapoo tàbàtù ma é cònumu boo i najawé. Â é uu ma ina pâ: «Pwi Ukai, gà dàgòtùo!» ");
INSERT INTO priNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Â é nye tu pâ kaa naa goro îê wà Iésu, â é ina têe pâ: «Nye dau kîri kaa ê cèikî'gà! Gorodà na gà pidumapiê?» ");
INSERT INTO priNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Ûna ru too naa gòro wànga, â é tûuboo i pwéretòotù. ");
INSERT INTO priNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Â wà diri tàpé na rà wâgòro i wànga, âna rà tùu jùrurà â rà pwamaina Iésu, â rà ina pâ: «Âjupâra pâ wâgà *Pwina naî Pwiduée!» ");
INSERT INTO priNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Rà jèe tapàgà diri i nawià wà Iésu ma wà tèpa câmu kêe. Â rà tèepaa gée naa na ére na tàmwünyabweri Génésareth. ");
INSERT INTO priNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Â rà côoina Iésu wà tèpa âboro wê. Â rà pi-ina pai tèepaa kêe pitiri ê ére-bà. Â rà cau popa medarié diri tèpa maagé. ");
INSERT INTO priNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Â rà tacoo gooé, â rà ina têe pâ: «Pâri ma rà tu naa goo co ê gòobàra ârabwée'gà?» Â wà diri tàpé na rà tu naa goo, âna rà nye wâdé kaa. ");
INSERT INTO priNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Gée na càùru pàra tòotù, â wà pàra tèpa *Farasaio ma pàra tèpa *dotée goro ê Naèà, âna rà me gée *Iérusaléma nau pâmari Iésu. Â rà ina têe pâ: ");
INSERT INTO priNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","«Wà tèpa *câmu'gà, âna càra caa pitêre dàra ê nyamanya kà tèpa nyimujè ma upàjè, ba càra caa nuwa ê îrà béaari ê pai ija, wàra naa na nyamanya kâjè. Âna gorodà, co pwini?» ");
INSERT INTO priNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Â é tòpi tàra pâ: «Wâguwà, âna câguwà caa pitêre dàra câbawâdé kà Pwiduée gée goro ê nyamanya kàwà. Âna gorodà? ");
INSERT INTO priNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Ba é ina wà Pwiduée pâ: Gà papwicîri du nyaa ma caa'gà. Â é ina mwara pâ: Wà pwi âboro na é ina ba èpà du nyaa ma caa kêe, âna guwà nama é bà. ");
INSERT INTO priNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","«Êco na wâguwà, âna guwà nye ina tà tèpa âboro pâ, nye wâdé na rà ina tà du nyaa ma caa kàra pâ: “Nümoo na go naa tàu cè jè muru târa pitu tàu; êco na càcaa pâri. Ba ê pwina nümoo na go naa tàu, âna ê âraimeai pwicîri tà Pwiduée.” ");
INSERT INTO priNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","«Êkaa na, guwà pacâmurirà, ma càra caa papwicîri du nyaa ma caa kàra! Â, na wàrapwiri, na guwà còogai naa napuu ê popai kà Pwiduée, goo ê pâ nyamanya kàwà! ");
INSERT INTO priNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Guwà tèpa âboro na câguwà caa *tàrù! É nye âjupâra wà *péroféta Isaia, na ia é naigé mara ê popai kà Pwiduée naa goowà, pâ: ");
INSERT INTO priNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Tèpa âboro bèepwiri, âna rà po ipwamainaô co goro pwârà ma pwâratùra. Â wâiti jiio pwâranümarà. ");
INSERT INTO priNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Rà pwapwicîri tôo ma pwa *ârapwaailò tôo, â piticèmuru naa goo. Rà pacâmuri pàra tàpé ba na rà wârori ê naèà. Â càcaa naèà kôo. Ba naèà kàra co.» Ésaïe 29.13 ");
INSERT INTO priNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Gée na càùé, â é todàra pâ âboro wà Iésu, â é ina tàra pâ: «Tàpéebà! Guwà tàmaariô, â guwà tâmogòori cai ê pwina go ina tàwà: ");
INSERT INTO priNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Càcaa pwina tò, naa pwâ pwi âboro, na o nama é miiri na ara Pwiduée. Ba êco pwina é còobé gée na pwêe, na é *miiri goo.» ");
INSERT INTO priNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Â rà gée paé dà Iésu tèpa câmu kêe, â rà ina têe pâ: «Gà côo, ê pâ popai'gà, âna dau tanoori tèpa Farasaio, gà nye tâmogòori?» ");
INSERT INTO priNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Â é tòpi tàra pâ: «Tèpa Farasaio bèepwiri, âna rà pwacèwii ê pâ upwâra na câé caa câmi wà Caa kôo nidò *napwéretòotù. Â ée mwa dàtàu. ");
INSERT INTO priNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Guwà naarà! Ba rà tèpa bwi, na rà popa tèpa bwi. Âna rà o cau tûu naa na pwêe!» ");
INSERT INTO priNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Â é ina tà Iésu wà Pétéru pâ: «Gà ina tâbà êre ucina goo ê pwina é miiri goo, wà pwi âboro.» ");
INSERT INTO priNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Â é tòpi wà Iésu pâ: «Gona wâguwà mwara, tèpa câmu kôo, âna bwaa càcaa pâji pâri ma guwà tâmogòori pwiri? ");
INSERT INTO priNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Guwà côo, diri ê pwina tò pwâ pwi âboro, âna pâ naa nanaaê, â gée na càùé, â é còobé gée naiié. ");
INSERT INTO priNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Êco na ê pâ popai na còobé gée pwâ tèpa âboro, âna rà me gée na pwâranümarà, â êkaa pwiri na rà miiri goo— ");
INSERT INTO priNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","ê pâ auniimirimuru, ma câbawâdé na èpà. Âna gée goo pwiri kaa, na rà pwa pâ muru na èpà: Rà tétàmwara âboro; Rà toomura (rà cîâa jii wâdàra); Rà ipuu ma tèpa âboro imudi; Rà mura; Rà ina pwina pwâ naa goo pàra tàpé; Rà tùra ba èpà naa goorà. ");
INSERT INTO priNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","«Wàépwiri ê pwina é nama jè miiri goo, na ara Pwiduée. Â câjè caa miiri goro ê pai càcaa nuwa ê îjè.» ");
INSERT INTO priNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Gée na càùé, â rà pâra gée na ére bèepwiri wà Iésu ma wà tèpa câmu kêe, naa na ére goro jènere ê du ville Tyr ma Sidon. ");
INSERT INTO priNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Â é medari Iésu wà tô jè ilàri gée na ére-bà, ba na é patùra Iésu. Wà tôoni, âna câé caa tô Juive, ba é tô gòobàra tèpa *Kanana, ê pwi Ba na rà tèpa pièpàri tèpa *Juif. Â é tomara too pâ: «Pwi Ukai, *Pwina naî Davita, gà meaario ma pitu tôo! Ba i èpo kôo, âna pwa duée gooé, â é po dau maagé goo.» ");
INSERT INTO priNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Êco na câé caa tòpi têe wà Iésu, goro cè caapwi pwâratùra. Â rà gée paé dèe wà tèpa câmu kêe, â rà tacoo gooé ma ina têe pâ: «Gà nama é pâra pé tô ilàri bèepwiri! Ba é nye tà ciburà to ma nama pikòi na nyürujè!» ");
INSERT INTO priNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Â é ina têe wà Iésu pâ: «Wà Pwiduée, âna é nye panuâô me co tà tèpa âboro *Isaraéla, na rà pwacèwii ê nari mutô na rà imwüru.» ");
INSERT INTO priNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Êco na wà i tô ilàri, âna é po me nau tùu jùrué ara Iésu, â é tacoo gooé ma ina têe pâ: «Pwi Ukai, gà pitu tôo!» ");
INSERT INTO priNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Â é tòpi têe wà Iésu pâ: «Càcaa wâdé na jè popa ê uti kâra nyi nari èpo ma jè tü târa ê pâ ‘nari akàna’.» ");
INSERT INTO priNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Â é ina wà tôoni pâ: «Bwa, Pwi Ukai, gà nye âjupâra. Êco na wà tèpa nari akàna mwara, âna rà nye ija ê muupàra ê utimuru, na tûu gée gòro taapà kà pwi caa kàra.» ");
INSERT INTO priNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Â é tòpi têe wà Iésu pâ: «Tôoni, dau maina ê cèikî'gà! Wâdé na wàra ê pwina nümagà goo!» Â nye tiàu kaa i maagé kâra i èpo kêe! ");
INSERT INTO priNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Gée na càùé, â é pâra wà Iésu gée na ére bèepwiri. Â é pâra wii bàrawià Galilée. Â géewê, â é too naa gòrojaa, â é tâaboo naawê. ");
INSERT INTO priNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Â rà medarié ê pâ âboro na rà dau wâru. Â rà pame têe tàpé na rà bee, wà tàpé na rà bwi, ma wà tèpa pitàbwamwa, ma wà tàpé na rà kûukû, â wâru mwara pàra maagé. Â rà cau naarà me na ara Iésu, â é cau nama tiàu ê pâ na jèpapara maagé kàra. ");
INSERT INTO priNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Â wà tèpa kûukû, âna rà jèe tùra. Â wà tèpa pitàbwamwa, âna rà jèe pâra. Â wà tèpa bee, âna jèe wâdé ârà. Â wà tèpa bwi, âna rà jèe niâ. Â rà po pò goo diri ê pâ âboro, â rà ipwamaina Pwiduée kà tèpa Isaraéla! ");
INSERT INTO priNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","É todà tèpa câmu kêe wà Iésu, â é ina tàra pâ: «Go meaari tèpa âboro bèeni! Ba jèe âracié tòotù kâjè ma wàilà, â jèe ticè utimuru. Â càcaa pâri ma go pawâjuérirà, na càra caa ija. Ba péa tà ticè nii kàra wii naigé.» ");
INSERT INTO priNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Â rà ina têe wà tèpa câmu kêe pâ: «Jè o wànau cè pai naa uti kàra diri, naani na pé ére na auticia? Ba gà côo, rà po dau wâru awé!» ");
INSERT INTO priNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Êco na é ina co pâ: «Gona âradipi poloa na wâjaawà?» Â rà ina têe pâ: «7 poloa, â pàra nari ârawéà.» ");
INSERT INTO priNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Nabwé, â é ina tà tèpa âboro pâ, na rà tâaboo. ");
INSERT INTO priNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Â é popa i pâ 7 poloa bau i pâ ârawéà, â é pwaolé tà Pwiduée. Â é tubiti, â é naa tà tèpa câmu kêe. Â rà ipâdi naa goo tèpa âboro. ");
INSERT INTO priNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Â rà ija tiagoro na rà jèe po cau pwàro diri. Â gée na càùé, â wà tèpa câmu, âna rà tòri ê dàra bwà, â po 7 nakébò maina na wâbé! ");
INSERT INTO priNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Po 4 000 paao na rà ija, â càcaa pûra ilàri ma èpo kîri! ");
INSERT INTO priNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Â nabwé, â é ina tàra wà Iésu pâ, na rà wâjué côwâ naa jaarà. Â wà Iésu ma wà tèpa câmu kêe âna rà tò naa gò i wànga, â rà pâra naa na ére Magadane. ");
INSERT INTO priNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Na jè tòotù, âna rà medari Iésu wà pàra tèpa *Farasaio ma *Sadukaio. Ba nümarà na rà pitü tûâ têe. Â rà ina têe pâ: «Paari tâbà ê câmu kâra ê pàtàmee na wâgoogà.» Ba nümarà na rà paari pâ câé caa wakè goro pàtàma Pwiduée. ");
INSERT INTO priNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Â é tòpi tàra pâ: «Na é mii napwéretòotù na auduu kâra i tòotù, â guwà ina pâ, o wâdé napô. ");
INSERT INTO priNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","«Â wiàna piduu i napô naa dàuru, â guwà ina pâ, o popaa. Ba guwà po dau tâmogòori naa wâdé napô, é, naa èpà napô. Êco na, na guwà côo ê pâ muru na gére tèepaa nabà, â tàutàwà na guwà côoina ê âjupâra. ");
INSERT INTO priNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Ba tàutàwà na guwà pitêre dà Pwiduée, ba guwà tèpa pwa na èpà! Wâguwà tèpa âboro nabà, âna guwà ciburà ilari jiié cè câmu kâra ê pàtàmee. Êco na nye ticè câmu kêe na guwà mwa caa côo mwara jii i pwi ia é tèepaa tà *péroféta Iona.» Â é pâra jiirà wà Iésu. ");
INSERT INTO priNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Rà tapàgà *nawià Galilée wà tèpa *câmu. Ûna rà tèepaa pâ, â rà côo pâ rà ipwanauri na rà popa cè poloa. ");
INSERT INTO priNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Â é ina tàra wà Iésu pâ: «Guwà ipwacôowà goro nyaa kâra poloa kà tèpa Farasaio ma tèpa Sadukaio!» ");
INSERT INTO priNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Â rà pi-ina tàra pâ: «Pwiri gée goro na câjè caa pa poloa?» ");
INSERT INTO priNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Â é têre wà Iésu, â é ina tàra pâ: «Nye dau kîri kaa ê cèikî kàwà! Cina guwà pi-ina tàwà pâ, câguwà caa pa poloa? ");
INSERT INTO priNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Bwaa nye gére câguwà caa tâmogòori kaa? Gona câguwà caa niimiri i 5 poloa târa i 5 000 âboro? Ê tòotù-bà, âna ia guwà tòri côwâ âradipi nakébò? ");
INSERT INTO priNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Â napwa naa goo i 7 poloa kâra i 4 000 âboro, â ê tòotù-bà, âna âradipi nakébò na ia guwà tòri côwâ? ");
INSERT INTO priNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","«Go jèe nye ina tàwà pâ: Guwà ipwacôowà goro nyaa kâra poloa kà tèpa Farasaio ma tèpa Sadukaio. Êco na câgo caa ina tàwà poloa na jè ija! Â gona câguwà caa tâmogòori pwiibà?» ");
INSERT INTO priNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Â rà mwa bàra tâmogòori tèpa câmu kêe pâ, é ina tàra pâ, na rà côoco ê ârapupûra kà tèpa Farasaio ma Sadukaio. ");
INSERT INTO priNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Wà Iésu ma wà tèpa câmu kêe, âna rà tèepaa naa na ére gée goo ê ville Césarée-Filipo. Â é tawèerirà pâ: «Wà tèpa âboro, âna rà ina pâ wâgo wàa, wâgo *Pwina naîri âboro?» ");
INSERT INTO priNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Â rà tòpi têe pâ: «Wà pàra tàpé, âna rà ina pâ wâgà *Ioane Pwi a piupwaa. Â wà pàra tàpé, âna rà ina pâ wâgà péroféta *Élia. Â wà pàra tàpé, âna rà ina pâ wâgà Iéremia, é, pwi jè ârapàara tèpa péroféta biu.» ");
INSERT INTO priNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Â é ina tàra wà Iésu pâ: «Â gona wâguwà na? Guwà ina pâ wâgo wàa?» ");
INSERT INTO priNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Â é tòpi têe wà Simona Pétéru pâ: «Wâgà, âna gà pwi *Mesia, *Pwina naî Pwiduée na é wâro.» ");
INSERT INTO priNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Â é ina têe wà Iésu pâ: «Cidòri nyuâagà co Simona, pwina naî Iona. Ba càcaa pwi âboro na é nama gà tâmogòori ê pwiibà, â nye wà Caa nidò *napwéretòotù. ");
INSERT INTO priNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Êkaa na go ina tâgà ni, pâ: Neegà Pétéru, pai ina wèe pâ ‘Atü’. Â wâgòro ê atü bèepwiri na go bari ê wâra pwapwicîri kôo. Â ê pàtàmara bàutê, âna ticè nii kêe naa goo. ");
INSERT INTO priNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Ê pwina gà papwicîri jii tèpa âboro naaniboo gòropuu, âna wà Pwiduée naa napwéretòotù, âna é papwicîri. Â ê pwina gà panuâ, naani gòropuu, âna wà Pwiduée naa napwéretòotù, âna é panuâ.» ");
INSERT INTO priNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Â é papwicîri ba gòo jii tèpa câmu kêe wà Iésu na rà ina târa cè jè âboro pâ, wàé pwi Mesia. ");
INSERT INTO priNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Tapoo na pàara bèepwiri, na é gére inapàpari tà tèpa câmu kêe wà Iésu, pâ: «Wâdé na go pâra naa *Iérusaléma. Â rà o dau pwa-imudiri tôo ma nama go pwamaagé côo wà tèpa pitûâ ma wà tèpa caa kà tèpa pwa *ârapwaailò, ma wà tèpa *dotée goro ê Naèà. Â rà o pwa ma go bà. Êco na, naa na béâracié kâra tòotù gée na càùé, âna go o mwa wâro côwâ.» ");
INSERT INTO priNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Â é todà Iésu naa na jè ére wà Pétéru, â é pwaé ma ina têe pâ: «Bwa, co Pwi Ukai! O nye ticè cèna tèepaa marigà cèna wàrapwiri!» ");
INSERT INTO priNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Â é tabiié Iésu naa goo Pétéru, â é ina pâ: «*Caatana, gà tùugà géeni arao! Gà tàgére pwa na gà tabiio jii ê câbawâdé kà Pwiduée, ba câgà caa niimiri pwacèwii Pwiduée, â gà niimiri pwacèwii tèpa âboro!» ");
INSERT INTO priNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Â é ina tà tèpa câmu kêe wà Iésu pâ: «Wiàna nüma cè pwi jè âboro na é me wiâô ba na é pwi a câmu kôo â é cibwaa mwa tà piniimiriê côwâ. Â wâdé na é kâa ê *kurucé kêe, â é me wiâô. ");
INSERT INTO priNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Ba wà pwina nümee na é ipwamuru ê wâro kêe, âna ée mwa tubatiàu. Â wà pwina é tubatiàu ê wâro kêe ba kôo, âna wà pwiibà, âna ée udò ma tâa têe ê *âji wâro. ");
INSERT INTO priNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Â târa dà kà pwi âboro na é tòpi diri ê pâ wâdé ni gòropuu wiàna é tubatiàu ê nyuâaê? Gona dà cèna o pâri ma é icuri târa ma é pâmari côwâ ê nyuâaê? ");
INSERT INTO priNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","28","«Guwà têre bwàti: Go ina tàwà diri ê pwiibà, ba go o mwa wâjué me côwâ naani gòropuu, nau tòpò ê pwâra ukai kôo, wâgo Pwina naîri âboro. Â bà mwa me ma wà tèpa *angela kôo, naa na pàtàma Pwiduée ma pai maina ma muugère kêe. Â go o mwa naa pumara wakè tà tèpa âboro wiâra jèpa wakè kàra. Â wà pàra tàpé gée goowà, âna rà o bwaa côo ê pai tèepaa me kôo naa na pwâra ukai kôo, béaari cè pai bà kàra.» ");
INSERT INTO priNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Gée na càùru 6 tòotù, â wà Iésu, âna é popa wà Pétéru, ma wà tupédu aéjii Jacques ma Ioane. Â rà too naa gòrojaa. ");
INSERT INTO priNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Géewê, â pitòotéri pai côo Iésu, na ararà. Ba ê naporomee, âna pwâra pwacèwii tòotù, â ê ârabwée kêe, âna pwaa pwacèwii ê dapàra tòotù. ");
INSERT INTO priNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Â rà nye côo kaa wà *Moosé ma wà Élia, tupédu *péroféta béaa na rà gére pitùra. ");
INSERT INTO priNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Â é ina tà Iésu wà Pétéru pâ: «Pwi Ukai, nye po dau wâdé tâbà, na bà gére tâa ni jaagà. Â wiàna nümagà, â go pacima âracié wâ imwaano naani, ba na kâgà jèpwi, â kà Moosé jèpwi, â kà Élia jèpwi.» ");
INSERT INTO priNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Na é bwaa gére tùra, â é tèepaa me ê jè nee na é pwâra, â é cajipirà. Â rà têre ê pwâratùra gée na i nee na ina pâ: «Wà pwini, âna wàé co kaa pwiri wà Pwina naîô na caapwi co na go dau meaarié. Wàé kaa na go jèe nye pitòrigarié, ba dau wânümoo têe. Â guwà pitêre dèe!» ");
INSERT INTO priNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Â wà tèpa *câmu, âna rà tùu jùrurà ma cigòboo goo pai wâgotàra. ");
INSERT INTO priNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Â é medarirà wà Iésu, â é tu naa goorà ma ina tàra pâ: «Guwà cimadò! Â guwà cibwaa nama wâgotàwà!» ");
INSERT INTO priNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Ûna rà tagòtùrà wà tèpa câmu, â rà côo pâ jèe nye tà wàilà acari ma Iésu. ");
INSERT INTO priNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Ûna rà tàbàtù boo côwâ gée gòrojaa, â é tûâri tàra wà Iésu pâ: «Guwà cibwaa ina târa cè jè âboro ê pwi na ia guwà côo, tiagoo ê tòotù, na go mwa wâro côwâ gée na aubà wâgo *Pwina naîri âboro.» ");
INSERT INTO priNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Â rà tawèeri Iésu wà tèpa câmu pâ: «Rà ina tèpa *dotée goro ê Naèà pâ, wà Élia, âna é pwi a mara pâbéaa kà pwi *Mesia, *pwi a pa-udò. Âna gorodà?» ");
INSERT INTO priNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Â é tòpi tàra Iésu pâ: «Üu, é mara pâbéaa me wà Élia, ba na é tòpò bwàti diri pâ muru, naa na pai tâa wê. ");
INSERT INTO priNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Êco na go ina tàwà pâ: É jèe nye me wà Élia. Â càra caa côoinaê ê pâ âboro, â rà nye pwa têe ê pwina èpà na nümarà goo. Â wàrapwiri mwara naa gooò, na go o mwa tà pwamaagé côo goorà, wâgo Pwina naîri âboro.» ");
INSERT INTO priNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Â rà pâra nau tâmogòori wà tèpa câmu pâ na é ina tàra wà Élia âna é ina wà *Ioane Pwi a piupwaa. ");
INSERT INTO priNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Na rà boome côwâ gée gòrojaa wà Iésu ma wà tèpa câmu kêe, â rà tèepaa mari tèpa âboro. Â é medari Iésu pwi jè âboro, â é tùu jùrué araé. ");
INSERT INTO priNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Â é ina têe pâ: «Pwi Ukai, gà meaari pwi naîô. Ba wâgooé duée na é nama é céca, â é po dau maagé goo. Na pàra pàara, âna é tüê naa na ânye ma najawé. ");
INSERT INTO priNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Â go jèe popaé me tà tèpa câmu'gà, â càcaa pâri ma rà nama é wâdé.» ");
INSERT INTO priNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Â é ina tàra wà Iésu pâ: «Go nyi meaariwà wâguwà tèpa âboro nabà! Ba bwaa câguwà caa cèikî, â guwà tèpa imwüru! Tiagoro wiidà na go o bwaa nye tà tâa jaawà, ma pidàpwicâariô naa goowà? Popa me cai naani i pwi nari âboro èpo!» ");
INSERT INTO priNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","É pwa i duée wà Iésu, â é ina têe pâ: «Gà còobé!» Â é còobé, â é nye wâdé kaa i pwi nari âboro èpo. ");
INSERT INTO priNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Gée na càùé, na rà mwa nye tà tâa acari wà Iésu ma tèpa câmu kêe, â rà me burèe, â rà tawèerié pâ: «Cina càcaa pâri ma bà pwa ma é còobé i duée?» ");
INSERT INTO priNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Â é tòpi tàra pâ: «Wàrapwiri, ba dau kîri kaa cèikî kàwà. Â guwà têre bwàti, ba go ina tàwà ê âjupâra pâ: Wiàna ê cèikî kàwà, âna é dau kîri pwacèwii ji nari murunyabu, â o pâri ma guwà ina târa jaa bèeni pâ: “Gà pâra” â ée pâra! Â o nye ticè cèna mwa caa pwacoé tàwà. { ");
INSERT INTO priNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Nye gée goro co ê pwapwicîri tà Pwiduée, ma ipwanya, na o pâri ma jè pacòobé ê pwi pwâra duée bèepwiri.}» ");
INSERT INTO priNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Gée na càùé, â rà ipitiri naa napô Galilée wà Iésu ma wà tèpa câmu kêe. Â é ina tàra wà Iésu pâ: «O mwa icurio tà tèpa âboro, wâgo Pwina naîri âboro. Â rà mwa tâjùruo, ");
INSERT INTO priNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","â rà o mwa pwa ma go bà. Êco na, naa na béâracié kâra tòotù gée na càùé, â go o mwa wâro côwâ gée na aubà.» Ûna rà têre pwiri, â rà nye dau pikîri kaa wà tèpa câmu kêe. ");
INSERT INTO priNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Rà tèepaa pâ naa Capernaüm wà Iésu ma wà tèpa câmu kêe. Â wà tèpa *tò mwani wâripû goro *Wâra pwapwicîri, âna rà pâmari Pétéru, â rà tawèerié pâ: «Gona wà pwi caa kàwà, âna é nye tòpò mwara ê wâripû, târa Wâra pwapwicîri?» ");
INSERT INTO priNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Â é tòpi tàra wà Pétéru pâ: «Wè! Üu! É nye wâri mwara!» Gée na càùé, â é tò naa wâ na é tâa wê wà Iésu. Â é nye pò ma tùra wà Iésu, ma ina têe pâ: «Simona, dà cè pai côo'gà? Wàilàapà cè pwina na é wâri ê napuu? Wà pwi apooro napô, é, wà pwi pârame?» ");
INSERT INTO priNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Â é tòpi têe wà Pétéru pâ: «Wà pwi pârame.» Â é ina têe wà Iésu pâ: «Üu kaa, â wà pwi apooro napô, âna câé caa wâri. ");
INSERT INTO priNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Êco na ju cibwaa tanoorirà. Gà pâra nau pwa pwé. Â jè ârawéà na gà téri, âna gà cébòaa pwêe, â gà o pâmari mwani naa na. Â gà popa ma wâripû kâju târa Wâra pwapwicîri.» ");
INSERT INTO priNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Na pwi pàara-bà, âna rà medari Iésu wà tèpa *câmu kêe, â rà tawèerié pâ: «Gona wàilàapà cè pwi âboro na pwamuru naa gooé naa na *Mwaciri napwéretòotù?» ");
INSERT INTO priNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Â é todà ji nari èpo, â é tòpòé boo naa nabibiu kàra, ");
INSERT INTO priNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","â é ina tàra pâ: «Guwà têre bwàti, ba go ina tàwà ê âjupâra pâ: Wiàna câgà caa ipakîrigà, ma gà wàra nyi nari èpo, â o câgà caa tò naa na Mwaciri napwéretòotù. ");
INSERT INTO priNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Â wiàna gà ipakîrigà pwacèwii ji nari èpo bèeni, â gà pwi âboro imaina naa na Mwaciri napwéretòotù. ");
INSERT INTO priNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Â wà pwina é tòpigà naa na neeô, âna é tòpio.» ");
INSERT INTO priNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","«Gà cibwaa pwa ma gùmagù ê cèikî kà pwi âboro kôo, na é pwacèwii nari èpo. Ba ê wârimuru'gà, âna o pwacèwii na jè tòo naa goro nyagà cè pé atü cèna maina, â jè tügà naa nanumwiri—â o dau maina jii pwiri! ");
INSERT INTO priNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","O nye ciburà wâru pâ naigé mara èpà na o paari tâjè naa na gòropuu bèeni. Êco na é tojii wà pwi âboro na é popa pwi jè bée naa na naigé bèepwiri! ");
INSERT INTO priNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","«Êkaa na, wiàna majoroé ê îgà, é, âgà, na gà pwa na èpà, â gà tapàgà, â gà tâjii naaiti jiigà. Ba o wâdé ba kâgà, wiàna gà tò naa na *âji wâro, pa caapwi îgà, ma caapwi âgà. Dau pwaée'gà wiàna gà wéaari ê du îgà ma du âgà, â tügà naa na ânye na ticè pwâadèreè, â gà o pwamaagé côo naawê. ");
INSERT INTO priNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Â wiàna majoroé ê âraporomeegà na gà pwa na èpà, â gà èrù tâjii. Ba o wâdé ba kâgà, na gà tò naa na âji wâro, pa caapwi âraporomeegà. Dau pwaée'gà na gà wéaari ê du âraporomeegà, â tügà naa na ânye, naa na ére na gà pwamaagé côo naawê.» ");
INSERT INTO priNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","«Guwà ipwacôowà pâ, guwà péa ipwatétéri imudi tà ji pwi a cèikî naa gooò! Ba go ina tàwà ê âjupâra pâ: Wà tèpa *angela na rà jèpa wéaarirà, âna rà nye ciburà tâa jaa Caa kôo naanidò napwéretòotù. { ");
INSERT INTO priNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Ba wâgo *Pwina naîri âboro, âna go me nau pa-udò tàpé na jèe tiàurà, ma naa tàra ê âji wâro.} ");
INSERT INTO priNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","«Guwà jèe têre cai ni: «Wà pwi jè âboro, âna pwa 100 mutô kêe. Â wiàna tiàu pwi caapwi gée goorà, â é pwa dà? É naaco i 99 mutô, â é pâ nau mudàra i mutô kêe na ia tiàué. ");
INSERT INTO priNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Â wiàna é pâmariê, â na pwi tòotù-bà, âna é dau ipwàdée goo i caapwi mutô, jii ê 99 na rà nye tà tâa. Êkaa na guwà têre bwàti, ba go ina tàwà ê âjupâra pâ: ");
INSERT INTO priNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","O ipaiwà naa goo wà Caa kàwà na wânidò napwéretòotù. Ba tàutêe na tiàu cè ji pwi caapwi a cèikî naa gooò.» ");
INSERT INTO priNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","«Wiàna é pwa {tâgà} cèna èpà wà pwi a cèikî béegà, â gà pâra mariê, â gàu mara pitùra bwàti, â gà paari têe ê èpà kêe. Â wiàna é pitêre dàgà, â jèe wâdé, ba gà jèe popaé còobé jii ê èpà. ");
INSERT INTO priNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Â wiàna câé caa têregà, â gà pwa ê pwina wii naa na *Tii Pwicîri: Gà popa cè caapwi, é, ârailu a cèikî, ma guwà pitùra ma wàé, ba ru mwa *paâjupâra ê pwâra pitùra kàwà. ");
INSERT INTO priNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Â wiàna tàutêe na é têrewà, â gà ina târa diri ê picaatâa. Â nabwé, wiàna é pitèi ê picaatâa pâ gà âjupâra, â bwaa tàutêe na é têre, â guwà cibwaa ipacè naa gooé, ba é pâ nau pwacèwii tàpé na càra caa cèikî, ma tèpa *tò mwani wâripû na rà pwâ ma iau. ");
INSERT INTO priNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","«Guwà têre bwàti, ba go ina tàwà ê âjupâra pâ: Diri ê pâ muru na guwà papwicîri jii tèpa âboro naani gòropuu, âna wà Pwiduée, wâ napwéretòotù, âna é papwicîri mwara. Â êdiri pâ muru na guwà panuâ naani gòropuu, âna wà Pwiduée wâ napwéretòotù, âna é panuâ mwara.» ");
INSERT INTO priNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","«Jèpwi mwara: Wiàna tupédu ârailu gée goowà, âna ru caapwi naa goro cè pwina ru pwapwicîri naa goo, â wà Caa kôo na é wânidò napwéretòotù, âna ée mwa naa tàru. ");
INSERT INTO priNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Ba wiàna ârailu ma âracié na rà papitirirà ma pitêrerà naa na neeô, â na go wânabibiu kàra.» ");
INSERT INTO priNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","É medari Iésu wà Pétéru, â é tawèerié pâ: «Pwi Ukai, wiàna é tà ciburà pwa na èpà tôo wà pwi a cèikî béeò, â go pwanaurié tiagoro wiidà? Tiagoro 7?» ");
INSERT INTO priNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Â é tòpi têe wà Iésu pâ: «Câgo caa ina tâgà pâ tiagoro 7, é, tiagoro 7 000. Gà nye tà pwanaurié taaci. ");
INSERT INTO priNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Ba ê Mwaciri napwéretòotù, âna pwacèwii ni: «É mwa tâa pwi jè ukai. Â, na jè tòotù, â nümee na é tâmogòori ê jèpa kéredi kà tèpa ênawéna kêe jècaa. ");
INSERT INTO priNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Â é tapoo naa goo pwi jèpwi. Â rà cia me têe pwina jèe too naa goro miliô ê kéredi kêe, âna pâ miliô. ");
INSERT INTO priNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Â jèe càcaa pâri ma é pitôowâri. «Â é tûâri wà pwi ukai pâ: “Icurié pwacèwii pwi âboro na ticè tàrù kêe. Icuri mwara wâdèe, ma wà pa èpo kêe, ma ê pâ neemuruê! Icuri diri, ba na pai pitôowâri kêe ê kéredi kêe!” ");
INSERT INTO priNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","«Êco na wà pwini, âna é tùu jùrué ara pwi ukai, â é i, ma ina têe pâ: “Go ilagà pâ, gà tàpo dàpwicâarigà, ba go mwa nye pitôowâri tâgà diri!” ");
INSERT INTO priNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","«Â wà pwi ukai, âna é dau meaarié, â é câtùra tâjii i kéredi kêe, â é panuâê ma é pâra. ");
INSERT INTO priNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","«Â nabwé, â é pâra i pwi ênawéna, â ipitiru ma i pwi bée goro wakè na ia é pa jiié ji caapwi mwani atü. Â é tâjùru pwiibà, â é cérunyee ma ina têe pâ: “Gà piawài, ma gà pitôowâri i mwani kôo!” ");
INSERT INTO priNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","«Â é tùu jùrué wà pwiibà na araé, ma ina têe pâ: “Go ilagà pâ, gà tàpo pidàpwicâarigà, ba go mwa nye pitôowâri tâgà!” ");
INSERT INTO priNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","«Êco na tàu tà wà pwini, â é pwa ma tüê naa na karapuu, tapacîri cè pai o mwa pitôowâri kêe diri i kéredi. ");
INSERT INTO priNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","«Â wà tèpa wakè béeru, âna rà pò goo, â dau èpà tàra. Â rà pâra nau piciapwâ tà pwi ukai kàra. ");
INSERT INTO priNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","«Â é todà i pwi ênawéna bèeni i pwi ukai, â é ina têe pâ: “Gà pé pwi ênawéna na piticèmuru naa googà! Ba ia go câtùra tâjii diri i kéredi'gà na po dau maina, ba ia gà me nau po i gooò! ");
INSERT INTO priNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Â wâgà mwara na pwiri gà nye gére meaari pwi béegà, wàra pai meaarigà kôo!” ");
INSERT INTO priNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","«Â é po dau putàmu wà pwi ukai, â é nama tâjùru i pwi ênawéna, ma tòpòé naa na karapuu. Â é pwa wârimuru têe, tapacîri cè pai o mwa pitôowâri kêe, diri ê pâ kéredi kêe.» ");
INSERT INTO priNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Â é tubanabwé ê ucina bèepwiri wà Iésu, â é ina pâ: «O ipaiwà pwina é pwa tâgà wà Caa kôo nidò napwéretòotù, wiàna câgà caa pwanauri pwi a cèikî béegà, gée na âji pwâranümagà. Nabwé.» ");
INSERT INTO priNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Ûna é ina diri ê pwiibà wà Iésu, â é pâra gée napô Galilée, naa na ére *Judée gée côwâ kâra nairiwâ Ioridano. ");
INSERT INTO priNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Â wâru pâ âboro na rà pâra wiâê. Â é pwa ma rà wâdé côwâ wà tàpé gée goorà na rà maagé. ");
INSERT INTO priNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Â rà me burèe wà pàra tèpa *Farasaio, â pwa na rà pwa tûâ têe. Â rà tawèerié pâ: «Gona pwa tàrù, kà pwi jè âboro, naa na ê *Naèà, na é tü tà tô wâdèe? O dà cè majoroé ma é tü têe?» ");
INSERT INTO priNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Â é tòpi tàra wà Iésu pâ: «Gona câguwà caa pûra ê pwina wii naa na *Tii Pwicîri? Ba jèe wii pâ, naa na autapoo goo, âna é tòpò wà pwi paao ma wà tô ilàri wà Pwiduée. ");
INSERT INTO priNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Â é ina wà Pwiduée pâ: Â gée goo kaa pwiri, âna é panuâ du nyaa ma caa kêe wà pwi paao, ba na ru pitâa ma wà tô wâdèe. Â, na wàrapwiri, â wàilu âna ru pâra nau caapwi. ");
INSERT INTO priNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","«Â êkaa, na go ina tàwà pâ: Càcaa mwa caa ârailu âboro, â ru jèe pwacèwii caapwi âboro. Â guwà cibwaa tipi côwâ ê pwina é jèe piinaimari wà Pwiduée!» ");
INSERT INTO priNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Â rà tòpi têe wà tèpa Farasaio pâ: «Wiàna wàrapwiri, â gorodà na é ina wà *Moosé pâ, pwa tàrù kà pwi âboro ma é panuâ côwâ tô wâdèe, wiàna é wii ê tii bétapàgà piéa?» ");
INSERT INTO priNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Â é tòpi tàra wà Iésu pâ: «É naa tàrù tàwà wà Moosé, ba po dau gòo ê pûruwà! Êco na, naa na autapoo goo, âna càcaa wàrapwiri. ");
INSERT INTO priNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Êkaa na go ina tàwà pâ: Gà cibwaa tü tà tô wâdàgà na càcaa tô a toomura (câé caa cîâa jiigà). Ba wiàna gà tü têe, â wiàna gà jèu éa côwâ, â gà pâ nau toomura (ba gà cîâa jii tô wâdàgà béaa).» ");
INSERT INTO priNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Rà ina tà Iésu wà tèpa *câmu kêe pâ: «Wiàna wàrapwiri, â wâdé na ticè piéa!» ");
INSERT INTO priNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Â é tòpi tàra pâ: «Ê pwi popai-bà, âna o càcaa wàrapwiri ba kâra diri pâ âboro. Êco na wà Pwiduée, âna é nama wàrapwiri co naa goo pàra tàpé. ");
INSERT INTO priNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Ba nye pwa pàra tàpé na càra caa éa, ba càcaa pâri, gée na aupitèparà. Â pwa pàra tàpé na càcaa pâri ma rà ipwénaî, gée goro ê pwina rà pwa naa na naiirà wà pàra tèpa âboro. Â pwa pàra tàpé na càra caa éa goro *Mwaciri napwéretòotù. Ba nümarà na rà piênawéna bwàti kà Pwiduée. Â wà pwina pâri târa ma é tòpi pwâratùra-bà, â wâdé na é tòpi!» ");
INSERT INTO priNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Gée na càùé, âna rà medari Iésu wà pàra tèpa âboro. Â rà cia me têe ê nyi nari èpo kàra, ba na é tòpò îê naa gòrà ma pwapwicîri ba kàra. Êco na wà tèpa câmu kêe, âna rà pwa i tèpa âboro, ma pacoorà. ");
INSERT INTO priNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Êco na é ina tàra wà Iésu pâ: «Guwà naaco nyi tèpa nari èpo, ma rà medario! Guwà cibwaa pacoorà! Ba napwa ê Mwaciri napwéretòotù, âna o kâra ê pâ âboro na rà wàra ê nyi nari èpo.» ");
INSERT INTO priNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Â é tòpò îê Iésu naa gò nyi nari èpo, â é *pwényunyuâarirà. Â gée na càùé, â é pâra gée na ére bèepwiri. ");
INSERT INTO priNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Ûna bwaa gére wàrapwiri, â é nye tèepaa kaa wà pwi jè âboro èpo dopwa, â é tawèeri Iésu pâ: «Pwi a pwa pupûra, dà cèna go pwa cèna o wâdé, ba na o tâa tôo ê *wâro dàra gòiri jaa Pwiduée?» ");
INSERT INTO priNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Â é tòpi têe wà Iésu pâ: «Gorodà na gà tawèerio goro ê pwina wâdé? Nye caapwi co wà Pwina é wâdé. Â wiàna nümagà na tâa tâgà ê *âji wâro, â gà pitêre dàra ê pâ Naèà kêe.» ");
INSERT INTO priNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Â é ina têe wà pwiibà, pâ: «Gona dà ê pâ naèà kêe?» Â é tòpi têe wà Iésu pâ: «Gà cibwaa tétàmwara âboro; Gà cibwaa toomura (gà cibwaa cîâa jii tô wâdàgà, é, wà pwi éagà); Gà cibwaa mura; Gà cibwaa ina cè popai na pwâ, naa goo cè pàra âboro. ");
INSERT INTO priNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Gà papwicîri du nyaa ma caa'gà; Gà meaari tèpa âboropwacèwii ê pai pimeaarigà côwâ.» ");
INSERT INTO priNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Â é tòpi têe wà pwiibà, pâ: «Êdiri pâ naèà-bà, âna go jèe pitêre dàra kaa. Â o dà cèna go pwa mwara?» ");
INSERT INTO priNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Â é tòpi têe wà Iésu pâ: «Wiàna nümagà na nye po wâdé bwàti ê pâ tûâ'gà na ara Pwiduée, â gà pâra, â gà nye icuri kaa diri ê neemurugà, â gà naa ê mwani wâri wèe tà tàpé na ticè kàra. Ba na wàrapwiri, âna o pwa cè wâdé'gà naa jaa Pwiduée. Â gà me wiâô.» ");
INSERT INTO priNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Â wà i pwi âboro, âna é po dau pikîri, ba po dau pwa neemuruê. Â é pâra. ");
INSERT INTO priNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Â é ina wà Iésu tà tèpa câmu kêe pâ: «Guwà têre bwàti, ba go ina tàwà ê âjupâra pâ: Wà pwi âboro na dau pwa neemuruê, âna dau pwacoé târa ma é tò naa na Mwaciri napwéretòotù. ");
INSERT INTO priNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Gona ê kaamela, âna pâri ma é tò na ê pwêe goro kaju? Bwa, pwacoé! Â go ina tàwà pâ: Wà pwi âboro na dau pwa neemuruê, âna mwa nye dau pwacoé têe awé, ma é tò naa na *Mwaciri kà Pwiduée.» ");
INSERT INTO priNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Â rà nye po dau pò wà tèpa câmu kêe, â rà ina pâ: «Â gona wàilàapà cè pwina o pâriê ma é udò ma tâa têe ê âji wâro?» ");
INSERT INTO priNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Â é niârirà wà Iésu, â é ina tàra pâ: «Naa goo wà tèpa âboro, âna càcaa pâri. Êco na, diri kaa ê pâ muru, âna pâri wà Pwiduée.» ");
INSERT INTO priNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Â é tòpi têe wà Pétéru pâ: «Gà côo! Wàibà, âna bà jèe nye po panuâ diri, ba na bà pâra wiâgà ma bà tèpa câmu'gà. Â gée goo pwiri, â o dà cèna bà tòpi?» ");
INSERT INTO priNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Â é tòpi tàra wà Iésu pâ: «Wàépwiri. Â guwà têre bwàti, ba go ina tàwà ê âjupâra pâ: Ée mwa tòotéri ma âmuê diri ê pâ namuru wà Pwiduée. Â, na pwi tòotù-bà, âna wâgo, *Pwina naîri âboro, âna go o mwa tâa gò ê autâa kôo, naa na pai maina ma muugère kôo. Â wâguwà na pâra wiâô, âna guwà o tâa gò ê pâ 12 autâa, ba na guwà pitûâ kâra ê 12 wâao *Isaraéla. ");
INSERT INTO priNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","«O mwa wâru pàra tàpé na rà o panuâ pwârawâ ma aupwanapô kàra, ba na rà pâra wiâô. Â rà o cau panuâ tèpa aéjii kàra, ma wà pa naigé kàra, ma du nyaa ma caa kàra, ma èpo kàra, gooò. Â wà diri tàpé na rà wàrapwiri âna rà o mwa cau tòpi cè muru na piwéna awé, na dau maina ma dau wâru! Â jèpwi mwara, âna wà Pwiduée, âna ée mwa naa tàra ê wâro dàra gòiri jaaé. ");
INSERT INTO priNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Wâru tàpé na rà pâbéaa nabà, na rà o mwa caa pwicò widàuru. Â wâru tàpé na rà pwicò nabà, na rà o mwa caa pâbéaa widàuru.» ");
INSERT INTO priNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","É ina mwara wà Iésu pâ: «Ê *Mwaciri napwéretòotù, âna pwacèwii mwara ê pwini: «É mwa tâa wà pwi apooro nadipâa, âna é mwa còobé na bwaa dàuru naa na aupwa jèna, ba na é mudàra cè tèpa wakè kêe. ");
INSERT INTO priNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Â é pâmari pàra tàpé, â rà jèe pitêrerà pâ, na ê wârirà, âna wâri wàra caapwi tòotù goro wakè. Â é panuârà pâ naa na aupwanapô. ");
INSERT INTO priNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Wâpâ gòro 9 ineretòotù dàuru, â é còobé mwara naa na aupwa jèna. Â é côo pàra tàpé na nye ticè na rà pwa. ");
INSERT INTO priNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Â é ina tàra pâ: “Tàpéebà! Guwà pâra mwara, nau wakè na i aupwanapô kôo, â go mwa nye naa cè wâriwà cèna pâri.” ");
INSERT INTO priNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","«Â rà pâra. Â wà pwiibà, âna é còobé côwâ na po gopaé, â é popa me mwara pàra tèpa wakè. Â ipaiwà mwara na âracié ineretòotù na càùru ija. ");
INSERT INTO priNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","«Â nabwé, â é còobé mwara, wâpâ gòro 5 ineretòotù, â é pâmari pàra tàpé mwara na rà nye tàgére pitabéaa cùu. Â é tawèerirà pâ: “Tàpéebà, gona guwà nye tàgére pwa dà? Nye ticè cèna guwà pwa?” ");
INSERT INTO priNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","«Â rà tòpi têe pâ: “Wàrapwiri, ba nye ticè cè pwina é popabà ma bà wakè.” «Â é ina tàra pâ: “Wâguwà mwara, guwà pâra nau wakè na aupwanapô kôo.” ");
INSERT INTO priNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","«Â pâ nau bàrane, â é ina tà pwi caa kâra wakè kêe pâ: “Gà todà me tèpa wakè, â gà piwârirà jècaa. Â gà mara wâri tàpé na ia rà pwicò goro wakè, â gà mwa tubanabwé naa goo tèpa mara wakè.” ");
INSERT INTO priNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","«Â wà tàpé na ia rà mwa wakè pwicò, âna rà mara me. Â rà tòpi wârirà—wâri wàra caapwi tòotù goro wakè. ");
INSERT INTO priNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Ûna rà côo pwiri wà tàpé na ia rà mara tapoo wakè, â rà tà niimiri pâ, ‘Wâdé, ba jè o tòpi cèna piwéna!’ «Êco na rà nye tòpi mwara wârirà, na wâri wàra caapwi tòotù goro wakè, pwacèwii tèpa wakè pwicò. ");
INSERT INTO priNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Â rà putàmu naa goro i pwi apooro aupwanapô, ");
INSERT INTO priNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","â rà ina têe pâ: “Wà tàpéeni, âna rà mwa tèepaa pwicò, â caapwi ineretòotù co na rà wakè na, â gà nama ipaiwà ê wâribà! Na wàibà, na bà wakè bamwara tòotù ma cîribà tòotù!” ");
INSERT INTO priNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","«Â é tòpi tà pwi jè ârapàararà wà i pwi apooro aupwanapô. Â é ina têe pâ: “Pwi béeò, gà cibwaa niimiri pâ go piwâmigà. Ba ia ju jèe nye pitêreju naa goro i wârigà. ");
INSERT INTO priNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Gà popa mwani'gà, â gà pâra. Ba nümoo na go naa tà tàpé na rà pwicò'gà, cèna ipaiwà ma wâgà. ");
INSERT INTO priNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Nye pwa tàrù kôo ma go pitûâ naa goro mwani kôo. Cina gà piboo na go pwa na wâdé tà pàra tàpé?”» ");
INSERT INTO priNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Â é tubanabwé ê ucina bèepwiri Iésu, â é ina pâ: «Wà tàpé na rà pwicò, âna rà o mwa pâbéaa. Â wà tàpé na rà pâbéaa, âna rà o mwa pwicò. Nabwé.» ");
INSERT INTO priNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Rà bwaa nye gére too naa *Iérusaléma wà Iésu ma wà tèpa 12 a *câmu kêe. Â, na rà gére pâra, â é poparà iti, â é ina tàra pâ: ");
INSERT INTO priNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","«Guwà têre. Nabàni, âna jè too naa Iérusaléma. Â naawê, âna o panuâô, wâgo *Pwina naîri âboro, tà tèpa caa kà tèpa pwa *ârapwaailò, ma wà tèpa *dotée goro ê Naèà. Â rà o mwa tèio tiagoro na o tétàmwaraô. ");
INSERT INTO priNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Â rà o panuâô tà tàpé na càra caa tèpa *Juif. Â wàilà, âna rà o piècaario. Â rà o pâdio goro ubati, â rà o tanamiriô naa goro *kurucé, tiagoro pai bà kôo. Êco na, naa na béâracié kâra tòotù gée na càùé, âna go o mwa wâro côwâ gée na aubà.» ");
INSERT INTO priNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Gée na càùru pwiri, â rà medari Iésu wà tô wâdà Zébédée, ma wà tupédu naîê. Â é tùu jùrué araé wà tôoni, ma é ilari jiié jè muru. ");
INSERT INTO priNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Â é ina têe wà Iésu pâ: «Dà cèna nümagà goo?» Â é tòpi têe pâ: «Bà tâmogòori pâ gà mwa tâa gòro autâa'gà, na Mwaciri'gà, ma pitûâ naa goo diri. Â wâdé na gà nama ru tâa goro du jèneregà wà tupédu naîô bèeni—pwi jèpwi naa gòro âji îgà, â pwi jèpwi naa gòro aèmwü'gà?» ");
INSERT INTO priNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Â é ina tà i tupédu aéjii wà Iésu pâ: «Câgàu caa tâmogòori ê pwina gàu ilari. Gona nümau na gàu wâdo ê na wârado na go o wâdo? Pâri ma gàu tòpi mwara ê pâ aré ma tòina kôo?» Â ru tòpi têe pâ: «Akaé, o pâribu.» ");
INSERT INTO priNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Â é ina tàru pâ: «Üu kaa, gàu o wâdo na wârado bèepwiri go wâdo. Êco na o càcaa wâgo na go pitûâ pâ, wàilàapà na o tâa gòro âji îô, ma gòro aèmwü kôo. Â nye wàco Caa kôo, na é jèe nye pwabwàti ê autâa bèepwiri, ba kà pàra tàpé na é nye pitòrigarirà.» ");
INSERT INTO priNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Ûna rà têre ê pwâratùra bèepwiri wà tèpa 10 a câmu béeru, â rà putàmu naa goo tupédu aéjii bèepwiri. ");
INSERT INTO priNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Â é todàra wà Iésu, â é ina tàra pâ: «Guwà côo, naa jaa wà tàpé na càra caa tèpa âboro kà Pwiduée, âna wà tèpa ukai, âna rà pitûâ, ba na rà còogai tèpa âboro. Â wà tàpé na rà imaina, âna rà pwa kûu tàra. Â rà niimiri pâ dau pwamuru naa goorà. ");
INSERT INTO priNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Â naa goowà, âna o càcaa wàrapwiri. Ba wà pwina nümee na é pwi âboro imaina, â wâdé na é pâ nau piâboro kîri kàwà. ");
INSERT INTO priNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Â wà pwina nümee na é pitûâ kàwà, âna wâdé na é piâboro kîri kàwà. ");
INSERT INTO priNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Wâdé na guwà pwacèwiio, wâgo Pwina naîri âboro. Ba câgo caa me, ba na guwà piâboro kîri kôo. Go me, nau piâboro kîri kâra pâ âboro. Â go me, ba na go panuâ ê wâro kôo, ba na go wâri ma tipi pâ âboro na wâru.» ");
INSERT INTO priNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Rà còobé gée na càùru pai pâra kàra naa Iériko wà Iésu ma wà tèpa câmu kêe. Â dau wâru tèpa âboro na rà pâra wiârà. ");
INSERT INTO priNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Pwa tupédu a bwi na ru tâa bàra naigé, â ûna ru têre pâ é tèepaa wà Iésu, â ru nye tà tomara too pâ: «{Pwi Ukai,} *Pwina naî Davita, gà meaaribu, â gà pitu tâbu!» ");
INSERT INTO priNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Â rà kànariru ê pâ âboro, ba na rà pacooru. Êco na ru mwa nye dau to too kaa burà ina pâ: «Pwi Ukai, Pwina naî Davita, gà meaaribu, â gà pitu tâbu!» ");
INSERT INTO priNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Â é têreru wà Iésu, â é coo, â é tomara too pâ: «Dà cèna pwina nümau goo? Dà cèna pâri ma go pwa ba kàu?» ");
INSERT INTO priNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Â ru tòpi têe pâ: «Pwi Ukai, na gà tàpiri du âraporomeebu ma bu niâ.» ");
INSERT INTO priNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Â é dau meaariru Iésu, â é tu naa goro i du âraporomeeru. Â ru jèe nye niâ kaa, wàra béaa. Â tapoo na tòotù bèepwiri, â ru nye pâra wiâ Iésu kaa. ");
INSERT INTO priNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Rà bwaa gére pâra dàra *Iérusaléma wà Iésu ma wà tèpa *câmu kêe. Â rà pâmwünyabweri Bethfagé, ê village na wâmwünyabweri ê gòrojaa Élaio. Â é mara panuâ pâ du ârailu a câmu kêe wà Iésu. ");
INSERT INTO priNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Â é ina tàru pâ: «Gàu pâra naa na village bèepwiri na tâa béaa kâjè. Â gàu o pâmari naawê ê jè buriko, na tòoé goro utàpwe, ma ê naîê. Â gàu tipiru, â gàu poparu me tôo. ");
INSERT INTO priNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Â wiàna rà tawèeriu goro cèna gàu pwa, â gàu tòpi tàra pâ, na gàu poparu pâdari wà Pwi Ukai, â rà o panuâru.» ");
INSERT INTO priNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Ê pai pwa wèe bèepwiri, âna tèepaa, ba na pacoo i pwi ia é ina wà Pwiduée, na é naigé mee pwi péroféta kêe, pâ: ");
INSERT INTO priNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Gà ina târa ville Iérusaléma, pâ: “Gà côo, co tô ilàri *Siona, é me dàgà wà Pwi Ukai'gà! Dau moo pwâranümee, ba é me na tàbwàti. É tâa gò buriko, ma nari buriko, macii na é pa nakake.” Ésaïe 62.11; Zakarie 9.9 ");
INSERT INTO priNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Â ru pâra i tupédu a câmu, â ru pwa diri ê pwina é ina tàru wà Iésu. ");
INSERT INTO priNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Â ru dàti me i nyaa kâra buriko bau i naîê, â ru tòpò pâ ârabwée kàru naa gòru. Â é mwa tâa gò i nari buriko wà Iésu, â é papâraê. ");
INSERT INTO priNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Wâru ê pâ âboro na rà pòpwara béaa kêe naa gòro naigé ê pâ ârabwée kàra, ba na rà pwamainaê. Â wà pàra tàpé, âna rà tépàgà îri upwâra na bwùu, â rà tòpò wii naigé. ");
INSERT INTO priNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Â wâru pâ âboro na rà pâbéaa ma rà pwicò kà Iésu. Â rà cau tomara too pâ: «Hosana ma ipwamaina tà *Pwina naî Davita! Cidòri nyuâa pwi âboro, na é me naa na nee Pwi Ukai! Psaume 118.26 Hosana ma cidòri! Pwamaina Pwi Ukai na é wâdòiti awé!» ");
INSERT INTO priNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Ûna é tèepaa pâ naa Iérusaléma wà Iésu, â po dàpàgà târa diri ê pâ âboro na ville, â rà pitawèerirà pâ: «Wàilàapà pwi âboro bèeni?» ");
INSERT INTO priNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Â rà tòpi tàra pâ âboro na rà pâra wiâê, pâ: «Wà Iésu, gée Nazareth wâ Galilée. Wàé kaa i pwi *péroféta na ia jè tapacîê.» ");
INSERT INTO priNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","É tèepaa pâ naa na *Wâra pwapwicîri wà Iésu, â é pacòobé tèpa gére pwa jèna, gée na gòroigé kâra Wâra pwapwicîri. Â é pugòboori ê pâ taapà naa goo tèpa pitòotéri mwani, ma ê pâ autâa kà tàpé na rà pi-icu marü. ");
INSERT INTO priNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Â é ina tàra pâ: «É ina wà Pwiduée naa na *Tii Pwicîri, pâ: O mwa ina goo ê wâ kôo, pâ, wâ târa pwapwicîri. Êco na wâguwà, âna guwà gére pwa ma aucârü kà tèpa mura!» ");
INSERT INTO priNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Gée na càùru pwiri, â wâru tàpé gée goo tèpa bwi ma tèpa bee, na rà medari Iésu naa na Wâra pwapwicîri, â é nama tiàu maagé kàra. ");
INSERT INTO priNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Â wà tèpa caa kà tèpa pwa *ârapwaailò, ma wà tèpa *dotée goro ê Naèà, âna rà côo ê pâ muru bèepwiri na é pwa wà Iésu—muru na wâdé, na jè pò goo. Â rà côo mwara pâ èpo, na rà gére uu naa na Wâra pwapwicîri ma ina pâ: «Hosana! Pwamaina Pwina naî Davita!» Â rà putàmu naa gooé wà tèpa pitûâ-bà, ");
INSERT INTO priNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","â rà ina têe pâ: «Pwiibà, wànau, câgà caa têre ê pwina rà gére ina pâ èpo bèeni?» Â é tòpi tàra pâ: «Akaé. Â câguwà caa mu pûra ê auwii goo, na wâna Tii Pwicîri? Ba jèe wii pâ: Gà nama rà pwamainagà pâ èpo ma nari èpo.» Psaume 8.3 ");
INSERT INTO priNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Â é pâra jiirà wà Iésu, â é còobé gée na ville ma é pâra naa na village Bétani. Â é mwa puu wê. ");
INSERT INTO priNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Na dàuru kêe, na bwaa dàuru, â é wâjué me naa na ville wà Iésu. Ûna é pâmwünyabweri i ville, â é copwa. ");
INSERT INTO priNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Â é côo jè *upwâra wâi naa bàra naigé. Â é pâra nau coo goo, êco na nye po dooé co. Â é pinajajaié, ma ina pâ: «O câgà mwa caa pwâ dàra gòiri!» Â é nye mwari kaa. ");
INSERT INTO priNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Ûna rà côo i upwâra wà tèpa câmu kêe, â rà po dau pò, â rà ina têe pâ: «Gorodà na é nye awài goro mwari kaa?» ");
INSERT INTO priNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Â é tòpi tàra wà Iésu pâ: «Guwà têre bwàti, ba go ina tàwà ê âjupâra pâ: Wiàna guwà cèikî, â wiàna câguwà caa pidumapiê, â o pâri ma guwà pwa ê pwina go pwa târa i upwâra bèeni. Â pâri mwara ma guwà ina târa ê jaa bèepwiri pâ: “Gà boo naa nawià!” Â o nye wàra. ");
INSERT INTO priNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","«Â wiàna guwà pwapwicîri târa ilari ê jè muru, â na guwà cèikî naa goo, â ée mwa pacoo wà Pwiduée.» ");
INSERT INTO priNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","É tò naa na Wâra pwapwicîri wà Iésu, â é pacâmuri pâ âboro. Â wà tèpa caa kà tèpa pwa ârapwaailò, ma wà tèpa pitûâ, âna rà me burèe, â rà tawèerié pâ: «Wàilàapà na naa tàrù tâgà, ma gà pwa ê pâ muru na gà pwa? Wàilàapà na cùrugà?» ");
INSERT INTO priNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Â é tòpi tàra pâ: «Wâgo mwara, âna go bwaa nama tawèeriwà goro ji caapwi muru. Â wiàna guwà tòpi tôo bwàti, â go mwa ina tàwà pwi a naa tôo tàrù ma go pwa. Wàéni: ");
INSERT INTO priNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Wàilàapà na naa tàrù tà Ioane ma é *piupwaa? Wà Pwiduée, é, wà tèpa âboro?» Â rà dau pitùra goo, â rà pi-ina tàra pâ: «Wiàna jè tòpi pâ: “Tàrù gée jaa wà Pwiduée” â ée mwa ina tâjè pâ: “Â gorodà na câguwà caa cèikî naa goo ê pwina é ina tàwà wà Ioane?” ");
INSERT INTO priNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Â wiàna jè tòpi têe pâ: “Tàrù gée jaa tèpa âboro co” â géewê, âna jè ipwacôojè goo tèpa âboro na rà cèikî naa goo Ioane!» Ba rà cau cèikî ba gòo wà tèpa âboro pâ é pwi péroféta na é pame ê popai gée jaa wà Pwiduée. ");
INSERT INTO priNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Â wà tèpa pitûâ, âna rà tòpi tà Iésu pâ: «Îi, câbà caa tâmogòori.» Â é ina tàra wà Iésu pâ: «Â wâgo mwara, âna o câgo caa ina tàwà pâ, wàilàapà na naa tàrù tôo ma go pwa ê pwina go pwa.» ");
INSERT INTO priNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","É pwa ucina tàra wà Iésu pâ: «Guwà têre cai ni: «Rà mwa tâa wà pwi jè âboro ma tupédu naîê. Â é ina tà pwi jèpwi pâ: “Pwina naîô, gà pâ nau wakè na aupwanapô nabà.” ");
INSERT INTO priNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","«Â é tòpi têe pwini pâ: “Tàutôo.” «Êco na, gée na càùé, âna é pinünüma naa goo i pai tòpi kêe têe. Â é nye pâra nau wakè na aupwanapô. ");
INSERT INTO priNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","«Â é ina wà caa kàru tà pwi jèpwi pâ: “Pwina naîô, gà pâ nau wakè na aupwanapô nabà.” «Â é tòpi têe pâ: “Üu, wâdé co caa. Go o jèe pâra.” Êco na câé caa pâra. ");
INSERT INTO priNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","«Â wàilàapà na tupéebà, na pwa ê câbawâdé kà caa kàru?» Â wà tèpa caa kà tèpa pwa ârapwaailò ma wà tèpa pitûâ, âna rà tòpi têe, pâ: «Wà pwi a pâbéaa.» Â é ina tàra wà Iésu pâ: «Guwà têre bwàti, ba go ina tàwà ê âjupâra pâ: Wà tàpé na guwà tétérirà— wà tèpa *tò mwani wâripû, ma wà pa ilàri gòronaigé, âna rà o tâa na autâa kàwà na *Mwaciri kà Pwiduée. ");
INSERT INTO priNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Ba é medariwà wà *Ioane Pwi a piupwaa, ba na é paari târa ê Ba *Isaraéla ê naigé na *tàrù na ara Pwiduée. Â câguwà caa cèikî naa gooé. Êco na wà tèpa tò mwani wâripû, ma wà pa ilàri gòronaigé, âna rà nye cèikî naa gooé. Â, na guwà côo pâ, rà cèikî, â câguwà caa pinünüma naa goo, ma guwà cèikî mwara naa gooé.» ");
INSERT INTO priNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","«Guwà têre jè ucina: «É mwa tâa pwi apooro nadipâa. Â é mwa câmi aupwanapô kêe. Â é mwa bariwâri goro ê auba, â é mwa îri pwêe, ba na aucòogai ê pwâra dipâa. Â é mwa bari ê wâ na dau gòri too, ba na aucibèri wàra ê nadipâa. Â nabwé, â é niimiri pâ, na é pâra nau ipokâa naa jè napô, â é wâri pàra tèpa âboro, ba na rà wéaari i na aupwanapô kêe. Â é pâra. ");
INSERT INTO priNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","«Paé pâ parui, paé, paé, paé… tèepaa naa na pàara na o pétâ pwâra dipâa na. Â é panuâ pâ tèpa ênawéna kêe, ba na rà tòpi jii tèpa wéaari nadipâa cè kêe gée goro ê piûnya. ");
INSERT INTO priNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Êco na rà pâdi pwi jè ênawéna, â rà pòtàmwara pwi jèpwi, â rà èi pwi béâracié goro atü. ");
INSERT INTO priNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Â dau wâru cè pàra tèpa ênawéna na é panuârà pâ mwara. Êco na nye ipaiwà pai pwa kàra tàra. ");
INSERT INTO priNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Â géewê, â é panuâ pâ pwi naîê, ba é niimiri pâ rà o papwicîriê. ");
INSERT INTO priNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","«Ûna rà côo i pwi naîê na é tèepaa pâ, â rà pi-ina tàra pâ: “Wàé kaa pwiri pwina ée mwa pwi apooro i na aupwanapô na cè jè tòotù! Wâdé na jè tétàmwereê cawi, ba na o mwa tà kâjè i na aupwanapô kêe!” ");
INSERT INTO priNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Â rà tâjùrué, â rà dàtié còobé jii aupwanapô, â rà tétàmwereê.» ");
INSERT INTO priNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Â wà Iésu, âna é tawèeri tàpé na rà gére têre ucina bèepwiri pâ: «Â wiàna é tèepaa me i pwi apooro na aupwanapô, â o dà cèna ée pwa tà tèpa wakè bèepwiri?» ");
INSERT INTO priNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Â rà tòpi tà Iésu wà tèpa caa kà tèpa pwa ârapwaailò, ma wà tèpa pitûâ, pâ: «Ée mwa pwa na èpà tà tàpé na rà èpà, â ée pòtàmwararà. Â é naa tà pàra tàpé i aupwanapô, ma rà wéaari. Â, na cè pàara na pétâ pwâra nadipâa na, âna rà o mwa naa têe ê pwina kêe.» ");
INSERT INTO priNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Â é pwa ma ina tàra mwara wà Iésu pâ: «Gona câguwà caa pûra ê pwina wii naa na Tii Pwicîri? Ba jèe wii pâ: I pwi atü na rà tétâjii wà tèpa ba wâ, âna nye wàé kaa pwiri, i âji êkêe! Tàutàra goo pwi ò kâra wâao! Ba nye autûâri kà Pwi Ukai. Jè pò goo pwényuâa kêe. Psaume 118.22–23 ");
INSERT INTO priNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","44","«{Wiàna é tûu cè pwi jè âboro naa gòro pwi atü-bà, â o tadidiri ê naiié. Â wiàna é tûu i pwi atü-bà naa gòro pwi jè âboro, â é câgagaié.} Wàépwiri majoroé ma go ina tàwà pâ: Wà Pwiduée, âna ée pa jiiwà ê aupwényunyuâari kâra Mwaciri kêe. Â ée naa târa cè jè Ba, cèna ée mwa naa cè pwâra wakè kà tèpa âji naîri Mwaciri.» ");
INSERT INTO priNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Wà tèpa caa kà tèpa pwa ârapwaailò, ma wà tèpa *Farasaio, âna rà tâmogòori pâ é tàgére pwa ucina wà Iésu naa goorà. ");
INSERT INTO priNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Â dau nümarà na rà tâjùrué. Êco na wâgotàra goro pâ âboro, ba dau wâru tàpé na rà niimiri pâ é pwi péroféta, pwi a-ipa popai kà Pwiduée. ");
INSERT INTO priNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Wà Iésu, âna é jèu ina côwâ tà tèpa pitûâ kà tèpa *Juif â é ina tàra pâ: ");
INSERT INTO priNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","«Go bwaa piucinari tàwà ê *Mwaciri napwéretòotù: «É mwa tâa pwi jè ukai. Â é mwa pwabwàti ê jè pi-ija na dau maina goo pwina naîê, na é piéa. ");
INSERT INTO priNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Â é mwa cùru pâ tèpa ênawéna kêe, ma rà todà me tàpé na rà o ija, êco na wà tàpéebà, âna tàutàra dàra me nau ija. ");
INSERT INTO priNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","«Â é mwa cùru mwara pàra tèpa ênawéna nau ina mwara tà tàpéebà pâ: “Go jèe pwabwàti diri. Ba go jèe nama taa ê pâ paaci ma macii kôo na patèerà. Â guwà me ma jè pi-ija nyabutùru i piéa!” ");
INSERT INTO priNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","«Êco na càra caa ipacè naa goorà wà tàpé na todàra. Â rà pâra nau pwa jèpa wakè kàra—é pâra naa na aupwanapô wà pwi jèpwi, â é côo mwagacâ kêe pwi jèpwi. ");
INSERT INTO priNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Â wà pàra tàpé, âna rà tâjùru tèpa ênawéna, â rà tubaèpà tàra, â rà pòtàmwararà. ");
INSERT INTO priNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Â é nye dau putàmu kaa i pwi ukai. Â é panuâ pâ tèpa ipaa kêe ma rà pòtàmwara tèpa pòroca-bà, â rà cîri ê napô kàra. ");
INSERT INTO priNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","«Â é todà me pàra tèpa ênawéna kêe, â é ina tàra pâ: “Jèe nabwé i utimuru târa piéa, êco na wà i tàpé na ia mara todàra, âna càcaa pâri naa goorà, ba pâ tèpa âboro èpà. ");
INSERT INTO priNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Guwà pâra diri naa ê pâ napô, â guwà todà me diri pâ âboro na guwà pâmarirà.” ");
INSERT INTO priNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","«Â rà pâra wii pâ naigé wà tèpa ênawéna, â rà todà diri tèpa âboro na rà pâmarirà—tàpé na rà èpà, ma tàpé na rà wâdé. Â pâra nau po wâbé i wâra pi-ija. ");
INSERT INTO priNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","«Â é too wà pwi ukai ma é côo tàpé na rà gére ija. Â é côo pwi âboro na câé caa coona i ârabwée târa pi-ija. ");
INSERT INTO priNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Â é ina têe pâ: “Ico pwi béeò, gà wànau târa pai toome'gà naani, na nye ticè ârabwée'gà târa pi-ija?” «Â câé caa tâmogòori wà pwini cè pai tòpi kêe. ");
INSERT INTO priNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","«Â é ina tà tèpa ênawéna kêe wà pwi ukai pâ: “Guwà pii du îê ma du âê, â guwà tüê còobé naa na bàutê. Â rà o i ma tòngüru poropwârà wà tèpa âboro gée goro pai maagé kàra.”» ");
INSERT INTO priNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Â é tubanabwé ê ucina bèepwiri wà Iésu, â é ina tàra pâ: «Âjupâra pâ é todàra pâ âboro na wâru wà Pwiduée êco na o pwâco cè tèpa âboro na é pitòrigarirà. Nabwé.» ");
INSERT INTO priNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Na jè tòotù, âna rà ipitiri wà pàra tèpa *Farasaio, ba na rà imudàra cè pai pwa wèe, ma rà tü tûâ tà Iésu. Â nümarà na é pitanami goro ê pai tòpi tàra kêe. ");
INSERT INTO priNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Â rà panuâ pâdarié pàra tèpa *câmu kàra, ma wà pàra tàpé na tâa na ére kà *Héroda. Â rà ina tà Iésu pâ: «Pwi a pwa pupûra, bà tâmogòori pâ gà ina ê âjupâra. Ba gà nye picémara ba *tàrù diri ê pâ muru, na nüma Pwiduée na jè pwa. Â nye ticè âboro cèna wâgotâgà gooé, â câgà caa pwaké goro âboro. ");
INSERT INTO priNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Â êkaa, na nümabà na bà tawèerigà pâ: Pwiri wâdé na jè wâripû tà pwi ukai kà tèpa Roma? É, o càcaa wâdé?» ");
INSERT INTO priNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Â wà Iésu, âna é jèe tâmogòori ji ipwa tûâ kàra, â é ina tàra pâ: «Tàpéeni, guwà tèpa pwâ! Gorodà na guwà ipawâmiô? ");
INSERT INTO priNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Paari tôo cai ê mwani wâripû!» Â rà naa têe jè mwani atü. ");
INSERT INTO priNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Â é ina tàra pâ: «Naporomee î ma nee î, na wâgòro ê mwani bèeni?» ");
INSERT INTO priNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Â rà tòpi têe pâ: «Kà pwi ukai kà tèpa *Roma.» Â é ina tàra wà Iésu pâ: «Â jèe wâdé, guwà pitôowâri tà pwi ukai kà tèpa Roma ê pwina kêe, â guwà pitôowâri tà Pwiduée ê kà Pwiduée.» ");
INSERT INTO priNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Â rà po dau pò wà tèpa tawèerié, â rà panuâê, â rà pâra. ");
INSERT INTO priNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Bwaa nye tòotù caapwi, â rà me mwara dari Iésu wà pàra tèpa *Sadukaio. Wàilà, âna jè ditàra pwapwicîri kà tèpa Juif na càra caa cèikî pâ, rà o wâro côwâ wà tèpa bà. Â târa ma rà paari pâ rà âjupâra â rà tawèeri Iésu pâ: ");
INSERT INTO priNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","«Pwi a pwa pupûra, é jèe ina wà *Moosé naa na ê *Naèà pâ: Wiàna é bà wà pwi âboro, na ticè èpo kêe, â wâdé na é popa tô dàpwà kêe wà pwi jiié, ma ru piéa. Â, na wàrapwiri, â é naa cè gòobàra pwi a bà. ");
INSERT INTO priNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","«Â wâdé. Êco na gà jèe niimiri cai ni: Wâjaabà, âna pwa tèpa 7 aéjii. Â é piéa wà pwina ciàra, êco na é bà, â nye ticè èpo kêe. Â pwi a pâ wê, âna ru piéa ma tô dàpwà. ");
INSERT INTO priNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Â ipaiwà ma i pwi ciàra, â gée paé, naa goo pwi béâracié, â tèepaa naa goro diri tèpa aéjii na rà po 7. ");
INSERT INTO priNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Â gée na càùrà diri, â é mwa bàra bà, wà i tô ilàri. ");
INSERT INTO priNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Gà ina pâ rà o mwa wâro côwâ wà tèpa bà, na jè tòotù. Â wiàna wàrapwiri, â wàilàapà narà, na o pwi éa tô ilàri-bà, na tòotù bèepwiri? Ba rà nye cau tèpa éaé diri! Gà tòpi cai!» ");
INSERT INTO priNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","31","Â é tòpi tàra wà Iésu pâ: «Guwà pitanami, làpé! Cina câguwà caa cèikî pâ, rà o mwa wâro côwâ wà tèpa bà? Ba câguwà caa tâmogòori ê *Tii Pwicîri, â câguwà caa tâmogòori ê pàtàma Pwiduée! Ba wiàna rà wâro côwâ wà tèpa bà, â o càra mwa caa piéa côwâ. Ba rà o wâro pwacèwii tèpa *angela naa jaa Pwiduée. Gona câguwà caa pûra ê pwina é ina tàwà goo, wà Pwiduée? Ba é ina pâ: ");
INSERT INTO priNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Wâgo Pwiduée kà *Abéraama, ma Isaaka, ma Iakobo. Pai ina wèe pâ rà nye cau tàgére wâro jaa Pwiduée! Ba wà Pwiduée, âna câé caa Pwiduée kà tèpa bà, â é Pwiduée kà tàpé na rà wâro!» ");
INSERT INTO priNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Â rà têre pwiri ê pâ âboro na wâru, â rà dau pò goro ê pai pacâmurirà kà Iésu. ");
INSERT INTO priNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Ûna rà têre wà tèpa Farasaio pâ é târi pwâ tèpa Sadukaio wà Iésu, â rà pitanaimarirà, ba na rà côo Iésu. ");
INSERT INTO priNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Â wà pwi jè ârapàararà, pwi jè *dotée goro ê Naèà, âna nümee na é tü tûâ tà Iésu, â é tawèerié pâ: ");
INSERT INTO priNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","«Pwi a pwa pupûra, gona dà ê pwi naèà na é piwéna, naa na diri ê pâ naèà?» ");
INSERT INTO priNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Â é tòpi tàra wà Iésu pâ: «Wàéni: Wâdé na gà meaari Pwi Ukai Pwiduée'gà, gée na diri ê pwâranümagà ma wâro'gà, ma aunünüma'gà. ");
INSERT INTO priNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Wàépwiri ê pwi naèà na é dau piwéna naa na diri ê pâ naèà. ");
INSERT INTO priNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Â wàéni béârailu kâra naèà pwacèwii pwi pâbéaa: Gà meaari tèpa âboropwacèwii ê pai pimeaarigà côwâ. ");
INSERT INTO priNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","«Diri ê Naèà kà Moosé ma ê auina kà tèpa *péroféta, âna cau me gée goro du ârailu naèà bèepwiri.» ");
INSERT INTO priNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Wà Iésu, âna é ucâri wà tèpa Farasaio na ia rà tâa wê, â é tawèerirà pâ: ");
INSERT INTO priNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","«Dà cè pai niimiri kàwà naa goo pwi *Mesia, pwi ukai na guwà tapacîê? É pwi gòobàra î?» Â rà tòpi têe pâ: «Ée pwi gòobàra *Davita, pai ina wèe pâ, é pwi âboro kîri jiié.» ");
INSERT INTO priNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Â é ina tàra pâ: «Guwà niimiri cai ni: Wà Davita, ûna dipitirié ê Nyuâaê Pwicîri, âna é ina goo pwi Mesia pâ “Pwi Ukai kôo”. Âna gorodà? ");
INSERT INTO priNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Ba é ina pâ: Popai kà Pwi Ukai, Pwi Ukai Pwiduée na é patùra Pwi Ukai kôo: “Gà me ma gà tâa ni. Tâa ni gòro îô étò. Go naa tâgà ê pitûâ. O pwamainagà awé. Go nama gà còogai tèpa ipaa dàgà.” Psaume 110.1 ");
INSERT INTO priNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","«Ûna é ina pâ, Pwi Ukai kôo, âna é tàgére ina wà pwi Mesia. Â wiàna wàrapwiri, â gorodà na guwà niimiri pâ wà pwi Mesia, âna é pwi âboro kîri jiié? Bwa, é paari wà Davita pâ wà pwi Mesia, âna é pwi âboro na é piwéna jii diri pàra tàpé!» ");
INSERT INTO priNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Â nye ticè na tòpi têe. Â gée na càùé, â jèe ipwacoé tà tèpa âboro na rà tawèeri wà Iésu goo cè pàra muru. ");
INSERT INTO priNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Gée na càùé, â wà Iésu, âna é patùra tèpa *câmu kêe ma wà tèpa âboro na rà tâa wê. Â é ina tàra pâ: ");
INSERT INTO priNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","«Guwà côo, tèpa *dotée goro ê Naèà, ma wà tèpa *Farasaio, âna wakè kàra, na rà pacâmuri tèpa âboro goro ê *Naèà kà Moosé. ");
INSERT INTO priNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","«Â wâdé na guwà pitêre dàra diri ê pwina rà ina tàwà. Êco na guwà cibwaa ipwacèwiirà, ba càra caa pwa ê pwina rà ina tàwà! ");
INSERT INTO priNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Ba pâ pitûâ kàra, âna pwacèwii pâ nakake na dau tòina, na rà nama rà kakeri tèpa âboro. Â tàutàra na rà tu naa goo, goro ji caapwi mangadaîrà. ");
INSERT INTO priNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","«Êdiri pâ tûâ kàra, âna rà pwa, ba na rà paari tà tèpa âboro pâ rà pâra wiâra ê pâ tûâ kà Pwiduée. Ba rà nama pimaina pâ nyi nari atà pwicîri na tâa gaadaarà, ma wâgoro îrà. Â rà nama gòri ê pâ cûuru ârabwée kàra. ");
INSERT INTO priNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Rà nye mudàra taaci ê pâ autâa na tâa béaa, na *wâra pitapitiri ma naa na pâ na aupi-ija maina. ");
INSERT INTO priNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Â wâdé tàra, na rà pwamainarà wà tèpa âboro, ma ina tàra pâ ‘Pwi ukai’, na diri ê pâ ére aupitapitiri na napô. ");
INSERT INTO priNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","«Â wâguwà, âna guwà cibwaa nama rà pi-ina goowà pâ ‘Pwi ukai’, gée goro na nye caapwi co Pwi Ukai. Â wâguwà, âna guwà cau tèpa aéjii. ");
INSERT INTO priNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Â guwà cibwaa ina goo cè pwi jè âboro ni gòropuu pâ ‘Caa’, gée goo na nye caapwi co pwi Caa kàwà, na é wânidò *napwéretòotù. ");
INSERT INTO priNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Â guwà cibwaa nama rà pitunee tàwà pâ ‘Pwi a pitûâ’, gée goo na nye caapwi co Pwi a pitûâ, âna wà Kériso, pwi *Mesia. ");
INSERT INTO priNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ba wà pwi âboro imaina jaawà, âna wâdé na é piâboro kîri kàwà. ");
INSERT INTO priNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Ba wà pwina é ipwamainaê, âna o naaê boo. Â wà pwina é ipakîriê, âna o naaê too.» ");
INSERT INTO priNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","É patùra tèpa Farasaio ma wà tèpa dotée goro ê Naèà wà Iésu, â é ina tàra pâ: «Guwà ipwacôoco, wâguwà tèpa dotée goro ê Naèà ma wâguwà tèpa Farasaio! O dau maina wârimuru kàwà! Ba guwà tèpa ipwacôwârimuru! Ba guwà târi goropwârawâ târa *Mwaciri napwéretòotù jii ê pâ âboro. Câguwà caa tò naa na, â guwà pacoo pàra tàpé na nümarà na rà tò naa na. { ");
INSERT INTO priNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","«O dau maina wârimuru kàwà! Ba guwà pwa ê pâ nyakâra pwapwicîri ba na jè o niimiri pâ guwà tèpa âboro wâdé. Êco na, ûna guwà gére wàrapwiri, â guwà popa diri jii ê pa dàpwà ê pâ muru na tâa tàra. Â gée goro kaa pwiri, âna mwa pwa tàwà ê wârimuru na dau maina jii ê wârimuru kà pàra tàpé.»} ");
INSERT INTO priNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","«Guwà tèpa ipwacôwârimuru! Ba guwà itàa pitiri ni gòropuu, ma nawià, ba na guwà pâmari cè pwi caapwi âboro, na é tòpi ê pwapwicîri kàwà. Ûna guwà jèe popaé, â guwà pwa ma é pwi âboro na dau èpà jiiwà, na pâri ma é pwa wârimuru, dàra gòiri awé, pwacèwiiwà! ");
INSERT INTO priNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","«Guwà ipwacôoco! Guwà tèpa bwi, na guwà tòcia naigé tà tèpa bwi. Ba guwà pitanami na guwà pacâmuri tèpa âboro goro ê pâ *auipwataâboro. Ba guwà ina tàra pâ: “Wiàna gà *ipwataâboro co naa goro neere ‘*Wâra pwapwicîri’, â o piticèmuru naa goo, â o pâri ma gà pitanami. Êco na, wiàna gà ipwataâboro naa goro ‘mwani mii na tâa na Wâra pwapwicîri’, â wâdé na gà pwa ê pwina gà ipwataâboro naa goo.” ");
INSERT INTO priNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","«Guwà tèpa piwârau, ma tèpa wâu! Dà cè pwina dau piâjimuru? Ê mwani mii, é, ê Wâra pwapwicîri? Go ina tàwà pâ: Nye ê Wâra pwapwicîri kaa, na é piâjimuru, ba ére na é tâa wê wà Pwiduée! ");
INSERT INTO priNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","«Â ipaiwà mwara, wiàna guwà ina pâ: “Wiàna gà ipwataâboro co, naa goro ê aupwa ârapwaailò, â o piticèmuru naa goo, â pâri ma gà pitanami. Êco na, wiàna gà ipwataâboro naa goro ê *ârapwaailò na tâa gò, â wâdé na gà pacoo ê auipwataâboro bèepwiri.” ");
INSERT INTO priNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","«Wànau? Gona ticè cèna guwà tâmogòori? Dà ê pwina dau piâjimuru? Ê ârapwaailò, é, ê aupwa ârapwaailò, na é nama é pwicîri i ârapwaailò? ");
INSERT INTO priNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Guwà côo, wà pwina é ipwataâboro naa goro aupwa ârapwaailò, âna é ipwataâboro naa goro diri ê pwina tòpò naa gò. ");
INSERT INTO priNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Â wà pwina é ipwataâboro naa goro neere Wâra pwapwicîri, âna é ipwataâboro naa goro nee Pwiduée, ba autâa kêe. ");
INSERT INTO priNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Â wà pwina é ipwataâboro naa goro neere napwéretòotù, âna é ipwataâboro naa goro autâa pwicîri kà Pwiduée, na é tâdòiti.» ");
INSERT INTO priNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","«Guwà naa tà Pwiduée ji caapwi gée goro 10, gée goro pâ jèpa arapwüru. Â nye wâdé. Guwà ipwacôoco! Ba câguwà caa pâra wiâra ê pwina piâjimuru naa na ê Naèà—ê âji cèikî naa goo wà Pwiduée, bau ê pai tòimiri tèpa âboro, ma pai meaarirà. Wâdé na guwà pacoo diri pâ pwiibà, na maina, bau diri ê nyi nari naèà na kîri. ");
INSERT INTO priNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Guwà tèpa bwi na guwà tòcia naigé tà tèpa bwi! Guwà dàgòtù ê ji nari puutâ gée na i wârado, êco na guwà cîdaée ê kaamela na guwà namiri. ");
INSERT INTO priNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","«Guwà nuwa bwàti gòroigé kâra wârado ma ngapò, â ê pwâranümawà, âna nye po wâbé kaa goro ê pwina èpà. Ba guwà tèpa iau, â guwà ciburà mudàra ê pwina wâdé ba kàwà. ");
INSERT INTO priNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Guwà tèpa bwi! Guwà mara nuwa béaa nanaara ngapò, ma é pwéelaa. Â géewê, â ée pwéelaa diri ngapò. ");
INSERT INTO priNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","«Guwà pâ tèpa pwàniri èpà! Guwà pwacèwii ê pâ bwàmu na tâmi ba pwaa gòroigé, â po wâdé pai côo kâjè. Êco na wânigée na, âna pwa duuru âboro ma ê pâ muru na wai. ");
INSERT INTO priNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Ba guwà tèpa gòmapwa ma guwà *tàrù na ara tèpa âboro. Êco na wânigée na wâbinyiri, âna guwà tèpa pwâ, ma âboro èpà. ");
INSERT INTO priNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","«O dau maina wârimuru kàwà, co tèpa dotée goro ê Naèà ma tèpa Farasaio! Nabàni, âna guwà tòimiri ê bwàmu kà tèpa péroféta ma wà tàpé na tàrù na ara Pwiduée. ");
INSERT INTO priNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Â guwà pi-ina tàwà pâ: “Wiàna ina pâ, jè gére tâa na pàara kà tèpa jojoorojè, â pwiri câjè caa pòtàmwara pâ péroféta!” ");
INSERT INTO priNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","«Êco na, na guwà ina pwiri, â guwà côoina pâ, guwà nye tèpa âji naî tàpé na rà pòtàmwararà! ");
INSERT INTO priNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Â wâdé, â guwà nye tubanabwé ê wakè na rà tapoo wà tèpa jojoorowà! ");
INSERT INTO priNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Guwà tèpa nari dòèa! Wà Pwiduée, âna ée mwa pwa wârimuru tàwà dàra gòiri! Â o câguwà caa udò jii! ");
INSERT INTO priNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","«Guwà têre bwàti, ba go o panuâ tàwà cè tèpa péroféta, ma tèpa tàmanga, ma tèpa pacâmuriwà. Â guwà o tubaèpà tàra. Ba guwà o pâdi pàra tàpé goro ubati, naa na pâ wâra pitapitiri. Â guwà o ipwâri pàra tàpé wii ê pâ napô. Â guwà tanamiri pàra tàpé naa goro upwâra, â guwà pòtàmwara pàra tàpé goro cè jè pai pwa wèe. ");
INSERT INTO priNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","«Gée goo kaa pwiri, na ée mwa pitèiwà wà Pwiduée, goro ê pai pòtàmwara wàra diri tèpa âboro kêe naani gòropuu—tapoo naa goo Abéla, pwi âboro na é *tàrù; tiagoo Zakaria, pwina naî Barakie. Ba guwà pòtàmwara Zakaria, naa nabibiu kâra i aupwa ârapwaailò, ma i ére na dau pwicîri! ");
INSERT INTO priNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Â go nye ina tàwà pâ: Wà Pwiduée, âna ée mwa pwa wârimuru tàwà, wâguwà tèpa âboro nabàni, goro diri ê pâ pwiibà, na rà pwa wà tèpa jojoorowà.» ");
INSERT INTO priNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","É ina mwara wà Iésu pâ: «Nyi wâriwà co tàpé *Iérusaléma! Guwà catàmwara tèpa péroféta na é cùrurà medariwà wà Pwiduée—guwà èi pàra tàpé goro atü, â guwà pòtàmwara pàra tàpé goro cè jè pai pwa wèe. Nye ciburà nümoo na go panaimariwà, pwacèwii jè nyaa kâra ja na é panaimari nyi naîê na aranara itooé. Êco na tàutàwà. ");
INSERT INTO priNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Â guwà côo, go o mwa pâra jiiwà, â o jèe ticia na ê Wâra pwapwicîri kàwà! ");
INSERT INTO priNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Â go ina tàwà pâ: O jèe câguwà caa côoô tiagoro ê tòotù na guwà o ina pâ: Cidòri nyuâa pwi âboro na é me naa na nee Pwi Ukai!» ");
INSERT INTO priNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Gée na càùé, â é còobé gée na *Wâra pwapwicîri wà Iésu. Â napwa naa goo wà tèpa *câmu kêe, âna rà gére picâdiri diri ê auba, goo i pâ wâ, â rà medarié, ba na rà paari têe. ");
INSERT INTO priNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Â é tòpi tàra pâ: «Guwà côo diri pâ auba bèeni? Âna go ina tàwà ê âjupâra pâ: O mwa téura diri. Â o mwa ticè atü na o mwa pitâagòrà too wê.» ");
INSERT INTO priNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Gée na càùé â é tâaboo wà Iésu, naa gòrojaa Élaio. Â rà pâra darié tèpa câmu kêe, âna nye wàilà co ma wàé, â rà tawèerié pâ: «Gà ina tâbà pâ o wiidà cèna o tèepaa ê pwina gà gére ina. Â o dà cè câmu kêe, ma bà o tâmogòori pâ, ê pàara na gà o mwa wâjué côwâ na, ma ê cè pwâadàra gòropuu?» ");
INSERT INTO priNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Â é tòpi tàra pâ: «Guwà ipwacôowà, â guwà cibwaa pwa ma ipa-imwüruwà. ");
INSERT INTO priNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Ba o wâru tàpé na rà o tèepaa me, â rà o pa ê neeô. Â rà o ina tàwà pâ: “Wâgo pwi *Mesia, *pwi a pa-udòwà”. Â rà o ipa-imwüru ê pâ âboro na wâru. ");
INSERT INTO priNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","«Â guwà o têre cè airi paa, na wâmwünyabwe, ma jèkutâ goro paa na wâiti. Â guwà cibwaa nama wâgotàwà! Ba o nye mara tèepaa ê pâ pwiibà, êco na o càcaa pâji pwâadàra gòropuu. ");
INSERT INTO priNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Â o wâru pâ ipaa pitiri gòropuu. Ba ê pwi jè Ba, âna ru pipaa ma pwi jè Ba. Â wà pwi jè ukai, âna ru pipaa ma pwi jè ukai. Â o pâ nau tèepaa ê pâ copwa na maina, â o gù napuu, na pâ pàra ére gòropuu. ");
INSERT INTO priNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Ê pâ na pai pwa wèe bèepwiri, âna o pwacèwii ê pâbéaari maagé kâra pitèpa èpo.» ");
INSERT INTO priNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","«Na pwi pàara bèepwiri, âna rà o pièpàriwà gooò wà diri ê pâ âboro naa gòropuu. Â rà o tâjùruwà, ma tubaèpà tàwà, tiagoro cè pai pòtàmwarawà, gée goo na guwà tèpa âboro kôo. ");
INSERT INTO priNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","«Â o wâru tàpé na rà o panuâ ê cèikî kàra. Â rà o pièpàrirà côwâ wà tèpa ibéerà, ma pi-icurirà côwâ. ");
INSERT INTO priNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","O wâru cè tèpa *péroféta a pwâ, na rà o tèepaa me, â rà o ipa-imwüru pâ âboro na wâru. ");
INSERT INTO priNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Â ê èpà, âna o dau pimaina too naa na gòropuu. Â gée goo pwiri, na o wâru cè tàpé na o moo ê pimeaari kàra. ");
INSERT INTO priNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Êco na wà pwina é cimwü tia pwâadèreè, âna ée mwa pa-udòé wà Pwiduée ma naa têe ê *wâro dàra gòiri jaaé. ");
INSERT INTO priNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Â o mwa picémara pitiri ê *Picémara Wâdé goro ê Mwaciri napwéretòotù. Â rà o têreê êdiri pâ Ba naa gòropuu. Â gée na càùru pwiri, â o jèe pwâadàra gòropuu.» ");
INSERT INTO priNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","«Guwà o pâ nau côo ê capwi na é tèepaa me—muru na jè miiri, ma jè pwùkùru goo—na ia é inapàparié béaa wà péroféta Daniéla. Â ée mwa tâa na Wâra pwapwicîri kà Pwiduée.» (Â wà pwina é pûra ni, âna wâdé na é tâmogòori bwàti ê pwini!) ");
INSERT INTO priNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","«Â, na pàara bèepwiri, âna wâdé na rà uru naa gòro ê pâ jaa, wà tàpé na rà tâa *Judée! ");
INSERT INTO priNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Â wà pwina é nao gòroigé jii wâ, âna é cibwaa tò côwâ, nau mudàra cè jè muru, wâna ê wâ kêe. ");
INSERT INTO priNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Â wà pwina é tâa na ê na aupwanapô, âna é cibwaa wâjué côwâ naa jaaé, ma é popa cè ârabwée kêe. ");
INSERT INTO priNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Au, wârico! Ba, na ê pâ tòotù bèepwiri, âna o po dau pwaée kâra pa ilàri na rà nyarana, ma pa ilàri mwara na rà pa-di ê èpo kàra. ");
INSERT INTO priNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","«Guwà pwapwicîri tà Pwiduée pâ, na ê pai uru kàwà, âna càcaa tèepaa na pàara na èpà napô, ma na *tòotù pwicîri. ");
INSERT INTO priNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Ba, na pàara bèepwiri, âna rà o dau maagé côo wà tèpa âboro. Ba bwaa nye ticè cè pwi jè âboro, cèna é jèe maagé côo wàrapwiri—tapoo gée na autapoo goo ê gòropuu, tiagoro nabà. Â o jèe nye ticè cè pwi jè âboro, cèna ée mwa wàrapwiri côwâ cè pai maagé kêe. ");
INSERT INTO priNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","«Wiàna câé caa niimiri wà Pwiduée pâ é nama piboo ê jéûru tòotù-bà, â pwiri o nye ticè cè pwi jè âboro cèna é upa wâro kêe! Êco na é nye niimiri na é nama piboo, wàrapwiri goo wà tàpé na é jèe pitòrigarirà.» ");
INSERT INTO priNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","«Wiàna é ina tàwà cè pwi jè âboro pâ: “Guwà côo! É wâni wà pwi Mesia!” é géepà: “É wâna ê ére bèepwiri!” â guwà cibwaa cèikî naa goo. ");
INSERT INTO priNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Ba rà o mwa tèepaa me cè tèpa ‘mesia’ ma tèpa ‘péroféta’ na rà tèpa pwâ. Â rà o pwa ê pâ wakè goro pàtàmarà na rà o pò goo wà tèpa âboro, târa ma rà ipa-imwürurà. Â rà ipwadàrapwa mwara ma rà ipa-imwüru tàpé na é jèe pitòrigarirà wà Pwiduée. ");
INSERT INTO priNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Â êkaa, na go jèe tàmara ina tàwà ê pâ muru, na o mwa tèepaa! ");
INSERT INTO priNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","«Â wiàna rà ina tàwà pâ: “Guwà côo, wà pwi Mesia, âna é wâ namaré!” â guwà cibwaa pâra. Â wiàna rà ina tàwà pâ: “Guwà côo, é tà cârü ni!” â guwà cibwaa cèikî naa goo. ");
INSERT INTO priNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Ba wiàna go tèepaa boome côwâ, wâgo *Pwina naîri âboro, â êdiri pâ âboro, âna rà o côoô! Ba o pwacèwii ê âra, na ée pwéelaa, na jè o côo pitiri gòropuu. ");
INSERT INTO priNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Ba pwacèwii na jè mu ina pâ: “Wâna é tâ tabéaa wê bwaooré, âna é wêe ê macii bà.”» ");
INSERT INTO priNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","«Na pâ tòotù-bà, â rà o dau maagé côo ê pâ âboro. Â gée na càùru pwiri, â o tèepaa i pwi ia é ina wà péroféta Isaia. Ba é tàmara ina pâ: O câé té i tòotù. O bàutê i parui. Rà tûu pâ îricò. Gùmagù pâ pàaé. Ésaïe 13.10; 34.4 ");
INSERT INTO priNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","«Â géewê, â tèepaa naanidò *napwéretòotù, ê câmu kâra pai tèepaa kôo, wâgo Pwina naîri âboro. Â rà o kâa goro pai wâgotàra diri ê Ba gòropuu. Ba rà o côoô, na go tèepaa boome gòro nee, naa na ê pàtàmoo, ma ê pai maina ma muugère kôo. ");
INSERT INTO priNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Ûna é upi i tutu na maina wà pwi jè *angela, â go o mwa panuâ me tèpa angela kôo, ba na rà panaimari tàpé na go jèe pitòrigarirà pitiri ê gòropuu.» ");
INSERT INTO priNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","«Wâdé na guwà picòo bwàti, ê câmu kâra ê *iri wâi. Ba, na é tapoo ti, â guwà tâmogòori pâ, ée jèe tèepaa me ê pàara na ucuu i napô. ");
INSERT INTO priNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","«Wàrapwiri na guwà côo pâ, gére tèepaa diri pâ câmu na go gére ina, â guwà o tâmogòori pâ, o jèe pacoo diri. ");
INSERT INTO priNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Â go ina tàwà ê âjupâra pâ: O càcaa gòiri. Wà pàra tèpa âboro nabà, âna rà o bwaa nye côo pwiri, béaari ê pai o bà kàra. ");
INSERT INTO priNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Ba o tiàu ê napwéretòotù ma ê gòropuu; â napwa ê popai kôo, âna o càcaa tiàu.» ");
INSERT INTO priNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","«Ba nye ticè pwi âboro, cèna tâmogòori cè tòotù ma cè ineretòotù, cèna o tèepaa ê pâ muru bèepwiri. Ba câbà caa tâmogòori mwara wâgo Pwina naî Pwiduée, ma wà tèpa angela kêe. Â nye wàco Caa, na é tâmogòori. ");
INSERT INTO priNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","39","«Â rà o pò goro pai wâjué côwâ kôo, pwacèwii tàpé na ia rà pò goro i jawé, na ia tùpwùtùru gòropuu, na pàara kà Noa. Ba rà nye tà pi-ija ma wâdo; â rà piéa, ma paéari ê pa èpo kàra. Â ticè cèna rà tâmogòori, tèepaa naa goro i tòotù, na é tò naa na i wànga kêe wà Noa. Â é nye tèepaa me kaa i jawé, â cau poparà diri wàco Noa ma ê tâa kêe. «Â go ina tàwà pâ: O nye ipaiwà mwara, ma ê pai tèepaa me côwâ kôo. ");
INSERT INTO priNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Ba, na pwi tòotù-bà, âna o wà tupédu âboro, cèna ru wakè na aupwanapô. Âna o popa pwi jèpwi, â o naaco pwi jèpwi. ");
INSERT INTO priNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Â o du ârailu ilàri cèna ru tòbiti blé, âna o popa tô jèpwi, â é tà tâa tô jèpwi. ");
INSERT INTO priNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Guwà tà tàcî, ba o câguwà caa tâmogòori cè pàara, cèna ée tèepaa me côwâ wâna, wà Pwi Ukai kàwà! ");
INSERT INTO priNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Guwà tâmogòori cai ê pwini: Wà pwi apooro pwârawâ, âna câé caa tâmogòori cè ineretòotù na ée mwa tò naa na wâ kêe, wà pwi a mura, na é me naa ne. Ba wiàna é tâmogòori, â pwiri é pacooé. ");
INSERT INTO priNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Wàé kaa pwiri na go ina tàwà pâ: Guwà tà tàcî. Ba go o mwa tèepaa me côwâ, wâgo Pwina naîri âboro. Êco na o câguwà caa tâmogòori cè pàara cèna go o mwa tèepaa na.» ");
INSERT INTO priNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","«Wàilàapà cè pwi ênawéna pwi a pitêre dàra ma pitòimiriê? Wàéni: I pwi ia é ina têe wà pwi ukai kêe pâ: “Go panuâ tâgà ê wakè bèeni: Gà pa-ija pàra tèpa ênawéna, naa na pàara na o pâri.” ");
INSERT INTO priNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","«Â o dau wâdé ba kà pwi ênawéna bèepwiri wiàna é tèepaa me wà pwi ukai, âna é nye tàgére wakè bwàti! ");
INSERT INTO priNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Guwà côo, wà pwi ukai, âna ée naa têe ê pitûâ naa goo ê pâ wâdé kêe. ");
INSERT INTO priNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Êco na, wiàna wà pwi ênawéna, âna é pwi âboro èpà, â é piniimiri pâ, ‘O câé caa nama tèepaa me wài wà pwi ukai.’ ");
INSERT INTO priNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Â é tapoo èi tèpa bée goro wakè. Â é dau ija ma wâdo ma tèpa ipwirié. ");
INSERT INTO priNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Â, na jè tòotù na câé caa tapacîê, â é nye wâjué me côwâ kaa wà pwi ukai. ");
INSERT INTO priNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Â ée mwa naa ê wârimuru na dau gòo tà i pwi ênawéna bèepwiri, wàilà diri ma pàra tèpa ênawéna, na càra caa *tàrù. Â rà o i ma tòngüru poropwârà gée goro pai maagé kàra.» ");
INSERT INTO priNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","2","É ina mwara wà Iésu pâ: «Ê *Mwaciri napwéretòotù, âna pwacèwii ni: «Rà mwa tâa 10 èpo ilàri. Â 5 gée goorà, âna rà tèi bwàti, â 5 gée goorà, âna rà tàpo imwüru. Â mwa cau todàra diri naa na jè piéa. Â rà mwa popa ê wâra ânye kàra, ba na rà tapacî pwi a piéa. Ba ée mwa tèepaa me naa bàrane. ");
INSERT INTO priNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","4","Wà i pa èpo na ia rà tèi bwàti âna rà me pa i wâra ânye kàra, bau ê bwà kâra jawé. Â wà i pa èpo na ia rà tàpo imwüru, âna rà popa i wâra ânye kàra, êco na ticè jawé târa. ");
INSERT INTO priNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Â jèe bàrane, â rà cau tèepaa me, naa na pwârawâ kà i tô a piéa, ba na rà tapacîri pwi a piéa. Êco na câé caa tèepaa me wài, â rà cau puu diri. Rà puu, rà puu, rà puu… ");
INSERT INTO priNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","«Â nabwé, â po nabibiu kâra ne, â rà nye têre kaa ê pwâra uu, ma pwâratùra, na ina pâ: “Pa èpo! Wàéni i pwi a piéa! Guwà còobé ma jè pâra caraé!” ");
INSERT INTO priNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","«Â rà tàcî wài i pa èpo, â rà pwabwàti i ânye kàra. ");
INSERT INTO priNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Â wà i pa èpo na ia rà tàpo imwüru âna rà ina tà pa béerà pâ: “Au, jèe ticè jawé târa ânye kâbà! Guwà naa cè jawé, gée goro dàra jawé kàwà.” ");
INSERT INTO priNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","«Â rà tòpi tàra pâ: “Bwa! Pa èpo, jèe càcaa pâri. Guwà itàa wài naa na pwi pwârawâ bèepwiri gée, ma guwà ilari cè jawé.” ");
INSERT INTO priNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","«Êco na, na pàara na rà tàgére pâra na, â é tèepaa me i pwi a piéa. Â rà cau pâra diri tèpa âboro ma wà pwi a piéa, naa na wâra piéa. Â wà i pa èpo ilàri na rà tèi bwàti, âna rà pâra wiâê. Â nabwé, â é târi i goropwârawâ. ");
INSERT INTO priNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","«Napwa naa goo pa èpo na rà tàpo imwüru, âna rà ipwâ. Â rà mwa itàa me. Â rà cùu i goropwârawâ, ma ina pâ: “Pwi ukai, tàpiri i goropwârawâ!” ");
INSERT INTO priNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","«Êco na é tòpi tàra i pwi a piéa pâ: “Guwà pâra, ba câgo caa tâmogòoriwà.”» ");
INSERT INTO priNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Â é tubanabwé ê ucina bèepwiri wà Iésu, â é ina pâ: «Guwà tà tàcî, ba câguwà caa tâmogòori cè tòotù, ma cè ineretòotù, na go o mwa tèepaa me côwâ. Nabwé.» ");
INSERT INTO priNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","É ina mwara wà Iésu pâ: «Ê pai pwa goo ê Mwaciri napwéretòotù, âna o pwacèwii ni: «É mwa tâa pwi jè âboro. Â mwa nümee na é pâra nau ipokâa naa jè napô. Â é mwa todà tèpa ênawéna kêe. Â é mwa panuâ tàra ê tàrù, naa goro diri ê pâ neemuruê. ");
INSERT INTO priNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","«Â é jèpa naa tàra jèpa mwani kêe, ba na rà wakèri, wiâra pai tâmogòorirà kêe. Â é naa tà pwi jèpwi 5 miliô mwani mii, â wà pwi jèpwi ârailu miliô, â wà pwi béâracié, caapwi miliô. Â nabwé, â é pâra jiirà. ");
INSERT INTO priNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Â wà i pwi ia tòpi 5 miliô, âna é nye wakèri kaa i pwi ia naa têe, â é pâmari 5 miliô mwani bèreè. ");
INSERT INTO priNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Â wà i pwi ia naa têe ârailu miliô, âna é ipwacèwii mwara, â é pâmari mwara ârailu miliô bèreè. ");
INSERT INTO priNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Â napwa naa goo i pwi ia naa têe caapwi miliô, âna é nye tà pwàniri, â câé caa pawakèri. Â é câjipi naa napuu i mwani na ia naa têe.» ");
INSERT INTO priNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","«Paé pâ parui, paé, paé, paé… Jèe gòiri pai pâra kà i pwi apooro i mwani. Â nabwé, â é pâ nau wâjué me côwâ naa pwârawâ kêe. Â é todà tèpa ênawéna kêe, ma tawèerirà goro i jèpa mwani, na ia é jèpa pâdi tàra. ");
INSERT INTO priNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","«Â é tòpi têe i pwi jè ênawéna pâ: “Pwi ukai, wàéni i 5 miliô mwani na ia gà naa tôo. Â wàéni 5 miliô mwani ârawakè kôo bèreè.” ");
INSERT INTO priNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","«Â é ina têe i pwi ukai pâ: “Po dau wâdé, ba gà pwi a wakè bwàti. Ba gà pitêre dàra naa na nyi muru na kîri, â go mwa naa tâgà cè muru cèna maina. Â gà tòme ma ju pi-ija, ma ipwàdée naima.” ");
INSERT INTO priNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","«Â é me wà i pwi béârailu kà tèpa ênawéna, â é ina tà pwi ukai kêe pâ: “Pwi ukai, wàéni i ârailu miliô mwani na ia gà naa tôo. Â wàéni ârailu miliô mwani na go naa dòme.” ");
INSERT INTO priNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","«Â é ina têe i pwi ukai pâ: “Po dau wâdé, ba gà pwi a wakè bwàti. Ba gà pitêre dàra naa na nyi muru na kîri, â go mwa naa tâgà cè muru cèna maina. Â gà tòme ma ju pi-ija, ma ipwàdée naima.” ");
INSERT INTO priNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","«Â é me wà pwi béâracié, â wâgotêe â é ina têe pâ: “Au, pwi ukai, go nye tâmogòori pâ, gà pwi a putàmu naa goo tàpé na càra caa wakè bwàti. Ba gà pwi a piûnyari ê ârawakè na câgà caa câmi, â gà panaimari ê pwina câgà caa wakèri. ");
INSERT INTO priNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Â wâgotôo, ba go péa tubatiàu i mwani'gà. Â go nye tà naapwàniri. Â wàéni, â gà nye popa côwâ.” ");
INSERT INTO priNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","«Â é tòpi têe wà i pwi ukai kêe pâ: “Gà pwi ênawéna na èpà, â gà pwi a pwa ciritàu! Wànau? Gà nye tâmogòori pâ, go piûnyari ê pwina câgo caa câmi, â go panaimari ê pwina câgo caa wakèri. ");
INSERT INTO priNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Üu kaa, â pwiri gà gére tòpò naa na cè wâra mwani i mwani kôo. Ba wiàna gà gére wàrapwiri, â pwiri go o mwa gére pa, bau cè naîê, gée na wâra mwani!” ");
INSERT INTO priNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","«Â é ina tà tèpa pwàliici kêe pâ: “Popa jiié caapwi miliô mwani bèepwiri, â guwà naa tà pwina wâru mwani kêe! ");
INSERT INTO priNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Ba wà pwina jèe pwa têe, âna o jèu âjagò têe côwâ. Â o tà têe muru na piêdò ma piwéna. Â wà pwina kîri ê pwina tà têe, âna o nye dàgòtù jiié côwâ ê ji dàramuru na tà têe. ");
INSERT INTO priNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Â wà pwi ênawéna bèeni na câé caa wakè âna piticèmuru naa gooé. Â wâdé na tüê naa na bàutê! Â ée mwa i ma é tòngüru poropwêe gée goro pai maagé côo kêe.” Nabwé naawê!» ");
INSERT INTO priNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","É ina mwara wà Iésu pâ: «Go o mwa tèepaa me côwâ, wâgo *Pwina naîri âboro, wâna pàtàmoo ma pai maina ma muugère kôo, ma wà diri tèpa *angela kôo. Â go o mwa tâa gòro autâa kôo ba na go pitûâ. ");
INSERT INTO priNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","«Â o panaimari na arao diri ê pâ Ba. Â go o mwa naaitiri ê pâ âboro, pwacèwii pwi a wéaari macii na é naaitiri mutô ma nani. ");
INSERT INTO priNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Â go o mwa tòpò tàpé na rà pwa ê câbawâdé kà Pwiduée naa gòro îô étò. Â wà pàra tàpé na càra caa pwa ê câbawâdé kêe, âna go o mwa tòpòrà naa gòro aèmwü kôo. ");
INSERT INTO priNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","«Â wâgo pwi ukai, âna go o mwa ina tà tàpé na rà tâa gòro îô étò pâ: “Cidòri nyuâawà, ba é *pwényunyuâariwà wà Pwiduée Caa! Tòme, naa na Mwaciri kà Caa. Â guwà tòpi êdiri pâ aupwényunyuâari kêe, wâna ê Mwaciri, na é jèe pwabwàti ba kàwà, gée na autapoo wàra ê gòropuu. ");
INSERT INTO priNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Gée goo na, na ia go copwa, â guwà naa uti kôo. Â na ia nümoo dàra wâdo, â guwà naa wâdooò. Â na ia go pwi pârame, â guwà tòpio. ");
INSERT INTO priNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Â na ia piticè ârabwée kôo, â guwà naa ârabwée kôo. Â na ia go maagé, â guwà meaario. Â na ia go tâa na karapuu, â guwà me nau caio.” ");
INSERT INTO priNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","«Â rà o mwa tà tòpi tôo, wà tàpé na rà *tàrù pâ: “Pwi Ukai, wiidà na bà côogà na gà copwa, â bà naa uti'gà? Ma wiidà na nümagà dàra wâdo, â bà naa wâdoogà? ");
INSERT INTO priNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Â wiidà na gà pwi pârame, â bà tòpigà? Â wiidà na ticè ârabwée'gà, â bà naa ârabwée'gà? ");
INSERT INTO priNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Â wiidà na gà maagé, â bà meaarigà? Â na gà tâa na karapuu, â bà caigà? Wiidà na bà pwa tâgà diri pâ pwiibà?” ");
INSERT INTO priNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","«Â go o mwa tòpi tàra pâ: “Guwà têre bwàti, ba go ina tàwà ê âjupâra pâ: Na diri pâ pàara na guwà pwa ê pâ pwiibà tà tèpa aéjii kôo na rà kîri, âna wâgo na guwà pwa tôo.” ");
INSERT INTO priNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","«Â napwa naa goo tàpé na rà o tâa gòro aèmwü kôo, âna go o mwa ina tàra pâ: “Guwà pâra jiio, ba é tojiiwà wà Pwiduée! Guwà pâra naa na ânye na é nye tà tòo awé, na é jèe ipwabwàti wà Pwiduée, ba kà *Caatana, wà pwi a cicarajè, ma wà tèpa duée kêe. ");
INSERT INTO priNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Gée goo na, na ia go copwa, â câguwà caa naa cè uti kôo. Â na ia nümoo dàra wâdo, â câguwà caa naa cè wâdooò. ");
INSERT INTO priNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Â na ia go pwi pârame, â câguwà caa tòpio. Â na ia ticè ârabwée kôo, â câguwà caa naa ârabwée kôo. Â na ia go maagé, â câguwà caa meaario. Â na ia go tâa na karapuu, â câguwà caa caio.” ");
INSERT INTO priNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","«Â rà o tòpi tôo pâ: “Pwi Ukai, wiidà na câbà caa pitu tâgà? Wiidà na gà copwa ma nümagà dàra wâdo, ma gà pwi pârame, ma na ticè ârabwée'gà? Â wiidà na gà maagé, ma gà tâa na karapuu?” ");
INSERT INTO priNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","«Â go o mwa ina tàra pâ: “Go ina tàwà ê âjupâra pâ: Na diri ê pâ pàara na tàutàwà na guwà pitu tà tèpa aéjii kôo na rà dau kîri, âna tàutàwà na guwà pitu tôo.” ");
INSERT INTO priNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","«Â wà tàpéebà, âna rà mwa bàra pâra jiio, nau pwa wârimuru dàra gòiri. Â wà tèpa âboro na rà tàrù, âna rà mwa bàra wârori ê *wâro dàra gòiri jaa Pwiduée.» ");
INSERT INTO priNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Ûna é ina diri ê pâ pwiibà wà Iésu, â é ina tà tèpa *câmu kêe pâ: ");
INSERT INTO priNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","«Tàpéebà, guwà tâmogòori pâ, naa na ârailu tòotù, na o pwa tòotù *Paséka. Â go ina tàwà pâ: O icurio ma tanamiriô naa goro kurucé, wâgo *Pwina naîri âboro.» ");
INSERT INTO priNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Na pwi pàara na é ina pwiri wà Iésu, â wà tèpa caa kà tèpa pwa *ârapwaailò, ma wà tèpa pitûâ kà tèpa *Juif, âna rà gére pitapitirirà naa jaa wà Caïphe, pwi ukai kàra. ");
INSERT INTO priNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Ba nümarà na rà pòtàmwara Iésu. Â rà imudàra cè pai pwa wèe, ma rà pwa tûâ têe, ma tâjùrué pwàniri. ");
INSERT INTO priNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Ba rà pi-ina tàra pâ: «O po càcaa wâdé na jè tâjùrué na ara pâ âboro, na pàara na pwa i pi-ija maina na. Ba péa rà tà putàmu naa goojè.» ");
INSERT INTO priNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Na pwi pàara bèepwiri, âna é tâa Bétani wà Iésu, wâna pwârawâ kà Simona, pwi a pwa maga. ");
INSERT INTO priNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Â, na rà gére ija, â é tèepaa me wà tô jè ilàri, bau ê wâra jawé atü, na wâbé goro ê jawé ûrea—pwi jawé na dau maina ê wâri wèe. Â é wicèpwiri naa gòro pûru Iésu. ");
INSERT INTO priNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Ûna rà côoê wà tèpa câmu kêe, â po dau càcaa wâdé tàra. Â rà pi-ina tàra pâ: «Cina é po dau pwatari i jawé ûrea? ");
INSERT INTO priNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Po dau maina ê wâri wèe! Gorodà na câé caa icuri, ma é naa ê wâri wèe tà tàpé na ticè kàra?» ");
INSERT INTO priNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Â é tâmogòori ê auniimiri kàra wà Iésu, â é ina tàra pâ: «Cina guwà nama é tòina tô ilàri bèeni? Ê pwina é pwa tôo, âna po dau wâdé. ");
INSERT INTO priNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Ba rà o nye tà ciburà wâjaawà wà tàpé na ticè kàra. Â napwa wâgo, âna o câgo caa tà ciburà tâa jaawà. ");
INSERT INTO priNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Â wà tôoni, âna é wicèpwiri naa gò-o i jawé. Â wiàna wàrapwiri, â târa ma pwabwàti cawi ê pai o boo kôo naa napwêe. ");
INSERT INTO priNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Â go ina tàwà ê âjupâra pâ: Na diri pâ ére, na o mwa inapàpari ê *Picémara Wâdé naawê—naa na gòropuu diri—â o piwiâ mwara ê jèkutâ goo ê pwina é pwa wà tô ilàri bèeni. Â o nye tà ciburà niimiriê.» ");
INSERT INTO priNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Wà pwi jè ârapàara tèpa 12 *apostolo na nee Judas Iscariote, âna é pâ nau côo tèpa caa kà tèpa pwa ârapwaailò. ");
INSERT INTO priNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Â é ina tàra pâ: «Dà cèna guwà o naa tôo, wiàna go naa tàwà Iésu?» Â rà naa têe 30 mwani pwaa. ");
INSERT INTO priNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Â tapoo na pàara bèepwiri, â é tapoo imudàra cè ji pàara cèna é icuri wà Iésu tàra na. ");
INSERT INTO priNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","É jèe tèepaa ê bétapoo tòotù, kâra ‘pi-ija poloa na ticè nyaa kêe’. Â rà medari Iésu wà tèpa câmu kêe, â rà ina têe pâ: «Bà o pâ nau pwabwàti ê utimuru târa Paséka. Â wâpà na nümagà na jè pi-ija wê?» ");
INSERT INTO priNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Â é tòpi tàra pâ: «Guwà pâra naa na ville, wâjaa pwi âboro bèeni, â guwà ina têe pâ: “É ina wà pwi a pwa pupûra kâbà pâ, o jèe tèepaa ê pàara kêe. Â bà mwa ija ê utimuru târa Paséka ma wàé, naa jaagà.”» ");
INSERT INTO priNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Â rà pâra, â rà pwabwàti i utimuru târa Paséka. ");
INSERT INTO priNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Jèe bàrane, â rà tâa goro taapà wà Iésu ma wà tèpa 12 apostolo kêe. ");
INSERT INTO priNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Â é ina tàra pâ: «Go ina tàwà ê âjupâra pâ: Pwa pwi jè ârapàarawà na ée mwa ipwa tûâ tôo.» ");
INSERT INTO priNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Â rà pikîri tèpa câmu kêe, â rà jèpa pitawèerié jècaa pâ: «Gona pwiri càcaa wâgo, co Pwi Ukai?» ");
INSERT INTO priNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Â é tòpi tàra pâ: «Akaé, wà pwi jè ârapàarawà, âna wàé kaa na ée mwa pwa tûâ tôo—wà pwina bu capai tuboo, naa na i na ngapò ma wàé. ");
INSERT INTO priNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","«Wâgo Pwina naîri âboro, âna go o pâ nau bà, wàra na é jèe inapàpari ê *Tii Pwicîri. Â napwa naa goo wà pwi âboro na é pi-icurio, âna po dau pwaée kêe. Au, wârico! Ba wà pwiibà, âna pwiri nye gére wâdé ba kêe, wiàna càcaa gére pitèpaé!» ");
INSERT INTO priNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Wà Judas, wà pwina é icuri Iésu, âna é tawèerié pâ: «Gona pwiri càcaa wâgo, co pwi a pwa pupûra?» Â é tòpi têe wà Iésu pâ: «Gà jèe nye tàgére ina.» ");
INSERT INTO priNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Ûna rà pi-ija naima, â é popa ê poloa wà Iésu. Â é pwaolé tà Pwiduée. Â é tubiti, â é naa jècaari tà tèpa câmu kêe, â é ina tàra pâ: «Guwà popa, â guwà ija, ba êni naiio.» ");
INSERT INTO priNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Â gée na càùé, â é popa i wârado dipâa. Â é pwaolé tà Pwiduée, â é naa tàra. Â é ina pâ: «Guwà cau wâdo. ");
INSERT INTO priNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Ba domii kôo, na o jèe joro ba kà tèpa âboro, bépwanauri ê pâ èpà kàra; domii na é pacoo ê *auipwataâboro na é pwa wà Pwiduée na é tòpò pinaanapô naa nabibiu kàwà ma wàé. ");
INSERT INTO priNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","«Â go ina tàwà pâ: O câgo mwa caa wâdo cè dipâa naani gòropuu. Jè o mwa wâdo naima cè dipâa cèna bwaa âmuê, naa na Mwaciri kà Caa kôo.» ");
INSERT INTO priNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Â rà nyabiri ê pâ *salamo târa ê pwi *tòotù maina-bà, â géewê, â rà too naa gòrojaa Élaio. ");
INSERT INTO priNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Â é ina wà Iésu tà tèpa câmu kêe pâ: «Naa na ne nabà, âna guwà o mwa po capai panuâô diri, gée goo ê pwina o mwa tèepaa medario. Ba jèe wii naa na Tii Pwicîri pâ: O mwa pòtàmwara pwi a wéaari mutô. O tadidiri pâ mutô. Zakarie 13.7 ");
INSERT INTO priNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","«Êco na, wiàna go mwa wâro côwâ gée na aubà, â guwà o mwa pâmariô naa Galilée.» ");
INSERT INTO priNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Â é ina têe wà Pétéru pâ: «Wà tàpéeni âna rà o panuâgà, â o càcaa wâgo!» ");
INSERT INTO priNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Â é tòpi têe wà Iésu, pâ: «Go ina tâgà ê âjupâra pâ: Naa na ne nabà, béaari ê pai wailu to kâra ê ja, â wâgà, âna gà o wacié pitütôowâri pâ, câgà caa tâmogòorio.» ");
INSERT INTO priNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Â é ina wà Pétéru pâ: «Bwa! Wiàna ina pâ, o tétàmwaraju, â câgo caa pitütôowârigà!» Â wàilà diri, âna nye caapwi ê pwina rà ina têe. ");
INSERT INTO priNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Géewê, â rà pâra naa na jè ére na câmi goro upwâra na ina goo wê pâ Gethsémané. Â é ina tà tèpa câmu kêe wà Iésu pâ: «Guwà tâaboo naani, ba go bwaa pâ nau pwapwicîri wâgéebà.» ");
INSERT INTO priNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Â é popa wiâê wà Pétéru ma wà tupédu naî Zébédée. Â é tapoo pikîri ma pidumapiê wà Iésu. ");
INSERT INTO priNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Â é ina tàra pâ: «Po dau tòina ma pikîri ê pwâranümoo. Â guwà tàpo tâa ni, â jè cau tà tàcî naima. Guwà cibwaa puu!» ");
INSERT INTO priNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Â é tàpo paé jiirà, â é tùu jùrué ma cigòboo. Â é pwapwicîri tà Pwiduée, ma ina pâ: «Caa, wiàna pâri, â gà patâjii jiio ê pâ aré ma tòina bèeni! Êco na gà cibwaa pwa ê pwina nümoo goo, â gà nye pwa câbawâdé'gà.» ");
INSERT INTO priNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Â é wâjué me côwâ dari tèpa âracié a câmu kêe, â é côo pâ rà tà puu. Â é ina tà Pétéru pâ: «Gona càcaa pâri ma guwà tàpo tàcî naima ma wâgo, wâna ji caapwi ineretòotù? ");
INSERT INTO priNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","«Guwà tà tàcî, â guwà pwapwicîri ba na o pwa cè nii ma gòo kàwà, wiàna tacaiwà. Ba nümawà na guwà pwa na wâdé, êco na ticè nii kàwà.» ");
INSERT INTO priNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","É jèu pâra côwâ wà Iésu jiirà, â é jèu pwapwicîri ma ina pâ: «Caa wée, wiàna càcaa pâri ma o popa jiio ê aré ma tòina bèeni, â go ilari jiigà pâ, gà pitu tôo, ma go pitêre dàra câbawâdé'gà.» ");
INSERT INTO priNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Ûna é wâjué me côwâ dari tèpa âracié a câmu kêe, â é pâmarirà mwara na rà gére puu. Ba nye po dau oratàra, â rà nye tà puucinga. ");
INSERT INTO priNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Â é jèu pâra côwâ jiirà, â é jèu pwapwicîri, â é ina côwâ ê pwina é jèe ina. ");
INSERT INTO priNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Ûna é wâjué me côwâ darirà, â é pâmarirà côwâ na rà tàgére puu. Â é ina tàra pâ: «Wànau? Guwà bwaa nye gére nao ma puu mwara? Wâdé ba kàwà! Êco na wâgo, Pwina naîri âboro, âna o jèe panuâô ni tà tèpa pwa na èpà. Ba rà tàgére mee ni, ba na rà tâjùruo. ");
INSERT INTO priNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Guwà cimadò! Ma jè pâra! Ba wà pwina é ipa popai gooò, âna jèe tà wàépwiri!» ");
INSERT INTO priNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Ûna é bwaa gére ina pwiri wà Iésu, â é po tèepaa me wà Judas, wà i pwi jè ârapàara tèpa 12 apostolo kêe. Â rà tèepaa me wiâê pâ âboro na wâru, na rà pa ê pâ tàuwa ma gò upwâra. Ba rà panuârà me wà tèpa caa kà tèpa pwa ârapwaailò, ma wà tèpa pitûâ kâra ê Ba kà tèpa Juif. ");
INSERT INTO priNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Â wà Judas, wà pwina é icuri Iésu, âna é jèe inapàpari tàra ê câmu na ée mwa pwa têe: «Wà pwi âboro na go bwénüuê, âna nye wàé kaa. Â guwà tâjùrué.» ");
INSERT INTO priNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Â rà tèepaa me, â é nye pâra dà Iésu kaa wà Judas, â é ina têe pâ: «Bwàcu'gà co pwi a pwa pupûra!» Â é bwénüuê. ");
INSERT INTO priNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Â é ina têe wà Iésu pâ: «Îgà, gà pwa ê wakè'gà.» Â rà nye pò ma tâjùru kaa wà Iésu wà tèpa âboro. ");
INSERT INTO priNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Êco na wà pwi jè a câmu na é tâa jaa Iésu, âna é pò ma càù ê tàuwa kêe, â é nye tüboo kaa naa gòro pûru pwi âboro kîri kà pwi *ukai kà tèpa pwa ârapwaailò. Êco na é tépàgà co ê jè doronyüruê. ");
INSERT INTO priNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Â é ina têe wà Iésu pâ: «Gà tùu boo côwâ i tàuwa'gà naa na ê wêe! Ba wà tàpé na rà paa goro tàuwa, âna rà o nye bà goro tàuwa. ");
INSERT INTO priNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","«Guwà têre, wiàna nümoo, â go todà caa kôo, ba na é panuâ me tôo, jè wâra coda goro tèpa *angela ma rà pwamuruô, na rà dau wâru awé! ");
INSERT INTO priNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Êco na, wiàna wàrapwiri, â o càcaa pâri ma coo i pwi ia jèe wii naa na Tii Pwicîri. Bwa. Wâdé na wàra, ba na o nye pacoo i Tii Pwicîri.» ");
INSERT INTO priNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Â é ina tà tàpé na rà tâjùrué, pâ: «Wànau, guwà me nau popao, goro ê pâ tàuwa, ma ê gò upwâra, pwacèwii na go pwi a pòtàmwara âboro! Êdiri na pâ tòotù, âna go tâa nabibiu kàwà. Â go pacâmuri tèpa âboro, naa na *Wâra pwapwicîri. Êco na câguwà caa tâjùruo! ");
INSERT INTO priNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","«Êco na, diri ê pwi bèepwiri, âna tèepaa, ba na pacoo ê popai kà tèpa *péroféta wâna Tii Pwicîri.» Â napwa naa goo diri tèpa câmu kêe, âna rà cau panuâê, â rà uru. ");
INSERT INTO priNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Wà tàpé na rà tâjùru Iésu, âna rà popaé pâdari Caïphe, wà pwi ukai kà tèpa pwa ârapwaailò. Ba rà ipitiri naa jaaé wà tèpa *dotée goro ê Naèà, ma wà tèpa pitûâ kà tèpa Juif. ");
INSERT INTO priNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Â napwa wà Pétéru, âna é picâwiâê gée iti. Â é tèepaa pâ naa jaa pwi ukai kà tèpa pwa ârapwaailò. Â é tâaboo naa na pé gòroigé, naa jaa tèpa âboro kîri, tèpa wéaa. Ba nümee na é côo cè pwina o tèepaa tà Iésu. ");
INSERT INTO priNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Wà tèpa caa kà tèpa pwa ârapwaailò, ma diri ê pé wâra pitèimuru kà tèpa Juif, âna rà mudàra cè tèpa âboro, na rà tèpa pwâ, ma rà pitòti wà Iésu. Ba nümarà na rà pwa wârimuru têe ma é bà. ");
INSERT INTO priNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Â wâru tèpa pwâ, na rà me nau pitòti Iésu, êco na càra caa pâmari ê âji majoroé ma rà pòtàmwereê. Â pâ nau pwâadàra pitèimuru kàra, â ru tèepaa me tupédu ârailu âboro. ");
INSERT INTO priNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Â ru ina pâ: «Ê ji pwi âboro bèepwiri, âna é pi-ina kêe pâ, ée mwa tédidiri ê Wâra pwapwicîri kà Pwiduée, â ée mwa pacima côwâ naa na âracié tòotù.» ");
INSERT INTO priNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Â é nye cimadò kaa i pwi ukai kà tèpa pwa ârapwaailò, â é tawèeri Iésu pâ: «Gona ticè bétòpigà? Câgà caa têre ê pwina rà gére pitòtigà goo?» ");
INSERT INTO priNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Êco na câé caa tòpi wà Iésu. Â é nye tawèerié côwâ i pwi ukai, pâ: «Naa goro nee Pwiduée na é wâro, â go ilagà pâ gà tòpi. Gona nye wâgà kaa pwi *Mesia, *Pwina naî Pwiduée?» ");
INSERT INTO priNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Â é tòpi têe wà Iésu pâ: «Gà jèe nye tàgére ina. Â go ina tàwà pâ: Tapoo nabàni, âna guwà mwa côo wà Pwina naîri âboro, na é tâa gòro étò kà Pwiduée na dau pwa pàtàmee, ba na é pitûâ kâra diri pâ muru. Â guwà mwa côoê, wiàna é me naa gòro ê pâ nee, gée napwéretòotù.» ");
INSERT INTO priNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Â po dau dàpàgà tà pwi ukai kà tèpa pwa ârapwaailò, â é nye dau putàmu kaa. Â é nye tidàpa kaa ê ârabwée kêe, â é ina tà tèpa pitèimuru bée pâ: «É tùra ba èpà naa goo Pwiduée ba é nama ipaiwàilu ma wàé! Jèe pâri! Naaco cè tèpa pitòtié, ba é nye pitòtié côwâ! Ba guwà jèe têre ê pwina é ina. ");
INSERT INTO priNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Â dà cèna guwà niimiri naa gooé?» Â rà cau tòpi diri pâ: «Wâdé na é bà.» ");
INSERT INTO priNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Â rà èduri ê naporomee, â rà tòbitié goro îrà. Â wà pàra tàpé, âna rà tamagérié, ");
INSERT INTO priNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","â rà ina têe pâ: «Wàilàapà na èigà? Gà pinadàra cai, co pwi dòro ‘Mesia’, wiàna gà pwi péroféta na gà tâmogòori diri!» ");
INSERT INTO priNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Napwa wà Pétéru, âna é nye tà tâaboo gòroigé. Â é medarié tô jè ênawéna, â é ina têe pâ: «Ée, wâgà kaa, âna gà pwi bée Iésu, gée Galilée!» ");
INSERT INTO priNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Â é tòpi têe na ara diri tèpa âboro, ma ina pâ: «Bwa! Câgo caa tâmogòori ê pwina gà ina!» ");
INSERT INTO priNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Â é nye pâra dàra kaa ê goropwârawâ na aucòobé. Â é côoê tô jè ilàri awakè wê, â é ina tà tèpa tàgére tâa wê, pâ: «Wà pwini, âna pwi bée wà Iésu gée Nazareth!» ");
INSERT INTO priNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Â é ina mwara wà Pétéru pâ: «Bwa! Go ipwataâboro ba câgo caa tâmogòorié!» ");
INSERT INTO priNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Gée na càùé, â wà tèpa tâa wê, âna rà medari wà Pétéru, â rà ina têe pâ: «Akaé! Gà pwi jè a câmu kêe! Ba bà têre naa na wéegére pwâratùra'gà.» ");
INSERT INTO priNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Â é nye pigòo kaa wà Pétéru ma ina pâ: «Guwà têre! Câgo caa tâmogòori wà pwiibà. Wâdé na é pwa wârimuru tôo wà Pwiduée, wiàna go pwâ! Guwà côo, go *ipwataâboro tàwà pâ: Câgo caa tâmogòori wà pwiibà!» Ûna é bwaa gére ina pwiri, â é nye to kaa i ja. ");
INSERT INTO priNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Â é mwa niimiri i pwi ia é ina têe wà Iésu pâ: «Béaari ê pai to kâra i ja, âna gà o wacié pitütôowâri pâ, câgà caa tâmogòorio.» Â é còobé naa gòroigé wà Pétéru, â é dau i pijinünü. ");
INSERT INTO priNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Ûna po dàuru moo, â rà pitapitirirà naima wà tèpa caa kà tèpa pwa *ârapwaailò, ma wà tèpa pitûâ kâra ê Ba kà tèpa *Juif. Â rà pitêrerà goro ê pai o pòtàmwara Iésu. ");
INSERT INTO priNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Â rà pwa ma piié, â rà popaé pâdari wà *Pilato, pwi kupénoo kà tèpa Roma. ");
INSERT INTO priNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Napwa wà Judas, wà i pwi ia icuri wà Iésu, âna é côo pâ rà o jèe pòtàmwereê. Â é mwa tà pinünüma naa goo ê pwina é pwa tà Iésu, â é dau pikîri goo. Â é wâjué côwâ naa jaa tèpa caa kà tèpa pwa ârapwaailò, ma wà tèpa pitûâ. Â é naa tàra côwâ i 30 mwani atü na ia rà naa têe. ");
INSERT INTO priNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Â é ina tàra pâ: «Au, go pwa ê pwina èpà. Ba go icuri pwi jè âboro na ticè èpà kêe, ma é bà.» Â rà tòpi têe pâ: «Ticè cèna bà côo naa goo!» ");
INSERT INTO priNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Â é tüboo i mwani naa na Wâra pwapwicîri. Â é pâ nau pidàpuna. ");
INSERT INTO priNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Â wà tèpa caa kà tèpa pwa ârapwaailò, âna rà tòri i mwani, â rà ina pâ: «Dà cèna jè pwa goro i mwani bèeni? Jè cibwaa tòpò naa jaa i âraimeai târa Wâra pwapwicîri, ba mwani wâri domii.» ");
INSERT INTO priNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Â rà pitêrerà pâ, na rà wâri napuu na ina goo pâ ‘Napuu kà pwi a pwa ilò puu’ ba na nacârü ba kà tèpa pârame. ");
INSERT INTO priNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Êkaa pwiri, wà tèpa âboro, âna rà ina goo ê pwi ére-bà pâ ‘Napuu wâri domii’. Â rà bwaa nye ina pwiri tiagoro ni. ");
INSERT INTO priNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Diri ê pâ pwiibà, âna tèepaa, ba na pacoo ê pâ ucina na ia é pwa wà *péroféta Iéremia, naa na pâ auwii kêe. Rà popa i 30 mwani atü. Êkaa jéûê na rà niimiri ê Ba *Isaraéla na rà wâri ba kêe. ");
INSERT INTO priNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Â rà wâri i napuu kà pwi a pwa ilò puu. Ba wàépwiri ê câbawâdé kà Pwi Ukai. ");
INSERT INTO priNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Rà popa pâ Iésu na ara Pilato, wà pwi kupénoo kà tèpa *Roma. Â é tawèerié wà Pilato pâ: «Gona nye wâgà kaa, na gà pwi ukai kà tèpa Juif?» Â é tòpi têe wà Iésu pâ: «Gà jèe nye tàgére ina.» ");
INSERT INTO priNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Â nabwé, â rà pitòti Iésu wà tèpa caa kà tèpa pwa ârapwaailò, ma wà tèpa pitûâ kâra ê Ba. Â câé caa tòpirà. ");
INSERT INTO priNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Â é pwa ma ina têe wà Pilato pâ: «Câgà caa têre diri pâ pwina èpà na rà ina naa googà?» ");
INSERT INTO priNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Êco na câé caa tòpi goo cè jè ji caapwi neeremuru wà Iésu. Â é po dau pò gooé wà i pwi kupénoo. ");
INSERT INTO priNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Napwa i pwi kupénoo, âna câmaajé têe, na diri pâ naja, na tòotù *Paséka, na é pacòobé gée na karapuu, cè pwi jè âboro, na nüma ê Ba gooé. ");
INSERT INTO priNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Â, na naja bèepwiri, â pwa pwi jè a pwa karapuu na ina gooé pâ Barabbas, na rà dau tâmogòorié wà tèpa âboro. ");
INSERT INTO priNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Â wâru tèpa âboro na rà tèepaa me naa jaa Pilato, â é ina tàra pâ: «Gona nümawà na go panuâ côwâ wà pwini Barabbas, é, wà Iésu, na ina gooé pâ ‘pwi *Mesia’, pwi ukai kàwà?» ");
INSERT INTO priNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Ba é nye tâmogòori pâ, wà tèpa caa kà tèpa pwa ârapwaailò, âna rà panuâ têe wà Iésu, goro pai piboo kàra. ");
INSERT INTO priNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Â nabwé, â é tâa gò i aupitèimuru wà Pilato, ba na é pitèi Iésu. Â, na ji pàara-bà, âna é nye tèepaa me kaa, wà pwi jè âboro, na é pame tà Pilato ê popai kà tô wâdèe. Â é ina pâ: «Èruune, âna go pwa naurune naa goo pwi Iésu bèeni. Â go po dau càcaa wâdé goo. Gà panuâê, â gà cibwaa tu naa gooé, ba é pwi âboro pwicîri!» ");
INSERT INTO priNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","21","Â é jèu ina tà tèpa âboro wà i pwi kupénoo pâ: «Go o mwa panuâ côwâ tàwà pwi jè a pwa karapuu. Wàilàapà gée goo tupéeni na nümawà gooé?» Â rà tòpi têe pâ: «Barabbas!» Ba rà cètùurà wà tèpa caa kà tèpa pwa ârapwaailò ma wà tèpa pitûâ ba na rà ina pwiri, ba na é bà wà Iésu. ");
INSERT INTO priNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Â é ina tàra wà Pilato pâ: «Â dà cèna go o pwa tà Iésu, na ia ina gooé pâ ‘Mesia’?» Â rà tòpi têe pâ: «Nama tanamiriê naa goro *kurucé!» ");
INSERT INTO priNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Â é jèu tawèerirà mwara pâ: «Gona dà cèna é pwa cèna èpà?» Êco na rà tomara too pâ: «Nama tanamiriê naa goro kurucé!» ");
INSERT INTO priNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Â é côo wà Pilato pâ, càra caa têreê, â jèe pâ nau dau maina ê pai gù kàra. Â é popa ê wâra jawé, â é nuwa îê, na ararà diri, â é ina tàra pâ: «Câgo caa pwi majoro pai bà kà pwi âboro bèeni. Â nye wâguwà co!» ");
INSERT INTO priNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Â rà cau tòpi têe diri, pâ: «Üu, nye wàibà kaa tèpa majoroé, wàibà ma wà tèpa èpo kâbà! Â wâdé kaa na é bà. Wiàna bà pwa na èpà, â o wâdé na bà o tòpi urà pai bà kêe.» ");
INSERT INTO priNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Â wà Pilato, âna é panuâ côwâ tàra wà Barabbas. Â é pwa ma pâdi Iésu goro ubati. Â é panuâê tà tèpa coda, ba na rà tanamiriê naa goro kurucé. ");
INSERT INTO priNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Wà tèpa coda, âna rà popa còobé wà Iésu, naa na gòroigé, kâra ê wâ maina kà kupénoo. Â rà todàra diri ê wâra coda. ");
INSERT INTO priNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Â rà tòpwùtù ârabwée kêe, â rà naagée naa gooé jè ârabwée mii pwacèwii ârabwée kà pwi âboro imaina ba na rà piècaarié. ");
INSERT INTO priNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Â rà pàti ê pé bwe korona kêe, goro îri upwâra na pwa daaé, â rà tòpò boo naa gòro pûruê. Â rà naa naa na îê étò ê jè bàra watü pwacèwii ê tâjò kà pwi ukai. Â rà tùu jùrurà araé, â rà ina têe pâ: «Cidòri nyuâagà, co ‘Pwi Ukai kà tèpa Juif’!» ");
INSERT INTO priNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Â rà nye tà èdurié, â rà popa i bàra watü, â rà nye tà pâdi ê pûruê goo. ");
INSERT INTO priNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Ûna nabwé ê pai piècaarié kàra, â rà tòpwùtù gée gooé i ârabwée mii, â rà nye naagée côwâ naa gooé ê ârabwée kêe. Géewê, â rà popaé còobé naa gòroigé, ba na rà tanamiriê naa goro kurucé. ");
INSERT INTO priNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Ûna rà gére còobé gée na ville, â ipitirà ma pwi âboro gée na ville Cyrène, na nee Simona. Â rà tacoo gooé, ba na é kâa i kurucé kà Iésu. ");
INSERT INTO priNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Â rà tèepaa naa na jè ti kâra jaa na ina goo wê pâ Golgota, âna pai ina wèe pâ ‘Goro pwiripûru âboro’. ");
INSERT INTO priNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Â wà pàra tàpé, âna rà pinaanaimari ê dipâa bau ê jawé na maga. Â rà naa tà Iésu, â é tàpo nari, êco na nye tàutêe goo. ");
INSERT INTO priNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Nabwé, â rà tanamiriê naa goro i kurucé wà tèpa coda. Â rà pwa ma ipâdi naa goorà ê pâ ârabwée kêe. Â rà picàù noo kâra tii, ma rà o tâmogòori pâ o wàilàapà na o popa {i ârabwée gòri kêe}. ");
INSERT INTO priNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Â rà tâaboo, ba na rà wéaarié. ");
INSERT INTO priNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Rà wii naa goro jè ére upwâra, ê auwii na wàéni: iésu, pwi ukai kà tèpa juif. Wàé kaa pwiri ê majoro ê pai bà kêe. Â rà ténamiri dòiti kâra pûruê. ");
INSERT INTO priNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Â rà tanamiri mwara tupédu a pwa na èpà naa goro jènere wà Iésu—wà pwi jèpwi naa gòro étò kêe; â wà pwi jèpwi naa gòro aèmwü kêe. ");
INSERT INTO priNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Wà tàpé na rà paé ma me na ére bèepwiri, âna rà côo Iésu, â rà ura ê pûrurà. ");
INSERT INTO priNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Â rà tànyiriê, â rà ina pâ: «Gona càcaa wâgà kaa, na gà o tédidiri i Wâra pwapwicîri, ma pagòtù côwâ naa na âracié tòotù? Â wâdé, ba wiàna gà *Pwina naî Pwiduée, â gà pa-udògà côwâ, ma gà boome gée goro i kurucé bèepwiri!» ");
INSERT INTO priNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Â wà mwara, tèpa caa kà tèpa pwa ârapwaailò, ma wà tèpa *dotée goro ê Naèà, ma wà tèpa pitûâ, âna rà pitaurèe goo Iésu mwara. Â rà ina pâ: ");
INSERT INTO priNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","«É pi-ina gooé pâ é pwi Mesia Pwi Ukai kâjè tèpa Isaraéla. Â é tâmogòori ma é pa-udò pàra tàpé, êco na câé caa tâmogòori ma é ipa-udòé côwâ! Wiàna é boo gée goro kurucé bèepwiri, â pwiri jè o mwa cèikî naa gooé! ");
INSERT INTO priNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","«É cèikî naa goo Pwiduée, â é ina pâ é Pwina naîê. Â wiàna nüma wà Pwiduée, â wâdé na é pa-udòé ni!» ");
INSERT INTO priNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Â nye ipaiwà mwara naa goo tupédu a pwa na èpà na tanamiriru naa goro jènere Iésu. Ba ru nye pitaurèe gooé mwara. ");
INSERT INTO priNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Ûna po gopaé bwàti, â nye po bàutê pitiri ê napô, tiagoro na âracié ineretòotù na càùru ija. ");
INSERT INTO priNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Ûna po âracié ineretòotù, â é tomara ba maina wà Iésu pâ: Éli, Éli, lama sabakthani? Pai ina wèe pâ: Pwiduée kôo, Pwiduée kôo, cina gà panuâô? ");
INSERT INTO priNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Â càra caa têreê bwàti wà pàra tàpé, â rà ina pâ: «Gà côo, é todà péroféta *Élia!» ");
INSERT INTO priNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Â é nye itàtà kaa pwi jè ârapàararà, â é popa jè imwaano, â é nuwa naa na ê dipâa na maga. Â é tòpò naa goro bàra upwâra, â é naa tà Iésu, ba na é wâdo. ");
INSERT INTO priNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Â rà ina têe wà pàra tàpé pâ: «Tàpo tâa, co pwini, ba pwiri jè o côo wà *Élia, na é me, nau pa-udòé!» ");
INSERT INTO priNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Êco na é uu mwara wà Iésu, â nye êgò kaa ôomaa kêe. ");
INSERT INTO priNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Â ê pé ciità maina, na é târiwâri ê ére na dau pwicîri naa na i Wâra pwapwicîri, âna nye tidàpa kaa, tapoo géenidò, tia niboo pwâadèreè. Â é gù ê napuu, â mabiti pâ atü. ");
INSERT INTO priNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Â nye cikòmaa kaa pâ auipwàni, â rà wâro côwâ gée na aubà, jè auwâru goo tèpa âboro kà Pwiduée. ");
INSERT INTO priNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","(Â, na pàara na é wâro côwâ Iésu gée na aubà, âna rà còobé gée na auipwàni. Â rà tò naa *Iérusaléma, pwi ville pwicîri, â rà ipaarirà târa pâ âboro. Â wâru tàpé na rà côorà.) ");
INSERT INTO priNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Wà tèpa coda roma na rà wéaari Iésu, bau pwi caa kàra, âna rà pò goro ê pai gù wàra i napuu, ma êdiri pâ pwina tèepaa. Â nye dau maina kaa ê pai wâgotàra, â rà ina pâ: «Âjupâra, wà pwi âboro bèeni, âna é Pwina naî Pwiduée!» ");
INSERT INTO priNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","56","Pwa pàra ilàri, na rà tà coo iti, â rà côo diri pwiri—wà Maria gée Magdala ma wà Maria, nyaa kà Jacques ma José, ma wà nyaa kà tupédu naî Zébédée. Â wâru mwara pa ilàri, na rà jèe pâra wiâê, gée napô Galilée, ba na rà o piâboro kîri kêe, âna rà tâa wê mwara. ");
INSERT INTO priNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Na bàrane, âna é tèepaa me pwi jè âboro na nee Ioséfa, wà pwi âboro gée na village Arimathée, na dau pwa neemuruê. Wàé mwara, âna é pwi âboro na é mu pâra wiâ Iésu. ");
INSERT INTO priNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Â é pâra naa jaa ukai Pilato, â é ilari i naii Iésu. Â wà Pilato, âna é ina tà tèpa coda pâ, na rà naa têe. ");
INSERT INTO priNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Â wà Ioséfa, âna é popa i naii Iésu. Â é cajipié goro jè ciità, na bwaa bwùu. ");
INSERT INTO priNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Â é popaé pâ, â é tòpòé naa na ê auipwàni na bwaa âmuê, pé pwêe na îri naa na pé atü, ba nye kêe, wàé Ioséfa. Â é pwùru ê jè pé atü maina, nau târiwâri i auipwàni. Â nabwé, â é pâra. ");
INSERT INTO priNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Napwa naa goo wà Maria gée Magdala ma wà tô jè Maria, âna ru tàgére tâaboo naawê, na ara i auipwàni. ");
INSERT INTO priNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Diri ê pâ pwi bèepwiri, âna pwa na papwicî, tòotù béaari ê *tòotù pwicîri kà tèpa Juif. Na papwicî, â rà mu pwabwàti ê pi-ija kâra tòotù pwicîri. Â, na dàuru kêe, na capàto, tòotù pwicîri, âna wà tèpa caa kà tèpa pwa ârapwaailò ma wà tèpa *Farasaio, âna rà ipitiri naa jaa Pilato. ");
INSERT INTO priNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Â rà ina têe pâ: «Gà côo, co pwi ukai, wà i pwi a pa-imwüru tèpa âboro bèepwiri, wà Iésu, âna é ina béaari ê pai bà kêe, pâ: “Naa na béâracié kâra tòotù gée na càùru pai bà kôo, âna go o mwa wâro côwâ gée na aubà.” ");
INSERT INTO priNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","«Â wâdé na gà ina tà tèpa coda pâ, na rà wéaari bwàti i auipwàni naa na âracié tòotù. Ba rà péa mura i naiié wà tèpa *câmu kêe, ma inapàpari pâ, é jèe wâro côwâ gée na aubà! Â wiàna wàrapwiri, â ê pwi jèkutâ pwâ bèepwiri, âna o dau maina, jii ê pwina pâbéaa!» ");
INSERT INTO priNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Â é ina tàra wà Pilato pâ: «Wâdé. Wàilà-ni pàra tèpa coda. Wiàna nümawà, â guwà nama rà wéaari i auipwàni!» ");
INSERT INTO priNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Â rà pâra, â rà pwabwàti ê pai wéaari ê auipwàni. Â rà pugabia bwàti i atü opumoori i auipwàni. Â rà tòpò tèpa coda, ba na rà tà wéaari. ");
INSERT INTO priNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Jèe nabwé ê *tòotù pwicîri kà tèpa *Juif. Â, na pwapwicîri, na bwaa po dàuru, béaari ê pai êgòdò kâra i tòotù, â wà Maria gée Magdala, ma wà tô jè Maria, âna ru pâra naa na auipwàni. ");
INSERT INTO priNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Ûna gére wàrapwiri, â é nye gù kaa i napuu. Ba é tàbàtù gée napwéretòotù jè *angela kà Pwi Ukai, â é pwùru i atü opumoori wàra i pwêe, â é tâaboo naa gò. ");
INSERT INTO priNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Âna é pwâra pwacèwii âra, â napwa ârabwée kêe, âna po jajau. ");
INSERT INTO priNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Â uru nyuâa wà tèpa coda na rà wéaari auipwàni, â rà nye tûuboo kaa naa napuu, pwacèwii tèpa bà. Â rà céca goro pai wâgotàra. ");
INSERT INTO priNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Â wà i pwi angela, âna é ina târa i du ilàri pâ: «Du èpo, gàu cibwaa nama wâgotàu. Ba go tâmogòori pâ gàu mudà Iésu, wà pwi ia tanamiriê naa goro *kurucé. ");
INSERT INTO priNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Gàu têre, jèe tiàué ni! Ba é jèe wâro côwâ gée na aubà, wàra na ia é jèe nye ina. Gàu me nau côo ê ére, na ia tòpòé naawê. ");
INSERT INTO priNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Â gàu nama wàcî nau ina tà tèpa *câmu kêe pâ: “É jèe wâro côwâ gée na aubà wà Iésu, â é tà tapacîwà wâ Galilée. Â guwà mwa côoê naawê.” Â wàépwiri na go ina tàu.» ");
INSERT INTO priNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Â ru nye nama wâjué wài gée na auipwàni. Tàpo wâgotàru, êco na ru dau ipwàdée mwara. Â ru itàa nau ina jèkutâ na bwaa âmuê tà tèpa câmu kà Iésu. ");
INSERT INTO priNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Â wii naigé, â ru pò goo Iésu na ipitirà ma wàé. Â é ina tàru pâ: «Bwàcu kàu!» Â ru gée paé, â ru tâaboo naa goro âê, ma ipwamainaê. ");
INSERT INTO priNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Â é ina tàru pâ: «Gàu cibwaa nama wâgotàu. Â gàu pâ nau ina tà tèpa béeò pâ rà pâra naa Galilée, ba rà o mwa côoô naawê.» ");
INSERT INTO priNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Na pàara na ru gére pâra wii naigé i du ilàri, â rà itàa naa na ville wà pàra tèpa coda na ia rà piwéaari i auipwàni. Â rà pâdari tèpa caa kà tèpa pwa *ârapwaailò, â rà piwiâ tàra diri pâ pwina tèepaa. ");
INSERT INTO priNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Â wà tàpéebà, âna rà todà diri tèpa béerà, ma wà tèpa pitûâ. Â rà ipitiri, ba na rà pitùra goro ê jèkutâ bèepwiri. Â rà niimiri naima pâ, na rà naa jè mwani na dau maina, tà tèpa coda, ma ina tàra pâ rà pwâ, goro ê pwina tèepaa. ");
INSERT INTO priNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Â rà ina tàra pâ: «Guwà o ina pâ, wà tèpa câmu kà Iésu, âna rà mura i naiié, na pàara na guwà tà puu. ");
INSERT INTO priNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Â wiàna é têre pwiri wà kupénoo, pwi ukai kàwà, â wàibà na bà mwa patùraé bwàti, ba na o câé caa putàmu naa goowà.» ");
INSERT INTO priNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Â rà popa i mwani wà tèpa coda, â rà pwa pwina rà ina tàra. Â wàépwiri na é pâpitiri ê jèkutâ-bà. Â rà bwaa piwiâ wà tèpa Juif, tiagoo nabàni. ");
INSERT INTO priNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Rà pâra naa napô Galilée wà tèpa 11 a câmu kà Iésu. Â rà pâra naa gòro ê jaa na ia é ina tàra Iésu pâ, na rà mwa pâra naawê. ");
INSERT INTO priNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Â é tèepaa marirà Iésu, â rà ipwamainaê. Êco na, napwa pàra tàpé, âna rà piwâ na rà cèikî pâ wàé. ");
INSERT INTO priNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Â é gée paé dàra wà Iésu, â é ina tàra pâ: «Wà Pwiduée, âna é naa tôo diri ê pàtàmee, wânidò napwéretòotù ma wâni gòropuu. ");
INSERT INTO priNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Êkaa na go ina tàwà pâ: Guwà pâra pitiri ê gòropuu. Â guwà pwa ma rà cèikî naa gooò ma pâra wiâô. Â guwà *upwaarà naa goro nee Caa, ma Pwina naîê, ma ê Nyuâaê Pwicîri. ");
INSERT INTO priNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Â guwà pacâmurirà ma rà pitêre dàra diri pâ pitûâ na go jèe naa tàwà. Â go tà wâjaawà, diri na pâ tòotù, tiagoro pwâadàra gòropuu.»");
INSERT INTO priNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Tapoo naani ê *Picémara Wâdé goo Iésu *Kériso, *Pwina naî Pwiduée. ");
INSERT INTO priNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Ba jèe wii naa na tii kà *péroféta Isaia ê popai bèeni kà Pwiduée: Go mwa panuâ paé pwi a pa popai kôo. Ée mwa pâbéaa'gà ma pwabwàti naigé'gà. Malachie 3.1 ");
INSERT INTO priNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Pwa pwi âboro naa namaré na é tomara too: “Ée me Pwi Ukai! Pwabwàti ê naigé! Pwa ma bàracaari pwi ére na ée pâ wê!” Ésaïe 40.3 ");
INSERT INTO priNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Êkaa na wàrapwiri, na é tèepaa me wà *Ioane Pwi a piupwaa, naa namaré. Â é tomara too pâ: «Guwà pinünüma ma guwà biiwà. Â guwà pwa ma *upwaawà, ba na paari pâ pitòotéri ê wâro kàwà. Â, na wàrapwiri, â ée mwa pwanauri tàwà ê pâ èpà kàwà wà Pwiduée.» ");
INSERT INTO priNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Â rà nye tà medari Ioane diri pâ âboro gée napô *Judée ma *Iérusaléma. Â rà inapàpari ê pâ èpà kàra, naa naporomara ê pâ âboro diri. Â é upwaarà, naa nairiwâ Ioridano. ");
INSERT INTO priNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","É coona ê ârabwée, na pwa goro wàra kaamela. Â é piié goo karapuu parawére macii. Â é uti ê pâ kòrée, â é wâdo ê narapuutâ. ");
INSERT INTO priNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Â é inapàpari pâ: «Wà pwi âboro na ée mwa me pwicò kôo, âna dau pwa pàtàmee jiio. Càcaa pâriô ma go cùuo boo, ma go tipi ê otàpwe goro ê du wâraâê ba é Pwi Ukai. ");
INSERT INTO priNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Â wâgo, âna go upwaawà goro jawé, êco na wàé, âna ée mwa upwaawà goro ê *Nyuâaê Pwicîri.» ");
INSERT INTO priNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Na pàara bèepwiri, â é tèepaa me wà Iésu, gée Nazareth wâ Galilée. Â é upwaaé wà Ioane, naa nairiwâ Ioridano. ");
INSERT INTO priNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Â, na é còobé gée najawé wà Iésu, â wà Ioane, âna é côo ê napwéretòotù na tidàpa. Â é nye côo kaa ê Nyuâaê Pwicîri, na é gére boome naa gò Iésu pwacèwii ê déamu. ");
INSERT INTO priNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Â é têre ê pwâratùra na me gée napwéretòotù, na ina tà Iésu pâ: «Gà Pwina naîô na caapwi co na go dau meaarigà. Wâgà kaa âna go jèe nye pitòrigarigà, ba dau wânümoo googà.» ");
INSERT INTO priNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Gée na càùé, â é pâra wà Iésu naa namaré, ba é popaé pâ naawê ê Nyuâaê Pwicîri. ");
INSERT INTO priNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Â é tâa wê naa na ê 40 tòotù. Â é tacaié wà *Caatana. Â é tâa jaa ê pâ macii a piugà wà Iésu. Â, na pwi pàara-bà, âna rà ipwa âboro kîri kêe wà tèpa *angela. ");
INSERT INTO priNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Na jè tòotù, â rà tâjùru wà Ioane, â rà tòpòé naa na karapuu. Â é pâra wà Iésu naa napô Galilée. Â é inapàpari ê Picémara Wâdé goo Pwiduée. ");
INSERT INTO priNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Â é ina tàra pâ: «Jèe tèepaa ê pàara, na é jèe pitòrigari wà Pwiduée. Ba ê Mwaciri kêe, âna ée jèe wâmwünyabweriwà! Guwà tòotéri ê wâro kàwà, â guwà cèikî naa goo ê Picémara Wâdé kêe!» ");
INSERT INTO priNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Â é pâra wii bàrawià Galilée wà Iésu. Â é côo wà Simona Pétéru ma André, tupédu aéjii, na ru tàgére tòpò ê puà naa najawé. Ba tupédu a taa ârawéà. ");
INSERT INTO priNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Â é ina tàru wà Iésu pâ: «Gàu me wiâô! Â go o mwa pwa ma gàu tupédu a pwapuàri âboro.» ");
INSERT INTO priNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Â nye géewê kaa, â ru naaco ê puà kàru, â ru pâra wiâê. ");
INSERT INTO priNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Â rà tàpo dau paé, â wà Iésu, âna é côo Jacques ma wà pwi aéjii kêe, Ioane, tupédu naî Zébédée, na ru tàgére pwàni ê puà gòro wànga kàru. ");
INSERT INTO priNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Â é nye nama todàru kaa wà Iésu. Â ru panuâ caa kàru, naa gòro i wànga ma wà tèpa wakè kàra. Â ru pâra wiâ Iésu. ");
INSERT INTO priNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Rà tèepaa pâ wà Iésu ma wà tèpa *câmu kêe, naa na village Capernaüm. Â é tò naa na *wâra pitapitiri, na tapoo *tòotù pwicîri. Â é pacâmuri tèpa âboro goro ê popai kà Pwiduée. ");
INSERT INTO priNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Â rà pò goo ê pai tùra kêe. Ba câé caa pwaduwà kà tèpa *dotée goro ê Naèà, na rà ina ê pwina rà ina wà pàra tàpé. Ba é nye tùra gée gooé. ");
INSERT INTO priNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Nye po napwiri kaa, na é tò naa na wâra pitapitiri ê pwi âboro na pwa duée gooé. Â é wiikau burà ina pâ: ");
INSERT INTO priNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","«Ée! Iésu gée Nazareth, nye ticè cèna gà pwa jaabà! Gà me na tubaèpà tâbà? Go tàgére côoinagà, ba wâgà pwi âboro, na é pitòrigarigà wà Pwiduée, â é panuâgà me!» ");
INSERT INTO priNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Â é nye kànari kaa i pé duée, wà Iésu, ma ina têe pâ: «Gà târi pwâgà, â gà còobé gée goo pwi âboro bèepwiri!» ");
INSERT INTO priNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Â é nye ngarü pwini kaa i duée, â é còobé burà uu gée gooé. ");
INSERT INTO priNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Â nye po dàpàgà târa diri ê pâ âboro, â rà pitawèerirà jècaa, ma ina pâ: «Dà cèna é gére pwa? Wà pwi âboro bèeni, âna é pacâmurijè goo jè pai pwa na bwaa âmuê. Ba napwa ê pwina é ina, âna pwa pàtàmee. Â é pitûâ kâra mwara pâ duée, â rà pitêre dèe!» ");
INSERT INTO priNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Â nye pâra kaa ê jèkutâ goo Iésu, pitiri ê napô Galilée. ");
INSERT INTO priNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Wà Iésu, âna é còobé gée na wâra pitapitiri. Â é nye nama pâra kaa naa jaa Simona ma wà André. Â ru pâra wiâê wà Jacques ma Ioane. ");
INSERT INTO priNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Ûna rà tèepaa naawê, â rà nama ina tà Iésu wà tàpé na rà gére tâa wê, pâ, wà tô nyaa kà wâdà Simona, âna é gére puu, ba é pitòoka. ");
INSERT INTO priNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Â é medarié wà Iésu, â é tu pâ naa goro îê, â é dàgòtùé ma é tâa. Â nye tiàu kaa ê pitòoka kêe! Â é cimadò â é naa èrà. ");
INSERT INTO priNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Na bàrane, â rà popa medari Iésu diri tèpa maagé, â wà mwara tàpé na pwa duée goorà. ");
INSERT INTO priNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Â rà pitanaimarirà naa goropwârawâ wà diri tèpa âboro na pwi village-bà. ");
INSERT INTO priNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Â é nye pwa ma tiàu diri kaa ê pâ na jèpapara maagé wà Iésu. Â é tü târa mwara ê pâ duée na wâru. Êco na câé caa panuârà ma rà tùra, ba rà jèe tâmogòorié. ");
INSERT INTO priNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Na dàuru kêe, na bwaa ne, â é còobé wà Iésu. Â é pâra naa na jè ére na ticia wê. Â é pwapwicîri. ");
INSERT INTO priNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Â rà pâra nau mudèe wà Simona ma wà tèpa bée. ");
INSERT INTO priNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Â rà ina têe pâ: «Rà po mudàgà diri ê pâ âboro.» ");
INSERT INTO priNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Â é tòpi tàra wà Iésu pâ: «Guwà me, ma jè pâra géeni, naa na pàra village na tàpo wâmwünyabwerijè. Ba wâdé na go inapàpari mwara naawê ê Picémara Wâdé. Ba wàépwiri majoroé ma go boome.» ");
INSERT INTO priNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Â é pâra pitiri wâ Galilée, â é picémara ê Picémara Wâdé, naa na pâ wâra pitapitiri. Â é tü târa ê pâ duée. ");
INSERT INTO priNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","É me burà Iésu wà pwi jè a pwa maga. Â é tùu jùrué araé, â é ilari jiié pâ: «Au! Wiàna nye nümagà, â gà o nama tiàu maagé kôo.» ");
INSERT INTO priNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Â é dau meaarié wà Iésu. Â é tùu pâ îê, â é tu naa gooé, â é ina têe pâ: «Nümoo! Wâdé na tiàu ê maagé'gà!» ");
INSERT INTO priNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Â nye tiàu jiié kaa ê maagé kêe, â é jèe wâdé. ");
INSERT INTO priNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Â é ina ba gòo têe wà Iésu pâ: «Gà pâra, ");
INSERT INTO priNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","â gà pwacôoco, â gà cibwaa pwa jèkutâri! Êco na gà pâra nau ipaarigà tà pwi a pwa ârapwaailò, â gà naa tà Pwiduée i pwi *ârapwaailò na ia é ina wà *Moosé naa na *Naèà kêe. Ba na wàrapwiri, â rà o côo diri wà tèpa âboro pâ gà jèe wâdé.» ");
INSERT INTO priNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Â é pâra i pwi âboro, êco na câé caa pwa i pwi ia é ina têe wà Iésu. Ba é piwiâ târa diri ê pâ âboro ê pwina tèepaa mariê. Â wàépwiri ê pwi majoroé ma câé caa pipaarié wà Iésu, naa na pâ village. Â é tâa na pâ ére na aupiticia. Â rà nye tà me mariê naawê ê pâ âboro gée na diri ê pâ ére. ");
INSERT INTO priNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Gée na càùru ê pàra tòotù, â é wâjué me côwâ naa na village Capernaüm wà Iésu. Â rà têre pâ é wâ pwârawâ. ");
INSERT INTO priNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Â wâru pâ âboro na ipitirà naawê, â jèe ticè autâa kàra, tia goropwârawâ. Â é inapàpari tàra ê popai kà Pwiduée. ");
INSERT INTO priNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Â rà tèepaa me ê pàra âboro, na rà popa me ê pwi âboro na é pitàbwamwa. Ârapàpé tàpé gée goorà, na rà pitûriê me. ");
INSERT INTO priNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Êco na ticè pai pwa wèe ma rà tòpòé na ara Iésu, majoroé ê pai wâru wàra ê âboro. Â rà tàmee too naa gòrowâ, â rà dàgòtù ê jè ére gòrowâ, wâcicima wâna na é tâa wê wà Iésu. Â rà panuâ boo wà i pwi a pitàbwamwa, na é puu gòro ê aupuu kêe. ");
INSERT INTO priNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Â é pò goo ê cèikî kà tèpa âboro bèepwiri, wà Iésu, â é ina tà pwi a pitàbwamwa pâ: «Pwina naîô, jèe pwanauri ê pâ èpà'gà.» ");
INSERT INTO priNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Rà tâa wê mwara ê pàra tèpa *dotée goro ê Naèà, â rà niimiri pâ, ");
INSERT INTO priNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","‘Kaa! É tùra ba èpà naa goo Pwiduée wà pwi âboro bèeni ba é nama ipaiwàilu ma wàé! Wàilàapà na tâmogòori ma é pwanauri ê pâ èpà? Na nye wàco Pwiduée!’ ");
INSERT INTO priNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Êco na é nye tâmogòori kaa ê pwina rà niimiri wà Iésu, â é ina tàra pâ: «Gorodà na wàrapwiri ê pâ pwâranümawà? ");
INSERT INTO priNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Piticècoé na go ina têe pâ: “Jèe pwanauri ê pâ èpà'gà” jii na go ina têe pâ: “Cimadò, â gà pa ê aupuu'gà, â gà pâra.” ");
INSERT INTO priNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Â wiàna pâri ma go nama é pâra na arawà diri â guwà mwa tâmogòori pâ, pwa tàrù kà *Pwina naîri âboro, ma é pwanauri ê pâ èpà kà tèpa âboro naani gòropuu.» Â é ina tà pwi a pitàbwamwa pâ: ");
INSERT INTO priNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","«Go ina tâgà ni pâ: Gà cimadò, â gà popa ê aupuu'gà, â gà pâra naa jaagà.» ");
INSERT INTO priNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Â é nye cimadò kaa naa nabibiu kâra i pâ âboro, â é nye popa kaa ê aupuu kêe, â é còobé. Â rà pò wà tèpa âboro, â rà ina pâ: «Ée! Câjè caa mu caa côo cè muru cèna wàrani!» Â rà pwamaina Pwiduée. ");
INSERT INTO priNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","É wâjué côwâ naa bàrawià Galilée wà Iésu. Â wâru ê pâ âboro na rà picàù wiârà medarié. Â é pacâmurirà goro ê Popai. ");
INSERT INTO priNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Ûna é pâra wii naigé, â é côo wà Lévi, pwina naî Alphée, na é gére tâa na ê wâra *tò mwani wâripû. Â é ina têe wà Iésu pâ: «Gà me wiâô!» Â é pò ma cimadò wà Lévi, â é pâra wiâê. ");
INSERT INTO priNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Gée na càùé, â rà pi-ija wà Iésu ma wà tèpa *câmu kêe naa jaa Lévi. Â wâru pâ âboro na rà pi-ija naima ma wàilà—wà tèpa tò mwani, ma wà pàra tàpé na èpà wâro kàra. Ba jèe pâ nau wâru âboro, na rà pâra wiâê. ");
INSERT INTO priNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Rà tâa wê mwara wà pàra tèpa dotée goro ê Naèà, gée goo tèpa *Farasaio. Â rà côo pâ rà pi-ija naima wà Iésu, ma wà diri tèpa âboro bèepwiri. Â rà ina tà tèpa câmu kêe pâ: «Gorodà na wà pwi caa kàwà, âna rà picaaija ma pibéerà ma tàpé na èpà ê wâro kàra, ma wà tèpa tò mwani?» ");
INSERT INTO priNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Â é têre wà Iésu, â é ina tàra pâ: «Càra caa bu dotée wà tàpé na rà wâdé. Â nye wàco tàpé na rà maagé. Câgo caa me, nau todà tàpé na rà tà niimiri pâ wâdé ê wâro kàra. Bwa! Go me nau todà tàpé na rà tà tâmogòori pâ èpà ê wâro kàra.» ");
INSERT INTO priNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Na jè tòotù, â wà tèpa câmu kà *Ioane Pwi a piupwaa ma wà tèpa Farasaio, âna rà gére pipwanya. Rà panuâ ê ija na jè ji pàara, ba na rà pwapwicîri tà Pwiduée. Â rà medari Iésu wà tèpa âboro, â rà ina têe pâ: «Rà tàgére pipwanya wà tèpa câmu kà Ioane, ma wà tèpa câmu kà tèpa Farasaio. Â gorodà na càra caa pipwanya wà tèpa câmu'gà?» ");
INSERT INTO priNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Â é tòpi tàra pâ: «Gona rà o pipwanya, wà tàpé na jè todàra naa goro ê piéa, na é bwaa tâa jaarà wà pwi a piéa? Bwa! Rà pi-ija ma wâdo. ");
INSERT INTO priNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Êco na o mwa me ê tòotù na ée mwa pâra jiirà wà pwi a piéa. Â géewê, â rà o mwa bàra pipwanya. ");
INSERT INTO priNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","«Â nye ticè jè âboro, cèna é popa ê jè noo kâra imwaano na bwaa bwùu, ma é taiti naa goro ê pwina jèe dòroé. Ba wiàna é nuwa i imwaano, â o dàdàpa ê gòobàra ê imwaano na jèe dòroé. Â o mwa dau maina kaa ê aumadàpa goo. ");
INSERT INTO priNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","«Guwà côo ê *wâra jawé na pwa goro parawére macii: Câjè caa popa ê dipâa na bwaa âmuê, ma jè upwâwii ê wâra jawé na jèe dòroé. Ba o taaò i wâra jawé ba pwacoé ma é tèe. Â o tubatiàu i dipâa bau i wâra jawé. Bwa! Wâdé na jè tòpò ê dipâa na bwaa âmuê, naa na ê wâra jawé na bwaa bwùu!» ");
INSERT INTO priNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Na jè *tòotù pwicîri, â rà pâra wii ê naigé na tapàgà na aupwanapô wà Iésu ma wà tèpa câmu kêe. Â wii naigé, â rà tàpo pétâ pâ pwâra blé wà tèpa câmu. ");
INSERT INTO priNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Â rà ina tà Iésu wà pàra tèpa Farasaio pâ: «Pwiini, gona cina rà pwa na wàrapwiri wà tèpa câmu'gà? Âna muru na papwicîri, na ê tòotù pwicîri!» ");
INSERT INTO priNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","26","Â é tòpi tàra pâ: «Gona bwaa câguwà caa pûra naa na tii ê pwina é pwa wà pwi ukai *Davita, na pàara kà Abiatar, pwi caa kà tèpa pwa *ârapwaailò? Ba, na jè tòotù, â rà copwa, wàilà ma wà tèpa bée, â nye ticè cèna rà uti. Â é tò naa na i wâra pwapwicîri pwa goro imwaano. Â é pa ê poloa, na naa tà Pwiduée, â é ija. Â é pa, â é nama rà ija mwara wà tèpa bée. Êco na ê poloa-bà, âna wàco wà tèpa pwa ârapwaailò, na pwa tàrù kàra ma rà ija.» ");
INSERT INTO priNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Â é ina mwara wà Iésu pâ: «É tòpò ê tòotù pwicîri wà Pwiduée, ba wàrapwiri goo wà pwi âboro. Â câé caa tòpò wà pwi âboro, ba na kâra ê tòotù pwicîri! ");
INSERT INTO priNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","«Â wàépwiri ê majoroé ma wà Pwina naîri âboro, âna é pwi apooro ê tòotù pwicîri mwara.» ");
INSERT INTO priNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Gée na càùé, â é wâjué côwâ naa na *wâra pitapitiri wà Iésu. É tâa wê mwara wà pwi âboro na bà ê îê. ");
INSERT INTO priNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Â wà tàpé na rà tâa wê, âna rà côo bwàti wà Iésu pâ, pwiri é pwa ma é wâdé côwâ wà pwi âboro bèepwiri, na *tòotù pwicîri? Ba rà mudàra cè pai pwa wèe, ba na rà o mwa pitòtié. ");
INSERT INTO priNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Â é ina wà Iésu tà pwina bà i îê pâ: «Gà me naani.» ");
INSERT INTO priNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Â é ina tà tàpé na rà tâa wê pâ: «Wànau? Pwa tàrù kâjè na tòotù pwicîri, ma jè pwa na wâdé, é, ma jè pwa pwina èpà? Wâdé na jè pawâro pwi âboro, é, wâdé na jè panuâê ma é bà?» Êco na càra caa tòpi têe. ");
INSERT INTO priNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Â é po niârirà burà putàmu wà Iésu. É pikîri, ba bwaa dau gòo pûrurà. Â é ina tà pwi âboro bèeni pâ: «Gà patàrù ê îgà.» Â é patàrù i îê, â é nye wâdé kaa. ");
INSERT INTO priNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Â rà còobé gée na wâra pitapitiri wà tèpa *Farasaio. Â rà nye pitùra kaa ma tèpa âboro gée na ére kà *Héroda Antipas. Càra caa mu pitêrerà béaa, êco na rà pimudàra naima cè pai pwa wèe ba na rà pòtàmwara Iésu. ");
INSERT INTO priNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Rà pâra jiirà wà Iésu ma wà tèpa *câmu kêe, dàra bàrawià Galilée. Â wâru ê pâ âboro na rà pâra wiârà—âboro me gée pâ napô Galilée, ma *Judée, ");
INSERT INTO priNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","ma Idumée. Â rà me mwara gée *Iérusaléma, ma gée na ére gée côwâ kâra nairiwâ Ioridano, ma gée na ére wâgoro jènere du ville Tyr ma Sidon. Ba rà pitêre ê jèkutâ goro ê pâ muru na é pwa wà Iésu, â nümarà na rà côoê. ");
INSERT INTO priNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Â é ina tà tèpa câmu kêe wà Iésu pâ: «Guwà pwabwàti ê jè nari wànga, ba na o càra caa igabiao ê pâ âboro bèeni.» ");
INSERT INTO priNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Ba rà gére itàa me dèe wà diri tèpa maagé, ba na rà tu naa gooé, ma rà o wâdé. Ba rà têre pâ é jèe pawâro ê pâ âboro na wâru. ");
INSERT INTO priNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Â, na rà côoê ê pâ duée na tâa goo tèpa âboro â rà tûuboo, â rà tùu jùrurà béaa kêe, â rà tomara too pâ: «Gà *Pwina naî Pwiduée!» ");
INSERT INTO priNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Â é tûâri tàra wà Iésu pâ: «Guwà cibwaa inapàpario!» ");
INSERT INTO priNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Gée na càùé, â wà Iésu, âna é too naa gòrojaa. Â é todà tèpa âboro na nümee goorà, â rà medarié. ");
INSERT INTO priNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Â é mwa pitòrigari gée jaarà tèpa 12 âboro, ba na o tèpa bée {â é nama neerà pâ *apostolo}. Â é panuârà, ba na rà picémara ê *Mwaciri kà Pwiduée. ");
INSERT INTO priNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Â é naa tàra ê tàrù ma pàtàmee, ba na rà tü târa ê pâ duée. ");
INSERT INTO priNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Wàilà-ni tèpa 12 apostolo: Simona (é pitunee têe wà Iésu pâ Pétéru); ");
INSERT INTO priNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Jacques, pwina naî Zébédée; Ioane, pwi aéjii kà Jacques (é pitunee tà tupédu aéjii-bà pâ Boanergès, na pai ina wèe pâ ‘Tupédu a tòoka’); ");
INSERT INTO priNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","André; Filipo; Barthélemy; Mataio; Toma; Jacques, pwina naî Alphée; Thaddée; Simona, pwi Zélote; ");
INSERT INTO priNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Judas Iscariote, wà pwina ée mwa ipwa tûâ tà Iésu. ");
INSERT INTO priNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","É wâjué côwâ naa pwârawâ wà Iésu. Â wâru ê pâ âboro na rà pitànaima mwara naawê. Â ticè pai pwa wèe ma rà ija wà Iésu ma wà tèpa apostolo kêe. ");
INSERT INTO priNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Â wà tèpa âboro gée na tâa kà Iésu, âna rà me nau popaé jiirà, ba rà niimiri pâ é jèe piwârau. ");
INSERT INTO priNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Pwa tèpa *dotée goro ê Naèà, na rà boo gée Iérusaléma. Â rà ina pâ: «É wâgoo wà Iésu wà Caatana, pwi caa kà tèpa duée. Ba wàé kaa, na é naa têe ê pàtàmee, ba na é tü târa ê pâ duée.» ");
INSERT INTO priNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Â é todàra wà Iésu, â é tawèerirà pâ: «Gona é wànau târa cè pai pitü têe côwâ wà Caatana?» Â é ina tàra ê pâ ucina bèeni: ");
INSERT INTO priNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","«Wiàna é pipaa dèe côwâ ê jè mwaciri, â o pwacoé ma é cimwü. ");
INSERT INTO priNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Â wiàna é picicaraé côwâ ê caapwi tâa, â o càcaa cimwü. ");
INSERT INTO priNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Â wiàna é pipaa dèe côwâ wà Caatana, é, wiàna câé caa pitêre dèe côwâ, â o jèe nye càcaa gòiri pâ ê pàtàmee. Â jèe nye êkaa ê pai pitubatiàué. ");
INSERT INTO priNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Â wiàna nümajè na jè too gòro gòori naa na ê wâ kà pwi jè âboro na é gòo, ma jè popa ê pâ neemuruê, â wâdé na jè mara piié. Â géewê, â jè mwa bàra pa ê pâ neemuruê na tâa na wâ kêe. ");
INSERT INTO priNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","«Guwà têre bwàti, ba go ina tàwà ê âjupâra pâ: O pâri ma pwanauri pwi âboro na é pwa na èpà, â wâpà, wiàna é piècaari Pwiduée. ");
INSERT INTO priNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Êco na wà pwina é tùra ba èpà naa goo ê Nyuâaê Pwicîri, âna o càcaa pwanauri. Ba o jèe nye tà tâa dàra gòiri awé.» ");
INSERT INTO priNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","É ina pwiri wà Iésu, ba kà tèpa dotée goro ê Naèà. Ba rà ina pâ pwa duée gooé. ");
INSERT INTO priNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Gée na càùé, â rà tèepaa me wà nyaa kà Iésu, ma wà tèpa jiié. Â rà tâa boo naa pé gòroigé. Â rà panuâ dò pwi jè âboro naa na i wâ, ba na é todèe. ");
INSERT INTO priNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Wâru ê pâ âboro na rà tâbèepi Iésu, naa na i wâ â rà ina pâ: «Gà côo, rà wâboo gòroigé wà nyaa'gà ma wà tèpa aéjii'gà. Â rà mudàgà.» ");
INSERT INTO priNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Â é tòpi tàra pâ: «Wàilàapà nyaa kôo? Ma wàilàapà cè tèpa aéjii kôo?» ");
INSERT INTO priNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Â é po niâri tèpa âboro na rà gére tâbèepié, â é ina tàra pâ: «Guwà côo, wàilà-ni wà nyaa kôo, ma wà tèpa aéjii kôo. ");
INSERT INTO priNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Ba wà pwina é pwa ê câbawâdé kà Pwiduée, âna wàé kaa pwiri, ê pwi aéjii kôo, ma tô naigé kôo, ma nyaa kôo.» ");
INSERT INTO priNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","É jèu pacâmurirà mwara goro ê Popai wà Iésu, na bàrawià Galilée. Â dau wâru ê pâ âboro na rà medarié. Â gée goo pwiri, â é tò naa gòro ê jè wànga na tâa niboo najawé, â é tâaboo, ba na é patùrarà. Â rà tâa nidò gòromwari ê pâ âboro. ");
INSERT INTO priNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Â é pwa ucina ma é pacâmurirà goro ê pâ muru na wâru. Â é ina tàra pâ: ");
INSERT INTO priNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","«Guwà têre! É mwa tâa wà pwi jè âboro. É mwa pâra naa na aupwanapô kêe, â é uri ê arapwüru. Â é uri, â é uri, â é uri… ");
INSERT INTO priNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Â napwa ê pàra arapwüru, âna rà tûu naa gòro nyi nari naigé na aupwanapô. Â rà me pâ marü, â rà uti diri. ");
INSERT INTO priNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","«Â napwa ê pàra pwi, âna rà tûu naa gòrotàrarà. Â rà pò ma cipu, ba càcaa wâru puu wê. ");
INSERT INTO priNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Êco na, na é té ê tòotù, â tòo ê pâ nari arapwüru, â rà marü, ba ticè wàawà kàra. ");
INSERT INTO priNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","«Â napwa ê pàra pwi, âna rà tûu naa nabibiu kâra pâ nari upwâra na pwa daarà. Â, na rà cipu i pâ nari upwâra bèepwiri, â rà câtàmwara i arapwüru, â nye ticè pwêe. ");
INSERT INTO priNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","«Â napwa ê pàra pwi, âna rà tûu naa na napuu na wâdé. Â rà cipu, â rà imaina too, â rà tòpò pwârà—pàra pwi, âna rà tòpò 30 pwêe; pàra tàpé, na 60; â pàra tàpé mwara, âna rà too tiagoro 100.» ");
INSERT INTO priNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Â é ina mwara wà Iésu pâ: «Wà pwina pwa pwâranyüruê, âna wâdé na é têre!» ");
INSERT INTO priNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Ûna rà jèe tà tâa acari wà Iésu, ma wà tèpa 12 *apostolo kêe, ma wà tèpa béerà, â rà tawèerié pâ: «Gorodà na gà ina ê pâ ucina bèepwiri?» ");
INSERT INTO priNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Â é tòpi tàra pâ: «Wà Pwiduée, âna é paari tàwà ê âji pai pwa goo ê Mwaciri kêe. Â napwa diri ê pàra âboro, âna rà nye po têre co ê pâ ucina. ");
INSERT INTO priNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Ba: Rà côo taaci, â càra caa côoina. Rà têre taaci, â càra caa têreina. Ba péa rà biirà; péa tà pwanauri pâ èpà na rà pwa.» Ésaïe 6.9–10 ");
INSERT INTO priNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Gée na càùé, â é ina tà tàpé na rà tâa wê, wà Iésu, pâ: «Gona câguwà caa tâmogòori ê ucina goo pwi a picâmi? Â guwà o mwa wànau târa cè pai tâmogòori wàra êdiri pàra ucina goro ê Mwaciri? ");
INSERT INTO priNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Wà pwi a picâmi, âna é câmi ê Popai kà Pwiduée. ");
INSERT INTO priNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Â ê pàra arapwüru, âna rà tûu naa gòro naigé. Ê naigé, âna wà tèpa âboro, na rà têre ê popai, êco na é nye nama tèepaa me côwâ wà *Caatana. Â é pò ma dàgòtù côwâ ê popai, na jèe câmi naa na ê pwâranümarà. ");
INSERT INTO priNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","«Â ê pàra arapwüru, âna rà tûu naa gòrotàrarà. Ê gòrotàrarà, âna wà tèpa âboro na rà têre ê popai, â rà nye nama tòpi naa na ipwàdée. ");
INSERT INTO priNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Êco na rà tèpa còmacò, â càcaa wàawà naa goorà ê popai na rà têre. Ûna tèepaa me marirà ê tacai, é ûna pwa na èpà tàra, majoroé ê pai pitêre dàra kàra ê popai kà Pwiduée, â rà nama panuâ cèikî. ");
INSERT INTO priNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","«Â ê pàra arapwüru, âna rà tûu naa na ê pâ na nari upwâra na pwa daarà. Ê napuu bèepwiri, âna wà tèpa âboro, na rà têre ê popai, ");
INSERT INTO priNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","êco na rà pidumapiê goro ê pâ muru na tèepaa naa na gòropuu bèeni. Â rà itàa burà ê pâ neemuru gòropuu—muru na càcaa âji êkêe. Â wâru mwara ê pâ muru na rà wâdéari. Â câamwara ê popai naa goorà, â o câé caa tòpò cè pwêe. ");
INSERT INTO priNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","«Êco na, napwa naa goo pàra arapwüru, âna rà tûu naa na ê napuu na wâdé. Ê pwi napuu bèepwiri, âna wà tèpa âboro na rà têre ê popai, â rà tòpi naa na pwâranümarà, â pwa pwâra ê popai naa goorà—pàra pwi, âna rà tòpò 30 pwêe; pàra tàpé na 60; â pàra tàpé mwara, âna rà too tiagoro 100.» ");
INSERT INTO priNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","É ina tàra mwara wà Iésu pâ: «Câjè caa nuri ê wâra ânye, ma jè cajipi goro ê jè cio, é wâpà wiàna jè tòpò na aranara aupuu! Bwa! Jè nye tòpò dòiti. ");
INSERT INTO priNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Êdiri pâ muru na jèe naapwàniri, âna o mwa paari naa na pwéelaa. Â o pâri ma jè côo bwàti. ");
INSERT INTO priNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Wà pwina pwa ê pwâranyüruê, âna wâdé na é têre!» ");
INSERT INTO priNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Â é ina tàra mwara pâ: «Guwà pwacôoco bwàti ê pwina guwà têre, ba na pwa tàwà ê autâmogòori goo! Ba ée mwa pwa tàwà wà Pwiduée, ê pwina guwà pwa tà pàra tàpé. Â ée mwa pwa cèna piwéna jii ê pwina guwà pwa. ");
INSERT INTO priNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Ba wà pwina jèe pwa têe ê autâmogòorimuru âna o jèu âjagò têe côwâ. Â wà pwina kîri ê pwina tà têe, â o dàgòtù jiié côwâ ê ji dàramuru na tà têe.» ");
INSERT INTO priNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","É ina mwara wà Iésu pâ: «Napwa ê *Mwaciri kà Pwiduée, âna é pwacèwii ni: «É mwa tâa wà pwi jè âboro. Na jè tòotù, âna é câmi ê pâ arapwüru naa na aupwanapô kêe. ");
INSERT INTO priNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Â géewê, â é tàpo nao. Â rà cipu i pâ arapwüru, â rà pimaina too. Êco na wà pwini, âna câé caa tâmogòori cè pai cipu kàra. Ba ticè na wakè goo, ");
INSERT INTO priNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","ba nye wakè kâra ê napuu na é pacipu ê pâ arapwüru. Â é nama rà pimaina too, tiagoro na rà pâra tòpò pwêe, ma pudòé. ");
INSERT INTO priNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ûna jèe gòo i aupwanapô, â wà pwi âboro bèepwiri, âna é mwa bàra pipwabwàtié târa piûnya.» ");
INSERT INTO priNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","É ina mwara wà Iésu pâ: «Napwa ê Mwaciri kà Pwiduée, âna é pwacèwii dà? Wàéni ê pwi ucina, târa ma guwà tâmogòori: ");
INSERT INTO priNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","32","«É pwacèwii ê jè pudòro upwâra na dau kîri awé na jè câmi. Â, na é cipu, â é jèe pâ nau upwâra na dau maina awé. Â maina pâ ditèe, â pâri ma rà pwa wânaîrà naa gò ê pâ marü.» ");
INSERT INTO priNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Wâru pâ ucina na wàrapwiri na é ina wà Iésu, ba na é inapàpari târa ê pâ âboro ê popai kà Pwiduée. É pwa ê pai wiâ wèe, ma rà pa cè jèpa kàra gée goo. ");
INSERT INTO priNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","É ciburà pwa ucina tàra. Êco na, naa mwa nye tà wàilà acari ma tèpa *câmu kêe, â é mwa napéaati tàra diri. ");
INSERT INTO priNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Na pwi bàrane kâra tòotù-bà, â é ina wà Iésu tà tèpa câmu kêe pâ: «Jè gée naanigée, na ére gée côwâ.» ");
INSERT INTO priNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Â rà popaé wà tèpa câmu kêe, naa gòro i wànga na rà tâa gò. Â rà còpòo jii tèpa âboro. Êco na rà tàpo pâra wiârà wà pàra tàpé, na pâ pàra wànga. ");
INSERT INTO priNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Gée na càùé, â é tapoo uu i pwéretòotù, â jèe pimaina too ê pai uu kêe. Â jèe pimaina too wià, â jèe pwii naa na i wànga. ");
INSERT INTO priNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Êco na wà Iésu, âna é tâa boobà pwâragòro i wànga, âna é jèe puu, â é pwa pàarapû. Â rà patàcîê wà tèpa câmu kêe, â rà ina têe pâ: «Pwi a pwa pupûra, jè o jèe mwü! Wànau, càcaa âjimuru tâgà?» ");
INSERT INTO priNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Â é tàcî, â é kànari i pwéretòotù. Â é ina târa i nawià pâ: «Gà coo!» Â é nye po tànana kaa i napô. Â é coo i pòu. ");
INSERT INTO priNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Â é ina tàra pâ: «Gorodà na wâgotàwà? Gona bwaa câguwà caa pâji cèikî kaa?» ");
INSERT INTO priNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Êco na po dau wâgotàra. Â rà pi-ina tàra pâ: «Ée! Gona wàilàapà pwi âboro bèeni, na pitêre dèe ê pwéretòotù ma ê nawià?» ");
INSERT INTO priNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Rà tèepaa wà Iésu ma wà tèpa *câmu kêe, naa Gadara, wâna ére gée côwâ kâra i *nawià Galilée. ");
INSERT INTO priNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Â é boo gée gò i wànga wà Iésu. Â é nye còobé me kaa gée nacârü wà pwi jè âboro na pwa duée gooé, â é me cara Iésu. ");
INSERT INTO priNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","4","Wà pwiibà âna é pwi a pitâa nacârü. Â nye ticè pai pwa wèe ma rà tâjùrué, ma rà pwa ma pii ê du îê ma du âê; ipaiwà mwara na tòoé goro itùpaò. Ba rà nye ciburà piié goo, â é nye taaci pòpàgà kêe. Â nye ticè pwi âboro na pwa nii kêe târa cipaé ma é tàpo tâa. ");
INSERT INTO priNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Na diri ê pàara, ûna ne ma pwaa, â é mu tàmadò ê pâ pwâra wiikau, wâna i nacârü, ma gòro pâ pûru jaa. Â é mu pièié côwâ goro ê pâ atü. ");
INSERT INTO priNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","8","Ûna é côo wà Iésu gée iti, â é itàtà caraé. Â wà Iésu, âna pwa na é tü târa ê duée gée gooé. Â wà pwi âboro, âna é tùu jùrué na araé, â é tomara too pâ: «Iésu, *Pwina naî Pwiduée nidò *napwéretòotù, dà na nümagà dàra pwa tôo? Go ilagà naa na nee Pwiduée pâ, gà cibwaa pwa tôo cèna èpà.» ");
INSERT INTO priNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Â é tawèerié wà Iésu pâ: «Gona dà neegà?» Â é tòpi têe pâ: «Wâraduée.» Â rà ina pâ duée wâgooé pâ: «Üu kaa ba dau wâru wàibà!» ");
INSERT INTO priNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Â é tacoo goo wà Iésu, â é ina têe pâ: «Na gà pacòobé pâ duée bèeni gée gooò, â gà cibwaa tü tàra géeni napô!» ");
INSERT INTO priNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","12","Â wà tèpa duée mwara, âna rà tacoo gooé, â rà ina têe pâ: «Naabà pâ ma bà too naa na ê pâ puàkà bèepwiri!» Ba pwa ê pé pubu puàkà na dau maina, na rà tàgére ija géeni gopaére jaa. ");
INSERT INTO priNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Â é naa tàra ê pwina rà ilari wà Iésu. Â rà còobé, gée goo i pwi âboro, â rà gée naa goo i pâ puàkà. Â rà nye itàtà kaa i pâ puàkà, géenidò gòro i jaa, boo naaniboo nawià, â rà mwü naawê. Â rà po wâmwünyabweri 2 000. ");
INSERT INTO priNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Wà tèpa wéaari wàra i pâ puàkà, âna rà itàa pâ, nau wiâ ê jèkutâ bèepwiri, naaniboo na village, ma pitiri ê napô. Â rà me ê pâ âboro, nau côo ê pwina gére tèepaa. ");
INSERT INTO priNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Ûna rà tèepaa mwünyabweri Iésu, â rà côo i pwi âboro na ia pwa duée gooé, na é tàgére tâaboo. Â é jèe coona ê pâ ârabwée, âna é jèe po wâdé ê pai tâa kêe. Â nye po dàpàgà tàra, â dau maina ê pai wâgotàra. ");
INSERT INTO priNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Â wà tàpé na rà po côo diri ê pwina tèepaa, âna rà piwiâ tà pàra tàpé ê jèkutâ goro i pwi âboro bèepwiri, ma i pâ puàkà. ");
INSERT INTO priNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Â wà tèpa âboro gée na napô-bà âna rà tacoo goo wà Iésu, â rà ina têe pâ: «Bà ilagà pâ, na gà pâra gée na napô kâbà.» ");
INSERT INTO priNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Â é tò naa gò i wànga wà Iésu. Â wà i pwi a tâa gooé i pâ duée, âna é ilaé pâ: «Nümoo na go pâra wiâgà.» ");
INSERT INTO priNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Êco na é tòpi têe pâ: «Gà wâjué naa pwârawâ'gà naa jaa tèpa jèneregà. Â gà wiâ ê pai meaarigà kà Pwi Ukai, ma êdiri ê pâ muru na é pwa ba kâgà.» ");
INSERT INTO priNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Â é wâjué côwâ wà pwini. Â é wiâ naa na pwi ére, na ina goo wê pâ Dix Villes, ê pâ muru na é pwa ba kêe wà Iésu. Â rà po dau pò wà diri tèpa âboro. ");
INSERT INTO priNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","É tò naa gò i wànga wà Iésu, â é gée naa na ére gée côwâ. Â wâru ê pâ âboro, na rà tâbèepié na bàrawià. ");
INSERT INTO priNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Â é tèepaa me wà pwi jè âboro na nee Jaïrus, pwi jè caa kâra *wâra pitapitiri. Â é côo Iésu, â é pâra nau tùu jùrué béaa kêe. ");
INSERT INTO priNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Â é tacoo gooé, â é ina têe pâ: «Gà me wài! Ba wà tô nari èpo kôo, âna ée jèe pwa na é bà. Gà me nau tòpò ê du îgà naa gòé, ba na tiàu ê maagé kêe, ba na é wâdé côwâ.» ");
INSERT INTO priNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Â é pâra wiâê wà Iésu. Â gée goo na wâru ê pâ âboro na rà pâra mwara, â rà nye po cibèepié ma igabiarà naa gooé. ");
INSERT INTO priNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","É tâa nabibiu kà tèpa âboro bèepwiri, tô jè ilàri, na jèe po 12 naja kêe goro maagé, ba, mu tèepaa me ê pàara na mu itàa domii gooé. ");
INSERT INTO priNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Jèe po dau wâru ê pâ dotée na é pâ nau côorà, â rà mwa nye dau tubamaagée kaa. Â é jèe po tubatiàu ê mwani kêe, êco na câé caa wâdé; â é mwa nye dau èpà kaa. ");
INSERT INTO priNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","É têre ê jèkutâ goo Iésu wà tôoni. Â é mee ni, càù Iésu. Â é tu naa goo ê ârabwée kêe, ");
INSERT INTO priNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","ba é piniimiri pâ, ‘Wiàna go tu naa goo co i ârabwée kêe, â o jèe tiàu acari i maagé kôo.’ ");
INSERT INTO priNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Ûna é pwa, â nye nama coo kaa ê pai joro wàra ê domii gooé. Â é têre naa gooé pâ jèe tiàu ê maagé kêe. ");
INSERT INTO priNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Â wà Iésu, âna é têre pâ, pâra gée gooé ê jè jènere nii kêe. Â é tawèeri ê pâ âboro pâ: «Wàilàapà na tu naa goo i ârabwée kôo?» ");
INSERT INTO priNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Â rà tòpi têe wà tèpa câmu kêe pâ: «Gorodà na gà ina pwiri? Ba gà côo, po dau wâru pâ âboro ni, â rà cibèepijè, â rà cau igabiarà naa googà!» ");
INSERT INTO priNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Êco na é tà niâ bèepié wà Iésu, ba na é nye mudàra pâ wàilàapà na pwa pwiri. ");
INSERT INTO priNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Â napwa i tô ilàri, âna é céca, ba wâgotêe. Ba é tâmogòori ê pwina tàgére tèepaa têe. Â é me, â é tùu jùrué na ara Iésu, â é ina têe diri ê âjupâra. ");
INSERT INTO priNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Â é ina têe wà Iésu pâ: «Cidòri nyuâagà, co tôoni! Gà jèe wâdé côwâ goo ê cèikî'gà! Â gà pâra, â ée mwa tâa jaagà ê pinaanapô. Gà jèe piétò!» ");
INSERT INTO priNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Na é bwaa gére ina pwiri wà Iésu, â wà pàra tèpa âboro, âna rà tèepaa me, gée jaa Jaïrus—i pwi apooro i wâra pitapitiri. Â rà ina tà pwini pâ: «Au! É jèe bà i èpo'gà. Â gà cibwaa cèpo tà pi-iluuri wà pwi a pwa pupûra.» ");
INSERT INTO priNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Êco na câé caa ipacè naa goo ê pâ pwâratùra bèepwiri wà Iésu, â é ina tà Jaïrus pâ: «Gà cibwaa pwa ma wâgotâgà! Â gà cèikî!» ");
INSERT INTO priNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Nabwé, â é popa co wà Pétéru, ma wà tupédu aéjii—wà Jacques, ma wà Ioane. Ba càcaa nümee na rà pâra wiâê cè pàra âboro. ");
INSERT INTO priNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Rà tèepaa pâ naa pwârawâ kà Jaïrus. Â nye dau wâru kaa ê pâ pwâratùra wê. Â é côo wà Iésu, na rà gére i ma pijinünü. ");
INSERT INTO priNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Â é tò naa na i wâ, â é ina tàra pâ: «Cina guwà po dau wàrapwiri, ê pai pikòi kàwà? Â cina guwà i? Napwa tô nari èpo bèepwiri, âna câé caa bà, â é nye po puu.» ");
INSERT INTO priNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Â rà pitaurèe gooé. Â é cau pacòobérà diri wà Iésu, â é popa i du nyaa ma caa kâra i èpo, ma wà tèpa âracié a câmu kêe. Â rà tò naa na ê naditàrawâ, na jèe tòpò i ji nari èpo naawê. ");
INSERT INTO priNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Â é tu pâ naa goro îê, â é ina têe pâ: «Talitha, koumi» (na pai ina wèe pâ: Èpo, cimadò, ba go ina tâgà). ");
INSERT INTO priNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Â é nye cimadò kaa i ji nari èpo, â é pâra! Â rà nye dau pò kaa wà tàpé na rà tâa wê. (Napwa naa goo wà tôoni, âna jèe 12 naja kêe.) ");
INSERT INTO priNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Â é ina tàra wà Iésu pâ, na rà naa cè uti kêe. Â é pitûâri tàra pâ: «Guwà cibwaa ina târa cè âboro ê pwina guwà côo.» ");
INSERT INTO priNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","É còpòo gée na ére-bà wà Iésu, â é pâra naa Nazareth, wâna na é maina naawê. Â rà pâra wiâê wà tèpa *câmu kêe. ");
INSERT INTO priNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Â, na *tòotù pwicîri, â é tò naa na *wâra pitapitiri. Â é pacâmuri tèpa âboro na wâru goro ê popai kà Pwiduée. Â rà dau pò gooé, â rà picocoorié, ma pi-ina tàra pâ: «Gona wàilàapà na pacâmuriê goo ê pâ pwina é ina? Muru me géepà ê autâmogòori kêe? Wàilàapà na naa têe ma é pwa ê pâ wakè goro pàtàmee? ");
INSERT INTO priNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Ba wàé co pwi a wakè goro upwâra, pé pwina naî Maria, pwi cià wà Jacques, ma José, ma Jude, ma Simona! Â wà pa naigé kêe âna wàilà-ni gére wâro jaajè!» Ba rà piboo gooé wà tàpé Nazareth, â tàutàra na rà cèikî naa gooé. ");
INSERT INTO priNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Â é ina tàra pâ: «Wà pwi *péroféta, âna càcaa pitòpié bwàti naa na napô kêe.» ");
INSERT INTO priNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Â nye ticè pai pwa wèe ma é pwa cè wakè goro pàtàmee na Nazareth. (Êco na é tòpò ê îê naa gò pàra tèpa maagé, â rà wâdé côwâ.) ");
INSERT INTO priNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Â é dau pò, ba nye dau càra caa cèikî ê pâ âboro. Gée na càùé, â é pâra wà Iésu nau picémara ê Popai, naa na diri ê pâ village, na tâbèepi wâ Nazareth. ");
INSERT INTO priNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Â é todà tèpa 12 *apostolo kêe, â é pipanuârà ba ârailu jècaa. Â é naa tàra ê tàrù ba na rà tü târa ê pâ duée. ");
INSERT INTO priNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","9","Â é ina tàra pâ: «Guwà cibwaa pa cè muru wiàna guwà pâra—guwà cibwaa pa cè poloa ma cèna atà, ma cè mwani naa na wâra mwani kàwà. Guwà pa co cè tâjò kàwà, ma wâraâwà, ma caapwi ârabwée kàwà.» ");
INSERT INTO priNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Â é ina tàra mwara pâ: «Wiàna tòpiwà naa na cè jè pwârawâ, â wâdé na guwà tâa wê, tiagoro cè tòotù na guwà mwa pâra gée na napô-bà. ");
INSERT INTO priNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Êco na, wiàna càcaa nüma wà tèpa âboro na rà tòpiwà naa na cè jè ére, â wiàna tàutàra na rà têrewà, â guwà pâra géewê. Â guwà tauri ê dàuru puu goro du âwà, ba na guwà paari pâ càcaa wâdé ê pwina rà pwa.» ");
INSERT INTO priNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Â rà pâra wà tèpa câmu, â rà inapàpari târa pâ âboro pâ: «Guwà pitòotéri ê wâro kàwà!» ");
INSERT INTO priNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Â rà tü târa ê pâ duée. Â rà tòpò l'huile naa gò ê pâ âboro na maagé, â rà pwapwicîri kàra â rà wâdé. ");
INSERT INTO priNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Wà pwi ukai *Héroda Antipas âna é têre ê jèkutâ goo Iésu, ba jèe dau pipâra ê jèkutâ gooé. Ba rà ina gooé wà pàra tàpé pâ: «Wàé, âna wàé *Ioane Pwi a piupwaa na é wâro côwâ gée na aubà. Â êkaa ê majoroé ma é pwa ê pâ câmu bèepwiri kâra pàtàmee.» ");
INSERT INTO priNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Â wà pàra tàpé, âna rà ina pâ wà péroféta Élia. Â wà pàra tàpé mwara, âna rà ina pâ: «Pé pwi jè péroféta pwacèwii pàra tèpa péroféta na jè pàara napô.» ");
INSERT INTO priNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Ûna é têre pwiri wà Héroda, â é ina pâ: «Ée! É wâro côwâ gée na aubà wà Ioane Pwi a piupwaa, na ia go pwa ma tépàgà nyee!» ");
INSERT INTO priNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Ba wàéni ê jèkutâ goo ê pai bà kêe: Wà Héroda Antipas, âna ru piéa ma Hérodiade, tô wâdà Filipo, pwi aéjii kêe. Â é ina tà Héroda wà Ioane pâ: «Nye ticè tàrù'gà ma gà popa tô wâdà pwina aéjii'gà!» Â é nama tâjùru wà Ioane, ma piié, ma tòpòé naa na karapuu. ");
INSERT INTO priNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","20","Êco na é nye tà tâmogòori pâ é pwi âboro na é *tàrù ma pwicîri, â é papwicîriê. Â wâdé têe na é tàmaariê, êco na, ûna é têre popai kêe, â jèe câé caa tâmogòori cè pwina ée pwa. Napwa naa goo wà tôoni Hérodiade, âna é èpàri wà Ioane. Â nümee na é pwa ma é bà, êco na ticè naigé mee, ma é pwa, ba wà Héroda, âna é pwamuruê. ");
INSERT INTO priNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Na pwi tòotù na rà pwamaina ê pai pitèpa wà ukai Héroda, âna nye pacoo pai nüma Hérodiade. Ba é pwa ê jè pé pi-ija na maina wà Héroda. Â é todà diri tèpa kupénoo, ma wà tèpa caa kâra coda, ma wà tèpa âboro imaina wâ napô Galilée. ");
INSERT INTO priNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Â wà tô èpo kà Hérodiade, âna é tò naa na ê wâ bèepwiri, â é câbu. Â rà nye dau ipwàdée kaa wà pwini Héroda, ma wà tàpé na rà ija ma wàé. Â é ina tà i tô èpo wà ukai Héroda pâ: «Gà ilari jiio cè pwina nümagà goo, â go o naa tâgà.» ");
INSERT INTO priNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Â é *ipwataâboro têe, â é ina têe pâ: «Go o nye naa tâgà cè pwina gà ilari jiio, wiàna jè pàara gée goro mwaciri kôo.» ");
INSERT INTO priNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","É còobé i tô èpo bèeni, â é ina tà nyaa kêe pâ: «Dà cèna go ilari jii pwi ukai?» Â é tòpi têe pâ: «Gà ilari jiié ê pûru wà Ioane Pwi a piupwaa.» ");
INSERT INTO priNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Â é nye piûri kaa goro itàtà wà tô èpo bèeni, â é pâmari ukai Héroda, â é ina têe pâ: «Nümoo na gà naa tôo ni i pûru wà Ioane, naa na cè jè ngapò.» ");
INSERT INTO priNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Â é dau pikîri wà Héroda. Êco na pwacoé têe ma é tajii ê pwina é ina, ba é jèe ipwataâboro, na ara pâ âboro diri. ");
INSERT INTO priNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Â é nye nama ina tà pwi jè coda pâ: «Gà pâra, â gà pame tôo ê pûru wà Ioane.» Â é pâra wà pwi coda naa na karapuu, â é tépàgà i nya Ioane. ");
INSERT INTO priNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Â é pame i pûruê naa na ê jè ngapò, â é naa tà i tô èpo ilàri. Â wà tôoni, âna é naa tà nyaa kêe. ");
INSERT INTO priNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Ûna rà têre pwiri wà tèpa câmu kà Ioane, â rà pâra nau popa i naiié. Â rà tòpòé naa na auipwàni. ");
INSERT INTO priNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Rà wâjué côwâ wà tèpa apostolo na ia é cùrurà pâ wà Iésu â rà pitapitirirà naa gooé. Â rà piwiâ têe diri ê pâ namuru na rà pwa, bau ê pwina rà picémara târa diri ê pâ âboro. ");
INSERT INTO priNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Nabwé, â é ina tàra pâ: «Jè pâ naa na jè ére na ticia wê, ma guwà tàpo nao.» Ba jèe nye ticè pàara na rà ija na, ba wâru âboro na rà medarirà. ");
INSERT INTO priNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Â rà pâra acari gò jè wànga, naa na jè ére na ticia wê. ");
INSERT INTO priNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Êco na wâru ê pâ âboro, na rà côorà na rà pâra, â rà côoinarà. Â rà itàa me gée na diri ê pâ village, â rà tèepaa béaa kà Iésu ma tèpa câmu kêe naanigée. ");
INSERT INTO priNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Ûna é boo gée gòro i wànga wà Iésu, â é côo i pâ âboro-bà, na dau wâru wàilà, â é po dau meaarirà. Ba rà pwacèwii ê pâ mutô na ticè pwi a wéaarirà. Â wàrapwiri, â é tapoo pacâmurirà goo ê pâ muru na wâru. ");
INSERT INTO priNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Nabwé, jèe pwa na é duu i tòotù, â rà medarié wà tèpa câmu kêe, â rà ina têe pâ: «Ée jèe duu i tòotù, â na, aupiticia ni. ");
INSERT INTO priNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Gà panuâ pâ ê pâ âboro bèeni naa na pâ village na tàmwünyabwe, ba na rà o pa cè uti kàra.» ");
INSERT INTO priNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Êco na é tòpi tàra wà Iésu pâ: «Bwa, guwà naa cè uti kàra!» Â rà tawèerié pâ: «Gona gà pwa na gà cùrubà, ba na bà wâri cè utimuru kàra? Auwa! Pwacoé! Ba rà po dau wâru awé, â o po dau maina awé ê wâri wèe!» ");
INSERT INTO priNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Â é ina tàra pâ: «Gona âradipi poloa na wâjaawà? Pâra ma guwà côo cai.» Â rà pitawèerirà, â rà ina têe pâ: «5 poloa, ma ârailu ârawéà.» ");
INSERT INTO priNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Â é ina tàra pâ: «Guwà ina târa ê pâ âboro bèeni, pâ rà pwa nari pubu, â rà tâaboo naawê.» ");
INSERT INTO priNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Â rà tâaboo, â rà pwa pubu goro 100 ma 50. ");
INSERT INTO priNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Â é popa i 5 poloa ma i du ârawéà wà Iésu. Â é tagòtùé too napwéretòotù, â é pwaolé tà Pwiduée. Â é tubiti ê poloa, â é naa tà tèpa câmu kêe, â rà pipâdi târa ê pâ âboro. Â é wàrapwiri târa mwara i du ârawéà. ");
INSERT INTO priNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Â rà cau ija diri, tiagoro na rà jèe po cau pwàro diri. ");
INSERT INTO priNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Â rà panaimari côwâ ê dàra noo kâra poloa ma ârawéà. Â rà pwaai 12 nakébò goo. ");
INSERT INTO priNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Ê jéû tèpa paao maina na rà ija, âna po 5 000 kaamwara! ");
INSERT INTO priNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Gée na càùé, â é ina wà Iésu tà tèpa câmu kêe pâ: «Guwà tò naa gò i wànga. Â guwà tàmara gée naa Bethsaïda.» Ba é bwaa tà tâa, ba na é pawâjuéri côwâ ê pâ âboro. ");
INSERT INTO priNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Ûna é picijiirà diri, â é too naa gòrojaa, ba na é pwapwicîri. ");
INSERT INTO priNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Ûna jèe ne, â rà jèe wânabibiu kâra i nawià wà tèpa câmu, naa gò i wànga. Â é tà tâa acari wânidò gòromwari wà Iésu. ");
INSERT INTO priNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Â, na jèe gòropwaa, â é côo pâ pwacoé ê pai tapwauru kàra. Ba é po me cararà i pwéretòotù. Â é pâra darirà wà Iésu gòro parawére jawé. Â pwa na é paé jiirà. ");
INSERT INTO priNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","50","Ûna rà côoê, â rà kâa too goro pai dau wâgotàra, â rà ina pâ: «Ée! Uu! Pé duée!» Êco na é nye nama patùrarà wà Iésu, â é ina pâ: «Tàpéeni, guwà cibwaa nama wâgotàwà, ba wâgo! Guwà gòo!» ");
INSERT INTO priNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Â é tò darirà naa gòro i wànga. Â é coo i pwéretòotù. Â nye po dàpàgà tà tàpéeni. ");
INSERT INTO priNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Ba càra caa tâmogòori mwara i pwi ia tèepaa, naa goo i pâ poloa ma du ârawéà. Ba nye târiwâri ê pwâranümarà. ");
INSERT INTO priNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Rà jèe tapàgà diri i nawià wà Iésu ma wà tèpa câmu kêe. Â rà tèepaa gée naa na ére na tàmwünyabweri ê village Génésareth. ");
INSERT INTO priNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Ûna rà êgò boo, â rà tòo i wànga. Â wà tèpa âboro wê, âna rà nama côoina Iésu. ");
INSERT INTO priNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Â rà itàa pitiri i napô kàra, â rà pame tèpa maagé, naa gò ê pâ aupuu kàra. ");
INSERT INTO priNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Â wâna diri ê pâ ére na é pâra naawê wà Iésu—wâna ê pâ ville, ma village, ma napô, ma aupwanapô—âna rà popa me tèpa maagé naa na pâ aupitâa kâra âboro diri. Â rà tacoo gooé, â rà ina têe pâ: «Pâri ma rà tu naa goo ârabwée'gà—wiàna êco ê gòobèreè?» Â wà diri tàpé na rà tu naa goo, âna rà nye wâdé kaa. ");
INSERT INTO priNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Rà me gée *Iérusaléma wà pàra tèpa *Farasaio, ma pàra tèpa *dotée goro ê Naèà. Â rà pitanaimarirà naa goo Iésu. ");
INSERT INTO priNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Â rà côo pâ wà pàra tèpa *câmu kêe, âna rà pâra nau ija, âna càra caa nuwa ê îrà pwacèwii ê pai pwa na ê nyamanya kàra. ");
INSERT INTO priNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Ba wà tèpa *Juif, âna rà nye pâra naa goo ê tûâ kà tèpa nyimurà ma upàra. Â wà tèpa Farasaio, âna rà bwaa dau déi goo. Rà mara nuwa bwàti ê du îrà, béaa kâra ê pai ija kàra. ");
INSERT INTO priNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Â, na rà wâjué me côwâ gée na pâ aupitâa kâra âboro diri, â rà nye ciburà nuwa bwàti ê du îrà, wiâra ê nyamanya kàra béaa kâra cè pai ija kàra. Â wâru ê pâ pàra nyamanya na rà pâra wiâra bwàti mwara—nyamanya na rà pame gée goo tèpa nyimurà ma upàra—wàra ê pai nuwa wàra ê wârado, ma ê wâra jawé, ma ilò. ");
INSERT INTO priNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Êkaa na wà tèpa Farasaio, ma wà tèpa dotée goro ê Naèà, âna rà ina tà Iésu pâ: «Wà tèpa câmu'gà, âna càra caa wâro wiâra ê nyamanya kà tèpa nyimujè ma upàjè. Ba rà ija pa ê îrà na tòri. Âna gorodà, co pwini?» ");
INSERT INTO priNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Â é tòpi tàra wà Iésu pâ: «Guwà tèpa âboro na câguwà caa *tàrù! É nye âjupâra wà *péroféta Isaia, na é naigé mara ê popai kà Pwiduée naa goowà. Ba é wii pâ: Tèpa âboro bèepwiri, âna rà po ipwamainaô co goro pwârà ma pwâratùra. Â wâiti jiio pwâranümarà. ");
INSERT INTO priNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Rà pwapwicîri tôo ma pwa *ârapwaailò tôo, â piticèmuru naa goo. Rà pacâmuri pàra tàpé ba na rà wârori ê naèà. Â càcaa naèà kôo. Ba naèà kàra co.» Ésaïe 29.13 ");
INSERT INTO priNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Â é ina tàra mwara wà Iésu pâ: «Guwà jèe panuâ ê aupitûâri kà Pwiduée. Â guwà jèe pâra naa goo ê aupitûâri kàwà, tèpa âboro. ");
INSERT INTO priNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Üu, guwà nye dau wâdé târa tütâjii ê autûâri kêe, â guwà mwa caa wéaari ê pwina nye tûâ ma càrawà. ");
INSERT INTO priNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Ba é jèe ina wà *Moosé pâ: Gà papwicîri du nyaa ma caa'gà. É jèe ina mwara pâ: Wà pwi âboro na é ina ba èpà du nyaa ma caa kêe, âna guwà nama é bà. ");
INSERT INTO priNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","«Êco na wâguwà, âna guwà nye ina tà tèpa âboro pâ, nye wâdé na rà ina tà du nyaa ma caa kàra pâ: “Nümoo na go naa tàu cè jè muru târa pitu tàu, êco na càcaa pâri. Ba ê pwina nümoo na go naa tàu, âna ê âraimeai pwicîri tà Pwiduée.” ");
INSERT INTO priNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","«Êkaa na, guwà pacâmurirà, ma rà iau tà du nyaa ma caa kàra! ");
INSERT INTO priNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Guwà còogai naa napuu ê popai kà Pwiduée, goo ê pâ nyamanya kàwà! Â wâru mwara ê pâ muru na wàrapwiri, na guwà pwa mwara.» ");
INSERT INTO priNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Gée na càùé, â é todàra mwara ê pâ âboro wà Iésu. Â é ina tàra pâ: «Tàpéebà! Guwà tàmaariô, â guwà tâmogòori cai ê pwina go ina tàwà: ");
INSERT INTO priNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Càcaa pwina tò pwâ pwi âboro, na o nama é *miiri na ara Pwiduée. Ba êco pwina é còobé gée na pwâranümee, na é miiri goo. { ");
INSERT INTO priNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Wà pwina pwa ê pwâranyüruê, âna wâdé na é têre!}» ");
INSERT INTO priNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Géewê, â é pâra jii tèpa âboro wà Iésu, â é pâra naa jaaé. Â rà tawèerié wà tèpa câmu kêe, goro ê ucina na é gére wiâ diri. ");
INSERT INTO priNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Â é tòpi tàra pâ: «Wâguwà mwara, âna càcaa pâri ma guwà tâmogòori pwiri? Guwà côo, nye ticè jè muru na tòme gée gòroigé, na o nama é miiri na ara Pwiduée cè pwi jè âboro. ");
INSERT INTO priNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Ba pâ muru bèepwiri, na me gée gòroigé, âna càra caa tò naa na pwâranümee. Ba rà tò naa nanaaê co, â gée na càùé, â rà còobé gée na naiié.» É paari naawê wà Iésu pâ, é jèe nama pâri ma jè uti gée goo diri ê pâ utimuru. ");
INSERT INTO priNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","22","Â é ina tàra mwara pâ: «Ê pwina còobé gée na pwâranümara pâ âboro, âna wàé kaa pwiri, ê pwina rà miiri goo—ê pâ auniimirimuru, ma câbawâdé na èpà. Â gée goo pwiri, na rà pwa pâ muru na èpà: Rà wâro imudi; Rà toomura (rà cîâa jii wâdàra); Rà ipuu ma tèpa âboro imudi; Rà ciburà iari pâ muru na nümarà goo; Rà iboo; Rà mura; Rà ipwamainarà; Rà tùra ba èpà naa goo pàra tàpé; Rà pwâgàri pàra tàpé; Rà pwa na èpà tàra; Rà tétàmwara âboro. «Wà tàpé na rà wàrapwiri, âna ticè cèna rà tâmogòori naa goo ê pwina wâdé. ");
INSERT INTO priNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Diri ê pâ èpà bèepwiri, âna còobé gée na pwâranüma pwi âboro. Â wàé kaa pwiri ê pwina nama é miiri goo.» ");
INSERT INTO priNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Gée na càùé, â é pâra gée na ére bèepwiri wà Iésu. Â é pâra naa na ére na tàmwünyabweri ê ville Tyr. Â é tâa na ê jè pwârawâ, â càcaa nümee na rà tâmogòori ê pâ âboro pâ é wêe. Êco na pipâra ê jèkutâ. ");
INSERT INTO priNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","Â êkaa, na é pitêre ê popai gooé wà tô jè ilàri. Wà tôoni âna câé caa tô Juive, ba tô gòobàra tèpa Phénicie wâ province Syrie. Â napwa wà tô èpo kêe âna pwa duée gooé. Â é medari Iésu i tô ilàri, â é tùu jùrué araé. Â é ina têe pâ: «Go ilagà pâ gà pacòobé ê duée gée goo tô èpo kôo.» ");
INSERT INTO priNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Â é tòpi têe wà Iésu pâ: «Jè nama rà ija béaa, tèpa nari èpo. Ba càcaa wâdé na jè pa ê uti kàra, ma jè tütâjii târa ê pâ ‘nari akàna’.» ");
INSERT INTO priNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Â é tòpi têe wà tôoni pâ: «Bwa, gà nye âjupâra. Êco na wà tèpa nari akàna mwara, âna rà ija ê muupàra ê utimuru, na rà tubatûu ê pâ nari èpo, gée goro taapà.» ");
INSERT INTO priNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Â é ina têe wà Iésu pâ: «Gée goo ê pai tòpi'gà, â pâri ma gà wâjué côwâ naa jaagà. Ba é jèe còobé i duée, gée goo i èpo'gà.» ");
INSERT INTO priNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Â é wâjué côwâ naa pwârawâ kêe wà tôoni. Â é côo i èpo kêe, na é tàgére puu gò i aupuu. Ba é jèe wâdé! ");
INSERT INTO priNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Géewê, â é pâra gée na ére Tyr wà Iésu, ba na é wâjué côwâ naa bàrawià Galilée. Êco na é bwaa tabiié naa pâ ére wâ Sidon ma Dix Villes. ");
INSERT INTO priNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Â rà popa medarié ê pwi âboro na é kûukû ma kee. Â rà tacoo goo wà Iésu, ma ilari jiié pâ: «Gà tòpò du îgà naa gòé, ba na é wâdé!» ");
INSERT INTO priNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Â é popaé wà Iésu, â ru pâra iti jii ê pâ âboro. Â é tùu gée ê mangadaîê, naa na ê pwâranyüru wà pwini. Â é nama tii ê mangadaîê, goro ê oropwêe. Â é tu naa goo ê ûmemee. ");
INSERT INTO priNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Â é tagòtùé too naa napwéretòotù wà Iésu, â é ôomaa ba maina. Â é ina tà i pwi âboro pâ: «Effata!» (Pai ina wèe pâ: Gà tàpirigà!) ");
INSERT INTO priNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Â é nye tàpirié kaa ê du nanyüruê; â é nye wâdé kaa i ûmemee, â jèe pâri ma é tùra bwàti. ");
INSERT INTO priNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Â é ina wà Iésu tà tàpé na rà côo pwiri pâ: «Guwà cibwaa pwa jèkutâ goo!» Êco na, ûna é gére ina pwiri tàra, â rà mwa nye dau pwa jèkutâ kaa goo, târa ê pâ âboro diri ê pwina é pwa. ");
INSERT INTO priNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Ba rà po dau pò, â rà cau ina pâ: «Guwà côo! Nye po dau wâdé kaa ê pâ muru na é pwa! Ba é nama rà têrejè wà tàpé na rà kee; â é nama rà tùra wà tàpé na rà kûukû!» ");
INSERT INTO priNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Na pwi pàara bèepwiri, âna rà pitapitirirà naa jaa wà Iésu ê pâ âboro na wâru. Â jèe ticè uti kàra. Â é todà tèpa *câmu kêe wà Iésu, â é ina tàra pâ: ");
INSERT INTO priNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","«Au, meaari tèpa âboro bèeni! Ba jèe âracié tòotù kâjè ma wàilà, â jèe ticè utimuru. ");
INSERT INTO priNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Â wiàna go pawâjuépirirà, â o ticè nii kàra wii naigé. Ba wâru tàpé na rà me gée iti.» ");
INSERT INTO priNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Â rà tòpi têe wà tèpa câmu kêe pâ: «A?! Jè o wànau cè pai naa uti kàra diri, naani na pé ére na auticia?» ");
INSERT INTO priNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Êco na é ina co pâ: «Gona âradipi poloa na wâjaawà?» Â rà ina têe pâ: «7 poloa.» ");
INSERT INTO priNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Nabwé, â é ina târa pâ âboro pâ na rà tâaboo. Â é popa i pâ 7 poloa, â é pwaolé tà Pwiduée. Â é tubiti, â é naa tà tèpa câmu kêe. Â rà ipâdi naa goo tèpa âboro. ");
INSERT INTO priNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Nye pwa mwara ê nyi pàra ârawéà kàra. Â é pwaolé tà Pwiduée. Â é ina tà tèpa câmu kêe pâ na rà ipâdi mwara. ");
INSERT INTO priNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Â rà ija tiagoro na rà jèe po cau pwàro diri. Â gée na càùé, â wà tèpa câmu, âna rà tòri ê dèreè, â po 7 nakébò maina na wâbé. ");
INSERT INTO priNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Po 4 000 âboro na rà ija! Nabwé, â é ina tàra wà Iésu pâ, na rà wâjué côwâ naa jaarà. ");
INSERT INTO priNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Â wà Iésu ma wà tèpa câmu kêe, âna rà tò naa gò i wànga. Â rà pâra naa na ére Dalmanoutha. ");
INSERT INTO priNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Rà tèepaa medari Iésu wà pàra tèpa *Farasaio, â rà tapoo pitòocia ma wàé. Ba nümarà na rà pitü tûâ têe. Â rà ina têe pâ: «Paari tâbà cè *câmu kâra pàtàmee na wâgoogà. Â géewê, âna bà o tâmogòori pâ, wà Pwiduée na é panuâgà medaribà.» ");
INSERT INTO priNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Â é watàu wà Iésu, â é ina pâ: «Gona gorodà na rà ciburà ilari cè câmu kêe wà tèpa âboro nabà? Â go ina tàwà ê âjupâra pâ: O càra caa côo cè câmu kâra pàtàmee wà tèpa âboro nabà!» ");
INSERT INTO priNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Â é picijajai, â é pâra jiirà. Â é tò naa gò i wànga, â é gée naanigée na ére gée côwâ. ");
INSERT INTO priNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Rà tèepaa pâ naa na ére gée côwâ. Â wà tèpa câmu kêe, âna rà côo pâ rà tà ipwanauri na rà pa cè poloa. Â tà dàra caapwi co ji poloa kàra. ");
INSERT INTO priNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Â é ina tàra wà Iésu pâ: «Guwà ipwacôoco ê nyaa kâra poloa kà tèpa Farasaio, ma ê nyaa kâra poloa kà *Héroda.» ");
INSERT INTO priNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Â rà pi-ina tàra wà tèpa câmu pâ: «A! Pwiri gée goro na câjè caa pa poloa?» ");
INSERT INTO priNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Â é têre, â é ina tàra pâ: «Cina guwà pi-ina tàwà pâ, guwà imwüru cè poloa? Gona bwaa câguwà caa côo ma tâmogòori? Wànau, bwaa gére picânauri tàwà? ");
INSERT INTO priNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Pwa ê âraporomeewà, â câguwà caa côo? Â pwa ê pwâranyüruwà, â câguwà caa têre? ");
INSERT INTO priNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Gona câguwà caa niimiri i pwi tòotù na go ipâdi i pâ 5 poloa tà i pâ 5 000 âboro? Â âradipi nakébò na guwà pawâjué côwâ?» Â rà ina têe pâ: «12 nakébò.» ");
INSERT INTO priNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","«Ûna go ipâdi i pâ 7 poloa tà tèpa 4 000 âboro, â âradipi jéûru nakébò na ia guwà popa wâjuéri?» Â rà tòpi têe pâ: «7 nakébò.» ");
INSERT INTO priNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Â é ina tàra pâ: «Â bwaa câguwà caa pâ tâmogòori kaa?» ");
INSERT INTO priNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Rà tèepaa pâ naa na village Bethsaïda. Â wà tèpa âboro wê, âna rà pame pwi jè a bwi. Â rà ila Iésu pâ na é tu naa gooé. ");
INSERT INTO priNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Â é tu naa goro îê wà Iésu, â é popaé còobé jii i village. Â é tòpò ê oropwêe naa gò du âraporomara pwi âboro bèepwiri. Â é tòpò ê du îê naa gòé, â é tawèerié pâ: «Dà cè pwina gà côo?» ");
INSERT INTO priNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Â é tàpiri du âraporomee wà pwi a bwi, â é ina pâ: «Go côo pâ âboro, êco na rà pwacèwii ê pâ upwâra na rà pâra.» ");
INSERT INTO priNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Â é jèu tòpò mwara ê du îê wà Iésu naa gòro âraporomee. Â é mwa bàra niâ bwàti wà pwini. Â é jèe wâdé, â é nye dau niâ tia-iti. ");
INSERT INTO priNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Â é ina têe wà Iésu pâ: «Gà wâjué naa jaagà, â gà cibwaa tò naa na village.» ");
INSERT INTO priNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Rà pâra wà Iésu ma wà tèpa câmu kêe, naa na pâ village na tàmwünyabweri wâ ville Césarée-Filipo. Ûna rà gére pâra wii naigé, â é tawèeri tèpa câmu kêe pâ: «Gona dà cèna rà ina gooò wà tèpa âboro? Rà ina pâ wâgo wàa?» ");
INSERT INTO priNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Â rà tòpi têe pâ: «Rà ina wà pàra pwi pâ wâgà *Ioane Pwi a piupwaa. Â rà ina wà pàra tàpé pâ wâgà *péroféta Élia. Â rà ina wà pàra tàpé mwara pâ gà pwi jè ârapàara tèpa péroféta biu.» ");
INSERT INTO priNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Â é tawèerirà wà Iésu pâ: «Â, na wâguwà na?» Â é tòpi têe wà Pétéru pâ: «Wâgà, âna gà pwi *Mesia, pwi ukai na gà me gée goo Pwiduée!» ");
INSERT INTO priNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Â é nye âji papwicîri jiirà kaa na rà inapàpari pwiri. ");
INSERT INTO priNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Gée na càùé, â é tapoo pacâmuri tèpa câmu kêe wà Iésu. Â é ina pâ: «O tèepaa ê pàara, na go mwa dau pwa ê maagé côo na, wâgo *Pwina naîri âboro. Ba wà tèpa pitûâ, ma wà tèpa caa kà tèpa pwa *ârapwaailò, ma wà tèpa *dotée goro ê Naèà, âna o nye tàutàra gooò. Â rà mwa pwa ma go bà. Êco na, naa na béâracié kâra tòotù gée na càùé, âna go o mwa wâro côwâ.» ");
INSERT INTO priNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","É ina ba pwéelaa tàra ê popai bèepwiri. Êco na é todèe naa na jè ére wà Pétéru, â é pwaé. ");
INSERT INTO priNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Â é niâri wà tèpa câmu kêe wà Iésu. Â é pwa Pétéru, â é ina têe pâ: «*Caatana, gà tùugà géeni arao! Ba câgà caa niimiri pwacèwii Pwiduée; â gà niimiri pwacèwii tèpa âboro!» ");
INSERT INTO priNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Géewê, â é todàra ê pâ âboro ma wà tèpa câmu kêe wà Iésu, â é ina tàra pâ: «Wiàna nüma cè pwi jè âboro na é me wiâô, â é cibwaa mwa tà piniimiriê côwâ. Â wâdé na é kâa ê *kurucé kêe, â é me wiâô. ");
INSERT INTO priNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Ba wà pwina nümee na é ipwamuru ê wâro kêe, âna ée mwa tubatiàu. Â wà pwina é panuâ ê wâro kêe ba kôo, ma ê *Picémara Wâdé, âna wà pwiibà, âna ée udò ma tâa têe ê *âji wâro. ");
INSERT INTO priNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Â târa dà kà pwi âboro na é tòpi diri ê pâ wâdé gòropuu, â wiàna é tubatiàu ê nyuâaê? ");
INSERT INTO priNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Gona o dà cèna pâri ma é icuri ma é pâmari côwâ ê nyuâaê? ");
INSERT INTO priNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","«Napwa wà tèpa âboro nabà, âna rà jèe tèpa pwa na èpà, â càra caa pitêre dà Pwiduée. Wà pàra tàpé, âna rà kamu gooò ma ê popai kôo na ara pâ âboro. Â, na wàrapwiri, â wâgo Pwina naîri âboro, âna go o mwa kamu goorà, wiàna bà mwa me, ma tèpa *angela kêe, naa na pwi tòotù kôo. Na pwi tòotù-bà â o paari ê pai maina ma muugère ma pai pwicîri kà Pwi Caa kôo.» ");
INSERT INTO priNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","«Go ina tàwà ê âjupâra pâ: Wà Pwiduée, âna é gére tòpò naani ê Mwaciri kêe, naa na diri ê pàtàmee. Â wà pàra tèpa gére wâni nabà, âna rà bwaa côo ê pai tèepaa kâra i Mwaciri, béaa kâra cè pai bà kàra.» ");
INSERT INTO priNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Gée na càùru 6 tòotù, â wà Iésu, âna é popa wà Pétéru, ma Jacques ma Ioane. Â rà too, naa gò ê pé jaa na maina. Â pitòotéri pai côo Iésu, na ararà. ");
INSERT INTO priNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Â pâra ma po dau pwaa ê pâ ârabwée kêe, â é pwâra. Â nye ticè cè jè âboro wâni gòropuu na pâri ma é pwa cè ârabwée, cèna pwaa pwacèwii pwiri. ");
INSERT INTO priNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Â rà nye côo kaa wà Élia ma wà *Moosé, tupédu *péroféta béaa na rà tàgére pitùra ma wàé. ");
INSERT INTO priNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","6","Â po dau wâgo tà wà Pétéru ma wà tupédu bée. Â é ina wà Pétéru tà Iésu pâ: «Pwi a pwa pupûra, nye po dau wâdé tâbà, na bà gére tâa ni jaagà. Â wâdé na bà pacima cè tèpa âracié nacapè—ba kâgà jèpwi, â kà Élia jèpwi, â kà Moosé jèpwi.» É ina pwiri, ba câé caa tâmogòori cèna é ina, goo pai wâgotêe. ");
INSERT INTO priNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Â é tèepaa me ê jè nee, â é cajipirà. Â rà têre ê pwâratùra gée na nee, na ina pâ: «Wà pwini, âna wàé co kaa pwiri, ê Pwina naîô na caapwi co na dau wânümoo gooé. Â guwà pitêre dèe.» ");
INSERT INTO priNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Â rà piniâ bèepirà wà tèpa *câmu, êco na jèe nye tà wàilà acari ma Iésu. ");
INSERT INTO priNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Ûna rà tàbàtù gée gòrojaa, â é ina ba gòo tàra wà Iésu pâ: «Guwà cibwaa ina târa âboro ê pwina guwà côo, tiagoro ê tòotù, na go mwa wâro côwâ gée na aubà, wâgo *Pwina naîri âboro.» ");
INSERT INTO priNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Â rà pitêre dàra ê pwâratùra bèepwiri. Êco na rà pitawèerirà pâ: «Gona dà ê pai ina wèe bèepwiri pâ, ée mwa wâro côwâ gée na aubà?» ");
INSERT INTO priNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Gée na càùé, â rà tawèeri Iésu pâ: «Wà tèpa *dotée goro ê Naèà, âna rà ina pâ: “Wà péroféta Élia, âna wàé pwi a mara pâbéaa kà pwi *Mesia, *pwi a pa-udò.” Âna gorodà?» ");
INSERT INTO priNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","13","Â é tòpi tàra wà Iésu pâ: «Üu kaa. É mara pâbéaa me wà Élia, ba na é tòpò bwàti diri pâ muru, naa na pai tâa wê. Â go ina tàwà pâ, é jèe nye me wà Élia. Êco na rà jèe pwa têe ê pwina èpà na rà niimiri wà pàra tèpa âboro, pwacèwii na jèe wii naa na *Tii Pwicîri. Â jèe wii mwara gooò, wâgo Pwina naîri âboro pâ, na go o mwa maagé côo, â rà o mwa èpàrio wà tèpa âboro.» ");
INSERT INTO priNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Na rà boome côwâ gée gòrojaa wà Iésu ma wà tèpa âracié a câmu kêe, â rà pâdari wà pàra tèpa câmu béerà. Â rà côo ê pâ âboro na rà dau wâru na rà tâbèepirà. Ba rà tàgére pitùra ma tèpa dotée goro ê Naèà. ");
INSERT INTO priNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Ûna rà côo Iésu wà tèpa âboro, â po dàpàgà tàra. Â rà itàa pâdarié, ba na rà pwabwàcu têe. ");
INSERT INTO priNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Â é tawèeri tèpa câmu kêe pâ: «Gona dà cèna guwà pi-ina ma wàilà?» ");
INSERT INTO priNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Â é tòpi têe wà pwi jèpwi gée goo tèpa âboro bèepwiri, â é ina pâ: «Pwi a pwa pupûra, pwa na go popa me pwina naîô darigà. Ba pwa pé duée na wâgooé, na é pwa ma câé caa tùra. ");
INSERT INTO priNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Â é mu popaé, ma tüê boo naa napuu. Â wà pwina naîô, âna mu còobé ê pâ oropwêe, â é mu tòngüru ê poropwêe. Â mu po gòo ê naiié. Â go ila tèpa câmu'gà pâ, na rà tü têe, êco na càcaa pâri naa goorà.» ");
INSERT INTO priNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","É ina tàra wà Iésu pâ: «Au, go nyi meaariwà wâguwà tèpa âboro nabà, ba bwaa câguwà caa cèikî! Tiagoro wiidà na go o bwaa nye tà tâa jaawà, ma pidàpwicâariô naa goowà? Popa me i pwi nari âboro èpo!» ");
INSERT INTO priNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Â rà popaé me. Ûna é côo Iésu i duée, â é nye nama é po céca diri kaa. Â é tûu, â é biié naa napuu. Â còobé gée pwêe ê pâ oropwêe. ");
INSERT INTO priNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Â wà Iésu, âna é tawèeri pwi caa kêe pâ: «Gona âradipi pàara, na pwa têe ê pwini?» Â é tòpi têe pâ: «Nye tapoo gée na aukîri kêe. ");
INSERT INTO priNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Ê pwi duée bèepwiri, âna é mu tüê naa na ânye, ma naa najawé, ba na é bà. Â gà meaaribà, ma pitu tâbà, wiàna pâri ma gà pwa.» ");
INSERT INTO priNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Â é tòpi têe wà Iésu pâ: «Gorodà na gà ina tôo pâ: “Wiàna pâri ma gà pwa?” Nye cau pâri diri tà pwi a cèikî!» ");
INSERT INTO priNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Â é nye tomara kaa wà pwiibà pâ: «Go cèikî! Êco na gà pitu tôo, ba càcaa po maina ê pai cèikî kôo!» ");
INSERT INTO priNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Â é côo wà Iésu pâ, wâru ê pâ âboro, na rà jèe tapoo me naa gooru. Â é nye pwa kaa i duée, â é ina têe pâ: «Wâgà pwini, na gà pwa ma câé caa tùra ma têrejè, âna go ina tâgà pâ: Gà còobé gée goo pwi âboro èpo bèeni! Â gà cibwaa mwa caa tò côwâ naa gooé!» ");
INSERT INTO priNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Â é pé wiikau i pé duée bèepwiri, â é nye nama é po céca diri i pwi âboro èpo, â é nye còobé kaa. Êco na, napwa i pwi âboro èpo, âna é pwacèwii na é jèe bà. Â wâru ê pâ âboro na rà ina pâ, é jèe maagé. ");
INSERT INTO priNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Êco na é tuboo dèe wà Iésu, â é dàgòtùé ba é jèe wâdé. ");
INSERT INTO priNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Gée na càùé, â é wâjué naa pwârawâ wà Iésu. Ûna rà pitâa acari ma tèpa câmu kêe, â rà tawèerié pâ: «Cina càcaa pâri ma bà pwa ma é còobé i duée?» ");
INSERT INTO priNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Â é tòpi tàra pâ: «Nye gée goro co ê pwapwicîri tà Pwiduée, na o pâri ma jè pacòobé ê pwi pwâra duée bèepwiri.» ");
INSERT INTO priNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Rà còobé gée na ére bèepwiri wà Iésu ma wà tèpa câmu kêe, â rà pitapàgà wài napô Galilée. Â càcaa nüma wà Iésu na rà tâmogòori wà tèpa âboro, pâ é tâa wê. ");
INSERT INTO priNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Ba é gére pacâmuri tèpa câmu kêe goro pai o bà kêe. É ina tàra pâ: «O mwa icurio tà tèpa âboro, wâgo Pwina naîri âboro. Â rà o tâjùruo, â rà o pwa ma go bà. Êco na, naa na béâracié kâra tòotù gée na càùé, âna go mwa wâro côwâ gée na aubà.» ");
INSERT INTO priNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Êco na càra caa tâmogòori ê pwina é ina tàra. Â wâgotàra na rà tawèerié. ");
INSERT INTO priNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Rà tèepaa pâ naa Capernaüm. Ûna rà tò naa na wâ, â é tawèeri tèpa câmu kêe wà Iésu pâ: «Gona dà cèna guwà pi-ina na ia jè gére me?» ");
INSERT INTO priNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Êco na càra caa tòpi têe. Ba ûna rà gére me wii naigé, â rà pitawèerirà pâ: «Gona wàilàapà cè pwina pwamuru naa gooé naa nabibiu kâjè?» ");
INSERT INTO priNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Â é tâaboo wà Iésu, â é ina tàra pâ, na rà cibèepié, â é ina tàra pâ: «Wiàna nümee na é imaina wà pwi jè âboro, â wâdé na é pwi a pwicò ma pwi a piâboro kîri kâra diri pâ âboro.» ");
INSERT INTO priNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Â é popa ji nari èpo, â é tòpòé boo, naa nabibiu kàra. Â é bwénüuê, â é ina tàra pâ: ");
INSERT INTO priNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","«Wà pwina é tòpi naa na neeô pwi jè nari èpo pwacèwii ni, âna é tòpio. Â wà pwina é tòpio, âna é tòpi mwara wà Pwina é cùruo me.» ");
INSERT INTO priNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","É ina wà Ioane tà Iésu pâ: «Pwi a pwa pupûra, bà côo pwi jè âboro, na é tü târa ê pâ duée, naa na neegà. Â pwa na bà ina têe pâ, na é cibwaa pwa, ba câé caa pwi béejè.» ");
INSERT INTO priNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Â é tòpi tàra pâ: «Guwà cibwaa pacooé! Ba wà pwina é wakè goro pàtàmoo, âna o pwacoé ma é ina cè pwina èpà naa gooò. ");
INSERT INTO priNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Ba wà pwina câé caa cicarajè, âna é pwi béejè. ");
INSERT INTO priNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Â go ina tàwà ê âjupâra pâ: Wà pwina é naa tàwà cè jè wârado jawé moo, ba guwà tèpa bée Kériso, âna wà pwi bèepwiri, âna ée mwa tòpi pumee.» ");
INSERT INTO priNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","É ina mwara wà Iésu pâ: «Gà cibwaa pwa ma gùmagù ê cèikî kà pwi âboro kôo, na é pwacèwii ji pwi nari èpo. Ba wiàna wàrapwiri, â o ê wârimuru'gà, âna o dau maina jii na jè tòo naa goro nyagà cè pé atü cèna maina, ma jè tügà naaniboo najawé. ");
INSERT INTO priNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","«Wiàna majoroé ê îgà, na gà pwa na èpà; â gà tapàgàé. Ba o wâdé ba kâgà, na gà tò naa na *âji wâro, pa caapwi îgà. Dau pwaée'gà na gà wéaari ê du îgà, â gà pâiti jii Pwiduée! Ba naa na ére bèepwiri, âna o nye tà ciburà tòogà ê maagé côo, pwacèwii ê na ânye na càcaa bà. { ");
INSERT INTO priNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Â pwa pâ ûne na uti naiiri âboro, âna càra caa bà naa na pwi ére-bà.} ");
INSERT INTO priNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","«Â wiàna majoroé ê âgà, na gà pwa na èpà; â gà tapàgàé. Ba o wâdé ba kâgà, na gà tò naa na âji wâro, pa caapwi âgà. Dau pwaée'gà na gà wéaari ê du âgà, â tügà naa na ére na gà pwamaagé côo naawê! { ");
INSERT INTO priNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Ba ê ânye na ére-bà, âna càcaa bà. Â pwa pâ ûne na rà uti ê naiiri âboro, â càra caa bà naa na pwi ére-bà.} ");
INSERT INTO priNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","«Â wiàna majoroé ê âraporomeegà, na gà pwa na èpà; â gà èrù tâjii. Ba o wâdé ba kâgà, na gà tò naa na *Mwaciri kà Pwiduée, pa caapwi âraporomeegà. Dau pwaée'gà na gà wéaari ê du âraporomeegà, â tügà naa na ére na gà pwamaagé côo naawê! ");
INSERT INTO priNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Â wê, âna càra caa bà ê pâ ûne, na rà iri ê naparawére âboro. Â jè maagé, pwacèwii na tòjè ê ânye. ");
INSERT INTO priNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","«Diri ê pâ âboro, âna o naa tàra ê ânye ma còo, târa ma cèitiri èpà kàra. ");
INSERT INTO priNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Napwa ê còo, âna jè muru na wâdé târa ma pwa nümara ê utimuru. Êco na, wiàna tubatiàu ê nümee, â jè o wànau târa ma jè o pwa ma tèepaa côwâ ê nümee? Bwa, pwacoé! Wâdé na é tâa goowà ê còo, â guwà wâro na tàbwàti ma pàra tèpa béewà.» ");
INSERT INTO priNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Géewê, â é pâra gée na ére bèepwiri wà Iésu. Â é tapàgà ê napô *Judée. Â é pâra naa na ére gée côwâ kâra nairiwâ Ioridano. Â, na diri pâ ére na é tâa wê, âna rà me mwara tèpa âboro, â rà tâbèepié. Â é pacâmurirà goro ê Popai, wàra na nye câmaajé têe na é pwa. ");
INSERT INTO priNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Â rà me burèe wà pàra tèpa *Farasaio, â pwa na rà pwa tûâ têe. Ba rà tawèerié pâ: «Gona pwa tàrù kà pwi jè âboro, naa na ê *Naèà kà Moosé ma é tü tà tô wâdèe?» ");
INSERT INTO priNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Â é tawèerirà wà Iésu pâ: «Gona dà ê popai, na é tûâri tàwà wà *Moosé?» ");
INSERT INTO priNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Â rà tòpi têe pâ: «Bwa, câé caa papwicîri wà Moosé tà pwi âboro na é pitapàgà piéa, wiàna é wii ê tii, ba na é panuâ côwâ tô wâdèe.» ");
INSERT INTO priNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Â é ina tàra wà Iésu pâ: «Guwà côo, é wii ba kàwà ê naèà bèepwiri wà Moosé, ba po dau gòo ê pûruwà! ");
INSERT INTO priNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Êco na, naa na autapoo goo, ûna é tòpò ê gòropuu wà Pwiduée, âna: É tòpò wà pwi paao ma wà tô ilàri. ");
INSERT INTO priNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Â gée goo kaa pwiri, âna é panuâ du nyaa ma caa kêe wà pwi paao, ba na ru pitâa ma wà tô wâdèe. ");
INSERT INTO priNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Â, na wàrapwiri, â wàilu âna ru pâra nau caapwi. «Â êkaa, na go ina tàwà pâ na jèe càcaa ârailu âboro, â ru jèe pwacèwii caapwi âboro. ");
INSERT INTO priNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Â guwà cibwaa tipi côwâ ê pwina é jèe piinaimari wà Pwiduée!» ");
INSERT INTO priNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Â rà pâra jiirà wà Iésu ma wà tèpa *câmu kêe. Ûna rà wâjué côwâ naa pwârawâ, â rà bwaa nye jèu tawèerié mwara, goro tapàgà piéa. ");
INSERT INTO priNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Â é ina tàra pâ: «Wiàna é tü tà wâdèe wà pwi jè âboro, ma é jèu éa côwâ, â é jèe pâ nau toomura (é cîâa jii tô wâdèe béaa). ");
INSERT INTO priNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Â wiàna é pâra jii pwi éaé wà tô ilàri, ma é jèu éa côwâ, â é jèe pâra nau toomura.» ");
INSERT INTO priNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Na jè tòotù, âna rà medari Iésu wà tèpa âboro. Â rà pame têe ê nyi nari èpo kàra, ba na é tu naa goorà, ma é *pwényunyuâarirà. Êco na wà tèpa câmu kêe, âna rà pwa tèpa âboro, ma pacoorà. ");
INSERT INTO priNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Ûna é côo pwiri wà Iésu, â càcaa wâdé têe, â é ina ba gòo tàra pâ: «Guwà naaco nyi tèpa nari èpo, ma rà medario! Guwà cibwaa pacoorà! Ba ê *Mwaciri kà Pwiduée, âna o kâra ê pâ âboro, na rà wàra ê nyi nari èpo. ");
INSERT INTO priNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Üu, âjupâra ê pwina go ina tàwà pâ: Wà pwi âboro na câé caa tòpi ê Mwaciri kà Pwiduée wàra ji nari èpo, âna o pwacoé têe ma é tò naa na.» ");
INSERT INTO priNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Â é nye popa kaa nyi nari èpo, â é tàmarà. Â é tòpò îê naa gòrà, ba na é pwényunyuâarirà. ");
INSERT INTO priNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Ûna é bwaa pwa na é pâra wà Iésu, â é itàa tèepaa me wà pwi jè âboro. Â é pâ nau tùu jùrué araé. Â é tawèerié pâ: «Pwi a pwa pupûra, gà nye dau pwi âboro wâdé kaa. O dà cèna go pwa, ma o tâa tôo ê *wâro dàra gòiri jaa Pwiduée?» ");
INSERT INTO priNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Â é tòpi têe wà Iésu pâ: «Gona cina gà ina gooò pâ, go pwi âboro wâdé? Âjupâra pai ina'gà. Ba nye ticè pwi âboro na wâdé; â nye caapwi co—wà Pwiduée. ");
INSERT INTO priNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Â napwa naa goo ê pai tawèeri'gà, âna gà tâmogòori bwàti ê pâ Naèà: Gà cibwaa tétàmwara âboro; Gà cibwaa toomura (gà cibwaa cîâa jii tô wâdàgà, é, wà pwi éagà); Gà cibwaa mura; Gà cibwaa ina cè popai na pwâ, naa goo cè pàra âboro; Gà cibwaa pwa cè tûâ cèna èpà tà pàra tàpé; Gà papwicîri du nyaa ma caa'gà.» ");
INSERT INTO priNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Â é ina têe wà pwi âboro pâ: «Pwi a pwa pupûra, go jèe pitêre dàra kaa pâ pwiibà, gée na aukîri kôo.» ");
INSERT INTO priNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Â é niâriê wà Iésu, â é po dau meaarié, â é ina têe pâ: «Gà têre, nye caapwi co jè muru, na bwaa tiàu jiigà. Wàéni: Gà pâra, â gà nye icuri kaa diri ê pâ neemurugà, â gà naa ê mwani wâri wèe tà tàpé na ticè kàra. Ba na wàrapwiri, âna o pwa cè wâdé'gà naa jaa Pwiduée. Â gà me wiâô!» ");
INSERT INTO priNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Êco na é po dau pikîri wà pwini, ba po dau pwa neemuruê. Â é pâra. ");
INSERT INTO priNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Wà Iésu, âna é niâri tèpa câmu kêe na rà tâbèepié, â é ina tàra pâ: «Guwà côo, wà tàpé na dau pwa neemururà, âna dau pwacoé tàra, ma rà tò naa na Mwaciri kà Pwiduée!» ");
INSERT INTO priNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Â rà po dau pò goro ê pwâra-tùra bèepwiri. Êco na é bwaa ina tàra côwâ pâ: «Tèpa béeò, akaé! Po dau pwacoé tà pwi jè âboro na é tò naa na Mwaciri kà Pwiduée. ");
INSERT INTO priNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Gona ê kaamela, âna pâri ma é tò na ê pwêe goro kaju? Bwa, pwacoé! Â go ina tàwà pâ: Wà pwi âboro na pwa neemuruê, âna mwa nye dau pwacoé têe awé, ma é tò naa na Mwaciri kà Pwiduée.» ");
INSERT INTO priNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Â rà mwa nye dau pò kaa, tèpa câmu kêe, â rà nye pi-ina tàra côwâ pâ: «A? Â gona wàilàapà cè pwina o pâriê ma é udò ma tâa têe ê *âji wâro?» ");
INSERT INTO priNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Â é niârirà wà Iésu, â é ina tàra pâ: «Naa goo wà tèpa âboro, âna càcaa pâri. Êco na, diri kaa ê pâ muru, âna nye pâri wà Pwiduée.» ");
INSERT INTO priNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Â é ina têe wà Pétéru pâ: «Gà côo, wàibà, âna bà jèe nye po panuâ diri ê pâ muru, ba na bà pâra wiâgà!» ");
INSERT INTO priNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Â é tòpi tàra wà Iésu pâ: «Wàépwiri. Â go ina tàwà ê âjupâra pâ: Â o mwa wâru pàra tàpé na rà o panuâ pwârawâ ma aupwanapô kàra, ba na rà pâra wiâô ma ê *Picémara Wâdé. Â rà o cau panuâ tèpa aéjii kàra, ma pa èpo naigé kàra, ma du nyaa ma caa kàra, ma pâ èpo kàra. «Â go ina tàwà pâ: ");
INSERT INTO priNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","Tapoo nabà, âna rà mwa tòpi cè muru cèna piwéna, na dau maina ma dau wâru. Ba o tâa tàra cè pwârawâ, ma cè aupwanapô kàra. Â o tâa tàra cè aéjii kàra, ma cè èpo naigé kàra, ma cè nyaa ma caa kàra, ma cè èpo kàra! Âjupâra pâ rà o maagé côo, gée goo na rà tèpa âboro kôo. Êco na, gée na càùé, â rà mwa tòpi ê wâro dàra gòiri jaa Pwiduée. ");
INSERT INTO priNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Wâru tàpé na rà pâbéaa nabà, na rà o mwa pwicò widàuru. Â wâru tàpé na rà pwicò nabà, na rà o mwa caa pâbéaa widàuru.» ");
INSERT INTO priNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","É gére too naa *Iérusaléma wà Iésu. Â rà pwicò kêe wà tèpa 12 a câmu kêe, ma pàra âboro. Â rà pâ nau dumapiê, â wâgotàra. Â é popa itiri tèpa câmu kêe ba na rà pitùra. Â é inapàpari tàra mwara ê muru na o jèe tèepaa têe: ");
INSERT INTO priNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","«Guwà côo, nabàni, âna jè too naa Iérusaléma. Â naawê, âna o jèe panuâô, wâgo *Pwina naîri âboro, tà tèpa caa kà tèpa pwa *ârapwaailò, ma tèpa *dotée goro ê Naèà. Â rà o tèio tiagoro na o tétàmwaraô. Â rà o panuâô tà tàpé na càra caa tèpa *Juif. ");
INSERT INTO priNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Â wà tàpéebà, âna rà o pitaurèe gooò, ma èdurio, ma pâdio goro ubati. Â rà o nama go bà. Êco na, naa na béâracié kâra tòotù gée na càùé, âna go o mwa wâro côwâ gée na aubà.» ");
INSERT INTO priNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Gée na càùé, âna ru medari Iésu wà Jacques ma wà Ioane, tupédu naî Zébédée, â ru ina têe pâ: «Pwi a pwa pupûra, pwa jè muru na bu ilari jiigà.» ");
INSERT INTO priNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Â é ina tàru pâ: «Îgàu!» ");
INSERT INTO priNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Â ru ina têe pâ: «Bu tâmogòori pâ gà mwa tâa gòro autâa'gà, na Mwaciri'gà, naa na muugère'gà, â o tâa tâgà ê pitûâ maina awé. Â bu ilari jiigà pâ, na bu tâa goro du jèneregà—pwi jèpwi naa gòro âji îgà, â pwi jèpwi naa gòro aèmwü'gà.» ");
INSERT INTO priNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Â é tòpi tàru pâ: «Câgàu caa tâmogòori ê pwina gàu ilari! Gona nümau na gàu wâdo ê na wârado na go o wâdo? Pâri ma gàu tòpi mwara ê pâ aré ma tòina kôo?» ");
INSERT INTO priNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Â ru tòpi têe pâ: «Akaé, o pâribu!» Â é ina tàru pâ: «Üu kaa, gàu o wâdo ê na wârado na go o wâdo, â gàu maagé ma tòina, pwacèwiio. ");
INSERT INTO priNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Êco na càcaa wâgo, na go pitûâ pâ, wàilàapà na o tâa gòro âji îô ma tâa gòro aèmwü kôo. Ba nye wàco Pwiduée Caa na é jèe nye pwabwàti ê autâa bèepwiri ba kà tàpé na é nye pitòrigarirà.» ");
INSERT INTO priNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Ûna rà têre ê pwâratùra bèepwiri wà tèpa 10 a câmu béeru, â rà putàmu naa goo Ioane ma Jacques. ");
INSERT INTO priNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Â é todàra wà Iésu, â é ina tàra pâ: «Guwà côo, naa jaa wà tàpé na càra caa tèpa âboro kà Pwiduée, âna wà tèpa ukai, âna rà pitûâ ba na rà còogai tèpa âboro. Â wà tàpé na rà imaina, âna rà pwa kûu tàra. Â rà niimiri pâ dau pwamuru naa goorà. ");
INSERT INTO priNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Êco na, napwa naa goowà, âna càcaa wàrapwiri. Ba wà pwi jè ârapàarawà, na nümee na é pwi âboro imaina, âna wâdé na é ipakîriê jii tèpa ênawéna. ");
INSERT INTO priNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Â wà pwina nümee na é pâbéaa, âna wâdé na é pwi ênawéna kâra âboro diri. ");
INSERT INTO priNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Ba wâgo, Pwina naîri âboro, âna câgo caa me, ba na guwà pipwa âboro kîri tôo. Go me, nau pipwa âboro kîri kâra pâ âboro. Â go me, ba na go panuâ ê wâro kôo, ba na go wâri ma tipi wà tèpa âboro na wâru gée na èpà kàra.» ");
INSERT INTO priNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Rà bwaa nye gére pâra naa Iérusaléma wà Iésu ma wà tèpa câmu kêe. Â rà tèepaa pâ naa na village Iériko. Ûna rà còobé géewê, â po dau wâru pâ âboro na rà pâra wiârà. Â é nye tà tâa bàra naigé wà pwi a bwi, na nee Bartimée, pwi naî Timée. Wà pwiibà, âna pwi a-ila, ba pwi a ticè kêe. ");
INSERT INTO priNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Ûna é têre pâ, é tèepaa wà Iésu, pwi âboro gée Nazareth, â é nye tà tomara too pâ: «Iésu, *Pwina naî Davita, gà meaario, â gà pitu tôo!» ");
INSERT INTO priNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Wâru ê pâ âboro, na rà kànariê, ba na rà pacooé. Êco na é mwa nye dau to too kaa burà ina pâ: «Pwina naî Davita, gà meaario, â gà pitu tôo!» ");
INSERT INTO priNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Â é tàpo coo wà Iésu, â é ina tàra pâ: «Guwà todèe!» Â rà todèe, â rà ina têe pâ: «Bwa, gà gòo! Â gà cimadò, ba é todàgà!» ");
INSERT INTO priNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Â é pò ma tétâjii ê palito kêe, â é nye pwairi cimadò kaa, â é pâra dari Iésu. ");
INSERT INTO priNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Â é tawèerié wà Iésu pâ: «Dà cè pwina nümagà goo? Dà cèna pâri ma go pwa ba kâgà?» Â é tòpi têe pâ: «Pwi a pwa pupûra, gà pwa ma go niâ ma wàra béaa.» ");
INSERT INTO priNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Â é ina têe wà Iésu pâ: «Gà pâra, ba gà jèe wâdé côwâ, goo ê cèikî'gà!» Â é jèe nye niâ kaa, wàra béaa. Â é pâra wiâ Iésu. ");
INSERT INTO priNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Rà bwaa gére too dàra *Iérusaléma wà Iésu ma wà tèpa *câmu kêe. Â rà tèepaa mwünyabweri Bétani, ma wâ Bethfagé, du village na ru tâa goro jènere ê gòrojaa Élaio. Â é panuâ pâ ê tupédu a câmu kêe wà Iésu, ");
INSERT INTO priNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","â é ina tàru pâ: «Gàu pâra naa na village bèepwiri, tâa béaa kâjè. Â gàu o pâmari naawê, ê ji nari buriko, na tòoé goro otàpwe, na bwaa nye ticè âboro cèna mu caa tâa gòé. Â gàu tipié, â gàu popaé me naani. ");
INSERT INTO priNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Â wiàna rà tawèeriu pâ: “Gorodà na gàu pwa pwiri?” â gàu tòpi tàra pâ, “Bu popaé pâdari Pwi Ukai, â é mwa panuâê me côwâ wài.”» ");
INSERT INTO priNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Â ru pâra, â ru côo pwi nari buriko, naani bàra naigé, na tòoé mwünyabweri goropwârawâ goo jè wâ. Â ru tipié. ");
INSERT INTO priNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Â wà pàra tèpa tà tâa wê, âna rà tawèeriru pâ: «Dà na gàu pwa? Gorodà na gàu tipi ê pwi nari buriko bèepwiri?» ");
INSERT INTO priNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Â ru tòpi tàra, goro i pwi ia é ina tàru wà Iésu, â rà panuâru. ");
INSERT INTO priNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Â ru popa me i nari buriko dari Iésu. Â ru tòpò pâ ârabwée, naa gòro càùé, â é tâa gòé wà Iésu. ");
INSERT INTO priNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Wâru ê pâ âboro, na rà pòpwara béaa kêe naa gòro naigé, ê pâ ârabwée kàra, ba na rà pwamainaê. Â wà pàra tàpé, âna rà tòpò ê pâ îri upwâra na bwùu, na rà tépàgà pâ ni, na ê pâ na aupwanapô. ");
INSERT INTO priNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Â wà tàpé na rà pâbéaa kà Iésu, ma wà tàpé na rà pwicò kêe, âna rà cau tomara too pâ: «Hosana ma cidòri! Ipwamaina Pwiduée! Cidòri nyuâa pwi âboro na é me na nee! Psaume 118.26 ");
INSERT INTO priNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","*Pwényunyuâari ê mwaciri, na é bwaa âmu tèepaa— pwâra ukai kà *Davita, pwi jojoorojè! Hosana ma cidòri! Pwamaina Pwiduée na é wâdòiti awé!» ");
INSERT INTO priNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Ûna é tèepaa wà Iésu naa Iérusaléma, â é tò naa na ê *Wâra pwapwicîri, â é côo bwàti ê pwina rà gére pwa wà tàpé na rà tâa wê. Â nabwé, â rà pâra naa Bétani ma wà tèpa 12 *apostolo kêe, ba jèe bàrane. ");
INSERT INTO priNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Na dàuru kêe, â ûna rà còobé gée Bétani, â é copwa wà Iésu. ");
INSERT INTO priNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Â é côo gée iti ê jè *upwâra wâi, na po pwédoo. Na pwi pàara-bà, âna càcaa wâru pwâra wâi. Êco na é pâra nau mudàra cè pwêe. Â ûna é tèepaa pâ, â nye po dooé co. ");
INSERT INTO priNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Â é pinajajai i upwâra, ma ina pâ: «O nye ticè cè pwi jè âboro, cèna ée mwa caa uti cè pwâra wâi'gà, ba gà o jèe bà!» Â rà têre pwiri wà tèpa câmu kêe. ");
INSERT INTO priNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Rà tèepaa pâ naa Iérusaléma, â é tò wà Iésu naa na Wâra pwapwicîri. Â é pacòobé tèpa gére pwa jèna, gée na gòroigé kâra Wâra pwapwicîri. Â é pugòboori ê pâ taapà kà tàpé na rà gére pitòotéri mwani, ma ê pâ autâa kà tàpé na rà pi-icu marü. ");
INSERT INTO priNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Â é ina pâ: «Guwà cibwaa pa dòme naani ê pâ muru imudi! ");
INSERT INTO priNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Guwà jèe nye tâmogòori bwàti ê pwina é ina wà Pwiduée naa na *Tii Pwicîri, pâ: O mwa ina goo ê wâ kôo pâ, wâ târa pwapwicîri, kâra diri ê pâ Ba. Êco na wâguwà, âna guwà gére pwa ma aucârü kà tèpa mura!» ");
INSERT INTO priNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Â wà tèpa caa kà tèpa pwa *ârapwaailò, ma wà tèpa *dotée goro ê Naèà, âna rà têre ê jèkutâ goro i pwi ia é pwa wà Iésu. Â rà mudàra cè pai pwa wèe, ba na rà tétàmwereê. Ba wâgotàra gooé, ba jèe dau wâru pâ âboro na rà pâra naa gooé. Ba rà câdiri ê pâ popai na é pacâmurirà goo. ");
INSERT INTO priNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Ûna bàrane, â rà còobé, gée na pwi ville-bà wà Iésu ma wà tèpa câmu kêe. ");
INSERT INTO priNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Na dàuru kêe, na rà pâra wii naigé, â rà côo i iri wâi, na ia é pinajajaié wà Iésu, âna é jèe mwari awé, tia niboo goro wàé. ");
INSERT INTO priNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Â wà Pétéru, âna é niimiri, i pwi ia é ina wà Iésu. Â é ina têe pâ: «Pwi a pwa pupûra, gà côo, i upwâra na ia gà pinajajaié géecaa, âna é jèe mwari.» ");
INSERT INTO priNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Â é ina wà Iésu tà tèpa câmu kêe pâ: «Wâdé na guwà cèikî naa goo Pwiduée! ");
INSERT INTO priNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Ba go ina tàwà ê âjupâra pâ: O pâri ma gà ina târa ê jaa bèeni pâ: “Gà êgò naaniboo nawià!” Â wà Pwiduée âna é pwa! Êco na wâdé na gà cèikî pâ o tèepaa ê pwina gà ina. Â gà cibwaa pidumapiê, naa na pwâranümagà! ");
INSERT INTO priNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Êkaa pwiri ê majoroé ma go ina tàwà pâ: Wiàna guwà pwapwicîri târa ilari ê jè muru, â wâdé na guwà cèikî pâ guwà jèe tòpi. Â ée mwa pacoo wà Pwiduée. ");
INSERT INTO priNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","«Â wiàna guwà cimadò, ma guwà pwapwicîri, â wâdé na guwà pwanauri, tà tàpé na rà pwa tàwà na èpà. Â, na wàrapwiri, â wà Caa kàwà, na é wânidò *napwéretòotù, âna é pwanauri tàwà ê pâ tojii kàwà. { ");
INSERT INTO priNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Êco na, wiàna câguwà caa pwanauri tà pàra tàpé, â wà pwi Caa kàwà, na é wânidò napwéretòotù, âna o câé caa pwanauri tàwà mwara ê pâ tojii kàwà.}» ");
INSERT INTO priNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Wà Iésu ma wà tèpa câmu kêe, âna rà tò côwâ naa Iérusaléma. Ûna é gére pâra naa i Wâra pwapwicîri, â rà me burèe wà pàra tèpa caa kà tèpa pwa ârapwaailò, ma wà tèpa dotée goro ê Naèà, ma wà tèpa pitûâ. ");
INSERT INTO priNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Â rà tawèerié pâ: «Pwiini, wàilàapà na naa tàrù tâgà, ma gà pwa ê pâ muru bèepwiri? Wàilàapà na cùrugà? Â?» ");
INSERT INTO priNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Â é tòpi tàra pâ: «Go bwaa nama tawèeriwà, goro ji caapwi muru co. Â wiàna guwà tòpi tôo bwàti, â go mwa ina tàwà pwi a naa tôo tàrù ma go pwa. Wàéni: ");
INSERT INTO priNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Wàilàapà na naa tàrù tà Ioane ma é *piupwaa? Wà Pwiduée, é, wà tèpa âboro?» ");
INSERT INTO priNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Â rà dau pitùra goo, â rà pi-ina tàra pâ: «Wiàna jè tòpi têe pâ: “Tàrù gée jaa wà Pwiduée” â ée mwa ina tâjè pâ: “Â gorodà na câguwà caa cèikî naa goo ê pwina é ina tàwà wà Ioane?” ");
INSERT INTO priNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Â wiàna jè tòpi têe pâ: “Tàrù gée jaa tèpa âboro co” â dà géewê cèna o tèepaa?» Ba wâgotàra goo tèpa âboro, na rà cau cèikî ba gòo pâ wà Ioane, âna é pwi *péroféta, na é pame ê popai gée jaa wà Pwiduée. ");
INSERT INTO priNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Â êkaa, na rà tòpi tà Iésu pâ: «Îi, câbà caa tâmogòori.» Â é ina tàra pâ: «Â wâgo mwara, âna o câgo caa ina tàwà, wàilàapà na naa tàrù tôo ma go pwa ê pwina go pwa.» ");
INSERT INTO priNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Wà Iésu, âna é piwiâ tà tèpa âboro ê pâ ucina. Â é ina tàra pâ: «É mwa tâa pwi apooro nadipâa. Â é mwa câmi aupwanapô kêe. Â é mwa bariwâri goro ê auba, â é mwa îri pwêe, ba na aucòogai ê pwâra dipâa. Â é mwa bari ê wâ na dau gòri too, ba na aucibèri wàra ê nadipâa. Â nabwé, â é niimiri pâ na é pâra nau ipokâa naa jè napô. Â é wâri pàra tèpa âboro, ba na rà wéaari i na aupwanapô kêe. Â é pâra, â é tâa na jè napô. ");
INSERT INTO priNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","«Paé pâ parui, paé, paé, paé… tèepaa naa na pàara na o pétâ pwâra dipâa na. Â é panuâ pâ pwi jè âboro kîri kêe, ba na é tòpi jii tèpa wéaari nadipâa cè kêe gée goro ê piûnya. ");
INSERT INTO priNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Êco na rà pâdié, â rà panuâê pâ côwâ, â nye ticè cèna rà naa têe. ");
INSERT INTO priNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Â géewê, â é panuâ me côwâ pwi jè âboro kîri kêe. Â rà pièié, â rà tanoori ê pûruê, â rà pé pidurié. ");
INSERT INTO priNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","«Â nabwé, â é panuâ pâ mwara ê pwi béâracié kâra âboro kîri kêe, â rà catàmwereê… Wâru ê pàra tèpa âboro kîri kêe na é panuârà mwara. Â rà pâdi pàra pwi, ma tétàmwara pàra tàpé. ");
INSERT INTO priNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","«Nabwé, â jèe nye ticè âboro târa ma é panuârà—jè dàra wàco pwi âji naîê, na dau wânümee gooé. Â é panuâê pâ tà tèpa piwéaari wàra i nadipâa. Ba é nye tà niimiri pâ rà o tòimiriê, ba wà pwina naîê. ");
INSERT INTO priNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","«Êco na wà tèpa âboro èpà bèepwiri, âna rà pitêrerà, â rà ina pâ: “Guwà côo, wàé kaa ni wà pwi ia ée mwa pwi apooro i na aupwanapô, na cè jè tòotù. Wâdé na jè tétàmwereê cawi, ba na o mwa tà kâjè i na aupwanapô!” ");
INSERT INTO priNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","«Â rà tâjùrué, â rà tétàmwereê. Â rà popa i naiié, â rà tétâjii naaiti jii i na aupwanapô.» ");
INSERT INTO priNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Â wà Iésu, âna é tawèeri tàpé na rà gére têreê, pâ: «Â o dà cèna ée pwa wà pwi apooro i nadipâa? Ée mwa po me wàé, â ée mwa nama tétàmwara i tèpa wéaari wàra i na aupwanapô. Â ée mwa caa naa ê nadipâa bèepwiri tà pàra tàpé, ba na rà wéaari. ");
INSERT INTO priNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Guwà jèe nye gére pûra ê popai bèepwiri, naa na *Tii Pwicîri, pâ: I pwi atü na rà tétâjii wà tèpa ba wâ, âna nye wàé kaa pwiri, i âji êkêe! Tàutàra goo pwi ò kâra wâao! ");
INSERT INTO priNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Ba nye autûâri kà Pwi Ukai. Jè pò goo pwényuâa kêe.» Psaume 118.22–23 ");
INSERT INTO priNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Napwa naa goo wà tèpa caa kà tèpa *Juif, âna rà tâmogòori pâ é tàgére pwa ucina naa goorà. Â dau nümarà na rà tâjùrué. Êco na wâgotàra, gée goo na wâru tèpa âboro na rà wâdéarié, â rà naaê, â rà pâra. ");
INSERT INTO priNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Wà tèpa pitûâ kà tèpa Juif, âna rà panuâ pâdari Iésu wà pàra tèpa *Farasaio, ma wà pàra tèpa tâa na ére kà *Héroda, ba na rà tü tûâ têe. Ba rà bu naigé ma rà pitòtié, gée goro cè pai mwa tòpi kêe tàra. ");
INSERT INTO priNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Â rà ina têe pâ: «Pwi a pwa pupûra, bà nye tâmogòori pâ, gà ina ê âjupâra. Â nye ticè âboro cèna wâgotâgà gooé, â câgà caa ipwaké goro âboro. Ba gà nye picémara ba *tàrù diri ê pâ muru na nüma Pwiduée na bà pwa. Â êkaa, na nümabà na bà tawèerigà pâ: Pwiri wâdé na jè wâripû tà pwi ukai kà tèpa *Roma? É, o càcaa wâdé?» ");
INSERT INTO priNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Êco na é tâmogòori wà Iésu pâ, tèpa pwâ. Â é ina tàra pâ: «Gorodà na guwà ipawâmiô? Paari tôo ê jè mwani atü.» ");
INSERT INTO priNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Â rà pame têe. Â é ina tàra pâ: «Naporomee î ma nee î, na wâgòro ê mwani bèeni?» Â rà tòpi têe pâ: «Kà pwi ukai kà tèpa Roma.» ");
INSERT INTO priNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Â é ina tàra wà Iésu pâ: «Â jèe wâdé, guwà pitôowâri tà pwi ukai ê pwina kêe; â guwà pitôowâri tà Pwiduée ê pwina kà Pwiduée.» Â rà po dau pò goo ê pai tòpi kêe. ");
INSERT INTO priNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Napwa naa goo wà tèpa *Sadukaio, âna jè ditàra pwapwicîri kà tèpa Juif, na càra caa cèikî pâ, rà o wâro côwâ wà tèpa bà. Â wà pàra tàpé gée goorà, âna rà medari Iésu ba nümarà na rà paari pâ rà âjupâra. Â rà tawèerié pâ: ");
INSERT INTO priNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","«Ico pwi a pwa pupûra, é jèe wii tâjè wà *Moosé naa na ê *Naèà pâ: Wiàna é bà wà pwi âboro, na ticè èpo kêe, â wâdé na é popa tô dàpwà kêe wà pwi jiié, ma ru piéa. Â, na wàrapwiri, â é naa cè gòobàra pwi a bà.» ");
INSERT INTO priNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","«Â wâdé. Êco na gà jèe niimiri cai ni: Po 7 tèpa aéjii. Â é piéa wà pwina ciàra, êco na é bà, â nye ticè èpo kêe. ");
INSERT INTO priNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Â pwi a pâ wê, âna ru piéa ma tô dàpwà, êco na é bà mwara wà pwini, â nye ticè èpo kàru. Â wà pwi béâracié, âna ipaiwà. ");
INSERT INTO priNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Â wàrapwiri naa goo wà tèpa 7 aéjii bèepwiri. Ba rà cau bà, â nye ticè èpo kàra. Â gée na càùrà diri, â é mwa bàra bà wà i tô ilàri. ");
INSERT INTO priNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Gà ina pâ rà o mwa wâro côwâ wà tèpa bà, na jè tòotù. Â wiàna wàrapwiri, â wàilàapà narà, na o pwi éa tô ilàri-bà, na tòotù bèepwiri? Ba rà nye cau tèpa éaé diri! Â?! Gà tòpi cai!» ");
INSERT INTO priNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Â é tòpi tàra wà Iésu pâ: «Guwà pitanami, làpé! Cina câguwà caa cèikî pâ, rà o mwa wâro côwâ wà tèpa bà? Ba câguwà caa tâmogòori ê Tii Pwicîri, â câguwà caa tâmogòori ê pàtàma Pwiduée! ");
INSERT INTO priNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","26","Ba na pàara na rà wâro côwâ wà tèpa bà, âna o càra mwa caa piéa côwâ. Ba rà wâro pwacèwii tèpa *angela, naa jaa Pwiduée. «Â gona câguwà caa tâmogòori ê pwina é ina wà Moosé? Ba é pwa jèkutâ naa na ê tii kêe, goro i ji na nari upwâra, na ia tòo gò i ânye. Naawê, âna é ina têe wà Pwiduée pâ: Wâgo Pwiduée kà *Abéraama, ma Isaaka, ma Iakobo. ");
INSERT INTO priNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Pai ina wèe pâ rà nye cau tàgére wâro jaa Pwiduée! Ba wà Pwiduée, âna câé caa Pwiduée kà tèpa bà, â é Pwiduée kà tàpé na rà wâro. Â jè côo naawê pâ, guwà po dau pitanami awé!» ");
INSERT INTO priNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Ûna rà gére pitùra, â é tàmaarirà wà pwi jè *dotée goro ê Naèà. Â é côo pâ é po dau tòpi bwàti tà tèpa Sadukaio wà Iésu. Â é me burèe, â é tawèerié pâ: «Gona dà ê pwi naèà na é piwéna, naa na diri ê pâ naèà?» ");
INSERT INTO priNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Â é tòpi têe wà Iésu pâ: «Wàéni: Guwà têre, co tèpa *Isaraéla!Wà Pwi Ukai Pwiduée, âna wàé kaa pwiri ê pwi âji Ukai kâjè, na é caapwi co! ");
INSERT INTO priNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Â wâdé na gà meaarié gée na diri ê pwâranümagà, ma ê wâro'gà, ma ê aunünüma'gà, ma ê nii'gà. ");
INSERT INTO priNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","«Â wàéni ê béârailu kâra naèà: Gà meaari tèpa âboropwacèwii ê pai pimeaarigà côwâ. Â nye ticè cè jè naèà, cèna piwéna jii ê du naèà-bà.» ");
INSERT INTO priNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Â wà pwi dotée goro ê Naèà âna é ina têe pâ: «Üu kaa! Po dau âjupâra co pwi a pwa pupûra, ê pwina gà ina! Wà Pwi Ukai, âna nye wàé kaa ê pwi âji Pwiduée kâjè! Â nye ticè pwi jèpwi! ");
INSERT INTO priNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Â wâdé na jè meaarié mwara, gée na diri ê pwâranümajè, ma ê tàmanga, ma ê nii kâjè. Â wâdé mwara, na jè meaari tèpa âboro, pwacèwii ê pai meaarijè côwâ. Nye dau piâjimuru pwiri jii ê pâ *ârapwaailò tà Pwiduée, ma ê pâ pàra âraimeai.» ");
INSERT INTO priNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Â é côo wà Iésu pâ, dau wâdé pai tòpi kêe. Â é ina têe pâ: «Câgà caa wâiti jii ê *Mwaciri kà Pwiduée.» Â gée na càùé, â nye ticè âboro na tawèeri Iésu goo cè pàra muru. ");
INSERT INTO priNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Ûna é gére pacâmurirà goo ê Popai naa na *Wâra pwapwicîri, wà Iésu, â é ina tà tàpé na rà tàmaariê, pâ: «Wà tèpa dotée goro ê Naèà, âna rà pacâmuriwà pâ, wà pwi *Mesia, pwi ukai na guwà tapacîê âna é pwi âboro kîri jii wà *Davita, ba é pwi gòobèreè co. Êco na rà pitanami. ");
INSERT INTO priNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Ba nye wà Davita kaa, ûna ia dipitirié ê Nyuâaê Pwicîri, na é ina pâ: Popai kà Pwi Ukai, Pwi Ukai Pwiduée na é patùra Pwi Ukai kôo: “Gà me ma gà tâa ni. Tâa ni gòro îô étò. Go naa tâgà ê pitûâ. O pwamainagà awé. Go nama gà còogai tèpa ipaa dàgà.” Psaume 110.1 ");
INSERT INTO priNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","«Ûna é ina wà Davita pâ Pwi Ukai kôo, âna é tàgére ina wà pwi Mesia. Â wiàna wàrapwiri, â gorodà na rà ina pâ, é pwi âboro kîri jii wà Davita?! Bwa, é paari wà Davita pâ wà pwi Mesia, âna é pwi âboro na é piwéna jii diri pàra tàpé!» Rà tàmaari Iésu ê pâ âboro na wâru, â rà dau ipwàdée. ");
INSERT INTO priNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Â é pacâmurirà mwara, â é ina tàra pâ: «Guwà pwacôoco! Guwà cibwaa pwaduwà kà pàra tèpa dotée goro ê Naèà! Ba dau wâdé tàra, na rà pâra na ê pâ ârabwée gòri. Â wâdé tàra, na rà nye pwabwàcu tàra ma pwamainarà pâ âboro, naa na diri ê pâ ére aupitapitiri. ");
INSERT INTO priNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Rà nye mudàra taaci ê pâ autâa na tâa béaa, na *wâra pitapitiri, ma naa na pâ na aupi-ija maina. ");
INSERT INTO priNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Â rà pwa ê pâ nyakâra pwapwicîri ba na jè o niimiri pâ rà tèpa âboro na rà wâdé. Êco na, ûna rà gére wàrapwiri, â rà popa diri jii ê pa dàpwà ê pâ muru na tà tàra. Â gée goro kaa pwiri, âna o mwa pwa tàra ê wârimuru na dau maina jii ê wârimuru kà pàra tàpé.» ");
INSERT INTO priNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Géewê, â é tò naa na wâra pwapwicîri wà Iésu. Â é tâa béaa naa na pwi ére na jè tòpò mwani târa Wâra pwapwicîri naawê. Â é côo ê pwina rà gére tòpò wà tèpa âboro. Â napwa wà tàpé na dau wâru neemururà, âna rà tòpò ê mwani na dau wâru. ");
INSERT INTO priNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Â é tèepaa me tô jè dàpwà, na piticè neemuruê. Â é naa ji du ârailu nari mwani atü. ");
INSERT INTO priNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Â é todà tèpa *câmu kêe wà Iésu, â é ina tàra pâ: «Go ina tàwà ê âjupâra pâ: Wà tô dàpwà bèeni na piticè neemuruê, âna po dau wéna awé ê pwina é tòpò, jii pàra tàpé. ");
INSERT INTO priNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Ba rà tòpò upûuê (ba ji ére mwani gée goro aumaina goo wârirà). Âna wàé, âna jèe nye piticè neemuruê kaa. Êco na é nye naa kaa diri ê mwani na o pâri ma é wâro goo.» ");
INSERT INTO priNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Gée na càùé, â é còobé gée na *Wâra pwapwicîri wà Iésu. Â é ina têe wà pwi jè a *câmu kêe pâ: «Pwi a pwa pupûra, côo ê pâ atü goro ê auba, goo ê pé wâ bèeni! Nye dau wâdé kaa! Â po dau pwa kaamwa kêe!» ");
INSERT INTO priNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Â é ina têe wà Iésu pâ: «Gà côo ê pâ auba bèeni? Âna go ina tâgà pâ: O mwa téura diri. Â o mwa ticè atü na o mwa pitâagòrà too wê.» ");
INSERT INTO priNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Rà tâa gòrojaa Élaio wà Iésu, ma wà Pétéru, ma Jacques, ma Ioane, ma wà André, wâcicima i Wâra pwapwicîri. Â rà tawèerié pâ: ");
INSERT INTO priNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","«Gà ina tâbà pâ o wiidà cèna o tèepaa ê pwina gà gére ina. Â o dà cè câmu kêe ma bà o tâmogòori pâ, o jèe tèepaa me ê pwi pàara-bà?» ");
INSERT INTO priNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Â é ina tàra pâ: «Guwà ipwacôowà, â guwà cibwaa pwa ma ipa-imwüruwà. ");
INSERT INTO priNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Ba o wâru tàpé na rà o tèepaa me, â rà o pa ê neeô. Â rà o ina tàwà pâ: “Wâgo pwi Mesia na go me gée jaa Pwiduée, na guwà tapacîê!” Â rà o ipa-imwüru ê pâ âboro na wâru. ");
INSERT INTO priNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Guwà o têre cè airi paa, cèna wâmwünyabwe, ma jèkutâ goro paa na wâiti. Â guwà cibwaa nama wâgotàwà! Ba o nye mara tèepaa ê pâ pwiibà, êco na o càcaa pâji pwâadàra gòropuu. ");
INSERT INTO priNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","«Â o wâru pâ ipaa pitiri gòropuu: Ba ê pwi jè Ba, âna ru pipaa ma pwi jè Ba. Â wà pwi jè ukai, âna ru pipaa ma cè pwi jè ukai. Â o gù napuu, na pâ pàra ére gòropuu, â o pâ nau tèepaa ê pâ copwa na maina. Ê pâ na pai pwa wèe bèepwiri, âna o pwacèwii ê pâbéaari maagé kâra pitèpa èpo.» ");
INSERT INTO priNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","«Guwà têre bwàti ê pwina o mwa tèepaa dariwà: Rà o mwa popawà pâ, naa na pâ wâra pitèimuru. Â rà o pâ nau èiwà, naa na pâ *wâra pitapitiri. Â o dàtiwà pâ, na ara tèpa kupénoo, ma wà tèpa ukai, gée goro na guwà tèpa âboro kôo. Â, na wàrapwiri, â guwà o tèpa *paâjupâraô, na ararà. ");
INSERT INTO priNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Ba wâdé na jèe mara inapàpari ê Picémara Wâdé târa diri pâ Ba. ");
INSERT INTO priNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","«Â, na diri ê pâ pàara na rà o mwa tâjùruwà ma pitèiwà, â guwà cibwaa pidumapiê goro cè pai tòpi kàwà tàra. Ba guwà mwa ina co ê popai na é naa tàwà wà Pwiduée, na pwi pàara-bà. Ba o ê Nyuâaê Pwicîri na ée tùra, â o càcaa wâguwà. ");
INSERT INTO priNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","«Na pwi pàara bèepwiri, âna wà pwi jè âboro, âna é panuâ pwi aéjii kêe, ba na tétàmwereê. Â é wàrapwiri mwara wà pwi caa kâra èpo, tà pwina naîê. Â wà tèpa èpo, âna rà o mwa pipaa ma tèpa nyaa ma caa kàra. Â rà o pwa ma rà pwa wârimuru, tiagoro pai pòtàmwararà. ");
INSERT INTO priNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","«Êdiri pâ âboro, âna rà o pièpàriwà gooò. Êco na wà pwina é cimwü tia pwâadèreè, âna ée mwa pa-udòé wà Pwiduée ma naa têe ê *wâro dàra gòiri jaaé.» ");
INSERT INTO priNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","«Guwà o pâ nau côo ê capwi na é tèepaa me naa na ére na càcaa autâa kêe—muru na jè miiri, ma jè pwùkùru goo.» (Â wà pwina é pûra ni, âna wâdé na é tâmogòori bwàti ê pwini!) «Â, na pàara bèepwiri, âna wâdé na rà uru naa gò pâ jaa, wà tàpé na rà tâa *Judée! ");
INSERT INTO priNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Â wà pwina é nao gòroigé jii wâ, âna é cibwaa wâjué côwâ, nau mudàra cè jè muru, wâna ê wâ kêe. ");
INSERT INTO priNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Â wà pwina é tâa na ê na aupwanapô, âna é cibwaa wâjué côwâ naa jaaé, ma é popa ê ârabwée kêe. ");
INSERT INTO priNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Au! Wârico! Ba, na ê pâ tòotù bèepwiri, âna o po dau pwaée kâra pa ilàri na rà nyarana, ma pa ilàri na rà pa-di ê èpo kàra. ");
INSERT INTO priNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","«Â guwà pwapwicîri tà Pwiduée pâ, na càcaa tèepaa mariwà, ê pâ muru bèepwiri, na pàara na pièpà napô na! ");
INSERT INTO priNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Ba, na pàara bèepwiri, âna rà o dau maagé côo wà tèpa âboro. Ba bwaa nye ticè cè pwi jè âboro, cèna ée jèe maagé côo wàrapwiri—tapoo gée na autapoo goo ê gòropuu, ûna é nye tòpò diri ê pâ muru wà Pwiduée—tiagoro nabà. Â o jèe nye ticè cè pwi jè âboro, cèna ée mwa wàrapwiri côwâ ê pai maagé kêe. ");
INSERT INTO priNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","«Wiàna wà Pwiduée Pwi Ukai, âna càcaa nümee na é nama piboo ê pâ jéûru tòotù bèepwiri, â pwiri nye ticè cè pwi jè âboro cèna é piupa ê wâro kêe. Êco na é niimiri pâ, na é nama piboo, wàrapwiri goo wà tàpé na é jèe pitòrigarirà.» ");
INSERT INTO priNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","«Â wiàna é ina tàwà ê pwi jè âboro pâ: “Guwà côo! É wâni wà pwi *Mesia, *pwi a pa-udòjè!” é wâpà wiàna é ina pâ: “É wâna ê ére bèeni!” â guwà cibwaa cèikî naa gooé. ");
INSERT INTO priNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Ba rà o mwa tèepaa me cè tèpa ‘mesia’ ma tèpa ‘péroféta’ na rà tèpa pwâ. Â rà o pwa ê pâ wakè goro pàtàmarà na rà mwa pò goo wà tèpa âboro, târa ma rà ipa-imwürurà. Â rà ipwadàrapwa mwara ma rà ipa-imwüru tàpé na é jèe pitòrigarirà wà Pwiduée. ");
INSERT INTO priNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Â, na wàrapwiri, â wâguwà, âna guwà o ipwacôoco! Ba go jèe tàmara ina tàwà ê pâ muru na o mwa tèepaa!» ");
INSERT INTO priNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","«Na pâ tòotù-bà, â rà o dau maagé côo ê pâ âboro. Â gée na càùru pwiri: O câé té i tòotù. O bàutê i parui. ");
INSERT INTO priNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Rà o tûu pâ îricò. Gùmagù pâ pàaé. Ésaïe 13.10; 34.4 ");
INSERT INTO priNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","«Â, na pàara bèepwiri, âna o côoô, wâgo *Pwina naîri âboro, wiàna go tèepaa me na nee, naa na ê pàtàmoo, ma ê pai maina ma muugère kôo. ");
INSERT INTO priNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Â go o panuâ me tèpa *angela, ba na rà popa tàpé na go jèe pitòrigarirà. Â rà panaimarirà, pitiri ê gòropuu.» ");
INSERT INTO priNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","«Wâdé na guwà picòo bwàti ê câmu kâra ê *iri wâi. Ba, na é bwaa tapoo ti, â guwà tâmogòori pâ, ée jèe tèepaa me ê pàara na ucuu i napô. ");
INSERT INTO priNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Wàrapwiri na guwà côo pâ, gére tèepaa ê pàra câmu na go gére ina, â guwà o tâmogòori pâ, o jèe pacoo diri. ");
INSERT INTO priNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Â go ina tàwà ê âjupâra pâ: O càcaa gòiri. Wà pàra tèpa âboro nabà, âna rà o bwaa nye côo pwiri, béaa kâra pai o bà kàra. ");
INSERT INTO priNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Ba o tiàu ê napwéretòotù ma ê gòropuu; â napwa ê popai kôo, âna o càcaa tiàu.» ");
INSERT INTO priNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","«Nye ticè pwi âboro, cèna tâmogòori cè tòotù ma cè ineretòotù, cèna o tèepaa ê pâ muru bèepwiri. Ba câbà caa tâmogòori mwara wâgo Pwina naî Pwiduée, ma wà tèpa angela kêe. Â nye wàco Caa, na é tâmogòori. ");
INSERT INTO priNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Guwà pwacôoco, â guwà cibwaa tà puu! Ba câguwà caa tâmogòori cè pàara cèna o tèepaa na. ");
INSERT INTO priNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","«Ba ipwacèwii naa goo pwi âboro na é pâ nau ipokâa jii napô kêe. Â é naa tà tèpa wakè kêe ê tàrù, naa goro diri ê pâ neemuruê, tiagoro ê pwârawâ kêe. Â é ipâdi naa goorà ê jèpa wakè kàra. Â é pitûâri tà pwi a wéaari goropwârawâ pâ, na é tà tâa ma tàcî. ");
INSERT INTO priNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","«Â ipaiwà naa goowà—wâdé na guwà tà tàcî! Ba o câguwà caa tâmogòori, cè pàara cèna ée tèepaa me côwâ na, wà pwi apooro pwârawâ. Ba pwiri o bàrane, é pwiri o nabibiu kâra ne, pwiri naa gòropwaa, pwiri gòro dàuru. ");
INSERT INTO priNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Â wiàna é pwairi tèepaa me, â càcaa wâdé na é pâmariwà na guwà gére puu! ");
INSERT INTO priNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Ê pwina go ina tàwà, âna popai tà diri tèpa âboro: Wâdé na guwà tà tàcî!» ");
INSERT INTO priNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Dàra ârailu tòotù, â o coo ê du *tòotù maina kà tèpa Juif—tòotù *Paséka jèpwi, bau tòotù maina kâra ‘pi-ija poloa na ticè nyaa kêe’. Â nüma wà tèpa caa kà tèpa pwa *ârapwaailò, ma wà tèpa *dotée goro ê Naèà, na rà tétàmwara wà Iésu. Â rà imudàra cè pai pwa wèe, ma rà tü tûâ têe ma tâjùrué pwàniri. ");
INSERT INTO priNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Ba rà pi-ina tàra pâ: «O po càcaa wâdé na jè tâjùrué pàpari, na pàara na pwa i pi-ija maina wâna. Ba péa rà tà putàmu naa goojè ê pâ âboro, ma gùmagù napô.» ");
INSERT INTO priNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Na pwi pàara bèepwiri, âna é tâa Bétani wà Iésu, wâna pwârawâ kà Simona, pwi a pwa maga. Â, na rà gére ija, â é tèepaa me ê tô jè ilàri, bau ê wâra jawé atü, na wâbé goro ê jawé ûrea—pwi jawé na dau maina ê wâri wèe. Â é tébiti i wâra jawé, â é wicèpwiri i jawé ûrea naa gòro pûru Iésu. ");
INSERT INTO priNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Ûna rà côoê wà pàra tàpé na rà gére tâa wê, â po dau càcaa wâdé tàra. Â rà pi-ina tàra pâ: «Kaa! Cina é po dau pwatari i jawé ûrea bèepwiri? ");
INSERT INTO priNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Ba ê wâri wèe, âna pâ miliô! Gorodà na càcaa icuri, ma o naa ê wâri wèe, tà tàpé na ticè kàra?» Â rà gére dau putàmu naa gooé. ");
INSERT INTO priNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Â é ina tàra wà Iésu pâ: «Guwà naaê! Gona cina guwà nama é tòina? Ê pwina é pwa wà tôoni, âna muru na po dau wâdé. ");
INSERT INTO priNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Ba rà o nye tà ciburà wâjaawà wà tàpé na ticè kàra, â o nye pâri ma guwà pwa tàra cè pwina wâdé wiàna âji nümawà. Â napwa wâgo, âna o câgo caa tà ciburà tâa jaawà. ");
INSERT INTO priNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Â wà tôoni, âna é jèe pwa kaa ê muru na pâri ma é pwa. Ba ûna é wicèpwiri naa gò-o i jawé ûrea, âna é jèe pwabwàti cawi béaa ê pai o boo kôo naa napwêe. ");
INSERT INTO priNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Pwa na go ina tàwà ê âjupâra pâ: Na diri pâ ére, na o mwa inapàpari ê *Picémara Wâdé naawê—naa na gòropuu diri—â o piwiâ mwara ê jèkutâ goo ê pwina é pwa wà tô ilàri bèeni. Â o nye tà ciburà niimiriê.» ");
INSERT INTO priNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Wà Judas Iscariote—wà pwi ârapàara tèpa 12 *apostolo—âna é pâ nau côo tèpa caa kà tèpa pwa ârapwaailò. Â é ina tàra pâ, na ée mwa panuâ Iésu tàra. ");
INSERT INTO priNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Â rà nye dau ipwàdée kaa, â rà ina pâ na rà o mwa naa cè mwani têe. Â tapoo na pàara bèepwiri, â é imudàra cè naigé, ma é icuri wà Iésu tàra. ");
INSERT INTO priNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","É jèe tèepaa ê bétapoo tòotù kâra ‘pi-ija poloa na ticè nyaa kêe’—tòotù na rà mu taa ê nari mutô târa Paséka. Â rà ina tà Iésu wà tèpa *câmu kêe pâ: «Bà o pâ nau pwabwàti ê utimuru târa Paséka. Â wâpà na nümagà na jè pi-ija wê?» ");
INSERT INTO priNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Â é panuâ tupédu ârailu gée goorà, â é ina tàru pâ: «Gàu pâra naa na ville, â o ipitiwà ma pwi âboro, na é popa ê wâra jawé. Â gàu pâra wiâê. ");
INSERT INTO priNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Â, na é tò naa na jè pwârawâ, â gàu ina tà pwi apooro wê pâ: “É tawèeri me wà pwi a pwa pupûra kâbà, pâ, o wâpà ê naditàrawâ, na bà o ija naima ê utimuru târa Paséka?” ");
INSERT INTO priNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","«Â ée paari tàu ê jè naditàra-wâ na wâdòiti—pwi naditàrawâ maina na jèe ipwabwàti. Â gàu pwabwàti i uti kâjè naawê.» ");
INSERT INTO priNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Â ru pâra naa na ville, â ru pâmari, wàra na é ina tàru wà Iésu. Â ru pwabwàti ê utimuru târa Paséka. ");
INSERT INTO priNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Na bàrane, âna rà tèepaa naawê wà Iésu ma i tèpa 12 apostolo kêe. ");
INSERT INTO priNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Â rà tâaboo, â rà ija. Â é ina tàra wà Iésu pâ: «Go ina tàwà ê âjupâra pâ: Wà pwi jè ârapàarawà, âna ée mwa ipwa tûâ tôo—pwina jè gére ija naima ma wàé.» ");
INSERT INTO priNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Â rà pikîri wà tèpa câmu kêe, â rà jèpa pitawèerié pâ: «Gona pwiri càcaa wâgo?» ");
INSERT INTO priNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Â é ina tàra pâ: «Akaé, o wà pwi jè ârapàarawà, wâguwà tèpa 12 apostolo—wà pwina bu capai tuboo naa na i na ngapò ma wàé. ");
INSERT INTO priNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Wâgo *Pwina naîri âboro, âna go o pâra nau bà, wàra na é jèe inapàpari ê *Tii Pwicîri. Â napwa naa goo wà pwi âboro na é pi-icurio, âna po dau pwaée kêe. Au! Wârico! Ba wà pwiibà, âna pwiri nye gére wâdé ba kêe wiàna càcaa gére pitèpaé!» ");
INSERT INTO priNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Ûna rà pi-ija naima, â é popa ê poloa wà Iésu. Â é pwaolé tà Pwiduée. Â é tubiti, â é naa jècaari tà tèpa câmu kêe, â é ina tàra pâ: «Guwà ija, ba êni, âna naiio.» ");
INSERT INTO priNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Â gée na càùé, â é popa ê wârado dipâa. Â é pwaolé tà Pwiduée, â é naa tàra. Â rà cau wâdo diri. ");
INSERT INTO priNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Â é ina tàra pâ: «Êni, âna domii kôo, na o jèe joro ba kà tèpa âboro; domii na é pacoo ê *auipwataâboro na é pwa wà Pwiduée, bétòpò pinaanapô naa nabibiu kàwà ma wàé. ");
INSERT INTO priNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Â go ina tàwà ê âjupâra pâ: O câgo mwa caa wâdo cè dipâa naani gòropuu. Go o mwa wâdo ê dipâa na bwaa âmuê, naa na ê *Mwaciri kà Pwiduée.» ");
INSERT INTO priNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Rà nyabiri ê pâ *salamo târa ê pwi tòotù maina-bà, â géewê, â rà too naa gòrojaa Élaio. ");
INSERT INTO priNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Â é ina wà Iésu tà tèpa câmu kêe pâ: «Guwà o mwa po capai panuâô diri. Ba jèe wii naa na Tii Pwicîri pâ: O mwa pòtàmwara pwi a wéaari mutô. O tadidiri pâ mutô. Zakarie 13.7 ");
INSERT INTO priNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","«Êco na, wiàna go o mwa wâro côwâ gée na aubà, â go o mwa pâbéaa kàwà naa Galilée.» ");
INSERT INTO priNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Â é ina têe wà Pétéru pâ: «Wà tàpéeni âna rà o panuâgà, â o càcaa wâgo!» ");
INSERT INTO priNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Â é tòpi têe wà Iésu pâ: «Go ina tâgà ê âjupâra pâ: Naa na ne nabà, béaa kâra ê pai wailu to kâra ê ja, âna wâgà, âna gà o wacié pitütôowâri pâ, câgà caa tâmogòorio.» ");
INSERT INTO priNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Â é nye ciburà gòo wà Pétéru nau ina pâ: «Èkâ! Wiàna ina pâ tétàmwaraju naima ma wâgà, â câgo caa pitütôowârigà!» Â wàilà diri, âna nye caapwi ê pwina rà ina têe. ");
INSERT INTO priNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Géewê, â rà pâra wà Iésu ma wà tèpa câmu kêe naa na jè ére na câmi goro upwâra na ina goo wê pâ Gethsémané. Â é ina tàra pâ: «Guwà tâaboo naani, ba go bwaa pâra nau pwapwicîri.» ");
INSERT INTO priNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Â é popa wiâê wà Pétéru, ma Jacques, ma Ioane. Â é tapoo po dau pidumapiê ma wâgotêe. ");
INSERT INTO priNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Â é ina tàra pâ: «Po dau tòina ma pikîri ê pwâranümoo. Â guwà tàpo tâa ni, â guwà tà tàcî! Guwà cibwaa puu!» ");
INSERT INTO priNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Â é tàpo paé jiirà, â é tùu jùrué. Â é ilari jii Pwiduée pâ na é patâjii jiié ê tòina kâra pwi pàara bèepwiri, wiàna pâri. ");
INSERT INTO priNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Â é ina pâ: «Abba, Caa, pârigà diri ê muru. Gà patâjii jiio ê pâ aré ma tòina bèeni! Êco na gà cibwaa pwa ê pwina nümoo goo, â gà nye pwa câbawâdé'gà.» ");
INSERT INTO priNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","É wâjué me côwâ dari tèpa âracié a câmu kêe, â é côo pâ rà tà puu. Â é ina tà Simona Pétéru pâ: «Simona, wànau, gà tà puu? Càcaa pâri ma gà tàpo tàcî, naa na ji caapwi ineretòotù? ");
INSERT INTO priNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Guwà tà tàcî, â guwà pwapwicîri ba na o pwa cè nii ma gòo kàwà, wiàna tacaiwà. Ba nümawà na guwà pwa na wâdé, êco na ticè nii kàwà.» ");
INSERT INTO priNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","É jèu pâra côwâ wà Iésu jiirà, â é jèu pwapwicîri, â é jèu ina mwara ê pwina é jèe ina. ");
INSERT INTO priNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Ûna é wâjué me côwâ darirà, â é pâmarirà mwara na rà gére puu. Ba nye po dau pwacoé tàra, ma rà tà tàcî. Â càra caa tâmogòori, cè otòpi kàra têe. ");
INSERT INTO priNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Â jèe béwacié mwara ê pai pâra kêe jiirà, â é wâjué côwâ. Â é ina tàra pâ: «Gona guwà bwaa gére nao ma puu? Pâri! Ba o jèe panuâô ni tà tèpa pwa na èpà, wâgo Pwina naîri âboro. Ba rà tàgére mee ni, ba na rà tâjùruo. ");
INSERT INTO priNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Guwà cimadò! Ma jè pâra! Ba wà pwina é ipa popai gooò, âna jèe tà wàéni!» ");
INSERT INTO priNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Ûna é bwaa gére ina pwiri wà Iésu, â é po tèepaa me wà Judas, wà i pwi jè ârapàara tèpa 12 apostolo kêe. Â rà tèepaa me wiâê pâ âboro na wâru, na rà pa ê pâ tàuwa, ma gò upwâra. Ba rà panuârà me wà tèpa caa kà tèpa pwa ârapwaailò, ma wà tèpa dotée goro ê Naèà, ma wà tèpa pitûâ. ");
INSERT INTO priNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Â wà Judas, wà pwina é pi-icuri Iésu, âna é jèe inapàpari tàra ê pwina ée pwa: «Wà pwi âboro na go bwénüuê, âna nye wàé kaa. Guwà tâjùrué, â guwà popaé pâ, â guwà wéaarié bwàti.» ");
INSERT INTO priNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Â rà tèepaa me, â é nye pâra dà Iésu kaa wà Judas, â é ina têe pâ: «Bwàcu'gà co Pwi a pwa pupûra!» Â é bwénüuê. ");
INSERT INTO priNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Â rà pò ma tâjùru Iésu. ");
INSERT INTO priNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Â wà pwi âboro na é tâa jaa Iésu, âna é pò ma càù ê tàuwa kêe, â é nye tüboo kaa naa gòro pûru pwi âboro kîri kà pwi *ukai kà tèpa pwa ârapwaailò. Êco na é tépàgà co i doronyüru. ");
INSERT INTO priNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","É ina wà Iésu tà tàpéeni pâ: «Wànau? Guwà me nau popao, goro ê pâ tàuwa, ma ê bàra upwâra, pwacèwii na go pwi a pòtàmwara âboro! ");
INSERT INTO priNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Diri pâ tòotù, âna go tâa nabibiu kàwà. Â go pacâmuri tèpa âboro, naa na *Wâra pwapwicîri. Êco na câguwà caa tâjùruo! Bwa, wâdé na wàrapwiri. Ba nabàni, âna gére pacoo ê pâ muru na jèe inapàpari, naa na Tii Pwicîri.» ");
INSERT INTO priNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Â wà diri tèpa câmu kêe, âna rà panuâê, â rà uru. ");
INSERT INTO priNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Êco na pwa pwi jè âboro èpo, âna é pâra wiâê. Â é pòpiié goo ê jè ciità. Ûna rà pwa na rà tâjùrué wà pàra tàpé, ");
INSERT INTO priNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","â rà tà cipa awé i ciità kêe, â é uru na é cicàpé. ");
INSERT INTO priNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Rà popa pâ Iésu naa jaa pwi ukai kà tèpa pwa ârapwaailò. Ba rà ipitiri naa jaaé wà tèpa caa kà tèpa pwa ârapwaailò, ma wà tèpa pitûâ, ma wà tèpa dotée goro ê Naèà. ");
INSERT INTO priNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Napwa wà Pétéru, âna é picâwiâê gée iti, â é tò naa jaa pwi ukai kà tèpa pwa ârapwaailò. Â é tâaboo naa na pé gòroigé, naa jaa tèpa âboro kîri, tèpa wéaa, â é pwacârau. ");
INSERT INTO priNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Wà tèpa caa kà tèpa pwa ârapwaailò, ma diri ê pé wâra pitèimuru kà tèpa Juif, âna rà mudàra cè âboro, târa na rà pitòti Iésu. Ba nümarà na rà o pwa wârimuru têe ma é bà. Êco na càra caa pâmari. ");
INSERT INTO priNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Ba wâru tèpa pitòtié na rà pwâ, êco na càra caa pitêrerà. ");
INSERT INTO priNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Â nabwé, â rà cimadò pàra tàpé gée goorà, â rà ina pâ: ");
INSERT INTO priNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","«Bà jèe nye têreê na é ina pâ: “Go o tédidiri ê Wâra pwapwicîri bèeni na ia rà bari wà tèpa âboro. Â naa na âracié tòotù, âna go bari côwâ ê jè Wâra pwapwicîri na càcaa bari goro na-araraîri âboro.”» ");
INSERT INTO priNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Êco na wà tèpa pitòtié bèepwiri, âna càra caa pitêrerà mwara. ");
INSERT INTO priNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","É cimadò na ara diri tèpa pitûâ wà pwi ukai kà tèpa pwa ârapwaailò, â é tawèeri Iésu pâ: «Gona nye ticè bétòpi'gà? Wànau? Câgà caa têre ê pâ pwina rà gére pitòtigà goo?» ");
INSERT INTO priNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Êco na é nye tàpo tâa wà Iésu, â câé caa tòpi. Â é jèu tawèerié mwara wà pwi ukai kà tèpa pwa ârapwaailò, pâ: «Gona nye âjupâra pâ wâgà, âna gà pwi *Mesia, *Pwina naî Pwiduée—wà Pwiduée na jè papwicîriê?» ");
INSERT INTO priNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Â é tòpi têe wà Iésu pâ: «Üu, âjupâra ê pwina gà ina. Â guwà mwa côo wà Pwina naîri âboro, wiàna é tâa gòro étò kà Pwiduée na dau pwa pàtàmee, â ée mwa pitûâ. Â guwà mwa côoê, wiàna é me na pâ nee, gée napwéretòotù.» ");
INSERT INTO priNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Â po dau dàpàgà tà pwi ukai kà tèpa pwa ârapwaailò, â é po dau putàmu. Â é nye tidàpa kaa ê ârabwée kêe, â é ina tà tèpa pitèimuru bée pâ: «Jèe pâri! Naaco cè tèpa pitòtié, ba é jèe ipitòtié côwâ! ");
INSERT INTO priNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Ba guwà jèe têreê, na é ina ba èpà Pwiduée ba é nama ipaiwàilu ma wàé. Â dà cèna guwà niimiri naa gooé?» Â rà cau tòpi diri pâ: «Wâdé na é bà!» ");
INSERT INTO priNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Â wà pàra tàpé, âna rà èdurié, â rà târamiri ê naporomee, â rà tòbitié goro îrà. Â rà ina têe pâ: «Wàilàapà na èigà? Gà pinadàra cai, wiàna gà pwi *péroféta na gà tâmogòori diri ê muru!» Â rà popaé wà tèpa wéaa, â rà pitagégéri pûruê. ");
INSERT INTO priNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Napwa wà Pétéru, âna é nye tà tâa niboo gòroigé. Â é tèepaa me tô jè âboro kîri kà pwi ukai kà tèpa pwa ârapwaailò. ");
INSERT INTO priNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Â é côo Pétéru na é gére pwacârau. Â é ucâriê, â é ina têe pâ: «Ée, wâgà kaa, âna gà pwi bée Iésu gée Nazareth!» ");
INSERT INTO priNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Â é tòpi têe pâ: «Bwa! Câgo caa tâmogòorié, â câgo caa tâmogòori ê pwina nümagà na gà ina.» Â géewê, â é pâra dàra ê goropwârawâ goro i gòroigé. {Â, na wàrapwiri, â é to i ja.} ");
INSERT INTO priNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Â wà tôoni, âna é ucâri mwara wà Pétéru, â é jèu ina mwara târa pâ âboro na rà tâa wê, pâ: «Akaé! Wà pwini, âna pwi jè ârapàara tèpa câmu kà Iésu!» ");
INSERT INTO priNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Â é ina mwara wà Pétéru pâ: «Bwa, bwa! Câgo caa tâmogòorié!» Â gée na càùé, â wà tèpa tâa wê, âna rà ina mwara têe pâ: «Akaé! Âjupâra pâ gà pwi jè a câmu kêe! Ba wâgà mwara, âna gà pwi a me gée Galilée!» ");
INSERT INTO priNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Â é nye pigòo kaa wà Pétéru ma ina pâ: «Kaa! Guwà têre, go *ipwataâboro tàwà pâ câgo caa tâmogòori wà pwiibà! Wâdé na é pwa wârimuru tôo wà Pwiduée, wiàna go pwâ!» ");
INSERT INTO priNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Ûna é bwaa gére ina pwiri, â é wailu to i ja. Â é mwa niimiri i pwi ia é ina têe wà Iésu pâ: «Béaa kâra ê pai wailu to kâra i ja, âna gà o wacié pitütôowâri pâ, câgà caa tâmogòorio.» Â é i wà Pétéru. ");
INSERT INTO priNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Ûna po dàuru moo, â rà pitapitirirà naima diri ê wâra pitûâ kà tèpa *Juif—wà tèpa caa kà tèpa pwa *ârapwaailò, ma wà tèpa pitûâ, ma tèpa *dotée goro ê Naèà. Ba nümarà na rà tâmogòori ê pwina rà pwa tà Iésu. Â rà piié, â rà popaé pâdari *Pilato, pwi kupénoo kà tèpa Roma. ");
INSERT INTO priNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Â é tawèerié wà Pilato pâ: «Gona nye wâgà kaa, na gà Pwi Ukai kà tèpa Juif?» Â é tòpi têe wà Iésu pâ: «Gà jèe nye tàgére ina.» ");
INSERT INTO priNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Â wà tèpa caa kà tèpa pwa ârapwaailò, âna wâru ê pâ muru na rà pinatòti Iésu goo. ");
INSERT INTO priNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Â é tawèerié mwara wà Pilato pâ: «Gona nye ticè cèna gà tòpi goo? Gà nye gére têre ê pâ muru na èpà na rà ina naa googà?» ");
INSERT INTO priNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Êco na câé mwa caa tòpi wà Iésu, â é po dau pò gooé wà Pilato. ");
INSERT INTO priNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Napwa Pilato, âna câmaajé têe, na diri pâ naja, na tòotù *Paséka, na é pacòobé gée na karapuu cè pwi jè âboro, na nüma ê Ba gooé. ");
INSERT INTO priNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Â, na naja bèepwiri, â pwa pwi jè âboro, na nee Barabbas, na rà pitànaima na karapuu, ma tèpa bée. Ba rà tétàmwara âboro, na pàara na rà cicara tèpa Roma. ");
INSERT INTO priNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Â rà tèepaa me naa jaa Pilato pâ âboro na wâru, â rà ilari jiié pâ: «Gà pwa ba kâbà, ê muru na jèe nye câmaajé tâgà na gà pwa.» ");
INSERT INTO priNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Â é tòpi tàra pâ: «Gona nümawà na go panuâ côwâ Iésu, ‘pwi ukai kà tèpa Juif’?» ");
INSERT INTO priNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Ba é nye tâmogòori bwàti pâ, wà tèpa caa kà tèpa pwa ârapwaailò, âna rà panuâ têe Iésu, goro pai piboo kàra. ");
INSERT INTO priNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Êco na wà tàpéebà, âna rà cètùu ê pâ âboro, ba na rà ina pâ: «Panuâ tâbà wà Barabbas!» ");
INSERT INTO priNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","É tawèerirà mwara wà Pilato pâ: «Â gona dà cèna go o pwa tà pwina guwà ina gooé pâ ‘pwi ukai kà tèpa Juif’?» ");
INSERT INTO priNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Â rà uu ma tomara too pâ: «Tanamiriê naa goro *kurucé!» ");
INSERT INTO priNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Â é jèu tawèerirà mwara pâ: «Gona dà cèna é pwa cèna èpà?» Êco na rà ina wiikauri pâ: «Tanamiriê naa goro kurucé!» ");
INSERT INTO priNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Â é panuâ tàra wà Barabbas wà Pilato, ba nümee na rà wâdéarié ê pâ âboro. Â é pwa ma pâdi Iésu goro ubati. Â é panuâê tà tèpa coda, ba na rà tanamiriê naa goro kurucé. ");
INSERT INTO priNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Wà tèpa coda, âna rà popa còobé Iésu, naa na gòroigé, kâra ê wâ maina kà kupénoo. Â rà todàra diri ê pé wâra coda. ");
INSERT INTO priNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Â rà piècaarié, â rà pwa ma é coona ê pé ârabwée na dau mii—pwacèwii ârabwée kà pwi âboro imaina. Â rà pàti ê pé bwe korona kêe, goro îri upwâra na pwa daaé, â rà tòpò boo naa gòro pûruê. ");
INSERT INTO priNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Â rà cibèepié, â rà tànyiriê, ma ina têe pâ: «Wée! Cidòri nyuâagà, co ‘Pwi ukai kà tèpa Juif’!» ");
INSERT INTO priNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Â rà nye tà pâdi ê pûruê goro ê bàra watü. Â rà nye tà èdurié, â rà nye tà tùu jùrurà araé. ");
INSERT INTO priNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Ûna nabwé ê pai piècaarié kàra, â rà tòpwùtù gée gooé i ârabwée mii, â rà naagée côwâ naa gooé ê ârabwée kêe. Â géewê, â rà popaé còobé naa gòroigé, ba na rà tanamiriê naa goro i kurucé. ");
INSERT INTO priNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Pwa pwi jè âboro gée na ville Cyrène na nee Simona, pwi caa kà Alexandre ma wà Rufus, âna é me wê, ba é wâjué côwâ gée na aupwanapô. Â rà tacoo gooé wà tèpa coda, ba na é kâa ê kurucé kà Iésu. ");
INSERT INTO priNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Â rà popa Iésu, pâ naa gòro jè ti kâra jaa na ina goo wê pâ Golgota, na pai ina wèe pâ ‘Goro pwiripûru âboro’. ");
INSERT INTO priNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Â wà pàra tàpé, âna rà pinaanaimari ê dipâa bau ê jawé na maga. Â rà naa tà Iésu, êco na nye tàutêe na é wâdo. ");
INSERT INTO priNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","25","Na po 9 ineretòotù na dàuru, âna rà tanamiriê naa goro i *kurucé wà tèpa coda. Â rà càù noo kâra tii, ba na rà tâmogòori pâ, wàilàapà na o popa ê pâ ârabwée kêe, ba na rà o pipâdi naa goorà. ");
INSERT INTO priNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Â rà popa ê ére upwâra, â rà wii naa goo, ê majoro ê pai bà kêe, pâ: iésu, pwi ukai kà tèpa juif. ");
INSERT INTO priNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Â rà tanamiri mwara tupédu a pwa na èpà naa goro jènere wà Iésu—wà pwi jèpwi naa gòro étò kêe; â wà pwi jèpwi naa gòro aèmwü kêe. { ");
INSERT INTO priNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Êkaa na pacoo i pwi ia mara wii naa na *Tii Pwicîri gooé, pâ: Rà naa wârimuru têe; ba rà ina pâ, é pwi a pwa na èpà.} ");
INSERT INTO priNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Wà tàpé na rà paé ma me na ére bèepwiri, âna rà ura ê pûrurà, â rà tànyiri Iésu, â rà ina pâ: «Pwiini, gona càcaa wâgà kaa, na gà o tédidiri i *Wâra pwapwicîri, â gà o pagòtù côwâ naa na âracié tòotù? ");
INSERT INTO priNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Â gà pa-udògà côwâ, ma gà boome gée goro i kurucé bèepwiri!» ");
INSERT INTO priNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","32","Â wà tèpa caa kà tèpa pwa ârapwaailò, ma wà tèpa dotée goro ê Naèà, âna rà pitaurèe goo Iésu mwara. Â rà pi-ina tàra jècaa pâ: «É pi-ina gooé pâ é Pwi Ukai kâjè tèpa *Isaraéla. Â é tâmogòori ma é pa-udò pàra tàpé, êco na câé caa tâmogòori ma é ipa-udòé côwâ! Wiàna é boo gée goro kurucé bèepwiri, â pwiri jè o mwa cèikî naa gooé!» Â nye ipaiwà mwara naa goo tupé na tanamiriru naa goro kurucé, naa goro jènereê. Ba ru nye pitaurèe gooé mwara. ");
INSERT INTO priNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Ûna po gopaé bwàti, â nye po bàutê pitiri ê napô tiagoro na âracié ineretòotù na càùru ija. ");
INSERT INTO priNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Ûna po âracié ineretòotù, â é tomara ba maina wà Iésu pâ: Éloï, Éloï, lama sabakthani? Pai ina wèe pâ: Pwiduée kôo, Pwiduée kôo, cina gà panuâô? ");
INSERT INTO priNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Â càra caa têreê bwàti wà pàra tàpé na rà tâa wê, â rà ina pâ: «Guwà côo, é todà *péroféta Élia!» ");
INSERT INTO priNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Â pwa pwi jè ârapàararà, âna é itàtà, â é popa jè imwaano, â é nuwa naa na ê dipâa na maga. Â é tòpò naa goro bàra upwâra, â é naa tà Iésu, ba na é wâdo. Â é ina tà tèpa bée pâ: «Tàpo tâa, ba pwiri jè o côo wà Élia, na é me, nau naaê boo géenidò goro kurucé!» ");
INSERT INTO priNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Êco na é dau uu too wà Iésu, â nye êgò kaa ôomaa kêe. ");
INSERT INTO priNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Â ê pé ciità maina, na é târiwâri ê ére na dau pwicîri naa na i Wâra pwapwicîri, âna nye tidàpa kaa, tapoo géenidò, tia niboo pwâadèreè. ");
INSERT INTO priNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Â wà pwi caa kâra coda roma na é coo ara Iésu, âna é côo ê pai bà kêe, â é ina pâ: «Âjupâra, wà pwi âboro bèeni, âna é *Pwina naî Pwiduée!» ");
INSERT INTO priNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Pwa pàra ilàri, na rà tâa wê mwara, âna rà tà coo iti, â rà côo pwiri—wàilà ma wà Maria gée Magdala, ma wà Salomé, ma wà Maria, nyaa kà tupédu aéjii José ma Jacques (wà pwina ina gooé pâ ‘Pwi dopwa’). ");
INSERT INTO priNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Wàilà kaa, na rà pâra wiâ Iésu, â na rà pitu têe, ûna é bwaa tâa napô Galilée. Â wâru ê pa pàra ilàri, na rà tâa wê mwara, na rà too wiâê mwara, naa *Iérusaléma. ");
INSERT INTO priNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Diri ê pâ namuru bèepwiri, âna pacoo na papwicî tòotù béaa kâra ê *tòotù pwicîri kà tèpa Juif. Na papwicî, âna rà pwabwàti ê pi-ija târa tòotù pwicîri. Na bàrane, âna é tèepaa me wà Ioséfa, pwi âboro gée Arimathée. Wà pwiibà, âna pwi jè âboro imaina, naa na wâra pitèimuru kà tèpa Juif. Â é pwi a nye tà gòo goro tapacîri ê pai tèepaa me kâra ê *Mwaciri kà Pwiduée. Â é ipagòorié, ba na é pâra naa jaa ukai Pilato, ma ilari jiié i naii Iésu. Ba nümee na é popa ê naiié béaa kâra ê pai tapoo kâra tòotù pwicîri. ");
INSERT INTO priNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Ûna é têre wà Pilato pâ, é jèe bà wà Iésu, â é pò. Â é todà pwi caa kâra coda, â é tawèerié pâ: «Gona jèe gòiri cè pai bà kêe?» ");
INSERT INTO priNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Â é piwiâ têe. Â wà Pilato, âna é naa tàrù tà Ioséfa, ba na é popa i naii Iésu. ");
INSERT INTO priNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Â wà pwiibà, âna é tapwùtù i naii Iésu gée gòro i kurucé. Â é cajipié goro ê ciità na é wâri. Â é popaé, â é tòpòé naa na ê auipwàni—pé pwêe na îri naa na pé atü. Â nabwé, â é pwùru ê jè pé atü maina, â é târiwâri i auipwàni. ");
INSERT INTO priNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Â wà Maria gée Magdala, ma wà Maria nyaa kà José ma Jacques âna ru côo ê ére na tòpò Iésu naawê. ");
INSERT INTO priNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Na capàto na bàrane ûna jèe nabwé ê *tòotù pwicîri kà tèpa *Juif â wà Maria gée Magdala, ma Salomé, ma wà Maria nyaa kà José ma Jacques, âna rà pâ nau wâri ê jawé ûrea, ba na rà wicèpwiri naa gòro ê naii Iésu. ");
INSERT INTO priNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Na pwapwicîri, na bwaa dàuru, na é gére êgòdò tòotù, â rà pâra naa na auipwàni. ");
INSERT INTO priNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","4","Â wii naigé, âna rà gére pi-ina tàra pâ: «Gona wàilàapà na o mwa pwùru i atü goro i pwêe? Ba po dau maina!» Êco na, ûna rà tèepaa pâ, â rà côo pâ jèe pwùru. ");
INSERT INTO priNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Â rà tò naa na i pwêe auipwàni. Â rà côo pwi âboro èpo na é tâa gòro âji îjè, na é coona ê ârabwée gòri na pwaa. Â rà po dau pò, ma wâgotàra. ");
INSERT INTO priNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Êco na é ina tàra pâ: «Guwà cibwaa nama wâgotàwà! Ba go tâmogòori pâ guwà me nau mudà Iésu gée Nazareth, wà pwi ia tanamiriê naa goro *kurucé. Guwà têre, jèe tiàué ni, ba é jèe tàcî gée na aubà, â é jèe wâro côwâ! Ba wàéni ê ére, na ia tòpòé naawê. ");
INSERT INTO priNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Â guwà wâjué côwâ wài, â guwà ina tà Pétéru ma tèpa *câmu kà Iésu pâ, é tapacîwà wâ Galilée wà Iésu. Â guwà o mwa côoê naawê, wàra na ia é jèe ina tàwà.» ");
INSERT INTO priNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Â rà còobé gée na i auipwàni i pa ilàri, â rà itàa pâ. Â po dau dàpàgà tàra, â rà céca. Â càra caa ina târa âboro imudi, ba po dau wâgotàra. ");
INSERT INTO priNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Na pwapwicîri na bwaa dàuru, âna é wâro côwâ gée na aubà wà Iésu. Â é pipaarié béaa tà Maria gée Magdala, wà i tô ilàri, na ia é nama é wâdé na é tü târa ê pâ 7 duée gée gooé. ");
INSERT INTO priNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Â wà tôoni, âna é me, nau piwiâ tà tèpa bée Iésu, ê pwina é côo. Napwa wàilà, âna rà tàgére pijinünü imuru Iésu. ");
INSERT INTO priNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Â é ina tàra wà Maria pâ: «É jèe wâro côwâ wà Iésu! Ba go côoê!» Êco na càra caa cèikî naa gooé. ");
INSERT INTO priNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Pwa tupédu a câmu kà Iésu, âna ru pâra wii naigé, â ru còobé gée na ville. Â é cipàpariru wà Iésu, na jèe ité pai côoê. ");
INSERT INTO priNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Â ru wâjué côwâ, ba na ru piwiâ tà pàra tèpa câmu, êco na wàilà mwara, âna càra caa cèikî naa gooru! ");
INSERT INTO priNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Â bénabwé wèe, âna é pipaarié tà tèpa 11 *apostolo kêe, wà Iésu, na rà bwaa gére ija. Â é pwarà, â é ina tàra pâ: «Po dau gòo ê pûruwà! Tàutàwà na guwà cèikî, na rà ina tàwà pâ, go jèe wâro côwâ!» ");
INSERT INTO priNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Â é ina tàra mwara pâ: «Guwà pâra pitiri ê gòropuu, â guwà inapàpari ê *Picémara Wâdé, târa diri ê pâ âboro. ");
INSERT INTO priNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Â wà pwina é cèikî naa goo, ma *upwaaé, âna ée mwa udò, â o tâa têe ê *âji wâro. Â wà pwina câé caa cèikî, âna ée mwa pitèié wà Pwiduée, ma naa wârimuru têe. ");
INSERT INTO priNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Wàéni pâ câmu kêe naa goo tàpé na rà cèikî: Rà o tü târa ê pâ duée, naa na neeô; Rà o pwa ê pâ pwâratùra na pâ ité; ");
INSERT INTO priNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Rà o cipa ê pâ dòèa naa na îrà; Rà o wâdo cè jawére bà, â o càra caa bà goo; Rà o tòpò ê du îrà naa gò tèpa maagé, â rà o wâdé côwâ.» ");
INSERT INTO priNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Gée na càùru ê pai ina kêe tàra pwiri, â dàgòtù too naa napwéretòotù, wà Pwi Ukai Iésu, â é tâa gòro étò kà Pwiduée ba na é pitûâ wê. ");
INSERT INTO priNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Â wà tèpa câmu kêe, âna rà pâpitiri pâ napô, ba na rà inapàpari ê Picémara Wâdé. Â é pitu tàra wà Pwi Ukai. Â é *paâjupâra ê Popai na rà inapàpari, ba é naa tàra ê pàtàmee, ba na rà pwa ê pâ câmu, na rà pò goo wà tèpa âboro.");
INSERT INTO priNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","3","Bwàcu'gà, co pwi ukai Théophile. Go wii ê tii bèeni, ba na go piwiâ tâgà diri pâ muru na é jèe pwa wà Pwiduée naa jaabà, gée na càùru pai pitèpa wà Iésu. Wâru tèpa *paâjupâra na rà côo pâ muru bèepwiri, â rà inapàpari, â rà picémara ê *Picémara Wâdé. Â wà pàra tàpé, âna pwa na rà piwiâ naa na tii. Â wâgo mwara, âna go mudàra bwàti, ba na go wii tòimiri ê jèkutâ ba kâgà, goro diri pâ muru bèepwiri. ");
INSERT INTO priNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Ba na wàrapwiri, âna gà o mwa bàra côoina pâ âjupâra ê popai na ia gà tòpi. ");
INSERT INTO priNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Na pàara na é ukai naa *Judée wà Héroda, âna pwa pwi jè âboro wê, na ina gooé pâ Zakaria. É pwi a pwa ârapwaailò, gée na pubu kà Abia. Â napwa tô wâdèe, Élisabeth, âna tô gòobàra *Arona. ");
INSERT INTO priNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Â cau wàilu, âna ru *tàrù na ara Pwi Ukai Pwiduée. Ba ru pitêre dàra diri pâ naèà, ma ê pâ pitûâ kêe, â nye ticè cèna pâri ma pitèiru goo. ");
INSERT INTO priNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Êco na nye ticè èpo kàru, ba càcaa pâri ma é pièrù wà Élisabeth. Â jèe cau pwanümaru. ");
INSERT INTO priNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Na jè tòotù, â wà Zakaria, âna é pwa wakè kêe na *Wâra pwapwicîri kà Pwiduée. Ba nye tòotù na rà wakè na i pubu kêe. ");
INSERT INTO priNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Wiâra ê pai pwa kà tèpa pwa *ârapwaailò, â rà picàù noo kâra tii, ba na rà pitòrigari pwi âboro gée goorà, na ée tò naa na ére na dau pwicîri, naa na Wâra pwapwicîri. Â naawê, âna é cîri encens pâ dà na ûrea na jè cîri ba na âraimeai tà Pwiduée. Â, na tòotù bèepwiri, âna wâru noo kâra tii kà wà Zakaria. Â é too nau pwa ê wakè kêe. ");
INSERT INTO priNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Â, na é gére cîri i encens naa gò béreca â dau wâru tèpa âboro na rà gére pwapwicîri boo gòroigé. ");
INSERT INTO priNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Ûna é gére wàrapwiri wà Zakaria â é nye cipàparié kaa, wà pwi jè *angela kà Pwi Ukai, na é coo gòro étò kâra i béreca. ");
INSERT INTO priNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Â é pò wà Zakaria, â dau wâgotêe, â é pwùkùru. ");
INSERT INTO priNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Êco na é ina têe wà pwi angela pâ: «Gà cibwaa nama wâgotâgà, co Zakaria! Ba é jèe têre ê pwâra pwapwicîri kàu wà Pwiduée. Â wà tô wâdàgà, âna ée mwa nyarana, â ée mwa pitàmari pwi èpo'gà, â gà mwa pitunee têe pâ Ioane. ");
INSERT INTO priNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Â gàu mwa puràra, ma ipwàdée. Â o mwa wâru mwara tàpé na rà o ipwàdée goo. ");
INSERT INTO priNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Ba wà pwina naîgà, âna ée mwa pâ nau pwi âboro na dau imaina na ara Pwi Ukai. Â o pwicîri na é wâdo dipâa ma cè jawé gòo. Ba ée jèe nye dipitirié kaa ê *Nyuâaê Pwicîri na é bwaa tâa nanaa nyaa kêe. ");
INSERT INTO priNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","«Dau wâru tàpé gée na ê Ba *Isaraéla, na ée mwa tòimirirà, ba na rà wâjué côwâ dari Pwi Ukai, Pwiduée kàra. ");
INSERT INTO priNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","O tâa gooé ê pàtàmara ê Nyuâaê Pwicîri, pwacèwii *péroféta Élia biu. Â ée mwa tòimiri ma pwabwàti ê Ba kêe, béaa kâra pai tèepaa kà Pwi Ukai. Ba o càcaa gòiri, â ée jèe tèepaa. Â gée goo pwina naîgà, âna wà tèpa caa, âna rà o naa nümarà naa goo tèpa naîrà. Â wà tàpé na càra caa pitêre dà Pwiduée, âna rà o mwa pinünüma, pwacèwii tèpa âboro na rà *tàrù na ara Pwiduée.» ");
INSERT INTO priNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","É ina wà Zakaria tà pwi angela pâ: «Go wànau târa pai cèikî kôo, naa goo ê pwina gà ina? Ba go jèe po dau ijiao, â wà mwara wâdòo, âna é jèe jiitàmu.» ");
INSERT INTO priNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Â é tòpi têe pâ: «Ico pwini! Wâgo, âna wâgo angela Gabriel, â go pwi a coo ara Pwiduée, ba na go piâboro kîri kêe. Â wàé na é cùruo me, ba na go inapàpari tâgà ê popai wâdé bèeni. ");
INSERT INTO priNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Wâdé na gà tâmogòori pâ, diri ê pâ muru na go ina tâgà, âna o mwa tèepaa, na pàara na é jèe tòpò wà Pwiduée. Êco na wâgà, âna câgà caa cèikî naa goo! Â gà côo, gà o cîô, tiagoro ê tòotù na o mwa coo diri ê pwina go ina tâgà!» ");
INSERT INTO priNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Na pàara na ru gére pitùra na, wà Zakaria ma wà pwi angela, âna rà gére tapacîê wà tèpa âboro. Â rà pò ma pitawèerirà pâ, cina gòrié dò wâ. ");
INSERT INTO priNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Ûna é mwa bàra còobé gée na ére na dau pwicîri âna é jèe cîô. Â é po pwa ineremuru tàra, goro îê. Â rà pâra na tâmogòori pâ pwa cè pwina é côo, cèna me gée goo Pwiduée. ");
INSERT INTO priNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Nabwé, â é tubanabwé ê wakè kêe wà Zakaria, naa na i Wâra pwapwicîri, â é pâra naa pwârawâ kêe. ");
INSERT INTO priNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Gée na càùé, â wà tô wâdèe Élisabeth, âna é nyarana. Â é nye tà tâa pwârawâ naa na 5 parui. Â é nye tà niimiri pâ, ");
INSERT INTO priNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","‘É dau wâdé ba kôo wà Pwi Ukai. Ba ia go po dau kamu, ba nye tô a ticè èpo kôo. Â é meaario, â é jèe dàgòtù ê pwâra kamu kôo.’ ");
INSERT INTO priNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","É jèe nyarana wà Élisabeth naa na 6 parui. Â, na pàara bèepwiri, â wà Pwiduée, âna é panuâ wà pwi angela kêe, wà Gabriel, naa Nazareth wâ Galilée, ");
INSERT INTO priNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","naa jaa tô jè èpo ilàri, na nee Maria. Wà tôobà, âna ru ipwa câbawâdé ma wà pwi âboro, na ina gooé pâ Ioséfa, pwi gòobàra pwi ukai *Davita. ");
INSERT INTO priNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Â é piâpàparié pwi angela, â é ina têe pâ: «Cidòri nyuâagà, co Maria! Ba wà Pwi Ukai Pwiduée, âna é jèe *pwényunyuâarigà goro ê pimeaari kêe, â é wâjaagà.» ");
INSERT INTO priNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Â é pò wà Maria, ba câé caa tâmogòori ê pwina é ina têe. Â é pinünüma ma pitèi pâ: ‘Cina é pacidòri nyuâaô wà Pwiduée?’ ");
INSERT INTO priNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Â é ina têe wà pwi angela pâ: «Gà cibwaa nama wâgotâgà, co tôoni! Ba é ipwàdée googà wà Pwiduée, â é pitòrigarigà. ");
INSERT INTO priNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Â gà o nyarana, â gà o pitàmari pwi nari èpo paao, â gà mwa pitunee têe pâ Iésu. ");
INSERT INTO priNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Wàé, âna wàé pwi âboro na dau imaina na ara Pwiduée. Â o pitunee têe pâ ‘*Pwina naî Pwiduée na é dau wâdòiti’. Â wà Pwiduée, Pwi Ukai kêe, âna ée mwa naa têe ê pwâra ukai kà Davita, pwi jojooroé. ");
INSERT INTO priNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Â ée pwi ukai kâra Ba Isaraéla dàra gòiri awé. Â ê pitûâ kêe, âna o nye ticè pwâadèreè.» ");
INSERT INTO priNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Â é ina wà Maria tà pwi angela pâ: «Gona êpwiri, âna o wànau târa cè pai tèepaa wèe?! Ba câbu caa pé ipuu ma pwi éao, ma cè pwi jè paao!» ");
INSERT INTO priNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","É tòpi têe wà pwi angela pâ: «Ê Nyuâaê Pwicîri, âna ée mwa boome naa gògà, â ê pàtàma Pwiduée na é dau wâdòiti, âna ée mwa wâjaagà. Â ê pwi nari èpo na gà o mwa pitàmariê, âna wàé kaa na é pitòrigarié wà Pwiduée, â o mwa ina gooé pâ Pwina naî Pwiduée. ");
INSERT INTO priNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","«Gà côo, wà tô jèneregà, Élisabeth, na ia jèe mu ina naa gooé pâ: “O jèe càcaa pitàmari”! Êco na ée mwa pitàmari pwi jè nari èpo. Ba é gére nyarana ni—jèe 6 parui kêe. ");
INSERT INTO priNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Ba nye ticè cèna pwacoé tà Pwiduée!» ");
INSERT INTO priNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Â é tòpi têe wà Maria pâ: «Go tô ênawéna kà Pwi Ukai. Â go nye pwa co ê câbawâdé kêe!» Â, na wàrapwiri, â é còpòo jiié i pwi angela. ");
INSERT INTO priNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","40","Pàra tòotù gée na càùé, â é piwàcî pâ wà Maria, nau cai wà Élisabeth. (Ê village kêe, âna é tâa gòrojaa na jè ére gée goo Judée.) ");
INSERT INTO priNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Ûna é têre pwâra pwabwàcu kà Maria wà Élisabeth, â é nye gù kaa i pwi èpo naa nanaaê. Â wà Élisabeth, âna nye dipitirié kaa ê Nyuâaê Pwicîri, ");
INSERT INTO priNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","â é tomara too pâ: «Wà Pwiduée, âna é dau pwényunyuâarigà jii diri pa èpo ilàri, â é pwényunyuâari mwara ê èpo bèepwiri gére wâgoogà! ");
INSERT INTO priNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Po dau muru na maina ba kôo! Ba gà me naa jaao, wâgà tô nyaa kà Pwi Ukai kôo! ");
INSERT INTO priNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","«Gà côo co tô béeò, ûna go têre pwâratùra'gà, â é ipwàdée i pwi èpo kôo, â é gù ni nanaaô! ");
INSERT INTO priNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Cidòri nyuâagà! Ba gà jèe cèikî pâ, ée mwa pacoo ê pwina é ina tâgà, wà Pwi Ukai.» ");
INSERT INTO priNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","É ina wà Maria pâ: «Ipwàdée pwâranümoo! Go pwamaina Pwi Ukai! ");
INSERT INTO priNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Puràra pwâranümoo! Ba é upao gée na èpà wà Pwiduée Caa. ");
INSERT INTO priNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","É câbapwamuru naa gooò, tô ênawéna kêe, na go po dau kîri. Rà o cau ina pâ: “Pwényunyuâari wà tôoni!” ");
INSERT INTO priNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","É paari nii kêe wà Pwina é dau maina. É pitu tôo goro îê étò, wà Pwina é pwicîri. ");
INSERT INTO priNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Maina pai wâdé kêe, dàra gòiri awé, ba kà tèpa âboro; tà tàpé na rà papwicîriê. ");
INSERT INTO priNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","É wakè goro pàtàmee. Tadidiri tèpa cuâcâda. ");
INSERT INTO priNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Téura pwâra ukai, kà tàpé na rà maina. Caa pagòtù too tàpé na rà kîri. ");
INSERT INTO priNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","É naa neemuru tàpé na ticè kàra. É pawâjuépiri tàpé na pwa kàra, ma ticè êre îrà. ");
INSERT INTO priNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","É pitu târa Ba kêe, pwi Ba Isaraéla, pwi ênawéna kêe. É ciburà meaarié. ");
INSERT INTO priNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","É ipwataâboro tà tèpa jojoorojè, tà *Abéraama, ma tèpa gòobèreè diri. É pacoo auina kêe, dàra gòiri awé. Nabwé!» ");
INSERT INTO priNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Wà Maria, âna é tàpo tâa jaa Élisabeth, naa na âracié parui. Â géewê, â é wâjué naa jaaé. ");
INSERT INTO priNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Tèepaa naa na pàara na ée pitàmari èpo na, wà Élisabeth, â é pitàmari pwi âboro èpo paao. ");
INSERT INTO priNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Â wà tèpa tàmwünyabwerié ma wà tèpa jènereê, âna rà têre pâ é pwényunyuâariê wà Pwi Ukai. Â rà capai ipwàdée diri, naima ma wàé. ");
INSERT INTO priNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Â gée na càùru caapwi nadàpàra pwapwicîri, â rà me, ba na rà pwa *kamaî tà i pwi nari èpo wiâra ê *Naèà kà Moosé. Â nümarà na rà naa têe i nee caa kêe, wà Zakaria, ");
INSERT INTO priNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","êco na é ina tàra wà tô nyaa kêe, pâ: «Bwa, o pitunee têe pâ Ioane.» ");
INSERT INTO priNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Â rà ina têe pâ: «Gorodà? Nye ticè jèneregà, cèna é popa ê neere âboro bèepwiri.» ");
INSERT INTO priNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Â rà po pwa ineremuru tà pwi caa kêe, Zakaria, ba na rà tawèerié pâ, o nümee na é picipa nee. ");
INSERT INTO priNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","65","É pwa ineremuru tàra wà Zakaria, ba na rà naa têe ê noo kâra tii, ba na é pwa tii naa na. Â é wii pâ ‘Ioane’. Â géewê, âna é nye tùra côwâ kaa, â é pwamaina Pwiduée. Â rà pò diri tàpé na rà têreê â wâgotàra. Â rà piwiâ ê jèkutâ goo, na diri pâ ére wâ gòrojaa, wâ napô Judée. ");
INSERT INTO priNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Â wà diri tàpé na rà têre ê popai bèepwiri, âna rà dau pinünüma, â rà ina pâ: «Ée! O po dau maina awé ê pwina ée mwa pwa, wà pwi nari èpo bèepwiri!» Ba wà Pwi Ukai, âna é wâjaaé. ");
INSERT INTO priNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Wà Zakaria, pwi caa kà i pwi nari èpo, âna dipitirié ê Nyuâaê Pwicîri, â é inapàpari ê popai na é naa têe wà Pwiduée. Â é ina pâ: ");
INSERT INTO priNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","«Pwamaina Pwi Ukai, Pwiduée kâra ê Ba, ê Ba Isaraéla. Ba é pa-udòjè, tipijè jii èpà kâjè. ");
INSERT INTO priNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Dau pwa pàtàma wà pwi a-upajè, pwi gòobàra Davita, pwi ênawéna kêe. ");
INSERT INTO priNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Jèe nye gòiri ê pai ina kêe pwiri. Ba rà inapàpari tèpa péroféta na é pitòrigarirà. ");
INSERT INTO priNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Ba é jèe ina pâ: “Go o mwa pa-udòwà jii tèpa pièpàriwà.” ");
INSERT INTO priNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Maina pimeaari kêe tà tèpa jojoorojè. É nye pacoo diri kaa auipwataâboro kêe, ");
INSERT INTO priNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","na é naa tà Abéraama, wà pwi jojoorojè, naa na pimeaari kêe. É gére ina naa goojè, pâ: ");
INSERT INTO priNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","“Go upa tèpa naîgà, jii tèpa pièpàrirà. Rà o piênawéna kôo; o càcaa wâgotàra. ");
INSERT INTO priNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Rà o wâdé na arao, â o tàrù pwâranümarà, na diri pai wâro kâra wâni gòropuu.” Nabwé.» ");
INSERT INTO priNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Â wà Zakaria, âna é pame ê popai bèeni goo wà pwina naîê, Ioane: «Wâgà pwi nari âboro èpo bèeni, âna: Gà o pwi Péroféta: Gà o ipa popai kà Pwiduée Caa, na é tâdòiti. Gà o pâbéaa kà wà Pwi Ukai; pwabwàti naigé kêe. ");
INSERT INTO priNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Gà o ina târa Ba kêe: Ée mwa pa-udòwà, ba na guwà wâro. Ée mwa pwanauri ê pâ èpà kàwà. ");
INSERT INTO priNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Maina pai wâdé kêe! É tèepaa marijè; é pame ê pwéelaa, pwacèwii pai tèepaa kâra dapàra tòotù. ");
INSERT INTO priNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","É èù mari tàpé na rà tâa na bàutê, bàutê kâra pwâra bà. É tòcia tàra naigé naa na pinaanapô. Nabwé.» ");
INSERT INTO priNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Wà i pwi âboro èpo, Ioane, âna é pimaina too, â pimaina pâ ê pàtàmara Nyuâaê Pwicîri naa gooé. Â é wâro namaré, tèepaa naa goro i pwi tòotù, na ée mwa ipaarié târa pwi Ba Isaraéla. ");
INSERT INTO priNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","2","Na pàara napô bèepwiri, âna é pwi kupénoo na Syrie wà Quirinius, â wà Auguste, âna é pwi ukai kà tèpa *Roma. Â é tûâri wà Auguste pâ, na pûra diri ê jéûru âboro wâna diri pâ napô na tâa na ê pwâra ukai kêe. (Â mwa nye piêcè kaa na rà pwa pwi bèepwiri.) ");
INSERT INTO priNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Â diri ê pâ âboro, âna rà jèpa ipiina naa na jèpa village ma ville kà tèpa jojoororà, ba na rà wii ê neerà. ");
INSERT INTO priNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","5","Napwa naa goo wà Ioséfa, âna é còpòo gée Nazareth wâ Galilée, ba na é pâra naa Bétéléma wâ napô *Judée, nau wii ê nee. Ba ia é pitèpa naawê wà ukai *Davita, wà pwi jojooroé. Â é popa wiâê wà Maria, tô wâdèe, na é gére nyarana, ba é tapacî pwi ciiri èpo kêe. ");
INSERT INTO priNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Na ru tâa Bétéléma, â tèepaa me pàara, na ée jèe pitàmari èpo wà Maria. ");
INSERT INTO priNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Â é pitàmari pwi ciiri èpo kêe. Â é cajipié naa na pé kupétuu, â é papuué naa na aunaa uti kâra macii, ba ticè autâa kàru ba po dau wâru âboro. ");
INSERT INTO priNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Na pwi bàrane-bà, na pwi jè ére gòrojaa géewê, âna pwa tèpa âboro na rà wéaari pâ mutô kàra naawê. ");
INSERT INTO priNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Â é nye tèepaa me kaa, pwi jè *angela kà Pwi Ukai, â é coo ararà. Â nye pwéelaa bèepirà kaa ê muugère kà Pwi Ukai. Â nye dau wâgotàra kaa. ");
INSERT INTO priNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Â é ina tàra wà pwi angela pâ: «Guwà cibwaa nama wâgotàwà. Ba go pame tàwà ê popai na wâdé; popai na rà o dau ipwàdée goo, wà diri tèpa âboro! ");
INSERT INTO priNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Ba na pwi ne bèeni, âna pitèpa *pwi a pa-udòwà, naa na village kà Davita. Âna wà pwi *Mesia, Pwi Ukai na ia guwà tapacîê gée na biu. ");
INSERT INTO priNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Wàéni câmu, ba na guwà o côoinaê: Guwà o pâmari ê ji nari èpo na cajipié goro pé kupétuu, â papuué naa na aunaa uti kâra macii.» ");
INSERT INTO priNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Na nye wàrapwiri kaa, â rà nye tèepaa boome kaa gée *napwéretòotù, pàra tèpa angela na rà dau wâru. Â rà cibèepi i pwi angela. Â rà nyabi ma ipwamaina Pwiduée: ");
INSERT INTO priNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","«Ipwamaina Pwiduée, nidò naa napwéretòotù! Bèe ma dàrébòo naani gòropuu! Moo ma awé ba kà diri tàpé na wâdé têe wàilà!» ");
INSERT INTO priNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Gée na càùé, â wà i tèpa angela, âna rà còpòo jii tèpa wéaari mutô, â rà wâjué too côwâ naa napwéretòotù. Â wà tèpa wéaari mutô, âna rà pi-ina tàra pâ: «Jè pâra naa Bétéléma, ma jè jèe côo cai ê pwina tèepaa, na é gére ina tâjè wà Pwi Ukai.» ");
INSERT INTO priNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Â rà nye piwàcî kaa, â rà pâmari wà Maria, ma wà Ioséfa, ma i ji pwi nari èpo na é gére puu na ê aunaa uti kâra macii. ");
INSERT INTO priNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Ûna rà côoê, â rà pâra nau piwiâ târa diri ê pâ âboro, i pwi ia é ina tàra wà i pwi angela. ");
INSERT INTO priNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Â wà diri tàpé na rà têre, âna rà dau pò goo. ");
INSERT INTO priNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Â wà Maria, âna é nye po tàmaari diri ê pâ namuru bèepwiri, â é dau pinünüma naa goo. ");
INSERT INTO priNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Nabwé, â wà i tèpa wéaari mutô, âna rà wâjué côwâ dari ê pubu macii kàra. Â rà dau nyabi ma pwamaina Pwiduée, goro diri ê pâ muru na rà côo ma têre. Ba nye po cau coo diri, i pwi ia é ina tàra wà i pwi angela. ");
INSERT INTO priNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Gée na càùru caapwi nadàpàra pwapwicîri, â wà Ioséfa ma Maria, âna ru popa pâ i pwi èpo kàru, ba na pwa *kamaî têe, wiâra ê *Naèà kà Moosé. Â ru nama nee pâ Iésu, i pwi neere âboro na ia é jèe mara ina i pwi angela, béaa kâra ê pai nyarana kà Maria. ");
INSERT INTO priNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","24","Tèepaa me ê pàara, na wà Maria, âna é pwa i *ârapwaailò târa pai pinuwa gée na càùru pai pitàmari èpo kêe. Ba jèe wii naa na Naèà kà Moosé pâ: Wâdé na é naa du ârailu déamu, é, du ârailu déajée. Êkaa na ru pâ naa na *Wâra pwapwicîri na *Iérusaléma wà Maria ma wà Ioséfa, ba na ru wàrapwiri. Â ru popa pâ wiâru mwara i èpo kàru, ba na ru naaê tà Pwi Ukai. Ba jèe wii mwara naa na ê Naèà kà Pwi Ukai, pâ: Wà pwi ciàra èpo paao, âna kà Pwi Ukai. ");
INSERT INTO priNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Na pwi pàara bèepwiri na Iérusaléma, âna pwa pwi jè âboro na nee Siméon, pwi âboro na é tàrù, ma pitòimiriê na ara Pwiduée, â tâa gòé ê Nyuâaê Pwicîri. Â é nye tà tapacîri ê pai tèepaa kà pwi Mesia pwi a pa-udò ê Ba *Isaraéla. ");
INSERT INTO priNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Â é ina têe ê Nyuâaê Pwicîri pâ: «Gà têre co Siméon, gà o bwaa nye côo pai tèepaa kà pwi Mesia kà Pwi Ukai Pwiduée, béaa kâra pai bà'gà!» ");
INSERT INTO priNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Â é cùrué pâ naa na i Wâra pwapwicîri. Â nye na ji pwi pàara bèepwiri kaa, na wà du nyaa ma caa kà Iésu, âna ru gére popa me i èpo kàru, ba na ru paarié tà Pwi Ukai wiâra ê Naèà. ");
INSERT INTO priNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Â wà Siméon, âna é tàma i pwi nari èpo, â é pwamaina Pwiduée, ma ina pâ: ");
INSERT INTO priNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","«Nabàni, co Pwi Ukai, âna go ipwàdée wâgo pwi ênawéna'gà! Gà popao naa jaagà naa na pinaanapô'gà. Ba gà jèe pacoo auinabéaa'gà. ");
INSERT INTO priNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","31","Gà cùrué me naa jaabà pwi a pa-udò diri ê pâ Ba; Â go jèe côoê, wàé. ");
INSERT INTO priNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Pwi pwéelaa kâra ê gòropuu diri. Pwényuâa kâra ê Ba, ê Ba'gà, Isaraéla.» ");
INSERT INTO priNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Wà du nyaa ma caa kâra i èpo, âna ru pò goo ê pwina é ina naa gooé wà Siméon. ");
INSERT INTO priNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Â nabwé, â é *pwényu-nyuâariru, â é ina tà Maria, pâ: «Ê pwi èpo'gà, âna ée mwa pwi câmu kâra ê Ba Isaraéla. Â o wâru tàpé na rà o cicaraé, â rà o pâiti jii Pwiduée. Â o wâru mwara tàpé na rà o cimadò gée gooé ma rà o pâmari Pwiduée. ");
INSERT INTO priNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Â o mwa pwéelaa goo ê pâ aunünüma na wâbinyiri kà tèpa âboro. Â napwa naa googà, co tôoni, âna gà o nye dau maagé côo gooé, pwacèwii na tòtée pwâranümagà goro tàuwa.» ");
INSERT INTO priNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","37","Na pwi pàara bèepwiri, âna é tâa na Wâra pwapwicîri wà tô jè ilàri *péroféta, na nee Anne, tô èpo kà Phanuel, gée na wâao kà Asser. (Wà tôoni, âna ru pitâa ma wà pwi éaé naa na 7 naja, â é bà jiié. Â é jèe jiitàmu naa na ê pai dàpwà kêe. Â jèe po 84 naja kêe nabà.) Â é mu nye tà tâa na Wâra pwapwicîri, naa ne ma pwaa. Â é piênawéna tà Pwiduée naa na *ipwanya—é panuâ ija, ba na é pwapwicîri bwàti. ");
INSERT INTO priNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Â é tèepaa me, na pwi pàara na rà tâa wê wà Siméon, ma wà ji pwi nari èpo, ma wà du nyaa ma caa kêe. Â é pwapwicîri wà Anne, ma pwaolé tà Pwiduée. Â é pwa jèkutâ goo Iésu tà diri tàpé na rà tapacîri ê pai tèepaa me kà pwi Mesia, ba na é upa Iérusaléma. ");
INSERT INTO priNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Wà du nyaa ma caa kà Iésu, âna ru pacoo ê pwina ina naa na Naèà kà Pwiduée—muru na mu pwa naa tèepaa ê nari èpo. Ûna ru gére pacoo diri, â ru wâjué côwâ naa jaaru, naa Nazareth wâ napô Galilée. ");
INSERT INTO priNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","É pimaina too Iésu, i pwi nari èpo, naa na pai tâmogòorimuru, ma tàmanga. Â ê *aupwényunyuâari kà Pwiduée, âna nye tà wâjaaé. ");
INSERT INTO priNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","42","Nye câmaajé tà du nyaa ma caa kà Iésu, na ru pâra naa Iérusaléma, na diri ê pâ naja, naa goro pwapwicîri, na tòotù *Paséka. Ûna 12 naja kà Iésu, â é pâra wiâru. ");
INSERT INTO priNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Gée na càùru ê pwapwicîri, â ru jèe wâjué côwâ, êco na, napwa naa goo Iésu, âna é tà tâa Iérusaléma. Â tà càru caa côo pâ tiàué, ");
INSERT INTO priNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","ba ru tà niimiri pâ, é wâjaa pàra tèpa béerà goro pâra wii naigé. Êco na, gée na càùru caapwi tòotù, â ru côo pâ tiàué. Â ru tapoo mudèe, nabibiu kà tèpa jènereru ma tèpa béeru. ");
INSERT INTO priNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Ûna càru caa pâmariê â ru wâjué côwâ naa Iérusaléma nau mudèe. ");
INSERT INTO priNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Na béâracié kâra tòotù, â ru mwa pâmariê naa na Wâra pwapwicîri, na é gére tâaboo naa nabibiu kà tèpa pacâmu tèpa *Juif. Ba é gére têrerà ma pitawiârà goro ê *Tii Pwicîri. ");
INSERT INTO priNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Â wà diri tàpé na rà têreê, âna rà po dau pò goo pai tàmanga kêe ma pai tòpi kêe. ");
INSERT INTO priNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Ûna ru côoê wà du nyaa ma caa kêe, â ru nye dau pò kaa gooé, â é ina têe nyaa kêe pâ: «Pwiini, gorodà na gà pwa tâbu na wàrapwiri? Gà côo, wàibu ma caa'gà, âna dau wâgotâbu. Â bu wâjué côwâ, ba na bu mudàgà!» ");
INSERT INTO priNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Â é tòpi tàru pâ: «Gorodà na gàu mudòo? Gona gàu ipwanauri pâ, wâdé na go wakèri ê pâ neemuru Caa kôo? Êkaa na go wâni na wâ kêe.» ");
INSERT INTO priNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Êco na càru caa tâmogòori ê pwina é pwa na é ina tàru. ");
INSERT INTO priNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Gée na càùé, â rà wâjué côwâ ma wàé naa Nazareth. Â é nye dau pitêre dà du nyaa ma caa kêe. Â wà nyaa kêe, âna é nye tà naa nümee naa goo diri ê pâ muru bèepwiri. ");
INSERT INTO priNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Â é pimaina too wà Iésu, â imaina mwara ê autâmogòorimuru kêe. Â rà dau wâdéarié wà Pwiduée, ma wà mwara tèpa âboro. ");
INSERT INTO priNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Jèe 15 naja, na é pwi ukai kà tèpa *Roma wà Tibère. Â, na pwi pàara bèepwiri, âna wà Ioane, âna é tapoo inapàpari ê popai kà Pwiduée. Wàilà-ni tèpa kupénoo kà ukai Tibère napwiri: Wà Ponce Pilato, kupénoo naa napô Judée; Wà *Héroda Antipas, naa Galilée; Wà Filipo (pwi aéjii kà Héroda Antipas) naa Iturée ma tia Traconite; Wà Lysanias, naa Abilène. ");
INSERT INTO priNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Â wà Hanne ma wà Caïphe, âna ru du *ukai kà tèpa pwa ârapwaailò. Â naa na pàara bèepwiri, âna wà Ioane, pwina naî Zakaria, âna é tâa namaré. Â é patùraé wà Pwiduée, ba na é inapàpari ê popai kêe. ");
INSERT INTO priNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Wà Ioane, âna é pâ naa na diri ê pâ ére gée goo nairiwâ Ioridano. Â é inapàpari tà tèpa âboro pâ: «Guwà pinünüma ma guwà biiwà. Â guwà pwa ma *upwaawà, ba na paari pâ pitòotéri ê wâro kàwà. Â, na wàrapwiri, â ée mwa pwanauri ê pâ èpà kàwà wà Pwiduée.» ");
INSERT INTO priNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Ba jèe wii naa na tii kà *péroféta Isaia pâ: Pwa pwi âboro naa namaré na é tomara too: “Ée me Pwi Ukai! Pwabwàti ê naigé! Pwa ma bàracaari pwi ére na ée pâ wê! ");
INSERT INTO priNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","O pwaai pâ autâgòro; tébapuu nyi autoo; tébatàrù aucùu naigé; tébabàracaari aupâra kêe. ");
INSERT INTO priNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Rà o côo pâ âboro pàtàma Pwi Ukai. É me nau pa-udòjè, wà Pwiduée Caa.” Ésaïe 40.3–5 ");
INSERT INTO priNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Wâru pâ âboro na rà medari Ioane, ba na é upwaarà naa nairiwâ. Â é ina tà pàra tàpé gée goorà pâ: «Guwà tèpa nari dòèa, ma tèpa pwâ! Wàilàapà na ina tàwà pâ, guwà o udò jii ê pitèimuru ma wârimuru, na ée mwa naa tàwà wà Pwiduée? ");
INSERT INTO priNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Bwa! Guwà mara pwa cè tûâ cèna wâdé, târa ma o paari pâ guwà jèe pitòotéri ê wâro kàwà! Â gona guwà tà niimiri pâ, guwà udò, gée goo na wà *Abéraama, âna é pwi jojoorowà? Bwa! Piticèmuru naa goo. Ba wiàna nümee, â o pâri wà Pwiduée ma é bii ê pâ atü bèeni, ma rà o tèpa gòobàra Abéraama! ");
INSERT INTO priNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","«É jèe tà pwabwàti ê gi kêe wà Pwiduée. Â ée mwa tépàgà naa na wàé diri ê pâ upwâra na càcaa wâdé ê pâ pwêe, â ée mwa cîri naa na ânye!» ");
INSERT INTO priNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Ê auwâru gée goo tàpé na rà têre Ioane, âna rà tawèerié, pâ: «Dà cèna o pâri ma bà pwa, ma bà o pitòotéri ê wâro kâbà?» ");
INSERT INTO priNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Â é tòpi tàra pâ: «Wiàna ârailu ârabwée'gà, â gà naa jèpwi tà pwina ticè têe. Â wiàna pwa utimuru'gà, â gà naa tà pwina ticè têe.» ");
INSERT INTO priNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Â pwa pàra tèpa *tò mwani wâripû, na rà me mwara, ba na é upwaarà wà Ioane. Â rà tawèerié pâ: «Pwi a pwa pupûra, dà cèna o pâri ma bà pwa?» ");
INSERT INTO priNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Â é tòpi tàra pâ: «Na guwà tò mwani wâripû ba kà tèpa Roma â guwà cibwaa popa ba kàwà cè mwani cèna piwéna jii ê âji wâripû.» ");
INSERT INTO priNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Â wà mwara pàra tèpa coda, âna rà tawèeri Ioane pâ: «Â wàibà, âna o dà cèna bà o pwa?» Â é tòpi tàra pâ: «Guwà naaco pai pwa kàwà na èpà tà tèpa âboro. Guwà cibwaa pwa kûu tàra, â guwà cibwaa tacoo goorà, ba na rà naa mwani tàwà. Wâdé na guwà ipwàdée co goro ê wâriwà.» ");
INSERT INTO priNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Êdiri tèpa âboro, âna rà tapacîri naa na ipwàdée cè pwina o tèepaa, â rà pitawèerirà jècaa pâ: «Gona wà Ioane, âna pwiri nye wàé kaa pwi *Mesia —wà *pwi a pa-udò na jè tapacîê gée na biu?» ");
INSERT INTO priNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Â wà Ioane, âna é inapàpari tàra diri pâ: «Wâgo, âna go upwaawà goro jawé. Êco na wà pwina ée mwa me pwicò kôo, âna dau pwa pàtàmee jiio. Â càcaa pâriô, ma go tipi ê otàpwe goro ê du wâraâê ba é Pwi Ukai. Â wàé, âna ée mwa upwaawà goro ê Nyuâaê Pwicîri ma ânye. ");
INSERT INTO priNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Â é jèe nye tà pwabwàtié, ba na é pitèi tèpa âboro. Â ée mwa naaitiri tàpé na rà wâdé jii tàpé na rà èpà, pwacèwii pai pinaaitiri ê pudòro upwâra jii ê parawée. Â é tòimiri ê pudòé, â é cîri parawée naa na ânye na ticè pwâadèreè.» ");
INSERT INTO priNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Wâru pai pwa kà Ioane na wàrapwiri, târa ma é patùra ê Ba kà tèpa *Juif ma inapàpari tàra ê *Picémara Wâdé. ");
INSERT INTO priNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Wà Ioane, âna é jèe ciburà ina tà kupénoo Héroda pâ, càcaa wâdé ê tûâ kêe. Ba ru ipâra ma Hérodiade, tô wâdà pwi aéjii kêe, â wâru mwara pàra muru na èpà na é pwa. ");
INSERT INTO priNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Â gée goo ê pwina é ina wà Ioane, â é tòpòé naa na karapuu wà Héroda. Â, na wàrapwiri, â wà Héroda, âna é âjagò mwara goro ê pâ tûâ kêe na dau èpà. ");
INSERT INTO priNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Na pàara na é upwaa wà tèpa âboro na wà Ioane, â wà mwara Iésu, âna upwaaé. Ûna é gére pwapwicîri, â nye tàpiri kaa ê napwéretòotù, ");
INSERT INTO priNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","â é nye boome kaa naa gòé ê Nyuâaê Pwicîri, pwacèwii ê déamu. Â é têre ê pwâratùra me gée napwéretòotù, na ina têe pâ: «Gà Pwina naîô na caapwi co na go dau meaarigà. Wâgà kaa âna go jèe nye pitòrigarigà, ba dau wânümoo googà.» ");
INSERT INTO priNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Na é gére wâna 30 naja wà Iésu, â é tapoo inapàpari ê Picémara Wâdé. Naa na auniimiri kà tèpa âboro, âna nye pwina naî Ioséfa. Wàilà-ni tèpa jojooroé: Wà Ioséfa, âna é pwina naî Héli, ");
INSERT INTO priNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","na é pwina naî Matat, na é pwina naî Lévi, na é pwina naî Melki, na é pwina naî Jannaï, na é pwina naî Ioséfa, ");
INSERT INTO priNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","na é pwina naî Matatias, na é pwina naî Amos, na é pwina naî Nahoum, na é pwina naî Esli, na é pwina naî Nagaï, ");
INSERT INTO priNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","na é pwina naî Mahath, na é pwina naî Matatias, na é pwina naî Séméïn, na é pwina naî Yosec, na é pwina naî Yoda, ");
INSERT INTO priNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","na é pwina naî Yoanan, na é pwina naî Résa, na é pwina naî Zorobabel, na é pwina naî Chéaltiel, na é pwina naî Néri, ");
INSERT INTO priNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","na é pwina naî Melki, na é pwina naî Adi, na é pwina naî Kosam, na é pwina naî Elmadam, na é pwina naî Er, ");
INSERT INTO priNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","na é pwina naî Yéchoua, na é pwina naî Éliézer, na é pwina naî Yorim, na é pwina naî Matat, na é pwina naî Lévi, ");
INSERT INTO priNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","na é pwina naî Siméon, na é pwina naî *Juda, na é pwina naî Ioséfa, na é pwina naî Yonam, na é pwina naî Éliakim, ");
INSERT INTO priNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","na é pwina naî Méléa, na é pwina naî Menna, na é pwina naî Matata, na é pwina naî Natan, na é pwina naî *Davita, ");
INSERT INTO priNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","na é pwina naî Jessé, na é pwina naî Obed, na é pwina naî Booz, na é pwina naî Sala, na é pwina naî Nachon, ");
INSERT INTO priNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","na é pwina naî Aminadab, na é pwina naî Admine, na é pwina naî Arni, na é pwina naî Hesron, na é pwina naî Pérès, na é pwina naî Juda, ");
INSERT INTO priNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","na é pwina naî Iakobo, na é pwina naî Isaaka, na é pwina naî Abéraama, na é pwina naî Téra, na é pwina naî Nahor, ");
INSERT INTO priNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","na é pwina naî Seroug, na é pwina naî Réou, na é pwina naî Péleg, na é pwina naî Éber, na é pwina naî Chéla, ");
INSERT INTO priNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","na é pwina naî Quénan, na é pwina naî Arpaxad, na é pwina naî Sem, na é pwina naî Noa, na é pwina naî Lémek, ");
INSERT INTO priNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","na é pwina naî Matusalem, na é pwina naî Hénok, na é pwina naî Yéred, na é pwina naî Malaléel, na é pwina naî Quénan, ");
INSERT INTO priNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","na é pwina naî Énos, na é pwina naî Seth, na é pwina naî *Adamu, na é pwi jojooro âboro, na é tòpò wà Pwiduée naani gòropuu. ");
INSERT INTO priNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","É wâjué côwâ wà Iésu gée nairiwâ Ioridano. Â ê Nyuâaê Pwicîri, âna é tâa gòé, â é popaé pâ naa namaré. ");
INSERT INTO priNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Â é tâa wê wà Iésu naa na ê 40 tòotù. Â é pwa ma tacaié naawê wà *Caatana, pwi a cicarajè. Â, na pwi pàara-bà, âna câé caa ija wà Iésu, â é dau copwa. ");
INSERT INTO priNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Â é pâdarié wà Caatana, â é ina têe pâ: «Wiàna gà *Pwina naî Pwiduée, â gà bii ê pwi atü bèeni, ma poloa!» ");
INSERT INTO priNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Â é tòpi têe wà Iésu pâ: «Jèe nye wii naa na *Tii Pwicîri, pâ: Câé caa wâro co goro poloa wà pwi âboro.» ");
INSERT INTO priNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Â é popaé too kaamwara naanidò gòrojaa wà Caatana. Â é nye paari têe kaa, na ji pàara bèepwiri, diri ê pâ napô ma mwaciri gòropuu. ");
INSERT INTO priNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Â é ina têe pâ: «Go o mwa naa tâgà ê muugère kâra diri pâ mwaciri bèeni, bau aupitûâri naa goorà, ba jèe naa tôo. Â pâri ma go naa, wiâra câbawâdé kôo. ");
INSERT INTO priNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Â go mwa cau naa tâgà diri, wiàna gà tùu jùrugà arao ma gà ipwamainaô.» ");
INSERT INTO priNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Â é tòpi têe wà Iésu pâ: «Jèe nye wii naa na Tii Pwicîri, pâ: Gà ipwamaina Pwi Ukai Pwiduée'gà, â nye wàé co, na gà ipwa âboro kîri kêe.» ");
INSERT INTO priNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Â é nye popa Iésu, pâ naa *Iérusaléma. Â é popaé too naa gòro pûru *Wâra pwapwicîri. Â é ina têe pâ: «Wiàna gà Pwina naî Pwiduée, â gà êgò géeni! ");
INSERT INTO priNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Ba jèe wii naa na Tii Pwicîri pâ: Ée mwa tûâri tà tèpa *angela kêe, wà Pwi Ukai Pwiduée, ba na rà wéaarigà. ");
INSERT INTO priNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Rà mwa tapigà. O càcaa tanoori âgà naa gòro atü.» Psaume 91.11–12 ");
INSERT INTO priNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Â é tòpi têe wà Iésu pâ: «Bwa. Ba jèe nye wii naa na Tii Pwicîri pâ: Gà cibwaa pigàdàPwi Ukai Pwiduée'gà.» ");
INSERT INTO priNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Ûna é jèe tacaié diri wà Caatana, â é pâra jiié. Â é tapacîri mwara cè jè tòotù. ");
INSERT INTO priNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Wà Iésu, âna dipitirié ê Nyuâaê Pwicîri, â é wâjué côwâ naa napô Galilée. Â rà jèe tapoo pwa jèkutâ gooé naa na diri ê pâ ére. ");
INSERT INTO priNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","É pacâmuri tèpa âboro naa na pâ *wâra pitapitiri, â rà dau inaê ba wâdé. ");
INSERT INTO priNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","É wâjué me côwâ wà Iésu naa Nazareth, wâna ia é maina naawê. Â naa na tapoo *tòotù pwicîri, âna é tò naa na wâra pitapitiri, wàra na mu nye câmaajé têe. Â é cimadò, ba na é pûra ê Tii Pwicîri. ");
INSERT INTO priNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Â é ilari jii pwi jè ênawéna ê tii kà *péroféta Isaia. Â é pwara, â é pitòrigari ê pâ popai, na é pûra tàra: ");
INSERT INTO priNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","É wâgò-o Nyuâa Pwi Ukai. É pitòrigario; é panuâô pâ, ma go pame Popai Wâdé tà tàpé na ticè kàra. Go inapàpari ê tàrù tà tèpa pwa karapuu; pai niâ kà tèpa bwi; pai tipi tàpé na piirà. ");
INSERT INTO priNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Wàéni ê pàara kêe na o inapàpari ê pimeaari; pai wâdé kà Pwi Ukai. Ésaïe 61.1–2 ");
INSERT INTO priNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","É pipîri i tii wà Iésu, â é naa côwâ tà i pwi ênawéna, â é tâaboo. Â rà gére po niâriê diri ê pâ âboro naa na i wâra pitapitiri. ");
INSERT INTO priNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Â é ina tàra pâ: «Guwà jèe nye têre ê auinapàpari kâra ê Tii Pwicîri. Â nabàni, âna jèe pacoo na arawà diri.» ");
INSERT INTO priNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Rà picagòtù Iésu ma pi-inaê ba wâdé, ba rà po dau pò goro ê pâ pwâratùra kêe na pwényuâa. Êco na, gée na càùé â rà tapoo pi-ina tàra pâ: «Gorodà na wàrapwiri ê pai tùra kêe? Na nye pwi âboro pwacèwiijè. Ba nye pwina naî Ioséfa!» ");
INSERT INTO priNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Â é tòpi tàra pâ: «Guwà jèe nye têre ê pâ namuru na go pwa na Capernaüm. Â nümawà na go pwa mwara cèna ipaiwà, naani napô kôo. «Pwiri guwà o ina tôo ê ucina bèeni: “Ico pwi dotée, gà pinama tiàu ê maagé'gà côwâ.” ");
INSERT INTO priNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","«Êco na go ina tàwà pâ: “Wà pwi péroféta, âna càcaa pitòpié bwàti naa na napô kêe.” ");
INSERT INTO priNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","«Âjupâra, ba ipaiwà na pàara kà péroféta *Élia. Ba ia càcaa coo boo cè popaa, â pwa copwa na maina, naa na diri ê napô, naa na âracié naja â gòobèreè. Â po dau wâru ê pa dàpwà na napô *Isaraéla, na rà copwa. ");
INSERT INTO priNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Êco na wà Pwiduée, âna câé caa panuâ Élia, ba na é pitu târa cè caapwi dàpwà, wâ Isaraéla, napô kêe. Â é nye panuâê pâ naa jaa tô jè dàpwà na village Sarepta, naa na jè ére goro Sidon. ");
INSERT INTO priNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","«Â guwà jèe niimiri cai mwara wà péroféta Élisée. Ba é pwa ma tiàu maga kà Naaman co, pwi âboro gée Syrie. Êco na dau wâru wà tèpa pwa maga na Isaraéla.» ");
INSERT INTO priNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Ûna rà têre pwiri, wà tèpa âboro naa na i wâra pitapitiri, â rà po dau putàmu naa goo Iésu. ");
INSERT INTO priNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Â rà nye cimadò kaa, â rà dàtié too, naanidò gòro i jaa, na tâa wê i village kàra. Â rà pwa na rà tüê tàbàtù niboo. ");
INSERT INTO priNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Êco na é nye pâ nabibiu kàra, â câé caa ipacè naa goorà. Â é pâra jiirà. ");
INSERT INTO priNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","É tèepaa wà Iésu naa Capernaüm, village wâ Galilée. Â é tò naa na wâra pitapitiri, na jè tòotù pwicîri. Â é pacâmuri tèpa âboro. ");
INSERT INTO priNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Â rà pò goo ê pai tùra kêe wà tàpé na rà gére têreê. Ba pwa pàtàmara ê popai kêe na é pacâmurirà goo. ");
INSERT INTO priNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Na é gére tùra wà Iésu â é tò naa na wâra pitapitiri ê pwi âboro na pwa duée gooé. Â é wiikau burà ina pâ: ");
INSERT INTO priNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","«Ée! Iésu gée Nazareth, nye ticè cèna gà pwa jaabà! Gà me na tubaèpà tâbà? Go tàgére côoinagà, ba wâgà pwi âboro, na é pitòrigarigà wà Pwiduée, â é panuâgà me!» ");
INSERT INTO priNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Â é nye kànari kaa i pé duée, wà Iésu, ma ina têe pâ: «Gà târi pwâgà, â gà còobé gée goo pwi âboro bèeni!» Â i pwi duée, âna é tüboo i pwi âboro, na ara diri tàpé na rà tâa wê. Â é còobé gée gooé, â câé caa tubaèpà têe. ");
INSERT INTO priNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Â nye po dàpàgà târa diri ê pâ âboro, â rà pitawèerirà jècaa, ma ina pâ: «Gà côo, wà pwi âboro bèeni, âna pwa pàtàmara ê pwina é ina. Â é pitûâ târa mwara pâ duée, â rà pitêre dèe, â rà còobé!» ");
INSERT INTO priNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Â nye pâra kaa ê jèkutâ goo Iésu, pitiri ê napô bèepwiri. ");
INSERT INTO priNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","É còobé gée na wâra pitapitiri wà Iésu, â é pâra naa jaa Simona Pétéru. Â rà ina têe wà tàpé na rà gére tâa wê, pâ, wà tô nyaa kà wâdà Simona, âna é dau maagé, ba é pitòoka, â rà ilari jiié pâ, na é pitu têe. ");
INSERT INTO priNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Â é medarié wà Iésu, â é cùué boo. Â é pacoo ê maagé kêe. Â nye tiàu jiié kaa ê pitòoka! Â é cimadò â é naa èrà. ");
INSERT INTO priNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Na capàto na bàrane, âna rà popa medari Iésu diri tèpa maagé. Â é tòpò îê naa gòrà diri, â nye tiàu kaa ê pâ na jèpapara maagé kàra. ");
INSERT INTO priNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Â rà còobé mwara pâ duée gée goo tàpé na wâru. Â rà tomara too i pâ duée, ma ina pâ: «Wâgà Pwina naî Pwiduée.» Êco na é papwicîri jiirà ba gòo na rà tùra. Ba rà jèe tâmogòori pâ wàé, âna é pwi *Mesia, wà *pwi a pa-udò na é cùru me wà Pwiduée. ");
INSERT INTO priNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Na dàuru kêe, â é còobé gée na village wà Iésu, â é pâra naa na jè ére na ticia wê. Êco na rà pâra nau mudèe wà tèpa âboro, ba na rà ilari jiié pâ, na é bwaa tàpo tâa jaarà. ");
INSERT INTO priNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Êco na é tòpi tàra pâ: «Bwa. Ba wâdé na go inapàpari ê *Picémara Wâdé goro ê Mwaciri kà Pwiduée, naa na pàra village. Ba wàépwiri majoroé ma go boome.» ");
INSERT INTO priNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Â é pâpitiri wâ *Judée, â é picémara ê Picémara Wâdé, naa na pâ wâra pitapitiri. ");
INSERT INTO priNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Na jè tòotù, âna é tâa niboo bàrawià Galilée wà Iésu. Â é picémara ê popai kà Pwiduée. Â wâru pâ âboro na rà cibèepié, ba na rà têreê. ");
INSERT INTO priNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Â é côo ê du wànga, na ru gére tâa niboo najawé mwünyabweri bàrawià. Ba rà gére boo gée gò i tèpa pwa puà, â rà gére nuwa i puà kàra. ");
INSERT INTO priNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Â é too naa gò i jè wànga, wànga kà Simona Pétéru. Â é ina tà Simona ma wà tèpa bée pâ: «Guwà tàpo cètùu boopaé i wànga.» Â é tâaboo, â é tapoo pacâmuri mwara tèpa âboro. ");
INSERT INTO priNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Ûna é gére tùra diri, â é ina tà Simona ma wà tèpa bée pâ: «Guwà toome, ba na jè tàpo dau boo naa na numwiri. Â guwà mwa bàra panuâ i pâ puà kàwà.» ");
INSERT INTO priNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Â é tòpi têe wà Simona pâ: «Ico pwi a pwa pupûra, gà côo: Bà jèe nye wakè kaa, diri na pé ne bèeni, â nye ticè cèna bà taa. Êco na, gée goro pai ina'gà tâbà, â go o pwa.» ");
INSERT INTO priNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Â rà too naa gòro i wànga, â rà tàpo boopaé â rà panuâ i pâ puà. Â nye dau wâru kâa ê pâ ârawéà na rà coo na. Â pwa na tidàpa i pâ puà. ");
INSERT INTO priNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Â rà piara dà tèpa béerà na rà tâa gòro i jè wànga, ba na rà pitu tàra. Â pwa na wâbé i du wànga goro ârawéà, â ru pwa na ru mwü. ");
INSERT INTO priNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","10","Â po dau wâgo tà wà Simona ma wà diri tèpa bée—wà Jacques ma wà Ioane, tupédu naî wà Zébédée, ma wà pàra tàpé. Â é tùu jùrué ma cigòboo na ara Iésu wà Simona, â é ina têe pâ: «Pwi Ukai, gà cibwaa coo jaao! Ba gà pwi âboro pwicîri â wâgo, âna go pwi âboro na go èpà!» Â é tòpi têe wà Iésu pâ: «Gà cibwaa nama wâgotâgà. Ba tapoo nabàni, âna gà o pwi a pwapuàri âboro.» ");
INSERT INTO priNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Â rà wâjué côwâ naa bàrawià, â rà dàti too naa gòromwari i du wànga. Â gée na càùé, â rà naaco diri, â rà pâra wiâ Iésu. ");
INSERT INTO priNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Ûna é tâa na jè village wà Iésu, â é tèepaa me wà pwi jè a pwa maga. Ûna é côo Iésu, â é tùu jùrué ma cigòboo na araé, â é ilari jiié pâ: «Wiàna nye nümagà, â gà o nama tiàu maagé kôo.» ");
INSERT INTO priNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Â é tùu pâ îê, â é tu naa gooé, â é ina têe pâ: «Nümoo! Wâdé na tiàu ê maagé'gà!» Â nye po tiàu jiié kaa ê maagé kêe, â é jèe wâdé. ");
INSERT INTO priNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Â é ina têe wà Iésu pâ: «Gà cibwaa pwa jèkutâri. Â gà pâra nau ipaarigà tà pwi a pwa ârapwaailò, â gà naa tà Pwiduée i pwi *ârapwaailò na ia é ina wà *Moosé naa na i *Naèà kêe. Ba naa wàrapwiri, â rà o côo diri wà tèpa âboro pâ gà jèe wâdé.» ");
INSERT INTO priNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Êco na dau ipâra pâ ê jèkutâ goo Iésu. Â mu dau wâru tàpé na rà mu me mariê, nau têreê, ma ilari jiié pâ, na é nama tiàu ê pâ maagé kàra. ");
INSERT INTO priNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Â é mu pâra acari, naa na pâ ére aupiticia, ba na é pwapwicîri. ");
INSERT INTO priNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Na jè tòotù, âna é pacâmuri pâ âboro wà Iésu. Â wà pàra tèpa *Farasaio ma *dotée goro ê Naèà, âna rà gére têreê. Ba rà medarié, gée na pâ village gée Galilée ma *Judée, ma gée *Iérusaléma. Â ê pàtàma Pwi Ukai Pwiduée, âna é tâa gò Iésu, ba na é nama tiàu maagé kà tèpa âboro. ");
INSERT INTO priNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Â rà tèepaa me ê pàra âboro, na rà pitûri me goro aupuu ê pwi âboro na é pitàbwamwa. Ba nümarà na rà popaé too naa na i wâ, ma tòpòé na ara Iésu. ");
INSERT INTO priNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Êco na ticè pai pwa wèe, majoroé ê pai wâru wàra ê âboro. Â rà tàmee too naa gòrowâ, â rà dàgòtù ê jè ére gòrowâ. Â rà panuâê boo gòro ê aupuu kêe, na ara Iésu, ma wà tèpa âboro na rà cibèepié. ");
INSERT INTO priNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Â é pò goo ê cèikî kà tèpa âboro bèepwiri, wà Iésu, â é ina tà pwi a pitàbwamwa pâ: «Pwiini, jèe pwanauri ê pâ èpà'gà.» ");
INSERT INTO priNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Wà tèpa Farasaio ma tèpa dotée goro ê Naèà, âna rà pi-ina tàra pâ: «Kaa! Wàilàapà pwi âboro bèeni, na é nama ipaiwàilu ma wà Pwiduée ma pinabaèpà ê nee! Wàilàapà na tâmogòori ma é pwanauri ê pâ èpà? Na nye wàco Pwiduée!» ");
INSERT INTO priNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Êco na é nye tâmogòori wà Iésu ê pwina rà niimiri, â é ina tàra pâ: «Gorodà na wàrapwiri ê pâ pwâranümawà? ");
INSERT INTO priNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Piticècoé na go ina têe pâ: “Jèe pwanauri ê pâ èpà'gà” jii na go ina têe pâ: “Gà cimadò, â gà pâra!” ");
INSERT INTO priNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Â wiàna pâri ma go nama é pâra, na arawà diri â guwà mwa tâmogòori pâ, pwa tàrù kà *Pwina naîri âboro, ma é pwanauri ê pâ èpà naani gòropuu.» Â é ina tà pwi a pitàbwamwa pâ: «Go ina tâgà ni pâ: Gà cimadò, â gà popa ê aupuu'gà, â gà pâra naa jaagà.» ");
INSERT INTO priNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Â é nye cimadò kaa, naa nabibiu kâra i pâ âboro. Â é popa ê aupuu kêe, â é pâra naa pwârawâ kêe, â é pwamaina Pwiduée. ");
INSERT INTO priNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Â rà dau pò goo wà diri tàpé na rà côo pwiri. Â nye po dàpàgà tàra, â rà nye pi-ina cùuru pâ: «É! Nye dau ité kaa ê pâ pwina jè côo nabà!» Â rà pwamaina Pwiduée. ");
INSERT INTO priNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Gée na càùé, ûna é pâra wii naigé wà Iésu, â é côo wà Lévi, pwi a *tò mwani wâripû, na é tâa na wâra wakè kêe. Â é ina têe wà Iésu pâ: «Gà me wiâô!» ");
INSERT INTO priNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Â é pò ma cimadò wà Lévi, â é panuâ diri, â é pâra wiâê. ");
INSERT INTO priNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Gée na càùé, â é pwa ê pi-ija na maina wà Lévi, naa jaaé, ba na é pwamaina wà Iésu. Â é todà Iésu ma wà tèpa *câmu kêe. Â wâru pâ âboro na rà pi-ija naima ma wàilà—wà tèpa tò mwani, ma wà pàra tàpé mwara. ");
INSERT INTO priNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Â rà tâa wê mwara wà pàra tèpa Farasaio. Â wà pàra tàpé gée goorà, âna rà tèpa dotée goro ê Naèà. Â rà cau pikûuri tèpa câmu kêe, â rà ina tàra pâ: «Kaa! Gorodà na guwà picaaija ma pibéewà ma tàpé na èpà ê wâro kàra, ma wà tèpa tò mwani?» ");
INSERT INTO priNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Â é ina tàra wà Iésu pâ: «Càra caa bu dotée wà tàpé na rà wâdé. Â nye wàco tàpé na rà maagé. ");
INSERT INTO priNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Câgo caa me, nau todà tàpé na rà niimiri pâ wâdé ê wâro kàra. Bwa! Go me nau todà tàpé na rà tâmogòori pâ èpà ê wâro kàra, ba na rà biirà, ma pitòotéri ê wâro kàra.» ");
INSERT INTO priNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Rà tapoo patùra Iésu wà tèpa Farasaio, goro ê *ipwanya—pai panuâ ija na jè ji pàara, ba na jè pwapwicîri. Â rà ina têe pâ: «Wà tèpa câmu kà *Ioane Pwi a piupwaa, âna rà tàgére ipwanya, ma pwapwicîri. Â ipaiwà naa goo tèpa câmu kâbà. Â wà tèpa câmu'gà, âna rà nye ija ma wâdo. Gorodà na càra caa ipwanya?» ");
INSERT INTO priNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Â é tòpi tàra pâ: «Gona rà o ipwanya, wà tàpé na jè todàra naa goro ê piéa, na é bwaa tâa jaarà wà pwi a piéa? Bwa! Na pàara na é bwaa tâa jaarà, â rà pi-ija ma wâdo. ");
INSERT INTO priNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Êco na o mwa me ê tòotù na ée mwa pâra jiirà wà pwi a piéa. Â géewê, na rà o mwa bàra ipwanya.» ");
INSERT INTO priNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Â é ina tàra mwara ê ucina bèeni wà Iésu, pâ: «Nye ticè jè âboro, cèna é dàdàpa ê gòobàra ê ârabwée na bwaa bwùu, ma é taiti naa goro ê ârabwée na jèe dòroé. Ba o jèe dànoori i ârabwée na bwùu, â o càcaa ipaiwà i du noo kâra imwaano, naa goro i ârabwée na jèe dòroé. ");
INSERT INTO priNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","«Guwà côo ê *wâra jawé na pwa goro parawére macii: Câjè caa popa ê dipâa na bwaa âmuê, ma jè upwâwii ê wâra jawé na jèe dòroé. Ba o taaò i wâra jawé, ba pwacoé ma é tèe. Â o tubatiàu i dipâa bau i wâra jawé. ");
INSERT INTO priNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Bwa! Wâdé na jè tòpò ê dipâa na bwaa âmuê, naa na ê wâra jawé na bwaa bwùu. ");
INSERT INTO priNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Êco na wà tàpé na rà mu wâdo ê dipâa na jèe gòiri, âna tàutàra goro ê dipâa na bwaa âmuê. Ba rà ina pâ: “Dau wâdé nümara ê dipâa na jèe gòiri.”» ");
INSERT INTO priNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Na jè *tòotù pwicîri, âna rà pâra wii ê naigé na tapàgà na aupwanapô wà Iésu ma wà tèpa *câmu kêe. Â wii naigé, â rà tàpo pétâ pâ pwâra blé wà tèpa câmu. Â rà iitiri naa na îrà, â rà uti ê pudòé. ");
INSERT INTO priNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Wà pàra tèpa *Farasaio, âna rà côorà, â rà ina tàra pâ: «Tàpéebà, gona cina guwà pwa na wàrapwiri? Âna muru na papwicîri, na ê tòotù pwicîri!» ");
INSERT INTO priNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Â é tòpi tàra wà Iésu pâ: «Gona câguwà caa pûra naa na Tii Pwicîri ê pwina é pwa wà pwi ukai *Davita? Ba, na jè tòotù, â rà copwa, wàilà ma wà tèpa bée, â nye ticè cèna rà uti. ");
INSERT INTO priNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Â é tò naa na wâra pwapwicîri pwa goro imwaano. Â é pa ê poloa, na naa tà Pwiduée, â é ija. Â é pa, â é nama rà ija mwara wà tèpa bée. Êco na ê poloa-bà, âna nye wàco wà tèpa pwa *ârapwaailò, na pwa tàrù kàra ma rà ija.» ");
INSERT INTO priNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Â é ina mwara wà Iésu pâ: «Wà *Pwina naîri âboro, âna é pwi apooro ê tòotù pwicîri.» ");
INSERT INTO priNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Na jè tòotù pwicîri, â é tò naa na *wâra pitapitiri wà Iésu. Â é pacâmuri tèpa âboro. É tâa wê mwara wà pwi âboro na bà ê îê. ");
INSERT INTO priNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Â wà tèpa *dotée goro ê Naèà ma wà tèpa Farasaio, âna rà côo bwàti wà Iésu, pâ, pwiri é pwa ma é wâdé côwâ wà pwi âboro bèepwiri, na tòotù pwicîri? Ba rà mudàra cè pai pwa wèe, ba na rà o mwa pitòtié. ");
INSERT INTO priNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","É tâmogòori ê auniimiri kàra, wà Iésu â é ina tà pwina bà i îê pâ: «Gà cimadò, â gà me naani, na ara diri pâ âboro.» Â é cimadò wà pwiibà, â é me naa jaa Iésu, na ara pâ âboro. ");
INSERT INTO priNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Â é ina wà Iésu tà tàpé na rà tâa wê pâ: «Wànau? É *tàrù na tòotù pwicîri, na jè pwa pwina wâdé, é na jè pwa pwina èpà? Wâdé na jè pawâro pwi âboro, é, wâdé na jè panuâê ma é bà?» ");
INSERT INTO priNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Â é po niârirà diri wà Iésu. Â é ina tà i pwi âboro pâ: «Gà patàrù ê îgà.» Â é patàrù i îê, â é nye wâdé kaa. ");
INSERT INTO priNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Â rà nye dau putàmu kaa wà tèpa Farasaio ma wà tèpa dotée goro ê Naèà. Â rà pitùra goro cè pwina rà o pwa tà Iésu. ");
INSERT INTO priNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Na jè tòotù, âna é too wà Iésu, naa gòrojaa. Â é pwapwicîri tà Pwiduée, tiagoro pwaa. ");
INSERT INTO priNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Ûna pwaa, â é todà diri tàpé na rà mu pâra wiâê. Â é mwa pitòrigari gée jaarà tèpa 12 âboro, na é nama neerà pâ *apostolo. ");
INSERT INTO priNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Wàilà-ni: Simona—é pitunee têe wà Iésu pâ Pétéru; André, wà pwi jiié; Jacques; Ioane; Filipo; Barthélemy; ");
INSERT INTO priNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mataio; Toma; Jacques, pwina naî Alphée; Simona, pwi Zélote; ");
INSERT INTO priNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Jude, pwina naî pwi jè âboro na nee Jacques; Judas Iscariote, wà pwina ée mwa icuri Iésu. ");
INSERT INTO priNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Rà wâjué boo côwâ gée gòrojaa, wà Iésu ma tèpa 12 apostolo kêe. Â rà coo na ére na tàbwàti. Â dau wâru pâ âboro na rà medarirà—wà tàpé na rà mu pâra wiâ Iésu, ma pàra tèpa âboro gée Iérusaléma ma gée na diri napô *Judée; ma gée na ére bàrawià wâgoro jènere du ville Tyr ma Sidon. ");
INSERT INTO priNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Ba rà cau me, ba na rà têre Iésu, â ba na é pwa ma tiàu maagé kàra. Â é tü târa mwara pâ duée na wâru. ");
INSERT INTO priNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Â wâru tàpé na pwa na rà tu naa gooé. Ba pwa ê pàtàmee na tâa gooé, â nye cau tiàu maagé kàra. ");
INSERT INTO priNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","É tabiié wà Iésu dà tèpa câmu kêe. Â é ina tàra pâ: «Cidòri nyuâawà, wâguwà na ticè kàwà, ba o mwa kàwà ê *Mwaciri kà Pwiduée! ");
INSERT INTO priNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Cidòri nyuâawà, wâguwà na guwà copwa ni, ba guwà o mwa pwàro! Cidòri nyuâawà, wâguwà na guwà i ni, ba guwà o mwa ipwàdée. ");
INSERT INTO priNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Cidòri nyuâawà wiàna rà pièpàriwà, ma tàutàra goowà, ma piècaariwà, ma tobapwâwà, gée goo na guwà tèpa âboro kôo, wâgo Pwina naîri âboro. ");
INSERT INTO priNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Ba wà tèpa jojoororà, âna rà nye wàrapwiri tà tèpa *péroféta. Â go ina tàwà pâ: Guwà ipwàdée ma piêgòtùru, ba o maina pumara wakè kàwà naanidò *napwéretòotù!» ");
INSERT INTO priNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","«Wàéni popai kôo naa goowà wâguwà na pwa kàwà: O pwa aré ma tòina kàwà. Ba jèe nye êkaa ê ipwàdée kàwà ê neemuruwà ni, â o jèe nye êkaa ê jara ipwàdée kàwà. ");
INSERT INTO priNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","O pwa aré ma tòina kàwà, wâguwà na guwà pwàro. Ba guwà o mwa copwa. O pwa aré ma tòina kàwà, wâguwà na guwà ipwàdée ni. Ba guwà o mwa i ma pijinünü. ");
INSERT INTO priNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","O pwa aré ma tòina kàwà, wâguwà na rà pi-inawà ba wâdé wà tèpa âboro. Ba o dau maina ê wârimuru kàwà jii wà tèpa péroféta a pwâ, na ia rà nye dau pi-inarà ba maina wà tèpa âboro.» ");
INSERT INTO priNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","«Guwà tàpo tàmaariô, wiàna nümawà na guwà têre: Gà meaari tàpé na rà èpàrigà, â gà pwa na wâdé tà tàpé na rà miirigà. ");
INSERT INTO priNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Â gà *pwényunyuâari tàpé na rà pinajajaigà. Â gà pwapwicîri ba kà tàpé na rà pi-inabaèpàgà. ");
INSERT INTO priNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Â wiàna é tamagéri jè upwaégà wà pwi jè âboro, â gà panuâ têe mwara jèpwi. Â wiàna é popa cimiici'gà, â gà naa têe mwara ê palito'gà. ");
INSERT INTO priNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Wiàna é ilari jiigà cè jè muru, wà pwi jè âboro, â gà naa têe. Â wiàna é popa ê jè neemurugà, â gà cibwaa ilari pâ, na é pitôowâri. ");
INSERT INTO priNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Üu, go ina tàwà pâ: Gà pwa tà pàra tàpé ê pâ muru na nümagà na rà pwa tâgà.» ");
INSERT INTO priNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Ba wiàna gà wâdéari co tàpé na rà wâdéarigà, â cina gà tapacîri cè câmagà jii Pwiduée? Ba wà tèpa âboro èpà, âna rà nye pwa mwara ê pwiibà. ");
INSERT INTO priNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Â wiàna gà pwa na wâdé tà tèpa béegà, â cina guwà tapacîri cè câmagà? Ba wà tèpa âboro èpà, âna rà nye pwa mwara ê pwiibà! ");
INSERT INTO priNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Â wiàna gà naa mwani co tà tàpé, na rà o mwa pitôowâri, â cina gà tapacîri cè câmagà? Ba wà tèpa âboro èpà, âna rà nye pwa mwara ê pwiibà! ");
INSERT INTO priNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","«Guwà têre! Gà meaari tàpé na rà èpàrigà, â gà pwa na wâdé tàra, â gà naa tà tèpa âboro, naa goro piticèmuru naa goo. Ba wiàna gà wàrapwiri, â o dau maina ê câmagà na ée mwa naa tâgà wà Pwiduée, na é wâ napwéretòotù. Ba gà paari goro ê càragà bèepwiri pâ gà pwi âji naîê. Ba wàé, âna é meaari tàpé na càra caa pwaolé têe, ma tàpé na rà pwa na èpà. ");
INSERT INTO priNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Êkaa na wâdé na gà pimeaari, pwacèwii pwi Caa'gà na é pwi a pimeaari.» ");
INSERT INTO priNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","«Gà cibwaa pitèi ma pitòti pàra tàpé, â o câé caa pitèigà wà Pwiduée. Â gà pwanaurirà, â wàé, âna ée mwa pwanaurigà. ");
INSERT INTO priNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Â gà naa, naa goro piticèmuru naa goo ba gà o tòpi. Ba o nye piâjagò tâgà côwâ. Â guwà o mwa tòpi pâ muru na piêdò ma piwéna. Ba o naa tâgà, pwacèwii ê pai naa kâgà tà pàra tàpé.» ");
INSERT INTO priNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","É ina tàra ê ucina bèeni wà Iésu, pâ: «Gona wà pwi a bwi, âna pâri ma é popa pwi jè a bwi? Bwa! Ba ru o cau tûu naa na pwêe! ");
INSERT INTO priNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Â go ina tàwà pâ: Wà pwi a câmu, âna câé caa piwéna jii pwi a pacâmuriê. Êco na, wiàna é dau câmu bwàti, â ée pâ nau pwacèwii pwi a pacâmuriê. ");
INSERT INTO priNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","42","«Gà dau côo bwàti ê mapûpûru na wâna âraporomee pwi aéjii'gà. Â gà niâ jai ê diopwaa kâra pàara upwâra na âraporomeegà! Â gà wànau pai ina tà pwi aéjii'gà pâ: “Nama go jèe patâjii i mapûpûru bèepwiri na âraporomeegà”? «Gà pwi a-ipwacôwârimuru! Gà mara patâjii béaa ê diopwaa kâra pàara upwâra bèepwiri na âraporomeegà! Â géewê, mwa bàra pwéelaa tâgà cè pai patâjii wàra ê mapûpûru na âraporomee pwi aéjii'gà!» ");
INSERT INTO priNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","«Ê upwâra na wâdé, âna é nye tòpò pwêe na wâdé târa uti, â pwacoé ma é tòpò pwêe na èpà. Â ê upwâra na èpà, âna é nye tòpò pwêe na èpà, â pwacoé ma é tòpò pwêe na wâdé. ");
INSERT INTO priNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Ba jè côoina i upwâra gée goro ê pwêe. Ba câjè caa pétâ pwâra î gée goro cè upwâra aru! Â câjè caa pétâ pwâra dipâa gée goro ê upwâra na pwa daaé! ");
INSERT INTO priNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Ê pâ muru na wâdé, âna me gée goo pwi âboro na é wâdé, ba wâdé pwâranümee. Â ê pâ muru na èpà, âna me gée goo wà pwi âboro na é èpà, ba èpà pwâranümee. Ba jè tùra, gée goo ê pwina é tâa na pwâranümajè.» ");
INSERT INTO priNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","«Gorodà na guwà po ciburà ina tôo pâ: “Pwi Ukai, Pwi Ukai!” â câguwà caa pitêre dòo? ");
INSERT INTO priNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Guwà têre cai ê ucina bèeni: «Wà pwi âboro na é têre diri pâ popai kôo, â é pitêre dàra, ");
INSERT INTO priNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","âna é pwacèwii pwi âboro na é bari ê wâ kêe. Â é îri boo tiagòro atü, ba na é tòpò naawê ê pàara wâ. Ûna ca ê jèpé, â é ti goro i wâ, â câé caa taura, ba bari naa gòro atü. ");
INSERT INTO priNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Â wà pwina é têre popai kôo, â câé caa pitêre dàra, âna é pwacèwii pwi âboro, na é pacima ê wâ kêe, âna ticè pàaé. Â ca i jèpé, â é ti goro i wâ, â é nye tûu kaa i wâ, â nye tanoori diri kaa.» ");
INSERT INTO priNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Ûna é gére ina diri pwiri tà tèpa âboro wà Iésu, â é wâjué me côwâ naa Capernaüm. ");
INSERT INTO priNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","3","Â wà pwi jè caa kâra coda roma, na é tâa wê, âna é têre jèkutâ goo Iésu. Â é panuâ pâdari Iésu pàra tèpa âboro imaina kà tèpa *Juif, ba na rà ilari jiié pâ, na é pwa ma tiàu maagé kà pwi ênawéna kêe. Ba é po dau maagé wà pwiibà, â é pwa na é bà. Â dau wânüma wà pwi caa kâra coda gooé. ");
INSERT INTO priNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Â rà pâdari Iésu wà tàpéebà, â rà tacoo gooé pâ, na é pitu tà i pwi caa kâra coda. Â rà ina têe pâ: «Gà côo, co pwi ukai, wà pwiibà, âna é pwi âboro na é dau wâdé. Â wâdé ma gà pitu têe. ");
INSERT INTO priNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Ba é meaari ê Ba kâjè wàijè tèpa Juif tiagoro na é bari ê *wâra pitapitiri kâjè.» ");
INSERT INTO priNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Â é pâra wiârà wà Iésu. Â ûna rà tèepaa mwünyabweri ê pwârawâ kà i pwi caa kâra coda, â wà pwiibà, âna é panuâ pâdari Iésu pàra tèpa bée, ba na rà pame têe ê popai bèeni: «Ico pwi ukai, càcaa pâri naa gooò ma gà tèepaa naa pwârawâ kôo. ");
INSERT INTO priNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Â càcaa pâri naa gooò mwara na go pâdarigà. Wâdé na gà nye po tùra co, â o tiàu maagé kà pwi ênawéna kôo. ");
INSERT INTO priNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Ba wâgo, âna go pitêre dàra pwi a pitûâ kôo, â go pitûâ kà tèpa coda. Â, na go ina tà pwi jèpwi pâ: “Gà pâra!” â é pâra. Â, na go ina tà pwi jèpwi pâ: “Gà me!” â é me. Â, na go ina tà tèpa ênawéna kôo pâ: “Guwà pwa ni!” â rà nye pwa.» ");
INSERT INTO priNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Â wà Iésu, âna é dau pò ma picâdiri i pwi caa kâra coda. Â é tabèreè, â é patùra tèpa âboro na wâru, na rà gére pâra wiâê. Â é ina tàra pâ: «Guwà têre bwàti: Câgo caa pâmari cè pwi âboro cèna maina cèikî kêe, pwacèwii pwini, tia na mwara ê âji Ba kà Pwiduée *Isaraéla.» ");
INSERT INTO priNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Ûna rà wâjué côwâ naa jaa i pwi coda wà tèpa bée, â rà pâmari i pwi ênawéna kêe, âna é jèe nye wâdé côwâ. ");
INSERT INTO priNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Gée na càùé, â é pâra wà Iésu naa na village na ina goo wê pâ Naïn. Â rà pâra wiâê wà tèpa *câmu kêe, ma pàra tèpa âboro na wâru. ");
INSERT INTO priNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Ûna rà gére tèepaa pâ naa na goropwârawâ naa na i village, â rà pâmari tèpa âboro, na rà po cia pâ pwi jè a bà naa na auipwàni. Nye wàé co tà nyaa kêe, â wâru âboro na pâra wiâ wà tôobà. ");
INSERT INTO priNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Ûna é côoê wà Pwi Ukai, â po dau maina ê pai meaarié kêe, â é ina têe pâ: «Tôoni, gà cibwaa i.» ");
INSERT INTO priNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Â é gée paé, â é tu naa goo i bòkòci. Â wà i tèpa kâa wèe, âna rà coo. Â é ina tà i pwi a bà pâ: «Pwiibà, gà tàcî. Ba go ina tâgà.» ");
INSERT INTO priNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Â é nye cimadò nau tâa kaa, â é tùra! Â é naaê boo wà Iésu, ma naaê tà nyaa kêe. ");
INSERT INTO priNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Â dau wâgo tà diri tàpé na rà tâa wê, â rà picâdiri Pwiduée. Â rà pi-ina tàra pâ: «É boome na wakè jaajè wà Pwiduée! Ba é cùru me marijè wà pwi jè *péroféta kêe na dau imaina.» ");
INSERT INTO priNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Â rà pijèkutâri ê pwina é pwa wà Iésu, naa na diri ê pâ ére wâ *Judée ma wâbèepi. ");
INSERT INTO priNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Wà tèpa câmu kà *Ioane Pwi a piupwaa âna rà piwiâ têe diri ê pâ pwina é pwa wà Iésu. Â é todà tupédu ârailu wà Ioane, ");
INSERT INTO priNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","â é panuâru pâdari Pwi Ukai, ba na ru tawèerié pâ: «Pwiri nye wâgà kaa pwi *Mesia, *pwi a pa-udò na ée mwa tèepaa? É, na bà bwaa nye tapacîri cè pwi jèpwi?» ");
INSERT INTO priNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","21","Â ru pâra, â na pwi pàara na ru pâdari Iésu na, â ru côo pâ é pwa ma tiàu maagé kà tèpa âboro na wâru. Â é tü târa pâ duée, â é pwa ma rà niâ côwâ, wà pàra tàpé na rà bwi. Â ru ina têe pâ: «É panuâbu medarigà wà Ioane, ba na bu tawèerigà pâ: Pwiri nye wâgà kaa pwi Mesia? É, na bà bwaa nye tapacîri cè pwi jèpwi?» ");
INSERT INTO priNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Â é tòpi tàru pâ: «Gàu wâjué côwâ nau piwiâ tà Ioane ê pwina gàu côo, ma ê pwina gàu têre. Ba wà tèpa bwi, âna rà jèe niâ; wà tàpé na rà bee, âna rà jèe pâra bwàti; wà tàpé na rà pwa maga, âna rà jèe wâdé; wà tèpa kee, âna rà jèe têrejè; â wà tèpa bà, âna rà jèe wâro côwâ; â wà tàpé na ticè kàra, âna rà jèe tòpi ê *Picémara Wâdé. ");
INSERT INTO priNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Cidòri nyuâa pwina é côoinaô, ma cèikî naa gooò!» ");
INSERT INTO priNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Ûna ru jèe wâjué côwâ wà tupédu a câmu kà Ioane, â é ina wà Iésu târa pâ âboro na rà gére tâa wê, pâ: «Na ia guwà pâra naa namaré nau têre Ioane â dà cèna guwà pâra nau ucâri? Pwi âboro na ipwaée kêe na é pwacèwii ê bàra watü na pòbagù pwéretòotù? ");
INSERT INTO priNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Bwa! Â gona dà na guwà pâra nau côo? Pwi jè âboro na é coona pâ ârabwée na po wâdé? Bwa! Wà tèpa âboro na wàrapwiri, âna rà tâa na ê wâra ukai, â dau wâru neemururà! ");
INSERT INTO priNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Nye dà cèna guwà pâra nau côo? Pwi jè péroféta? Üu kaa, â go ina tàwà pâ: Wà pwiibà, âna é pwi péroféta maina! ");
INSERT INTO priNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Ba nye wà kaa Ioane, na é inaê wà Pwiduée, naa na *Tii Pwicîri, pâ: Go mwa panuâ paé pwi a pa popai kôo. Ée mwa pâbéaa'gà ma pwabwàti naigé'gà. Malachie 3.1 ");
INSERT INTO priNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","«Guwà têre bwàti: Nye ticè pwi jè âboro gòropuu, cèna é piwéna jii Ioane Pwi a piupwaa. Êco na go ina tàwà pâ: Wà pwina ée dau kiriwi naa na *Mwaciri kà Pwiduée, âna o tâa têe ê pwina mwa piwéna jii wà Ioane.» ");
INSERT INTO priNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Wà tèpa âboro na rà têre pwiri, ma tèpa *tò mwani wâripû, âna rà jèe cau côo pâ, é wâdé ma *tàrù wà Pwiduée. Â rà pâra dari Ioane, ba na é *upwaarà. ");
INSERT INTO priNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Êco na, napwa naa goo wà tèpa *Farasaio ma wà tèpa *dotée goro ê Naèà, âna càra caa pitêre dàra ê câbawâdé kà Pwiduée, ba tàutàra na rà pâra dari wà Ioane ma é upwaarà. ");
INSERT INTO priNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","É ina mwara wà Iésu pâ: «Go ipwacèwii naa goro dà ê pâ âboro nabà? ");
INSERT INTO priNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Rà pwacèwii pâ nari èpo na rà gére ipuburirà naa na aupitapitiri, â tàutàra dàra kòcò ma wà tèpa béerà na rà pitakàna ma ina tàra pâ: “Bà tòjò tàwà, â tàutàwà dàra câbu. Bà nyabiri tàwà nyabi târa ipwàni, â tàutàwà dàra i!” ");
INSERT INTO priNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","«Ba é tèepaa me wà Ioane Pwi a piupwaa, â câé caa ija poloa, â câé caa wâdo dipâa, â guwà ina pâ: “Pwa duée gooé!” ");
INSERT INTO priNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","«Ûna é jèe tèepaa me, wà *Pwina naîri âboro, â é ija ma wâdo pwacèwii pàra tàpé. Â guwà ina pâ: “Wà pwini, âna é dau pwi a wâdo ma pwi a-ija! Â é pabée tèpa tò mwani, ma wà pàra tèpa âboro èpà.” ");
INSERT INTO priNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","«Êco na âjupâra ê pwina jè mu ina pâ: “Ê tàmanga, âna jè côo taaci naa na pwâra wakè kêe.”» ");
INSERT INTO priNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Na jè tòotù, âna é todà Iésu wà pwi jè Farasaio, ba na rà picaaija. Â rà tâaboo naa goro i taapà, â rà tapoo ija. ");
INSERT INTO priNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Â é tèepaa me wà tô jè ilàri gòronaigé, ba é jèe têre pâ é wêe wà Iésu. Â é pame ê wâra jawé atü na dau wâdé, na wâbé goro ê jawé ûrea. ");
INSERT INTO priNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Â é tùu jùrué ma cigòboo na ara Iésu, â é i. Â ê pâ nüru i kêe, âna rà tûuboo naa gò du â Iésu. Â é câtùra goro wàrapûruê, ma bwénüu ê du âê, â é wicèpwiri i jawé ûrea naa gò du âê. ");
INSERT INTO priNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Wà i pwi apooro pwârawâ, wà i pwi Farasaio, âna é côo pwiri, â dau èpà têe, â é niimiri pâ, ‘Wiàna wà pwini, âna é pwi jè péroféta na é cùrué me wà Pwiduée â pwiri é tâmogòori pâ wà tô ilàri bèeni, âna é tô ilàri gòronaigé. Êco na é nama é tu naa gooé wà tôoni.’ ");
INSERT INTO priNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Êco na é nye tâmogòori kaa ê auniimiri kêe wà Iésu, â é ina têe pâ: «Pwini Simona, gà têre, ba pwa pwina nümoo na go ina tâgà.» Â é tòpi têe wà pwini pâ: «Îgà.» ");
INSERT INTO priNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Â é ina têe wà Iésu ê ucina bèeni: «É mwa tâa pwi jè âboro. Â ârailu tupédu âboro na ru pwa kéredi têe—pwi jèpwi, âna 500 000, â wà pwi jèpwi 50 000. ");
INSERT INTO priNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","«Êco na càcaa pâri ma ru wâri wà tupéeni. Â é ina tàru pâ: “Jèe wâdé! Guwà naaco i kéredi kàu.” Â é cau pwanauriru goo diri i mwani bèepwiri.» É tubanabwé i ucina kêe wà Iésu, â é tawèeri wà Simona, wà i pwi Farasaio, pâ: «Wàilàapà gée goo tupéebà, na dau côoina ê pai wâdé kà i pwi apooro i mwani? Gà niimiri pâ wàilàapà?» ");
INSERT INTO priNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Â é tòpi têe wà Simona pâ: «Munaa wà i pwi a maina kéredi kêe.» Â é ina têe wà Iésu pâ: «Gà âjupâra.» ");
INSERT INTO priNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","46","Â é tabiié wà Iésu dà i tô ilàri, â é ina tà Simona pâ: «Pwiini, na go tòme naani pwârawâ'gà, â câgà caa pwabwàti tôo, wiâra ê nyamanya kâjè. Ba câgà caa naa tôo cè jawé, ba na go nuwa du âô. Â câgà caa naa tôo ê l'huile târa ê pûruô. Â gà côo i tô ilàri bèeni, âna câé caa nao goro pwa ê pwina wâdé. Ba é nuwa ê du âô goro ê nüru i kêe, â é câtùra goro wàrapûruê. Â é wicèpwiri ê jawé ûrea na dau maina wâri wèe, naa gòro ê du âô. ");
INSERT INTO priNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Ba dau maina ê pimeaari kêe, ba dau wâru ê pâ èpà kêe na jèe pwanauri. Â gà têre, wà pwi âboro na càcaa pwanauri têe pâ èpà kêe na wâru, âna o càcaa maina ê pimeaari kêe.» ");
INSERT INTO priNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Â é ina tà i tô ilàri pâ: «Tôoni, jèe pwanauri ê pâ èpà'gà.» ");
INSERT INTO priNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Â wà tàpé na rà gére picaatâa ma wàé goro taapà, âna rà pi-ina tàra pâ: «Wàilàapà pwi âboro bèeni, na pâri ma é pwanauri ê pâ èpà?» ");
INSERT INTO priNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Â é ina tà i tô ilàri wà Iésu pâ: «Cidòri nyuâagà co tôoni! Gà udò ma tâa tâgà ê *âji wâro gée goo ê cèikî'gà! Â gà pâra, â ée mwa tâa jaagà ê pinaanapô.» ");
INSERT INTO priNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","2","Gée na càùé, â rà pâra wà Iésu ma wà tèpa 12 a *câmu kêe, naa na pâ village. Â é picémara naawê ê *Picémara Wâdé goo ê *Mwaciri kà Pwiduée. Pwa mwara pa ilàri na rà pâra wiârà—wà pa ilàri na ia é nama tiàu maagé kàra, ma tü târa pâ duée gée goorà: Wà Maria gée Magdala na ia é tü târa pâ 7 duée gée gooé; ");
INSERT INTO priNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Wà Jeanne, tô wâdà Chuza, pwi caa kà tèpa ênawéna kà ukai *Héroda; Wà Suzanne; Wâru mwara pàra ilàri na rà mu naa mwani ma neemururà, ba na rà pitu tà Iésu ma tèpa câmu kêe. ");
INSERT INTO priNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Dau wâru ê pâ âboro na rà medari Iésu, gée na pâ village. Â é ina tàra ê ucina bèeni: ");
INSERT INTO priNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","«É mwa tâa wà pwi jè âboro. Â é mwa còobé, na jè tòotù, ba na é uri ê arapwüru. Â é uri, â é uri, â é uri… Â napwa ê pàra arapwüru, âna rà tûu naa gòro nyi nari naigé na aupwanapô â rà còogai tèpa âboro. Â rà me pâ marü, â rà uti diri. ");
INSERT INTO priNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Â napwa ê pàra pwi, âna rà tûu naa gòrotàrarà. Â rà pò ma cipu, êco na rà marü, ba ticè jawé wê. ");
INSERT INTO priNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Â napwa ê pàra pwi, âna rà tûu naa nabibiu kâra pâ nari upwâra na pwa daarà. Â, na rà cipu i pâ nari upwâra bèepwiri, â rà câtàmwara i arapwüru. ");
INSERT INTO priNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Â napwa ê pàra pwi, âna rà tûu naa na napuu na wâdé. Â rà cipu, â rà imaina too, â rà tòpò pwârà na po dau wâru awé—tiagoro 100.» Â é tubanabwé ê ucina bèepwiri wà Iésu â é tomara too pâ: «Wà pwina pwa pwâranyüruê, âna wâdé na é têre!» ");
INSERT INTO priNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Wà tèpa câmu kêe, âna rà tawèeri Iésu goo ê pai ina wàra ê ucina bèepwiri. ");
INSERT INTO priNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Â é tòpi tàra pâ: «Wà Pwiduée, âna é paari tàwà ê âji pai pwa goo ê Mwaciri kêe. Êco na, napwa naa goo diri ê pàra âboro, âna rà o nye po têre co ê pâ ucina {ba na: Rà côo taaci, â càra caa côoina; rà têre taaci, â càra caa têreina }.» ");
INSERT INTO priNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","É ina tàra mwara wà Iésu, pâ: «Wàéni ê pai ina wàra ê ucina bèepwiri: Ê arapwüru, âna ê Popai kà Pwiduée. ");
INSERT INTO priNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","«Â ê pàra arapwüru, âna rà tûu naa gòro naigé. Ê naigé, âna é ipwacèwii naa goo wà tèpa âboro, na rà têre ê popai, êco na é tèepaa me côwâ wà *Caatana. Â é dàgòtù côwâ ê popai, gée na ê pwâranümarà. Ba péa rà tà cèikî naa goo, â rà udò ma tâa tàra ê *âji wâro. ");
INSERT INTO priNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","«Â ê pàra arapwüru, âna rà tûu naa gòrotàrarà. Ê gòrotàrarà, âna wà tèpa âboro na rà tòpi ê popai naa na ipwàdée, â rà tàpo cèikî na jè pàara. Êco na càcaa wàawà naa goorà ê popai na rà têre. Â ûna tèepaa me marirà ê tacai, â rà nama panuâ cèikî. ");
INSERT INTO priNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","«Â ê pàra arapwüru, âna rà tûu naa na ê pâ na nari upwâra na pwa daarà. Ê napuu bèepwiri âna wà tèpa âboro na rà têre ê popai, êco na, ûna rà pâra, â rà tapoo pidumapiê goro ê pâ namuru na tèepaa naa na gòropuu bèeni. Â rà itàa burà ê pâ neemuru gòropuu, bau ê pâ muru na rà wâdéari. Â câamwara ê popai naa goorà, â o càra caa tòpò cè pwêe na târa. ");
INSERT INTO priNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","«Êco na, napwa naa goo pàra arapwüru, âna rà tûu naa na ê napuu na wâdé. Â ê pwi napuu bèepwiri âna wà tèpa âboro na rà *tàrù ma âjupâra, ma wâdé ê pwâranümarà. Â ûna rà têre ê popai, â rà tòpi, â rà pitêre dàra. Â rà pidàpwicâarirà, â pwa pwâra ê popai naa goorà.» ");
INSERT INTO priNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","É ina tàra mwara wà Iésu pâ: «Câjè caa nuri ê wâra ânye, ma jè cajipi goro ê jè cio, é wâpà wiàna jè tòpò na aranara aupuu! Bwa! Jè nye tòpò dòiti, ba na rà o côo bwàti wà tàpé na rà tò naawê. ");
INSERT INTO priNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Êdiri pâ muru na jèe naapwàniri, âna o mwa paari naa na pwéelaa. Â o pâri ma jè côo bwàti. ");
INSERT INTO priNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Guwà pwacôoco bwàti ê popai na guwà têre, târa ma pimaina too ê pwina guwà tâmogòori! Ba wà pwina jèe pwa têe, âna o jèu âjagò têe côwâ. Â wà pwina kîri ê pwina tà têe, âna o dàgòtù jiié côwâ ê ji dàramuru na tà têe.» ");
INSERT INTO priNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Gée na càùé, â rà tèepaa me wà nyaa kà Iésu, ma wà tèpa jiié, ba na rà côoê. Êco na càcaa pâri ma rà medarié, gée goro ê pai wâru wàra pâ âboro na rà tâbèepié. ");
INSERT INTO priNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Â é ina tà Iésu wà pwi jè âboro, pâ: «Gà côo, rà wâboo gòroigé wà nyaa'gà ma wà tèpa aéjii'gà. Â rà mudàgà.» ");
INSERT INTO priNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Â é tòpi tàra pâ: «Guwà têre, wà tàpé na rà têre ê popai kà Pwiduée, â rà wârori, âna wàilà kaa pwiri tô nyaa kôo, ma wà tèpa aéjii kôo.» ");
INSERT INTO priNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Na jè tòotù, â rà tò naa gòro ê jè wànga wà Iésu ma wà tèpa câmu kêe. Â é ina tàra pâ: «Jè gée naanigée, na ére gée côwâ kâra nawià.» Â rà còpòo. ");
INSERT INTO priNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Â, na rà pâra, â é puu wà Iésu. Â é tapoo uu ba maina i pwéretòotù naa nawià. Â jèe pimaina too wià, â jèe pwii naa na i wànga. ");
INSERT INTO priNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Â rà patàcî Iésu, â rà ina têe pâ: «Pwi a pwa pupûra, jè o jèe mwü!» Â é pwa i pwéretòotù bau i nawià. Â é nye coo kaa i pòu, â é nye po tànana kaa i napô. ");
INSERT INTO priNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Â é ina tàra pâ: «Gona câguwà caa cèikî?» Êco na dau wâgotàra. Â rà pò gooé, â rà pi-ina tàra pâ: «É! Gona wàilàapà pwi âboro bèeni, na é pitûâ kâra ê pwéretòotù ma ê nawià, â ru pitêre dèe?» ");
INSERT INTO priNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Rà tèepaa wà Iésu ma wà tèpa câmu kêe, naa Gadara, wâna ére gée côwâ kâra napô Galilée. ");
INSERT INTO priNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","29","Na napô bèepwiri, âna pwa pwi jè âboro na pwa pâ duée gooé. Jèe gòiri na é pitâa nacârü, â é cicàpé. Â wâru pâ pàara, na rà ipa-imwüruê ê pâ duée, ma é pwa-imudirimuru. Â wà tèpa âboro wê, âna rà pwa ma pii ê du îê ma du âê ma tòoé goro itùpaò. Êco na é nye taaci pòpàgà kêe. Â rà cètùué pâ naa namaré i pâ duée. Ûna é boo gée gò i wànga wà Iésu naa napô kà pwi âboro-bà â wà pwiibà, âna é nye tèepaa me caraé kaa. Â wà Iésu, âna pwa na é tü târa pâ duée gée gooé. Êco na é tùu jùrué ma cigòboo na araé wà pwiibà, â é tomara too pâ: «Iésu, *Pwina naî Pwiduée nidò *napwéretòotù! Dà na nümagà dàra pwa tôo? Go ilari jiigà pâ, gà cibwaa pwa tôo cè pwina èpà.» ");
INSERT INTO priNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Â é tawèerié wà Iésu pâ: «Gona dà neegà?» Â é tòpi têe pâ: «Wâraduée.» Ba rà dau wâru tèpa duée na wâgooé. ");
INSERT INTO priNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Â rà tacoo goo wà Iésu, ma ina têe pâ: «Gà cibwaa tübà naa na i Oolaa! ");
INSERT INTO priNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Êco na gà naabà pâ ma bà too naa na ê pâ puàkà bèepwiri.» Ba pwa ê pé pubu puàkà na dau maina, na rà tàgére ija géeni gopaére jaa. ");
INSERT INTO priNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Â é naa tàra ê pwina rà ilari wà Iésu. Â rà còobé gée goo i pwi âboro, â rà gée naa goo i pâ puàkà. Â rà nye itàa kaa i pâ puàkà, géenidò gòro i jaa, boo naaniboo najawé, â rà mwü naawê. ");
INSERT INTO priNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Wà tèpa wéaari wàra i pâ puàkà, âna rà itàa pâ, nau wiâ ê jèkutâ bèepwiri, naaniboo na village, ma pitiri ê napô. ");
INSERT INTO priNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Â rà me ê pâ âboro, nau côo ê pwina gére tèepaa. Ûna rà tèepaa mwünyabweri Iésu, â rà côo i pwi âboro na ia pwa duée gooé, na é tàgére tâaboo na ara Iésu. Â é jèe coona ê pâ ârabwée, âna jèe po wâdé ê pai tâa kêe. Â nye po dàpàgà tàra, â dau maina ê pai wâgotàra. ");
INSERT INTO priNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Â wà tàpé na rà po côo diri ê pwina tèepaa, âna rà piwiâ tà pàra tàpé, ê jèkutâ goro i pai wâdé côwâ kêe. ");
INSERT INTO priNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Â wâgo tà tèpa âboro naa napô bèepwiri wâ Gadara. Â rà ina tà Iésu pâ, na é pâra jiirà. Â é tò naa gò i wànga, ba na é wâjué côwâ naa na ére gée côwâ kâra nawià. ");
INSERT INTO priNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Pwa na é pâra â i pwi âboro, âna é me nau ilari jiié pâ, na é pâra wiâê. Êco na é tòpi têe pâ: ");
INSERT INTO priNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","«Bwa. Gà wâjué naa pwârawâ'gà, â gà wiâ tàra diri ê pâ muru, na é pwa ba kâgà wà Pwiduée.» Â é wâjué côwâ wà pwini. Â é wiâ pitiri naa na i village, ê muru na dau pwényuâa na é pwa ba kêe wà Iésu. ");
INSERT INTO priNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","É tèepaa me wà Iésu naa na ére gée côwâ kâra nawià. Â rà tòpié naa na ipwàdée wà tèpa âboro wê, ba rà tàgére tapacîê. ");
INSERT INTO priNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Â é tèepaa medarié pwi jè âboro na nee Jaïrus, pwi jè caa kâra *wâra pitapitiri. Â é tùu jùrué ma cigòboo na ara Iésu. Â é tacoo gooé pâ, na é nama pâra wiâê, naa na pwârawâ kêe. ");
INSERT INTO priNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Ba wà tô nari èpo kêe, âna ée jèe pwa na é bà. Jèe 12 naja kêe, â nye wàé co tà du nyaa ma caa kêe. Â é pâra wiâê wà Iésu. Na é gére pâra wà Iésu, â wâru ê pâ âboro na rà po cibèepié, â rà dau pi-igabiarà. ");
INSERT INTO priNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Â é tâa nabibiu kà tèpa âboro bèepwiri, tô jè ilàri, na jèe po 12 naja kêe goro maagé, ba mu tèepaa me ê pàara na mu itàa domii gooé. Â é jèe po tubatiàu ê mwani kêe naa goro pâ dotée, êco na càcaa pâri ma rà nama tiàu maagé kêe. ");
INSERT INTO priNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Â é mee ni càù Iésu, â é tu naa goro ê gòobàra ârabwée kêe. Â nye nama coo kaa ê pai joro wàra ê domii gooé. ");
INSERT INTO priNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","É ina wà Iésu pâ: «Wàilàapà na tu naa goo i ârabwée kôo?» Â rà cau tòpi têe pâ: «Càcaa wàibà!» Â é ina têe wà Pétéru pâ: «Pwi a pwa pupûra, gorodà na gà ina pwiri? Ba gà côo, po dau wâru pâ âboro ni, â rà cibèepijè, â rà cau igabiarà naa googà!» ");
INSERT INTO priNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Êco na é ina mwara wà Iésu pâ: «Bwa. Pwa pwi jè âboro na é tu naa goo i ârabwée kôo. Ba go têre pâ é pâra gée gooò ê jè jènere nii kôo.» ");
INSERT INTO priNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Napwa naa goo wà tô ilàri, âna é céca, goro pai wâgotêe. Ba é côo pâ é tâmogòori ê pwina tàgére tèepaa wà Iésu. Â é tùu jùrué ma cigòboo na araé. Â é ina têe, na ara diri tèpa âboro, ê majoroé ma é tu naa gooé, ma ê pai nama tiàu ê maagé kêe. ");
INSERT INTO priNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Â é ina têe wà Iésu pâ: «Cidòri nyuâagà, co tôoni! Gà jèe wâdé côwâ goo ê cèikî'gà! Â gà pâra, â ée mwa tâa jaagà ê pinaanapô.» ");
INSERT INTO priNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Na é bwaa gére ina pwiri wà Iésu, â é tèepaa me wà pwi jè âboro, gée jaa Jaïrus, i pwi apooro i wâra pitapitiri. Â é ina tà Jaïrus, pâ: «Au! É jèe bà i èpo'gà. Â gà cibwaa cèpo tà pi-iluuri wà pwi a pwa pupûra.» ");
INSERT INTO priNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Â é têre ê pâ pwâratùra bèepwiri wà Iésu, â é ina tà Jaïrus, pâ: «Gà cibwaa pwa ma wâgotâgà! Â gà cèikî, ba ée mwa wâro!» ");
INSERT INTO priNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Ûna rà tèepaa pâ naa pwârawâ kà Jaïrus, â pwa na é tò wà Iésu, nau côo i tô nari èpo. Â é papwicîri jii tèpa âboro na rà tò naa na i wâ; wàco Pétéru, ma wà Ioane, ma Jacques, bau du nyaa ma caa kâra i èpo. ");
INSERT INTO priNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Ba rà cau gére i ma pijinünü goo wà tô èpo. Â é ina tàra pâ: «Guwà cibwaa i, ba câé caa bà; â é nye po puu.» ");
INSERT INTO priNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Â rà pitaurèe gooé, ba rà tâmogòori bwàti pâ é jèe bà. ");
INSERT INTO priNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Â é tò naa na i wâ. Â é tu pâ naa goro î tô èpo, â é ina too pâ: «Tôoni, gà cimadò!» ");
INSERT INTO priNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Â é nye wâro côwâ kaa, â é cimadò! Â é ina wà Iésu tà tèpa âboro pâ: «Guwà naa cè uti kêe.» ");
INSERT INTO priNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Â ru nye dau pò kaa wà du nyaa ma caa kêe. Êco na é ina tàru wà Iésu pâ, na ru cibwaa pwa jèkutâ goo ê pwina tèepaa marirà. ");
INSERT INTO priNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","2","Wà Iésu, âna é todà tèpa 12 *apostolo kêe me naa jaaé. Â é panuârà pâ, ba na rà picémara târa pâ âboro ê *Mwaciri kà Pwiduée. Â é naa tàra ê tàrù ma pàtàmee, ba na rà tü târa ê pâ duée, ma nama tiàu maagé kà tèpa âboro. ");
INSERT INTO priNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Â é ina tàra pâ: «Guwà cibwaa pa cè muru wiàna guwà pâra—wiàna cè tâjò, ma cè atà, ma cè poloa, ma cè mwani. Â guwà nye coona co caapwi ârabwée. ");
INSERT INTO priNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","«Â wiàna tòpiwà naa na cè jè pwârawâ, â wâdé na guwà tâa wê, tiagoro cè tòotù cèna guwà mwa pâra gée na napô-bà. ");
INSERT INTO priNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Â wiàna càcaa nüma tèpa âboro na rà tòpiwà naa na cè jè ére, â guwà pâra géewê. Â guwà tauri ê dàuru puu goro âwà, ba na guwà paari pâ, càcaa wâdé ê pwina rà pwa.» ");
INSERT INTO priNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Â rà pâra wà tèpa *câmu naa na pâ village, â rà picémara ê *Picémara Wâdé, â rà nama tiàu maagé kà tèpa âboro. ");
INSERT INTO priNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","9","Wà pwi ukai *Héroda Antipas âna é têre ê jèkutâ goro pâ *câmu kâra pàtàmee na é pwa wà Iésu. Â é ina pâ: «Go pwa ma tépàgà nya Ioane Pwi a piupwaa. Â wàilàapà pwi âboro bèeni, na go têre pâ jèkutâ gooé?» Â é tapoo dumapiê, ba rà ina gooé wà pàra tàpé pâ: «Wàé, âna wàé *Ioane Pwi a piupwaa na é wâro côwâ gée na aubà.» Â wà pàra tàpé, âna rà ina pâ wà *péroféta Élia, é, pwi jè péroféta na jè pàara napô, na é wâro côwâ. Â wà Héroda, âna pwa na é côo mwara wà Iésu. ");
INSERT INTO priNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Rà wâjué côwâ wà tèpa apostolo gée na pâ village, â rà pitapitirirà naa jaa Iésu. Â rà piwiâ têe diri ê pâ namuru na rà pwa. Â é poparà pâ naa na jè ére na wâmwünyabweri ê village Bethsaïda, ba na rà tâa acari wê. ");
INSERT INTO priNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Êco na wâru ê pâ âboro, na rà têre pâ rà pâra naawê, â rà pâra wiârà. Â é tòpirà wà Iésu, â é pacâmurirà goro ê Mwaciri kà Pwiduée, â é nama tiàu maagé kàra. ");
INSERT INTO priNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Jèe pwa na é duu i tòotù, â rà medarié wà tèpa câmu kêe, â rà ina têe pâ: «Gà panuâ pâ ê pâ âboro bèeni naa na pâ village ma pâ pwârawâ na tàmwünyabwe, ba na rà o pa cè uti kàra, ma puu wê. Ba aupiticia ni.» ");
INSERT INTO priNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Â é tòpi tàra pâ: «Bwa, guwà naa cè uti kàra!» Â rà ina têe pâ: «Auwa! Nye 5 poloa co, ma ârailu ârawéà na wâjaabà! Gona nümagà na bà pâra nau wâri cè utimuru ba kàra diri? Ba o nye êco kaa pwiri cè pai naa cè uti kàra!» ");
INSERT INTO priNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","(Ba ê jéû tèpa paao maina na rà tâa wê, âna po 5 000 kaamwara.) Â é ina tàra wà Iésu pâ: «Bwa. Guwà ina târa ê pâ âboro bèeni pâ, rà pwa nari pubu goro 50 jècaa, â rà tâaboo.» ");
INSERT INTO priNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Â rà cau tâaboo tèpa âboro. ");
INSERT INTO priNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Â é popa i pâ 5 poloa ma i du ârawéà wà Iésu. Â é tagòtùé too *napwéretòotù, â é pwaolé tà Pwiduée. Â é tubiti i poloa, â é naa tà tèpa câmu kêe, â rà ipâdi târa ê pâ âboro. Â é wàrapwiri târa mwara i du ârawéà. ");
INSERT INTO priNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Â rà cau ija diri, tiagoro na rà jèe po cau pwàro diri. Â rà panaimari côwâ ê dàra noo kâra poloa. Â ê dèreè, âna rà pwaai 12 nakébò goo. ");
INSERT INTO priNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Na jè tòotù, â é pwapwicîri acari wà Iésu. Ûna é nabwé â é medari tèpa câmu kêe, â é tawèerirà pâ: «Gona dà na rà ina gooò wà tèpa âboro? Rà ina pâ gona wâgo wàa?» ");
INSERT INTO priNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Â rà tòpi têe pâ: «Rà ina wà pàra pwi pâ wâgà Ioane Pwi a piupwaa. Â rà ina wà pàra tàpé pâ wâgà péroféta *Élia. Â rà ina wà pàra tàpé mwara pâ gà pwi jè ârapàara tèpa péroféta biu, na é wâro côwâ gée na aubà.» ");
INSERT INTO priNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Â é tawèerirà wà Iésu pâ: «Â, na wâguwà na?» Â é tòpi têe wà Pétéru pâ: «Wâgà, âna gà pwi *Mesia, *pwi a pa-udò na gà me gée jaa Pwiduée!» ");
INSERT INTO priNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Êco na é nye âji papwicîri jiirà kaa na rà inapàpari pwiri. ");
INSERT INTO priNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","É ina tàra pâ: «O tèepaa ê pàara, na go mwa dau pwa ê maagé côo na wâgo *Pwina naîri âboro. Ba wà tèpa pitûâ; ma wà tèpa caa kà tèpa pwa *ârapwaailò; ma wà tèpa *dotée goro ê Naèà, âna o nye tàutàra gooò. Â rà mwa pwa ma go bà. Êco na, naa na béâracié kâra tòotù gée na càùé, âna go mwa wâro côwâ.» ");
INSERT INTO priNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","É ina tà diri tèpa âboro wà Iésu pâ: «Wiàna nüma cè pwi jè âboro na é me wiâô, â é cibwaa mwa tà piniimiriê côwâ. Â, diri na pâ tòotù, âna wâdé na é kâa ê *kurucé kêe, â é me wiâô. ");
INSERT INTO priNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Ba wà pwina nümee na é ipwamuru ê wâro kêe, âna ée mwa tubatiàu. Â wà pwina é panuâ ê wâro kêe ba kôo, âna wà pwiibà, âna ée udò â o tâa têe ê *âji wâro. ");
INSERT INTO priNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Â târa dà kà pwi âboro na é tòpi diri ê pâ neemuru gòropuu, wiàna é tubatiàu ê nyuâaê? ");
INSERT INTO priNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","«Wà pàra tàpé, âna rà kamu gooò ma ê popai kôo na ara pâ âboro. Â, na wàrapwiri, â wâgo, Pwina naîri âboro, âna go o mwa kamu goorà, wiàna go o mwa me, naa na pwi tòotù kôo. Na pwi tòotù-bà â o paari ê pai maina ma muugère ma pai pwicîri kâbà, ma Caa kôo ma wà tèpa *angela kêe. ");
INSERT INTO priNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Â go ina tàwà ê âjupâra pâ: Wà pàra tèpa gére wâni nabà, âna rà bwaa côo ê pai tèepaa kâra i Mwaciri kà Pwiduée, béaa kâra cè pai bà kàra.» ");
INSERT INTO priNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Wâpâ na 8 tòotù gée na càùru ê pai ina kà Iésu pwiri, â é popa wà Pétéru, ma Ioane, ma Jacques. Â rà too, naa gòrojaa, ba na rà pwapwicîri wê. ");
INSERT INTO priNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Ûna é gére pwapwicîri wà Iésu, â pitòotéri pai côo ê naporomee. Â pâra ma po dau pwaa ê pâ ârabwée kêe, â é pwâra. ");
INSERT INTO priNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","31","Â ru nye tèepaa kaa wà *Moosé ma wà Élia, tupédu péroféta béaa. Â po dau maina awé ê muugère kà Pwiduée naa goorà. Â rà pitùra ma wà Iésu goro ê pai o bà kêe na *Iérusaléma. Ba o wàrapwiri ê pai o pacoo ê auniimiri kà Pwiduée gée na biu. ");
INSERT INTO priNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Ûna rà gére wàrapwiri, âna rà tàgére puu wà Pétéru ma wà tupédu a câmu bée, goro pai oratàra. Ûna rà tàcî, â rà côo ê pai muugère kà Iésu, â rà côo wà tupédu péroféta, ");
INSERT INTO priNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","na pwa na ru pâra jiirà. Â é nye ina kaa wà Pétéru pâ: «Pwi a pwa pupûra, nye po dau wâdé tâbà, na bà gére tâa ni jaagà. Â wâdé na bà pacima cè tèpa âracié nacapè—ba kâgà jèpwi, â kà Moosé jèpwi, â kà Élia jèpwi.» É ina pwiri, ba câé caa tâmogòori cèna é ina, goo pai dàpàgà têe. ");
INSERT INTO priNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Na é bwaa gére tùra, â é nye tèepaa me kaa ê jè nee, â é cajipirà. Â po dau wâgotàra ma wà tupédu a câmu bée. ");
INSERT INTO priNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Â rà têre ê pwâratùra gée na nee, na ina pâ: «Wà pwini, âna wàé co kaa pwiri, wà Pwina naîô na caapwi co na go pitòrigarié. Â guwà pitêre dèe.» ");
INSERT INTO priNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Ûna é nabwé i pwâratùra, â jèe nye tà wàilà acari ma wà Iésu. Â càra caa pwa jèkutâ goo, naa na pâ parui na wâru. ");
INSERT INTO priNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Na dàuru kêe, â rà boome côwâ gée gòrojaa wà Iésu ma wà tèpa âracié a câmu kêe. Â rà medarirà pâ âboro na dau wâru. ");
INSERT INTO priNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Â pwi jè ârapàararà, âna é tomara too, ma ina tà Iésu pâ: «Pwi a pwa pupûra, go ilari jiigà pâ, gà pitu tà pwina naîô, na é caapwi co. ");
INSERT INTO priNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Ba é mu popaé ê duée, â é mu nama é uu, ma tûu ma pòtàta pâ napuu, â é nama còobé ê pâ oropwêe. Â é mu po dau pwatarié, ma tubaèpà têe, béaa kâra pai còobé kêe gée gooé. ");
INSERT INTO priNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Â go ilari jii tèpa câmu'gà pâ, na rà tü târa i duée, êco na càcaa pâri naa goorà.» ");
INSERT INTO priNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Â é ina tàra wà Iésu pâ: «Au, go nyi meaariwà wâguwà tèpa âboro nabà! Ba bwaa câguwà caa cèikî, â guwà tèpa imwüru! Tiagoro wiidà na go o bwaa nye tà tâa jaawà, ma pidàpwicâariô naa goowà? Popa me cai naani i pwi nari âboro èpo!» ");
INSERT INTO priNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Ûna rà gére popaé me, â i duée, âna é tüê boo naa napuu, â é nama é céca. Â é nye pwa kaa i duée wà Iésu. Â é nye nama tiàu maagé kà pwini, â é naaê tà caa kêe. ");
INSERT INTO priNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Â rà po dau pò wà diri tèpa âboro, na rà côo ê câmu bèepwiri kâra ê pàtàma Pwiduée na dau maina. Wà tèpa âboro, âna rà picâdiri diri ê pwina é pwa wà Iésu. Â é ina tà tèpa câmu kêe pâ: ");
INSERT INTO priNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","«Guwà têre bwàti, ma tà niimiri ê pwina go ina tàwà: O mwa icurio tà tèpa âboro, wâgo Pwina naîri âboro. Â rà o tâjùruo, â rà o pwa ma go bà.» ");
INSERT INTO priNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Êco na càra caa tâmogòori ê pwina é ina. Ba cârü tàra ê pai ina wèe. Â wâgotàra na rà tawèerié goo. ");
INSERT INTO priNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Gée na càùé, â rà tapoo pitòocia wà tèpa câmu. Rà pitawèerirà pâ, o wàilàapà gée goorà cè pwina pwamuru naa gooé. ");
INSERT INTO priNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Êco na é tâmogòori ê pwâra-nümarà wà Iésu. Â é popa ji nari èpo, â é tòpòé boo naa goro jènereê. ");
INSERT INTO priNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Â é ina tàra pâ: «Wà pwina é tòpi naa na neeô pwi jè nari èpo pwacèwii pwini, âna é tòpio. Â wà pwina é tòpio, âna é tòpi mwara Pwina é cùruo me. Ba wà pwina é dau ipakîriê, naa nabibiu kàwà, âna wàé kaa pwiri, wà pwi âboro na é imaina.» ");
INSERT INTO priNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","É ina wà Ioane tà Iésu pâ: «Pwi a pwa pupûra, bà côo pwi jè âboro, na é tü târa ê pâ duée, naa na neegà. Â pwa na bà ina têe pâ, na é cibwaa pwa, ba câé caa pwi béejè.» ");
INSERT INTO priNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Â é tòpi tàra pâ: «Guwà cibwaa pacooé! Ba wà pwina câé caa cicarajè, âna é pwi béejè.» ");
INSERT INTO priNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","O jèe tèepaa ê pàara na o mwa dàgòtù côwâ wà Iésu naa napwéretòotù. Â é nye ipagòorié, ba na é pâra naa Iérusaléma. ");
INSERT INTO priNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Â é cùru béaa tèpa ipa popai kêe pâ, na rà pâra naa na jè village na napô *Samaria, ba na rà o pwabwàti ê pai o tèepaa pâ kêe. ");
INSERT INTO priNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Êco na wà tèpa âboro wê, âna tàutàra gooé. Ba rà têre pâ ée mwa caa pâra géewê naa Iérusaléma, ville wâ napô *Judée. ");
INSERT INTO priNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Ûna ru têre ê pwiibà wà tupédu a câmu kêe, wà Jacques, ma wà Ioane, â ru ina têe pâ: «Kaa! Pwi Ukai, jè mwa ilari ê ânye napwéretòotù, ba na cîri tàpéeni!» ");
INSERT INTO priNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Â é tabiié Iésu, â é nye pwaru kaa: {«Câgàu caa tâmogòori pâ po dau èpà pwâranümau! ");
INSERT INTO priNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Ba wâgo Pwina naîri âboro, âna câgo caa me, ba na rà bà wà tèpa âboro. Â go me, ba na rà udò.}» Â rà pâra naa na jè village. ");
INSERT INTO priNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Na rà pâra wii naigé, â é medari Iésu wà pwi jè âboro, â é ina têe pâ: «Nümoo na go pwi a câmu'gà â go o pâra wiâgà, naa na diri cè ére cèna gà o pâ wê.» ");
INSERT INTO priNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Â é tòpi têe wà Iésu pâ: «Ê pâ macii a piugà, âna pwa aucârü kàra, â pâ marü, âna pwa na wânaîrà. Â napwa naa gooò, Pwina naîri âboro, âna nye ticè aunao kôo.» ");
INSERT INTO priNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Â ipaiwà naa goo pwi jè âboro. Ba é ina têe wà Iésu pâ: «Gà me wiâô.» Êco na é ina têe wà pwini pâ: «Tàpo coo. Ma go jèe mara pâra nau ipwàniri caa kôo.» ");
INSERT INTO priNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Â é tòpi têe wà Iésu pâ: «Bwa, gà naaco tèpa bà, ma rà nye ipwànirirà côwâ! Â wâgà, âna gà pâra, â gà inapàpari ê Mwaciri kà Pwiduée.» ");
INSERT INTO priNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Napwa naa goo pwi jè âboro, âna é ina tà Iésu pâ: «Üu, co Pwi Ukai, go o mwa pâra wiâgà. Êco na gà naaô ma go mara picijii ê tâa kôo.» ");
INSERT INTO priNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Â é tòpi têe wà Iésu pâ: «Wà pwina é tòpò îê naa goro ê béû, â é ciburà niâ wâjué côwâ, âna wà pwiibà, âna o càcaa pâri ma é tò naa na Mwaciri kà Pwiduée.» ");
INSERT INTO priNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Wà Pwi Ukai, âna é pitòrigari 70 âboro, â é ipanuârà ba ârailu, béaa kêe, naa na pâ village ma pâ ére na é niimiri pâ é pâra naawê. ");
INSERT INTO priNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Â é ina tàra pâ: «Dau maina ê ârapiûnya na o pwa. Êco na càcaa wâru a wakè. Guwà pwapwicîri ma ilari cai jii pwi apooro aupwanapô, ma é panuâ me mwara cè pàra tèpa wakè, ba na rà o pitu. ");
INSERT INTO priNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Guwà pâra, â guwà ipwacôoco! Ba go cùruwà pwacèwii ê pâ nari mutô naa nabibiu kâra macii a piuti. ");
INSERT INTO priNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Â, na guwà pâra, â guwà cibwaa pa cè mwani, ma cè atà. Â guwà popa co du wâraâwà. Â guwà cibwaa tà pwa jèkutâ ma cè jè âboro wii naigé.» ");
INSERT INTO priNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","«Â, na guwà tò naa na jè pwârawâ, â guwà ilari jii Pwiduée ê aupwényunyuâari ma pinaanapô kêe, naa gò tàpé na rà tâa wê. ");
INSERT INTO priNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Â wiàna rà tèpa âboro na rà jèe tâa na ê pinaanapô, â o mwa tâa tàra ê aupwényunyuâari. Â wiàna càcaa wàrapwiri, â o nye wâjué côwâ naa gòwà ê aupwényunyuâari kàwà. ");
INSERT INTO priNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Na guwà tâa na cè jè village, â wâdé na guwà tâa na caapwi pwârawâ. Â guwà cibwaa piwâ na guwà tòpi jiirà ê utimuru, ba wà pwi a wakè, âna wâdé na é tòpi ê uti kêe. ");
INSERT INTO priNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","«Wiàna rà tòpiwà wà tèpa âboro naa na village, â guwà tòpi ê utimuru na rà naa tàwà. ");
INSERT INTO priNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Â guwà nama tiàu ê maagé kà tèpa âboro wê. Â guwà ina tàra jècaa pâ: “É tàgére tòpò ê Mwaciri kêe wà Pwiduée, â gà jèe tàmwünyabwerié!”» ");
INSERT INTO priNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","«Wiàna càra caa tòpiwà naa na jè village, â guwà pâra naa na aupitapitiri kà tèpa âboro, â guwà inapàpari tàra pâ: ");
INSERT INTO priNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Bà câtùra ê dàuru puu kâra ê napô kàwà, gée goo âbà, ba naa câmu kâra ê pitèimuru kà Pwiduée! Â guwà ipwacôoco, ba jèe tàmwünyabweri ê Mwaciri kêe!” ");
INSERT INTO priNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","«Â go ina tàwà ê âjupâra pâ: Ée mwa pwa wârimuru tàra wà Pwiduée, na Tòotù na ée mwa pitèi pâ âboro. Â o dau maina ê wârimuru kàra, jii tàpé gée *Sodoma. ");
INSERT INTO priNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","«Guwà ipwacôoco, wâguwà tèpa âboro wâ Korazine ma Bethsaïda! Ba o naa wârimuru tàwà! Ba go jèe pwa pâ muru na dau maina naa jaawà, â câguwà caa cèikî! Niimiri cai du ville Tyr ma Sidon biu, âna dau èpà ê tûâ kà tèpa âboro wê. Êco na, wiàna rà côo ê pwina go pwa naa jaawà, â pwiri jèe gòiri cè pai pitòotéri ê wâro kàra. Â pwiri rà paari naa goro cè pai coona dodà kàra, ma pitâmirà goro dà! ");
INSERT INTO priNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Â o dau maina ê wârimuru kàwà, jii tàpé Tyr ma Sidon. ");
INSERT INTO priNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","«Â ipaiwà naa goowà, wâguwà tèpa âboro naa na village Capernaüm. Ba guwà niimiri pâ pwamuru naa goowà, â guwà pwacèwii Pwiduée. Bwa! Nye piticèmuru naa goowà, â ée mwa naawà boo dari tèpa bà!» ");
INSERT INTO priNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Â é ina mwara wà Iésu tà tèpa âboro kêe pâ: «Wiàna é pitêre dàwà cè pwi jè âboro, âna wâgo na é pitêre dòo. Â wiàna câé caa tòpiwà cè pwi jè âboro, âna wâgo na câé caa tòpio. Â wiàna câé caa tòpio, âna câé caa tòpi Pwina é cùruo me.» Â rà pâra pâ wà tèpa 70. ");
INSERT INTO priNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Ûna rà wâjué me côwâ, âna po dau maina pai ipwàdée kàra, â rà ina pâ: «Pwi Ukai, gà côo, wà mwara tèpa duée, âna rà pitêre dàbà, na bà tü tàra naa na neegà!» ");
INSERT INTO priNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Â é tòpi tàra wà Iésu pâ: «Guwà têre! Go côo wà *Caatana, na é tûuboo gée napwéretòotù pwacèwii ê âra! ");
INSERT INTO priNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Â go jèe naa tàwà ê tàrù ma pàtàmee, naa gò Caatana. Â guwà o pâra gòro cè dòèa, ma cè keecii, â o nye ticè cèna côwâriwà. ");
INSERT INTO priNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Êco na guwà cibwaa ipwàdée co, gée goro na rà pitêre dàwà ê pâ duée! Â wâdé na guwà dau ipwàdée, gée goro na é jèe wii ê neewà wà Pwiduée, naa na Tii kêe, naa *napwéretòotù.» ");
INSERT INTO priNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Ûna é ina pwiri wà Iésu, â é nye dau ipwàdée kaa goro ê Nyuâaê Pwicîri. Â é ina tà Pwiduée pâ: «Go ipwaolé tâgà, co Caa, wâgà na gà Pwi Ukai kâra napwéretòotù ma gòropuu! Ba gà naapwàniri pâ muru bèepwiri, jii tèpa tâmogòorimuru ma wà tèpa tàmanga, â gà paari tà tàpé na càra caa câmu. Ba nye wiâra ê câbawâdé'gà.» ");
INSERT INTO priNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Â é ina tà tàpé na rà têreê pâ: «Êdiri ê pwina tâa tà Caa kôo, âna é jèe naa tôo. Nye wàé co na é tâmogòorio, wâgo Pwina naîê. Â nye wâgo co na go tâmogòorié. Â go paarié tà pàra tàpé, ba na rà tâmogòorié mwara.» ");
INSERT INTO priNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Ûna rà tâa acari ma wà tèpa *câmu kêe, â é ina tàra wà Iésu pâ: «Dau wâdé ba kàwà, ma cidòri nyuâawà, ba wâguwà na guwà côo pâ muru na dau pwényuâa! ");
INSERT INTO priNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Ba go ina tàwà pâ: Wâru tèpa *péroféta ma tèpa ukai na dau nümarà na rà côo ê pwina guwà côo, êco na càra caa côo. Â nümarà na rà têre ê pâ popai na guwà têre, êco na càra caa têre.» ");
INSERT INTO priNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Na jè tòotù, âna é tèepaa medari Iésu wà pwi jè *dotée goro ê Naèà. Ba nümee na é tacaié. Â é tawèerié pâ: «Pwi a pwa pupûra, dà cèna go pwa, ma o tâa tôo ê *wâro dàra gòiri jaa Pwiduée?» ");
INSERT INTO priNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Â é tòpi têe wà Iésu pâ: «Dà cèna wii naa na ê *Naèà? Dà cè pai tâmogòori'gà?» ");
INSERT INTO priNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Â é ina têe i pwi âboro pâ: «Wâdé na gà meaari Pwi Ukai Pwiduée'gà, gée na diri ê pwâranümagà, ma ê wâro'gà, ma ê nii'gà, ma ê pai tâmogòori'gà.Â gà meaari tèpa âboropwacèwii ê pai pimeaarigà côwâ.» ");
INSERT INTO priNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Â é tòpi têe wà Iésu pâ: «Üu kaa. Gà po tòpi bwàti. Â gà wàrapwiri cè pai pwa'gà, ba na o tâa tâgà ê *âji wâro.» ");
INSERT INTO priNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Êco na wà i pwi âboro, âna nümee na é paari pâ é *tàrù. Â é tawèerié mwara pâ: «Â gona wàilàapà pwi âboro, na wâdé na go meaarié?» ");
INSERT INTO priNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Â é pwa ucina wà Iésu, ba na bétòpi têe. É ina pâ: «É mwa tâa wà pwi jè âboro, pwi jè jènerejè, tèpa *Juif. Â, na jè tòotù â é mwa boo gée *Iérusaléma naa Iériko. Â, na é pâra wii naigé, â rà èié ma pwatarié wà tèpa mura. Â rà popa diri pâ mwani kêe ma pâ ârabwée kêe. Â rà panuâê na pwa na é jèe bà. ");
INSERT INTO priNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","«Â nabwé, â é me wii naigé wà pwi jè jènerejè wà pwi jè a pwa *ârapwaailò. Ûna é pâmari i pwi âboro, â é nye pàgà kaa gooé, â é nye pâra wii naigé kêe. ");
INSERT INTO priNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Â é tèepaa me wà pwi jè ênawéna kâra *Wâra pwapwicîri. Â é nye pwacèwii pwi a pâbéaa, â é nye wiâ naigé kêe. ");
INSERT INTO priNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","«Â nabwé, â é tèepaa me pwi jè ârapàara tàpé *Samaria—wàilà na guwà pièpà ma wàilà. Â é côo i pwi âboro, â nye dau maina kaa pai meaarié kêe. ");
INSERT INTO priNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Â é tuboo naa gooé, â é wicèpwiri ê wâi, naa gòro pâ aurumuru kêe, â é târamiri. Â é tàmee too naa gòro i buriko kêe. Â é popaé pâ naa na wâ kà tèpa pârame, â é wéaarié naawê. ");
INSERT INTO priNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","«Na dàuru kêe, âna é ipwa-bwàtié, ba na é wiâ côwâ ê naigé kêe. Â é naa mwani târa i pwi apooro i pwârawâ ma ina têe pâ: “Gà wéaari bwàti wà pwini. Â wiàna càcaa pâri ê mwani bèeni, â go mwa wâri cè dèreè, wiàna go wâjué me côwâ.” «Â nabwé, â é pâra wii naigé kêe.» ");
INSERT INTO priNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Â é tubanabwé ê ucina bèepwiri wà Iésu, â é tawèeri pwi dotée goro ê Naèà pâ: «Wàilàapà, gée goo tèpa âracié âboro bèepwiri, na é âji meaari wà i pwi âboro na pwatarié? Wàilàapà na é pwi âji jènereê? Dà cè auniimiri'gà?» ");
INSERT INTO priNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Â é tòpi i pwi dotée goro ê Naèà pâ: «Wà pwi na ia é pwa na wâdé têe ma pitu têe.» Â é ina têe Iésu pâ: «Gà pâra, â gà ipwacèwiié!» ");
INSERT INTO priNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Rà pâra wii naigé dàra Iérusaléma wà Iésu ma tèpa câmu kêe. Â rà tèepaa naa na jè village, na é tâa wê tô ilàri na nee Marthe. Â é tòpirà na pwârawâ kêe. ");
INSERT INTO priNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Â pwa tô jiié, na nee Maria, na é tâaboo naa jaa Iésu, ba na é tàmaari diri ê popai kêe. ");
INSERT INTO priNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Â wà Marthe, âna é nye gére pâracùu goro pwaailò, â é putàmu naa goo tô jiié, â é ina tà Iésu pâ: «Pwi Ukai, wà tô jiio, âna é nye tà panuâô ma go wakè acari! Â pwiri nye wâdé ba kâgà? Gà ina têe pâ é me, ma é pitu tôo!» ");
INSERT INTO priNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Â é ina têe wà Pwi Ukai pâ: «Au, tôoni, gà po dau géaa nabà, goro pâ muru na piticèmuru naa goo. ");
INSERT INTO priNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Â gà côo, nye caapwi co ji muru na pwamuru naa goo. Â wà Maria, âna é jèe pâmari. Â o câ mwa caa pa jiié.» ");
INSERT INTO priNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Na jè tòotù, â é pwapwicîri na jè ére wà Iésu. Â gée na càùé, â wà pwi jè ârapàara tèpa *câmu kêe, âna é ina têe pâ: «Pwi Ukai, gà pacâmuribà goro pwapwicîri, ba é wàrapwiri wà *Ioane Pwi a piupwaa tà tèpa câmu kêe.» ");
INSERT INTO priNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","É tòpi têe pâ: «Wàéni cè pai pwapwicîri kàwà: “Pwi Caa kâbà, Wâdé naa papwicîri ê neegà. Wâdé naa coo ê Mwaciri'gà. ");
INSERT INTO priNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Gà naa tâbà cè utimuru cèna pâribà diri na pâ tòotù. ");
INSERT INTO priNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Gà pwanauri pâ èpà kâbà, pwacèwii na bà pwanauri tàra ê pâ èpà na rà pwa tâbà. Gà cibwaa panuâbà naa na tacai.”» ");
INSERT INTO priNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","6","Wà Iésu, âna é pacâmuri mwara tèpa câmu kêe goro ê pai pwapwicîri â é ina tàra ê ucina bèeni: «Guwà jèe niimiri cai ni: É tèepaa me wà pwi jè âboro naa jaagà, na po nabibiu kâra ne. Â ticè utimuru wâ pwârawâ'gà. Â gà itàa naa jaa pwi jè béegà, â gà ilari jiié ê âracié poloa. ");
INSERT INTO priNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","«Êco na é jèe puu wà pwini, â câé caa còobé naa googà, â é po ina boo co pâ: “Naaô! Bà jèe cau puu ma tèpa nari èpo kôo. Â jèe kiiri i goropwârawâ, â tàutôo dàra còobé!”» ");
INSERT INTO priNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Â é ina wà Iésu pâ: «Pwiri o câé caa pitu tâgà gée goo na é pwi béegà. Êco na ée mwa pitu tâgà, wiàna gà tà cùu taaci. Â gée goo pai pidàpwicâarigà ma wàrakee'gà, â ée mwa naa tâgà ê pwina nümagà goo. ");
INSERT INTO priNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","«Êkaa na go ina tàwà pâ: Wâdé na guwà nye tà ilari taaci jii wà Pwiduée ba ée mwa naa tàwà. Â guwà nye tà mudàra taaci, ba guwà o mwa pâmari. Â guwà nye tà cùu taaci ê goropwârawâ, ba o mwa tàpiri tàwà. ");
INSERT INTO priNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Üu, ba wà pwina é ilari, âna o naa têe. Â wà pwina é mudàra, âna é pâmari. Â wà pwina é cùu ê goropwârawâ, âna o tàpiri têe. ");
INSERT INTO priNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","«{Â o wàilàapà nawà, na o naa cè atü târa cè èpo kêe, wiàna é ilari jiié cè poloa?} O wàilàapà na o naa cè dòèa, târa cè èpo kêe, wiàna é ilari cè ârawéà? ");
INSERT INTO priNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Â o wàilàapà na o naa têe cè wàramiida wiàna é ilari cè narija? ");
INSERT INTO priNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Ba wâguwà, tèpa âboro èpà, âna guwà tâmogòori naa ê pwina wâdé tà tèpa nari èpo kàwà. Â wà Pwiduée Caa kàwà nidò napwéretòotù, na é wâdé, âna ée mwa naa, naa goro piticèmuru naa goo ê Nyuâaê Pwicîri, tà tàpé na rà ilari jiié.» ");
INSERT INTO priNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Na jè tòotù, â wà Iésu, âna é tü târa ê duée gée goo pwi âboro na é kûukû. Ûna é còobé i duée, â é nye tùra kaa i pwi a kûukû. Â rà pò gooé diri pâ âboro na rà tâa wê. ");
INSERT INTO priNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Êco na wà pàra tàpé gée goorà, âna rà ina pâ: «É tü târa ê pâ duée goro ê pàtàma *Caatana, pwi ukai kà tèpa duée!» ");
INSERT INTO priNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Wà pàra tàpé, âna nümarà na rà pitü tûâ têe. Â rà ina têe pâ: «Paari tâbà ê *câmu kâra pàtàma Pwiduée na wâgoogà.» Ba nümarà na rà paari pâ câé caa wakè goro pàtàma Pwiduée. ");
INSERT INTO priNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Â é tâmogòori auniimiri kàra wà Iésu. Â é ina tàra pâ: «Wiàna é ipaa dèe côwâ ê jè mwaciri, â o tédidirié. ");
INSERT INTO priNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Wiàna é ipaa dèe côwâ wà Caatana, â o wànau târa cè pai cimwü wàra ê mwaciri kêe?! Guwà ina pâ, go tü târa pâ duée goro ê pàtàma Caatana. ");
INSERT INTO priNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Êco na, wiàna wàrapwiri, â wàilàapà, na naa tà tèpa béewà ê pàtàmee, ma rà tü târa pâ duée? Bwa! Ê pwina rà pwa, âna paari tàwà pâ guwà tàgére pitanami naa gooò. ");
INSERT INTO priNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Ba wâgo, âna go tü târa pâ duée, goro ê pàtàma Pwiduée. Â wiàna wàrapwiri, â jè cau côo bwàti pâ é jèe mara tòpò ê Mwaciri kêe naa jaawà! ");
INSERT INTO priNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","«Â guwà jèe niimiri cai ni: Wà pwi âboro na pwa nii kêe, âna pwa gò ma da kêe, â o pâri ma é wéaari ê wâ kêe ma neemuruê. ");
INSERT INTO priNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Â càcaa wâgotêe, ba é pûra naa goo pâ neemuru paa kêe. Êco na, wiàna é me nau ipaa dèe pwi jè âboro na dau pwa nii kêe, â ée piétò jiié. Â ée mwa popa jiié diri pâ neemuru paa kêe, bau diri pâ muru na tâa na wâ kêe. ");
INSERT INTO priNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","«Guwà têre, wà pwina câé caa wâjaao, âna é cicarao. Â wà pwina câé caa pitu tôo ma bu panaimari, âna é tédidiri.» ");
INSERT INTO priNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","«Guwà têre cai ni: Wiàna pwa duée, goo pwi jè âboro; â wiàna é còobé gée gooé, â gona é pâ naapà? É paé ma me, na pâ ére na aupiticia. Ba é mudàra cè ére cèna é tâa wê. Êco na câé caa pâmari. Â é niimiri pâ, ‘Go wâjué pâ côwâ, naa na i pwârawâ kôo.’ ");
INSERT INTO priNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","«Â é wâjué, â é pâmari i wâ, âna nye po baléri bwàti, ma pitòimiri bwàti. ");
INSERT INTO priNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Â é wâjué nau mudàra tèpa 7 duée bée, na rà dau èpà jiié. Â rà tò nau pitâa na i wâ. Â wà pwi âboro-bà, âna é mwa dau èpà kaa jii béaa!» ");
INSERT INTO priNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Ûna é gére tùra wà Iésu, â é nye tomara too kaa tô jè ilàri—tô jè ârapàara tèpa âboro na rà tàmaari Iésu. Â é ina pâ: «Cidòri nyuâa tô ilàri na é pitàmarigà, ma pa-digà!» ");
INSERT INTO priNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Â é tòpi wà Iésu pâ: «Cidòri nyuâa tàpé na rà têre ê popai kà Pwiduée, ma pitêre dàra!» ");
INSERT INTO priNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Wâru tèpa âboro na rà pâmari wà Iésu, ba na rà tàmaariê â rà tapoo igabiarà naa gooé. Â é ina tàra mwara pâ: «Wà tèpa âboro nabà, âna rà dau èpà, ba càra caa pitêre dà wà Pwiduée. Â rà ciburà ilari jiié cè câmu kâra pàtàmee. O nye ticè câmu na rà mwa caa côo mwara, jii i pwi ia é tèepaa tà *péroféta Iona. ");
INSERT INTO priNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Ba wàépwiri ê câmu kêe tà tèpa âboro wâ Ninive pâ, nye wà Pwiduée na ia é cùrué pâdarirà. Â wàrapwiri ê pwina o tèepaa tôo *Pwina naîri âboro, na o câmu tà tèpa âboro nabà.» ");
INSERT INTO priNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","32","«Wà tèpa âboro wâ Ninive, âna rà têre ê pupûra kà péroféta Iona, â rà nye pinünüma ma pitòotéri ê càrarà. Â guwà côo, é wâni, pwi jè âboro na é dau piwéna jii Iona. Â o tèepaa ê Tòotù na ée mwa pitèi tèpa âboro na wà Pwiduée. Â, na tòotù-bà, âna wà tàpé Ninive, âna rà o cimadò na arawà, wâguwà tèpa âboro nabàni, â rà o piciapwâ goowà. Ba tàutàwà na guwà têre. «Â guwà jèe niimiri cai wà tô ilàri ukai naa napô Saba na pàara biu, âna ia é me gée napô kêe na dau wâiti, ba na é têre pwâratùra kà ukai *Solomona na tâbawêe goro autâmogòori kêe. Â guwà côo, é tà wâni jaawà pwi jè âboro na é dau piwéna jii Solomona. Â, na Tòotù na ée mwa pitèi ê pâ âboro na, wà Pwiduée, â wà tô ilàri ukai-bà, âna ée mwa cimadò na arawà, wâguwà tèpa âboro nabà, â ée mwa piciapwâ goowà. Ba tàutàwà na guwà pinünüma ma guwà biiwà!» ");
INSERT INTO priNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","«Câjè caa nuri ê wâra ânye, ma jè cajipi goro ê jè cio, é wâpà wiàna jè naapwàniri naa na jè ére! Bwa! Jè nye tòpò dòiti, ba na rà o côo bwàti wà tàpé na rà tò naa wâ. ");
INSERT INTO priNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Guwà têre, ê âraporomeejè, âna ê pwéelaa kâra naiijè. Â wiàna nye wâdé ê âraporomeejè, â diri ê naiijè, âna é tâa na pwéelaa. Â wiàna èpà ê âraporomeejè, â diri ê naiijè, âna é tâa na bàutê. ");
INSERT INTO priNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Guwà ipwacôoco, ba péa ê pwéelaa naa wâgoowà, âna é péa pâra nau bàutê. ");
INSERT INTO priNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Wiàna é tâa googà ê pwéelaa, â o ticè jè ére gée googà cèna o tâa na bàutê. Ba é pwacèwii ê ânye na é èùrugà goro ê pwéelaa kêe.» ");
INSERT INTO priNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","É tubanabwé ê pupûra bèepwiri wà Iésu. Â é me wà pwi jè *Farasaio, â é todà Iésu, ba na rà pi-ija na pwârawâ kêe ma wà tèpa Farasaio bée. Â rà tèepaa naa pwârawâ, â rà tâaboo naa goro taapà. ");
INSERT INTO priNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Â wà Iésu, âna câé caa nuwa ê du îê béaa kâra ê pai ija wàra naa na nyamanya kà tèpa *Juif. Â é pò wà pwi Farasaio â càcaa wâdé têe. ");
INSERT INTO priNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Â é ina têe wà Pwi Ukai Iésu pâ: «Wâguwà tèpa Farasaio, âna guwà nuwa bwàti gòroigé kâra wârado ma ngapò. Êco na ê pwâranümawà, âna nye po wâbé kaa goro ê pwina èpà, â guwà tèpa iau ma pwa kûu! ");
INSERT INTO priNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Guwà tèpa imwüru! Ba gona câguwà caa tâmogòori pâ, wà Pwiduée na é pwa ê gòrocàùru ngapò, âna nye wàé kaa mwara, na é pwa ê nanaara ngapò? ");
INSERT INTO priNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Wâdé na guwà naa tà tàpé na ticè kàra ê pwina tâa na pâ ngapò ma wârado kàwà. Ba na wàrapwiri, â o po pwéelaa bwàti ê du îwà bau ê pwâranümawà!» ");
INSERT INTO priNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","«Guwà naa tà Pwiduée ji caapwi gée goro 10, gée goro pâ jèpa arapwüru. Â nye wâdé. Guwà ipwacôoco, làpé! Ba câguwà caa pâra wiâra ê pwina piâjimuru naa na ê *Naèà—ê pai tòimiri tèpa âboro, ma pai meaarirà wiâra ê câbawâdé kà Pwiduée. Wâdé na guwà pacoo diri pâ pwiibà, na maina, bau diri ê nyi nari naèà na kîri. ");
INSERT INTO priNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","«O dau maina wârimuru kàwà, wâguwà tèpa Farasaio! Ba guwà nye mudàra ê pâ autâa na tâa béaa, na pâ *wâra pitapitiri. Â dau wâdé tàwà, na rà nye pwabwàcu tàwà, ma pwamainawà, na ara diri tèpa âboro. ");
INSERT INTO priNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","«Guwà pwacèwii ê pâ bwàmu na càcaa tòimiri. Ba, na jè pâra naa gò, â câjè caa tâmogòori pâ jè gére pâra gò cè bwàmu.» ");
INSERT INTO priNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Wà pwi jè *dotée goro ê Naèà, âna é têre ê popai kà Iésu bèepwiri, goo wà tèpa Farasaio. Â é ina têe pâ: «Pwi Ukai, na gà ina pwiri, â gà pi-inabà ba èpà mwara, wàibà tèpa dotée goro ê Naèà!» ");
INSERT INTO priNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Â é tòpi têe pâ: «Ipaiwà naa goowà mwara! Guwà ipwacôowà, co tèpa dotée goro ê Naèà! Ba o dau maina mwara ê wârimuru kàwà. Ba pâ pitûâ kàwà, âna pwacèwii pâ nakake na dau tòina, na guwà nama rà kakeri wà tèpa âboro. Â tàutàwà na guwà tu naa goo, goro ji caapwi mangadaîwà! ");
INSERT INTO priNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","48","«Üu! O dau maina wârimuru kàwà. Ba wà tèpa jojoorowà, âna rà pòtàmwara tèpa péroféta kà Pwiduée. Â nabàni, âna guwà bari ê bwàmu kà tàpé na rà pòtàmwararà! Â, na wàrapwiri, â guwà paari pâ, guwà wâgoo ê pwina rà pwa wà tèpa nyimuwà ma upàwà! ");
INSERT INTO priNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Ba wàéni ê pwina é ina goowà wà Pwiduée, wà Pwina é tâmogòori diri: “Go o mwa panuâ pâ tàwà tèpa péroféta kôo, ma tèpa *apostolo kôo. Â guwà o tubaèpà tàra, tiagoo na guwà o tétàmwara pàra tàpé.” ");
INSERT INTO priNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","«Â ée mwa pitèiwà wà Pwiduée, goro ê pai pòtàmwara diri tèpa péroféta kêe, gée na autapoo goro gòropuu— ");
INSERT INTO priNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","tapoo naa goo Abéla, tiagoo Zakaria, pwina naî Barakie. Ba wàé na ia rà pòtàmwereê, naa nabibiu kâra i aupwa *ârapwaailò, ma i ére na dau pwicîri! Â go ina tàwà pâ: O wâguwà, tèpa âboro nabà, na o pitèiwà goo! ");
INSERT INTO priNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","«Wâguwà tèpa dotée goro ê Naèà, âna napârawà ma guwà tàpiri tà tèpa âboro ê autâmogòorimuru naa na *Tii Pwicîri. Êco na guwà naapwàniri jiirà! Tàutàwà na guwà tò naa na *Mwaciri kà Pwiduée. Â guwà pacoo pàra tàpé, na nümarà na rà tò naa na. Êkaa na go ina tàwà pâ: O dau maina wârimuru kàwà!» ");
INSERT INTO priNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","É tubanabwé ê pwina é ina wà Iésu, â é còobé gée na wâ kà i pwi Farasaio. Â rà nye dau putàmu kaa, wà tèpa Farasaio ma wà tèpa dotée goro ê Naèà. Â tapoo gée goo ê pwi pàara-bà, âna rà ciburà tacaié, ba na rà têre cè pwina é ina. ");
INSERT INTO priNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Ba rà bu naigé ma rà pitòtié gée goro cè pai mwa tòpi kêe. ");
INSERT INTO priNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Na pàara na é gére patùra tèpa *Farasaio wà Iésu, âna jèe pâra na dau piwâru too ê pâ âboro, na rà me nau têreê. Â rà tapoo pi-igabiarà. Â béaa kâra ê pai patùrarà kêe, âna é pacâmuri tèpa *câmu kêe. É ina tàra pâ: «Guwà ipwacôoco ê ‘nyaa kâra poloa’ kà tèpa Farasaio—ba rà paari ê pwina wâdé, â rà pwàniri ê èpà kàra. ");
INSERT INTO priNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Ba diri ê pwina jèe naapwàniri nabà, âna o mwa paari naa na pwéelaa widàuru. Â o pâri ma jè côo bwàti! ");
INSERT INTO priNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Â ê muru na guwà ina pwàniri naa na bàutê, âna o inapàpari naa na pwéelaa. Â ê muru na guwà pitànunuuri, naa na naditàrawâ, âna o mwa tomara too, naa na gomu kâra âboro.» ");
INSERT INTO priNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","«Â guwà cibwaa nama wâgotàwà goro pâ âboro, co tèpa béeò. Ba wiàna rà pòtàmwara naiiwà, â o nye ticè jè muru, cèna o piwéna mwara jii pwiri. ");
INSERT INTO priNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Êco na guwà ipwacôowà. Wâdé na guwà nama wâgotàwà goo Pwiduée! Ba wàé na pâri ma é pòtàmwara ê naiiwà, ma tüwà naa na ére, na o maagé ma tòina naawê ê nyuâawà. ");
INSERT INTO priNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","«Guwà jèe côo cai pâ marü na kîri: Jè icuri 5 marü naa goro ârailu mwani. Êco na nye ticè gée goorà cèna é imwüru jiié wà Pwiduée. ");
INSERT INTO priNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Â wâguwà, âna é nye cau tâmogòoriwà bamwara, tiagoro mwara jéûru wàrapûruwà. Êkaa na go ina tàwà pâ: Guwà cibwaa nama wâgotàwà! Ba dau pwamuru naa goowà na ara Pwiduée, jii ê pâ marü na dau wâru!» ");
INSERT INTO priNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","«Go ina tàwà pâ: Wà pwi âboro na é ina pâ, é pwi âboro kôo, na ara pâ âboro, â wâgo mwara, âna go o ina pâ, é pwi âboro kôo, na ara tèpa angela kà Pwiduée. ");
INSERT INTO priNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Â wà pwi âboro na é pitütôowâriô, na ara pâ âboro, â wâgo mwara, âna go o pitütôowâriê, na ara tèpa angela kà Pwiduée. ");
INSERT INTO priNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Â o pwanauri diri tàpé na rà tùra ba èpà naa goo *Pwina naîri âboro. Êco na wà pwi âboro na é tùra ba èpà naa goro ê Nyuâaê Pwicîri, âna o càcaa pâri ma pwanaurié. ");
INSERT INTO priNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","«Guwà têre, rà o mwa tâjùruwà, ba na rà pitèiwà naa na *wâra pitapitiri, ma na ara tèpa ukai, ma tèpa kupénoo. Â, na diri pâ pàara bèepwiri, â guwà cibwaa pidumapiê goro cè pai tòpi kàwà tàra. ");
INSERT INTO priNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Ba ê Nyuâaê Pwicîri, âna ée mwa paari tàwà, cè pwina guwà mwa ina na guwà coo ararà.» ");
INSERT INTO priNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","É ina tà Iésu wà pwi jè ârapàara tàpé na rà tà bèepié, pâ: «Pwi a pwa pupûra, é jèe bà wà pwi caa kôo jii ê neemuruê. Â câé caa ipâdi naa goobu wà pwi ciòo. Gà ina têe pâ é naa tôo pwina kôo!» ");
INSERT INTO priNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Â é tòpi têe wà Iésu pâ: «Pwiini, wàilàapà na nama go pwi a pitèi ma ipâdi ê neemuru-u?» ");
INSERT INTO priNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Â é ina târa pâ âboro pâ: «Guwà ipwacôowà, ma guwà cibwaa ciburà mudàra ma wâru tàwà ê pâ muru! Ba ê *âji wâro kà pwi âboro, âna càcaa gée goro ê pâ muru na tâa têe.» ");
INSERT INTO priNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","É piwiâ tàra ê ucina bèeni: «É mwa tâa wà pwi jè âboro na dau pwa neemuruê. Dau wâru têe ê arapwüru na é piûnyari gée na napuu kêe. ");
INSERT INTO priNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Â é mwa pitawèeri pâ: “O dà cèna go o pwa? Ba o càcaa pâri i napié kôo, ma go tòpò i ârawakè kôo.” ");
INSERT INTO priNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","«Â é pi-ina têe pâ: “Wâdé na go tédàpa i na autòpò arapwüru na wâdòiti, â go o tapoo côwâ cè jèpwi cèna maina. Â go o tòpò naawê diri ê pâ ârawakè kôo, ma êdiri pâ neemuruô. ");
INSERT INTO priNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Â gée na càùé, â o mwa tâa tôo pâ utimuru ma neemuruô na wâru, târa pâ naja na wâru. Â go o mwa tàpo nao, ma ija, ma wâdo, ma ipwàdée.” ");
INSERT INTO priNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","«Êco na é ina têe wà Pwiduée pâ: “Gà piwârau! Naa ne nabà, âna go o pacôwâri jiigà ê wâro'gà. Â diri ê pâ neemurugà na gà iauri, âna o mwa kâî?”» ");
INSERT INTO priNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Â é ina tà tèpa âboro wà Iésu pâ: «Guwà ipwacôoco! Ba wàépwiri ê pwina o tèepaa mari diri tàpé na rà iauri pâ wâdé kàra naani gòropuu. Ba nye ticè âji wâdé kàra naa jaa Pwiduée!» ");
INSERT INTO priNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","É tabiié wà Iésu naa goo tèpa câmu kêe, â é ina tàra pâ: «Wàépwiri ê majoroé ma go ina tàwà pâ: Guwà cibwaa géaa goro ê wâro kàwà, ma ê naiiwà. Guwà cibwaa pitawèeri pâ: “Jè o mwa ija dà?” ma “Jè o mwa coona dà?” ");
INSERT INTO priNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Ba ê wâro kàwà, âna é âjimuru jii ê utimuru; â ê naiiwà, âna é âjimuru jii ârabwée! ");
INSERT INTO priNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Guwà jèe côo cai ê pâ marü. Ba càra caa picâmi ma piûnya, ma càra caa tòpò cè bwà târa pâ tòotù. Êco na wà Pwiduée, âna é nye pa-ijarà. Â gona câguwà caa dau piwéna jii ê pâ marü? Akaé! ");
INSERT INTO priNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Càcaa gée goro pai géaa goro ija ma wâdo, ma picoona ârabwée, na guwà tàpo nama gòri ê wâro kàwà! ");
INSERT INTO priNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Ê pidumapiê kàwà, âna o pwacoé ma é tòotéri ê ji caapwi muru. Êkaa na guwà cibwaa pidumapiê! ");
INSERT INTO priNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","«Guwà jèe côo cai pâ murubuké na-araé. Ba rà cipu, â càra caa pàti, ma càra caa ta ârabwée. Â go ina tàwà pâ: Wà pwi ukai *Solomona, naa na diri ê muugère kêe, âna ê pâ ârabwée kêe, âna càcaa dau wâdé jii ê pwi caapwi murubuké. ");
INSERT INTO priNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Â guwà jèe côo cai ê aramwatò: É cipu nabà, â o cîri widàuru naa gòro ânye. Â wà Pwiduée, âna é naa ârabwée kàra. Â gona o câé caa naa ârabwée kàwà na piwéna jii? Nye dau kîri kaa ê cèikî kàwà! ");
INSERT INTO priNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","«Üu kaa, go ina tàwà pâ: Guwà cibwaa dumapiê ma géaa, goro cè pwina guwà o ija ma wâdo! ");
INSERT INTO priNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Ba wà tàpé na càra caa tâmogòori Pwiduée, âna càra caa nao goro mudàra ê pâ pwiibà. Êco na wâguwà, âna wà Pwiduée Caa kàwà, âna é nye tâmogòori ê pwina nümawà goo. ");
INSERT INTO priNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Guwà mudàra béaa ê Mwaciri kêe Â ée mwa âjagò tàwà mwara goro diri pâ pàra muru bèepwiri.» ");
INSERT INTO priNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","«Guwà cibwaa nama wâgotàwà, co tèpa âji béeò, wâguwà na guwà pubu âboro kôo. Ba é jèe pacoo wà Caa kàwà pâ, na ée naa tàwà ê Mwaciri kêe! ");
INSERT INTO priNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Guwà icuri pâ wâdé kàwà, â guwà naa tà tàpé na ticè kàra. Â, na wàrapwiri, â guwà o wéaari ê pâ âji wâdé na rà wâ *napwéretòotù, na o tà tâa awé. Ba ticè a mura wê, na ée popa. Â ticè madé na uti, ma ticè waaca na iri. Â o càcaa wai ma botére. ");
INSERT INTO priNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Ba ê pwâranümagà, âna é wâna é wêe ê wâdé'gà.» ");
INSERT INTO priNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","36","É ina mwara tà tèpa câmu kêe wà Iésu pâ: «Guwà tà tàcî, pwacèwii tèpa ênawéna, na rà tapacîri ê pai wâjué côwâ kà pwi ukai kàra. Ba rà o ipwabwàtirà, â rà coona bwàti pâ ârabwée na wâdé, â rà popa ê wâra ânye kàra. Â wiàna ée wâjué côwâ gée goro pwa-ija goro piéa, â ée mwa cùu goropwârawâ. Â rà o pò ma tàpiri têe. ");
INSERT INTO priNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Â o dau wâdé ba kà tàpé na é pâmarirà, wiàna rà tà tàcî ma tapacîê. «Go ina tàwà ê âjupâra pâ: Wà i pwi ukai, âna ée mwa coona ê ârabwée kâra ênawéna. Â ée mwa patâaboorirà naa goro taapà, â ée mwa naa èrà. ");
INSERT INTO priNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Üu, na pàara na rà tapacîê, âna càra caa tâmogòori wiidà na ée mwa tèepaa me—wiàna naa nabibiu kâra ne, é, wiàna too i tòotù. Êco na o cidòri nyuâarà, wiàna é tèepaa me, âna é pâmarirà na rà tà tàcî ma ipwabwàtirà! ");
INSERT INTO priNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","«Guwà jèe niimiri cai ê pwini: Wà pwi apooro pwârawâ, âna câé caa tâmogòori cè ineretòotù na ée mwa tò naa na wâ kêe, wà pwi a mura na é me naa ne. Ba wiàna é tâmogòori, â pwiri é pacooé. ");
INSERT INTO priNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Wàé kaa pwiri na go ina tàwà pâ: Guwà tà tàcî. Ba go o mwa tèepaa me côwâ, wâgo Pwina naîri âboro. Êco na o câguwà caa tâmogòori cè pàara cèna go o mwa tèepaa na.» ");
INSERT INTO priNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","É tawèeri Iésu wà Pétéru pâ: «Pwi Ukai, gona ê ucina bèepwiri na gà ina, âna ba kâbà co wàibà tèpa câmu'gà é, kâra diri pâ âboro?» ");
INSERT INTO priNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Â é tòpi têe wà Pwi Ukai pâ: «Kâra diri tèpa ênawéna na rà pitêre dàra ma pitòimirirà. Â wàilàapà pwi ênawéna bèepwiri? Wàéni: I pwi ia é ina têe wà pwi ukai kêe pâ: “Go panuâ tâgà ê wakè bèeni: Gà pa-ija pàra tèpa ênawéna, naa na pàara na o pâri.” ");
INSERT INTO priNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","«Â o dau wâdé ba kà pwi ênawéna bèepwiri, wiàna é tèepaa me wà pwi ukai, âna é nye tàgére wakè bwàti! ");
INSERT INTO priNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Guwà côo, wà pwi ukai, âna ée naa têe ê pitûâ naa goo ê pâ wâdé kêe. ");
INSERT INTO priNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Êco na, wiàna wà i pwi ênawéna, âna é pwi âboro èpà, â é piniimiri pâ, ‘O câé caa nama tèepaa me wài wà pwi ukai.’ Â é tapoo èi tèpa bée goro wakè. Â é dau ija ma wâdo ma ipwirié. ");
INSERT INTO priNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Â, na jè tòotù na é tàpilée, â é nye wâjué me côwâ kaa wà pwi ukai. Â ée mwa naa ê wârimuru na dau gòo tà i pwi ênawéna bèepwiri, wàilà diri ma pàra tèpa ênawéna, na càra caa pitêre dàra. ");
INSERT INTO priNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","«Üu, o dau maina ê wârimuru kêe, gée goo na é tâmogòori ê câbawâdé kà pwi ukai kêe, â câé caa pacoo, â ticè na é pwabwàti ba kêe. ");
INSERT INTO priNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Êco na o càcaa dau maina ê wârimuru kà tàpé na càra caa tâmogòori pâ èpà ê pwina rà pwa. Ba wà pwina naa têe ba wâru, âna o ilari jiié na wâru. Â wà pwina jèu âjagò têe côwâ, âna o jèu ilari jiié mwara.» ");
INSERT INTO priNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","«Guwà têre, go tèepaa me, ba na go pame ê ânye naa gòropuu. Â po dau nümoo na jèe tubanabwé ê wakè bèepwiri! ");
INSERT INTO priNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Ba o upwaao goro pwi *piupwaa goro maagé côo na dau maina. Â go bwaa nye tàgére tapacîri naa na picâri. ");
INSERT INTO priNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Guwà cibwaa niimiri pâ go tèepaa me naani gòropuu, ba na go pame pinaanapô. Èkâ! Ba rà mwa pitadàrùrà ê pâ âboro gooò. ");
INSERT INTO priNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Tapoo nabà, âna rà o pitadàrù pâ pwârawâ. Ba pwiri o ârailu âboro gée goorà na ru wâgooò, â âracié na rà o cicarao, é, pwiri o âracié na rà wâgooò, â o ârailu na ru cicarao. ");
INSERT INTO priNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Â o pitadàrù wà tupédu aénaî, ma du duanaî, ma du duatâa.» ");
INSERT INTO priNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","É ina mwara wà Iésu târa pâ âboro na wâru, pâ: «Wiàna guwà côo pâ nee na dau duu, na rà me gée nawià, â guwà nye nama ina pâ, “O popaa” â nye popaa kaa. ");
INSERT INTO priNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Â wiàna é cima ê dàré, â guwà ina pâ, “O wâdé napô” â nye wàra. ");
INSERT INTO priNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","57","Üu, guwà po dau tâmogòori ina naa wâdé napô, é, naa èpà napô. Â gorodà na câguwà caa côoinari ê âjupâra, naa na pâ muru na gére tèepaa nabà? Guwà tèpa gòmapwa! Ba wiàna guwà gére côoinari, â pwiri guwà tâmogòori ê pwina tàrù ma guwà pwa. Êco na tàutàwà. ");
INSERT INTO priNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","«Wàéni ê pwina tàrù: Wiàna é piciapwâ googà wà pwi jèpwi, â gàu mara pinaanapô ma wàé, wiàna gàu bwaa gére wâ naigé pâ naa na aupitèimuru. Ba é péa panuâgà tà pwi a pitèimuru, na ée mwa panuâgà târa pwàliici ma tòpògà naa na karapuu. ");
INSERT INTO priNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Â go ina tâgà ê âjupâra pâ: O câgà caa còobé gée na karapuu, wiàna ina pâ, bwaa câgà caa pé wâri diri ê wârimuru'gà!» ");
INSERT INTO priNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Na pàara bèepwiri, âna rà medari Iésu wà pàra tèpa âboro, â rà ina têe pâ: «Wà ukai *Pilato, âna é nama tétàmwara pàra tèpa âboro gée Galilée, na pàara na rà pwa *ârapwaailò tà Pwiduée, naa na *Wâra pwapwicîri wâ *Iérusaléma.» ");
INSERT INTO priNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Â é tòpi tàra wà Iésu pâ: «Gona guwà niimiri pâ, rà bà, ba rà dau tèpa pwa na èpà, jii pàra tàpé? ");
INSERT INTO priNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Bwa! Â go ina tàwà pâ: Guwà ipwacôowà, â guwà biiwà ma pitòotéri ê wâro kàwà. Ba câguwà caa tâmogòori cè pwi pàara na guwà o bà na! ");
INSERT INTO priNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Â guwà jèe niimiri cai wà tèpa 18 âboro, na ia tûu naa gòrà i auba na Siloé, â caagairà. Gona rà dau tèpa âboro èpà jii pàra tèpa âboro Iérusaléma? ");
INSERT INTO priNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Bwa! Â go ina tàwà mwara pâ: Wâdé na guwà pinünüma ma guwà biiwà. Ba guwà péa tà cau bà wài, pwacèwiirà!» ");
INSERT INTO priNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","É ina tàra ê ucina bèeni wà Iésu: «É mwa tâa wà pwi jè âboro. Â é mwa pwa wâru pâra naa na aupwanapô kêe, ba na é côo ê *upwâra wâi kêe, ma pwa ma mudàra cè pwêe. Êco na mu nye ticè. ");
INSERT INTO priNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","«Â é pwa ma ina tà pwi a wakè kêe pâ: “Gà côo! Po âracié naja na go me nau mudàra cè pwêe, â nye ticè. Tépàgàé tâjii! Ba càcaa wâdé na é cèpo tà pi cipu naa goro piticèmuru naa goo, naa ticè pwêe!” ");
INSERT INTO priNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","«Â é tòpi têe i pwi a wakè kêe pâ: “Pwi ukai, tàpo naaê, ba na go bwaa pwabwàti goo. Go o mwa îri tabéaa gooé, ma naa wai kâra upwâra ma pwa puu naa goo. Â ju mwa côo na naja noowê. ");
INSERT INTO priNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Â wiàna pwa pwêe, â nye wâdé. Â wiàna ticè, â gà o mwa bàra tépàgàé.”» ");
INSERT INTO priNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Na jè *tòotù pwicîri, âna é tâa na *wâra pitapitiri wà Iésu. Â é gére pacâmuri tèpa âboro. ");
INSERT INTO priNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Â é tâa wê mwara tô jè ilàri, na é maagé naa na 18 naja. Ba tâa gooé ê duée, â too ê càùé, â càcaa pâri ma é citàrù. ");
INSERT INTO priNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Â é todèe wà Iésu, â é ina têe pâ: «Tôoni, é jèe tiàu ni i maagé'gà!» ");
INSERT INTO priNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Â é tòpò îê naa gòé. Â é nye citàrù kaa, â é dau ipwamaina Pwiduée! ");
INSERT INTO priNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Êco na é po dau putàmu wà pwi a pitûâ kâra na wâra pitapitiri, gée goo na tòotù pwicîri. Â é pwa tèpa âboro, ma ina tàra pâ: «Kaa! Tàpéeni, 6 tòotù na jè wakè na. Wiàna nümawà na tiàu maagé kàwà, â guwà me naa nadàpàra pwapwicîri! Â guwà naaco ê tòotù pwicîri!» ");
INSERT INTO priNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Â é tòpi têe wà Pwi Ukai pâ: «Wàéco! Gà ina, â gà têre côwâ! Gona câguwà caa tipi ê macii kàwà ma pawâdoorà, na tòotù pwicîri? Â? ");
INSERT INTO priNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Â wà tô ilàri bèeni, âna é tô gòobàra *Abéraama, pwi jojoorojè. Â é piié wà *Caatana naa na 18 naja. Â wànau, o nye ticè tàrù kôo ma go tipi ê maagé kêe na tòotù pwicîri?» ");
INSERT INTO priNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Â rà kamu diri tàpé na rà cicara Iésu. Êco na ê auwâru gée goo tèpa âboro, âna rà dau ipwàdée goro pâ muru na muugère na é pwa. ");
INSERT INTO priNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","É ina mwara wà Iésu pâ: «Napwa ê *Mwaciri kà Pwiduée, âna é pwacèwii dà? Wàéni ê pwi ucina, târa ma guwà tâmogòori: ");
INSERT INTO priNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","«Ê Mwaciri kà Pwiduée, âna é pwacèwii ê jè pudòro moutarde na dau kîri. Wà pwi jè âboro, âna é câmi, â é cipu. Â é jèe pâ nau dau maina. Â pâri ma rà pwa wânaîrà, naa gò pâ ditèe, ê pâ marü.» ");
INSERT INTO priNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","«Ê Mwaciri, âna o pwacèwii mwara ni: ");
INSERT INTO priNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Wà tô jè ilàri, âna é popa ê nyaa kâra poloa, â é biinaimari bau 25 kilo goro dàuru poloa. Â é tü tiagoro na é tùu too i poloa!» ");
INSERT INTO priNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","É gére pâra dàra Iérusaléma wà Iésu. Â é pwa ma pacâmuri tèpa âboro naa na pâ village ma napô, wii naigé. ");
INSERT INTO priNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Â é tawèerié wà pwi jè âboro pâ: «Pwi Ukai, gona o dau pwâco wà tàpé na rà o udò ba na tâa tàra ê *âji wâro?» Â é ina tà tèpa âboro wà Iésu pâ: ");
INSERT INTO priNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","«Guwà côo, nye dau picu kaa ê goropwârawâ, pâ naa na ê âji wâro. Â guwà ipwadàrapwa cai ma guwà tò naa na. Ba wâru tàpé na nümarà na rà tò, êco na o pwacoé tàra. ");
INSERT INTO priNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Ba, na ée târi ma kiiri ê goropwârawâ, wà pwi apooro pwârawâ, â o càcaa pâri ma guwà tò. Guwà o tà coo boo gòroigé, ma cùu taaci i goropwârawâ, ma ina têe pâ: “Pwi ukai, gà tàpiri tâbà!” «Â ée mwa tòpi tàwà pâ: “Bwa. Guwà pâra, ba câgo caa tâmogòoriwà.” ");
INSERT INTO priNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","«Â guwà o mwa ina têe pâ: “Bwa. Nye wàibà kaa, na ia jè mu pi-ija ma wâdo ma wâgà. Â wàibà na ia gà mu pacâmuri pâ ni jaabà!” ");
INSERT INTO priNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","«Â ée mwa po ina tàwà gée pâ: “Bwa! Câgo caa tâmogòoriwà! Guwà tèpa còobé géepà? Guwà pâra jiio, ba guwà tèpa pwa ê pâ tûâ na èpà! Ba câguwà mu caa pwa ê câbawâdé kôo.” ");
INSERT INTO priNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","«Â o mwa tüwà naa gòroigé. Â guwà o mwa i ma tòngüru poropwâwà, goro pai tòina kàwà. Ba guwà mwa côo tèpa jojoorowà—wà *Abéraama, ma Isaaka, ma Iakobo—ma wà diri tèpa *péroféta, na rà cau tâa diri na ê Mwaciri kà Pwiduée. ");
INSERT INTO priNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Â o mwa wâru diri cè tàpé cèna rà o mwa me, gée na diri ê gòropuu. Â o pwa autâa kàra, na ê pi-ija maina, naanidò na Mwaciri kà Pwiduée. ");
INSERT INTO priNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Â guwà côo, wâru tàpé na rà pwicò nabà, na rà o mwa caa pâbéaa na pwi pàara-bà. Â wâru tàpé na rà pâbéaa nabà, na rà o mwa caa pwicò.» ");
INSERT INTO priNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Ûna é gére ina pwiri wà Iésu, â rà nye tèepaa me kaa wà pàra tèpa *Farasaio, â rà ina têe pâ: «Pwiini, bà têre pâ, ée pwa na é tétàmwaragà wà ukai *Héroda Antipas! Â wâdé na gà uru géeni!» ");
INSERT INTO priNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Â é tòpi tàra pâ: «Guwà ina tà pwi macii a piugà bèepwiri pâ, nabà ma widàuru, âna go o bwaa mara pwa ê wakè kôo ni—ba go o bwaa tü târa pâ duée, â go o bwaa nama tiàu maagé kà tèpa âboro. Â naa na béâracié kâra tòotù gée na càùé, âna go mwa tubanabwé diri. ");
INSERT INTO priNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Êco na go o mwa coo gòobàra ê naigé kôo pâ naa Iérusaléma. Ba o càcaa wâdé wiàna o tétàmwara pwi jè péroféta kà Pwiduée wâgòroigé jii Iérusaléma ê ville pwicîri kêe! ");
INSERT INTO priNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","«Au! Nyi wâriwà co tàpé Iérusaléma! Guwà catàmwara tèpa péroféta na é cùrurà medariwà wà Pwiduée, ba guwà èi pàra tàpé goro atü, â guwà pòtàmwara pàra tàpé goro cè jè pai pwa wèe. Nye ciburà nümoo na go panaimariwà, pwacèwii jè nyaa kâra ja, na é panaimari nyi naîê, na aranara itooé. Êco na tàutàwà. ");
INSERT INTO priNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Â guwà côo, go o mwa pâra jiiwà, â o jèe ticia na ê Wâra pwapwicîri kàwà! Â go ina tàwà pâ: O jèe câguwà caa côoô, tiagoro ê tòotù na guwà o ina pâ: Cidòri nyuâa pwi âboro na é me naa na nee Pwi Ukai!» ");
INSERT INTO priNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","2","Na jè *tòotù pwicîri, âna rà pi-ija wà Iésu, na pwârawâ kà pwi jè *Farasaio. Â é tâa wê mwara wà pwi jè âboro, na é maagé, ba tèe naparawée. Â wà diri tèpa âboro, âna rà tà wéaa goo Iésu, ba na rà côo pâ pwiri é nama tiàu maagé kêe. ");
INSERT INTO priNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Â é tawèeri tèpa *dotée goro ê Naèà ma wà tèpa Farasaio pâ: «Gona muru pwicîri, é, nye pwa tàrù ma jè nama tiàu maagé kà pwi jè âboro, na tòotù pwicîri?» ");
INSERT INTO priNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Â càra caa tòpi têe. Â é tabiié pâ dàra i pwi a maagé, â é nama tiàu i maagé kêe, â é ina têe pâ, na é wâjué côwâ naa jaaé. ");
INSERT INTO priNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Â é tawèeri diri pàra âboro pâ: «Wiàna é tûu naa na pwârajawé wà pwi naîgà, é wiàna macii'gà, na tòotù pwicîri, â gà o pwa dà? Gona o câgà caa pò ma dàtié dò wài gée na pwêe?» ");
INSERT INTO priNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Â càcaa pâri ma rà tòpi têe. ");
INSERT INTO priNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Wà pàra tàpé na todàra naa na pi-ija, âna rà pwa na rà pitòri ê autâa na tâa béaa. Ûna é côo pwiri wà Iésu, â é ina tàra pâ: ");
INSERT INTO priNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","«Guwà ipwacôoco! Ba wiàna todàgà naa goro cè jè pi-ija goro piéa, â gà cibwaa pâra nau tâa gòro autâa kà tèpa âboro imaina. Ba é péa tà todà cè pwi âboro cèna é piwéna jiigà ");
INSERT INTO priNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","wà i pwi apooro pi-ija! Â é péa tà ina tâgà pâ: “Gà cimadò, â gà pâra gée na autâa bèepwiri.” Â o maina kamu'gà na gà pâra na mudàra cè autâa'gà. ");
INSERT INTO priNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","«Bwa! Wâdé na gà tâa boobà càùru tâa. Â ée mwa ina tâgà wà pwina é todàgà, pâ: “Pwi béeò, gà me, â gà tâa gò autâa kà tèpa âboro imaina.” Â rà o côo naawê ê pai ipwamainagà kà pwi apooro pi-ija, na ara diri tèpa âboro! ");
INSERT INTO priNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Ba wà pwina é ipwamainaê, âna o naaê boo. Â wà pwina é ipakîriê, âna o naaê too.» ");
INSERT INTO priNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Géewê, â é ina wà Iésu tà pwina é todèe pâ: «Wiàna gà ipwabwàti cè jè pi-ija na wàrani â gà cibwaa todà co tàpé na rà o pitôowâri tâgà—wiàna wà tèpa béegà, ma tèpa jèneregà, ma wà tàpé na dau pwa neemururà. ");
INSERT INTO priNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","«Bwa! Wâdé na gà todà tàpé na ticè neemururà, ma wà tèpa maagé, ma wà tèpa bee, ma wà tèpa bwi. ");
INSERT INTO priNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Â o cidòri nyuâagà, ba wàilà diri, âna càcaa pâri ma rà pitôowâri tâgà. Â wà Pwiduée, âna ée mwa naa tâgà ê pumara wakè'gà, naa na ê tòotù na ée mwa pawâro côwâ gée na aubà, wà tàpé na rà pwa na wâdé. Â o dau maina ê aupwényunyuâari na ée mwa naa tâgà.» ");
INSERT INTO priNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Pwa pwi jè âboro na ru tâa goro taapà ma wà Iésu, â ûna é têre ê pai pwa pupûra kêe, â é ina têe pâ: «Pwi Ukai, o po dau cidòri nyuâa tàpé na rà tâa na pwi pi-ija maina naa na *Mwaciri kà Pwiduée!» ");
INSERT INTO priNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Â é pwa ucina wà Iésu, târa ma é tòpi têe. Â é ina pâ: «É mwa tâa pwi jè âboro. Â é mwa pwabwàti ê jè pi-ija na dau maina. Â é mwa todà tàpé na dau wâru, ma rà ija. ");
INSERT INTO priNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Â nabwé, â po coo i tòotù kâra pi-ija. Â é cùru pâ pwi ênawéna kêe, ma é todà me tàpé na rà o pi-ija ma wàé. ");
INSERT INTO priNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","«Â é tèepaa naa goo pwi jè ârapàararà. Êco na é tòpi têe wà pwini pâ: “Au, gà ina tà pwi ukai pâ, na é pwanaurio, ba càcaa pâri ma go me nau pi-ija. Ba go me gée auwâri ê aupwanapô, â wâdé na go bwaa pâra nau cai.” ");
INSERT INTO priNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","«Â nabwé, â é pâmari pwi béârailu kà tàpé na todàra. Â é tòpi têe wà pwini pâ: “Au! Gà ina tà pwi ukai pâ, na é pwanaurio, ba càcaa pâriô ma go me. Ba go me gée auwâri ê 10 paaci târa û, â wâdé na go nama tacairà jècaa.” ");
INSERT INTO priNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","«Â nabwé, â é pâmari ê pwi béâracié kà tèpa âboro. Â é tòpi têe pâ: “Go pwi a bwaa tàgére piéa, â càcaa pâri ma go me. Au! Gà ina tà pwi ukai pâ é pwanaurio.” «Cau tàutàra diri na rà me, ba rà cau ina pâ, pwa wakè kàra.» ");
INSERT INTO priNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","«Â é wâjué côwâ wà pwi ênawéna, â é wiâ tà pwi ukai kêe ê pai tòpi kà tèpa âboro bèepwiri. «Â é nye dau putàmu kaa wà pwi ukai, â é ina têe pâ: “Gà pâra wài, pitiri pâ napô, â gà todà me tàpé na ticè kàra, ma wà tèpa bee, ma wà tèpa pitàbwamwa, ma wà tèpa bwi.” ");
INSERT INTO priNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","«Â é pâra i pwi ênawéna. Ûna é wâjué me côwâ, â é ina tà pwi ukai kêe pâ: “Go jèe todàra diri, pwacèwii pai ina'gà tôo, êco na bwaa nye pwa dàra autâa.” ");
INSERT INTO priNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","«Â é tòpi têe pâ: “Gà pâra naa na pâ ére na tàpo wâiti jii ni, â gà todà tèpa âboro na gà pâmarirà, ba na o wâbé i wâra pi-ija! ");
INSERT INTO priNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Â napwa naa goo wà tàpé na ia go mara todàra, âna o càra mwa caa ija cè ji noo kâra utimuru, gée gòro taapà kôo.” Nabwé naawê!» ");
INSERT INTO priNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Na pwi pàara bèepwiri, â wâru pâ âboro na rà gére pâra wiâ Iésu. Â é tabiié naa goorà, â ina tàra pâ: ");
INSERT INTO priNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","«Wà pwina nümee na é me wiâô, âna wâdé na é meaario, jii du nyaa ma caa kêe, ma wà wâdèe, ma pâ èpo kêe, ma tèpa aéjii kêe, ma wà pa naigé kêe, tiagoro ê wâro kêe, wàé côwâ. Ba, na càcaa wàrapwiri, â càcaa pâri ma é pwi a *câmu kôo. ");
INSERT INTO priNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Wà pwina câé caa kâa ê *kurucé kêe, ma é me wiâô, âna wà pwiibà, âna càcaa pâriê ma é pwi a câmu kôo.» ");
INSERT INTO priNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","«Â wâdé na é mara nünümari bwàti naa goo ê pwina ée mwa pwa. Ba wà pwi jè âboro na é niimiri na é pacima ê wâ na maina, â é mara pwa kilo naa goo cè wâri wèe, wiâra ê mwani na wâjaaé, pâ, pwiri o pâri. ");
INSERT INTO priNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","«Ba é péa tòpò ê pàara wâ, â càcaa pâri ê mwani kêe ma é tubanabwé. «Â rà picocoorié, ");
INSERT INTO priNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","ma ina pâ: “Gà côo wà pwiibà—nye wàé kaa, na é tapoo bari i wâ, â câé caa tubamwara!” ");
INSERT INTO priNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","«Â jèpwi mwara, âna guwà jèe niimiri cai pwi jè ukai, na po 10 000 coda kêe, na ée pwa paa ma pwi jè ukai, na po 20 000 coda kêe. Ba wâdé na é mara nünümari bwàti béaa kâra cè pai paa kêe! ");
INSERT INTO priNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","«Ba wiàna càcaa pâriê, â wâdé na é cùru pâ cè pwi a-ipa popai kêe, dari pwi jè ukai, na é bwaa wâiti, ba na é ilari jiié ê pinaanapô.» ");
INSERT INTO priNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Â é ina mwara wà Iésu pâ: «Êkaa na go ina pâ: Wiàna nümagà na gà pwi a câmu kôo, â wâdé na gà mara panuâ diri pâ muru ba kôo. ");
INSERT INTO priNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","«Guwà jèe niimiri cai ê còo, âna muru na wâdé, târa ma pwa nümara ê utimuru. Êco na, wiàna tubatiàu ê nümee, â jè o wànau târa ma jè o pwa ma tèepaa côwâ ê nümee? Bwa, pwacoé! ");
INSERT INTO priNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Â càcaa mwa caa wâdé târa utimuru, â càcaa wâdé târa tòpò naa na aupwanapô mwara. Â jè o tâjii naa gòroigé. Wà pwina pwa pwâranyüruê, âna wâdé na é têre!» ");
INSERT INTO priNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Wâru tèpa âboro na èpà ê wâro kàra—wà tèpa *tò mwani wâripû, ma wà pàra tàpé—na rà medari Iésu, ba na rà têre ê pai pwa pupûra kêe. ");
INSERT INTO priNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Â dau càcaa wâdé tà tèpa *Farasaio ma wà tèpa *dotée goro ê Naèà. Â rà picocoorié, ma pi-ina tàra pâ: «Kaa! Wà pwini, âna rà picaatâa ma tàpé na èpà ê wâro kàra, tiagoro na rà picaaija ma wàé!» ");
INSERT INTO priNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","É ina tàra wà Iésu ê ucina bèeni: ");
INSERT INTO priNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","«Guwà jèe têre cai ê pwini: Wà pwi jè ârapàarawà, âna pwa 100 mutô kêe. Â wiàna tiàu naa namwatò ê pwi caapwi gée goorà, â ée pwa dà? Ée naaco i 99 mutô, â é pâ nau mudàra i mutô kêe na ia tiàué. ");
INSERT INTO priNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Â wiàna é pâmariê, â ée dau ipwàdée, â ée mwa kâaê ma popaé me côwâ, mari i pubu mutô. ");
INSERT INTO priNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","«Â wiàna é tèepaa me naa pwârawâ, â ée todà tèpa bée, â é ina tàra pâ: “Tàpéebà, guwà me, ba na jè ipwàdée naima! Ba go jèe pâmari i mutô na ia tiàué!”» ");
INSERT INTO priNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Â é tubanabwé ê ucina bèepwiri wà Iésu, â é ina pâ: «Â guwà côo, o ipaiwà naanidò *napwéretòotù. Ba wà Pwiduée ma wà tèpa âboro kêe, âna rà o dau ipwàdée, goo ji pwi caapwi âboro èpà, na é pitòotéri ê wâro kêe, jii ê pâ 99 na rà niimiri pâ wâdé ê wâro kàra.» ");
INSERT INTO priNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","É pwa jè ucina wà Iésu, â é ina tàra pâ: «É mwa tâa wà tô ilàri, na pwa 10 mwani atü kêe. Â, na jè tòotù, â é tubatiàu caapwi gée goo. Â é mwa nuri wâra ânye, â é dau baléri ê wâ, â é mudàra bwàti i mwani kêe. Â é mudàra, mudàra, mudàra… tiagoro na é pâmari! ");
INSERT INTO priNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","«Â é todà tèpa bée, â é ina tàra pâ: “Guwà me, ma jè ipwàdée ma wâgo! Ba go jèe pâmari côwâ i mwani atü kôo!” ");
INSERT INTO priNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","«Â go ina tàwà pâ: O po dau maina ê ipwàdée kà tèpa *angela kà Pwiduée, goo ê pwi caapwi âboro na é èpà, na é pitòotéri ê wâro kêe.» ");
INSERT INTO priNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","É wiâ tàra mwara ê jè ucina wà Iésu: «Rà mwa tâa wà paénaî. ");
INSERT INTO priNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Â wà pwi pwêedi, âna é ina tà caa kàru pâ: “Gà naa tôo ê wâdé kôo, gée goro ê neemurugà.” «Â wà pwi caa kàru, âna é nye naa têe. ");
INSERT INTO priNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","«Nabwé, â wà pwini, âna é popa diri ê wâdé kêe, â é icuri. Â é popa i mwani goo, â é pâra naa na jè napô na wâiti. Â é mudàra ê wâro na wâdé têe, â é ipwa-imudiri i mwani kêe. ");
INSERT INTO priNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Paé pâ parui, paé, paé, paé… Â é pâra na po tubatiàu diri i mwani kêe. Â tèepaa ê copwa na dau maina naa na i napô bèepwiri. Â é dau copwa. ");
INSERT INTO priNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Â é mudàra cè wakè kêe, ba na é ija. Â é pâ nau wéaari pâ puàkà kà pwi jè âboro naa napô bèepwiri. ");
INSERT INTO priNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Êco na é jèe dau copwa tiagoro na dau nümee na é ija gée goro i uti kâra i pâ puàkà. Ba nye ticè âboro wê, cèna é naa cè uti kêe. ");
INSERT INTO priNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","«Â tèepaa naa na jè pàara, â é pinünüma, ma niimiri pâ, ‘Wâjaa caa, âna dau pwa utimuru, ba kà diri tèpa âboro, tiagoo tèpa ênawéna kêe na rà dau kîri. Â pwa ma nye wâru mwara jiirà! Â wâgo, naani, âna go bàtiri copwa! ");
INSERT INTO priNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Jèe pâri! Go wâjué côwâ dari caa, â go ina têe pâ: Caa, gà pwanaurio, ba go pitanami, na ara Pwiduée ma na aragà. ");
INSERT INTO priNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Jèe càcaa pâri ma go pwi naîgà. Â gà pwa ma go pwacèwii pwi jè ênawéna'gà.’ ");
INSERT INTO priNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Â é cimadò, â é pâra.» «Ûna é gére me wii naigé, â é côoinaê wà caa kêe, â é dau meaarié. Â é itàa caraé, â é ta-imwüê ma bwénüuê. ");
INSERT INTO priNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Â é ina tà caa kêe pâ: “Caa, gà pwanaurio, ba go pitanami, na ara Pwiduée ma na aragà. Jèe càcaa pâri ma gà ina gooò pâ go pwina naîgà…” ");
INSERT INTO priNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","«Êco na câé caa pâji tùra diri â é jèe ina caa kêe tà tèpa ênawéna kêe pâ: “Guwà wàcî! Guwà pame jè ârabwée na dau wâdé, ma é coona wà pwina naîô. Â guwà naagée naa goro îê jè pwiâ, â ê du wâraâ naa goro âê. ");
INSERT INTO priNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Â guwà taa i nari paaci na ia jè gére pa-ijaé bwàti târa jè tòotù. Ba nabà, âna jè o pi-ija naima ma ipwàdée! ");
INSERT INTO priNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Ba guwà côo, wà pwi naîô bèeni, âna pwacèwii na é jèe pwi a bà, â é jèe wâro côwâ. Â jèe pwi a tiàué, â jè pâmariê côwâ!” «Â rà tapoo ê pi-ija kàra.» ");
INSERT INTO priNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","«Na rà gére wàrapwiri, â wà pwi cièe, âna é tà wakè na aupwanapô. Ûna é wâjué me côwâ naa pwârawâ, â é têre ê pwâra nyabi ma airi câbu. ");
INSERT INTO priNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Â é todà pwi jè ênawéna, â é ina têe pâ: “Wànau? Cina guwà po dau ipwàdée?” ");
INSERT INTO priNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","«Â é tòpi têe pâ: “Gà côo, é jèe wâjué côwâ i pwi jiigà. Â é nye dau ipwàdée kaa wà caa kàu na é piêgòtùru. Â é nama bà taa i paaci, ba na jè pi-ija ma ipwàdée!” ");
INSERT INTO priNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","«Êco na é putàmu wà pwi cièe, â tàutêe na é tò naa pwârawâ. Â é còobé wà caa kêe, â é tacoo gooé pâ, na é tò darirà. ");
INSERT INTO priNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","«Êco na é tòpi têe pâ: “Gà têre, co caa, jèe wâru ê pâ naja na go po dau wakè'gà. Â câgo caa pâji pwa ciritàu, ma tàutôo na go pitêre dàgà. Â câgà caa pâji naa tôo cè ji nari nani ma bà ipwa-ija ma tèpa béeò! ");
INSERT INTO priNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Â wà pwi bèepwiri, âna é jèe tubatiàu ê mwani'gà naa goro pa ilàri gòronaigé. Ûna é wâjué me côwâ, â gà nye nama taa ê paaci na dau tèe, ba kêe!”» ");
INSERT INTO priNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","«Â é tòpi têe wà caa kêe pâ: “Gà têre, co pwina naîô, nye dau wânümoo mwara googà! Go ipwàdée na gà nye tà ciburà tâa jaao, ba diri ê pwina kôo, âna kâgà. ");
INSERT INTO priNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Êco na wâdé na jè pwa pi-ija nabà, ma ipwàdée. Ba wà pwi naîô bèeni, âna pwacèwii na é jèe pwi a bà, â é jèe wâro côwâ. Â jèe pwi a tiàué, â jè pâmariê côwâ.” Nabwé naawê!» ");
INSERT INTO priNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","É pacâmuri tèpa *câmu kêe wà Iésu, â é ina tàra ê ucina bèeni: «É mwa tâa wà pwi ênawéna kà pwi jè âboro na pwa neemuruê. Ba é pwi a piwéaari ê mwani kêe ma neemuruê. «Â na jè tòotù, âna wà pàra tèpa âboro, âna rà me na piciapwâ tà pwi ukai kêe, â rà ina têe pâ: “Wà pwi ênawéna'gà, âna é po pwa-imudiri ê mwani'gà.” ");
INSERT INTO priNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","«Â é todèe wà pwi ukai, â é ina têe pâ: “Pwiini! Rà piciapwâ tôo googà! Nabàni, âna o câgà mwa caa pwi a wakè kôo. Êco na gà inapàpari tôo cai cè pwina gà pwa goro i mwani ma neemuruô. Ba o câgà mwa caa tà wéaari!” ");
INSERT INTO priNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","«Â é pi-ina têe côwâ wà i pwi ênawéna pâ: “Go po nabwé diri! Â go o pwa dà? Jèe ticè nii kôo ma go wakè napuu. Â go kamu na go ila.” ");
INSERT INTO priNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","«Â é nye niimiri kaa ê pwina ée pwa, ba na o wâru cè tèpa bée na rà o pitu têe, wiàna ticè wakè kêe. ");
INSERT INTO priNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","«Â é pitodà jècaa tàpé na pwa kéredi kàra, jaa pwi ukai kêe. Â é tawèeri pwi a pâbéaa pâ: “Âradipi kéredi'gà?” ");
INSERT INTO priNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","«Â é tòpi têe pâ: “100 pwirijawé goro l'huile.” «Â é ina têe i pwi ênawéna pâ: “Bwa. Gà pitôowâri co 50, co pwi béeò. Wàéni noo kâra tii bépaâjupâra wèe. Â jèe nabwé awé ê kéredi'gà.” ");
INSERT INTO priNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","«Â nabwé, â é todà pwi jèpwi, â é tawèerié pâ: “Â wâgà, co pwini, âna âradipi kéredi'gà?” «Â é tòpi têe pâ: “Auwa! Po 100 baikè blé.” «Â é ina têe i pwi ênawéna pâ: “Bwa. Wâdé. Wàéni noo kâra tii'gà, â gà tàpo wii co 80, â jèe nabwé awé ê kéredi'gà.” ");
INSERT INTO priNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","«Â nabwé, â ûna é têre pwiri wà pwi ukai, â é pò, â é picâdiri i pwi âboro bèeni goo ê pai ipwacôoê, wiàna nye âjupâra pâ, é pwi a pwa tûâ.» Â é tubanabwé ê ucina bèepwiri wà Iésu, â é ina pâ: «Guwà côo, wà tèpa âboro ni gòropuu, âna rà dau tâmogòori ipwacôorà, jii tèpa âboro kà Pwiduée na *tàrù ma âjupâra ê pâ tûâ kàra. ");
INSERT INTO priNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Â go ina tàwà pâ: Ê mwani, âna pwi a-ipa-imwürujè! Â wâdé na gà popa mwani'gà, ba na gà pitu tà pàra tàpé goo, naani gòropuu, ba na o pwa béegà. Ba gée na càùé, na gà jèe pâra jii ê mwani, â wà Pwiduée, âna é nye tòpigà bwàti naa na pwârawâ kêe, naa *napwéretòotù dàra gòiri awé!» ");
INSERT INTO priNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","É patùrarà mwara wà Iésu goro mwani, â é ina pâ: «Wiàna gà tâmogòori tòimiri ji muru na kîri, â gà o nye tâmogòori tòimiri ê pâ muru na maina mwara. Â wiàna câgà caa tâmogòori tòimiri ji muru na kîri, â o câgà caa tâmogòori tòimiri ê pâ muru na maina. ");
INSERT INTO priNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","12","Üu, wiàna câgà caa tâmogòori tòimiri ê pâ muru imudi naani gòropuu, â gorodà na gà niimiri pâ wà Pwiduée, âna ée mwa naa tâgà, ba na gà wakèri ê pâ wâdé na dau âjimuru wâ napwéretòotù? Â gorodà na gà niimiri pâ, ée mwa naa tâgà ê pwina é wéaari ba kâgà? ");
INSERT INTO priNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","«Nye ticè âboro cèna pâri ma é piênawéna bwàti kâra ârailu ukai. Ba ée mwa tà piênawéna bwàti kà pwi jèpwi, â ée pwa-imudiri tà pwi jèpwi. Üu, o càcaa pâri ma guwà cau piênawéna kà Pwiduée ma ê mwani!» ");
INSERT INTO priNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Wà pàra tèpa Farasaio, âna rà têre ê popai bèepwiri. Â rà ipwaêrea gooé, ba rà wâdéari mwani. ");
INSERT INTO priNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Â é ina tàra pâ: «Guwà ipwacôoco, làpé! Guwà tèpa ipaariwà na ara tèpa âboro, êco na é tâmogòori pwâranümawà wà Pwiduée. Ê pwina rà pwamaina wà tèpa âboro, âna muru na miiri na ara Pwiduée.» ");
INSERT INTO priNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","É pacâmuri tèpa âboro wà Iésu goro pàra popai. Â é ina tàra pâ: «Ê *Naèà kà Moosé, ma ê pâ popai kà tèpa *péroféta, âna rà pitûâ kâjè tiagoo na é tapoo pwa pupûra wà *Ioane Pwi a piupwaa. Êco na nabàni, âna go tàgére picémara ê *Picémara Wâdé goro ê *Mwaciri kà Pwiduée. Â dau wâru tèpa âboro na rà dau ipwadàra, ma rà tò naa na, ba na rà tèpa âboro kà Pwiduée. ");
INSERT INTO priNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Êco na, ûna bwaa tâa ê napwéretòotù ma gòropuu, â o nye ticè cè ji caapwi âmu na o câtùra gée goro ê Naèà. ");
INSERT INTO priNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","«Êkaa na go ina pâ: Wiàna gà tü tà tô wâdàgà, ma gà jèu éa côwâ, â gà jèe pâ nau toomura, ba gà cîâa jii tô wâdàgà béaa. Â ipaiwà wiàna gàu piéa ma wà tô jè ilàri na ia é jèe tapàgà piéa béaa.» ");
INSERT INTO priNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","É ina wà Iésu ê ucina bèeni: «Ru mwa tâa wà tupédu ârailu âboro. Wà pwi jèpwi, âna pwi âboro na dau pwa neemuruê. Â é mwa coona pâ ârabwée na dau wâdé ma dau too wâri wèe. Diri tòotù, âna é pwa ê pwina wâdé têe, â é pwa pâ pi-ija na dau maina.» ");
INSERT INTO priNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","21","«Â wà Lacaro, âna ticè neemuruê, â é pwi diibére, ma pwi a-ila. Â dau wâru aurumuru kêe, ba é pwa tonga, â rà dipi aurumuru kêe ê pâ akàna. É nye tà puu goropwârawâ goro i babé goro wâ kà pwi a pwa neemuruê. Â dau nümee na é ija ê dàra utimuru, na é tâjii gée gòro taapà kêe wà pwi a pwa neemuruê. ");
INSERT INTO priNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","«Â nabwé, â ru jèe bà wà i tupédu âboro bèepwiri. Â rà me wà tèpa *angela, â rà popa wà Lacaro pâdari *Abéraama, naa napwéretòotù. Â napwa naa goo i pwi a pwa neemuruê, ");
INSERT INTO priNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","âna popaé boo naa jaa tèpa bà. Â é dau maagé ma picâri naawê. «Â é tagòtùé too, â é côo wà Lacaro ma wà Abéraama na ru dau wâiti jiié. ");
INSERT INTO priNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Â é tomara too tà Abéraama, pâ: “Au, caa wée, gà meaario! Gà panuâ boome Lacaro, ba na é pitu tôo. Wâdé na é tùu boo naa na jawé ji gòobàra mangadaîê co, ma é tòpò naa gòro ûmemeeô. Ba go po dau tòoka goro ânye.” ");
INSERT INTO priNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","«Â é tòpi têe wà Abéraama pâ: “Pwina naîô, gà nye niimiri na pàara na gà bwaa wâro wâ gòropuu. Âna nye ticè cèna tiàu tâgà, â gà wâro na ipwàdée. Â wà Lacaro, âna ia é tâa na aré ma tòina. Â gà côo, nabà, âna é ipwàdée, â wâgà, âna gà tâa na aré ma tòina. ");
INSERT INTO priNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Jèpwi mwara, âna pwa pé pwêe na dau maina awé, na é wânabibiu kâjè. Â pwacoé ma bu boopaé géeni dariwà, â pwacoé ma gà toome gée pwiri, daribà.” ");
INSERT INTO priNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","«Â wà i pwi a pwa neemuruê, âna é tòpi têe pâ: “Na wàrapwiri, co caa. Â go ilagà pâ, gà cùru pâ wà Lacaro naa pwârawâ kà caa kôo. ");
INSERT INTO priNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Ba rà wêe tèpa 5 aéjii kôo, â wâdé na é patùrarà goro ê pwi ére bèeni, na go tâa na. Ba rà péa boome naani, naa na aré ma tòina.” ");
INSERT INTO priNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","«Â é tòpi têe wà Abéraama pâ: “Bwa! Ba jèe nye wâjaarà ê popai kà Moosé ma tèpa péroféta. Â wâdé co na rà nye pitêre dàra!” ");
INSERT INTO priNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","«Â é ina têe wà pwiibà pâ: “Caa, bwa. Ba o dau wâdé na é wâjué côwâ gée na aubà wà pwi jè âboro, ma é patùrarà, ba na rà o pinünüma ma rà biirà.” ");
INSERT INTO priNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","«Êco na é tòpi têe wà Abéraama pâ: “Na càra caa pitêre dà Moosé ma wà tèpa péroféta, â o càra caa pitêre dà pwi âboro na é wâjué côwâ gée na aubà!” Nabwé naawê!» ");
INSERT INTO priNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Na jè tòotù, â é ina tà tèpa *câmu kêe wà Iésu pâ: «O nye ciburà wâru pâ naigé mara èpà na o paari tâjè naa na gòropuu bèeni. Êco na ê tojii, âna é tatée pwi âboro na é popa pwi jè bée, naa na naigé bèepwiri!» ");
INSERT INTO priNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","«Gà ipwacôoco. Gà cibwaa pwa ma gùmagù ê cèikî kà pwi jè âboro kôo, na é pwacèwii ji pwi nari èpo. Ba ê wârimuru'gà, âna o dau maina jii na jè tòo naa goro nyagà cè pé atü cèna maina, ma jè tügà naa najawé! ");
INSERT INTO priNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Â gà têre, wiàna é pwa cèna èpà tâgà wà pwi a cèikî béegà, â gàu mara pitùra bwàti, â gà paari têe ê èpà kêe. Â wiàna é pinünüma ma é biié, â gà pwanaurié. ");
INSERT INTO priNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Â wiàna é tà ciburà pwa na èpà tâgà, na diri pâ tòotù, â wiàna é biié ma picigòboo tâgà taaci, â gà pwanaurié taaci.» ");
INSERT INTO priNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Na jè tòotù, â rà ina tà Iésu wà tèpa câmu kêe, pâ: «Gà naa tâbà cèikî na dau maina.» ");
INSERT INTO priNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Â é tòpi tàra pâ: «Wiàna ê cèikî kàwà, âna dau kîri pwacèwii ji nari murunyabu, â o pâri ma guwà ina târa ê upwâra bèeni pâ: “Càùgà ma câmigà naa nawià!” â o nye wàra!» ");
INSERT INTO priNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","É pacâmurirà mwara wà Iésu, â é ina tàra pâ: «Guwà jèe côo cai pwi ênawéna na é ûmwari aupwanapô, é, é wéaari macii. Wiàna é wâjué côwâ gée na aupwanapô, âna câé caa tâaboo wài naa goro taapà, ba na é mara ija, béaa kà pwi ukai kêe! ");
INSERT INTO priNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Bwa! É pitòotéri wài ârabwée kêe, ba na é mara piênawéna kà pwi ukai. Â é pwabwàti ê utimuru kêe, â é tòpò têe naa goro taapà. ");
INSERT INTO priNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Â càcaa pâri ma é pwaolé têe wà pwi ukai, ba ê pwina é pwa, âna nye wakè kêe. ");
INSERT INTO priNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","«Ipaiwà naa goowà. Ba wiàna guwà pwa diri wakè na é naa tàwà wà Pwiduée, â wâdé na guwà ina têe pâ: “Bà tèpa ênawéna'gà na piticèmuru naa goobà. Â bà nye pwa co ê wakè na gà naa tâbà.”» ");
INSERT INTO priNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","É gére pâra gée napô Galilée dàra *Iérusaléma wà Iésu, â é tèepaa naa na ére na wâmwünyabweri ê napô *Samaria. ");
INSERT INTO priNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Â é pàgà naa na jè village. Ûna é tèepaa pâ, â pwa na rà pime mariê tèpa 10 âboro na rà pwa maga. ");
INSERT INTO priNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Ûna rà bwaa wâiti jiié, â rà uu too ma ina pâ: «Pwi Ukai Iésu, gà meaaribà ma pwa ma tiàu maagé kâbà!» ");
INSERT INTO priNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Â é ucârirà wà Iésu, â é ina tàra pâ: «Guwà pâra nau ipaariwà tà tèpa pwa *ârapwaailò.» Ûna rà bwaa gére pâra, â nye tiàu kaa i pai maga kàra. ");
INSERT INTO priNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Â é côo wà pwi jè ârapàararà pâ, jèe tiàu i maga kêe. Â é nye itàa wâjué me côwâ kaa, â é tomara naa na pai ipwàdée kêe, pâ: «Pwamaina Pwiduée!» ");
INSERT INTO priNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Â é tùu jùrué ma cigòboo na ara Iésu, ba na é pwaolé têe. Napwa naa goo wà pwi âboro bèepwiri, âna pwi âboro gée Samaria. ");
INSERT INTO priNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Â é ina têe wà Iésu pâ: «Ico pwini, wâpà tèpa 9 béegà? ");
INSERT INTO priNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Gorodà na câguwà caa capai wâjué côwâ ma guwà pwamaina Pwiduée? Â wàco wâgà, na gà pwi a pârame! ");
INSERT INTO priNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Gà cimadò, â gà pâra, ba gà jèe wâdé côwâ goo ê cèikî'gà.» ");
INSERT INTO priNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Na jè tòotù â wà pàra tèpa *Farasaio, âna rà tawèeri Iésu pâ: «Wiidà cèna ée mwa tòpò ê Mwaciri kêe wà Pwiduée?» Â é tòpi tàra pâ: «Càcaa muru na guwà o côo goro âraporomeewà! Â o càcaa pâri ma guwà tà tapacîri ê câmu kêe, ");
INSERT INTO priNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","ba na guwà o pi-ina tàwà pâ: “É wâni” é, “É wâpwiri”. Ba ê *Mwaciri kà Pwiduée, âna é jèe wânabibiu kàwà!» ");
INSERT INTO priNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Gée na càùé, â ûna rà tâa acari wà Iésu ma wà tèpa câmu kêe, â é ina tàra mwara pâ: «O mwa tèepaa ê pàara na o dau nümawà na guwà côo ê pai wâjué côwâ kôo, ma jè o piwâro naima, wiàna na ji caapwi tòotù. Êco na o càcaa pâri. ");
INSERT INTO priNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Â guwà ipwacôowà, ba pwiri rà o ina tàwà pâ, go tâa ni, é, go tâa na jè ére. Â guwà cibwaa cèikî naa goorà, â guwà cibwaa pâra nau mudòo wê. ");
INSERT INTO priNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Ba wiàna go tèepaa boome côwâ, wâgo *Pwina naîri âboro, â o ticè âboro cèna é cîdaée! Ba o pwacèwii ê âra na ée pwéelaa, na jè o côo pitiri gòropuu. ");
INSERT INTO priNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Êco na, béaa kâra ê pwiibà, âna wâdé na go dau pwamaagé côo, â wâdé na rà tütâjiio wà tèpa âboro nabà. ");
INSERT INTO priNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","27","«Â go ina tàwà pâ: Rà o pò goro pai wâjué côwâ kôo wà tèpa âboro, pwacèwii tàpé na ia rà pò goro i jawé, na ia tùpwùtùru gòropuu, na pàara kà Noa. Ba rà nye tà pi-ija ma wâdo; â rà piéa, ma paéari ê pa èpo kàra. Â ticè cèna rà tâmogòori, tèepaa naa goro i tòotù, na é tò naa na i wànga kêe wà Noa. Â é nye tèepaa me kaa i jawé, â cau tubatiàurà diri wàco Noa ma ê tâa kêe na rà wâro. ");
INSERT INTO priNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","«Â ipaiwà mwara bau i pwi ia tèepaa naa *Sodoma na pàara kà Lota. Ba rà tà pi-ija ma wâdo, â rà pi-icu ma wâri, â rà pwa napô, ma ba wâ. ");
INSERT INTO priNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Â ticè cèna rà tâmogòori, tèepaa naa goro i tòotù, na é uru jii ê ville kàra wà Lota. Â é nye tèepaa me kaa ê ânye ma dà na tòo, na é tûu naa gòrà gée napwéretòotù, pwacèwii ê popaa. Â cau tubatiàurà diri. ");
INSERT INTO priNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Â o nye ipaiwà mwara, naa goo ê pai tèepaa me côwâ kôo, wâgo Pwina naîri âboro. Ba o tabapò wà tèpa âboro.» ");
INSERT INTO priNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","«Na pwi tòotù-bà, â wà pwina é nao gòroigé jii wâ, âna o càcaa pâri ma é tò naa na wâ, nau popa cè jè muru. Â wà pwina é wakè na ê na aupwanapô, âna o càcaa pâri ma é bwaa wâjué côwâ naa jaaé. ");
INSERT INTO priNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Â guwà niimiri ê pwina é tèepaa naa goo wâdà Lota, na ia é niâ wâjué côwâ. Ba ia tiàué ma wà tàpé Sodoma. ");
INSERT INTO priNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","«Ba wà pwina nümee na é wéaari ê wâro kêe, âna ée mwa tubatiàu. Â wà pwina é panuâ ê wâro kêe, âna wà pwiibà, âna ée udò â o tâa têe ê *âji wâro. ");
INSERT INTO priNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Na go o mwa wâjué côwâ, â go mwa popa tèpa âboro kôo. Ba gée goo wà tupédu âboro cèna ru puu na caapwi naditàrawâ, âna o popa pwi jèpwi, â o naaco pwi jèpwi. ");
INSERT INTO priNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Â gée goo du ilàri cèna ru tòbiti blé naima, âna o popa tô jèpwi, â é tà tâa tô jèpwi. { ");
INSERT INTO priNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","«Â gée goo wà tupédu âboro cèna ru wakè na aupwanapô, âna o popa pwi jèpwi, â é tà tâa pwi jèpwi.}» ");
INSERT INTO priNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Ûna rà têre ê popai bèepwiri wà tèpa câmu kêe, â rà tawèerié pâ: «Gona wiidà na o mwa tèepaa pwiri, co Pwi Ukai?» Â é tòpi tàra pâ: «Guwà tàcî, â guwà côo pâ câmu kêe. Ba pwacèwii na jè mu ina pâ: “Wâna é tâ tabéaa wê bwaooré, âna é wêe ê macii bà.”» ");
INSERT INTO priNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","É ina ê ucina bèeni wà Iésu tà tèpa *câmu kêe, ba na é paari tàra pâ, wâdé na jè ciburà pwapwicîri, â jè cibwaa nama oratâjè. ");
INSERT INTO priNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","3","Â é ina tàra pâ: «É mwa tâa wà tô jè dàpwà na ticè kêe. Â, na jè tòotù, â é pâra dari pwi jè a pitèimuru, pwi âboro na dau imaina nau ilari jiié pâ, na é tèi pwi jè âboro na ia é pwa na èpà têe. Â é ina têe wà tôoni pâ: “Pwi ukai, gà pitu tôo!” «Êco na wà pwi a pitèimuru, âna câé caa pwi a papwicîri wà Pwiduée, â câé caa papwicîri tèpa âboro mwara. ");
INSERT INTO priNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","5","Â tàutêe, â é pawâjuépiri wà tô dàpwà. Êco na é ciburà medarié diri pâ tòotù wà tôoni, tiagoro na ée mwa têreê. «Â nabwé, â é pi-ina têe wà pwi a pitèimuru pâ: “Auwa! Po dau oratôo goo wà tôoni! Ticè cèna go côo naa goo Pwiduée. Â ticè cèna go côo naa goo tèpa nari âboro na pwacèwii tôoni. Êco na go o jèe naa têe tàrù, ba na o câé mwa caa me nau ciburà iluurio.”» ");
INSERT INTO priNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Â é ina mwara wà Pwi Ukai Iésu pâ: «Guwà jèe côo cai ê pwina tèepaa! ");
INSERT INTO priNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","É pitu têe wà pwi a pitèimuru bèepwiri na é èpà. Â gona wà Pwiduée, âna o câé caa têre tèpa âboro kêe, ma pitu tàra, wiàna rà todèe ûna ne ma pwaa? ");
INSERT INTO priNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Akaé! É nye nama têre dàra wài. Êco na, ûna go o mwa wâjué côwâ naani gòropuu wâgo *Pwina naîri âboro, â gona go bwaa pâmari tèpa âboro na rà cèikî?» ");
INSERT INTO priNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Pwa pàra tèpa âboro na rà niimiri pâ rà *tàrù na ara Pwiduée, â rà pitaurèe goo wà pàra tàpé. É ina jè ucina wà Iésu, ba kàra: ");
INSERT INTO priNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","«Ru mwa tâa wà tupédu ârailu âboro. É pwi *Farasaio pwi jèpwi—pwi a ciburà pwapwicîri tà Pwiduée. Â é pwi a *tò mwani wâripû pwi jèpwi—pwi a pwa tûâ goro ê mwani wâripû. Â, na jè tòotù, â ru pâra nau pwapwicîri na *Wâra pwapwicîri. ");
INSERT INTO priNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","«Â é cimadò wà pwi Farasaio, â é ina naa na pwâranümee pâ: “Pwiduée kôo, go ipwaolé tâgà, ba câgo caa wàra pàra tàpé, na èpà ê wâro kàra. Ba càra caa *tàrù, â rà tèpa mura, â rà tèpa piwâmi pa wâdàra. Â câgo caa wàrapwiri! Â go ipwaolé tâgà, ba câgo caa wàra pwi a tò mwani wâripû bèeni. ");
INSERT INTO priNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Â go pâra wiâra bwàti ê naèà kâra pwapwicîri. Ba go mu naaco ê utimuru na jè ji pàara, ba na go pwapwicîri tâgà, naa na ârailu tòotù, naa na nadàpàra pwapwicîri. Â go tòpò tâgà caapwi ére gée goro 10, gée goro ê ârawakè kôo.” ");
INSERT INTO priNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","«Â napwa naa goo wà i pwi a tò mwani wâripû, âna càcaa pâri ma é tagòtùé dò naa napwéretòotù, na é pwapwicîri. Â é cùu ê nawâaê ba é ipakîriê, â é ina tà Pwiduée pâ: “Pwiduée wée, gà meaario! Ba go pwi âboro èpà.”» ");
INSERT INTO priNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Â é ina wà Iésu pâ: «Gona wàilàapà gée goo tupédu âboro bèepwiri, na é nama wâdé pwâranümee wà Pwiduée? Wàilàapà na é tàrù na araé? Nye wàco pwi a tò mwani wâripû, â càcaa wà pwi Farasaio. Ba wà pwina é ipwamainaê, âna o naaê boo. Â wà pwina é ipakîriê, âna o naaê too.» ");
INSERT INTO priNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Na jè tòotù, âna rà medari Iésu wà pàra tèpa âboro. Â rà pame têe ê nyi nari èpo kàra, ba na é tu naa goorà, ma é *pwényunyuâarirà. Êco na wà tèpa câmu kêe, âna rà pwa tèpa âboro, ma pacoorà. ");
INSERT INTO priNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Êco na é ina tàra wà Iésu pâ: «Guwà naaco nyi tèpa nari èpo, ma rà medario! Guwà cibwaa pacoorà! Ba ê *Mwaciri kà Pwiduée, âna o kâra ê pâ âboro na rà wàra ê nyi nari èpo. ");
INSERT INTO priNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Üu, âjupâra ê pwina go ina tàwà pâ: Wà pwi âboro na câé caa tòpi ê Mwaciri kà Pwiduée pwacèwii ê nari èpo, âna wà pwiibà, âna o pwacoé têe ma é tò naa na.» ");
INSERT INTO priNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Wà pwi jè a pitûâ kâra ê pwapwicîri kà tèpa *Juif, âna é tawèeri Iésu pâ: «Pwi a pwa pupûra, gà nye dau pwi âboro wâdé kaa. O dà cèna go pwa, ma o tâa tôo ê *wâro dàra gòiri jaa Pwiduée?» ");
INSERT INTO priNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Â é tòpi têe wà Iésu pâ: «Gona cina gà ina gooò pâ, go pwi âboro wâdé? Âjupâra pai ina'gà. Ba nye ticè pwi âboro na wâdé; â nye caapwi co—wà Pwiduée. ");
INSERT INTO priNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Â napwa naa goo ê pai tawèeri'gà, âna gà tâmogòori bwàti ê pâ *Naèà: Gà cibwaa toomura (gà cibwaa cîâa jii tô wâdàgà, é, wà pwi éagà); Gà cibwaa tétàmwara âboro; Gà cibwaa mura; Gà cibwaa ina cè popai na pwâ, naa goo cè pàra âboro; Gà papwicîri du nyaa ma caa'gà.» ");
INSERT INTO priNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Â é tòpi têe wà pwi âboro-bà pâ: «Üu kaa, go jèe pitêre dàra kaa pâ pwiibà gée na aukîri kôo.» ");
INSERT INTO priNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Â é ina têe wà Iésu pâ: «Gà têre, nye caapwi co jè muru, na bwaa tiàu jiigà. Wàéni: Gà pâra, â gà nye icuri kaa diri ê pâ neemurugà, â gà naa ê mwani wâri wèe tà tàpé na ticè kàra. Ba na wàrapwiri, âna o pwa cè wâdé'gà naa jaa Pwiduée. Â gà me wiâô!» ");
INSERT INTO priNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Êco na é po dau pikîri wà pwini, ba po dau pwa neemuruê. ");
INSERT INTO priNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Â é niâ wiâê wà Iésu, na é gére pâra. Â é ina tà tèpa câmu kêe pâ: «Guwà côo, wà tàpé na dau pwa neemururà, âna dau pwacoé tàra, na rà tò naa na Mwaciri kà Pwiduée! ");
INSERT INTO priNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","«Gona ê kaamela, âna pâri ma é tò na ê pwêe goro kaju? Bwa, pwacoé! Â go ina tàwà pâ: Wà pwi âboro na pwa neemuruê, âna mwa nye dau pwacoé têe awé, ma é tò naa na Mwaciri kà Pwiduée.» ");
INSERT INTO priNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Â rà mwa nye dau pò kaa, tàpé na rà têreê, â rà nye ina pâ: «A? Â gona wàilàapà cè pwina o pâriê ma é udò ma tâa têe ê *âji wâro?» ");
INSERT INTO priNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Â é tòpi tàra pâ: «Ê pwina pwacoé tà pwi âboro na é pwa, âna pâri wà Pwiduée.» ");
INSERT INTO priNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Â é ina têe wà Pétéru pâ: «Gà côo, wàibà, âna bà jèe nye po panuâ diri, ba na bà pâra wiâgà!» ");
INSERT INTO priNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Â é ina tàra wà Iésu pâ: «Wàépwiri. Â go ina tàwà ê âjupâra pâ: Wâru tàpé na rà o mwa panuâ ê pwârawâ kàra, ba na rà piênawéna kâra ê Mwaciri kà Pwiduée. Â rà o panuâ pâ wâdàra ma pâ èpo kàra, ma du nyaa ma caa kàra ma wà tèpa aéjii kàra, ba na rà pâra wiâô. Êco na go ina pâ: Wà tàpé na rà wàrapwiri ");
INSERT INTO priNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","âna rà mwa tòpi tapoo nabà, cè muru na piwéna, na dau maina ma dau wâru. Â gée na càùé, â rà mwa tòpi ê wâro dàra gòiri jaa Pwiduée.» ");
INSERT INTO priNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Càcaa gòiri ê pai tèepaa dò naa *Iérusaléma kà Iésu ma wà tèpa câmu kêe. Â é poparà iti, ba na é patùrarà goro pâ muru na o jèe tèepaa têe. Â é ina tàra pâ: «Wà tèpa *péroféta biu, âna wâru pâ popai na rà wii naa gooò, wâgo Pwina naîri âboro. Â guwà côo, naa Iérusaléma, âna o jèe cau coo diri. ");
INSERT INTO priNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","«Ba o jèe panuâô tà tàpé na càra caa tèpa Juif. Â rà o pitaurèe gooò, ma tubaèpà tôo, ma èdurio, ");
INSERT INTO priNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","ma pâdio goro ubati. Â rà o nama go bà. Â, naa na béâracié kâra tòotù gée na càùé, âna go o mwa wâro côwâ gée na aubà.» ");
INSERT INTO priNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Êco na càra caa tâmogòori ê pwina é ina wà tèpa câmu kêe—wiàna ji caapwi popai. Ba naapwàniri jiirà ê pai ina wèe ma autâmogòori goo. ");
INSERT INTO priNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Rà bwaa nye gére pâra naa Iérusaléma wà Iésu ma wà tèpa câmu kêe. Â rà tèepaa pâ naa Iériko. Â wâru mwara tèpa âboro na rà gére pâra wiâê. Â naa na autò goro ê pwi village-bà, âna pwa pwi jè a bwi, na é tà tâa bàra naigé, âna é gére ila, ba pwi a ticè kêe. ");
INSERT INTO priNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Ûna é têre ê pwâratùra kâra diri pâ âboro na rà pâra wiâ Iésu, â é ina tàra pâ: «Wànau, co tàpéebà?» ");
INSERT INTO priNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Â rà tòpi têe pâ é gére paé wà Iésu, pwi âboro gée Nazareth. ");
INSERT INTO priNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Â é nye tà tomara too pâ: «Iésu, *Pwina naî Davita, gà meaario, â gà pitu tôo!» ");
INSERT INTO priNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Wà tàpé na rà pâbéaa kà Iésu, âna rà kànariê, ba na rà pacooé. Êco na é mwa nye dau to too kaa burà ina pâ: «Pwina naî Davita, gà meaario, â gà pitu tôo!» ");
INSERT INTO priNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Â é tàpo coo wà Iésu, â é ina tàra pâ, na rà popaé medarié. Â é ina têe pâ: ");
INSERT INTO priNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","«Dà cè pwina nümagà goo? Dà cèna pâri ma go pwa ba kâgà?» Â é tòpi têe pâ: «Gà pwa ma go niâ ma wàra béaa, co Pwi Ukai.» ");
INSERT INTO priNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Â é ina têe wà Iésu pâ: «Gà niâ côwâ! Gà jèe wâdé côwâ, goo ê cèikî'gà!» ");
INSERT INTO priNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Â é jèe nye niâ kaa, wàra béaa. Â é pâra wiâ Iésu, âna é gére pwamaina Pwiduée. Â wà mwara diri tàpé na rà côo pwiri, âna rà cau pwamaina Pwiduée goo! ");
INSERT INTO priNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","É tèepaa pâ naa Iériko wà Iésu, â é gére tapàgà i village-bà. ");
INSERT INTO priNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","É tâa wê wà pwi âboro na nee Zakaio, na é pwi caa kà tèpa *tò mwani wâripû. É pwi âboro imaina, â dau pwa mwani kêe. ");
INSERT INTO priNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Â é imudàra cè pai côo kêe wà Iésu, êco na càcaa pâri, ba ji pwi âboro ûgé. Â po dau wâru pâ âboro na rà cibéaa kêe, ba na rà me nau côo wà Iésu. ");
INSERT INTO priNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Â é itàa béaa kâra ê pâ âboro, â é too wii jè upwâra, ba na é côo Iésu wiàna é me niboo aranaê. ");
INSERT INTO priNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Ûna é tèepaa pâ naa jaaé wà Iésu, â é tagòtùé too, â é ina têe pâ: «Pwi ukai Zakaio, gà boo wài gée gò ê upwâra bèepwiri. Â gà wàcî! Ba nabà, âna pâri ma ju pi-ija naima jaagà.» ");
INSERT INTO priNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Â é dau ipwàdée wà pwini Zakaio, â é nye tàbàtù boo kaa, â é popa Iésu pâ naa jaaé. ");
INSERT INTO priNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Â wà tèpa âboro, âna rà putàmu, â rà ina pâ: «Kaa! Po èpà na é pâra naa jaa pwi âboro èpà bèepwiri!» ");
INSERT INTO priNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Êco na é coo ara Iésu wà Zakaio, â é ina têe pâ: «Têre co Pwi Ukai, go o mwa naa tà tèpa ticè kàra jè ére mwani kôo. Â wiàna go popa ba kôo cè mwani cèna piwéna jii ê âji wâripû â go pitôowâri tà pwi âboro cè pwina go mura jiié. Â go o mwa naa têe cèna dau piwéna.» ");
INSERT INTO priNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Â é tòpi têe, na ara tèpa âboro, wà Iésu pâ: «Wà Pwiduée, âna é pa-udògà, bau ê pwârawâ'gà! Ba gà paari pâ gà pwi âji gòobàra *Abéraama! ");
INSERT INTO priNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Ba é cùruo me wà Pwiduée, wâgo *Pwina naîri âboro, ba na go mudà tàpé na rà imwüru pwacèwiigà. Â go mwa pa-udòrà, ma naa tàra ê *âji wâro.» ");
INSERT INTO priNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Wâru pâ âboro na rà gére tàmaari ê pwâratùra kà Iésu. Â é ina tàra ê ucina, ba na rà tâmogòori ê âji pai pwa goo ê pai tèepaa kâra *Mwaciri kà Pwiduée. Ba é tàmwünyabweri *Iérusaléma, â rà niimiri pâ pwiri ée jèe tòpò ê Mwaciri, ûna é tò naa na ville. ");
INSERT INTO priNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Â é ina tàra pâ: «É mwa tâa wà pwi jè âboro gée na jè wâao na imaina. Â rà mwa todèe, ba na ée pwi ukai naa napô kêe. Â é mwa pwabwàti pai pâra kêe, naa na jè napô na wâiti, ba na é côo pwi ukai maina naawê, ma tòpi pwâra ukai kêe. ");
INSERT INTO priNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Â é todà tèpa 10 ênawéna kêe. Â é jèpa ipâdi tàra jèpa mwani na wâru, â é ina tàra pâ: “Guwà wakèri i mwani kàwà ba na o piwâru too—guwà wakèri tiagoro cè tòotù na go mwa wâjué me côwâ!” ");
INSERT INTO priNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Â nabwé, â é pâra, ba na é tòpi pwâra ukai kêe. «Êco na wâru tàpé naa napô kêe na rà èpàrié, â rà cùru tèpa âboro wiâê, naa na napô na é pâra naawê, ba na rà ina tà pwi ukai maina pâ: “Tàutâbà goo pwi âboro bèeni! Tàutâbà na é pwi ukai kâbà.” ");
INSERT INTO priNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","«É jèe nye nama é pwi ukai. Â nabwé, â é jèe nye wâjué côwâ. Â é todà me tèpa ênawéna kêe, na ia é pâdi tàra i mwani kêe, ba na é côo cè pwina piwéna gée goo. ");
INSERT INTO priNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Â wà pwi jèpwi gée goorà, âna é tòpi têe pâ: “Pwi ukai, wàéni i caapwi miliô mwani na gà naa tôo. Â wàéni mwara 10 miliô na go naa dòme!” ");
INSERT INTO priNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","«Â é ina têe i pwi ukai pâ: “Po dau wâdé, ba gà pwi a wakè bwàti. Ba gà pitêre dàra, naa na nyi muru na kîri, â go mwa naa tâgà ê pumara wakè'gà. Wàéni: Gà mwa pwi kupénoo kôo, naa na pâ 10 ville!” ");
INSERT INTO priNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","«Â é me wà pwi jè ênawéna, â é ina tà pwi ukai kêe pâ: “Pwi ukai, wàéni i caapwi miliô na gà naa tôo. Â wàéni mwara 5 miliô na go naa dòme!” ");
INSERT INTO priNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","«Â é ina têe i pwi ukai pâ: “Wâdé! Wàéni ê pumara wakè'gà: Gà mwa pwi kupénoo kôo naa na pâ 5 ville!”» ");
INSERT INTO priNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","«Â nabwé, â é me wà pwi jèpwi, â é ina têe pâ: “Au, pwi ukai, gà popa côwâ i mwani'gà. Â nye ticè mwani na go naa dòme, ba go nye tà naapwàniri, ");
INSERT INTO priNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","ba wâgotôo na go tubatiàu. Ba go nye tâmogòori pâ gà pwi a putàmu naa goo tàpé na càra caa wakè bwàti. Ba gà pwi a piûnyari ê ârawakè na câgà caa câmi, â gà panaimari ê pwina câgà caa wakèri.” ");
INSERT INTO priNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","«Â é tòpi têe wà i pwi ukai kêe pâ: “Ò! Pwiini! Gà pwi ênawéna èpà! Gà pitòtigà côwâ goro ê pwina gà ina! Wànau, gà ina pâ gà tâmogòori pâ, go pwi a putàmu naa goo tàpé na càra caa wakè bwàti? Â gà tâmogòori pâ, go piûnyari ê pwina câgo caa câmi, â go panaimari ê pwina câgo caa wakèri? ");
INSERT INTO priNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Â gorodà na câgà caa tòpò naa na cè wâra mwani i mwani kôo?! Ba wiàna gà gére wàrapwiri, â pwiri go o mwa gére pa côwâ gée na wâra mwani, bau cè naîê!” ");
INSERT INTO priNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","«Â é ina tà tèpa pwàliici kêe, wà i pwi ukai pâ: “Popa jiié i mwani bèepwiri, â guwà naa tà pwi ênawéna na ia wâru mwani kêe!” ");
INSERT INTO priNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","«Êco na rà tòpi têe pâ: “Jèe po dau pâra na wâru mwani kà pwiibà!” ");
INSERT INTO priNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","«Â é ina tàra wà pwi ukai pâ: “Guwà côo, é wakèri bwàti i pwi ia naa têe, ba na pwa cè naîê. Â wà pwina jèe pwa têe, âna o jèu âjagò têe côwâ. Â wà pwina kîri ê pwina tà têe, âna o nye dàgòtù jiié côwâ ê ji dàramuru na tà têe. ");
INSERT INTO priNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Â ni, na wâpà tèpa âboro na rà cicarao, â tàutàra na go pwi ukai kàra? Guwà tâjùrurà, â guwà poparà me naani. Â guwà tétàmwararà na arao!” Nabwé naawê!» ");
INSERT INTO priNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Ûna é ina diri ê ucina bèepwiri wà Iésu, â é tabiié, â é coo gòobàra ê naigé kêe pâ naa Iérusaléma. Â rà pwicò kêe wà tèpa *câmu kêe. ");
INSERT INTO priNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Â rà tèepaa mwünyabweri Bétani, ma wâ Bethfagé, du village na ru tâa goro jènere ê gòrojaa Élaio. Â é panuâ pâ ê tupédu a câmu kêe wà Iésu, ");
INSERT INTO priNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","â é ina tàru pâ: «Gàu pâra naa na village bèepwiri, tâa béaa kâjè. Â gàu o pâmari naawê, ê ji nari buriko, na tòoé goro otàpwe, na bwaa nye ticè âboro cèna mu caa tâa gòé. Â gàu tipié, â gàu popaé me naani. ");
INSERT INTO priNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Â wiàna rà tawèeriu pâ: “Gorodà na gàu tipié?” â gàu tòpi tàra pâ, “Bu popaé pâdari Pwi Ukai.”» ");
INSERT INTO priNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Â ru pâra, â ru pâmari i nari buriko, pwacèwii na ia é ina tàru. ");
INSERT INTO priNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Ûna ru gére tipié, â wà tèpa apooé, âna rà ina tàru pâ: «Gorodà na gàu tipi ê pwi nari buriko bèepwiri?» ");
INSERT INTO priNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Â ru tòpi tàra pâ: «É ina tâbu pwi ukai pâ, na bu popaé pâdarié, ba pwa wakè kêe.» ");
INSERT INTO priNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Â ru popa me i nari buriko dari Iésu. Â ru tòpò pâ ârabwée, naa gòro càùé, â rà nama é tâa gòé wà Iésu. ");
INSERT INTO priNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","É tâa gò pâ i buriko, naa Iérusaléma wà Iésu. Â wâru ê pâ âboro, na rà pòpwara béaa kêe naa gòro naigé ê pâ ârabwée kàra, ba na rà pwamainaê. ");
INSERT INTO priNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Â rà tèepaa naa na pwi ére, na i naigé, âna é tapoo boo gée gò i gòrojaa Élaio, â é boo dàra Iérusaléma. Â wà diri tèpa âboro na rà gére pâra wiâ Iésu, âna rà tapoo uu too ma pwamaina Pwiduée. Â rà picâdirié gée goro diri ê pâ câmu kâra pàtàmee, na dau muugère, na ia rà jèe côo na é pwa. ");
INSERT INTO priNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Â rà cau tomara too pâ: «Cidòri nyuâa Pwi Ukai bèeni! É me na nee Pwiduée, nee Pwi Ukai maina! Pinaanapô ma ipwamaina wânidò napwéretòotù; Cidòri ma tòbuari naa na autâa kêe!» ");
INSERT INTO priNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Êco na wà pàra tèpa *Farasaio na rà tâa wê, âna rà pwa Iésu, â rà ina têe pâ: «Pwiini, dau càcaa wâdé ê pwina rà ina wà tèpa béegà bèeni. Â gà ina tàra pâ rà târi pwârà!» ");
INSERT INTO priNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Â é tòpi tàra pâ: «Wiàna pâri ma târi pwârà, â rà o pwamaina Pwiduée ê pâ atü bèeni!» ");
INSERT INTO priNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","É pâmwünyabweri Iérusaléma wà Iésu, â ûna é côo i ville na coo béaa kêe, â é imuruê. ");
INSERT INTO priNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Â é ina pâ: «Au! Wârico! Ico Iérusaléma, dau nümoo na wâgà mwara, âna gà pâmari ê pinaanapô nabà. Êco na tàutâgà, â o càcaa mwa caa pâri ma tèepaa nabàni! ");
INSERT INTO priNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Ba o càcaa gòiri, â rà o mwa tèepaa medarigà tèpa pièpàrigà. Â rà o cibèepigà ma cuwârigà, naa na diri ê pâ ére. Rà o pwa bèepigà pâ auba wâragu, â rà o ipaa dàgà. ");
INSERT INTO priNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Â rà o tédidiri ê auba babé wâri'gà, â o mwa ticè atü na o mwa pitâagòrà too wê. Â rà o còogaiwà, ma êdiri tèpa âboro'gà. Wàrapwiri ba câgà caa côoinari ê pwi pàara na é medarigà na, wà Pwiduée, ba na é pa-udògà.» ");
INSERT INTO priNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Rà tèepaa pâ naa Iérusaléma, â é tò wà Iésu naa na *Wâra pwapwicîri. Â é pacòobé tèpa gére pwa jèna, gée na gòroigé kâra Wâra pwapwicîri. ");
INSERT INTO priNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Â é ina tàra pâ: «É ina wà Pwiduée naa na *Tii Pwicîri, pâ: O mwa ina goo ê wâ kôo pâ, wâ târa pwapwicîri. Êco na wâguwà, âna guwà gére pwa ma aucârü kà tèpa mura!» ");
INSERT INTO priNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Gée na càùé, â wà Iésu, âna é pacâmuri tèpa âboro, naa na Wâra pwapwicîri, na diri pâ tòotù. Napwa naa goo wà tèpa caa kà tèpa pwa *ârapwaailò, ma wà tèpa *dotée goro ê Naèà, ma wà tèpa pitûâ kà tèpa Juif âna rà tapoo mudàra cè pai pwa wèe, ba na rà tétàmwereê. ");
INSERT INTO priNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Êco na càra caa pâmari, ba po dau wâru tèpa âboro, na rà câdiri ê pâ popai na é pacâmurirà goo. ");
INSERT INTO priNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Wà Iésu, âna é pacâmuri tèpa âboro naa na *Wâra pwapwicîri, â é picémara tàra ê *Picémara Wâdé. Na jè tòotù, ûna é gére wàrapwiri, â rà me burèe wà pàra tèpa caa kà tèpa pwa *ârapwaailò, ma wà tèpa *dotée goro ê Naèà, ma wà tèpa pitûâ. ");
INSERT INTO priNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Â rà tawèerié pâ: «Pwiini, wàilàapà na naa tàrù tâgà, ma gà pwa ê pâ muru bèepwiri? Wàilàapà na cùrugà?» ");
INSERT INTO priNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Â é ina tàra pâ: «Go bwaa nama tawèeriwà, goro ji caapwi muru. Wàéni: ");
INSERT INTO priNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Wàilàapà na naa tàrù tà Ioane ma é *piupwaa? Wà Pwiduée, é, wà tèpa âboro?» ");
INSERT INTO priNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Â rà dau pitùra goo, â rà pi-ina tàra pâ: «Wiàna jè tòpi têe pâ: “Tàrù gée jaa wà Pwiduée” â ée mwa ina tâjè pâ: “Â gorodà na câguwà caa cèikî naa goo ê pwina é ina tàwà wà Ioane?” ");
INSERT INTO priNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Â wiàna jè tòpi têe pâ: “Tàrù gée jaa tèpa âboro” â rà o péa èijè goro atü wà tèpa âboro. Ba rà cau cèikî ba gòo pâ wà Ioane âna é pwi *péroféta, na é pame ê popai gée jaa wà Pwiduée.» ");
INSERT INTO priNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Â êkaa, na rà tòpi tà Iésu pâ: «Îi, câbà caa tâmogòori.» ");
INSERT INTO priNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Â é ina tàra pâ: «Â wâgo mwara, âna o câgo caa ina tàwà, wàilàapà na naa tàrù tôo ma go pwa ê pwina go pwa.» ");
INSERT INTO priNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Wà Iésu, âna é piwiâ tà tèpa âboro ê ucina bèeni: «É mwa tâa wà pwi jè âboro. É mwa câmi jè nadipâa. Â nabwé, â é niimiri pâ é pâra nau ipokâa naa jè napô. Â é wâri pàra tèpa âboro, ba na rà wéaari i na aupwanapô kêe. Â é pâra, â tàpo gòiri pai tâa kêe naa napô bèepwiri. ");
INSERT INTO priNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Paé pâ parui, paé, paé, paé… tèepaa naa na pàara na jè pétâ pwâra dipâa na. Â é panuâ pâ pwi jè âboro kîri kêe, ba na é tòpi jii tèpa wéaari nadipâa cè kêe gée goro ê piûnya. Êco na rà pâdié, â rà panuâê pâ côwâ, â nye ticè cèna rà naa têe. ");
INSERT INTO priNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","«Â géewê, â é panuâ me côwâ pwi jè âboro kîri kêe. Â rà èié mwara, â rà pé pidurié. Â rà panuâê pâ côwâ, â nye ticè cèna rà naa têe. ");
INSERT INTO priNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Â nabwé, â é panuâ pâ mwara ê pwi béâracié kà tèpa âboro kîri kêe, â rà tanooriê, â rà tü têe. ");
INSERT INTO priNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","«Â nabwé, â é pi-ina têe wà pwi apooro nadipâa pâ: “Dà cèna go o mwa pwa? Go o mwa panuâ pâ pwi âji naîô, na dau wânümoo gooé. Ba pwiri rà o mwa tòimiriê.” ");
INSERT INTO priNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","«Êco na, ûna rà côoê wà tèpa âboro èpà bèepwiri, â rà pitêrerà, â rà ina pâ: “Guwà côo, wàé kaa ni wà pwi ia ée mwa pwi apooro i na aupwanapô, na cè jè tòotù. Wâdé na jè tétàmwereê cawi, ba na o mwa tà kâjè i na aupwanapô!” ");
INSERT INTO priNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","«Â rà dàtié còobé jii i na aupwanapô. Â rà tétàmwereê.» Â wà Iésu, âna é tawèeri tàpé na rà gére têreê, pâ: «Â o dà cèna ée pwa wà pwi apooro i nadipâa? ");
INSERT INTO priNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Ée mwa po me wàé, â ée mwa nama tétàmwara i tèpa wéaari wàra i na aupwanapô. Â ée mwa caa naa ê nadipâa bèepwiri tà pàra tàpé, ba na rà wéaari. Nabwé!» Êco na wà tàpé na rà gére têre ê ucina bèepwiri, âna rà pò, â rà ina pâ: «Bwa! Pwacoé! O càcaa wàrapwiri!» ");
INSERT INTO priNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Â é niârirà wà Iésu, â é tòpi tàra pâ: «Guwà jèe niimiri cai i pwi ia wii naa na Tii Pwicîri pâ: I pwi atü na rà tétâjii wà tèpa ba wâ, âna nye wàé kaa pwiri, i âji êkêe! Tàutàra goo pwi ò kâra wâao!» Psaume 118.22 ");
INSERT INTO priNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","«Wiàna é tûu cè pwi jè âboro naa gòro pwi atü-bà, â o tadidiri ê naiié. Â wiàna é tûu i pwi atü-bà naa gòro pwi jè âboro, â é câgagaié.» ");
INSERT INTO priNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","20","Wà tèpa dotée goro ê Naèà, ma wà tèpa caa kà tèpa pwa ârapwaailò, âna rà tâmogòori pâ é tàgére pwa ucina wà Iésu naa goorà. Â dau nümarà na rà tâjùrué wài, ba na rà icurié tà pwi kupénoo kà tèpa *Roma. Êco na wâgotàra, gée goo na wâru tèpa âboro na rà wâdéarié, â rà naaê. Â rà gére piwéaa gooé. Na jè tòotù, â rà panuâ pâdarié tèpa âboro, ba na rà tawèerié goo pàra muru. Â wàilà, âna rà ina têe pâ, nümarà na rà tâmogòori ê âjupâra. Êco na rà mudàra cè pai pitòtié, naa na pai tòpi kêe tàra. ");
INSERT INTO priNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Wàéni pwâra pitùra kàra ma wàé: «Pwi a pwa pupûra, bà nye tâmogòori pâ, gà ina ê âjupâra, â câgà caa ipwaké goro âboro. Ba gà nye picémara ba tàrù diri ê pâ muru na nüma Pwiduée na bà pwa. ");
INSERT INTO priNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Â êkaa, na nümabà na bà tawèerigà pâ: Pwiri wâdé na jè wâripû tà pwi ukai kà tèpa Roma? É, o càcaa wâdé?» ");
INSERT INTO priNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Êco na é tâmogòori ji ipwa tûâ kàra wà Iésu. Â é ina tàra pâ: ");
INSERT INTO priNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","«Paari tôo ê jè mwani atü. Naporomee î ma nee î, na wâgòro ê mwani bèeni?» Â rà tòpi têe pâ: «Kà pwi ukai kà tèpa Roma.» ");
INSERT INTO priNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Â é ina tàra wà Iésu pâ: «Â jèe wâdé, guwà pitôowâri tà pwi ukai ê pwina kêe; â guwà pitôowâri tà Pwiduée ê pwina kà Pwiduée.» ");
INSERT INTO priNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Â rà po dau pò goo ê pai tòpi kêe, ba càcaa pâri ma rà pwa tûâ têe na ara tèpa âboro. Â nye ticè cèna rà tòpi têe goo. ");
INSERT INTO priNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Napwa naa goo wà tèpa *Sadukaio, jè ditàra pwapwicîri kà tèpa *Juif âna càra caa cèikî pâ, rà o wâro côwâ wà tèpa bà. Â wà pàra tàpé gée goorà, âna rà medari Iésu. Â târa ma rà paari pâ rà âjupâra â rà tawèerié pâ: ");
INSERT INTO priNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","«Ico pwi a pwa pupûra, é jèe wii tâjè wà *Moosé naa na ê *Naèà pâ: Wiàna é bà wà pwi âboro, na ticè èpo kêe, â wâdé na é popa tô dàpwà kêe wà pwi jiié, ma ru piéa. Â, na wàrapwiri, â é naa cè gòobàra pwi a bà. ");
INSERT INTO priNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","«Â wâdé. Êco na gà jèe niimiri cai ni: Pwa tèpa 7 aéjii. Â é piéa wà pwina ciàra, êco na é bà, â nye ticè èpo kêe. ");
INSERT INTO priNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Â pwi a pâ wê, âna ru piéa ma tô dàpwà, êco na é bà mwara wà pwini, â nye ticè èpo kàru. ");
INSERT INTO priNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Â wà pwi béâracié, âna ipaiwà. Â wàrapwiri naa goo wà tèpa 7 aéjii bèepwiri. Ba rà cau bà, â nye ticè èpo kàra. ");
INSERT INTO priNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Â gée na càùrà diri, â é mwa bàra bà wà i tô ilàri. ");
INSERT INTO priNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Gà ina pâ rà o mwa wâro côwâ wà tèpa bà, na jè tòotù. Â wiàna wàrapwiri, â wàilàapà narà, na o pwi éa tô ilàri-bà, na tòotù bèepwiri? Ba rà nye cau tèpa éaé diri! Â?! Gà tòpi cai!» ");
INSERT INTO priNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","É tòpi tàra wà Iésu pâ: «Guwà pitanami. Ba jè piéa co naa na pàara bèeni na jè bwaa wâro naa gòropuu. ");
INSERT INTO priNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","36","Â o càcaa wàrapwiri naa na pàara noowê. Ba wà Pwiduée, âna ée mwa pitòrigari tèpa naîê—tàpé na é niimiri pâ pâri ma rà picaatâa ma wàé. Â nye wàilà kaa na ée mwa pawârorà côwâ gée na aubà, â rà o pwacèwii tèpa *angela kêe. Ba o càra mwa caa bà côwâ. Â o càra mwa caa piéa côwâ. ");
INSERT INTO priNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","«Guwà tawèerio naa goo ê pai wâro côwâ gée na aubà. Â gona câguwà caa tâmogòori ê pwina é ina wà Moosé? Ba é pwa jèkutâ naa na ê tii kêe goro i ji na nari upwâra, na ia tòo gò i ânye. Ba é ina goo Pwi Ukai Pwiduée pâ, é Pwiduée kà *Abéraama, ma Isaaka, ma Iakobo. ");
INSERT INTO priNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Pai ina wèe pâ rà nye cau tàgére *wâro jaa Pwiduée! Ba wà Pwiduée, âna câé caa Pwiduée kà tèpa bà, â é Pwiduée kà tàpé na rà wâro.» ");
INSERT INTO priNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Wà pàra tèpa dotée goro ê Naèà, âna rà têre ê pwina é ina wà Iésu tà tèpa Sadukaio, â rà ina têe pâ: «Aipaa! Nye dau wâdé kaa ê pai tòpi'gà, co pwi a pwa pupûra!» ");
INSERT INTO priNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Ba ipwacoé tàra, na rà tawèeri wà Iésu goo cè pàra muru. ");
INSERT INTO priNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Â é ina tàra pâ: «Gorodà na rà ina wà tèpa âboro pâ, wà pwi *Mesia, pwi ukai na guwà tapacîê âna é pwi âboro kîri jii *Davita, gée goo na é pwi gòobèreè co?» ");
INSERT INTO priNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","43","«Bwa, càcaa wàrapwiri, ba nye wà Davita kaa, na é ina naa na tii Salamo, pâ: Popai kà Pwi Ukai, Pwi Ukai Pwiduée na é patùra Pwi Ukai kôo: “Gà me ma gà tâa ni. Tâa ni gòro îô étò. Go naa tâgà ê pitûâ. O pwamainagà awé. Go nama gà còogai tèpa ipaa dàgà.” Psaume 110.1 ");
INSERT INTO priNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","«Ba ûna é ina pâ, Pwi Ukai kôo, âna é tàgére ina wà pwi Mesia. Â é paari pâ, wà pwi Mesia, âna pwi âboro na é piwéna jii diri pàra tàpé!» ");
INSERT INTO priNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Wâru pâ âboro na rà gére tàmaari ê pwina é ina wà Iésu. Â, na ararà diri, â é ina tà tèpa *câmu kêe pâ: ");
INSERT INTO priNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","«Guwà pwacôoco! Guwà cibwaa pwaduwà kà pàra tèpa dotée goro ê Naèà! Ba dau wâdé tàra, na rà pâra na ê pâ ârabwée gòri. Â wâdé tàra, na rà nye pwabwàcu tàra, ma pwamainarà pâ âboro, naa na diri ê pâ ére aupitapitiri. Â rà nye mudàra taaci ê pâ autâa na tâa béaa, na *wâra pitapitiri, ma naa na pâ na aupi-ija maina. ");
INSERT INTO priNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Â rà pwa ê pâ nyakâra pwapwicîri ba na jè o niimiri pâ rà tèpa âboro na rà wâdé. Êco na, ûna rà gére wàrapwiri, â rà popa diri jii ê pa dàpwà ê pâ muru na tà tàra. Â gée goro kaa pwiri, âna o mwa pwa tàra ê wârimuru na dau maina jii ê wârimuru kà pàra tàpé.» ");
INSERT INTO priNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","É tâa na *Wâra pwapwicîri wà Iésu. Â é gére côo tèpa âboro na dau pwa neemururà na rà tòpò mwani târa Wâra pwapwicîri. ");
INSERT INTO priNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Â é tèepaa me tô jè dàpwà, na piticè neemuruê. Â é naa ji du ârailu nari mwani atü. ");
INSERT INTO priNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Â é ina wà Iésu tà tèpa *câmu kêe pâ: «Go ina tàwà ê âjupâra pâ: Wà tô dàpwà bèeni na piticè neemuruê, âna po dau wéna awé ê pwina é tòpò, jii pàra tàpé. ");
INSERT INTO priNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Ba rà tòpò upûuê (ba ji ére mwani gée goro aumaina goo wârirà). Â, na wàé, âna jèe nye piticè neemuruê kaa. Êco na é nye naa kaa diri ê mwani na o pâri ma é wâro goo.» ");
INSERT INTO priNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Gée na càùé, â rà picâdiri i Wâra pwapwicîri wà pàra tèpa âboro, pâ: «Nye dau wâdé kaa ê pâ atü goro ê auba, goo ê pé wâ bèeni! Po dau pwa kaamwa kêe. Â dau muugère pâ cûuê na rà naa tèpa âboro, ba na uràpâra tà Pwiduée!» ");
INSERT INTO priNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Â é ina tàra wà Iésu pâ: «Guwà côo diri pâ pwiibà? Âna go ina tàwà pâ: O mwa tèepaa ê tòotù na o téura diri. Â o mwa ticè atü na o mwa pitâagòrà too wê.» ");
INSERT INTO priNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Rà tawèeri Iésu wà tèpa câmu kêe pâ: «Ico pwi a pwa pupûra, gà ina tâbà pâ o wiidà cèna o tèepaa ê pwina gà gére ina. Â o dà cè câmu kêe ma bà o tâmogòori pâ, o jèe tèepaa me ê pwi pàara-bà?» ");
INSERT INTO priNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Â é ina tàra pâ: «Guwà ipwacôowà, â guwà cibwaa pwa ma ipa-imwüruwà. Ba o wâru tàpé na rà o tèepaa me, â rà o pa ê neeô. Â rà o ina tàwà pâ: “Wâgo pwi Mesia na go me gée jaa Pwiduée, na guwà tapacîê!” â “Jèe wâni ê pàara kôo.” Êco na guwà cibwaa pâra wiârà! ");
INSERT INTO priNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Wiàna guwà têre jèkutâ goro pâ paa, ma pâ pai èpà wèe ê gòropuu, â guwà cibwaa nama wâgotàwà! Ba o nye mara tèepaa ê pâ pwiibà, êco na o càcaa pâji pwâadàra gòropuu.» ");
INSERT INTO priNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Â é ina mwara wà Iésu pâ: «Na pwi pàara-bà, â o wâru pâ ipaa pitiri gòropuu: Ba ê pwi jè Ba, âna ru ipaa ma pwi jè Ba. Â wà pwi jè ukai, âna ru pipaa ma cè pwi jè ukai. ");
INSERT INTO priNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Â o gù napuu, na pâ pàra ére gòropuu, â o pâ nau tèepaa ê pâ copwa na maina, ma pâ pwécapa. Â o wâru pâ muru na jè pwùkùru goo, â o wâru pâ câmu kêe, naanidò napwéretòotù.» ");
INSERT INTO priNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","«Béaa kâra diri pâ pwiibà, âna o dau tubaèpà tàwà, wâguwà tèpa câmu kôo. Ba rà o tâjùruwà, â rà o mwa popawà pâ, naa na pâ *wâra pitapitiri, ma naa na pâ wâra karapuu. Â rà o dàtiwà na ara tèpa kupénoo, ma wà tèpa ukai, gée goro na guwà tèpa âboro kôo. ");
INSERT INTO priNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Â, na pwi pàara-bà, âna o naa tàwà, ba na guwà o tèpa *paâjupâraô, na ararà. ");
INSERT INTO priNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Â guwà cibwaa dau nünüma ma pidumapiê goro pai tòpi kàwà tàra. ");
INSERT INTO priNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Ba go o mwa naa tàwà ê pâ popai na guwà o ina, bau ê autâmogòorimuru. Â o càcaa pâri ma rà tòpi tàwà wà tèpa pièpàriwà! ");
INSERT INTO priNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","«Rà o icuriwà wà du nyaa ma caa kàwà, ma wà tèpa aéjii kàwà, ma wà tèpa jènerewà, ma wà tèpa béewà, tiagoro na o tétàmwara pàra tàpé gée goowà. ");
INSERT INTO priNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Â rà o pièpàriwà gooò diri ê pâ âboro. ");
INSERT INTO priNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","19","Êco na wà pwina é cimwü, âna ée mwa udò, â o tà têe ê *âji wâro. Â o nye ticè na rà pwa, na o tigée goro ê wâro bèepwiri na wâgoowà.» ");
INSERT INTO priNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","«Na guwà côo pâ pwâra paa na rà cibèepi *Iérusaléma, â wàé kaa pwiri na guwà o tâmogòori pâ o jèe tédidiri i auba. ");
INSERT INTO priNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Wà tàpé na rà wâgòroigé jii i ville, âna rà cibwaa tò naa na! Â wà tàpé na rà tâa na i ville, âna rà uru wài! Üu, wâdé na rà cau uru wài naa gò pâ jaa, wà diri tàpé na rà tâa napô *Judée! ");
INSERT INTO priNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","23","Au! Wârico! Ba, naa na pâ tòotù bèepwiri, âna po dau pwaée kâra pa ilàri na rà nyarana, ma pa ilàri na rà pa-di ê èpo kàra. Ba wàépwiri ê pàara na wà Pwiduée, âna ée mwa naa wârimuru târa ê Ba kêe, wà tèpa *Juif. Êkaa na wàrapwiri cè pai pacoo diri pâ popai kà tèpa *péroféta wâna *Tii Pwicîri. «Â o po dau maina ê pwâra putàmu kêe, â rà o dau pwamaagé côo tèpa âboro wê, na pwi pàara-bà. ");
INSERT INTO priNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Â o dau wâru tàpé na o tétàmwararà goro ê tàuwa. Â o wâru mwara tàpé na o piirà ma poparà pâ, naa na pâ napô na wâru, ba na rà tèpa *ênawéna kîri kà tèpa âboro wê. Ba ê pwi pàara bèepwiri, âna o pàara kà tàpé na càra caa tèpa Juif. Â rà o pwatari diri Iérusaléma. Â rà o mwa còogai ê napuu kêe bau ê Ba kêe, tiagoro ê tòotù na ée mwa pacoo pwiri wà Pwiduée.» ");
INSERT INTO priNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","26","«Gée na càùru pwiri â o pwa pâ câmu na ité naa na i tòotù, ma ê parui, ma ê pâ îricò. Ba o gùmagù ê pàara napwéretòotù. Â o nye ité mwara i nawià, â o pwa pâ diopwaa kâra pàri wià, â o dau maina airà. Â wà tèpa âboro gòropuu, âna rà o pò goo diri pwiri, â o dau wâgotàra, â rà o pwùkùru. Ba rà o côo pâ, o jèe tèepaa ê pàara na po dau èpà awé naa gòropuu. ");
INSERT INTO priNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Â nabwé, â rà o mwa bàra côoô, wâgo *Pwina naîri âboro, wiàna go tèepaa me na nee, naa na ê pàtàmoo, ma ê pai maina ma muugère kôo. ");
INSERT INTO priNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Êkaa na go ina tàwà pâ: Wiàna guwà côo pâ, jèe tapoo coo ê pâ muru bèepwiri, â guwà gòo ma ipwàdée! Ba o jèe càcaa gòiri ê tòotù, â ée mwa pa-udòwà wà Pwiduée!» ");
INSERT INTO priNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Wà Iésu, âna é patùrarà mwara goro ê pwina o tèepaa. Â é ina tàra ê ucina bèeni pâ: «Guwà côo ê *iri wâi, é, pwi jè upwâra. ");
INSERT INTO priNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Ba, na é tapoo ti, â guwà tâmogòori pâ, ée jèe tèepaa me ê pàara na ucuu i napô. ");
INSERT INTO priNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Wàrapwiri na guwà côo pâ, gére tèepaa ê pâ pwi bèepwiri, na ia go ina, â guwà o tâmogòori pâ, ée jèe tapoo tòpò ê Mwaciri kêe wà Pwiduée. ");
INSERT INTO priNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Â go ina tàwà ê âjupâra pâ: O càcaa gòiri. Ba wà pàra tèpa âboro nabà, âna rà o bwaa nye côo pwiri, béaa kâra pai o bà kàra. ");
INSERT INTO priNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Ba o tiàu ê napwéretòotù ma ê gòropuu; â napwa ê popai kôo, âna o càcaa tiàu.» ");
INSERT INTO priNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","«Guwà ipwacôoco! Guwà cibwaa wârori ê wâro imudi; guwà cibwaa dau wâdo ma ija! Â guwà cibwaa géaa goo ê pâ muru na o tubatiàuwà naa goo naani gòropuu. Ba wiàna guwà tà èrà goo pâ muru bèepwiri, â péa guwà mwa tà pò, ma piticè càrawà, na go tèepaa me côwâ, ");
INSERT INTO priNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","pwacèwii diri pàra âboro gòropuu. Ba go o mwa cau papòrà diri, pwacèwii pwi a pwa puà, na é tü puà kêe naa gòro ê pu ârawéà. ");
INSERT INTO priNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Êkaa na guwà tà tàcî! Â wâdé na guwà pwapwicîri tà Pwiduée, ma ilari jiié pâ, na é wéaariwà jii diri pâ muru na èpà na o mwa tèepaa. Â go o mwa ipwàdée goowà wâgo Pwina naîri âboro, na guwà cima arao. Nabwé!» ");
INSERT INTO priNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","38","Na pàara na é tâa Iérusaléma na wà Iésu â é tò naa na Wâra pwapwicîri na diri pâ tòotù, ba na é pacâmuri tèpa âboro. Ba mu ipitirirà naawê, naa diri pâ dàuru, ba na rà têreê. Â, na bàrane, â é mu wâjué côwâ naa gòrojaa Élaio, â é tâa wê naa ne. ");
INSERT INTO priNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Jèe pâmwünyabweri ê *tòotù maina kà tèpa *Juif, na ina goo pâ tòotù Paséka—pwi tòotù na rà ija poloa na ticè nyaa kêe. ");
INSERT INTO priNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Â wà tèpa caa kà tèpa pwa *ârapwaailò, ma wà tèpa *dotée goro ê Naèà, âna rà imudàra cè pai pwa wèe, ba na rà tétàmwara wà Iésu. Êco na wâgotàra goo wà tèpa âboro. Ba dau wâru tàpé na rà wâgoo Iésu. ");
INSERT INTO priNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Â, na pwi pàara bèepwiri, âna wà *Caatana, âna é nye too kaa naa goo wà Judas Iscariote, wà pwi jè ârapàara tèpa 12 *apostolo kà Iésu. ");
INSERT INTO priNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Â é pâra wà Judas, nau côo tèpa caa kà tèpa pwa ârapwaailò, ma wà tèpa caa kà tèpa wéaari ê *Wâra pwapwicîri. Â é ina tàra pâ, na ée mwa panuâ Iésu tàra. ");
INSERT INTO priNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Â rà nye dau ipwàdée kaa, â rà ina têe pâ, na rà o mwa naa cè mwani têe. ");
INSERT INTO priNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Â gée na càùé, âna é imudàra cè naigé, ba na é icuri pwàniri tàra wà Iésu. ");
INSERT INTO priNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","É jèe tèepaa ê bétapoo tòotù kâra ‘pi-ija poloa na ticè nyaa kêe’—tòotù na rà mu taa ê nari mutô târa Paséka. ");
INSERT INTO priNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Â wà Iésu, âna é panuâ pâ naa *Iérusaléma wà Pétéru ma Ioane, â é ina tàru pâ: «Gàu pâra béaa naa na ville, â gàu pwabwàti ê utimuru kâjè, târa ê tòotù Paséka.» ");
INSERT INTO priNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Â ru tawèerié pâ: «Wâpà na nümagà na jè pi-ija wê?» ");
INSERT INTO priNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Â é tòpi tàru pâ: «Na gàu tò naa na ville, â o ipitiwà ma pwi âboro, na é popa ê wâra jawé. Â gàu pâra wiâê. Â, na é tò naa na jè pwârawâ, ");
INSERT INTO priNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","â gàu ina tà pwi apooro wê pâ: “É tawèeri me wà pwi a pwa pupûra kâbà pâ, o wâpà ê naditàrawâ, na bà o ija naima ê utimuru târa Paséka?” ");
INSERT INTO priNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","«Â ée paari tàu ê jè naditàrawâ na wâdòiti—pwi naditàrawâ maina na jèe ipwabwàti. Â gàu pwabwàti i uti kâjè naawê.» ");
INSERT INTO priNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Â nabwé, â ru pâra wà Ioane ma Pétéru, â ru pâmari wàra na é ina tàru wà Iésu. Â ru pwabwàti ê utimuru târa Paséka. ");
INSERT INTO priNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Na bàrane, ûna jèe tèepaa ê pàara na rà pi-ija na, â rà tâa goro taapà wà Iésu ma i tèpa 12 apostolo kêe. ");
INSERT INTO priNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Â é ina tàra pâ: «Jèe gòiri na go tapacîri ê ji pwi pàara bèeni, na jè pi-ija naima ê utimuru târa Paséka, béaa kâra pai picâri kôo. ");
INSERT INTO priNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Ba go ina tàwà pâ: O câgo mwa caa ija ê utimuru bèeni ma wâguwà, naani gòropuu. Go o mwa ija côwâ na go o mwa bàra tubanabwé ê wakè kâra âji Paséka na pàara na é tòpò Mwaciri kêe wà Pwiduée.» ");
INSERT INTO priNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Â é popa ê wârado dipâa. Â é pwaolé tà Pwiduée, â é ina tàra pâ: «Guwà popa, â guwà cau wâdo jècaa. ");
INSERT INTO priNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Ba go ina tàwà ê âjupâra pâ: O câgo mwa caa wâdo cè dipâa naani gòropuu. Go o mwa wâdo ê dipâa na bwaa âmuê, naa na pàara na é tòpò Mwaciri kêe wà Pwiduée.» ");
INSERT INTO priNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Â é popa ê poloa, â é pwaolé tà Pwiduée. Â é tubiti, â é naa tàra, â é ina tàra pâ: «Êni, âna naiio, na go panuâ ba kàwà. Â, na wàrapwiri, â guwà o mwa nye tà pitaniimiri ê pwina go pwa tàwà.» ");
INSERT INTO priNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Gée na càùru ê pi-ija, â é pa i wârado dipâa, â é ina tàra mwara pâ: «Êni, âna *câmu kâra *auipwataâboro na bwaa âmuê, na é pwa wà Pwiduée goro ê domii kôo na o jèe joro. Ba o wàrapwiri pai tòpò pinaanapô naa nabibiu kàwà ma wàé.» ");
INSERT INTO priNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","22","É ina tàra mwara pâ: «Wâdé na go bà, wâgo *Pwina naîri âboro, ba na pacoo ê auniimiri kà Pwiduée gée na biu. Êco na, napwa naa goo wà pwi âboro na é pi-icurio, âna po dau pwaée kêe. Â guwà côo, co tèpa béeò, é tâa jaajè ni, wà i pwi âboro bèepwiri, ba jè gére ija ma wàé.» ");
INSERT INTO priNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Â wà tèpa câmu kêe, âna rà pò goo pâ popai bèepwiri, â rà pitànunuu, â rà pitawèerirà pâ: «Wàilàapà na o pwa pwiri?» ");
INSERT INTO priNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Rà tapoo pitòocia wà tèpa câmu. Ba rà imudàra cè pwi âboro na é imaina naa jaarà. ");
INSERT INTO priNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Â é ina tàra wà Iésu pâ: «Guwà côo, naa jaa wà tàpé na càra caa tèpa âboro kà Pwiduée, âna wà tèpa ukai ma wà tèpa pitûâ, âna rà còogai tèpa âboro. Â nümarà na jè tà pwamainarà ma pwaolé tàra taaci. ");
INSERT INTO priNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Â wâguwà, âna guwà cibwaa pwacèwiirà! Ba wà pwi âboro imaina nabibiu kàwà, âna wâdé na é pwacèwii pwi nari èpo. Â wà pwi a pitûâ, âna wâdé na é pwacèwii pwi ênawéna. ");
INSERT INTO priNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","«Ba naa jaa tèpa âboro gòropuu, âna wà pwi ukai, âna é tâa goro taapà; â wà tèpa ênawéna kêe, âna rà naa èe. Â guwà côo, nye càcaa wàrapwiri naa nabibiu kâjè. Ba go jèe pâ nau pwi ênawéna kàwà. ");
INSERT INTO priNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","«Â wâguwà, na guwà tâa jaao na go tâa na aré ma tòina, ");
INSERT INTO priNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","âna go mwa naa tàwà ê autâa na ê Mwaciri, na é jèe naa tôo wà Caa kôo. ");
INSERT INTO priNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Â jè o mwa pi-ija naima ma wâgo. Â guwà o mwa tâaboo naa gòro autâa kà tèpa ukai, ba guwà o pitûâ kà tèpa 12 wâao *Isaraéla.» ");
INSERT INTO priNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Wà Iésu, âna é tabiié naa goo Simona Pétéru, â é ina pâ: «Têre! Wà Caatana, âna é ilari pâ, na é jèpa tacaiwà. Â ée mwa nama gùmagù ê pwâranümawà, naa na jè ji pàara. ");
INSERT INTO priNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Â ée mwa dau tacaigà co Simona, pwi âji béeò! Au, meaarigà! Ba gà o mwa tûu. Êco na go jèe pwapwicîri ba kâgà, ba na gà mwa cimadò côwâ. Â wiàna gà o mwa wâjué me côwâ dario, â pâragà, na gà pagòo tèpa aéjii'gà bèeni.» ");
INSERT INTO priNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Â é tòpi têe wà Pétéru pâ: «Bwa! Bwa, co Pwi Ukai! Nye pâriô mwara ma go picâri pwacèwiigà, wiàna naa na karapuu, é ju capai bà!» ");
INSERT INTO priNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Â é ina têe wà Iésu pâ: «Bwa, go ina tâgà ê âjupâra, co pwini, pâ: Naa na ne nabà, âna béaa kâra cè pai to kâra i ja, âna gà o wacié pitütôowâri pâ, câgà caa tâmogòorio.» ");
INSERT INTO priNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","É ina mwara wà Iésu tà tèpa câmu kêe pâ: «Na ia, âna go cùruwà ba na guwà Picémara ê *Picémara Wâdé âna ticè mwani, ma atà, ma wâraâwà na guwà popa wiâwà. Â wànau, gona nye tiàu jiiwà cè muru?» Â rà tòpi têe pâ: «Bwa.» ");
INSERT INTO priNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Â é ina tàra pâ: «Êco na nabàni, âna go ina tàwà pâ, wâdé na guwà popa cè mwani ma atà kàwà! Â wiàna ticè tàuwa kàwà, â wâdé na guwà icuri ârabwée kàwà, ba na o wâri wèe. ");
INSERT INTO priNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Ba rà o jèe tubaèpà tôo pwacèwii na go pwi âboro èpà. Ba pwa jè popai gooò, na wii naa na *Tii Pwicîri, pâ: Rà naa wârimuru têe; ba rà ina pâ, é pwi a pwa na èpà. Â o jèe nye coo ê popai bèepwiri.» ");
INSERT INTO priNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Â rà ina têe wà tèpa câmu kêe pâ: «Wàéni ê du ârailu tàuwa, co Pwi Ukai!» Â é tòpi tàra pâ: «Jèe pâri!» ");
INSERT INTO priNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Rà còobé gée na wâ wà Iésu ma wà tèpa câmu kêe, â rà pâra naa gòrojaa Élaio. Ba mu nye câmaajé tàra na rà puu wê. ");
INSERT INTO priNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Ûna rà tèepaa naawê, â é ina tàra pâ: «Guwà pwapwicîri ba na o pwa cè nii ma gòo kàwà, wiàna tacaiwà.» ");
INSERT INTO priNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Â é tàpo paé jiirà, â é tùu jùrué, â é pwapwicîri tà Pwiduée. ");
INSERT INTO priNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Â é ina pâ: «Caa, wiàna nümagà, â gà patâjii jiio ê pâ aré ma tòina bèeni. Êco na gà cibwaa pwa ê pwina nümoo goo, â gà nye pwa câbawâdé'gà.» ");
INSERT INTO priNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Â é nye tèepaa kaa pwi jè *angela, me gée *napwéretòotù, â é pagòoé. ");
INSERT INTO priNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Â é nye pwapwicîri mwara wà Iésu, â jèe po dau maina ê aré ma tòina kêe. Â ê wétàu kêe, âna jèe pâra nau domii, â joro naa napuu pwacèwii ê pwâra jawé. ");
INSERT INTO priNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Â nabwé, â é cimadò, â é wâjué me côwâ dari tèpa câmu kêe. Êco na é côo pâ rà puu. Ba dau oratàra gée goo pai pikîri kàra. ");
INSERT INTO priNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Â é ina tàra pâ: «Cina guwà puu? Guwà tà tàcî, â guwà pwapwicîri ba na o pwa cè nii ma gòo kàwà, wiàna tacaiwà.» ");
INSERT INTO priNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Ûna é bwaa gére ina pwiri wà Iésu, â é po tèepaa me wà Judas, wà i pwi jè ârapàara tèpa 12 apostolo kêe. Â rà tèepaa me wiâê pâ âboro na wâru, ba na rà tâjùru Iésu. Â é nye pâra dà Iésu kaa wà Judas, â é pwabwàcu têe, ma bwénüuê. ");
INSERT INTO priNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Â é ina têe wà Iésu pâ: «Wànau, co Judas? Gà wàrapwiri târa pai pi-icurio, wâgo Pwina naîri âboro, goro ê pai bwénüuô'gà?» ");
INSERT INTO priNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Wà tèpa câmu kà Iésu, âna rà côo pâ rà o jèe tâjùrué wà tèpa âboro. Â rà pò ma ina têe pâ: «Wâdé co Pwi Ukai, na jè piokée! Wàéni tàuwa!» ");
INSERT INTO priNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Â wà pwi jè ârapàararà, âna é nye tüboo kaa ê tàuwa kêe naa gòro pûru pwi âboro kîri kà pwi ukai kà tèpa pwa ârapwaailò. Êco na é tépàgà co i doronyüruê. ");
INSERT INTO priNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Â é ina tàra wà Iésu pâ: «Bwa! Jèe pâri! Guwà cibwaa cicararà!» Â é tu naa goo i doronyüruê, â nye wâdé côwâ kaa. ");
INSERT INTO priNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Â é patùra tèpa pitûâ kà tàpé na rà me nau tâjùrué—tèpa caa kà tèpa pwa ârapwaailò, ma wà tèpa caa kà tèpa wéaari ê Wâra pwapwicîri. Â é ina tàra pâ: «Wànau? Guwà me nau popao, goro ê pâ tàuwa, ma ê bàra upwâra, pwacèwii na go pwi a pòtàmwara âboro! ");
INSERT INTO priNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Diri ê pâ tòotù, âna go tâa nabibiu kàwà, naa na Wâra pwapwicîri, êco na câguwà caa tâjùruo! Bwa, wâdé na wàrapwiri. Ba ni, âna jèe pàara kàwà—pàara na é pitûâ ê pàtàmara ê bàutê.» ");
INSERT INTO priNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Â rà tâjùru Iésu. Rà popa pâ Iésu naa pwârawâ kà pwi *ukai kà tèpa pwa ârapwaailò. Napwa wà Pétéru, âna é picâwiâê gée iti. ");
INSERT INTO priNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Â é pâmari pàra tèpa wéaa, naa na gòroigé kâra pwârawâ. Ba rà pwa ê pé na ânye, â rà pwacârau. Â é coo burà pwacârau jaarà wà Pétéru. ");
INSERT INTO priNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Â wà tô jè ênawéna, âna é côoê naa na pwéelaa kâra ânye. Â é ciburà ucâriê, â é côoinaê, â é ina tà tèpa âboro na rà tâa wê pâ: «É! Wà pwini, âna é pwi jè bée Iésu gée Nazareth!» ");
INSERT INTO priNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Êco na é pitütôowâri wà Pétéru, â é ina têe pâ: «Bwa! Câgo caa tâmogòorié, co tôoni.» ");
INSERT INTO priNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Â gée na càùru ê ji pàara bèepwiri, â wà pwi jè âboro, âna é côoinaê mwara, â é ina têe pâ: «Pwiini, gona câgà caa pwi jè bée Iésu?» Â é tòpi têe wà Pétéru, pâ: «Bwa!» ");
INSERT INTO priNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Â wâna caapwi ineretòotù, â wà pwi jè âboro, âna é nye gòo goro ina tà tèpa bée pâ: «Akaé! Âjupâra pâ é pwi jè bée! Ba wàé mwara, âna é pwi a me gée Galilée!» ");
INSERT INTO priNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Â é tòpi têe wà Pétéru pâ: «Kaa! Gà têre, co pwini! Câgo caa tâmogòori ê pwina nümagà na gà ina!» Ûna é bwaa gére ina pwiri, â é to i ja. ");
INSERT INTO priNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Â wà Pwi Ukai Iésu na rà tàgére pitèié naa na jè ére gòroigé âna é nye tabiié kaa, â é ucâri wà Pétéru. Â é nye niimiri kaa wà Pétéru i pwi ia é ina têe wà Iésu pâ: «Béaa kâra ê pai to kâra i ja, âna gà o wacié pitütôowâri pâ, câgà caa tâmogòorio.» ");
INSERT INTO priNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Â é còobé naa gòroigé wà Pétéru, â é dau i pijinünü. ");
INSERT INTO priNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Wà tèpa âboro na rà wéaari Iésu, âna rà pitaurèe gooé, â rà èié. ");
INSERT INTO priNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Â rà târamiri ê naporomee, â ûna rà tòbitié, â rà ina têe pâ: «Wàilàapà na èigà? Gà pinadàra cai, wiàna gà pwi *péroféta na gà tâmogòori diri ê muru!» ");
INSERT INTO priNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Â rà dau tànyiriê, ma ina têe pâ muru na po dau èpà. ");
INSERT INTO priNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Ûna po dàuru moo, â rà pitapitirirà naima diri ê wâra pitûâ kà tèpa Juif—wà tèpa caa kà tèpa pwa ârapwaailò, ma wà tèpa pitûâ, ma tèpa dotée goro ê Naèà. Â rà ina tà tèpa wéaa pâ, na rà popa me Iésu na ararà. ");
INSERT INTO priNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Â rà ina têe pâ: «Wiàna wâgà wà pwi *Mesia, â gà ina tâbà!» Â é tòpi tàra wà Iésu pâ: «Wiàna go ina tàwà ê âjupâra, â o câguwà caa cèikî naa gooò. ");
INSERT INTO priNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","«Â wiàna go tawèeriwà goro cè jè muru, â o câguwà caa tòpi tôo. ");
INSERT INTO priNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Êco na o jèe tèepaa ê pàara, na wà Pwina naîri âboro, âna ée mwa tâa gòro étò kà Pwiduée na dau pwa pàtàmee, â ée mwa pitûâ.» ");
INSERT INTO priNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Ûna rà têre pwiri, â rà nye dau putàmu kaa â rà ina pâ: «Ico pwini! Gona gà ina pâ wâgà, âna gà *Pwina naî Pwiduée?» Â é tòpi tàra wà Iésu pâ: «Guwà jèe nye tàgére ina!» ");
INSERT INTO priNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Â rà pi-ina pâ: «Jèe pâri! Guwà nye têre ê pwina é ina. Naaco cè tèpa pitòtié, ba é jèe ipitòtié côwâ!» ");
INSERT INTO priNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Rà cau cimadò diri tèpa *wâratûâ kà tèpa Juif, â rà cia Iésu dari wà *Pilato, pwi kupénoo kà tèpa Roma. ");
INSERT INTO priNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Â rà pitòti Iésu, ma ina pâ: «Wà pwi âboro bèeni, âna é pitoo naa na pûru ê Ba kâbà tèpa Juif ba na rà cicara César, pwi ukai. Ba é ticia jiirà, na rà wâri mwani wâripû têe, â é ina pâ wàé pwi *Mesia, pwi jè ukai maina.» ");
INSERT INTO priNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Â é tawèeri Iésu wà Pilato pâ: «Gona nye wâgà kaa, na gà Pwi Ukai kà tèpa Juif?» É tòpi têe wà Iésu pâ: «Gà jèe nye tàgére ina.» ");
INSERT INTO priNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","É tabiié wà Pilato naa goo tèpa caa kà tèpa pwa *ârapwaailò, ma wà pàra tèpa âboro na rà tâa wê. Â é ina tàra pâ: «Câgo caa pâmari cè majoro wârimuru kêe.» ");
INSERT INTO priNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Êco na rà ina ba gòo têe pâ: «Bwa! Gà côo, é nama gùmagù napô pitiri, goro ê pai pwa pupûra kêe—tapoo na Galilée, tia ni *Iérusaléma!» ");
INSERT INTO priNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Â é ina tàra wà Pilato pâ: «Wànau? Guwà ina pâ, é pwi âboro gée Galilée?» ");
INSERT INTO priNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Ûna rà tòpi têe pâ «Üu», â é panuâ pâ Iésu naa jaa *Héroda Antipas. Ba wàé na é pwi kupénoo na Galilée. Â, na pwi pàara-bà, âna é tàgére tâa Iérusaléma. ");
INSERT INTO priNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","É nye dau ipwàdée kaa wà Héroda na é côo Iésu, ba jèe nye dau gòiri pai têre kêe ê jèkutâ gooé. Â nye dau nümee na é côo cè jè *câmu kâra pàtàmee cèna é pwa. ");
INSERT INTO priNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Â é tawèerié mwara goro pâ muru na wâru. Êco na câé caa tòpi têe wà Iésu. ");
INSERT INTO priNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Â naa na diri ê pàara na ru gére wàrapwiri, â wà tèpa caa kà tèpa pwa ârapwaailò ma wà tèpa *dotée goro ê Naèà, âna rà tàgére tâa wê, â rà dau tùra too ma pitòtié. ");
INSERT INTO priNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Jèe pâ nau ora tà Héroda gooé â rà tànyiriê ma piècaarié, wàé ma wà tèpa coda kêe. Â rà pwa ma é coona ê pé ârabwée kâra ukai. Â rà panuâê côwâ pâdari Pilato. ");
INSERT INTO priNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Tapoo na pwi tòotù-bà, âna ru pitêreru wà Héroda ma Pilato. Ba béaa, âna nye tupédu a pièpà. ");
INSERT INTO priNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Wà Pilato, âna é panaimari ê napô, bau tèpa pitûâ kàra, ma tèpa caa kà tèpa pwa ârapwaailò. ");
INSERT INTO priNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Â é ina tàra pâ: «Guwà pame pwi âboro bèeni, na guwà gére ina pâ: “É pitoo naa na pûru tèpa âboro, ba naa gùmagù ê napô.” Â go tawèerié goo, na arawà. Êco na câgo caa pâmari cèna èpà na pâri ma pwa wârimuru têe goo. ");
INSERT INTO priNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","«Â wà ukai Héroda Antipas mwara, âna câé caa pâmari cè èpà cèna é pwa, â é panuâê côwâ me naani. Â nye ticè majoroé ma naa wârimuru têe, ma é bà. ");
INSERT INTO priNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Na wàrapwiri, â go o nye pwa ma pâdié co, â go o nye panuâê côwâ.» { ");
INSERT INTO priNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Ba pâra Pilato na é pacòobé ê pwi jè âboro gée na karapuu, na diri pâ naja, na tòotù *Paséka.} ");
INSERT INTO priNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Ûna é ina pwiri wà Pilato â rà nye cau wiikau too kaa ê pâ âboro, ma ina pâ: «Nama é bà wà pwi âboro bèepwiri! Gà panuâ wà Barabbas!» ");
INSERT INTO priNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(Wà pwini Barabbas, âna é tâa na karapuu, ba é pwi a tétàmwara âboro. Â é pwi jè ârapàara mwara tàpé na pwa na rà cicara tèpa *Roma, naa Iérusaléma.) ");
INSERT INTO priNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Wà Pilato, âna nümee na é panuâ Iésu, â pwa na é patùra tèpa âboro, ba na é pacoorà. ");
INSERT INTO priNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Êco na rà mwa nye dau uu ma tomara too kaa pâ: «Tanamiriê! Tanamiriê naa goro *kurucé!» ");
INSERT INTO priNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","É bwaa wacié tawèerirà wà Pilato pâ: «Dà cè èpà cèna é pwa pwi âboro bèeni? Na nye ticè majoroé ma é bà. Go o nye nama pâdié co, ma panuâê côwâ.» ");
INSERT INTO priNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Êco na rà mwa nye dau pwatàngürurà ma uu too ma ina pâ: «Tanamiriê!» ");
INSERT INTO priNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Â é nye niimiri bamwara wà Pilato pâ, na é pwa ê pwina nümarà goo. ");
INSERT INTO priNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Â é panuâ wà Barabbas, wà i pwi pòroca, â é panuâ wà Iésu tà tèpa coda kêe, ba na rà tétàmwereê. ");
INSERT INTO priNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Wà tèpa coda roma, âna rà popa pâ Iésu, âna é kâa i kurucé kêe. Â ipitirà ma pwi jè âboro gée na ville Cyrène, na nee Simona, na é wâjué me gée na aupwanapô. Â rà tacoo gooé, ba na é kâa pwicò i kurucé kà Iésu. ");
INSERT INTO priNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Â dau wâru pâ âboro na rà pâra wiâ Iésu. Â wà pa ilàri, âna rà imuruê ma pijinünü. ");
INSERT INTO priNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Â é tabiié Iésu naa goorà, â é ina tàra pâ: «Pa èpo gée Iérusaléma, guwà cibwaa imuruô! Guwà imuruwà côwâ, ma pâ èpo kàwà. ");
INSERT INTO priNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Ba o jèe tèepaa ê pàara na o dau gòo. Ba o mwa ina pâ: “Rà ipwàdée pa ilàri na càcaa pâri ma rà ipièrù, ma wàilà na càra caa pâji pitàmari èpo, ma wàilà na càra caa pâji pa-di èpo!” ");
INSERT INTO priNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","«Â o dau maina ê pai picâri kà tèpa âboro, tiagoro na o nümarà na tûu naa gòrà ê pâ jaa, ba na naapwànirirà jii ê pé tòina bèepwiri! ");
INSERT INTO priNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","«Ba “Wiàna rà cîri i upwâra na bwaa bwùu, â rà o mwa wànau târa ê upwâra na jèe mwari?” Ba rà tubaèpà tôo nabà, â rà o mwa tubaèpà tàwà gée na càùé.» ");
INSERT INTO priNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Â wà tèpa coda, âna rà capai popa Iésu ma wà tupédu a pwa na èpà, ma capai tanamirirà. ");
INSERT INTO priNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Rà popa Iésu pâ, tèepaa naa na ére na ina goo pâ ‘Napwiripûru âboro’. Â rà tanamiriê naa goro *kurucé. Â rà tanamiri mwara i tupédu a pwa na èpà; pwi jèpwi naa gòro étò kêe, â pwi jèpwi naa gòro aèmwü. ");
INSERT INTO priNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Â wà Iésu, âna é ina tà Pwiduée pâ: «Caa, gà pwanaurirà, ba càra caa tâmogòori ê pwina rà pwa.» Â wà tèpa coda, âna rà picàù noo kâra tii, naa goro ê ârabwée kêe. ");
INSERT INTO priNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Wâru pâ âboro na rà coo wê, â rà gére ucâri diri ê pwina tèepaa. Â wà tèpa pitûâ kà tèpa Juif, âna rà pitaurèe goo Iésu, â rà ina pâ: «É pi-ina gooé pâ é pwi Mesia, *pwi a pa-udò na é cùrué me wà Pwiduée! Â é tâmogòori ma é pa-udò pàra tàpé, êco na câé caa tâmogòori ma é ipa-udòé côwâ!» ");
INSERT INTO priNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","37","Wà tèpa coda, âna rà pitaurèe mwara gooé. Ba rà nye tà pame darié dipâa na maga, â rà nye tà ina têe pâ: «É! Pwiini, wiàna gà pwi ukai kà tèpa Juif, â gà nye ipa-udògà côwâ!» ");
INSERT INTO priNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Â rà ténamiri dòiti kâra pûruê jè ére upwâra na wii naa goo ê aupwa tii na ina pâ: iésu, pwi ukai kà tèpa juif. ");
INSERT INTO priNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Â wà i pwi jè bâadi na ia tanamiriê naa goro jè jènere Iésu, âna é dau tànyiriê, â é ina têe pâ: «A! Wànau co pwini? Gà ina pâ, wâgà pé pwi Mesia. Â gà upagà ni, â gà cau upajè naima!» ");
INSERT INTO priNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Êco na é tòpi têe wà pwi bée, na ia é tâa goro jè jènere Iésu, ma ina têe pâ: «Pwiibà, gorodà na càcaa wâgotâgà goo Pwiduée, wâgà na gà o jèe tàpo bà, â gà o mwa coo araé? ");
INSERT INTO priNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Gà côo, nye *tàrù ê pai pwa wârimuru kâju, ba ju dau tupédu a pwa na èpà. Â napwa wàé, âna nye ticè èpà na é pwa!» ");
INSERT INTO priNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Â é ina tà Iésu pâ: «Au, Iésu, gà nyi niimiriô, wiàna gà mwa tâa na ê Mwaciri'gà.» ");
INSERT INTO priNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Â é tòpi têe wà Iésu pâ: «Go ina tâgà ê âjupâra pâ: Nabàni, âna gà o tâa jaao, naa napô kôo na tâa wê pinaanapô.» ");
INSERT INTO priNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","45","Ûna po gopaé bwàti, â câé mwa caa té i tòotù, â nye po bàutê pitiri ê napô tiagoro na âracié ineretòotù na càùru ija. Â ê pé ciità maina, na é târiwâri ê ére na dau pwicîri naa na i *Wâra pwapwicîri, âna nye tidàpa kaa. ");
INSERT INTO priNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Â é tomara ba maina wà Iésu pâ: Caa, go panuâ tâgà côwâ ê nyuâaô! Â nye êgò kaa ôomaa kêe. ");
INSERT INTO priNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Ûna é côo pai bà kêe, wà pwi caa kâra coda roma, â é pwamaina Pwiduée, â é ina pâ: «Nye âjupâra pâ, wà pwi âboro bèeni, âna nye ticè èpà na é pwa!» ");
INSERT INTO priNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Â wà diri tèpa âboro na ia rà tâa wê, âna rà wâjué côwâ naa jaarà, â dau tòina pwâranümarà. ");
INSERT INTO priNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Napwa naa goo wà tèpa bée Iésu, ma wà mwara pa ilàri na ia rà pâra wiâê gée Galilée, âna rà tà coo iti ma côo pwiri. ");
INSERT INTO priNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Pwa pwi jè âboro na nee Ioséfa, pwi âboro gée Arimathée wâ napô *Judée. É pwi âboro na é pitòimiriê, ma ê pwi âboro na é *tàrù na ara Pwiduée. Â é pwi a nye tà gòo goro tapacîri ê pai tèepaa me kâra ê *Mwaciri kà Pwiduée. Â é pwi jè a tâa na wâratûâ kà tèpa Juif, êco na dau càcaa wâdé têe ê pwina rà pwa tà Iésu wà tèpa wâratûâ bée. ");
INSERT INTO priNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Â wà pwiibà, âna é pâra naa jaa ukai Pilato, â é ilari jiié i naii Iésu, â é naa tàrù têe wà Pilato. ");
INSERT INTO priNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Â é tapwùtù i naii Iésu gée gòro i *kurucé. Â é târamiri goro imwaano na gòri. Â é popaé, â é tòpòé naa na ê auipwàni na bwaa âmuê, pé pwêe na îri naa na pé atü, na bwaa nye ticè âboro bà na tòpòé naa na. ");
INSERT INTO priNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Diri ê pâ namuru bèepwiri, âna pacoo na papwicî, tòotù béaa kâra ê *tòotù pwicîri kà tèpa Juif. (Na papwicî, âna rà pwabwàti ê pi-ija târa tòotù pwicîri.) ");
INSERT INTO priNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Ûna é gére popa i naii Iésu gée goro kurucé wà Ioséfa, â wà i pa ilàri gée Galilée, âna rà côoê, â rà pâra wiâê. Â rà côo i auipwàni, na tòpò Iésu naawê. ");
INSERT INTO priNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Â nabwé, â rà wâjué côwâ naa pwârawâ, â rà pwabwàti ê pâ wâi ma jawé ûrea, ba na rà wicèpwiri naa gòro ê naii Iésu. Êco na, ûna bàrane, â rà tàpo coo, ba jèe tapoo i tòotù pwicîri. Â pwicîri na rà wakè na pwi tòotù-bà. ");
INSERT INTO priNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Na pwapwicîri, na dàuru kâra *tòotù pwicîri kàra na bwaa gòropwaa, â rà pâra naa na auipwàni wà i pa ilàri. Â rà popa pâ i jawé ûrea na ia rà pwabwàti. ");
INSERT INTO priNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Â rà côo i atü, bécamoori i pwêe, âna jèe pwùru tâjii. ");
INSERT INTO priNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","4","Â rà tò, â rà dau pò, ba càra caa pâmari i naii Iésu. Na rà gére pitawèerirà goro ê pwina gére tèepaa, â ru nye piâpàparirà kaa tupédu âboro, na ru coona ê ârabwée na dau pwaa, ma pwâra. ");
INSERT INTO priNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Â rà cigòboo i pa ilàri, ba po dau wâgotàra. Êco na ru ina tàra pâ: «Gorodà na guwà mudàra nacârü, pwi âboro na é jèe wâro côwâ? ");
INSERT INTO priNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Jèe tiàu Iésu ni! Ba é jèe wâro côwâ gée na aubà! Gona câguwà caa niimiri i pwi ia é ina tàwà, na guwà bwaa tâa ma wàé na Galilée? ");
INSERT INTO priNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Ba ia é ina pâ, o mwa panuâê tà tèpa âboro èpà, wàé *Pwina naîri âboro. Â rà o mwa tanamiriê naa goro *kurucé. Â, naa na béâracié kâra tòotù gée na càùé, âna ée mwa wâro côwâ gée na aubà.» ");
INSERT INTO priNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Â wà i pa ilàri, âna rà nye niimiri kaa pâ, ia é jèe nye ina pwiri tàra wà Iésu. ");
INSERT INTO priNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Â rà nye itàa kaa gée na auipwàni, ba na rà piwiâ tà tèpa *câmu kêe, ma êdiri pàra tèpa âboro ê pwina tèepaa marirà. ");
INSERT INTO priNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Napwa naa goo wà pa ilàri bèepwiri, âna wà Maria gée Magdala, ma Jeanne, ma Maria tô nyaa kà Jacques, ma wà pàra ilàri mwara. Â rà pwa jèkutâ tà tèpa *apostolo. ");
INSERT INTO priNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Êco na càra caa cèikî naa goorà, ba rà niimiri pâ rà piwâmirà. ");
INSERT INTO priNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Êco na wà Pétéru, âna é cimadò, â é itàa naa na auipwàni, ba na é côo. Â câé caa tò â é nye po cùué boo co, â é niâ dò naadò wâ, â é pò na é côo ê pâ imwaano co na gére tâaboo naani napuu. Â é wâjué côwâ naa pwârawâ, â é dau pinünüma naa goro ê pwina gére tèepaa. ");
INSERT INTO priNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Na tòotù bèepwiri, âna ru pâra wà tupédu ârailu bée Iésu, naa Emmaüs, pwi village, wâpâ na 11 kilomètres gée *Iérusaléma. ");
INSERT INTO priNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","15","Â wii naigé, âna ru gére pwa jèkutâ goro ê pâ pwina gére tèepaa. Â é pâmwünyabweriru wà pwi jè âboro, â rà picaapâra. Nye wà Iésu kaa, ");
INSERT INTO priNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","êco na càru caa côoinaê. ");
INSERT INTO priNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Â é tawèeriru pâ: «Dà ê pwina gàu gére pwa jèkutâ goo, co tupéeni?» Â ru coo, na ru nye dau pikîri. ");
INSERT INTO priNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Â wà pwi jèpwi (na nee Cléopas), âna é tòpi têe pâ: «Wànau, co pwini? Gona câgà caa tâmogòori ê pwina gére tèepaa na pâ tòotù bèeni? Diri ê pâ âboro wâ Iérusaléma, âna rà nye tâmogòori, â nye wâgà co?» ");
INSERT INTO priNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Â é tòpi tàru pâ: «Gona dà?» Â ru ina têe pâ: «Ê pwina tèepaa dari Iésu gée Nazareth, pwi *péroféta na é piwéna! Ba dau pwa pàtàmara ê pwâratùra kêe, ma ê pwina é pwa. Â é dau wâdé na ara Pwiduée, â wâru tèpa âboro mwara na rà picâdirié. ");
INSERT INTO priNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Â wà tèpa pitûâ kâjè, ma tèpa caa kà tèpa pwa *ârapwaailò, âna rà tâjùrué, ma panuâê tà tèpa *Roma ba na rà pwa wârimuru têe, ma é bà. Â rà nama tanamiriê naa goro *kurucé. ");
INSERT INTO priNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Â wàibà-ni, âna bà nye po dau pikîri kaa ba bà nye tà wâari pâ, wàé kaa pwi *Mesia, na é *pwi a pa-udò ê Ba kâjè *Isaraéla. Â ni, âna jèe âracié tòotù gée na càùru pai bà kêe. ");
INSERT INTO priNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","«Â èri, âna wà pàra ilàri gée jaabà, âna rà dau papòbà kaa goro jèkutâ kàra. Ba, na bwaa po dàuru, âna rà pâra naa na auipwàni. ");
INSERT INTO priNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Â càra caa pâmari i naiié, â rà ina pâ rà côo du *angela, na ru ina tàra pâ, é jèe wâro côwâ wà Iésu! ");
INSERT INTO priNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Â wà pàra tèpa paao gée goobà, âna rà itàa pâ naa na auipwàni, ba na rà côo, â nye âjupâra pâ, tiàu naii Iésu! Nye dau ité kaa!» ");
INSERT INTO priNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","É ina tàru wà pwini pâ: «Au, meaariwà! Ba nye ticè cèna guwà tâmogòori! Po dau ipwâ ma guwà cèikî naa goro ê pâ pwi ia rà wii wà tèpa péroféta biu! ");
INSERT INTO priNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Ba rà ina pâ: Wâdé na é pwamaagé côo wà pwi Mesia naa na pai pwa wèe bèepwiri, béaa kâra pai o paari ê pai maina ma muugère kêe.» ");
INSERT INTO priNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Â, na rà gére pâra wii naigé, â é napéaati tàru wà pwini, êdiri pâ jèkutâ gooé na wii naa na *Tii Pwicîri—tapoo naa goro pâ tii kà *Moosé, tèepaa naa goro pâ tii kà tèpa péroféta. ");
INSERT INTO priNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Â nabwé, â rà tèepaa pâ naa na village na ru pâra naawê wà tupédu âboro. Â wà pwiibà, âna pwa na é pâra jiiru. ");
INSERT INTO priNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Êco na ru tacoo gooé, â ru ina têe pâ: «Bwa, gà tàpo tâa jaabu, ba jèe bàrane.» Â rà pàgà naa pwârawâ, â rà tâa wê. ");
INSERT INTO priNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Nabwé, ûna rà tâa goro taapà, â é popa ê poloa wà pwini, â é pwaolé tà Pwiduée, â é tubiti i poloa, â é ipâdi tàru. ");
INSERT INTO priNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Ûna wàrapwiri, â ru nye côoina kaa pâ wà Iésu, êco na, na ji pàara bèepwiri, âna é nye pò ma tiàué jiiru kaa. ");
INSERT INTO priNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Â ru pi-ina naa gooru pâ: «Nye dau ité kaa ê pé ipwàdée, na tâa na pwâranümaju, na ia é tàgére patùraju me wii naigé, goro ê Tii Pwicîri!» ");
INSERT INTO priNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Ru cimadò, â ru wâjué côwâ wài naa Iérusaléma, ba na ru ina tà tèpa 11 a câmu na rà gére caatâa wê, ma pàra tèpa bée Iésu. ");
INSERT INTO priNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Êco na rà mara ina tàru pâ: «Nye âjupâra kaa pâ, é jèe wâro gée na aubà wà Pwi Ukai! Ba é côoê wà Simona Pétéru!» ");
INSERT INTO priNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Â wà i tupédu âboro, âna ru piwiâ ê pwina tèepaa mariru wii naigé. Â ru ina mwara pâ: «Bu nye côoinaê kaa, na é tubiti ê poloa.» ");
INSERT INTO priNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Wà tèpa câmu kà Iésu ma wà tèpa béerà, âna rà pwa jèkutâ goro pai wâro côwâ kêe gée na aubà. Na rà bwaa gére pi-ina pwiri, â é nye coo kaa nabibiu kàra wà Iésu, â é ina tàra pâ: «Bwàcu kàwà! Cidòri nyuâawà!» ");
INSERT INTO priNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Â rà cau pò ma po dau wâgotàra, ba rà niimiri pâ pé duée. ");
INSERT INTO priNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Êco na é ina tàra wà Iésu pâ: «Cina wâgotàwà ma gùmagù pwâranümawà? Gorodà na câguwà caa cèikî pâ wâgo?» ");
INSERT INTO priNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","40","Â é paari tàra ê du îê ma i du âê, â é ina tàra pâ: «Guwà côo ê du îô, ma ê du âô. Nye wâgo kaa! Guwà côo naiio, â guwà tu naa goo! Ba ê duée, âna nye ticè naiié!» ");
INSERT INTO priNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Â rà po dau pò wà tèpa câmu kêe. Â rà ipwàdée, ba nümarà na rà cèikî êco na rà piwâ, ba càra caa pâji cèikî bwàti. Â é pwa ma tawèerirà Iésu pâ: «Nye pwa cè uti kâjè?» ");
INSERT INTO priNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Â rà naa têe jè noo kâra ârawéà na cîri, ");
INSERT INTO priNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","â é uti na ararà. ");
INSERT INTO priNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","É pwa ma ina tàra pâ: «Guwà niimiri, na jè bwaa tâa ma wâgo, â ia go ina tàwà pâ: O mwa coo diri ê pâ pwina rà wii naa gooò, wà Moosé, ma wà tèpa péroféta, ma naa na tii *Salamo.» ");
INSERT INTO priNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Â é tàpiri pai côoina kàra ma pai tâmogòori kàra ê Tii Pwicîri. ");
INSERT INTO priNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Ba é ina pâ: «Jèe wii naa na Tii Pwicîri pâ, wà pwi Mesia, âna wâdé na é pwamaagé côo, ma bà. Â naa na béâracié kâra tòotù, â ée mwa wâro côwâ gée na aubà. ");
INSERT INTO priNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","«Â go panuâwà, ba na guwà picémara târa diri ê Ba, tapoo na Iérusaléma, ê popai goro pai pinünüma. Â guwà ina tàra naa na neeô pâ: “Guwà biiwà ma pitòotéri ê wâro kàwà, â ée mwa pwanauri tàwà ê pâ èpà kàwà wà Pwiduée!” ");
INSERT INTO priNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","«Ba nye wâguwà, na guwà tèpa *paâjupâra ê pwiibà! ");
INSERT INTO priNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Êco na guwà bwaa tàpo tâa ni, na ville, tapacîri cè pai tòpi kàwà ê pàtàma Pwiduée. Ba go o mwa panuâ me tàwà ê Nyuâaê Pwicîri âraimeai na ia é ina béaa wà Caa.» ");
INSERT INTO priNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Wà Iésu, âna é popa tèpa câmu kêe, naa na jè ére na wâmwünyabweri Bétani. Â é tòpò naa gòrà ê du îê, â é *pwényunyuâarirà. ");
INSERT INTO priNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Ûna é gére wàrapwiri, â dàgòtùé too jiirà naa napwéretòotù. ");
INSERT INTO priNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Â rà dau pwamainaê. Â nabwé, â rà wâjué côwâ naa Iérusaléma, â nye dau maina kaa ê ipwàdée kàra. ");
INSERT INTO priNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Â rà gòo goro picâdiri Pwiduée taaci naa na *Wâra pwapwicîri.");
INSERT INTO priNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","É jèe nye tâa ê Popai naa na autapoo goo ê gòropuu. É tâa jaa Pwiduée. Ba nye tàgére wàé Pwiduée. ");
INSERT INTO priNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","É nye wâjaa Pwiduée naa na autapoo goo. ");
INSERT INTO priNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","É nama é pwa diri pâ namuru wà Pwiduée. Diri ê pâ muru, âna wàé na pwa. ");
INSERT INTO priNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","É wâjaaé *âji wâro, na nama rà wâro na pwéelaa pâ âboro. ");
INSERT INTO priNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Ê pwéelaa, âna é èù naa nanaara ê bàutê. Â ê bàutê, âna câé caa câtàmwereê. ");
INSERT INTO priNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Wà Pwiduée, âna é cùru me pwi jè âboro na nee Ioane. ");
INSERT INTO priNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","É pwi a *paâjupâra ê pwéelaa, ba na é pwi naigé mara ê cèikî kà tèpa âboro diri. ");
INSERT INTO priNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Càcaa wàé ê pwéelaa, â é tèepaa, ba na é *paâjupâra ê pwéelaa. ");
INSERT INTO priNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Wàépwiri ê âji pwéelaa, na é tèepaa naa gòropuu, ba na é nama pwéelaa goo tèpa âboro diri. ");
INSERT INTO priNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","É jèe nye tâa gòropuu ê Popai, â é tòpò ê gòropuu wà Pwiduée goo ê Popai. Êco na càra caa câmogòorié wà tèpa âboro gòropuu. ");
INSERT INTO priNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","É jèe tèepaa naa napô kêe naa jaa tèpa bée; â càra caa tòpié wà tèpa jènereê. ");
INSERT INTO priNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Êco na wà tàpé na rà tòpié ma cèikî naa gooé, âna é nama rà tèpa naî Pwiduée. ");
INSERT INTO priNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Wà tèpa naîê, âna càra caa tèepaa gée goro ê câbawâdé kâra âboro. Ba rà nye tèepaa gée goro ê câbawâdé kà Pwiduée. ");
INSERT INTO priNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","É pa naiiri âboro ê Popai, â é wâro nabibiu kâjè. Po tâbawêe naa gooé ê *pimeaari imudi, ma ê *âjupâra. Â bà jèe côo ê pai maina ma muugère kà Pwina naîê, na é caapwi co, na é tòpi jii Caa. ");
INSERT INTO priNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","É tomara too wà Ioane, ba na é pamogòorié tà tèpa âboro, â é ina pâ: «Wàé kaa pwiri i pwi âboro na ia go jèe picémaraê tàwà, na ia go ina pâ, é bwaa pwicò kôo wà pwi âboro na dau pwamuru naa gooé jiio, ba é jèe nye wâro béaario.» ");
INSERT INTO priNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Jè pitòpi naa gò ê pâ wâdé ma *aupwényunyuâari, gée goo pimeaari imudi kêe. ");
INSERT INTO priNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Béaa, âna é pinaigé mara ê *Naèà wà *Moosé. Â nabàni, âna é pinaigé mara ê pimeaari imudi ma *âjupâra, wà Iésu *Kériso. ");
INSERT INTO priNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Nye ticè pwi jè âboro cèna é mu jèe côo Pwiduée. Êco na wà Pwina naîê na caapwi co, âna wàé kaa na pamogòorié tâjè. Ba é nye tà tâa jaa Pwiduée, â nye tàgére wàé côwâ mwara Pwiduée. ");
INSERT INTO priNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","20","Wà tèpa caa kà tèpa *Juif gée *Iérusaléma, âna rà panuâ pâ pàra tèpa ênawéna kâra Wâra pwapwicîri, ma pàra tèpa pwa *ârapwaailò dari Ioane. Â rà tawèerié pâ: «Wâgà wàa?» Â nye ticè na é naapwàniri goorà, ba é ina ba pwéelaa tàra pâ: «Càcaa wâgo pwi *Mesia, na ée mwa pa-udò ê Ba.» ");
INSERT INTO priNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Â rà tawèerié pâ: «Â gona wâgà wàa? Gona càcaa wâgà Élia, pwi *péroféta na ée mwa pâbéaa kêe?» «Bwa.» «Â gona câgà caa i pwi Péroféta na é inaê wà Moosé?» «Bwa.» ");
INSERT INTO priNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","«Â gona wâgà wàa? Gà ina tâbà, ba na bà ina tà tàpé na rà panuâbà me.» ");
INSERT INTO priNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Â é tòpi tàra pâ: «Wâgo wà pwi âboro na ia é inaô wà Isaia, pwi péroféta, na ia é wii pâ: Pwi âboro naa namaré na é tomara too: “Ée me Pwi Ukai! Patàrù naigé kêe!”» Ésaïe 40.3 ");
INSERT INTO priNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Rà tâa nabibiu kà tèpa âboro bèepwiri cùrurà, pàra tèpa *Farasaio. ");
INSERT INTO priNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Â rà tawèerié mwara pâ: «Wiàna càcaa wâgà pwi Mesia, é, Élia, é, pwi Péroféta, â gorodà na gà *piupwaa?» ");
INSERT INTO priNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Â é tòpi tàra wà Ioane pâ: «Wâgo, âna go piupwaa goro jawé. Êco na é wânabibiu kàwà, ê pwi âboro na câguwà caa câmogòorié. ");
INSERT INTO priNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Wàé, âna ée mwa pwicò kôo. Êco na po dau càcaa pâriô, ma go tipi ê otàpwe goro du wâraâê, ba é Pwi Ukai.» ");
INSERT INTO priNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Ê pwâra pitùra kàra bèepwiri, âna rà pwa na Bétani, pwi village na wâdò côwâ kâra nairiwâ Ioridano, wâna na é piupwaa naawê wà Ioane. ");
INSERT INTO priNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Na dàuru kêe, â é côo Iésu wà Ioane, na é me burèe, â é ina pâ: «Wàéni i *Pwi nari mutô kà Pwiduée! Wàé na é patâjii ê èpà kâra pâ âboro gòropuu! ");
INSERT INTO priNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Wà i pwi âboro, na ia go inaê tàwà napwiri pâ: É bwaa pwicò kôo wà pwi âboro, na dau pwamuru naa gooé jiio, ba é jèe nye wâro béaario. ");
INSERT INTO priNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","«Béaa, âna câgo caa câmogòori pâ wàilàapà pwi âboro na ia go picémaraê tàwà. Â go me nau piupwaa goro jawé, ba na rà o câmogòorié wà tàpé *Isaraéla.» ");
INSERT INTO priNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Â é paâjupâra mwara wà Ioane pâ: «Go côo ê *Nyuâaê Pwicîri, na é boo gée napwéretòotù, wàra déamu, â é boo naa gòé. ");
INSERT INTO priNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Béaa, âna bwaa câgo caa pâji câmogòori pâ pwiri wàilàapà. Êco na wà Pwiduée, na é cùruo me, nau piupwaa goro jawé, âna é jèe ina tôo béaa pâ: “Gà mwa côo ê Nyuâaê Pwicîri, na boo naa gò pwi jè âboro, â é mwa tâa gooé. Âna wàé kaa, pwi âboro na ée mwa piupwaa goro Nyuâaê Pwicîri.” ");
INSERT INTO priNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","«Â wàé kaa pwiri ê pwina go côo, â go nye paâjupâra pâ, wà pwi âboro bèepwiri, âna Pwina naî Pwiduée.» ");
INSERT INTO priNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Na dàuru kêe, âna rà tâa wê côwâ wà Ioane ma tupédu âboro ârailu a *câmu kêe. ");
INSERT INTO priNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Â é côo Iésu na é paé, â é ina pâ: «Wàéni i Pwi nari mutô kà Pwiduée!» ");
INSERT INTO priNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Â ru têreê, â ru pâra wiâ Iésu. ");
INSERT INTO priNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Â é tabèreè wà Iésu, â é côoru, na ru gére pâra wiâê, â é ina tàru pâ: «Gàu mudà î?» Â ru tòpi têe pâ: «Gà pitâa pà, co pwi Rabbi?» (Ê popai Rabbi, âna pai ina wèe pâ ‘Pwi a pwa pupûra’.) ");
INSERT INTO priNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Â é ina tàru pâ: «Gàu me, ba na gàu o côo.» Jèe ârapàpé ineretòotù na càùru ija. Â rà pâra naima, nau côo na é pitâa wê, â rà jèe tà burà tâa wê. ");
INSERT INTO priNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Wà pwi jèpwi gée gooru, âna wà André, pwi aéjii kà Simona Pétéru. ");
INSERT INTO priNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Â é pò ma pâmari pwi aéjii kêe, â é ina têe pâ: «Bu jèe pâmari pwi Mesia!» (Ê popai ‘Mesia’, âna pai ina wèe pâ ‘Kériso’.) ");
INSERT INTO priNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Â é popaé pâdari Iésu. Â é côo wà Simona wà Iésu, â é ina têe pâ: «Wâgà Simona, pwina naî Iona. O mwa pituneegà pâ Céphas, é, Pétéru.» (Ê pwi neere âboro bèeni, âna pai ina wèe pâ ‘Atü’.) ");
INSERT INTO priNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","44","Na dàuru kêe, â nüma Iésu na é wâjué côwâ naa napô Galilée. Ûna é pâra, â ipitiru ma Filipo, pwi âboro gée Bethsaïda, village kà André ma Pétéru. Â é ina têe wà Iésu pâ: «Me wiâô!» ");
INSERT INTO priNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Â wà Filipo, âna ipitiru ma Natanaël, â é ina têe pâ: «Gà côo, bà jèe côo pwi âboro, na ia é inaê wà Moosé naa na i Naèà kêe—wà pwi âboro na ia rà picémaraê mwara wà pàra tèpa péroféta. Wà pwiibà, âna wà Iésu, pwi âboro gée Nazareth, pwina naî Ioséfa.» ");
INSERT INTO priNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Â é ina têe wà Natanaël pâ: «Gona nye pâri ma me gée Nazareth, cè jè muru cèna wâdé? Auwa!» Â é tòpi têe wà Filipo pâ: «Me, ma gà côo!» ");
INSERT INTO priNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Ûna é gére medari Iésu wà Natanaël, â é côoê wà Iésu, â é ina pâ: «Wàéni ê pwi âji Isaraéla, ba é pwi âboro na é *tàrù ma âjupâra!» ");
INSERT INTO priNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Â é pò wà pwiibà, â é ina têe pâ: «Gà tâmogòorio géepà?» Â é ina têe wà Iésu pâ: «Béaari ê pai todàgà kà Filipo, âna go jèe tà côogà na aranara i *upwâra wâi.» ");
INSERT INTO priNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Â é ina têe wà Natanaël pâ: «Pwi a pwa pupûra, wâgà Pwina naî Pwiduée, â gà Pwi Ukai naa Isaraéla!» ");
INSERT INTO priNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Â é tòpi têe wà Iésu pâ: «Gona gà cèikî, gée goo na go ina tâgà pâ, go côogà na aranara i upwâra wâi? Tàpo coo, ba gà o mwa côo ê pâ namuru na dau maina jii pwiri!» ");
INSERT INTO priNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Â é ina tàra diri pâ: «Guwà têre bwàti, ba go ina tàwà ê âjupâra pâ: Guwà o mwa côo ê napwéretòotù, wiàna tàpirié. Â guwà o mwa côo wà tèpa *angela kà Pwiduée, na rà too ma tàbàtù, wâgò-o *Pwina naîri âboro.» ");
INSERT INTO priNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Gée na càùru ârailu tòotù, âna pwa jè piéa na Kana, jè village gée Galilée. Â é tâa goo wà nyaa kà Iésu. ");
INSERT INTO priNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Â rà todà mwara Iésu ma tèpa *câmu kêe, naa goro piéa. ");
INSERT INTO priNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Bwaa càcaa pâji pwâadàra i tòotù, â jèe pâ nau ticè dipâa. Â é todà Iésu wà nyaa kêe, â é ina têe pâ: «Au, meaarirà, ba jèe ticè dipâa kàra.» ");
INSERT INTO priNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Â é ina têe wà Iésu pâ: «Naa càcaa wâgà, na pitûâri tôo, cè pwina go o pwa. Ba bwaa càcaa pâji tèepaa me ê pàara kôo.» ");
INSERT INTO priNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Â é ina wà nyaa kêe tà tèpa ênawéna pâ: «Guwà pwa diri ê pwina ée mwa ina tàwà.» ");
INSERT INTO priNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Â tâa wê ê tèpa wâra jawé atü na po 6, na piwâpâ na 100 litres. Wà tèpa *Juif, âna rà mu pa ê jawé gée na, târa ê ‘pwapwicîri târa pai *pinuwa’, wiâra ê nyamanya kàra. ");
INSERT INTO priNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Â é ina tà tèpa ênawéna wà Iésu pâ: «Pwaai ma wâbé tèpa wâra jawé bèepwiri, goro jawé.» Â rà pwaai ma wâbé diri. ");
INSERT INTO priNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Â é pwa ma ina tàra côwâ pâ: «Guwà cia côwâ, â guwà popa pâdari wà pwi apooro pi-ija.» Â rà cia pâdarié. ");
INSERT INTO priNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Nabwé, â é nacai i jawé wà pwini â é pò, ba jèe pâra nau dipâa. Â câé caa tâmogòori wâna na me géewê, i dipâa bèepwiri. (Êco na wà tèpa ênawéna, âna rà nye tâmogòori.) Â é todà pwi a piéa, ");
INSERT INTO priNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","â é ina têe pâ: «Naa na ê pai pwa kâjè, âna jè ipâdi béaa ê dipâa na dau wâdé. Ûna rà jèe dau wâdo, â jè mwa pâdi ê dipâa na câé caa po dau wâdé. Êco na wâgà, âna gà nye tàgére wéaari dipâa na wâdé, tiagoo ni!» ");
INSERT INTO priNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Wàé kaa pwiri tapoo pàtàmara wakè, na é tapoo wà Iésu na Kana wâ Galilée. Ba ê câmu bèepwiri, âna é paari ê pai maina ma muugère kêe. Â rà cèikî naa gooé wà tèpa câmu kêe. ");
INSERT INTO priNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Gée na càùé, â é boo naa Capernaüm wà Iésu, wàilà ma wà nyaa kêe, ma tèpa aéjii kêe, ma wà tèpa câmu kêe. Â càcaa wâru pâ tòotù na rà tâa wê na. ");
INSERT INTO priNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Jèe tàpo wâmwünyabwe ê tòotù *Paséka, tòotù maina kà tèpa Juif. Â é too naa *Iérusaléma wà Iésu. ");
INSERT INTO priNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Â ûna é tò naa na gòroigé kâra ê *Wâra pwapwicîri, â é pâdari ê pâ âboro, na rà gére pi-icu paaci ma mutô ma déa, â é côo mwara tèpa pitòotéri mwani, na rà tâaboo naa goro taapà kàra. ");
INSERT INTO priNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Â é bàpi ê otàpwe, ba na ubati, â é cau tütürà gée na Wâra pwapwicîri—cau wàilà mara pâ mutô ma paaci kàra. Â é tawicèpwiri tâjii ê pâ mwani atü kà tèpa pitòotéri mwani, ma pugòboori ê pâ taapà kàra. ");
INSERT INTO priNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Â é tûâri tà tèpa pi-icu marü, pâ: «Guwà patâjii géeni ê pâ muru bèeni! Â guwà nabwé na guwà pwa ma wâra pi-icu ê wâ kà Caa kôo!» ");
INSERT INTO priNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Â wà tèpa câmu kêe, âna rà mwa niimiri ê jè auwii naa na *Tii Pwicîri, pâ: Dau maina ê pwâranümoo goo ê Wâra pwapwicîri'gà. ");
INSERT INTO priNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Rà ina têe wà tèpa pitûâ kà tèpa Juif pâ: «Dà cè câmu kêe, na gà pwa, târa paari tâbà pâ ê pwina gà pwa, âna muru me gée jaa Pwiduée?» ");
INSERT INTO priNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Â é ina tàra pâ: «Téura tâjii ê wâra pwapwicîri bèeni, â go mwa pacima côwâ naa na âracié tòotù!» ");
INSERT INTO priNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Â rà ina têe pâ: «A?! Po 46 naja goro pai bari wàra ê Wâra pwapwicîri bèeni! Â wànau? Wâgà, âna gà ina pâ gà o pacima côwâ naa na âracié tòotù?!» ");
INSERT INTO priNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Êco na ê ‘wâra pwapwicîri’ na é ina wà Iésu, âna é ina ê naiié. ");
INSERT INTO priNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Ûna ée mwa wâro côwâ gée na aubà, â rà mwa niimiri wà tèpa câmu kêe, pâ, é mu jèe nye pwa wâru ina tàra ê pwi bèepwiri. Â rà cèikî naa goo ê Tii Pwicîri, ma pâ pwina é jèe nabwé ina wà Iésu. ");
INSERT INTO priNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Ûna é bwaa tâa Iérusaléma wà Iésu, na tòotù Paséka, â dau wâru âboro na rà cèikî naa gooé. Ba rà jèe côo pâ câmu kâra pàtàma Pwiduée na é pwa. ");
INSERT INTO priNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Êco na câé caa po cèikî naa goorà, ba é jèe nye cau câmogòorirà diri. ");
INSERT INTO priNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Ba càcaa âjimuru têe, wiàna ina têe ê pai pwa kâra âboro, ba é nye tâmogòori pwâranümarà. ");
INSERT INTO priNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Pwa pwi jè âboro na nee Nicodème, pwi jè ârapàara tèpa pwapwicîri gée jaa tèpa *Farasaio. Â é pwi âboro imaina kà tèpa *Juif. ");
INSERT INTO priNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Â é pâra dari Iésu na jè ne, â é ina têe pâ: «Pwi ukai, bà jèe tâmogòori pâ, gà pwi a pwa pupûra na gà me gée goo Pwiduée. Ba nye ticè pwi âboro, na pâri ma é pwa ê pâ *câmu kâra pàtàma Pwiduée na gà pwa, wiàna câé caa wâjaaé wà Pwiduée.» ");
INSERT INTO priNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","É tòpi têe pâ: «Gà têre bwàti, ba go ina tâgà ê âjupâra pâ: Wiàna càcaa jèu pitèpa côwâ wà pwi âboro, â o càcaa pâri ma é côo ê *Mwaciri kà Pwiduée.» ");
INSERT INTO priNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Â é ina têe wà Nicodème pâ: «A? É wànau târa cè pai pitèpaé côwâ, wà pwi jè âboro na é jèe maina? Gona nye pâri ma é tò côwâ naa nanaa nyaa kêe, ma o mwa jèu pitèpaé côwâ?» ");
INSERT INTO priNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Â é tòpi têe wà Iésu pâ: «Go ina tâgà ê âjupâra pâ: Wiàna càcaa jèu pitèpa côwâ wà pwi âboro, goro jawé ma ê Nyuâaê Pwicîri, â o càcaa pâri ma é tò naa na Mwaciri kà Pwiduée. ");
INSERT INTO priNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Wà pwina pitèpaé gée goro âboro, âna nye pwi âboro. Â wà pwina pitèpaé gée goo ê Nyuâaê Pwicîri, âna nye pwi âboro kà Pwiduée. ");
INSERT INTO priNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Gà cibwaa pò, na go gére ina tâgà pâ, wâdé na jèu pitèpawà côwâ. ");
INSERT INTO priNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Gà côo, ê pwéretòotù, âna é nye pâ naa, na nye nümee na é pâ wê. Â gà têre aié, â câgà caa tâmogòori na é me géewê, ma wâna é pâ naawê. É wàrapwiri mwara naa goo pwi âboro na pitèpaé naa na ê Nyuâaê Pwicîri.» ");
INSERT INTO priNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","É ina têe wà Nicodème pâ: «Ê ‘pitèpa bèeni naa na ê Nyuâaê Pwicîri’ na gà ina, âna o wànau târa cè pai pwa wèe?» ");
INSERT INTO priNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Â é tòpi têe wà Iésu pâ: «Gà pwi *dotée goro ê Naèà, â gà pwi âboro imaina na *Isaraéla. Â gona câgà caa tâmogòori ê pâ pwi bèepwiri? ");
INSERT INTO priNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Go ina tâgà ê âjupâra pâ: Bà ina pâ pwina bà tâmogòori, â bà *paâjupâra ê pwina bà côo. Â câguwà caa tòpi ê pwina bà paâjupâra. ");
INSERT INTO priNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Na go ina tàwà pwina tèepaa naa na gòropuu, â câguwà caa cèikî naa goo. Â guwà mwa wànau târa cè pai cèikî kàwà, wiàna go ina tàwà ê pâ muru na wânidò *napwéretòotù? ");
INSERT INTO priNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Nye ticè pwi jè âboro cèna é too naa napwéretòotù; â wâdé co wâgo *Pwina naîri âboro, na go boome gée napwéretòotù. ");
INSERT INTO priNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","«Gà pitaniimiri ê pai pwa kà *Moosé, naa namaré. Ba é cipa too naa goro ê bàra upwâra, ê dòèa na pwa goro paò. Â o wàrapwiri ê pai cipa too wà *Pwina naîri âboro, ");
INSERT INTO priNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","ba na wà pwina é cèikî naa gooé, âna o tà têe ê *wâro dàra gòiri jaa Pwiduée. ");
INSERT INTO priNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","«Ba po dau wânüma Pwiduée goo ê pâ âboro gòropuu, êkaa na é panuâ me wà Pwina naîê na é caapwi co, ba na wà pwina é cèikî naa gooé, âna câé caa bà, êco na o tà têe ê wâro dàra gòiri. ");
INSERT INTO priNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Ba câé caa cùru me Pwina naîê, wà Pwiduée, ba na é pitèi tèpa âboro gòropuu. Â é cùrué me, ba na rà udò ê pâ âboro gée gooé, ma tâa tàra ê *âji wâro jaaé. ");
INSERT INTO priNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Wà pwina é cèikî naa goo wà Pwina naîê, âna càcaa pitèié; â wà pwina câé caa cèikî naa gooé, âna jèe pitèié. Wàrapwiri, ba câé caa cèikî naa goro *Pwina naî Pwiduée, na é caapwi co. ");
INSERT INTO priNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","«Â ê aupitèi bèepwiri, âna êni: É jèe tèepaa me ê pwéelaa naa gòropuu, êco na wà tèpa âboro, âna wâdé tàra ê bàutê jii ê pwéelaa. Ba ê pâ càrarà ma tûâ kàra, âna nye taaci èpà. ");
INSERT INTO priNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Ba wà pwina é pwa taaci na èpà, âna é èpàri ê pwéelaa. Â câé caa me naa na pwéelaa. Ba péa o côo ê pâ tûâ kêe na èpà. ");
INSERT INTO priNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Â wà pwi âboro na é wakè na *âjupâra, âna é me naa na ê pwéelaa, ba na inapàpari diri pâ wakè kêe, na me gée goo Pwiduée.» ");
INSERT INTO priNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Gée na càùé, â rà pâra wà Iésu ma wà tèpa *câmu kêe, naa napô *Judée. Â rà tàpo tâa wê, â é *upwaa tèpa âboro. ");
INSERT INTO priNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Â wà Ioane mwara, âna é *piupwaa naa na ére wâ Énon, wâmwünyabweri Salim, gée goro na wâru najawé wê. Â rà pâra wiâê ê pâ âboro, ba na é upwaarà naawê. ");
INSERT INTO priNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","(Ba bwaa câé caa pâ pwa karapuu, na pàara bèepwiri.) ");
INSERT INTO priNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Na jè tòotù, âna wà pwi jè Juif, âna é tapoo pitùra ma wà tèpa câmu kà Ioane. Â rà pâ nau pitòocia goro ê ‘pwapwicîri târa *pinuwa’ wiâra ê nyamanya kàra. ");
INSERT INTO priNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Â rà pâdari Ioane, â rà ina têe pâ: «Pwi ukai, gà niimiri i pwi âboro na ia gà paâjupâraê, na ia gàu caatâa na ére gée côwâ kâra Ioridano? Â gà côo, nabàni, âna é jèe gére piupwaa! Â jèe po dau wâru ê pâ âboro na rà gére pâra darié!» ");
INSERT INTO priNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Â é tòpi tàra wà Ioane pâ: «Nye ticè jè muru cèna é tòpi wà pwi âboro, wiàna câé caa naa têe wà Pwiduée. ");
INSERT INTO priNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Ba wâguwà kaa, âna guwà jèe nye têreô, na go ina pâ, càcaa wâgo *Mesia na ée mwa pa-udò ê Ba. Ba wâgo, âna cùruo me, ba na go pâbéaa kêe. ");
INSERT INTO priNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","«Guwà côo, wà pwina é tâa jaa wà tô a piéa, âna wà pwi a piéa. Â napwa naa goo wà pwi bée pwi a piéa; âna é tà coo goro jènereê, â é tàmaariê. Â é dau ipwàdée goro ê pwâratùra kêe. Â ipaiwà naa gooò, ba nye tâbawêe nabà ê ipwàdée kôo. ");
INSERT INTO priNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Â wâdé na é pimaina too; â go pikîri boo.» ");
INSERT INTO priNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Wà pwi âboro gée gòropuu, âna é nye gée gòropuu. Â é nye tùra pwacèwii pwi âboro gée gòropuu. Êco na wà pwina é me géenidò napwéretòotù, âna é nye wâjaijè diri. Üu, é wâjaijè diri kaa. ");
INSERT INTO priNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Â é nye paâjupâra ê pâ muru na é jèe côo ma têre. Â nye ticè âboro cèna é tòpi ê pâ muru na é ina. ");
INSERT INTO priNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Â wà pwi âboro na é tòpi ê pipaâjupâra kêe, âna é inapàpari pâ, wà Pwiduée, âna é ina ê âjupâra. ");
INSERT INTO priNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Ba wà pwi âboro na é cùrué wà Pwiduée, âna é ina ê popai kà Pwiduée. Â wà Pwiduée, âna é naa bamwara têe ê Nyuâaê Pwicîri. ");
INSERT INTO priNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Wà Pwiduée Caa, âna wânümee goo Pwina naîê, â é naa têe pitûâ naa gòro diri pâ muru. ");
INSERT INTO priNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Wà pwi âboro na é cèikî naa goo Pwina naîê, âna tà têe ê wâro dàra gòiri jaa Pwiduée. Â wà pwi âboro na tàutêe na é cèikî, âna o câé caa wâro. Â ê pwâra putàmu kà Pwiduée, âna o nye tà tâa gooé. ");
INSERT INTO priNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","3","Rà têre wà tèpa *Farasaio pâ, wâru ê pâ âboro na é todàra wà Iésu, ma *upwaarà, jii wà Ioane. (Êco na câé caa *piupwaa wà Iésu; â wà tèpa *câmu kêe co na piupwaa.) Ûna é têre pwiri wà Iésu, â é pâra gée napô *Judée, naa Galilée. ");
INSERT INTO priNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Â é pitapàgà pâ napô *Samaria. ");
INSERT INTO priNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Â é tèepaa naawê, â é pâra naa na pwi jè village, na nee Sikar, na é wâmwünyabweri ê napuu, na ia é jèe naa wà Iakobo tà pwina naîê Ioséfa, na pàara biu. ");
INSERT INTO priNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","É tâa wê ê pwârajawé kà Iakobo. Â é tàpo tâaboo naawê wà Iésu, ba dau oratêe, goro ê pai pâra kêe, â jèe gopaé. ");
INSERT INTO priNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Wà tèpa câmu kêe, âna rà pâra naa na village nau wâri cè èrà. É tèepaa naa goro pwârajawé wà tô jè ilàri gée Samaria, nau cia jawé. Â é ina têe wà Iésu pâ: «Tôoni, go ilagà na gà naa cè wâdooò.» ");
INSERT INTO priNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Â é tòpi têe i tô ilàri pâ: «Ée! Cina gà ila jawé jiio, wâgà pwi *Juif? Ba wâgo, âna go tô Samaria.» (Ba càra caa piwâdé wà tèpa Juif ma tèpa Samaria.) ");
INSERT INTO priNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Â é tòpi têe pâ: «Câgà caa câmogòorio, wâgo pwi a gére ila jawé jiigà. Â câgà caa câmogòori mwara ê uràpâra kà Pwiduée. Ba wiàna gà côoinari, â pwiri gére wâgà na ila jawé jiio; â pwiri go gére naa tâgà cè jawé târa wâro!» ");
INSERT INTO priNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Â é ina têe wà tôobà pâ: «Gà o wànau târa cè pai pa wàra i jawé târa wâro, na gà gére ina? Ba nye ticè wâra cia, â é po dau tâgòro i pwârajawé. ");
INSERT INTO priNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Wànau? Gà piwéna jii Iakobo, pwi caa kâbà? Ba wàé na naa tâbà i pwârajawé bèeni. Â rà wâdo ni, ma tèpa naîê, ma ê pâ macii kêe diri.» ");
INSERT INTO priNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Â é tòpi têe wà Iésu pâ: «Ê pâ âboro na rà wâdo na pwârajawé bèeni, âna o bwaa nye tà nümarà dàra wâdo côwâ. ");
INSERT INTO priNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Êco na wà pwi âboro na é wâdo ê jawé na go naa têe, âna o càcaa mwa caa nümee dàra wâdo. Ba ê jawé na go o mwa naa têe, âna ée mwa pâra nau pwârapò gooé—pwi pwârapò na ée mwa tà ciburà pò, tia naa na ê wâro dàra gòiri jaa Pwiduée!» ");
INSERT INTO priNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Â é ina têe wà tôoni pâ: «Naa tôo ê jawé bèepwiri! Naa tôo, ba na o câ mwa caa nümoo dàra wâdo côwâ! Â o câgo mwa caa me côwâ nau cia jawé wâni!» ");
INSERT INTO priNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","É tòpi têe pâ: «Pâra nau todà pwi éagà; â gàu me naani.» ");
INSERT INTO priNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","«Nye ticè éao.» «Nye âjupâra ê pai ina'gà pâ nye ticè éagà. ");
INSERT INTO priNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Ba jèe po 5 éagà. Â wà pwina gàu gére pitâa ma wàéni, âna càcaa pwi éagà mwara. Üu, nye âjupâra kaa ê pai tòpi'gà!» ");
INSERT INTO priNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Â é ina têe wà tô ilàri pâ: «Go côo pâ gà pwi *péroféta, na gà pame ê popai me gée jaa wà Pwiduée! ");
INSERT INTO priNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Wà tèpa ijiao kâbà, âna rà pwamaina Pwiduée gòro ê jaa bèeni. Â napwa naa goowà tèpa Juif, âna guwà ina pâ ê ére na jè pwamainaê naawê, âna wâ *Iérusaléma.» ");
INSERT INTO priNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Â é ina têe wà Iésu pâ: «Tôoni, gà cèikî naa gooò, na go ina pâ: O mwa tèepaa me ê pwi pàara, na o jèe nabwé na pwamaina Caa, naa gò pwi jaa bèeni, ma wâ Iérusaléma mwara. ");
INSERT INTO priNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Ba wâguwà tèpa Samaria, âna câguwà caa tâmogòori wà Pwina guwà pwamainaê. Wâdé wàibà tèpa Juif, ba bà nye tâmogòorié. Ba ê pai udò kà tèpa âboro, âna me gée goo tèpa Juif. ");
INSERT INTO priNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Êco na o mwa tèepaa ê pwi pàara, â jèe wàé kaa ni, na rà o mwa pwamaina wà Caa wà tèpa âboro, naa na nyuâa ma na *âjupâra. Ba wàé kaa pwiri ê pai pwamaina, na é ilari wà Caa. ");
INSERT INTO priNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Ba wà Pwiduée, âna é nyuâa. Â wâdé na wà tèpa âboro na rà pwamainaê, âna rà pwamainaê naa na nyuâa ma na *âjupâra.» ");
INSERT INTO priNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Â é ina têe wà tô ilàri pâ: «Go tâmogòori pâ ée mwa tèepaa wà pwi *Mesia, jè nee mwara Kériso. Â wiàna ée mwa tèepaa, â ée mwa inapàpari tâjè diri ê pâ muru.» ");
INSERT INTO priNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Â é ina têe wà Iésu pâ: «*Wâgo pwini na tàgére patùragà!» ");
INSERT INTO priNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Ûna ru bwaa gére pitùra, â rà tèepaa me côwâ wà tèpa câmu kêe. Â rà dau pò, na rà côoê na ru ipwa jèkutâ ma tô jè ilàri. Êco na nye ticè gée goorà cèna tawèeri tô ilàri pâ: «Dà cè pwina na gà ina tà pwini?» Â ticè na tawèeri Iésu pâ: «Cina gà pwa jèkutâ ma wà tôoni?» ");
INSERT INTO priNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Â é panuâ naawê i wâra cia jawé kêe wà tô ilàri. Â é pâra côwâ naa na village, â é ina târa ê pâ âboro pâ: ");
INSERT INTO priNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","«Ée! Guwà me nau côo pwi âboro na é cau inapàpari tôo diri ê pâ muru na go pwa! Pwiri wàilàapà? Pwiri wà Mesia?» ");
INSERT INTO priNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Â rà cau pâra diri nau côo Iésu. ");
INSERT INTO priNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Na pwi pàara-bà, â rà tàgére tacoo goo wà Iésu wà tèpa câmu kêe pâ, na é pa cè uti kêe: «Pwi Ukai, gà jèe tàpo ija!» ");
INSERT INTO priNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Êco na é ina tàra pâ: «Wâgo, na pwa ê uti kôo, na câguwà caa tâmogòori.» ");
INSERT INTO priNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Â rà pitawèerirà pâ: «Pwiri jèe pwa cè âboro cèna pame cè uti kêe?» ");
INSERT INTO priNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Â é tòpi tàra pâ: «Ê uti kôo, âna, na go pwa ê câbawâdé kà Pwina é cùruo me, â go tubanabwé diri ê pâ wakè na é naa tôo. ");
INSERT INTO priNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","«Guwà tâmogòori ê auina na ina pâ: “Bwaa dàra ârapàpé parui târa piûnya.” Êco na go ina tàwà pâ: Côo bwàti ê pâ aupwanapô, ba jèe pàara târa piûnya! ");
INSERT INTO priNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","«É tàgére tòpi ê wâriê wà pwina é piûnya, ba é piûnya dàra ê *wâro dàra gòiri jaa Pwiduée. Êkaa na ru cau ipwàdée, wà pwina é câmi, ma wà pwina é piûnya. ");
INSERT INTO priNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Â êna âjupâra ê pai ina wèe pâ: “Jè âboro, âna é câmi, â jèpwi, âna é piûnya.” ");
INSERT INTO priNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","«Wâgo na go cùruwà nau piûnya ê pwina câguwà caa câmi. Ba wà pàra tàpé, âna rà wakèri, â wâguwà, âna guwà mwa caa piûnya.» ");
INSERT INTO priNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Wâru tèpa Samaria gée na village Sikar, na rà cèikî naa goo Iésu, gée goo jèkutâ kà tô ilàri, na ia é ina tàra pâ: «É po cau ina tôo diri ê pâ muru na go pwa.» ");
INSERT INTO priNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Â rà pâmari Iésu, â rà tacoo gooé pâ, na é bwaa tàpo tâa jaarà. Â é tâa jaarà naa na ârailu tòotù. ");
INSERT INTO priNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Mwa dau wâru âboro côwâ, na rà cèikî naa goo Iésu, gée goro ê pai tùra kêe. ");
INSERT INTO priNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Â rà ina tà tô ilàri pâ: «Câbà caa cèikî gée goro ê jèkutâ'gà co. Ba nabàni, âna bà jèe têreê. Â bà tâmogòori pâ wàé kaa, âna é *pwi a pa-udò pâ âboro gòropuu!» ");
INSERT INTO priNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Gée na càùru du tòotù bèepwiri na napô Samaria â é wâjué côwâ wà Iésu naa Galilée. ");
INSERT INTO priNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","É nye tàmara ina béaa pâ: «Wà pwi péroféta, âna càra caa papwicîriê, naa na ê âji napô kêe.» ");
INSERT INTO priNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Êco na, ûna é tèepaa naa Galilée, â rà tòpié bwàti. Ba rà jèe côo ê pâ muru na é pwa na Iérusaléma, na rà tâa wê ma wàé naa goro i *Paséka. ");
INSERT INTO priNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Â é wâjué côwâ naa Kana, i pwi village gée Galilée, wâ na ia é bii i jawé ma dipâa. É tâa wê ê pwi jè âboro imaina kà ukai *Héroda, na é maagé ê pwi naîê, naa na village Capernaüm. ");
INSERT INTO priNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Â é têre pâ é jèe tèepaa wà Iésu naa Galilée, me gée Judée. Â é pâdarié, â é tacoo gooé, ma é boo naa Capernaüm, nau pwa ma é wâdé pwina naîê. Ba jèe tòina maagé kêe. ");
INSERT INTO priNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Â é ina wà Iésu tà tàpé na rà tâa wê pâ: «Wiàna câguwà caa côo ê pâ *câmu kâra pàtàma Pwiduée naa gooò na guwà pò goo, â o câguwà caa cèikî!» ");
INSERT INTO priNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Â é ina têe wà pwi âboro pâ: «Gà wàcî, co Pwi Ukai, â gà me naa jaao, ba ée jèe pwa na é bà wà pwi naîô!» ");
INSERT INTO priNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Â é ina têe wà Iésu pâ: «Gà wâjué côwâ, ba é jèe wâdé i pwi naîgà.» Â é cèikî wà pwiibà naa goro i popai kà Iésu, â é pâra. ");
INSERT INTO priNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Ûna é bwaa gére pâra, â ipitirà ma tèpa ênawéna kêe, â rà ina têe pâ, é jèe wâdé i pwi naîê. ");
INSERT INTO priNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Â é tawèerirà goro ê ineretòotù na tiàu i maagé kêe na. Â rà ina têe pâ: «Tiàu ê pai pitòoka kêe, géecaa na caapwi ineretòotù na càùru ija.» ");
INSERT INTO priNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Â é côo pâ, wàé kaa pwiri i pwi ineretòotù na ia é ina têe wà Iésu pâ: «É jèe wâdé ni i pwi naîgà.» Â rà cèikî naa goo Iésu, wàilà ma êdiri pwârawâ kêe. ");
INSERT INTO priNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Wàépwiri ê béârailu kâra câmu kâra pàtàma Pwiduée, na é pwa wà Iésu naa napô Galilée, na é me gée Judée. ");
INSERT INTO priNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Gée na càùé, â rà pwa ê pi-ija na *Iérusaléma wà tèpa *Juif. Â é too naawê wà Iésu. ");
INSERT INTO priNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Â, naa Iérusaléma, âna pwa ê jè na auipitoo, na nee Béthesda naa na *hébéru. Â é wâmwünyabweri ê pwi jè goropwârawâ goro ê ville, na rà ina goo pâ Goropwârawâ kâra mutô. Â naa goo ê pwi auipitoo-bà, âna pwa 5 goropwârawâ. Â naa na jèpa goropwârawâ, âna jè pâra nabibiu kâra du nee âra wâ. ");
INSERT INTO priNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Â po dau wâru tèpa maagé na rà tà puu wê na curuu—wà tèpa bwi, ma wà tèpa bee, ma tèpa pitàbwamwa. {Ba rà tà tapacîri ê pai gù kâra i jawé. ");
INSERT INTO priNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Ba é boome na pàra pàara ê jè *angela kà Pwi Ukai, nau gù na i jawé. Â wà pwi âboro maagé na é êgò boo béaa naa na auipitoo, gée na càùru pai gù kâra jawé, âna jèe tiàu ê maagé kêe.} ");
INSERT INTO priNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","É tâa wê wà pwi jè âboro, na jèe po 38 naja kêe goro maagé. ");
INSERT INTO priNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Â é côoê wà Iésu, na é gére puu. Â é jèe tâmogòori pâ jèe po dau gòiri ê pai maagé kêe. Â é ina têe pâ: «Nümagà na tiàu ê maagé'gà?» ");
INSERT INTO priNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Â é tòpi têe pâ: «Üu kaa! Êco na ticè âboro cèna tüô boo naa najawé, na é bwaa gére gù! Ba ûna go pwa ma go êgò boo, â é jèe êgò béaario wà pwi jèpwi.» ");
INSERT INTO priNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Â é ina têe wà Iésu pâ: «Gà cimadò, â gà pa aupuu'gà, â gà pâra!» ");
INSERT INTO priNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","É nye wâdé kaa. Â é pa ê aupuu kêe, â é pâra. Napwa tòotù bèepwiri, âna *tòotù pwicîri kà tèpa Juif. ");
INSERT INTO priNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Â rà ina têe wà tèpa caa kà tèpa Juif pâ: «Ée! Tòotù pwicîri nabà, â wiâra ê *Naèà âna pwicîri na gà pa aupuu'gà!» ");
INSERT INTO priNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Â é tòpi tàra pâ: «Bwa, wà pwina é pwa ma go wâdé, âna é ina tôo pâ, na go popa aupuu kôo, ma go pâra.» ");
INSERT INTO priNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Â rà ina pâ: «Kaa! Wàilàapà cè pwi a gére ina tâgà pwiri?» ");
INSERT INTO priNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Êco na câé caa tâmogòori pâ pwiri wàilàapà. Â càcaa pâri ma é paari tàra Iésu, naa nabibiu kâra pâ âboro, ba rà po dau wâru. ");
INSERT INTO priNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Mwa gée na càùé, â wà Iésu, âna é côo wà pwi âboro-bà naa na *Wâra pwapwicîri, â é ina têe pâ: «Gà côo, jèe tiàu ê maagé'gà. Gà cibwaa pwa côwâ ê pwina èpà. Ba o péa tèepaa darigà cè pwina o po dau èpà na dau maina.» ");
INSERT INTO priNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Â é wâjué côwâ wà pwiibà dari tèpa caa kà tèpa Juif, â é ina tàra pâ wà Iésu na é pwa ma é wâdé. ");
INSERT INTO priNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Â géewê, â rà mudàra ma rà tubaèpà tà Iésu, gée goro ê pai pwa ma tiàu ê maagé, na tòotù pwicîri. ");
INSERT INTO priNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Êco na é ina tàra pâ: «Wà Caa kôo, âna é nye tà ciburà wakè. Tèepaa naa goro tòotù nabà, â o câé caa coo. Â go nye wàrapwiri mwara wâgo.» ");
INSERT INTO priNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Â gée goo ê pai ina kêe pwiri, âna rà nye dau pibu naigé kaa ma rà pòtàmwereê. Càcaa gée goro co pai êgòjai ê tòotù pwicîri, â gée goo mwara ê pai ina kêe pâ, wà Pwiduée, âna é pwi âji Caa kêe. Ba ûna é wàrapwiri pai ina kêe, â é nama ipaiwàilu ma Pwiduée. ");
INSERT INTO priNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","É ina tàra wà Iésu pâ: «Guwà têre bwàti, ba go ina tàwà ê âjupâra pâ: Go côo ê pwina é pwa wà Caa kôo, â go pwa, ba càcaa pâri ma go pwa jè muru gée gooò. Üu, ê pâ muru na é pwa wà Caa, âna go pwa mwara wâgo, Pwina naîê. ");
INSERT INTO priNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Ba wânüma Caa gooò, â é paari tôo diri pâ muru na é pwa. Â ée mwa paari tôo mwara ê pâ pàra muru na dau maina, na go o mwa pwa. Â o dau dàpàgà tàwà wiàna guwà mwa côo. ");
INSERT INTO priNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Ba wà Caa, âna é pacimadò côwâ wà tàpé na rà jèe bà, ma pawârorà côwâ. Â go wàrapwiri mwara, wâgo Pwina naîê, ba go naa ê *âji wâro tà tàpé na nümoo na go pawârorà. ");
INSERT INTO priNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","«Napwa wà Caa, âna câé caa pitèi tèpa âboro. Â é nye naa tôo, Pwina naîê, diri ê tàrù ma go pitèirà. ");
INSERT INTO priNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Â, na wàrapwiri, â rà o cau pwamainaô diri ê pâ âboro wàra ê pai pwamaina kâra wà Caa. Ba wà pwina câé caa ipwamainaô, Pwina naîê, âna câé caa ipwamaina mwara wà Caa na é cùruo me. ");
INSERT INTO priNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","«Guwà têre bwàti, ba go ina tàwà ê âjupâra pâ: Wà pwi âboro na é pitêre dàra ê popai kôo, â é cèikî naa goo wà Pwina é cùruo me, âna é jèe tòpi ê *wâro dàra gòiri jaa Pwiduée. Â o jèe càcaa pwa wârimuru têe, ba é jèe pâra gée na bà, naa na wâro. ");
INSERT INTO priNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","«Go ina tàwà ê âjupâra pâ: O mwa tèepaa ê jè tòotù, â jèe wàéni kaa, na rà têre ê pwâratùra kôo, wâgo *Pwina naî Pwiduée, wà tàpé na rà bwaa bà. Â wà tàpé na rà pitêre dòo, âna o tâa tàra ê âji wâro. ");
INSERT INTO priNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Ba wà Caa, âna tà têe ê pàtàma târa ma é naa wâro, â é naa tôo mwara, wâgo Pwina naîê. ");
INSERT INTO priNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Â é naa tôo mwara ê tàrù, ba na go pwi a pitèimuru, gée goo na go Pwina naîri âboro. ");
INSERT INTO priNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Guwà cibwaa pò na go ina tàwà pâ: O mwa me ê tòotù, na rà o têre ê pwâratùra kôo wà diri tàpé na rà jèe bà. ");
INSERT INTO priNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Â rà o cau wâro côwâ gée na aubà. Â wà tàpé na rà pwa na wâdé, âna rà o cimadò côwâ naa na âji wâro. Â wà tàpé na rà pwa na èpà, âna rà o cimadò côwâ nau pwa wârimuru.» ");
INSERT INTO priNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","É ina tàra mwara wà Iésu pâ: «Càcaa pâri ma go pwa cè jè muru gée gooò. Â go pitèi wiâra na é ina tôo wà Caa. Â napwa pitèimuru kôo, âna *tàrù. Ba câgo caa mudàra ma go pwa ê câbawâdé kôo. Â go pwa ê câbawâdé kà Pwina é cùruo me. ");
INSERT INTO priNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","«Wiàna wâgo na go pipa-âjupâraô côwâ, â o ticèmuru naa goo ê pwina go ina. ");
INSERT INTO priNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Êco na nye pwa mwara Pwi jèpwi na é *paâjupâraô. Â go tâmogòori pâ nye âjupâra ê pwina é ina naa gooò. ");
INSERT INTO priNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","«Guwà cùru pâ tèpa âboro dari *Ioane Pwi a piupwaa, â ê jèkutâ gooò na é wiâ tàwà, âna âjupâra. ");
INSERT INTO priNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","«Wâgo, âna càcaa âjimuru tôo ê pai paâjupâra kà pwi âboro. Êco na go ina tàwà ê pâ muru bèepwiri, ba na guwà udò, ma tâa tàwà ê âji wâro. ");
INSERT INTO priNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Ba wà Ioane, âna é wàra ê ânye na udàrù, â pwa pwéelaa kêe. Â guwà ipwàdée naa na pwéelaa kâra ê pâ popai kêe, naa na jè ji pàara na càcaa gòiri.» ");
INSERT INTO priNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","«Êco na pwa ê bépaâjupâraô, na piwéna jii Ioane. Ba ê pâ namuru na é nama go pwa wà Caa, âna rà paâjupâraô, â rà paari pâ é cùruo me.» ");
INSERT INTO priNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","«Wà Caa, na é cùruo me, âna é jèe paâjupâraô diri. Â câguwà caa pâji têre ê pwâratùra kêe, ma côo mwara ê naporomee. ");
INSERT INTO priNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Â câguwà caa tòpi ê popai kêe naa na pwâranümawà. Ba câguwà caa cèikî naa gooò, wâgo na é cùruo me. ");
INSERT INTO priNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","«Guwà mudàra na ê *Tii Pwicîri, ba guwà niimiri pâ, guwà o pâmari ê wâro dàra gòiri jaa Pwiduée. Â êkaa pâ popai bèepwiri, na rà paâjupâraô! ");
INSERT INTO priNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Êco na tàutàwà na guwà me mariô, ma guwà tòpi ê âji wâro! ");
INSERT INTO priNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","«Câgo caa mudàra ma rà pwamainaô wà tèpa âboro. ");
INSERT INTO priNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Â go nye tâmogòori pâ, nye càcaa wânümawà goo Pwiduée. ");
INSERT INTO priNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Go jèe me na nee Caa kôo, â câguwà caa tòpio. Êco na, wiàna é tèepaa cè pwi jè âboro na é nye me na nee, wàé pwi âboro, â guwà nye tòpié! ");
INSERT INTO priNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Guwà ipwamainawà gée goowà côwâ, wâguwà tèpa âboro. Â câguwà caa mudàra ê âji ipwamaina, na me gée goo Pwiduée na é caapwi co. Guwà mwa wànau târa cè pai cèikî kàwà? ");
INSERT INTO priNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Êco na guwà cibwaa niimiri pâ go o mwa pitòtiwà, na ara wà Caa. Bwa, càcaa wâgo, â nye wà *Moosé, wà pwina guwà wâari pâ ée mwa pitu tàwà! ");
INSERT INTO priNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","«Wiàna âjupâra pâ, guwà cèikî naa gooé, â pwiri guwà gére cèikî naa gooò mwara! Ba é wii ê popai gooò naa na ê pâ tii kêe. ");
INSERT INTO priNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Â wàra na jèe câguwà caa cèikî naa goo ê auwii kêe, â guwà o mwa wànau târa pai cèikî kàwà, naa goo ê pâ popai kôo?» ");
INSERT INTO priNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Tàpo pwa ji pàara, â gée na càùé, â rà tapàgà ê *nawià Galilée, wà Iésu ma wà tèpa *câmu kêe. (Ê nawià bèepwiri, âna jè nee mwara Tibériade.) ");
INSERT INTO priNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Â rà nye tà pâra wiâê ê pâ âboro na wâru, ba rà côo *câmu kâra pàtàma Pwiduée naa gooé na é nama tiàu maagé kà tèpa âboro. ");
INSERT INTO priNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Â rà too naa gòrojaa wà Iésu ma wà tèpa câmu kêe, â rà tâaboo. ");
INSERT INTO priNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","5","Â ûna é tagòtùé wà Iésu, â é côo diri tèpa âboro bèepwiri na rà gére me burèe. É tâmogòori pâ jèe tàpo wâmwünyabwe ê *Paséka, tòotù kâra pi-ija kà tèpa *Juif. Â é ina tà Filipo pâ: «Jè o mwa wâri géepà cè poloa, târa ma jè pa-ijarà diri?» ");
INSERT INTO priNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","(É ina pwiri, ba na é têre cè pwina é ina wà Filipo. Ba wà Iésu, âna é jèe nye tà tâmogòori ê pwina ée pwa.) ");
INSERT INTO priNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Â é tòpi têe wà Filipo pâ: «Wiàna pwa tâjè pâ miliô, ma jè wâri poloa goo, â o càcaa pâri ma jè naa tàra diri cè nyi nari noo kâra poloa!» ");
INSERT INTO priNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Êco na é medari Iésu wà pwi jè a câmu kêe, wà André, pwi aéjii kà Simona Pétéru. Â é ina têe pâ: ");
INSERT INTO priNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","«É wâni pwi nari âboro èpo, na wâjaaé 5 poloa, ma ârailu ârawéà. Êco na o târa dà, naa goro pé jéûru âboro bèeni?» ");
INSERT INTO priNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","É ina wà Iésu pâ: «Guwà patâaboorirà.» Â rà tâaboo wà tèpa âboro naa gòro nuruga. Â ê jéû tèpa paao maina na rà ija, âna wâmwünyabweri 5 000. ");
INSERT INTO priNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Â é popa i pâ poloa wà Iésu, â é pwaolé tà Pwiduée goo. Â é pwa ma rà ipâdi, târa diri ê pâ âboro na rà tâaboo. Â é wàrapwiri naa goo i du ârawéà mwara. Â é pâdi naa goorà diri, â rà nye ija tiagoro na rà jèe po cau pwàro diri. ");
INSERT INTO priNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Â nabwé, â é ina tà tèpa câmu kêe pâ: «Guwà panaimari ê dàra utimuru, ba na o nye ticè cèna tà pwatéreri târa.» ");
INSERT INTO priNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Â rà panaimari ê pâ dàra uti kàra. Â rà pwaai ê 12 nakébò goro ê dàra noo kâra i tèpa 5 poloa! ");
INSERT INTO priNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Ûna rà côo ê pàtàma Pwiduée naa goo Iésu, â rà ina pâ: «Âjupâra pâ wàé kaa i pwi Péroféta, na ia ina pâ ée mwa tèepaa me naani gòropuu!» ");
INSERT INTO priNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Â é jèe tà tâmogòori wà Iésu pâ, rà o me nau popaé, ba na rà pacimaê ma é pwi ukai kàra. Êkaa na é pâra côwâ acari naa gòrojaa. ");
INSERT INTO priNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Na bàrane, â rà boo naa bàrawià wà tèpa câmu kà Iésu. ");
INSERT INTO priNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Â rà pa wànga, â rà tapàgà i nawià, â rà pâra cima Capernaüm, na ére gée côwâ. Ûna ne, â bwaa câé caa tèepaa darirà wà Iésu. ");
INSERT INTO priNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Â é uu ba maina ê pwéretòotù, â maina wià. ");
INSERT INTO priNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Ûna rà tapwauru naa na 5 é 6 kilomètres, â rà côo Iésu, na é câwiârà na é po pâra gòro parawére jawé. Â é pâmwünyabweri i wànga. Â po dau wâgotàra. ");
INSERT INTO priNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Êco na é ina tàra pâ: «Guwà cibwaa pwa ma wâgotàwà, ba *Wâgo!» ");
INSERT INTO priNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Â pwa na rà nama é too darirà naa gòro wànga. Êco na rà jèe pò ma tèepaa gée, wâna na rà gée naawê. ");
INSERT INTO priNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","24","Napwa naa goo wà tèpa âboro na ia é pa-ijarà wà Iésu, âna rà nye tà tâa bàrawià, na ére gée côwâ kâra nawià. Na dàuru kêe, âna rà pò na tiàu Iésu jaarà. Ba rà tâmogòori pâ, câé caa pâra wiâ tèpa câmu kêe gòro i pwi wànga. Â, na rà gére mudèe, â rà tèepaa me pàra wànga na rà me gée na ville Tibériade, â rà tâdòo naawê. Â wà tèpa âboro, âna rà tò naa gò, ba na rà pâ naa Capernaüm, nau mudà Iésu naawê. ");
INSERT INTO priNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Rà pâmari Iésu wà tèpa âboro, na ére nawià gée côwâ. Â rà ina têe pâ: «Pwi ukai, gà tèepaa naani wiidà?» ");
INSERT INTO priNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Â é tòpi tàra pâ: «Guwà têre bwàti, ba go ina tàwà ê âjupâra pâ: Câguwà caa mudòo, gée goo i pwina go pwa goro ê pàtàma Pwiduée. Bwa. Guwà medario ba ia go naa èwà na ia guwà copwa! ");
INSERT INTO priNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Êco na go ina tàwà pâ, guwà cibwaa wakè târa utimuru na o wai tiàu. Wâdé na guwà wakè dàra ê utimuru na tâa cawi—utimuru na é naa ê *wâro dàra gòiri jaa Pwiduée. Â nye wâgo, *Pwina naîri âboro, na go naa tàwà ê utimuru bèepwiri. Ba é naa tôo ê tàrù kêe ma pàtàmee wà Pwiduée Caa.» ");
INSERT INTO priNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Â rà ina têe pâ: «Dà cè pâ wakè na bà pwa, ba na bà pacoo ê câbawâdé kà Pwiduée?» ");
INSERT INTO priNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Â é tòpi tàra pâ: «Wàéni co ê wakè na nümee na guwà pwa: Na guwà cèikî naa goo pwina é cùrué me.» ");
INSERT INTO priNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Rà tawèerié mwara pâ: «Dà cè câmu kêe, cèna gà o pwa, ma bà côo ê pàtàma Pwiduée naa googà, â na bà o cèikî naa googà? ");
INSERT INTO priNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Napwa wà tèpa jojoorojè, âna rà ija manne naa namaré. Ba jèe wii naa na Tii Pwicîri pâ: É naa tàra poloa me gée napwéretòotù, ba na rà ija.» ");
INSERT INTO priNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Â é tòpi tàra pâ: «Go ina tàwà ê âjupâra pâ: Càcaa wà *Moosé na é naa tàwà ê poloa na me gée napwéretòotù. Â wà Caa kôo. ");
INSERT INTO priNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Ba ê âji poloa kà Pwiduée, âna wà Pwina é boome gée *napwéretòotù. Â é naa ê *âji wâro tà diri tèpa âboro gòropuu.» ");
INSERT INTO priNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Â rà ina têe pâ: «Pwi Ukai, gà ciburà naa tâbà ê poloa bèepwiri!» ");
INSERT INTO priNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","É tòpi tàra wà Iésu pâ: «*Wâgo âna go pwi poloa târa wâro! Wà pwi âboro na é medario ma cèikî naa gooò, âna o câ mwa caa nümee dàra ija ma wâdo. ");
INSERT INTO priNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Êco na, ia go jèe nabwé ina tàwà pâ: Guwà jèe côoô, êco na câguwà caa cèikî naa gooò. ");
INSERT INTO priNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Â rà o medario diri ê pâ âboro na é naa tôo wà Caa, â câgo caa naa còobé wà pwina é medario. ");
INSERT INTO priNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","«Ba go boome gée napwéretòotù, nau pwa ê câbawâdé kà Pwina é cùruo me, â càcaa ê câbawâdé kôo. ");
INSERT INTO priNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Â wàéni ê câbawâdé kêe: Na go cibwaa caa tubatiàu cè pwi jèpwi, gée goo tàpé na é jèe naarà tôo; â na go mwa pawâroé côwâ gée na aubà na Tòotù pwicò. ");
INSERT INTO priNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Â wàéni ê câbawâdé kà Caa kôo: Wà pwi âboro na é côoô, wâgo *Pwina naî Pwiduée, ma cèikî naa gooò, âna ée mwa tòpi ê wâro dàra gòiri jaa Pwiduée. Â go mwa pawâroé gée na aubà na Tòotù pwicò.» ");
INSERT INTO priNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Wà tèpa âboro, âna rà jèe tapoo picocoori Iésu, gée goro ê pai ina kêe pâ: «Wâgo ê pwi poloa na é boome gée napwéretòotù.» ");
INSERT INTO priNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Â rà bwaa nye tà pi-ina tàra pâ: «Kaa! Gona câé caa wà Iésu, pwina naî Ioséfa? Ba jè tàgére tâmogòori du nyaa ma caa kêe! Â gorodà na é ina pâ é boome gée napwéretòotù?» ");
INSERT INTO priNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Â é ina tàra wà Iésu pâ: «Tàpéeni, guwà cibwaa ipicocoo. ");
INSERT INTO priNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Nye ticè pwi jè âboro cèna é medario, wiàna câé caa todèe me wà Caa, wà pwi a cùruo me. Â go mwa pawâroé côwâ gée na aubà na Tòotù pwicò. ");
INSERT INTO priNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Â jèe wii naa na tii kà pwi jè *péroféta pâ: Rà o cau picòo jii Pwiduée. Â êdiri pâ âboro na rà tòpi ê pwina é ina tàra wà Caa, âna rà cau medario. ");
INSERT INTO priNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Nye ticè pwi âboro cèna é mu côo wà Caa; wàco wà Pwina é me gée jaa Pwiduée.» ");
INSERT INTO priNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","«Go ina tàwà ê âjupâra pâ: Wà pwi âboro na é cèikî naa gooò, âna o mwa tà têe ê wâro dàra gòiri jaa Pwiduée. ");
INSERT INTO priNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Wâgo ê poloa târa wâro. ");
INSERT INTO priNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Rà ija manne wà tèpa jojoorowà, naa namaré. Êco na rà jèe bà. ");
INSERT INTO priNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Â napwa ê poloa na é boome gée napwéretòotù, âna wiàna é ija pwi jè âboro, â o câé caa bà. ");
INSERT INTO priNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Wâgo ê pwi poloa târa wâro, na go boome gée napwéretòotù. Wiàna é ija poloa bèepwiri wà pwi jè âboro, â é wâro dàra gòiri awé. Â ê poloa na go mwa naa, âna ê naiio, na go naa tà tèpa âboro gòropuu, ba na rà wâro.» ");
INSERT INTO priNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Géewê, âna rà pitòocia wà tèpa pitûâ kà tèpa Juif, â rà pi-ina tàra pâ: «Wà pwini, âna é wànau târa cè pai naa tâjè ê naiié, ma jè ija?» ");
INSERT INTO priNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Â é ina tàra wà Iésu pâ: «Guwà têre bwàti: Wiàna câguwà caa ija ê naii Pwina naîri âboro, ma wâdo ê domii kêe, â o nye ticè âji wâro wâgoowà. ");
INSERT INTO priNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Â wà pwina é ija ê naiio, ma wâdo ê domii kôo, âna o mwa tà têe ê wâro dàra gòiri jaa Pwiduée. Â go mwa pawâroé côwâ gée na aubà na Tòotù pwicò. ");
INSERT INTO priNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Ba ê naiio, âna ê âji utimuru; â ê domii kôo, âna ê âji jawé. ");
INSERT INTO priNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Â wà pwi âboro na é ija ê naiio, ma wâdo ê domii kôo, âna é wâro gooò, â go wâro gooé. ");
INSERT INTO priNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","«Wà Caa na é cùruo me, âna é wâro, â wàé, âna é Pwina é naa ê wâro. Â wâgo, âna go wâro gée gooé. Â wàra mwara pwina é ija naiio, âna é wâro gée gooò. ");
INSERT INTO priNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Wàéni ê pwi poloa na é boome gée napwéretòotù. Càcaa wàra ê poloa na ia rà ija wà tèpa jojoorowà—ba rà cau bà. Â wà pwi âboro na é ija ê pwi poloa bèeni, âna é wâro dàra gòiri awé.» ");
INSERT INTO priNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","É ina ê pâ popai bèepwiri wà Iésu, na é pwa pupûra naa na *wâra pitapitiri wâ Capernaüm. ");
INSERT INTO priNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Ûna rà têre ê pwina é ina wà Iésu, â ê auwâru gée goo tàpé na rà mu ciburà pâra wiâê, âna rà pi-ina pâ: «Auwa! Po dau gòo ê popai bèepwiri! O wàilàapà cèna pâriê ma é tòpi?» ");
INSERT INTO priNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Â é têre naa gooé pâ, rà tàgére picocoorié goo, â é ina tàra pâ: «Wànau? Po dau tanooriwà ê popai bèepwiri? ");
INSERT INTO priNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Â wiàna guwà côoô, wâgo Pwina naîri âboro, na go too côwâ naa na autâa kôo béaa, â o dà cè pwina guwà niimiri? ");
INSERT INTO priNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Ba nye êkaa gée goo pâ popai kôo, na é me ê Nyuâaê Pwicîri, wàé na é naa wâro. Ba napwa pâ wakè kà tèpa âboro, âna càcaa pâri ma rà naa wâro. ");
INSERT INTO priNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Êco na rà wânabibiu kàwà pàra tèpa âboro na càra caa cèikî naa goo ê pâ popai kôo.» Ba é nye tâmogòori wà Iésu, gée na autapoo tàpé na càra caa cèikî, ma wà pwina é ipwa tûâ têe. ");
INSERT INTO priNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Â é ina tàra mwara pâ: «Wàépwiri ê majoroé ma go jèe ina tàwà pâ: Nye ticè pwi jè âboro cèna é me wiâô, wiàna câé caa todèe medario wà Caa.» ");
INSERT INTO priNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Â tapoo napwiri, âna wâru pàra tèpa âboro kêe âna rà coo jiié, â jèe càra caa pâra côwâ wiâê. ");
INSERT INTO priNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","É ina wà Iésu tà tèpa 12 a câmu kêe, pâ: «Â wâguwà, âna nümawà mwara na guwà wâjué côwâ?» ");
INSERT INTO priNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Â é tòpi têe wà Simona Pétéru pâ: «Pwi Ukai, na bà pâra wiâ î? Ba nye wâjaagà ê pâ popai târa wâro dàra gòiri jaa Pwiduée. ");
INSERT INTO priNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Ba bà nye côoina pâ, wâgà Kériso, wà Pwina é jèe pitòrigarigà ma cùrugà me wà Pwiduée. Â bà jèe cèikî naa googà.» ");
INSERT INTO priNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Â é ina tàra pâ: «Wâgo na ia pitòrigariwà, wâguwà tèpa 12 a câmu kôo. Êco na pwi jè ârapàarawà, âna pé pwi naî *Caatana!» ");
INSERT INTO priNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","É ina pwiri naa goo wà Judas, pwina naî Simona Iscariote. Ba wàé, gée goo tèpa 12 *apostolo, âna ée mwa ipwa tûâ tà Iésu. ");
INSERT INTO priNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Gée na càùé, â é pâpitiri napô Galilée wà Iésu. Ba nye càcaa nümee dàra pâpitiri wâ *Judée. Ba rà pibu naigé wà tèpa caa kà tèpa *Juif, ba na rà pòtàmwereê. ");
INSERT INTO priNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Jèe pâmwünyabwe ê *tòotù maina kà tèpa Juif. Â, na pâ tòotù bèepwiri, âna rà tâa nacapè. ");
INSERT INTO priNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Â wà tèpa aéjii kà Iésu, âna rà ina têe pâ: «Gà pâra géeni naa Judée, ba na gà too naa goro i tòotù maina. Ba wâdé na rà côo mwara ê pâ muru na gà pwa wà tèpa âboro'gà na tâa Judée. ");
INSERT INTO priNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Ba nye ticè pwi âboro cèna é naapwàniri ê pwina é pwa, wiàna nümee na picagòtùé. Â wiàna gà pwa ê pâ muru bèepwiri goro ê pàtàma Pwiduée â gà ipaarigà, ba na rà côogà wà tèpa âboro.» ");
INSERT INTO priNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Ba wà tèpa aéjii kêe, wàilà mwara, âna bwaa càra caa pâji cèikî naa gooé. ");
INSERT INTO priNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","É tòpi tàra pâ: «Wâdé naa goowà, ba nye pâri ma guwà nye tà pâra imudi. Â napwa naa gooò, âna càcaa pâji pàara kôo. ");
INSERT INTO priNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Ba tèpa âboro gòropuu, âna ticè pai pwa wèe ma rà èpàriwà. Â napwa naa gooò, âna rà nye èpàrio, ba go inapàpari ê pâ tûâ kàra na èpà. ");
INSERT INTO priNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Bwa, guwà too naa goro pi-ija, wâguwà. Â wâgo, âna câgo caa too, ba càcaa pâji tèepaa ê pàara kôo.» ");
INSERT INTO priNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Ûna é jèe ina pwiri tàra, â é bwaa tàpo tâa Galilée. ");
INSERT INTO priNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Êco na, ûna rà jèe too naa goro tòotù maina, â ée mwa tà pwicò kàra, â câé caa pipaarié. ");
INSERT INTO priNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Napwa wà tèpa caa kà tèpa Juif, âna rà imudà Iésu na aupwa-ija. Â rà pitawèeri pâ: «Wâpèe?» ");
INSERT INTO priNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Â rà dau pwa jèkutâ gooé wà tèpa âboro. Ba rà ina pàra pwi pâ: «É pwi âboro wâdé.» Â rà ina pàra tàpé pâ: «Bwa, é pwi a pwa ma rà imwüru tèpa âboro.» ");
INSERT INTO priNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Êco na nye ticè âboro cèna inapàparié, ba wâgotàra goo tèpa pitûâ kàra. ");
INSERT INTO priNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Na po nabibiu kâra pwa-ija, â é too naa na *Wâra pwapwicîri wà Iésu, â é tapoo ipupûra tà tèpa âboro wê. ");
INSERT INTO priNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Â rà dau pò gooé wà tèpa Juif, â rà pi-ina tàra pâ: «É tâmogòori géepà ê pâ *Naèà wà pwini, na nye ticè caa kâra câmu kêe?» ");
INSERT INTO priNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","É ina tàra pâ: «Ê pwina go ina tàwà, âna càcaa muru me gée gooò, â gée goo Pwiduée na é cùruo me. ");
INSERT INTO priNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Ba wiàna nümawà na guwà pwa ê câbawâdé kà Pwiduée, â guwà mwa tâmogòori pâ, wiàna ê pwina go ina, âna me gée jaa Pwiduée, é, me gée gooò. ");
INSERT INTO priNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Wà pwina é ina ê pwina é nye niimiri wàé, âna é mudàra pai pwa wèe ma picâdirié. Â wà pwina é imudàra ma é ipwamaina pwina é cùrué me, âna é *tàrù, ba é nye ina co pwina âjupâra. ");
INSERT INTO priNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","«Gona câé caa naa tàwà ê Naèà wà *Moosé? Â nye ticè pwi jè âboro cèna é pâra wiâra! Cina nümawà na guwà pòtàmwaraô?» ");
INSERT INTO priNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Â rà ina têe pâ: «Kaa! Pwa duée wâgoogà! Wàilàapà na mudàra ma pòtàmwaragà?» ");
INSERT INTO priNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Â é tòpi tàra pâ: «Nye caapwi co ji muru na go pwa goro pàtàma Pwiduée na *tòotù pwicîri â guwà dau pò goo. ");
INSERT INTO priNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Êco na wâguwà mwara, âna guwà wakè na tòotù pwicîri, na guwà pwa *kamaî tà pwi nari èpo. Ba guwà ina pâ ê pwa kamaî, âna me gée goo wà Moosé. (Êco na càcaa me gée gooé, â wà tèpa jojoorojè béaa kêe, na rà pwa.) ");
INSERT INTO priNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Üu, guwà pwa kamaî na tòotù pwicîri, ba na câguwà caa êgòjai ê Naèà kà Moosé. Â wâgo, âna go pwa ma tiàu awé maagé kà pwi jè âboro, na tòotù pwicîri. Â cina guwà putàmu naa gooò? ");
INSERT INTO priNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Guwà cibwaa tèi wiâra ê pai côo kàwà. Wâdé na guwà tèi wiâra tàrù!» ");
INSERT INTO priNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Rà ina pàra âboro gée *Iérusaléma pâ: «Gona càcaa wà i pwi ia rà mudàra ma rà pòtàmwereê? ");
INSERT INTO priNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Guwà côo! Câé caa picârü, â rà nye tàgére pitùra ma pàra tàpé, â nye gére ticè na rà ina têe wà tèpa pitûâ! Gona pwiri rà côoinaê pâ wàé pwi *Mesia, pwi ukai na jè tapacîê? ");
INSERT INTO priNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Êco na, wà pwi Iésu bèeni, âna jè tâmogòori wâna na é me géewê. Â napwa wà pwi Mesia, âna nye ticè jè âboro cèna o tâmogòori wâna na ée me géewê.» ");
INSERT INTO priNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Ûna é bwaa gére pwa pupûra wà Iésu, naa na Wâra pwapwicîri, â é tomara too pâ: «Gona guwà nye niimiri kaa pâ guwà jèe tâmogòorio? Â guwà tâmogòori wâna na go me géewê? Bwa! Ba câgo caa me gée gooò. Â wà Pwi a cùruo me, âna pwina pâriê ma guwà tòpò naa gooé ê cèikî kàwà. Êco na guwà nye âji càcaa tâmogòorié. ");
INSERT INTO priNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Â wâgo, âna go nye tâmogòorié, ba go me jiié, â wàé na é cùruo me.» ");
INSERT INTO priNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Â wà tèpa âboro, âna rà imudàra cè naigé ma rà tâjùrué, êco na nye ticè pai pwa wèe. Ba bwaa càcaa pâji tèepaa ê pàara. ");
INSERT INTO priNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Êco na rà jèe dau wâru gée goo tàpé na rà têreê, na rà cèikî naa gooé. Â rà ina pâ: «Munaa wàé pwi Mesia. Ba nye dau wâru kaa pâ câmu kâra pàtàma Pwiduée na é pwa. Â wiàna càcaa wàé pwi Mesia, â pwiri càcaa wàrapwiri.» ");
INSERT INTO priNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Wà pàra tèpa *Farasaio, âna rà têre ê pai picocoo naa goo Iésu. Â rà pitêrerà ma wà tèpa caa kà tèpa pwa *ârapwaailò, ba na rà cùru wà tèpa wéaari Wâra pwapwicîri nau tâjùrué. ");
INSERT INTO priNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Â é ina tàra wà Iésu pâ: «O càcaa gòrio jaawà, â go o mwa pâra côwâ naa jaa Pwina é cùruo me. ");
INSERT INTO priNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Â guwà o mwa pimudòo, â o câguwà caa pâdario, ba càcaa pâri ma guwà pâra naa na, na go pâ naawê.» ");
INSERT INTO priNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Â rà pi-ina tàra pâ: «Gona wâpà na, na é pâra naawê, ma o càcaa pâri ma jè o pâmariê? Wànau? Gona é còobé jii ê napô kâjè, târa ma é pacâmuri tèpa jènerejè, na rà wâro naa nabibiu kà tàpé na càra caa tèpa Juif? ");
INSERT INTO priNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Dà ê pwina é pwa na é ina tâjè, na é gére ina pâ: “Guwà o mwa pimudòo, â o câguwà caa pâdario, ba càcaa pâri ma guwà pâra naa, na go pâ naawê”?» ");
INSERT INTO priNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Jèe pwi bénabwé tòotù kâra pi-ija kà tèpa Juif, pwi tòotù na dau pwamuru naa goo. Â é cimadò wà Iésu, na ara diri ê pâ âboro. Â é tomara too pâ: «Wiàna pwa cè pwi âboro na nümee dàra wâdo, â wâdé na é medario ma é wâdo! ");
INSERT INTO priNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Ba wà pwina é cèikî naa gooò, âna o mwa pò gée gooé ê pwârajawé târa wâro, wàra ê pai ina naa na *Tii Pwicîri.» ");
INSERT INTO priNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","É ina pwiri goo ê Nyuâaê Pwicîri, na rà o mwa tòpi ê pâ âboro na rà o mwa cèikî naa gooé. Êco na, na pwi pàara-bà, âna càcaa pâji naa ê Nyuâaê Pwicîri, ba bwaa câé caa pâ too naa na muugère kêe wà Iésu. ");
INSERT INTO priNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Ûna rà têre ê pâ popai bèepwiri, â wâru ê pâ âboro na rà ina pâ: «Âjupâra pâ wà pwini, âna nye wàé kaa i Pwi Péroféta na jè tapacîê!» ");
INSERT INTO priNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Â rà ina wà pàra tàpé pâ: «Wàé kaa wà pwi Mesia!» Êco na rà ina wà pàra tàpé pâ: «Gona ée mwa me gée Galilée wà pwi Mesia? Bwa! ");
INSERT INTO priNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Ba jèe wii naa na ê Tii Pwicîri pâ, ée mwa tèepaa wà pwi Mesia gée na wâao kà pwi ukai *Davita. Â ée mwa me gée Bétéléma, village kà Davita.» ");
INSERT INTO priNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Êkaa na rà pitadàrùrà goo Iésu. ");
INSERT INTO priNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Â nüma pàra tàpé na rà tâjùrué, êco na nye ticè pai pwa wèe. ");
INSERT INTO priNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Napwa wà tèpa wéaari Wâra pwapwicîri na ia cùrurà pâ, ba na rà tâjùrué âna rà wâjué côwâ. Â rà tèepaa dari tèpa caa kà tèpa pwa ârapwaailò ma tèpa Farasaio. Â wà tàpéebà, âna rà tawèerirà pâ: «Gorodà na câguwà caa popa me Iésu?» ");
INSERT INTO priNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Â rà tòpi tàra pâ: «Nye ticè âboro cèna mu tùra bwàti pwacèwiié!» ");
INSERT INTO priNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Â rà ina tàra wà tèpa Farasaio pâ: «Wànau, é ipa-imwüruwà mwara? ");
INSERT INTO priNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Nye ticè pwi jè ârapàarajè, wàijè tèpa pitûâ ma tèpa Farasaio, na cèikî naa gooé. ");
INSERT INTO priNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Â napwa diri ê nyi tèpa âboro bèeni na rà cèikî naa gooé, âna càra caa tâmogòori ê Naèà kà Moosé. Â jèe tojiirà!» ");
INSERT INTO priNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Êco na wà Nicodème, pwi jè béerà—wà i pwi a pâmari Iésu na ne—âna é ina tàra pâ: ");
INSERT INTO priNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","«Pwicîri naa na ê Naèà kâjè, na jè pwa wârimuru tà wà pwi âboro, béaari ê pai pitèié. Wâdé na jè mara tàmaari ê pwina é ina târa ipwamuruê.» ");
INSERT INTO priNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Â rà tapàgà têe, â rà ina pâ: «Kaa! Gà pwi âboro me gée Galilée, wâgà mwara? Mudàra cai na ê Tii Pwicîri, â gà o pâ nau côo pâ, nye ticè *péroféta cèna me gée Galilée!» { ");
INSERT INTO priNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Â nabwé, â rà jèpa ipiina naa na jèpa pwârawâ kàra.} ");
INSERT INTO priNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Â é pâra wà Iésu, naa gòrojaa Élaio. ");
INSERT INTO priNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Â, na dàuru kêe, na bwaa dau dàuru, â é wâjué côwâ naa na *Wâra pwapwicîri. Â rà medarié, ê pâ âboro na wâru. Â é tâaboo, â é tapoo pacâmurirà. ");
INSERT INTO priNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Â wà pàra tèpa *dotée goro ê Naèà, ma wà pàra tèpa *Farasaio, âna rà dàti medarié ê tô jè ilàri. Ba rà pâmariê, na ru gére ipuu ma pwina càcaa pwi éaé. Â rà popaé me, na ara diri ê pâ âboro. ");
INSERT INTO priNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Â rà ina tà Iésu pâ: «Pwi a pwa pupûra, wà tôoni, âna tâjùrué na é bwaa gére mura paao. ");
INSERT INTO priNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Jèe wii naa na ê *Naèà kà Moosé, pâ, o caamwara goro atü ê tô ilàri na é wàrapwiri. Â wâgà, âna dà cèna gà ina naa goo?» ");
INSERT INTO priNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Rà ina pwiri têe, ba na rà tacaié. Ba nümarà na rà pa ê pai tòpi kêe, ma bépiciapwâ gooé. Êco na é cùué boo wà Iésu, â é pwa tii goro ê mangadaîê, naa napuu. ");
INSERT INTO priNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Ûna rà nye tà ciburà tawèerié, â é cimadò, â é ina tàra pâ: «Wâdé na wà pwi âboro, na mu nye ticè èpà na é pwa, âna é tapoo èié goro atü.» ");
INSERT INTO priNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Â é jèu cùué boo côwâ, ma pwa tii na napuu. ");
INSERT INTO priNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Â rà jèpa ipiina, tapoo gée goo tèpa ijiao, tèepaa naa goo tèpa âboro kîri. Â ru mwa tà tâa acari, wà Iésu ma wà i tô ilàri. ");
INSERT INTO priNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Â é tagòtùé wà Iésu, â é ina têe pâ: «Tôoni, rà wâpà, tàpé na ia rà pitòtigà? Gona nye ticè âboro cèna é tâa, ma é naa cè wârimuru tâgà?» ");
INSERT INTO priNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Â é tòpi têe pâ: «Nye ticè.» Â é ina têe wà Iésu pâ: «Â wâgo mwara, âna câgo caa naa cè wârimuru tâgà. Gà pâra, â gà cibwaa pwa côwâ cè tûâ cèna èpà!» ");
INSERT INTO priNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","É ina mwara tà tèpa âboro wà Iésu pâ: «*Wâgo kaa ê pwéelaa kâra gòropuu. Â wà pwi âboro na é me wiâô, âna o mwa pwa ê pwéelaa na wâgooé na naa têe ê âji wâro. Â o câé mwa caa pâ naa ê bàutê.» ");
INSERT INTO priNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Â rà ina têe wà tèpa Farasaio pâ: «Nye piticèmuru naa goo ê pwina gà ina, ba gà nye pipaâjupâragà côwâ!» ");
INSERT INTO priNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Â é tòpi tàra pâ: «Bwa. Wiàna go nye pipaâjupâraô côwâ, â nye âjupâra ê pai pipaâjupâraô kôo. Ba go tâmogòori wâna na go me géewê, ma wâna na go pâra naawê. Â napwa wâguwà, âna câguwà caa tâmogòori wâna na go me géewê, ma wâna na go pâra naawê. ");
INSERT INTO priNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Ba guwà pitèi wiâra ê tûâ kà tèpa âboro. Â wâgo, âna nye ticè pwina go tèié. ");
INSERT INTO priNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Êco na, wiàna go nye tèi, â o nye âjupâra ê pai tèi kôo. Ba càcaa wâgo co, â nye wàibu naima ma Pwiduée Caa, na é cùruo me. ");
INSERT INTO priNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Ba ia wii naa na ê Naèà kàwà pâ, ê aupaâjupâra kâra ârailu âboro, âna nye âjupâra kaa. ");
INSERT INTO priNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Â *Wâgo, âna go nye *paâjupâraô, â é nye paâjupâraô mwara wà Caa, Pwina é cùruo me.» ");
INSERT INTO priNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Â rà tawèerié pâ: «Gona wâpà Caa'gà?» Â é tòpi tàra pâ: «Câguwà caa tâmogòoribu ma Caa kôo. Ba wiàna guwà gére tâmogòorio, â pwiri guwà gére tâmogòori mwara wà Caa kôo.» ");
INSERT INTO priNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","É ina ê pâ popai bèepwiri wà Iésu, ûna é bwaa gére pwa pupûra wâna Wâra pwapwicîri, wâna autòpò âraimeai tà Pwiduée. Â nye ticè jè âboro cèna é tâjùrué, ba bwaa càcaa tèepaa ê pàara kêe. ");
INSERT INTO priNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","É ina mwara wà Iésu pâ: «Go o jèe pâra, â guwà o mwa mudòo. Â guwà o bà naa na èpà kàwà. Ba wâna na go pâra naawê, âna o càcaa pâri ma guwà pâra naawê.» ");
INSERT INTO priNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Â rà pi-ina tàra wà tèpa âboro pâ: «Dà pai ina wèe ni? Pwiri ée mwa pipòtàmwereê côwâ? Ba é ina pâ càcaa pâri ma jè pâra naa na é pâra naawê.» ");
INSERT INTO priNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Â é tòpi tàra pâ: «Wâguwà âna guwà tèpa âboro géeniboo, â wâgo, âna go me géenidò. Ba guwà tèpa âboro gòropuu, â câgo caa pwi âboro géeni gòropuu. ");
INSERT INTO priNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Gée goro pwiri, na ia go ina tàwà pâ, guwà o bà naa na èpà kàwà, wiàna câguwà caa cèikî pâ, ‘*Wâgo na go napwiri, nabà, â dàra gòiri awé’.» ");
INSERT INTO priNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Â rà ina têe pâ: «Gona wâgà wàa?» Â é tòpi pâ: «I pwi ia go jèe ina tàwà, gée na autapoo goo. ");
INSERT INTO priNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Â wâru pâ muru na pâri ma go ina naa goowà, ma pitèiwà goo. Êco na go inapàpari tàwà co ê pwina go têre jii wà Pwina é cùruo me naa jaawà. Ba wàé na é ina ê âjupâra.» ");
INSERT INTO priNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Êco na càra caa têreina pâ é pwa jèkutâ goo wà Pwiduée Caa. ");
INSERT INTO priNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Â é ina tàra pâ: «Wiàna guwà mwa naaô too naanidò, wâgo *Pwina naîri âboro, â guwà o mwa côoinari pâ, ‘Wâgo na go napwiri, nabà, â dàra gòiri awé’. Â guwà o mwa côoina mwara pâ, câgo caa po pwa cè jè muru gée gooò. Ba go ina co ê pwina é ina tôo wà Caa. ");
INSERT INTO priNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Â wà Pwina é panuâô me, âna é nye tà wâjaao, â càcaa mu nama tà wâgo acari. Ba go pwa taaci ê pâ muru na wâdé têe.» ");
INSERT INTO priNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Ûna é wàrapwiri pai tùra kêe tàra, â wâru tàpé na rà cèikî naa gooé. ");
INSERT INTO priNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","É ina wà Iésu tà tèpa Juif na rà cèikî naa gooé, pâ: «Guwà tèpa âji a *câmu kôo, wiàna guwà tà cimwü goo ê popai kôo. ");
INSERT INTO priNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Â géewê, na guwà mwa tâmogòori ê *âjupâra, â ê âjupâra âna ée mwa tipiwà.» ");
INSERT INTO priNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Â rà ina têe wà pàra tàpé pâ: «Cina gà ina pâ, o mwa tipibà? Ba wàibà, âna bà tèpa gòobàra *Abéraama, â nye ticè pwi âboro cèna é mu caa nama bà tèpa *ênawéna kîri kêe!» ");
INSERT INTO priNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Â é tòpi tàra pâ: «Guwà têre bwàti, ba go ina tàwà ê âjupâra pâ: Wà pwi âboro na é pipanuâê târa èpà, âna é pwi ênawéna kîri kâra èpà. ");
INSERT INTO priNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Â wà pwi ênawéna kîri, âna càcaa pwâraê naa na tâa kà pwi a pitûâ kêe. Â wâdé co naa goo ê pwi èpo naa pwârawâ. ");
INSERT INTO priNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Â wiàna go tipiwà, wâgo Pwina naîri âboro, â o nye ticè kaa cèna câguwà mwa caa èrà goo. ");
INSERT INTO priNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Go tâmogòori pâ guwà tèpa gòobàra Abéraama. Êco na guwà pimudàra ma guwà pòtàmwaraô, ba câguwà caa tòpi ê popai kôo. ");
INSERT INTO priNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Go ina ê pâ muru na go côo naa jaa wà Caa kôo. Â wâguwà, âna guwà nye pwa ê pwina guwà têre jii pwi caa kàwà.» ");
INSERT INTO priNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Â rà tòpi têe pâ: «Nye pwi âji caa kâbà, âna wà Abéraama!» Â é ina pâ: «Wiàna guwà tèpa âji naîê, â pwiri guwà gére pwa pâ wakè na ia é pwa. ");
INSERT INTO priNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Â nabà, âna guwà pimudàra ba na guwà pòtàmwaraô, wâgo na go ina tàwà ê âjupâra na go têre jii Pwiduée! Wà Abéraama âna câé caa mu pwa na wàrapwiri! ");
INSERT INTO priNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Bwa, guwà nye pwa ê pâ wakè kà pwi caa kàwà.» Â rà ina têe pâ: «Câbà caa tèpa èbwi! Ba nye caapwi co pwi caa kâbà, âna wà Pwiduée!» ");
INSERT INTO priNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","É tòpi tàra pâ: «Wiàna é pwi caa kàwà wà Pwiduée, â pwiri gére wânümawà gooò. Ba go me gée jaa Pwiduée, â go wâni gée gooé. Ba câgo caa me imudi, â é cùruo me. ");
INSERT INTO priNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Gorodà na câguwà caa tâmogòori ê pwina go ina tàwà? Ba nye tàutàwà na guwà tòpi ê popai kôo. ");
INSERT INTO priNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","«Bwa, wà pwi caa kàwà, âna wà *Caatana, wà Pwi âboro èpà! Êkaa na nye nümawà na guwà pwa ê câbawâdé kêe. Wà pwiibà, âna é pwi a pòtàmwara âboro, gée na autapoo goo. Â câé caa tâa na âjupâra, ba nye ticè âjupâra gooé. Ba é nye tà pwâ, ba é nye pwi a wàrapwiri, ba é pwi caa kà tèpa pwâ. ");
INSERT INTO priNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","«Â wâgo, âna go ina ê âjupâra, êkaa na câguwà caa cèikî naa goo. ");
INSERT INTO priNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Wàilàapà gée goowà cèna ée paari pâ pwa cè èpà na go pwa? Â wiàna go ina tàwà ê âjupâra, â cina câguwà caa cèikî naa gooò? ");
INSERT INTO priNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Wà tèpa âboro na rà me gée goo Pwiduée, âna rà têre ê popai kà Pwiduée. Êco na câguwà caa têre ê popai kêe, ba câguwà caa me gée goo Pwiduée.» ");
INSERT INTO priNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Rà ina tà Iésu wà pàra tèpa Juif pâ: «Bà nye âjupâra pâ gà pé pwi *Samaria, â pé pwi a pwa duée googà!» ");
INSERT INTO priNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Â é tòpi tàra pâ: «Bwa, càcaa pwa duée gooò! Êco na go pitòimiri Caa kôo, â wâguwà, âna câguwà caa pitòimiriô. ");
INSERT INTO priNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Câgo caa pimudàra cè pai pwamainaô. Êco na pwa Pwi a pitèimuru, na é pwi a-imudàra ba kôo. ");
INSERT INTO priNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Go ina tàwà ê âjupâra pâ: Wà pwi âboro na é pitêre dàra ê popai kôo, âna o càcaa pâri ma é bà dàra gòiri.» ");
INSERT INTO priNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Â rà ina têe pâ: «Bà jèe tâmogòori ni, pâ, gà pé wâra duée! Ba é jèe bà wà Abéraama, â rà jèe bà mwara wà tèpa *péroféta. Â wâgà âna gà ina pâ: “Wà pwi âboro na é pitêre dàra bwàti ê popai kôo, âna o câé caa bà.” ");
INSERT INTO priNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","«Pwiini, wâgà ilàapà?! Gona gà maina jii Abéraama, pwi caa kâbà? Wàé na é jèe bà, â rà jèe bà mwara wà tèpa péroféta!» ");
INSERT INTO priNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","É tòpi tàra wà Iésu pâ: «Wiàna go ipwamainaô, â napwa ê pâ popai kôo, âna piticèmuru naa goo. Êco na wà Caa kôo, âna é nye ipwamainaô ma paari ê pai muugère kôo. Wàé na guwà ina gooé pâ é Pwiduée kàwà! ");
INSERT INTO priNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Êco na câguwà caa tâmogòorié, â wâgo, âna go tâmogòorié. Ba wiàna go ina tàwà pâ câgo caa tâmogòorié, â go pwi a pwâ, pwacèwiiwà. Êco na go nye tâmogòorié, êkaa na go pâra wiâra ê popai kêe. ");
INSERT INTO priNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Wà Abéraama, pwi caa kàwà, âna é jèe tàmara côo ê pwi pàara kôo, â é dau ipwàdée, goo pai mwa tèepaa me kôo.» ");
INSERT INTO priNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Â rà ina pâ: «A? Bwaa càcaa pâ 50 naja'gà, â gà jèe côo Abéraama?!» ");
INSERT INTO priNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Â é tòpi tàra wà Iésu pâ: «Guwà têre bwàti, ba go ina tàwà ê âjupâra pâ: Na bwaa nye tiàu Abéraama, âna go jèe tâa, ba ‘Wâgo na go napwiri, nabà, â dàra gòiri awé’.» ");
INSERT INTO priNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Â ûna rà têre pâ, é nama ipaiwàilu ma wà Pwiduée â rà nye tòri kaa pâ atü, ba na rà èié goo. Êco na é picârü goorà, â é còobé gée na Wâra pwapwicîri. ");
INSERT INTO priNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Ûna é pâra wii naigé wà Iésu, â é côo pwi jè âboro, na é pwi a bwi gée na aukîri kêe. ");
INSERT INTO priNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Â rà tawèerié wà tèpa *câmu kêe pâ: «Pwi ukai, cina é bwi wà pwini? Pwiri gée goro cè èpà kêe, é, gée goro cè èpà kà du nyaa ma caa kêe?» ");
INSERT INTO priNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Â é tòpi tàra pâ: «Bwa, càcaa gée goro èpà kêe, â càcaa gée goro cè èpà kà du nyaa ma caa kêe. Ê pai bwi kêe, âna pwa, ba na paari ê pàtàma Pwiduée naa gooé. ");
INSERT INTO priNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Ba, na pàara naa bwaa pwaa, âna wâdé na jè pacoo ê pâ wakè kà Pwina é cùruo me. Ba é wâmwünyabwe ê bàutê, â o jèe nye ticè âboro na pâri ma é wakè na bàutê. ");
INSERT INTO priNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Ba, na go bwaa wâni gòropuu, âna go pwéelaa kâra ê gòropuu.» ");
INSERT INTO priNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Â é èdu boo naa napuu, â é biinaimari ê nüru èdu kêe ma puu. Â é tâmi ê du parawére âraporomee i pwi a bwi. ");
INSERT INTO priNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Â é ina têe pâ: «Gà pâra nau nuwagà naa najawé Siloé.» (Siloé, âna pai ina wèe pâ ‘Cùrué’.) Â é pwa wà pwini, â ûna é wâjué me côwâ naa pwârawâ â é jèe nye niâ! ");
INSERT INTO priNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Wà tèpa âboro na rà wâro goro jènereê, ma wà tàpé na rà mu côoê na é mu ila, âna rà pò ma pi-ina tàra pâ: «Gona càcaa wà i pwi âboro na ia é mu nye tà tâaboo burà ila?» ");
INSERT INTO priNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Â rà ina wà pàra tàpé pâ: «Akaé.» Êco na rà ina wà pàra tàpé mwara pâ: «Bwa! Pwacèwii naa wàé.» Â wà pwiibà, âna é tòpi tàra pâ: «Bwa, nye wâgo kaa.» ");
INSERT INTO priNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Â rà tawèerié pâ: «Ico pwini, gà wànau târa ê pai pwa wèe ma gà côojè?!» ");
INSERT INTO priNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Â é tòpi tàra pâ: «Wà pwi jè âboro na nee Iésu, âna é pwa ma go côojè. Ba é bii ê puu, â é tâmi ê du parawére âraporomeeô goo. Â é ina tôo pâ, na go nuwao naa najawé Siloé. Ûna go wàrapwiri, â go nye niâ kaa!» ");
INSERT INTO priNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Â rà ina têe pâ: «Â é wâpà wà pwi âboro-bà?» Â é tòpi pâ: «Îi, câgo caa tâmogòori.» ");
INSERT INTO priNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Rà popa wà i pwi a bwi, pâdari tèpa *Farasaio. ");
INSERT INTO priNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Ba napwa ê tòotù bèepwiri ia é bii i puu na wà Iésu, ma é pwa ma é niâ, âna tòotù pwicîri. ");
INSERT INTO priNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Â rà tawèerié mwara wà tèpa Farasaio, goro ê pai niâ kêe. Â é tòpi tàra pâ: «É tâmi i du parawére âraporomeeô goro dùuru, â go nuwa, êkaa na go niâ.» ");
INSERT INTO priNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Â jèe pâra nau pitadàrù ê pai tâa kàra. Ba rà ina wà pàra tàpé pâ: «Wà pwi âboro na é pwa pwiri, âna câé caa me gée goo Pwiduée! Ba câé caa papwicîri ê *tòotù pwicîri!» Â rà ina wà pàra tàpé pâ: «Bwa, wiàna é pwi âboro èpà, â pwiri càcaa pâri ma é pwa ê pâ *câmu kâra pàtàma Pwiduée.» ");
INSERT INTO priNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Â rà tawèeri mwara i pwi âboro a bwi pâ: «Dà cè pai niimiri'gà naa gooé, na é nama gà niâ?» Â é tòpi tàra pâ: «É pwi *péroféta na é me gée goo wà Pwiduée.» ");
INSERT INTO priNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Wà tèpa pitûâ kà tèpa *Juif, âna càcaa nümarà na rà cèikî pâ, wà pwiibà, âna pwi a bwi béaa. Â rà bwaa nye pwa mwara ma ru me, wà du nyaa ma caa kêe. ");
INSERT INTO priNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Â rà tawèeriru pâ: «Pwi naîu wà pwini? Â âjupâra pâ é bwi gée na aupitèpaé? Â gorodà na é niâ nabà?» ");
INSERT INTO priNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Â ru tòpi tàra pâ: «Üu kaa, é pwi naîbu. Â é pwi a bwi gée na aupitèpaé. ");
INSERT INTO priNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Â é jèe niâ nabà, êco na câbu caa tâmogòori cè majoroé. Â câbu caa tâmogòori mwara cè pwi âboro, cèna é nama wâdé ê du âraporomee. Wâdé na guwà nye tawèerié cai, ba jèe nye pwi âboro maina, â jèe nye pâri ma é ina tàwà!» ");
INSERT INTO priNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Ru ina pwiri, ba wâgotàru goo tèpa pitûâ kà tèpa Juif. Ba rà jèe pitêrerà pâ na rà o pacoo gée na *wâra pitapitiri kàra, êdiri pâ âboro na rà ina pâ wà Iésu, âna é pwi *Mesia na é me nau pa-udò ê Ba. ");
INSERT INTO priNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Wàépwiri ê majoroé ma ru ina wà du nyaa ma caa kêe pâ: «Guwà jèe nye tawèerié cai, ba jèe nye pwi âboro maina.» ");
INSERT INTO priNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Rà jèu todà côwâ wà i pwi a bwi wà tèpa Farasaio. Â rà ina têe pâ: «Gà ina ê âjupâra na ara Pwiduée! Ba bà tâmogòori pâ wà pwi âboro na é nama gà wâdé, âna é pwi âboro èpà.» ");
INSERT INTO priNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Â é tòpi tàra pâ: «Câgo caa tâmogòori pâ, pwiri pwi âboro èpà. Â caapwi co ê pwina go tâmogòori, âna, béaa, âna go pwi a bwi, â nabàni, âna go jèe niâ.» ");
INSERT INTO priNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Â rà ina têe mwara pâ: «Gona dà na é pwa tâgà? É wànau târa ê pai pwa wèe, ma gà niâ?» ");
INSERT INTO priNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Â é tòpi tàra pâ: «Ia go jèe ina tàwà, â tàutàwà na guwà têre! Â gorodà na guwà bwaa jèu tawèeri mwara? Pwiri nümawà na guwà tèpa âboro kêe mwara?» ");
INSERT INTO priNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Â rà pwaé, ma ina têe pâ: «É! Pwiini! Nye wâgà na gà pwi âboro kêe! Ba wàibà, âna bà tèpa pâra naa goo wà *Moosé! ");
INSERT INTO priNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Bà nye tâmogòori pâ é patùra Moosé wà Pwiduée. Â wà pwiibà, âna ji pwi a me géepà?!» ");
INSERT INTO priNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","É ina tàra wà pwiibà pâ: «Nye ité, ba é nama go niâ, êco na wâguwà, âna câguwà caa tâmogòori na é me géewê! ");
INSERT INTO priNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Â jè jèe cau tâmogòori pâ, câé caa têre tèpa âboro èpà wà Pwiduée. Â é têre tàpé na rà papwicîriê, â na rà pwa ê câbawâdé kêe. ");
INSERT INTO priNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Mu nye ticè âboro na é nama é niâ cè pwi jè âboro, na é bwi gée na aupitèpaé! ");
INSERT INTO priNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Â wiàna câé caa me jii Pwiduée wà pwi âboro bèepwiri, â pwiri càcaa pâriê ma é pwa cèna wàrapwiri.» ");
INSERT INTO priNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Â rà putàmuriê wà tèpa Farasaio ma ina têe pâ: «Pwiini! Gà pwa na gà pacâmuribà, wâgà na gà pé pwi a pwa na èpà, gée na aupitèpagà?» Â rà tü têe gée na wâra pitapitiri. ");
INSERT INTO priNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","É têre wà Iésu pâ rà tü tà i pwi ia é bwi, â é pâmariê. Â é ina têe pâ: «Gà nye cèikî naa goo wà *Pwina naîri âboro?» ");
INSERT INTO priNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","«Pwi ukai, wàilàapà pwiri, ba na go cèikî naa gooé?» ");
INSERT INTO priNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","«Gà jèe tàgére côoê, ba wàé na é tàgére patùragà!» ");
INSERT INTO priNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","«Üu, co Pwi Ukai, go cèikî naa googà!» Â é cigòboo ma tùu jùrué na ara Iésu. ");
INSERT INTO priNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","É ina wà Iésu pâ: «Go tèepaa me naani gòropuu, na pinaaitiri tèpa âboro—ba na rà niâ tèpa âboro na rà bwi; â na rà bwi tèpa âboro na rà niâ.» ");
INSERT INTO priNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Na rà têre pwiri wà pàra tèpa Farasaio, na rà gére tâa wê, â rà ina têe pâ: «Wànau? Wàibà mwara âna bà tèpa bwi?» ");
INSERT INTO priNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Â é tòpi tàra pâ: «Wiàna guwà gére tèpa bwi, â pwiri nye gére ticè èpà kàwà. Êco na guwà ina pâ guwà niâ. Êkaa na guwà tà tâa na ê èpà kàwà.» ");
INSERT INTO priNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","É ina tàra mwara wà Iésu pâ: «Guwà têre bwàti, ba go ina tàwà ê âjupâra: Wà pwi âboro na é too wii iti jii ê goropwiinawâ goo nababé kâra mutô, âna é pé pwi a mura, ma pé pwi bâadi. Ba câé caa tò naa ê goropwârawâ. ");
INSERT INTO priNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Â napwa wà pwina é tò naa ê goropwârawâ, âna wàé na é pwi âji a piwéaari mutô. ");
INSERT INTO priNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Â, naa dàuru, âna wà pwi âboro na é wéaari goropwârawâ naa ne âna é tàpiri têe. Â wà diri tèpa mutô kêe, âna rà nye têreina ê pwâratùra kà pwi âji a piwéaari mutô. Â é ina jèpa neerà, â é pacòobérà naa gòroigé. ");
INSERT INTO priNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Ûna é cau pacòobérà diri, â é pâbéaa kàra. Â rà nye cau pwicò kêe, ba rà têreina ê pwâratùra kêe. ");
INSERT INTO priNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Pwacoé ma rà pâra wiâra cè pwi jèpwi. Ba càra caa têreina pwâratùra kêe. Â rà o upié.» ");
INSERT INTO priNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Êco na wà tàpé na rà têre ê ucina bèepwiri kà Iésu, âna càra caa tâmogòori ê pai ina wèe. ");
INSERT INTO priNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","É ina tàra mwara pâ: «Go ina tàwà ê âjupâra pâ: *Wâgo pwi goropwârawâ kâra ê pâ mutô. ");
INSERT INTO priNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Wâru tàpé na rà tèepaa me béaario, na rà tèpa mura, ma tèpa bâadi. Â wà tèpa mutô âna càra caa pitêre dàra. ");
INSERT INTO priNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","*Wâgo pwi goropwârawâ. Wà pwi âboro na é tòme gooò, âna ée udò, â o tâa têe ê *âji wâro. Â o pâri ma é pâra naa na nümee goo wê, â ée mwa tà pâdari uti kêe. ");
INSERT INTO priNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","«Napwa wà pwi a mura, âna é nye tèepaa co, ba na é mura, ma pòtàmwara, ma ténoori. Â wâgo, âna go me, ba na rà wâro wà tèpa âboro, wàilà tèpa mutô kôo. Â o tà tàra ê âji wâro na tâbawêe.» ");
INSERT INTO priNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","«Wâgo, âna go pwi âji a piwéaari ê pâ mutô. Â wà pwi âji a piwéaari ê mutô, âna é panuâ ê wâro kêe ba kàra. ");
INSERT INTO priNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Â wà pwi âboro na é nye po wakè co târa mwani, âna câé caa pwi âji a piwéaari mutô. Ba wiàna é côo ê loup na é tèepaa me, â é panuâ i pâ mutô, â é uru, ba càcaa mutô kêe. Â o utirà ma tadidirirà. ");
INSERT INTO priNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Â é uru wà pwi âboro bèepwiri, ba é pwi a wakè târa mwani co, â càcaa wânümee goo ê pâ mutô.» ");
INSERT INTO priNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","«Üu, wâgo, âna go pwi âji a piwéaari mutô. Â go nye tâmogòori ê pâ mutô kôo, â rà nye tâmogòorio mwara. ");
INSERT INTO priNT_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Ipaiwà naa goobu ma Caa. Ba wà Caa, âna é tâmogòorio, â wâgo, âna go tâmogòori wà Caa. Â go panuâ ê wâro kôo, ba kâra ê pâ mutô kôo. ");
INSERT INTO priNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Â bwaa pwa mwara ê pàra mutô kôo, na càra caa pâ toome naa na ê nababé bèeni. Â wâdé na go mudàra mwara. Â rà o mwa têre ê pwâratùra kôo. Â o mwa caapwi pubu goorà diri, ma caapwi cè pwi a piwéaarirà. ");
INSERT INTO priNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","«Dau wânüma Caa gooò, ba go panuâ ê wâro kôo. Go panuâ, ba go o mwa nye tòpi côwâ. ");
INSERT INTO priNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Nye ticè pwi jè âboro cèna é popa jiio, â go nye naa, gée gooò. Ba pwa tàrù kôo ma go naa ê wâro kôo, â nye pwa tàrù kôo ma go nye popa côwâ. Ba wàépwiri ê aupitûâri kà Caa kôo.» ");
INSERT INTO priNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Rà pitadàrùrà mwara wà tèpa *Juif, gée goro ê pâ popai bèepwiri. ");
INSERT INTO priNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Ba wâru gée goorà na rà ina pâ: «Pwa duée gooé, â é pigù! Cina guwà gére pitêre dèe?!» ");
INSERT INTO priNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Êco na rà ina wà pàra tàpé pâ: «Bwa, ba càcaa wàrapwiri ê pai tùra kà pwi âboro na pwa duée gooé! Ê duée, âna càcaa pâri ma é pwa ma rà niâ ê pâ âboro na rà bwi!» ");
INSERT INTO priNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Pwa ê pwi *tòotù maina na *Iérusaléma—pwi tòotù na pitaniimiri ê pai tàpiri côwâ ê *Wâra pwapwicîri, na pàara aumoo. ");
INSERT INTO priNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Â é tâa goo wà Iésu, â é nye tàgére ipokâa na i Wâra pwapwicîri, naa na ‘Wâ kà *Solomona’, wâ cikòmaa. ");
INSERT INTO priNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Â rà tapitirirà naa gooé wà pàra tèpa Juif, â rà ina têe pâ: «Gà tà ciburà nama bà pibu âboro naa googà, tiagoro wiidà? Wiàna wâgà wà pwi *Mesia, *pwi a pa-udò na bà tapacîê â wâdé na gà inapàpari tâbà!» ");
INSERT INTO priNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Â é tòpi tàra pâ: «Ia go jèe nye ina tàwà, â câguwà caa tòpi. Rà *paâjupâraô ê pâ muru, na ia go pwa naa na nee Caa kôo. ");
INSERT INTO priNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Êco na tàutàwà na guwà cèikî naa gooò, ba câguwà caa tèpa mutô kôo. ");
INSERT INTO priNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","«Ba rà nye têre ê pwâratùra kôo wà tèpa mutô kôo, â go nye côoinarà, â rà nye pâra wiâô. ");
INSERT INTO priNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Â go naa tàra ê *wâro dàra gòiri jaa Pwiduée. Â o càra caa tâmogòori ma rà o bà. Â o nye ticè pwi jè âboro cèna o pâriê ma é poparà gée na-araraîô. ");
INSERT INTO priNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Ba wà Caa kôo na é panuârà tôo, âna é dau maina awé jii diri ê pâ muru. Â nye ticè pwi jè âboro cèna o pâriê ma é popa cè jè muru, gée na-araraî Caa. ");
INSERT INTO priNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Â napwa wàibu ma Caa, âna bu nye caapwi.» ");
INSERT INTO priNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Ûna rà têre pwiri wà tèpa âboro, â rà jèu tòri côwâ ê pâ atü, ba na rà catàmwereê goo. ");
INSERT INTO priNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Â é ina tàra wà Iésu pâ: «Dau wâru ê pâ muru na wâdé, na go pwa na arawà—muru na me gée goo wà Caa. Â gona dà cè pwina gére nümawà dàra catàmwaraô goo?» ");
INSERT INTO priNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Â rà tòpi têe pâ: «Pwiini, càcaa goo cè wakè na wâdé na gà pwa. Nye gée goo co na gà inabaèpà wà Pwiduée. Ba gà nye pwi âboro, â nümagà naa wâgà Pwiduée!» ");
INSERT INTO priNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","É ina tàra pâ: «Jèe wii naa na *Naèà kà Pwiduée pâ: Guwà tèpa ‘pwiduée’. ");
INSERT INTO priNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Â é ina pwiri tà tèpa jojoorowà na rà tòpi ê Naèà! Â jè tâmogòori diri pâ càcaa pâri ma câtùra ê pwina jèe wii naa na ê Naèà. ");
INSERT INTO priNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Napwa wâgo, âna é pitòrigario wà Pwiduée Caa, â é cùruo me naa gòropuu, â go ina pâ, go Pwina naîê. Â wiàna é ina wà Pwiduée Caa tà tèpa âboro pâ, rà tèpa ‘pwiduée’ â cina guwà putàmu naa gooò, wiàna go ina pâ wâgo Pwina naîê? ");
INSERT INTO priNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","«Wiàna câgo caa pwa ê pâ wakè kà Caa kôo, â guwà cibwaa cèikî naa gooò! ");
INSERT INTO priNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Êco na go nye tàgére pwa; â wâdé na guwà cèikî. Ba wiàna pwacoé tàwà ma guwà cèikî naa gooò; â guwà cèikî naa gooò gée goo ê pâ muru na go pwa. Â, na wàrapwiri, â guwà tâmogòori bwàti pâ go wâgoo Caa, â é wâgooò.» ");
INSERT INTO priNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Gée goo pwiri, â rà pimudàra mwara cè naigé ba na rà tâjùrué. Êco na é nye uru taaci. ");
INSERT INTO priNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Géewê, â é jèu pâra côwâ wà Iésu, naa na ére gée côwâ kâra nairiwâ Ioridano, wâna na ia é *piupwaa béaa naawê wà Ioane. Â é tàpo tâa wê. ");
INSERT INTO priNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Â rà medarié pâ âboro na wâru, â rà pi-ina tàra pâ: «Wà Ioane, âna câé caa pwa cè jè *câmu kâra pàtàma Pwiduée, êco na po coo diri ê pâ popai, na ia é ina naa goo pwi âboro bèeni!» ");
INSERT INTO priNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Â dau wâru ê pâ âboro wê, na rà cèikî naa goo Iésu. ");
INSERT INTO priNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","2","Pwa pwi jè âboro, na nee Lacaro. Â rà tâa Bétani ma du naigé kêe, wà Maria ma Marthe. (Wà Maria, âna wà i tô ilàri na ia é wicèpwiri ê jawé ûrea naa gòro â wà Pwi Ukai Iésu, â câtùra goro wàrapûruê.) É dau maagé wà Lacaro, ");
INSERT INTO priNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","â wà du duajii ilàri, âna ru panuâ pâ pwi jè âboro dà Iésu, nau ina têe pâ: «Pwi Ukai, gà me wài, ba wà i pwi âji béegà, âna é maagé!» ");
INSERT INTO priNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","5","Wà Iésu, âna é dau wânümee goo wà Marthe ma Maria, ma Lacaro. Êco na, ûna é têre ê popai, â câé caa pò ma pâra. Â é ina pâ: «Ê maagé kà Lacaro, âna o câé caa bà goo. Gée goo pwiri, â o pwamaina Pwiduée, ma paari ê pai muugère kêe. Â o paari ê pai muugère kôo mwara, Pwina naîê.» ");
INSERT INTO priNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Â é bwaa nye tâa wê, naa na ârailu tòotù mwara. ");
INSERT INTO priNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Gée na càùé, â é ina tà tèpa *câmu kêe pâ: «Wâdé na jè pâra côwâ naa *Judée.» ");
INSERT INTO priNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Â rà tòpi têe pâ: «Pwi Ukai, bwaa càcaa pé gòiri, na rà pibu naigé wà pàra tèpa *Juif naa Judée, ba na rà catàmwaragà. Â nümagà dàra wâjué côwâ naawê?» ");
INSERT INTO priNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Â é ina tàra pâ: «Wànau, càcaa 12 ineretòotù na é té na tòotù? Wà pwi âboro na é pâra na bwaa pwaa, âna o câé caa cigòtù âê, ba bwaa pwéelaa. ");
INSERT INTO priNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Êco na, wiàna é pâra na ne, â o cigòtù âê, ba bàutê.» ");
INSERT INTO priNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Gée na càùé, â é ina tàra pâ: «É jèe puu wà Lacaro, pwi béejè, â go o pâra nau patàcîê.» ");
INSERT INTO priNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Â rà ina têe pâ: «Wâdé, co Pwi Ukai, ba wiàna é gére puu co, â ée nye wâdé!» ");
INSERT INTO priNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Ba càra caa tâmogòori pâ, é ina tàra pâ é bà wà Lacaro. Rà niimiri pâ é nye âji puu. ");
INSERT INTO priNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Â é inapàpari tàra pâ: «Bwa, é jèe maagé. ");
INSERT INTO priNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Êco na go ipwàdée goowà, na câgo caa tâa jaaé napwiri. Ba na wàrapwiri â guwà o mwa côo ê pwina go pwa, â guwà mwa cèikî naa gooò. Guwà me! Ma jè pâra darié!» ");
INSERT INTO priNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Â é ina wà Toma (jè nee ‘Bérepidu’) tà tèpa câmu bée pâ: «Jè pâra mwara, ba na jè cau bà naima ma wà Pwi Ukai.» ");
INSERT INTO priNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Ûna é pâmwünyabweri Bétani wà Iésu, â é têre pâ jèe ârapàpé tòotù kà Lacaro na auipwàni. ");
INSERT INTO priNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","19","Â ru imuru pwi bàraru wà Marthe ma Maria, â dau wâru tèpa âboro gée *Iérusaléma, na rà medariru ba na rà patàmarù-ru. (Ba Bétani, village kàru, âna wâmwünyabweri Iérusaléma, wâpâ na âracié kilomètres.) ");
INSERT INTO priNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","É têre wà Marthe pâ é jèe tèepaa wà Iésu, â é cimadò, â é pâra caraé naa gòro naigé. Â wà Maria, âna é nye tà tâa wâ. ");
INSERT INTO priNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Â é ina tà Iésu wà Marthe pâ: «Au! Pwi Ukai, wiàna gà nye gére tâa ni, â pwiri câé caa gére bà wà pwi bàrao! ");
INSERT INTO priNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Êco na go tâmogòori pâ é nye naa tâgà wà Pwiduée êdiri pâ muru na gà o mwa ilari jiié ni.» ");
INSERT INTO priNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","É tòpi têe pâ: «Ée jèe wâro côwâ gée na aubà wà pwi bàragà.» ");
INSERT INTO priNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Â é ina têe wà Marthe pâ: «Üu, go cèikî pâ ée mwa wâro côwâ gée na aubà, na rà wâro côwâ wà tèpa bà, na pwi Tòotù pwicò.» ");
INSERT INTO priNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Â é ina têe wà Iésu pâ: «*Wâgo pwina é naa ê wâro, ma pawâro côwâ tèpa âboro. Wà pwi âboro na é cèikî naa gooò, âna wiàna é bà, â ée mwa nye wâro côwâ. ");
INSERT INTO priNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Â wà pwi âboro na é wâro ma cèikî naa gooò, âna o câé mwa caa bà dàra gòiri. Gona gà nye cèikî naa goro ê popai bèepwiri?» ");
INSERT INTO priNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Â é tòpi têe pâ: «Üu kaa, co Pwi Ukai, go nye cèikî pâ, wâgà pwi *Mesia, wà *Pwina naî Pwiduée, na ée mwa tèepaa naani gòropuu.» ");
INSERT INTO priNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Nabwé, â wà Marthe, âna é pâra nau pitodà pwàniri Maria, tô jiié. Â é ina têe pâ: «É jèe tèepaa wà pwi a pwa pupûra, â é todàgà.» ");
INSERT INTO priNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Â é nye cimadò kaa wà Maria, â é pâdari Iésu. ");
INSERT INTO priNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Ba bwaa câé caa pâ tèepaa me naa na village, â é bwaa tâa, wâna na ipitiru naawê ma Marthe. ");
INSERT INTO priNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Wà tèpa Juif na rà tâa wâ, na rà patàmarù Maria, âna rà côoê na é piwàcî còobé. Â rà pâra wiâê. Ba rà niimiri pâ é pâra nau i, nacârü. ");
INSERT INTO priNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Ûna é tèepaa medari Iésu wà Maria, â é cigòboo ma tùu jùrué na araé, â é ina têe pâ: «Au! Pwi Ukai, wiàna gà nye gére tâa ni, â pwiri câé caa gére bà wà pwi bàrao!» ");
INSERT INTO priNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","É côoê wà Iésu, na rà gére i ma tèpa Juif na rà pâra wiâê. Â dau gùmagù pwâranümee, â é watàu. ");
INSERT INTO priNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Â é tawèerirà pâ: «Guwà pwàniriê naapà?» Â rà ina têe pâ: «Pwi Ukai, me ma gà côo.» ");
INSERT INTO priNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Â é i wà Iésu. ");
INSERT INTO priNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Â rà ina wà tèpa Juif pâ: «Au! Guwà côo, é po dau niimiri wà Lacaro!» ");
INSERT INTO priNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Êco na rà picocoorié wà pàra tàpé ma pi-ina tàra pâ: «Wà pwiibà, âna é pwi a nama é niâ wà pwi a bwi. Â gona càcaa pâriê ma é pwa ma câé caa bà wà Lacaro, pwi bée?» ");
INSERT INTO priNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","39","Dau gùmagù pwâra-nüma Iésu. Â é pâra naa goo pé pwâramara-atü, wâna na ia ipwàniri wà Lacaro naawê. Â é ina tàra pâ: «Pwùru tâjii ê atü.» Ba i pwâramara-atü, âna târi goro atü. Êco na é ina wà Marthe, wà tô naigé kà pwi a bà, pâ: «Ai! É jèe gére wâbu, co pwi ukai, ba jèe ârapàpé tòotù kêe wê!» ");
INSERT INTO priNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Â é ina têe wà Iésu pâ: «Gona câgo caa ina tâgà pâ, wiàna gà cèikî, â gà o côo ê pai maina ma muugère kà Pwiduée?» ");
INSERT INTO priNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Â rà pwùru tâjii i atü. Â é niâ too naa napwéretòotù wà Iésu, â é ina pâ: «Caa wée, go ipwaolé tâgà, ba gà têreô! ");
INSERT INTO priNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Wâgo, âna go nye tâmogòori pâ gà nye têreô taaci. Â go ina pwiri, goo tàpé na rà cibèepio, ba na rà o cèikî pâ, wâgà pwi a cùruo me.» ");
INSERT INTO priNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Â é tomara too pâ: «Lacaro, còobé boome!» ");
INSERT INTO priNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Â é còobé wà i pwi a bà! Â napwa ê du îê ma du âê, âna pii târamiri goro noo kâra imwaano na gòri. Â ê naporomee, âna târamiri goro pwi jè imwaano. Â wà Iésu, âna é ina tà tèpa âboro wê pâ: «Guwà tipié ma panuâê, ma é pâra.» ");
INSERT INTO priNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Wà tèpa Juif na rà tèepaa dari Maria, âna rà côo ê pwina é pwa wà Iésu. Â wâru gée goorà na rà cèikî naa gooé. ");
INSERT INTO priNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Êco na wà pàra tàpé, âna rà pâdari tèpa *Farasaio, â rà piwiâ tàra ê pwina é pwa. ");
INSERT INTO priNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Â wà tèpa caa kà tèpa pwa *ârapwaailò ma wà tèpa Farasaio, âna rà panaimari ê *wâratûâ maina, â rà pi-ina tàra pâ: «Jè o pwa dà? Gà côo, jèe po dau wâru ê pâ *câmu kâra pàtàmee na é pwa wà pwini. ");
INSERT INTO priNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","«Â wiàna jè nye tà panuâê, â rà jèe nye po cèikî diri naa gooé ê pâ âboro. Â rà o tèepaa wà tèpa coda *roma, â rà o ténoori ê *Wâra pwapwicîri kâjè, ma ê Ba kâjè!» ");
INSERT INTO priNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Â é tapoo tùra wà pwi jè âboro gée goorà, na nee Caïphe. Wàé na é pwi *ukai kà tèpa pwa ârapwaailò na naja bèepwiri. Â é ina tàra pâ: «Tàpéeni! Po dau ticè na guwà tâmogòori! ");
INSERT INTO priNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Wànau? Câguwà caa côoina ê pwina é âjimuru ba kâjè? Wâdé na é bà pwi caapwi âboro, ba kâra ê Ba, ba na o cibwaa ténoori diri ê Ba kâjè!» ");
INSERT INTO priNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","(Ûna é ina pwiri, âna câé caa tâmogòori pâ é nye tàmara ina béaa pâ, ée mwa bà wà Iésu ba kâra ê Ba. Ba nye wà Pwiduée kaa na é tùra gooé gée goo na é pwi ukai kà tèpa pwa ârapwaailò na naja bèepwiri. ");
INSERT INTO priNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Â jèpwi mwara, âna ê pai bà kà Iésu, âna càcaa ba kâra ê Ba kà tèpa Juif co. É bà, ba na é dànaimari ma rà caapwi, êdiri wà tèpa naî Pwiduée, na rà jèpa tâa pâ.) ");
INSERT INTO priNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Gée na càùru ê ipitiri kàra bèepwiri, âna rà tapoo pibu naigé wà tèpa pitûâ kà tèpa Juif, ba na rà pòtàmwara Iésu. ");
INSERT INTO priNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Â géewê, â é tàpo coo, goro pâra naa nabibiu kà tèpa âboro. Â é pâra naa Éfraïm, wâmwünyabweri namaré. Â rà caatâa wê ma tèpa câmu kêe. ");
INSERT INTO priNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Ûna jèe wâmwünyabwe ê *Paséka, tòotù maina kà tèpa Juif, â dau wâru ê pâ âboro na rà me gée na pâ jèpa ére, naa Iérusaléma. Ba nümarà na rà pwa ê pâ ‘pwapwicîri târa pai *pinuwa’, béaari i tòotù maina. ");
INSERT INTO priNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Ûna rà tâa na Wâra pwapwicîri, â rà mudà Iésu, êco na càra caa pâmariê â rà pi-ina tàra pâ: «Dà cèna guwà niimiri? Gona ée mwa me naa goro i *tòotù maina, é…?» ");
INSERT INTO priNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Ba wà tèpa caa kà tèpa pwa ârapwaailò ma wà tèpa Farasaio, âna rà ina ba gòo tà diri tèpa âboro pâ: «Wiàna guwà côo na é wêe wà Iésu, â guwà nama inapàpari tâbà, ba na bà tâjùrué.» ");
INSERT INTO priNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Bwaa 6 tòotù béaari ê *Paséka, tòotù maina kà tèpa *Juif. Â é pâra wà Iésu naa Bétani. Bétani, âna village kà Lacaro, wà pwi ia é pawâroé côwâ gée na aubà wà Iésu. ");
INSERT INTO priNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Â rà ija wê ma wà Lacaro, na é pwi bée tèpa tâa goro taapà. Â wà Marthe, âna é tô a picia èrà ma wâdoorà. ");
INSERT INTO priNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Â napwa naa goo wà Maria, âna é popa jè wâra jawé, na pwaai goro jawé ûrea—pwi jawé na dau maina ê wâri wèe. Â é wicèpwiri naa gòro ê du â Iésu, â é câtùra goro wàrapûruê. Â po dipitiri i wâ i ûraaê. ");
INSERT INTO priNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Â càcaa wâdé tà Judas Iscariote, pwi jè ârapàara tèpa *câmu kà Iésu—wà pwina ée mwa ipwa tûâ tà Iésu. Â é ina pâ: ");
INSERT INTO priNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","«Gorodà na càcaa icuri i jawé ûrea bèeni, ma o naa ê wâri wèe tà tàpé na ticè kàra? Ba wâri wèe, âna pâ miliô!» ");
INSERT INTO priNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Câé caa ina pwiri gée goro cè pai meaari kêe tàpé na ticè kàra. Â é ina ba pé pwi a mura. Ba é pwi a tà pa wàra i wâra mwani kàra, â é mu nye tàpo pa gée goro ê mwani na tòpò naa na. ");
INSERT INTO priNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Â é ina wà Iésu pâ: «Naaê! Ba é jèe tàmara pwa ê pwi bèepwiri, târa ê pwi tòotù na o ipwàniriô na. ");
INSERT INTO priNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Guwà o nye tà ciburà tâa ma tàpé na ticè kàra, êco na wâgo, âna o câgo caa tà ciburà tâa jaawà.» ");
INSERT INTO priNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Dau wâru tèpa âboro na rà têre pâ é tâa Bétani wà Iésu, â rà pâra naawê, ba nümarà na rà côoê. Â rà pâra mwara ba na rà côo Lacaro, wà pwi ia é pawâroé côwâ gée na aubà. ");
INSERT INTO priNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Â rà pitùra wà tèpa caa kà tèpa pwa *ârapwaailò, ba na rà pwa ma pòtàmwara mwara wà Lacaro. ");
INSERT INTO priNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Ba wàrapwiri gooé, â jèe dau wâru wà tèpa Juif, na rà pâra jiirà, â rà cèikî naa goo Iésu. ");
INSERT INTO priNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Na dàuru kêe, âna wà tèpa âboro na rà me naa *Iérusaléma naa goro ê pwapwicîri kâra Paséka, âna rà têre pâ wà Iésu âna é gére toome mwara. ");
INSERT INTO priNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Â rà còobé jii ê ville, â rà dàciò ê pâ îri upwâra ba na rà pwamainaê â rà pâra caraé. Â rà uu ma ina pâ: «Hosana ma cidòri! Pwamaina Pwiduée! Cidòri nyuâa pwi âboro, na é me na nee Psaume 118.26 —wà Pwi Ukai naa *Isaraéla!» ");
INSERT INTO priNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Â é popa ê nari buriko wà Iésu, â é tâa gòé. Wàra na jèe wii naa na ê *Tii Pwicîri pâ: ");
INSERT INTO priNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Cibwaa nama wâgotâgà, co tô èpo *Siona, ville Iérusaléma! É tèepaa me wà Pwi Ukai'gà. É tâa gò ji nari buriko. Zakarie 9.9 ");
INSERT INTO priNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Ba diri ê pâ muru-bà, na rà pacoo wà tèpa âboro ba kà Iésu, âna jèe tàmara ina béaa naa na Tii Pwicîri. Êco na, na pwi tòotù-bà, âna càra caa tâmogòori wà tèpa câmu kêe. Â rà mwa nye tà tâmogòori gée na càùé—na pàara na é wâro côwâ wà Iésu gée na aubà, ma paari ê pai maina ma muugère kêe. ");
INSERT INTO priNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","18","Dau wâru tèpa âboro na rà pâra mariê na pwi tòotù-bà. Ba wà tàpé na rà côoê na ia é pawâro côwâ wà Lacaro, âna rà nye dau pwa jèkutâ goo. ");
INSERT INTO priNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Napwa naa goo wà tèpa *Farasaio, âna rà pi-ina tàra pâ: «Gà côo, o jèe nye ticè cè pwina pâri ma jè pwa. Ba rà jèe nye pâra wiâê diri ê pâ âboro!» ");
INSERT INTO priNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Na Iérusaléma, âna pwa pàra tàpé na càra caa tèpa Juif, na rà jèe tòpi ê pwapwicîri kà tèpa Juif. Â rà me nau pwamaina wà Pwiduée na pwi tòotù Paséka. ");
INSERT INTO priNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Â rà me burà wà Filipo, pwi âboro gée Bethsaïda, wâ Galilée. Â rà ina têe pâ: «Pwi ukai, nümabà na bà côo Iésu.» ");
INSERT INTO priNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Â é pâra wà Filipo, â é ina tà André, â ru pâra nau ina tà Iésu. ");
INSERT INTO priNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Â é ina tàra diri wà Iésu pâ: «O jèe tèepaa ê tòotù na ipwamaina *Pwina naîri âboro. ");
INSERT INTO priNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Guwà têre bwàti, ba go ina tàwà ê âjupâra pâ: Ê pwi pwâra blé na é tûuboo naa napuu, âna wâdé na é wai, ba na é naa cè pwâra blé na wâru. Ba wiàna càcaa wai, â o nye tà wàé co. ");
INSERT INTO priNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","«Wà pwi âboro na wânümee târa ê wâro kêe, âna é tubatiàu. Â wà pwi âboro na dau wânümee goo Pwiduée, jii ê wâro kêe naani gòropuu, âna wà pwiibà, âna câé caa tubatiàu ê wâro kêe. Â o mwa tâa têe ê *wâro dàra gòiri jaa Pwiduée. ");
INSERT INTO priNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","«Wà pwi âboro na nümee na é piênawéna kôo, âna wâdé na é me wiâô. Â wâna na go tâa wê, âna bu caatâa wê ma wàé. Â ée mwa nye tòpi ê pumara wakè kêe jii Caa.» ");
INSERT INTO priNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","É ina mwara wà Iésu pâ: «É pikîri nabà ê pwâranümoo. Gona go mwa ina pâ: “Caa, upao jii ê picâri kâra ê tòotù bèeni”? Bwa, ba go jèe tèepaa naani gòropuu, ba na go pacoo ê pwi tòotù bèeni. ");
INSERT INTO priNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","29","Caa, paari pâ wâgà Pwiduée na gà maina!» Wà tàpé na rà tâa wê, âna rà têre ê pwâratùra gée napwéretòotù na ina pâ: «Go jèe paari pâ, wâgo Pwiduée naa na pai maina ma muugère kôo. Â go bwaa nye tà wàrapwiri mwara.» Â rà niimiri wà pàra pwi pâ, é kûu i tikakara. Êco na rà ina pàra tàpé pâ: «Bwa! É patùraé ê jè *angela!» ");
INSERT INTO priNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Â é ina tàra wà Iésu pâ: «I pwâratùra bèepwiri, âna càcaa me ba kôo, â wàrapwiri goowà. ");
INSERT INTO priNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","O jèe nabàni, na é pitèi pâ âboro gòropuu bèeni wà Pwiduée. Â é tü còobé naaboo gòroigé wà *Caatana, pwi ukai kâra gòropuu bèeni. ");
INSERT INTO priNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Â wiàna naaô too géeni gòropuu, â go mwa dàti medario ê pâ âboro diri.» ");
INSERT INTO priNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Ûna é ina pwiri, â é jèe gére inapàpari tàra ê pai pwa kàra têe, ma rà o nama é bà. ");
INSERT INTO priNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Rà ina têe ê pâ âboro pâ: «Ina naa na pâ tii goro *Naèà pâ wà pwi *Mesia, âna é nye tà wâro dàra gòiri awé. Â cina gà ina pâ, o wâdé naa naatoo géeni gòropuu wà Pwina naîri âboro? Â gére wàilàapà ê Pwina naîri âboro bèepwiri?» ");
INSERT INTO priNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Â é tòpi tàra pâ: «O jèe càcaa tà gòiri, na bwaa tà tâa jaawà i pwéelaa. Â wâdé na guwà pâra, ûna é bwaa tâa jaawà, ba na o câé caa papòwà ê bàutê. Ba wà pwi âboro na é pâra na ê bàutê, âna câé caa tâmogòori wâna na é pâ naawê. ");
INSERT INTO priNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Tòpi ê pwéelaa, ûna é bwaa tâa jaawà, ba na guwà tèpa âboro kâra pwéelaa.» Ûna é ina pwiri wà Iésu, â é pâra jiirà, â é picârü goorà. ");
INSERT INTO priNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Wâru pâ *câmu kâra pàtàma Pwiduée na é pwa wà Iésu, na ara tèpa Juif. Êco na càcaa wâru tàpé na rà cèikî naa gooé. ");
INSERT INTO priNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Â jèe coo ê popai na é ina biu wà Isaia, pwi *péroféta, pâ: Pwi Ukai, Pwiduée, wàilàapà na cèikî naa goo popai kâbà? Gà paari tâî pàtàma'gà ma nii'gà? Ésaïe 53.1 ");
INSERT INTO priNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Â o pwacoé mwara ma rà cèikî, ba é jèe nabwé ina wà Isaia, pâ: ");
INSERT INTO priNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Âraporomeerà na bwi; pwâranümarà na gòo. Ba wakè kà Pwi Ukai —Pwi Ukai Pwiduée na nama rà wàrapwiri. Ba péa rà biirà, ma medarié côwâ. Péa nama tiàu pâ maagé kâra Ba. Ésaïe 6.10 ");
INSERT INTO priNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","É ina pwiri wà Isaia goo Iésu, ba é jèe tàmara côo ê pai maina ma muugère kêe. ");
INSERT INTO priNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Êco na pwa pàra tàpé na rà cèikî naa gooé, tiagoo pàra tèpa pitûâ kà tèpa Juif mwara. Caapwi co na càra caa inapàparirà, ba wâgotàra goo tèpa Farasaio. Ba rà péa pacòobérà gée na *wâra pitapitiri. ");
INSERT INTO priNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Ba wâdé tàra, ê pai pwamainarà kà tèpa âboro, jii ê pai pwamainarà kà Pwiduée. ");
INSERT INTO priNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","É tomara too wà Iésu pâ: «Wà pwina é cèikî naa gooò, âna câé caa cèikî naa gooò co, â é cèikî mwara naa goo Pwina é cùruo me. ");
INSERT INTO priNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Â wà pwi âboro na é côoô, âna é côo mwara Pwina é cùruo me. ");
INSERT INTO priNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Wâgo, âna go pwi pwéelaa, na go me naa na gòropuu, ba na câé caa tâa na bàutê cè pwi jèpwi cèna é cèikî naa gooò. ");
INSERT INTO priNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","«O càcaa wâgo na go pwa wârimuru tà tàpé na rà têre ê popai kôo, â càra caa pâra wiâra. Ba câgo caa me nau pwa wârimuru târa pâ âboro gòropuu. Â go me nau pa-udòrà ma naa tàra ê *âji wâro. ");
INSERT INTO priNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","«Wà pwi âboro na tàutêe gooò, ma câé caa tòpi ê pâ popai kôo, âna o pitèié na Bénabwé tòotù, gée goro ê pâ popai na go ina. ");
INSERT INTO priNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Ba câgo caa po ina gée gooò ê pâ popai-bà. Â wà Caa na é cùruo me, âna é nye dàbacoo tôo pâ namuru, na go me nau ina ma picémara. ");
INSERT INTO priNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Â go nye tâmogòori pâ ê aupitûâri kêe, âna naa ê wâro dàra gòiri jaaé. Üu, ê pâ popai na go ina, âna ê pwina é ina tôo wà Caa.» ");
INSERT INTO priNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","2","Jèe pwi bénabwé tòotù béaari ê tòotù *Paséka. Â rà ija na bàrane wà Iésu ma wà tèpa *câmu kêe. É jèe tâmogòori wà Iésu pâ, é jèe tèepaa ê pàara na na é pâra na, géeni gòropuu naa jaa wà Pwiduée Caa. Â mu nye dau wânümee goo pâ âboro kêe na rà tâa ni gòropuu. Ba nye tà wânümee goorà tia pwâadèreè. Napwa naa goo wà Judas Iscariote, pwina naî Simona, âna wà *Caatana, âna é jèe nabwé tòpò naa na pwâranümee jè auniimiri târa ma é pwa tûâ tà Iésu. ");
INSERT INTO priNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Wà Iésu, âna é jèe nye tâmogòori pâ é nye me gée jaa Caa, â ée mwa wâjué côwâ naa jaaé. Â é tâmogòori mwara pâ é jèe tòpi jii Pwiduée ê pitûâ naa goro diri ê pâ muru. ");
INSERT INTO priNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Na rà bwaa gére ija, â é cimadò, â é tòpwùtù ê ârabwée kêe na tâa géeme côwâ â é pa ê jè imwaano, â é piié goo. ");
INSERT INTO priNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Â é wicèpwiri ê jawé naa na wâra jawé, â é pwa ma nuwa ê â tèpa câmu kêe. Â é câbaigé goro i imwaano na ia é piié goo. ");
INSERT INTO priNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Ûna é tèepaa pâ naa jaa Simona Pétéru, â é ina têe wà Pétéru pâ: «Bwa, Pwi Ukai, càcaa pâri naa gooò na gà nuwa ê du âô.» ");
INSERT INTO priNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Â é tòpi têe pâ: «Câgà caa tâmogòori nabà ê pwina go pwa tâgà, êco na gà o mwa nye tà tâmogòori.» ");
INSERT INTO priNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","«Bwa! O câgà mwa caa nuwa ê du âô!» «Wiàna câgo caa nuwa ê du âgà, â o nye ticè kâgà jaao.» ");
INSERT INTO priNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","«Wiàna wàrapwiri, co Pwi Ukai, â càcaa êco ê du âô na gà nuwa, â wâdé mwara na ê du îô, ma pûruô mwara!» ");
INSERT INTO priNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Â é tòpi têe wà Iésu pâ: «Wà pwi âboro na é jèe ipitoo, âna é jèe pwéelaa diri, â càcaa pâri ma jè nuwaé diri. Jè po nuwa co ê du âê. Â wâguwà âna guwà jèe pwéelaa diri. Êco na càcaa wâguwà diri.» ");
INSERT INTO priNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Ba é jèe tâmogòori wà pwina ée mwa ipwa tûâ têe. Êkaa na é ina pâ: «Câguwà caa cau pwéelaa diri.» ");
INSERT INTO priNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Ûna é jèe cau nuwa diri ê pâ ârà, â é coona côwâ ê ârabwée kêe, â é tâaboo côwâ naa goro taapà, â é ina tàra pâ: «Gona guwà nye câmogòori ê pwina go pwa tàwà? ");
INSERT INTO priNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Ba guwà ina tôo pâ ‘pwi a pwa pupûra’ ma ‘Pwi Ukai’, â guwà nye âjupâra, ba nye wâgo kaa. ");
INSERT INTO priNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Â wiàna go nuwa ê âwà, wâgo Pwi Ukai ma pwi a pwa pupûra, â wâdé mwara na guwà mwa tà pinuwa ê âwà jècaa. ");
INSERT INTO priNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Ba go naa tàwà nabà ê câmu, ba na guwà ipwacèwii ê pwina go paari tàwà. ");
INSERT INTO priNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Guwà têre bwàti: Wà pwi ênawéna âna câé caa piwéna jii pwi ukai kêe. Â càcaa pwamuru naa goo wà pwi âboro na cùrué, jii wà pwi a cùrué. ");
INSERT INTO priNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","«Â nabà, âna guwà jèe tâmogòori ê pâ pwi bèepwiri. Â wâdé na guwà wârori, â guwà o ipwàdée.» ");
INSERT INTO priNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","«Câgo caa ina pwiri naa goowà diri, ba go nye câmogòori tàpé na go nye càwairà. Êco na wâdé na é coo ê auwii naa na ê Tii Pwicîri, pâ: Wà pwina bu pi-ija naima ma wàé i poloa, âna wàé na é jèe cicarao. ");
INSERT INTO priNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","«Nabàni, âna go ina pwiri tàwà, na bwaa càcaa pâji tèepaa. Ba wiàna coo, âna guwà o cèikî pâ, ‘*Wâgo na go napwiri, nabà, â dàra gòiri awé’. ");
INSERT INTO priNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Go ina tàwà ê âjupâra pâ: Wà pwina é tòpi pwi âboro na go cùrué, âna é tòpio mwara. Â wà pwina é tòpio, âna é tòpi mwara Pwina é cùruo me.» ");
INSERT INTO priNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Ûna é ina diri pwiri wà Iésu, â dau gùmagù ê pwâranümee. Â é ina tàra pâ: «Guwà têre bwàti: Wà pwi jè ârapàarawà âna ée mwa pwa tûâ tôo.» ");
INSERT INTO priNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Â rà piucârirà wà tèpa câmu kêe, â rà pitawèerirà pâ wàilàapà na é inaê. ");
INSERT INTO priNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","24","Â wà Simona Pétéru, âna é pwa ineremuru tà pwi a câmu na wânüma Iésu gooé, ba na é tawèeri Iésu pâ, wàilàapà na é inaê. Ba wà pwiibà âna é tâa goro jènere Iésu, naa goro taapà. ");
INSERT INTO priNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Â é tabiié pâ dà Iésu, wà pwi a câmu bèepwiri, â é ina têe pâ: «Pwi Ukai, wàilàapà?» ");
INSERT INTO priNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Â é tòpi têe pâ: «Wà pwi âboro na go o naa têe ê noo kâra poloa na go nuwa.» Â é pa i noo kâra poloa, â é nuwa, â é naa tà Judas, pwi naî Simona Iscariote. ");
INSERT INTO priNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Ûna é pa i noo kâra poloa wà Judas, â é nye tò kaa naa gooé wà Caatana. Â é ina têe wà Iésu pâ: «Ê pwina gà pwa, âna gà pwa wài!» ");
INSERT INTO priNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Â nye ticè ârapàararà, cèna é tâmogòori pâ cina é ina wàrapwiri tà Judas. ");
INSERT INTO priNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Ba rà niimiri wà pàra tàpé pâ é ina têe wà Iésu pâ: «Gà wâri cè muru cèna pârijè târa i *tòotù maina» é, «Gà pa ê mwani, â gà naa tà tàpé na ticè kàra.» Ba wà Judas, âna pwi a tà pa wàra ê wâra mwani kàra. ");
INSERT INTO priNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Ûna é ija diri i noo kâra poloa na ia é naa têe wà Iésu, â é nye còobé kaa wà Judas, na jèe bàutê. ");
INSERT INTO priNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","32","Ûna é còobé wà Judas, â é ina tàra wà Iésu pâ: «Nabàni, âna o jèe paari ê pai maina ma muugère kôo, wâgo, *Pwina naîri âboro, â o côo naa gooò ê pwényuâa kà Pwiduée. Â wiàna wàrapwiri, â nye wà Pwiduée kaa, na ée mwa paari ê pwényuâa kôo. Â ée jèe nye tapoo paari.» ");
INSERT INTO priNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","«Tèpa âji naîô, jèe càcaa gòiri ji pàara na go bwaa tâa jaawà. Â guwà o mudòo, êco na càcaa pâri ma guwà tèepaa pâ naa na go pâra naawê. Êkaa pwiri i pwi ia go jèe ina mwara tà tèpa *Juif. ");
INSERT INTO priNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Go naa tàwà ê naèà na bwaa âmuê, pâ, guwà pimeaariwà, pwacèwii ê pai mu meaariwà kôo. ");
INSERT INTO priNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Ba wiàna guwà pimeaariwà, â rà mwa tâmogòori diri ê pâ âboro pâ, guwà tèpa câmu kôo.» ");
INSERT INTO priNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","É ina têe wà Simona Pétéru pâ: «Pwi Ukai, gona gà pâ naapà?» Â é tòpi têe wà Iésu pâ: «Wâna go pâra naawê, âna càcaa pâ pâri nabà, ma ju capai pâra naawê. Êco na gà mwa nye tà me wiâô na cè jè pàara.» ");
INSERT INTO priNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Â é ina mwara wà Pétéru pâ: «Pwi Ukai, gorodà na càcaa pâri ma go pâra wiâgà nabàni? Ba o câgo caa piwâ na go panuâ wâro kôo ba kâgà.» ");
INSERT INTO priNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Â é tòpi têe wà Iésu pâ: «Gona gà o panuâ wâro'gà ba kôo? Go ina tâgà ê âjupâra pâ: Wiàna bwaa câé caa to ê ja, âna gà o jèe wacié pigòo pâ, câgà caa tâmogòorio.» ");
INSERT INTO priNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","É ina mwara wà Iésu tà tèpa *câmu kêe pâ: «Guwà cibwaa nama gùmagù ê pwâranümawà. Wâdé na guwà cèikî naa goo Pwiduée, â guwà cèikî naa gooò mwara. ");
INSERT INTO priNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Ba dau wâru pâ wâ wânidò na pwârawâ kà Caa kôo. Â go pâ nau pwabwàti cè autâa kàwà. Ba wiàna càcaa gére âjupâra, â pwiri câgo caa gére ina tàwà. ");
INSERT INTO priNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","«Wiàna go jèe pwabwàti cè autâa kàwà, â go mwa me côwâ. Â go mwa popawà, ba na guwà caatâa ma wâgo, wâna na go tâa wê. ");
INSERT INTO priNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Â guwà jèe tâmogòori ê naigé pâ naawê.» ");
INSERT INTO priNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","É ina wà Toma pâ: «Bwa, Pwi Ukai, câbà caa tâmogòori wâna, na gà pâra naawê. Â bà o wànau târa cè pai tâmogòori ê naigé pâ naawê?» ");
INSERT INTO priNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Â é tòpi têe wà Iésu pâ: «*Wâgo ê naigé, ma *âjupâra, ma wâro. Â nye ticè pai pwa kà pwi âboro ma é pâdari wà Caa, wiàna câé caa me jaao. ");
INSERT INTO priNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Â wiàna guwà jèe câmogòorio, â guwà jèe câmogòori mwara wà Caa kôo. Â tapoo nabàni, âna guwà jèe tâmogòorié, â guwà jèe côoê.» ");
INSERT INTO priNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","É ina têe wà Filipo pâ: «Pwi Ukai, gà paari tâbà wà Caa, â bà o ipwàdée!» ");
INSERT INTO priNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Â é tòpi têe pâ: «Jèe nye gòrio kaa jaawà, â câgà caa pâji câmogòorio kaa, co Filipo? Â cina gà bwaa ina pâ: “Nama bà côo wà Pwiduée Caa”? Ba wà pwi âboro na é côoô, âna é côo mwara wà Caa. ");
INSERT INTO priNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Gona bwaa câgà caa cèikî pâ, go wâro goo Caa, â é wâro gooò? Napwa ê pâ popai kôo, âna câgo caa ina gée gooò. Ba wà Caa na é wâgooò, â wàé na é gére wakè. ");
INSERT INTO priNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Cèikî naa goo ê pwina go ina tàwà pâ go wâro wâni goo wà Caa, â é wâro wâni gooò wà Caa. Wiàna câguwà caa cèikî goo ê pâ popai bèepwiri, â wâdé na guwà cèikî goo ê pâ muru na go pwa.» ");
INSERT INTO priNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","«Guwà têre bwàti, ba go ina tàwà ê âjupâra pâ: Wà pwi âboro na é cèikî naa gooò, âna ée mwa pwa ê pâ wakè goro ê pàtàma Pwiduée na go pwa. Â jèpwi mwara, âna o mwa wâru ê pwina ée pwa, jii ê pwina go pwa. Ba wâgo, âna go pâra dari wà Caa. ");
INSERT INTO priNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Â diri ê pâ muru cèna guwà ilari naa na neeô, âna go mwa pwa, ba na go paari ê pai maina ma muugère kà Caa, wâgo Pwina naîê. ");
INSERT INTO priNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Üu, wiàna guwà ilari cè muru naa na neeô, â go o pwa.» ");
INSERT INTO priNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","«Wiàna wânümawà gooò, â guwà o pâra wiâra ê pâ aupitûâri na go ina tàwà. ");
INSERT INTO priNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Â go o mwa ilari jii Caa cè pwi Bépitu tàwà, ba na é tà tâa jaawà, diri na pâ tòotù, dàra gòiri kaamwara. ");
INSERT INTO priNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Ê pwi bépitu-bà, âna ê Nyuâaê Pwicîri; wà pwi Nyuâaê na é paari ê âjupâra. Càra caa tâmogòori tòpié pâ âboro gòropuu, ba càra caa côoinaê ma tâmogòorié. Êco na wâguwà, âna guwà câmogòorié, ba é tâa jaawà, â é nye tà wâro awé wâgoowà. ");
INSERT INTO priNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","«Â o câgo caa nama tà wâguwà acari. Ba go o mwa me mariwà côwâ. ");
INSERT INTO priNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Càcaa gòiri, â o jèe càra mwa caa côoô wà tèpa âboro gòropuu. Êco na wâguwà, âna guwà mwa côoô na go mwa wâro côwâ. Â guwà o wâro mwara. ");
INSERT INTO priNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Wiàna mwa tèepaa ê pwi tòotù-bà, â guwà o mwa tâmogòori pâ go wâro goo wà Caa kôo. Â wâguwà âna guwà wâro gooò, â go wâro goowà mwara. ");
INSERT INTO priNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Wà pwi âboro na é tòpi ê pâ aupitûâri kôo, ma pâra wiâra, âna wàé kaa pwiri pwina wânümee gooò. Â wà pwina é wânümee gooò, âna o mwa wânüma Caa kôo gooé. Â o mwa wânümoo gooé, â go o mwa ipaario têe.» ");
INSERT INTO priNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Â é tawèerié wà Jude (càcaa wà Judas Iscariote, â nye pwi jèpwi), â é ina pâ: «Pwi Ukai, wiàna gà o ipaarigà tâbà, â gorodà na càra caa côogà mwara, wà pàra tèpa âboro?» ");
INSERT INTO priNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Â é tòpi têe pâ: «Wà pwi âboro na wânümee gooò, âna é pâra wiâra ê pâ popai kôo. Â wânüma wà Caa gooé. Â bu mwa me mariê wàibu ma Caa. Â bu mwa pitâa jaaé. ");
INSERT INTO priNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Â wà pwi âboro na càcaa wânümee gooò, âna câé caa pâra wiâra pâ popai kôo. Napwa ê pwina na go ina tàwà, âna càcaa popai kôo; â popai me gée jaa Caa na é cùruo me. ");
INSERT INTO priNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","«Go jèe nye tàmara ina tàwà pwiri, na go bwaa tâa jaawà. ");
INSERT INTO priNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Â ée mwa cùru me ê Nyuâaê Pwicîri wà Caa, ba na é pwa ê wakè kôo. Â ée mwa pitu tàwà ê Nyuâaê Pwicîri, â ée mwa pacâmuriwà goo diri pâ namuru. Â ée mwa taniimiri tàwà diri ê pâ popai na ia go jèe ina tàwà. ");
INSERT INTO priNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","«Go tòpò naa jaawà ê pinaa-napô; üu, go naa tàwà ê pinaanapô kôo. Câgo caa naa pwacèwii ê pai naa kà tèpa âboro gòropuu. Êkaa na guwà cibwaa pidumapiê ma wâgotàwà goo cè pwina o tèepaa. ");
INSERT INTO priNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Ba guwà jèe têre ê pai ina kôo tàwà pâ: Go o jèe pâra, â go o mwa me mariwà côwâ. «Wiàna âji wânümawà gooò, â guwà o dau ipwàdée na go pâdari Caa. Ba wàé, na ia é cùruo medariwà, ba é dau maina jiio. ");
INSERT INTO priNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Nabàni, âna go ina pwiri tàwà, na bwaa càcaa pâji tèepaa, ba, wiàna coo, âna guwà o cèikî naa goo. ");
INSERT INTO priNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","O jèe càcaa wâru ê pwina go ina tàwà. Ba ée jèe tèepaa me wà *Caatana, pwi ukai kâra gòropuu bèeni. Napwa wâgo, âna nye ticè pwina pâri ma é pwa tôo. ");
INSERT INTO priNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Êco na ê pwina tèepaa mariô, âna, naa kâra pâ âboro gòropuu, ba na rà tâmogòori pâ, wânümoo goo Caa. Â ê pwina go pwa, âna go pwa ê pwina é tûâri tôo. Nabwé. «Â ni, cimadò, ma jè pâra géeni!» ");
INSERT INTO priNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Gée na càùé, âna é ina tàra wà Iésu pâ: «*Wâgo ê pwi âji majoro vigne, â wà pwina é pwabwàti ê vigne, âna wà Caa kôo. ");
INSERT INTO priNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Êdiri pâ ditàra upwâra âna rà wâgooò. Â wiàna câé caa pwâ ê ditèe, â é tapàgà tâjii wà Caa kôo. Â wiàna é pwâ, â é tédità pàra ditèe wà Caa kôo, â é tòimiri pàra pwi, ba na o dau wâru ê pwêe. ");
INSERT INTO priNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","«Wâguwà, âna guwà pwacèwii pâ ditàra vigne na tòimiri, ba jèe patâjii èpà gée na pwâranümawà goro ê pâ popai na go jèe ina tàwà. ");
INSERT INTO priNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Wâdé na guwà tà tâa gooò, pwacèwii na go tà tâa goowà. Ba pwacoé ma é pwâ ê ditàra upwâra, wiàna câé caa tâa goo ê majoroé. Â wàrapwiri mwara naa goowà, âna o nye ticè pwâra wakè kàwà, wiàna câguwà caa tà tâa gooò. ");
INSERT INTO priNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","«*Wâgo, âji majoro vigne, â guwà pâ ditèe. Â wà pwi âboro na é tà tâa gooò, â go tà tâa gooé, âna o dau wâru pwêe. Ba càcaa pâri ma guwà pwa cè jè muru, wiàna tiàuo jiiwà. ");
INSERT INTO priNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Wà pwina câé caa tâa gooò, âna o tüê còobé, pwacèwii pwi ditàra upwâra na tapàgà. Â é mwari, â jè tòri, â jè tüê naa na ânye, â tòo.» ");
INSERT INTO priNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","«Wiàna guwà tâa gooò, â wiàna ê pâ popai kôo âna tâa goowà, â guwà ilari diri cè pwina nümawà goo, â o naa tàwà. ");
INSERT INTO priNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Wâdé na dau pwa pwâra wakè kàwà. Â wiàna wàrapwiri, â guwà paari pâ guwà tèpa *câmu kôo. Â guwà paari mwara ê pai maina ma muugère kà Caa. ");
INSERT INTO priNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","«Wânümoo goowà pwacèwii pai wânüma Caa gooò. Wâdé na guwà tà mwü naa na pimeaari kôo. ");
INSERT INTO priNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Â wiàna guwà pitêre dàra ê pâ aupitûâri kôo, âna guwà tà mwü na pimeaari kôo. Guwà pwacèwiio, ba go pitêre dàra ê pâ popai kà Caa kôo. Â go tà mwü naa na pimeaari kêe. ");
INSERT INTO priNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","«Go ina tàwà ê pâ namuru bèepwiri, ba naa tâa goowà ê ipwàdée kôo, â na o tâbawêe ê ipwàdée kàwà.» ");
INSERT INTO priNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","«Wàéni ê aupitûâri kôo: Guwà mwa tà pimeaariwà, pwacèwii ê pai jèe meaariwà kôo. ");
INSERT INTO priNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Â wàéni ê pimeaari na dau imaina: Na é panuâ ê wâro kêe wà pwi jè âboro ba kà tèpa bée. ");
INSERT INTO priNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Guwà tèpa béeò, wiàna guwà pitêre dàra pâ muru na go ina tàwà. ");
INSERT INTO priNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Â o câgo mwa caa ina goowà côwâ pâ guwà tèpa ênawéna kôo. Ba pwi ênawéna, âna câé caa tâmogòori ê pwina é pwa wà pwi ukai kêe. Â go ina goowà nabà pâ, guwà tèpa béeò. «Ba go jèe pwa ma guwà tâmogòori diri pâ muru na é ina tôo wà Caa kôo. ");
INSERT INTO priNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Ba càcaa wâguwà na pitòrigario. Â wâgo na pitòrigariwà. Â go cùruwà, ba na o pwa pwâra wakè kàwà—ê pwâra wakè na o tà tâa. Êkaa na ée mwa naa tàwà wà Caa êdiri pâ namuru na guwà ilari jiié, naa na neeô. ");
INSERT INTO priNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Wàéni ê aupitûâri kôo tàwà: Na guwà pimeaariwà.» ");
INSERT INTO priNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","«Wiàna rà èpàriwà tèpa âboro gòropuu, â wâdé na guwà mwa tà niimiri pâ, rà jèe mara èpàrio. ");
INSERT INTO priNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Ba wiàna guwà bwaa tâa jaarà, â rà nye wâdéariwà. Êco na câguwà caa tâa jaarà, ba go jèe pitòrigariwà jii ê gòropuu. Êkaa na rà èpàriwà. ");
INSERT INTO priNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Guwà pitaniimiri ê popai na ia go jèe ina tàwà pâ: Wà pwi ênawéna âna càcaa piwéna jii pwi ukai kêe. «Â wiàna rà tubaèpà tôo, â rà o nye tubaèpà tàwà mwara. Ba càra caa tòpi ê popai kôo, â o càra caa tòpi mwara ê popai kàwà. ");
INSERT INTO priNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","«Rà o pwa tàwà ê pâ muru na èpà ba wàrapwiri gooò, â wàrapwiri mwara ba càra caa tâmogòori wà Pwina é cùruo me. ");
INSERT INTO priNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Wiàna câgo caa gére ina tàra ê pâ namuru bèepwiri, â pwiri nye gére ticè èpà kàra. Êco na go jèe me kaa, â go jèe ina tàra. Â gée goo kaa pwiri, â o ticè pai tòpi kàra, na tòotù na o pitèirà goro ê muru na èpà na rà pwa. ");
INSERT INTO priNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","«Wà tèpa âboro na rà èpàrio, âna rà nye èpàri mwara wà Caa kôo. ");
INSERT INTO priNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Go pwa naa naporomeerà ê pâ muru, na câé caa pâji pwa cè pwi jèpwi. Ba wiàna câgo caa pwa ê pâ muru bèepwiri, â pwiri nye gére ticè èpà kàra. Êco na rà jèe côo, â rà èpàribu ma wà Caa kôo. ");
INSERT INTO priNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Â rà wàrapwiri, ba na o coo ê auwii naa na tii goro *Naèà kàra, pâ: Rà èpàrio, âna nye ticè majoroé. ");
INSERT INTO priNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","«Napwa naa goowà, âna go o mwa panuâ me pwi a pitu tàwà na é me gée jaa wà Caa—âna ê Nyuâaê Pwicîri, na é paari ê Âjupâra. Ba, ûna é tèepaa medariwà, â ée mwa paâjupâraô. ");
INSERT INTO priNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Â wâguwà mwara âna guwà o mwa paâjupâraô, ba guwà mu tèpa tâa jaao gée na autapoo.» ");
INSERT INTO priNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","«Go jèe ina tàwà ê pâ muru bèepwiri, târa ma guwà cibwaa pwa ma tiàu cèikî kàwà. ");
INSERT INTO priNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Ba o pacoowà gée na pâ *wâra pitapitiri. Â o me cè pàara na rà o pòtàmwarawà tèpa âboro. Ba rà niimiri pâ rà piênawéna tà Pwiduée. ");
INSERT INTO priNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Rà o wàrapwiri tàwà, ba càra caa câmogòoribu ma Caa. ");
INSERT INTO priNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Â go ina tàwà ê pâ muru bèepwiri, ba wiàna o mwa tèepaa ê pwiibà, â guwà mwa tà niimiri, ba go jèe tàmara ina tàwà.» «Câgo caa inapàpari tàwà ê popai bèepwiri, na ia go tapoo todàwà, ba go bwaa tâa jaawà. ");
INSERT INTO priNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Â nabà, âna go o jèe pâra dari Pwina é cùruo me, â nye ticè pwi jè ârapàarawà cèna é niimiriô na é tawèerio pâ: “Gona gà pâ naapà?” ");
INSERT INTO priNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","«Â po dau pikîri ê pwâranümawà, gée goro ê pwina go gére ina tàwà. ");
INSERT INTO priNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Êco na go ina tàwà ê âjupâra pâ: Wâdé ba kàwà na go pâra. Ba wiàna câgo caa pâra, â o câé caa tèepaa medariwà wà pwi a pitu tàwà. Ba go pâra, â go o mwa cùrué medariwà. ");
INSERT INTO priNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","«Wiàna ée mwa tèepaa me, â ée mwa paari târa pâ âboro gòropuu pâ, rà pitanami naa na pai tâmogòori kàra. Ba càra caa tâmogòori ê pai pwa goo ê èpà ma ê *tàrù, bau ê pitèimuru kà Pwiduée na o mwa tèepaa. ");
INSERT INTO priNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Rà pitanami naa goo ê èpà; ba ê èpà kàra na dau maina, âna pai càcaa cèikî kàra naa gooò. ");
INSERT INTO priNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Â rà pitanami naa goo ê tàrù; ba go o jèe pâra mari wà Caa, wâgo ê Tàrù. Â o jèe câguwà mwa caa côoô côwâ. ");
INSERT INTO priNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Â rà pitanami mwara, naa goo ê pitèimuru kà Pwiduée. Ba wà Pwiduée, âna ée jèe pitèi diri wà *Caatana pwi ukai kâra gòropuu bèeni. ");
INSERT INTO priNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","«Bwaa nye dau wâru ê pâ muru na nümoo na go ina tàwà mwara. Êco na o bwaa dau tòina tàwà wiàna guwà têre ni. ");
INSERT INTO priNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Wiàna ée mwa tèepaa wà Nyuâaê Pwicîri na é paari ê *âjupâra, â ée mwa pwa ma guwà tâmogòori diri ê âjupâra. Ba o câé caa po ina cè pâ muru cèna me gée gooé, êco na ée mwa ina tàwà diri ê pâ pwina é têre jiibu ma wà Caa. Â ée mwa inapàpari tàwà ê pâ muru na o mwa tèepaa. ");
INSERT INTO priNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Â ée mwa paari ê pai maina bau ê muugère kôo. Ba ée mwa inapàpari tàwà ê pâ pwina go ina têe. ");
INSERT INTO priNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Ba diri ê pâ pwina kà Caa âna kôo. Â wàé kaa pwiri na go ina pâ: Ê Nyuâaê Pwicîri âna ée mwa inapàpari tàwà diri ê pâ pwina go ina têe.» ");
INSERT INTO priNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","«Càcaa tà gòiri, â o jèe câguwà caa côoô. Â càcaa gòiri mwara gée na càùé, â guwà o mwa côoô côwâ.» ");
INSERT INTO priNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","18","Â rà pi-ina tàra wà pàra tèpa *câmu kêe pâ: «Gona cina é ina pwiri? Â cina é ina mwara pâ càcaa tà gòiri â o câjè caa côoê, â o càcaa gòiri côwâ gée na càùé, â é pâra dari wà Caa kêe? Gona dà ê pwina nümee na é ina tâjè, na é gére ina tâjè pâ: “Càcaa gòiri”?» ");
INSERT INTO priNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","20","É jèe tâmogòori wà Iésu pâ nümarà na rà tawèerié, â é ina tàra pâ: «Tàpéebà, guwà gére pitawèeriwà goro ê pwina go ina tàwà. Guwà têre bwàti, ba nye âjupâra pâ: Càcaa tà gòiri, â o jèe câguwà caa côoô. Â càcaa gòiri mwara gée na càùé, â guwà o mwa côoô côwâ. Â guwà o i ma pijinünü, êco na pâ âboro gòropuu, âna rà mwa ipwàdée. Â guwà o pikîri, êco na ê pikîri kàwà âna o mwa pâra nau ipwàdée. ");
INSERT INTO priNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","«Wàra ê jè ilàri na ée jèe picôo èpo. Ba ûna é tapacîri ê tòotù kêe, â é dau maagé. Â wiàna é jèe picôo èpo, â jèe câé caa niimiri côwâ ê pai maagé kêe. Ba é jèe ipwàdée goro ê pai tèepaa kâra pwi nari èpo, naa gòropuu. ");
INSERT INTO priNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Â wàrapwiri, na guwà o bwaa pikîri nabà. Êco na go o mwa tèepaa me mariwà côwâ, â o mwa ipwàdée ê pwâranümawà. Â o nye ticè pwi jè âboro cèna é popa jiiwà ê ipwàdée kàwà. ");
INSERT INTO priNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","«Na pwi tòotù bèepwiri, âna o jèe câguwà caa me nau tawèerio goo cè jè muru. Ba ê Nyuâaê Pwicîri, âna ée mwa pacâmuriwà. Â go ina tàwà ê âjupâra pâ: Diri ê pâ muru na guwà o ilari naa na neeô, âna é naa tàwà wà Caa. ");
INSERT INTO priNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Tiagoo ni, âna bwaa nye ticè jè muru cèna guwà ilari naa na neeô. Wâdé na guwà ilari, ba guwà o tòpi, â o tâbawêe ê ipwàdée kàwà.» ");
INSERT INTO priNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","«Go mu pwa ucina tàwà na ia go patùrawà. Êco na o mwa tèepaa me ê tòotù, na o câgo caa pwa ucina côwâ tàwà. Ba go o nye inapàpari tàwà ê popai goo Caa. ");
INSERT INTO priNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Na tòotù bèepwiri, âna guwà o pwapwicîri tà Caa naa na neeô. «Câgo caa ina tàwà pâ go o pwapwicîri tà Caa ba kàwà. ");
INSERT INTO priNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Ba wà Caa âna dau wânümee goowà, gée goro ê pai wânümawà gooò ma pai cèikî kàwà pâ go me jiié. ");
INSERT INTO priNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Go nye me jii Caa, â go tèepaa me naani gòropuu. Â nabàni, âna go o jèe pâra côwâ géeni gòropuu, dari wà Caa.» ");
INSERT INTO priNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Rà ina têe wà tèpa câmu kêe pâ: «Gà côo, gà jèe po inapàpari nabà, â jèe câgà caa pwa ucina. ");
INSERT INTO priNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Nabà, âna bà jèe côoinari pâ, gà tâmogòori diri pâ muru. Â câgà caa tapacîri ma bà tawèerigà goo cè jè muru, ba gà mara tâmogòori ê auniimiri kâbà. Êkaa na bà nye cèikî kaa pâ gà me jii wà Pwiduée.» ");
INSERT INTO priNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Â é tòpi tàra pâ: «Gona guwà cèikî ni? ");
INSERT INTO priNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Guwà côo, o mwa tèepaa ê pàara, â é jèe tàgére tèepaa, na o mwa nama guwà jèpa ipiina jiio, â o mwa tà wâgo acari. Êco na càcaa wâgo acari, ba wàibu ma Caa. ");
INSERT INTO priNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Go ina tàwà pwiri, ba na tâa goowà ê pinaanapô, wiàna guwà tà tâa gooò. Ba guwà mwa dau picâri naani gòropuu. Êco na guwà gòo, ba go jèe piétò jii ê gòropuu.» ");
INSERT INTO priNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Ûna é nabwé ina pwiri wà Iésu, â é niâ too naa napwéretòotù, â é ina pâ: «Caa wée, jèe wàéni i pwi pàara kôo. Paari ê pai maina ma muugère kôo, Pwina naîgà, ba na go paari mwara ê pai maina ma muugère'gà. ");
INSERT INTO priNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Ba gà jèe naa tôo ê pitûâ naa gò diri tèpa âboro. Êkaa na go naa ê *wâro dàra gòiri, tà diri tàpé na gà panuârà tôo. ");
INSERT INTO priNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Â wàéni ê wâro: Na rà câmogòorigà, wâgà Pwiduée, na gà nye caapwi co; â na rà câmogòorio, wâgo Iésu Kériso, na gà cùruo me. ");
INSERT INTO priNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","«Go jèe paari ê pai maina ma muugère'gà naani gòropuu. Ba go jèe tubamwara diri pâ wakè, na gà panuâ tôo ba na go pwa. ");
INSERT INTO priNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Êni, co Caa, âna gà naa tôo côwâ ê pai maina ma muugère kôo, pwacèwii na nye tà tôo béaa na go bwaa wâjaagà béaari ê pai tòpò ê gòropuu.» ");
INSERT INTO priNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","«Go jèe inapàparigà tà tèpa âboro—tà tàpé na ia gà pitòrigarirà gée na ê gòropuu, â gà naarà tôo. Ba rà nye tèpa âboro'gà, â gà jèe panuârà tôo. Â rà jèe pâra wiâra ê pâ popai'gà. ");
INSERT INTO priNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Â rà jèe tâmogòori nabà pâ, êdiri pâ muru na tâa tôo, âna nye muru me gée jaagà. ");
INSERT INTO priNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Ba go naa tàra ê pâ popai na gà naa tôo, â rà jèe cau tòpi. Â rà jèe nye câmogòorio bwàti pâ go nye me jiigà, ba rà cèikî pâ wâgà na gà cùruo me. ");
INSERT INTO priNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","«Go pwapwicîri ni ba kàra, â càcaa ba kà tèpa âboro gòropuu. Üu, go nye pwapwicîri ba kà tàpé na gà naarà tôo, ba rà nye tèpa âboro'gà. ");
INSERT INTO priNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Ba diri ê pwina kâgà, âna kôo mwara. Â ipaiwà mwara naa goo ê pwina kôo, âna kâgà. Â naa goorà, âna gére paari ê pai maina ma muugère kôo. ");
INSERT INTO priNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","«Nabà, âna jèe câgo caa tâa na ê gòropuu bèeni, ba go o jèe tòpaé darigà. Êco na wàilà, âna rà o tà tâa ni. Caa, wâgà na gà dau maina awé, go ilari pâ gà wéaarirà, naa na ê pàtàmara neegà, i pwi neegà na gà naa tôo. Üu, gà wéaarirà, ba na rà o caapwi pwacèwiiju na ju caapwi. ");
INSERT INTO priNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Na go bwaa tâa jaarà, â go wéaarirà, naa na i neegà na gà naa tôo. Â go jèe nye wéaarirà, â càcaa pwa cè pwi jèpwi cèna tiàué jiirà, êco, wà pwi âboro caapwi. Ba wàé, âna pitòrigarié, ba na o tiàué dàra gòiri awé ba na o coo ê auwii naa na *Tii Pwicîri.» ");
INSERT INTO priNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","«Caa wée, go o jèe paé darigà. Â go ina ê pâ popai bèeni, na go bwaa tâa ni gòropuu. Go ina pwiri, ba na tâa goorà ê ipwàdée kôo, pwi ipwàdée na tâbawêe. ");
INSERT INTO priNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Go jèe naa tàra ê popai'gà. «Wà tèpa âboro gòropuu, âna rà èpàrirà ba càra caa pwacèwiirà. Ba ê gòropuu bèeni, âna càcaa âji napô kàra. Ba rà pwacèwiio, ba câgo caa pwi âboro ni gòropuu. ");
INSERT INTO priNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Êco na câgo caa ilari jiigà pâ, na gà poparà géeni gòropuu. Go ilari jiigà pâ, na gà piwéaarirà jii wà Pwi âboro èpà, wà *Caatana. ");
INSERT INTO priNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Üu, ba càcaa tèpa âboro ni gòropuu, ba rà pwacèwiio, na câgo caa pwi âboro ni. ");
INSERT INTO priNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","«Pacâmurirà goro ê popai'gà, ba na rà wâgoogà bwàti. Ba ê popai'gà, âna é âjupâra. ");
INSERT INTO priNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","«Go cùrurà pâ naa na gòropuu, pwacèwii na gà jèe cùruo me naa na gòropuu. ");
INSERT INTO priNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Â go nye ipanuâô tâgà bwàti, ba na rà tèpa âji âboro'gà mwara goro ê popai'gà na âjupâra.» ");
INSERT INTO priNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","«Câgo caa pwapwicîri ba kàra co, â ba kâra mwara ê pâ âboro na rà o mwa tà cèikî naa gooò, gée goro ê popai kàra. ");
INSERT INTO priNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Wâdé na rà caapwi. Ba ju caapwi, co Caa, ba gà wâro gooò, â go wâro googà. Â go pi-ila ba kàra diri, pâ, wâdé na rà caapwi naa gooju. Êkaa na rà mwa cèikî pâ âboro gòropuu pâ, gà cùruo me naa jaarà. ");
INSERT INTO priNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","«Go jèe naa tà tèpa âboro'gà ê pai maina ma muugère na gà naa tôo. Êkaa na rà o caapwi, wàra pai caapwi kâju— ");
INSERT INTO priNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","wâgo naa goorà, ma wâgà naa gooò—ba na rà o caapwi bwàti. Â wà tèpa âboro gòropuu, âna rà mwa tâmogòori pâ gà cùruo me, â wânümagà goo tèpa âboro kôo, pwacèwii ê pai wânümagà gooò. ");
INSERT INTO priNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","«Caa, gà jèe naarà tôo. Â nümoo na rà tâa na ê pwi ére na go o tâa wê, ba na rà o côo ê pai maina ma muugère na gà naa tôo. Ba wânümagà gooò na bwaa càcaa tòpò ê gòropuu. ");
INSERT INTO priNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Caa, wâgà na gà *tàrù, âna càra caa câmogòorigà ê pâ âboro gòropuu. Êco na wâgo âna go câmogòorigà. Â wà tèpa *câmu kôo, âna rà tâmogòori pâ gà cùruo me. ");
INSERT INTO priNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Â go jèe inapàparigà tàra, â go bwaa inapàparigà tàra mwara. Wàépwiri, ba na o wâgoorà ê pwi pimeaari na gà meaario goo, â go wâgoorà mwara.» ");
INSERT INTO priNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Ûna é pwapwicîri diri wà Iésu, â rà tapàgà napwé Cédron, wàilà ma tèpa *câmu kêe. Â rà pâ naa na jè ére na câmi goro upwâra, â rà tò naawê. ");
INSERT INTO priNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Â wà Judas, wà pwina ée mwa pwa tûâ tà Iésu, âna é nye tâmogòori bwàti ê pwi ére-bà. Ba rà mu nye ciburà pâra naawê ma wà Iésu. ");
INSERT INTO priNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Â é popa me naawê ê pâ coda na wâru, wàilà bau pàra tèpa wéaari *Wâra pwapwicîri. Ba rà cùrurà wà tèpa caa kà tèpa pwa *ârapwaailò, ma tèpa *Farasaio. Â rà popa pâ ê pâ wâra ânye, bau pâ uèù, bau pâ neemuru paa. ");
INSERT INTO priNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Wà Iésu, âna é jèe nye tâmogòori diri ê pâ muru, na o tèepaa mariê. Â é pâra cararà, â é ina tàra pâ: «Wàilàapà na guwà mudèe?» ");
INSERT INTO priNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","6","«Wà Iésu, pwi âboro gée Nazareth.» «*Wâgo kaa.» Â rà ti côwâ, ma tûuboo naa napuu. Napwa naa goo wà Judas, âna é bwaa tâa jaarà. ");
INSERT INTO priNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Â é tawèerirà mwara wà Iésu pâ: «Wàilàapà na guwà mudèe?» «Wà Iésu gée Nazareth.» ");
INSERT INTO priNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Â é tòpi tàra pâ: «Go jèe ina tàwà èri pâ wâgo kaa. Â wiàna nye wâgo kaa na guwà mudòo, â wâdé na guwà panuâ tàpéeni, ma rà pâra.» ");
INSERT INTO priNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","É ina pwiri, ba na pâ nau coo ê popai, na ia é jèe tàmara ina pâ: «O càcaa tiàu cè pwi jè âboro gée goo tàpé na gà naarà tôo.» ");
INSERT INTO priNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Â wà Simona Pétéru, âna pwa ê tàuwa kêe, â é càù dò gée na wêe. Â é pwa na é tüboo kaa naa gòro pûru Malkus, pwi ênawéna kà pwi *ukai kà tèpa pwa ârapwaailò. Êco na é tépàgà co i doronyüruê étò. ");
INSERT INTO priNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Â é ina tà Pétéru wà Iésu pâ: «Gà tùu boo côwâ i tàuwa'gà naa na i wêe! Gona gà niimiri pâ, o tàutôo na go wâdo ê na wârado kâra maagé côo, na é pwabwàti ba kôo wà Caa?» ");
INSERT INTO priNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Rà tâjùru Iésu wà tèpa coda—wà tèpa coda kà tèpa *Roma, ma wà pwi caa kàra; wàilà ma wà tèpa coda kà tèpa *Juif. Â rà piié goro ê pâ utàpwe. ");
INSERT INTO priNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Â rà popaé béaa pâdari Hanne, pwi caa kà wâdà Caïphe. (Wà Caïphe âna é pwi ukai kà tèpa pwa ârapwaailò, na pwi naja-bà. ");
INSERT INTO priNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Â wàé kaa, na ia é ina tà tèpa Juif pâ: «Wâdé na é bà wà pwi caapwi âboro ba kâra ê Ba.») ");
INSERT INTO priNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Ru picâwiâ Iésu wà Simona Pétéru, ma pwi jè a câmu mwara. Wà pwi ukai kà tèpa pwa ârapwaailò, âna é tâmogòori bwàti wà pwi a câmu bèepwiri. Êkaa na, ûna é tò wà Iésu, â é jèe nye tò mwara wà pwini naanidò gòroigé kà pwi ukai. ");
INSERT INTO priNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Wà Pétéru âna é jèe tà coo boo gòroigé, goro goropwârawâ. Â é còobé côwâ i pwi jèpwi. Â é patùra i tô ilàri na é piwéaari goropwârawâ, ba na é nama é tò mwara wà Pétéru. ");
INSERT INTO priNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Â é ina tà Pétéru wà tôoni pâ: «É! Pwiini, gà pwi jè bée Iésu?» Â é ina pâ: «Bwa, bwa.» ");
INSERT INTO priNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Rà tà tâa wê wà pàra tèpa ênawéna, ma wà tèpa wéaari Wâra pwapwicîri. Â rà pwa ê pé na ânye, â rà pwacârau, ba dau maina kaa ê moo. Â é tà coo burà pwacârau jaarà wà Pétéru. ");
INSERT INTO priNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Wà Iésu, âna é coo ara Hanne pwi ukai kà tèpa pwa ârapwaailò béaa. Â wà Hanne âna é pitawiâê naa goo tèpa câmu kêe ma pai pwa pupûra kêe. ");
INSERT INTO priNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Â é ina têe wà Iésu pâ: «Go mu nye tùra na ara diri ê pâ âboro. Â go mu ipupûra na ê Wâra pwapwicîri, ma wâna ê pâ *wâra pitapitiri. Â nye ticè jè popai cèna go pinaapwàniri. ");
INSERT INTO priNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Â gorodà na gà bwaa pitawiâô? Wâdé na gà tawèeri ê pâ âboro na rà têre ê popai kôo. Ba rà tâmogòori ê pâ muru na go ina.» ");
INSERT INTO priNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Â é tamagérié wà pwi jè a wéaari Wâra pwapwicîri, na é cimwünyabwerié, â é ina têe pâ: «Kaa! Gà wàrapwiri târa pai tòpi'gà tà pwi ukai kà tèpa pwa ârapwaailò?!» ");
INSERT INTO priNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Â é ina tà Hanne wà Iésu pâ: «Wiàna èpà cè pai tòpi kôo, â gà paari tôo cai cè popai èpà na go ina. Â wiàna *tàrù, â cina gà nama tamagério?» ");
INSERT INTO priNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Â é panuâê pâ wà Hanne, dari wà Caïphe, gée goo na é pwi ukai kà tèpa pwa ârapwaailò, na pwi pàara-bà. Â bwaa nye tàgére pii wà Iésu. ");
INSERT INTO priNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Na bwaa gére wàrapwiri, â rà tàgére pwacârau wà Simona Pétéru ma wà pàra tàpé. Â rà jèu ina têe pâ: «Pwiini, gà pwi jè a câmu kà Iésu mwara?» Â é pitütôowâri wà Pétéru, â é ina pâ: «Bwa, câgo caa tâmogòori pwiibà.» ");
INSERT INTO priNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Â é tâa jaarà mwara wà pwi jè ârapàara tèpa ênawéna kà pwi ukai kà tèpa pwa ârapwaailò. Wà pwi ênawéna-bà, âna pijènereru ma wà i pwi ia é tépàgà i doronyüruê wà Pétéru. Â é ina têe pâ: «Pwiini, akaé! Wâgà kaa na go côogà naa jaa wà Iésu, na i ére na câmi goro upwâra.» ");
INSERT INTO priNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Â é pitütôowâri mwara wà Pétéru. Â é nye to kaa i ja. ");
INSERT INTO priNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Bwaa nye dau dàuru kaa, â rà popa Iésu wà tèpa coda, jii wà Caïphe. Â rà dàtié pâ naa na pwârawâ kà *Pilato, pwi kupénoo roma. Â wà tèpa caa kà tèpa Juif, âna càra caa too naa na i pwârawâ; wàrapwiri ba câé caa pwi Juif wà Pilato. Ba péa rà tà piwâtàmurirà, wiâra ê naèà kâra pwapwicîri kàra â o càcaa pâri ma rà ija ê utimuru pwicîri na tòotù *Paséka. ");
INSERT INTO priNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Êkaa na é còobé cararà wà pwi kupénoo Pilato. Â é ina tàra pâ: «Gona dà cè pwina èpà cèna é pwa wà pwi âboro bèeni, na guwà me nau piciapwâ gooé?» ");
INSERT INTO priNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Â rà ina têe pâ: «Wiàna ticè cè pwina é pwa na èpà, â gona gà niimiri kaa pâ bà o popaé medarigà?» ");
INSERT INTO priNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Â é tòpi tàra wà Pilato pâ: «Guwà popaé côwâ, â guwà pitèié wiâra ê naèà kàwà.» Â rà ina têe pâ: «Nye ticè tàrù kâbà wiâra ê naèà kàwà ma bà pòtàmwara cè pwi jè âboro.» ");
INSERT INTO priNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Tèepaa me ê pâ bèepwiri, târa ma coo ê popai na é jèe ina wà Iésu, na é inapàpari ê pai o bà kêe. ");
INSERT INTO priNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","É tò côwâ wà Pilato naa na i wâ. Â é todà Iésu, â é tawèerié pâ: «Gona gà pwi ukai kà tèpa Juif?» ");
INSERT INTO priNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Â é tòpi têe pâ: «Gà ina gée googà ê popai bèepwiri, é, pwa cè jè âboro cèna é inaô tâgà?» ");
INSERT INTO priNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Â é ina têe wà Pilato pâ: «Gona go pwi Juif mwara, wâgo? Rà panuâgà tôo wà tèpa jèneregà, ma wà tèpa caa kà tèpa pwa ârapwaailò. Ba dà cèna gà pwa?» ");
INSERT INTO priNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Â é tòpi têe wà Iésu pâ: «Càcaa wâni gòropuu ê Mwaciri kôo. Ba wiàna wâni gòropuu, â pwiri rà gére ipwamuruô wà tèpa ênawéna kôo, ma càcaa panuâô tà tèpa pitûâ kà tèpa Juif. Bwa, càcaa wâni gòropuu ê Mwaciri kôo.» ");
INSERT INTO priNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Â é tawèerié mwara wà Pilato pâ: «Gona gà pwi jè ukai?» Â é tòpi têe wà Iésu pâ: «Âjupâra ê pai ina'gà! Ba go Pwi Ukai. Â go tèepaa naani gòropuu, ba na go picémara ê *âjupâra. Â wà diri tàpé na rà tâa na ê âjupâra, âna rà tàmaari ê pâ popai kôo.» ");
INSERT INTO priNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Â é ina wà Pilato pâ: «Â gona dà ‘âjupâra’?» É còobé côwâ wà Pilato, â é ina tà tèpa Juif pâ: «Câgo caa pâmari cè pwina pâri ma é pwa wârimuru goo, ê pwi âboro bèeni. ");
INSERT INTO priNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Nye câmaajé tâjè, na go panuâ côwâ tàwà ê pwi jè a pwa wârimuru, na tòotù Paséka. Â wànau, nümawà na go panuâ côwâ Iésu, ‘pwi ukai kà tèpa Juif’?» ");
INSERT INTO priNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Â rà nye cau ina too kaa pâ: «Bwa! Càcaa wàé! Gà panuâ Barabbas!» (Napwa wà pwini Barabbas, âna pwi a mura.) ");
INSERT INTO priNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Wà *Pilato âna é panuâ Iésu ma pâdié goro ubati. ");
INSERT INTO priNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Â wà tèpa coda, âna rà piècaarié. Rà pàti ê bwe goro ê îri upwâra na dau pwa daaé. Â rà tòpò naa gòro pûru Iésu, wàra pé bwe korona kà pwi jè ukai. Â rà pwa ma é coona ê pé ârabwée na dau mii. ");
INSERT INTO priNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Â rà pime burèe, â rà pitaurèe gooé ma ina têe pâ: «Wée! Cidòri nyuâagà, co pwi ukai kà tàpé Juif!» Â rà dau tamagérié. ");
INSERT INTO priNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","É còobé côwâ wà Pilato, â é ina tà tèpa âboro pâ: «Guwà côo, go jèe panuâê tàwà, ba na guwà tâmogòori pâ, nye ticè pwina é pwa na pâri ma é pwa wârimuru goo.» ");
INSERT INTO priNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Â é pacòobé wà Iésu, âna é bweri i bwe kêe na pwa daaé, â jèe wâgooé i ârabwée mii. Â wà Pilato, âna é ina tàra pâ: «Wàépwiri i ji pwi âboro.» ");
INSERT INTO priNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Ûna rà côoê wà tèpa pitûâ kà tèpa Juif, â rà uu ma tomara too pâ: «Ténamiriê naa goro *satauro! Ténamiriê naa goro satauro!» Â é ina tàra wà Pilato pâ: «Tàpéebà, wiàna nümawà na guwà ténamiriê, â guwà nye popaé côwâ. Ba wâgo, âna nye ticè èpà kêe cèna go côo.» ");
INSERT INTO priNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Êco na rà tòpi têe pâ: «É ina pâ é *Pwina naî Pwiduée, muru na dau pwicîri wiâra ê naèà kâbà. Â wâdé na é bà!» ");
INSERT INTO priNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Na é têre bèepwiri wà Pilato, â dau wâgotêe. ");
INSERT INTO priNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Â é too côwâ naa na i wâ, â é tawèeri Iésu pâ: «Gà pwi a me géepà, co pwini?» Êco na câé mwa caa tòpi têe wà Iésu. ");
INSERT INTO priNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Â é ina têe mwara wà Pilato pâ: «Pwini, câgà caa tòpi tôo? Gona câgà caa tâmogòori pâ, tà tôo pitûâ ma go panuâgà, é, ma go pwa ma ténamirigà naa goro satauro?» ");
INSERT INTO priNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Â é tòpi têe wà Iésu pâ: «O nye ticè tàrù'gà naa gooò, wiàna câé caa panuâ tâgà wà Pwiduée géenidò. Napwa naa goo wà pwi âboro na ia é icurio tâgà, âna é dau pwa na èpà jiigà.» ");
INSERT INTO priNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Wà Pilato, âna é tàgére bu naigé ba na é panuâ Iésu côwâ. Êco na wà tèpa pitûâ kà tèpa Juif, âna rà ina têe pâ: «Wiàna gà panuâ pwi âboro bèeni, â câgà caa pwi bée wà César, ukai'gà. Ba wà pwi âboro na é ina pâ é pwi ukai, âna é pwi a cicara César.» ");
INSERT INTO priNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Â wà Pilato, âna é pacòobé wà Iésu naa gòroigé. Â é tâaboo naa gòro ê autâa kà pwi a pitèimuru, naa na ji ére na ina goo pâ Gabbatha naa na *hébéru (pai ina wèe pâ ‘Naigé na pwa goro atü’). ");
INSERT INTO priNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Napwa ê tòotù bèepwiri, âna tòotù na pibwéka târa tòotù *Paséka, â po gopaé. Â é ina wà Pilato tà tèpa âboro pâ: «Wàéni i pwi ukai kàwà!» ");
INSERT INTO priNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Â rà tomara too pâ: «Caamwereê! Caamwereê! Ténamiriê naa goro satauro!» Â é ina tàra wà Pilato pâ: «Gona nümawà na go pwa ma ténamiri wà pwi ukai kàwà?» Â rà tòpi têe wà tèpa caa kà tèpa pwa *ârapwaailò pâ: «Nye caapwi co, wà César, pwi ukai kâbà! Nye ticè pwi jèpwi mwara!» ");
INSERT INTO priNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Â é panuâê tàra ma ténamiriê naa goro satauro. Â rà popa Iésu wà tèpa coda. ");
INSERT INTO priNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Wà Iésu, âna é nye kâa i satauro kêe, â é còobé jii i ville. Â é pâra dàra ê pwi ti kâra jaa, na ina goo wê pâ Golgota naa na hébéru, âna pai ina wèe pâ ‘Goro pwiripûru âboro’. ");
INSERT INTO priNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Â rà ténamiriê naa goro satauro naawê. Â rà ténamiri mwara ê tupédu ârailu âboro, naa goro du jènereê. ");
INSERT INTO priNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","É nama rà wii ê jè aupwa tii wà Pilato, â rà tòpò naa goro i satauro kà Iésu. Â wàéni ê pwina wii naa gò: iésu, pwi âboro gée nazareth, pwi ukai kà tèpa juif. ");
INSERT INTO priNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Âna wii goro pwa hébéru, ma roma, ma grec. Wâru tèpa âboro na rà pûra, ba ê ére na rà ténamiri Iésu naawê, âna é tàmwünyabweri ê ville. ");
INSERT INTO priNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Wà tèpa caa kà tèpa pwa ârapwaailò, âna rà pwa ma ina tà Pilato pâ: «Gà cibwaa wii pâ: “Pwi ukai kà tèpa Juif”. Â gà wii pâ: “É ina pâ é pwi ukai kà tèpa Juif.”» ");
INSERT INTO priNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Êco na é tòpi tàra wà Pilato pâ: «Ê pwina go wii, âna o jèe càcaa tòotéri.» ");
INSERT INTO priNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Wà tèpa ârapàpé coda, na ia rà ténamiri Iésu, âna rà popa ê pâ ârabwée kêe. Â rà ipâdi naa goorà ma ipârirà. Â rà popa mwara i ârabwée kêe na gòri, na nye ticè autaa na. ");
INSERT INTO priNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Â rà pi-ina tàra pâ: «Jè cibwaa pidàdàrù. Wâdé na jè picàù noo kâra tii naa goo, ba na jè tâmogòori cè pwina kêe.» Êkaa na jèe pâra nau coo ê auina naa na *Tii Pwicîri, na ina pâ: Rà ipâdi ârabwée kôo. Rà picàù noo kâra tii naa goro ârabwée gòri. Psaume 22.19 Ba wàépwiri ê tûâ kà tèpa coda. ");
INSERT INTO priNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Pwa ârapàpé ilàri na rà cimwünyabweri i satauro—wà nyaa kà Iésu, ma tô ilàri aéjii kà nyaa kêe, ma wà Maria, tô wâdà Cléopas, ma wà Maria gée Magdala. ");
INSERT INTO priNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Â é tâa wê mwara wà pwi jè a *câmu na dau wânüma Iésu gooé. Âna é coo goro jènere nyaa kà Iésu. Ûna é côoru wà Iésu, â é ina tà nyaa kêe pâ: «Nyaa, wàépwiri ê pwina naîgà.» ");
INSERT INTO priNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Â é ina mwara tà pwi a câmu kêe pâ: «Wàéni wà nyaa'gà.» Â tapoo napwiri, â é popaé pâ naa na pwârawâ kêe wà pwi a câmu kêe bèeni. ");
INSERT INTO priNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","É tâmogòori wà Iésu pâ é jèe tubamwara diri ê wakè kêe, â é ina pâ: «Nümoo dàra wâdo.» Êkaa na pacoo ê auina naa na Tii Pwicîri. ");
INSERT INTO priNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Â tâa wê jè wâra jawé, na pwa dipâa na maga na. Â wà tèpa coda, âna rà popa jè imwaano, â rà tòo naa goro pé bàra upwâra hysope. Â rà tùu boo naa na i dipâa, â rà cipa too na pwâ Iésu. ");
INSERT INTO priNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Â é nacai. Â nabwé, â é ina pâ: «Go jèe po cau pacoo diri.» Â é cigòboo, â êgò ôomaa kêe. ");
INSERT INTO priNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Bwaa papwicî, tòotù béaa kâra ê *tòotù pwicîri kà tèpa Juif. Â rà ilari jii wà Pilato wà tèpa pitûâ kàra pâ na rà téciò ê pâ duuru â tàpé na rà tâa goro i satauro ba na o wàcî pai bà kàra. Ba nümarà na tapwùtùrà, ba na o càra caa tà utòtòro goro satauro, na tòotù pwicîri. Ba wà pwi tòotù pwicîri-bà, âna pwi tòotù na dau ipwamuru naa goo. ");
INSERT INTO priNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Â é cùru pâ pàra tèpa coda, â rà téciò du duuru â wà tupédu ârailu âboro na ru tâa goro jènere Iésu. ");
INSERT INTO priNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Êco na, ûna rà tèepaa pâ naa goo wà Iésu, â rà côo pâ é jèe bà, â càra caa burà téciò âê. ");
INSERT INTO priNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Êco na wà pwi jè coda, âna é tòtée i jènereê, goro da, â nye joro kaa domii ma jawé. ");
INSERT INTO priNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","(Wâgo, pwi a wii ê tii bèeni âna go wiâ ê pwina go côo, â jèkutâ na âjupâra. Â go wiâ, ba na guwà cèikî naa goo, wâguwà mwara.) ");
INSERT INTO priNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","37","Jèe pâra nau tèepaa ê pâ muru bèepwiri, ba na coo ê du auina naa na Tii Pwicîri, pâ: O nye ticè duué na o téciò. Â: Rà mwa côo wà pwina rà tòtée goro da. ");
INSERT INTO priNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Pwa pwi jè âboro na nee Ioséfa, pwi âboro gée Arimathée. Wà pwiibà âna é wâgoo wà Iésu, êco na câé caa pâra wiâê pàpari, ba wâgotêe goo tèpa pitûâ kà tèpa Juif. Â é ilari jii wà Pilato i naii wà Iésu, â é naa tàrù têe wà Pilato. Â é pâra wà Ioséfa, ba na é popaé. ");
INSERT INTO priNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Â é pâra wiâê wà Nicodème, wà i pwi âboro na ia é pâra dari Iésu na ne. Â é pwa ma pame ê jawé ûrea, na pwa goro aloès ma myrrhe, na wâna 30 kilo. ");
INSERT INTO priNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Ru popa ê naii Iésu, â ru târamiri goro imwaano na gòri. Â ru *upwaaé goro i jawé ûrea, wiâra ê nyamanya kà tèpa Juif, na rà ipwàni. ");
INSERT INTO priNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","42","Â ru popaé pâ naa na jè ére na câmi goro upwâra, na wâmwünyabweri i ére na ténamiri Iésu naawê. Â ru tòpòé naa na pé pwi diopwaa kâra pwâramara-atü, na bwaa nye ticè âboro bà na tòpòé naa na. Ru pwàniriê naawê, gée goo na, o jèe tapoo tòotù pwicîri naa bàrane, â pwicîri na rà pwàniri âboro bà, na pwi tòotù-bà. ");
INSERT INTO priNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Na pwapwicîri, na dàuru kâra *tòotù pwicîri kàra na bwaa gòropwaa, âna é pâra naa na auipwàni wà Maria gée Magdala. Â é côo i diopwaa kâra atü, bécamoori i pwêe, âna jèe pwùru tâjii. ");
INSERT INTO priNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Â é itàa wâjué côwâ, nau pâmari Simona Pétéru, ma wà pwi jè a *câmu na dau wânüma Iésu gooé. Â é ina tàru pâ: «Rà jèe popa wà Pwi Ukai gée na auipwàni, â câbà caa tâmogòori cèna rà tòpòé naawê.» ");
INSERT INTO priNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","4","Â ru pò ma pâra wà Pétéru ma pwi bée, â ru itàa naa na auipwàni. Â é dau awài wà pwini jii wà Pétéru, â é mara tèepaa pâ. ");
INSERT INTO priNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Â câé caa tò, â é nye po cùué boo, â é niâ dò naadò wâ, â é côo ê pâ imwaano co na gére tâaboo naani napuu. ");
INSERT INTO priNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Ûna é tèepaa pâ wà Simona Pétéru, â é nye tò kaa naadò wâ na auipwàni. Â é côo pâ imwaano na tàgére tâaboo naani napuu. ");
INSERT INTO priNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Napwa naa goo ê imwaano bépii pûruê, âna càcaa pitànaima bau ê pâ imwaano-bà. É nye pwa-ité tâa naa na jè ére, na nye cùu bwàti. ");
INSERT INTO priNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Â ée mwa caa pwicò kà Pétéru wà pwi bée. Â é côo, â é cèikî pâ wà Iésu, âna é jèe wâro côwâ gée na aubà. ");
INSERT INTO priNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","(Êco na càru caa pâji po tâmogòori bwàti ê pâ auina naa na *Tii Pwicîri, naa goro pai wâro côwâ kà Iésu.) ");
INSERT INTO priNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Nabwé, â ru pâra côwâ wà tupéeni naa pwârawâ na ru pitâa na. ");
INSERT INTO priNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Napwa naa goo wà Maria, âna é tà coo boo goo i pwâramara-atü, âna é nye tà i wê. Â é cùué boo, ba na é niâ dò naadò wâ. ");
INSERT INTO priNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Â é nye côo kaa du *angela, na ru coona ârabwée pwaa. Wà pwi jèpwi, âna é tâa na na ia tâa wê i pûru wà Iésu; â wà pwi jèpwi, âna é tâa na na ia tâa wê i du âê. ");
INSERT INTO priNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Â ru tawèerié pâ: «Tôoni, cina gà i?» Â é ina tàru pâ: «Go imuru Pwi Ukai kôo, ba rà jèe popaé, â câgo caa tâmogòori cèna rà tòpòé naawê.» ");
INSERT INTO priNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","É ina pwiri, â é tabiié, â é côo wà Iésu na é tàgére coo wê, êco na câé caa côoinaê. ");
INSERT INTO priNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Â é ina têe pâ: «Tôobà, cina gà i? Gà mudà î?» Êco na é tà niimiri wà Maria pâ, wà pwiibà âna wà pwi âboro na é tòimiri i na upwâra. Â é ina têe pâ: «Wiàna wâgà pwi a popa naii Pwi Ukai Iésu â gà paari tôo na gà tòpòé naawê, ba na go pâ nau popaé.» ");
INSERT INTO priNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Â é ina têe wà Iésu pâ: «Maria!» Â é tabèreè wà Maria, â é nye côoinaê kaa, â é ina têe naa na pwâratùra *hébéru, pâ: «Au, Rabbouni!» (Pai ina wèe pâ ‘Pwi a pwa pupûra’.) ");
INSERT INTO priNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Â é ina têe wà Iésu pâ: «Gà cibwaa tu naa gooò, ba bwaa câgo caa too dari Caa. Â gà pâra naa jaa tèpa béeò. Â gà ina tàra pâ, go o jèe too dari Caa kôo, wà pwi Caa kàwà mwara; wà Pwiduée kôo, ma wà pwi Pwiduée kàwà mwara.» ");
INSERT INTO priNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Â é pâra wà Maria, â é pâdari tèpa câmu. Â é ina tàra pâ: «Tàpéebà! Go jèe côo wà Pwi Ukai!» Â é piwiâ tàra ê pwâra pitùra kàru. ");
INSERT INTO priNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Na bàrane kâra pwi pwapwicîri-bà, âna rà pitànaima na jè pwârawâ wà tèpa câmu. Â rà kiiri ê pâ goropwârawâ, ba wâgotàra goo tèpa pitûâ kà tèpa *Juif. Â é nye tèepaa kaa naa nabibiu kàra wà Iésu. Â é ina tàra pâ: «Cidòri nyuâawà!» ");
INSERT INTO priNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Â é paari tàra du na-araraîê ma ê jènereê. Â rà nye dau ipwàdée kaa na rà côo wà Pwi Ukai. ");
INSERT INTO priNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Â é jèu ina tàra pâ: «Cidòri nyuâawà! É cùruo me wà Caa naa na gòropuu; â nabàni, âna go cùruwà pwacèwii pai pwa kêe tôo.» ");
INSERT INTO priNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Â é upirà, ma ina tàra pâ: «Guwà tòpi ê Nyuâaê Pwicîri! ");
INSERT INTO priNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Wiàna guwà pwanauri ê pâ èpà kâra ê pâ âboro, â é pwanaurirà wà Pwiduée. Â wiàna câguwà caa pwanaurirà, â ê pâ èpà kàra âna o nye tà tâa.» ");
INSERT INTO priNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Napwa naa goo wà Toma (pwi ârapàara tèpa 12 a câmu, jè nee mwara ‘Bérepidu’), âna tà tiàué jaarà na ê pwi tòotù na é tèepaa marirà wà Iésu. ");
INSERT INTO priNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Â rà mwa tà ina têe wà pàra tèpa câmu pâ: «É cipàparibà wà Pwi Ukai.» Êco na é tòpi tàra pâ: «Auwa! Pwacoé na go cèikî pâ é wâro côwâ! Wâdé co wiàna go côo ê auru paò goro du na-araraîê. Â wiàna go tùu gée goo ê mangadaîô naa na ê auru paò, ma tòpò mwara ê na-araraîô naa goo i jènereê!» ");
INSERT INTO priNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Gée na càùru caapwi nadàpàra pwapwicîri, â rà pitànaima mwara wà tèpa câmu naa na i wâ, â jèe wàilà ma Toma. Â rà kiiri ê pâ goropwârawâ, êco na é tèepaa marirà wà Iésu. Â é coo nabibiu kàra, â é ina tàra pâ: «Cidòri nyuâawà!» ");
INSERT INTO priNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Â é ina tà Toma pâ: «Gà côo i du na-araraîô. Â gà tòpò i mangadaîgà naa na. Â gà pame i na-araraîgà, â gà tòpò naa goo i jènereô. Â gà cibwaa pidumapiê, â gà cèikî!» ");
INSERT INTO priNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Â é tòpi têe wà Toma pâ: «Pwi Ukai kôo ma Pwiduée kôo!» ");
INSERT INTO priNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Â é ina têe wà Iésu pâ: «Gà mwa cèikî ba gà côoô. Cidòri nyuâa tèpa âboro na rà cèikî, na càra caa côoô.» ");
INSERT INTO priNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Dau wâru ê pâ *câmu kâra pàtàma Pwiduée na é pwa wà Iésu, na ara tèpa câmu kêe. Càcaa wii diri naa na ê tii bèeni. ");
INSERT INTO priNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Êco na ê pâ popai bèeni gére wii, âna wii, ba na guwà cèikî pâ, wà Iésu âna é pwi *Mesia, *Pwina naî Pwiduée. Â wiàna guwà cèikî naa gooé, â o tà tàwà ê *âji wâro na wâgooé. ");
INSERT INTO priNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Gée na càùru pàra tòotù, â é ipaarié mwara wà Iésu, tà tèpa *câmu kêe, na bàrawià Galilée. Â wàéni ê pai ipaarié tàra: ");
INSERT INTO priNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Rà picaatâa wà pàra tèpa câmu kêe—wà Simona Pétéru, ma Toma (jè nee mwara ‘Bérepidu’), ma Natanaël (pwi âboro gée Kana wâ Galilée), ma wà tupédu naî Zébédée, ma tupédu ârailu mwara. ");
INSERT INTO priNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Â é ina tàra wà Simona Pétéru pâ: «Go bwaa pâra nau pwa puà.» Â rà ina têe pâ: «O wàijè.» Â rà pâra, â rà too naa na i wànga, â rà pâra nau pwa puà. Êco na, na pwi ne-bà, âna nye ticè ârapokâa kàra. ");
INSERT INTO priNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Na pâra nau pwaa dòme, âna wà Iésu, âna é nye tà tâa nidò bàrawià. Êco na bwaa càra caa côoinaê. ");
INSERT INTO priNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Â é ina tàra pâ: «Ico tàpéeni, nye pwa cè ârawéà kàwà?» Â rà tòpi têe pâ: «Auwa, nye âji ticè.» ");
INSERT INTO priNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","É ina tàra pâ: «Guwà tòpò i puà naa gòro étò kàwà, ma o pwa cè ârawéà kàwà!» Â rà tòpò, â jèe càcaa pâri ma rà dàgòtù, ba dau tòina goro ê pai wâru wàra pâ ârawéà. ");
INSERT INTO priNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Â wà i pwi a câmu na ia dau wânüma Iésu gooé, âna é ina tà Pétéru, pâ: «Ée! Wà Pwi Ukai pwiri!» Â wà Pétéru, âna é nye nama pòpii i ârabwée kêe goro opiié, â é nye êgò kaa naa nawià, â é éoo too dari Iésu. ");
INSERT INTO priNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Â rà gére me mariru wà pàra tèpa câmu bée gòro i wànga. Â rà jèe po tadàti i puà, goro ê pai wâru wàra ê ârawéà na. Ba rà jèe tà wâmwünyabweri ê bàrawià. ");
INSERT INTO priNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Â rà tâdòo, â rà boo gée na i wànga, â rà tòpaé. Â rà pâmari ê poloa bau ê pâ ârawéà na tâa na dàuru ânye. ");
INSERT INTO priNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Â é ina tàra wà Iésu pâ: «Pame cè pàra ârawéà gée goro ê pwina guwà bwaa taa.» ");
INSERT INTO priNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Â wà Simona Pétéru, âna é wâjué côwâ naa na i wànga ba na é dàti dò naa gòromwari i puà. Â po 153 ârawéà maina na tâa na i puà, êco na càcaa madàpa i puà. ");
INSERT INTO priNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","13","Â é ina tàra wà Iésu pâ: «Jè ija.» Â é popa i poloa ma i ârawéà, â é jèpa naa tàra jècaa. Â nye ticè pwi jèpwi gée goorà, cèna é tawèerié pâ «Gona wâgà wàa?» Ba rà jèe nye tâmogòori pâ wà Pwi Ukai. ");
INSERT INTO priNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Wàépwiri béâracié kâra pai ipaarié kêe tà tèpa câmu kêe, gée na càùru ê pai wâro côwâ kêe gée na aubà. ");
INSERT INTO priNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Gée na càùru ê pai pi-ija kàra, â wà Iésu, âna é tawèeri Simona Pétéru pâ: «Simona, pwina naî Iona, gona dau pimaina ê pwâranümagà gooò, jii ê pwâranüma wà tàpéeni gooò?» Â é tòpi têe wà Pétéru pâ: «Üu kaa, co Pwi Ukai, gà jèe nye tâmogòori pâ go pwi gòrobéegà.» Â é ina têe wà Iésu pâ: «Gà mwa tà pa-ija i pâ nari mutô kôo.» ");
INSERT INTO priNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Â é wailu tawèerié pâ: «Simona, pwina naî Iona, gona dau wânümagà gooò?» Â é tòpi têe mwara pâ: «Üu kaa, co Pwi Ukai, ba gà nye tâmogòori pâ go pwi gòrobéegà.» Â é ina têe wà Iésu pâ: «Gà mwa tà wéaari i pâ mutô kôo.» ");
INSERT INTO priNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Â é wacié tawèerié pâ: «Gona gà nye pwi gòrobéeò?» Â é nye dau pikîri kaa wà Pétéru, gée goro na é jèe po wacié tawèerié. Â é tòpi têe pâ: «Pwi Ukai, gà nye tâmogòori diri ê pâ muru, â gà nye tâmogòori pâ go pwi gòrobéegà.» Â é ina têe wà Iésu pâ: «Gà mwa tà pa-ija i pâ mutô kôo. ");
INSERT INTO priNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Gà têre bwàti, ba go ina tâgà ê âjupâra pâ: Na pàara na gà bwaa dopwa na, âna gà nye ipii acari ê karapuu'gà. Â gà nye pâra naa na ére na gà câbawâdé. Êco na, wiàna gà mwa ijiao, â gà o mwa patàrù ê du îgà, â ée mwa pii ê karapuu'gà cè pwi jèpwi. Â ée mwa popagà pâ naa na ére na càcaa nümagà na gà pâ naawê.» ");
INSERT INTO priNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","(É ina pwiri, ba na é inapàpari ê pai o bà kà Pétéru, târa ma o pwamaina wà Pwiduée.) Ûna é jèe ina pwiri, â é ina têe wà Iésu mwara pâ: «Gà me wiâô!» ");
INSERT INTO priNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Na gére wàrapwiri, â wà pwi a câmu na ia dau wânüma Iésu gooé, âna é gére me wiâru. (Wà pwiibà, âna i pwi ia é tâa goro jènere wà Iésu, na i pwi bénabwé pi-ija kàra, na ia é ina têe pâ: «Pwi Ukai, wàilàapà na o ipwa tûâ tâgà?») Â é tabiié wà Pétéru ");
INSERT INTO priNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","â é côoê, â é ina tà Iésu pâ: «Pwi Ukai, âna wà pwini na?» ");
INSERT INTO priNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Â é tòpi têe wà Iésu pâ: «Wiàna nümoo na câé caa bà, tiagoro cè pai wâjué kôo côwâ; â ê pwiibà âna târa dà'gà? Wàéni ê pwina go ina tâgà: Gà me wiâô!» ");
INSERT INTO priNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Gée goo pwiri, na ipâra ê jèkutâ wânabibiu kà tèpa pâra wiâ Iésu, pâ, pwiri o câé caa bà wà pwi a câmu-bà. Caapwi co, na câé caa ina wà Iésu pâ, o câé caa bà. Â é nye po ina co pâ: «Wiàna nümoo na câé caa bà, tiagoro cè pai wâjué kôo côwâ, â târa dà'gà?» ");
INSERT INTO priNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Napwa naa goo wà pwi a câmu-bà, âna wàé na é *paâjupâra ê pâ muru bèepwiri, ma wii naa na tii. Â bà jèe nye tâmogòori pâ âjupâra ê pai ina kêe. ");
INSERT INTO priNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Nye dau wâru awé ê pàra muru na é pwa wà Iésu. Êco na, wiàna jè cau wii diri, â go niimiri pâ, ê gòropuu âna é po dau kîri târa ma tâa na! Nabwé!");
INSERT INTO priNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Théophile, naa na ê tapoo tii kôo, âna go piwiâ tâgà diri ê pwina é pwa wà Iésu, ma é pacâmuri gée na autapoo goo, ");
INSERT INTO priNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","tiagoro ê tòotù na dàgòtùé too naa *napwéretòotù. Béaa kâra ê pai too kêe, âna é naa tà tèpa âboro ê pâ naèà kêe, goro ê pàtàmara ê Nyuâaê Pwicîri. Wà tèpa âboro bèepwiri, âna é jèe pitòrigarirà, ba naa tèpa *apostolo kêe. ");
INSERT INTO priNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Gée na càùru ê pai bà kêe, â é piâpàparié tàra. Â wâru ê pâ muru na é pwa, ba na é paari tàra pâ é jèe wâro côwâ. Â é pipaarié tàra na pàra pàara naa na 40 tòotù, â é picémara ê *Mwaciri kà Pwiduée. ");
INSERT INTO priNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Ûna é bwaa tâa jaarà, â é ina tàra pâ: «Guwà cibwaa pâra gée *Iérusaléma, ba na guwà tapacîri i pwi, na ia é jèe ina béaa wà Caa, â ia go jèe ina tàwà mwara. ");
INSERT INTO priNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Ba wà Ioane, âna é *piupwaa goro jawé. Â napwa naa goowà, âna càcaa dàra wâru cè pâ tòotù, â o *upwaawà goro ê Nyuâaê Pwicîri.» ");
INSERT INTO priNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Ûna rà caatâa wà tèpa apostolo ma wà Iésu, â rà tawèerié pâ: «Pwi Ukai, o napwiri na gà o tòpò côwâ ê mwaciri wâ *Isaraéla?» ");
INSERT INTO priNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Â é tòpi tàra pâ: «Càcaa wâguwà na, na guwà tâmogòori ê pâ pàara ma tòotù na é tòpò wà Caa wiâra ê câbawâdé kêe. ");
INSERT INTO priNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Êco na guwà o tòpi ê pàtàmara ê *Nyuâaê Pwicîri, na ée mwa me naa gòwà, ba na guwà o mwa tèpa *paâjupâraô na Iérusaléma, ma naa na diri ê pâ ére wâ napô *Judée ma Samaria, ma tia pwâadàra ê gòropuu.» ");
INSERT INTO priNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Gée na càùru na é ina tàra pwiri, â càùé too jiirà naa napwéretòotù. Â tiàué naa na pé nee. ");
INSERT INTO priNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Ûna rà bwaa nye tàgére niâ too wiâê, â rà pò goo tupédu âboro na ru coona ârabwée pwaa, ");
INSERT INTO priNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","â ru ina tàra pâ: «I tàpé Galilée, cina guwà tàgére coo awé? Cina guwà tàgére côo ê napwéretòotù? Guwà nye côo ê pai too kà Iésu bèeni naa napwéretòotù, â na o mwa wàrapwiri cè pai wâjué côwâ kêe.» ");
INSERT INTO priNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Wà tèpa apostolo, âna rà wâjué côwâ gée gòrojaa Élaio, pâ naa Iérusaléma, tàpo wâna caapwi kilomètre. ");
INSERT INTO priNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Ûna rà tèepaa pâ, â rà too naa na ê pwi naditàrawâ na tâdòiti wâna ê pwârawâ na rà mu ciburà tâa wê. Wà tàpéebà, âna wà Pétéru, Ioane, Jacques ma André, Filipo ma Toma, Barthélemy ma Mataio, Jacques pwina naî Alphée, Simona pwi Zélote, ma wà Jude pwina naî wà Jacques. ");
INSERT INTO priNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Â rà caajurirà, â rà nye tà pwapwicîri taaci, wàilà ma pa ilàri, ma wà Maria nyaa kà Iésu, ma wà tèpa jii Iésu. ");
INSERT INTO priNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Na pwi jè tòotù, âna po 120 wàilà tèpa cèikî na rà picaatâa, â é cimadò gée nabibiu kàra wà Pétéru, â é ina tàra pâ: ");
INSERT INTO priNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","17","«Tèpa aéjii kôo, wâdé na coo ê auinapopai naa na Tii Pwicîri, na é pinaigé mee ê Nyuâaê Pwicîri na ia é tùra goo wà *Davita. Ba é jèe ina béaa pâ wà Judas—pwi jè apostolo béebà—âna ée mwa pwi naigé mee, ma rà tâjùru wà Iésu.» ");
INSERT INTO priNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(Napwa naa goo wà Judas, âna é pa ê napuu goo wâri wàra pai icuri kêe wà Iésu, â é tûu, â tabòaa ê naaê, â tabaêgò ê pâ wâgooé. ");
INSERT INTO priNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Ê pwi jèkutâ bèepwiri, âna rà capai tâmogòori diri wà tèpa âboro na ville Iérusaléma, â rà pwa ma neere ê pwi ére-bà pâ Hakeldama, na pai ina wèe naa na pairà pâ ‘napuu na pwa domii na’.) ");
INSERT INTO priNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Â é tòobàra pâ wà Pétéru, â é ina pâ: «Ba jèe wii naa na tii Salamo pâ: O ticia pwârawâ kêe. O ticè cèna ée mwa tâa wê. Psaume 69.26 «Â jèe wii mwara pâ: É tòotérié pwi jèpwi. É popa wakè kêe. Â wâdé na wàra. Psaume 109.8 ");
INSERT INTO priNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","«Êkaa na wâdé na pwa cè pwi jè béebà, ba na pwi jè a *paâjupâra ê pai wâro côwâ kà Iésu. Wâdé na wà pwi âboro-bà, âna pwi jè ârapàara tàpé na rà mu nye ciburà pâra wiâjè, naa na pàara na é bwaa tâa jaajè wà Pwi Ukai kâjè—tapoo na é piupwaa wà Ioane; tiagoro ê pai too kà Iésu naa napwéretòotù.» ");
INSERT INTO priNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Rà pitòrigari tupédu ârailu—wà Ioséfa na nee Barsabbas, jè nee mwara Justus, ma wà Matthias. ");
INSERT INTO priNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Â rà capai pwapwicîri, â rà ina pâ: «Pwi Ukai, wâgà na gà tâmogòori ê pwâranümara diri ê pâ âboro; gà paari tâbà cè pwi âboro na gà jèe pitòrigarié naa na tupédu âboro bèeni, ");
INSERT INTO priNT_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","ma é pa wakè kà Judas ma pwi apostolo. Ba é jèe panuâ ê wakè kêe wà Judas, â é jèe pâra naa na ê pwi ére kêe. Ba é jèe tòpi ê pumara wakè kêe na èpà.» ");
INSERT INTO priNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Â rà càù noo kâra tii naa gooru, â wâru noo kâra tii kà wà Matthias, â rà naaê gée, ma pwi bée wà tèpa 11 apostolo. ");
INSERT INTO priNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Na tòotù kâra Pentecôte, *tòotù maina kâra piûnya âna rà pitànaima na jè ére wà tèpa cèikî. ");
INSERT INTO priNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Â rà nye têre kaa ê pwina é boome gée napwéretòotù na pwa aié na pwacèwii ê airi pwéretòotù na dau maina. Â é nye pwaai kaa ê wâ na rà tâa na. ");
INSERT INTO priNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Â rà côo na tèepaa me ê pâ pwina pwacèwii ê doromara ânye, â jèpa ti gòrà jècaa. ");
INSERT INTO priNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Â ê Nyuâaê Pwicîri, âna é nye tûu kaa naa gòrà diri, â rà tùra na ê na jèpapara pwâratùra, wiâra na é naa tàra ê Nyuâaê Pwicîri. ");
INSERT INTO priNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Na pwi pàara bèepwiri, âna rà wâro wâ *Iérusaléma wà tèpa *Juif na dau wânümarà tàra ê pwapwicîri, âna rà me gée na diri ê gòropuu pitiri. ");
INSERT INTO priNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Â wà tàpéebà, âna rà cau itàa, ma caatâa naa, na rà têre pâ naawê i pwi airimuru. Â po tabaticè nümarà, ba rà têre tèpa cèikî na rà tùra naa na jèpapara pwâratùra. ");
INSERT INTO priNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Po dàpàgà tàra, â rà pitawèerirà pâ: «Gona wà tèpa âboro bèeni na rà gére tùra, âna càcaa tèpa âboro diri gée Galilée? ");
INSERT INTO priNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Â gorodà na jè têrerà, na rà gére tùra na jèpa paijè jècaa?» ");
INSERT INTO priNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Ba gée nabibiu kàra, âna pwa tèpa âboro na rà me gée napô *Judée. Â pwa pàra tàpé na rà me gée na pâ napô—gée Parthes, ma Médie, ma Élam ma Mésopotamie. Â pwa pàra tàpé na rà me gée na jè province kà tèpa *Roma—Cappadoce, ma Pont, ma Asia, ");
INSERT INTO priNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","â gée na ére mwara wâ Phrygie ma Pamphylie. Â wà pàra tàpé, âna rà me gée napô *Aigupito, â gée na nyi nari napô gée goo na ville Cyrène wâ Libye. Â wà pàra tàpé mwara, âna rà me gée Roma, ");
INSERT INTO priNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","â gée gòropô wâ Crète; â gée napô Arabie. Â pwa pàra tàpé gée jaarà, âna rà nye tèpa âji Juif; ma wà tàpé na rà cèikî naa goro ê pwapwicîri kà tèpa Juif. Â rà pitawèerirà pâ: «Gona dà majoroé ma jè têre wà tèpa âboro Galilée bèepwiri na rà gére ina naa na ê jèpa paijè ê pâ muru na maina na é pwa wà Pwiduée?» ");
INSERT INTO priNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Â rà dau pò diri, â càra caa tâmogòori cèna rà niimiri, â rà pi-ina tàra pâ: «Dà pai ina wèe ni?» ");
INSERT INTO priNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Êco na pwa pàra tàpé na rà piècaari tèpa cèikî, â rà ina pâ: «Bwa! Rà nye dau ipwirié kaa goro dipâa!» ");
INSERT INTO priNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","É cimadò wà Pétéru ma wà tèpa 11 *apostolo bée, â é mwa patùrarà, ba na rà tâmogòori bwàti. «Bwa; guwà têre, co tèpa jènereô, ma wâguwà diri na guwà wâni Iérusaléma. Guwà tàpo tàmaa ma go ina bwàti tàwà ê pwina gére tèepaa. ");
INSERT INTO priNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Wà tèpa âboro bèeni, âna càra caa ipwirié pwacèwii ê pai niimiri kàwà, ba mwa nye gére 9h dàuru kaa. ");
INSERT INTO priNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Bwa! Wàéni kaa i popai kà Pwiduée, na é naigé mee wà *péroféta Joël: ");
INSERT INTO priNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Go o mwa naa boopaé ê Nyuâaê kôo naa gò tèpa Ba, na tòotù pwicò. Go o mwa naa popai kôo tà pa èpo paao ma èpo kàwà. Rà mwa tomara too târa inapàpari. Go o mwa paari pâ muru na nyuâa tà pa èpo dopwa kàwà. Go o mwa patùra tèpa ijiao kàwà naa na naurune. ");
INSERT INTO priNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Go o naaboo Nyuâaô, na pwi pàara-bà, naa goo pâ ênawéna kôo, pa ilàri ma paao. Rà mwa picémara popai kôo. ");
INSERT INTO priNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","20","Go o nama tèepaa pâ muru na ité na càcaa mu côo naa gopaérenao ma naa gòropuu. Too ânye ma mu. O câé caa té tòotù. Ba é biié ma bàutê O mii parui pwacèwii domii. O cau coo diri béaa kâra pwi tòotù —tòotù kà Pwi Ukai. Nyamu ma pwényuâa pwi tòotù kôo-bà. ");
INSERT INTO priNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Ée mwa udò awé wà pwina ée mwa todòo na pwi tòotù-bà!» Joël 3.1–5 ");
INSERT INTO priNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","É ina mwara wà Pétéru pâ: «Tèpa âboro *Isaraéla, tàpo tàmaari ê popai na go ina tàwà: Wà Iésu pwi âboro Nazareth, âna wà pwi âboro na é jèe tàmara pitòrigarié wà Pwiduée. Â wà Pwiduée, âna é jèe paarié tàwà, ba é nama é pwa ê pâ *câmu kâra pàtàmee naa nabibiu kàwà, na guwà pò goo. ");
INSERT INTO priNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Wà pwiibà, âna pinaaê tàwà, â guwà pwa ma é bà, ma guwà nama rà tanamiriê naa goro *kurucé wà tèpa âboro èpà. Êco na é mara tâmogòori diri pwiibà wà Pwiduée, â nye câbawâdé kêe na wàrapwiri. ");
INSERT INTO priNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Â gée na càùru ê maagé côo kà Iésu â é upaé jii ê pwâra bà, â é pawâroé côwâ. Ba nye ticè pàtàmara ê pwâra bà naa gooé. ");
INSERT INTO priNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Ba é jèe tàmara picémaraê wà *Davita na é ina pâ: Go nye tà côo taaci wà Pwi Ukai béaa kôo. É tâa gòro âji îô, â câgo caa gùmagù. ");
INSERT INTO priNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Go ipwàdée ma picagòtùé! Ba wiàna go bà, â o nye tà wâdé naa gooò. ");
INSERT INTO priNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Go ina têe pâ: Gà jèe pitòrigario ma go pwi ênawéna'gà. O câgà caa panuâ nyuâaô ma é tâa na aubà. O câgà caa panuâ naiio ma o wai ma botére. ");
INSERT INTO priNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Gà jèe paari tôo ê naigé mara wâro. Go o mwa ipwàdée, ba gà tà wâjaao!» Psaume 16.8–11 ");
INSERT INTO priNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","É tòobàra pâ wà Pétéru, â é ina tàra pâ: «Tèpa jènereô, câgo caa piwâ na go ina ba pwéelaa tàwà pâ: Wà pwi jojoorojè Davita, âna é bà, â pwàniriê, ba jè bwaa tà côo nabàni ê bwàmu kêe, naa jaajè. ");
INSERT INTO priNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Êco na é nye pwi péroféta, ba é pame ê popai gée jaa Pwiduée â é nye tâmogòori ê *auipwataâboro kà Pwiduée na é ina têe pâ: Go o mwa pitòrigari cè pwi âboro caapwi gée goo wà tèpa gòobàragà. Ée mwa tâa na autâa'gà. Ba wâgo na go o mwa pwa. Psaume 132.11 ");
INSERT INTO priNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","«Ûna é ina pwiri wà Davita, â é mara ina wà pwi *Mesia na ée mwa me. Ûna é ina pâ, o câé caa panuâê naa na aubà, â o càcaa wai ma botére ê naiié, â é inapàpari ê pai wâro côwâ kà pwi Mesia. ");
INSERT INTO priNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Â wà pwi Iésu na go gére ina tàwà, âna wàé kaa pwiri, ba wà Pwiduée, âna é jèe pawâroé côwâ gée na aubà. Â nye wàibà kaa tèpa *paâjupâraê diri. ");
INSERT INTO priNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","«Â é naaê too wà Pwiduée Caa naa gòro âji îê ba na é pitûâ kâra diri pâ muru â é naa têe ê Nyuâaê Pwicîri, na é jèe nabwé ina béaa. Êkaa na naa boome naa gòbà ê Nyuâaê Pwicîri, wàra na guwà gére côo ma têre nabà. ");
INSERT INTO priNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","35","Ba wà Davita, âna câé caa too naa napwéretòotù, êco na é ina pâ: Popai kà Pwi Ukai, Pwi Ukai Pwiduée na é patùra Pwi Ukai kôo: “Gà me ma gà tâa ni. Tâa ni gòro îô étò. Go naa tâgà ê pitûâ. O pwamainagà awé. Go nama gà còogai tèpa ipaa dàgà.” Psaume 110.1 ");
INSERT INTO priNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","«Wâdé na wâguwà ê Ba Isaraéla, âna guwà câbaâjupâra pâ, wà i pwi Iésu na ia guwà tanamiriê naa goro kurucé, âna é nama é pwi Mesia ma Pwi Ukai wà Pwiduée.» ");
INSERT INTO priNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Na rà têre ê popai bèepwiri, â cau tatée ma tabagéaa diri ê pwâranümarà, â rà ina tà Pétéru ma tèpa apostolo bée pâ: «Tèpa jènerebà, na bà pwa dà?» ");
INSERT INTO priNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Â é ina tàra wà Pétéru pâ: «Guwà pinünüma ma guwà biiwà. Â guwà nama *upwaawà jècaa, naa na nee wà Iésu *Kériso, ba na o pwanauri ê pâ èpà kàwà, â na guwà o tòpi ê âraimeai, i Nyuâaê Pwicîri. ");
INSERT INTO priNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Ba ê auinabéaa bèepwiri, âna kàwà ma tèpa naîwà ma diri ê pâ âboro na rà wâiti awé na ée mwa todàra wà Pwiduée, Pwi Ukai kâjè.» ");
INSERT INTO priNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Dau wâru mwara ê pâ popai na é paâjupâra tàra ma pagòorà goo wà Pétéru. Â é ina tàra mwara pâ: «Guwà upiri ê pâ naneeâboro na èpà tûâ kàra, ba na o tâa tàwà ê *âji wâro.» ");
INSERT INTO priNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Nye wâpâ na 3 000 âboro kaa, na rà tòpi ê popai kà Pétéru na pwi tòotù bèepwiri. Â rà cèikî naa goo wà Iésu, â *upwaarà. Â mwa tèpa bée tàpé na rà cèikî béaa. ");
INSERT INTO priNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Wà tèpa cèikî, âna rà nye tà ciburà pitànaima ma tèpa apostolo, ba na rà têre bwàti ê pupûra kàra. Â rà pitubiti naima ê poloa, ma pwapwicîri naima. ");
INSERT INTO priNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Wâru pâ câmu kâra pàtàma Pwiduée na rà pwa wà tèpa apostolo. Â wà tèpa âboro, âna rà pò goo, â rà pitòimirirà ma piaabòrirà. ");
INSERT INTO priNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Wà diri tèpa cèikî âna caapwi pwâranümarà, â rà pwa ma ê jèpa neemururà, âna capai kàra. ");
INSERT INTO priNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Rà icuri ê pâ napuu kàra ma ê pâ wâdé kàra, â rà ipâdi naa goorà ê wâri wèe, wiâra ê pwina tiàu jiirà. ");
INSERT INTO priNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Na diri ê pâ tòotù, âna rà capai pwapwicîri naima wâna *Wâra pwapwicîri. Â rà pi-ija naima naa na ê pâ pwârawâ kàra, naa na ipwàdée ma ipakîri. ");
INSERT INTO priNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Â rà pwamaina wà Pwiduée, â rà ipwàdée goorà wà tèpa âboro. Â wà Pwi Ukai, na diri ê pâ tòotù, âna é nama piwâru too tàpé na rà udò. ");
INSERT INTO priNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Na pàara kâra pwapwicîri na, na âracié ineretòotù na càùru ija, â ru too naa na *Wâra pwapwicîri wà Pétéru ma wà Ioane. ");
INSERT INTO priNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Wâgoro ê Wâra pwapwicîri bèepwiri, âna pwa pwina é pitàbwamwa gée na ê pai pitèpaé. Â popaé me, na diri ê pâ tòotù, â tòpòé naa goro ê goropwârawâ, na ina goo pâ Goropwârawâ Wâdé. Â é ila mwani jii tèpa âboro na rà tò naadò wâ. ");
INSERT INTO priNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Ûna é côo wà Pétéru ma Ioane na pwa na ru tò naa na Wâra pwapwicîri, â é ilaru. ");
INSERT INTO priNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Â ru nye po ucâriê kaa, â é ina têe wà Pétéru pâ: «Niâribu!» ");
INSERT INTO priNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Â é nye po niâriru kaa, tapacîri cè pwina ru naa têe. ");
INSERT INTO priNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Êco na é ina têe côwâ wà Pétéru pâ: «Ticè mwani mii ma mwani pwaa kôo, êco na ê pwina tà tôo, âna go o naa tâgà. Naa na nee wà Iésu Kériso gée Nazareth, gà cimadò, â gà pâra!» ");
INSERT INTO priNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Â é tuboo naa goro îê étò wà Pétéru, â é dàgòtùé. Â nye wâdé kaa ê du âê. ");
INSERT INTO priNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Â é too na coo, â é jèe pâra. Â rà tò ma wàé naa na Wâra pwapwicîri. Â é ipwàdée, â é êgò ma pwamaina Pwiduée. ");
INSERT INTO priNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Diri ê pâ âboro na rà côoê na é pâra, âna rà ipwamaina Pwiduée. ");
INSERT INTO priNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Ba rà côoina pâ, wà i pwi ia é mu nye tà tâaboo goro Goropwârawâ Wâdé, ba na é ila mwani. Â cau dàpàgà tàra goo ê pwina tèepaa mariê. ");
INSERT INTO priNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Wà pwi âboro bèeni, âna é tàgére tâa goo wà Pétéru ma wà Ioane, â wà tèpa âboro na rà pò gooé, âna rà itàa medarirà naa na pwi wâ cikòmaa na ina goo pâ ‘Wâ kà *Solomona’. ");
INSERT INTO priNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Ûna é côo pwiri wà Pétéru, â é ina tàra pâ: «I tàpé *Isaraéla, gorodà na guwà pò goo ê pai wâdé kà pwini? Cina guwà gére côobu, pwacèwii na wàibu na pwa? Câé caa pâra wà pwi âboro bèeni, gée goo cè pàtàmabu, ma cè aupitòimiri kâbu! ");
INSERT INTO priNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","«Wà Pwiduée kà *Abéraama, ma Isaaka, ma Iakobo, wà Pwiduée kà tèpa jojoorojè, âna é paari pâ é dau maina, â é dau muugère wà pwi ênawéna kêe, wà Iésu. Â wâguwà na guwà icurié tà tèpa ukai kàwà, â guwà pitütôowâriê na ara wà pwi kupénoo *Pilato. Wà Pilato, âna é jèe nye niimiri pâ, na é panuâê côwâ, ");
INSERT INTO priNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","êco na tàutàwà na panuâ pwi âboro *tàrù na ia é pitòrigarié wà Pwiduée, â guwà mwa nye nama panuâ pwi a catàmwara âboro! ");
INSERT INTO priNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","«Êkaa na guwà pwa ma é bà wà Pwi Ukai kâra wâro. Êco na wà Pwiduée, âna é pawâroé côwâ jii tàpé na rà jèe bà. Â wàibà kaa na *paâjupâra. ");
INSERT INTO priNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","«Â nabàni, âna guwà cau côo ê pwina tèepaa tà pwi a pitàbwamwa bèeni, pwi âboro na guwà tâmogòorié. Ba é jèe wâdé na arawà diri, goro ê nee wà Iésu, ba bu cèikî naa gooé. Üu, go ina tàwà pâ: Ê cèikî naa goo wà Iésu na é nama é wâdé. ");
INSERT INTO priNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","«Êco, co tèpa jènereô, na go tâmogòori pâ i pwi ia guwà pwa tà Iésu, wâguwà ma tèpa ukai kàwà, âna guwà pwa na câguwà caa tâmogòori. ");
INSERT INTO priNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Êco na wà Pwiduée, âna é pacoo wàrapwiri ê auinabéaa kà tèpa *péroféta kêe pâ, wà Pwi *Mesia, âna ée mwa wâro na ê picâri. ");
INSERT INTO priNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","«Guwà pinünüma ma guwà biiwà medari Pwiduée, ba na o câtùra ê pâ èpà kàwà. ");
INSERT INTO priNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Ba ée mwa naa tàwà ê pinaanapô kêe, â ée mwa panuâ medariwà wà Iésu, pwi Mesia kêe, na é jèe pitòrigarié béaa, ba kàwà. ");
INSERT INTO priNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","«Êco na, ni, âna é bwaa wâ *napwéretòotù tiagoro ê pàara na o tòpò côwâ diri ê pâ namuru. Wà Pwiduée, âna é jèe cùru biu wà tèpa péroféta, ba na rà picémara pwiri. ");
INSERT INTO priNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Ba é ina wà *Moosé pâ: Wà Pwiduée ma Pwi Ukai kàwà, âna ée mwa pacima gée nabibiu kàwà cè pwi péroféta na é pwacèwiio. Wâdé na guwà mwa tà pitêre dèe naa na diri ê pâ pwina é ina tàwà. ");
INSERT INTO priNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Wà pwina câé caa pitêre dàra pwi péroféta bèepwiri, âna o naaê còobé jii ê Ba, â o catàmwereê. ");
INSERT INTO priNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","«Wà diri tèpa péroféta na tapoo gée goo wà Samuéla, âna rà pitòoté goro inapàpari ê pwina tèepaa nabàni. ");
INSERT INTO priNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","«Guwà tèpa naî tèpa péroféta, â ê pwi auina bèeni, âna kàwà mwara. Ba wà Pwiduée, âna é jèe pwa ê *auipwataâboro kêe tà tèpa caa kâjè, na é ina tà Abéraama pâ: Gée goo tèpa gòobàragà, âna go mwa *pwényunyuâari diri ê pâ wâao ma tâa, na wâna ê gòropuu. ");
INSERT INTO priNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","«Ba nye mara kàwà béaa, na é panuâ me pwi ênawéna kêe wà Pwiduée. Ba nümee na é naa tàwà ê *aupwényunyuâari, ma dàbiiwà jècaa gée na ê pâ èpà kàwà.» ");
INSERT INTO priNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Na ru gére patùra ê pâ âboro bèepwiri wà Pétéru ma Ioane, â rà nye tèepaa me kaa wà pàra tèpa pwa *ârapwaailò, ma wà pwi caa kà tèpa wéaari *Wâra pwapwicîri, ma pàra tèpa *Sadukaio. ");
INSERT INTO priNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Â rà po dau putàmu, ba ru gére pacâmuri ê pâ âboro pâ, é wâro côwâ wà Iésu. Ba càra caa cèikî naa goo ê pai wâro côwâ. ");
INSERT INTO priNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Â rà nye tâjùruru kaa, â rà tòpòru naa na karapuu, tiagoro dàuru, ba jèe bàrane. ");
INSERT INTO priNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Êco na dau wâru gée goo tèpa têre ê popai na rà cèikî, â ê jéû tèpa cèikî, âna é pitoo wâmwünyabweri 5 000 âboro. ");
INSERT INTO priNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Na dàuru kêe, âna wà tèpa *wâratûâ kà tèpa *Juif—wà tèpa ukai, ma tèpa ijiao, ma tèpa *dotée goro ê *Naèà—âna rà pitapitirirà na *Iérusaléma, ");
INSERT INTO priNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","wàilà ma Hanne, pwi *ukai kà tèpa pwa ârapwaailò, ma diri tèpa âboro naa ê tâa kêe—wà Caïphe, Jean, ma Alexandre, ma pàra tàpé mwara. ");
INSERT INTO priNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Â rà tòpò Pétéru ma Ioane naa nabibiu kàra, â rà tawèeriru pâ: «Gée goro pàtàma î, ma naa na nee î, na gàu pwa ma é wâdé côwâ wà pwi ia maagé?» ");
INSERT INTO priNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Â wà Pétéru, âna nye dipitirié kaa ê Nyuâaê Pwicîri, â é ina tàra pâ: «Tèpa ukai ma tèpa ijiao kâra Ba *Isaraéla, ");
INSERT INTO priNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","bu pwa na wâdé tà pwi âboro na é pitàbwamwa, â nabàni, âna guwà gére tawèeribu goro ê majoro ê pai tiàu wàra ê maagé kêe. ");
INSERT INTO priNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","«Wâdé na guwà cau tâmogòori, wâguwà ê Ba Isaraéla, pâ: Wà pwi âboro bèeni na é jèe wâdé, âna é gére coo arawà gée goro ê nee Iésu Kériso gée Nazareth, i pwi na ia guwà tanamiriê naa goro *kurucé, êco na é mwa pawâroé côwâ wà Pwiduée. ");
INSERT INTO priNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","É ina naa na Tii Pwicîri pâ: I pwi atü na rà tétâjii wà tèpa ba wâ, âna nye wàé kaa pwiri i âji êkêe! Tàutàra goo pwi ò kâra wâao! Psaume 118.22 «Wà pwi atü bèepwiri, âna wà Iésu. Â wâguwà tèpa ba wâ na tétâjiié. ");
INSERT INTO priNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Êco na nye ticè cè pwi neere âboro wâni gòropuu, ma wânidò *napwéretòotù, cèna naa tâjè tèpa âboro, ba na jè udò goo. Nye gée goo Iésu co, na naa tâjè ê *âji wâro.» ");
INSERT INTO priNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Ûna rà côo wà tèpa wâratûâ ê pai cimwü kà Pétéru ma Ioane, â rà dau pò, ba rà tâmogòori pâ wàilu, âna tupédu âboro gée na ê Ba, â càru caa dau câmu. Â rà côoinari pâ mu tupédu bée wà Iésu. ");
INSERT INTO priNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Êco na, ûna rà côo naa jaaru i pwi âboro na ia é jèe wâdé, â jèe ticè pai tùra kàra. ");
INSERT INTO priNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Â rà nye ina tàru kaa pâ, na ru còobé jii ê wâra pitùra, ba na rà bwaa pitùra. ");
INSERT INTO priNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Â rà pi-ina tàra pâ: «Dà cèna jè pwa tà tupédu âboro bèeni? Ba jèe po dau tàpàpaa na ara tèpa âboro wâ Iérusaléma ê pàtàmara i pwi ia ru pwa. Â nye ticè pai pwa wèe ma jè ina pâ pwâ. ");
INSERT INTO priNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Êco na càcaa wâdé na é dau ipâra pâ i jèkutâ gooru. Wâdé na jè papwicîri jiiru na ru pwa jèkutâ côwâ goo wà Iésu Kériso.» ");
INSERT INTO priNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Â rà todàru côwâ, â rà ina ba gòo tàru pâ, na ru cibwaa mwa caa tùra goo ê nee Iésu, ma pacâmuri tèpa âboro gooé. ");
INSERT INTO priNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Êco na ru tòpi tàra pâ: «Guwà jèe pwadàra pitèi cai na ara Pwiduée pâ, pwiri *tàrù na bu pitêre dàwà, é, na bu pitêre dèe? ");
INSERT INTO priNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Ba wàibu, âna càcaa pâri ma câbu caa ina ê muru na bu côo, ma ê muru na bu têre.» ");
INSERT INTO priNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Â rà jèu pwaru côwâ, êco na rà panuâru, ba càra caa tâmogòori cè pai pwa ma ru pwa wârimuru, wàrapwiri goo ê Ba, ba rà capai pwamaina Pwiduée goo ê pwina tèepaa. ");
INSERT INTO priNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Ba wà pwi âboro bèepwiri ia é wâdé, âna é jèe wâdò côwâ kâra 40 naja. ");
INSERT INTO priNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Panuâ Pétéru ma Ioane, â ru nama pâra dari tèpa béeru, â ru piwiâ tàra diri ê pâ pwina rà ina tàru wà tèpa caa kà tèpa pwa ârapwaailò ma wà tèpa ijiao. ");
INSERT INTO priNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Â wà tèpa cèikî, âna rà capai pwamaina Pwiduée naa na ê caapwi pwâranüma. Â rà ina pâ: «Pwi Ukai, wâgà na tòpò ê napwéretòotù ma gòropuu, ma nawià, ma diri ê pâ pwina wâna. ");
INSERT INTO priNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Wâgà na cùru me ê Nyuâaê Pwicîri, ma é tùra goo pwi caa kâbà, pwi ênawéna'gà *Davita pâ: Cina rà putàmu pâ Ba? Gorodà na rà bu tûâ na piticèmuru naa goo? ");
INSERT INTO priNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Rà paa dà Pwiduée tèpa ukai maina; rà caajurirà tèpa ukai kîri— cicara Pwi Ukai ma pwi *Mesiakêe. Psaume 2.1–2 ");
INSERT INTO priNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","«Âjupâra, ba wà ukai *Héroda Antipas ma wà kupénoo Ponce *Pilato, âna rà picinaima ma tèpa âboro, ma ê pâ wâao Isaraéla, na napô bèeni. Â rà cicara pwi ênawéna, wà Iésu, na gà pitòrigarié, ba na é pwi Mesia. ");
INSERT INTO priNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Êco na, na wàrapwiri, â rà pacoo diri ê pwina gà jèe tòpò béaa, wiâra ê câbawâdé'gà ma pàtàmagà. ");
INSERT INTO priNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","«Â êni co Pwi Ukai, âna gà côo ê pai pwa kûu kàra, â bà ilari jiigà pâ, na gà nama bà gòo, wàibà tèpa ênawéna'gà, ba na o câbà caa piwâ na bà ina ê popai'gà. ");
INSERT INTO priNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Wâdé na gà naame ê pàtàmagà, ba na rà wâdé tèpa maagé. Â gà pwa cè pâ *câmu kêe na rà o pò goo wà tèpa âboro; naa na nee Iésu, pwi ênawéna na gà pitòrigarié.» ");
INSERT INTO priNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Na rà pwapwicîri diri, â nye céca kaa ê ére na rà tâa wê. Â ê Nyuâaê Pwicîri, âna é nye tûu kaa naa gòrà, â jèe càra caa piwâ na rà picémara ê popai kà Pwiduée. ");
INSERT INTO priNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Nye êdiri kaa tèpa cèikî na caapwi pwâranümarà ma caapwi auniimiri kàra. Nye ticè pwi jè ârapàararà na é ina pâ, napwa ê pâ wâdé kêe, âna nye kêe acari; â capai kàra diri. ");
INSERT INTO priNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Rà picémara ba gòo wà tèpa *apostolo ma *paâjupâra ê pai wâro côwâ kà Ukai Iésu. Â é panuâ boo naa gòrà diri ê *aupwényunyuâari kêe wà Pwiduée. ");
INSERT INTO priNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Nye ticè pwi jèpwi gée nabibiu kàra, na pwa cè pwina tiàu jiié. Ba wà diri tàpé na pwa na aupwanapô kàra, â pwa wâ kàra, âna rà icuri. Â rà pame mwani goo, ");
INSERT INTO priNT_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","â rà naa tà tèpa apostolo, â rà mwa jèpa pâdi tàra, wiâra pwina tiàu jiirà. ");
INSERT INTO priNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Pwacèwii naa goo wà Ioséfa pwi Lévite na pitèpaé naa gòropô Chypre. Wà pwi âboro-bà, âna rà pitunee têe wà tèpa apostolo pâ, Barnabas, na pai ina wèe pâ ‘Pwi a pagòojè’. ");
INSERT INTO priNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Wà pwiibà, âna é icuri na aupwanapô kêe, â é pame ê mwani goo, â é naa tà tèpa apostolo. ");
INSERT INTO priNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Pwa du duadà na ru icuri ê napuu kàru—wà pwi paao âna nee Ananias, â wà wâdèe âna nee Saphira. ");
INSERT INTO priNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Â ru niimiri pâ, na ru naa ê mwani tà tèpa *apostolo. Êco na ru pitêreru pâ, na ru cégòtù ê jè jènere mwani gée goo, â càru caa tà inapàpari tàra. ");
INSERT INTO priNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Â é ina têe wà Pétéru pâ: «Ananias, cina gà pitêre dà wà *Caatana ma gà pwâgàri ê Nyuâaê Pwicîri? Cina gà cipa ê jè ére gée goo ê wâri wàra i napuu? ");
INSERT INTO priNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Béaa kâra ê pai icuri'gà i napuu, âna, nye kâgà! Â gée na càùru ê pai icuri'gà, âna bwaa nye kâgà mwara ê mwani goo! Cina gà wàrapwiri ê pai niimiri'gà? Ba càcaa wà tèpa âboro na gà pwâgàrirà, â gà pwâgàri wà Pwiduée.» ");
INSERT INTO priNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Ûna é têre pâ na popai bèepwiri wà Ananias, â êgò ê ôomaa kêe, â é tûuboo. Â nye dau maina kaa ê pai wâgo tà tèpa têre wàra ê pwi jèkutâ-bà. ");
INSERT INTO priNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Â rà me wà tèpa âboro èpo â rà târamiriê, â rà pwa ma popaé còobé nau pwàniriê. ");
INSERT INTO priNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Wâpâ na âracié ineretòotù gée na càùé, â é tèepaa me wà wâdà Ananias, â na nye ticè na é tâmogòori gée goo i pwi ia tàgére tèepaa. ");
INSERT INTO priNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Â é tawèerié wà Pétéru pâ: «Nye êkaa ni wâri wèe i napuu na gàu icuri?» Â é tòpi têe pâ: «Üu, nye êkaa.» ");
INSERT INTO priNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Â é ina têe wà Pétéru pâ: «Gàu wànau târa ê pai pitêreu, ma gàu bumuru goo ê Nyuâaê Pwicîri kà Pwi Ukai? Gà côo, wà tàpé na rà me gée aupwàniri pwi éagà, âna wàilà-ni goropwârawâ, â rà o popagà mwara.» ");
INSERT INTO priNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Â nye êgò kaa ê ôomaa kêe, â é nye tûuboo kaa naa goro â Pétéru. Rà toome i tèpa âboro èpo, â rà pâmariê na é jèe bà. Â rà popaé pâ nau pwàniriê naa jaa wà pwi éaé. ");
INSERT INTO priNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Nye dau maina kaa ê pai wâgo tà tèpa cèikî, ma wà diri pàra tàpé na rà têre ê jèkutâ bèepwiri. ");
INSERT INTO priNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Wâru ê pâ *câmu kâra pàtàma Pwiduée na rà pwa wà tèpa apostolo naa nabibiu kà tèpa âboro. Â rà pò goo ê pwina rà côo. Napwa naa goo wà tèpa cèikî, âna rà pitànaima na wâ cikòmaa ‘Wâ kà Solomona’. ");
INSERT INTO priNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Nye ticè gée jaa tàpé na càra caa cèikî, na nümee na é pâdarirà. Êco na rà dau pwamainarà wà pàra tèpa âboro. ");
INSERT INTO priNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Â é nye tà pitoo pâ ê jéû tèpa paao ma ilàri na rà cèikî naa goo Pwi Ukai, â rà pâdari wà tàpé na rà jèe cèikî. ");
INSERT INTO priNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Wà tèpa âboro na Iérusaléma âna rà popa me tèpa maagé naa gòro naigé, â tòpòrà naa gòro aupuu tâdòiti ma aupuu pipîri, ba wiàna é me wà Pétéru, â, na o tii goo cè pàararà ê ânuuê. ");
INSERT INTO priNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Dau wâru mwara ê pâ âboro na rà me gée pàra village, naa *Iérusaléma. Â rà popa me tàpé na rà maagé, ma pwa duée goorà. Â rà po capai wâdé diri. ");
INSERT INTO priNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Na gére wàrapwiri, â wà pwi *ukai kà tèpa pwa ârapwaailò ma wà tèpa bée (ê gére pâra kà tèpa *Sadukaio), âna rà nye dau piboo goo tèpa apostolo, â rà cau cimadò. ");
INSERT INTO priNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Â rà nye tâjùrurà kaa, â rà türà dò naa na karapuu na ara diri ê pâ âboro. ");
INSERT INTO priNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Êco na, na ne, âna wà pwi *angela kà Pwi Ukai, âna é tàpiri diri ê pâ goropwârawâ kâra i na karapuu, â é pacòobérà. Â é ina tàra pâ: ");
INSERT INTO priNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","«Guwà pâra nau tâa na *Wâra pwapwicîri, â guwà picémara êdiri pâ na popai goo ê pwi *âji wâro bèeni.» ");
INSERT INTO priNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","22","Â rà pò ma too naa na Wâra pwapwicîri na bwaa po dàuru, â rà pacâmuri tèpa âboro. Na gére wàrapwiri, â wà pwi ukai kà tèpa pwa ârapwaailò ma tèpa bée, âna rà todà diri tèpa *wâratûâ, wà tèpa ijiao kâra Ba *Isaraéla, ba na rà ipitiri. Â rà panuâ pâ tèpa wéaa, ba na rà popa me tèpa apostolo, gée na karapuu. Êco na, na rà tèepaa pâ naa na karapuu, â càra caa pâmarirà. Â rà wâjué côwâ, â rà ina târa wâratûâ pâ: ");
INSERT INTO priNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","«Bà pâmari i na karapuu, âna nye po târi bwàti ê pâ goropwârawâ goo, â wà tèpa wéaari wèe, âna rà nye jèpa coo na ê auwéaa kàra. Êco na, na bà tàpiri pâ goropwârawâ, âna jèe ticè âboro na!» ");
INSERT INTO priNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Ûna rà têre pwiri wà pwi caa kà tèpa wéaari Wâra pwapwicîri ma wà tèpa caa kà tèpa pwa *ârapwaailò, â càra caa tâmogòori cèna rà niimiri naa goo ê pai tiàu tèpa apostolo, ma cè pwi cèna o tèepaa. ");
INSERT INTO priNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Na bwaa gére wàrapwiri, â é tèepaa me pwi jè âboro na ina tàra pâ: «Tàpéeni! Wà i tèpa âboro na ia guwà tòpòrà naa na karapuu, âna rà wâna Wâra pwapwicîri ni, â rà gére pacâmuri ê pâ âboro!» ");
INSERT INTO priNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Â rà nye pâra kaa naa na Wâra pwapwicîri wà tèpa wéaa ma wà pwi caa kàra, ba na rà tâjùru tèpa apostolo. Êco na rà nye poparà me bwàti, ba wâgotàra goo i Ba, ba é péa tà èirà goro atü. ");
INSERT INTO priNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Rà popa me tèpa apostolo, â rà poparà pâdari ê wâratûâ maina. Â é tawèerirà wà pwi ukai kà tèpa pwa ârapwaailò pâ: ");
INSERT INTO priNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","«Tàpéeni! Gona ia câbà caa dau papwicîri jiiwà na guwà pacâmuri naa na pwi neere âboro bèepwiri? Â côo, nabàni, âna guwà nama pâra pitiri Iérusaléma ê câmu kàwà! Â guwà inapàpari pâ nye wàibà kaa na bà tèpa majoro ê pai bà kêe.» ");
INSERT INTO priNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","É tòpi tàra wà Pétéru, na wàilà ma wà tèpa apostolo bée, pâ: «Bà pitêre dà wà Pwiduée, â càcaa tèpa âboro! ");
INSERT INTO priNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Wâguwà kaa na tétàmwara wà Iésu, ba guwà nama é utòtòro goro *kurucé. Êco na é pawâroé côwâ wà Pwiduée kà tèpa caa kâjè. ");
INSERT INTO priNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Â é naatoo Iésu naa gòro âji îê ba na é pitûâ kâra diri pâ muru. Â é tòpòé ma é Pwi Ukai, ma é *pwi a pa-udò. É wàrapwiri, ba na é tâmogòori ê Ba Isaraéla pâ, pâri ma é pinünüma ma o pwanauri ê èpà kêe. ");
INSERT INTO priNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Â wàibà kaa tèpa *paâjupâra wàra diri ê pâ namuru bèepwiri, wàibà ma ê Nyuâaê Pwicîri, na é naa wà Pwiduée tà tàpé na rà pitêre dèe.» ");
INSERT INTO priNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Ûna rà têre pwiri wà tèpa wâratûâ, â rà dau putàmu, â rà pwa na rà tétàmwara wà tèpa apostolo. ");
INSERT INTO priNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Êco na é cimadò gée nabibiu kàra ê pwi *Farasaio na nee Gamaliel (na é pwi jè *dotée goro ê Naèà mwara), na rà dau picâdirié diri ê Ba. Â é ilari pâ, na rà tàpo pacòobé tèpa apostolo. ");
INSERT INTO priNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Â é ina tà tèpa wâratûâ bée pâ: «Ico tèpa béeò Isaraéla, guwà ipwacôowà bwàti goo cè pwina guwà niimiri pâ na guwà pwa tà tèpa âboro bèepwiri. ");
INSERT INTO priNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Càcaa pâ gòiri ê pàara na é tèepaa na wà Theudas, pwi âboro na é nye niimiri pâ dau pwamuru naa gooé. Â wâpâ goro 400 âboro na rà pâra wiâê. Êco na, ûna caamwereê, â rà jèe ipiina diri, â jèe ticè airà. ");
INSERT INTO priNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Gée na càùé, na pàara na pûra jéûru âboro na, â é cimadò wà Judas, wà pwi âboro me gée Galilée. Â wâru tèpa âboro na rà pâra wiâê. Êco na, na é bà, wàé mwara, â wà tèpa âboro bèepwiri, âna rà jèpa ipiina mwara. ");
INSERT INTO priNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Â nabàni, âna go ina tàwà pâ, na guwà cibwaa kairi tàpé bèepwiri. Bwa, guwà nama rà pâra, ba wiàna ê pwina rà pwa, âna me co gée jaa tèpa âboro, â o tiàu. ");
INSERT INTO priNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Êco na, naa muru me gée jaa wà Pwiduée, â o càcaa pâri ma guwà pacoo. Guwà cibwaa ipwaji ma guwà cicara Pwiduée!» Â wà tèpa pitûâ, âna rà pâra naa goo ê pai ina kà wà Gamaliel. ");
INSERT INTO priNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Â rà todà côwâ tèpa apostolo, â rà nama pâdirà. Â rà panuârà, â rà tûâri tàra pâ, na rà cibwaa mwa caa tùra na nee Iésu. ");
INSERT INTO priNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Wà tèpa apostolo, âna rà còobé jii ê wâratûâ, â rà dau ipwàdée, ba wà Pwiduée, âna é tèi pâ, pâri ma pâdirà goo ê nee Iésu. ");
INSERT INTO priNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Â êdiri na tòotù, naa na Wâra pwapwicîri, ma ê pâ pwârawâ, âna rà nye taaci pacâmuri tèpa âboro. Â rà picémara ê *Picémara Wâdé goo Iésu, pwi *Mesia, pwi a pa-udòjè. ");
INSERT INTO priNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Na pwi pàara-bà, âna jèe pitoo ê jéû tèpa cèikî. Â wà tàpé na rà pwa grec, âna rà pikûuri wà tèpa âboro *Juif na rà pwa *hébéru. Ba wà pa dàpwà kàra, âna po dau càcaa wâdé pai pwa tàra, naa na ipâdimuru na rà pwa na diri ê pâ tòotù. ");
INSERT INTO priNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Wà tèpa 12 *apostolo, âna rà todà diri tèpa cèikî, â rà ina tàra pâ: «Càcaa wâdé na bà coo jii ê picémara popai kà Pwiduée, ma bà pâdi ê utimuru. ");
INSERT INTO priNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Êni co tèpa cèikî béeò, âna guwà pitòrigari cè tèpa 7 âboro gée jaawà, tèpa âboro na guwà côo pâ, nye wâdé kaa ê càrarà ma tûâ kàra, na dipitirirà ê Nyuâaê Pwicîri ma autâmogòorimuru kà Pwiduée. Â bà o nama wakè kàra pwiri. ");
INSERT INTO priNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Ba wàibà, âna bà o jèe nye po tâa co kaa naa goo ê pwapwicîri, ma picémara ê popai.» ");
INSERT INTO priNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Â wâdé târa diri tèpa cèikî, â rà pitòrigari tèpa âboro bèeni: Étienne (na dau maina ê cèikî kêe, â dau tâa gòé ê Nyuâaê Pwicîri); Filipo; Procore; Nicanor; Timon; Parménas; Nicolas gée na ville Antioche. (Ia é biié naa goro pwapwicîri kà tèpa Juif.) ");
INSERT INTO priNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Â rà poparà medari tèpa apostolo, â rà pwapwicîri kàra wà tèpa apostolo ma tòpò îrà naa gòrà. ");
INSERT INTO priNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Â napwa ê popai kà Pwiduée, âna nye pâra ba maina kaa, â é jèe dau pitoo ê jéû tèpa cèikî na *Iérusaléma. Â wâru tèpa pwa *ârapwaailò na rà cèikî. ");
INSERT INTO priNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Wà Étienne, âna pwi âboro na dau maina naa gòé ê *aupwényunyuâari kà Pwiduée. Â é pwa ê pâ *câmu kâra pàtàma Pwiduée naa nabibiu kâra pâ âboro—muru na maina, na rà pò goo. ");
INSERT INTO priNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Êco na pwa pàra tèpa âboro na rà cicaraé—pàra tèpa Juif gée na du ville Cyrène ma Alexandrie na rà me gée na *wâra pitapitiri kà tèpa *ênawéna kîri na jèe tipirà côwâ. Â pwa mwara tèpa Juif gée na du province Cilicie ma Asia na rà cicara Étienne. Â rà pitùra ma wàé ma pwaé. ");
INSERT INTO priNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Êco na ticè na rà wà têe, ba é tùra na autâmogòorimuru na é naa têe ê Nyuâaê Pwicîri. ");
INSERT INTO priNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Wà tàpéebà, âna rà wâri tèpa âboro, ba na rà piciapwâ gooé ma ina pâ: «Bà têre na é ina pâ popai na èpà naa goo wà *Moosé ma wà Pwiduée.» ");
INSERT INTO priNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Â rà tubagùra nüma tèpa âboro ma wà tèpa pitûâ kàra. Â rà êgò gée paé, â rà tâjùru wà Étienne, â rà popaé pâ naa na *wâratûâ maina. ");
INSERT INTO priNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Rà tòpò mwara tèpa âboro na rà pwâ, na rà ina pâ: «Wà pwi âboro bèeni, âna câé caa nao goro dàbaèpà ê *Wâra pwapwicîri ma ê *Naèà. ");
INSERT INTO priNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Â bà têre na é gére ina pâ, wà Iésu, ê pé pwi Nazareth bèepwiri, âna ée mwa ténoori ê Wâra pwapwicîri bèeni, â ée mwa tòotéri ê pâ nyamanya na é naa tâjè wà Moosé!» ");
INSERT INTO priNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Wà diri tèpa wâratûâ, âna rà niâri pâ wà Étienne. Ba pé pwâra ê naporomee, pwacèwii naporomara *angela. ");
INSERT INTO priNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","É tawèeri wà Étienne wà pwi *ukai kà tèpa pwa ârapwaailò pâ: «Nye âjupâra kaa ê pwina rà gére ina naa googà?» ");
INSERT INTO priNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Â é tòpi têe pâ: «Tèpa jènereô ma tèpa caa, guwà têre, wà Pwiduée na é maina ma muugère, âna é pièpàparié tà pwi caa kâjè *Abéraama, na é bwaa tâa napô Mésopotamie, béaa kâra ê pai pâra kêe nau tâa na ville Haran. ");
INSERT INTO priNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","«Â é ina têe wà Pwiduée pâ: Gà pâra jii ê tâa'gà ma ê napô'gà, â gà pâra naa na ê pwi napô na go mwa tòcia tâgà. ");
INSERT INTO priNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","«Â é còobé wà Abéraama gée napô kà tèpa Kaldé, â é tâa Haran. Gée na càùé, â é bà wà caa kêe. Â wà Pwiduée, âna é popaé me, naa na ê pwi napô bèeni, na jè gére tâa na nabà. ");
INSERT INTO priNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","«É tàmara ina têe wà Pwiduée pâ: Go o mwa naa tâgà, ma wà tèpa gòobàragà, ê pwi napô bèeni. Na pwi pàara bèepwiri, âna é bwaa càcaa pâ pipièrù wà Abéraama! Â ticè caapwi ére na pwacèwii auduu goro pwùruîjè, na é naa tà Abéraama wà Pwiduée. ");
INSERT INTO priNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","«Â é ina têe mwara wà Pwiduée pâ: Wà tèpa gòobàragà, âna rà o mwa pwa pârame naa na pwi jè napô, â rà o mwa piâboro kîri, â o mwa tubaèpà tàra naa na 400 naja. ");
INSERT INTO priNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Êco na go o mwa pwa wârimuru târa ê pwi Ba, na é pwa ma rà tèpa piâboro kîri kêe. Â gée na càùé, â rà mwa còobé wà tèpa gòobàragà, â rà o mwa pwamainaô, naa na pwi ére bèeni.» ");
INSERT INTO priNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","«Gée na càùé, â wà Pwiduée, âna é pacoo ê *ipwataâboro kàru ma Abéraama. Â é nama câmu kêe—ê pwa *kamaî. Â wà Abéraama, âna é pwa kamaî tà pwi naîê Isaaka, na caapwi nadàpàra pwapwicîri kêe. Â wà Isaaka, âna é pwa kamaî tà pwi naîê Iakobo, â wà Iakobo, âna é pwa tà tèpa 12 naîê, wà tàpé na rà mwa pâra nau tèpa jojooro 12 wâao *Isaraéla.» ");
INSERT INTO priNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","«Wà tèpa aéjii-bà, âna rà piboo goo wà Ioséfa, pwi jè aéjii kàra. Â rà icurié, â é pâra nau piâboro kîri wâ napô *Aigupito. Êco na é nye tà wâjaaé wà Pwiduée, ");
INSERT INTO priNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","â é nye popaé jii ê pâ aré ma tòina. Â é naa têe ê autâmogòorimuru, â é nama é wâdéari wà Ioséfa wà Faraô, pwi ukai naa Aigupito. Wà Faraô, âna é pwa ma é pwi a pitûâ naa napô Aigupito, tèepaa naa goro ê pwârawâ kêe. ");
INSERT INTO priNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","«Tèepaa me ê copwa na maina, naa na diri ê napô Aigupito ma *Kanana. Â dau pwaée kà tèpa âboro. Â wà tèpa caa kâjè, âna jèe ticè uti kàra. ");
INSERT INTO priNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Ûna é tâmogòori pâ, pwa utimuru wâ Aigupito wà Iakobo, â é tapoo panuâ boo tèpa naîê wà tèpa caa kâjè. ");
INSERT INTO priNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","«Naa na béwailu boo kàra, â wà Ioséfa, âna é nama rà côoinaê wà tèpa cièe. Géewê, â wà Faraô, âna é mwa bàra tâmogòori ê tâa kà Ioséfa. ");
INSERT INTO priNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Â wà Ioséfa, âna é nama popa me wà caa kêe Iakobo, ma diri ê tâa kêe, na rà po 75 diri. ");
INSERT INTO priNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Â é boo naa Aigupito wà Iakobo, â é mwa bà naawê, wàilà ma tèpa caa kâjè. ");
INSERT INTO priNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Â nye popa dò côwâ ê napwùrudòrà naa na ville Sikem. Â tòpòrà naa na nacârü na é wâri goro mwani wà Abéraama târa ê wâao kà Hamor. ");
INSERT INTO priNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","«Â jèe pâmwünyabweri pwi pàara na o jèe coo i auinabéaa na é ina wà Pwiduée tà Abéraama. Ba wà tèpa Isaraéla, âna rà pimaina ma ipwénaî na Aigupito. ");
INSERT INTO priNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Êco na é pâra nau cimadò ê pwi jè ukai naa Aigupito, na é câbapiticèmuru naa goo ê wakè kà Ioséfa. ");
INSERT INTO priNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Wà pwi ukai-bà, âna é ipwa tûâ târa i Ba kâjè, â é pwa ma tubaèpà tàra. Â é tacoo goorà ma rà pâra jii ê tèpa nari èpo kàra, ma panuârà, ba na rà bà.» ");
INSERT INTO priNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","«Na pwi pàara-bà, âna pitèpa wà *Moosé, pwi nari èpo na dau wâdé pai côoê, â wâdé tà Pwiduée wàé. Â ipièrù gooé naa na âracié parui naa jaa du nyaa ma caa kêe. ");
INSERT INTO priNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Â ûna ru panuâê wiâra ê autûâri â é pâmariê wà tô na naî wà ukai Faraô. Â é popaé ma pwi naîê. ");
INSERT INTO priNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Â rà pacâmuriê naa na diri ê tàmanga kà tèpa Aigupito, â pwi a tùra bwàti, ma pwi a wakè bwàti. ");
INSERT INTO priNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","«Ûna 40 naja kêe, â me naa na pwâranümee pâ, na é cai wà tèpa aéjii kêe, ê Ba Isaraéla. ");
INSERT INTO priNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Â é pâmari pwi jè Aigupito na é gére èi pwi jè âboro Isaraéla. Â é pwamuruê jii pwi a èié, â é tétàmwara wà pwi Aigupito. ");
INSERT INTO priNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","É tà niimiri pâ wà tèpa aéjii kêe, âna rà o tâmogòori pâ, wà kaa Pwiduée na é cùrué pâ, ba na pwi a pa-udòrà, êco na càra caa tâmogòori. ");
INSERT INTO priNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","«Â, na pwi tòotù gée paé côwâ, âna é côo wà tupédu âboro Isaraéla na ru gére piokée. Â é picoo nadàpàru, â é ina tàru pâ: “Du âboro èpo, gàu tàgére tupédu aéjii, cina gàu pipwa tàu na èpà?” ");
INSERT INTO priNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Êco na wà pwi âboro na é pwa na èpà tà pwi bée âna é cètùu wà Moosé. Â é ina têe pâ: Wàilàapà na pacimagà ma gà pwi ukai ma gà pwi a pitèimuru? ");
INSERT INTO priNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Wànau? Pwa na gà tétàmwaraô pwacèwii pai tétàmwaragà, géecaa, wà pwi Aigupito? ");
INSERT INTO priNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Ûna é têre pwiri wà Moosé, â é nye uru kaa. Â é pâra na pwa pârame naa na napô Madian. Â pitèpa naawê wà tupédu naîê. ");
INSERT INTO priNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","«Gée na càùru 40 naja, â é tâa wà Moosé naa namaré, wâmwünyabweri gòrojaa Sinaï. Â é côo ê nari upwâra na tòo. Â wà pwi jè *angela, âna é nye cipàparié kaa na doromara ânye. ");
INSERT INTO priNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","É nye dau pò kaa wà Moosé, â é me mwünyabweri, ba na é côo bwàti. Â é têre ê pwâratùra kà Pwi Ukai, na é ina têe pâ: ");
INSERT INTO priNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","Wâgo Pwiduée kà tèpa caa'gà, wà Pwiduée kà *Abéraama, ma Isaaka, ma Iakobo. Â é nye pwùkùru kaa wà Moosé goo ê pai wâgotêe, â pwacoé têe ma é niâri. ");
INSERT INTO priNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","«Â é ina têe wà Pwi Ukai pâ: Gà tòpwùtù du wâraâgà, ba napwa ê pwi ére bèepwiri na gà gére coo wê, âna ére na pwicîri. ");
INSERT INTO priNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Go jèe côo i aré ma tòina kâra i Ba kôo Isaraéla, na Aigupito, â go têre ê pwâra càwé kêe. Â go boome, ba na go pacòobée. Êni, âna gà pâra, ba go o mwa nama gà pâ naa Aigupito. ");
INSERT INTO priNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","«É naa tà Moosé ê tàrù bèepwiri wà Pwiduée êco na càra caa côoinaê wà tèpa jènereê, â rà ina pâ: Wàilàapà na pacimagà ma gà pwi ukai ma gà pwi a pitèimuru? Wàé kaa na é panuâê wà Pwiduée ma pwi a pitûâ, ma pwi a pipoparà. Ba wàé na ia é pitòrigarié wà pwi angela kà Pwiduée na é cipàparié naa na i na nari upwâra. ");
INSERT INTO priNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","«Â wà Moosé na é nama còobé ê Ba kêe gée Aigupito. Naa na 40 naja, âna é pwa ê pâ *câmu kâra pàtàma Pwiduée naa napô Aigupito, naa nawià Mii, ma naa namaré. Â rà pò goo wà tèpa âboro. ");
INSERT INTO priNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Wà kaa pwi Moosé bèepwiri na é ina târa ê Ba Isaraéla pâ: Wà Pwiduée, âna ée mwa pacimadò gée nabibiu kàwà cè pwi *péroféta na é pwacèwiio. ");
INSERT INTO priNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Nye wà mwara wà Moosé na é tâa jaa tèpa caa kâjè, na rà caatâa namaré. Â nye wàé mwara na ia é patùraé i pwi angela, naa gòrojaa Sinaï, â na ia é naa têe ê pâ popai târa wâro, ba na ée mwa naa tâjè.» ");
INSERT INTO priNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","«Êco napwa wà tèpa caa kâjè, âna tàutàra na rà pitêre dèe, â tàutàra gooé, â nümarà dàra wâjué côwâ naa Aigupito. ");
INSERT INTO priNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Â rà ina tà wà *Arona pwi cièe pâ: Gà pwa cè pâ ânuuru duée kâjè cèna rà pâbéaa kâjè. Ba pé pwi Moosé bèepwiri, wà pwi a pacòobéjè gée napô Aigupito, âna câjè caa tâmogòori cèna gére tèepaa mariê. ");
INSERT INTO priNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Na tòotù-bà, âna rà pwa ê pé nari paaci, ba na pé ânuuru duée kàra, â rà pwa ma pwa *ârapwaailò têe. Â rà dau ipwàdée kaa goo pwina rà pwa. ");
INSERT INTO priNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Napwa naa goo Pwiduée, âna é panuârà ma rà pwapwicîri târa ê tòotù ma parui ma ê pâ îricò. Ba jèe wii naa na ê tii kà tèpa péroféta, pâ: Tòpi tôo co, Isaraéla! Guwà pwapwicîri tâî na guwà tâa namaré? Guwà pwa ârapwaailò tâî naa na 40 naja? ");
INSERT INTO priNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Nye càcaa wâgo! Guwà popa wâ imwaano kâra duée Molok! Guwà popa ê îricò kâra duée Réphan! Guwà ipwamainaru goro *ânuurumuru na ia guwà pwa goro îwà. Êkaa na guwà têre: Go nama guwà còobé awé jii napô kàwà. Guwà o pwa karapuu naa napô *Babulona.» Amos 5.25–27 ");
INSERT INTO priNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","«Wà tèpa caa kâjè, âna rà pwa ê wâra pwapwicîri goro imwaano, ba na é wâjaarà wà Pwiduée. Rà pagòtù i wâ-bà wiâra ê pai câmuri kà Pwiduée, na ia é paari tà Moosé. ");
INSERT INTO priNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Gée na càùrà, â wà tèpa naîrà, âna rà tòpi ê pwi wâra pwapwicîri-bà. Â rà popa wiârà na rà pâra wiâ wà Iosua. Â rà pa goro paa ê napô Kanana â rà tâaboo naawê. Ba wà Pwiduée, âna é pwâri tèpa Ba na rà tâa wê béaa kàra. Â i wâra pwapwicîri-bà, âna é tâa wê tiagoro ê pàara kà ukai *Davita. ");
INSERT INTO priNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Â napwa wà Davita, âna wâdé tà Pwiduée wàé. Â é ilari jiié pâ, na é pacima cè Wâra pwapwicîri kâra ê Ba Isaraéla. ");
INSERT INTO priNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Â wà *Solomona na é mwa bari ê wâ kà Pwiduée. ");
INSERT INTO priNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","«Êco na wà Pwiduée na é tâjaijè, âna câé caa tâa na ê wâ na pwa goro na-araraîri âboro. Ba wàéni ê pwina é ina, na é naigé mee wà pwi péroféta kêe: ");
INSERT INTO priNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Ê napwéretòotù, âna autâa kôo; Ê gòropuu diri, aucò kîri kôo. Wâpà cè wâ na guwà bari, na pâri ma go tâa na? Wâpà cè wâao cèna go tâa wê? ");
INSERT INTO priNT_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Ba nye wâgo kaa, na go tòpò diri, goo du na-araîô.» Ésaïe 66.1–2 ");
INSERT INTO priNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","É ina mwara wà Étienne tà tèpa pitûâ pâ: «Po dau gòo ê pâ pûruwà! Ba tàutàwà na guwà têre ê popai kà Pwiduée! Guwà nye ciburà cicara ê Nyuâaê Pwicîri, pwacèwii wà tèpa caa kàwà. ");
INSERT INTO priNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Ba rà tubaèpà ma pòtàmwara tèpa péroféta diri, wàilà na rà tàmara inapàpari ê pai tèepaa kà Pwina é *tàrù. «Wà pwiibà, âna é pitòrigarié wà Pwiduée êco na guwà icurié, â guwà tèpa pòtàmwereê. ");
INSERT INTO priNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Wâguwà tàpé na guwà tòpi ê Naèà kà Pwiduée na rà pinaigé mee tàwà ê pâ angela, â câguwà caa pâra wiâra.» ");
INSERT INTO priNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Na rà têre ê popai-bà wà tèpa pitûâ, â rà nye dau putàmu kaa, â rà pitòngüru poropwârà, naa goo wà Étienne. ");
INSERT INTO priNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Êco na é boo naa gòé ê Nyuâaê Pwicîri, â é niâ too naanidò *napwéretòotù wà Étienne, â é côo ê muugère kà Pwiduée, â é côo wà Iésu na é coo gòro étò kà Pwiduée. ");
INSERT INTO priNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Â é ina pâ: «Guwà têre! Go côo ê napwéretòotù na é tàpirié, â wà *Pwina naîri âboro na é coo gòro étò kà Pwiduée!» ");
INSERT INTO priNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Â rà nye uu too kaa wà tèpa pitûâ, burà cémoori ê pwâranyürurà, â rà nye itàa me kaa naa gòé. ");
INSERT INTO priNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Â rà bèerié boo naa gòroigé jii ê ville, â rà tòpwùtù ârabwée kàra, ma tòpò naa goro majoro â ê pwi âboro èpo, na nee Saulo. Â rà èi Étienne goro atü, ba na rà catàmwereê. ");
INSERT INTO priNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Â é pwapwicîri burà ina pâ: «Pwi Ukai Iésu, gà tòpi ê nyuâaô.» ");
INSERT INTO priNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Â é tùu jùrué, â é tomara too pâ: «Pwi Ukai, gà cibwaa pitôowâri tàra ê pwi èpà bèeni rà pwa tôo!» Â é bà. ");
INSERT INTO priNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Wà Saulo, âna é wâgoo ê pai tétàmwara wà Étienne. Nye na kaa pwi tòotù-bà, na nye maina pâ kaa ê pai tubaèpà tà tèpa cèikî wâ *Iérusaléma. Â rà jèpa ipiina pâ naa pâ ére gée goo *Judée ma Samaria. Â wàco tèpa *apostolo na rà nye tà tâa Iérusaléma. ");
INSERT INTO priNT_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Wà tèpa âboro na rà dau pitòimirirà naa goro ê pwapwicîri, âna rà pwàniri wà Étienne, â rà dau imuruê ba maina. ");
INSERT INTO priNT_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Êco napwa naa goo wà Saulo, âna é nye dau tubaèpà kaa tà tèpa cèikî, â é tédidirirà. Â é ipâra wii pâ pwârawâ kàra, â é pwa ma dàti còobé ê paao ma ilàri, â naarà dò naa na karapuu. ");
INSERT INTO priNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Wà tèpa cèikî na ia rà ipiina, âna rà jèpa pâra naa ê pâ napô, â rà picémara ê *Picémara Wâdé. ");
INSERT INTO priNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","É pâra wà Filipo naa na pwi ville gée goo Samaria, â é picémara tà tèpa âboro naawê pâ, wà Iésu, âna é pwi *Mesia, pwi a pa-udòjè. ");
INSERT INTO priNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Â rà nye po cau tàmaari bwàti ê pwina é ina tàra, na pâ tòotù ba rà têre ma côo ê pâ câmu na é pwa, goro ê pàtàma Pwiduée. ");
INSERT INTO priNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Ba ê pâ duée, âna rà uu too, na rà còobé gée goo tàpé na rà wâru. Â wâru mwara tèpa pitàbwamwa ma tàpé na rà bee na rà capai wâdé diri. ");
INSERT INTO priNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Â dau maina ê ipwàdée na ê pwi ville-bà. ");
INSERT INTO priNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","É nye mara tâa na ê pwi ville-bà ê pwi âboro na ina gooé pâ Simona. É pwi a pwa tutê, â é nama dau pwamuru naa gooé. Â wà tèpa âboro na napô Samaria, âna rà dau pò goo ê pwina é pwa. ");
INSERT INTO priNT_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Wàilà diri, tapoo gée goo tèpa nari èpo tiagoo tèpa ijiao, âna rà mu nye po tàmaariê bwàti, â rà nye cau ina diri kaa pâ: «Wà pwini, âna nye tâa gooé kaa ê pàtàma wà Pwiduée, na dau maina awé!» ");
INSERT INTO priNT_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Rà nye dau tàmaariê bwàti kaa, ba jèe dau gòiri ê pàara, na é pwa ma rà pò goro ê pai pwa tutê kêe. ");
INSERT INTO priNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Êco na, ûna é tèepaa me wà Filipo, â rà cau têreê, na é picémara tàra ê Picémara Wâdé goo wà Iésu Kériso, ma ê *Mwaciri kà Pwiduée. Â rà cèikî naa goo, â rà nama *upwaarà—wà tèpa paao ma pa ilàri mwara. ");
INSERT INTO priNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Napwa naa goo wà Simona, âna é cèikî mwara, â *upwaaé. Gée na càùé, â jèe câé caa pâra jii wà Filipo. Â é côo ê pâ *câmu na maina kâra pàtàma Pwiduée na gére coo, â po dàpàgà têe, wàé mwara. ");
INSERT INTO priNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Wà tèpa apostolo, na rà tâa Iérusaléma, âna rà têre pâ rà jèe tòpi ê popai kà Pwiduée wà tèpa âboro Samaria. Â rà panuâ pâ wà Pétéru ma Ioane. ");
INSERT INTO priNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Ûna ru tèepaa pâ naa jaarà, â ru pwapwicîri kàra, ma rà tòpi ê Nyuâaê Pwicîri. ");
INSERT INTO priNT_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Ba câé caa pâji boo naa gò cè pwi jè ârapàararà, ba bwaa nye po upwaarà co naa na nee Pwi Ukai Iésu. ");
INSERT INTO priNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","18","Â ru tòpò îru naa gòrà, â rà tòpi ê Nyuâaê Pwicîri. Ûna é côo pwiri wà Simona, â é pò ");
INSERT INTO priNT_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","â é ina tà tupédu apostolo pâ: «Gàu naa tôo mwara ê pwi pàtàma bèepwiri, ba na go tòpò ê îô naa gò pâ âboro, ba na rà tòpi ê Nyuâaê Pwicîri.» Â pwa na é naa mwani tàru. ");
INSERT INTO priNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Êco na é ina têe wà Pétéru pâ: «Pwiini! Wâdé na tiàugà bau ê mwani'gà! Wànau? Gà tà niimiri pâ, ê âraimeai kà Pwiduée, âna muru wâri goro mwani? ");
INSERT INTO priNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","O nye ticè kâgà gée goo ê wakè kâbu! Ba po dau èpà ê pwâranümagà! ");
INSERT INTO priNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Biigà jii ê pâ auniimiri'gà na èpà, â gà pwapwicîri tà Pwi Ukai, ba na é pwanauri tâgà ê auniimiri'gà. ");
INSERT INTO priNT_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Ba go côo pâ jèe dipitirigà ê èpà, â gà dau pwi a piboo. Ba ê èpà, âna é pii ê pwâranümagà ma auniimirigà.» ");
INSERT INTO priNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Â é tòpi tàru wà Simona pâ: «Tupéeni, gàu pwapwicîri ba kôo, ba na o càcaa tèepaa mariô ê pâ namuru na gàu gére ina!» ");
INSERT INTO priNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Ru picémara ê popai kà Pwi Ukai wà Pétéru ma Ioane. Â gée na càùé, â ru wâjué côwâ naa Iérusaléma. Â wii naigé, âna ru picémara ê Picémara Wâdé naa na ê pâ village na wâru, gée goo Samaria. ");
INSERT INTO priNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Napwa naa goo wà Filipo, âna é patùraé ê pwi *angela kà Pwi Ukai, â é ina têe pâ: «Gà cimadò, â gà pâra wii naigé na é boo gée Iérusaléma naa Gaza, pwi naigé na càra caa ciburà wédò na.» ");
INSERT INTO priNT_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Â é nye cimadò kaa wà Filipo, â é pâra. Ûna é pâra wii ê naigé, â ipitiru ma pwi jè âboro gée napô Éthiopie. Wà pwiibà, âna pwi âboro imaina naa na pitûâ goo ê pâ mwani kà tô ilàri ukai naa Éthiopie. Ba é wâjué côwâ gée goro aupwamaina Pwiduée na Iérusaléma. ");
INSERT INTO priNT_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Â é gére pûra ê tii na é wii wà *péroféta Isaia, na ê na wàtio kêe. ");
INSERT INTO priNT_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","É ina tà Filipo ê Nyuâaê Pwicîri pâ: «Gà paé, ba na gà cimwünyabweri ê pwi na wàtio bèepwiri gére me.» ");
INSERT INTO priNT_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","É itàa pâ wà Filipo, â é têre wà pwi Éthiopie na é gére pûra ê tii kà péroféta Isaia. Â é tawèerié wà Filipo pâ: «Gà nye tâmogòori ê pwina gà gére pûra?» ");
INSERT INTO priNT_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Â é tòpi têe pâ: «Na o wànau târa cè pai tâmogòori kôo, wiàna nye ticè na paari tôo?» Â é ila wà Filipo pâ, na é too ma é tâa jaaé. ");
INSERT INTO priNT_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","33","Napwa pwi ére na tii na é gére pûra, âna wàéni: Rà popaé pâ, pwacèwii pwi mutô na tapàgà na wàé. É tà tâa, é tà cîô na rà pwa têe na èpà. Nye dau ticè *tàrù kâra ê pwina rà pwa. Rà dàtié pâ dàra pwâra bà kêe, pwacèwii pwi mutô naa na wâra taa macii. Rà wâpà pâ naîê? Â dà cè jèkutâ na piwiâ goorà? Au, bwa, ba nye ticè! Ba jèe patâjii ê wâro kêe ni na é tâa gòropuu. Ésaïe 53.7–8 ");
INSERT INTO priNT_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Â é tawèeri Filipo wà pwi a pitûâ, pâ: «Pâri ma gà ina tôo, pâ, wàilàapà na é inaê naani wà pwi péroféta? É nye pi-inaê côwâ, é, é ina cè pwi jèpwi?» ");
INSERT INTO priNT_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Â, tapoo gée goo pwi auinapopai-bà, â é inapàpari têe wà Filipo ê Picémara Wâdé goo wà Iésu. ");
INSERT INTO priNT_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Na ru pâra wii naigé, â ru pâmari ê najawé, â é ina tà Filipo pâ: «Dà cè pwina o pacoo wiàna upwaao na jèe wàéni i najawé.» { ");
INSERT INTO priNT_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Â é tòpi têe wà Filipo pâ: «Wiàna gà cèikî gée na âji pwâranümagà, â pâri ma upwaagà.» Â é tòpi têe pâ: «Go cèikî pâ, wà Iésu Kériso âna *Pwina naî Pwiduée.»} ");
INSERT INTO priNT_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Â é nama pacoo i na wàtio, â ru boo ma wà Filipo naa najawé, â é upwaaé. ");
INSERT INTO priNT_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Na ru tò côwâ gée najawé, â é nye dàgòtù wà Filipo kaa ê Nyuâaê kà Pwi Ukai, â câé mwa caa côoê côwâ wà pwi a pitûâ. Êco na é dau ipwàdée kaa, â é nye pâra wii naigé kêe. ");
INSERT INTO priNT_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","É mwa tòpò wà Filipo naa na ville Azot ê Nyuâaê kà Pwi Ukai. Â géewê, â é pâra naa Césarée wà Filipo. Â wii naigé, â é picémara ê Picémara Wâdé naa na diri ê pâ ére. ");
INSERT INTO priNT_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Na pwi pàara-bà, âna é dau putàmu wà Saulo naa goo wà tèpa cèikî naa goo wà Iésu. Dau nümee na é pòtàmwararà, â é mudàra cè pai pwa wèe. Â é pâra nau côo wà pwi *ukai kà tèpa pwa ârapwaailò. ");
INSERT INTO priNT_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Â é ilari jiié pâ, na é wii cè tii, tà tèpa pitûâ kâra pâ *wâra pitapitiri na ville Damas. Ê tii-bà, âna é naa ê tàrù kêe ma é tâjùru diri tèpa cèikî na é pâdarirà—wà tèpa paao ma ilàri na rà wâgoo ê pai *pâra wiâ Pwi Ukai—ba na é poparà me naa *Iérusaléma. ");
INSERT INTO priNT_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Â, na é gére pâra wii naigé pâ naa Damas, â ûna é pâmwünyabweri wê, â nye me kaa géenidò *napwéretòotù ê pwi pwéelaa, â é pwéelaa bèepié. ");
INSERT INTO priNT_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","É nye tûuboo kaa naa napuu, â é têre pwi pwâratùra na ina têe pâ: «Saulo, Saulo, cina gà tubaèpà tôo?» ");
INSERT INTO priNT_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Nye dau wâgo tà Saulo kaa â é tawèeri pâ: «É?! Wâgà wàa, co Pwi Ukai?» Â é tòpi têe wà Pwi Ukai pâ: «Wâgo Iésu, na gà gére tubaèpà tôo. ");
INSERT INTO priNT_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Gà cimadò, â gà tò naa Damas, ba o mwa ina tâgà naawê, cè pwina gà pwa.» ");
INSERT INTO priNT_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Wà tèpa âboro na rà pâra wiâê, âna nye po dàpàgà tàra, â càra caa tâmogòori cèna rà ina. Ba rà nye têre ê pwâratùra, êco na nye ticè âboro cèna rà côo. ");
INSERT INTO priNT_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Ûna é cimadò gée napuu wà Saulo, â é niâ, êco na jèe câé caa côojè. Â rà mwa po tu naa goro îê, â rà popaé pâ naa Damas. ");
INSERT INTO priNT_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Â âracié tòotù na é tâa, â câé caa côojè, â câé caa ija ma wâdo. ");
INSERT INTO priNT_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","É tâa Damas pwi jè a cèikî na nee Ananias. Â é pièpàparié têe wà Pwi Ukai, â é ina têe pâ: «Ananias!» Â é tòpi têe pâ: «Wànau?» ");
INSERT INTO priNT_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Â é ina têe wà Pwi Ukai pâ: «Gà cimadò, â gà pâra naa na pwi naigé na nee ‘Tàrù’ â gà mudàra na pwârawâ kà Judas, wà pwi âboro gée na ville Tarse, na nee Saulo. Ba é gére pwapwicîri, â go nama é côo naa na nyuâa ");
INSERT INTO priNT_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","ê pwi âboro na nee Ananias na é gére tòme. Â é tòpò du îê naa gòé, ba na é côojè côwâ.» ");
INSERT INTO priNT_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Â é tòpi têe wà Ananias pâ: «Au, Pwi Ukai, wà pwi âboro-bà, âna wâru tèpa âboro na rà inaê ba èpà tôo. Ba rà ina pâ: “Po dau wâru pâ muru na èpà, na é pwa tà tèpa âboro kà Pwiduée—tèpa cèikî naa goo wà Iésu—na Iérusaléma.” ");
INSERT INTO priNT_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Â é gére wâni pa ê tàrù, na rà naa têe wà tèpa caa kà tèpa pwa *ârapwaailò, ba na é tâjùru diri wà tèpa âboro na rà ipwamainagà.» ");
INSERT INTO priNT_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Êco na é tòpi têe wà Pwi Ukai pâ: «Gà pâra, ba go jèe pitòrigari wà pwi âboro bèepwiri, ba na é pwi neemuru wakè kôo. Ba ée mwa pamogòori ê neeô na ara ê pâ Ba ma tèpa ukai kàra, ma na ara mwara ê Ba *Isaraéla. ");
INSERT INTO priNT_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Â go o mwa paari têe diri ê pwina, na ée pwa naa na aré ma tòina, ba kôo.» ");
INSERT INTO priNT_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Â é nye còobé kaa wà Ananias, â é pâra. É tò wà Ananias naa na pwârawâ na é tâa wê wà Saulo. Â é tòpò du îê naa gòé, â é ina têe pâ: «Saulo, pwi a cèikî béeò, é cùruo wà Pwi Ukai Iésu—wà Pwi Ukai na ia é piâpàparié tâgà na naigé Damas. Â é panuâô me, ba na gà côojè côwâ, â, ba na dipitirigà ê Nyuâaê Pwicîri.» ");
INSERT INTO priNT_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Â nye tûu kaa géeni na âraporomee Saulo ê pâ pwina pwacèwii ê upàra ârawéà, â é côojè côwâ. Â é cimadò, â pwa ma *upwaaé. ");
INSERT INTO priNT_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Â é ija, â me côwâ ê nii kêe. Bwaa tàpo pwa tòotù kà Saulo na Damas jaa tèpa cèikî. ");
INSERT INTO priNT_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Â géewê, âna é nye picémara kaa ê popai, pâ naa ê pâ wâra pitapitiri. Â é inapàpari tàra pâ wà Iésu, âna nye wàé kaa *Pwina naî wà Pwiduée. ");
INSERT INTO priNT_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Wà diri tàpé na rà gére tàmaariê, âna rà dau pò. Â rà ina pâ: «É! Gona càcaa wàé kaa, na ia é dau gòo goro tubaèpà tà tèpa cèikî naa goo Iésu, na Iérusaléma? Â é me mwara naani nau tâjùrurà ma poparà pâdari tèpa caa kà tèpa pwa ârapwaailò!» ");
INSERT INTO priNT_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Êco na pimaina too ê pàtàma Pwiduée naa goo ê pai tùra kà Saulo. Â é pamogòori tà wà tèpa *Juif gée Damas pâ, wà Iésu, âna é Pwi *Mesia, pwi a pa-udò na rà tapacîê gée na biu. Â càra caa tâmogòori cè pwina rà tòpi têe. ");
INSERT INTO priNT_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Jèe tàpo pwa pàara kà Saulo wâjaarà, â rà ipitiri wà tèpa Juif, â rà pitêrerà, ba na rà tétàmwereê. ");
INSERT INTO priNT_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Â, na diri ê pâ ne ma pwaa, âna rà wéaa dèe goo ê pâ goropwârawâ goro napô, ba na rà catàmwereê. Êco na é pâra nau tâmogòori pwiri Saulo. ");
INSERT INTO priNT_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Â, na jè ne, âna rà nama é uru wà tèpa bée. Ba rà tòpòé naa na pé na ai, â rà panuâê boo wii ê pé goropwiinawâ babé wâri napô. ");
INSERT INTO priNT_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","É pâra naa Iérusaléma wà Saulo, â é mudàra cè pai pwa wèe, ba na é pâra mari tèpa cèikî. Êco na wâgotàra diri gooé, ba càra caa wâari pâ é jèe pwi jè a cèikî. ");
INSERT INTO priNT_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Êco na é pitu têe wà Barnabas. Ba é popaé pâdari wà tèpa *apostolo, â é piwiâ tàra pâ: «Wà Pwi Ukai, âna é piâpàparié tà pwiibà naa gòro naigé, â é patùraé. Â ni, âna câé caa piwâ na é picémara naa na nee Iésu na Damas.» ");
INSERT INTO priNT_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Tapoo géewê, âna é jèe tâa jaarà wà Saulo, â é pâra ma me naa Iérusaléma, â é picémara ba gòo naawê, naa na nee Pwi Ukai. ");
INSERT INTO priNT_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Â é patùra mwara wà tèpa Juif na rà pwa grec. Êco na rà pwaé goro pwina é ina tàra, â wàilà mwara, âna rà mudàra cè pai pwa wèe, ba na rà catàmwereê. ");
INSERT INTO priNT_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Ûna rà tâmogòori pwiri wà tèpa cèikî, â rà popaé pâ naa na ville Césarée. Â géewê, âna rà pwa ma é pâra naa Tarse. ");
INSERT INTO priNT_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Na pwi pàara-bà, âna rà wâro na ê tàbwàti wà tèpa cèikî wâna diri ê pâ napô *Judée, Galilée ma *Samaria. Rà pipagòorà, â rà papwicîri wà Pwiduée. Â dau pitoo ê jéûrà ba é pitu tàra ê Nyuâaê Pwicîri. ");
INSERT INTO priNT_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Wà Pétéru, âna é cai pâ mwara tèpa âboro kà Pwiduée na diri ê pâ napô, â é pwa ma boo tia jaa wà tàpé na rà tâa na village Lydda. ");
INSERT INTO priNT_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Â é pâmari naawê pwi jè âboro na nee Énée, na jèe 8 naja kêe goro puu gòro aupuu kêe, ba é pitàbwamwa. ");
INSERT INTO priNT_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Â é ina têe wà Pétéru pâ: «Énée, é pwa ma gà wâdé ni wà Iésu Kériso! Cimadò, â gà pipîri ê aupuugà!» Â é nye cimadò kaa. ");
INSERT INTO priNT_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Ûna rà côoê na é pâra â rà cèikî naa goo wà Pwi Ukai wà diri tèpa âboro Lydda, ma Saron. ");
INSERT INTO priNT_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Wâjaa tèpa cèikî na ville Joppé, âna pwa ê tô ilàri, na nee Tabitha naa na *hébéru ma Dorcas naa na grec. É tô a nye po wakè kêe pwa pwina wâdé. Ba é pitu tà tàpé na piticè neemururà. ");
INSERT INTO priNT_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Êco na, na pàara-bà, âna é maagé, â é bà. Gée na càùru na rà papitooé, â rà popaé too naa na pwi narawâ na tâdòiti. ");
INSERT INTO priNT_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Ûna rà tâmogòori wà tèpa cèikî wê pâ, wà Pétéru âna é tâa Lydda, â rà cùru pâ tupédu ârailu béerà nau ina têe pâ, na é wàcî medarirà. (Ba càcaa wâiti Lydda pâ naa Joppé.) ");
INSERT INTO priNT_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Â é nye pâra kaa wiâru wà Pétéru. Ûna é tèepaa pâ, â rà popaé too naa na pwi narawâ na tâdòiti. Â wà diri ê pa ilàri dàpwà, âna rà cibèepié burà i, â rà paari têe na jèpapara ârabwée na é pwa wà Tabitha, na é bwaa wâro. ");
INSERT INTO priNT_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Â é pacòobérà diri wà Pétéru, â é tùu jùrué, â é pwapwicîri; â é tabiié dàra i naiiri âboro bà, â é ina têe pâ: «Tabitha, cimadò!» Â é nye niâ kaa wà tôobà, â ûna é côo wà Pétéru, â é nye too kaa nau tâa! ");
INSERT INTO priNT_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Â é tu pâ dèe wà Pétéru, â é pacimadòé. Â nabwé, â é todà pa ilàri dàpwà ma diri pàra âboro kà Pwiduée, â é paari tàra wà Tabitha, na é jèe wâro côwâ! ");
INSERT INTO priNT_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Diri tèpa âboro wâ Joppé, âna rà têre ê pwi jèkutâ-bà, â dau wâru tàpé na rà cèikî naa goo wà Pwi Ukai. ");
INSERT INTO priNT_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Tàpo gòiri wà Pétéru wê, â é pitâa jaa pwi âboro na nee Simona, pwi a wakè goro parawére macii. ");
INSERT INTO priNT_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Pwa pwi âboro na é tâa Césarée na nee Corneille, pwi *Roma. Wà pwiibà âna é pwi jè caa kâra 100 coda, gée nabibiu kâra wâra coda kà tèpa Italie. ");
INSERT INTO priNT_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Wà pwi âboro-bà, âna wâdé têe ê pwapwicîri kà tèpa *Juif, wàé mara ê pwârawâ kêe. É dau pwi a pimeai tèpa Juif na ticè kàra, â é pwi a nye tà pwapwicîri tà Pwiduée. ");
INSERT INTO priNT_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Na jè tòotù, na âracié inere-tòotù na càùru ija, â é pwapwicîri, â é nye po côo bwàti kaa pwi *angela kà Pwiduée na é tò mariê naa wâ, â é ina têe pâ: «Corneille!» ");
INSERT INTO priNT_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Â é nye po côoê kaa wà Corneille, â dau wâgotêe, â é ina pâ: «Dà, co Pwi Ukai?» Â é ina pwi angela pâ: «Napwa ê pâ pwâra pwapwicîri'gà, âna é têre wà Pwiduée, â é côo ê pai imeaigà, â câé caa imwüru jii. ");
INSERT INTO priNT_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Gà naa pâ ni naa Joppé cè tèpa âboro, ba na rà pâ nau todà me wà Simona, na ina gooé mwara pâ Pétéru. ");
INSERT INTO priNT_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","É pitâa jaa wà Simona, pwi a wakè goro parawére macii. Ê pwârawâ kà pwiibà, âna tâa bàrawià.» ");
INSERT INTO priNT_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Na é pâra côwâ i pwi angela, â wà Corneille, âna é todà tupédu ârailu âboro gée jaa tèpa ênawéna kêe. Â é todà mwara pwi jè coda kêe, gée nabibiu kà tèpa coda na é pitûâ kàra—pwi coda na jèe dau gòrié jaaé, â pwi a pitòimiriê naa goro pwapwicîri. ");
INSERT INTO priNT_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Gée na càùru na é wiâ tàra diri ê pâ pwina tèepaa mariê, â é cùrurà pâ naa Joppé. ");
INSERT INTO priNT_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Na tòotù gée paé côwâ, na po gopaé bwàti, âna rà pâmwünyabweri Joppé. Na pwi pàara-bà, âna é too wà Pétéru naanidò gòrowâ, nau pwapwicîri, ");
INSERT INTO priNT_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","na rà pwabwàti ê uti kêe wà tèpa âboro wâ pwârawâ. Na é gére pwapwicîri, â me mariê pwâra copwa, â nümee dàra ija. Â wà Pwiduée, âna é paari têe naa na nyuâa ê pâ muru. ");
INSERT INTO priNT_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","É nye côo kaa ê napwéretòotù na é tàpirié, â é boome géewê ê pwina pwacèwii ê pwérela na dau maina na cipa pâ ârapàpé naûruê. Â é tàbàtù boome naa gòropuu. ");
INSERT INTO priNT_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Â tâa na, diri ê pâ na pwâra macii na ârapàpé ârà, ma êdiri pâ âgòri ma âûtòo ma dòèa, ma êdiri pâ marü mwara. ");
INSERT INTO priNT_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Â é ina têe pwi pwâratùra pâ: «Gà cimadò co Pétéru, â gà taa, â gà uti.» ");
INSERT INTO priNT_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Êco na é ina wà Pétéru pâ: «Bwa! Tàutôo co Pwi Ukai, ba câgo caa mu uti ê pwina papwicîri ê *Naèà kâbà.» ");
INSERT INTO priNT_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","É jèu têre mwara i pwâratùra, na é ina têe pâ: «Gà cibwaa câbaèpà ê pwina é ina wà Pwiduée pâ muru na wâdé.» ");
INSERT INTO priNT_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","É wacié tèepaa ê pâ namuru bèepwiri, â gée na càùé, â càù too côwâ naa napwéretòotù. ");
INSERT INTO priNT_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Â, na gére wàrapwiri, â wà i tèpa âboro na ia é cùrurà wà Corneille, âna rà jèe pitawèeri cèna é wêe i pwârawâ kà Simona, â tòcia tàra i pwârawâ. Â rà tèepaa pâ naa goropwârawâ, na pàara na wà Pétéru na é bwaa gére pimudàra cè pai ina wàra i pwi na ia é paari têe wà Pwiduée. ");
INSERT INTO priNT_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Â rà to, â rà tawèeri pâ: «Gona nye wâni kaa na é pitâa wê wà Simona, pwina nee Pétéru?» ");
INSERT INTO priNT_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Na é bwaa gére pinünüma wà Pétéru naa goo i pwi na ia é côo, â é ina têe ê Nyuâaê Pwicîri pâ: «Pwiini, rà wâni wà tèpa âracié âboro na rà mudàgà. ");
INSERT INTO priNT_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Cimadò ma gà boo, â gà cibwaa piwâ na gà pâra wiârà, ba wâgo na naarà me.» ");
INSERT INTO priNT_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Â é boo wà Pétéru, â é ina tà tèpa âboro bèeni pâ: «Wà pwi âboro na guwà gére mudèe, âna wâgo kaa. Dà cè majoroé ma guwà me?» ");
INSERT INTO priNT_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Â rà tòpi têe pâ: «É cùrubà me wà Corneille, pwi caa kâra coda, pwi âboro na é *tàrù, â wâdé têe ê pwapwicîri kà tèpa Juif. Wà diri mwara tèpa Juif, âna rà pi-inaê ba wâdé. É piâpàparié wà pwi angela kà Pwiduée, â é ina têe pâ, na é pwa ma gà me naa pwârawâ kêe, ba na é têre cè pwina gà ina têe.» ");
INSERT INTO priNT_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Nabwé, â é ticiarà wà Pétéru ma rà bwaa puu. Na dàuru kêe, âna é jèe pâra wiâ tèpa âracié âboro bèeni wà Pétéru. Â rà pâra wiâê mwara wà pàra tèpa cèikî na tâa Joppé. ");
INSERT INTO priNT_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Na pwi tòotù gée paé côwâ, â rà tèepaa pâ naa Césarée. Â é tà tapacîrà wê wà Corneille, ma wà tèpa âboro gée na tâa kêe ma tèpa âji bée, na é nye todàra me. ");
INSERT INTO priNT_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Na é tò wà Pétéru, â é pâra caraé wà Corneille, â é tùu jùrué burà cùué boo naa goro â wà Pétéru. ");
INSERT INTO priNT_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Êco na é dàgòtùé wà Pétéru, â é ina têe pâ: «Gà cimadò, ba go nye pwi âboro pwacèwiigà!» ");
INSERT INTO priNT_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","É nye gére tùra burà too naa na wâ wà Pétéru, â é pâmari pâ âboro na wâru, na rà jèe tàgére tâa wê. ");
INSERT INTO priNT_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Â é ina tàra pâ: «Guwà jèe nye tâmogòori pâ muru pwicîri tà tèpa Juif, na rà pabée tàpé na càra caa tèpa Juif. Â papwicîri jiirà mwara na rà tò naa jaarà. Êco na é jèe paari tôo wà Pwiduée pâ, na go cibwaa câbaèpà pwi âboro ma go cibwaa miiriê. ");
INSERT INTO priNT_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Êkaa na, na guwà todòo me, â nye ticè pwina na go bwaa èrà goo.» «Â go tawèeriwà pâ: Dà cè majoroé ma guwà nama go me?» ");
INSERT INTO priNT_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Â é ina têe wà Corneille pâ: «Jèe âracié tòotù nabà, gée na càùru pwi tòotù na go pwapwicîri ni, na âracié ineretòotù. Â pwi tòotù-bà, âna é piâpàpario pwi âboro na pwâra ê ârabwée kêe, â é ina tôo pâ: ");
INSERT INTO priNT_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","“Corneille, wà Pwiduée, âna é jèe tòpi ê pwâra pwapwicîri'gà. Â câé caa imwüru ê pai imeaigà. ");
INSERT INTO priNT_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Â ni, âna gà cùru pâ naa Joppé cè tèpa âboro nau todà me wà Simona, pwina nee mwara Pétéru, na é pitâa na pwârawâ kà Simona, pwi a wakè goro parawére macii. Napwa pwârawâ kêe, âna tâa bàrawià.” ");
INSERT INTO priNT_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Êkaa na go panuâ wài paé tèpa âboro, ba na rà todàgà, â nye dau wâdé kaa na gà me. Êni, âna bà jèe wâdiri ara Pwiduée, ba na bà têre diri ê pâ namuru na é jèe naa tâgà wà Pwi Ukai, ba na gà ina tâbà.» ");
INSERT INTO priNT_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","É inapàpari tàra wà Pétéru pâ: «Go mwa nye tàgére tâmogòori kaa pâ napwa wà Pwiduée, âna câé caa pwaké goro âboro. ");
INSERT INTO priNT_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Ba, naa na diri ê pâ napô, âna wà pwi âboro na é papwicîri wà Pwiduée ma pwa ê pwina wâdé, ma imeai, âna é wâdéarié wà Pwiduée. ");
INSERT INTO priNT_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","É jèe panuâ ê popai târa ê Ba *Isaraéla—ê Picémara Wâdé târa ê pinaanapô na é naigé mee wà Iésu Kériso, Pwi Ukai kâra diri ê pâ âboro. ");
INSERT INTO priNT_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","«Guwà jèe tâmogòori ê pwina tèepaa béaa na Galilée, géewê, tia na diri ê napô *Judée, gée na càùru ê pai picémara ê *piupwaa kà Ioane. ");
INSERT INTO priNT_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Ba wà Pwiduée, âna é naaboo ê pàtàmara ê Nyuâaê Pwicîri naa gò wà Iésu, pwi âboro gée Nazareth. É pâra diri naa pâ ére, â é pwa na wâdé tà tèpa âboro, ba é wâjaaé wà Pwiduée. Â é nama rà wâdé côwâ wà tàpé na rà maagé, ma êdiri wà tàpé na wâgoorà ê pàtàma wà *Caatana. ");
INSERT INTO priNT_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","«Wàibà kaa tèpa *paâjupâra wàra diri ê pâ pwina é pwa, na *Iérusaléma, tia na pàra ére napô gée goro Judée. Êco na rà tanamiriê naa goro *kurucé, â é bà. ");
INSERT INTO priNT_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","«Êco na wà Pwiduée, âna é nama é wâro côwâ, na pwi béâracié kâra tòotù gée na càùé. Â é pwa ma é piâpàparié tâbà co. ");
INSERT INTO priNT_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Wàibà tàpé na pitòrigaribà béaa, ba na bà mwa tèpa paâjupâraê. Wàibà tàpé na bà picaaija ma wâdo ma wàé, gée na càùru na é wâro côwâ jii tèpa bà. Ba câé caa pwa ma piâpàparié târa diri ê pâ âboro. ");
INSERT INTO priNT_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Â nye wà Iésu kaa na é jèe cùrubà pâ, ba na bà pâra nau picémara ê *Picémara Wâdé târa ê Ba, ma inapàpari pâ, jèe wàé kaa pwina é jèe tòpòé wà Pwiduée, ba na ée mwa pwi a pitèi tàpé na rà wâro ma tàpé na rà bà. ");
INSERT INTO priNT_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","«Â wà diri tèpa *péroféta, âna rà jèe tàmara ina pâ, cè pwina é cèikî naa goo Iésu, âna o pwanauri ê èpà kêe, naa na nee.» ");
INSERT INTO priNT_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Ûna é bwaa gére tùra wà Pétéru, â é nye boome kaa ê Nyuâaê Pwicîri naa gò diri tàpé na rà tàmaari ê popai kà Pwiduée. ");
INSERT INTO priNT_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Wà tèpa Juif na rà cèikî, na ia rà me wiâ wà Pétéru, âna rà pò, na naa boome mwara ê Nyuâaê Pwicîri naa gò tàpé na càra caa tèpa Juif. ");
INSERT INTO priNT_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Ba rà têrerà na rà tùra naa ê pâ pwâratùra na ité, ma pwamaina Pwiduée. Â é ina wà Pétéru pâ: ");
INSERT INTO priNT_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","«Wànau, o nye pâri ma câjè caa *upwaa tàpé na rà jèe tòpi ê Nyuâaê Pwicîri, pwacèwiijè?» ");
INSERT INTO priNT_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Â é naa tàrù wà Pétéru, ba na upwaarà naa na nee Pwi Ukai Iésu. Gée na càùé, â rà ilaé pâ, na é bwaa tàpo pwa cè pàra tòotù wâjaarà. ");
INSERT INTO priNT_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Wà tèpa *apostolo ma tèpa cèikî, na rà tâa napô *Judée, âna rà têre pâ wà pàra tàpé na càra caa tèpa *Juif, âna rà jèe cèikî mwara naa goro ê popai kà Pwiduée. ");
INSERT INTO priNT_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Ûna é too naa *Iérusaléma wà Pétéru, â wà tèpa cèikî na rà tèpa Juif, âna rà cagòtù têe ê pwina é pwa, â rà ina têe pâ: ");
INSERT INTO priNT_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","«Cina gà too naa jaa tàpé na càra caa tèpa Juif, ma guwà pi-ija naima ma wàilà?» ");
INSERT INTO priNT_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Â wà Pétéru, âna é piwiâ tàra bwàti ê pâ namuru na tèepaa mariê, gée na autapoo goo ê pwi jèkutâ-bà. Â é ina pâ: ");
INSERT INTO priNT_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","«Go tâa Joppé, â na pàara na go bwaa gére pwapwicîri na, âna go côo jè muru, na é paari tôo naa na nyuâa wà Pwiduée—pé pwina pwacèwii ê pwérela na dau maina, na cipa ê pâ ârapàpé naûruê. Â é boome gée napwéretòotù tia jaao. ");
INSERT INTO priNT_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Ûna go ucâri ê pé pwérela bèepwiri, â go côo naa na, pâ macii âraèrù, ma macii a piugà, ma pâ âgòri, ma pâ âûtòo, ma pâ dòèa, ma pâ marü mwara. ");
INSERT INTO priNT_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Â go têre ê pwâratùra, na ina tôo pâ: “Gà cimadò co Pétéru, â gà taa, â gà uti.” ");
INSERT INTO priNT_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","«Êco na go ina pâ: “Bwa! Tàutôo co Pwi Ukai, ba muru pwicîri naa na ê *Naèà kâbà. Â câgo caa mu uti gée goo!” ");
INSERT INTO priNT_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","«Â go jèu têre mwara i pwâra-tùra na me gée napwéretòotù, na ina pâ: “Gà cibwaa câbaèpà ê pwina é ina wà Pwiduée pâ muru na wâdé.” ");
INSERT INTO priNT_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","É wacié tèepaa ê pâ namuru bèepwiri, â gée na càùé, â càùrà too côwâ naa napwéretòotù. ");
INSERT INTO priNT_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","«Â rà nye tèepaa medario kaa wà tèpa âracié âboro me gée Césarée naa na pwârawâ na bà tâa na. ");
INSERT INTO priNT_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Â é ina tôo ê Nyuâaê Pwicîri pâ: “Gà cibwaa piwâ na gà pâra wiârà.” Â wà tèpa 6 béejè na wàilà-ni, âna rà me wiâô naa Césarée, â bà capai too naa na ê pwârawâ kà Corneille. ");
INSERT INTO priNT_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","«Â é piwiâ tâbà wà Corneille ê pai côo kêe pwi *angela naa pwârawâ na é ipaarié têe, ma ina têe pâ: “Panuâ pâ cè âboro naa Joppé nau mudà Simona, pwina ina gooé mwara pâ Pétéru, ");
INSERT INTO priNT_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","ba ée mwa ina tâgà pâ, na popai na gà o udò goo, wâgà ma diri ê pwârawâ'gà, ba na o tâa tàwà ê *âji wâro.” ");
INSERT INTO priNT_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","«Ûna go tapoo tùra, â é boome naa gòrà ê Nyuâaê Pwicîri, pwacèwii naa gòjè naa na autapoo goo. ");
INSERT INTO priNT_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Â go nye tà niimiri ê pwi popai kà Pwi Ukai, na é ina pâ: “Wà Ioane, âna é *piupwaa goro jawé, êco na wâguwà, âna o mwa *upwaawà goro ê Nyuâaê Pwicîri.” ");
INSERT INTO priNT_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","«Wà Pwiduée, âna é nye naa tàra mwara ê âraimeai, i Nyuâaê Pwicîri, ma pwacèwiijè, na jè cèikî naa goo Pwi Ukai Iésu Kériso. Â go pwi wàa, ma go cicara wà Pwiduée?» ");
INSERT INTO priNT_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Gée na càùru ê pai têre kàra pwiri, â rà jèe nabwé na rà putàmu, â rà pwamaina Pwiduée, â rà ina pâ: «Üu kaa! Âjupâra pâ wà Pwiduée, âna é naa mwara ê âji wâro tà tàpé na càra caa tèpa Juif, na rà pinünüma ma biirà dèe.» ");
INSERT INTO priNT_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Gée na càùru ê pai bà kà Étienne, â tapoo pwa-imudiri tà tèpa cèikî, â rà jèpa ipiina pâ naa ê pâ napô, naa Phénicie, ma naa na ville Antioche ma gòropô Chypre. Â rà picémara ê popai naawê; êco na rà nye picémara co tà tèpa Juif. ");
INSERT INTO priNT_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Êco na wà pàra tàpé gée jaarà, tèpa âboro gée Chypre ma na ville Cyrène, âna rà me naa Antioche. Â rà picémara ê *Picémara Wâdé kà Pwi Ukai Iésu tà tàpé na càra caa tèpa Juif. ");
INSERT INTO priNT_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Nye tâa gòrà ê nii kà Pwiduée, â wâru tèpa âboro, na rà biirà naa goo wà Pwi Ukai, â rà cèikî. ");
INSERT INTO priNT_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Ûna rà têre pwiri wà tèpa cèikî na wâra pwapwicîri Iérusaléma, â rà panuâ pâ wà Barnabas naa Antioche. ");
INSERT INTO priNT_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Ûna é tèepaa pâ, â é côo ê *aupwényunyuâari kà Pwiduée naa gò tèpa âboro, â é dau ipwàdée. Â é pagòorà diri ma rà cimwü bwàti naa goo Pwi Ukai. ");
INSERT INTO priNT_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Ba wà Barnabas, âna pwi âboro na é dau wâdé, â maina ê cèikî kêe. Â dau tâa gòé ê Nyuâaê Pwicîri. Â wâru mwara tàpé na rà cèikî naa goo Pwi Ukai. ");
INSERT INTO priNT_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Géewê, â é pâra naa na ville Tarse, ba na é mudà wà Saulo. ");
INSERT INTO priNT_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Ûna é pâmariê, â é popaé me naa Antioche. Ru tâa wê naa na caapwi naja. Ru pâra taaci naa na pâ ipitiri kâra wâra pwapwicîri, â rà pacâmuri pâ âboro na wâru. Nye tapoo kaa na Antioche, na tapoo ina goo tèpa cèikî pâ chrétiens, pai ina wèe pâ ‘tèpa cèikî naa goo wà Kériso’. ");
INSERT INTO priNT_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Na pàara bèepwiri, âna rà boome gée Iérusaléma naa Antioche pâ tèpa *péroféta na rà pame ê popai gée jaa wà Pwiduée. ");
INSERT INTO priNT_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Pwi jè ârapàararà, âna nee Agabus. Â wâgooé ê pàtàmara Nyuâaê Pwicîri. Â é cimadò, â é ina tàra pâ: «O mwa pwa cè copwa na dau maina pitiri gòropuu.» (Â nye coo pwi auina-bà na pàara kà Claude, pwi ukai kà tèpa *Roma.) ");
INSERT INTO priNT_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Napwa naa goo wà tèpa cèikî, âna rà pitêrerà, ba na rà panuâ pâ cè bépitu kàra tà tèpa cèikî na rà tâa Judée. Rà nye jèpa naa ê pwina pâri ma rà naa wiâra ê pumara wakè kàra. ");
INSERT INTO priNT_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Â wà Barnabas ma Saulo, âna ru pa pâ i âraimeai dari tèpa pitûâ kâra wâra pwapwicîri. ");
INSERT INTO priNT_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Na pàara-bà, âna é tubaèpà tà pàra tèpa cèikî wà ukai *Héroda Agrippa I. ");
INSERT INTO priNT_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Â é naa tàrù, ba na tòtàmwara goro tàuwa wà Jacques, pwi aéjii kà Ioane. ");
INSERT INTO priNT_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Ûna é côo pâ wâdé tà tèpa *Juif, â é nama tâjùru mwara wà Pétéru, na pwi jè *tòotù maina kàra, pwi tòotù na pi-ija poloa na ticè nyaa kêe. ");
INSERT INTO priNT_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Â é pwa ma tüê naa na karapuu, â é nama wéaarié ê ârapàpé gomu na piârapàpé coda naa na. Ba nümee na pitèi Pétéru na ara diri ê pâ âboro, gée na càùru tòotù *Paséka. ");
INSERT INTO priNT_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Â rà wéaari wà Pétéru naa na karapuu. Â napwa wà tèpa cèikî, âna rà gòo goro pwapwicîri taaci ba kêe. ");
INSERT INTO priNT_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Na pwi bàrane béaa kâra ê pai pitèié, âna wà Pétéru, âna é puu nabibiu kâra ârailu coda. Â tòoé goro itùpaò, naa goo tupédu coda. Â pwa mwara tèpa coda, na rà wéaari ê goropwârawâ goro karapuu. ");
INSERT INTO priNT_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Êco na é nye pwairi tèepaa kaa pwi jè *angela kà Pwi Ukai, â nye po pwéelaa kaa na karapuu. Â wà pwi angela, âna é pitaci gòro jènere wà Pétéru. Â é ina têe pâ: «Gà cimadò wài!» Â nye tûu kaa gée goro ê du î wà Pétéru i pâ itùpaò. ");
INSERT INTO priNT_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Â é jèu ina têe côwâ wà pwi angela pâ: «Gà piigà goro i karapuu'gà, â gà coona i du wâraâgà.» Â é nye pitêre dèe wà Pétéru. Â é ina têe mwara wà pwi angela pâ: «Wâdé. Â gà coona i palito'gà, â gà me wiâô.» ");
INSERT INTO priNT_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Â é pâra wiâê gée na karapuu wà Pétéru. Êco na câé caa tâmogòori pâ ê pâ pwina é pwa têe wà pwi angela, âna nye tàgére âjupâra. Ba é niimiri pâ é pwa âcôwâ. ");
INSERT INTO priNT_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Â ru wénari ê tèpa coda na rà wéaa béaa, â ru wénari mwara wà tàpé na rà coo wê. Â ru tèepaa pâ naa goo ê goropwârawâ paò na babé wâri ê ville. Â é nye pitàpirié acari béaa kàru, â ru còobé, â ru pâ naa jè naigé. Gée pwiri, â nye tàpo tiàu kaa i pwi angela. ");
INSERT INTO priNT_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Â pitâmogòo nüma wà Pétéru, â é ina pâ: «Nye âjupâra kaa! Wà Pwi Ukai, âna é nye panuâ me pwi angela kêe, ba na é upao gée na-araraî wà Héroda! Â é upao jii ê pâ pwina èpà na rà pwa na rà pwa tôo tèpa Juif na rà cicarabà.» ");
INSERT INTO priNT_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","É pâra wà Pétéru naa na pwârawâ kà Maria, nyaa kà Ioane (na jè nee mwara Maréko). Rà tàgére tâa wê ê jè auwâru goro tèpa cèikî, â rà nye tàgére pwapwicîri. ");
INSERT INTO priNT_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Â é cùu ê goropwârawâ na autò wà Pétéru, â é me wà Rhode nau tàpiri. (Wà tôoni, âna tô ênawéna na pwi pwârawâ-bà.) ");
INSERT INTO priNT_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Â é têreina ê pwâratùra kà Pétéru, â naa na pai wâdé têe, â é itàa pâ, na ina pâ: «É! Wà Pétéru na é wâboo gòroigé!» Â é imwüru na é tàpiri i goropwârawâ! ");
INSERT INTO priNT_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Â rà ina têe pâ: «Gà ipwirié co tôoni!» Êco na é nye gòo goro ina pâ: «Akaé! Go nye âjupâra.» Â rà ina mwara têe pâ: «Bwa! O gére nyuâaê.» ");
INSERT INTO priNT_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Na rà gére wàrapwiri pai tùra kàra, âna wà Pétéru, âna é nye tàgére gòo goro cùu taaci i goropwârawâ! Â rà mwa tàpiri, â rà nye dau pò kaa. ");
INSERT INTO priNT_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Â é pwa ineremuru tàra pâ, na rà cibwaa tùra. Â é piwiâ tàra ê pai pacòobée gée na karapuu. Â é ina tàra pâ: «Guwà mwa ina tà Jacques ma pàra tèpa cèikî béejè.» Â é còobé jiirà, â é pâra naa na jè ére. ");
INSERT INTO priNT_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Ûna pwaa dòme, â rà paé ma me wà tèpa coda. Â rà dau géaa, ba càra caa tâmogòori cèna é wêe wà Pétéru, â dau wâgotàra. ");
INSERT INTO priNT_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Â é nama rà mudèe bwàti wà Héroda, êco na càra caa pâmariê. Â é pitawiâ wà tèpa wéaa, â é nama catàmwararà. Gée na càùé, â é boo wà Héroda gée napô *Judée naa Césarée, ba na é pitâa wê. ");
INSERT INTO priNT_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","É dau putàmu wà ukai Héroda naa goo wà tèpa âboro gée Tyr ma Sidon. Êco na rà me nau côoê, ba na rà ilari jiié ê pinaanapô. (Ba ê du ville kàra, âna ru wâro goo ê napô kà Héroda.) Â rà nama é pwi naigé mee wà Blastus, pwi ênawéna kà pwi ukai, pwi a wéaari ê pwârawâ maina kêe. ");
INSERT INTO priNT_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Na pwi tòotù na é jèe dàbacoo na wà Héroda, â é coona ê ârabwée kâra ukai kêe. Â é too naa gòro ê autâa kêe, â é patùra tèpa âboro. ");
INSERT INTO priNT_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Â rà nye dau picâdirié, ma ina pâ: «É! Càcaa pwi âboro na gére tùra! Â pwi jè pwiduée!» ");
INSERT INTO priNT_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Â wâdé têe na rà pwamainaê jii wà Pwiduée. Êkaa na é nye èié kaa ê pwi angela kà Pwi Ukai, â rà iri ê naparawée ê pâ âgù, â é bà. ");
INSERT INTO priNT_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Napwa naa goo ê popai kà Pwi Ukai, âna jèe dau picémara ba maina pâ, â é pitoo ê jéû tèpa cèikî. ");
INSERT INTO priNT_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Gée na càùru ê pai wakè kà Barnabas ma Saulo, â rà wâjué côwâ gée *Iérusaléma, wàilà ma Ioane-Maréko. ");
INSERT INTO priNT_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Naa na wâra pwapwicîri naa Antioche wâna province Syrie, âna pwa pàra tèpa *péroféta, ma tèpa ipacâmu—wà Barnabas, wà Siméon pwina ina gooé pâ ‘Pwi âboro duu’; Lucius gée na ville Cyrène; Manaën na ia ru pimaina naima ma pwi kupénoo *Héroda Antipas; ma wà Saulo. ");
INSERT INTO priNT_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Pwa pwi pàara na rà gére ipwanya—ba rà panuâ ê ija, ba na rà gére pwapwicîri tà Pwi Ukai. Â é ina tàra ê Nyuâaê Pwicîri pâ: «Guwà pitòpò naaiti wà Barnabas ma wà Saulo, târa ê wakè na go todàru naa goo.» ");
INSERT INTO priNT_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Gée na càùru ê ipwanya ma pwapwicîri kàra, â rà tòpò îrà naa gòru ba na pwényunyuâariru â rà panuâru pâ. ");
INSERT INTO priNT_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","5","É cùru pâ Barnabas ma Saulo ê Nyuâaê Pwicîri. Â é pâra wiâru wà Ioane-Maréko, ba na é pitu tàru. Rà boo naa na ville Séleucie, â géewê, â rà pâ gòro wànga naa gòropô Chypre. Ûna rà tèepaa pâ naa na ville Salamine, â ru picémara ê popai kà Pwiduée wà Barnabas ma Saulo, naa na pâ *wâra pitapitiri kà tèpa *Juif. ");
INSERT INTO priNT_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Ûna ru jèe pâra pitiri ê pô, tia na ville Paphos, â ru pâmari pwi jè Juif na nee Bar-Jésus (Élymas naa na grec). Wà pwi âboro-bà, âna pwi a pwa tutê, â é ina pâ wàé pwi péroféta kà Pwiduée na é pame popai kêe. ");
INSERT INTO priNT_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Wà pwiibà, âna pwi bée Sergius Paulus, pwi kupénoo kâra pô-bà, na pwi a tàmanga. Wà pwi kupénoo-bà, âna é todà wà Barnabas ma Saulo, ba dau nümee na é têre ê popai kà Pwiduée. ");
INSERT INTO priNT_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Êco na wà Élymas, âna é mudàra, ba na é dàbii ê aucèikî kà pwi kupénoo. ");
INSERT INTO priNT_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Wà Saulo (na ina gooé mwara pâ Paulo), âna dipitirié ê Nyuâaê Pwicîri, â é ucâri Élymas burà ina têe pâ: ");
INSERT INTO priNT_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","«Pwina naî *Caatana! Gà pwi a cicara ê pwina *tàrù! Dau pwi a maina kaa ê pwa tûâ naa googà! Wànau? Bwaa caa pâ nabwé kaa ê pai cicaragà ê pâ naigé na tàrù kà Pwi Ukai? ");
INSERT INTO priNT_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Ée tatéegà wà Pwi Ukai, â gà o bwi ni, â o tàpo pwa pàara na o câgà caa côojè.» Â nye me kaa ê bàutê naa gò wà Élymas, â jèe câé caa côojè. Â é mudàra ma cèi dàra pâ âboro, ba na rà pipopaé. ");
INSERT INTO priNT_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Napwa naa goo wà pwi kupénoo, âna é pò goro ê pwina gére tèepaa, ma ê pàtàmara ê popai kà Pwiduée, â é nye cèikî kaa. ");
INSERT INTO priNT_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Gée na càùé, â wà Paulo ma tèpa bée, âna rà pa wànga gée Paphos, pâ naa na ville Perge gée goo province Pamphylie. Â é pâra jiiru naawê wà Ioane-Maréko, â é wâjué côwâ naa *Iérusaléma. ");
INSERT INTO priNT_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Â gée Perge, âna ru pâra wà Paulo ma Barnabas, â ru pâra wii ê naigé pâ naa Antioche goro jènere pwi ére napô Pisidie. Ûna ru tèepaa pâ naawê, â ru tò naa na wâra pitapitiri kà tèpa Juif, na *tòotù pwicîri. ");
INSERT INTO priNT_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Wà tèpa âboro na rà pwapwicîri wê, âna rà gére pûra i tii goro *Naèà kà Moosé, ma i tii kà tèpa péroféta. Â rà ina tàru wà tèpa pitûâ pâ: «Tupédu jènerebà, wiàna pwa cè popai kàu, târa pagòojè, â gàu cimadò ma gàu tùra.» ");
INSERT INTO priNT_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","É cimadò wà Paulo, â é pwa ineremuru, ba na rà cibwaa tùra, â é ina pâ: «Bwa; guwà têre diri, i tàpé *Isaraéla, ma wâguwà mwara na guwà gére pwapwicîri naima. ");
INSERT INTO priNT_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Wà Pwiduée kâra ê pwi Ba kâjè Isaraéla, âna é pitòrigari wà tèpa caa kâjè. Â é pwa ma é pimaina too ê Ba, na pwi pàara na rà bwaa pwa pârame naa napô *Aigupito. Â é pwa ma rà còobé, goro ê nii ma pàtàmee. ");
INSERT INTO priNT_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Â é pa-ijarà na wâpâ na 40 naja, naa namaré. ");
INSERT INTO priNT_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","«É pwa ma rà pwâri ma catàmwara ê 7 mwaciri naa napô *Kanana, â é panuâ tàra ê napô, ba na tèpa âji apooé. ");
INSERT INTO priNT_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Ê pwi pàara-bà, âna wâmwünyabweri 450 naja gée na càùru pai pitòrigarirà kêe na Aigupito. Â é naa tàra wà tèpa ukai juges, târa pipoparà tiagoro ê pàara kà péroféta Samuéla. ");
INSERT INTO priNT_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","«Nye, na pwi pàara-bà, na wà tèpa ijiao kâjè, âna rà ilari jii Pwiduée cè pwi ukai kàra. Â é naa tàra wà Saül, pwina naî Kis gée na wâao kà *Benjamin. Â wà Saül âna é pwi ukai kàra naa na 40 naja. ");
INSERT INTO priNT_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","«Gée na càùé, â é tapwùtù Saül wà Pwiduée, â é naa târa ê Ba wà pwi ukai *Davita. É ina wà Pwiduée gooé pâ: Go jèe pâmari wà Davita pwina naî Jessé, pwi âboro na wânümoo gooé, na ée mwa pacoo diri câbawâdé kôo. ");
INSERT INTO priNT_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","«Â ê autûâri kà Pwiduée, âna na ée mwa còobé gée na ê tâa kà Davita, wà Iésu pwi a-upa Isaraéla. ");
INSERT INTO priNT_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","«Béaa kâra ê pai tèepaa kà wà Iésu, âna é me wà *Ioane Pwi a piupwaa, â é picémara tà tèpa Isaraéla. Â é ina tàra pâ: “Guwà pinünüma ma guwà biiwà ma *upwaawà.” ");
INSERT INTO priNT_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Ûna é pwa na é tubanabwé ê wakè kêe, â é mu nye tà ciburà ina tàra wà Ioane pâ: “Gona guwà gére niimiri pâ wâgo wàa? Ba càcaa wâgo pwi *Mesia, pwi ukai na guwà tapacîê gée na biu. Guwà côo, ée mwa pwicò kôo wà pwiibà, na po dau càcaa pâri ma go tipi ê otàpwe goro du wâraâê.”» ");
INSERT INTO priNT_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","É ina mwara wà Paulo pâ: «Tàpo tàmaariô, co tèpa jènereô, tèpa gòobàra *Abéraama, ma wâguwà mwara na papwicîri wà Pwiduée. Jèe panuâ medarijè diri ê pwi popai bèeni, ba na jè udò, ma tâa tâjè ê *âji wâro. ");
INSERT INTO priNT_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Êco na wà tèpa âboro Iérusaléma ma tèpa ukai kàra, âna càra caa câmogòori pâ, wà Iésu, âna é me, ba na jè udò. Càra caa tâmogòori ê popai na rà ina béaa wà tèpa péroféta; ê popai na rà mu pûra diri na ê pâ tòotù pwicîri! Êco na rà pacoo ê popai-bà, na rà pwa ma é bà wà Iésu. ");
INSERT INTO priNT_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","«Â rà nye tâmogòori pâ, nye ticè na é pwa wà Iésu na pâri ma tétàmwereê goo. Êco na rà nye ilari jii wà *Pilato pâ, wâdé na é bà naa goro *kurucé. ");
INSERT INTO priNT_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Ba rà pacoo diri ê pâ namuru na ina naa gooé. Â gée na càùé, â rà naaê boo gée goro kurucé, â rà tòpòé naa na auipwàni.» ");
INSERT INTO priNT_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","«Êco na wà Pwiduée, âna é pawâroé côwâ, gée nabibiu kà tèpa bà. ");
INSERT INTO priNT_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Â naa na pâ tòotù na dau wâru, â é ipaarié taaci wà Iésu tà tèpa âboro na ia rà too ma wàé gée Galilée naa Iérusaléma. Â nabàni, âna rà jèe tèpa *paâjupâraê naa nabibiu kâra ê Ba Isaraéla. ");
INSERT INTO priNT_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","«Â wàibà, âna bà picémara tàwà ê pwi *Picémara Wâdé bèepwiri. Ba é jèe mara ina béaa wà Pwiduée tà tèpa jojoorojè pâ ée mwa pwa jè muru. ");
INSERT INTO priNT_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Â nabàni, âna é pwa ba kâjè tèpa naîrà ma pàra tàpé mwara. Ba é pwa ma é wâro côwâ wà Iésu. «Jèe wii gooé, naa na béârailu kâra salamo kà Davita pâ: Wàéni popai kôo, na go ina nabà: Gà pwina naîô, â go pwi caa'gà. Psaume 2.7 ");
INSERT INTO priNT_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","«Â wà Pwiduée, âna é pawâroé côwâ, gée nabibiu kà tèpa bà, ba na é cibwaa wâjué côwâ naa na auipwàni, â é cibwaa wai ma botére. Ba ée jèe mara ina wà Pwiduée pâ: Go mwa naa tàwà ê *aupwényunyuâari na go jèe mara ina tà Davita. ");
INSERT INTO priNT_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","«Â âjupâra, ba é wii mwara wà Davita, naa na jè ére pâ: Gà jèe pitòrigario ma go pwi ênawéna'gà. O câgà caa panuâ nyuâaô ma é tâa na aubà. O câgà caa panuâ naiio ma o wai ma botére. Psaume 16.10 ");
INSERT INTO priNT_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","«Wà ukai Davita, âna é nye tà piênawéna kà Pwiduée, tiagoro ê pai bà kêe, â é pacoo ê câbawâdé kà Pwiduée. Êco na é bà, â pwàniriê pwacèwii diri tèpa caa kêe, â é jèe wai ma botére naa na auipwàni. ");
INSERT INTO priNT_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Êco na wà pwina é jèe pawâroé wà Pwiduée, âna câé caa wai ma botére.» ");
INSERT INTO priNT_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","39","«Wâdé na guwà tâmogòori bwàti, co tèpa jènereô, pâ, bà picémara tàwà nabà ê pai pwanauri èpà naa na nee Iésu. Â nye gée gooé kaa, na tòpò pinaanapô naa nabibiu kâjè ma wà Pwiduée, ba na jè tèpa âboro na jè tàrù na araé. Ba càcaa pâri, ê Naèà kà Moosé ma pwanauri ê èpà, ma nama jè tàrù. ");
INSERT INTO priNT_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Â guwà pwacôoco, ba péa tà tèepaa mariwà ê pwina rà jèe ina tèpa péroféta: ");
INSERT INTO priNT_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","Guwà pwacôowà, wâguwà tèpa ipwamainawà! Go mwa papòwà, â guwà jèpa ipiina! Go o mwa pwa wakè kôo na guwà bwaa wâro; wakè na muugère ma dau maina awé. Â wiàna wiâ tàwà, â câguwà caa wâari.» Habakuk 1.5 ");
INSERT INTO priNT_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","43","Â ûna é ina diri pwiri wà Paulo, â jèe nabwé ê ipitiri, â ru còobé ma Barnabas gée na i wâra pitapitiri. Â rà ilari jiiru wà tèpa âboro pâ, na ru mwa tòpò cè gòobàra ê popai kàru, na ê tòotù pwicîri noowê. Â wâru tàpé na rà pâra wiâru—wà tèpa Juif, ma tàpé na rà biirà naa goro ê pwapwicîri kà tèpa Juif. Â rà ipwa jèkutâ naima, â ru pagòorà ba na rà cimwü naa na *pimeaari imudi kà Pwiduée. ");
INSERT INTO priNT_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Na pwi tòotù pwicîri pâ côwâ, âna ipiti êdiri tèpa âboro na ville Antioche wâ Pisidie, ba na rà têre ê popai kà Pwi Ukai. ");
INSERT INTO priNT_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Ûna rà côo pwiri wà tèpa pitûâ kà tèpa Juif, â rà iboo goo wà Paulo, â rà tobapwâê ma inaê ba èpà. ");
INSERT INTO priNT_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Êco na ru ina ba gòo tàra wà Paulo ma Barnabas pâ: «Bu mara me mariwà ba wâguwà tàpé na, na guwà mara têre ê popai kà Pwiduée. Ûna guwà tüma, êkaa na, bu o biibu dà tàpé na càra caa tèpa Juif. Ba munaa càcaa kàwà ê *wâro dàra gòiri jaa Pwiduée?! ");
INSERT INTO priNT_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Ba wàéni ê pwina é jèe ina tâbà wà Pwi Ukai pâ: Go tòpògà ma cùrugà. Gà mwa pwéelaa kâra pâ Ba. Ina târa gòropuu: “É jèe me wà Pwi Ukai; me nau pa-udòwà!”» Ésaïe 49.6 ");
INSERT INTO priNT_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Ûna rà têre pwiri wà tàpé na càra caa tèpa Juif, â rà dau ipwàdée. Â rà ina pâ: «Nye dau wâdé kaa ê popai kà Pwi Ukai!» Â rà cèikî wà tàpé na é jèe pitòrigarirà wà Pwiduée, ba na tà tàra ê wâro dàra gòiri jaaé. ");
INSERT INTO priNT_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Â napwa naa goo ê popai kà Pwi Ukai, âna é pâpitiri napô. ");
INSERT INTO priNT_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Êco na wà tèpa cicara Paulo ma Barnabas, âna rà pinaa ârapûru wà tèpa âboro, ba na rà tubaèpà tàru ma pacòobéru. Wàilà âna tèpa ijiao kâra napô, ma pàra ilàri na wâdé tàra ê pwapwicîri kà tèpa Juif, â na pi-inarà ba wâdé na pwi napô-bà. Â rà pacòobéru gée napô kàra. ");
INSERT INTO priNT_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Â ru tauri ê dàuru puu goro âru, â ru pâra naa na ville Iconium. ");
INSERT INTO priNT_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Â wà tèpa cèikî na rà tâa Antioche, âna dipitirirà ê Nyuâaê Pwicîri, â é nama rà dau ipwàdée. ");
INSERT INTO priNT_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Ipaiwà ê pwina tèepaa na Iconium ma wâ Antioche. Ba ru too wà Paulo ma Barnabas naa na *wâra pitapitiri kà tèpa *Juif; â ru picémara ê popai kà Pwiduée; â wâru tèpa âboro na rà cèikî—wà tèpa Juif, ma wà tàpé na càra caa tèpa Juif mwara. ");
INSERT INTO priNT_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Napwa naa goo wà pàra tèpa Juif, âna tàutàra dàra cèikî naa goo ê popai na ru ina; â rà pitoo naa na pûru wà pàra tèpa tâa wê, ba na rà putàmu naa goo wà Paulo ma Barnabas. ");
INSERT INTO priNT_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Êco na càru caa pò ma pâra, â ru bwaa nye tàpo tâa wê. Â càru caa piwâ na ru picémara ê *pimeaari imudi kà Pwi Ukai, ba tupédu a cèikî naa gooé. Â é *paâjupâra ê pâ popai na ru ina wà Pwiduée, na é nama ru pwa ê pâ *câmu kâra pàtàmee na rà pò goo wà tèpa âboro. ");
INSERT INTO priNT_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Â rà pitadàrùrà wà tèpa âboro na napô bèepwiri. Ba ê jè ére gée goorà, âna é pâra wiâ tèpa caa kà tèpa Juif; â jè ére, âna é pâra wiâ wà tupédu *apostolo. ");
INSERT INTO priNT_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Pwa mwara pàra tàpé na càra caa tèpa Juif na rà cicara Paulo ma Barnabas. Â rà pitêrerà ma wà tèpa Juif, ma wà tèpa caa kàra, ba na rà catàmwararu goro atü. ");
INSERT INTO priNT_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Êco na, ûna ru tâmogòori pwiri, â ru uru pâ naa napô Lycaonie—naa na du ville Lystre, ma Derbe, ma ê pâ na ére goro jènereru. ");
INSERT INTO priNT_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Â ru picémara naawê ê *Picémara Wâdé. ");
INSERT INTO priNT_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Na pàara bèepwiri, âna é tâa Lystre ê pwi a pitàbwamwa. Gée na aukîri kêe, âna càcaa pâri ma é cimadò ma é pâra. ");
INSERT INTO priNT_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Â, na jè tòotù, âna é tàmaari wà Paulo na é gére picémara ê popai. Â é nye po ucâriê kaa wà Paulo, ba é côo pâ é cèikî wà pwiibà pâ o mwa wâdé du âê. ");
INSERT INTO priNT_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Â é dau tùra too wà Paulo, â é ina têe pâ: «Gà cimadò, â gà citàrù!» Â é nye êgò kaa, â é too na citàrù, â é pâra! ");
INSERT INTO priNT_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Wâru ê pâ âboro gée Lycaonie na rà côo pwiri, â rà uu burà ina naa na pwâratùra kàra pâ: «É! Wà tèpa duée kâjè, âna rà jèe pipwârürà naa goo tèpa âboro, â rà boome darijè!» ");
INSERT INTO priNT_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Â rà naa tàru ê nee tèpa duée kàra. Ba rà ina goo Barnabas pâ Zeus, nee pwi ukai kà tèpa duée; â wà Paulo pâ Hermès ba nye wàé na é pwi a pame ê popai. ");
INSERT INTO priNT_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Pwa ê wâra pwapwicîri kà Zeus, âna é wâni na jè tapoo tò naa na ville. Â wà pwi a pwa ârapwaailò kêe, âna é pame ê pâ paaci bau pâ buké, â é tòpò boo naa goro ê pâ goropwârawâ. Ba nümarà ma wà tèpa âboro na rà pwa *ârapwaailò tà tupédu apostolo. ");
INSERT INTO priNT_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Êco na, ûna ru têre pwiri, â dau càcaa wâdé tàru, â ru tidàpa ê ârabwée kàru. Â ru itàa pâ naa nabibiu kâra pâ âboro, â ru tomara too pâ: ");
INSERT INTO priNT_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","«Bwa! Tèpa béebu, dà na guwà pwa? Wàibu, âna bu nye tupédu âboro pwacèwiiwà! Â bu me nau picémara tàwà ê Picémara Wâdé. Wâdé na guwà panuâ ê pâ duée kàwà na ticèmuru naa goorà. Guwà biiwà naa goo wà Pwiduée na é wâro. Ba wàé na é pwa ê napwéretòotù ma gòropuu ma nawià, ma diri ê pâ namuru na wâna. ");
INSERT INTO priNT_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","«Â wà pwi Pwiduée-bà, naa na pâ pàara biu, âna é panuâ ê pâ Ba, ma rà pwa ê pâ câbawâdé kàra. ");
INSERT INTO priNT_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Êco na é mu nye tà paari tâjè ê pimeaari kêe, na é pwa ê pâ muru na wâdé ba kâjè. Ba é naa tâjè ê popaa me gée napwéretòotù, ma ê pàara na piûnya na. Â wàé na é naa tâjè ê pâ utimuru na dau wâru, â é naa mwara ma jè dau ipwàdée.» ");
INSERT INTO priNT_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Â ru jèe nye ina tàra ê pâ popai bèepwiri wà Paulo ma Barnabas, êco na ru bwaa nye tàpo paa goro ticia jiirà pâ, na rà cibwaa pwa ârapwaailò tàru. ");
INSERT INTO priNT_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Êco na rà tèepaa me naawê wà tèpa Juif na ia rà cicara Paulo ma Barnabas naa Antioche ma Iconium. Â rà too naa na pûru wà pàra tèpa âboro, ba na rà catàmwara Paulo. Â rà dau èié goro atü, â rà bèerié còobé gée na napô, ba rà tà niimiri pâ é jèe bà. ");
INSERT INTO priNT_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Êco na rà cibèepié wà tèpa cèikî, â é cimadò â é tò naa na ville. Na pwi tòotù gée paé côwâ, â ru pâra ma Barnabas naa na ville Derbe. ");
INSERT INTO priNT_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Géewê, âna ru picémara ê Picémara Wâdé na Derbe, wà Paulo ma Barnabas. Â wâru tèpa âboro na rà cèikî. Â ru wâjué me côwâ naa Lystre, ma Iconium, ma Antioche wâ Pisidie. ");
INSERT INTO priNT_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Ru pagòo tèpa cèikî, ba na rà cimwü naa na cèikî kàra naa goo wà Pwi Ukai. Â ru ina tàra pâ: «Jè wâro na ê pâ picâri, na jè pâra wii ê naigé pâ naa na ê *Mwaciri kà Pwiduée.» ");
INSERT INTO priNT_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Ru pitòrigari wà pàra tèpa âboro, ba na rà tèpa pitûâ naa na jèpa wâra pwapwicîri. Â ru ipwanya—ru panuâ ê ija na jè pàara, ba na ru pwapwicîri kàra bwàti. ");
INSERT INTO priNT_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Â nabwé, â ru picijiirà â ru tapàgà boo Pisidie, â ru tèepaa naa na province Pamphylie. ");
INSERT INTO priNT_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Â ru picémara ê popai kà Pwiduée naa na du ville wê—naa Perge, ma Attalie. ");
INSERT INTO priNT_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Géewê, â ru pa wànga ba na ru wâjué côwâ naa Antioche wâ Syrie. Ba nye wà tèpa cèikî na pwi ére-bà, na ia rà panuâru na aranara ê pimeaari imudi kà Pwiduée, târa pwi wakè na ru gére tubamwara. ");
INSERT INTO priNT_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Ûna ru tèepaa pâ, â ru panaimari tèpa cèikî. Â ru piwiâ tàra diri ê pâ namuru na é nama ru pwa wà Pwiduée. Â ru piwiâ mwara ê pai tàpiri ê goropwârawâ tà tàpé na càra caa tèpa Juif, ma rà cèikî. ");
INSERT INTO priNT_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Â bwaa tàpo gòiriru goro tâa wê. ");
INSERT INTO priNT_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Pwa pàra tèpa âboro, na rà me gée napô *Judée, na rà pacâmuri tèpa cèikî pâ: «Wiàna câguwà caa pipwa *kamaî tàwà wiâra ê *Naèà kà Moosé, â o câguwà caa udò.» ");
INSERT INTO priNT_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Êco na wà Paulo ma Barna-bas, âna ru dau pitakàna ma wàilà goro ê pwi auniimiri-bà. Â rà pâ nau pitêrerà pâ, wâdé na rà too naa *Iérusaléma, wàilu ma wà pàra tàpé gée goorà, ba na rà o pitùra wà tèpa *apostolo ma wà tèpa pitûâ kâra wâra pwapwicîri, goo ê pwi auinapopai bèepwiri. ");
INSERT INTO priNT_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Â êkaa, na é panuârà pâ ê wâra pwapwicîri. Â rà pâra wà tàpéeni, â rà tapàgà du ére napô Phénicie ma *Samaria. Â rà piwiâ tà tèpa cèikî wê ê pai cèikî kà tàpé na càra caa tèpa *Juif. Â rà dau ipwàdée goo, wà tàpé na rà têre ê pwi jèkutâ-bà. ");
INSERT INTO priNT_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Ûna rà tèepaa pâ naa Iérusaléma wà Paulo ma Barnabas ma wà tèpa béeru, â é tòpirà ê wâra pwapwicîri—êdiri wà tèpa cèikî ma tèpa apostolo ma tèpa pitûâ kâra wâra pwapwicîri. Â rà piwiâ tàra diri ê pâ muru na é nama rà pwa wà Pwiduée. ");
INSERT INTO priNT_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Êco na rà wâjaarà wà pàra tèpa *Farasaio na rà jèe cèikî naa goo wà Iésu. Â rà cimadò, â rà ina tàra pâ: «Wâdé na rà pwa kamaî tà tèpa cèikî na càra caa tèpa Juif, â wâdé na rà pâra wiâ bwàti ê Naèà kà Moosé.» ");
INSERT INTO priNT_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Rà ipitiri wà tèpa apostolo ma tèpa pitûâ, ba na rà pitùra goo ê popai bèepwiri. ");
INSERT INTO priNT_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Rà dau pièi popai goo, â jè pàara, â é cimadò wà Pétéru â é ina tàra pâ: «Bwa; tèpa cèikî béeò, guwà tâmogòori pâ, jèe gòiri na é pitòrigario wà Pwiduée gée nabibiu kàwà, ba na go picémara ê popai tà tàpé na càra caa tèpa Juif. Ba nümee na rà têre ê popai goro wâro, â na rà o cèikî naa goo. ");
INSERT INTO priNT_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Wà Pwiduée, âna é tâmogòori ê pwâranüma tèpa âboro. Â é naa tàra mwara ê Nyuâaê Pwicîri pwacèwii naa goojè. É nye tàgére paari tâjè pâ, é nye tòpirà mwara. ");
INSERT INTO priNT_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Câé caa ipwaké goojè ma wàilà. É cèitiri ê èpà kàra, â é nama wâdé ê pwâranümarà na araé, ba rà cèikî naa gooé. ");
INSERT INTO priNT_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","«Â nabàni, âna guwà bwaa gére bumuru goo Pwiduée? Gorodà na guwà tòpò naa gò tèpa cèikî ê jè nakake, na càcaa pâri ma rà kakeri wà tèpa jojoorojè, ma wàijè mwara? ");
INSERT INTO priNT_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Bwa! Jè cèikî pâ, jè udò gée goo ê *pimeaari imudi kà Pwi Ukai Iésu, ipaiwàijè ma wàilà.» ");
INSERT INTO priNT_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Â po tèepaa me ê tànana naa na i ipitiri. Â rà tàmaari wà Barnabas ma wà Paulo, na ru piwiâ tàra ê pâ *câmu kâra pàtàma Pwiduée, na é nama ru pwa, naa nabibiu kà tàpé na càra caa tèpa Juif. ");
INSERT INTO priNT_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Ûna ru jèe tùra diri, â é tùra wà Jacques, â é ina pâ: «Bwa; tèpa cèikî béeò, guwà tàmaariô. ");
INSERT INTO priNT_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","É piwiâ wà Simona Pétéru ê pai tapoo pitòrigari kà Pwiduée cè Ba kêe, gée nabibiu kà tàpé na càra caa tèpa Juif, ba na é pwi Ba kêe. ");
INSERT INTO priNT_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Ba jèe pwacèwii ê pwina é ina wà Pwiduée, na rà naigé mee wà tèpa *péroféta kêe. Ba jèe wii pâ: ");
INSERT INTO priNT_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","Gée na càùru pwiri, â go o mwa me côwâ. Go o mwa bari côwâ pwârawâ kà *Davita, pwâra ukai na jèe tûu. Go mwa pacimadò côwâ. ");
INSERT INTO priNT_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Rà o mwa mudòo tèpa âboro diri; pâmariô pâ Ba, tàpé na go todàra, ba na o pwi Ba kôo. ");
INSERT INTO priNT_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Wàépwiri popai kôo, wâgo Pwi Ukai. Go jèe tàmara ina; pacoo gée na biu.» Amos 9.11–12 ");
INSERT INTO priNT_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","É ina mwara wà Jacques pâ: «Go niimiri pâ, na cibwaa naa mwara cè jè nakake kà tàpé na càra caa tèpa Juif na rà jèe cèikî naa goo wà Pwiduée. ");
INSERT INTO priNT_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Wâdé na jè pwa tii pâdarirà ma jè ina tàra pâ, na rà cibwaa uti ê pâ macii na pwa *ârapwaailò goo târa pâ ânuuru duée. Â rà cibwaa ipuu imudi. Â rà cibwaa uti ê domii, ma uti ê pâ macii na dàûru nyarà (ba jèe càcaa còobé ê domii kàra). ");
INSERT INTO priNT_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Diri ê pâ pwiibà, âna rà tâmogòori ba jèe gòiri na picémara ê Naèà kà Moosé, naa na pâ napô. Â wà tèpa Juif, âna rà pûra i Naèà naa na ê pâ *wâra pitapitiri, diri ê pâ *tòotù pwicîri.» ");
INSERT INTO priNT_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Wà tèpa apostolo, ma wà tèpa pitûâ, ma diri ê wâra pwapwicîri, âna rà pitêrerà ma rà wii tà tèpa cèikî naa Antioche. Â rà pitòrigari wà Silas, ma wà Jude, na ina gooé pâ Barsabbas—tupédu âboro na rà cèikî naa gooru—ba na ru pâra wiâ Paulo ma Barnabas ma popa pâ i tii. ");
INSERT INTO priNT_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Wàéni ê pwina rà wii: Bwàcu kàwà co tèpa cèikî wâ Antioche, ma Syrie, ma Cilicie! Wàibà—wà tèpa apostolo ma tèpa pitûâ—na wii ê tii bèeni. Câguwà caa tèpa Juif, êco na guwà cèikî naa goo wà Kériso, êkaa na guwà tèpa aéjii kâbà naa na nee. ");
INSERT INTO priNT_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Bà têre pâ, pwa pàra tàpé na rà pâra gée jaabà, â rà paé nau tuba-imwüruwà goro ê pâ popai kàra, â rà jèe nama gù ê pwâranümawà. Êco na càcaa wàibà na naa tàrù tàra. ");
INSERT INTO priNT_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Êkaa na bà pitapitiri, â bà niimiri pâ, wâdé na bà pitòrigari cè tupédu âboro gée jaabà, ma bà panuâru paé dariwà. Â ru paé wiâ tupédu a cèikî béebà, tupé na dau wânümabà gooru, wà Paulo ma Barnabas. ");
INSERT INTO priNT_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Ba ru panuâ wâro kàru, naa na nee Pwi Ukai Iésu Kériso. ");
INSERT INTO priNT_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Bà naa paé wà Jude ma Silas, ba na ru mwa po ina tàwà goro pwâru ma napéaati ê pwina wii naa na tii bèeni. ");
INSERT INTO priNT_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Ba bà pitêrebà, wàibà ma ê Nyuâaê Pwicîri, pâ, càcaa wâdé na bà tòpò côwâ naa gòwà cè nakake. Êco na wàéni ê pwina âjimuru: ");
INSERT INTO priNT_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Guwà cibwaa uti ê pâ macii na pwa *ârapwaailò goo târa ê pâ ânuuru duée; Guwà cibwaa uti ê domii, ma ê pâ macii na dàûru nyarà (ba jèe càcaa còobé ê domii kàra); Guwà cibwaa ipuu imudi. Ê pâ namuru bèepwiri, âna wâdé na guwà nabwé jii. Topai tàwà. ");
INSERT INTO priNT_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Êkaa na rà pâra naa Antioche wà Paulo, Barnabas, Jude ma Silas. Â rà papitiri diri tèpa cèikî, ba na rà naa tàra i tii. ");
INSERT INTO priNT_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Ûna rà pûra i tii wà tèpa cèikî, â nye dau piwâdé nümarà kaa. ");
INSERT INTO priNT_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Napwa naa goo wà Jude ma Silas, âna ru tupédu péroféta, â tàpo gòriru jaarà. Â ru pame ê popai kà Pwiduée tà tèpa cèikî, â ru dau pagòorà. ");
INSERT INTO priNT_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Gée na càùru ê jè pàara, â rà picijiiru wà tèpa cèikî wâ Antioche, ba na ru wâjué côwâ dari tàpé na rà naaru me. { ");
INSERT INTO priNT_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Êco na é niimiri wà Silas pâ wâdé na é bwaa tà tâa.} ");
INSERT INTO priNT_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Wà Paulo ma Barnabas, âna ru nye tà tâa Antioche. Â rà pacâmuri tèpa âboro ma inapàpari ê popai kà Pwi Ukai, wàilu ma pâ âboro na wâru. ");
INSERT INTO priNT_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Gée na càùru ê jè pàara, â é ina wà Paulo tà Barnabas, pâ: «Ju wâjué côwâ naa na ê pâ napô na ia ju picémara pâ wê ê popai kà Pwi Ukai. Wâdé na ju cai tèpa cèikî na rà jèpa wâna, ba na ju côo pâ, pwiri rà gére wànau.» ");
INSERT INTO priNT_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Nüma wà Barnabas na é popa mwara wà Ioane-Maréko. ");
INSERT INTO priNT_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Êco na tàu tà wà Paulo, ba é nye pwa-itépâra jiiru wà pwiibà, tapoo gée na province Pamphylie. Â câé caa pitu tàru tiagoro ê pwâadàra wakè kàru. ");
INSERT INTO priNT_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Ru dau pitùra, â ru iputàmu, tiagoro na ru ipiina. Â é popa Ioane-Maréko wà Barnabas, â ru pâra gòro wànga naa gòropô Chypre. ");
INSERT INTO priNT_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Napwa naa goo wà Paulo, âna é popa Silas. Â wà tèpa cèikî, âna rà panuâru, na aranara ê pimeaari imudi kà Pwi Ukai, â ru pâra. ");
INSERT INTO priNT_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Â ru tapàgà ê du province Syrie ma Cilicie, â ru pagòo pâ ê pâ wâra pwapwicîri. ");
INSERT INTO priNT_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","É pâra wà Paulo géewê naa Derbe, ma naa Lystre (du ârailu ville). Naa Lystre, âna é pâmari pwi a cèikî na nee Timotéo, pwi naîri tô ilàri Juive, na tô a cèikî naa goo wà Iésu. Â napwa naa goo wà caa kêe, âna câé caa pwi *Juif. ");
INSERT INTO priNT_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Wà tèpa cèikî gée na du ville Lystre ma Iconium, âna rà ina pâ, é dau pwi âboro wâdé wà Timotéo. ");
INSERT INTO priNT_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Â é todèe wà Paulo, ba na é pâra wiâê. É mara pwa *kamaî têe, ba naa wâdé tà tèpa Juif na rà tâa na ére bèepwiri. Ba rà nye tâmogòori diri pâ, wà caa kêe, âna câé caa pwi Juif. ");
INSERT INTO priNT_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Na pâ napô na rà pâ naa, âna ru ina tà tèpa cèikî, wà Paulo ma Silas, na rà pâra wiâra bwàti ê pâ aupitûâri kà tèpa *apostolo ma tèpa pitûâ gée *Iérusaléma. ");
INSERT INTO priNT_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Wà tèpa âboro kà Pwiduée, âna rà pimaina too naa na cèikî, â é pitoo mwara ê jéûrà diri na pâ tòotù. ");
INSERT INTO priNT_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Ê Nyuâaê Pwicîri, âna é côwâri wà Paulo ma Silas, na ru pwa na ru picémara ê popai kà Pwiduée naa na province Asia. Â rà tapàgà pwi ére naa nadàpàra Phrygie ma Galatia ma wà tèpa béeru. ");
INSERT INTO priNT_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Ûna rà tèepaa pâ naa gòobàra napô Mysie, â rà pwa na rà too naa na province Bithynie, êco na câé caa tàpiri tàra ê Nyuâaê Pwicîri kà Iésu. ");
INSERT INTO priNT_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Êkaa na rà tapàgà Mysie, â rà tèepaa boo naa Troas, pwi aucoo kâra wànga. ");
INSERT INTO priNT_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Ûna ne, â wà Paulo, âna é côo naa na nyuâa, pwi âboro gée na province Macédoine, na é coo, â é gére tacoo gooé burà ina têe pâ: «Gà me naa Macédoine nau pitu tâbà.» ");
INSERT INTO priNT_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Gée na càùru pwina paari têe, â bà mudàra ma bà piwàcî pâ naa Macédoine, ba bà jèe tâmogòori pâ, wà Pwi Ukai na é todàbà ba na bà picémara ê *Picémara Wâdé naawê. ");
INSERT INTO priNT_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Bà tò naa gòro wànga na Troas, â bà itàa dàra ê pô Samothrace. Â, na dàuru kêe, â bà êgò boo naa Néapolis, pwi aucoo kâra wànga. ");
INSERT INTO priNT_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Géewê, â bà pâra naa Filipi, pwi ville gée na province Macédoine (pwi colonie kà tèpa *Roma). Bwaa tàpo pwa tòotù kâbà naa na pwi napô bèepwiri. ");
INSERT INTO priNT_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Na *tòotù pwicîri, â bà còobé jii ê napô, â bà pâra naa bàra nairiwâ, ba bà niimiri pâ tâa wê, cè ére cèna rà mu pwapwicîri wê wà tèpa Juif. Bà tâaboo, â bà patùra pa ilàri na rà gére pitapitirirà naawê. ");
INSERT INTO priNT_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Wà tô jèpwi, na nee Lydie, tô âboro gée na ville Thyatire, âna tô a pi-icu imwaano mii, na dau maina ê wâri wèe. Câé caa tô Juive, êco na wâdé têe ê pwapwicîri kà tèpa Juif. Â é tàmaari bwàti ê popai kâbà. Â é tàpiri ê pwâranümee wà Pwi Ukai. ");
INSERT INTO priNT_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Â *upwaaé bau ê tèpa âboro na rà tâa pwârawâ kêe. Â gée na càùé, â é ina tâbà pâ: «Wiàna guwà câbaâjupâra pâ, go âji cèikî naa goo Pwi Ukai, â guwà me wiâô naa pwârawâ kôo.» Â é tacoo goobà, ba na bà pâra wiâê. ");
INSERT INTO priNT_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Na jè tòotù, na bà gére pâra naa na aupwapwicîri, â é me carabà tô jè ilàri na pwa duée gooé. Wà pwi duée-bà, âna é cètùué nau ina tà tèpa âboro ê pâ namuru na o mwa tèepaa. Â dau wâru mwani na rà tòpi gée goo ê pâ pwina é ina wà tàpé na é piwakè kàra. ");
INSERT INTO priNT_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Â é me wiâbà, na wàibà ma Paulo, â é tomara pâ: «Wà tèpa âboro bèeni, âna tèpa ênawéna kà Pwiduée na é tâjaijè, â rà picémara tàwà ê pai udò kâjè naa na *âji wâro.» ");
INSERT INTO priNT_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","É nye tà wàrapwiri diri na pâ tòotù, â jèe tubagùra nüma wà Paulo. Â é nye tabiié kaa, â é ina târa i duée pâ: «Gà còobé gée goo tô ilàri bèeni naa na nee Iésu Kériso!» Â é nye còobé kaa gée gooé. ");
INSERT INTO priNT_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Ûna rà côo wà tèpa pitûâ kêe pâ, jèe tiàu ê opamwani kàra, â rà nye tâjùru kaa wà Paulo ma wà Silas, â rà dàtiru boo naa na aupitèimuru, na ara tèpa pitûâ kâra napô. ");
INSERT INTO priNT_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Rà paariru tà tèpa pitèimuru kà tèpa Roma, â rà ina tàra pâ: «Wà tupédu âboro bèeni, âna ru tubagù ê napô. ");
INSERT INTO priNT_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Ba tupédu Juif, â ru gére picémara ê pâ tûâ na càcaa pâri ma jè tòpi ma wârori, wàijè tèpa Roma.» ");
INSERT INTO priNT_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Â rà nye putàmu kaa naa gooru wà tèpa âboro. Â wà tèpa pitèimuru, âna rà nama dàdàpa ê ârabwée kàru, â rà pwa ma pâdiru goro bàra upwâra. ");
INSERT INTO priNT_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Â rà tòpòru naa na wâra pwa karapuu, â rà ina tà pwi a wéaa pâ, na é wéaariru bwàti. ");
INSERT INTO priNT_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Êkaa na é tòpòru naa na pwi bénabwé naditàrawâ na wâra pwa karapuu, â é pwa ma dàgabia ê du âru naa na ê pâ upwâra. ");
INSERT INTO priNT_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Naa nabibiu kâra ne, âna wà Paulo ma Silas, âna ru nye tà pwapwicîri ma nyabi, â ru tòbuari Pwiduée. Â rà tàgére tàmaariru wà pàra tèpa pwa karapuu béeru. ");
INSERT INTO priNT_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Â nye tèepaa kaa ê pé gù napuu na dau maina, â é tébagù ê pâ pàara wâ wâna wâra pwa karapuu. Â rà cau tàpirirà diri ê pâ goropwârawâ, â tûu mwara ê pâ itùpaò na tòo diri tèpa pwa karapuu goo. ");
INSERT INTO priNT_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Ûna é pò tàcî wà pwi a wéaa, â nye dau dàpàgà têe kaa. Â é côo ê pâ goropwârawâ maina kâra na karapuu na tàpirirà, â é nye càù kaa ê tàuwa kêe, ba na é pitaé côwâ, ba é niimiri pâ rà jèe uru wà tèpa pwa karapuu. ");
INSERT INTO priNT_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Êco na é kànariê wà Paulo, â é ina têe pâ: «Pwiini, gà cibwaa pipwa tâgà cèna èpà, ba bà cau wâni diri!» ");
INSERT INTO priNT_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Â é nye ilari kaa cè ânye wà pwi a wéaa, ma wàcî dò naa na wâra pwa karapuu, â é tùu jùrué burà céca naa goro â wà Paulo ma Silas, goo ê pai wâgotêe. ");
INSERT INTO priNT_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","É pacòobéru, â é ina tàru pâ: «Tupédu ukai, dà cè pwina na go pwa ba na go o udò ba na o tâa tôo ê âji wâro.» ");
INSERT INTO priNT_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Â ru tòpi têe pâ: «Gà cèikî naa goo Pwi Ukai Iésu, â gà o udò, wâgà ma ê pwârawâ'gà.» ");
INSERT INTO priNT_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","34","Â é poparu wiâê, naa na pwârawâ kêe, na bwaa ne, â é nuwa aurumuru kàru, â é naa uti kàru. Â ru picémara tàra ma tèpa âboro na ê pwârawâ kêe, ê popai kà Pwi Ukai. Â rà cèikî naa goo, â ru *upwaarà. Â rà dau ipwàdée. ");
INSERT INTO priNT_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Ûna pwaa, â rà cùru tèpa pipa popai wà tèpa pitûâ kàra, ba na rà ina tà pwi a wéaa pâ, na é panuâru. ");
INSERT INTO priNT_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Â é ina tà Paulo pwiibà pâ: «Wà tèpa pitûâ, âna rà panuâ popai me, pâ, o jèe panuâu, â gàu pâra na ê pitàbwàti.» ");
INSERT INTO priNT_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Â é ina wà Paulo tà tèpa pipa popai pâ: «Tàpéeni, wàibu, âna bu tupédu Roma. Êco na rà pitèibu wà tèpa pitûâ kàwà, â rà nama pâdibu, na ara ê pâ âboro diri, â rà tübu naa na karapuu! Â gona pwa na rà pacòobébu ni pwàniri? Bwa! O càcaa wàrapwiri! Wâdé na rà nye me wàilà ma rà panuâbu.» ");
INSERT INTO priNT_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Rà pawâjué ê pai ina kà Paulo wà tèpa pipa popai, â dau wâgo tà tèpa pitèimuru na rà têre pâ ru tupédu Roma. ");
INSERT INTO priNT_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Â rà me nau picigòboo tàru. Â rà pacòobéru, â rà tacoo gooru pâ, na ru pâra gée na napô. ");
INSERT INTO priNT_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Ru pâra wà Paulo ma Silas, â ru too dari Lydie. Gée na càùru ê pai côo tèpa cèikî, â ru pagòorà, â ru pâra. ");
INSERT INTO priNT_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Ru pâ naa du ville Amphipolis ma Apollonie wà Paulo ma Silas, â ru tèepaa naa Tésalonika, wâna tâa wê pwi jè *wâra pitapitiri kà tèpa *Juif. ");
INSERT INTO priNT_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Â é tò naa na wâra pitapitiri wà Paulo, wiâra ê nye pai pwa kêe. Â âracié tòotù pwicîri na é pwa pupûra goo ê popai na é pa gée na *Tii Pwicîri. ");
INSERT INTO priNT_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","É paari tàra diri pâ auinapopai goo pwi *Mesia, *pwi a pa-udò na rà tapacîê. Ba wii pâ, ée mwa maagé côo, â ée mwa bà. Êco na ée mwa wâro côwâ gée na aubà. Â é ina tàra wà Paulo pâ: «Guwà côo, wà pwi Iésu na go picémaraê tàwà, âna wàé kaa pwi Mesia.» ");
INSERT INTO priNT_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Wà pàra tàpé gée goorà, âna rà cèikî, â rà pâra wiâ Paulo ma Silas. Dau wâru tàpé gée goo tèpa *Grec na rà pâra wiâru—tàpé na wâdé tàra ê pwapwicîri kà tèpa Juif—wàrapwiri mwara gée jaa ê pa ilàri imaina. ");
INSERT INTO priNT_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Êco na rà dau iboo wà pàra tèpa Juif, â rà todà tèpa âboro na nye ticè na wâdé naa goorà, ma rà pinaa ârapûru tèpa âboro na ville, ba na rà putàmu naa gooru. Â rà itàa pâ nau mudàru naa na pwârawâ kà pwi âboro na nee Jason, ba na rà poparu pâ naaniboo gòro naigé, na ara diri ê pâ âboro, ba na pitèiru. ");
INSERT INTO priNT_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","7","Êco na càra caa pâmariru, â rà dàti pâ wà Jason ma pàra tèpa cèikî naa jaa tèpa pitûâ kâra napô, â rà tomara pâ: «Wà pwini, âna é tòpi tupédu âboro èpà, wà Paulo ma Silas, na ru tubagù ê gòropuu diri, â nabàni, âna ru tèepaa naani! Wà tàpéeni ma wà tèpa béerà, âna rà cicara ê naèà kà César, pwi ukai kà tèpa *Roma. Ba rà ina pâ, nye caapwi co ê pwi ukai, â wà pwiibà, âna wà Iésu.» ");
INSERT INTO priNT_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Ûna rà têre pwiri wà tèpa âboro ma wà tèpa pitûâ, â nye dau céepwâa tàra kaa. ");
INSERT INTO priNT_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Â rà mwa panuâ cawi wà Jason ma wà pàra tèpa bée, na rà wâri i wârimuru kàra. ");
INSERT INTO priNT_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Ûna ne, â wà tèpa cèikî, âna rà pitu tà Paulo ma Silas, ba na ru pâra pwàniri gée Tésalonika. Â ru pâra naa na ville Bérée. Ûna ru tèepaa pâ, â ru too naa na wâra pitapitiri kà tèpa Juif. ");
INSERT INTO priNT_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Wà tèpa Juif na tâa Bérée, âna rà dau wâdé jii tèpa Juif na rà tâa Tésalonika. Ba rà tòpi ê popai naa na ipwàdée. Â diri na pâ tòotù, âna rà côo bwàti ê Tii Pwicîri kàra, ba na rà côo pâ pwiri nye âjupâra kaa ê pâ popai na é ina tàra wà Paulo. ");
INSERT INTO priNT_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Wâru gée goorà na rà cèikî, â wâru mwara gée jaa tèpa Grec—pa ilàri imaina, ma tèpa paao. ");
INSERT INTO priNT_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Êco na rà têre wà tèpa Juif gée Tésalonika pâ, wà Paulo, âna é picémara ê popai kà Pwiduée mwara na Bérée. Â rà me nau naa ârapûru tèpa âboro wê, ba na rà putàmu naa gooé. ");
INSERT INTO priNT_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Êco na rà nye êgò kaa mwara wà tèpa cèikî, â rà popa Paulo naa na aucoo kâra wànga. Â napwa naa goo wà Silas ma Timotéo, âna ru bwaa nye tà tâa Bérée. ");
INSERT INTO priNT_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Wà tàpé na rà picia wà Paulo, âna rà ciaé tia na ville Athènes. Â é cùrurà côwâ naa Bérée, ba na rà ina tà wà Silas ma wà Timotéo pâ, na ru piawài goro medarié. ");
INSERT INTO priNT_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Wà Paulo, âna é bwaa tàpo cipacî Silas ma Timotéo wâ Athènes. Â é côo pâ wà tèpa âboro na pwi napô-bà, âna nye itémuru kaa ê pâ ânuuru duée na rà pwamaina. Â nye dau tòina kaa ê pwâranümee. ");
INSERT INTO priNT_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Â é pâra naa na wâra pitapitiri kà tèpa Juif, â é patùrarà, wàilà ma wà tàpé na wâdé tàra ê pwapwicîri kàra. Â diri na pâ tòotù, âna é patùra mwara wà tàpé na é pâdarirà naa na aupwa jèna. ");
INSERT INTO priNT_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Rà pitùra mwara ma wàé wà pàra tèpa pacâmuri âboro gée goo wà tàpé na ina goorà pâ, tèpa épicurien ma tèpa stoïcien. Wà pàra tàpé gée goorà, âna rà ina pâ: «Gona dà na é gére tòri ma uti tâjè wà pwi bèepwiri?» Â wà pàra tàpé mwara, âna rà ina pâ: «Wàra munaa é picémara cè pâ duée na nye ité.» Ba rà têre wà Paulo na é picémara wà Iésu ma ê pai wâro côwâ. ");
INSERT INTO priNT_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Â rà ciaé naa jaa ê wâratûâ kâra napô, na nee Aréopage, â rà ina têe pâ: «Nümabà na bà tâmogòori bwàti ê pâ namuru bèepwiri bwaa âmuê, na gà gére ina tâbà. ");
INSERT INTO priNT_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Ba gà pwa ma bà têre ê pâ muru na ité, â nümabà na bà tâmogòori ê pai ina wèe.» ");
INSERT INTO priNT_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","(Ba wà diri tèpa âboro géeni Athènes, ma wà tàpé na tèpa pârame na rà wâro wâni, âna rà nye tà tâa goo ê pâ jèkutâ na bwaa âmuê.) ");
INSERT INTO priNT_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Â é cimadò wà Paulo, â é ina pâ: «Bwa; tàpé Athènes, go côo pâ guwà tèpa dau tòimiri ê pâ duée. ");
INSERT INTO priNT_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Ba, na go gére tabéaa na ê ville kàwà, â go côo ê pâ auba na guwà pwamaina ma pwapwicîri naa goo. Â go pwa ma pâmari mwara ê pwi aupwa *ârapwaailò na wii naa goo pâ: Tà pwi jè duée na câjè caa tâmogòorié. «Guwà côo, wà Pwina guwà pwamainaê na câguwà caa tâmogòorié, âna wàé kaa, na go me nau picémaraê tàwà. ");
INSERT INTO priNT_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Wà Pwiduée na é pwa ê gòropuu, ma diri ê pâ namuru na tâa na, âna wàé Pwi Ukai kâra napwéretòotù ma ê gòropuu. Â câé caa tâa na ê pâ wâra pwapwicîri na rà bari wà tèpa âboro. ");
INSERT INTO priNT_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Â càcaa pâri ma jè pitu têe, wàijè tèpa âboro, pwacèwii na nümee goo cè jè muru jiijè! «Ba wàé na é naa tâjè diri ê wâro ma ôomaa, ma diri ê pâ namuru. ");
INSERT INTO priNT_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Â é pwa ma wà tèpa âboro diri, âna rà còobé gée goo ê pwi caapwi âboro, ba na rà wâro pitiri wâna ê gòropuu. Â é jèe nabwé tòpò tàra ê jèpa pàara na naja, ma ê pwâadàra ê jèpa napô. ");
INSERT INTO priNT_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","«É wàrapwiri ê pai tòpò kêe wà Pwiduée, ba na rà o mudèe wà tèpa âboro. Ba câé caa wâiti jiijè. Â wiàna rà mudèe imudi wà tèpa âboro, â péa rà nye tà pâmariê. ");
INSERT INTO priNT_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Ba jèe nabwé ina pâ: “Jè wâro gée gooé, â jè gù gée gooé, â jè tèpa âboro gée gooé.” Wàra na rà ina mwara pàra tèpa pwa tii kàwà pâ: “Jè tèpa naîê mwara.” ");
INSERT INTO priNT_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","«Gée goro na jè tèpa naîê, â jè cibwaa niimiri pâ wà Pwiduée, âna é pwacèwii ê duée na pwa goro atü, é, na pwa goro mwani mii ma mwani pwaa, wiâra ê auniimiri kà tèpa âboro! ");
INSERT INTO priNT_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Rà wàrapwiri wà tèpa âboro na jè pàara, êco na wà Pwiduée, âna é dau pidàpwicâariê goorà, ba ticè na rà tâmogòori. «Êco na nabàni, âna é tacoo goorà, ba na rà pinünüma, ba na o tòotéri ê wâro kàra. ");
INSERT INTO priNT_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Ba é jèe nabwé tòpò ê Tòotù na ée mwa pitèi diri ê pâ âboro naa gòropuu, â ê aupitèi kêe, âna o *tàrù. Ée mwa pinaigé mee ê pwi âboro, na é jèe nabwé pitòrigarié târa pwi tòotù-bà. Â é pawâroé côwâ gée na aubà, ba na é paari tâjè diri pâ wàé kaa pwiri, ê pwi a pitèimuru na ia é jèe pitòrigarié.» ");
INSERT INTO priNT_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Ûna rà têreê na é gére tùra goro ê wâro côwâ gée na aubà, â rà pitadàrùrà wà tèpa âboro-bà. Wà pàra tàpé, âna rà pitaurèe gooé; â wà pàra pwi, âna rà ina pâ: «Bà o mwa têregà côwâ goo pwiri, na cè jè tòotù.» ");
INSERT INTO priNT_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Â é còobé jiirà wà Paulo. ");
INSERT INTO priNT_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Êco na, pwa pàra tàpé mwara, na rà tâa gooé, â rà cèikî naa goo ê popai kêe. Wàrapwiri naa goo wà Denys, pwi jè a tâa na wâratûâ kà tàpé Athènes, ma tô jè ilàri na nee Damaris, ma pâ pàra âboro mwara. ");
INSERT INTO priNT_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","É pâra wà Paulo gée Athènes, naa na ville Korénito. ");
INSERT INTO priNT_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Â é pâmari naawê pwi jè *Juif na nee Aquilas, pwi âboro gée na province Pont, na ru bwaa tàgére tèepaa me gée Italie, ma wà Priscille, tô wâdèe. Ba wà Claude, pwi ukai kà tèpa *Roma, âna é jèe nabwé ina tà diri tèpa Juif pâ, na rà còobé gée Roma. Wà Paulo, âna é pâra nau cairu. ");
INSERT INTO priNT_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Â é pâra nau pitâa jaaru ma rà piwakè naima. Ba po caapwi bwàti ê wakè kàra—rà tèpa pwa wâ imwaano. ");
INSERT INTO priNT_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Â, diri pâ tòotù pwicîri, â é picémara ê popai wà Paulo, naa na ê pâ *wâra pitapitiri. Â é patùra tèpa Juif ma tèpa *Grec, â é mudàra ma rà cèikî naa goo ê popai na é ina. ");
INSERT INTO priNT_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Na ru mwa tèepaa me gée na province Macédoine wà Silas ma Timotéo, â wà Paulo, âna é nye po tâa goo kaa ê picémara ê popai. Â é ina tà tèpa Juif pâ: «Wà Iésu, âna nye wàé kaa pwi *Mesia, *pwi a pa-udò na guwà tapacîê gée na biu.» ");
INSERT INTO priNT_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Êco na rà cicaraé, â rà pi-inaê ba èpà. Â é tauri tétâjii ê dàuru puu gée goro ârabwée kêe wà Paulo, â é ina tàra pâ: «Wiàna tiàuwà jii ê wâro kà Pwiduée, âna mwa nye gée goowà, â câgo caa pwi majoroé. Nabàni, âna go pâra dari tàpé na càra caa tèpa Juif.» ");
INSERT INTO priNT_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Â é còpòo jiirà, â é pâra naa jaa pwi jèpwi na nee Titius Justus, pwi âboro na wâdé têe ê pwapwicîri kà tèpa Juif. Ê pwârawâ kêe, âna é tàpo wâmwünyabweri ê wâra pitapitiri. ");
INSERT INTO priNT_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Â wà Crispus, pwi ukai kâra wâra pitapitiri, âna é cèikî naa goo wà Pwi Ukai, cau wàilà diri mara ê pwârawâ kêe. Â wâru mwara tèpa Korénito na rà têre Paulo, â rà cèikî, â *upwaarà. ");
INSERT INTO priNT_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Naa jè ne, â é pipaarié naa na nyuâa wà Pwi Ukai tà Paulo, â é ina têe pâ: «Gà cibwaa pwa ma wâgotâgà, â gà cibwaa pwacimarù, â gà nye tà coo goo ê picémara ê popai kôo. ");
INSERT INTO priNT_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Ba go nye tà wâjaagà, â o nye ticè pwi jè âboro cèna é tâjùrugà, ma o pwa tâgà cèna èpà. Gà nye tà ina ê popai, ba wâru ê pâ âboro kôo na rà wâna ê ville bèepwiri.» ");
INSERT INTO priNT_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Â é tâa wê wà Paulo naa na caapwi naja, â 6 parui. Â é pacâmuri tàpé Korénito goro ê popai kà Pwiduée. ");
INSERT INTO priNT_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Na pàara na wà Gallion, âna pwi kupénoo naa na province Akaïe, â rà cau cinaima wà tèpa Juif, â rà tâjùru wà Paulo, â rà popaé pâ naa na aupitèimuru na ara pwi kupénoo. ");
INSERT INTO priNT_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Â rà ina têe pâ: «Wà pwi âboro bèeni, âna é tacoo goo tèpa âboro, ba na rà pwamaina wà Pwiduée, naa na pai pwa na pi-ité jii ê *Naèà kâra pwapwicîri kâbà.» ");
INSERT INTO priNT_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Bwaa câé caa pâji tùra wà Paulo, â é tòpi tàra wà Gallion pâ: «Tàpéeni, wiàna wà pwi âboro bèeni, âna é pòtàmwara âboro, é wiàna é gére pwa cè pwina dau èpà, â pwiri go gére tàmaariwà. ");
INSERT INTO priNT_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Êco na guwà pitòocia goro ê pâ popai, ma ê pâ neere âboro, ma ê naèà kàwà. Â êpwiri, âna nye pikàwà. Càcaa nümoo na go pwi a pitèi ê pâ namuru bèepwiri.» ");
INSERT INTO priNT_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Â é pwa ma tü tàra gée na ê aupitèimuru. ");
INSERT INTO priNT_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Â rà êgò, cau wàilà diri, â rà tâjùru wà Sostène, pwi ukai kâra wâra pitapitiri, â rà pièié na ara ê wâra pitèimuru. Êco na nye ticè na é côo naa goo wà Gallion. ");
INSERT INTO priNT_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Bwaa nye tàpo gòiri ê pai tâa kà Paulo wâ Korénito. Â géewê, â é picijii tèpa cèikî. Â é popa wiâê wà Priscille ma Aquilas, â rà pâra naa Cencrées. Rà tò naa gò jè wànga, pâ naa na province Syrie. Na é bwaa tâa Cencrées wà Paulo, â é pwa ê jè *ipwataâboro. Â é pwa ma pwârü diri ê pûruê, wiâra ê naèà kà tèpa Juif. ");
INSERT INTO priNT_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Nabwé, â rà pâra géewê gòro wànga. Â rà tèepaa naa na ville Éféso. Â é tò wà Paulo naa na wâra pitapitiri, â rà pitùra ma wà tèpa Juif. ");
INSERT INTO priNT_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Â rà ilari jiié pâ, na é bwaa tàpo tâa jaarà. ");
INSERT INTO priNT_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Â é ina tàra pâ: «Bwa, êco na, wiàna câbawâdé kà Pwiduée, â go o mwa wâjué côwâ medariwà.» Â é pâra jiirà. Â é còpòo gòro wànga gée Éféso, â ru jèe tà tâa wê wà Priscille ma Aquilas. ");
INSERT INTO priNT_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Ûna é ti wâ Césarée wà Paulo, â é too naa Iérusaléma nau pwabwàcu tà tèpa cèikî. Â nabwé, â é wâjué côwâ naa Antioche wâ Syrie na ia é tapoo i pâra kêe géewê. ");
INSERT INTO priNT_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Bwaa nye tàpo gòiri ê pai tâa kà Paulo wâ Antioche. Gée na càùé, â é pâra côwâ mwara. Â é pâra pitiri Galatia ma Phrygie, nau pagòo tèpa cèikî. ");
INSERT INTO priNT_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Na pàara bèepwiri, âna é me naa Éféso wà pwi jè Juif na nee Apollos, pwi âboro gée na ville Alexandrie. Wà pwiibà, âna pwi âboro na é tùra bwàti ma tâmogòori bwàti ê *Tii Pwicîri. ");
INSERT INTO priNT_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Â jèe pacâmuriê naa goo ê pai *pâra wiâ Pwi Ukai, â é pwi a tàcî. Â é picémara tà tèpa âboro ê *Picémara Wâdé kà Kériso. Â é pacâmurirà ma napéaati bwàti ê popai gooé. Êco na é nye tâmogòori co ê *piupwaa kà Ioane. ");
INSERT INTO priNT_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Â é tapoo tùra na ê wâra pitapitiri, â nye ticè na wâgotêe goo. Â ru têreê wà Aquilas ma Priscille, â ru popaé naa jaaru, â ru ina têe bwàti ê naigé kà Pwiduée. ");
INSERT INTO priNT_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Ûna nümee na é pâra naa Akaïe, â rà pagòoé wà tèpa cèikî, â rà pwa tii pâdari tèpa cèikî wê, ba na rà tòpié bwàti. Ûna é tèepaa pâ naawê, â é pwi jè bépitu na maina, ba kà tàpé na rà jèe cèikî gée goro ê *pimeaari imudi kà Pwiduée. ");
INSERT INTO priNT_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Â rà pitùra ma wà tèpa Juif na ara diri âboro, â po ticè na rà wà têe, ba é *paâjupâra tàra goro ê Tii Pwicîri pâ, wà Iésu âna wàé kaa pwi Mesia. ");
INSERT INTO priNT_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Na é bwaa tàgére tâa Korénito wà Apollos, â wà Paulo, âna é tapàgà pâ ê pâ ére na tâa gòrojaa, â é tèepaa naa Éféso. Â é pâmari naawê pàra tèpa cèikî, â é tawèerirà pâ: ");
INSERT INTO priNT_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","«Ûna na ia guwà cèikî, â é nye boome naa gòwà ê Nyuâaê Pwicîri?» «Câbà caa tâmogòori pâ pwa cè nyuâaê pwicîri!» ");
INSERT INTO priNT_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","«Âna dà *piupwaa cèna *upwaawà goo?» «Goo ê piupwaa kà Ioane.» ");
INSERT INTO priNT_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Â é ina tàra wà Paulo pâ: «Wà Ioane, âna é upwaa tàpé na rà pinünüma ma rà biirà naa goo wà Pwiduée. Â é ina tà tèpa *Juif pâ, na rà cèikî naa goo wà pwi âboro na ée mwa pwicò kêe—wà Iésu.» ");
INSERT INTO priNT_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Wà tèpa cèikî, âna rà nama upwaarà naa na nee Pwi Ukai Iésu. ");
INSERT INTO priNT_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Ûna é tòpò du îê naa gòrà wà Paulo, â é boome naa gòrà ê Nyuâaê Pwicîri, â rà tùra na pâ pwâratùra na ité, â rà inapàpari ê pâ popai na é naa tàra wà Pwiduée. ");
INSERT INTO priNT_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Wà tèpa âboro-bà, âna rà jèe wâpâ na 12 ma. ");
INSERT INTO priNT_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Géewê, â é ciburà too naa na *wâra pitapitiri wà Paulo naa na âracié parui. Â câé caa piwâ na é picémara ê popai goo ê *Mwaciri kà Pwiduée, â é dau mudàra ma rà cèikî wà tèpa âboro naa goo ê pwina é ina tàra. ");
INSERT INTO priNT_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Êco na wâru tàpé na rà pagòo pûrurà ma tàutàra na rà cèikî. Â rà pitaurèe goo ê pai *pâra wiâ Pwi Ukai, na ara diri ê pâ âboro. Â é pâra jiirà wà Paulo, â é popa tèpa cèikî, â é pacâmurirà diri na pâ tòotù, naa na ê jè wâra ipitiri kà Tyrannus. ");
INSERT INTO priNT_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","É piwàrapwiri ê pai pwa kêe wà Paulo naa na ârailu naja, êkaa na rà têre ê popai kà Pwi Ukai diri wà tàpé na rà tâa na province Asia—wà tèpa Juif ma wà tàpé na càra caa tèpa Juif mwara. ");
INSERT INTO priNT_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Wà Pwiduée, âna é pwa ma é pinaigé mee wà Paulo ê pâ câmu kâra pàtàmee na nye dau wâdé kaa, na rà pò goo wà tèpa âboro. ");
INSERT INTO priNT_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Â wà tèpa âboro, âna rà popa ê pâ ârabwée ma pâ noo kâra imwaano, ba na é tigée goo wà Paulo. Â rà popa pâdari tèpa maagé, â rà jèe nye wâdé kaa! Â wà tèpa duée, âna rà còobé, â rà pâra. ");
INSERT INTO priNT_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Pwa mwara pàra tèpa Juif, na rà nye tà pipâra wii napô, ba na rà tü còobé ê pâ duée gée goo ê pâ âboro. Â rà pimudàra ma rà pwa naa na nee Pwi Ukai Iésu. Â rà ina tàra pâ: «Naa na nee wà Pwi Ukai Iésu na é picémaraê wà Paulo, â guwà còobé!» ");
INSERT INTO priNT_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Wà tàpéebà, âna wà tèpa 7 naî Scéva, pwi jè caa kà tèpa pwa *ârapwaailò. ");
INSERT INTO priNT_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Êco na é tòpi tàra i pé duée pâ: «Go tâmogòori wà Iésu, â go tâmogòori mwara wà Paulo. Â gona wâguwà, âna guwà tèpa wàa?» ");
INSERT INTO priNT_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Â wà pwi âboro bèepwiri na tâa gooé i duée, âna é êgò gée paé, â é tâjùrurà, â é dau èirà. Â rà mwa uru pa ê aurumuru kàra gée pwârawâ kêe, âna rà jèe cicàpé! ");
INSERT INTO priNT_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Ûna rà tâmogòori ê jèkutâ bèepwiri wà tàpé Éféso—wà tèpa Juif ma wà tàpé na càra caa tèpa Juif mwara—â nye dau maina kaa ê pai wâgotàra, â rà cau papwicîri ê nee Pwi Ukai Iésu. ");
INSERT INTO priNT_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Wâru gée goo tàpé na rà jèe cèikî, na rà me nau inapàpari na ara diri ê âboro ê pâ muru na rà pwa pwàniri. ");
INSERT INTO priNT_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Ê jè auwâru goo tàpé na rà tèpa patùra pâ duée, âna rà pame ê pâ tii kàra, â rà cîri na ara ê pâ âboro. Â ê jéûru wâri wàra diri ê pâ tii bèepwiri, âna dau maina awé. Ba é tèepaa naa goro 50 000 mwani atü kàra. ");
INSERT INTO priNT_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Êkaa na é jèe pipâra pâ ê popai kà Pwi Ukai, â é pwa ma pimaina mwara ê pàtàmee. ");
INSERT INTO priNT_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Gée na càùru ê pâ muru bèepwiri, â é niimiri wà Paulo pâ, na é tapàgà pâ ê du province Macédoine ma Akaïe, ba na é pâra naa *Iérusaléma. Â é ina mwara pâ: «Wiàna go tèepaa pâ, â wâdé mwara na go pâ naa *Roma.» ");
INSERT INTO priNT_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Â é panuâ pâ béaa kêe naa Macédoine wà Timotéo ma Éraste, tupédu ârailu âboro gée goo tèpa pitu têe. Â wàé, âna é bwaa tà tâa na province Asia na jè pàara. ");
INSERT INTO priNT_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Na pàara bèepwiri, âna gùmagù ba maina ê napô gée goro ê popai kà Paulo goo ê pai pâra wiâ Pwi Ukai. ");
INSERT INTO priNT_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Ba pwa pwi jè âboro na nee Démétrius na pwi a wakè goo ê pâ paò pwaa. Â é pwa ê pâ nari wâra pwapwicîri kà Artémis, tô jè duée. Â dau maina ê mwani na rà tòpi ma wà tèpa bée. ");
INSERT INTO priNT_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Â é cau panaimarirà diri, â é ina tàra pâ: «I tàpé wée, guwà tâmogòori pâ ê wâdé kâjè, âna é me gée goro ê pwâra wakè kâjè bèeni. ");
INSERT INTO priNT_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","27","Ba po dau wâru tèpa âboro ni na province Asia, ma pitiri gòropuu, na rà pwamaina Artémis. Êco na guwà jèe tàgére côo ma têre ê pwina é pwa ê ji pwi Paulo bèepwiri. Ba é gére inapàpari pâ, ticèmuru naa goo ânuuru duée, ba muru na pwa goro na-araraîri âboro. Â rà pâ nau wâru wà tàpé na rà cèikî ê pwiibà, càcaa wâco wâni Éféso, â jèe wâpitiri Asia. «Po dau èpà, ba o péa o ina ba èpà ê wakè kâjè, bau imara i wâra pwapwicîri kà Artémis, â péa o nabwé na jè pwamainaê!» ");
INSERT INTO priNT_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Rà nye dau putàmu kaa tèpa wakè goro paò, â rà tomara too pâ: «Wà Artémis kâjè tàpé Éféso, âna é tâjaijè diri!» ");
INSERT INTO priNT_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Â pâ nau gùmagù ê pé napô diri, ba cau tèpa âboro diri, âna rà piwàcî pâ naa na aupitapitiri. Â rà dàti wiârà wà Gaïus ma Aristarque, tupédu âboro gée na province Macédoine, tupédu bée wà Paulo goro picémara ê popai. ");
INSERT INTO priNT_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Nüma wà Paulo na é pâra mari ê pâ âboro, ba na rà pitùra, êco na rà pacooé wà tèpa cèikî. ");
INSERT INTO priNT_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Â wà pàra tèpa bée mwara, tèpa âboro imaina me gée Asia, âna rà panuâ popai têe pâ, na é cibwaa cipàpari ê pâ âboro naa na wâra ipitiri. ");
INSERT INTO priNT_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Napwa naa goo wà tèpa âboro, âna jèe càra caa pitàmaarirà, ba wà pàra tàpé, âna rà tomara pâ, wàrani. Â wà pàra pwi, âna rà tomara ê jè pai ina wèe. Â wâru tàpé na càra caa gére tâmogòori pâ gée goro dà na rà gére ipitirà. ");
INSERT INTO priNT_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Wà pàra tèpa Juif, âna rà popa pwi jè âboro na nee Alexandre, â rà piwiâ têe ê majoro ê pitapitiri kà tèpa âboro bèepwiri. Â rà cètùué, ba na é pwi a pitùra kàra na ara pâ âboro. Â é cimadò, â é pagòtù ê îê, ba na é ilari jii tèpa âboro pâ, na é tùra. ");
INSERT INTO priNT_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Êco na, na rà tâmogòori pâ é pwi Juif na é cèikî naa goo wà Pwiduée â rà cau tomara too diri pâ: «Wà Artémis kâjè tàpé Éféso, âna é tâjaijè diri!» Â po ârailu ineretòotù kàra goro tomara pwiri. ");
INSERT INTO priNT_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","É mwa bàra pâra nau pacoorà wà pwi a pwa tii kâra wâratûâ kâra napô. Â é ina tàra pâ: «Bwa; i tàpé gée Éféso! Jè tâmogòori diri pâ ê napô bèeni, âna é pwi a piwéaari ê wâra pwapwicîri kà Artémis, ma ê ânuuê pwicîri—ê ânuuê na pwa goro atü, â na tûu boome gée napwéretòotù! Wàilàapà pwina câé caa tâmogòori pwiri? ");
INSERT INTO priNT_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Nye ticè pwi jèpwi cèna é tobapwâ. Wâdé na guwà moo, â guwà cibwaa ûri imudi. ");
INSERT INTO priNT_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Ba guwà pame naani wà tèpa âboro bèeni. Êco na nye ticè na rà mura gée na ê wâra pwapwicîri, ma ticè na èpà na rà ina naa goo Artémis, tô duée ilàri kâjè. ");
INSERT INTO priNT_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","«Wà Démétrius ma tèpa bére wakè kêe, âna munaa nümarà na rà bu èpà, naa goo cè pwi jèpwi. Wâdé, êco na nye pwa tèpa pitèimuru, â nye pwa mwara ê pâ tòotù kâra pitèimuru. Wàépwiri wâna na, na rà pâra nau piciapwâ naawê. ");
INSERT INTO priNT_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Wiàna bwaa pwa cè muru cèna nümawà na guwà tawèeri, â jè mwa pitùra goo naima, na pai pwa wèe na wâdé, na cè tòotù kâra wâratûâ. ");
INSERT INTO priNT_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Ba péa rà niimiri wà tèpa Roma pâ, jè nama gùmagù napô, gée goo ê pwina tèepaa nabà. Â wiàna rà tawèerijè goro majoro ê pitapitirijè, â o ticè na jè tòpi tàra goo.» Â gée na càùru ê pai tùra kêe, â é ina tàra pâ, na rà ipiina. ");
INSERT INTO priNT_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Ûna jèe nabwé ê pai pipwa kàra, â é papitiri tèpa cèikî wà Paulo, â é pagòorà. Gée na càùru ê jè pàara, â é picijiirà, â é pâra naa na province Macédoine. ");
INSERT INTO priNT_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Â é tapàgà ê pâ napô Macédoine, â é dau pagòo tèpa cèikî na rà tâa wê goro ê pâ popai na wâru. Â géewê, â é pâra naa Grèce. ");
INSERT INTO priNT_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Â é bwaa tà tâa wê, naa na âracié parui. Â gée na càùé, â é pwa na é tò naa gòro wànga pâ naa na province Syrie. Êco na é têre pâ, pwa na rà pwa tûâ têe wà tèpa *Juif. Â é niimiri pâ, na é wâjué, ma é pâ naa Macédoine. ");
INSERT INTO priNT_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Wâru tèpa âboro na rà pâra wiâê gée na pâ jèpa ville—wà Sopater gée Bérée, pwina naî wà Pyrus; wà Aristarque ma Secundus gée Tésalonika; wà Gaïus gée Derbe; â âracié âboro mwara gée na province Asia—wà Timotéo, ma Tychique, ma Trophime. ");
INSERT INTO priNT_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Rà pâra béaa kâbà, â rà mwa tà tapacîbà wâna ville Troas. ");
INSERT INTO priNT_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Â napwa naa goobà, âna bà pa wànga gée na ville Filipi, gée na càùru ê pâ *tòotù maina kâra ‘pi-ija poloa na ticè nyaa kêe’. Â gée na càùru ê 5 tòotù, â bà mwa pâdarirà naa Troas. Â bà bwaa tà tâa wê naa na caapwi nadàpàra pwapwicîri. ");
INSERT INTO priNT_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Na bàrane kâra *tòotù pwicîri, â bà caatâa naima târa pa utimuru, ma tubiti ê poloa. Â é patùra tèpa cèikî wà Paulo, tiagoro nabibiu kâra ne, ba ée jèe pâra jiirà, na dàuru. ");
INSERT INTO priNT_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Bà picaatâa na ê pwi naditàrawâ na tâdòiti. Â dau wâru ê pâ ânye na tâa wê. ");
INSERT INTO priNT_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Pwa pwi âboro èpo, na nee Eutyque, âna é tâa na goropwârawâ kîri. Â, na é gére pwa nyakâra tùra wà Paulo, â é puuia wà pwini, â é tûu gée na âracié narawâ tâdòiti. Â, na rà pipagòtùé, âna é jèe bà. ");
INSERT INTO priNT_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Â é boo wà Paulo, â é cùué boo, â é tòtòopié, â é ina pâ: «Guwà cibwaa nama wâgotàwà, ba é bwaa nye wâro.» ");
INSERT INTO priNT_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Ûna é too côwâ wà Paulo, â é tubiti ê poloa, â rà ija. Â é bwaa tùra ba gòiri mwara tiagoro pwârapwaa. Â gée na càùru pwiri, â é pâra jiirà. ");
INSERT INTO priNT_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Â wà tèpa cèikî, âna rà pâra wiâ i pwi âboro èpo naa jaaé. Â rà nye dau ipwàdée diri kaa. ");
INSERT INTO priNT_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Bà pâra béaa kà Paulo gòro wànga, ba nümee na é pâ napô tia na ville Assos, â na bà mwa popaé géewê. ");
INSERT INTO priNT_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Â é tòme daribà naa gòro wànga naa Assos, â bà pâra naa na ville Mytilène. ");
INSERT INTO priNT_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Géewê, na tòotù gée paé côwâ, âna bà pâ goro jènere gòropô Kio. Â, na dàuru kêe, â bà coo na gòropô Samos. Â, na tòotù gée paé côwâ, â bà tèepaa naa na ville Milet. ");
INSERT INTO priNT_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Ba é jèe nye tûâri wà Paulo pâ, o câé caa coo na Éféso, târa na o câé caa tà èrà wâna province Asia. Ba é wàcî, târa na é tèepaa naa *Iérusaléma, wiàna pâri, na tòotù kâra Pentecôte, *tòotù maina kâra piûnya. ");
INSERT INTO priNT_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Ûna bà tèepaa naa Milet, â é panuâ popai wà Paulo pâ naa Éféso, jaa tèpa pitûâ kâra wâra pwapwicîri, ba na rà me mariê naa Milet. ");
INSERT INTO priNT_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Ûna rà pitànaima, â é ina tàra pâ: «Guwà jèe nye côo ê pai wâro kôo naa nabibiu kàwà, tapoo na tòotù na go tèepaa medariwà naa na province Asia. ");
INSERT INTO priNT_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Â go piênawéna kà Pwiduée, na ê ipakîri. Â, na pàra tòotù, âna go mu i, â go mu dau pidàpwicâariô goo ê pâ tûâ na èpà, na rà pwa tôo wà tèpa Juif. ");
INSERT INTO priNT_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Guwà tâmogòori pâ go jèe ina tàwà diri ê pâ pwina wâdé ba kàwà, â nye ticè na go naapwàniri goowà. Ba go picémara ma pacâmuriwà, béaa kâra diri ê pâ âboro, ma naa na mwara ê pâ pwârawâ kàwà. ");
INSERT INTO priNT_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Go ina ba gòo tà tèpa Juif, ma tàpé na càra caa tèpa Juif mwara pâ, na rà pinünüma ma rà biirà naa goo Pwiduée, â na rà cèikî naa goo Pwi Ukai kâjè Iésu Kériso.» ");
INSERT INTO priNT_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","«Â êni, âna é tacoo gooò ê Nyuâaê Pwicîri, ba na go pâra naa Iérusaléma, â câgo caa tâmogòori cè pwina o tèepaa mariô. ");
INSERT INTO priNT_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","É mu nye tà patêreô naa na ê pâ napô ê Nyuâaê Pwicîri pâ, ê karapuu, ma ê maagé côo, âna rà nye tàgére tapacîô. ");
INSERT INTO priNT_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Êco na pé piticèmuru naa goo, na go bà, é, na go wâro. Ba wàéni ê pwina dau pwamuru naa goo: Na go tubamwara ê wakè na é naa tôo wà Pwi Ukai Iésu, na go picémara ê *Picémara Wâdé, goo ê *pimeaari imudi kà Pwiduée. ");
INSERT INTO priNT_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","«Ia go picémara pâ jaawà ê *Mwaciri kà Pwiduée. Â nabàni, âna go tâmogòori pâ o câjè mwa caa picôojè côwâ. ");
INSERT INTO priNT_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Êkaa pwiri, na go ina ba gòo tàwà nabàni, pâ: Wiàna cè pwi jè ârapàarawà, âna o tiàué jaa Pwiduée, â câgo caa pwi majoroé. ");
INSERT INTO priNT_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Ba go jèe picémara tàwà, diri ê pâ pwina, na guwà tâmogòori, naa goo ê auniimiri kà Pwiduée. Â nye ticè cèna go pwàniri goowà.» ");
INSERT INTO priNT_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","«Guwà ipwacôowà, â guwà tòimiri bwàti mwara ê wâra pwapwicîri kêe, ba tèpa âboro kà Pwiduée. Ba ê Nyuâaê Pwicîri, âna é naarà tàwà, ba na guwà wéaarirà, wàilà na é jèe wârirà wà Pwiduée, goro ê pai bà kà Pwina naîê Iésu. ");
INSERT INTO priNT_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Ba go nye tâmogòori pâ gée na càùru ê pai pâra kôo, â rà o tèepaa me wà tèpa âboro na tèpa pwâ. Â rà pwacèwii tèpa macii a piuti na rà o tòdidiri ê na gomu goowà. ");
INSERT INTO priNT_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Â nye gée nabibiu kàwà mwara, na rà o cimadò géewê wà tàpé na rà pwâ, ba na rà dàti tèpa cèikî wiârà.» ");
INSERT INTO priNT_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","«Guwà tà tàcî, â guwà tà niimiri pâ po âracié naja na go tâa jaawà. Â pwa ê pàra pàara na, mu tûu ê pwâra jawé kôo na go mu pagòowà jècaa, naa ne ma pwaa. ");
INSERT INTO priNT_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","Â nabàni, âna go naawà tà Pwiduée, ma ê popai goro ê pimeaari imudi kêe. Ba wàé na tà têe ê pàtàmee, târa ma é pagòowà, ma naa tàwà ê pâ *aupwényunyuâari na é jèe nabwé ipwabwàti, ba kà tèpa âboro kêe. ");
INSERT INTO priNT_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","«Ûna go bwaa tâa jaawà, â càcaa nümoo goo cè mwani pwaa, ma cè mwani mii, ma cè ârabwée kâra cè pwi jèpwi. ");
INSERT INTO priNT_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Ba guwà nye tâmogòori pâ go nye wakè goro ê du na-araraîô bèeni, ba târa ê pwina nümabà goo, ma wà tèpa béeò. ");
INSERT INTO priNT_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Â go jèe paari tàwà mwara pâ, na jè wakè, târa ma jè pitu tà tàpé na rà maagé ma piticè kàra. Na jè wàrapwiri, â jè niimiri ê popai kà Pwi Ukai Iésu na é ina pâ: “Dau maina ipwàdée kà pwina é naa, jii pwina é tòpi.”» ");
INSERT INTO priNT_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Â gée na càùru ê pai tùra kêe bèepwiri, â é tùu jùrué wà Paulo, â rà capai pwapwicîri naima. ");
INSERT INTO priNT_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Â rà ibwénüu, ba na rà picijiié, â rà nye po cau i diri. ");
INSERT INTO priNT_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Ba po dau pikîri ê pwâranümarà, gée goro na é ina tàra pâ, o càra mwa caa picôorà côwâ. Â géewê, â rà ciaé boo tiagoro ê wànga. ");
INSERT INTO priNT_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Bà ipicijii ma tèpa pitûâ kâra wâra pwapwicîri na Éféso, â bà tò naa gòro wànga. Â bà itàa ba tàrù naa gòropô Cos. Ûna dàuru, â bà too naa gòropô Rhodes, â géewê, â bà pâra naa na ville Patara. ");
INSERT INTO priNT_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Naawê, âna bà pâmari pwi wànga pâ naa na ére napô Phénicie, â bà tò naa gò, â bà pâra. ");
INSERT INTO priNT_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Â bà pâra, â ûna bà niâ pâ, â bà côo ê pô Chypre, â bà tòpòé naa gòro aèmwü. Â bà itàa dàra province Syrie, â bà ti wâna pwi jè ville wê, na nee Tyr, wâna na na kai naawê ê wànga. ");
INSERT INTO priNT_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Ûna bà pâmari tèpa cèikî wê, â bà tà tâa jaarà naa na caapwi nadàpàra pwapwicîri. Â ê Nyuâaê Pwicîri, âna é naa tàra ê popai goo Paulo. Â rà ina têe pâ, na é cibwaa too naa *Iérusaléma. ");
INSERT INTO priNT_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Êco na, gée na càùru caapwi nadàpàra pwapwicîri, â bà coo gòobàra pâra kâbà. Â rà piciabà wà tèpa tâa wê, wàilà mara wâdàra, ma èpo kàra. Rà ciabà tia bàrawià, â na bà tèepaa boo, â bà tùu jùrubà, â bà pwapwicîri. ");
INSERT INTO priNT_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Nabwé, â bà tò naa gòro wànga, â rà wâjué côwâ naa jaarà wà tèpa cèikî. ");
INSERT INTO priNT_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Bà còpòo gée Tyr, â bà pâra naa Ptolémaïs, pwi aucoo kâra wànga. Â bà tubanabwé naawê ê pâra kâbà gòro wànga. Géewê, â bà pâra nau pwabwàcu tà tèpa cèikî, â bà bwaa tàpo tâa caapwi tòotù wâjaarà. ");
INSERT INTO priNT_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Bà còpòo pâ naa Césarée na dàuru. Ûna bà tèepaa naawê, â bà pitâa jaa wà Filipo, pwi a picémara ê *Picémara Wâdé, wà pwi jè ârapàara tèpa 7 dikona na ia pitòrigarirà na Iérusaléma. ");
INSERT INTO priNT_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Wà pwiibà, âna ârapàpé ê pa èpo dopwa kêe, na rà pa *péroféta. Ba rà inapàpari ê pâ popai na cùrurà goo Pwiduée. ");
INSERT INTO priNT_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Â jèe dau wâru ê tòotù kâbà naa na pwi ére-bà. Â, na pàara-bà, âna é tèepaa boome gée napô *Judée wà pwi jè péroféta, na nee Agabus. ");
INSERT INTO priNT_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Â ûna é pâmaribà, â é pa karapuu kà Paulo, â é ipii côwâ ê du âê ma du îê goo, â é ina pâ: «Wàéni ê pwina é ina ê Nyuâaê Pwicîri: “Wà pwi âboro na kêe ê karapuu bèeni, âna rà wàrani târa cè pai piié wà tèpa *Juif na Iérusaléma. Â rà o mwa naaê tà tàpé na càra caa tèpa Juif.”» ");
INSERT INTO priNT_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Ûna bà têre pwiri, wàibà ma tèpa tâa wê, â bà tacoo goo wà Paulo pâ, na é cibwaa too naa Iérusaléma. ");
INSERT INTO priNT_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Êco na é tòpi tâbà pâ: «Cina guwà gére i, ma pwa ma pikîri ê pwâranümoo? Wiàna tòo-o ma pòtàmwaraô naa goo nee Iésu na Iérusaléma, âna go jèe pipwabwàtio.» ");
INSERT INTO priNT_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Ûna càcaa pâri ma bà tubatûu ê pwâranümee, â bà nabwé na bà tacoo gooé, â bà ina pâ: «Wâdé na coo ê câbawâdé kà Pwi Ukai.» ");
INSERT INTO priNT_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Gée na càùru ê pâ tòotù-bà, â bà too naa Iérusaléma. ");
INSERT INTO priNT_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Â rà me wiâbà wà pàra tèpa cèikî gée Césarée, â rà popabà pâdari pwi âboro na nee Mnason, ba na bà pitâa jaaé. Wà pwiibà, âna pwi âboro gée gòropô Chypre, â pwina jèe gòrié na ê cèikî. ");
INSERT INTO priNT_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Ûna bà tèepaa naa Iérusaléma, â rà tòpibà naa na ipwàdée wà tèpa cèikî. ");
INSERT INTO priNT_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Na tòotù gée paé côwâ, âna bà pâra wiâ Paulo naa jaa wà Jacques. Â rà cau ipitiri naawê wà tèpa pitûâ kâra wâra pwapwicîri. ");
INSERT INTO priNT_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Ûna é pwabwàcu tàra diri wà Paulo, â é piwiâ tàra diri ê pâ namuru na é pwa wà Pwiduée, naa nabibiu kà tàpé na càra caa tèpa Juif, na pàara na é picémara tàra ê popai. ");
INSERT INTO priNT_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Ûna rà têre pwiri, â rà dau pwamaina Pwiduée. Â rà ina têe pâ: «Gà côo, co pwi béebà, jèe po dau wâru tèpa Juif na rà cèikî naa goo Iésu âna rà bwaa dau déi goo ê *Naèà kà Moosé. ");
INSERT INTO priNT_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Â rà têre pâ wâgà, na picòo tà pàra tèpa Juif—wàilà na rà piwâro naima ma pàra tèpa âboro ité—pâ, na rà biirà jii ê Naèà kà Moosé. Â rà têre mwara pâ gà ina tàra pâ, na rà cibwaa pwa *kamaî tà tèpa nari èpo kàra, â na rà cibwaa pâra wiâra ê nyamanya kà tèpa Juif. ");
INSERT INTO priNT_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","O mwa wànau? Ba rà mwa têre pâ gà wâni. ");
INSERT INTO priNT_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","«Gée goro pwiri, â wâdé na gà pwa pwina bà ina tâgà. Ba rà wâni nabibiu kâbà ârapàpé âboro na rà pwa ê *ipwataâboro tà Pwiduée. ");
INSERT INTO priNT_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Wâdé na gà poparà wiâgà, ba na guwà pwa ma wàilà ê ‘pwapwicîri târa pai pinuwa’. Â gà wâri ê pwina tiàu jiirà goro ê wakè bèepwiri, ba na rà o pwârü ê pûrurà. Â rà o tâmogòori wà tèpa âboro pâ, ê pwina rà têre naa googà, âna pwâ. Â nye wâgà mwara, âna gà o paari pâ gà pwi a pitòimirigà mwara, naa goro ê Naèà. ");
INSERT INTO priNT_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","«Â napwa naa goo wà tàpé na càra caa tèpa Juif, na rà jèe cèikî, âna bà jèe pwa tii darirà. Â bà ina tàra ê aupitûâri kâbà: “Guwà cibwaa uti ê pâ macii na pwa *ârapwaailò goo târa pâ ânuuru duée. Guwà cibwaa uti ê domii, ma ê pâ macii na dàûru nyarà (ba jèe càcaa còobé ê domii kàra). Â guwà cibwaa ipuu imudi.”» ");
INSERT INTO priNT_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Â é wâgoo ê auniimiri kàra wà Paulo, â é popa tèpa ârapàpé âboro bèepwiri. Â, na tòotù géeme côwâ, â rà tapoo ma wàé ê ‘pwapwicîri târa pai pinuwa’ wiâra ê naèà kà tèpa Juif. Â gée na càùé, â é too naa na *Wâra pwapwicîri wà Paulo, â é inapàpari ê tòotù na rà o mwa jèpa pwa ârapwaailò na; ba na rà paari pâ, rà jèe tubanabwé ê *auipwataâboro kàra. ");
INSERT INTO priNT_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Naa pwâadàra ê caapwi nadàpàra pwapwicîri, âna wà tèpa Juif gée na province Asia, âna rà côo wà Paulo naa na Wâra pwapwicîri, â rà pinaa ârapûru wà tèpa âboro, ba na rà tâjùrué. ");
INSERT INTO priNT_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","Â rà ina pâ: «Tèpa *Isaraéla, guwà me nau pitu tâbà! Wàéni ê pwi âboro na é picémara pitiri pâ, naa cicara ê Ba kâjè, ma ê Naèà kà Moosé, ma ê Wâra pwapwicîri bèeni! Â nabà, âna é jèe còbèedari mwara ê pwi ére pwicîri bèeni, ba é jèe pwa ma naadò naawê wà tàpé na càra caa tèpa Juif!» ");
INSERT INTO priNT_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","(Rà ina pwiri, ba rà côoru naima ma Trophime, pwi âboro gée Éféso, naawê na Iérusaléma, â rà niimiri pâ é popaé dò naa na Wâra pwapwicîri wà Paulo.) ");
INSERT INTO priNT_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Â diri ê ville, âna é pikòi, â rà itàa me diri ê pâ âboro, â rà tâjùru wà Paulo. Â rà dàtié còobé gée na Wâra pwapwicîri, â rà nye pò ma târi kaa ê pâ goropwârawâ. ");
INSERT INTO priNT_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Â rà jèe pimudàra, ba na rà tétàmwereê. Êco na é pâ nau têre wà pwi caa kâra coda *roma pâ, rà gùmagù diri tàpé Iérusaléma. ");
INSERT INTO priNT_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Â é nye pò ma popa kaa tèpa coda ma tèpa caa kàra, â rà itàa pâ dàra. Ûna rà côorà wà tèpa âboro, â rà nye nabwé kaa na rà èi wà Paulo. ");
INSERT INTO priNT_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","É nye pâra kaa wà pwi caa kâra coda, â é tâjùru Paulo, â é pwa ma piié goro ârailu itùpaò. Â é tawèeri tèpa âboro pâ: «Wàilàapà pwini, â dà cè pwina é pwa?» ");
INSERT INTO priNT_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Â rà ina wà pàra tàpé pâ wàrani, â rà ina pàra tàpé pâ wàrana. Â câé caa tâmogòori wà pwiibà pâ, wàilàapà cèna âjupâra ba rà po dau pikòi. Â é ina pâ, na popa Paulo too naa na wâra coda. ");
INSERT INTO priNT_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Â rà popaé wà tèpa coda. Ûna rà tèepaa naa gòro aucò too, â rà jèe po tàmee, ba rà po dau putàmu wà tèpa âboro, â nye nümarà na rà èié. ");
INSERT INTO priNT_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Ba rà cau pâra diri wiâê burà tomara pâ: «Naaê, ba na bà pòtàmwereê!» ");
INSERT INTO priNT_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Wà tèpa coda, âna pwa na rà naadò wà Paulo naa na wâra coda, â é ina tà pwi caa kàra naa na pwâratùra grec pâ: «Pwiri o nye pâri ma go ina tâgà cè jè muru?» Â é pò wà pwini, â é tòpi têe pâ: «Gona gà pwa grec? ");
INSERT INTO priNT_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Gona càcaa wâgà pwi *Aigupito, pwi a pwa ma gùmagù ê napô?—wà pwi a pa pâ naanigée namaré ê 4 000 âboro târa tü paa dàra ê pwâra ukai kâbà?» ");
INSERT INTO priNT_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Â é tòpi têe wà Paulo pâ: «Bwa! Wâgo, âna go pwi Juif, â go pwi a tèpa naa Tarse, napô gée na province Cilicie, pwi napô na dau maina. Â go ilari jiigà pâ, càcaa pâri ma go patùra ê pâ âboro bèeni?» ");
INSERT INTO priNT_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Â é ina wà pwiibà pâ: «Îgà!» Â é coo gò i aucò wà Paulo, â é pwa ineremuru târa ê pâ âboro goro îê. Ûna nye po ticè pwâratùra kaa, â é patùrarà, goro *hébéru, pwâratùra kà tèpa Juif. ");
INSERT INTO priNT_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","Â é ina pâ: «Bwa; tèpa jènereô ma tèpa caa, guwà têre pwina go ina tàwà ni, ba târa béipwamuruô.» ");
INSERT INTO priNT_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Ûna rà têre na é patùrarà naa na ê pwâratùra kàra, â mwa dau ticè airà kaa. É ina tàra wà Paulo pâ: ");
INSERT INTO priNT_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","«Go pwi *Juif, pitèpao naa Tarse wâna province Cilicie, êco na èrùo naani *Iérusaléma. Â wà Gamaliel na é pacâmuriô, pwi âboro imaina naa jaa wà tèpa caa kâra câmu. Â é còo tôo bwàti ê *Naèà kà tèpa jojoorojè. Go pwi a tàcî ba kà Pwiduée pwacèwiiwà diri nabà. ");
INSERT INTO priNT_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Go tubaèpà tà tàpé na rà *pâra wiâ Pwi Ukai Iésu. Ba go pwa ma tâjùrurà ma piirà—tèpa paao ma ilàri mwara—â go türà naa na karapuu. Â go pwa ma tétàmwara pàra tàpé gée goorà. ");
INSERT INTO priNT_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","«Wà pwi *ukai kà tèpa pwa ârapwaailò ma ê *wâratûâ kà tèpa ijiao, âna rà o *paâjupâraô. Ba go tòpi jiirà ê pâ tii, ba na go naa tà tèpa jènerejè, tèpa Juif na rà tâa Damas. Ê pâ tii-bà, âna rà naa ê tàrù kôo, ma go pâra naawê, nau tâjùru tèpa cèikî naa goo Iésu, ma poparà me naa Iérusaléma, ba na pwa wârimuru tàra. Â go pwa diri ê pâ muru bèepwiri.» ");
INSERT INTO priNT_vpl 