﻿USE sofia;
DROP TABLE IF EXISTS sofia.prfNT_vpl;
CREATE TABLE prfNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES prfNT_vpl WRITE;
INSERT INTO prfNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Iddi en listaan nen ninunu hidi ni Jesu-Cristo a gubwat ten lahi ni David a gubwat bi ten lahi ni Abraham. ");
INSERT INTO prfNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Ti Abraham ay ama ni Isaac sakay ti Isaac bi en ama ni Jacob. Ti Jacob ay ama ni Juda sakay en kákkapatkaka na hidi a lállaki. ");
INSERT INTO prfNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Ti Juda ay ama de Fares ay ti Zara (en ina di ay ti Tamar). Sakay ti Fares ay ama ni Esrom a ama ni Aram. ");
INSERT INTO prfNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ti Aram ay ama ni Abinadab sakay ti Abinadab ay ama ni Naason a ama ni Salmon. ");
INSERT INTO prfNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Ti Salmon ay ama ni Booz a en ina na ay ti Rahab. Sakay ti Booz ay ama ni Obed (en ina na ay ti Ruth) a ama ni Jesse ");
INSERT INTO prfNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","a ama bi ni Hari a David. Ti David ay ama ni Solomon (en ina na ay ti Batseba a nabiluwan ni Urias). ");
INSERT INTO prfNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Ti Solomon ay ama ni Roboam a ama ni Abias sakay ti Abias ay ama ni Asa. ");
INSERT INTO prfNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Ti Asa ay ama ni Josafat a ama ni Joram. Sakay ti Joram ay ama ni Ozias. ");
INSERT INTO prfNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Ti Ozias ay ama ni Jotam a ama ni Acaz sakay ti Acaz ay ama ni Ezequias. ");
INSERT INTO prfNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ti Ezequias ay ama ni Manases, ti Manases ay ama ni Amos sakay ti Amos ay ama ni Josias. ");
INSERT INTO prfNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Sakay ti Josias ay ama ni Jeconias sakay en kákkapatkaka na hidi a lállaki. Neenak dán hidi ten panahun a pinuwersa nen taga-Babilonia hidi en Israelita hidi a iyangay ten bansa di. ");
INSERT INTO prfNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Nadid káttapos nen panahun a puwersadu a kákkeangay nen Israelita hidi ti Babilonia ay nagin anak ni Jeconias ti Salatiel a ama ni Zorobabel. ");
INSERT INTO prfNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Ti Zorobabel ay ama ni Abiud. Ti Abiud ay ama ni Eliquim sakay ti Eliquim ay ama ni Azor. ");
INSERT INTO prfNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Ti Azor ay ama ni Sadoc. Ti Sadoc ay ama ni Aquim sakay ti Aquim ay ama ni Eliud. ");
INSERT INTO prfNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Ti Eliud ay ama ni Eleazar; ti Eleazar ay ama ni Matan. Ti Matan ay ama ni Jacob. ");
INSERT INTO prfNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Sakay ti Jacob ay ama ni Jose a kabinga ni Maria. Ti Maria ay ina ni Jesus a dáddulawán a Cristo. ");
INSERT INTO prfNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Kaya tehud a sapulu ay ti áppat a salinlahi sapul kánni Abraham hanggan kánni David. Sakay sapulu ay ti áppat a salinlahi sapul kánni David hanggan ten panahun nen puwersadu a kákkeangay nen Israelita hidi ti Babilonia. Sakay tehud bi a sapulu ay ti áppat a salinlahi sapul ten puwersadu a kákkeangay ti Babilonia hanggan kánni Cristo. ");
INSERT INTO prfNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Kona háddi en nangyari ten kákkeenak ni Jesu-Cristo. Ti Maria a ina ni Jesus sakay ti Jose ay nagkasundu dán hidi a magkabinga. Peru bagu hidi a nagagum ay mabuktet dán ti Maria (iyud ay nangyari ten pamamag-itan nen kapangyariyan nen Banal a Ispiritu.) ");
INSERT INTO prfNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Ti Jose a magin kabinga ni Maria ay matuwid a tolay. Gapu awan na gustu a mapasaniki ti Maria ten kakpalan ay binalak na a hiwalayan ti palihim. ");
INSERT INTO prfNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Peru mentras a áisipán na iyud ay minetidug siya sakay en anghel nen Panginoon ay pummeta dikona ten pamamag-itan ni tagináp sakay kinagi nen anghel, “Jose a gubwat ten lahi ni David, dyan ka manteng a tulusán a pakasalan ti Maria gapu en buktet na ay ten pamamag-itan nen kapangyariyan nen Banal a Ispiritu. ");
INSERT INTO prfNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Magenak siya ti essa a lállaki sakay ngaranan mu a Jesus, gapu siya en mángligtas ten tolay na hidi ten kasalanan di hidi.” ");
INSERT INTO prfNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Nangyari i atananid a iyud tánni matupad en kinagi nen Panginoon ten pamamag-itan nen propeta a, ");
INSERT INTO prfNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Mágsanig kam! Maglihi en essa a birhen sakay magenak siya ti essa a lállaki, sakay ngaranan siya a Emmanuel.” (En kahulugan ni iyád ay “Kaguman tam en Diyos.”) ");
INSERT INTO prfNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Nadid, ten dikona a malukag ti Jose ay sinunud na en utus nen anghel nen Panginoon dikona sakay inagum na ti Maria. ");
INSERT INTO prfNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Peru awan inarikad ni Jose ti Maria hanggan dikona a awan meenak en anak a lállaki. Ten dikona a neenak en anak ay nginaranan ni Jose a Jesus. ");
INSERT INTO prfNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Nadid ti Jesus ay neenak ten banuwan a Bethlehem a sakup ni Judea ten kapanahunan nen pághari ni Herodes. Ten kákkeenak ni Jesus ay tehud a dummemát ti Jerusalem a sangan a mágkurunung a tolay a gubwat ti sikatan. ");
INSERT INTO prfNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Nágtatanungán hidi ten tolay hidi haud, “Hádya dán en neenak a anak a magin hari nen Judio hidi? Gapu netan mi a lummitaw ti sikatan en biton na. Kaya ummangay kami háddi ay tánni sambaán siya.” ");
INSERT INTO prfNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Nadid ten dikona a mabareta iyud ni Hari a Herodes ay nabalisa siya ti hustu kona bi ten atanan nen taga Jerusalem hidi. ");
INSERT INTO prfNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Kaya pinisan na en atanan a pinunu nen padi hidi sakay en tagapagtoldu hidi nen Kautusan sakay tinanung na hidi, “Hádya a meenak en Cristo?” ");
INSERT INTO prfNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Kinagi di a, “Ti Bethlehem a sakup ni Judea,” gapu kona háddi en insulat nen propeta: ");
INSERT INTO prfNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Siko Bethlehem a sakup ni Juda, ay awan ka medimudyan ten atanan a banuwan ni Juda. Gapu dikomu a maggubwat en essa a pinunu a mamahala ten banuwan ku a Israel.’ ” ");
INSERT INTO prfNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Nadid ten dikona a matukuyan iyud ni Herodes, ay pinadulaw na ti lihim en mágkarunung hidi a tolay. Tinukoy na dikodi ni nengkan a lummitaw en biton. ");
INSERT INTO prfNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Káttapos ay kinagi na dikodi, “Kadmoy dán ti Bethlehem sakay pakaaryokán moy en anak. Ni ketan moy dán ay ibareta moy dikoku a pagdaka tánni angayák bi sumamba dikona.” ");
INSERT INTO prfNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Nadid pákkasanig di ten kinagi nen hari ay lummakad dán hidi. Ten dikona a ketan di a ruway en biton ay tunay en saya di. Inggiya hidi nen biton hanggan dikona a makademát hidi ten tapat nen páppágyanan nen anak. ");
INSERT INTO prfNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Tunay en saya nen mágkarunung hidi a tolay a gubwat ti sikatan dikona netan di a ummimang en biton. ");
INSERT INTO prfNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Dikona a makasáddáp dán hidi ten bilay ay netan di en anak a kaguman na en ina na a ti Maria. Lummuhud hidi sakay sinamba di en anak. Inluwas di en rigalu di hidi ten anak a gintu, insenso sakay mira. ");
INSERT INTO prfNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Nadid dikona pasoli dán hidi ay kinagi nen Diyos dikodi ten pamamag-itan ni tagináp a dyan dán hidi soli kánni Herodes. Kaya iba dán a dilan en naglakadan di. ");
INSERT INTO prfNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Nadid ten kállakad nen mágkarunung hidi a tolay ay pummeta kánni Jose en anghel nen Panginoon ten pamamag-itan ni tagináp. Kinagi na dikona, “Jose umikat ka dán sakay iyangay mu i matina en ti Egipto. Dyan kam lumakad haud mentras a awan ku kagiyán dikomu. Gapu aryokán ni Herodes i anaken tánni bunuwán na.” ");
INSERT INTO prfNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Kaya ummikat ti Jose ti gibiyid a iyud sakay ummangay hidi ti Egipto kaguman na en matina. ");
INSERT INTO prfNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Sakay haud dán hidi a nágyan hanggan ten dikona a dummemát en panahun nen kákkatay ni hari a Herodes. Nangyari iyud tánni matupad en kinagi nen Panginoon ten pamamag-itan nen propeta hidi a, “Dinulawan ku en anak ku a lumakad ti Egipto.” ");
INSERT INTO prfNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Nadid ten dikona a matukuyan ni Herodes a linoku siya nen mágkarunung hidi a tolay ay naiyamut siya ti hustu. Kaya pinabunu na ten sundalu na hidi en atanan a anak a lállaki a tehud a idad a duwwa a taon a padibábbi a mágyan ti Bethlehem sakay ten palebut na hidi a lugar. En nagin giyya na ten idad nen anak hidi a bunuwán ay ayun ten natukuyan na a kinagi nen mágkarunung hidi a tolay a panahun a kállitaw nen biton. ");
INSERT INTO prfNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Natupad ngani en kinagi ni propeta a Jeremias tenhud a, ");
INSERT INTO prfNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","‘Nasanig ti Rama en boses, boses nen matindi a sangetan sakay kalungkutan. Sássangitan ni Raquel en anak na hidi. Awan na gustu a paraparaán gapu nágkatay dán hidi.” ");
INSERT INTO prfNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Nadid ten dikona a natay dán ti Herodes, ay pummeta kánni Jose en anghel nen Panginoon ten pamamag-itan ni tagináp dikona a ked palla siya ti Egipto. ");
INSERT INTO prfNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Kinagi na, “Jose umikat ka dán, iyoli mu dán i matina en ti Israel, gapu natay dán en masor hidi a mangbunu ti anaken.” ");
INSERT INTO prfNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Kaya ummikat siya sakay nagsoli hidi ti Israel kaguman na en matina. ");
INSERT INTO prfNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Peru ten dikona a matukuyan ni Jose a ti Arquelao a anak ni Herodes en maghari ti Judea ay mineántingan siya a angay haud. Sakay binawalan siya nen Panginoon ten pamamag-itan ni tagináp kaya ummangay siya ti Galilea. ");
INSERT INTO prfNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Kaya nágyan siya ten banuwan a Nazaret a sakup ni Galilea tánni matupad en kinagi nen propeta hidi tenhud a, “Siya ay mangaranan a Nazareno.” ");
INSERT INTO prfNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Nadid ti panahunid a iyud ay dummemát ti Juan a Mágbinyag ten kaparangan ti Judea sakay nangaral. ");
INSERT INTO prfNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Kinagi na, “Adággan moy dán en kasalanan moy hidi gapu adeni dán a dumemát en kahariyan dilanget!” ");
INSERT INTO prfNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Ti Juan en gustu a kagiyán ni propeta Isaias dikona a kinagi na a, “Tehud a magpákraw ten kaparangan. ‘Ihanda moy dán en dilan nen Panginoon; maggamet kam ti masunong a dilan a paglakadan na!’ ” ");
INSERT INTO prfNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","En damit ni Juan ay naladi a dutdut ni kamelyo sakay en sinturon na ay gubwat ten koblet ni hayup. En kákkanán na ay raksa a dudun sakay pulut ni pitukan. ");
INSERT INTO prfNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Angay nágsanig dikona en tolay hidi a gubwat ti Jerusalem, ti Judea, sakay en mágyan hidi ten banuwan hidi a namagdibelyu ten dinom ti Jordan. ");
INSERT INTO prfNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Impahayag di en kasalanan di hidi sakay bininyagan hidi ni Juan ten dinom ti Jordan. ");
INSERT INTO prfNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Peru dikona a ketan ni Juan a makpal a Pariseo sakay Saduseo a umadeni tánni magpabinyag, ay kinagi na dikodi, “Sikam a lahi ni biklat. Deya i nagkagiyid dikomoy a maginanan moy en parusa nen Diyos? ");
INSERT INTO prfNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Patunayan moy pa ten kákkabiyag moy a talaga a inadággan moy dán en kasalanan moy hidi. ");
INSERT INTO prfNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Sakay dyan moy kagiyán a makaligtas kam ten parusa nen Diyos gapu kagi moy a lahi kam ni Abraham. Kagiyán ku dikomoy a kaya nen Diyos a manglalang ti batuwiday hidi ti tatarudan a lahi ni Abraham. ");
INSERT INTO prfNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Nadid palla ay nakahanda dán en wasay a pagkáttol ten gamot nen kayu; en bawat kayu a awan magbunga ti maganda ay pukanán sakay ibut ten apoy. ");
INSERT INTO prfNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“Binyagan takam ten dinom bilang tanda a nagsisi kamon sakay inumadág ten kasalanan moy hidi. Peru en dumemát a kasunud ku ay siya en mangbinyag dikomoy ti Banal a Ispiritu sakay ti apoy. Mas makapangyariyan siya nan sikán, awanák ngani karapatdapat maski ni tagatawid la ten sandalyas na. ");
INSERT INTO prfNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Ipagpag na en yaut tánni maalap en paray, káttapos ay iyoli na en paray ten bilay na sakay en lupás ay tutudán ten apoy a awan maadáp maski nikan.” ");
INSERT INTO prfNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Nadid ti Jesus ay dummemát ti Jordan a gubwat ti Galilea tánni angay magpabinyag kánni Juan. ");
INSERT INTO prfNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Peru tinanggiyan ni Juan ti Jesus sakay kinagi na, “Sikán i kailanganid a binyagan mu, bakin a angay ka magpabinyag dikoku?” ");
INSERT INTO prfNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Tummábbig ti Jesus dikona, “Pabayan mu la a iyád i mangyariyid nadid, gapu iyád i dapatid a gamitán tánni masunud en kaluuban nen Diyos.” Kaya pummayag bi ti Juan. ");
INSERT INTO prfNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Ten dikona a mabinyagan ti Jesus ay ummawas siya ten dinom. Bigla a bummukas dilanget sakay netan na en Ispiritu nen Diyos a dummibábbi a kumán a kalapati sakay ummapon dikona. ");
INSERT INTO prfNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Sakay tehud a boses a nasanig a gubwat dilanget a kinagi na, “Saiyád en mahal ku a Anak, masayaák a tarud dikona!” ");
INSERT INTO prfNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Nadid ti Jesus ay inggiyya nen Ispiritu nen Diyos ten kaparangan tánni toksuwán nen diyablo. ");
INSERT INTO prfNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Nagkulásyon ti Jesus ti áppat a pulu a aldew ay ti gibi kaya nagaláp siya ti hustu. ");
INSERT INTO prfNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Dummemát en diyablo sakay kinagi na, “Ni talaga a siko en Anak nen Diyos ay gamitán benid a tinapay i batuwiday hidi.” ");
INSERT INTO prfNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Peru tummábbig ti Jesus, “Nakasulat, bakán la a ten tinapay a mabiyag i tolayid, nan ten bawat Upos a maggubwat ten Diyos.” ");
INSERT INTO prfNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Káttapos ay inyangay siya nen diyablo ten Templo ti Jerusalem ten Banal a siyudad. Sakay pinágtaknág na siya ten kalangkawan a bahagi nen Templo. ");
INSERT INTO prfNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Kinagi nen diyablo dikona, “Ni siko en Anak nen Diyos ay tumáknig ka benid, gapu nakasulat, ‘Ipebahala na ka ten anghel na hidi, sakay alalayan di ka ten lima di, tánni awan mesángdul ti batu i básset muwen.’ ” ");
INSERT INTO prfNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Tummábbig ti Jesus, “Nakasulat bi ten Upos nen Diyos a, ‘Dyan mu purbaan en Panginoon mu a Diyos.’ ” ");
INSERT INTO prfNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Káttapos ay inyangay siya nen diyablo ten essa a malangkaw a bukid sakay pinatan-aw na dikona en atanan a kahariyan ti munduwiday sakay ten kapangyariyan di hidi. ");
INSERT INTO prfNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Sakay kinagi nen diyablo kánni Jesus, “Iyatád ku dikomu i atananid a iyán ni lumuhud ka sakay sumamba ka dikoku.” ");
INSERT INTO prfNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Peru kinagi ni Jesus, “Lumayas ka Satanas! Gapu nakasulat, ‘En Panginoon mu a Diyos i dapat muwid a sambaán. Sakay siya la i dapat muwid a pagserbiyan.’ ” ");
INSERT INTO prfNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Káttapos ay linakadan siya nen diyablo. Dummemát bi en anghel hidi sakay sinerbiyan di ti Jesus. ");
INSERT INTO prfNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Dikona a nabareta ni Jesus a nepiresu ti Juan, ay nagsoli siya ti Galilea. ");
INSERT INTO prfNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Peru awan dán siya nágyan ti Nazaret nan ti Capernaum dán. Iyád a banuwan ay ked ten adeni nen gilid nen Minalnu ti Galilea a sakup ni Zabulon sakay Neftali. ");
INSERT INTO prfNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Nangyari iyud tánni matupad en kinagi ni Propeta Isaias a, ");
INSERT INTO prfNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“En lugar a Zabulon sakay en lugar a Neftali, ay dilan nen Hentil a tamu ten minalnu ten dibelyu ni Jordan ti Galilea nen Hentil hidi! ");
INSERT INTO prfNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","En tolay hidi a ked ten kadiklámman ay naketa ti mademlag a simbuwan! Para ten mágyan hidi ten diklám nen kamatayan ay sumikat en demlag.” ");
INSERT INTO prfNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Sapul ti panahunid a iyud ay nagsapul dán a mangaral ti Jesus. Kinagi na, “Magsisi kamon sakay adággan moy dán en kasalanan moy hidi gapu adeni dán a dumemát en kahariyan dilanget.” ");
INSERT INTO prfNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Essa a aldew, mentras a maglakad ti Jesus ten gilid nen Minalnu ti Galilea ay netan na en duwwa a matkaka a de Simon a dáddulawán di a Pedro sakay en kapatkaka na a ti Andres a kasalukuyan hidi a mamanti. ");
INSERT INTO prfNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Kinagi ni Jesus dikodi, “Mákkuyug kam dikoku, ta tolduwan takam a manilág ti tolay.” ");
INSERT INTO prfNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Pagdaka a inwarak nen matkaka en panti di hidi sakay nákkuyug hidi kánni Jesus. ");
INSERT INTO prfNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Nagtulos a naglakad ti Jesus sakay netan na bi en matkaka a de Santiago ay ti Juan a anak ni Zebedeo. Ked hidi ten abeng a kaguman di en ama di, sakay magayuma hidi ten panti di, sakay dinulaw bi hidi ni Jesus. ");
INSERT INTO prfNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Pagdaka di a linakadan en abeng sakay en ama di, sakay nákkuyug hidi kánni Jesus. ");
INSERT INTO prfNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Linebut ni Jesus en buu a Galilea. Nagtoldu siya ten sinagoga di hidi sakay impangaral na en Maganda a Bareta tungkul ten pághari nen Diyos. Sakay pinagpiyya na en tolay hidi ten saket di hidi. ");
INSERT INTO prfNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Nabareta nen tolay hidi ten lugar a Siria en tungkul ten ginamet hidi ni Jesus. Kaya inyangay di dikona en atanan nen tehud hidi a saket, en hinayup hidi, en mágpatay hidi sakay en lupug hidi. Atanan di ay pinagpiyya ni Jesus. ");
INSERT INTO prfNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Gapu ti iyud ay inumunonud dikona en makpal a tolay a gubwat ti Galilea, Decapolis, Jerusalem, Judea sakay maski en ked hidi ten dibelyu ni Jordan. ");
INSERT INTO prfNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Dikona a ketan ni Jesus en tunay ti kakpal a tolay ay summangkay siya ten marenggád a bukid. Káetnud na ay ummadeni dikona en disepulus na hidi, ");
INSERT INTO prfNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","sakay tinolduwan na hidi. Kinagi na a: ");
INSERT INTO prfNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Pinagpala en tolay hidi a en Diyos la i asaan diyid gapu mebilang hidi ten kahariyan nen Diyos. ");
INSERT INTO prfNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","“Pinagpala en tehud hidi a kalungkutan, gapu paraparaán hidi nen Diyos. ");
INSERT INTO prfNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","“Pinagpala en magpakababa hidi, gapu magin mana di i munduwiday. ");
INSERT INTO prfNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","“Pinagpala en tolay hidi a masor a manggamet ten kaluuban nen Diyos, gapu tulungan hidi nen Diyos a magamet iyád. ");
INSERT INTO prfNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","“Pinagpala en makákkagbiyán hidi, gapu kagbiyan bi hidi nen Diyos. ");
INSERT INTO prfNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","“Pinagpala en malinis hidi ti págpusuwan, gapu ketan di en Diyos. ");
INSERT INTO prfNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","“Pinagpala en maggamet hidi ti paraan para ten kapayapaan, gapu ibilang hidi a anak nen Diyos. ");
INSERT INTO prfNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Pinagpala en usigán hidi gapu ten kássunud di ten kaluuban nen Diyos, gapu mebilang hidi ten kahariyan nen Diyos. ");
INSERT INTO prfNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Pinagpala en insultuwán hidi sakay usigán, sakay pagbintangan ti atanan a kalasi ni madukás sakay kakabuliyan gapu dikoku. ");
INSERT INTO prfNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Magsaya kam gapu dikál en piremyu moy dilanget. Kona labi hud en ginággamet nen tolay hidi ten propeta hidi a nágdipalongu dikomoy.” ");
INSERT INTO prfNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Sikam ay asen ti munduwiday. Peru ni mawanan ti lasa en asen ay konya dán a mesoli en dati na a lasa? Awan dán iyád ti pakinabang, kaya ibut dán sakay pagyudakan dálla nen tolay hidi. ");
INSERT INTO prfNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Sikam ay demlag ti munduwiday. Awan metagu en siyudad a ked ten toktok nen marenggád a bukid. ");
INSERT INTO prfNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Awan bi ti magtab ti simbuwan sakay takáppan na ti timba. Nan itupu na iyud ten talaga a págtupuwan tánni mademlagan en atanan a ked ten bilay. ");
INSERT INTO prfNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Kona labi hud, dapat moy a pademlagán en simbuwan moy ten atubengán nen tolay hidi tánni ketan di en mágkaganda moy hidi a gamet, sakay puriyán di en Ama moy a ked dilanget.” ");
INSERT INTO prfNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Dyan moy isipán a ummangayák ti munduwiday a para pawanan ku ti bisa en Kautusan sakay en toldu nen propeta hidi. Ummangayák háddi bakán a pawanan hidi iyud ti bisa nan para tupadán. ");
INSERT INTO prfNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Tandaan moy: mawan en langet ay ten luta peru maski ni en kabaditan a bahagi nen Kautusan ay awan mamawan, hanggan ni awan mangyari en atanan. ");
INSERT INTO prfNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Kaya ni deyaman en manglabag ten maski kabaditan a bahagi nen Kautusan sakay magtoldu ti konahud ten tolay hidi ay magin kababaan ten kahariyan nen Diyos. Peru ni deyaman en mangsunud ten Kautusan sakay magtoldu ten tolay hidi a tupadán iyud ay magin mataas ten kahariyan dilanget. ");
INSERT INTO prfNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Peru kagiyán ku dikomoy a, ni en kássunud moy ten kaluuban nen Diyos ay kona la ten págsunud nen tagapagtoldu hidi nen Kautusan sakay nen Pariseo hidi, ay awan kam makasáddáp ten kahariyan nen Diyos.” ");
INSERT INTO prfNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Kinagi pa ni Jesus, “Nasanig moy a intoldu di ten ninunu moy hidi a, ‘Dyan ka mamunu; sakay ni deyaman en makabunu ay meatubeng ten pághatulan. ");
INSERT INTO prfNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Peru kagiyán ku bi dikomoy, a ni deyaman en maiyamut ten kapatkaka na ay meatubeng ten pághatulan. Sakay en mangkagi ten kapatkaka na a, ‘Awan ka ti kuwenta!’ ay meatubeng ten Sanedrin. Sakay ni deyaman en magkagi ten kapatkaka na a, ‘Nagareng ka!’ ay meangay ten apoy ti impiyerno ");
INSERT INTO prfNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Kaya ni magalay ka ten altar para ten Diyos sakay maala-ala mu a tehud a saket ni isip en kapatkaka mu dikomu, ");
INSERT INTO prfNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","ay iwarak mu pala en alay mu ten atubengán nen altar sakay angay ka mákpagkasundu dikona. Káttapos ay soli ka dán a magalay ten Diyos. ");
INSERT INTO prfNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Ni tehud a mángkasu dikomu, ay mákpagkasundu ka dikona a pagdaka bagu a meangay ten pághatulan en kasu mu. Ni awan mu iyud gamitán ay iyangay na ka ten huwes sakay iyangay ka nen huwes ten pulis a mángpiresu dikomu. ");
INSERT INTO prfNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Kagiyán ku dikomu: awan ka makaluwas haud mentras a awan mu mabayadan a hanggan ten katapusan a sentabos nen dapat mu a bayadan.” ");
INSERT INTO prfNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Nasanig moy dán a nakagi a, ‘Dyan ka mangalunya.’ ");
INSERT INTO prfNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Peru nadid ay kagiyán ku dikomoy a, ni deyaman en umileng ten essa a bábbi sakay mahalay en isip na ay nangalunya dán siya ti iyud a bábbi ten pusu na. ");
INSERT INTO prfNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Kaya ni en mata mu en dahilan nen págkasala ay lábwetán mu sakay ibut mu! Gapu mas maganda pa ni mawanan ka ti essa a bahagi nen bággi mu nan buu en bággi mu a meangay ti impiyerno. ");
INSERT INTO prfNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ni en kawanan mu a lima en dahilan nen págkasala mu ay káttulán mu iyud sakay ibut mu! Mas maganda pa a mawanan ka ti bahagi nen bággi mu nan buu en bággi mu a meangay ti impiyerno. ");
INSERT INTO prfNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Nakagi bi a, ‘Ni hiwalayan nen lállaki en kabinga na ay dapat a átdenan na ti kasulatan ni pághiwalay.’ ");
INSERT INTO prfNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Peru nadid ay kagiyán ku dikomoy, a ni hiwalayan nen essa a lállaki en kabinga na, puwera la ni nangalunya ay siya en nángtuglad ten kabinga na a mangalunya. Sakay ni deyaman en mangkabinga ten bábbi a hiniwalayan ay nangalunya bi.” ");
INSERT INTO prfNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Nasanig moy bi a inyutus nen Diyos ten ninunu moy hidi a, ‘Dyan ka manumpa ti awan ti katutuhanan, nan tupadán mu en sinumpaan mu ten Panginoon.’ ");
INSERT INTO prfNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Peru nadid ay kagiyán ku dikomoy, “Dyan kamon manumpa ni magpangaku kam. Dyan moy kagiyán a, ‘Tistigu ku dilanget.’ Gapu iyud en trono nen Diyos. ");
INSERT INTO prfNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Sakay dyan moy bi kagiyán a, “Tistigu ku i lutaiday,” gapu iyád en táttáppakan nen Diyos. Dyan moy bi kagiyán a, ‘Tistigu ku ti Jerusalem,’ gapu iyád en siyudad nen dakila a Hari. ");
INSERT INTO prfNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Dyan moy bi ipanumpa i ulu moyen, gapu maski ni essa a waget ti buuk moyen ay awan mu mapapudew oni mapangitet ");
INSERT INTO prfNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Kagiyán mu dálla a ‘Uhu’ ni uhu sakay ‘Awan’ ni awan. Gapu gubwat dán ten Madukás en ányaman a medagdag pa haud.” ");
INSERT INTO prfNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Nasanig moy a nakagi a, ‘Mata ti mata sakay ngipán ti ngipán.’ ");
INSERT INTO prfNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Peru nadid ay kagiyán ku dikomoy, dyan moy gantiyan en madukás a tolay. Ni dapangán di ka ten kawanan ay iyatubeng mu bi en kawiri. ");
INSERT INTO prfNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ni tehud a mángkasu dikomu tánni maalap na en badu mu ay iyatád mu dikona pati en alikábkáb mu. ");
INSERT INTO prfNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Ni ipilit dikomu nen essa a sundalu a pakarga en tawid na ti essa a kilumetru ay kargaán mu iyud ti duwwa a kilumetru. ");
INSERT INTO prfNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Mangatád ka ten magagid dikomu sakay dyan mu pakawanan en mangáddem dikomu.” ");
INSERT INTO prfNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Nasanig moy a nakagi a, ‘Mahalán mu en kaparehu mu a tolay sakay kaiyamutan mu en kadima mu.’ ");
INSERT INTO prfNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Peru nadid ay kagiyán ku dikomoy, a mahalán moy en kadima moy sakay ipagdasal moy en mangusig hidi dikomoy.” ");
INSERT INTO prfNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Ni konahud gamitán moyid ay magin tatarudan kam a anak nen Ama moy dilanget. Gapu pasikatán nen Diyos en aldew para ten mágkabait sakay ten mágkadukás a tolay sakay paudenán na para ten matuwid hidi sakay ten awan matuwid a tolay. ");
INSERT INTO prfNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","“Ni en mangmahal la dikomoy en mahalán moy ay awan kam ti mauray a piremyu moy. Gapu maski ni en mágsinger hidi ti buwes ay gággamitán di labi iyud. ");
INSERT INTO prfNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Sakay ni en batiyán moy la ay en kákkapatkaka moy hidi, ay ánya ginamet moyid a higit ten agum? Awan beman kona labi haán gággamitánnid nen Hentil hidi? ");
INSERT INTO prfNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Kaya magin ganap kam a kona ten Ama moy dilanget.” ");
INSERT INTO prfNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Ingatan moy a awan magin kukunwari la en pággamet moy ti maganda gapu ni konahud i gamitán moyid ay awan kam ti maalap a piremyu a gubwat ten Ama moy dilanget. ");
INSERT INTO prfNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Kaya ni mangatád ka ti limus ay dyan mu dán iyud ikákkagi a kona ten gággamitán nen magkukunwari hidi. Maglimus hidi ten sinagoga sakay ten karsada hidi tánni puriyán hidi ni tolay. Kagiyán ku dikomoy a natanggap di dán en piremyu di. ");
INSERT INTO prfNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Ni mangatád ka ti limus ay dyan mu dán ikákkagi maski ten amigu mu. ");
INSERT INTO prfNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Gamitán mu ti lihim en pángngatád mu, sakay en Ama a maketa ten maganda a ginamet mu ti lihim en mangatád dikomu ti piremyu.” ");
INSERT INTO prfNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Ni magdasal kam ay dyan moy arigán en magkukunwari hidi. Gugustu di a magdasal a mágtaknág ten sinagoga sakay ten karsada hidi. Kagiyán ku dikomoy, a tinanggap di dán en piremyu di. ");
INSERT INTO prfNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Kaya ni magdasal ka ay sumáddáp ka ten kuwartu mu sakay isiradu mu en pintuwan. Sakay magdasal kam ten Ama a awan ketan, sakay en Ama mu a maketa ten ginamet mu ti lihim en mangatád dikomu ti piremyu. ");
INSERT INTO prfNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Ni magdasal kam ay dyan kam maggamit ti makpal a upos a awan ti kahulugan, a kona ten gággamitán nen Hentil hidi. Akala diyid ay sanigán hidi nen Diyos gapu ten kakpal nen kákkagiyán di. ");
INSERT INTO prfNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Dyan moy hidi arigán. Tukoy dán nen Ama moy en kailangan moy bagu moy pa iyud a agidán dikona. ");
INSERT INTO prfNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Kaya ni magdasal kam ay kona háddi: ‘Ama mi a ked dilanget, sambaán nakuwan en ngaran mu. ");
INSERT INTO prfNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Maghari ka nakuwan dikomi. Masunud nakuwan en kaluuban mu ti lutaiday a kona dilanget. ");
INSERT INTO prfNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Átdenan mu kami nadid ti pagkain a aldew-aldew; ");
INSERT INTO prfNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","sakay patawadán mu kami ten kasalanan mi hidi, a kona ten págpatawad mi ten magkasala hidi dikomi. ");
INSERT INTO prfNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Sakay dyan mu kami pabayan a matoksu, nan iligtas mu kami ten Madukás!’ Gapu kao mu en kahariyan, en kapangyariyan sakay kaluwalhatian a awan ti katapusan! Amen. ");
INSERT INTO prfNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Gapu ni patawadán moy en nagkasala hidi dikomoy, ay patawadán kam bi nen Ama moy dilanget. ");
INSERT INTO prfNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Peru ni awan moy patawadán en agum, ay awan bi patawadán nen Ama moy en kasalanan moy hidi.” ");
INSERT INTO prfNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Ni magkulásyon kam ay dyan moy ipeta en rupa moy a malungkut a kona ten gággamitán nen magkukunwari hidi. Awan hidi magayus ten sadili di tánni matukuyan nen agum a magkulásyon hidi. Kagiyán ku dikomoy, a tinanggap di dán en piremyu di. ");
INSERT INTO prfNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Kaya ni magkulásyon ka ay magudemos ka sakay maglangis ka ten buuk mu, ");
INSERT INTO prfNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","tánni awan mapansin nen tolay hidi a magkulásyon ka. En Ama mu a awan mu ketan i makatukoy laid ten ginamet mu ti lihim, sakay siya i mangatáddid dikomu ti piremyu.” ");
INSERT INTO prfNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Dyan kam magpuron ti kayamanan ti lutaiday, gapu tehud a magsida a insektu sakay kalawang, sakay tehud a makasáddáp a mágtakaw. ");
INSERT INTO prfNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Nan magpuron kam ti kayamanan moy dilanget ta awan haud ti mangsida a insektu sakay kalawang, sakay awan ti makasáddáp a mágtakaw. ");
INSERT INTO prfNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Gapu ni ked hádya en kayamanan moy, ay ked bi haud en pusu moy.” ");
INSERT INTO prfNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“En mata en pinakasimbuwan nen bággi. Ni malinaw en pangileng mu, ay mademlagan en buu mu a bággi. ");
INSERT INTO prfNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Peru ni madiklám en pangileng mu, ay maputat ti kadiklámman en buu mu a bággi. Sakay ni en demlag mu ay madiklám ay talaga a ked ka ten kadiklámman.” ");
INSERT INTO prfNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Awan ti alipin a makapagserbi ti sabay ten duwwa a amu, gapu kaiyamutan na en essa sakay mahalán na en essa, magtapat siya ten essa sakay awan siya magin tapat ten kaduwwa. Awan kam maari a magserbi ti sabay ten Diyos sakay ten kayamanan. ");
INSERT INTO prfNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Kaya kagiyán ku dikomoy, dyan kam mabalisa tungkul ten kanán moy sakay mainom tánni mabiyag kam oni tungkul ten ibadu moy ten bággi moy. Awan beman mas mahalaga en biyag nan en pagkain, sakay en bággi nan en badu? ");
INSERT INTO prfNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Ilingán moy en ibun hidi. Awan hidi magmula oni magani oni magpuron ti pagkain ten budega di, peru pakanán hidi nen Ama moy dilanget. Awan beman a mas mahalaga kam nan en ibun hidi? ");
INSERT INTO prfNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Deya dikomoy i makapangpaatakdugid ten biyag na ti maski ni essa a odas ten pamamag-itan nen págbabalisa na? ");
INSERT INTO prfNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Sakay bakin mabalisa kam tungkul ti badu? Isipán moy dálla ni konya a magtubu en bulaklak hidi ten kaparangan, awan hidi magtarabahu oni maggamet ti badu. ");
INSERT INTO prfNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Peru kagiyán ku dikomoy, a maski ti Solomon a tunay ti yaman ay awan nakapagbadu ti kaparehu ti ganda nen essa ten bulaklak hidi. ");
INSERT INTO prfNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Ni en lamon hidi ten parang, a biyag nadid sakay ten kailawan ay tutudán ay baduwan nen Diyos, sikam pa beman? Ánya dán ben ti kabadit en pánnampalataya moy ten Diyos! ");
INSERT INTO prfNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“Kaya dyan kam mabalisa tungkul ten makan, mainom oni mesulot moy. ");
INSERT INTO prfNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Gapu hidi iyád a bagay en kákkabalisaan nen Hentil hidi. Tukoy nen Ama moy dilanget a kailangan moy i atananid a hidi iyád a bagay. ");
INSERT INTO prfNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Peru higit ten atanan ay pagsikapan moy a paghariyan kam nen Diyos sakay mabiyag a ayun ten kaluuban na sakay iyatád na dikomoy en atanan nen kailangan moy. ");
INSERT INTO prfNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","“Kaya dyan moy kabalisaan en para ten kailawan, gapu en kailawan ay tehud dán a sadili a kabalisaan. Dyan moy dán dagdagan pa en problema moy kada aldew.” ");
INSERT INTO prfNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Dyan moy hatulan en agum tánni awan kam bi hatulan nen Diyos. ");
INSERT INTO prfNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Gapu hatulan kam nen Diyos ayun ten pághatul moy ten agum, sakay pagsukatan bi nen Diyos para dikomoy en ginamit moy ten agum. ");
INSERT INTO prfNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Bakin barángngán mu en puleng nen kapatkaka mu, samantala awan mu mabaráng i gaturosuwen a puleng ti mata muwen? ");
INSERT INTO prfNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Konya mu a makagi ten kapatkaka mu a, ‘Karon hád ta ibutan ku i puleng muwen,” samantala gaturosu labi i puleng muwen? ");
INSERT INTO prfNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Siko a magkukunwari! Ibutan mu pa i gaturosuwen a puleng mu tánni luminaw pangileng muwen sakay makatulung ka a mangibut ten puleng nen kapatkaka mu. ");
INSERT INTO prfNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Dyan moy iyatád ten asu hidi en banal a bagay, bakay káttapos ay waringán di kam sakay kagatán. Dyan moy iyatád ten babuy en perlas moy hidi gapu pagyudakan di la iyán.” ");
INSERT INTO prfNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Ni magagid kam ay atáddan kam; ni magaryok kam ay maketa kam; ni tumoktok kam ay mabukasan kam. ");
INSERT INTO prfNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Gapu en atanan a magagid ay átdenan; en atanan a magaryok ay maketa; sakay atanan a tumoktok ay mabukasan. ");
INSERT INTO prfNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Atáddan moy beman ti batu en anak moy ni magagid ti tinapay? ");
INSERT INTO prfNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Oni atáddan moy beman siya ti biklat ni magagid ti ikan? ");
INSERT INTO prfNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Ni sikam a makasalanan hidi ay tukoy moy a mangatád ti mágkaganda hidi a bagay ten anak moy hidi, ay mas lalu dán en Ama moy a ked dilanget. Átdenan na ti mágkaganda a bagay en deyaman a magagid dikona. ");
INSERT INTO prfNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Gamitán moy ten agum en gustu moy a gamitán di dikomoy. Iyád en kahulugan nen Kautusan sakay en intoldu nen propeta hidi.” ");
INSERT INTO prfNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Sumáddáp kam ten mapiit a pintuwan. Gapu malawa en pintuwan sakay malabang en dilan a patamu ten kapahamakan, sakay haud paglakadanid nen kakpalan. ");
INSERT INTO prfNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Peru mapiit en pintuwan sakay makitid en dilan a tamu ten biyag, sakay sasangan la en maglakad haud.” ");
INSERT INTO prfNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Magingat kam ten awan hidi tatarudan a propeta. Umangay hidi dikomoy a kumán a tupa, peru tatarudanid ay mágkatapang hidi a asu ti talon. ");
INSERT INTO prfNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Matenggi moy hidi ten pamamag-itan nen gamet di hidi. Maari beman a magbunga ti ubas oni igos en masaet a dawag? ");
INSERT INTO prfNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","En maganda a kayu ay magbunga ti maganda peru en madukás a kayu ay magbunga ti madukás. ");
INSERT INTO prfNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Awan makapagbunga ti madukás en maganda a kayu sakay awan makapagbunga ti maganda en madukás a kayu. ");
INSERT INTO prfNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","En bawat ponan a awan magbunga ti maganda ay pukanán sakay ibut ten apoy. ");
INSERT INTO prfNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Kaya matenggi en awan hidi tatarudan a propeta ten pamamag-itan nen gamet di hidi.” ");
INSERT INTO prfNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Awan atanan a mangdulaw dikoku ti, ‘Panginoon, Panginoon,’ ay makasáddáp ten kahariyan nen Diyos, nan en atanan la nen sumunud ten kaluuban nen Ama ku a ked dilanget.” ");
INSERT INTO prfNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Káddemát nen Aldew nen Pághatul ay makpal a magkagi dikoku a, ‘Panginoon, nagpahayag kami ti mensahi a gubwat ten Diyos, sakay nagpalayas kami ti dimonyo ten pamamag-itan nen ngaran mu, sakay naggamet kami ti himala ten pamamag-itan nen ngaran mu.’ ");
INSERT INTO prfNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Peru itábbig kuwid dikodi ay, ‘Awan takam matenggi, umadeyu kam dikoku, sikam a mággamet hidi ti madukás.’ ” ");
INSERT INTO prfNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Kaya ni deyaman en mágsanig sakay sumunud ten upos ku hidi ay kona ten essa a matalinu a tolay a nagpataknág ti bilay a nepundasyon ti batu. ");
INSERT INTO prfNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Maski ni maguden ti mabegsák, dumikál en dinom sakay bumugsu en mabegsák a parás ay awan marábba gapu nakapundasyon ten batu. ");
INSERT INTO prfNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Peru ni deyaman en mágsanig ten upos ku sakay awan na iyud sunudán ay kona ten essa a tolay a mangmang a nagpataknág ti bilay ten baybay. ");
INSERT INTO prfNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Nadid naguden ti mabegsák, dummikál en dinom, sakay bummugsu en mabegsák a parás. En bilay ay minatumba sakay tulos a narábba.” ");
INSERT INTO prfNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Minagtaka en tolay hidi dikona a nasanig di en págtoldu ni Jesus. ");
INSERT INTO prfNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Gapu en págtoldu na ay tehud a kapangyariyan, bakán a kona ten tagapagtoldu hidi nen Kautusan. ");
INSERT INTO prfNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Dikona a nakadagson dán ti Jesus ten bukid ay inunud siya nen tunay ti kakpal a tolay. ");
INSERT INTO prfNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Ummadeni dikona en essa a tolay a kinetong, lummuhud siya ten atubengán ni Jesus sakay kinagi na, “Panginoon ni gustuwán mu ay mapagpiyyaák mu sakay mapagin-malinis.” ");
INSERT INTO prfNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Tinawidan siya ni Jesus sakay kinagi na, “Uhu, gustu ku a magpiyya ka sakay magin malinis.” Nagpiyya sakay linuminis a pagdaka en kinetong. ");
INSERT INTO prfNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Sakay kinagi ni Jesus dikona, “Dyan mu iyád kagiyán maski ni kándeya. Kadmudán, angay ka paileng ten padi hidi. Káttapos ay magalay ka ayun ten inyutus ni Moises, bilang patunay ten tolay hidi a nagpiyya ka dán sakay malinis.” ");
INSERT INTO prfNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Nadid, ten dikona a nakademát ti Jesus ten banuwan a Capernaum ay ummadeni dikona en kapitan nen sundalu hidi a Romano sakay nákkekagbi dikona. ");
INSERT INTO prfNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Kinagi na, “Panginoon en katulung ku ay tehud a saket, ked siya dibilay a awan makaarikad sakay mahirapan ti hustu.” ");
INSERT INTO prfNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Tummábbig ti Jesus, “Sigi angay ku siya pagpiyyaán.” ");
INSERT INTO prfNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Peru tummábbig en kapitan, “Panginoon, awanák karapatdapat a angayan mu pa ten bilay ku. Basta kagiyán mu la ay magpiyya dán iyud en katulung ku. ");
INSERT INTO prfNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Gapu maski sikán ay tehud a mas mataas a upisyal a magutus dikoku sakay sikán ay magutusák bi ten sundalu hidi a sakup ku. Ni kagiyán ku ten sundalu ku a essa a, ‘Angay ka haud!’ ay angay siya. Ni kagiyán ku bi ten essa a, ‘Karon hád!’ ay umadeni siya. Sakay ni utusan ku en alipin ku a, ‘Gamitán mu iyán!’ ay gamitán na iyud.” ");
INSERT INTO prfNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Nadid ten dikona a masanig iyud ni Jesus ay nagtaka siya sakay kinagi na ten tolay hidi a umunonud dikona, “Kagiyán ku dikomoy, a awanák palla naketa ti Israelita a kona ti kadikál ti pánnampalataya naen. ");
INSERT INTO prfNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Kagiyán ku dikomoy, a makpal a dumemát a gubwat ti sikatan sakay ti sarámman ten handaan a kaguman de Abraham, Isaac sakay ti Jacob ten kahariyan dilanget. ");
INSERT INTO prfNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Peru makpal ten tolay hidi a kaguman nakuwan ten kahariyan en ibut ten kadiklámman. Mágsasangitán hidi haud sakay magpákraw gapu ten hirap a mabati di. ");
INSERT INTO prfNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Sakay kinagi ni Jesus ten kapitan, “Umuli ka dán mangyari en agidán mu ayun ten pánnampalataya mu.” Ti odasid a iyud ay nagpiyya ngani en katulung na. ");
INSERT INTO prfNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Nadid, ummangay ti Jesus ten bilay ni Pedro, netan na haud en bábbi a katugngan ni Pedro a mágkatdug gapu ten ladu na. ");
INSERT INTO prfNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Tinawidan ni Jesus en lima nen bábbi sakay pagdaka a nagpiyya. Ummikat siya sakay sinerbiyan na ti Jesus. ");
INSERT INTO prfNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Ti gibiyid a iyud ay inyangay nen tolay hidi kánni Jesus en hinayup hidi. Ten essa la a upos ay pinalakad ni Jesus en mágkadukás hidi a ispiritu sakay pinagpiyya na en atanan a tehud a saket. ");
INSERT INTO prfNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Iyud ay nangyari tánni matupad en kinagi ni propeta Isaias a, “Inibutan na en kahinaan tam hidi, sakay pinagpiyya na en saket tam hidi.” ");
INSERT INTO prfNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Nadid, ten dikona a napansin ni Jesus a makpal a tolay ten palebut na ay kinagi na ten disepulus na hidi a umarabes hidi ten dibelyu. ");
INSERT INTO prfNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Peru bagu hidi a ummarabes ay tehud a ummadeni dikona a essa a tagapagtoldu nen Kautusan sakay kinagi na, “Maistu, mákkuyugák dikomu maski ni hádya i angayan muwid.” ");
INSERT INTO prfNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Tummábbig ti Jesus, “En asu hidi ti talon ay tehud a págyanan sakay en ibun hidi ay tehud a lobun. Peru en Anak nen Tolay ay awan ti matidugan oni maimangan.” ");
INSERT INTO prfNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Sakay nagtanung bi dikona en essa ten disepulus na hidi, “Panginoon maari wád a umuliyák pa tánni mepalábbáng ku en ama ku?” ");
INSERT INTO prfNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Peru tinábbig siya ni Jesus, “Mákkuyug ka dán dikoku. Pabayan mu dán a ilábbáng nen patay hidi en patay di.” ");
INSERT INTO prfNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Summakay ti Jesus ten abeng, kaguman na en disepulus na hidi. ");
INSERT INTO prfNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Mentras a magarabes hidi ay tidug ti Jesus. Bigla a binumugsu en mabegsák a parás sakay ngari-ngari dán a taporan nen tagmák en abeng. ");
INSERT INTO prfNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Kaya linukag siya nen disepulus na hidi sakay kinagi di, “Panginoon tulungan mu kami. Umállád kitamon!” ");
INSERT INTO prfNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Sakay kinagi na dikodi, “Bakin manteng kam? Ánya dán ben ti kabadit en pánnampalataya moy!” Ummikat siya sakay sinaway na en parás ay ten tagmák, sakay ginumanda en panahun. ");
INSERT INTO prfNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Nagtaka hidi a atanan, sakay kinagi di, “Ánya wád iyád a kalasi ni tolay? Maski parás sakay tagmák ay sumunud dikona!” ");
INSERT INTO prfNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Dikona nakademát ti Jesus ten dibelyu, ten lugar nen taga-Gadara hidi ay tinagbu siya nen duwwa a lállaki a hinayup. Mágyan hidi ten páglábbángngan. Mágkatapang hidi kaya awan ti deyaman a makatalib haud. ");
INSERT INTO prfNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Bigla a nagpákrawan en duwwa a lállaki, “Ánya i gustu muwid dikomi, siko a Anak nen Diyos? Ummangay ka beman háddi tánni parusaan mu kami dán maski ni awan palla panahun?” ");
INSERT INTO prfNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Nadid, makpal a babuy a ked ten adeni di a mamagsábbukan. ");
INSERT INTO prfNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Nákkekagbi dikona en dimonyo hidi, “Ni palayasán mu kami ay pasáddáppán mu kami dálla ti babuyud hidi.” ");
INSERT INTO prfNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Kinagi ni Jesus dikodi, “Sigi, kadmoy dán haud.” Lummuwas ngani en dimonyo hidi ten duwwa a lállaki sakay summáddáp hidi ten kababuyan. Sakay en kababuyan ay namagginanan ten pengpeng sakay summegbu hidi ten minalnu, sakay tulos hidi a minágkalimás. ");
INSERT INTO prfNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Ginuminan en mágbantay hidi ten kababuyan a tamu ten banuwan. Káddemát di haud, ay imbábbareta di ten atanan en nangyari; pati en nangyari ten duwwa a hinayup. ");
INSERT INTO prfNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Ten dikona a matukuyan iyud nen katolayan ay lummuwas hidi ten banuwan tánni tagbuwán di ti Jesus. Sakay ten dikona a ketan di siya ay nákkekagbi hidi a lumakad siya ten lugar di. ");
INSERT INTO prfNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Kaya summakay ti Jesus ten abeng sakay ummarabes ten dibelyu, sakay tummulos siya ten sadili na a banuwan. ");
INSERT INTO prfNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Káddemát di haud ay tehud a sangan a tolay a náng-angay kánni Jesus ti essa a lupug a mágkatdug ten págkatdugan na. Dikona a ketan ni Jesus ni sakonya ti kadikál en pánnampalataya di ay kinagi na ten tolay a lupug, “Anak, begsákkan mu i isip muwen! Gapu pinatawad dán en kasalanan mu hidi.” ");
INSERT INTO prfNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Nadid, tehud a sangan a tagapagtoldu nen Kautusan a ked haud sakay kinagi di ten sadili di, “Awan ti galang ten Diyos i tolayid a iyán!” ");
INSERT INTO prfNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Peru tukoy ni Jesus en ked ten isip di kaya kinagi na dikodi, “Bakin magisip kam ti kona haán? ");
INSERT INTO prfNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Ánya beman i mas alistuwid a kagiyán, ‘pinatawad dán en kasalanan mu,’ oni en kagiyán a, ‘tumaknág ka sakay maglakad ka?’ ");
INSERT INTO prfNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Patunayan ku dikomoy a en Anak nen Tolay ay tehud a kapangyariyan a magpatawad ti kasalanan ti lutaiday, sakay kinagi na ten tolay a lupug, “Tumaknág ka, tawidán mu i págkatdugan muwen sakay umuli ka dán.” ");
INSERT INTO prfNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Pagdaka a tummaknág en lupug sakay ummuli. ");
INSERT INTO prfNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Ten dikona a ketan iyud nen tolay hidi ay neántingan hidi sakay nagpuri hidi ten Diyos a nangatád ten tolay hidi ti konahud a kapangyariyan. ");
INSERT INTO prfNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Nadid, dikona a lummakad ti Jesus haud ay netan na ti Mateo a mággetnud ten págsingeran ti buwes. Kinagi dikona ni Jesus, “Mákkuyug ka dikoku a magin tagapagserbi ku.” Kaya tummaknág ti Mateo sakay nákkuyug dikona. ");
INSERT INTO prfNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Nadid mentras a kuman de Jesus sakay en disepulus na hidi ten bilay ni Mateo, ay dummemát en mágsinger hidi ti buwes sakay en makasalanan hidi, náksabay hidi a kumman kánni Jesus. ");
INSERT INTO prfNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Dikona ketan iyud nen Pariseo hidi ay tinanung di en disepulus hidi ni Jesus, “Bakin maistu moyen ay mákpággatubeng a kuman ti mágsingiren hidi ti buwes sakay ti makasalananen hidi?” ");
INSERT INTO prfNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Peru nasanig iyud ni Jesus kaya tinábbig na hidi, “En mangailangan ti mággamot ay en tolay hidi a tehud a saket, bakán a en awan hidi ti saket. ");
INSERT INTO prfNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Intendiyán moy i kahuluganid ni iddi: ‘Habag i gustu kuwid bakán a en alay moy.’ Gapu ummangayák háddi tánni dulawán ku en makasalanan hidi, bakán a en matuwid hidi.” ");
INSERT INTO prfNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Ummangay kánni Jesus en disepulus hidi ni Juan a Mágbinyag, sakay intanung di, “Sikami sakay en Pariseo hidi ay mágkulásyon. Bakin i disepulus muwen hidi ay awan mágkulásyon?” ");
INSERT INTO prfNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Tummábbig ti Jesus, “Maari beman a maglungkut en bisita hidi ten kasalan mentras a kakaguman di en lállaki a kinasal? Ni dumemát en panahun a awan dán siya ay haud palla hidi a magkulásyon.” ");
INSERT INTO prfNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Awan ti magáppol ti bigu a risatu ten dati dán a damit, gapu ni kumárrán en bigu a risatu ay mabatak na en ináppulan kaya lalu a lumawa en pisad nen damit. ");
INSERT INTO prfNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Awan bi ti magasák ti bigu a alak ten dati a pággasákkan a gamet ti koblet ni hayup. Ni konahud i mangyariyid ay pumáddek en dati a pággasákkan, mebulak en alak sakay masida en pággasákkan. Nan en bigu a alak ay dapat a iyasák ten bigu a pággasákkan, tánni parehu a magmalay.” ");
INSERT INTO prfNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Nadid, mentras a mákpágguron ti Jesus dikodi ay tehud a dummemát a essa a pinunu nen Judio hidi. Lummuhud siya ten atubengán ni Jesus sakay kinagi na, “Kákkatay la nen anak ku a bábbi; peru ni mákkuyug ka dikoku sakay itupu mu i lima muwen dikona ay mabiyag siya a ruway.” ");
INSERT INTO prfNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Kaya tummaknág ti Jesus sakay en disepulus na hidi sakay nákkuyug hidi ten pinunu. ");
INSERT INTO prfNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Nadid ay tehud a ummunud dikodi a essa a bábbi a sapulu ay ti duwwa dán a taon a mágdadigiyán. Ummadeni siya sakay tinawidan na en garayan nen badu ni Jesus. ");
INSERT INTO prfNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Gapu kinagi nen bábbi ten sadili na, “Matawidan ku la i badu naen ay magpiyyaák dán.” ");
INSERT INTO prfNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Lummingat ti Jesus sakay dikona a netan na siya ay kinagi na, “Anak begsákkan mu i isip muwen, pinagpiyya ka nen pánnampalataya mu.” Ti odas biyid a iyud ay nagpiyya en bábbi. ");
INSERT INTO prfNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Káddemát ni Jesus ten bilay nen pinunu ay netan na en mágtugtug hidi ti pangpatay sakay en makpal a tolay a mamagsangetan. ");
INSERT INTO prfNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Kinagi ni Jesus dikodi, “Lumuwas kam pa. Awan patay i anaken, tidug la siya!” Dikona a makagi na iyud ay pinágtatawaan di siya. ");
INSERT INTO prfNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Dikona a mapaluwas na dán en tolay hidi ay summáddáp siya ten kuwartu, sakay tinawidan na en lima nen anak sakay ummikat. ");
INSERT INTO prfNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","En bareta tungkul ti iyud a nangyari ay kummalat ti buuwid a iyud a lugar.” ");
INSERT INTO prfNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Nadid, kállakad ni Jesus haud ay inunud siya nen duwwa a burák a lállaki. Mentras a ked hidi ten dilan ay impákraw di, “Anak ni David, kagbiyan mu kami pay!” ");
INSERT INTO prfNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Dikona nakasáddáp dán ti Jesus ten bilay ay ummadeni dikona en duwwa a burák. Tinanung hidi ni Jesus, “Manampalataya kam beman a mapagpiyya takam?” “Opo, Panginoon!” tábbig nen duwwa a burák. ");
INSERT INTO prfNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Tinawidan ni Jesus en mata di sakay kinagi na, “Magpiyya kam gapu ten pánnampalataya moy.” ");
INSERT INTO prfNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Naketa ngani hidi. Sakay mahigpit hidi a binilin ni Jesus a dyan di iyud kagiyán maski kándeya. ");
INSERT INTO prfNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Peru ten dikona lummakad dán hidi, ay imbábbareta di ti lugarid a iyud en ginamet ni Jesus dikodi. ");
INSERT INTO prfNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Dikona palakad dán hidi ay inyangay di kánni Jesus en essa a bulol a hinayup. ");
INSERT INTO prfNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Pinalakad ni Jesus en dimonyo sakay pagdaka a nakapagupos en bulol. Minagtaka en tolay hidi sakay kinagi di, “Maski ni nengkan ay awan palla ti nangyari a kona haád ti Israeliday!” ");
INSERT INTO prfNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Peru kinagi nen Pariseo hidi, “En pinunu nen dimonyo hidi i nangatáddid dikona ti kapangyariyan a magpalayas ten dimonyo hidi.” ");
INSERT INTO prfNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Linebut ni Jesus en atanan a banuwan sakay baryu haud. Nagtoldu siya ten sinagoga di sakay impangaral na ten sinagoga en Maganda a Bareta tungkul ten pághari nen Diyos. Pinagpiyya na bi en atanan a tolay a tehud a saket. ");
INSERT INTO prfNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Dikona a ketan ni Jesus en makpal a tolay, ay nahabag siya dikodi gapu mabalisa hidi sakay awan hidi ti mapagagidan ti tulung, kumán hidi a tupa a awan ti magalaga. ");
INSERT INTO prfNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Kaya kinagi na ten disepulus na hidi, “Makpal dán a gapasán, peru sasangan la en maggapas. ");
INSERT INTO prfNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Ipagdasal moy ten makákkao ten gapasán a mángpaangay siya ti makpal a mággapas.” ");
INSERT INTO prfNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Nadid ay dinulawan ni Jesus en disepulus na hidi sakay inatáddan na hidi ti kapangyariyan a magpalayas ti mágkadukás a ispiritu sakay magpapiyya ten tehud hidi a saket. ");
INSERT INTO prfNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Hidi iddi en ngaran nen sapulu ay ti duwwa a apostol: en purumeru ay ti Simon a ngángngaranan a Pedro, sakay ti Andres a kapatkaka na, de Santiago ay ti Juan a anak ni Zebedeo; ");
INSERT INTO prfNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","ti Felipe, ti Bartolome, ti Tomas, sakay ti Mateo a mágsinger ti buwes; ti Santiago a anak ni Alfeo, sakay ti Tadeo. ");
INSERT INTO prfNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Ti Simon a Makabanuwan sakay ti Judas Iscariote, a nángtokyon kánni Jesus. ");
INSERT INTO prfNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Inutusan hidi ni Jesus sakay binilin na hidi ti kona háddi, “Dyan kam umangay ten lugar nen Hentil hidi oni hádya man a banuwan nen Samaritano hidi. ");
INSERT INTO prfNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Nan aryokán moy en nágketawtaw hidi a tupa, ten tolay hidi nen Diyos ti Israel. ");
INSERT INTO prfNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Ipangaral moy dikodi a adeni dán a dumemát en kahariyan dilanget. ");
INSERT INTO prfNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Pagpiyyaán moy en tehud hidi a saket sakay biyagán moy en patay hidi. Pagpiyyaán moy bi en kinetong hidi, sakay palayasán moy en dimonyo hidi. Nakatanggap kam ti tulung a awan ti bayad. Kaya tumulung kam bi a awan ti bayad. ");
INSERT INTO prfNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Dyan kam magbalon ten lakad moy ti pilak, gintu, silber oni tangsu, ");
INSERT INTO prfNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","dyan kam bi magbalon ti paglewasan moy, riserba a sandalyas oni sarukud, gapu en tarabahador ay karapatdapat a tumanggap ten bagay hidi a kabiyagan na. ");
INSERT INTO prfNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Hádyaman a banuwan oni baryu en angayan moy ay magaryok kam ti tolay a karapatdapat a páktulusan, sakay tumulos kam haud hanggan a awan kam lumakad ti lugarid a iyud. ");
INSERT INTO prfNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Kássáddáp moy ten bilay a tulusan moy ay kagiyán moy a, ‘Nakuwan ay maghari en kapayapaan ti bilayid a iyád!’ ");
INSERT INTO prfNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Ni awan maganda en pángtanggap dikomoy nen makábbilay ay bawiyán moy en págbati moy a kapayapaan dikodi. Peru ni maganda en pángtanggap di dikomoy ay dyan moy dán bawiyán. ");
INSERT INTO prfNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Peru ni awan kam tanggapán oni sanigán nen tolay hidi ten essa a bilay oni banuwan ay lumakad kam sakay ipagpag moy en alikabuk ten babásset moy. ");
INSERT INTO prfNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Kagiyán ku dikomoy, a ten Aldew nen Pághatul ay mas madággi en parusa nen tolay hidi a awan nangtanggap dikomoy ti banuwanid a iyud nan ten parusa a dinanas nen taga-Sodoma sakay nen taga-Gomorra hidi. ");
INSERT INTO prfNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Tandaan moy: utusan takam a kumán a tupa ten ditángnga nen asu hidi ti talon. Kaya magin matalinu kam a kona ten biklat sakay magin maamu a kona ten kalapati. ");
INSERT INTO prfNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Magingat kam gapu tehud a mangdikáp dikomoy sakay ikasu di kam, sakay haplitán di kam ten sinagoga di hidi. ");
INSERT INTO prfNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Gapu dikoku ay ikasu di kam ten gubernador hidi sakay ten hari hidi tánni magpatunay kam dikodi sakay ten Hentil hidi ten Maganda a Bareta. ");
INSERT INTO prfNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Ti odasid a iyud ay dyan kam mabalisa ni ánya kagiyán moyid, oni ni konya kam a magpatunay. Gapu ipagkaluub dikomoy ni ánya i dapat moyid a kagiyán. ");
INSERT INTO prfNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Gapu bakán a sikam en magupos nan en Ispiritu nen Ama moy ten pamamag-itan moy. ");
INSERT INTO prfNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Itokyon nen kapatkaka na en sadili na a kapatkaka tánni pabunu, kona bi hud gamitánnid ten ama ten anak na; sakay labanan nen anak hidi en dáddikál di hidi sakay pabunu di hidi. ");
INSERT INTO prfNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Kaiyamutan kam nen atanan gapu ten págsunud moy dikoku. Peru en manatili a matapat dikoku hanggan ten katapusan ay maligtas. ");
INSERT INTO prfNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Ni usigán di kam ten essa a banuwan ay guminan kam ten kadeni na a banuwan. Tandaan moy, “Awan moy palla naangayan en atanan a banuwan ti Israel ay dumemát dán en Anak nen Tolay.” ");
INSERT INTO prfNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Awan ti disepulus a mas mataas nan en maistu na, sakay awan ti alipin a mas mataas ten amu na. ");
INSERT INTO prfNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Dapat a masiyaan en disepulus a magkakona ten maistu na, sakay en alipin a magkakona ten amu na. Ni en ama ay nginaranan di a Beelzebul, ay lalu di a laitán en kabilay na hidi.” ");
INSERT INTO prfNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Kaya dyan kam manteng dikodi. Atanan a netagu ay meluwas sakay atanan a sekretu ay matukuyan. ");
INSERT INTO prfNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","En kagiyán ku dikomoy ten kadiklámman ay ikagi moy a ruway ten demlag. Sakay en nasanig moy a anasas ay ipákraw moy ten matolay a lugar. ");
INSERT INTO prfNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Dyan moy kantingan en makabunu hidi ten bággi peru awan makabunu ten kaluluwa. Nan en dapat moy a kantingan ay en Diyos a makabunu ten bággi sakay ten kaluluwa ti impiyerno. ");
INSERT INTO prfNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Awan beman en duwwa a dignás ay tunay la ti kamuraan ni ilaku? Konapamanhud ay awan hidi matay ni awan kaluuban nen Ama moy. ");
INSERT INTO prfNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Maski sikam, tukoy nen Diyos ni sangan bilangid ni buuk moyen. ");
INSERT INTO prfNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Kaya dyan kam manteng gapu mas mahalaga kam nan en dignás hidi.” ");
INSERT INTO prfNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Ni deyaman en mangtenggi dikoku ten atubengán nen katolayan ay tenggiyán ku bi ten atubengán nen Ama ku dilanget. ");
INSERT INTO prfNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Peru ni deyaman en mángkasaniki dikoku ten atubengán nen katolayan ay, ikasaniki ku bi ten atubengán nen Ama ku a ked dilanget.” ");
INSERT INTO prfNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Dyan moy isipán a ummangayák háddi tánni magtawid ti kapayapaan; nan ummangayák háddi tánni magtawid ti ispada bakán a kapayapaan. ");
INSERT INTO prfNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Ummangayák háddi tánni paglabanán en anak a lállaki sakay en ama na, sakay en anak a bábbi sakay en ina, sakay en magkatugngan a bábbi. ");
INSERT INTO prfNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Sakay en magin kadima nen essa a tolay ay en sadili na dán a kabilay.” ");
INSERT INTO prfNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Ni deyaman en mangmahal ten ama na oni ten ina na ti mas higit dikoku ay awan karapatdapat dikoku. Sakay en mangmahal ten anak na ti mas higit dikoku ay awan karapatdapat dikoku. ");
INSERT INTO prfNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Sakay ni deyaman en awan mangbáklay ten kudus na sakay sumunud dikoku ay awan karapatdapat dikoku. ");
INSERT INTO prfNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Ni deyaman en magingat ten biyag na ay mawanan ti biyag. Peru en mawanan ti biyag alang-alang dikoku ay siya en magkahud ti biyag.” ");
INSERT INTO prfNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Ni deyaman en mangtanggap dikomoy ay sikán tinanggap diyid. Sakay en mangtanggap dikoku ay en nangutus dikoku i tinanggap diyid. ");
INSERT INTO prfNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Ni deyaman en mangtanggap ten essa a propeta gapu siya ay propeta ay makatanggap ti piremyu a nelaan para ten essa a propeta. Sakay ni deyaman en mangtanggap ten tolay a matuwid gapu siya ay matuwid ay makatanggap ti piremyu a nelaan para ten matuwid a tolay. ");
INSERT INTO prfNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Kagiyán ku dikomoy, a ni deyaman en mangatád ti maski essa a basu a malamig a dinom ten essa ti hidi iyád a mágkababa a tolay gapu disepulus ku hidi, ay siguradu a makatanggap ti piremyu a gubwat ten Diyos.” ");
INSERT INTO prfNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Nadid, káttapos ni Jesus a magbilin ten sapulu ay ti duwwa a disepulus ay lummakad siya tánni magtoldu sakay mangaral bi ten banuwan hidi haud. ");
INSERT INTO prfNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Ti Juan a Mágbinyag ay nakapiresu ti panahunid a iyud. Nabareta na en gággamitán hidi ni Cristo, kaya inutusan na en sangan ten disepulus na hidi ");
INSERT INTO prfNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","tánni magtanung, “Siko beman en áorayán mi a dumemát, oni maguray kami pa ti agum?” ");
INSERT INTO prfNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Tummábbig ti Jesus, “Sumoli kam kánni Juan sakay kagiyán moy dikona en nasanig moy sakay en netan moy. ");
INSERT INTO prfNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Naketa en burák hidi, sakay nakapaglakad dán en pilay hidi. Nagpiyya en kinetong hidi, sakay makasanig dán en bángngág hidi. Nabiyag en patay hidi sakay en Maganda a Bareta ay netoldu dán ten mágkahirap hidi a tolay. ");
INSERT INTO prfNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Pinagpala en tolay hidi a awan magduda dikoku! ");
INSERT INTO prfNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Nadid ten kállakad nen disepulus hidi ni Juan ay kinagi ni Jesus ten tolay hidi en tungkul kánni Juan, “Ánya beman en asaan moy a ketan ten dikona a ummangay kam ten kaparangan? Essa beman a waget ni kugun a idáppay-dáppay ni parás? ");
INSERT INTO prfNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Ánya beman a talaga i gustu moyid a ketan? Para maketa la ti tolay a magbadu ti mahal? En magbadu ten kona hidi haud ay ketan ten palasyu hidi nen hari. ");
INSERT INTO prfNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Ánya beman a talaga i gustu moyid a ketan? Awan beman gustu moy a maketa ti propeta? Tama kam, peru ti Juan ay mas higit pa nan ten essa a propeta. ");
INSERT INTO prfNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Ti Juan en kinagi nen Kasulatan a, ‘Tehudák a inutusan a mágdipalongu dikomu; ihanda na en paglakadan mu.’ ");
INSERT INTO prfNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Tandaan moy, mas mataas ti Juan nan ten deyaman a tolay a neenak ti munduwiday. Peru en kababaan ten kahariyan dilanget ay mas mataas nan ti Juan. ");
INSERT INTO prfNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Sapul dikona mangaral ti Juan a Mágbinyag a hanggan nadid, en kahariyan dilanget ay pilit a sáddáppán nen tolay hidi a marahas. ");
INSERT INTO prfNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Gapu bagu a dummemát ti Juan, en propeta hidi sakay en Kasulatan ni Moises en nagpahayag tungkul ten kahariyan. ");
INSERT INTO prfNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ni maniwala kam ti iyád a pahayag, ay ti Juan dán ngani en Elias a impangaku a dumemát. ");
INSERT INTO prfNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Mágsanig en tehud a págsanig. ");
INSERT INTO prfNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Hádya ku a iparehu en tolay hidi nadid a panahun? Kumán hidi a en anak hidi a mággetnud ten karsada a mágdadulawán ten kaayam di. ");
INSERT INTO prfNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Tinugtugan mi kam ti plauta, peru awan kam nagsayaw! Nagpatugtug kami ti pangluksa peru awan kam naglungkut!’ ");
INSERT INTO prfNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Gapu netan di ti Juan a magkulásyon sakay awan uminom ti alak, sakay en kagi di ay, ‘Hinayup i tolayen!’ ");
INSERT INTO prfNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Netan di bi en Anak nen Tolay a kuman sakay uminom, sakay kinagi di bi, ‘Ilingán moy i tolayen! Maunas, lasinggeru, sakay amigu nen mágsinger hidi ti buwes sakay makasalanan. Konapamanhud, en karunungan nen Diyos ay mapatunayan a tama ten pamamag-itan nen gamet na hidi.” ");
INSERT INTO prfNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Káttapos ay pinagkagiyan ni Jesus en banuwan hidi a naketa ten makpal a himala a ginamet na haud gapu awan hidi nagsisi sakay ummadág ten kasalanan di hidi. ");
INSERT INTO prfNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Kinagi na, “Kakakagbi kam a taga-Corazin hidi! Kakakagbi kam a taga-Bethsaida hidi! Gapu ni ginamet ti Tiro sakay Sidon en himala hidi a ginamet haán dikomoy, ay nalay dán nakuwan hidi a nagbadu ti kostal sakay nággetnud ten abu bilang tanda nen págsisi di.” ");
INSERT INTO prfNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Kagiyán ku dikomoy a ten Aldew nen Pághatul ay mas madággi en parusa moy nan ten parusa a madanas nen taga-Tiro hidi sakay taga-Sidon hidi. ");
INSERT INTO prfNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Sakay sikam a taga-Capernaum hidi gustu moy a itaas en sadili moy a hanggan dilanget peru mebagsak kam a hanggan ten patay hidi! Gapu ni ti Sodoma a nangyari en ginamet ku hidi a himala haán nakuwan ay ked palla i banuwanid a iyud a hanggan nadid. ");
INSERT INTO prfNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Kagiyán ku dikomoy a ten Aldew nen Pághatul ay mas madággi en parusa dikomoy nan ten taga-Sodoma hidi. ");
INSERT INTO prfNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Ti panahunid a iyud ay kinagi ni Jesus, “Ama, Panginoon nen langet ay ten luta, magpasalamaták dikomu gapu inlihim mu i bagayid a hidi iyád ten mágkarunung sakay mágkatalinu, sakay impahayag mu ten tolay hidi a en kaluuban di ay kumán a anak. ");
INSERT INTO prfNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Opo, Ama gapu iyud en kagustuwan mu.” ");
INSERT INTO prfNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“Inyatád dán dikoku nen Ama en atanan a bagay. Awan ti makatenggi ten Anak nan en Ama la, sakay awan ti makatenggi ten Ama nan en Anak la sakay en pinili hidi nen Anak a pángpahayagan na.” ");
INSERT INTO prfNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Umadeni kam dikoku, atanan moy a mahirapan dán sakay madággiyan ten karga moy, ta paimangán takam. ");
INSERT INTO prfNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Magpasakup kam sakay magadal dikoku. Gapu mabaiták sakay mapagpakumbabaák sakay makaimang en kaluluwa moy. ");
INSERT INTO prfNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Gapu alistu a sunudán en utus ku hidi sakay magaan la en pagamet ku hidi. ");
INSERT INTO prfNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Nadid ten essa a Aldew nen Káimang, ay nagtalib de Jesus sakay en disepulus na hidi ten katriguwan. En disepulus na hidi ay minagaláp kaya nagkádtor hidi ti trigo sakay nagkássel hidi. ");
INSERT INTO prfNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Ten dikona a ketan hidi nen sangan a Pariseo hidi ay kinagi di kánni Jesus, “Ilingán mu i gagamitán ni disepulus muwen hidi. Mahigpit iyán a bawal ten Kautusan ten Aldew nen Káimang!” ");
INSERT INTO prfNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Tummábbig ti Jesus, “Awan moy beman nabasa en ginamet ni David dikona nagaláp siya sakay en kaguman na hidi?” ");
INSERT INTO prfNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Summáddáp siya ten bilay nen Diyos sakay kumman ten tinapay a alay sakay pinakan na bi en kaguman na hidi. Labag ten Kautusan en ginamet di gapu en padi la hidi i maariyid a kuman ti iyud. ");
INSERT INTO prfNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Sakay awan moy palla beman nabasa ten Kautusan a en padi hidi ay magtarabahu ten Templo maski ni Aldew nen Káimang? Labag iyád ten Kautusan, peru awan hidi nagkasala. ");
INSERT INTO prfNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Kagiyán ku dikomoy, a tehud háddi a mas dakila nan en Templo. ");
INSERT INTO prfNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Ni maintendiyan moy nakuwan la i kahuluganid ni iddi, ‘Habag gustu kuwid, bakán a en alay moy,’ ay awan moy nakuwan hinatulan en awan hidi ti kasalanan. ");
INSERT INTO prfNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Gapu en Anak nen Tolay ay Panginoon nen Aldew nen Káimang.” ");
INSERT INTO prfNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Káttapos ay lummakad ti Jesus sakay ummangay siya ten sinagoga. ");
INSERT INTO prfNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Tehud haud a essa a lállaki a en essa na a lima ay awan makaarikad. Tehud bi haud a sangan a tolay a magaryok ti pagkakataun a mabintang di ti Jesus. Tinanung di ti Jesus, “Maari beman ten Kautusan a magpapiyya ten Aldew nen Káimang?” ");
INSERT INTO prfNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Tummábbig ti Jesus, “Ni mara essa dikomoy ay tehud a tupa a matápduk ten bal-ung ten Aldew nen Káimang, awan moy beman iyud iyawas? ");
INSERT INTO prfNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Mas mahalaga en essa a tolay nan en essa a tupa! Kaya awan labag ten Kautusan a maggamet ti maganda ten Aldew nen Káimang.” ");
INSERT INTO prfNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Káttapos ay kinagi na ten lállaki, “Iyolnat mu i lima muwen.” Inyolnat ngani nen lállaki en lima na sakay nagpiyya siya. ");
INSERT INTO prfNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Peru en sangan ten Pariseo hidi a ked haud ay lummakad sakay nagplanu hidi ni konya di a pabunu ti Jesus. ");
INSERT INTO prfNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Nadid, ten dikona a matukuyan ni Jesus en planu di ay lummakad siya. Makpal a tolay en ummunud dikona sakay pinagpiyya na en atanan a tehud hidi a saket. ");
INSERT INTO prfNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Peru mahigpit na hidi a binilinan a dyan di ibareta en tungkul dikona. ");
INSERT INTO prfNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Nangyari iyud tánni matupad en kinagi nen Diyos ten pamamag-itan ni propeta Isaias a, ");
INSERT INTO prfNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Ked háddi en pinili ku a magserbi dikoku. Mahal ku siya, sakay masayaák a tarud dikona. Iyatád ku dikona en Ispiritu ku, sakay siya en magpatupad ti katarungan ten bansa hidi. ");
INSERT INTO prfNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Awan siya mákpagtalu oni mákdima, oni magboses ten kakarsada hidi. ");
INSERT INTO prfNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Awan na paghirapán en mágkahina hidi a tolay, sakay mabait siya ten awan hidi ti pag-asa, hanggan a magtagumpay en katarungan. ");
INSERT INTO prfNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Sakay magtiwala en atanan a tolay dikona.” ");
INSERT INTO prfNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Káttapos ay inyangay nen tolay hidi kánni Jesus en lállaki a burák sakay bulol gapu hinayup. Pinagpiyya siya ni Jesus kaya nakapagupos sakay naketa dán. ");
INSERT INTO prfNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Kaya nagtaka en makpal a tolay sakay namagtanungan hidi, “Siya dán wád en áorayán tam a Anak ni David?” ");
INSERT INTO prfNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Ten dikona a masanig iyud nen Pariseo hidi ay kinagi di, “Makapagpalayas ti dimonyo i tolayid a iyán gapu ti Beelzebul a pinunu nen dimonyo hidi i nangatáddid dikona ti kapangyariyan.” ");
INSERT INTO prfNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Peru tukoy ni Jesus en ked ten isip di kaya kinagi na dikodi, “En essa a bansa a mahati-hati sakay maglaban-laban ay bumagsak. Sakay en banuwan oni pamilya a maglaban-laban ay mawasak. ");
INSERT INTO prfNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ni palayasán ni Satanas ti Satanas ay di kalabanán na en sadili na! Konya na nadid a mapanatili en kahariyan na? ");
INSERT INTO prfNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Ni makapagpalayasák ti dimonyo ten pamamag-itan ni Beelzebul, deya nadid en nangatád ti kapangyariyan ten tagasunud moy hidi a makagamet ti konahud? Kaya hidi dán bi en magpatunay a talaga a liwat kam! ");
INSERT INTO prfNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Peru ni en Ispiritu nen Diyos en nangatád dikoku ti kapangyariyan a makapagpalayas ti dimonyo, ay siya iyád katunayanid a dummemát dán dikomoy en pághari nen Diyos.” ");
INSERT INTO prfNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Konya a masáddáp sakay mapagtakawan en bilay nen essa a mabegsák a tolay ni awan siya punguwán? Ni mapungu dán ay maari dán a mapagtakawan en bilay na. ");
INSERT INTO prfNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Ni deyaman en awan kumampi dikoku ay kontra dikoku. Sakay en awan tumulung dikoku a magipun ten tolay hidi, ay magkalat ti tolay. ");
INSERT INTO prfNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Kagiyán ku dikomoy, a mapatawad en atanan a kasalanan maski en páglapastangan ten Diyos, peru en páglapastangan ten Banal a Ispiritu ay awan dán mapatawad. ");
INSERT INTO prfNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Ni deyaman en magupos kontra ten Anak nen Tolay ay mapatawad, peru en magupos kontra ten Banal Ispiritu ay awan mapatawad maski nadid a panahun oni ten panahun a dumemát. ");
INSERT INTO prfNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Ni maganda en ponan nen kayu ay maganda bi en bunga na. Peru ni madukás en ponan nen kayu ay madukás bi en bunga na. Gapu matukuyan en kayu ten pamamag-itan nen bunga na. ");
INSERT INTO prfNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Sikam a lahi hidi ni biklat! Konya kam a makapagupos ti maganda a bagay ni mágkadukás kam a tolay? Gapu ni ánya en ked ten pusu moy ay iyud labi en lumuwas ten ngusu moy. ");
INSERT INTO prfNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","En maganda a tolay ay makapagupos ti maganda gapu maganda en lasán nen pusu na. Madukás en kagiyán nen essa a tolay gapu madukás en lasán nen pusu na. ");
INSERT INTO prfNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","“Tandaan moy, ten Aldew nen Pághatul ay tábbigan nen tolay en bawat upos a awan ti seserbi a kinagi na. ");
INSERT INTO prfNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Gapu mahatulan kam oni maligtas kam ayun ten kinagi moy.” ");
INSERT INTO prfNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Nadid en sangan ten tagapagtoldu hidi nen Kautusan sakay en Pariseo hidi ay ummadeni kánni Jesus sakay kinagi di dikona, “Maistu, mángpeta ka pay dikomi ti himala.” ");
INSERT INTO prfNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Tummábbig ti Jesus, “Sikam a lahi ni mágkadukás a tolay! Magaryok kam ti himala peru awan ti ipeta dikomoy maliban ten nangyari kánni propeta a Jonas. ");
INSERT INTO prfNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Ni konya a ti Jonas ay nágyan ti tállu aldew ay ti tállu a gibi ten tiyan nen tunay ti kadikál a ikan, ay kona bi hud en Anak nen Tolay a mágyan ti tállu a aldew ay ti tállu a gibi ten disalad nen luta. ");
INSERT INTO prfNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Ten Aldew nen Pághatul ay tumaknág en taga-banuwan hidi a Ninive kontra ti lahiyid a iyád, gapu nagsisi hidi káttapos a mangaral ti Jonas dikodi. Peru mas mataas kánni Jonas en ked háddi nadid. ");
INSERT INTO prfNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Ti aldewid a iyud, ay tumaknág bi en Raina a gubwat ti Sheba kontra ti lahiyid a iyád, gapu gubwat pa siya ten ontok ni munduwiday tánni sanigán na la en karunungan ni Solomon, peru mas mataas kánni Solomon en ked háddi nadid.” ");
INSERT INTO prfNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Ni umibut en madukás a ispiritu ten bággi nen essa a tolay ay maglebut iyud ten mamadi a lugar ta magaryok ti maimangan na. Ni awan siya ti ketan ay ");
INSERT INTO prfNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","kagiyán na, ‘Soliyák ten tolay a ginubwatan ku.’ Ten kássoli na ay ketan na iyud a awan ti lasán, malinis sakay maayus. ");
INSERT INTO prfNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Kaya sumoli siya sakay mángkuyug pa siya ti pittu a ispiritu a mas madukás pa dikona. Sakay summáddáp hidi a mágyan haud. Kaya en magin kalagayan ni tolayid a iyud ay mas madukás nan ten dati na a kalagayan. Kaya konahud i mangyariyid ti lahiyiday hidi a mágkadukás.” ");
INSERT INTO prfNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Mentras a mangaral ti Jesus ten katolayan ay dummemát en ina na sakay en kákkapatkaka na. Maguray hidi ten luwas sakay gustu di siya a makauron. ");
INSERT INTO prfNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Tehud a nagkagi dikona, “Ked ti luwason de ina mu ay ten kákkapatkaka mu hidi, ta gustu di ka a makauron.” ");
INSERT INTO prfNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Peru kinagi ni Jesus, “Deya beman i ina kuwid sakay i kákkapatkaka kuwid hidi?” ");
INSERT INTO prfNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Intoldu ni Jesus en disepulus na hidi sakay kinagi na, “Hidi iddi i ina kuwid sakay kákkapatkaka ku hidi. ");
INSERT INTO prfNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Gapu ni deyaman en sumássunud ten kaluuban nen Ama ku a ked dilanget ay siya en ina ku sakay kákkapatkaka ku.” ");
INSERT INTO prfNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Nadid, ti aldewid a iyud ay lummuwas ti Jesus ten bilay sakay angay siya nággetnud ten gilid nen minalnu. ");
INSERT INTO prfNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Sakay pinalebutan siya nen tunay ti kakpal a tolay kaya summakay siya ten abeng. Ummetnud siya sakay nagtoldu ten katolayan a mágtaknág ten gilid nen minalnu. ");
INSERT INTO prfNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Tinolduwan na hidi ti makpal a bagay ten pamamag-itan ni talinhaga, kinagi na, “Tehud a essa a tolay a angay nagsabug. ");
INSERT INTO prfNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Ten págsabug na ay tehud a bine a neragrag ten adeni nen dilan, dummemát en ibun hidi sakay tinoktok di iyud. ");
INSERT INTO prfNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Tehud bi a bine a neragrag ten luta a mabatu. Gapu malapes la en luta ay alistu a nagtubu en bine. ");
INSERT INTO prfNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Peru ten dikona a masinagan ti mahigpit ay minalanás, gapu madibabew la en gamot na hidi. ");
INSERT INTO prfNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Tehud bi a bine a neragrag ten kasaetan; lummagu en kasaetan sakay nailongan en bine a neragrag haud. ");
INSERT INTO prfNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Peru en bine hidi neragrag ten matabi a luta ay nagbunga ti tágdadatos a butil, tehud a tággi-ánnám a pulu, sakay tehud a tágtatállu a pulu a butil en bawat ohay. ");
INSERT INTO prfNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Mágsanig en tehud a págsanig.” ");
INSERT INTO prfNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Ummadeni en disepulus hidi ni Jesus sakay tinanung di siya, “Bakin patalinhaga en págtoldu mu ti tolayen hidi?” ");
INSERT INTO prfNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Tummábbig ti Jesus dikodi, “Ingkaluub dikomoy en karapatan a maintendiyan en lihim tungkul ten kahariyan dilanget, peru awan iyád nepagkaluub dikodi. ");
INSERT INTO prfNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Gapu en tehud dán ay maátdenan pa, sakay sumagana. Peru en awan ay maski ni sabadit a ked dikona ay alapán pa. ");
INSERT INTO prfNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Kaya a patalinhaga ni magtolduwák dikodi ay gapu maski ni umileng hidi ay awan hidi maketa sakay mágsanig hidi peru awan hidi ti masanig oni maintendiyan. ");
INSERT INTO prfNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Natupad ngani dikodi en kinagi ni propeta Isaias a, Mágsasanigán kam man a mágsasanigán peru awan kam makaintendi, Umileng kam man a umileng ay awan kam bi maketa. ");
INSERT INTO prfNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Gapu nagin maktug dán en ulu ni tolayiday hidi; mahirap a makasanig en babángbáng di, sakay ingkáddám di en matamata di, ni awan di ginamet iyud ay naketa dán nakuwan en matamata di, nakasanig en babángbáng di, nakaintendi en iisip di, sakay nagsoli hidi dikoku, sakay pinagpiyya ku hidi.’ ");
INSERT INTO prfNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Peru sikam, ay pinagpala kam gapu en mata moy ay maketa sakay en bángbáng moy ay makasanig! ");
INSERT INTO prfNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Tandaan moy, makpal a propeta sakay matuwid a tolay en masor a maketa ten ketan moy sakay masor a makasanig ten masanig moy, peru awan di iyud netan sakay nasanig.” ");
INSERT INTO prfNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Nadid ay sanigán moy en kahulugan nen talinhaga tungkul ten mágsabug. ");
INSERT INTO prfNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","En mágsanig hidi ten mensahi tungkul ten pághari nen Diyos peru awan na iyud intendiyán ay kona ten bine hidi a neragrag ten adeni nen dilan. Dumemát en Madukás sakay ibutan na ten isip di en mensahi a nasanig di. ");
INSERT INTO prfNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","“En neragrag ten luta a mabatu ay en tolay a nágsanig ten mensahi. Masaya siya sakay pagdaka na iyud a tinanggap ");
INSERT INTO prfNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","peru awan tinumiim en mensahi ten pusu na. Awan nagnalay ay dummemát en pághirap sakay pággusig gapu ten mensahi, pagdaka na a inadággan en pánnampalataya na. ");
INSERT INTO prfNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","“En bine hidi a neragrag ten kasaetan ay mángpeta ten tolay hidi a nágsanig ten mensahi peru gapu ten kákkabalisa ten makpal a bagay sakay ten kákkasor ten kayamanan, ay nawanan ti lugar en mensahi ten pusu di kaya awan nagbunga. ");
INSERT INTO prfNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","“En kaparehu nen bine hidi a neragrag ten matabi a luta ay en tolay hidi a nágsanig sakay nangintendi ti mapiyya ten mensahi kaya nagbunga ti sagana, tehud a tággidatos, tehud bi a tággi-ánnám a pulu, sakay tehud bi a tágtatállu a pulu.” ");
INSERT INTO prfNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Nángkagi pa ti Jesus dikodi ti essa a talinhaga. Kinagi na dikodi, “En kahariyan dilanget ay kona ten essa a tolay a nagsabug ti maganda a bine ten uma na. ");
INSERT INTO prfNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Essa a gibi, mentras a tidug en tolay hidi, ay dummemát en kadima na, nángsabug ti madukás a lamon ten kaparayan, káttapos ay lummakad. ");
INSERT INTO prfNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Ten dikona a tummubu en paray sakay nagbunga ay lummitaw bi en madukás a lamon. ");
INSERT INTO prfNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Kaya ummadeni en utusan hidi nen makákkao sakay kinagi di dikona, ‘Awan beman a maganda a bine en insabug mu ten uma mu? Bakin malamon dán ben nadid?’ ");
INSERT INTO prfNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Tummábbig en makákkao, ‘Essa a kadima i nanggamitid ti iyán.’ Sakay kinagi nen utusan na hidi, ‘Gustu mu beman a bagután mi dán en lamon hidi?’ ");
INSERT INTO prfNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Tummábbig siya, ‘Dyan moy, bakay pati paray ay mabagut moy.’ ");
INSERT INTO prfNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","‘Basta pabayan moy la hidi a parehu a lumagu hanggan ti sákgapasid. Ti sákgapasid ay kagiyán ku ten mággapas hidi a ipunán di pa en kalamonan sakay bádbáddán di sakay tutudán. Sakay en paray hidi ay ipunán ten budega ku.” ’ ");
INSERT INTO prfNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Nadid ay essa dámman a talinhaga en kinagi ni Jesus dikodi, “En kahariyan dilanget ay kona ten essa a bukál nen mustasa a immula nen essa a tolay ten uma na. ");
INSERT INTO prfNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Kabaditan iyád ti atanan a bukál, peru ni magtubu dán ay kadikállan iyád ten atanan a mula. Dumikál iyád a kona ten kayu sakay maari a mapaglobunan nen ibun hidi en pinge-pinget na.” ");
INSERT INTO prfNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Kinagi na dikodi en essa dámman a talinhaga. “En kahariyan dilanget ay kona ten págpaalsa a inhalu nen essa a bábbi ten tállu dáddekál a takal a arina, kaya ummalsa en minasa a arina.” ");
INSERT INTO prfNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","En atanan a kinagi ni Jesus ten tolay hidi ay purus a patalinhaga sakay awan siya ti intoldu dikodi a bakán a patalinhaga. ");
INSERT INTO prfNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Kaya natupad en kinagi nen propeta: “Magupusák dikodi ten pamamag-itan ni talinhaga, ipahayag ku dikodi en bagay hidi a nelihim sapul pa dikona a lalangán i munduwiday.” ");
INSERT INTO prfNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Káttapos ay linakadan ni Jesus en tolay hidi sakay summáddáp siya ten bilay. Ummadeni dikona en disepulus na hidi sakay kinagi di, “Ipaliwanag mu pay dikomi ni ánya en talinhaga tungkul ten madukás a lamon ten kaparayan.” ");
INSERT INTO prfNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Tummábbig ti Jesus, “En mágsabug ti maganda a bine ay en Anak nen Tolay, ");
INSERT INTO prfNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","en uma ay i munduwiday. En mágkaganda a bine ay en tolay hidi a kabilang ten kahariyan sakay en mágkadukás a lamon ay en tolay hidi a kabilang ten Madukás. ");
INSERT INTO prfNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","En kadima a nagsabug ti lamon ten kaparayan ay en diyablo. Sakay en panahun nen sákgapas ay en katapusan ni munduwiday. Sakay en mággapas hidi ay en anghel hidi. ");
INSERT INTO prfNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Ni konya a en lamon hidi ay ipunán sakay tutudán, kona bi hud i mangyariyid ten katapusan ni munduwiday. ");
INSERT INTO prfNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Utusan nen Anak nen Tolay en anghel na hidi a ipunán a gubwat ten kahariyan na en atanan a nagin dahilan nen págkasala sakay en atanan a mággamet ti madukás. ");
INSERT INTO prfNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Sakay ibut di hidi ten maggerab a apoy sakay haud hidi a mágsasangitán sakay mággaaduyán ten hirap di. ");
INSERT INTO prfNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Peru en mággamet hidi ti matuwid ay magdemlag a kumán a aldew ten kahariyan nen Ama di. Mágsanig en tehud a págsanig!” ");
INSERT INTO prfNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“En kahariyan dilanget ay kona ten kayamanan a nekali ten essa a uma. Nadid ay nekaliyan iyud nen essa a tolay sakay tinaporan na a ruway. Gapu ten saya na ay angay na inlaku en atanan a ari-ariyan na sakay binali na iyud a uma.” ");
INSERT INTO prfNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“En kahariyan dilanget ay kona bi ten essa a nigosyanti a mággaaryokán ti mahal a kalasi ni perlas. ");
INSERT INTO prfNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Ten dikona a maketa dán siya ti essa a mahalaga a kalasi a perlas, ay angay na inlaku en atanan a ari-ariyan na sakay binali na iyud.” ");
INSERT INTO prfNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“En kahariyan dilanget ay kona bi ten essa a atakdug a panti a ingkalat ten minalnu sakay nakalap ti sari-sari a kalasi ni ikan. ");
INSERT INTO prfNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Nadid ten dikona a makpal dán a nalap ay hinela di dán ten dinapan. Sakay nággetnud en tolay hidi tánni piliyán di en mágkaganda a ikan sakay ibut di en awan ti serbi a ikan. ");
INSERT INTO prfNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Kona bi hud ten katapusan ni munduwiday. Dumemát en anghel hidi sakay ihiwalay di en makasalanan hidi ten matuwid hidi. ");
INSERT INTO prfNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Káttapos ay ibut di en makasalanan hidi ten maggerab a apoy. Haud hidi a mágsasangitán sakay mággaaduyán gapu ten hirap di.” ");
INSERT INTO prfNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Tinanung ni Jesus en disepulus na hidi, “Naintendiyan moy beman i atananid a iyád?” “Opo” tábbig di. ");
INSERT INTO prfNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Sakay kinagi na dikodi, “Kaya ngani, a en bawat tagapagtoldu nen Kautusan a mangtenggi ten kahariyan dilanget ay kona ten essa a pinunu nen sabilay a magluwas ti bigu hidi a bagay sakay dati a bagay a gubwat ten págtaguwan na ti kayamanan.” ");
INSERT INTO prfNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Nadid, ten dikona a mekagi dán ni Jesus hidi iyád a talinhaga ay lummakad dán siya ti lugarid a iyud. ");
INSERT INTO prfNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Ummuli siya ten banuwan na sakay ummangay siya nagtoldu ten sinagoga hidi haud. Nadid ay nagtaka en nakasanig hidi dikona. Kinagi di, “Hádya a nangalap ti karunungan i tolayid a iyán? Konya siya a makagamet ti himala hidi a bagay? ");
INSERT INTO prfNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Awan beman a anak iyán nen karpinteru? Awan beman a ti Maria en ina na sakay de Santiago, Jose, Simon, sakay ti Judas en kákkapatkaka na? ");
INSERT INTO prfNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Sakay en kákkapatkaka na hidi a bábbi ay mágyan bi hidi háddi. Hádya na wád a naadal i atananid a hidi iyán?” ");
INSERT INTO prfNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Sakay awan di siya pinaniwalaan. Kaya kinagi ni Jesus dikodi, “En essa a propeta ay igalang maski ni hádya, maliban la ten sadili na a banuwan sakay ten sadili na a pamilya.” ");
INSERT INTO prfNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Sakay gapu ten awan di pánniwala dikona ay awan siya naggamet ti makpal a himala haud. ");
INSERT INTO prfNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Nadid ti panahunid a iyud ay nabareta ni Herodes a pinunu ti Galilea en tungkul kánni Jesus. ");
INSERT INTO prfNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Kinagi na ten upisyal na hidi, “Siya iyán ti Juan a Mágbinyag a nabiyag a ruway, kaya tehud siya a kapangyariyan a makagamet ti himala.” ");
INSERT INTO prfNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Ti Herodes en nangpadikáp kánni Juan. Pinapungu na sakay impepiresu na gapu kánni Herodias a kabinga nen kapatkaka na a ti Felipe. ");
INSERT INTO prfNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Gapu kinagi ni Juan kánni Herodes, “Awan tama a kabingaán mu en kabinga nen kapatkaka mu.” ");
INSERT INTO prfNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Gustu ni Herodes a pabunu ti Juan kaya la ay manteng siya ten Judio hidi, gapu tenggiyán di ti Juan a essa a propeta. ");
INSERT INTO prfNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Peru ten dikona dummemát en aldew nen kákkeenak ni Herodes ay nagkasayaan hidi. Nagsayaw en anak ni Herodias a dalaga ten atubengán nen bisita hidi, sakay minasaya ti hustu ti Herodes. ");
INSERT INTO prfNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Kaya impangaku na ten dalaga a iyatád na en ányaman a agidán na. ");
INSERT INTO prfNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Gapu ten sulsul nen ina na ay kinagi nen dalaga, “Mahal a hari, gustu kuwid a iyatád mu dikoku nadid bi ay en ulu ni Juan a Mágbinyag a nakadátton ti penggan.” ");
INSERT INTO prfNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Ten dikona a masanig iyud ni Herodes ay minalungkut siya ti hustu, peru gapu ten pangaku na a nasanig nen bisita na hidi ay inyutus na a iyatád iyud ten dalaga. ");
INSERT INTO prfNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Kaya angay na pinaputol en ulu ni Juan ten págpiresuwan. ");
INSERT INTO prfNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Sakay indátton di ten essa a penggan en ulu na sakay inyatád di ten dalaga; sakay inyangay na bi iyud ten ina na. ");
INSERT INTO prfNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Dummemát en disepulus hidi ni Juan, inalap di en bangkay na sakay inlábbáng di. Sakay imbareta di kánni Jesus en nangyari. ");
INSERT INTO prfNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Ten dikona mabareta iyud ni Jesus ay summakay siya ten abeng sakay ummangay ten lugar a awan ti tolay. Dikona matukuyan iyud nen katolayan ay lummuwas hidi ten banu-banuwan di sakay ummunud hidi kánni Jesus. ");
INSERT INTO prfNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Ten káddung de Jesus ten baybay ay netan na en tunay ti kakpal a tolay. Kinagbiyan na hidi sakay pinagpiyya na en tehud hidi a saket. ");
INSERT INTO prfNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Ten dikona a págdiklám dán ay ummadeni kánni Jesus en disepulus na hidi. Sakay kinagi di dikona, “Panginoon, ked kitam ti liblibiday a lugar sakay págdiklám dán pa bi. Paangayán mu dán i tolayen hidi ti babaryuwen hidi tánni makabali hidi ti makan di.” ");
INSERT INTO prfNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Peru kinagi ni Jesus dikodi, “Awan di dán kailangan a lumakad. Sikam mangpakanid dikodi.” ");
INSERT INTO prfNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Tummábbig hidi, “Awan kitam ti pagkain, lilimma la a mommon a tinapay sakay duduwwa a ikan.” ");
INSERT INTO prfNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Kinagi na dikodi, “Iyangay moy háddi.” ");
INSERT INTO prfNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Pinággetnud na en tolay hidi ten kalamonan. Inalap na en limma a tinapay sakay en duwwa a ikan, tummangad siya dilanget sakay nagpasalamat siya ten Diyos. Hinati-hati na en tinapay sakay inyutus na ten disepulus na hidi a itagtag iyud ten katolayan. ");
INSERT INTO prfNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Nakakan a atanan sakay nágkabássug. Dikona inipun nen disepulus hidi en subra a pagkain, ay nakaputat hidi ti sapulu ay ti duwwa a lákba. ");
INSERT INTO prfNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Tehud a limmang libu a kalállakiyan en nakakan, puwera pa ten kabábbiyan hidi sakay ten anak hidi. ");
INSERT INTO prfNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Pagdaka a pinasakay ni Jesus ten abeng en disepulus na hidi sakay pinágdipalongu na dán hidi ten dibelyu, mentras a pauliyán na en tolay hidi. ");
INSERT INTO prfNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Kállakad nen tolay hidi ay summangkay siya ten marenggád a bukid tánni magdasal siya. Mággeessa siya haud a ginibi. ");
INSERT INTO prfNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Ti odasid a iyud, ay ked dán ditaw en abeng a dáddapáttán nen dáddekál a tagmák gapu patagbu hidi ten parás. ");
INSERT INTO prfNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Ten dikona a kaldiwan dán ay ummunud ti Jesus dikodi a naglakad ten dibabew nen dinom. ");
INSERT INTO prfNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Peru ten dikona a ketan di a tehud a maglakad ten dibabew nen dinom ay mineántingan hidi ti hustu. Impákraw di, “Tehud a anitu!” ");
INSERT INTO prfNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Peru nagupos a pagdaka ti Jesus, kinagi na, “Dyan kam manteng, sikán iyád!” ");
INSERT INTO prfNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Kinagi ni Pedro, “Panginoon, ni talaga a siko iyán ay paangayánnák mu haán a maglakad ti dinomiday.” ");
INSERT INTO prfNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Tummábbig ti Jesus, “Karon dán!” Kaya ummugsad ti Pedro ten abeng a naglakad ten dibabew nen dinom a patamu kánni Jesus. ");
INSERT INTO prfNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Peru ten dikona a mapansin ni Pedro en mabegsák a parás ay mineántingan siya sakay nagsapul dán a umállád. “Panginoon, iligtasák mu!” kagi ni Pedro. ");
INSERT INTO prfNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Pagdaka siya a ginewat ni Jesus sakay kinagi na, “Bakin nagalangan ka? Tunay ti kabadit i pánnampalataya muwen!” ");
INSERT INTO prfNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Ten kássakay di ten abeng ay ummimang en parás. ");
INSERT INTO prfNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Sakay sinamba siya nen disepulus na hidi a ked ten abeng. Kinagi di, “Tunay ngani a siko en Anak nen Diyos!” ");
INSERT INTO prfNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Nadid, ten káarabes di ay dummung hidi ten lugar a Genesaret. ");
INSERT INTO prfNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ten pákkatenggi nen tolay hidi kánni Jesus ay angay di imbábbareta ten atanan a babaryu ti lugarid a iyud kaya inyangay di dikona en atanan a tehud a saket. ");
INSERT INTO prfNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Nákkekagbi hidi kánni Jesus a ni maari ay patawid na ten tehud hidi a saket maski en garayan la nen badu na. Sakay en atanan a nakatawid ay nagpiyya. ");
INSERT INTO prfNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Káttapos ay ummangay kánni Jesus en Pariseo hidi sakay en tagapagtoldu hidi nen Kautusan a gubwat hidi ti Jerusalem. Tinanung di siya, ");
INSERT INTO prfNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Bakin a labagán ni disepulus muwen hidi en toldu hidi a minana tam ten ninunu tam hidi. Ni kuman hidi ay awan hidi magugas a ayun ten utus.” ");
INSERT INTO prfNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Tummábbig ti Jesus, “Bakin a labagán moy bi en utus nen Diyos gapu la ten kássunud moy ten intoldu nen ninunu moy hidi? ");
INSERT INTO prfNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Gapu kinagi nen Diyos, ‘Igalang mu en ama mu ay ten ina mu’ sakay, ‘Ni deyaman en manglait ten ama na oni ina na ay dapat a bunuwán.’ ");
INSERT INTO prfNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Peru itáttoldu moy a, “Ni kagiyán nen essa a tolay ten ama na oni ina na a, ‘En metulung ku dikomoy ay nealay ku dán ten Diyos’ ");
INSERT INTO prfNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","awan na dán kailangan a tulungan en ama na. Gapu ten kássunud moy ten minana moy hidi a toldu ay awan moy dán pinahalagaan en upos nen Diyos. ");
INSERT INTO prfNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Sikam a magkukunwari hidi! Tama ngani en kinagi ni propeta Isaias a tungkul dikomoy, ");
INSERT INTO prfNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘En pággalang dikoku ni iyád a banuwan ay kunwari la, gapu ten ngusu di la a maggubwat bakán a ten pusu di. ");
INSERT INTO prfNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Awan ti kuwenta en págsamba di, gapu kagi diyid ay gubwat ten Diyos en itáttoldu di.” ");
INSERT INTO prfNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Nadid ay pinaadeni ni Jesus en tolay hidi sakay kinagi na dikodi, “Mágsanig kam sakay intendiyán moy i kagiyán kuwiday. ");
INSERT INTO prfNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Bakán a en isubu nen tolay en makapangpadingát dikona ten pangileng nen Diyos nan en lumuwas ten ngusu na.” ");
INSERT INTO prfNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Káttapos ay ummadeni kánni Jesus en disepulus na hidi sakay kinagi di dikona, “Tukoy mu, nasaketan en Pariseo hidi ten dikona a nasanig di en kinagi mu!” ");
INSERT INTO prfNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Tummábbig ti Jesus, “Bagután en bawat mula a awan immula nen Ama ku a ked dilanget. ");
INSERT INTO prfNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Pabayan moy la hidi. Burák hidi a tagagiyya nen kaparehu di hidi a burák. Sakay ni burák a tolay i mánggiyyaid ten kaparehu na a burák ay parehu hidi a matápduk ten ábbut.” ");
INSERT INTO prfNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Kinagi ni Pedro dikona, “Ipaliwanag mu dikomi ni ánya i kahuluganid nen talinhaga.” ");
INSERT INTO prfNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Tummábbig ti Jesus, “Pati beman sikam ay awan bi makaintendi?” ");
INSERT INTO prfNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Awan moy beman tukoy a ányaman a isubu moy ay tumulos ten tiyan moy sakay lumuwas labi? ");
INSERT INTO prfNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Peru en lumuwas hidi ten ngusu ay naggubwat ten pusu. Iyud i makapangpadingáttid ten essa a tolay. ");
INSERT INTO prfNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Gapu gubwat ten pusu nen tolay en mágkadukás a isip, pámmunu, pángngalunya, págtakaw, págbuli-buli sakay pággupos ti madukás kontra ten agum a tolay. ");
INSERT INTO prfNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Hidi iyád en makapangpadingát ten essa a tolay. Peru en awan pággugas ti lima bagu a kuman ayun ten minana a toldu ay awan makapangpadingát ten essa a tolay. ");
INSERT INTO prfNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Lummakad ti Jesus haud sakay ummangay ten lugar hidi a adeni ti Tiro sakay Sidon. ");
INSERT INTO prfNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Tehud a essa a bábbi a taga-Canaan a mágyan haud, ummadeni siya kánni Jesus sakay magpákraw, “Panginoon a Anak ni David, kagbiyanák mu! En anak ku a bábbi ay hinayup sakay pahirapan na siya ti hustu.” ");
INSERT INTO prfNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Peru awan tumatábbig ti Jesus. Sakay kinagi dikona nen disepulus na hidi, “Palakadán mu dán siya, makabángngág a umunonud dikotam.” ");
INSERT INTO prfNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Tummábbig ti Jesus, “Inutusanák nen Ama ku a umangay la ten nágketawtaw hidi a tupa ni Israel.” ");
INSERT INTO prfNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Peru angay lummuhud dikona en bábbi sakay kinagi na, “Panginoon, kagbiyanák mu a tulungan.” ");
INSERT INTO prfNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Tummábbig ti Jesus, “Awan dapat a alapán en pagkain nen anak hidi sakay ipakan ten asu hidi.” ");
INSERT INTO prfNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Tummábbig en bábbi, “Tarud iyán Panginoon, peru maski ni en asu hidi ay kuman bi ten mumu a maragrag ten lamisaan nen amu di.” ");
INSERT INTO prfNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Kaya kinagi ni Jesus ten bábbi, “Tunay ti kadikál i pánnampalataya muwen! Mangyari en agidán mu.” Ti odas biyid a iyud ay nagpiyya en anak na. ");
INSERT INTO prfNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Kállakad ni Jesus ti lugarid a iyud, ay nagsoli siya ten adeni nen Minalnu ti Galilea. Summangkay siya ten marenggád a bukid sakay nággetnud. ");
INSERT INTO prfNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Sakay nagdemáttan en tunay ti kakpal a tolay a tehud hidi a tawid a pilay, burák, lupug, bulol sakay makpal pa a tehud a sari-sari a kalasi ni saket. Inyangay di hidi ten atubengán ni Jesus sakay pinagpiyya na hidi. ");
INSERT INTO prfNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Nagtaka en tolay hidi dikona a ketan di a makaupos dán en bulol hidi, makapaglakad dán en lupug hidi, makalakad dán en pilay hidi, sakay maketa dán en burák hidi. Sakay nagpuri hidi ten Diyos ni Israel. ");
INSERT INTO prfNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Nadid ay dinulawan ni Jesus en disepulus na hidi sakay kinagi na dikodi, “Kagbiyan ku i tolayiday hidi, gapu tállu dán hidi a aldew a kakaguman tam sakay awan dán hidi ti makan. Awan ku hidi gustu a pauliyán a magaláp bakay ni malinug hidi ti dilanen.” ");
INSERT INTO prfNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Kinagi dikona nen disepulus na hidi, “Hádya i pangalapan tamid ti pagkain a para ti kakpal ni tolayen hidi, ked kitam pa bi ti kaparanganiday?” ");
INSERT INTO prfNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Tinanung hidi ni Jesus, “Sangan i tinapay moyid haán?” “Pittu a tinapay sakay sasangan a bábbadit a ikan,” tábbig nen disepulus na hidi. ");
INSERT INTO prfNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Sakay pinággetnud ni Jesus en tolay hidi ten luta. ");
INSERT INTO prfNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Inalap ni Jesus en pittu a tinapay sakay en sasangan a bábbadit a ikan sakay nagpasalamat ten Diyos. Káttapos ay hinati-hati na iyud sakay inyatád na ten disepulus na hidi tánni itagtag di ten tolay hidi. ");
INSERT INTO prfNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Atanan di ay nakakan sakay nabássug; sakay ten dikona a ipunán nen disepulus hidi en naburay ay nakaputat hidi ti pittu a lákba. ");
INSERT INTO prfNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","En bilang nen kumman hidi a lállaki ay áppat a libu awan palla hud kabilang en kabábbiyan sakay en kaanakan. ");
INSERT INTO prfNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Sakay dikona a napauli dán ni Jesus en tolay hidi ay summakay siya ten abeng a patamu ten banuwan a Magadan. ");
INSERT INTO prfNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Tehud a sangan ten Pariseo hidi ay ten Saduseo hidi a ummangay kánni Jesus. Gustu di siya a purbaan kaya nággid hidi dikona ti tanda a gubwat dilanget. ");
INSERT INTO prfNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Peru kinagi ni Jesus dikodi, “Ti pággapon ay kagiyán moy a, ‘Maganda i panahunid ni ilaw gapu maganda i langiten.’ ");
INSERT INTO prfNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Sakay ti dimadimang a tarud ay kagiyán moy a, ‘Maguden nadid, gapu madiklám i langiten.’ Tukoy moy a magileng ten tanda hidi ti langiten, peru awan moy tukoy en tanda hidi ti nadid a kasalukuyan a panahun. ");
INSERT INTO prfNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Sikam a madukás a lahi sakay awan matapat ten Diyos! Magaryok kam ti tanda, peru awan ipeta dikomoy maliban ten tanda a nangyari kánni Jonas!” Káttapos ni iyud ay lummakad ti Jesus. ");
INSERT INTO prfNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Nadid, ten dikona a makaarabes dán hidi ten dibelyu nen minalnu ay nakalimon en disepulus hidi a magtawid ti tinapay. ");
INSERT INTO prfNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Kinagi ni Jesus dikodi, “Magingat kam ten págpaalsa nen Pariseo hidi sakay nen Saduseo hidi.” ");
INSERT INTO prfNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Kaya namágguron en disepulus hidi. Kagi di a, “Gapu a awan kitam nagtawid ti tinapay kaya na a kinagi iyud.” ");
INSERT INTO prfNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Tukoy ni Jesus en pamággurunan di, “Bakin a pamággurunan moy a awan kam ti balon a tinapay? Tunay ti kabadit i pánnampalataya moyen! ");
INSERT INTO prfNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Hanggan beman nadid ay awan kam palla makaintendi? Awan moy beman maalala en limma a mommon a tinapay a hinati-hati para ten limmang libu a tolay? Sangan a lákba a tinapay en subra? ");
INSERT INTO prfNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Kona bi ten pittu a mommon a tinapay a para ten áppat a libu a tolay! Sangan a lákba a tinapay en subra? ");
INSERT INTO prfNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Bakin a awan moy maintendiyan a bakán a tungkul ti tinapay en kinagi ku dikomoy a magingat kam ten págpaalsa a gamit nen Pariseo hidi sakay nen Saduseo hidi!” ");
INSERT INTO prfNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Sakay naintendiyan di dán a pagingatán hidi ni Jesus ten toldu nen Pariseo hidi sakay nen Saduseo hidi, bakán a ten págpaalsa a gággamitán ti tinapay. ");
INSERT INTO prfNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Nadid, ten dikona a makademát ti Jesus ten banuwan a Cesarea a sakup ni Filipos, ay tinanung na en disepulus na hidi, “Deya kan en Anak nen Tolay, ayun ten tolay hidi?” ");
INSERT INTO prfNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Tummábbig hidi, “En kagi nen agum hidi ay ti Juan a Mágbinyag ka kan. Kagi biyid nen agum hidi ay ti Elias ka kan. Sakay tehud pa a magkagi a ti Jeremias ka kan, oni essa ten propeta hidi.” ");
INSERT INTO prfNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Sakay tinanung na hidi, “Ay sikam ánya bi i makagi moyid? Deyaák?” ");
INSERT INTO prfNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Tummábbig ti Simon Pedro, “Siko ay ti Cristo, en Anak nen Diyos a biyag.” ");
INSERT INTO prfNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Kinagi ni Jesus dikona, “Pinagpala ka Simon, a anak ni Jonas! Gapu iyád a katutuhanan ay awan impahayag dikomu ni deyaman nan nen Ama ku dilanget. ");
INSERT INTO prfNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Sakay kagiyán ku dikomu, a siko ay Pedro, sakay ti dibabew ni batuwid a iyád ay ipataknág ku en simbaan ku, sakay awan ti makapangtalu dikona maski ni en kapangyariyan nen kamatayan. ");
INSERT INTO prfNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Iyatád ku dikomu en susi hidi nen kahariyan dilanget. En ibawal mu ti lutaiday ay ibawal bi dilanget, sakay ányaman a payagan mu ti lutaiday ay payagan bi dilanget.” ");
INSERT INTO prfNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Sakay mahigpit a binilin na en disepulus na hidi a dyan di kagikagiyán a siya en Cristo. ");
INSERT INTO prfNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Sapul haud ay kinagi dán ni Jesus ten disepulus na hidi en mangyari dikona. Kinagi na, “Kailangan a angayák ti Jerusalem sakay magdanasák ti makpal a hirap ten lima nen pinunu hidi nen banuwan, ten pinunu nen padi hidi sakay ten tagapagtoldu hidi nen Kautusan. Bunuwánnák di, peru ten katállu a aldew ay mabiyagák a ruway. ");
INSERT INTO prfNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Peru inakit ni Pedro ti Jesus ti sekretu la sakay kinagiyan na siya ti kona háddi, “Panginoon, awan nakuwan iyád payagan nen Diyos a mangyari! Awan iyád dapat a mangyari dikomu.” ");
INSERT INTO prfNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Peru inatubeng siya ni Jesus sakay kinagi na, “Satanas, umadeyu ka dikoku! Dyan mu pugáddán en kaluuban nen Diyos. I ked ti isip muwen ay bakán a kaluuban nen Diyos nan kaluuban nen tolay.” ");
INSERT INTO prfNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Sakay kinagi ni Jesus ten disepulus na hidi, “Ni deyaman en masor a sumunud dikoku ay dapat a limunán na en tungkul ten sadili na sakay báklayán na en kudus na sakay mákkuyug dikoku. ");
INSERT INTO prfNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Ni deyaman en masor a mángligtas ten biyag na ay siya en mawanan; peru en mawanan ti biyag alang-alang dikoku ay siya en magkahud ti biyag. ");
INSERT INTO prfNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Ánya i pakinabangid nen essa a tolay ni makao na i munduwiday ni en kapalit ni iyud ay en biyag na? Ánya i mebayadid nen essa a tolay para mesoli dikona en biyag na? ");
INSERT INTO prfNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Gapu dumemát en Anak nen Tolay ten pamamag-itan nen dakila a kapangyariyan nen Ama na sakay kaguman na en anghel na hidi. Ti panahunid a iyud ay piremyuwan na en balang essa a tolay ayun ten ginamet na.” ");
INSERT INTO prfNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Tandaan moy: tehud dikomoy a ked háddi a awan matay hanggan a awan na ketan en Anak nen Tolay a dumemát a bilang essa a Hari.” ");
INSERT INTO prfNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Kállipas nen ánnám a aldew, ay ingkuyug ni Jesus de Pedro sakay en matkaka a de Juan ay ti Santiago sakay ummangay hidi ten toktok nen essa a malangkaw a bukid. ");
INSERT INTO prfNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Mentras a ked hidi haud ay netan di a nagbagu en idsura ni Jesus, nagdemlag a kumán a aldew en rupa na sakay en badu na ay magdemlag ten pudew na. ");
INSERT INTO prfNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Netan nen tállu a disepulus a bigla a pummeta de Moises sakay ti Elias a kauron ni Jesus. ");
INSERT INTO prfNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Kaya kinagi ni Pedro kánni Jesus, “Panginoon mapiyya la ta ked kami háddi. Ni gustu mu ay maggamiták ti tállu a sarong, essa a para dikomu, essa bi a para kánni Moises sakay essa bi a para kánni Elias.” ");
INSERT INTO prfNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Mentras a magupos ti Pedro ay bigla a tinaklábban hidi ni mademlag a panganurin. Sakay kinagi nen boses a gubwat ten panganurin, “Saiyád en mahal ku a Anak a kasayaan ku a tarud. Sanigán moy siya!” ");
INSERT INTO prfNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Ten dikona a masanig iyud nen disepulus hidi ay mineántingan hidi sakay linumuhud hidi. ");
INSERT INTO prfNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Peru inadeniyan hidi ni Jesus sakay tinawidan. Kinagi na, “Tumaknág kam, dyan kam manteng!” ");
INSERT INTO prfNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Ten dikona a umileng hidi ay ti Jesus dálla en netan di. ");
INSERT INTO prfNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Mentras a padagson hidi ten bukid ay inyutus ni Jesus dikodi, “Dyan moy kagiyán maski ni kándeya en netan moy, hanggan a awan mabiyag a ruway en Anak nen Tolay.” ");
INSERT INTO prfNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Tinanung siya nen disepulus na hidi, “Bakin a kákkagiyán nen tagapagtoldu hidi nen Kautusan a dapat a mágdipalongu pa ti Elias a umangay háddi?” ");
INSERT INTO prfNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Tummábbig ti Jesus, “Mágdipalongu ngani ti Elias háddi tánni ihanda na en atanan a bagay. ");
INSERT INTO prfNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Peru kagiyán dikomoy, a ummangay dán háddi ti Elias peru awan siya tinenggi nen tolay hidi. Ginamet di dikona atanan a gustu di a gamitán. Kona bi hud i gamitán diyid a pahirapan di en Anak nen Tolay.” ");
INSERT INTO prfNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Naintendiyan nen disepulus hidi a ti Juan a Mágbinyag en gustu na a kagiyán. ");
INSERT INTO prfNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Nadid, kássoli di ay dinemáttan di en makpal a tolay. Ummadeni dikona en essa a lállaki, lummuhud ten atubengán ni Jesus sakay kinagi na a, ");
INSERT INTO prfNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Panginoon, kagbiyan mu en anak ku! Mágpatay siya sakay mahirapan ti hustu ni sumingga. Pirmi siya a matumba ten apoy oni ten dinom. ");
INSERT INTO prfNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Inyangay ku dán bi siya ten disepulus mu hidi peru awan di siya mapagpiyya.” ");
INSERT INTO prfNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Tummábbig ti Jesus, “Sikam a tolay hidi a madukás a lahi sakay awan ti pánnampalataya. Hanggan nikanák a mákpágyan dikomoy? Hanggan nikan takam a pagtiisan? Iyangay moy háddi i anaken.” ");
INSERT INTO prfNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Inutusan ni Jesus en dimonyo a lumakad ten anak sakay nagpiyya en anak. ");
INSERT INTO prfNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Káttapos ay ummadeni kánni Jesus en disepulus na hidi sakay sinekretu di siya a tinanung ni bakin a awan di mapaibut en dimonyo. ");
INSERT INTO prfNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Tummábbig ti Jesus, “Gapu ti kabadit ni pánnampalataya moyen. Kagiyán ku dikomoy, a ni kona nakuwan la ten kadikál nen bukál ni mustasa en pánnampalataya moy ten Diyos ay makagi moy ti bukiden a, ‘Umagton ka hudi!’ ay mangyari iyud. Awan ti bagay a awan moy magamet. ");
INSERT INTO prfNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Peru konaid hud a kalasi ni dimonyo ay awan mapaibut ni awan kam pa magdasal sakay magkulásyon.” ");
INSERT INTO prfNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Nadid ten dikona a maipun en disepulus hidi ti Galilea ay kinagi ni Jesus dikodi, “En Anak nen Tolay ay itokyon ");
INSERT INTO prfNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","sakay bunuwán di. Peru ten katállu a aldew ay biyagán siya a ruway.” Dikona a masanig iyud nen disepulus na hidi ay minalungkut hidi ti hustu. ");
INSERT INTO prfNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Nadid káddemát di ti Capernaum ay ummadeni kánni Pedro en mágsinger hidi ti buwes a para ten templo. Kinagi di, “Mágbayad beman ti buwes a para ten templo i Maistu moyen?” ");
INSERT INTO prfNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","“Opo” tábbig ni Pedro. Dikona makademát siya ten bilay di ay tinanung siya ni Jesus, “Ánya palagay muwid Simon? Deya i dapatid a magbayad ti buwes ten hari nen essa a bansa, en nasakupan na hidi oni en dayu hidi?” ");
INSERT INTO prfNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","“En dayu hidi,” tábbig ni Pedro. Kinagi ni Jesus, “Ni konahud ay awan dapat a magbayad en nasakupan na hidi.” ");
INSERT INTO prfNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Peru konapamanhud, tánni awan hidi ti makagi dikotam, ay angay ka ten mamaruwan ti minalnuwen. En purumeru a ikan a malap mu ay pagángngakán mu sakay tehud ka a ketan a silber a maari a pagbayad ten buwes ta a duwwa. Alapán mu iyud sakay angay ka magbuwes para dikota a duwwa. ");
INSERT INTO prfNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Nadid, ti odasid a iyud ay ummadeni kánni Jesus en disepulus na hidi sakay nagtanung, “Deya en kataasan ten kahariyan dilanget?” ");
INSERT INTO prfNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Dinulaw ni Jesus en essa a anak sakay pinataknág na ten atubengán di, ");
INSERT INTO prfNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","sakay kinagi na, “Tandaan moy iddi: ni awan kam magbagu sakay umarig ten anak hidi, ay awan kam makasáddáp ten kahariyan dilanget. ");
INSERT INTO prfNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Kaya, ni deyaman en magpakababa a kona ti anakiday ay siya en magin kataasan ten kahariyan dilanget. ");
INSERT INTO prfNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Sakay ni deyaman en mangtanggap ten anak a kona háddi alang-alang dikoku ay sikán tinanggap naid.” ");
INSERT INTO prfNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Mapiyya pa ten essa a tolay a báttenan ti essa a dikál a gilingan a batu ten állig na sakay itábbung ditaw a diget nan ni magin dahilan nen págkasala nen bábbadit hidi a anak a mánnampalataya dikoku. ");
INSERT INTO prfNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Kakakagbi i munduwiday gapu ten kakpal nen toksu hidi a dahilan ni págkasala! Awan ngani mapugád en káddemát nen toksu, peru makaánteng en mangyari ten tolay a dahilan nen págkasala. ");
INSERT INTO prfNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Ni en lima oni en básset mu en dahilan nen págkasala mu, ay káttolán mu sakay ibut mu! Mas maganda pa a meangay ka dilanget a putád nan duwwa en lima mu oni básset mu peru meangay ka ten apoy a awan maadáp. ");
INSERT INTO prfNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Sakay ni en mata mu en magin dahilan nen págkasala mu ay lábwetán mu iyud sakay ibut! Mas maganda pa a meangay ka dilanget a burák en essa mu a mata nan tehud ka a duwwa a mata peru meangay ka ten apoy ti impiyerno. ");
INSERT INTO prfNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Magingat kam a dyan moy imemenos en essa ti hidi iyád a anak. Kagiyán ku dikomoy, a en anghel di hidi ay pirmi a ked ten atubengán nen Ama ku a ked dilanget. ");
INSERT INTO prfNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Gapu ummangay háddi en Anak nen Tolay tánni iligtas en tolay hidi a netawtaw. ");
INSERT INTO prfNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Ánya ti palagay moyid en gamitán nen essa a tolay a tehud a datos a tupa sakay mebut en essa? Awan beman lakadan na en siyam a pulu ay ti siyam ten pággulaan na tánni aryokán na en essa a netawtaw? ");
INSERT INTO prfNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Kagiyán ku dikomoy, a ni ketan na dán iyud ay mas dikál en kasayaan na ti iyud a tupa nan ten siyam a pulu ay ti siyam a awan netawtaw? ");
INSERT INTO prfNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Kona labi hud, awan kagustuwan nen Ama moy a ked dilanget a metawtaw en essa ti bábbaditiday a anak.” ");
INSERT INTO prfNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Ni magkasala dikomu en essa ten kapatkaka mu ay adeniyan mu siya sakay mágguron kam a sikam la a duwwa. Ni sumanig siya dikomu, ay mesoli ten dati en pággagum moy bilang matkaka. ");
INSERT INTO prfNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Peru ni awan siya sumanig dikomu ay mángkuyug ka ti essa oni duwwa a kapatkaka tánni en atanan a mapággurunan moy ay mapatunayan nen duwwa oni tállu a tistigu. ");
INSERT INTO prfNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ni awan pa siya sumanig dikodi, ay kagiyán mu ten buu a simbaan en nangyari. Sakay ni awan pa siya sumanig ten simbaan ay ibilang mu dán siya a Hentil oni mágsinger ti buwes.” ");
INSERT INTO prfNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Tandaan moy iddi: ányaman en ibawal moy ti lutaiday ay ibawal bi dilanget, sakay ányaman en payagan moy ti lutaiday ay payagan bi dilanget. ");
INSERT INTO prfNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Sakay tandaan moy bi: ni tehud a duwwa dikomoy a nagkaessa ti lutaiday a mággid ti ányaman ten págdasal moy ay iyatád iyud nen Ama ku a ked dilanget. ");
INSERT INTO prfNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Gapu hádyaman a tehud a duwwa oni tállu a nagipun-ipun ten pamamag-itan nen ngaran ku, ay kedák bi haud a kaguman di.” ");
INSERT INTO prfNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Ummadeni ti Pedro kánni Jesus sakay nagtanung, “Panginoon, pensangan ku a patawadán en kapatkaka ku a paruway-ruway a magkasala dikoku? Pumenpittu beman?” ");
INSERT INTO prfNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Tummábbig ti Jesus, “Awan ku kagiyán a pumenpittu, nan pittu a pulu a pumenpittu. ");
INSERT INTO prfNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Gapu en kahariyan dilanget ay meparehu ten essa a hari a nagdisisyon a pagbayadán na en tagapagserbi na hidi a tehud a utang dikona. ");
INSERT INTO prfNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","En purumeru na a pinadulaw ay tehud a utang dikona a minilyon a pisu. ");
INSERT INTO prfNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Gapu awan siya ti ibayad ay inyutus nen hari a ilaku siya sakay en kabinga na, en anak na hidi sakay en atanan a ari-ariyan na tánni makabayad siya. ");
INSERT INTO prfNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Lummuhud sakay nákkekagbi en lállaki ten atubengán nen hari, kinagi na, ‘Atáddanák mu pay pa ti panahun tánni mabayadan ku dikomu en atanan.’ ");
INSERT INTO prfNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Kinagbiyan siya nen hari kaya awan na dán pinabayad en utang na sakay pinalaya na dán siya. ");
INSERT INTO prfNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Peru kállakad na haud ay natagbu na en essa ten kaparehu na a tagapagserbi a tehud a utang dikona a sangan a datos a pisu. Sinunggaban na iyud sakay sináppállan, kinagi na, ‘Magbayad ka dán ten utang mu!’ ");
INSERT INTO prfNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Lummuhud sakay nákkekagbi en lállaki, kinagi na, ‘Átdenanák mu pa ti panahun tánni makabayadák dikomu.’ ");
INSERT INTO prfNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Peru awan siya pummayag, nan en ginamet na ay impepiresu na hanggan dikona a makabayad dán siya. ");
INSERT INTO prfNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","“Ten dikona ketan nen kaparehu na hidi a tagapagserbi en nangyari ay minalungkut hidi ti hustu. Kaya angay di ingkagi ten hari en nangyari. ");
INSERT INTO prfNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Kaya pinadulaw nen hari en loku a tagapagserbi sakay kinagi na dikona, ‘Tunay ka ti dukás a tagapagserbi! Awan taka dán pinagbayad ten utang mu gapu nákkekagbi ka dikoku. ");
INSERT INTO prfNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Kinagbiyan taka, peru bakin a awan ka makabetu a mangagbi ten kaparehu mu a tagapagserbi?’ ");
INSERT INTO prfNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Gapu ten iyamut nen hari ay impepiresu na siya hanggan a awan na mabayadan en atanan a utang na. ");
INSERT INTO prfNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Kona labi hud i gamitánnid nen Ama ku a ked dilanget dikomoy ni awan moy patawadán en kákkapatkaka moy hidi. ");
INSERT INTO prfNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Nadid, káttapos ni Jesus a kagiyán hidi iyád a bagay, ay lummakad siya ti Galilea sakay ummangay siya ti Judea, ten dibelyu ni Jordan. ");
INSERT INTO prfNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Tunay ti kakpal a tolay en ummunud dikona sakay pinagpiyya na en tehud hidi a saket. ");
INSERT INTO prfNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Tehud a sangan a Pariseo a ummadeni dikona, magaryok hidi ti mebintang di dikona, kaya tinanung di siya, “Ayun beman ten Kautusan a hiwalayan nen lállaki en kabinga na maski ni ánya a dahilan?” ");
INSERT INTO prfNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Tummábbig ti Jesus, “Awan moy palla beman nabasa ten kasulatan a sapul pa ten sapul ay linalang nen Diyos en tolay a lállaki sakay bábbi? ");
INSERT INTO prfNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Sakay kinagi bi nen Diyos, ‘Kaya iwarak nen lállaki en dáddikál na hidi sakay magagum hidi ay ten kabinga na, sakay magin essa dán hidi.’ ");
INSERT INTO prfNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Kaya bakán dán hidi a duwwa nan essa dán. Kaya en pinagagum nen Diyos ay awan dapat a paghiwalayán nen tolay.” ");
INSERT INTO prfNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Kaya tinanung siya a ruway nen Pariseo hidi, “Ni konahud, ay bakin inyutus ni Moises a átdenan nen lállaki en kabinga na ti kasulatan ni pághiwalay bagu na siya a palakadán?” ");
INSERT INTO prfNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Tummábbig ti Jesus, “Gapu ti káttug ni ulu moyen kaya pinayagan ni Moises a hiwalayan moy en kákkabinga moy hidi. Peru sapul pa ten sapul ay bakán a konahud en planu nen Diyos. ");
INSERT INTO prfNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Kagiyán ku dikomoy, a en lállaki a humiwalay ten kabinga na, maliban a nangalunya iyud sakay nákkabinga ti iba a bábbi ay nagkasala ti pángngalunya.” ");
INSERT INTO prfNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Kinagi nen disepulus hidi kánni Jesus, “Ni konahud i kalagayanid nen lállaki ten kabinga na ay mas maganda pa ni dyan dálla siya mákkabinga.” ");
INSERT INTO prfNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Tummábbig ti Jesus, “Awan atanan ay makakaya a mangtanggap ti iyád a toldu nan en pinagkaluuban la hidi nen Diyos. ");
INSERT INTO prfNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Gapu tehud a sari-sari a dahilan ni bakin a tehud a lállaki a awan nákkabinga. En agum ay gapu ten dipirensiya sapul pa ten kákkeenak di, en agum ay gapu ten gamet nen agum a tolay kaya hidi a nagkakona haud. Tehud bi a awan nákkabinga alang-alang ten kahariyan dilanget. Ni deyaman en makatanggap ti iyád a toldu ay dapat iyád a gamitán nen tolay a makaintendi ti iyád a toldu.” ");
INSERT INTO prfNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Inyangay nen tolay hidi kánni Jesus en anak di hidi a bábbadit tánni itupu ni Jesus en lima na dikodi sakay ipagdasal na hidi. Peru nagsarantaan hidi nen disepulus na hidi. ");
INSERT INTO prfNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Peru kinagi ni Jesus, “Pabayan moy i anaken hidi a umadeni dikoku. Dyan moy hidi sawayán, gapu en kona dikodi en mebilang ten kahariyan dilanget.” ");
INSERT INTO prfNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Intupu ngani ni Jesus en lima na ten anak hidi, sakay lummakad siya. ");
INSERT INTO prfNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Nadid, tehud a essa a lállaki a ummadeni kánni Jesus sakay nagtanung, “Maistu, ánya i maganda kuwid a gamitán tánni magkahudák ti biyag a awan ti katapusan?” ");
INSERT INTO prfNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Tummábbig ti Jesus, “Bakin tanungánnák mu ni ánya i magandaid? Essa la i magandaid. Peru ni gustu mu a magkahud ti biyag a awan ti katapusan, ay sunudán mu en Kautusan nen Diyos.” ");
INSERT INTO prfNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","“Ánya a ka utus?” tanung nen binata. Tummábbig ti Jesus, “Dyan ka mamunu; dyan ka mangalunya; dyan ka magtakaw sakay dyan ka magbuli-buli ten págtistigu mu. ");
INSERT INTO prfNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Igalang mu en dáddikál mu hidi, sakay mahalán mu en kaparehu mu hidi a kona ten págmahal mu ten sadili mu.” ");
INSERT INTO prfNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Kinagi nen binata kánni Jesus, “Sinássunud ku dán i atananid a iyán, ánya pa i dapat kuwid a gamitán?” ");
INSERT INTO prfNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Tummábbig ti Jesus, “Ni gustu mu a magin ganap, ay ilaku mu en ari-ariyan mu hidi. Sakay iyatád mu en naglakuwan mu ten mágkahirap hidi sakay magkahud ka ti kayamanan dilanget. Káttapos ay sumoli ka sakay mákkuyug ka dikoku.” ");
INSERT INTO prfNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Pákkasanig nen lállaki ay malungkut siya a lummakad gapu tunay siya ti yaman. ");
INSERT INTO prfNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Sakay kinagi ni Jesus ten disepulus na hidi, “Tandaan moy: talaga mahirap a makasáddáp en essa a mayaman ten kahariyan dilanget! ");
INSERT INTO prfNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ruwayán ku a kagiyán: mas alistu pa en essa a kamelyu a makasáddáp ten ábbut nen digum nan ten essa a mayaman a makasáddáp ten kahariyan nen Diyos.” ");
INSERT INTO prfNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Ten dikona a masanig iyud nen disepulus hidi ay nagtaka hidi ti hustu sakay nagtanung hidi, “Panginoon, ni konahud ay deya maligtasid?” ");
INSERT INTO prfNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Inileng hidi ni Jesus sakay kinagi na, “Awan iyád magamet nen tolay, peru magamet nen Diyos en atanan a bagay.” ");
INSERT INTO prfNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Nagupos ti Pedro, “Ilingán mu, linakadan mi dán en atanan sakay nákkuyug kami dikomu. Ánya bi nadid i paraid dikomi?” ");
INSERT INTO prfNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Kinagi ni Jesus dikodi, “Tandaan moy iddi: ni maghari dán en Anak nen Tolay ten trono na a maluwalhati ti buuwiday a mundu, ay mággetnud kam bi ten sapulu ay ti duwwa a trono a magin pinunu nen sapulu ay ti duwwa a lahi ni Israel. ");
INSERT INTO prfNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Sakay ni deyaman en mángwarak ten bilay na, kákkapatkaka na hidi, dáddikál na hidi, anak na hidi sakay en luta na hidi alang-alang dikoku ay makatanggap ti datos a beses sakay magkahud siya ti biyag a awan ti katapusan. ");
INSERT INTO prfNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Peru makpal a nágdipalongu a medimudyan sakay makpal a nágdimudyan a medipalongu.” ");
INSERT INTO prfNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“En kahariyan dilanget ay meparehu ten essa a tolay a maagap a tarud a lummuwas tánni magaryok ti magtarabahu ten kaubasan na. ");
INSERT INTO prfNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ten dikona a magkasundu dán hidi ti upa a essa a dinaryo ti maghapun ay angay na dán hidi pinagtarabahu ten kaubasan na. ");
INSERT INTO prfNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Ten dikona a magalas nuwebi dán ten dimadimang ay lummuwas siya a ruway sakay naketa siya ti agum pa a palakad-lakad la ten palengki. ");
INSERT INTO prfNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Kinagi na dikodi, ‘Angay kam bi magtarabahu ten kaubasan ku ta upaan takam ti tama a pággupa.’ Kaya ummangay bi hidi. ");
INSERT INTO prfNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Linumuwas dámman siya ten tanghali dán, sakay dikona magalas tres dán ten apon, ay kona labi hud en ginamet na. ");
INSERT INTO prfNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Ten dikona a magalasingku dán ten apon ay linumuwas siya a ruway sakay naketa pa ti katolayan a awan ti gamet. Kinagi na dikodi, ‘Bakin a ked kam la háddi a mágtataknággán a maghapun?’ ");
INSERT INTO prfNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Tummábbig hidi, ‘Awan biyay bi ti mangatád dikomi ti tarabahu!’ Sakay kinagi na dikodi, ‘Ni kona bál hud ay kammoy dán magtarabahu ten kaubasan ku.’ ");
INSERT INTO prfNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Nadid, dikona apon dán ay kinagi nen makákkao ten kaubasan ten katiwala na, ‘Angay mu dán dulawán en nagtarabahu hidi sakay upaan mu hidi. Sapul ten kadimudyanan hanggan ten kapurumeruwan a nagtarabahu.’ ");
INSERT INTO prfNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","En nagsapul hidi ten magalasingku ten apon ay nakatanggap ti essa a denaryo. ");
INSERT INTO prfNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Sakay ten dikona a ummadeni en nágdipalongu hidi a nagtarabahu ay inisip di a makatanggap hidi ti mas higit haud; peru en balang essa dikodi ay tummanggap bi ti tatággessa di a dinaryo. ");
INSERT INTO prfNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Ten pákkatanggap di ten upa di ay nagreklamu hidi ten makákkao ten kaubasan. ");
INSERT INTO prfNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Kinagi di, ‘Bakin konahud, en dimudyan hidi a dummemát ay essa la hidi a odas a nagtarabahu. Peru inupaan moy hidi ti kona ten upa mi. Samantala sikami ay nágtatiisán ten makapasi a init nen aldew ten buu a maghapun. Bakin pare-parehu la en inyupa moy dikomi?’ ");
INSERT INTO prfNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Sakay kinagi nen makákkao ten kaubasan ten essa dikodi, ‘Amigu ku, awan taka dinaya. Awan beman pummayag ka ten essa a dinaryo a bayad moy? ");
INSERT INTO prfNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Alapán mu dán i upa muwen sakay maglakad ka dán. Upaan ku en dimudyan hidi ti kona ten upa mu ni gustu ku. ");
INSERT INTO prfNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Awanák beman ti karapatan a manggamet ten gustu ku ten sadili ku a ari-ariyan? Oni bakay sumeni kam la gapu ten kabaitan ku?’ ");
INSERT INTO prfNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Kaya kinagi ni Jesus dikodi, “En dimudyan ay medipalongu, sakay en nedipalongu ay medimudyan.” ");
INSERT INTO prfNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Nadid, ten dikona a maglakad de Jesus a patamu ti Jerusalem ay imbukud na en sapulu ay ti duwwa a disepulus na hidi. Sakay kinagi na dikodi, ");
INSERT INTO prfNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Ilingán moy, umangay kitam ti Jerusalem. Itokyon di haud en Anak nen Tolay ten pinunu hidi nen padi hidi sakay ten tagapagtoldu hidi nen Kautusan. Hatulan di siya ti kamatayan, ");
INSERT INTO prfNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","sakay iyatád di ten Hentil hidi. Insultuwán di siya, haplitán, sakay ipaku di ten kudus, peru ten katállu a aldew ay biyagán siya a ruway.” ");
INSERT INTO prfNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Nadid, ummadeni kánni Jesus en kabinga ni Zebedeo, kaguman na en duwwa na a anak a lállaki. Linumuhud siya ten atubengán ni Jesus gapu tehud siya a ipákpágguron. ");
INSERT INTO prfNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Tinanung siya ni Jesus, “Ánya i gustu muwid?” Tummábbig en bábbi, “Nakuwan ay ni maghari ka dán ay paetnudán mu a kadatig mu i anak kuwidi a duwwa. Essa ten kawiri sakay essa ten kawanan.” ");
INSERT INTO prfNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Peru tummábbig ti Jesus, “Awan moy tukoy ni ánya i agidán moyen. Kaya moy beman a tiisán en hirap a tiisán ku?” Tummábbig hidi, “Opo, kaya mi.” ");
INSERT INTO prfNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Sakay kinagi ni Jesus, “En hirap a tiisán ku ay matiis moy ngani. Peru bakán a sikán i mangpiliyid ni ti deya en mággetnud ten kawanan ku sakay ten kawiri ku. Hidi iyán a pággetnudan ay para ten pinánghandaan nen Ama ku.” ");
INSERT INTO prfNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Ten dikona a masanig iyud nen sapulu a disepulus ay nagsaranta hidi ten matkaka. ");
INSERT INTO prfNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Kaya pinaadeni hidi ni Jesus sakay kinagi na dikodi, “Tukoy moy a en pinunu nen Hentil hidi en maghari ten nasakupan na, sakay hidi en masunud ni ánya en gustu di. ");
INSERT INTO prfNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Peru bakán a konahud i dapatid a mangyari dikomoy. Nan ni deya en masor a magin pinunu ay dapat a magin tagapagserbi nen agum. ");
INSERT INTO prfNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Sakay ni deyaman en masor a magin kataasan ay dapat a magin alipin moy. ");
INSERT INTO prfNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Kona ten Anak nen Tolay ay ummangay háddi bakán a para pagserbiyan nan para magserbi sakay iyalay na en biyag na para matubus en makpal a tolay.” ");
INSERT INTO prfNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Dikona lumakad hidi ti Jerico ay ummunud kánni Jesus en tunay ti kakpal a tolay. ");
INSERT INTO prfNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Tehud a duwwa a burák a mággetnud ten gilid nen dilan. Ten dikona a masanig di a magtalib ti Jesus ay impáppákraw di a, “Panginoon, Anak ni David, kagbiyan mu kami pay!” ");
INSERT INTO prfNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Pinagkagiyan hidi nen katolayan a mágtahimik hidi, peru tulos di la impáppákraw a, “Panginoon, Anak ni David, kagbiyan mu kami pay!” ");
INSERT INTO prfNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Ummimang ti Jesus, dinulaw na hidi sakay tinanung na hidi, “Ánya i gustu moyid a gamitán ku dikomoy?” ");
INSERT INTO prfNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Tummábbig hidi, “Panginoon, gustu mi a maketa a ruway!” ");
INSERT INTO prfNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Kinagbiyan hidi ni Jesus sakay tinawidan na en mata di. Pagdaka hidi a naketa sakay nákkuyug hidi dikona. ");
INSERT INTO prfNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Dikona adeni dán de Jesus ay ten disepulus na hidi ti Jerusalem ay ummangay hidi ten banuwan a Betfage ten Bukid nen Olibo hidi. Pinágdipalongu na en duwwa ten disepulus na hidi. ");
INSERT INTO prfNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Kinagi na dikodi, “Angay kam ti sumunuden a banuwan. Ketan moy haud en inahin a asno a umáegut a kaguman na en anak na. Okbisán moy sakay iyangay moy dikoku. ");
INSERT INTO prfNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Ni tehud a mangsaway dikomoy ay kagiyán moy a, ‘Kailangan nen Panginoon,’ sakay iyatád na dán iyud a pagdaka.” ");
INSERT INTO prfNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Nangyari iyád tánni matupad en kinagi nen propeta a, ");
INSERT INTO prfNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Kagiyán moy ten taga-Zion hidi a, ‘Ilingán moy Hari moyen a mágdadedemát. Siya ay mapagpakumbaba, mágkabayu ti asno, mágkabayu ten bul-u ni asno.’ ” ");
INSERT INTO prfNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Lummakad dán en duwwa a disepulus sakay sinunud di en pagamet ni Jesus dikodi. ");
INSERT INTO prfNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Tinawid di en matina a asno a pinaangay ni Jesus. Insapin di en pággalikábkáb di hidi ten asno hidi sakay summakay ti Jesus. ");
INSERT INTO prfNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Inlatag bi nen makpal a tolay en pággalikábkáb di ten dilan sakay en agum ay nanggáppas ti pinget ni kayu sakay inlatag di bi ten dilan. ");
INSERT INTO prfNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Mamagpákrawan en tolay hidi a mágdipalongu dikona, kona bi hud ten umunonud hidi. Kinagi di, “Puriyán en anak ni David! Pagpalaán en mágdadedemát ten ngaran nen Panginoon! Puriyán en Diyos!” ");
INSERT INTO prfNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Dikona sumáddáp ti Jesus ti Jerusalem ay nagkagulu en banuwan. Namagtanungan hidi, “Deya wád iyán?” kagi di. ");
INSERT INTO prfNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","“Ti Jesus iyán, en propeta a taga-Nazaret ti Galilea,” tábbig nen kakpalan. ");
INSERT INTO prfNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Summáddáp ti Jesus ten Templo sakay pinaluwas na en máglaku hidi, kona bi hud ten mamali hidi. Sakay impágbaliktad na en lamisaan nen mágpalit hidi ti pilak sakay en bangku nen máglaku hidi ti kalapati. ");
INSERT INTO prfNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","“Nesulat ten Kasulatan a, ‘En bilay ku ay ngaranan a bilay a págdasalan.’ Peru ginamet moy a bilay nen mágtakaw hidi.” ");
INSERT INTO prfNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Ummadeni kánni Jesus en burák hidi sakay en pilay hidi, sakay pinagpiyya na hidi a atanan. ");
INSERT INTO prfNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Minagsaranta en pinunu hidi nen padi hidi sakay en tagapagtoldu hidi nen Kautusan dikona a ketan di en himala hidi a ginamet ni Jesus, sakay dikona a masanig di en anak hidi a magpákraw ten Templo ti kona háddi, “Puriyán en anak ni David!” ");
INSERT INTO prfNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Kinagi di kánni Jesus, “Masanig mu beman i kákkagiyán diyen?” “Uhu sássanigán ku,” tábbig ni Jesus. “Awan moy palla beman nabasa ten kasulatan en kona háddi, ‘Tinolduwan mu en anak hidi sakay en sumusu palla hidi a magpuri?’ ” ");
INSERT INTO prfNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Sakay linakadan hidi ni Jesus, lummuwas siya ten banuwan sakay ummangay siya ti Betania, haud siya a nagpalipas ti gibi. ");
INSERT INTO prfNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Ten kailawan, dikona summoli ti Jesus ten siyudad ay minagaláp siya. ");
INSERT INTO prfNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Netan na en kayu a igos ten gilid nen dilan, inadeniyan na sakay tinangad na ni tehud a bunga. Peru purus la a duun en netan na kaya kinagi na ten kayu, “Awan ka dán magbunga maski nikan!” Pagdaka a nalanás en kayu a igos. ");
INSERT INTO prfNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Dikona a ketan iyud nen disepulus na hidi ay minagtaka hidi ti hustu. “Konya a nalanás a pagdaka en igos?” tanung di. ");
INSERT INTO prfNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Tummábbig ti Jesus, “Kagiyán ku dikomoy, a ni manampalataya kam sakay awan magduda ay magamet moy bi iyád, sakay bakán la a iyád maari moy a kagiyán ti bukiden a, ‘Umibut ka haán, angay ka sumegbu ti digeten,’ ay mangyari. ");
INSERT INTO prfNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Sakay ányaman en agidán moy ten págdasal ay matanggap moy, ni tehud kam a pánnampalataya.” ");
INSERT INTO prfNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Summáddáp dámman a ruway ti Jesus ten Templo. Mentras a magtoldu siya ay ummadeni dikona en pinunu hidi nen padi hidi sakay en pinunu hidi nen banuwan sakay tinanung di siya, “Ánya i karapatan muwid a maggamet ti hidi iyád a bagay? Deya i nangatáddid dikomu ti karapatan?” ");
INSERT INTO prfNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Tummábbig ti Jesus, “Tanungán takam bi. Ni matábbigák moy ay kagiyán ku bi dikomoy ni deya i nangatáddid dikoku ti karapatan a maggamet ti bagayid a hidi iyád. ");
INSERT INTO prfNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Deya nangatáddid ten karapatan ni Juan para magbinyag, en Diyos beman oni en tolay?” Namágguron hidi. “Ni kagiyán tam a gubwat ten Diyos, ay kagiyán na bi dikotam a, ‘Bakin awan kam naniwala dikona?’ ");
INSERT INTO prfNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ni kagiyán tam bi a gubwat ti tolay, ay bakay bi ni ánya i gamitánnid ni katolayanen dikotam, gapu maniwala hidi a atanan a ti Juan ay essa a propeta.” ");
INSERT INTO prfNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Kaya tummábbig hidi kánni Jesus, “Awan mi tukoy!” Sakay kinagi ni Jesus dikodi, “Awan ku bi kagiyán dikomoy ni hádya i gubwatid nen karapatan ku a maggamet ti bagayid a hidi iyád.” ");
INSERT INTO prfNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“Ánya nadid palagay moyid háddi? Tehud a ama a tehud a duwwa a anak a lállaki. Ummadeni siya ten panganay sakay kinagi na, ‘Anak, angay ka magtarabahu nadid ten kaubasan.’ ");
INSERT INTO prfNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","‘Umáddák,’ kagi na. Peru nagbagu en isip na sakay ummangay. ");
INSERT INTO prfNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Ummadeni bi en ama ten wadi a kona labi hud en kinagi na. ‘Opo,’ tábbig nen wadi, peru awan ummangay. ");
INSERT INTO prfNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Deya ten duwwa i nangsunudid ten ama di? “En kaka,” tábbig di. Kinagi ni Jesus, “Kagiyán ku dikomoy, a en mágsinger hidi ti buwes sakay en bábbi hidi a mágkadukás ti kákkabiyag ay mágdipalongu pa dikomoy a makasáddáp ten kahariyan dilanget. ");
INSERT INTO prfNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Gapu ummangay háddi dikomoy ti Juan a nagtoldu ten págsunud ten kaluuban nen Diyos peru awan moy siya pinaniwalaan. Peru en mágsinger hidi ti buwes sakay en bábbi hidi a mágkadukás ti kákkabiyag ay naniwala dikona. Netan moy dán ngani, ay awan kam pa nagsisi sakay naniwala dikona.” ");
INSERT INTO prfNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“Sanigán moy i essa pa iday a talinhaga,” kagi ni Jesus. “Tehud a essa a tolay a nagmula ti ubas ten luta na. Kinudal na iyud, naggamet ti págpáspássan, sakay naggamet ti malangkaw a bilay a págbantayan. Káttapos ay inwarak na en kaubasan ten katiwala na hidi sakay ummangay siya ti iba a lugar. ");
INSERT INTO prfNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Dikona dummemát dán en panahun nen sákburas, ay inutusan nen makákkao ten kaubasan en alipin na hidi para angen di en kabunong na. ");
INSERT INTO prfNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Peru sinunggaban nen katiwala hidi en alipin hidi; binulbug di en essa, binunu di en kaduwwa, sakay binatu di en katállu. ");
INSERT INTO prfNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Inutusan a ruway nen makákkao en mas makpal a alipin na, peru kona labi hud en ginamet nen katiwala na hidi. ");
INSERT INTO prfNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Ten katapusan ay inutusan nen makákkao en anak na a lállaki. Gapu inisip na a, “Igalang di iyád i anak kuwiday.” ");
INSERT INTO prfNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Peru dikona a ketan nen katiwala hidi en anak nen makákkao ay kinagi di, ‘Siya iddi i magmanaid. Kamon dán! Bunuwán tam siya sakay kaowán tam en mana na.’ ");
INSERT INTO prfNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Kaya sinunggaban di siya, inluwas di ten kaubasan, sakay binunu di.” ");
INSERT INTO prfNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Tinanung hidi ni Jesus, “Kássoli nen makákkao ten kaubasan, ánya wád i gamitán naid ten katiwala na hidi?” ");
INSERT INTO prfNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Tummábbig hidi, “Bunuwán na en mágkadukás hidi a katiwala. Sakay ipabahala na en kaubasan ti iba a katiwala a máng-atád ten kabunong na kada a sákburas.” ");
INSERT INTO prfNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Kinagi ni Jesus dikodi, “Awan moy palla beman nabasa ten Kasulatan a kinagi na, ‘En batu a inadiyan nen mággamet hidi ti bilay, ay siya bali en pinakamahalaga a pamireng. Ginamet iyád nen Panginoon, sakay makataka-taka a áelingán!’ ");
INSERT INTO prfNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Kaya ngani a kagiyán ku dikomoy, a en kahariyan nen Diyos ay alapán dikomoy sakay iyatád ten tolay hidi a matapat a magserbi dikona. ");
INSERT INTO prfNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","En medapag ti batuwid a iyád ay maritu-ritu, sakay en matáppugan na ay mapapárset. ");
INSERT INTO prfNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Nasanig nen pinunu hidi nen padi sakay en Pariseo hidi en talinhaga ni Jesus sakay naintendiyan di a hidi en patamaan na. ");
INSERT INTO prfNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Dikáppán di nakuwan ti Jesus, peru minanteng hidi ten katolayan gapu tenggiyán di ti Jesus a propeta. ");
INSERT INTO prfNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Nagtulos la a nagtoldu ti Jesus ten pamamag-itan ni talinhaga, kinagi na, ");
INSERT INTO prfNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“En kahariyan dilanget ay kona ten essa a hari a naghanda para ten kasal nen anak na a lállaki. ");
INSERT INTO prfNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Inutusan na en tagapagserbi na hidi para dulawán di en inimbita hidi, peru umád hidi a umangay. ");
INSERT INTO prfNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Nagutus siya a ruway ten agum hidi a tagapagserbi sakay binilinan na hidi ti kona háddi: ‘Ikagi moy ten naimbitaan hidi a ayus dán en handaan nakahanda dán a atanan, nabunu ku dán en baka ku hidi, sakay en pinatabi hidi a bul-u a baka. Nakahanda dán en atanan. Kamon dán!’ ");
INSERT INTO prfNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Peru awan iyád sinanig nen naimbitaan hidi. Ummangay hidi ten gustu di a angayan. En essa ay ummangay ten uma na, en essa bi ay ummangay ten nigosyu na. ");
INSERT INTO prfNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","En ginamet nen agum ay sinunggaban di en tagapagserbi hidi, ininsultu di hidi sakay binunu. ");
INSERT INTO prfNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Minaiyamut ti hustu en hari. Inutusan na en sundalu na hidi a bunuwán i mágbabonuwid a hidi iyud sakay pinatutud na en banuwan di. ");
INSERT INTO prfNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Káttapos ay kinagi na ten tagapagserbi na hidi, ‘Ayus dán en handaan, peru awan karapatdapat en naimbitaan hidi. ");
INSERT INTO prfNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Umangay kam ten karsada hidi a matolay, sakay imbitaán moy ten kasalan en atanan tolay a ketan moy.’ ");
INSERT INTO prfNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Ummangay ngani en alipin hidi ten matolay hidi a karsada. Ingkuyug di en atanan tolay a netan di, mágkabait ay ti mágkadukás. Kaya naputat en kasalan ti bisita. ");
INSERT INTO prfNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Peru dikona sumáddáp en hari para batiyán na en tolay hidi, ay naketa siya haud ti essa a lállaki a awan nakabadu ti pangkasalan. ");
INSERT INTO prfNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Kaya kinagi nen hari dikona, ‘Amigu ku, konya nakasáddáp muwid háddi a awan ka nakabadu ti pangkasalan?’ Awan nakapagupos en lállaki. ");
INSERT INTO prfNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Kinagi nen hari ten tagapagserbi na hidi, ‘Punguwán moy i lima naen sakay básset naen, sakay ibut moy ti kadiklámmanon diluwas. Haud siya a mágsasangitán sakay mággaaduyán.’ ");
INSERT INTO prfNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Káttapos ay kinagi ni Jesus, ‘Makpal en nadulaw, peru sabadit la en pinili.” ");
INSERT INTO prfNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Káttapos ay lummakad en Pariseo hidi sakay namágguronan di ni konya di a mepatibung ti Jesus ten kákkagiyán na hidi. ");
INSERT INTO prfNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Kaya inutusan di en sangan ten disepulus di hidi kánni Jesus kaguman en tolay hidi ni Herodes. Sakay kinagi nen inutusan hidi, “Maistu, tukoy mi a matapat ka, sakay itáttoldu mu en tatarudan tungkul ten kagustuwan nen Diyos a gamitán nen tolay. Sakay awan ka ti paboran gapu parehu en pangileng mu ten tolay. ");
INSERT INTO prfNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Ánya makagi muwid háddi? Tama beman ten Kautusan a magbayad ti buwes ten Emperador, oni awan?” ");
INSERT INTO prfNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Peru tukoy ni Jesus en balak di a madukás kaya kinagi na, “Bakin gustuwák moy a ipatibung! Sikam a magkukunwari hidi? ");
INSERT INTO prfNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Kotam ti pilak a págbuwes.” Inátdenan di siya ti essa a dinaryo. ");
INSERT INTO prfNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Sakay kinagi na dikodi, “Kándeya a rupa sakay ngaran en nakaukit háddi?” ");
INSERT INTO prfNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","“Ten Emperador,” tábbig di. Sakay kinagi na dikodi, “Ni konahud, ay iyatád moy ten Emperador en para dikona, sakay iyatád moy ten Diyos en para ten Diyos.” ");
INSERT INTO prfNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Minagtaka hidi dikona masanig di iyud, sakay lummakad dán hidi. ");
INSERT INTO prfNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Ti aldew biyid a iyud ay ummangay kánni Jesus en sangan a Saduseo. Awan hidi iyád maniwala a mabiyag a ruway en patay hidi. ");
INSERT INTO prfNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Kinagi di, “Maistu, intoldu ni Moises a ni matay a awan ti anak en essa a lállaki a tehud a kabinga ay pakasalan nen kapatkaka na en bilu tánni magkaanak hidi para magin anak nen natay. ");
INSERT INTO prfNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Nadid, tehud háddi a pittu a lállaki a matátkaka. Nákkabinga en panganay sakay natay a awan ti anak, kaya kinabinga nen wadi na en bilu. ");
INSERT INTO prfNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Kona labi hud en nangyari ten kaduwwa, katállu hanggan ten kapittu. ");
INSERT INTO prfNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Káttapos di a natay atanan ay natay bi en bábbi. ");
INSERT INTO prfNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Nadid, deya ten pittu i magin kabingaid nen bábbi ten kákkabiyag a ruway, ta nagin kabinga na hidi a atanan?” ");
INSERT INTO prfNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Tummábbig ti Jesus, “Liwat a tarud i ked ti isip moyen! Palibhasa awan moy tukoy en Kasulatan maski en kapangyariyan nen Diyos. ");
INSERT INTO prfNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Ten kákkabiyag a ruway ay awan dán mákkabinga en tolay, nan magin kona dán hidi ten anghel hidi dilanget. ");
INSERT INTO prfNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Nadid, tungkul ten kákkabiyag a ruway nen patay hidi, ay awan moy palla beman nabasa en kinagi nen Diyos dikomoy ten Kasulatan? Kinagi na, ");
INSERT INTO prfNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Sikán en Diyos ni Abraham, en Diyos ni Isaac, sakay en Diyos ni Jacob.’ En Diyos ay bakán a Diyos nen patay hidi, nan nen biyag hidi.” ");
INSERT INTO prfNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Dikona masanig iyud nen katolayan ay nagtaka hidi ten intoldu na. ");
INSERT INTO prfNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Minagipun-ipun en Pariseo hidi dikona a nasanig di a awan nakatábbig en Saduseo hidi kánni Jesus. ");
INSERT INTO prfNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","En essa dikodi ay maistu nen Kautusan. Pinurbaan na a tinanung ti Jesus para linlangán na. ");
INSERT INTO prfNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Maistu, ánya i pinakamahalagaid a utus ten Kautusan?” tanung na. ");
INSERT INTO prfNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Tummábbig ti Jesus, “Mahalán mu en Panginoon mu a Diyos ti buu a pusu, buu a kaluluwa, sakay buu a isip. ");
INSERT INTO prfNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Siya iyád en pinakamahalaga a utus ten atanan. ");
INSERT INTO prfNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","En kaduwwa a mahalaga a utus ay iddi: Mahalán mu en kaparehu mu a tolay a kona ten págmahal mu ten sadili mu. ");
INSERT INTO prfNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","I duwwaid a iyád a utus ay kabuuwan nen Kautusan ni Moises sakay ten toldu nen propeta hidi.” ");
INSERT INTO prfNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Nadid, mentras a naipun-ipun en Pariseo hidi ay tinanung hidi ni Jesus, ");
INSERT INTO prfNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Ánya palagay moyid tungkul ten Cristo? Kándeya siya a anak?” “Kánni David,” tábbig di. ");
INSERT INTO prfNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Tummábbig ti Jesus, “Ni konahud, ay bakin dinulaw siya ni David a ‘Panginoon’ dikona a inggiyya siya nen Ispiritu?” Kinagi na, ");
INSERT INTO prfNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Kinagi nen Panginoon ten Panginoon ku, Mággetnud ka ti kawanan kuwidi, mentras awan ku mapasuku dikomu en atanan nen kadima mu hidi. ");
INSERT INTO prfNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Nadid, ni dinulaw siya ni David a ‘Panginoon,’ konya a makagi a anak ni David en Cristo?” ");
INSERT INTO prfNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Awan ti nakapangtábbig kánni Jesus, sakay sapul haud ay awan dán ti nangahas pa a magtanung dikona. ");
INSERT INTO prfNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Káttapos iyud ay kinagi ni Jesus ten katolayan sakay ten disepulus na hidi, ");
INSERT INTO prfNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“En tagapagtoldu hidi nen Kautusan ay ten Pariseo hidi ay hidi en tehud a karapatan a mángpaliwanag ten Kautusan ni Moises. ");
INSERT INTO prfNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Kaya dapat moy a gamitán sakay sunudán en atanan a itáttoldu di. Peru dyan moy arigán en gamet di, gapu awan di gamitán en itáttoldu di. ");
INSERT INTO prfNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Pagkargaán di ti madággi en tolay, peru ni guramát di ay awan di iyarikad para makatulung ten págkarga. ");
INSERT INTO prfNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Sakay en gággamitán di ay kunwari la tánni ketan la ni tolay. Padáddekállán di en págdáttonan di hidi ti bersikulu a nakabákkád ten muding di sakay ten barasu di hidi, sakay paatakdugán di en maroymaroy nen garayan nen badu di. ");
INSERT INTO prfNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Gugustu di bi a mágyan ten lugar hidi a marangal ten handaan. Kona ten bangku hidi a para ten mágkataas ten sinagoga. ");
INSERT INTO prfNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Gugustu di bi a batiyán ti pággalang ten matolay hidi a lugar sakay mangaranan a ‘maistu.’ ");
INSERT INTO prfNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Peru sikam ay dyan kam pangaran a ‘maistu,’ gapu eessa la en Maistu moy, sakay matátkaka kam a atanan. ");
INSERT INTO prfNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Sakay dyan kam magngaran ti Ama ten deyaman ti lutaiday. Gapu eessa la en Ama moy a ked dilanget. ");
INSERT INTO prfNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Dyan kam bi pangaran a ‘panginoon.’ Gapu eessa la en Panginoon moy, awan ti iba nan en Cristo. ");
INSERT INTO prfNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","En kataasan dikomoy ay dapat a magin tagapagserbi moy. ");
INSERT INTO prfNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","En magpakataas ay mebaba, sakay en magpakababa ay metaas.” ");
INSERT INTO prfNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Peru kakagbi kam a tagapagtoldu hidi nen Kautusan sakay sikam a Pariseo hidi! Magkukunwari kam! Harangán moy en tolay hidi tánni awan makasáddáp ten kahariyan dilanget. Gapu sikam a mismu ay umád a sumáddáp haud. ");
INSERT INTO prfNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","“Kakakagbi kam a tagapagtoldu hidi nen Kautusan sakay sikam a Pariseo hidi! Magkukunwari kam! Kákkamkamán moy en kabiyagan nen bilu hidi a bábbi, sakay magparaan kam ten pamamag-itan nen atakdug a págdasal. Kaya lalu a dumággi en parusa moy! ");
INSERT INTO prfNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Kakakagbi kam a tagapagtoldu hidi nen Kautusan sakay sikam a Pariseo hidi! Magkukunwari kam! Lebután moy en susuluk ni munduwiday sakay digidigeten para makaakit kam la ti essa a Hentil ten pánnampalataya a Judio. Ni makaakit kamon ay gamitán moy siya a mas madukás pa nan sikam, kaya mas dikál en pagkakataun a maparusaan siya ti impiyerno. ");
INSERT INTO prfNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Kakakagbi kam a burák a tagagiyya! Itáttoldu moy a ni gamitán nen manumpa en Templo ay bali awan la iyud. Peru ni gamitán nen manumpa en gintu ten Templo ay kailangan a tupadán na en sinumpaan na. ");
INSERT INTO prfNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Burák kam sakay awan ti nakám! Ánya beman i mas mahalagaid, en gintu oni en Templo a mangpabanal ten gintu? ");
INSERT INTO prfNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Kákkagiyán moy bi a ni gamitán nen manumpa en altar ay bali awan la iyud. Peru ni gamitán nen manumpa en alay ten altar ay kailangan a tupadán na en sinumpaan na. ");
INSERT INTO prfNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Burák kam! Ánya beman i mas mahalagaid, en alay oni en altar a mangpabanal ten alay? ");
INSERT INTO prfNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Kaya ni gamitán nen deyaman a manumpa en altar, ay ginamit na iyud pati en alay ten altar. ");
INSERT INTO prfNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Ni ginamit nen deyaman a manumpa en Templo ti pangaku ay ginamit na maski en Diyos a mágyan ten Templo. ");
INSERT INTO prfNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Sakay ni ginamit nen deyaman a manumpa en langet, ay ginamit na en trono nen Diyos, sakay en Diyos a mággetnud a haud. ");
INSERT INTO prfNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Kakakagbi kam a tagapagtoldu hidi nen Kautusan sakay sikam a Pariseo hidi! Magkukunwari kam! Magikapu kam maski ten naani moy hidi ten pangrikadu hidi. Peru linimon moy bi en mas mahalaga hidi a adal a ked ten Kautusan, kona ten katarungan, habag, sakay katapatan. Tama la a gamitán moy iyud peru awan dapat a kalimunan en agum. ");
INSERT INTO prfNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Sikam a burák a tagagiyya! Saraán moy en insektu hidi ten inumán moy, peru itálmok moy bi en kamelyu! ");
INSERT INTO prfNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Kakakagbi kam a tagapagtoldu hidi nen Kautusan sakay sikam a Pariseo hidi! Magkukunwari kam! Áugasan moy en luwas nen tasa sakay penggan moy, peru ten disalad ay putat ti kasakiman sakay pagkamakasadili. ");
INSERT INTO prfNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Burák a Pariseo! Ugasan mu pa en disalad nen tasa sakay penggan, sakay magin malinis dán bi en luwas na! ");
INSERT INTO prfNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Kakakagbi kam a tagapagtoldu hidi nen Kautusan sakay sikam a Pariseo hidi! Magkukunwari kam! Kumán kam a en lábbáng a pininturan ti mapudew, maganda ten luwas na. Peru ten disalad ay putat ti bungu sakay atanan a madingát. ");
INSERT INTO prfNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Kona kam haán! Ten pangileng ay mágkabait kam a tolay. Peru disalad ay putat kam ti págkukunwari sakay kadukássan. ");
INSERT INTO prfNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Kakakagbi kam a tagapagtoldu hidi nen Kautusan sakay sikam a Pariseo hidi! Magkukunwari kam! Naggamet kam ti mágkaganda a páglábbángngan nen propeta hidi tenhud, sakay pinaganda moy en páglábbángngan nen mágkabait hidi a tolay. ");
INSERT INTO prfNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Sakay kákkagiyán moy a, ‘Ni biyag kami la ten panahun nen ninunu mi hidi, ay awan kami nakuwan kaguman a nangbunu ten propeta hidi.’ ");
INSERT INTO prfNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Kaya gapu ti kinagi moyen, ay sikamon a mismu en nangpatunay a anak kam nen nangbunu hidi ten propeta hidi! ");
INSERT INTO prfNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Hala sigi! Tapusán moy en sinapulan nen ninunu moy hidi! ");
INSERT INTO prfNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Sikam a lahi hidi ni biklat! Awan moy maginanan en parusa moy ti impiyerno! ");
INSERT INTO prfNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Kaya mángpaangayák haán dikomoy ti propeta hidi, mágkatalinu a tolay sakay tagapagtoldu hidi! Bunuwán moy en agum, sakay en agum ay ipaku moy ten kudus. En agum ay bálbággán moy ten sinagoga moy hidi, sakay usigán moy hidi ten banu-banuwan. ");
INSERT INTO prfNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Kaya pagtáknangan kam nen parusa nen kákkabunu nen atanan a matuwid a tolay ti munduwiday. Sapul ten pángbunu kánni Abel a awan ti kasalanan. Hanggan ten pángbunu kánni Zacarias a anak ni Baraquias a binunu moy ten pag-itan nen págtutudan ti alay ten Templo. ");
INSERT INTO prfNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Kagiyán ku dikomoy, a pagtáknangan nen parusa en tolay hidi nadid a panahun gapu ti atananid a iyád.” ");
INSERT INTO prfNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Sikam a taga-Jerusalem hidi! Bábbunuwán moy en propeta hidi, sakay bábbatuwán moy en inutusan hidi nen Diyos a angay dikomoy! Pumensangan ku dán a gustu a puronán en anak mu hidi a kona ten pánglákkáp nen inahin a manok ten sepsep na hidi. Peru umád kam! ");
INSERT INTO prfNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Kaya en Templo moy ay mapabayan, awan ti mamágyan. ");
INSERT INTO prfNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Kagiyán ku dikomoy, a awanák moy dán keketan hanggan ni dumemát en odas a kagiyán moy a, ‘Pagpalaán en dumáddadedemát ten ngaran nen Panginoon!’ ” ");
INSERT INTO prfNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Lummakad ti Jesus ten Templo. Mentras a maglakad siya ay ummadeni dikona en disepulus na hidi sakay intoldu di dikona en bilay hidi ten laguwerta nen Templo. ");
INSERT INTO prfNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Peru kinagi na dikodi, “Namalas moy i bilayid a hidi iyán! Tatarudan i kagiyán kuwidi! Dumemát en panahun a awan haán ti batu a tumáttopu ten kaparehu na a batu. Atanan ay makuray-kuray!” ");
INSERT INTO prfNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Dikona a mággetnud ti Jesus ten Bukid nen Olibo hidi, ay pasekretu a ummadeni dikona en disepulus na hidi sakay nagtanung, ‘Nikan a mangyari i bagayid a hidi iyád? Ánya i maariyid a senyal a paketan ten kássoli mu a ruway sakay ten katapusan ni munduwiday?’ ");
INSERT INTO prfNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Tummábbig ti Jesus, “Mangilag kam tánni awan kam metawtaw nen deyaman! ");
INSERT INTO prfNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Gapu makpal a lumitaw a magkagi a, ‘Sikán en Cristo!’ Makpal en metawtaw di. ");
INSERT INTO prfNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Makasanig kam ti labanan sakay makabareta ti gera ti iba a lugar. Dyan kam mabalisa dapat a mangyari hidi iyád. Peru bakán palla a iyád en katapusan ni munduwiday. ");
INSERT INTO prfNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Maglaban-laban en bansa hidi, kona bi hud en kahariyan ten kaparehu na a kahariyan. Magkahud ti aláp sakay maglinug ti iba-iba a lugar. ");
INSERT INTO prfNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Atananid a iyád ay sapul palla nen pághirap a kona ten magenak. ");
INSERT INTO prfNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Ti panahunid a iyud ay dikáppán di kam, pahirapan sakay bunuwán. Sakay kaiyamutan kam nen atanan gapu dikoku. ");
INSERT INTO prfNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Makpal en mangadág ten pánnampalataya di ti panahunid a iyud. Mamagiyamutan en balang essa sakay mamágpasubuwan. ");
INSERT INTO prfNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Sakay makpal bi a lumitaw a awan tatarudan a propeta, sakay itawtaw di en makpal a tolay. ");
INSERT INTO prfNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Gapu ten kákkakpal nen kadukássan ay manglamig en págmahal nen kakpalan. ");
INSERT INTO prfNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Peru en manatili a tapat hanggan ten katapusan ay maligtas. ");
INSERT INTO prfNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Sakay ipangaral en Maganda a Bareta tungkul ten pághari nen Diyos ti buuwiday a mundu, tánni masanig nen atanan a bansa. Sakay dumemát dán en katapusan.” ");
INSERT INTO prfNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Intendiyán moy iyád ti mapiyya: ni ketan moy dán a mangyari ten Banal a Lugar en tunay ti dukás a gamet a awan ti kaparehu a kinagi ni propeta Daniel, ");
INSERT INTO prfNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","ay en ked hidi ti Judea ay dapat a guminan dán ten bukid hidi. ");
INSERT INTO prfNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","En ked ten bubungan ay dyan dán magabala a mángngay ti ányaman ten disalad nen bilay na. ");
INSERT INTO prfNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Sakay en ked ten uma na ay dyan dán umuli para mángngay ti pagalikábkáb na. ");
INSERT INTO prfNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Kakakagbi en mágkabuktet hidi sakay en tehud hidi a anak a sumusu ti aldewid a hidi iyud! ");
INSERT INTO prfNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Ipagdasal moy a en kágginan moy ay awan metaun ti sákdágnen sakay Aldew ni Káimang. ");
INSERT INTO prfNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Gapu ti panahunid a iyud ay magdanas en atanan a tolay ti dikál a kahirapan a awan palla naranasan sapul dikona lalangán i munduwiday a hanggan nadid. Sakay awan dán iyud mangyari a ruway. ");
INSERT INTO prfNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Sakay ni awan paaperitán nen Diyos i aldewid a hidi iyud ay awan ti maburay a tolay. Peru alang-alang ten pinili na hidi ay paaperitán nen Diyos i aldewid a hidi iyud. ");
INSERT INTO prfNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Sakay ni tehud a magkagi dikomoy a, ‘En Cristo laid!’ oni ‘Ked siya hudi!’ ay dyan kam maniwala. ");
INSERT INTO prfNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Gapu tehud a lumitaw a awan tatarudan a Mesias, sakay awan tatarudan a propeta. Mángpeta hidi ti senyales sakay makataka hidi a himala, tánni itawtaw di en makpal pati en pinili hidi nen Diyos. ");
INSERT INTO prfNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Tandaan moy, indipalongu ku dán iyád a ingkagi dikomoy tánni makapaghanda kam. ");
INSERT INTO prfNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Kaya ni kagiyán di a, ‘Ked siya ti parangud,’ dyan kam angay haud. Ni kagiyán di a, ‘Ked siya disáddáp,’ dyan kam maniwala. ");
INSERT INTO prfNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Gapu ni sakonya a kabilis en kilat ti sikatan a mangdemlag hanggan ti sarámman, ay kona bi hud en káddemát nen Anak nen Tolay. ");
INSERT INTO prfNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","“Ni hádya i páppágyananid nen bangkay ay ked bi hud en wakwak hidi.” ");
INSERT INTO prfNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Káttapos ni panahunid a iyud ni kahirapan, ay dumiklám en aldew, sakay awan dán dumemlag en bulan. Mágkaragrag en biton hidi dilanget, sakay mayanág en kapangyariyan hidi ten kalawakan. ");
INSERT INTO prfNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Sakay lumitaw dán en senyal nen Anak nen Tolay dilanget. Magkahud ti kalungkutan en atanan a tolay ti munduwiday pákketa di ten Anak nen Tolay a ked ten panganurin. Dumemát siya a tehud a dakila a kapangyariyan sakay dikál a karangalan. ");
INSERT INTO prfNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Sakay ten káttánnug nen trumpeta ti mabegsák ay utusan na en anghel na hidi ten atanan a suluk ni munduwiday, puronán di en atanan a tolay a pinili nen Diyos ten bawat lugar. ");
INSERT INTO prfNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Ilingán moy en adal ten kayu a igos; kapag ni sumariwa en pinget na hidi sakay magduun ay makagi moy a adeni dán a kássinag. ");
INSERT INTO prfNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Kona labi hud, ni ketan moy dán i atananid a iyád, ay makagi moy a adeni dán en kássoli na, kumán a pasáddáp dán ten pintuwan. ");
INSERT INTO prfNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Kagiyán ku dikomoy, mangyari i atananid a iyád bagu a matay en tolay hidi a biyag nadid. ");
INSERT INTO prfNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Mawan en langet ay ten luta, peru en upos ku ay manatili a awan ti katapusan.” ");
INSERT INTO prfNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Peru awan ti makatukoy ten aldew ay ten odas a mangyari iyád. Magin en anghel hidi dilanget oni en Anak ay awan makatukoy, nan en Ama la. ");
INSERT INTO prfNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","En káddemát nen Anak nen Tolay ay magkakona ten káddemát nen lonsu ten panahun ni Noe. ");
INSERT INTO prfNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Ti panahunid a iyud ay mamagkainan, mamaginoman, sakay mamagkabingaan en tolay hidi. Hanggan dikona a sumakay dán ti Noe ten barku. ");
INSERT INTO prfNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Kaya dummemát en lonsu a awan hidi ti nangmalayan, sakay nágkalimás hidi a atanan. Kona labi hud i mangyariyid ten káddemát nen Anak nen Tolay. ");
INSERT INTO prfNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Ti panahunid a iyud, ay tehud a duwwa a lállaki a magtarabahu ten uma di; maalap en essa sakay mawarak en essa. ");
INSERT INTO prfNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Tehud a duwwa bábbi a maggiling; maalap en essa sakay mawarak en essa. ");
INSERT INTO prfNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Kaya humanda kam gapu awan moy tukoy ni nikan a dumemát en Panginoon moy. ");
INSERT INTO prfNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Tandaan moy iddi: ni tukoy la nen pinunu nen sabilay ni ánya a odas ten gibi a dumemát en mágtakaw, ay magbantay siya sakay awan na pabayan a masáddáp en bilay na. ");
INSERT INTO prfNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Kaya dapat kam bi a magin handa, gapu dumemát en Anak nen Tolay ten odas a awan moy inasaan.” ");
INSERT INTO prfNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Ni deyaman en matapat sakay matalinu ten tagapagserbi hidi ay siya i pamahalaánnid nen amu di ten agum a tagapagserbi. Siya en mangatád dikodi ti pagkain ten tama a panahun. ");
INSERT INTO prfNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Pinagpala i tagapagserbiyid a iyud ni demáttan siya nen amu na a saiyud i gamitán naid! ");
INSERT INTO prfNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Kagiyán ku dikomoy, a gamitán siya nen amu na a mamahala ten atanan a ari-ariyan na. ");
INSERT INTO prfNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Peru ni kagiyán ni tagapagserbiyid a iyud a, ‘Malay padi a sumoli en amu ku.’ ");
INSERT INTO prfNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Kaya sapulan na a bulbugán en kaparehu na hidi a tagapagserbi. Sakay mákpagkainan siya, sakay mákpaginoman ten lasinggeru hidi. ");
INSERT INTO prfNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Sumoli en amu ni tagapagserbiyid a iyud ten aldew a awan na inasaan, sakay ten odas a awan na tukoy. ");
INSERT INTO prfNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Sakay parusaan siya nen amu na ti mahigpit, sakay ipisan na siya ten magkukunwari hidi. Haud siya a mágsasangitán sakay mággaaduyán.” ");
INSERT INTO prfNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“En kahariyan dilanget ay kona ten sapulu a dalaga a tehud a manga tawid a simbuwan, angay hidi tumagbu ten lállaki a ikasal. ");
INSERT INTO prfNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","En limma dikodi ay mangmang sakay en limma ay mágkatalinu. ");
INSERT INTO prfNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","En limma a mangmang ay tehud a manga simbuwan, peru awan hidi nangtawid ti riserba di a langis a pangasák di ten simbu di. ");
INSERT INTO prfNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Samantala en limma a mágkatalinu ay nagtawid ti riserba bukud pa ten ked ten simbu di. ");
INSERT INTO prfNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Minaatrasadu en káddemát nen lállaki a ikasal kaya minagtongka hidi sakay minetidug a atanan. ");
INSERT INTO prfNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Peru dikona hatinggabi dán ay tehud a pinumákraw, ‘Ked dán en lállaki a ikasal! Tagbuwán moy dán!’ ");
INSERT INTO prfNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Pagdaka a ummikat en sapulu a dalaga sakay hinusay di en simbuwan di hidi. ");
INSERT INTO prfNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Kinagi nen mangmang hidi ten mágkatalinu, ‘Átdenan moy kami pay ti langis moyen, maadáp dán i simbuwan miyiday hidi.’ ");
INSERT INTO prfNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","‘Bakay awan dán maghustu dikotam a atanan, mas maganda pa ni angay kam dálla mamali ti tindaanon ti para kao moy,’ tábbig nen mágkatalinu hidi. ");
INSERT INTO prfNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Kaya angay namali en limma a mangmang. Mentras a mamali hidi, ay dummemát en lállaki a ikasal. Nakaguman na a summáddáp ten kasalan en limma a nakahanda, sakay insiradu en pintuwan. ");
INSERT INTO prfNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Káttapos, ay dummemát bi en limma a mangmang. Magpákraw hidi, ‘Panginoon, pasáddáppán mu kami!’ ");
INSERT INTO prfNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Peru tummábbig siya, ‘Tatarudan i kagiyán kuwidi dikomoy, awan takam matenggi.’ ");
INSERT INTO prfNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Káttapos ay kinagi ni Jesus, “Kaya ngani a magbantay kam, gapu awan moy tukoy en aldew ay ten odas.” ");
INSERT INTO prfNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“En kahariyan dilanget ay kona ten essa a tolay a magbiyahi. Dinulaw na en tagapagserbi na hidi sakay inyentrega na dikodi en ari-ariyan na hidi. ");
INSERT INTO prfNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Inátdenan na ti pilak en balang essa ayun ten kaya na. En essa ay inátdenan na ti limmang libu, en essa ay duwanglibu, sakay en essa ay sanglibu. Káttapos ay lummakad dán siya. ");
INSERT INTO prfNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Lummakad a pagdaka en nakatanggap ti limmang libu sakay innigosyu na. Sakay kinumita ti limmang libu pa. ");
INSERT INTO prfNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Kona bi hud ten nakatanggap ti duwanglibu, sakay kinumita bi ti duwanglibu pa. ");
INSERT INTO prfNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Peru en nakatanggap ti sanglibu ay ingkali na ten luta en pilak nen amu na. ");
INSERT INTO prfNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Dikona makalipas en nalay a panahun ay dummemát en amu ni tagapagserbiyid a hidi iyud sakay nákpagkuwentaan dikodi. ");
INSERT INTO prfNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Ummadeni en nakatanggap ti limmang libu sakay kinagi na, ‘Maistu, sadánnid en pilak mu a limmang libu sakay i limmang libu paidi a kinita ku.’ ");
INSERT INTO prfNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Kinagi nen amu na, “Malalaki! Matapat sakay mahusay a tagapagserbi! Gapu nagin matapat ka ten sabadit a halaga, ay pamahalaán taka ti dikál a halaga. Mákpagkasayaan ka dikoku.’ ");
INSERT INTO prfNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Ummadeni bi en nakatanggap ti duwanglibu, sakay kinagi na, “Maistu, sadánnid en pilak mu a duwanglibu a inyatád mu dikoku. Sakay i duwanglibu paidi a kinita ku.’ ");
INSERT INTO prfNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Kinagi nen amu na, “Malalaki! Matapat sakay mahusay a tagapagserbi! Gapu nagin matapat ka ten sabadit a halaga, ay pamahalaán taka ti dikál a halaga. Mákpagkasayaan ka dikoku!’ ");
INSERT INTO prfNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Sakay ummadeni bi en nakatanggap ti sanglibu, sakay kinagi na, “Maistu, tukoy ku a istriktu ka. Magburas ka ten awan mu immula, sakay maggapas ten awan mu sinabugan.’ ");
INSERT INTO prfNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Minantingák kaya ingkali ku ten luta en pilak mu. Sadánnid en sanglibu mu.’ ");
INSERT INTO prfNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Kinagi nen amu na, ‘Madukás sakay tamad a tagapagserbi! Tukoy mu dán bali a magburasák ten awan ku immula, sakay maggapasák ten awan ku sinabugan! ");
INSERT INTO prfNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Bakin awan mu dálla indipositu ti bangku, tánni tehudák nakuwan a kinita nadid?’ ");
INSERT INTO prfNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Alapán moy dikona en sanglibu, sakay iyatád moy ten tehud a sapulu a libu. ");
INSERT INTO prfNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Gapu en tehud ay átdenan pa, sakay sumagana. Peru en awan, ay pati en sabadit a kao na ay alapán pa. ");
INSERT INTO prfNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ibut moy ten luwas ten kadiklámman en tagapagserbi a awan ti kuwenta, haud siya a mágsasangitán sakay mággaaduyán.’ ” ");
INSERT INTO prfNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Káddemát nen Anak nen Tolay a bilang Hari, sakay kaguman na en atanan a anghel, ay umetnud siya ten trono nen kaluwalhatian. ");
INSERT INTO prfNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Sakay mapisan en atanan a tolay ten atubengán na. Paghiwalayán na hidi a kona ten pánghiwalay nen mággalaga ten tupa ay ten kambing. ");
INSERT INTO prfNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","En tupa hidi ay idátton na ten kawanan na, sakay en kambing hidi ay ten kawiri na. ");
INSERT INTO prfNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Sakay kagiyán nen Hari ten ked hidi ten kawanan na, ‘Kamon dán sikam a pinagpala nen Ama ku! Tanggapán moy dán en kahariyan a nehanda para dikomoy sapul pa dikona lalangán i munduwiday. ");
INSERT INTO prfNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Gapu dikona magaláppák ay pinakanák moy. Dikona mauwawák ay pinainumák moy, sakay dikona dayuwák ay pinatulosák moy. ");
INSERT INTO prfNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Dikona awanák ti mesulot ay pinabaduwanák moy. Dikona tehudák a saket ay binisitaák moy, sakay dikona piresuwák ay angenák moy inileng.’ ");
INSERT INTO prfNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Sakay tummábbig en matuwid hidi, “Panginoon, nengkan naketa miyid dikomu a nagaláp ka sakay pinakan mi ka, oni nauwaw sakay pinainom mi ka? ");
INSERT INTO prfNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Nengkan naketa miyid dikomu a dayu ka sakay pinatulos mi ka, oni awan ti mesulot sakay pinabaduwan mi ka? ");
INSERT INTO prfNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Sakay nengkan naketa miyid dikomu a tehud ka a saket oni piresu ka sakay binisita mi ka?’ ");
INSERT INTO prfNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Sakay tumábbig en Hari, “Tandaan moy, dikona gamitán moy iyád ten kababaan ti kákkapatkaka kuwiday hidi ay ginamet moy iyud dikoku.’ ");
INSERT INTO prfNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Sakay kagiyán na bi ten ked hidi ten kawiri na, ‘Umadeyu kam dikoku a sinumpa hidi! Angay kam ten apoy a awan ti kákkaadáp a nehanda para ten diyablo sakay ten sakup na hidi. ");
INSERT INTO prfNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Gapu dikona magaláppák ay awanák moy pinakan, nauwawák ay awanák moy pinainom. ");
INSERT INTO prfNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Dikona dayuwák ay awanák moy pinatulos; dikona awanák ti mesulot ay awanák moy pinabaduwan. Dikona tehudák a saket sakay piresuwák ay awanák moy binisita.’ ");
INSERT INTO prfNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Sakay tumábbig bi hidi, ‘Panginoon, nengkan mi ka netan a nagaláp, nauwaw, dayu, awan ti mesulot, tehud a saket oni piresu, sakay awan mi ka sinerbiyan?’ ");
INSERT INTO prfNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Sakay kagiyán nen Hari dikodi a, “Tandaan moy, dikona awan moy tinulungan en kababaan ti hidi iddi, ay ginamet moy iyud dikoku.’ ");
INSERT INTO prfNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Káttapos ay angay dán hidi ten parusa a awan ti katapusan, peru en matuwid hidi ay angay ten biyag a awan ti katapusan.” ");
INSERT INTO prfNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Ten dikona a natapos dán a itoldu ni Jesus i atananid a iyud ay kinagi na ten disepulus na hidi, ");
INSERT INTO prfNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Tukoy moy a duwwa a aldew dálla ay Piyesta dán nen Aldew nen Págtalib. Sakay itokyon en Anak nen Tolay tánni ipaku ten kudus.” ");
INSERT INTO prfNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Nadid en pinunu hidi nen padi hidi sakay en pinunu hidi nen banuwan ay namagipun-ipun ten palasyu nen kapunuwan a padi a ti Caifas. ");
INSERT INTO prfNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Nagplanu hidi a lihim di a padikáp ti Jesus sakay pabunu. ");
INSERT INTO prfNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Peru kinagi di, “Dyan tam gamitán ten aldew nen Piyesta bakay magkagulu en tolay hidi.” ");
INSERT INTO prfNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Tenhud ay ked ti Jesus ti Betania ten bilay ni Simon a dati a kinetong. ");
INSERT INTO prfNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Mentras a kuman siya ay tehud a ummadeni a bábbi a tehud a tawid a pággasákkan a alabastro a putat ti mahal a págpasárrub. Binulakan na ti págpasárrub en ulu ni Jesus mentras a kuman siya. ");
INSERT INTO prfNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Ten dikona a ketan iyud nen disepulus hidi ay nagsaranta hidi. Kinagi di, “Bakin a sinayang na en págpasárrub? ");
INSERT INTO prfNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Nelaku nakuwan iyud ti mahal sakay iyatád ten pubri hidi en naglakuwan!” ");
INSERT INTO prfNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Tukoy ni Jesus en kinagi di, kaya kinagi na, “Bakin a gágguluwán moy i bábbiyen? Maganda en ginamet na dikoku. ");
INSERT INTO prfNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Gapu pirmi moy la a kakaguman en pubri hidi, peru sikán ay awanák moy pirmi a kakaguman. ");
INSERT INTO prfNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Dikona a binulakanák na ti págpasárrub ay ginamet na iyud bilang pághanda ten páglábbáng dikoku. ");
INSERT INTO prfNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Tandaan moy: hádyaman a itoldu en Maganda a Bareta ti buuwiday a mundu, ay banggitán bi en ginamet na bilang pággala-ala dikona.” ");
INSERT INTO prfNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Nadid ti Judas Iscariote a essa ten sapulu ay ti duwwa ay ummangay ten pinunu hidi nen padi hidi. ");
INSERT INTO prfNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Sakay intanung na, “Ánya i iyatád moyid dikoku ni tulungan takam a madikáp ti Jesus?” Ti iyud bila a odas ay inatáddan di siya ti tállu a pulu a pirasu a silber a pilak. ");
INSERT INTO prfNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Sapul haud ay nagaryok dán ti Judas ti pagkakataun tánni metokyon na ti Jesus. ");
INSERT INTO prfNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Ten purumeru a aldew nen Piyesta nen Tinapay a Awan ti Págpaalsa ay ummadeni kánni Jesus en disepulus na hidi sakay intanung di, “Panginoon, hádya i gustu muwid a paghandaan mi ti pangapon para ten Aldew nen Págtalib?” ");
INSERT INTO prfNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Tummábbig siya, “Angay kam ten siyudad sakay aryokán moy en essa a tolay, kagiyán moy dikona, “Pekagi nen Maistu a dummemát dán en odas na. Mangapon siya a kaguman na en disepulus na hidi ten bilay mu para ten Aldew nen Págtalib.” ");
INSERT INTO prfNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Sinunud nen disepulus hidi en inyutus ni Jesus sakay inhanda di en pangapon ten Aldew nen Págtalib. ");
INSERT INTO prfNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Ti gibiyid a iyud, ay kumman ten lamisaan ti Jesus a kaguman na en sapulu ay ti duwwa a disepulus na. ");
INSERT INTO prfNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Sakay mentras a kuman hidi ay kinagi ni Jesus, “Tandaan moy, essa dikomoy en mángtokyon dikoku!” ");
INSERT INTO prfNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Minalungkut ti hustu en disepulus na hidi sakay balang essa ay nagtanung dikona, “Sikán beman Panginoon?” ");
INSERT INTO prfNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Tummábbig ti Jesus, “En kasabay ku a magsawsaw ti malukungen ay siya en mángtokyon dikoku. ");
INSERT INTO prfNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Matay en Anak nen Tolay ayun ten Kasulatan peru kakakagbi en mángtokyon dikona! Mapiyya pa ni awan dálla neenak i tolayid a iyud!” ");
INSERT INTO prfNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Ti Judas a mángtokyon dikona ay nagtanung bi, “Maistu, sikán beman?” Tummábbig ti Jesus, “Siko dán nagkagiyid.” ");
INSERT INTO prfNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Mentras a kuman hidi ay nangalap ti Jesus ti tinapay. Sakay káttapos na a magpasalamat ten Diyos ay hinati-hati na en tinapay sakay inyatád na ten disepulus na hidi. Sakay kinagi na, “Alapán moy iddi sakay kanán moy. Iyád en bággi ku.” ");
INSERT INTO prfNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Káttapos ay inalap na en tasa sakay nagpasalamat siya ten Diyos sakay inyatád na dikodi. Sakay kinagi na, ‘Uminom kam a atanan ti iyád.’ ");
INSERT INTO prfNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Gapu en digi ku en mebuhus para mapatawad en atanan a kasalanan nen makpal a tolay. ");
INSERT INTO prfNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Kagiyán ku dikomoy, a awanák dán uminom ti alak a gubwat ti ubas hanggan ten aldew a en bigu dán a alak i inumán kuwid a kaguman kam ten kahariyan nen Ama ku.” ");
INSERT INTO prfNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Sakay káttapos di a nágkansiyon ti essa a pasalamat ay ummangay hidi ten Bukid nen Olibo hidi. ");
INSERT INTO prfNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Kinagi ni Jesus dikodi, “Ti gibiyid a iyád ay lakadanák moy a atanan, kona ten kinagi nen Kasulatan a, ‘Bunuwán ku en pastol sakay magkawatak-watak en tupa hidi.’ ");
INSERT INTO prfNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Peru káttapos ku a mabiyag a ruway ay mágdipalonguwák dikomoy ti Galilea.” ");
INSERT INTO prfNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Tummábbig ti Pedro, “Maski ni lakadan ka nen atanan ay awan taka lakadan.” ");
INSERT INTO prfNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Kinagi ni Jesus, “Tandaan mu, ti gibiyid a iyád, bagu a magtarakket en manok ay pentálluwák mu dán a ipamen.” ");
INSERT INTO prfNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Peru kinagi ni Pedro, “Maski ni bunuwánnák di ay awan taka ipamipamen.” Sakay kona labi hud en kinagi nen agum na hidi a disepulus. ");
INSERT INTO prfNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Sakay ingkuyug hidi ni Jesus ten essa a lugar a nginaranan a Getsemani. Kinagi na ten disepulus na hidi, “Háddi kam pala ta magdasalák hudi.” ");
INSERT INTO prfNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Peru ingkuyug na de Pedro sakay en duwwa a anak ni Zebedeo. Sakay nagsapul siya a nabalisa sakay nalungkut en kaluuban na. ");
INSERT INTO prfNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Kinagi na dikodi, “I pusu kuwidi ay malungkut a tarud a halus a ikatay ku! Maguray kam háddi, sakay mákpagpuyat kam dikoku!” ");
INSERT INTO prfNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Ummadeyu ti Jesus ti sabadit, lummuhud siya sakay nagdasal, “Ama ku, ni maari ay ibutan mu dikoku iyád a pághirap. Peru bakán a en gustu ku nan en gustu mu en mangyari.” ");
INSERT INTO prfNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Nagsoli siya sakay dinemáttan na en tállu a disepulus a tidug hidi. Kinagi na kánni Pedro, “Talaga beman a awan kam makapagpuyat para dikoku maski ni essa la a odas? ");
INSERT INTO prfNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Magpuyat kam sakay magdasal tánni awan kam madaig nen toksu. En ispiritu ay nakahanda peru en bággi ay mahina.” ");
INSERT INTO prfNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Ruway siya a ummadeyu sakay nagdasal, “Ama ku, ni awan maari a ibutan iyád a pághirap, nan kailangan a danasán ku ay mangyari en kagustuwan mu.” ");
INSERT INTO prfNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Ruway siya a nagsoli sakay dinemáttan na dámman hidi a tidug, gapu tunay en tongka di. ");
INSERT INTO prfNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Linakadan na dámman a ruway en tállu a disepulus sakay ruway siya a nagdasal, sakay kona labi hud en kinagi na. ");
INSERT INTO prfNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Nagsoli dámman siya ten disepulus na hidi sakay kinagi na dikodi, “Tidug kam palla beman sakay umimang? Dummemát dán en odas a itokyon en Anak nen Tolay ten makasalanan hidi. ");
INSERT INTO prfNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Umikat kamon sakay kadtamon! Ked dán en mángtokyon dikoku.” ");
INSERT INTO prfNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Magupos palla ti Jesus dikona a dummemát ti Judas, a essa ten sapulu ay ti duwwa. Tehud siya a kaguman a makpal a tolay a tehud a tawid a áttak sakay garoti. Gubwat hidi ten pinunu hidi nen padi hidi sakay ten pinunu hidi nen banuwan. ");
INSERT INTO prfNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Bagu pa hidi a dummemát haud ay kinagi dán nen mángtokyon dikona, “En ámmuwan ku ay siya en aryokán moy. Dikáppán moy siya a pagdaka!” ");
INSERT INTO prfNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Kaya inadeniyan ni Judas ti Jesus sakay binati na, “Mapiyya gibi Maistu!” sakay inámmuwan na. ");
INSERT INTO prfNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Kinagi ni Jesus dikona, “Amigu ku, gamitán mu dán en gustu mu.” Sakay inadeniyan siya nen tolay hidi sakay dinikáp di. ");
INSERT INTO prfNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Bigla a nagbagut ti áttak en essa ten kaguman hidi ni Jesus. Tinigpas na en alipin nen kapunuwan nen padi hidi sakay naripas en bángbáng na. ");
INSERT INTO prfNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Kinagi ni Jesus, “Isarungan mu i áttak muwen! En mabiyag ti áttak ay ten áttak labi a matay. ");
INSERT INTO prfNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Awan mu beman tukoy a makaagidák ten Ama ku ti sapulu ay ti duwwa a batalyon a anghel? ");
INSERT INTO prfNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Peru konya a matupad en nesulat ten Kasulatan a dapat iyád a mangyari?” ");
INSERT INTO prfNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Sakay inatubeng na en tolay hidi sakay kinagi na, “Tulisanák beman kaya kam a ummangay háddi a tehud a tawid a áttak sakay garoti para dikáppánnák moy? Aldew-aldewák la a magtoldu ten Templo peru awanák moy dinikáp. ");
INSERT INTO prfNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Peru nangyari i atananid a iyád para matupad en insulat nen propeta hidi.” Káttapos ay gumminan en disepulus na hidi sakay inwarak di siya a mággeessa. ");
INSERT INTO prfNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Nadid ay inyangay di ti Jesus ten bilay ni Caifas, en kapunuwan nen padi hidi. Haud a namagpisan-pisan en tagapagtoldu hidi nen Kautusan sakay en pinunu hidi nen banuwan. ");
INSERT INTO prfNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Ummunud ti Pedro peru adeyu en agwat di. Káddemát na ten bilay nen kapunuwan a padi ay summáddáp siya ten laguwerta sakay nággetnud a kaguman en guwardiya hidi tánni ketan na ni ánya en mangyari. ");
INSERT INTO prfNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Nagaryok en pinunu nen padi hidi sakay en buu a Sanedrin ti tistigu a magbulibuli kontra kánni Jesus para mapabunu di siya. ");
INSERT INTO prfNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Peru awan hidi ti netan a makapagpatunay a kailangan a matay ti Jesus, maski ni makpal a ummatubeng sakay nagkagi ti kakabuliyan tungkul dikona. Ten katapusan ay tehud a duwwa a ummatubeng ");
INSERT INTO prfNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","a nagkagi, “Kinagi ni tolayid a iyán a sidaán na en Templo nen Diyos sakay ipataknág ti tállu a aldew.” ");
INSERT INTO prfNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Tummaknág en kapunuwan nen padi hidi sakay kinagi na kánni Jesus, “Tehud ka a metábbig ti imbintang diyen dikomu?” ");
INSERT INTO prfNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Peru awan tummatábbig ti Jesus. Sakay kinagi dikona nen kapunuwan nen padi hidi, “Iyutus ku dikomu, kagiyán mu dikomi ten ngaran nen Diyos a biyag, siko beman en Cristo, en Anak nen Diyos?” ");
INSERT INTO prfNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Tummábbig ti Jesus, “Siko dán en nagkagi. Kagiyán ku dikomoy, awan dán magmalay ay ketan moy en Anak nen Tolay a mággetnud ten kawanan nen makapangyariyan a Diyos sakay dumemát siya a ked ten panganurin!” ");
INSERT INTO prfNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Dikona a nasanig iyud nen kapunuwan nen padi hidi ay pinisad na en badu na sakay kinagi na, “Iyád a pággupos ay awan pággalang ten Diyos! Awan tamon kailangan en agum pa a mangtistigu. Nasanig moy en pággupos na a awan pággalang ten Diyos! ");
INSERT INTO prfNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Ánya ti palagay moyid?” Tummábbig hidi, “Dapat siya a matay!” ");
INSERT INTO prfNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Sakay linoktaban di siya ten rupa na sakay sinássuntuk. Dinapang bi siya nen agum hidi ");
INSERT INTO prfNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","sakay kinagi di, “Cristo, tukuyan mu benid ni deya en nangdapang dikomu!” ");
INSERT INTO prfNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Mentras a mággetnud ti Pedro ten laguwerta, ay inadeniyan siya nen essa a utusan a bábbi sakay kinagi na, “Kaguman ka bi ni Jesus a taga-Galilea, awan beman?” ");
INSERT INTO prfNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Peru impamen ni Pedro ten atubengán nen kakpalan. “Awanák ti tukoy ti kákkagi-kagiyán muwen,” tábbig na. ");
INSERT INTO prfNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Sakay ummangay ti Pedro ten balkon. Netan siya nen essa pa a utusan a bábbi sakay kinagi na ten ked hidi haud, “I lállakiyid a iyán ay kaguman ni Jesus a taga-Nazaret.” ");
INSERT INTO prfNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Ruway na siya a impamen, “Manumpaák a awan ku tukoy i tolayid a iyán.” ");
INSERT INTO prfNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Mamaya-maya ay ummadeni kánni Pedro en lállaki hidi a ked haud. Kinagi di, “Essa ka ngani bi dikodi. Matenggi ti pággupos muwen.” ");
INSERT INTO prfNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Tummábbig ti Pedro, “Maski ni matayák pa ay talaga a awan ku matenggi i tolayid a iyán!” ");
INSERT INTO prfNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Sakay naala-ala ni Pedro en kinagi ni Jesus, “Bagu a magtarakket en manok ay pentálluwák mu a ipamen.” Sakay lummuwas ti Pedro sakay nágsasangitán ti hustu. ");
INSERT INTO prfNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Ten dikona a dimadimang dán ay namágguron en pinunu hidi nen padi hidi sakay en pinunu hidi nen banuwan ni konya di a mapabunu ti Jesus. ");
INSERT INTO prfNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Káttapos ay pinapungu di siya sakay inyangay di kánni gubernador a Pilato. ");
INSERT INTO prfNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Dikona a ketan ni Judas a ti Jesus ay nahatulan ti kamatayan ay nagsisi siya sakay insoli na ten pinunu hidi nen padi hidi sakay ten pinunu hidi nen banuwan en tállu a pulu a pirasu a silber a pilak. ");
INSERT INTO prfNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Kinagi na, “Nagkasalaák! Intokyon ku en tolay a awan ti kasalanan.” “Ánya i pakialam miyid? Bahala ka ti biyag muwen!” tábbig di. ");
INSERT INTO prfNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Insapwar ni Judas en pilak ten disalad nen Templo, lummakad siya sakay angay nagbitti. ");
INSERT INTO prfNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Kinopkop nen pinunu hidi nen padi hidi en silber sakay kinagi di, “Bawal ten Kautusan a iyád a pilak ay idátton ten págdáttonan ten handug ten Templo. Gapu iyád ay bayad ten biyag nen essa a tolay.” ");
INSERT INTO prfNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Nagkaessa hidi a ibali en pilak ten luta nen mággamet ti binga, para magin páglábbángngan ten dayu hidi a tolay. ");
INSERT INTO prfNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Kaya i lutaid a iyud ay nginaranan di a hanggan nadid ti, “Uma ni Digi.” ");
INSERT INTO prfNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Gapu ti iyud a pangyayari ay natupad en kinagi ni Propeta Jeremias a, “Inalap di en pilak a tállu a pulu a pirasu a silber, iyud en halaga a katumbas na ayun ten Israelita hidi, ");
INSERT INTO prfNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","sakay imbayad ku ten luta nen mággamet ti binga ayun ten inyutus dikoku nen Panginoon.” ");
INSERT INTO prfNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Káttapos ay inyangay di ti Jesus ten gubernador, sakay tinanung na siya, “Siko beman en hari nen Judio hidi?” Tummábbig ti Jesus, “Siko dán en nagkagi.” ");
INSERT INTO prfNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Peru ten dikona a bintangán siya nen pinunu hidi nen padi hidi sakay en pinunu hidi nen banuwan ay awan dán siya tummábbig. ");
INSERT INTO prfNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Kaya kinagi dikona ni Pilato, “Awan mu beman nasanig en imbintang di hidi dikomu?” ");
INSERT INTO prfNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Peru awan tummábbig ti Jesus kaya nagtaka ti hustu en gubernador. ");
INSERT INTO prfNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Nadid kada Piyesta nen Aldew nen Págtalib, gággamitán dán nen gubernador a magpalaya ti essa a piresu. Palayaán na ni deyaman en kagiyán nen tolay hidi. ");
INSERT INTO prfNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Ti panahunid a iyud ay tehud a essa a tanyag a piresu a en ngaran na ay Jesus Barrabas. ");
INSERT INTO prfNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Kaya dikona a naipun en tolay hidi ay tinanung hidi ni Pilato, “Deya i gustu moyid a palayaán ku, ti Jesus Barrabas oni ti Jesus a nangaranan a Cristo?” ");
INSERT INTO prfNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Gapu tukoy ni Pilato a inggit en dahilan di ni bakin a inyangay di ti Jesus dikona. ");
INSERT INTO prfNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Bakán la a iyán, nan alay na a mággetnud ten pághatulan, ay impekagi nen kabinga na, “Dyan ka makialam ti tolayid a iyán. Awan siya ti kasalanan. Pinahirapanák nadid nen tagináp ku tungkul dikona.” ");
INSERT INTO prfNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Sinulsulan nen pinunu hidi nen padi hidi sakay en pinunu hidi nen banuwan en tolay hidi a agidán di kánni Pilato a ti Barrabas palayaán naid, sakay ti Jesus ay pabunu na. ");
INSERT INTO prfNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Ruway a tinanung nen gubernador en tolay hidi, “Deya ten duwwa i gustu moyid a palayaán ku?” “Ti Barrabas!” tábbig di. ");
INSERT INTO prfNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Kinagi ni Pilato dikodi, “Ni konahud, ánya i gamitán kuwid kánni Jesus a nginaranan a Cristo?” Tummábbig en atanan, “Ipaku siya ten kudus!” ");
INSERT INTO prfNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","“Bakin ánya beman i madukássid a ginamet na?” tanung ni Pilato. Peru lalu pa hidi a pummákraw, “Ipaku siya ten kudus!’ ");
INSERT INTO prfNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Dikona a ketan ni Pilato a awan dán siya ti magamet sakay bakay magkagulu pa en tolay hidi ay nagpaalap siya ti dinom sakay nagugas ten lima na ten atubengán nen tolay hidi. “Awanák ti pananagutan ti kákkatay ni tolayid a iyán. Bahala kamon!” kagi ni Pilato. ");
INSERT INTO prfNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Tummábbig en tolay hidi, “Sagutin mi sakay nen anak mi hidi en kákkatay ni tolayid a iyán!” ");
INSERT INTO prfNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Sakay pinalaya ni Pilato ti Barrabas, peru ti Jesus ay pinalatigu na sakay inyatád na dikodi tánni ipaku ten kudus. ");
INSERT INTO prfNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Káttapos, ay inyangay nen sundalu hidi ti Jesus ten palasyu nen gubernador. Sakay minaipun ten palebut na en essa a batalyon a sundalu. ");
INSERT INTO prfNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Ineklasan di siya sakay sinulutan di ti essa a badu a madidig. ");
INSERT INTO prfNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Nangkawikaw hidi ti lanot a masaet sakay indátton di ten ulu na sakay pinagtawid di ti essa a sarukud ten kawanan na a lima. Sakay sinesti di siya linuhud-luhudan di sakay kinagi di, “Mabuhay en Hari nen Judio hidi!” ");
INSERT INTO prfNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Linoktaban di siya sakay inalap di en sarukud na sakay impakol di dikona. ");
INSERT INTO prfNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Káttapos di siya a sestiyán ay ineklasan di siya sakay sinulutan di ten sadili na a badu. Káttapos ay inluwas di ten banuwan tánni ipaku ten kudus. ");
INSERT INTO prfNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Ten kálluwas di ten banuwan ay netagbuwan di en essa a lállaki a en ngaran na ay ti Simon a taga-Cirene. Impilit di a pabáklay dikona en kudus ni Jesus. ");
INSERT INTO prfNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Káddemát di ten lugar a nangaranan a Golgota, (en gustu na a kagiyán ay Lugar nen Bungu) ay ");
INSERT INTO prfNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","inátdenan di ti Jesus ti alak a hinaluwan ti apdu. Peru ten dikona a naennaman na ay awan na ininom. ");
INSERT INTO prfNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Dikona a mepaku dán siya ten kudus ay hinati-hati nen sundalu hidi en badu na káttapos di a nagbunutan. ");
INSERT INTO prfNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Sakay nággetnud hidi para bantayan di siya. ");
INSERT INTO prfNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Insulat di ten ontok nen kudus en nagin bintang di dikona, “Ti Jesus iyád, en Hari nen Judio hidi.” ");
INSERT INTO prfNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Duwwa bi a tulisan en kasabay na a nepaku ten kudus, essa ten kawanan na sakay essa ten kawiri na. ");
INSERT INTO prfNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Ininsultu bi siya nen magtalib hidi sakay magwalingiwág pa hidi a ");
INSERT INTO prfNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","magkagi, “Awan beman siko en mangsida ten Templo sakay ruway mu a ipataknág ti tállu a aldew? Iligtas mu nadid i sadili muwen! Ni siko a talaga en Anak nen Diyos, umugsad ka ti kudusen!” ");
INSERT INTO prfNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Sinesti bi siya nen pinunu hidi nen padi hidi, nen tagapagtoldu hidi nen Kautusan sakay nen pinunu hidi nen banuwan. Kinagi di, ");
INSERT INTO prfNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Inligtas na en agum hidi peru i sadili naen ay awan na meligtas! Awan beman siya en Hari ni Israel? Ni umugsad la siya nadid ti kudusen ay maniwala kami dán dikona! ");
INSERT INTO prfNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Maniwala siya ten Diyos sakay kinagi na a siya en Anak nen Diyos. Iligtas siya nen Diyos ni talaga a tatarudan en kinagi na!” ");
INSERT INTO prfNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Sakay sinesti bi siya nen duwwa a tulisan a nepaku a kasabay na. ");
INSERT INTO prfNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Sapul ten tanghali hanggan ten alas tres ten apon ay nagdiklám en buu a lugar. ");
INSERT INTO prfNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Ten dikona a magalas tres ten apon ay pummákraw ti Jesus, “Eli, Eli, lema sabachthani?” En gustu na a kagiyán ay “Diyos ku, Diyos ku bakin pinabayanák mu?” ");
INSERT INTO prfNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Nasanig iyud nen sangan a tumáttaknág haud kaya kinagi di, “Dáddulawan na ti Elias!” ");
INSERT INTO prfNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Pagdaka a gumminan en essa dikodi sakay nangalap ti damit. Binisa na ti maapsot a alak sakay indátton na ten ontok nen tákkán sakay impasápsáp na kánni Jesus. ");
INSERT INTO prfNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Peru kinagi bi nen agum hidi, “Maguray kam pa, ilingán tam ni dumemát ti Elias para iligtas siya!” ");
INSERT INTO prfNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Ruway a pinumákraw ti mabegsák ti Jesus sakay natay dán siya. ");
INSERT INTO prfNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Ti odasid a iyud ay bigla a napisad en kortina nen Templo, sapul ten disunu hanggan ten dibábbi. Naglinug ten luta sakay nabisag en batu hidi. ");
INSERT INTO prfNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Nabukasan en lábbáng hidi sakay nabiyag a ruway en makpal a tolay nen Diyos a nágkatay dán. ");
INSERT INTO prfNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Lummuwas hidi ten páglábbángngan sakay dikona a nabiyag a ruway ti Jesus, ay summáddáp hidi ti Jerusalem sakay netan hidi haud nen makpal a tolay. ");
INSERT INTO prfNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Neántingan ti hustu en kapitan sakay en sundalu hidi a nagbantay kánni Jesus dikona a nabati di en linug sakay netan di en atanan a nangyari. Kinagi di, “Tarud ngani a Anak siya nen Diyos!” ");
INSERT INTO prfNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Makpal a kabábbiyan en ked haud a mágtan-aw ten adeyu la. Sapul pa ti Galilea ay ummunonud dán hidi kánni Jesus sakay nagserbi dikona. ");
INSERT INTO prfNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Kaguman dikodi ti Maria Magdalena, ti Maria a ina de Santiago ay ti Jose, sakay en kabinga ni Zebedeo. ");
INSERT INTO prfNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Ten dikona a pággapon dán ay tehud a dummemát a essa a mayaman a taga-Arimatea, en ngaran na ay ti Jose. Siya ay disepulus bi ni Jesus. ");
INSERT INTO prfNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Ummangay siya kánni Pilato sakay inagid na en bangkay ni Jesus. Inyutus bi ni Pilato a iyatád en bangkay dikona. ");
INSERT INTO prfNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Kaya inalap ni Jose en bangkay sakay binalutan na ti malinis a tela a lino. ");
INSERT INTO prfNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Inyangay na ten sadili na a páglábbángngan a bigu na palla a impagamet ten pader a batu. Káttapos ay inggulung na en dikál a batu a págtakáp ten pintuwan sakay lummakad. ");
INSERT INTO prfNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Ked bi haud ti Maria Magdalena sakay en essa pa a Maria a nággetnud ten luwas nen páglábbángngan. ");
INSERT INTO prfNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Ten kailawan na, káttapos nen aldew nen pághanda ten Aldew nen Págtalib, sabay a ummangay kánni Pilato en pinunu hidi nen padi hidi sakay en Pariseo hidi. ");
INSERT INTO prfNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Kinagi di dikona, “Naala-ala mi en kinagi ni magkukunwariyid a iyud dikona a biyag palla a mabiyag siya a ruway kállipas nen tállu a aldew. ");
INSERT INTO prfNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Pabantayan mu pay ti hustu en páglábbángngan hanggan ten katállu a aldew. Bakay umangay en disepulus na hidi sakay takawán di en bangkay. Sakay kagiyán di ten tolay hidi a nabiyag siya a ruway. Mahirap dán bakay i págloku diyid a iyád ay magin mas madukás pa nan ten purumeru.” ");
INSERT INTO prfNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Kinagi dikodi ni Pilato, “Mángkuyug kam ti sundalu hidi sakay pabantay moy ti hustu en páglábbángngan.” ");
INSERT INTO prfNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Kaya ummangay hidi sakay dináttonan di ti senyal en pintuwan a batu sakay pinabantayan di en páglábbángngan ten sundalu hidi. ");
INSERT INTO prfNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Kállipas nen Aldew nen Káimang, dikona a págdemlag dán ten purumeru a aldew nen sasimba, ay ummangay de Maria Magdalena sakay en essa pa a Maria ten nánglábbángngan kánni Jesus. ");
INSERT INTO prfNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Káddemát di haud ay bigla a naglinug ti mabegsák gapu ummugsad a gubwat dilanget en essa a anghel nen Panginoon. Inggulung na en batu a nakatakáp ten páglábbángngan sakay ummetnud ten dibabew na. ");
INSERT INTO prfNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","En rupa na ay makasili a kumán a kilat, kona bi ten pudew nen badu na. ");
INSERT INTO prfNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Nagpágpág ti ánteng en bantay hidi sakay nabuwal hidi a kona ten essa a patay dikona a netan di en anghel. ");
INSERT INTO prfNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Peru kinagi nen anghel ten bábbi hidi, “Dyan kam manteng. Tukoy ku a aryokán moy ti Jesus a nepaku ten kudus. ");
INSERT INTO prfNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Awan dán siya háddi gapu nabiyag dán siya a ruway a kona ten kinagi na. Kamon haád, ilingán moy en nángdáttonan dikona. ");
INSERT INTO prfNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Angay moy ibareta nadid bi ten disepulus na hidi a siya ay nabiyag a ruway sakay mágdipalongu ti Galilea. Metan moy siya haud! Tandaan moy en kinagi ku dikomoy.” ");
INSERT INTO prfNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Kaya nagalistu hidi a lummakad ten páglábbángngan a tehud ánteng sakay dikál a kasayaan. Sakay nagginan hidi a ummangay ten disepulus hidi tánni ibareta di en nangyari. ");
INSERT INTO prfNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Peru tinagbu hidi ni Jesus, sakay binati na hidi, “Magkahud kam ti kapayapaan!” Ummadeni hidi kánni Jesus, tinumawid hidi ten básset na hidi sakay sinamba di siya. ");
INSERT INTO prfNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Sakay kinagi ni Jesus dikodi, “Dyan kam manteng! Kammoy dán sakay kagiyán moy ten kákkapatkaka ku hidi a umangay hidi ti Galilea sakay ketanák di haud!” ");
INSERT INTO prfNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Dikona a makalakad en bábbi hidi ay ummangay bi ten banuwan en sangan ten nagbantay hidi ten páglábbángngan. Imbareta di ten pinunu hidi nen padi hidi en atanan a nangyari. ");
INSERT INTO prfNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Nagipun-ipun hidi sakay káttapos di a mákpágguron ten pinunu hidi nen banuwan, ay sinuhulan di ti dikál a pilak en sundalu hidi. ");
INSERT INTO prfNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Sakay inutusan di hidi a kona háddi en ibareta di, “Mentras a tidug kami nen gibi ay ummangay en disepulus na hidi sakay tinakaw di en bangkay.” ");
INSERT INTO prfNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Kinagi pa nen pinunu hidi nen padi hidi dikodi, “Dyan kam mabalisa, maski masanig man iyád nen gubernador. Bahala kami dán!” ");
INSERT INTO prfNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Tinanggap nen bantay hidi en pilak sakay sinunud di en inyutus dikodi. Kaya hanggan nadid ay iyád padi en istorya nen Judio hidi. ");
INSERT INTO prfNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Nadid en sapulu ay ti essa a disepulus ay ummangay ti Galilea, ten bukid a intoldu ni Jesus dikodi. ");
INSERT INTO prfNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Dikona a ketan di ti Jesus ay sinamba di siya. Peru en agum hidi ay nagduda en isip di. ");
INSERT INTO prfNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Ummadeni ti Jesus sakay kinagi na dikodi, “Neatád dán dikoku en atanan a kapangyariyan dilanget sakay ti lutaiday. ");
INSERT INTO prfNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Kaya angay kam ten atanan a bansa sakay gamitán moy a disepulus ku en atanan a tolay. Binyagan moy hidi ten ngaran nen Ama, nen Anak sakay nen Banal a Ispiritu. ");
INSERT INTO prfNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Sakay tolduwan moy hidi a sumunud ten atanan a inyutus ku dikomoy. Tandaan moy, kakagumanák moy hanggan ten katapusan ni munduwiday.”");
INSERT INTO prfNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Iddi en Maganda a Bareta tungkul kánni Jesu-Cristo a Anak nen Diyos. ");
INSERT INTO prfNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Nagsapul iyád dikona matupad en insulat ni propeta Isaias a, “Tehudák a paangayán a mágdipalongu dikomu. Siya i mánghandaid ten paglakadan mu.’ ");
INSERT INTO prfNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Siya en magpákraw ten kaparangan ti kona háddi, ‘Maghanda kamon ten káddemát nen Panginoon, husayán moy dán en paglakadan na!’ ” ");
INSERT INTO prfNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Nadid, dummemát ngani ti Juan ten kaparangan, a nagbinyag sakay nangaral. Kinagi na ten tolay hidi, “Adággan moy dán sakay pagsisiyan en kasalanan moy hidi, sakay magpabinyag kam tánni patawadán kam nen Diyos.” ");
INSERT INTO prfNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Ngari-ngari a atanan nen tolay hidi a taga-prubinsiya a Judea sakay siyudad a Jerusalem ay ummangay kánni Juan ten dinom ti Jordan a mágsanig ten pángngaral na. Intapat di en kasalanan di hidi sakay bininyagan na hidi. ");
INSERT INTO prfNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","En badu ni Juan ay gamet ti dutdut ni kamelyo sakay en sinturon na ay koblet ni hayup. Raksa a dudun en kákkanán na sakay pulut ni pitukan. ");
INSERT INTO prfNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ipáppangaral na ten tolay hidi a, “Tehud a dumemát a mas makapangyariyan nan sikán, maski mangokbis ten igut nen sandalyas na ay awanák karapatdapat. ");
INSERT INTO prfNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Bininyagan takam ti dinom peru siya en mangbinyag dikomoy ti Banal a Ispiritu.” ");
INSERT INTO prfNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Awan nagnalay ti panahunid a iyud ay dummemát ti Jesus. Gubwat siya ti Nazaret a sakup ni Galilea. Sakay bininyagan ni Juan ten dinom ti Jordan. ");
INSERT INTO prfNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Káawas ni Jesus ten dinom ay netan na a bummukas dilanget sakay dummibábbi dikona en Ispiritu a kumán a kalapati. ");
INSERT INTO prfNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Tulos a tehud a nagupos dilanget a kinagi na, “Siko en mahal ku a Anak sakay kasayaan ku a tarud.” ");
INSERT INTO prfNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Káttapos ay pagdaka a inggiyya nen Ispiritu ti Jesus ten kaparangan. ");
INSERT INTO prfNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Áppat a pulu a aldew siya a nágyan haud sakay tináttoksu siya ni Satanas. Tehud a mágkatapang a hayup haud peru pinagserbiyan siya nen anghel hidi. ");
INSERT INTO prfNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Dikona a nepiresu dán ti Juan ay ummangay ti Jesus ten prubinsiya a Galilea. Impangaral na haud en Maganda a Bareta a gubwat ten Diyos. ");
INSERT INTO prfNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Kinagi na, “Dummemát dán en odas. Adeni dán a maghari en Diyos. Kaya magsisi kamon sakay adággan moy dán en kasalanan moy hidi sakay maniwala kam ten Maganda a Bareta!” ");
INSERT INTO prfNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Dikona a naglakad ti Jesus ten gilid nen Minalnu ti Galilea ay netan na en matkaka a mángngikan, de Simon ay ti Andres a mamanti. ");
INSERT INTO prfNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Kinagi ni Jesus dikodi, “Mákkuyug kam dikoku ta gamitán takam a mángngikan ti tolay.” ");
INSERT INTO prfNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Pákkasanig di ten kinagi ni Jesus ay pagdaka di a inwarak en panti di sakay nákkuyug hidi dikona. ");
INSERT INTO prfNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Naglakad pa ti Jesus, awan palla siya nakaadeyu ay netan na bi en matkaka a de Santiago ay ti Juan a anak ni Zebedeo. Ked hidi ten abeng di a magayuma ten panti di. ");
INSERT INTO prfNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Kaya ten pákketa na dikodi ay dinulawan na hidi sakay nákkuyug hidi dikona. Linakadan di en ama di a ti Zebedeo ten abeng kaguman na en tarabahador di hidi. ");
INSERT INTO prfNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Nadid ay ummangay ti Jesus sakay en disepulus na hidi ti Capernaum. Ten Aldew nen Káimang nen Judio hidi ay summáddáp ti Jesus ten sinagoga sakay nagtoldu siya ten tolay hidi. ");
INSERT INTO prfNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Nagtaka en tolay hidi gapu makapangyariyan en págtoldu na, awan kona ten tagapagtoldu hidi nen Kautusan. ");
INSERT INTO prfNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Tehud a essa a lállaki a sináddáp ni madukás a ispiritu, bigla siya a summáddáp ten sinagoga. Káttapos ay pummákraw siya, ");
INSERT INTO prfNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Jesus a taga-Nazaret, ánya i gustu muwid a mangyari dikomi? Bunuwán mu kami beman? Tukoy taka! Siko en Banal a gubwat ten Diyos.” ");
INSERT INTO prfNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Peru sinaway ni Jesus en madukás a ispiritu, kinagi na, “Tumahimik ka! Lumuwas ka ti lállakiyen!” ");
INSERT INTO prfNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Pinagpirágpirág nen madukás a ispiritu en lállaki sakay magpákraw a lummakad dikona. ");
INSERT INTO prfNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Nagtaka en atanan a tolay kánni Jesus sakay namágguronan di, “Ánya iyád? Bigu a toldu? Makapangyariyan siya a tarud, maski en madukás a ispiritu ay sumunud ten utus na.” ");
INSERT INTO prfNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Kaya gapu ti iyud ay pagdaka a nabareta ten atanan a lugar ten prubinsiya a Galilea en tungkul kánni Jesus. ");
INSERT INTO prfNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Nadid, kálluwas de Jesus ten sinagoga ay nagtulos hidi ten bilay nen matkaka a Simon ay ti Andres, kaguman na de Santiago ay ti Juan. ");
INSERT INTO prfNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Dinemáttan di en katugngan ni Simon a mágkatdug a tehud a saket. Pagdaka a tehud a nángkagi kánni Jesus a maladu siya. ");
INSERT INTO prfNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Kaya inadeniyan ni Jesus en bábbi, tinawidan na en lima na sakay inyekat na. Pagdaka siya a nawasan sakay tulos na dán a sinerbiyan de Jesus. ");
INSERT INTO prfNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Dikona sumarám en aldew ten gibi dán, ay inyangay di kánni Jesus en atanan nen tehud hidi a saket sakay en sináddáp hidi ni dimonyo. ");
INSERT INTO prfNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Ngari-ngari a atanan nen tolay ti banuwanid a iyud ay napisan hidi ten atubengán nen bilay. ");
INSERT INTO prfNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Pinagpiyya na en makpal hidi a tehud a saket ten ányaman a bábbatiyán di, sakay pinalakad na bi en dimonyo hidi ten tolay hidi. Awan pinabayan ni Jesus a magupos en dimonyo hidi, gapu tukoy di ni deya siya. ");
INSERT INTO prfNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Kaldiwan palla ay ummikat dán ti Jesus sakay ummangay ten tahimik a lugar a nagdasal. ");
INSERT INTO prfNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Káikat de Simon ay inaryok di ti Jesus ni hádya inangayan naid. ");
INSERT INTO prfNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Pákketa di kánni Jesus ay kinagi di, “Aryokán ka nen katolayan.” ");
INSERT INTO prfNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Peru kinagi ni Jesus dikodi, “Kailangan a angay kitam ti agumen hidi a banuwan tánni makapagtolduwák bi haud. Iyád en dahilan ni bakin ummangayák háddi.” ");
INSERT INTO prfNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Kaya linebut na en prubinsiya a Galilea a nangaral ten sinagoga hidi, sakay nagpalayas siya ti dimonyo ten tolay hidi. ");
INSERT INTO prfNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Tehud a tolay a ummadeni kánni Jesus a kinetong, lummuhud siya sakay nákkekagbi a kinagi na, “Ni gustuwán mu ay mapagpiyyaák mu.” ");
INSERT INTO prfNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Kinagbiyan siya ni Jesus, tinawidan na sakay kinagi na, “Gustu ku! Nadid ay nagpiyya ka dán.” ");
INSERT INTO prfNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Ti odas biyid a iyud ay pagdaka a nagpiyya en ketong na, sakay nagin malinis siya. ");
INSERT INTO prfNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Pinalakad siya ni Jesus a pagdaka peru mahigpit na a imbilin dikona a, ");
INSERT INTO prfNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Dyan mu ikagi maski kándeya en págpapiyya ku dikomu. Nan magtulos ka ten padi sakay paileng ka dikona, káttapos ay magalay ka ten Diyos a kona ten inyutus ni Moises. En pággalay mu i mangpatunayid ten tolay hidi a nagpiyya ka dán.” ");
INSERT INTO prfNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Peru ten kállakad nen lállaki ay imbábbareta na ten atanan a tolay en págpiyya na, kaya awan dán hayagan en kássáddáp ni Jesus ten banuwan. Nanatili dálla siya ten adeyu a lugar ten luwas nen banuwan peru maski adeyu en páppágyanan na ay makpal padi a tolay en ummangay dikona a gubwat ti iba-iba a lugar. ");
INSERT INTO prfNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Kállipas nen sangan a aldew ay nagsoli ti Jesus ti Capernaum. Kummalat en bareta a ked dán siya ten bilay. ");
INSERT INTO prfNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Kaya tunay ti kakpal a tolay en ummangay a ngari-ngari a awan dán hidi ti págyanan maski ten atubengán nen bilay. Dikona pasiyaan a mangaral ti Jesus dikodi ten Maganda a Bareta ay ");
INSERT INTO prfNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","tehud a dummemát a áppat a lállaki, tehud hidi a usung a lupug. ");
INSERT INTO prfNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Gapu ten kakpal nen tolay ay awan hidi makaadeni kánni Jesus. Ginamet diyid ay inyonek di en tehud a saket ten atáp nen bilay sakay lináttab di en atáp ten tapat na. Káttapos ay intonton di en ayud a págkatdugan nen lupug. ");
INSERT INTO prfNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Dikona a netan ni Jesus en dikál di a pánnampalataya ay kinagi na ten lupug, “Anak ku, napatawad dán en kasalanan mu hidi.” ");
INSERT INTO prfNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Nadid, tehud a sangan a tagapagtoldu nen Kautusan a mággetnud sakay magisip hidi ti kona háddi, ");
INSERT INTO prfNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Bakin kona haán a magupos i tolayen? Essa iyád a páglapastangan ten Diyos! Awan beman en Diyos la i makapagpatawadid ti kasalanan?” ");
INSERT INTO prfNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Natukuyan ni Jesus en ked ten isip di, kaya pagdaka na a kinagi dikodi, “Bakin magisip kam ti kona haán? ");
INSERT INTO prfNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Ánya beman i mas alistuwid a kagiyán ti lupugidi, ‘Pinatawad taka dán ten kasalanan mu hidi,’ oni, ‘Tumaknág ka, betbitán mu i págkatdugan muwen sakay maglakad ka?’ ");
INSERT INTO prfNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Nadid ipeta ku dikomoy a en Anak nen Tolay ay tehud a kapangyariyan ti munduwiday a magpatawad ti kasalanan.” Kaya kinagi na ten lupug, ");
INSERT INTO prfNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Umikat ka, betbitán mu i págkatdugan muwen sakay umuli ka dán.” ");
INSERT INTO prfNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Tummaknág en lupug, binetbet na en págkatdugan na sakay lummakad a áelingán nen katolayan. Nagtaka hidi a atanan ten netan di sakay nagpuri hidi ten Diyos. Kinagi di, “Nadid kami palla a naketa ti kona haán!” ");
INSERT INTO prfNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Nadid, ummangay dámman ti Jesus ten gilid nen Minalnu ti Galilea. Makpal a tolay a ummadeni kánni Jesus kaya tinolduwan na hidi. ");
INSERT INTO prfNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Káttapos ay nagtulos siya a naglakad sakay netan na ti Levi a anak ni Alfeo a mággetnud ten págsingeran na ti buwes. Kinagi ni Jesus dikona, “Umunud ka dikoku.” Pákkasanig ni Levi ten kinagi ni Jesus ay pagdaka siya a tummaknág sakay nákkuyug dikona. ");
INSERT INTO prfNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Káttapos ay ummangay ti Jesus ten bilay ni Levi sakay kumman siya haud. Makpal a mágsinger ti buwes sakay makasalanan en ummunud kánni Jesus sakay náksabay hidi a kumman kaguman en disepulus hidi. ");
INSERT INTO prfNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Netan iyád nen sangan a tagapagtoldu nen Kautusan a kabilang ten Pariseo hidi, a kumman ti Jesus a kaguman nen mágpabuwes hidi sakay nen makasalanan hidi a tolay. Kaya tinanung di en disepulus hidi ni Jesus, “Bakin máksabay siya a kuman ten mágpabuwes hidi sakay ten makasalanan hidi?” ");
INSERT INTO prfNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Dikona nasanig iyud ni Jesus ay tummábbig siya ti patalinhaga, “Awan beman en tehud la hidi a saket i gamutánnid nen mággamot? Kona labi hud, kayaák a ummangay háddi ay tánni dulawán ku en makasalanan hidi a magsisi, bakán a en awan hidi ti kasalanan.” ");
INSERT INTO prfNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Tenhud, en disepulus hidi ni Juan sakay en Pariseo hidi ay nagkulásyon. Nadid, tehud a ummadeni kánni Jesus a nagtanung, “Bakin awan magkulásyon i disepulus muwen hidi, samantala en disepulus hidi nen Pariseo hidi sakay en disepulus hidi ni Juan a Mágbinyag ay magkulásyon?” ");
INSERT INTO prfNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Tummábbig ti Jesus, “Maari beman a magkulásyon en katolayan ni kakaguman di palla en lállaki a ikasal? Awan! Mentras a kaguman di palla en lállaki a ikasal ay awan di iyud gamitán. ");
INSERT INTO prfNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Peru ni dumemát en panahun a awan di dán siya kaguman ay magkulásyon dán hidi.” ");
INSERT INTO prfNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Intulos ni Jesus en pággupos na, “Awan ti magáppol ti bigu a risatu ten dati a badu. Ni iyáppol en bigu ten dati ay kumárrán en risatu sakay lalu a magkahud ti dikál a pisad en badu.” ");
INSERT INTO prfNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Sakay kinagi na pa, “Kona labi iyán ten bigu a alak. Awan ti magasák ti bigu a alak ten dati a pággasákkan ti alak a gamet ti koblet ni hayup. Ni magasák ti bigu a alak ten dati a pággasákkan ay pumáttak iyud sakay tulos a mágkebut en alak, parehu a masayang en alak sakay en pággasákkan. Kailanganid ten bigu a alak ay bigu bi a pággasákkan.” ");
INSERT INTO prfNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Ten essa a Aldew nen Káimang nen Judio hidi ay dummaman de Jesus ten katriguwan. Dikona pasiyaan hidi a maglakad ay nagkádtor en disepulus na hidi ti ohay a págkásselan di. ");
INSERT INTO prfNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Kinagi nen Pariseo hidi kánni Jesus, “Ilingán mu i ginamet ni disepulus muwen hidi, naggamet hidi ti bawal ten Aldew nen Káimang!” ");
INSERT INTO prfNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","26","Tinanung hidi ni Jesus, “Awan beman nabasa moy dán en ginamet ni David dikona ti Abiatar en kapunuwan nen padi hidi? Magaláp tenhud de David ay ten kaguman na hidi. Kaya summáddáp siya ten bilay nen Diyos sakay inalap na en alay a tinapay para ten Diyos sakay kinan di. Bawal iyud ten kautusan gapu padi la en maari a mangkan haud. Peru kinan iyud ni David sakay inátdenan na pa en kaguman na hidi.” ");
INSERT INTO prfNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Kinagi pa ni Jesus, “En Aldew nen Káimang ay intakda para ten kapiyyaan nen tolay; bakán a linalang en tolay para ten Aldew nen Káimang. ");
INSERT INTO prfNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Kaya maski en Aldew nen Káimang ay ked ten kapangyariyan nen Anak nen Tolay.” ");
INSERT INTO prfNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Ummangay a ruway ti Jesus ten sinagoga, nedemáttan na haud en lállaki a awan makaarikad en essa na a lima. ");
INSERT INTO prfNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Binantayan nen tolay hidi ni gamután ni Jesus en lállaki ten Aldew nen Káimang tánni magkahud hidi ti ibidensiya a awan siya mangilin. ");
INSERT INTO prfNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Kinagi ni Jesus ten lállaki, “Karon hád!” ");
INSERT INTO prfNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Sakay tinanung na en tolay hidi, “Ánya beman i bawalid ten Kautusan, maggamet ti maganda oni maggamet ti madukás? En mángligtas ti tolay oni pabayan mu a matay?” Peru awan hidi ti kákkagi. ");
INSERT INTO prfNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Ummileng ti Jesus ten tolay hidi ten palebut na. Iyamut sakay kagbi en mabati na gapu ten káttug nen ulu di. Káttapos ay kinagi na ten lállaki, “Iyolnat mu i lima muwen.” Dikona iyolnat nen lállaki en lima na ay pagdaka a nagpiyya. ");
INSERT INTO prfNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Lummakad en Pariseo hidi sakay kinauron di a pagdaka en tolay hidi ni Hari a Herodes ni konya di a mapabunu ti Jesus. ");
INSERT INTO prfNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Lummakad ti Jesus a kaguman na en disepulus na hidi, ummangay hidi ten gilid nen minalnu. Ummunud dikona en tunay a kakpal a tolay a gubwat ti Galilea, ti Judea, ");
INSERT INTO prfNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","ti Jerusalem, ti Idumea, ten dibelyu ni Jordan, ten siyudad a Tiro, sakay Sidon. Ummunud hidi gapu nabareta di en ginággamet ni Jesus. ");
INSERT INTO prfNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","10","Makpal siya a pinagpiyya a tehud a saket, sakay pummilit pa en agum a tehud a saket a kumabit dikona. Kaya nángpehanda ti Jesus ti abeng ten disepulus na hidi sakay summakay siya tánni awan di siya masáldit. ");
INSERT INTO prfNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Balang essa ten sináddáp hidi nen madukás a ispiritu a naketa kánni Jesus ay lummuhud ten atubengán na sakay ipákraw di a, “Siko en Anak nen Diyos!” ");
INSERT INTO prfNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Mahigpit a inyutus ni Jesus ten mágkadukás hidi a ispiritu a dyan di kákkagiyán ni deya siya. ");
INSERT INTO prfNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Káttapos ay ummangay ti Jesus ten bukid, kaguman na en pinili na hidi sakay ummunud dikona. ");
INSERT INTO prfNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Nangpili siya dikodi ti sapulu ay ti duwwa a nginaranan na a apostol. Pinili na hidi tánni magin kákkagumanán na sakay utusan na hidi a angay mangaral. ");
INSERT INTO prfNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Inátdenan na hidi ti kapangyariyan a magpalakad ten dimonyo hidi. ");
INSERT INTO prfNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","En pinili na a sapulu ay ti duwwa a apostol ay ti Simon a nginaranan na a Pedro, ");
INSERT INTO prfNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","de Santiago ay ti Juan a anak ni Zebedeo, nginaranan na hidi a Boarnerges, gustu naid a kagiyán ay, “Anak hidi ni káddur;” ");
INSERT INTO prfNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","sakay ti Andres, Felipe, Bartolome, Mateo, Tomas, Santiago a anak ni Alfeo, Tadeo, Simon a makabanuwan, ");
INSERT INTO prfNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","sakay ti Judas Iscariote a nángtokyon dikona. ");
INSERT INTO prfNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Dikona a ummuli ti Jesus ay tunay dámman a kakpal en tolay a ummangay haud kaya awan na dán mapospos a kuman, kona bi ten disepulus na hidi. ");
INSERT INTO prfNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Dikona nabareta iyud nen ina na sakay nen kákkapatkaka na hidi ay ummangay hidi haud. Angen di ti Jesus gapu kagi nen tolay hidi a nagareng kanon siya. ");
INSERT INTO prfNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Kinagi nen sangan a tagapagtoldu nen Kautusan a gubwat ti Jerusalem a kaya kan a makapagpalakad ti Jesus ti dimonyo ay inátdenan siya ni Beelzebul ti kapangyariyan. Ti Beelzebul en pinunu nen dimonyo hidi. ");
INSERT INTO prfNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Gapu ten kinagi di ay dinulaw hidi ni Jesus sakay nagupos siya ti patalinhaga, “Konya a palakadán ni Satanas en sadili na?” ");
INSERT INTO prfNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Ni mamágdadema en mamanuwan ten essa a kahariyan ay awan magmalay a mawasak i kahariyanid a iyud. ");
INSERT INTO prfNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Maski ten essa a pamilya, ni mamágdadema hidi ay awan bi hidi magmalay. ");
INSERT INTO prfNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Kona labi hud ni kalabanán ni Satanas en sadili na sakay mamágdadema en nasakupan na hidi ay awan hidi magmalay, dumemát en katapusan na. ");
INSERT INTO prfNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Peru awan ti makapangsáddáp sakay magtakaw ten bilay nen mabegsák a tolay mentras a awan pa siya mapungu. Ni napungu dán siya ay maari dán a pagtakawan en bilay na. ");
INSERT INTO prfNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Tandaan moy, mapatawad nen Diyos en tolay ten atanan a kasalanan na, pati en kinákkagi na a madukás ten Diyos. ");
INSERT INTO prfNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Peru en magupos ti madukás ten Banal a Ispiritu ay awan dán mapatawad maski nikan. Gapu nanggamet siya ti awan ti katapusan a kasalanan. ");
INSERT INTO prfNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Kinagi iyud ni Jesus dikodi gapu bábbintangán di siya a sináddáp ni madukás a ispiritu. ");
INSERT INTO prfNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Dummemát en ina ni Jesus sakay en kákkapatkaka na hidi. Naguray hidi ten luwas nen bilay sakay pinadulaw di siya. ");
INSERT INTO prfNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Makpal en tolay a mággetnud ten palebut ni Jesus dikona kinagi di, “Ked ti luwason en ina mu sakay en kákkapatkaka mu hidi urayán di ka.” ");
INSERT INTO prfNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Peru kinagi ni Jesus, “Deya beman i ina kuwid sakay i kákkapatkaka kuwid?” ");
INSERT INTO prfNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Inileng na en mággetnud hidi ten palebut na sakay kinagi na, “Hidi iddi i ina kuwid sakay kákkapatkaka kuwid! ");
INSERT INTO prfNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Gapu ni deya en sumássunud ten utus nen Diyos ay siya i kapatkaka kuwid sakay ina kuwid.” ");
INSERT INTO prfNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Nadid, ummangay a ruway ti Jesus ten gilid nen Minalnu ti Galilea. Pinalebutan siya nen tunay ti kakpal a tolay kaya summakay siya ten abeng a ked ten dinom. Ummetnud siya ten abeng sakay en tolay hidi ay ked ten gilid nen minalnu. ");
INSERT INTO prfNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Tinolduwan na hidi ti makpal a bagay ten pamamag-itan nen talinhaga hidi. Kona háddi en kinagi na, ");
INSERT INTO prfNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Mágsanig kam! Tehud a essa a lállaki a mággaradu a angay magsabug. ");
INSERT INTO prfNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Dikona magsabug dán siya ay tehud a sangan a bine a naragrag ten dilan. Dummemát en ibun hidi sakay tinoktok di en bine a naragrag. ");
INSERT INTO prfNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Tehud bi a naragrag a bine ten kabatuwan sakay pagdaka a nagtubu gapu malapes en luta. ");
INSERT INTO prfNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Peru dikona nagsinag ti hustu ay nalanás sakay nagmadi hidi iyud a bine, gapu ápperet la en gamot di. ");
INSERT INTO prfNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Tehud bi a bine a naragrag ten kasaetan, peru dikona immoya en kasaetan ay nailongan en bine, kaya awan nagbunga. ");
INSERT INTO prfNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Sakay tehud bi a bine a naragrag ten maganda a luta kaya tummubu hidi iyud, ummoya sakay nagbunga ti makpal. Nagohay hidi ti tággitállu a pulu a butil sakay tehud a tággi-ánnam a pulu, sakay tehud a tággidatos a butil balang essa.” ");
INSERT INTO prfNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Kinagi pa ni Jesus a, “Mágsanig en tehud págsanig.” ");
INSERT INTO prfNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Dikona mággessa-essa dálla ti Jesus ay ummadeni dikona en sapulu ay ti duwwa a disepulus na kaguman en agum hidi a nakasanig ten talinhaga. Impákpágguron di a ni maari ay ipaliwanag na en kahulugan nen talinhaga. ");
INSERT INTO prfNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Kinagi ni Jesus, “Inyatád dán dikomoy en karapatan a maintendiyan moy en lihim nen pághari nen Diyos. Peru ten agum, atanan a bagay ay itoldu dikodi ten pamamag-itan ni talinhaga. ");
INSERT INTO prfNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Tánni, ‘Umáeleng man hidi ay awan hidi maketa, sakay mágsanig man hidi ay awan hidi makaintendi. Ni konahud, ay sinoli di nakuwan en Diyos sakay nakatanggap nakuwan hidi ti kapatawadan.’ ” ");
INSERT INTO prfNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Káttapos ay tinanung hidi ni Jesus, “Awan moy beman maintendiyan en talinhaga? Konya moy a maintendiyan en agum hidi a talinhaga? ");
INSERT INTO prfNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Kona háddi i kahulugan naid; en bine a isássabug ay en upos nen Diyos. ");
INSERT INTO prfNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","En bine hidi a nágkeragrag ten dilan ay kumán a en tolay hidi a nakasanig ten upos nen Diyos. Pákkasanig di ay dummemát ti Satanas, inibutan na ten isip nen tolay en upos nen Diyos. ");
INSERT INTO prfNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","En bine hidi a nágkeragrag ten kabatuwan ay kumán a en tolay hidi a pákkasanig di ten upos nen Diyos ay pagdaka di a tinanggap a masaya. ");
INSERT INTO prfNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Peru awan gummamot en upos nen Diyos ten pusu di, kaya awan hidi nakapanatili. Dikona demáttan hidi ni kahirapan oni págdusta gapu ten upos nen Diyos, ay pagdaka hidi a ummatras. ");
INSERT INTO prfNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","En bine hidi a nágkeragrag ten kasaetan ay kona ten tolay hidi a nágsanig ten upos nen Diyos. ");
INSERT INTO prfNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Peru gapu ten pággaisip di ten kákkabiyag di ti munduwiday sakay ni konya hidi a yumaman, sakay ten kákkasor di ten sari-sari a bagay ay awan neasák ten pusu di en upos nen Diyos kaya awan nagbunga. ");
INSERT INTO prfNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","En bine hidi a nágkeragrag ten maganda a luta ay kona ten tolay hidi a nágsanig ten upos nen Diyos sakay tinanggap di kaya nagbunga hidi. Tehud a nagbunga ti tággitállu a pulu, tehud a tággi-ánnam a pulu sakay tehud a tággidatos.” ");
INSERT INTO prfNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Nagtulos ti Jesus ten pággupos na. Kinagi na, “Taban beman en simbuwan sakay taklábban ten págtakalan, oni idátton moy ten sarok nen katri? Awan beman, dapatid ay itupu en simbuwan ten tama a págtupuwan? ");
INSERT INTO prfNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Awan ti netagu a awan meluwas, sakay awan ti sekretu a awan mehayag. ");
INSERT INTO prfNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Mágsanig en tehud a págsanig” ");
INSERT INTO prfNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Kinagi pa ni Jesus, “Intendiyán moy ti mapiyya en masanig moy. En sukat a gamitán moy ten agum ay siya labi en sukat a gamitán dikomoy, sakay higit pa haud. ");
INSERT INTO prfNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Gapu en tehud ay átdenan pa, peru en awan, maski en sabadit a ked dikona ay alapán pa.” ");
INSERT INTO prfNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Kinagi pa ni Jesus, “En pághari nen Diyos ay kona ten essa a nagsabug ti bine ten uma na. ");
INSERT INTO prfNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Mátdug siya ti gibi sakay umikat ti aldew. En bine a insabug na ay magtubu la iyud sakay dumikál a awan na tukoy ni konya en káttubu na. ");
INSERT INTO prfNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","En luta i mangpatubuwid sakay mangpadikál ten mula, purumeruwid ay magbuyas pa sakay káttapos ay sumilag dán. ");
INSERT INTO prfNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ni nalutu dán en bunga na ay pagdaka na a pagapas gapu panahun dán.” ");
INSERT INTO prfNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Sakay kinagi na, “Ánya maari tamid a pángparehuwan ten pághari nen Diyos? Ánya maari tamid a gamitán a talinhaga? ");
INSERT INTO prfNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Kona iyád ten bukál nen mustasa a kabaditan ten atanan a bukál. ");
INSERT INTO prfNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Peru ni memula dán ay magin kalangkawan ten atanan a mula sakay magpinget pa ti mayambung, kaya maari a páglobunan nen ibun hidi.” ");
INSERT INTO prfNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Impangaral ni Jesus ten tolay hidi en Upos nen Diyos ten pamamag-itan ni talinhaga ayun ten abut nen isip di. ");
INSERT INTO prfNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Awan siya nangaral dikodi ti bakán a patalinhaga. Peru ni hidi-hidi la ay ten disepulus na hidi ay ipaliwanag na dikodi en atanan a bagay. ");
INSERT INTO prfNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Ten gibi ti aldewid a iyud ay kinagi ni Jesus ten disepulus na hidi, “Kadtamon umarabes dibelyu.” ");
INSERT INTO prfNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Linakadan di en tolay hidi sakay summakay hidi ten abeng a sássakayan ni Jesus. Tehud hidi a kasabay a agum pa a abeng. ");
INSERT INTO prfNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Nagabutan hidi ni mabegsák a bagyu ditaw. Dáddekál a tagmák en dummapát ten abeng kaya ngari-ngari a maputat dán ti dinom. ");
INSERT INTO prfNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Ti Jesus ay tidug a mágpunganan ten dipos nen abeng kaya linukag siya nen disepulus na hidi. Kinagi di, “Maistu, awan ka la mabalisa, umállád kitamon?” ");
INSERT INTO prfNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Ummikat ti Jesus sakay kinagi na ten parás, “Umimang ka!” Sakay kinagi na bi ten tagmák, “Tumahimik ka!” Pagdaka a ummimang en parás sakay lummantap. ");
INSERT INTO prfNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Káttapos ay tinanung hidi ni Jesus, “Bakin manteng kam? Hanggan beman nadid ay awan kam palla ti pánnampalataya?” ");
INSERT INTO prfNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Tunay hidi ti ánteng kaya kinagi nen balang essa, “Deya wád iyád, pati ben parás sakay tagmák ay sumunud dikona?” ");
INSERT INTO prfNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Dummemát de Jesus ten dibelyu nen minalnu, ten lugar nen Gergeseno hidi. ");
INSERT INTO prfNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Káawas ni Jesus ten abeng ay tinagbu siya nen essa a lállaki a hinayup. ");
INSERT INTO prfNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Mágyan siya ten páglábbángngan sakay tunay siya ti begsák. Awan di siya mapungu maski pa ni kadena i gamitánnid a pangpungu dikona. ");
INSERT INTO prfNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Pensangan di dán siya a punguwán ti kadena, peru bágsot-bágsután na la. Kaya awan ti makabalud dikona. ");
INSERT INTO prfNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Aldew ay ti gibi ay máglalakadán siya a mágpapákrawán ten kampusantu sakay ten buki-bukid, sakay táttalinguwan na en bággi na ti batu. ");
INSERT INTO prfNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Adeyu palla siya ay netan-awan na dán ti Jesus kaya nággaginanán siya a ummadeni sakay lummuhud ten atubengán na. ");
INSERT INTO prfNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Sakay impákraw na ti mabegsák, “Jesus, Anak nen kataasan a Diyos, bakin pakialamanák mu? Ipangaku mu ten ngaran nen Diyos a awanák mu pahirapan.” ");
INSERT INTO prfNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","(Kinagi na iyud gapu inyutus ni Jesus ten madukás a ispiritu a lumakad siya ten lállaki.) ");
INSERT INTO prfNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Káttapos ay tinanung siya ni Jesus, “Ánya i ngaran muwid?” Tummábbig siya, “Batalyon, gapu makpal kami.” ");
INSERT INTO prfNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Nákpágguron siya kánni Jesus a dyan na hidi palakadán ti lugarid a iyud. ");
INSERT INTO prfNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Nadid, ten digdig nen bukid ay tehud a makpal a babuy a mamagsábbukan. ");
INSERT INTO prfNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Nákkekagbi kánni Jesus en mágkadukás a ispiritu a ni maari ay pasáddáppán na dálla hidi ten kababuyan. ");
INSERT INTO prfNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Pinayagan hidi ni Jesus kaya lummuwas ten tolay en mágkadukás hidi a ispiritu sakay sinomdáp hidi ten kababuyan. Káttapos ay namagginanan en manga duwanglibu a kababuyan ten pengpeng, nágkatápduk hidi ten dinom sakay nágkalimás. ");
INSERT INTO prfNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Pákketa nen mággalaga hidi ten kababuyan ten nangyari ay ginuminan hidi sakay angen di imbareta ten banuwan sakay ten kadatig hidi a banuwan en atanan nen netan di. Kaya ummangay haud en tolay hidi gapu gustu di a ketan en nangyari. ");
INSERT INTO prfNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Dikona umadeni en tolay hidi kánni Jesus ay netan di en lállaki a dati a sináddáp ni kadimonyowan a mággetnud. Mahusay dán en isip na sakay nakabadu dán, kaya neántingan en tolay hidi. ");
INSERT INTO prfNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Imbábbareta nen naketa hidi ten tolay hidi a dummemát en nangyari ten lállaki a sináddáp ni dimonyo sakay ten kababuyan. ");
INSERT INTO prfNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Káttapos ay nákkekagbi en tolay hidi kánni Jesus a ni maari ay lumakad siya ten lugar di. ");
INSERT INTO prfNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Dikona a sumakay dán ti Jesus ten abeng ay nákkekagbi dikona en lállaki a linakadan nen kadimonyowan, kinagi na, “Mákkuyugák pay dikomu!” ");
INSERT INTO prfNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Peru awan pummayag ti Jesus nan kinagi na, “Umuli ka sakay ikagi mu ten kamag-anak mu hidi en atanan a ginamet nen Panginoon dikomu, ni konya na ka a kinagbiyan.” ");
INSERT INTO prfNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Kaya lummakad en lállaki sakay imbábbareta na ti buu a Decapolis en atanan nen ginamet ni Jesus dikona. Nagtaka en atanan nen nakasanig ten imbareta na. ");
INSERT INTO prfNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Ummarabes a ruway ti Jesus, ked palla siya ten gilid nen minalnu ay dinarupodupan dámman siya nen tunay ti kakpal a tolay. ");
INSERT INTO prfNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Ked bi haud en essa a lállaki a Jairo en ngaran na. Essa siya a tagapamahala ten sinagoga. Pákketa na kánni Jesus ay linumuhud siya ten atubengán na. ");
INSERT INTO prfNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Nákkekagbi siya, sakay kinagi na, “Magipepatay dán en anak ku a dalagita, ni maari ay mákkuyug ka pay dikoku. Itupu mu la i lima muwen dikona tánni magpiyya siya sakay mabiyag.” ");
INSERT INTO prfNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Nákkuyug ti Jesus dikona sakay ummunud en tunay ti kakpal a tolay a magdail-ilan, ngari-ngari a masáldit ti Jesus. ");
INSERT INTO prfNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Ked bi haud en essa a bábbi a sapulu ay ti duwwa dán a taon a mágdadigiyán. ");
INSERT INTO prfNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Naubus na dán atanan nen ari-ariyan na ten págpapagamot na sakay makpal dán a mággamot en nanggamot dikona peru awan la nagpiyya nan nahirapan la siya sakay ummondug pa en saket na. ");
INSERT INTO prfNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Nasanig na en tungkul kánni Jesus kaya nákpagdail-ilan siya a ummadeni ten adág ni Jesus sakay tinawidan na en badu na, ");
INSERT INTO prfNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","gapu kinagi na ten sadili na a maski ni matawidan na la en badu ni Jesus ay magpiyya dán siya. ");
INSERT INTO prfNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Ti odas biyid a iyud a natawidan na en badu ni Jesus ay pagdaka na a nabati a awan dán en págdigi na sakay nagpiyya dán siya. ");
INSERT INTO prfNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Nadid, pagdaka a nabati ni Jesus a tehud a lummuwas ten kapangyariyan na, kaya lummingat siya ten katolayan sakay nagtanung, “Deya en nangtawid ten badu ku?” ");
INSERT INTO prfNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Tummábbig en disepulus na hidi, “Bakin itanung mu ni deya i nangtawidid ti badu muwen? Samantala a tunay ti kakpal i tolayen hidi a mamagdail-ilan?” ");
INSERT INTO prfNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Peru náglalingat-lingatán la ti Jesus, aryokán na en nangtawid ten badu na. ");
INSERT INTO prfNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Gapu tukoy nen bábbi en nangyari ay ummadeni siya kánni Jesus a magpágpág ten ánteng na. Lummuhud siya ten atubengán ni Jesus sakay kinagi na en atanan nen ginamet na. ");
INSERT INTO prfNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Kinagi ni Jesus dikona, “Anak ku, pinagpiyya ka nen pánnampalataya mu. Umuli ka dán a mapayapa. Nagpiyya ka dán ten saket mu.” ");
INSERT INTO prfNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Pasiya palla a mákpágguron ti Jesus ten bábbi ay tehud a sangan a dummemát a gubwat ten bilay ni Jairo, kinagi di, “Natay dán en anak mu, dyan mu dán abalaán i Maistuwen.” ");
INSERT INTO prfNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Awan pinospos ni Jesus en kinagi di nan kinagi na kánni Jairo, “Dyan ka mawanan ti pag-asa, basta maniwala ka la.” ");
INSERT INTO prfNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Awan ti iba a ingkuyug ti Jesus nan de Pedro la ay ten matkaka a Santiago ay ti Juan. ");
INSERT INTO prfNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Káddemát di ten bilay ni Jairo ay netan ni Jesus a makpal a tolay a mamagsangetan sakay marendi hidi. ");
INSERT INTO prfNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Kaya ten kássáddáp na ten bilay ay kinagi na dikodi, “Bakin marendi kam sakay mamagsangetan? Awan natay anaken, tidug la siya.” ");
INSERT INTO prfNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Peru pinagtawaan di la ti Jesus. Káttapos ay pinaluwas na en tolay hidi ten bilay puwera la ten dáddikál hidi nen anak sakay ten tállu a disepulus na. Sakay ummadeni hidi ten págyanan nen anak. ");
INSERT INTO prfNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Tinawidan ni Jesus en lima nen anak sakay kinagi na, “Talitha koum,” gustu naid a kagiyán ay, “Anak, umikat ka!” ");
INSERT INTO prfNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Pagdaka a ummikat en anak sakay naglakad. Sapulu ay ti duwwa a taon en idad na. Atanan nen naketa ten ginamet ni Jesus ay nagtaka. ");
INSERT INTO prfNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Mahigpit a imbilin ni Jesus dikodi a dyan di ikagi maski kándeya en netan di a nangyari. Sakay inyutus na a pakanán di dán en anak. ");
INSERT INTO prfNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Lummakad haud ti Jesus sakay ummuli ten banuwan na, nákkuyug en disepulus na hidi. ");
INSERT INTO prfNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Ten Aldew nen Káimang nen Judio hidi ay nangaral siya ten sinagoga. Dikona nasanig nen makpal a tolay en pángngaral na ay nagtaka hidi sakay kinagi di, “Hádya wád nangalapan naid ti karunungan naen? Hádya ginubwatanid ni kapangyariyan naen a makagamet ti himala? ");
INSERT INTO prfNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Awan beman siya en karpinteru a anak ni Maria, sakay kákkapatkaka na de Santiago, Jose, Judas, sakay ti Simon, sakay ked bi háddi en kákkapatkaka na hidi a bábbi?” Gapu ti iyud ay nagduda hidi dikona sakay immemenos di siya. ");
INSERT INTO prfNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Kaya kinagi ni Jesus, “Igalang maski hádya en essa a propeta, puwera la ten kabanuwan na hidi, kapartidu, sakay kasabilay.” ");
INSERT INTO prfNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Awan siya nakagamet ti himala haud nan en págtupu na la ten lima na ten sasangan a tehud a saket sakay pinagpiyya na hidi. ");
INSERT INTO prfNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Nagtaka siya ni bakin awan hidi sumampalataya dikona. Nadid, linebut ni Jesus en lugar hidi haud sakay nangaral ten tolay hidi. ");
INSERT INTO prfNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Dinulaw na en sapulu ay ti duwwa a apostol sakay inutusan na hidi a tágdaduwwa. Inátdenan na hidi ti kapangyariyan a mangdaig ten mágkadukás a ispiritu. ");
INSERT INTO prfNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Imbilin na dikodi a, “Dyan kam magbalon ti maski ánya haán a makan oni pilak, maski ni hembeg, basta en sarukud moy la. ");
INSERT INTO prfNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Magsandalyas kam la sakay dyan kamon magtawid ti paglewasan.” ");
INSERT INTO prfNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Sakay kinagi na pa bi dikodi, “Ni deya en mangtanggap dikomoy ten bilay na ay haud kam a máktulos hanggan ni lumakad kam ti banuwanid a iyud. ");
INSERT INTO prfNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Peru ni awan di kam tanggapán oni sanigán ten essa a banuwan, ay lumakad kam haud sakay ipagpag moy en alikabuk ni babásset moyen, bilang babala dikodi. ");
INSERT INTO prfNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Kaya lummakad en sapulu ay ti duwwa a apostol. Impangaral di ten katolayan a kailangan a magsisi hidi sakay umadág hidi ten kasalanan di. ");
INSERT INTO prfNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Pinalayas di en dimonyo hidi a summáddáp ten katolayan, sakay hinaplasan di ti langis en makpal a tehud a saket sakay pinagpiyya di hidi. ");
INSERT INTO prfNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Nadid, nabareta ni Hari a Herodes en tungkul kánni Jesus gapu netanyag dán ti hustu. Tehud a magkagi a nabiyag kan a ruway ti Juan a Mágbinyag kaya makagamet ti Jesus ti himala. ");
INSERT INTO prfNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Peru kagi nen agum ay ti Elias kan siya. Tehud bi a magkagi a essa kan siya a propeta a kona ten propeta hidi tenhud a panahun. ");
INSERT INTO prfNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Dikona masanig iyud ni Hari a Herodes ay kinagi na, “Siya ay ti Juan a pinaputol ku ti ulu. Nabiyag siya a ruway!” ");
INSERT INTO prfNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Kinagi iyud ni Herodes gapu siya en nangpadikáp sakay nángpepiresu kánni Juan gapu ten kagustuwan ni Herodias. Ginamet na iyud gapu kánni Herodias. (Ti Herodias ay kinabinga ni Herodes maski kabinga dán siya nen kapatkaka na a ti Felipe.) ");
INSERT INTO prfNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Pirmi a kagiyán ni Juan kánni Herodes a awan na dapat a kabingaán en kabinga nen kapatkaka na. ");
INSERT INTO prfNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Kaya naiyamut ti Herodias kánni Juan, gustu na siya a pabunu peru awan siya ti magamet ");
INSERT INTO prfNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","gapu tukoy na a manteng ti Herodes kánni Juan. Tukoy ni Herodes a matuwid sakay banal a tolay ti Juan kaya isurug na. Gugustu na a mágsanig ten itáttoldu hidi ni Juan maski makagulu iyud dikona. ");
INSERT INTO prfNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Peru nagkahud labi ti pagkakataun ti Herodias a pabunu ti Juan dikona dummemát en aldew nen kákkeenak ni Herodes. Nagpahanda ti Herodes ti dikál a handaan sakay inakit na en atanan nen pinunu na hidi, en pinunu hidi nen sundalu hidi sakay en mágkayaman hidi ti Galilea. ");
INSERT INTO prfNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Dikona nagsayaw en anak ni Herodias a dalaga, ay nasaya a tarud ti Herodes sakay en bisita na hidi kaya kinagi nen hari ten anak ni Herodias, “Agidán mu maski ánya gustu muwid ta iyatád ku dikomu!” ");
INSERT INTO prfNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Sakay impangaku na pa a maski kan en kalahati nen kahariyan na ay iyatád na ni saiyud i agidán naid. ");
INSERT INTO prfNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Ummangay en dalaga ten ina na sakay tinanung na ni ánya i agidán naid. Kinagi ni Herodias a en ulu ni Juan a Mágbinyag i agidán naid. ");
INSERT INTO prfNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Pagdaka a nagsoli en dalaga kánni Hari a Herodes sakay kinagi na, “Gustu kuwid a iyatád mu dikoku nadid ay en ulu ni Juan a Mágbiyag a nedátton ti penggan.” ");
INSERT INTO prfNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Dikál en sisi ni Hari a Herodes peru awan siya makaadi gapu nagpangaku siya ten atubengán nen bisita na hidi. ");
INSERT INTO prfNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Pagdaka na a inyutus ten sundalu a iyangay dikona en ulu ni Juan. Summunud en sundalu sakay pinutol na en ulu ni Juan ten págpiresuwan. ");
INSERT INTO prfNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Indátton na en ulu ten penggan sakay inyatád na ten dalaga. Tulos bi a inyatád nen dalaga ten ina na. ");
INSERT INTO prfNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Dikona nabareta iyud nen disepulus hidi ni Juan a Mágbinyag ay inangay di en bangkay na, sakay tulos di a inlábbáng. ");
INSERT INTO prfNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Nadid, nagsoli en apostol hidi kánni Jesus sakay imbareta di en atanan nen ginamet di sakay intoldu di. ");
INSERT INTO prfNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Peru tunay ti kakpal a tolay a mamagdemáttan sakay mamaglakadan, kaya maski kákkan di ay awan di dán mapospos. Kinagi ni Jesus ten disepulus na hidi, “Angay kitam ten tahimik a lugar tánni makaimang kam ti sabadit.” ");
INSERT INTO prfNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Sakay nággabeng hidi a ummangay ten tahimik a lugar. ");
INSERT INTO prfNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Peru makpal a tolay en naketa ten kárrektat di, sakay natenggi di hidi sakay tukoy di ni hádya a angay de Jesus. Kaya en tolay hidi a gubwat ti iba-iba a banuwan ay ummunud dikodi. Dinipalonguwan di pa de Jesus a dummemát ten lugar a angayan di. ");
INSERT INTO prfNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Dikona umawas ti Jesus ten abeng ay netan na en tunay ti kakpal a tolay. Kinagbiyan na hidi gapu kumán hidi a en tupa a awan ti mággalaga. Kaya tinolduwan na hidi ti makpal a bagay. ");
INSERT INTO prfNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","36","Dikona apon dán ay ummadeni kánni Jesus en disepulus na hidi sakay kinagi di, “Maistu, mággaaapon dán, paangayán mu dán tolayen hidi ti babaryuwen, pagaryokán mu dán hidi ti pangapon di gapu ked kitam ti adeyuwidi a lugar.” ");
INSERT INTO prfNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Peru kinagi ni Jesus a, “Sikam mangatáddid dikodi ti makan di.” Tummábbig en disepulus na hidi, “Konya pangpakan miyid dikodi? Ngari-ngari a sataon a suweldu i kailanganid para mapakan hidi a atanan.” ");
INSERT INTO prfNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Kinagi na dikodi, “Angen moy ilingán ni sakonya en balon moy a tinapay.” Pákketa di ay kinagi di kánni Jesus, “Lilimma a tinapay sakay duduwwa a ikan.” ");
INSERT INTO prfNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","40","Káttapos ay pinaetnud ni Jesus en tolay hidi a nagrupu-grupu ten kalamonan. Balang grupu ay tehud a limma pulu sakay tehud a tággidatos. ");
INSERT INTO prfNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Inalap ni Jesus en limma a tinapay sakay en duwwa a ikan, tummangad siya dilanget sakay nagpasalamat ten Diyos. Káttapos ay tináppeng-táppeng na en tinapay sakay inyatád na ten disepulus na hidi sakay intagtag di ten katolayan. Kona bi hud en ginamet na ten ikan. ");
INSERT INTO prfNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Nakakan hidi a atanan sakay nágkabássug hidi. ");
INSERT INTO prfNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Sakay dikona a puronán nen disepulus hidi en summubra a tinapay sakay ikan, ay naputat di pa en sapulu ay ti duwwa a lákba. ");
INSERT INTO prfNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Tehud a limmang libu a lállaki en kinuman ten tinapay. ");
INSERT INTO prfNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Pagdaka a pinasakay ni Jesus en disepulus na hidi ten abeng, pinágdipalongu na hidi a umarabes tamu ti Bethsaida, mentras a pauliyán na en tolay hidi. ");
INSERT INTO prfNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Káttapos na a magpaalam dikodi ay ummangay siya ten bukid tánni magdasal. ");
INSERT INTO prfNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Dikona gibi dán ay ked dán ten ditaw en abeng, ti Jesus ay ked ten dinapan. ");
INSERT INTO prfNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Natan-aw na en disepulus na hidi a maghirap hidi a magbusay gapu patagbu en parás dikodi. Ten kaldiwan dán ay naglakad ti Jesus ten dibabew nen dinom a tamu dikodi. Laan na hidi lampasan, ");
INSERT INTO prfNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","peru dikona netan di siya a maglakad ten dibabew nen dinom ay neántingan hidi kaya pummákraw hidi gapu akala diyid ay anitu siya. ");
INSERT INTO prfNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Tunay en ánteng di dikona ketan di siya, peru nagupos a pagdaka ti Jesus, kinagi na, “Dyan kam manteng, sikán iddi! Begsákkan moy isip moyen!” ");
INSERT INTO prfNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Summakay ti Jesus ten abeng di sakay kinumupa en parás. Nagtaka hidi ti hustu, ");
INSERT INTO prfNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","gapu awan di palla maintendiyan en kahulugan nen nangyari ten tinapay, sakay awan palla maabut nen isip di. ");
INSERT INTO prfNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Dikona makaarabes dán hidi ay pummundu hidi ten banuwan a Genesaret. ");
INSERT INTO prfNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Sakay dikona umawas hidi ay pagdaka siya a natenggi nen tolay hidi. ");
INSERT INTO prfNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Kaya nagalistu hidi a naglebut ten babaryu sakay inangay di en tehud hidi a saket. Maski ked hádya en tehud hidi a saket ay usungán di la ten págkatdugan na sakay iyangay di hádya man en pakabaretaan di a páppágyanan ni Jesus. ");
INSERT INTO prfNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Maski ni ked siya ti baryu, ten banuwan, oni ten uma, ay pagdaka di a iyadeni dikona en tehud hidi a saket sakay ipákkekagbi di a ni maari ay matawidan di en garayan nen badu na. Sakay en atanan nen makatawid ay magpiyya. ");
INSERT INTO prfNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Nadid, ummadeni kánni Jesus en Pariseo hidi sakay en sangan a tagapagtoldu nen Kautusan a gubwat ti Jerusalem. ");
INSERT INTO prfNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Netan di en sangan ten disepulus na hidi a kumman a awan nagugas ti lima ayun ten kaugaliyan di. ");
INSERT INTO prfNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Gapu en Pariseo hidi sakay atanan nen Judio hidi ay awan kuman ni awan hidi nakapagugas ten lima di, ayun ten minana di a kaugaliyan nen ninunu di hidi. ");
INSERT INTO prfNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Awan di bi kanán en ányaman a gubwat ti palengki ni awan palla naugasan. Makpal pa hidi a sássunudán a toldu a minana di, kona ten pággugas ten tasa hidi, pitsel, kagamitan hidi a tangsu, sakay ten págkatdugan hidi. ");
INSERT INTO prfNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Kaya tinanung nen Pariseo hidi sakay nen tagapagtoldu hidi nen Kautusan ti Jesus, “Bakin awan sumássunud i disepulus muwen hidi ten intoldu nen ninunu tam hidi? Kuman hidi a awan palla nakapagugas ti lima ayun ten kaugaliyan.” ");
INSERT INTO prfNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Tinábbig hidi ni Jesus, “Sikam a magkukunwari hidi! Tama ngani en hula ni propeta Isaias tungkul dikomoy, dikona insulat na a, ‘En pággalang dikoku ni banuwanid a iddi ay wari-wari la, gapu gumubwat la iyud ten ngusu bakán a ten pusu di. ");
INSERT INTO prfNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Awan ti kuwenta en págsamba di, gapu itáttoldu di a gubwat ten Diyos en utus di hidi.’ ");
INSERT INTO prfNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Mas pinahalagaan moy pa en utus nen tolay nan en utus nen Diyos.” ");
INSERT INTO prfNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Kinagi pa ni Jesus, “Mágkalalaki kam! Para masunud moy la en dati moy a pánniwala, ay pinawanan moy ti halaga en utus nen Diyos! ");
INSERT INTO prfNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Kona ten kautusan ni Moises a, ‘Igalang mu en ama mu ay ten ina mu. Sakay ni deyaman en magupos ti madukás ten ama na ay ten ina na ay dapat a bunuwán.’ ");
INSERT INTO prfNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Peru en itáttoldu moy ten tolay hidi ay, ‘Ni tehud kam a maari a itulung ten dáddikál moy hidi ay maari moy a kagiyán a iyud ay Corban.’ (En gustu na a kagiyán ay iyád ay nealay dán ten Diyos.) ");
INSERT INTO prfNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Kaya awan moy dán hidi patulungán ten dáddikál di. ");
INSERT INTO prfNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Gapu ti iyud ay pinawanan moy dán ti halaga en upos nen Diyos. Makpal kam pa a itáttoldu a kona labi haád.” ");
INSERT INTO prfNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Ruway a pinaadeni ni Jesus en tolay hidi sakay kinagi na dikodi, “Mágsanig kam a atanan sakay intendiyán moy i kagiyán kuwiday! ");
INSERT INTO prfNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Bakán a en pagkain a sumáddáp ten ngusu nen tolay i mangpadingáttid dikona nan en lumuwas ten ngusu na. ");
INSERT INTO prfNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Mágsanig en tehud págsanig!” ");
INSERT INTO prfNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Linakadan ni Jesus en tolay hidi sakay ummangay siya ten bilay. Dikona nakasáddáp dán siya ay tinanung siya nen disepulus na hidi tungkul ten talinhaga. ");
INSERT INTO prfNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Kinagi ni Jesus dikodi, “Bakin pati beman sikam ay awan moy naintendiyan? Awan moy beman tukoy a bakán a en isubu nen tolay i mangpadingáttid dikona? ");
INSERT INTO prfNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Gapu awan iyud umasák ten pusu na nan ten tiyan na la káttapos ay iluwas na labi.” (Ti kinagiyid a iyád ni Jesus, ay impahayag na a maari a kanán atanan a pagkain.) ");
INSERT INTO prfNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Sakay kinagi na, “En lumuwas ten tolay i mangpadingáttid dikona ten pangileng nen Diyos. ");
INSERT INTO prfNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Gapu gubwat ten disalad nen pusu nen tolay, en atanan nen mágkadukás a isip. Kona ten makiapid, magtakaw, mamunu, ");
INSERT INTO prfNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","mangalunya, magnasa ten bakán na a kao. Sakay mangloku ti tolay a kona ten págdaya, kahalayan, kásseni, págmetmet, págpalalu sakay kahangalan. ");
INSERT INTO prfNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Atananid a iyád a mágkadukás ay maggubwat ten pusu sakay hidi iyád i mangpadingáttid dikona.” ");
INSERT INTO prfNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Nadid, nagrektat ti Jesus sakay ummangay siya ten lugar a Tiro sakay ti Sidon. Tummulos siya ten essa a bilay sakay awan na gustu a matukuyan nen deyaman a ked siya haud, peru netan di labi siya. ");
INSERT INTO prfNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Tehud haud a essa a ina a tehud a anak a bábbi a sináddáp ni madukás a ispiritu. Pákkabareta na a dummemát ti Jesus ay pagdaka siya a ummangay dikona sakay lummuhud ten atubengán na. ");
INSERT INTO prfNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Iyud a bábbi ay Griego a taga-Sirofenicia. Nákkekagbi siya kánni Jesus a palakadán en dimonyo a summáddáp ten anak na. ");
INSERT INTO prfNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Peru kinagi ni Jesus a, “Kailangan a dipalonguwán ku pa en anak hidi a pakanán. Awan tama a alapán en kanán nen anak sakay ipakan ten asu.” ");
INSERT INTO prfNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Tummábbig en bábbi, “Tarud ngani Panginoon, peru kanán bi nen asu hidi a ked ten sarok nen lamesa en nágkeragrag nen anak hidi.” ");
INSERT INTO prfNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Kaya kinagi ni Jesus dikona, “Gapu ti kinagi muwen ay maari ka dán a umuli. Linakadan dán nen dimonyo en anak mu.” ");
INSERT INTO prfNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Ummuli en bábbi sakay dinemáttan na en anak na ten págkatdugan na, a linakadan dán ngani nen dimonyo. ");
INSERT INTO prfNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Nadid, dikona nagsoli de Jesus a gubwat ti Tiro ay nagdaman hidi ti Sidon patamu hidi ten Minalnu ti Galilea, sakay nagkon hidi ten danág ti Decapolis. ");
INSERT INTO prfNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Inyangay nen tolay hidi dikona en essa a lállaki a bángngág sakay bulol. Nákkekagbi hidi a itupu na en lima na ten lállaki. ");
INSERT INTO prfNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Inyadeyu ni Jesus en lállaki ten katolayan, sakay insulot na en guramát na ten magtembang a bángbáng nen lállaki, káttapos ay pinahidan na en dila nen lállaki ten loktab na. ");
INSERT INTO prfNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Tummangad ti Jesus dilanget sakay ummangás ti dikál. Káttapos ay kinagi na a, “Effata” en gustu na a kagiyán ay, “Bumukas ka!” ");
INSERT INTO prfNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Ti odasid a iyud ay pagdaka a nakasanig en lállaki sakay nakapagupos dán ti malinaw. ");
INSERT INTO prfNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Kinagi ni Jesus ten tolay hidi a dyan di ibareta en ginamet na. Peru mentras a bawalan na hidi ay lalu di bi a ibábbareta. ");
INSERT INTO prfNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Hinumanga hidi ti hustu sakay kinagi di, “Atanan nen gággamitán na ay mágkaganda! Pagpiyyaán na pa en bángngág hidi sakay bulol!” ");
INSERT INTO prfNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Ti aldewid a hidi iyud ay ruway a naipun en tunay ti kakpal a tolay. Dikona awan dán hidi ti makan ay dinulaw ni Jesus en disepulus na hidi sakay kinagi na, ");
INSERT INTO prfNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Kagbiyan ku i tolayiday hidi gapu tállu dán hidi a aldew a kakaguman ku, nadid ay awan dán hidi ti makan. ");
INSERT INTO prfNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Ni pauliyán ku hidi a magaláp ay manglupoy hidi ti dilanen, adeyu pa bi i uliyanid ni agumen.” ");
INSERT INTO prfNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Nagtanung en disepulus na hidi, “Hádya beman i pangalapan tamid ti makan ti kaparanganiday para makakan i kakpal ni tolayen hidi?” ");
INSERT INTO prfNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","“Sangan a mommon i tinapay moyen?” tanung ni Jesus. “Pittu,” kagi di. ");
INSERT INTO prfNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Pinaetnud ni Jesus en tolay hidi ten luta. Inalap na en pittu a tinapay sakay nagpasalamat ten Diyos. Káttapos ay tináppeng-táppeng na en tinapay sakay inyatád na ten disepulus na hidi tánni itagtag di ten katolayan. Kona ngani haud en ginamet nen disepulus na hidi. ");
INSERT INTO prfNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Tehud bi hidi a sasangan a bábbadit a ikan. Nagpasalamat siya a ruway ten Diyos sakay inutusan na en disepulus na hidi a itagtag di bi iyud ten katolayan. ");
INSERT INTO prfNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Nakakan hidi a atanan sakay nabássug. Dikona puronán di en subra ay nakaputat pa hidi ti pittu a lákba. ");
INSERT INTO prfNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Tehud a áppat a libu en tolay a kinuman. Dikona a mapauli na en tolay hidi, ");
INSERT INTO prfNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","ay summakay ti Jesus ten abeng kaguman na en disepulus na hidi, sakay ummangay hidi ten lugar a Dalmanuta. ");
INSERT INTO prfNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Ummangay en Pariseo hidi kánni Jesus sakay nákpagdiskusyon hidi dikona. Gustu di siya a purbaan kaya kinagi di dikona a mángpeta siya ti essa a himala a gubwat dilanget. ");
INSERT INTO prfNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Inumangás ti dikál ti Jesus sakay kinagi na dikodi, “Bakin sikam a tolay nadid a panahun ay mággid kam ti himala? Pakatandaan moy, awan makeketa ti ányaman a tanda i lahiyid a iyád.” ");
INSERT INTO prfNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Linakadan na hidi, sakay summakay siya a ruway ten abeng sakay ummarabes ten dibelyu. ");
INSERT INTO prfNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Nalimunan nen disepulus na hidi a magtawid ti tinapay, sakay eessa dálla a mommon en naburay ten tawid di a tinapay ten abeng. ");
INSERT INTO prfNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Kinagi ni Jesus dikodi, “Magingat kam ten págpaalsa nen Pariseo hidi sakay ni Herodes.” ");
INSERT INTO prfNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Kinagi nen disepulus hidi ten balang essa, “Awan kitam biyay bi ti tawid a tinapay kaya kinagi na iyud.” ");
INSERT INTO prfNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Gapu tukoy ni Jesus en pamággurunan di, ay kinagi na dikodi, “Bakin pamággurunan moy a awan kam ti tawid a ti tinapay? Awan kam palla beman makaintendi hanggan nadid? Awan palla beman iyád abut ni isip moyen? ");
INSERT INTO prfNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Tehud kam labi a mata, burák kam beman? Tehud kam labi a bángbáng, bángngág kam beman? Nalimunan moy dán beman ");
INSERT INTO prfNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","en tináppeng-táppeng ku a limma a tinapay para ten limmang libu a tolay? Sangan a lákba en napuron moy a buray a tinapay?” “Sapulu ay ti duwwa,” tábbig di. ");
INSERT INTO prfNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“Sakay dikona táppeng-táppengán ku en pittu a tinapay para ten áppat a libu a tolay, sangan a lákba en naputat moy ten naburay?” “Pittu a lákba,” tábbig di a ruway. ");
INSERT INTO prfNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Sakay kinagi na dikodi, “Awan moy palla beman maintendiyan?” ");
INSERT INTO prfNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Káddemát de Jesus ti Bethsaida, ay inyangay nen sangan a tolay dikona en essa a burák sakay impákpágguron di a tawidan na i tolayid a iyád. ");
INSERT INTO prfNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Inalalayan ni Jesus en burák sakay inluwas na ten banuwan. Linoktaban na en mata nen burák sakay intupu na en lima dikona. Káttapos ay tinanung siya ni Jesus, “Tehud ka dán a ketan?” ");
INSERT INTO prfNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ummileng en lállaki sakay kinagi na, “Maketaák ti katolayan peru kumán a kayu a maglakad.” ");
INSERT INTO prfNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Ruway a intupu ni Jesus en lima na hidi ten mata nen burák. Dikona umileng en lállaki ti mapiyya ay maketa dán siya sakay malinaw dán en ketan na. ");
INSERT INTO prfNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Kinagi ni Jesus dikona, “Umuli ka dán. Dyan ka dán rumoyot di banuwan.” ");
INSERT INTO prfNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Káttapos ay ummangay ti Jesus ten lugar a Cesarea a sakup ni Filipos, kaguman na en disepulus na hidi. Mentras a maglakad hidi ay tinanung na hidi, “Deyaák ten pangisip nen tolay hidi?” ");
INSERT INTO prfNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Tummábbig en disepulus na hidi, “Tehud a magkagi a ti Juan a Mágbinyag ka kan. Tehud bi a magkagi a ti Elias ka kan. Kagi bi nen agum ay essa ka ten propeta hidi.” ");
INSERT INTO prfNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","“Ay sikam, deyaák?” Tanung ni Jesus. Tummábbig ti Pedro, “Siko en Cristo.” ");
INSERT INTO prfNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","“Dyan moy kagiyán maski kándeya ni deyaák,” mahigpit a utus na dikodi. ");
INSERT INTO prfNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Sakay sinapulan na dán a kinagi ten disepulus na hidi en mangyari dikona. Kinagi na, “En Anak nen Tolay ay magdanas ti makpal a hirap. Itakwil siya nen pinunu hidi nen banuwan, nen pinunu hidi nen padi hidi sakay nen tagapagtoldu hidi nen Kautusan. Pabunu di siya peru ten katállu a aldew ay mabiyag siya a ruway.” ");
INSERT INTO prfNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Ingkagi na iyád dikodi ti malinaw, inyadeyu ni Pedro ti Jesus sakay sinaway na. ");
INSERT INTO prfNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Peru ummatubeng ti Jesus ten disepulus na hidi sakay kinagi na kánni Pedro, “Umibut ka ti atubengán kuwiday, Satanas! I áisipán muwen ay bakán a gubwat ten Diyos nan ten tolay.” ");
INSERT INTO prfNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Pinaadeni ni Jesus en katolayan pati en disepulus na hidi sakay kinagi na dikodi, “Ni deyaman en masor a sumunud dikoku ay kailangan a limunán na en sadili na, báklayán na en kudus na, sakay sumunud dikoku. ");
INSERT INTO prfNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Gapu ni deyaman en masor a mángligtas ten biyag na ay mawanan ti biyag; peru en mawanan ti biyag alang-alang dikoku sakay ten Maganda a Bareta ay magkahud ti biyag. ");
INSERT INTO prfNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Ánya beman pakinabangid nen essa a tolay ni makao na i buuwid a mundu ni ikepahamak na labi iyud? ");
INSERT INTO prfNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Ánya beman i mebayadid nen essa a tolay para mabawi na en biyag na? ");
INSERT INTO prfNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Ni ikasanikiyák moy sakay en upos ku hidi ten atubengán nen taksil hidi sakay makasalanan a tolay nadid a panahun, ay ikasaniki kam bi nen Anak nen Tolay káddemát na a tehud a dakila a kapangyariyan a gubwat ten Ama, sakay kaguman na en anghel hidi a banal.” ");
INSERT INTO prfNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Kinagi pa ni Jesus dikodi, “Tandaan moy, tehud a sangan háddi dikomoy a awan matay mentras a awan di ketan en makapangyariyan a pághari nen Diyos.” ");
INSERT INTO prfNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Kállipas nen ánnám a aldew ay ingkuyug ni Jesus de Pedro, Santiago sakay ti Juan ten malangkaw a bukid a awan ti tolay. Dikona ked dán hidi haud ay netan di a nagiba en idsura ni Jesus. ");
INSERT INTO prfNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Pinumudew en badu na ti makasili, awan ti makapangpudew ti munduwiday. ");
INSERT INTO prfNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Netan di bi haud de Elias sakay ti Moises a nákpágguron kánni Jesus. ");
INSERT INTO prfNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Kinagi ni Pedro kánni Jesus, “Maistu, maganda ta ked kami háddi. Maggamet kami ti tállu a sarong, essa dikomu, essa kánni Moises sakay essa bi kánni Elias.” ");
INSERT INTO prfNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Nakagi iyud ni Pedro gapu awan na tukoy en kagi-kagiyán na gapu tunay en ánteng di. ");
INSERT INTO prfNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Linenduman hidi nen mabagál a diklám sakay tehud a nagupos a gubwat ten diklám, a kinagi na, “Iyád en mahal ku a anak. Sunudán moy siya.” ");
INSERT INTO prfNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Dikona umileng hidi ten palebut di ay awan dán hidi ti netan a iba nan ti Jesus dálla. ");
INSERT INTO prfNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Dikona managson dán hidi ten bukid ay binilin hidi ni Jesus ti mahigpit a dyan di kagiyán maski kándeya en netan di mentras a awan mabiyag a ruway en Anak nen Tolay. ");
INSERT INTO prfNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Sinunud di en kinagi na peru namagtanungan hidi ni ánya kahuluganid nen kinagi na a kákkabiyag a ruway. ");
INSERT INTO prfNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Sakay tinanung di ti Jesus, “Bakin kinagi nen tagapagtoldu hidi nen Kautusan a dapat a mágdipalongu a dumemát ti Elias?” ");
INSERT INTO prfNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Kinagi na dikodi a, “Tatarudan iyán mágdipalongu a dumemát háddi ti Elias tánni ihanda na en atanan a bagay. Peru bakin kinagi bi nen Kasulatan a en Anak nen Tolay ay imemenos di sakay magtággád ti makpal a hirap? ");
INSERT INTO prfNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Peru kagiyán ku dikomoy iddi, dummemát dán háddi ti Elias sakay ginamet nen tolay hidi en gustu di a gamitán dikona, a kona ten nesulat tungkul dikona.” ");
INSERT INTO prfNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Nadid, dikona a summoli dán hidi ay nademáttan di en agum hidi a disepulus a kinalibungbungan nen makpal a tolay sakay nen tagapagtoldu hidi nen Kautusan a mákpagtalu dikodi. ");
INSERT INTO prfNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Dikona netan nen tolay hidi ti Jesus, ay naráknid hidi sakay nagginan hidi a tummagbu sakay binati di siya. ");
INSERT INTO prfNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Tinanung ni Jesus en disepulus na hidi, “Ánya i pamagtalunan moyen?” ");
INSERT INTO prfNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Tehud a essa a lállaki ten katolayan a nagupos, “Maistu, inyangay ku háddi dikomu i anak kuwidi a lállaki gapu sináddáp ni madukás a ispiritu, sakay awan siya makaupos. ");
INSERT INTO prfNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Kada pahirapan siya nen madukás a ispiritu ay medumor siya; magruru i ngusu naidi, magnguritáb i ngipán naidi sakay kumásseng. Inyoron ku ti disepulus muwen hidi a palakadán di en madukás a ispiritu peru awan di mapalakad.” ");
INSERT INTO prfNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Kinagi ni Jesus dikodi, “Lahi a awan ti pánnampalataya! Hanggan nikan takam pa beman a aguman? Hanggan nikan takam a pagtiisan? Iyangay moy háddi anaken!” ");
INSERT INTO prfNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Sakay inyangay di en anak kánni Jesus. Pákketa nen madukás a ispiritu kánni Jesus ay pagdaka na a pinagpágpág en anak, sakay nedumor ten luta, nagbuleláng sakay nagruru en ngusu na. ");
INSERT INTO prfNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Tinanung ni Jesus en ama nen anak, “Nengkan pa siya a nagkakona haán?” Kinagi nen ama, “Sapul pa iyán dikona badit palla siya.” ");
INSERT INTO prfNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","“Gustu siya a bunuwán nen madukás a ispiritu. Pirmi na siya a itumba ten apoy sakay ten dinom. Kaya ni tehud ka a magamet ay kagbiyan mu kami pay a tulungan.” ");
INSERT INTO prfNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Kinagi ni Jesus dikona, “Bakin kinagi mu a, ‘Ni tehud ka a magamet.’ Atanan a bagay ay mangyari ten tehud a pánnampalataya.” ");
INSERT INTO prfNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Pagdaka a kinagi nen ama nen anak, “Maniwalaák a talaga! Kagbiyanák mu a tulungan a madagdagan en pánnampalataya ku.” ");
INSERT INTO prfNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Dikona a ketan ni Jesus a magkakpal en katolayan, ay kinagiyan na en madukás a ispiritu, “Siko a ispiritu a mágpabángngág sakay mágpabulol, utusan taka a lumakad ka dán ti anaken sakay dyan ka dán sumoli dikona!” ");
INSERT INTO prfNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Minágpapákrawán en madukás a ispiritu, pinagpágpág na en anak, sakay káttapos ay tulos dán siya a lummakad. Kumán dán a patay en anak kaya balang essa ay nagkagi a patay dán siya. ");
INSERT INTO prfNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Peru tinawidan ni Jesus en lima nen anak sakay inyekat na, sakay tulos dán a tummaknág en anak. ");
INSERT INTO prfNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Dikona a summáddáp ti Jesus ten bilay, ay palihim siya a tinanung nen disepulus na hidi, “Bakin awan mi mapalakad iyud a madukás a ispiritu?” ");
INSERT INTO prfNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Tummábbig ti Jesus, “Mapalakad la iyud a kalasi ni ispiritu ten pamamag-itan ni págdasal.” ");
INSERT INTO prfNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Kállakad di haud ay nagkon hidi ti Galilea. Sala ni Jesus a matukuyan nen tolay hidi ni ked hádya siya ");
INSERT INTO prfNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","gapu tolduwan na tenhud en disepulus na hidi. Kinagi na dikodi, “En Anak nen Tolay ay metokyon ten tolay hidi sakay bunuwán di siya. Peru mabiyag siya a ruway ten katállu a aldew.” ");
INSERT INTO prfNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Peru awan di naintendiyan en kinagi ni Jesus, sakay manteng bi hidi a magtanung dikona. ");
INSERT INTO prfNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Dikona a dummemát de Jesus ten bilay ti Capernaum ay tinanung na en disepulus na hidi, “Ánya en pamagtalunan moy ten dilan?” ");
INSERT INTO prfNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Awan hidi ti kákkagi gapu en pamagtalunan di ay ni deya i kataasanid dikodi. ");
INSERT INTO prfNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Ummetnud ti Jesus, sakay dinulaw na en sapulu ay ti duwwa a disepulus, sakay kinagi na dikodi, “Ni deyaman en masor a magin purumeru ay dapat a magin katapusan, sakay magin tagapagserbi nen atanan.” ");
INSERT INTO prfNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Nangalap ti Jesus ti anak a badit sakay pinataknág na ten atubengán di. Káttapos ay kinálkál na sakay kinagi na ten disepulus na hidi, ");
INSERT INTO prfNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Ni deyaman en mangtanggap ten badit a anak a kona háddi alang-alang ten ngaran ku ay sikán en tinanggap na. Sakay ni deyaman en mangtanggap dikoku ay bakán la a sikán en tinanggap na nan pati en nangpaangay dikoku háddi.” ");
INSERT INTO prfNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Nadid, kinagi ni Juan kánni Jesus, “Maistu, naketa kami ti essa a tolay a magpalakad ti dimonyo ten pamamag-itan nen ngaran mu. Sinaway mi siya gapu awan tam siya kaguman.” ");
INSERT INTO prfNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Peru kinagi ni Jesus a, “Dyan moy sawayán, gapu en tolay a maggamet ti himala ten pamamag-itan nen ngaran ku ay awan siya pagdaka a magupos ti madukás kontra dikoku. ");
INSERT INTO prfNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Gapu en awan kumontra dikotam ay kapanig tam. ");
INSERT INTO prfNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Tandaan moy, ni tehud a mangatád dikomoy ti dinom, maski essa la a basu gapu sakup takam ay siguradu a makatanggap ti pagpapala.” ");
INSERT INTO prfNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Mapiyya pa ni báttenan ti dikál a gilingan a batu en állig nen essa a tolay, sakay ibator ditaw a diget nan ni siya ay magin dahilan ni kasalanan ten essa ti bábbaditid a hidi iddi a maniwala dikoku. ");
INSERT INTO prfNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Ni en lima mu i magin dahilanid nen kasalanan mu ay putáddán mu! Mas mapiyya pa ni mabiyag ka a putád en essa mu a lima nan ni tehud ka a duwwa a lima ni meangay ka labi ti impiyerno, ten apoy a awan maada-adáp. ");
INSERT INTO prfNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Awan mata-matay en urád hidi haud, sakay awan maada-adáp en apoy. ");
INSERT INTO prfNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Sakay ni en básset mu i magin dahilanid nen kasalanan mu ay putáddán mu! Mas mapiyya pa ni mabiyag ka a putád en essa mu a básset nan ni tehud ka a duwwa a básset ni meangay ka labi ti impiyerno. ");
INSERT INTO prfNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Awan mata-matay en urád hidi haud, sakay awan maada-adáp en apoy. ");
INSERT INTO prfNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Sakay ni en essa mu a mata i magin dahilanid nen kasalanan mu ay lábwetán mu! Mas mapiyya pa ni sumáddáp ka ten kahariyan nen Diyos a burák en essa mu a mata nan ni tehud ka a duwwa a mata ni meangay ka labi ti impiyerno. ");
INSERT INTO prfNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Awan mata-matay en urád hidi haud, sakay awan maada-adáp en apoy.” ");
INSERT INTO prfNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Gapu en balang essa ay mapurbaan ten pamamag-itan nen apoy. ");
INSERT INTO prfNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Maganda en asen peru ni mawan en lasa na, ay konya dán a mesoli en asen na? Kaya magin kona kam ten asen sakay mabiyag kam ti mapayapa ten balang essa. ");
INSERT INTO prfNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Nadid, kállakad di haud, ay ummangay hidi ten prubinsiya a Judea sakay ummarabes hidi ten dinom ti Jordan. Kinalibungbungan dámman siya nen makpal a tolay sakay tinolduwan na hidi kona ten dati na a gággamitán. ");
INSERT INTO prfNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Tehud a sangan a Pariseo a ummadeni kánni Jesus. Gustu di siya a purbaan kaya tinanung di siya, “Tama beman ten Kautusan a maari a hiwalayan nen lállaki en kabinga na?” ");
INSERT INTO prfNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Tinanung bi hidi ni Jesus, “Ánya beman en kinagi ni Moises?” ");
INSERT INTO prfNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Kinagi di, “Impayag ni Moises a maari a hiwalayan nen lállaki en kabinga na káttapos a magkahud ti kasulatan ni pághiwalay.” ");
INSERT INTO prfNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Peru kinagi ni Jesus dikodi, “Kaya insulat ni Moises i kautusanid a iyud ay gapu maktug i págguluwan moyen. ");
INSERT INTO prfNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Peru sapul pa dikona lalangán nen Diyos i munduwiday, ay linalang na dán en tolay a lállaki sakay bábbi. ");
INSERT INTO prfNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Iyád en dahilan kaya a lakadan nen lállaki en ama na ay ten ina na sakay magagum dán hidi ay ten kabinga na, ");
INSERT INTO prfNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","en duwwa ay magin essa dán.’ Bakán dán hidi a duwwa nan essa dán hidi. ");
INSERT INTO prfNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","En pinagagum nen Diyos ay awan dapat a paghiwalayán nen deyaman.” ");
INSERT INTO prfNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Káddemát di ten bilay, ay tinanung nen disepulus hidi ti Jesus tungkul ten pághiwalay. ");
INSERT INTO prfNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Kinagi na dikodi, “Ni deyaman a lállaki en humiwalay ten kabinga na sakay mákkabinga a ruway ti iba ay nagkasala ti pángngalunya ten kabinga na. ");
INSERT INTO prfNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Kona labi hud ten bábbi a humiwalay ten kabinga na, sakay mákkabinga ti iba ay nagkasala ti pángngalunya ten kabinga na.” ");
INSERT INTO prfNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Tehud a katolayan a náng-angay ten anak di hidi kánni Jesus tánni ipákpágguron di a itupu na en lima na dikodi, peru nagsarantaan hidi nen disepulus hidi. ");
INSERT INTO prfNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Nagsaranta ti Jesus dikona ketan na iyud. Kinagi na dikodi, “Pabayan moy la a umadeni dikoku i anaken, dyan moy hidi sawayán gapu en kona hidi dikodi en mebilang ten kahariyan nen Diyos. ");
INSERT INTO prfNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Tandaan moy, ni deyaman en awan mangtanggap ten kahariyan nen Diyos a kona ten káttanggap nen badit a anak ay awan paghariyan nen Diyos.” ");
INSERT INTO prfNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Káttapos ay kinálkál ni Jesus en anak hidi, intupu na en lima na ten ulu di sakay indasal na hidi a pagpalaán nen Diyos. ");
INSERT INTO prfNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Dikona magrektat dán de Jesus ay tehud a essa a lállaki a gumággenan a ummadeni dikona, sakay lummuhud ten atubengán na. Nagtanung siya, “Mahusay a Maistu, ánya dapat kuwid a gamitán tánni magkahudák ti biyag a awan ti katapusan?” ");
INSERT INTO prfNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Kinagi ni Jesus, “Bakin dulawánnák mu a mahusay? Awan ti iba a mahusay nan en Diyos la. ");
INSERT INTO prfNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Awan beman tukoy mu dán en kautusan nen Diyos a dyan ka mamunu, mangalunya, magtakaw, dyan ka magtistigu ten awan ti katutuhanan, dyan ka magdaya sakay igalang mu en ama mu ay ten ina mu.” ");
INSERT INTO prfNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Kinagi nen lállaki, “Maistu, sinunud ku dán hidi iyán a atanan sapul pa dikona anakák.” ");
INSERT INTO prfNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Dikona umileng ti Jesus ten lállaki ay tehud a págmahal a kinagi na, “Tehud pa a essa a bagay a kulang dikomu. Kammudán ilaku mu en atanan nen ari-ariyan mu hidi sakay iyatád mu ten pubri hidi en naglakuwan mu tánni magkahud ka ti kayamanan dilanget. Káttapos ay sumoli ka sakay mákkuyug ka dikoku.” ");
INSERT INTO prfNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Pákkasanig na ten kinagi ni Jesus ay minalungkut siya a lummakad gapu mayaman siya a tarud. ");
INSERT INTO prfNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Liningat ni Jesus en ked hidi ten palebut na sakay kinagi na ten disepulus na hidi, “Talaga a mahirap a makasáddáp en mágkayaman hidi ten kahariyan nen Diyos!” ");
INSERT INTO prfNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Nagtaka en disepulus na hidi ten kinagi na. Peru kinagi a ruway ni Jesus, “Anak ku hidi, talaga a tunay ti hirap a makasáddáp ten kahariyan nen Diyos! ");
INSERT INTO prfNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Mas alistu pa a makasáddáp en kamelyo ten ábbut nen digum nan ten essa a mayaman a mebilang ten kahariyan nen Diyos.” ");
INSERT INTO prfNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Lalu a minagtaka en disepulus hidi ten nasanig di kaya nagtanung hidi, “Ni konahud, ay deya wád i maligtasid?” ");
INSERT INTO prfNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Inileng hidi ni Jesus sakay kinagi na dikodi, “Awan iyád kaya a gamitán nen tolay, peru ten Diyos ay maari. Gapu atanan a bagay ay kaya a gamitán nen Diyos.” ");
INSERT INTO prfNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Nagupos ti Pedro, “Panginoon, inadággan mi dán en atanan tánni makasunud kami la dikomu.” ");
INSERT INTO prfNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Kinagi ni Jesus, “Tandaan moy: ni deyaman en manglakad ten bilay na, kákkapatkaka na, dáddikál na, anak na, sakay ten luta na hidi tánni sumunud dikoku, sakay para ten Maganda a Bareta, ");
INSERT INTO prfNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","ay makatanggap nadid a panahun ti datos a bilay, kákkapatkaka, dáddikál, anak sakay luta, peru tehud a kaguman a pággusig. Sakay ten dumemát a panahun ay magkahud siya ti biyag a awan ti katapusan. ");
INSERT INTO prfNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Peru makpal a mágdipalongu en medimudyan, sakay makpal ten mágdimudyan en medipalongu.” ");
INSERT INTO prfNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Dikona a ked hidi ten dilan a tamu ti Jerusalem ay mágdipalongu ti Jesus. Magkábba-kábba en disepulus na hidi sakay tehud bi a ánteng en tolay hidi a umunonud dikona. Imbukud a ruway ni Jesus en sapulu ay ti duwwa a disepulus na sakay kinagi na en mangyari dikona. ");
INSERT INTO prfNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Kinagi ni Jesus, “Angay kitam nadid ti Jerusalem, káddemát tam haud ay itokyon di en Anak nen Tolay ten pinunu hidi nen padi hidi, sakay ten tagapagtoldu hidi nen Kautusan. Hatulan di siya ti kamatayan sakay iyatád di siya ten Hentil hidi. ");
INSERT INTO prfNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Imemenos di siya, loktaban, haplitán, sakay tulos di a bunuwán. Peru kállipas nen tállu a aldew ay mabiyag siya a ruway.” ");
INSERT INTO prfNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Sakay ummadeni de Santiago ay ti Juan a anak ni Zebedeo kánni Jesus. Kinagi di, “Maistu, tehud kami nakuwan a ipákpágguron dikomu.” ");
INSERT INTO prfNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Tinanung hidi ni Jesus, “Ánya beman iyud?” ");
INSERT INTO prfNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Kinagi di, “Ni mággetnud ka dán ten kahariyan mu ay ipákpágguron mi nakuwan a makaetnud kami a kasadát mu, essa ten kawanan mu sakay essa bi ten kawiri mu.” ");
INSERT INTO prfNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Peru kinagi ni Jesus dikodi, “Awan moy tukoy i agidán moyen dikoku. Mainom moy beman en tasa nen kahirapan a inumán ku? Matággád moy beman en binyag a ibinyag dikoku?” ");
INSERT INTO prfNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","“Opo,” kagi di. Kinagi ni Jesus, “En tasa a inumán ku ay inumán moy ngani, sakay mabinyagan kam ngani ten binyag a tanggapán ku. ");
INSERT INTO prfNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Peru bakán a sikán i mangpiliyid ni deya i mággetnudid ten kawanan ku sakay ten kawiri ku. En Diyos en máng-atád ti lugarid a hidi iyán ten nánglaanan na.” ");
INSERT INTO prfNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Dikona a masanig iyud nen sapulu a disepulus, ay nagsaranta hidi ten matkaka a Santiago ay ti Juan. ");
INSERT INTO prfNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Kaya pinaadeni hidi ni Jesus sakay kinagi na, “Tukoy moy dán a en pinunu nen Hentil hidi ay ipeta di a talaga a hidi i mamunuwid, sakay en kataasan i masunudid. ");
INSERT INTO prfNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Peru bakán a kona haán i dapatid a mangyari dikomoy. Nan ni deyaman dikomoy en masor a magin kataasan ay dapat a magin tagapagserbi moy. ");
INSERT INTO prfNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Sakay ni deyaman en masor a magin pinunu ay dapat a magin alipin nen atanan. ");
INSERT INTO prfNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Gapu en Anak nen Tolay ay ummangay háddi bakán a para pagserbiyan nan para magserbi sakay tánni máng-alay ten biyag na para ten katubusan nen makpal.” ");
INSERT INTO prfNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Nadid, dummemát de Jesus ti Jerico. Dikona palakad dán hidi a kaguman na en disepulus na hidi sakay en makpal a tolay, ay tehud hidi a nataliban a essa a burák, mággetnud siya ten gilid nen dilan a máklimus. Siya ay ti Bartimeo a anak ni Timeo. ");
INSERT INTO prfNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Dikona a masanig nen burák a en magtalib ay ti Jesus a taga-Nazaret, ay impákraw na, “Jesus, anak ni David, kagbiyanák mu pay!” ");
INSERT INTO prfNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Sinaway siya nen tolay hidi tánni umimang, peru lalu na pa a binegsákkan a impákraw, “Anak ni David, kagbiyanák mu pay!” ");
INSERT INTO prfNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Ummimang ti Jesus sakay kinagi na, “Dulawán moy siya háddi.” Dinulaw di en burák sakay kinagi di, “Magsaya ka! Padulaw ka ni Jesus. Nay, umágkat ka dán.” ");
INSERT INTO prfNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Inwatek nen burák en alikábkáb na sakay lummuksu a tummaknág, sakay ummadeni kánni Jesus. ");
INSERT INTO prfNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Tinanung siya ni Jesus, “Ánya gustu muwid a gamitán ku dikomu?” Kinagi nen burák, “Maistu, gustu ku a maketaák a ruway.” ");
INSERT INTO prfNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Kinagi ni Jesus, “Nagpiyya ka dán gapu ten pánnampalataya mu.” Ti odasid a iyud ay naketa dán siya a ruway, sakay ummunud kánni Jesus. ");
INSERT INTO prfNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Dikona adeni dán de Jesus ten siyudad a Jerusalem, sakay ten banuwan hidi a Betfage sakay Betania a ked ten bukid a Olibo, ay pinágdipalongu na en duwwa ten disepulus na hidi. ");
INSERT INTO prfNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Kinagi na dikodi, “Angay kam ti sumunuden a banuwan. Kássáddáp moy haud ay tehud kam a ketan a umáegut a bul-u a asno a awan palla nasakayan. Okbisán moy sakay iyangay moy háddi. ");
INSERT INTO prfNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ni tehud a magtanung dikomoy ni bakin okbisán moy ay kagiyán moy a kailangan nen Panginoon sakay isoli na la a pagdaka.” ");
INSERT INTO prfNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Kaya lummakad en duwwa a disepulus, sakay netan di ngani haud en bul-u a asno ten gilid nen dilan a umáegut ten pintuwan nen bilay. Dikona okbisán di ay ");
INSERT INTO prfNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","tinanung hidi nen tolay hidi a mágtaknág haud, “Bakin okbisán moy iyán?” ");
INSERT INTO prfNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","En tábbig di ay kona ten imbilin ni Jesus, kaya pinabayan dán hidi nen tolay hidi a lumakad. ");
INSERT INTO prfNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Inyangay di kánni Jesus en bul-u a asno, insapin di en alikábkáb di ten asno sakay summakay ti Jesus. ");
INSERT INTO prfNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Makpal a tolay en nánglatag ten alikábkáb di ten dilan, en agum bi ay nangkáttol ti maduun a pinget ni kayu sakay iyud en inlatag di ten dilan. ");
INSERT INTO prfNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Nadid en tolay hidi ten dipalongu ni Jesus sakay en umunonud hidi dikona ay magpákrawan hidi a magpuri, kinagi di, “Puriyán en Diyos! Pagpalaán en mágdadedemát ten ngaran nen Panginoon! ");
INSERT INTO prfNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Pagpalaán nakuwan en kahariyan nen ninunu tam a ti David a mágdadedemát dán. Puriyán en Diyos!” ");
INSERT INTO prfNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Summáddáp ti Jesus ti Jerusalem sakay ummangay siya ten Templo. Inileng na en atanan a bagay a ked haud, káttapos ay nagsoli siya ti Betania gapu mággibi-gibi dán, kaguman na en sapulu ay ti duwwa. ");
INSERT INTO prfNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Ten kailawan, dikona a magsoli hidi a gubwat ti Betania, ay nakabati ti Jesus ti aláp. ");
INSERT INTO prfNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Netan-awan na en kayu a igos a malagu. Inadeniyan na iyud tánni ilingán na ni tehud a bunga. Peru awan siya ti netan a bunga na, purus la a duun gapu awan na palla panahun. ");
INSERT INTO prfNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Kaya kinagi na ten kayu a igos, “Sapul nadid ay awan dán ti makaennam ten bunga mu.” Nasanig iyud nen disepulus na hidi dikona kinagi na. ");
INSERT INTO prfNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Káddemát de Jesus ti Jerusalem ay summáddáp siya ten Templo. Tinabug na en máglaku hidi, sakay en mamali hidi haud, sakay impágtumba na en lamisaan nen mágpalit hidi ti pilak sakay en bangku nen máglaku hidi ti kalapati. ");
INSERT INTO prfNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Awan pinagkon ni Jesus ten laguwerta nen Templo en tehud hidi a pangarga. ");
INSERT INTO prfNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Sakay tinolduwan na en tolay hidi, kinagi na, “Kona háddi en nakasulat, ‘En bilay ku ay ngaranan a bilay a págdasalan nen atanan a bansa.’ Peru ginamet moy a bilay nen mágtakaw hidi!” ");
INSERT INTO prfNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Nasanig iyud nen pinunu hidi nen padi hidi sakay nen tagapagtoldu hidi nen Kautusan. Sapul haud ay nagisip dán hidi ti paraan tánni mapabunu di ti Jesus. Peru manteng hidi dikona gapu makpal dán en humanga ten págtoldu na. ");
INSERT INTO prfNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Dikona gibi dán, ay lummakad dán de Jesus ti siyudadid a iyud. ");
INSERT INTO prfNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Ten kailawan, ay netan di ten dilan a nagmadi dán en kayu a igos a hanggan ten gamot na hidi. ");
INSERT INTO prfNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Naisip ni Pedro en nangyari ten kayu, kaya kinagi na kánni Jesus, “Maistu, ilingán mu en sinumpa mu a kayu a igos, natay dán!” ");
INSERT INTO prfNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Kinagi ni Jesus dikodi, “Maniwala kam ten Diyos. ");
INSERT INTO prfNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Tandaan moy iddi: ni manampalataya kam ten Diyos sakay awan kam magalangan, ay maari moy a kagiyán ti bukiden a, ‘Umibut ka haán, tumápduk ka ti digeten,’ ay mangyari. ");
INSERT INTO prfNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Kaya kagiyán ku dikomoy, a ányaman a bagay en agidán moy ten págdasal moy, ay maniwala kam a natanggap moy dán, ay matanggap moy ngani iyud. ");
INSERT INTO prfNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Ni magdasal kam ay patawadán moy pa en tehud kasalanan dikomoy tánni patawadán kam bi nen Ama moy a ked dilanget. ");
INSERT INTO prfNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Ni awan kam magpatawad ten nagkasala hidi dikomoy ay awan kam bi patawadán nen Ama moy a ked dilanget.” ");
INSERT INTO prfNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Dummemát dámman de Jesus ti Jerusalem. Dikona pasiyaan a maglakad ti Jesus ten Templo ay ummadeni dikona en pinunu hidi nen padi hidi, en tagapagtoldu hidi nen Kautusan sakay en pinunu hidi nen banuwan. ");
INSERT INTO prfNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Tinanung di ti Jesus, “Ánya karapatan muwid a maggamet ti bagayid a hidi iyád? Deya nangatáddid dikomu ti karapatanid a iyán?” ");
INSERT INTO prfNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Kinagi ni Jesus dikodi, “Tanungán takam pa. Ni matábbig moy i tanung kuwiday ay kagiyán ku dikomoy en ginubwatan nen karapatan ku a manggamet ti bagayid a hidi iyád. ");
INSERT INTO prfNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Nadid, deya i nangatáddid ti karapatan kánni Juan a magbinyag, en Diyos beman oni tolay?” ");
INSERT INTO prfNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Namággurunan di, “Mara ni kagiyán tam a gubwat iyud ten Diyos ay tanungán na kitam bi ni bakin awan kitam naniwala kánni Juan. ");
INSERT INTO prfNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Peru ni kagiyán tam bi a gubwat ten tolay, ay bakay ni ánya bi gamitánnid ni tolayen hidi dikotam.” Manteng hidi gapu tenggiyán nen tolay hidi ti Juan a essa a propeta. ");
INSERT INTO prfNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Kaya en tábbig di kánni Jesus ay, “Awan mi tukoy.” Kinagi ni Jesus dikodi, “Ni konahud, ay awan ku bi kagiyán dikomoy ni hádya i gubwatid nen karapatan ku a maggamet ti bagayid a hidi iyád.” ");
INSERT INTO prfNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Nadid, nagtoldu ti Jesus ten tolay hidi ten pamamag-itan ni talinhaga, kinagi na, “Tehud a essa tolay a nagmula ti ubas ten uma na. Pinakudal na en kaubasan na sakay nagpagamet ti págpáspássan ti ubas, sakay nagpagamet ti malangkaw a bilay a págbantayan. Káttapos ay inyentrega na ten katiwala na hidi en ubasan sakay ummangay siya ti iba a lugar. ");
INSERT INTO prfNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Dikona panahun dán nen sákburas ay inutusan na en essa na a alipin tánni paangay na en kabunong na a ubas ten katiwala na hidi. ");
INSERT INTO prfNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Peru binálbág nen katiwala hidi en alipin, sakay pinauli di a awan ti tawid. ");
INSERT INTO prfNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Nangutus a ruway ti iba a alipin en makákkao ten kaubasan. Peru pinakol di sakay ináinsultu di. ");
INSERT INTO prfNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Nangutus dámman en makákkao ti essa pa a alipin peru binunu di. Kona bi hud i ginamet diyid ten makpal pa, tehud hidi a binálbág sakay tehud hidi a binunu. ");
INSERT INTO prfNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Nadid ay eessa dálla en naburay a maari a utusan nen makákkao ten kaubasan, en mahal na a anak. Kaya inutusan na siya gapu inisip na a, ‘Igalang di i anak kuwiday.’ ");
INSERT INTO prfNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Peru namágguron en katiwala hidi dikona ketan di en anak nen makákkao, kinagi di, ‘Iyán i magmanaid, bunuwán tamon siya tánni makao tam en manaán na.’ ");
INSERT INTO prfNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Kaya dinuklos di siya sakay tulos di a binunu. Káttapos ay imbut di en bangkay na ten luwas nen kaubasan.” ");
INSERT INTO prfNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Intanung ni Jesus, “Ánya wád i gamitánnid nen makákkao ten kaubasan? En gamitán na ay angay siya ten uma na sakay bunuwán na en katiwala na hidi. Káttapos ay iyentrega na en kaubasan ti agum a tolay. ");
INSERT INTO prfNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Awan beman nabasa moy dán en nakasulat ten Kasulatan a, ‘En batu a inadiyan nen mággamet hidi ti bilay ay siya en nagin pinakamahalaga ten atanan. ");
INSERT INTO prfNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Iyád ay ginamet nen Panginoon, a makasaya a áelingán!’ ” ");
INSERT INTO prfNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Dikona nasanig nen pinunu hidi nen Judio hidi en kinagi ni Jesus ay gustu di siya a dikáppán gapu nahalata di a hidi en patamakan na ten talinhaga. Peru awan di magamet gapu manteng hidi ten tolay hidi kaya lummakad dálla hidi. ");
INSERT INTO prfNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","En sangan a Pariseo sakay en sangan bi ten tolay hidi ni Hari a Herodes ay nautusan a umangay kánni Jesus tánni urayán di siya a maliwat ten pággupos na. ");
INSERT INTO prfNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Kaya ummadeni hidi kánni Jesus sakay kinagi di, “Maistu, tukoy mi a tapat ka sakay awan ka ti panigan, pantay i pángngileng muwid ten atanan a tolay. En itáttoldu mu ay tungkul ten tatarudan a kagustuwan nen Diyos para ten tolay. Gustu mi nakuwan a itanung ni labag beman ten Kautusan tam a magbayad kami ti buwes ten Emperador ti Roma oni awan?” ");
INSERT INTO prfNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Tukoy ni Jesus a magkukunwari la hidi kaya kinagi na dikodi, “Bakin páppurbaanák moy? Átdenanák moy ti pilak a denaryo.” ");
INSERT INTO prfNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Inátdenan di ngani siya ti pilak. Káttapos ay tinanung hidi ni Jesus, “Kándeya a rupa sakay ngaran en nakatatak háddi?” Kinagi di, “Kao nen Emperador.” ");
INSERT INTO prfNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Kinagi ni Jesus, “Iyatád moy ten Emperador en kao nen Emperador, sakay iyatád moy ten Diyos en kao nen Diyos.” Minagtaka hidi ti hustu ten tábbig na. ");
INSERT INTO prfNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Nadid, tehud a sangan a Saduseo a ummadeni kánni Jesus tánni magtanung. Maniwala hidi a awan dán mabiyag a ruway en patay. ");
INSERT INTO prfNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Kinagi di, “Maistu, tehud a insulat ti Moises a kautusan a para dikotam. Ni matay kan en lállaki a awan hidi ti anak ay ten kabinga na ay en wadi nen lállaki i dapatid a mangkabinga ten bilu, tánni magkahud hidi ti anak para ten kaka na a natay. ");
INSERT INTO prfNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Tehud a pittu a matátkaka a lállaki. Nákkabinga en kaka peru natay a awan ti anak. ");
INSERT INTO prfNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Kinabinga nen kaduwwa en bilu. Peru natay bi siya a awan ti anak. Kona bi hud en nangyari ten kattállu. ");
INSERT INTO prfNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Nakabinga nen bábbi en pittu a lállaki a matátkaka peru natay hidi a atanan a awan ti anak. Sakay ten dimudyan ay natay bi en bábbi. ");
INSERT INTO prfNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Nadid, ta nakabinga na hidi a atanan, deya i tenggiyán naid a kabinga na, káddemát ten kákkabiyag a ruway?” ");
INSERT INTO prfNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Kinagi ni Jesus dikodi, “Liwat a tarud i pánniwala moyen, gapu awan moy maintendiyan en itáttoldu nen Kasulatan sakay en kapangyariyan nen Diyos. ");
INSERT INTO prfNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Ten kákkabiyag a ruway ay awan dán ti kabingaan; kaparehu dán hidi nen anghel hidi dilanget. ");
INSERT INTO prfNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Ni tungkul ten kákkabiyag a ruway, awan moy beman nabasa ten libru ni Moises en kinagi nen Diyos dikona, ten pangyayari ten maggerab a marenggád a kayu? Kinagi nen Diyos kánni Moises, ‘Sikán en Diyos ni Abraham, Isaac, sakay Jacob.’ ");
INSERT INTO prfNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","En Diyos ay bakán a Diyos nen patay hidi nan Diyos nen biyag hidi. Kaya talaga a liwat kam a tarud!” ");
INSERT INTO prfNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Nasanig nen essa a tagapagtoldu nen Kautusan en pamagtalunan di. Netan na a mahusay en káttábbig ni Jesus ten Saduseo hidi kaya ummadeni siya sakay nagtanung, “Ánya en pinakamahalaga a utus ten atanan?” ");
INSERT INTO prfNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Kinagi ni Jesus, “Iddi en purumeru a utus a pinakamahalaga: ‘Sanigán mu Israel! En Panginoon tam a Diyos ay mággeessa la a Panginoon, awan dán ti agum. ");
INSERT INTO prfNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Mahalán mu en Panginoon mu a Diyos ti buu a pusu, buu a kaluluwa, buu a isip sakay buu a begsák.’ ");
INSERT INTO prfNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Iddi en kaduwwa a utus, ‘Mahalán mu en kaparehu mu a tolay a kona ten págmahal mu ten sadili mu. Awan dán ti agum a utus a manghigit pa ti duwwaid a iyád.” ");
INSERT INTO prfNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Kinagi nen tagapagtoldu nen Kautusan, “Tarud iyán Maistu! Tama en kinagi mu a essa la en Diyos, awan dán ti agum. ");
INSERT INTO prfNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Sakay kailangan a mahalán siya ti buu a pusu, buu a isip sakay buu a begsák, sakay dapat a mahalán en kaparehu a tolay a kona ten págmahal ten sadili. Mas mahalaga hidi iyád nan ni máng-alay ti bagay hidi a tutudán sakay ten iba pa hidi a alay.” ");
INSERT INTO prfNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Netan ni Jesus a mahusay en káttábbig na kaya kinagi na dikona, “Adeni ka dán ten kahariyan nen Diyos.” Sapul haud ay awan dán ti nangahas a magtanung kánni Jesus. ");
INSERT INTO prfNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Mentras a magtoldu ti Jesus ten Templo ay kinagi na, “Bakin a kinagi nen tagapagtoldu hidi nen Kautusan a en Cristo ay maggubwat ten lahi ni David? ");
INSERT INTO prfNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Awan beman dikona inggiyya nen Banal a Ispiritu ti David ay kona háddi en kinagi na: “Kinagi nen Panginoon ten Panginoon ku, ‘Mággetnud ka ti kawanan kuwiday, mentras awan ku mapasuku dikomu en atanan nen kadima mu hidi.’ ” ");
INSERT INTO prfNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Ti David dán en nangdulaw dikona a Panginoon; konya a en Cristo ay maggubwat ten lahi ni David?” Makpal a tolay en masaya a mágsanig dikona. ");
INSERT INTO prfNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Sakay kinagi pa ni Jesus ten págtoldu na, “Mangilag kam ten tagapagtoldu hidi nen Kautusan, gugustu di a maglakad ten matolay a lugar a susulot di en badu di a malayon sakay kasayaan di a igalang hidi nen katolayan. ");
INSERT INTO prfNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Gugustu di en bangku hidi a para ten mágkataas ni ked hidi ten sinagoga sakay en bangku hidi a para ten marangal ten handaan hidi. ");
INSERT INTO prfNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Áubusán di en ari-ariyan nen bilu hidi a bábbi sakay en áttakdug di hidi a dasal ay wari-wari la. Kaya tunay ti dággi i magin parusa diyid.” ");
INSERT INTO prfNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Nadid, nággetnud ti Jesus ten adeni nen págdáttonan ti kaluub ten Templo. Áelingán na en tolay hidi a magdátton ten kaluub di. Netan na a makpal a pilak en idátton nen mágkayaman hidi. ");
INSERT INTO prfNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Sakay netan na bi en pubri a bilu a bábbi a nángdátton ten kaluub na a duwwa a sentabos. ");
INSERT INTO prfNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","44","Dinulaw ni Jesus en disepulus na hidi sakay kinagi na dikodi, “Tatarudan i kagiyán kuwidi dikomoy, en ingkaluub nen pubri a bilu ay mas makpal, gapu en agum ay nangatád la ten bahagi nen kayamanan di. Peru siya a pubri a bilu maski ni mahirap siya ay inyobus na a inyatád en kasiya-siya a kabiyagan na.” ");
INSERT INTO prfNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Dikona paluwas ti Jesus ten Templo ay kinagi nen essa ten disepulus na hidi, “Maistu, ilingán mu i dáddekállen hidi a bilay, sakay i mágkagandaen hidi a batu a ginamit di!” ");
INSERT INTO prfNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Kinagi ni Jesus, “I áelingán muwen a dáddekál a bilay ay marábba iyán a atanan, awan ka haán ti ketan a batu a tumáttopu ten kaparehu na a batu. Atanan ay makuray-kuray!” ");
INSERT INTO prfNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Nadid, dikona mággetnud ti Jesus ten Bukid nen Olibo a táttan-awán na en Templo ay palihim a tinanung siya de Pedro, Santiago, Juan sakay ti Andres. ");
INSERT INTO prfNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Kinagi di, “Kagiyán mu pay dikomi, nikan a mangyari i bagayid a hidi iyád, sakay ánya tandaid a pakatukuyan mi ni adeni dán a mangyari atananid iyád?” ");
INSERT INTO prfNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Kinagi ni Jesus dikodi, “Mangilag kam tánni awan kam maloku nen deyaman. ");
INSERT INTO prfNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Makpal a dumemát a magkagi a hidi en Cristo, sakay itawtaw di en makpal a tolay. ");
INSERT INTO prfNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Dyan kam la mabalisa ni makasanig kam ti gera a adeni dikomoy oni bareta tungkul ti gera ten adeyu a lugar. Dapat a mangyari hidi iyád, peru bakán palla iyád a en katapusan. ");
INSERT INTO prfNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Magkahud pa ti kontraan sakay labanan en bansa ti iba a bansa sakay en kahariyan ten kaparehu na a kahariyan. Maglinug ten iba-iba a lugar, sakay magkahud ti aláp. Iyád a atanan ay sapul palla ni pághirap. Kona iyád ten karanasan nen essa a bábbi a magenak. ");
INSERT INTO prfNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Humanda kam gapu dikáppán di kam sakay tulos di kam a bistaán ten Sanedrin. Ni ked kam ten sinagoga ay bálbággán di kam, sakay iyangay di kam ten mágkataas hidi a pinunu nen banuwan gapu ten kássunud moy dikoku tánni mebahagi moy en Maganda a Bareta. ");
INSERT INTO prfNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Kailangan a mepangaral pa en Maganda a Bareta ten atanan a bansa bagu a dumemát en katapusan. ");
INSERT INTO prfNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Ni dikáppán di kam sakay bistaán ay dyan kam mabalisa ni ánya i kagiyán moyid. Ti odasid a iyud ay kagiyán moy la en dapat moy a kagiyán, gapu bakán a sikam en magupos; en kagiyán moy ay maggubwat ten Banal a Ispiritu. ");
INSERT INTO prfNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Káddemát ni panahunid a iyud ay itokyon nen tolay en kapatkaka na a pabunu. Kona labi hud i gamitánnid nen ama ten anak na. Labanan nen anak en dáddikál na sakay pabunu na. ");
INSERT INTO prfNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Kaiyamutan di kam a atanan gapu ten kássunud moy dikoku. Peru en manatili a tapat a hanggan ten katapusan ay maligtas.” ");
INSERT INTO prfNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Nadid, kinagi pa ni Jesus, “Kailangan a intendiyán iddi nen mágbasa: Ni ketan moy dán en tunay ti dukás a gamet a awan ti kaparehu a ked ten lugar a awan na dapat a págyanan, ay en ked hidi ti Judea ay guminan dán ten buki-bukid. ");
INSERT INTO prfNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","En pagabutan a ked ten atáp ay dyan dán magabala a umugsad sakay sumáddáp a mangalap ti ányaman haán. ");
INSERT INTO prfNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Pati en ked hidi ten uma di ay dyan dán umuli a mángngay ti pagalikábkáb na. ");
INSERT INTO prfNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Kakakagbi en bábbi hidi a mabuktet sakay magpasusu ti aldewid a hidi iyud. ");
INSERT INTO prfNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Idasal moy a dyan nakuwan mangyari hidi iyád a bagay ni sákdágnen, ");
INSERT INTO prfNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","gapu magdanas ti matindi a hirap en tolay hidi ti panahunid a iyud. Iyud a hirap ay awan palla naranasan sapul dikona lalangán nen Diyos i munduwiday, sakay awan dán maranasan a ruway maski nikan. ");
INSERT INTO prfNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Ni awan paaperetán nen Diyos i panahunid a iyud ay awan ti deyaman a maligtas. Peru pinaaperet na iyud alang-alang ten pinili na hidi. ");
INSERT INTO prfNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Ni tehud a magkagi dikomoy a, ‘Ked háddi en Cristo!’ oni kagiyán di a, ‘Ked siya hudi!’ ay dyan kam maniwala. ");
INSERT INTO prfNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Gapu tehud a magkukunwari a Cristo sakay tehud bi a magkukunwari a propeta. Mángpeta bi hidi ti himala sakay makataka-taka hidi a bagay tánni maari la, ay itawtaw di en pinili hidi nen Diyos. ");
INSERT INTO prfNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Kaya mangilag kam. Indipalongu ku dán a kagiyán dikomoy en atanan a bagay bagu a mangyari.” ");
INSERT INTO prfNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Ti panahunid a iyud, kállipas ni pághirapid a iyud, ay dumiklám en aldew sakay awan dán dumemlag en bulan. ");
INSERT INTO prfNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","En biton hidi dilanget ay mágkaragrag, sakay magkagulu en atanan a kapangyariyan ten kalawakan. ");
INSERT INTO prfNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Káttapos ay ketan en Anak nen Tolay a dumemát a ked ten panganurin, a tehud a dakila a kapangyariyan sakay karangalan. ");
INSERT INTO prfNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Utusan na en anghel na hidi ten áppat a suluk ni munduwiday tánni pisanán di en pinili hidi nen Diyos ten atanan a lugar.” ");
INSERT INTO prfNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Intendiyán moy en adal a gubwat ten kayu a igos; ni manariwa dán en pinget na sakay ni magduun dán, ay iyud en tanda a adeni dán en kássinag. ");
INSERT INTO prfNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Kona labi hud, ni ketan moy a mangyari dán hidi iyád a bagay ay matukoyan moy a adeni dán en káddemát na; dumáddadedemát dán siya. ");
INSERT INTO prfNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Tandaan moy: mangyari atananid a iyád a bagay bagu a matay en tolay hidi a biyag nadid. ");
INSERT INTO prfNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Lumipas en langet sakay en luta, peru en upos ku ay manatili a awan ti katapusan.” ");
INSERT INTO prfNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Peru awan ti makatukoy ten aldew ay ten odas, maski en anghel hidi dilanget, oni en Anak man. En Ama la i makatukoyid haád. ");
INSERT INTO prfNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Magingat kam sakay humanda gapu awan moy tukoy ni nikan iyád a mangyari. ");
INSERT INTO prfNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Kona iyád ten essa a tolay a magbiyahi ti adeyu. Inwarak na en bilay na ten utusan na hidi sakay inátdenan na en balang essa ti tarabahu di. Sakay binilin na en tagabantay a magbantay ti mapiyya. ");
INSERT INTO prfNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Kona labi hud, magbantay kam ti mapiyya gapu awan moy tukoy ni nikan i soliyid nen makábbilay. Maari a ten págdiklám, ten hatinggabi, ten kaldiwan, oni dimadimang dán. ");
INSERT INTO prfNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Bakay bigla siya a dumemát sakay mademáttan na kam a tidug. ");
INSERT INTO prfNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Kagiyán kuwiday dikomoy ay kagiyán ku ten atanan. Maghanda kam!” ");
INSERT INTO prfNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Duwwa dálla a aldew ay Piyesta dán nen Aldew nen Págtalib sakay piyesta bi nen Tinapay a awan ti Págpaalsa. En pinunu hidi nen padi hidi sakay en tagapagtoldu hidi nen Kautusan ay nágguronan di ni konya di a mapadikáp ti Jesus ti lihim sakay pabunu di. ");
INSERT INTO prfNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Kinagi di, “Dyan tam siya dikáppán ni piyesta palla bakay magkagulu i katolayanen.” ");
INSERT INTO prfNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Ked ti Jesus ti Betania tenhud, ten bilay ni Simon a dati a kinetong. Mentras a kuman ti Jesus ay dummemát en essa a bábbi a tehud a tawid a alabastro a putat ti tunay ti kamahalan a págpasárrub, gubwat iyud ten tábbug nen mula a nardo. Binássag na en boti sakay imbulak na ten ulu ni Jesus en págpasárrub. ");
INSERT INTO prfNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Nagsaranta en agum a tolay a ked haud sakay kinagi di ten balang essa, “Bakin sinayang na en págpasárrub? ");
INSERT INTO prfNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Melaku nakuwan iyud ti halaga ni sataon a suweldu sakay en naglakuwan ay iyatád ten pubri hidi.” Kaya sinisi di en bábbi. ");
INSERT INTO prfNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Peru kinagi ni Jesus, “Bakin guluwán moy siya? Pabayan moy la siya. Maganda i ginamet naen dikoku. ");
INSERT INTO prfNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Gapu pirmi moy la a kaguman en pubri hidi kaya maski ánya a odas ay maari moy la hidi a matulungan. Peru sikán, ay awanák moy pirmi a kaguman. ");
INSERT INTO prfNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ginamet na la en kaya na a gamitán. Maski ni awan palla nangyari ay binulakan na dán ti págpasárrub i bággi kuwiday bilang pághanda ten káddemát nen páglábbáng dikoku. ");
INSERT INTO prfNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Tandaan moy, maski hádya ti munduwiday a mepangaral en Maganda a Bareta ay mabanggit bi en ginamet na bilang ala-ala dikona.” ");
INSERT INTO prfNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Nadid, ti Judas Iscariote a essa ten sapulu ay ti duwwa a disepulus ni Jesus ay ummangay ten pinunu hidi nen padi hidi tánni itokyon na ti Jesus. ");
INSERT INTO prfNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Minasaya hidi ten kinagi ni Judas sakay impangaku di a átdenan di siya ti pilak. Sapul haud ay naguray dán ti Judas ti pagkakataun a metokyon na ti Jesus. ");
INSERT INTO prfNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Ten purumeru a aldew nen piyesta nen Tinapay a awan ti Págpaalsa ay aldew nen págbunu di ti tupa para ten Piyesta nen Aldew nen Págtalib. Tinanung nen disepulus hidi ti Jesus, “Hádya gustu muwid a pánghandaan mi ti pangapon tam para ten piyesta nen Aldew nen Págtalib?” ");
INSERT INTO prfNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Inutusan na en duwwa a disepulus na, kinagi na, “Angay kam dibanuwan, káddemát moy haud ay matagbu moy en lállaki, a tehud a báklay a binga a tehud a dinom. Unudán moy siya ");
INSERT INTO prfNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","hanggan ten bilay a sáddáppan na. Sakay kagiyán moy ten makábbilay a, ‘Petanung ben nen Maistu ni hádya kan i kuwartuwid a maari a pangapunan na sakay nen disepulus na hidi, para ten Piyesta nen Aldew nen Págtalib.’ ");
INSERT INTO prfNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Káttapos ay ipeta na dikomoy en dikál a kuwartu ten disunu nen bilay. Nakahanda dán iyud kaya ihanda moy dán haud en pangapon tam.” ");
INSERT INTO prfNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Summunud en disepulus na hidi, ummangay hidi ten banuwan sakay netan di en atanan a bagay a kinagi ni Jesus. Sakay inhanda di en pangapon di para ten piyesta nen Aldew nen Káimang. ");
INSERT INTO prfNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Dikona gibi dán, ay dummemát ti Jesus kaguman na en sapulu ay ti duwwa a disepulus na. ");
INSERT INTO prfNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Dikona pasiyaan hidi a kuman ay kinagi ni Jesus, “Kagiyán ku dikomoy: en essa dikomoy háddi a katubeng ku a kuman ay mángtokyon dikoku.” ");
INSERT INTO prfNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Nagsapul dán a nagin malungkut en disepulus na hidi sakay balang essa ay nagtanung dikona, “Sikán beman Panginoon?” ");
INSERT INTO prfNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Kinagi ni Jesus dikodi, “Essa dikomoy a sapulu ay ti duwwa a kasabay ku a magsawsaw ti tinapay ti malukungiday. ");
INSERT INTO prfNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","En Anak nen Tolay ay matay ayun ten nakasulat a tungkul dikona. Peru kakakagbi en tolay a mángtokyon dikona. Mas mapiyya pa ni awan dálla siya neenak.” ");
INSERT INTO prfNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Dikona pasiyaan hidi a kuman ay nangalap ti Jesus ti tinapay sakay nagpasalamat ten Diyos. Káttapos ay tináppeng-táppeng na en tinapay sakay inyatád na ten disepulus na hidi. Kinagi na, “Alapán moy iddi; iyád en bággi ku.” ");
INSERT INTO prfNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Nangalap bi siya ti tasa sakay káttapos na a magpasalamat ten Diyos ay intoyag na ten disepulus na hidi, sakay umminom hidi a atanan. ");
INSERT INTO prfNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Kinagi ni Jesus, “Iyád en digi ku a mangpatibay ten pangaku nen Diyos, en digi a mebuhus para ten makpal. ");
INSERT INTO prfNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Tandaan moy: awanák dán uminom a ruway ti alak a gubwat ti tábbug ni ubas hanggan ten aldew a inumán ku en bigu a alak ten kahariyan nen Diyos.” ");
INSERT INTO prfNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Káttapos ay nágkansiyon hidi ti papuri ten Diyos sakay ummangay hidi ten Bukid nen Olibo. ");
INSERT INTO prfNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Nadid, kinagi ni Jesus dikodi, “Lakadanák moy a atanan, gapu nakasulat ten kasulatan a, ‘Bunuwán ku en pastol sakay mangalat en tupa hidi.’ ");
INSERT INTO prfNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Peru kákkabiyag ku a ruway ay mágdipalonguwák dikomoy a angay ti Galilea.” ");
INSERT INTO prfNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Kinagi ni Pedro, “Awan taka lakadan, maski lumakad hidi a atanan.” ");
INSERT INTO prfNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Kinagi ni Jesus dikona, “Tandaan mu, bagu a magtarakket ti pumenduwwa en manok nadid a gibi ay pentálluwák mu a ipamen.” ");
INSERT INTO prfNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Peru impilit la a kinagi ni Pedro, “Maski ni bunuwánnák di a kaguman mu, ay awan taka ipamipamen.” Kona bi hud en kinagi nen kaguman na hidi a disepulus. ");
INSERT INTO prfNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Ummangay hidi ten essa a lugar a Getsemani en ngaran na. Káddemát di haud ay kinagi ni Jesus ten disepulus na hidi, “Mággetnud kam pala háddi ta angayák magdasal.” ");
INSERT INTO prfNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Sakay ingkuyug na de Pedro, Santiago, sakay ti Juan. Nadid, nagsapul siya a mabalisa sakay maghirap en isip na. ");
INSERT INTO prfNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Kinagi na dikodi, “Tunay dán i lungkut ni pusu kuwiday a ngari-ngari ku dán a ikatay! Maguray kam háddi sakay magbantay.” ");
INSERT INTO prfNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Ummadeyu siya ti sabadit, sakay lummuhud ten luta a nagdasal a ni maari ay awan dán dumemát en odas nen pághirap na. ");
INSERT INTO prfNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Indasal na a, “Ama, Ama ku, tukoy ku a magamet mu en atanan a bagay. Dyanák mu pabayan a maghirap. Peru bakán a en kagustuwan ku i masunudid nan en kagustuwan mu.” ");
INSERT INTO prfNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Káttapos ay nagsoli siya ten tállu a disepulus na. Nademáttan na hidi a tidug kaya kinagi na kánni Pedro, “Simon, tidug ka? Awan ka beman makapagbantay maski ni sang-odas la? ");
INSERT INTO prfNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Magbantay kam sakay magdasal tánni awan kam madaig nen toksu. Nakahanda en ispiritu peru mahina en bággi.” ");
INSERT INTO prfNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Ummadeyu dámman ti Jesus para magdasal, rinuway na en kona ten purumeru a indasal na. ");
INSERT INTO prfNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Sakay nagsoli siya a ruway ten disepulus na hidi. Nedemáttan na dámman hidi a tidug gapu tunay en tongka di. Awan di tukoy ni ánya kagiyán diyid dikona. ");
INSERT INTO prfNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Ten kapentállu a kássoli ni Jesus ay kinagi na dikodi, “Tidug kam palla beman sakay umimang? Tama dán iyán, dummemát dán en odas a meatád en Anak nen Tolay ten makasalanan hidi. ");
INSERT INTO prfNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Umikat kamon, kadtamon! Keddán en tolay a mángtokyon dikoku.” ");
INSERT INTO prfNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Pasiyaan palla a magupos ti Jesus dikona dummemát ti Judas a essa ten sapulu ay ti duwwa. Kaguman na en makpal a tolay a tehud a manga-áttak sakay garoti. Inutusan hidi nen pinunu hidi nen padi hidi, nen tagapagtoldu hidi nen Kautusan sakay nen pinunu hidi nen banuwan. ");
INSERT INTO prfNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Bagu hidi a dinumemát ay kinagi dán ni Judas en palatandaan ten tolay hidi, kinagi na, “Ni deya en ámmuwan ku ay siya en dikáppán moy peru bantayan moy ti mahusay.” ");
INSERT INTO prfNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Káddemát ni Judas ay ummadeni siya a pagdaka kánni Jesus, sakay kinagi na, “Maistu,” káttapos ay inámmuwan na siya. ");
INSERT INTO prfNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Kaya ten pákketa nen tolay hidi kánni Jesus ay binalud di siya sakay dinikáp. ");
INSERT INTO prfNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Peru en essa ten disepulus na hidi ay binumagut ten áttak na sakay tinigpas na en alipin nen kapunuwan nen padi hidi, kaya naripas en bángbáng na. ");
INSERT INTO prfNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Kinagi ni Jesus ten tolay hidi, “Bakin dikáppánnák moy a kumán a mágbabonu? Tehud kam pa a manga tawid a áttak sakay garoti? ");
INSERT INTO prfNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Kada-aldew ay kedák ten Templo a magtoldu, peru awanák moy dinikáp. Peru kailangan a mangyari en nakasulat ten Kasulatan!” ");
INSERT INTO prfNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Ginuminan en atanan nen disepulus hidi, inwarak di ti Jesus. ");
INSERT INTO prfNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Ummunud kánni Jesus en essa a binata a nakabadu la ti lino. Hinagad siya nen katolayan, ");
INSERT INTO prfNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","peru gumminan siya sakay newarak na en badu na a lino, kaya eklas siya a nággaginanán. ");
INSERT INTO prfNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Inyangay di ti Jesus ten bilay nen kapunuwan nen padi hidi. Napisan haud en pinunu hidi nen padi hidi, en pinunu hidi nen banuwan, sakay en tagapagtoldu hidi nen Kautusan. ");
INSERT INTO prfNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Ummunud ti Pedro kánni Jesus peru adeyu la en distansiya na. Nagtulos siya ten laguwerta nen bilay nen kapunuwan nen padi hidi, sakay nákpággetnud siya ten magbantay hidi a magindu ten apoy. ");
INSERT INTO prfNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Nadid, en pinunu hidi nen padi hidi, sakay en buu a Sanedrin ay magaryok hidi ti ibintang di kánni Jesus, tánni tehud hidi a dahilan a mangpabunu dikona. Peru awan hidi ti ketan a patunay. ");
INSERT INTO prfNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Makpal a nagpatunay a nagkagi ti kakabuliyan kontra kánni Jesus peru awan bi magkaparehu en kinákkági di. ");
INSERT INTO prfNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Tehud a sangan a nagpatunay a nagkagi ti kona háddi a kakabuliyan kontra kánni Jesus, ");
INSERT INTO prfNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Nasanig mi a kinagi na a, ‘Rábbaán ku en Templo a ginamet ni tolay. Sakay ten luub nen tállu a aldew ay maggamiták ti bigu a templo a awan magamet ni tolay.’ ” ");
INSERT INTO prfNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Peru awan padi nagkaparehu en kinákkagi di. ");
INSERT INTO prfNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Tummaknág en kapunuwan nen padi hidi ten atubengán di sakay tinanung na ti Jesus, “Ánya makagi muwid ten kinákkagi di a kontra dikomu?” ");
INSERT INTO prfNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Peru awan ti kákkagi ti Jesus, awan siya tummábbig. Kaya tinanung siya a ruway nen kapunuwan nen padi hidi, “Siko beman en Cristo, a Anak nen Mapagpala a Diyos?” ");
INSERT INTO prfNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Tummábbig ti Jesus, “Sikán ngani. Ketan moy en Anak nen Tolay a mággetnud ten kawanan nen Makapangyariyan ten atanan. Ketan moy bi siya a dumemát a ked ten panganurin dilanget.” ");
INSERT INTO prfNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Pinisad nen kapunuwan nen padi hidi en badu na sakay kinagi na, “Awan tamon kailangan i tistiguwid! ");
INSERT INTO prfNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Nasanig moy en kinagi na a siya ay Diyos! Ánya nadid i gustu moyid a gamitán tam dikona?” Kinagi di a atanan a kailangan a bunuwán siya. ");
INSERT INTO prfNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Sakay sinapulan di dán siya a pahirapan; linoktaban siya nen agum, pinángngássan di sakay sinássuntuk. Pinatukoy di pa ni deya i nangsuntukid dikona, sakay binulbug siya nen mágbantay hidi. ");
INSERT INTO prfNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Nadid, ti Pedro ay ked ten laguwerta dikona dummemát en essa a alipin a bábbi nen kapunuwan nen padi hidi. ");
INSERT INTO prfNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Netan na ti Pedro a magindu ten apoy kaya minalas na siya ti hustu sakay tinanung na, “Awan beman kaguman ka ni Jesus a taga-Nazaret?” ");
INSERT INTO prfNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Peru impamen ni Pedro, kinagi na, “Awanák ti tukoy sakay awan ku maintendiyan i kákkagi-kagiyán muwen.” Lummakad siya sakay ummangay ten lakdangan sakay nagtarakket en manok. ");
INSERT INTO prfNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Netan dámman siya nen bábbi a alipin sakay kinagi na ten tolay hidi a ked haud, “Essa siya ten kákkagumanán hidi ni Jesus!” ");
INSERT INTO prfNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Peru impamen dámman ni Pedro. Kállipas nen sangan a minutu ay kinagi dámman nen tolay hidi a ked haud kánni Pedro, “Dyan mu dán ipamen a essa ka dikodi, taga-Galilea ka awan beman?” ");
INSERT INTO prfNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Kinagi ni Pedro, “Isumpa ku, maski matayák awan ku matenggi i tolayid a iyán!” ");
INSERT INTO prfNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Hustu bi a káttarakket a ruway nen manok. Naala-ala ni Pedro en kinagi ni Jesus dikona a pentállu na siya a ipamen bagu a magtarakket en manok ti pumenduwwa. Kaya nágsasangitán siya ti hustu. ");
INSERT INTO prfNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Ten kailawan ay pagdaka a nagipun-ipun en pinunu hidi nen padi hidi, en pinunu hidi nen banuwan, en tagapagtoldu hidi nen Kautusan sakay en agum a kaguman ten Sanedrin. Pinapungu di ti Jesus sakay inyangay di kánni Pilato. ");
INSERT INTO prfNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Káddemát di haud ay tinanung ni Pilato ti Jesus, “Siko beman en Hari nen Judio hidi?” Tummábbig ti Jesus, “Siko dán i nagkagiyid.” ");
INSERT INTO prfNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Makpal a imbábbintang en pinunu hidi nen padi hidi kánni Jesus. ");
INSERT INTO prfNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Kaya tinanung siya a ruway ni Pilato, “Bakin awan ka tumábbig? Nasanig mu en kakpal nen ibábbintang di dikomu.” ");
INSERT INTO prfNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Peru awan padi tumatábbig ti Jesus, kaya nagtaka a tarud ti Pilato. ");
INSERT INTO prfNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Nadid, kada Piyesta nen Aldew nen Págtalib ay mangpalaya ti Pilato ti essa a piresu. Ni deya en piliyán nen tolay hidi ay siya i palayaán naid. ");
INSERT INTO prfNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Ti panahunid a iyud ay tehud a pumáppiresu a Barrabas en ngaran na. Kaguman siya ten ribeldi hidi sakay nakabunu siya dikona tehud a kaguluwan. ");
INSERT INTO prfNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Namagkaessa en katolayan a ummangay kánni Pilato tánni ikagi di dikona a gamitán na dámman en dati na a gággamitán. ");
INSERT INTO prfNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Tinanung hidi ni Pilato, “Gustu moy beman a palayaán ku en Hari nen Judio hidi?” ");
INSERT INTO prfNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Kinagi na iyud gapu tukoy ni Pilato a sumeni la en pinunu hidi nen padi hidi kaya inreklamu di ti Jesus. ");
INSERT INTO prfNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Peru sinássulsulan nen pinunu hidi nen padi hidi en tolay hidi a ti Barrabas i kagiyán diyid a palayaán na. ");
INSERT INTO prfNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Kaya tinanung hidi a ruway ni Pilato, “Ánya i gustu moyid a gamitán ku ti tolayiday a dáddulawán moy a Hari nen Judio hidi?” ");
INSERT INTO prfNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Impákraw nen tolay hidi, “Ipaku siya ten kudus!” ");
INSERT INTO prfNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Tinanung dammán hidi ni Pilato, “Bakin, ánya beman i kasalanan naid?” Peru lalu di pa a impákraw a, “Ipaku siya ten kudus!” ");
INSERT INTO prfNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Gustu ni Pilato a pagustuwan en tolay hidi, kaya pinaluwas na ten págpiresuwan ti Barrabas sakay pinahaplit na ti Jesus, káttapos ay inyatád na dikodi para ipaku di ten kudus. ");
INSERT INTO prfNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Nadid, inyangay nen sundalu hidi ti Jesus ten laguwerta nen palasyu nen gubernador sakay pinaipun di haud en agum hidi a sundalu. ");
INSERT INTO prfNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Sinulutan di ti Jesus ti inubi a malayon a alikábkáb. Nangalap hidi ti masaet a lanot sakay ginamet di a kurona sakay insulot di ten ulu na. ");
INSERT INTO prfNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Sakay sinesti di siya a sinaluduwan kinagi di, “Mabuhay en Hari nen Judio hidi!” ");
INSERT INTO prfNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Pináppakol di siya, linálloktaban sakay sinesti di a linuhudan. ");
INSERT INTO prfNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Káttapos di siya a sinesti ay ineklas di en inubi a malayon a alikábkáb sakay insulot di en sadili na a badu, sakay inluwas di siya ta ipaku di dán ten kudus. ");
INSERT INTO prfNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Nadid, natagbu di ten dilan ti Simon a gubwat ten uma na, taga-Cirene siya a ama de Alejandro ay ti Rufo. Impilit di a pinabáklay dikona en kudus ni Jesus. ");
INSERT INTO prfNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Inyangay di ti Jesus ten lugar a nginaranan di a Golgota, gustu naid a kagiyán ay “Lugar ni bungu.” ");
INSERT INTO prfNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Sakay inátdenan di siya ti alak a tehud a halu a mira, peru awan na ininom. ");
INSERT INTO prfNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Impaku di siya ten kudus sakay pinaghati-hatiyan di en badu na ten pamamag-itan ni bunutan. ");
INSERT INTO prfNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Alas nuwebi ten dimadimang dikona impaku di siya ten kudus. ");
INSERT INTO prfNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Nesulat ten disunu nen kudus en nangakusaan di dikona, “En Hari nen Judio hidi.” ");
INSERT INTO prfNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Tehud bi hidi a impaku a duwwa a tulisan a kasabay ni Jesus, essa ten kawanan na sakay essa bi ten kawiri na. ");
INSERT INTO prfNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Ti pangyayariyid a iyád ay natupad dán en nakasulat ten kasulatan a, “Imbilang di siya ten mágbabonu hidi.” ");
INSERT INTO prfNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Ináinsultu siya nen tolay hidi a magtalib sakay magwalingiwág hidi a kinagi di, “Ánya nadid? Siko bali i mangrábbaid ten Templo sakay gamitán mu a ruway ti tállu la a aldew? ");
INSERT INTO prfNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Iligtas mu benid i sadili muwen! Umugsad ka ti kudusen!” ");
INSERT INTO prfNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Sinesti bi siya nen pinunu hidi nen padi hidi sakay nen tagapagtoldu hidi nen Kautusan, kinagi di ten balang essa dikodi, “Inligtas na en agum a tolay peru awan na meligtas i sadili naen! ");
INSERT INTO prfNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Ni ketan tam a umugsad ti kudusen i hari kanen ti Israel ay maniwala kitamon dikona a siya en Cristo!” Sinesti bi siya nen duwwa a tulisan a kasabay na a nepaku ten kudus. ");
INSERT INTO prfNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Dikona tanghali dán ay nagdiklám en atanan a lugar hanggan ten alas tres ten apon. ");
INSERT INTO prfNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Dikona alas tres dán ten apon ay pummákraw ti Jesus ti mabegsák, “Eloi, Eloi, Lema Sabachthani?” Gustu naid a kagiyán ay, “Diyos ku, Diyos ku, bakin pinabayanák mu?” ");
INSERT INTO prfNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Nasanig iyud nen tolay hidi a ked haud kaya kinagi di, “Sanigán moy, dulawán na ti Elias.” ");
INSERT INTO prfNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Tehud a essa a nagginan a nangalap ti damit a pamunas sakay binisa na iyud ti maapsot a alak. Káttapos ay inyálpet na ten ontok nen tákkán sakay impasápsáp na kánni Jesus. Kinagi na, “Ilingán tam benid ni dumemát ti Elias a máng-ugsad dikona.” ");
INSERT INTO prfNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Pummákraw ti Jesus ti mabegsák sakay káttapos ay nabágsot dán en angás na. ");
INSERT INTO prfNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Sakay napisad ten ditángnga na en mabagál a kortina nen Templo, sapul ten disunu hanggan ten dibábbi. ");
INSERT INTO prfNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Mágtaknág en pinunu nen sundalu hidi ten atubengán nen kudus. Netan na ni konya a natay ti Jesus kaya kinagi na, “Tarud ngani a Anak nen Diyos i tolayid a iddi!” ");
INSERT INTO prfNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Tehud a mágtan-aw a sangan a bábbi ten adeyu, kaguman de Maria Magdalena, Salome sakay ti Maria a ina de Santiago sakay ti Jose. ");
INSERT INTO prfNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Sapul pa ti Galilea ay nákkuyoyug dán hidi kánni Jesus sakay nagserbi hidi dikona. Ked bi haud en agum hidi a bábbi a nákkuyug dikona ti Jerusalem. ");
INSERT INTO prfNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Dikona mágga-aapon dán ay dummemát ti Jose a taga-Arimatea. Essa siya a igággalang a miyembru nen Sanedrin, maguray bi siya ten káddemát nen pághari nen Diyos. Nadid gapu aldew tenhud nen pághanda di ten Aldew nen Káimang ay binegsákkan na en isip na a ummangay kánni Pilato para agidán na en bangkay ni Jesus. ");
INSERT INTO prfNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Nagtaka ti Pilato dikona nabareta na a natay dán ti Jesus. Pinadulaw na en pinunu nen sundalu hidi sakay tinanung na ni tatarudan. ");
INSERT INTO prfNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Dikona a matukuyan na ten pinunu a talaga a patay dán siya ay pinayagan na ti Jose a alapán en bangkay ni Jesus. ");
INSERT INTO prfNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Dikona medibábbi ni Jose en bangkay ni Jesus ay binalutan na ten damit a lino a binali na. Káttapos ay inlábbáng na ten kuweba a batu. Impagulung na en dikál a batu a nangtakláb di ten pintuwan nen páglábbángngan. ");
INSERT INTO prfNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Netan de Maria Magdalena sakay ti Maria a ina ni Jose en nánglábbángngan kánni Jesus. ");
INSERT INTO prfNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Nadid, kállipas nen Aldew nen Káimang, de Maria Magdalena, ti Maria a ina ni Santiago sakay ti Salome ay namali hidi ti págpasárrub a idátton di ten bangkay ni Jesus. ");
INSERT INTO prfNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Dikona sumikat en aldew ten Simba ay ummangay hidi ten nánglábbángngan kánni Jesus. ");
INSERT INTO prfNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Peru mamagtanungan hidi, “Deya wád mángpagulungid ten batu a nakatakáp ten pintuwan nen páglábbángngan?” ");
INSERT INTO prfNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Tunay ti kadikál en batu. Peru dikona tuman-aw hidi ay negulung dán en batu. ");
INSERT INTO prfNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Dikona summáddáp hidi disalad ay nagtaka hidi gapu naketa hidi ti essa a lállaki a nakabadu ti malayon a mapudew a mággetnud ten danág ten kawanan. ");
INSERT INTO prfNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Sakay kinagi nen lállaki, “Dyan kam manteng, aryokán moy ti Jesus a taga-Nazaret, en impaku ten kudus. Awan siya háddi, biniyag siya a ruway nen Diyos! Ilingán moy i nángdáttonan diyen dikona. ");
INSERT INTO prfNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Kaya kammoy dán ibareta moy ten disepulus na hidi lalu kánni Pedro. Kagiyán moy a, ‘Mágdipalongu siya dikomoy ti Galilea. Ketan moy siya haud a kona ten kinagi na dikomoy.’ ” ");
INSERT INTO prfNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Lummuwas hidi ten páglábbángngan sakay nággaginanán hidi a lummakad, magpágpág hidi sakay magulu en isip di. Awan hidi ti ingkagi a ányaman maski kándeya gapu ten ánteng di. ");
INSERT INTO prfNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Nadid, dikona a nabiyag a ruway ti Jesus ten kaldiwan nen Simba ay ti Maria Magdalena en purumeru a pinumetaan na. Siya en bábbi a nangibutan ni Jesus ten pittu a dimonyo. ");
INSERT INTO prfNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Ummangay siya ten disepulus hidi ni Jesus, dinemáttan na hidi a malungkut sakay mágsasangitán. Imbareta na dikodi en netan na. ");
INSERT INTO prfNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Peru awan hidi maniwala dikona kagiyán ni Maria a biyag ti Jesus sakay pummeta dikona. ");
INSERT INTO prfNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Káttapos ay pumumeta bi ti Jesus ten duwwa a disepulus a pasiyaan a maglakad a patamu ti baryu, peru iba en idsura ni Jesus tenhud. ");
INSERT INTO prfNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Nagsoli hidi sakay imbareta di ten kakagumanan di hidi en nangyari, peru awan hidi naniwala. ");
INSERT INTO prfNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Sakay pummeta ti Jesus ten sapulu ay ti essa a disepulus mentras a kuman hidi. Nagsarantaan na hidi gapu ten awan di pánniwala dikona sakay ten káttug nen ulu di, gapu awan hidi naniwala ten naketa hidi dikona a biyag ngani siya. ");
INSERT INTO prfNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Sakay kinagi ni Jesus dikodi, “Angay kam ti buuwid a mundu, ipangaral moy en Maganda a Bareta ten atanan a tolay. ");
INSERT INTO prfNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","En atanan a sumampalataya sakay magpabinyag ay maligtas, peru en awan sumampalataya ay maparusaan. ");
INSERT INTO prfNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","En sumampalataya hidi ay átdenan ti kapangyariyan a maggamet ti himala: ten pamamag-itan nen ngaran ku ay magpalakad hidi ti dimonyo sakay makapagupos ti iba-iba a upos. ");
INSERT INTO prfNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Awan hidi maaánya maski ni mangkáppot hidi ti biklat oni makainom ti ilu. Sakay magpiyya en tehud hidi a saket a tupuwan di ten lima di. ");
INSERT INTO prfNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Nadid káttapos nen Panginoon a Jesus a nákpágguron ten disepulus hidi, ay indisunu siya dilanget sakay nággetnud ten kawanan nen Diyos. ");
INSERT INTO prfNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Summunud ngani en disepulus na hidi a nangaral ten atanan a lugar. Sakay tinulungan hidi nen Panginoon, pinatunayan na ten tolay hidi a tarud en ipangaral di gapu ten himala hidi a ingkaluub na dikodi. (9) Ummangay en bábbi hidi kánni Pedro sakay ten kaguman na hidi, sakay insaysay di en atanan a nakagi dikodi. (10) Káttapos ay inutusan ni Jesus en disepulus na hidi a ipangaral ten atanan a suluk ni munduwiday en banal sakay biyag a awan ti katapusan a bareta nen kaligtasan.");
INSERT INTO prfNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Kagalang-galang a Teofilo, makpal dán a tolay i nagsikapid a mángsulat tungkul ten bagay hidi a nangyari a netan mi. ");
INSERT INTO prfNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","En insulat di ay tungkul ten netoldu dikomi nen naketa hidi sapul pa ten sapul na, sakay nangaral ten Maganda a Bareta. ");
INSERT INTO prfNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Kaya inadal ku bi ti hustu en atanan a bagay tungkul ti nangyariyid a hidi iyád, sinapul ku ten sapul na, sakay káttapos ay naisipan ku a isulat ti maayus en atanan a pangyayari para dikomu ");
INSERT INTO prfNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","tánni matukuyan mu talagaid a katutuhanan tungkul ten netoldu hidi dikomu. ");
INSERT INTO prfNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Dikona a ti Herodes en hari ti Judea ay tehud a essa a padi a Zacarias en ngaran na. Kaguman siya ten grupu ni Abias. En kabinga na ay ti Elisabet a gubwat ten lahi ni Aaron. ");
INSERT INTO prfNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Ten atubengán nen Diyos ay parehu a makasaya en magkabinga. Sássunudán di en atanan a kautusan sakay bilin nen Panginoon. ");
INSERT INTO prfNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Awan hidi ti anak gapu baug ti Elisabet, sakay mágkatanda dán hidi a duwwa. ");
INSERT INTO prfNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Nadid, dikona a en grupu dán de Zacarias en lummewas a nanungkulan ten Templo ay siya en nagserbi a padi ten atubengán nen Diyos. ");
INSERT INTO prfNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Dikona nagbunutan hidi a ayun ten kaugaliyan nen padi hidi ay en ngaran ni Zacarias en napili a somdáp ten kadisaladan nen Templo nen Panginoon para magalay ti insenso. ");
INSERT INTO prfNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Ti odasid a iyud ay napisan bi en tolay hidi a magdasal ten luwas nen Templo. ");
INSERT INTO prfNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Nadid ay tehud a pummeta kánni Zacarias a essa anghel nen Panginoon. Nágtaknág ten kawanan nen altar a págtutudan ti insenso. ");
INSERT INTO prfNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Naráknid siya sakay neántingan ten pákketa na ten anghel. ");
INSERT INTO prfNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Peru kinagi nen anghel dikona, “Dyan ka manteng Zacarias! Sinanig nen Diyos en dasal mu. Magenak en kabinga mu a ti Elisabet ti essa a lállaki sakay Juan ingaran muwid dikona. ");
INSERT INTO prfNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Magin masaya ka sakay makpal bi masayaid ten kákkeenak na. ");
INSERT INTO prfNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Gapu magin mataas siya ten atubengán nen Panginoon. Awan siya dapat a uminom ti alak oni maski ányaman a makalasing. Buktet palla siya ay ked dán dikona en Banal a Ispiritu. ");
INSERT INTO prfNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Makpal ten Israelita hidi en maakit na a sumoli ten Panginoon di a Diyos. ");
INSERT INTO prfNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Dumipalongu siya ten Panginoon. Ked dikona en Ispiritu sakay kapangyariyan a kona kánni Elias a propeta. Pagkasunduwán na en máttama hidi. Pasoliyán na ten tama a dilan en masuwayin hidi, tánni mehanda na en tolay hidi para ten Panginoon. ");
INSERT INTO prfNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Kinagi ni Zacarias ten anghel, “Konyaák a makasigudu a mangyari iyád? Lakayák dán sakay bikás dán bi en kabinga ku. ");
INSERT INTO prfNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Tummábbig en anghel, “Sikán ay ti Gabriel a magserbi ten atubengán nen Diyos. Inutusanák na tánni ikagi ku dikomu iyád a maganda a bareta. ");
INSERT INTO prfNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Peru gapu awan ka maniwala ten kinagi ku a mangyari iyád ten netakda a panahun, ay mabulol ka hanggan dumemát en takda a odas a mangyari en kinagi ku dán dikomu.” ");
INSERT INTO prfNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Nadid en tolay hidi ay maguray kánni Zacarias ten luwas. Magtaka dán hidi ni bakin a malay siya a lumuwas. ");
INSERT INTO prfNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Ten kálluwas na ay awan dán siya makapagupos nan magsinyas dálla. Kaya naisip nen tolay hidi a bakay naketa siya ti pangitain ten disalad nen Templo. Ti Zacarias ay nagtulos-tulos a bulol. ");
INSERT INTO prfNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Dikona natapos dán en págserbi ni Zacarias ay ummuli dán siya. ");
INSERT INTO prfNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Awan nagnalay ay naglihi dán ngani ti Elisabet. Sakay limma a bulan siya a awan lummuwas ten bilay di. ");
INSERT INTO prfNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Kinagi ni Elisabet, “Nadid ay kinagbiyanák nen Panginoon. Ginamet na iyád tánni maibut en dahilan nen kahihiyan ku!” ");
INSERT INTO prfNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Ten kaánnám a bulan nen págbuktet ni Elisabet ay inutusan nen Diyos ti anghel Gabriel a umangay ti Nazaret, Galilea, tánni kaurunán na en ");
INSERT INTO prfNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","essa a dalaga a Maria en ngaran na. Nakatakda dán siya a ikasal kánni Jose a gubwat ten lahi ni hari a David. ");
INSERT INTO prfNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Ummangay en anghel kánni Maria, sakay binati na, “Magsaya ka dán! Kasayaan ka a tarud nen Diyos sakay ked dikomu en Panginoon.” ");
INSERT INTO prfNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Nabalisa a tarud ti Maria sakay ináisip na ti hustu ni ánya i kahuluganid ni uposid a iyud. ");
INSERT INTO prfNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Kinagi nen anghel dikona, “Dyan ka manteng Maria, gapu kasayaan ka nen Diyos. ");
INSERT INTO prfNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Kagiyán kuwidi dikomu ay maglihi ka sakay magenak ka ti essa a lállaki a ngaranan mu a Jesus. ");
INSERT INTO prfNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Magin mataas siya, sakay ngaranan di siya a Anak nen Kataasan a Diyos. Gamitán siya nen Panginoon a Diyos a hari a kona ten ninunu na a ti David. ");
INSERT INTO prfNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Maghari siya ten lahi ni Jacob a awan ti katapusan. En pághari na ay pang-awan ti katapusan.” ");
INSERT INTO prfNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Kinagi ni Maria ten anghel, “Konya iyád a mangyari birhenák palla bi?” ");
INSERT INTO prfNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Kinagi nen anghel dikona, “Umangay dikomu en Banal a Ispiritu sakay lenduman ka nen kapangyariyan nen Kataasan a Diyos. Kaya en iyenak mu ay banal sakay dulawán a Anak nen Diyos. ");
INSERT INTO prfNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Kona ten nangyari ten kamag-anak mu a ti Elisabet, awan beman tukoy nen atanan a tolay a baug siya? Peru nadid ay naglihi siya maski bikás dán. Kaánnám na dán nadid a bulan a mabuktet, ");
INSERT INTO prfNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","gapu awan ti ányaman a bagay a awan magamet nen Diyos.” ");
INSERT INTO prfNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Tummábbig ti Maria, “Alipinák nen Panginoon. Mangyari nakuwan dikoku en kinagi mu.” Káttapos ay linakadan dán siya nen anghel. ");
INSERT INTO prfNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Nadid, awan nagnalay ay nagapura ti Maria a ummangay ten mabuki-bukid a banuwan ti Judea. ");
INSERT INTO prfNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Káddemát na ten bilay de Zacarias ay binati na ti Elisabet. ");
INSERT INTO prfNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Pákkasanig ni Elisabet kánni Maria ay nagarikad en anak ten disalad nen tiyan na. Naputat ti Banal a Ispiritu ti Elisabet. ");
INSERT INTO prfNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Sakay nepákraw siya ten saya na a kinagi na, “Pinagpala ka ten atanan a bábbi sakay pinagpala bi i buktet muwen! ");
INSERT INTO prfNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Deyaák beman para bisitaán nen ina nen Panginoon ku? ");
INSERT INTO prfNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Ten pákkasanig ku ten bati mu ay nagarikad ten saya na i anakidi ti tiyan kuwiday. ");
INSERT INTO prfNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Pinagpala ka ta summampalataya ka a mangyari en kinagi nen Panginoon dikomu.” ");
INSERT INTO prfNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Sakay kinagi ni Maria, “Magpuri i pusu kuwiday ten Panginoon, ");
INSERT INTO prfNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","sakay en ispiritu ku ay masaya ten Diyos a Tagapagligtas ku. ");
INSERT INTO prfNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Gapu awanák na pinabayan maski mababaák la a alipin na! Sapul nadid ay kagiyán nen atanan a tolay a sikán ay pinagpala. ");
INSERT INTO prfNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Gapu dikál a bagay en ginamet dikoku nen Makapangyariyan a Diyos. Siya ay Banal! ");
INSERT INTO prfNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","En habag na ay para ten atanan a tolay, sakay ten atanan a lahi a tehud a ánteng dikona. ");
INSERT INTO prfNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Impeta na en begsák nen barasu na, sakay linitu na en hambug hidi ti pággisipan. ");
INSERT INTO prfNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Inibutan na ten trono di en tehud hidi a kapangyariyan. Sakay intaas na en ked hidi ten mababa a kalagayan. ");
INSERT INTO prfNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Pinutat na ti mágkaganda a bagay en magaláp hidi. Sakay pinalakad na a awan ti tawid a ányaman en mágkayaman hidi. ");
INSERT INTO prfNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Tinulungan na en tagapagserbi na a Israel, awan na hidi linimon a kahabagan. ");
INSERT INTO prfNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Tinupad na en pangaku na ten ninunu tam hidi, kánni Abraham sakay en lahi na hidi a awan ti katapusan!” ");
INSERT INTO prfNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Nágyan ti Maria kánde Elisabet ti tállu a bulan bagu siya a ummuli. ");
INSERT INTO prfNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Nadid, dikona dummemát en odas a magenak dán ti Elisabet ay lállaki en anak na. ");
INSERT INTO prfNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Masaya a tarud en kadatigan na hidi sakay en partidu na hidi dikona a mabareta di a pinagpala siya nen Panginoon. ");
INSERT INTO prfNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Ten kawalu a aldew ay ummangay hidi ten bilay de Elisabet gapu turiyán di dán en anak. Ngaranan di nakuwan a Zacarias en anak a kona ten ama na, ");
INSERT INTO prfNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","peru kinagi ni Elisabet, “Bakán! Juan ngaran naid.” ");
INSERT INTO prfNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Kinagi di, “Peru awan kam ti kapartidu a tehud a ngaran a kona haán.” ");
INSERT INTO prfNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Kaya sininyasan di en ama na tánni itanung di ni ánya gustu naid a pangngaran ten anak na. ");
INSERT INTO prfNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Nággid ti Zacarias ti pagsulatan sakay insulat na a, “Juan i ngaran naid.” Nagtaka hidi a atanan. ");
INSERT INTO prfNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Ti odasid biyid a iyud ay nakapagupos dán ti Zacarias, sakay tulos siya a nagpuri ten Diyos. ");
INSERT INTO prfNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Neántingan en kadatigan di hidi, sakay nekalat en bareta ten buu a mabuki-bukid a lugar ti Judea. ");
INSERT INTO prfNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Atanan nen nakabareta hidi ay mággaisipán ten pangyayari. Kinagi di, “Ánya wád pangyariyanid ni anakid a iyád? Gapu maliwanag a ked dikona en kapangyariyan nen Panginoon. ");
INSERT INTO prfNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Naputat ti Banal a Ispiritu ti Zacarias a ama ni Juan, sakay nagpahayag ti mensahi a gubwat ten Diyos. ");
INSERT INTO prfNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Kinagi na, “Puriyán tam en Panginoon a Diyos ni Israel! Tinulungan na sakay pinalaya en tolay na hidi. ");
INSERT INTO prfNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Nángpaangay siya dikotam ti essa a makapangyariyan a Tagapagligtas, a gubwat ten lahi ni David a tagapagserbi na. ");
INSERT INTO prfNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Tenhud pa a panahun ay impangaku na dán ten pamamag-itan nen propeta na hidi a banal, ");
INSERT INTO prfNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","a iligtas na kitam ten atanan a kadima tam, sakay ten atanan a maiyamut dikotam. ");
INSERT INTO prfNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Nagpangaku bi a kagbiyan na en ninunu tam hidi, sakay awan na kalimunan en banal na a kasunduwan. ");
INSERT INTO prfNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Impangaku na ten ninunu tam a ti Abraham, ");
INSERT INTO prfNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","a iligtas na kitam ten atanan a kadima tam, tánni makapagserbi kitam dikona a awan ti ánteng, ");
INSERT INTO prfNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","sakay magin banal sakay matuwid ten pangileng na mentras a biyag kitam.” ");
INSERT INTO prfNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Intulos pa ni Zacarias a kinagi, “Siko a anak ku ay ngaranan di ka a propeta nen Kataasan a Diyos. Gapu mágdipalongu ka ten Panginoon a mánghanda ten paglakadan na. ");
INSERT INTO prfNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Tánni ipakapospos mu ten tolay na hidi en kaligtasan di, sakay en kapatawadan nen kasalanan di. ");
INSERT INTO prfNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","En Diyos ay talaga a makákkagbiyán sakay mapagmahal. Págdadedemlagán na dán en aldew nen kaligtasan. ");
INSERT INTO prfNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Siya i mangdemlagid ten tolay hidi a ked ten kadiklámman sakay en adeni dán ti kamatayan. Igiyya na kitam ten dilan a patamu ten kapayapaan.” ");
INSERT INTO prfNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Dummikál en anak sakay bummegsák en ispiritu na. Nágyan siya ten kaparangan hanggan ten dikona angay dán siya pummeta ten banuwan ni Israel. ");
INSERT INTO prfNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Ti panahunid a iyud, ay inyutus ni Emperador Augusto a kailangan a magparihistru en atanan a tolay a nasakupan nen kahariyan ni Roma. ");
INSERT INTO prfNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Iyád en purumeru a págparihistru nen tolay hidi dikona a gubernador ti Cirenio ti Siria. ");
INSERT INTO prfNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Kaya en atanan a tolay ay ummuli ten sadili di a banuwan tánni magparihistru. ");
INSERT INTO prfNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Kaya ti Jose a mágyan ten banuwan a Nazaret, a essa a siyudad ti Galilea ay ummangay ti Judea, ti Bethlehem ten banuwan a neenakan ni hari a David, gapu siya ay gubwat ten lahi ni David. ");
INSERT INTO prfNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Kaguman ni Jose ti Maria a magin kabinga na. Angay bi hidi magparihistru. Ti Maria ay taráeenakan dán, ");
INSERT INTO prfNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","kaya mentras a ked hidi ti Bethlehem ay nagabutan siya nen pággenak na. ");
INSERT INTO prfNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Inyenak ni Maria en panganay na a anak a lállaki. Binalutan na iyud ti lampen sakay impakatdug na ten págpakanan ti hayup. Gapu awan dán hidi ti maari a tulusan ta awan dán ti bakanti ten págkaseruwan. ");
INSERT INTO prfNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Ti lugarid a iyud ay tehud a katolayan a magbantay ten alaga di hidi a tupa ten kaparangan ti gibiyid a iyud. ");
INSERT INTO prfNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Bigla a pummeta dikodi en essa a anghel nen Panginoon, sakay en kaluwalhatian nen Panginoon ay dinumemlag ten palebut di kaya minanteng hidi. ");
INSERT INTO prfNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Peru kinagi nen anghel dikodi, “Dyan kam manteng, tehudák a tawid a maganda bareta para dikomoy. Mangatád iyád ti dikál a kasayaan ten atanan a tolay. ");
INSERT INTO prfNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Neenak nadid a aldew ten banuwan ni David en Tagapagligtas moy, en Cristo a Panginoon. ");
INSERT INTO prfNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Saiddi tanda naid, tehud kam a ketan a anak a nabalutan ti lampen sakay kumákkatdug ten págpakanan ti hayup.” ");
INSERT INTO prfNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Nadid, bigla a linumitaw ten páppágyanan nen anghel en makpal pa a anghel a gubwat dilanget, mágkansiyon hidi ti papuri ten Diyos. ");
INSERT INTO prfNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","Kinagi di, “Puriyán en Diyos a ked dilanget, sakay kapayapaan ti lutaiday para ten tolay hidi a kasayaan na.” ");
INSERT INTO prfNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Dikona a nagsoli dán en anghel hidi dilanget ay namágguron en mággalaga hidi ti tupa, kinagi di, “Kadtamon ti Bethlehem, angay tam ilingán iyád a pangyayari a ingkagi dikotam nen Panginoon.” ");
INSERT INTO prfNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Pagdaka hidi a ummangay ti Bethlehem. Káddemát di haud ay netan di de Maria ay ti Jose, sakay en anak a kumákkatdug ten págpakanan ti hayup. ");
INSERT INTO prfNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Inyistorya nen mággalaga hidi ti tupa en tungkul ten anak a imbareta nen anghel dikodi. ");
INSERT INTO prfNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Nagtaka en atanan a nakasanig ten kinagi nen mággalaga hidi ti tupa. ");
INSERT INTO prfNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Peru pinakatandaan ni Maria en atanan a nasanig na, sakay nággisip-isip ten atanan a nangyari. ");
INSERT INTO prfNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Nagsoli dán en mággalaga hidi ti tupa ten kaparangan a mágpapuriyán ten Diyos sakay magpahayag ten kadakilaan na, gapu ten atanan a nasanig di sakay netan di a imbareta nen anghel dikodi. ");
INSERT INTO prfNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Nadid káddemát nen kawalu a aldew ay tinuri en anak, sakay Jesus en nangngaran di dikona. Iyád en ngaran a kinagi nen anghel bagu siya a inlihi. ");
INSERT INTO prfNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Ten dikona dummemát dán en aldew a pangtupad de Jose ay ti Maria ten Kautusan ni Moises a páglinis, ay ummangay hidi ti Jerusalem. Tawid di en anak tánni iyalay di ten Panginoon, ");
INSERT INTO prfNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","gapu kona háddi en nakasulat ten Kautusan nen Diyos, “En atanan a panganay a lállaki ay ilaan ten Panginoon.” ");
INSERT INTO prfNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Nagalay bi hidi ayun ten kinagi nen kautusan nen Panginoon, maari a magkabinga a batu-batu oni duwwa a ogbun ni kalapati. ");
INSERT INTO prfNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Nadid, ti panahunid a iyud ay tehud a lállaki a mágyan ti Jerusalem a Simeon en ngaran na. Matuwid siya a tolay, tehud siya a ánteng ten Diyos sakay mággaurayán siya ten pángligtas nen Diyos ten lahi ni Israel. Ked dikona en Banal a Ispiritu. ");
INSERT INTO prfNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Impakapospos nen Banal a Ispiritu dikona a awan siya matay hanggan awan na ketan en Cristo a impangaku nen Panginoon. ");
INSERT INTO prfNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Gapu inggiyya siya nen Banal a Ispiritu kaya sinomdáp siya ten Templo. Dummemát bi ten Templo de Jose ay ti Maria a tawid di en anak a ti Jesus tánni tupadán di en Kautusan. ");
INSERT INTO prfNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Kinarga ni Simeon en anak sakay nagpuri ten Diyos a kinagi na, ");
INSERT INTO prfNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Nadid Panginoon, natupad dán en impangaku mu dikoku, maariyák mu dán a alapán a mapayapa. ");
INSERT INTO prfNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Gapu netan ku dán a mismu en págligtas mu, ");
INSERT INTO prfNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","a inhanda mu para ketan nen atanan a tolay. ");
INSERT INTO prfNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Essa a demlag a mángpahayag ten kaluuban mu ten Hentil hidi, sakay siya bi en mangatád ti kapuriyan ten banuwan mu a Israel.” ");
INSERT INTO prfNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Nagtaka en dáddikál hidi nen anak gapu ten kinagi ni Simeon tungkul dikona. ");
INSERT INTO prfNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Pinagpala hidi ni Simeon sakay kinagi na kánni Maria a ina nen anak, “I anakid a iyád ay nelaan para ten kákkepahamak oni kákkaligtas nen makpal ti Israel. Siya en tanda a gubwat ten Diyos, peru makpal mangkontraid dikona. ");
INSERT INTO prfNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Gapu dikona ay matukuyan en ked ten isip nen makpal a tolay. Sakay siko Maria ay dumanas ka ti subra a kalungkutan a kumán a balisung a nesaksak ti pusu muwen. ");
INSERT INTO prfNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Ked bi ten Templo en essa propeta a bábbi, Ana en ngaran na. Anak siya ni Fanuel a gubwat ten lahi ni Aser. Bikás dán siya a tarud. Pittu la hidi a taon a nagagum ay ten kabinga na, ");
INSERT INTO prfNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","sakay nabilu dán siya. Nadid ay walu a pulu ay ti áppat dán a taon siya a bilu. Pirmi siya a ked ten Templo, sakay aldew ay ti gibi ay sumamba ten Diyos ten pamamag-itan nen págkulásyon sakay págdasal. ");
INSERT INTO prfNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Ti odas biyid a iyud ay ummadeni bi siya kánde Jose ay ti Maria sakay nagpasalamat ten Diyos. Nagupos bi siya ti tungkul ten anak ten atanan nen maguray ten págpalaya nen Diyos ti Jerusalem. ");
INSERT INTO prfNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Dikona natupad dán de Jose ay ti Maria en atanan a bagay a agidán nen Kautusan nen Panginoon ay nagsoli dán hidi ti Nazaret, Galilea. ");
INSERT INTO prfNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","En anak ay dummikál a malusug, matalinu, sakay makasaya ten Diyos. ");
INSERT INTO prfNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Kada a taon ten Piyesta nen Aldew nen Págtalib nen Judio hidi, ay angay en dáddikál hidi ni Jesus ti Jerusalem. ");
INSERT INTO prfNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Sakay dikona sapulu ay ti duwwa dán a taon ti Jesus ay ummangay dámman hidi ti Jerusalem a kona ten dati di a kaugaliyan. ");
INSERT INTO prfNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Káttapos nen piyesta ay nagrektat dán hidi a ummuli. Nawarak ti Jesus ti Jerusalem a awan natukuyan nen dáddikál na hidi. ");
INSERT INTO prfNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Gapu en akala di ay ked la siya a kaunonud di kaya tulos-tulos la en lakad di ten saldew. Dikona a napospusan di a awan siya kaguman ay nagaryok dán hidi ten kapartidu di hidi ay ten mágkatenggi di hidi a tolay. ");
INSERT INTO prfNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Peru awan di siya netan, kaya nagsoli hidi ti Jerusalem a magaryok. ");
INSERT INTO prfNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Tállu a aldew hidi a nagaryok bagu di a netan ti Jesus ten Templo. Mákpággetnud ten tagapagtoldu hidi nen Kautusan. Mágsanig siya dikodi sakay magtanung. ");
INSERT INTO prfNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Atanan nen makasanig hidi dikona ay magtaka ten karunungan na. ");
INSERT INTO prfNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Dikona netan siya nen dáddikál na hidi ay nagtaka bi hidi. Kinagi nen ina na, “Anak ku, bakin ginamet mu iyád dikomi? Tunay kami ti balisa ay ti ama mu a mággaaryokán dikomu.” ");
INSERT INTO prfNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Kinagi ni Jesus, “Bakin a aryokánnák moy? Awan moy beman tukoy a dapatid ay kedák ten bilay nen ama ku?” ");
INSERT INTO prfNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Peru awan di naintendiyan en tatarudan a kahulugan nen kinagi na. ");
INSERT INTO prfNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Sakay nák-oli dán siya ten dáddikál na hidi ti Nazaret. Masunurin siya a anak ten dáddikál na hidi. Nadid, pinakatandaan nen ina na en atanan a bagay a nangyari. ");
INSERT INTO prfNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Mágdika-dikál ti Jesus, sakay lummawak en karunungan na. Lalu siya a nagin makasaya ten Diyos pati ten tolay hidi. ");
INSERT INTO prfNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Ti panahunid a iyud, ay sapulu dán ay ti limma a taon en pághari ni Emperador Tiberio. Ti Poncio Pilato ay gubernador ti Judea. Ti Herodes ay pinunu ti Galilea, sakay en kapatkaka na a ti Felipe ay pinunu ten lugar a Iturea sakay Traconite. Ti Lisanias ay pinunu ti Abilinia. ");
INSERT INTO prfNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Dikona de Anas ay ti Caifas en kapunuwan nen padi hidi, ti Juan a anak ni Zacarias ay mágyan ten kaparangan. Sakay impahayag nen Diyos kánni Juan en upos na. ");
INSERT INTO prfNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Kaya linebut na en magdibe-dibelyu a lugar ti Jordan. Impangaral na a dapat hidi a magsisi ten kasalanan di, sakay magpabinyag tánni patawadán hidi nen Diyos. ");
INSERT INTO prfNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Kaya natupad en nakasulat ten libru ni propeta Isaias a, “Iddi en impahayag nen essa a tolay a magpákraw ten kaparangan: ‘Ihanda moy en paglakadan nen Panginoon. Maggamet kam ti masunong a dilan a paglakadan na! ");
INSERT INTO prfNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Matambakan en lábbak-lábbak, sakay mapatag en buki-bukid. Mapasunong en dilan a kiwál-kiwál, sakay mapatag en dilan a mabagtu-bagtu. ");
INSERT INTO prfNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Sakay ketan nen atanan a tolay en págligtas a gamitán nen Diyos!’ ” ");
INSERT INTO prfNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Makpal en tolay a ummadeni kánni Juan para magpabinyag. Peru kinagi na dikodi, “Sikam a lahi hidi ni biklat! Deya i nagkagiyid dikomoy maginanan moy en parusa a dumemát? ");
INSERT INTO prfNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Ipeta moy ten pamamag-itan nen gamet a nagsisi kamon, sakay dyan moy ikatuwiran a anak kam ni Abraham. Kagiyán ku dikomoy, a makalalang en Diyos ti tatarudan a anak ni Abraham ti batuwiday hidi. ");
INSERT INTO prfNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Nadid palla ay nakahanda dán en wasay para ten gamot hidi nen kayu; en balang kayu a awan magbunga ti maganda ay pukanán sakay ibut ten apoy.” ");
INSERT INTO prfNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Tinanung siya nen tolay hidi, “Ni konahud ay ánya i dapat miyid a gamitán?” ");
INSERT INTO prfNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Tummábbig ti Juan, “Ni tehud kam a duwwa a badu ay iyatád moy en essa ten awan. Kona bi hud gamitánnid nen tehud a pagkain. ");
INSERT INTO prfNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Nadid, dummemát bi en mágsinger hidi ti buwes tánni magpabinyag, sakay nagtanung hidi dikona, “Maistu, ánya i dapat miyid a gamitán?” ");
INSERT INTO prfNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Kinagi na dikodi, “Dyan kam magsinger ti subra ten dapat moy a singirán.” ");
INSERT INTO prfNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Tinanung bi siya nen sundalu hidi, “Ay sikami, ánya bi i dapat miyid a gamitán?” Kinagi ni Juan dikodi, “Dyan kam mággid ten deyaman ten pamamag-itan nen págpilit oni págbintang ten awan ti katuwiran. Tama moy dán en suweldu moy.” ");
INSERT INTO prfNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Magáoray tenhud en katolayan ten káddemát nen Cristo, kaya inisip di a ti Juan dán en áorayán di. ");
INSERT INTO prfNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Kaya kinagi ni Juan dikodi, “Binyagan takam ten pamamag-itan nen dinom, peru en dumemát a kasunud ku ay siya i mangbinyagid dikomoy ten pamamag-itan nen Banal a Ispiritu sakay nen apoy. Mas makapangyariyan siya nan sikán, awanák ngani karapatdapat maski mangokbis man dálla ten igut nen sandalyas na. ");
INSERT INTO prfNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Tawid na dán en bilau tánni tapan na en inággik. Puronán na en paray sakay isaddi na ten bilay na. Peru en lupás ay tutudán na ten apoy a awan maada-adáp a awan ti katapusan.” ");
INSERT INTO prfNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Makpal pa a bagay en impangaral ni Juan ten katolayan ten pángpahayag na ten Maganda a Bareta. ");
INSERT INTO prfNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Maski ti Herodes a pinunu ti Galilea ay nagkagiyan bi ni Juan gapu inagum na en kayong na a ti Herodias sakay magin ten agum pa hidi a mágkadukás a gággamitán na. ");
INSERT INTO prfNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Kaya impepiresu ni Herodes ti Juan, sakay lalu pa a nadagdagan en kasalanan ni Herodes. ");
INSERT INTO prfNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Nadid dikona a nabinyagan dán ni Juan en katolayan, ay bininyagan na bi ti Jesus. Mentras a magdasal ti Jesus ay nabukasan dilanget ");
INSERT INTO prfNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","sakay dummibábbi dikona en Banal a Ispiritu a kumán a kalapati. Tehud a boses a gubwat dilanget a kinagi na, “Siko en mahal ku a Anak, kasayaan taka a tarud.” ");
INSERT INTO prfNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Dikona tállu a pulu dán a taon en idad ni Jesus ay sinapulan na dán a mangaral. Ten pangisip nen tolay hidi ay anak siya ni Jose a anak ni Eli, ");
INSERT INTO prfNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","a anak ni Matat. Ti Matat ay anak ni Levi a anak ni Melqui, sakay ti Melqui ay anak ni Janai a anak ni Jose. ");
INSERT INTO prfNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Ti Jose ay anak ni Matatias a anak ni Amos. Ti Amos a anak ni Nahum ay anak ni Esli. Ti Esli a anak ni Nage, ");
INSERT INTO prfNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","ay anak ni Maat a anak ni Matatias. Ti Matatias a anak ni Semei ay anak ni Jose. Ti Jose a anak ni Juda ");
INSERT INTO prfNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","ay anak ni Joana. Ti Joana ay anak ni Resa a anak ni Zorobabel a anak ni Salatiel a anak ni Neri. ");
INSERT INTO prfNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Ti Neri ay anak ni Melqui a anak ni Adi. Ti Adi ay anak ni Cosam a anak ni Elmodam a anak ni Er. ");
INSERT INTO prfNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Ti Er ay anak ni Josue a anak ni Elieser a anak ni Jorim a anak ni Matat. Ti Matat ay anak ni Levi ");
INSERT INTO prfNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","a anak ni Simeon a anak ni Juda. Ti Juda ay anak ni Jose. Ti Jose ay anak ni Jonan a anak ni Eliaquim, ");
INSERT INTO prfNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","a anak ni Melea. Ti Melea ay anak ni Mainan a anak ni Matata a anak ni Natan a anak ni David. ");
INSERT INTO prfNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Ti David ay anak ni Jesse, a anak ni Obed, sakay ti Obed ay anak ni Booz. Ti Booz ay anak ni Salmon a anak ni Naason ");
INSERT INTO prfNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","a anak ni Aminadab a anak ni Admin. Ti Admin ay anak ni Arni a anak ni Esrom, a anak ni Fares. Ti Fares ay anak ni Juda ");
INSERT INTO prfNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","a anak ni Jacob. Ti Jacob ay anak ni Isaac a anak ni Abraham. Ti Abraham ay anak ni Tare a anak ni Nacor. ");
INSERT INTO prfNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Ti Nacor ay anak ni Serug a anak ni Ragau, a anak ni Peleg, sakay ti Peleg ay anak ni Heber a anak ni Sala. ");
INSERT INTO prfNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Ti Sala ay anak ni Cainan a anak ni Arfaxad a anak ni Sem. Ti Sem ay anak ni Noe a anak ni Lamec ");
INSERT INTO prfNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","a anak ni Matusalem a anak ni Enoc. Ti Enoc ay anak ni Jared a anak ni Mahalaleel a anak ni Cainan. ");
INSERT INTO prfNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Ti Cainan ay anak ni Enos a anak ni Set. Sakay ti Set ay anak ni Adan a anak nen Diyos. ");
INSERT INTO prfNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Nadid summoli ti Jesus a gubwat ti Jordan a putat a tarud ti Banal a Ispiritu. Inggiyya siya nen Ispiritu ten kaparangan, ");
INSERT INTO prfNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","ten alay nen áppat a pulu a aldew, tinoksu siya haud nen diyablo. Awan siya ti kinan a ányaman ti alayid a iyud kaya nagaláp siya. ");
INSERT INTO prfNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Kinagi nen diyablo dikona, “Ni siko en Anak nen Diyos, ay iyutus mu a magin tinapay i batuwen.” ");
INSERT INTO prfNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Peru kinagi ni Jesus dikona, “Kinagi nen Kasulatan, ‘Bakán la a ten makan a mabiyag i tolayid.’ ” ");
INSERT INTO prfNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Káttapos ay inyangay siya nen diyablo ten malangkaw a lugar, sakay impeta na ti saglit en atanan a kahariyan ti munduwiday. ");
INSERT INTO prfNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Kinagi nen diyablo, “Iyatád ku dikomu en atanan a kapangyariyan sakay karangalan ni kahariyanid a hidi iyán. Neatád iyád dikoku, sakay maari ku a iyatád maski kándeya, basta gustu ku. ");
INSERT INTO prfNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Kaya ni sambaánnák mu ay magin kao mu hidi iyán a atanan.” ");
INSERT INTO prfNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Peru tummábbig ti Jesus, “Kinagi nen Kasulatan a, ‘En Panginoon mu a Diyos i dapat muwid a sambaán, sakay siya la i dapat muwid a pagserbiyan.’ ” ");
INSERT INTO prfNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Káttapos ay inyangay dámman siya nen diyablo ten toktok nen Templo ti Jerusalem, sakay kinagi na dikona, “Ni siko ngani en Anak nen Diyos ay tumápduk ka, ");
INSERT INTO prfNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","gapu nakasulat a, ‘Pabantay ka nen Diyos ten anghel na hidi, utusan na hidi tánni bantayan di ka,’ ");
INSERT INTO prfNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","sakay nakasulat bi a, ‘Ten pamamag-itan nen lima di ay alalayan di ka, tánni maski i básset muwen ay awan mesángdul ti batu.’ ” ");
INSERT INTO prfNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Peru tummábbig ti Jesus dikona, “Kinagi nen Kasulatan a, ‘Dyan mu purbaan en Panginoon mu a Diyos!’ ” ");
INSERT INTO prfNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Káttapos nen diyablo a nangtoksu kánni Jesus ten atanan a paraan, ay linakadan na dán ti Jesus sakay naguray ti iba a pagkakataun. ");
INSERT INTO prfNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Nadid nagsoli ti Jesus ti Galilea a ked dikona en kapangyariyan nen Ispiritu. Nabareta ten banu-banuwan haud en tungkul dikona. ");
INSERT INTO prfNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Nagtoldu siya ten tolay hidi ten sinagoga di hidi, sakay pinuri siya nen atanan a tolay. ");
INSERT INTO prfNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Nadid, ummangay ti Jesus ti Nazaret, iyud en dummikállan na a banuwan. Kona ten dati na a gággamitán ay summáddáp siya ten sinagoga ten Aldew nen Káimang. Tummaknág siya tánni magbasa, ");
INSERT INTO prfNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","sakay inyatád di dikona en libru a insulat ni propeta Isaias. Binuklat na iyud sakay kona háddi en nakasulat, ");
INSERT INTO prfNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Ked dikoku en Banal a Ispiritu, gapu piniliyák na a mángpakapospos ten Maganda a Bareta ten pubri hidi. Inutusanák na tánni ipakapospos ten piresu hidi a lumaya hidi, sakay kona bi ten burák hidi a maketa hidi. Inutusanák tánni palayaán dán en apiyadu hidi, ");
INSERT INTO prfNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","sakay tánni ipakapospos a pademát dán en panahun nen págligtas nen Panginoon.” ");
INSERT INTO prfNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Káttapos ay linukot na en kasulatan, sakay nággetnud dikona mesoli na ten mágserbi ten sinagoga. Sakay ináeleng siya nen atanan a ked haud. ");
INSERT INTO prfNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Sakay kinagi na dikodi, “Natupad nadid en nasanig moy a binasa ku ten kasulatan.” ");
INSERT INTO prfNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Pinuri siya nen atanan a ked haud sakay nagtaka hidi gapu mahusay en pággupos na. Kinagi di, “Awan beman siya en anak ni Jose?” ");
INSERT INTO prfNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Kaya kinagi ni Jesus dikodi, “Siguradu a kagiyán moy dikoku i kakagiyanid a iddi, ‘Ta Doktor ka ay gamután mu i sadili muwen.’ Maari a kagiyán moy bi a, ‘Bakin a awan mu gamitán ti sadili muwidi a banuwan en nabareta mi a ginamet mu ti Capernaum?’ ");
INSERT INTO prfNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Kagiyán ku dikomoy a awan ti propeta a tenggiyán ten sadili na a banuwan. ");
INSERT INTO prfNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Peru kagiyán ku dikomoy a ten panahun ni propeta Elias ay makpal a bilu a bábbi ti Israel, dikona a awan naguden ti tállu ay ti kalahati a taon sakay nagkahud ti aláp ten buu a lugar. ");
INSERT INTO prfNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Peru awan inutusan ti Elias a umangay ten maski ni deyaman dikodi, nan ummangay siya ten bilu a bábbi ti Sarepta, ten lugar a Sidon. ");
INSERT INTO prfNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Kona labi ten kapanahunan ni Eliseo ay tunay ti kakpal en kinetong ti Israel, peru awan siya ti pinagpiyya sakay lininis maski essa man dikodi, nan ti Naaman la a taga-Siria.” ");
INSERT INTO prfNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Naiyamut en atanan a tolay ten sinagoga dikona masanig di iyud. ");
INSERT INTO prfNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Tummaknág hidi a atanan sakay binerber di siya a paluwas, inyangay di ten gilid nen bukid a páppágyanan nen banuwan tánni itápduk di siya ten pengpeng. ");
INSERT INTO prfNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Peru nagkon siya ten ditángnga di sakay linumakad. ");
INSERT INTO prfNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Kállakad na haud ay ummangay ti Jesus ti Capernaum ti Galilea, sakay nagtoldu ten tolay hidi ten Aldew nen Káimang. ");
INSERT INTO prfNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Nagtaka en mágsanig hidi ten págtoldu na gapu tehud a kapangyariyan en pággupos na. ");
INSERT INTO prfNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Tehud a essa a lállaki a hinayup a ked ten sinagoga. Pummákraw siya ti mabegsák, ");
INSERT INTO prfNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","kinagi na, “Jesus a taga-Nazaret, ánya i pakialam muwid dikomi? Ummangay ka beman háddi tánni bunuwán mu kami? Matenggi taka, siko en Banal a gubwat ten Diyos.” ");
INSERT INTO prfNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Peru sinaway siya ni Jesus, kinagi na, “Tumahimik ka, umibut ka dán ti tolayen!” Sakay nelugmuk en lállaki ten atubengán nen katolayan, káttapos ay lummakad en dimonyo a awan na pinasaketan. ");
INSERT INTO prfNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Nagtaka hidi a atanan, kaya namagtanungan hidi a kinagi di, “Ánya wád iyád a kakalasi a pággupos? Makapangyariyan! Mautusan na a lumakad en mágkadukás a ispiritu sakay sumunud hidi dikona!” ");
INSERT INTO prfNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Sakay kummalat en bareta tungkul kánni Jesus ti iyud a lugar. ");
INSERT INTO prfNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Lummakad ti Jesus ten sinagoga sakay tulos siya a ummangay ten bilay ni Simon. Netaun bi a mahigpit en ladu nen bábbi a katugngan ni Simon, kaya impákpágguron di kánni Jesus a pagpiyyaán siya. ");
INSERT INTO prfNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Tummaknág ti Jesus ten adeni nen kákkatdugan nen bábbi, sakay inyutus na a maibut en ladu, sakay naibut ngani. Pagdaka a ummikat en bábbi sakay nagserbi dikodi. ");
INSERT INTO prfNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Dikona a summarám dán en aldew ay inyangay nen tolay hidi en atanan a tehud a saket kánni Jesus, ányaman en saket di. Intupu na en lima na ten balang essa, sakay nagpiyya hidi a atanan. ");
INSERT INTO prfNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Pinalayas na bi en dimonyo hidi ten tolay hidi a sináddáppan di. Nagpákrawan hidi a lummuwas, kinagi di, “Siko en Anak nen Diyos!” Peru sinaway hidi ni Jesus sakay awan na hidi pinayagan a magupos, gapu tukoy di a siya en Cristo. ");
INSERT INTO prfNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Dikona kaldiwan dán ay lummakad ti Jesus, sakay ummangay ten tahimik a lugar. Inaryok siya nen katolayan sakay dikona ketan di ay nákkekagbi hidi a dyan pala siya lumakad. ");
INSERT INTO prfNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Peru kinagi ni Jesus, “Kailangan a ipangaral ku bi ten agum a banuwan en Maganda a Bareta tungkul ten pághari nen Diyos, gapu saiyád en dahilan kayaák a pinaangay háddi.” ");
INSERT INTO prfNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Sakay nagtulos siya a nangaral ten sinagoga hidi ti buu a Judea. ");
INSERT INTO prfNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Essa a aldew ay mágtaknág ti Jesus ten gilid nen Minalnu ti Genesaret. Kinalibungbungan siya nen tunay a kakpal a tolay gapu gustu di a mágsanig ten upos nen Diyos. ");
INSERT INTO prfNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Tehud siya a netan a duwwa a abeng a pumáppundu, nakaawas dán en mángngikan hidi sakay maglinis dán hidi ten panti di. ");
INSERT INTO prfNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Summakay ti Jesus ten essa a abeng a kao ni Simon, sakay kinagiyan na ti Simon a ituglad na ti sabadit en abeng a paditaw. Nággetnud siya ten abeng sakay nagtoldu ten katolayan. ");
INSERT INTO prfNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Káttapos na a nagtoldu ay kinagi na kánni Simon, “Angay kam ditaw sakay isáklad moy i panti moyen.” ");
INSERT INTO prfNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Tummábbig ti Simon, “Maistu, sagibi kami dán a nagpuyat peru awan kami ti nanalap! Peru gapu ta kinagi mu ay isáklad ku a ruway i pantiyiday hidi.” ");
INSERT INTO prfNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Kona ngani haud en ginamet di. Tunay ti kakpal en nalap di a ikan, kaya ngari-ngari dán a mapisad en panti di hidi. ");
INSERT INTO prfNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Pinayapay di en kaguman di hidi a ked ten iba a abeng tánni patulung hidi. Ummadeni ngani hidi, sakay naputat di en duwwa a abeng a ngari-ngari dán a omlád. ");
INSERT INTO prfNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Ten pákketa ni Simon Pedro ten nangyari ay lummuhud siya ten atubengán ni Jesus sakay kinagi na, “Adeyuwanák mu Panginoon, gapu essaák a makasalanan.” ");
INSERT INTO prfNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Tunay en págtaka na, kona bi ten kaguman na hidi gapu ten kakpal nen nalap di. ");
INSERT INTO prfNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Kona bi hud ten kasosyu hidi ni Simon a de Santiago ay ti Juan a anak ni Zebedeo. Kinagi ni Jesus kánni Simon, “Dyan ka dán manteng, sapul nadid ay tolay dán i dikáppán muwid, bakán dán a ikan.” ");
INSERT INTO prfNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Nadid, dikona nedek di dán en abeng di hidi, ay linakadan di en atanan sakay ummunud hidi kánni Jesus. ");
INSERT INTO prfNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Nadid dikona a ked ti Jesus ten essa a banuwan, ay netan siya nen essa a lállaki a kinetong. Lummuhud siya sakay nákkekagbi a kinagi na, “Panginoon, ni gustuwán mu ay mapagpiyyaák mu.” ");
INSERT INTO prfNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Tinawidan siya ni Jesus sakay kinagi na, “Gustu ku; magpiyya ka dán!” Pagdaka a nawan en ketong na. ");
INSERT INTO prfNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Kinagi ni Jesus dikona, “Dyan mu iyád kagikagiyán maski kándeya. Nan angay ka paileng ten padi. Káttapos ay magalay ka ayun ten inyutus ni Moises. Saiyád mangpatunayid ten tolay hidi a nagpiyya ka dán.” ");
INSERT INTO prfNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Peru lalu a nekalat en bareta tungkul kánni Jesus, kaya nagdemáttan en tunay ti kakpal a tolay tánni mágsanig dikona sakay mapagpiyya en saket di. ");
INSERT INTO prfNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Peru ti Jesus ay mággangay ten tahimik hidi a lugar tánni manalangin. ");
INSERT INTO prfNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Essa a aldew mentras a magtoldu ti Jesus, en Pariseo hidi sakay en tagapagtoldu hidi nen Kautusan ay mággetnud ten adeni na. Gubwat hidi ten iba-iba a banuwan ti Galilea, ti Judea, sakay ti Jerusalem. Ked kánni Jesus en kapangyariyan a magpapiyya ten tehud hidi a saket. ");
INSERT INTO prfNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Sakay dummemát en sangan a tolay a usung di en lupug ten págkatdugan na. Ipilit di a isaddáp ten bilay en tehud a saket tánni meangay di ten atubengán ni Jesus. ");
INSERT INTO prfNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Peru awan hidi ti masáddáppan gapu ten kakpal nen tolay. Kaya summangkay hidi ten atáp sakay lináttab di, sakay intoton di en págkatdugan nen lupug ten atubengán ni Jesus. ");
INSERT INTO prfNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Dikona a ketan ni Jesus en pánnampalataya di, ay kinagi na ten lupug, “Amigu ku, napatawad ka dán ten kasalanan mu hidi.” ");
INSERT INTO prfNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Namágguron en tagapagtoldu hidi nen Kautusan sakay en Pariseo hidi ten pákkasanig di haud, kinagi di, “Deya iyán a tolay a magupos ti awan ti galang ten Diyos? Awan beman en Diyos la i maariyid a magpatawad ti kasalanan?” ");
INSERT INTO prfNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Peru gapu tukoy ni Jesus en ked ten isip di kaya kinagi na dikodi, “Bakin magisip kam ti kona haán? ");
INSERT INTO prfNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Ánya mas alistuwid a kagiyán ku ti lupugiday, ‘Pinatawad dán en kasalanan mu hidi,’ oni kagiyán ku a, ‘Tumaknág ka sakay maglakad ka?’ ");
INSERT INTO prfNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Peru tánni matukuyan moy a en Anak nen Tolay ay tehud a kapangyariyan ti lutaiday a magpatawad ti kasalanan,” kinagi na ten lupug, “Tumaknág ka, tawidán mu i págkatdugan muwen sakay umuli ka dán!” ");
INSERT INTO prfNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Pagdaka a tummaknág en lállaki, sakay ten atubengán nen atanan ay inágkat na en págkatdugan na sakay ummuli a nágpapuriyán ten Diyos. ");
INSERT INTO prfNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Nagtaka en atanan a ked haud sakay nagpuri hidi ten Diyos. Kinagi di, “Makataka-taka en bagay hidi a netan tam nadid!” ");
INSERT INTO prfNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Nadid, káttapos ni pangyayariyid a iyud ay lummuwas ti Jesus sakay netan na ti Levi a mágsinger ti buwes. Mággetnud siya ten págsingeran na ti buwes, sakay kinagi ni Jesus dikona, “Umunud ka dikoku.” ");
INSERT INTO prfNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Tummaknág ti Levi sakay tulos na a linakadan en atanan, ummunud sakay nagserbi kánni Jesus. ");
INSERT INTO prfNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Naghanda ti Levi ti dikál a handaan para kánni Jesus ten bilay na. Nakatubeng na haud a kuman en agum hidi a mágsinger ti buwes sakay en agum pa hidi a tolay. ");
INSERT INTO prfNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Nágganasasan en Pariseo hidi sakay en kaguman di hidi a tagapagtoldu nen Kautusan. Kinagi di ten disepulus hidi ni Jesus, “Bakin mákpággatubeng kam a kuman sakay uminom ti mágsingeren hidi ti buwes, sakay ti makasalananen hidi?” ");
INSERT INTO prfNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Tinábbig hidi ni Jesus, “Awan kailangan nen awan ti saket en mággamot nan en tehud la a saket. ");
INSERT INTO prfNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Awanák háddi ummangay tánni tulungan en matuwid nan ummangayák háddi tánni tulungan en makasalanan hidi tánni magsisi hidi.” ");
INSERT INTO prfNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Nadid, tehud a sangan a tolay a nagkagi kánni Jesus ti kona háddi: “En disepulus hidi ni Juan ay pirmi a magkulásyon sakay manalangin, kona bi hud en disepulus hidi nen Pariseo hidi. Bakin i disepulus muwen hidi ay tulos la a mágkakanán sakay mággainumán?” ");
INSERT INTO prfNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Tummábbig ti Jesus, “Pagkulásyonán moy beman en bisita hidi ten kasalan a kaguman di palla en lállaki a kinasal? ");
INSERT INTO prfNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Dumemát en aldew a alapán dán en kinasal, sakay saiyud dán en págkulásyon di.” ");
INSERT INTO prfNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Kinagi bi ni Jesus dikodi en essa a talinhaga: “Awan maari a mangtabas ten bigu a damit para iyáppol ten dati dán a damit. Mara ni konahud i mangyariyid ay masida en bigu a damit sakay awan nebabagay en bigu a inyáppol ten dati dán a damit. ");
INSERT INTO prfNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Awan bi ti magasák ti bigu a alak ten dati dán a pággasákkan a koblet ni hayup. Ni kona háud i mangyariyid ay páddekán nen bigu a alak en dati a pággasákkan, mágkebut en alak sakay masida en pággasákkan. ");
INSERT INTO prfNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Ni bigu a alak en iyasák ay dapat a bigu bi en pagasákkan a koblet ni hayup. ");
INSERT INTO prfNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Awan bi ti masor a manginom ten bigu a alak ni nakainom dán ten dati a alak. Kagiyán na a, ‘Masarap en dati a alak.’ ” ");
INSERT INTO prfNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Essa a Aldew nen Káimang, ay nagtalib de Jesus ten kaparayan. Nangkádtor en disepulus na hidi ten ohay nen paray sakay nágkásselan di. ");
INSERT INTO prfNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Peru kinagi nen sangan a Pariseo, “Bakin maggamet kam ti labag ten Kautusan ten Aldew nen Káimang?” ");
INSERT INTO prfNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Tummábbig ti Jesus, “Awan moy beman nabasa en ginamet ni David dikona nagaláp siya sakay en kaguman na hidi? ");
INSERT INTO prfNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Awan beman, summáddáp siya ten bilay nen Diyos, sakay kinuman ten tinapay a nealay a padi la i tehudid a karapatan a mangkan? Inátdenan na pa en kakagumanan na hidi.” ");
INSERT INTO prfNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Kinagi pa ni Jesus dikodi, “En Anak nen Tolay en Panginoon nen Aldew nen Káimang.” ");
INSERT INTO prfNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Aldew bi tenhud nen Káimang dikona a summáddáp ti Jesus ten sinagoga sakay nagtoldu. Tehud a essa haud a lállaki a awan makaarikad en kawanan na a lima. ");
INSERT INTO prfNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Nadid, binantayan nen tagapagtoldu hidi nen Kautusan sakay nen Pariseo hidi ti Jesus ni magpapiyya siya ten Aldew nen Káimang, tánni tehud hidi a mebintang dikona a linabag na en Kautusan ni Moises. ");
INSERT INTO prfNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Peru tukoy ni Jesus en ked ten isip di kaya kinagi na ten lállaki a awan makaarikad en essa na a lima, “Karon hád, angay ka ti atubengánnidi.” Ummadeni ngani en lállaki sakay tummaknág ten atubengán. ");
INSERT INTO prfNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Sakay kinagi ni Jesus ten tagapagtoldu hidi nen Kautusan sakay ten Pariseo hidi, “Tanungán takam nadid. Hádya tamaid ten Kautusan, en maggamet ti maganda oni maggamet ti madukás ten Aldew nen Káimang? En mángligtas ti biyag oni mamunu?” ");
INSERT INTO prfNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Inileng ni Jesus en balang essa ten palebut na sakay kinagi na ten lállaki a, “Iyolnat mu i lima muwen!” Ten páng-olnat na ten lima na ay pagdaka iyud a nagpiyya. ");
INSERT INTO prfNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Tunay ti iyamut en tagapagtoldu hidi nen Kautusan sakay en Pariseo hidi, namággurunan di ni ánya i dapat diyid a gamitán kánni Jesus. ");
INSERT INTO prfNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Ti panahunid a iyud ay summangkay ti Jesus ten essa a bukid sakay sagibi siya haud a nagdasal ten Diyos. ");
INSERT INTO prfNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Ten kailawan, ay dinulaw na en disepulus na hidi, sakay nangpili siya dikodi ti sapulu ay ti duwwa, sakay nginaranan na hidi a apostol. ");
INSERT INTO prfNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Hidi ay de Simon en nginaranan ni Jesus a Pedro, sakay ti Andres a wadi ni Pedro; de Santiago, Juan, Felipe, Bartolome, ");
INSERT INTO prfNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mateo, Tomas, sakay Santiago a anak ni Alfeo, ti Simon a makabanuwan, ");
INSERT INTO prfNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","ti Judas a anak ni Santiago, sakay ti Judas Iscariote a nángtokyon dikona. ");
INSERT INTO prfNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Káugsad ni Jesus a kaguman en apostol na hidi, ay dinemáttan di ten patag a lugar en kakpalan ten disepulus na hidi, kaguman en tunay ti kakpal a tolay a gubwat ti Judea, Jerusalem, sakay ten banu-banuwan ten gilid nen diget ti Tiro sakay Sidon. ");
INSERT INTO prfNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Ummangay hidi haud tánni mágsanig, sakay mapagpiyya ten saket di hidi. Pinagpiyya ngani hidi ni Jesus maski en páppahirapan nen mágkadukás a ispiritu. ");
INSERT INTO prfNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Pinilit nen atanan a tehud a saket a umadeni dikona tánni matawidan di la siya, gapu tehud siya a kapangyariyan a magpapiyya ten atanan a saket. ");
INSERT INTO prfNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Ummileng ti Jesus ten disepulus na hidi, sakay kinagi na, “Pinagpala kam a pubri hidi, gapu maghari dikomoy en Diyos! ");
INSERT INTO prfNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","“Pinagpala kam a magaláp hidi nadid, gapu bássugán kam nen Diyos! Pinagpala kam a malungkut hidi nadid, gapu pasayaán na kam! ");
INSERT INTO prfNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","‘Pinagpala kam ni gapu ten kássunud moy ten Anak nen Tolay ay kaiyamutan di kam, awan di kam kailangan sakay insultuwán di kam sakay kagiyán di kam a madukás. ");
INSERT INTO prfNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Ni mangyari iyád dikomoy ay dapat kam a magsaya, lumuksu kam ti saya moy gapu dikál en piremyu moy dilanget. Kona labi hud en ginággamet nen ninunu di hidi ten propeta hidi. ");
INSERT INTO prfNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Peru sikam a mágkayaman hidi nadid ay kakakagbi kam, gapu nagtamasa kamon ti ginhawa. ");
INSERT INTO prfNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","“Sikam a bássug hidi nadid ay kakakagbi kam, gapu alappán kam! “Sikam a mágtatawaán hidi nadid ay kakakagbi kam, gapu magin malungkut kam sakay mágsasangitán. ");
INSERT INTO prfNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","“Kakakagbi kam ni puriyán kam nen atanan a tolay, gapu kona labi hud ginametid nen ninunu di hidi ten awan hidi tatarudan a propeta.” ");
INSERT INTO prfNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Peru kagiyán kuwid dikomoy a mágsanig hidi dikoku: Mahalán moy en kadima moy hidi, sakay maggamet kam ti maganda ten maiyamut hidi dikomoy. ");
INSERT INTO prfNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Pagpalaán moy en mangsumpa hidi dikomoy, sakay ipagdasal moy en mangapi hidi dikomoy. ");
INSERT INTO prfNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Mara ni dapangán di ka ten dilipot mu a rupa ay padapang mu pa en dilipot. Mara ni alapán di en alikábkáb mu ay iyatád mu pati en badu mu. ");
INSERT INTO prfNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Átdenan mu en balang mággid dikomu, sakay ni alapán di en ari-ariyan mu ay dyan mu dán pesoli. ");
INSERT INTO prfNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Ni ánya en gustu mu a gamitán nen agum a tolay dikomu ay saiyud bi gamitán muwid dikodi. ");
INSERT INTO prfNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Ni en magmahal la dikomoy mahalán moyid, ánya padi urayán moyid a piremyu? Maski labi en makasalanan hidi ay mahalán di en magmahal dikodi. ");
INSERT INTO prfNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","“Sakay ni en maggamet la dikomoy ti maganda i paggamitan moyid ti maganda, ánya padi urayán moyid a piremyu? Maski labi en makasalanan hidi ay kona haán en gamet di. ");
INSERT INTO prfNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ni en makabayad la dikomoy i paáddiman moyid, ánya padi urayán moyid a piremyu? Maski en makasalanan hidi ay magpaáddem bi ten kaparehu di a makasalanan gapu umasa hidi a mabayadan. ");
INSERT INTO prfNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Dapatid ay mahalán moy en kadima moy hidi, sakay maggamet kam ti maganda dikodi. Magpaáddem kam peru dyan kamon umasa ten ányaman a bayad. Ni magkakonahud ay dikál en piremyu a matanggap moy sakay magin anak kam nen Kataasan a Diyos. Gapu en Diyos ay makákkagbiyán maski ten mágkadukás hidi a tolay, sakay ten awan hidi makabetu a tumenggi ti utang a luub. ");
INSERT INTO prfNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Dapatid ay makákkagbiyán kam a kona ten Ama moy.” ");
INSERT INTO prfNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Dyan kam maghatul tánni awan kam hatulan. Dyan kam magparusa tánni awan kam parusaan nen Diyos. Patawadán moy en kaparehu moy a tolay tánni patawadán kam bi nen Diyos. ");
INSERT INTO prfNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Mangatád kam tánni átdenan kam bi nen Diyos: ti tama a takal, nadasák a tarud, natádtád, sakay magsepway pa en iyatád dikomoy. Gapu ni konya kam a mangatád ay kona labi hud pangatáddid nen Diyos dikomoy.” ");
INSERT INTO prfNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Tinanung bi hidi ni Jesus ti talinhaga, kinagi na, “Maari beman a igiyya nen burák en kaparehu na a burák? Awan! Parehu hidi a matáppduk ten ábbut ni gamitán di iyud. ");
INSERT INTO prfNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Awan ti disepulus a mas mataas nan ten maistu na. Peru ni matolduwan dán ti mahusay ay kona dán bi siya ten maistu na.” ");
INSERT INTO prfNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Bakin barángngán mu en puleng nen kapatkaka mu? Samantala siko, awan mu la mabaráng en puleng mu a gaturosu? ");
INSERT INTO prfNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Konya mu a kagiyán ten kapatkaka mu a, ‘Kapatkaka, ibutan ku i puleng muwen,’ samantala siko ay awan mu ketan en gaturosu mu a puleng? Magkukunwari ka pa! Ibutan mu pa i puleng muwen a gaturosu tánni maketa ka ti maganda sakay maibutan mu en puleng nen kapatkaka mu.” ");
INSERT INTO prfNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Magandaid a kayu ay awan magbunga ti madukás. Awan bi ti madukás a kayu a magbunga ti maganda. ");
INSERT INTO prfNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Matenggi en bawat kayu ten pamamag-itan nen bunga na. Gapu awan ka makapusi ti igos ten masaet a mula oni ubas ten dawag hidi. ");
INSERT INTO prfNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","En mabait a tolay ay maggamet ti maganda a gubwat ten pusu na a putat ti kagandaan. Peru en madukás a tolay ay maggamet ti madukás a gubwat ten pusu na a putat ti kadukássan. Gapu ni ánya en ked ten pusu na ay siya en lumuwas ten ngusu na.” ");
INSERT INTO prfNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Bakin a dáddulawanák moy a, ‘Panginoon, Panginoon,’ peru awan moy labi gággamitán en kákkagiyán ku? ");
INSERT INTO prfNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Kagiyán ku dikomoy ni ánya en kaparehu nen tolay a umadeni dikoku, mágsanig ten upos ku hidi, sakay mánggamet ti hidi iyád. ");
INSERT INTO prfNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Kona siya ten tolay a naggamet ti bilay a nagkotkot ti madisalad sakay impundasyon na en bilay na ten batu. Dikona dummikál en dinom sakay dinapalis na en bilay ay awan iyud naarikad, gapu matibáng en kagagamet na. ");
INSERT INTO prfNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Peru en mágsanig bi ten upos ku sakay awan na gamitán ay kona ten essa a tolay a naggamet ti bilay a awan nakapundasyon. Dikona dummikál en dinom sakay dinapalis na en bilay ay pagdaka iyud a natumba sakay narukat-rukat.” ");
INSERT INTO prfNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Nadid, káttapos ni Jesus a nagtoldu ten tolay hidi, ay ummangay siya ten banuwan a Capernaum. ");
INSERT INTO prfNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Tehud haud a essa a kapitan nen sundalu hidi a Romano. Tehud siya a alipin a mahal na a tehud a saket sakay magipepatay dán. ");
INSERT INTO prfNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Dikona natukuyan nen kapitan en tungkul kánni Jesus, ay inutusan na en sangan a pinunu nen Judio hidi tánni ipákpágguron di kánni Jesus a angen na pagpiyyaán en alipin. ");
INSERT INTO prfNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Dikona makaadeni en inutusan hidi kánni Jesus ay nákpágguron hidi ti mahusay dikona, kinagi di a, “Panginoon, nerarapat la a tulungan mu en kapitan ");
INSERT INTO prfNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","gapu mahal na en bansa tam. Ti katunayan na ay nagpagamet na kitam ti essa a sinagoga.” ");
INSERT INTO prfNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Nákkuyug ti Jesus dikodi, peru dikona adeni dán siya ten bilay ay natagbu na en amigu hidi nen kapitan. Inutusan hidi nen kapitan para pekagi na kánni Jesus en kona háddi: “Panginoon, dyan ka dán magabala, gapu awanák karapatdapat a angayan mu ten bilay ku. ");
INSERT INTO prfNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Sakay awanák pa bi karapatdapat a umatubeng dikomu, nan kagiyán mu la ay magpiyya dán en alipin ku. ");
INSERT INTO prfNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Sakupák nen pinunu hidi a mas mataas nan sikán, sakay tehudák bi a nasakupan a sundalu hidi; ni kagiyán ku ten essa a, ‘Angay ka hudi!’ ay sumunud iyud. Ni kagiyán ku bi ten essa a, ‘Karon hád!’ ay umadeni iyud. Ni kagiyán ku bi ten alipin ku a, ‘Gamitán mu iddi!’ ay gamitán na iyud.” ");
INSERT INTO prfNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Nagtaka ti Jesus dikona nasanig na iyud, ummatubeng siya ten makpal a tolay a umunonud dikona sakay kinagi na, “Kagiyán ku dikomoy a, maski ti Israel ay awanák naketa ti kona háddi a kadikál ni pánnampalataya.” ");
INSERT INTO prfNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Ten kássoli nen inutusan hidi ten bilay nen kapitan, ay dinemáttan di en alipin a nagpiyya dán. ");
INSERT INTO prfNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Káttapos ay ummangay ti Jesus ten essa a banuwan a nginaranan di a Nain. Nákkuyug en disepulus na hidi sakay en tunay a kakpal a tolay. ");
INSERT INTO prfNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Dikona adeni dán siya ten pintuwan nen banuwan, ay natagbu di en tolay hidi a angay manglábbáng ten eessa a anak a lállaki nen bilu a bábbi. Makpal a tarud en mákpanglábbáng. ");
INSERT INTO prfNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Dikona netan nen Panginoon en ina nen natay ay kinagbiyan na, kaya kinagi na dikona, “Dyan ka magsanget.” ");
INSERT INTO prfNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Káttapos ay ummadeni siya sakay tinawidan na en páppágyanan nen patay. Ummimang bi en magusung hidi ten patay, sakay kinagi ni Jesus, “Binata, kagiyán ku dikomu, umikat ka!” ");
INSERT INTO prfNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Ummetnud en binata sakay nagupos. Sakay inyatád siya ni Jesus ten ina na.” ");
INSERT INTO prfNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Neántingan hidi a atanan sakay nagpuri hidi ten Diyos. Kinagi di, “Dummemát dikotam en dakila a propeta! Binisita nen Diyos en banuwan na.” ");
INSERT INTO prfNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Kummalat en bareta tungkul ten ginamet ni Jesus ten buu a Judea sakay ten banuwan hidi a ked ten palebut. ");
INSERT INTO prfNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Nadid, imbareta nen disepulus hidi ni Juan dikona en atanan ni pangyayariyid a hidi iyád. Kaya dinulaw ni Juan en duwwa dikodi ");
INSERT INTO prfNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","sakay pinaangay na hidi ten Panginoon tánni itanung di ni siya dán en nepangaku a dumemát, oni maguray pa hidi ti agum. ");
INSERT INTO prfNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Káddemát di kánni Jesus ay kinagi di, “Pinaangay kami háddi ni Juan a Mágbinyag gapu petanung na ni siko dán en impangaku a dumemát, oni maguray kami pa ti iba?” ");
INSERT INTO prfNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Ti odasid a iyud ay makpal en pinagpiyya ni Jesus ten tehud hidi a manga saket, mahigpit a bábbatiyán, en sináddáp hidi ni mágkadukás a ispiritu sakay makpal bi a burák en pinaketa na. ");
INSERT INTO prfNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Kinagi ni Jesus ten disepulus hidi ni Juan, “Sumoli kamon kánni Juan sakay kagiyán moy dikona en netan moy sakay nasanig; maketa dán en burák hidi, makalakad dán en pilay hidi, nagpiyya dán en kinetong hidi, makasanig dán en bángngág hidi, nabiyag a ruway en patay hidi, sakay ipáppangaral en Maganda a Bareta ten pubri hidi. ");
INSERT INTO prfNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Pinagpala en tolay a awan magduda dikoku!’ ” ");
INSERT INTO prfNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Kállakad nen disepulus hidi ni Juan ay tehud a kinagi ti Jesus ten tolay hidi tungkul kánni Juan, “Bakin ummangay kam ten kaparangan? Ánya beman gustu moyid a ketan? Gustu moy beman a maketa ti kugun a idáppay-dáppay ni parás? ");
INSERT INTO prfNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Ánya beman i talagaid a angen moy ilingán ten kaparangan? Essa a tolay a nakabadu ti mágkamahal? En tolay hidi a magbadu ti mágkamahal sakay mahusay ti kalagayan ti biyag, ay mágyan ten palasyu nen hari hidi. ");
INSERT INTO prfNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Kagiyán moy dikoku ni ánya i talagaid a gustu moy a ketan? Essa beman a propeta? Tama kam. Peru kagiyán ku dikomoy a mas mataaas pa siya nan ten propeta. ");
INSERT INTO prfNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Gapu ti Juan en kinagi nen kasulatan a, ‘Siya iddi en paangayán ku a mágdipalongu dikomu, tánni ihanda na en paglakadan mu.’ ");
INSERT INTO prfNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Kagiyán ku dikomoy, a awan palla ti neenak a mas mataas nan ti Juan. Peru mas mataas kánni Juan en kababaan ten kahariyan nen Diyos.” ");
INSERT INTO prfNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","En atanan a tolay a nakasanig dikona, maski en mágsinger hidi ti buwes ay summunud ten Diyos. Bininyagan hidi a atanan ni Juan. ");
INSERT INTO prfNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Peru en Pariseo hidi sakay en tagapagtoldu hidi nen Kautusan ay inadiyan di en kaluuban nen Diyos para dikodi, awan hidi nagpabinyag kánni Juan. ");
INSERT INTO prfNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Kinagi pa ni Jesus, “Ánya wád i maari kuwid a pángparehuwan ten tolay hidi nadid? Ánya kaparehu diyid? ");
INSERT INTO prfNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Kona hidi ten anak a bábbadit a mamággetnud ten palengki. Ipáppákraw di ten balang essa a, ‘Tinugtugan mi kam ti plauta, peru awan kam nagsayaw! Nagkansiyon kami ti panglábbáng, peru awan kam nákpagsanget!’ ");
INSERT INTO prfNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Gapu ummangay háddi ti Juan a Mágbinyag, mágkulásyon siya sakay awan umminom ti alak, peru kinagi moy a hinayup siya. ");
INSERT INTO prfNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Dikona dummemát bi en Anak nen Tolay, ay kuman sakay uminom. Peru kinagi moy a, ‘Ilingán moy i tolayen, maunas sakay lasinggeru! Amigu pa nen mágsinger hidi ti buwes sakay nen makasalanan hidi!’ ");
INSERT INTO prfNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Peru en karunungan nen Diyos ay ketan a tama ten pamamag-itan nen gamet nen tagasunud na hidi.” ");
INSERT INTO prfNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Nadid, inimbitaan ni Simon a Pariseo ti Jesus a angay kuman ten bilay na. Ummangay ti Jesus sakay nákpággatubeng siya a kumman. ");
INSERT INTO prfNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Ti banuwanid a iyud ay tehud a essa a bábbi a makasalanan. Ten pákkabareta na a pasiyaan a kuman ti Jesus ten bilay nen Pariseo ay ummangay siya haud. Nagtawid siya ti essa boti a putat ti mahal a págpasárrub. ");
INSERT INTO prfNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Káddemát na haud ay ummadeni siya ten áadággan ni Jesus a adeni ten básset na, sakay nagsanget, binisa na ten luwa na en básset ni Jesus. Pinahidan na ten buuk na, sakay inámmuwan na. Káttapos ay binulakan na ten págpasárrub. ");
INSERT INTO prfNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Dikona a ketan iyád nen Pariseo a nangimbita kánni Jesus ay nagisip siya ti kona háddi: ‘Ni talaga a propeta i tolayiday ay dapat nakuwan a tukoy na a essa makasalanan i bábbiyen a nagtawid ti básset naen.’ ");
INSERT INTO prfNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Bilang katábbigan ten ked ten isip ni Simon ay kinagi ni Jesus, “Simon, tehudák a kagiyán dikomu.” “Ánya iyud, Maistu?” kagi ni Simon. ");
INSERT INTO prfNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Tulos a kinagi ni Jesus, “Tehud a duwwa a tolay a nangáddem ti pilak ten essa a mágpautang; en ináddem nen essa ay limma datos a pilak a silber, sakay en essa bi ay limmapulu a pilak a silber. ");
INSERT INTO prfNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Dikona parehu hidi a awan nakabayad ten utang di ay pinatawad hidi nen nangutangan di. Nadid i tanung kuwid dikomu, ay deya ten duwwa en mas mangmahal ten nagpautang dikodi?” ");
INSERT INTO prfNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Tummábbig ti Simon, “Palagay kuwid ay en pinatawad ten dikál ti inutang.” “Tama ka,” kagi ni Jesus. ");
INSERT INTO prfNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Káttapos ay sinulig na en bábbi sakay kinagi na kánni Simon a, “Netan mu i bábbiyidi? Summáddáppák ti bilay muwidi peru awan ka dálla nangatád ti dinom a pagugasan ku ti básset kuwiday. Peru i bábbiyidi ay binisa na ten luwa na i básset kuwidi, sakay pinahidan na ten buuk na.” ");
INSERT INTO prfNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Awanák mu inámmuwan a binati, peru siya ay awan umimang a mággaámmuwán ti básset kuwiday sapul ten kássáddáp na. ");
INSERT INTO prfNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Awan mu pinahidan ti langis i ulu kuwiday, peru siya ay pinahidan na ti págpasárrub i básset kuwiday. ");
INSERT INTO prfNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Kaya kagiyán ku dikomu, kagi ni Jesus, “En dikál a págmahal a impeta na mangpatunayid a pinatawad dán en makpal na a kasalanan. Peru en napatawad ten sabadit la a kasalanan ay sabadit labi en págmahal a mepeta na.” ");
INSERT INTO prfNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Káttapos ay kinagi na ten bábbi a, “Pinatawad ka dán ten kasalanan mu hidi.” ");
INSERT INTO prfNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","En kaguman na hidi a kumman ay magtanung dán ten sadi-sadili di, “Deya wád iyád a katolay, pati págpatawad ti kasalanan ay pangahasan na?” ");
INSERT INTO prfNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Peru kinagi ni Jesus ten bábbi a, “Inligtas ka nen pánnampalataya mu, umuli ka dán a mapayapa.” ");
INSERT INTO prfNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Awan nagnalay ay linebut ni Jesus en banu-banuwan sakay ten babaryu. Impangaral na sakay intoldu en Maganda a Bareta tungkul ten pághari nen Diyos. Kaguman na en sapulu ay ti duwwa a disepulus na, ");
INSERT INTO prfNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","sakay en sangan a bábbi a pinagpiyya na ten mágkadukás a ispiritu sakay ten saket di hidi: ti Maria Magdalena a nangpalakadan ni Jesus ten pittu a dimonyo, ");
INSERT INTO prfNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","ti Juana a kabinga ni Cusa a katiwala ni Herodes; ti Susana, sakay en agum pa hidi. Ginastus di en sadili di a ari-ariyan ten káttulung di kánni Jesus sakay ten disepulus na hidi. ");
INSERT INTO prfNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Nagdemáttan pa en tolay hidi a gubwat ten iba-iba a banuwan sakay ummadeni hidi kánni Jesus. Dikona naipun-ipun dán en tunay ti kakpal a tolay ay insaysay ni Jesus i talinhagaid a iddi: ");
INSERT INTO prfNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Tehud a essa a mágsabug a ummangay ten uma na tánni magsabug. Ten págsabug na ay tehud a naragrag a bine ten dilan, nagámmakan iyud nen katolayan sakay tinoktok nen ibun hidi. ");
INSERT INTO prfNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Tehud bi a bine a naragrag ten kabatuwan sakay nagtubu, peru pagdaka a nalanás gapu mamadi en kabatuwan. ");
INSERT INTO prfNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Tehud bi a naragrag ten kalamonan a masaet. Dikona lumagu en kalamonan ay binurebáddan di en bine a nagtubu. ");
INSERT INTO prfNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","En agum ay naragrag ten maganda a luta. Nagtubu hidi iyud sakay nagbunga ti tággidatos a butil. Kinagi pa ni Jesus ti mabegsák, “Mágsanig en tehud a págsanig!” ");
INSERT INTO prfNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Nagtanung en disepulus na hidi ni ánya en kahulugan nen talinhaga a kinagi na. ");
INSERT INTO prfNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Tummábbig ti Jesus, “Neatád dán dikomoy en karapatan a maintendiyan en lihim tungkul ten pághari nen Diyos. Peru ten agum ay magupusák ten pamamag-itan nen talinhaga tánni, ‘Maski umileng hidi ay awan hidi ti ketan, Sakay maski ni mágsanig hidi ay awan hidi ti maintendiyan.’ ” ");
INSERT INTO prfNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Saiddi kahuluganid nen talinhaga: en bine ay en upos nen Diyos. ");
INSERT INTO prfNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","En bine hidi a naragrag ten gilid nen dilan ay en tolay hidi a nágsanig. Peru dummemát en diyablo sakay inibutan na en Upos ten pusu nen mágsanig hidi tánni awan hidi sumampalataya sakay maligtas. ");
INSERT INTO prfNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","En nágkeragrag bi hidi ten kabatuwan ay en nakasanig hidi ten Upos sakay tinanggap di a masaya, peru awan iyud tummiim ten pusu di. Awan la nalay a naniwala hidi, káddemát nen pagsubuk ay hinumiwalay hidi. ");
INSERT INTO prfNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","En nágkeragrag bi hidi ten kalamonan a masaet ay en nágsanig hidi ten upos nen Diyos, peru dikona umalay, ay nadaig hidi nen kabalisaan hidi ti biyag, kayamanan sakay ten sor di a mapagustuwan ten ányaman a magustuwan di. Kaya awan malutu en bunga di hidi. ");
INSERT INTO prfNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Sakay en nesabug bi ten matabi a luta ay en nágsanig hidi ten upos nen Diyos sakay pinahalagaan di ten pusu di a matapat sakay malinis, sakay magbunga hidi gapu ten tiyaga di.” ");
INSERT INTO prfNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Awan ti tolay a magtab ti simbuwan sakay taklábban na ti timba oni isarok na ten katri. Nan itupu na iyud ten talaga a págtupuwan tánni mademlagan en sumáddáp hidi ten bilay. ");
INSERT INTO prfNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Awan ti netagu a awan melantad, sakay awan ti lihim a awan mehayag.” ");
INSERT INTO prfNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","“Kaya husayán moy en págsanig moy, gapu en tehud ay átdenan pa, peru en awan ay ibutan pa maski en inakala na a ked dikona.” ");
INSERT INTO prfNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Dummemát en ina sakay kákkapatkaka hidi ni Jesus, peru awan hidi makaadeni dikona gapu ten kakpal nen tolay. ");
INSERT INTO prfNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Kaya tehud a nángkagi dikona a, “Ked ti luwason a mágtaknág en ina mu sakay en kákkapatkaka mu hidi, gustu di ka a ketan.” ");
INSERT INTO prfNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Peru kinagi ni Jesus, “En mágsanig hidi sakay mangsunud ten upos nen Diyos, ay hidi i ina kuwid sakay kákkapatkaka ku.” ");
INSERT INTO prfNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Nadid, ten essa a aldew ay summakay de Jesus ay ten disepulus na hidi ten abeng. Kinagi na dikodi, “Umarabes kitam dibelyu.” Kaya ummarabes ngani hidi. ");
INSERT INTO prfNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Dikona pasiyaan dán hidi a maggaud ay netidug ti Jesus. Nagabutan hidi ni mabegsák a bagyu, sakay sináddáp dán ni limas en abeng di, kaya ngari-ngari dán hidi a omlád. ");
INSERT INTO prfNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Kaya inadeniyan siya nen disepulus hidi sakay linukag di. Kinagi di, “Panginoon, Panginoon, marombak kitamon!” Ummikat ti Jesus sakay pinaimang na en parás ay ten dáddekál a tagmák. Ummimang ngani en parás ay ten tagmák sakay gummanda en panahun. ");
INSERT INTO prfNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Nadid ay tinanung hidi ni Jesus, “Hádya dán en pánnampalataya moy?” Peru neántengan hidi sakay nagtaka. Kagi di ten balang essa, “Deya wád iyád? Utusan na pati parás ay ti tagmák sakay sumunud dikona!” ");
INSERT INTO prfNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Dummung hidi ten lugar nen Gergeseno hidi, a ked ten dibelyu ni Galilea. ");
INSERT INTO prfNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Káawas ni Jesus ten abeng, ay tinagbu siya nen essa a lállaki a taga haud a sináddáp ni dimonyo. Nanalay dán siya a awan ti badu sakay awan dán ummuli nan ten páglábbángngan en páppágyanan na. ");
INSERT INTO prfNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Pákketa na kánni Jesus ay pummákraw en lállaki, lummuhud ten atubengán ni Jesus sakay kinagi na ti mabegsák, “Jesus Anak nen Kataasan a Diyos, ánya i gustu muwid a gamitán dikoku? Ipákpágguron ku dikomu a dyanák mu pahirapan!” ");
INSERT INTO prfNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Kaya konahud en kinagi na ay gapu inutusan ni Jesus en madukás a ispiritu a lumuwas dikona. (Pirmi siya a sássaniban nen mágkadukás a ispiritu. Kaya maski ni pakabantayan di siya sakay punguwán di ti kadena en básset na ay ten lima na ay bágsután na la iyud. Iyangay siya nen madukás a ispiritu ten kaparangan.) ");
INSERT INTO prfNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Tinanung siya ni Jesus, “Ánya i ngaran muwid?” “Batalyon,” kagi na gapu makpal en dimonyo a summanib dikona. ");
INSERT INTO prfNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Nadid, nákkekagbi en dimonyo hidi kánni Jesus a dyan na hidi utusan a sumegbu ten ábbut a awan ti katapusan ti kadsalad. ");
INSERT INTO prfNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Nadid, tehud a makpal a babuy a mamagsábbukan ten bumábbukid a adeni haud. Nákkekagbi en dimonyo hidi kánni Jesus a pasáddáppán na hidi ten kababuyan, sakay pinayagan bi hidi ni Jesus. ");
INSERT INTO prfNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Lummuwas ten tolay en dimonyo hidi sakay sinomdáp hidi ten kababuyan. Pagdaka a namagginanan en kababuyan a padagson sakay tulos hidi a nágkatáknig ten minalnu sakay nágkalimás. ");
INSERT INTO prfNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Pákketa nen mággalaga hidi ten kababuyan ten nangyari, ay gumminan hidi sakay imbábbareta di iyud ten banuwan sakay ten babaryu. ");
INSERT INTO prfNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Kaya lummuwas en tolay hidi gapu gustu di a ilingán en nangyari. Káddemát di kánni Jesus ay netan di en tolay a dati a sináddáp nen dimonyo hidi. Nággetnud siya ten táttaknággan ni Jesus, nakabadu dán siya sakay mahusay dán en isip na. Neántingan hidi a atanan. ");
INSERT INTO prfNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Insaysay bi nen naketa hidi ten nangyari ten katolayan ni konya a nagpiyya en lállaki a dati a sináddáp nen dimonyo hidi. ");
INSERT INTO prfNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Kinagi nen atanan nen Gergeseno hidi kánni Jesus a lumakad dán siya ten banuwan di gapu tunay en ánteng di. Kaya summakay dán ti Jesus ten abeng sakay lummakad. ");
INSERT INTO prfNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Nadid, nákkekagbi kánni Jesus en lállaki a linakadan nen dimonyo hidi a kinagi na, “Mákkuyugák pay dikomu.” Peru kinagi ni Jesus dikona, ");
INSERT INTO prfNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Kadmudán dibilay moy sakay ibareta mu en ginamet nen Diyos dikomu.” Lummakad ngani en lállaki sakay imbábbareta na ten buu a banuwan en ginamet ni Jesus dikona. ");
INSERT INTO prfNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Dikona a nagsoli ti Jesus ten dibelyu, ay masaya siya a tinanggap nen katolayan gapu áorayán di dán siya. ");
INSERT INTO prfNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Dummemát tenhud en essa a lállaki a Jairo en ngaran na, essa siya a pinunu ten sinagoga. Lummuhud siya ten atubengán ni Jesus, sakay nákkekagbi a umangay ti Jesus ten bilay na. ");
INSERT INTO prfNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Gapu magipepatay dán en eessa a anak na a bábbi, sapulu dán ay ti duwwa a taon en idad na. Mentras a maglakad ti Jesus a tamu ten bilay ni Jairo ay sássánsánnán siya nen makpal a tolay. ");
INSERT INTO prfNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Ked bi haud en essa a bábbi a sapulu ay ti duwwa dán a taon a mágdadigiyán sakay awan mapagpiyya nen deyaman. Naubus dán en atanan a kabiyagan na gapu ti págpapagamot. ");
INSERT INTO prfNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Ummadeni siya ten áadággan ni Jesus sakay tinawidan na en garayan nen badu na. Pagdaka a ummimang en págdadigi na. ");
INSERT INTO prfNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Tinanung hidi ni Jesus, “Deya en nangtawid ten badu ku?” Ten dikona awan ti umamin ay kinagi ni Pedro, “Panginoon, napalebutan ka ni tolayen hidi sakay sássánsánnán di ka!” ");
INSERT INTO prfNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Peru kinagi ni Jesus, “Tehud a nangtawid ten badu ku! Nabati ku a tehud a kapangyariyan a lummuwas dikoku.” ");
INSERT INTO prfNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Dikona matukuyan nen bábbi a awan bali melihim en ginamet na, ay magpágpág siya a ummadeni kánni Jesus sakay lummuhud ten atubengán na. Sakay kinagi na ten atanan a ked haud ni bakin tinawidan na en badu ni Jesus, sakay ni konya siya a nagpiyya a pagdaka. ");
INSERT INTO prfNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Kinagi ni Jesus dikona, “Anak ku pinagpiyya ka nen pánnampalataya mu. Umuli ka a mapayapa.” ");
INSERT INTO prfNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Mentras a magupos ti Jesus ay tehud a dummemát a essa lállaki a gubwat ten bilay ni Jairo. “Patay dán en anak mu a bábbi dyan mu dán abalaán i Maistuwen!” kagi na kánni Jairo. ");
INSERT INTO prfNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Dikona a nasanig iyud ni Jesus ay kinagi na kánni Jairo, “Dyan ka manteng, maniwala ka la ay magpiyya siya.” ");
INSERT INTO prfNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Káddemát ni Jesus ten bilay, ay awan siya ti iba a ingkuyug ten sáddáp nan de Pedro, Juan, Santiago sakay en dáddikál hidi nen dalagita. ");
INSERT INTO prfNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Mamagsangetan en atanan a ked haud sakay maglungkut ten patay. Peru kinagi ni Jesus, “Dyan kam magsanget. Awan patay i anaken, nan tidug la.” ");
INSERT INTO prfNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Nagtawaan di ti Jesus gapu tukoy di a patay dán en dalagita. ");
INSERT INTO prfNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Peru tinawidan ni Jesus en lima na sakay kinagi na, “Anak ku, umikat ka.” ");
INSERT INTO prfNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Summoli en angás nen dalagita sakay pagdaka a ummikat. Káttapos ay pinaatád siya ni Jesus ti makan. ");
INSERT INTO prfNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Naráknid en dáddikál na hidi, peru imbilin ni Jesus dikodi a dyan di kagiyán maski kándeya en nangyari. ");
INSERT INTO prfNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Dinulaw ni Jesus en disepulus na hidi a sapulu ay ti duwwa, sakay inátdenan na hidi ti kapangyariyan sakay karapatan a magpalayas ti dimonyo, sakay magpapiyya ten tehud hidi a saket. ");
INSERT INTO prfNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Inutusan na hidi a angay mangaral tungkul ten pághari nen Diyos sakay magpapiyya ten tehud hidi a saket. ");
INSERT INTO prfNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Sakay imbilin na dikodi a, “Dyan kam magbalon ti maski ni ányaman ten angayan moy kona ti sarukud, hembeg, makan, pilak oni paglewasan. ");
INSERT INTO prfNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Máktulos kam ten bilay nen deyaman a mangtanggap dikomoy. Mágyan kam la haud mentras awan kam palla lumakad ti banuwanid a iyud. ");
INSERT INTO prfNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Mara ni awan kam tanggapán nen tolay hidi ten essa a banuwan ay lumakad kam haud. Peru bagu kam a lumakad ay ipagpag moy pa en alikabuk nen babásset moy, tanda iyud a tehud hidi a parusa ten awan di pángtanggap dikomoy.” ");
INSERT INTO prfNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Sakay lummakad en disepulus na hidi. Angay hidi nangaral ten babaryu tungkul ten Maganda a Bareta sakay pinagpiyya di en tehud hidi a saket ten atanan a lugar. ");
INSERT INTO prfNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Nadid, nabareta ni Herodes a pinunu ti Galilea en atanan a nangyari. Naguluwan en isip na, gapu tehud a sangan a nagkagi a nabiyag a ruway ti Juan a Mágbinyag. ");
INSERT INTO prfNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Tehud bi a sangan a nagkagi a lummitaw ti Elias, sakay kagi bi nen agum ay nabiyag a ruway en essa ten propeta hidi tenhud pa a panahun. ");
INSERT INTO prfNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Kaya kinagi ni Herodes, “Pinaputol ku dán en ulu ni Juan, peru deya wád nabareta kuwiday? Makpalák a nasanig tungkul dikona.” Kaya pinilit ni Herodes a ketan ti Jesus. ");
INSERT INTO prfNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Nadid, dikona nagsoli en apostol hidi ay kinagi di kánni Jesus en atanan a ginamet di. Káttapos ay ingkuyug hidi ni Jesus a ummangay ten banuwan a Betsaida. ");
INSERT INTO prfNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Ummunud en tolay hidi dikona matukuyan di, sakay masaya hidi a tinanggap ni Jesus. Tinolduwan na hidi tungkul ten pághari nen Diyos, sakay pinagpiyya na en tehud hidi a saket. ");
INSERT INTO prfNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Dikona a mágsasasarám dán en aldew ay ummadeni kánni Jesus en disepulus na hidi a sapulu ay ti duwwa, sakay kinagi di dikona, “Palakadán mu dán i tolayen hidi tánni umangay hidi ti a babaryuwen sakay uma, tánni makaaryok hidi ti makan di sakay matidugan. Ked kitam ti adeyuwidi a lugar a awan ti tolay.” ");
INSERT INTO prfNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Peru kinagi ni Jesus, “Sikam i mangatáddid ti makan dikodi.” Kagi di ay, “Awan kitam ti balon, lilimma la iddi a mommon a tinapay, sakay duwwa a ikan. Mamali kami beman para ti atanan diyen?” ");
INSERT INTO prfNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Peru kinagi na ten disepulus na hidi, “Paetnudán moy hidi a atanan ti táglalimmapulu balang essa a grupu.” Tehud a limmang libu en lállaki hidi a ked haud. ");
INSERT INTO prfNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Pinággetnud di ngani hidi a atanan. ");
INSERT INTO prfNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Káttapos ay inalap ni Jesus en limma a mommon a tinapay sakay en duwwa a ikan. Tummangad siya dilanget sakay nagpasalamat ten Diyos. Tináppeng-táppeng na iyud sakay inyatád na ten disepulus na hidi tánni itagtag di ten katolayan. ");
INSERT INTO prfNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Nakakan hidi a atanan sakay nágkabássug. Káttapos ay pinuron nen disepulus hidi en naburay sakay nakaputat hidi ti sapulu ay ti duwwa a lákba. ");
INSERT INTO prfNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Nadid, dikona a pasiyaan a magdasal ti Jesus a mággeessa ay ummadeni dikona en disepulus na hidi. Tinanung hidi ni Jesus, “Ánya en palagay nen tolay hidi tungkul dikoku? Deyaák kan?” ");
INSERT INTO prfNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Tummábbig hidi, “Tehud a sangan a nagkagi a ti Juan a Mágbinyag ka kan. Tehud bi a nagkagi a ti Elias ka kan, sakay kagi bi nen agum a nabiyag kan a ruway en essa ten propeta tenhud pa a panahun.” ");
INSERT INTO prfNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Tinanung dámman hidi ni Jesus, “Sikam, ánya bi i makagi moyid tungkul dikoku?” Kinagi ni Pedro, “Siko en Cristo a impangaku nen Diyos!” ");
INSERT INTO prfNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Impakebibilin ni Jesus ten disepulus na hidi a dyan di iyud kagiyán maski kándeya. ");
INSERT INTO prfNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Sakay kinagi na pa dikodi, “Magtiis pa ti dikál a hirap en Anak nen Tolay. Itakwil siya nen pinunu hidi nen lahi ni Israel, nen pinunu hidi nen padi hidi, sakay nen mágtoldu hidi ten Kautusan. Pabunu di siya peru ten katállu a aldew ay biyagán siya a ruway nen Diyos.” ");
INSERT INTO prfNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Nadid, kinagi pa ni Jesus ten atanan a tolay, “Ni deyaman en masor a sumunud dikoku ay kailangan a limunán na en para ten sadili na. Báklayán na en kudus na aldew-aldew sakay sumunud dikoku. ");
INSERT INTO prfNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Gapu en tolay a maghangad a mángligtas ten sadili na a biyag ay siya i mawananid ti biyag. Peru ni deyaman en máng-alay ten biyag na alang-alang dikoku ay magkahud ti biyag. ");
INSERT INTO prfNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Ánya beman i pakinabangid nen tolay ni makao na man i buuwid a mundu, ni mepahamak labi en sadili na? ");
INSERT INTO prfNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Ni ikasanikiyák moy sakay en upos ku hidi ay ikasaniki kam bi nen Anak nen Tolay ten kássoli na haád a tehud a karangalan, sakay karangalan nen Ama sakay nen banal hidi a anghel. ");
INSERT INTO prfNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Saiddi kagiyán kuwid dikomoy, tehud a sangan háddi dikomoy a awan matay mentras a awan di ketan en pághari nen Diyos.” ");
INSERT INTO prfNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Kállipas nen sasimba káttapos na a kagiyán i bagayid a hidi iyád ay summangkay ti Jesus ten bukid tánni magdasal. Ingkuyug na de Pedro, Juan sakay ti Santiago. ");
INSERT INTO prfNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Dikona pasiyaan siya a magdasal ay nagbagu en rupa na, sakay tunay ti pudew en sulot na a badu a magbanaag, sakay magdemlag. ");
INSERT INTO prfNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Káttapos ay bigla la a lummitaw en duwwa a lállaki, a de Moises ay ti Elias, ");
INSERT INTO prfNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","dumáddemlagan bi hidi a pummeta. Nákpágguron hidi kánni Jesus tungkul ten adeni dán a kákkatay na ti Jerusalem. ");
INSERT INTO prfNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Nadid, mahusay en tidug ni Pedro pati en kakagumanan na hidi, peru bigla hidi a nalukag. Netan di ti Jesus a magdemlag ti makasili, kaguman en duwwa a lállaki a mákpágtaknág dikona. ");
INSERT INTO prfNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Dikona palakad dán en duwwa a lállaki ay kinagi ni Pedro, “Panginoon, maganda ta ked kami háddi. Paggamet mi kam ti tállu a sarong: essa para dikomu, essa para kánni Moises, sakay essa bi kánni Elias.” Peru i tatarudanid ay awan kabetuwan ni Pedro en kákkagiyán na. ");
INSERT INTO prfNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Pasiyaan palla a magupos ti Pedro ay nataklábban dán hidi nen panganurin, kaya neántingan en disepulus hidi. ");
INSERT INTO prfNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Sakay tehud a essa a boses a gubwat ten panganurin a kona háddi en kinagi na, “Iyád en Anak ku a pinili ku, sanigán moy siya.” ");
INSERT INTO prfNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Dikona awan dán en boses ay netan di a mággeessa dálla ti Jesus. Awan kinagi nen disepulus hidi en netan di maski kándeya. ");
INSERT INTO prfNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Ten ruway a aldew ay dummagson dán hidi a gubwat ten bukid, sakay tinagbu nen tunay a kakpal a tolay ti Jesus. ");
INSERT INTO prfNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Ten kakpalan nen tolay hidi ay tehud a lállaki a pummákraw a, “Maistu, kagbiyan pay a ilingán i eessa kuwiday a anak a lállaki. ");
INSERT INTO prfNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Hinayup siya, sakay bigla dálla siya a mágpapákrawán. Pagpágpággán siya nen dimonyo hanggan magruru en ngusu na. Páppahirapan na siya sakay awan na gustu a lakadan. ");
INSERT INTO prfNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Nákkekagbiyák ten disepulus mu hidi a paibután di en madukás a ispiritu, peru awan di kaya.” ");
INSERT INTO prfNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Tummábbig ti Jesus, “Tunay kam ti dukás a tolay, awan kam ti pánniwala! Hanggan nikan takam a págtatiisan?” Sakay kinagi ni Jesus ten lállaki, “Iyangay mu háddi en anak mu.” ");
INSERT INTO prfNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Dikona a paadeni en anak ay inlugmuk siya nen dimonyo sakay pinagpágpág na. Inutusan ni Jesus en madukás a ispiritu a lumakad ten anak, pinagpiyya na sakay tulos na inyatád ten ama na. ");
INSERT INTO prfNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Nagtaka ti hustu en tolay hidi ten kapangyariyan nen Diyos. Tunay palla en págtaka nen tolay hidi ten ginamet ni Jesus dikona kagiyán na ten disepulus na hidi a, ");
INSERT INTO prfNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Dyan moy kalimunan i kagiyán kuwiday, itokyon en Anak nen Tolay sakay mepabahala ten kapangyariyan nen tolay hidi.” ");
INSERT INTO prfNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Peru awan iyád naintendiyan nen disepulus na hidi, gapu awan palla impakapospos nen Diyos dikodi. Sakay manteng hidi a magtanung ni ánya en kahulugan nen kinagi na. ");
INSERT INTO prfNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Mensan, namagtalu-talu en disepulus na hidi ni deya i kataasanid dikodi. ");
INSERT INTO prfNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Tukoy ni Jesus ni ánya en ked ten isip di kaya dinulawan na en essa a anak a badit sakay pinataknág na ten wares na. ");
INSERT INTO prfNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Sakay kinagi na dikodi, “Ni deya en mangtanggap ti anakidi gapu maniwala siya dikoku ay sikán en tinanggap na, sakay ni deya en mangtanggap dikoku ay tinanggap na en nangutus dikoku a umangay háddi. Ni deyaman en kababaan dikomoy ay siya i kataasanid.” ");
INSERT INTO prfNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Kinagi ni Juan, “Maistu, netan mi en essa a tolay a magpalayas ti dimonyo ten pamamag-itan nen ngaran mu. Sinaway mi siya gapu awan tam siya kaguman.” ");
INSERT INTO prfNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Peru kinagi ni Jesus, “Dyan moy siya sawayán, gapu kaguman moy en umayun dikomoy.” ");
INSERT INTO prfNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Dikona a adeni dán en panahun a idisunu ti Jesus dilanget ay naisip na a angay ti Jerusalem. ");
INSERT INTO prfNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Tehud siya a pinágdipalongu a ummangay ten essa a lugar ti Samaria tánni maghanda ti tulusan na. ");
INSERT INTO prfNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Peru awan siya tinanggap nen Samaritano hidi gapu malinaw a paangay siya ti Jerusalem. ");
INSERT INTO prfNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Dikona natukuyan iyád nen disepulus hidi a de Santiago ay ti Juan ay kinagi di dikona, “Panginoon, masor ka beman a mangpadibábbi kami ti apoy a gubwat dilanget tánni mapuksa hidi?” ");
INSERT INTO prfNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Peru liningat hidi ni Jesus sakay sinaway na hidi. ");
INSERT INTO prfNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Sakay ummangay hidi ten agum a lugar. ");
INSERT INTO prfNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Dikona a maglakad dán hidi ay tehud a tolay a nagkagi kánni Jesus, “Maistu, mákkuyugák dikomu, maski hádya en angayan mu.” ");
INSERT INTO prfNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Kinagi ni Jesus dikona, “Tehud a ábbut a páppágyanan en asu hidi ti talon sakay tehud a lobun en ibun hidi. Peru en Anak nen Tolay ay awan dálla ti lugar a mapátdugan oni maimangan.” ");
INSERT INTO prfNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Káttapos ay kinagi ni Jesus ten essa a tolay, “Mákkuyug ka dikoku.” Peru kinagi nen tolay a, “Panginoon, pabayanák mu pa a umuli ta angay ku pelábbáng en ama ku.” ");
INSERT INTO prfNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Peru kinagi ni Jesus dikona, “Pebahala mu ten patay hidi en páglábbáng ten patay di. Peru siko, angen mu ipakapospos ten tolay hidi en tungkul ten pághari nen Diyos.” ");
INSERT INTO prfNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Kinagi bi nen essa a lállaki a, “Mákkuyugák dikomu Panginoon, peru payaganák mu a angayák pa magpaalam ten pamilya ku.” ");
INSERT INTO prfNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Kona bi háddi en tábbig ni Jesus dikona, “Ni deyaman en magaradu a mágsasulig-suligán, ay awan maari ten kahariyan nen Diyos.” ");
INSERT INTO prfNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Nadid, káttapos ay nangpili en Panginoon ti pittu a pulu ay ti duwwa a lállaki. Tágdaduwwa hidi a inutusan na a umangay ten balang banuwan sakay lugar a angayan na. ");
INSERT INTO prfNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Kinagi na, “Makpal en gapasán, peru kulang en maggapas. Idasal moy ten makákkao ten gapasán a mángpaangay pa siya ti mággapas. ");
INSERT INTO prfNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Kadmoy dán! Utusan takam a kona ten tupa ten ditángnga nen asu hidi ti talon. ");
INSERT INTO prfNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Dyan kam magtawid ti pilak, hembeg, oni sandalyas. Dyan kam magabala a umimang a mákpágguron ten matagbu moy hidi ten dilan. ");
INSERT INTO prfNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Kássáddáp moy ten balang bilay a angayan moy ay kagiyán moy dikodi a, ‘Maghari nakuwan en kapayapaan ti bilayid a iddi.’ ");
INSERT INTO prfNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Nadid ni mahal nen mágyan hidi ten bilay en kapayapaan ay magkahud ngani hidi ti kapayapaan. Peru ni awan ay soli dikomoy en kapayapaan moy. ");
INSERT INTO prfNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Ni hádya en bilay a págyanan moy ay haud kam la, dyan kam mággaagton-agtonán. Ni ányaman en ihayin di dikomoy ay kanán moy sakay inumán moy en ipenom di dikomoy. Gapu en tarabahador ay tehud a karapatan mangtanggap ten hornal na. ");
INSERT INTO prfNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Ni tanggapán di kam ten hádyaman a banuwan, ay kanán moy ni ányaman en ihayin di dikomoy. ");
INSERT INTO prfNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Pagpiyyaán moy en tehud hidi a saket haud, sakay kagiyán moy dikodi a, ‘Adeni dán a dumemát en pághari nen Diyos dikomoy.’ ");
INSERT INTO prfNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Peru ni awan di kam tanggapán ten banuwan a angayan moy ay lumuwas kam ten dilan sakay kagiyán moy a, ");
INSERT INTO prfNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Ipagpag mi en alikabuk nen banuwan moy a ked ti babásset miyiday, iyád ay tanda a tehud kam a parusa gapu ten awan moy pángtanggap dikomi. Peru tandaan moy ummadeni dán nakuwan en pághari nen Diyos dikomoy!’ ");
INSERT INTO prfNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Siguradu a káddemát nen Aldew nen Pághatul ay mas madággi en parusa ten tolay hidi ti banuwanid a iyud, nan ten dinanas nen taga-Sodoma hidi!” ");
INSERT INTO prfNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Kahabaghabag kam a taga-Corazin hidi! Kahabaghabag kam a taga-Bethsaida hidi! Makpalák dán a impeta dikomoy a himala peru awan kam la sibu-sibulan a magsisi. Ni ti Tiro sakay ti Sidon i nángpetaan kuwid ten himala hidi a impeta ku háddi, ay nanalay dán nakuwan hidi a nagsulot ti kostal, sakay nággetnud ten abu, tanda a nagsisi dán hidi ten kasalanan di. ");
INSERT INTO prfNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Ten Aldew nen Pághatul ay mas madággi i parusa moyid nan ten parusa nen taga-Tiro hidi sakay nen taga-Sidon hidi. ");
INSERT INTO prfNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Sakay sikam a taga Capernaum hidi, gugustu moy a itaas i sadili moyen a hanggan dilanget, peru mebaba kam a hanggan ti impiyerno!” ");
INSERT INTO prfNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Káttapos ay kinagi pa ni Jesus ten disepulus na hidi, “Ni deyaman mangsanigid dikomoy ay sikán i sinanig diyid, en awan mangtanggap dikomoy ay sikán i awan diyid tinanggap. Sakay en awan mangtanggap dikoku ay en nangutus dikoku i awan diyid tinanggap.” ");
INSERT INTO prfNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Tunay ti saya a nagsoli en pittu a pulu ay ti duwwa. Kinagi di, “Panginoon maski en dimonyo hidi ay summunud dikomi ni utusan mi hidi ten ngaran mu.” ");
INSERT INTO prfNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Kinagi ni Jesus, “Netan ku ti Satanas a natáknig a gubwat dilanget a kumán a kilat. ");
INSERT INTO prfNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Tandaan moy, inátdenan takam ti kapangyariyan tánni awan kam maaánya, maski yudakán moy en biklat hidi sakay ánnepet, sakay maski kontraán moy en kapangyariyan nen kadima. ");
INSERT INTO prfNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Peru dyan kam masaya gapu ten kássunud nen mágkadukás hidi a ispiritu dikomoy, nan dapat moyid a kasayaan ay nelista dán en ngaran moy dilanget.” ");
INSERT INTO prfNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Ti odasid a iyud ay pinutat nen Banal a Ispiritu ti Jesus ti kasayaan. Kinagi na, “Magpasalamaták dikomu Ama a Panginoon dilanget sakay ti lutaiday, gapu awan mu impakapospos hidi iyád a bagay ten mágkarunung hidi. Impakapospos mu la hidi iyád ten kaparehu nen anak hidi a bábbadit. Opo Ama, magpasalamaták gapu iyád en kaluuban mu.” ");
INSERT INTO prfNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","“Inyatád dán nen Ama ku dikoku en atanan a bagay. Awan ti iba a makatukoy ni deya en Anak ni awan en Ama la. Kona labi hud ten Ama awan ti iba a makatukoy ni deya siya ni awan en Anak la, sakay en pinili hidi nen Anak a pángpakapospusan na tungkul ten Ama.” ");
INSERT INTO prfNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Káttapos ay ummatubeng ti Jesus ten disepulus na hidi sakay kinagi na ti palihim, “Pinagpala kam, gapu netan moy en bagay hidi a netan moy nadid! ");
INSERT INTO prfNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Tandaan moy, makpal a propeta sakay hari en masor a maketa ten netan moy nadid, peru awan di netan. Gustu di bi a masanig en nasanig moy peru awan di nasanig.” ");
INSERT INTO prfNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Tehud a ummadeni kánni Jesus a essa a tagapagtoldu nen Kautusan, gapu gustu na siya a purbaan. Kinagi na, “Maistu ánya dapat kuwid a gamitán tánni magkahudák ti biyag a awan ti katapusan?” ");
INSERT INTO prfNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Tummábbig ti Jesus, “Ánya beman en nakasulat ten Kautusan? Ánya nabasa muwid haud?” ");
INSERT INTO prfNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Tummábbig siya, “ ‘Mahalán mu en Panginoon mu a Diyos ti buu a pusu, buu a kaluluwa, buu a begsák, sakay ti buu a isip,’ sakay ‘Mahalán mu en kaparehu mu a tolay a kona ten págmahal mu ten sadili mu.’ ” ");
INSERT INTO prfNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","“Tama en tábbig mu,” kagi ni Jesus. “Ni masunud mu iyád ay magkahud ka ti biyag a awan ti katapusan.” ");
INSERT INTO prfNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Para pangbura na ten kákkatagama na ay tinanung na a ruway ti Jesus, “Deya beman kaparehu kuwid a tolay?” ");
INSERT INTO prfNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Tummábbig ti Jesus, “Tehud a essa a tolay a patamu ti Jerico, gubwat siya ti Jerusalem. Hinarang siya nen tulisan hidi, inalap di pati sulot na a badu. Binálbág di siya a ngari-ngari dán a matay dikona lakadan di. ");
INSERT INTO prfNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Sakay netaun a nagtalib haud en essa a padi. Peru ten pákketa na ten tolay a bumábbangtad ten dilan ay lummisi siya sakay nágpagilid ten dilan. ");
INSERT INTO prfNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Nagtalib bi en essa a Levita, peru inileng na la en tolay a nabálbág sakay tulos-tulos la en lakad na ten gilid nen dilan. ");
INSERT INTO prfNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Peru tehud a Samaritano a magbiyahi a nagkon haud. Pákketa na ten bumábbangtad ay kinagbiyan na. ");
INSERT INTO prfNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Ummadeni en Samaritano dikona sakay binulakan na ti langis ay ti alak en talingu na hidi, sakay binádbáddan na. Káttapos ay insakay na ten págkabayuwan na a asno. Inyangay na siya ten essa a págkaseruwan, tánni maalagaan na haud. ");
INSERT INTO prfNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Ten ruway a aldew ay nangalap en Samaritano ti duwwa a dinaryo ten bulsa na sakay inyatád na ten makákkao ten bilay a págkaseruwan sakay imbilin na a, ‘Alagaan mu siya, sakay ni sangan i kulang kuwid ay bayadan ku la kássoli ku.” ’ ");
INSERT INTO prfNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Sakay nagtanung ti Jesus, “Deya ti palagay muwid ten tállu a nagtalib ten bumábbangtad i tatarudanid a tehud a pákpággagum?” ");
INSERT INTO prfNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","“En nangágbi ten tolay a bumábbangtad.” Kagi nen tagapagtoldu nen Kautusan. Kaya kinagi ni Jesus dikona, “Kammudán, kona bi hud i dapat muwid a gamitán.” ");
INSERT INTO prfNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Nadid, de Jesus ay ten disepulus na hidi ay nagtulos la ten lakad di, ummangay hidi ten essa a baryu. Tehud haud a mágyan a essa a bábbi a Marta en ngaran na, masaya siya a nangtanggap dikodi ten bilay na. ");
INSERT INTO prfNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Tehud siya a kapatkaka a Maria en ngaran na. Nággetnud ti Maria ten atubengán nen Panginoon sakay nágsanig ten itáttoldu na. ");
INSERT INTO prfNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Peru nabalisa ti Marta ten pághanda na kaya ummadeni siya kánni Jesus sakay kinagi na, “Panginoon, bali-awan beman la dikomu a páppabayanák la ni kapatkaka kuwen? Kagiyán mu pay dikona a tulunganák na.” ");
INSERT INTO prfNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Peru kinagi nen Panginoon dikona, “Marta, Marta, masiyadu ka a balisa a mágpapospusán ten makpal a bagay, ");
INSERT INTO prfNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Peru essa la i talagaid a kailangan. Pinili ni Maria en tama a bagay, kaya awan iyád maibutan dikona.” ");
INSERT INTO prfNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Nadid, ten essa a aldew ay nagdasal ti Jesus ten essa a lugar. Káttapos na ay kinagi nen essa a disepulus na, “Panginoon, tolduwan mu kami pay a magdasal a kona ten págtoldu ni Juan ten disepulus na hidi.” ");
INSERT INTO prfNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Kinagi ni Jesus, “Ni magdasal kam ay kona háddi i kagiyán moyid, ‘Ama, sambaán nakuwan en ngaran mu. Maghari ka nakuwan dikomi. ");
INSERT INTO prfNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Átdenan mu kami ti makan mi ti aldew-aldew. ");
INSERT INTO prfNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Sakay patawadán mu kami ten kasalanan mi hidi, gapu patawadán mi en balang magkasala dikomi. Sakay dyan mu kami pabayan a matoksu.’ ” ");
INSERT INTO prfNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Káttapos ay kinagi pa ni Jesus dikodi, “Ipalagay tam a essa a hatinggabi, essa dikomoy ay ummangay ten amigu moy a nákkekagbi sakay kinagi na, ‘Amigu ku, paáddimanák pay ti tállu a balut a tinapay. ");
INSERT INTO prfNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Rummoyot biyay en essa a amigu ku a magbiyahi, awanák ti mepakan dikona!’ ");
INSERT INTO prfNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Kona háddi en intábbig nen amigu mu, ‘Dyanák mu pay istorbuwán! Nekalang dán i pintuwanen sakay mágkatdug kami dán ay ti anak kuwiday hidi. Awanák dán makaikat a mangatád dikomu ti kailangan muwen.’ ");
INSERT INTO prfNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Peru kagiyán ku dikomoy, maski umád siya a umikat, gapu magamigu kam ay umikat labi siya a mangatád ten atanan a kailangan mu gapu ten págpapilit mu. ");
INSERT INTO prfNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Kaya tandaan moy, ni agidán mu ten Diyos en kailangan mu ay iyatád na iyád dikomu, ni magaryok ka ay maketa ka, sakay ni tumoktok ka ay bukasan na ka. ");
INSERT INTO prfNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Gapu en atanan nen magagid ay makatanggap, en atanan nen magaryok ay maketa, sakay en atanan nen tumoktok ay mabukasan. ");
INSERT INTO prfNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Sikam a ama hidi, mara ni mággid dikomoy en anak moy ti ikan, átdenan moy beman siya ti biklat? ");
INSERT INTO prfNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Oni mara ni mággid en anak moy ti bunay, átdenan moy beman siya ti ánnepet? ");
INSERT INTO prfNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Syempre awan, gapu maski mágkadukás kam a ama ay kabetuwan moy a mangatád ti mágkaganda a bagay ten anak moy hidi. Iyud pa beman ni en Ama tamon dilanget! Iyatád na en Banal a Ispiritu ten mággid hidi dikona!” ");
INSERT INTO prfNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Nadid, pinalayas ni Jesus en essa a dimonyo ten essa a lállaki a bulol sakay dikona a lummayas en dimonyo ay makapagupos dán siya sakay hinumanga en tolay hidi kánni Jesus. ");
INSERT INTO prfNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Peru kinagi nen sangan a tolay, “En nangatád dikona ti kapangyariyan a mangpaibut ti dimonyo ay ti Beelzebul, en pinunu nen dimonyo hidi.” ");
INSERT INTO prfNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Tehud bi a sangan a masor a mangpurba kánni Jesus, kaya kinagi di, “Mángpeta ka benid ti himala a mangpatunay a ked dikomu en Diyos.” ");
INSERT INTO prfNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Peru tukoy ni Jesus en ked ten isip di, kaya kinagi na dikodi, “Mara ni mahati-hati en tolay hidi ten essa a banuwan sakay mamágdadema ay awan hidi magmalay. Kona labi hud en sabilay a mamágdadema, mamágsasena hidi. ");
INSERT INTO prfNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Ni tehud a grupu-grupu a mamaglaban-laban ten kahariyan ni Satanas, ay konya a tumatag en kahariyan na? Kagi moy a magpalayasák ti dimonyo ten pamamag-itan nen kapangyariyan ni Beelzebul. ");
INSERT INTO prfNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Ni gubwat kánni Beelzebul en kapangyariyan ku a magpalayas ten dimonyo hidi, ay kándeya bi a kapangyariyan en págpalayas nen tagasunud moy hidi? Hidi dán i makapangpatunayid a liwat kam. ");
INSERT INTO prfNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Magpalayasák ti dimonyo ten pamamag-itan nen kapangyariyan nen Diyos, gustu naid a kagiyán ay dummemát dán en kahariyan nen Diyos dikomoy.” ");
INSERT INTO prfNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Ni en essa a tolay a mabegsák ay magbantay ten bilay na sakay tawid na en armas na, ay awan ti makapangagew ten ari-ariyan na. ");
INSERT INTO prfNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Peru ni sunggaban nen essa a tolay a mas mabegsák nan en makábbilay, ay agiwán na en armas hidi a inasaan nen makábbilay sakay ipagatád na en ari-ariyan hidi a naagew na.” ");
INSERT INTO prfNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“En awan ku kakampi ay kalaban ku, sakay en awan ku kaguman a magipun ay mágkakalatán.” ");
INSERT INTO prfNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Kinagi pa ni Jesus, “Ni lumuwas en essa a madukás a ispiritu ten bággi nen essa a tolay ay máglalebután iyud ten lugar a kamadiyan, gapu magaryok ti maimangan na. Ni awan siya ti ketan ay kagiyán na ten sadili na a, ‘Sumoliyák dálla a ruway ten bilay a ginubwatan ku.’ ");
INSERT INTO prfNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Kássoli na ay demáttan na en bilay a malinis dán sakay maayus. ");
INSERT INTO prfNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Kaya lumuwas siya a ruway a magakit pa ti pittu a ispiritu a mas mabagsik pa nan siya, sakay somdáp hidi haud a mágyan. Kaya, mas dumukás pa ten dati en kalagayan nen tolay, gapu makpal dán en madukás a ispiritu a ked dikona.” ");
INSERT INTO prfNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Dikona pasiyaan a magupos ti Jesus ay tehud a essa a bábbi a pummákraw ten katolayan. Kinagi na, “Pinagpala en bábbi a náng-enak dikomu sakay nangpadikál!” ");
INSERT INTO prfNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Peru tummábbig ti Jesus, “Mas pinagpala en mágsanig sakay sumunud ten upos nen Diyos!” ");
INSERT INTO prfNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Dinarupodupan nen tolay hidi ti Jesus, kinagi na, “Madukás a tarud i tolayid nadid a panahun! Magaryok hidi ti himala, peru awan ti ipeta a tanda dikodi, maliban ten tanda a nangyari kánni Jonas. ");
INSERT INTO prfNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Ni konya a ti Jonas ay nagin tanda nen Diyos ten taga-Ninive hidi ay kona labi hud ten Anak nen Tolay a tanda nen Diyos para ten tolay hidi nadid a panahun. ");
INSERT INTO prfNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Ten Aldew nen Pághatul ay magpatunay kontra ten tolay hidi nadid en Raina ti Sheba gapu maski ked siya ten adeyu a banuwan ay ummangay padi siya nágsanig ten karunungan ni Solomon. Peru sikam, ked dán ngani háddi nadid en mas mataas nan ti Solomon ay awan kam la maniwala! ");
INSERT INTO prfNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ten Aldew nen Pághatul ay magpatunay kontra ten tolay hidi nadid a panahun en taga-Ninive hidi gapu dikona nangaral dikodi ti Jonas ay nagsisi hidi. Peru kagiyán ku dikomoy a mas mataas nan ti Jonas en ked háddi nadid.” ");
INSERT INTO prfNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Kinagi bi ni Jesus, “Awan ti magtab ti simbuwan sakay taklábban na ti timba. Nan en simbuwan ay idátton ten talaga a págtupuwan tánni mademlagan en tolay hidi a sumáddáp ten bilay. ");
INSERT INTO prfNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","En mata ay pinakasimbu nen tolay ten bággi na. Mara ni mahusay en mata mu ay mademlagan en buu mu a bággi. Peru ni maraburab en mata mu ay madiklámman en buu mu a bággi. ");
INSERT INTO prfNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Kaya siguraduwán mu la, bakay i demlagen a tukoy mu a ked dikomu ay diklám bali. ");
INSERT INTO prfNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Ni ked ten demlag en buu mu a bággi sakay awan ti bahagi a ked ten kadiklámman ay magdemlag iyád a kumán a essa a simbuwan a mangdemlag dikomu.” ");
INSERT INTO prfNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Káttapos ni Jesus a nagupos ay inakit siya nen essa a Pariseo a kuman ten bilay na. Nákkuyug siya sakay nákpággetnud dikodi a kinuman. ");
INSERT INTO prfNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Nagtaka en Pariseo dikona netan na ti Jesus a kinuman a awan nagugas ten lima na. ");
INSERT INTO prfNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Kaya kinagi nen Panginoon dikona, “Sikam a Pariseo hidi, ugasan moy en luwas nen tasa sakay penggan, peru ten disalad nen bággi moy ay putat ti mágkadukás a gamet. ");
INSERT INTO prfNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Sikam a mangmang hidi! Awan beman en Diyos nanglalangid ten disalad ay ten luwas nen essa a tolay? ");
INSERT INTO prfNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Iyatád moy pa ten mágkahirap hidi en lasán nen tasa moy sakay nen penggan moy, tánni magin malinis en atanan a bagay para dikomoy.” ");
INSERT INTO prfNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Kakakagbi kam a Pariseo hidi! Iyatád moy en kasapulu a bahagi nen mula-mula moy hidi a pangrikadu, peru linimon moy bi en katarungan sakay en págmahal ten Diyos. Tama a gamitán moy en purumeru, peru awan moy dapat a limunán en kaduwwa. ");
INSERT INTO prfNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Kakakagbi kam a Pariseo hidi! Gapu gugustu moy a mággetnud ten pággetnudan nen mágkataas hidi a tolay ten sinagoga, sakay igalang, sakay batiyán ten sentru nen banuwan. ");
INSERT INTO prfNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Kakakagbi kam gapu kumán kam a en lábbáng hidi a awan ti tanda kaya táppakan la nen tolay hidi gapu awan di mahalata.” ");
INSERT INTO prfNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Kinagi dikona nen essa a tagapagtoldu nen Kautusan, “Maistu, ti kinagi muwen ay pati sikami ay ininsultu mu bi.” ");
INSERT INTO prfNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Kaya tummábbig ti Jesus, “Sikam a tagapagtoldu hidi nen Kautusan, kakakagbi kam bi! Gapu pabáklay moy ten tolay hidi en mágkadággi hidi a karga, peru maski ni guramát moy ay awan moy iyarikad para tulungan hidi. ");
INSERT INTO prfNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Kakakagbi kam! Gapu mággagamitán kam ti mágkaganda a páglábbángngan para ten propeta hidi a binábbunu nen dáddikál moy hidi tenhud. ");
INSERT INTO prfNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Gapu ti ginamet moyid a iyud ay sikam labi i nangpatunayid a ummayun kam ten ginamet nen ninunu moy hidi, gapu hidi en nangbunu ten propeta hidi sakay sikam en nangpaganda ten nánglábbángngan dikodi. ");
INSERT INTO prfNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Iyád mangpatunayid a tatarudan en kinagi ayun ten Karunungan nen Diyos, ‘Mángpaangayák dikodi ti propeta sakay apostol hidi; en agum ay bunuwán di sakay en agum ay pahirapan di. ");
INSERT INTO prfNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Kaya maparusaan en tolay hidi nadid a panahun, gapu binunu nen ninunu di hidi en propeta hidi sapul dikona a linalang i munduwiday, ");
INSERT INTO prfNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","sapul ten pángbunu ni Cain kánni Abel hanggan kánni Zacarias a binunu di ten sállat nen banal a lugar ay ten altar a págtutudan di ti alay. Kaya gapu ten ginamet di, en tolay hidi nadid a panahun ay maparusaan. ");
INSERT INTO prfNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Sikam a tagapagtoldu hidi nen Kautusan, kakakagbi kam! Gapu inlihim moy ten tolay hidi en susi nen kaalaman. Sala moy dán ngani a sumáddáp ay harangán moy pa en tolay hidi a masor a sumáddáp.” ");
INSERT INTO prfNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Kállakad ni Jesus ti lugarid a iyud ay nagsapul dán a naiyamut dikona en tagapagtoldu hidi nen Kautusan sakay en Pariseo hidi. Pirmi di siya a tanungán tungkul ten sari-sari a bagay, ");
INSERT INTO prfNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","gapu gustu di siya a madikáp ni tehud siya a kagiyán a maari di a idahilan tánni mahatulan di siya. ");
INSERT INTO prfNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Dikona nagdemáttan en libu-libu a katolayan ay mágketáppakan di dán en balang essa gapu ten kakpal di. Kinagi ni Jesus ten disepulus na hidi, “Mangilag kam ten págpaalsa nen Pariseo hidi, gustu kuwid a kagiyán ay en págkukunwari di. ");
INSERT INTO prfNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Awan ti netagu a awan ketan, sakay awan ti sekretu a awan matukuyan. ");
INSERT INTO prfNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","En kagiyán moy ten diklám ay masanig ten demlag, sakay en iyanasas moy ten disalad nen kuwartu ay masanig ten matolay a lugar.” ");
INSERT INTO prfNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Kagiyán ku dikomoy a amigu ku hidi, a dyan kam manteng ten mágbabonu hidi ta maari di laid a bunuwán ay en bággi sakay awan dán hidi ti agum a magamet. ");
INSERT INTO prfNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Kagiyán ku dikomoy a en dapat moy a kantingan ay en Diyos, gapu káttapos na a mangbunu ay tehud pa siya a kapangyariyan a máng-angay ten tolay ti impiyerno. Tandaan moy, en Diyos la en dapat moy a kantingan! ");
INSERT INTO prfNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Awan beman, en limma a dignás ay ilaku la ti duwwa a sentabos? Peru kagiyán ku dikomoy, maski tunay iyud ti kamuraan ay awan pabayan nen Diyos maski essa dikodi. ");
INSERT INTO prfNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Maski i buuk moyen ay nabilang na dán a atanan. Kaya dyan kam manteng gapu mas mahalaga kam ten Diyos nan en dignás hidi.” ");
INSERT INTO prfNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Kagiyán ku dikomoy, a ni deyaman en mangkilala dikoku ten atubengán nen katolayan ay kilalanán bi nen Anak nen Tolay ten atubengán nen anghel hidi nen Diyos. ");
INSERT INTO prfNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Peru ni deyaman en awan mangkilala dikoku ten atubengán nen katolayan ay awan ku bi kilalanán ten atubengán nen anghel hidi nen Diyos. ");
INSERT INTO prfNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Ni deya en magupos ti kontra ten Anak nen Tolay ay mapatawad. Peru en magupos ti madukás kontra ten Banal a Ispiritu ay awan mapatawad. ");
INSERT INTO prfNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Mara ni iyangay di kam ten sinagoga hidi, oni ten atubengán nen pinunu hidi, sakay ten tehud hidi a kapangyariyan a tolay para bistaán, ay dyan kam mabalisa ni konya moy a dipensaan en sadili moy oni ánya i itábbig moyid. ");
INSERT INTO prfNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Gapu ti odasid a iyud ay itoldu dikomoy nen Banal a Ispiritu ni ánya i dapat moyid a itábbig.” ");
INSERT INTO prfNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Tehud a essa a lállaki ten katolayan a nagkagi kánni Jesus ti kona háddi, “Maistu, kagbiyan pay a iyutus ten kaka ku a iyatád na dán dikoku en mana ku.” ");
INSERT INTO prfNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Tummábbig ti Jesus, “Deya beman i nangatáddid dikoku ti karapatan a magin huwes oni manghati ten mana moy?” ");
INSERT INTO prfNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Káttapos ay kinagi ni Jesus dikodi a atanan, “Mangilag kam ten atanan a kalasi ni kasakiman; gapu en biyag nen tolay ay bakán a ten kakpal nen kayamanan na.” ");
INSERT INTO prfNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Káttapos ay inyistorya ni Jesus en essa a talinhaga. Kinagi na, “Tehud a essa a mayaman a lállaki a tummama ten uma na. ");
INSERT INTO prfNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Sakay kinagi na ten sadili na, ‘Ánya wád gamitán kuwid? Awanák dán ti pángdáttonan ti naani kuwidi! ");
INSERT INTO prfNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Kona bál háddi i gamitán kuwid! Rukatán ku en budega ku, sakay mángpataknággák ti mas dikál, sakay idátton ku haud en naani ku pati en ari-ariyan ku hidi. ");
INSERT INTO prfNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Káttapos ay kagiyán ku ten sadili ku a makpalák dán a kayamanan! Awanák dán kulangán ti malay a panahun. Mágpakahusayák dálla ten biyag ku a kuman, uminom, sakay mágsasayaán!’ ");
INSERT INTO prfNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Peru kinagi nen Diyos dikona, ‘Mangmang! Nadid bi a gibi ay bawiyán ku dán i biyag muwen. Kándeya nadid a meangay en atanan a inhanda mu?’ ");
INSERT INTO prfNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Káttapos ay kinagi ni Jesus, “Kona haán mangyariyid ten mágpapuronán ti kayamanan para ten sadili na. Peru pubri siya ten pangileng nen Diyos.” ");
INSERT INTO prfNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Kinagi ni Jesus ten disepulus na hidi, “Kaya kagiyán ku dikomoy, a dyan kam mabalisa tungkul ten makan a kailangan moy para mabiyag kam, oni tungkul ten badu a isulot moy. ");
INSERT INTO prfNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Gapu mas mahalaga en biyag nan ten makan, sakay en bággi moy nan ten badu moy. ");
INSERT INTO prfNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Isipán moy dálla en wakwak hidi, awan hidi magmula oni magani, sakay awan bi hidi ti budega a págtambakan. Peru ilingán moy maski kona la hidi haud ay páppakanán hidi nen Diyos. Mas mahalaga kam nan ten ibun hidi! ");
INSERT INTO prfNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Deya beman dikomoy en makapangpaatakdug ten biyag na maski essa la a odas ten pamamag-itan nen kákkabalisa na? ");
INSERT INTO prfNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Ni awan moy makaya a gamitán i sakona laid haud a bagay ay bakin kabalisaan moy pa en tungkul ten agum hidi a bagay? ");
INSERT INTO prfNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Ilingán moy en bulaklak hidi ten parang, awan hidi magtarabahu sakay awan bi hidi maggamet ti badu di. Maski ni mayaman ti Solomon ay awan palla siya nakapagbadu ti kaparehu ti ganda nen essa ten bulaklak hidi ten parang. ");
INSERT INTO prfNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Ni en lamon hidi a biyag nadid, sakay ni ilaw ay tutudán ay pospusán nen Diyos, sikam pa beman en awan na pospusán a baduwan? Tunay ti kabadit en pánnampalataya moy dikona! ");
INSERT INTO prfNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Kaya dyan kam la mabalisa ten pággaryok moy ten makan moy sakay ten inumán moy. ");
INSERT INTO prfNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Gapu hidi iyád en bagay hidi a páppospusán nen tolay hidi a awan ti pánniwala ten Diyos. Tukoy nen Ama moy dilanget a kailangan moy hidi iyád a atanan. ");
INSERT INTO prfNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Kaya bagu en atanan a bagay ay pagsikapan moy pa a paghariyan kam nen Diyos, sakay iyatád na en atanan a kailangan moy.” ");
INSERT INTO prfNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Dyan kam manteng, sikam a sasangan a disepulus ku hidi, gapu gugustu a tarud nen Ama a iyatád dikomoy en kahariyan. ");
INSERT INTO prfNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Ilaku moy en ari-ariyan moy sakay iyatád moy ten pubri hidi en naglakuwan moy. Ni kona hád i gamitán moyid ay magkahud kam ti pitaka a awan masisida, gapu en kayamanan moy ay mapuron dilanget. Awan ti mágtakaw a makasáddáp haud sakay awan ti insektu a mangsida. ");
INSERT INTO prfNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Gapu ni ked hádya en kayamanan moy ay ked bi haud en pusu moy.” ");
INSERT INTO prfNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Pirmi kam a humanda sakay tulos-tulos moy a paggitángngán en simbuwan moy. ");
INSERT INTO prfNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Arigán moy en utusan hidi a maguray ten káddemát nen amu di a gubwat ten kasalan. Káddemát na sakay magtoktok ay pagdaka di a mabukasan en pintuwan. ");
INSERT INTO prfNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Pinagpala en utusan hidi a demáttan a lukag sakay nakahanda ten káddemát nen amu di. Kagiyán ku dikomoy, páglewas na ay paetnudán na hidi ten lamisaan sakay tulos na hidi a serbiyan a pakanán. ");
INSERT INTO prfNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Pinagpala hidi ni demáttan na hidi a nakahanda maski ni dumemát siya ten hatinggabi dán oni kaldiwan dán. ");
INSERT INTO prfNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Kagiyán ku dikomoy, a ni tukoy la nen makákkao ten bilay en odas a káddemát nen mágtakaw, ay awan na pabayan a masáddáp en bilay na. ");
INSERT INTO prfNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Kaya, dapatid ay pirmi kam a nakahanda gapu dumemát en Anak nen Tolay ten odas a awan moy tukoy.” ");
INSERT INTO prfNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Nagtanung ti Pedro, “Panginoon, kinagi mu beman i talinhagaid a iyád para dikomi oni para ten atanan?” ");
INSERT INTO prfNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Tummábbig en Panginoon, “Deya beman en tapat sakay marunung a utusan? Deya en katiwala a pamahalaán nen amu na ten kasabilay na hidi tánni siya en mangatád ti makan ten agum hidi a utusan ten tama a odas? ");
INSERT INTO prfNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Pinagpala utusanid a iyád ni demáttan siya nen amu na a gággamitán na en atanan a utus dikona. ");
INSERT INTO prfNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Kagiyán ku dikomoy, siya en pagentregaan nen amu na ten atanan nen ari-ariyan na. ");
INSERT INTO prfNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Peru ni kagiyán na ten sadili na a, ‘Malay padi bagu magsoli en amu ku,’ kaya sapulan na dán a pahirapan en kaparehas na hidi a utusan bábbi ay ti lállaki, sakay mágkakanán sakay máglalasingán. ");
INSERT INTO prfNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Sakay dumemát en amu na ten aldew a awan na akalaán sakay ten odas a awan na tukoy. Parusaan siya nen amu na ti mahigpit sakay ipisan na siya ten tolay hidi a masássuwayán. ");
INSERT INTO prfNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“En utusan a makatukoy ni ánya gustuwid nen amu na a gamitán, peru awan na ginamet ay maparusaan ti mahigpit. ");
INSERT INTO prfNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Peru en utusan a awan palla nakatukoy ten gustu a pagamet nen amu na, magkulang man siya ten tungkulin na ay maparusaan, peru awan mahigpit. En inatáddan ti makpal a bagay ay aryokan bi ti makpal a bagay; sakay en pinagkatiwalaan ti mas makpal a bagay ay tehud a sagutin ten mas makpal a bagay.” ");
INSERT INTO prfNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Kayaák a ummangay ti munduwiday ay tánni magtawid ti parusa a kumán a apoy, gustu ku nakuwan a maggerab dán iyád. ");
INSERT INTO prfNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Peru bagu iyud ay kailangan a magdanasák pa ti dikál a hirap. Mabalisaák dán hanggan a awan iyád matupad. ");
INSERT INTO prfNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Ti palagay moy bemanid kayaák ummangay ti lutaiday ay tánni mangatád ti kapayapaan? Kagiyán ku dikomoy, bakán a kapayapaan i tawid kuwid nan en pamágsasena nen tolay hidi. ");
INSERT INTO prfNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Sapul nadid ni tehud a limma a tolay ten sabilay ay mamágsasena hidi, tállu kontra ten duwwa sakay duwwa kontra ten tállu. ");
INSERT INTO prfNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","En ama ay kontra ten anak na a lállaki, sakay en anak a lállaki ay kontra ten ama na; en ina ay kontra ten anak na a bábbi, sakay en anak na a bábbi ay kontra ten ina na; sakay en magkatugngan a bábbi ay magkakontra.” ");
INSERT INTO prfNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Káttapos ay kinagi ni Jesus ten tolay hidi, “Ni ketan moy dán a mabagál en diklám ti sarámman ay kagiyán moy dán a maguden, kona ngani haud i mangyariyid. ");
INSERT INTO prfNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ni magabagat dán ay kagiyán moy a magsinag dán, sakay kona ngani haud i mangyariyid. ");
INSERT INTO prfNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","“Sikam a mágwariwari hidi! Tukoy moy a intendiyán en tanda ti lutaiday sakay dilanget, bakin awan moy matukuyan en tanda hidi a mangyari dán nadid a panahun?” ");
INSERT INTO prfNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Bakin a awan moy tukoy a gamitán en tama? ");
INSERT INTO prfNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Ni tehud a masor a mángkasu dikomu ay sikapán mu a mákpagkasundu dikona bagu na ka a medimanda. Gapu ni awan ay bakay pilitán na ka a iyatubeng ten huwes. Káttapos ay ipapulis ka nen huwes sakay ipepiresu na ka. ");
INSERT INTO prfNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Tandaan mu i kagiyán kuwiday, awan ka makaluwas ten págpiresuwan hanggan ni awan mu mabayadan en atanan nen multa mu.” ");
INSERT INTO prfNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Nadid dummemát en sangan a tolay sakay imbareta di kánni Jesus a pinabunu ni Pilato en sangan a taga-Galilea mentras a magalay hidi ten Diyos. ");
INSERT INTO prfNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Kinagi ni Jesus dikodi, “Nadid gapu beman a konahud nangyariyid dikodi ay isipán moy dán a mas makasalanan hidi nan ten agum hidi a taga-Galilea? ");
INSERT INTO prfNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Awan! Kagiyán ku dikomoy, a ni awan kam magsisi ten kasalanan moy hidi ay mepahamak kam bi a kona dikodi. ");
INSERT INTO prfNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Tungkul bi ten sapulu ay ti walu a natay dikona a natáppelan hidi nen malangkaw a bilay ti Siloe, ti isip moy bemanid ay mas makasalanan hidi nan ten agum hidi a mágyan ti Jerusalem? ");
INSERT INTO prfNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Awan! Kagiyán ku dikomoy, a ni awan moy pagsisiyan en atanan a kasalanan moy ay mepahamak kam bi a kona dikodi.” ");
INSERT INTO prfNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Káttapos ay inyistorya ni Jesus dikodi i talinhagaid a iddi, “Tehud a essa a lállaki a tehud a mula a kayu a igos ten kaubasan na. Nadid, dikona panahun dán nen págbunga na ay angay na inileng ni tehud dán a bunga, peru awan siya ti netan. ");
INSERT INTO prfNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Kaya kinagi na ten págtarabahuwán na ten kaubasan na, ‘Tálluwák dán a taon a mágsasoli-soliyán háddi tánni ilingán ku ni magbunga dán, peru awan bela magbunga-bunga. Mas mapiyya pa wád ni pukanán dálla! Gapu makasiwal la ti agumidi a mula.’ ");
INSERT INTO prfNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Peru tummábbig en págtarabahuwán na, ‘Dyan ta pala pukanán, palipasán ta pa en sataon. Kotkotan ku i lebut ni ponan naen sakay dáttonan ku ti págpaoya. ");
INSERT INTO prfNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Mara ni magbunga ti tamuwánnidi a taon ay maganda, peru ni awan ay papukan mu dán!’ ” ");
INSERT INTO prfNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Nadid, ten Aldew nen Káimang ay nagtoldu ti Jesus ten sinagoga. ");
INSERT INTO prfNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Tehud a bábbi haud a sapulu ay ti walu dán a taon a tehud a saket gapu tehud a madukás a ispiritu a summáddáp dikona. Kábbung siya a tarud sakay awan na dán meolnat en bággi na. ");
INSERT INTO prfNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Ten pákketa ni Jesus ten bábbi ay dinulawan na sakay kinagi na, “Nagpiyya ka dán, awan ka dán ti saket!” ");
INSERT INTO prfNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Intupu ni Jesus en lima na ten bábbi, sakay pagdaka na dán a neolnat en bággi na sakay nagpuri siya ten Diyos. ");
INSERT INTO prfNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Peru nagsaranta en pinunu ten sinagoga gapu nagpapiyya ti Jesus ten Aldew nen Káimang, kaya kinagi na ten tolay hidi, “Tehud kitam a ánnám a aldew a págtarabahu, angay kam háddi ti aldewid a hidi iyud para pagamot, bakán a ten Aldew nen Káimang.” ");
INSERT INTO prfNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Peru tinábbig siya nen Panginoon, “Sikam a mágwariwari hidi! Awan beman angen moy iyula en baka moy oni en asno moy, sakay angen moy painomán maski ni Aldew nen Káimang? ");
INSERT INTO prfNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Nadid ked háddi i bábbiyiday a gubwat ten lahi ni Abraham a pinahirapan siya ni Satanas ten sapulu ay ti walu a taon, awan beman dapat la a pagpiyyaán siya maski ten Aldew nen Káimang?” ");
INSERT INTO prfNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Gapu ten intábbig ni Jesus ay napasaniki en atanan nen kontra hidi dikona, sakay minasaya en katolayan gapu ten ginamet hidi ni Jesus a mágkaganda a bagay. ");
INSERT INTO prfNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Káttapos ay kinagi ni Jesus, “Ánya kaparehuwid nen pághari nen Diyos? Hádya ku iyád a iparehu? ");
INSERT INTO prfNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Kona iyád ten kabaditan a bukál nen mustasa a immula nen essa a tolay ten uma na. Dummikál iyud sakay nagin kona ten essa a kayu sakay naglobunan nen ibun hidi en pinge-pinget na.” ");
INSERT INTO prfNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Kinagi pa ni Jesus, “Ánya i pángparehuwan kuwid ten pághari nen Diyos? ");
INSERT INTO prfNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","I kaparehuwid ni iyád ay kona ten págpaalsa a inhalu nen essa a bábbi ten tállu a takal ni arina, kaya ummalsa en buu a namasa.” ");
INSERT INTO prfNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Dikona a ummangay ti Jesus ti Jerusalem ay nagtoldu siya ten banuwan hidi sakay ten babaryu a dinamanan na. ");
INSERT INTO prfNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Sakay tehud a nagtanung dikona, “Panginoon, sasangan beman la i maligtasid?” ");
INSERT INTO prfNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Kinagi ni Jesus, “Mapiit en pintuwan a patamu ten kahariyan nen Diyos, kaya pilitán moy a makasáddáp gapu makpal pumilitid a somdáp peru awan hidi makasáddáp.” ");
INSERT INTO prfNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","“Ni insiradu dán nen makábbilay en pintuwan ay awan na kamon pasáddáppán maski mágtatoktokán kam a mákkekagbi, maski pa kagiyán moy a, ‘Panginoon, kagbiyan mu kami pay a pasáddáppán.’ Peru tábbigán na kam ti kona háddi, ‘Awan takam mágkatenggi.’ ");
INSERT INTO prfNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Káttapos ay kagiyán moy a, ‘Kaguman mu kami a kumman sakay umminom. Sakay nagtoldu ka bi ten banuwan mi.’ ");
INSERT INTO prfNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Peru tumábbig siya a ruway, ‘Awan takam mágkatenggi! Adeyuwanák moy, sikam a mággamet hidi ti madukás!’ ");
INSERT INTO prfNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Mamagsangetan kam sakay mággaaduyán haud ni ketan moy dán ten kahariyan nen Diyos de Abraham, Isaac, ti Jacob sakay en atanan a propeta hidi, mentras a paadeyuwán na kam. ");
INSERT INTO prfNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Dumemát en tolay hidi a magipun-ipun a gubwat ti sikatan, ti sarámman, ti amiyanan, ti abagatan, sakay angay hidi mákpággatubeng a kuman ten lamisaan ten kahariyan nen Diyos. ");
INSERT INTO prfNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Talaga a tehud a dimudyan a medipalongu, sakay tehud a dipalongu a medimudyan.” ");
INSERT INTO prfNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Ti odasid a iyud ay tehud a sangan a Pariseo a ummadeni kánni Jesus sakay kinagi di, “Lumakad ka dán háddi sakay umangay ka ti iba a lugar, gustu ka a pabunu ni Herodes.” ");
INSERT INTO prfNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Tummábbig ti Jesus, “Kagiyán moy ti abusadorid a iyán a tolay a magpalayasák pa ti dimonyo sakay magpapiyyaák ten tehud hidi a saket nadid a aldew hanggan ni ilaw, sakay ten katállu pa a aldew ay tapusán ku gamet kuwiday. ");
INSERT INTO prfNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Peru dapat ku a itulos en lakad ku nadid, ni ilaw sakay puwera ni ilaw, gapu awan dapat a matay en essa a propeta ten iba a banuwan, dapatid ay ti Jerusalem la! ");
INSERT INTO prfNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“Sikam a taga-Jerusalem hidi, binábbunu moy en propeta hidi, sakay binábbatu moy en inutusan hidi nen Diyos dikomoy. Pumensangan takamon a gustu a lákkáppan a kona ten páglákkáp nen manok ten sepsep na hidi, peru umád kam. ");
INSERT INTO prfNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Kaya nadid ay mapabayan dán en Templo moy. Kagiyán ku dikomoy, a awanák moy dán keketan a hanggan a awan dumemát en odas a kagiyán moy a, ‘Pagpalaán en mágdadedemát ten ngaran nen Panginoon!’ ” ");
INSERT INTO prfNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Nadid ten Aldew nen Káimang ay inimbitaan nen essa a pinunu nen Pariseo hidi ti Jesus a angay kuman ten bilay na, sakay bábbantayan di en atanan nen ararikad na haud. ");
INSERT INTO prfNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Tehud haud a essa a lállaki a ummadeni kánni Jesus a tehud a lábbig. ");
INSERT INTO prfNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Kaya tinanung ni Jesus en Pariseo hidi sakay en tagapagtoldu hidi nen Kautusan, “Kontra beman ten Kautusan i magpapiyyaid ten Aldew nen Káimang oni awan?” ");
INSERT INTO prfNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Peru awan hidi ti kákkagi, kaya tinawidan ni Jesus en tehud a saket, pinagpiyya na sakay pinauli na dán. ");
INSERT INTO prfNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Káttapos ay kinagi ni Jesus dikodi, “Mara ni tehud kam a anak oni baka a matáknig ten bal-ung, awan beman alapán moy iyud maski Aldew ni Káimang?” ");
INSERT INTO prfNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Awan hidi nakatábbig ten intanung ni Jesus. ");
INSERT INTO prfNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Nahalata ni Jesus en agum a bisita ten bilay nen Pariseo a nagpili hidi ti pággetnudan di a pang-marangal, kaya kinagi na dikodi i talinhagaid a iddi. ");
INSERT INTO prfNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Mara ni tehud a mangakit dikomoy ten essa a kasalan ay dyan moy piliyán en pang-marangal a pággetnudan ta bakay tehud hidi a nánghandaan a mas marangal a tolay nan sikam ten pággetnudan a pinili moy. ");
INSERT INTO prfNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Gapu mapasaniki kam ni kagiyán nen nagakit dikomoy a, ‘Kagbiyan pay a paetnudán i tolayiday ti pággetnudan muwen.’ Kaya i mangyariyid ay mapasaniki kam sakay meangay kam ten pang-mababa a pággetnudan. ");
INSERT INTO prfNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Magandaid ay mággetnud kam pa ten pang-mababa a pággetnudan tánni umadeni en nangimbita dikomoy ay kagiyán na a, ‘Amigu ku, háddi ka a mággetnud ti pang-marangalidi a pággetnudan.’ Ni kona haád i mangyariyid ay ketan nen agum a tolay a marangal kam. ");
INSERT INTO prfNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Gapu en magpakataas ay mebaba, sakay en magpakababa ay metaas” ");
INSERT INTO prfNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Káttapos ay kinagi ni Jesus ten nangakit dikona, “Mara ni maghanda ka ay dyan ka mangakit ten makapangakit bi dikomu a kona ten amigu mu hidi, kapatkaka mu hidi, kapartidu mu hidi oni en mágkayaman hidi a kadatigan mu. Gapu akitán di ka bi ay magantiyan dán en ginamet mu. ");
INSERT INTO prfNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Peru ni maghanda ka ay akitán mu en kakakagbi hidi a kona ten pubri hidi, pengkaw, pilay, sakay en burák. ");
INSERT INTO prfNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Gapu awan hidi ti anggen a mangakit bi dikomu, kaya magin pinagpala ka gapu en Diyos manggantiyid dikomu ten aldew nen kákkabiyag a ruway nen tolay hidi a matuwid.” ");
INSERT INTO prfNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Dikona a nasanig iyád nen essa ten katubeng de Jesus ay kinagi na, “Pinagpala en makaguman a mákpággatubeng ten handaan ten kahariyan nen Diyos!” ");
INSERT INTO prfNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Peru tummábbig ti Jesus, “Tehud a essa a lállaki a naghanda ti dikál a handaan, sakay makpal en inakit na. ");
INSERT INTO prfNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Dikona a dummemát dán en odas nen handaan ay inutusan na en utusan na hidi. Angay na impekagi ten inakit na hidi a angay dán hidi haud gapu nakahanda dán en atanan. ");
INSERT INTO prfNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Peru nagdahilan en atanan nen inakit na hidi. Kinagi nen purumeru, ‘Kagiyán mu dálla dikona a awanák makaangay, gapu nakabaliyák ti luta, kailangan a angen ku iyud ilingán.’ ");
INSERT INTO prfNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Sakay kinagi nen essa, ‘Gustu ku nakuwan a umangay peru namaliyák biyay ti sapulu a baka, kailangan a purbaan ku hidi tánni matukuyan ku ni maganda hidi a pagaradu.’ ");
INSERT INTO prfNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Kinagi bi nen essa a, ‘Awanák makaangay gapu biguwák a kasal.’ ");
INSERT INTO prfNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Kaya nagsoli en utusan sakay imbareta na ten panginoon na en kinagi nen inakit na hidi. Káttapos ay nagsaranta en panginoon na, kinagi na, ‘Nay, alistu ka, angay mu akitán en kakakagbi hidi ten buu a banuwan, akitán mu en pubri hidi, pengkaw, burák sakay en pilay hidi.’ ");
INSERT INTO prfNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Summunud en utusan sakay nagsoli a kinagi na ten panginoon na a dummemát dán en inakit na hidi. Peru awan palla naputat en bilay ti tolay. ");
INSERT INTO prfNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Kaya kinagi nen panginoon ten utusan na, ‘Lumuwas ka a ruway, sakay angay ka ten mas adeyu hidi a lugar, pilitán mu en tolay hidi a angay háddi tánni maputat i bilay kuwiday. ");
INSERT INTO prfNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Kagiyán ku dikomoy, maski essa ten purumeru ku hidi a inakit ay awan makaennam ten inhanda ku!’ ” ");
INSERT INTO prfNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Nadid, nákkuyug kánni Jesus en katolayan hidi kaya ummatubeng siya dikodi sakay kinagi na, ");
INSERT INTO prfNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Awan maari a magin disepulus ku en deyaman a mangmahal ten ama ay ten ina na, kabinga na ay ten anak na hidi, kákkapatkaka na sakay en sadili na a biyag ti mas higit nan dikoku. ");
INSERT INTO prfNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Sakay ni deyaman en awan mangbáklay ten sadili na a kudus sakay sumunud dikoku ay awan maari a magin disepulus ku. ");
INSERT INTO prfNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Ni tehud a essa dikomoy a magbalak a magpabilay ti malangkaw a bilay, awan beman umetnud pa siya sakay kuwentaán na ni sakonya magastus naid para matukuyan na ni tehud siya a pilak a pangpatapos na ten ipabilay na? ");
INSERT INTO prfNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Bakay ni kákkedátton nen pundasyon ay hanggan dálla haud. Pagtawaan la iyud nen atanan a maketa. ");
INSERT INTO prfNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Kona háddi i kagiyán diyid, ‘Sinapulan ni tolayiday a magpabilay ti dikál peru awan na labi kaya a tapusán.’ ");
INSERT INTO prfNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Kona labi iyád ten essa a hari a tehud a sapulu a libu a sundalu, awan beman adalán na pa ti mapiyya ni konya na a kalabanán en essa a hari a tehud a duwapulu a libu a sundalu? ");
INSERT INTO prfNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Sakay ni ketan na a awan na kaya, ay adeyu palla en kalaban ay mangutus dán siya ti angay mákpagkasundu dikodi. ");
INSERT INTO prfNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Kona labi hud, awan maari a magin disepulus ku en deyaman ni awan na adággan en atanan ten biyag na.” ");
INSERT INTO prfNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Maganda en asen, peru ni mawan en lasa na, ay konya dán a mapaasen a ruway? ");
INSERT INTO prfNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Awan dán iyud ti pakinabang maski ten luta, oni maski ten págsapwagan, kaya ibut dálla. Mágsanig en tehud págsanig!” ");
INSERT INTO prfNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Nadid, ten essa a aldew ay en mágsinger hidi ti buwes sakay en makasalanan hidi ay angay nágsanig kánni Jesus. ");
INSERT INTO prfNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Dikona netan hidi nen Pariseo hidi sakay nen tagapagtoldu hidi nen Kautusan ay namagreklamuwan hidi. Kinagi di, “I tolayid a iyán ay mákpággagum ten makasalanan hidi sakay mákpággatubeng siya a kuman dikodi.” ");
INSERT INTO prfNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Kaya kinagi ni Jesus dikodi en essa a talinhaga. ");
INSERT INTO prfNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","Kinagi na, “Ni en essa dikomoy ay tehud a datos a tupa sakay mawan en essa, ánya i gamitán naid? Awan beman iwarak na en siyam a pulu ay ti siyam ten parang sakay angen na aryokán en nawan a hanggan metan na iyud? ");
INSERT INTO prfNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Nadid, ni metan na dán iyud ay báklayán na sakay sumoli siya a masaya. ");
INSERT INTO prfNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Káddemát na ten bilay na ay akitán na en amigu na hidi sakay en kadatigan na hidi. Kagiyán na dikodi a, ‘Mákpagsaya kam dikoku, gapu netan ku dán en tupa ku a nawan!’ ");
INSERT INTO prfNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Kagiyán ku dikomoy, a magkahud ti dikál a kasayaan dilanget gapu ten essa a makasalanan a nagsisi nan ten siyam a pulu ay ti siyam a matuwid a awan kailangan a magsisi.” ");
INSERT INTO prfNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Kinagi pa ni Jesus, “Ni tehud a sapulu a silber a pilak en essa a bábbi sakay nebut en essa, ánya wád i gamitán naid? Awan beman taban na en simbuwan sakay walisan na en buu a bilay, sakay pakaaryokán na, hanggan metan na? ");
INSERT INTO prfNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Nadid, pákketa na ay dulawán na en amigu na hidi sakay en kadatigan na hidi, sakay kagiyán na, ‘Mákpagsaya kam dikoku gapu netan ku dán en nebut ku a silber a pilak!’ ");
INSERT INTO prfNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Kagiyán ku dikomoy, a kona bi hud en kasayaan nen anghel hidi nen Diyos gapu ten essa a makasalanan a nagsisi.’ ” ");
INSERT INTO prfNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Kinagi pa ni Jesus, “Tehud a essa a tolay a tehud a anak a duwwa a lállaki. ");
INSERT INTO prfNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Nadid ay kinagi nen dipos, ‘Ama ku, iyatád mu dán pay dikoku en mana ku!’ Kaya binunong nen ama dikodi en ari-ariyan na hidi. ");
INSERT INTO prfNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Kállipas nen sangan a aldew ay inlaku nen dipos en mana na. Sakay ummangay siya ten adeyu a lugar, tawid na en atanan a kayamanan na sakay ginasta na haud en pilak na ti awan maganda a kákkabiyag. ");
INSERT INTO prfNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Nadid, dikona a naubus na dán en pilak na ay nagkahud ti mahigpit a aláp ti lugarid a iyud, hanggan a naghirap siya. ");
INSERT INTO prfNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Kaya summáddáp siya a utusan ten essa a lállaki a taga haud. Pinaangay na siya ten uma na a magalaga ten babuy na hidi. ");
INSERT INTO prfNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Nadid gapu ten aláp na dán, sakay awan bi ti mangatád dikona, ay ngari-ngari a mákkan dán siya ten bunga nen kayu a ipáppakan na ten babuy hidi. ");
INSERT INTO prfNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Kaya naisipan na en ginamet na sakay kinagi na ten sadili na a, ‘En utusan hidi nen ama ku ay awan hidi magala-aláp, kompletu hidi ti makan sakay magsusubra pa. Peru sikán ay kedák háddi a matay dán ti aláp!’ ");
INSERT INTO prfNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Soliyák dán ten ama ku, sakay kagiyán ku dikona a, ‘Ama ku, nagkasalaák ten Diyos sakay dikomu. ");
INSERT INTO prfNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Awanák mu dán dapat a dulawán a anak, ibilangák mu dálla a essa ten utusan mu hidi.’ ");
INSERT INTO prfNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Káttaknág na ay lakad na dán a summoli ten ama na. “Adeyu palla siya ten bilay di ay netan-awan dán siya nen ama na, kinagbiyan na siya ti hustu. Kaya gumággenan en ama na a tummagbu dikona sakay kinábkábban na siya sakay inámmuwan na. ");
INSERT INTO prfNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Káttapos ay kinagi nen anak ten ama na, ‘Ama ku, nagkasalaák ten Diyos, sakay dikomu. Awanák mu dán dapat a dulawán a anak!’ ");
INSERT INTO prfNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Peru dinulawan nen ama en utusan na hidi, sakay kinagi na dikodi, ‘Alistu kam! Iyangay moy háddi en kagandaan a badu sakay isulot moy dikona. Sulutan moy bi siya ti sangkalan sakay sandalyas. ");
INSERT INTO prfNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Alapán moy bi en pinatabi ku a baka, sakay bunuwán moy ta kuman kitam sakay magsaya! ");
INSERT INTO prfNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Gapu kumán dán a natay i anak kuwiday, peru nabiyag a ruway, nawan siya peru netan a ruway.’ Kaya nagsaya hidi. ");
INSERT INTO prfNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Nadid, en panganay ay awan palla haud, ked palla siya ten uma di. Ten káuli na, dikona a adeni dán siya ten bilay di ay nasanig na en tugtugan sakay sayawan. ");
INSERT INTO prfNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Kaya dinulaw na en essa ten utusan di hidi, sakay tinanung na ni bakin a tehud a kasayaan ten bilay di. ");
INSERT INTO prfNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Kinagi nen utusan dikona, ‘Dummemát en wadi mu! Kaya pinabunu ni ama mu en pinatabi na a baka, gapu nagsoli en wadi mu a biyag sakay awan ti saket!’ ");
INSERT INTO prfNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Nagsaranta en panganay, awan na gustu a somdáp ten bilay di. Kaya lummuwas en ama na sakay inangon-angon na siya. ");
INSERT INTO prfNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Peru kinagi na ten ama na, ‘Ama ku, nagserbiyák dikomu ti makpal a taon, sakay awan taka sinuway, peru maski pumensan ay awanák mu inátdenan ti maski essa la a bul-u a kambing para pagkasayaanan mi ay ten amigu ku hidi. ");
INSERT INTO prfNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Peru nadid a dummemát i anak muwen a nággagastaán ten kayamanan mu ten pággaibábbi na ay nagbunu mu pa siya ten pinatabi mu a baka!’ ");
INSERT INTO prfNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Kinagi nen ama na, ‘Anak ku, pirmi taka a kaguman, kao mu en atanan a ari-ariyan ku. ");
INSERT INTO prfNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Peru dapat kitam a magkasayaan gapu kuwenta a natay dán en wadi mu, peru nabiyag a ruway, nawan peru netan a ruway.’ ” ");
INSERT INTO prfNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Káttapos ay kinagi ni Jesus ten disepulus na hidi, “Tehud a essa a lállaki a mayaman, impabahala na en ari-ariyan na ten katiwala na. Tehud a nagpilet dikona a gággastaán nen katiwala na en ari-ariyan na hidi. ");
INSERT INTO prfNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Kaya pinadulaw na siya sakay tinanung na, ‘Ánya ben i nabareta kuwiday tungkul dikomu? Iyatád mu dikoku en listaan nen pinamahalaan mu a ari-ariyan ku. Sapul nadid ay ibutan taka dán ten tarabahu mu.’ ");
INSERT INTO prfNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Kinagi nen katiwala ten sadili na, ‘Ánya wád i dapat kuwid a gamitán gapu ibutanák dán nen amu ku? Awan ku pa bi tukoy a magtarabahu ti luta sakay masanikiyák bi a máklimu-limus. ");
INSERT INTO prfNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Tukoy ku dán! Kona háddi i gamitán kuwid tánni maski maibutanák ten tarabahu ku ay tehudák palla a amigu a mangakit dikoku ten bilay di!’ ");
INSERT INTO prfNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Kaya dinulaw na en balang essa a tehud a utang ten amu na. Tinanung na en purumeru, ‘Sakonya i utang muwid ten amu ku?’ ");
INSERT INTO prfNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Tummábbig siya, ‘Datos a tapayan a langis.’ ‘Salaid en kasulatan nen utang mu. Mággetnud ka, alistuwan mu a isulat gamitán mu dálla a limmapulu.’ ");
INSERT INTO prfNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Káttapos ay tinanung na bi en kaduwwa, ‘Siko, sakonya i utang muwid?’ ‘Datos a kostal a trigo,’ kagi na. ‘Salaid en kasulatan nen utang mu. Isulat mu a walu a pulu dálla.’ ");
INSERT INTO prfNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Pinuri nen amu en katiwala na a madaya gapu ten impeta na a karunungan. Gapu mas malalaki a maggamet ti paraan en makamundu hidi a tolay ten biyag di nan en tolay hidi a maka-diyos.” ");
INSERT INTO prfNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Káttapos ay kinagi ni Jesus, “Kaya kagiyán ku dikomoy, gamitán moy en kayamanan ni munduwiday ten pággamet ti maganda ten kaparehu moy a tolay tánni ni maubus dán iyud ay tanggapán kam bi ten bilay a awan ti katapusan. ");
INSERT INTO prfNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","En tolay a maari a pagkatiwalaan ten badit a bagay ay maari bi a pagkatiwalaan ten dikál a bagay, sakay en mangdaya ten badit a bagay ay mangdaya bi ten dikál a bagay. ");
INSERT INTO prfNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Gapu ni awan kam mapagkatiwalaan ten kayamanan ti munduwiday, ay deya i magtiwalaid dikomoy ten tatarudan a kayamanan? ");
INSERT INTO prfNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Sakay ni awan kam mapagkatiwalaan ten kayamanan nen agum a tolay, ay deya i mangatáddid ti talaga a para dikomoy? ");
INSERT INTO prfNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Awan maari a sabay a pagserbiyan nen essa a utusan en duwwa a amu gapu kaiyamutan na en essa sakay mahalán na en kaduwwa. Pagserbiyan na ti tapat en essa sakay en essa ay awan na pagtapatan. Awan moy maari a pagsabayán a serbiyan en Diyos sakay en kayamanan.” ");
INSERT INTO prfNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Dikona a nasanig iyud nen Pariseo hidi en kinagi ni Jesus kaya nagtawaan di gapu masássorán hidi ti pilak. ");
INSERT INTO prfNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Peru kinagi ni Jesus dikodi, “Magkukunwari kam a matuwid ten atubengán nen tolay hidi, peru tukoy nen Diyos en ked ten pusu moy. Gapu en bagay hidi a pahalagaan nen tolay ay sasala nen Diyos.” ");
INSERT INTO prfNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“En Kautusan ni Moises sakay en insulat nen propeta hidi ay tehud la iyád a bisa hanggan ten panahun ni Juan a Mágbinyag. Sapul haud ay impangaral dán en Maganda a Bareta tungkul ten pághari nen Diyos. Kaya magpumilit en atanan a makaangay haud. ");
INSERT INTO prfNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Alistu pa a mawan en langet ay ten luta, peru maski en sabadit la a bahagi ten Kautusan nen Diyos ay awan mawanan ti bisa.” ");
INSERT INTO prfNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Ni pinalakad nen lállaki en kabinga na sakay mákkabinga ti iba ay nagkasala siya ti pángngalunya. Sakay en mangkabinga bi ten bábbi a hiniwalayan ay nagkasala bi ti pángngalunya.” ");
INSERT INTO prfNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Kinagi pa ni Jesus, “Tehud a essa a mayaman a lállaki a mágbabaduwán ti mágkamahal sakay sagana ti pagkain a aldew-aldew. ");
INSERT INTO prfNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Tehud bi a essa a pubri a Lazaro en ngaran na, makpal siya a talingu ten babággi na. Iyáangay di siya ten pintuwan nen bilay nen mayaman. ");
INSERT INTO prfNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Umasa ti Lazaro a makakan ten maski mágkeragrag a mumu ten lamisaan nen mayaman. Adeniyan siya nen kaasuwan sakay dáddeldelan di en talingu na hidi. ");
INSERT INTO prfNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Natay en pubri sakay inyangay nen anghel hidi ten páppágyanan ni Abraham dilanget. Natay bi en mayaman sakay nelábbáng. ");
INSERT INTO prfNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Mentras a mágtatiisán en mayaman ten lugar nen patay hidi, ay natan-aw na ti Lazaro a ked ten páppágyanan ni Abraham. ");
INSERT INTO prfNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Kaya pummákraw siya, ‘Ama ku a Abraham, kagbiyan pay a utusan ti Lazaro a ilábláb na i guramát naen ti dinomen, sakay ipaturug na ti dila kuwiday tánni malamiganák, gapu mahirapanák dán háddi a tarud ti apoyiday!’ ");
INSERT INTO prfNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Peru kinagi ni Abraham dikona, ‘Anak ku, alalahanán mu a nagpakasawa ka ten biyag mu ten dibabew nen luta. Peru ti Lazaro ay nágtatiisán ti hirap. Nadid ay masaya dán en biyag na háddi, peru siko ay ked ka haán a mágdadusaán. ");
INSERT INTO prfNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Bakán la a iyán, tehud pa a madsalad a pengpeng ten pag-itan nen págyanan tam kaya en ked háddi ay awan makaangay haán, sakay en ked haán ay awan bi makaangay háddi.’ ");
INSERT INTO prfNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Kinagi nen mayaman, ‘Ni konahud, ama ku a Abraham, mákkekagbiyák pay dikomu a paangayán mu ti Lazaro ten bilay nen ama ku. ");
INSERT INTO prfNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Tehudák a limma a kákkapatkaka a lállaki haud, utusan mu siya a angay na hidi pagkagiyan tánni awan bi hidi meangay ti lugaridi a pagdusaan ku.’ ");
INSERT INTO prfNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Peru kinagi ni Abraham dikona, ‘Ked dán dikodi en insulat ni Moises sakay nen propeta hidi. Saiyud dán i sunudán diyid.’ ");
INSERT INTO prfNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Tummábbig en mayaman, ‘Bakán la a basta konahud, peru ni umangay dikodi en essa a natay dán sakay nabiyag a ruway ay magsisi hidi sakay adággan di en kasalanan di.’ ");
INSERT INTO prfNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Peru kinagi ni Abraham, ‘Ni awan di paniwalaan en insulat ni Moises sakay nen propeta hidi ay awan di bi paniwalaan en kagiyán nen essa a natay a nabiyag a ruway.’ ” ");
INSERT INTO prfNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Nadid, kinagi ni Jesus ten disepulus na hidi, “Pirmi a tehud a dahilan para magkasala en tolay, peru makaánteng en keangayan nen tolay a magin dahilan nen págkasala! ");
INSERT INTO prfNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Magandaid dikona ay báttenan ti dikál a gilingan a batu en állig na sakay ibator ditaw a diget, nan ni magin dahilan nen págkasala ni bábbadit palla iday hidi. ");
INSERT INTO prfNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Kaya mangilag kam! “Ni magkasala dikomu en kapatkaka mu ay kagiyan mu sakay ni magsisi siya ay patawadán mu. ");
INSERT INTO prfNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Ni pumenpittu siya a nagkasala dikomu ten saldew, sakay pumenpittu bi a umadeni dikomu a magkagi a, ‘Magsisiyák dán’ ay kailangan a patawadán mu.” ");
INSERT INTO prfNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Káttapos ay kinagi nen apostol hidi kánni Jesus, “Panginoon, dagdagan mu pay en pánnampalataya mi!” ");
INSERT INTO prfNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Tummábbig en Panginoon, “Ni kumona nakuwan dálla ti kadikál nen bukál ni mustasa en pánnampalataya moy ay maari moy dán a kagiyán ti kayuwen a sikomoro a, ‘Mabagut ka haán sakay memula ka ti digitud,’ ay sumunud iyád dikomoy.” ");
INSERT INTO prfNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Ipalagay tam a tehud kam a utusan a magaradu, oni magula ti tupa. Nadid kággubwat na ten uma ay kagiyán moy beman dikona a, ‘Karon dán, angay ka dán kuman?’ ");
INSERT INTO prfNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Awan beman i kagiyán moyid ay, ‘Maglewas ka dán sakay paghandaák mu ti pangapon ku, sakay serbiyanák mu mentras a kumanák. Káttapos ku a kuman ay maari ka dán a kuman.’ ");
INSERT INTO prfNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Kailangan beman a pasalamatan en utusan gapu ten kássunud na ten inyutus dikona? ");
INSERT INTO prfNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Kumán labi iyád a kona dikomoy, ni magamet moy dán a atanan a inyutus dikomoy ay iddi i kagiyán moyid, ‘Utusan kami la sakay ginamet mi la en tungkulin mi.’ ” ");
INSERT INTO prfNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Dikona patamu dán ti Jesus ti Jerusalem ay nagkon siya ten pag-itan ni Samaria sakay Galilea. ");
INSERT INTO prfNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Nadid, dikona a adeni dán siya ten essa a baryu ay tummagbu en sapulu a kinetong peru awan hidi ummadeni kánni Jesus. ");
INSERT INTO prfNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Sakay impákraw di, “Jesus a Panginoon, kagbiyan mu kami pay!” ");
INSERT INTO prfNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Pákketa ni Jesus dikodi ay kinagi na, “Kammoy dán tulos kamon a magpaileng ten padi hidi.” Mentras a maglakad hidi ay nagpiyya hidi sakay kinuminis. ");
INSERT INTO prfNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Dikona nabati nen essa a nagpiyya dán siya ay nagsoli a ipáppákraw na a magpuri ten Diyos. ");
INSERT INTO prfNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Káttapos ay lummuhud siya ten atubengán ni Jesus sakay nagpasalamat, siya ay taga-Samaria. ");
INSERT INTO prfNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Kinagi ni Jesus, “Awan beman sapulu kam a nagpiyya? Hádya dán en siyam? ");
INSERT INTO prfNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Bakin bakán pa a Judio i nagsoliyid a nagpuri ten Diyos?” ");
INSERT INTO prfNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Sakay kinagi ni Jesus dikona, “Tumaknág ka sakay umuli ka dán! Nagpiyya ka gapu ten pánnampalataya mu.” ");
INSERT INTO prfNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Tinanung nen Pariseo hidi ti Jesus ni nikan en pághari nen Diyos ti munduwiday. Tummábbig ti Jesus, “En sapul nen pághari nen Diyos ay awan kam ti ketan a tanda. ");
INSERT INTO prfNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Kaya awan ti mangkagi a nagsapul dán háddi oni hudi. Gapu i tatarudanid ay maghari dán en Diyos dikomoy.” ");
INSERT INTO prfNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Káttapos ay kinagi na ten disepulus na hidi, “Gustuwán moy a ketan en essa ten aldew hidi nen Anak nen Tolay, peru awan moy ketan. ");
INSERT INTO prfNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Tehud a mángkagi dikomoy a, ‘Ked siya hudi!’ oni ‘Ked siya háddi!’ Peru dyan kam umangay sakay dyan maniwala dikodi. ");
INSERT INTO prfNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Gapu káddemát nen netakda a aldew ay dumemát en Anak nen Tolay a kumán a kilat a magdemlag dilanget. ");
INSERT INTO prfNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Peru kailangan a magtággád pa siya ti makpal a hirap sakay itakwil siya nen tolay hidi nadid a panahun. ");
INSERT INTO prfNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","En káddemát nen Anak nen Tolay ti munduwiday ay magkakona ten nangyari dikona panahun ni Noe. ");
INSERT INTO prfNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","En tolay hidi tenhud ay mamagkainan, mamaginoman sakay mamágkabingaan a hanggan dikona a dummemát en aldew a summakay ti Noe ten barku. Dummemát en dilobyu sakay nágkalimás hidi a atanan. ");
INSERT INTO prfNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Kona labi hud ten panahun ni Lot, mamagkainan en tolay hidi, mamaginoman, mamagbaliyan, mamaglakuwan, mamagmulaan, sakay mamagbilayan. ");
INSERT INTO prfNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Peru dikona a lumakad ti Lot ti Sodoma ay naguden ti apoy sakay asupre kaya natutud hidi a atanan. ");
INSERT INTO prfNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Kona labi hud i mangyariyid káddemát nen Anak nen Tolay. ");
INSERT INTO prfNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Ti aldiwid a iyud, en ked ten atáp ay dyan dán magabala a umugsad sakay somdáp ten bilay na a mangalap ten kasangkapan na hidi. En ked ten uma na ay dyan dán magabala a umuli. ");
INSERT INTO prfNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Isipán moy dálla en nangyari ten kabinga ni Lot. ");
INSERT INTO prfNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Ni deyaman en magsikap a mángligtas ten sadili na a biyag ay mawanan ti biyag. Peru ni deyaman en mawanan ti biyag ay siya en makapángligtas ten biyag na. ");
INSERT INTO prfNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Kagiyán ku dikomoy, a ti gibiyid a iyud ay tehud a duwwa a tolay a tidug ten essa a katri, maalap en essa sakay mawarak en essa. ");
INSERT INTO prfNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Tehud bi a duwwa a bábbi a magkaguman a maggiling, maalap en essa sakay mawarak bi en essa. ");
INSERT INTO prfNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Tehud bi a duwwa a lállaki a magtarabahu ten uma di, maalap en essa sakay mawarak bi en essa.” ");
INSERT INTO prfNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Nagtanung en disepulus na hidi, “Hádya iyád a mangyari, Panginoon?” Tummábbig ti Jesus, “Ni hádya a tehud a bangkay ay ked bi haud a maipun en wakwak hidi.” ");
INSERT INTO prfNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Nadid, kinagi ni Jesus ten disepulus na hidi en essa a talinhaga tánni itoldu na dikodi a dapat a pirmi hidi a magdasal, sakay dyan mawanan ti pag-asa. ");
INSERT INTO prfNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Kinagi ni Jesus, “Ten essa banuwan, ay tehud a huwes a awan ti ánteng ten Diyos sakay awan siya ti igagalang a tolay. ");
INSERT INTO prfNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Ti banuwanid a iyud ay tehud a bábbi a bilu. Pirmi siya a mágsasoli-soliyán ten huwes a mákkekagbi a pesurug. Kákkagiyán na a, ‘Kagbiyan pay a atáddan ti katarungan i kasu kuwiday.’ ");
INSERT INTO prfNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Nanalay dán a awan pospusán nen huwes en bilu. Peru dummemát en odas a kinagi na ten sadili na, ‘Maski pa ni awanák ti ánteng ten Diyos sakay awanák ti igagalang a tolay, ");
INSERT INTO prfNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","ay mas mapiyya pa ni isurug ku dálla i biluwiday, gapu pirmiyák na a istorbuwán bakay maiyamuták pa ti págsasoli-soli na en.’ ” ");
INSERT INTO prfNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Káttapos ay kinagi nen Panginoon, “Nasanig moy en naisipan nen madukás a huwes. ");
INSERT INTO prfNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Iyud pa beman en Diyos a awan mángsurug dikomoy? Tulungan na en pinili na a pirmi a mákkekagbi dikona aldew ay ti gibi. ");
INSERT INTO prfNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Kagiyán ku dikomoy, a iyatád na a pagdaka dikodi en katarungan. Peru ten káddemát a ruway nen Anak nen Tolay ti munduwiday, ay tehud wád siya a demáttan a mánnampalataya dikona?” ");
INSERT INTO prfNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Nadid, kinagi bi ni Jesus iddi a talinhaga ten tolay hidi a nagisip a matuwid dán hidi, peru imemenos di labi en agum a tolay. ");
INSERT INTO prfNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Kinagi ni Jesus, “Tehud a duwwa a lállaki a summáddáp ten Templo para magdasal. En essa ay Pariseo, sakay en essa ay mágsinger ti buwes. ");
INSERT INTO prfNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Tummaknág en Pariseo sakay nagdasal ti kona háddi tungkul ten sadili na, ‘Magpasalamaták dikomu Diyos ku, gapu awanák kaparehu nen agum a mágkatakaw, mágdaya, mángngalunya, oni kona ti lállakiyidi a mágsinger ti buwes. ");
INSERT INTO prfNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Pumenduwwaák a magkulásyon ti sasimba sakay mággikapuwák ten atanan nen kitaán ku.’ ");
INSERT INTO prfNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Nadid, en mágsinger ti buwes a mágtaknág ten adeyu ay awan na maalap a tumangad dilanget, táttepdagán na en rakaw na, sakay kinagi na, ‘Diyos ku, kagbiyanák mu pay, essaák a makasalanan!’ ” ");
INSERT INTO prfNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","“Kagiyán ku dikomoy, ummuli en mágsinger bi buwes ten bilay na a napatawad dán en kasalanan na hidi. Peru en Pariseo ay awan napatawad. Gapu ni deyaman en magpakataas ay mebaba, sakay en magpakababa ay metaas.” ");
INSERT INTO prfNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Inyadeni nen sangan a tolay kánni Jesus en anak di hidi a bábbadit tánni itupu ni Jesus dikodi en lima na. Dikona a netan iyud nen disepulus hidi ay nagsarantaan di en tolay hidi. ");
INSERT INTO prfNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Peru dinulaw ni Jesus en anak hidi sakay kinagi na ten disepulus na hidi, “Pabayan moy i anaken hidi a umadeni dikoku. Dyan moy hidi sawayán, gapu kona dikodi i paghariyanid nen Diyos. ");
INSERT INTO prfNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Tandaan moy; ni deyaman en awan mangtanggap ten pághari nen Diyos a kona ten essa a anak ay awan paghariyan nen Diyos.” ");
INSERT INTO prfNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Nadid, nagtanung kánni Jesus en pinunu nen Judio hidi, “Mahusay a maistu ánya i dapat kuwid a gamitán tánni mágkahudák ti biyag a awan ti katapusan?” ");
INSERT INTO prfNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Tummábbig ti Jesus, “Bakin dinulawák mu a mahusay? Awan ti agum a mahusay nan en Diyos la! ");
INSERT INTO prfNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Tukoy mu dán en utus hidi nen Diyos, ‘Dyan ka mangalunya, dyan ka mamunu, dyan ka magtakaw, dyan ka magtistigu ti kakabuliyan, sakay igalang mu en ama mu ay ten ina mu.’ ” ");
INSERT INTO prfNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Tummábbig en lállaki, “Sinássunud ku dán hidi iyán a atanan sapul pa dikona a anakák.” ");
INSERT INTO prfNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Dikona nasanig iyud ni Jesus ay kinagi na, “Essa pa a bagay en kulang dikomu, ilaku mu en atanan a ari-ariyan mu sakay iyatád mu ten pubri hidi en naglakuwan mu tánni mágkahud ka ti kayamanan dilanget. Káttapos ay sumoli ka sakay mákkuyug ka dikoku.” ");
INSERT INTO prfNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Nalungkut en lállaki dikona nasanig na iyud gapu tunay siya ti yaman. ");
INSERT INTO prfNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Netan ni Jesus a malungkut siya, kaya kinagi na, “Mahirap a talaga a makasáddáp en mayaman ten kahariyan nen Diyos! ");
INSERT INTO prfNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Mas alistu pa a makasáddáp en kamelyo ten ábbut nen digum, nan ten essa a mayaman a makasáddáp ten kahariyan nen Diyos.” ");
INSERT INTO prfNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Nagtanung en nakasanig hidi, “Ni konahud ay deya i maligtasid?” ");
INSERT INTO prfNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Tinábbig hidi ni Jesus, “En bagay hidi a awan kaya gamitán nen tolay ay kaya a gamitán nen Diyos.” ");
INSERT INTO prfNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Nadid, kinagi ni Pedro, “Ay konya mi dán? Linakadan mi dán en bilay mi hidi para mákkuyug dikomu.” ");
INSERT INTO prfNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Kaya kinagi ni Jesus dikodi, “Tandaan moy kagiyán kuwiday, en tolay a manglakad ten bilay na, kabinga na, kákkapatkaka na, dáddikál na hidi, oni en anak na hidi alang-alang ten kahariyan nen Diyos, ");
INSERT INTO prfNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ay makatanggap siya ti mas makpal ten biyag nadid, sakay magkahud siya ti biyag a awan ti katapusan ten dumemát a panahun.” ");
INSERT INTO prfNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Nadid, imbukud ni Jesus en sapulu ay ti duwwa a disepulus na, sakay kinagi na dikodi, “Mágsanig kam, angay kitam nadid ti Jerusalem sakay haud dán a matupad en atanan nen insulat nen propeta hidi tungkul ten Anak nen Tolay. ");
INSERT INTO prfNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Iyentrega di siya ten Hentil hidi sakay sestiyán di siya, insultuwán, sakay loktaban. ");
INSERT INTO prfNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Bálbággán di siya, sakay tulos di a bunuwán. Peru ten katállu a aldew ay mabiyag siya a ruway.” ");
INSERT INTO prfNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Peru awan ti naintendiyan en sapulu ay ti duwwa a disepulus ten nasanig di. Awan di tukoy en kahulugan na, sakay awan di naintendiyan en kinagi ni Jesus. ");
INSERT INTO prfNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Nadid, dikona a adeni dán ti Jesus ti Jerico ay tehud a essa a lállaki a burák, mággetnud ten gilid nen dilan a máklimus. ");
INSERT INTO prfNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Dikona nasanig na a magtalib en makpal a tolay ay intanung na ni ánya iyud. ");
INSERT INTO prfNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Kinagi di dikona a, “Magtalib ti Jesus a taga-Nazaret.” ");
INSERT INTO prfNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Kaya pummákraw siya, “Jesus, anak ni David! Kagbiyanák mu pay!” ");
INSERT INTO prfNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Sinaway siya nen tolay hidi a ked ten dipalongu, peru inyondug na pa a impákraw a, “Anak ni David, kagbiyanák mu pay!” ");
INSERT INTO prfNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Kaya ummimang ti Jesus, sakay inyutus na a iyangay di dikona en burák. Dikona a ked dán en burák ay tinanung na siya. ");
INSERT INTO prfNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Ánya beman i gustu muwid a gamitán ku dikomu?” Kinagi na, “Panginoon, gustu ku nakuwan a maketaák a ruway.” ");
INSERT INTO prfNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Kinagi ni Jesus dikona, “Maketa ka dán! Nagpiyya ka gapu ten pánnampalataya mu.” ");
INSERT INTO prfNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Ti odas biyid a iyud ay naketa dán en burák, sakay tulos siya a ummunonud kánni Jesus a nágpapuriyán ten Diyos. Dikona a netan iyud nen tolay hidi ay atanan di ay nagpuri ten Diyos. ");
INSERT INTO prfNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Nadid, summáddáp ti Jesus ti Jerico sakay naglakad ten banuwan. ");
INSERT INTO prfNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Tehud haud a essa a lállaki a mayaman a Zaqueo en ngaran na. Siya en pinunu nen mágsinger hidi ti buwes. ");
INSERT INTO prfNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Nasanig na a dummemát ti Jesus, sakay gustu na a ketan ni deya siya. Peru gapu ten kakpal nen tolay ay awan na ketan gapu marenggád siya a tolay. ");
INSERT INTO prfNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Kaya nagginan siya a dummipalongu sakay ummunek ten kayu a sikomoro tánni ketan na ti Jesus a magtalib haud. ");
INSERT INTO prfNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Káttapat ni Jesus ten sarok nen kayu ay tinangad na siya sakay kinagi na, “Zaqueo, umugsad ka dán, alistu ka gapu angayák nadid ten bilay mu.” ");
INSERT INTO prfNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Kaya nagalistu siya a ummugsad ten kayu, sakay tunay siya ti saya a nangtanggap kánni Jesus ten bilay na. ");
INSERT INTO prfNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Nágganasasan en atanan nen naketa hidi ten nangyari sakay kinagi di, “Angay ben siya ten bilay nen makasalanan?” ");
INSERT INTO prfNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Nadid, tummaknág ti Zaqueo sakay kinagi na, “Panginoon, iyatád ku ten pubri hidi en kalahati nen kayamanan ku. Sakay ni deyaman en nadaya ku ay pumen-áppat ku a bayadan.” ");
INSERT INTO prfNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Káttapos ay kinagi ni Jesus, “En kaligtasan ay dummemát dán ti bilayid a iddi, gapu tolayid a iddi ay lahi bi ni Abraham. ");
INSERT INTO prfNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Ummangay háddi en Anak nen Tolay tánni aryokán na en nágketawtaw hidi sakay iligtas na.” ");
INSERT INTO prfNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Mentras a mágsanig en tolay hidi, ay insaysay ni Jesus dikodi en essa pa a talinhaga. Adeni dán ti Jesus ti Jerusalem sakay akalaid nen tolay hidi ay magsapul dán en pághari nen Diyos. ");
INSERT INTO prfNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Kaya kinagi na, “Tehud a essa a lállaki a mataas en katungkulan na, ummangay siya ten adeyu a lugar tánni magin hari haud. Káttapos ay nagsoli labi siya. ");
INSERT INTO prfNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Bagu siya a lummakad ay dinulaw na en sapulu a utusan na, sakay inátdenan na en balang essa dikodi ti pilak a gintu. Sakay kinagi na, ‘Inigosyu moy iyán a hanggan ten kássoli ku.’ ");
INSERT INTO prfNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Peru tunay ti iyamut en kabanuwan na hidi, kaya nangutus hidi ti angay mángkagi ten kataasan a pinunu nen banuwan a umád hidi a magin hari di siya. ");
INSERT INTO prfNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Peru nagin hari labi siya. Nadid, kássoli na ay pinadulaw na en atanan nen utusan a inátdenan na ti pilak a gintu, tánni matukuyan na ni sakonya i ganansiyaid nen balang essa. ");
INSERT INTO prfNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Ummadeni dikona en essa sakay kinagi na, ‘Panginoon, en pilak mu a gintu ay nakaganansiya ti sapulu a pilak a gintu.’ ");
INSERT INTO prfNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Kinagi nen hari, ‘Mahusay ka a utusan! Nadid, gapu matapat ka ten inyentrega ku a badit a bagay ay pamahalaán taka ten sapulu a siyudad.’ ");
INSERT INTO prfNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Ummadeni en kaduwwa sakay kinagi na, ‘Panginoon, en pilak mu a gintu ay nakaganansiya ti limma.’ ");
INSERT INTO prfNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Sakay kinagi na dikona, ‘Pamahalaán taka ten limma a siyudad.’ ");
INSERT INTO prfNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Nadid, ummadeni bi en essa pa a utusan sakay kinagi na, ‘Panginoon, saránnid en pilak mu a gintu. Binalutan ku ti panyu sakay intagu ku. ");
INSERT INTO prfNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Mantingák biyay bi dikomu gapu tunay ka ti kahigpitan. Tukoy ku a alapán mu en bakán mu a kao, sakay aniyán mu en bakán mu a immula.’ ");
INSERT INTO prfNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Káttapos ay kinagi nen hari dikona, ‘Madukás ka a utusan! Hatulan taka ten kinagi mu. Tukoy mu bál a mahigpiták, sakay kinagi mu dikoku a alapán ku en bakán ku a kao sakay aniyán ku en bakán ku a immula. ");
INSERT INTO prfNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Bakin awan mu indipositu ten bangku i pilak kuwen? Tehud nakuwan iyán a ganansiya baguwák a dummemát’ ");
INSERT INTO prfNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Káttapos ay kinagi nen hari ten atanan nen ked hidi haud, ‘Alapán moy dikona en pilak a gintu. Sakay iyatád moy ten tehud a sapulu.’ ");
INSERT INTO prfNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Peru kinagi di, ‘Panginoon, tehud dán siya a sapulu a pilak a gintu?’ ");
INSERT INTO prfNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Kagiyán ku dikomoy, a en tehud dán ay átdenan pa, peru en awan maski en sabadit a ked dikona ay alapán pa. ");
INSERT INTO prfNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Kona bi ten kadima ku hidi a umád dikoku a magin hari di, iyangay moy hidi háddi sakay bunuwán moy hidi ti atubengán kuwidi!’ ” ");
INSERT INTO prfNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Nadid, káttapos na a nagupos ten tolay hidi ay nagrektat dán siya a patamu ti Jerusalem. ");
INSERT INTO prfNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Dikona adeni dán siya ti Betfage sakay ti Betania, ten bukid a ngángngaranan di a Olibo ay pinágdipalongu na en duwwa na a disepulus. ");
INSERT INTO prfNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Kinagi na dikodi, “Kammoy dán, angay kam ti sumunuden a baryu. Káddemát moy haud ay ketan moy en essa a bul-u a asno a umáegut, awan palla iyud nasaka-sakayan. Okbisán moy sakay iyangay moy háddi. ");
INSERT INTO prfNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Ni tehud a magtanung dikomoy ni bakin okbisán moy ay kagiyán moy a, ‘Kailangan nen Panginoon.’ ” ");
INSERT INTO prfNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Kaya lummakad dán en inutusan na a duwwa a disepulus sakay netan di ngani en asno a kinagi ni Jesus. ");
INSERT INTO prfNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Mentras a okbisán di en asno ay tinanung hidi nen makákkao, “Bakin okbisán moy iyán?” ");
INSERT INTO prfNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Kaya kinagi di, “Kailangan nen Panginoon.” ");
INSERT INTO prfNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Inyangay di kánni Jesus en asno, sakay sinapinan di ten alikábkáb di, káttapos ay pinasakay di ti Jesus. ");
INSERT INTO prfNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Nadid, ten kássakay na a patamu ti Jerusalem ay inlatag nen tolay hidi en alikábkáb di hidi ten paglakadan na. ");
INSERT INTO prfNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Dikona a adeni dán siya ti Jerusalem, ten dilan a padagson ten bukid a nginaranan di a Olibo ay nagpákrawan en atanan nen disepulus na hidi gapu ten saya di. Sakay nagpuri hidi ten Diyos gapu ten himala hidi a netan di a ginamet ni Jesus. ");
INSERT INTO prfNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Kinagi di, “Pinagpala en hari a mágdadedemát ten ngaran nen Panginoon! Kapayapaan dilanget! Puriyán en Kataasan!” ");
INSERT INTO prfNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Nadid, tehud a sasangan a Pariseo a kaguman ten katolayan, kinagi di, “Maistu, sawayán mu pay i disepulus muwen hidi.” ");
INSERT INTO prfNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Tummábbig ti Jesus, “Kagiyán ku dikomoy, a ni tumahimik hidi ay lumewas i batuwen hidi a magpákraw.” ");
INSERT INTO prfNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Nadid, dikona a adeni dán siya ti Jerusalem sakay dikona natan-aw na en siyudad ay nagsanget siya. ");
INSERT INTO prfNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Kinagi na, “Ni tukoy mu la ni ánya i makapangatáddid dikomu ti kapayapaan nadid a aldew! Kaya la ay awan mu iyád ketan nadid. ");
INSERT INTO prfNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Dumemát en aldew a magkampu en kadima mu hidi ti lebut muwen. Palebutan di ka sakay bantayan ti mahigpit a magdili-dilipot. ");
INSERT INTO prfNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Puksaán di ka pati en anak mu hidi, awan hidi ti ibura-buray, maski en batu hidi ay awan ti maburay a magkatupu, gapu awan mu pinospos en odas a káddemát nen Diyos a mángligtas dikomu.” ");
INSERT INTO prfNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Káddemát de ti Jesus ti Jerusalem ay summáddáp siya ten Templo, sakay pinalakad na en atanan a tolay a maglaku haud. ");
INSERT INTO prfNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Kinagi na dikodi, “Nakasulat, ‘En bilay ku ay ngaranan di a bilay a págdasalan.’ Peru ánya i ginamet moyiday? Ginamet moy a bilay nen mágtakaw hidi.’ ” ");
INSERT INTO prfNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Aldew-aldew ay magtoldu ti Jesus ten Templo. Peru gustu siya a bunuwán nen pinunu hidi nen padi hidi, nen tagapagtoldu hidi nen Kautusan sakay nen pinunu hidi nen banuwan. ");
INSERT INTO prfNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Peru awan hidi ti netan a paraan ni konya di siya a mabunu gapu en atanan nen tolay ten banuwan ay mágsanig ti mapiyya ten atanan nen kákkagiyán na. ");
INSERT INTO prfNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Nadid, ten essa a aldew ay ked ti Jesus ten disalad nen Templo, nangaral siya tungkul ten Maganda a Bareta. Ummadeni dikona en pinunu hidi nen padi hidi, en tagapagtoldu hidi nen Kautusan, sakay en pinunu hidi nen banuwan. ");
INSERT INTO prfNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Kinagi di dikona, “Kagiyán mu benid dikomi ni ánya karapatan muwid a maggamet ti bagayid a hidi iyád? Deya i nangatáddid dikomu ti karapatan?” ");
INSERT INTO prfNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Tummábbig ti Jesus, “Tanungán takam bi nadid. Kagiyán moy dikoku, ");
INSERT INTO prfNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","hádya gubwatid nen kapangyariyan ni Juan a magbinyag, ten Diyos beman oni ten tolay?” ");
INSERT INTO prfNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Nadid, namágguron hidi sakay kinagi di, “Ni kagiyán tam a, ‘Ten Diyos,’ ay kagiyán na dikotam a, ‘Bakin awan moy pinaniwalaan ti Juan?’ ");
INSERT INTO prfNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Peru ni kagiyán tam bi a gubwat ten tolay, ay batuwán kitam ni tolayen hidi gapu maniwala hidi a essa a propeta ti Juan.” ");
INSERT INTO prfNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Kaya tummábbig hidi, “Awan mi tukoy!” ");
INSERT INTO prfNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Kaya kinagi ni Jesus dikodi, “Ni konahud ay awan ku bi kagiyán dikomoy ni hádya i gubwatid nen karapatan ku a maggamet ti bagayid a hidi iyád.” ");
INSERT INTO prfNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Nadid, kinagi ni Jesus i talinhagaid a iddi ten tolay hidi, “Tehud a essa a tolay a nagmula ti ubas ten uma na sakay impabahala na iyud ten katiwala na hidi. Káttapos ay ummangay siya ti adeyu a lugar sakay nagnalay pa haud. ");
INSERT INTO prfNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Dikona sákburas dán ti ubas ay pinaangay na en essa na a alipin tánni mángngay ten kabunong na a ubas. Peru pákketa nen katiwala hidi ten alipin ay binálbág di sakay pinauli di a awan ti tawid. ");
INSERT INTO prfNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Kaya nangutus siya a ruway ten essa na pa a alipin, peru binálbág di bi siya ti mas mahigpit nan ten dipalongu, ininsultu di siya sakay pinauli di bi a awan ti tawid. ");
INSERT INTO prfNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Nadid, inutusan na en katállu, peru tinalinguwan di siya sakay pinalakad di. ");
INSERT INTO prfNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Kinagi nen makákkao ten kaubasan, ‘Ánya wád i dapat kuwid a gamitán? Maganda wád ni en mahal ku a anak i paangayán kuwid haud. Siguradu a igalang di siya.’ ");
INSERT INTO prfNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Peru dikona a ketan nen katiwala hidi en anak nen makákkakao ay namágguron hidi, kinagi di, ‘Iddi i magmanaid, bunuwán tam siya tánni makao tam en mana na.’ ");
INSERT INTO prfNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Inluwas di siya ten kaubasan, sakay tulos di a binunu.” Káttapos ay kinagi ni Jesus, “Ánya wád gamitánnid dikodi nen makákkao ten kaubasan? ");
INSERT INTO prfNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","“Angay siya haud tánni bunuwán na en katiwala hidi ten kaubasan na, sakay iyatád na ten agum en kaubasan.” Pákkasanig nen tolay hidi ten kinagi ni Jesus ay kinagi di, “Dyan nakuwan iyud ipagkaluub nen Diyos!” ");
INSERT INTO prfNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Inileng hidi ni Jesus sakay tulos na hidi a tinanung, “Ni konahud ay ánya kahuluganid nen nakasulat ten kasulatan a kona háddi: ‘En batu a inadiyan nen mágbilay hidi ay siya bali en pinakamahalaga a pamireng?’ ");
INSERT INTO prfNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Ni deyaman en matáknig ti batuwid a iyud ay maritu-ritu sakay ni deyaman en matáppugan na ay mapapárset.” ");
INSERT INTO prfNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Naintendiyan nen tagapagtoldu hidi nen Kautusan sakay nen pinunu hidi nen padi hidi a hidi en patamakan ni Jesus ten talinhaga na. Kaya pinurbaan di siya a dikáppán ti odasid a iyud, peru nanteng hidi ten tolay hidi. ");
INSERT INTO prfNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Kaya sinapulan di siya a manmanan. Nangsuhul hidi ti sangan a tolay tánni magkukunwari a magaryok ti katutuhanan. Ginamet di iyud tánni madikáp di siya ten pággupos na tánni tehud hidi a meatubeng a kasu ten gubernador. ");
INSERT INTO prfNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Nadid, kinagi nen espiyya hidi kánni Jesus, “Maistu, tukoy mi a tama i kákkagiyán muwen, sakay itáttoldu muwen. Tukoy mi bi a awan ka manuyu ten mataas hidi a tolay, nan itoldu mu en tatarudan a kagustuwan nen Diyos a gamitán nen tolay hidi. ");
INSERT INTO prfNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Ánya ti palagay muwid, tama beman a magbayad kitam ti buwes ten Emperador ti Roma, oni awan?” ");
INSERT INTO prfNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Tukoy ni Jesus en madukás a ked ten isip di, kaya kinagi na dikodi, ");
INSERT INTO prfNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Kotam benid ti pilak a dinaryo. Kándeya a rupa sakay ngaran i kedid ti pilakidi?” “Ten Emperador ti Roma,” kagi di. ");
INSERT INTO prfNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Kaya kinagi ni Jesus dikodi, “Ni konahud ay iyatád moy ten Emperador en para ten Emperador. Sakay en para ten Diyos ay iyatád moy bi ten Diyos.” ");
INSERT INTO prfNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Awan ti nangyari ten planu di a madikáp ti Jesus ten pággupos na ten atubengán nen tolay hidi. Sakay awan hidi ti nakagi gapu nabigla hidi ten intábbig na. ");
INSERT INTO prfNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Nadid, tehud a sangan a Saduseo a ummangay kánni Jesus. Hidi iyád en grupu nen Judio hidi a awan maniwala a mabiyag a ruway en nágkatay dán a tolay. ");
INSERT INTO prfNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Kinagi di, “Maistu, insulat ni Moises ten kautusan en kona háddi, ‘Ni matay en essa a lállaki a awan hidi ti anak ay ten kabinga na ay kailangan a pakasalan nen wadi nen lállaki en bilu tánni magkahud hidi ti anak para ten natay.’ ");
INSERT INTO prfNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Nadid, tehud a pittu a matátkaka a lállaki. Nákkabinga en kaka peru natay siya a awan ti anak. ");
INSERT INTO prfNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Káttapos ay pinakasalan nen wadi na en bilu, peru natay bi a awan bi ti anak. ");
INSERT INTO prfNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Kona bi hud en nangyari ten katállu hanggan ten kapittu. Naessa-essa a nakabinga nen bábbi en pittu a matátkaka. Peru nágkatay hidi a atanan a awan ti anak. ");
INSERT INTO prfNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Ten katapusan ay natay bi en bábbi. ");
INSERT INTO prfNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Nadid, ten kákkabiyag a ruway, ay deya ten pittu i tenggiyánnid nen bábbi a kabinga na ta hidi a atanan ay nakabinga na?” ");
INSERT INTO prfNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Tinábbig hidi ni Jesus, “Ti biyagid a iddi ay mákkabinga en tolay hidi. ");
INSERT INTO prfNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Peru en tolay hidi a karapatdapat a mabiyag a ruway ay awan dán mákkabinga. ");
INSERT INTO prfNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Kumán dán hidi a en anghel hidi a awan matay, sakay anak hidi nen Diyos gapu kabilang hidi ten nabiyag hidi a ruway. ");
INSERT INTO prfNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Maski ti Moises ay pinatunayan na bi a mabiyag a ruway en nágkatay dán hidi. Gapu ten nangyari a tungkul ten maggerab a marenggád a kayu, ay nginaranan na en Panginoon a Diyos ni Abraham, Diyos ni Isaac sakay Diyos ni Jacob.” ");
INSERT INTO prfNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Kaya en Diyos ay bakán a Diyos nen patay hidi, nan Diyos nen biyag hidi, gapu ten Diyos en atanan a tolay ay biyag.” ");
INSERT INTO prfNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Kinagi nen sangan a tagapagtoldu nen Kautusan, “Maistu, mahusay en intábbig mu!” ");
INSERT INTO prfNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Kaya awan dán ti nangahas a magtanung a ruway. ");
INSERT INTO prfNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Káttapos ay nagtanung ti Jesus dikodi, “Konya a makagi nen tolay a en Cristo ay anak ni David? ");
INSERT INTO prfNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Ti David dán a mismu nagkagiyid ten Libru nen Kansiyon hidi a, ‘Kinagi nen Panginoon ten Panginoon ku, “Mággetnud ka ti kawanan kuwiday, ");
INSERT INTO prfNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","mentras awan ku mapasuku dikomu en atanan nen kalaban mu hidi.” ’ ");
INSERT INTO prfNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Nadid, ti David dán en nangdulaw ten Cristo a Panginoon, konya a makagi nen tolay a siya ay anak ni David?” ");
INSERT INTO prfNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Mentras a mágsanig en tolay hidi kánni Jesus ay kinagi na ten disepulus na hidi, ");
INSERT INTO prfNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Mangilag kam ten tagapagtoldu hidi nen Kautusan gapu gugustu di a magsulot ti mágkaganda a badu a malayon tánni mapansin hidi nen katolayan. Sakay gugustu di bi a igalang hidi. Kona labi hud gugustu di bi a mággetnud ten pang-marangal a pággetnudan ten sinagoga hidi sakay ten handaan hidi. ");
INSERT INTO prfNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Sássamantalaán di en ari-ariyan nen bilu hidi, mágdadasalán hidi ti atakdug peru wari-wari la. Kaya lalu pa a dumággi en magin parusa di. ");
INSERT INTO prfNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Ummileng ti Jesus ten disalad nen Templo sakay netan na en mágkayaman hidi a magtábbung ten kaluub di. ");
INSERT INTO prfNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Netan na bi en essa a bábbi a bilu a pubri, nángtábbung siya ti duwwa a sentabos. ");
INSERT INTO prfNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Kaya kinagi ni Jesus, “Kagiyán ku dikomoy, a i pubriyen a bábbi a bilu ay nángtábbung ti mas makpal nan ten agum hidi. ");
INSERT INTO prfNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Gapu en intábbung di ay susubra di la, peru i biluwen a tunay ti kapubriyan ay inyatád na pa en kasiya-siya a kabiyagan na.” ");
INSERT INTO prfNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Nadid, págguronan nen sangan a tolay en tungkul ten Templo, gapu nadikurásyonan ti batu hidi a mágkaganda sakay ten agum a dikurásyon a inyalay nen tolay hidi ten Diyos. Kaya kinagi ni Jesus, ");
INSERT INTO prfNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Dumemát en panahun a atanan ni ketan moyen ay maduray, sakay awan ti maburay a batu a magkatupu.” ");
INSERT INTO prfNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Tinanung di ti Jesus, Maistu, nikan iyád a mangyari? Sakay ánya i senyalid ni dumemát dán iyád?” ");
INSERT INTO prfNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Tummábbig ti Jesus, “Mangilag kam tánni awan kam metawtaw nen deyaman. Makpal a dumemát a magkagi a hidi en Cristo. Sakay kagiyán di bi a, ‘Dummemát dán en katapusan ni munduwiday.’ Dyan kam maniwala dikodi. ");
INSERT INTO prfNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Mara ni makasanig kam ti gera sakay kaguluwan ay dyan kam mabalisa. Talaga a mangyari i atananid a iyád, peru bakán palla iyád en katapusan ni munduwiday.” ");
INSERT INTO prfNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Kinagi na pa, “Mamaggera en bansa ti bansa, sakay en kahariyan laban ti kahariyan. ");
INSERT INTO prfNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Magkahud ti mágkabegsák a linug, sák-aláp, sakay ti makeares a saket ti iba-iba a lugar ti munduwiday. Tehud bi a lumitaw a makaánteng a bagay, sakay makataka hidi a senyal a gubwat dilanget. ");
INSERT INTO prfNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Peru bagu a mangyari i atananid a iyád ay padikáp di kam sakay pahirapan. Imbistigaan di kam ten sinagoga hidi sakay pepiresu. Iyatubeng di kam a ikasu ten hari hidi sakay ten gubernador hidi gapu maniwala kam dikoku. ");
INSERT INTO prfNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Iyád dán i pagkakataun moyid a mángbahagi ten Maganda a Bareta tungkul dikoku. ");
INSERT INTO prfNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Begsákkan moy la i isip moyen. Dyan kam mabalisa ni konya moy a dipensaan i sadili moyen. ");
INSERT INTO prfNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Gapu átdenan takam ti karunungan ten káttábbig moy, tánni awan dán ti mekagi en kalaban moy hidi. ");
INSERT INTO prfNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Itokyon kam nen dáddikál moy hidi, kákkapatkaka, kapartidu, sakay nen amigu moy hidi, sakay pabunu di en sangan dikomoy. ");
INSERT INTO prfNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Kaiyamutan kam nen atanan gapu ten págsunud moy dikoku. ");
INSERT INTO prfNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Peru awan ti mawan maski essa a waget ti buuk moyen. ");
INSERT INTO prfNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Ni magpakatatag kam ay meligtas moy en biyag moy.” ");
INSERT INTO prfNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Nadid, ni ketan moy a napalebutan dán ni makpal a sundalu i Jerusalemiday ay tukoy moy a adeni dán a marábba i siyudadid a iyád. ");
INSERT INTO prfNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Kaya dapatid ay guminan dán ten bukid en ked hidi ti Judea, sakay en ked hidi ten banuwan ay dapat a lumakad dán hidi haud, sakay dyan dán umangay ten banuwan en ked hidi ten uma. ");
INSERT INTO prfNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Gapu iyád dán en aldew hidi a págparusa, tánni matupad en nakasulat ten Kasulatan. ");
INSERT INTO prfNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Kakakagbi en mabuktet hidi sakay en magpasusu hidi ti panahunid a iyud! Gapu dumemát en mahigpit a parusa ti bansaid a iyád. ");
INSERT INTO prfNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","En agum hidi ay matay ti ispada, sakay en agum ay dikáppán di hidi a bilang piresu ten atanan a bansa. Sakupán nen Hentil hidi en Jerusalem hanggan matapos en panahun a netakda.” ");
INSERT INTO prfNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Tehud kam a ketan a tanda ten aldew, bulan, sakay ten biton hidi. Maligalig en bansa hidi ti lutaiday, sakay keántingan hidi gapu ten tánnug nen diget sakay ten tunay ti káddekál a tagmák. ");
INSERT INTO prfNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Kaya makpal a pumatay a tolay gapu ten ánteng di a mággaisipán ten mangyari ti munduwiday; gapu mayanág en kapangyariyan hidi dilanget. ");
INSERT INTO prfNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Ti panahunid a iyud ay ketan di en Anak nen Tolay a magdibábbi ten panganurin a gubwat dilanget, tehud siya a kapangyariyan sakay kaluwalhatian. ");
INSERT INTO prfNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Nadid, ni magsapul dán a mangyari i bagayid a hidi iyád ay dyan kam manteng, magsaya kam gapu adeni dán a dumemát en kaligtasan moy.” ");
INSERT INTO prfNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Nadid, kinagi ni Jesus en essa a talinhaga, “Ilingán moy en kayu a igos sakay en agum hidi a kayu. ");
INSERT INTO prfNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Ni magduun dán hidi iyád ay tukoy moy a adeni dán a kássinag. ");
INSERT INTO prfNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Kona labi hud, ni ketan moy a mangyari dán a atanan i bagayid a hidi iyád ay matukuyan moy a adeni dán en panahun a maghari en Diyos. ");
INSERT INTO prfNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Tandaan moy, mangyari i atananid a iyád bagu a matay en atanan nen tolay a biyag nadid. ");
INSERT INTO prfNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Mawan en langet sakay lutaiday, peru en upos ku ay manatili a awan ti katapusan.” ");
INSERT INTO prfNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Mangilag kam a dyan masiyaan a mágkakanán, máglalasingán, sakay mágsasayaán sakay dyan kam mabalisa ten pággaryok moy ten kabiyagan moy. Bakay bigla a dumemát en Anak nen Tolay a awan moy maandaman. ");
INSERT INTO prfNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Gapu dumemát siya ti lutaiday ten odas a awan asaan nen atanan a tolay. ");
INSERT INTO prfNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Kaya pirmi kam a nakahanda ten atanan a odas. Pirmi moy a idasal a magkahud kam ti begsák tánni matággád moy en atanan a hirap a dumemát, sakay nakahanda kam la a umatubeng ten Anak nen Tolay.” ");
INSERT INTO prfNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Aldew-aldew ay nagtoldu ti Jesus ten Templo, peru ti gibi ay angay siya mátdug ten Bukid nen Olibo hidi. ");
INSERT INTO prfNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Dimadimang palla ay angay dán en tolay hidi ten Templo a mágsanig dikona. ");
INSERT INTO prfNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Nadid adeni dán a dumemát en Piyesta nen Tinapay a awan ti Págpaalsa, a kákkagiyán di bi a Piyesta nen Aldew nen Págtalib. ");
INSERT INTO prfNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","En pinunu hidi nen padi hidi sakay en tagapagtoldu hidi nen Kautusan ay manteng ten tolay hidi, kaya namágguron hidi ni konya di a pabunu ti Jesus ti sekretu. ");
INSERT INTO prfNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Káttapos ay sinomdáp ti Satanas kánni Judas a Iscariote, essa ten sapulu ay ti duwwa a Apostol. ");
INSERT INTO prfNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Kaya angay nákpágguron ti Judas ten pinunu hidi nen padi hidi sakay ten pinunu hidi nen mágbantay hidi ten Templo ni konya na a metokyon ti Jesus. ");
INSERT INTO prfNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Nasaya en pinunu hidi sakay nagpangaku hidi kánni Judas a átdenan di siya ti pilak. ");
INSERT INTO prfNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Nasor siya, kaya sapul haud ay nagaryok dán siya ti pagkakataun a metokyon na ti Jesus ten paraan a awan matukuyan nen katolayan. ");
INSERT INTO prfNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Nadid, dummemát dán en aldew nen Piyesta nen Tinapay a awan ti Págpaalsa, sakay aldew nen págbunu ti tupa para ten Piyesta nen Aldew nen Págtalib. ");
INSERT INTO prfNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Inutusan ni Jesus de Pedro ay ti Juan. Kinagi na, “Kammoy dán, maghanda kam ti pangapon tam a para ten Piyesta nen Aldew nen Págtalib.” ");
INSERT INTO prfNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Tinanung di siya, “Hádya i gustu muwid a paghandaan mi?” ");
INSERT INTO prfNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Kinagi ni Jesus, “Angay kam ti Jerusalem. Tehud kam a matagbu haud a essa a lállaki, tehud a tawid a binga a tehud a lasán a dinom. Unonudán moy siya ten bilay a sáddáppan na. ");
INSERT INTO prfNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Sakay kagiyán moy ten makákkao ten bilay, ‘Petanung ben nen Maistu mi ni hádya kan i kuwartuwid a pangapunan mi káddemát nen Piyesta nen Aldew nen Págtalib.’ ");
INSERT INTO prfNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Káttapos ay itoldu na dikomoy en essa a dikál a kuwartu ten disunu a tehud dán a nakahanda a gamit. Haud kam a maghanda ti pangapon tam.” ");
INSERT INTO prfNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Lummakad en apostol hidi sakay netan di en atanan a kinagi ni Jesus. Kaya inhanda di dán en pangapon di a para ten Piyesta nen Aldew nen Págtalib. ");
INSERT INTO prfNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Dikona dumemát dán en odas a mangapon dán hidi ay nákpággatubeng ti Jesus ten apostol na hidi. ");
INSERT INTO prfNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Káttapos ay kinagi na dikodi, “Gugustu ku a makatubeng takam a mangapon ti kona hádday a Piyesta nen Aldew nen Págtalib baguwák a maghirap. ");
INSERT INTO prfNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Kagiyán ku dikomoy, awanák dán kuman a ruway ti kona háddi hanggan awan mangyari en kahulugan ni iyád ten kahariyan nen Diyos.” ");
INSERT INTO prfNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Inalap ni Jesus en tasa a tehud a lasán a alak sakay nagpasalamat siya ten Diyos. Káttapos ay kinagi na dikodi, “Paghati-hatiyan moy iddi a inumán. ");
INSERT INTO prfNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Tandaan moy, sapul nadid ay awanák dán uminom a ruway ti tábbug ni ubas mentras a awan palla dumemát en pághari nen Diyos.” ");
INSERT INTO prfNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Inalap na en tinapay, sakay nagpasalamat ten Diyos, káttapos ay tináppeng-táppeng na sakay intagtag na dikodi. Kinagi na, “Iddi en bággi ku a neatád para dikomoy. Gamitán moy iyád bilang pággala-ala moy dikoku.” ");
INSERT INTO prfNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Káttapos di a kumman ay kona labi hud en ginamet na, inalap na en tasa sakay kinagi na, “Saiyád en tanda nen bigu a pákpagkasundu nen Diyos ten tolay a pinatunayan nen digi ku. Mebuhus en digi ku para dikomoy. ");
INSERT INTO prfNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Kinagi ni Jesus, “Peru ilingán moy, katubeng tam háddi nadid en mángtokyon dikoku. ");
INSERT INTO prfNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Matay en Anak nen Tolay ayun ten intakda nen Diyos, peru makaánteng en sapitán nen mángtokyon dikoku.” ");
INSERT INTO prfNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Káttapos iyud a masanig nen apostol hidi ay namagtanungan hidi ni deya dikodi en mángtokyon kánni Jesus. ");
INSERT INTO prfNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Namagtalu-talu en disepulus hidi ni deya dikodi tenggiyánnid nen tolay hidi a kataasan. ");
INSERT INTO prfNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Kaya kinagi ni Jesus ten disepulus na hidi, “En hari hidi nen Hentil hidi ay tehud a kapangyariyan ten katolayan a sakup di, sakay en tehud hidi a kapangyariyan ay gustu di a mangaranan a, ‘Amigu nen katolayan.’ ");
INSERT INTO prfNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Peru, bakán a kona haán i dapat moyid a gamitán. Nan dapatid ay en kataasan i kababaanid, sakay en pinunu hidi i dapatid a tagapagserbi. ");
INSERT INTO prfNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Deya beman kataasanid, en mággetnud beman a kuman oni en utusan a maghayin? Awan beman mas mataasid ay en mággetnud a hayinan? Sikán ay Panginoon moy peru magserbiyák dikomoy a kona ten essa a utusan. ");
INSERT INTO prfNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Nanatili kam a kakaguman ku maski ten pagsubuk hidi a dinanas ku. ");
INSERT INTO prfNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Ni konyaák a inátdenan nen Ama ku ti karapatan a maghari ay kona labi hud iyatád ku dikomoy i karapatanid a iyád. ");
INSERT INTO prfNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Kapisan takam a kuman sakay uminom ten kahariyan ku. Sakay mággetnud kam ten trono a mamunu ten sapulu ay ti duwwa a lahi ni Israel.” ");
INSERT INTO prfNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Káttapos ay kinagi ni Jesus, “Simon! Simon! Mágsanig ka! Napakultadan ti Satanas a purbaan kam a kona ten pánghiwalay ten lupás ten paray. ");
INSERT INTO prfNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Peru indasal taka dán tánni awan humina en pánnampalataya mu. Sakay ni sumoli ka dán ten pánnampalataya mu ay pabegsákkán mu en kákkapatkaka mu.” ");
INSERT INTO prfNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Kinagi ni Pedro, “Panginoon, nakahandaák a mepiresu sakay matay a kaguman mu.” ");
INSERT INTO prfNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Peru kinagi ni Jesus, “Sanigán mu kagiyán kuwiday Pedro, bagu a magtarakket en manok nadid a aldew ay pentalluwák mu a ipamen.” ");
INSERT INTO prfNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Káttapos ay tinanung hidi ni Jesus, “Dikona inutusan takam a awan ti tawid a pitaka, hembeg oni sandalyas ay kinulang kam beman ti ányapaman haán?” Kinagi di a, “Awan.” ");
INSERT INTO prfNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Kinagi ni Jesus, “Peru nadid ni tehud kam a pitaka oni hembeg ay tawidán moy. Sakay ni deyaman en awan ti ispada ay dapat a ilaku na en alikábkáb na tánni tehud siya a pamali ti ispada. ");
INSERT INTO prfNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Kagiyán ku dikomoy, a kailangan a matupad dán nadid en nakasulat ten Kasulatan tungkul dikoku a, ‘Imbilang di siya a essa ten makasalanan hidi.’ ” ");
INSERT INTO prfNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Káttapos ay kinagi nen disepulus hidi, “Panginoon, tehud dán a duwwa a ispada.” “Tama dán iyán!” kagi ni Jesus. ");
INSERT INTO prfNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Lummakad dán ti Jesus ti Jerusalem sakay ummangay ten bukid nen Olibo hidi, kona ten dati na a gággamitán. Nákkuyug dikona en disepulus na hidi. ");
INSERT INTO prfNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Dikona a dumemát dán hidi haud ay kinagi ni Jesus dikodi, “Magdasal kam tánni awan kam madaig nen toksu.” ");
INSERT INTO prfNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Káttapos ay ummadeyu ti Jesus dikodi ti saobasan ti batu sakay lummuhud siya a nagdasal. ");
INSERT INTO prfNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Kinagi na, “Ama, ni maari ay iyadeyu pay dikoku en tasa nen pághirap. Peru bakán a en kaluuban ku en masunud nan en kaluuban mu.” ");
INSERT INTO prfNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Káttapos ay tehud a essa a anghel a pummeta dikona a gubwat dilanget sakay pinabegsák na en isip na. ");
INSERT INTO prfNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Nadid, gapu ten subra a hirap a nabati na ten isip na ay nagdasal siya ti taimtim. Tummákták ten luta en inet na a kumán a dáddekál a turug ni digi. ");
INSERT INTO prfNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Dikona a natapos dán siya a magdasal ay nagsoli siya ten disepulus na hidi, sakay nedemáttan na hidi a pasiyaan a tidug gapu ten lungkut di. ");
INSERT INTO prfNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Kinagi ni Jesus, “Bakin mágtatidugán kam? Umikat kamon sakay magdasal kam, tánni awan kam madaig nen toksu.” ");
INSERT INTO prfNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Nadid, dikona pasiyaan palla a magupos ti Jesus ay tehud a dummemát a makpal a tolay. Ti Judas en nánggiya dikodi, essa siya ten sapulu ay ti duwwa. Ummadeni siya kánni Jesus tánni ámmuwan na siya. ");
INSERT INTO prfNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Peru kinagi ni Jesus dikona, “Judas, ámmu beman iyád nen pángtokyon mu dikoku?” ");
INSERT INTO prfNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Nadid, dikona netan iyád nen disepulus hidi ay kinagi di, “Panginoon, tigpasán mi dán beman hidi!” ");
INSERT INTO prfNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Pagdaka a tinigpas nen essa a disepulus en kawanan a bángbáng nen utusan nen kapunuwan nen padi hidi. ");
INSERT INTO prfNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Peru kinagi ni Jesus, “Tama dán iyán!” Tinawidan na en bángbáng nen utusan kaya nagpiyya. ");
INSERT INTO prfNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Káttapos ay kinagi ni Jesus ten pinunu hidi nen padi hidi, ten pinunu hidi nen mágbantay hidi ten Templo, sakay ten pinunu hidi nen banuwan a dummemát a mangdikáp dikona, “Bakin? Madukassák beman a tolay kaya kailangan pa a angay kam háddi a te manga armas a ispada sakay garoti? ");
INSERT INTO prfNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Aldew-aldew ay magtolduwák ten Templo sakay ked kam bi haud, peru awanák moy dinikáp. Peru nadid ay odas moy dán sakay nen kapangyariyan nen kadiklámman a maghari.” ");
INSERT INTO prfNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Káttapos ay dinikáp di ngani ti Jesus sakay inyangay di ten bilay nen kapunuwan nen padi hidi. Ummunonud ti Pedro dikodi peru adeyu la siya. ");
INSERT INTO prfNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Nadid, nagnamu hidi ten ditángnga nen laguwerta sakay nággetnud hidi ten palebut nen apoy, sakay angay nákpággetnud ti Pedro dikodi. ");
INSERT INTO prfNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Dikona netan siya nen essa a bábbi a utusan ay minámmalas na siya ti hustu. Sakay kinagi na, “Kaguman bi ni Jesus i tolayid a iddi!” ");
INSERT INTO prfNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Peru impamen ni Pedro, kinagi na ten bábbi, “Awan! Awan ku siya matenggi.” ");
INSERT INTO prfNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Mamaya-maya ay tehud a essa a lállaki a nakatenggi kánni Pedro, kaya kinagi na, “Awan beman essa ka bi ten kakagumanan na hidi?” Peru tummábbig ti Pedro, ‘Awan, nagkamali kam.’ ” ");
INSERT INTO prfNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Nadid, kállipas nen manga essa a odas ay impilit a kinagi nen essa a tolay, “Talaga a kaguman ni Jesus i tolayid a iyán gapu essa bi siya a taga-Galilea.” ");
INSERT INTO prfNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Peru tummábbig ti Pedro, “Awan ku tukoy i kákkagi-kagiyán muwen!” Pasiyaan palla siya a magupos ay bigla a nagtarakket en manok. ");
INSERT INTO prfNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Sinulig nen Panginoon ti Pedro sakay ináeleng na siya. Naisip nadid ni Pedro en kinagi ni Jesus a, ‘Bagu a magtarakket en manok nadid a aldew ay pentálluwák mu a ipamen.’ ");
INSERT INTO prfNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Lummuwas ti Pedro sakay nágsasangitán ti hustu. ");
INSERT INTO prfNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Nadid, sinesti sakay binálbág nen magbantay hidi ti Jesus. ");
INSERT INTO prfNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Pinángngássan di siya sakay tinanung di, “Nay! Tukuyan benid ni deya i nangsuntukid dikomu.” ");
INSERT INTO prfNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Makpal pa hidi a kinákkagi a págsesti dikona. ");
INSERT INTO prfNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Nadid, ten dimadimang ay nagipun-ipun en Sanedrin kabilang háddi en pinunu hidi nen banuwan, en pinunu hidi nen padi hidi, sakay en tagapagtoldu hidi nen Kautusan. Inyatubeng di ti Jesus dikodi sakay tinanung di. ");
INSERT INTO prfNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Kinagi di, “Kagiyán mu dikomi, siko beman en Cristo?” Tummábbig ti Jesus, “Maski ni kagiyán ku dikomoy ay awan kam labi maniwala. ");
INSERT INTO prfNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Ni tanungán takam bi ay awan kam bi tumábbig. ");
INSERT INTO prfNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Peru kagiyán ku dikomoy, a sapul nadid ay mággetnud en Anak nen Tolay ten kawanan a trono nen Makapangyariyan a Diyos.” ");
INSERT INTO prfNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Nagtanung hidi a atanan, “Gustu muwid a kagiyán ay siko en Anak nen Diyos?” Tummábbig siya, “Sikamon i nangkagiyid.” ");
INSERT INTO prfNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Káttapos ay kinagi di, “Ánya pa beman i kailangan tamid a pangpatunay? Nasanig tamon a mismu en atanan a kinákkagi na.” ");
INSERT INTO prfNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Tummaknág en buu a Sanedrin sakay inyangay di ti Jesus kánni Pilato. ");
INSERT INTO prfNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Káddemát di kánni Pilato ay sinapulan di siya a bintangán. Kinagi di, “Nadikáp mi i tolayidi a magsulsul ten kabanuwan mi hidi a magribeldi. Kinagiyan na hidi a dyan hidi magbayad ti buwes ten Emperador, sakay kinagi na bi a siya en Cristo, a siya ay hari.” ");
INSERT INTO prfNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Káttapos ay tinanung ni Pilato ti Jesus, “Siko beman en hari nen Judio hidi?” “Siko dán nangkagiyen,” kagi ni Jesus. ");
INSERT INTO prfNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Kaya kinagi ni Pilato ten pinunu hidi nen padi hidi sakay ten katolayan, “Awanák ti ketan a kasalanan ni tolayid a iddi.” ");
INSERT INTO prfNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Peru impilit di a kinagi a, “Gapu ten págtoldu na ay inggiyya na a manggulu en tolay hidi ti buu a Judea. Nagsapul siya ti Galilea sakay hanggan dán háddi.” ");
INSERT INTO prfNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Dikona nasanig iyud ni Pilato ay intanung na ni taga-Galilea ti Jesus. ");
INSERT INTO prfNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Sakay dikona natukuyan na a gubwat ti Jesus ten lugar a sakup ni Herodes ay impeangay siya ni Pilato kánni Herodes. Tama bi a ti panahunid a iyud ay ked ti Herodes ti Jerusalem. ");
INSERT INTO prfNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Tunay en saya ni Herodes dikona a netan na ti Jesus, gapu makpal dán siya a nabareta tungkul dikona sakay nanalay na dán siya a gustu a ketan. Inasaan ni Herodes a ketan na ti Jesus a maggamet ti himala. ");
INSERT INTO prfNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Kaya nágtatanungán siya kánni Jesus, peru awan na siya tinatábbig. ");
INSERT INTO prfNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Ked haud en pinunu hidi nen padi hidi sakay en tagapagtoldu hidi nen Kautusan, awan di imangan a bábbintangán ti Jesus. ");
INSERT INTO prfNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Káttapos ay sinesti siya ni Herodes pati nen sundalu na hidi sakay ininsultu di siya. Binaduwan di siya ti mamahalin a damit, káttapos ay pinasoli di siya kánni Pilato. ");
INSERT INTO prfNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Sapul ti aldiwid a iyud ay nagin magamigu dán de Herodes ay ti Pilato a dati a magkadima. ");
INSERT INTO prfNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Nadid, pinadulaw ni Pilato en pinunu hidi nen padi hidi, en pinunu hidi nen banuwan sakay en katolayan. ");
INSERT INTO prfNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Káttapos ay kinagi na dikodi, “Ingkasu moy dikoku i tolayid a iddi ten kasalanan a pággiyya ten tolay hidi a manggulu. Peru nasanig moy dikona a imbistigaan ku siya sakay natukuyan ku a awan tatarudan en bintang moy hidi dikona. ");
INSERT INTO prfNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Kona bi hud ti Herodes, awan siya ti netan a kasalanan ni Jesus kaya impesoli na siya háddi. Awan siya dapat a bunuwán gapu awan siya ti kasalanan. ");
INSERT INTO prfNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Kaya pabálbág ku siya sakay paluwasán.” ");
INSERT INTO prfNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Kinagi na iyád gapu ugali di dán a kada aldew nen Piyesta nen Aldew nen Págtalib ay kailangan a mángpaluwas en gubernador ti essa a piresu para dikodi. ");
INSERT INTO prfNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Peru sabay-sabay a impákraw nen atanan a tolay a, “Bunuwán i tolayid a iyán! Sakay palayaán mu ti Barrabas!” ");
INSERT INTO prfNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Nepiresu ti Barrabas gapu ten pággiyya na ten págribeldi ten banuwan sakay pámmunu. ");
INSERT INTO prfNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Nadid, nagupos a ruway ti Pilato dikodi gapu gustu na a palayaán ti Jesus. ");
INSERT INTO prfNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Peru impákraw nen katolayan a, “Ipaku siya ten kudus! Ipaku siya ten kudus!” ");
INSERT INTO prfNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Káttapos ay pentállu a kinagi ni Pilato dikodi a, “Bakin? Ánya beman i ginamet naid a madukás? Awan ti dahilan para pabunu ku siya. Kaya pabálbág ku dálla siya sakay paluwasán.” ");
INSERT INTO prfNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Peru lalu di a impáppákraw a kailangan a ipaku ti Jesus ten kudus. Sakay nagtagumpay en ipáppákraw di. ");
INSERT INTO prfNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Kaya nagdisisyon ti Pilato a pagustuwan na en kagustuwan nen tolay hidi. ");
INSERT INTO prfNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Pinaluwas ni Pilato en tolay a nepiresu a namunu sakay nagsapulan ni kaguluwan. Káttapos ay inyatád ni Pilato ti Jesus dikodi tánni magamet di dikona en gustu di. ");
INSERT INTO prfNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Nadid, ti Jesus ay tinawid nen sundalu hidi. Mentras a maglakad hidi ay natagbu di ti Simon a taga-Cirene a gubwat ti baryu, pinilit di a pinabáklay dikona en kudus sakay pinaunonud di kánni Jesus. ");
INSERT INTO prfNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Makpal a tolay en umunonud kánni Jesus, kaguman bi en sangan a bábbi a mamagsangetan sakay malungkut gapu ten habag di dikona. ");
INSERT INTO prfNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Peru sinulig hidi ni Jesus sakay kinagi na, “Sikam a bábbi hidi ti Jerusalem, dyanák moy sangitan, dapat moyid a sangitan ay i sadili moyen sakay en anak moy hidi. ");
INSERT INTO prfNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Gapu dumemát en aldew a kagiyán nen tolay hidi a, ‘Pinagpala en baug hidi, en awan hidi nagbuktet sakay en awan hidi nagpasusu!’ ");
INSERT INTO prfNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Iyud bi en panahun a kagiyán nen tolay hidi ten bukid hidi a, ‘Taporan moy kami!’ sakay ten marenggád hidi a bukid, ‘Itagu moy kami!’ ");
INSERT INTO prfNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Gapu ni kona haád en gamitán ten sariwa a kayu, ay ánya wád i mangyariyid ni mamadi dán? ");
INSERT INTO prfNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Nadid, tehud bi a tinawid en sundalu hidi a duwwa a tolay a mágbabonu, para bunuwán di bi a kasabay ni Jesus. ");
INSERT INTO prfNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Káddemát di ten lugar a nginaranan di a Bungu ay impaku di dán ti Jesus ten kudus. Sakay impaku di bi en duwwa a tolay a mágbabonu, essa ten danág ten kawanan, sakay essa bi ten danág ten kawiri. ");
INSERT INTO prfNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Kinagi ni Jesus, “Ama, patawadán mu hidi gapu awan di tukoy i gagamitán diyen.’ Nagbunutan en sundalu hidi tánni matukuyan di ni hádya ten badu hidi ni Jesus en meangay ten balang essa dikodi. ");
INSERT INTO prfNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Nágtaknág en tolay hidi haud a mággeleng; mentras a en pinunu hidi nen banuwan ay mágsasestiyán dikona. Kinagi di, “Inligtas na en agum, nadid, ni talaga a siya en Cristo a pinili nen Diyos ay bakin awan na iligtas i sadili naen?” ");
INSERT INTO prfNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Sinesti bi siya nen sundalu hidi. Ummadeni dikona en essa a sundalu sakay painomán na siya ti maapsot a alak. ");
INSERT INTO prfNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Sakay kinagi di, “Ni siko en hari nen Judio hidi ay iligtas mu i sadili muwen!” ");
INSERT INTO prfNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Insulat di ten áoluwan na en, “Iddi en hari nen Judio hidi.” ");
INSERT INTO prfNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Ininsultu siya nen essa a mágbabonu a impaku di bi ten kudus. Kinagi na, “Awan beman siko en Cristo? Iligtas mu i sadili muwen, pati sikami!” ");
INSERT INTO prfNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Peru nagkagiyan siya nen kaguman na, “Awan ka la manteng ten Diyos? Parehu kitam la a tállu a pinarusaan! ");
INSERT INTO prfNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Dapat la a parusaan di kita a duwwa gapu ten mágkadukás a ginággamet ta, peru i tolayid a iyán ay awan ti ginamet a ányaman a madukás.” ");
INSERT INTO prfNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Sakay kinagi na kánni Jesus, “Alalahanánnák mu pay, Jesus, ni maghari ka dán.” ");
INSERT INTO prfNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Tummábbig ti Jesus, “Kagiyán ku dikomu, ti aldew biyid a iyád ay kuyugán taka ti Paraiso.” ");
INSERT INTO prfNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","45","Dikona a tanghali dán ay nagdiklám i buuwid a luta hanggan ten alas tres ten apon. Sakay napisad en ditángnga nen kortina ten kadisaladan nen Templo. ");
INSERT INTO prfNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Káttapos ay pummákraw ti Jesus, “Ama, iyentrega ku dán dikomu ispiritu kuwidi.” Káttapos na a kinagi iyud ay nabágsutan dán siya ti angás. ");
INSERT INTO prfNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Dikona a netan nen kapitan nen sundalu hidi en nangyari ay nagpuri siya ten Diyos. Kinagi na, “Tatarudan ngani a matuwid i tolayid a iddi!” ");
INSERT INTO prfNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Makpal en katolayan a naipun a mággeleng haud, ummuli hidi a tunay en lungkut di gapu ten netan di a nangyari. ");
INSERT INTO prfNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","En atanan nen kákkagumanán hidi ni Jesus ay ked hidi haud a mágtaknág ten adeyu, pati en bábbi hidi a ummunonud dikona sapul ti Galilea. Netan di en atanan nen nangyari haud. ");
INSERT INTO prfNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Tehud a essa a lállaki a Jose en ngaran na, taga-Arimatea a essa a banuwan ti Judea. Mabait siya sakay matuwid a tolay, essa siya ten tolay hidi a maguray ten káddemát nen pághari nen Diyos. Sakay maski kaguman siya ten Sanedrin ay awan siya ummayun ten madukás a ginamet di kánni Jesus. ");
INSERT INTO prfNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Ummangay siya kánni Pilato sakay inagid na en bangkay ni Jesus. ");
INSERT INTO prfNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Indibábbi na en bangkay, sakay binalutan na ti tela a lino. Káttapos ay inyangay na ten páglábbángngan a kumán a kuweba a batu, a awan palla nagamit. ");
INSERT INTO prfNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Ti aldiwid a iyud ay Aldew nen Pághanda di gapu magsapul dán en Aldew nen Káimang. ");
INSERT INTO prfNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Nákkuyug kánni Jose en bábbi hidi a nákkuyug kánni Jesus sapul ti Galilea, kaya netan di en páglábbángngan sakay en kákkedátton nen bangkay na haud. ");
INSERT INTO prfNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Káttapos ay ummuli hidi sakay tulos hidi a naghanda ti págpasárrub sakay mira a idátton di ten bangkay ni Jesus. Ten káddemát nen Aldew nen Káimang ay ummimang hidi gapu iyud utus nen Kautusan. ");
INSERT INTO prfNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Nadid, págdemlag palla ten Simba ay ummangay dán en bábbi hidi ten nánglábbángngan di kánni Jesus, tawid di en págpasárrub a inhanda di. ");
INSERT INTO prfNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Káddemát di haud ay netan di a negulung dán en batu a sumássiradu ten páglábbángan. ");
INSERT INTO prfNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Peru dikona a summáddáp hidi haud ay awan dán en bangkay nen Panginoon a Jesus. ");
INSERT INTO prfNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Nadid mentras a isipán di ni bakin konahud en nangyari ay tehud a bigla a pummeta a duwwa a lállaki a makasili en badu di. ");
INSERT INTO prfNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Tunay en ánteng di kaya lummuhud hidi. Kinagi nen lállaki hidi dikodi, “Bakin aryokán moy en biyag ten lugar nen patay hidi? ");
INSERT INTO prfNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Awan háddi ti Jesus, nabiyag dán siya a ruway! Nalimunan moy dán beman en kinagi na dikomoy dikona a ked palla siya ti Galilea? ");
INSERT INTO prfNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Awan beman kinagi na a, ‘En Anak nen Tolay ay kailangan a itokyon ten makasalanan hidi sakay ipaku ten kudus, peru mabiyag siya a ruway ten katállu a aldew?’ ” ");
INSERT INTO prfNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Nadid, naisip nen bábbi hidi en kinagi hidi ni Jesus tenhud. ");
INSERT INTO prfNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Kaya nagsoli hidi gubwat ten páglábbángngan sakay angay di imbareta en atanan nen nangyari ten sapulu ay ti essa a apostol sakay ten agum pa a kakagumanan di. ");
INSERT INTO prfNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","En bábbi hidi ay de Maria Magdalena, ti Juana, sakay ti Maria a ina ni Santiago, sakay en agum pa hidi a kaguman di a bábbi en nagbareta ten apostol hidi. ");
INSERT INTO prfNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Peru awan naniwala en apostol hidi gapu isip diyid ay binubuu la iyud nen bábbi hidi. ");
INSERT INTO prfNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Peru tummaknág ti Pedro sakay nagginan a patamu ten nánglábbángngan di kánni Jesus. Káddemát na ten lábbáng ay dummukug siya a summedip ten disalad. Awan siya ti netan, basta en damit a lino. Kaya ummuli siya a mággaisipán ten nangyari. ");
INSERT INTO prfNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Ti aldewid a iyud ay naglakad en duwwa a disepulus ni Jesus, patamu ten baryu a nginaranan di a Emaus, manga sapulu ay ti essa a kilumetru en kadeyu na ti Jerusalem. ");
INSERT INTO prfNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Mágguron hidi a duwwa tungkul ten atanan a nangyari. ");
INSERT INTO prfNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Nadid, mentras a mágguron hidi ay ummadeni ti Jesus dikodi sakay náksabay. ");
INSERT INTO prfNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Netan di siya peru awan di siya natenggi. ");
INSERT INTO prfNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Tinanung hidi ni Jesus, “Ánya ben i págguronan moyen?” Ummimang hidi ten páglakad di, sakay malungkut a tarud en rupa di. ");
INSERT INTO prfNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Tummábbig en essa dikodi a Cleopas en ngaran na, “Siko wád la i dayuwid ti Jerusalem a awan nakabareta ten nangyari hidi haud ti nakalipasudi a sangan a aldew.” ");
INSERT INTO prfNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Kinagi ni Jesus, “Ánya beman nangyariyid haud?” Tummábbig hidi, “En tungkul ten nangyari hidi kánni Jesus a taga-Nazaret. Essa siya a propeta a makapangyariyan ten upos sakay gamet maski ten atubengán nen Diyos sakay nen tolay hidi. ");
INSERT INTO prfNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Peru dinikáp siya nen pinunu hidi nen padi mi hidi, sakay nen pinunu hidi nen banuwan para mahatulan a matay, sakay impaku di siya ten kudus. ");
INSERT INTO prfNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Siya pa beman i asaan miyid a mángligtas ti Israel. Sakay bakán la a iyán, katállu dán nadid a aldew sapul dikona a nangyari iyud. ");
INSERT INTO prfNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Naráknid kami ten imbareta nen sangan a bábbi a kakagumanan mi. Págdemlag palla ay ummangay hidi bummisita ten lábbáng ni Jesus. ");
INSERT INTO prfNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Peru awan di netan en bangkay na haud. Nagsoli hidi sakay kinagi di a tehud hidi a netan a pangitain a tehud a duwwa a anghel a nagkagi dikodi a biyag ti Jesus. ");
INSERT INTO prfNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Kaya angay inileng nen agum mi hidi a kakagumanan en lábbáng na sakay kinagi di a tatarudan en kinagi nen bábbi hidi, peru awan di netan ti Jesus.” ");
INSERT INTO prfNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Kinagi ni Jesus dikodi, “Ánya kam dán ben ti alay a makaintendi! Bakin awan moy paniwalaan en atanan nen kinagi nen propeta hidi ");
INSERT INTO prfNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","a kailangan a magtággád ti hirap en Cristo, bagu siya umangay ten marangal a páppágyanan na?” ");
INSERT INTO prfNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Káttapos ay impaliwanag ni Jesus dikodi en atanan nen nakasulat ten Kasulatan a tungkul dikona, sinapulan na ten libru hidi ni Moises hanggan ten insulat nen propeta hidi. ");
INSERT INTO prfNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Nadid, dikona a adeni dán hidi ten baryu a tamuwan nen duwwa a disepulus, ti Jesus ay kumán a magtulos ten lakad na a tamu ti mas adeyu a lugar. ");
INSERT INTO prfNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Peru pinugád di siya a kagi di, “Máktulos ka dálla háddi dikomi, gapu sumarám dán i aldiwen sakay mágdadidiklám dán.” Kaya náktulos ti Jesus dikodi. ");
INSERT INTO prfNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Dikona katubeng di dán siya a kuman ay inalap na en tinapay, sakay nagpasalamat ten Diyos. Káttapos ay tináppeng-táppeng na sakay inyatád na dikodi. ");
INSERT INTO prfNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Sakay nabukasan en pangileng di sakay natenggi di ti Jesus, peru bigla dán siya a nawan. ");
INSERT INTO prfNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Kinagi di, “Kaya bali a tunay ti saya en bábbatiyán ta mentras a mákpágguron siya dikota ten dilan sakay impaliwanag na dikota en nakasulat ten Kasulatan.” ");
INSERT INTO prfNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Tummaknág hidi a pagdaka sakay nagsoli hidi ti Jerusalem. Dinemáttan di a naipun en sapulu ay ti essa a apostol sakay en agum pa hidi a kakagumanan di. ");
INSERT INTO prfNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Kinagi di ten duwwa, “Tatarudan a nabiyag en Panginoon, pummeta siya kánni Simon!” ");
INSERT INTO prfNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Káttapos ay inyistorya bi nen duwwa a disepulus en nangyari ten dilan, sakay ni konya di a natenggi en Panginoon dikona a táppeng-táppengán na en tinapay. ");
INSERT INTO prfNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Nadid, mentras a págguronan di en nangyari ay bigla a lummitaw ti Jesus a tummaknág ten ditángnga di, sakay kinagi na dikodi, “Mágkahud kam ti kapayapaan!” ");
INSERT INTO prfNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Naráknid en disepulus hidi sakay neántingan hidi gapu inisip di a anitu en netan di. ");
INSERT INTO prfNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Peru kinagi ni Jesus dikodi, “Bakin manteng kam? Sakay bakin magduda kam? ");
INSERT INTO prfNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Ilingán moy i lima kuwiday sakay i básset kuwiday, sikán dán ngani iddi. Tawidanák moy sakay pakailingánnák moy. Awan ti pilas sakay tulang en anitu, peru sikán ay tehud a kona ti ketan moyidi. ");
INSERT INTO prfNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Káttapos na a kinagi iyád ay impeta na dikodi en lima na sakay en básset na. ");
INSERT INTO prfNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Nagtaka hidi ti hustu sakay tunay hidi ti saya. Peru awan palla hidi makapaniwala, kaya tinanung hidi ni Jesus, “Tehud kam a makan haán?” ");
INSERT INTO prfNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Inátdenan di siya ti kakáttol a neapoy a ikan. ");
INSERT INTO prfNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Inalap na iyud sakay kinan na ten atubengán di. ");
INSERT INTO prfNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Káttapos ay kinagi na dikodi, “Saiyád en kinagi ku dikomoy dikona a kakagumanák moy palla. Dapat a matupad en atanan a nesulat ten Kautusan ni Moises, ten libru nen propeta hidi sakay ten libru nen Kansiyon hidi tungkul dikoku.” ");
INSERT INTO prfNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Káttapos ay binukasan na en isip di tánni maintendiyan di en Kasulatan. ");
INSERT INTO prfNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Kinagi na dikodi, “Kona háddi en nakasulat, ‘Kailangan a maghirap en Cristo sakay matay. Káttapos ay mabiyag siya a ruway ten katállu a aldew.’ ");
INSERT INTO prfNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Kaya ten pamamag-itan nen ngaran na ay dapat a ipangaral en págsisi, sakay págpatawad ten kasalanan sapul ti Jerusalem hanggan ten atanan a bansa. ");
INSERT INTO prfNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Sikam i makapangpatunayid ti bagayid a hidi iyád. ");
INSERT INTO prfNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Tandaan moy, paangayán ku dikomoy en impangaku nen Ama ku. Kaya dyan kam lumakad ti Jerusalem mentras a awan moy matanggap en kapangyariyan a gubwat dilanget.” ");
INSERT INTO prfNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Káttapos ay ingkuyug hidi ni Jesus ten luwas ti Jerusalem, káddemát ti Betania ay indisunu na en lima na sakay pinagpala na hidi. ");
INSERT INTO prfNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Mentras a pagpalaán na hidi ay mággade-adeyu siya a padisunu a patamu dilanget. ");
INSERT INTO prfNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Sinamba di siya sakay káttapos ay nagsoli hidi ti Jerusalem a masaya a tarud. ");
INSERT INTO prfNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Pirmi hidi a mággangay ten Templo a magpuri ten Diyos.");
INSERT INTO prfNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Sapul pa ten sapul ay ked dán en Upos, kaguman nen Diyos en Upos, sakay en Upos ay siya dán en Diyos. ");
INSERT INTO prfNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Sapul pa ten sapul ay kaguman dán siya nen Diyos. ");
INSERT INTO prfNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Linalang en atanan bagay a ten pamamag-itan na, sakay awan ti linalang a bakán a ten pamamag-itan na. ");
INSERT INTO prfNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","En Upos en paggubwatan ni biyag, sakay iyád a biyag ay nangatád ti demlag ten tolay. ");
INSERT INTO prfNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Iyád a demlag ay magdemlag ten kadiklámman, sakay awan iyád madaig nen diklám. ");
INSERT INTO prfNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Nadid, tehud a essa a lállaki a inutusan en Diyos, en ngaran na ay ti Juan. ");
INSERT INTO prfNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Pinaangay na ti Juan ten tolay hidi, inutusan siya tánni ipahayag na en tungkul ten demlag, tánni sumampalataya en atanan a tolay. ");
INSERT INTO prfNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Bakán a ti Juan en demlag, nan inutusan siya tánni mángpahayag ni deya en demlag. ");
INSERT INTO prfNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","En tunay a demlag a mangdemlag ten atanan a tolay ay dumemát ti munduwiday. ");
INSERT INTO prfNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Dummemát en Upos ti munduwiday, peru awan siya tinenggi ni munduwiday maski ni linalang i munduwiday ten pamamag-itan na. ");
INSERT INTO prfNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Ummangay siya ten sadili na a banuwan, peru awan siya tinanggap nen kabanuwan na hidi. ");
INSERT INTO prfNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Peru en atanan a nangtanggap sakay summampalataya dikona ay inátdenan na ti karapatan a magin anak nen Diyos. ");
INSERT INTO prfNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Nagin anak ngani hidi nen Diyos bakán a ten pamamag-itan nen pisikal a kákkeenak oni gapu ten kagustuwan nen tolay, nan gapu ten kaluuban nen Diyos. ");
INSERT INTO prfNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","En Upos ay nagin tolay sakay nákpágyan dikomi. Netan mi en kaluwalhatian na bilang bugtung a anak nen Ama. Putat siya ti kabaitan sakay katutuhanan. ");
INSERT INTO prfNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Impahayag siya ni Juan, sakay impákraw na ten tolay hidi a, “Siya en kinagi ku dikomoy a, ‘En dumemát a kasunud ku ay mataas nan sikán, gapu baguwák a neenak ay ked dán siya.’ ” ");
INSERT INTO prfNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Gapu putat siya ti págmahal, ay naranasan tam a atanan en tulos-tulos a pagpapala. ");
INSERT INTO prfNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Neatád dikomi en Kautusan nen Diyos ten pamamag-itan ni Moises, peru en kabaitan sakay katutuhanan ay neatád ten pamamag-itan ni Jesu-Cristo. ");
INSERT INTO prfNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Maski nikan ay awan palla ti naketa ten Diyos. Peru impakilala siya nen bugtung a Anak a tunay a kasayaan nen Ama. ");
INSERT INTO prfNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Inutusan nen pinunu hidi nen Judio hidi ti Jerusalem en sangan a padi sakay Levita a itanung kánni Juan ni deya siya. ");
INSERT INTO prfNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Intapat a kinagi ni Juan dikodi, “Bakán a sikán en Cristo.” ");
INSERT INTO prfNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","“Ni konahud ay deya ka?” tanung di, “Siko beman ti Elias?” “Bakán a sikán,” kagi ni Juan. “Siko beman en propeta?” Kinagi na dikodi, “Bakán a sikán.” ");
INSERT INTO prfNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","“Deya ka beman a talaga? Kagiyán mu dikomi tánni tehud kami a mekagi ten nagutus hidi dikomi. Ánya makagi muwid tungkul ti sadili muwen?” ");
INSERT INTO prfNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","“Tummábbig ti Juan ten pamamag-itan nen kinagi ni propeta Isaias, “Sikán en boses nen tolay a magpákraw ten parang, ‘Pasunongán moy en paglakadan nen Panginoon.’ ” ");
INSERT INTO prfNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","En nagtanung hidi ay inutusan nen Pariseo hidi. ");
INSERT INTO prfNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Tinanung di a ruway ti Juan, “Bakin magbinyag ka, ni bakán bali a siko en Cristo, oni ti Elias, oni en propeta?” ");
INSERT INTO prfNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Tummábbig ti Juan, “Mágbinyagák dikomoy ten dinom, peru tehud a ked ti ditángnga moyen a awan moy matenggi. ");
INSERT INTO prfNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Dumemát siya a kasunud ku peru awanák karapatdapat dikona maski ni mangokbis dálla ten igut nen sandalyas na.” ");
INSERT INTO prfNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Iyád ay nangyari ti Betania, ten dibelyu nen dinom ti Jordan a nagbinyagan ni Juan. ");
INSERT INTO prfNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Ten kailawan na, ay netan ni Juan ti Jesus a umadeni dikona. Kaya kinagi na ten tolay hidi, “Siya iddi en Tupa nen Diyos. Siya en mangibut ten kasalanan nen tolay ti munduwiday. ");
INSERT INTO prfNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Siya en kinagi ku dikomoy a dumemát a kasunud ku a mas mataas nan sikán. Gapu baguwák pa a neenak ay ked dán siya. ");
INSERT INTO prfNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Awan ku bi siya matenggi tenhud peru ummangayák háddi a magbinyag ti dinom tánni ipakilala ku siya ti Israel. ");
INSERT INTO prfNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Káttapos ay nagpatunay ti Juan, a kinagi na, “Netan ku en Ispiritu a dummibábbi a gubwat dilanget a kona ten essa a kalapati, sakay ummapon dikona. ");
INSERT INTO prfNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Awan ku siya matenggi tenhud, peru en nangutus dikoku a magbinyag ti dinom ay siya labi en nagkagi a, ‘Ketan mu a dumibábbi en Ispiritu sakay mágyan ten essa a tolay. Iyud a tolay i magbinyagid ti Banal Ispiritu.’ ");
INSERT INTO prfNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Mineta ku siya kaya patunayan ku a siya en Anak nen Diyos.” ");
INSERT INTO prfNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Ten kinailawan na, ay ked dámman haud ti Juan kaguman na en duwwa na a disepulus. ");
INSERT INTO prfNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Dikona ketan na ti Jesus a magtalib ay kinagi na, “Siya en Tupa nen Diyos!” ");
INSERT INTO prfNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Ten pákkasanig nen duwwa a disepulus ten kinagi ni Juan, ay inunud di ti Jesus. ");
INSERT INTO prfNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Dikona sumulig ti Jesus, ay netan na hidi a umunonud, kaya tinanung na hidi, “Ánya kailangan moyid?” Kinagi di, “Hádya táttulusan muwid Rabbi?” (En gustu a kagiyán nen Rabbi ay Maistu.) ");
INSERT INTO prfNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","“Kamon haád angen moy ilingán,” kagi ni Jesus. Kaya nákkuyug hidi kánni Jesus sakay netan di en táttulusan na; sakay náktulos dán bi hidi ti iyud a aldew gapu magalaskuwatru dán ten apon. ");
INSERT INTO prfNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","En essa ten duwwa a nakasanig ten kinagi ni Juan ay ti Andres a kapatkaka ni Simon Pedro. ");
INSERT INTO prfNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Kaya inaryok ni Andres en kapatkaka na a ti Pedro sakay kinagi na, “Netan mi dán en Mesias!” (En gustu a kagiyán nen Mesias ay Cristo.) ");
INSERT INTO prfNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Ingkuyug ni Andres ti Simon a ummangay kánni Jesus. Ten pákketa ni Jesus kánni Pedro ay kinagi na, “Siko ay ti Simon a anak ni Juan. Sapul nadid ay ngaranan ka dán a Cefas.” (En kahulugan na ay Pedro, ti iba a upos ay batu). ");
INSERT INTO prfNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Ten kailawan na ay naisipan ni Jesus a umangay ti Galilea. Netan na haud ti Felipe sakay kinagi na, “Mákkuyug ka dikoku.” ");
INSERT INTO prfNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","(Ti Felipe ay taga-Bethsaida a kabanuwan de Andres ay ti Pedro.) ");
INSERT INTO prfNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Netan ni Felipe ti Natanael, sakay kinagi na dikona, “Netan mi dán en kinagi ni Moises ten kasulatan sakay nen propeta hidi. Siya ay ti Jesus a taga Nazaret a anak ni Jose.” ");
INSERT INTO prfNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","“Tehud beman a maggubwat a mahusay ti Nazaret?” tanung ni Natanael. Tummábbig ti Felipe, “Karon hád angen mu ilingán.” ");
INSERT INTO prfNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Pákketa ni Jesus kánni Natanael a patamu dikona ay kinagi na, “Ilingán moy, i tatarudanen a Israelita. Awan siya mágwariwari.” ");
INSERT INTO prfNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Tinanung siya ni Natanael, “Konyaák mu a nakilala?” Tummábbig ti Jesus, “Bagu ka pa a dulawán ni Felipe ay netan taka dán dikona a ked ka ten sarok nen kayu a igos.” ");
INSERT INTO prfNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Kinagi ni Natanael, “Maistu, talaga a siko en Anak nen Diyos! Siko en Hari ni Israel!” ");
INSERT INTO prfNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Kinagi ni Jesus, “Sumampalataya ka beman gapu ten kinagi ku a netan taka ten sarok nen kayu a igos? Makpal ka pa a ketan a mas lalu pa haán.” ");
INSERT INTO prfNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Sakay kinagi ni Jesus dikona, “Tandaan mu, ketan mu a bukas dilanget sakay en anghel hidi nen Diyos ay sumangkay sakay umugsad ten páppágyanan nen Anak nen Tolay. ");
INSERT INTO prfNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Nadid, kállipas nen kaduwwa a aldew, ay tehud a kasalan ti Cana a sakup ni Galilea. Ked haud en ina ni Jesus. ");
INSERT INTO prfNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Imbitadu bi de Jesus ay ten disepulus na hidi ten kasalan. ");
INSERT INTO prfNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Naubusan hidi ti alak ten handaan. Kaya kinagi nen ina ni Jesus dikona, “Naubusan dán hidi ti alak.” ");
INSERT INTO prfNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Kinagi ni Jesus, “Dyanák mu dipalonguwan. Bakán palla a iyád en tama a odas.” ");
INSERT INTO prfNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Kinagi nen ina na ten mágserbi hidi, “Gamitán moy en ányaman a kagiyán na dikomoy.” ");
INSERT INTO prfNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Tehud a ánnám a tapayan a maglasán ti manga duwwa a pulu hanggan tállu a pulu a galon. Hidi iyád ay nehanda para pággugasan nen Judio hidi ayun ten relihiyon di. ");
INSERT INTO prfNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Kinagi ni Jesus ten mágserbi hidi, “Sigi putatán moy ti dinom tapayanen hidi.” Pinutat di ngani en tapayan hidi. ");
INSERT INTO prfNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Sakay kinagi na dikodi, “Mangsigit kam sakay iyangay moy ten tagapamahala ten kasalan.” Nangsigit ngani hidi sakay inyangay di ten tagapamahala ten kasalan. ");
INSERT INTO prfNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Dikona ennaman nen tagapamahala ten kasalan en dinom a nagin alak ay awan na tukoy ni hádya iyud a naggubwat. Peru tukoy nen mágserbi hidi a nangsigit. Kaya dinulaw nen tagapamahala en lállaki a kinasal. ");
INSERT INTO prfNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Kinagi na, “En masarap a alak en purumeru a iluwas sakay iluwas en mahina a kalasi ni alak ni makpal dán a mainom en tolay hidi. Peru siko ay indimudyan mu a inluwas en masarap a alak.” ");
INSERT INTO prfNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Iyád a ginamet ni Jesus ti Cana, en kapurumeruwan a ginamet na a himala. Ten pamamag-itan ni iyud ay nehayag en kapangyariyan na sakay naniwala en disepulus na hidi. ");
INSERT INTO prfNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Káttapos ni iyud, ay ummangay de Jesus ti Capernaum. Kaguman na en ina na, sakay en kákkapatkaka na hidi ay ten disepulus na hidi. Sakay náktulos hidi haud ti sangan a aldew. ");
INSERT INTO prfNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Nadid, dikona a adeni dán en Piyesta nen Aldew nen Págtalib nen Judio hidi, ay ummangay ti Jesus ti Jerusalem. ");
INSERT INTO prfNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Ten kássáddáp na ten Templo, ay netan na en tolay hidi a maglaku-laku. Maglaku hidi ti kabakaan, tupa sakay kalapati, sakay netan na bi haud en mágpalit hidi ti pilak. ");
INSERT INTO prfNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Naggamet ti Jesus ti pághaplit a lubid sakay intabuy na a paluwas ten Templo en máglaku-laku hidi, pati en baka hidi sakay tupa hidi. Insapwar na en pilak nen mágpalit hidi sakay impágpasakáb na en lamisaan di hidi. ");
INSERT INTO prfNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Sakay kinagi na ten maglaku hidi ti kalapati, “Ibutan moy háddi hidi iyán, bakin ginamet moy a palengki en bilay nen Ama ku?” ");
INSERT INTO prfNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Naala-ala nen disepulus na hidi en nesulat ten kasulatan a, “En págsurug ku ten bilay mu ay kumán a apoy a maggerab ti pusu kuwiday.” ");
INSERT INTO prfNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Gapu haud, ay tinanung siya nen pinunu hidi nen Judio hidi, kinagi di, “Ánya i mepeta muwid dikomi a himala, tánni patunay a tehud ka a karapatan a gamitán iyád?” ");
INSERT INTO prfNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Tummábbig ti Jesus, “Rábbaán moy i Templowid a iyád sakay ten alay nen tállu a aldew ay itaknág ku iyád a ruway.” ");
INSERT INTO prfNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Kinagi nen pinunu hidi nen Judio hidi, “Samantala áppat a pulu ay ti ánnám a taon a ginamet i Templowid a iyád? Sakay nadid ay itaknág mu la ti tállu a aldew?” ");
INSERT INTO prfNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Peru en Templo a kinagi ni Jesus ay en bággi na. ");
INSERT INTO prfNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Kaya, dikona nabiyag siya a ruway ten katállu a aldew, ay naala-ala nen disepulus na hidi iyud a kinagi na. Sakay lalu hidi a naniwala ten kasulatan sakay ten intoldu hidi ni Jesus. ");
INSERT INTO prfNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Nadid, ten Piyesta nen Aldew nen Págtalib ti Jerusalem, ay makpal en summampalataya kánni Jesus ten dikona ketan di en himala hidi a ginággamet na. ");
INSERT INTO prfNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Peru awan nagtiwala ti Jesus dikodi gapu tukoy na en ked ten isip di. ");
INSERT INTO prfNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Awan dán siya kailangan a baretaan tungkul ten deyaman, gapu tukoy na en ked ten isip nen atanan a tolay. ");
INSERT INTO prfNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Nadid, tehud a essa a pinunu nen Judio hidi a en ngaran na ay ti Nicodemo. Kabilang bi siya ten grupu nen Pariseo hidi. ");
INSERT INTO prfNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Ten essa a gibi, ay ummangay siya kánni Jesus sakay kinagi na, “Maistu, tukoy mi a siko ay essa a maistu a gubwat ten Diyos gapu awan ti makagamet ten himala hidi a gággamitán mu ni awan dikona en Diyos.” ");
INSERT INTO prfNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Tummábbig ti Jesus, “Kagiyán ku dikomu mentras a awan meenak a ruway en essa a tolay ay awan na ketan en kahariyan nen Diyos.” ");
INSERT INTO prfNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","“Konya a meenak a ruway en essa a tolay a matanda dán? Makasáddáp beman siya a ruway ten tiyan nen ina na para meenak a ruway?” kagi ni Nicodemo. ");
INSERT INTO prfNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Kinagi ni Jesus, “Tandaan mu, en tolay a awan meenak a ruway ten dinom sakay ten Ispiritu, ay awan makasáddáp ten kahariyan nen Diyos. ");
INSERT INTO prfNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","En meenak ayun ten pagkatolay ay tolay, sakay en meenak ayun ten Ispiritu ay ispiritu. ");
INSERT INTO prfNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Dyan ka magtaka ten kinagi ku dikomu, ‘Kailangan a meenak a ruway en atanan a tolay.’ ");
INSERT INTO prfNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Ni magparás ay masanig mu en tánnug na peru awan mu tukoy naggubwatan naid sakay tamuwán naid. Kona labi hud en tolay a neenak ayun ten Ispiritu.” ");
INSERT INTO prfNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Kinagi ni Nicodemo, “Konya iyád a mangyari?” ");
INSERT INTO prfNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Kinagi ni Jesus, “Essa ka pa bi a matalinu a maistu ti Israel bakin awan mu maintendiyan i bagayid a hidi iyád? ");
INSERT INTO prfNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Tandaan mu: en ikagi mi ay tukoy mi, sakay en patunayan mi ay netan mi, peru awan moy iyud tinanggap. ");
INSERT INTO prfNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Ni awan kam maniwala ten bagay hidi a kagiyán ku tungkul ti munduwiday, ay konya moy a paniwalaan en ikagi ku a tungkul ten bagay hidi dilanget? ");
INSERT INTO prfNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Awan ti iba a ummangay dilanget nan en dummibábbi a gubwat dilanget a en Anak nen Tolay. ");
INSERT INTO prfNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Sakay ni konya a indisunu ni Moises en tangsu a biklat ten parang ay kona labi hud a kailangan a idisunu en Anak nen Tolay. ");
INSERT INTO prfNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Tánni deyaman en sumampalataya dikona ay magkahud ti biyag a awan ti katapusan. ");
INSERT INTO prfNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Gapu mahal a tarud nen Diyos en atanan a tolay ti munduwiday, kaya inyatád na en bugtung na a Anak, tánni deyaman en sumampalataya dikona ay awan mepahamak nan magkahud ti biyag a awan ti katapusan. ");
INSERT INTO prfNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Gapu inutusan nen Diyos en anak na, bakán a para hatulan ti parusa i munduwiday, nan iligtas ten pamamag-itan na. ");
INSERT INTO prfNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Awan dán mahatulan a maparusaan en sumampalataya ten Anak. Peru nahatulan dán en awan sumampalataya. Gapu awan siya summampalataya ten bugtung a Anak nen Diyos. ");
INSERT INTO prfNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Nahatulan hidi, gapu ummangay dán ti munduwiday en demlag, peru ginustu pa nen tolay hidi en diklám nan ten demlag, gapu en gággamitán di ay mágkadukás. ");
INSERT INTO prfNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","En mággamet ti madukás ay maiyamut ten demlag. Adeyuwan di en demlag tánni awan ketan en gamet di. ");
INSERT INTO prfNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Peru en mabiyag a ayun ten katutuhanan ay umadeni ten demlag, tánni mehayag en gamet na a ayun ten kaluuban nen Diyos. ");
INSERT INTO prfNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Káttapos ni iyud ay ummangay de Jesus ay ten disepulus na hidi ti Judea. Nágyan hidi haud ti sabadit a panahun sakay nagbinyag ten tolay hidi. ");
INSERT INTO prfNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Ti iyud a panahun, ay magbinyag bi ti Juan ti Enon, adeni ti Salim, gapu makpal a dinom haud, sakay ummangay dikona en tolay hidi a magpabinyag. ");
INSERT INTO prfNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","(Awan palla hud nepiresu ti Juan) ");
INSERT INTO prfNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Nadid, nagkatábbigan en disepulus hidi ni Juan ay ten essa a Judio, tungkul ten páglinis ayun ten relihiyon di. ");
INSERT INTO prfNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Kaya ummangay hidi kánni Juan, sakay kinagi di, “Maistu, en lállaki a kaguman mu ten dibelyu ni Jordan, en pinatunayan mu, ay magbinyag bi sakay ngari-ngari a atanan tolay ay ummangay dikona!” ");
INSERT INTO prfNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Kinagi ni Juan, “Awan ti magamet en tolay ni awan ipagkaluub nen Diyos. ");
INSERT INTO prfNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Awan moy beman naala-ala en kinagi ku dikomoy a bakán a sikán en Cristo nan inutusanák la a mágdipalongu dikona. ");
INSERT INTO prfNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","En bábbi a ikasal ay para ten lállaki a ikasal. En abay a maguray ten káddemát nen lállaki a ikasal ay masaya a tarud ni masanig na dán en boses nen lállaki. Konaák labi haud nadid masayaák a tarud a meta ku en tolay hidi a umangay kánni Jesus. ");
INSERT INTO prfNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Kailangan a lalu siya a metaas, sakay sikán ay mebaba. ");
INSERT INTO prfNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","En gubwat dilanget ay kataasan ten atanan; en gubwat ti lutaiday ay tagaluta sakay magupos tungkul ten bagay hidi ti lutaiday. En gubwat dilanget ay kataasan ten atanan. ");
INSERT INTO prfNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Imbareta na en nasanig na sakay en netan na, peru awan ti maniwala ten imbareta na. ");
INSERT INTO prfNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Peru en naniwala hidi ten imbareta na, ay magpatunay a en kinagi nen Diyos ay tama. ");
INSERT INTO prfNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","En inutusan nen Diyos ay magpahayag ten upos hidi nen Diyos, gapu awan ti karád en págkaluub nen Diyos ten Ispiritu na. ");
INSERT INTO prfNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Mahal nen Diyos en Anak, sakay inyatád nen Diyos dikona en pámmahala ten atanan a bagay. ");
INSERT INTO prfNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","En sumampalataya ten Anak nen Diyos, ay tehud a biyag a awan ti katapusan. Peru en awan sumunud ten Anak, ay awan magkahud ti biyag. Nan manatili dikona en iyamut nen Diyos. ");
INSERT INTO prfNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Nadid, nabareta nen Pariseo hidi a mas makpal a naakit sakay nabinyagan ti Jesus nan ti Juan. ");
INSERT INTO prfNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(Peru bakán a ti Jesus a mismu en magbinyag, nan en disepulus na la hidi). ");
INSERT INTO prfNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Dikona nabareta iyud ni Jesus, ay lummakad siya ti Judea, sakay nagsoli ti Galilea. ");
INSERT INTO prfNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Ten kássoli di ay kailangan a dumaman siya ti Samaria. ");
INSERT INTO prfNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Nademát di en essa a banuwan a en ngaran na ay Sicar a sakup ni Samaria. Adeni ti Sicar en luta a inyatád ni Jacob ten anak na a ti Jose. ");
INSERT INTO prfNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Ketan haud en bal-ung ni Jacob. Káddemát di haud ay nággetnud ti Jesus ten gilid nen bal-ung, gapu pagud a naglakad. Halus adeni dán a magtanghali en aldew. ");
INSERT INTO prfNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Tehud a essa a Samaritana a angay summagáb. Kinagi ni Jesus dikona, “Mák-enumák pay.” ");
INSERT INTO prfNT_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","(Ti iyud a pagkakataun ay awan en disepulus na hidi gapu ummangay hidi ten banuwan a mamali ti makan di.) ");
INSERT INTO prfNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Kinagi dikona nen Samaritana, “Awan beman Judio ka, sakay mák-enom ka dikoku a Samaritana?” (Gapu awan maari a mákpággagum en Judio hidi ten Samaritano hidi.) ");
INSERT INTO prfNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Kinagi ni Jesus dikona, “Ni tukoy mu la en kaluub nen Diyos, sakay ni deya i mák-enomidi dikomu, ay maari a siko i mággidid dikona ti dinom sakay átdenan na ka ti dinom a makapangatád ti biyag.” ");
INSERT INTO prfNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Kinagi nen bábbi, “Ti kadsalad ni bal-ungidi sakay awan ka pa bi ti págtabu, hádya pangalapan muwid ti dinom a makapangatád ti biyag? ");
INSERT INTO prfNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Iyád a bal-ung ay gubwat ten ninunu mi a ti Jacob. Umminom siya háddi sakay en anak na hidi maski en hayup na hidi. Mataasan mu beman siya?” kagi na. ");
INSERT INTO prfNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Kinagi ni Jesus, “En uminom ti dinomid a iyád ay mauwaw padi a ruway, ");
INSERT INTO prfNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","peru en uminom ten iyatád ku a dinom ay awan dán mauwaw a ruway. Gapu en dinom a iyatád ku ay magin kona ten bukal a tulos-tulos a magbulos sakay makapangatád dikona ti biyag a awan ti katapusan. ");
INSERT INTO prfNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Kinagi nen bábbi, “Átdenanák mu pay ti kona ti iyán a dinom tánni awanák dán mauwaw a ruway, sakay awanák dán sumoli háddi a sumagáb a ruway.” ");
INSERT INTO prfNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","“Umuli ka dán sakay ikuyug mu háddi en kabinga mu,” kagi ni Jesus. ");
INSERT INTO prfNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","“Awanák ti kabinga,” tábbig nen bábbi. Kinagi ni Jesus, “Tama ka, ti kinagi muwen a awan ka ti kabinga ");
INSERT INTO prfNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","gapu limma dán en nagin kabinga mu, sakay en kapisan mu nadid ay bakán mu a kabinga.” ");
INSERT INTO prfNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Kinagi nen bábbi, “Talaga a propeta ka bewád?” ");
INSERT INTO prfNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","“Háddi a bukid a sinumamba ten Diyos en ninunu mi hidi, peru kagi moy a Judio hidi a ti Jerusalem la dapat a sambaán en Diyos.” ");
INSERT INTO prfNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Kinagi ni Jesus dikona, “Maniwala ka dikoku, a sambaán en Diyos bakán la a ti iyán a bukid oni ti Jerusalem. ");
INSERT INTO prfNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Sikam a Samaritano ay awan moy tukoy i sambaán moyid, peru sikami a Judio hidi ay tukoy mi en sambaán mi, gapu en kaligtasan ay nagsapul ten Judio hidi. ");
INSERT INTO prfNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Peru dumemát dán en panahun nadid dán ngani a mismu, a en tunay a sumamba ten Ama ay sumamba ten ispiritu ay ten katutuhanan. Gapu iyud en gustu nen Ama ten balang sumamba dikona. ");
INSERT INTO prfNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","En Diyos ay Ispiritu, kaya dapat siya a sambaán ten ispiritu ay ten katutuhanan. ");
INSERT INTO prfNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Kinagi nen bábbi, “Tukoy ku a pademát en Mesias, en kákkagiyán a Cristo. Káddemát na ay siya en mángpaliwanag dikomi ten atanan a bagay” ");
INSERT INTO prfNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","“Sikán dán iyád a mismu i kagiyán muwen,” kagi ni Jesus. ");
INSERT INTO prfNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Káddemát nen disepulus hidi ni Jesus a gubwat ten banuwan ay nabigla hidi dikona ketan di a mákpágguron siya ten Samaritana. Peru awan ti nagtanung dikodi ten bábbi a, “Ánya kailangan muwid?” Awan bi ti nagtanung kánni Jesus a, “Bakin mákpágguron ka dikona?” ");
INSERT INTO prfNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Linakadan nen bábbi en isássagáb na, summoli ten banuwan sakay kinagi na ten tolay hidi haud, ");
INSERT INTO prfNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Kadtamon, angen moy ilingán en tolay a nakatukoy ten atanan a ginamet ku. Siya dán wád Cristowid?” ");
INSERT INTO prfNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Ten pákkatukoy di ay lummuwas hidi ten banuwan sakay ummangay hidi kánni Jesus. ");
INSERT INTO prfNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Pumensangan dán a kinagi nen disepulus na hidi a, “Maistu, angay ka pa kuman.” ");
INSERT INTO prfNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Peru kinagi na, “Tehudák a pagkain a awan moy tukoy.” ");
INSERT INTO prfNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Kaya nagtanungan en disepulus na hidi, “Tehud wád a nangatád dikona ti makan na?” ");
INSERT INTO prfNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Kinagi ni Jesus dikodi, “Pagkain kuwid ay tupadán ku en kaluuban nen nangutus dikoku, sakay tapusán en pagamet na dikoku. ");
INSERT INTO prfNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Awan beman kakagiyan moy a, ‘Áppat dálla a bulan ay sák-ani dán?’ Kagiyán ku dikomoy, a nalutu dán en mula hidi nakahanda dán tánni aniyán. ");
INSERT INTO prfNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","En maggapas ay makatanggap ti upa sakay magpuron ti bunga a para ten biyag a awan ti katapusan. Kaya en mágmula sakay en mággapas ay parehu hidi a magkahud ti kasayaan. ");
INSERT INTO prfNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Kaya tama la en kakagiyan a, ‘Iba en magmula sakay iba bi en magani.’ ");
INSERT INTO prfNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Utusan takam, a aniyán moy en awan moy immula. Iba en nagpagud, sakay sikam en magani ten nagpagudan di.” ");
INSERT INTO prfNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Makpal a Samaritano ti banuwanid a iyud en naniwala kánni Jesus, gapu ten pahayag nen bábbi a, “Kinagi na dikoku en atanan a ginamet ku.” ");
INSERT INTO prfNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Kaya kinauron di ti Jesus a mákpágyan pala siya haud. Sakay nákpágyan bi siya haud ti duwwa a aldew. ");
INSERT INTO prfNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Makpal en summampalataya dikona masanig di siya. ");
INSERT INTO prfNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Kinagi di ten Samaritana, “Maniwala kami dán nadid, bakán la a gapu ten kinagi mu nan gapu nasanig mi siya. Natukuyan mi dán a siya en Tagapagligtas nen tolay ti munduwiday.” ");
INSERT INTO prfNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Nadid, kállipas nen duwwa a aldew, ay nagsoli ti Jesus a tamu ti Galilea. ");
INSERT INTO prfNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","(Kinagi ni Jesus a en essa a propeta ay awan di igagalang ten sadili na a banuwan.) ");
INSERT INTO prfNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Káddemát ni Jesus ti Galilea ay mahusay en pángtanggap dikona nen tolay hidi, gapu natandaan di en atanan a ginággamet na a himala ti Jerusalem ten Piyesta nen Aldew nen Págtalib. ");
INSERT INTO prfNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Ummangay a ruway ti Jesus ti Cana a sakup ni Galilea a nanggamitan na ten dinom a nagin alak. Ti Capernaum ay tehud a essa a pinunu ni gubiyernu a tehud a anak a lállaki a tehud a saket ");
INSERT INTO prfNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","sakay maghingalu dán. Dikona a nabareta na a nagsoli ti Jesus ti Galilea a gubwat ti Judea, ay ummangay siya nákpágguron kánni Jesus a angay na pagpiyyaán en anak na ti Capernaum. ");
INSERT INTO prfNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Kinagi ni Jesus, “Mentras a awan kam ti ketan a himala hidi sakay makataka-taka a bagay ay awan kam sumampalataya.” ");
INSERT INTO prfNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Kinagi nen pinunu, “Kadtamon pay, Panginoon, bagu matay en anak ku.” ");
INSERT INTO prfNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Kinagi ni Jesus dikona, “Umuli ka dán, mahusay dán en anak mu.” Pákkasanig nen lállaki ten kinagi ni Jesus ay naniwala siya sakay tulos dán a ummuli. ");
INSERT INTO prfNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Maglakad palla siya ten soli na ay natagbu na dán en alipin na hidi sakay kinagi di dikona a nagpiyya dán en anak na. ");
INSERT INTO prfNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Tinanung na hidi, “Ánya a kaodas nagpiyya naid?” Kinagi di, “Nawasan siya ten ladu na ten ala-una nennapon.” ");
INSERT INTO prfNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Naala-ala nen pinunu a konahud en odas dikona kinagi ni Jesus a, “Mahusay dán en anak mu.” Kaya summampalataya siya sakay en buu na a pamilya kánni Jesus. ");
INSERT INTO prfNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Iyád en kaduwwa a ginamet ni Jesus a himala ti Galilea kággubwat na ti Judea. ");
INSERT INTO prfNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Nadid, káttapos ni iyud, ay ummangay ti Jesus ti Jerusalem ten piyesta nen Judio hidi. ");
INSERT INTO prfNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Ti banuwanid a iyud ay tehud a dikál a dipositu ni dinom a kadeni nen Pintuwan nen Tupa hidi. Iyud a dinom ay ngángngaranan nen Judio hidi a Betesda, ten gilid na ay tehud a limma a bilay. ");
INSERT INTO prfNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Napisanpisan haud en te manga saket hidi, kona ten burák, pilay sakay lupug. ");
INSERT INTO prfNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","(Gapu tehud a panahun a dumibábbi en Anghel nen Panginoon sakay kibugán na en dinom. En medipalongu a tumabsung ay magpiyya siya ányaman en saket na.) ");
INSERT INTO prfNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Nadid, tehud haud a lállaki a tállu a pulu ay ti walu dán a taon a tehud a saket. ");
INSERT INTO prfNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Netan siya ni Jesus, tukoy na a iyud a lállaki ay nalay dán a tehud a saket. Tinanung na siya, “Gustu mu beman a magpiyya?” ");
INSERT INTO prfNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Tummábbig en tehud a saket, “Maistu, awan biyay ti mangtulung dikoku a tumabsung ni tehud dán a mangkibug ti dinomen, patamuwák palla ay tehud dán a nakadipalongu dikoku.” ");
INSERT INTO prfNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Kinagi ni Jesus dikona, “Tumaknág ka, betbitán mu i abák muwen, sakay maglakad ka.” ");
INSERT INTO prfNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Ti odasid a iyud ay nagpiyya en lállaki, inalap na en abák na sakay naglakad. Iyud a aldew ay Aldew nen Káimang. ");
INSERT INTO prfNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Kaya kinagi nen pinunu nen Judio hidi ten lállaki a nagpiyya, “Aldew nadid nen Káimang! Labag ten Kautusan a magbetbet ka ti abák muwen.” ");
INSERT INTO prfNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Peru kinagi na dikodi, “En nagpapiyya dikoku i nangkagiyid a betbitán ku i abák kuwidi sakay maglakadák.” ");
INSERT INTO prfNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","“Deya beman nagkagiyid dikomu a betbitán mu i abák muwen sakay maglakad ka?” kagi di. ");
INSERT INTO prfNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Peru awan tukoy nen lállaki ni deya en nagpapiyya dikona, gapu awan dán ti Jesus ten kakpalan nen tolay. ");
INSERT INTO prfNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Kállipas ni iyud, ay netan ni Jesus ten Templo en lállaki a pinagpiyya na. Kagi na dikona, “Nadid ta nagpiyya ka dán, ay dyan ka dán maggamet ti kasalanan, bakay mas madukás pa i mangyariyid dikomu.” ");
INSERT INTO prfNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Kállakad nen lállaki ay ummangay siya ten Judio hidi sakay kinagi na dikodi a ti Jesus i nagpapiyyaid dikona. ");
INSERT INTO prfNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Kaya sapul haud, ay inusig dán nen pinunu hidi nen Judio hidi ti Jesus gapu ten págpapiyya na ten Aldew nen Káimang. ");
INSERT INTO prfNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Peru kinagi ni Jesus dikodi, “En Ama ku ay tulos-tulos a magtarabahu a hanggan nadid, konaák labi haud.” ");
INSERT INTO prfNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Gapu ti iyud, ay lalu di a pinagsikapan a pabunu ti Jesus gapu linabag na dán en batas nen Aldew nen Káimang ay kinagi na pa a en Diyos i Ama naid, gustu naid a kagiyán ay ipantay na en sadili na ten Diyos. ");
INSERT INTO prfNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Kaya kinagi ni Jesus dikodi, “Kagiyán ku dikomoy en katutuhanan a awan ti magamet en Anak a gubwat ten sadili na la; nan en ketan na a gamitán nen Ama ay siya labi iyud i gamitán naid. En gamitán nen Ama ay siya labi en gamitán nen Anak. ");
INSERT INTO prfNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Gapu mahal nen Ama en Anak, kaya ipeta na ten Anak en atanan a gággamitán na, sakay higit pa ti hidi iyán en gamet a ipeta dikona nen Ama tánni lalu kam a humanga. ");
INSERT INTO prfNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Ni biyagán nen Ama en patay hidi, ay kona labi hud, a biyagán nen Anak en deyaman a gustu na a biyagán. ");
INSERT INTO prfNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Awan maghatul en Ama, nan inyatád na ten Anak en atanan a kapangyariyan a maghatul, ");
INSERT INTO prfNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","tánni parangalan nen atanan en Anak a kona ten págparangal di ten Ama. En awan magparangal ten Anak ay awan labi magparangal ten Ama a nangutus ten Anak.” ");
INSERT INTO prfNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Kagiyán ku dikomoy en tatarudan, en mágsanig ten upos ku sakay en sumampalataya ten nangutus dikoku ay magkahud ti biyag a awan ti katapusan. Awan dán siya mahatulan nan neagton dán siya ten biyag gubwat ten kamatayan. ");
INSERT INTO prfNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Tandaan moy iddi: dumemát en odas, nadid dán ngani, a masanig nen patay hidi en boses nen Anak nen Diyos sakay en mágsanig dikona ay mabiyag. ");
INSERT INTO prfNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Ni konya a en Ama ku a mismu en paggubwatan nen biyag, kona labi hud en Anak ay inátdenan na ti konahud a kapangyariyan. ");
INSERT INTO prfNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Sakay inátdenan na bi ti kapangyariyan en Anak a maghatul gapu siya en Anak nen Tolay. ");
INSERT INTO prfNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Dyan kam magtaka ti kagiyán kuwidi, gapu dumemát en odas a masanig nen patay hidi en boses na. ");
INSERT INTO prfNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Mabiyag hidi a ruway; atanan nen naggamet ti maganda ay magkahud ti biyag a awan ti katapusan, sakay en atanan a naggamet ti madukás ay maparusaan.” ");
INSERT INTO prfNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Kinagi ni Jesus, “Awanák ti gamitán a ayun la ten sadili ku, maghatulák a ayun ten kagiyán dikoku nen Ama kaya tama en pághatul ku. Awan ku sunudán en sadili ku nan en sunudán ku ay en nangutus dikoku. ");
INSERT INTO prfNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Ni sikán la en mangpatunay tungkul ten sadili ku, ay en págpatunay ku ay awan tatarudan. ");
INSERT INTO prfNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Peru tehud a magtistigu tungkul dikoku, sakay en ikagi na ay tatarudan. ");
INSERT INTO prfNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Tehud kam a inutusan tenhud kánni Juan, sakay pinatunayan na en tungkul ten katutuhanan. ");
INSERT INTO prfNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Peru mas maganda ni en patunay ay awan naggubwat ti tolay, kinagi ku la iyád tánni maligtas kam. ");
INSERT INTO prfNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Ti Juan ay kumán a en demlag nen simbuwan a magdemlag, sakay nasiyaan kam ti sangan la a panahun ten demlag na. ");
INSERT INTO prfNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Peru tehud a mangpatunay dikoku a higit pa ten págpatunay ni Juan. En gággamitán ku hidi a inyutus nen Ama dikoku. Hidi iyád en mangpatunay a pinaangayák háddi nen Ama. ");
INSERT INTO prfNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Sakay en Ama a nangutus dikoku ay magpatunay bi tungkul dikoku. Maski nikan ay awan moy palla nasanig en boses na, sakay awan moy palla netan en idsura na. ");
INSERT INTO prfNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Awan nanatili dikomoy en upos na gapu awan kam summampalataya ten inutusan na. ");
INSERT INTO prfNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Mággaadalán kam ten Kasulatan, gapu en paniwala moy ay haud moy a maaryok en biyag a awan ti katapusan. Hidi iyán a Kasulatan ay magpatunay tungkul dikoku! ");
INSERT INTO prfNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Peru umád kam padi a magpasakup dikoku tánni magkahud kam ti biyag.” ");
INSERT INTO prfNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Awan ku gustuwán a puriyán ni tolay. ");
INSERT INTO prfNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Peru tukoy takam, tukoy ku a awan kam ti págmahal ten Diyos. ");
INSERT INTO prfNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Pinaangayák háddi nen Ama ku, peru awanák moy tanggapán. Peru ni tehud a iba a angay háddi a ayun la ten sadili na, ay siya en tanggapán moy. ");
INSERT INTO prfNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Sakay en gustu moy la ay papuri nen balang essa, awan moy ginustu en papuri a gubwat ten eessa a Diyos. Konya kam a makapaniwala dikoku? ");
INSERT INTO prfNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Dyan moy isipán a sikán i mángkasuwid dikomoy ten Ama, ti Moises a inasaan moy i mángkasuwid dikomoy. ");
INSERT INTO prfNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Ni talaga maniwala kam kánni Moises, ay maniwala kam bi dikoku, gapu en insulat na ay tungkul dikoku. ");
INSERT INTO prfNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Nadid gapu awan kam maniwala ten insulat ni Moises, ay awan moy bi mapaniwalaan en kagiyán ku?” ");
INSERT INTO prfNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Káttapos ni iyud ay ummarabes ti Jesus ten dibelyu nen Minalnu ti Galilea, a ngángngaranan di labi a Minalnu ti Tiberias. ");
INSERT INTO prfNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Inunud siya nen makpal a tolay, gapu netan di en págpapiyya na ten tehud hidi a saket. ");
INSERT INTO prfNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Summangkay ti Jesus ten bukid kaguman na en disepulus na hidi sakay nággetnud hidi haud. ");
INSERT INTO prfNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Adeni dán tenhud en Piyesta nen Aldew nen Págtalib nen Judio hidi. ");
INSERT INTO prfNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Pákkatan-aw ni Jesus ten mamagdemáttan a makpal a tolay, ay tinanung na ti Felipe, “Hádya kitam a makabali ti tinapay a kanán ni tolayen hidi?” ");
INSERT INTO prfNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","(Kinagi na la iyud tánni purbaan na ti Felipe, tukoy dán ni Jesus i gamitán naid.) ");
INSERT INTO prfNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Tummábbig ti Felipe, “Ti kakpal diyen, ay maski ni walu a bulan a suweldu ni essa a tolay ay awan makakayaw dikodi maski ni tágsabadit la hidi.” ");
INSERT INTO prfNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Kinagi ni Andres a essa ten disepulus na hidi a kapatkaka ni Simon Pedro, ");
INSERT INTO prfNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Tehud háddi a anak a lállaki a tehud a balon a limma a tinapay sakay duwwa a ikan, peru awan iyád makakayaw ti kakpal diyen.” ");
INSERT INTO prfNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Kinagi ni Jesus ten disepulus na hidi, “Pággetnudán moy hidi.” Nággetnud ngani en tolay hidi ten malawak a kalamonan. En bilang nen kalállakiyan ay umabut ti limmang libu. ");
INSERT INTO prfNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Inalap ni Jesus en tinapay, sakay nagpasalamat ten Diyos. Káttapos ay impetagtag na ten tolay hidi, kona bi hud en ginamet na ten ikan. Nakakan hidi a atanan sakay nabássug. ");
INSERT INTO prfNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Dikona makakan dán en tolay hidi ay kinagi ni Jesus ten disepulus na hidi, “Puronán moy atanan subra tánni awan masayang.” ");
INSERT INTO prfNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Dikona mapuron di en subra, ay nakapuron hidi ti sapulu ay ti duwwa a lákba. ");
INSERT INTO prfNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Pákketa nen tolay hidi ten ginamet ni Jesus ay kinagi di, “Talaga ngani a siya en Propeta a umangay ti munduwiday!” ");
INSERT INTO prfNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Peru nahalata ni Jesus a umadeni en tolay hidi sakay pilitán di siya a gamitán a hari, kaya lummakad siya a mágge-essa sakay summangkay ten bukid. ");
INSERT INTO prfNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Dikona pággapon dán ay ummangay en disepulus hidi ten gilid nen minalnu. ");
INSERT INTO prfNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Summakay hidi ten abeng a paarabes ti Capernaum. Gibi dán ay awan palla ummunud ti Jesus dikodi. ");
INSERT INTO prfNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Bigla a dummáddekál en tagmák gapu ten mabegsák a parás. ");
INSERT INTO prfNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Dikona makabusay hidi ti manga limma hanggan ánnám a kilumetru, ay netan di ti Jesus a maglakad ten dibabew nen dinom a patamu ten abeng, sakay mineántingan hidi. ");
INSERT INTO prfNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Peru kinagi na dikodi, “Dyan kam manteng. Sikán iyád!” ");
INSERT INTO prfNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Nasaya hidi a nangpasakay kánni Jesus, sakay pagdaka hidi a nakademát ten angayan di. ");
INSERT INTO prfNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Ten kailawan na ay netan nen tolay hidi a ked haud a ked palla en essa a abeng. Tukoy di a ti Jesus ay awan kaguman nen disepulus na hidi, gapu hidi la en lummakad a nágsakay ten abeng. ");
INSERT INTO prfNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Dummemát bi en agum a abeng a gubwat ti Tiberias sakay nagdung haud ten tapat nen kummanan di ten tinapay a impasalamat nen Panginoon. ");
INSERT INTO prfNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Dikona ketan nen tolay hidi a awan dán haud ti Jesus maski en disepulus na hidi, ay summakay hidi ten abeng hidi a patamu ti Capernaum tánni aryokán di ti Jesus. ");
INSERT INTO prfNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Dikona ketan di ti Jesus ten dibelyu nen minalnu ay tinanung di, “Nengkan ka pa háddi Maistu?” ");
INSERT INTO prfNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Kinagi ni Jesus, “I tatarudanid ay kaya aryokánnák moy ay bakán a gapu ten netan moy hidi a himala nan gapu nakakan kam ti tinapay sakay nabássug. ");
INSERT INTO prfNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Dyan kam magaryok ti pagkain a masida la nan en pagkain a awan masida sakay makapangatád ti biyag a awan ti katapusan. Iyán en iyatád dikomoy nen Anak nen Tolay, gapu siya en inatáddan nen Diyos Ama ti konahud a kapangyariyan.” ");
INSERT INTO prfNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Kaya kinagi di kánni Jesus, “Ánya i dapat miyid a gamitán tánni masunud mi en kaluuban nen Diyos?” ");
INSERT INTO prfNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Kinagi ni Jesus, “Iddi en gustu nen Diyos a gamitán moy, sumampalataya kam ten inutusan na.” ");
INSERT INTO prfNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Kinagi di kánni Jesus, “Ánya i mepeta muwid dikomi a himala tánni sumampalataya kami? Ánya i gamitán muwid?” ");
INSERT INTO prfNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","En ninunu mi hidi ay kinuman ti mana ten kaparangan. Kona ten nesulat ten kasulatan, ‘Inátdenan hidi ni Moises ti tinapay a gubwat dilanget.’ ” ");
INSERT INTO prfNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Kinagi ni Jesus dikodi, “Kagiyán ku dikomoy en tatarudan, bakán a ti Moises en nangatád ti pagkain a gubwat dilanget. En Ama ku en nangatád dikomoy ti tinapay a gubwat dilanget. ");
INSERT INTO prfNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Gapu en pagkain a gubwat ten Diyos ay en dummibábbi a gubwat dilanget sakay mangatád ti biyag ti munduwiday.” ");
INSERT INTO prfNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Tummábbig hidi, “Panginoon, ni kona haud ay átdenan mu kami a pirmi ti iyán a pagkain.” ");
INSERT INTO prfNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Kinagi ni Jesus dikodi, “Sikán en tinapay a makapangatád ti biyag. En umadeni dikoku ay awan dán magaláp maski nikan sakay en sumampalataya dikoku ay awan dán mauwaw maski nikan. ");
INSERT INTO prfNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Peru kagiyán ku dikomoy, a minetaák moy dán peru awan kam padi sumampalataya dikoku. ");
INSERT INTO prfNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Umadeni en atanan a iyatád nen Ama ku dikoku, sakay awan ku palakadán maski nikan en deyaman a umadeni dikoku. ");
INSERT INTO prfNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Dummibábbiyák a gubwat dilanget, bakán a para gamitán ku en kagustuwan ku, nan en kagustuwan nen nangutus dikoku. ");
INSERT INTO prfNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Iddi en kagustuwan na: awan ku dapat a pabayan a mepahamak maski essa ten inyatád na hidi dikoku, nan biyagán ku siya a ruway ten katapusan a aldew. ");
INSERT INTO prfNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Gapu iddi en kagustuwan nen Ama ku: en atanan nen tumenggi sakay sumampalataya ten Anak ay magkahud ti biyag a awan ti katapusan. Sakay biyagán ku hidi a ruway ten katapusan a aldew. ");
INSERT INTO prfNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Pákkasanig nen Judio hidi, ay namágganasasan hidi gapu ten kinagi na a, “Sikán en tinapay a dummibábbi a gubwat dilanget.” ");
INSERT INTO prfNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Kinagi di, “Awan beman siya ay ti Jesus a anak ni Jose? Tukoy tam en dáddikál na hidi, konya na a makagi a gubwat siya dilanget? ");
INSERT INTO prfNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Kinagi ni Jesus dikodi, “Bakin mamágganasasan kam? ");
INSERT INTO prfNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Awan ti makaadeni dikoku ni awan siya inyadeni nen Ama a nangutus dikoku. Sakay en umadeni dikoku ay biyagán ku a ruway ten katapusan a aldew. ");
INSERT INTO prfNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Nesulat ten libru nen propeta hidi a, ‘Sakay tolduwan hidi a atanan nen Diyos.’ Balang mágsanig ten Ama ku sakay natolduwan ay umadeni dikoku. ");
INSERT INTO prfNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Bakán a gustu naid a kagiyán ay tehud dán a naketa ten Ama; en naggubwat la ten Diyos en naketa ten Ama. ");
INSERT INTO prfNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Tandaan moy kagiyán kuwidi dikomoy: en sumampalataya dikoku ay magkahud ti biyag a awan ti katapusan. ");
INSERT INTO prfNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Sikán en tinapay a makapangatád ti biyag. ");
INSERT INTO prfNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Kinuman en ninunu moy hidi ti manna ten kaparangan, sakay nágkatay labi hidi. ");
INSERT INTO prfNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Peru ni deyaman en kuman ten tinapay a dummibábbi a gubwat dilanget ay awan dán matay. ");
INSERT INTO prfNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Sikán en tinapay a makapangatád ti biyag a dummibábbi a gubwat dilanget. Mabiyag a awan ti katapusan en deyaman a kuman ti iyád. Sakay en iyatád ku a tinapay ay en bággi ku tánni mabiyag en atanan a tolay.” ");
INSERT INTO prfNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Pákkasanig nen Judio hidi ay namagtalu-talu hidi. “Konya kan a meatád ni tolayid a iyán i bággi na en para kanán tam?” ");
INSERT INTO prfNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Kaya kinagi ni Jesus dikodi, “Kagiyán ku dikomoy tatarudanid, mentras a awan moy kanán en bággi nen Anak nen Tolay sakay inumán en digi na ay awan kam magkahud ti biyag. ");
INSERT INTO prfNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Peru en kuman ten bággi ku sakay uminom ten digi ku ay magkahud ti biyag a awan ti katapusan, sakay ruway ku siya a biyagán ten katapusan a aldew. ");
INSERT INTO prfNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Gapu en bággi ku ay siya en tatarudan a pagkain, sakay en digi ku ay siya en tatarudan a dinom. ");
INSERT INTO prfNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Kaya ni deyaman en mangkan ten bággi ku sakay uminom ten digi ku ay manatili dikoku sakay manatiliyák bi dikona. ");
INSERT INTO prfNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","En biyag a Ama en nangutus dikoku, sakay mabiyagák gapu dikona. Kona labi hud, en deyaman a mangkan dikoku ay mabiyag a gapu dikoku. ");
INSERT INTO prfNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Iyád en tinapay a dummibábbi a gubwat dilanget. Awan iyád kaparehu nen kinan nen ninunu moy hidi ten kaparangan; nágkatay labi hidi maski ni kinuman hidi ti iyud. En kuman ti iyád a tinapay ay mabiyag a awan ti katapusan.” ");
INSERT INTO prfNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Iyád en kinagi ni Jesus ten sinagoga dikona a nagtoldu siya ti Capernaum. ");
INSERT INTO prfNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Dikona nasanig nen disepulus na hidi en págtoldu na ay kinagi nen kakpalan dikodi, “Madággi iyád a págtoldu na, deya makaintendiyid haán?” ");
INSERT INTO prfNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Tukoy ni Jesus a mamágganasasan en disepulus na hidi tungkul ten intoldu na kaya kinagi na dikodi, “Gapu beman ti iyád ay lakadanák moy dán? ");
INSERT INTO prfNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Iyud pa beman wád ni ketan moy dán en Anak nen Tolay a dumisunu a tamu ten dati na a páppágyanan? ");
INSERT INTO prfNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","En Ispiritu en mangatád ti biyag; awan iyád magamet nen tolay. En upos hidi a kinagi ku dikomoy ay ispiritu a mangatád ti biyag. ");
INSERT INTO prfNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Peru tehud a sangan dikomoy a awan maniwala dikoku.” (Nakagi iyád ni Jesus gapu sapul pa ten sapul ay tukoy na dán en awan hidi maniwala dikona, sakay en mángtokyon dikona.) ");
INSERT INTO prfNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Sakay kinagi na pa, “Iyád en dahilan kaya ku a kinagi dikomoy a awan ti makaadeni dikoku ni awan gustuwán nen Ama.” ");
INSERT INTO prfNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Sapul haud ay makpal dán en ummadág ten disepulus na hidi sakay awan dán hidi nákkuyug dikona a ruway. ");
INSERT INTO prfNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Kaya kinagi ni Jesus ten sapulu ay ti duwwa, “Ánya, lakadanák moy beman bi?” ");
INSERT INTO prfNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Kinagi ni Simon Pedro, “Panginoon, hádya pa beman angayan miyid? Ked dán dikomu en upos hidi a makapangatád ti biyag a awan ti katapusan. ");
INSERT INTO prfNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Maniwala kami, sakay siguradu kami a siko en Banal a gubwat ten Diyos.” ");
INSERT INTO prfNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Tummábbig ti Jesus, “Awan beman pinili takam a sapulu ay ti duwwa? Peru en essa dikomoy ay diyablo!” ");
INSERT INTO prfNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","En kinagi ni Jesus ay tungkul kánni Judas a anak ni Simon Iscariote. Ti Judas ay essa ten sapulu ay ti duwwa sakay siya en mángtokyon kánni Jesus. ");
INSERT INTO prfNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Káttapos iyud ay linebut ni Jesus ti Galilea. Awan siya ummangay ti Judea, gapu gustu siya a bunuwán nen pinunu hidi nen Judio hidi haud. ");
INSERT INTO prfNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Adeni dán en Piyesta nen Tolda hidi, a essa a ten piyesta nen Judio hidi. ");
INSERT INTO prfNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Kaya kinagi nen kákkapatkaka na hidi dikona, “Bakin awan ka pa maglakad sakay angay ti Judea, tánni ketan nen disepulus mu hidi en gággamitán mu. ");
INSERT INTO prfNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Awan ti tolay a mángtagu ten gamet na ni gustu na a metanyag. Ta gággamitán mu labi hidi iyán a bagay, ay ipeta mu dán ti munduwiday.” ");
INSERT INTO prfNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","(Maski en kákkapatkaka hidi ni Jesus ay awan summampalataya dikona.) ");
INSERT INTO prfNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Kinagi ni Jesus dikodi, “Awan ku palla odas, sikam ay maari maski ni ánya odas. ");
INSERT INTO prfNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Awan maiyamut en tolay hidi dikomoy. Peru sikán ay maiyamut hidi gapu patunayan ku a madukás en gamet di hidi. ");
INSERT INTO prfNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Sikam umangay ten piyesta. Awanák umangay haud gapu awan palla tama a odas para dikoku.” ");
INSERT INTO prfNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Pákkakagi na ti iyud ay nawarak dán siya ti Galilea. ");
INSERT INTO prfNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Ten kállakad nen kákkapatkaka na hidi a tamu ten Piyesta ay ummangay labi haud ti Jesus, peru patagu la. ");
INSERT INTO prfNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Inaryok siya haud nen Judio hidi, kinagi di, “Hádya dán wád siya?” ");
INSERT INTO prfNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Mamágganasasan en kakpalan. Kagi nen agum ay, “Mabait iyán a tolay,” kagi bi nen agum ay, “Awan! Itawtaw na la en tolay hidi!” ");
INSERT INTO prfNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Peru awan di pasanig a magupos tungkul dikona ta manteng hidi ten pinunu hidi nen Judio hidi. ");
INSERT INTO prfNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Ten kalahatiyan nen Piyesta ay ummangay ti Jesus ten Templo sakay tulos a nagtoldu. ");
INSERT INTO prfNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Nagtaka en pinunu hidi nen Judio hidi sakay kinagi di, “Hádya wád a nangalap ti karunungan i tolayid a iyán, awan bi siya nagiskuwela?” ");
INSERT INTO prfNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Kaya kinagi ni Jesus dikodi, “Bakán ku a kao en itoldu ku, nan kao nen nangutus dikoku. ");
INSERT INTO prfNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Kaya ni deyaman en masor a mangtupad ten kaluuban nen Diyos, ay matukuyan na ni en itoldu ku ay gubwat ten Diyos oni gubwat la dikoku. ");
INSERT INTO prfNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","En magtoldu ten gubwat la ten sadili na ay maghangad ti sadili a karangalan. Peru en tolay a maghangad a maparangalan en nangutus dikona ay tolay a matapat sakay awan magbulibuli. ");
INSERT INTO prfNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Awan beman neatád dán dikomoy ni Moises en Kautusan? Peru maski ni essa dikomoy ay awan ti nangsunud, sakay gustuwák moy pa a bunuwán” ");
INSERT INTO prfNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Kinagi nen tolay hidi, “Talaga a tehud ka a dimonyo!” “Deya beman masorid a mangbunu dikomu?” ");
INSERT INTO prfNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Kinagi ni Jesus dikodi, “Essa palla a bagay en ginamet ku ay magtaka kamon. ");
INSERT INTO prfNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Inyatád dikomoy ni Moises en utus tungkul ten págturi (maski ni awan iyád naggubwat kánni Moises nan ten ninunu moy hidi). Sakay maski ni Aldew nen Káimang ay turiyán moy en kalállakiyan moy hidi. ");
INSERT INTO prfNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Ni turiyán moy en essa a lállaki ten Aldew nen Káimang, tánni masunud moy la en utus ni Moises, bakin a maiyamut kam dikoku gapu ten págpapiyya ku ten Aldew nen Káimang? ");
INSERT INTO prfNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Maghatul kam ti tama, bakán a ten pamamag-itan la nen ketan moy.” ");
INSERT INTO prfNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Kinagi nen agum a tolay a taga Jerusalem, “Awan beman iyán en tolay a gustu di a bunuwán? ");
INSERT INTO prfNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Ked bela siya a hayagan a mangaral, awan bela hidi ti makagi dikona! Bakay bi ni natukuyan nen pinunu hidi a siya dán en Cristo?” ");
INSERT INTO prfNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Peru, kagi nen agum, “Peru káddemát nen Cristo ay awan ti makatukoy ni hádya naggubwatan naid, peru tukoy tam a atanan ni hádya gubwat ni tolayid a iyán!” ");
INSERT INTO prfNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Mentras a magtoldu ti Jesus ten Templo ay kinagi na, “Matenggiyák moy beman a talaga? Tukoy moy beman ni hádya i naggubwatan kuwid? Awanák ummangay háddi a para ten sadili ku la a kagustuwan. Karapat-dapat a pagtiwalaan en nangutus dikoku awan moy siya matenggi. ");
INSERT INTO prfNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Peru sikán ay tukoy ku siya, gapu gubwaták dikona sakay siya en nangutus dikoku háddi.” ");
INSERT INTO prfNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Laan dán siya a dikáppán nen sangan a ked haud, peru awan ti nangahas gapu awan na palla odas. ");
INSERT INTO prfNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Kaya makpal a tolay en naniwala dikona. Kinagi di, “Ánya wád káangay háddi nen Cristo makagamet wád siya ti mas higit ti ginággamet ni tolayid a iyán?” ");
INSERT INTO prfNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Nasanig nen Pariseo hidi en pamággurunan nen tolay hidi tungkul kánni Jesus, kaya nangutus hidi sakay en pinunu hidi nen padi hidi ten sangan a guwardiya ten Templo tánni dikáppán di ti Jesus. ");
INSERT INTO prfNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Kaya kinagi ni Jesus, “Badit dálla a panahun pákpággagum kuwid dikomoy ay magsoliyák dán ten nangutus dikoku. ");
INSERT INTO prfNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Aryokánnák moy, peru awanák moy metan, gapu awan kam makaangay ten angayan ku.” ");
INSERT INTO prfNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Namágguron en Judio hidi, “Hádya wád bi angayan ni tolayid a iyán a awan tamon keketan? Angay wád siya ten Judio hidi a neangay ten banuwan a sakup nen Griego hidi tánni magtoldu dikodi?” ");
INSERT INTO prfNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Ánya wád i gustuwid a kagiyán nen kinagi na a, ‘Aryokánnák moy peru awanák moy keketan,’ sakay ‘Awan kam makaangay ten angayan ku?’ ” ");
INSERT INTO prfNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Ten katapusan a pinakamahalaga a aldew nen piyesta ay tummaknág ti Jesus sakay kinagi na ti mabegsák, “Ni deyaman en mauwaw ay umadeni dikoku.” ");
INSERT INTO prfNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","sakay ni deyaman en maniwala dikoku ay uminom. Gapu kinagi nen kasulatan, ‘Magbulos en dinom a makapangatád ti biyag ten pusu nen balang maniwala dikoku.’ ” ");
INSERT INTO prfNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","En gustu a kagiyán ni Jesus ay en Ispiritu a tanggapán nen sumampalataya hidi dikona. Gapu ti panahunid a iyud ay awan palla nepagkaluub en Ispiritu, gapu awan palla nabiyag a ruway ti Jesus sakay naluwalhati. ");
INSERT INTO prfNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Pákkasanig nen tolay hidi dikona ay kinagi di, “Talaga a siya dán en propeta a áorayán tam.” ");
INSERT INTO prfNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Tehud bi a iba a nagkagi a, “Siya dán en Cristo.” Peru en tábbig nen agum ay, “Maari beman a maggubwat ti Galilea en Cristo? ");
INSERT INTO prfNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Awan beman kinagi nen kasulatan a en paggubwatan nen Cristo ay en lahi ni David, sakay meenak ti Bethlehem a banuwan ni David?” ");
INSERT INTO prfNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Kaya awan magkaparehu en isip nen tolay hidi tungkul dikona. ");
INSERT INTO prfNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","En agum ay gustu di siya a dikáppán, peru awan ti nangahas a mangdikáp dikona. ");
INSERT INTO prfNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Dikona a magsoli en guwardiya hidi nen Templo, ay tinanung hidi nen pinunu hidi nen padi hidi sakay nen Pariseo hidi, “Bakin awan moy siya inyangay háddi? ");
INSERT INTO prfNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Kinagi nen nagbantay hidi, “Awan kami palla ti nasanig a kona ten pággupos na.” ");
INSERT INTO prfNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","“Pati beman sikam ay nákkaloku na bi?” kagi nen Pariseo hidi. ");
INSERT INTO prfNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Tehud beman a pinunu oni Pariseo a maniwala dikona? ");
INSERT INTO prfNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","“Awan! En tolay la hidi a awan ti pangmalayan tungkul ten Kautusan, kaya sinumpa hidi!” ");
INSERT INTO prfNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Ked bi haud ti Nicodemo, en ummangay nákpágguron kánni Jesus ten gibi. Kinagi na dikodi, ");
INSERT INTO prfNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Awan beman labag ten Kautusan a hatulan en essa a tolay ni awan palla sinanig sakay pinagadalan ni ánya en ginamet na?” ");
INSERT INTO prfNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Tummábbig hidi, “Bakin taga-Galilea ka dán beman bi? Pagadalan mu en Kasulatan, ketan mu iyán a awan ti propeta a maggubwat ti Galilea.” ");
INSERT INTO prfNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Káttapos iyud ay ummuli dán en balang essa. ");
INSERT INTO prfNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Nadid, ti Jesus ay ummangay ten Bukid nen Olibo hidi. ");
INSERT INTO prfNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Ten dimadimang ay nagsoli siya ten Templo. Ummadeni dikona en tolay hidi sakay nákpággetnud siya a nagtoldu dikodi. ");
INSERT INTO prfNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Dummemát en tagapagtoldu hidi nen Kautusan sakay en Pariseo hidi, tawid di en a essa bábbi a nadikáp di ti pángngalunya. Pinágtaknág di siya ten atubengán nen kakpalan, ");
INSERT INTO prfNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","sakay kinagi di kánni Jesus, “Maistu, naaktu mi i bábbiyid a iddi a nangalunya. ");
INSERT INTO prfNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Ayun ten Kautusan ni Moises, ay dapat a batuwán a hanggan matay en kona hidi haán a tolay. Ánya makagi muwid?” ");
INSERT INTO prfNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Kinagi di la iyud dikona para pangsubukan di, tánni tehud hidi a mebintang a kontra dikona. Peru dummukug la ti Jesus sakay nagsulat siya ten luta ten pamamag-itan nen toldu na. ");
INSERT INTO prfNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Awan di siya imangan a táttanungán, kaya tinumaknág siya sakay kinagi na, “Sigi, ni deya dikomoy en awan ti kasalanan ay siya en mágdipalongu a mangbatu dikona.” ");
INSERT INTO prfNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Sakay ruway siya a ummetnud sakay nagsulat siya ten luta. ");
INSERT INTO prfNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Pákkasanig di ti iyud ay balang essa ay lummakad, sapul ten katandaan. Linakadan di en bábbi a mágtaknág ten atubengán ni Jesus. ");
INSERT INTO prfNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Tummaknág ti Jesus sakay tinanung na en bábbi, “Hádya dán en mangparusa hidi dikomu?” ");
INSERT INTO prfNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","“Awan dán ben, Panginoon,” tábbig nen bábbi. Kinagi ni Jesus: “Maski sikán ay awan taka bi parusaan, umuli ka dán sakay dyan ka dán magkasala.” ");
INSERT INTO prfNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Nadid, ruway a nagtoldu ti Jesus ten Pariseo hidi. Kinagi na, “Sikán en demlag ni munduwiday. En sumunud dikoku ay magkahud ti demlag ten biyag na sakay awan dán maglakad ten diklám.” ");
INSERT INTO prfNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Kinagi nen Pariseo hidi, “Siko labiyen a mismu i mangpatunayid ti sadili muwen; awan ti kuwenta i konaid haán a págpatunay.” ");
INSERT INTO prfNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Tummábbig ti Jesus, “Maski sikán la mangpatunayid ti sadili kuwidi ay tatarudan i kákkagiyán kuwidi, gapu tukoy ku ni hádyaák a naggubwat sakay ni hádya angayan kuwid. Peru sikam ay awan moy tukoy ni hádya naggubwatan kuwid sakay angayan kuwid. ");
INSERT INTO prfNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Maghatul kam ayun ten pangileng nen tolay, peru sikán ay awanák maghatul maski kándeya. ");
INSERT INTO prfNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Sakay ni maghatulák man ay tama en pághatul ku. Gapu bakán la a sikán en maghatul nan kaguman ku en Ama a nangutus dikoku. ");
INSERT INTO prfNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Nakasulat ten Kautusan moy, a dapat a paniwalaan en págpatunay nen duwwa a tistigu. ");
INSERT INTO prfNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Mapatunayan ku a mismu i sadili kuwidi, sakay magpatunay bi en Ama a nangutus dikoku.” ");
INSERT INTO prfNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Tinanung di siya, “Hádya la ama muwid?” Tummábbig ti Jesus, “Awanák moy matenggi, sakay awan moy bi matenggi en Ama ku. Ni matenggiyák moy ay matenggi moy bi en Ama ku.” ");
INSERT INTO prfNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Kinagi iyád ni Jesus ten Templo ten danág nen págdáttonan ti alay. Peru awan ti nangahas a mangdikáp dikona, gapu awan na palla odas. ");
INSERT INTO prfNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Ruway a kinagi ni Jesus dikodi, “Adeniyák dán a lumakad sakay aryokánnák moy; peru awan kam makaangay ten angayan ku. Mágkatay kam a awan palla mapatawad en kasalanan moy hidi.” ");
INSERT INTO prfNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Namágguron en Judio hidi, “Magpakamatay bewád bakin a kinagi na a, ‘Awan kam makaangay ten angayan ku?’ ");
INSERT INTO prfNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Kinagi ni Jesus dikodi, “Sikam ay taga-dibábbi, sikán ay taga-disunu. Sikam ay taga-munduwiday peru sikán ay bakán a taga-mundu. ");
INSERT INTO prfNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Kaya tatarudan en kinagi ku dikomoy a mágkatay kam a awan palla napatawad en kasalanan moy hidi. Ni awan kam maniwala a, ‘Sikán ay Sikán dán,’ ay mágkatay kam a awan palla napatawad en kasalanan moy hidi.” ");
INSERT INTO prfNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","“Deya ka beman a talaga?” kagi di. Tummábbig ti Jesus, nalay ku dán a kinagi dikomoy ni deyaák. Sikán en kinagi ku dán dikomoy a sapul pa ten dipalongu. ");
INSERT INTO prfNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Makpalák palla a makagi sakay mehatul kontra dikomoy. Peru tatarudan en kinagi nen nangutus dikoku, sakay en nasanig ku dikona ay ipahayag ku ti munduwiday.” ");
INSERT INTO prfNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Awan di naintendiyan a en Ama i gustu naid a kagiyán. ");
INSERT INTO prfNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Kaya kinagi ni Jesus, “Kapag ni nelangkaw moy dán a Anak nen Tolay, ay matukuyan moy a, ‘Sikán ay sikán dán ngani.’ Awanák ti gamitán a gubwat la ten sadili ku a kapangyariyan, nan en pekagi la nen Ama en kagiyán ku. ");
INSERT INTO prfNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Sakay kaguman ku en nangutus dikoku, awanák na páppabayan, gapu pirmi ku a gággamitán en makasaya dikona.” ");
INSERT INTO prfNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Kakpalan ten nakasanig hidi ten kinagi ni Jesus ay summampalataya dikona. ");
INSERT INTO prfNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Kinagi ni Jesus ten Judio hidi a maniwala dikona, “Ni tulos-tulos kam a sumunud ten toldu ku, ay sikam en tatarudan a disepulus ku; ");
INSERT INTO prfNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","matukuyan moy en katutuhanan, sakay en katutuhanan en mangpalaya dikomoy.” ");
INSERT INTO prfNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Tummábbig hidi dikona, “Gubwat kami ten lahi ni Abraham sakay maski nikan ay awan kami naalipin nen deyaman? Konya mu a makagi a palayaán kami?” ");
INSERT INTO prfNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Tummábbig ti Jesus, “Kagiyán ku dikomoy; a en mabiyag ti kasalanan ay alipin ni kasalanan. ");
INSERT INTO prfNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","En alipin ay awan kabilang ten pamilya a habang panahun, peru en anak ay kabilang a awan ti katapusan. ");
INSERT INTO prfNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Mara ni pinalaya kamon nen Anak, ay talaga ngani a malaya kamon. ");
INSERT INTO prfNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Tukoy ku a lahi kam ni Abraham, peru gustuwák moy a bunuwán gapu awan moy matanggap en itoldu ku dikomoy. ");
INSERT INTO prfNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","En kákkagiyán ku dikomoy ay en neta ku ten Ama ku; peru sikam en gággamitán moy ay en nasanig moy ten ama moy.” ");
INSERT INTO prfNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","“Ti Abraham i Ama miyid,” kagi nen Judio hidi. Kinagi ni Jesus dikodi, “Ni talaga a lahi kam ni Abraham, ay di arigán moy nakuwan en ginamet na. ");
INSERT INTO prfNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Kinagi ku la en katutuhanan a nasanig ku ten Diyos peru gustuwák moy dán a bunuwán. Bakán a kona haán en ginamet ni Abraham. ");
INSERT INTO prfNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","En gággamitán moy ay kona ten ginamet nen ama moy.” Tummábbig hidi, “Bakán kami a mungaw. Essa la Ama miyid, en Diyos.” ");
INSERT INTO prfNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Kinagi ni Jesus dikodi, “Ni talaga a en Diyos Ama moyid, mahalánnák moy nakuwan gapu naggubwaták ten Diyos. Awanák ummangay háddi ten sadili ku la a kagustuwan, nan inutusanák na. ");
INSERT INTO prfNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Bakin awan moy maintendiyan i kákkagiyán kuwidi? Gapu awan moy gustu a tanggapán en itáttoldu ku. ");
INSERT INTO prfNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","En diyablo i ama moyid! Sakay en kagustuwan na i gustu moyid a gamitán. Sapul pa ten sapul ay mágbabonu dán siya. Awan ti ketan dikona a katutuhanan, gapu sasala na katutuhanan. Ugali na a talaga a mágbulibuliyán gapu mabuli siya sakay ama siya ni kakabuliyan. ");
INSERT INTO prfNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Awan moy gustu a maniwala dikoku gapu katutuhanan en kákkagiyán ku dikomoy. ");
INSERT INTO prfNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Deya dikomoy i makapagkagiyid a tehudák a kasalanan? Nadid, ni katutuhanan en kinákkagi ku, ay bakin awanák moy paniwalaan. ");
INSERT INTO prfNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","En tolay a maka-diyos ay mágsanig ten upos nen Diyos. Peru sikam ay awan moy gustu a mágsanig dikoku gapu awan kam maka-diyos.” ");
INSERT INTO prfNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Ten pákkasanig nen Judio hidi, ay kinagi di, “Awan beman tama la en kinagi mi a siko ay Samaritano sakay sinaniban ni dimonyo?” ");
INSERT INTO prfNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Kinagi ni Jesus, “Awanák sinaniban ni dimonyo. Pinarangalan ku en Ama ku, peru linapastanganák moy. ");
INSERT INTO prfNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Awanák maghangad a parangalanák, peru tehud a essa a magsikap a maparangalanák, sakay siya en makapanghatul. ");
INSERT INTO prfNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Tandaan moy kagiyán kuwidi: en sumunud ten toldu ku ay awan dán matay maski nikan.” ");
INSERT INTO prfNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Kinagi nen Judio hidi, “Nadid mi a matiyak a talaga sinaniban ka ni dimonyo. Natay ngani dán ti Abraham sakay ten propeta hidi, kagiyán mu pa a awan ti matay ten deyaman a sumunud ten toldu mu. ");
INSERT INTO prfNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Kinagi di, “Mas mataas ka pa beman nan en ama mi a ti Abraham? Natay siya kumona bi ten propeta hidi. Ánya akala muwid ti sadili muwen?” ");
INSERT INTO prfNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Kinagi ni Jesus dikodi, “Ni sikán la en mangparangal ti sadili kuwidi ay awan ti kuwenta. En Ama ku en mangparangal dikoku sakay kákkagiyán moy a siya i Diyos moyid. ");
INSERT INTO prfNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Awan moy siya matenggi, peru matenggi ku siya. Ni kagiyán ku a awan ku siya matenggi ay magin mabuliyák a kona dikomoy. Peru matenggi ku siya sakay sunudán ku en kákkagiyán na. ");
INSERT INTO prfNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Nasaya en ama moy a ti Abraham ten dikona maakala na a ketan na en aldew a demát ku, netan na ngani iyud sakay nasaya siya.” ");
INSERT INTO prfNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Gapu ti iyud ay kinagi nen Judio hidi dikona, “Samantala awan ka palla ti limmapulu a taon, konya mu a makagi a netan mu dán ti Abraham?” ");
INSERT INTO prfNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Kinagi ni Jesus dikodi, “Kagiyán ku dikomoy i tatarudanid: bagu pa neenak ti Abraham ay, ‘Sikán ay ked dán.’ ” ");
INSERT INTO prfNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Pákkasanig nen Judio hidi ti iyud, ay nangkopkop hidi ti batu tánni batuwán di siya, peru tummagu ti Jesus sakay lummuwas ten Templo. ");
INSERT INTO prfNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Nadid, ten paglakad ni Jesus, ay netan na en essa a lállaki a neenak a burák. ");
INSERT INTO prfNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Kinagi nen disepulus na hidi, “Maistu, deya i tehudid a kasalanan ta mineenak a burák i lállakiyid a iyán, siya oni en dáddikál na?” ");
INSERT INTO prfNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Kinagi ni Jesus dikodi, “Awan ti kasalanan i lállakiyid a iyán oni en dáddikál na hidi. Nan nangyari iyán tánni mepeta en kapangyariyan nen Diyos. ");
INSERT INTO prfNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Kailangan a tupadán tam en ipagamet hidi nen nangutus dikoku mentras tehud palla a aldew. Ni dumemát dán en gibi ay awan dán ti makapanggamet. ");
INSERT INTO prfNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Mentras kedák palla ti munduwiday, ay sikán en demlag ni munduwiday.” ");
INSERT INTO prfNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Pákkakagi ni Jesus ti iyud, ay lummoktab siya ten luta sakay ginamet na a lusak, sakay impahid na iyud ten mata nen burák. ");
INSERT INTO prfNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Sakay kinagi na ten burák, “Kammudán magudemos ten dinom a Siloe.” (En gustu na a kagiyán ay inutusan.) Kona ngani haud en ginamet nen burák sakay ten kássoli na ay naketa dán siya. ");
INSERT INTO prfNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Kinagi nen kadatigan na hidi sakay nen naketa hidi dikona, dikona a mágpalimus palla siya, “Awan beman iyán en lállaki a dati a mágpalimus?” ");
INSERT INTO prfNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","“Iyán dán ngani” kagi nen agum, “Awan! Karupa na la,” kagi dámman nen agum. Kaya nagupos en lállaki, “Sikán dán iyád.” ");
INSERT INTO prfNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Kinagi di dikona, “Konya ka a naketa?” ");
INSERT INTO prfNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Tummábbig en lállaki, “En lállaki ben a dáddulawán di a Jesus ay naggamet ti lusak a nahaluwan ten loktab na sakay impahid na ti mata kuwidi. Sakay kinagi na dikoku a, ‘Umangay ka ti Siloe a magudemos.’ Kaya ummangayák bi haud sakay nagudemos, hudák dán a naketa,” ");
INSERT INTO prfNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","“Hádya dán siya?” kagi di dikona, “Awan ku tukoy.” Tábbig na dikodi. ");
INSERT INTO prfNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Inyangay di ten Pariseo hidi en dati a burák. ");
INSERT INTO prfNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Aldew iyud nen Káimang dikona gamitán ni Jesus en lusak sakay nanggamot na ten burák. ");
INSERT INTO prfNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Tinanung a ruway nen Pariseo hidi ni konya siya a naketa. Kinagi na dikodi, “Pinahidan na ti lusak i mata kuwidi, sakay pinagudemusák na, sakay hudák dán a naketa.” ");
INSERT INTO prfNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Kinagi nen agum a Pariseo, “Bakán a gubwat ten Diyos i tolayid a iyán, gapu awan na impangilin en Aldew nen Káimang.” Peru kinagi bi nen agum, “Konya a makagamet ti kona haán a himala i essaid a makasalanan?” Sakay awan hidi namagkaessa. ");
INSERT INTO prfNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Kinagi di dámman ten lállaki a burák, “Siko, ánya palagay muwid dikona, gapu pinaketa na i mata muwen, ánya makagi muwid?” “Essa siya a propeta.” Tábbig nen lállaki. ");
INSERT INTO prfNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Awan maniwala en Judio hidi ni tatarudan a burák siya, kaya pinauwet di en dáddikál na hidi. ");
INSERT INTO prfNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Sakay kinagi di ten dáddikál na hidi, “Tarud beman a anak moy siya? Tarud beman a neenak siya a burák? Bakin naketa dán siya?” ");
INSERT INTO prfNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Kinagi nen dáddikál na hidi, “Tukoy mi a anak mi siya, sakay neenak siya a burák. ");
INSERT INTO prfNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Peru awan mi tukoy ni konya naketa naid, sakay awan mi bi tukoy ni deya nangpapiyyaid dikona. Siya dálla tanungán moyid, te idad dán bi siya sakay mekagi na dán en tungkul ten sadili na. ");
INSERT INTO prfNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Kona la haád en kinagi nen dáddikál na hidi gapu ten ánteng di ten Judio hidi. Gapu napagkasunduwan nen Judio hidi a itiwalag di ten sinagoga en balang mángpahayag a ti Jesus en Cristo. ");
INSERT INTO prfNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Iyád en dahilan ni bakin kinagi nen dáddikál na hidi a, “Siya ay tehud dán a sapat idad; siya dálla i tanungán moyid.” ");
INSERT INTO prfNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Kaya pinadulaw dámman nen Judio hidi en burák sakay kinagi di dikona, “Ten ngaran nen Diyos ay magkagi ka ti tatarudan tukoy mi a makasalanan i tolayid a iyud.” ");
INSERT INTO prfNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Tumábbig siya, “Para dikoku makasalanan man siya oni awan. Basta tukoy kuwid ay datiyák a burák peru nadid ay maketaák dán.” ");
INSERT INTO prfNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","“Ánya ginamet naid dikomu? Konya na a pinaketa i mata muwen?” Tanung di dikona. ");
INSERT INTO prfNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Tummábbig siya dikodi, “Nakagi ku dán ben dikomoy, peru awanák moy gustu a paniwalaan. Bakin gustu moy dámman a masanig a ruway? Gustu moy beman bi a magin disepulus na?” ");
INSERT INTO prfNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Pákkasanig nen Judio hidi, ay pinagsarantaan di siya, “Siko disepulus naid. Peru sikami, ay disepulus ni Moises. ");
INSERT INTO prfNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","“Tukoy mi a nákpágguron en Diyos kánni Moises. Peru i lállakiyid a iyán, ay awan mi tukoy ni hádya naggubwatan naid.” ");
INSERT INTO prfNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Kinagi nen lállaki, “Iyud ngani makatakaid! Awan moy tukoy ni hádya nagubwatan naid, peru pinagpiyya na mata kuwidi.” ");
INSERT INTO prfNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Tukoy tam a awan sanigán nen Diyos en makasalanan. Peru sanigán na en tunay a sumamba hidi dikona sakay sumunud ten kaluuban na. ");
INSERT INTO prfNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Sapul pa ten sapul awanák palla nakasanig ti nakapagpapiyya ti neenak a dati dán a burák. ");
INSERT INTO prfNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Talaga a awan ti magamet i lállakiyid a iyud ni awan naggubwat ten Diyos!” ");
INSERT INTO prfNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Kinagi di dikona, “Neenak ka a makasalanan, gustu muwid a kagiyán ay siko pa i mangtolduwid dikomi?” Sakay sapul haud ay intiwalag di dán siya. ");
INSERT INTO prfNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Nabareta ni Jesus a intiwalag nen Pariseo hidi en lállaki a pinagpiyya na. Kaya kinagi na ten lállaki dikona ketan na, “Sumampalataya ka beman ten Anak nen tolay?” ");
INSERT INTO prfNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Tummábbig en lállaki, “Deya beman siya Maistu? Kagiyán mu dikoku tánni maniwalaák dikona.” ");
INSERT INTO prfNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","“Netan mu dán siya, siya i kauron muwidi nadid,” kagi ni Jesus. ");
INSERT INTO prfNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","“Sumampalatayaák dikomu Panginoon!” kagi nen lállaki. Sakay sinamba na ti Jesus. ");
INSERT INTO prfNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Sakay kinagi pa ni Jesus, “Kayaák a ummangay ti munduwiday, ay tánni maghatul ten tolay. Tánni maketa en burák hidi sakay maburák en maketa hidi.” ");
INSERT INTO prfNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Nasanig iyud nen agum a Pariseo a adeni dikona kaya tinanung di siya, “Ánya beman gustu muwid a kagiyán burák kami?” ");
INSERT INTO prfNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Kinagi ni Jesus, “Ni burák kam ay awan kam nakuwan ti kasalanan. Peru kinagi moy a awan kam burák, en kasalanan ay manatili dikomoy.” ");
INSERT INTO prfNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Kinagi ni Jesus, “Tandaan moy iddi, en awan maglakad ten pintuwan nen kulungan nen tupa hidi, nan umunek siya ten awan páglakadan, ay mágtakaw sakay tulisan. ");
INSERT INTO prfNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Peru en maglakad ten pintuwan na, ay siya en tunay a pastol. ");
INSERT INTO prfNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Pasáddáppán siya nen guwardiya, sakay sanigán nen tupa hidi en boses na. Dulawán na ten ngara-ngaran di en balang essa ten tupa hidi, sakay iluwas na hidi ten kulungan. ");
INSERT INTO prfNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Ni meluwas na dán hidi, ay dumipalongu siya sakay mahusay hidi a umunonud dikona, gapu matenggi di en boses na. ");
INSERT INTO prfNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Awan hidi sumunud ti iba, nan guminan pa hidi a paadeyu, gapu awan di matenggi en boses nen iba.” ");
INSERT INTO prfNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Kinagi ni Jesus iyád a talinhaga, peru awan di naintendiyan en gustu na a kagiyán. ");
INSERT INTO prfNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Kaya ruway a kinagi ni Jesus, “Kagiyán ku dikomoy iddi: sikán en pintuwan a sássáddáppan nen tupa hidi. ");
INSERT INTO prfNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","En nágdipalongu dikoku ay mágtakaw sakay tulisan, peru awan hidi sinanig nen tupa hidi. ");
INSERT INTO prfNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Sikán en tunay a pintuwan. En deyaman a sumáddáp ten pamamag-itan ku ay maligtas. Somdáp siya sakay lumuwas sakay maketa ti kabiyagan na. ");
INSERT INTO prfNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Dumemát en mágtakaw tánni magtakaw sakay mamunu sakay mangperhisyu. Peru sikán, ummangayák háddi tánni magkahud ti biyag en tupa hidi, biyag a masagana sakay ganap. ");
INSERT INTO prfNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Sikán en mabait a pastol. En mabait a pastol ay iyalay na en biyag na para ten tupa na hidi. ");
INSERT INTO prfNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Peru en áupaan ay guminan ni maketa ti sumunggab a matapang a hayup ti talon. Ginanan na hidi palibhasa awan siya pastol sakay awan na kao en tupa hidi. Kaya sunggaban hidi ni matapang a hayup ti talon sakay mariwak-riwak hidi. ");
INSERT INTO prfNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Ginanan na la hidi palibhasa a naupaan la siya sakay awan ti malasakit ten tupa hidi. ");
INSERT INTO prfNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","“Sikán en mabait a pastol. Matenggi ku en sadili ku hidi a tupa sakay matenggiyák di bi. ");
INSERT INTO prfNT_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Kona ten pákkatenggi ku ten Ama, iyatád ku en buu ku a biyag para ten tupa ku hidi. ");
INSERT INTO prfNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Tehudák a iba pa a tupa a awan palla ti kulunganidi. Kailangan a mesáddáp ku bi hidi sakay sanigán di en boses ku. Ni magkakonahud ay mapisan ti essa en tupa hidi sakay essa la en pastol.” ");
INSERT INTO prfNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Kaya tatarudan a mahalák nen Ama, gapu inyalay ku en biyag ku, tánni mabiyagák labi a ruway. ");
INSERT INTO prfNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Awan ti makapangalap ti biyag kuwidi, nan kusa ku iyád a iyatád. Tehudák a kapangyariyan a iyatád iyád sakay alapán a ruway. Iyád en utus a tinanggap ku ten Ama ku.” ");
INSERT INTO prfNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Gapu ti kinagiyid a hidi iyud ni Jesus ten Judio hidi ay awan hidi namagkaessa ti palagay. ");
INSERT INTO prfNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Kakpalan dikodi ay nagkagi a, “Sinaniban siya ni dimonyo sakay nagareng! Bakin mágsanig kam pa dikona?” ");
INSERT INTO prfNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Kinagi bi nen agum a, “Awan makapagupos ti kona haud i sinanibanid ni dimonyo! Makagamot beman ti burák i dimonyowid?” ");
INSERT INTO prfNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Sákdágnen tenhud sakay pasiyaan en Piyesta nen Páglaan ten Templo ti Jerusalem. ");
INSERT INTO prfNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Dikona ked ti Jesus ten Templo a máglakad-lakad ten balkon ni Solomon, ");
INSERT INTO prfNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","ay pinalebutan siya nen Judio hidi sakay kinagi di dikona, “Bakin págdadudaán mu kami pa? Kagiyán mu dikomi ni talaga siko dán ti Cristo.” ");
INSERT INTO prfNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Kinagi ni Jesus dikodi, “Kinagi ku dán ben dikomoy, peru awan kam maniwala. En gággamitán ku hidi ten pamamag-itan nen ngaran nen Ama ku en magpatunay tungkul dikoku. ");
INSERT INTO prfNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Peru awan kam maniwala, gapu awan kam kabilang ten tupa ku hidi. ");
INSERT INTO prfNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Mágsanig dikoku en tupa ku hidi, tukoy ku hidi sakay sumunud hidi dikoku. ");
INSERT INTO prfNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Atáddán ku hidi ti biyag a awan ti katapusan. Maski nikan ay awan hidi mepahamak sakay awan hidi maagew nen deyaman dikoku. ");
INSERT INTO prfNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","En Ama ku a náng-atád dikodi dikoku ay dakila ten atanan sakay awan ti makapangagew dikodi ten Ama ku. ");
INSERT INTO prfNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Sikán ay ten Ama ku ay eessa la.” ");
INSERT INTO prfNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Pákkasanig nen Judio hidi ti iyud ay, nangkopkop hidi a ruway ti batu tánni batuwán di siya. ");
INSERT INTO prfNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Kinagi ni Jesus dikodi, “Makpalák a impeta dikomoy a mágkaganda a gamet a gubwat ten Ama ku. Hádya ti hidi iyud pangbatuwan moyid dikoku?” ");
INSERT INTO prfNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Tummábbig en pinunu hidi nen Judio hidi, “Bakán a gapu ten mágkaganda a gamet kaya batuwán mi ka nan gapu ten páglapastangan mu ten Diyos! Gapu kinagi mu a Diyos ka peru tolay ka la.” ");
INSERT INTO prfNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Kinagi ni Jesus dikodi, “Awan beman nakasulat ten Kautusan moy a, ‘Kinagi ku a diyos kam?’ ");
INSERT INTO prfNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Diyos hidi en nangdulaw nen Kautusan ten nángtiwalaan hidi ten upos nen Diyos, sakay awan maari a tanggiyan en kinagi nen kasulatan. ");
INSERT INTO prfNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Sikán ay pinili sakay inutusan nen Ama. Konya moy a makagi a linapastangan ku en Diyos gapu kinagi ku a Anakák nen Diyos? ");
INSERT INTO prfNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Ni awan ku gamitán en pagamet hidi dikoku nen Ama ku, ay dyan kam maniwala dikoku. ");
INSERT INTO prfNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Peru ni gamitán ku hidi iyud, ay dapat a paniwalaan moy en ginággamet ku, maski ni awanák moy paniwalaan. Ni magkakonahud ay masiguradu moy a ked dikoku en Ama sakay kedák bi dikona.” ");
INSERT INTO prfNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Laan di dámman siya a dikáppán, peru nakalisi siya. ");
INSERT INTO prfNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Nagsoli dámman ti Jesus ten dibelyu ni Jordan, adeni ten nagbinyagan ni Juan. Mentras a ked haud siya ay, ");
INSERT INTO prfNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","makpal a ummangay dikona. Kinagi nen tolay hidi, “Ti Juan ay awan ti ginamet a himala, peru tatarudan en atanan a kinákkagi na tungkul ti tolayid a iyád.” ");
INSERT INTO prfNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Kaya makpal en summampalataya kánni Jesus haud. ");
INSERT INTO prfNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Nadid, tehud a lállaki a nagkasakit ti Betania a en ngaran na ay ti Lazaro a kapatkaka de Maria ay ti Marta. ");
INSERT INTO prfNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Ti Maria en nangbulak ten básset nen Panginoon ti págpasárrub sakay pinahidan na ten buuk na. Gapu tehud a saket ti Lazaro, ");
INSERT INTO prfNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","kaya impekagi nen matkaka kánni Jesus a, “Panginoon, en mahal mu a amigu ay tehud a saket.” ");
INSERT INTO prfNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Peru dikona masanig iyud ni Jesus, ay kinagi na, “Awan siya matay ten saket na. Nangyari iyud tánni maparangalan en Diyos sakay ten pamamag-itan ni iyád ay maparangalan en Anak nen Diyos.” ");
INSERT INTO prfNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Mahal ni Jesus en matátkaka a de Marta, Maria ay ti Lazaro. ");
INSERT INTO prfNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Peru nagpalipas pa siya ti duwwa a aldew sapul dikona a mabareta na a tehud a saket ti Lazaro. ");
INSERT INTO prfNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Kállipas nen duwwa a aldew, ay kinagi na ten disepulus na hidi, “Magsoli kitam ti Judea.” ");
INSERT INTO prfNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Kinagi nen disepulus na hidi, “Maistu, awan beman págbabaditan ka dán a batuwán nen pinunu hidi nen Judio hidi? Bakin magsoli ka dámman haud?” ");
INSERT INTO prfNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Kinagi ni Jesus, “Awan beman tehud a sapulu ay ti duwwa a odas ten maghapun? Awan mesángdul en maglakad ni aldew, gapu ketan na en demlag ni munduwiday. ");
INSERT INTO prfNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Peru mesángdul en maglakad ti gibi, gapu awan dikona en demlag.” ");
INSERT INTO prfNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Káttapos ni iyud, ay kinagi na dikodi, “En amigu tam a ti Lazaro ay netidug, kaya kadtamon haud angen ku siya lukagán.” ");
INSERT INTO prfNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","“Panginoon, ni konahud ay magpiyya la siya,” kagi nen disepulus na hidi. ");
INSERT INTO prfNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","En gustu a kagiyán ni Jesus ay patay dán ti Lazaro, peru en akala nen disepulus na hidi ay talaga a tidug la. ");
INSERT INTO prfNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Kaya kinagi ni Jesus ti mahusay, “Natay dán ti Lazaro. ");
INSERT INTO prfNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Peru masayaák ta awanák haud tánni sumampalataya kam dikoku. Kaya kadtamon haud.” ");
INSERT INTO prfNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Nadid, ti Tomas a ngángngaranan di a Kambal, ay nagakit ten kaguman na hidi. “Kadtamon mákkuyug kitam ten Maistu, maski mákkatay kitam dikona.” ");
INSERT INTO prfNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Káddemát de Jesus ti Betania, ay natukuyan na a áppat dán a aldew a nakalábbáng ti Lazaro. ");
INSERT INTO prfNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Manga tállu a kilumetru en kadeyu ni Betania ti Jerusalem. ");
INSERT INTO prfNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Sakay makpal ten taga-Jerusalem hidi en ummangay kánde Marta ay ti Maria tánni mangparapara dikodi. ");
INSERT INTO prfNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Ten pákkasanig ni Marta a pademát ti Jesus, ay tinagbu na sakay inuron na siya. Peru ti Maria ay nawarak la ten bilay di. ");
INSERT INTO prfNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Kinagi ni Marta, “Panginoon, ni ked ka la nakuwan háddi ay awan nakuwan natay en kapatkaka ku. ");
INSERT INTO prfNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Peru tukoy ku, a maski nadid ay iyatád nen Diyos en ányaman a agidán mu dikona.” ");
INSERT INTO prfNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Kinagi ni Jesus dikona, “Mabiyag a ruway en kapatkaka mu.” ");
INSERT INTO prfNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Kinagi ni Marta, “Tukoy ku a mabiyag siya a ruway ten katapusan a aldew.” ");
INSERT INTO prfNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Kinagi ni Jesus dikona, “Sikán en makapangatád ti biyag sakay en ruway a kákkabiyag. Ni deyaman en sumampalataya dikoku, maski matay ay mabiyag a ruway. ");
INSERT INTO prfNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Sakay en deyaman a biyag nadid a sumampalataya dikoku ay awan matay maski nikan. Maniwala ka beman?” ");
INSERT INTO prfNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Tummábbig siya, “Maniwalaák Panginoon! Sumampalatayaák dikomu sakay maniwalaák a siko en Cristo, en Anak nen Diyos, a áorayán mi a pademát ti munduwiday.” ");
INSERT INTO prfNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Káttapos ni iyud ay ummuli ti Marta. Inangay na sinekretu en wadi na a kinagiyan, “Keddán en Maistu, padulaw na ka.” ");
INSERT INTO prfNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Ten pákkasanig ni Maria, ay pagdaka siya a tummaknág sakay tummagbu kánni Jesus. ");
INSERT INTO prfNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","(Awan palla nakademát ti Jesus ten baryu, ked palla siya ten nangtagbuwan dikodi ni Marta.) ");
INSERT INTO prfNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Inumunud kánni Maria en Judio hidi a mangparapara dikodi, dikona ketan di a magalistu siya a lumuwas ten bilay di. Akala di ay angay siya ten páglábbángngan a magsanget. ");
INSERT INTO prfNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Káddemát ni Maria ten puwestu ni Jesus, ay lummuhud siya ten táttaknággan na. Kinagi na, “Panginoon, ni ked ka la nakuwan háddi ay awan natay en kapatkaka ku.” ");
INSERT INTO prfNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Nahabag ti Jesus ten pákketa na a magsanget ti Maria sakay en Judio hidi a kaguman na. ");
INSERT INTO prfNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","“Hádya nánglábbángngan moyid dikona?” kagi ni Jesus. “Karon hád Panginoon angen mu ilingán.” tábbig di dikona. ");
INSERT INTO prfNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Nagsanget ti Jesus. ");
INSERT INTO prfNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Kaya, kinagi nen Judio hidi, “Ilingán moy talaga a mahal na ti Lazaro!” ");
INSERT INTO prfNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Peru kinagi nen agum, “Nagpapiyya siya ti burák, bakin awan na napugád en kákkatay ni Lazaro?” ");
INSERT INTO prfNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Káddemát ni Jesus ten páglábbángngan ay nalungkut siya a ruway. En páglábbángngan ay kuweba a tehud a takáp a dikál a batu en bunganga na. ");
INSERT INTO prfNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Kinagi ni Jesus dikodi, “Ibutan moy batuwen.” Kinagi ni Marta, “Panginoon kaáppat na dán nadid a aldew siguradu a mabuyok dán siya.” ");
INSERT INTO prfNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Kinagi ni Jesus, “Awan beman kinagi ku dikomu a ni sumampalataya ka dikoku ay ketan mu nen kaluwalhatian nen Diyos?” ");
INSERT INTO prfNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Kaya inibutan di en batu. Sakay tummangad ti Jesus a kinagi na, “Ama, magpasalamaták dikomu gapu sinanigák mu. ");
INSERT INTO prfNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Tukoy ku Ama a pirmiyák mu a sanigán. Kaya ku iyád a kinagi ay gapu ti tolayiday hidi, tánni maniwala hidi a siko en nangutus dikoku.” ");
INSERT INTO prfNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Káttapos na iyud a kinagi, ay impákraw na a, “Lazaro, lumuwas ka haán!” ");
INSERT INTO prfNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Linumuwas ngani ti Lazaro, a nabalutan ti damit a panglábbáng en lima na sakay en básset na, tehud bi a takáp a damit en rupa. Kinagi ni Jesus, “Okbisan moy siya, tánni makalakad dán siya.” ");
INSERT INTO prfNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Kakpalan ten Judio hidi a kaguman ni Maria a naketa ten ginamet ni Jesus ay summampalataya hidi dikona. ");
INSERT INTO prfNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Peru en agum, ay ummangay hidi ten Pariseo hidi sakay imbareta di en ginamet ni Jesus. ");
INSERT INTO prfNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Kaya inipun nen pinunu hidi nen padi hidi sakay nen Pariseo hidi en kagawad hidi nen Sanedrin. Kinagi di a, “Ánya gamitán tamid? Makpal dán a ginággamet a himala i tolayid a iyán. ");
INSERT INTO prfNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Ni páppabayan tam siya a magtulos-tulos ti gággamitán naen ay mapaniwala na en atanan. Ni magkakonahud ay angay háddi en Romano hidi sakay sidaán di en Templo sakay pahirapan di en bansa tam.” ");
INSERT INTO prfNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Peru en essa dikodi a ti Caifas, a kapunuwan nen padi hidi tenhud, ay kinagi na, “Talaga a awan kam ti tukoy! ");
INSERT INTO prfNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Awan moy beman maisip a mas mapiyya pa ni essa la matayid alang-alang ten banuwan, nan ni mepahamak en buu a bansa?” ");
INSERT INTO prfNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Awan gubwat ten sadili na iyud a kinagi ni Caifas. Nan bilang kapunuwan nen padi hidi ti iyud a taon ay impahayag na a dapat a matay ti Jesus alang-alang ten bansa di. ");
INSERT INTO prfNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Sakay tánni maipun en atanan a nekalat a anak nen Diyos. ");
INSERT INTO prfNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Sapul haud, ay nagisipan di dán ni konya di a mapabunu ti Jesus. ");
INSERT INTO prfNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Kaya ti Jesus ay awan dán pinumeta a maglakad ti Judea. Nan nagdiretsu dán siya ten banuwan a Efraim a adeni ten kaparangan. Sakay haud pala siya a nákpágyan a kaguman nen disepulus na hidi. ");
INSERT INTO prfNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Nadid, adeni dán en Piyesta nen Aldew nen Págtalib nen Judio hidi, makpal a inumangay a tolay ti Jerusalem bagu a dumemát en piyesta, tánni tupadán di en utus ni Moises tungkul ten páglinis ti bággi. ");
INSERT INTO prfNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Inaryok di ti Jesus ten Templo, sakay nagtanungan hidi, “Ánya ti palagay moyid? Umangay wád siya ti piyestaidi?” kagi di. ");
INSERT INTO prfNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Nagutus en kapunuwan nen padi hidi sakay en Pariseo hidi, a ikagi dikodi nen tolay hidi ni hádya puwestuwid ni Jesus, tánni mapadikáp di siya. ");
INSERT INTO prfNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Nadid, ánnám pa a aldew bagu en Piyesta nen Aldew nen Págtalib, ti Jesus ay dummemát ti Betania, ten banuwan ni Lazaro a biniyag na a ruway. ");
INSERT INTO prfNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Kaya naghanda hidi haud ti pangapon para kánni Jesus, sakay kumman hidi a kaguman ti Lazaro. Ti Marta ay nagserbi dikodi. ");
INSERT INTO prfNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Nangalap ti Maria ti kalahati ni litru a mahal a kalasi ni págpasárrub, iyád ay puru a págpasárrub a gubwat ten mula a nardo. Imbulak na iyud ten babásset ni Jesus. Káttapos ay pinahidan na ten buuk na. Sakay en buu a bilay ay summárrub. ");
INSERT INTO prfNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Ti Judas Iscariote, en disepulus ni Jesus a mángtokyon dikona en nagkagi a, ");
INSERT INTO prfNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“En halaga ni pasárrubid a iyán ay katumbas nen essa a taon a suweldu. Bakin a awan tam dálla inlaku sakay inyatád ten mágkahirap hidi en pilak?” ");
INSERT INTO prfNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Kinagi na iyud bakán a gapu tehud siya a malasakit ten mágkahirap hidi nan gapu a essa siya a mágtakaw. Siya en mágsaddi ten pilak di sakay kákkupitán na iyud. ");
INSERT INTO prfNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Tummábbig ti Jesus, “Pabayan moy la siya. Imbulak na iyud ten bággi ku bilang pághanda ten páglábbáng dikoku. ");
INSERT INTO prfNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","En mágkahirap ay pirmi moy hidi a kakaguman, peru sikán ay awanák moy pirmi a kakaguman.” ");
INSERT INTO prfNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Ten dikona a nabareta nen makpal a Judio a ked ti Betania ti Jesus ay ummangay hidi haud, bakán la a gapu kánni Jesus nan gustu di bi a ketan ti Lazaro a biniyag na a ruway. ");
INSERT INTO prfNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Kaya binalak nen pinunu hidi nen padi hidi a pabunu di bi ti Lazaro, ");
INSERT INTO prfNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","gapu siya en dahilan ni bakin a en Judio hidi ay humiwalay dán dikodi sakay sumampalataya dán kánni Jesus. ");
INSERT INTO prfNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Nadid, ten kailawan na ay nabareta nen tunay ti kakpal a tolay a nákpamiyesta a ti Jesus ay tamu ti Jerusalem. ");
INSERT INTO prfNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Kaya nangalap hidi ti palapa ni palma sakay tinagbu di ti Jesus. Ipáppákraw di a, “Puriyán en Diyos! Pagpalaán en dumemát ten ngaran nen Panginoon. Puriyán en Hari ni Israel!” ");
INSERT INTO prfNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Netan ni Jesus en essa a bul-u palla a asno sakay sinakayan na iyud, kona ten nesulat a, ");
INSERT INTO prfNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Dyan kam manteng, sikam a taga-Sion hidi! Mágsanig kam! Dumemát dán en Hari moy, a sumássakay ten bul-u a asno!” ");
INSERT INTO prfNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Awan iyud naintendiyan nen disepulus na hidi. Peru dikona a mabiyag a ruway ti Jesus sakay maluwalhati, ay naala-ala di en kinagi ten kasulatan tungkul dikona, kaya kona ngani haud en nangyari. ");
INSERT INTO prfNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Dikona a biyagán a ruway ni Jesus ti Lazaro ay makpal en naketa. Iyud a pangyayari ay angay di imbábbareta. ");
INSERT INTO prfNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Iyud en dahilan ni bakin a tinagbu siya ni sakonahud ti kakpal a tolay gapu nabareta di en ginamet na hidi a himala. ");
INSERT INTO prfNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Namágguronan nen Pariseo hidi a, “Awan kitamon ti magamet! Ilingán moy umunonud dán dikona atanan a tolay!” ");
INSERT INTO prfNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Nadid ay tehud a sangan a Griego a ummangay ten piyesta nen Aldew nen Págtalib tánni sumamba. ");
INSERT INTO prfNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Ummadeni hidi kánni Felipe a taga-Bethsaida a sakup ni Galilea sakay kinagi di, “Maari kami wád a mákpágguron kánni Jesus?” ");
INSERT INTO prfNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Kinagi iyud ni Felipe kánni Andres sakay hidi a duwwa en ummadeni kánni Jesus sakay kinagi di iyud. ");
INSERT INTO prfNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Kinagi ni Jesus, “Dummemát dán en odas tánni parangalan en Anak nen Tolay. ");
INSERT INTO prfNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Tandaan moy: mentras a awan matáknig ten luta en essa a butil nen trigo sakay matay ay manatili iyud a mággeessa. Peru ni matay ay magbunga iyud ti makpal. ");
INSERT INTO prfNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","En tolay a magpahalaga ti hustu ten biyag na ay siya en mawanan, peru ni deyaman en awan mangpahalaga ten biyag na ti munduwiday gapu la dikoku ay magkahud ti biyag a awan ti katapusan. ");
INSERT INTO prfNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Ni deyaman en magserbi dikoku ay dapat a sumunud dikoku, sakay ni ked hádyaák ay ked bi siya haud. Ni deyaman en magserbi dikoku ay parangalan nen Ama.” ");
INSERT INTO prfNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Kinagi pa ni Jesus, “Mabalisaák nadid. Kagiyán ku beman ten Ama a iligtasák na ten adeni dán a pághirap ku? Awan! Gapu iyád en dahilan ni bakin a kedák háddi.” ");
INSERT INTO prfNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Káttapos ay kinagi ni Jesus, “Ama, parangalan mu en ngaran mu.” Sakay en boses a gubwat dilanget en tummábbig a, “Pinarangalan ku dán iyád sakay ruway ku a parangalan.” ");
INSERT INTO prfNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Nasanig iyud nen tolay hidi a ked haud kaya kinagi di, “Nagkáddur” Kagi bi nen agum ay, “Nákpágguron dikona en essa a anghel!” ");
INSERT INTO prfNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Kinagi ni Jesus, “Impasanig iyud a boses para dikomoy, bakán a para dikoku.” ");
INSERT INTO prfNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","“Nadid dán en panahun tánni hatulan i munduwiday. Sakay iyád dán bi en panahun a hatulan en pinunu ni munduwiday. ");
INSERT INTO prfNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Sakay ni melangkawák ay paadeniyán ku dikoku en atanan a tolay.” ");
INSERT INTO prfNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","(Kinagi na iyád tánni ipeta na ni konya siya a matay.) ");
INSERT INTO prfNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Tummábbig en tolay hidi, “Kinagi nen Kautusan a en Cristo ay mabiyag a awan ti katapusan. Bakin a kinagi mu a kailangan a melangkaw en Anak nen Tolay? Deya beman en Anak nen Tolay a kákkagiyán mu?” ");
INSERT INTO prfNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Tummábbig ti Jesus, “Awan dán magmalay a kakaguman moy en demlag. Tulos kam a maglakad mentras a kaguman moy palla en demlag, tánni awan kam maabutan nen diklám. Gapu awan tukoy nen maglakad ten kadiklámman ni hádya en angayan na. ");
INSERT INTO prfNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Sumampalataya kam ten demlag mentras a kaguman moy palla en demlag tánni magin anak kam nen demlag.” Káttapos na hidi a kagiyán ay lummakad ti Jesus sakay tinaguwan na hidi. ");
INSERT INTO prfNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Nadid, maski ni netan nen Judio hidi en makpal a himala a ginamet ni Jesus ay awan padi hidi summampalataya dikona. ");
INSERT INTO prfNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Ni konahud ay natupad en kinagi ni Propeta Isaias a, “Panginoon, deya naniwalaid ten impahayag mi? Deya i nángpetaan muwid ten kapangyariyan mu?” ");
INSERT INTO prfNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Awan ngani hidi maniwala gapu kinagi ni Isaias, ");
INSERT INTO prfNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Binurák nen Diyos en mata di sakay pinakáttug na en pusu di, tánni awan hidi maketa, sakay awan makaintendi en isip di, bakay sumoli hidi dikoku sakay pagpiyyaán ku hidi.” ");
INSERT INTO prfNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Kinagi iyád ni Isaias gapu netan na en kaluwalhatian ni Jesus, sakay nagupos siya tungkul kánni Jesus. ");
INSERT INTO prfNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Konapamanhud, ay makpal ten pinunu hidi nen Judio hidi en naniwala dikona. Peru insekretu di la gapu ten ánteng di ten Pariseo hidi, bakay itiwalag di hidi ten sinagoga. ");
INSERT INTO prfNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Gapu mas ginustu di pa a kasayaan nen tolay nan kasayaan nen Diyos. ");
INSERT INTO prfNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Sakay mabegsák a kinagi ni Jesus, “En maniwala dikoku ay bakán la a sikán en naniwalaan na, nan pati en nangutus dikoku. ");
INSERT INTO prfNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Sakay en naketa dikoku ay naketa dán bi ten nangutus dikoku. ");
INSERT INTO prfNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Ummangayák háddi bilang demlag ti munduwiday, tánni deyaman en maniwala dikoku ay awan dán manatili ten kadiklámman. ");
INSERT INTO prfNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Ni deyaman en nakasanig ten upos ku hidi peru umád a sumunud ay awan ku siya hatulan. Gapu ummangayák háddi bakán a tánni hatulan ku i munduwiday nan para iligtas iyád. ");
INSERT INTO prfNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Tehud a manghatul ten mángtakwil dikoku sakay en awan mangtanggap ten upos ku hidi; en upos a impangaral ku en manghatul dikodi ten katapusan a aldew. ");
INSERT INTO prfNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Gapu awanák magupos a gubwat la ten sadili ku, nan en Ama a nangutus dikoku en nángkagi ni ánya i dapat kuwid a kagiyán sakay ipahayag. ");
INSERT INTO prfNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Sakay tukoy ku a en utus na ay makapangatád ti biyag a awan ti katapusan. Kaya en pekagi nen Ama en ipáppahayag ku dikomoy. ");
INSERT INTO prfNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Nadid, dikona a saldew dálla bagu a Piyesta nen Aldew nen Págtalib ay tukoy ni Jesus a dumemát dán en panahun a lumakad dán siya ti munduwiday tánni sumoli dán siya ten Ama. Mahal ni Jesus en disepulus na hidi a ked ti munduwiday, sakay en págmahal na dikodi ay hanggan ten katapusan. ");
INSERT INTO prfNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Ti gibiyid a iyud a nangapon hidi, ay immula dán nen diyablo ten isip ni Judas Iscariote a anak ni Simon a itokyon na ti Jesus ten Judio hidi. ");
INSERT INTO prfNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Tukoy ni Jesus a atanan a kapangyariyan ay inyatád dán dikona nen Ama. Sakay tukoy na bi a gubwat siya ten Diyos sakay pasoli dán siya ten Diyos. ");
INSERT INTO prfNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Mentras a kuman hidi ay tummaknág ti Jesus sakay ineklas na en alikábkáb na sakay imburebád na ten sáppang na en tuwalya. ");
INSERT INTO prfNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Káttapos ay nángbulak siya ti dinom ten palanggana sakay sinapulan na a ugasan en babásset nen disepulus na hidi sakay pinahidan na ten tuwalya a bumábburebád ten sáppang na. ");
INSERT INTO prfNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Ten dikona a ummadeni siya kánni Pedro ay inumád siya. Kinagi na, “Panginoon, bakin siko pa i mangugasid ti babásset kuwiday?” ");
INSERT INTO prfNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Tummábbig ti Jesus, “Awan mu maintendiyan i gággamitán kuwiday nadid, peru maintendiyan mu labi iyád káttapos.” ");
INSERT INTO prfNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Ruway a kinagi ni Pedro, “Panginoon, umáddák a siko i mangugasid ti básset kuwiday hidi. Tummábbig ti Jesus, “Ni awan mu paugas i básset muwen ay awan ka ti kaugnayan dikoku.” ");
INSERT INTO prfNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Kaya kinagi ni Pedro, “Ni konahud Panginoon ay bakán la i básset kuwiday hidi i ugasan muwid nan pati dán bi i lima kuwiday hidi sakay ulu ku.” ");
INSERT INTO prfNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Kinagi dikona ni Jesus, “En nakapágdigus dán ay awan dán kailangan a ugasan puwera la ten babásset na, gapu malinis dán en buu moy a bággi. Malinis kamon, peru bakán a atanan moy.” ");
INSERT INTO prfNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","(Kinagi ni Jesus a awan atanan ay malinis gapu tukoy na ni deya en mángtokyon dikona.) ");
INSERT INTO prfNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Káttapos a maugasan ni Jesus en babásset di hidi ay ruway na insulot en alikábkáb na sakay summoli siya ten lamisaan. Káttapos ay tinanung na hidi, “Naintendiyan moy beman en ginamet ku dikomoy?” ");
INSERT INTO prfNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","“Dáddulawanák moy a Maistu sakay Panginoon, ay tama kam gapu iyán ngani en tatarudan. ");
INSERT INTO prfNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Nadid ni sikán a Panginoon sakay Maistu moy ay nagugas ten babásset moy hidi ay dapat bi a mamagugasan kam ti básset. ");
INSERT INTO prfNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Impeta ku dikomoy en halimbawa a dapat moy a arigán. Kaya gamitán moy bi en ginamet ku dikomoy. ");
INSERT INTO prfNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Kagiyán ku dikomoy: en alipin ay awan mataas nan en amu na, sakay awan bi ti inutusan a mas mataas nan ten nangutus dikona. ");
INSERT INTO prfNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Ni naintendiyan moy hidi iyád a bagay sakay gamitán moy ay pagpalaán kam nen Diyos. ");
INSERT INTO prfNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Awan ku kagiyán a pinagpala kam a atanan, gapu tukoy ku en pinili ku hidi. Peru kailangan a matupad en kinagi nen Kasulatan a, ‘Tinaraidurák nen tolay a pinakan ku.’ ");
INSERT INTO prfNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Kagiyán ku iyád dikomoy bagu a mangyari tánni ni mangyari dán ay sumampalataya kam a, ‘Sikán ay sikán dán.’ ");
INSERT INTO prfNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Kagiyán ku dikomoy a: ni deyaman en mangtanggap ten inutusan ku ay mangtanggap bi dikoku sakay ni deyaman en mangtanggap dikoku ay mangtanggap bi ten nangutus dikoku.” ");
INSERT INTO prfNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Káttapos a kagiyán ni Jesus hidi iyud ay nabalisa siya ti hustu sakay kinagi na, “Kagiyán ku dikomoy a essa dikomoy en mángtokyon dikoku.” ");
INSERT INTO prfNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Nággilengan en disepulus hidi gapu awan di tukoy ni deya en gustu a kagiyán ni Jesus. ");
INSERT INTO prfNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","En disepulus a mahal ni Jesus ay kasadát na. ");
INSERT INTO prfNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Sininyasan siya ni Simon Pedro a tanungán na kánni Jesus ni deya en gustu na a kagiyán. ");
INSERT INTO prfNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Kaya summandig siya ten abaga ni Jesus sakay intanung na, “Panginoon deya gustu muwid a kagiyán?” ");
INSERT INTO prfNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Tummábbig ti Jesus, “En páng-atáddan ku ten tinapay káttapos ku a isawsaw ay siya iyud.” Kaya nangalap ti Jesus ti tinapay sakay káttapos na a insawsaw ay inyatád na kánni Judas a anak ni Simon Iscariote. ");
INSERT INTO prfNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Ten dikona a matanggap ni Judas en tinapay ay sináddáp siya ni Satanas. Kinagi ni Jesus dikona, “Gamitán mu dán a pagdaka en dapat mu a gamitán.” ");
INSERT INTO prfNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Peru maski ni essa ten kaguman hidi ni Jesus a nangapon ay awan di naintendiyan ni bakin a kinagi iyud ni Jesus. ");
INSERT INTO prfNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Gapu ti Judas en tagatawid ten pilak di ay inisip nen agum a inutusan siya ni Jesus a mamali ten kailangan di hidi para ten piyesta oni angay siya mangatád ti limus ten mágkahirap hidi. ");
INSERT INTO prfNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Ten dikona a makakan dán ti Judas ten tinapay ay lummakad siya. Gibi dán ti odasid a iyud. ");
INSERT INTO prfNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Ten dikona a nakalakad dán ti Judas ay kinagi ni Jesus, “Nadid ay mehayag dán en karangalan nen Anak nen Tolay, sakay ten pamamag-itan na ay mehayag bi en karangalan nen Diyos. ");
INSERT INTO prfNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Sakay ni mehayag dán en karangalan nen Diyos ten pamamag-itan nen Anak nen Tolay, ay en Diyos bi mánghayagid ten karangalan nen Anak sakay gamitán na iyud a pagdaka.” ");
INSERT INTO prfNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Anak ku hidi, badit dálla a panahun a makagumanák moy. Aryokánnák moy, peru kona ten kinagi ku ten Judio hidi, ‘Awan kam makaangay ten angayan ku.’ ");
INSERT INTO prfNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Essa a bigu a utus en iyatád ku dikomoy: magmahalan kam! Ni konya takam a minahal ay kona bi hud en págmahal moy ten balang essa. ");
INSERT INTO prfNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Ni magmahalan kam ay matukuyan nen atanan a tolay a sikam ay disepulus ku hidi.” ");
INSERT INTO prfNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Tinanung ni Simon Pedro ti Jesus, “Panginoon, hádya i angayan muwid?” Tummábbig ti Jesus, “Ten angayan ku ay awan ka makaunud nadid, peru makaunud ka labi balang aldew.” ");
INSERT INTO prfNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Nagtanung pa ti Pedro, “Panginoon, bakin a awanák maari a umunud dikomu nadid? Nakahandaák bi a matay para dikomu.” ");
INSERT INTO prfNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Tummábbig ti Jesus, “Iyalay mu i biyag muwen para dikoku? Tandaan mu: bagu a magtarakket en manok ay pumentálluwák mu a ipamen.” ");
INSERT INTO prfNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Kinagi ni Jesus dikodi, “Dyan kam mabalisa. Sumampalataya kam ten Diyos sakay sumampalataya kam bi dikoku. ");
INSERT INTO prfNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Ten bilay nen Ama ku ay makpal a kuwartu. Angayák haud para paghanda takam ti mapágyanan moy. Awan ku iyád kagiyán dikomoy ni awan tatarudan. ");
INSERT INTO prfNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Ni kedák dán haud sakay nehanda ku dán en mapágyanan moy ay soliyák sakay ikuyug takam tánni ni ked hádyaák ay ked kam bi haud. ");
INSERT INTO prfNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Sakay tukoy moy dán en dilan a patamu ten angayan ku.” ");
INSERT INTO prfNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Kinagi ni Tomas dikona, “Panginoon, awan mi tukoy ni hádya angayan muwid, konya mi a matukuyan en dilan?” ");
INSERT INTO prfNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Tummábbig ti Jesus, “Sikán en dilan, en katutuhanan, sakay en biyag. Awan ti makaangay ten Ama ni awan ten pamamag-itan ku. ");
INSERT INTO prfNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Ni matenggiyák moy ay tukoy moy dán bi en Ama ku. Sapul nadid ay matenggi moy dán siya sakay netan moy dán.” ");
INSERT INTO prfNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Kinagi ni Felipe dikona, “Panginoon, ipeta mu la dikomi en Ama ay makontentu kami dán.” ");
INSERT INTO prfNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Tummábbig ti Jesus, “Felipe, awanák mu palla bali tukoy, maski nalay kitamon a mamagkakaguman? En naketa dikoku ay naketa dán bi ten Ama. Bakin a kagiyán mu pa a, ‘Ipeta mu dikomi en Ama’? ");
INSERT INTO prfNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Awan ka beman maniwala a kedák ten Ama sakay en Ama ay ked dikoku? En upos hidi a kagiyán ku dikomoy ay bakán a gubwat dikoku nan gubwat ten Ama a ked dikoku. Siya en manggamet ten bagay hidi a gággamitán ku. ");
INSERT INTO prfNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Maniwala kam a sikán ay ked ten Ama sakay en Ama ay ked dikoku. Ni umád kam a maniwala ten kákkagiyán ku ay maniwala kam gapu ten ginamet ku. ");
INSERT INTO prfNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Kagiyán ku dikomoy en tatarudan: en manampalataya dikoku ay makagamet bi ten gággamitán ku ti mas higit pa, gapu sumoliyák dán ten Ama. ");
INSERT INTO prfNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Sakay ányaman en agidán moy ten ngaran ku ay gamitán ku tánni maparangalan en Ama ten pamamag-itan nen Anak. ");
INSERT INTO prfNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Gamitán ku en ányaman a agidán moy ten pamamag-itan nen ngaran ku.” ");
INSERT INTO prfNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Ni mahalák moy ay sunudán moy en utus ku hidi. ");
INSERT INTO prfNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Sakay agidán ku ten Ama a paangayán na dikomoy en Tagagiyya a makaguman moy a awan ti katapusan. ");
INSERT INTO prfNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Iyád ay en Ispiritu nen katutuhanan, a awan matanggap ni munduwiday gapu awan siya ketan oni tukoy ni munduwiday. Peru tukoy moy siya, gapu siya ay kakaguman moy sakay mágyan siya dikomoy.” ");
INSERT INTO prfNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“Awan takam iwarak a awan ti kaguman; soliyán takam. ");
INSERT INTO prfNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Awan dálla malay ay awanák dán ketan nen taga-mundu hidi, peru ketanák moy; gapu mabiyagák sakay mabiyag kam bi. ");
INSERT INTO prfNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Ti aldewid a iyud ay matukoyan moy a sikán ay ked ten Ama ku, sikam ay ked dikoku sakay sikán ay ked dikomoy.” ");
INSERT INTO prfNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","“Ni deyaman en mangtanggap sakay sumunud ten utus ku hidi ay siya en magmahal dikoku. En magmahal dikoku ay mahalán bi nen Ama ku. Mahalán ku bi siya sakay magpakilalaák dikona.” ");
INSERT INTO prfNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Tinanung siya ni Judas (bakán a ti Iscariote), “Panginoon, bakin dikomi ka la a magpakilala ti hustu bakán a ti munduwiday?” ");
INSERT INTO prfNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Tummábbig ti Jesus, “En magmahal dikoku ay sumunud ten utus ku hidi. Mahalán siya nen Ama ku sakay umangay kami mákpágyan dikona. ");
INSERT INTO prfNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","En awan magmahal dikoku ay awan sumássunud ten utus ku hidi. Sakay en upos hidi a nasanig moy dikoku ay awan gubwat dikoku nan ten Ama a nangutus dikoku.” ");
INSERT INTO prfNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Kinagi ku hidi iyád a bagay dikomoy mentras a kakagumanák moy palla. ");
INSERT INTO prfNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Peru en Tagagiyya, en Banal Ispiritu a paangayán háddi nen Ama ten ngaran ku ay siya en magtoldu dikomoy ten atanan a bagay sakay magpaala-ala ten atanan a kinagi ku dikomoy.” ");
INSERT INTO prfNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“Kapayapaan en iwarak ku dikomoy. En kapayapaan ku en iyatád ku dikomoy; bakán iyád a kona ten iyatád ni munduwiday. Dyan kam mabalisa sakay dyan kam manteng. ");
INSERT INTO prfNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Kinagi ku dán dikomoy a, ‘Lumakadák peru sumoliyák labi.’ Ni mahalák moy, ay dapat a magsaya kam ta angayák ten Ama, gapu mas dakila en Ama nan sikán. ");
INSERT INTO prfNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Kagiyán ku dán hidi iyád dikomoy bagu pa a mangyari tánni ni mangyari dán ay maniwala kam dikoku. ");
INSERT INTO prfNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Awan ku dán pakaatakdugán i kákkagiyán kuwiday dikomoy, gapu pademát dán en pinunu ni munduwiday. Awan siya ti kapangyariyan dikoku, ");
INSERT INTO prfNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","kaya la dapat a matukuyan ni munduwiday a mahal ku en Ama ku, kaya gamitán ku en inyutus na dikoku. Kamon dán, kadtamon!” ");
INSERT INTO prfNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Kinagi pa ni Jesus ten disepulus na hidi, “Sikán en tatarudan a ponan nen ubas sakay en Ama ku en mággalaga. ");
INSERT INTO prfNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Káttolán na en balang pinget a awan magbunga sakay káttulan na sakay linisan en balang pinget a magbunga tánni lalu pa a magbunga ti makpal. ");
INSERT INTO prfNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Malinis kamon gapu ten upos hidi a kinagi ku dikomoy. ");
INSERT INTO prfNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Manatili kam dikoku sakay manatiliyák dikomoy. Awan makapagbunga en pinget a awan manatili a nakakabit ten ponan. Kona bi hud i mangyariyid, awan kam makapagbunga ni awan kam manatili dikoku.” ");
INSERT INTO prfNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Sikán en ponan nen ubas, sikam en pinget hidi. En manatili dikoku sakay manatiliyák bi dikona ay makapagbunga ti makpal. Gapu awan kam ti magamet ni nakahiwalay kam dikoku. ");
INSERT INTO prfNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","En awan manatili dikoku ay kona ten pinget hidi a ibut sakay magmadi. En kona hidi haud a pinget ay puronán sakay tutudán. ");
INSERT INTO prfNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Ni manatili kam dikoku sakay manatili dikomoy en upos ku hidi, ay iyatád ku dikomoy ányaman en agidán moy. ");
INSERT INTO prfNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Maparangalan en Ama ni magbunga kam ti makpal, ni konahud en mangyari ay mepeta moy a sikam ay disepulus ku. ");
INSERT INTO prfNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Mahal takam a kona ten págmahal nen Ama dikoku. Manatili kam ten págmahal ku. ");
INSERT INTO prfNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Ni sássunudán moy en utus ku hidi ay manatili kam ten págmahal ku. Kona dikoku, sássunudán ku en utus hidi nen Ama ku, kaya nanatiliyák ten págmahal na. ");
INSERT INTO prfNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","“Kinagi ku hidi iyád a bagay dikomoy tánni makabahagi kam bi ten kasayaan ku, sakay magin kompletu en kasayaan moy. ");
INSERT INTO prfNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Iddi en utus ku: magmahalan kam a kona ten págmahal ku dikomoy. ");
INSERT INTO prfNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Awan ti págmahal a mas higit pa ten págmahal nen essa a tolay a náng-alay ten biyag na para ten amigu na. ");
INSERT INTO prfNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Amigu takam ni sássunudán moy en utus ku hidi. ");
INSERT INTO prfNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Awan takamon dulawán a alipin gapu awan tukoy nen alipin en gággamitán nen amu na. Nan, dulawán takamon a amigu gapu kinagi ku dán dikomoy en atanan a nasanig ku ten Ama ku. ");
INSERT INTO prfNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Bakán a sikam en nangpili dikoku. Sikán en nangpili dikomoy sakay inutusan takam tánni magbunga kam ti makpal sakay en bunga moy ay manatili. Ni magkakonahud ay ányaman a agidán moy ten Ama ten pamamag-itan nen ngaran ku ay iyatád na dikomoy. ");
INSERT INTO prfNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Kaya iddi en utus ku dikomoy: magmahalan kam.” ");
INSERT INTO prfNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Ni maiyamut dikomoy i munduwiday ay dapat moy a matukuyan a naiyamut dán iyád dikoku bagu a sikam. ");
INSERT INTO prfNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Ni kabilang kam ti munduwiday ay mahalán di kam. Peru awan kam kabilang dikodi, nan pinili takam a gubwat dikodi. ");
INSERT INTO prfNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Tandaan moy en kinagi ku dikomoy a awan ti alipin a mas higit ten amu na. Ni inusigák di ay usigán di kam bi. Sakay ni sinunud di en utus ku ay sunudán di bi en kagiyán moy. ");
INSERT INTO prfNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Usigán di kam gapu ten pánnampalataya moy dikoku sakay gapu awan di tukoy en nangutus dikoku. ");
INSERT INTO prfNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Ni awanák ummangay háddi sakay nangaral dikomoy ay awan nakuwan hidi ti kasalanan. Peru nadid ay awan hidi ti merason ten kasalanan di. ");
INSERT INTO prfNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Ni deyaman en maiyamut dikoku ay maiyamut bi ten Ama ku. ");
INSERT INTO prfNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Ni awanák nanggamet ten atubengán di ti himala a awan nagamet ni maski deyaman ay awan nakuwan hidi ti kasalanan. Peru maski ni netan di dán en himala hidi a ginamet ku ay maiyamut padi hidi dikoku sakay ten Ama ku. ");
INSERT INTO prfNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Ti ginamet diyid a iyád ay natupad en nesulat ten Kautusan a: ‘Maiyamut hidi dikoku a awan ti dahilan.’ ");
INSERT INTO prfNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Peru en Tagagiyya en Ispiritu nen katutuhanan ay umangay háddi a gubwat ten Ama. Paangayán ku siya háddi a gubwat ten Ama, sakay siya en magpatunay tungkul dikoku. ");
INSERT INTO prfNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Sakay dapat kam bi a magpatunay tungkul dikoku gapu kaguman takamon sapul pa ten sapul.” ");
INSERT INTO prfNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Kagiyán ku atananid a iyád dikomoy tánni awan kam mawanan ti pánnampalataya dikoku. ");
INSERT INTO prfNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Palayasán di kam ten sinagoga hidi. Ti katunayanid dumemát en panahun a en deyaman a mangbunu dikomoy ay magakala a magserbi ten Diyos. ");
INSERT INTO prfNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Sakay gamitán di iyád gapu awanák di kilala maski en Ama. ");
INSERT INTO prfNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Peru kagiyán ku dikomoy bagayid a hidi iyád tánni, káddemát nen odas a gamitán di iyád, ay maala-ala moy a impadipalongu ku dán iyád dikomoy.” “Awan ku palla kinagi dikomoy bagayid a hidi iyád ten sapul gapu kagumanák moy palla. ");
INSERT INTO prfNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Peru nadid ay soliyák dán ten Ama ku a nagpaangay dikoku. Awan ti essa man dikomoy a nagtanung dikoku ni hádya angayan kuwid. ");
INSERT INTO prfNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Peru gapu kinagi ku dán dikomoy, ay naglungkut kam. ");
INSERT INTO prfNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Kaya kagiyán ku dikomoy en tatarudan: en kállakad ku ay para ten kapiyyaan moy, gapu awan angay dikomoy en Banal a Ispiritu ni awanák lumakad. Peru ni lumakadák, paangayán ku siya dikomoy. ");
INSERT INTO prfNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Sakay ni dumemát siya, ay patunayan na ten tolay hidi ti munduwiday a liwat en pákkatukoy di ten kasalanan, tungkul ten pagkamatuwid, sakay tungkul ten pághatul nen Diyos. ");
INSERT INTO prfNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Liwat hidi tungkul ten kasalanan, gapu awan hidi maniwala dikoku. ");
INSERT INTO prfNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Liwat hidi tungkul ten pagkamatuwid, gapu angayák ten Ama sakay awan moy dán ketan; ");
INSERT INTO prfNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","sakay tungkul ten pághatul nen Diyos, gapu nahatulan dán en pinunu ni munduwiday. ");
INSERT INTO prfNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Makpalák palla a kagiyán dikomoy, peru awan moy palla kaya a intendiyán nadid. ");
INSERT INTO prfNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Peru ni dumemát en Ispiritu nen katutuhanan ay igiyya na kam ten atanan a katutuhanan a gubwat ten Diyos. Gapu en kagiyán na ay bakán a gubwat ten sadili na, nan en nasanig na sakay ipahayag na dikomoy en mangyari hidi a pademát. ");
INSERT INTO prfNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Parangalanák na gapu tanggapán nen Ispiritu a gubwat dikoku en ipahayag na dikomoy. ");
INSERT INTO prfNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","En atanan nen ked ten Ama ay kao ku; kaya kinagi ku a tanggapán nen Ispiritu a gubwat dikoku sakay ipahayag na iyád dikomoy. ");
INSERT INTO prfNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Awan dálla malay ay awanák moy dán ketan; sakay awan la malay a panahun ay ketanák moy dámman a ruway.” ");
INSERT INTO prfNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Namágguron en agum ten disepulus na hidi, kinagi di, “Ánya wád gustu naid a kagiyán? Bakin kinagi na a awan dálla malay ay awan tamon siya ketan sakay awan dálla malay a panahun ay ketanák moy dámman a ruway? Kagi na pa a, ‘Gapu soliyák dán ten Ama ku.’ ");
INSERT INTO prfNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Ánya wád gustu naid a kagiyán ten, ‘Awan dálla malay?’ Awan tam maintendiyan!” ");
INSERT INTO prfNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Tukoy ni Jesus a gustu di a magtanung, kaya kinagi na, “Mamágtanungan kam tungkul ten kinagi ku a awan dálla malay ay awanák moy dán ketan; sakay kállipas nen badit pa a panahun, ay ketanák moy a ruway. ");
INSERT INTO prfNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Kagiyán ku dikomoy en tatarudan: magsanget kam sakay maglungkut peru magsaya i munduwiday. Subra en kalungkutan moy peru mapalitan iyán ti kasayaan. ");
INSERT INTO prfNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Ni magbati-bati dán en essa bábbi a magenak ay maghirap siya, gapu dummemát dán en odas nen pággenak na. Peru ni makaenak dán siya ay awan na dán maalala en hirap; gapu ten kasayaan na a neenak na dán ti munduwiday en anak na. ");
INSERT INTO prfNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Kona kam labi haud maglungkut kam nadid, peru mamagketa kitam a ruway sakay magkahud kam ti dikál a kasayaan ten pusu moy a awan ti makapangagew maski ni deya. ");
INSERT INTO prfNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Ti aldewid a iyud ay awan moy dán kailangan a magtanung dikoku. Tandaan moy: ányaman en agidán moy ten Ama ten pamamag-itan nen ngaran ku ay iyatád na dikomoy. ");
INSERT INTO prfNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Hanggan nadid ay awan kam palla ti inagid dikona ten pamamag-itan nen ngaran ku. Mággid kam, sakay tehud kam a matanggap, tánni makompletu en kasayaan moy.” ");
INSERT INTO prfNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Kagiyán ku hidi iyád dikomoy ti patalinhaga. Peru dumemát en panahun a awanák dán magupos dikomoy ti kona haád; diretsuwan ku dán a kagiyán dikomoy en tungkul ten Ama. ");
INSERT INTO prfNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Ti aldiwid a iyud ay mággid kam dikona ten pamamag-itan nen ngaran ku; sakay awan ku kagiyán a mággidák ten Ama para dikomoy, ");
INSERT INTO prfNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","gapu mahal kam nen Ama. Mahal na kam gapu mahalák moy sakay naniwala kam a gubwaták ten Diyos. ");
INSERT INTO prfNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Sikán ay gubwat ten Ama sakay ummangay ti munduwiday; nadid lumakadák dán ti munduwiday sakay soli dán ten Ama.” ");
INSERT INTO prfNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Kinagi nen disepulus na hidi, “Nadid diretsuwan dán pággupos muwen dikomi sakay bakán dán a patalinhaga! ");
INSERT INTO prfNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Nadid tukoy mi dán a tukoy mu atanan a bagay, sakay awan ka dán kailangan a tanungán nen deyaman. Gapu ti iyád ay maniwala kami a gubwat ka ten Diyos.” ");
INSERT INTO prfNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Tummábbig ti Jesus, “Talaga beman a maniwala kamon nadid? ");
INSERT INTO prfNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Dumemát en odas a nadid dán ngani a magkawatak-watak kam, magsadili kam ti lakad, sakay iwarakák moy. Peru, awanák mággeessa gapu kaguman ku en Ama. ");
INSERT INTO prfNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Kagiyán ku iyád dikomoy tánni magkahud kam ti kapayapaan ten pákpagkaessa moy dikoku. Tehud kam a kahirapan háddi ti munduwiday; peru begsákkan moy isip moyen! Napaglabanan ku dán i munduwiday!” ");
INSERT INTO prfNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Pákkakagi ni Jesus ti hidi iyud, ay tummangad siya dilanget sakay kinagi na, “Ama, dummemát dán en odas; parangalan mu dán en Anak mu tánni maparangalan na ka. ");
INSERT INTO prfNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Gapu inatáddanák mu ti kapangyariyan ten atanan a tolay, tánni mangatáddák ti biyag a awan ti katapusan ten atanan a inyatád mu ten Anak. ");
INSERT INTO prfNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Iddi en biyag a awan ti katapusan: en tenggiyán di ka a eessa sakay tunay a Diyos, sakay tenggiyán di ti Jesu-Cristo a inutusan mu. ");
INSERT INTO prfNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Impahayag ku ti lutaiday en karangalan mu; natapos ku dán en pinagamet mu dikoku. ");
INSERT INTO prfNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Kaya Ama, iyatád mu dikoku nadid en kaluwalhatian a ked dikoku dikona kagumanák mu bagu pa a lalangán i munduwiday. ");
INSERT INTO prfNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Impakilala taka ten tolay hidi a inyatád mu dikoku a gubwat ti munduwiday. Kao mu hidi, inyatád mu hidi dikoku, sakay tinupad di en upos mu. ");
INSERT INTO prfNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Nadid tukoy di dán a en atanan a bagay a inyatád mu dikoku ay gubwat dikomu; ");
INSERT INTO prfNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","gapu intoldu ku dikodi ni ánya en intoldu mu dikoku sakay tinanggap di bi. Nakasiguradu hidi a gubwaták dikomu, sakay maniwala hidi a siko en nangutus dikoku. ");
INSERT INTO prfNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Ipagdasal ku hidi, bakán a i munduwiday nan en atanan a inyatád mu dikoku, gapu kao mu hidi. ");
INSERT INTO prfNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Atanan ni kao ku ay kao mu, sakay atanan bi ni kao mu ay kao ku, sakay maparangalanák ten pamamag-itan di. ");
INSERT INTO prfNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Kaya nadid, soliyák dán dikomu; lumakadák dán ti munduwiday, peru ked palla hidi ti munduwiday. Ama a banal, ingatan mu hidi ten pamamag-itan nen kapangyariyan nen ngaran mu. En ngaran a inyatád mu dikoku tánni magkaessa hidi a kona dikota a eessa. ");
INSERT INTO prfNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Mentras kagumanák di, iningatan ku hidi ten pamamag-itan nen ngaran a inyatád mu dikoku. Inalagaan ku hidi sakay maski ni essa ay awan ti nepahamak dikodi, puwera la ten tolay a nangaryok ten kapahamakan na tánni matupad en kasulatan. ");
INSERT INTO prfNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Peru nadid, soliyák dán dikomu; sakay kagiyán ku iyád mentras kedák palla ti munduwiday, tánni magkahud bi hidi ti dikál a kasayaan a kona ten kasayaan ku. ");
INSERT INTO prfNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Ingkagi ku dán dikodi en upos mu, sakay kinaiyamutan hidi ni munduwiday gapu awan dán hidi taga-mundu, a kona dikoku a awan taga-mundu. ");
INSERT INTO prfNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Awan ku idasal a alapán mu hidi ti munduwiday, nan iligtas mu hidi ten Madukás! ");
INSERT INTO prfNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Awan hidi taga-mundu, kona dikoku a awan taga-mundu. ");
INSERT INTO prfNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Ilaan mu hidi ten pamamag-itan nen katutuhanan; en upos mu ay katutuhanan. ");
INSERT INTO prfNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Ni konyaák mu a inutusan ti munduwiday, ay kona bi hud inutusan ku bi hidi ti munduwiday. ");
INSERT INTO prfNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Sakay alang-alang dikodi ay ilaan ku sadili kuwidi dikomu, tánni melaan bi hidi dikomu ten pamamag-itan nen katutuhanan. ");
INSERT INTO prfNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Bakán la a hidi en ipagdasal ku, nan pati en manalig palla hidi dikoku ten pamamag-itan nen págbahagi di. ");
INSERT INTO prfNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Idasal ku a magkaessa nakuwan hidi a atanan Ama, a kona dikota a eessa. Kona labi hud mákkaessa nakuwan hidi dikota tánni maniwala i munduwiday a siko en nangutus dikoku. ");
INSERT INTO prfNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Inyatád ku dikodi en karangalan a inyatád mu dikoku tánni tunay a magin essa hidi a kona dikota a eessa. ");
INSERT INTO prfNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Sikán ay ked dikodi sakay siko ay ked dikoku, tánni tunay a magin essa hidi. Ni magkakonahud, ay matukoyan ni munduwiday a inutusanák mu sakay mahal mu hidi, kona ten págmahal mu dikoku. ");
INSERT INTO prfNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Ama, gustu ku a makaguman ten páppágyanan ku en inyatád mu hidi dikoku, tánni maáeleng di en karangalan a inyatád mu dikoku, gapu minahalák mu dán bagu pa lalangán i munduwiday. ");
INSERT INTO prfNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Matuwid a Ama, awan ka matenggi ni munduwiday, peru matenggi taka; sakay tukoy nen inyatád mu hidi dikoku a siko en nangutus dikoku. ");
INSERT INTO prfNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Impakilala taka dikodi, sakay tulos taka ipakilala pa, tánni en págmahal mu dikoku ay manatili dikoku, sakay sikán ay manatili bi dikodi.” ");
INSERT INTO prfNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Nadid, káttapos ni Jesus a nagdasal, ay ummangay siya sakay en disepulus na hidi ten dibelyu nen sapa a Kidron sakay ummangay hidi ten essa a lugar a mámmulaan ti Olibo. ");
INSERT INTO prfNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Kabisadu ni Judas a nángtokyon dikona i lugarid a iyud, gapu pirmi a angay haud ti Jesus sakay en disepulus na hidi. ");
INSERT INTO prfNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Kaya ummangay haud ti Judas a kaguman en sangan a pinunu nen mágbantay hidi ten Templo sakay essa a grupu a sundalu a Romano a gubwat ten pinunu hidi nen padi hidi sakay ten Pariseo hidi. Tehud hidi a tawid a parol, sulu sakay armas. ");
INSERT INTO prfNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Tukoy ni Jesus en atanan a mangyari dikona, kaya tinagbu na hidi sakay tinanung, “Deya aryokán moyid?” ");
INSERT INTO prfNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Tummábbig hidi, “Ti Jesus a taga-Nazaret.” Kinagi na dikodi, “Sikán ti Jesus.” Ti Judas a nángtokyon dikona ay katubeng di. ");
INSERT INTO prfNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Dikona kagiyán na dikodi a, siya ti Jesus, neatras hidi sakay natumba ten luta. ");
INSERT INTO prfNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Tinanung na hidi a ruway, “Deya beman aryokán moyid?” “Ti Jesus a taga-Nazaret,” tábbig di. ");
INSERT INTO prfNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Tummábbig ti Jesus, “Kinagi ku dán dikomoy a sikán ti Jesus. Ni sikán i aryokán moyid, ay pakultadan moy dán a lumakad i kakagumanan kuwidi hidi.” ");
INSERT INTO prfNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","(Kinagi na iyád tánni matupad en inupos na labi a, “Awan ti nepahamak maski ni essa man ten inyatád mu hidi dikoku, Ama.”) ");
INSERT INTO prfNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Sakay binagut ni Simon Pedro en áttak na sakay tinigpas na en alipin nen kapunuwan nen padi hidi. Naripas en kawanan a bángbáng nen alipin a en ngaran na ay ti Malco. ");
INSERT INTO prfNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Kinagi ni Jesus kánni Pedro, “Isarungan mu áttak muwen! Dapat ku a madanas en hirap a inyatád nen Ama dikoku.” ");
INSERT INTO prfNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Ti Jesus ay dinikáp sakay pinungu nen mágbantay hidi ten Templo sakay nen sundalu hidi a Romano, en amu di ay kapitan. ");
INSERT INTO prfNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Inyangay di pa siya a dipalongu kánni Anas, siya ay katugngan ni Caifas a kapunuwan a padi ti panahunid a iyud. ");
INSERT INTO prfNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Ti Caifas en nagpayu ten pinunu hidi nen Judio hidi a mas maganda a essa la a tolay i matayid alang-alang ten banuwan. ");
INSERT INTO prfNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Ti Pedro sakay ten essa pa a disepulus ay ummunonud kánni Jesus. Tukoy nen kapunuwan a padi i disepulusid a iyád, kaya nakasáddáp siya a kaguman ni Jesus ten laguwerta nen bilay nen kapunuwan a padi. ");
INSERT INTO prfNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Mentras a mágtáknág ti Pedro ten luwas nen pintuwan, lummuwas en disepulus a tukoy nen kapunuwan a padi. Kinauron na en katulung a dalaga a mágbantay ten pintuwan, sakay pinasáddáp na ti Pedro. ");
INSERT INTO prfNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Kinagi nen katulung a dalaga a mágbantay ten pintuwan kánni Pedro, “Awan beman essa ka ten disepulus hidi ni tolayid a iyán?” “Awan,” tábbig ni Pedro. ");
INSERT INTO prfNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Nagnamu en alipin hidi sakay ten guwardiya hidi gapu madágnen, nágtaknág hidi sakay nagindu. Kaguman di ti Pedro a nákpagindu. ");
INSERT INTO prfNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Tinanung nen kapunuwan a padi ti Jesus tungkul ten disepulus na hidi sakay ten itáttoldu na. ");
INSERT INTO prfNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Tummábbig ti Jesus, “Awanák ti inlihim ten tolay hidi, pirmiyák a magtoldu ten sinagoga hidi sakay ten Templo nen Judio hidi. Awanák ti kinagi a palihim. ");
INSERT INTO prfNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Bakin sikán i tanungán muwid? Tanungán moy en tolay hidi a nakasanig dikoku; tukoy di ni ánya en kinagi ku.” ");
INSERT INTO prfNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Pákkakagi na, ay dinapang siya nen essa ten mágbantay hidi a ked haud. “Bakin tinábbig mu ti kona haán en kapunuwan a padi?” tanung na. ");
INSERT INTO prfNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Tinábbig siya ni Jesus, “Ni nagupusák ti madukás, patunayan mu! Peru ni tatarudan en kinagi ku, bakin dinapangák mu?” ");
INSERT INTO prfNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Ti Jesus a nakapungu palla ay impeangay ni Anas kánni Caifas, en kapunuwan a padi. ");
INSERT INTO prfNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Mentras a ked palla haud ti Simon Pedro a magindu, ay tinanung di siya, “Awan beman essa ka bi ten disepulus hidi ni tolayid a iyán?” “Awan!” tábbig ni Pedro. ");
INSERT INTO prfNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Tinanung bi siya nen essa ten alipin hidi nen kapunuwan a padi, pensan nen lállaki a tinigpas ni Pedro ti bángbáng, “Awan beman siko en neta ku a kaguman ni Jesus ten lugar a págmulaan ti Olibo?” ");
INSERT INTO prfNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Impamen ni Pedro a ruway ti Jesus, sakay bigla bi a nagtarakket en manok. ");
INSERT INTO prfNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Sapul ten bilay ni Caifas, ay inyangay di ti Jesus ten palasyu nen gubernador. Dimadimang dán dikona nangyari iyud. Awan summáddáp en pinunu hidi nen Judio hidi ten palasyu nen gubernador, tánni awan hidi mebilang a awan karapatdapat a kuman ten Piyesta nen Aldew nen Págtalib. ");
INSERT INTO prfNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Kaya ti Pilato a gubernador ay linumuwas sakay kinagi na, “Ánya i mebintang moyid ti tolayid a iddi?” ");
INSERT INTO prfNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Tummábbig hidi, “Ni awan siya naggamet ti madukás, ay awan mi siya iyangay dikomu.” ");
INSERT INTO prfNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Kinagi ni Pilato dikodi, “Ikuyug moy siya sakay hatulan ayun ten kautusan moy.” Tummábbig en Judio hidi, “Awan kami ti kapangyariyan a humatul ti kamatayan ten deyaman.” ");
INSERT INTO prfNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","(Nangyari iyád tánni matupad en kinagi ni Jesus tungkul ten paraan nen kákkatay na.) ");
INSERT INTO prfNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Summáddáp a ruway ti Pilato ten palasyu sakay dinulawan na ti Jesus sakay kinagi na, “Siko beman en hari nen Judio hidi?” ");
INSERT INTO prfNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Tummábbig ti Jesus, “Siko beman i nakaisipid ti tanungid a iyán, oni tehud a nagkagi dikomu?” ");
INSERT INTO prfNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Tummábbig ti Pilato, “Judiowák beman? Kabanuwan muwen hidi sakay en pinunu hidi nen padi hidi i náng-angayid dikomu háddi. Ánya beman ginamet muwid?” ");
INSERT INTO prfNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Tummábbig ti Jesus, “En kahariyan ku ay bakán a ked ti munduwiday. Ni ked ti munduwiday i kahariyan kuwid, ay insurugák dán nakuwan nen disepulus ku hidi sakay awanák nakuwan netokyon ten Judio hidi. Peru bakán a ti munduwiday i kahariyan kuwid!” ");
INSERT INTO prfNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","“Ni konahud, essa ka a hari?” kagi ni Pilato. Tummábbig ti Jesus, “Siko dán en nagkagi a hariyák. Iyán dahilanid ni bakin neenakák sakay ummangay ti munduwiday: tánni ipangaral en tungkul ten katutuhanan. Mágsanig dikoku en deyaman a ked ten katutuhanan.” ");
INSERT INTO prfNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Kinagi ni Pilato dikona, “Ánya beman i katutuhananid?” Pákkakagi na ay lummuwas a ruway ti Pilato sakay kinagi na ten Judio hidi, “Awanák ti ketan a kasalanan ti tolayidi. ");
INSERT INTO prfNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Peru ayun ten kaugaliyan moy, ay dapaták a magpalaya ti essa a piresu ten Aldew nen Págtalib. Gustu moy beman a palayaán ku en Hari nen Judio hidi?” ");
INSERT INTO prfNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Namagpákrawan hidi a ruway, “Bakán a siya, nan ti Barrabas!” (Ti Barrabas ay essa a tulisan.) ");
INSERT INTO prfNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Kaya pinaalap ni Pilato ti Jesus sakay pinalatigu na. ");
INSERT INTO prfNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","En sundalu hidi ay nangalap ti masaet a mula, ginamet di a kurona, sakay ingkurona di kánni Jesus. Sakay binaduwan di siya ti inubi. ");
INSERT INTO prfNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Balang essa ay umadeni dikona sakay inusek di a binati, “Mabuhay en Hari nen Judio hidi!” Sakay dináddapang di siya. ");
INSERT INTO prfNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Lummuwas a ruway ti Pilato sakay kinagi na dikodi, “Iyatubeng ku siya dikomoy tánni matukuyan moy a awanák ti netan a kasalanan na!” ");
INSERT INTO prfNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Sakay inluwas di ti Jesus a tehud a kurona a saet sakay nakabadu ti inubi. Kinagi ni Pilato dikodi, “Malasán moy siya!” ");
INSERT INTO prfNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Pákketa dikona nen pinunu hidi nen padi hidi sakay nen guwardiya hidi ay nagpákrawan hidi, “Ipaku siya ten kudus! Ipaku ten kudus!” Kinagi ni Pilato dikodi, “Alapán moy siya, sakay bahala kam a mángpaku dikona, gapu awanák ti ketan a kasalanan na.” ");
INSERT INTO prfNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Tummábbig en Judio hidi, “Ayun ten kautusan mi ay dapat la siya a matay, gapu magkukunwari siya a Anak nen Diyos.” ");
INSERT INTO prfNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Dikona masanig ni Pilato en kinagi di ay neántingan siya ti hustu. ");
INSERT INTO prfNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Summáddáp siya a ruway ten palasyu sakay tinanung na ti Jesus, “Taga-hádya ka beman?” Peru awan tummábbig ti Jesus. ");
INSERT INTO prfNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Kinagi a ruway ni Pilato, “Umád ka beman a mákpágguron dikoku? Awan mu beman tukoy a maari taka a palayaán oni pepaku ten kudus?” ");
INSERT INTO prfNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Tummábbig ti Jesus, “Kaya mu la magamet iyán ay gapu impagkaluub nen Diyos dikomu i kapangyariyanid a iyán, kaya mas madággi en kasalanan nen náng-angay háddi dikoku.” ");
INSERT INTO prfNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Dikona masanig iyád ni Pilato, ay lalu na a ginustu a palayaán ti Jesus. Peru nagpákrawan en tolay hidi, “Ni palayaán mu tolayid a iyán, ay awan ka amigu nen Emperador! Deyaman en magkukunwari a hari ay kalaban nen Emperador.” ");
INSERT INTO prfNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Pákkasanig ni Pilato ay inluwas na ti Jesus, sakay nággetnud ten pághatulan, ten lugar a kákkagiyán a, “En Plataporma” (Gabata ten upos ni Hebreo). ");
INSERT INTO prfNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Aldew tenhud nen Pághanda para ten Piyesta nen Págtalib, sakay magalasdosi dán ten tanghali. Kinagi ni Pilato ten Judio hidi, “En hari moy dánnid!” ");
INSERT INTO prfNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Pummákraw hidi, “Bunuwán siya! Bunuwán! Ipaku ten kudus!” “Pepaku ku beman ten kudus en hari moy?” tanung ni Pilato. Tummábbig en pinunu hidi nen padi hidi, “Awan kami ti hari nan en Emperador la!” ");
INSERT INTO prfNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Kaya inyatád ni Pilato dikodi ti Jesus tánni pepaku ten kudus. Inalap di ngani ti Jesus. ");
INSERT INTO prfNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Kaya lummuwas siya a babáklay na en kudus na, tamu ten lugar a ngángngaranan a, “Lugar ni Bungu” (Golgota ten upos ni Hebreo). ");
INSERT INTO prfNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Káddemát haud, ay impaku di siya ten kudus a kaguman nen duwwa pa. Essa ten kawiri na sakay essa ten kawanan na, nágditángngaan di ti Jesus. ");
INSERT INTO prfNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Nagsulat ti Pilato ti kona háddi sakay impedátton na ten kudus: “Ti Jesus a taga-Nazaret, en Hari nen Judio hidi.” ");
INSERT INTO prfNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Nesulat iyád ti upos ni Hebreo, Latin, sakay Griego sakay makpal ten Judio hidi en nakabasa haud, gapu adeni ten banuwan en lugar a nángpakuwan di kánni Jesus. ");
INSERT INTO prfNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Kaya kinagi nen pinunu hidi nen padi hidi kánni Pilato, “Dyan mu isulat a Hari nen Judio hidi nan, ‘Kinagi ni tolayid a iddi a, Sikán en Hari nen Judio hidi.’ ” ");
INSERT INTO prfNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Tummábbig ti Pilato, “Ni ánya nesulat kuwid ay awan dán ti makapangbagu.” ");
INSERT INTO prfNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Dikona nepaku dán nen sundalu hidi ti Jesus, ay inalap di en badu na a malayon sakay pinagáppat di, essa ten kada sundalu. Inalap di bi en badu na a pangdisalad; iyád ay awan ti dirop buu sapul disunu hanggan ten dibábbi. ");
INSERT INTO prfNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Namágguron en sundalu hidi, “Dyan tam pisadán iyád; magbunutan kitam dálla para matukuyán tam ni kándeya iyád a meangay.” Nangyari iyád tánni matupad en nesulat ten Kasulatan a, “Naghati-hati di en badu ku; sakay nagbunutan hidi ni deya magkaowid ten badu ku a malayon.” Kona ngani haud en ginamet nen sundalu hidi. ");
INSERT INTO prfNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Mágtaknág ten kasadát nen kudus ni Jesus en ina na, sakay en kapatkaka nen ina na a ti Maria a kabinga ni Cleopas. Ked bi haud ti Maria Magdalena. ");
INSERT INTO prfNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Dikona ketan ni Jesus en ina na, sakay en mahal na a disepulus a kasadát nen ina na ay kinagi na, “Ina ku, siya dán iyán anak muwid!” ");
INSERT INTO prfNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Sakay kinagi na bi ten disepulus na, “Siya dán ina muwid!” Sapul haud ay pinágyan dán nen disepulus ti Maria ten bilay na. ");
INSERT INTO prfNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Káttapos ni iyád, ay tukoy ni Jesus a natupad dán atanan a bagay. Sakay para matupad en kasulatan ay kinagi na, “Mauwawák!” ");
INSERT INTO prfNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Tehud a essa a malukung haud a putat ti maapsot a alak. Insawsaw di haud en essa a damit, sakay inggalot ten pinget nen isopo sakay impasápsáp di kánni Jesus. ");
INSERT INTO prfNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Dikona masápsáp ni Jesus en alak ay kinagi na, “Natapos dán!” Dummukug siya sakay nabágsutan ti angás. ");
INSERT INTO prfNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Tenhud ay Aldew nen Pághanda, sakay awan gustu nen Judio hidi a ked la ten kudus en bangkay hidi ten Aldew nen Káimang (gapu dakila en Aldew nen Káimang). Kaya inagid di kánni Pilato a ipapilay na en pepengkel nen nágkepaku hidi ten kudus, sakay ibutan haud en bangkay hidi. ");
INSERT INTO prfNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Ummangay ngani haud en sundalu hidi sakay pinilay di en pengkel nen duwwa a nepaku a kasabay ni Jesus. ");
INSERT INTO prfNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Peru káadeni di kánni Jesus sakay netan di a patay dán siya, ay awan di dán pinilay en pengkel na. ");
INSERT INTO prfNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Peru essa ten sundalu hidi en nangpika kánni Jesus ten wares na, sakay bigla bummulos en digi sakay ten dinom. ");
INSERT INTO prfNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","En naketa háddi en magpatunay sakay en patunay na ay tatarudan. Tukoy na a magkagi siya ti tatarudan tánni maniwala kam. ");
INSERT INTO prfNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Nangyari atananid a iyád tánni matupad en kinagi nen kasulatan a, “Awan ti mabungál maski ni essa ten tulang na hidi.” ");
INSERT INTO prfNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Sakay nakagi bi ten iba a bahagi nen kasulatan a, “Áelingán di en pinika di.” ");
INSERT INTO prfNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Káttapos ni iyád, ay ti Jose a taga-Arimatea ay ummangay kánni Pilato tánni mák-agid ti permisu a maalap en bangkay ni Jesus. (Ti Jose ay essa a disepulus ni Jesus, peru sekretu la ngani gapu ten ánteng na ten Judio hidi.) Sakay pinayagan siya ni Pilato; kaya inalap na en bangkay ni Jesus. ");
INSERT INTO prfNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nákkuyug dikona ti Nicodemo, tehud a tawid a págpasárrub a manga-tállu a pulu a kilu nen pinaghalu a mira sakay aloe. (Siya en angay nákpágguron kánni Jesus ten gibi.) ");
INSERT INTO prfNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Inalap di en bangkay ni Jesus, sakay pinasárruban di mentras a balután ti damit a lino, ayun ten kaugaliyan nen Judio hidi. ");
INSERT INTO prfNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Ten nángpakuwan di kánni Jesus ay tehud a págmulaan, sakay tehud haud a essa a bigu a páglábbángngan a awan palla naglalábbángngan. ");
INSERT INTO prfNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Gapu tenhud ay saldew dálla bagu a Piyesta sakay gapu adeni la en páglábbánggan, ay haud di dán a inlábbáng ti Jesus. ");
INSERT INTO prfNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Nadid, págdemlag palla ten aldew nen Simba, ay ummangay dán ti Maria Magdalena ten páglábbángngan. Dinemáttan na a negulung dán en batu a siradu nen pintuwan nen páglábbángngan. ");
INSERT INTO prfNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Gapu haud, ay gummággenan siya a ummangay kánde Simon Pedro sakay ten disepulus a mahal ni Jesus, sakay kinagi na dikodi, “Inalap di en Panginoon ten páglábbángngan sakay awan mi tukoy ni hádya i náng-angayan diyid!” ");
INSERT INTO prfNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Kaya ti Pedro sakay ten disepulus a mahal ni Jesus ay ummangay ten páglábbángngan. ");
INSERT INTO prfNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Parehu hidi a gummággenan peru ti Pedro ay nadipalonguwan nen kaguman na a disepulus. ");
INSERT INTO prfNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Summedip siya ten disalad sakay netan na en damit a lino a dumáddátton haud, peru awan siya summáddáp. ");
INSERT INTO prfNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Kasunud na a dummemát ti Simon Pedro sakay diretsu a summáddáp ten páglábbángngan. Netan na en damit hidi a lino, ");
INSERT INTO prfNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","sakay ten damit a imbalut di ten ulu ni Jesus. Awan iyád kaguman nen damit hidi a lino, nan nehiwalay a nakáppel ten tapat nen páppágyanan na. ");
INSERT INTO prfNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Summáddáp bi en disepulus a dipalongu a dummemát; netan na iyud sakay naniwala siya. ");
INSERT INTO prfNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","(Awan di palla naintendiyan en nakasulat ten kasulatan, a kailangan a mabiyag a ruway ti Jesus.) ");
INSERT INTO prfNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Sakay nagsoli en disepulus hidi ten bilay di. ");
INSERT INTO prfNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Ti Maria ay mágtaknág a mágsasangitán ten luwas nen páglábbángngan; dummukug siya sakay summedip disalad. ");
INSERT INTO prfNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Sakay tehud siya a netan a duwwa a anghel a mággetnud ten nángdáttonan di ten bangkay ni Jesus, en essa ay ked ten áoluwan na sakay en essa bi ay ten áoyadan na. ");
INSERT INTO prfNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Tinanung di ti Maria, “Bakin magsanget ka?” Tummábbig siya, “Inalap di en Panginoon ku, sakay awan ku tukoy ni hádya i náng-angayan diyid.” ");
INSERT INTO prfNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Lummingat siya pákkakagi na, sakay netan na ti Jesus a mágtáknág haud, peru awan na natenggi a ti Jesus iyud. ");
INSERT INTO prfNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Tinanung siya ni Jesus, “Bakin magsanget ka? Deya aryokán muwid?” Akala ni Maria ay siya en mággalaga ten kamulaan, kaya kinagi na, “Maistu, ni siko i nangalapid dikona ay kagbiyan pay a itoldu dikoku ni hádya náng-angayan muwid ta angen ku.” ");
INSERT INTO prfNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","“Maria!” kagi ni Jesus. Ummatubeng siya sakay kinagi na, “Raboni!” gustu naid a kagiyán ay “Maistu.” ");
INSERT INTO prfNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Kinagi ni Jesus, “Dyanák mu tawidan, gapu awanák palla nakaangay ten Ama. Nan, angay ka ten kákkapatkaka ku hidi sakay kagiyán mu a soliyák dán ten Ama ku sakay ten Ama moy bi, ten Diyos ku sakay ten Diyos moy bi.” ");
INSERT INTO prfNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Kaya ummangay ti Maria Magdalena ten disepulus hidi sakay kinagi na, “Netan ku en Panginoon!” Sakay kinagi na dikodi en bilin ni Jesus. ");
INSERT INTO prfNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Kággibi na ti aldewid a iyud, ay namagipun-ipun en disepulus hidi ni Jesus. Nakasiradu en pintu nen bilay a namagipun-ipunan di gapu ten ánteng di ten Judio hidi. Dummemát ti Jesus sakay tummaknág ten ditángnga di. “Magkahud kam ti kapayapaan!” kagi na. ");
INSERT INTO prfNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Pákkakagi na, ay impeta na en lima na sakay ten wares na. Tunay ti saya en disepulus na hidi dikona netan di en Panginoon. ");
INSERT INTO prfNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Kinagi dámman a ruway ni Jesus dikodi, “Magkahud kam ti kapayapaan! Ni konyaák a inutusan nen Ama, ay kona bi hud, utusan takam bi.” ");
INSERT INTO prfNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Sakay dikona matapos na kinagi iyud, ay inangássan hidi ni Jesus sakay kinagi na, “Tanggapán moy en Banal a Ispiritu. ");
INSERT INTO prfNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Ni deya en patawadán moy ten kasalanan di hidi ay pinatawad dán ngani; en awan moy pinatawad ay awan ngani pinatawad.” ");
INSERT INTO prfNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Peru ti Tomas a nginaranan di a Kambal, a essa ten sapulu ay ti duwwa, ay awan haud dikona dummemát ti Jesus. ");
INSERT INTO prfNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Kaya kinagi dikona nen agum a disepulus, “Netan mi en Panginoon!” Tummábbig ti Tomas, “Awanák maniwala hanggan awan ku ketan en ábbut nen paku hidi ten lima na, sakay mesulot haud i guramát kuwidi sakay ten wares na.” ");
INSERT INTO prfNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Kállipas nen walu a aldew, ay namagipun-ipun a ruway en disepulus hidi; kaguman di ti Tomas. Nakasiradu en pintu, peru summáddáp ti Jesus sakay tummaknág ten ditángnga di. Kinagi na, “Magkahud kam ti kapayapaan!” ");
INSERT INTO prfNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Sakay kinagi na kánni Tomas, “Ilingán mu i lima kuwidi hidi sakay isulot mu dán i guramát muwen. Isulot mu dán bi i lima muwen ti wares kuwidi. Dyan ka dán magduda, maniwala ka dán.” ");
INSERT INTO prfNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tummábbig ti Tomas, “Panginoon ku sakay Diyos ku!” ");
INSERT INTO prfNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Kinagi ni Jesus dikona, “Maniwala ka dán beman gapu netanák mu dán? Pinagpala en maniwala hidi maski ni awanák di netan.” ");
INSERT INTO prfNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Todu padi a himala a ginamet ti Jesus a netan nen disepulus na hidi, peru awan nesulat ti libruwid a iyád. ");
INSERT INTO prfNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","En nakasulat hidi háddi ay insulat tánni sumampalataya kam a ti Jesus en Cristo, en Anak nen Diyos, sakay tánni magkahud kam ti biyag ten pamamag-itan na. ");
INSERT INTO prfNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Nadid káttapos, ay pummeta a ruway ti Jesus ten disepulus na hidi ten gilid nen Minalnu ti Tiberias. Kona háddi en pangyayari: ");
INSERT INTO prfNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","magkaguman de Simon Pedro, Tomas a nginaranan di a Kambal, Natanael a taga-Cana Galilea, en anak hidi ni Zebedeo, sakay ten duwwa pa a disepulus. ");
INSERT INTO prfNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Kinagi dikodi ni Simon Pedro, “Manilággák.” “Mákkuyug kami,” kagi di. Lummakad hidi sakay nágsakay ten abeng, peru awan hidi ti nalap ti gibiyid a iyud. ");
INSERT INTO prfNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Dikona págdemlag dán, ay tummaknág ti Jesus ten gilid nen minalnu, peru awan siya natenggi nen disepulus hidi. ");
INSERT INTO prfNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Kinagi na, “Anak, nakalap kam?” “Awan,” tábbig di. ");
INSERT INTO prfNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","“Isáklad moy i pantiyen ti danág ti kawanan ni abingen, sakay makalap kam,” kagi ni Jesus. Insáklad di ngani en panti sakay awan di maguyud ten kakpal nen nalap. ");
INSERT INTO prfNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Kinagi nen disepulus a mahal ni Jesus kánni Pedro, “En Panginoon iyud!” Dikona masanig iyud ni Simon Pedro ay nagbadu siya (gapu eklas siya) sakay summegbu siya ten dinom. ");
INSERT INTO prfNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","En kaguman na hidi a disepulus ay ummangay ten dinapan, mágsakay hidi ten abeng sakay totoroy di en panti a todu a nalap. Awan hidi masiyadu a adeyu ten dinapan manga siyam a pulu a metros la. ");
INSERT INTO prfNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Káapet di ten dinapan ay naketa hidi haud ti mabaga a genggeng a tehud a ikan a inyapoy, sakay ti sabadit a tinapay. ");
INSERT INTO prfNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","“Magtawid kam háddi ti ikanen a nalap moy,” kagi ni Jesus. ");
INSERT INTO prfNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Kaya summakay ti Simon Pedro ten abeng sakay binerber na ten dinapan en panti a todu a nalap a dáddekál a ikan, datos ay ti limma pulu ay ti tállu. Awan napisad en panti, maski sakonahud ti kakpal en ikan. ");
INSERT INTO prfNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","“Kamon haád ta magaramusal kitam,” kagi ni Jesus. Essa man ten disepulus hidi ay awan ti nangahas a magtanung dikona ni deya siya, gapu tukoy di a siya en Panginoon. ");
INSERT INTO prfNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Ummadeni ti Jesus, inalap na en tinapay sakay inyatád na dikodi, kona bi hud en ginamet na ten ikan. ");
INSERT INTO prfNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Iyád en katállu a káppeta ni Jesus ten disepulus na hidi sapul ten kákkabiyag na a ruway. ");
INSERT INTO prfNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Káttapos di a kumman, ay tinanung ni Jesus ti Simon Pedro, “Simon, anak ni Juan, mahalák mu beman nan hidi iddi?” “Opo, Panginoon, tukoy mu a mahal taka,” tábbig na. Kinagi ni Jesus dikona, “Pakanán mu en bábbadit ku hidi a tupa.” ");
INSERT INTO prfNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Tinanung siya a ruway ni Jesus, “Simon, anak ni Juan, mahalák mu beman?” Tummábbig ti Pedro, “Opo, Panginoon, tukoy mu a mahal taka.” Kinagi ni Jesus, “Alagaan mu en tupa ku hidi.” ");
INSERT INTO prfNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Katállu a ruway a tanung ni Jesus dikona, “Simon, anak ni Juan, mahalák mu beman?” Nalungkut ti Pedro gapu pentállu dán siya a tinanung ni Jesus ti: “Mahalák mu beman?” Sakay tummábbig siya, “Panginoon, tukoy mu atanan a bagay; tukoy mu a mahal taka.” Kinagi ni Jesus dikona, “Pakanán mu en tupa ku hidi. ");
INSERT INTO prfNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Pakatandaan mu: dikona anak ka palla, ay siko en mangbadu ti sadili muwen sakay makaangay ka ten gustu mu a angayan. Peru kállakay mu, ay iyolnat mu i lima muwen sakay iba en mangbadu dikomu sakay iyangay di ka ten awan mu gustu.” ");
INSERT INTO prfNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","(Kinagi na iyád tánni ipakapospos na ni konya a matay ti Pedro tánni maparangalan en Diyos.) Káttapos, ay kinagi ni Jesus dikona, “Arigánnák mu!” ");
INSERT INTO prfNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Lummingat ti Pedro sakay netan na a umunonud en disepulus a mahal ni Jesus, en summandig ten rakaw ni Jesus dikona mangapon hidi sakay nagtanung, “Panginoon, deya en mángtokyon dikomu?” ");
INSERT INTO prfNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Dikona ketan siya ni Pedro, ay tinanung na ti Jesus, “Panginoon, ánya bi i mangyariyid dikona?” ");
INSERT INTO prfNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Tummábbig ti Jesus, “Ni gustuwán ku a mabiyag siya hanggan kássoli ku, ánya nadid dikomu? “Arigánnák mu!” ");
INSERT INTO prfNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Kummalat ten kákkapatkaka hidi en bareta a awan matay i disepulusid a iyád, maski awan kinagi ni Jesus a awan siya mata-matay nan, “Ni gustuwán ku a mabiyag siya hanggan ten kássoli ku, ánya nadid dikomu?” ");
INSERT INTO prfNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Siya ngani en disepulus a mangpatunay tungkul ti bagayid a hidi iyád; siya bi en nángsulat ti iyád, sakay tukoy mi a tatarudan en págpatunay na. ");
INSERT INTO prfNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Sakay todu pa a ginamet ti Jesus a ni isulat a atanan, ay ti pangileng kuwidi ay awan meubus maski ti buuwiday a mundu en libru hidi a mesulat.");
INSERT INTO prfNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Mahal ku a Teofilo: Insulat ku ten purumeru ku a libru en atanan a ginamet sakay intoldu ni Jesus a magpasapul ten kadipalonguwan a ginamet na ");
INSERT INTO prfNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","hanggan ten aldew a indisunu siya nen Diyos dilanget. Bagu siya a indisunu ay ten tulung nen Banal a Ispiritu ay nagbilin siya ten apostol hidi a pinili na. ");
INSERT INTO prfNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Káttapos nen kákkatay na ay makpal a beses siya a pummeta ten apostol na hidi ti iba-iba a paraan. Haud a napatunayan a siya ay nabiyag a ruway. Ten luub nen áppat a pulu a aldew ay pummeta siya dikodi sakay nagtoldu tungkul ten pághari nen Diyos. ");
INSERT INTO prfNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Dikona kakaguman di palla ti Jesus ay binilin na en disepulus na hidi, “Dyan kam lumakad ti Jerusalem, urayán moy pa haud en kinagi ku dikomoy a pangaku nen Ama. ");
INSERT INTO prfNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Bininyagan kam ni Juan ti dinom peru awan magmalay ay mabinyagan kam ti Banal a Ispiritu. ");
INSERT INTO prfNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Dikona ruway a namagipun de Jesus ay ten disepulus na hidi ay tinanung di siya, “Panginoon, pasoliyán mu dán beman en pághari ni Israel?” ");
INSERT INTO prfNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Kinagi ni Jesus, “En panahun sakay en odas ay intakda nen Ama ten kapangyariyan na. Sakay awan moy kailangan a matukuyan ni nikan. ");
INSERT INTO prfNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Peru makatanggap kam ti kapangyariyan káddibábbi dikomoy nen Banal a Ispiritu, sakay sikam ay magin tagapagpatunay ku ti Jerusalem, ti buu a Judea sakay Samaria sakay hanggan ten kasuluk-sulukan ni munduwiday. ");
INSERT INTO prfNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Káttapos na a nagupos ay indisunu siya nen Diyos dilanget. Tumáttangad en disepulus na hidi hanggan dikona nataklábban dán siya nen panganurin. ");
INSERT INTO prfNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Pasiya hidi a umáeleng dilanget ten dikona a tehud a duwwa a lállaki a nakabadu ti mapudew a tummaknág ten adeni di sakay nagupos a ");
INSERT INTO prfNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","kinagi di, “Sikam a taga-Galilea hidi, bakin tumáttaknág kam háddi sakay umáeleng dilanget? Ti Jesus a dummisunu dilanget ay dumemát en aldew a soli labi háddi a kona ten netan moy a káddisunu na.” ");
INSERT INTO prfNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","En apostol hidi ay nagsoli ten siyudad a Jerusalem. Gubwat hidi ten bukid a Olibo hidi a dummisunuwan ni Jesus, manga essa a kilumetru en kadeyu na ti Jerusalem. ");
INSERT INTO prfNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Hidi iyád a apostol ay de Pedro, Juan, Santiago, Andres, Felipe, Tomas, Bartolome, Mateo, Santiago a anak ni Alfeo, ti Simon a makabanuwan, sakay ti Judas a anak ni Santiago. Káddemát di ten táttulusan di a bilay ten siyudad ay summangkay hidi ten kuwartu ten disunu. ");
INSERT INTO prfNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Namagkaessa en apostol hidi a pirmi a mamagipun-ipun a magdasal. Kaguman di en bábbi hidi sakay ti Maria a ina ni Jesus, sakay en kákkapatkaka hidi ni Jesus a lállaki. ");
INSERT INTO prfNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Kállipas nen sangan a aldew ay nagipun-ipun en mánnampalataya hidi a umabut ti datos ay ti duwapulu. Tummaknág ti Pedro ten atubengán di sakay nagupos, ");
INSERT INTO prfNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Kákkapatkaka ku hidi, kailangan a matupad en nakasulat ten banal a Kasulatan dikona pinagupos nen Banal a Ispiritu ti David tungkul kánni Judas a nánggiya ten págdikáp di kánni Jesus. ");
INSERT INTO prfNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Ti Judas ay dati a kabilang nen grupu mi sakay kaguman ten págserbi mi.” ");
INSERT INTO prfNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","En pilak a nebayad kánni Judas ten pángtokyon na kánni Jesus ay imbali na ti luta. Haud siya a natáknig a nággusok sakay tulos dán a nabágsutan ti angás, sakay pinomdek pa en tiyan na sakay lummuwas en bituka na. ");
INSERT INTO prfNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Nabareta iyád nen atanan tolay a taga-Jerusalem kaya ten upos di ay nginaranan di i lugarid a iyud ti Akeldama, gustu naid a kagiyán ay Uma ni Digi. ");
INSERT INTO prfNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Kinagi pa ni Pedro, “Nakasulat ten Libru nen Kansiyon hidi a, ‘En bilay na ay dyan dán adeniyan sakay dyan dán págyanan maski ni deya.’ Nakasulat bi a, ‘Dapat a tehud a mangpalit dikona ten tungkulin na.’ ");
INSERT INTO prfNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","“Kaya dapat kitam a mangpili ti essa a makakaguman mi bilang magpatunay ten ruway a kákkabiyag ni Jesus. Kailangan tamid a piliyán ay essa ten grupu mi a nalay mi dán a kakaguman sapul pa ten dikona kaguman mi palla ti Jesus sakay sapul dikona bininyagan siya ni Juan hanggan ten káangay na dilanget.” ");
INSERT INTO prfNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Kaya nangpili hidi ti duwwa a lállaki a pagpiliyan di, de Matias ay ti Jose. Ti Jose ay ngángngaranan di labi a Barsabas oni Justo. ");
INSERT INTO prfNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Nadid nagdasal hidi, “Panginoon, tukoy mu en ked ten isip nen balang essa a tolay kaya kagbiyan mu pay a ipakapospos dikomi ni deya ti duwwa iday i pinili muwid ");
INSERT INTO prfNT_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","a magin apostol a kapalit ni Judas ten tungkulin na a linakadan na. Nadid ay ked dán siya ten lugar a pinili na.” ");
INSERT INTO prfNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Káttapos di a nagdasal ay nagbunutan hidi ni deya ten duwwa en mapili di. Sakay en napili ay ti Matias kaya siya en indagdag di ten sapulu ay ti essa a apostol. ");
INSERT INTO prfNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Dikona dummemát en aldew a Pentecostes ay nagipun-ipun ti essa a lugar en atanan nen mánnampalataya hidi. ");
INSERT INTO prfNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Tehud hidi a bigla a nasanig a maggalungogung a kumán a en tánnug nen mabegsák a parás a gubwat dilanget. En galungogung ay masanig maski hádya man a suluk nen bilay a págyanan di. ");
INSERT INTO prfNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Naketa hidi ti kumán hidi a dila a apoy a kummalat sakay ummangay ten balang essa dikodi. ");
INSERT INTO prfNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Sakay minágkaputat hidi a atanan ti Banal a Ispiritu, sakay nakapagupos hidi ti iba-iba a upos ayun ten inkaluub nen Ispiritu ten balang essa dikodi. ");
INSERT INTO prfNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Nadid, makpal a relihiyoso a Judio tenhud a ked ti Jerusalem a gubwat ti iba-iba a bansa ti munduwiday. ");
INSERT INTO prfNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Dikona nasanig di en maggalungogung ay nagdemáttan en makpal a tolay ten páppágyanan nen mánnampalataya hidi. Tunay en págtaka di gapu makapagupos dán en mánnampalataya hidi ten upu-upos di. ");
INSERT INTO prfNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Gapu ten págtaka di ay namagtanungan hidi a kinagi di, “Awan beman taga-Galilea hidi a atanan? ");
INSERT INTO prfNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Bakin tukoy di dán a magupos ten balang upos tam? ");
INSERT INTO prfNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Tehud dikotam a taga-Partia, tehud a taga-Media, taga-Elam, tehud a gubwat ti Mesopotamia, ti Judea sakay Capadocia, ti Ponto, sakay Asia. ");
INSERT INTO prfNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Tehud pa dikotam a taga-Frigia sakay Pamfilia, Egipto sakay en lugar hidi a sakup ni Libya a adeni ti Cirene. En agum dikotam ay taga-Roma, ");
INSERT INTO prfNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Judio ay ti Hentil a naakit ti pánnampalataya ni Judio, sakay en agum dikotam ay taga-Creta sakay Arabia. Konya di a nakagi ten balang upos tam en makataka hidi a bagay a ginamet nen Diyos?” ");
INSERT INTO prfNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Awan di maabut a maisip en nangyari kaya awan matapos-tapos en pamagtanungan di ni ánya i kahuluganid iyud. ");
INSERT INTO prfNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Peru sinesti di en agum hidi a kinagi di, “Lasing la hidi iyán!” ");
INSERT INTO prfNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Nadid, gapu ten kinagi di ay tummaknág ti Pedro kaguman en sapulu ay ti essa a apostol sakay nagupos siya ti mabegsák. Kinagi na, “Sikam a kasa-Judio ku hidi sakay ten agum pa hidi a mágyan ti Jerusalem, mágsanig kam ti mapiyya ta kagiyán ku dikomoy kahuluganid ni iyád. ");
INSERT INTO prfNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Ipakapospos ku dikomoy a hidi iyád a tolay ay awan lasing a kona ten ked ti isip moyen gapu alas nuwebi palla ti dimadimang. ");
INSERT INTO prfNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Dyan kam magtaka ta iyád dán en hula ni propeta Joel, ");
INSERT INTO prfNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Kona háddi i gamitán kuwid ten dimudyan a aldew,’ kagi nen Diyos, ‘Pagkaluuban ku ti Ispiritu ku en atanan a tolay. Kaya ipangaral nen anak moy hidi a lállaki ay ti bábbi en mensahi ku. En binatilyu moy hidi ay maketa ti pangitain. Sakay en lállakay hidi ay magkahud ti tagináp. ");
INSERT INTO prfNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Ti aldewid a iyud ay pagkaluuban ku bi ti Banal a Ispiritu en tagapagserbi ku hidi, lállaki ay ti bábbi sakay ipakapospos di en mensahi ku. ");
INSERT INTO prfNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Mángpetaák ti himala hidi dilanget sakay ti makataka hidi a bagay ti lutaiday. magkahud ti digi, apoy, sakay mabagál a asok. ");
INSERT INTO prfNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Dumiklám en aldew, sakay dumidig en bulan a kona ten digi bagu a dumemát en aldew a dakila sakay maluwalhati a kássoli nen Panginoon. ");
INSERT INTO prfNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Sakay ti panahunid a iyud en atanan a mággid ti tulung ten ngaran nen Panginoon ay maligtas.’ ");
INSERT INTO prfNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“Sikam a Israelita hidi pakasanigán moy iddi! Ti Jesus a taga-Nazaret ay talaga a siya en pinaangay nen Diyos ti lutaiday. Mapatunayan iyád nen himala hidi sakay nen makataka hidi a bagay a ginamet nen Diyos ten pamamag-itan na. Tukoy moy hidi iyád a atanan gapu nangyari iyád ten atubengán moy. ");
INSERT INTO prfNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Peru ti Jesus a netokyon dikomoy ayun ten kagustuwan nen Diyos sapul pa ten sapul ay impepaku moy sakay pinabunu moy ten makasalanan hidi a tolay. ");
INSERT INTO prfNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Peru nadid ay biniyag siya a ruway nen Diyos sakay pinalaya na siya ten kapangyariyan nen kamatayan, gapu maski nikan ay awan siya maari a mepiresu ni kamatayan. ");
INSERT INTO prfNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Kona ten kinagi ni David tenhud tungkul dikona, ‘Tukoy ku a pirmi ku a kaguman en Panginoon, kaya awanák mabalisa gapu kaguman ku siya. ");
INSERT INTO prfNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Sakay magpuri i pusu kuwidi ta mabiyagák a tehud a pag-asa ");
INSERT INTO prfNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Gapu tukoy ku a awanák mu pabayan ten lugar nen patay hidi; sakay awan mu pabayan a marunot en Banal mu a Tagapagserbi. ");
INSERT INTO prfNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Intoldu mu dikoku en tama a dilan tánni mabiyagák, putaták ti kasayaan gapu kakaguman taka.’ ");
INSERT INTO prfNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“Kákkapatkaka ku hidi, kagiyán kuwiday dikomoy a en ninunu tam a ti hari a David ay natay sakay nelábbáng, ti katunayan na ay ked palla en lábbáng na a hanggan nadid. ");
INSERT INTO prfNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Siya ay propeta sakay tukoy na en impangaku nen Diyos dikona, a essa ten maggubwat ten lahi na ay magin hari a kona labi dikona. ");
INSERT INTO prfNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Kaya en kákkabiyag a ruway nen Cristo en netan na sakay impahayag dikona a kinagi na a, ‘Awan na siya pinabayan ten págyanan nen patay hidi, sakay awan na pinarunutan en bággi na.’ ");
INSERT INTO prfNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Ti Jesus ay biniyag a ruway nen Diyos, mapatunayan mi iyud a atanan gapu netan mi. ");
INSERT INTO prfNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Kaya minággetnud siya ten kawanan nen Diyos, sakay tinanggap na ten Ama en nepangaku a Banal a Ispiritu. Iyád en imbuhus na dikomi a kona ti áelingán moyen sakay sássanigán nadid. ");
INSERT INTO prfNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Bakán a ti hari a David en ummangay dilanget, nan kinagi na la a, ‘Kinagi nen Panginoon ten Panginoon ku a, “Mággetnud ka ti kawanan kuwidi, ");
INSERT INTO prfNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","hanggan ni tulos ku dán a mapasuku dikomu en kadima mu hidi.’ ” ");
INSERT INTO prfNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Kaya dapat a matukuyan ni buu a Israel a ti Jesus a impepaku moy ten kudus ay siya en ginamet nen Diyos a Panginoon sakay Cristo!” ");
INSERT INTO prfNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Nabalisa hidi ten nasanig di kaya kinagi di kánni Pedro sakay ten agum hidi a apostol, “Kákkapatkaka mi hidi, ánya dapat miyid a gamitán nadid?” ");
INSERT INTO prfNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Tummábbig ti Pedro, “Pagsisiyan moy dán sakay adággan en kasalanan moy hidi sakay magpabinyag kam ten ngaran ni Jesu-Cristo tánni mapatawad kam, sakay ipagkaluub na dikomoy en Banal a Ispiritu. ");
INSERT INTO prfNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Gapu iyád a pangaku nen Diyos ay para dikomoy sakay ten anak moy hidi, sakay para ten atanan a tolay a ked ti adeyu, sakay ten balang essa a dulawán nen Panginoon a Diyos.” ");
INSERT INTO prfNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Makpal pa a impahayag ti Pedro tánni pangpatunay ten kinákkagi na, sakay kinagiyan na hidi, “Iligtas moy i sadili moyen ten parusa a dumemát ti lahiyid a iddi a mágkadukás.” ");
INSERT INTO prfNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Káttapos ay naniwala en makpal a tolay ten kinagi na sakay nagpabinyag hidi kaya tehud a tállu a libu a tolay en nedagdag ten mánnampalataya hidi ti aldewid a iyud. ");
INSERT INTO prfNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Nanatili hidi ten intoldu nen apostol hidi ten pamagipun-ipun di a bilang matátkaka, ten págtáppeng-táppeng di ti tinapay, sakay ten págdasal di. ");
INSERT INTO prfNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Gapu ten makpal a himala sakay makataka-taka a nagamet ten pamamag-itan nen apostol hidi ay nanteng en atanan nen tolay hidi. ");
INSERT INTO prfNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Namagipun-ipun en atanan nen mánnampalataya hidi sakay en ari-ariyan di hidi ay para ten atanan. ");
INSERT INTO prfNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Ilaku di en ari-ariyan di hidi sakay en naglakuwan ay ipagatád di ten kakagumanan di hidi ayun ten pangangailangan nen balang essa. ");
INSERT INTO prfNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Mamagipun-ipun hidi ten Templo kada a aldew, sakay mamagkaguman hidi ten págtáppeng-táppeng di ti tinapay ten bila-bilay di, masaya hidi a mamággatubeng a kuman a tehud a malinis a kaluuban. ");
INSERT INTO prfNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Mágpapuriyán hidi a pirmi ten Diyos, sakay igalang hidi nen tolay hidi a taga haud. Kada aldew ay tehud a iligtas en Diyos sakay idagdag na ten dati dán a grupu nen mánnampalataya. ");
INSERT INTO prfNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Ten essa a aldew a alas tres ten apon, odas nen págdasal ay ummangay de Pedro ay ti Juan ten Templo. ");
INSERT INTO prfNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Ten adeni nen kákkagiyán di a Maganda a Pintuwan ay tehud a essa haud a lállaki a lupug sapul ten kákkeenak na. Iyáangay di siya haud aldew-aldew tánni máklimus ten sumáddáp hidi ten Templo. ");
INSERT INTO prfNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Dikona netan na de Pedro ay ti Juan a summáddáp ten Templo ay náklimus siya. ");
INSERT INTO prfNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Ináeleng siya nen duwwa ti mapiyya sakay kinagi ni Pedro, “Umileng ka dikomi!” ");
INSERT INTO prfNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Ummileng ngani siya gapu akala naid ay limusan di siya. ");
INSERT INTO prfNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Peru kinagi ni Pedro, “Awanák ti pilak oni gintu peru iyatád ku dikomu ni ánya en ked dikoku. Ten pamamag-itan nen kapangyariyan ni Jesu-Cristo a taga-Nazaret ay maglakad ka dán.” ");
INSERT INTO prfNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Sakay tinawidan na en kawanan a lima nen lupug sakay intaknág na. Káttapos ay pagdaka a bummegsák en babásset nen lupug, ");
INSERT INTO prfNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","lummuksu sakay nagsapul a naglakad. Dikona summáddáp hidi ten Templo ay kaguman di dán siya a máglaluksu-luksuwán ten saya na sakay mágpapuriyán ten Diyos. ");
INSERT INTO prfNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Netan nen atanan a makalakad dán siya sakay magpuri ten Diyos. ");
INSERT INTO prfNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Kaya tunay en págtaka di ta matenggi di a siya en pirmi a máklimus a lupug a mággetnud ten Maganda a Pintuwan nen Templo. ");
INSERT INTO prfNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Nadid kasalukuyan a kumákkabit en lupug kánde Pedro ay ti Juan ten lugar a ngángngaranan a portiko ni Solomon ay nagginan a ummadeni dikodi en tolay hidi gapu tunay en págtaka di ten makataka a nangyari. ");
INSERT INTO prfNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Pákketa ni Pedro ten tolay hidi ay kinagi na, “Sikam a Israelita hidi, bakin magtaka kam ti nangyariyid a iddi? Bakin ilingán moy kami ti kona haán? Isip moy wáddid ay napaglakad mi siya ten pamamag-itan nen sadili mi a kapangyariyan oni gapu hustu en kabanalan mi? ");
INSERT INTO prfNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Pinarangalan nen Diyos nen ninunu tam hidi a de Abraham, Isaac sakay ti Jacob en Tagapagserbi na ti Jesus a ingkasu moy sakay intakwil ten atubengán ni Pilato, maski ni gustu dán ni Pilato a palayaán. ");
INSERT INTO prfNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Inadiyan moy en Banal sakay Matuwid, mas ginustu moy pa a paluwasán ten págpiresuwan en mágbabonu. ");
INSERT INTO prfNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Binunu moy en Pággubwatan ni biyag, peru biniyag siya a ruway nen Diyos. Sikami a mismu en naketa ti pangyayariyid a iyud. ");
INSERT INTO prfNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","En kapangyariyan nen ngaran ni Jesus en nangpapiyya ti lállakiyid a iddi, nangyari iyád gapu ten pánniwala na ten ngaran ni Jesus. En pánnampalataya na kánni Jesus i tatarudanid a nagpiyyaan na a kona ti netan moyen. ");
INSERT INTO prfNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Kaya nadid kákkapatkaka ku hidi, tukoy ku a awan moy tukoy en ginagamet moy, kumona bi ten pinunu moy hidi. ");
INSERT INTO prfNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Gapu ten pángbunu moy kánni Cristo ay natupad dán en impakapospos nen Diyos dikotam tenhud pa, ten pamamag-itan nen atanan a propeta a kailangan a maghirap en Cristo. ");
INSERT INTO prfNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Kaya nadid ay magsisi kamon sakay magsoli kamon ten Diyos a inadággan moy tánni patawadán na en kasalanan moy, ");
INSERT INTO prfNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","sakay tánni dumemát dán en panahun nen kapahingaan a gubwat ten Panginoon. Paangayán na dikomoy ti Jesus, en Cristo a napili sapul pa tenhud para dikomoy. ");
INSERT INTO prfNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Peru kailangan a mágyan pa ti Jesus dilanget hanggan ten aldew nen pángbagu nen Diyos ten atanan a bagay ayun ten impakapospos na ten pamamag-itan nen propeta hidi tenhud pa. ");
INSERT INTO prfNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Gapu kinagi ni Moises a, ‘En Panginoon moy a Diyos ay mangpili dikomoy ti essa a gamitán na a propeta a kona dikoku. Sunudán moy en atanan a kagiyán na dikomoy. ");
INSERT INTO prfNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Sakay ni deyaman en awan mangsanig ti propetaid a iyud ay ihiwalay ten tolay hidi nen Diyos sakay mawasak.’ ");
INSERT INTO prfNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Maski en propeta hidi tenhud pa a panahun, magsapul kánni Samuel hanggan ten ummunud hidi dikona ay nángpakapospos tungkul ten mangyari ti nadididay a panahun. ");
INSERT INTO prfNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","En pangaku hidi nen Diyos a kinagi nen propeta hidi ay para dikomoy sakay kabilang kam ten ginamet a kasunduwan nen Diyos ten ninunu moy hidi dikona kinagi na kánni Abraham a, ‘Pagpalaán ku en atanan a lahi ti munduwiday ten pamamag-itan nen lahi mu.’ ");
INSERT INTO prfNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Kaya káttapos a biyagán nen Diyos en Tagapagserbi na, ay pinaangay na siya a dipalongu dikomoy tánni pagpalaán sakay tulungan na kam a umadág ten madukás moy a kákkabiyag.” ");
INSERT INTO prfNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Nadid, dikona pasiyaan palla a magupos de Pedro ay ti Juan ten tolay hidi ay dummemát en padi hidi sakay en pinunu nen guwardiya hidi ten Templo kaguman di bi en Saduseo hidi. ");
INSERT INTO prfNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Maiyamut hidi a tarud kánde Pedro ay ti Juan gapu impangaral di ten tolay hidi a biniyag a ruway nen Diyos ti Jesus bilang patunay a mabiyag bi a ruway en nágkatay dán hidi. ");
INSERT INTO prfNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Kaya dinikáp di en duwwa sakay impiresu di palla hidi hanggan ten kailawan gapu gibi dán tenhud. ");
INSERT INTO prfNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Konapamanhud, makpal ten nakasanig hidi ten impangaral di ay summampalataya hidi kánni Jesus, en lállaki palla hidi ay tehud dán a limmang libu. ");
INSERT INTO prfNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Kinailawan, ay nagipun-ipun ti Jerusalem en pinunu hidi nen Judio hidi, en pinunu hidi nen banuwan, sakay en tagapagtoldu hidi nen Kautusan. ");
INSERT INTO prfNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Ked haud ti Anas a kapunuwan nen padi hidi sakay de Caifas, Juan sakay Alejandro sakay en kamag-anak hidi ni Anas. ");
INSERT INTO prfNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Pinaatubeng di en duwwa a apostol sakay tinanung di hidi, “Ánya a kapangyariyan oni kándeya a ngaran i ginamit moyid ten pággamet moy ti bagayid a hidi iyád?” ");
INSERT INTO prfNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Kaya nagupos ti Pedro a tehud a kapangyariyan nen Banal a Ispiritu a kinagi na, “Sikam a tagagiyya hidi sakay pinunu nen banuwan, ");
INSERT INTO prfNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","ni gustu moy kami nadid a usisaán tungkul ten ginamet mi a maganda ti lupugiday, sakay ni konya siya a nagpiyya ");
INSERT INTO prfNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","ay kailangan a matukuyan moy a atanan, sakay kona bi dikomoy a atanan a lahi hidi ni Israel a i tolayidi a mágtaknág ti atubengán moyen ay nagpiyya gapu ten kapangyariyan nen ngaran ni Jesu-Cristo a taga-Nazaret a impepaku moy ten kudus peru biniyag a ruway nen Diyos. ");
INSERT INTO prfNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Tungkul kánni Jesus en nakasulat ten Kasulatan a, ‘En batu a inadiyan moy a mágbilay hidi, ay siya en nagin adigi a pamireng.’ ");
INSERT INTO prfNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Kánni Jesu-Cristo tam la a ketan en kaligtasan, gapu ti buuwiday a mundu ay awan ti agum a ngaran a kinagi en Diyos para ten kaligtasan nen tolay ni awan ti Jesu-Cristo la. ");
INSERT INTO prfNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Nagtaka en buu a Sanedrin ten begsák isip de Pedro ay ti Juan lalu dán dikona a netan di a mababa la hidi a tolay sakay awan nagadal. Sakay natukuyan di bi a dati hidi a kakagumanan ni Jesus. ");
INSERT INTO prfNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Gustu di a barángngán en ginamet di a himala peru en tolay a pinagpiyya di ay ked haud a mágtaknág a kasadát de Pedro ay ti Juan kaya awan hidi ti nakagi. ");
INSERT INTO prfNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Kaya en ginamet di ay pinaluwas di pala en apostol hidi ten lugar a namagipunan di sakay namágguron hidi. ");
INSERT INTO prfNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","“Ánya i gamitán tamid nadid dikodi? Nadid tukoy dán nen atanan a taga-Jerusalem en ginamet di sakay awan tamon mepamen en himala a ginamet di. ");
INSERT INTO prfNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Kona háddi i gamitán tamid tánni awan lalu a kumalat iyád a bagay ay bawalan tam hidi ti mahigpit a dyan dán hidi magupos maski kándeya tungkul kánni Jesus.” ");
INSERT INTO prfNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Kaya pinadulaw di a ruway de Pedro sakay binawalan di hidi a dyan dán magupos oni magtoldu tungkul kánni Jesus. ");
INSERT INTO prfNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Peru tummábbig de Pedro ay ti Juan, “Sikamon i manghatulid ni ánya en tama sakay en maganda ten atubengán nen Diyos, sumunud kami dikomoy oni sumunud kami ten Diyos. ");
INSERT INTO prfNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Peru para dikomi ay awan maari a awan mi ipakapospos en netan mi sakay en nasanig mi tungkul kánni Jesus.” ");
INSERT INTO prfNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Ten pákkasanig nen mággimbistiga hidi ay lalu di hidi a binawalan ti mahigpit a dyan magtoldu tungkul kánni Jesus, káttapos ay pinalakad di dán hidi. Awan hidi ti maisip a paraan tánni maparusaan hidi gapu en tolay hidi ay magpuri ten Diyos gapu ten nangyari. ");
INSERT INTO prfNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","En lállaki a pinagpiyya di ay mahigit dán a áppat a pulu a taon en idad na. ");
INSERT INTO prfNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Dikona nakaluwas dán de Pedro ay ti Juan ay ummangay hidi ten kakagumanan di hidi sakay imbareta di en kinagi nen pinunu hidi nen padi hidi sakay nen pinunu hidi nen banuwan. ");
INSERT INTO prfNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Dikona masanig di iyád ay namagkaessa hidi a nagdasal ten Diyos a kinagi di, “Panginoon a nakabahala ten atanan, siko en nanglalang ten langet, ti lutaiday sakay ten diget sakay ten atanan a bagay a ked haád. ");
INSERT INTO prfNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Siko en nagupos ten pamamag-itan nen ninunu mi a ti David a tagapagserbi mu ten dikona a kagiyán na ten tulung nen Banal a Ispiritu a, ‘Bakin tunay ti iyamut en Hentil hidi, sakay nagbalak hidi ti baka-bakán. ");
INSERT INTO prfNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Naghanda en hari hidi ti lutaiday tánni lumaban, sakay nagipun-ipun en pinunu hidi tánni lumaban ten Diyos sakay ten Pinili na.’ ");
INSERT INTO prfNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Natupad ngani iyád dikona a nagkaessa de Herodes ay ti Poncio Pilato, kaguman en Hentil hidi sakay en buu a Israel. Namagkaessa hidi kontra ten banal a Tagapagserbi mu a ti Jesus, a Pinili mu. ");
INSERT INTO prfNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Naipun hidi tánni matupad en dapat a mangyari ayun ten intakda mu tenhud pa. ");
INSERT INTO prfNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Nadid, Panginoon, bábbantaan di kami kaya tulungan mu kami a tagapagserbi mu hidi a magkahud kami ti begsák isip a ipangaral en upos mu. ");
INSERT INTO prfNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Iyolnat mu i lima muwen tánni magpapiyya, sakay ipagkaluub mu a ten ngaran nen banal a Tagapagserbi mu a ti Jesus ay makagamet kami ti himala.” ");
INSERT INTO prfNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Káttapos di a nagdasal ay nayanág en págyanan di a bilay sakay naputat hidi ti hustu ten Banal a Ispiritu sakay bummegsák en isip di a mangaral ten Upos nen Diyos. ");
INSERT INTO prfNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Nagkaessa en isip nen atanan nen sumampalataya hidi kánni Jesus. Awan sinadili nen balang essa en ari-ariyan di nan para ten atanan. ");
INSERT INTO prfNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Ten begsák nen kapangyariyan nen Diyos a inyatád na ten apostol hidi ay tulos la hidi a nagpatunay a ti Jesus ay biniyag a ruway nen Diyos, sakay pinagpala na hidi ti hustu. ");
INSERT INTO prfNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Maski essa dikodi ay awan kinulang ten kailangan di gapu en tehud hidi a luta oni bilay ay inlaku di sakay en naglakuwan di ");
INSERT INTO prfNT_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","ay inyatád di ten apostol hidi. Sakay binunong-bunong nen apostol hidi en pilak ayun ten pangangailangan nen balang essa. ");
INSERT INTO prfNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Kona labi hud en ginamet ni Jose a essa a Levita a taga-Chipre. Nginaranan siya nen apostol hidi a Bernabe gustu naid a kagiyán ay matáttulungán. ");
INSERT INTO prfNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Inlaku na en uma na sakay inyatád na ten apostol hidi en naglakuwan na. ");
INSERT INTO prfNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Nadid tehud a magkabinga a naglaku bi ti luta, en lállaki ay Ananias en ngaran na sakay en kabinga na ay ti Safira. ");
INSERT INTO prfNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Peru nagkasunduwan nen magkabinga a awan iyatád ni Ananias en buu a naglakuwan di. ");
INSERT INTO prfNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Kaya kinagi ni Pedro dikona, “Ananias, bakin nagpadaig ka kánni Satanas sakay nagbuli-buli ka ten Banal a Ispiritu? Bakin nángtagu ka ten naglakuwan mu ten luta? ");
INSERT INTO prfNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Awan beman dikona awan mu palla nelaku ay kao mu iyud? Nadid, dikona nalaku mu dán awan beman kao mu en naglakuwan? Bakin naisipan mu iyád a gamitán? Bakán a tolay i nagbuli-buliyan muwid nan en Diyos!” ");
INSERT INTO prfNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Dikona nasanig iyud ni Ananias ay patay siya a natumba kaya atanan nen nakasanig hidi ten nangyari ay neántingan ti hustu. ");
INSERT INTO prfNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Ummadeni en sangan a binata, binalutan di bangkay sakay angay di inlábbáng. ");
INSERT INTO prfNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Kállipas nen tállu a odas ay dummemát en kabinga na a awan ti nangmalayan ten nangyari. ");
INSERT INTO prfNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Pagdaka siya a tinanung ni Pedro, “Kagiyán mu dikoku i tatarudanid, tarud beman a sakona háddi en nalakuwan nen luta moy?” Kinagi na, “Opo, sakona la haán.” ");
INSERT INTO prfNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Kaya kinagi ni Pedro dikona, “Bakin nagkaessaan moy a purbaan en Ispiritu nen Panginoon? Ilingán mu, ked dán ti pintuwanen en nánglábbáng hidi ten kabinga mu sakay siko dámman ilewas diyid.” ");
INSERT INTO prfNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Pagdaka a natumba ti Safira ten atubengán ni Pedro sakay natay bi. Ten kássáddáp nen binata hidi ay netan di a patay dán siya, kaya inlábbáng di siya ten wáwwaresan nen kabinga na. ");
INSERT INTO prfNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Tunay ti ánteng en atanan nen mánnampalataya hidi gapu ten nangyari pati en agum hidi a nakasanig ti baretaid a iyud. ");
INSERT INTO prfNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Nadid, makpal a ginamet en apostol hidi a himala a netan nen tolay hidi. Atanan nen mánnampalataya hidi ay nagipun-ipun ten Portiko ni hari a Solomon. ");
INSERT INTO prfNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Awan nangahas a mák-agum en awan hidi mánnampalataya peru pináppuri di en mánnampalataya hidi. ");
INSERT INTO prfNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Peru mágdadadagdag en sumampalataya hidi ten Panginoon, bábbi ay ti lállaki. ");
INSERT INTO prfNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Gapu ten ginamet nen apostol hidi ay inyangay nen tolay hidi en tehud hidi a saket ten karsada sakay pinágkatdug di hidi ten katri, en agum ay ten abák tánni káttalib ni Pedro ay malenduman hidi nen aninu na. ");
INSERT INTO prfNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Makpal bi a dummemát a tolay a gubwat ten iba-iba a banuwan a adeni ti Jerusalem, tawid di en tehud hidi a saket sakay en hinayup hidi, nagpiyya hidi a atanan. ");
INSERT INTO prfNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Nadid, gapu ten ginamet nen apostol hidi ay nanaghili en kapunuwan nen padi hidi sakay en kakagumanan na hidi a Saduseo, kaya namagkaessa hidi a nagplanu. ");
INSERT INTO prfNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Dinikáp di en apostol hidi sakay impiresu di hidi. ");
INSERT INTO prfNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Peru dikona gibi dán ay binukasan nen anghel nen Panginoon en pintuwan nen págpiresuwan sakay inluwas na en apostol hidi. Kinagi na dikodi, ");
INSERT INTO prfNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Kammoy dán ten Templo ipangaral moy ten tolay hidi en tungkul ten bigu a kákkabiyag.” ");
INSERT INTO prfNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Kaya summunud en apostol hidi. Dikona kaldiwan dán ay summáddáp hidi ten Templo sakay tulos hidi a nagtoldu ten tolay hidi. Nagipun-ipun en kapunuwan nen padi hidi sakay en kakagumanan na hidi, sakay nagpadulaw hidi ti miting ti buu a Sanedrin. Pinaangay di en apostol hidi a nakapiresu. ");
INSERT INTO prfNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Peru káddemát haud nen mágbantay hidi ay netan di a awan dán en apostol hidi. Kaya nagsoli hidi ten kapisanan sakay imbareta di a, ");
INSERT INTO prfNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Netan mi a nakakandadu en págpiresuwan sakay ked labi haud a mágtaknág en mágbantay hidi. Peru dikona bukasan mi dán ay awan kami ti netan a tolay disalad!” ");
INSERT INTO prfNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Nabalisa a tarud en pinunu hidi nen padi hidi sakay en kapitan nen mágbantay hidi ten Templo sakay awan di maubus a maisip ni ánya i nangyariyid ten apostol hidi. ");
INSERT INTO prfNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Peru tehud a dummemát a angay nagbareta dikodi a kinagi na, “En lállaki hidi a impepiresu moy ay pasiyaan dán hidi a magtoldu ten tolay hidi ten Templo.” ");
INSERT INTO prfNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Kaya ummangay en pinunu nen mágbantay ten Templo kaguman na en mágbantay na hidi. Inuwet di en apostol hidi sakay inyangay di hidi ten kapisanan. Peru awan di hidi pinuwersa gapu manteng hidi ta bakay batuwán hidi nen katolayan. ");
INSERT INTO prfNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Inyatubeng di en apostol hidi ten Sanedrin sakay tináttanung hidi nen kapunuwan nen padi hidi. ");
INSERT INTO prfNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","Kinagi na, “Awan beman mahigpit mi a imbawal dikomoy a dyan kamon mangaral ten ngaran ni Jesus? Peru ánya ginamet moyid? Ten ginamet moy ay kummalat dán ti buu a Jerusalem en itáttoldu moy sakay gustu moy pa a ipakasalanan dikomi en kákkatay ni tolayid a iyud!” ");
INSERT INTO prfNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Peru tummábbig de Pedro ay ten kaguman na hidi, kinagi di, “En Diyos dapat miyid a sunudán bakán a en tolay. ");
INSERT INTO prfNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","En Diyos nen ninunu tam hidi en nangbiyag a ruway kánni Jesus a pinabunu moy ten dikona a impepaku moy siya ten kudus. ");
INSERT INTO prfNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Indisunu siya nen Diyos ten kawanan na bilang Tagapaggiyya sakay Tagapagligtas, tánni atáddan na en Israelita hidi ti pagkakataun a magsisi sakay umadág ten kasalanan di hidi tánni mapatawad hidi. ");
INSERT INTO prfNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Sikami en makapangpatunay ti bagayid a iyád, kaguman en Banal a Ispiritu a impagkaluub nen Diyos ten atanan a sumunud dikona.” ");
INSERT INTO prfNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Dikona masanig nen buu a Sanedrin en kinagi de Pedro ay tunay hidi ti iyamut sakay gustu di a pabunu en apostol hidi. ");
INSERT INTO prfNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Peru tummaknág en essa ten Pariseo hidi a Gamaliel en ngaran na, mágtoldu siya ten Kautusan sakay igággalang nen buu a banuwan. Inyutus na a iluwas di pala en apostol hidi. ");
INSERT INTO prfNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Káttapos ay nagupos, a kinagi na, “Kakagumanan ku hidi a Israelita, isipán moy pa ti mapiyya en gustu moy a gamitán ti tolayen hidi. ");
INSERT INTO prfNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Sakay awan beman, awan palla nalay dikona a lummitaw ti Teudas a nagwari-wari a essa kan siya a mataas a pinunu, tehud wád a áppat a datos a tolay en naakit na a summapi dikona. Peru dikona nabunu siya ay nasina-sina en tolay na hidi sakay nabali-awan en grupu di. ");
INSERT INTO prfNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Káttapos ay lummitaw bi ti Judas a taga-Galilea ten panahun nen págsensus ten tolay hidi. Nakaakit bi siya ti makpal a tolay a summapi dikona. Peru dikona mabunu siya ay nasina-sina bi en sakup na hidi. ");
INSERT INTO prfNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Kaya kagiyán kuwid dikomoy ay pabayan moy la i tolayid a hidi iyán, dyan moy hidi pakialaman. Ni gággamitán diyid a iyán ay gubwat la ten tolay ay awan iyán ti abután. ");
INSERT INTO prfNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Peru ni gubwat iyád ten Diyos ay awan moy iyád mahadlangan nan lumuwas pa a kalabanán moy en Diyos.” Sinunud di ngani en payu ni Gamaliel. ");
INSERT INTO prfNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Pinadulaw di a ruway en apostol hidi ten kapisanan di, pinabálbág di hidi sakay binawalan di hidi a dyan di dán ipangaral en tungkul ten ngaran ni Jesus. Káttapos ay pinalaya di dán hidi. ");
INSERT INTO prfNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Tunay ti saya en apostol hidi a lummakad ten Sanedrin gapu ginustu nen Diyos a magdanas hidi ti pághirap alang-alang ten ngaran ni Jesus. ");
INSERT INTO prfNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Sakay kada-aldew ay angay hidi ten Templo a magtoldu sakay ten bila-bilay hidi a mangaral tungkul kánni Jesus, en Cristo. ");
INSERT INTO prfNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Nadid, tulos-tulos en págkakpal nen mánnampalataya hidi sakay dummemát en panahun a nagreklamu en Helenista hidi ten Hebreo hidi. Kinagi di a en bilu hidi a bábbi a Helenista ay napabayan ten págbunong-bunong di ten pang-aldew-aldew a kabiyagan. ");
INSERT INTO prfNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Kaya pinisan nen sapulu ay ti duwwa a apostol en buu a kapisanan nen mánnampalataya hidi sakay kinagi di dikodi, “Awan mi maari a pabayan en pángngaral ten upos nen Diyos tánni mamahala ten kabiyagan. ");
INSERT INTO prfNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Kaya nadid kákkapatkaka mi hidi mangpili kam ti kakagumanan moyen hidi ti pittu a lállaki a igággalang, putat ti Banal a Ispiritu, sakay mágkatalinu tánni hidi idátton miyid ti tungkulinid a iyád. ");
INSERT INTO prfNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Sikami ay ilaan mi en atanan nen odas mi ti págdasal sakay pángngaral ten Upos nen Diyos.” ");
INSERT INTO prfNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Nasaya en atanan nen tolay hidi ten kinagi nen apostol hidi kaya pinili di ti Esteban a essa a lállaki a matibay en pánnampalataya na ten Diyos sakay putat siya ti Banal a Ispiritu. Sakay pinili di bi de Felipe, Procoro, Nicanor, Timon, Parmenas, sakay ti Nicolas a taga-Antioquia a essa a Hentil a naakit ten pánnampalataya ni Judio. ");
INSERT INTO prfNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Inyangay di hidi ten apostol hidi, indasal di hidi, tulos di a intupu en lima di ten ulu nen balang essa. ");
INSERT INTO prfNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Nadid ay tulos-tulos a kummalat en upos nen Diyos sakay nágkakakakpal en maniwala hidi kánni Jesus ti Jerusalem. Maski en padi hidi ay makpal bi dikodi en summampalataya. ");
INSERT INTO prfNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Nadid, pinagpala a tarud nen Diyos ti Esteban sakay inátdenan na siya ti kapangyariyan kaya makagamet siya ti makataka-taka hidi a bagay sakay himala ten atubengán nen makpal a tolay. ");
INSERT INTO prfNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Peru kinontra siya nen sangan a Judio a miyembru nen sinagoga a kákkagiyán di a Malaya, tehud pa hidi a kaguman a taga-Cirene sakay taga-Alejandria sakay tehud pa a agum a Judio a gubwat ti Cilicia sakay ti Asia. ");
INSERT INTO prfNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Peru awan hidi ti magamet ni magupos ti Esteban gapu ten karunungan a kaluub dikona nen Banal a Ispiritu. ");
INSERT INTO prfNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Kaya sinekretu di a sinulsulan en sangan a lállaki a kagiyán di en kona háddi, “Nasanig mi a magupos siya ti kontra kánni Moises sakay ten Diyos.” ");
INSERT INTO prfNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Kaya gapu haud ay nagsaranta kánni Esteban en katolayan, en pinunu hidi nen banuwan sakay en tagapagtoldu hidi nen Kautusan. Dinikáp di siya sakay inyangay di ten Sanedrin. ");
INSERT INTO prfNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Dikona bistaán di siya ay náng-atubeng pa hidi ti mágkabuli a tistigu kontra kánni Esteban a kinagi di, “I tolayen ay awan ti imang a mággauposán ti madukás kontra ten banal a Templo sakay ten Kautusan ni Moises. ");
INSERT INTO prfNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Nasanig mi a kinagi na a rábbaán kan ni Jesus a taga-Nazaret en Templo tam sakay baguwán na kan en kaugaliyan tam a dati a intoldu ni Moises.” ");
INSERT INTO prfNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Lináttángngan nen atanan a ked ten Sanedrin ti Esteban sakay netan di a kumán a rupa ni anghel en rupa na. ");
INSERT INTO prfNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Nadid, tinanung nen kapunuwan nen padi hidi ti Esteban, “Tatarudan beman hidi iyád?” ");
INSERT INTO prfNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Kinagi ni Esteban, “Kákkapatkaka ku hidi sakay kadáddikállan hidi, sanigán moy i kagiyán kuwidi, tenhud a panahun dikona ked palla ti Mesopotamia en ninunu tam a ti Abraham ay pummeta dikona en dakila sakay makapangyariyan a Diyos, bagu siya a nágyan ti Haran. ");
INSERT INTO prfNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Kinagi nen Diyos dikona, ‘Lakadan mu i lugar muwen sakay i kapartidu muwen hidi sakay angay ka ten lugar a itoldu ku dikomu.’ ");
INSERT INTO prfNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Kaya lummakad ngani siya ten lugar nen Caldeo hidi sakay nágyan siya ti Haran. Dikona natay dán en ama na ay pinaagton dámman siya nen Diyos ti banuwaniday a páppágyanan tam nadid. ");
INSERT INTO prfNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Peru dikona ummangay siya háddi ay awan palla siya inátdenan nen Diyos ti maski sabadit a luta nan nagpangaku la a magin kao na sakay nen lahi na hidi i lugarid a iddi. Maski ni awan palla ti anak ti Abraham. ");
INSERT INTO prfNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Kona háddi en kinagi nen Diyos kánni Abraham, ‘En sumunud mu hidi a lahi ay mákpágyan ti iba a bansa. Magin alipin hidi haud sakay pahirapan di hidi ti áppat a datos a taon. ");
INSERT INTO prfNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Peru parusaan ku en bansa a mangsakup sakay mangalipin dikodi. Lakadan nen lahi mu hidi i bansaid a iyud sakay magsoli hidi ti lugarid a iddi tánni sumamba dikoku.’ ");
INSERT INTO prfNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Sakay inyutus nen Diyos kánni Abraham en págturi bilang tanda nen kasunduwan di. Kaya dikona a neenak dán ti Isaac ay tinuri na ten kawalu na a aldew. Kona labi hud en ginamet ni Isaac ten anak na a ti Jacob sakay kona bi hud en ginamet ni Jacob ten sapulu ay ti duwwa a anak na a lállaki a nagin mahalaga hidi a ninunu nen Judio hidi. ");
INSERT INTO prfNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“En anak hidi ni Jacob a lállaki ay summeni ten kapatkaka di a ti Jose, kaya inlaku di siya tánni magin alipin ti Egipto. Peru kakaguman na en Diyos. ");
INSERT INTO prfNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Tinulungan na siya ten atanan nen kahirapan na. Kaya dikona ummatubeng siya kánni Faraon a hari ti Egipto ay nagkaluuban siya nen Diyos ti karunungan. Sakay inátdenan na siya ti katungkulan a magin gubernador ti Egipto sakay mamahala ten palasyu nen hari. ");
INSERT INTO prfNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Ti panahunid a iyud ay nagkahud ti aláp sakay mahigpit a kahirapan ti buu a Egipto hanggan ti Canaan ten bansa a págyanan nen ninunu tam hidi, awan hidi ti pangalapan ti makan. ");
INSERT INTO prfNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Kaya dikona nabareta ni Jacob a makpal a trigo ti Egipto ay pinaangay na haud en ninunu tam hidi. ");
INSERT INTO prfNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Ten kapenduwwa di a ummangay haud ay nagpakilala dán ti Jose ten kákkapatkaka na hidi sakay natukuyan nen Faraon en tungkul ten pamilya ni Jose. ");
INSERT INTO prfNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Kaya pinauwet ni Jose ti Jacob a ama di, pati en atanan nen kákkapatkaka di hidi, pittu a pulu ay ti limma hidi a atanan. ");
INSERT INTO prfNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Ummangay de Jacob ti Egipto sakay tulos dán hidi haud a nágyan, haud dán bi siya a natay pati en anak na hidi. ");
INSERT INTO prfNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","En bangkay di hidi ay inyoli di ten bansa a Canaan sakay inlábbáng di hidi ti Siquem, ten kuweba a dati dán a binali ni Abraham ten anak hidi ni Hamor. ");
INSERT INTO prfNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Dikona adeni dán en panahun a pangtupad nen Diyos ten pangaku na kánni Abraham ay tunay dán ti kakpal en Israelita hidi ti Egipto. ");
INSERT INTO prfNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Ti Jose bi ay awan dán kilala nen hari ti Egipto ti panahunid a iyud. ");
INSERT INTO prfNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Linoku na en ninunu tam hidi sakay pinahirapan na hidi sakay pinilit na en dáddikál hidi a ibut en atanan nen anak di hidi a lállaki a bigu a lagsang tánni matay hidi. ");
INSERT INTO prfNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Ti panahunid a iyud ay neenak ti Moises, essa a anak a kasayaan nen Diyos. Tállu a bulan la siya a naalagaan nen dáddikál na hidi ten bilay di. ");
INSERT INTO prfNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Sakay dikona a ibut di dán, ay inampun siya nen anak a bábbi nen Faraon, sakay pinadikál na siya a kumán a sadili na a anak. ");
INSERT INTO prfNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Tinolduwan di siya ten atanan a karunungan ti Egipto, nagin malalaki siya ten pággupos sakay ten gamet na. ");
INSERT INTO prfNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Dikona áppat a pulu dán a taon en idad ni Moises ay naisipan na a angay bumisita ten kasa-Israelita na hidi tánni ketan na en papágyan di. ");
INSERT INTO prfNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Ten káddemát na haud ay netan na a apiyán nen essa a taga-Egipto en essa ten kasa-Israelita na. Insurug ni Moises en Judio kaya nabunu na en Egipcio. ");
INSERT INTO prfNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","En akala ni Moises ay naintendiyan nen kasa-Israelita na hidi a ten pamamag-itan na ay iligtas hidi nen Diyos peru awan di iyud naintendiyan. ");
INSERT INTO prfNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Ten sumunud a aldew ay naketa siya ti duwwa a Judio a magdima. Nadid, pinilit na hidi a sawayán sakay kinagi na, ‘Amigu ku hidi, bakin magdima kam ay parehu kam pa bi a Israelita?’ ");
INSERT INTO prfNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Peru intuglad siya nen essa a mangpahirap ten kadima na sakay kinagi na, ‘Deya i nángdáttonid dikomu a magin pinunu sakay tagahatul mi? ");
INSERT INTO prfNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Gustuwák mu beman a bunuwán a kona ten ginamet mu ten Egipcio nen napon?’ ");
INSERT INTO prfNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Pákkasanig ni Moises ten kinagi na ay gumminan siya, ummangay siya ten adeyu a bansa a Midian sakay tulos dán siya a nágyan haud. Nákkabinga siya sakay nagkahud hidi ti duwwa a anak a lállaki. ");
INSERT INTO prfNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Nadid, kállipas nen áppat a pulu a taon ay pummeta kánni Moises en essa a anghel ten maggerab a marenggád a kayu ten kaparangan, adeni ten bukid a Sinai. ");
INSERT INTO prfNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Nagtaka ti Moises ten netan na kaya ummadeni siya tánni mamalas na ti mapiyya. Nasanig na a nagupos en Diyos a ");
INSERT INTO prfNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","kinagi na, ‘Sikán en Diyos a sássambaán nen ninunu mu hidi, en Diyos de Abraham, Isaac sakay ni Jacob.’ Nagpágpág ti Moises ten ánteng na sakay awan siya makaileng. ");
INSERT INTO prfNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Kinagi nen Panginoon dikona, ‘Ibutan mu i sandalyas muwen gapu banal a lugar i págtaknággan muwen. ");
INSERT INTO prfNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Netan ku en pángngapi nen taga-Egipto hidi ten pinili ku hidi a tolay sakay nasanig ku en daing di kaya kedák háddi tánni iligtas hidi. Karon hád, ta utusan taka a angay ti Egipto.’ ");
INSERT INTO prfNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Kinagi pa ni Esteban a, “Iyud a Moises a awan sinanig nen lahi hidi ni Israel nan inadiyan di tenhud sakay nagkagiyan di pa ti kona háddi, ‘Deya nángdáttonid dikomu a magin pinunu mi sakay tagahatul mi?’ ay siya en pinili nen Diyos a magin pinunu di sakay mángligtas dikodi ten tulung nen anghel a pummeta dikona ten maggerab a kayu. ");
INSERT INTO prfNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Siya en nánggiya ten Judio hidi dikona a lakadan di en banuwan a Egipto. Naggamet siya ti himala hidi ti Egipto, sakay ten Diget a Madidig sakay ten dikona ked hidi ten kaparangan ti áppat a pulu a taon. ");
INSERT INTO prfNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Ti Moises labi en nangkagi ten lahi hidi ni Israel a, ‘En Diyos ay mangpili ti essa dikomoy sakay gamitán na a propeta a kona dikoku.’ ");
INSERT INTO prfNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Siya en kaguman nen Israelita hidi ten kaparangan. Napisan hidi ten bukid a Sinai dikona nákpágguron en anghel dikona. Sakay tinanggap ni Moises en Upos nen Diyos a makapangatád ti biyag tánni ipakapospos na dikotam. ");
INSERT INTO prfNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Peru awan siya sinunud nen ninunu tam hidi nan inadiyan di siya a pinunu, sakay gustu di pa a sumoli ti Egipto. ");
INSERT INTO prfNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Sakay kinagi di kánni Aaron, ‘Paggamet mu kami pay ti diyos tam a mánggiyya dikomi gapu awan mi dán tukoy ni nangánya dán ti Moises a nángluwas dikomi ti Egipto.’ ");
INSERT INTO prfNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Kaya naggamet hidi ti diyos-diyosan di a kumán a bul-u a baka. Piniyesta di iyud sakay inatangan di bilang págsamba di ten diyos-diyosan a ginamet la nen lima di. ");
INSERT INTO prfNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Gapu ten ginamet di ay pinabayan hidi nen Diyos, pinabayan na hidi a sumamba ten biton hidi dilanget. Kona ten nakasulat ten libru nen propeta hidi a kinagi nen Diyos a, ‘Sikam a lahi hidi ni Israel, bakán a sikán en inalayan moy ten binunu hidi a hayup ten págyan moy ti áppat a pulu a taon ten kaparangan. ");
INSERT INTO prfNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Babáklay moy en kubu nen diyos-diyosan moy a ti Moloc sakay en diyos-diyosan moy a ti Renfan a kumán a biton. Hidi iyud en ribultu a ginággamet moy tánni sambaán, kaya ibut takam ten lugar a mas adeyu pa ti Babilonia.’ ");
INSERT INTO prfNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Nadid, kinagi ni Esteban, “Dikona a ked ten kaparangan en ninunu tam hidi ay ked dikodi en Tolda nen Kasunduwan a pinagamet nen Diyos kánni Moises ayun ten sukat sakay idsura a kinagi na. ");
INSERT INTO prfNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Minana iyád nen anak di hidi ten ninunu di hidi sakay táttawid di iyud dikona a sakupán di en iba-iba hidi a lahi a pinasakup nen Diyos dikodi ten pággiyya ni Josue. Tatawid di iyud a hanggan ten panahun ni David. ");
INSERT INTO prfNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Nasaya en Diyos kánni David kaya inagid ni David a pakultadan na siya a mángpataknág ti bilay a para ten Diyos ni Israel. ");
INSERT INTO prfNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Peru ti Solomon a anak na i nanggamitid ti bilayid a iyud. ");
INSERT INTO prfNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Peru en Kataasan a Diyos ay awan mágyan ti bilay a ginamet la ni tolay, ayun ten insulat nen essa ten propeta hidi, ");
INSERT INTO prfNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘En langet ay pággetnudan ku, ‘sakay en luta ay táttáppakan ku. ánya pa a i maari moyid a gamitán a págyanan ku, oni lugar a áimangan ku? ");
INSERT INTO prfNT_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Awan beman sikán en naggamet ten atanan a bagay?’ ");
INSERT INTO prfNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Sakay kinagi ni Esteban, “Tunay ti káttug i págguluwan moyen! Sala moy a mabagu i kaisipan moyen. Sala moy a sanigán en katutuhanan a gubwat ten Diyos! Kaparehu kam nen ninunu moy hidi a summuway ten Banal a Ispiritu. ");
INSERT INTO prfNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Deya beman a propeta i awanid pinahirapan nen ninunu moy hidi? Binunu di en nanghula ten káddemát nen matuwid a Tagapagserbi a intokyon sakay pinabunu moy. ");
INSERT INTO prfNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Tinanggap moy bi en Kautusan nen Diyos a inyatád na tenhud ten pamamag-itan nen anghel hidi peru awan moy sássunudán!” ");
INSERT INTO prfNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Dikona masanig nen Sanedrin en kinagi ni Esteban ay tunay hidi ti iyamut. ");
INSERT INTO prfNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Peru naputat ti hustu ten Banal a Ispiritu ti Esteban kaya dikona tummangad siya dilanget ay netan na en kaluwalhatian nen Diyos sakay netan na bi ti Jesus a mágtaknág ten kawanan nen Diyos. ");
INSERT INTO prfNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Sakay kinagi ni Esteban, “Ketan ku a bukas dilanget sakay en Anak nen Tolay a mágtaknág ten kawanan nen Diyos.” ");
INSERT INTO prfNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Pákkasanig nen tehud hidi a katungkulan a Judio kánni Esteban ay pinálláddan di en babángbáng di sakay pinumákraw hidi sakay sabay-sabay hidi a dummuklos dikona. ");
INSERT INTO prfNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Binerber di siya a inluwas ten siyudad sakay haud di siya a binábbatu tánni matay. En tolay hidi a nangtistigu kontra dikona ay nageklas hidi ten alikábkáb di sakay intád di ten lállaki a en ngaran na ay Saulo. ");
INSERT INTO prfNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Mentras bábbatuwán di ti Esteban ay magdasal siya ti kona háddi, “Panginoon Jesus tanggapán mu i ispiritu kuwiday.” ");
INSERT INTO prfNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Sakay lummuhud siya a pummákraw, “Panginoon patawadán mu hidi ti kasalanan diyiday a ginamet di dikoku!” Ten káttapos na a nagupos ay tulos dán siya a nabágsutan ti angás. ");
INSERT INTO prfNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Kaguman ti Saulo ten pángbunu kánni Esteban. Ti aldewid a iyud ay nagsapul en mahigpit a pággusig ten mánnampalataya hidi ti Jerusalem. Minagkalat en mánnampalataya hidi ten iba-iba a lugar ten prubinsiya a Judea sakay Samaria peru en apostol hidi ay napisan la ti Jerusalem. ");
INSERT INTO prfNT_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Ti Esteban ay inlábbáng nen tolay hidi a tehud a ánteng ten Diyos sakay sinangitan di ti hustu. ");
INSERT INTO prfNT_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Nadid, pinilit ni Saulo a sidaán en simbaan, sináddáp na en balang bilay sakay dinikáp na en mánnampalataya hidi, sakay tulos na a impepiresu, lállaki ay ti bábbi. ");
INSERT INTO prfNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Impangaral nen nekalat hidi a mánnampalataya ten iba-iba a lugar en Upos nen Diyos ten balang angayan di. ");
INSERT INTO prfNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Ti Felipe a essa a kakagumanan di ay ummangay ten essa a siyudad ti Samaria sakay impangaral na haud en tungkul ten Cristo. ");
INSERT INTO prfNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Dikona a masanig nen tunay ti kakpal a tolay ti Felipe sakay ketan di en himala a ginággamet na ay inisip di ti mapiyya en kákkagiyán na. ");
INSERT INTO prfNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Magkállesan a lummuwas en mágkadukás a ispiritu ten hinayup hidi, sakay makalakad dán bi en pilay hidi sakay en lupug hidi. ");
INSERT INTO prfNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Kaya tunay en saya nen tolay hidi ti siyudadid a iyud. ");
INSERT INTO prfNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Tehud haud a essa a lállaki a en ngaran na ay Simon. Ten purumeru ay pahangaán na en Samaritano hidi ten pamamag-itan nen galing na. Ipagmadikál na a siya ay makapangyariyan, ");
INSERT INTO prfNT_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","sakay sanigán bi siya nen atanan, sapul ten kababaan hanggan ten kataasan, kinagi di, “I lállakiyid a iyád ay en dáddulawán a Mataas a Kapangyariyan, en kapangyariyan nen Diyos.” ");
INSERT INTO prfNT_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Nalay a panahun a pinaniwala na hidi ten galing na, kaya tulos-tulos di siya a sássanigán. ");
INSERT INTO prfNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Peru dikona masanig di en pángngaral ni Felipe ten Maganda a Bareta a pághari nen Diyos sakay en tungkul kánni Jesu-Cristo ay summampalataya en tolay hidi sakay tulos dán hidi a nagpabinyag, lállaki ay ti bábbi. ");
INSERT INTO prfNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Pati ti Simon ay summampalataya bi sakay nagpabinyag, pirmi dán siya a mákkuyoyug kánni Felipe. Humanga siya a tarud kada ketan na en himala hidi a gággamitán ni Felipe. ");
INSERT INTO prfNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Dikona nabareta nen apostol hidi a ked ti Jerusalem a naniwala en Samaritano hidi ten Upos nen Diyos ay pinaangay di de Pedro ay ti Juan ten siyudad a Samaria. ");
INSERT INTO prfNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Káddemát di haud ay indasal di en mánnampalataya hidi tánni matanggap di bi en Banal a Ispiritu, ");
INSERT INTO prfNT_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","gapu awan palla dummibábbi en Banal a Ispiritu ten maski essa dikodi. Nabinyagan la hidi ten ngaran ni Jesus a Panginoon. ");
INSERT INTO prfNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Sakay intupu de Pedro ay ti Juan en lima di ten ulu nen mánnampalataya hidi sakay summáddáp dán dikodi en Banal a Ispiritu. ");
INSERT INTO prfNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Netan ni Simon en ginamet de Pedro ay ti Juan, a ten pángtupu di ten lima di ten tolay hidi ay natanggap di bi en Banal a Ispiritu. Kaya inuron na de Pedro ay ti Juan a upaan na hidi ti pilak. ");
INSERT INTO prfNT_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","Kinagi na, “Átdenanák moy pay ti kapangyariyan a kona haán tánni mara itupu ku bi i lima kuwidi ay matanggap di bi en Banal a Ispiritu.” ");
INSERT INTO prfNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Peru kinagi ni Pedro dikona, “Mepahamak ka Simon a kaguman nen pilak mu! Akala mu wáddid ay mabali mu ti pilak en kaluub nen Diyos! ");
INSERT INTO prfNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Awan ka kabilang dikomi sakay awan ka ti karapatan ti bagayid a iyád, gapu tukoy nen Diyos a madukás i isip muwen. ");
INSERT INTO prfNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Magsisi ka dán ti kagustuwan muwen a madukás sakay idasal mu ten Panginoon a patawadán na ka. ");
INSERT INTO prfNT_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Sakay ketan ku bi a tunay i inggit muwen sakay nakagapus ka ti kasalanan.” ");
INSERT INTO prfNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Kinagi ni Simon, “Idasalák moy pay ten Panginoon tánni awan mangyari dikoku en kinákkagi moy!” ");
INSERT INTO prfNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Nadid káttapos de Pedro ay ti Juan a nagpatunay sakay nangaral ten Maganda a Bareta tungkul kánni Jesu-Cristo ten siyudad a Samaria, ay nagsoli hidi ti Jerusalem. Impangaral di bi en Maganda a Bareta ten makpal a lugar a dinamanan di ti Samaria. ");
INSERT INTO prfNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Nadid, inutusan nen anghel nen Panginoon ti Felipe a kinagi na, “Angay ka a pagdaka ten danág ti abagatan a dilan ti Jerusalem a patamu ti Gaza.” Awan dán iyád páglakadan nadid. ");
INSERT INTO prfNT_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Kaya pagdaka siya a nagrektat. Natagbu ni Felipe ten dilan en essa a pinunu a taga-Etiopia, siya ay tusureru nen Candace oni raina ti Etiopia. Gubwat siya ti Jerusalem a sinumamba ten Diyos. ");
INSERT INTO prfNT_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Dikona a pasoli dán siya a mágkalesa sakay magbasa ten libru ni propeta Isaias, ");
INSERT INTO prfNT_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","kinagi nen Banal a Ispiritu kánni Felipe, “Unudán mu i kalesa uday sakay máksabay ka.” ");
INSERT INTO prfNT_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Kaya inunud ni Felipe en kalesa a sássakayan nen lállaki sakay nasanig na a magbasa siya ten libru ni propeta Isaias. Tinanung siya ni Felipe, “Maintendiyan mu beman i basaán muwen?” ");
INSERT INTO prfNT_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Kinagi nen pinunu, “Konya ku a maintendiyan awan bi ti mángpaliwanag dikoku?” Tulos na a inakit ti Felipe a sumakay ten kalesa na sakay nággetnud siya ten wáwwaresan na. ");
INSERT INTO prfNT_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Nadid, kona háddi en sumássulat ten binasa nen lállaki, “Kumán siya a en tupa a netakda a bunuwán; kona siya ten kordero a awan tumanggi maski ni rapasán mu en dutdut na. Sakay awan siya magupos maski ni sabadit. ");
INSERT INTO prfNT_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Immemenos di siya sakay awan di inátdenan ti katarungan. Awan ti makapángkagi tungkul ten sumunud hidi a lahi na gapu binunu di siya.” ");
INSERT INTO prfNT_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Kinagi nen pinunu kánni Felipe, “Kagiyán pay dikoku ni deya a tolay i kinagiyiday nen propeta. En sadili na beman oni agum?” ");
INSERT INTO prfNT_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Impaliwanag ni Felipe en kahulugan nen nabasa nen pinunu sakay tulos na a impangaral en Maganda a Bareta tungkul kánni Jesus. ");
INSERT INTO prfNT_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Tulos-tulos la en págbiyahi di hanggan a nakademát hidi ten lugar a tehud a dinom. Kinagi nen pinunu, “Tehud a dinom háddi, maariyák mu dán beman a binyagan nadid?” ");
INSERT INTO prfNT_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Kinagi ni Felipe, “Maari ka a binyagan ni talaga a hustu ti isip muwen en kássampalataya mu.” Tummábbig en pinunu, “Maniwalaák a tarud a Anak nen Diyos ti Jesu-Cristo.” ");
INSERT INTO prfNT_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Pinaimang nen pinunu en kalesa sakay ummugsad hidi a duwwa a patamu ten dinom sakay bininyagan siya ni Felipe. ");
INSERT INTO prfNT_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Dikona umapet hidi ten dinapan ay bigla dálla a inalap nen Ispiritu nen Panginoon ti Felipe. Awan dán siya netan nen pinunu kaya intulos na dán en págbiyahi na, tunay siya ti saya. ");
INSERT INTO prfNT_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Inimonan dálla ni Felipe a ked dán siya ten lugar a Azoto. Impangaral na en Maganda a Bareta tungkul kánni Jesus sapul ti lugarid a iyud sakay ten atanan a banuwan a taliban na hanggan a nakademát siya ti Cesarea. ");
INSERT INTO prfNT_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Nadid, tulos en sigasig ni Saulo a mapabunu en mánnampalataya hidi ten Panginoon. Kaya ummadeni siya ten kapunuwan a padi nen Judio hidi, ");
INSERT INTO prfNT_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","sakay nággid ti sulat para ten sinagoga hidi ti Damasco tánni dikáppán na sakay matawid ti Jerusalem en deyaman a bábbi oni lállaki a kaguman ten Dilan nen Panginoon. ");
INSERT INTO prfNT_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Ummangay ti Saulo ten siyudad a Damasco, dikona adeni dán siya a dumemát ay tehud a dummemlag ten palebut na a makasili a gubwat dilanget. ");
INSERT INTO prfNT_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Nalugmuk siya, sakay nasanig na a tehud a nangdulaw dikona, “Saulo, Saulo, bakin usigánnák mu?” ");
INSERT INTO prfNT_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","“Deya ka beman, Panginoon?” tanung ni Saulo. Tummábbig en boses, “Sikán ay ti Jesus a áusigán mu. ");
INSERT INTO prfNT_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Tumaknág ka dán, sakay diretsu ka ten siyudad. Tehud a mángkagi dikomu haud ni ánya maari muwid a gamitán.” ");
INSERT INTO prfNT_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Awan ti kákkagi en kaguman hidi ni Saulo dikona a nasanig di en boses peru awan hidi ti ketan a magupos. ");
INSERT INTO prfNT_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Tummaknág ti Saulo sakay bummulag peru awan dán siya maketa, kaya inagbay nen kakagumanan na hidi a hanggan ti Damasco. ");
INSERT INTO prfNT_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Awan siya naketa ten alay nen tállu a aldew sakay awan bi siya kumman sakay umminom. ");
INSERT INTO prfNT_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Nadid, tehud a essa a mánnampalataya ti Damasco a Ananias en ngaran na. Pummeta dikona en Panginoon ten essa a pangitain a dinulaw na siya. Tummábbig ti Ananias a kinagi na, “Panginoon, ánya iyud?” ");
INSERT INTO prfNT_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Kinagi nen Panginoon, “Angay ka ten karsada a dáddulawán a Diretsu, ten bilay ni Judas sakay itanung mu haud en essa a lállaki a taga-Tarso, en ngaran na ay Saulo. Pasiyaan siya a magdasal nadid. ");
INSERT INTO prfNT_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Netan na ten pangitain na a summáddáp en essa a lállaki a Ananias en ngaran na ten bilay a páppágyanan na, sakay intupu na en lima na dikona tánni maketa dán siya a ruway.” ");
INSERT INTO prfNT_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Kinagi ni Ananias, “Panginoon, makpalák ben a bareta ti tolayid a iyán ten mágkadukás hidi a ginággamet na ten pinili mu hidi ti Jerusalem. ");
INSERT INTO prfNT_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Ummangay siya ti Damascowiday a tawid na en kapangyariyan a gubwat ten pinunu hidi nen padi hidi tánni dikáppán en atanan nen magdasal hidi dikomu.” ");
INSERT INTO prfNT_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Peru kinagi nen Panginoon dikona, “Kadmudán, gapu siya en pinili ku a mángpakapospos tungkul dikoku ten Hentil hidi, ten hari hidi sakay dikomoy a lahi ni Israel. ");
INSERT INTO prfNT_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Sakay mismu a sikán en mángpakapospos dikona ten atanan nen dapat na hidi a tiisán alang-alang dikoku.” ");
INSERT INTO prfNT_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Kaya ummangay haud ti Ananias. Summáddáp siya ten bilay sakay intupu na en lima na ten ulu ni Saulo sakay kinagi na, “Kapatkaka a Saulo, pinaangayák haád ni Jesus a Panginoon, en pummeta dikomu ten dilan dikona patamu ka haád. Pinaangayák na haád tánni maketa ka a ruway sakay tánni maputat ka ti Banal a Ispiritu.” ");
INSERT INTO prfNT_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Ti odas biyid a iyud ay bigla a naragrag en kumán hidi a keskes a gubwat ten mata ni Saulo sakay naketa dán siya. Tummaknág siya sakay tulos a nagpabinyag. ");
INSERT INTO prfNT_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Kumman siya sakay summoli dán en begsák nen bággi na. Nákpágyan ti Saulo ten mánnampalataya hidi ti Damasco ti sangan a aldew. ");
INSERT INTO prfNT_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Ummangay siya a pagdaka ten sinagoga hidi sakay sinapulan na dán a nangaral a ti Jesus en Anak nen Diyos.” ");
INSERT INTO prfNT_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Nagtaka en atanan nen nakasanig dikona sakay namágtanungan hidi a kinagi di, “Awan beman siya en nágpapahirapán ten tolay hidi a sumamba kánni Jesus ti Jerusalem? Sakay awan beman kaya a ked siya haád ay tánni dikáppán na hidi sakay iyangay na ten pinunu hidi nen padi hidi?” ");
INSERT INTO prfNT_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Peru lalu a nagin malalaki ti Saulo a nangaral kaya awan dán tukoy nen Judio hidi a mágyan ti Damasco ni ánya itábbig diyid ten patunay na a ti Jesus ay en Cristo. ");
INSERT INTO prfNT_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Kállipas nen makpal a aldew ay nagkaessaan nen Judio hidi a bunuwán ti Saulo. ");
INSERT INTO prfNT_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Aldew ay ti gibi ay áabangan di siya ten atanan nen sássáddáppan ten siyudad. Peru natukuyan dán ni Saulo en planu di dikona. ");
INSERT INTO prfNT_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Kaya ten essa a gibi ay inyasák siya nen disepulus na hidi ten balulang sakay intonton di ten dilipot nen pader a kudal. ");
INSERT INTO prfNT_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Káddemát ni Saulo ti Jerusalem ay pummilit siya a mákpisan ten mánnampalataya hidi haud, peru kantingan di siya sakay awan hidi makapaniwala a essa dán siya a disepulus. ");
INSERT INTO prfNT_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Peru tinabay siya ni Bernabe a ummangay ten apostol hidi, sakay insaysay na dikodi ni konya a netan ni Saulo en Panginoon ten dilan a tamu ti Damasco, sakay ten pákpágguron nen Panginoon dikona. Kinagi na bi a tunay a begsák en isip ni Saulo a nangaral tungkul kánni Jesus ti Damasco. ");
INSERT INTO prfNT_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Kaya sapul haud ay imbilang di dán a kakagumanan di ti Saulo ti Jerusalem tunay en begsák nen isip na a nangaral haud tungkul kánni Jesus. ");
INSERT INTO prfNT_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Nákpágguron bi siya sakay nákpagdiskusyon ten Judio hidi a Griego en upos di kaya gustu di siya a bunuwán. ");
INSERT INTO prfNT_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Dikona natukuyan iyud nen mánnampalataya hidi ay inyangay di ti Saulo ti Cesarea sakay pinaangay di siya ti Tarso. ");
INSERT INTO prfNT_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Kaya sapul haud ay nagin tahimik en papágyan nen mánnampalataya hidi ti buu a Judea, Galilea, sakay Samaria. Ten tulung nen Banal a Ispiritu ay tummibay sakay kummáppal en mánnampalataya hidi. ");
INSERT INTO prfNT_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Nadid, naglebut ti Pedro ten iba-iba a lugar tánni magbisita ten mánnampalataya hidi. Dikona angay siya bummisita ten banuwan a Lida ay ");
INSERT INTO prfNT_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","netan na haud en essa a lállaki a Eneas en ngaran na. Lupug siya sakay walu dán a taon a kumákkatdug. ");
INSERT INTO prfNT_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Kinagi ni Pedro dikona, “Eneas, pagpiyyaán ka ni Jesu-Cristo. Umikat ka dán sakay isaddi mu dán i págkatdugan muwen.” Pagdaka a ummikat ti Eneas. ");
INSERT INTO prfNT_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Dikona netan nen atanan nen taga-Lida hidi sakay taga-Saron hidi a nagpiyya dán siya ay summampalataya hidi ten Panginoon. ");
INSERT INTO prfNT_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Nadid, ten siyudad a Joppa ay tehud a mánnampalataya a bábbi, Tabita en ngaran na (Ti upos a Griego ay Dorcas, gustu naid a kagiyán ay ugsa). Gamitán na en atanan nen odas na ten pággamet ti maganda sakay ten págtulung ten pubri hidi. ");
INSERT INTO prfNT_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Ti panahunid a iyud ay nagkasakit siya sakay tulos a natay. Dikona a napunasan di dán en bangkay na ay indátton di ten kuwartu ten disunu. ");
INSERT INTO prfNT_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Awan masiyadu a adeyu en Joppa ten banuwan a Lida. Kaya dikona nabareta nen mánnampalataya hidi a ked ti Pedro ten banuwan a Lida ay pinauwet di siya ten duwwa a lállaki, impákkekagbi di a umangay siya a pagdaka ten siyudad a Joppa. ");
INSERT INTO prfNT_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Kaya nagrektat ti Pedro sakay nákkuyug dikodi. Káddemát di haud ay inyangay di siya ten kuwartu ten disunu. Pagdaka a ummadeni dikona en bilu hidi a bábbi a mágsassangitán sakay impáppeta di en badu di hidi sakay en alikábkáb di hidi a ginággamet ni Dorcas dikona a biyag palla siya. ");
INSERT INTO prfNT_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Pinaluwas ni Pedro en atanan nen tolay hidi sakay lummuhud a nagdasal. Káttapos ay ummileng siya ten bangkay sakay kinagi na, “Tabita umikat ka dán!” Bummulag en bábbi sakay pákketa na kánni Pedro ay ummetnud siya. ");
INSERT INTO prfNT_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Tinulungan siya ni Pedro a tummaknág sakay dinulawan na en mánnampalataya hidi, sakay en bilu hidi sakay inyatubeng na dikodi ti Dorcas a biyag dán. ");
INSERT INTO prfNT_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Nabareta iyud nen tolay hidi ten buu a siyudad a Joppa. Kaya makpal dán en naniwala ten Panginoon. ");
INSERT INTO prfNT_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Nalay a nágyan ten siyudad a Joppa ti Pedro. Náktulos siya kánde Simon a en tarabahu na ay mággamet ti leder. ");
INSERT INTO prfNT_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Nadid, tehud a essa lállaki taga-Cesarea a Cornelio en ngaran na. Essa siya a kapitan nen “Batalyon a Italiano” nen sundalu nen Romano hidi. ");
INSERT INTO prfNT_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Relihiyoso siya a tolay. Siya sakay en buu na a pamilya ay sumássamba ten Diyos. Pirmi siya a tumulung ten pubri hidi a Judio sakay magdasal a pirmi ten Diyos. ");
INSERT INTO prfNT_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Ten essa a aldew a magalas-tres ten apon ay naketa siya ti pangitain, netan na a summáddáp en anghel nen Diyos ten bilay na sakay dinulawan na siya, “Cornelio.” ");
INSERT INTO prfNT_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Ummileng siya sakay tunay en ánteng na a tummábbig, “Ánya iyud, Panginoon?” Kinagi nen anghel dikona, “Sinanig nen Diyos en dasal mu hidi sakay nasaya siya dikomu ten káttulung mu ten pubri hidi. ");
INSERT INTO prfNT_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Ipauwet mu ten sangan a lállaki ten siyudad a Joppa ti Simon a ngángngaranan di a Pedro. ");
INSERT INTO prfNT_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Náktulos siya kánni Simon a en tarabahu na ay mággamet ti leder a mágyan ten digdig nen diget.” ");
INSERT INTO prfNT_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Ten kállakad nen anghel ay dinulawan ni Cornelio en duwwa ten katulung na hidi sakay en essa a sadili na a sundalu a relihiyoso labi. ");
INSERT INTO prfNT_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Imbareta na dikodi en atanan nen nangyari sakay pinaangay na hidi ten siyudad a Joppa. ");
INSERT INTO prfNT_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","10","Ten sumunud a aldew ay adeni dán ten siyudad a Joppa en inutusan hidi ni Cornelio. Nadid, ti Pedro ay summangkay ten atáp nen bilay tánni magdasal. Magtatanghali dán tenhud kaya magaláp dán siya. Peru mentras a maguray siya a mehanda en pagkain di ay naketa siya ti pangitain. ");
INSERT INTO prfNT_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Bummukas dilanget sakay netan na a tehud a tummonton a dikál a ulás a tehud a igut en áppat na a kantu a mágdiba-dibábbi ti lutaiday. ");
INSERT INTO prfNT_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Sumássakay haud en atanan a kalasi ni hayup, en maglakad hidi sakay en magarakas hidi ti lutaiday sakay en magegbár hidi. ");
INSERT INTO prfNT_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Tehud siya a nasanig a boses a nagupos a kinagi na, “Tumaknág ka Pedro. Magbunu ka sakay kuman ka.” ");
INSERT INTO prfNT_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Peru tummábbig ti Pedro, “Awan ku magamet i bagayid a iyán Panginoon, sapul pa ten sapul ay awanák palla kukumman ten nebilang a madingát a pagkain.” ");
INSERT INTO prfNT_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Nasanig na a ruway en boses, “Dyan mu ibilang a madingát en lininis dán nen Diyos.” ");
INSERT INTO prfNT_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Pumentállu iyád a nangyari sakay káttapos ay dummisunu dán en ulás a tamu dilanget. ");
INSERT INTO prfNT_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Mentras a magisip ti Pedro ni ánya kahuluganid nen pangitain na ay tama bi a dummemát en inutusan hidi ni Cornelio. Intanung di en bilay ni Simon sakay káddemát di haud ay dummulaw hidi ten tapat nen pintuwan. ");
INSERT INTO prfNT_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Intanung di ni mágyan ngani haud ti Simon a ngángngaranan di a Pedro. ");
INSERT INTO prfNT_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Ti Pedro ay magisip palla ni ánya gustuwid a kagiyán nen netan na dikona kinagi nen Banal a Ispiritu a, “Tehud a tállu a lállaki a magaryok dikomu disadung. ");
INSERT INTO prfNT_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Umugsad ka dán sakay dyan ka magalangan a mákkuyug dikodi gapu sikán i nangutusid dikodi.” ");
INSERT INTO prfNT_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Kaya ummugsad ti Pedro sakay kinagi na ten tállu a lállaki, “Sikán ti Pedro, en aryokán moy, ánya maari kuwid a metulung dikomoy?” ");
INSERT INTO prfNT_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Kinagi di, “Pinaangay kami háddi ni kapitan Cornelio. Mabait siya a tolay sakay maka-diyos, igággalang siya nen atanan nen kasa Judio mu hidi. Kinagi nen anghel nen Diyos dikona a paangay na ka sakay sanigán na en kagiyán mu.” ");
INSERT INTO prfNT_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Pinatulos hidi ni Pedro sakay tulos na dán hidi a pinatidug haud ti gibiyid a iyud. Ten dimadimang ay nagrektat dán hidi. Nákkuyug dikona en sangan hidi a mánnampalataya a taga-Joppa. ");
INSERT INTO prfNT_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Ten kinailawan ay dummemát hidi ti Cesarea. Maguray dán de Cornelio ay ten inimbitaan na hidi a kapartidu na sakay en amigu na hidi. ");
INSERT INTO prfNT_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Káddemát ni Pedro ay tinagbu siya ni Cornelio sakay lummuhud siya ten atubengán na a sumamba. ");
INSERT INTO prfNT_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Peru kinagi ni Pedro, “Tumaknág ka ta kaparehuwák mu labi a tolay.” ");
INSERT INTO prfNT_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Mentras pasáddáp hidi ten bilay ay mágguron hidi. Kássáddáp di ay netan ni Pedro a makpal a tolay. ");
INSERT INTO prfNT_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Sakay nagupos ti Pedro a kinagi na, “Tukoy moy labi a ayun ten Kautusan nen relihiyon ni Judio ay bawal en mákpággagum oni bumisita ten awan na kasa-Judio. Peru impakapospos nen Diyos dikoku a dyan ku kan dapat a ibilang a madingát oni awan karapatdapat en deyaman a tolay. ");
INSERT INTO prfNT_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Kaya dikona pinauweták mu ay awanák tinumanggi. Nadid, gustu ku a mapospusan ni bakin pinauweták mu.” ");
INSERT INTO prfNT_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Kinagi ni Cornelio, “Kaáppat dán a aldew en lummipas ten kona labi haád a magalas-tres ten apon a magdasalák ti bilay kuwiday ay tehud a bigla a tummaknág ten atubengán ku a lállaki, nakabadu siya ti makasili a ngari-ngari a awan ku maláttángngan. ");
INSERT INTO prfNT_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Kinagi na dikoku, ‘Cornelio sinanig nen Diyos en dasal mu sakay nasaya siya dikomu ten káttulung mu ten pubri hidi. ");
INSERT INTO prfNT_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Ipauwet mu ten sangan a lállaki ten siyudad a Joppa ti Simon a ngángngaranan di a Pedro. Náktulos siya kánni Simon a máglinis ti koblet ni hayup a en bilay na ay ked ten digdig nen diget.’ ");
INSERT INTO prfNT_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Kaya pagdaka taka a pinauwet, salamat dikomu ta nakaangay ka. Nadid ay napisan kami ten atubengán nen Diyos tánni sanigán mi dikomu ni ánya i pekagiyid nen Panginoon.” ");
INSERT INTO prfNT_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Nagupos ti Pedro a kinagi na, “Nadid ku a napospusan ti hustu a pare-parehu en pangileng nen Diyos dikotam a atanan. ");
INSERT INTO prfNT_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Tanggapán na en deyaman a tolay maski ánya en lahi na basta en tehud a ánteng dikona sakay en mággamet ti matuwid. ");
INSERT INTO prfNT_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Inyatád nen Diyos en upos na ten Israelita hidi. Impakapospos na dikodi en Maganda a Bareta nen kapayapaan ten pamamag-itan ni Jesu-Cristo a Panginoon nen atanan! ");
INSERT INTO prfNT_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Tukoy moy dán en nangyari ti buu a Judea, nagsapul iyud ti Galilea ten káttapos a nangaral ni Juan tungkul ten págbinyag. ");
INSERT INTO prfNT_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Kilala moy ti Jesu-Cristo a taga-Nazaret, sakay tukoy moy bi ni konya siya a pinili nen Diyos sakay ni konya siya a naputat ti Banal a Ispiritu sakay kapangyariyan. Tukoy moy bi a maski ni hádya en angayan na ay naggamet siya ti maganda sakay nangpaibut ti dimonyo ten atanan nen hinayup hidi, gapu kaguman na en Diyos. ");
INSERT INTO prfNT_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Sikami en makapangpatunay ten atanan nen ginággamet na hidi ten lugar nen Judio hidi sakay ti Jerusalem. Peru binunu di siya ten pángpaku di dikona ten kudus. ");
INSERT INTO prfNT_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","41","Peru biniyag siya a ruway nen Diyos ten katállu a aldew. Pummeta siya peru bakán a ten atanan a tolay nan dikomi la a pinili hidi nen Diyos tenhud pa bilang tagapatunay na. Sikami en kaguman na a kumman sakay umminom dikona nabiyag siya a ruway. ");
INSERT INTO prfNT_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Inutusan na kami a mangaral ten atanan a tolay tungkul ten Maganda a Bareta sakay magpatunay a siya en pinili nen Diyos a manghatul ten biyag hidi a tolay sakay ten nágkatay dán hidi. ");
INSERT INTO prfNT_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Siya en gustu a kagiyán nen atanan a propeta a ni deyaman en maniwala dikona ay patawadán na en kasalanan di hidi ten pamamag-itan nen kapangyariyan nen ngaran na.” ");
INSERT INTO prfNT_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Pasiyaan palla a magupos ti Pedro dikona dummibábbi en Banal a Ispiritu ten atanan a tolay a mágsanig. ");
INSERT INTO prfNT_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Nagtaka en kaguman hidi ni Pedro a Judio a mánnampalataya ta maski en Hentil hidi ay nagkaluuban bi ti Banal a Ispiritu. ");
INSERT INTO prfNT_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Peru naniwala hidi gapu nasanig di a mismu a nagupos ti iba-iba a upos sakay nagpuri hidi ten Diyos. Kaya kinagi ni Pedro, ");
INSERT INTO prfNT_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Kona labi dikotam ay nagkaluuban bi hidi ti Banal a Ispiritu. Kaya awan dán ti makapangpugád a mabinyagan hidi.” ");
INSERT INTO prfNT_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Inyutus ni Pedro a binyagan hidi ten ngaran ni Jesu-Cristo. Káttapos ay inakit di ti Pedro a mágyan pa siya haud ti sangan a aldew. ");
INSERT INTO prfNT_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Nadid, nabareta nen apostol hidi sakay nen mánnampalataya hidi ten buu a prubinsiya a Judea a maski en bakán hidi a Judio ay naniwala ten Upos nen Diyos. ");
INSERT INTO prfNT_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Kaya dikona ummangay dán ti Pedro ti Jerusalem ay binaráng siya nen kákkapatkaka hidi a pabor ti págturi, ");
INSERT INTO prfNT_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","“Bakin náktulos ka ten bilay nen Hentil hidi sakay nákpággatubeng ka dikodi a kuman?” ");
INSERT INTO prfNT_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Kaya impaliwanag ni Pedro dikodi en atanan nen nangyari sapul pa ten sapul. ");
INSERT INTO prfNT_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Sapul naid ay dikona kedák ten siyudad a Joppa. Pasiyaanák a magdasal ay naketaák ti pangitain, a dummibábbi a kumán a ulás a tehud a igut en áppat na a kantu, sakay dummibábbi ten páppágyanan ku a gubwat dilanget. ");
INSERT INTO prfNT_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Minámmalas ku iyud ti mapiyya, netan ku haud en atanan a kalasi ni hayup. En hayup hidi a maglakad sakay en magarakas hidi ti lutaiday, sakay en mágkailam hidi kona bi ten magegbár hidi. ");
INSERT INTO prfNT_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Tehudák nasanig a boses a nagkagi, ‘Tumaknág ka Pedro. Magbunu ka sakay kuman ka!’ ");
INSERT INTO prfNT_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Peru kinagi ku, ‘Awan ku magamet i bagayid a iyán Panginoon! Sapul pa ten sapul ay awanák palla kukumman ten nebilang hidi a madingát a kákkanán.’ ");
INSERT INTO prfNT_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Nasanig ku a ruway en boses a gubwat dilanget a kinagi na, ‘Dyan mu ibilang a madingát en bagay hidi a lininisan dán nen Diyos.’ ");
INSERT INTO prfNT_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Pumentállu iyád a nangyari sakay káttapos ay dummisunu dán en ulás a tamu dilanget. ");
INSERT INTO prfNT_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Ti odas biyid a iyud ay dummemát ten tinulusan ku a bilay en tállu a lállaki a nanguwet dikoku, gubwat hidi ti Cesarea. ");
INSERT INTO prfNT_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Kinagi nen Banal a Ispiritu dikoku a dyanák magalangan a mákkuyug dikodi. Nákkuyug dikoku en ánnám a mánnampalataya dikona ummangay kami ten bilay ni Cornelio. ");
INSERT INTO prfNT_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Insaysay ni Cornelio dikomi a naketa siya ti essa a anghel, tummaknág kan ten disalad nen bilay na sakay kinagi na dikona, ‘Pauwet mu ten siyudad a Joppa ti Simon a ngángngaranan di a Pedro. ");
INSERT INTO prfNT_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Siya en mángkagi dikomu ni konya ka a maligtas sakay en kasabilay mu hidi.’ ");
INSERT INTO prfNT_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Magsapulák palla a magupos ay dummibábbi dán dikodi en Banal a Ispiritu a kona ten káddibábbi na dikotam ten purumeru. ");
INSERT INTO prfNT_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Naisipan ku en kinagi nen Panginoon a, ‘Nagbinyag ti Juan ti dinom, peru binyagan kam ti Banal a Ispiritu. ");
INSERT INTO prfNT_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Inátdenan bi hidi nen Diyos ti Banal a Ispiritu a kona ten pángngatád na dikotam, dikona a naniwala kitam kánni Jesu-Cristo a Panginoon. Nadid, deyaák a mangkontra ten Diyos?” ");
INSERT INTO prfNT_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Pákkasanig di ten paliwanag na ay awan dán hidi nagbaráng nan nagpuri hidi ten Diyos. Kinagi di, “Ni konahud ay inátdenan bi nen Diyos ti pagkakataun en Hentil hidi a magsisi ten kasalanan di sakay magbagu tánni maligtas hidi.” ");
INSERT INTO prfNT_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Nadid en mánnampalataya hidi ay minawatak-watak gapu ten págpahirap dikodi, sapul dikona a binunu di ti Esteban. Tehud a nakaabut ti Fenicia, ti Chipre hanggan ti Antioquia. Maski hádya en demáttan di a lugar ay ipangaral di en Maganda a Bareta peru ten Judio la hidi. ");
INSERT INTO prfNT_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Peru tehud a sangan a nákkuyug dikodi a taga-Chipre sakay taga-Cirene, káddemát di ti Antioquia ay impangaral di bi en Maganda a Bareta tungkul kánni Jesu-Cristo a Panginoon ten bakán hidi a Judio. ");
INSERT INTO prfNT_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Ked dikodi en kapangyariyan nen Panginoon kaya makpal en naniwala sakay nagtiwala ten Panginoon. ");
INSERT INTO prfNT_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Dikona a nabareta iyud nen simbaan ti Jerusalem ay inutusan di ti Bernabe a tamu ti Antioquia. ");
INSERT INTO prfNT_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Káddemát na haud ay masaya siya a tarud gapu netan na a pinagpala hidi nen Diyos. Kaya pinayuwan na hidi a atanan a manatili a tapat sakay nakatuun en isip di ten Panginoon. ");
INSERT INTO prfNT_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Mabait a tolay ti Bernabe, en Banal a Ispiritu en giyya na ten biyag na sakay matibay en pánnampalataya na kaya makpal en tolay a naakit na ten Panginoon. ");
INSERT INTO prfNT_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Kaya ummangay ti Bernabe ti Tarso tánni aryokán na ti Saulo. ");
INSERT INTO prfNT_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Dikona netan na ay ingkuyug na siya ti Antioquia. Kakaguman di en mánnampalataya hidi ten buu a sataon a págyan di haud, sakay nagtoldu hidi ten makpal a tolay. Ti Antioquia en kadipalonguwan a lugar a nangaranan a Cristiano en mánnampalataya hidi. ");
INSERT INTO prfNT_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Ti panahunid a iyud ay tehud a dummemát a sangan a propeta ti Antioquia a gubwat ti Jerusalem. ");
INSERT INTO prfNT_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Tummaknág en essa dikodi a Agabo en ngaran na, ten tulung nen Banal a Ispiritu ay kinagi na a tehud a dumemát a mahigpit a aláp ti munduwiday. Nangyari iyád ten kapanahunan ni Emperador a Claudio. ");
INSERT INTO prfNT_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Nagkaessaan nen disepulus hidi a magpatawid ti tulung ten kákkapatkaka di hidi a mánnampalataya ti Judea ayun ten makaya nen balang essa. ");
INSERT INTO prfNT_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Kona ngani haud en ginamet di, inyangay de Bernabe ay ti Saulo en tulung di ten pinunu nen mánnampalataya hidi ti Jerusalem. ");
INSERT INTO prfNT_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Ti panahunid a iyud ay sinapulan ni hari a Herodes a usigán en sangan a grupu nen mánnampalataya hidi. ");
INSERT INTO prfNT_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Pinaputol na en ulu ni Santiago a kapatkaka ni Juan. ");
INSERT INTO prfNT_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Dikona a netan na a ginustu iyád nen Judio hidi ay pinadikáp na ti Pedro. Nangyari iyád ten Piyesta nen Tinapay a awan ti Págpaalsa. ");
INSERT INTO prfNT_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Dikona a madikáp di ti Pedro ay tulos a impepiresu ni Herodes sakay pinabantay na ten áppat a grupu a tággi-áppat ten sundalu na hidi. Awan na iyatubeng a pagdaka ti Pedro ten Judio hidi gapu Piyesta palla nen Aldew nen Págtalib. ");
INSERT INTO prfNT_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Mentras a pumáppiresu ti Pedro ay taimtim siya a idáddasal nen grupu nen mánnampalataya hidi. ");
INSERT INTO prfNT_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Nadid, ten gibi ay tidug ti Pedro ten sállat nen duwwa a sundalu. Pinungu di siya ti duwwa a kadena sakay tehud a guwardiya ten pintuwan nen págpiresuwan. Nakatakda siya a iyatubeng ni Herodes ten Judio hidi ten ruway a aldew. ");
INSERT INTO prfNT_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Bigla dálla a pummeta en anghel nen Panginoon sakay dummemlag en págpiresuwan. Tinapek na en abaga ni Pedro sakay linukag, kinagi nen anghel, “Magalistu ka umikat ka!” Pagdaka a naokbis en kadena ten lima na. ");
INSERT INTO prfNT_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Kinagi nen anghel, “Ayusán mu dán sadili muwen sakay magsandalyas ka!” Kona ngani haud en ginamet na. Kinagi pa nen anghel a, “Iyalikábkáb mu i badu muwen a malayon sakay umunud ka dikoku.” ");
INSERT INTO prfNT_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Ummunonud ti Pedro ten anghel a lummuwas ten págpiresuwan. Peru awan na tukoy ni tatarudan en gagamitán na oni mágtagináp la siya. ");
INSERT INTO prfNT_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Nalampasan di en purumeru sakay en kaduwwa hidi a guwardiya hanggan a nakademát hidi ten pintuwan a bakal a lálluwasan a patamu ten siyudad, bigla la iyud a bummukas ten kusa na sakay lummuwas dán hidi. Dikona maglakad hidi ten essa a karsada ay bigla a nawan en anghel. ");
INSERT INTO prfNT_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Káttapos ay naisip ni Pedro a tatarudan en nangyari dikona kaya kinagi na, “Tukoy ku dán nadid a tatarudan bali i pangyayariyiday. Pinaangay háddi nen Panginoon en anghel na tánni iligtasák na ten kapangyariyan ni Herodes sakay ten asaan nen Judio hidi a mangyari dikoku.” ");
INSERT INTO prfNT_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Dikona maisip na en talaga a nangyari ay ummangay siya ten bilay ni Maria a ina ni Juan a ngángngaranan di a Marcos. Makpal a mánnampalataya en nagipun-ipun haud a mágdadasalán. ");
INSERT INTO prfNT_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Tummoktok ti Pedro ten pintuwan nen kudal sakay angay inileng nen utusan a bábbi a Roda en ngaran na ni deya en magtoktok. ");
INSERT INTO prfNT_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Nabosesan nen utusan ti Pedro peru gapu ten saya na ay awan na dán nabukasan en pintuwan nen kudal nan nággaginanán a summáddáp sakay imbareta na a ked ti Pedro ten pintuwan. ");
INSERT INTO prfNT_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Kinagi di, “Nagareng ka dán wádden!” Peru impilit na la a tatarudan a ked ti Pedro. Kaya kinagi di, “Bakay anghel na.” ");
INSERT INTO prfNT_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Peru tulos-tulos la en págtoktok ni Pedro kaya binukasan di en pintuwan nen kudal. Sakay dikona a ketan di dán siya ay minagtaka hidi ti hustu. ");
INSERT INTO prfNT_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Sininyasan hidi ni Pedro a dyan hidi pakareraw sakay inyistorya na dikodi ni konya siya a pinaluwas nen Panginoon ten págpiresuwan. Sakay imbilin na dikodi a ibareta di bi kánni Santiago en nangyari sakay ten agum hidi a mánnampalataya. Káttapos ay nagrektat dán siya a angay ti iba a lugar. ");
INSERT INTO prfNT_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Nadid, ten págdemlag dán ay narendi a tarud en guwardiya hidi gapu awan dán ti Pedro. Awan di tukoy ni ánya i nangyariyid dikona. ");
INSERT INTO prfNT_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Pinaaryok siya ni Herodes peru awan di netan. Pinaimbistiga na en guwardiya hidi sakay pinabunu na hidi. Káttapos ay nagrektat ti Herodes ti Judea sakay ummangay ti Cesarea, haud dán siya a nákpágyan. ");
INSERT INTO prfNT_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Tehud a iyamut ti Herodes ten taga-Tiro hidi sakay ten taga-Sidon hidi. Nadid en tolay hidi ti duwwaid a iyud a siyudad ay nagkaessa a angay umadeni kánni Herodes. Inamigu di ti Blasto a tagapamahala ten palasyu a aguman na hidi a mákpágguron kánni Herodes tánni amu-amuwán di siya, gapu en paggubwatan nen kabiyagan di ay ten banuwan ni hari a Herodes. ");
INSERT INTO prfNT_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Nadid, káddemát nen aldew a intakda ni Herodes ay nagbadu siya ti badu ni hari, nággetnud siya ten bangku na sakay nagupos. ");
INSERT INTO prfNT_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Impákraw nen tolay hidi, “En nagupos ay diyos bakán a tolay!” ");
INSERT INTO prfNT_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Ti odas biyid a iyud ay pinagkasakit nen anghel nen Panginoon ti Herodes gapu kinao na en kapuriyan nen Diyos, sakay kinnan siya ni urád a hanggan a matay. ");
INSERT INTO prfNT_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Peru en upos nen Diyos ay kummalat sakay nágkakakakpal en mánnampalataya hidi. ");
INSERT INTO prfNT_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Lummakad dán de Bernabe ay ti Saulo a tamu ti Jerusalem dikona magamet di dán en tungkulin di. Ingkuyug di ti Juan a ngángngaranan di a Marcos. ");
INSERT INTO prfNT_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Ten mánnampalataya hidi ti Antioquia ay tehud a sangan a mágpahayag ten Maganda a Bareta sakay tehud bi a sangan a mágtoldu ten mánnampalataya hidi. Kabilang hád ti Bernabe, ti Simeon a nginaranan di a Negro, sakay ti Lucio a taga-Cirene, ti Manaen (a kaguman ni gubernador a Herodes dikona anak palla hidi a duwwa) sakay ti Saulo. ");
INSERT INTO prfNT_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Mentras a magkulásyon hidi para magpuri ten Panginoon ay kinagi nen Banal a Ispiritu dikodi, “Ibukud moy de Bernabe ay ti Saulo. Tehudák a inlaan a tarabahu para dikodi.” ");
INSERT INTO prfNT_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Káttapos di a nagkulásyon sakay nagdasal, ay intupu di ten duwwa en lima di sakay pinarektatan di dán hidi. ");
INSERT INTO prfNT_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Nadid, inyutus nen Banal a Ispiritu kánde Bernabe ay ti Saulo a umangay hidi ti Seleucia a adeni ten diget. Sapul haud ay nággabeng hidi a patamu ti Chipre a dikál a puduk. ");
INSERT INTO prfNT_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Dummung hidi ten lugar a Salamina sakay impangaral di en upos nen Diyos ten sinagoga nen Judio hidi. Kakaguman di ti Juan Marcos a tummulung dikodi. ");
INSERT INTO prfNT_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Dikona ummangay hidi ten dilipot nen dikál a puduk hanggan ten siyudad a Pafos, ay nesapulan di haud en tehud a galing a Judio a magkukunwari a propeta, Bar-Jesus en ngaran na. ");
INSERT INTO prfNT_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Kaguman siya ni gubernador Sergio Paulo, essa a malalaki a tolay. Pinadulaw nen gubernador de Bernabe ay ti Saulo gapu gustu na a masanig en upos nen Diyos. ");
INSERT INTO prfNT_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Peru sinaway hidi nen tehud a galing a ti Elimas (iyud en ngaran ni Bar-Jesus ten upos a Griego) tánni awan sumampalataya en gubernador. ");
INSERT INTO prfNT_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Peru ti Saulo a ngángngaranan di labi a Pablo ay putat ti Banal a Ispiritu. Lináttángngan na ti Elimas ");
INSERT INTO prfNT_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","sakay kinagi na, “Siko! Anak ka ni diyablo! Kadima ka nen atanan a tama a bagay! Ked dikomu en atanan a kakabuliyan sakay págdaya! Bakin pirmi mu a pakiwállán en atanan a tama tungkul ten Panginoon? ");
INSERT INTO prfNT_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Kaya maparusaan ka nadid! Maburák ka hanggan ten aldew a intakda nen Diyos.” Kaya pagdaka a nabati ni Elimas a nagdiklám en pángngileng na sakay magkapakapa siya a magaryok ti mangantabay dikona. ");
INSERT INTO prfNT_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Summampalataya en gubernador dikona a netan na en nangyari sakay minagtaka siya ten intoldu de Bernabe tungkul ten Panginoon. ");
INSERT INTO prfNT_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Nadid, de Pablo ay ten kaguman na hidi ay nággabeng sapul ti Pafos patamu ti Perga a banuwan ti Pamfilia. Peru summina ti Juan Marcos dikodi sakay nagsoli ti Jerusalem. ");
INSERT INTO prfNT_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Sapul ti Perga ay nagtulos hidi ti Antioquia a banuwan ti Pisidia. Ten Aldew nen Káimang nen Judio hidi ay summáddáp hidi ten sinagoga sakay nággetnud haud. ");
INSERT INTO prfNT_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Káttapos di a nangbasa ten Kautusan ni Moises sakay ten insulat nen propeta hidi ay impekagi nen pinunu nen sinagoga dikodi a, “Kákkapatkaka ku hidi, ni tehud kam a gustu a kagiyán a makapabegsák ti tolayiday hidi ay maari moy dán a kagiyán.” ");
INSERT INTO prfNT_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Kaya tummaknág ti Pablo sakay sininyasan na hidi sakay sinapulan na a nagupos. Kinagi na, “Sikam a Israelita sakay sikam a Hentil hidi a tehud a ánteng ten Diyos, mágsanig kam! ");
INSERT INTO prfNT_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","En Diyos nen lahi ni Israel en nangpili ten ninunu tam hidi, sakay pinakakpal na hidi ti hustu dikona a nákpágyan palla hidi ti Egipto. Inluwas na hidi haud ten pamamag-itan nen kapangyariyan na. ");
INSERT INTO prfNT_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Nagtiisan na hidi a inalagaan ti áppat a pulu a taon dikona a ked hidi ten kaparangan. ");
INSERT INTO prfNT_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Pinapuksa na en pittu a bansa ti Canaan sakay inyatád na i lugarid a hidi iyud ten ninunu tam hidi, ");
INSERT INTO prfNT_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","ten luub nen halus áppat a datos sakay limma a pulu a taon. Sakay inátdenan na hidi ti kahuwesan a hanggan dikona a ti Samuel dán en nagin propeta. ");
INSERT INTO prfNT_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Nadid, gapu gustu di a magkahud ti hari ay inátdenan hidi nen Diyos ti essa a lállaki a ti Saulo a anak ni Cis, gubwat siya ten lahi ni Benjamin. Nagin hari di siya ti áppat a pulu a taon. ");
INSERT INTO prfNT_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Dikona ibutan dán siya nen Diyos ten katungkulan na ay pinili na ti David a magin hari di sakay kinagi na, ‘Netan ku kánni David a anak ni Jesse en atanan a gustu ku, gapu tukoy ku a nakahanda siya a sumunud ten atanan a iyutus ku!’ ");
INSERT INTO prfNT_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Ten lahi ni David en naggubwatan ni Jesus, en impangaku nen Diyos ten Israelita hidi a magin Tagapagligtas. ");
INSERT INTO prfNT_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Bagu dummemát ti Jesus ay impangaral ni Juan ten buu a Israel a magsisi hidi ten kasalanan di sakay magpabinyag hidi. ");
INSERT INTO prfNT_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Dikona adeni dán a matapos ti Juan ten gamet na ay kinagi na, ‘Bakay isipán moy a sikán dán en áorayán moy a Tagapagligtas. Bakán a sikán. Peru káttapos ku ay dumemát siya sakay maski mangibut la ten sandalyas na ay awanák karapatdapat gapu mataas siya a tarud.’ ");
INSERT INTO prfNT_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“Kákkapatkaka ku hidi a gubwat ten lahi ni Abraham sakay sikam a tehud a ánteng ten Diyos sanigánnák moy, sikitam en nángpatawidan nen Diyos ten bareta tungkul ten kaligtasan. ");
INSERT INTO prfNT_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Awan tinenggi nen Judio hidi a ked ti Jerusalem sakay nen pinunu di hidi ti Jesus a siya en Tagapagligtas. Maski en Kasulatan a hula nen propeta hidi a bábbasaán di kada-Aldew ten Káimang nen Judio hidi ay awan di maintendiyan. Hidi pa en nangtupad ten hula gapu hidi en nangpabunu kánni Jesus. ");
INSERT INTO prfNT_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Maski awan hidi ti katuwiran a mangpabunu dikona ay inagid di la kánni Pilato a pabunu di siya. ");
INSERT INTO prfNT_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Dikona natupad di dán atanan nen nakasulat tungkul ten pángpabunu di ay impedibábbi di siya ten kudus sakay impelábbáng di. ");
INSERT INTO prfNT_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Peru biniyag siya a ruway nen Diyos. ");
INSERT INTO prfNT_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Makpal a aldew a pinumeta siya ten tolay hidi a nákkuyoyug dikona, dikona ked palla siya ti Jerusalem a gubwat ti Galilea. Nadid ay hidi dán en mangpatunay tungkul dikona. ");
INSERT INTO prfNT_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Kaya iddi en Maganda a Bareta nen Diyos a inyangay mi háddi a ipakapospos dikomoy, en pangaku na ten ninunu tam hidi. ");
INSERT INTO prfNT_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Iyud ay tinupad na dán nadid a panahun ten pamamag-itan nen pángbiyag na a ruway kánni Jesus. Kona ten nakasulat ten libru nen kansiyon a, ‘Siko en Anak ku, sapul nadid ay sikán dán en Ama mu.’ ");
INSERT INTO prfNT_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Tungkul ten kákkabiyag na a ruway sakay ten awan kákkarunot nen bággi na ay kinagi nen Diyos, ‘Ipagkaluub ku dikomoy en banal hidi sakay maasaan a pagpapala kona ten impangaku ku kánni David.’ ");
INSERT INTO prfNT_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Nakasulat bi ten iba a bahagi nen libru nen kansiyon a, ‘Awan mu pabayan a marunot en Banal mu.’ ");
INSERT INTO prfNT_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Dikona nasunud dán ni David en atanan nen kagustuwan nen Diyos, ay natay dán siya sakay inlábbáng di a adeni ten nánglábbángngan di ten dáddikál na hidi sakay narunot en bággi na. ");
INSERT INTO prfNT_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Peru ti Jesus a biniyag a ruway nen Diyos ay awan summaber ti kákkarunot. ");
INSERT INTO prfNT_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Dapat moy a matukuyan kákkapatkaka ku hidi a ten pamamag-itan ni Jesus ay napatawad dán en kasalanan tam. ");
INSERT INTO prfNT_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","En atanan nen sumampalataya hidi dikona ay napatawad dán ten atanan nen kasalanan di a awan mapatawad maski ten págsunud ten Kautusan hidi ni Moises. ");
INSERT INTO prfNT_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Kaya mangilag kam tánni awan mangyari dikomoy en hula nen propeta hidi a, ");
INSERT INTO prfNT_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Sikam a magsesti hidi ten Diyos! Magtaka kam sakay mepahamak! Gapu gamitán ku ten kapanahunan moy en essa a bagay a awan moy mapaniwalaan, maski ni tehud a mángpaliwanag pa tungkul ti iyád dikomoy!’ ” ");
INSERT INTO prfNT_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Nadid, dikona a lumakad dán de Pablo ay ti Bernabe ten sinagoga ay nákkekagbi en tolay hidi a mangaral dámman hidi dikodi ten ruway a Aldew nen Káimang nen Judio hidi. ");
INSERT INTO prfNT_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Dikona mamaguliyan dán hidi ay ummunud kánde Pablo ay ti Bernabe en makpal a Judio sakay en Hentil hidi a nák-agum ten relihiyon nen Judio hidi. Kinauron hidi nen duwwa a apostol sakay pinayuwan di hidi a tulos la hidi a magtiwala ten kabaitan nen Diyos. ");
INSERT INTO prfNT_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Nadid, ten ruway a Aldew nen Káimang nen Judio hidi ay ngari-ngari a atanan nen tolay ten siyudad ay nagipun-ipun tánni mágsanig ten Upos nen Diyos. ");
INSERT INTO prfNT_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Peru dikona a netan nen Judio hidi en makpal a tolay a angay mágsanig ay nanaghili hidi a tarud. Kaya linait di sakay kinontra ti Pablo. ");
INSERT INTO prfNT_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Peru mabegsák en isip de Pablo ay ti Bernabe a magupos, kinagi di, “Dapatid ay sikam en purumeru mi a pángpakapospusan ten Upos nen Diyos. Peru gapu awan moy tinanggap ay hinatulan moy en sadili moy a awan kam karapatdapat ten biyag a awan ti katapusan kaya angay kami dálla mangaral ten Hentil hidi. ");
INSERT INTO prfNT_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Gapu kona háddi en inyutus nen Panginoon dikomi, ‘Pinili taka a magin demlag ten Hentil hidi tánni mepangaral mu en kaligtasan hanggan ten kasuluk-sulukan ni munduwiday.’ ” ");
INSERT INTO prfNT_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Tunay ti saya en Hentil sakay nagpuri hidi ten Panginoon gapu ten kinagi de Pablo ay ti Bernabe. Summampalataya en pinili hidi nen Panginoon a magkahud ti biyag a awan ti katapusan. ");
INSERT INTO prfNT_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Kaya kummalat en upos nen Diyos ti lugarid a iyud. ");
INSERT INTO prfNT_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Peru sinulsulan nen Judio hidi en lállaki hidi a pinunu nen siyudad sakay en bábbi hidi a relihiyosa a tanyag ten banuwan; pinausig di de Pablo ay ti Bernabe sakay pinalakad di hidi ti lugarid a iyud. ");
INSERT INTO prfNT_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Kaya impagpag nen duwwa en alikabuk ten básset di bilang tanda a kontra ten tolay hidi haud, sakay ummangay hidi ti Iconio. ");
INSERT INTO prfNT_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","En disepulus hidi ti Antioquia ay naputat hidi ti hustu ti kasayaan sakay ten Banal a Ispiritu. ");
INSERT INTO prfNT_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Nadid ten siyudad a Iconio ay kona bi hud en ginamet de Pablo ay ti Bernabe. Ummangay hidi ten sinagoga nen Judio hidi sakay mahusay en pággupos di kaya makpal a Judio sakay Griego en summampalataya kánni Jesus. ");
INSERT INTO prfNT_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Peru en ginamet nen Judio hidi a awan sumampalataya ay sinida di en isip nen Hentil hidi sakay sinulsulan di hidi kontra ten mánnampalataya hidi. ");
INSERT INTO prfNT_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Nanalay bi haud a nágyan de Pablo ay ti Bernabe sakay tunay ti begsák en isip di a nangaral tungkul ten Panginoon. Kaya pinatunayan nen Panginoon a tatarudan en pángngaral di tungkul ten awan ti kaparehu a kabaitan na, ten pamamag-itan nen intád na dikodi a kapangyariyan a makagamet ti makataka-taka hidi a bagay. ");
INSERT INTO prfNT_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Kaya nahati en tolay hidi ten siyudad, en agum ay kinumampi ten Judio hidi sakay en agum ay ten apostol hidi. ");
INSERT INTO prfNT_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Nadid, nagbalak ti madukás en Hentil hidi, en Judio hidi, sakay en pinunu di hidi, kontra ten apostol hidi. Inggayak di hidi a pahirapan sakay batuwán. ");
INSERT INTO prfNT_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Peru natukuyan iyud nen apostol hidi kaya ginuminan hidi ti Listra sakay ti Derbe a siyudad hidi ti Licaonia hanggan ten nakapalebut hidi a lugar. ");
INSERT INTO prfNT_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Impangaral Di haud en Maganda a Bareta. ");
INSERT INTO prfNT_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Nadid, tehud a essa a lállaki ti Listra a awan makalakad, lupug siya sapul ten kákkeenak na. ");
INSERT INTO prfNT_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Mággetnud siya haud a mágsanig ten pángngaral ni Pablo. Dikona lináttángngan siya ni Pablo sakay netan na a tehud siya a pánniwala a magpiyya ay ");
INSERT INTO prfNT_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","kinagi na ti mabegsák a, “Tumaknág ka ti diretsu!” Linumuksu en lállaki sakay tulos dán a naglakad. ");
INSERT INTO prfNT_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Dikona netan nen tolay hidi en ginamet ni Pablo ay impákraw di ten sadili di a upos a Licaonia a, “Dummibábbi dikotam en duwwa a diyos a nagin tolay hidi!” ");
INSERT INTO prfNT_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Nginaranan di a Zeus ti Bernabe sakay ti Pablo ay Hermes gapu siya en mágpaliwanag. ");
INSERT INTO prfNT_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","En templo nen diyos-diyosan di a ti Zeus ay ked la ten luwas nen sássáddáppan ten siyudad. Kaya en padi di ay náng-angay ti kabakaan a bunuwán a tehud a manga ulay a bulaklak tánni iyalay na sakay nen tolay ten banuwan kánde Bernabe ay ti Pablo a ked ten sássáddáppan nen siyudad. ");
INSERT INTO prfNT_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Dikona a matukuyan de Bernabe ay ti Pablo en gamitán nen tolay hidi ay pinisad-pisad di en badu di tánni ipeta di a adiyan di en gustu di a gamitán sakay nággaginanán hidi a ummangay ten kakpalan nen tolay sakay impákraw di a kinagi, ");
INSERT INTO prfNT_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Dyan kam maggamet ti kona haán, kaparehu moy kami la a tolay! Ummangay kami háddi tánni ipangaral dikomoy en Maganda a Bareta tánni adággan moy dán hidi iyán a gamet a awan ti serbi sakay sumoli kam ten Diyos a biyag a nanggamet ten langet, ten luta, ten diget sakay ten atanan a bagay a ked haud. ");
INSERT INTO prfNT_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Ten lummipas a panahun ay pinabayan nen Diyos en atanan a tolay a manggamet ten balang gustu di a gamitán. ");
INSERT INTO prfNT_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Konapamanhud ay nangatád en Diyos ti sapat a katibayan a mangpatunay ni deya siya tánni matenggi moy siya ten pamamag-itan nen mágkaganda hidi a bagay a ginággamet na para dikomoy. Magpauden siya gubwat dilanget sakay mangatád ti maganda a ani ten takda a panahun. Átdenan na kam ti sapat a makan sakay páppasayaán na kam. ");
INSERT INTO prfNT_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Maski kona haud en kinákkagi ni Pablo ay nahirapan padi hidi a nangpugád ten tolay hidi a magalay dikodi. ");
INSERT INTO prfNT_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Peru dinumemát en Judio hidi a gubwat ti Antioquia sakay ti Iconio. Sinulsulan di en tolay hidi ti Listra kontra kánni Pablo kaya binábbatu di siya. Sakay hinehela di a paluwas ten siyudad ta isip diyid ay patay dán siya. ");
INSERT INTO prfNT_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Peru dikona palebutan siya nen mánnampalataya hidi ay tummaknág siya sakay nagsoli ten siyudad. Ten ruway a aldew ay nagrektat hidi ay ti Bernabe a tamu ti Derbe. ");
INSERT INTO prfNT_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Nadid impangaral de Pablo ay ti Bernabe en Maganda a Bareta ti Derbe sakay makpal hidi a naakit a magin disepulus. Káttapos ay nagsoli hidi ten siyudad a Listra, Iconio sakay ti Antioquia a lugar ti Pisidia. ");
INSERT INTO prfNT_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Pinabegsák di en isip nen mánnampalataya hidi sakay pinayuwan di hidi a magpakatibay ten pánniwala di, sakay kinagi di, “Dapat kitam a magtággád ti makpal a hirap bagu kitam a makasáddáp ten kahariyan nen Diyos.” ");
INSERT INTO prfNT_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Ten balang simbaan nen mánnampalataya hidi ay nagpili de Bernabe ay ti Pablo dikodi ti magin pinunu nen simbaan di. Káttapos ay nagkulásyon hidi tánni magdasal, sakay impebahala di hidi ten Panginoon a pánniwalaan di. ");
INSERT INTO prfNT_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Nadid nalebut di dán en prubinsiya a Pisidia hanggan nakademát hidi ten prubinsiya a Pamfilia. ");
INSERT INTO prfNT_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Impangaral di en upos nen Diyos ten siyudad a Perga sakay ummangay hidi ti Atalia. ");
INSERT INTO prfNT_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Sapul ti Atalia ay nággabeng hidi a pasoli ti Antioquia. Haud labi en nángdasalan di dikodi a aguman hidi nen Diyos gapu ten natapos di dán a tarabahu. ");
INSERT INTO prfNT_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Kaya káddemát di ti Antioquia ay dinulaw di atanan a kakagumanan di a mánnampalataya, sakay imbareta di en atanan a ginamet nen Diyos ten pamamag-itan di. Sakay ni konya hidi a inátdenan nen Diyos ti pagkakataun a magpahayag ten Maganda a Bareta tánni sumampalataya en Hentil hidi. ");
INSERT INTO prfNT_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Nalay hidi a nákpágyan haud kaguman en mánnampalataya hidi. ");
INSERT INTO prfNT_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Peru tehud a sangan a lállaki a dummemát haud a gubwat ti Judea sakay nagtoldu ten mánnampalataya hidi ti kona háddi, “Ni awan kam magpaturi ayun ten paraan nen Kautusan ni Moises ay awan kam maligtas.” ");
INSERT INTO prfNT_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Awan pummayag de Pablo ay ti Bernabe kaya nagin mainit en diskusyonan di. Kaya nagkaessaan nen mánnampalataya hidi a paangayán de Pablo ay ti Bernabe ti Jerusalem sakay sangan hidi a kákkapatkaka a taga-Antioquia, tánni angay di itanung ten apostol hidi sakay ten pinunu nen simbaan en tungkul ti problemaid a iyud. ");
INSERT INTO prfNT_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Nadid pinarektatan ngani hidi nen simbaan. Ten lakad di ay rummoyot hidi ten prubinsiya a Fenicia sakay ten prubinsiya a Samaria, imbareta di haud ni konya a naakit en Hentil hidi a sumampalataya ten Diyos. Kaya tunay en saya nen atanan nen mánnampalataya hidi ti baretaid a iyud. ");
INSERT INTO prfNT_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Káddemát di ti Jerusalem ay masaya hidi a tinanggap nen apostol hidi, nen pinunu hidi sakay nen buu a simbaan haud sakay imbareta di en atanan a ginamet nen Diyos ten pamamag-itan di. ");
INSERT INTO prfNT_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Peru tummaknág en sangan a mánnampalataya a ked ten grupu nen Pariseo hidi, sakay kinagi di a, “En Hentil hidi ay dapat a magpaturi sakay kagiyán dikodi a sumunud ten Kautusan ni Moises.” ");
INSERT INTO prfNT_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Nadid, nagmiting en apostol hidi ay ten pinunu hidi nen simbaan tánni mapággurunan di en tungkul ti bagayid a iyud. ");
INSERT INTO prfNT_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Káttapos nen atakdug a diskusyonan di ay tummaknág ti Pedro a kinagi na, “Kákkapatkaka ku hidi, tukoy moy a tenhud ay piniliyák nen Diyos tánni ipangaral en Maganda a Bareta ten Hentil hidi sakay summampalataya hidi. ");
INSERT INTO prfNT_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","En Diyos a makatukoy ten isip nen balang essa dikotam en nangpatunay a tinanggap na hidi dikona nagkaluuban na hidi ti Banal a Ispiritu a kona labi dikotam. ");
INSERT INTO prfNT_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Impeta na a pantay en pangileng nen Diyos. Pinatawad na bi hidi ten kasalanan di gapu summampalataya hidi. ");
INSERT INTO prfNT_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Nadid ay gustu moy pa beman a subukán en Diyos? Bakin pagamet moy ten mánnampalataya hidi en bagay hidi a mágkahirap a maski en ninunu tam hidi sakay sikitam ay awan tam nagamet? ");
INSERT INTO prfNT_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Summampalataya kitam sakay naligtas ten pamamag-itan nen habag nen Panginoon Jesus a awan ti kaparehu.” ");
INSERT INTO prfNT_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Tummahimik hidi a atanan sakay nágsanig hidi kánde Pablo ay ti Bernabe a magbareta tungkul ten himala hidi a pinagamet nen Diyos ten atubengán nen Hentil hidi. ");
INSERT INTO prfNT_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Káttapos ay ti Santiago dámman en nagupos, “Kákkapátkaka ku hidi, sanigán moy kagiyán kuwiday. ");
INSERT INTO prfNT_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Káttapos la ni Simon a nagpaliwanag tungkul ten dipalongu a pángdulaw nen Diyos ten Hentil hidi tánni maski hidi ay magin tolay na. ");
INSERT INTO prfNT_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Kona háddi en hula nen propeta hidi a nakasulat: ");
INSERT INTO prfNT_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘Káttapos ni iyád ay magsoliyák a ruway. Sakay ipataknág ku a ruway en binumagsak a kahariyan ni David. Itaknág ku a ruway en pághari na a nasida. ");
INSERT INTO prfNT_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Tánni aryokán sakay sambaán nen atanan a tolay en Panginoon; nen atanan a bansa a dinulaw tánni magin kao ku. ");
INSERT INTO prfNT_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Kona haud en kinagi nen Panginoon a nángpakapospos ti hidi iyád a bagay tenhud pa a panahon.’ ");
INSERT INTO prfNT_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Kinagi pa ni Santiago a, “Kaya para dikoku ay dyan tamon paghirapán en Hentil hidi ten káadeni di ten Diyos. ");
INSERT INTO prfNT_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Mas mapiyya pa ni sulatan tam hidi a dyan kuman ti neatang ten diyos-diyosan hidi, dyan mangalunya, dyan kuman ten hayup hidi a nabitti sakay dyan kuman ti digi. ");
INSERT INTO prfNT_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Gapu sapul pa tenhud a panahun, en Kautusan ni Moises ay bábbasaán dán ten sinagoga hidi kada Aldew nen Káimang sakay itáttoldu iyád ten bawat banuwan.” ");
INSERT INTO prfNT_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Pákkasanig nen apostol hidi sakay nen pinunu hidi sakay nen atanan a mánnampalataya a naipun-ipun haud ten kinagi ni Santiago ay nagkaessaan di a mangpili ti sangan a lállaki ten mánnampalataya hidi tánni pákkuyugán di kánde Pablo ay ti Bernabe ti Antioquia. En duwwa a napili di ay ti Judas a dáddulawán di a Barsabas sakay ti Silas a igággalang nen mánnampalataya hidi. ");
INSERT INTO prfNT_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Sakay impatawid di en sulat a kona háddi en nakadátton, “Sikami a apostol ay ten pinunu hidi nen simbaan ay summulat sakay mákkumusta dikomoy a mánnampalataya hidi a Hentil a mágyan ti Antioquia, ti Siria sakay ti Cilicia. ");
INSERT INTO prfNT_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Nabareta mi a angen kam lálligaligán nen agum hidi a kakagumanan tam a gubwat háddi. Maski awan mi hidi inutusan a mángkagi ti kona haud. ");
INSERT INTO prfNT_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Kaya nagmiting kami sakay nagkaessaan mi a paangayán haán en duwwa hidi a napili mi a mángpaliwanag dikomoy. Pinákkuyug mi hidi ten mahal tam hidi a kákkapatkaka a de Bernabe ay ti Pablo a ");
INSERT INTO prfNT_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","awan nangsayang ten biyag di a mángtaya ten págserbi ten Panginoon tam a ti Jesu-Cristo. ");
INSERT INTO prfNT_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Pinaangay mi dikomoy de Judas ay ti Silas tánni hidi dán en mángpaliwanag ten insulat mi. ");
INSERT INTO prfNT_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Ten tulung nen Banal a Ispiritu ay naisipan mi a dyan kamon átdenan ti agum pa a utus nan en mágkahalaga la hidi a bagay, kona ti hidi iddi. ");
INSERT INTO prfNT_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Dyan moy kanán en neatang ten diyos-diyosan hidi, dyan kamon kuman ten tehud a digi sakay dyan moy dán kanán en hayup a nabitti, sakay dyan kamon mangalunya. Ni sunudán moy hidi iyád ay magin mahusay en biyag moy. Hanggan dálla haud salamat.” ");
INSERT INTO prfNT_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Nadid pinarektat di dán en napili di hidi a umangay ti Antioquia. Káddemát di haud ay pinisan di en atanan a mánnampalataya sakay inyatád di en sulat. ");
INSERT INTO prfNT_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Pángbasa di ten sulat ay nasaya a tarud en tolay hidi gapu ten nasanig di. ");
INSERT INTO prfNT_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","De Judas ay ti Silas ay propeta, kaya makpal hidi a kinákkagi ten mánnampalataya hidi a nangpabegsák ten isip di sakay nangpatibay ten pánnampalataya di. ");
INSERT INTO prfNT_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","En duwwa ay nákpágyan haud ti sangan a aldew. Káttapos ay nagsoli dán hidi a tawid di en págbati nen kákkapatkaka para ten nangutus hidi dikodi. ");
INSERT INTO prfNT_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Peru mas ginustu ni Silas a mawarak ti Antioquia. ");
INSERT INTO prfNT_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","De Pablo ay ti Bernabe ay nágyan palla ti Antioquia. Kakaguman di en agum hidi a mánnampalataya, intoldu di sakay impangaral en upos nen Panginoon. ");
INSERT INTO prfNT_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Kállipas nen sangan a aldew ay kinagi ni Pablo kánni Bernabe a, “Angen ta soliyán a bisitaán en kákkapatkaka ta hidi ti pánnampalataya ten siyudad hidi a nangaralan ta ten upos nen Panginoon. Sakay ilingán ta ni ánya dán papágyan diyid.” ");
INSERT INTO prfNT_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Gustu ni Bernabe a ikuyug ti Juan a ngángngaranan di labi a Marcos. ");
INSERT INTO prfNT_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Peru kánni Pablo ay awan tama a ikuyug di siya ta awan siya nákpagtapos ten tarabahu di sakay linakadan na pa hidi ten prubinsiya a Pamfilia. ");
INSERT INTO prfNT_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Nadid ay nagkahud hidi ti mainit a diskusyon kaya tulos hidi a naghiwalay. Ingkuyug ni Bernabe ti Juan Marcos sakay nággabeng hidi a ummangay ten dikál a puduk a Cyprus. ");
INSERT INTO prfNT_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Ingkuyug bi ni Pablo ti Silas sakay lummakad hidi káttapos a idasal nen mánnampalataya hidi a kagbiyan hidi nen Panginoon. ");
INSERT INTO prfNT_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Ummangay hidi ti Siria sakay Cilicia, sakay pinabegsák di en mánnampalataya hidi haud. ");
INSERT INTO prfNT_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Ummangay bi ti Pablo ti Derbe sakay ti Listra. Tehud haud a essa a disepulus en ngaran na ay ti Timoteo. En ina na ay mánnampalataya a Judio peru en ama na ay Griego. ");
INSERT INTO prfNT_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Igalang nen atanan a mánnampalataya ti Listra sakay ti Iconio ti Timoteo. ");
INSERT INTO prfNT_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Gustu a ikuyug ni Pablo ti Timoteo kaya tinuri na siya gapu tukoy nen Judio hidi ti siyudadid a iyud a Griego en ama na. ");
INSERT INTO prfNT_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Atanan nen banuwan a ummangayan di ay impakapospos di ten mánnampalataya hidi en napagkasunduwan nen apostol hidi sakay nen pinunu hidi nen simbaan ti Jerusalem a patakaran tánni iyud dán en sunudán di. ");
INSERT INTO prfNT_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Kaya tummibay en pánnampalataya nen bawat miyembru nen kada simbaan, sakay aldew-aldew ay mágdadadagdag hidi. ");
INSERT INTO prfNT_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Nadid, nangaral de Pablo ten lugar a Frigia sakay Galacia gapu awan hidi pinagustuwan nen Banal a Ispiritu a mangaral ten prubinsiya a Asia. ");
INSERT INTO prfNT_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Káddemát di ten tapat nen lugar a Misia ay gustu di nakuwan a sumáddáp ti Bitinia peru awan hidi pinagustuwan nen Ispiritu ni Jesus. ");
INSERT INTO prfNT_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Kaya nagtalib dálla hidi ten lugar a Misia sakay nagtulos ti Troas. ");
INSERT INTO prfNT_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Dikona a tidug ti Pablo ti gibiyid a iyud ay nagkahud siya ti pangitain, tehud a essa a lállaki a taga-Macedonia a mágtaknág sakay mákkekagbi dikona a kinagi na, “Angay kam pay ti Macedonia iday, kagbiyan moy kami a tulungan.” ");
INSERT INTO prfNT_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Kaya káttapos nen pangitain ni Pablo ay pagdaka kami a nagrektat a angay ti Macedonia, gapu nasigudu mi a paangayán kami haud nen Diyos tánni ipangaral mi en Maganda a Bareta. ");
INSERT INTO prfNT_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Sapul ti Troas ay nággabeng kami a patamu ti Samotracia sakay ten kailawan ay ti Neapolis. ");
INSERT INTO prfNT_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Sapul haud ay ummangay kami ti Filipos, essa a dikál a siyudad ti Macedonia a sakup ni Roma. Nákpágyan kami haud ti sangan a aldew. ");
INSERT INTO prfNT_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Ten Aldew nen Káimang nen Judio hidi ay lummuwas kami ten siyudad, ummangay kami ten gilid nen dinom gapu inisip mi a tehud a lugar haud a págdasalan nen Judio hidi. Nággetnud kami haud sakay nákpágguron ten bábbi hidi a nagipun-ipun. ");
INSERT INTO prfNT_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","En essa dikodi ay ti Lydia a taga Tiatira, máglaku siya ti mágkamahal a damit a inubi. Maka-Diyos siya a tolay. Mentras a mágsanig siya kánni Pablo ay binukasan nen Panginoon en isip na sakay naniwala siya ten kinákkagi ni Pablo. ");
INSERT INTO prfNT_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Nagpabinyag hidi a sabilay sakay inakit na kami, kinagi na, “Ni tenggiyánnák moy a tapat a tagapagserbi nen Panginoon ay kadtamon dibilay, haud kam a tumulos.” Mahigpit en pággakit na dikomi kaya awan mi naadiyan. ");
INSERT INTO prfNT_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Essa a aldew dikona a patamu kami ten lugar a págdasalan nen Judio hidi ay naketagbu kami ti essa a anak a bábbi a alipin. Sináddáp siya ni madukás a ispiritu. Iyád a ispiritu ay nangatád dikona ti kapangyariyan a makapanghula. Dikál a pilak en kitaán nen amu na hidi ten pághula na. ");
INSERT INTO prfNT_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Ummunonud siya dikomi a de Pablo sakay ipáppákraw na a, “Hidi iyád a tolay ay tagapagserbi nen kataasan a Diyos! Ummangay hidi háddi tánni ipangaral di dikomoy ni konya kam a maligtas.” ");
INSERT INTO prfNT_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Pirmi na iyud a gággamitán dikomi aldew-aldew kaya naiyamut ti Pablo. Inatubeng na en anak a bábbi sakay kinagi na ten madukás a ispiritu, “Ten ngaran ni Jesu-Cristo, ay utusan taka a umibut ka dán haán ti bábbiyen!” Ti odas biyid a iyud ay pagdaka a ummibut en madukás a ispiritu. ");
INSERT INTO prfNT_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Dikona netan nen amu hidi nen anak a nawan dán en pagkapilakan di ay dinuklos di de Pablo ay ti Silas sakay ginuyud di hidi ten matolay a lugar sakay inyatubeng di hidi ten pinunu hidi. ");
INSERT INTO prfNT_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Inyatubeng di hidi ten pinunu hidi nen siyudad sakay binintang di hidi ti kona háddi, “I duwwaiday a Judio ay manggulu hidi ten siyudad. ");
INSERT INTO prfNT_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Magtoldu hidi ti kaugaliyan a bawal ten kautusan tam hidi a Romano. Awan tam maari a tanggapán itáttoldu diyen.” ");
INSERT INTO prfNT_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Sabay-sabay a sinumunggab en katolayan kánde Pablo ay ti Silas, sakay pinaeklasan hidi nen pinunu hidi a tulos di a pinahaplit en duwwa. ");
INSERT INTO prfNT_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Káttapos di hidi a hináhhaplit ay impepiresu di hidi sakay pinabantayan ti mapiyya. ");
INSERT INTO prfNT_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Insáddáp hidi nen guwardiya ten kadisaladan nen págpiresuwan sakay ingkandadu di en kayu a sássulutan nen babásset di. ");
INSERT INTO prfNT_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Nadid, dikona hatinggabi dán ay magdasal de Pablo ay ti Silas sakay mágkansyon hidi ti papuri sakay págsamba para ten Diyos. En agum hidi a piresu ay mágsanig dikodi. ");
INSERT INTO prfNT_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Bigla a naglinug ti tunay ti begsák, nayanág maski pundasyon nen págpiresuwan. Pagdaka a bummukas en atanan nen pintuwan sakay naokbis en kadena nen atanan a piresu. ");
INSERT INTO prfNT_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Nalukag en guwardiya nen págpiresuwan sakay dikona ketan na a bukas dán en pintuwan hidi ay akala na ni nakaginan dán en piresu hidi. Kaya binagut na en áttak na a laan na dán a bunuwán en sadili na. ");
INSERT INTO prfNT_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Peru pinákrawan siya ni Pablo a kinagi na, “Dyan mu bunuwán i sadili muwen ked kami la háddi a atanan!” ");
INSERT INTO prfNT_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Nággid ti simbuwan en guwardiya sakay nagginan a summáddáp sakay lummuhud a magpágpág ten atubengán de Pablo ay ti Silas. ");
INSERT INTO prfNT_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Inluwas na hidi sakay nagtanung siya dikodi, “Ánya i dapat kuwid a gamitán tánni maligtasák?” ");
INSERT INTO prfNT_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Kinagi di, “Sumampalataya ka ten Panginoon a ti Jesus tánni maligtas ka, siko ay ten kasabilay mu.” ");
INSERT INTO prfNT_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Impangaral di dikona en upos nen Panginoon sakay ten atanan nen kaguman na hidi ten bilay na. ");
INSERT INTO prfNT_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Ti odas biyid a iyud ay lininisan nen guwardiya en tali-talingu de Pablo ay ti Silas, nagpabinyag siya sakay en kasabilay na hidi. ");
INSERT INTO prfNT_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Káttapos ay ingkuyug na hidi ten bilay na sakay pinakan na hidi. Tunay en saya na sakay ten kasabilay na hidi gapu natukuyan di dán a sumampalataya ten Diyos. ");
INSERT INTO prfNT_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Ten kadimadimangan na ay inutusan nen pinunu hidi nen siyudad en sundalu hidi a palayaán di de Pablo ay ti Silas. ");
INSERT INTO prfNT_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Kinagi nen guwardiya kánni Pablo, “Inyutus nen pinunu hidi a maari kam kanon a lumaya. Kammoy dán, lumakad kamon a mapayapa.” ");
INSERT INTO prfNT_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Peru kinagi ni Pablo dikodi, “Pinayabat di kami ten atubengán nen makpal a tolay sakay impiresu di kami maski awan kami palla naimbistigaan, samantala taga-Roma kami bi! Nadid ay gustu di kami a palayaán ti sekretu! Awan, awan maari! Kailangan a hidi angayid háddi a mangpalaya dikomi.” ");
INSERT INTO prfNT_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Impakapospos nen sundalu hidi ten pinunu hidi nen siyudad en kinagi ni Pablo. Minanteng hidi dikona napospusan di a de Pablo ay ti Silas ay taga-Roma bali. ");
INSERT INTO prfNT_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Kaya ummangay en pinunu hidi ten págpiresuwan sakay náktawad hidi kánde Pablo ay ti Silas. Inluwas di hidi ten págpiresuwan sakay inuron di hidi a lakadan di dán en siyudad. ");
INSERT INTO prfNT_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Nadid ten kálluwas de Pablo ay ti Silas ten págpiresuwan ay nagtulos hidi ten bilay ni Lydia. Dinemáttan di en mánnampalataya hidi haud, bagu a lummakad en duwwa ay pinayuwan di hidi a magpakatibay ten pánnampalataya di. ");
INSERT INTO prfNT_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Nadid, rummoyot de Pablo ay ti Silas ti Amfipolis sakay Apolonia, sakay nagtulos hidi ti Tesalonica. Ti lugarid a iyud ay tehud a sinagoga en Judio hidi. ");
INSERT INTO prfNT_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Gapu ugali dán ni Pablo, ay ummangay dámman siya ten sinagoga haud. Ten luub nen tállu a simba kada-Aldew nen Káimang nen Judio hidi ay ked siya ten sinagoga a mákpagpaliwanagan tungkul ten Kasulatan. ");
INSERT INTO prfNT_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Impaliwanag na sakay pinatunayan a en Cristo ay dapat pa a magdanas ti hirap sakay mabiyag a ruway. Kinagi na, “Ti Jesus a impakapospos ku dikomoy ay siya en Cristo.” ");
INSERT INTO prfNT_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Naakit sakay nákkuyug kánde Pablo ay ti Silas en sangan dikodi, kona bi ten tanyag hidi a kabábbiyan sakay en Griego hidi a maka-diyos. ");
INSERT INTO prfNT_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Peru nainggit en Judio hidi kaya sinulsulan di sakay pinisan en abusador hidi, sakay inutusan di hidi a manggulu ten siyudad. Sináddáp di en bilay ni Jason, pilit di a aryokán de Pablo ay ti Silas tánni iyatubeng ten tolay hidi. ");
INSERT INTO prfNT_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Dikona awan di ketan en duwwa ay imbaling di en iyamut di kánni Jason, binerber di siya sakay kaguman en sangan a mánnampalataya sakay inyangay di hidi ten pinunu hidi nen siyudad. Kona háddi en ipáppákraw di, “Hidi iyád a tolay ay manggugolu maski hádya angayan diyid, ");
INSERT INTO prfNT_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","pinatulos hidi ni Jason ten bilay na. Sinuway di en atanan kautusan nen Emperador. Kinagi di pa a tehud a iba a hari a ngaran naid ay ti Jesus.” ");
INSERT INTO prfNT_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Pákkasanig nen tolay hidi sakay nen pinunu hidi nen siyudad ten ipáppákraw di ay minamagkagulu hidi. ");
INSERT INTO prfNT_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Bagu a pinalaya nen pinunu hidi ti Jason sakay ten kakagumanan na hidi ay pinagbayad di pa ti piyansa. ");
INSERT INTO prfNT_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Ti gibiyid a iyud ay pinaangay nen mánnampalataya hidi de Pablo ay ti Silas ti Berea. Káddemát di haud ay ummangay hidi ten sinagoga nen Judio hidi. ");
INSERT INTO prfNT_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Mas maganda a kauron en Judio hidi ti Berea nan en Judio di ti Tesalonica. Entrisadu hidi a tarud a mágsanig ten paliwanag ni Pablo, pagadalan di a aldew-aldew en Kasulatan tánni mapatunayan di ni tatarudan en kákkagiyán ni Pablo. ");
INSERT INTO prfNT_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Makpal en summampalataya haud a Judio kona bi ten Griego hidi, lállaki ay ti bábbi a tanyag ti lugarid a iyud. ");
INSERT INTO prfNT_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Peru pákkabareta nen Judio hidi ti Tesalonica a impangaral ni Pablo en upos nen Diyos ti Berea ay ummangay bi hidi haud tánni sulsulan di en tolay hidi a manggulu ten banuwan. ");
INSERT INTO prfNT_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Pagdaka a pinalakad nen mánnampalataya hidi ti Pablo sakay pinaangay di siya ten gilid nen diget, peru nawarak de Silas ay ti Timoteo. ");
INSERT INTO prfNT_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","En nángtugán hidi kánni Pablo ay nákkuyug hanggan ti Atenas sakay nagsoli hidi ti Berea a tawid en bilin ni Pablo kánde Silas ay ti Timoteo a umunud hidi a pagdaka. ");
INSERT INTO prfNT_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Alay ni Pablo a maguray ten duwwa ti Atenas ay netan na a todu en diyos-diyosan ten siyudad. Kaya nagsaket ti hustu en isip na. ");
INSERT INTO prfNT_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Kaya nákpagpaliwanagan siya ten sinagoga hidi haud, ten Judio hidi sakay ten relihiyoso hidi a tolay, sakay maski deya matagbu na ten matolay a lugar aldew-aldew. ");
INSERT INTO prfNT_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Nákpagdiskusyon bi dikona en sangan a maistu a kabilang ten grupu a Epicureo sakay Estoico. Tehud bi a sangan a nagkagi a, “Ánya wád i gustuwid a kagiyán ni magmala-malalakiyanen a lállaki?” En agum hidi ay kinagi di, “Magtoldu wád tungkul ten diyos nen iba a banuwan.” Nakagi di iyud gapu en itáttoldu ni Pablo ay tungkul kánni Jesus sakay en kákkabiyag a ruway. ");
INSERT INTO prfNT_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Kaya inyangay di siya ten págmitingan di ten Areopago tánni imbistigaan, kinagi di, “Gustu mi la a matukuyan ni ánya gustuwid a kagiyán ni biguwen a itáttoldu mu. ");
INSERT INTO prfNT_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Iba iyán a toldu gapu pákkasanig mi palla kaya gustu mi a matukuyan ni ánya gustu naid a kagiyán.” ");
INSERT INTO prfNT_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Gapu en taga-Atenas hidi maski en dayu hidi a mágyan dán haud ay gugustu di a pamággurunan sakay sanigán en tungkul ten bigu a toldu. ");
INSERT INTO prfNT_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Kaya tummaknág ti Pablo ten atubengán nen miting di ten Areopago, kinagi na dikodi, “Sikam a taga-Atenas hidi, netan ku a masiyadu kam a relihiyoso. ");
INSERT INTO prfNT_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Gapu ten páglalebut ku ti banuwan moyiday ay neilingan ku ten lugar hidi a págdasalan moy en essa a altar a nakasulat en kona háddi, ‘Ten Diyos a awan matenggi.’ En Diyos a awan moy matenggi a páppuriyán moy ay siya en ipangaral ku nadid dikomoy. ");
INSERT INTO prfNT_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","En Diyos a nanglalang ti munduwiday sakay ten atanan a mágyan haád ay siya en Panginoon ten langet ay ten luta. Awan siya maari a mágyan ten templo a ginamet ni tolay. ");
INSERT INTO prfNT_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Awan siya mangailangan ti ányaman a tulung nen tolay, ta siya en nangatád ti biyag, angás sakay atanan a bagay ten atanan a tolay. ");
INSERT INTO prfNT_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Linalang na en atanan a lahi a gubwat ten essa a tolay sakay pinágyan na hidi ti buuwiday a mundu. Intakda na en hayunán nen balang essa sakay en mapágyanan na. ");
INSERT INTO prfNT_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Ginamet na iyud tánni aryokán di siya, tánni ten pággaryok di ay bakay sakali a ketan di siya. Peru i tatarudanid ay kadeni tam la siya. ");
INSERT INTO prfNT_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Gapu, ‘Tawid na i biyag tamiday, ararikad sakay pagkatolay.’ Kona ten kinagi nen sangan ten mágtula moy hidi, ‘Sikitam ay anak na.’ ");
INSERT INTO prfNT_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Gapu sikitam ay anak nen Diyos, ay dyan tam ipalagay a siya ay kona la ten ribultu a gintu, pilak, oni batu a linalang la ni isip sakay lima ni tolay. ");
INSERT INTO prfNT_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Nalay a panahun a pinabayan nen Diyos en tolay ten awan di pángtenggi dikona. Peru nadid ay awan dán, gapu inyutus na a magsisi en atanan a tolay sakay adeyuwan di dán en madukás di a kákkabiyag. ");
INSERT INTO prfNT_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Gapu intakda na dán en aldew nen pághatul ti munduwiday, sakay iyád ay gamitán na a makatarungan ten pamamag-itan nen essa a tolay a pinili na. Pinatunayan na iyud dikona biniyag a ruway i tolayid a iyud.” ");
INSERT INTO prfNT_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Pákkasanig di ten kinagi ni Pablo tungkul ten kákkabiyag a ruway ay tinulokyu siya nen agum. Peru en agum ay kinagi di a, “Gustu mi a masanig a ruway i kinákkagi muwen.” ");
INSERT INTO prfNT_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Sakay linakadan dán hidi ni Pablo. ");
INSERT INTO prfNT_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Tehud a sangan a naniwala dikona sakay summampalataya ten Diyos. Kaguman haud de Dionisio a kabilang ten grupu a mágmiting ten Areopago, en bábbi a Damaris en ngaran na sakay en agum pa hidi a tolay. ");
INSERT INTO prfNT_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Káttapos ay lummakad ti Pablo ti Atenas sakay ummangay ti Corinto. ");
INSERT INTO prfNT_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Nakilala na haud en essa a Judio a Aquila en ngaran na, siya ay taga-Ponto. Káddemát na la a gubwat ti Italia a kaguman na en kabinga na a ti Priscila, gapu pinalakad ni Emperador Claudio atanan a Judio ti Roma. Ummangay ti Pablo ten bilay di, ");
INSERT INTO prfNT_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","sakay gapu parehu hidi a mággamet ti tolda ay nákpágyan dán siya haud sakay nákpagtarabahu dikodi. ");
INSERT INTO prfNT_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Kada Aldew nen Káimang nen Judio hidi ay angay ti Pablo ten sinagoga a mákpagpaliwanagan ten Judio hidi sakay ten Griego hidi, pilitán na hidi a maakit a sumampalataya. ");
INSERT INTO prfNT_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Dikona dummemát de Silas ay ti Timoteo a gubwat ti Macedonia ay awan dán ti agum a pináppospos ti Pablo aldew-aldew nan mangaral sakay magpatunay ten Judio hidi a ti Jesus en Cristo. ");
INSERT INTO prfNT_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Peru kinontra di siya sakay ininsultu di, kaya impagpag na en alikabuk ten badu na, bilang babala dikodi. Kinagi na, “Kasalanan moy dán iyán ni mepahamak kam! Awanák moy dán masisi! Sapul nadid ay angayák ten Hentil hidi mangaral.” ");
INSERT INTO prfNT_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Kaya linakadan na hidi sakay tummulos siya ten bilay ni Ticio Justo siya ay Hentil a maka-diyos, en bilay na ay kasadát nen sinagoga. ");
INSERT INTO prfNT_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Ti Crispo a pinunu ten sinagoga ay summampalataya ten Panginoon kona bi ten kasabilay na hidi. Makpal pa ten taga-Corinto hidi a nágsanig kánni Pablo en summampalataya sakay nagpabinyag. ");
INSERT INTO prfNT_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Essa a gibi dikona tidug ti Pablo ay nákpágguron dikona en Panginoon ten pangitain a kinagi na, “Dyan ka manteng, itulos mu la i pángngaral muwen! Maski ánya en mangyari ay dyan ka la umimang. ");
INSERT INTO prfNT_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Awan ti mangpasaket dikomu ta kagumanák mu, sakay makpal en mánnampalataya dikoku ti siyudadid a iyád.” ");
INSERT INTO prfNT_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Kaya sataon ay ti kalahati siya a nákpágyan haud a nangaral ten tolay hidi ten upos nen Diyos. ");
INSERT INTO prfNT_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Ten dikona ti Galio dán en nagin gubernador ti Acaya ay nagkaessaan nen Judio hidi a dinikáp ti Pablo sakay inyangay di ten pághatulan. ");
INSERT INTO prfNT_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Kinagi di, “I tolayidi ay magakit ten tolay hidi a sumamba ten Diyos ten paraan a bawal ten kautusan!” ");
INSERT INTO prfNT_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Magupos dán nakuwan ti Pablo peru nagupos dán ti Galio a kinagi na, “Sikam a Judio hidi, ni madággi a kasalanan i reklamu moyen sakay ni páglabag ten batas ay dapat la a pospusán takam. ");
INSERT INTO prfNT_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Peru i reklamu moyen ay tungkul la ti upos, ngaran hidi sakay ten kautusan moy hidi a Judio ay umáddák a makialam ti bagayid a iyán. Bahala kamon!” ");
INSERT INTO prfNT_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Sakay pinaluwas hidi nen gubernador ten pághatulan. ");
INSERT INTO prfNT_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Sinunggaban di ti Sostenes a pinunu ten sinagoga. Binálbág di siya ten atubengán nen pághatulan peru awan iyud pinospos ni Galio. ");
INSERT INTO prfNT_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Káttapos ni pangyayariyid a iyud ay nákpágyan pa ti Pablo ti Corinto ti sangan a aldew, sakay nagpaalam ten mánnampalataya hidi. Káttapos ay ummangay siya ti Cencrea a adeni ten diget. Nagpapolpok siya haud tanda a natupad na dán en pangaku na ten Diyos. Sakay nággabeng siya a tamu ti Siria kaguman en magkabinga a Aquila sakay Priscila. ");
INSERT INTO prfNT_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Káddemát di ti Efeso ay inwarak ni Pablo en duwwa sakay summáddáp siya ten sinagoga nen Judio hidi. Nákpagpaliwanagan siya ten ked hidi haud. ");
INSERT INTO prfNT_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Inagid di dikona a ni maari ay mágyan pa siya haud ti sangan a aldew peru inumád siya. ");
INSERT INTO prfNT_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Peru dikona magpaalam dán siya ay kinagi na dikodi, “Magsoliyák haád a ruway ni kagustuwan nen Diyos.” Sakay lummakad siya ti Efeso a nagsakay ti abeng. ");
INSERT INTO prfNT_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Dikona dummung siya ti Cesarea ay ummangay siya ten mánnampalataya hidi ti Jerusalem. Binati na hidi sakay káttapos ay nagtulos dán hidi ti Antioquia. ");
INSERT INTO prfNT_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Nágyan siya haud ti sangan a aldew sakay káttapos ay rummektat dámman siya. Rummoyot siya ten lugar a Galacia sakay Frigia sakay pinabegsák na en pánnampalataya nen atanan a disepulus haud. ");
INSERT INTO prfNT_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Tehud a dummemát a essa Judio ti Efeso a Apolos en ngaran na, neenak siya ti Alejandria sakay malalaki siya a magdiskurso sakay makpal a kabetuwan ten Banal a Kasulatan. ");
INSERT INTO prfNT_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Natolduwan siya tungkul ten Dilan nen Panginoon sakay masipag siya a mangaral sakay intáttoldu na ti tama en tungkul kánni Jesus. Peru en tukoy na la ay en págbinyag ni Juan. ");
INSERT INTO prfNT_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Mabegsák en isip na a nangaral ten sinagoga nen Judio hidi. Dikona nasanig nen magkabinga a Aquila sakay Priscila en págpaliwanag ni Apolos ay inakit di siya sakay ingkuyug di ten bilay di sakay impaliwanag di pa dikona ti hustu en bagay hidi a awan na palla tukoy tungkul ten Dilan a impeta nen Diyos. ");
INSERT INTO prfNT_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Dikona naggayak siya a angay ti Acaya ay nagsulat en mánnampalataya ten disepulus hidi haud a tanggapán di ti mahusay ti Apolos. Káddemát na haud ay dikál en netulung na ten mánnampalataya hidi ten pamamag-itan nen kabaitan nen Diyos. ");
INSERT INTO prfNT_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Gapu tunay siya ti husay a nagpaliwanag ay awan siya nadaig nen Judio hidi ten atubengán nen katolayan hidi. Pinatunayan na dikodi ten pamamag-itan nen Kasulatan a ti Jesus en Cristo. ");
INSERT INTO prfNT_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Mentras a ked palla ti Apolos ti Corinto, ti Pablo ay tinamu na en mabuki-bukid a lugar ten prubinsiya a hanggan nakademát siya ti Efeso. Netan na haud en sasangan a disepulus. ");
INSERT INTO prfNT_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Tinanung na hidi a kinagi na, “Natanggap moy dán beman en Banal a Ispiritu dikona summampalataya kam?” “Awan palla, ni awan mi ngani nasanig a tehud a Banal a Ispiritu,” tábbig di. ");
INSERT INTO prfNT_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Kaya nagtanung ti Pablo, “Ni konahud, ay konya kam a nabinyagan?” Kinagi di, “En págbinyag ben ni Juan.” ");
INSERT INTO prfNT_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Kinagi ni Pablo, “En págbinyag ni Juan ay para ten tolay a nagsisi dán ten kasalanan na. Impangaral na ten Israelita hidi en págsisi tánni sumampalataya hidi kánni Jesus, en dumemát a kasunud na.” ");
INSERT INTO prfNT_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Dikona masanig di iyud, ay nagpabinyag hidi ten ngaran nen Panginoon a ti Jesus. ");
INSERT INTO prfNT_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Intupu ni Pablo en lima na ten ulu di. Sakay dummibábbi dikodi en Banal a Ispiritu kaya nakapagupos hidi ti iba-iba a upos sakay nagpahayag hidi ti upos a gubwat ten Diyos. ");
INSERT INTO prfNT_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Tehud a manga sapulu ay ti duwwa a lállaki en nagpabinyag. ");
INSERT INTO prfNT_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Mággangay ti Pablo ten sinagoga hidi ten luub nen tállu a bulan sakay mabegsák en isip na a mágpapaliwanagán sakay akitán na en tolay hidi a magpasakup ten pághari nen Diyos. ");
INSERT INTO prfNT_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Peru tehud a sangan dikodi a maktug ti pággisipan a umád a sumampalataya sakay nagupos pa hidi ti madukás ten atubengán nen katolayan ti kontra ten Dilan nen Panginoon. Kaya linakadan ni Pablo en sinagoga, ingkuyug na en mánnampalataya hidi a tamu ten iskuwilaan ni Tirano sakay nagtulos-tulos siya a nangaral aldew-aldew. ");
INSERT INTO prfNT_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Nagnalay siya haud ti duwataon kaya en tolay hidi a mágyan ti Asia Judio man oni Griego ay nakasanig ten upos nen Panginoon. ");
INSERT INTO prfNT_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Naggamet haud en Diyos ti himala ten pamamag-itan ni Pablo. ");
INSERT INTO prfNT_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Maski panyu oni badu a nagamit ni Pablo ay iyangay di ten tehud hidi a saket. Magpiyya hidi maski en mágkadukás a ispiritu a mangpahirap dikodi ay lumakad. ");
INSERT INTO prfNT_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Tehud a sangan haud a Judio a maglebut a magpalakad ti mágkadukás a ispiritu, pinurbaan di a gamitán en ngaran ni Jesus ten págpalakad di ti mágkadukás a ispiritu. Kinagi di, “Ten ngaran ni Jesus a impangaral ni Pablo, utusan takam a lumakad kamon haán!” ");
INSERT INTO prfNT_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Kaguman dikodi en pittu a anak a lállaki ni Esceva, a kapunuwan a padi nen Judio hidi. ");
INSERT INTO prfNT_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Peru tinábbig hidi nen madukás a ispiritu, “Matenggi ku ti Jesus sakay matenggi ku bi ti Pablo. Peru sikam deya kam?” ");
INSERT INTO prfNT_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Sakay bigla hidi a dinugtuwan nen lállaki a sináddáp nen madukás a ispiritu. Natalu na hidi atanan sakay tináttalinguwan na hidi, tulos na a pinisad-pisad en babadu di kaya eklas hidi a gumminan a gubwat ti bilayid a iyud. ");
INSERT INTO prfNT_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Nabareta iyud nen atanan a taga-Efeso, Judio ay ti Griego kaya nanteng hidi a atanan, sakay pinuri di en ngaran nen Panginoon a ti Jesus. ");
INSERT INTO prfNT_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Makpal bi ten summampalataya hidi en nángtapat ten kakpalan ten mágkadukás di hidi a gamet. ");
INSERT INTO prfNT_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Induru nen makpal a tehud a galing-galing en lilibru di hidi sakay tinutud di ten atubengán nen kakpalan. En karkula di ten halaga nen libru hidi ay ummabut ti limmapulu a libu a silber. ");
INSERT INTO prfNT_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Kaya ten pamamag-itan nen kapangyariyan nen Panginoon, tulos-tulos a kummalat sakay nagtagumpay en upos na. ");
INSERT INTO prfNT_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Nadid, káttapos ni pangyayariyid a iyud, ten tulung nen Ispiritu, ay naisip ni Pablo a maglakbay ti Macedonia sakay ti Acaya a patamu ti Jerusalem. Kinagi na, “Kággubwat ku ti Jerusalem ay kailangan a bumisitaák bi ti Roma.” ");
INSERT INTO prfNT_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Pinágdipalongu na ti Macedonia de Timoteo ay ti Erasto, hidi a duwwa en kaguman na, sakay nákpágyan palla siya ti Asia ti badit a panahon. ");
INSERT INTO prfNT_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Ti panahunid a iyud ay nagkahud ti mahigpit a kaguluwan ti Efeso tungkul ten Dilan a impeta nen Panginoon. ");
INSERT INTO prfNT_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Tehud a essa a mágpanday a en ngaran na ay ti Demetrio. Mággamet siya ti bábbadit a templo a yari ti silber para ten diyos-diyosan di a Artemis. Dikál i kita naid haud. ");
INSERT INTO prfNT_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Pinisan ni Demetrio en tarabahador na hidi sakay en agum hidi a tolay a kaparehu na ti kabiyagan. Sakay kinagi na, “Kakagumanan ku hidi, i tarabahu tam la iday en paggubwatan nen maganda tam a kabiyagan. ");
INSERT INTO prfNT_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Nadid, netan moy sakay nasanig en kinákkagi ni Pablowid a iyán. Kinagi na a en diyos kan a ginamet la ni lima ni tolay ay bakán a tatarudan a diyos sakay makpal dán en naakit na. Bakán la a háddi ti Efeso nan ngari-ngari a pati ti buu a Asia. ");
INSERT INTO prfNT_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Madukás i risultaid ni itáttoldu na en. Masida en ngaran nen tarabahu tam. Bakán la iyud nan pati en templo nen mataas a diyos tam a ti Artemis ay mawanan ti serbi sakay awan di dán siya igalang. Siya pa beman en diyos a sambaán ti buu a Asia ay ten atanan a tolay ti munduwiday. ");
INSERT INTO prfNT_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Dikona masanig di iyud ay inuminit en iyamut di sakay impákraw di a, “Ti Artemis a diyos ni Efeso ay kataasan!” ");
INSERT INTO prfNT_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Gapu ti iyud ay nagkagulu ti hustu en buu a siyudad ten pákrawan. Binerber di de Gayo ay ti Aristarco a taga-Macedonia a kaguman ni Pablo sakay sabay-sabay di hidi a inyangay ten págmitingan. ");
INSERT INTO prfNT_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Gustu nakuwan ni Pablo a angay ten atubengán nen tolay hidi peru sinaway siya nen mánnampalataya hidi. ");
INSERT INTO prfNT_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Impekagi bi nen amigu na hidi a pinunu nen prubinsiya a Asia a mahigpit a dyan siya umangay ten págmitingan. ");
INSERT INTO prfNT_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Magulu a tarud en tolay hidi ten págmitingan. En agum ay mángpákraw ti essa a bagay, en agum ay iba bi en ipákraw di sakay awan tukoy nen kakpalan ni bakin ked hidi haud a naipun-ipun. ");
INSERT INTO prfNT_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Inisip nen agum a tolay a ked haud ti Alejandro i nagsapulanid nen gulu gapu siya en pinataknág nen Judio hidi ten atubengán. Dikona mágtaknág dán siya ay nagsinyas siya a tumahimik en tolay hidi tánni makapagpaliwanag siya. ");
INSERT INTO prfNT_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Peru dikona matukuyan di a Judio labi siya ay lalu hidi a namagpákrawan ten luub nen duwang-odas ti kona háddi, “Ti Artemis a diyos ni Efeso ay kataasan!” ");
INSERT INTO prfNT_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Nadid ten dimudyan ay napatahimik labi hidi nen pinunu nen banuwan. Kinagi na ten tolay hidi, “Sikam a taga-Efeso, deya beman awanid makatukoy a i siyudadiday a Efeso ay siya en nakabahala ten templo nen mataas a Artemis, kona bi ten banal a batu a naragrag a gubwat dilanget? ");
INSERT INTO prfNT_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Awan ti makapagkagi a kakabuliyan i bagayid a iyád. Kaya tumahimik kam sakay dyan kam pabigla-bigla. ");
INSERT INTO prfNT_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","I duwwaen a inyangay moy háddi ay awan nagtakaw ten templo sakay awan nagupos ti madukás ten diyosa tam. ");
INSERT INTO prfNT_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Kaya ni ti Demetrio ay ten tarabahador na hidi en tehud a reklamu kontra kándeyaman ay maari na a iyangay en kasu ten pághatulan, tehud a pinunu a maari a manghatul. ");
INSERT INTO prfNT_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Sakay ni tehud kam pa a gustu a kagiyán ay dapat a pamággurunan sakay disisyunan ten miting a intakda nen batas. ");
INSERT INTO prfNT_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Dilikadu kitam ti nangyariyiday nadid a aldew bakay ni siriyán di kitam ay awan kitam ti katuwiran ni bakin nagkagulu i siyudad tamiday.” ");
INSERT INTO prfNT_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Káttapos na a nagupos ay pinalakad na dán en tolay hidi. ");
INSERT INTO prfNT_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Dikona ummimang dán en kaguluwan ay pinadulaw ni Pablo en disepulus hidi sakay pinabegsák na en isip di. Káttapos ay nagpaalam siya sakay ummangay ti Macedonia. ");
INSERT INTO prfNT_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Binisita na en banu-banuwan haud, nagtoldu siya sakay pinabegsák na en isip nen disepulus hidi haud. Káttapos ay nagtulos dán siya hanggan nakademát ti Grecia. ");
INSERT INTO prfNT_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Nágyan siya haud ti tállu a bulan. Lumakad dán nakuwan siya a tamu ti Siria, peru nabareta na a tehud a balak a madukás en Judio hidi dikona, naisip na a magkon dálla siya ti Macedonia ten kássoli na. ");
INSERT INTO prfNT_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Nákkuyug dikona ti Sopater a anak ni Pirro a taga-Berea sakay de Aristarco ay ti Segundo a taga-Tesalonica, ti Gayo a taga-Derbe, ti Timoteo sakay de Tiquico ay ti Trofimo a taga-Asia. ");
INSERT INTO prfNT_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Nágdipalongu hidi sakay inuray di kami ti Troas. ");
INSERT INTO prfNT_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Káttapos nen Piyesta nen Tinapay a awan ti Págpaalsa ay nággabeng kami a gubwat ti Filipos. Kállipas nen limma a aldew ay dummung kami ti Troas sakay nágyan kami haud ti pittu a aldew. ");
INSERT INTO prfNT_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Ten gibi nen sabado ay nagipun-ipun kami ten págtáppeng-táppeng ti tinapay. Nangaral ti Pablo hanggan ten hatinggabi gapu ten kadimadimangan na ay lumakad dán siya. ");
INSERT INTO prfNT_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Makpal a simbuwan ten disunu nen bilay a nagipun-ipunan mi. ");
INSERT INTO prfNT_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Mággetnud en essa a binatilyu ten bintana mentras mágsanig a ti Eutico en ngaran na. Gapu ten katakdug nen págpaliwanag ni Pablo ay nagtongka siya tulos a netidug. Awan nagnalay ay natápduk siya a gubwat ten kattállu a palapag nen bilay, kaya patay dán siya dikona inágkat di. ");
INSERT INTO prfNT_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Ummugsad ti Pablo sakay kinábkábban na siya, kinagi na, “Dyan kam mabalisa, biyag la siya.” ");
INSERT INTO prfNT_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Summangkay siya a ruway ten disunu, nagtáppeng-táppeng ti tinapay sakay kumman hidi. Intulos na en págpaliwanag na dikodi hanggan ten dimadimang sakay lummakad dán siya. ");
INSERT INTO prfNT_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Inyoli di a biyag en binatilyu kaya masaya hidi a tarud. ");
INSERT INTO prfNT_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Nágdipalongu kami a nagsakay ti barku sakay dummung ti Ason. Haud kami kan dálla a mamagketa a de Pablo ta iyud en kinagi na dikomi. Gapu gustu na a magsakay ti sássakayan a pangluta. ");
INSERT INTO prfNT_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Dikona namagketa kami dán ti Ason ay náksakay bi siya ten barku a págsakayan mi kaya kaguman mi dán siya a ummangay ti Mitilene. ");
INSERT INTO prfNT_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Sapul ti Ason ay nagtulos kami ten biyahi mi sakay ten kailawan na ay tummalib kami ten tapat ni Quio. Ten ruway a aldew ay tummalib kami ti Samos, lummipas pa en essa aldew ay dummemát kami dámman ti Mileto. ");
INSERT INTO prfNT_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Nagdisisyon ti Pablo a dyan dálla rumoyot ti Efeso tánni awan dán maabala ti Asia. Gapu ni maari ay gustu na a ked dán siya ti Jerusalem ten aldew nen Pentecostes. ");
INSERT INTO prfNT_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Dikona ked ti Pablo ti Mileto ay pinadulaw na en pinunu hidi nen mánnampalataya hidi ti Efeso. ");
INSERT INTO prfNT_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Káddemát di haud ay kinagi na dikodi, “Tukoy moy ni konyaák a nákpágyan dikomoy sapul ten purumeru a aldew a káddemát ku ti Asia. ");
INSERT INTO prfNT_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Nagpakababaák a nagserbi ten Panginoon sakay tummákták en luwa ku a nagtiis ten makpal a pagsubuk gapu ten madukás a balak nen Judio hidi dikoku. ");
INSERT INTO prfNT_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Dikona nangaralák sakay nagtoldu dikomoy ten atubengán nen katolayan oni ten bila-bilay moy ay awanák ti intagu a kagiyán basta ten kapiyyaan moy. ");
INSERT INTO prfNT_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Impangaral ku ten Judio hidi ay ten Griego hidi a dapat hidi a magsisi ten kasalanan di sakay magsoli ten Diyos sakay sumampalataya ten Panginoon a ti Jesu-Cristo. ");
INSERT INTO prfNT_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Nadid, bilang kássunud ten Banal a Ispiritu ay angayák ti Jerusalem, awan ku tukoy ni ánya mangyariyid dikoku haud. ");
INSERT INTO prfNT_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Basta tukoy ku laid ay ten balang banuwan a inangayan ku dán ay kinagi nen Banal a Ispiritu a kedák ti kákkapiresu ay ti pághirap. ");
INSERT INTO prfNT_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Peru awan ti halaga dikoku i biyag kuwiday, en mahalaga ay matupad ku la en tungkulin ku a inyatád nen Panginoon a ti Jesus a ipakapospos en Maganda a Bareta tungkul ten habag nen Diyos a para ten tolay. ");
INSERT INTO prfNT_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","Nákpággagumák dikomoy mentras a ipangaral ku en tungkul ten Kahariyan. Nadid, tukoy ku a awanák moy dán ketan a ruway. ");
INSERT INTO prfNT_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Kaya kagiyán ku dikomoy nadid a aldew, a bakán ku dán a kasalanan ni tehud a mepalulung dikomoy. ");
INSERT INTO prfNT_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Gapu awanák nagalanganin dikomoy a mángpakapospos tungkul ten layunin nen Diyos. ");
INSERT INTO prfNT_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Kaya ingatan moy en sadili moy sakay en atanan a mánnampalataya a inyentrega nen Banal a Ispiritu dikomoy a bantayan. Alagaan moy ti hustu en simbaan nen Diyos gapu tinubus na hidi ten pamamag-itan nen digi nen sadili na a Anak. ");
INSERT INTO prfNT_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Tukoy ku a ni awanák dán ay magdemáttan en mágkatapang hidi a asu a tayam a mangubus a mangpuksa ten katupaan. ");
INSERT INTO prfNT_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Dumemát en panahun a tehud a mangaral ti kakabuliyan a gubwat labi ten grupu moy tánni makaakit hidi ten mánnampalataya hidi a humiwalay sakay mákkuyug dikodi. ");
INSERT INTO prfNT_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Kaya magingat kam, alalahanán moy en págtatoldu ku dikomoy aldew ay ti gibi ten luub nen tállu a taon a kakagumanák moy, makpal a luwa en pinuhunan ku. ");
INSERT INTO prfNT_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","“Nadid ay ipabahala takamon ten Diyos sakay ten upos na a makapangpatunay ten kabaitan na a awan ti kaparehu. Siya i makapangpatibayid dikomoy sakay makapangatád ten atanan a pagpapala a inlaan na ten atanan a lininisan na ten kasalanan di hidi. ");
INSERT INTO prfNT_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Awanák naghangad ti pilak oni gintu ay ti badu nen deyaman. ");
INSERT INTO prfNT_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Sikam i makatukoyid a nagtarabahuwák tánni tehud kami a kabiyagan ay ten kakagumanan ku hidi. ");
INSERT INTO prfNT_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Ten atanan a pagkakataun ay impeta ku dikomoy a dapat kitam a magtarabahu ti kona haud tánni matulungan tam en mágkahina hidi. Alalahanán tam en kinagi nen Panginoon a ti Jesus a, ‘Pinagpala en mangatád nan en tumanggap.’ ” ");
INSERT INTO prfNT_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Káttapos ni Pablo a nagupos ay lummuhud siya sakay nagdasal a kaguman di. ");
INSERT INTO prfNT_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Sakay namagsangetan hidi a atanan a kummábkáb sakay ummámmu kánni Pablo. ");
INSERT INTO prfNT_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Nalungkut hidi a tarud gapu ten kinagi na a awan di dán siya ketan a ruway kaya intugán di siya hanggan ten barku a sakayan na. ");
INSERT INTO prfNT_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Nadid, káttapos mi a de Pablo a nagpaalam dikodi ay nággabeng kami a patamu ti Cos. Ten kinailawan ay dummemát kami ti Rodas sakay sapul haud ay nagtulos kami ti Patara. ");
INSERT INTO prfNT_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Dinemáttan mi haud en essa a barku a patamu ti Fenicia kaya ummagton kami a summakay haud. ");
INSERT INTO prfNT_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Dinemát mi en tapat ni Cyprus a matan-aw ten danág ti kawiri. Sakay nagtulos-tulos kami a hanggan ti Siria peru pummundu kami ti Tiro gapu nagdiskarga en barku. ");
INSERT INTO prfNT_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Inaryok mi en disepulus hidi haud sakay náktulos kami dikodi ti sasimba. Ten tulung nen Ispiritu ay kinagi di kánni Pablo a dyan siya tumulos ti Jerusalem. ");
INSERT INTO prfNT_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Peru káddemát nen aldew a kállakad mi, ay intugán di kami hanggan ten luwas nen banuwan, kaguman en kákkabinga di ay ten anak di hidi. Dikona dumemát kami ten págpunduwan ten gilid nen diget ay lummuhud kami a atanan sakay nagdasal. ");
INSERT INTO prfNT_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Káttapos mi a nagpaalam dikodi ay summakay kami ten barku sakay ummuli dán bi hidi. ");
INSERT INTO prfNT_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Sapul ti Tiro ay nagtulos kami a nagbiyahi a hanggan dummung kami ti Tolemaida. Nákpagketa kami ten mánnampalataya hidi sakay nágyan kami haud ti saldew. ");
INSERT INTO prfNT_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Ten rumuway a aldew ay nagtulos kami ti Cesarea. Náktulos kami ten bilay ni Felipe a mángngaral ten Maganda a Bareta. Essa siya ten pittu a napili tenhud ti Jerusalem. ");
INSERT INTO prfNT_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Tehud siya áppat a anak a dalaga a puru a propeta. ");
INSERT INTO prfNT_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Dikona a lummipas en sangan a aldew a ked kami haud ay tehud a dummemát a essa a propeta a gubwat ti Judea a Agabo en ngaran na. ");
INSERT INTO prfNT_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Ummadeni siya dikomi sakay inalap na en sinturon ni Pablo. Pinungu na en sadili na a básset ay ten lima na sakay kinagi na, “Iddi en kinagi nen Banal a Ispiritu. Kona haád en gamitán nen Judio hidi ti Jerusalem ten makákkao ti sinturonid a iddi, sakay iyentrega di siya ten Hentil hidi.” ");
INSERT INTO prfNT_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Ten pákkasanig mi ten kinagi na ay impákkekagbi mi sakay nen tolay hidi haud kánni Pablo a dyan dán siya umangay ti Jerusalem. ");
INSERT INTO prfNT_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Peru kinagi ni Pablo, “Nangánya kam? Bakin magsanget kam? Laluwák moy la a palungkután! Nakahandaák bakán la a mapungu ti Jerusalem nan maski matayák alang-alang ten ngaran nen Panginoon a ti Jesus.” ");
INSERT INTO prfNT_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Dikona nabati mi a awan mi siya mapugád ay pinabayan mi dálla siya. Kinagi mi a, “Masunud en kaluuban nen Panginoon.” ");
INSERT INTO prfNT_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Kállipas nen sangan a aldew ay rummektat kami a patamu ti Jerusalem. ");
INSERT INTO prfNT_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Nákkuyug dikomi en sasangan a disepulus a taga-Cesarea. Inyangay di kami ten bilay ni Manason a taga-Cyprus sakay haud kami a náktulos. Ti Manason ay nanalay dán a mánnampalataya. ");
INSERT INTO prfNT_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Nadid, káddemát mi ti Jerusalem ay tinanggap kami ti mahusay nen mánnampalataya hidi haud. ");
INSERT INTO prfNT_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Ten ruway a aldew ay bummisita kami a de Pablo kánni Santiago. Ked bi haud en pinunu hidi nen simbaan ti Jerusalem. ");
INSERT INTO prfNT_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Binati hidi ni Pablo sakay inessa-essa na a imbareta dikodi en atanan a ginamet nen Diyos ten Hentil hidi ten pamamag-itan nen págserbi na. ");
INSERT INTO prfNT_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Dikona nasanig di iyud ay nagpuri hidi ten Diyos. Káttapos ay kinagi di kánni Pablo, “Tukoy mu kapatkaka, tehud dán a sangan a libu a Judio en summampalataya kánni Jesus. Mahigpit bi en págtupad di ten Kautusan. ");
INSERT INTO prfNT_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Nabareta di a tinolduwan mu kan en atanan a Judio a mágyan ten banu-banuwan nen Hentil a dyan di sunudán en Kautusan ni Moises. Kinagi mu kan pa bi a dyan di dán turiyán en anak di sakay dyan di sunudán en kaugaliyan nen Judio hidi. ");
INSERT INTO prfNT_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Ánya nadid dapat tamid a gamitán? Siguradu a mabareta di dán a dummemát ka. ");
INSERT INTO prfNT_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Kaya kona háddi i gamitán muwid. Tehud háddi a áppat a lállaki a tehud a panata. ");
INSERT INTO prfNT_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Ikuyug mu hidi sakay mákpagtupad ka bi ten páglinis ayun ten Kautusan. Bahala ka dán ten atanan nen magastus tánni makapagpapolpok dán hidi. Ti paraanid a iyud ay matukuyan nen atanan a Judio a kakabuliyan en nabareta di tungkul dikomu, nan sumássunud ka ten Kautusan ni Moises. ");
INSERT INTO prfNT_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Tungkul ten Hentil a mánnampalataya ay sinulatan mi hidi a nagkaessaan mi a dyan hidi kuman ti ányaman a makan a neatang ten diyos-diyosan, sakay dyan kuman ti digi sakay hayup a nabitti sakay dyan mangalunya.” ");
INSERT INTO prfNT_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Kaya ruway a aldew ay kinuyug ni Pablo en lállaki hidi ten Templo sakay sabay hidi a nangtupad ten panata di a páglinis. Káttapos ay summáddáp siya ten templo sakay impakapospos na ni hanggan nikan en alay nen págtupad ten panata di a páglinis, tánni makapagalay en balang essa dikodi. ");
INSERT INTO prfNT_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Nadid, dikona adeni dán a matapos en pittu a aldew ay netan nen sangan a Judio a taga-Asia ti Pablo a ked ten Templo. Sinulsulan di en atanan nen tolay a manggulu, sinunggaban di siya sakay tulos a dinikáp. ");
INSERT INTO prfNT_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","Ipáppákraw di a, “Kabanuwan mi hidi, tulungan moy kami! Saiddi en tolay a mágtatolduwán ten atanan a tolay maski ni hádya siya a makademát ti kontra ten Israelita hidi, ten Kautusan ni Moises, sakay kontra ten Templo. Awan na inggalang i Templo tamiday, tehud pa siya a ingkuyug a Hentil a summáddáp, diningáttan na en banal a lugar!” ");
INSERT INTO prfNT_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Kona hud en patama di gapu netan di ti Pablo ten siyudad a kaguman ti Trofimo a taga-Efeso. En akala di ay ingkuyug siya ni Pablo ten Templo. ");
INSERT INTO prfNT_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Nagkagulu ten buu a siyudad gapu ten nasanig di a bareta. Sinunggaban di ti Pablo sakay binerber di a paluwas ten Templo sakay insiradu en pintuwan. ");
INSERT INTO prfNT_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Bunuwán di dán nakuwan ti Pablo peru nabareta nen pinunu nen sundalu hidi a gulu i buu a Jerusalem. ");
INSERT INTO prfNT_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Kaya ingkuyug nen pinunu nen sundalu hidi en upisyal na hidi sakay sundalu na hidi a tamu ten páppágyanan nen kaguluwan. Pákketa nen tolay hidi dikodi ay inyemang di en págbálbág di kánni Pablo. ");
INSERT INTO prfNT_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Inadeniyan nen pinunu nen sundalu hidi ti Pablo sakay dinikáp na. Inyutus na ten sundalu na hidi a punguwán di siya ti duwwa a kadena. Sakay intanung na, “Deya iyád a tolay? Sakay ánya i kasalanan naid?” ");
INSERT INTO prfNT_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Awan parehu en ipáppákraw nen tolay hidi. Gapu ten kaguluwan ay awan maliwanagan nen pinunu nen sundalu hidi ni ánya en tatarudan a pangyayari kaya inyutus na a iyangay ti Pablo ten kampu di. ");
INSERT INTO prfNT_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Káddemát di ten agdenan ay inágkat dálla nen sundalu hidi ti Pablo gapu ummondug en gulu ");
INSERT INTO prfNT_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","nen tolay hidi a umunonud dikodi sakay ipáppákraw di, “Bunuwán siya.” ");
INSERT INTO prfNT_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Dikona isáddáp palla nen sundalu hidi ti Pablo ten kampu di ay nák-oron siya ten pinunu nen sundalu hidi. Kinagi na, “Maari taka a makauron?” Kinagi nen pinunu nen sundalu hidi, “Makabetu ka bali a magupos ti Griego? ");
INSERT INTO prfNT_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Ni konahud ay bakán a siko en taga-Egipto a pinunu nen áppat a libu a armadu a lállaki a náklaban dikomi sakay tinumalon hidi.” ");
INSERT INTO prfNT_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Tummábbig ti Pablo, “Essaák a Judio a taga-Tarso ti Cilicia a tanyag ti iyád a siyudad. Magpermisuwák pay dikomu a pakultadanák mu a magupos ti tolayiday hidi.” ");
INSERT INTO prfNT_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Pinakultadan siya nen pinunu nen sundalu hidi a magupos kaya tummaknág siya ten balitang nen agdenan sakay sininyasan na en tolay hidi a tumahimik. Dikona tahimik dán hidi a atanan ay nagupos dán ti Pablo ti upos ni Hebreo. ");
INSERT INTO prfNT_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","“Kákkapatkaka ku hidi sakay kadáddikállan, sanigán moy i paliwanag kuwiday tánni maintendiyanák moy!” ");
INSERT INTO prfNT_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Dikona masanig di siya a nagupos ti upos ni Hebreo ay lalu hidi a tummahimik sakay nagtulos ti Pablo a nagupos. Kinagi na, ");
INSERT INTO prfNT_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“Sikán ay Judio a neenakák ti Tarso a sakup nen prubinsiya a Cilicia, dummikállák ti Jerusalemiday. En maistu ku ay ti Gamaliel sakay mahigpit en págtoldu na dikoku tungkul ten Kautusan nen ninunu tam hidi. Mahigpit tenhud en págsunud ku ten Diyos a kona dikomoy nadid. ");
INSERT INTO prfNT_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Pinahirapan ku sakay pinabunu en sumunud hidi ti Dilanid a iddi. Pinapungu ku hidi sakay impepiresu, bábbi man oni lállaki. ");
INSERT INTO prfNT_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Mapatunayan iyád nen kapunuwan nen padi hidi ay ten buu a kapisanan nen pinunu hidi nen banuwan. Hidi pa a mismu en nangatád dikoku ti sulat hidi para ten Judio hidi ti Damasco kaya ummangayák haud para dikáppán en miyembru hidi ni Dilanid a iddi sakay iyangay ku hidi ti Jerusalemiday tánni maparusaan.” ");
INSERT INTO prfNT_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","“Ten dikona a tanghali dán sakay adeniyák dán ti Damasco ay bigla a kummislap ten palebut ku en matindi a demlag a gubwat dilanget. ");
INSERT INTO prfNT_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Nerakpaák ten luta sakay nasanig ku en boses a kinagi na dikoku, ‘Saulo, Saulo! Bakin áusigánnák mu?’ ");
INSERT INTO prfNT_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Tummábbigák, ‘Deya ka beman Panginoon?’ Kinagi na, ‘Sikán ti Jesus a taga-Nazaret a áusigán mu.’ ");
INSERT INTO prfNT_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Netan nen kakagumanan ku hidi dikona dummemlag en palebut ku peru awan di nasanig en boses a nákpágguron dikoku. ");
INSERT INTO prfNT_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Sakay intanung ku dikona, ‘Ánya gamitán kuwid nadid Panginoon?’ Kinagi na, ‘Tumaknág ka sakay umangay ka ti Damasco, haud mu a matukuyan en inlaan a dapat mu a gamitán.’ ");
INSERT INTO prfNT_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Gapu ti demlagid a iyud ay naburákkák. Kaya inantabayananák nen kaguman ku hidi a tamu ti Damasco. ");
INSERT INTO prfNT_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","“Tehud haud a essa a lállaki a Ananias en ngaran na. Siya ay maka-diyos a tolay sakay sumássunud ten Kautusan sakay igalang siya nen atanan a Judio. ");
INSERT INTO prfNT_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Ummangay siya ten páppágyanan ku sakay kinagi na dikoku, ‘Kapatkaka a Saulo maketa ka dán a ruway!’ Pagdakaák a naketa a ruway, sakay inileng ku siya. ");
INSERT INTO prfNT_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Sakay kinagi na pa a, ‘Pinili ka nen Diyos nen ninunu tam hidi tánni matukuyan mu en kagustuwan na sakay ketan mu en Banal a Tagapagserbi na sakay masanig en boses na. ");
INSERT INTO prfNT_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Gapu siko en mangpatunay para dikona ten atanan a tolay en tungkul ten netan mu ay ten nasanig mu. ");
INSERT INTO prfNT_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Ánya pa urayán muwid? Tumaknág ka, magpabinyag ka sakay magdasal ka ten ngaran na tánni mapatawad ka ten kasalanan mu hidi.’ ” ");
INSERT INTO prfNT_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","“Nagsoliyák ti Jerusalemiday, dikona kedák ten Templo a pasiyaan a magdasal ay tehudák a netan a pangitain. ");
INSERT INTO prfNT_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Netan ku en Panginoon sakay kinagi na dikoku, ‘Magalistu ka lumakad ka ti Jerusalemiday gapu awan di tanggapán i págpatunay muwen tungkul dikoku.’ ");
INSERT INTO prfNT_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Sakay kinagi ku, ‘Panginoon, talaga a tukoy di en ginággamet ku dikona sinássáddáp ku en sinagoga hidi sakay impáppiresu sakay impabálbág en maniwala hidi dikomu. ");
INSERT INTO prfNT_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Sakay dikona bunuwán di ti Esteban a tagapagpatunay mu ay kedák haud sakay nákpagkaessaák ten ginamet di, sikán pa en nangbantay ten badu nen nangbunu hidi dikona.’ ");
INSERT INTO prfNT_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Peru kinagi nen Panginoon dikoku, ‘Kadmudán ta paangayán taka ten adeyu hidi a lugar, ten Hentil hidi.’ ");
INSERT INTO prfNT_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Nágsanig hidi kánni Pablo, peru ten pángkagi na ti kona haud ay nagpákrawan hidi ti hustu, “Bunuwán siya! Awan siya dapat a mabiyag!” ");
INSERT INTO prfNT_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Tulos-tulos la en pákrawan di, nágsasapwarán hidi ti alikabuk sakay ipágbudas di en alikábkáb di hidi. ");
INSERT INTO prfNT_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Kaya inyutus nen pinunu nen sundalu hidi a isáddáp ti Pablo ten kampu di tánni imbistigaan, sakay haplitán tánni matukuyan ni bakin a kona dálla haud en pákrawan nen Judio hidi kontra dikona. ");
INSERT INTO prfNT_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Peru dikona magapus di dán siya tánni haplitán ay kinagi ni Pablo ten kapitan a mágtaknág ten adeni na, “Ked beman ten batas a basta haplitán en essa a Romano maski ni awan palla siya nahatulan?” ");
INSERT INTO prfNT_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Pákkasanig nen kapitan ay pagdaka a angay náktanung ten kumander, “Ánya dán i maariyid a gamitán nadid ta Romano bali i tolayid a itud?” ");
INSERT INTO prfNT_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Kaya ummangay ten páppágyanan ni Pablo en kumander sakay tinanung na a, “Talaga beman a Romano ka?” Kinagi na, “Romanowák.” ");
INSERT INTO prfNT_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Kinagi nen pinunu nen sundalu hidi, “Dikál a pilak i imbayad kuwid baguwák a nagkahud ti karapatan a kona ten Romano hidi.” Kinagi ni Pablo, “Peru sikán ay sapul ten kákkeenak ku ay Romanowák dán.” ");
INSERT INTO prfNT_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Pagdaka a lummakad en magimbistiga hidi dikona. Nanteng bi en pinunu nen sundalu hidi gapu pinagapus na ti Pablo a essa bali a Romano. ");
INSERT INTO prfNT_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Nadid gapu gustu nen pinunu nen sundalu hidi a matukuyan ni ánya i reklamuwid nen Judio hidi kánni Pablo. Kaya ten kailawan ay dummulaw siya ti miting ten pinunu nen padi hidi sakay ten Sanedrin. Angay na pinaokbis ti Pablo sakay inyatubeng dikodi. ");
INSERT INTO prfNT_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Ummileng ti Pablo ten kapisanan nen pinunu nen Judio hidi sakay kinagi na, “Kákkapatkaka ku hidi, ten atubengán nen Diyos ay nabiyagák a malinis i konsensiya kuwidi hanggan nadid.” ");
INSERT INTO prfNT_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Pákkasanig di ten kinagi ni Pablo ay inyutus ni Ananias a kapunuwan nen padi hidi ten tolay a kadeni ni Pablo a dapangán di siya. ");
INSERT INTO prfNT_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Peru kinagi ni Pablo, “Haplitán ka nen Diyos, siko a magkukunwari! Mággetnud ka la haán tánni maghatul ayun ten Kautusan, peru labag ten Kautusan a padapangák mu.” ");
INSERT INTO prfNT_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Kinagi nen katataknág hidi a kadeni ni Pablo, “Awan ka ti gagalang ten kapunuwan a padi nen Diyos!” ");
INSERT INTO prfNT_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Tummábbig ti Pablo, “Kákkapatkaka ku hidi awanák ti nangmalayan a pinunu bali siya a padi. Gapu nakasulat ngani a, ‘Awan ka dapat a magupos ti bagay a kontra ten pinunu nen banuwan.’ ” ");
INSERT INTO prfNT_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Natukuyan ni Pablo a tehud a grupu ni Saduseo sakay Pariseo ten kapisanan nen mágkataas hidi a Judio kaya kinagi na ti mabegsák, “Kákkapatkaka hidi, Pariseowák sakay anakák bi nen Pariseo hidi. Naimbistigaanák nadid gapu ten pánniwala ku a mabiyag a ruway en patay hidi.” ");
INSERT INTO prfNT_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Dikona a makagi iyud ni Pablo ay namagtalu-talu en Pariseo hidi ay ten Saduseo hidi kaya nagduwwa a bahagi en kapisanan di. ");
INSERT INTO prfNT_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Gapu en pánniwala nen Saduseo hidi ay awan mabiyag a ruway en patay sakay awan ti anghel oni ispiritu. Peru en Pariseo hidi ay maniwala ti atananid a iyád. ");
INSERT INTO prfNT_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Nadid inumondug en pákrawan di. Tummaknág en sangan a tagapagtoldu nen Kautusan a kabilang ten grupu nen Pariseo hidi a impilit di a, “Awan kami ti ketan a kasalanan ni tolayid a iddi. Bakay tehud a ispiritu oni anghel a nákpágguron dikona!” ");
INSERT INTO prfNT_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Dikona nagin mahigpit dán en pamágtalu-talu di ay nanteng en pinunu nen sundalu hidi bakay bálbággán nen tolay hidi ti Pablo. Kaya pinaugsad na en sundalu hidi sakay inyutus na a alapán di ti Pablo sakay isáddáp ten kampu di. ");
INSERT INTO prfNT_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Ti gibiyid a iyud ay pummeta en Panginoon kánni Pablo sakay kinagi na a, “Dyan ka manteng! Nagpatunay ka tungkul dikoku ti Jerusalemiday, kona bi hud en gamitán mu ti Roma.” ");
INSERT INTO prfNT_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Ten kadimadimangan ay tehud a sangan a Judio a nagkasundu a bunuwán di ti Pablo. Nagpanata en balang essa dikodi a awan hidi kuman oni uminom hanggan awan di mabunu ti Pablo. ");
INSERT INTO prfNT_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Mahigit a áppat a pulu a lállaki en nagpanata ti kona haud. ");
INSERT INTO prfNT_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Sakay ummangay hidi ten pinunu nen padi hidi ay ten pinunu hidi nen banuwan, a kinagi di, “Nagpanata kami ti mahigpit a awan kami kuman sakay awan kami uminom hanggan awan mi mabunu ti Pablo. ");
INSERT INTO prfNT_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Kaya nadid, sikam ay ten kapisanan nen mágkataas hidi a Judio ay kagiyán moy ten pinunu nen sundalu hidi a paugsadán di a ruway ti Pablo, kagiyán moy la a imbistigaan moy pa siya ti hustu. Sakay ten dilan palla ay bunuwán mi dán siya.” ");
INSERT INTO prfNT_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Peru nasanig iyud nen pamangkin ni Pablo a lállaki a anak nen kapatkaka na a bábbi. Kaya ummangay siya ten kampu nen sundalu hidi sakay kinagi na kánni Pablo iyud a balak di. ");
INSERT INTO prfNT_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Dinulaw ni Pablo en kapitan sakay kinagi na, “Aguman mu pay i binatilyuwiday ten pinunu nen sundalu hidi ta tehud siya a kagiyán.” ");
INSERT INTO prfNT_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Inaguman siya nen kapitan ten pinunu nen sundalu hidi sakay kinagi na, “Dinulawanák nen piresu a ti Pablo, pinaagum na i binatilyuwiday gapu tehud kan siya a kagiyán dikomu.” ");
INSERT INTO prfNT_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Tinawidan nen pinunu nen sundalu hidi en lima nen binatilyu sakay inyadeyu na a tinanung, “Ánya beman i kagiyán muwid dikoku?” ");
INSERT INTO prfNT_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Tummábbig siya, “Nagkaessaan nen Judio hidi a agidán di dikomu ti Pablo a iyatubeng ni ilaw ten Sanedrin a wari-wari di pa a imbistigaan ti hustu. ");
INSERT INTO prfNT_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Dyan ka nakuwan maniwala gapu mahigit a áppat a pulu a lállaki en mangabang dikona tánni bunuwán di siya. Nagpanata pa hidi a awan hidi kuman oni uminom hanggan awan di mabunu ti Pablo. Nadid ay handa dán hidi, urayán di dálla ni pumayag ka.” ");
INSERT INTO prfNT_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Nadid, pinauli nen pinunu nen sundalu hidi en binatilyu sakay binilin na a, “Dyan mu kagi-kagiyán maski kándeya a nagpilet ka dikoku.” ");
INSERT INTO prfNT_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Nadid, nangdulaw en pinunu nen sundalu hidi ti duwwa ten kapitan na hidi sakay kinagi na a, “Mánghanda kam ti duwadatos a sundalu sakay pittu a pulu a tehud a kabayu sakay duwadatos bi a sundalu a tehud a pika. Tánni angay kam ti Cesarea nadid a alas nuwebi ti gibi. ");
INSERT INTO prfNT_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Maghanda kam bi ti kabayu hidi a págsakayan ni Pablo sakay iyangay moy siya kánni gubernador Felix, bantayan moy siya ti hustu!” ");
INSERT INTO prfNT_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Sakay nagsulat en kumander kánni gubernador Felix ti kona háddi, ");
INSERT INTO prfNT_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“Sikán ti Claudio Lisias a nagsulat dikomu a kagalang-galang a Gubernador Felix. Kumusta ka la? ");
INSERT INTO prfNT_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Iyán a lállaki ay dinikáp nen Judio hidi sakay bunuwán di dán nakuwan. Nadid natukuyan ku a Romano bali siya kaya ginamet kuwid ay inligtas ku siya sakay pinaagum ku ten sundalu ku hidi. ");
INSERT INTO prfNT_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Gapu ten sor ku a mapospusan ni bakin ingkasu di siya ay impeatubeng ku ten kapisanan nen mágkataas hidi a Judio. ");
INSERT INTO prfNT_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Natukuyan ku a tungkul ten Kautusan di i nángkasuwan diyid dikona, peru awan palla iyud sapat a pangbunuwan oni pángpiresuwan dikona. ");
INSERT INTO prfNT_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Natukuyan ku bi a gayakán siya a bunuwán nen Judio hidi kaya pagdaka ku siya a impeangay dikomu. Sakay kinagi ku ten tolay hidi a angay dálla hidi magreklamu dikomu kontra dikona. Hanggan dálla hud.” ");
INSERT INTO prfNT_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Sakay summunud en sundalu hidi ten utus dikodi. Kággibi na ay inangay di ti Pablo sakay inyangay di ti Antipatris. ");
INSERT INTO prfNT_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Ten kadimadimangan na ay nagsoli en sundalu hidi ten kampu di peru en mágkabayu hidi ay nagtulos ten páglakbay di tánni bantayan ti Pablo. ");
INSERT INTO prfNT_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Káddemát di ti Cesarea ay inyentrega di ti Pablo ten gubernador sakay inyatád di en sulat. ");
INSERT INTO prfNT_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Pákkabasa nen gubernador ten sulat ay tinanung na ti Pablo ni taga hádya siya. Dikona matukuyan na a taga-Cilicia, ");
INSERT INTO prfNT_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","ay kinagi na, “Sanigán ku en katuwiran mu káddemát nen nángkasu hidi dikomu.” Sakay inyutus na a bantayan ti Pablo ten palasyu ni Herodes. ");
INSERT INTO prfNT_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Kállipas nen limma a aldew ay dummemát ti Cesarea ti Ananias a kapunuwan nen padi hidi. Tehud siya a kaguman a sangan a pinunu nen banuwan sakay essa a abugadu a ti Tertulo en ngaran na. Ummatubeng hidi ten gubernador sakay kinagi di en reklamu di kontra kánni Pablo. ");
INSERT INTO prfNT_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Inyatubeng di ti Pablo sakay sinapulan dán ni Tertulo a isaysay en reklamu na. Kinagi na, “Kagalang-galang a Gubernador Felix, essa a mahusay a pinunu gapu ti alay dán a panahun ay napanatili mu a tahimik sakay makpal dán a pagbabagu a kapiyyaan i bansa miyiday gapu dikomu. ");
INSERT INTO prfNT_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Gapu ti hidi iyád ay magpasalamat kami ti dikál dikomu maski ni hádya sakay awan ti katapusan. ");
INSERT INTO prfNT_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Awan ku gustu a maabala ka, kaya ipákpágguron ku a kagbiyan mu a sanigán i kagiyán miyiday awan la malay. ");
INSERT INTO prfNT_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Gapu i tolayid a iyán ay manggugolu. Gágguluwán na atanan Judio maski hádya a lugar ni munduwiday sakay essa siya ten pinunu hidi nen Nazareno a grupu. ");
INSERT INTO prfNT_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Maski en Templo mi ay laan na a paggamitan ti madukás kaya dinikáp mi siya. Laan mi dán siya a hatulan ayun ten kautusan mi, ");
INSERT INTO prfNT_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","peru dummemát en pinunu nen sundalu hidi a ti Lisias sakay pinuwersa di a inalap dikomi i tolayid a iyán. ");
INSERT INTO prfNT_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Sakay inyutus na dikomi a en tehud a reklamu ay angay dálla dikomu magreklamu. Ni imbistigaan mu siya ay matukuyan mu en atanan nen reklamu mi kontra dikona.” ");
INSERT INTO prfNT_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Inayunan bi nen Judio hidi a ked haud en atanan a kinákkagi ni Tertulo. ");
INSERT INTO prfNT_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Sininyasan nen Gubernador ti Pablo a magupos kaya kinagi na, “Kagalang-galang a Gubernador, tukoy ku a nalay ka dán a panahun a huwes ni bansaid a iddi kaya masayaák a mangatuwiran ti atubengán muwidi. ");
INSERT INTO prfNT_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Awanák palla ti sapulu ay ti duwwa a aldew a ked ti Jerusalem tánni sumamba ten Diyos. Mapatunayan mu iyád Gubernador ten pággimbistiga mu. ");
INSERT INTO prfNT_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Awanák palla netan nen Judio hidi a nákpagdibati maski kándeya a tolay oni netan a sinulsulan a nanggulu ten Templo, maski ten sinagoga, oni hádya a lugar nen siyudad. ");
INSERT INTO prfNT_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Awan hidi ti katibayan ti ibábbintang diyen dikoku. ");
INSERT INTO prfNT_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Aminán ku a tatarudan a sumampalatayaák ten Diyos nen ninunu mi hidi ayun ti Dilanen a kákkagiyán di a liwat a pánnampalataya. Peru paniwalaan ku en atanan a nakasulat ten Kautusan sakay ten libru nen propeta hidi. ");
INSERT INTO prfNT_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Kona dikodi, ay manampalatayaák bi a biyagán a ruway nen Diyos en atanan a tolay, matuwid oni awan matuwid. ");
INSERT INTO prfNT_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Kaya pilitán ku a magin malinis i konsensiya kuwiday ten atubengán nen Diyos ay ten tolay hidi. ");
INSERT INTO prfNT_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","“Sangan dán a taon a awanák ti Jerusalem peru nagsoliyák tánni mángtugánnák ti tulung para ten kabanuwan ku hidi sakay magalay ten Diyos. ");
INSERT INTO prfNT_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Mentras a gamitán ku en atanan a bagay para ten páglinis ayun ten Kautusan, ay netanák di ten Templo, sasangan la en tolay sakay awan ti gulu. ");
INSERT INTO prfNT_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Peru tehud a sasangan a Judio a ked haud a gubwat ti Asia, hidi nakuwan i ummangayid háddi dikomu a magreklamu kontra dikoku. ");
INSERT INTO prfNT_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Oni tanungán mu i tolayiday hidi a ked háddi ni tehud hidi a napatunayan a kasalanan ku imbistigaanák di ten Sanedrin. ");
INSERT INTO prfNT_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","En maari la a ibintang di dikoku ay dikona ummatubengák dikodi sakay impákraw ku a, ‘Gapu ten pag-asa ku a mabiyag a ruway en tolay a natay dán kaya kedák háddi a imbistigaan.’ ");
INSERT INTO prfNT_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Gapu dikál dán en tukoy ni Gubernador Felix ten tungkul ten Dilan, kaya inyemang na en págbista, kinagi na, “Hatulan ku i kasu muwen káddemát ni Lisias.” ");
INSERT INTO prfNT_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Káttapos ay inyutus na ten kapitan a bantayan ti Pablo, peru dyan hidi maghigpit dikona nan pabayan di a bisitaán siya sakay tulungan nen amigu na hidi. ");
INSERT INTO prfNT_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Nadid, kállipas nen sangan a aldew ay dummemát ti Felix, kaguman na en kabinga na a ti Drusila a essa a Judio. Pinadulaw na ti Pablo sakay nágsanig tungkul ten pánnampalataya kánni Cristo-Jesus. ");
INSERT INTO prfNT_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Peru dikona a magpaliwanag dán ti Pablo tungkul ten pagkamatuwid, págpugád ti sadili, sakay ten dumemát a pághatul nen Diyos, ay minanteng ti Felix. Kinagi na, “Maari ka dán a lumakad, padulaw taka la a ruway.” ");
INSERT INTO prfNT_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Pirmi na a padulaw sakay kaurunán ti Pablo gapu akala naid ay suhulan siya ni Pablo. ");
INSERT INTO prfNT_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Kállipas nen duwataon ay pinalitan ni Porcio Festo ti Felix. Gapu ten sor ni Felix a mapasaya en Judio hidi ay pinabayan na ti Pablo a pumáppiresu. ");
INSERT INTO prfNT_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Dummemát ti Festo ten prubinsiya a pamahalaan na, sakay káttapos nen katállu a aldew ay ummangay siya ti Jerusalem gubwat ti Cesarea. ");
INSERT INTO prfNT_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","En pinunu hidi nen padi hidi sakay en pinunu hidi nen Judio hidi ay angen di inyatubeng en reklamu di kontra kánni Pablo. Nákkekagbi hidi kánni Festo ");
INSERT INTO prfNT_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","a ni maari la ay paangayán na ti Pablo ti Jerusalem gapu gustu di siya a harangán ten dilan sakay bunuwán. ");
INSERT INTO prfNT_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Tummábbig ti Festo, “Gapu ti Pablo ay piresu ti Cesarea, ay angayák haud a pagdaka. ");
INSERT INTO prfNT_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Pákkuyugán moy dikoku en pinunu moy hidi, ni tehud a nagamet a madukás i lállakiyid a iyud ay haud di siya a ikasu.” ");
INSERT INTO prfNT_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Nagpalipas pa ti Festo ti walu hanggan sapulu a aldew ti Jerusalem sakay nagsoli ti Cesarea. Ten kailawan ay ummangay siya ten págbistaan sakay inyutus na a iyangay dikona ti Pablo. ");
INSERT INTO prfNT_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Kássáddáp ni Pablo ay kinalibungbungan siya nen Judio hidi a gubwat ti Jerusalem sakay sinapulan di dán a kinákkagi en bintang di hidi a mágkadukás dikona, peru atananid a iyud ay awan hidi ti napatunayan. ");
INSERT INTO prfNT_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Peru nangatuwiran ti Pablo a kinagi na, “Awanák ti nagamet a páglabag ten Kautusan nen Judio hidi oni ten Templo oni ten Emperador.” ");
INSERT INTO prfNT_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Gustu a paboran ni Festo en Judio hidi kaya tinanung na ti Pablo, “Gustu mu beman a angay ti Jerusalem tánni haud taka a bistaán?” ");
INSERT INTO prfNT_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Kinagi ni Pablo, “Kedák dán háddi a mágtaknág ten atubengán nen pághatulan nen Emperador, dapatid ay háddák dán háddi a maimbistigaan. Awanák ti ginamet a kasalanan ti Judiowen hidi, tukoy moy iyán. ");
INSERT INTO prfNT_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Ni linabag ku en batas oni nakagamiták ti ányaman a madukás a pangbunuwan dikoku ay awan ku adiyan. Peru ni awan di mapatunayan i ibábbintang diyen ay awanák dapat a meatád dikodi. Angayák umatubeng ten Emperador.” ");
INSERT INTO prfNT_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Nadid, inuron ni Festo en tagapayu na hidi, káttapos ay kinagi na, “Sigi gapu kinagi mu a iyatubeng ka ten Emperador ay peangay taka ten Emperador.” ");
INSERT INTO prfNT_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Kállipas nen sangan a aldew ti Cesarea ay dummemát de Hari a Agripa ay ti Bernice ta angay di batiyán en bigu a Gubernador a ti Festo. ");
INSERT INTO prfNT_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Sumangan a aldew ay kinagi ni Festo ten hari en tungkul kánni Pablo, “Tehud háddi a essa a lállaki a piresu a inwarak ni Felix. ");
INSERT INTO prfNT_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Dikona kedák ti Jerusalem ay inreklamu siya dikoku nen pinunu hidi nen padi hidi ay ten pinunu hidi nen Judio hidi, sakay agidán di a maparusaan siya. ");
INSERT INTO prfNT_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Peru kinagi ku dikodi a awan tam ugali a Romano hidi a maghatul ti parusa ten essa a nereklamu ni awan na palla nakatubeng en nangakusa hidi dikona sakay ni awan na palla nepaliwanag en tábbig na ten reklamu dikona. ");
INSERT INTO prfNT_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Kaya dikona dummemát hidi háddi ay awanák dán nagabala, ten kailawan labi ay pinadulaw ku dán siya ten págbistaan. ");
INSERT INTO prfNT_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Peru dikona a tinumaknág en nángreklamu hidi dikona ay awan di siya binintang ti madággi a kasalanan a kona ten akala ku a kagiyán di. ");
INSERT INTO prfNT_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Nan en pamagtalunan di ay tungkul ten sadili di a rilihiyon sakay ten essa a tolay a patay dán a Jesus en ngaran na, peru ipilit ni Pablo a biyag siya. ");
INSERT INTO prfNT_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Awan ku tukoy ni ánya gamitán kuwid tungkul ti bagayid a iyád kaya tinanung ku ti Pablo ni gustu na a angay ti Jerusalem ta haud dálla siya a bistaán. ");
INSERT INTO prfNT_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Peru tinumanggi siya sakay inagid na a ipasa ten Emperador en disisyon ten kasu na. Kaya pinabantayan ku siya tánni iyangay ten Emperador. ");
INSERT INTO prfNT_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Kinagi ni Agripa kánni Festo, “Gustu ku a masanig en katuwiran ni tolayid a iyán.” Kinagi ni Festo, “Masanig mu siya ni ilaw.” ");
INSERT INTO prfNT_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Kinailawan ay dummemát de Agripa ay ti Bernice a tehud a dikál a parangal, kaguman en mágkataas hidi a pinunu