﻿USE sofia;
DROP TABLE IF EXISTS sofia.pps_vpl;
CREATE TABLE pps_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES pps_vpl WRITE;
INSERT INTO pps_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Jiꞌi sen kuachrjenixin ndo Jesucristo. Jeꞌe ndo kuachrjenixin ndo, ndo David ko ndo Abraham. ");
INSERT INTO pps_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Ndo Abraham ikjui ndotée ndo Isaac ko ndo Isaac ikjui ndotée ndo Jacob ko jeꞌe ndo ikjui ndotée ndo Judá ko sen kichuu ndo. ");
INSERT INTO pps_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Ko ndo Judá ikjui ndotée ndo Fares ko ndo Zara ko janée sen ikjui jan Tamar. Ndo Fares ikjui ndotée ndo Esrom ko jeꞌe ndo Esrom ndotée ndo Aram. ");
INSERT INTO pps_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ndo Aram ikjui ndotée ndo Aminadab ko jeꞌe ndo ndotée ndo Naasón ko ndo Naasón ikjui ndotée ndo Salmón. ");
INSERT INTO pps_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Ndo Salmón ikjui ndo ndotée ndo Booz ko janée ndo jan Rahab. Ndo Booz ikjui ndotée ndo Obed ko janée ndo Obed jan Rut. Ndo Obed ikjui ndo ndotée ndo Isaí. ");
INSERT INTO pps_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Ko ndo Rey David, chjenꞌen ndo Isaí, ko jan Betsabé, jan ikjui janchriꞌe ndo Urías, ko ndo Rey David, meꞌe sen ikjui ndotée ko janée ndo Salomón. ");
INSERT INTO pps_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Ko ndo Salomón ikjui ndotée ndo Roboam ko jeꞌe ndo ndotée ndo Abías ko jeꞌe ndo Abías ikjui ndotée ndo Asa. ");
INSERT INTO pps_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Ndo Asa ikjui ndotée ndo Josafat ko ndo Josafat ikjui ndotée ndo Joram ko ndo Joram ikjui ndotée ndo Uzías. ");
INSERT INTO pps_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Ko ndo Uzías ikjui ndotée ndo Jotam ko ndo Jotam ikjui ndotée ndo Acaz ko ndo Acaz ndotée ndo Ezequías. ");
INSERT INTO pps_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ndo Ezequías ikjui ndotée ndo Manasés ko ndo Manasés ikjui ndotée ndo Amón ko ndo Amón ikjui ndotée ndo Josías. ");
INSERT INTO pps_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Ko ndo Josías ikjui ndotée ndo Jeconías ko kain xjan kichuu ndo. Sen bakeꞌe nchakon sabikao na̱ sen israelita tjajna Babilonia, bikao na̱ sen xranchi sen itji ndoꞌachjiso ko ntiꞌa juinchencheꞌe na̱ sen ixra̱ ko juengeꞌa na̱ sen ꞌna̱. ");
INSERT INTO pps_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Juexinja ti bijeꞌe na̱ sen ntiꞌa tjajna meꞌe, tjumeꞌe ndo Jeconías ikjui ndotée ndo Salatiel ko ndo Salatiel ikjui ndotée ndo Zorobabel. ");
INSERT INTO pps_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Ko ndo Zorobabel ikjui ndotée ndo Abiud ko ndo Abiud ikjui ndotée ndo Eliaquim ko ndo Eliaquim ikjui ndotée ndo Azor. ");
INSERT INTO pps_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Ko ndo Azor ikjui ndotée ndo Sadoc ko ndo Sadoc ikjui ndotée ndo Aquim ko ndo Aquim ikjui ndotée ndo Eliud. ");
INSERT INTO pps_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Ko ndo Eliud ikjui ndotée ndo Eleazar ko ndo Eleazar ikjui ndotée ndo Matán ko ndo Matán ikjui ndotée ndo Jacob. ");
INSERT INTO pps_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Ko ndo Jacob ndotée ndo José ko ndo José ndoxiꞌe jan María ko jeꞌe jan María janée ndo Jesús, ndo Jesús, ndo nchekinꞌin sen Cristo. ");
INSERT INTO pps_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Itenoó sen xranchrjen kuachrjenixin ndo Abraham ko tjumeꞌe konoxin ndo David ko kaxon itenoó sen kuachrjenixin ndo David, ko tjumeꞌe ni tjajna Babilonia sabikao na̱ sen israelita tjajnée na̱ ko tjumeꞌe íjngo itenoó sen jongíꞌe, tjumeꞌe jongíꞌe ndo Cristo. ");
INSERT INTO pps_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","*Jaꞌin jongíꞌe ndo Jesucristo: Jan María, jan xrokjui janée ndo Jesús, ó tsijanchia ndo José jan. Ko xratintekaoꞌa kichuu sen, ó jiyá jan ichjan ixi juachaxien Espíritue ndo Dio. ");
INSERT INTO pps_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Ndo José, ndo tsoña̱ ndoxiꞌe jan María, jeꞌe ndo naa xi tsango jian, méxin, imao tjaun ndo xrokuintuꞌe ndo jan ixi tjaunꞌa ndo xrokonoꞌe chujni. ");
INSERT INTO pps_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Ko ó tsixraxaon ndo jaña, nchakon naa ndo ángel neꞌe Ncháina tsikonoxinꞌen ndo ngaya kotáchrién ndo ko jaꞌin nichja ndo ángel: ―José, jaꞌa ti kuachrjenixian ndo David, xrakonꞌa ixi tsayeꞌé jan María xranchi janchriꞌa ixi ichjan xrochónda jan, xjan meꞌe ixi juachaxien Espíritue ndo Dio tsjongíexin xjan. ");
INSERT INTO pps_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","*Ko jan María sinchejongíꞌe jan naa xjan xi ko sinchekiꞌian xjan Jesús; jaña tsinꞌin xjan ixi jeꞌe xjan tsantsje xjan ijie̱ chónda chujni. ");
INSERT INTO pps_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Kain jiꞌi konꞌen ixi jaña tsichronga ndo Dio ngajin sen kuanichja chijnie Ndo ó saꞌó. Jaꞌin tsindachro ndo: ");
INSERT INTO pps_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Naa nchrichajan tseyá nchrichan ichjan, ko xrochónda nchrichan naa ichjan, ko jeꞌe xjan ndatsinꞌin xjan Emanuel. Jiꞌi xrondachro: ndo Dio stekuꞌuna ndo. ");
INSERT INTO pps_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Hora xingameꞌe ndo José kuitikaon ndo ngeꞌe ti ndachro ndo ángel neꞌe Ncháina Dio ko kuayéꞌe ndo jan María xranchi janchriꞌe ndo. ");
INSERT INTO pps_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","*Xra kuintejuakaoꞌa kichuu sen, jeꞌe jan juinchejongíꞌe jan naa ichjan ko ndo José juinchekinꞌin ndo xjan Jesús. ");
INSERT INTO pps_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Tjajna Belén tikinixinꞌen Judea, ntiꞌa jongíexin ndo Jesús. Nchakon meꞌe bakeꞌe naa xi rey bakinꞌin Herodes, xi meꞌe bakituanꞌan ntiꞌa. Nchakon meꞌe kui̱i̱ kaxin sen tsango noꞌe nchekuanxin nchanotsé. Sen meꞌe kui̱xi̱n sen ndatsjonxin chjuya. ");
INSERT INTO pps_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Ko juanchangi sen: ―¿Ti no jii xjan tsijongíꞌe xjan rey tsetuenꞌen ni judío? Ixi bikona nchanotsée xjan ndatsjonxin chjuya, ko juiꞌina ixi tsajonna juasaya ngajin xjan. ");
INSERT INTO pps_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Ko xi rey Herodes kuinꞌen xa meꞌe, juincheꞌa xa juaxruxin ko kaxon kain ni tjajna Jerusalén. ");
INSERT INTO pps_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Tjumeꞌe xi rey Herodes kuiyeꞌe xa sen taana ícha tetuanꞌan ko kain ni tjako ley, ko juanchangiꞌe xa na̱ ixi no xrojongíexin ndo Cristo. ");
INSERT INTO pps_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Jeꞌe na̱ juatingíexin na̱: ―Jeꞌe xjan tsjongíexin xjan tjajna Belén tikinixinꞌen Judea, jaña tsikjin sen kuanichjaxin chijnie ndo Dio ó saꞌó: ");
INSERT INTO pps_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Jaꞌa tjajna Belén nunteꞌe Judá, á jeꞌa jaꞌa naa tjajna ícha nchíín ngakjenꞌen ikaxin tjajna ícha ijié, ko ntiꞌi tsachrjexin naa ngisen ícha tsetuanꞌan, ko jeꞌe ndo tsayakonꞌen ndo tjajnána Israel. ");
INSERT INTO pps_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Tjumeꞌe xi Herodes imao kuiyeꞌe xa sen nchekuanxin nchanotsé ko juanchangi xa ngisa konoxin nchanotsé. ");
INSERT INTO pps_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Ko tjumeꞌe ndachro xa: ―Itjinta Belén, ntiꞌa tjanchangínta ixi ichjan meꞌe, ko ti no tsinchíinta xjan, nchenónanta ixi janꞌan kaxon itsji ngajin xjan tsajon juasaya. ");
INSERT INTO pps_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Ko sen nchekuanxin nchanotsé kuinꞌen sen ngeꞌe ichro xi rey ko sakuintekji sen ko nchanotsé bikon sen meꞌe kuitaoꞌen sen ntiꞌa ko tjumeꞌe kuíxin nchanotsé ngataꞌa ti no jii jeꞌe xjan. ");
INSERT INTO pps_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Ko sen nchekuanxin nchanotsé tsango chéꞌe sen ixi bikon sen no bakeꞌe nchanotsé. ");
INSERT INTO pps_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Ko hora kuixinꞌin sen nchia ko bikon sen xjan jikao xjan jan María, janée xjan, bakeꞌexin ntatuchiꞌin sen, kuajon sen juasaya ngajin xjan ko kuantjeꞌe sen nta̱baúl tsikikaꞌo sen ko kuajon sen chika oro ko tsjo xraxe ko xro̱a̱n mirra. ");
INSERT INTO pps_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Ko tjumeꞌe koxienxin sen ixi íxrokjanꞌi sen ti jii xi Rey Herodes. Méxin, kua sen inaa chaꞌo, sakjui sen tjajnée sen. ");
INSERT INTO pps_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Ko nchakon sakuintekji sen nchekuanxin nchanotsé, tjumeꞌe naa ndo ángel neꞌe Ncháina konoxin ngaya kotáchrién ndo José ko ndachro ndo ángel: ―Tingatjen, satikoꞌa ichjan ko janée xjan, satjinta tjajna Egipto. Ko ntiꞌa tinteenta ti xrondachrja̱njan janꞌan, ixi xi Herodes tjaun xa tsenꞌen xjan. ");
INSERT INTO pps_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Tjumeꞌe ndo José kuaya ndo ko sabikao ndo ichjan ko janée xjan, tiie meꞌe kua sen chaꞌo sakjui sen tjajna Egipto. ");
INSERT INTO pps_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Ntiꞌa bakeꞌe sen, kuenjan xi Herodes. Jaña konꞌen ixi jaña tsichronga sen kuanichjaxin ndo Dio: “Tjajna Egipto bakeꞌe chjanꞌna ko janꞌan kuiyaꞌa xjan.” ");
INSERT INTO pps_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Hora konoꞌe xi rey Herodes ixi sen nchekuanxin nchanotsé íkjanꞌi sen xranchi kuetuenꞌen xa sen, meꞌe xi Herodes tsango koñao xa ko kuetuanꞌan xa ixi tsenꞌen kain xjan xi, xjan xrachóndaꞌi yuu nano ste tjajna Belén ko xjan ste ngandeꞌe tjajna kaxon. Jaña kuetuanꞌan xa ixi jixraxaon xa ngeꞌe ndachro sen nchekuanxin nchanotsé. ");
INSERT INTO pps_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Jaꞌin konꞌen ixi ti tsikjin ndo Jeremías, ndo kuanichja chijnie Dio, nchakon tsindachro ndo: ");
INSERT INTO pps_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Jaꞌin kuinꞌen chujni tée naa sen nichjaxin tjajna Ramá, tsango kuyako sen ko tsango tsjanga sen. Meꞌe nchri Raquel jitsjangaxin chjenꞌen nchra. Ko tjaunꞌa nchra ixi xrojan ngisen sinchecháxin nchra ixi ó tsikintekenꞌen chjenꞌen nchra. Jaña jitaxin xroon. ");
INSERT INTO pps_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Ntiꞌa kuintee sen tjajna Egipto kuenjan xi Herodes ko naa ndo ángel neꞌe Ncháina konoxin ndo ngajin ndo José ngaya kotáchrién ndo ko jaꞌin ndachro ndo: ");
INSERT INTO pps_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","―Tingatjen ko satikoꞌa ichjan ko janée xjan, ikjannta tjajna Israel ixi ó ndakuenꞌen ni tjaun xrokóña xjan. ");
INSERT INTO pps_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Ko tjumeꞌe ndo José kuaya ndo ko sabikao ndo xjan ko janée xjan tjajna Israel. ");
INSERT INTO pps_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Ko konoꞌe ndo José ixi xi Arquelao, chjenꞌen xi Herodes, tetuanꞌan xa nunte Judea, ti baketuanꞌan ndotée xa, xronka ndo José ixi xrokjui ndo ntiꞌa. Ko ixi tsichronga ndo Dio ixi kotachrin, méxin sakjui sen nunte tikinixinꞌen Galilea. ");
INSERT INTO pps_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","*Ko tjajna ndatinꞌin Nazaret, ntiꞌa kuintee sen. Jaña konꞌen ixi jaña tsichronga sen kuanichjaxin ndo Dio ó saꞌó ko tsindachro sen ixi ndo Jesús xrojuinchekinꞌin na̱ ndo nazareno. ");
INSERT INTO pps_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Nchakon meꞌe ndo Juan Bautista kuiji ndo ti jii ijna̱ nchese nunte Judea, ntiꞌa nichja ndo chijnie ndo Dio ");
INSERT INTO pps_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","*ko jaꞌin nichja ndo: ―Ikjan titikaonnta ndo Dio ixi ó tuinxin tsonoxin juachaxien ndo. ");
INSERT INTO pps_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Ndo Juan, meꞌe ndo tsindachro ndo Isaías: Tée naa sen tuyako ti jii ijna̱: “Nchekonchjiannta chaꞌo tsi̱ꞌxi̱n Ncháina ko nchenataoxinnta chaꞌo.” ");
INSERT INTO pps_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Ko manta jitsáa ndo Juan Bautista tsikonchjianxin chjuen kucamello ko naa tju̱a̱ jingatoxin ndo. Ko ti bajine ndo jeoxón kuxruꞌa ko tsjeen kunoa, kuntajie. ");
INSERT INTO pps_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Ko bakiji chujni Jerusalén ko ni Judea ko kueya chujni tjajna ste ngandeꞌe inda Jordán ko bakiꞌen na̱ ti kuandachro ndo. ");
INSERT INTO pps_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Ko kuachronga na̱ ti ndakoꞌa juincheꞌe na̱ ngajin ndo Dio ko tjumeꞌe ndo Juan bikitée ndo na̱ ti jii ndajitinga ndatinꞌin Jordán. ");
INSERT INTO pps_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","*Ko bikon ndo Juan ixi kueya xi fariseo ko xi saduceo kuiji xa ixi tjaun na̱ tsikitée xa kaxon, méxin, ndachro ndo: ―Jaꞌanta tsikachrjenixinnta kunchee, ¿ngisen ntatjunta satsingeꞌenta juañaue ndo Dio ti ó tuinxin tsi̱i̱? ");
INSERT INTO pps_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Xrokonda ixi nduaxin tsjakonta ixi ó ti jian rincheꞌenta ko titikaonnta Ncháina. ");
INSERT INTO pps_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","*Ko xrondachroꞌanta ixi kuachrjenixinnta ndo Abraham ko jaña sinchejiénta asáanta ixi janꞌan ntatjunta ixi ixro jiꞌi chao ndo Dio sinchéña ndo chujni tsachrjenixin ndo Abraham. ");
INSERT INTO pps_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","*Ko jacha ó jichónꞌen jacha xrochrijinxin nueꞌe nta̱yua ixi kain nta̱a̱ tajonꞌa itu jian xrokonda xrochrijin nta̱a̱ ko xroche nta̱a̱. ");
INSERT INTO pps_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Ko nduaxin tjakonta ixi juincheniꞌanta ti ndakoꞌa juincheꞌenta ko janꞌan inda bikitéexinta. Ko ícha tjumeꞌe tsi̱i̱ inaa ndo ícha tetuanꞌan, ko janꞌan tikinixinnaꞌi tsikiꞌan katée ndo, ko jeꞌe ndo tsikitéxinnta ndo Espíritue ndo Dio ko xroꞌi. ");
INSERT INTO pps_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Ko jeꞌe ndo ó jitikaꞌo ndo kachrintue ndo tsjenduaxin ndo noatrigo ko tsinchexin ndo no ti xineno ko tsakeꞌe ndo noa ti jii ntaneꞌto ko xineno tsjaaka ndo xineno, ko xroꞌi meꞌe naiꞌa tsanga xroꞌi. ");
INSERT INTO pps_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Ndo Jesús kui̱xi̱n ndo nunte Galilea ko kuiji ndo ti jii ndajitinga ndatinꞌin Jordán ti jii ndo Juan Bautista ixi tsikitée ndo Jesús. ");
INSERT INTO pps_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Ko ndo Juan tjaunꞌa ndo tsikitée ndo ndo Jesús ko jaꞌin ndachro ndo: ―Xrokonda jaꞌanta tsikiténinta janꞌan, ko jaꞌanta tjiꞌinta ngajin ixi janꞌan tsikitéenta. ");
INSERT INTO pps_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Ko ndo Jesús juatingíexin ndo: ―Jaña xrokonda sincheꞌena jai, ixi jaña tsitikaonna kain ti kuetuanꞌan ndo Dio. Meꞌe ndo Juan kuitikaon ndo. ");
INSERT INTO pps_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Ko ndo Jesús bikitée ndo, tuinxin xenduaxin ndo inda ko meꞌe xitjeꞌe̱ ngajní ko bikon ndo Espíritue ndo Dio xingajin xranchi naa kuntúá ko bakeꞌe ngataꞌa ndo. ");
INSERT INTO pps_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","*Ko tuinxin kuinꞌenni naa tée séen kui̱xi̱n ngajní ko ndachro: ―Jiꞌin chjanꞌna tsango tjuaꞌa ko juaxruxin ritjén ngajin xjan. ");
INSERT INTO pps_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","*Tjumeꞌe Espíritue ndo Dio bikao ndo Jesús ngataꞌa ijna̱ nchese ko ntiꞌa Xixronꞌanxrée tjaun xa tsakaon xa ndo Jesús. ");
INSERT INTO pps_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Bakeꞌe ndo ijna̱, ko yuukan nchakon ko tiie juinchekatse ñao ndo jinta, méxin kuenꞌen ndo jinta. ");
INSERT INTO pps_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Ko Xixronꞌanxrée konchjiñeꞌe xa ti jii ndo Jesús ixi tjaun xa tsakaon xa ndo, méxin ndachro xa: ―Siá nduaxin jaꞌa Chjenꞌen ndo Dio, ndache ixro meꞌe xrokjan xro nutja. ");
INSERT INTO pps_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Ko jeꞌe ndo juatingíexin ndo: ―Jitaxin xroon chijnie ndo Dio: “Jeꞌa jeꞌo nutja tsechónxin chujni. Kaxon kain chijnie ndo Dio, meꞌe tsechónxin chujni.” ");
INSERT INTO pps_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Tjumeꞌe Xixronꞌanxrée bikao xa ndo Jesús tjajna tsango tjúá, tjajna Jerusalén, ko juinchengajinꞌin xa ndo ti ícha nui ngataꞌa niꞌngo, ");
INSERT INTO pps_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","ko ndachro xa: ―Siá nduaxin jaꞌa Chjenꞌen ndo Dio, chrinka ti nunte ixi jitaxin xroon chijnie ndo Dio: Jeꞌe ndo tsetuenꞌen ndo sen ángel tikinixinꞌen ndo ixi xrotsengia sen ixi tsontengíxinꞌa tutáa ixro. ");
INSERT INTO pps_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Ko jeꞌe ndo Jesús juatingíexin ndo: ―Kaxon ndachro chijnie ndo Dio: “Tsakéꞌa naa ngeꞌe ixi tsikuan á chao sincheꞌe ndo Dio.” ");
INSERT INTO pps_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Ko íjngo nchakon bikao xa ndo Jesús ngataꞌa ijna̱ ícha noi ko juakoꞌe xa ndo kain tjajna jii ngataꞌa nunte xasintajni ko kain ngeꞌe ti tjintee chónda na̱. ");
INSERT INTO pps_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Ko ndachro Xixronꞌanxrée: ―Kain jiꞌi xrotjáꞌa siá jaꞌa tsakeꞌexian ntatuchiꞌian ko xrochjána̱na juasiaa. ");
INSERT INTO pps_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Tjumeꞌe jeꞌe ndo Jesús ndachro ndo: ―Satjia jaꞌa Xixronꞌanxrée, ixi ndachro xroon chijnie ndo Dio: “Jeꞌo Ncháa ndo Dio xrokonda xrochjeꞌé ndo juasaya ko jeꞌo ngajin jeꞌe ndo tsitikaoan.” ");
INSERT INTO pps_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Ko Xixronꞌanxrée ngaxiton xa ko tjumeꞌe kui̱i̱ kaxin sen ángel ngajin ndo Jesús ko kuayakonꞌen sen ndo. ");
INSERT INTO pps_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","*Nchakon ndo Jesús kuinꞌen ndo ixi ndo Juan xraxinꞌin na̱ ndo ndoꞌachjiso, jeꞌe ndo ikjan ndo nunte Galilea. ");
INSERT INTO pps_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","*Ko kuitueꞌa ndo tjajna Nazaret; sakjui ndo tjajna Capernaum, tjajna meꞌe jii ngandeꞌe ndachaon tjenka nunte Zabulón ko Neftalí. ");
INSERT INTO pps_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Jaꞌin konꞌen xranchi ti tsikjin ndo Isaías chijnie ndo Dio. Jaꞌin tsindachro ndo: ");
INSERT INTO pps_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Nunte Zabulón ko nunte Neftalí ti jii chaꞌo ngandeꞌe ndachaon tuenxin ndajitinga ndatinꞌin Jordán, nunte Galilea ti ste ni chúxinꞌa ndo Dio. ");
INSERT INTO pps_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Chujni tjajna ste naxixeꞌe bikon na̱ ijié xroꞌi, ko ni ste ti jii tsaꞌon neꞌe xichononte, xroꞌi bingasáñeꞌe na̱. ");
INSERT INTO pps_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","*Ko nchakon meꞌe kuaxi juako ndo Jesús ko kuandachro ndo: ―Tintuꞌenta ti ndakoꞌa kuancheꞌenta ixi juachaxien ndo Dio jii ngajní ó tjenkanta jii. ");
INSERT INTO pps_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Ndo Jesús jitatsinga ndo ngandeꞌe ndachaon ndatinꞌin Galilea, ntiꞌa bikon ndo yuu sen, sen meꞌe kichuu sen, naa ndo ndatinꞌin Simón ko kuanchekinꞌin na̱ ndo Pedro, ko ndo kichuu ndo ndatinꞌin ndo Andrés. Jeꞌe sen stetánka sen nochaꞌa ngangi inda, ko kuansengi sen kuchee̱ ixi jeꞌe sen ixra̱ meꞌe kuancheꞌe sen. ");
INSERT INTO pps_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Ko ndo Jesús ndache ndo sen: ―Xrokuiinta ruaꞌnaninta ko janꞌan sintakuanꞌannta xronichjeꞌenta chujni meꞌe tsitikaon na̱ najanꞌan, ko xrokjui xranchi xrotsénta kuchee̱. ");
INSERT INTO pps_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Ko tuinxin kuintuꞌe sen nochaꞌa ko ruéꞌe sen ndo. ");
INSERT INTO pps_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Ko kuiji ndo Jesús ícha ndáꞌa bikon ndo íjngo yuu sen, ko sen meꞌe kaxon kichuu sen, naa ndo ndatinꞌin Jacob ko inaa ndo ndatinꞌin Juan, yui sen chjenꞌen ndo Zebedeo ko yui sen stekao sen ndotée sen ngaxinꞌin nta̱barco ixi stetjaun sen nochaꞌa tséxin sen kuchee̱. Tjumeꞌe ndo Jesús kuiyeꞌe ndo sen. ");
INSERT INTO pps_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Ko jeꞌe sen tuinxin kuintuꞌe sen nta̱barco ko kuintuꞌe sen ndotée sen ko ruéꞌe sen ndo Jesús. ");
INSERT INTO pps_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","*Ndo Jesús kuaji ndo nchijíi nunte Galilea ko banchekuenꞌen ndo chujni ngaxinꞌin ningue ni israelita ngujngu tjajna ti bakiji ndo ko kuanchekuenꞌen ndo na̱ chijni natjúá ti tetuanꞌan ndo Dio ko kuanchexruenꞌen ndo kain ichin ko kain ti tiín na̱. ");
INSERT INTO pps_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Ko kain ti ixra̱ jian kuancheꞌe ndo, meꞌe konoꞌe ni ste nunte Siria ko bikaꞌo na̱ kain ni kuachónda ngixeꞌi ichin ko ni chónda espíritue Xixronꞌanxrée, ni bakendáa, ko ni juaꞌi itji, ko ndo Jesús juinchexruenꞌen ndo na̱. ");
INSERT INTO pps_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Ko kueya chujni kuarueꞌe na̱ ndo Jesús, ni nunte Galilea ko ni tjajna Decápolis ko ni tjajna Jerusalén ko nunte Judea ko ni kui̱xi̱n tuenxin ndajitinga ndatinꞌin Jordán. ");
INSERT INTO pps_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Ndo Jesús bikon ndo ixi xejo kueya chujni, meꞌe kuajinꞌin ndo ngataꞌa ijna̱ ko ntiꞌa bakeꞌe ndo nunte. Ko kaxon sen teyuu kuarueꞌe ndo, konchjiñeꞌe sen ngajin ndo. ");
INSERT INTO pps_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Tjumeꞌe ndo Jesús kuaxi nichja ndo ko jaꞌin ndachro ndo: ");
INSERT INTO pps_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","―Juaxruxin tsakeꞌe sen xraxaon ixi nduaxin xrokondeꞌe sen ndo Dio ixi sen meꞌe tsayéꞌe sen juachaxin tsintee sen ti tetuanꞌan ndo Dio. ");
INSERT INTO pps_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","’Juaxruxin tsakeꞌe kain sen stechíín ixi xrojan ngeꞌe ti ndakoꞌa konꞌen sen, ko jeꞌe ndo Dio tsajon ndo juachaxin ixi juaxruxin tsintee sen. ");
INSERT INTO pps_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","’Juaxruxin tsakeꞌe sen nchejiéꞌa aséen ixi jeꞌe sen tsayéꞌe sen nunte ti ó ndachro ndo Dio tsajon ndo. ");
INSERT INTO pps_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","’Juaxruxin tsakeꞌe kain sen tjaun xranchi xrojuine o̱ xrokuiꞌi chijnie ndo Dio ixi jeꞌe ndo Dio tsajon ndo ti jian ngaya aséen sen. ");
INSERT INTO pps_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","’Juaxruxin tsakeꞌe sen tingijna sen kichuu, jaña ndo Dio kaxon tsikonóeꞌe ndo sen. ");
INSERT INTO pps_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","’Juaxruxin tsakeꞌe sen kuitikaon ko juinchetjúá aséen ixi jeꞌe sen nduaxin tsikon sen ndo Dio. ");
INSERT INTO pps_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","’Juaxruxin tsakeꞌe kain sen stetingijna ixi tsinteke̱to̱ꞌa chujni ko ndo Dio sinchekinꞌin ndo sen chjenꞌen ndo. ");
INSERT INTO pps_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","*’Juaxruxin tsakeꞌe sen chinga nchekao na̱ ixi titikaon sen ngeꞌe tjaun ndo Dio, meꞌe jeꞌe sen tikinixinꞌen sen ngajní ti tetuanꞌan ndo Dio. ");
INSERT INTO pps_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","*’Juaxruxin takeꞌé jaꞌanta ti chinga tuyakuꞌanta na̱ ko ningakonꞌannta na̱ ko tjangiꞌanta na̱ ixi kondanaxin janꞌan. ");
INSERT INTO pps_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","*Cháꞌanta ko juaxruxin takeꞌénta ixi jaꞌanta tsayeꞌenta naa ngeꞌe ícha jian jii ngajní. Ixi jaña juinchekao na̱ sen saꞌó, sen kuanichja chijnie ndo Dio. ");
INSERT INTO pps_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","*’Xranchi xíjnteꞌe nunte xasintajni meꞌe jaꞌanta, ko siá xíjnta ijníꞌa xíjnta, ¿xranchi tsojníxin xíjnta íjngo?, ko jaña íxroꞌan tsonda xíjnta, tsintji xíjnta, ko tsingatjangi na̱ xíjnta. ");
INSERT INTO pps_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","*’Xroꞌi tingasáñaxin nunte xasintajni meꞌe jaꞌanta. Naa tjajna jii ngataꞌa naa ijna̱ juaꞌi tsemá tjajna. ");
INSERT INTO pps_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","*Xroꞌan ngisen sinchekakiin naa xroꞌi ko tsakeꞌe sen xroꞌi ngangi naa chikute. Naꞌi, xroꞌi takeꞌe xroꞌi noi ngataꞌa naa nta̱a̱ ixi sinchengasáña xroꞌi kain chujni ste nchia. ");
INSERT INTO pps_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","*Jaña jaꞌanta kaxon nchengasáñeꞌenta kain chujni jii ngandajinnta, meꞌe tsikon chujni ti jian ncheꞌenta, jaña jeꞌe na̱ tsajon na̱ juasaya ngajin Ndotáina jii ngajní. ");
INSERT INTO pps_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","’Jaꞌanta xraxaonꞌanta ixi janꞌan juiꞌi ixi sintamaꞌa ley kuajon ndo Moisés ko ti ngeꞌe ndachro ikaxin sen nichja chijnie ndo Dio. Naꞌi. Janꞌan juiꞌi ixi tsitikaꞌon kain ti kuetuanꞌan ndo Dio ko sintakuanꞌannta ngeꞌe xrondachro chijni meꞌe. ");
INSERT INTO pps_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","*Ko nduaxin xrontatjunta ixi xratsatsingaꞌi ngajní ko nunte xasintajni, xroꞌan ley kuetuanꞌan ndo Dio tsoméꞌe, ko ní naa letra tsachrjendeꞌa. Naꞌi, kain ti ndachro chijni, meꞌe xrokonda tsonꞌen. ");
INSERT INTO pps_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Ko ngisen tsitikaonꞌa ko sincheꞌa ti ndachro ley kuetuanꞌan ndo Dio, maski naa ley nchíín tsitikaonꞌa sen, ko jaña sinchekuenꞌen sen chujni, kaxon nchion juasie ndo Dio tsayéꞌe sen ti jii ngajní tetuanꞌan ndo Dio. Ko siá ndako tsitikaon sen ley kuetuanꞌan ndo Dio ko jaña sinchekuenꞌen sen chujni, ijié juasie ndo Dio tsayéꞌe sen ntiꞌa ti jitetuanꞌan ndo Dio, ");
INSERT INTO pps_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Méxin, janꞌan ntatjunta xrokonda tsango jian tsitikaonnta ndo Dio ícha ixi ni fariseo ko ni tjako ley kuetuanꞌan ndo Dio, ko siá sincheꞌanta ícha jian juaꞌi tsixinꞌinnta ti tetuanꞌan ndo Dio. ");
INSERT INTO pps_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","’Jaꞌanta ó kuinꞌennta ti kuituenꞌen sen saꞌó: “Juaꞌi naatsóñaxónnta ni kichuunta, ixi ngisen sincheꞌe jaña tsitsingataꞌa sen ijie̱.” ");
INSERT INTO pps_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ko janꞌan ndachrja̱n siá xrojan ngisen xraningakonꞌen sen sen kichuu, sen meꞌe tsitsingataꞌa sen ijie̱. Ko ngisen tsengeꞌe kichuu teka, sen meꞌe, ni tetuanꞌan tsjankataꞌa na̱ sen ijie̱. Ko ngisen xrondache sen kichuu ixi tsinchetjáña jaa sen, sen ndachro meꞌe satsji sen ngangi xroꞌi kain nchakon. ");
INSERT INTO pps_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Méxin siá tsikuꞌunta naa ngeꞌe tsajonxinnta juasianta ngajin ndo Dio ngaxinꞌin niꞌngo ko ntiꞌa xroxraxaonnta ixi xrojan sen kichuunta toñaoꞌanta sen, ");
INSERT INTO pps_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","ntiꞌao tintuꞌenta ngeꞌe ritikuunta ngataꞌa altar, ko itjinta, tjaunnta sen ko tjancheꞌenta sen juatitjáña kondeexin ngeꞌe kue̱to̱nta. Tjumeꞌe ikjannta ko tájonnta ti bikuunta ngajin ndo Dio. ");
INSERT INTO pps_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","’Siá xrojan ngisen kuichro ijie̱ kontraanta, cháña tuinxin tjaunnta sen ko nchekonchjiannta ti stetoñaoxinnta ixi xrayaꞌonta chaꞌo, ko xratjasoꞌanta ti jii xi nchéña ijie̱ ba̱ tsituanꞌan xa xi policía xroxraxinꞌinnta xa ndoꞌachjiso. ");
INSERT INTO pps_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Ko nduaxin ntatjunta ixi tsachrjexinꞌanta ndoꞌachjiso tsjengajanta ꞌna̱ kain ti tasinkanta. ");
INSERT INTO pps_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","’Jaꞌanta kuinꞌennta chijni tsikitueꞌen sen saꞌó jaꞌin ndachro: “Chondaꞌinta inaa nchri, nchri jeꞌa nchrinchriꞌanta o̱ jeꞌa xixiꞌanta.” ");
INSERT INTO pps_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ko janꞌan ndachrja̱n ngixeꞌi naa xi xrotsjeꞌe xa inaa nchri ko tsingakuenxin xa nchra, meꞌe ó juincheꞌe xa ti ndakoꞌa ngaya aséen xa. ");
INSERT INTO pps_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","*’Méxin siá ikuan ndatsjonxin jian sintekateya ixi sincheꞌe ti ndakoꞌa, cháña tantsjengia ko ndáꞌa tjanka, ixi cháña tsitjáña tuꞌo cuerpoa ko jeꞌa tsitjáña nchijíi jaꞌa ti jii xroꞌi naiꞌa tsanga. ");
INSERT INTO pps_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","*Ko siá tjáa ndatsjonxin jian sintekateya ixi sincheꞌe ti ndakoꞌa, cháña tonchrijian tjáa ko ndáꞌa tjanka ixi cháña tsitjáña tuꞌo cuerpoa ko jeꞌa tsitjáña nchijíi jaꞌa ti jii xroꞌi naiꞌa tsanga. ");
INSERT INTO pps_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","*’Kaxon kuituenꞌen sen saꞌó ixi ngisen ítjaunꞌa janchriꞌe, chao tsonchjian naa xroon tsintuexin kichuu sen. ");
INSERT INTO pps_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","*Ko janꞌan ndachrja̱n ixi ngixeꞌi xi ítjaunꞌa nchrinchriꞌe xa, ko tjaun xa tsintuꞌe xa nchra, chao, jeꞌo siá nchrinchriꞌe xa juincheyeꞌe nchra xa ixi inaa xi. Siá naꞌi, meꞌe jeꞌe xa xranchi xrojuinchekateya xa nchra sincheꞌe nchra ti ndakoꞌa. Ko xi tsuteꞌe naa nchri, nchri tsikintuꞌe xixiꞌe, xi meꞌe tsama xa ijie̱ kaxon, xranchi naa xi kuejuakao inaa nchri. ");
INSERT INTO pps_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","’Kaxon tsikinꞌennta ti kuetuenꞌen sen saꞌó: “Takeꞌanta ndo Dio xranchi nduaxin xrojuincheꞌenta ti ndachronta ko ncheꞌanta; jaꞌanta xrokonda sincheꞌenta ti tsindachronta ngajin Ncháina.” ");
INSERT INTO pps_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","*Ko janꞌan ndachrja̱n ixi juaꞌi tsakéenta ndo Dio ko ncheꞌanta ti ndachronta o̱ ngixeꞌi naa ngeꞌe ti jii ngajní ixi ngajní meꞌe ntaxitueen ndo Dio, ti tetuanxin ndo. ");
INSERT INTO pps_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Ko kaxon juaꞌi tsakéenta nunte xasintajni ko nduaxinꞌa sincheꞌenta ixi ngataꞌa nunte ntiꞌi takeꞌe tutée ndo Dio, ko juaꞌi xronichjaxinnta ixi tjajna Jerusalén ixi tjajna meꞌe tjajnée ndo Dio, ndo Rey tsango tetuanꞌan. ");
INSERT INTO pps_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Ko kaxon juaꞌi tsakéexinnta jáanta ko nduaxinꞌa sincheꞌenta ti ndachronta, ixi jaꞌanta chondaꞌinta juachaxin xrondachronta ixi naa xrajaanta tsontjúá xra o̱ tsontie xra. ");
INSERT INTO pps_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Méxin nchakon xrondachronta jaán, jaán tsonꞌen, o̱ siá xrondachronta naꞌi, naꞌi tsonꞌen ixi kain ti ícha xronichjanta, meꞌe nchekateyanta Xixronꞌanxrée. ");
INSERT INTO pps_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","’Ó kuinꞌennta ixi kuandachro sen saꞌó siá kuandeꞌena ito̱n ikonnta, jaꞌanta kaxon tandeꞌenta ito̱n ikon na̱. Ko siá ito̱n kuantsjexin na̱ nenonta, jaꞌanta kaxon tandeꞌenta ito̱n neno na̱. ");
INSERT INTO pps_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ko janꞌan ndachrja̱n te̱to̱koꞌinta ni ñaꞌi, ko siá xrojan ni meꞌe tsandeꞌe na̱ itja na̱ ngaya ikonnta, ndatsjonxin jian, takéenta ti ndatsjonxin ikjon kaxon. ");
INSERT INTO pps_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Siá xrojan ni ñaꞌi tsichro na̱ ijie̱ ixi tjaun na̱ tsantsjaꞌanta na̱ camisaanta, tájonnta kaxon chamaranta. ");
INSERT INTO pps_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Ko siá xrojan ni tjaun tsamanta ti iye jitikao na̱ naa kilómetro, jaꞌanta tikuꞌunta yuu kilómetro. ");
INSERT INTO pps_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Siá xrojan ni tsjanchakaꞌa ngajinnta, chje̱ꞌénta na̱, ko siá xrojan ngisen tjaun sinchekjennta na̱ xrojan ngeꞌe, tájonnta. ");
INSERT INTO pps_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","’Ó kuinꞌennta kaxon ti kuandachro sen: “Tjueꞌenta ni tjuaꞌanta ko ningakonꞌennta ni ningakonꞌannta.” ");
INSERT INTO pps_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Ko janꞌan ntatjunta ixi tjueꞌenta ni ningakonꞌannta, ko ndachenta ndo Dio sinchenchaon ndo ni ndakoꞌa nichjaꞌanta, ko tingijnanta ni ningakonꞌannta, ko ndachenta ndo Dio ixi sincheméꞌe ndo ti ndakoꞌa juintaꞌanta na̱ ko ti chinga nichja na̱ ixi jaꞌanta ko ti benginta na̱. ");
INSERT INTO pps_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Meꞌe jaꞌanta xrokjannta chjenꞌen Ndotáina jii ngajní, ndo tetuanꞌan tsachrje chjiixro ngataꞌa ni titikaon ndo ko ngataꞌa ni ñaꞌi, ko kaxon nchekania ndo ichrin ngataꞌa ni jian ncheꞌe ko ni ndakoꞌa ncheꞌe. ");
INSERT INTO pps_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Siá jaꞌanta jeꞌo tjueꞌenta ngisen tjuaꞌanta, ¿ngeꞌe tsjachanta ixi meꞌe? Ixi ni tjejo tomi neꞌe xi tetuanꞌan jaña ncheꞌe na̱ kaxon. ");
INSERT INTO pps_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Siá jeꞌo jian nichjeꞌenta sen kichuunta, ¿á jian rincheꞌenta, richronta? Jaña ncheꞌe ni chúxinꞌa ndo Dio kaxon. ");
INSERT INTO pps_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Méxin tsango jian ko ndako ncheꞌenta kain ngeꞌe xranchi Ndotánta jii ngajní, jian ncheꞌe jeꞌe ndo ko jian ndo. ");
INSERT INTO pps_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","*’Tingijnaꞌinta ni xrokondeꞌe ixi jeꞌo tjaunnta tsikon chujni ti jian rincheꞌenta. Siá jaña sincheꞌenta, Ndotánta jii ngajní tsajonꞌa ndo ngeꞌe tsjachanta. ");
INSERT INTO pps_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Méxin nchakon tsingijnanta naa ni nóa, ndacheꞌanta ikaxin chujni ngeꞌe juincheꞌenta. Ncheꞌanta xranchi ncheꞌe ni tjako inaa ikon. Nchakon ste na̱ ngaya chaꞌo o̱ niꞌngo, tingijna na̱ ni nóa ixi tjaun na̱ tsikon chujni ngeꞌe ncheꞌe na̱ ixi jaña xrondachro chujni ixi tsango jian jeꞌe na̱. Ko janꞌan ndachrja̱n ixi ni meꞌe ó kuayéꞌe na̱ ti tikinixinꞌen na̱. ");
INSERT INTO pps_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Ko jaꞌanta nchakon tsingijnanta naa ni nóa, imao ncheꞌenta, ko sen ícha tjentonta tsonoeꞌa sen. ");
INSERT INTO pps_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Imao tingijnanta ni nóa ko ndotánta jii ngajní, ndo tsjeꞌe ngeꞌe ncheꞌenta imao, jeꞌe ndo tsajon ndo ngeꞌe tsjachanta ixi ti jian juincheꞌenta. ");
INSERT INTO pps_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","*’Ko nchakon jaꞌanta xronichjeꞌenta ndo Dio, ncheꞌanta xranchi ncheꞌe ni tjako inaa ikon, ni meꞌe ncheꞌe na̱ juaxruxin siin na̱ nichjeꞌe na̱ ndo Dio ngaxinꞌin niꞌngo ko ngaya chaꞌo, ixi jaña tsikon chujni ngeꞌe stencheꞌe na̱. Ko janꞌan ndachrja̱n ixi ni meꞌe ó chónda na̱ ngeꞌe tikinixinꞌen na̱. ");
INSERT INTO pps_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Ko jaꞌanta nchakon xronichjeꞌenta ndo Dio, tixinꞌinnta ndointa, tijeꞌe̱nta nta̱chja ko ntiꞌa nichjeꞌenta ndo imao. Ko jeꞌe ndo ó jitsjeꞌe ndo ngeꞌe ncheꞌenta imao ko jeꞌe ndo tsajon ndo ngeꞌe jian tsayeꞌenta. ");
INSERT INTO pps_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","’Ko nchakon nichjeꞌenta ndo Dio, nichjaꞌinta xrajeꞌo ko xrajeꞌo chijni, xranchi ncheꞌe ni chúxinꞌa ndo Dio, ixi jeꞌe na̱ xraxaon na̱ ixi siá itsjé xronichja na̱, meꞌe tsinꞌen ndo Dio. ");
INSERT INTO pps_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Jaꞌanta nichjaꞌinta xranchi ncheꞌe jeꞌe na̱ ixi Ndotánta ó noꞌe ndo ngeꞌe xrokondaꞌanta maski xratjancheꞌanta ndo. ");
INSERT INTO pps_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Jaꞌanta jaꞌin nichjeꞌenta ndo Dio: Ndotána, jaꞌanta ritjennta ngajní, tsango tjúá jaꞌanta. ");
INSERT INTO pps_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Janꞌanna tjaꞌonna tsjiꞌinta tsetuanꞌannta ngataꞌa nunte ntiꞌi ko tsonꞌen xranchi xrondachro jaꞌanta ngataꞌa nunte ntiꞌi, jaña kaxon tsonꞌen ngajní. ");
INSERT INTO pps_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Tájonnta nutja sinena jai. ");
INSERT INTO pps_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Ko jaꞌanta ncheméꞌenta kain ti ndakoꞌa juintaꞌana xranchi janꞌanna ntamáꞌana ngaya aséena̱na ti ndakoꞌa juinchena̱na ikaxin chujni. ");
INSERT INTO pps_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Tintueꞌanta ixi ti ndakoꞌa sintaꞌana, ko tájonꞌanta juachaxin ixi xrojan ngeꞌe sinchena̱na Xixronꞌanxrée ixi jaꞌanta tituanꞌannta kain ngeꞌe ko chondanta ijié juachaxin kain nchakon. Jaña tsonꞌen. ");
INSERT INTO pps_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","*’Ko siá jaꞌanta sincheméꞌenta ngaya asáanta ti ndakoꞌa juintaꞌanta na̱, kaxon Ndotánta jii ngajní sincheméꞌe ndo ti ndakoꞌa juincheꞌenta. ");
INSERT INTO pps_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ko siá jaꞌanta sincheméꞌanta ngaya asáanta ti ndakoꞌa juintaꞌanta na̱, kaxon Ndotánta jii ngajní sincheméꞌa ndo ti ndakoꞌa juincheꞌenta. ");
INSERT INTO pps_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","’Jaꞌanta nchakon sinchekatse ñaonta jinta, ncheꞌanta xranchi ncheꞌe ni tjako yuu ikon, ixi jeꞌe na̱ juichenchíín ikon na̱, meꞌe jaña tsikon chujni ixi jeꞌe na̱ jinchekatse ñao na̱ jinta. Janꞌan nduaxin ntatjunta ixi ni meꞌe ó kuayéꞌe na̱ ti tikinixinꞌen na̱. ");
INSERT INTO pps_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Jaꞌanta nchakon rinchekatse ñaonta jinta, néma ikonnta ko jian tonchjiannta ");
INSERT INTO pps_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","ixi jaña tsonoeꞌa chujni ixi jaꞌanta rinchekatse ñaonta jinta. Jeꞌo Ndotánta jii ngajní tsonoꞌe ndo, ko jeꞌe ndo jitsjeꞌe ndo ti imao rincheꞌenta, jeꞌe ndo tsajon ndo naa ngeꞌe tsjachanta. ");
INSERT INTO pps_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","*’Tasintjaꞌinta ti tjintee jii ngataꞌa nunte ntiꞌi, ixi ntiꞌi tiꞌi kuchi̱i ko itjo kain ngeꞌe, ko xicheꞌe chao tixinꞌin xa ndointa ko tse̱e xa ti tjintee chondanta. ");
INSERT INTO pps_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Cháña ngajní tasintjanta kain ti tjintee ixi ntiꞌa kuchi̱i xroꞌan ncheꞌe ba, ko ntiꞌa xroꞌan ngeꞌe itjo, ko xicheꞌe juaꞌi tse̱e xa. ");
INSERT INTO pps_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Ixi ti no jii ti tsango tjintee chondanta, ntiꞌa tsakeꞌe asáanta kaxon. ");
INSERT INTO pps_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","’Ikonnta meꞌe nchengasáñaꞌanta. Méxin, siá jian ikonnta, jian tsingasáña nchijíi jaꞌanta. ");
INSERT INTO pps_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Ko siá ikonnta jeꞌa jian, kaxon nchijíi jaꞌanta naxixeꞌe tsakeꞌenta. Ko siá xroꞌi chondanta jeꞌa xroꞌi jian tingasáña, tsango naxixeꞌe tsakeꞌenta. ");
INSERT INTO pps_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","’Xroꞌan ngisen jian sincheꞌe ixra̱ ngajin yuu nchée; xroningakonꞌen sen naa nchée sen o̱ xrotjueꞌe sen inaa nchée sen, kaxon tsango jian sincheꞌe sen ixra̱ ngajin naa nchée sen ko ngajin inaa nchée sen, naꞌi. Juaꞌi sincheꞌeni ixra̱ ngajin ndo Dio ko xrotjueꞌeni tomi. ");
INSERT INTO pps_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","’Janꞌan ntatjunta: Taꞌinta juachjaon ixi ngeꞌe sintenta o̱ ngeꞌe tsiꞌinta o̱ ngeꞌe tsaritsiinta. ¿Á ícha tjintee ngeꞌe ti sintenta ixi ti chondanta juachaxin tsaricho̱nnta? Xraxaonnta ixi ícha tjintee asáanta ko ti chondanta juachaxin tsaricho̱nnta ixi ti tsaritsiinta ko ti sintenta. ");
INSERT INTO pps_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Tsjeꞌenta kuxe, jeꞌe ba tengaꞌi ba ko tandáꞌi ba ko tatsinꞌa ba ti sine ba, ko Ndotáina jii ngajní tajon ndo ngeꞌe sine ba. Ko jaꞌanta ícha tjinteenta ixi naa kuxe. ");
INSERT INTO pps_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","¿Ko ngixeꞌi jaꞌanta ixi tsango taanta juachjaon, á meꞌe ícha tsojinenta xranchi ngusinexin naa metro? ");
INSERT INTO pps_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","’¿Ko sonda tsango taanta juachjaon ixi ngeꞌe tsaritsiinta? Tsjeꞌenta xranchi tangi itsjo. Itsjo meꞌe ncheꞌa tsjo ixra̱ ko tjaunꞌa tsjo manta, ");
INSERT INTO pps_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","ko janꞌan ntatjunta ixi xi rey Salomón, xi kuachónda tsango itsjé ngeꞌe, kuitsaꞌi xa xranchi itsjo meꞌe. ");
INSERT INTO pps_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Ko siá ndo Dio jaña nchekitsáa ndo ika, ka jai jichón, ko ndúya xroche ka ngaya itja̱, ¿xranchi sinchekitsáꞌinta ndo Dio jaꞌanta ti chuntiaꞌinta ndo? ");
INSERT INTO pps_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Méxin, taꞌinta juachjaon, ko ndachroꞌanta ixi ngeꞌe sintenta o̱ ngeꞌe tsiꞌinta o̱ ngeꞌe tsaritsiinta, ");
INSERT INTO pps_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","ixi chujni chúxinꞌa ndo Dio tsango taa na̱ juachjaon ixi meꞌe. Ko Ndotáina jii ngajní, jeꞌe ndo ó noꞌe ndo ngeꞌe xrokondaꞌanta. ");
INSERT INTO pps_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Saꞌó tjéenta juachaxien ndo Dio ko ncheꞌenta ti jian, ko tjumeꞌe jeꞌe ndo tsajon ndo kain ngeꞌe xrokondaꞌanta. ");
INSERT INTO pps_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Ko taꞌinta juachjaon ngeꞌe tsonꞌen ndúya ixi nchakon ndúya, nchakon meꞌe noaꞌinta ngeꞌe juachjaon tsikaꞌo. ");
INSERT INTO pps_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","’Tjankataꞌinta ijie̱ ngajin ikaxin chujni ixi jaña ndo Dio kaxon tsjangataꞌinta ndo ijie̱. ");
INSERT INTO pps_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","*Ndo Dio tsjankataꞌa ndo ijie̱ ngajinnta xranchi jaꞌanta tsjankataꞌanta ijie̱ ngajin ikaxin chujni. Ko xranchi sincheꞌe jaꞌanta jaña kaxon ndo Dio sincheꞌe ndo ngajinnta. ");
INSERT INTO pps_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Jaꞌanta tikonnta naa xineno jingi ikon sen kichuunta ko tikonꞌanta naa nta̱siji jingi ikonnta. ");
INSERT INTO pps_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Ko siá jaꞌanta chondanta naa nta̱siji jingi ikonnta, ¿xranchi xrondachenta sen kichuunta ixi jaꞌanta tsantsjengínta xineno jingi ikon sen? ");
INSERT INTO pps_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Jaꞌanta ti yuu ikonnta nichjakuanta, saꞌó tantsjenginta nta̱siji jingi ikonnta ko tjumeꞌe chao tsikonnta tsantsjengínta xineno jingi ikon sen kichuunta. ");
INSERT INTO pps_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","’Chjeꞌanta kunia kain ti tjúá tikinixinꞌen ndo Dio ixi ba̱ xrokjan ba ngajinnta ko sinaꞌanta ba ko naatsóñaxónnta ba. Kaxon chjeꞌanta kuchinga ixro tjintee ndatinꞌin perla ixi ba̱ tsingatjangi ba ixro. ");
INSERT INTO pps_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","’Tjanchianta ko ndo Dio xrotjáanta ndo ngeꞌe tjaunnta. Tjéenta ko tsinchíinta. Tinganta nta̱chja ko xroxitjeꞌe nta̱chja. ");
INSERT INTO pps_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Ixi ngisen tjanchia, tayéꞌe sen, ko ngisen tjée, titja sen, ko ngisen tinga nta̱chja, xitjeꞌe̱ nta̱chja. ");
INSERT INTO pps_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","’¿Á xrojan jaꞌanta, xrochjeꞌénta chjanꞌanta naa ixro sine xjan, siá jitjanchia xjan naa nutja? ");
INSERT INTO pps_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","O̱, ¿xrochjeꞌénta xjan naa kunchee sine xjan, siá juanchiaꞌanta xjan naa kuchee̱? ");
INSERT INTO pps_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Ko jaꞌanta ñaꞌinta, ko noꞌanta chje̱ꞌénta chjanꞌanta ngeꞌe ti jian, Ndotáina jii ngajní ícha jian ndo, ko jeꞌe ndo tsajon ndo ngeꞌe ícha jian tsayéꞌe sen tjanchia ngajin ndo. ");
INSERT INTO pps_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","*’Jaꞌanta nchekuunta chujni xranchi tjaunnta sintaꞌanta na̱ ixi jaña kuetuanꞌan ley neꞌe ndo Moisés ko jaña ndachro xroon tsikjin sen kuachronga chijnie ndo Dio. ");
INSERT INTO pps_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","’Tixixinnta nta̱chja ijno. Ixi nta̱chja ko chaꞌo tsitjáñaxin chujni, yui meꞌe tsango ito̱n ko kueya chujni ntiꞌa tixixin na̱. ");
INSERT INTO pps_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Nta̱chja ko chaꞌo tixixinni ngajní, meꞌe tsango ijno ko tsjéꞌa sen tixixin nta̱chja meꞌe. ");
INSERT INTO pps_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","’Tsjeꞌenta jian ixi kueya ni ndachro ixi jeꞌe na̱ nichja na̱ chijnie ndo Dio ko nduaxinꞌa. Jeꞌe na̱ tetsáa na̱ xranchi naa kutuchjon, ko ngaya aséen na̱ ncheꞌe na̱ xranchi naa kundanixra tsango jieꞌe. ");
INSERT INTO pps_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Jaꞌanta jaiko tsichuxinnta na̱ ixi ti ngeꞌe ncheꞌe na̱, xranchi nta̱chaꞌa juaꞌi tajon nta̱a̱ tu uva o̱ tu higo. ");
INSERT INTO pps_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Méxin, kain nta̱a̱ jian tajon nta̱a̱ itu jian, ko nta̱a̱ jeꞌa jian tajon nta̱a̱ itu xroꞌan xrée. ");
INSERT INTO pps_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Naa nta̱a̱ jian, nta̱a̱ meꞌe juaꞌi tsajon nta̱a̱ itu xroꞌan xrée, ko nta̱a̱ jeꞌa jian, nta̱a̱ meꞌe juaꞌi tsajon nta̱a̱ itu jian. ");
INSERT INTO pps_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","*Kain nta̱a̱ tajon itu xroꞌan xrée xrokonda xrochrijin nta̱a̱ ko xroche nta̱a̱. ");
INSERT INTO pps_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","*Ko jaña tsichuxinnta chujni kaxon ixi ti ngeꞌe ncheꞌe chujni. ");
INSERT INTO pps_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","’Kainꞌa ni xrondachro: “Jaꞌanta, Nchána”, tsixinꞌin na̱ ti tetuanꞌan ndo Dio. Jeꞌo sen titikaon ti tetuanꞌan Ndotána jii ngajní, tsixinꞌin sen ntiꞌa. ");
INSERT INTO pps_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Nchakon tsi̱i̱ ti tetuanꞌan ndo Dio, itsjé sen xrondachro sen: “Nchána, Nchána, janꞌanna nichjaxinna nombreanta ko nombreanta kuantsjexinna espíritue Xixronꞌanxrée ko nombreanta juintaxinna kueya ixra̱ ijié.” ");
INSERT INTO pps_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Ko tjumeꞌe ndo Jesús xrondache ndo sen: “Janꞌan chuxinꞌanta, ndáꞌa itjinta, jaꞌanta ti juincheꞌanta ti ndako.” ");
INSERT INTO pps_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","’Méxin ngisen tinꞌen ko titikaon ngeꞌe ndachrja̱n, sen meꞌe ste sen xranchi naa xi xraxaon jian ixi juinchekonchjian xa ndoꞌa xa ngataꞌa itjao. ");
INSERT INTO pps_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Kuania ichrin, ko koyeé inda tsaaka, ko soji kui̱i̱ chrinto ngataꞌa nchia meꞌe, ko kuitsingaꞌi nchia ixi ngataꞌa ixro soji jitaꞌa nchia. ");
INSERT INTO pps_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Ko ngisen tinꞌen ngeꞌe ndachrja̱n ko titikaonꞌa na̱ sen, sen meꞌe ncheꞌe sen xranchi naa xi ninta ixi juinchekonchjian ndoꞌa xa ti jii nchese. ");
INSERT INTO pps_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ko tjumeꞌe kui̱i̱ ichrin ko koyeé inda tsaaka, ko kui̱i̱ chrinto ngataꞌa nchia meꞌe; méxin kuitsinga nchia, ko tsango ijié juachjaon konꞌen ixi ngataꞌa nchese juinchekonchjian xa nchia. ");
INSERT INTO pps_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","*Ko hora juexin nichja ndo Jesús, chujni stetinꞌen ndachro na̱ ixi tsango ijié juachaxin chónda ndo ko chaxro juako ndo ");
INSERT INTO pps_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","ixi juako ndo xranchi naa ngisen tsango ijié tituanꞌan ko juakoꞌa ndo xranchi ni tjako ley. ");
INSERT INTO pps_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Hora xingajinxin ndo Jesús ijna̱, itsjé chujni ruéꞌe na̱ ndo. ");
INSERT INTO pps_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Ko konchjiñeꞌe naa xi niꞌe chónda xa ichin lepra ko bakeꞌexin ntatuchiꞌin xa ngajin ndo Jesús ko ndachro xa: ―Nchána, siá tjaunnta chao sinchexruananinta ―ichro xa. ");
INSERT INTO pps_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Ko tjumeꞌe ndo Jesús ba̱ke̱ꞌe̱ itja ndo ngataꞌa xa ko ndachro ndo: ―Jaán tjaꞌon. Jai tsachrjaꞌa ichin jiꞌin. Ko juexin ndachro ndo jaña, jeꞌe xa tuinxin kuachrjeꞌe xa ichin meꞌe. ");
INSERT INTO pps_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Ko ndo Jesús ndache ndo xa: ―Xroꞌan ngisen tekiꞌé jiꞌin. Jeꞌo itjia ngajin xitaana ko tájuan juasiaa xranchi tsiketuanꞌan ndo Moisés ixi jaña tsonoꞌe xitaana ixi ó koxruanꞌan. ");
INSERT INTO pps_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Nchakon kuixinꞌin ndo Jesús tjajna Capernaum, konchjiñeꞌe naa xi capitán neꞌe Roma ko kuinóatée xa, ko jaꞌin ndachro xa: ");
INSERT INTO pps_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","―Nchána, nía jii naa chán nchexra̱na ko jeꞌe chán níexin chán ichin juaꞌi tontengini ko tsango tiín chán. ");
INSERT INTO pps_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Meꞌe ndo Jesús juatingíexin ndo: ―Janꞌan itsji sintaxruanꞌan chán. ");
INSERT INTO pps_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Ko xi capitán juatingíexin xa: ―Naꞌi, Nchána, janꞌan tikinixinnaꞌi tsixinꞌinnta nía. Jaꞌanta jeꞌo tetuenꞌennta ichin tsachrje ichin, ko jeꞌe chán tsoxruenꞌen chán. ");
INSERT INTO pps_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Janꞌan kaxon chonda ngisen tetuanna ko kaxon janꞌan chonda xi soldado tetuanꞌan. Nchakon janꞌan tetuanꞌan naa xi soldado ixi itsji xa xrojan no, jeꞌe xa titikaon xa. Ko janꞌan tetuanꞌan inaa xa tsi̱i̱ xa ndaꞌi, ko jeꞌe xa ti̱i̱ xa. Ko kaxon tetuanꞌan xi nchexra̱na xrojan ngeꞌe sincheꞌe xa, ko jeꞌe xa ncheꞌe xa ti ndachrja̱n. ");
INSERT INTO pps_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Ko kuinꞌen ndo Jesús ngeꞌe ndachro xi capitán, tsango juincheꞌe ndo juaxruxin ngeꞌe chro xa, ko ndache ndo chujni steruéꞌe: ―Nduaxin xrontatjunta ixi xroꞌan ngisen nchijíi nunte Israel kui̱nꞌa̱n jaꞌin nichja ko tsango chuntia xranchi xi jiꞌi. ");
INSERT INTO pps_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","*Janꞌan ntatjunta ixi tsi̱i̱ kueya chujni, ni tsi̱ꞌxi̱n chjuya ko ni tsi̱ꞌxi̱n retuya sinekaꞌo na̱ ndo Abraham ko ndo Isaac ko ndo Jacob ti jii nchia tetuanꞌan ndo Dio ngajní. ");
INSERT INTO pps_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","*Ko kueya sen tikinixinꞌen xrobakeꞌe sen nchia ti tetuanꞌan ndo Dio, sen meꞌe tsachrjexin sen ntiꞌa, ko nduja tsakeꞌe sen ti naxixeꞌe ko ntiꞌa xrotsjanga sen ko tse̱to̱ neno sen ixi tsango xroxronka sen. ");
INSERT INTO pps_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Tjumeꞌe ndo Jesús ndache ndo xi capitán: ―Itjia ndúya, ko tsonꞌen xranchi jaꞌa kuitikaoan. Ko chán nchexrée xi capitán hora meꞌe koxruenꞌen chán. ");
INSERT INTO pps_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Ndo Jesús ikjui ndo ndoꞌa ndo Pedro ko ntiꞌa bikon ndo janchée ndo Pedro jitsinga jan ko tsango yaa jan súa. ");
INSERT INTO pps_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Meꞌe ndo Jesús itsé ndo itja jan ko tuinxin kuachrjeꞌe jan súa, ko jaiko bingatjen jan juinchekonchjian jan ngeꞌe sine sen. ");
INSERT INTO pps_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Ko tiie meꞌe bikaoꞌe na̱ ndo Jesús kueya chujni chónda espíritue xi ñaꞌi ko jeꞌe ndo naáko chijni nichja ndo ko tuinxin kuachrjeꞌe na̱ espíritue xi ñaꞌi, ko kaxon juinchexruenꞌen ndo ikaxin ni niꞌe. ");
INSERT INTO pps_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Jiꞌi konꞌen ixi jaña tsichronga ndo Isaías chijnie ndo Dio ó sée: “Jeꞌe ndo kuama ndo ichin chondana ko jeꞌe ndo kuama ndo ti tiínna ko ti sojiꞌana.” ");
INSERT INTO pps_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Hora bikon ndo Jesús ixi kueya chujni xejo ngandajin ndo, kuetuanꞌan ndo ixi tsatsingatuꞌe sen ndalago. ");
INSERT INTO pps_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Ko naa xi tjako ley kuetuanꞌan ndo Dio konchjiñeꞌe xa ngajin ndo Jesús ko ndachro xa: ―Maestro, janꞌan tjaꞌon xroruaꞌanta ko itsji ti no itsjinta. ");
INSERT INTO pps_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Ko juatingíexin ndo Jesús ko ndachro ndo: ―Kutuunta chónda ba itjao̱ tejuaxinꞌin ba, ko kuxe chónda ba kakée ba. Ko Chjenꞌen ndo Dio, xjan jongíꞌe xranchi chujni, chóndaꞌi xjan ti no tsjokéexin xjan. ");
INSERT INTO pps_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Ko naa sen chrikao ndo, ndachro sen: ―Nchána, chjánanta juachaxin tsjabaja ndotána. ");
INSERT INTO pps_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Ko ndo Jesús juatingíexin ndo: ―Tuinxin ruaꞌna̱na jaꞌa. Tintuꞌé ni tsikenꞌen tsjabaa kichuu na̱. ");
INSERT INTO pps_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Ndo Jesús kuixinꞌin ndo nta̱barco ko sen teyuu chrikao ndo kaxon kuixinꞌin sen. ");
INSERT INTO pps_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Kuania ichrin ko kui̱i̱ naa chrinto tsango soji ko ndachaon tsango soji jamangitaon nda. Ko ndo Jesús jijua ndo. ");
INSERT INTO pps_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Tjumeꞌe sen teyuu chrikao ndo Jesús ikjui sen juinchexingameꞌe sen ndo ko ndachro sen: ―Nchána, tingijnaninta ixi xrojamangi nta̱barco. ");
INSERT INTO pps_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Ko jeꞌe ndo ndachro ndo: ―¿Sonda stexronkanta, jaꞌanta? ¿Á chuntiaꞌinta ndo Dio? Tjumeꞌe bingatjen ndo ko kuyakutee ndo chrinto ko ndachaon ko tuinxin ndabakeꞌe nda. ");
INSERT INTO pps_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Ko sen ruéꞌe ndo ndastetsjeko sen ixi ngeꞌe konꞌen, ko ndachro sen: ―¿Ngixeꞌe xi jiꞌin?, ixi nichjeꞌe xa chrinto ko ndachaon ko titikaon nda. ");
INSERT INTO pps_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Hora ndo Jesús kuiji ndo tuenxin ndachaon ti jii nunte Gadara, kuachrje kui̱i̱ yuu xi ste ti no xrabaa ni tsikenꞌen. Xi meꞌe chónda xa espíritue Xixronꞌanxrée ko tsango chinga ncheꞌe xa, meꞌe xronka chujni, méxin tatsingaꞌi na̱ ti jii chaꞌo meꞌe. ");
INSERT INTO pps_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Ko xi meꞌe kuaxi kuyako xa ko ndachro xa: ―¿Sonda nchexronkana, Jesús, Chjenꞌen ndo Dio? ¿Á ó juiꞌia ixi sinchexronkana maski xratiꞌa nchakon sinchéña ijie̱ ngajinna? ");
INSERT INTO pps_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Tjenka ntiꞌa jii kueya kuchinga steneña ba. ");
INSERT INTO pps_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Ko espíritue Xixronꞌanxrée kuinóatée ngajin ndo Jesús ko ndachro: ―Siá tsantsjexianna ntiꞌi, tintuna̱na tsixinꞌinna kuchinga ste yáꞌa. ");
INSERT INTO pps_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Ko ndachro ndo Jesús: ―Chao tixinꞌia ngaxinꞌin kuchinga. Tjumeꞌe espíritue Xixronꞌanxrée kuachrjexin xi meꞌe ko kuixinꞌin ngaxinꞌin kain kuchinga. Ko kain kuchinga chrinka ba ti jii yasoꞌe, ko kuitsingangi ba inda, ko ntiꞌa kjunꞌen ba inda. ");
INSERT INTO pps_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Ko ni stetsjeꞌe kuchinga xronka na̱ ko sabinga na̱ sakjui na̱ tjajna ko bekiꞌe na̱ chujni ngeꞌe konꞌen kuchinga ko ngeꞌe konꞌen xi kuachónda espíritue Xixronꞌanxrée. ");
INSERT INTO pps_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Ko kain ni tjajna meꞌe ikjui na̱ ngajin ndo Jesús ko hora bikon na̱ ndo kuinóatée na̱ ngajin ndo ixi satsjixin ndo tjajna ntiꞌa. ");
INSERT INTO pps_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Tjumeꞌe ndo Jesús kuixinꞌin ndo nta̱barco ko kuatsinga ndo tuenxin ndalago ko kuiji ndo tjajnée ndo. ");
INSERT INTO pps_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Ko ntiꞌa kaxin chujni bikaoꞌe na̱ ndo naa xi tsikenꞌen tutée jitsingataꞌa xa naa kania. Ko ndo Jesús bikon ndo ixi nduaxin chujni meꞌe chuntia na̱ ngajin ndo, méxin nichjeꞌe ndo xi niꞌe ko ndachro ndo: ―Chjanꞌna, takeꞌé juaxruxin, ixi kain ti ndakoꞌa juincheꞌe, janꞌan ndachrja̱n ó koméꞌe jía. ");
INSERT INTO pps_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Tjumeꞌe kaxin ni nchekuenꞌen chujni chijnie ndo Dio stendachro na̱ ngaya aséen na̱: ―Xi jiꞌi nichjangíꞌe xa ndo Dio. ");
INSERT INTO pps_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Ko ndo Jesús noꞌe ndo ngeꞌe stexraxaon xa ngaya aséen xa, meꞌe ndachro ndo: ―¿Sonda ndakoꞌa xraxaonnta ngaya asáanta? ");
INSERT INTO pps_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","¿Ngeꞌe ícha tangiꞌa xrondachroni: “Ti ndakoꞌa juincheꞌe ó juintamáꞌa”, o̱ xrondacheni xi jiꞌi: “Tingatjen ko tjasían ko tajia”? ");
INSERT INTO pps_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Méxin, sintanoꞌanta ixi Chjenꞌen ndo Dio, xjan jongíꞌe xranchi chujni, tsango tituanꞌan xjan ngataꞌa nunte ntiꞌi ixi sincheméꞌe xjan ti ndakoꞌa juincheꞌe chujni. Tjumeꞌe ndache ndo xi niꞌe: ―Tingatjen, tama kaniꞌa ko satjia ndúya. ");
INSERT INTO pps_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Ko xi tsikenꞌen tutée bingatjen xa ko sakjui xa ndoꞌa xa. ");
INSERT INTO pps_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Ko kain ni ste ntiꞌa bikon na̱ naa ixra̱ tsango ijié konꞌen, xronka na̱ ko kuaxi na̱ kuajon na̱ juasaya ngajin ndo Dio ixi tsango ijié juachaxin tsikajon ndo ngajin chujni ste ngataꞌa nunte xasintajni. ");
INSERT INTO pps_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Hora sakui̱xi̱n ndo Jesús ntiꞌa, tjumeꞌe bikon ndo naa xi ndatinꞌin Mateo jitayéꞌe xa tomi neꞌe xi tituanꞌan. Meꞌe ndachro ndo Jesús: ―Jaꞌa ruaꞌna̱na. Ko jeꞌe xi Mateo bingatjen xa ko ruéꞌe xa ndo Jesús. ");
INSERT INTO pps_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","*Nchakon meꞌe ndo Jesús ko sen teyuu chrikao ndo ikjui sen ndoꞌa xi Mateo bijine sen, ko ntiꞌa ste ikaxin xi tayéꞌe tomie xi tituanꞌan ko ikaxin ni ndakoꞌa ncheꞌe. ");
INSERT INTO pps_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Ko kaxin xi fariseo bikon xa ndo Jesús ngakjenꞌen chujni meꞌe, méxin juanchangiꞌe xa sen teyuu chrikao ndo Jesús, ko ndachro xa: ―¿Sonda ndo ntakuanꞌannta nekao ndo ni xengeꞌe na̱ tomie xi tituanꞌan ko ni ndakoꞌa ncheꞌe? ");
INSERT INTO pps_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Ko ndo Jesús kuinꞌen ndo ngeꞌe stendachro na̱, meꞌe juatingíexin ndo: ―Jeꞌa sen chao ste xrokondeꞌe xi nchexruan; sen niꞌe, meꞌe sen xrokondeꞌe xa. ");
INSERT INTO pps_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","*Itjinta ko tanginta ngeꞌe jitaxin xroon chijnie ndo Dio ti ndachro: “Janꞌan tjaꞌon ixi jaꞌanta tsikonóeꞌenta chujni; jeꞌa jeꞌo tsonꞌinta iko ko xroche jnié ba, meꞌe tsayáꞌa̱.” Jaꞌin ndachro chijnie ndo Dio. Ixi janꞌan juiꞌa ntiꞌi ixi tsiyaꞌa chujni jian ncheꞌe. Naꞌi. Janꞌan juiꞌi ixi tsiyaꞌa chujni ndakoꞌa ncheꞌe ko jeꞌe na̱ tsintuꞌe na̱ ti ndakoꞌa ncheꞌe na̱. ");
INSERT INTO pps_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Naa nchakon konchjiñeꞌe sen chrikao ndo Juan Bautista ko juanchangiꞌe sen ndo Jesús: ―Sonda janꞌanna ko ni fariseo nanaó ntekatse ñaoꞌo na̱ jinta, ko sen chrjikuꞌunta, ¿sonda naꞌi? ");
INSERT INTO pps_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Tjumeꞌe juatingíexin ndo Jesús: ―Sen tsikiyeꞌe xi tsuteꞌe ko sen ste kiée xa, ¿á chao xrotsjanga sen siá jeꞌe xa xrajíi xa ngajin sen? Ko tsi̱i̱ nchakon satsjikao na̱ xi tsuteꞌe, nchakon meꞌe tsaxi sinchekatse ñao sen jinta. ");
INSERT INTO pps_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","’Xroꞌan ngisen tjao̱n mantée ti tsikichje ko takeꞌe tuꞌo manta natjúá ixi nchakon tsijma manta tsixeꞌe ti natjúá ko ícha tsinchje ti nta̱xi. ");
INSERT INTO pps_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Ko juaꞌi tsikia ndée tu uva ti nandá tsikoña ixran ngaya naa tjua̱nxra̱n nta̱xi ixi xroxruji xran ko tsinchje xran tjua̱nxra̱n nta̱xi ko íxroꞌan tsonda tjua̱nxra̱n ko kaxon tsintji xran. Méxin, xran natjúá xrokonda tsikia xran tjua̱nxra̱n natjúá, jaña yui jian tsonda. ");
INSERT INTO pps_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Ko xrajinichja ndo Jesús, kui̱i̱ naa xi tituenꞌen sen tjajna judío bakeꞌexin ntatuchiꞌin xa ngajin ndo ko kuinóatée xa: ―Nchrichajanꞌna nandákua juexin kuenꞌen nchrichan. Ko siá suixinnta itsjinta ko tsakée tjáanta ngataꞌa nchrichan, jeꞌe nchrichan xroxechón nchrichan. ");
INSERT INTO pps_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Ko ndo Jesús bingatjen ndo ko sabikao ndo sen kuarueꞌe ndo. ");
INSERT INTO pps_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Kaxon konchjiñeꞌe naa nchri, ó teyuu nano níexin nchra jnié nchra ko imao konchjiñeꞌe nchra tuenxin ndo Jesús ko itsé nchra ngandeꞌe manta jitsáa ndo. ");
INSERT INTO pps_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Ixi jeꞌe nchra jaña tsixraxaon nchra: ―Maski ngandeꞌe manta jitsáa ndo Jesús xrotse̱, meꞌe tsoxruanna. ");
INSERT INTO pps_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Ndo Jesús tuinxin ngatjia ndo ko bikon ndo nchra, ko ndachro ndo: ―Chjanꞌna, takeꞌé juaxruxin jaꞌa ixi ti chuntiana meꞌe juintaxruanꞌan. Ko jeꞌe nchra koxruenꞌen nchra hora meꞌe. ");
INSERT INTO pps_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Ko hora kuiji ndo Jesús ndoꞌa xi tituenꞌen ni judío, bikon ndo ixi ó tsikiji ni tanoa ntaxro ixi itsji na̱ tsijabaa na̱ nchrichajan. Ko chujni ste ntiꞌa stetsjanga na̱. ");
INSERT INTO pps_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Meꞌe ndachro ndo Jesús: ―Tachrjexinnta ntiꞌi ixi xjan jiꞌi tsikenꞌa xjan; jeꞌo jijua xjan. Ko jeꞌe na̱ kuaxi juanoa na̱ ndo. ");
INSERT INTO pps_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Ko hora kuachrje chujni ste ntiꞌa, ndo Jesús kuixinꞌin ndo ko itsé ndo itjáa xjanchrichjan tsikenꞌen ko jeꞌe xjan xechón xjan ko tuinxin bingatjen xjan. ");
INSERT INTO pps_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ko tsango ijié ixra̱ juincheꞌe ndo Jesús, nchijíi nunte meꞌe konoꞌe na̱. ");
INSERT INTO pps_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Tjumeꞌe sajuixin ndo Jesús ntiꞌa ko yuu chujni tikonꞌa jiruéꞌe na̱ ndo, ko jaꞌin stetoyako na̱: ―Tikonóaꞌnananta, jaꞌanta ti tsikachrjexinnta ndo David. ");
INSERT INTO pps_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Ko kuixinꞌin ndo Jesús naa nchia, tjumeꞌe konchjiñeꞌe ni tikonꞌa, ko ndo Jesús juanchangiꞌe ndo na̱ ko ndachro ndo: ―¿Á titikaonnta ixi janꞌan nduaxin sintaxruanꞌannta? Ko jeꞌe na̱ juatingíexin na̱: ―Jaán, Nchána̱na, janꞌanna chuntiana ngajinnta. ");
INSERT INTO pps_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Tjumeꞌe ndo Jesús bakeꞌe ndo itjáa ndo ngataꞌa ikon na̱ ko ndachro ndo: ―Jaꞌanta tsoxruanꞌannta ixi chuntianta ngajin. ");
INSERT INTO pps_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Ko tuinxin ó chao bikon na̱. Ko ndo Jesús kuetuanꞌan ndo: ―Xroꞌan ngisen tekiꞌénta jiꞌin. ");
INSERT INTO pps_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Ko jeꞌe na̱ kuachrjexón na̱ ntiꞌa, tuinxin bekiꞌena kain chujni kuetan na̱ ko nchijíi nunte meꞌe konoꞌe na̱ ngeꞌe jian juincheꞌe ndo Jesús. ");
INSERT INTO pps_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Ko hora sakjui ni bakikonꞌa, kaxin chujni bikaꞌo na̱ naa xi nosin ko chónda xa espíritue Xixronꞌanxrée. ");
INSERT INTO pps_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Ko hora kuantsje ndo espíritue Xixronꞌanxrée, xi nosin chao kuaxi nichja xa. Ko kain chujni ste ntiꞌa xronka na̱ ixi kain ngeꞌe tsango ijié konꞌen ntiꞌa ko ndachro na̱: ―Xroꞌan ngeꞌe tsango ijié bakonꞌen nchijíi nunte Israel xranchi ti konꞌen jai. ");
INSERT INTO pps_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","*Ko ni fariseo stendachro na̱: ―Xi jiꞌi tantsje xa espíritue Xixronꞌanxrée ixi Xixronꞌanxrée tsikajon xa juachaxin ngajin xi jiꞌin. ");
INSERT INTO pps_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","*Ndo Jesús kuaji ndo itsjé tjajna, tjajna ijié ko tjajna nchínchín banchekuenꞌen ndo chujni Israel ngaxinꞌin ningue na̱, ko chronga ndo ti juachaxin jian bikaoxin ndo ti tetuanꞌan ndo Dio. Ko juinchexruenꞌen ndo kain chujni kuachónda ichin ko kain ti tiín na̱. ");
INSERT INTO pps_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","*Ko bikon ndo ixi itsjé chujni kuiji ntiꞌa, ko tsango bikonóeꞌe ndo na̱ ixi ichrji na̱ xranchi kutuchjon chóndaꞌi ngisen tsjeꞌe ba. ");
INSERT INTO pps_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","*Tjumeꞌe ndache ndo sen teyuu chrikao ndo: ―Tsango itsjé ngeꞌe jii tsandáani, ko kueyaꞌi sen ncheꞌe ixra̱ jiꞌi. ");
INSERT INTO pps_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Méxin tjancheꞌenta nchée nunte jiꞌi xroxruanꞌan ndo itsjé sen nchexra̱, sen tsandáa. ");
INSERT INTO pps_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Ndo Jesús kuiyeꞌe ndo sen teyuu chrikao ndo ko chjée ndo sen ijié juachaxin ixi tsantsje sen espíritue Xixronꞌanxrée jitetuenꞌen aséen chujni ko sinchexrjuenꞌen sen kain ichin chónda chujni ko kain ti tiín na̱. ");
INSERT INTO pps_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Jaꞌin kuinꞌin ti teyuu sen kuincheꞌe ndo Jesús, sen ruéꞌe ndo: saꞌó ndo Simón, ndo juinchekinꞌin sen Pedro, ko ndo kichuu ndo, ndo Andrés, kao ndo Jacobo ko ndo kichuu ndo ndatinꞌin Juan, chjenꞌen ndo Zebedeo. ");
INSERT INTO pps_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Ko ndo Felipe, ndo Bartolomé, ndo Tomás, ndo Mateo, ndo kuaxengeꞌe ꞌna̱ ti bajanchia xi tetuanꞌan, ko ndo Jacobo, chjenꞌen ndo Alfeo, ko ndo Lebeo, ndo tsikakeꞌe na̱ Tadeo. ");
INSERT INTO pps_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Kaxon ndo Simón, ndo baruéꞌe ni cananista, ko xi Judas Iscariote, xi juinchekji ndo Jesús. ");
INSERT INTO pps_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Ndo Jesús xruanꞌan ndo sen teyuu ko jaꞌin ndache ndo sen: ―Tjiꞌanta ngajin chujni jeꞌa judío ko tixinꞌanta tjajna Samaria. ");
INSERT INTO pps_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Jaꞌanta itjinta ngajin chujni bingachrue xranchi kutuchjon, sen tikinixinꞌen tjajna Israel. ");
INSERT INTO pps_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Itjinta ko nchekuenꞌennta chujni ko jaꞌin nichjeꞌenta na̱: “Juachaxien ndo Dio jii ngajní ó tuinxin tsi̱i̱.” ");
INSERT INTO pps_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Sinchexruenꞌennta chujni niꞌe ko ni chónda ichin lepra ko nchengatjennta ni tsikenꞌen, tantsjenta espíritue Xixronꞌanxrée ko ti juachaxin kuitoꞌannta kaxon nchiki̱tonꞌennta chujni. ");
INSERT INTO pps_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","’Tikuꞌinta tomi chika oro, plata o̱ cobre, ");
INSERT INTO pps_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","*ko nchakon tsaanta chaꞌo tikuꞌinta ngeꞌe sintenta, ko ngeꞌe taritsíinta, tikuꞌinta kaxon inaa kate xrochjanganta, ko tikuꞌinta ntakuto ixi sen ncheꞌe ixra̱ tikinixin tsayéꞌe sen ti sine sen. ");
INSERT INTO pps_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","’Nchakon tsjasonta naa tjajna ijié o̱ naa tjajna nchíín, tjéenta naa ngisen ncheꞌe jian ko ntiꞌa tituanꞌanta ndoꞌa sen ti satsjixinjanta ntiꞌa. ");
INSERT INTO pps_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Hora tsixinꞌinnta naa ndoꞌa sen, jaꞌin tájonnta juajna: “Juaxruxin xrochónda ngisen jii nchia jiꞌi.” ");
INSERT INTO pps_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Ko sen ndoꞌa siá nduaxin jian aséen sen tsayéꞌe sen juaxruxin, ko siá naꞌi, satikuꞌunta juaxruxin meꞌe. ");
INSERT INTO pps_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","*Ko siá xrojan ngisen chroꞌa tsituꞌanta ndoꞌa sen ko chroꞌa sen tsinꞌen sen ngeꞌe nichjanta, tachrjexinnta tjajna o̱ nchia meꞌe ko tontsjenganta tutáanta, jaña tsintji inche ixi jaña tsjakoxinnta ixi jeꞌe na̱ chroꞌa na̱ kuayéꞌe na̱ ngeꞌe ichronta. ");
INSERT INTO pps_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","*Ko nduaxin ndachrja̱n ixi nchakon tsoña̱ ijie̱ ti tsjexinja kain ngeꞌe, ni tjajna Sodoma ko Gomorra tantoꞌa tangi tsonꞌen na̱ xranchi ni tjajna tjaunꞌa na̱ kuinꞌen na̱ ti ndachronta. ");
INSERT INTO pps_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","*’Jai janꞌan xroxruanꞌannta xranchi kutuchjon ngakjenꞌen kundanixra. Méxin jaiko ko jian tsjeꞌenta xranchi kunchee ko kaxon ncheꞌenta xranchi kuntúá, nchejiéꞌa asáanta. ");
INSERT INTO pps_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","*Jian tsjeꞌenta ixi kaxin chujni xrotsénta na̱ ko tsikuꞌunta na̱ ngajin ni tetuanꞌan, ko ngaxinꞌin ningue na̱, ntiꞌa tsikaonxinnta. ");
INSERT INTO pps_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Ko tsikaannta na̱ ngajin xi tetuanꞌan ko ngajin xi rey ixi chuntianta ngaji̱n. Ko ntiꞌa xronichjanta ixi titikaonninta, tsinꞌen ni meꞌe ko tsinꞌen kaxon ni chúxinꞌa ndo Dio. ");
INSERT INTO pps_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Ko nchakon tsikaannta na̱ ti ste xi tetuanꞌan, taꞌinta juachjaon ixi ngeꞌe xrondachronta o̱ ngeꞌe xronichjanta ixi hora meꞌe ndo Dio tsajon ndo ngeꞌe xronichjanta, ");
INSERT INTO pps_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","ixi jeꞌa jaꞌanta xronichjanta; Espíritue Ndotánta xronichjaxin ixi jaꞌanta. ");
INSERT INTO pps_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","*’Chujni kichuu tsajon na̱ juachaxin ixi tsenꞌen ni kichuu na̱ ko ndotata tsajon ndo chjenꞌen ndo ixi tsóña na̱ xjan. Ko ichjan xraningakonꞌen xjan sen ndoꞌa xjan ko tsajon xjan sen ixi tsenꞌen sen. ");
INSERT INTO pps_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","*Ko kaxon itsjé chujni xroningakonꞌannta ixi chuntianinta. Ko kain sen tsokuaxiꞌen kain jiꞌi ti tsjexinja kain ngeꞌe jii ngataꞌa xasintajni, sen meꞌe tsayéꞌe sen juachaxin tsechón sen kain nchakon. ");
INSERT INTO pps_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Ko nchakon tsengixinnta na̱ tjajna jiꞌi, satinganta inaa tjajna. Ko nduaxin xrontatjunta xratsjexinꞌa satsjinta ngujngu tjajna tikinixinꞌen Israel, Chjenꞌen ndo Dio, xjan jongíꞌe xranchi chujni, xrokjan xjan tsi̱i̱ xjan ntiꞌi. ");
INSERT INTO pps_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","*’Naa ndo tjako ícha tjintee ndo ixi sen nchekuenꞌen ndo, ko kaxon sen chónda ni nchexra̱, ícha tetuanꞌan jeꞌe sen ixi ni nchexrée sen. ");
INSERT INTO pps_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","*Ko ngisen jitangi xroxraxaon sen ixi jeꞌo tjintee sen xranchi ndo nchekuenꞌen sen, ko ni nchexra̱ xroxraxaon na̱ ixi jeꞌo tsituanꞌan na̱ xranchi nchée na̱. Ixi siá ndotata juinchekinꞌin na̱ ndo Xixronꞌanxrée, sen ruéꞌe ndo ícha jaiko sinchekinꞌin na̱ sen jaña. ");
INSERT INTO pps_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","*’Jaꞌanta xroꞌan ngisen xrakonꞌenta, ixi kain ti jixratja xrokonda tsonoxin, ko kain ti jimá xrokonda tsonoꞌeni ngeꞌe meꞌe. ");
INSERT INTO pps_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Ko siá xrontatjunta xrojan ngeꞌe imao, jaꞌanta séen nichjanta tsinꞌen kain chujni. Ko siá tsekiꞌanta naa ngeꞌe ngaya ndatsjonnta, jaꞌanta séen tekiꞌénta chujni. ");
INSERT INTO pps_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Xrakuenꞌanta chujni tsóña ntauꞌeni ixi ni meꞌe juaꞌi tsóña na̱ aséenni. Jaꞌanta xroxrakonꞌennta ngisen chao xroxruanꞌan asáanta ko ntauꞌanta ti jiche xroꞌi. ");
INSERT INTO pps_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","’¿Á tuchji̱ꞌa yuu kuxechjan ixi naa tomi nchíín? Ko maski tjinteꞌa ba, ninaa ba tenꞌa ba siá Ndotánta Dio tsajonꞌa Ndo juachaxin. ");
INSERT INTO pps_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Ko kaxon ndo Dio noꞌe ndo ngijanꞌin xrajaanta chondanta. ");
INSERT INTO pps_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Méxin, jaꞌanta xrakonꞌanta ixi jaꞌanta ícha tjinteenta ixi kain kuxe. ");
INSERT INTO pps_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","’Ko siá jaꞌanta xrondachronta ixi titikaonninta tsinꞌen chujni, kaxon janꞌan xrontatjan Ndotána jii ngajní ixi nduaxin meꞌe. ");
INSERT INTO pps_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","*Ko ngisen xrondache chujni ixi janꞌan chuxinꞌana sen, janꞌan kaxon xrontatjan Ndotána jii ngajní ixi janꞌan chuxinꞌa sen. ");
INSERT INTO pps_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","’Xraxaonꞌanta ixi janꞌan bikian juaxruxin ngataꞌa nunte xasintajni. Naꞌi. Janꞌan bikian ti tse̱ꞌto̱ na̱. ");
INSERT INTO pps_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Kondanaxin janꞌan tsinteke̱ꞌto̱ chujni; xi tse̱ꞌto̱ xa ngajin ndotée xa, ko nchrichajan tse̱ꞌto̱ nchrichan ngajin janée nchrichan, nchritakinda tse̱ꞌto̱ nchra ngajin jachée nchra. ");
INSERT INTO pps_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Ko sen kichuunta, sen meꞌe ícha xroningakonꞌannta sen. ");
INSERT INTO pps_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","’Ko ngisen ícha tjueꞌe ndotée o̱ janée, kaxon sen tjueꞌe ícha xitsiꞌe o̱ nchrichjeꞌen sen, sen meꞌe tikinixienꞌa sen xroruaꞌna sen. ");
INSERT INTO pps_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","*Ko ngisen tsamaꞌi nta̱cru, ko xroruanaꞌi sen, sen meꞌe tikinixienꞌa sen tsinꞌin sen chujnina. ");
INSERT INTO pps_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","*Ngisen tjaunꞌa tsenꞌen, sen meꞌe tsenꞌen sen, ko ngisen tsenꞌen ixi janꞌan, ngajin sen meꞌe janꞌan tsajon juachaxin tsechón sen kain nchakon. ");
INSERT INTO pps_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","*’Ko nchakon xrojan ngisen xrondachro ixi chao tsatsinganta ngaxinꞌin ndoꞌa sen, sen meꞌe xranchi xrokuayéꞌe sen najanꞌan, ko siá janꞌan tsayéꞌena sen kaxon Ndotána Dio, ndo xruanꞌanna, tsayéꞌe ndo sen. ");
INSERT INTO pps_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Ngisen tsayéꞌe ngaxinꞌin ndoꞌa naa sen nichja chijnie ndo Dio, sen meꞌe tsayéꞌe sen naa ngeꞌe tsango jian jii ngajní xranchi ti tsayéꞌe sen nichja chijnie ndo Dio. Ko ngisen tsayéꞌe naa chujni jian, chujni ndako ncheꞌe, sen meꞌe kaxon tsayéꞌe sen naa ngeꞌe jian jii ngajní xranchi ti tsayéꞌe sen jian ko ndako ncheꞌe. ");
INSERT INTO pps_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ko ngisen tsajon nchíín ndakin tsiꞌi naa chujni titikaonna, janꞌan xrotjáꞌa sen meꞌe naa ngeꞌe tsango tjintee tsayéꞌe sen. ");
INSERT INTO pps_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Ndo Jesús juexin ndache ndo sen teyuu chrikao ndo ngeꞌe sincheꞌe sen, tjumeꞌe sakjui ndo kaxin tjajna bijako ndo chijnie ndo Dio, tjajna tikinixinꞌen Israel. ");
INSERT INTO pps_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Ndo Juan Bautista jijeꞌe̱ ndo ndoꞌachjiso, kuinꞌen ndo ixi ndo Cristo jinchexruenꞌen ndo chujni ko jincheꞌe ndo kaxin ixra̱ ícha ijié, méxin ndo Juan xruanꞌan ndo yuu sen chrikao ndo ixi tsjanchangíꞌe sen ndo Jesús. ");
INSERT INTO pps_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Tjumeꞌe sakjui sen bijanchiangíꞌe sen ndo ko ndachro sen: ―¿Á suixinnta ngisen ti ndachro ndo Dio xroxruanꞌan ndo ngajinna o̱ xrochonꞌanna inaa sen? ");
INSERT INTO pps_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Ko jaꞌin juatingíexin ndo Jesús: ―Itjinta ko ndachenta ndo Juan ngeꞌe bikonta ko ngeꞌe kuinꞌennta. ");
INSERT INTO pps_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Tekiꞌénta ndo ixi sen tikonꞌa, ó tikon sen, sen ntarengo ó ichrji sen ko sen kuachónda ichin lepra ó koxruenꞌen sen, sen ntakuxro, tinꞌen sen; kaxon sen tsikenꞌen xechón sen ko sen nóa stetinꞌen sen chijnie ndo Dio. ");
INSERT INTO pps_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Ndo Dio sintanchaonnta ndo ti nduaxin ruaꞌnaninta ko tintunaꞌininta. ");
INSERT INTO pps_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Hora sakjui sen xruanꞌan ndo Juan, ndo Jesús kuaxi ndache ndo chujni ngisen ndo Juan ko ndachro ndo: ―¿Ngisen kuitsjeꞌenta ti jii ijna̱? ¿Á kuitsjeꞌenta naa xi jixratoꞌo xranchi naa ntatji tsijatoꞌo chrinto? ");
INSERT INTO pps_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Siá naꞌi, ¿ngeꞌe kuitsjeꞌenta? ¿Á bikonta naa xi jitsáa jeoxón manta tjintee? Xraxaonnta ixi chujni stetsáa manta tjintee, ni meꞌe jeꞌo ste na̱ nchiandoꞌa xi rey. ");
INSERT INTO pps_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","¿Ngisen kuitsjeꞌenta tjumeꞌe? ¿Á bikonta naa xi jichrónga chijnie ndo Dio? Jaán nduaxin, ko janꞌan ntatjunta ixi ndo Juan ícha tjintee ndo ixi sen kuachronga chijnie ndo Dio ó saꞌó. ");
INSERT INTO pps_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Jiꞌi ndo xroxruanꞌan ndo Dio xranchi jichrónga xroon chijnie ndo ó saꞌó: Janꞌan xroxruanꞌan naa ngisen tsitaon ntiꞌa tsikao sen chijnina, ko sinchenataonxin sen chaꞌo. ");
INSERT INTO pps_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Ko janꞌan nduaxin ndachrja̱n ixi kain sen jongíꞌe ko bakeꞌe ngataon nunte ntiꞌi, ni naa sen tjinteꞌa sen xranchi tjintee ndo Juan tikitée chujni. Ko naa sen ícha tjinteꞌa jii ti tetuanꞌan ndo Dio, sen meꞌe ícha tetuanꞌan sen ixi ndo Juan. ");
INSERT INTO pps_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","*’Nchakon kuaxi nichja ndo Juan Bautista chijnie ndo Dio, nchakon meꞌe ko ti jai, tsango tangi stetayéꞌe sen chijnie ndo Dio ko ti tetuanꞌan ndo, ko jeꞌo sen xronkaꞌi, sen meꞌe tsjacha tsayéꞌe juachaxien ndo Dio. ");
INSERT INTO pps_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Itsjé sen kuanichja chijnie ndo Dio ko kaxon chijni tsiketuanꞌan ndo Moisés ndachro kain ti xrokonꞌen ti xrokui̱i̱ja ndo Juan. ");
INSERT INTO pps_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","*¿Á tsitikaonnta o̱ naꞌi?, ixi nchakon tsindachro ndo Dio ixi xroxruanꞌan ndo ndo Elías, jiꞌi jinichja ixi ndo Juan tikitée chujni. ");
INSERT INTO pps_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Ko ngisen chónda ndatsjon, sen meꞌe chao tsinꞌen sen jiꞌi. ");
INSERT INTO pps_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","’¿Xranchi tsjakoꞌanta ti ncheꞌe chujni jichón jai? Ncheꞌe na̱ xranchi ncheꞌe kaxin ichjan stesondaon ti jii ntaasin, ko jaꞌin stetoyako xjan: ");
INSERT INTO pps_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“Kuanoana ntaxro ko jaꞌanta téꞌanta. Itsje̱na sóen chujni tsikenꞌen ko jaꞌanta tsjangaꞌinta.” ");
INSERT INTO pps_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Ixi kui̱i̱ ndo Juan juineꞌa ndo ko kuiꞌa ndo ixi juinchekatse ñao ndo jinta, ko jaꞌanta ndachronta ixi espíritue Xixronꞌanxrée chónda ndo. ");
INSERT INTO pps_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Ko juiꞌi janꞌan, Chjenꞌen ndo Dio, xjan jongíꞌe xranchi chujni, juiné ko kuiꞌi, ko ndachronta ixi tsango itsjé iné ko tsango yee tiꞌi ko tjento ni tjáka tomie xi tetuanꞌan ko ni ndakoꞌa ncheꞌe. Ko jian xraxaonnta ixi ti ixra̱ jian tonꞌen meꞌe tjako ixi ndo Dio tsango noꞌe ndo. ");
INSERT INTO pps_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Tjumeꞌe ndo Jesús kuaxi kuyakutee ndo chujni ste ntiꞌa ixi tjajna meꞌe juinchexruenꞌen ndo kueya chujni ko ikaxin ixra̱ ijié juincheꞌe ndo ko chujni meꞌe kuitikaonꞌa na̱ ko kuindoxinꞌa na̱ ti ndakoꞌa kuancheꞌe na̱. ");
INSERT INTO pps_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Tjumeꞌe ndachro ndo: ―¡Jaꞌanta ti stenta tjajna Corazín ko jaꞌanta ti stenta tjajna Betsaida, tsango tangi tsonꞌannta!, ixi siá xrokoxruenꞌen kain ni niꞌe ko xrokonꞌen kain ti jian ngajin tjajna Tiro ko tjajna Sidón xranchi ti konꞌen ntiꞌi, jeꞌe ni meꞌe xrokuindoxin na̱ ti ndakoꞌa kuancheꞌe na̱ ko xrokuitsáa na̱ manta tiie ko xrokuintjítee na̱ ntesokiꞌi jaa na̱ ixi jaña xrojuako na̱ nduaxin tjaun na̱ ísincheꞌa na̱ ti ndakoꞌa. ");
INSERT INTO pps_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Méxin nduaxin xrontatjunta ixi nchakon tsoña̱ ijie̱, ni tjajna Tiro ko ni tjajna Sidón, ícha tangiꞌa tsonꞌen na̱ xranchi jaꞌanta. ");
INSERT INTO pps_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Ko jaꞌanta chujni tjajna Capernaum, á xraxaonnta ixi ti jii ngajní tsajíinnta. Naꞌi, jaꞌanta xroxingajinnta ti ste ni tsikenꞌen, ixi siá tjajna Sodoma xrokoxruenꞌen chujni ko xrokonꞌen kain ti ixra̱ ijié konꞌen ngajin tjajnánta, tjajna meꞌe xraxrobakeꞌe tjajna ngataꞌa nunte jai. ");
INSERT INTO pps_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","*Méxin nchakon tsjexin kain ngeꞌe, ndo Dio sinchéña ndo ijie̱ ko ícha tangi tsonꞌannta jaꞌanta ixi chujni tjajna Sodoma. ");
INSERT INTO pps_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Hora meꞌe ndo Jesús nichja ndo ngajin Ndotée ndo ko jaꞌin ndachro ndo: ―Ndotána, tjáꞌanta juasiana, Nchée ngajní ko nunte xasintajni, ixi jaꞌanta kueméꞌenta chujni tsango noꞌe ko ni tsango tsikangi xroon, ko juinchekueꞌennta kain jiꞌi ngajin sen nchejiéꞌa aséen. ");
INSERT INTO pps_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ndotána, jaña konꞌen ixi jaꞌanta jaña fiaonnta. ");
INSERT INTO pps_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","*Ko ndache ndo ni ste ntiꞌa: ―Kain ngeꞌe chjána Ndotána ko jeꞌo jeꞌe ndo chuxinna ndo janꞌan, Chjenꞌen ndo, ko kaxon xroꞌan ngisen chúxin jeꞌe ndo, jeꞌo Chjenꞌen ndo, ko janꞌan, Chjenꞌen ndo, nichjaꞌa chujni ixi jaña jeꞌe na̱ tsichuxin na̱ Ndotána. ");
INSERT INTO pps_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Jaꞌanta ti richondanta juachjaon ko konchrjenta, Xrokuiinta ngajin janꞌan ko janꞌan tsajon juaxruxin tsjokaꞌanta. ");
INSERT INTO pps_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Titikaonnta ti ndachrja̱n ko toñaoꞌanta ko nchejiéꞌa asáanta xranchi janꞌan ntajiéꞌa aséenna, meꞌe jaña chao juaxruxin tsinteenta. ");
INSERT INTO pps_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Ko ti ndachrja̱n sincheꞌenta tangiꞌa ko ixra̱ tajon sincheꞌenta, ixra̱ meꞌe tangiꞌa xra̱. ");
INSERT INTO pps_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Naa nchakon tjokéꞌe sen judío, ndo Jesús ko sen teyuu chrikao ndo kuatsinga sen ti jii naa nunte tsikinga noatrigo; sen teyuu chrikao ndo kuenꞌen sen jinta, méxin kuaxi sen kuantsjengí sen trigo ko juine sen noa. ");
INSERT INTO pps_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Ko ni fariseo bikon na̱ ngeꞌe stencheꞌe sen teyuu chrikao ndo Jesús ko ndachro na̱: ―¿Á ritsjeꞌe ngeꞌe stencheꞌe ni chrjikoꞌa ixi jai nchakon tjokéꞌeni?, juaꞌi sincheꞌe ni jaña. ");
INSERT INTO pps_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Ko jeꞌe ndo juatingíexin ndo: ―¿Á noaꞌinta ngeꞌe jitaxin xroon ti juincheꞌe ndo rey David ko sen chrikao ndo, hora kuenꞌen sen jinta? ");
INSERT INTO pps_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Kuixinꞌin sen ndoꞌa ndo Dio ko juine sen nutja tikinixinꞌen ndo, ko jeꞌe ndo David ko sen ruéꞌe ndo, jeꞌe sen tikinixinꞌa sen xrojuine sen nutja meꞌe; jeꞌo sen taana. ");
INSERT INTO pps_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Kaxon, ¿á bikonꞌanta xroon tsikjin ndo Moisés ti ndachro ixi ndotaana chao ncheꞌe ndo ixra̱ ngaxinꞌin niꞌngo nchakon tjokéꞌeni ko xroꞌan ijie̱ kuama ndotaana? ");
INSERT INTO pps_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ko nduaxin xrontatjunta ixi ngisen jinichjaꞌanta jai ícha tetuanꞌan ixi niꞌngo. ");
INSERT INTO pps_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","*Ko jaꞌanta tienxinꞌanta ti ndachro xroon chijnie ndo Dio: “Janꞌan ndo Dio tjaunꞌa tsonꞌinta iko ko tsjaakanta jnié ba tsayáꞌa̱ janꞌan. Janꞌan tjaꞌon tsingijnanta ko xrotjueꞌe kichuunta”, siá xrokuienxinnta chijni jiꞌi, xrojuankataꞌinta ijie̱ ngataꞌa chujni xroꞌan ngeꞌe sínká. ");
INSERT INTO pps_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Ko Chjenꞌen ndo Dio, xjan jongíꞌe xranchi chujni, chónda xjan ijié juachaxin ngataꞌa nchakon tjokéꞌeni ―ichro ndo Jesús. ");
INSERT INTO pps_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Ndo Jesús sakjuixin ndo ntiꞌa ko tjumeꞌe kuixinꞌin ndo naa ningue ni judío. ");
INSERT INTO pps_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Ko ntiꞌa jii naa xi tsixema naa itja ko ntiꞌa kaxon ste kaxin xi fariseo ko tjaun xa tsjankataꞌa xa ijie̱ ngajin ndo Jesús, méxin juanchangiꞌe xa ndo: ―¿Á chao tsoxruenꞌen naa sen niꞌe nchakon tjokéꞌeni? ");
INSERT INTO pps_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","*Ko ndo Jesús ndachro ndo: ―¿Á xrojan jaꞌanta chondanta naa kutuchjon ko iko meꞌe xrokuitsingaya ba naa tuye nchakon tjokéꞌeni, á xrokjuiꞌanta ko xrokuantsjenta ba? ");
INSERT INTO pps_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Naa chujni ícha tjintee ixi naa kutuchjon. Méxin, chao sincheꞌeni ti jian maski nchakon tjokéꞌeni. ");
INSERT INTO pps_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Tjumeꞌe ndache ndo xi niꞌe: ―Tinxe tjáa. Ko jeꞌe xa kuinxe itja xa ko itja xi meꞌe tuinxin koxruenꞌen. ");
INSERT INTO pps_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Tjumeꞌe xi fariseo kuachrjexin xa niꞌngo ko stetoñao xa ko stexraxaon xa xranchi sincheꞌe xa ixi tsóña xa ndo Jesús. ");
INSERT INTO pps_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Ndo Jesús konoꞌe ndo ixi ngeꞌe stexraxaon xi fariseo, meꞌe sakjuixin ndo ntiꞌa ko kueya chujni ruéꞌe ndo ko juinchexruenꞌen ndo kain chujni niꞌe, ");
INSERT INTO pps_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","ko kuetuenꞌen ndo chujni ruéꞌe ndo ixi xrochrongaꞌi na̱ ngisen jeꞌe ndo. ");
INSERT INTO pps_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Jaꞌin konꞌen ixi ó sée tsichronga ndo Isaías chijnie ndo Dio: ");
INSERT INTO pps_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Ndo kuinchaꞌa, ntiꞌi jii ndo ngajinnta, ndo sincheꞌe ixra̱ ngaji̱n, janꞌan tsango tjuaꞌa ndo ko jeꞌe ndo tsango nchexruxinꞌen ndo aséenna, ko janꞌan tsakée espírituna ngataꞌa ndo ixi jeꞌe ndo xrochronga ndo chijnina ngajin kain tjajna jii ngataꞌa nunte xasintajni, ko chijnina meꞌe tsóñaxin ijie̱ ngataꞌa kain chujni tsitikaonꞌana. ");
INSERT INTO pps_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Tsjakaxinꞌa ndo ko xroꞌan ngisen tsuyakuꞌe ndo, méxin tsienꞌa na̱ tée ndo ngaya chaꞌo. ");
INSERT INTO pps_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Ko ísincheníeꞌa ndo sen ó tsikoniꞌe, ko juaꞌi naatsóñaxón ndo sen ó jiteꞌen. Naꞌi. Jeꞌe ndo sinchesoji ndo aséen sen sojiꞌa ko jeꞌe ndo sincheꞌe ndo ixra̱ tsija nchakon jeꞌe ndo sinchéña ndo ijie̱. ");
INSERT INTO pps_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Ko kain chujni nunte xasintajni xrochuntia na̱ ngajin ndo. Jaña tsichronga ndo Dio ó seno. ");
INSERT INTO pps_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Kaxin chujni bikaꞌo na̱ naa xi niꞌe ixi ndo Jesús sinchexrjuenꞌen ndo xa. Xi meꞌe tikonꞌa xa ko nichjaꞌi xa ixi chónda xa espíritue Xixronꞌanxrée. Ko ndo Jesús juinchexruenꞌen ndo xa ko tuinxin nichja xa ko bikon xa. ");
INSERT INTO pps_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Ko kain chujni ste ntiꞌa xronka na̱ ko tjanchangíꞌe kichuu na̱: ―¿Á jeꞌa jiꞌi ndo Jesús, ndo xroxruanꞌan ndo Dio tsikachrjenixin ndo David? ");
INSERT INTO pps_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","*Ko kuinꞌen xi fariseo ixi jaña stenichja na̱, méxin ndachro xa: ―Xi Jesús jiꞌi tantsje xa espíritu ñaꞌi ixi chónda xa juachaxien Xixronꞌanxrée, xi tsango ñaꞌi, xi tetuenꞌen kain espíritu meꞌe. ");
INSERT INTO pps_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Ko jeꞌe ndo noꞌe ndo ngeꞌe stexraxaon xa, meꞌe ndachro ndo: ―Xroꞌan nación jii, ixi jeꞌo na̱ tsinteke̱to̱kaꞌo kichuu na̱, ko siá jaña sincheꞌe na̱, nación meꞌe tsjexin. Ko naa tjajna ti tinteke̱to̱kaꞌo kichuu na̱, kaxon tuinxin ni meꞌe xrochjekeꞌe na̱ ko tjajna meꞌe tsitjáña tjajna. Kaxon naa ndo tata ko chjenꞌen ndo, siá jeꞌo sen tsinteke̱to̱kaꞌo kichuu sen, sen nchia meꞌe xrochjekeꞌe sen ko tsitjáña sen. ");
INSERT INTO pps_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ko siá Xixronꞌanxrée jeꞌo xa tsantsje xa naa espíritu tikinixinꞌen xa jixinꞌin ngaxinꞌin naa chujni, jeꞌo xa tsonchjejin xa ti tituanꞌan xa. ");
INSERT INTO pps_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Ko jaꞌanta ndachronta ixi janꞌan tantsje espíritu tikinixinꞌen Xixronꞌanxrée ixi jeꞌe xa chjána xa juachaxin. Siá nduaxin meꞌe, ¿ngisen tajon juachaxin ngajin ni ruaꞌanta ixi jeꞌe na̱ tantsje na̱ kaxon espíritue Xixronꞌanxrée? Ni ruaꞌanta meꞌe tjakoxin na̱ ixi jaꞌanta noaꞌinta ngeꞌe nichjanta. ");
INSERT INTO pps_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Ko siá janꞌan ixi espíritue ndo Dio tantsjexin espíritu tikinixinꞌen Xixronꞌanxrée chónda chujni, meꞌe xrondachro ixi juachaxien ndo Dio ó kui̱i̱ ti ste jaꞌanta. ");
INSERT INTO pps_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","’Xranchi xrojan chujni te̱e tjaun tixinꞌin ndoꞌa naa xi tsango soji ko tjaun tse̱e ngeꞌe jii ndoꞌa xi meꞌe, ¿á jeꞌa saꞌó xrokonda tsitee xi ndoꞌa ko tjumeꞌe tsantsje kain ngeꞌe jii ngaxinꞌin ndoꞌa xa? ");
INSERT INTO pps_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","*’Ngisen titikaonꞌa najanꞌan, sen meꞌe ningakonna sen, ko ngisen tingijnaꞌi ixra̱ ntaꞌa, sen meꞌe tingakonꞌen sen. ");
INSERT INTO pps_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Méxin janꞌan ntatjunta chao tsoméꞌe kain ti ndakoꞌa ko ti nichjangí chujni ngajin ndo Dio. Ko ngisen xronichjangíꞌe Espíritue ndo Dio, sen meꞌe juaꞌi tsoméꞌe ti ndakoꞌa nichja sen. ");
INSERT INTO pps_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","*Ko siá xrojan ngisen xronichjangíꞌe Chjenꞌen ndo Dio, xjan jongíꞌe xranchi chujni, tsoméꞌe kain ti nichjangí na̱ ko ti ndakoꞌa juincheꞌe na̱. Ko ngisen xronichjangíꞌe Espíritue ndo Dio, naiꞌa tsoméꞌe ti ndakoꞌa nichja na̱. ");
INSERT INTO pps_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","*’Naa nta̱a̱ jian tajon nta̱a̱ itu jian ko naa nta̱a̱ xroꞌan xrée kaxon xroꞌan xrée tu tajon nta̱a̱. Méxin, naa nta̱a̱ tajon itu, itu tsichuxixinni nta̱a̱. ");
INSERT INTO pps_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","*Jaꞌanta tsikachrjenixinnta kunchee, ¿méxin, xranchi xronichjanta ti jian siá jaꞌanta jeꞌa jiannta? Ixi chujni jian, nichja ti jian ko chujni ndakoꞌa ncheꞌe, nichja ti ndakoꞌa. Ixi ti nichja roꞌani meꞌe ti̱ꞌxi̱n aséenni. ");
INSERT INTO pps_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Naa chujni jian nichja ngeꞌe ti jian ixi jian aséen. Ko chujni jianꞌi, ti ndakoꞌa nichja na̱, ixi ti ndakoꞌa jiá aséen na̱. ");
INSERT INTO pps_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Ko janꞌan ntatjunta ixi tsi̱i̱ nchakon tsjexin kain ngeꞌe, nchakon meꞌe sinchéña ndo Dio ijie̱ ngajin chujni tsinichja ngeꞌe ndakoꞌa. ");
INSERT INTO pps_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Ndo Dio sinchéña ndo ijie̱ ngajin ngujngu chujni, ngisen tsinichja jian, sen meꞌe tsoméꞌe ti ndakoꞌa juincheꞌe sen ko sen ndakoꞌa tsinichja, sen meꞌe tangi tsonꞌen sen. ");
INSERT INTO pps_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","*Tjumeꞌe kaxin xi fariseo ko ni tjako chijnie ndo Dio ndache na̱ ndo Jesús: ―Jaꞌanta ti tjakonta, tjaꞌonna tsjakoꞌnaninta naa ngeꞌe xrochronga á nduaxin ndo Dio xruanꞌannta. ");
INSERT INTO pps_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","*Ko jeꞌe ndo Jesús juatingíexin ndo: ―Jaꞌanta chujni ñaꞌi, ti chuntiaꞌinta ngajin ndo Dio, tjanchianta tsjáko naa ngeꞌe xrochronga á nduaxin ndo Dio xruanꞌanna ndo, ko janꞌan jeꞌo xrontatjunta ngeꞌe konꞌen ndo Jonás, ndo kuachronga chijnie ndo Dio ó saꞌó. ");
INSERT INTO pps_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Ndo Jonás bakeꞌe ndo ngaya tse̱ꞌe̱ naa kuballena níi nchakon ko níi tiie, jaña kaxon Chjenꞌen ndo Dio, xjan jongíꞌe xranchi chujni, xrokonda xroxrabaa xjan níi nchakon ko níi tiie. ");
INSERT INTO pps_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Nchakon tsjexin kain ngeꞌe ko tsoña̱ ijie̱, ni tjajna Nínive tsingatjen na̱ ko tsjangiꞌanta na̱ ko ndo Dio tsjankataꞌanta ndo ijie̱, ixi ni meꞌe, ni tjajna Nínive, tuinxin kuindoxin na̱ ti ndakoꞌa kuancheꞌe na̱ nchakon kuinꞌen na̱ chijnie ndo Dio tsichronga ndo Jonás. Ko jaꞌanta tinꞌennta chijnina ko tindoxinꞌanta ti ndakoꞌa ncheꞌenta ko janꞌan ícha tjinteena ixi ndo Jonás. ");
INSERT INTO pps_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Kaxon nchri reina tsiki̱ꞌxi̱n no Níjin, naa tjajna tsango ikjín, kui̱i̱ nchra kuinꞌen nchra chijni kuanichja ndo Salomón, nchri meꞌe tsjankataꞌanta nchra ijie̱ nchakon tsoña̱ ijie̱, ixi jaꞌanta titikaonꞌanta ti nichja maski janꞌan ícha tjinteena ixi ndo Salomón. ");
INSERT INTO pps_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","’Nchakon tachrjexin naa chujni naa espíritue Xixronꞌanxrée ko ichrji ti jii nunte xema ko titjaꞌi inaa chujni no tixinꞌin ixi tsjokéꞌe, meꞌe ndachro: ");
INSERT INTO pps_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","“Cháña xrokjanna nía ti kuachrjexin ko tsixinꞌin ntiꞌa íjngo.” Ko ti ikjan espíritu ñaꞌi nchia meꞌe, xroꞌan ngisen jixinꞌin nchia ko tjúá nchia. ");
INSERT INTO pps_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Tjumeꞌe itji espíritu ñaꞌi ko tikao íjngo ya̱a̱to̱ espíritu ncheꞌe ixra̱ ngajin Xixronꞌanxrée ícha ñaꞌi. Ko kain espíritu ñaꞌi tixinꞌin ngaxinꞌin chujni meꞌe, ko chujni meꞌe ícha chjinga tsonꞌen ixi ti nchakon kuachónda naakua espíritu ñaꞌi. Jaña tsonꞌen kain chujni ndakoꞌa ncheꞌe jai. ");
INSERT INTO pps_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Ko ndo Jesús xrajinichja ndo ngajin chujni ste ntiꞌa, janée ndo ko sen kichuu ndo kuiji sen ti jii ndo ko stechónꞌen sen nduja ixi tjaun sen xronichjeꞌe sen ndo. ");
INSERT INTO pps_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Ko naa sen jii ntiꞌa ndache sen ndo Jesús: ―Janáanta ko sen kichuunta stechónꞌen sen nduja ixi tjaun sen xronichjaꞌanta sen. ");
INSERT INTO pps_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Ko jeꞌe ndo Jesús ndachro ndo: ―¿Ngisen nduaxin janána ko sen kichian? ");
INSERT INTO pps_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Tjumeꞌe juakoxin itja ndo ngajin sen teyuu chrikao ndo ko ndachro ndo: ―Sen jiꞌi meꞌe janána ko sen kichian, ");
INSERT INTO pps_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","ixi sen ncheꞌe ngeꞌe tjaun Ndotána jii ngajní, sen meꞌe janána ko sen kichian. ");
INSERT INTO pps_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Nchakon meꞌe ndo Jesús kuachrjexin ndo nchia jii ndo, tjumeꞌe sakjui ndo ngandeꞌe ndachaon ko ntiꞌa bakeꞌe ndo nunte ixi sinchekuenꞌen ndo chujni. ");
INSERT INTO pps_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","*Ko tsango kueya chujni konchjiñeꞌe ixi tjaun na̱ tsinꞌen na̱ ngeꞌe xronichja ndo. Méxin ndo Jesús kuajinꞌin ndo naa nta̱barco ko ntiꞌa bakeꞌe ndo nunte ko chujni kuiji na̱ ti jii nchese ngandeꞌe inda. ");
INSERT INTO pps_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Ko kueya chijni bekiꞌe ndo na̱ ixi jaña tsienxin chujni ngeꞌe xrondachro ti nichja ndo, Ko kuaxi beki ndo naa chijni ko ndachro ndo: ―Sakjui naa xi bikenga xa, ");
INSERT INTO pps_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","ko hora jitenga xa, kaxin noatrigo kuintjí noa ngatja chaꞌo ko kui̱i̱ kuxe juine ba noa. ");
INSERT INTO pps_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Ko kaxin noa kuintjí ngakjenꞌen ixro ti koꞌa itsjé inche, ko noa meꞌe tuinxin kuachrje no ixi tjínꞌa inche. ");
INSERT INTO pps_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Ko hora kuachrje chjiixro, katrigo meꞌe xeꞌnte ka ko xema ka ixi yasoeꞌa jii nueꞌe ka. ");
INSERT INTO pps_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Ko kaxin noa kuintjí ngakjenꞌen nta̱chaꞌa ko hora kuangi no, nta̱chaꞌa meꞌe kuintueꞌa nta̱cha kuangi no. ");
INSERT INTO pps_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Ko kaxin noa kuintjí noa ti jii inche jian, méxin tsango jian kóña noa. Ko kaxin katrigo kuachónda naa ciento noa, ko kaxin katrigo kuachónda níi ti ikán noa, ko kaxin katrigo kuachónda ikánte noa. ");
INSERT INTO pps_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Sen chao tinꞌen, xrokonda tsinꞌen sen jiꞌi. ");
INSERT INTO pps_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Tjumeꞌe sen teyuu chrikao ndo Jesús konchjiñeꞌe sen ngajin ndo ko juanchangiꞌe sen ndo: ―¿Sonda jeꞌo chijni tjakoexinnta chujni? ");
INSERT INTO pps_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Ko jeꞌe ndo Jesús jaꞌin juatingíexin ndo: ―Janꞌan bekiꞌanta kain chijni jimá kondee ti tetuanꞌan ndo Dio, ko ngajin ni kaxin xrontatjanꞌi na̱. ");
INSERT INTO pps_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","*Ngisen noꞌe ícha jian chijni neꞌe ndo Dio, ndo Dio ícha sinchekuenꞌen ndo sen. Ko ni tjaunꞌa tsienxin chijni ti tetuanꞌan ndo Dio, ndo Dio sincheméꞌe ndo ti nchion noꞌe na̱. ");
INSERT INTO pps_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Méxin janꞌan ntakuanꞌana ixi chijni, ixi ni tikon, juaꞌi tsichuxin na̱ ti tikon na̱, ko ni tinꞌen, ti tinꞌen na̱, tsienxinꞌa na̱. ");
INSERT INTO pps_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Jaña tsonꞌen ixi ngeꞌe tsichronga ndo Isaías, ndo kuanichja chijnie ndo Dio ó saꞌó: Chujni jiꞌin maski ícha tsinꞌen na̱, jeꞌe na̱ tsienxinꞌa na̱, ko maski stetsjeꞌe na̱, jeꞌe na̱ tsikonꞌa na̱. ");
INSERT INTO pps_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Ixi aséen chujni jiꞌi tsango tsikoncha ko ndatsjon na̱ jijeꞌe̱ ko stejeꞌe̱ ikon na̱ ixi jaña juaꞌi tsikon na̱ ko juaꞌi tsinꞌen na̱, méxin, juaꞌi sintamaꞌa ti ndakoꞌa ncheꞌe na̱ ko juaꞌi sintaxruanꞌan na̱. ");
INSERT INTO pps_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","*Tjumeꞌe ndachro ndo Jesús: ―Jaꞌanta ti ruaꞌnaninta, tsango juaxruxin tinteenta ixi ndo Dio kuajon ndo juachaxin chao tikonnta ko tienxinnta ti nichja. ");
INSERT INTO pps_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Ko nduaxin xrontatjunta ixi itsjé sen kuachronga chijnie ndo Dio ko ikaxin chujni tjúá aséen, xrojueñao sen xrobikon sen ti tikon jaꞌanta, ko bikonꞌa sen ko kuienꞌa sen. ");
INSERT INTO pps_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","’Jai tinꞌennta ngeꞌe xrondachro ti xi ikjui bikenga chjaka. ");
INSERT INTO pps_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Ngisen tinꞌen chijni chronga xranchi tetuanꞌan ndo Dio ko tienxinꞌa sen ti kuinꞌen sen, meꞌe ti̱i̱ Xixronꞌanxrée nchetjáñajin xa sen, méxin tjáñeꞌe sen ti kuinꞌen sen, meꞌe xrondachro ti noa kuintjí ngandeꞌe chaꞌo. ");
INSERT INTO pps_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Ko noa kuitsinga ti jii ixro meꞌe xrondachro ngisen kuinꞌen chijni chronga xranchi tetuanꞌan ndo Dio ko sen meꞌe juincheꞌe sen juaxruxin ti kuinꞌen sen. ");
INSERT INTO pps_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Ko kuienxinꞌa sen ndako ngeꞌe xrondachro ti chijnie ndo Dio, méxin juaxruxin kuachónda sen tuinxin juexin ixi kui̱i̱ juachjaon kondeexin ti kuitikaon sen ndo Dio, méxin kuachrjendáa sen. ");
INSERT INTO pps_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Ko noa kuitsinga ti jii nta̱chaꞌa meꞌe xrondachro ngisen tinꞌen chijnie ndo Dio ko tindoxinꞌa sen ti ndakoꞌa ncheꞌe sen ko ícha ncheꞌe sen juaxruxin tomi ko kain ti tjintee jii ngataꞌa nunte. Meꞌe ncheꞌa sen ti jian. ");
INSERT INTO pps_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Ko noa kuitsinga ngataꞌa inche jian meꞌe xrondachro ngisen tinꞌen chijnie ndo Dio ko tienxin sen ko taxi ncheꞌe sen ti tetuanꞌan ndo Dio. Sen meꞌe ncheꞌe sen xranchi kaxin katrigo tajon ka ngujngu ciento noa ko kaxin ka tajon ka níikán noa ko ikaxin ka tajon ikánte noa. ");
INSERT INTO pps_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Tjumeꞌe ndo Jesús juakoxin ndo inaa chijni ndachro jaꞌin: ―Ti tetuanꞌan ndo Dio tonꞌen xranchi naa ngisen kuenga jian nunteꞌe. ");
INSERT INTO pps_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Ko hora juexin nchakon, kain sen sakuintejua sen ko naa xi ningakonꞌen sen, ikjui xa bikenga xa ngakjenꞌen trigo naa tse̱e̱ kañaꞌi ndatinꞌin cizaña, ko sakjui xa. ");
INSERT INTO pps_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Ko nchakon kuachrje ka trigo ko kuaxi kuajon ka tién ka, sen nchexra̱ bikon sen ixi kaxon ika ñaꞌi tsikangi ka. ");
INSERT INTO pps_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Ko kuichronga sen ngajin nchée sen ko ndachro sen: “Nchána siá jaꞌanta kuenganta noa trigo, noa jian, ¿ti no tsiki̱ꞌxi̱n ika ñaꞌi tsikangikaꞌo noa jian?” ");
INSERT INTO pps_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Ko nchée sen juatingíexin: “Naa xi ningakonna tsijincheꞌe ña̱.” Tjumeꞌe sen nchexra̱ ndachro sen: “¿Á tjaunnta itsjina tsikantsjengina kañaꞌi?” ");
INSERT INTO pps_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Ko ndachro nchée sen: “Naꞌi, ixi hora tsantsjengínta ka ñaꞌi, ba tsantsjengínta ka trigo ixi naxrajeꞌo tsjeꞌe ka. ");
INSERT INTO pps_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Nchakon xroxejo noa, meꞌe tsichuxinni noa trigo ko kañaꞌi. Tintuꞌenta ka tsangikaꞌo kichuu ka tsija nchakon xroxejo tse̱e̱. Meꞌe tsetuanꞌan sen nchexra̱ saꞌó tsjejo sen kañaꞌi, ko tsjasintja sen kichuu ka ko tsjaaka sen ka ixi xroꞌi, ko tjumeꞌe xroxraka noatrigo ko itsji noa ti tsasinꞌinni noa.” ");
INSERT INTO pps_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Ndo Jesús juakoxin ndo naa chijni ndachro jaꞌin: ―Nchijíi ti tetuanꞌan ndo Dio tonꞌen xranchi naa tse̱e̱ nta̱a̱ mostaza tsikenga naa xi ngataꞌa nunteꞌe xa. ");
INSERT INTO pps_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Ko tse̱e̱ meꞌe tsango nchíín tse̱e̱ ko nchakon tsangi nta̱a̱ mostaza, nta̱a̱ meꞌe nta̱a̱ ícha ijié ixi ikaxin nta̱a̱ ko kuxe nchéña ba kakée ba ngataꞌa chaan nta̱a̱. ");
INSERT INTO pps_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Ndo Jesús juakoxin ndo inaa chijni: ―Nchijíi ti tetuanꞌan ndo Dio tonꞌen xranchi naa nchri itsé nchra nchíín chuꞌu nchetjaꞌin itsjé chue nutja, ko nchion chuꞌu meꞌe nchetsjé chue nutja. ");
INSERT INTO pps_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Ndo Jesús juinchekuenꞌen ndo chujni itsjé ngeꞌe ixi bakekiꞌe ndo na̱ ixi chijni; ko jeꞌo chijni banchekuenxin ndo na̱. ");
INSERT INTO pps_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Jaña ndo Jesús juincheꞌe ndo ngeꞌe ndachro naa sen tsichronga chijnie Dio ó saꞌó: Janꞌan xronichjaꞌa chujni ixi chijni ko tsekiꞌa na̱ ngeꞌe ti jimá kuachónda ndo Dio, ti tsixrangíxixion juinchéña ndo nunte xasintajni. ");
INSERT INTO pps_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Juexin nichjeꞌe ndo Jesús chujni ste ntiꞌa, tjumeꞌe kuixinꞌin ndo nchia, ko konchjiñeꞌe sen teyuu chrikao ndo ko ndachro sen: ―Ndachijininta ngeꞌe xrondachro ti ika ñaꞌi bangikaꞌo ka trigo. ");
INSERT INTO pps_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Ko ndo Jesús ndachro ndo: ―Sen benga noatrigo meꞌe Chjenꞌen ndo Dio, xjan jongíꞌe xranchi chujni. ");
INSERT INTO pps_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Ko chjaka xrondachro chujni ste ngataꞌa nunte xasintajni. Ko noatje xrondachro chujni kuayéꞌe juachaxin tsinꞌin chjenꞌen ndo Dio ko tsitikaon ti tetuanꞌan jeꞌe ndo. Ko ika ñaꞌi meꞌe chujni ncheꞌe xrée Xixronꞌanxrée. ");
INSERT INTO pps_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Ko xi toñao, xi kuenga kañaꞌi meꞌe Xixronꞌanxrée. Ko ti tsandáani meꞌe xrondachro nchakon tsoña̱ kain ijie̱ ko tsjexin kain ngeꞌe. Ko sen tsandáa meꞌe sen ángel neꞌe ndo Dio. ");
INSERT INTO pps_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Ko kaxon ti xroxejo kañaꞌi ko tsixintja kichuu ka ko xroche ka, meꞌe xrondachro ti tsoña̱ ijie̱ nchakon tsjexin kain ngeꞌe. ");
INSERT INTO pps_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Ko Chjenꞌen ndo Dio, xjan jongíꞌe xranchi chujni, tsetuenꞌen xjan sen ángel neꞌe xjan itsji sen nchijíi ti tetuanꞌan ndo Dio, ko tsejo sen chujni ndakoꞌa ncheꞌe ko ni nchekateya ikaxin chujni sincheꞌe ti ndakoꞌa. ");
INSERT INTO pps_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Ko sen ángel meꞌe tsjankaya sen chujni ñaꞌi ti jii xroꞌi xranchi naa itja̱; ntiꞌa xrotsjanga chujni meꞌe ko tse̱ꞌto̱ neno na̱. ");
INSERT INTO pps_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Ko kain sen juincheꞌe ti jian, sen meꞌe tsongixin sen xranchi chjiixro ti tetuanꞌan ndo Dio. Méxin siá chondanta ndatsjonnta, jian tienxinnta jiꞌin. ");
INSERT INTO pps_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","’Ti jii no tetuanxin ndo Dio tonꞌen xranchi tomi tsango tjintee jixrabaa. Ko naa ngisen kuitja tomi meꞌe ko sen meꞌe íjngo juabaa sen tomi. Ko tsango chéꞌe sen, méxin sakjui sen kuinchekji sen kain ti chónda sen ko tomi tsjejo sen meꞌe tseꞌnaxin sen nunte ti no jixrabaa tomi kuitja sen. ");
INSERT INTO pps_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Kaxon ndo Jesús ndachro ndo: ―Ti jii ti tetuanxin Dio kaxon tonꞌen xranchi naa xi tachríi ixro tsango chaxro. ");
INSERT INTO pps_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Ko nchakon kuitja xa naa ixro tsango tjintee, sakjui xa kuinchekji xa kain ti ngeꞌe tjintee kuachónda xa ko ikjan xa ko kueꞌna xa ixro meꞌe. ");
INSERT INTO pps_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Tjumeꞌe ndachro ndo Jesús: ―Ti jii ti tetuanꞌan ndo Dio jii xranchi naa nochaꞌa, ko sen itsé kuchee̱ tjankaꞌngi sen nochaꞌa meꞌe ixi xrotsé sen ngixeꞌi kuchee̱ jingi inda. ");
INSERT INTO pps_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Ko hora kaon nochaꞌa, tantsjengi sen nochaꞌa ngandeꞌe inda ko ntiꞌa tsincheꞌe sen kuchee̱ jian ko tenga sen ba ngaya ntaxra. Ko kuchee̱ xroꞌan xrée tjanka sen ba. ");
INSERT INTO pps_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Jaña tsonꞌen nchakon tsjexin kain ngeꞌe ngataꞌa nunte xasintajni. Itsji sen ángel tsincheꞌe sen chujni jian ko chujni ndakoꞌa ncheꞌe. ");
INSERT INTO pps_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Ko tsjánkaxinꞌin sen ni ndakoꞌa ncheꞌe ti jii xroꞌi naiꞌa tanga ko ntiꞌa xrotsjanga na̱ ko tse̱ꞌto̱ neno na̱ ixi tsango ijié juachjaon jii ntiꞌa. ");
INSERT INTO pps_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Ndo Jesús juanchangi ndo: ―¿Á tienxinnta kain ti rintakuanꞌannta? Ko jeꞌe sen juatingíexin sen: ―Jaán, Nchána, tianxinna. ");
INSERT INTO pps_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ko ndachro ndo: ―Kain sen tjako ley neꞌe ndo Dio ko taxi tienxin sen ngeꞌe xrondachro ti juachaxin tetuanꞌan ndo Dio, sen meꞌe ncheꞌe sen xranchi naa xi chónda itsjé ngeꞌe ngaxinꞌin naa nchia ijié, ko ntiꞌa tantsjexin xa ti natjúá ko ti nta̱xi. ");
INSERT INTO pps_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Ko hora juexin juinchekuenꞌen ndo na̱ kaxin chijni, ndo Jesús sakjuixin ndo ntiꞌa, ");
INSERT INTO pps_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","ko kuiji ndo tjajnée ndo, tjajna Nazaret. Kuaxi ndo juinchekuenꞌen ndo chujni ngaxinꞌin ningue ni Israel. Ko chujni meꞌe xronka na̱ ko stendachro na̱: ―Xi jiꞌi, ¿ti no tsikitjaxin xa kain ti nichja xa ko xranchi ncheꞌe xa kain ixra̱ ijié? ");
INSERT INTO pps_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Ko ikaxin na̱ stendachro na̱: ―¿Á jeꞌa jiꞌi chjenꞌen ndo José, ndo tameꞌe nta̱a̱, ko janée xa jan María ko xi kichuu xa, xi Santiago, José, Simón ko xi Judas? ");
INSERT INTO pps_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Ko tjajna ntiꞌi ste kaxin nchri kichuu xa. ¿Xranchi noꞌe xa kain jiꞌin ko xranchi ncheꞌe xa kain ti ixra̱ ijié? ");
INSERT INTO pps_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","*Ko ninaa ni ste ntiꞌa kuitikaonꞌa na̱ ngeꞌe juako ndo Jesús. Méxin jaꞌin ndachro ndo: ―Kain tjajna chujni tajon na̱ juasie na̱ ngajin naa ndo chronga chijnie ndo Dio. Ko ni tjajnée ndo, naꞌi, ko kaxon ni ndoꞌa ndo tjaunꞌa na̱ tajon na̱ juasie na̱. ");
INSERT INTO pps_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ko ixi titikaonꞌa ni tjajnée ndo, méxin tsjéꞌa chujni juinchexruenꞌen ndo ntiꞌa. ");
INSERT INTO pps_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Nchakon meꞌe xi ndatinꞌin Herodes Antipas, xi tituenꞌen nunte Galilea, kuinꞌen xa ti kuanichja chujni ngeꞌe jian kuancheꞌe ndo Jesús. ");
INSERT INTO pps_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Ko naa nchakon ndache xa ni nchexrée xa: ―Xi Jesús meꞌe xi Juan Bautista ko jai tsixechón xa. Méxin chónda xa ijié juachaxin nchexruenꞌen xa chujni. ");
INSERT INTO pps_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","*Xi Herodes tsixraxinꞌin xa ndo Juan, ngaxinꞌin ndoꞌa chjiso ko ntiꞌa tsikintee xa ndo ixi chika cadena kondeexin nchri Herodías, nchrinchriꞌe xi Felipe, xi kichuu xi Herodes ");
INSERT INTO pps_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","ixi tsindache ndo xa: ―Ndakoꞌa juincheꞌe jaꞌa ixi kuantsjeꞌe xi kichuua, Felipe, nchrinchriꞌe xa, nchri Herodías, ko kutaꞌa nchra. ");
INSERT INTO pps_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Xi Herodes tjaun xa naaxrokóñaxón xa ndo Juan, ko juaꞌi ixi kuaxrakonꞌen xa chujni ixi kain ni tjajna meꞌe titikaon na̱ ixi jeꞌe ndo Juan meꞌe naa ngisen nduaxin tjako chijnie ndo Dio. ");
INSERT INTO pps_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Ko nchakon kuitja xa nano, juinchéña xa kiée xa, ko nchrixajoꞌen xa, nchrichjeꞌen nchri Herodías, chaxro ité nchrichan ko bikon kain ni ikjui kiée xa. Ko tsango juincheꞌe xa juaxruxin xranchi ité nchrichan, ");
INSERT INTO pps_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","méxin ndache xa nchrichan ko nichjaxin xa ngatoxin ndo Dio ixi nduaxin tsajon xa ngajin nchrichan ngixeꞌi ngeꞌe xrojuanchia nchrichan. ");
INSERT INTO pps_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Ko nchri Herodías juinchekateya nchra nchrichjeꞌen nchra, méxin jaꞌin ndachro nchrichan: ―Chjána̱na ngaya naa laato jaa xi Juan tikitée chujni. ");
INSERT INTO pps_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Ko xi rey Herodes tsango koniꞌe aséen xa ixi ti juanchia nchrichan ixi jeꞌe xa tsindachro xa ixi nduaxin xrokuajon xa ti xrojuanchia nchrichan ko ixi kain ni ste ntiꞌa kuinꞌen na̱, méxin kuituanꞌan xa tsonꞌen xranchi ndachro nchrichan. ");
INSERT INTO pps_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Ko kuetuanꞌan xa ixi tsonchrijin na̱ jaa xi Juan ngaxinꞌin ndoꞌachjiso. ");
INSERT INTO pps_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Ko tjumeꞌe bikaꞌo na̱ jaa xi Juan ngaya naa laato ko kuayéꞌe nchrichan, ko jeꞌe nchrichan kuajon nchrichan jaa xa ngajin janée nchrichan. ");
INSERT INTO pps_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Ko kuinꞌen sen chrikao ndo Juan ixi jaña tsikonꞌen, meꞌe juirueꞌe sen ndo ko juabaa sen ndo, ko tjumeꞌe kuichronga sen ngajin ndo Jesús ngeꞌe konꞌen. ");
INSERT INTO pps_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Ko hora kuinꞌen ndo Jesús ixi jaña tsikonꞌen ndo Juan, kuixinꞌin ndo ngaxinꞌin naa nta̱barco ko sakjui ndo ti xroꞌan chujni jii ixi jeꞌo ndo tjaun ndo tsakeꞌe ndo. Ko kain chujni kuinꞌen ixi sakjui ndo ko kueya na̱ kuachrjexin na̱ tjajnée na̱ ko tutée na̱ ruexin na̱ ndo. ");
INSERT INTO pps_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Ko hora kuachrjexin ndo Jesús nta̱barco, bikon ndo ixi tsango itsjé chujni jii ntiꞌa, bikonóeꞌe ndo na̱ ko juinchexruenꞌen ndo kain ni niꞌe tsikikaꞌo na̱. ");
INSERT INTO pps_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Ko ó jitondaya nunte ko sen teyuu chrikao ndo Jesús konchjiñeꞌe sen ngajin ndo, ko ndachro sen: ―Ó jitóndó ko ntiꞌi xroꞌan ngeꞌe jii sinena. Cháña ndachenta na̱ satsji na̱ naa tjajna tsijée na̱ naa ngeꞌe sine na̱. ");
INSERT INTO pps_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Ko jeꞌe ndo Jesús jaꞌin juatingíexin ndo: ―Naꞌi. Xrokondaꞌi satsji na̱. Jaꞌanta chje̱ꞌénta na̱ ngeꞌe sine na̱. ");
INSERT INTO pps_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Ko jeꞌe sen juatingíexin sen: ―Xroꞌan ngeꞌe chondana, jeꞌo naꞌó nutja ko yuu kuchee̱. ");
INSERT INTO pps_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Ko jeꞌe ndo Jesús ndachro ndo: ―Kuaxinta ntiꞌi ngeꞌe chondanta. ");
INSERT INTO pps_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Ko kuetuanꞌan ndo chujni tsjokéꞌe na̱ ngataꞌa kayua ko itsé ndo ti naꞌó nutja ko ti yuu kuchee̱ ko tsjeꞌe ndo ngajní ko kuajon ndo juasie ndo ngajin ndo Dio. Tjumeꞌe konchrinjin ndo nu ko kuajon ndo nu ngajin sen teyuu chrikao ndo ko kao kuchee̱ tsonchjeyeꞌe sen chujni. ");
INSERT INTO pps_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Ko kain na̱ juine na̱ jian, ko kaon na̱. Ko juexin juine kain chujni, sen teyuu chrikao ndo Jesús juejo sen ti xeꞌe, teyuu ntaxra. ");
INSERT INTO pps_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Ko ni juine xranchi naꞌó mil jeꞌo chujni xi, ko bekiꞌa sen sen nchri ko ichjan. ");
INSERT INTO pps_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Ko tjumeꞌe kuituenꞌen ndo Jesús sen teyuu chrikao ndo ko ndachro ndo: ―Tajiínta nta̱barco ko tatsingatoꞌenta ndachaon. Janꞌan tsituna ntiꞌi xrontatjan chujni satsji na̱ ko banchixon xroruaꞌanta. ");
INSERT INTO pps_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Ko juexin chjekeꞌe chujni, ndo Jesús sakjui ndo naa ijna̱ jeꞌo ndo ixi ntiꞌa xronichjeꞌe ndo ndo Dio. Ko ntiꞌa jeꞌo ndo bakeꞌe ndo ko ó tiie. ");
INSERT INTO pps_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Ko nta̱barco ó kuiji nta̱a̱ ngusine ndachaon ko kuaxi binga naa chrinto tsango soji ko inda jijamangitaon nda ko tjaun nda tsonjamangi nda nta̱barco, ko ícha jitosoji chrinto. ");
INSERT INTO pps_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Ko ndúyo xranaxixeꞌe ndo Jesús konchjiñeꞌe ndo ti jii nta̱barco ko jiti̱xi̱n tutée ndo ngataꞌa nda. ");
INSERT INTO pps_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Ko sen teyuu chrikao ndo bikon sen naa ngisen jiti̱xi̱n tutée ngataꞌa nda ko juatsuanꞌi sen ndo, méxin tsango xronka sen ko kuyako sen séen: ―¡Naa ntachaꞌan, naa ntachaꞌan! ");
INSERT INTO pps_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Ko ndo Jesús tuinxin nichjeꞌe ndo sen: ―Xrakonꞌanta ixi janꞌan juiꞌi. ");
INSERT INTO pps_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Ko ndo Pedro juatingíexin ndo ko ndachro ndo: ―Nchána, siá nduaxin jaꞌanta, tituanꞌannta ixi janꞌan kaxon tsjixin tutéena ngataꞌa inda ko tsjaso ti ritjennta. ");
INSERT INTO pps_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Ko ndo Jesús ndachro ndo: ―Xrokuia. Ko tuinxin ndo Pedro xingajinxin ndo nta̱barco ko kuaxi juixin tutée ndo ngataꞌa nda ti no jii ndo Jesús. ");
INSERT INTO pps_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Ko chrinto soji juinchexronka ndo Pedro ko jitaxin jitenunte ndo chringi inda ko kuyako ndo: ―Nchána, ¡tingijnaninta! ");
INSERT INTO pps_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Ko ndo Jesús tuinxin koka itja ndo ko itsé ndo ndo Pedro ko ndachro ndo: ―Pedro, ¿sonda tsango nchion chuntiana ko sonda xronka? ");
INSERT INTO pps_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Ko tjumeꞌe yui sen kuajinꞌin sen nta̱barco ko tuinxin kuíxin chrinto. ");
INSERT INTO pps_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Ko sen stexinꞌin nta̱barco bakeꞌexin ntatuchiꞌin sen ngajin ndo Jesús ko ndachro sen: ―¡Nduaxin Chjenꞌen ndo Dio jaꞌanta! ");
INSERT INTO pps_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Tjumeꞌe juexin kuatsingatuꞌe sen ndachaon ko kuiji sen nunte Genesaret. ");
INSERT INTO pps_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ko chujni tjajna meꞌe kuichúxin na̱ ndo Jesús, ko juinchenoꞌe na̱ kainxin tjajna ste nunte meꞌe ixi ndo Jesús ntiꞌa jii ndo ko chujni meꞌe bikaꞌo na̱ kain ni niꞌe. ");
INSERT INTO pps_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Ko kuinóatée ni niꞌe ixi maski ngandeꞌe mantée ndo xrotsé na̱, ko nduaxin kain ni itsé mantée ndo, koxruenꞌen na̱. ");
INSERT INTO pps_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Tjumeꞌe konchjiñeꞌe kaxin xi fariseo ko kaxin xi tjako chijnie ndo Dio tsiki̱ꞌxi̱n tjajna Jerusalén ko juanchangiꞌe xa ndo: ");
INSERT INTO pps_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","―¿Sonda sen chrjikuꞌunta ncheꞌa sen ngeꞌe kuancheꞌe sen tachríꞌina ixi xrokonda saꞌó sinéma itja sen ko tjumeꞌe sine sen? ");
INSERT INTO pps_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Ko ndo Jesús juanchangi ndo: ―¿Sonda jaꞌanta rueꞌénta ngeꞌe kuancheꞌe na̱ ko jaña ndáꞌa tintuꞌenta ngeꞌe tsiketuanꞌan ndo Dio? ");
INSERT INTO pps_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Ixi ndo Dio ndachro ndo: “Chondeꞌenta juasaya ndotánta ko janáanta ko tayakonꞌennta sen”, ko “Ngisen ndakoꞌa nichja ngajin ndotée sen ko janée sen, xrokonda tsenꞌen sen.” ");
INSERT INTO pps_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Ko jaꞌanta ndachenta chujni ixi chao xrondache na̱ ndotée na̱ ko janée na̱: “Janꞌan juaꞌi tsingijnanta ixi kain ngeꞌe chonda, ó ntatjan ndo Dio ixi jeꞌe ndo tsayéꞌe ndo.” ");
INSERT INTO pps_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Ko ngixeꞌi chujni xrondachro jaña, íxrokondaꞌi tsingijna ndotée ko janée. Ko ixi jaꞌanta tjakonta jaña, méxin juincheméꞌenta ngeꞌe kuituanꞌan ndo Dio ko jaꞌanta ncheꞌenta ngeꞌe tsikituanꞌan sen xranchrjen. ");
INSERT INTO pps_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Jaꞌanta ti tjako yuu ikonnta. Nduaxin ti tsindachro ndo Isaías, ndo kuachronga chijnie ndo Dio ó saꞌó: ");
INSERT INTO pps_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Chujni tjajna jiꞌi ndachro na̱ ixi tajon na̱ juasaya ngajin jeꞌo ixi roꞌa na̱, meꞌe ti nichja na̱ ko jeꞌa nduaxin, ko ngaya aséen na̱ titikaonꞌa na̱. ");
INSERT INTO pps_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Méxin, xroꞌan tjintee ti chjána na̱ juasaya ixi jeꞌo tjako na̱ ngeꞌe tetuanꞌan chujni. ");
INSERT INTO pps_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Ko ndo Jesús kuiyeꞌe ndo chujni ste ntiꞌa ko ndachro ndo: ―Tinꞌennta ti ntatjunta ko tienxinnta. ");
INSERT INTO pps_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Jeꞌa ti ine chujni meꞌe sincheki̱tja̱ aséen. Naꞌi, ti nichja na̱ ko ti nichjangí na̱ meꞌe ti ncheki̱tja̱ aséen na̱. ");
INSERT INTO pps_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Tjumeꞌe sen teyuu chrikao ndo Jesús konchjiñeꞌe sen ngajin ndo ko ndachro sen: ―Xi fariseo koñao xa ixi ngeꞌe ndachronta. ");
INSERT INTO pps_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Ko ndo Jesús juatingíexin ndo: ―Kain ika, ka bengaꞌi Ndotána jii ngajní, kain ka meꞌe xrokonda tsachrjengíxin nueꞌe ka. ");
INSERT INTO pps_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","*Taꞌinta juachjaon ixi xi fariseo ña̱, ntakutsin xa ko ni ruéꞌe xa kaxon ntakutsin na̱. Ko siá naa xi ntakutsin tikao inaa xi ntakutsin, yui xa tsitsingaya xa naa tuye. ");
INSERT INTO pps_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Ndo Pedro ndache ndo ndo Jesús: ―Ndachijininta ngeꞌe xrondachro chijni jiꞌi. ");
INSERT INTO pps_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Ndo Jesús ndachro ndo: ―¿Á kaxon jaꞌanta tienxinꞌanta? ");
INSERT INTO pps_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","¿Á tienxinꞌanta ixi kain ngeꞌe ti ineni itji ngaya tse̱ꞌe̱ni ko tjumeꞌe tachrje? ");
INSERT INTO pps_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","*Ko ti ndakoꞌa nichja chujni ti̱ꞌxi̱n ngaya aséen, ko meꞌe ncheki̱tja̱ aséen na̱. ");
INSERT INTO pps_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Ixi aséen chujni tachrjexin ti jianꞌi ko kain ti ndakoꞌa xraxaon na̱, ti naatsóñaxón naa chujni, ko ti tsekao na̱ inaa nchri, nchri jeꞌa nchrinchriꞌe na̱, ko jeꞌo xraxaon na̱ xrochónda itsjé nchri, ko ti tjaun na̱ tse̱e na̱, ko ti ncheya na̱ ko ti tengeꞌe kichuu na̱ teka. ");
INSERT INTO pps_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Kain jiꞌi meꞌe ncheki̱tja̱ aséen chujni, ko maski tsitikaonꞌa na̱ ixi sinéma itja na̱ hora sine na̱, jeꞌa meꞌe tsamaxin na̱ ijie̱. ");
INSERT INTO pps_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Tjumeꞌe ndo Jesús kuachrjexin ndo tjajna Jerusalén ko sakjui ndo tjajna Tiro ko tjajna Sidón. ");
INSERT INTO pps_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Ko naa nchri cananea jii ndoꞌa nchra no nunte meꞌe, kui̱i̱ nchra ngajin ndo Jesús ko séen jitoyako nchra: ―Nchána, Chjenꞌen ndo David, tikonóananinta ixi xjanchrichjanꞌna chónda xjan naa espíritue Xixronꞌanxrée ko tsango tangi jii xjan. ");
INSERT INTO pps_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Ndo Jesús juatengíexinꞌa ndo. Ko sen teyuu chrikao ndo konchjiñeꞌe sen ngajin ndo ko ndache sen ndo: ―Nchána, ndachenta nchra satsji nchra ixi tsango tuyako nchra ko jiruaꞌina nchra. ");
INSERT INTO pps_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Ko ndo Jesús ndachro ndo: ―Ndo Dio xruanꞌanna ndo tsingijna sen tjajnána Israel ixi jeꞌe sen tsingachrue sen xranchi kutuchjon. ");
INSERT INTO pps_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ko jeꞌe nchri cananea konchjiñeꞌe nchra ko bakeꞌexin ntatuchiꞌin nchra ngajin ndo Jesús, ko ndachro nchra: ―Nchána, ¡tingijnaninta! ");
INSERT INTO pps_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Ko ndo Jesús ndachro ndo: ―Ndakoꞌa jii tsantsjeꞌeni chjenꞌenni nutja ko xrochjéeni kunia sine ba. ");
INSERT INTO pps_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Ko jeꞌe nchra ndachro nchra: ―Nchána, nduaxin meꞌe. Ko kaxon kunia ine ba nutja tutuꞌo titsingaxin ti netaꞌa nchée ba. ");
INSERT INTO pps_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Tjumeꞌe ndachro ndo Jesús: ―Nduaxin jaꞌa tsango chuntiana. Tsonꞌen xranchi jaꞌa tjauan. Ko hora meꞌe chjenꞌen nchra tuinxin koxruenꞌen xjan. ");
INSERT INTO pps_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Ko ndo Jesús sakjuixin ndo ntiꞌa ko kuiji ndo ngandeꞌe ndachaon ndatinꞌin Galilea. Tjumeꞌe kuiji ndo naa ijna̱ ko ntiꞌa bakeꞌe ndo nunte. ");
INSERT INTO pps_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Ko itsjé chujni konchjiñeꞌe na̱ ngajin ndo ko bikaꞌo na̱ chujni ntarengo ko ni tikonꞌa ko ni nosin ko chujni ntamango ko ikaxin ni niꞌe bakeꞌe na̱ tjenka tutée ndo Jesús ko jeꞌe ndo juinchexruenꞌen ndo ni niꞌe meꞌe. ");
INSERT INTO pps_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Ko kain chujni ste ntiꞌa tsango xronka na̱ ixi bikon na̱ ixi ni nosin ó chao nichja na̱ ko ni ntamango chao koxruenꞌen na̱ ko ni ntarengo ó chao itji na̱ ko ni ntakutsin chao tikon na̱. Ko tjumeꞌe kuaxi na̱ kuajon na̱ juasie na̱ ngajin ndo Dio neꞌe ni tjajna Israel. ");
INSERT INTO pps_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Tjumeꞌe ndo Jesús kuiyeꞌe ndo sen teyuu chrikao ndo ko ndachro ndo: ―Tsango tikonóaꞌa kain chujni jiꞌi ixi ó níi nchakon ste na̱ ngaji̱n ko chóndaꞌi na̱ ngeꞌe sine na̱. Ko tjaunꞌa xrontatjan na̱ satsji na̱ ndoꞌa na̱ ba̱ tsjeje̱ñao na̱ ixi jinta ngatja chaꞌo. ");
INSERT INTO pps_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Ko sen teyuu chrikao ndo juatingíexin sen: ―Ntiꞌi ti stena, xroꞌan ngisen jii, ¿ti no tsanchiana ngeꞌe sine na̱ ixi tsango kueya na̱? ");
INSERT INTO pps_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Ko ndo Jesús juatingíexin ndo: ―¿Ngijanꞌin nutja chondanta? Ko jeꞌe sen ndachro sen: ―Ya̱a̱to̱ nutja ko kaxin kuchee̱ nchínchín. ");
INSERT INTO pps_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Ko ndo Jesús kuituenꞌen ndo kain chujni tsjokéꞌe na̱ ngataꞌa nunte. ");
INSERT INTO pps_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Ko itsé ndo ti ya̱a̱to̱ nutja ko kuchee̱ ichjan ko kuajon ndo juasie ndo ngajin ndo Dio. Ko kuaxi konchrinjin ndo nutja ko chjée ndo sen teyuu chrikao ndo ko jeꞌe sen konchjeya sen nutja ko kuchee̱ ngajin chujni ste ntiꞌa. ");
INSERT INTO pps_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Kain na̱ juine na̱ jian ko kaon na̱, ko xra xejo ya̱a̱to̱ ntaxra nutja tutuꞌo ti tsikonchrijin ndo. ");
INSERT INTO pps_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Ko ni juine nchakon meꞌe noó mil chujni xi. Ko bekiꞌa sen chujni nchri ko ichjan. ");
INSERT INTO pps_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Tjumeꞌe ndo Jesús chjée ndo na̱ juajna ko sakjui na̱ ko jeꞌe ndo kuajinꞌin ndo nta̱barco ko sakjui ndo no nunte Magdala. ");
INSERT INTO pps_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","*Kaxin xi fariseo ko kaxin xi saduceo ikjui xa ngajin ndo Jesús ixi tjaun xa ndakoꞌa xronichja jeꞌe ndo, méxin ndachro xa ixi ndo Jesús xrojuakoxin ndo naa ixra̱ ijié, meꞌe xrokuitikaon xa ixi nduaxin jeꞌe ndo kui̱xi̱n ndo ixi juachaxien ndo Dio. ");
INSERT INTO pps_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Jeꞌe ndo Jesús juatingíexin ndo ndachro ndo: ―Ó kóndo ko jaꞌanta tsjeꞌenta ngajní ko ndachronta: “Chaxro sincheꞌe nchakon ixi játse ngajní.” ");
INSERT INTO pps_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ko ndúyo tsjeꞌenta ngajní ko ndachronta: “Jai chaxroꞌa sincheꞌe nchakon ixi játse ngajní ko tsango jii itjui̱ tiie.” Jaꞌanta tsango jian tienxinnta ngixranchi sincheꞌe nchakon, ¿sonda tienxinꞌanta ngeꞌe ixra̱ ntaꞌa janꞌan ixi jiꞌin ti̱ꞌxi̱n ixi juachaxien ndo Dio? ");
INSERT INTO pps_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","*Jaꞌanta ñaꞌinta ko tjanchianta naa ixra̱ ijié tsonꞌen tsikonnta. Ko tsikonꞌanta tsonꞌen ixra̱ ijié meꞌe, jeꞌo tsikonnta xranchi konꞌen ndo Jonás, ndo kuanichja chijnie ndo Dio ó saꞌó. Tjumeꞌe ndo Jesús sakjui ndo ko kuintuꞌe ndo ni ste ntiꞌa. ");
INSERT INTO pps_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Ndo Jesús ko sen teyuu chrikao kuatsingatuꞌe sen ndachaon ndatinꞌin Galilea ko sen teyuu chrikao ndo tsitjáñeꞌe sen nutja. ");
INSERT INTO pps_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","*Meꞌe ndachro ndo Jesús: ―Jian tsjeꞌenta ngeꞌe xrondachro ti chuꞌu nchetjaꞌin nutjée xi fariseo ko xi saduceo. ");
INSERT INTO pps_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Ko sen teyuu chrikao ndo Jesús ndache kichuu sen: ―Jaꞌin ichro ndo ixi tjáñai̱na nutja. ");
INSERT INTO pps_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Ko ndo Jesús konoꞌe ndo ngeꞌe stendachro sen, méxin ndachro ndo: ―¿Sonda ndachronta ixi chondaꞌinta nutja? Jaꞌanta chuntiaꞌininta, méxin nichjanta jaña. ");
INSERT INTO pps_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","*¿Á xraxaonꞌanta o̱ tienxinꞌanta ti naꞌó nutja chjeyeꞌe naꞌó mil chujni juine na̱ ko ngijanꞌin ntaxra nutja xejo ti tsixeꞌe? ");
INSERT INTO pps_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","*Ko, ¿á sintaxiꞌañaonta ixi ya̱a̱to̱ nutja konchjeyeꞌenta noó mil chujni juine ko ngijanꞌin ntaxra juejonta ti nutja tsixeꞌe? ");
INSERT INTO pps_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿Á kuienxinꞌanta ixi janꞌan jeꞌa nutja rindachrja̱n hora ntatjunta ixi jian tsjeꞌenta ngeꞌe tjako xi fariseo ko xi saduceo? ");
INSERT INTO pps_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Tjumeꞌe kuienxin sen teyuu chrikao ndo Jesús ixi jeꞌa kondee chuꞌu nchetjaꞌin nutja jinichja ndo. Naꞌi. Jeꞌe ndo jindachro ndo ixi ti ngeꞌe tjako xi fariseo ko xi saduceo meꞌe jian xrotsjeꞌe sen ixi ti nichja xa ndakoꞌa jii. ");
INSERT INTO pps_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Hora kuiji ndo Jesús nunte tjajna Cesarea de Filipo meꞌe ndache ndo sen teyuu chrikao ndo: ―¿Ngeꞌe ndachro ni tjajna ixi Chjenꞌen ndo Dio, xjan jongíꞌe xranchi chujni? ");
INSERT INTO pps_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","*Ko jeꞌe sen ndachro sen: ―Kaxin na̱ ndachro na̱ ixi jaꞌanta ndo Juan batikitée chujni ko ikaxin na̱ ndachro na̱ ixi jaꞌanta ndo Elías ko ste ikaxin na̱ ndachro na̱ ixi jaꞌanta ndo Jeremías o̱ ngixeꞌi inaa sen kuachronga chijnie ndo Dio ó saꞌó. ");
INSERT INTO pps_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Tjumeꞌe juanchangi ndo Jesús: ―¿Ko jaꞌanta ngeꞌe chronta, ngisen janꞌan? ");
INSERT INTO pps_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","*Ko ndo Simón Pedro juatingíexin ndo ko ndachro ndo: ―Jaꞌanta ndo Cristo, Chjenꞌen ndo Dio, ndo jichón. ");
INSERT INTO pps_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Ko ndo Jesús ndachro ndo: ―Juaxruxin takeꞌé jaꞌa Simón, chjenꞌen ndo Jonás, ixi xroꞌan chujni juintanoꞌa jiꞌin. Jeꞌe Ndotána jii ngajní juintanoꞌa. ");
INSERT INTO pps_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ko janꞌan sintakiꞌian ixro meꞌe xrondachro Pedro, ko ngataꞌa ixro ijié jiꞌin tsakée ningona ko maski tsi̱i̱ juachjaon tsenxin chujni juaꞌi tsitjáña ningona. ");
INSERT INTO pps_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","*Ko xrotjáꞌa chika xitjeexin nta̱chja ti tetuanꞌan ndo Dio ko jaꞌa tsayéꞌe juachaxin chao kain tsintee ntiꞌi ngataꞌa nunte xasintajni ko ti jii ngajní kaxon juaꞌi xroxindanga; ko kain ngeꞌe xroxindanga ntiꞌi ngataꞌa nunte xasintajni, jii juachaxin ixi ngajní chao xroxindanga. ");
INSERT INTO pps_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Tjumeꞌe ndo Jesús kuetuenꞌen ndo sen teyuu chrikao ndo ixi tsekiꞌa sen ixi jeꞌe ndo, ndo Cristo. ");
INSERT INTO pps_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Nchakon meꞌe kuaxi ndo Jesús ndache ndo sen teyuu chrikao ndo ixi xrokonda satsji ndo tjajna Jerusalén ko ntiꞌa xi tetuanꞌan niꞌngo ko xitaana ko xi tjako ley neꞌe ndo Dio tsango sincheniꞌe xa ndo ko naatsóñaxón xa ndo, ko nchakon nínxin xroxechón ndo. ");
INSERT INTO pps_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Ko ndo Pedro kuantsjendáa ndo ndo Jesús ko kuaxi kuyakutee ndo ndo ko ndachro ndo: ―Nchána ndo Dio tsajonꞌa juachaxin tsonꞌen meꞌe, ko jaꞌanta xroꞌan ngeꞌe tsonꞌannta. ");
INSERT INTO pps_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Tjumeꞌe ndo Jesús ngatjia ndo ko ndache ndo ndo Pedro: ―Ndáꞌa satjia jaꞌa, Xixronꞌanxrée. Tingakonnaꞌia ti ngeꞌe tsónna ixi jaꞌa tienxinꞌa xranchi xraxaon ndo Dio. Jaꞌa xraxaoan xranchi xraxaon chujni. ");
INSERT INTO pps_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","*Tjumeꞌe ndo Jesús nichjeꞌe ndo sen teyuu chrikao ndo, ko ndachro ndo: ―Siá xrojan jaꞌanta tjaunnta xroruaꞌnaninta, xrokonda tsintuꞌenta kain ngeꞌe tjakuenxin asáanta, ko tamanta nta̱cru ko ruaꞌnaninta. ");
INSERT INTO pps_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","*Ixi ngisen tjaunꞌa tsenꞌen, sen meꞌe tsenꞌen sen. Ko ngisen tsenꞌen ixi kondanaxin janꞌan, sen meꞌe tsitjáñaꞌi sen ko xrochónda sen juachaxin tsechón sen kain nchakon. ");
INSERT INTO pps_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Ixi, ¿ngeꞌe tsjacha naa sen siá tsetuenꞌen sen nchijíi nunte xasintajni ko xrochónda sen itsjé tomi, ko sinchetjáña aséen sen? Ixi tomi meꞌe juaꞌi tsjengaxin sen ꞌna̱ ixi tsechón aséen sen. ");
INSERT INTO pps_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","*Ko Chjenꞌen Dio, xjan jongíꞌe xranchi chujni, tsikaꞌo xjan ijié juachaxin ko ijié chjiixro neꞌe Ndotée xjan, ndo Dio, ko kaxon tsikaꞌo xjan sen ángel neꞌe ndo ko tjumeꞌe tsjengeꞌe xjan ꞌna̱ ngujngu chujni ixra̱ juincheꞌe ngataꞌa nunte ntiꞌi. ");
INSERT INTO pps_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Ko nduaxin ntatjunta ixi kaxinnta ti stenta ntiꞌi xratsenꞌanta ko tsikonnta xranchi tsi̱i̱ Chjenꞌen ndo Dio, xjan jongíꞌe xranchi chujni, tsikaꞌo xjan ijié juachaxin ko tsituanꞌan xjan ntiꞌi. ");
INSERT INTO pps_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Kuatsingaja ikjaon nchakon ndo Jesús sabikao ndo ndo Pedro ko ndo Jacobo ko ndo Juan, ndo kichuu ndo Jacobo; jeꞌo sen ikjui sen naa ijna̱ tsango noi. ");
INSERT INTO pps_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Ntiꞌa ste sen ko tuinxin bikon sen ixi kuindoxin ndo Jesús. Ikon ndo jitóngíxin xranchi chjiixro ko manta jitsáa ndo tjúá manta xranchi naa xroꞌi tóngíxin. ");
INSERT INTO pps_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Ko kaxon bikon sen ntiꞌa jii ndo Moisés ko ndo Elías stetjao sen ndo Jesús. ");
INSERT INTO pps_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Tjumeꞌe ndo Pedro ndache ndo ndo Jesús: ―Nchána, chao ndatsojuna ntiꞌi. Ko siá tjaunnta sintáñana níi nchia, naa nchia jaꞌanta ko naa nchia ndo Moisés ko naa nchia ndo Elías. ");
INSERT INTO pps_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","*Ko xrajinichja ndo Pedro, naa itjui̱ tsango jitóngíxin kuitsía sen ko ngakjenꞌen itjui̱ meꞌe kuinꞌen sen naa tée inaa sen nichja ko ndachro sen jaꞌin: ―Jiꞌin chjanꞌna tsango tjuaꞌa ko tsango juaxruxin ritjén ixi ixra̱ jincheꞌe jeꞌe xjan. Titikaonnta ngeꞌe nichja xjan. ");
INSERT INTO pps_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Hora kuinꞌen sen chrikao ndo Jesús, tuinxin bakeꞌexin ntatuchiꞌin sen ko bakeꞌe ikon sen ngataꞌa inche ixi tsango xronka sen. ");
INSERT INTO pps_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Tjumeꞌe ndo Jesús konchjiñeꞌe ndo ngajin sen, bakeꞌe itja ndo ngataꞌa sen ko ndachro ndo: ―Tingatjennta ko xrakonꞌanta. ");
INSERT INTO pps_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Ko tuinxin ikjan tsjeꞌe sen ti no jii ndo Jesús ko xroꞌan ngisen bikon sen jikao ndo. ");
INSERT INTO pps_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Ko hora xingajinxin sen ijna̱, ndo Jesús kuetuenꞌen ndo sen: ―Xroꞌan ngisen tekiꞌénta ngeꞌe bikonta jai, hasta ti xroxechónjan Chjenꞌen ndo Dio, xjan jongíꞌe xranchi chujni. ");
INSERT INTO pps_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Ko sen teyuu chrikao ndo Jesús juanchangiꞌe sen ndo: ―¿Sonda ndachro sen tjako ley kuituanꞌan ndo Dio, ixi saꞌó tsi̱i̱ ndo Elías ko tjumeꞌe tsi̱i̱ ngisen tsajon juachaxin tsechón chujni kain nchakon? ");
INSERT INTO pps_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Ko ndo Jesús juatingíexin ndo: ―Nduaxin meꞌe, saꞌó tsi̱i̱ ndo Elías ixi jeꞌe ndo sinchekonchjian ndo kain ngeꞌe. ");
INSERT INTO pps_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","*Ko janꞌan nduaxin xrontatjunta ixi ndo Elías ó kui̱i̱ ndo, ko chujni kuichúxinꞌa na̱ ndo, méxin chinga juinchekaon na̱ ndo. Ko janꞌan Chjenꞌen ndo Dio, xjan jongíꞌe xranchi chujni, jaña sinchena̱na kaxon ko tsango sinchenína na̱. ");
INSERT INTO pps_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Meꞌe sen teyuu chrikao ndo Jesús kuienxin sen ixi jeꞌe ndo jinichja ndo ixi ndo Juan bikitée chujni. ");
INSERT INTO pps_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Ko naa nchakon kuiji sen ti jii tsango itsjé chujni, meꞌe konchjiñeꞌe naa xi, xi meꞌe bakeꞌexin ntatuchiꞌin xa ngajin ndo Jesús ko ndachro xa: ");
INSERT INTO pps_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","―Nchána, tikonóeꞌénta chjanꞌna ixi jeꞌe xjan chonda xjan ichin tendaa ko tsango tangi tonꞌen xjan. Nanaunka titsinga xjan ngataꞌa xroꞌi ko ngangi inda. ");
INSERT INTO pps_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Bikian xjan ntiꞌi ko sen chrjikuꞌunta juaꞌi juinchexruenꞌen sen xjan. ");
INSERT INTO pps_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Ko ndo Jesús ndache ndo sen teyuu chrikao ndo: ―Jaꞌanta chujni ndakoꞌa xraxaon ko titikaonꞌaninta janꞌan. ¿Ti ngisa xrokonda tsakeꞌe ngajinnta?, ko, ¿ti ngisa tsokuaxinna ngeꞌe ncheꞌenta? Kuaxinta xjan ndaꞌi. ");
INSERT INTO pps_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Ko tjumeꞌe ndo Jesús kuyakutee ndo espíritue xi ñaꞌi ko tuinxin espíritu meꞌe kuachrjexin xjan ko ndakoxruenꞌen xjan. ");
INSERT INTO pps_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Tjumeꞌe sen teyuu chrikao ndo Jesús ndáꞌa kuiyeꞌe sen ndo ko juanchangiꞌe sen ndo: ―¿Sonda janꞌanna juaꞌi kuantsjena espíritu ñaꞌi? ");
INSERT INTO pps_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","*Meꞌe ndo Jesús juatingíexin ndo: ―Jaꞌanta chuntiaꞌininta. Ko janꞌan nduaxin ntatjunta siá jaꞌanta jeꞌo xrochuntianinta naanchion xranchi naa tse̱e̱ ntamostaza tsango nchíín tse̱e̱, meꞌe chao xrondachenta jna̱ jiꞌin: “Ndáꞌa tjia”; ko jaña xrokonꞌen ixi ijna̱ xrokuitikaon jna̱. Ko siá nduaxin xrochuntianinta, chao sincheꞌenta kain ixra̱ tsetuanꞌannta. ");
INSERT INTO pps_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Ixi kain espíritu kichuu ña̱ jeꞌo tachrjexin siá nduaxin xronichjaꞌnaninta kain nchakon ko sinchekatse ñaonta jinta. ");
INSERT INTO pps_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Xrasteyáa sen chaꞌo nunte Galilea, ndo Jesús ndachro ndo ixi jeꞌe ndo Chjenꞌen ndo Dio, xjan jongíꞌe xranchi chujni, xrotsé na̱ ndo ko tsikao na̱ ndo ngajin ni tetuanꞌan, ");
INSERT INTO pps_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","ko naatsóñaxón na̱ ndo. Ko nchakon nínxin xrokonda xroxechón ndo. Ko ti ndachro jeꞌe ndo tsango juincheniꞌe aséen sen teyuu chrikao ndo. ");
INSERT INTO pps_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Nchakon ndo Jesús ko sen teyuu chrikao ndo kuiji sen tjajna Capernaum, ni xengeꞌe ꞌna̱ neꞌe niꞌngo kuitsjeꞌe na̱ ndo Pedro ko juanchangiꞌe na̱ ndo: ―Ndo ntakuanꞌannta, ¿á tjenga ndo ꞌna̱ tomi neꞌe niꞌngo? ");
INSERT INTO pps_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Ko ndo Pedro juatingíexin ndo: ―Jaán, tjenga ndo ꞌna̱. Ko hora ndo Pedro kuixinꞌin ndo nchia ti ste kain sen, ndo Jesús saꞌó nichja ndo ko ndachro ndo: ―Ndachijiana, Pedro, xi tetuanꞌan ngataꞌa nunte ntiꞌi, ¿ngisen tjancheꞌe xa ixi xrokonda tsjenga na̱ ꞌna̱? ¿Á ni tjajnée xa o̱ ni tsiki̱ꞌxi̱n inaa tjajna? ");
INSERT INTO pps_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Ko jaꞌin juatingíexin ndo Pedro: ―Ni tsiki̱ꞌxi̱n inaa tjajna. Ko ndachro ndo Jesús: ―Sen tjajnée xrokondaꞌi tsjenga sen ꞌna̱. ");
INSERT INTO pps_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Ko ixi tjaunꞌa tsoñao na̱, itjia ti jii ndachaon ko tjankaꞌngia chika tséxinni kuchee̱ ko kuchee̱ saꞌó xrotsé, tantjeꞌe roꞌa ba, ko tsinchia naa tomi ko tomi meꞌe tjenga ꞌna̱ ti tikinixin janꞌan ko jaꞌa. ");
INSERT INTO pps_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","*Nchakon meꞌe sen teyuu chrikao ndo Jesús konchjiñeꞌe sen ngajin ndo ko juanchangiꞌe sen ndo: ―¿Ngisen ícha tsitee ngajní ti tetuanꞌan ndo Dio? ");
INSERT INTO pps_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Tjumeꞌe ndo Jesús kuiyeꞌe ndo naa chjan, ko bakeꞌe ndo xjan ngusine ti ste sen, ");
INSERT INTO pps_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","*ko ndachro ndo: ―Nduaxin ntatjunta ixi siá tjaunnta tsixinꞌinnta ti tetuanꞌan ndo Dio, xrokonda tsindoxinnta ko tsaxi sincheꞌenta xranchi ncheꞌe naa xjan nchíín. ");
INSERT INTO pps_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Ixi ti tetuanꞌan ndo Dio, sen ícha tjintee, nchejiéꞌa aséen sen xranchi naa chjan jiꞌi. ");
INSERT INTO pps_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Ko ngisen xrotjueꞌe ko tsayéꞌe sen naa chjan nchíín xranchi xjan jiꞌi, meꞌe nduaxin titikaonna sen, ko xrokjui xranchi xrokuayeꞌena sen janꞌan. ");
INSERT INTO pps_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","’Siá xrojan naa xjan nchíín titikaonna janꞌan, ko kondeexin xrojan chujni, xjan meꞌe xrojuincheꞌe xjan ti ndakoꞌa, ni meꞌe cháña xrotsé na̱ naa ixro ijié ti tontsingaxin ko xrokuintee na̱ ixro tusin na̱, ko xrokuitsingangi na̱ ndachaon ti yasoꞌe. ");
INSERT INTO pps_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Lastu nunte xasintajni ixi jii ngeꞌe sinchengachrue chujni ixi tsitikaonꞌa na̱ chijnie ndo Dio, ko lastu ni sinchekateya chujni ixi sincheꞌe na̱ ti ndakoꞌa. ");
INSERT INTO pps_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","*’Méxin siá kondeexin tjáanta o̱ tutáanta, jaꞌanta sincheꞌenta ti ndakoꞌa, cháña tonchrijinnta ko ndáꞌa tjankanta, ixi maski xrochondaꞌinta naa tjáanta o̱ naa tutáanta tsaricho̱nnta kain nchakon, ko xrochondanta yui tjáanta ko yui tutáanta ko jaña nchijíinta itsjinta ti jiche xroꞌi kain nchakon. ");
INSERT INTO pps_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","*Ko siá ti tsikon ikonnta, kondeexin meꞌe ncheꞌenta ti ndakoꞌa, cháña tantsjengi ikonnta ko ndáꞌa tjankanta, ixi maski ntakutsinnta, jaꞌanta tsaricho̱nnta kain nchakon. Ko yuxin ikonnta xrochondanta, jaña satsjinta ngangi xroꞌi ko ntiꞌa tsakeꞌenta kain nchakon. ");
INSERT INTO pps_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","*’Ndachroꞌanta ixi tjinteꞌa kaxin xjanchínchín jiꞌin, ixi xjan jiꞌin, sen ángel neꞌe xjan, sen ste ngajní ti jii Ndotána, jeꞌe sen tjanchia sen ixi jeꞌe xjan. ");
INSERT INTO pps_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Ixi Chjenꞌen ndo Dio, xjan jongíꞌe xranchi chujni, kui̱i̱ xjan bijée xjan chujni kuitjáña ko sincheméꞌe xjan jíee sen. ");
INSERT INTO pps_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","’¿Ngeꞌe chronta? Siá naa xi chónda naa ciento kutuchjon ko siá kuitjáña naa ba, ¿á tsintueꞌa xa ntiꞌa ti noventa y nueve ba ti jii ijna̱ ko tjumeꞌe tsijée xa iko kuitjáña? ");
INSERT INTO pps_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Ko siá tsitja xa kutuchjon meꞌe, á jeꞌa ícha tsakeꞌe xa juaxruxin ixi kuitja xa iko kuitjáña ixi kain iko kuitjáñaꞌi. ");
INSERT INTO pps_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Jaña kaxon Ndotána jii ngajní tjaunꞌa ndo tsitjáña ninaa xjanchíin jiꞌi. ");
INSERT INTO pps_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","*’Siá naa sen kichuunta xrojan ti ndakoꞌa juintaꞌanta sen, jaꞌanta ko sen meꞌe nichjeꞌe kichuunta ti jaꞌonta stenta, ixi ti ndakoꞌa juintaꞌanta sen. Siá kuitikaon sen ngeꞌe ndachronta, jaꞌanta juachanta naa sen kichuunta. ");
INSERT INTO pps_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ko siá sen meꞌe kuitikaonꞌa sen, tiyeꞌenta naa o̱ yuu sen kichuunta ixi sen meꞌe tsinꞌen sen ngeꞌe tsjaonta ko ngeꞌe sinchekonchjiannta. ");
INSERT INTO pps_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ko sen ningakonꞌannta, siá tsitikaonꞌa sen sen kuiyeꞌenta, tjumeꞌe ndachenta sen niꞌngo, ko siá tsitikaonꞌa sen kaxon, tjumeꞌe índachroꞌanta ixi sen meꞌe kichuunta sen, sen meꞌe ó ikjan sen xranchi naa chujni tjáka tomie xi Roma ko chúxinꞌa na̱ ndo Dio. ");
INSERT INTO pps_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","*’Ko nduaxin ndachrja̱n ixi siá tsajonꞌanta juachaxin xroxindanga ijie̱ yama naa chujni ntiꞌi ngataꞌa nunte xasintajni, kaxon ngajní ti jii ndo Dio, jeꞌe ndo tsajonꞌa ndo juachaxin tsoméꞌe ijie̱ meꞌe, ko kain ti tsajonnta juachaxin ixi tsoméꞌe ti ndakoꞌa juintaꞌanta na̱ ntiꞌi ngataꞌa nunte xasintajni, kaxon ndo Dio sincheméꞌe ndo ijie̱ chónda na̱. ");
INSERT INTO pps_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","’Kaxon ntatjunta ixi siá yuu jaꞌanta ngataꞌa nunte ntiꞌi ndako xronichjeꞌe kichuunta ixi xrojan ngeꞌe tsjancheꞌenta Ndotána jii ngajní, Ndotána jii ngajní, jeꞌe ndo tsajon ndo ngeꞌe tsjanchianta. ");
INSERT INTO pps_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Ixi ti no ste yuu o̱ níi sen titikaonna, ntiꞌa tsakeꞌe janꞌan ngusine ti ste sen. ");
INSERT INTO pps_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","*Tjumeꞌe konchjiñeꞌe ndo Pedro ko juanchangiꞌe ndo ndo Jesús: ―Nchána, ¿ngijanꞌin sintamaꞌa ngaya aséenna ngeꞌe ti ndakoꞌa juinchena sen kichian? ¿Á jeꞌo jaña ya̱a̱to̱ vez? ");
INSERT INTO pps_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Meꞌe juatingíexin ndo Jesús ko ndachro ndo: ―Naꞌi, jeꞌa jeꞌo ya̱a̱to̱. Janꞌan ndachrja̱n níi ti kán ko naa ti te tsoméꞌe ngaya asáan ti juintaꞌa sen. ");
INSERT INTO pps_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","’Ti no tituanꞌan ndo Dio meꞌe xranchi naa nunte ijié tetuanꞌan naa xi rey ko tjaun xa sinchéñakaꞌo xa xinchexrée xa cuenta. ");
INSERT INTO pps_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Ko kuaxi xa nchéña xa cuenta ko hora meꞌe bikaꞌo na̱ naa xi tsango itsjé sínká. ");
INSERT INTO pps_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ko xi sínká meꞌe chóndaꞌi xa tomi tsjengaxin xa ꞌna̱ ti sínká xa, méxin xi rey kuetuanꞌan xa ixi tsochji xi sínká ko janchriꞌe xa ko chjenꞌen xa ngajin ni teꞌna chujni ko ti tjintee chónda xa tsochji kaxon xroxengaxin ꞌna̱ ti sínká xa. ");
INSERT INTO pps_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Ko xi sínká bakeꞌexin ntatuchiꞌin xa ngajin xi rey, ko kuinóatée xa ko ndachro xa: “Chona̱ninta ko janꞌan tsjengaꞌanta ꞌna̱ kain ti tasinkaꞌanta.” ");
INSERT INTO pps_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Ko xi rey bikonóeꞌe xa xi sínká ko juincheméꞌe xa kain ti sínká xi meꞌe, ko kuituanꞌan xa tsajanda na̱ xa ixi ó koméꞌe ti sínká xa. ");
INSERT INTO pps_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Ko sakjui xa ko hora meꞌe kuetan xa inaa xi nchekao xa ixra̱, ko xi meꞌe tsjéꞌa sínká xa ngajin xi koméꞌe ti kuasínká xa ngajin xi rey. Ko xi koméꞌe ti sínká, soji itsé xa tusin xi sinkeꞌe xa ko ndachro xa: “¡Tjénga̱nana ꞌna̱ ti tasinkana̱na!” ");
INSERT INTO pps_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Ko xi nchekao xa xra bakeꞌexin ntatuchiꞌin xa ngajin xi koméꞌe ti sínká ko kuinóatée xa: “Tikonóanana ko janꞌan tsjengaꞌa ꞌna̱ kain ti tjasínkáꞌa.” ");
INSERT INTO pps_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Ko xi koméꞌe ti sínká chroꞌa xa ko kuetuanꞌan xa ixi tsijeꞌe̱ xi sinkeꞌe xa ngaxinꞌin ndoꞌachjiso ko tsachrjexinꞌa xa ntiꞌa hasta ti tsjengaja xa ꞌna̱ kain ti sínká xa. ");
INSERT INTO pps_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Ko ikaxin xi nchekao xa ixra̱ bikon xa ngeꞌe juincheꞌe xi koméꞌe ti sínká, meꞌe tsango juincheniꞌe aséen xa, méxin kuintekji xa ngajin xi rey ko chronga xa ngeꞌe juincheꞌe xi koméꞌe ti sínká. ");
INSERT INTO pps_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Tjumeꞌe xi rey kuetuanꞌan xa tsixrakua xi koméꞌe ti sínká ko jaꞌin ndachro xa: “Jaꞌa ti kuancheꞌe xra̱na, tsango ñaꞌia jaꞌa, ixi janꞌan juintamáꞌa kain ti kuasínkáꞌna̱na ixi jaꞌa kuinóatáa ngajin. ");
INSERT INTO pps_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Kaxon jaꞌa xrobikonuéꞌé xi kuanchekua ixra̱ xranchi janꞌan bikonóaꞌa jaꞌa.” ");
INSERT INTO pps_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Tjumeꞌe xi rey kuetuanꞌan xa tsikaon xi ñaꞌi ko tsjengaja xa ꞌna̱ kain ti sínká xa. Jaña ichro xi rey ixi tsango koñao xa. ");
INSERT INTO pps_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Ndo Jesús juexin kueki ndo chijni jiꞌi, meꞌe ndachro ndo: ―Jaña kaxon Ndotána jii ngajní sintaꞌanta ndo ngujngu jaꞌanta siá jeꞌa nduaxin sincheméꞌenta ngaya asáanta ti ndakoꞌa juintaꞌanta sen kichuunta. ");
INSERT INTO pps_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Juexin nichja ndo Jesús kain jiꞌi, tjumeꞌe sakjui ndo nunte Galilea ko kuiji ndo tjajna Judea, nunte jii chjuya ti jii indajitinga ndatinꞌin Jordán. ");
INSERT INTO pps_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Ntiꞌa kueya chujni ruéꞌe ndo ko itsjé ni niꞌe juinchexruenꞌen ndo. ");
INSERT INTO pps_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Ko tjumeꞌe kaxin xi fariseo konchjiñeꞌe xa ngajin ndo Jesús ko juanchangiꞌe xa ndo ixi tjaun xa ndakoꞌa xrojuatingíexin ndo, ko jaꞌin ndachro xa: ―¿Á chao jañao naa xi tsintuꞌe xa nchrinchriꞌe xa maski nchrinchriꞌe xa xroꞌan ngeꞌe ti ndakoꞌa juincheꞌe nchra? ");
INSERT INTO pps_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Ko ndo Jesús jaꞌin juatingíexin ndo: ―¿Á kuangiꞌanta ngeꞌe ndachro xroon chijnie ndo Dio?, ixi “jeꞌe ndo juinchéña ndo kain chujni, xi ko nchri juinchéña ndo.” ");
INSERT INTO pps_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Ko kaxon ndachro ndo: “Méxin chujni xi tsintuꞌe xa ndotée xa ko janée xa ko tsuteꞌe xa nchrinchriꞌe xa ko yui jeꞌe na̱ í jeꞌa yuu na̱, ixi ó xranchi xrokjui naakua naa chujni.” ");
INSERT INTO pps_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Méxin í jeꞌa yuu na̱. Naꞌi. Jai ó xranchi naakua naa chujni, méxin xroꞌan chujni tsonchjeya ni kuteꞌe, ni chjée ndo Dio juachaxin tsekao kichuu na̱. ");
INSERT INTO pps_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","*Ko xi fariseo juanchangiꞌe xa ndo: ―¿Sonda tjumeꞌe ndo Moisés kuajon ndo juachaxin tsoña̱ naa xroon ko xroon meꞌe xronichja ixi chao tsintuꞌe kichuu na̱? ");
INSERT INTO pps_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Ko ndo Jesús ndachro ndo: ―Ndo Moisés kuajon ndo juachaxin tsonchjian xroon xrochjeyaxin xi ko nchri, ni stekao kichuu, ixi chujni tsango icha aséen na̱ko tjaunꞌa na̱ tsitikaon na̱ chijnie ndo Dio. Ko ti nchakon xrangíxixión kain ngeꞌe, kuancheꞌa na̱ jaña. ");
INSERT INTO pps_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","*Méxin, janꞌan ndachrja̱n siá xrojan jaꞌanta tjaunnta tsintuꞌenta janchriꞌanta ko siá janchriꞌanta juitéxinꞌa jan inaa xi, jaꞌanta juaꞌi tsintuꞌenta jan ko chondaꞌinta juachaxin ixi tsutaꞌanta inaa nchri. Ko siá sincheꞌenta jaña, jaꞌanta tsamanta ijie̱. Kaxon ngixeꞌi naa xi tsuteꞌe naa nchri, nchri kuayéꞌe xroon chjeyaxin chujni, xi meꞌe tsama xa ijie̱ kaxon. ");
INSERT INTO pps_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Tjumeꞌe sen teyuu chrikao ndo Jesús ndachro sen: ―Siá ni tintekuteꞌe jaña ncheꞌe na̱, cháña tsuteꞌani. ");
INSERT INTO pps_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Méxin ndo Jesús ndachro ndo: ―Chijni jiꞌi kainꞌa sen tienxin sen chijni. Jeꞌo tienxin sen chjée ndo Dio juachaxin ixi tsuteꞌa sen. ");
INSERT INTO pps_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Nduaxin jiꞌi, kaxin xi juaꞌi tsuteꞌe xa, ixi ti xratsijongíexión xa juaꞌi tsuteꞌe xa. Ikaxin xa juincheniꞌe na̱ xa, méxin juaꞌi tsuteꞌe xa, ko jii ikaxin sen tjaunꞌa sen tsuteꞌe sen ixi tjaun sen sincheꞌe sen ixra̱ ngajin ndo Dio, méxin ti rintakuanꞌannta jai jeꞌo tsienxin sen tjaun sincheꞌe jaña. ");
INSERT INTO pps_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Tjumeꞌe bikaꞌo na̱ kaxin ichjan ixi tjaun na̱ tsakeꞌe itja ndo Jesús ngataꞌa xjan ko xronichjeꞌe ndo ndo Dio ixi jeꞌe xjan. Ko sen teyuu chrikao ndo Jesús kuyakutee sen ni bikaꞌo xjan. ");
INSERT INTO pps_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Ko jeꞌe ndo Jesús ndachro ndo: ―Tintuꞌenta ichjan tsi̱i̱ xjan ngajin ko tingakuenꞌanta xjan ixi sen sincheꞌe xranchi ncheꞌe naa ichjan, sen meꞌe tikinixinꞌen sen tixinꞌin sen ngajní ti tetuanꞌan ndo Dio. ");
INSERT INTO pps_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Juexin bakeꞌe itja ndo ngataꞌa xjan, sakjuixin ndo ntiꞌa. ");
INSERT INTO pps_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Naa chajan kui̱i̱ chán kuitsjeꞌe chán ndo Jesús ko juanchangiꞌe chán ndo: ―Jaꞌanta ti nchekuenꞌennta chujni tsango jiannta, ¿ngeꞌe xrokonda sintaꞌa ixi tsayáꞌa̱ juachaxin tsarichón kain nchakon? ");
INSERT INTO pps_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Ko jeꞌe ndo jaꞌin juatingíexin ndo: ―¿Sonda ndachrua ixi janꞌan jianna? Jeꞌo ndo Dio, jeꞌe ndo jian ndo. Ko siá tjauan nduaxin tsarichuan, xrokonda tsitikaoan chijnie ndo Dio. ");
INSERT INTO pps_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Ko jeꞌe chán ndachro chán: ―¿Ngixeꞌe chijni meꞌe? Ko ndo Jesús ndachro ndo: ―Koꞌa juachaxin naatsóñaxuan naa chujni, koꞌa juachaxin tsixintexian naa nchri chónda xixiꞌe, koꞌa juachaxin ixi tse̱ꞌe̱, juaꞌi sincheya ixi sincheniꞌe inaa chujni. ");
INSERT INTO pps_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Chóndeꞌe juasaya ndotáa ko janáa, kaxon tjueꞌé chujni xranchi tjueꞌe asáan. ");
INSERT INTO pps_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Ko jeꞌe chán ndachro chán: ―Kain chijni jiꞌin kuitikaꞌon xrachiona. ¿Ngeꞌe ícha titjáña sintaꞌa? ");
INSERT INTO pps_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Ko ndo Jesús juatingíexin ndo: ―Siá nduaxin tjauan sinchetjúá asáan, nchekjia kain ngeꞌe tjintee chonda, ko tonchjiyeꞌe sen nóa kain tomia. Ko meꞌe xrochónda ti tjintee jii ngajní. Tjumeꞌe tsjiꞌia ko xrokjan jaꞌa naa sen ruaꞌna. ");
INSERT INTO pps_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Ko kuinꞌen chán jaña, tsango koniꞌe aséen chán, sakjui chán ixi tsango itsjé ngeꞌe ti tjintee chónda chán. ");
INSERT INTO pps_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Tjumeꞌe ndo Jesús ndache ndo sen teyuu chrikao ndo: ―Nduaxin xrontatjunta ixi tsango tangi tsixinꞌin ngajní ti tetuanꞌan ndo Dio, naa chujni chónda itsjé tomi. ");
INSERT INTO pps_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ko nduaxin ntatjunta ixi ícha tangiꞌa tsixinꞌin naa kucamello ikon naa ntachika, ixi naa chujni chónda itsjé tomi tixinꞌin ti tetuanꞌan ndo Dio. ");
INSERT INTO pps_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Ko sen teyuu chrikao ndo kuinꞌen sen ngeꞌe nichja ndo, tsango kuiyeꞌe ñao sen, ko juanchangiꞌe kichuu sen: ―¿Ngisen tsjacha tsechón kain nchakon tjumeꞌe? ");
INSERT INTO pps_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Ko ndo Jesús jitsjeꞌe ndo sen, meꞌe ndachro ndo: ―Chujni juaꞌi tsechón na̱ kain nchakon. Jeꞌo ndo Dio tajon ndo juachaxin tsechón chujni. ");
INSERT INTO pps_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Tjumeꞌe ndo Pedro ndachro ndo: ―Nchána, janꞌanna kuintuꞌana kain ti kuachondana ko ruaꞌananta. ¿Janꞌanna ngeꞌe tsjachana? ");
INSERT INTO pps_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","*Ko ndo Jesús juatingíexin ndo: ―Nduaxin ntatjunta nchakon tsi̱i̱ tsoña̱ natjúá kain ngeꞌe, nchakon Chjenꞌen ndo Dio, xjan tsijongíꞌe xranchi chujni, tsakeꞌe xjan nunte ngataꞌa ntaxitaon ti tsetuanxin xjan ko tsjako xjan ti ijié juachaxin chonda xjan, tjumeꞌe kaxon jaꞌanta ti rueꞌénta xjan xrochondanta teyuu ntaxitaon tsituanxinnta ko sinchéñaxinnta ijie̱ ngajin ti teyuu tjajna neꞌe Israel. ");
INSERT INTO pps_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ko kain sen kuintuꞌe ndoꞌa, ko sen kuintuꞌe ndo kichuu ko jan kichuu, ndotée o̱ janée, janchriꞌe o̱ chjenꞌen o̱ nunteꞌe ixi kuitikaonna sen ko ruaꞌna sen janꞌan, sen meꞌe tsango itsjé ngeꞌe tsayéꞌe sen ko kaxon tsechón sen kain nchakon. ");
INSERT INTO pps_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","*Ko kueya sen jai tsango tetuanꞌan sen, nchakon meꞌe ítsetuanꞌi sen. Ko kueya sen tjinteꞌa jai, nchakon meꞌe jeꞌe sen ícha tsetuanꞌan sen. ");
INSERT INTO pps_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","’Ngajní tetuanxin ndo Dio meꞌe tonoxin xranchi naa xi chónda naa ijngi tsango ijié ko ndúyo kuachrje xa bijée xa kaxin xinchexra̱ ixi tsikonchrijin xa tu uva. ");
INSERT INTO pps_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ko kuitja xa xinchexra̱ ko konchjiankaꞌo kichuu xa ko xroxengeꞌe xa ꞌna̱ naa tomi ndatinꞌin denario ngujngu nchakon ko tjumeꞌe xruanꞌan xa xinchexra̱ ngataon ijngi. ");
INSERT INTO pps_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Ko kuachrje xa hora na̱a̱ neꞌe nchakon ko bikon xa ikaxin chujni jii ngusine tjajna ko chóndaꞌi na̱ ixra̱. ");
INSERT INTO pps_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Ko ndache xa na̱: “Itjinta tikonchrijinnta tu uva ko jian tsjengaꞌanta ꞌna̱.” Ko jeꞌe na̱ ikjui na̱. ");
INSERT INTO pps_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Tjumeꞌe ngusine nchakon bijée xa ikaxin xinchexra̱, ko kaxon ti hora nínxin neꞌe nchakon kuachrje xa juée xa xinchexra̱. ");
INSERT INTO pps_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Ko kóndo kaxon kuachrje xa hora naꞌó, ikjui xa ngusine tjajna ko kuitja xa ikaxin ninchexra̱, ni xroꞌan stencheꞌe ko ndachro xa: “¿Sonda stenta ntiꞌi nguixin nchakon ko xroꞌan ixra̱ stencheꞌenta?” ");
INSERT INTO pps_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","’Ko jeꞌe na̱ ndachro na̱: “Ixi xroꞌan ngisen chjána̱na ixra̱, méxin ntiꞌi stena.” Ko jeꞌe xa ndachro xa: “Itjinta ncheꞌenta xra̱na ko jian tsjengaꞌanta ꞌna̱.” ");
INSERT INTO pps_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Ko ó kontie ko xi chjakée ndache xa xi tetuenꞌen xinchexra̱: “Tiyeꞌé xinchexra̱ ko tjengeꞌé xa ꞌna̱, tjangíxinxian tjengeꞌé ꞌna̱ xi kjui ó kóndo ko tsjexixin xi kjui ndúyo.” ");
INSERT INTO pps_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Ko saꞌó konchjiñeꞌe xi kuixinꞌin xra̱ hora naꞌó ko ngujngu xa kuayéꞌe xa naa tomi denario. ");
INSERT INTO pps_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Tjumeꞌe konchjiñeꞌe xi kuaxi xra̱ ndúyo ko xraxaon xa ixi jeꞌe xa xrojuacha xa ícha itsjé tomi, ko xrajeꞌo kuayéꞌe xa naakua tomi denario. ");
INSERT INTO pps_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Ko hora kuayéꞌe xa tomi, bakeꞌa xa juaxruxin ti juacha xa. ");
INSERT INTO pps_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Ko ndachro xa: “Ni kui̱i̱ ó kóndo naakua hora juincheꞌe na̱ xra̱ ko kaxon xengeꞌe na̱ ꞌna̱ xrajeꞌo xranchi juacha janꞌanna ti juintaꞌana ixra̱ nchijíi nchakon ngataon súa.” ");
INSERT INTO pps_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Ko xi xrée jaꞌin juatingíexin xa: “Janꞌan ndako rintaꞌa, joi̱na ixi xrojuengaꞌanta ꞌna̱ naa denario ko jaña kuayeꞌenta. ");
INSERT INTO pps_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Itsenta tomianta ko satjinta. Janꞌan tjaꞌon xrotjáꞌa xi kui̱i̱ ó kóndo xrajeꞌo xranchi jaꞌanta. ");
INSERT INTO pps_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Janꞌan, ¿á chondaꞌi juachaxin ixi xrotjáꞌa ngisen tjaꞌon tomina? O̱, ¿jitochjuyaꞌanta ixi ti jian rintaꞌa janꞌan?” ");
INSERT INTO pps_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","*Méxin, jaꞌin xrondachro chijni jiꞌin: ni kui̱i̱ ícha tjumeꞌe, ni meꞌe ícha saꞌó tsayéꞌe na̱ ti jian, ko ni kui̱i̱ ícha saꞌó, ni meꞌe ícha tjumeꞌe tsayéꞌe na̱ ti jian tsajon ndo Dio ixi itsjé ni tsonchjiñeꞌe ko kaxion ni tsincheꞌe ndo. ");
INSERT INTO pps_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Hora sakjui ndo Jesús tjajna Jerusalén, kuachrjendaxin ndo ti ste chujni, jeꞌe ndo ko sen teyuu chrikao ndo ko ndache ndo sen: ");
INSERT INTO pps_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","―Jai stetajinꞌina tjajna Jerusalén ko ntiꞌa xrotsé na̱ Chjenꞌen ndo Dio, xjan jongíꞌe xranchi chujni, ko tsajon na̱ xjan ngajin xitaana tetuanꞌan ko xi tjako ley neꞌe ndo Dio, ko tsjankataꞌa na̱ xjan ijie̱ ko xrondachro na̱ tsenꞌen xjan. ");
INSERT INTO pps_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Ko tsajon na̱ xjan ngajin xi kui̱xi̱n inaa tjajna ko ni meꞌe tsjanoa na̱ xjan ko tsikaon xjan ko tsasintjian na̱ xjan ko ntiꞌa tsenꞌen xjan ko nchakon nínxin xroxechón xjan. ");
INSERT INTO pps_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Tjumeꞌe janée ndo Jacob ko ndo Juan, chjenꞌen ndo Zebedeo, jeꞌe jan ko yui chjenꞌen jan konchjiñeꞌe sen ngajin ndo Jesús ko bakeꞌexin jan ntatuchiꞌin jan ngajin ndo Jesús ko kuinóatée jan ngajin ndo. ");
INSERT INTO pps_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Ko ndo Jesús juanchangi ndo: ―¿Ngeꞌe tjauan? Jeꞌe jan ndachro jan: ―Tjaꞌon ixi nchakon tsakeꞌenta nunte ngataꞌa ntaxitaunnta ko tsjakonta ijié juachaxin, tájonnta juachaxin ixi yui chjanꞌna tsakeꞌe xjan ti tsakeꞌe jaꞌanta, naa xjan ndatsjonxin jian ko naa xjan ndatsjonxin ikjon. ");
INSERT INTO pps_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Tjumeꞌe ndo Jesús ndachro ndo: ―Jaꞌanta noaꞌinta ngeꞌe tjanchianta. ¿Á chao jaꞌanta tsiꞌinta ti tsango itsjá tsiꞌi janꞌan ko ti itsjá meꞌe xrondachro ti chinga sinchena̱na ko tsintji jnina ko tsenꞌenna? Tjumeꞌe sen teyuu chrikao ndo ndachro sen: ―Jaán, chao. ");
INSERT INTO pps_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Tjumeꞌe ndachro ndo Jesús: ―Jaán, nduaxin jaꞌanta tsango chinga sintaꞌanta na̱ xranchi sinchena̱na janꞌan, ko ti tsakeꞌenta ndatsjonxin jian o̱ ndatsjonxin ikjon, jeꞌo Ndotána tikinixinꞌen ndo xrondachro ndo ngisen tsayéꞌe juachaxin meꞌe. ");
INSERT INTO pps_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Ko hora kuinꞌen sen ite chrjikao ndo Jesús, koñao sen ngajin ndo Jacobo ko ndo Juan. ");
INSERT INTO pps_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","*Tjumeꞌe ndo Jesús kuiyeꞌe ndo kain sen chrikao ndo ko ndachro ndo: ―Jaꞌanta noꞌanta ixi xi tetuanꞌan tjajna, jeꞌe xa tituenꞌen xa chujni ko xroꞌan ngeꞌe ncheꞌe chujni siá xi tituanꞌan tsajonꞌa xa juachaxin ko xi tsango tituanꞌan chujni xrokonda tsitikaon na̱ ngeꞌe tituanꞌan xa. ");
INSERT INTO pps_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","*Ko jaꞌanta juaꞌi sincheꞌenta jaña xranchi ncheꞌe jeꞌe na̱. Naꞌi. Siá xrojan jaꞌanta tjaunnta tsituanꞌannta ícha, saꞌó xrokonda tsitikaonnta ngeꞌe tsetuanꞌannta sen kichuunta. ");
INSERT INTO pps_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Ko ngixeꞌi jaꞌanta ti tjaunnta ícha tsetuanꞌannta, xrokonda tayakonꞌennta sen kichuunta ko xroꞌan ngeꞌe tsjachanta. ");
INSERT INTO pps_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Jaña kaxon Chjenꞌen Dio, xjan jongíꞌe xranchi chujni, kuiꞌa xjan ixi chujni sincheꞌe ixra̱ ngajin xjan. Naꞌi. Jeꞌe xjan kui̱i̱ xjan ixi tayakonꞌen xjan chujni ko tsenꞌen xjan ixi jaña tsantsjengíꞌe xjan ijie̱ chónda chujni. ");
INSERT INTO pps_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Ko kuachrjexin sen tjajna Jericó, itsjé chujni ruéꞌe ndo Jesús. ");
INSERT INTO pps_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Ko yuu ni tikonꞌa ste na̱ nunte ngandeꞌe chaꞌo ko kuinꞌen na̱ ixi jitatsinga ndo Jesús, meꞌe kuaxi kuyako na̱: ―Nchána, xjan kuachrjenixin ndo David, tikonóaꞌnaninta. ");
INSERT INTO pps_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Ko chujni kuyakutee na̱ ni tikonꞌa ixi xrotenko na̱ ko jeꞌe na̱ ícha séen kuyako na̱: ―Nchána, xjan kuachrjenixin ndo David, tikonóaꞌnaninta. ");
INSERT INTO pps_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Tjumeꞌe ndo Jesús kuíxin ndo, ko kuiyeꞌe ndo ni tikonꞌa ko juanchangiꞌe ndo na̱: ―¿Ngeꞌe tjaunnta sintaꞌa? ");
INSERT INTO pps_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ko jeꞌe na̱ juateꞌe na̱: ―Nchána, tjaꞌonna tsikonna. ");
INSERT INTO pps_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Ko ndo Jesús bikonóeꞌe ndo na̱ ko bakeꞌe itja ndo ngataꞌa ikon na̱. Ko tuinxin bikon na̱ ko kaxon jeꞌe na̱ ruéꞌe na̱ ndo. ");
INSERT INTO pps_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Ndo Jesús ko sen teyuu chrikao ndo kuiji sen ó tjenka tjajna Jerusalén, naa tjajna Betfagé, ntiꞌa jii ijna̱ ndatinꞌin Olivo, ko ndo Jesús kuetuenꞌen ndo yuu sen chrikao ndo, ");
INSERT INTO pps_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","ko ndachro ndo: ―Itjinta tjajna jiꞌa, ntiꞌa tsinchíinta naa kuntajno, kunchri, jichroá ba ko naa kuntajnochjan jikao ba. Tonxindangeꞌenta ba ko tsikuunta yui ba. ");
INSERT INTO pps_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Ko siá xrojan ngisen tsjanchangiꞌanta sonda satikuꞌunta ba, jaꞌanta ndachronta: “Ncháina xrokondeꞌe ba ko tsjexin tsondeꞌe ndo ba, jeꞌe ndo tsituanꞌan ndo tsikianna ba.” ");
INSERT INTO pps_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Jaña konꞌen ixi jaña ó tsikjin naa ndo kuachronga chijnie ndo Dio ó saꞌó, ko jaꞌin tsindachro ndo: ");
INSERT INTO pps_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Ndachenta chujni tjajna Sión: “Tsjeꞌenta ndo rey naꞌanta ó kui̱i̱ ndo ngajinnta, ko jeꞌe ndo nchejiéꞌa aséen ndo, naa kuntajno jitaꞌa ndo, naa kuntajnochjan, chjenꞌen naa kuntajno, ko tama.” Jaña jitaxin xroon chijnie ndo Dio ó saꞌó. ");
INSERT INTO pps_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Ko sen chrikao ndo, ikjui sen, juincheꞌe sen ti kuetuanꞌan ndo Jesús. ");
INSERT INTO pps_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Ko bikaꞌo sen kuntajno ko chjenꞌen ba, ko bakeꞌe sen manta jitsáa sen ngataꞌa ba, tjumeꞌe jeꞌe ndo kuetaꞌa ndo ba. ");
INSERT INTO pps_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Ko tsango itsjé chujni ste ntiꞌa ko kuingo na̱ manta stetsáa na̱ ngataꞌa chaꞌo ko ikaxin na̱ konchrinjin na̱ chaan nta̱a̱ yua ko bingó na̱ ngatja chaꞌo kaxon. ");
INSERT INTO pps_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Ko kaxin chujni stetaon ko chujni steruéꞌe na̱ ndo Jesús ko jaꞌin stetoyako na̱: ―Ijié juachaxin tikinixinꞌen xjan kuachrjenixin ndo David. Tsango jian ndo kui̱xi̱n ixi juachaxien Ndotáina jii ngajní. Ijié juachaxin tsayéꞌe ndo. ");
INSERT INTO pps_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Hora kuixinꞌin ndo Jesús tjajna Jerusalén, kain chujni ste ntiꞌa xronka na̱ ko ndachro na̱: ―¿Ngisen jiꞌin? ");
INSERT INTO pps_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Ko itsjé na̱ ndachro na̱: ―Jiꞌi ndo Jesús chronga chijnie ndo Dio, ndo tjajna Nazaret tikinixinꞌen nunte Galilea. ");
INSERT INTO pps_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Ko ndo Jesús kuixinꞌin ndo ningue ndo Dio ko kuantsje ndo kain ni stenchekji ko ni teꞌna ngaxinꞌin niꞌngo. Ko konjamangi ndo nta̱a̱ jitaꞌa ngeꞌe nchekji na̱ ko ti tasingixin na̱ tomi ko ntaxitauen ni nchekji kuntúá. ");
INSERT INTO pps_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ko ndo Jesús ndachro ndo: ―Jaꞌin ndachro xroon chijnie ndo Dio tsikjin sen kuachronga ó saꞌó: “Nchanía, nchia nichjaxin chujni ngajin ndo Dio.” Jaña ndatinꞌin nchia, ko jaꞌanta juinchéñanta nchia tjaue xicheꞌe. ");
INSERT INTO pps_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Ko ngaxinꞌin niꞌngo konchjiñeꞌe ni ntakutsin, ni ntarengo ngajin ndo Jesús ko jeꞌe ndo juinchexruenꞌen ndo na̱. ");
INSERT INTO pps_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Ko kaxin xitaana tetuanꞌan ko xi tjako chijnie ndo Dio bikon xa kain ni juinchexruenꞌen ndo ko ngeꞌe juincheꞌe ndo ko kuinꞌen xa kaxin ichjan stetsje̱ xjan ngaxinꞌin niꞌngo, ko jaꞌin ichro ti stetsje̱ xjan: “Ijié juachaxin tikinixinꞌen ndo kuachrjenixin ndo rey David.” Ko xi stetinꞌen tsango koñao xa ");
INSERT INTO pps_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","ko jaꞌin ndache xa ndo: ―¿Á ritinꞌén ngeꞌe stetsje̱ xjan jiꞌin? Ko jeꞌe ndo ndachro ndo: ―Jaán, ¿jaꞌanta á noaꞌinta ngeꞌe ndachro xroon chijnie ndo Dio? Ko jaꞌin ndachro xroon: Roꞌa xjan nchínchín ko xjan stetaki bakéenta ti juasaya jian xrotsje̱ xjan. ");
INSERT INTO pps_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Tjumeꞌe jeꞌe ndo kuachrjexin ndo tjajna Jerusalén sakjui ndo tjajna Betania ko ntiꞌa jokeꞌe ndo tiie meꞌe. ");
INSERT INTO pps_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Ndúyo kua sen chaꞌo ko ikjan sen tjajna Jerusalén ko ndo Jesús kuenꞌen ndo jinta. ");
INSERT INTO pps_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ko bikon ndo naa nta̱a̱ tu higo ngandeꞌe chaꞌo ko konchjiñeꞌe ndo ti jii nta̱a̱, ko xroꞌan itu kuitja ndo, jeꞌo ika chónda nta̱a̱. Méxin ndache ndo nta̱a̱: ―Kainko nchakon xroꞌan itu xrochónda. Ko nta̱a̱ tu higo tuinxin xema nta̱a̱. ");
INSERT INTO pps_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Ko sen teyuu chrikao ndo Jesús bikon sen ngeꞌe konꞌen nta̱a̱, meꞌe xronka sen ko juanchangiꞌe sen ndo: ―¿Sonda tuinxin xema nta̱a̱ tu higo? ");
INSERT INTO pps_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","*Ko ndo Jesús ndachro ndo: ―Nduaxin ntatjunta siá nduaxin xrochuntianta ko xroꞌan ngeꞌe sinchengachrue asáanta, jeꞌa jeꞌo xranchi konꞌen nta̱a̱ tu higo, chao sincheꞌenta. Jaꞌanta chao xronichjeꞌenta ijna̱ jiꞌin ko jaꞌin xrondachenta jna̱: “Satjixian ntiꞌi ko taritsingaꞌngia ndachaon”, ko jaña tsonꞌen. ");
INSERT INTO pps_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Ko kain ngeꞌe tjaunnta, siá xronichjeꞌenta ndo Dio ko nduaxin xrochuntianta ngajin ndo, nduaxin tsayeꞌenta ngeꞌe tsjanchianta. ");
INSERT INTO pps_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Tjumeꞌe ndo Jesús kuixinꞌin ndo niꞌngo, ko juinchekuenꞌen ndo chujni, meꞌe konchjiñeꞌe kaxin xitaana tetuanꞌan ko kaxon kaxin xi judío, xi ícha tetuanꞌan, ko juanchangiꞌe xa ndo: ―¿Ngeꞌe juachaxin chonda jaꞌa ixi jaꞌin ncheꞌe ko ngisen tjáa juachaxin? ");
INSERT INTO pps_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Ko jaꞌin juateꞌe ndo Jesús: ―Kaxon janꞌan tsjanchangiꞌanta naa ngeꞌe ko siá tsjatingíexinnta ngeꞌe tsjanchangiꞌanta, janꞌan kaxon xrontatjunta ngisen chjána juachaxin. ");
INSERT INTO pps_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Ndo Juan ti kuikitée chujni, ¿no kui̱xi̱n juachaxin meꞌe? ¿Á ngajní o̱ chujni kuituanꞌan? Tjumeꞌe jitjakaxin kichuu xa ko stendachro xa: ―Siá xrondachrona ixi ndo Dio tsiketuenꞌen xi Juan, xrondachro xi jiꞌi: “¿Sonda kuitikaonꞌanta ti ndachro xi Juan?” ");
INSERT INTO pps_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ko siá xrondachrona ixi chujni, kain ni tjajna tsoñao na̱ ixi xi Juan ndachro na̱ nichja xa chijnie ndo Dio. ");
INSERT INTO pps_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Tjumeꞌe juatingíexin xa: ―Nónaꞌina ngisen. Ko ndo Jesús ndachro ndo: ―Janꞌan kaxon xrontatjuꞌinta ngisen chjána juachaxin rintaꞌa jiꞌi. ");
INSERT INTO pps_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Tjumeꞌe ndachro ndo Jesús: ―¿Ngeꞌe ndachronta ixi ti tsekiꞌanta? Bakeꞌe naa xi ko xi meꞌe chónda xa yuu chájeꞌen xa, ko saꞌó konchjiñeꞌe xa ngajin naa chájeꞌen xa ko ndachro xa: “Itjia ncheꞌé ixra̱ chjaka ti jii nta̱a̱ tu uva.” ");
INSERT INTO pps_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Ko juateꞌe chán: “Naꞌi, tjaunꞌa itsji”, ichro chán. Ko tjumeꞌe kuindoxin chán ti jixraxaon chán ko kuitikaon chán ti ndachro ndotée chán. ");
INSERT INTO pps_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Ko tjumeꞌe kuitsjeꞌe xa inaa chájeꞌen xa ko xrajeꞌo kuetuenꞌen xa chán itsji chán ngataon ijngi ti jii nta̱a̱ tu uva ko juateꞌe chán: “Janꞌan chao itsji”, ichro chán. Ko juiꞌa chán. ");
INSERT INTO pps_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Tjumeꞌe juanchangi ndo Jesús: ―¿Ngixeꞌe ti yuu chajan kuitikaon chán ngeꞌe kuetuanꞌan ndotée chán? Ko jeꞌe sen ndachro sen: ―Chán saꞌó kuituenꞌen. Ko ndo Jesús ndache ndo sen: ―Ko nduaxin xrontatjunta ixi chujni tjanchia tomi xroxrajon ngajin xi tetuanꞌan ko nchri chónda kueya xi, ni meꞌe ícha saꞌó tsixinꞌin na̱ ti tetuanꞌan ndo Dio ko tjumeꞌe jaꞌanta. ");
INSERT INTO pps_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","*Ixi ndo Juan tikitée chujni, kui̱i̱ ndo ko jaꞌanta kuitikaonꞌanta ti chronga ndo, ko ni xengeꞌe ꞌna̱ ko nchri chónda kueya xi, ni meꞌe kuitikaon na̱ ti ndachro ndo. Ko jaꞌanta maski bikonta jaña, kuindoxinꞌanta ko kuitikaonꞌanta. ");
INSERT INTO pps_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Ndo Jesús ndachro ndo: ―Tsekiꞌanta inaa chijni. Xranchi naa xi kuenga itsjé nta̱a̱ tu uva ngaya chjakée xa. Ko juinchéñeꞌe xa nta̱a̱ tu uva naa korra, ko inge xa ti no tsáñaxin ndée tu uva. Kaxon juinchekonchjian xa naa nta̱a̱ ijié ti no xrotsjéxin xa nchijíi jngiꞌe xa. ’Ko tjumeꞌe juatoya xa nunte meꞌe ngajin kaxin ni ncheꞌe ixra̱ ko nchakon xroxejo tu uva jeꞌe na̱ tsajon na̱ ti tikinixinꞌen xa ko tjumeꞌe sakjui xa ikjín. ");
INSERT INTO pps_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Ko nchakon kuaxi xejo tu uva, xi nunteꞌe xruanꞌan xa kaxin ni nchexrée xa tsjiruéꞌe na̱ tu uva ti tikinixinꞌen xa. ");
INSERT INTO pps_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Ko ni kuituꞌe ijngi chonda nta̱a̱ tu uva, ndakoꞌa juincheꞌe na̱ ixi itsé na̱ xi nchexrée xi nunteꞌe, naa xa bikaon xa, inaa xa naakóñaxón na̱ xa, ko inaa xa kuaxi na̱ xa ixro ko xroꞌan ngeꞌe kuajon na̱. ");
INSERT INTO pps_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Tjumeꞌe xi nunteꞌe xruanꞌan xa ikaxin xi nchexrée xa ko xrajeꞌo juinchekao na̱ ni meꞌe. ");
INSERT INTO pps_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","’Ko tjumeꞌe xruanꞌan xa chájeꞌen xa ixi xraxaon xa xrochóndeꞌe na̱ chán juasaya. ");
INSERT INTO pps_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Ko hora bikon na̱ cháchjenꞌen xi nunteꞌe, jaꞌin kuintejao na̱: “Chán ña̱ tsitueꞌe chán kain ngeꞌe chónda ndotée chán. Cháña naatsóñaxónna chán ixi jaña tsituei̱na kain ngeꞌe tikinixinꞌen chán.” ");
INSERT INTO pps_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Tjumeꞌe itsé na̱ cháchjenꞌen xi nunteꞌe ko kuantsjexin na̱ chán chjaka ko naakóñaxón na̱ chán. ");
INSERT INTO pps_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Tjumeꞌe ndo Jesús juanchangiꞌe ndo sen ste ntiꞌa: ―Nchakon tsi̱i̱ Nchée chjaka, ¿ngeꞌe sinchekao xa ni nchexra̱ ñaꞌi? ");
INSERT INTO pps_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Ko jeꞌe sen juatingíexin sen: ―Nchakon tsi̱i̱ nchée ijngi meꞌe tsikonóeꞌa xa ni ñaꞌi ko naatsóñaxón xa na̱, ko tsjée xa ikaxin xinchexra̱ tsitueꞌe chjaka ko ni meꞌe tsajon na̱ itu tikinixinꞌen xa. ");
INSERT INTO pps_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Ko ndachro ndo Jesús: ―¿Á juinchekuanxinꞌanta xroon chijnie ndo Dio tsikjin sen kuachronga ó saꞌó? Ixro chaxro jueñaoꞌa ni tiꞌte nchia, ko jai ixro meꞌe, ixro ícha tjintee tsikiꞌtexin nchia. Ko ndo Dio jaña juinchéña ndo, meꞌe ti chaxro stetikonna jai. Jaña ichro chijnie ndo Dio. ");
INSERT INTO pps_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","’Méxin xrontatjunta juachaxien ndo Dio tsachrjaꞌa jaꞌanta ko tsayéꞌe ikaxin chujni juachaxin meꞌe ko jeꞌe ni meꞌe jian tsitikaon na̱ ixi tsajon na̱ ngeꞌe tikinixinꞌen Ndo Dio. ");
INSERT INTO pps_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Ko ngisen tsitsingataꞌa ixro meꞌe naatsenxón sen, ko siá ixro meꞌe tsitsingataꞌa ixro naa chujni, naa tsontsingaxon chujni. ");
INSERT INTO pps_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Ko xitaana tetuanꞌan ko xi fariseo kuinꞌen xa chijni juakoxin ndo Jesús, meꞌe kuienxin xa ixi kondeexin jeꞌe xa ti ndachro ndo. ");
INSERT INTO pps_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Meꞌe tjaun xa xrotsé xa ndo Jesús ixi tsijeꞌe̱ xa ndo, ko juaꞌi juincheꞌe xa ixi ni tjajna ndachro na̱ ixi jeꞌe ndo Jesús nichja ndo chijnie ndo Dio. ");
INSERT INTO pps_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Íjngo ndo Jesús kuaxi juako ndo ixi chijni ko ndachro ndo: ");
INSERT INTO pps_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","―Ti no tetuanꞌan ndo Dio meꞌe xranchi naa chijni nichja ixi naa ndo rey juinchéña ndo naa kia ixi tsuteꞌe chjenꞌen ndo. ");
INSERT INTO pps_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Ko xruanꞌan ndo xi nchexrée ndo tsikiyeꞌe xa chujni tsi̱i̱ na̱ kia; ko ni meꞌe chroꞌa na̱ kui̱i̱ na̱. ");
INSERT INTO pps_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Ko íjngo kuetuenꞌen ndo xi nchexrée ndo ko ndachro ndo: “Ndachenta na̱ ixi ó konchjian ti sine na̱, kain iko juntao ó kuenꞌen ba ko kain ngeꞌe ó chao jii tsintekii na̱ kia”, jaña kuetuanꞌan ndo rey. ");
INSERT INTO pps_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Ko ni kuiyeꞌe ndo kia kuitikaonꞌa na̱. Naa xi kuiyeꞌe ndo sakjui xa chjakée xa ko inaa xa sakjui xa kuitsjeꞌe xa ixra̱ chónda xa. ");
INSERT INTO pps_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Ko ikaxin na̱ itsé na̱ xi bikao juajnée ndo rey ko bikaon xa ko naakóñaxón na̱ xa. ");
INSERT INTO pps_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Tjumeꞌe ndo rey kuinꞌen ndo ngeꞌe juinchekao na̱ xi xruanꞌan ndo, meꞌe tsango koñao ndo ko kuetuenꞌen ndo xi soldadoe ndo ko naakóñaxón xi soldado ni ñaꞌi meꞌe ko juaaka xa tjajnée na̱. ");
INSERT INTO pps_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Tjumeꞌe ndache ndo ni nchexrée ndo: “Kain ngeꞌe ó konchjian ixi sen tsuteꞌe ko ni kuiyaꞌa tsiꞌa na̱ ixi tikinixienꞌa na̱ tsi̱i̱ na̱ kia. ");
INSERT INTO pps_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Méxin, itjinta chaꞌo tachrjexin chujni tjajna ko ndachenta ngixeꞌi chujni tsi̱i̱ na̱ kia.” ");
INSERT INTO pps_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Ko ni nchexra̱ sakjui na̱ ko juejo na̱ itsjé chujni, ni jian ko ni ñaꞌi, ko kia meꞌe tsango itsjé chujni xejo. ");
INSERT INTO pps_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","’Hora kuixinꞌin ndo rey ti ste ni kui̱i̱ kia, bikon ndo naa xi jitsáꞌi manta takeꞌe ni itji kia. ");
INSERT INTO pps_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Meꞌe ndachro ndo: “Jaꞌa, ¿sonda kuixiꞌian ntiꞌi ko tsikakeꞌa manta tetsáa ni itji kia ngajin sen tsuteꞌe?” Ko xi meꞌe xroꞌan ngeꞌe juatingíexin xa. ");
INSERT INTO pps_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","*Tjumeꞌe ndo rey kuiyeꞌe ndo ni stetaya ti sine chujni ko ndachro ndo: “Itsenta xi ña̱ ko tinteenta tutée xa ko itja xa ko tjankanta xa nduja ti naxixeꞌe; ntiꞌa xrotsjanga xa ko tse̱ꞌto̱ neno xa.” ");
INSERT INTO pps_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Tjumeꞌe ndachro ndo Jesús: ―Jaꞌin tonꞌen ixi kueya ni tjaun tixinꞌin ti tetuanꞌan ndo Dio ko jeꞌe ndo tsjéꞌa sen tsincheꞌe ndo. ");
INSERT INTO pps_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Tjumeꞌe xi fariseo sakuntekji xa ko juao kichuu xa xranchi sincheꞌe xa ixi ndo Jesús ndakoꞌa xronichja ndo naa ngeꞌe ixi jaña chao tsjankataꞌa xa ndo ijie̱. ");
INSERT INTO pps_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Méxin xruanꞌan xa kaxin xi nchekuenꞌen xa ko kaxin xi nchexrée xi Herodes ixi tsjanchangíꞌe xa ndo Jesús jaꞌin: ―Maestro, konónana ixi jaꞌanta jeꞌo ti nduaxin nichjanta, ko ndako tjakonta chijnie ndo Dio, ko jaꞌanta taꞌinta juachjaon ngeꞌe nichja chujni, ixi jaꞌanta tsjeꞌenta aséen chujni. ");
INSERT INTO pps_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Méxin ngeꞌe chronta, ¿á chao tsjengeꞌeni ꞌna̱ xi tetuanꞌan kui̱ꞌxi̱n tjajna Roma? ");
INSERT INTO pps_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Ko ndo Jesús noꞌe ndo ixi ndakoꞌa stexraxaon xa, meꞌe ndachro ndo: ―Jaꞌanta ndakoꞌa xraxaonnta. ¿Sonda tjaunnta ixi janꞌan ndakoꞌa xronichja? ");
INSERT INTO pps_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Chjánanta naa tomi xengaxin ꞌna̱. Ko jeꞌe na̱ kuajon na̱ naa tomi ndatinꞌin denario. ");
INSERT INTO pps_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Tjumeꞌe ndo Jesús juanchangiꞌe ndo xa: ―¿Xranchi ndatinꞌin ko ngisen ikon jinito tomi jiꞌi? ");
INSERT INTO pps_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Ko jeꞌe na̱ juatingíexin na̱: ―Xi César tetuanꞌan Roma, meꞌe xi ikon. Ko jeꞌe ndo ndachro ndo: ―Chje̱ꞌénta xi César ngeꞌe tjanchia xa ko chje̱ꞌénta ndo Dio ngeꞌe tikinixinꞌen ndo. ");
INSERT INTO pps_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Ko kuinꞌen na̱ jaꞌin, meꞌe xraxaon na̱: ―Xi jiꞌin tsango noꞌe xa. Tjumeꞌe sakuintekji na̱. ");
INSERT INTO pps_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","*Ko xrajeꞌo nchakon meꞌe, kuntekii kaxin xi ndatinꞌin saduceo, xi titikaonꞌa ixi xroxechón chujni, ko juanchangiꞌe xa ndo Jesús: ");
INSERT INTO pps_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","―Jaꞌanta ti nchekuenꞌennta chujni, ngeꞌe chronta ti tsindachro ndo Moisés ixi siá naa xi tsenꞌen xa ko tsintueꞌa xa chjan ngajin janchriꞌe xa, xi kichuu xa xrokonda tsuteꞌe xa nchrinchriꞌe xi kuenꞌen, ko siá xrochónda na̱ ichjan, ichjan meꞌe xrokjui xranchi chjenꞌen xi kuenꞌen. ");
INSERT INTO pps_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Bakeꞌe ngakjenꞌen janꞌanna ya̱a̱to̱ xi, ko xi meꞌe kichuu xa. Ko xi saꞌó kuteꞌe xa ko kuenꞌen xa ko kuichóndaꞌi janchriꞌe xa ichjan, meꞌe xi kichuu xa kuteꞌe xa nchrinchriꞌe xi kuenꞌen. ");
INSERT INTO pps_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Ko jaña konꞌen xi yuxin, kaxon xi nínxin, ko kain ya̱a̱to̱ xa. ");
INSERT INTO pps_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Ko kain xa kuenꞌen xa ko kaxon jeꞌe nchra kuenꞌen nchra. ");
INSERT INTO pps_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Nchakon xroxechón kain chujni tsikenꞌen, ¿ngixeꞌe ti ya̱a̱to̱ xa tsoña̱ ndoxiꞌe nchra ixi kain xa kuteꞌe xa nchra? ");
INSERT INTO pps_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Tjumeꞌe ndo Jesús juatingíexin ndo: ―Jaꞌanta, ¿á tsango noaꞌinta ngeꞌe ichro xroon chijnie ndo Dio ko á chuxinꞌanta juachaxien ndo? ");
INSERT INTO pps_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Ixi nchakon xroxechón kain chujni, xroꞌan ngisen tsuteꞌe ntiꞌa, ko xroꞌan sen xroxrajon ixi tsuteꞌe sen, ixi sen xroxechón tsintee sen xranchi sen ángel neꞌe ndo Dio ste ngajní. ");
INSERT INTO pps_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Chijni nichja ixi xroxechón ni tsikenꞌen, jaꞌanta, ¿á juinchekuanxinꞌanta ngeꞌe ndachro chijnie ndo Dio? Ixi jeꞌe ndo jaꞌin ndachro ndo: ");
INSERT INTO pps_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Janꞌan ndo Dio, ndo titikaon ndo Abraham ko ndo Isaac ko ndo Jacob.” Ndo Dio jeꞌa neꞌe ni tsikenꞌen. Naꞌi. Jeꞌe ndo ndo Dio neꞌe ni stechón. ");
INSERT INTO pps_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Ko ni kuinꞌen ngeꞌe nichja ndo xraxaon na̱ ixi jeꞌe ndo tsango noꞌe ndo ko jian nichja ndo. ");
INSERT INTO pps_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Kain xi fariseo konoꞌe xa ixi ndo Jesús jian juatingíexin ndo ngajin xi saduceo ko juinchekita ndo xa, méxin juejo kichuu xi fariseo ");
INSERT INTO pps_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","ko naa xi fariseo, naa xi ícha noꞌe ko tjako xa chijnie ndo Dio, juanchangiꞌe xa ndo Jesús ixi tjaun xa ndakoꞌa xrojuatingíexin ndo: ");
INSERT INTO pps_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","―Maestro, ¿ngixeꞌe chijnie ndo Dio ti ícha tetuanꞌan? ");
INSERT INTO pps_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Ndo Jesús ndachro ndo: ―“Jaꞌanta xrotjueꞌenta ndo Dio ixi nchijíi asáanta ko ti xraxaonxinnta.” ");
INSERT INTO pps_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Jiꞌin chijni saꞌó ko ícha tjintee kuetuanꞌan ndo Dio. ");
INSERT INTO pps_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ko chijni yuxin xrajeꞌo ndachro chijni: “Xrotjueꞌenta ni kichuunta xranchi tjueꞌenta asáanta.” ");
INSERT INTO pps_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","*Yui chijni jiꞌin ti kuetuanꞌan ndo Dio kuachrjenixin kain ti kuetuanꞌan ndo, ti juako ndo Moisés, ko kain ti juako sen kuachronga chijnie ndo Dio ó saꞌó. ");
INSERT INTO pps_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Ko xra ste kain xi fariseo, ndo Jesús juanchangiꞌe ndo xa ");
INSERT INTO pps_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","ko jaꞌin juanchangi ndo: ―¿Ngeꞌe xraxaonnta ixi ndo Cristo? ¿Ngisen kuachrjenixin ndo? Ko jeꞌe xa ndachro xa: ―Ndo Cristo tsikachrjenixin ndo ndo David. ");
INSERT INTO pps_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Tjumeꞌe ndo Jesús ndachro ndo: ―Ndo David nichjaxin ndo ixi Espíritue ndo Dio ko ndachro ndo: “Nchána”, ");
INSERT INTO pps_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Meꞌe jaꞌin nichja Nchána Dio ngajin Nchána: “Takeꞌénta ndatsjonxin jian ti ritjén janꞌan, ko chonꞌénnta ti tsakeja kain ni ningakonꞌannta ngangi tutáanta.” ");
INSERT INTO pps_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","¿Xranchi ndo Cristo xrokuachrjenixin ndo ndo David ko jeꞌe ndo David ndachro ndo ixi Nchée ndo ndo Cristo? ");
INSERT INTO pps_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Ko juaꞌi juateꞌe ninaa xi ste ntiꞌa ti juanchangi ndo Jesús ko ti hora meꞌe kuaxi í xroꞌan ngeꞌe juanchangiꞌe xa ndo. ");
INSERT INTO pps_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Ko kuaxi ndo Jesús nichjeꞌe ndo chujni kao sen teyuu chrikao ndo, ko jaꞌin ndachro ndo: ");
INSERT INTO pps_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","―Xi tjako ley chijnie ndo Dio ko xi fariseo xraxaon xa ixi jeꞌe xa ícha jian noꞌe xa chijni juako ndo Moisés. ");
INSERT INTO pps_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Méxin, kain ngeꞌe tsituanꞌan xa titikaonnta ko ncheꞌenta meꞌe, ko ncheꞌanta xranchi ncheꞌe jeꞌe xa ixi jeꞌe xa ndachro xa naa ngeꞌe ko jeꞌe xa ncheꞌa xa ti ndachro xa. ");
INSERT INTO pps_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Ixi jeꞌe xa tetuanꞌan xa ti tsango tangi sincheꞌe chujni, ko jeꞌe xa titikaonꞌa xa naa nchichjaon ko tingijnaꞌi xa chujni ixi tsitikaon na̱ kaxon. ");
INSERT INTO pps_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","*Ko kain ti jian ncheꞌe xa tjaun xa tsikon chujni ko ncheꞌe xa juaxruxin takeꞌe xa nganito ntatjen xa ko ntachaan xa kaxin chajua iton, ntiꞌa tsikjin xa chijnie ndo Dio ko manta tetsáa xa tsikakeꞌe xa kueya chajua ícha jié ixi ti tetsáa ikaxin chujni. ");
INSERT INTO pps_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Ko nchakon itji xa niꞌngo o̱ xrojan kia tjaun xa ixi chujni jian sinchesayeꞌe na̱ xa. ");
INSERT INTO pps_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Ko ngataon ndasin ko ngaya chaꞌo tjaun xa ixi chujni tsajon na̱ juajna ko xrochóndeꞌe na̱ xa juasaya ko sinchekinꞌin na̱ xa xi tjako chijnie ndo Dio. ");
INSERT INTO pps_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","’Ko jaꞌanta tjanchaꞌinta ixi chujni xrontatjunta na̱ sen nchekuenꞌen chujni jaꞌanta, ixi jaꞌanta naakua naa ndo nchekuanꞌannta meꞌe ndo Cristo ko kain jaꞌanta kichuunta. ");
INSERT INTO pps_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ko xroꞌan ngisen ndachenta ndotánta ngataꞌa nunte ntiꞌi ixi naakua naa Ndotánta chondanta, ndo jii ngajní. ");
INSERT INTO pps_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Ko ndachroꞌanta ixi jaꞌanta ritaunꞌenta chujni ixi jeꞌo ndo Cristo meꞌe ndo jitaonꞌen chujni. ");
INSERT INTO pps_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","*Ngisen ícha tjaun tsituanꞌan, sen meꞌe xrokonda xrokjan sen chujni ncheꞌe xráanta. ");
INSERT INTO pps_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","*Ixi ngisen ícha sinchejié aséen, sen meꞌe ícha nunte tsintee sen, ko sen nchejiéꞌa aséen, sen meꞌe ícha tsetuanꞌan sen. ");
INSERT INTO pps_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","’Ko lastu jaꞌanta ti nchekuenꞌennta chujni ko jaꞌanta fariseo, ti tjako yuu ikonnta, ti tijeꞌe̱nta nta̱chja ti tetuanꞌan ndo Dio ixi tsixinꞌa chujni ko jaꞌanta tixinꞌanta ko tintueꞌanta tixinꞌin ikaxin chujni tjaun tixinꞌin. ");
INSERT INTO pps_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","’Ko lastu jaꞌanta ti nchekuenꞌennta chujni ko jaꞌanta chujni fariseo, ti tjako yuu ikonnta, ko tantsjeꞌenta nchri kaꞌan ndoꞌa nchra, ko tjaunnta tsikon chujni ixi tsango nichjeꞌenta ndo Dio. Méxin jaꞌanta ícha tangi tsonꞌannta. ");
INSERT INTO pps_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","’Lastu jaꞌanta ti nchekuenꞌennta chujni ko jaꞌanta chujni fariseo, ti tjako yuu ikonnta, ko tatsinganta ndachaon ko tsango ichrjinta ixi tsjachanta naa chujni tsitikaon ti tjakonta, ko nchakon juachanta chujni meꞌe, tsango chinga nchekuenꞌennta na̱, ko chujni meꞌe ícha ndakoꞌa ncheꞌe chujni ko chujni meꞌe ícha tikinixinꞌen chujni xrochexin xroꞌi ixi jaꞌanta. ");
INSERT INTO pps_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","’Lastu jaꞌanta ixi tjakonta ko jaꞌanta ndakútsínnta. Ndachro jaꞌanta nchakon xrojan chujni xrondachro ixi sincheꞌe xrojan ngeꞌe ko niꞌngo xronichjaxin sen ko ndachro jaꞌanta ixi tjinteꞌa meꞌe. Ko siá chika oro jii ngaxinꞌin niꞌngo xronichjaxin sen, jaꞌanta ndachronta ixi chijni meꞌe tjintee ko nduaxin xroxenga ꞌna̱. ");
INSERT INTO pps_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Tsango ninta jaꞌanta ko ntakutsinnta. ¿Á tsango tjintee chika oro o̱ á tsango tjintee niꞌngo juinchetjúáxin chika oro? ");
INSERT INTO pps_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Kaxon ndachro jaꞌanta: “Xrojan chujni xrondachro ixi sincheꞌe xrojan ngeꞌe ko xronichjaxin sen altar ko jaꞌanta ndachronta ixi tjinteꞌa meꞌe. Ko siá xrondachro sen ixi sincheꞌe sen xrojan ngeꞌe ko xronichjaxin sen ngeꞌe chjée sen ndo Dio ngataꞌa altar meꞌe ti tjintee ichro jaꞌanta ko meꞌe xrondachro ixi nduaxin xroxenga ꞌna̱.” ");
INSERT INTO pps_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Tsango ninta jaꞌanta ko ntakutsinnta. ¿Á tsango tjintee ngeꞌe xrochjeꞌénta ndo Dio?, o̱, ¿á ícha tsango tjintee altar ti tontjúáxin ngeꞌe tsajonnta? ");
INSERT INTO pps_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Ixi ngisen xrondachro ixi sincheꞌe xrojan ngeꞌe ko xronichjaxin sen altar, jeꞌa nichjaxin sen jeꞌo altar. Naꞌi. Kaxon nichjaxin sen kain ngeꞌe jii ngataꞌa ntiꞌa. ");
INSERT INTO pps_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Meꞌe ngisen xrondachro ixi sincheꞌe sen xrojan ngeꞌe ko xronichjaxin sen niꞌngo, jeꞌa nichjaxin sen jeꞌo niꞌngo. Naꞌi. Kaxon nichjaxin sen ndo Dio jii ntiꞌa. ");
INSERT INTO pps_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","*Méxin, ngisen xronichjaxin sen ngajní, meꞌe kaxon nichjaxin sen trono neꞌe ndo Dio ko ngisen jitetuanꞌan ntiꞌa. ");
INSERT INTO pps_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","’Lastu jaꞌanta ti tjakonta ley ko jaꞌanta chujni fariseo. Jaꞌanta ndakoꞌa xraxaonnta. Jaꞌanta chje̱ꞌénta ndo Dio ti ite ngeꞌe tikinixin tsajonnta neꞌe kamenta ko anís ko comino. Ko titikaonꞌanta ti ngeꞌe tjako ley: ti jian xrokonda sincheꞌenta ko ti xrokonda tsikonóeꞌenta sen kichuunta ko ti xrochuntianta ndo Dio. Kain jiꞌi xrokonda sincheꞌenta ko kaxon ti ngeꞌe tikinixinꞌen ndo Dio tsajonnta. ");
INSERT INTO pps_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Jaꞌanta ntakutsinnta, ti nchekangiꞌenta kuchjisen nchíín ixi tsingaꞌinta ba, ko jaꞌanta tinganta naa kucamello tsango ijié. ");
INSERT INTO pps_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","’Lastu jaꞌanta ti tjakonta ley ko jaꞌanta chujni fariseo. Jaꞌanta ndakoꞌa xraxaonnta. Jaꞌanta tsango nchetjúánta tuenxin vaso ko laato, ko ngaxinꞌin tsango kitja ixi xraxaonnta xrotsénta ngeꞌe jeꞌa tikinixinꞌanta. ");
INSERT INTO pps_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Jaꞌanta chujni fariseo tsango ntakutsinnta. Saꞌó xronchetjúánta ngaxinꞌin vaso ko laato ko meꞌe tsontjúá tuenxin. ");
INSERT INTO pps_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","*’Lastu jaꞌanta ti tjakonta ley ko jaꞌanta fariseo. Ndakoꞌa xraxaonnta. Jaꞌanta stenta xranchi naa tuye tsixrabaa chujni, tsango chaxro tsjeꞌe nduja, ko ngaxinꞌin jikaon nteꞌe chujni tsikenꞌen ko kain ngeꞌe tjúáꞌi. ");
INSERT INTO pps_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Jaña jaꞌanta tjaunnta chujni tsikon na̱ ixi jaꞌanta tsango jiannta, ko ngaxinꞌin asáanta ndakoꞌa xraxaonnta ko ñaꞌinta. ");
INSERT INTO pps_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","’Lastunta ti tjakonta ley ko jaꞌanta fariseo. Jaꞌanta ndakoꞌa xraxaonnta. Jaꞌanta ti juincheñanta lápida ti tsixrabaa sen kuanichja chijnie ndo Dio ó saꞌó ko chaxro nchetsojinnta ixro jitaꞌa tuye neꞌe sen tjúá aséen. ");
INSERT INTO pps_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Ko jaꞌanta ndachronta siá xrobakeꞌenta nchakon bakeꞌe sen tachríꞌanta xrobingijnaꞌinta sen kóña sen juako chijnie ndo Dio. ");
INSERT INTO pps_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Ko jaña jaꞌonta ndachronta ixi nduaxin jaꞌanta tsikachrjexinnta sen kóña sen kuanichja chijnie ndo Dio ó saꞌó. ");
INSERT INTO pps_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Méxin, jai jaꞌanta tjaunnta sinchejexinnta ti kuancheꞌe sen tachríꞌanta. ");
INSERT INTO pps_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","*’¡Jaꞌanta ti tsikachrjexinnta kunchee! ¿Xranchi satsingeꞌenta nchakon xrochexinnta xroꞌi? ");
INSERT INTO pps_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Méxin, janꞌan xroxruanꞌan chujni xrochronga chijnie ndo Dio ko chujni tsango noꞌe ko chujni nduaxin tjako chijnie ndo. Ko jaꞌanta naatsóñaxónnta sen ko tankanitonta sen nta̱cru ko ikaxin sen tsonꞌinta sen ngaxinꞌin niꞌngo ko tsenginta sen tjajna ko tjajna. ");
INSERT INTO pps_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Ko méxin, jaꞌanta tsamanta ijie̱ ti neꞌe sen jian kuenxin ngataꞌa nunte ó saꞌó. Ko tsamanta ijie̱ ixi ti kuaxi kuenꞌen sen jian xrangíxixín ndo Abel, ndo jian, ko kain sen hasta ti ndo Zacarías, chjenꞌen ndo Berequías, kóñaxinnta tjenka altar niꞌngo. ");
INSERT INTO pps_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Ko nduaxin ntatjunta ixi kain ijie̱ meꞌe tsama chujni jii jai. ");
INSERT INTO pps_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Tjumeꞌe ndachro ndo Jesús: ―Jerusalén, Jerusalén, jaꞌanta ti tonꞌinnta sen tjako chijnie ndo Dio ko tóñaxinnta ixro sen xruanꞌan ndo Dio ngajinnta. Janꞌan tsango tjaꞌon xrojuejunta xranchi naa kuchika tejo chjenꞌen ba chringi neneꞌe ba ko jaꞌanta tjaunꞌanta. ");
INSERT INTO pps_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Ko jai ndo Dio tsintuꞌanta ndo. ");
INSERT INTO pps_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Ko janꞌan ntatjunta ixi í tsikonꞌaninta janꞌan íjngo tsitjaja nchakon xrondachronta: “Tsango jian ngisen kui̱i̱ ixi juachaxien Ncháina.” ");
INSERT INTO pps_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Hora kuachrjexin ndo Jesús niꞌngo, konchjiñeꞌe sen teyuu chrikao ndo ixi tsanchangíꞌe sen ndo Jesús xranchi tsikonchjian niꞌngo. ");
INSERT INTO pps_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Tjumeꞌe ndo Jesús ndachro ndo: ―¿Á stetsjeꞌenta nchijíi tjatuꞌo jiꞌin? Ko janꞌan nduaxin ntatjunta ixi kain jiꞌin xrochjejin, ko xroꞌan ixro tsakeꞌe ngataꞌa inaa ixro, kain xrochjejin. ");
INSERT INTO pps_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Tjumeꞌe ikjui sen ti jii ijna̱ Olivo ko ntiꞌa ndo Jesús bakeꞌe ndo nunte ko sen chrikao ndo konchjiñeꞌe sen ko jaꞌin ndachro sen: ―Ndachronta ngisa xrojamangi niꞌngo ko, ¿ngeꞌe tsonꞌen nchakon tsjiꞌinta íjngo, ko nchakon tsjexin kain ngeꞌe jii ngataꞌa nunte xasintajni? ");
INSERT INTO pps_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Ko jaꞌin juateꞌe ndo Jesús: ―Jian tsjeꞌenta ixi xroꞌan ngisen sintayaꞌanta. ");
INSERT INTO pps_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Ixi tsi̱i̱ kueya chujni xronichja na̱ xranchi janꞌan ko jaꞌin xrondachro na̱: “Janꞌan ndo Cristo.” Ko sincheyeꞌe na̱ kueya chujni. ");
INSERT INTO pps_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Ko tsinꞌennta steteto kaxin tjajna ko kaxon tsinꞌennta ixi tsaxi tse̱ꞌto̱ ikaxin tjajna, jaꞌanta xrakonꞌanta ixi kain jiꞌi xrokonda tsonꞌen ko xra jeꞌa tsjexin kain ngeꞌe ngataꞌa nunte. ");
INSERT INTO pps_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Naa tjajna tse̱ꞌto̱ ngajin inaa tjajna ko naa xi tituanꞌan tse̱ꞌto̱ xa ngajin inaa xi tituanꞌan. Ko tsango itsjé chujni tsoniꞌe na̱ ko tsango tsatse na̱ jinta ko tsango tsontengi nunte ngixeꞌi tjajna. ");
INSERT INTO pps_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Kain jiꞌi jeꞌo nandá xrangíxixín ti ijié juachjaon tsonꞌen chujni. ");
INSERT INTO pps_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","*’Ko nchakon meꞌe xrotsénta na̱ ixi tsikaonnta ko kaxinnta naatsóñaxónnta na̱ ko itsjé chujni xroningakonꞌannta kondanaxin janꞌan. ");
INSERT INTO pps_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Ko nchakon meꞌe itsjé sen íxrochuntiaꞌina sen ko jeꞌo sen tsjangíꞌe kichuu sen ixi tsango xrochóndeꞌe kichuu sen juañao. ");
INSERT INTO pps_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Ko kueya xi xrondachro xa ixi jeꞌe xa nichja xa chijnie ndo Dio ko jaña sincheyeꞌe xa kueya chujni. ");
INSERT INTO pps_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Ko ixi tsango tsonkueya ni ndakoꞌa ncheꞌe, méxin kaxon sen titikaonna íxrotjueꞌa kichuu sen. ");
INSERT INTO pps_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","*Ko kain sen xrochuntiana janꞌan ko tsokuaxiꞌen sen ti chinga sinchekaon na̱ sen, sen meꞌe tsjacha sen tsechón sen kain nchakon. ");
INSERT INTO pps_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Ko chijni jiꞌi ti tjako janꞌan tsonoꞌe kain chujni jii ngataꞌa nunte xasintajni, ixi jaña kain tjajna, jeꞌe na̱ tsonoꞌe na̱ ngisen janꞌan, tjumeꞌe tsjexin kain ngeꞌe. ");
INSERT INTO pps_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","’Nchakon tsikonnta tsi̱i̱ xi tsango ndakoꞌa ncheꞌe ko tsakeꞌe xa ngaxinꞌin niꞌngo tsango tjúá, jiꞌin ti ó tsichronga ndo Daniel jitaxin chijnie ndo Dio. Méxin ngisen nchekuanxin xroon jiꞌin xrokonda tsienxin sen. ");
INSERT INTO pps_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Nchakon meꞌe sen ste nunte Judea xrokonda tsinga sen ti jii ijna̱. ");
INSERT INTO pps_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","*Ko ngisen jii ngataꞌa nchandoꞌa, xroxingajinꞌa sen tsjiruéꞌe sen xrojan ngeꞌe. ");
INSERT INTO pps_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ko sen ste ngataon ijngi, íxrokjanꞌi sen ixi tsikao sen ti tsetsáa sen. ");
INSERT INTO pps_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Ko lastu sen nchri, sen steyá chjenꞌen ko sen stenchekaki ichjan nchakon meꞌe. ");
INSERT INTO pps_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Nichjeꞌenta ndo Dio ixi nchakon tsingeꞌenta ti chinga tsonꞌen, jeꞌa nchakon tania ichrin o̱ jeꞌa nchakon tjokéꞌe chujni. ");
INSERT INTO pps_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","*Ixi tsakeꞌe ijié juachjaon ngataꞌa chujni, xranchi bakeꞌa xra ti xrangíxixión nunte xasintajni, ko tsoenꞌa ícha tjumeꞌe. ");
INSERT INTO pps_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Ndo Dio tsango tjueꞌe ndo sen kuincheꞌe ndo, méxin nchakon tsi̱i̱ ijié juachjaon, tsonchrjenꞌa juachjaon meꞌe, ixi siá naꞌi, kain sen tsenꞌen sen. ");
INSERT INTO pps_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","’Méxin siá xrojan ngisen xrondachro: “Tsjeꞌenta ntiꞌi jii ndo Cristo”, o̱ “Tsjeꞌenta noyáꞌa jii ndo”, titikaonꞌanta na̱. ");
INSERT INTO pps_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Ixi tsonoxin kaxin xi xrondachro xa jeꞌe xa ndo Cristo ko kaxin xa xrondachro xa ixi jeꞌe xa nichja xa chijnie ndo Dio ko tsjako xa ijié juachaxin ko ijié ixra̱ sincheꞌe xa, jaña tjaun xa sincheyeꞌe xa chujni tsikincheꞌe ndo Dio. ");
INSERT INTO pps_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Ó saꞌó ntatjunta ngeꞌe tsonꞌen. ");
INSERT INTO pps_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","*Méxin, siá xrontatjunta na̱: “Tsjeꞌenta ti jii ntajie, ntiꞌa jii ndo Cristo”, tjiꞌanta. O̱ xrondachro na̱: “Jii ndo ngaxinꞌin nchia”, titikaonꞌanta. ");
INSERT INTO pps_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Ixi xranchi tachrjexin xroꞌi tóngíxin ndatsjonxin chuya ko ti jii xroꞌi ti tetaonxin nchakon, jaña tsikon chujni nchakon tsi̱i̱ Chjenꞌen ndo Dio, xjan jongíꞌe xranchi chujni. ");
INSERT INTO pps_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","*Ixi ti no jitsinga ti tsikenꞌen, ntiꞌa xroxejo kuntachrjen. ");
INSERT INTO pps_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","*’Ko tsatsinga ti chinga tsonꞌen chujni, nchakon meꞌe chjiixro ítsingasáñaꞌi chjiixro ko tsonaxixeꞌe. Ko nchanitjao ítsajonꞌa chjixrue, ko nchanotsé tsitsingaxin nchanotsé ngajní ko kain ngeꞌe jii ngajní tsontengi. ");
INSERT INTO pps_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","*Ko tjumeꞌe tsonoxin ti jii ngajní naa ngeꞌe xrochronga ixi ikjan Chjenꞌen ndo Dio, xjan jongíꞌe xranchi chujni. Ko kain chujni jii ngataꞌa nunte tsango xroxronka na̱ ixi tsikon na̱ Chjenꞌen ndo Dio tsi̱i̱ xjan ngakjenꞌen itjui̱ ko tsikaꞌo xjan ijié juachaxin ixi tsango tituanꞌan xjan. ");
INSERT INTO pps_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Ko xroxruanꞌan xjan sen ángel neꞌe xjan ixi séen tsanoa sen tjaoꞌe sen, meꞌe xroxejo kain chujnie xjan tsi̱ꞌxi̱n nganoó lado nunte xasintajni. ");
INSERT INTO pps_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","’Tanginta chijnie naa nta̱a̱ tu higo: nchakon taxi xechji nta̱a̱, ko tajon nta̱a̱ kayua meꞌe xrondachro ixi ó tsaxi tsi̱i̱ ichrin. ");
INSERT INTO pps_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Jaña ncheꞌe jaꞌanta kaxon, nchakon tsikonnta tsatsinga kain jiꞌi, meꞌe tsonoꞌanta ixi Ncháina ó tuinxin tsi̱i̱ ndo. ");
INSERT INTO pps_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Ko nduaxin ntatjunta ixi kain jiꞌi saꞌó xrokonda tsonꞌen, ko chujni jichón jai xratsenꞌa na̱. ");
INSERT INTO pps_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Ngajní ko nunte xasintajni tsitjáña. Ko chijni nichja janꞌan, naiꞌa tsitjáña chijni. ");
INSERT INTO pps_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","’Ko ngiora ko ngixeꞌe nchakon tsi̱i̱ ndo xroꞌan ngisen noꞌe, ni sen ángel ste ngajní noeꞌa sen, ni janꞌan, Chjenꞌen ndo Dio, nónaꞌi. Jeꞌo Ndotána, meꞌe ndo noꞌe. ");
INSERT INTO pps_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","’Ko xranchi konꞌen nchakon bakeꞌe ndo Noé jaña tsonꞌen nchakon tsi̱i̱ Chjenꞌen ndo Dio, xjan jongíꞌe xranchi chujni. ");
INSERT INTO pps_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Ixi nchakon xra chreteꞌa chujni inda, jeꞌe na̱ bajine na̱ ko bakiꞌi na̱, bakute̱ꞌe na̱ ko bakajon kichuu na̱ ixi tsuteꞌe na̱, ko kui̱i̱ nchakon kuixinꞌin ndo Noé nta̱barco, ");
INSERT INTO pps_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","ko kuienxinꞌa na̱ ngeꞌe xrokonꞌen, kuija ichrin ko inda sabikao na̱ ko kjunꞌen na̱ inda. Jaña tsonꞌen nchakon tsi̱i̱ Chjenꞌen ndo Dio, xjan jongíꞌe xranchi chujni. ");
INSERT INTO pps_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Ko xranchi nchakon meꞌe jaña tsakeꞌe yuu xi ngataon ijngi, naa xa satsikao ndo xa ko í naa xa tsituꞌe xa. ");
INSERT INTO pps_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Yuu nchri jitaꞌo nchra, naa nchra satsikao ndo nchra ko inaa nchra tsituꞌe nchra. ");
INSERT INTO pps_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","’Jian tsjeꞌenta ixi noaꞌinta ngiora tsiꞌi Ncháina. ");
INSERT INTO pps_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","*Jaꞌanta xrokuienxinnta jiꞌin ixi nchée naa nchia, siá xrokonoꞌe xa ngiora tiie tsi̱i̱ naa xicheꞌe ixi tse̱e xa, jeꞌe nchée nchia xrokuejuaꞌi xa ixi tsintueꞌa xa xicheꞌe tsixinꞌin xa ko tse̱e xa. ");
INSERT INTO pps_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Méxin, jaꞌanta tarichrinꞌanta ixi Chjenꞌen ndo Dio, xjan jongíꞌe xranchi chujni, tsi̱i̱ xjan hora jaꞌanta xraxaonꞌanta. ");
INSERT INTO pps_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","’Naa xinchexra̱, xi jian titikaon, xi meꞌe tituenꞌen xa xinchexrée nchée xa ko tsajon xa ngeꞌe sine ni nchexra̱ hora xrokonda sine na̱. ");
INSERT INTO pps_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Juaxruxin tsakeꞌe xinchexra̱, xi titikaon, ixi nchakon tsi̱i̱ nchée xa tsitja ndo xa ixi jincheꞌe xa ngeꞌe kuituenꞌen xa. ");
INSERT INTO pps_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Ko nduaxin xinchexra̱ meꞌe tsayéꞌe xa ijié juachaxin tsituanꞌan xa ngataꞌa kain ti tjintee chónda nchée xa. ");
INSERT INTO pps_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Ko siá xinchexra̱ ñaꞌi xroxraxaon xa ixi nchée xa tsonchrjenꞌen tsi̱i̱ ");
INSERT INTO pps_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","ko tsaxi xa tsóña xa xinchekao xa xra̱ ko tjumeꞌe tsaxi xa tsiꞌikao ko sinekao xa ni tsikuan, ");
INSERT INTO pps_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","ko nchakon tsi̱i̱ nchée xi nchexra̱ ñaꞌi, ngiora ko nchakon ti jeꞌe xa noeꞌa xa ");
INSERT INTO pps_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","ko nchée xa tsituanꞌan ixi tsikaon xa ko xroxruanꞌan xa ti ste kain ni ñaꞌi ko ntiꞌa xrotsjanga xa ko tse̱ꞌto̱ neno xa ixi tsango xroxronka xa. ");
INSERT INTO pps_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","*Ndo Jesús ndachro ndo: ―Ti tetuanꞌan ndo Dio tsonꞌen xranchi konꞌen ti ite nchrichajan, nchrichan ikjui ti kuteꞌe chujni, ko kain jeꞌe nchrichan itsé nchrichan ti tikia ndaxiꞌe ko kuachrje nchrichan kuichónꞌen nchrichan ndo tsuteꞌe. ");
INSERT INTO pps_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Naꞌó nchrichan meꞌe tsango jian titikaon nchrichan ko naꞌó nchrichan tsango seꞌe nchrichan. ");
INSERT INTO pps_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Ko nchrichan seꞌe bikao nchrichan ti no tikia ndaxiꞌe ko tsikikaoꞌa nchrichan yee ndaxiꞌe xrochexin xroꞌi. ");
INSERT INTO pps_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Ko nchrichan jian titikaon bikao nchrichan ti no tikia ndaxiꞌe ko kaxon bikao nchrichan ícha ndaxiꞌe ixi tsangaꞌi xroie nchrichan. ");
INSERT INTO pps_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Ko konchrjenꞌen ndo tsuteꞌe, ko jeꞌe nchrichan itja̱ jaa nchrichan ko kuejua nchrichan. ");
INSERT INTO pps_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Ko ngusine tiie kuinꞌen nchrichan nichja kaxin chujni: “Ó kui̱i̱ ndo tsuteꞌe, tachrjenta ixi ó kui̱i̱ ndo.” ");
INSERT INTO pps_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Meꞌe kain nchrichajan bingatjen nchrichan ko kuaxi bikia nchrichan ndaxiꞌe. ");
INSERT INTO pps_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Ko naꞌó nchrichan seꞌe, juanchia nchrichan ndaxiꞌe ngajin naꞌó nchrichan jian titikaon: “Chjána̱nanta nchíín ndaxiꞌe ixi jitanga xroina̱na.” ");
INSERT INTO pps_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Ko nchrichan jian titikaon ndachro nchrichan: “Naꞌi, ixi batsitjáñaꞌina ndaxiꞌe janꞌanna ko jaꞌanta. Cháña itjinta tikeꞌnanta ndaxiꞌe ti no nchekji na̱ nda.” ");
INSERT INTO pps_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Ko naꞌó nchrichan seꞌe, nandá kuachrje nchrichan bikeꞌna nchrichan ndaxiꞌe, ko jeꞌe ndo tsuteꞌe kui̱i̱ ndo. Ko nchrichan naꞌó, jian titikaon, kuixinkao nchrichan ndo tsuteꞌe, ko bijeꞌe nta̱chja. ");
INSERT INTO pps_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","*Ko tjumeꞌe kui̱i̱ naꞌó nchrichan seꞌe, ko kuaxi ndachro nchrichan: “Jaꞌanta ti tsutaꞌanta, tantjeꞌenta nta̱chja ixi tsixinꞌinna.” ");
INSERT INTO pps_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Ko jeꞌe ndo jaꞌin juatingíexin ndo: “Janꞌan nduaxin ntatjunta ixi chuxinꞌanta.” ");
INSERT INTO pps_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Ko ndo Jesús ndachro ndo: ―Tarichrinꞌanta ko jian tsjeꞌenta ixi noaꞌinta ngixeꞌe nchakon ko ngiora tsi̱i̱ Chjenꞌen ndo Dio, xjan jongíꞌe xranchi chujni. ");
INSERT INTO pps_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","*Tjumeꞌe ndachro ndo Jesús: ―Ti no tituanꞌan ndo Dio tsonꞌen xranchi naa xi satsji xa ikjín, meꞌe kuiyeꞌe xa xinchexrée xa ko bakeꞌe xa ngaya itja xinchexrée xa kain ti tjintee chónda xa ixi xinchexrée xa sinchencheꞌe xa tomi xra̱. ");
INSERT INTO pps_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","’Ko naa xinchexrée xa kuayéꞌe xa naꞌó mil tomi, ko inaa xinchexrée xa kuayéꞌe xa yuu mil tomi, ko xi nínxin kuayéꞌe xa naa mil tomi. Ko xi tomie kuajon xa tomi ngajin xinchexrée xa xranchi bikon xa chjakonꞌen xinchexrée xa. Ko juexin kuajon xa tomi, tjumeꞌe sakjui xa ikjín. ");
INSERT INTO pps_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Ko xi kuayéꞌe naꞌó mil tomi juinchencheꞌe xa tomi xra̱ ko juacha xa íjngo naꞌó mil tomi. ");
INSERT INTO pps_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Jaña kaxon xi kuayéꞌe yuu mil tomi juacha xa íjngo yuu mil tomi. ");
INSERT INTO pps_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Ko xi kuayéꞌe naa mil tomi ikjui xa ko juinchéña xa naa tuye ko juabaa xa tomie nchée xa. ");
INSERT INTO pps_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","’Ko kuatsinga itsjé nano ikjan nchée xinchexra̱ meꞌe, ko juinchéñakaꞌo kichuu xa kuenta. ");
INSERT INTO pps_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Ko saꞌó kui̱i̱ xi kuayéꞌe naꞌó mil tomi ko chjée xa nchée xa íjngo naꞌó mil tomi ti juacha xa ko ndachro xa: “Jaꞌanta chjánanta naꞌó mil tomianta ko janꞌan juacha íjngo naꞌó mil tomi.” ");
INSERT INTO pps_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Tjumeꞌe nchée xinchexra̱ meꞌe ndachro: “Chao jian juincheꞌe jaꞌa, xinchexráana, ixi jian kuitikaoan. Ti kueyaꞌi tomi tjáꞌa ko jian juincheꞌe, ko jai ícha kueya tsayeꞌé. Takeꞌé juaxruxin jaꞌa.” ");
INSERT INTO pps_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Tjumeꞌe kui̱i̱ xi kuayéꞌe yuu mil tomi ko ndachro xa: Yuu mil tomi chjánanta ko ntiꞌi jii íjngo yuu mil tomi juacha. ");
INSERT INTO pps_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Tjumeꞌe nchée xa ndachro: “Chao juincheꞌe jaꞌa, xinchexráana, ixi jaꞌa jian kuitikaoan. Ko maski tsjéꞌa kuayéꞌe, jian juinchencheꞌe tomi xra̱, ko jai ícha itsjé tsayeꞌé. Tatsinga ko juaxruxin tsojuna.” ");
INSERT INTO pps_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Tjumeꞌe kui̱i̱ xi kuayéꞌe naa mil ko ndachro xa: “Nchána janꞌan nóna ixi jaꞌa chujni tsango ji̱nta̱ ixi tayeꞌé ngeꞌe tikinixianꞌia ko tjejua ti no bengaꞌia. ");
INSERT INTO pps_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Méxin, xronkana ko ikjui juabaa tomia, tayeꞌé tomia. Ntiꞌi jii tomi.” ");
INSERT INTO pps_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Tjumeꞌe juateꞌe nchée xinchexra̱ meꞌe ko ndachro xa: “Jaꞌa xinchexra̱ tsango ñaꞌia ko tsango saꞌa. Siá noꞌa ixi janꞌan tsango ji̱nta̱na ko tandáa ti no bengaꞌi ko tjejo ti no kuintjíꞌa tse̱e̱, ");
INSERT INTO pps_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","cháña xrokuajuan tomina ngajin ninchexra̱ banco. Ntiꞌa xrojuinchencheꞌe na̱ tomina xra̱, ko nchakon xrojuiꞌi janꞌan xrokuayaꞌa̱ chjenꞌen tomina.” ");
INSERT INTO pps_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Kaxon jaꞌin ndachro xa: “Tantsjeꞌenta xi jiꞌin tomi chónda xa ko chje̱ꞌénta xi chónda ite mil tomi ");
INSERT INTO pps_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","*ixi ngisen chónda itsjé tomi, jeꞌe sen tsayéꞌe sen ícha, ko ngisen tsjéꞌa chónda, ti tsjéꞌa chónda sen kaxon ti meꞌe tsachrjeꞌe sen. ");
INSERT INTO pps_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","*Ko xinchexra̱ ñaꞌi, xi seꞌe, tjankanta xa nduja ti naxixeꞌe, ntiꞌa xrotsjanga xa ko tse̱ꞌto̱ neno xa.” ");
INSERT INTO pps_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","*’Nchakon xrokjan Chjenꞌen ndo Dio, xjan jongíꞌe xranchi chujni, tsikaꞌo xjan ijié juachaxin ixi tsango tsituanꞌan xjan ko tsi̱i̱ kain sen ángel ko tjumeꞌe tsetaꞌa xjan ntaxitaon ko xrochónda xjan ijié juachaxin. ");
INSERT INTO pps_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Ko ntiꞌa xroxejo kain chujni neꞌe kain tjajna nunte xasintajni, ntiꞌa tsantsjendexin xjan ngujngu chujni, xranchi ncheꞌe sen tingatjia kutuchjon, tantsjendáa sen kutuchjon ko nango tsakeꞌe kubito. ");
INSERT INTO pps_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Ko tsakeꞌe xjan kutuchjon ndatsjonxin jian ko kubito ndatsjonxin ikjon. ");
INSERT INTO pps_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Tjumeꞌe ndo rey xrondache ndo sen ste ndatsjonxin jian: “Xrokui̱i̱nta ti juinchenchaonnta Ndotána ixi tsayeꞌenta ti juintakitonꞌannta ndo, ti juinchéña ndo nchakon xrangíxixión kóña nunte xasintajni, ");
INSERT INTO pps_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","ixi kuenꞌenna jinta ko jaꞌanta chjánanta juiné, ko kuenꞌenna inda ko kuajonnta ngeꞌe kuiꞌi, kuaji xranchi naa chujni kui̱xi̱n ikjín ko jaꞌanta kuajonnta ti no jokéna. ");
INSERT INTO pps_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Ko chondaꞌi ngeꞌe tsaria ko jaꞌanta juinchekitsiininta, ko konína ko jaꞌanta juasotsjenaninta, ko ndoꞌachjiso bakeꞌé ko juasonta bikitsjenanta.” ");
INSERT INTO pps_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Ko tjumeꞌe sen ncheꞌe jian ndachro sen: “Nchána, ¿ngisa bikona kuenꞌennta jinta ko kuajonna ngeꞌe juintenta?, ko, ¿ngisa bikona ixi kuenꞌennta inda ko kuajonna ngeꞌe kuiꞌinta? ");
INSERT INTO pps_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿Ko ngisa bikonanta xranchi naa ni kui̱xi̱n ikjín ko kuajonna ti no jokáꞌanta? ¿Ko ngisa bikona ixi chondaꞌinta ngeꞌe tsarianta ko janꞌanna juintakitsananta? ");
INSERT INTO pps_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿Ko ngisa bikona koniꞌanta o̱ bakeꞌenta ndoꞌachjiso ko juasotsjaꞌananta?” ");
INSERT INTO pps_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Ko ndo Rey xrondachro ndo: “Nduaxin ntatjunta nchakon bingijnanta naa sen kichuunta, sen ícha nóa, meꞌe xranchi xrobingijnaninta janꞌan.” ");
INSERT INTO pps_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","’Tjumeꞌe ndo Rey kaxon xrondache ndo ni ste ndatsjonxin ikjon: “Jaꞌanta ti yamanta ijie̱, satjixinnta ti ritjén janꞌan ko itjinta ti jii xroꞌi naiꞌa tsanga jichónꞌen xrochexin Xixronꞌanxrée ko kain ni ángel neꞌe xa. ");
INSERT INTO pps_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Ixi kuenꞌenna jinta ko jaꞌanta kuajonꞌanta juiné ko kuenꞌenna inda ko kuajonꞌanta inda kuiꞌi. ");
INSERT INTO pps_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Kuaji xranchi naa ni kui̱xi̱n ikjín ko jaꞌanta kuajonꞌanta ti no xrojukéna ko kuachondaꞌi manta tsaria ko jaꞌanta xroꞌan ngeꞌe chjánanta tsaritsaꞌa, konína ko bakeꞌé ndoꞌachjiso ko jaꞌanta juasoꞌanta tsjenanta.” ");
INSERT INTO pps_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Tjumeꞌe jeꞌe na̱ kaxon xrondachro na̱: “Nchána, ¿ngisa bikona ixi kuenꞌennta jinta ko kuenꞌennta inda ko tjaꞌinanta, ko xranchi ni kui̱xi̱n ikjín ko chondaꞌinta ngeꞌe tsarianta ko niꞌanta ko jijaꞌa̱nta ndoꞌachjiso ko janꞌanna binginaꞌinanta?” ");
INSERT INTO pps_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Tjumeꞌe Ndo Rey jaꞌin tsjateꞌe ndo: “Nduaxin ntatjunta ixi siá bingijnaꞌinta naa chujni kichuunta, naa ni ícha nóa, meꞌe xranchi janꞌan xrojuinchenaninta.” ");
INSERT INTO pps_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Ko ni ñaꞌi satsji na̱ ti no tsikaon na̱ kain nchakon. Ko sen jian ncheꞌe itsji sen ti tsechón sen kain nchakon ―jaña chronga ndo Jesús. ");
INSERT INTO pps_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Juexin chronga ndo Jesús kain jiꞌi, tjumeꞌe nichjeꞌe ndo sen teyuu chrikao ndo, ko ndachro ndo: ");
INSERT INTO pps_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","―Jaꞌanta noꞌanta ixi titjáña yuu nchakon tsaxi kia pascua ko Chjenꞌen ndo Dio, xjan jongíꞌe xranchi chujni, tsajon na̱ xjan ixi tsenito na̱ xjan nta̱cru. ");
INSERT INTO pps_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Tjumeꞌe kain xitaana ícha tetuanꞌan ko xi tjako ley neꞌe ndo Dio ko xi tachríi tetuanꞌan tjajna judío, juaꞌo kichuu xa ti ntasien ndoꞌa xitaana ícha tetuanꞌan ndatinꞌin Caifás. ");
INSERT INTO pps_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Ko ntiꞌa juao na̱ xranchi sincheyeꞌe na̱ ndo Jesús ko xrotsé na̱ ndo ixi tjaun na̱ naatsóñaxón na̱ ndo. ");
INSERT INTO pps_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Ko kaxon ndachro na̱: ―Kain nchakon tsonchrjenꞌen kia, xroꞌan ngeꞌe sinchekuuna xi Jesús ixi batsoñao chujni tjajna. ");
INSERT INTO pps_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Ndo Jesús jii ndo tjajna Betania ndoꞌa ndo Simón, ndo kuachónda chinlepra. ");
INSERT INTO pps_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","*Meꞌe konchjiñeꞌe naa nchri ngajin ndo Jesús, ko bikaꞌo nchra naa xroxrao jitjiá inda chaxro xraxe, nda meꞌe tsango tjintee nda. Tjumeꞌe jeꞌe nchra bingamá nchra nda ngataꞌa jaa ndo. ");
INSERT INTO pps_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Ko sen teyuu chrikao ndo Jesús, hora bikon sen ngeꞌe juincheꞌe nchra, tsango koñaoꞌe sen nchra ko ndachro sen: ―¿Sonda juinchexienxian inda xraxe ña̱? ");
INSERT INTO pps_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Cháña xrokúchji̱ nda ko kueya tomi xrokuajon na̱ ixi jeꞌe nda ko tomi meꞌe xrochjeyeꞌe ni nóa. ");
INSERT INTO pps_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Ndo Jesús kuinꞌen ndo ngeꞌe stendache sen nchra, meꞌe ndachro ndo: ―¿Sonda toñaoꞌenta nchra? Ti juincheꞌe nchra ngaji̱n, meꞌe naa ixra̱ tsango jian. ");
INSERT INTO pps_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Sen nóa kain nchakon xrochondanta sen, ko janꞌan íseꞌa tsakeꞌe ngajinnta. ");
INSERT INTO pps_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Ixi ti bingamána nchra inda chaxro xraxe, meꞌe xrondachro juinchekonchjianna nchra ixi xroxrabaana. ");
INSERT INTO pps_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Ko nduaxin ntatjunta ixi nchakon tsinꞌen chujni chijnina nguixin ngataꞌa nunte xasintajni, kaxon xroxraxaon na̱ ixi jeꞌe nchra bingamána nchra nda chaxro xraxe. ");
INSERT INTO pps_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Tjumeꞌe naa xi teyuu chrikao ndo Jesús, ndatinꞌin xa Judas Iscariote, ikjui xa kuitsjeꞌe xa xitaana ícha tetuanꞌan ");
INSERT INTO pps_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","ko ndachro xa: ―¿Ngijanꞌin xrochjána̱na ko janꞌan tsingijna xrotséna ndo Jesús? Ko xitaana tetuanꞌan juenga xa ꞌna̱ ngajin xi Judas, níi ite tomi chika plata. ");
INSERT INTO pps_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Ko nchakon meꞌe kuaxi xi Judas tjée xa ngiora tsajon xa ndo Jesús ngajin na̱. ");
INSERT INTO pps_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Nchakon xrangíxixín kia neꞌe nutja chondaꞌi ngeꞌe tjainxin nio, sen teyuu chrikao ndo Jesús konchjiñeꞌe sen ngajin ndo ko ndachro sen: ―Ndachronta, ¿no tjaunnta tsonchjian sinexinna nutja kia Pascua? ");
INSERT INTO pps_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Tjumeꞌe jeꞌe ndo ndachro ndo: ―Itjinta tjajna ijié, ndoꞌa naa xi ko jaꞌin ndachenta xa: “Ndachro ndo nchekuanna̱na: Íseꞌa tsakeꞌe ngataꞌa nunte xasintajni, méxin nchanduya̱ tjaꞌon sinekiꞌan sen ntakuanꞌan ti nutja kia Pascua.” ");
INSERT INTO pps_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Ko sen teyuu chrikao ndo Jesús juinchekonchjian sen ti sine sen kia Pascua xranchi jeꞌe ndo kuituanꞌan ndo. ");
INSERT INTO pps_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Hora kontie ndo Jesús bakeꞌekao ndo sen teyuu ti jii mesa, ");
INSERT INTO pps_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","ko xra stene sen, jeꞌe ndo ndachro ndo: ―Nduaxin xrontatjunta ixi naa jaꞌanta tsajonninta ngajin ni ningakonna. ");
INSERT INTO pps_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Ko meꞌe juincheniꞌe aséen sen ko ngujngu sen teyuu chrikao ndo kuaxi ndachro sen: ―Nchána, ¿á janꞌan sintaꞌa jaña? ");
INSERT INTO pps_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Ko jeꞌe ndo juatingíexin ndo: ―Ngisen nekian ngaya latona, meꞌe sen sinchekjina. ");
INSERT INTO pps_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Ko nduaxin Chjenꞌen ndo Dio, xjan jongíꞌe xranchi chujni, tsenꞌen xjan xranchi nichja xroon chijnie ndo Dio, ko lastu xi sinchekji xjan. Cháña xi meꞌe xrojongíeꞌa xa ngataꞌa nunte xasintajni. ");
INSERT INTO pps_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Ko ndachro xi Judas, xi sinchekji ndo Jesús: ―Jaꞌanta ti nchekuannaninta, ¿á janꞌan sintakjinta? Ko ndachro ndo Jesús: ―Jaꞌa ndachrua. ");
INSERT INTO pps_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Ko xrastene sen, ndo Jesús itsé ndo naa nutja ko kuajon ndo juasaya ngajin ndo Dio. Tjumeꞌe konchrinjin ndo nio ko konchjeya ndo nio ngajin sen chrikao ndo ko ndachro ndo: ―Itsenta nutja ko intenta nio, ixi nutja jiꞌin xranchi xrokjui cuerpona. ");
INSERT INTO pps_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Tjumeꞌe itsé ndo naa vaso jitjiá ndée tu uva ko kuajon ndo juasaya ngajin ndo Dio ko chjée ndo sen ko ndachro ndo: ―Tinꞌinnta kainnta ");
INSERT INTO pps_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","ixi jiꞌin ndée tu uva meꞌe xrokjui xranchi jnina, jni̱ konchjianxin ley natjúá, ko tsintji jni̱ kondeexin itsjé chujni ko jaña tsoméxin ti ndakoꞌa juincheꞌe na̱. ");
INSERT INTO pps_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Ko jai ntatjunta ixi ítsiꞌa ndée tu uva íjngo, ti tsijija nchakon tsojuna ti jii juachaxin tetuanꞌan ndo Dio. Ko nchakon meꞌe tsiꞌi ndée tu uva natjúá íjngo. ");
INSERT INTO pps_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Ko juexin itsje̱ sen naa soon, tjumeꞌe sakuintekji sen ijna̱ Olivo. ");
INSERT INTO pps_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Ntiꞌa ndachro ndo Jesús: ―Tiie jai kain jaꞌanta íxrochuntiaꞌininta ixi ndachro xroon chijnie ndo Dio: “Sintaniꞌa ndo tingatjia kutuchjon ko kutuchjon xrochjekeꞌe ba.” ");
INSERT INTO pps_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","*Ko nchakon xroxechónna tsitaoꞌannta itsjina nunte Galilea. ");
INSERT INTO pps_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Ko ndo Pedro ndachro ndo: ―Maski kain sen tsintuꞌanta sen, janꞌan naꞌi. ");
INSERT INTO pps_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Ko ndo Jesús juatingíexin ndo: ―Nduaxin xrontatjua jaꞌa tiie jai, xraxrotsje̱ꞌa kuntaxichíká níi vez, jaꞌa xrondachrora ixi chuxinꞌana. ");
INSERT INTO pps_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Ko ndachro ndo Pedro: ―Maski naatsóñaxónna na̱, janꞌan xrondachrja̱nꞌi chuxinꞌanta. Ko kain sen chrikao ndo jaña ndachro sen kaxon. ");
INSERT INTO pps_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Tjumeꞌe kuiji ndo Jesús ko sen chrikao ndo ti jii naa huerto ndatinꞌin Getsemaní ko ndache ndo sen: ―Ntiꞌi tinteenta ko janꞌan itsji xronichjaꞌa Ndotána. ");
INSERT INTO pps_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Tjumeꞌe sabikao ndo ndo Pedro ko yui chjenꞌen ndo Zebedeo ko tsango kuaxi koniꞌe aséen ndo. ");
INSERT INTO pps_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Ko ndache ndo sen: ―Tsango jitoniꞌe aséenna xranchi ti xrokueꞌenna. Jaꞌanta ntiꞌi tituanꞌanta ko tarichrinꞌanta. ");
INSERT INTO pps_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Ko sakjui ndo ícha kjínxin ko bakeꞌexin ntatuchiꞌin ndo ko kuisée ndo ti ngataꞌa inche ko jaꞌin nichjeꞌe ndo ndotée ndo: ―Ndotána, siá chao, tájonnta juachaxin ixi tsiꞌa ti tsango itsjá jitjiá copa jiꞌi. Ko ntatjunta ixi tsoenꞌa xranchi janꞌan tjaꞌon. Naꞌi. Jaꞌanta ncheꞌenta xranchi jaꞌanta tjaunnta. ");
INSERT INTO pps_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Ko tjumeꞌe ikjan ndo Jesús ti no kuintuꞌe ndo sen ko jeꞌe sen stejua sen. Ko jaꞌin ndache ndo ndo Pedro: ―¿Á juaꞌi kuarichonnta naa hora? ");
INSERT INTO pps_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Nichjeꞌenta ndo Dio ko tarichrinꞌanta ixi jaña sinchengachrueꞌa Xixronꞌanxrée asáanta ixi espírituanta tjée ndo Dio ko ntauꞌanta tjaunꞌa. ");
INSERT INTO pps_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Tjumeꞌe sakjui ndo íjngo ko ó yuxin kuinóatée ndo ngajin Ndotée ndo, ko ndachro ndo: ―Ndotána, siá xrokonda tsiꞌi ti itsjá jitjiá copa jiꞌi ko jaña tjaun jaꞌanta, janꞌan tsitikaꞌon. ");
INSERT INTO pps_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Ko ikjan ndo ti no ste sen ko jeꞌe sen stejua sen ixi tsango chjéꞌe sen kotachrin. ");
INSERT INTO pps_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Ko sakjui ndo íjngo ko nínxin nichjeꞌe ndo Ndotée ndo ko xrajeꞌo kuinóatée ndo. ");
INSERT INTO pps_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Tjumeꞌe ikjan ndo ti ste sen chrikao ndo ko ndachro ndo: ―¿Á xrarichrinnta ko stetjokaꞌanta? Ó kuitja hora Chjenꞌen ndo Dio, xjan jongíꞌe xranchi chujni, tsajon na̱ xjan ngaya itja chujni ñaꞌi. ");
INSERT INTO pps_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Tingatjennta sachjina ixi ó kui̱i̱ xi sinchekjina ko jai tsajonna xa. ");
INSERT INTO pps_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Ko xrajinichjao ndo Jesús, kui̱i̱ xi Judas, naa xi teyuxin chrikao ndo, ko tsango itsjé chujni bikaꞌo xa, ni steyá nta̱a̱ ko chika espada, ni meꞌe tsixruaꞌan xitaana tsango tetuanꞌan ko ni tachríi neꞌe tjajna judío. ");
INSERT INTO pps_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Ko xi Judas, xi juinchekji ndo Jesús, jaꞌin tsindache xa na̱: ―Xi tsetoxin janꞌan, meꞌe xi xrotsénta. ");
INSERT INTO pps_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Tjumeꞌe konchjiñeꞌe xa ngajin ndo Jesús ko ndachro xa: ―¿Á chao ritjennta, jaꞌanta ti nchekuannaninta? Ko kue̱to̱xin xa ndo. ");
INSERT INTO pps_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Ko ndo Jesús ndachro ndo: ―¿Ngeꞌe tjauan jaꞌa, xi tjento janꞌan? Ko tjumeꞌe konchjiñeꞌe na̱ itsé na̱ ndo. ");
INSERT INTO pps_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Ko naa sen teyuu chrikao ndo Jesús kuantsje xa chika espada ko konchrinjin xa ndatsjon naa xinchexrée xitaana tetuanꞌan. ");
INSERT INTO pps_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Ko tjumeꞌe ndachro ndo Jesús: ―Xraxiꞌian chika ña̱ ngaya tjueꞌé chika, ixi kain sen tjayaxin chika espada, chika espada tsenxin sen kaxon. ");
INSERT INTO pps_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿Ngeꞌe chrua jaꞌa, á juaꞌi tsjáncháꞌa Ndotána ko jeꞌe ndo xroxruanna ndo teyuu ejército sen ángel? ");
INSERT INTO pps_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ko siá xrokui̱i̱ sen ángel, jaña íxrokuenꞌa ti nichja xroon chijnie ndo Dio ó seno. ");
INSERT INTO pps_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","*Tjumeꞌe ndo Jesús ndache ndo ni kui̱i̱ itsé ndo: ―Jaꞌanta yaꞌanta nta̱a̱ ko chika espada xranchi xrotsénta naa xicheꞌe. Ngujngu nchakon bakeꞌe ngaxinꞌin niꞌngo ixi ntakuanꞌannta ko tséꞌaninta. ");
INSERT INTO pps_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Ko kain jiꞌi jaña xrokonda tsonꞌen, ixi jaña chronga sen tsikjin xroon chijnie ndo Dio ó saꞌó. Tjumeꞌe kain sen chrikao ndo Jesús sabinga sen ko jeꞌo ndo kuituꞌe ndo. ");
INSERT INTO pps_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Tjumeꞌe ni tsé ndo Jesús bikao na̱ ndo ngajin xitaana ícha tetuanꞌan ndatinꞌin Caifás, ko ntiꞌa ste kain ni tjako ley neꞌe ndo Dio ko xi tetuanꞌan niꞌngo. ");
INSERT INTO pps_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Ko ndo Pedro imao jiruéꞌe ndo ko kuiji ndo ti ntasien ndoꞌa xitaana tetuanꞌan ko hora kuixinꞌin ndo ntiꞌa, bakeꞌe ndo tjenka ti ste xi stendáa ntiꞌa ixi tjaun ndo xrotsjeꞌe ndo ngeꞌe tsonꞌen. ");
INSERT INTO pps_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Ko xitaana ícha tetuanꞌan ko xi tachríi, ni meꞌe tjaun na̱ tsjankataꞌa na̱ ndo Jesús ijie̱ maski nduaxinꞌa ti ndachro na̱ ixi tjaun na̱ naatsóñaxón na̱ ndo. ");
INSERT INTO pps_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Ko xroꞌan ti ndakoꞌa kuitja na̱, maski kuiji kueya chujni juangíꞌe na̱ ndo. Ko ni meꞌe ncheya na̱, ko tjumeꞌe kui̱i̱ íjngo yuu ni nduaxinꞌa nichja, ");
INSERT INTO pps_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","*ko ndachro na̱: ―Xi Jesús jiꞌi kuinꞌanna ndachro xa: “Janꞌan chao tsonchjejin ningue ndo Dio, ko jeꞌo níi nchakon sintakonchjianxin niꞌngo íjngo.” ");
INSERT INTO pps_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Ko xitaana ícha tetuanꞌan bingatjen xa ko juanchangiꞌe xa ndo Jesús: ―¿Á tsjateeꞌa ti ngeꞌe ichro ni tjangiꞌa? ");
INSERT INTO pps_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Ko ndo Jesús nichjaꞌi ndo. Ko ndachro xitaana ícha tetuanꞌan: ―Janꞌan tituanꞌan ixi nombrée ndo Dio, ndo jichón, ixi xrondachijiana, ¿á jaꞌa ndo Cristo, Chjenꞌen ndo Dio? ");
INSERT INTO pps_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Ko ndo Jesús jaꞌin juatingíexin ndo: ―Jaꞌa ndachijiana jaña. Ko janꞌan kaxon xrontatjua ixi jai tsaxi tsikonnta Chjenꞌen ndo Dio, xjan jongíꞌe xranchi chujni, tsakeꞌe xjan ndatsjonxin jian ti jii ndo Dio, ndo tsango tituanꞌan, ko tsikonnta xjan tsi̱ꞌxi̱n xjan ngajní ngakjenꞌen itjui̱. ");
INSERT INTO pps_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Ko xitaana ícha tetuanꞌan, tsango koñao xa ko kuinchje xa manta jitsáa xa ko ndachro xa: ―Xiꞌi tsango nichjangíꞌe xa ndo Dio. ¿Ngeꞌe ícha tjaunnta tsinꞌennta? Íxrokondaꞌi xi tangi. Ti kuinꞌenna nichjangíꞌe xa ndo Dio, ixi meꞌó. ");
INSERT INTO pps_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿Ngeꞌe ichro jaꞌanta? Ko ni kaxin jaꞌin juateꞌe na̱: ―Xiꞌi chónda xa ijie̱, xrokonda tsenꞌen xa. ");
INSERT INTO pps_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Tjumeꞌe kuaxi na̱ bikitée na̱ ndo ndatée na̱ ngaya ikon ndo ko ikaxin na̱ kuandeꞌe na̱ ito̱n ikon ndo. ");
INSERT INTO pps_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Ko ndachro na̱: ―Siá nduaxin jaꞌa ndo Cristo, ndachrua ngisen kuandaꞌa ito̱n. ");
INSERT INTO pps_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Ko ndo Pedro jii ndo ti jii ntasien nchia, ko konchjiñeꞌe naa nchri ncheꞌe ixra̱ ntiꞌa ko ndachro nchra: ―Jaꞌa kaxon kuajikuꞌa xi Jesús, xi nunte Galilea. ");
INSERT INTO pps_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Ko kain ni ste ntiꞌa kuinꞌen na̱ ngeꞌe juateꞌe ndo Pedro: ―Janꞌan chuxinꞌa xi ña̱. ");
INSERT INTO pps_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Tjumeꞌe ndo Pedro kuachrje ndo nduja ko tjenga nta̱chja inaa nchri bikon nchra ndo ko ndache nchra kain ni ste ntiꞌa: ―Xi jiꞌi kaxon chrikao xa xi Jesús neꞌe tjajna Nazaret. ");
INSERT INTO pps_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Tjumeꞌe ndo Pedro ndachro ndo íjngo ixi jeꞌe ndo chúxinꞌa ndo ndo Jesús: ―Ndo Dio noꞌe ndo ixi janꞌan chuxinꞌa xi ña̱. ");
INSERT INTO pps_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Ko nchion tjumeꞌe ni ste ntiꞌa, konchjiñeꞌe na̱ ti jii ndo Pedro ko jaꞌin ndachro na̱: ―Jaꞌa nduaxin kuajikuꞌa xi Jesús ixi kaxon nichja xranchi jeꞌe xa. ");
INSERT INTO pps_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Ko ndo Pedro kuaxi benga ndo teka ko ndachro ndo: ―Janꞌan chúxinꞌa xi ña̱. Ko hora meꞌe itsje̱ kuntaxichíká. ");
INSERT INTO pps_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Ko ndo Pedro xraxaon ndo ti nichja ndo Jesús: “Ko xraxrotsje̱ꞌa kuntaxichíká níi vez, jaꞌa xrondachrua ixi chuxinꞌana.” Tjumeꞌe ndo Pedro kuachrje ndo nduja ko tsango tsjanga ndo. ");
INSERT INTO pps_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Ko ngasáña, kain xitaana tetuanꞌan ko xi tachríi tetuanꞌan tjajna judío juao kichuu xa xranchi sincheꞌe xa ixi naatsóñaxón xa ndo Jesús. ");
INSERT INTO pps_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Ko kuintexin na̱ ndo Jesús ino ko bikao na̱ ndo ngajin xi Poncio Pilato, xi tetuanꞌan kui̱xi̱n tjajna Roma. ");
INSERT INTO pps_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","*Tjumeꞌe xi Judas, xi tsijinchekji ndo Jesús, bikon xa ixi naatsóñaxón na̱ ndo, meꞌe juincheniꞌe aséen xa, ko ikjui xa bijinchekjan xa ti níite tomi chika plata tsikayéꞌe xa, ti kuajon xitaana tsango tetuanꞌan ko ni tachríi. ");
INSERT INTO pps_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Ko ndachro xa: ―Janꞌan ndakoꞌa juintaꞌa ixi juintakji naa xi tsango jian. Ko jeꞌe na̱ juateꞌe na̱: ―Janꞌanna kondanaꞌina meꞌe. Jaꞌa noꞌa ngeꞌe ncheꞌe. ");
INSERT INTO pps_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Tjumeꞌe xi Judas juanka xa tomi chika plata ngaxinꞌin niꞌngo ko sakjui xa kuisintjianxin xa ixi ino tusin xa. ");
INSERT INTO pps_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Ko xitaana tetuanꞌan juejo xa tomi ko ndachro xa: ―Tomi jiꞌi juaꞌi tsa̱ke̱ꞌe̱ na̱ tomi ngaya ti tinga ofrenda, ixi tomi jiꞌin yaa tomi jnié chujni. ");
INSERT INTO pps_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Ko juao na̱ kondee tomi, tjumeꞌe kueꞌna na̱ naa ijngi ndatinꞌin Nunte xi Nchéña Ichi ixi ntiꞌa tsjabaa na̱ chujni tsiki̱ꞌxi̱n inaa tjajna. ");
INSERT INTO pps_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Ko nchakon jai jaña tinꞌin nunte meꞌe: Nunte Chónda Ijni̱. ");
INSERT INTO pps_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Jaña konꞌen ngeꞌe tsikjin ndo Jeremías, ndo kuachronga chijnie ndo Dio ó saꞌó: “Kua na̱ níi ite tomi chika plata, tomi xengaxin ꞌna̱ ixi xi kuenꞌen, (ña̱ ti tsindachro ni tjajna Israel tjintee xa), ");
INSERT INTO pps_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","tomi meꞌe kuenaxin na̱ nunte ndatinꞌin xi Nchéña Ichi, ixi jaña kuituanna Ncháina.” ");
INSERT INTO pps_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Ndo Jesús jii ndo ngajin xi ícha tetuanꞌan ko jaꞌin juanchangiꞌe xa ndo: ―¿Á jaꞌa Rey neꞌe ni judío? Ko ndo Jesús ndachro ndo: ―Jaꞌa ndachrua. ");
INSERT INTO pps_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Ko kain xitaana tetuanꞌan ko xi tachríi tetuanꞌan tjankataꞌa na̱ ndo ijie̱ ko jeꞌe ndo Jesús xroꞌan ngeꞌe juateꞌe ndo. ");
INSERT INTO pps_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Tjumeꞌe xi Pilato juanchangi xa: ―¿Á kuinꞌen kain ngeꞌe ichro na̱, juincheꞌe? ");
INSERT INTO pps_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Ko ndo Jesús xroꞌan ngeꞌe juatingíexin ndo, méxin xi tetuanꞌan xronka xa ko noeꞌa xa ngeꞌe sincheꞌe xa. ");
INSERT INTO pps_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Ko kia Pascua xi tetuanꞌan ngujngu nano bakajanda xa naa xi jixinꞌin ndoꞌachjiso, naa xi tjaun chujni tsachrje. ");
INSERT INTO pps_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Ko xi jii ngaxinꞌin ndoꞌachjiso, naa xi tsango ñaꞌi, ndatinꞌin Barrabás. ");
INSERT INTO pps_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Ko ntiꞌa ste itsjé chujni, tjumeꞌe xi Pilato juanchangiꞌe xa na̱: ―¿Ngisen tjaunnta tsajanda, á xi Barrabás o̱ xi Jesús nchekinꞌinnta Cristo? ");
INSERT INTO pps_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Ko xi Pilato noꞌe xa ixi tsango tochjuyeꞌe na̱ ngajin ndo Jesús, méxin tjaun na̱ tsenꞌen ndo. ");
INSERT INTO pps_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Ko xi Pilato jitaꞌa xa xitaon ti no tonchjianxin ijie̱ ko nchrinchriꞌe xa tsixruaꞌan nchra naa juajna ngajin xa: ―Xroꞌan ngeꞌe nchekua ndo Jesús ixi tsango tjúá aséen ndo ixi nakonkjin tsango chinga kuxinaxin kondee jeꞌe ndo. ");
INSERT INTO pps_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Ko xitaana tetuanꞌan ko ni tachríi tetuanꞌan juinchekateya na̱ chujni ixi tsjancheꞌe na̱ xi Pilato tsajanda xa xi Barrabás ko naatsóñaxón na̱ ndo Jesús. ");
INSERT INTO pps_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Ko tjumeꞌe xi Pilato íjngo nichjeꞌe xa kain chujni ste ntiꞌa ko ndachro xa: ―¿Ngisen tjaunnta tsajanda? Ko jeꞌe na̱ juatingíexin na̱: ―Tajanda xi Barrabás. ");
INSERT INTO pps_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Tjumeꞌe xi Pilato juanchangi xa: ―¿Ngeꞌe sintakian xi Jesús, xi nchekinꞌinnta Cristo? Ko kain na̱ kuyako na̱: ―¡Tjankanitua xa nta̱cru! ");
INSERT INTO pps_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Tjumeꞌe xi Pilato ndachro xa: ―¿Me ngeꞌe juintaꞌanta xi jiꞌin? Ko jeꞌe na̱ ícha séen kuyako na̱ ko ndachro na̱: ―¡Tjankanitua xa nta̱cru! ");
INSERT INTO pps_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Ko xi Pilato bikon xa ixi chujni ítitikaonꞌa na̱ ngeꞌe ichro jeꞌe xa ixi jeꞌe na̱ ícha kuyako na̱, méxin juanchia xa inda ko junéꞌma itja xa ko kain meꞌe stetikon chujni ste ntiꞌa ko ndachro xa: ―Janꞌan tsamaꞌi ijie̱ ti tsenꞌen xi jiꞌi, ixi xroꞌan ngeꞌe sínká xa. Jaꞌanta ti tsamanta ti tsenꞌen xa. ");
INSERT INTO pps_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Ko kain chujni ste ntiꞌa jaꞌin juatingíexin na̱: ―Janꞌanna ko chjanꞌna̱na tsamana ijie̱ ko jnié xi ña̱. ");
INSERT INTO pps_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Ko tjumeꞌe xi Pilato kuantsje xa xi Barrabás ko kuetuanꞌan xa ixi tsikaon ndo Jesús ko tjumeꞌe tsjankanito na̱ ndo nta̱cru. ");
INSERT INTO pps_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Ko xi soldadoe xi Pilato bikao na̱ ndo Jesús ti jii ntasien nchia tituanxin na̱ ko ntiꞌa xejo kain xi soldado. ");
INSERT INTO pps_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Tjumeꞌe kuantsjeꞌe na̱ ndo manta jiá ndo ko juinchekakeꞌe na̱ ndo naa manta játsetié. ");
INSERT INTO pps_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Ko ba̱ke̱ꞌe̱ na̱ ngataꞌa jaa ndo naa corona tsikonchjianxin nta̱chaꞌa ko ba̱ke̱ꞌe̱ na̱ ngaya itja ndo ti ndatsjonxin jian naa ntakuto. Ko tjumeꞌe takeꞌexin ntatuchiꞌin na̱ ko tjanoa na̱ ndo ko ndachro na̱: ―Kain nchakon tsakeꞌe, ndo rey tituenꞌen ni judío. ");
INSERT INTO pps_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ko tikitée na̱ ndatée na̱ ngaya ikon ndo ko itsé na̱ nta̱a̱ jiá itja ndo, meꞌe tandeꞌe na̱ nta̱a̱ jaa ndo. ");
INSERT INTO pps_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Ko juexin juano na̱, tjumeꞌe kuantsjeꞌe na̱ ndo manta játsetié ko juinchekitsa na̱ ndo mantée ndo. Tjumeꞌe bikao na̱ ndo ixi tsenito na̱ ndo nta̱cru. ");
INSERT INTO pps_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Ko hora stetachrjekaꞌo na̱ ndo Jesús, ntiꞌa jii naa xi tjajna Cirene, ndatinꞌin xa Simón, ko kuetuenꞌen na̱ xa tsama xa nta̱cru ti no tsakeꞌe na̱ ndo Jesús. ");
INSERT INTO pps_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Ko ti kuiji na̱ ti no ndatinꞌin Gólgota, (meꞌe xrondachro Ntajaa ni tsikenꞌen). ");
INSERT INTO pps_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Ntiꞌa chjée na̱ ndo Jesús tsiꞌi ndo nchíín vinagre tsikintekjanxin xro̱a̱n tsjá ko jeꞌe ndo tsjexion ndo xro̱a̱n meꞌe, ko kuiꞌa ndo. ");
INSERT INTO pps_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Hora juexin bakeꞌe xi soldado ndo Jesús nganito nta̱cru, tjumeꞌe sondaonxin xa ixro ixi jaña tsonoꞌe xa ngisen tsjacha tsitueꞌe manta jiá ndo ixi jaña tsonꞌen xranchi tsinichja sen kuachronga chijnie ndo Dio ó saꞌó, ko jaꞌin tsindachro sen: “Chjeyeꞌe na̱ mantána ko sondaonxin na̱ ixro ngataꞌa manta.” ");
INSERT INTO pps_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Tjumeꞌe xi soldado ntiꞌa kuituꞌe xa ixi tsendáa xa ndo Jesús. ");
INSERT INTO pps_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ko bakeꞌe na̱ naa nta̱a̱ ícha noixin ti jii jaa ndo, ntiꞌa jitaxin ngeꞌe kondeexin kóña na̱ ndo: “Ndo Jesús, ndo Rey tikinixinꞌen ni judío.” ");
INSERT INTO pps_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Kaxon kuenito na̱ yuu xicheꞌe nganito nta̱cru, naa xa ndatsjonxin jian ko í naa xa ndatsjonxin ikjon ti jii jeꞌe ndo. ");
INSERT INTO pps_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Ko ni stetatsinga ntiꞌa chinga ndache na̱ ndo ko nchetengi jaa na̱, ");
INSERT INTO pps_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","*ko ndachro na̱: ―Jaꞌa ndachrua ixi tsonjamangia niꞌngo ko níiko nchakon sinchekonchjian niꞌngo íjngo, cháña xingajinxian nta̱a̱ ña̱ siá nduaxin jaꞌa Chjenꞌen ndo Dio. ");
INSERT INTO pps_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Kaxon xitaana tetuanꞌan ko xi tjako ley ko xi fariseo ko ni tetuanꞌan tjajna, kain na̱ juanoa na̱ ndo Jesús, ko stetjao na̱: ");
INSERT INTO pps_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","―Ikaxin na̱ bingijna xi ña̱ ko jeꞌe xa juaꞌi xingajinxin xa nta̱cru. Siá jeꞌe xa Rey neꞌe ni Israel, ko siá xroxingajinxin xa nta̱cru, meꞌe tsitikaꞌonna xa. ");
INSERT INTO pps_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Jeꞌe xa chúntia xa ngajin ndo Dio, jeꞌe ndo tsingijna ndo xa siá nduaxin jeꞌe ndo Dio tjueꞌe ndo xa ixi jeꞌe xa ndachro xa: “Janꞌan Chjenꞌen ndo Dio.” ");
INSERT INTO pps_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Kaxon xicheꞌe stenito nta̱cru chinga ndache xa ndo Jesús. ");
INSERT INTO pps_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Ko xrangusine nchakon ko kuiji hora nínxin konaxixeꞌe ngataꞌa nunte xasintajni. ");
INSERT INTO pps_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Ko hora meꞌe ndo Jesús séen ndachro ndo: ―Elí, Elí, ¿lama sabactani? ―jiꞌi xrondachro: Ndotána, Ndotána, ¿sonda janꞌon kuintunaninta? ");
INSERT INTO pps_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Ko kaxin ni ste ntiꞌa kuinꞌen na̱ ngeꞌe ichro ndo, meꞌe ndachro na̱: ―Ndo kuanichjaxin chijnie ndo Dio, ndo Elías jitiyeꞌe xi Jesús. ");
INSERT INTO pps_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ko naa xi jii ntiꞌa itsé xa naa manta ko juinchetjao xa vinagre ko ba̱ke̱ꞌe̱ xa ikon naa ntasé ko chjée xa ndo Jesús xrokuiꞌi ndo. ");
INSERT INTO pps_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ko ikaxin ni ste ntiꞌa ndachro na̱: ―Chonꞌén, tsikonna á tsi̱i̱ ndo Elías tsingijna ndo xi Jesús. ");
INSERT INTO pps_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Tjumeꞌe ndo Jesús séen kuyako ndo íjngo, ko meꞌe juexin kuenꞌen ndo. ");
INSERT INTO pps_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Ko hora meꞌe kaxon velo jii ngaxinꞌin niꞌngo ti jingakuenxin luga tsango tjúá, chrinjin ngusinexin xrangíxixión noi hasta ti nunte. Ko hora meꞌe kontengí nunte ko chjenga ixro. ");
INSERT INTO pps_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Ko xitjeꞌe̱ tuye ti xrabaa chujni ko itsjé sen tsikitikaon ndo Dio, sen tjúá aséen, xechón sen. ");
INSERT INTO pps_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Nchakon xechón ndo Jesús, tjumeꞌe sen xechón, kui̱i̱ sen tjajna Jerusalén, tjajna tjúá, ko ntiꞌa itsjé chujni bikon ixi jeꞌe sen tsixechón sen. ");
INSERT INTO pps_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Ko xi centurión ko xi soldado jindaa ndo Jesús, bikon xa ixi kontengí nunte ko kain ngeꞌe konꞌen, tsango xronka xa, ko ndachro xa: ―Xi jiꞌi nduaxin Chjenꞌen ndo Dio. ");
INSERT INTO pps_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","*Ko kjínxin stetsjeꞌe kueya nchri, nchri tsirueꞌe ndo Jesús tsiki̱ꞌxi̱n tjajna Galilea, nchri meꞌe kuayakonꞌen ndo hora bikaꞌo na̱ ndo. ");
INSERT INTO pps_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Ngakjenꞌen ni ste ntiꞌa jii jan María Magdalena ko jan María, janée ndo Jacobo ko ndo José, ko janée chjenꞌen ndo Zebedeo. ");
INSERT INTO pps_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Hora kontie, kui̱i̱ naa xi chónda tsango itsjé tomi, kui̱xi̱n tjajna Arimatea, xi meꞌe ndatinꞌin xa José. Kaxon xi meꞌe juinchekuenꞌen ndo Jesús xa. ");
INSERT INTO pps_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Ko xi José ikjui xa ngajin xi Pilato, bijanchia xa cuerpoe ndo Jesús ko xi Pilato kuajon xa juachaxin. ");
INSERT INTO pps_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Tjumeꞌe xi José ikjui xa ko kuajin xa ndo Jesús ko kuintsía xa ndo naa manta tjúá. ");
INSERT INTO pps_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Ko ba̱ke̱ꞌe̱ xa cuerpoe ndo ngaya naa tuye natjúá tsikoña nganito naa itjao̱ ko kuincheka xa naa ixro ijié bijee̱xin itjao̱ ko tjumeꞌe sakjui xa. ");
INSERT INTO pps_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Ko ntiꞌa jii jan María Magdalena ko inaa jan María, ste sen nunte ti jii tuye. ");
INSERT INTO pps_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Ko ndúyaxin ti nchakon tjokéꞌe sen tjajna Israel, xitaana tetuanꞌan ko xi fariseo kuitsjeꞌe na̱ xi Pilato ");
INSERT INTO pps_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","*ko ndachro na̱: ―Janꞌanna stexraxaꞌonna ixi xi Jesús, xi kuancheya, ti xra jichón xa ndachro xa: “Nchakon tsenꞌenna, janꞌan xroxechónna nchakon nínxin.” ");
INSERT INTO pps_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Méxin, xruanꞌan xi soldado tsendáa xa tuye kaníi nchakon, ixi ba̱ tiie tsi̱i̱ ni bajikao xi Jesús ko tse̱e na̱ cuerpoe xa ko tjumeꞌe xrondache na̱ chujni tjajna ixi xechón xa. Ko meꞌe ícha tsitikaon na̱ xi Jesús. ");
INSERT INTO pps_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Tjumeꞌe ndachro xi Pilato: ―Ña̱ ste xi soldado. Jaꞌanta itjinta ko jian tijeꞌe̱nta tuye ti tsijabaa na̱ xi Jesús. ");
INSERT INTO pps_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Ko jeꞌe na̱ ikjui na̱ ko ba̱ke̱ꞌe̱ na̱ naa ixro ijié bijee̱xin tuye ko ba̱ke̱ꞌe̱ na̱ naa seña ngataꞌa ixro ko ntiꞌa kuintuꞌe na̱ kaxin xi soldado ixi tsendáa xa tuye. ");
INSERT INTO pps_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Kuatsinga nchakon tjokéꞌe sen tjajna judío. Xratingasáñaꞌi nchakon xrangíxixín semana, kui̱i̱ jan María Magdalena ko inaa jan María kuitsjeꞌe sen ti tsixrabaa ndo Jesús. ");
INSERT INTO pps_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Ko hora meꞌe kontengí nunte ixi naa ndo ángel neꞌe ndo Dio xingajinxin ngajní ko jeꞌe ndo kuintjian ndo ixro jijee̱xin itjao̱ ko bakeꞌe ndo ngataꞌa ixro meꞌe. ");
INSERT INTO pps_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Ko ndo ángel meꞌe tóngíxin ndo ko manta jiá ndo tsango tjúá xranchi chrinta. ");
INSERT INTO pps_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Ko xi soldado ste ntiꞌa, hora bikon xa ndo ángel, tsango xranga xa ko tjaun xrokuintekenꞌen xa ixi tsango xronka xa. ");
INSERT INTO pps_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Ko ndo ángel meꞌe jaꞌin nichjeꞌe ndo sen nchri: ―Jaꞌanta sen nchri, xrakonꞌanta. Janꞌan nóna ixi tjéenta ndo Jesús, ndo kuenxin nganito nta̱cru. ");
INSERT INTO pps_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Koꞌa ndo ntiꞌi, ixi jeꞌe ndo ó xechón ndo xranchi chronga ndo ó saꞌó. Xrokuiinta ko tsjeꞌenta ti no ba̱ke̱ꞌe̱ na̱ ndo. ");
INSERT INTO pps_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Ko tuinxin satjinta tindachenta sen bajikao ndo ixi jeꞌe ndo ó xechón ndo ko jeꞌe ndo ó sakuitaon ndo tjajna Galilea. Ntiꞌa tsikonnta ndo. Meꞌe ntanoꞌanta. ");
INSERT INTO pps_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Ko sen nchri kuachrjexin sen ti no tsixrabaa ndo Jesús, ko stexronka sen ko stechéꞌe sen. Tjumeꞌe nteeto sakjui sen kuichronga sen ngajin sen chrikao ndo Jesús. ");
INSERT INTO pps_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Ko jeꞌe ndo Jesús konoxin ndo ko kuajon ndo juajna ngajin sen nchri. Ko jeꞌe sen konchjiñeꞌe sen ngajin ndo ko joa sen tutée ndo, ko kuajon sen juasie sen. ");
INSERT INTO pps_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Tjumeꞌe jeꞌe ndo ndachro ndo: ―Xrakonꞌanta, ko satjinta tikekiꞌenta sen kichuuna ko itsji sen tjajna Galilea, ntiꞌa tsikonxin sen. ");
INSERT INTO pps_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Ko hora sakjui sen nchri, kaxin xi soldado jindaa ti tsixrabaa ndo Jesús sakjui xa tjajna Jerusalén kuichronga xa ngajin xitaana tetuanꞌan kain ngeꞌe konꞌen. ");
INSERT INTO pps_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Tjumeꞌe xitaana tetuanꞌan nichjeꞌe xa xi tetuanꞌan tjajna ko juao na̱ ixi xrochjée na̱ kueya tomi xi soldado. ");
INSERT INTO pps_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Ko ndache na̱ xi soldado: ―Jaꞌanta ndachronta ixi ó tiie meꞌe itsenta kotachrin ko stechrinnta, meꞌe kui̱i̱ ni chrikao xi Jesús, ko kuee na̱ cuerpoe xa, jaña chronta. ");
INSERT INTO pps_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ko siá tsonoꞌe xi tetuanꞌan nunte Israel, janꞌanna xronichjaꞌana xa ixi tsoñaoꞌa xa ngajinnta. ");
INSERT INTO pps_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Ko xi soldado kuayéꞌe xa tomi ko juincheꞌe xa xranchi kuituanꞌan xitaana. Ko ti konꞌen nchakon meꞌe ni tjajna Israel jaña teki na̱ hasta ti nchakon jai. ");
INSERT INTO pps_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","*Ko ti tenaá sen chrikao ndo Jesús sakjui sen ijna̱ nunte Galilea ixi jaña tsiketuanꞌan ndo. ");
INSERT INTO pps_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Ko hora bikon sen ndo, kuajon sen juasaya ngajin ndo ko kaxin sen xratitikaonꞌa sen ixi á jeꞌe ndo o̱ naꞌi. ");
INSERT INTO pps_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Ko ndo Jesús konchjiñeꞌe ndo ko ndachro ndo: ―Ijié juachaxin chjána ndo Dio ngajní ko ngataꞌa nunte xasintajni, ");
INSERT INTO pps_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","*méxin, itjinta kain tjajna jii ngataꞌa nunte xasintajni ko nchekuenꞌennta kain chujni chijnina ixi jaña tsitikaonna na̱ kaxon. Ko ni tsitikaon, tikitéenta na̱ ixi juachaxien Ndotána ko nombrée Chjenꞌen ndo ko Espíritue ndo. ");
INSERT INTO pps_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Ko nchekuenꞌennta sen ixi tsitikaon sen kain ngeꞌe kuetuanꞌan. Ko janꞌan tsakeꞌe ngajinnta kain nchakon hasta tsjexinja nunte xasintajni. Jaña tsonꞌen.");
INSERT INTO pps_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Jaꞌin xrangíxixín chijni jian neꞌe ndo Jesucristo, chjenꞌen ndo Dio. ");
INSERT INTO pps_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Xranchi jitaxin xroon tsikjin ndo profeta Isaías, ndo tsichronga chijnie ndo Dio ó saꞌó, ko jaꞌin ndachro xroon: Janꞌan xroxruanꞌan naa ngisen xrochronga chijnina, ndo meꞌe tsitaoꞌan ntiꞌa ixi sinchekonchjianꞌan ndo chaꞌo. ");
INSERT INTO pps_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Ko tsinꞌennta naa tée sen tsakeꞌe ntajie, ko tsuyako sen ko xrondachro: “Nchekonchjiannta chaꞌo tsi̱xi̱nꞌin Ncháina, tantjeꞌenta naa chaꞌo nao.” ");
INSERT INTO pps_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Jiꞌi konꞌen nchakon kui̱i̱ ndo Juan Bautista, bakeꞌe ndo ntajie bikitée ndo chujni. Juinchekuenꞌen ndo na̱ ixi xrokonda tsindoxin na̱ ti ndakoꞌa kuancheꞌe na̱ ko xrobikitée na̱ ixi jaña xrokoméꞌe ijie̱ chónda na̱. ");
INSERT INTO pps_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Kueya na̱ kui̱xi̱n na̱ nunte Judea ko tjajna Jerusalén kui̱i̱ na̱ ti bakeꞌe ndo Juan ixi tsinꞌen na̱ ngeꞌe ndachro ndo ko chronga na̱ ngeꞌe ndakoꞌa juincheꞌe na̱, ko ndo Juan bikitéexin ndo na̱ ndajitinga ndatinꞌin Jordán. ");
INSERT INTO pps_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Mantée ndo Juan tsikoña ixi chjuen kucamello ko tju̱a̱ jingatoxin ndo kaxon tsikoña tjueꞌé iku. Ko bajine ndo kuchjua ko tsjeen kunoa jii ntajie. ");
INSERT INTO pps_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ko ndo Juan juinchekuenꞌen ndo na̱ chijnie ndo Dio ko ndachro ndo: ―Tuenxinna janꞌan jiruéꞌe naa ngisen chónda ícha ijié juachaxin ixi najanꞌan. Ixi janꞌan chondaꞌi juachaxin tsoxindangaꞌa tjuée katée ndo. ");
INSERT INTO pps_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Janꞌan bikitéexinta inda ko jeꞌe ndo tsi̱i̱ ndo tsikitéxinnta ndo Espíritue ndo Dio. ");
INSERT INTO pps_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Nchakon meꞌe ndo Jesús kuachrjexin ndo tjajna Nazaret nunte Galilea ko ndo Juan bikitéexin ndo ndo Jesús ndajitinga ndatinꞌin Jordán. ");
INSERT INTO pps_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Ko hora kuachrjengíxin ndo Jesús inda, tuinxin bikon ndo xitjeꞌe̱ ngajní ko espíritue ndo Dio xingajin xranchi naa kuntúá ko bakeꞌe ngataꞌa jaa ndo Jesús. ");
INSERT INTO pps_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","*Ko kuinꞌen na̱ nichja naa tée sen kui̱xi̱n ngajní, ndachro: ―Jaꞌa chjanꞌna ko janꞌan tsango tjuaꞌanta. Ko janꞌan juaxruxin ritjén ixi jaꞌa. ");
INSERT INTO pps_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Ko tjumeꞌe Espíritue ndo Dio bikao ndo Jesús ngataꞌa ijna̱. ");
INSERT INTO pps_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Ntiꞌa bakeꞌe ndo Jesús yuu ikán nchakon ko ntiꞌa jii iku jieꞌe ko Xixronꞌanxrée tjaun xa xrojuincheyeꞌe xa ndo. Ko tjumeꞌe sen ángel kui̱i̱ sen kuayakonꞌen ndo Jesús. ");
INSERT INTO pps_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Juexinja xraxinꞌin na̱ ndo Juan ndoꞌachjiso, tjumeꞌe ndo Jesús sakjui ndo nunte Galilea ko juinchekuenꞌen ndo na̱ chijni jian xranchi jii ti no tetuanꞌan ndo Dio. ");
INSERT INTO pps_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","*Ko ndachro ndo: ―Ó kui̱i̱ nchakon, tsi̱i̱ juachaxien ndo Dio. Méxin tintuꞌenta ngeꞌe ndakoꞌa xraxaonnta ko titikaonnta chijni jian. ");
INSERT INTO pps_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Ndo Jesús jitji ndo ngandeꞌe inda nunte Galilea ko bikon ndo ndo Simón ko ndo kichuu ndo Simón ndatinꞌin Andrés. Jeꞌe sen stetsé sen kuchee̱ ko stetjánka sen nochaꞌa chringi inda. ");
INSERT INTO pps_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Ko ndachro ndo Jesús: ―Ruaꞌnaninta, ko xrotjáꞌanta ixra̱ xrotsénta chujni ixi tsitikaonna na̱. ");
INSERT INTO pps_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Ko tuinxin kuintuꞌe sen nochaꞌa tséxin sen kuchee̱ ko ruéꞌe sen ndo Jesús. ");
INSERT INTO pps_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Ko kjínꞌa kuiji ndo Jesús ko bikon ndo ndo Jacobo ko ndo kichuu ndo, Juan, chjenꞌen ndo Zebedeo. Jeꞌe sen ko ndotée sen steyá sen naa nta̱barco stenchekonchjian sen nochaꞌa ti tséxin sen kuchee̱. ");
INSERT INTO pps_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Ko tjumeꞌe ndo Jesús kuiyeꞌe ndo sen kaxon. Ko tuinxin kuintuꞌe sen ndotée sen, ndo Zebedeo, ko jeꞌe ndo kuituekao ndo xinchexra̱ ko nta̱barco. Ko ndo Jacobo ko ndo Juan ruéꞌe sen ndo Jesús. ");
INSERT INTO pps_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Ko tjumeꞌe kuiji sen tjajna Capernaum ko nchakon sábado, nchakon tjokéꞌe na̱, kuixinꞌin ndo Jesús ningue Israel ko kuaxi ndo juinchekuenꞌen ndo chujni ntiꞌa. ");
INSERT INTO pps_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","*Ko ni ste ntiꞌa xronka na̱ xranchi tjako ndo ixi chijnie ndo chónda ijié juachaxin ko jeꞌa xranchi nichja ni tjako ley. ");
INSERT INTO pps_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Ko ngaxinꞌin niꞌngo meꞌe jii naa xi chónda espíritue Xixronꞌanxrée ko séen kuyako xa ko ndachro xa: ");
INSERT INTO pps_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","―Tintuna̱na, Jesús tjajna Nazaret. ¿Á juiꞌia ixi sinchetjáñana? Janꞌan chuxian ko nóna ixi jaꞌa naa ngisen ícha tjúá tsixruaꞌan ndo Dio. ");
INSERT INTO pps_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Ko ndo Jesús kuyakutee ndo espíritue xi ñaꞌi, ko ndachro ndo: ―Tenkua, ko tachrjexian aséen xi ña̱. ");
INSERT INTO pps_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Ko espíritue Xixronꞌanxrée juanka xi meꞌe nunte ko kuyako xa séen ko kuachrje espíritu meꞌe. ");
INSERT INTO pps_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Ko kain na̱ xronka na̱ ko ndache kichuu na̱: ―¿Ngisen jiꞌi? ¿Ngeꞌe chijni natjúá nichja xa? Jeꞌe xa chónda xa ijié juachaxin ko tetuenꞌen xa espíritue Xixronꞌanxrée ko titikaon espíritu. ");
INSERT INTO pps_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Ko nchijíi nunte Galilea konoꞌe na̱ xranchi nchexruenꞌen ndo Jesús chujni ko xranchi nichja ndo. ");
INSERT INTO pps_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Tjumeꞌe ndo Jesús kuachrjexin ndo niꞌngo, ko sakjui ndo ndoꞌa ndo Simón ko ndo Andrés, ko sabikao ndo ndo Jacobo ko ndo Juan. ");
INSERT INTO pps_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Ko jachée ndo Simón jitsinga jan, níexin jan súa, ko ndache sen ndo Jesús ngeꞌe chónda jan. ");
INSERT INTO pps_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Ko ndo Jesús konchjiñeꞌe ndo ti jitsinga jan ko itsé ndo itja jan ko juinchengatjen ndo jan. Ko tuinxin kuachrjeꞌe jan súa ko kuajon jan juine sen. ");
INSERT INTO pps_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Ko ó kuitaon nchakon ko kontie, ko bikao na̱ ni niꞌe ko ni chónda espíritue Xixronꞌanxrée ti jii ndo Jesús ");
INSERT INTO pps_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","ko nchijíi tjajna xraꞌo na̱ ngandangi nduja nchia ti jii ndo. ");
INSERT INTO pps_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Ko ndo Jesús juinchexruenꞌen ndo kain ni niꞌe, ni chónda ngixeꞌi ichin ko kuantsje ndo itsjé espíritue Xixronꞌanxrée. Ko kuintueꞌa ndo xronichja xa ixi jeꞌe xa noꞌe xa ngisen jeꞌe ndo. ");
INSERT INTO pps_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Ko nandá jitingasáña kuaya ndo Jesús, kuachrjexin ndo tjajna meꞌe, sakjui ndo naa nunte xroꞌan ngisen ste, ntiꞌa xronichjeꞌe ndo ndotée ndo jii ngajní. ");
INSERT INTO pps_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Ko tjumeꞌe ndo Simón ko sen chrikao ndo juée sen ndo ");
INSERT INTO pps_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","ko hora kuitja sen ndo ndachro sen: ―Kain na̱ stetjéena̱nta. ");
INSERT INTO pps_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Ko ndachro ndo Jesús: ―Sachjina ikaxin tjajna tjenka ntiꞌi ixi kaxon ntiꞌa xronichja chijni jian, ixi meꞌó juixin janꞌan. ");
INSERT INTO pps_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","*Ko jaña nchijíi nunte Galilea kuaji ndo kain niꞌngo ko chronga ndo chijnie ndo Dio ko kuantsje ndo espíritue Xixronꞌanxrée chónda chujni. ");
INSERT INTO pps_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Ko naa xi níexin chinlepra konchjiñeꞌe xa ngajin ndo Jesús ko bakeꞌexin ntatuchiꞌin xa ko kuinóatée xa ngajin ndo, ko ndachro xa: ―Siá tjaunnta, chao nchexruannanta. ");
INSERT INTO pps_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Ko ndo Jesús bikonóeꞌe ndo xa ko bakeꞌe ndo itja ndo ngataꞌa jaa xa ko ndachro ndo: ―Jaán tjaꞌon; toxruanꞌan. ");
INSERT INTO pps_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Ko jaña ndachro ndo ko tuinxin koxruenꞌen xa. ");
INSERT INTO pps_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Ko ndo Jesús kuetuenꞌen ndo xa ixi satsji xa ko ndachro ndo: ");
INSERT INTO pps_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","―Xroꞌan ngisen tekiꞌé ixi koxruanꞌan. Itjia ngajin xitaana ixi ó koxruanꞌan ko tájuan ti tikinixin kuituanꞌan ndo Moisés, ko jaña tsikon kueya na̱ ixi koxruanꞌan. ");
INSERT INTO pps_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ko xi koxruenꞌen sakjui xa ko kuaxi bekiꞌe xa kain na̱ xranchi koxruenꞌen xa. Méxin, ndo Jesús imao bakixinꞌin ndo kain tjajna ko bakituꞌe ndo ti xroꞌan ngisen jii ko itsjé na̱ bajée na̱ ndo. ");
INSERT INTO pps_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Ko kuatsinga ikaxin nchakon ko tjumeꞌe ndo Jesús ikjan ndo tjajna Capernaum. Ko konoꞌe na̱ ixi bakeꞌe ndo naa nchia ntiꞌa. ");
INSERT INTO pps_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Ko kueya chujni konchjiñeꞌe ngajin ndo Jesús ko kuitjaꞌi nchia kuixinꞌin na̱ ko kaxon tsango tsjé chujni jii nduja nchia. Ko ndo Jesús banchekuenꞌen ndo na̱ chijnie ndo Dio. ");
INSERT INTO pps_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Ko tjumeꞌe kui̱i̱ noó xi bikao xa naa xi juaꞌi nchetengi tutée. ");
INSERT INTO pps_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Méxin, juaꞌi konchjiñeꞌe xa ti jii ndo Jesús ixi kueya na̱ ste ntiꞌa. Ko kuajinꞌin xa ngataꞌa nchia ko konxrato xa ngataꞌa nchia ko ntiꞌa juinchexingajinxin xa xi niꞌe jitaꞌa kania. ");
INSERT INTO pps_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Ko ndo Jesús bikon ndo ixi xi meꞌe tsango chuntia xa ko ndache ndo xi niꞌe: ―Chjanꞌna, ó tjáñana kain ti ndakoꞌa juincheꞌe. ");
INSERT INTO pps_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Ko kaxin xi tjako ley ste xa ntiꞌa, stexraxaon xa: ");
INSERT INTO pps_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“¿Sonda jaña nichja xi jiꞌi? Nichjangíꞌe xa ndo Dio. Ixi xroꞌan ngisen sincheméꞌe ijie̱; jeꞌo ndo Dio chao sincheméꞌe ndo ijie̱ chónda chujni”, jaña stexraxaon xa. ");
INSERT INTO pps_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Ko ndo Jesús ó noꞌe ndo ngeꞌe stexraxaon xa, méxin ndachro ndo: ―¿Sonda jaña xraxaonnta? ");
INSERT INTO pps_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","¿Ngeꞌe ti ícha tangiꞌa xrontatjan xi niꞌe? ¿Á ícha tangiꞌa xrontatjan xa ixi koméꞌe ti ndakoꞌa juincheꞌe xa, o̱ tsingatjen xa ko xrotsé xa kanieꞌe xa ko tsaxi tsaji xa? ");
INSERT INTO pps_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Méxin, jai tsjakoꞌanta ixi janꞌan Chjenꞌen ndo Dio, xjan jongíꞌe xranchi chujni, chonda xjan juachaxin ngataꞌa inche ko tsantsje xjan ijie̱ chónda chujni. Ko ndo Jesús ndache ndo xi niꞌe: ");
INSERT INTO pps_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","―Janꞌan ntatjua tingatjen ko itsé kaniaꞌa ko satjia ndúya. ");
INSERT INTO pps_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ko stetsjeꞌe kain na̱ ixi tuinxin bingatjen xi niꞌe ko itsé xa kanieꞌe xa ko kuachrjexin xa nchia, ko sakjui xa. Ko kain ni ste ntiꞌa xronka na̱ ko kaxin na̱ kuajon na̱ juasie na̱ ngajin ndo Dio ko ndachro na̱: ―Naiꞌa bikona jaña konꞌen. ");
INSERT INTO pps_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Ko tjumeꞌe ndo Jesús sakjui ndo ngandeꞌe inda ko itsjé chujni konchjiñeꞌe na̱ ti jii ndo ko jeꞌe ndo juinchekuenꞌen ndo na̱. ");
INSERT INTO pps_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Ko jitatsinga ndo ntiꞌa, bikon ndo ndo Mateo, chjenꞌen ndo Alfeo, jii ndo ti xengaxin iꞌna̱ tomi tayéꞌe xi tjajna Roma ko ndo Jesús ndachro ndo: ―Ruaꞌna̱na. Ko ndo Mateo bingatjen ndo ko tuinxin ruéꞌe ndo ndo Jesús. ");
INSERT INTO pps_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Ko tjumeꞌe ndo Jesús bakeꞌe ndo ndoꞌa ndo Mateo, ko kuajon sen ngeꞌe sine ndo. Ko kaxon ste kueya xi xengeꞌe ꞌna̱ ko ikaxin ni chónda ijie̱ ko juinekao na̱ ndo Jesús ko kao sen teyuu chrikao ndo. ");
INSERT INTO pps_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Ko kaxin xi tjako ley ko xi fariseo bikon xa ixi ndo Jesús jinekao ndo kain xi xengeꞌe ꞌna̱ ko ikaxin ni chónda ijie̱, ko juanchangiꞌe xa sen teyuu chrikao ndo Jesús, ko ndachro xa: ―¿Sonda xi tjakoꞌanta nekao xa ko tikao xa xi xengeꞌe ꞌna̱ ko ni chónda ijie̱? ");
INSERT INTO pps_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Ko ndo Jesús kuinꞌen ndo ngeꞌe ndache xa sen teyuu chrikao ndo meꞌe ndachro ndo: ―Ni níeꞌa xrokondeꞌa na̱ xinchexruan. Jeꞌo ni niꞌe xrokondeꞌe na̱ xinchexruan. Juiꞌa janꞌan ixi tsiyaꞌa ni ndako ncheꞌe. Juiꞌi ixi tsiyaꞌa ni chónda ijie̱. ");
INSERT INTO pps_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Naa nchakon sen chrikao ndo Juan Bautista ko xi fariseo juinchekatse ñao na̱ jinta nguixin nchakon, ko kui̱i̱ kaxin na̱ nichjeꞌe na̱ ndo Jesús ko ndachro na̱: ―¿Sonda ni chrikao ndo Juan ko ni fariseo nchekatse ñao na̱ jinta ko ni chrjikoꞌa jaꞌa, naꞌi? ");
INSERT INTO pps_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Ko jaꞌin juatingíexin ndo Jesús: ―¿Á xrojuinchekatsé ñao na̱ jinta, ni tsikiyeꞌe xi kuteꞌe nchakon tsiki̱i̱ na̱ kiée xa? Naꞌi ixi xrastekao na̱ xa. ");
INSERT INTO pps_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Ko tsi̱i̱ nchakon xrotsé na̱ xi tsikuteꞌe, satsikao na̱ xa, ko tjumeꞌe ni kuiyeꞌe xa sinchekatse ñao na̱ jinta. ");
INSERT INTO pps_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","’Xroꞌan ngisen tonchrijin tuꞌo manta natjúá ko takeꞌe na̱ ti manta tsitje. Siá jaña sincheꞌe na̱, tsichje manta tsitje ko í xroꞌan tsonta manta natjúá. ");
INSERT INTO pps_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Kaxon juaꞌi tsikia xran vino natjúá ngaya tjua̱nxra̱n nta̱xi, ixi siá jaña tsonꞌen, tsichje tjua̱nxra̱n meꞌe, ko ixran ko tjua̱nxra̱n ndatsitjáña. Méxin, xran natjúá xrokonda tsikia xran naa tjua̱nxra̱n natjúá, ko jaña kayui ngeꞌe tsitjáñaꞌi. ");
INSERT INTO pps_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Naa nchakon sábado tjokéꞌe ni judío, ndo Jesús ko sen teyuu chrikao ndo kuatsinga sen tjenka naa ijngi tsikenga na̱ noatrigo ko sen teyuu chrikao ndo kuaxi sen konchrinjin sen kaxin iti̱n trigo. ");
INSERT INTO pps_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Ko kaxin xi fariseo juanchangiꞌe xa ndo Jesús: ―¿Sonda sen chrjikoꞌa stencheꞌe sen naa ixra̱ tikinixinꞌa sincheꞌeni nchakon tjokéꞌeni? ");
INSERT INTO pps_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Ko ndachro ndo Jesús: ―¿Á noaꞌinta ti ndachro xroon jitaxin chijnie ndo Dio chronga xranchi juincheꞌe ndo David ko sen bikao ndo, naa nchakon kuenꞌen sen jinta? ");
INSERT INTO pps_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Méxin, nchakon bakeꞌe xi Abiatar, xitaana tetuanꞌan, jeꞌe ndo David kuixinꞌin ndo ndoꞌa ndo Dio ko juine ndo nutja tikinixinꞌen ndo Dio ko kaxon kuajon ndo nio juine kain sen bikao ndo. Ko nutja meꞌe jeꞌo xitaana chónda xa juachaxin sine xa nio. ");
INSERT INTO pps_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Kaxon ndachro ndo Jesús: ―Kóña nchakon tjokéꞌeni ixi xrokonda tsjokéꞌe chujni, jeꞌa ixi xrokuajonni juasieni ngajin nchakon meꞌe. ");
INSERT INTO pps_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Ko janꞌan Chjenꞌen ndo Dio, xjan jongíꞌe xranchi chujni, chónda juachaxin tsetuanꞌan ngeꞌe tsonꞌen nchakon tjokéꞌeni. ");
INSERT INTO pps_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Ko tjumeꞌe ndo Jesús kuixinꞌin ndo ndoꞌa ndo Dio íjngo. Ko ntiꞌa bakeꞌe naa xi tsixema naa itja. ");
INSERT INTO pps_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Ko konchjiñeꞌe kaxin xi stetsaya xa ndo Jesús ixi tsikon xa á sinchexrjuenꞌen ndo xi meꞌe, nchakon tjokéꞌe na̱ ixi jaña tsjankataꞌa xa ndo Jesús ijie̱. ");
INSERT INTO pps_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Ko ndo Jesús ndache ndo xi tsixema itja: ―Tingatjen ko takeꞌé ngusine ntiꞌi. ");
INSERT INTO pps_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Ko juanchangiꞌe ndo Jesús ni ste ntiꞌa, ko ndachro ndo: ―Nchakon tjokéꞌeni, ¿á chao sincheꞌeni ti jian, o̱ á chao sincheꞌeni ti ndakoꞌa? ¿Á chao tsingijnani naa ngisen?, o̱, ¿á naatsóñaxónni naa chujni? Ko jeꞌe na̱ tenko na̱. ");
INSERT INTO pps_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Ko ndo Jesús koñao ndo, ko bikon ndo kain ni ste ntiꞌa, meꞌe koniꞌe aséen ndo ixi tsango ícha aséen na̱. Ko ndache ndo xi niꞌe: ―Tinxe tjáa. Ko jeꞌe xa kuinxe itja xa, ko hora meꞌe koxruenꞌen itja xa. ");
INSERT INTO pps_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Ko xi fariseo kuachrjexin xa ntiꞌa ko ikjui xa ti ste ni tjento xi Herodes ko juao kichuu xa xranchi naatsóñaxón xa ndo Jesús. ");
INSERT INTO pps_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Ko ndo Jesús ko sen teyuu chrikao ndo sakjui sen ngandeꞌe inda. Ko kueya na̱ jiruéꞌe na̱ sen, ni tsiki̱ꞌxi̱n nunte Galilea ko kaxon nunte Judea ");
INSERT INTO pps_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","ko tjajna Jerusalén ko nunte Idumea ko ikaxin na̱ tsiki̱ꞌxi̱n na̱ tonꞌen inda jitinga ndatinꞌin Jordán ko kaxon ni tsiki̱ꞌxi̱n no tjajna Tiro ko tjajna Sidón. Ko kain na̱ tsikinꞌen na̱ ixra̱ ijié juincheꞌe ndo Jesús ko kaxon tjaun na̱ tsikon na̱ meꞌe. ");
INSERT INTO pps_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","*Tjumeꞌe kuituenꞌen ndo sen teyuu chrikao ndo ixi ntiꞌao xrochonꞌen naa nta̱barco. Ko hora tsango xrokuixintja na̱ ndo xrokuixinꞌin ndo nta̱barco ");
INSERT INTO pps_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","ixi kueya na̱ tsijinchexruenꞌen ndo, ko kain ni niꞌe kuixintja na̱ ndo ixi tjaun na̱ xrotsé na̱ ndo. ");
INSERT INTO pps_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Ko kaxin na̱ chónda na̱ espíritue Xixronꞌanxrée ko hora bikon na̱ ndo Jesús bakeꞌexin na̱ ntatuchiꞌin na̱ ngajin ndo. Ko kuyako espíritue Xixronꞌanxrée ko ndachro: ―Jaꞌa chjenꞌen ndo Dio. ");
INSERT INTO pps_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ko ndo Jesús kuyakutee ndo espíritue Xixronꞌanxrée ko ndachro ndo ixi xrochrongaꞌi xa ngisen jeꞌe ndo. ");
INSERT INTO pps_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Tjumeꞌe kuajinꞌin ndo Jesús naa ijna̱, ko ntiꞌa kuiyeꞌe ndo sen tjaun ndo xrokuajikao ndo ko konchjiñeꞌe sen ngajin ndo. ");
INSERT INTO pps_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Ko kuincheꞌe ndo teyuu sen tsajikao ndo ixi tsetuenꞌen ndo sen satsji sen xrochronga sen chijni jian. ");
INSERT INTO pps_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Ko kuajon ndo juachaxin sinchexrjuenꞌen sen ni niꞌe ko tsantsje sen espíritue Xixronꞌanxrée chónda na̱. ");
INSERT INTO pps_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Ko sen teyuu kuincheꞌe ndo jaꞌin ndatinꞌin sen: ndo Simón, ndo juinchekinꞌin ndo Jesús Pedro; ");
INSERT INTO pps_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","ko ndo Jacobo ko ndo kichuu ndo, ndo Juan, sen meꞌe chjenꞌen ndo Zebedeo. Kaxon sen meꞌe juinchekinꞌin ndo Jesús Boanerges meꞌe xrondachro chjenꞌen ti Tjateé. ");
INSERT INTO pps_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Ko ndo Andrés, ndo Felipe, ndo Bartolomé, ndo Mateo, ndo Tomás, ndo Jacobo, chjenꞌen ndo Alfeo, ko ndo Tadeo ko inaa ndo Simón, ndo tikinixin naa partido romano ndatinꞌin cananista, ");
INSERT INTO pps_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ko xi Judas Iscariote, xi juinchekji ndo Jesús. ");
INSERT INTO pps_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Ko tjumeꞌe ndo Jesús ko sen teyuu chrikao ndo kuixinꞌin sen naa nchia. Ko íjngo kueya na̱ xraꞌo na̱ ntiꞌa ko juaꞌi juine ndo Jesús ko sen teyuu chrikao ndo. ");
INSERT INTO pps_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Ko konoꞌe sen ndoꞌa ndo Jesús ixi ntiꞌa jii ndo ko kui̱i̱ sen ixi satsikao sen ndo ixi ndachro sen jeꞌe ndo tsinchetjáña jaa ndo. ");
INSERT INTO pps_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","*Ko kaxon kui̱i̱ kaxin xi tjako ley tsiki̱ꞌxi̱n tjajna Jerusalén ko ndachro xa: ―Xi jiꞌi chónda xa juachaxien Beelzebú, Xixronꞌanxrée, xi tetuenꞌen kain espíritu ñaꞌi, méxin, chao tantsje xa espíritue Xixronꞌanxrée. ");
INSERT INTO pps_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Ko ndo Jesús kuiyeꞌe ndo xi ndachro meꞌe ko jaꞌin juakoxin ndo: ―¿Xranchi Xixronꞌanxrée jeꞌo xa tsantsje xa espíritue xa? ");
INSERT INTO pps_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Siá naa tjajna, jeꞌo na̱ tse̱to̱kaꞌo kichuu na̱, juaꞌi tsintekao kichuu na̱ jian. ");
INSERT INTO pps_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Ko ni stekao kichuu naakua nchia, siá ningakonꞌen kichuu na̱, kaxon juaꞌi tsekao kichuu na̱ ndako. ");
INSERT INTO pps_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ko kaxon jaña siá Xixronꞌanxrée tse̱to̱kaꞌo xa juachaxin chónda xa, ndatsitjáña juachaxin meꞌe. ");
INSERT INTO pps_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","’Xroꞌan ngisen chao tixinꞌin ndoꞌa naa xi soji ixi tse̱e na̱ ngeꞌe chónda xa. Saꞌó xrokonda xrokuintee na̱ xi soji ixi chao tse̱e na̱ ngeꞌe chónda xa. ");
INSERT INTO pps_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","’Nduaxin ntatjunta ixi ndo Dio chao sincheméꞌe ndo kain ijie̱ chónda chujni ko kain ngeꞌe ndakoꞌa tsinichja na̱. ");
INSERT INTO pps_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","*Ko ngisen xronichja ndakoꞌa ixi Espíritue ndo Dio juaꞌi tsoméꞌe ijie̱ meꞌe, ni xronichja meꞌe, kain nchakon tsama na̱ ijie̱. ");
INSERT INTO pps_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Jaña ichro ndo Jesús ixi ni meꞌe tsindachro na̱ ixi jeꞌe ndo chónda ndo espíritue Xixronꞌanxrée. ");
INSERT INTO pps_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Ko tjumeꞌe janée ndo Jesús ko xi kichuu ndo kuiji sen ti jii ndo Jesús ko nduja nchia ste sen, kuituenꞌen sen naa xi tsikiyeꞌe xa ndo Jesús. ");
INSERT INTO pps_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Ko sen ste ngajin ndo Jesús, ndache sen ndo: ―Janáanta ko xi kichuunta ste sen nduja ko nichjaꞌanta sen. ");
INSERT INTO pps_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Ko ndo Jesús ndachro ndo: ―¿Ngisen janána ko ngisen sen kichian? ");
INSERT INTO pps_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Ko jitsjeꞌe ndo kain ni ste ntiꞌa ko ndachro ndo: ―Sen jiꞌi meꞌe sen janána ko sen kichian. ");
INSERT INTO pps_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Kain sen ncheꞌe ngeꞌe tjaun ndo Dio, sen meꞌe sen kichian ko janána. ");
INSERT INTO pps_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","*Tjumeꞌe ndo Jesús íjngo juangíxin ndo juinchekuenꞌen ndo na̱ ngandeꞌe ndalago. Ko ntiꞌa xraꞌo itsjé chujni ti jii ndo. Ko jeꞌe ndo kuixinꞌin ndo naa nta̱barco jitaꞌa inda, ko ntiꞌa bakeꞌe ndo nunte. Ko kain na̱ kuituꞌe na̱ ngandeꞌe inda. ");
INSERT INTO pps_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Ko itsjé ngeꞌe juinchekuenꞌen ndo na̱. Ko ndachro ndo: ");
INSERT INTO pps_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","―Tinꞌennta jiꞌi: Naa xi kuikenga tse̱e̱, ");
INSERT INTO pps_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","ko kaxin tse̱e̱ kuenga xa kuitsinga tse̱e̱ ngandeꞌe chaꞌo. Ko kui̱i̱ kuxe juine ba tse̱e̱. ");
INSERT INTO pps_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Ikaxin tse̱e̱ kuitsinga tse̱e̱ ti jii kueya ixro, ti koꞌa itsjé inche, ko taka kuachrje ika ixi tjínꞌa inche, ");
INSERT INTO pps_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","ko nchakon kuachrje chjiixro ichján ka ko xema ka ixi yasoeꞌa jii nueꞌe ka. ");
INSERT INTO pps_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Ko kaxin tse̱e̱ kuitsinga tse̱e̱ ti jii nta̱chaꞌa. Ko nta̱chaꞌa ícha kuangi nta̱a̱. Meꞌe xrabaatja ka ko ndakuangiꞌa ka. ");
INSERT INTO pps_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Ko ícha tse̱e̱ kuitsinga ngataꞌa inche jian, meꞌe tse̱e̱ chaxro kuangi ka. Ko tsango kueya tse̱e̱ kuajon ika meꞌe; naa kuajon ikánte tse̱e̱, ko inaa ka kuajon níikán tse̱e̱, ko inaa kuajon naa ciento tse̱e̱. ");
INSERT INTO pps_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Ko ndachro ndo Jesús: ―Ngisen tjaun tsinꞌen, tsinꞌen sen jian. ");
INSERT INTO pps_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Ko nchakon kuituꞌe ndo Jesús jeꞌo ndo, sen ste tjenka ndo ko sen teyuu chrikao ndo juanchangiꞌe sen ndo ngeꞌe xrondachro ngeꞌe beki ndo. ");
INSERT INTO pps_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Ko jeꞌe ndo Jesús ndachro ndo: ―Ndotána tjaun ndo tsienxinnta ti noaꞌinta ti tetuanꞌan jeꞌe ndo. Ko ni kaxin tsekiexinni na̱ xranchi tekini naa chijni, ");
INSERT INTO pps_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","ixi maski tikon na̱ ko tinꞌen na̱ ko jaña tsienxinꞌa na̱ ixi tsindoxinꞌa na̱ ti ndakoꞌa ncheꞌe na̱, xrokjanꞌi na̱ ngajin ndo Dio ko jaña jeꞌe ndo tsantsjeꞌa ndo ijie̱ chónda na̱. ");
INSERT INTO pps_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Ko tjumeꞌe ndache ndo sen: ―¿Á tienxinꞌanta xranchi xrondachro ngeꞌe bekiꞌanta? Siá naꞌi, ¿xranchi tsienxinnta ikaxin ngeꞌe tsekiꞌanta? ");
INSERT INTO pps_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Sen kuikenga tse̱e̱ meꞌe jii xranchi naa ngisen juinchekueꞌenni chijnie ndo Dio. ");
INSERT INTO pps_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Ko kaxin sen meꞌe xranchi tse̱e̱ kuitsinga ngandeꞌe chaꞌo, ixi kuinꞌen sen chijnie ndo Dio, ko tjumeꞌe kui̱i̱ Xixronꞌanxrée ko nchetjáñajin xa sen. ");
INSERT INTO pps_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Ikaxin tse̱e̱ kuitsinga ti jii ixro, meꞌe sen kuinꞌen chijnie ndo Dio ko juaxruxin bakeꞌe sen, ");
INSERT INTO pps_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","ko séꞌa kuitikaon sen ixi kui̱i̱ juachjaon ngataꞌa sen ko koñaoꞌe na̱ sen ixi kuitikaon sen chijnie ndo Dio, méxin kuintuꞌe sen ti kuitikaon sen ndo. ");
INSERT INTO pps_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Ko tse̱e̱ kuitsinga ngakjenꞌen nta̱chaꞌa meꞌe sen tinꞌen chijnie ndo Dio, ");
INSERT INTO pps_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","ko ícha ncheꞌe sen tjée sen tomi ko ícha ruéꞌe sen ti jii juaxruxin. Kain jiꞌi tingakonꞌen ixi tsinꞌen sen chijnie ndo Dio, ko ncheꞌa sen ti tjaun ndo. ");
INSERT INTO pps_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ko tse̱e̱ kuitsinga ti jii inche jian, sen meꞌe tayéꞌe sen chijnie ndo Dio ko titikaon sen kain ti ndachro ndo ko jian ncheꞌe sen ngajin ndo Dio. Sen meꞌe ste sen xranchi tse̱e̱ kuajon ikánte tse̱e̱, ko ikaxin sen xranchi tse̱e̱ kuajon níikán tse̱e̱, ko ikaxin sen xranchi tse̱e̱ kuajon naa ciento tse̱e̱. ");
INSERT INTO pps_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","*Ko kaxon ndachro ndo Jesús: ―¿Á xrochóndani naa xroꞌi ko xroꞌi meꞌe á tsemáni xroꞌi ngangi naa ntacajón o̱ tsakeꞌeni xroꞌi ngangi naa nta̱a̱ tejuataꞌani? Naꞌi, jeꞌa meꞌe sincheꞌeni. Xrokonda nui tsakeꞌeni xroꞌi meꞌe ixi chao tsingasáña xroꞌi. ");
INSERT INTO pps_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","*Méxin, xroꞌan ngeꞌe ti jimá tsonoxinꞌa ko xroꞌan ngeꞌe imao tsonoeꞌa na̱ xrojan nchakon ixi kain ngeꞌe tsonoxin ixi xroꞌi. ");
INSERT INTO pps_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Ko ngisen tjaun tsinꞌen, tsinꞌen sen jian. ");
INSERT INTO pps_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","*Ko kaxon ndachro ndo: ―Méxin, jaꞌanta tinꞌennta jian. Xranchi jaꞌanta tájonnta ngeꞌe ngajin ikaxin na̱, jaña ndo Dio xrotjáanta ndo kaxon, ko ícha itsjé xrotjáanta ndo. ");
INSERT INTO pps_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","*Ni itsjé chónda, ndo Dio tsingijna ndo xrochónda na̱ ícha. Ko ni xroꞌan ngeꞌe chónda, ndo Dio tsantsjeꞌe ndo na̱ ti ngeꞌe chónda na̱. ");
INSERT INTO pps_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Ko kaxon ndachro ndo Jesús: ―Ti juachaxin tetuanxin ndo Dio jii xranchi naa ngisen tikenga nunte. ");
INSERT INTO pps_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Ko maski tejua sen ko taya sen ko tatsinga kaxin nchakon ko kaxin tiie, tse̱e̱ kuenga sen tachrje tse̱e̱ ko tangi tse̱e̱. Ko sen kuenga noeꞌa sen xranchi konꞌen jiꞌi. ");
INSERT INTO pps_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Ixi inche jeꞌo nche juincheꞌe ixra̱. Saꞌó tachrje chaan no, ko tjumeꞌe ntée, ko tjumeꞌe ticha ko tóña tse̱e̱. ");
INSERT INTO pps_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ko nchakon ticha tse̱e̱ meꞌe xrokonda xrochrijin tse̱e̱. ");
INSERT INTO pps_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Ko kaxon ndachro ndo Jesús: ―¿Ngeꞌe xrondachro ti juachaxin tetuanꞌan ndo Dio? ");
INSERT INTO pps_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Naxreꞌo xranchi naa tse̱e̱ ndatinꞌin mostaza tsikenga naa xi jngiꞌe xa. Jiꞌi naa tse̱e̱ ícha nchíín ixi kain tse̱e̱ jii xasintajni. ");
INSERT INTO pps_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Ko ti tsikinga tse̱e̱, tangi ka ko ikjan naa nta̱a̱ ícha ijié ixi ikaxin nta̱a̱ jii ngataꞌa nunte. Ko kaxon chaan nta̱a̱ tangi ícha noi, ko kuxe tjanga ba ko chao nchéña ba kakée ba chringi tsauen nta̱a̱. ");
INSERT INTO pps_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Jaña ndo Jesús juinchekuenꞌen ndo kain na̱, ko beki ndo kueya ngeꞌe xranchi chao xrokuienxin na̱. ");
INSERT INTO pps_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Ko kainxin ngeꞌe juinchekuenꞌen ndo na̱ beki ndo xranchi naa chijni. Ko juexin juinchekuenꞌen ndo na̱, tjumeꞌe ndache ndo sen teyuu chrikao ndo xranchi xrondachro kain ti beki ndo. ");
INSERT INTO pps_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Ko nchakon meꞌe ó kóndo ndache ndo Jesús sen teyuu chrikao ndo: ―Tsatsingatuꞌena ndalago. ");
INSERT INTO pps_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Ko tjumeꞌe kuintuꞌe sen kain ni ste ntiꞌa ko sabikao sen ndo Jesús ngaxinꞌin nta̱barco ko kaxon ikaxin nta̱barco sakjui nta̱a̱. ");
INSERT INTO pps_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Ko tuinxin kui̱i̱ naa chrinto soji ko tsango juinchetengi inda ko nta̱barco kuaxi bikia nta̱a̱ inda ko kuaxi konuntengi nta̱barco. ");
INSERT INTO pps_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Ko ndo Jesús ndakuejua ndo ícha ndáꞌa ngaxinꞌin nta̱barco ko jikjón ndo naa noxra. Ko juinchexingameꞌe sen ndo, ko ndachro sen: ―¡Maestro! ¿Á taꞌinta juachjaon ixi xrokjuina inda? ");
INSERT INTO pps_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Ko jeꞌe ndo bingatjen ndo, ko kuyakutee ndo chrinto ko inda ko ndachro ndo: ―Tenkua ko ndatakeꞌe. Ko tuinxin jeꞌe inda ndabakeꞌe inda ko chrinto kaxon. ");
INSERT INTO pps_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Ko ndache ndo jeꞌe sen: ―¿Sonda xrakonnta? ¿Á xrachuntiaꞌantana janꞌan? ");
INSERT INTO pps_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ko jeꞌe sen xronka sen ko ndache kichuu sen: ―¿Ngixeꞌi xi jiꞌin ixi tituenꞌen xa chrinto soji ko inda ko kayui titikaon ngajin xa? ");
INSERT INTO pps_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Ko tjumeꞌe kuatsingatuꞌe sen ndalago, ko kuiji sen nunte Gadara. ");
INSERT INTO pps_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Ko ndo Jesús xingajinxin ndo nta̱barco ko tuinxin naa xi konchjiñeꞌe xa ngajin ndo ko kuixi xa ti jii itjao̱ ti tsixrabaa chujni ko chónda xa espíritue Xixronꞌanxrée. ");
INSERT INTO pps_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Xi meꞌe bakeꞌe xa ti ste itjao̱ ti tsixrabaa chujni tsikenꞌen, ko xroꞌan ngisen chao tokuaxinꞌen itsé xa ko juaꞌi tsitexin xa nochika. ");
INSERT INTO pps_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Ko itsjé vez bakichruaxin na̱ tutée xa ko itja xa ixi nochika, ko jeꞌe xa bakonchrindaon xa chika. Ko xroꞌan ngisen tjacha tjintee xa. ");
INSERT INTO pps_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Bakaji xa tiie ko nchakon ti jii ijna̱ ko ti tsixrabaa chujni ko ntiꞌa kuyako xa ko ixro tandeꞌe xa ntakuin xa. ");
INSERT INTO pps_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Ko ikjín bikon xa ndo Jesús ko binga xa konchjiñeꞌe xa ko bakeꞌexin ntatuchiꞌin xa ngajin ndo ");
INSERT INTO pps_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","ko séen kuyako xa: ―¿Sonda nchexronkana Jesús, chjenꞌen ndo Dio jii ngajní? Janꞌan tjaunꞌa sinchexronkana. ");
INSERT INTO pps_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Jaña ndachro xa ixi tsindachro ndo Jesús: ―Jaꞌa espíritu ñaꞌi, tachrjexian xi ña̱. ");
INSERT INTO pps_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Ko ndo Jesús juanchangiꞌe ndo espíritu meꞌe: ―¿Xranchi tiꞌian? Ko jeꞌe espíritu meꞌe jaꞌin juatingíexin: ―Janꞌanna ndatinꞌinna Legión ixi tsango itsjé janꞌanna. ");
INSERT INTO pps_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ko kain espíritue Xixronꞌanxrée kuinóatée ngajin ndo Jesús ixi xroxruanꞌi ndo espíritu satsji ikjín. ");
INSERT INTO pps_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Ko tjenka ntiꞌa jii naa ijna̱ steneña itsjé kuchinga. ");
INSERT INTO pps_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Ko kuinóatée kain espíritue Xixronꞌanxrée ko ndachro: ―Tituanꞌan satsjina ti ste kuchinga, ko tájuan juachaxin tsixinꞌinna ngaxinꞌin ba. ");
INSERT INTO pps_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Ko tuinxin ndo Jesús kuajon ndo juachaxin. Ko kain ti espíritue Xixronꞌanxrée kuachrjexin xi meꞌe, ko kuixinꞌin espíritu ngaxinꞌin kuchinga. Ko kain ko ste ntiꞌa xranchi yuu mil ba. Ko kain ba binga ba ko kuitsingangi ba ti yasoꞌe jii ndalago ko kjunꞌen ba inda. ");
INSERT INTO pps_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Ko tjumeꞌe xi stetsjeꞌe kuchinga xrakon xa ko binga xa kuindache xa ni tjajna ngeꞌe konꞌen ko kaxon kuindache xa ni ste ngataon ijngi ngeꞌe konꞌen. Ko tjumeꞌe itsjé na̱ kuitsjeꞌe na̱ ngeꞌe konꞌen ntiꞌa. ");
INSERT INTO pps_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Ko hora kuiji na̱ ti jii ndo Jesús, bikon na̱ ixi ntiꞌa jii xi kuachónda kain espíritue Xixronꞌanxrée ko jii xa nunte ko jiá xa manta ko ó ndako xraxaon xa, ko bikon na̱ meꞌe xronka na̱. ");
INSERT INTO pps_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Ko kain ni bikon ngeꞌe konꞌen, kueki na̱ xranchi konꞌen xi kuachónda espíritue Xixronꞌanxrée ko ngeꞌe tsikonꞌen kuchinga. ");
INSERT INTO pps_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Ko kuaxi na̱ kuinóatée na̱ ngajin ndo Jesús ixi satsjixin ndo ntiꞌa. ");
INSERT INTO pps_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Ko ndo Jesús kuajinꞌin ndo nta̱barco ko ti xi kuachónda espíritue Xixronꞌanxrée kuinóatée xa ixi kao xa xrokjui xa. ");
INSERT INTO pps_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Ko ndo Jesús kuajonꞌa ndo juachaxin ixi kao xa itsji xa ko ndachro ndo: ―Satjia ko tekiꞌé kain sen ndúya kain ngeꞌe juincheꞌe ndo Dio ngajian ko xranchi bikonóaꞌa ndo. ");
INSERT INTO pps_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Ko xi meꞌe sakjui xa ko kuaxi bekiꞌe xa kain ni tjajna tikinixinꞌen Decápolis kain ngeꞌe juincheꞌe ndo Jesús ngajin xa. Ko kain ni kuinꞌen tsango xronka na̱. ");
INSERT INTO pps_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Íjngo ndo Jesús kuixinꞌin ndo nta̱barco ko sakjui ndo tuenxin ndalago, ko ntiꞌa kueya na̱ konchjiñeꞌe na̱ ngajin ndo ko jeꞌe ndo ndiꞌao kuituꞌe ndo ngandeꞌe nda. ");
INSERT INTO pps_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Ko tjumeꞌe kui̱i̱ naa xi baketuanꞌan naa niꞌngo judío, xi meꞌe ndatinꞌin xa Jairo. Ko hora bikon xa ndo Jesús, bakeꞌexin ntatuchiꞌin xa ngajin ndo, ");
INSERT INTO pps_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","ko jaꞌin kuinóatée xa: ―Xjanchrichjanꞌna jiteꞌen xjan. Ixudio ichjina nía, takée tjáanta ngataꞌa xjan ixi tsoxruenꞌen xjan. ");
INSERT INTO pps_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Ko tjumeꞌe ndo Jesús sabikao ndo xa ko tsango itsjé na̱ ruéꞌe na̱ ko kuixintja na̱ ndo Jesús. ");
INSERT INTO pps_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Ko ngakjenꞌen kain ni meꞌe konchjiñeꞌe naa nchri niꞌe, ó teyuu nano níexin nchra jnié nchra. ");
INSERT INTO pps_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Ko jeꞌe nchri meꞌe juinchexienxin nchra ngajin xinchexruan kain ti bachónda nchra, ko ninaa xinchexruan juaꞌi juinchexruenꞌen xa nchra ko ícha bakoniꞌe nchra. ");
INSERT INTO pps_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Ko ó tsikinꞌen nchra ngeꞌe beki na̱ ti juincheꞌe ndo Jesús, meꞌe jeꞌe nchra kui̱i̱ nchra ko tuenxin na̱ konchjiñexin nchra ko itsé nchra mantée ndo Jesús ");
INSERT INTO pps_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","ixi ndachro nchra: “Siá jeꞌo xrotse̱ ngandeꞌe mantée ndo, meꞌe tsoxruanna.” ");
INSERT INTO pps_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Ko tuinxin kuíxin jnié nchra, meꞌe konoꞌe nchra ixi ó koxruenꞌen nchra. ");
INSERT INTO pps_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Ko ndo Jesús konoꞌe ndo ixi juachaxien ndo koxruenxin naa ngisen, meꞌe ngatjia ndo ko juanchangiꞌe ndo ni ste ntiꞌa: ―¿Ngisen itséna? ");
INSERT INTO pps_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ko jeꞌe sen juatingíexin sen ko ndachro sen: ―Maestro, kueya na̱ jii ngandajinnta ko tonchekanta na̱, ¿sonda tjanchangínta ngisen itsé mantoanta? ");
INSERT INTO pps_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Tjumeꞌe bingatjia ndo ko tsjeꞌe ndo nguixin ixi tsonoꞌe ndo ngisen itsé mantée ndo. ");
INSERT INTO pps_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Ko jeꞌe nchra xronka nchra ko jixranga nchra ixi koxruenꞌen nchra, ko konchjiñeꞌe nchra ti jii ndo ko bakeꞌexin ntatuchiꞌin nchra ngajin ndo ko chronga nchra kain ngeꞌe konꞌen nchra. ");
INSERT INTO pps_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Ko ndachro ndo Jesús: ―Chjanꞌna, jaꞌa koxruanꞌan ixi chuntiana. Jai juaxruxin satjia ixi ó koxruanꞌan. ");
INSERT INTO pps_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Ko xrajinichja ndo Jesús, kui̱i̱ kaxin ni kui̱xi̱n ndoꞌa xi Jairo, xi baketuanꞌan niꞌngo ko ndache na̱ xa: ―Xjannchrichjaꞌanta ó kuenꞌen xjan; í chjeꞌanta ndo maestro ixra̱. ");
INSERT INTO pps_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Ko jeꞌe ndo Jesús kuinꞌen ndo ngeꞌe ndachro na̱, ko ndache ndo xi tetuanꞌan niꞌngo: ―Xrakonꞌa jaꞌa, jeꞌo titikáoanna. ");
INSERT INTO pps_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Ko kuajonꞌa ndo juachaxin ixi kain sen itsji sen, jeꞌo ndo Pedro ko ndo Jacobo ko ndo Juan, ndo kichuu ndo Jacobo, meꞌe sen bikao ndo. ");
INSERT INTO pps_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Ko hora kuiji sen ndoꞌa xi tetuanꞌan niꞌngo, bikon sen ixi stetsjanga na̱ ko stetaxin na̱ xjan juachjaon ko stetoyako na̱. ");
INSERT INTO pps_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Ko kuixinꞌin ndo Jesús nchia, ko ndachro ndo: ―¿Sonda tuyakonta ko tsjanganta? Jeꞌe xjan tsikenꞌa xjan; jeꞌo jijua xjan. ");
INSERT INTO pps_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ko jeꞌe na̱ juanoa na̱ ndo, méxin kuetuanꞌan ndo ixi kain na̱ satsji na̱ nduja ko jeꞌo kuituekao ndo ndotée xjan ko janée xjan ko sen níi, sen chrikao ndo, ko jeꞌe sen kuixinꞌin sen ti jii xjan. ");
INSERT INTO pps_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Ko ndo Jesús itsé ndo itja xjan ko ngigueꞌe ndo nichjexin ndo xjan, ko ndachro ndo: ―Talita, cumi ―meꞌe xrondachro: Xjanchrichjan, tingatjen. ");
INSERT INTO pps_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Ko xjan meꞌe tuinxin bingatjen xjan ko kuaji xjan ixi xjan meꞌe kuachónda xjan teyuu nano, ko kain ni jii ntiꞌa tsango xronka na̱. ");
INSERT INTO pps_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Ko ndo Jesús kuetuanꞌan ndo ixi xroꞌan ngisen tsekiꞌe na̱ ngeꞌe konꞌen. Ko kaxon kuetuanꞌan ndo xrochjée na̱ xjan ngeꞌe sine xjan. ");
INSERT INTO pps_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Ko tjumeꞌe ndo Jesús kuachrjexin ndo tjajna ntiꞌa ko sakjui ndo tjajnée ndo tjajna Nazaret ko kaxon ruéꞌe sen teyuu chrikao ndo. ");
INSERT INTO pps_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Ko kuiji sábado, nchakon tjokéꞌe na̱, ko kuaxi ndo juinchekuenꞌen ndo na̱ ngaxinꞌin ningue ni israelita ntiꞌa. Ko kueya na̱ kuinꞌen na̱ ngeꞌe tjako ndo, meꞌe xronka na̱ ko ndachro na̱: ―¿No kuitjaxin xi jiꞌi ngeꞌe tjako xa?, ko, ¿ngisen juinchekuenꞌen xa ti nichja xa ko ixra̱ ijié ncheꞌe xa? ");
INSERT INTO pps_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","¿Á jeꞌa jiꞌi xi carpintero ko janée xa ndatinꞌin María, ko xi kichuu xa xi Jacobo, ko xi José, ko xi Judas, ko xi Simón? ¿Á stekuiꞌana nchrikichuu xa ntiꞌi? Méxin, kuitikaonꞌa na̱ ngeꞌe ichro ndo. ");
INSERT INTO pps_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","*Ko ndachro ndo Jesús: ―Kain tjajna kain chujni tajon na̱ juasaya ngajin naa ndo nichja chijnie ndo Dio; ko sen tjajnée ndo, naꞌi, ko kaxon sen ndoꞌa ndo tajonꞌa sen juasaya ngajin ndo. ");
INSERT INTO pps_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Méxin, ntiꞌa xroꞌan ixra̱ jian juincheꞌe ndo, jeꞌo bakeꞌe itja ndo ngataꞌa jaa kaxin ni niꞌe ko juinchexruenꞌen ndo na̱. ");
INSERT INTO pps_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Ko tsango xronka ndo ixi kuitikaonꞌa na̱. Ko tjumeꞌe sakjui ndo kaxin tjajna nchínchín ste tjenka ntiꞌa ko juinchekuenꞌen ndo na̱. ");
INSERT INTO pps_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Ko tjumeꞌe ndo Jesús kuiyeꞌe ndo sen teyuu sen chrikao ndo ko kuaxi kuetuanꞌan ndo ixi yuyu sen itsji sen ko kaxon kuajon ndo juachaxin ixi chao tsantsje sen kain espíritue Xixronꞌanxrée chónda chujni. ");
INSERT INTO pps_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Ko kuetuenꞌen ndo sen ixi xroꞌan ngeꞌe tsikao sen ti tsaa sen chaꞌo. Jeꞌo naa ntakuto tsjixin sen ko meꞌó tsikao sen. Ko tsikauꞌa sen ti tsinga ngeꞌe ko ngeꞌe sine sen ko tsikauꞌa sen tomi. ");
INSERT INTO pps_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Ko jeꞌo kate jichjanga sen ko jeꞌo manta jiá sen tsikao sen. ");
INSERT INTO pps_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ko kaxon ndachro ndo: ―Nchakon tsixinꞌinnta naa nchia ntiꞌao tsituꞌanta hasta tsachrjexinjanta tjajna meꞌe. ");
INSERT INTO pps_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","*Ko siá tsjasonta xrojan tjajna ko tsajonꞌa na̱ juachaxin tsituꞌanta ntiꞌa ko xrochroꞌa na̱ tsinꞌen na̱ ngeꞌe tjakonta, jaꞌanta tachrjexinnta tjajna meꞌe ko tontsjenganta inche yaa kateanta, meꞌe tsjakoxinnta ixi ndakoꞌa juincheꞌe na̱ ngajinnta. Ko nduaxin ndachrja̱n ixi nchakon sinchéña ndo Dio ijie̱ ngajin chujni, ícha tangi tsonꞌen ni tjajna meꞌe, ixi ni tjajna Sodoma ko ni tjajna Gomorra. ");
INSERT INTO pps_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Ko sakjui sen ko ndache sen na̱ ixi xrokonda tsindoxin na̱ ngeꞌe ncheꞌe na̱ ko tsintuꞌe na̱ ti ndakoꞌa ncheꞌe na̱. ");
INSERT INTO pps_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","*Ko kaxon kuantsje sen itsjé espíritue Xixronꞌanxrée kuachónda kaxin na̱. Ko ngataꞌa jaa itsjé ni niꞌe bakeꞌe sen ndaxiꞌe ko jaña koxruenꞌen na̱. ");
INSERT INTO pps_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","*Ko xi rey Herodes kuinꞌen xa kain ngeꞌe jian kuancheꞌe ndo Jesús ixi kain na̱ teki na̱ xranchi ijié juachaxin chónda ndo, meꞌe ndachro xa: ―Ndo Juan Bautista ó tsixechón ndo ixi xrajeꞌo juachaxin chónda xi jiꞌi. ");
INSERT INTO pps_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Ko kaxin na̱ ndachro na̱: ―Jiꞌi ndo Elías kuachronga chijnie ndo Dio. Ko ikaxin na̱ ndachro na̱: ―Jiꞌi naa ndo kuachronga chijnie ndo Dio ó saꞌó. ");
INSERT INTO pps_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Ko kuinꞌen xi Herodes ko ndachro xa: ―Jiꞌin ndo Juan, ndo kuetuanꞌan konchrinjin na̱ jaa ndo, ndo meꞌe ó tsixechón ndo. ");
INSERT INTO pps_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","*Ko xi Herodes tsiketuanꞌan xa ixi tsitexin ndo Juan ixi nochika ko tsixraxinꞌin na̱ ndo ndoꞌachjiso ixi jaña tsijanchia nchri Herodías. Jeꞌe nchri Herodías, nchrinchriꞌe xi Felipe xikichuu xi Herodes, ko jeꞌe xi Herodes kua xa nchri meꞌe xranchi xrokjui nchrinchriꞌe jeꞌe xa. ");
INSERT INTO pps_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Ko ndo Juan jaꞌin tsindache ndo xi Herodes: ―Xroꞌan juachaxin jii ixi jaꞌa xrochónda nchrinchriꞌe xi kichuua. ");
INSERT INTO pps_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Méxin nchri Herodías tsango koñaoꞌe nchra ndo Juan ko tjaun nchra xrokóña nchra ndo, ko juaꞌi juincheꞌe nchra meꞌe ");
INSERT INTO pps_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","ixi xi Herodes xrakonꞌen xa ndo Juan ixi kuanoꞌe xa ixi ndo Juan naa ngisen tsango jian ko tjúá aséen. Méxin, chroꞌa xa tsajon xa juachaxin ixi jeꞌe nchri tsjaya nchra. Ko maski xi Herodes tienxinꞌa xa jian kain ti kuandachro ndo Juan, tjaun xa ícha xrokuinꞌen xa ti ngeꞌe juako ndo. ");
INSERT INTO pps_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Ko nchri Herodías juacha nchra nchakon kiée xi Herodes. Tsikiyeꞌe xa ni tetuanꞌan tjajna ko ni tetuenꞌen xi soldado ko ikaxin ni tetuanꞌan nunte Galilea ixi tsi̱i̱ na̱ kiée xa. ");
INSERT INTO pps_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Ko nchrichjeꞌen nchri Herodías kuixinꞌin nchrichan ti ste na̱, ko ité nchrichan, ko tsango juaxruxin bakeꞌe xi Herodes ko kain ni stenekao xa ntiꞌa. Ko jeꞌe xi Rey Herodes ndache xa nchrichan meꞌe: ―Tjanchiana̱na ngeꞌe tjauan ko janꞌan xrotja̱ꞌá. ");
INSERT INTO pps_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Ko jeꞌe xa nichjaxin ngatoxin ndo Dio ixi nduaxin tsajon xa ngixeꞌi ngeꞌe tsjanchia nchrichan maski ngusine tjajna tetuanꞌan xa. ");
INSERT INTO pps_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Ko jeꞌe nchrichan kuachrje nchrichan ko ndache nchrichan janée nchrichan: ―¿Ngeꞌe tsjanchia? Ko janée nchrichan ndachro jan: ―Tjanchia jaa xi Juan Bautista. ");
INSERT INTO pps_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Ko jeꞌe nchrichajan jaiko ikjan nchrichan ti jii xi rey, ko ndachro nchrichan: ―Janꞌan tjaꞌon xrochjána̱na jaa xi Juan Bautista ngaya naa laato. ");
INSERT INTO pps_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Ko jeꞌe xi rey tsango koniꞌe aséen xa ixi jaña juanchia nchrichan ixi tsíndáchro xa ngatoxin ndo Dio tsajon xa kain ti tjanchia nchrichan ko tsikinꞌen kain ni ste ntiꞌa, méxin, í juaꞌi xrondachro xa naꞌi. ");
INSERT INTO pps_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Ko tuinxin kuetuenꞌen xa naa xi soldado ixi tsijikao xa jaa ndo Juan. ");
INSERT INTO pps_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Ko xi soldado sakjui xa ndoꞌachjiso ko konchrinjin xa jaa ndo Juan ko juankaya xa naa laato jaa ndo ko chjée xa nchrichajan ko jeꞌe nchrichan bikenꞌen nchrichan janée nchrichan. ");
INSERT INTO pps_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Ko kuinꞌen kain sen chrikao ndo Juan ixi jaña tsikonꞌen, meꞌe juirueꞌe sen cuerpoe ndo ko juabaa sen ndo. ");
INSERT INTO pps_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Ko tjumeꞌe sen tsixruaꞌan ndo Jesús ikjan sen ti jii ndo ko beki sen kain ti juincheꞌe sen ko kain ti nichja sen. ");
INSERT INTO pps_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Ko ndachro ndo Jesús: ―Tsachrjendáana sachjina ntajie ti xroꞌan ngisen ste ko ntiꞌa tsjokai̱na nchíín. Jaña ndachro ndo ixi kueya na̱ itji na̱ ko ti̱i̱ na̱ ko koꞌa tiempo sine sen. ");
INSERT INTO pps_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Ko ndo Jesús ko sen teyuu chrikao ndo, jeꞌo sen kuixinꞌin sen naa nta̱barco sakjui sen naa nunte xroꞌan ngeꞌe jii. ");
INSERT INTO pps_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Ko kueya na̱ bikon na̱ ixi sakjui sen ko ndo Jesús ntiꞌa kaxon jitji ndo, meꞌe kuachrjexin na̱ tjajnée na̱ ko binga na̱, méxin saꞌó kuiji na̱ ngandeꞌe ndalago ko ntiꞌa stechónꞌen na̱ ndo Jesús. ");
INSERT INTO pps_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","*Ko hora kuachrjexin ndo nta̱barco, bikon ndo ixi kueya na̱ jichónꞌen na̱ ntiꞌa, méxin bikonóeꞌe ndo na̱ ixi ste na̱ xranchi kutuchjon chóndaꞌi ngisen tsjeꞌe ba. Ko juangíxin ndo juinchekuenꞌen ndo na̱ kueya ngeꞌe. ");
INSERT INTO pps_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Ko ó kóndo ko sen teyuu chrikao ndo Jesús konchjiñeꞌe sen ngajin ndo, ko ndachro sen: ―Ó kóndo ko xroꞌan ngeꞌe jii ntiꞌi. ");
INSERT INTO pps_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Ndachenta na̱ ixi satsji na̱ naa nchia o̱ naa tjajna kjínꞌa ste, ko tseꞌna na̱ ngeꞌe sine na̱ ixi xroꞌan ngeꞌe chónda na̱. ");
INSERT INTO pps_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Ko ndo Jesús juatingíexin ndo: ―Jaꞌanta tájonnta ngeꞌe sine na̱. Ko jeꞌe sen ndachro sen: ¿Á tjaunnta tseꞌnana yuu ciento denario nutja ixi tsajonna sine na̱? ");
INSERT INTO pps_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Ko ndo Jesús juanchangi ndo: ―Titsjeꞌenta ngijanꞌin nutja chondanta. Ko kuitsjeꞌe sen ko ndachro sen: ―Jii naꞌó nutja ko yuu kuchee̱. ");
INSERT INTO pps_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Ko kuetuanꞌan ndo ixi kain na̱ xrobakeꞌe na̱ nunte ngataꞌa kayua. ");
INSERT INTO pps_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Ko jaña xrochjeya na̱ tsachrjendáa ngujngu ciento na̱ ko ngujngu cincuenta na̱. ");
INSERT INTO pps_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Ko ndo Jesús kua ndo ti naꞌó nutja ko yuu kuchee̱ ko tsjeꞌe ndo ngajní ko kuajon ndo juasie ndo ngajin ndo Dio ko konchrinjin ndo nutja ko chjée ndo sen teyuu chrikao ndo ixi tsonchjeya sen sine kain ni ste ntiꞌa; kaxon konchrinjin ndo ti yuu kuchee̱ ko konchjeya sen ixi sine kain na̱. ");
INSERT INTO pps_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ko kain na̱ juine na̱ ko konkjeꞌe na̱. ");
INSERT INTO pps_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Ko juexin juine na̱ ko sen teyuu chrikao ndo Jesús juejo sen tutuꞌo nutja ko kuchee̱ tsixeꞌe ko juinchekaon sen teyuu ntaxra ti nutja ko kuchee̱. ");
INSERT INTO pps_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Ni juine meꞌe xranchi naꞌó mil xi. ");
INSERT INTO pps_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Ko tuinxin ndache ndo Jesús sen teyuu chrikao ndo ixi tixinꞌin sen nta̱barco ko tsatsingatuꞌe sen ndalago no jii tjajna Betsaida. Ko jeꞌe ndo xrakuituꞌe ndo nichjeꞌe ndo kain ni ste ntiꞌa. ");
INSERT INTO pps_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Ko juexin nichjeꞌe ndo na̱, sakjui ndo naa ijna̱ ixi tsinichjeꞌe ndo ndo Dio. ");
INSERT INTO pps_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Ko ó kóndo ko kontie ko nta̱barco meꞌe kuiji nta̱a̱ ngusine ndalago, ko jeꞌe ndo Jesús jeꞌo ndo kuintuꞌe ndo nunte ntiꞌa. ");
INSERT INTO pps_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Ko bikon ndo ixi tsango tangi tikao sen nta̱a̱ ixi tsango soji jitinga chrinto ko meꞌe ruéꞌe ndo sen. Ko tutée ndo jiti̱xi̱n ndo ngataꞌa nda ko konchjiñeꞌe ndo ti ste sen ko juincheꞌe ndo xranchi xrokuitaon ndo. ");
INSERT INTO pps_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Ko hora bikon sen jitji ndo ngataꞌa inda, tsango xraxaon sen ixi bikon sen naa chrintoe chujni tsikenꞌen, ko kuyako sen ");
INSERT INTO pps_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","ixi kain sen bikon sen ndo ko ícha xronka sen. Ko jeꞌe ndo nichja ndo, ko ndache ndo sen: ―Xronkaꞌinta, janꞌan juiꞌi. ");
INSERT INTO pps_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Ko jeꞌe ndo kuixinꞌin ndo nta̱barco ti ste sen, ko chrinto tuinxin ndabakeꞌe chrinto. Ko jeꞌe sen ícha xronka sen ixi jaña konꞌen ");
INSERT INTO pps_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","ixi tsikienxinꞌa sen ti juincheꞌe ndo Jesús nchakon kuajon ndo itsjé nutja ixi xracha aséen sen meꞌe kuitikaonꞌa sen ndo. ");
INSERT INTO pps_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Ko kuatsingatuꞌe sen ndalago ko kuiji sen nunte Genesaret ko ntiꞌa kuenchrua sen nta̱barco ngandeꞌe inda. ");
INSERT INTO pps_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Ko tuinxin ti kuachrjexin sen inda, ni ste ntiꞌa kuichúxin na̱ ndo Jesús. ");
INSERT INTO pps_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Ko jeꞌe na̱ kuichronga na̱ nchijíi nunte ntiꞌa, méxin kuaxi na̱ bikao na̱ itsjé ni niꞌe, ni jitsingataꞌa kania ko bikao na̱ ti jii ndo Jesús. ");
INSERT INTO pps_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Ko kain ti no ikjui ndo, tjajna nchíín ko tjajna ijié, o̱ ngaya chjaka meꞌe bikaꞌo na̱ kain ni niꞌe ko bakeꞌe na̱ ngandeꞌe chaꞌo. Ko ni niꞌe tinóatée na̱ ngajin ndo Jesús ixi jeꞌo xrotsé na̱ ngandeꞌe mantée ndo meꞌe koxruenꞌen na̱. ");
INSERT INTO pps_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Tjumeꞌe kaxin ni fariseo ko kaxin ni bajako chijnie ndo Dio kui̱xi̱n na̱ tjajna Jerusalén konchjiñeꞌe na̱ ti jii ndo Jesús. ");
INSERT INTO pps_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Jeꞌe na̱ bikon na̱ ixi kaxin sen chrikao ndo Jesús junémaꞌi itja sen, jañao juine sen, méxin kuaxi na̱ juankataꞌa na̱ sen ijie̱. ");
INSERT INTO pps_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(Ixi xi fariseo ko kain ni judío kuanéma tja na̱ xranchi kuancheꞌe ni tachríꞌe na̱, ni xranchrjen, ixi saꞌó banéma na̱ itja na̱ ko tjumeꞌe ine na̱. ");
INSERT INTO pps_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Ko hora kjanxin na̱ ndasin, saꞌó xrokonda néma na̱ itja na̱ ko tjumeꞌe sine na̱. Ko kaxon banéma na̱ vaso ko ichi ko cazuela chika ko kuajontaꞌa na̱ cama, jaña kuancheꞌe na̱ ko kaxon ikaxin ngeꞌe ixi jaña kuituanꞌan ni tachríꞌe na̱ xranchrjen.) ");
INSERT INTO pps_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Méxin, xi fariseo ko xi tjako chijnie ndo Dio jaꞌin juanchangiꞌe xa ndo Jesús: ―¿Sonda sen chrjikoꞌa ncheꞌa sen ngeꞌe kuancheꞌe sen tachríꞌina xranchrjen ó saꞌó? Sen chrjikoꞌa jaꞌa, némaꞌi sen itja sen hora ine sen. ");
INSERT INTO pps_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Ko juatingíexin ndo Jesús ko ndachro ndo: ―Nduaxin ti tsindachro ndo profeta Isaías ixi jaꞌanta ndakoꞌa xraxaonnta, ko jaꞌin ndachro xroon tsikjin ndo: Ni tjajna jiꞌi jeꞌo roꞌa na̱ nichjanaxin na̱ ngajin, jeꞌa nduaxin ixi aséen na̱ xraxaon na̱. ");
INSERT INTO pps_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Méxin, xroꞌan tjintee juasaya tajon na̱ ngajin, ixi jeꞌo tjako na̱ ngeꞌe tetuanꞌan chujni. ");
INSERT INTO pps_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Ko jaꞌanta tsikintuꞌenta ngeꞌe tsiketuanꞌan ndo Dio ko rueꞌénta ngeꞌe kuancheꞌe na̱, méxin néꞌmanta ichi, ko vaso ti̱ꞌxi̱nnta, ko kaxon ikaxin ngeꞌe ncheꞌenta. ");
INSERT INTO pps_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Ko kaxon ndachro ndo Jesús: ―Jaꞌanta rueꞌénta ngeꞌe kuancheꞌe na̱ ko jaña ndáꞌa tintuꞌenta ngeꞌe tsiketuanꞌan ndo Dio. ");
INSERT INTO pps_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Ndachro chijnie ndo Dio tsikjin ndo Moisés: “Xrochondeꞌenta juasaya ndotánta ko janáanta”, ko kaxon tsindachro ndo “Ngisen ndakoꞌa nichja ngajin ndotée o̱ janée xrokonda tsenꞌen sen.” ");
INSERT INTO pps_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Ko jaꞌanta ndachenta chujni ixi chao xrondache na̱ ndotée na̱ ko janée na̱: “Ndotána, janáana, juaꞌi tsingijnananta ixi kain ngeꞌe chondana meꞌe kóña corbán”, (meꞌe xrondachro ixi kain tomina ó tjáꞌa ndo Dio). ");
INSERT INTO pps_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Ko siá xrondachronta jaña, jaꞌanta ndachronta xrokondaꞌi tsingijnanta ndotánta o̱ janáanta. ");
INSERT INTO pps_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ko jaña titikaonꞌanta ngeꞌe tsiketuanꞌan ndo Dio ko jaꞌanta titikaonnta ngeꞌe kuancheꞌe na̱ saꞌó. Ko kaxon ncheꞌenta ikaxin ngeꞌe ndakoꞌa. ");
INSERT INTO pps_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Ko íjngo kuiyeꞌe ndo Jesús chujni ste ntiꞌa, ko ndachro ndo: ―Tinꞌennta kainnta ti ntatjunta ko tienxinnta jiꞌi. ");
INSERT INTO pps_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Jeꞌa ti ineni ncheki̱tja̱ aséenni. Ti tachrjexin aséenni meꞌe ncheki̱tja̱ni. ");
INSERT INTO pps_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Ti tjaunnta tsinꞌennta, tinꞌennta. ");
INSERT INTO pps_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Ko ndo Jesús kuintuꞌe ndo kain na̱, ko jeꞌe ndo ko sen teyuu chrikao ndo kuixinꞌin sen nchia. Ko juanchangiꞌe sen ndo ngeꞌe xrondachro ti juinchekuenꞌen ndo na̱. ");
INSERT INTO pps_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Ko ndachro ndo Jesús: ―¿Á kaxon jaꞌanta tienxinꞌanta? ¿Á noaꞌinta ixi ti ngeꞌe ineni jeꞌa meꞌe ncheki̱tja̱ aséenni? ");
INSERT INTO pps_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Ixi ti ineni tjiꞌa ngaya aséenni. Meꞌe satsji ngaya tse̱ꞌe̱ni ko tjumeꞌe tachrje. Meꞌe xrondachro ixi ti ngeꞌe ineni, ncheki̱tja̱ꞌi aséenni. ");
INSERT INTO pps_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Ko ndachro ndo Jesús: ―Ko ti ngeꞌe tachrjenixin aséen chujni meꞌe ncheki̱tja̱ aséen. ");
INSERT INTO pps_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Kain jiꞌi tachrjenixin aséen chujni: ti ndakoꞌa xraxaon na̱, ti chónda na̱ inaa ngisen jeꞌa janchriꞌe na̱ o̱ ndoxiꞌe na̱, ti tjaun na̱ tsitexin na̱ inaa ngisen, ti naatsóñaxón kichuu na̱, ");
INSERT INTO pps_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","ti te̱e na̱, ti tochjuyeꞌe na̱ ngeꞌe chónda inaa chujni, ti ndakoꞌa nchekao kichuu na̱, ti ncheya na̱, ti tsango chjinga ncheꞌe na̱, ti tochjio na̱, ti nchejié aséen na̱, ko ti ndakuaꞌi xraxaon na̱. ");
INSERT INTO pps_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Kain ti ndakoꞌa meꞌe tachrjenixin ngaya aséen na̱, ko meꞌe ti ncheki̱tja̱ aséen chujni. ");
INSERT INTO pps_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Ko tjumeꞌe ndo Jesús kuachrjexin ndo ntiꞌa ko sakjui ndo nunte tjajna Tiro ko tjajna Sidón. Ko kuixinꞌin ndo naa nchia ixi tjaunꞌa ndo xrokonoꞌe na̱ ixi ntiꞌa jii ndo. Ko juaꞌi kuemá ndo. ");
INSERT INTO pps_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Ko tjumeꞌe janée naa nchrichajan, chónda nchrichan espíritue Xixronꞌanxrée kuinꞌen jan ixi ntiꞌa jii ndo Jesús, ko tuinxin kuiji jan ko bakeꞌexin jan ntatuchiꞌin jan tutée ndo Jesús. ");
INSERT INTO pps_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Jan meꞌe ikjín kui̱xi̱n jan, nunte Sirofenicia, ko kuinóatée jan ngajin ndo Jesús ixi xrokuantsje ndo espíritue Xixronꞌanxrée chónda nchrichajenꞌen jan. ");
INSERT INTO pps_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Ko ndo Jesús ndachro ndo: ―Saꞌó tintuꞌenta ichjan sine xjan. Ndakoꞌa jii xrokuantsjeꞌeni xjan nutja ko xrochjéeni kunia sine ba. ");
INSERT INTO pps_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ko jeꞌe jan juatingíexin jan: ―Nduaxin meꞌe, Nchána. Ko kunia jingi ba mesa ine ba nutja tituꞌo ti tintjí ichjan. ");
INSERT INTO pps_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Ko ndachro ndo Jesús: ―Chao ndachrua. Satjia ixi espíritue Xixronꞌanxrée ó kuachrjexin nchrichajanꞌan. ");
INSERT INTO pps_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Ko hora kuiji jan ndoꞌa jan, bikon jan ixi nchrichajenꞌen jan ó jian jitsingataꞌa xjan ti jijua xjan ixi ó tsikachrje espíritue Xixronꞌanxrée. ");
INSERT INTO pps_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Ko tjumeꞌe ndo Jesús kuachrjexin ndo tjajna Tiro ko kuatsinga ndo tjajna Sidón ko kaxin tjajna tikinixin nunte Decápolis ko kuiji ndo ti ndalago Galilea. ");
INSERT INTO pps_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ko ntiꞌa bikao na̱ naa xi tienꞌa ko juaꞌi nichja xa. Ko kuinóatée na̱ ngajin ndo Jesús ixi tsakeꞌe itja ndo ngataꞌa jaa xa meꞌe tsoxruenꞌen xa. ");
INSERT INTO pps_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Ko tjumeꞌe ndo Jesús kuachrjendakaꞌo ndo jeꞌe xi tienꞌa ti xroꞌan ngisen ste. Ko dedue itja ndo Jesús xraxinꞌin ndo ndatsjon xi tienꞌa. Ko kaxon dedue itja ndo bikitée ndo ndatée ndo ko bakeꞌe ndo dedue ngataꞌa nejen xi nichjaꞌi. ");
INSERT INTO pps_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Ko tjumeꞌe tsjeꞌe ndo nui ngajní ko kuabaa ndo ko nichjeꞌe ndo xi tienꞌa, ko ndachro ndo: ―¡Efata! ―meꞌe ngigueꞌe sen xrondachro: ¡Xitjeꞌe̱! ");
INSERT INTO pps_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Ko tuinxin xitjeꞌe̱ ndatsjon xi tienꞌa ko kuinꞌen xa ko koxruenꞌen nejen xa, ko jian nichja xa. ");
INSERT INTO pps_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Ko ndo Jesús kuetuanꞌan ndo ixi xroꞌan ngisen xrobeꞌki ngeꞌe ti konꞌen. Ko maski jaña kuetuanꞌan ndo, jeꞌe na̱ ícha beki na̱. ");
INSERT INTO pps_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Ko meꞌe tsango xronka kain na̱ ko ndachro na̱: ―Tsango jian kain ngeꞌe ncheꞌe ndo. Ni tienꞌa, tinꞌen na̱ ko ni nichjaꞌi, nichja na̱. ");
INSERT INTO pps_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Ko nchakon meꞌe kueya na̱ konchjiñeꞌe na̱ ngajin ndo Jesús. Ko chóndaꞌi na̱ ngeꞌe sine na̱. Ko ndo Jesús kuiyeꞌe ndo sen teyuu chrikao ndo, ko ndachro ndo: ");
INSERT INTO pps_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","―Tsango tikonóaꞌa kain ni ste ntiꞌi ixi ó níi nchakon ste na̱ ngajin ko chóndaꞌi na̱ ngeꞌe sine na̱. ");
INSERT INTO pps_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Ko siá tsétuanꞌan na̱ satsji na̱ ndoꞌa na̱ ko xraneꞌa na̱, ngatja chaꞌo tsjeje̱ñao na̱ ixi xraneꞌa na̱ ixi kaxin na̱ tsango ikjín tsiki̱ꞌxi̱n na̱. ");
INSERT INTO pps_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ko juatingíexin sen chrikao ndo: ―¿No tsi̱ꞌxi̱n ngeꞌe xrojuine kain ni jiꞌi ixi xroꞌan nchia jii ntiꞌi? ");
INSERT INTO pps_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Ko juanchangiꞌe ndo Jesús: ―¿Ngijanꞌin nutja chondanta? Ko jeꞌe sen juatingíexin sen: ―Ya̱a̱to̱ nutja chondana. ");
INSERT INTO pps_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Ko ndo Jesús kuetuenꞌen ndo kain na̱ ixi tsakeꞌe na̱ nunte. Ko kua ndo ti ya̱a̱to̱ nutja ko kuajon ndo juasaya ngajin ndo Dio ko konchrinjin ndo nio ko chjée ndo sen teyuu chrikao ndo ixi tsonchjeya sen ngajin kain ni ste ntiꞌa. ");
INSERT INTO pps_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Ko kaxon kaxin kuchee̱ nchínchín chónda sen. Ko ndo Jesús kuajon ndo juasaya ko kuetuanꞌan ndo tsonchjeya sen kuchee̱ kaxon. ");
INSERT INTO pps_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Ko kain na̱ juine na̱ ko konkjeꞌe na̱. Ko juejo sen tutuꞌo ngeꞌe tsixeꞌe ko juinchekaon sen ya̱a̱to̱ ntaxra. ");
INSERT INTO pps_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Ko noó mil na̱ juine na̱. Ko tjumeꞌe ndo Jesús ndache ndo na̱ ixi satsji na̱. ");
INSERT INTO pps_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Ko jeꞌe ndo ko sen teyuu chrikao ndo kuixinꞌin sen naa nta̱barco ko sakjui sen no nunte Dalmanuta. ");
INSERT INTO pps_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","*Ko kui̱i̱ kaxin xi fariseo ko kuaxi xa juao xa ndo Jesús ko juanchia xa ixi xrojuakoxin ndo naa ixra̱ ijié tsi̱ꞌxi̱n ngajní ixi tjaun na̱ tsonoꞌe na̱ á nduaxin chao sincheꞌe ndo. ");
INSERT INTO pps_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","*Ko ndo Jesús kuabaa ndo ko ndachro ndo: ―¿Sonda ni jiꞌi tjanchia na̱ sintaꞌa naa ngeꞌe ijié? Nduaxin ndachrja̱n ixi xroꞌan ngeꞌe sintaꞌa tsikon na̱. ");
INSERT INTO pps_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Ko kuintuꞌe ndo na̱ ntiꞌa, ko kuixinꞌin ndo nta̱barco ko sakjui ndo tuenxin ndalago. ");
INSERT INTO pps_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Ko tjáñeꞌe sen tsikikaoꞌa sen ngeꞌe sine sen. Naakua nutja chónda sen ngaxinꞌin nta̱barco. ");
INSERT INTO pps_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","*Ko ndo Jesús kuetuenꞌen ndo sen: ―Jian tsjeꞌenta ixi ngeꞌe nchetjaꞌin nutjée xi fariseo ko nutjée xi Herodes. ");
INSERT INTO pps_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Ko sen teyuu chrikao ndo ndache kichuu sen: ―Jaña ichro ndo ixi tsikikoꞌina nutja. ");
INSERT INTO pps_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Ko jeꞌe ndo noꞌe ndo ngeꞌe tjao kichuu sen ko ndachro ndo: ―¿Sonda tjao kichuunta ixi chondaꞌinta nutja? ¿Á noaꞌinta ko xratienxinꞌanta? ¿Á icha asáanta méxin titikaonꞌanta ndo Dio? ");
INSERT INTO pps_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","*¿Á tikonxinꞌa ikonnta?, ko, ¿á tienxinꞌa ndatsjonnta? ¿Á sintaxiꞌañaonta? ");
INSERT INTO pps_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Nchakon konchrinjin naꞌó nutja juine naꞌó mil chujni, ¿ngijanꞌin ntaxra ti tutuꞌo nutja xejo? Ko jeꞌe sen juatingíexin sen: ―Teyuu ntaxra. ");
INSERT INTO pps_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Ko íjngo ndachro ndo Jesús: ―Ko nchakon konchrinjin ya̱a̱to̱ nutja juine noó mil chujni, ¿ngijanꞌin ntaxra ti tutuꞌo nutja xejo? Ko ndachro sen: ―Ya̱a̱to̱ ntaxra. ");
INSERT INTO pps_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Ko ndo Jesús ndachro ndo: ―Méxin, ¿á xratienxinꞌanta? ");
INSERT INTO pps_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Ko kuiji sen tjajna Betsaida, ko kui̱i̱ kaxin na̱ bikaꞌo na̱ naa xi tikonꞌa. Ko kuinóatée na̱ ngajin ndo Jesús ixi xrojuinchexruenꞌen ndo xa. ");
INSERT INTO pps_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Ko ndo Jesús itsé ndo itja jeꞌe xi tikonꞌa ko kuachrjendakaꞌo ndo xa ngandeꞌe tjajna. Ko bikitée ndo ndatée ndo ikon xi meꞌe ko bakeꞌe itja ndo ngataꞌa xa ko juanchangiꞌe ndo xa: ―¿Á ó tikuan nchíín? ");
INSERT INTO pps_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ko ndachro jeꞌe xi tikonꞌa: ―Tiko̱n chujni, ko tiko̱n na̱ xranchi naa nta̱yua ichrji. ");
INSERT INTO pps_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Ko ndo Jesús bakeꞌe itja ndo íjngo ngataꞌa ikon xa. Ko jeꞌe xa tsjeꞌe xa ko koxruenꞌen xa ko chao bikon xa kain ngeꞌe. ");
INSERT INTO pps_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Ko ndo Jesús kuetuanꞌan ndo ixi satsji xa ndoꞌa xa, ko ndachro ndo: ―Ikjanꞌia tjajna íjngo ko xroꞌan ngisen tekiꞌé jiꞌin. ");
INSERT INTO pps_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Ko tjumeꞌe ndo Jesús ko sen teyuu chrikao ndo sakjui sen tjajna nchíín tjenka tjajna Cesarea de Filipo. Ko ngatja chaꞌo juanchangiꞌe ndo Jesús sen chrikao ndo ko ndachro ndo: ―¿Ngeꞌe ichro na̱, ngisen janꞌan? ");
INSERT INTO pps_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","*Ko jeꞌe sen ndachro sen: ―Kaxin na̱ ndachro na̱ ixi jaꞌanta ndo Juan Bautista ko ikaxin na̱ ndachro na̱ ixi jaꞌanta ndo profeta Elías ko ikaxin na̱ ndachro na̱ ixi jaꞌanta naa sen profeta kuachronga chijnie ndo Dio ó saꞌó. ");
INSERT INTO pps_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","*Ko tjumeꞌe ndo Jesús juanchangiꞌe ndo sen: ―Ko jaꞌanta, ¿ngeꞌe ndachronta, ngisen janꞌan? Ko juatingíexin ndo Pedro ko ndachro ndo: ―Jaꞌanta ndo Cristo tsixruaꞌan ndo Dio. ");
INSERT INTO pps_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Ko kuetuanꞌan ndo Jesús ixi xroꞌan ngisen tsekiꞌe sen jiꞌi. ");
INSERT INTO pps_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Ko juangíxin ndo Jesús ndache ndo sen ixi jeꞌe ndo chjenꞌen ndo Dio, xjan jongíꞌe xranchi chujni, xrokonda tsango tangi tsonꞌen ndo ko kain xi tetuanꞌan niꞌngo ko kain xitaana tetuanꞌan ko kain ni tjako ley tsoñaoꞌe na̱ ndo. Ko ni meꞌe naatsóñaxón na̱ ndo ko nchakon nínxin xroxechón ndo. ");
INSERT INTO pps_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Kain jiꞌi jian chronga ndo. Ko tjumeꞌe ndo Pedro kuantsjendáa ndo ndo Jesús ko kuyakutee ndo ndo. ");
INSERT INTO pps_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Ko ngatjia ndo Jesús tsjeꞌe ndo kain sen chrikao ndo ko kuyakutee ndo ndo Pedro, ko ndachro ndo: ―¡Satjixian ntiꞌi, Xixronꞌanxrée! Jaꞌa xraxaonꞌa xranchi xraxaon ndo Dio. Jaꞌa xraxaoan xranchi xraxaon chujni. ");
INSERT INTO pps_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","*Ko ndo Jesús kuiyeꞌe ndo sen teyuu chrikao ndo ko sen tsikonchjiñeꞌe ngajin ndo ko ndachro ndo: ―Siá xrojan ngisen tjaun xroruaꞌna, xrokonda xrotjáñeꞌe sen kain ngeꞌe ícha tjaun sen ko xroruaꞌna sen kain nchakon, maski tangi tsonꞌen sen. ");
INSERT INTO pps_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","*Ni tjaun tsitjáñaꞌi, ni meꞌe nduaxin tsenꞌen na̱; ko ni tsenꞌen ixi titikaonna na̱ janꞌan ko chijni jian nichja, ni meꞌe tsechón na̱ kain nchakon. ");
INSERT INTO pps_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","¿Ngeꞌe tsjacha naa ngisen xrochónda kain ngeꞌe jii ngataꞌa nunte ntiꞌi ko ndatsitjáña aséen sen? ");
INSERT INTO pps_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","¿Ngijanꞌin tsjenga sen ꞌna̱ ixi tsechón sen? ");
INSERT INTO pps_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Ixi sen tsosueꞌe ixi titikaonna sen ko kao chijni nichja, stetikon ni ndakoꞌa ncheꞌe ko ni chónda ijie̱, kaxon chjenꞌen ndo Dio, xjan jongíꞌe xranchi chujni, tsosueꞌe xjan ko xrondachro xjan ixi chúxinꞌa xjan sen nchakon tsetuanꞌan xjan ti jii juachaxin ijié chónda Ndotée xjan ko kain sen ángel. ");
INSERT INTO pps_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Ko kaxon ndachro ndo Jesús: ―Nduaxin rintatjonta ixi kaxin ni ste ntiꞌi xratsenꞌa na̱, tsikonja na̱ tsi̱i̱ juachaxien ndo Dio. ");
INSERT INTO pps_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","*Kuatsinga ikjaon nchakon ko tjumeꞌe ndo Jesús sabikao ndo ndo Pedro, ndo Jacobo ko ndo Juan kuajinꞌin sen naa ijna̱ nui. Ko ntiꞌa bikon sen kuindoxin ikon ndo Jesús. ");
INSERT INTO pps_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Ko manta jía ndo ikjan tsango tjúá, ko ngataꞌa nunte ntiꞌi xroꞌan ngisen xrojuinéma manta jaña ixi tsango tjúá bikoni. ");
INSERT INTO pps_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Ko bikon sen ntiꞌa jii ndo Elías ko ndo Moisés stetjao sen ndo Jesús. ");
INSERT INTO pps_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Ko ndo Pedro ndache ndo ndo Jesús: ―Maestro, chao stena ntiꞌi. Sintakonchjianna níi tsaꞌon; naa tsaꞌon jaꞌanta ko naa tsaꞌon ndo Moisés ko naa tsaꞌon ndo Elías. ");
INSERT INTO pps_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Jaña ichro ndo ixi kain sen tsango xronka sen, ko ndo Pedro noeꞌa ndo ngeꞌe nichja ndo. ");
INSERT INTO pps_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","*Ko tuinxin kui̱i̱ naa itjui̱ bakeꞌe ngataꞌa ti ste sen. Ko ngakjenꞌen itjui̱ meꞌe kuinꞌen sen naa tée naa ngisen nichja: ―Jiꞌin chjanꞌna tsango tjuaꞌa. Tinꞌennta ngeꞌe xrondachro xjan. ");
INSERT INTO pps_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Ko ikjan tsjeꞌe sen ko xroꞌan ngisen bikon sen; jeꞌo ndo Jesús jii ntiꞌa. ");
INSERT INTO pps_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Ko tjumeꞌe xingajinxin sen ijna̱ meꞌe, ko kuetuanꞌan ndo Jesús ixi tsekieꞌa sen ikaxin chujni ngeꞌe bikon sen tsijija nchakon xroxechón jeꞌe ndo chjenꞌen ndo Dio, xjan jongíꞌe xranchi chujni. ");
INSERT INTO pps_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Méxin, jeꞌo sen noꞌe sen jiꞌi ko bekiꞌa sen ngeꞌe bikon sen ko stetjao sen ngeꞌe xrondachro ti xroxechón ndo íjngo. ");
INSERT INTO pps_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","*Ko juanchangiꞌe sen ndo Jesús: ―¿Sonda ndachro ni tjako ley ixi saꞌó xrokui ndo Elías ko tjumeꞌe xrokui ndo Cristo? ");
INSERT INTO pps_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Ko ndachro ndo Jesús: ―Nduaxin tsi̱i̱ ndo Elías saꞌó ko sinchekonchjian ndo kain ngeꞌe. ¿Ko ngeꞌe xrondachro xroon jitaxin chijnie ndo Dio?, ixi tsango tangi tsonꞌen chjenꞌen ndo Dio, xjan jongíꞌe xranchi chujni, ko tsitikaonꞌa na̱ xjan. ");
INSERT INTO pps_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Ko ntatjunta ixi nduaxin ó kui̱i̱ ndo Elías, ko tangi juinchekao na̱ ndo xranchi jeꞌe na̱ tjaun na̱, jaña jitaxin xroon chijnie ndo Dio ixi jaña tsonꞌen. ");
INSERT INTO pps_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Ko hora kjan sen ti kuituꞌe kaxin sen chrikao ndo Jesús, bikon sen ixi kueya na̱ ste na̱ ngandajin sen. Ko kaxon kaxin ni tjako ley stetjao na̱ sen. ");
INSERT INTO pps_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Ko tuinxin hora bikon na̱ ndo Jesús kain na̱ xronka na̱, ko binga na̱ ikjui na̱ ti jii ndo, ko kuajon na̱ juajna. ");
INSERT INTO pps_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Ko ndo Jesús juanchangiꞌe ndo na̱ ko ndachro ndo: ―¿Ngeꞌe stetjaunnta sen chrjikiꞌan? ");
INSERT INTO pps_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Ko naa xi jingakjenꞌen ni ste ntiꞌa juatingíexin xa: ―Maestro, ntiꞌi bikian chjanꞌna chónda xjan espíritue Xixronꞌanxrée tintueꞌa xjan nichja xjan. ");
INSERT INTO pps_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Ko ti no jii xjan, espíritue Xixronꞌanxrée itsé xjan ko tjanka xjan nunte, ko tuchrjo ti̱ꞌxi̱n roꞌa xjan ko ndachro neno xjan ko tsango toncha xjan. Ko janꞌan kuinóatáana ngajin sen chrjikuꞌunta xrokuantsje sen espíritue Xixronꞌanxrée ko juaꞌi juincheꞌe sen. ");
INSERT INTO pps_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Ko ndo Jesús juatingíexin ndo: ―Jaꞌanta titikaonꞌanta jian ndo Dio. ¿Ti ngisa xrokonda tsakeꞌe ngajinnta? ¿Ngisa chao tsaxinta sincheꞌenta ixra̱? Tikuunantana chán ntiꞌi. ");
INSERT INTO pps_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Ko bikaꞌo sen chán. Ko hora bikon espíritue Xixronꞌanxrée ndo Jesús kuaxi kontsjenga espíritu chán, ko juanka espíritu chán ngataꞌa inche ko jamangitaon chán ko kuachrje tuchrjo roꞌa chán. ");
INSERT INTO pps_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Ko ndo Jesús juanchangiꞌe ndo ndotée chán: ―¿Á ó sée jaña tonꞌen chán? Ko ndachro ndotée chán: ―Xranchio chán bakonꞌen chán jaña. ");
INSERT INTO pps_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Ko nanaó espíritue Xixronꞌanxrée tjanka chán ti jii xroꞌi ko tjanka chán ti jii inda ixi tjaun espíritu naatsóñaxón chán. Ko ixudio tikonóaꞌnananta ko tingijnananta. ");
INSERT INTO pps_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Ko ndachro ndo Jesús: ―¿Á chao titikaonnta ndo Dio? Siá titikaonnta ndo Dio, chao tsonꞌen kain ngeꞌe. ");
INSERT INTO pps_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Ko tuinxin séen nichja ndotée chán, ko ndachro: ―Janꞌan titikaꞌon. Tingijnana ixi jaña ícha tsitikaꞌon. ");
INSERT INTO pps_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Ko tjumeꞌe bikon ndo Jesús ixi kueya na̱ konchjiñeꞌe na̱. Ko kuyakutee ndo espíritue Xixronꞌanxrée chónda chán meꞌe, ko ndachro ndo: ―Jaꞌa espíritue ti tintueꞌa nichja na̱ ko ti tintueꞌa tinꞌen na̱. Jai janꞌan ntatjua tachrjexian chajan jiꞌi ko tintuꞌé chán ko íkjanꞌia. ");
INSERT INTO pps_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Ko jeꞌe espíritue Xixronꞌanxrée kuyako ko kontsjenga espíritu chán íjngo, ko kuachrje espíritu. Ko jeꞌe chán ndako naa ni tsikenꞌen kuituꞌe chán, ko kueya na̱ ndachro na̱ ixi ó kuenꞌen chán. ");
INSERT INTO pps_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Ko ndo Jesús itsé ndo itja chán ko juinchengatjen ndo chán. ");
INSERT INTO pps_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Ko ndo Jesús ko sen teyuu chrikao ndo kuixinꞌin sen naa nchia ko jeꞌe sen juanchangiꞌe sen ndo: ―¿Sonda juaꞌi kuantsjena espíritue Xixronꞌanxrée? ");
INSERT INTO pps_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Ko ndachro ndo Jesús: ―Espíritu jeꞌo tachrjexin ixi xronichjeꞌenta Ndotána ko sinchekatse ñaonta jinta. ");
INSERT INTO pps_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Hora sajuixin sen ntiꞌa, kuatsinga sen no nunte Galilea. Ko ndo Jesús tjaun ndo ixi xroꞌan ngisen tsonoꞌe ste sen ntiꞌa ");
INSERT INTO pps_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","ixi tjaun ndo sinchekuenꞌen ndo sen chrikao ndo. Ko ndache ndo sen: ―Janꞌan chjenꞌen ndo Dio, xjan jongíꞌe xranchi chujni, xrotséna na̱ ko tsikaanna na̱ ngajin ni tituanꞌan ko naatsóñaxónna na̱. Ko nchakon nínxin xroxechónna. ");
INSERT INTO pps_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Ko jeꞌe sen kuienxinꞌa sen ngeꞌe ti ndachro ndo ko noeꞌa sen á chao xrojuanchangíꞌe sen ndo ngeꞌe xrondachro jiꞌi. ");
INSERT INTO pps_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Ko tjumeꞌe kuiji sen tjajna Capernaum; ko hora ste sen nchia ntiꞌa, ndo Jesús juanchangiꞌe ndo sen: ―¿Ngeꞌe stetjao kichuunta ti steyána chaꞌo? ");
INSERT INTO pps_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","*Ko jeꞌe sen tenko sen ixi ngatja chaꞌo stetjao sen ixi ngisen ícha tjintee. ");
INSERT INTO pps_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","*Ko tjumeꞌe ndo Jesús bakeꞌe ndo nunte ko kuiyeꞌe ndo ti teyuu sen chrikao ndo, ko ndache ndo sen: ―Siá xrojan jaꞌanta tjaunnta ícha tjinteenta, xrokonda sinchenchiin asáanta ko tsingijnanta kain chujni. ");
INSERT INTO pps_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Ko tjumeꞌe kuiyeꞌe ndo naa chjan ko bakeꞌe ndo xjan ngusine ti ste sen, ko ndachro ndo: ");
INSERT INTO pps_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","*―Ngisen tjueꞌe naa ichjan xranchi xjan jiꞌi ixi titikaonna sen, sen meꞌe kaxon tjueꞌe sen najanꞌan, ko sen tjueꞌe najanꞌan, tjueꞌe sen ngisen xruanꞌanna juiꞌi. ");
INSERT INTO pps_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Ko ndo Juan ndachro ndo: ―Maestro, bikona naa ngisen tantsje espíritue Xixronꞌanxrée ixi juachaxiannta. Ko ntatjanna sen meꞌe í sincheꞌa sen jaña ixi jeꞌe sen chrjikuiꞌana sen. ");
INSERT INTO pps_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Ko ndo Jesús ndachro ndo: ―Tingakuenꞌanta sen meꞌe ixi xroꞌan ngisen, sen ncheꞌe naa ixra̱ jian ixi juachaxinna, sen meꞌe juaꞌi ndakoꞌa xronichja sen ixi janꞌan. ");
INSERT INTO pps_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","*Sen ningakoñaꞌina, sen meꞌe chao tsingijnana. ");
INSERT INTO pps_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","*Ko ngisen xrotjáanta naa vaso inda ixi nduaxin titikaonntana, nduaxin ndachrja̱n ixi tsayéꞌe sen ngeꞌe jian. ");
INSERT INTO pps_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","’Ko ngisen sinchekateya naa ichjan titikaonna janꞌan sincheꞌe xjan ti ndakoꞌa, ni meꞌe cháña xrokuintexin na̱ tusin na̱ naa xrochri ijié ko xrokuitsingangi na̱ ndachaon. ");
INSERT INTO pps_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","*Ko siá tjáanta sinchexinnta ti ndakoꞌa, cháña xrokonchrijinnta tjáanta ixi cháña naakua tjáanta xrokuixinꞌinnta ti tsechónni kain nchakon ixi xrochondanta yui tjáanta ko saxrokjuinta ti jii xroꞌi naiꞌa tsanga, ");
INSERT INTO pps_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","ti jii kutsindo tenꞌa ko ti jiche xroꞌi tsangaꞌi. ");
INSERT INTO pps_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Ko kaxon tutáanta xrojuinchexinnta ti ndakoꞌa, xrokonchrijinnta tutáanta ixi cháña naakua tutáanta xrokuixixinnta ti tsechónni kain nchakon ixi siá xrochondanta yui tutáanta ko saxrokjuinta ti jii xroꞌi naiꞌa tsanga, ");
INSERT INTO pps_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","ti jii kutsindo tenꞌa ko ti jiche xroꞌi tsangaꞌi. ");
INSERT INTO pps_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","*Ko siá ikonnta sinchexinnta ti ndakoꞌa, cháña xrokuantsjengínta ikonnta ixi naakua ikonnta xrochondanta ko jaña xrokuixinꞌinnta ti tetuanꞌan ndo Dio ti tsechónni kain nchakon ixi yui ikonnta saxrokjuinta ti jiche xroꞌi naiꞌa tsanga, ");
INSERT INTO pps_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","ti jii kutsindo tenꞌa ko ti jiche xroꞌi tangaꞌi. ");
INSERT INTO pps_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","’Ko kain chujni xrokonda tangi tsonꞌen sen ixi meꞌe tsingijna sen, xranchi xíjnta tingijna tsojníxin ngeꞌe sineni. ");
INSERT INTO pps_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","*Xíjnta jian xíjnta. Ko siá xíjnta ijníꞌa xíjnta, juaꞌi tsonda xíjnta. Jaꞌanta xranchi xíjnta tinteenta, méxin juaxruxin tsarikuꞌunta kain chujni. ");
INSERT INTO pps_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Tjumeꞌe ndo Jesús kuachrjexin ndo tjajna Capernaum, sakjui ndo nunte Judea nangoxin ndajitinga Jordán. Ko kueya na̱ xraꞌo na̱ ti jii ndo ko jeꞌe ndo juinchekuenꞌen ndo na̱ ixi meꞌe kuancheꞌe ndo. ");
INSERT INTO pps_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Ko kaxin xi fariseo konchjiñeꞌe xa ngajin ndo ko juanchangiꞌe xa ndo ixi tjaun xa ndakoꞌa xrojuatingíexin ndo. Ko juanchangi xa á chao tsintuꞌeni janchriꞌeni. ");
INSERT INTO pps_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Ko ndo Jesús juatingíexin ndo, ko ndachro ndo: ―¿Ngeꞌe kuetuanꞌan ndo Moisés? ");
INSERT INTO pps_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","*Ko ndachro xa: ―Ndo Moisés kuajon ndo juachaxin ixi tsoña̱ naa xroon tsayéꞌe nchri ixi chao tsintuꞌe xa nchra. ");
INSERT INTO pps_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Ko ndo Jesús ndachro ndo: ―Jaña kuetuanꞌan ndo Moisés ixi jaꞌanta ícha asáanta ko titikaonꞌanta. ");
INSERT INTO pps_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Ko ti xraxrangíxixión juinchéña ndo Dio kain ngeꞌe, juinchéña ndo naa xi ko naa nchri ");
INSERT INTO pps_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","ixi xi tsintuꞌe xa ndotée xa ko janée xa ko tsekao xa janchriꞌe xa. ");
INSERT INTO pps_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Ko tjumeꞌe yui sen tsoña̱ sen xranchi naakua naa chujni. Méxin, í jeꞌa yuu sen, ó naakua sen jai. ");
INSERT INTO pps_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Ko jaña siá juachaxien ndo Dio ikjan sen naakua chujni, méxin inaa chujni juaꞌi xrondachro ixi xrochjeya sen. ");
INSERT INTO pps_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Ko hora ste sen nchia, sen teyuu chrikao ndo íjngo juanchangiꞌe sen ndo ngeꞌe xrondachro jiꞌi. ");
INSERT INTO pps_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","*Ko ndo Jesús ndachro ndo: ―Siá naa xi tsintuꞌe xa janchriꞌe xa ko xrochónda xa inaa nchri, xi meꞌe ndakoꞌa jincheꞌe xa ixi ó tsikuteꞌe xa nchrinchriꞌe xa. ");
INSERT INTO pps_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ko kaxon siá naa nchri tsintuꞌe nchra ndoxiꞌe nchra ko xrochónda nchra inaa xi, kaxon jeꞌe nchra índakoꞌa jincheꞌe nchra. ");
INSERT INTO pps_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Kaxin na̱ bikaꞌo na̱ ichjan nchínchín ixi tsakeꞌe ndo Jesús itja ndo ngataꞌa jaa xjan. Ko sen chrikao ndo Jesús kuyakutee sen ni bikaꞌo ichjan meꞌe. ");
INSERT INTO pps_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Ko bikon ndo Jesús jaña stencheꞌe sen, méxin, koñao ndo ko ndachro ndo: ―Tintuꞌenta ichjan tsi̱i̱ xjan ngaji̱n ko tingakuenꞌanta xjan, ixi ti no tetuanꞌan ndo Dio tsikinixinꞌen sen ncheꞌe xranchi ichjan. ");
INSERT INTO pps_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","*Ko xrontatjunta ixi ngisen xrokjanꞌi xranchi naa ichjan nchíín juaꞌi tixinꞌin sen ti tetuanꞌan ndo Dio. ");
INSERT INTO pps_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Ko tjumeꞌe joa ndo kain ichjan ko bakeꞌe itja ndo ngataꞌa jaa xjan ko juinchenchaon ndo xjan. ");
INSERT INTO pps_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Ko hora sakjui ndo Jesús, jitinga naa xi kui̱i̱ xa ko bakeꞌexin xa ntatuchiꞌin xa ngajin ndo Jesús, ko juanchangi xa: ―Maestro jian jaꞌa, ¿ngeꞌe sintaꞌa janꞌan ixi tsarichónna kain nchakon? ");
INSERT INTO pps_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Ko tjumeꞌe ndo Jesús ndachro ndo: ―¿Sonda ndachrua ixi jianna janꞌan? Naakua ngisen jian, jeꞌo ndo Dio jian ndo. ");
INSERT INTO pps_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Jaꞌa ó noꞌa kain ti kuetuanꞌan ndo Dio: “Ncheyeꞌa nchrinchriꞌa, tóñaiꞌa chujni, te̱maꞌia, tjangíeꞌa chujni siá jincheꞌe ti jian, ncheyeꞌa na̱ ko tájuan juasiaa ngajin ndotáa ko janáa.” ");
INSERT INTO pps_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Ko jeꞌe xi meꞌe ndachro xa: ―Maestro, kain jiꞌi ó juintaꞌa xranchiona. ");
INSERT INTO pps_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Ko ndo Jesús tsjeꞌe ndo xa ko tsango tjueꞌe ndo xa. Ko ndachro ndo: ―Xra titjáña naakua ngeꞌe sincheꞌe. Satjia ko nchekjia kain ngeꞌe chonda ko tonchjeyeꞌe ni nóa tomi meꞌe. Jaña xrochonda ngeꞌe ícha tjintee ngajní. Ko tjumeꞌe tsjiꞌia ko ruaꞌna̱na. ");
INSERT INTO pps_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Ko kuinꞌen xa jaña ko tsango kuechíín xa ko sakjui xa, ixi tsango kueya ngeꞌe kuachónda xa. ");
INSERT INTO pps_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Ko ndo Jesús tsjeꞌe ndo ni ste ntiꞌa, ko ndache ndo sen teyuu chrikao ndo: ―Tsango tangi tixinꞌin ni chónda itsjé ngeꞌe ti tetuanꞌan ndo Dio. ");
INSERT INTO pps_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Ko xronka sen chrikao ndo Jesús ixi jaña ndachro ndo. Ko ndachro ndo íjngo: ―Ni chuntia ti ngeꞌe chónda, tsango tangi tixinꞌin na̱ ti tetuanꞌan ndo Dio. ");
INSERT INTO pps_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Ícha tangiꞌa ixi tsatsingatuxin naa ko camello ikon ntachika ixi naa ni chónda kueya ngeꞌe xrokuixinꞌin na̱ ti tetuanꞌan ndo Dio. ");
INSERT INTO pps_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Ko jeꞌe sen kuinꞌen sen jaña ko tsango xronka sen. Ko juanchangiꞌe kichuu sen: ―¿Ngisen chao tixinꞌin ti tetuanꞌan ndo Dio? ");
INSERT INTO pps_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Ko ndo Jesús tsjeꞌe ndo sen, ko ndachro ndo: ―Ti ngeꞌe juaꞌi sincheꞌe chujni, ndo Dio chao sincheꞌe ndo kain ngeꞌe. ");
INSERT INTO pps_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Ko ndo Pedro ndachro ndo: ―Kainna kuintuꞌana kain ngeꞌe chondana ixi ruaꞌananta. ");
INSERT INTO pps_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Ko ndo Jesús ndachro ndo: ―Nduaxin ntatjunta ixi xrojan ngisen tintuꞌe ndoꞌa o̱ xi kichuu, o̱ nchri kichuu, o̱ ndotée, o̱ janée, o̱ janchriꞌe, o̱ chjenꞌen, o̱ nunteꞌe, ixi kuitikaonna sen janꞌan ko titikaon sen chijni ndachrja̱n, ");
INSERT INTO pps_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","sen meꞌe ícha itsjé ngeꞌe tsayéꞌe sen ntiꞌi ko xrochónda sen inaa ciento ícha itsjé ngeꞌe. Kueya nchia xrochónda sen ko tsikon sen itsjé chujni xranchi ni kichuu sen ko xranchi janée sen ko xranchi chjenꞌen sen ko tsayéꞌe sen itsjé nunte. Ko maski tangi tsonꞌen sen ngataꞌa nche ntiꞌi, tjumeꞌe ngajní tsechón sen kain nchakon. ");
INSERT INTO pps_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","*Ko kueya ni tituanꞌan jai, nchakon tsjexin kain ngeꞌe ítsituanꞌi na̱. Ko itsjé ni tjinteꞌa jai, nchakon meꞌe ícha tsetuanꞌan na̱. ");
INSERT INTO pps_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Tjumeꞌe yaa sen chaꞌo satji sen tjajna Jerusalén ko ndo Jesús kuitaon ndo ntiꞌa. Ko sen chrikao ndo stexronka sen steruéꞌe sen. Ko ndo Jesús kuiyeꞌe ndo jeꞌo sen teyuu, ko kuaxi ndo ndache ndo sen xranchi tsonꞌen ndo. ");
INSERT INTO pps_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Ko jaꞌin ndachro ndo: ―Jai satsjina tjajna Jerusalén. Ko tjumeꞌe janꞌan, chjenꞌen ndo Dio, xjan jongíꞌe xranchi chujni, xrotséna na̱ tsikaanna na̱ ngajin xitaana tetuanꞌan ko xi tjako ley. Ko ni tetuanꞌan tsajon na̱ juachaxin ixi tsikaon na̱. Tjumeꞌe tsikaanna na̱ ngajin ni jeꞌa judío ");
INSERT INTO pps_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","ko jeꞌe na̱ tsjanoana na̱, tsandeꞌena itja na̱ ikon, tsikitéena na̱ ndatée na̱ ko naatsóñaxónna na̱. Ko nchakon nínxin xroxechónna íjngo. ");
INSERT INTO pps_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Ko tjumeꞌe ndo Jacobo ko ndo Juan, chjenꞌen ndo Zebedeo, konchjiñeꞌe sen ngajin ndo Jesús ko ndachro sen: ―Maestro, tjanchaꞌananta naa ngeꞌe. ");
INSERT INTO pps_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Ko juanchangi ndo Jesús: ―¿Ngeꞌe tjaunnta? ");
INSERT INTO pps_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Ko ndachro sen: ―Nchakon tsakeꞌenta ti tetuanꞌan, tájonnta juachaxin ixi naa janꞌanna tsakeꞌena ndatsjonxin jian ti tsakeꞌenta jaꞌanta ko inaa janꞌanna tsakeꞌena ndatsjonxin ikjon. ");
INSERT INTO pps_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","*Ko tjumeꞌe ndo Jesús ndache ndo sen: ―Jaꞌanta noaꞌinta ngeꞌe tjanchianta. ¿Á chao tsikixinꞌannta ti tangi tsónna janꞌan? ");
INSERT INTO pps_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Ko jeꞌe sen juatingíexin sen: ―Jaán chao tsikixinna̱na. Ko ndo Jesús ndache ndo sen: ―Nduaxin tangi tsonꞌan jaꞌanta xranchi tangi sinchena na̱ janꞌan. ");
INSERT INTO pps_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Ko janꞌan juaꞌi xrontatjunta ixi naa jaꞌanta tsakeꞌenta ti ndatsjonxin jian ko inaanta tsakeꞌenta ti ndatsjonxin ikjon ti tsakeꞌe janꞌan ixi ó saꞌó jitaxin ngisen tsakeꞌe ntiꞌa. ");
INSERT INTO pps_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Ko ikaxin sen ite, sen chrikao ndo Jesús, kuinꞌen sen ixi jaña tjanchia ndo Jacobo ko ndo Juan ko kuaxi sen koñao sen ngajin sen yuu. ");
INSERT INTO pps_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","*Ko tjumeꞌe kuiyeꞌe ndo Jesús kain sen ko ndache ndo sen: ―Ó noꞌanta ixi ni tetuanꞌan xasintajni tsango tetuenꞌen na̱ kain chujni ko kain ni tsango tetuanꞌan, ni meꞌe tsango nchejié aséen na̱ ko chjinga nchekao na̱ chujni. ");
INSERT INTO pps_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","*Ko jaꞌanta sincheꞌanta jaña. Naꞌi. Siá xrojannta tjaunnta tsituanꞌannta xrokonda tsingijnanta ni kichuunta. ");
INSERT INTO pps_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ko xrojannta tjaunnta ícha xrochondanta juachaxin, meꞌe xrokonda tsitikaonnta ngeꞌe tsituanꞌannta ikaxin chujni. ");
INSERT INTO pps_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Ixi chjenꞌen ndo Dio, xjan jongíꞌe xranchi chujni, kuiꞌa xjan ixi chujni sincheꞌe xra ngajin xjan. Naꞌi. Jeꞌe xjan kui̱i̱ xjan ixi sincheꞌe xjan ixra̱ ngajin chujni ko tsenꞌen xjan ixi kain chujni tsechón sen. ");
INSERT INTO pps_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Ko tjumeꞌe kuiji sen tjajna Jericó. Ko ndo Jesús ko sen chrikao ndo ko kueya na̱ kuachrjexin na̱ tjajna ntiꞌa. Ko ntiꞌa jii naa xi juaꞌi tikon ndatinꞌin xa Bartimeo ko ndotée xa ndatinꞌin Timeo. Takeꞌe xa ngandeꞌe chaꞌo ko tjanchiakaꞌa xa. ");
INSERT INTO pps_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Ko jeꞌe xa kuinꞌen xa ixi ó jitonchjiñeꞌe ndo Jesús tjajna Nazaret, ko kuaxi xa kuyako xa ko ndachro xa: ―Jesús, ndo kuachrjenixin ndo David, tikonóaꞌnanta. ");
INSERT INTO pps_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Ko kueya na̱ kuyakutee na̱ xa ko ndache na̱ xa xrotenko xa. Ko jeꞌe xa ícha séen kuyako xa ko ndachro xa: ―Jaꞌanta, ndo kuachrjenixinnta ndo David, tikonóaꞌnanta. ");
INSERT INTO pps_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Ko chónꞌen ndo Jesús ko kuetuenꞌen ndo na̱: ―Tiyeꞌenta xi meꞌe. Ko tjumeꞌe kuiyeꞌe na̱ jeꞌe xi tikonꞌa ko ndache na̱ xa: ―Xrakonꞌa, tingatjen ixi jitiyaꞌa ndo Jesús. ");
INSERT INTO pps_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Ko nango kuintuꞌe xa ti jitsáa xa ko chrinka xa bingatjen xa ko konchjiñeꞌe xa ti jii ndo Jesús. ");
INSERT INTO pps_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Ko ndo Jesús juanchangiꞌe ndo xa: ―¿Ngeꞌe tjauan sintaꞌa ixi jaꞌa? Ko xi tikonꞌa ndachro xa: ―Maestro, tjaꞌon tsikon. ");
INSERT INTO pps_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Ko ndo Jesús ndache ndo xa: ―Jai chao satjia. Ó koxruanꞌan ixi chuntiana. Ko jeꞌe xi tikonꞌa tuinxin chao bikon xa ko ruéꞌe xa ndo Jesús. ");
INSERT INTO pps_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Hora jitonchjiñeꞌe sen tjajna Jerusalén, tjenka tjajna Betfagé ko tjajna Betania tjenka ijna̱ ndatinꞌin olivo, ndo Jesús kuetuenꞌen ndo yuu sen chrikao ndo, ");
INSERT INTO pps_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","ko ndachro ndo: ―Itjinta tjajna jii yáꞌa ko hora tsjasonta ntiꞌa tsinchíinta naa kuntajno jichroá ba ko meꞌe xra xroꞌan ngisen tetaꞌa ba. Toxindangeꞌenta ba ko tsikuunta ba. ");
INSERT INTO pps_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ko siá xrojan ngisen tsjanchangiꞌanta sonda tonxindangeꞌenta ba, ndachenta sen: “Nchéeni xrokondeꞌe ndo ba ko tjumeꞌe tsonkjanna ba.” ");
INSERT INTO pps_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Ko jeꞌe sen ikjui sen ko kuitja sen kuntajno jichroá ba tjenka nchia ko konxindangeꞌe sen ba. ");
INSERT INTO pps_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Ko kaxin ni ste ntiꞌa juanchangi na̱: ―¿Sonda tonxindangeꞌenta kuntajno ña̱? ");
INSERT INTO pps_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Ko jeꞌe sen juatingíexin sen xranchi ndachro ndo Jesús. Ko jeꞌe na̱ kuajon na̱ juachaxin tsikao sen ba. ");
INSERT INTO pps_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Ko tjumeꞌe sabikao sen kuntajno meꞌe ti jii ndo Jesús ko kuakeꞌe sen manta ngataꞌa ba manta stetsáa sen ko ndo Jesús kuetaꞌa ndo ba. ");
INSERT INTO pps_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Ko kaxon itsjé na̱ kuantsje na̱ manta stetsáa na̱ ko bingó na̱ manta ngaya chaꞌo ti tsatsinga ndo Jesús. Ko ikaxin na̱ konchrinjin na̱ chaan nta̱yua ko bingó na̱ ngaya chaꞌo. ");
INSERT INTO pps_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ko ni jititaon chaꞌo ko ni steruéꞌe kuaxi na̱ kuyako na̱ ixi tsango chéꞌe na̱ ko ndachro na̱: ―Juasaya tayéꞌe ndo Dio. ¡Tsango jian ngisen jiti̱i̱ ixi juachaxien ndo Dio! ");
INSERT INTO pps_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Tsango jian ngisen jiti̱i̱ juachaxien ndo Dio ixi jeꞌe ndo jitikaꞌo ndo juachaxin bakituanꞌan ndo xrachrjei̱na David. Juasie ndo Dio jii ngajní. ");
INSERT INTO pps_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Ko ndo Jesús kuiji ndo tjajna Jerusalén ko kuixinꞌin ndo niꞌngo ícha tetuanꞌan ko tsjeꞌe ndo nguixin ngaxinꞌin ntiꞌa. Ko ó kóndo ko ndo Jesús ko sen teyuu chrikao ndo sakjui sen tjajna Betania. ");
INSERT INTO pps_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Tjumeꞌe ndúyaxin kjanxin sen tjajna Betania ko ndo Jesús kuenꞌen ndo jinta. ");
INSERT INTO pps_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Ko bikon ndo ikjín jii naa nta̱a̱ higo chónda kayua ko kuitsjeꞌe ndo á chónda nta̱a̱ itu. Ko bikon ndo ixi xroꞌan tu chónda nta̱a̱, jeꞌo ika ixi jeꞌa nchakuen itu. ");
INSERT INTO pps_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Ko ndo Jesús nichjeꞌe ndo nta̱a̱ meꞌe: ―Í xroꞌan ngisen sine itu tsajuan. Ko sen teyuu chrikao ndo kuinꞌen sen jaña ndachro ndo. ");
INSERT INTO pps_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Ko kuiji sen tjajna Jerusalén ko ndo Jesús kuixinꞌin ndo niꞌngo ko juangíxin ndo kuantsje ndo kain ni stenchekji ko kain ni steteꞌna. Ko juanka ndo mesa tjasingixixin na̱ tomi ko ntaxitauen ni stenchekji kuntúá, ");
INSERT INTO pps_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","ko kuintueꞌa ndo ni ste ntiꞌa tsatsingakaꞌo na̱ ngeꞌe ngaxinꞌin niꞌngo. ");
INSERT INTO pps_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Ko juinchekuenꞌen ndo na̱, ko jaꞌin ndachro ndo: ―Jitaxin xroon chijnie ndo Dio: “Nía jiꞌi ndatinꞌin nchia xronichjaxin chujni kain tjajna ngajin janꞌan”, ko jaꞌanta juinchekjannta nchia itjao̱ neꞌe xicheꞌe. ");
INSERT INTO pps_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Ko xitaana tetuanꞌan ko ni tjako ley kuinꞌen na̱ jiꞌi, ko kuaxi xraxaon na̱ xranchi naatsóñaxón na̱ ndo Jesús, ko xrakon na̱ ixi itsjé chujni juincheꞌe na̱ juaxruxin ixi ngeꞌe juinchekuenꞌen ndo na̱. ");
INSERT INTO pps_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Ko ó kóndo kuachrjexin ndo ntiꞌa ko sakjui ndo. ");
INSERT INTO pps_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Ko kuatsinga sen ti jii nta̱a̱ tajon tu higo ko bikon sen ixi ó tsixema nta̱a̱ ixi nueꞌe nta̱a̱. ");
INSERT INTO pps_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Ko ndo Pedro sintaxiñao ndo ti ndache ndo Jesús nta̱a̱ higo ko ndachro ndo: ―Maestro, tsjeꞌenta nta̱a̱ tu higo koyakutéenta najna ko jai ó tsixema nta̱a̱. ");
INSERT INTO pps_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Ko ndo Jesús juatingíexin ndo: ―Chuntianta ndo Dio. ");
INSERT INTO pps_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","*Nduaxin ntatjunta ixi siá xrojan jaꞌanta xrondachenta ijna̱ jiꞌi: “Satjixian ntiꞌi ko titsingaꞌngia ndachaon”, ko ixi nchijíi asáanta xrochuntianta ngajin ndo Dio ko tsonꞌen ti tjanchianta. ");
INSERT INTO pps_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Méxin, jaña ntatjunta ixi kain ngeꞌe tsjancheꞌenta ndo Dio, siá nduaxin xrochuntianta ixi tsayeꞌenta meꞌe, jaña tsonꞌen ko nduaxin tsayeꞌenta. ");
INSERT INTO pps_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","*Ko hora nichjeꞌenta ndo Dio ko xroxraxaonnta ixi ningakonꞌennta xrojan ngisen, cháña jian xrotjáñaꞌanta ngeꞌe juintaꞌanta na̱ ixi jaña ndotánta jii ngajní kaxon xrotjáñeꞌe ndo ijie̱ chondanta. ");
INSERT INTO pps_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Ko siá xrotjáñaꞌinta ijie̱ chónda na̱, ndotánta jii ngajní kaxon xrotjáñeꞌa ndo ti ijie̱ chondanta. ");
INSERT INTO pps_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Ko tjumeꞌe ikjan sen tjajna Jerusalén íjngo. Ko ndo Jesús kuaji ndo ngaxinꞌin niꞌngo, ko konchjiñeꞌe xitaana tetuanꞌan ko xi tjako ley ko xi tetuanꞌan niꞌngo, ");
INSERT INTO pps_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","ko jeꞌe xa juanchangiꞌe xa ndo Jesús: ―¿Ngeꞌe juachaxin chonda ixi ncheꞌe jiꞌi? ¿Ngisen tjáa juachaxin ixi jaña ncheꞌe? ");
INSERT INTO pps_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Ko ndo Jesús juatingíexin ndo ko ndachro ndo: ―Kaxon janꞌan tsjanchangiꞌanta naa ngeꞌe, siá tsjatingíexinnta ngeꞌe, xrontatjunta ngeꞌe juachaxin chónda janꞌan. ");
INSERT INTO pps_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","¿Ngisen xruanꞌan ndo Juan ixi tsikitée ndo chujni? ¿Á ndo Dio?, o̱, ¿á chujni? Tjateꞌenta. ");
INSERT INTO pps_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Ko jeꞌo xa juao kichuu xa: ―Siá xrondachrona ixi ndo Dio tsixruaꞌan xi Juan, tjumeꞌe tsjanchangi xi jiꞌi sonda kuitikaonꞌana xi Juan. ");
INSERT INTO pps_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","¿Ko siá xrondachrona ixi chujni tsixruaꞌan xi Juan, já tsoñao na̱? Ko xrakonꞌen xa ni tjajna ixi kain na̱ kuitikaon na̱ ixi ndo Juan nduaxin kuanichja ndo chijnie ndo Dio. ");
INSERT INTO pps_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Ko tjumeꞌe ndache xa ndo Jesús: ―Nónaꞌina. Ko ndachro ndo Jesús: ―Ko kaxon janꞌan xrondachrja̱nꞌi ngisen chjána juachaxin ixi ntaꞌa ixra̱ jiꞌi. ");
INSERT INTO pps_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Tjumeꞌe ndo Jesús ijngo beki ndo naa chijni, ko ndachro ndo: ―Bakeꞌe naa xi, kuenga xa jngiꞌe xa nta̱a̱ tu uva ko juinchéñeꞌe xa naa korra ko inge xa naa tuye no tsóñaxin xran vino. Kaxon juinchéña xa naa tjatuꞌo nui, ntiꞌa tsajinꞌin na̱ tsendáa na̱ jngiꞌe xa. ’Tjumeꞌe kuajon xa ijngi ngajin ikaxin na̱ ixi sincheꞌe na̱ ixra̱ ko sakjui xa ikjín. ");
INSERT INTO pps_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Ko kui̱i̱ nchakon tsaxi tsandáa na̱ itu, ko jeꞌe xa xruanꞌan xa naa sen ncheꞌe xrée xa itsji sen tsjanchia sen itu tikinixinꞌen xa. ");
INSERT INTO pps_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Ko ni juincheꞌe ixra̱ ijngi itsé na̱ sen tsixruaꞌan xi jngiꞌe, ko juaya na̱ ngajin sen, ko xroꞌan itu chjée na̱ sen ko bengi na̱ sen. ");
INSERT INTO pps_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Ko tjumeꞌe xi nunteꞌe xruanꞌan xa inaa sen ncheꞌe xrée xa ngajin na̱. Ko kuiji sen ntiꞌa ko ni chónda ijngi kuaxi na̱ sen ixro ko juincheniꞌe na̱ jaa sen ko kuyakutee na̱ sen. ");
INSERT INTO pps_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Ko tjumeꞌe xi nunteꞌe xruanꞌan xa inaa ngisen kuitsjeꞌe ntiꞌa. Ko sen meꞌe kuiji sen ntiꞌa ko naakóñaxón na̱ sen meꞌe. Ko íjngo xruanꞌan xa ikaxin sen ncheꞌe xrée xa, kuitsjeꞌe sen, ko juaya na̱ ngajin kaxin sen ko ikaxin sen naakóñaxón na̱ sen. ");
INSERT INTO pps_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","’Ko xi nunteꞌe chónda xa naakua chjenꞌen xa, tsango tjueꞌe xa xjan. Ko xruanꞌan xa chjenꞌen xa ikjui xjan kuitsjeꞌe xjan nunte ixi xraxaon xa: “Chjanꞌna, jaán ícha tsitikaon na̱ xjan.” ");
INSERT INTO pps_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Ko ni chónda ijngi juao kichuu na̱: “Xjan jiꞌi tsituꞌe xjan kain ngeꞌe. Naatsóñaxónna xjan, ko jai̱na tsitui̱na kain ngeꞌe.” ");
INSERT INTO pps_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Ko jaña itsé na̱ xjan, naakóñaxón na̱ xjan ko kuantsjexin na̱ xjan ngataon ijngi. ");
INSERT INTO pps_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Ko juanchangi ndo Jesús ko ndachro ndo: ―¿Ngeꞌe sincheꞌe xi nunteꞌe? Tsi̱i̱ xa ko naatsóñaxón xa ni chónda nunteꞌe xa, tjumeꞌe tsajon xa jngiꞌe xa ngajin inaa ngisen sincheꞌe ixra̱. ");
INSERT INTO pps_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","’¿Á juinchekuanxinꞌanta ti jitaxin xroon chijnie ndo Dio? Ndachro: Ixro jueñaoꞌa ni juinchekonchjian tjatuꞌo, jai xro meꞌe ikjan xro, ixro ícha tetuanꞌan. ");
INSERT INTO pps_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Jaña juincheꞌe Ncháina ndo Dio, ko jiꞌi tsango chaxro tikonni. ");
INSERT INTO pps_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Ko ni tituanꞌan tjaun na̱ xrotsé na̱ ndo Jesús ixi kuienxin na̱ ixi kain ti ndachro ndo nichja ndo ixi jeꞌe na̱ meꞌe. Ko xroꞌan ngeꞌe juincheꞌe na̱ ixi xrakonꞌen na̱ ni tjajna ko kuintuꞌe na̱ ndo ko sakjui na̱. ");
INSERT INTO pps_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Tjumeꞌe xruanꞌan na̱ ikaxin ni fariseo ko ni ncheꞌe xrée xi Herodes ixi tsjanchangíꞌe na̱ ndo Jesús kaxin ngeꞌe ixi tjaun na̱ ndakoꞌa tsjatingíexin ndo ko jaña tsjankataꞌa na̱ ndo ijie̱. ");
INSERT INTO pps_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Ko kuiji na̱ ti jii ndo ko ndachro na̱: ―Maestro, nónana ixi jaꞌa nichja ti nduaxin ko taꞌia juachjaon ixi ngeꞌe xroxraxaon chujni ixi nduaxin nchekuenꞌén na̱ chijnie ndo Dio. Méxin, ndachijiana, ¿á chao tsjengana ꞌna̱ ngajin xi tetuanꞌan, tomi tjanchia xa, o̱ naꞌi? ");
INSERT INTO pps_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Ko ndo Jesús noꞌe ndo jian ngeꞌe stexraxaon xa, ko ndachro ndo: ―¿Sonda tjaunnta ndakuaꞌi tsjatengiaxin? Tikuunta naa tomi xrotsjaꞌa. ");
INSERT INTO pps_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Ko jeꞌe na̱ chjée na̱ ndo naa tomi ixi xrotsjeꞌe ndo. Ko juanchangi ndo: ―¿Ngisen ikon jinito tomi jiꞌi ko ngisen jitaxin tomi? Ko jeꞌe na̱ juatingíexin na̱: ―Xi tetuanꞌan, xi César. ");
INSERT INTO pps_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Ko juateꞌe ndo Jesús ko ndachro ndo: ―Chje̱ꞌénta xi tetuanꞌan ngeꞌe tikinixinꞌen xa; ko chje̱ꞌénta ndo Dio ngeꞌe tikinixinꞌen ndo. Ko xrakon xa ixi jaña juateꞌe ndo Jesús. ");
INSERT INTO pps_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","*Ko tjumeꞌe xi saduceo kuitsjeꞌe xa ndo Jesús ixi jeꞌe xa xraxaon xa nduaxinꞌa xroxechón ni tsikenꞌen ko jaꞌin juanchangiꞌe xa ndo Jesús: ");
INSERT INTO pps_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","―Maestro, ndo Moisés tsikjin ndo xroon ó saꞌó ndachro siá tsenꞌen naa xi ko kuintuꞌe janchriꞌe xa, ko xroꞌan ichjan kuachóndakaꞌo xa janchriꞌe xa, xi kichuu xi kuenꞌen xrokonda tsuteꞌe xa nchri kaꞌan, ko ichjan xrochóndakaꞌo xa nchrikanꞌan xrokjan xranchi chjenꞌen xi kuenꞌen. ");
INSERT INTO pps_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Ko bakeꞌe ya̱a̱to̱ xi kichuu xa. Ko xi saꞌó kuteꞌe xa janchriꞌe xa. Tjumeꞌe kuenꞌen xa, ko xroꞌan ichjan kuachónda xa. ");
INSERT INTO pps_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Ko tjumeꞌe xi yuxin kuteꞌe xa nchri kaꞌan, ko kaxon kuenꞌen xa. Ko xroꞌan ichjan kuichónda xa. Ko tjumeꞌe xi nínxin kuteꞌe xa nchri kaꞌan ko jaña xrajeꞌo konꞌen. ");
INSERT INTO pps_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Ko jaña konꞌen ngajin kain xi ya̱a̱to̱. Kain xa ndakuenꞌen xa ko xroꞌan ichjan kuintuꞌe xa. Ko kaxon jeꞌe nchra ndakuenꞌen nchra. ");
INSERT INTO pps_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Méxin, nchakon xroxechón kain chujni tsikenꞌen, ¿ngisen kuanduá ndoxiꞌe nchra ixi kain ya̱a̱to̱ xi kuteꞌe nchra? ");
INSERT INTO pps_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Ko juateꞌe ndo Jesús: ―Ndakoꞌa xraxaonnta ixi tienxinꞌanta ngeꞌe ndachro xroon chijnie ndo Dio ko chuxinꞌanta juachaxien ndo. ");
INSERT INTO pps_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Nchakon xroxechón chujni tsikenꞌen, sen meꞌe tsuteꞌa sen ko tsajonꞌa sen chjenꞌen sen ixi tsuteꞌe xjan ixi chujni tsikenꞌen xranchi sen ángel tsintee sen ngajní. ");
INSERT INTO pps_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Ko ti xroxechón chujni tsikenꞌen, ¿á tsjeꞌanta ngeꞌe ichro xroon tsikjin ndo Moisés ti chronga xranchi nichjaxin ndo Dio ti nta̱a̱ yua yaa xroꞌi? Ko jaꞌin kuinꞌen ndo Moisés: “Janꞌan ndo Dio titikaon ndo Abraham ko ndo Isaac ko ndo Jacob.” ");
INSERT INTO pps_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Méxin, ndo Dio jeꞌa naa ndo Dioe ni tsikenꞌen. Naꞌi. Ndo Dio meꞌe ndo Dioe sen jichón. Ko jaꞌanta tienxinꞌanta ko ndakoꞌa xraxaonnta. ");
INSERT INTO pps_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Tjumeꞌe kui̱i̱ naa xi tjako ley ko kuinꞌen xa xranchi stetjao na̱ ndo Jesús ko kuinꞌen xa jian juateꞌe ndo. Ko juanchangi xa ko ndachro xa: ―¿Ngeꞌe ti ícha tjintee tsikituanꞌan ndo Dio? ");
INSERT INTO pps_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Ko ndo Jesús juatingíexin ndo: ―Ti ícha tjintee tsiketuanꞌan ndo Dio jaꞌin ndachro: “Tinꞌennta kainnta ni Israel ixi Ncháina ndo Dio naáko ndo jii ko koꞌa inaa ngisen. ");
INSERT INTO pps_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Ko ixi nchijíi asáanta ko ti xraxaonnta xrotjuexinnta ndo Dio.” Meꞌe ti ícha tjintee tsiketuanꞌan ndo Dio. ");
INSERT INTO pps_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ko ti chijni yuxin tsiketuanꞌan ndo Dio jaꞌin ndachro: “Xrotjueꞌenta kichuunta xranchi tjueꞌenta asáanta.” Koꞌa inaa ngeꞌe ícha tjintee ti tsiketuanꞌan ndo Dio. ");
INSERT INTO pps_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Tjumeꞌe juateꞌe xi tjako ley, ko ndachro xa: ―Ndako ndachrua, Maestro, nduaxin naakua ndo Dio jii ko koꞌa inaa ngisen. ");
INSERT INTO pps_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Nóna ixi nchijíi aséenni ko ixi ti xraxaonni ko ixi nchijíi jeꞌeni xrotjuexinni ndo Dio ko xrotjueꞌeni ni kichuuni xranchi tjueꞌeni aséenni. Meꞌe ícha tjintee ixi kain iko xrokóñani xrokuayéꞌe ndo Dio. ");
INSERT INTO pps_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","*Ko bikon ndo Jesús ixi jian juateꞌe xa, ndachro ndo: ―Jaꞌa íkjínꞌa ritjén ti jii juachaxien ndo Dio. Ko kain na̱ xronka na̱ ko íxroꞌan ngisen juanchangiꞌe ndo ícha ngeꞌe. ");
INSERT INTO pps_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Tjumeꞌe ndo Jesús bakeꞌe ndo niꞌngo juinchekuenꞌen ndo chujni. Ko juanchangi ndo ko ndachro ndo: ―¿Sonda ni tjako ley ndachro na̱ ixi ndo Cristo naa xjantié ndo David? ");
INSERT INTO pps_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Ixi Espíritue ndo Dio bingijna ndo David ko ndachro ndo: Ndo Dio ndache ndo Nchána: “Takeꞌé ndatsjonxin jian ti no tituanꞌan janꞌan, tsjexinja tsitjáña kain ni ningakonꞌan.” ");
INSERT INTO pps_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","¿Xranchi ndo Cristo xrokjui xjantié ndo David?, ko ndo David ndachro ndo ixi ndo Cristo Nchée jeꞌe ndo. Ko kain chujni juaxruxin bakeꞌe na̱ ti kuinꞌen na̱ ti beki ndo Jesús. ");
INSERT INTO pps_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Tjumeꞌe ndo Jesús nichja ndo ko ndachro ndo: ―Tsjeꞌenta xranchi ncheꞌe ni tjako ley ixi jeꞌe na̱ ncheꞌe na̱ juaxruxin ixi steyá na̱ manta ícha jine̱ ko tjaun na̱ ixi kain ni tjajna tsajon na̱ juasie ngajin jeꞌe na̱ nchakon ichrji na̱ ngataon ndasin. ");
INSERT INTO pps_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Jeꞌe na̱ tjée na̱ ntaxitaon ícha jian tsetaꞌa na̱ ngaxinꞌin niꞌngo. Ko kaxon nchakon itji na̱ kia tjaun na̱ tsakeꞌe na̱ ti no ícha jian. ");
INSERT INTO pps_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Ko tantsjeꞌe na̱ nchri kaꞌan ndoꞌa nchra. Ko tjumeꞌe séen nichjeꞌe na̱ ndo Dio ixi tsinꞌen chujni ngeꞌe ndachro na̱ ko jaña xroxraxaon chujni ixi jeꞌe na̱ jian na̱. Ni meꞌe ícha tangi tsonꞌen na̱. ");
INSERT INTO pps_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Naa nchakon ndo Jesús bakeꞌe ndo ngaxinꞌin niꞌngo tjenka ti tingachjian tomi. Ko jitsjeꞌe ndo takeꞌe na̱ tomi ngaya nta̱a̱. Ko ni chónda itsjé tomi kuajon na̱ tsjé tomi. ");
INSERT INTO pps_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Ko kaxon kui̱i̱ naa nchri kaꞌan nóa ko kuajon nchra yuu tomi nchínchín, tomi tjinteꞌa. ");
INSERT INTO pps_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Ko tjumeꞌe ndo Jesús kuiyeꞌe ndo sen chrikao ndo, ko ndachro ndo: ―Nduaxin ntatjunta ixi nchri kaꞌan, nchri nóa ícha tjintee bikon ndo Dio tomi ti kuajon nchra ixi ti kuajon ikaxin na̱, ");
INSERT INTO pps_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","ixi ni kaxin jeꞌo tomi tsixeꞌe kuajon na̱. Ko jeꞌe nchri nóa kuajon nchra kain tomi chonda nchra xrojuinexin nchra. ");
INSERT INTO pps_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Tjumeꞌe nchakon kuachrjexin ndo Jesús niꞌngo ijié, ndachro sen chrikao ndo: ―Maestro, tsango chaxro ixro ko chaxro nchia tsikonchjian. ");
INSERT INTO pps_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Ko juateꞌe ndo Jesús ko ndachro ndo: ―¿Á tikuan nchia ijié tsikonchjian? Tsiji nchakon ninaa ixro tsitueꞌa ngataꞌa inaa ixro, kain tsitjáña. ");
INSERT INTO pps_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Ko tjumeꞌe sakjui sen ngataꞌa ijna̱ Olivo jna̱ jii ngajinxin niꞌngo. Ntiꞌa bakeꞌe ndo Jesús, ndo Pedro, ndo Jacobo, ndo Juan, ko ndo Andrés ko juanchangiꞌe sen ndo, ko ndachro sen: ");
INSERT INTO pps_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","―Ndachijinanta ngisa tsonꞌen kain jiꞌin ko ngeꞌe tsonoxin ixi jaña tsonónana. ");
INSERT INTO pps_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Ko ndo Jesús juateꞌe ndo ko ndachro ndo: ―Tsjeꞌenta jian ixi xroꞌan ngisen sintayaꞌanta. ");
INSERT INTO pps_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Kueya na̱ tsi̱i̱ na̱ xrondachro na̱ ixi jeꞌe na̱ ndo Cristo. Ko jaña sincheyeꞌe na̱ kueya chujni. ");
INSERT INTO pps_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","’Ko nchakon tsinꞌennta ixi tse̱to̱ naa tjajna ngajin inaa tjajna ko tsóña kichuu na̱, jaꞌanta xronkaꞌinta ixi xrokonda tsonꞌen meꞌe. Ko xratsitjáñaꞌi xasintajni. ");
INSERT INTO pps_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Naa tjajna tse̱to̱kaꞌo inaa tjajna ko xi tetuanꞌan tjajna tsinteke̱ꞌto̱ xa. Ko itsjé no tsontengi nunte ko kueya tjajna tsatse na̱ jinta. Jiꞌi ti xrangíxixín tsi̱i̱ ijié juachjaon. ");
INSERT INTO pps_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","*’Ko jaꞌanta soji takeꞌénta ixi tsikuꞌunta na̱ ti jii xi tetuanꞌan ko ngaxinꞌin niꞌngo ntiꞌa tsjaya na̱ ngajinnta. Kaxon tsikaannta na̱ ti jii xi gobernador ko xi rey ixi chuntianta ngajin janꞌan; ko jaña tsjakoxinnta ngajin jeꞌe na̱ ixi titikaonninta janꞌan. ");
INSERT INTO pps_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Ko xratsitjáñaꞌi xasintajni, xrokonda tsinꞌen kain tjajna chijni jian tsantsje ijie̱. ");
INSERT INTO pps_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Hora tsikuꞌunta na̱ ti jii xi tetuanꞌan, taꞌinta juachjaon ngeꞌe tsjateꞌenta. Jaꞌanta xronichjanta ngeꞌe tsajon ndo Dio nchakon meꞌe, ixi jeꞌa jaꞌonta xronichjanta. Espíritue ndo Dio xronichjaxin ixi jaꞌanta. ");
INSERT INTO pps_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Kaxin chujni tsikaan na̱ ni kichuu na̱ ixi tsóña na̱ na̱. Ko jaña kaxin na̱ tsikaan na̱ chjenꞌen na̱ ixi tsóña na̱ xjan ko íkaxin na̱ xraningakonꞌen na̱ ndotée na̱ ko janée na̱ ko tsikaan na̱ na̱ ixi tsenꞌen na̱. ");
INSERT INTO pps_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","*Kainko ni xasintajni xroningakonꞌannta na̱ ixi titikaonninta. Ko sen nduaxin titikaonna janꞌan ko tsoguaxiꞌen sen ti tsijija nchakon tsjexin kain ngeꞌe, sen meꞌe tsayéꞌe juachaxin tsechón sen kain nchakon. ");
INSERT INTO pps_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","’Sen sinchekuanxin xroon chijnie ndo Dio xrokonda tsienxin sen jian jiꞌi: nchakon tsikonnta tsakeꞌe naa xi tsango ñaꞌi ti no tikinixinꞌa xrobakeꞌe xa, xranchi tsindachro ndo profeta Daniel, ko ni jii nunte Judea nchakon tsikon na̱ meꞌe, satsinga na̱ ijna̱ tsikemá na̱. ");
INSERT INTO pps_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","*Ko ni jii ngataꞌa nchia íxroxingajinꞌa na̱, tixinꞌin na̱ nchia tsantsje na̱ xrojan ngeꞌe. ");
INSERT INTO pps_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ko ni jii ngataon ijngi íxrokjanꞌi na̱ xrotsé na̱ ngeꞌe tsetsáa na̱. ");
INSERT INTO pps_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Ko nchakon meꞌe lastu nchri yaa ichjan ko nchri stenchekaki chjenꞌen. ");
INSERT INTO pps_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Xrojuincheꞌenta ndo Dio ixi jeꞌa nchakuen ikin xrokonꞌen jiꞌi. ");
INSERT INTO pps_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","*Ko nchakon meꞌe ijié juachjaon tsonꞌen na̱, xranchi naiꞌa tsikonꞌen ti juangíxixín ndo Dio juinchéña ndo xasintajni ko tsoenꞌa jaña íjngo. ");
INSERT INTO pps_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Ko siá Ncháina ndo Dio xrokuajonꞌa ndo juachaxin ixi séꞌa tsonchrjenꞌen jiꞌi, íxroꞌan ngisen xrokuechón. Ko tjueꞌe ndo sen tsikincheꞌe ndo, méxin xroꞌan itsjé nchakon tsochrjeꞌen jiꞌi. ");
INSERT INTO pps_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","’Ko siá xrojan ngisen xrontatjunta: “Tsjeꞌenta, ntiꞌi jii ndo Cristo”, o̱ xrondachro na̱: “Tsjeꞌenta, ndaꞌa jii ndo”, titikaonꞌanta na̱. ");
INSERT INTO pps_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Ixi tsi̱i̱ kaxin na̱ xrondachro na̱ ixi jeꞌe na̱ ndo Cristo ko kaxon kaxin na̱ ndakoꞌa tsjako na̱ ko tsjakoxin na̱ naa ixra̱ ijié ixi tjaun na̱ sincheyeꞌe na̱ chujni ko kaxon ngajin sen titikaon ndo Dio. ");
INSERT INTO pps_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Ko jaꞌanta tsjeꞌenta jian ixi ó ntatjunta saꞌó ngeꞌe tsonꞌen. ");
INSERT INTO pps_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","*’Nchakon tsatsinga juachjaon, chjiixro tsonaxixeꞌe, ko nchanitjao ítsingasáñaꞌi. ");
INSERT INTO pps_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","*Ko kaxin nchanotsé tsitsingaxin ngajní ko kain juachaxin jii ngajní xroxranga. ");
INSERT INTO pps_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","*Tjumeꞌe tsikonnta tsi̱i̱ Chjenꞌen ndo Dio, xjan jongíꞌe xranchi chujni, ngakjenꞌen itjui̱ ko tsjako ndo ijié juachaxin chónda ndo. ");
INSERT INTO pps_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ko tsetuenꞌen ndo sen ángel satsji sen nchijíi ngataꞌa nche ixi tsjaꞌo sen kain sen tsikincheꞌe ndo Dio. ");
INSERT INTO pps_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","’Xraxaonnta ngeꞌe bekiꞌanta ixi nta̱a̱ tu higo. Nchakon tachrje ika chaan nta̱a̱, ó noꞌanta ixi íseꞌa tsi̱i̱ nchakon súa, ");
INSERT INTO pps_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","jaña kaxon nchakon tsikonnta jitonꞌen kain jiꞌi, meꞌe ó noꞌanta ixi ó kui̱i̱ nchakon tsjexin xasintajni. ");
INSERT INTO pps_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Méxin, nduaxin ntatjunta ixi kain jiꞌi saꞌó tsonꞌen, ko xratsenꞌa ni jii ngataꞌa nunte. ");
INSERT INTO pps_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Ko ngajní ko xasintajni tsitjáña ko chijnina tsitjáñaꞌi, nduaxin jaña tsonꞌen. ");
INSERT INTO pps_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","*’Ko nchakon ko hora tsonꞌen jiꞌi, xroꞌan ngisen noꞌe, ni sen ángel jii ngajní ni kaxon Chjenꞌen ndo Dio, xjan jongíꞌe xranchi chujni, noeꞌa sen nchakon tsonꞌen jiꞌi. Jeꞌo Ndotána noꞌe ndo. ");
INSERT INTO pps_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","’Méxin tsjeꞌenta jian ko xronichjeꞌenta ndo Dio ixi noaꞌinta ngisa ko ngiora tsonꞌen kain jiꞌi. ");
INSERT INTO pps_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","*Xranchi naa ngisen satsji ikjín, tintuꞌe sen ndoꞌa sen, saꞌó tetuanꞌan sen ngujngu ixra̱ sincheꞌe ni ncheꞌe xrée sen. Ko kuetuenꞌen sen naa xi tsendáa xa nchia ko kain ngeꞌe. ");
INSERT INTO pps_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Méxin, jaꞌanta tarichrinꞌanta ixi noaꞌinta ngisa xrokjan nchée nchia, á naa tsondo o̱ á naa tiie o̱ á ngusine tiie o̱ hora itsje̱ kuntaxichíká o̱ á tsingasáña, ");
INSERT INTO pps_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","ko banchexin tuinxin tsi̱i̱ sen ndoꞌa tsitjanta sen stechrinnta. ");
INSERT INTO pps_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Ti ntatjunta, jaña kain na̱ ixi xrotsjeꞌe na̱ jian xranchi tsakeꞌe na̱. ");
INSERT INTO pps_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Xratitjáña yuu nchakon tsaxi kia pascua ti sine na̱ nutja chóndaꞌi ti tjaꞌin nutja. Tjumeꞌe xitaana tetuanꞌan ko ni tjako ley xraxaon na̱ xranchi sincheya na̱ ixi xrotsé na̱ ndo Jesús ko naatsóñaxón na̱ ndo. ");
INSERT INTO pps_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Ko ndachro na̱: ―Jeꞌa nchakon kia sintuꞌuna jiꞌi ixi batsoñao kain chujni. ");
INSERT INTO pps_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","*Tjumeꞌe ndo Jesús bakeꞌe ndo tjajna Betania ndoꞌa ndo Simón, ndo kuachónda chinlepra. Ko hora jine ndo Jesús, tuinxin kui̱i̱ naa nchri bikaꞌo nchra naa xroxrao jitjiá nda chaxro xraxe tsjo nardo, tsango tjintee. Ko nchri meꞌe kuantjeꞌe nchra xro ko bikitée nchra jaa ndo Jesús nda meꞌe. ");
INSERT INTO pps_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Ko sen ste ntiꞌa koñaoꞌe sen nchra ko ndachro sen: ―¿Sonda juinchexienxin nchra inda chaxro xraxe? ");
INSERT INTO pps_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Cháña xrojuinchekji nchra nda meꞌe, ixi níi ciento tomi denario, ko tjumeꞌe xrojuinchekitunꞌen nchra ni nóa. ");
INSERT INTO pps_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ko ndachro ndo Jesús: ―Tintuꞌenta nchra, ¿sonda tuyakutéenta nchra? Jeꞌe nchra juincheꞌe nchra naa ngeꞌe jian ngajin. ");
INSERT INTO pps_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Ni nóa kain nchakon tsarikuꞌunta na̱, ko chao tsingijnanta na̱ xrojan nchakon. Ko janꞌan kainꞌa nchakon tsakeꞌe ngajinnta. ");
INSERT INTO pps_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ko jeꞌe nchra ó juincheꞌe nchra ngeꞌe ti xrokonda xrojuincheꞌe nchra. Saꞌó bingamána nchra xro̱a̱n ixi xroxrabaana. ");
INSERT INTO pps_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Nduaxin ndachrja̱n ixi kain ti no tsinꞌen na̱ chijni jian, nchijíi ngataꞌa nche tsinꞌen na̱ kaxon ngeꞌe juincheꞌe nchri jiꞌi, ko xroxraxaon na̱ nchra ixi jaña juincheꞌe nchra. ");
INSERT INTO pps_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Tjumeꞌe xi Judas Iscariote, naa xi teyuu sen chrikao ndo Jesús, kuitsjeꞌe xa xitaana tetuanꞌan ixi xrochronga xa xranchi xrotsé na̱ ndo Jesús. ");
INSERT INTO pps_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Ko jeꞌe na̱ bakeꞌe na̱ juaxruxin ixi kuinꞌen na̱ ngeꞌe ndachro xi Judas ko ndachro na̱ tsajon na̱ tomi tsayéꞌe xa. Ko tjumeꞌe kuaxi xraxaon xa xranchi sincheꞌe xa ixi xrotsé na̱ ndo Jesús. ");
INSERT INTO pps_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Nchakon xrangíxixín kia sine na̱ nutja chóndaꞌi ti tjaꞌin nio, nchakon meꞌe tóña na̱ kutuchjon sine na̱ kia pascua. Ko sen teyuu chrikao ndo Jesús juanchangiꞌe sen ndo: ―¿Ti no tjaunnta sintakonchjianxinna ti sinena kia pascua? ");
INSERT INTO pps_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Tjumeꞌe kuetuenꞌen ndo yuu sen chrikao ndo, ko ndachro ndo: ―Itjinta tjajna Jerusalén ko ntiꞌa tsetannta naa xi yama nchixran jitjiá inda. Rueꞌénta xa ");
INSERT INTO pps_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","ti nchia tixinꞌin xa, ko ndachenta xi ndoꞌa: “Kuetuanꞌan ndo nchekuanna̱na: ¿Ti no jii nchia sinexin ndo kia pascua ko sen teyuu chrikao ndo?” ");
INSERT INTO pps_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ko tjumeꞌe jeꞌe xa tsajon xa naa nchia yuxin jii noi ko ntiꞌa ó jii kain ngeꞌe. Ntiꞌa nchekonchjianxinnta ti sinena. ");
INSERT INTO pps_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Tjumeꞌe jeꞌe sen sakjui sen tjajna Jerusalén ko kuitja sen xranchi tsindachro ndo Jesús. Ko ntiꞌa juinchekonchjianxin sen ti sine sen kia pascua. ");
INSERT INTO pps_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Tjumeꞌe ó kóndo kuiji ndo Jesús ko sen teyuu chrikao ndo. ");
INSERT INTO pps_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Ko hora stene sen, ndachro ndo Jesús: ―Nduaxin ndachrja̱n ixi naa jaꞌanta rinekiꞌan ntiꞌi sinchekjininta. ");
INSERT INTO pps_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Ko jeꞌe sen kochíin sen. Ko kuaxi ngujngu sen juanchangiꞌe sen ndo: ―¿Á janꞌan ngisen sincheꞌe meꞌe? ");
INSERT INTO pps_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Ko juateꞌe ndo Jesús ko ndachro ndo: ―Xi meꞌe naa sen teyuu rinekiꞌan ngaya latona. ");
INSERT INTO pps_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Chjenꞌen ndo Dio, xjan jongíꞌe xranchi chujni, tsonꞌen xjan xranchi nichja xroon chijnie ndo Dio. Ko lastu xi sinchekji ndo ixi ícha jian xrojongíeꞌa xi meꞌe. ");
INSERT INTO pps_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Ko stene sen, ndo Jesús kua ndo naa nutja, ko kuajon ndo juasaya ngajin ndo Dio. Ko tjumeꞌe konchrinjin ndo nutja ko konchjeyeꞌe ndo sen. Ko ndachro ndo: ―Intenta, jiꞌi cuerpona. ");
INSERT INTO pps_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Ko kaxon kua ndo naa vaso ko kuajon ndo juasaya ngajin ndo Dio ko chjée ndo sen ko kain sen kuiꞌi sen. ");
INSERT INTO pps_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Tjumeꞌe ndachro ndo: ―Jiꞌi jnina chronga ixi nduaxin tsaxi tsituanꞌan naa ley natjúá ícha tjintee, jnina tsintji jni̱ ixi tsitjáñaxin ijie̱ chónda kain chujni. ");
INSERT INTO pps_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Nduaxin ndachrja̱n ixi ítsiꞌa janꞌan ndée tu uva íjngo, hasta ti tsijija nchakon tsojuna ti tetuanꞌan ndo Dio. Ko nchakon meꞌe tsiꞌi ndée tu uva natjúá. ");
INSERT INTO pps_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Ko juexin itsje̱ sen naa soon ngajin ndo Dio, tjumeꞌe sakjui sen ijna̱ Olivo. ");
INSERT INTO pps_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Ko ndo Jesús ndachro ndo: ―Tiie jai kainnta tsintunaninta ko tsonꞌen xranchi ndachro xroon chijnie ndo Dio: “Naatsóñaxón na̱ sen tingatjia kutuchjon, ko jeꞌe ba xrochjekeꞌe ba.” ");
INSERT INTO pps_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","*Ko nchakon xroxechónna, janꞌan tsitaoꞌannta chaꞌo itji nunte Galilea. ");
INSERT INTO pps_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Ko ndachro ndo Pedro: ―Maski kain sen tsintuꞌanta sen, janꞌan tsintuaꞌinta. ");
INSERT INTO pps_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Ko ndachro ndo Jesús: ―Nduaxin xrontatjua ixi jai tiie xrajeꞌa yuu xrotsje̱ kuntaxichíká, jaꞌa níi xrondachrua ixi chuxinꞌana. ");
INSERT INTO pps_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Ko séen juateꞌe ndo Pedro ko ndachro ndo: ―Maski tsenꞌenna, xrondachrja̱nꞌi chuxinꞌanta. Ko jaña ndachro kain sen. ");
INSERT INTO pps_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Tjumeꞌe kuiji sen naa huerto ndatinꞌin Getsemaní. Ko kuetuenꞌen ndo Jesús sen chrikao ndo: ―Tituanꞌanta ntiꞌi, janꞌan itsji xronichjaꞌa ndo Dio. ");
INSERT INTO pps_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Tjumeꞌe ndo Jesús sabikao ndo ndo Pedro ko ndo Jacobo ko ndo Juan. Ko kuaxi tsango koniꞌe aséen ndo xranchi ndaxrokuenꞌen ndo. ");
INSERT INTO pps_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Ko ndache ndo sen: ―Tsango koniꞌe aséenna ixi kain ngeꞌe tsónna. Ntiꞌó tituanꞌanta, tarichrinꞌanta. ");
INSERT INTO pps_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Ko tjumeꞌe sakjui ndo ícha kjínxin ko bakeꞌexin ndo ntatuchiꞌin ndo ko kuaxi kuinóatée ndo ngajin ndo Dio ixi xrokuajon ndo Dio juachaxin ixi xrokuatsingaꞌi ndo juachjaon meꞌe. ");
INSERT INTO pps_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Ko ndachro ndo: ―Jaꞌanta Ndotána. Jaꞌanta chondanta kain juachaxin ko tjanchaꞌanta ixi tsatsingaꞌi janꞌan juachjaon jiꞌi. Ko tsoenꞌa xranchi janꞌan tjaꞌon. Naꞌi, tsonꞌen xranchi jaꞌanta tjaunnta. ");
INSERT INTO pps_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Ko tjumeꞌe ikjan ndo ti kuintuꞌe ndo sen ko kuitja ndo sen stejua sen. Ko ndache ndo ndo Pedro: ―Simón Pedro, ¿á richrian? ¿Á juaꞌi kuarichuan maski naa hora? ");
INSERT INTO pps_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Jai xingamaꞌanta ko nichjeꞌenta ndo Dio ixi tsajonꞌa ndo juachaxin ixi Xixronꞌanxrée sintayaꞌanta xa. Espírituanta tjée ndo Dio ko ntauꞌanta sojiꞌa. ");
INSERT INTO pps_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Tjumeꞌe sakjui ndo íjngo kuinóatée ndo ngajin ndo Dio. Ko xrajeꞌo nichja ndo. ");
INSERT INTO pps_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Tjumeꞌe ikjan ndo ko kuitja ndo sen stejua sen íjngo ko juaꞌi tantjeꞌe ikon sen ixi tsango chjée sen kotachrin. Ko noeꞌa sen ngeꞌe tsjateꞌe sen. ");
INSERT INTO pps_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Ko nínxin sakjui ndo ko ikjan ndo ko ndachro ndo: ―¿Á xrastechrinnta ko stetjokaꞌanta? Jai ó kui̱i̱ hora ixi Chjenꞌen ndo Dio, xjan jongíꞌe xranchi chujni, tsajon na̱ xjan ngajin ni ñaꞌi. ");
INSERT INTO pps_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Tingatjennta sachjina ixi ó jiti̱i̱ ngisen sinchekjina. ");
INSERT INTO pps_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Xrajinichja ndo Jesús, tuinxin kui̱i̱ xi Judas, naa xi teyuu chrikao ndo. Ko kueya na̱ bijikao xa steyá na̱ chika espada ko nta̱a̱. Ni meꞌe tsixruaꞌan xitaana tetuanꞌan ko xi tjako ley ko xi tetuanꞌan niꞌngo. ");
INSERT INTO pps_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Ko xi Judas, xi juinchekji ndo, tsindachro xa: ―Xi tsetoxin, xi meꞌe itsenta ko satikuꞌunta. ");
INSERT INTO pps_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Tjumeꞌe kui̱i̱ xi Judas ko tuinxin konchjiñeꞌe xa ngajin ndo Jesús ko ndachro xa: ―Maestro, Maestro. Ko kuitoxin xa ndo. ");
INSERT INTO pps_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Ko ni kuijikao xa itsé na̱ ndo Jesús, sabikao na̱ ndo. ");
INSERT INTO pps_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Ko naa sen jii ntiꞌa kuantsje chika espada konchrinjin sen ndatsjon naa xi ncheꞌe xrée xitaana tetuanꞌan. ");
INSERT INTO pps_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Ko ndo Jesús ndachro ndo: ―¿Sonda bikuunta chika yao ko nta̱a̱ xrotséxinninta xranchi xrokjui naa xicheꞌe? ");
INSERT INTO pps_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","*Kain nchakon bakeꞌe ngajinnta ti jii niꞌngo juintakuanꞌannta, ko, ¿sonda tséꞌaninta ntiꞌa? Ko xrokonda jaña tsonꞌen xranchi nichja xroon chijnie ndo Dio. ");
INSERT INTO pps_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Ko kain sen chrikao ndo Jesús kuintuꞌe sen ndo ko sakjui sen. ");
INSERT INTO pps_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Naa chajan kaxon jiruéꞌe chán ntiꞌa, ko jeꞌo naa manta jitsía chán, ko itsé na̱ chán. ");
INSERT INTO pps_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Ko jeꞌo mantée chán tsitsé na̱ ko turuchu chán sabinga chán. ");
INSERT INTO pps_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Tjumeꞌe sabikao na̱ ndo Jesús ndoꞌa xitaana tsango tetuanꞌan. Ntiꞌa tsixraꞌo kain xitaana tetuanꞌan ko ni tachríi tetuanꞌan niꞌngo ko ni tjako ley. ");
INSERT INTO pps_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Ko ndo Pedro ikjín jiruéexin ndo ko kuiji ndo ti ntasien ndoꞌa xitaana tsango tetuanꞌan. Ntiꞌa jiche xroꞌi. Ko xi policía stendajin xa xroꞌi jixraxruꞌe xa, ko kaxon ndo Pedro jixraxruꞌe ndo. ");
INSERT INTO pps_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Ko xi tetuenꞌen xitaana ko kain xi ícha tetuanꞌan juée na̱ ngisen xrojuankataꞌa ijie̱ ngajin ndo Jesús ixi jaña naatsóñaxón na̱ ndo. Ko kuitjaꞌi xa ijie̱ ngajin ndo ");
INSERT INTO pps_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","ixi itsjé na̱ ndachro na̱ ti nduaxinꞌa ko tjankataꞌa na̱ ndo ijie̱ ko jeꞌa xrajeꞌo ngeꞌe ndachro na̱. ");
INSERT INTO pps_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Ko bingatjen kaxin ni juankataꞌa ndo ijie̱ ko ndachro na̱: ");
INSERT INTO pps_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","*―Janꞌanna kui̱nꞌa̱n ixi ndachro xi Jesús tsonchjejin xa niꞌngo tsijinchekonchjian chujni, ko nchakon nínxin sinchekonchjian xa niꞌngo íjngo ko jeꞌa chujni sinchekonchjian. ");
INSERT INTO pps_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Maski jaña ndachro na̱ ko jeꞌa xrajeꞌo kuanichja kain na̱. ");
INSERT INTO pps_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Ko xi tetuenꞌen xitaana bingatjen xa ti ste kain na̱ ko juanchangiꞌe xa ndo Jesús: ―¿Á xroꞌan tsjatengíexian jaꞌa ti ijie̱ tjankataꞌa na̱? ");
INSERT INTO pps_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Ko ndo Jesús tenko ndo, xroꞌan ngeꞌe juateꞌe ndo. Ko xitaana tetuanꞌan ndachro xa íjngo: ―¿Á jaꞌa ndo Cristo, Chjenꞌen ndo Dio tsango tjúá? ");
INSERT INTO pps_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Ko ndachro ndo Jesús: ―Jaán, janꞌan. Ko naa nchakon jaꞌanta tsikonnta Chjenꞌen ndo Dio, xjan jongíꞌe xranchi chujni, tsakeꞌe xjan ndatsjonxin jian ti jii ndo Dio, ndo chónda ijié juachaxin ko jeꞌe xjan tsi̱ꞌxi̱n ndo ngajní ngakjenꞌen itjui̱. ");
INSERT INTO pps_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Ko xitaana tetuanꞌan kuinchje xa ti jitsáa xa ixi tsango koñao xa ko ndachro xa: ―Íxrokondaꞌi ixi ikaxin na̱ xrochronga na̱ ti ndakuaꞌi ncheꞌe xi jiꞌi. ");
INSERT INTO pps_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Jaꞌanta ó kuinꞌennta ixi nichjangíꞌe xa ndo Dio. ¿Ngeꞌe ndachronta? Ko kain na̱ juatingíexin na̱, xrokonda tsenꞌen ndo. ");
INSERT INTO pps_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Tjumeꞌe ikaxin na̱ kuaxi na̱ bikitée na̱ ndo ndatée na̱. Ko kuaxi na̱ bijeꞌe na̱ ikon ndo ko kuandeꞌe na̱ ndo itja na̱ ko juanchangiꞌe na̱ ndo: ―Ndachrua ngisen juaya ngajian. Tjumeꞌe xi policía kondee niꞌngo kuandeꞌe xa itja xa ngaya ikon ndo Jesús. ");
INSERT INTO pps_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Ko ndo Pedro jii ndo ti jii nda̱sin. Ko tjumeꞌe kui̱i̱ naa nchri ncheꞌe ixra̱ ngajin xitaana tetuanꞌan. ");
INSERT INTO pps_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Ko bikon nchra jixraxruꞌe ndo Pedro ngandeꞌe xroꞌi ntiꞌa. Ko jian jitsjeꞌe nchra ndo ko ndachro nchra: ―Jaꞌa kaxon chrjikoꞌa xi Jesús kui̱xi̱n tjajna Nazaret. ");
INSERT INTO pps_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Ko ndo Pedro ndachro ndo: ―Naꞌi. Janꞌan chúxinꞌa xi meꞌe. Nónaꞌi ngeꞌe ndachrua. Tjumeꞌe kuachrjexin ndo ntiꞌa sakjui ndo nduja. Ko tuinxin itsje̱ naa kuntaxichíká. ");
INSERT INTO pps_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Ko íjngo bikon nchra ndo ko ndache nchra ni ste ntiꞌa: ―Xi meꞌe naa xi chrikao xi Jesús. ");
INSERT INTO pps_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Ko ndachro ndo Pedro íjngo: ―Naꞌi. Ko ícha tjumeꞌe ni ste ntiꞌa ndache na̱ ndo Pedro: ―Nduaxin jaꞌa kaxon tsikjixian tjajna Galilea ixi jaꞌa nichja xranchi nichja ni tjajna meꞌe. ");
INSERT INTO pps_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Ko ndo Pedro kuaxi ndo benga ndo teka ko ndachro ndo: ―Chúxinꞌa xi ndachronta. ");
INSERT INTO pps_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Ko tuinxin ndo Pedro kuinꞌen ndo yuxin itsje̱ kuntaxichíká. Ko xraxaon ndo xranchi tsindachro ndo Jesús: “Xrajeꞌa yuu xrotsje̱ kuntaxichíká, jaꞌa nínxin xrondachrua chuxinꞌana.” Meꞌe xraxaon ndo ko tsjanga ndo ixi ndakoꞌa juincheꞌe ndo. ");
INSERT INTO pps_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Tjumeꞌe ó bingasáña ko xitaana tetuanꞌan kao ni tachríi, ko ni tjako ley ko kain ni tetuanꞌan niꞌngo, xraꞌo kain na̱ juintejao kichuu xa ko juexin itsé na̱ ndo Jesús sabikao na̱ ndo ngajin xi Pilato. ");
INSERT INTO pps_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Ko xi Pilato juanchangiꞌe xa ndo Jesús ko ndachro xa: ―¿Á jaꞌa Rey tetuanꞌan ni judío? Ko jaꞌin juatingíexin ndo Jesús: ―Jaꞌa ndachrua. ");
INSERT INTO pps_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Tjumeꞌe xitaana tetuanꞌan bankataꞌa xa ndo ijie̱. ");
INSERT INTO pps_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Ko xi Pilato juanchangi xa íjngo, ko ndachro xa: ―¿Jaꞌa, sonda xroꞌan ngeꞌe tjatengíexian? Itsjé ijie̱ tjankataꞌa na̱. ");
INSERT INTO pps_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Ko ndo Jesús xroꞌan ngeꞌe juatingíexin ndo. Tjumeꞌe xi Pilato noeꞌa xa ngeꞌe sincheꞌe xa. ");
INSERT INTO pps_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Ko kia meꞌe xi Pilato xrokonda tsajanda xa naa xi jii ngaxinꞌin ndoꞌachjiso, ngixeꞌi xi tsjanchia chujni tjajna. ");
INSERT INTO pps_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Ko ngaxinꞌin ndoꞌachjiso jii naa xi ndatinꞌin Barrabás, ko ikaxin ni ñaꞌi tsikitikaonꞌa xi tetuanꞌan ko naatsikóñaxón xa kaxin chujni. ");
INSERT INTO pps_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Ko kui̱i̱ kueya na̱ juancheꞌe na̱ xi Pilato ixi xrojuincheꞌe xa xranchi tonꞌen kain nano. ");
INSERT INTO pps_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Ko juatingíexin xi Pilato: ―¿Á tjaunnta tsajanda satsji xi Rey tetuenꞌen ni judío? ");
INSERT INTO pps_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Jaña ichro xa ixi jeꞌe xa noꞌe xa ixi xitaana tetuanꞌan tochjuyeꞌe xa ngajin ndo Jesús, méxin tsitsé na̱ ndo. ");
INSERT INTO pps_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Ko xitaana tetuanꞌan juinchekateya xa kain chujni jii ntiꞌa, ko ndache xa na̱ ixi tsjanchia na̱ ngajin xi Pilato ixi xrokuajanda xa xi Barrabás. ");
INSERT INTO pps_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Tjumeꞌe xi Pilato juanchangi xa, ko ndachro xa: ―Ko xi nchekinꞌinnta Rey tetuenꞌen ni judío, ¿ngeꞌe tjaunnta tsonꞌen xa? ");
INSERT INTO pps_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ko jeꞌe na̱ juatingíexin na̱, ko stetoyako na̱: ―¡Tjankanitua xa nta̱cru! ");
INSERT INTO pps_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Ko xi Pilato juanchangiꞌe xa na̱: ―¿Ngeꞌe ndakuaꞌi juincheꞌe xi jiꞌin? Ko ícha séen kuyako na̱ tjanchia na̱: ―¡Tjankanitua xa nta̱cru! ");
INSERT INTO pps_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Ko xi Pilato tjaun xa sincheꞌe xa ngeꞌe tjaun na̱, ko kuajon xa juachaxin tsajanda na̱ xi Barrabás ko kuetuanꞌan xa ixi xrojuaya na̱ ngajin ndo Jesús ko kuajon xa juachaxin ixi xi soldado satsikao xa ndo Jesús tsenito xa ndo nta̱cru. ");
INSERT INTO pps_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Tjumeꞌe xi soldado sabikao xa ndo Jesús ngaxinꞌin ntasien nchatituanꞌan. Ntiꞌa xejuxin kain xi soldado. ");
INSERT INTO pps_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Ko ntiꞌa juinchekakeꞌe na̱ ndo Jesús naa manta játsetié ko bakeꞌe na̱ ngataꞌa jaa ndo naa corona tsikóñaxin nta̱chaꞌa. ");
INSERT INTO pps_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Tjumeꞌe juangíxin kuyako xi soldado, ko ndachro xa: ―Kain nchakon tsechón Rey tituenꞌen ni judío. ");
INSERT INTO pps_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Ko ixi naa ntasé tandeꞌe xa jaa ndo Jesús, ko ndatée xa bikitée xa ndo. Ko bakeꞌexin ntatuchiꞌin xa ko nchexin xa xranchi xrokuajon xa juasaya ngajin ndo. ");
INSERT INTO pps_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Ko juexin juanoa xa ndo kuantsjeꞌe xa ndo manta játsetié jiá ndo ko juinchekeya xa ndo mantée ndo íjngo. Ko kuantsjexin xa ndo ntiꞌa sabikao xa ndo ixi tsenito xa ndo nta̱cru. ");
INSERT INTO pps_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","*Ko nchakon meꞌe naa xi tsiki̱ꞌxi̱n tjajna Cirene, ndatinꞌin xa Simón, xi jiꞌin ndotée xi Alejandro ko xi Rufo, xi meꞌe jiti̱ꞌxi̱n xa chjaka, ko kuatsinga xa ntiꞌa. Ko xi soldado juinchekama xa xi meꞌe nta̱cru, nta̱a̱ yama ndo Jesús. ");
INSERT INTO pps_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Tjumeꞌe sabikao xa ndo Jesús ijna̱ ndatinꞌin Gólgota, ko Gólgota xrondachro ngigueꞌe na̱ ntajaa chujni. ");
INSERT INTO pps_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Ko ntiꞌa chjée na̱ ndo vino tsijinchentekjan na̱ xro̱a̱n mirra xrokuiꞌi ndo Jesús, ko jeꞌe ndo kuiꞌa ndo. ");
INSERT INTO pps_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Tjumeꞌe xi soldado kuenito xa ndo Jesús nganito nta̱cru. Ko juexin jiꞌi, sondaonxin xa ixro ixi jaña tsonoꞌe xa ngisen tsjacha tsituꞌe ngujngu manta jiá ndo. ");
INSERT INTO pps_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Ko ó las nueve ti kuasintjian xa ndo nganito nta̱cru. ");
INSERT INTO pps_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ko nganito nta̱a̱ jii ndo Jesús tsikakeꞌe na̱ naa nta̱a̱ nchíín tsikjin na̱ kondeexin ti tsenꞌen ndo ko jaꞌin ndachro: “Xiꞌi Rey tetuenꞌen ni judío.” ");
INSERT INTO pps_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Ko kaxon kuasintjian na̱ nganito nta̱cru yuu xicheꞌe, naa xi bakeꞌe na̱ ndatsjonxin jian ti jii ndo Jesús ko inaa xa bakeꞌe na̱ xa ndatsjonxin ikjon ti jii ndo. ");
INSERT INTO pps_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Jaña konꞌen xranchi jitaxin xroon chijnie ndo Dio ti ndachro: “Xranchi naa ni chónda ijie̱ juinchekao na̱ ndo.” ");
INSERT INTO pps_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","*Ko ni stetatsinga ntiꞌa juanoa na̱ ndo ko nichjangíꞌe na̱ ndo ko tingatjia jaa na̱ ko ndachro na̱: ―Jaꞌa ndachrua tsonchejia niꞌngo, ko níiko nchakon sinchekonchjianxian niꞌngo íjngo. ");
INSERT INTO pps_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Siá nduaxin sincheꞌe meꞌe, xingajinxian nta̱cru. ");
INSERT INTO pps_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Ko xitaana tetuanꞌan ko xi tjako ley juanoa xa ndo, ko jaꞌin juao kichuu xa: ―Inaa na̱ bingijna xi jiꞌin ko jeꞌe xa juaꞌi tingijna aséen xa. ");
INSERT INTO pps_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Siá nduaxin jeꞌe xa ndo Cristo, Rey tetuenꞌen tjajna Israel, tsikonna xroxingajinxin xa nta̱cru ko jaña tsitikaonna xa. Ko kaxon xi ste nganito nta̱cru nichjangíꞌe xa ndo. ");
INSERT INTO pps_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Tjumeꞌe ngusine nchakon konaxixeꞌe nchijíi nunte xasintajni ti kuijija hora nínxin kóndo. ");
INSERT INTO pps_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Ko hora meꞌe séen ndachro ndo Jesús: ―Eloi, Eloi, ¿lama sabactani? ―ngigueꞌe na̱ xrondachro: Ndotána, Ndotána, ¿sonda kuintunantana? ");
INSERT INTO pps_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Ko kaxin ni ste ntiꞌa kuinꞌen na̱ ngeꞌe ndachro ndo, meꞌe ndachro na̱: ―Tinꞌennta, jitiyeꞌe xa ndo Elías, ndo kuachronga chijnie ndo Dio ó saꞌó. ");
INSERT INTO pps_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Tjumeꞌe naa xi jii ntiꞌa binga xa kua xa tuꞌo manta ko juinchetjao xa ixi vinagre, ko ixi naa nta̱a̱ ijié kokaxin xa manta ti jii roꞌa ndo Jesús ixi xrokuiꞌi ndo meꞌe. Ko ndachro xa: ―Xrochonꞌenna á nduaxin tsi̱i̱ ndo Elías sinchexingajin ndo xa. ");
INSERT INTO pps_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Ko ndo Jesús séen kuyako ndo ko kuenꞌen ndo. ");
INSERT INTO pps_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Ko velo jijee̱xin niꞌngo kuinchje nui hasta ti nunte. ");
INSERT INTO pps_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Ko xi capitán romano jindaa xa ti jii ndo Jesús, bikon xa juexin kuenꞌen ndo ko ndachro xa: ―Nduaxin xi jiꞌi Chjenꞌen ndo Dio. ");
INSERT INTO pps_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","*Kaxon ntiꞌa ste kaxin nchri, ikjín stetsjexin nchra, nchri meꞌe: jan María Magdalena, jan María, janée ndo ndatinꞌin Jacobo, ndo chjiaxon, ko ndo José. Ko kaxon jan Salomé. ");
INSERT INTO pps_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Ko sen nchri meꞌe ruéꞌe sen ndo Jesús ko kuayakonꞌen sen ndo nchakon bakeꞌe ndo tjajna Galilea ko ntiꞌa jii ikaxin nchra, nchri ruéꞌe ndo ti sakjui ndo tjajna Jerusalén. ");
INSERT INTO pps_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Tjumeꞌe ó kóndo nchakon xrangíxixín nchakon tjokéꞌe na̱, ");
INSERT INTO pps_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","kui̱i̱ naa ndo ndatinꞌin José, tjajnée ndo ndatinꞌin Arimatea. Ndo meꞌe kaxon tetuanꞌan ndo ti tjajnée ni judío. Jeꞌe ndo meꞌe jichónꞌen ndo tsi̱i̱ juachaxien ndo Dio ko xrakonꞌa ndo kuitsjeꞌe ndo xi Pilato ko juanchia ndo satsikao ndo cuerpoe ndo Jesús. ");
INSERT INTO pps_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Ko xi Pilato xronka xa ixi ó juexin tsikenꞌen ndo Jesús, méxin, kuiyeꞌe xa xi capitán ko juanchangiꞌe xa xi meꞌe á nduaxin tsikenꞌen ndo. ");
INSERT INTO pps_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Ko chronga xi capitán ixi nduaxin ó juexin kuenꞌen ndo Jesús. Ko kuinꞌen xi Pilato jaña, ko kuajon xa juachaxin ixi tsikao ndo José cuerpoe ndo Jesús. ");
INSERT INTO pps_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Tjumeꞌe ndo José tsikeꞌna ndo manta chaxro ko ikjui ndo juinchexingajin ndo cuerpoe ndo Jesús, ko kuintsía ndo ndo Jesús manta. Tjumeꞌe bakeꞌe ndo cuerpoe ndo Jesús ti no tsinge na̱ ngaxinꞌin naa itjao̱. Ko naa ixro ijié bijee̱xin ndo itjao̱ meꞌe. ");
INSERT INTO pps_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Ko jan María Magdalena ko jan María, janée ndo José, bikon sen no bakeꞌe na̱ cuerpoe ndo Jesús. ");
INSERT INTO pps_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Tjumeꞌe kuatsinga nchakon tjokéꞌe na̱, jan María Magdalena ko jan María, janée ndo Jacobo, ko jan Salomé kueꞌna sen xro̱a̱n chaxro xraxe ixi tsingamá sen cuerpoe ndo Jesús. ");
INSERT INTO pps_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Ko, nchakon xrangíxixín semana sakjui sen ti no tsixrabaa ndo. ");
INSERT INTO pps_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Ko jeꞌe sen nchri stetjao kichuu sen: ―¿Ngisen tsingijnana tsintjian ixro jijee̱xin itjao̱? ");
INSERT INTO pps_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Ko ti kuiji sen nchri bikon sen ixi ixro ijié jijee̱xin itjao̱, ó tsikontengi ixro. ");
INSERT INTO pps_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Ko jeꞌe sen nchri kuixinꞌin sen itjao̱ meꞌe, ko bikon sen naa chajan jii chán nunte ndatsjonxin jian ko jiá chán manta jine̱ ko tjúá, ko jeꞌe sen nchri xronka sen. ");
INSERT INTO pps_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ko jeꞌe chán ndachro chán: ―Xronkaꞌinta. ¿Á tjéenta ndo Jesús, ndo tsiki̱ꞌxi̱n tjajna Nazaret, ndo kuenito na̱ nta̱cru? Jeꞌe ndo ó xechón ndo, í koꞌa ndo ntiꞌi. Tsjeꞌenta ti no bakeꞌe na̱ ndo. ");
INSERT INTO pps_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","*Satjinta, ndachenta sen bajikao ndo ko kao ndo Pedro ixi ndo Jesús sakuitaon ndo nunte Galilea ko ntiꞌa tsikonnta ndo xranchi tsintatjunta ndo. ");
INSERT INTO pps_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Ko sen nchri sajuixin sen ti no tsixrabaa ndo Jesús, stexronka sen ko stexranga sen. Ko xroꞌan ngisen ndache sen nchri ti ngeꞌe tsikikon sen ixi tsango xronka sen. ");
INSERT INTO pps_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Nchakon xechón ndo Jesús, nchakon xrangíxixín semana saꞌó konoxin ndo ngajin jan María Magdalena, jan tsikantsjexin ndo ya̱a̱to̱ espíritue Xixronꞌanxrée. ");
INSERT INTO pps_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Ko jeꞌe jan sakjui jan, bekiꞌe jan sen chrikao ndo ixi jeꞌe sen jitoniꞌe aséen sen ko stetsjanga sen. ");
INSERT INTO pps_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Ko kuinꞌen sen ixi jaña tsikikon jan ko kuitikaonꞌa sen ti ndachro jan. ");
INSERT INTO pps_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Ko tjumeꞌe yuu sen bikon ndo Jesús, ko jéexin bikon sen ndo. Sen meꞌe jitji sen chaꞌo itji chjaka. ");
INSERT INTO pps_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Ko jeꞌe sen kuichronga sen ngajin sen kaxin; ko kaxon jeꞌe sen kuitikaonꞌa sen. ");
INSERT INTO pps_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Tjumeꞌe konoxin ndo ngajin sen tenaá kuajikao ndo ti stene sen. Ko nichjeꞌe ndo sen sonda tsikitikaonꞌa sen ngeꞌe chronga sen tsikikon ndo ixi jeꞌe ndo ó tsixechón ndo. ");
INSERT INTO pps_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","*Ko ndache ndo sen: ―Itjinta nchijíi nunte xasintajni nchekuenꞌennta kain na̱ chijni jian ixi tsayéꞌe na̱ juachaxin tsechón na̱ kain nchakon. ");
INSERT INTO pps_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Sen tsitikaon ko tsikitée, sen meꞌe tsitjáñaꞌi sen. Ko ni tsitikaonꞌa, ni meꞌe tangi tsonꞌen na̱. ");
INSERT INTO pps_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Ko sen tsitikaonna janꞌan, sen meꞌe chao sincheꞌe sen naa ixra̱ jian, ixi tsayéꞌe sen juachaxin tsantsje sen espíritue Xixronꞌanxrée chónda kaxin na̱ ko kaxon xronichja sen jée ngigua. ");
INSERT INTO pps_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Maski kunchee xrotsé sen, xroꞌan ngeꞌe tsonꞌen sen, ko maski xrokuiꞌi sen xro̱a̱n yua, tsenꞌa sen. Kaxon tsakeꞌe itja sen ngataꞌa jaa ni niꞌe ko ni niꞌe tsoxruenꞌen na̱. ");
INSERT INTO pps_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","*Tjumeꞌe juexin nichja Ncháina Jesús ngajin sen, jeꞌe ndo kuajinꞌin ndo ngajní. Ko ntiꞌa bakeꞌe ndo ndatsjonxin jian ti jii ndo Dio. ");
INSERT INTO pps_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Ko sakjui sen ko juako sen chijni jian, chijni ncheméꞌe ijie̱ chónda chujni. Ko Ncháina Jesús bingijna ndo sen ko juachaxien ndo juinchexin sen ixra̱ jian, ixi jaña tsonoexin chujni ixi nduaxin chijnie ndo Dio nchekuenꞌen sen na̱. Jaña tsonꞌen.");
INSERT INTO pps_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Kueya na̱ tjaun na̱ ndako xrokjin na̱ kain ngeꞌe nduaxin konꞌen nchakon bakeꞌe ndo Jesús ngajinna ");
INSERT INTO pps_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","xranchi juinchekuai̱na sen, sen xrangíxixión bikonxin ikon sen kain ngeꞌe juincheꞌe ndo Jesús ko kuaxi sen chronga sen ti nichja ndo. ");
INSERT INTO pps_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Janꞌan kaxon juanchangi jian kain ngeꞌe tsikonꞌen xrangíxixión bakeꞌe ndo Jesús. Ko jai xrokjinꞌannta, Teófilo, kain ngeꞌe xranchi tsikonꞌen naa ko naa, ");
INSERT INTO pps_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","ixi tsichuxinnta jian kain ngeꞌe tsijinchekuanꞌannta sen. ");
INSERT INTO pps_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Nchakon bakeꞌe xi Herodes baketuenꞌen xa nunte Judea, ntiꞌa bakeꞌe naa ndotaana bakinꞌin Zacarías, kuachrjenixin ndo xitaana bakinꞌin Abías. Ko janchriꞌe ndo Zacarías bakinꞌin jan Elisabet, ndotáchriꞌe jan kaxon xranchrjen ndotaana Aarón. ");
INSERT INTO pps_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Yui sen jian kuancheꞌe sen xranchi tjaun ndo Dio ko bakitikaon sen kain ti ngeꞌe kuetuanꞌan ndo. Méxin, xroꞌan ngisen chao xrondachro ixi jeꞌe sen chónda sen ijie̱. ");
INSERT INTO pps_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Ko xroꞌan chjan kuachónda sen ixi jan Elisabet kuituenꞌa jan xrochónda jan chjan, ko jeꞌe sen ó tachríi sen. ");
INSERT INTO pps_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Ko tjumeꞌe naa nchakon ndo Zacarías ko xitaana, sen ncheꞌe ixra̱ xranchi jeꞌe ndo, kuetuenꞌen sen tsajon sen juasie sen ngajin ndo Dio. ");
INSERT INTO pps_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Xranchi kuancheꞌe xitaana nchakon meꞌe, ndo Zacarías kuayéꞌe ndo ixra̱ tixinꞌin ndo ngaxinꞌin nchia tjúá ndoꞌa ndo Dio ixi tsjaaka ndo tsjoxraxé. ");
INSERT INTO pps_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Nchakon juaaka ndo tsjoxraxé ngaxinꞌin ndoꞌa ndo Dio, kain ni ste nduja nichjeꞌe na̱ ndo Dio. ");
INSERT INTO pps_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Ko tuinxin ndo Zacarías bikon ndo naa ndo ángel xruanꞌan ndo Dio ko siin ndo ángel nangoxin jian tjenka altar ti iche tsjoxraxé. ");
INSERT INTO pps_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Hora bikon ndo Zacarías ndo ángel meꞌe, jeꞌe ndo chrinkaxrakon ndo. ");
INSERT INTO pps_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Ko ndo ángel nichja ndo ko ndachro ndo: ―Zacarías xrakonꞌa, ixi ndo Dio kuinꞌen ndo ngeꞌe juanchia, méxin, janchriꞌa Elisabet sinchejongíꞌe jan naa xjan xi ko jaꞌa sinchekiꞌian xjan Juan. ");
INSERT INTO pps_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Ko jaꞌa xrochónda juaxruxin ko kueya na̱ xrochéꞌe na̱ ixi tsjongíꞌe xjan meꞌe. ");
INSERT INTO pps_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Ko chjanꞌan ijié tsakeꞌe xjan ngajinxin ndo Dio. Ko xroꞌan vino ko ninaa xran tsiꞌa xjan, ko tsango xrochónda xjan Espíritue ndo Dio ti xrajiyá xjan ngaya tse̱ꞌe̱ janée xjan. ");
INSERT INTO pps_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Ko jeꞌe xjan sinchekuenꞌen xjan ni tjajna Israel, ko kueya na̱ xrokjan na̱ tsitikaon na̱ ndo Dio. ");
INSERT INTO pps_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Jeꞌe ndo Juan tsitaon ndo tsjendueꞌe ndo chaꞌo tsi̱ꞌxi̱n Ncháina, ko xrochónda ndo xrajeꞌo juachaxin xranchi kuachónda ndo profeta Elías, ko xronichjeꞌe ndo aséen ndotée ichjan tsoñaoꞌa na̱ ngajin chjenꞌen na̱, ko kain ni titikaonꞌa ndo Dio tsonoꞌe na̱ xranchi tsitikaon na̱ ndo ko jian sincheꞌe na̱ ixi tsi̱i̱ Ncháina Cristo. ");
INSERT INTO pps_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Ko jeꞌe ndo Zacarías juanchangiꞌe ndo ndo ángel ko ndachro ndo: ―¿Xranchi tsonóna ixi tsonꞌen ti ndachronta? Ixi janꞌan ó tsango tachríina ko kaxon janchriꞌna ó nachríi jan. ");
INSERT INTO pps_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Ko jeꞌe ndo ángel juatingíexin ndo: ―Janꞌan Gabrielna, ko ntaꞌa kain ngeꞌe tetuanꞌan ndo Dio. Ko kuetuanna ndo tsjiꞌi ko xrontatjua ngeꞌe jian tsonꞌen. ");
INSERT INTO pps_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Ko ixi kuitikaonꞌa ti ndachrja̱n, méxin, tsonosian ko juaꞌi xronichja xroxetjaja nchakon tsonꞌen meꞌe. ");
INSERT INTO pps_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Ko kain ni stechónꞌen nduja ndoꞌa ndo Dio ixi tsachrje ndo Zacarías, stexraxaon na̱ sonda jitonchrjenꞌen ndo ngaxinꞌin ndoꞌa ndo Dio. ");
INSERT INTO pps_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Ko hora kuachrje ndo, í juaꞌi nichja ndo. Ko xraxaon na̱ ixi xrojan ngeꞌe bikon ndo Zacarías ngaxinꞌin ndoꞌa ndo Dio. Ko jeꞌe ndo ixi jeꞌo itja ndo tjakoxin ndo ngeꞌe tjaun ndo ixi nosin ndo. ");
INSERT INTO pps_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Ko juexin xetja nchakon juincheꞌe ndo Zacarías ixra̱ ngaxinꞌin ndoꞌa ndo Dio, sakjui ndo ndoꞌe ndo. ");
INSERT INTO pps_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Ko tjumeꞌe jan Elisabet, janchriꞌe ndo Zacarías, yaa jan chjan. Ko íkuachrjexinꞌa jan ndoꞌe jan naꞌó nchanitjao, ko jixraxaon jan: ");
INSERT INTO pps_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Jaña ndo Dio kuajon ndo juachaxin ixi xrochónda chjan ko ítsjanoaꞌina na̱ jai.” ");
INSERT INTO pps_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Kuatsinga ikjaon nchanitjao ko ndo Dio xruanꞌan ndo ndo ángel Gabriel itsji ndo naa tjajnée tjajna Galilea ndatinꞌin Nazaret ");
INSERT INTO pps_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","*ixi ntiꞌa xronichjeꞌe ndo naa nchrichajan ndatinꞌin María ko jeꞌe nchrichan xrachuxinꞌa nchrichan ninaa xi. Jeꞌe nchrichan tsijateꞌe nchrichan tsuteꞌe nchrichan naa xi ndatinꞌin José, kuachrjenixin xa ndo rey David. ");
INSERT INTO pps_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Ko ndo ángel meꞌe kuixinꞌin ndo ndoꞌa jan María, ko ndachro ndo: ―¡Janꞌan juiꞌi tjáꞌanta juajna ixi ndo Dio ícha tjuaꞌanta ndo ko Ncháina Dio jii ngajinnta, ícha juintanchaonnta ndo ixi ikaxin nchri! ");
INSERT INTO pps_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Ko xronka jeꞌe nchrichajan ko íkuienxinꞌa nchrichan ngeꞌe juajna kuajon ndo ángel. ");
INSERT INTO pps_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Ko jeꞌe ndo ángel ndachro ndo: ―María, xrakonꞌanta, ixi ndo Dio ícha tjuaꞌanta ndo. ");
INSERT INTO pps_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","*Ko jai tseyá naa chjan ngaya tseenta ko sinchejongíꞌenta naa xjan xi ko sinchekinꞌinnta xjan Jesús. ");
INSERT INTO pps_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Ko jeꞌe xjan tsango tsetuanꞌan xjan, ko tsinꞌin xjan chjenꞌen ndo Dio jii ngajní. Ko jeꞌe Ncháina ndo Dio xrochjée xjan juachaxin tsetuanꞌan xjan xranchi baketuanꞌan ndotáchriꞌe xjan xranchrjen, ndo David. ");
INSERT INTO pps_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Ko jeꞌe xjan tsetuanꞌan xjan tjajna Israel kain nchakon ko ti tsetuanꞌan xjan ítsjexinꞌa. ");
INSERT INTO pps_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Ko jan María juanchangiꞌe jan ndo ángel, ndachro jan: ―¿Xranchi tsonꞌen jiꞌi, ixi janꞌan rikianꞌi xi? ");
INSERT INTO pps_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Ko juatingíexin ndo ángel, ndachro ndo: ―Espíritue ndo Dio tsi̱i̱ ngajinnta ko juachaxien ndo sinchekitsáanta ndo xranchi naa tsaꞌon. Ko xjan tsjongíꞌe xrochóndaꞌi xjan ijie̱, ko ndatsinꞌin xjan chjenꞌen ndo Dio. ");
INSERT INTO pps_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Ko kaxon jan kichuunta Elisabet yaa jan chjan maski ó nachríi jan. Ko jai, nchri bandachro na̱ juaꞌi xrochónda chjan, jai ó ikjaon nchanitjao yaa jan xjan. ");
INSERT INTO pps_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Méxin juachaxien ndo Dio, chao tsonꞌen kain ngeꞌe. ");
INSERT INTO pps_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Ko ndachro jan María: ―Janꞌan ntaꞌa xrée Nchána Dio; méxin janꞌan tsitikaꞌon kain ngeꞌe kuetuanna ndo xranchi jaꞌanta ndachronta. Ko juexin nichja ndo ángel, sakjui ndo. ");
INSERT INTO pps_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Kaxon nchakon meꞌe, jan María nteeto sakjui jan naa tjajna ngataꞌa ijna̱ nunte Judea. ");
INSERT INTO pps_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Ko kuiji jan tjajna ntiꞌa kuixinꞌin jan ndoꞌa ndo Zacarías ko jan Elisabet ko kuajon jan juajna ngajin jan Elisabet. ");
INSERT INTO pps_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Hora kuinꞌen jan Elisabet juajna, xjan yaa jan chrinka xjan ngaya tse̱ꞌe̱ jan, ko jeꞌe jan Elisabet tsango kuayéꞌe jan juachaxien Espíritue ndo Dio. ");
INSERT INTO pps_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Ko tjumeꞌe jan Elisabet séen nichja jan ko ndachro jan: ―Ndo Dio juinchenchaoan ndo ícha ixi ikaxin nchri, ko kaxon juinchenchaon ndo chjanꞌan. ");
INSERT INTO pps_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","¿Ngisen janꞌan ixi juiꞌa kuitsjena jaꞌa, janée Nchána? ");
INSERT INTO pps_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Ixi hora kui̱nꞌa̱n juajnáa, chrinka chjanꞌna ngaya tse̱ꞌe̱ ixi chéꞌe xjan. ");
INSERT INTO pps_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Ijié juaxruxin chonda ixi kuitikaoan ngeꞌe tsonꞌen, xranchi ndachro ndo Dio. ");
INSERT INTO pps_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Ko tjumeꞌe jan María ndachro jan: Aséenna tajon juasaya ngajin Ndotána Dio. ");
INSERT INTO pps_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Ko juaxruxin ritjén ixi ndo Dio kuantsjena ndo ijie̱. ");
INSERT INTO pps_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Ndo Dio xraxaon ndo sincheꞌe ndo jian ngaji̱n, janꞌan naa nchri nóa ncheꞌe ixra̱ ngajin ndo. Ko jai tsaxi xrondachijina na̱ ndo Dio juinchechaoan ndo. ");
INSERT INTO pps_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Ndo Dio chónda ndo kain juachaxin, ko juincheꞌe ndo ijié ngeꞌe ngaji̱n ixi jeꞌe ndo tsango tjúá ndo. ");
INSERT INTO pps_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Ko jeꞌe ndo kain nchakon tikonóeꞌe ndo kain ni tajon juasie ngajin jeꞌe ndo. ");
INSERT INTO pps_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Jeꞌe ndo soji ndo ixi juincheꞌe ndo kain ngeꞌe ko kuantsjeꞌe ndo juachaxin chónda kain ni nchejié aséen. ");
INSERT INTO pps_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Ko kuantsjeꞌe ndo kain juachaxin chónda ni tetuanꞌan ko juinchejié ndo kain ni nóa ixi jeꞌe na̱ xrochónda na̱ juachaxin. ");
INSERT INTO pps_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Ko kuajon ndo kain ngeꞌe jian kuayéꞌe ni chóndaꞌi ko xroꞌan ngeꞌe kuajon ndo ngajin ngisen kueya chónda. ");
INSERT INTO pps_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Jeꞌe ndo bingijna ndo ni tjajna Israel, ni ncheꞌe xrée ndo; ko bikonóeꞌe ndo na̱, ");
INSERT INTO pps_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","ixi jaña ndache ndo sen tachríꞌe na̱ xranchrjen, ndo Abraham ko kain ni tsachrjenixin ndo. ");
INSERT INTO pps_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Ko jan María kuituꞌe jan ndoꞌa jan Elisabet níi nchanitjao, ko tjumeꞌe ikjan jan ndoꞌa jan. ");
INSERT INTO pps_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Ko kui̱i̱ nchakon sinchejongíꞌe jan Elisabet chjenꞌen jan, ko juinchejongíꞌe jan naa xjan xi. ");
INSERT INTO pps_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Méxin, ni ste tjenka ndoꞌa jan ko ni nchandoꞌa jan, ikjui na̱ kuitsjeꞌe na̱ jan ko kuintee na̱ juaxruxin ngajin jan ixi konoꞌe na̱ ixi ndo Dio tsango bikonóeꞌe ndo jan. ");
INSERT INTO pps_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Kuitja ijní nchakon, kui̱i̱ na̱ ixi tsayéꞌe ichjan chjiꞌe ni judío, ko tjaun na̱ xrokuinꞌin xjan Zacarías xranchi tinꞌin ndotée xjan. ");
INSERT INTO pps_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Ko ndachro janée xjan: ―Naꞌi. Xrokonda tsinꞌin xjan Juan. ");
INSERT INTO pps_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ko jeꞌe na̱ juatingíexin na̱: ―¿Sonda tsinꞌin xjan jaña? Xroꞌan sen ndúya tinꞌin na̱ jaña. ");
INSERT INTO pps_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Tjumeꞌe itja na̱ juanchangíexin na̱ ndotée xjan xranchi tjaun ndo tsinꞌin xjan. ");
INSERT INTO pps_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Ko jeꞌe ndo juanchia ndo tuꞌo nta̱a̱ ko ikjin ndo: “Jeꞌe xjan tsinꞌin xjan Juan.” Ko kain ni ste ntiꞌa xronka na̱. ");
INSERT INTO pps_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Ko tuinxin íjngo kuaxi nichja ndo Zacarías, ko kuaxi kuajon ndo juasie ndo ngajin ndo Dio. ");
INSERT INTO pps_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Kain ni ste tjenka nchandoꞌa sen xronka na̱, ko kain tjajna ngataꞌa ijna̱ Judea kuinꞌen na̱ ngeꞌe konꞌen. ");
INSERT INTO pps_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Ko kain ni kuinꞌen ngeꞌe konꞌen, xraxaon na̱ ko ndachro na̱: ―¿Ngeꞌe ixra̱ sincheꞌe ichjan ña̱? Ko nduaxin ndo Dio tsango jii ndo ngajin xjan. ");
INSERT INTO pps_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Ko ndotée xjan ndo Zacarías meꞌe ícha kuayéꞌe ndo juachaxien Espíritue ndo Dio ko nichja ndo chijnie ndo Dio ko ndachro ndo: ");
INSERT INTO pps_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Juasie Ndotáina Dio titikaon ni tjajna Israel ixi jeꞌe ndo kui̱i̱ ndo tsingijna ndo tjajnée ndo. ");
INSERT INTO pps_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Ko jeꞌe ndo xruanꞌan ndo ngisen ícha soji tsingijna tsachrjengíexin ijie̱ chónda chujni, naa sen kuachrjenixin ndo David, ngisen juincheꞌe ixra̱ ngajin ndo Dio. ");
INSERT INTO pps_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Jaña nichja ndo Dio nichjaxin ndo sen chronga chijnie ndo Dio ó saꞌó ");
INSERT INTO pps_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","ndache ndo sen ixi tsingijna ndo tsantsjeꞌe ndo juachaxin kain ni ningakoi̱na. ");
INSERT INTO pps_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Ko tsikonóeꞌe ndo sen tachríꞌina kuintee saꞌó, ko xraxaon ndo ti juao ndo sen tjajnée ndo ó saꞌó. ");
INSERT INTO pps_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Ko jiꞌi tsindache ndo Dio ndo tachríꞌina xranchrjen, ndo Abraham ");
INSERT INTO pps_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","ixi tsingijnana ndo ixi tsituaꞌi xi ningakoi̱na, ko chao sincheꞌena ixra̱ ngajin ndo Dio ko xroxrakonꞌana, ");
INSERT INTO pps_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","ixi ícha tjúá tsakeꞌe aséei̱na ko jian tsitikaonna chijnie ndo Dio, ko tsojuna ngajin ndo Dio kain nchakon. ");
INSERT INTO pps_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Ko jaꞌa, chjanꞌna, jaꞌa xrokjan naa ngisen xronichja chijnie ndo Dio jii noi, ko jaꞌa saꞌó tsitaonꞌen Ncháina, ko jaꞌa sinchenataonxian chaoé ndo, ");
INSERT INTO pps_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","ixi tsonoꞌe ni tjajnée ndo ixi sincheméꞌe ndo kain ijie̱ chónda na̱ ko tsajon ndo juachaxin tsitjáñaꞌi na̱. ");
INSERT INTO pps_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Ixi jeꞌe Ndotáina Dio tsango tjaunna ndo ko tsango tikonóaꞌina ndo, ko jeꞌe ndo tsajon ndo xroꞌi tsingasáñai̱na kain nchakon, ");
INSERT INTO pps_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","ko tsajon ndo xroꞌi tsingasáñaxin kain ni jii ti tsango naxixeꞌe. Ko jeꞌe ndo tsakeꞌe ndo tutéi̱na ngataꞌa chaꞌo tajon juaxruxin. ");
INSERT INTO pps_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Ko jeꞌe xjan bangi xjan ko konsoji aséen xjan. Ko bakeꞌe xjan ngataon ijngi ti xroꞌan ngisen ste, xetjaja nchakon konoxin xjan ngajin ni tjajna Israel. ");
INSERT INTO pps_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Nchakon meꞌe bakeꞌe naa xi ícha baketuanꞌan ko bakinꞌin xa Augusto César, ko jeꞌe xa kuetuanꞌan xa ixi tsixintaxin kain na̱ ixi tsonoꞌe xa ngijanꞌin chujni chónda kain tjajna. ");
INSERT INTO pps_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Méxin, ti saꞌó kuixintaxin chujni xi Cirenio baketuanꞌan xa nunte Siria. ");
INSERT INTO pps_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Ko kuetuenꞌen na̱ kain na̱ satsji na̱ tjajna tikinixinꞌen na̱ ixi ntiꞌa tsixintaxin na̱. ");
INSERT INTO pps_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Méxin, ndo José kuachrjexin ndo tjajna Nazaret tikinixinꞌen Galilea, ko sakjui ndo tjajna Belén nunte Judea ti tsijongíexin ndo David, ixi ndo José kuachrjenixin ndo ndo tachríꞌe ndo xranchrjen, ndo David. ");
INSERT INTO pps_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Méxin sakjui ndo José tjajna Belén, jeꞌe ndo ko janchriꞌe ndo jan María. Ko jeꞌe jan María ó yaa jan ichjan. ");
INSERT INTO pps_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Ko nchakon jii sen tjajna Belén, kuitja nchakon tsjongíꞌe chjenꞌen jan María. ");
INSERT INTO pps_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Ko ntiꞌa kuixinꞌin sen naa nchia ti tejua iko ixi kuitjaꞌi sen nchia no tsituꞌe sen. Méxin, ntiꞌa jongíexin chjenꞌen jan María, xjan saꞌó, ko jeꞌe jan kuintsía jan xjan manta ko ba̱ke̱ꞌe̱ jan xjan ngaya ti nexin iko. ");
INSERT INTO pps_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Tiie meꞌe tjenka tjajna Belén kaxin na̱ stendáa na̱ kutuchjoen na̱ ngataon ijngi. ");
INSERT INTO pps_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Meꞌe tuinxin konoxin naa ndo ángel xruanꞌan ndo Dio, ko bikaꞌo ndo chjiixrué ndo Dio juinchengasáña nguixin ngandajin na̱; ko jeꞌe na̱ tsango xronka na̱. ");
INSERT INTO pps_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Ko jeꞌe ndo ángel ndache ndo na̱: ―Xrakonꞌanta ixi janꞌan bikian juajna jian, méxin, xrochondanta juaxruxin ko kain ni tjajna kaxon. ");
INSERT INTO pps_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Tjajnée ndo David jai jongíexin naa chjan, xjan meꞌe sincheméꞌe xjan kain ijie̱ chónda chujni, ko jeꞌe xjan Ncháina Cristo. ");
INSERT INTO pps_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Itjinta tjajna, ntiꞌa tsinchíinta xjan jitsjía xjan manta ko jii xjan ti no nexin iko. ");
INSERT INTO pps_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Xrajíi ndo ángel, tuinxin konoxin ícha kueya sen ángel kui̱xi̱n sen ngajní, ko itsje̱ sen ko kuajon sen juasaya ngajin ndo Dio jii ngajní, ko ndachro sen: ");
INSERT INTO pps_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","¡Juasie ndo Dio jii ngajní ixi tsango chónda ndo juachaxin! Ko juaxruxin tsintee kain ni ste ngataꞌa nunte, kain ni titikaon ndo. ");
INSERT INTO pps_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Ko tjumeꞌe kain sen ángel sakjui sen ngajní, ko ni stetsjeꞌe kutuchjoen ndache kichuu na̱: ―Ichjina tjajna Belén, tsitsjeꞌena ngeꞌe konꞌen ntiꞌa xranchi ndachro ndo ángel xruanꞌan ndo Dio. ");
INSERT INTO pps_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Ko nteeto sakjui na̱ bikitsjeꞌe na̱ jan María ko ndo José, ko ichjan jii xjan ti tejua iko. ");
INSERT INTO pps_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Hora bikon na̱ xjan, beki na̱ kain ti ndachro ndo ángel kondee jeꞌe xjan ");
INSERT INTO pps_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","ko tsango xronka kain chujni kuinꞌen ti ndachro na̱. ");
INSERT INTO pps_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Ko jeꞌe jan María jixraxaon jan ngaya aséen jan kain ngeꞌe konꞌen. ");
INSERT INTO pps_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Ni stetsjeꞌe kutuchjoen ikjan na̱ ti kuintuꞌe na̱ kuée na̱, ko kuajon na̱ juasaya ngajin ndo Dio ixi kain ngeꞌe kuinꞌen na̱ ko bikon na̱, kain ngeꞌe konꞌen xranchi ndachro ndo ángel. ");
INSERT INTO pps_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","*Nchakon kuitja xjan Jesús ijní nchakon, chjée sen xjan chjiꞌe ni tjajnée xjan ko juinchekinꞌin sen xjan Jesús, xranchi kuetuanꞌan ndo ángel ngajin jan María nchakon xrayáꞌi jan xjan. ");
INSERT INTO pps_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Kuitja nchakon chao jii jan María xranchi tsiketuanꞌan ley tsikjin ndo Moisés, ko tjumeꞌe jeꞌe jan ko ndo José sabikao sen xjan tjajna Jerusalén ixi ndo Dio sinchenchaon ndo xjan. ");
INSERT INTO pps_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Ko jaña juincheꞌe sen xranchi jitaxin xroon kuituanꞌan ndo Dio: “Kain xjan xi, xjan kóña saꞌó, tikinixinꞌen xjan ndo Dio.” ");
INSERT INTO pps_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Méxin, jan María ko ndo José sakjui sen ndoꞌa ndo Dio ixi bikao sen iko tsenꞌen ntiꞌa xranchi jitaxin xroon tsituanꞌan ndo Dio tsonꞌen, méxin xrokuajon sen yuu kuntúá najni o̱ yuu kuxenta. ");
INSERT INTO pps_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Nchakon meꞌe tjajna Jerusalén bakeꞌe naa ndo tachríi ndatinꞌin Simeón. Jeꞌe ndo tsango jian ndo, ko bakajon ndo juasaya ngajin ndo Dio, ko chónꞌen ndo xroxruanꞌan ndo Dio ngisen tsingijna tjajna Israel. Méxin Espíritue ndo Dio jii ngajin ndo Simeón ");
INSERT INTO pps_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","ko Espíritue ndo Dio juinchenoꞌe ndo Simeón ixi xratsenꞌa ndo tsikonja ndo ndo Cristo, ndo xroxruanꞌan ndo Dio. ");
INSERT INTO pps_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Ko tjumeꞌe Espíritue ndo Dio juinchexraxaon ndo Simeón xrokjui ndo ndoꞌa ndo Dio. Ko nchakon meꞌe kui̱i̱ jan María ko ndo José bikao sen xjan Jesús ngaxinꞌin ndoꞌa ndo Dio ixi kuitikaon sen xranchi tsiketuanꞌan ley. ");
INSERT INTO pps_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Ko tjumeꞌe ndo Simeón joa ndo xjan Jesús ko kuajon ndo juasaya ngajin ndo Dio ko ndachro ndo: ");
INSERT INTO pps_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Jai, Ncháina, ó kuitja ti ndachronta. Jai chao tájonnta juachaxin juaxruxin tsenꞌen na̱, ");
INSERT INTO pps_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","ixi ó bikon ngisen kui̱i̱ tsantsje kain ijie̱ chondana, ");
INSERT INTO pps_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","ko jaꞌanta tsixruanꞌannta xjan ko kain tjajna tsichuxin na̱ xjan. ");
INSERT INTO pps_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Jeꞌe xjan xroꞌi tsingasáña ngajin kain tjajna, ni jeꞌa tjajna Israel, ko tsajon na̱ juasaya ngajin tjajnánta Israel ixi ntiꞌa konoxin xjan Jesús. ");
INSERT INTO pps_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Ko ndo José ko jan María, janée xjan Jesús, xronka sen ixi jaña ndachro ndo Simeón xranchi sincheꞌe xjan Jesús. ");
INSERT INTO pps_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Ko tjumeꞌe ndo Simeón juinchenchaon ndo sen ko nichjeꞌe ndo jan María, janée xjan ko ndachro ndo: ―Chjanꞌan meꞌe tsikaꞌo itsjé ngeꞌe tangi tsikonni. Méxin, kueya ni tjajna Israel, kaxin na̱ tsitikaonꞌa na̱ ko ikaxin na̱ tsitikaon na̱ chijnie xjan ko jian tsakeꞌe na̱. ");
INSERT INTO pps_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Ko jaña tsonoxin xranchi xraxaon ngujngu aséen na̱. Ko kain ngeꞌe tsonꞌen sintaniꞌa xranchi naa chika yao tsatsingatuꞌu asáan jaꞌa, María. ");
INSERT INTO pps_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Ko kaxon ntiꞌa bakeꞌe naa janachri profeta, nichja jan chijnie ndo Dio ko ndatinꞌin jan Ana. Ndotée jan bakinꞌin ndo Fanuel, ko jeꞌe ndo, ndo tachríꞌe ndo xranchrjen, ndo Aser. Jeꞌe jan Ana ó tsango nachríi jan, ko xranchrichájan jan tsikuteꞌe jan ko bekao jan ndoxiꞌe jan jeꞌo ya̱a̱to̱ nano. ");
INSERT INTO pps_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Ko jai ó kaꞌan jan ko noókán ko noó nano chónda jan. Ko tachrjexinꞌa jan niꞌngo ndoꞌa ndo Dio; ko ndiꞌao bakeꞌe jan tiie ko nchakon bakajon jan juasaya ngajin ndo Dio; ko kaxin nchakon bajineꞌa jan ixi nichjeꞌe jan ndo Dio. ");
INSERT INTO pps_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Ko nchakon meꞌe jan Ana konchjiñeꞌe jan ko juangíxin jan kuajon jan juasie jan ngajin ndo Dio, ko kuaxi jan nichja jan ixi xjan Jesús, nichjeꞌe jan kain ni stechónꞌen nchakon xroxruanꞌan ndo Dio ngisen tsingijna ni tjajna Jerusalén. ");
INSERT INTO pps_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","*Nchakon juexin juincheꞌe jan María ko ndo José kain ngeꞌe ndachro chijnie ndo Dio, ikjan sen tjajnée sen Nazaret, nunte Galilea. ");
INSERT INTO pps_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Ko xjan Jesús ícha bangi xjan, ko ícha konsoji xjan, ko ícha noꞌe xjan jian kain ngeꞌe ixi ndo Dio bakajon ndo juachaxin ngajin xjan. ");
INSERT INTO pps_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Ndo José ko jan María, janée xjan Jesús, bakji sen tjajna Jerusalén kain nano ixi tsakeꞌe sen ntiꞌa ti kia pascua. ");
INSERT INTO pps_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Ko nchakon kuitja xjan Jesús teyuu nano, jeꞌe sen ko jeꞌe xjan sakjui sen tjajna Jerusalén xranchi kuituenꞌen sen ixi kia pascua. ");
INSERT INTO pps_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Nchakon juexin kia pascua, kua sen chaꞌo itji tjajnée sen. Ko xjan Jesús tsikituꞌe xjan ntiꞌa tjajna Jerusalén, ko ndo José ko jan María, janée xjan, konoeꞌa sen tsikituꞌe xjan. ");
INSERT INTO pps_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Jeꞌe sen xraxaon sen ixi xjan Jesús jitji xjan ngakjenꞌen sen kaxin, ko sakjui sen nchijíi naa nchakon. Ko tjumeꞌe juée sen xjan ngajin ni kichuu sen ko ni chúxin sen. ");
INSERT INTO pps_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Ko kuitjaꞌi sen xjan, méxin ikjan sen tjajna Jerusalén ko juée sen xjan ntiꞌa. ");
INSERT INTO pps_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Ko nchakon nínxin kuitja sen xjan ngaxinꞌin niꞌngo ndoꞌa ndo Dio. Ntiꞌa jii xjan nunte ngusine kain sen tjako chijnie ndo Dio ko jitinꞌen xjan ti ndachro sen, ko jitjanchiangíꞌe xjan sen. ");
INSERT INTO pps_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Ko kain chujni jitinꞌen ti ndachro xjan, xronka na̱ ixi tsango jian noꞌe xjan ko jian tjateꞌe xjan kain ngeꞌe tjanchangíꞌe sen xjan. ");
INSERT INTO pps_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Ko xronka ndo José ko janée xjan hora bikon sen ti jii xjan ngusine sen noꞌe. Ko janée xjan ndachro jan: ―Chjanꞌna, ¿sonda jaña juincheꞌe? Ndotáa ko janꞌan yaana juachjaon chrjitjéena jaꞌa. ");
INSERT INTO pps_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Ko juatingíexin xjan Jesús: ―¿Sonda tjéeninta? ¿Á noaꞌinta ixi janꞌan xrokonda sintaꞌa xrée Ndotána? ");
INSERT INTO pps_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Ko jeꞌe sen kuienxinꞌa sen ngeꞌe ndachro xjan. ");
INSERT INTO pps_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Ko tjumeꞌe sabikao sen xjan Jesús tjajnée sen, tjajna Nazaret, ko xjan Jesús bakitikaon xjan sen. Ko jan María, janée xjan, ngaya aséen jan xraxaon jan kain ngeꞌe konꞌen. ");
INSERT INTO pps_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Ko ícha bangi xjan ko ícha konoꞌe xjan, ko ijié juachaxin kuajon ndo Dio ngajin xjan, ko kain na̱ tsango tjueꞌe na̱ xjan. ");
INSERT INTO pps_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Ó chónda tenaꞌó nano baketuanꞌan xi Tiberio César, ko xi Poncio Pilato baketuanꞌan xa nunte Judea, ko xi Herodes baketuanꞌan xa nunte Galilea, ko xi kichuu xi Herodes ndatinꞌin Felipe baketuanꞌan xa nunte Iturea ko nunte Traconite, ko xi Lisanias baketuanꞌan xa nunte Abilinia. ");
INSERT INTO pps_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Ko xi Anás ko xi Caifás xitaana ícha tetuanꞌan. Nchakon meꞌe ndo Dio, nichjeꞌe ndo ndo Juan, chjenꞌen ndo Zacarías, xjan bakeꞌe ntajie. ");
INSERT INTO pps_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Ko ndo Juan ikjui ndo kain tjajna ngandeꞌe inda jitinga ndatinꞌin Jordán ko ndache ndo kain na̱ ixi xrokonda tsintuꞌe na̱ ti ndakoꞌa ncheꞌe na̱ ko tsikitée na̱ ixi ndo Dio jaña sincheméꞌe ndo kain ijie̱ chónda na̱. ");
INSERT INTO pps_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Jaña jitaxin xroon tsikjin ndo profeta Isaías ndachro: Naa tée sen nichja ntajie tuyako ko ndachro: “Nchekonchjiannta chaꞌo tsaji Ncháina, tantjeꞌenta naa chaꞌo nao itji. ");
INSERT INTO pps_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Ko kain tsaaka tsingachjian inche, ko kain jna̱ ko kain ngandeꞌe jna̱, jian tsonataunxin; ko kain chaꞌo nango itji, xroxendueꞌe chaꞌo ko kain chaꞌo nataonxinꞌa, tsonataunxin chaꞌo. ");
INSERT INTO pps_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Méxin, kain ni ste ngataꞌa nunte ntiꞌi tsonoꞌe na̱ ngisen xruanꞌan ndo Dio, tsantsje ndo ijie̱ chónda chujni.” ");
INSERT INTO pps_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","*Nchakon meꞌe kueya na̱ bakonchjiñeꞌe na̱ ixi ndo Juan tsikitée ndo na̱, ko jeꞌe ndo ndache ndo na̱: ―¡Jaꞌanta tsikachrjenixinnta kunchee! ¿Ngisen ntatjunta satsingeꞌenta juañaue ndo Dio ti ó tuinxin tsi̱i̱? ");
INSERT INTO pps_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","*Xrokonda tsindoxinnta ti ndakoꞌa ncheꞌenta ko jian titikaonnta ti tetuanꞌan ndo Dio. Ko Ndachroꞌanta: “Janꞌanna ícha jianna ixi kuachrjenixinna ndo Abraham.” Ko janꞌan nduaxin ntatjunta ixi ndo Dio chao sinchéña ndo ixro jiꞌi xrokjan xjantié ndo Abraham. ");
INSERT INTO pps_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","*Méxin, ó jichónꞌen chika jacha xrochrijinxin nta̱a̱, nueꞌe nta̱a̱ xrochrijinxin nta̱a̱. Méxin kain nta̱a̱ tajonꞌa itu cháña tsjánka na̱ nta̱a̱ ko tsaa nta̱a̱ xroꞌi. ");
INSERT INTO pps_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Ko tjumeꞌe juanchangiꞌe na̱ ndo Juan ko ndachro na̱: ―¿Ngeꞌe xrokonda sintaꞌana? ");
INSERT INTO pps_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Ko juatingíexin ndo Juan ko ndachro ndo: ―Ngisen chónda yuu manta xrochjée sen naa manta ni xroꞌan ngeꞌe chónda. Ko ngisen chónda ngeꞌe sine xrochjée sen ni chóndaꞌi. ");
INSERT INTO pps_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","*Ko konchjiñeꞌe kaxin ni xengeꞌe iꞌna̱ tomi tjanchia xi tetuanꞌan ko kaxon tjaun na̱ tsikitée na̱, méxin, juanchangiꞌe na̱ ndo Juan: ―Maestro, ¿ngeꞌe xrokonda sintaꞌana janꞌanna? ");
INSERT INTO pps_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ko jeꞌe ndo ndachro ndo: ―Jeꞌo tjanchianta ti nduaxin sínká na̱. ");
INSERT INTO pps_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Ko kaxon kaxin xisoldado juanchangiꞌe xa ndo Juan: ―Kaxon janꞌanna, ¿ngeꞌe sintaꞌana? Ko jeꞌe ndo juatingíexin ndo: ―Tantsjeꞌanta chujni ngeꞌe chónda na̱, ko nchexronkaꞌinta na̱ ixi ngeꞌe juincheꞌa na̱, ko takeꞌénta juaxruxin ixi jeꞌo tomi tjachanta. ");
INSERT INTO pps_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Kain ni ste ntiꞌa tjao na̱ ixi jeꞌe ndo Juan á ndo Cristo ndo. ");
INSERT INTO pps_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Ko ndo Juan ndache ndo kain na̱: ―Janꞌan nduaxin ntatjunta ixi janꞌan tikitéxinnta inda, ko tsi̱i̱ naa ngisen tsikitéxinnta ndo ixi Espíritue ndo Dio ko xroꞌi. Ko jeꞌe ndo ícha ijié juachaxin chónda ndo ixi juachaxin chonda janꞌan. Janꞌan tikinixinnaꞌi tsoxindangaꞌa tjuée katée ndo. ");
INSERT INTO pps_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ko jeꞌe ndo ó bikaꞌo ndo naa kachrintu ixi tsjenduaxin ndo noatrigo ixi tsachrjekjeꞌen xineno. Tsjatsiꞌin ndo kain noatrigo ti tikinixin tsjiꞌin no, ko kain xineno tsjánka ndo ti xroꞌi juaꞌi tsanga. ");
INSERT INTO pps_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Jaña ndachro ndo Juan ko ndache ndo na̱ ikaxin ngeꞌe ko chronga ndo chijni jian. ");
INSERT INTO pps_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","*Ko kaxon kuyakutee ndo Juan xi Herodes, xi tetuanꞌan, ixi jikao xa nchri Herodías, nchrinchriꞌe xikichuu xa, xi ndatinꞌin Felipe, ko kaxon ndo Juan koñao ndo ngajin xi Herodes ixi ícha ngeꞌe ndakoꞌa juincheꞌe xa. ");
INSERT INTO pps_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Ko xi Herodes kuitikaonꞌa xa, ko ícha chinga juincheꞌe xa ko kaxon bijeꞌe xa ndo Juan ndoꞌachjiso. ");
INSERT INTO pps_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Ko nchakon xrajitikitée ndo Juan kueya na̱, kaxon kui̱i̱ ndo Jesús bikitée ndo. Ko hora jinichja ndo Jesús ngajin ndo Dio xitjeꞌe̱ ngajní ");
INSERT INTO pps_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","*ko Espíritue ndo Dio xingajin xranchi naa kuntúá ko bakeꞌe ba ngataꞌa jaa ndo Jesús ko kuinꞌenni nichja naa ngisen jii ngajní ndachro: ―Jaꞌa chjanꞌna ko tsango tjuaꞌa. Ko janꞌan ritjén juaxruxin ngajian. ");
INSERT INTO pps_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Ndo Jesús kuachónda ndo xranchi ikánte nano nchakon ti juangíxin ndo xrée ndo. Ko kain na̱ xraxaon na̱ ixi jeꞌe ndo Jesús chjenꞌen ndo José. Ko ndo José chjenꞌen ndo Elí, ");
INSERT INTO pps_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","ko ndo Elí chjenꞌen ndo Matat, ko ndo Matat chjenꞌen ndo Leví, ko ndo Leví chjenꞌen ndo Melqui, ko ndo Melqui chjenꞌen ndo Jana, ko ndo Jana chjenꞌen ndo José. ");
INSERT INTO pps_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Ko ndo José chjenꞌen ndo Matatías, ko ndo Matatías chjenꞌen ndo Amós, ko ndo Amós chjenꞌen ndo Nahum, ko ndo Nahum chjenꞌen ndo Esli, ko ndo Esli chjenꞌen ndo Nagai, ");
INSERT INTO pps_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","ko ndo Nagai chjenꞌen ndo Maat, ko ndo Maat chjenꞌen ndo Matatías, ko ndo Matatías chjenꞌen ndo Semei, ko ndo Semei chjenꞌen ndo José, ko ndo José chjenꞌen ndo Judá. ");
INSERT INTO pps_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Ko ndo Judá chjenꞌen ndo Juana, ko ndo Juana chjenꞌen ndo Resa, ko ndo Resa chjenꞌen ndo Zorobabel, ko ndo Zorobabel chjenꞌen ndo Salatiel, ko ndo Salatiel chjenꞌen ndo Neri. ");
INSERT INTO pps_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Ko ndo Neri chjenꞌen ndo Melqui, ko ndo Melqui chjenꞌen ndo Adi, ko ndo Adi chjenꞌen ndo Cosam, ko ndo Cosam chjenꞌen ndo Elmodam, ko ndo Elmodam chjenꞌen ndo Er. ");
INSERT INTO pps_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Ko ndo Er chjenꞌen ndo Josué, ko ndo Josué chjenꞌen ndo Eliezer, ko ndo Eliezer chjenꞌen ndo Jorim, ko ndo Jorim chjenꞌen ndo Matat. ");
INSERT INTO pps_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Ndo Matat chjenꞌen ndo Leví, ko ndo Leví chjenꞌen ndo Simeón, ko ndo Simeón chjenꞌen ndo Judá, ko ndo Judá chjenꞌen ndo José, ko ndo José chjenꞌen ndo Jonán, ko ndo Jonán chjenꞌen ndo Eliaquim. ");
INSERT INTO pps_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Ndo Eliaquim chjenꞌen ndo Melea, ko ndo Melea chjenꞌen ndo Mainán, ko ndo Mainán chjenꞌen ndo Matata, ko ndo Matata chjenꞌen ndo Natán. ");
INSERT INTO pps_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Ndo Natán chjenꞌen ndo David, ko ndo David chjenꞌen ndo Isaí, ko ndo Isaí chjenꞌen ndo Obed, ko ndo Obed chjenꞌen ndo Booz, ko ndo Booz chjenꞌen ndo Salmón, ko ndo Salmón chjenꞌen ndo Naasón. ");
INSERT INTO pps_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Ndo Naasón chjenꞌen ndo Aminadab, ko ndo Aminadab chjenꞌen ndo Aram, ko ndo Aram chjenꞌen ndo Esrom, ko ndo Esrom chjenꞌen ndo Fares, ko ndo Fares chjenꞌen ndo Judá. ");
INSERT INTO pps_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Ko ndo Judá chjenꞌen ndo Jacob, ko ndo Jacob chjenꞌen ndo Isaac, ko ndo Isaac chjenꞌen ndo Abraham, ko ndo Abraham chjenꞌen ndo Taré, ko ndo Taré chjenꞌen ndo Nacor. ");
INSERT INTO pps_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Ndo Nacor chjenꞌen ndo Serug, ko ndo Serug chjenꞌen ndo Ragao, ko ndo Ragao chjenꞌen ndo Peleg, ko ndotée ndo Peleg meꞌe ndo Heber, ko ndo Heber chjenꞌen ndo Sala. ");
INSERT INTO pps_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Ndo Sala chjenꞌen ndo Cainán, ko ndo Cainán chjenꞌen ndo Arfaxad, ko ndo Arfaxad chjenꞌen ndo Sem, ko ndo Sem chjenꞌen ndo Noé, ko ndo Noé chjenꞌen ndo Lamec. ");
INSERT INTO pps_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Ndo Lamec chjenꞌen ndo Matusalén, ko ndo Matusalén chjenꞌen ndo Enoc, ko ndo Enoc chjenꞌen ndo Jared, ko ndo Jared chjenꞌen ndo Mahalaleel, ko ndo Mahalaleel chjenꞌen ndo Cainán. ");
INSERT INTO pps_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Ndo Cainán chjenꞌen ndo Enós, ko ndo Enós chjenꞌen ndo Set, ko ndo Set chjenꞌen ndo Adán, ko ndo Adán chjenꞌen ndo Dio. ");
INSERT INTO pps_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Ndo Jesús tsango chónda ndo juachaxien Espíritue ndo Dio, ko tjumeꞌe kjanxin ndo ti jii inda jitinga ndatinꞌin Jordán. Ko Espíritue ndo Dio bikao ndo ntajie. ");
INSERT INTO pps_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Ntiꞌa bakeꞌe ndo yuu ikán nchakon, ko kain nchakon meꞌe juineꞌa ndo, ko tjumeꞌe kuenꞌen ndo jinta ko Xixronꞌanxrée tjaun xa xrojuincheyeꞌe xa ndo. ");
INSERT INTO pps_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Ko jeꞌe Xixronꞌanxrée ndache xa ndo Jesús: ―Siá nduaxin jaꞌa chjenꞌen ndo Dio, ndache ixro jiꞌi xrokjan ixro nutja. ");
INSERT INTO pps_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Ko juatingíexin ndo Jesús ko ndachro ndo: ―Ndachro xroon jitaxin chijnie ndo Dio: “Jeꞌa jeꞌo nutja tsechónxin chujni. Kaxon ixi chijnie ndo Dio tsechónxin na̱.” ");
INSERT INTO pps_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Ko tjumeꞌe Xixronꞌanxrée bikao xa ndo Jesús ngataꞌa naa ijna̱ ícha nui ko juakoꞌe xa ndo kain tjajna jii ngataꞌa nunte. ");
INSERT INTO pps_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Ko ndachro Xixronꞌanxrée: ―Janꞌan xrotjáꞌa juachaxin ko kain ti tjintee chónda kain tjajna ixi janꞌan kuayáꞌa̱ kain jiꞌi, ko chao xrotjáꞌa kain jiꞌi ngajin ngisen janꞌan tjaꞌon. ");
INSERT INTO pps_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Méxin siá jaꞌa tsakeꞌexian ntatuchiꞌian ko xrochjána juasaya, kain jiꞌi tsayeꞌé. ");
INSERT INTO pps_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Ko juatingíexin ndo Jesús ko ndachro ndo: ―Tingaxintuan satjia, Xixronꞌanxrée jaꞌa. Ndachro chijnie ndo Dio: “Tsájuan juasaya ngajin Ncháa ndo Dio, ko jeꞌo ngajin jeꞌe ndo sincheꞌé ixra̱.” ");
INSERT INTO pps_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Ko tjumeꞌe Xixronꞌanxrée bikao xa ndo Jesús tjajna Jerusalén, ko juinchekajinꞌin xa ndo ti ícha nui ngataꞌa niꞌngo ko ndachro xa: ―Siá nduaxin jaꞌa chjenꞌen ndo Dio, chrinka ti nunte; ");
INSERT INTO pps_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","ixi ndachro chijnie ndo Dio: Ndo Dio tsetuenꞌen ndo sen ángel ixi xrotsengia sen, ");
INSERT INTO pps_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","ko ngaya itja sen tsakeꞌe, ixi tsontengíxinꞌa tutáa ixro. ");
INSERT INTO pps_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Ko ndo Jesús juatingíexin ndo ndachro ndo: ―Kaxon ndachro chijnie ndo Dio: “Tsakéꞌa naa ngeꞌe ixi tsikuan á chao sincheꞌe ndo.” ");
INSERT INTO pps_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Ko Xixronꞌanxrée juaꞌi juincheyeꞌe xa ndo Jesús, ko jeꞌe xa sajuixin xa ti ndo Jesús kaxin nchakon. ");
INSERT INTO pps_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Ko tjumeꞌe Ndo Jesús ikjan ndo nunte Galilea ko tsango chónda ndo juachaxien Espíritue ndo Dio. Ko kain ni ntiꞌa teki na̱ kain ti juincheꞌe ndo Jesús. ");
INSERT INTO pps_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Ko jeꞌe ndo juinchekuenꞌen ndo chujni chijnie ndo Dio ngaxinꞌin niꞌngo ste kain tjajna ntiꞌa, ko kain na̱ kuajon na̱ juasaya ngajin ndo. ");
INSERT INTO pps_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Ko tjumeꞌe ndo Jesús sakjui ndo tjajna Nazaret, ti no bangíxin ndo. Ko nchakon sábado tjokéꞌe na̱, kuixinꞌin ndo ningue ni israelita ixi jaña kuancheꞌe ndo. Ko bingatjen ndo Jesús ixi sinchekuanxin ndo ti jitaxin xroon chijnie ndo Dio. ");
INSERT INTO pps_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Ko chjée na̱ ndo xroon tsikjin ndo kuanichjaxin chijnie ndo Dio ó saꞌó, ndo Isaías. Ko jeꞌe ndo kuantjeꞌe ndo xroon ko juée ndo ti jitaxin jaꞌin: ");
INSERT INTO pps_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Espíritue ndo Dio jii ngataꞌana, ko kuayáꞌa̱ juachaxin xronichja chijnie ndo tsayéꞌe ni nóa. Xruanꞌanna ndo ixi sintaxruanꞌan ni tangi ste, ko tsantsje jíee ni stejeꞌe̱, ko sintaxruanꞌan ni tikonꞌa; ko tsingijna ni stechrua, ");
INSERT INTO pps_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","ko xrontatjan na̱ ixi kui̱i̱ nchakon tsingijna na̱ ndo Dio ko tsantsje ndo ijie̱ chónda na̱. ");
INSERT INTO pps_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Ko tjumeꞌe ndo Jesús bijeꞌe ndo xroon, ko kuajon ndo xroon ngajin xi jincheꞌe ixra̱ niꞌngo, ko jeꞌe ndo bakeꞌe ndo nunte. Ko kain ni ste ntiꞌa jian stetsjeꞌe na̱ ndo. ");
INSERT INTO pps_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Ko kuaxi nichja ndo: ―Jai kuitja nchakon ndachro chijnie ndo Dio, chijni kuinꞌennta. ");
INSERT INTO pps_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Ko kain na̱ stetjao kichuu na̱ kondee xranchi jian jinichja ndo, ko xraxaon na̱ tsango chaxro ti ngeꞌe nichja ndo. Ko juanchangiꞌe kichuu na̱: ―¿Á jeꞌa xi jiꞌi chjenꞌen ndo José? ");
INSERT INTO pps_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Ko ndo Jesús ndache ndo na̱: ―Nduaxin xrondachijintana chijni jiꞌi: “Jaꞌa xi nchexruan, jaꞌua toxruanꞌan.” Ko kaxon xrondachijintana: “Ti kuinꞌanna juincheꞌe tjajna Capernaum, jaña ncheꞌe kaxon ntiꞌi tjajnáa.” ");
INSERT INTO pps_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","*Ko xrajinichja ndo, ko ndachro ndo: ―Nduaxin xrontatjunta xroꞌan sen profeta nichja chijnie ndo Dio, tsitikaon na̱ ndo ni tjajnée ndo. ");
INSERT INTO pps_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Ko janꞌan nduaxin ntatjunta ixi bakeꞌe itsjé nchri kaꞌan nunte Israel nchakon bakeꞌe ndo profeta Elías, naa ndo kuanichja chijnie ndo Dio ó saꞌó, nchakon meꞌe kuiꞌa ichrin níi nano kutuꞌo ko tsango bakeꞌe jinta nchijíi tjajna ntiꞌa. ");
INSERT INTO pps_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Ko ndo Dio xruanꞌi ndo ndo Elías xrokuitsjeꞌe ndo ngixeꞌi nchri kaꞌan tjajna Israel. Naꞌi. Xruanꞌan ndo ndo Elías itsji ndo ngajin naa nchri kaꞌan bakeꞌe tjajna Sarepta, tjenka tjajna Sidón ixi tsingijna ndo nchra. ");
INSERT INTO pps_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Kaxon nunte Israel kuintee kueya chujni níexin ichin lepra nchakon bakeꞌe ndo profeta Eliseo, ko xruanꞌi ndo Dio ndo Eliseo ngisen xrokuitsjeꞌe ndo ngixeꞌi chujni níexin ichin lepra ntiꞌa. Jeꞌo ndo Naamán kui̱xi̱n tjajna Siria, meꞌe ndo koxruenꞌen. ");
INSERT INTO pps_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Ko kain ni ste ngaxinꞌin niꞌngo kuinꞌen na̱ jaña, ko tsango koñao na̱. ");
INSERT INTO pps_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Bingatjen na̱ ko kuantsjexin na̱ ndo Jesús ntiꞌa, ko bikao na̱ ndo ngandeꞌe tjajna ngataꞌa ti ijna̱ ícha nui ixi tjaun na̱ xrojuinchengandatjen na̱ ndo ijna̱ meꞌe. ");
INSERT INTO pps_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Ko jeꞌe ndo Jesús kuatsinga ndo ngakjenꞌen na̱ ko sakjui ndo. ");
INSERT INTO pps_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Ko tjumeꞌe ndo Jesús sakjui ndo tjajna Capernaum, naa tjajna tikinixinꞌen tjajna Galilea ko kain sábado nchakon tjokéꞌe na̱ nchekuenꞌen ndo ni ste ntiꞌa. ");
INSERT INTO pps_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","*Ko ni stetinꞌen juincheꞌe na̱ juaxruxin xranchi kuanchekuenꞌen ndo na̱ ixi chijnie ndo chónda ijié juachaxin. ");
INSERT INTO pps_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Ko ngaxinꞌin niꞌngo ntiꞌa jii naa xi chónda espíritue Xixronꞌanxrée ko séen kuyako xa ko ndachro xa: ");
INSERT INTO pps_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","―Tintuna̱na, Jesús tjajna Nazaret. ¿Á juiꞌia ixi sinchetjáñana? Janꞌan chuxian ixi jaꞌa naa ngisen ícha tjúá xruanꞌan ndo Dio. ");
INSERT INTO pps_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Tjumeꞌe ndo Jesús kuyakutee ndo espíritue Xixronꞌanxrée, ko ndachro ndo: ―¡Tenkua, ko tachrjexian xi ña̱! Tjumeꞌe jeꞌe espíritue Xixronꞌanxrée juanka xi meꞌe nunte ngatoxin ikon kain ni ste ntiꞌa. Ko tjumeꞌe kuachrje espíritue Xixronꞌanxrée ko juinchenieꞌa xa xi meꞌe. ");
INSERT INTO pps_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Kainko na̱ xronka na̱, ko ndache kichuu na̱: ―¿Ngeꞌe chijni jian nichja ndo Jesús? Ixi jeꞌe ndo chónda ndo ijié juachaxin ko tetuenꞌen ndo espíritue Xixronꞌanxrée ko titikaon, tachrje ko satji espíritu. ");
INSERT INTO pps_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Ko kain tjajna ntiꞌa binga chijni xranchi nchexruenꞌen ndo Jesús kain na̱ ko xranchi nichja ndo. ");
INSERT INTO pps_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Tjumeꞌe ndo Jesús kuachrjexin ndo niꞌngo ko sakjui ndo ndoꞌa ndo Simón Pedro. Ko jachée ndo Pedro tsango níexin jan súa. Méxin, kuinóatée sen ngajin ndo Jesús ixi sinchexrjuenꞌen ndo jan. ");
INSERT INTO pps_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Ko ndo Jesús kuisée ndo ti jitsinga jan, ko kuyakutee ndo súa ko jeꞌe súa kuachrje súa. Ko tuinxin bingatjen jan ko kuajon jan juine sen. ");
INSERT INTO pps_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Ko kuitaon nchakon, kain ni chónda ni niꞌe, níexin na̱ ngixeꞌi ichin, bikao na̱ na̱ ti jii ndo Jesús; ko jeꞌe ndo bakeꞌe ndo itja ndo ngataꞌa ngujngu na̱, ko koxruenꞌen kain na̱. ");
INSERT INTO pps_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Ko itsjé ni niꞌe kuantsjexin ndo espíritue Xixronꞌanxrée ko hora tachrje espíritu tuyako ko ndachro: ―Jaꞌa chjenꞌen ndo Dio. Ko ndo Jesús kuyakutee ndo espíritue Xixronꞌanxrée ko kuintueꞌa ndo xronichja xa ixi jeꞌe xa noꞌe xa ixi jeꞌe ndo Jesús, ndo Cristo. ");
INSERT INTO pps_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Ko ó bingasáña jeꞌe ndo Jesús kuachrjexin ndo tjajna meꞌe, ko sakjui ndo nunte xroꞌan chujni ste. Ko jeꞌe na̱ juée na̱ ndo ko ikjui na̱ ti no jii ndo. Ko tingakonꞌen na̱ ndo ixi tjaunꞌa na̱ satsji ndo inaa tjajna. ");
INSERT INTO pps_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","A̱ jeꞌe ndo Jesús ndachro ndo: ―Janꞌan xrokonda itsji ikaxin tjajna ixi xrontatjan na̱ xranchi tsayéꞌe na̱ ti tetuanꞌan ndo Dio ixi meꞌe juixin janꞌan. ");
INSERT INTO pps_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ko jaña kuaji ndo Jesús kain niꞌngo tikinixinꞌen nunte Galilea ko ndache ndo na̱ chijnie ndo Dio. ");
INSERT INTO pps_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","*Naa nchakon ndo Jesús jii ndo ngandeꞌe ndalago ndatinꞌin Genesaret ko kueya na̱ kuixintja kichuu na̱ ixi tjaun na̱ tsinꞌen na̱ chijnie ndo Dio. ");
INSERT INTO pps_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Ko bikon ndo jii ngandeꞌe inda yuu nta̱barco tsikintuꞌe ni itsé kuchee̱ ko jeꞌe na̱ stenéma na̱ nochaꞌa tséxin na̱ ba. ");
INSERT INTO pps_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Ko jeꞌe ndo bajinꞌin ndo naa nta̱barcoe naa xi ndatinꞌin Simón, ko ndo Jesús ndache ndo xa ixi tsoncheka xa nta̱a̱ ícha ngusine inda. Ko bakeꞌe ndo nunte ngataꞌa nta̱barco ko kuaxi ndo juinchekuenꞌen ndo kain ni ste ntiꞌa. ");
INSERT INTO pps_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Ko juexin juinchekuenꞌen ndo na̱, tjumeꞌe ndache ndo xi Simón: ―Tikuꞌa nta̱barco ti ícha yasoꞌe inda, ko tjankanta nochaꞌa chringi inda ixi xrotsénta kuchee̱. ");
INSERT INTO pps_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","*Ko ndo Simón juatingíexin ndo: ―Maestro, nguixin tiie stentaꞌana ixra̱ ko xroꞌan kuchee̱ itséna. Ko siá jaꞌanta ndachronta, jaña sintaꞌana. ");
INSERT INTO pps_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","*Ko jeꞌe sen kuitikaon sen ngeꞌe ichro ndo Jesús. Ko tsango kueya kuchee̱ bingachjian nochaꞌa ko jitaxin jichrindaon no. ");
INSERT INTO pps_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Ko tjakaxin kichuu sen steyá inaa nta̱barco ixi tsonchjiñeꞌe sen tsingijna kichuu sen. Ko kui̱i̱ sen ko juinchekaon sen yui nta̱barco ko jeꞌe nta̱a̱ kuechjenꞌen nta̱a̱ ko ó xrojamangi nta̱a̱ ixi kueya kuama nta̱a̱. ");
INSERT INTO pps_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Ko bikon ndo Simón Pedro ngeꞌe konꞌen, bakeꞌexin ndo ntatuchiꞌin ndo ko ndachro ndo: ―Tingaxintuan, Nchána Jesús, ixi janꞌan tjúáꞌi aséenna. ");
INSERT INTO pps_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Méxin, ndo Simón ko sen ste ngajin ndo xronka sen ixi kueya kuchee̱ itsé sen. ");
INSERT INTO pps_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Kaxon xronka ndo Jacobo ko ndo Juan, chjenꞌen ndo Zebedeo, sen meꞌe tingijna ndo Simón ncheꞌe sen ixra̱. Ko ndo Jesús ndachro ndo: ―Xronkaꞌia, saꞌó kuatse kuchee̱ ko jai tsaxia xronichjeꞌe chujni kondeena janꞌan. ");
INSERT INTO pps_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Ko bikao sen nta̱barco ngandeꞌe inda. Ko kuintuꞌe sen nta̱a̱ ko kain ngeꞌe kuachónda sen ko sakjui sen ruéꞌe sen ndo Jesús. ");
INSERT INTO pps_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Naa nchakon bakeꞌe ndo Jesús naa tjajna, kui̱i̱ naa xi níexin xa ichin lepra. Ko bikon xa ndo Jesús, méxin, konchjiñeꞌe xa ko bakeꞌexin ntatuchiꞌin xa ko kuiséya xa ngataꞌa nunte ko kuinóatée xa ko ndachro xa: ―Jaꞌanta nchexruannanta siá jaña tjaunnta. ");
INSERT INTO pps_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Ko ndo Jesús bakeꞌe ndo itja ndo ngataꞌa xa ko ndachro ndo: ―Jaán tjaꞌon; sintaxruanꞌan. Ko tuinxin koxruenꞌen xa. ");
INSERT INTO pps_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Ko jeꞌe ndo kuetuanꞌan ndo ngajin xa: ―Xroꞌan ngisen tekiꞌé ixi ó koxruanꞌan. Itjia ngajin xitaana ixi ó koxruanꞌan ko tájuan ti tikinixin kuituanꞌan ndo Moisés ko jaña tsikon kueya na̱ ixi koxruanꞌan. ");
INSERT INTO pps_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Ko konoꞌe kain tjajna chijnie ndo Jesús, ko kueya na̱ konchjiñeꞌe na̱ ngajin ndo ixi tsinꞌen na̱ ngeꞌe ndachro ndo, ko sinchexrjuenꞌen ndo chinꞌen na̱. ");
INSERT INTO pps_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Ko jeꞌe ndo Jesús bakachrjendáa ndo nanaó ti xroꞌan chujni jii ixi kuanichjeꞌe ndo ndotée ndo jii ngajní. ");
INSERT INTO pps_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Naa nchakon ndo Jesús juinchekuenꞌen ndo chujni ko ntiꞌa ste kaxin xi fariseo ko kaxin xi tjako ley, tsiki̱ꞌxi̱n xa kain tjajna nunte Galilea ko nunte Judea ko tjajna Jerusalén. Ko ndo Jesús juako ndo juachaxien ndo Dio ixi juinchexruenꞌen ndo itsjé chujni niꞌe. ");
INSERT INTO pps_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Nchakon meꞌe kui̱i̱ kaxin na̱ bikaꞌo na̱ naa xi jitsingataꞌa kania, xi meꞌe juaꞌi nchetengi tutée xa. Ko tjaun na̱ xrokuixinꞌin na̱ kao xi niꞌe ngaxinꞌin nchia ixi xrobakeꞌe na̱ xa ngajin ndo Jesús. ");
INSERT INTO pps_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Ko juaꞌi kuixinꞌin na̱ ixi kueya na̱ ste na̱ ngaxinꞌin nchia. Ko tjumeꞌe bajinꞌin na̱ ngataꞌa nchia ko konxrato xa ngataꞌa nchia, ko ntiꞌa juinchexingajinxin na̱ xi niꞌe jiá kania ngusine kain ni ste tjenka ndo Jesús. ");
INSERT INTO pps_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Ko ndo Jesús bikon ndo ixi chujni meꞌe tsango chuntia na̱ ko ndache ndo xi niꞌe: ―Janꞌan ó juintemáꞌa kain ti ndakoꞌa juincheꞌe. ");
INSERT INTO pps_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Ko tjumeꞌe kain xi tjako ley ko xi fariseo kuaxi xraxaon xa: “¿Ngisen xi jiꞌi, ixi ndakoꞌa nichja xa ko nichjangíꞌe xa ndo Dio? Ixi xroꞌan chujni tsantsje ijie̱; jeꞌo ndo Dio chao tsantsje ndo ijie̱ chónda na̱.” ");
INSERT INTO pps_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Ko ndo Jesús ó noꞌe ndo ngeꞌe stexraxaon xa, méxin, ndachro ndo: ―¿Sonda jaña xraxaonnta? ");
INSERT INTO pps_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","¿Ngeꞌe ícha tangiꞌa xrontatjan xi niꞌe? ¿Á ícha tangiꞌa xrontatjan xa ixi ó koméꞌe ti ndakoꞌa juincheꞌe xa?, o̱, ¿á tsingatjen xa ko tsajixin xa tutée xa? ");
INSERT INTO pps_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Méxin, jai tsjakoꞌanta ixi janꞌan, chjenꞌen ndo Dio, xjan jongíꞌe xranchi chujni, chonda juachaxin ngataꞌa nunte tsantsje ijie̱ chónda chujni. Ko tjumeꞌe ndo Jesús ndache ndo xi niꞌe: ―Janꞌan ntatjua jaꞌa tingatjen ko itsé kaniaꞌa ko satsjia ndúya. ");
INSERT INTO pps_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Ko tuinxin bingatjen xi juaꞌi itji ko stetsjeꞌe kain na̱, ko itsé xa kanieꞌe xa ti baketaꞌa xa ko sakjui xa ndoꞌa xa ko jitajon xa juasaya ngajin ndo Dio. ");
INSERT INTO pps_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Ko kain ni ste ntiꞌa xronka na̱ ko kaxon kuajon na̱ juasaya ngajin ndo Dio, ko xrakon na̱ stendachro na̱: ―Jai bikona naa ngeꞌe ícha jié juincheꞌe ndo Dio. ");
INSERT INTO pps_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Ko tjumeꞌe ndo Jesús kuachrjexin ndo nchia, ko bikon ndo naa xi xengeꞌe iꞌna̱ ndatinꞌin Mateo, jii xa ti xengaxin iꞌna̱ ko ndo Jesús ndache ndo xa: ―Xrokuia, ichjina. ");
INSERT INTO pps_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Ko xi Mateo, bingatjen xa ko kuintuꞌe xa kain ngeꞌe, ko ruéꞌe xa ndo Jesús. ");
INSERT INTO pps_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Ko tjumeꞌe xi Mateo bakeꞌe xa naa kia ijié ndoꞌa xa ixi tsajon xa juasie xa ngajin ndo Jesús. Ko kaxon ste kueya xi xengeꞌe iꞌna̱ ko ikaxin chujni chónda ijie̱ ko juinekao na̱ ndo Jesús. ");
INSERT INTO pps_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","*Ko itsjé xi fariseo ko xi tjako ley kuaxi xa nichjangíꞌe xa ti ni chrikao ndo Jesús, ko ndachro xa: ―¿Sonda rintekuꞌunta ko tikuꞌunta xi xengeꞌe iꞌna̱ ko ni chónda ijie̱? ");
INSERT INTO pps_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Ko juatingíexin ndo Jesús ko ndachro ndo: ―Ngisen níeꞌa xrokondeꞌa xinchexruan; ni niꞌe ícha xrokondeꞌe na̱ xa. ");
INSERT INTO pps_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Juiꞌa ixi tsiyaꞌa ni jian. Juiꞌi ixi tsiyaꞌa ni chónda ijie̱, ko tsitikaon na̱ ndo Dio. ");
INSERT INTO pps_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Ko tjumeꞌe jeꞌe na̱ juanchangiꞌe na̱ ndo Jesús ko ndachro na̱: ―Sen chrikao ndo Juan ko xi fariseo neꞌa sen nchakon nichja sen ngajin ndo Dio ko, ¿sonda sen chrjikoꞌa jaꞌa kain nchakon ine sen ko tiꞌi sen? ");
INSERT INTO pps_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Ko ndachro ndo Jesús: ―¿Á xrojuineꞌa ni tsikiyeꞌe xi kuteꞌe, ni kui̱i̱ kiée xa? Já jaán ixi xrastekao na̱ xa. ");
INSERT INTO pps_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Ko tsi̱i̱ naa nchakon satsikao na̱ xi tsikuteꞌe, ko tjumeꞌe jeꞌe sen sineꞌa sen. ");
INSERT INTO pps_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Kaxon juako ndo naa ngeꞌe, ko ndachro ndo: ―Xroꞌan ngisen tonchrijin tuꞌo manta natjúá ko tjaun ti tsikichje manta nta̱xi. Siá jaña sincheꞌe na̱, tsitjáña manta natjúá; ko kaxon manta natjúá ndakoꞌa tsikonni manta ti manta nta̱xi. ");
INSERT INTO pps_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Kaxon juaꞌi tsikia xran vino natjúá tjua̱nxra̱n nta̱xi, ixi tsichje tjua̱nxra̱n, ko ixran ko tjua̱nxra̱n ndatsitjáña. ");
INSERT INTO pps_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Méxin, xran natjúá xrokonda tsikia xran tjua̱nxra̱n natjúá, ko jaña kayui tsitjáñaꞌi. ");
INSERT INTO pps_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ko kaxon xroꞌan ngisen tsiꞌi xran nta̱xi, ko tjumeꞌe tsiꞌi na̱ xran natjúá, ixi xrondachro na̱: “Ícha jian xran nta̱xi.” ");
INSERT INTO pps_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Naa nchakon sábado tjokéꞌe ni judío, ndo Jesús ko sen teyuu chrikao ndo kuatsinga sen tjenka kaxin ijngi tsikenga na̱ trigo, ko sen teyuu chrikao ndo konchrinjin sen kaxin ti̱n trigo, ko konteꞌnga sen trigo ixi itja sen ko juine sen. ");
INSERT INTO pps_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Ko kaxin xi fariseo juanchangi xa ndachro xa: ―¿Sonda stencheꞌenta ti tikinixinꞌa sincheꞌeni nchakon tjokéꞌeni? ");
INSERT INTO pps_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Ko ndachro ndo Jesús: ―¿Á juinchekuanxinꞌanta ngeꞌe ndachro xroon jitaxin chijnie ndo Dio, xranchi juincheꞌe ndo David ko kain xi bikao ndo naa nchakon tsango kuenꞌen sen jinta? ");
INSERT INTO pps_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Ndo David kuixinꞌin ndo ndoꞌa ndo Dio ko itsé ndo nutja ti tikinixinꞌen ndo Dio ko juine ndo nio, ko kaxon kuajon ndo nio juine kain xi bikao ndo. Ko nutja meꞌe jeꞌo xitaana chónda xa juachaxin sine xa nio. ");
INSERT INTO pps_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Ko kaxon ndachro ndo Jesús: ―Chjenꞌen ndo Dio, xjan jongíꞌe xranchi chujni, chónda ndo juachaxin tsetuenꞌen ndo xranchi tsonꞌen nchakon tjokéꞌeni. ");
INSERT INTO pps_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Inaa sábado nchakon tjokéꞌe ni judío, kuixinꞌin ndo Jesús ningue ndo Dio ko kuaxi ndo juinchekuenꞌen ndo na̱ chijnie ndo Dio. Ko ntiꞌa jii naa xi juaꞌi nchetengi itja xa ti jian. ");
INSERT INTO pps_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Ko xi tjako ley ko xi fariseo stetsjaya xa ndo Jesús ixi tjaun xa tsikon xa á sinchexrjuenꞌen ndo xi meꞌe nchakon sábado tjokéꞌe na̱, ixi jaña tsjankataꞌa xa ndo Jesús ijie̱. ");
INSERT INTO pps_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Ko ndo Jesús ó noꞌe ndo ngeꞌe stexraxaon aséen xa, méxin, ndache ndo xi niꞌe itja: ―Tingatjen ko takeꞌé ngusine ntiꞌi. Ko tjumeꞌe bingatjen xi meꞌe ko bakeꞌe xa ngusine ti ste kain na̱. ");
INSERT INTO pps_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Ko jeꞌe ndo Jesús ndache ndo ikaxin na̱: ―Janꞌan tsjanchangiꞌanta, ¿ngeꞌe chao sincheꞌeni nchakon tjokéꞌeni, á sincheꞌeni jian o̱ sincheꞌeni ndakoꞌa? ¿Á tsingijnani chujni o̱ á tsóñani chujni? ");
INSERT INTO pps_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Ko tjumeꞌe ndo Jesús tsjeꞌe ndo kain ni ste ntiꞌa ko ndache ndo xi niꞌe: ―Tinxe tjáa. Ko jeꞌe xa kuinxe itja xa, ko hora meꞌe koxruenꞌen itja xa. ");
INSERT INTO pps_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Ko ikaxin na̱ tsango koñao na̱ ko stetjao kichuu na̱ xranchi xrotsé na̱ ndo Jesús. ");
INSERT INTO pps_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Ikaxin nchakon tjumeꞌe ndo Jesús ikjui ndo ti jii naa ijna̱ ixi ntiꞌa xronichjexin ndo ndo Dio, ko nchijíi tiie juao ndo ndotée ndo. ");
INSERT INTO pps_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Ko ti bingasáña nichjeꞌe ndo sen ruéꞌe ndo, ko kuincheꞌe ndo teyuu sen, sen meꞌe ikjan apóstol tsajikao ndo. ");
INSERT INTO pps_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Ko sen meꞌe jaꞌin ndatinꞌin sen: ndo Simón, meꞌe ndo Jesús juinchekinꞌin ndo Pedro; ko xikichuu ndo ndatinꞌin Andrés; ndo Jacobo, ndo Juan, ndo Felipe ndo Bartolomé, ");
INSERT INTO pps_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","ndo Mateo, ndo Tomás, ndo Jacobo, chjenꞌen ndo Alfeo, ndo Simón, banchekinꞌin na̱ Zelote, ");
INSERT INTO pps_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","ndo Judas chjenꞌen ndo Jacobo ko ndo Judas Iscariote, ndo juinchekji ndo Jesús. ");
INSERT INTO pps_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Ko ndo Jesús ko ti teyuu sen xingajinxin sen ngataꞌa jna̱ ko kui̱i̱ sen ngataon naa ijngi, ko ntiꞌa ste ikaxin sen ruéꞌe ndo. Ko kaxon kueya na̱ konchjiñeꞌe na̱, kui̱xi̱n na̱ kueya tjajna nunte Judea ko tjajna Jerusalén ko nguixin ngandeꞌe ndalago ti jii tjajna Tiro ko tjajna Sidón. Kain na̱ kui̱i̱ na̱ ixi tsinꞌen na̱ ti nichja ndo Jesús ko tsoxruenxin na̱ ichin chónda na̱. ");
INSERT INTO pps_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Ko ni chónda espíritue Xixronꞌanxrée kaxon koxruenꞌen na̱. ");
INSERT INTO pps_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Ko kain na̱ tjaun na̱ xrotsé na̱ ndo Jesús ixi noꞌe na̱ juachaxin tachrjexin jeꞌe ndo chao sinchexrjuenꞌen kain na̱. ");
INSERT INTO pps_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Ko tjumeꞌe ndo Jesús xendua ndo tsjeꞌe ndo sen teyuu chrikao ndo ko ndachro ndo: ―Juaxruxin tsakeꞌenta ti nóanta ixi tsayeꞌenta juachaxin tsixinꞌinnta ti tetuanꞌan ndo Dio. ");
INSERT INTO pps_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Juaxruxin tsakeꞌenta ti jai chondaꞌinta ngeꞌe sintenta, ko tjumeꞌe xrochondanta ti jian. ’Juaxruxin tsakeꞌenta ti jai tsjanganta, ixi tjumeꞌe xrochaꞌanta. ");
INSERT INTO pps_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","*’Juaxruxin tsakeꞌenta ti jai ningakonꞌannta na̱ ko tsjanoanta na̱, chinga xrontatjunta na̱, ko xrondachro na̱ ixi ñaꞌinta ixi titikaonntana janꞌan, Chjenꞌen Ndo Dio, xjan jongíꞌe xranchi chujni. ");
INSERT INTO pps_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","*Nchakon tsonꞌen kain juachjaon meꞌe, tsango juaxruxin ko chaxro tsakeꞌenta, ixi tsayeꞌenta naa ngeꞌe ícha jian jii ngajní. Jaña juincheꞌe sen tachríꞌanta ngajin sen kuachronga chijnie ndo Dio. ");
INSERT INTO pps_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","’Lastunta jaꞌanta ti kueya chondanta ixi ó juexin ti juaxruxin bakeꞌenta. ");
INSERT INTO pps_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","’Lastunta ti chondanta kueya ngeꞌe sintenta ixi tsi̱i̱ nchakon tsatsenta jinta. ’Ko lastunta ti jai tjanonta ko cháꞌanta ixi tsi̱i̱ nchakon xrotsjanganta ixi tsayeꞌenta ijié juachjaon. ");
INSERT INTO pps_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","’Lastunta jaꞌanta ixi jai kain chujni chaxro nichjaꞌanta na̱ ixi jaña kaxon kuanichjeꞌe ni tachríꞌanta chujni ndakoꞌa bajako chijnie ndo Dio. ");
INSERT INTO pps_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","’Ko jaꞌanta ti tinꞌennta ti ntatjunta: Tjueꞌenta ngisen tjaunꞌanta, ko ncheꞌenta jian ngajin ni ningakonꞌannta. ");
INSERT INTO pps_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Tjancheꞌenta ndo Dio ixi chaxro tsintee ngisen chinga nichjaꞌanta, ko tjancheꞌenta ndo Dio ixi ni ndakoꞌa ncheꞌe ngajinnta. ");
INSERT INTO pps_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Siá xrojan ngisen tsandeꞌe na̱ tja na̱ ikonnta, tintuꞌenta tsandeꞌe na̱ naa nango. Ko siá xrojan ngisen tsantsjaꞌanta chamaranta, kaxon tájonnta camisáanta. ");
INSERT INTO pps_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Ko siá xrojan ngisen tsjanchaꞌanta ngeꞌe chondanta, tájonnta; ko siá xrojan ngeꞌe tsantsjaꞌanta na̱, íncheniaxinꞌanta. ");
INSERT INTO pps_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","*Jaꞌanta ncheꞌenta ngajin na̱ xranchi tjaunnta sincheꞌe na̱ ngajinnta. ");
INSERT INTO pps_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","’Siá jaꞌanta jeꞌo tjueꞌenta ngisen chaxro nichjaꞌanta, ndo Dio ncheꞌa ndo juaxruxin meꞌe, ixi kain ni chúxinꞌa ndo Dio ko ni ndakoꞌa ncheꞌe, jaña ncheꞌe na̱. ");
INSERT INTO pps_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ko siá jeꞌo ncheꞌenta ti jian ngajin ngisen ncheꞌe jian ngajinnta, ndo Dio ncheꞌa ndo juaxruxin meꞌe, ixi kain ni chúxinꞌa ndo Dio jaña ncheꞌe na̱ kaxon. ");
INSERT INTO pps_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ko siá nchekjennta na̱ xrojan ngeꞌe chondanta jeꞌo ngajin ngisen chao xrokjanꞌannta ngeꞌe juinchekjennta, ndo Dio ncheꞌa ndo juaxruxin meꞌe ixi kaxon ni chúxinꞌa ndo Dio nchekjen kichuu na̱ xrojan ngeꞌe ko jaña tjaun na̱ xrokjenꞌen na̱ kaxon. ");
INSERT INTO pps_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Ko jaꞌanta xrotjueꞌenta ngisen ningakonꞌannta, ko sincheꞌenta jian ngajin ni tjaunꞌanta. Kaxon sinchekjennta na̱ naa ngeꞌe, ko xroꞌan ngeꞌe xrochonꞌénnta tsayeꞌenta. Jaña jaꞌanta tsayeꞌenta naa ngeꞌe jian ixi jaꞌanta xrokjannta chjenꞌen ndo Dio jii ngajní, ixi jeꞌe ndo Dio kaxon jaña ncheꞌe ndo, tajon ndo kueya ngeꞌe ngajin ni tajonꞌa juasaya ko ni ndakoꞌa ncheꞌe. ");
INSERT INTO pps_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Tikonóeꞌénta chujni, xranchi Ndotáina jii ngajní tikonóeꞌe ndo chujni. ");
INSERT INTO pps_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","’Tjankataꞌinta ijie̱ ngajin na̱, meꞌe kaxon ndo Dio tsjangataꞌinta ndo ijie̱ ngajinnta. Ncheꞌanta ixi tangi tsonꞌen naa chujni ko jaña kaxon ndo Dio tsetuanꞌi ndo ixi tangi tsonꞌannta. Tjáñaꞌanta ngeꞌe ndakoꞌa juintaꞌanta na̱, jaña kaxon ndo Dio xrotjáñeꞌe ndo ti ndakoꞌa juincheꞌenta. ");
INSERT INTO pps_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Ko tájonnta ngeꞌe xrokondeꞌe ikaxin na̱, ko ndo Dio xrotjáanta ndo kain ti xrokondaꞌanta. Ko sinchekaon ndo costáanta jian, tsonteto costa jian, tsontsjenga ndo ko jian xrokaon ixi ícha xrotjáanta ndo. Méxin siá juaxruxin kuajonnta, jaña tsayeꞌenta kaxon. ");
INSERT INTO pps_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","*Ko ndo Jesús kaxon juako ndo jaꞌin: ―¿Á chao naa ngisen tikonꞌa xrotséꞌe itja inaa ni tikonꞌa? ¿Á jeꞌa tsandatjen yui na̱ ngaya tuye? ");
INSERT INTO pps_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","*Méxin, naa ngisen ruéꞌe, jeꞌa ícha noꞌe sen ixi ti ndo nchekuenꞌen sen. Ko nchakon tsitja sen jian, meꞌe tsakeꞌe sen xranchi ndo juinchekuenꞌen sen. ");
INSERT INTO pps_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","’¿Sonda tsjeꞌenta xineno jii ngangi ikon sen kichuunta ko tsjeꞌanta nta̱a̱ ti chónda ikonnta? ");
INSERT INTO pps_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Siá tikonꞌanta nta̱a̱ jii ngangi ikonnta, ¿sonda xrondachenta sen kichuunta: “Chonꞌén tsantsjengi xineno jii ngangi ikuan”? ¡Ko jaꞌanta ndakoꞌa xraxaonnta! Cháña saꞌó tantsjenginta nta̱a̱ jii ngangi ikonnta, ko jaña chao tsikonnta jian tsantsjengínta xineno jii ngangi ikon sen kichuunta. ");
INSERT INTO pps_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","’Ko xroꞌan nta̱a̱ jian tsajon naa itu xroꞌan xrée, ko nta̱a̱ xroꞌan xrée juaꞌi tsajon nta̱a̱ naa itu jian. ");
INSERT INTO pps_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","*Nanaá nta̱a̱ tatsuanxinni nta̱a̱ ixi itu tajon nta̱a̱. Ixi nta̱chaꞌa juaꞌi tsajon nta̱a̱ tu higo, ko kacháꞌa juaꞌi tsajon ka tu uva. ");
INSERT INTO pps_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","*Ni jian nichja na̱ ngeꞌe jian jii ngaya aséen na̱; ko ni ñaꞌi ndakoꞌa nichja na̱ ixi nichja na̱ ti chónda na̱ ngaya aséen na̱. Ixi kain ngeꞌe chónda na̱ ngaya aséen na̱ meꞌe nichja roꞌa na̱. ");
INSERT INTO pps_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","’Ko jaꞌanta, ¿sonda ndachronta ixi janꞌan Ncháanta ko titikaonꞌanta ngeꞌe tetuanꞌannta? ");
INSERT INTO pps_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Kain chujni tonchjiñeꞌe na̱ ngajin janꞌan, ko tinꞌen na̱ ti ntatjan na̱ ko titikaon na̱, ");
INSERT INTO pps_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","ni meꞌe ste na̱ xranchi naa xi tsijinchekonchjian naa nchia ko saꞌó inge xa ixi ngataꞌa itjao̱ tsiꞌte xa nchia. Ko nchakon koyeé inda, ko soji kuinchekaꞌo inda nchia meꞌe, ko xroꞌan konꞌen nchia ixi soji jii nchia ngataꞌa itjao̱. ");
INSERT INTO pps_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Ko ni tinꞌen ti ndachrja̱n ko titikaonꞌa na̱, ni meꞌe ste na̱ xranchi naa xi juinchekonchjian naa nchia ngataꞌa nchese. Ko nchakon koyeé inda, ko soji kuinchekaꞌo inda nchia meꞌe, jamangi. Ko jaña chjenjin nchia meꞌe. ");
INSERT INTO pps_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Ko juexin nichja ndo Jesús, ikjan ndo tjajna Capernaum. ");
INSERT INTO pps_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Ntiꞌa bakeꞌe naa xi capitán romano bachónda xa naa xi nchexra̱ ko tsango tjaun xa xi meꞌe. Ko jeꞌe xi nchexra̱ niꞌe xa ko ó jiteꞌen xa. ");
INSERT INTO pps_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Ko xi capitán kuinꞌen xa nichja na̱ ngeꞌe jian juincheꞌe ndo Jesús, ko tjumeꞌe xroꞌan xa kaxin ni judío tetuanꞌan tsijée na̱ ndo Jesús, tsinóatée na̱ ixi xrokui̱i̱ ndo ko xrojuinchexruenꞌen ndo xi nchexrée xi capitán. ");
INSERT INTO pps_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Ko jeꞌe na̱ konchjiñeꞌe na̱ ngajin ndo Jesús ko kuaxi kuinóatée na̱ ngajin ndo ko ndachro na̱: ―Tsango jian xi capitán ko jaꞌanta chao xrobingijnanta xa, ");
INSERT INTO pps_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","ixi jeꞌe xa tjaun xa tjajnana̱na, tjajnée ni judío, ko kuetuanꞌan xa konchjian ningona̱na. ");
INSERT INTO pps_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Ko ndo Jesús ikjui ndo ko ó jitonchjiñeꞌe sen ndoꞌa xi capitán, ko tjumeꞌe xi capitán kuetuanꞌan xa ngajin kaxin na̱ itsji na̱ tsindache na̱ ndo Jesús: ―Xi capitán tjaunꞌa xa xrotjáanta xa ixra̱, ko ndachro xa ixi tikinixinꞌa xa tsixinꞌinnta ndoꞌa xa ");
INSERT INTO pps_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","ko kaxon tikinixinꞌa tsi̱i̱ xa xronichjaꞌanta xa. Méxin, jeꞌo tájonnta juachaxin ixi xi nchexrée xa tsoxruenꞌen xa. ");
INSERT INTO pps_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Jeꞌe xa kaxon xrokonda tsitikaon xa ngisen tetuenꞌen xa, ko kaxon chónda xa juachaxin tetuanꞌan xa ngajin kain xisoldadoe xa. Ko nchakon tetuenꞌen xa naa xisoldadoe xa satsji xa, jeꞌe xa itji xa. Ko nchakon tetuanꞌan xa ixi tsi̱i̱ naa xi soldado jeꞌe xa ti̱i̱ xa. Ko nchakon tetuenꞌen xa naa xi nchexra̱, jeꞌe xa titikaon xa. ");
INSERT INTO pps_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Ko kuinꞌen ndo Jesús, ko xronka ndo ixi jaña ndachro xa, ko jeꞌe ndo konkjan tsjeꞌe ndo ti sen steruéꞌe ndo, ko ndachro ndo: ―Nduaxin ntatjunta, xroꞌan ni israelita kuitja chuntiana xranchi xi capitán jiꞌi. ");
INSERT INTO pps_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Ko tjumeꞌe ni ncheꞌe ixra̱ ngajin xi capitán ikjan na̱ nchia, ko bikon na̱ xi niꞌe ko ó tsikoxruenꞌen xa ko íxroꞌan ichin chónda xa. ");
INSERT INTO pps_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Ko tjumeꞌe ndo Jesús sakjui ndo naa tjajna ndatinꞌin Naín, bikao ndo sen teyuu chrikao ndo ko kueya ni konchjiñeꞌe ngajin ndo. ");
INSERT INTO pps_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Ko nchakon kuiji sen ngandeꞌe tjajna meꞌe, ndo Jesús bikon ndo jitikaꞌo na̱ naa chujni tsikenꞌen xroxrabaa, chán meꞌe naa chjenꞌen naa nchri kaꞌan, naakua xjan meꞌe bachónda nchra. Ko tsango itsjé ni tjajna jitikao na̱ nchra tsixrabaa chán. ");
INSERT INTO pps_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Hora bikon ndo Jesús nchri meꞌe, bikonóeꞌe ndo nchra ko ndachro ndo: ―Ítsjangaꞌia. ");
INSERT INTO pps_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Ko tjumeꞌe ndo Jesús konchjiñeꞌe ndo ko bakeꞌe ndo itja ndo ngataꞌa nta̱a̱ jiá chán, ko ni jitikao nta̱a̱ chónꞌen na̱. Ko ndo Jesús ndache ndo chán tsikenꞌen: ―Janꞌan ntatjua: ¡Chajan tingatjen! ");
INSERT INTO pps_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Ko tjumeꞌe chán tsikenꞌen xendua chán ko bakeꞌe chán ko juangíxin chán nichja chán, ko jaña ndo Jesús kuajon ndo chán ngajin janée chán. ");
INSERT INTO pps_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Ko nchakon bikon na̱ jaña konꞌen, kain na̱ tsango xronka na̱ ko juangíxin na̱ kuajon na̱ juasie na̱ ngajin ndo Dio ko ndachro na̱: ―Ndo Dio xruanꞌan ndo naa ndo nichja chijnie ndo, ndo meꞌe tsango chónda ndo juachaxin. Ko kaxon ndachro na̱: ―Ndo Dio kui̱i̱ ndo tsingijna ndo tjajnée ndo. ");
INSERT INTO pps_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ko nguixin nunte Judea ko kain tjajna jii ngandajin nunte Judea konoꞌe na̱ ngeꞌe jian juincheꞌe ndo Jesús. ");
INSERT INTO pps_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Sen chrikao ndo Juan bekiꞌe sen ndo kain ngeꞌe juincheꞌe ndo Jesús ko tjumeꞌe kuiyeꞌe ndo yuu sen chrikao ndo, ");
INSERT INTO pps_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","ko xruanꞌan ndo sen tsitsjeꞌe sen ndo Jesús tsjanchangíꞌe sen ndo á jeꞌe ndo ngisen tsi̱i̱, o̱ á xrochonꞌen sen tsi̱i̱ inaa ngisen. ");
INSERT INTO pps_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Ko sen xruanꞌan ndo Juan konchjiñeꞌe sen ngajin ndo Jesús, ko ndachro sen: ―Ndo Juan xruanꞌanna ndo tsjanchangiꞌananta á jaꞌanta ndo Cristo tsi̱i̱, o̱ xraxrochonꞌanna inaa ngisen tsi̱i̱. ");
INSERT INTO pps_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Ko nchakon kuiji sen, ndo Jesús juinchexruenꞌen ndo tsango itsjé ni chónda ichin, ko kuantsje ndo espíritue Xixronꞌanxrée chónda kaxin na̱, ko kaxon juinchexruenꞌen ndo itsjé ni tikonꞌa. ");
INSERT INTO pps_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Méxin, ndo Jesús ndache ndo sen xruanꞌan ndo Juan: ―Itjinta, tindachenta ndo Juan ti bikonta ko ti kuinꞌennta: ni tikonꞌa, chao tikon na̱, ko ni ntarengo chao ichrji na̱, ko ni kuachónda ichin lepra, jai íxroꞌan ichin chónda na̱, ko ni bakienꞌa, chao tinꞌen na̱, ko ni kuenꞌen, jai xechón na̱, ko ni nóa kuinꞌen na̱ chijni jian ixi tsachrje ijie̱ chónda na̱. ");
INSERT INTO pps_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Ko sen xrotjáñeꞌa xrochuntiana, sen meꞌe juaxruxin tsintee sen. ");
INSERT INTO pps_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Nchakon sakjui sen tsixruaꞌan ndo Juan, ndo Jesús kuaxi ndo ndache ndo kain ni kuituꞌe ntiꞌa kondee ndo Juan, ko ndachro ndo: ―Nchakon ikjuinta ntajie kuitsjeꞌenta ndo Juan, ¿xranchi xraxaonnta xrobikonnta ndo? ¿Á bikonta ndo xranchi naa ntatji tjatuꞌo chrinto? ");
INSERT INTO pps_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","¿Naꞌi, ngeꞌe xrobikonnta? ¿Á xrobikonnta naa xi jiá manta tsango tjintee? ¡Naꞌi, jeꞌa meꞌe! Jaꞌanta ó noꞌanta ixi ngisen jiá manta tjintee ko chónda itsjé ngeꞌe, ni meꞌe ste na̱ ndoꞌa naa xi rey tetuanꞌan. ");
INSERT INTO pps_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Méxin, ¿ngeꞌe kuitsjeꞌenta? ¿Á xrobikonnta naa ngisen chronga chijnie ndo Dio? ¡Jaán, nduaxin meꞌe, ko xi meꞌe ícha chónda juachaxin ixi sen banichja chijnie ndo Dio saꞌó! ");
INSERT INTO pps_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Ndo Juan meꞌe ngisen kui̱i̱ xranchi jitaxin xroon chijnie ndo Dio saꞌó: Janꞌan xroxruanꞌan naa ngisen xrochronga chijnina ko jeꞌe ndo sinchenataonxin ndo chaꞌo, ko sinchekonchjian ndo chaꞌo ngajinnta. ");
INSERT INTO pps_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Janꞌan rintatjonta ixi kain ni kui̱i̱ saꞌó chronga chijnie ndo Dio, xroꞌan ngisen kuachónda juachaxin xranchi juachaxin chónda ndo Juan Bautista. Ko maski, ngisen chóndaꞌi itsjé juachaxin ti tetuanꞌan ndo Dio, ícha ijié sen ixi ndo Juan. ");
INSERT INTO pps_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","*Nchakon kuinꞌen na̱ jiꞌi, kain na̱ ko kain xi xengeꞌe iꞌna̱ tsikikite ndo Juan kuitikaon na̱ ixi ndo Dio tsango jian ndo. ");
INSERT INTO pps_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Ko xi fariseo ko xi tjako ley chroꞌa xa ixi ndo Juan xrobikitée ndo xa, tjaunꞌa xa ti ndo Dio xrobingijna ndo xa. ");
INSERT INTO pps_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Ko ndo Jesús ndachro ndo: ―¿Xranchi tsjakoxin chujni ste jai? ¿Ste na̱ xranchi tsjakoxinni ti ncheꞌe chujni? ");
INSERT INTO pps_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Ste na̱ xranchi ichjan nchínchín takeꞌe xjan nunte sondaon xjan ngataon ndasin ko tuyakuꞌe kichuu xjan ko ndachro xjan: “Janꞌanna kuanoana ntaxro ko jaꞌanta téꞌanta, janꞌanna itsje̱na soon ti chóndani juachjaon ko jaꞌanta tsjangaꞌinta.” ");
INSERT INTO pps_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Ko kui̱i̱ ndo Juan Bautista, ko juineꞌa ndo nutja ko kuiꞌa ndo xran vino, ko jaꞌanta ndachronta ixi jeꞌe ndo chónda ndo naa espíritue Xixronꞌanxrée. ");
INSERT INTO pps_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Ko tjumeꞌe juiꞌi janꞌan, Chjenꞌen ndo Dio, xjan jongíꞌe xranchi chujni, ko iné ko tiꞌí, ko jaꞌanta ndachronta ixi janꞌan tsango iné ko tsango tiꞌí ko tjento kain ni ndakoꞌa ncheꞌe ko kain xi xengeꞌe iꞌna̱. ");
INSERT INTO pps_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Ko ti tsango noꞌe ndo Dio meꞌe tjakoxin chjenꞌen ndo Dio. ");
INSERT INTO pps_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Naa xi fariseo ndache xa ndo Jesús itsji ndo ndoꞌa xa sinekao ndo xa. Ko ndo Jesús ikjui ndo ntiꞌa ko bakeꞌe ndo ti jii mesa. ");
INSERT INTO pps_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","*Ko tjajna meꞌe jii naa nchri, nchri meꞌe tsango kueya ijie̱ kuachónda nchra. Ko konoꞌe nchra ixi ndo Jesús kui̱i̱ ndo sine ndo ndoꞌa xi fariseo meꞌe, ko jeꞌe nchra ikjui nchra ntiꞌa ko bikao nchra naa xroxrao jichre inda chaxro xraxe tjintee. ");
INSERT INTO pps_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Ko konchjiñeꞌe nchra ti jii tutée ndo Jesús ko bakeꞌexin nchra ntatuchiꞌin nchra ko tsjanga nchra. Méxin, kuintjí ndakon nchra tutée ndo Jesús, ko tjumeꞌe xrajaa nchra juinchexemaxin nchra tutée ndo, ko kuitoxin nchra tutée ndo, ko tjumeꞌe bingamá nchra inda chaxro xraxe tutée ndo. ");
INSERT INTO pps_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Ko bikon xi fariseo tsikiyeꞌe ndo Jesús, ko jeꞌe xa xraxaon xa: “Á nduaxin ndo jiꞌi naa ndo chronga chijnie ndo Dio, siá nduaxin meꞌe, jeꞌe ndo xrokonoꞌe ndo ngisen jinéma ixi ndakon tutée ndo, ko ngisen nchri jiꞌi; xrokonoꞌe ndo ixi nchri jiꞌi tsango ndakoꞌa ncheꞌe nchra.” ");
INSERT INTO pps_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Ko tjumeꞌe ndo Jesús ndache ndo xi fariseo: ―Simón, janꞌan xrontatjua naa ngeꞌe. Ko xi fariseo juateꞌe xa: ―Ndachijiana, Maestro. ");
INSERT INTO pps_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Ko ndo Jesús ndachro ndo: ―Bakeꞌe yuu xi sínká tomi ngajin naa xi tjatuya tomi. Naa xi sínká naꞌó ciento tomi, ko naa xi sínká tuꞌo ciento tomi. ");
INSERT INTO pps_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Ko juaꞌi kuintejuenga xa ꞌna̱. Ko xi tjatuya tomi juincheméꞌe xa ti sínká kayui xi meꞌe. Ndachro ndo Jesús: ―Jai ndachijiana jaꞌa, ¿ngixeꞌe xi ícha tjueꞌe xi tjatuya tomi? ");
INSERT INTO pps_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Ko juateꞌe xi Simón ndachro xa: ―Janꞌan xraxaꞌon ixi xi ícha bikonóeꞌe xa, xi sínká ícha tomi. Ko ndo Jesús ndachro ndo: ―Jaán, nduaxin. ");
INSERT INTO pps_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Ko ndo Jesús tsjeꞌe ndo nchri meꞌe ko ndache ndo xi Simón: ―Tsjeꞌé nchri jiꞌi. Janꞌan kuixinꞌin ndúya ko chjánaꞌiana inda tsijmaxin tutéena; ko nchri jiꞌi juinéma nchra tutéena ixi ndakon nchra, ko juinchexemaxin nchra xrajaa nchra. ");
INSERT INTO pps_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Jaꞌa kuitoxinꞌana ti juiꞌi ndúya, ko jeꞌe nchra, xrakuixiꞌin ndúya jititoxin nchra tutéena. ");
INSERT INTO pps_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Jaꞌa bakeꞌa ndaxiꞌe ngataꞌa jáana; ko jeꞌe nchra bakeꞌe nchra inda chaxro xraxe tutéena. ");
INSERT INTO pps_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Méxin, janꞌan ntatjua ixi ti kueya sínká nchra ó koméꞌe, ko méxin, ícha tjaunna nchra; ko ngisen sinkaꞌi ijie̱, kaxon jeꞌa ícha tjaunna na̱. ");
INSERT INTO pps_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Ko tjumeꞌe ndo Jesús ndache ndo nchri meꞌe: ―Kain ti ndakoꞌa juincheꞌe ó koméꞌe. ");
INSERT INTO pps_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ko kain na̱ tsikonchjiñeꞌe ti jii ndo Jesús tjenka mesa kuaxi na̱ ndache kichuu na̱: ―¿Ngisen jiꞌi, ixi ncheméꞌe xa ti ijie̱ chónda na̱? ");
INSERT INTO pps_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Ko tjumeꞌe ndo Jesús ndache ndo nchra: ―Jaꞌa chuntiana ko kuitikaonna, méxin ijie̱ kuachonda koméꞌe ijie̱; méxin, jai juaxruxin satjia. ");
INSERT INTO pps_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Ko tjumeꞌe, ndo Jesús kuaji ndo itsjé tjajna ijié ko itsjé tjajna nchíín kuachronga ndo ixi kui̱i̱ juachaxien ndo Dio. Ko chrikao ndo sen teyuu kuincheꞌe ndo. ");
INSERT INTO pps_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","*Ko kaxon ntiꞌa steruéꞌe kaxin nchri tsikantsjeꞌe ndo espíritue Xixronꞌanxrée kuachónda nchra ko tsikantsje ndo kain ichin kuachónda nchra. Ko naa nchri meꞌe ndatinꞌin María Magdalena, nchri meꞌe kuantsjexin ndo ya̱a̱to̱ espíritue Xixronꞌanxrée. ");
INSERT INTO pps_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Ko kaxon ntiꞌa bakeꞌe nchri Juana, janchriꞌe naa xi ndatinꞌin Chuza, xi meꞌe kuancheꞌe xa xrée xi Herodes; ko kaxon ntiꞌa bakeꞌe nchri Susana ko ikaxin nchri bakingijna nchra ndo Jesús ko kuajon nchra ngeꞌe juine sen. ");
INSERT INTO pps_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Ko xejo kueya na̱, kui̱ꞌxi̱n na̱ kueya tjajna ko konchjiñeꞌe na̱ ngajin ndo Jesús. Meꞌe jeꞌe ndo beki ndo naa chijni: ");
INSERT INTO pps_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","―Naa xi bikenga tse̱e̱, ko kaxin tse̱e̱ kuitsinga ngandeꞌe chaꞌo. Ko kuatsinga chujni ko ngatjangi na̱ tse̱e̱. Ko kui̱i̱ kuxe juine ba tse̱e̱. ");
INSERT INTO pps_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Ko kaxin tse̱e̱ kuitsinga ngakjenꞌen ixro ko kuachrje ka, ko bangiꞌa ka ixi xroꞌan itjao ko inche chónda nueꞌe ka. ");
INSERT INTO pps_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Ko kaxin tse̱e̱ kuitsinga ti jii nta̱chaꞌa. Ko nta̱chaꞌa ícha bangi nta̱a̱. Meꞌe xrabaatja ka ko bangiꞌa tse̱e̱. ");
INSERT INTO pps_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ko ícha tse̱e̱ kuitsinga ngataꞌa inche jian, meꞌe bangi ka ko itsjé tse̱e̱ kuajon ka, xranchi naa ciento tse̱e̱ kuajon ngujngu ka. Jaña nichja ndo Jesús, ko tjumeꞌe séen ndachro ndo: ―Ngisen chao tinꞌen, tsinꞌen sen jian. ");
INSERT INTO pps_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Ko sen teyuu chrikao ndo Jesús juanchangi sen: ―¿Ngeꞌe xrondachro chijni juako ndo? ");
INSERT INTO pps_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Ko jeꞌe ndo Jesús ndachro ndo: ―Jaꞌanta kuayeꞌenta juachaxin tsienxinnta ti noaꞌinta, ti tetuanꞌan ndo Dio. Ko chujni kaxin, naꞌi. Méxin, janꞌan nichjaxin naa chijni, ixi maski tsikon na̱ ko tsinꞌen na̱, tsienxinꞌa na̱. ");
INSERT INTO pps_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","’Ko jiꞌi xrondachro chijni ntatjunta: Ti tse̱e̱ meꞌe chijnie ndo Dio. ");
INSERT INTO pps_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Tse̱e̱ kuitsinga ngandeꞌe chaꞌo meꞌe xrondachro ngisen tinꞌen chijnie ndo Dio. Ko Xixronꞌanxrée nchetjáñajin xa na̱ ko titikaonꞌa na̱, méxin, tsitjáña na̱. ");
INSERT INTO pps_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Tse̱e̱ kuitsinga ti jii ixro meꞌe xrondachro ngisen kuinꞌen chijnie ndo Dio ko bakeꞌe na̱ juaxruxin, ko séꞌa kuitikaon na̱ ixi kui̱i̱ juachjaon ko ngaxiton na̱. ");
INSERT INTO pps_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Tse̱e̱ kuitsinga ngataꞌa nta̱chaꞌa meꞌe xrondachro ngisen tinꞌen chijnie ndo Dio ko hora satji na̱ tjáñeꞌe na̱ ngeꞌe kuinꞌen na̱ ixi yaa na̱ juachjauen tomi ko ícha tjueꞌe na̱ ti juaxruxin, ko ncheꞌa na̱ ti tjaun ndo Dio. ");
INSERT INTO pps_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Ko tse̱e̱ kuitsinga ti inche indá xrondachro ngisen tayéꞌe chijnie ndo Dio ngaxinꞌin aséen na̱ ko titikaon na̱ ti ndachro ndo ko soji tjintee na̱. ");
INSERT INTO pps_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","*’Xroꞌan ngisen tsjaaka naa xroꞌi ko tsakeꞌe na̱ xroꞌi chringi naa ichi o̱ chringi nta̱a̱ tejuataꞌa na̱. Xrokonda tsakeꞌe na̱ xroꞌi noi ixi kain ni tixinꞌin nchia chao tsikon na̱ ti tingasáña. ");
INSERT INTO pps_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","*Xroꞌan ngeꞌe jimá tsonoxinꞌa, ko xroꞌan ngeꞌe imao tsonoaꞌani inaa nchakon ixi kain ngeꞌe tsonoxixin ixi xroꞌi. ");
INSERT INTO pps_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","*’Méxin, jaꞌanta tinꞌennta jian; ngisen ó noꞌe naa nchíín, ndo Dio tsingijna ndo tsonoꞌe sen ícha, ko ti ngisen xroꞌan noꞌe, ti jixraxaon na̱ ixi noꞌe na̱ kaxon meꞌe tsachrjeꞌe na̱. ");
INSERT INTO pps_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Tjumeꞌe janée ndo Jesús ko kaxin xi kichuu ndo kuiji sen ti jii ndo Jesús, ko juaꞌi konchjiñeꞌe sen ixi tsango itsjé chujni ste ntiꞌa. ");
INSERT INTO pps_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Ko tjumeꞌe naa xi kuindache xa ndo Jesús: ―Janáanta ko xi kichuunta ste sen nduja, ko nichjaꞌanta sen. ");
INSERT INTO pps_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Ko ndo Jesús ndachro ndo: ―Sen tinꞌen chijnie ndo Dio ko titikaon, sen meꞌe janána ko sen kichian. ");
INSERT INTO pps_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Naa nchakon ndo Jesús kuajinꞌin ndo naa nta̱barco ko ndache ndo sen teyuu chrikao ndo: ―Tsatsingatoꞌena ndalago. Ko tjumeꞌe sakjui sen. ");
INSERT INTO pps_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Ko jitji sen ngataon inda, ko jeꞌe ndo kuejua ndo. Ko tuinxin kui̱i̱ naa chrinto soji ko nta̱barco steyá sen kuaxi bikia nta̱a̱ inda ko tjaun nta̱a̱ xrojamangi nta̱a̱. ");
INSERT INTO pps_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Ko konchjiñeꞌe sen ti jii ndo ko juinchexingameꞌe sen ndo ko ndache sen ndo: ―¡Maestro, Maestro! ¡Tsenꞌenna ixi xrojamangi nta̱a̱ steyána ko xrokjoi̱nna inda! Ko jeꞌe ndo bingatjen ndo ko kuyakutee ndo chrinto ko inda ko tuinxin ndabakeꞌe nda. ");
INSERT INTO pps_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Ko ndo Jesús ndache ndo sen: ―¿Sonda chuntiaꞌintana? Ko jeꞌe sen xronka sen ko ndastetsjeko sen ko stendache kichuu sen: ―¿Ngisen jiꞌi ixi tetuenꞌen ndo chrinto soji ko inda, ko jeꞌe inda ko chrinto titikaon? ");
INSERT INTO pps_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Tjumeꞌe kuiji sen nunte ndatinꞌin Gadara ti jii tuenxin ndalago ngajinxin nunte Galilea. ");
INSERT INTO pps_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Ko ndo Jesús xingajinxin ndo nta̱barco ko tuinxin naa xi kuachrjexin tjajna ntiꞌa konchjiñeꞌe xa ngajin ndo Jesús. Ko xi meꞌe tsango sée kuachónda xa espíritue Xixronꞌanxrée. Ko xroꞌan manta jiá xa, ko jeꞌa nchia bakeꞌe xa; bakeꞌe xa ngakjenꞌen itjao̱ ti bajabaa na̱ ni tsikenꞌen. ");
INSERT INTO pps_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Hora bikon xa ndo Jesús, bakeꞌexin xa ntatuchiꞌin xa ngajin ndo ko kuyako xa ko ndachro xa: ―Jesús, chjenꞌen ndo Dio, ¿sonda nchexronkana? Tjanchaꞌana xroꞌan nchena̱na. ");
INSERT INTO pps_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Jaña ndachro xa ixi ndo Jesús tsiketuenꞌen ndo espíritue Xixronꞌanxrée tsachrjexin xa xi meꞌe. Ko ó sée espíritue Xixronꞌanxrée baketuenꞌen xa xi meꞌe ko bakichruaxin na̱ tutée xa ko itja xa ixi nochika, ko jeꞌe xa bakonchrindaon xa nochika ko espíritue Xixronꞌanxrée banchekinga xa chrikaꞌa ijna̱ ti xroꞌan chujni ste. ");
INSERT INTO pps_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Ko tjumeꞌe ndo Jesús juanchangiꞌe ndo xi meꞌe: ―¿Xranchi tiꞌian? Ko jeꞌe xi ndachro xa: ―Janꞌanna ndatinꞌinna Legión. Jaña ndachro xa ixi tsango itsjé espíritue Xixronꞌanxrée bakeꞌe ngaxinꞌin aséen xa. ");
INSERT INTO pps_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Ko kain espíritue Xixronꞌanxrée juancheꞌe ndo Jesús ixi xroxruanꞌa ndo satsji espíritu ti tuye yasoꞌe. ");
INSERT INTO pps_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Ko ijna̱ ntiꞌa steneña itsjé kuchinga, ko kain espíritue Xixronꞌanxrée juanchia ngajin ndo Jesús ixi jeꞌe ndo tsajon ndo juachaxin tixinꞌin kain espíritu meꞌe ngaxinꞌin kuchinga. Ko ndo Jesús kuajon ndo juachaxin. ");
INSERT INTO pps_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Ko kain espíritue Xixronꞌanxrée kuachrjexin xi meꞌe ko kuixinꞌin ngaxinꞌin kuchinga. Ko kain kuchinga binga ba ko kuitsingangi ba ti yasoꞌe jii ndalago ko kjunꞌen ba inda. ");
INSERT INTO pps_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Ko kain xi stetsjeꞌe xa kuchinga, bikon xa jaña konꞌen ba, ko jeꞌe xa tsango xronka xa ko binga xa kuindache xa ni tjajna ngeꞌe konꞌen ko kaxon kuindache xa ni ste ngataon ijngi. ");
INSERT INTO pps_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Ko kain ni meꞌe kui̱i̱ na̱ kuitsjeꞌe na̱ ngeꞌe konꞌen ntiꞌa. Ko hora kuiji na̱ ti jii ndo Jesús, bikon na̱ ntiꞌa jii xi kuachrjexin kain espíritue Xixronꞌanxrée. Jii xa tjenka tutée ndo Jesús, ko ó jiá xa manta, ko ndako xraxaon xa, ko kain na̱ xronka na̱. ");
INSERT INTO pps_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Ko kain na̱ bikon na̱ ngeꞌe konꞌen ntiꞌa ko chronga na̱ xranchi koxruenꞌen xi bachónda espíritue Xixronꞌanxrée. ");
INSERT INTO pps_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Méxin, kain ni nunte Gadara juancheꞌe na̱ ndo Jesús ixi satsjixin ndo ntiꞌa, ixi jeꞌe na̱ tsango xronka na̱. Méxin, ndo Jesús kuajinꞌin ndo nta̱barco ko sakjui ndo. ");
INSERT INTO pps_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Ko xi kuachrjexin kain espíritue Xixronꞌanxrée kuinóatée xa ixi xrokuajon ndo juachaxin tsikao ndo xa. Ko ndo Jesús kuetuenꞌen ndo xa tsituꞌe xa, ko ndachro ndo: ");
INSERT INTO pps_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","―Ikjan ndúya, ko tekiꞌé na̱ kain ngeꞌe juincheꞌe ndo Dio ngajian. Ko xi meꞌe sakjui xa ko bekiꞌe xa kain na̱ nguixin tjajna ti juincheꞌe ndo Jesús ngajin xa. ");
INSERT INTO pps_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Nchakon ikjan ndo Jesús tuenxin ndalago, kain ni ste ntiꞌa tsango chéꞌe na̱ ixi kuiji ndo Jesús, ixi kain na̱ stechónꞌen na̱ ndo. ");
INSERT INTO pps_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Ko tjumeꞌe kui̱i̱ naa xi ndatinꞌin Jairo, xi meꞌe baketuanꞌan xa niꞌngo judío ntiꞌa. Bakeꞌexin xa ntatuchiꞌin xa ngajin ndo Jesús ko kuinóatée xa ngajin ndo ixi xrokjui ndo ndoꞌa xa ");
INSERT INTO pps_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","ixi xjanchrichjeꞌen xa, xjan naakuaxon chónda xa, chónda xjan teyuu nano ko jiteꞌen xjan. Ko tjumeꞌe ndo Jesús sakjui ndo ndoꞌa xi Jairo ko tsango itsjé na̱ ruéꞌe na̱ ndo ko kuixintja na̱ ndo Jesús. ");
INSERT INTO pps_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Ko ngakjenꞌen kain chujni meꞌe ntiꞌa konchjiñeꞌe naa nchri baniꞌe nchra, teyuu nano níexin nchra jnié nchra, ko juinchexienxin nchra kain ti bachónda nchra ngajin xi nchexruan, ko ninaa xinchexruan juaꞌi juinchexruenꞌen nchra. ");
INSERT INTO pps_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Nchri meꞌe konchjiñeꞌe nchra tuenxin ndo Jesús ko itsé nchra ngandeꞌe mantoe ndo ko tuinxin kuíxin jnié nchra. ");
INSERT INTO pps_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Ko ndo Jesús juanchangi ndo: ―¿Ngisen itséna? Ko kain na̱ ndachro na̱ ixi xroꞌan ngisen itsé ndo. Méxin, ndo Pedro ko kain sen jitikao ndo ndachro sen: ―Maestro, kueya na̱ ste na̱ ngandajian ko sinteeto na̱, méxin, ¿sonda tjanchangia ngisen itsé? ");
INSERT INTO pps_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Ko ndo Jesús ndachro ndo: ―Xrojan ngisen itséna, ixi konóna juachaxin kuachrjexinna ixi koxruenxin naa ngisen. ");
INSERT INTO pps_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Ko nchri meꞌe bikon nchra konoꞌe ndo Jesús, ko konchjiñeꞌe nchra ti jii ndo ko jixranga nchra ko xrakon nchra, ko bakeꞌexin ntatuchiꞌin nchra tutée ndo Jesús. Ko ngatoxin ikon kain ni ste ntiꞌa ndachro nchra xranchi itsé nchra mantoe ndo Jesús ko xranchi tuinxin koxruenꞌen nchra. ");
INSERT INTO pps_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Ko tjumeꞌe ndo Jesús ndache ndo nchra: ―Jaꞌa koxruanꞌan ixi chuntiana. Jai juaxruxin satjia. ");
INSERT INTO pps_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Xrajinichja ndo Jesús, kui̱i̱ naa ngisen kui̱xi̱n ndoꞌa xi Jairo, xi baketuanꞌan niꞌngo ntiꞌa; ko ndache na̱ xa: ―Chjanꞌan ó kuenꞌen xjan; ítajonꞌa ixra̱ ngajin ndo maestro. ");
INSERT INTO pps_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Ko tjumeꞌe kuinꞌen ndo Jesús, ko ndache ndo xi Jairo: ―Xronkaꞌia; jeꞌo titikáoanna, chjanꞌan tsoxruenꞌen xjan. ");
INSERT INTO pps_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Ko ti kuiji sen ndoꞌa xi Jairo, ndo Jesús kuachrjendakaꞌo ndo, ndo Pedro ko ndo Jacobo, ko ndo Juan, kuixinꞌin sen nchia ko kao ndotée ko janée xjanchrichjan. ");
INSERT INTO pps_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Ko kain ni ste ntiꞌa stetsjanga na̱ ko yaxin na̱ xjan juachjaon. Ko ndo Jesús ndache ndo na̱: ―Tsjangaꞌinta; xjanchrichjan tsikenꞌa xjan; jeꞌo jijua xjan. ");
INSERT INTO pps_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Ko jeꞌe na̱ juanoa na̱ ndo Jesús, ixi kain na̱ noꞌe na̱ kuenꞌen xjan. ");
INSERT INTO pps_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Ko tjumeꞌe ndo Jesús itsé ndo itja xjan ko séen ndachro ndo: ―Jaꞌa xjanchrichjan, tingatjen. ");
INSERT INTO pps_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Ko jeꞌe xjan xechón xjan íjngo, ko tuinxin bingatjen xjan. Ko ndo Jesús kuetuanꞌan ndo xrochjée sen xjan sine xjan. ");
INSERT INTO pps_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Ko janée xjan ko ndotée xjan tsango xrakon sen, ko ndo Jesús kuetuenꞌen ndo na̱ ixi xroꞌan ngisen tsekiꞌe na̱ jaña konꞌen. ");
INSERT INTO pps_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Ko tjumeꞌe ndo Jesús kuetuanꞌan ndo tsonchjiñeꞌe sen teyuu chrikao ndo, ko kuajon ndo juachaxin ixi chao tsantsje sen kain espíritue Xixronꞌanxrée chónda na̱, ko sinchexrjuenꞌen sen ni niꞌe. ");
INSERT INTO pps_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Ko kuetuanꞌan ndo satsji sen sinchekuenꞌen sen na̱ kondee juachaxin tetuanꞌan ndo Dio ko sinchexrjuenꞌen sen ni niꞌe. ");
INSERT INTO pps_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Ko ndachro ndo: ―Xroꞌan ngeꞌe tikuꞌunta ti tsaanta chaꞌo, tikuꞌinta ntakuto, tikuꞌinta puxa, nutja, tomi ko tikuꞌinta yuu manta, jeꞌo manta rianta. ");
INSERT INTO pps_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Ko nchakon tsjasonta xrojan nchia tsixinꞌinnta ko tsituꞌanta ntiꞌa tsijija nchakon satsjixinnta tjajna meꞌe. ");
INSERT INTO pps_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","*Siá tsjasonta xrojan tjajna ko tsajonꞌa na̱ juachaxin tsinteenta ntiꞌa, jaꞌanta tachrjexinnta tjajna meꞌe, ko tontsjenganta inche yaa tutáanta, meꞌe tsjakoxinnta ixi ndo Dio tsjankataꞌa ndo ijie̱ ngajin ni tjajna meꞌe. ");
INSERT INTO pps_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Ko tjumeꞌe sakjui sen kain tjajna nchínchín, ko ndache sen na̱ chijni jian xranchi ndo Dio tsantsje ijie̱ chónda na̱ ko juinchexruenꞌen sen ni niꞌe. ");
INSERT INTO pps_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","*Xi Herodes, xi kuetuanꞌan ntiꞌa, konoꞌe xa kain ngeꞌe jian bancheꞌe ndo Jesús, ko jeꞌe xa tsango xronka xa, noeꞌa xa ngeꞌe xraxaon xa ixi kaxin na̱ ndachro na̱ ixi ó tsixechón xi Juan Bautista. ");
INSERT INTO pps_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Ko ikaxin na̱ ndachro na̱ ixi ndo kuachronga chijnie ndo Dio ó saꞌó, ndo Elías, konoxin íjngo, ko ikaxin na̱ ndachro na̱ ixi inaa ndo kuachronga chijnie ndo Dio kui̱i̱ ícha saꞌó, ko jai xechón ndo íjngo. ");
INSERT INTO pps_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Ko ndachro xi Herodes: ―Janꞌan kuetuanꞌan chrinjin jaa xi Juan; méxin, ¿ngisen xi jiꞌi ixi kui̱nꞌa̱n tsango itsjé ngeꞌe jian ncheꞌe xa? Ko xi Herodes tsango tjaun xa xrokuitsjeꞌe xa ndo Jesús. ");
INSERT INTO pps_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Ko tjumeꞌe ikjan sen xruanꞌan ndo Jesús ko bekiꞌe sen ndo kain ti juincheꞌe sen. Ko tjumeꞌe ndo Jesús sabikao ndo sen ti xroꞌan ngisen ste, tjenka tjajna Betsaida. ");
INSERT INTO pps_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Ko hora konoꞌe na̱ no jii ndo ko jeꞌe na̱ ruéꞌe na̱ ndo, ko ndo Jesús kuajon ndo juachaxin kuituꞌe na̱ ntiꞌa. Ko chronga ndo kondee juachaxin tetuanꞌan ndo Dio ko juinchexruenꞌen ndo kain ni niꞌe. ");
INSERT INTO pps_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Ko ó kóndo, konchjiñeꞌe sen teyuu chrikao ndo, ko ndachro sen: ―Ndachenta kain na̱ ixi satsji na̱ kaxin tjajna tjenka ntiꞌi, tseꞌna na̱ ti sine na̱ ko tsjokéꞌe na̱ ixi ntiꞌi xroꞌan ngeꞌe jii. ");
INSERT INTO pps_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Ko ndo Jesús ndache ndo sen: ―Jaꞌanta tájonnta ngeꞌe sine na̱. Ko jeꞌe sen ndachro sen: ―Xroꞌan ngeꞌe chondana, jeꞌo chondana naꞌó nutja ko yuu kuchee̱, ¿á tjaunnta ixi tsikeꞌnana ngeꞌe sine kain na̱? ");
INSERT INTO pps_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Ixi kain ni meꞌe, jeꞌo ni xi xranchi naꞌó mil chujni. Ko ndache ndo Jesús sen teyuu chrikao ndo: ―Ndachenta na̱ tsintee na̱ nunte, ngujngu yuukante na̱. ");
INSERT INTO pps_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Ko jaña juincheꞌe sen ko kuintee na̱ nunte kain na̱. ");
INSERT INTO pps_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Ko tjumeꞌe ndo Jesús kua ndo naꞌó nutja ko yuu kuchee̱ ko tsjeꞌe ndo ngajní, ko kuajon ndo juasie ndo ngajin ndo Dio. Ko konchrinjin ndo nutja ko kuchee̱ ko chjée ndo sen teyuu chrikao ndo. Ko jeꞌe sen konchjeya sen nutja ko kuchee̱, kuayéꞌe kain ni ste ntiꞌa. ");
INSERT INTO pps_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Ko kain na̱ juine na̱ ko kaon na̱ jian, ko juexin juine kain na̱, sen teyuu chrikao ndo Jesús juejo sen teyuu ntaxra tutuꞌo nutja tsixeꞌe. ");
INSERT INTO pps_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Naa nchakon ndo Jesús tsikachrjendáa ndo ko kuinichjeꞌe ndo ndo Dio, ko jikao ndo sen teyuu chrikao ndo, ko jeꞌe ndo juanchangiꞌe ndo sen: ―¿Ngeꞌe ndachro chujni, ngisen janꞌan? ");
INSERT INTO pps_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","*Ko jeꞌe sen ndachro sen: ―Kaxin na̱ ndachro na̱ ixi jaꞌanta ndo Juan Bautista; ko ikaxin na̱ ndachro na̱ ixi jaꞌanta ndo profeta Elías; ko ícha na̱ ndachro na̱ ixi jaꞌanta naa sen profeta tsixechón. ");
INSERT INTO pps_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","*Ko tjumeꞌe ndo Jesús juanchangiꞌe ndo sen: ―Ko jaꞌanta, ¿ngeꞌe ndachronta, ngisen janꞌan? Ko ndo Pedro ndachro ndo: ―Jaꞌanta ndo Cristo, chjenꞌen ndo Dio. ");
INSERT INTO pps_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Ko ndo Jesús tsango kuetuenꞌen ndo sen ixi xroꞌan chujni xrondache sen ngisen jeꞌe ndo. ");
INSERT INTO pps_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Ko tjumeꞌe ndo Jesús ndache ndo sen: ―Janꞌan, chjenꞌen ndo Dio, xjan jongíꞌe xranchi chujni, xrokonda tsango tangi sinchena na̱, ko kain xi tetuanꞌan niꞌngo, ko kain xitaana tetuanꞌan ko kain xi tjako ley, tsoñaona na̱. Ko naatsóñaxónna na̱, ko nchakon nínxin xroxechónna íjngo. ");
INSERT INTO pps_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","*Juexin ndachro ndo jiꞌi, ndache ndo kain ni ste ntiꞌa: ―Siá xrojan ngisen xroruaꞌna, xrokonda tsintuꞌe sen ti ícha tjueꞌe sen ko xroruaꞌna sen kain nchakon, maski tangi tsonꞌen sen. ");
INSERT INTO pps_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","*Ko ni tjaun xroꞌan tsonꞌen, sinchetjáña aséen na̱; ko ngisen tsenꞌen ixi titikaonna sen, sen meꞌe tsechón sen kain nchakon. ");
INSERT INTO pps_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","¿Ngeꞌe tsjacha na̱ siá xrochónda na̱ kain ngeꞌe jii ngataꞌa nunte ko sinchetjáña na̱ aséen na̱? ");
INSERT INTO pps_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Méxin, ngisen tosueꞌe ixi titikaonna sen ko chijni nichja, kaxon janꞌan, Chjenꞌen ndo Dio, xjan jongíꞌe xranchi chujni, xrondachrja̱n ixi chúxinꞌa sen nchakon tsikian ijié juachaxin ko chjiixro chónda Ndotána ko kain ángel neꞌe ndo. ");
INSERT INTO pps_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Nduaxin ntatjunta ixi kaxin ni ste ntiꞌi jai, xratsenꞌa na̱ tsikonja na̱ juachaxien ndo Dio. ");
INSERT INTO pps_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Kuatsinga ijní nchakon ti ndachro ndo Jesús kain jiꞌi, ko tjumeꞌe jeꞌe ndo kuajinꞌin ndo naa ijna̱ ixi xronichjeꞌe ndo ndo Dio ko bikao ndo ndo Pedro ko ndo Jacobo ko ndo Juan. ");
INSERT INTO pps_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Ko hora jinichjeꞌe ndo Jesús ndo Dio, ngayakon ndo Jesús kuindoxin ko ti jitsáa ndo ikjan xranchi chjiixro ixi tsango tóngíxin. ");
INSERT INTO pps_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Ko tjumeꞌe konoxin yuu sen stetjao ndo Jesús, ko sen meꞌe ndo Moisés ko ndo Elías. ");
INSERT INTO pps_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Ko nguixin ngandajin ti ste sen tsango chaxro bingasáña ko stetjao sen xranchi tsonꞌen ndo Jesús ko xranchi tsenꞌen ndo tjajna Jerusalén. ");
INSERT INTO pps_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Ko maski ndo Pedro ko sen stekao ndo tsango chjée sen kotachrin, jeꞌe sen stetsjeꞌe sen ko bikon sen juachaxin chónda ndo Jesús, ko bikon sen sen yuu jikao ndo. ");
INSERT INTO pps_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Ko hora saxrokjui sen, ndo Pedro ndache ndo ndo Jesús: ―Maestro, jian stena ntiꞌi. Sintáñana níi tsaꞌon nchíín; naa tsaꞌon jaꞌanta, ko naa tsaꞌon ndo Moisés, ko naa tsaꞌon ndo Elías. Ko ndo Pedro noeꞌa ndo ngeꞌe ndachro ndo. ");
INSERT INTO pps_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Ko xrajinichja ndo kui̱i̱ naa itjui̱ kuitsía sen ko xrakon sen ixi kuituꞌe sen ngakjenꞌen itjui̱. ");
INSERT INTO pps_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","*Ko tjumeꞌe ngakjenꞌen itjui̱ meꞌe kuinꞌen sen naa ngisen ndachro: ―Jiꞌi chjanꞌna tsango tjuaꞌa. Tinꞌennta ti ndachro xjan. ");
INSERT INTO pps_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Juexin nichja ndo Dio, bikon sen ndo Jesús jeꞌo ndo jii ndo ntiꞌa. Ko jeꞌe sen tenko sen, ko xroꞌan ngisen bekiꞌe sen ngeꞌe bikon sen. ");
INSERT INTO pps_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Ndúyaxin ti xingajinxin sen ijna̱, tsango itsjé na̱ jichónꞌen na̱ ndo Jesús ngatja chaꞌo. ");
INSERT INTO pps_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Ko naa xi jii ngakjenꞌen ni meꞌe nichja xa ko ndache xa ndo Jesús: ―Maestro, tinóatáana ixi tikitsjeꞌenta chjanꞌna ixi naakua xjan chonda ko niꞌe xjan. ");
INSERT INTO pps_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Chónda xjan espíritue Xixronꞌanxrée ko itsé xa xjan ko nchekoyako xa xjan, ko titsinga xjan ko tuchrjo ti̱ꞌxi̱n roꞌa xjan. Tsango ncheniꞌe xa xjan ko tsango chrjen tajanda xa xjan. ");
INSERT INTO pps_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Janꞌan ó kuinóatáana ngajin sen chrjikuꞌunta ixi xrokuantsje sen espíritu, ko juaꞌi kuantsje sen. ");
INSERT INTO pps_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Ko ndo Jesús ndachro ndo: ―¡Jaꞌanta chuntiaꞌintana ko titikaonꞌanta! ¿Ti ngisa xrokonda tsakeꞌe ngajinnta ko sintakuanꞌannta? Tikuunta chán ntiꞌi. ");
INSERT INTO pps_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Ti konchjiñeꞌe chán ti jii ndo Jesús, espíritue Xixronꞌanxrée meꞌe juinchekuendaa chán, ko juanka chán ngataꞌa nunte. Ko ndo Jesús kuyakutee ndo espíritu, ko meꞌe kuachrje espíritu ñaꞌi ko koxruenꞌen chán ko ndo Jesús kuajon ndo chán ngajin ndotée chán. ");
INSERT INTO pps_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Ko kain ni ste ntiꞌa tsango xronka na̱ ixi bikon na̱ juachaxin ijié chónda ndo Dio. Kain na̱ xrastexronka na̱ ixi ixra̱ ijié juincheꞌe ndo Jesús, ko tjumeꞌe jeꞌe ndo ndache ndo sen teyuu chrikao ndo: ");
INSERT INTO pps_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","―Tinꞌennta jian ti xrontatjunta, ko tjáñaꞌinta. Chujni xrotséna na̱ janꞌan, chjenꞌen ndo Dio, xjan jongíꞌe xranchi chujni, tsikaanna na̱ ti jii xi ñaꞌi. ");
INSERT INTO pps_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Ko jeꞌe sen kuienxinꞌa sen ngeꞌe ndachro ndo, ixi xrakuajonꞌa ndo Dio juachaxin xrokuienxin sen. Ko jeꞌe sen xrakon sen ko í juanchangíeꞌa sen ndo ngeꞌe xrondachro ti ndachro ndo. ");
INSERT INTO pps_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","*Ko tjumeꞌe sen teyuu chrikao ndo Jesús, juangíxin sen juao kichuu sen ixi ngisen ti jeꞌe sen ícha tetuanꞌan. ");
INSERT INTO pps_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Ko ndo Jesús konoꞌe ndo ngeꞌe xraxaon sen. Ko tjumeꞌe joa ndo naa chjan ko bakeꞌe ndo xjan tjenka ndo, ");
INSERT INTO pps_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","*ko ndache ndo sen: ―Ngisen tsayéꞌe ichjan jiꞌi ixi titikaonna sen; sen meꞌe tayéꞌe sen janꞌan kaxon. Ko ngisen tsayéꞌena janꞌan, kaxon tsayéꞌe ngisen xruanꞌanna. Méxin, ngisen ícha tjinteꞌa ngakjenꞌennta, sen meꞌe ícha tjintee sen ti tetuanꞌan ndo Dio. ");
INSERT INTO pps_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Ko tjumeꞌe ndo Juan ndache ndo ndo Jesús: ―Maestro, janꞌanna bikona naa xi ixi juachaxiannta jitantsje xa espíritue Xixronꞌanxrée; ko janꞌanna ntatjanna xa ixi ísincheꞌa xa jaña, ixi jeꞌe xa chrjikoꞌiana xa. ");
INSERT INTO pps_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Ko ndachro ndo Jesús: ―Tingakuenꞌanta ni meꞌe, ixi ni ningakonaꞌina, jeꞌe na̱ tsingijnanta na̱. ");
INSERT INTO pps_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Ko tjumeꞌe konchjiñeꞌe nchakon satsji ndo Jesús nio ti jii ndotée ndo, ko xraxaon ndo itsji ndo tjajna Jerusalén. ");
INSERT INTO pps_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Jeꞌe ndo xruanꞌan ndo kaxin sen kuitaonxin sen chaꞌo saꞌó, ko sen meꞌe ikjui sen naa tjajna nunte Samaria bijée sen naa nchia ti tsjokéꞌe ndo Jesús ko kao jeꞌe sen. ");
INSERT INTO pps_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Ko ni samaritano juaꞌi kuajon na̱ juachaxin ntiꞌa ixi ó noꞌe na̱ ixi ndo Jesús satji ndo tjajna Jerusalén. ");
INSERT INTO pps_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Hora konoꞌe ndo Jacobo ko ndo Juan ixi ni samaritano juaꞌi tsajon na̱ juachaxin, jeꞌe sen ndache sen ndo Jesús: ―¿Nchána, á tjaunnta ixi tsjanchiana xroxingajinxin xroꞌi ngajní sinchetjáña kain ni meꞌe xranchi juincheꞌe ndo profeta Elías ó saꞌó? ");
INSERT INTO pps_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Ko tjumeꞌe ndo Jesús ngatjia tsjeꞌe ndo sen, ko kuyakutee ndo sen, ko ndachro ndo: ―Jaꞌanta noaꞌinta ngixeꞌe espíritu chondanta. ");
INSERT INTO pps_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Ixi janꞌan, chjenꞌen ndo Dio, xjan jongíꞌe xranchi chujni, juiꞌa ixi sintatjáña chujni. Naꞌi. Janꞌan juiꞌi ixi tsantsjen ijie̱ chónda na̱ ixi tsechón na̱ kain nchakon. Ko tjumeꞌe sakjui sen inaa tjajna. ");
INSERT INTO pps_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Nchakon stetji sen ngatja chaꞌo, naa xi ndache xa ndo Jesús: ―Janꞌan tjaꞌon xroruaꞌanta nguixin ti no satsjinta. ");
INSERT INTO pps_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Ko ndo Jesús ndache ndo xi meꞌe: ―Kain kutuunta chónda ba tjaue tixinꞌin ba, ko kain kuxe chónda ba kakée ba, ko janꞌan, chjenꞌen ndo Dio, xjan jongíꞌe xranchi chujni, chondaꞌi ti no tsarichrin. ");
INSERT INTO pps_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Ko íjngo ndo Jesús ndache ndo xi meꞌe: ―Jaꞌa ruaꞌna̱na. Ko xi meꞌe juateꞌe xa ndachro xa: ―Tájonnta juachaxin tsijabaja ndotána. ");
INSERT INTO pps_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Ko juatingíexin ndo Jesús ndachro ndo: ―Tintuꞌenta chujni tsikenꞌen tsjabaa kichuu na̱; ko jaꞌanta itjia ko ndachenta chujni xranchi jii juachaxin tetuanꞌan ndo Dio. ");
INSERT INTO pps_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Ko tjumeꞌe inaa xi ndache xa ndo Jesús: ―Janꞌan tjaꞌon xroruaꞌanta; tintunanta xrontatjan sen nía. ");
INSERT INTO pps_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Ko ndachro ndo Jesús: ―Ngisen teka ninge, ko ikjan sen tsjeꞌe sen, sen meꞌe juaꞌi sincheꞌe ixra̱ ti tetuanꞌan ndo Dio. ");
INSERT INTO pps_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Tjumeꞌe ndo Jesús kuincheꞌe ndo níikán ko te chujni, ko jeꞌe ndo xruanꞌan ndo sen, yuyu sen, tsitaon sen satsji sen kain tjajna ko nguixin ti no tjaun ndo xrokjui ndo. ");
INSERT INTO pps_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","*Ko ndachro ndo: ―Nduaxin ntatjunta, ícha tsikoña noa jai, ko sen sincheꞌe ixra̱ tsjéꞌa sen. Méxin tinóatáanta ngajin nchée nunte xroxruanꞌan ndo itsjé sen sincheꞌe ixra̱. ");
INSERT INTO pps_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","*Satjinta ixi janꞌan xruanꞌannta itsjinta xranchi kutuchjon ngakjenꞌen kundanixra. ");
INSERT INTO pps_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Tikuꞌinta bolsa, tomi, kate ko xroꞌan ngisen chje̱ꞌénta juajna ngatja chaꞌo. ");
INSERT INTO pps_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Ti tsjasonta naa nchia, saꞌó tájonnta juajna ko ndachronta: “Juaxruxin tsakeꞌe ni ste nchia jiꞌi.” ");
INSERT INTO pps_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Ko siá xrojan ni nchia tikinixin tsayéꞌe na̱ juaxruxin, meꞌe ícha juaxruxin tsayéꞌe na̱ xranchi ndachronta; ko siá naꞌi, juaxruxin meꞌe xrokjan ngajinnta. ");
INSERT INTO pps_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","*Ti tsjasonta naa tjajna, tituanꞌanta jeꞌo naakua nchia ko intenta ko tinꞌinnta ti xrotjáanta ni nchia meꞌe, ixi ngisen ncheꞌe ixra̱ tikinixin xroxengeꞌe na̱ iꞌna̱. Ko tjiꞌanta naa ko inaa nchia. ");
INSERT INTO pps_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Ti tsjasonta naa tjajna ko ni ste ntiꞌa jian tsiyaꞌanta na̱, intenta kain ngeꞌe xrotjáanta na̱. ");
INSERT INTO pps_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Nchexrueꞌennta ni niꞌe ste tjajna meꞌe, ko ndachenta na̱: “Í kjínꞌa jiti̱i̱ juachaxin tsetuanꞌan ndo Dio.” ");
INSERT INTO pps_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","*Ko siá tsjasonta naa tjajna ko tsayaꞌinta na̱ jian, jaꞌanta tachrjenta chaꞌo ko ndachronta: ");
INSERT INTO pps_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","*“Inche tjajnánta itsé tuténa̱na, tontsjengana ixi tsjakoxinna ixi jaꞌanta ko janꞌanna chondaꞌina ngeꞌe xrotsjeꞌena ixi jaꞌanta kuitikaonꞌanta ndo. Ko tonoꞌanta ixi juachaxin tetuanxin ndo Dio ó kjínꞌa jii juachaxin.” ");
INSERT INTO pps_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","*Janꞌan ntatjunta nchakon tsjexin nunte xasintajni ícha tangi tsonꞌen ni tjajna meꞌe ixi ngeꞌe konꞌen ni tjajna Sodoma ó sée. ");
INSERT INTO pps_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","’¡Tsango tangi tsonꞌannta jaꞌanta ni tjajna Corazín! ¡Ko tsango tangi tsonꞌannta jaꞌanta, ni tjajna Betsaida! Ixi siá ti ijié ngeꞌe juintaꞌa ngajinnta ntiꞌi xrokonꞌen ngajin ni tjajna Tiro ko tjajna Sidón, ni meꞌe ó sée xrokuindoxin na̱ ti ndakoꞌa juincheꞌe na̱ ko xrotsjanga na̱. Ko xrokueyá na̱ manta tiie ko xrobakeꞌe na̱ ntesokiꞌi ngataꞌa jaa na̱. ");
INSERT INTO pps_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Méxin nchakon tsjexin nunte ntiꞌi, ícha tangi tsonꞌannta jaꞌanta ixi ti tsonꞌen ni tjajna Tiro ko tjajna Sidón. ");
INSERT INTO pps_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ko jaꞌanta tjajna Capernaum, ¿á xraxaonnta itsjinta ti jii ndo Dio? Naꞌi, jeꞌa jaña tsonꞌen, jaꞌanta xroxingajinnta ti jii xroꞌi xrochexin chujni titikaonꞌa. ");
INSERT INTO pps_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","*Ko ndachro ndo Jesús: ―Ngisen tsitikaon ti xrondachro jaꞌanta, kaxon tsitikaonna na̱ janꞌan. Ko ngisen tsitikaonꞌa ti xrondachronta, kaxon tsitikaonꞌana na̱. Ko chujni tsitikaonꞌa na̱ janꞌan, kaxon tsitikaonꞌa na̱ ngisen xruanꞌanna juiꞌi. ");
INSERT INTO pps_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Tjumeꞌe ikjan sen níikán ko te chujni ko tsango juaxruxin ste sen, ko ndachro sen: ―Ncháana̱na, kain espíritue Xixronꞌanxrée titikaonna hora nichjana ixi juachaxiannta. ");
INSERT INTO pps_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Ko ndachro ndo Jesús: ―Jaán, janꞌan bikon xranchi xingajinxin Xixronꞌanxrée ngajní xranchi naa tóngíxin. ");
INSERT INTO pps_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Janꞌan tjáꞌanta juachaxin tsingatjanginta kunchee ko kulantajoon, ko tsixinteꞌanta ti ñaꞌi, ko xroꞌan ngeꞌe tsonꞌannta. ");
INSERT INTO pps_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Ko takeꞌanta juaxruxin ixi espíritue Xixronꞌanxrée titikaon ngajinnta. Ícha juaxruxin tinteenta ixi xranchi tinꞌinnta ó jitaxin ngajní. ");
INSERT INTO pps_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Ko hora meꞌe Espíritue ndo Dio kuajon ngajin ndo Jesús juaxruxin ko chéꞌe ndo nichjeꞌe ndo ndotée ndo jii ngajní ko ndachro ndo: ―Tajon juasaya ngajin jaꞌanta Ndotána, Nchée nunte ko ngajní, ixi kuajonnta juachaxin ixi ngisen noeꞌa xrokuienxin na̱ ngeꞌe kondee ngajní ko juinchenoeꞌanta ni tsango noꞌe ko ni tsango tienxin. Jaña, juincheꞌe jaꞌanta Ndotána ixi jaña tjaunnta. ");
INSERT INTO pps_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","*Ko nichjeꞌe ndo sen ntiꞌa ko ndachro ndo: ―Ndotána chjána juachaxin ixi tetuanꞌan kain ngeꞌe. Xroꞌan ngisen noꞌe ngisen chjenꞌen jeꞌe ndo. Jeꞌo Ndotána chúxin ndo ngisen chjenꞌen ndo. Ko xroꞌan ngisen chúxin ngisen jeꞌe ndo, jeꞌo chjenꞌen ndo, ko janꞌan tinchaꞌa ngisen tjaun xrochuxin Ndotána. ");
INSERT INTO pps_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Ko tjumeꞌe ndo Jesús tsjeꞌe ndo sen teyuu chrikao ndo ko jeꞌo sen ndache ndo sen: ―Juaxruxin ste ni bikonxin ixi ikon ngeꞌe bikon jaꞌanta. ");
INSERT INTO pps_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Ntatjunta ixi itsjé sen kuanichja sen chijnie ndo Dio ko itsjé sen rey tjaun sen xrobikon sen ti bikonta, ko bikonꞌa sen. Ko tjaun sen xrokuinꞌen sen xranchi ritinꞌennta jai, ko kuienꞌa sen. ");
INSERT INTO pps_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","*Ko tjumeꞌe naa xi tjako ley tjajna Israel bingatjen xa nichjeꞌe xa ndo Jesús ixi tjaun xa tsonoꞌe xa á nduaxin noꞌe ndo Jesús, ko juanchangi xa ndachro xa: ―Maestro, ¿ingeꞌe sintaꞌa janꞌan ixi tsarichón kain nchakon? ");
INSERT INTO pps_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Ko ndachro ndo Jesús: ―¿Ngeꞌe jitaxin chijnie ndo Dio? ¿Ngeꞌe tienxian? ");
INSERT INTO pps_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Ko jeꞌe xa ndachro xa: ―Ley ndachro: “Tjueꞌenta Ncháanta ndo Dio ixi nchijíi asáanta, ko nchijíi jaꞌanta ko nchijíi ti xraxaonxinnta; ko tjueꞌenta ni kichuunta xranchi tjueꞌenta asáanta.” ");
INSERT INTO pps_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Ko tjumeꞌe ndo Jesús ndachro ndo: ―Chao ndachrua. Siá jaꞌa sincheꞌe jiꞌi, tsechón asáan kain nchakon. ");
INSERT INTO pps_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Ko xi tjako ley tjaun xa xrojuakoxin xa ixi ícha jian noꞌe xa, méxin ndache xa ndo Jesús íjngo: ―¿Ngisen ni kichuuna? ");
INSERT INTO pps_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Ko tjumeꞌe ndachro ndo Jesús: ―Naa xi kui̱xi̱n xa tjajna Jerusalén jitji xa tjajna Jericó, ko ngatja chaꞌo bingakonꞌen xa kaxin xicheꞌe, ko kueꞌe na̱ xa kain ngeꞌe chónda xa ko kain ti jitsáa xa, ko juaya na̱ ngajin xa, xranaáxrokóñaxón na̱ xa. Ko tjumeꞌe sakjui na̱. ");
INSERT INTO pps_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Ko tjumeꞌe naa xitaana judío jitji xa xrajeꞌo chaꞌo, ko bikon xa jitsinga xi meꞌe, ko xitaana konchjino xa ko sakjui xa. ");
INSERT INTO pps_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Ko kaxon no ntiꞌa jitatsinga naa xi levita, ko bikon xa xi jitsinga, ko kaxon konchjino xa. ");
INSERT INTO pps_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Ko kaxon ntiꞌa jitji naa xi kui̱xi̱n nunte Samaria, ko bikon xa jitsinga xi judío, ko jeꞌe xa bikonóeꞌe xa xi meꞌe. ");
INSERT INTO pps_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Ko konchjiñeꞌe xa tjenka xa, ko juinchexruenꞌen xa ixi aceite ko vino kain ti no tsikoniꞌe xa, ko kuetsía xa jian ti no tsikoniꞌe. Ko tjumeꞌe juincheketaꞌa xa xi kuntajnoé xa ko sabikao xa xi niꞌe naa nchia tjokéexin na̱, ko ntiꞌa jeꞌe xa kuayakonꞌen xa xi niꞌe. ");
INSERT INTO pps_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Ko nchakon sakjui xa, kuantsje xa yuu tomi ko juenga xa iꞌna̱ ngajin xi ndoꞌa, ko ndachro xa: “Tayakonꞌén xi jiꞌi, ko siá sinchexienxian ícha tomi ixi jeꞌe xa, janꞌan tsjengaꞌa ꞌna̱ nchakon xrokjanna.” ");
INSERT INTO pps_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Méxin ndachijiana, ¿ngisen ti níi xi jiꞌi nduaxin tjueꞌe xa xi juincheniꞌe xicheꞌe? ");
INSERT INTO pps_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Ko xi tjako ley ndachro xa: ―Xi bikonóeꞌe xi niꞌe. Ko tjumeꞌe ndachro ndo Jesús: ―Méxin jaꞌa kaxon itjia ko ncheꞌe jaña. ");
INSERT INTO pps_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","*Tjumeꞌe ndo Jesús sakjui ndo, ko kuiji ndo naa tjajna nchíín. Ntiꞌa jii naa jan ndatinꞌin Marta ko kuajon jan juachaxin kuituꞌe ndo ndoꞌa jan. ");
INSERT INTO pps_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Ko jeꞌe jan Marta chónda jan naa jan kichuu jan ndatinꞌin María. Ko jeꞌe jan María bakeꞌe jan tjenka tutée ndo Jesús stetinꞌen jan ngeꞌe jindachro ndo. ");
INSERT INTO pps_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Ko jan Marta tsango xraxaon jan sinchekonchjian jan ngeꞌe sine sen ko chónda jan itsjé xra̱, méxin konchjiñeꞌe jan ngajin ndo Jesús ko ndachro jan: ―¿Nchána, á xraxaonꞌa ixi jan kichuuna tintuna jan janꞌon rintaꞌa kain ixra̱? Ndache jan tsingijnana jan. ");
INSERT INTO pps_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Ko ndo Jesús ndache ndo jan Marta: ―Marta, Marta, jaꞌanta tsango yaanta juachjaon ixi kain ixra̱ chondanta, ");
INSERT INTO pps_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","ko jii naakua ngeꞌe tsango tjintee. Ko jan María kuitja jan ngeꞌe ícha jian, ko xroꞌan ngisen tsantsjeꞌe jan jiꞌi. ");
INSERT INTO pps_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Naa nchakon ndo Jesús jinichjeꞌe ndo ndotée ndo, ndo Dio, ko juexin nichja ndo, tjumeꞌe naa sen chrikao ndo ndachro sen: ―Nchána, nchekuannaninta xranchi xronichjaꞌana ndo Dio xranchi ndo Juan juakoꞌe ndo chujnie ndo. ");
INSERT INTO pps_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Ko ndachro ndo Jesús: ―Nchakon nichjeꞌenta ndo Dio, ndachronta: Ndotáina Dio ritjennta ngajní, tsango tjúá jaꞌanta. Jaꞌanta tetuanꞌannta ngajinna. Ncheꞌenta xranchi tjaunnta ngataꞌa nunte ntiꞌi, xranchi ncheꞌenta ngajní. ");
INSERT INTO pps_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Ko jaꞌanta tájonnta nutja sinena kain nchakon. ");
INSERT INTO pps_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Ko ncheméꞌenta kain ti ndakoꞌa ntaꞌana, xranchi janꞌanna tjáñana̱na ti ndakoꞌa juinchena̱na na̱. Tájonꞌanta juachaxin ngajin Xixronꞌanxrée ixi sincheꞌe xa tsitexinna ti ndakoꞌa. ");
INSERT INTO pps_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Ko kaxon ndachro ndo Jesús: ―Takeꞌkona ixi naa jaꞌanta chondanta naa xi tjentonta, ko ngusine tiie xrokjuinta ndoꞌa xa ko xrondachenta xa: “Amigo, nchekjenna níi nutja, ");
INSERT INTO pps_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","ixi kui̱i̱ naa xi chúxin, kui̱xi̱n xa ikjín, ko kuiji xa nía ko janꞌan xroꞌan chonda xrotjáꞌa xa.” ");
INSERT INTO pps_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Ko siá tsjateꞌe xi jii ngaxinꞌin nchia xrondachro xa: “Chjánaiꞌana ixra̱; ó jijeꞌe̱ nchia ko chjanꞌna ko janꞌan ó tsintechrina; juaꞌi tsaya xrotjáꞌa ngeꞌe.” ");
INSERT INTO pps_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Ko ntatjunta siá chroꞌa xa tsaya xa xrotjáanta xa ngeꞌe tjaunnta maski tjentonta xa, tsaya xa xrotjáanta xa kain ngeꞌe xrokondaꞌanta ixi ítjaunꞌa xa ícha xrokuiyeꞌenta xa. ");
INSERT INTO pps_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Méxin, janꞌan ntatjunta: Tjanchianta ko ndo Dio tsajon ndo; tjéenta ngeꞌe ko tsinchíinta; tinganta nta̱chja, ko tsantjeꞌe ndo. ");
INSERT INTO pps_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Ixi ngisen tjanchia ngeꞌe, tsayéꞌe sen; ko ngisen tjée, sen meꞌe tsitja sen; ko ngisen tinga nta̱chja, xitjeꞌe̱ nta̱chja. ");
INSERT INTO pps_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","’¿Á xrojan jaꞌanta chondanta chjanꞌanta ko tjanchia xjan nutja, á xrochjeꞌénta xjan naa ixro? O̱, ¿tjanchia xjan kuchee̱ ko xrochjeꞌénta xjan naa kunchee? ");
INSERT INTO pps_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","¿O̱ tjanchia xjan joja ko xrochjeꞌénta xjan naa kuntanchia? ");
INSERT INTO pps_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Méxin, siá jaꞌanta maski jianꞌinta noꞌanta chje̱ꞌénta chjanꞌanta ngeꞌe jian, ¡ícha Ndotáina ndo Dio jii ngajní tsajon ndo Espíritue ndo ngajin sen tsjancheꞌe ndo! ");
INSERT INTO pps_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Naa nchakon ndo Jesús kuantsje ndo naa espíritue Xixronꞌanxrée tsijinchenosin naa xi. Ko hora kuachrje espíritue Xixronꞌanxrée, jeꞌe xi chao nichja xa. Tjumeꞌe kueya ni ste ntiꞌa xronka na̱ ixi jaña juincheꞌe ndo Jesús. ");
INSERT INTO pps_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","*Ko kaxin na̱ ndachro na̱: ―Xi jiꞌin tantsje xa espíritue Xixronꞌanxrée ixi chónda xa juachaxien Beelzebú, meꞌe Xixronꞌanxrée, xi tetuenꞌen kain espíritu ñaꞌi. ");
INSERT INTO pps_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","*Ko ikaxin na̱ tjaunna na̱ xrotsjeꞌe na̱ á nduaxin noꞌe ndo Jesús, méxin juancheꞌe na̱ ndo xrojuincheꞌe ndo naa ixra̱ ijié ixi juachaxien ndo Dio jii ngajní. ");
INSERT INTO pps_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Ko jeꞌe ndo noꞌe ndo ngeꞌe stexraxaon na̱, ko ndachro ndo: ―Xrojan tjajna jeꞌa naxrajeꞌo xraxaon ni tjajna meꞌe ko te̱ꞌto̱ kichuu na̱, ndatsitjáña, ko ni ste naa nchia, siá jeꞌa naxrajeꞌo xraxaon na̱, kaxon juaꞌi tsintee na̱. ");
INSERT INTO pps_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Jaña kaxon, siá Xixronꞌanxrée te̱to̱kaꞌo xa ni kichuu xa, tsitjáña juachaxin chónda xa. Jaꞌin ndachrja̱n, ixi jaꞌanta ndachronta ixi janꞌan tantsjexin espíritue Xixronꞌanxrée ixi juachaxien xa. ");
INSERT INTO pps_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Ko siá jaña xrokjui, ¿ngisen chjée ni chrjikuꞌu jaꞌanta juachaxin tsantsje na̱ espíritu ñaꞌi? Méxin, jeꞌe na̱ xrondachro na̱ ndakoꞌa jii ngeꞌe stexraxaonnta. ");
INSERT INTO pps_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Ko siá janꞌan tantsjexin espíritue Xixronꞌanxrée juachaxien ndo Dio, meꞌe xrondachro ixi ti tetuanꞌan ndo Dio ó kui̱i̱ ngajinnta. ");
INSERT INTO pps_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","’Nchakon naa xi tsanga yaa xa ntatjo ko jindaa xa ndoꞌa xa, xroꞌan ngeꞌe tsitjáña. ");
INSERT INTO pps_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Ko nchakon ti̱i̱ inaa xi ícha tsanga ko tse̱to̱kaꞌo xa xi nchée nchia ko tsjacha xa, ko tsantsjeꞌe xa kain chika yama xi ndoꞌa, ko satsjikao xa kain ngeꞌe chónda xi ndoꞌa ko tsonchjeya ngajin ni chúxin xa. ");
INSERT INTO pps_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","*’Ngisen titikaonꞌana janꞌan, ni meꞌe ningakonna; ko ngisen tingijnaꞌi ixra̱ ntaꞌa, ni meꞌe tingakonꞌenna. ");
INSERT INTO pps_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","’Ko naa espíritue Xixronꞌanxrée kuachrjexin aséen naa chujni, satji ti jii nunte xema tijée no tsjokéꞌe. Ko kuitjaꞌi ti no tsjokéexin, jeꞌe espíritu jixraxaon: “Janꞌan xrokjanna nía ti kuachrjexin.” ");
INSERT INTO pps_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Ko nchakon ikjan espíritue Xixronꞌanxrée, tjumeꞌe tixinꞌin aséen chujni ti kuachrjexin, ixi bikon xa ni meꞌe ste na̱ xranchi naa nchia tsikajon na̱ ko chaxro tsjeꞌe. ");
INSERT INTO pps_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Ko tjumeꞌe espíritue Xixronꞌanxrée tiruéꞌe ya̱to̱ espíritu ícha ñaꞌi, ko kain espíritu tixinꞌin ngaxinꞌin aséen ni meꞌe. Ko tjumeꞌe ícha tangi tonꞌen na̱ ixi saꞌó. ");
INSERT INTO pps_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Ko ndo Jesús jinichja ndo kain jiꞌi, ko tjumeꞌe naa nchri ste ngakjenꞌen na̱ ntiꞌa, nichja nchra ndachro nchra séen: ―¡Tsango juaxruxin jii nchri juintajongíꞌa ko juintakangia! ");
INSERT INTO pps_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Ko ndachro ndo Jesús: ―¡Ícha juaxruxin tsintee chujni tinꞌen ngeꞌe ndachro ndo Dio ko titikaon! ");
INSERT INTO pps_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","*Tjumeꞌe itsjé na̱ konkueya na̱ ngandajin ndo Jesús, ko jeꞌe ndo juangíxin nichja ndo ko ndachro ndo: ―Kain ni ste jai, jeꞌe na̱ ñaꞌi na̱ ko tjanchia na̱ tsikon na̱ naa ngeꞌe ijie̱; ko xroꞌan ngeꞌe sintaꞌa; jeꞌo ngeꞌe konꞌen ndo profeta Jonás, ndo kuachronga chijnie ndo Dio saꞌó. ");
INSERT INTO pps_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Xranchi konoxin ndo Jonás ngajin ni kuintee tjajna Nínive ixi xrokuienxin na̱, jaña kaxon konoxinna janꞌan, Chjenꞌen ndo Dio, xjan jongíꞌe xranchi chujni, ixi tsikon kain ni jii jai. ");
INSERT INTO pps_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Nchakon tsoña̱ ijiée kain ni ste jai, nchri reina tsiki̱ꞌxi̱n naa nunte ícha níjin tsingatjen nchra ko tsjankataꞌa nchra ijie̱ ni ste jai ixi nchri reina meꞌe tsiki̱ꞌxi̱n tsango ikjín ixi xrokuinꞌen nchra ti juako ndo Salomón. Ko jai ntiꞌi ritjén janꞌan ngajinnta ko ícha chonda juachaxin ixi juachaxin kuachónda ndo Salomón. ");
INSERT INTO pps_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ko ni kuintee tjajna Nínive kaxon tsingatjen na̱ nchakon tsoña̱ ijie̱ ngajin kain chujni, ko tsjankataꞌa na̱ ijie̱ ni ste jai ixi kain ni tjajna Nínive kuindoxin na̱ ko kuintuꞌe na̱ ijie̱ kuachónda na̱ nchakon kuinꞌen na̱ chijnie ndo Dio tsichronga ndo Jonás ó sée. Ko jai ntiꞌi ritjén janꞌan ngajinnta ko ícha chonda juachaxin ixi juachaxin kuachónda ndo Jonás. ");
INSERT INTO pps_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","*’Xroꞌan ngisen tjaaka naa xroꞌi ko tsemá sen xroꞌi meꞌe, ko kaxon takeꞌa na̱ xroꞌi ngaxinꞌin naa nta̱a̱. Noi takeꞌe na̱ xroꞌi ixi kain ni tixinꞌin nchia tsikon na̱ ti tingasáña. ");
INSERT INTO pps_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Jaña ikonni xranchi naa xroꞌi tingasáña cuerpoeni. Méxin, siá jian ikonnta, kaxon nguixin cuerpoanta tingasáña. Ko siá naꞌi, jianꞌa ikonnta, kaxon nguixin cuerpoanta naxixeꞌe jii. ");
INSERT INTO pps_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Tsjeꞌenta jian ixi á chao jii xroꞌi chondanta, á jeꞌa ti naxixeꞌe stenta. ");
INSERT INTO pps_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Méxin, siá nchijíi cuerpoanta chónda ti tingasáña, ko jeꞌa tuꞌo chónda naxixeꞌe, jaña nchijíinta jian tingasáña xranchi xrochondanta naa xroꞌi chaxro tingasáña. ");
INSERT INTO pps_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Ndo Jesús juexin ndachro ndo kain jiꞌi, tjumeꞌe naa xi fariseo kuinóatée xa ngajin ndo Jesús ixi itsji ndo ndoꞌa xa sinekaꞌo xa ndo. Tjumeꞌe ikjui ndo Jesús ndoꞌa xa ko kuixinꞌin ndo ko bakeꞌe ndo ti jii mesa. ");
INSERT INTO pps_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Ko jeꞌe xi fariseo xrakon xa ixi bikon xa ixi ndo Jesús bakeꞌe ndo juine ndo ko kontiꞌa ndo inda itja ndo xranchi kuancheꞌe kain ni judío. ");
INSERT INTO pps_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Ko ndo Jesús ndachro ndo: ―Jaꞌanta xi fariseo nchetjúánta tuenxin vaso ko laato, ko ti ngaya asáanta jikaon kain ti chjuyaꞌanta ko ñaꞌinta. ");
INSERT INTO pps_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","¡Jaꞌanta nintanta! ¿Á noaꞌinta ixi ngisen juinchekonchjian cuerpo, kaxon juinchekonchjian ngaxinꞌin cuerpo? ");
INSERT INTO pps_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Siá ixi nchijíi asáanta chje̱ꞌénta ni nóa ngeꞌe chondanta, kaxon jaña nchijíi asáanta tsontjúá. ");
INSERT INTO pps_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","’¡Tsango tangi tsonꞌannta jaꞌanta fariseonta! Ixi jaꞌanta chje̱ꞌénta ndo Dio ti texin parte ka menta ko kain kaxroan, ika ko itu ineni ko ncheꞌanta ngeꞌe jian xrojuincheꞌenta ko tjaoꞌanta ndo Dio, méxin chao xrochjeꞌénta ndo Dio ngeꞌe chondanta ko kaxon xrotjáñaꞌinta sincheꞌenta kain ngeꞌe jian. ");
INSERT INTO pps_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","’¡Tsango tangi tsonꞌannta, jaꞌanta fariseonta! Jaꞌanta tjaunnta tsayeꞌenta xitaon ícha chaxro ngaxinꞌin niꞌngo, ko tjaunnta ixi kain na̱ xrotjáanta juajna ngatja chaꞌo. ");
INSERT INTO pps_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","’¡Tsango tangi tsonꞌannta jaꞌanta xratjakonta ley ko jaꞌanta fariseonta ixi jaꞌanta ncheꞌanta xranchi ndachronta! Ixi jaꞌanta xranchi tuye tsixrabaa ni tsikenꞌen stenta ko tikonꞌa na̱ tuye meꞌe ko taꞌtu na̱ tuye ko noeꞌa na̱ ixi ntiꞌa tsixrabaa chujni. ");
INSERT INTO pps_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Ko tjumeꞌe naa xi tjako ley ndache xa ndo Jesús: ―Maestro, ti ndachronta jaña, xranchi janꞌanna tuyakutéentana. ");
INSERT INTO pps_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Ko ndachro ndo Jesús: ―¡Kaxon jaꞌanta tsango tangi tsonꞌannta, jaꞌanta xro tjakonta ley! Ixi jaꞌanta tetuenꞌennta na̱ sincheꞌe na̱ ngeꞌe tsango tangi ko juaꞌi sincheꞌe na̱ meꞌe. Ko jaꞌanta tingijnaꞌinta na̱ sincheꞌe na̱ kain ti tetuanꞌannta. ");
INSERT INTO pps_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","’¡Tsango tangi tsonꞌannta xi jaꞌanta nchekonchjiannta tjatuꞌo tsango chaxro ngataꞌa ti jixrabaa kain sen profeta tsichronga chijnie ndo Dio saꞌó, ko meꞌe ni ndotáchriꞌanta xranchrjen tsikoña na̱ sen! ");
INSERT INTO pps_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Ko jaña jaꞌanta tjakonta ixi chao ti tsijincheꞌe ndotáchriꞌanta xranchrjen saꞌó, ixi jeꞌe na̱ tsikoña na̱ sen profeta ko jai jaꞌanta nchekonchjiannta tjatuꞌo chaxro ngataꞌa ti jixrabaa sen meꞌe. ");
INSERT INTO pps_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","’Ko ndo Dio tsango jian noꞌe ndo, méxin, ndachro ndo: “Xroxruanꞌannta ngisen xrochronga chijnina ko ngisen tsjako ngajinnta, ko jaꞌanta naatsóñaxónnta sen ko ikaxin sen chinga sinchekuunta sen.” ");
INSERT INTO pps_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Méxin, ndo Dio tsjankataꞌa ndo ijie̱ ngajin ni jii jai ixi kain sen profeta kuintekenꞌen ko kuintjí jnié sen, ti xra xrangíxixión konchjian nunte ko ti nchakon jai; ");
INSERT INTO pps_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","xranchakon kuenꞌen ndo Abel ko hasta ti kuenꞌen ndo Zacarías, ndo kóñaxin na̱ ngusine ti jii altar ko niꞌngo. Méxin, ntatjunta, ndo Dio tsjankataꞌa ndo ijie̱ ngajin ni ste jai ixi xranchi kuenꞌen kain sen saꞌó. ");
INSERT INTO pps_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","’¡Tsango tangi tsonꞌannta jaꞌanta xro tjakonta ley! Ixi jaꞌanta chondanta xroon jitaxin kain ti tetuanꞌan ndo Dio ko jaꞌanta tjaunꞌanta titikaonnta, ko tingijnaꞌinta ni tjaun tsitikaon. ");
INSERT INTO pps_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Juexin ndachro ndo Jesús kain jiꞌi, tjumeꞌe xi tjako ley ko xi fariseo tsango koñao xa ngajin ndo Jesús, ko tjumeꞌe juanchangiꞌe xa ndo Jesús tsango itsjé ngeꞌe, ");
INSERT INTO pps_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","ixi xrobikon xa siá jeꞌe ndo xronichja ndo naa ngeꞌe ndakoꞌa ixi chao xrobankataꞌa xa ijie̱ ngajin ndo. ");
INSERT INTO pps_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","*Tjumeꞌe xejo kueya na̱, tsango kueya na̱ stetateyá kichuu na̱. Ko jeꞌe ndo Jesús kuaxi nichja ndo saꞌó ngajin sen teyuu chrikao ndo ko ndachro ndo: ―Ncheꞌanta xranchi ncheꞌe xi fariseo, ixi ndachro xa ko nichja xa jian ko ti ndachro xa, ncheꞌa xa. ");
INSERT INTO pps_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","*Ixi xroꞌan ngeꞌe ncheꞌe chujni tsemá, kain ngeꞌe ti ncheꞌe chujni ti jimá, kain meꞌe naa nchakon tsonoxin. ");
INSERT INTO pps_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Méxin, kain ti imao tsinichjanta, tsi̱i̱ nchakon tsonoxin; ko kain ti tsinichjanta imao ngaxinꞌin nchia, tsajinꞌin na̱ nchia tsuyako na̱ tsinꞌen kain chujni. ");
INSERT INTO pps_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","’Janꞌan ntatjunta ixi tjento kichuuna, xrakuenꞌanta ngisen naatóñaxón cuerpoeni ixi meꞌó chao sincheꞌe na̱. ");
INSERT INTO pps_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Janꞌan xrontatjunta ngisen xroxrakonꞌennta: xrakonꞌennta ndo nduaxin tsantsjaꞌanta asáanta ko chónda ndo juachaxin xroxruanꞌannta ndo ti xroꞌi xrochexin kain ni ndakoꞌa ncheꞌe. Jeꞌo ngajin jeꞌe ndo xroxrankana. ");
INSERT INTO pps_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","’¿Á tuchji̱ꞌa naꞌó kuxechjan ixi yuu tomi nchínchín? Ko jeꞌe ndo Dio tjáñeꞌa ndo ninaa ba. ");
INSERT INTO pps_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Ko ngujngu jaꞌanta Ndotáina Dio jeꞌe ndo noꞌe ndo ngijanꞌin xrajaanta chondanta; jeꞌe ndo beki ndo naa ko naa ka. Méxin, jaꞌanta xrakonꞌanta, ixi jaꞌanta ícha tjinteenta ixi kueya kuxechjan. ");
INSERT INTO pps_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","’Janꞌan ntatjunta ixi kain sen xrondachro chuxinna ngatoxin ikon chujni, kaxon janꞌan, chjenꞌen ndo Dio, xjan jongíꞌe xranchi chujni, xrontatjan kain sen angéel ndo Dio ixi janꞌan kaxon chuxin sen. ");
INSERT INTO pps_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Ko ni xrondachro chuxinꞌana na̱ ngatoxin ikon chujni, janꞌan kaxon xrondachrja̱n ngajin sen angéel kondee ndo Dio ixi chúxinꞌa sen kaxon. ");
INSERT INTO pps_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","*’Ko xrojan ni xronichja ndakoꞌa kondee najanꞌan, chjenꞌen ndo Dio, xjan jongíꞌe xranchi chujni, xrachao tsoméꞌe jíee ni meꞌe; ko ni xronichja ndakoꞌa kondee espíritue ndo Dio, ni meꞌe tsango tangi tsonꞌen na̱ ko tsoméꞌa jíeena na̱. ");
INSERT INTO pps_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","*’Ko nchakon tsikuꞌunta na̱ ngajin ni ste niꞌngo, o̱ ngajin xi sinchéña ijie̱, o̱ naa xi tetuanꞌan, taꞌinta juachjaon ixi ngeꞌe tsjatingíexinnta o̱ ngeꞌe xrondachronta, ");
INSERT INTO pps_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","ixi Espíritue ndo Dio sintakuanꞌannta ko xrondachro ngeꞌe tsjatingíexinnta. ");
INSERT INTO pps_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Tjumeꞌe naa xi jii ngakjenꞌen kueya na̱ ndache xa ndo Jesús: ―Nchána, ndache xi kichian xrochjána xa ngusinexin ti kuintuꞌe sen nía. ");
INSERT INTO pps_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Ko jeꞌe ndo Jesús ndache ndo xa: ―¿Ngisen ndachro ixi janꞌan sintaña ijie̱ ngajinnta ko tsonchjeyaꞌanta ti kuintuꞌe ni ndúinta? ");
INSERT INTO pps_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Ko kaxon ndache ndo kain ni stetinꞌen: ―Ko xroxraxaonꞌanta ixi xrochondanta itsjé ngeꞌe ko itsjé tomi. Ixi jeꞌa ti itsjé xrochondanta, meꞌe xrotjáanta juaxruxin. ");
INSERT INTO pps_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Ko kaxon ndo Jesús bekiꞌe ndo na̱ naa chijni: ―Bakeꞌe naa xi kuachónda xa itsjé ngeꞌe. Ko chjakée xa kóña kueya trigo, méxin, kueya juatsiꞌin xa. ");
INSERT INTO pps_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Ko jeꞌe xa jixraxaon xa: “¿Ngeꞌe sintaꞌa ixi íkoꞌa no tsengachjian kain trigo juaka?” ");
INSERT INTO pps_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Ko ndachro xa: “Ó nóna ngeꞌe sintaꞌa. Tsonjamangi kain nchia nchíín ko sintaña kaxin nchia ícha ijié ko ntiꞌa tsjatsiin kain trigo kóña.” ");
INSERT INTO pps_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Ko xrontatjan aséenna: “Kueya ngeꞌe kuatsían ko chonda itsjé ngeꞌe tsarichonxian itsjé nano. Inte ko tiꞌia, tjokaꞌa ko takeꞌé juaxruxin.” ");
INSERT INTO pps_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Ko jeꞌe ndo Dio ndache ndo xa: “Jaꞌa ndakoꞌa xraxaoan ko tienxinꞌa, ixi tiie jai tsenꞌén ko tsitjáña asáan ko, ¿ngisen tsondeꞌe kain ti kuatsían?” ");
INSERT INTO pps_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Ko jaña tsonꞌen kain ni ícha tjaun xrochónda tomi ko kain ngeꞌe jii ngataꞌa nunte ko xroꞌan ngeꞌe chónda na̱ ngajin ndo Dio. ");
INSERT INTO pps_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Ko tjumeꞌe ndache ndo Jesús sen teyuu chrikao ndo: ―Janꞌan ntatjunta taꞌinta juachjaon ixi ngeꞌe sintenta ko ngeꞌe tsaritsiinta. ");
INSERT INTO pps_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Ícha tjintee ti tsechónni ixi ngeꞌe sineni, ko cuerpoeni ícha tjintee ixi manta tsetsáani. ");
INSERT INTO pps_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Tsjeꞌenta xranchi jii kuntaꞌa. Tengaꞌi ba ko xroꞌan noa tatsiꞌin ba, ko chóndaꞌi ba no tsechjianxin no, ko ndo Dio tajon ndo ngeꞌe ine ba. ¿Á jeꞌa ícha tjinteenta jaꞌanta ixi kuxe? ");
INSERT INTO pps_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Maski jaꞌanta, ícha taanta juachjaon, juaꞌi tsaricho̱nnta ícha nchakon. ");
INSERT INTO pps_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","’Siá juaꞌi ncheꞌenta ngeꞌe ícha tangiꞌa, ¿sonda yaanta juachjaon ixi ti ícha tangi? ");
INSERT INTO pps_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","’Tsjeꞌenta xranchi tangi itsjo, tsjo meꞌe ncheꞌa tsjo ixra̱ ni tjaunꞌa tsjo manta. Ko janꞌan ntatjunta ixi ndo rey Salomón, maski ícha chaxro kuetsaa ndo, kuetsaꞌi ndo xranchi naa itsjo meꞌe. ");
INSERT INTO pps_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Siá ndo Dio nchekitsáa ndo ika, maski jai jichón ka ngataon ijngi ko ndúya ó xroche ka, ko á jeꞌa ícha chaxro sinchekitsáanta ndo jaꞌanta ti chuntiaꞌinta ndo. ");
INSERT INTO pps_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Méxin, jaꞌanta taꞌinta juachjaon ixi ngeꞌe sintenta o̱ ngeꞌe tsiꞌinta. ");
INSERT INTO pps_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Ixi ngisen chúxinꞌa ndo Dio ícha tjaun na̱ xrochónda na̱ kain ngeꞌe. Ko jaꞌanta chondanta Ndotánta jii ngajní, ko jeꞌe ndo ó noꞌe ndo kain ngeꞌe xrokondaꞌanta. ");
INSERT INTO pps_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Ko jaꞌanta cháña saꞌó tjéenta ti tetuanꞌan ndo Dio, ko jeꞌe ndo tsajon ndo kain ngeꞌe xrokondaꞌanta. ");
INSERT INTO pps_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","’Kutuchjonna xrakonꞌanta. Maski kueyaꞌinta, Ndotánta jii ngajní, tjaun ndo tsakeꞌenta ngajin ndo. ");
INSERT INTO pps_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Nchekjinta ti chondanta ko chje̱ꞌénta tomi ni nóa; ko tjumeꞌe nchekonchjiannta puxa tichjeꞌa, ixi jaña xrochondanta ti ícha tjintee ngajní, ko meꞌe kain nchakon tsakeꞌe ko tsjexinꞌa. Ixi ntiꞌa juaꞌi tixinꞌin xicheꞌe ko ti̱ꞌa kuchi̱i. ");
INSERT INTO pps_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Ixi ti no tsakeꞌenta ti tjintee chondanta, ntiꞌa tsakeꞌe asáanta kaxon. ");
INSERT INTO pps_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","*’Kainko nchakon jian xrotsjeꞌenta ko nchekangaꞌinta xroꞌi jii ngaya asáanta. ");
INSERT INTO pps_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","*Jaꞌanta takeꞌénta xranchi naa xi ncheꞌe ixra̱, xi jichónꞌen xa xrokjan nchée xa, ndo tsi̱ꞌxi̱n ti tsikuteꞌe na̱. Ixi hora tsi̱i̱ nchée xa ko tseya ndo, jeꞌe xa tuinxin tsantjeꞌe xa nta̱chja tixinꞌin ndo. ");
INSERT INTO pps_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Tsango juaxruxin tsintee kain ngisen ncheꞌe ixra̱ nchakon xrokjan nchée na̱ ko tsitja ndo na̱ stechón na̱, tsikejuaꞌi na̱. Ko janꞌan ntatjunta, ixi jeꞌe ndo tsajon ndo juachaxin tsakeꞌe na̱ ti jii ntachaon ko tsajon ndo ngeꞌe sine na̱. ");
INSERT INTO pps_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Ijié juaxruxin tsintee na̱ maski tsi̱i̱ ndo ngusine tiie o̱ tsingasáñaja ixi stechónꞌen na̱ ndo ko tsikejuaꞌi na̱. ");
INSERT INTO pps_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","*Ko tienxinnta jiꞌi: siá xi nchée naa nchia xrokonoꞌe xa ngeꞌe hora tsi̱i̱ xicheꞌe, jeꞌe xa xrokuejuaꞌi xa hora meꞌe, ko xrokuintueꞌa xa tse̱e̱ xicheꞌe ndoꞌa xa. ");
INSERT INTO pps_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Jaꞌanta kaxon tarichrinꞌanta; ixi janꞌan, chjenꞌen ndo Dio, xjan jongíꞌe xranchi chujni, tsjiꞌi naa nchakon ko jaꞌanta noaꞌinta ngixeꞌe nchakon ko ngixeꞌi hora tsjiꞌi. ");
INSERT INTO pps_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Ko tjumeꞌe ndo Pedro juanchangiꞌe ndo ndo Jesús: ―Ncháina Jesús, ti ndachronta jiꞌi, ¿á tsienxin kain na̱ o̱ janꞌonna tsianxinna? ");
INSERT INTO pps_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Ko juatingíexin ndo Jesús: ―Naa xi jian tetuanꞌan ni ncheꞌe ixra̱, meꞌe xrondachro ixi jeꞌe xa xrotsjeꞌe xa nchia ko tsajon xa sine kain ni ste nchia meꞌe. ");
INSERT INTO pps_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Chaxro tsonoꞌe aséen xi meꞌe nchakon tsi̱i̱ nchée xa ko tsichuexin xa ixi jincheꞌe xa ti kuituenꞌen xa. ");
INSERT INTO pps_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Janꞌan ntatjunta ixi ndo tetuenꞌen nchia tsakeꞌe ndo xi kuitikaon ixi jeꞌe xa tsetuanꞌan xa kain ixra̱ ko kain ngeꞌe chónda ndo ndoꞌa. ");
INSERT INTO pps_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Ko siá xi sincheꞌe kain ixra̱ meꞌe xroxraxaon xa ixi nchée xa tsonchrjenꞌen tsi̱i̱ ndo, ko tsaa xa ndakoꞌa sinchekao xa ni nchexra̱, ni nchri ko ni xi tituenꞌen xa, ko jeꞌe xa takeꞌe xa sine xa ko tsiꞌi xa ko xrokoan xa, ");
INSERT INTO pps_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","ko nchakon ko hora xraxaonꞌa xa tsi̱i̱ nchée xa, ndo tetuenꞌen nchia, tjumeꞌe jeꞌe ndo tsoñao ndo ngajin xa ko tsikaon xa ko tsengi ndo xa. Xranchi tsonꞌen xi meꞌe, jaña tsonꞌen kain ni titikaonꞌa ndo Dio. ");
INSERT INTO pps_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","’Xi ncheꞌe ixra̱, siá noꞌe xa ngeꞌe tjaun nchée xa sincheꞌe xa ko jeꞌe xa titikaonꞌa xa ti kuituenꞌen xa, xi meꞌe tsanga tsikaon xa. ");
INSERT INTO pps_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Ko xi noeꞌa ixi ti ndakoꞌa jincheꞌe xa, xi meꞌe ícha tsikaonꞌa xa. Méxin, ngisen ícha kueya kuayéꞌe, sen meꞌe ícha kueya xrokonda tsajon sen. Ko sen ícha kueya noꞌe, sen meꞌe ícha kueya xroxrancheꞌe sen. ");
INSERT INTO pps_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","’Janꞌan juiꞌi ixi sintakakiin xroꞌi ngataꞌa nunte ntiꞌi. ¡Ko janꞌan ó tjaꞌon xrojua̱a̱ xroꞌi jai! ");
INSERT INTO pps_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","*Xrokonda ngeꞌe tsango tangi sinchena na̱, ko jai jitoniꞌe aséenna tsijija nchakon tsonꞌen meꞌe. ");
INSERT INTO pps_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Siá jaꞌanta xraxaonnta ixi janꞌan bikian juaxruxin ngataꞌa nunte ntiꞌi, ntatjunta naꞌi. Méxin jée xroxraxaon ngujngunta. ");
INSERT INTO pps_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Ixi nchakon xrangíxixín jai ko kaxin nchakon tsi̱i̱, naꞌó ni ste naa nchia, ni meꞌe xrochjeya na̱. Níi na̱ tsoñaoꞌe na̱ ni yuu ko ni yuu tsoñaoꞌe na̱ ni níi. ");
INSERT INTO pps_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Ko ndotata xraningakonꞌen ndo chjenꞌen ndo, ko ichjan xraningakonꞌen xjan ndotée xjan. Ko janáana xraningakonꞌen jan nchrichjeꞌen jan, ko nchrichjeꞌen jan xraningakonꞌen xjan janée xjan. Janchaꞌa xraningakonꞌen jan nchritakindeꞌe jan ko nchritakinda xraningakonꞌen nchra jachée nchra. ");
INSERT INTO pps_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Ndo Jesús kaxon ndache ndo na̱: ―Ko nchakon tikonnta tsonchjian itjui̱ ti no tetaonxin nchakon, jaꞌanta ndachronta ixi ó tsi̱i̱ chrin, ko jaña tonꞌen. ");
INSERT INTO pps_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ko nchakon chrinto ti̱ꞌxi̱n no níjin, jaꞌanta ndachronta tsania súa, ko jaña tonꞌen. ");
INSERT INTO pps_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","¡Jaꞌanta ndakoꞌa xraxaonnta! Jaꞌanta ó noꞌanta ko chuxinnta ngeꞌe tonꞌen ngajní ko ngataon ijngi, ko jaꞌanta noaꞌinta ko tienxinꞌanta ngeꞌe jitonꞌen nchakon stenta. ");
INSERT INTO pps_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","’¿Sonda nchekonchjianꞌinta jaꞌonta ti nchekuu kichuunta? ");
INSERT INTO pps_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Siá xrojan ngisen tsjankataꞌanta ijie̱ ko xrokonda itsjinta ngajin xi nchekonchjian ijie̱, cháña naa tjaoxon kichuunta ti xrayáanta chaꞌo ko xratjasoꞌanta ti jii xi tetuanꞌan. Ixi siá tsjasonta ntiꞌa, xi nchéña ijie̱ xroxraxinꞌinnta xa ndoꞌachjiso. ");
INSERT INTO pps_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Ko janꞌan ntatjunta ixi tsachrjexinꞌanta ntiꞌa tsjengajanta kain tomi chondanta. ");
INSERT INTO pps_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Nchakon meꞌe konchjiñeꞌe kaxin na̱ ngajin ndo Jesús ko bekiꞌe na̱ ndo xranchi juincheꞌe xi Pilato ixi tsiketuanꞌan xa kuenꞌen kaxin xi tsiki̱ꞌxi̱n nunte Galilea. Ko jnié xa tsikintji ti no chexin jnié iko ti bakajonxin na̱ juasaya ngajin ndo Dio. ");
INSERT INTO pps_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Ko ndo Jesús juatingíexin ndo: ―¿Á xraxaonnta ixi jeꞌe xa ícha kueya ijie̱ sínká xa ixi kain ni tjajnée xa ni Galilea, méxin jaña konꞌen xa? ");
INSERT INTO pps_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Janꞌan ntatjunta ixi naꞌi. Ko siá jaꞌanta tsindoxinꞌanta xranchi ncheꞌenta ko xranchi xraxaonnta, kainnta jaña tsintekenꞌennta kaxon. ");
INSERT INTO pps_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","O̱, ¿á xraxaonnta kaxon ni itejní kuenꞌen, ni xratja torre Siloé? ¿Á ni meꞌe ícha ijie̱ kuachónda na̱ ixi ikaxin ni bakeꞌe tjajna Jerusalén? ");
INSERT INTO pps_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Janꞌan ntatjunta naꞌi. Ko siá jaꞌanta tsitikaonꞌanta ti tetuanꞌan ndo Dio, jaꞌanta jaña tsintekenꞌennta kaxon. ");
INSERT INTO pps_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Tjumeꞌe ndo Jesús bekiꞌe ndo sen: ―Naa xi kuachónda xa naa nta̱a̱ tu higo ngataon ijngi. Ko ikjui xa kuitsjeꞌe xa nta̱a̱ á chónda nta̱a̱ itu, ko xroꞌan itu kuitja xa. ");
INSERT INTO pps_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Ko tjumeꞌe ndache xa xi tsjeꞌe jngiꞌe xa: “Ó chónda níi nano titsjaꞌa nta̱a̱ jiꞌi ko xroꞌan itu titja. Méxin cháña tonchrijian nta̱a̱, xruenxon jitaꞌa nta̱a̱ ngataꞌa nunteꞌna.” ");
INSERT INTO pps_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Ko xi tsjeꞌe ijngi ndachro xa: “Jaꞌanta, tintuꞌenta nta̱a̱ nano jiꞌi; janꞌan sintandá inche tutée nta̱a̱ ko tsjánkaꞌa nta̱a̱ xineno tsitjo. ");
INSERT INTO pps_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Ko xrotsjeꞌena á tsajon nta̱a̱ itu. Ko siá naꞌi, meꞌe ché xrochrijin nta̱a̱.” ");
INSERT INTO pps_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Naa nchakon tjokéꞌe ni judío, ndo Jesús juinchekuenꞌen ndo na̱ chijnie ndo Dio ngaxinꞌin naa nchandoꞌe ndo Dio. ");
INSERT INTO pps_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Ko ntiꞌa jii naa nchri niꞌe itejní nano. Espíritue Xixronꞌanxrée tsijatuꞌo nchra, méxin jisée nchra, ko juaꞌi xendua nchra. ");
INSERT INTO pps_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Ndo Jesús bikon ndo nchra, ko kuiyeꞌe ndo nchra ko ndachro ndo: ―Jaꞌa nchri jai kuachrje ichin kuachonda. ");
INSERT INTO pps_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Ko tjumeꞌe jeꞌe ndo bakeꞌe ndo itja ndo ngataꞌa nchra, ko tuinxin jeꞌe nchra xendua nchra ko kuaxi nchra kuajon nchra juasaya ngajin ndo Dio. ");
INSERT INTO pps_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Ko xi tetuanꞌan niꞌngo koñao xa ixi ndo Jesús juinchexruenꞌen ndo nchra nchakon tjokéꞌe na̱. Méxin jeꞌe xa ndache xa kain ni ste ntiꞌa: ―Jii ikjaon nchakon tikinixin tsonꞌen ixra̱; nchakon meꞌe tsjiꞌinta tsoxruanꞌannta, ko jai nchakon tjokéꞌeni tikinixinꞌa tsonꞌen jiꞌi. ");
INSERT INTO pps_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Ko tjumeꞌe ndo Jesús ndache ndo xa: ―Ncheyeꞌa asáanta. ¿Á toxindangeꞌanta kuxintaꞌanta o̱ kuntajnoanta ko tikuꞌunta ba tsiꞌi ba inda nchakon tjokéꞌeni? ");
INSERT INTO pps_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Ko nchri jiꞌi xjantié ndo Abraham, Xixronꞌanxrée tsikintexin xa nchra ixi ichin tejní nano ko, ¿á tikinixinꞌa tsoxruenꞌen nchra nchakon tjokéꞌeni? ");
INSERT INTO pps_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Jaña ndachro ndo Jesús, méxin kaxin na̱ ningakonꞌen na̱ ndo ixi juinchesueꞌe ndo na̱; ko ni ste ntiꞌa tsango juaxruxin ste na̱ ixi bikon na̱ tsango ngeꞌe ijié juincheꞌe ndo. ");
INSERT INTO pps_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Ko tjumeꞌe ndachro ndo Jesús: ―¿Xranchi jii ti tetuanꞌan ndo Dio? ");
INSERT INTO pps_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Meꞌe jii ndako naa tse̱e̱ mostaza. Naa xi benga tse̱e̱ meꞌe jngiꞌe xa. Ko bangi ka ko kóña naa nta̱a̱ ijié ko kuxe juinchéña ba kakée ba ngataꞌa chaan nta̱a̱ meꞌe. ");
INSERT INTO pps_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Ko kaxon ndachro ndo Jesús: ―¿Ngeꞌe chao tsikonxinni ti tetuanꞌan ndo Dio? ");
INSERT INTO pps_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Meꞌe xranchi ti nchetjaꞌin nutja níi medida ikuen tsitsé naa nchri ko jaña juanꞌin chuꞌu. ");
INSERT INTO pps_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Sakjui ndo Jesús no tjajna Jerusalén, ko kuatsinga ndo itsjé tjajna ijié ko tjajna nchíín ko juinchekuenꞌen ndo na̱ chijnie ndo Dio. ");
INSERT INTO pps_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Ko bakeꞌe naa xi juanchangiꞌe xa ndo Jesús ko ndachro xa: ―¿Á kainꞌa chujni xrochónda juachaxin tsechón kain nchakon? Ko ndo Jesús ndachro ndo: ");
INSERT INTO pps_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","―Xakonꞌannta tsixixinnta ixi nta̱chja ijno, ixi ntatjunta itsjé na̱ tjaun na̱ tixinꞌin na̱ ntiꞌa ko juaꞌi tixinꞌin na̱. ");
INSERT INTO pps_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Ko tjumeꞌe ndo ndoꞌa tsingatjen ndo ko tsijeꞌe̱ ndo nta̱chja ko jaꞌanta tsituꞌanta nduja, tsinganta nta̱chja ko xrondachronta: “Tantjeꞌenta nta̱chja.” Ko jeꞌe ndo xrondachro ndo: “Janꞌan nónaꞌi no juixin jaꞌanta.” ");
INSERT INTO pps_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Ko tjumeꞌe jaꞌanta tsjangixinnta xrondachronta: “Janꞌanna kuiꞌina ko juinena ngajinnta, ko jaꞌanta juinchekuannanta chijnie ndo Dio ngatja chaꞌo tjajnana̱na.” ");
INSERT INTO pps_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Ko jeꞌe ndo xrondachro ndo: “Janꞌan ó ntatjunta nónaꞌi no juixinnta. Satjixinnta ti ritjén janꞌan, jaꞌanta ndakoꞌa ncheꞌenta.” ");
INSERT INTO pps_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","*Ntiꞌa jaꞌanta xrotsjanganta ko tse̱to̱ nenonta nchakon tsikonnta ndo Abraham, ko ndo Isaac, ko ndo Jacob, ko kain sen profeta bakeꞌe saꞌó, ste sen ngajní ti tetuanꞌan ndo Dio, ko jaꞌanta tsakeꞌenta nduja. ");
INSERT INTO pps_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Ixi tsi̱ꞌxi̱n chujni kain nunte; chuya, retuya, kuꞌe ko no níjin ko tsakeꞌe na̱ sine na̱ ti tetuanꞌan ndo Dio. ");
INSERT INTO pps_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","*Méxin itsjé na̱ jai xroꞌan juachaxin chónda na̱, ko jeꞌe ni meꞌe ícha ijié juachaxin xrochonda na̱; ko kaxin na̱ jai tsango ijié juachaxin chónda na̱, ko ni meꞌe íxroꞌan juachaxin xrochónda na̱. ");
INSERT INTO pps_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Nchakon meꞌe ikjui kaxin xi fariseo ko ndache xa ndo Jesús: ―Satjixinnta ntiꞌi, ixi xi rey Herodes tjaun xa naatsóñaxónnta xa. ");
INSERT INTO pps_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Ko ndo Jesús ndachro ndo: ―Satjinta ko ndachenta xi meꞌe, xi ndakoꞌa ncheꞌe: “Jai ko ndúya xratsantsje espíritue Xixronꞌanxrée chónda chujni, ko sintaxruanꞌan ni niꞌe, ko nínxin nchakon ó sintajexin xra̱na.” ");
INSERT INTO pps_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Ko xrokonda xratsaji janꞌan jai ko ndúya ko tjenki, ixi kain sen profeta chronga chijnie ndo Dio xrokonda tsenxin sen tjajna Jerusalén. ");
INSERT INTO pps_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","’¡Jaꞌanta tjajna Jerusalén, jaꞌanta tóñanta kain sen chronga chijnie ndo Dio ko taxinta ixro sen xruanꞌan ndo Dio kui̱i̱ xrobingijnanta! ¡Janꞌan nanaunka fiaꞌon xroxraꞌunta xranchi naa kuchika tjaꞌo ba chjenꞌen ba ngangi nineꞌe ba, ko jaꞌanta chroꞌanta! ");
INSERT INTO pps_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Méxin xrokonoꞌanta ixi nchianduinta jeꞌo ncha tsituꞌe ncha; ko xrontatjunta í tsikonꞌantana tsija nchakon jaꞌanta xrondachronta: “Tsango jian ngisen kui̱xi̱n juachaxien ndo Dio.” ");
INSERT INTO pps_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Naa sábado nchakon tjokéꞌe na̱, ndo Jesús ikjui ndo ndoꞌa naa xi fariseo tetuanꞌan, ko ntiꞌa chjée na̱ ndo juine ndo. Ko ntiꞌa ste ícha xi fariseo stetsjaya xa ndo Jesús. ");
INSERT INTO pps_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Kaxon ntiꞌa jii naa xi tsikatjuya xa. ");
INSERT INTO pps_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Ko ndo Jesús juanchangiꞌe ndo xi tjako chijnie ndo Dio ko xi fariseo: ―¿Á jii juachaxin sinchexruenꞌenni naa ni niꞌe nchakon tjokéꞌeni? ");
INSERT INTO pps_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Ko jeꞌe xa tenko xa. Tjumeꞌe ndo Jesús itsé ndo itja xi niꞌe, ko juinchexruenꞌen ndo xa ko ndache ndo xa chao satsji xa. ");
INSERT INTO pps_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","*Tjumeꞌe ndo Jesús ndache ndo xi fariseo: ―¿Ngixeꞌe jaꞌanta, siá naa kuntajnoanta o̱ naa kuxintaꞌanta tsitsingaya ba naa tuye, á tsantsjeꞌanta ba maski nchakon tjokéꞌeni? ");
INSERT INTO pps_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Ko xi fariseo juaꞌi juatingíexin xa ngeꞌe ndachro ndo Jesús. ");
INSERT INTO pps_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Ndo Jesús jitsjeꞌe ndo ixi kain ni konchjiñeꞌe ti kiée na̱, juée na̱ ntaxitaon jian jii ti mesé ni tsikuteꞌe, ko tjumeꞌe jeꞌe ndo ndachro ndo: ");
INSERT INTO pps_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","―Nchakon itsjinta naa kiée ni tsuteꞌe, tjéꞌanta ntaxitaon jii ícha tjenka ni tsikuteꞌe, ixi nchéxin tsi̱i̱ naa ngisen ícha tetuanꞌan ko ni meꞌe xrokonda tsakeꞌe na̱ ntiꞌa. ");
INSERT INTO pps_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Ko ngisen kuiyaꞌanta ikjuinta kia xrontatjunta na̱: “Tingatjenxinnta ti ntaxitaon ritaꞌanta ixi ña̱ tsakeꞌe naa ngisen jiꞌi.” Ko tjumeꞌe jaꞌanta tsingatjennta ko tsakeꞌenta ti ntaxitaon jii ícha no ndáꞌa ko tsosuaꞌanta. ");
INSERT INTO pps_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Méxin naa ngisen xrondachro tsjiꞌinta naa kiée na̱, jaꞌanta cháña takeꞌénta ntaxitaon ícha no ndáꞌa, ixi jaña ni ntatjunta juiꞌinta kia xrontatjunta na̱: “Jaꞌanta tatsinganta ti ntaxitaon jii ícha tjenka ni kuteꞌe.” Jaña jaꞌanta tsayeꞌenta ícha juasaya ngajinxin kain ni ste ntiꞌa. ");
INSERT INTO pps_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","*Ixi ni ícha sinchejié aséen, ni meꞌe tjinteꞌa na̱ ko tsayéꞌa na̱ juachaxin tsetuanꞌan na̱; ko ngisen nchejiéꞌa aséen, sen meꞌe ícha tsayéꞌe sen juachaxin tsetuanꞌan sen. ");
INSERT INTO pps_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Ko ndo Jesús ndache ndo xi tsikiyeꞌe ndo tsi̱i̱ ndo kiée xa: ―Jaꞌanta nchakon sinchéñanta naa kia, tiyeꞌanta chujni tjentonta, sen ndointa, sen kichuunta, sen ste tjenka ndointa chónda itsjé tomi, ixi sen meꞌe chao sinchéña sen inaa kia ko tsiyaꞌanta sen itsjinta sintekuꞌunta sen, ko jaña jeꞌe sen sinchekjan sen ti juine sen ndointa. ");
INSERT INTO pps_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Méxin, nchakon jaꞌanta sinchéñanta naa kia, tiyeꞌenta ni nóa, ni juaꞌi itji, ni juaꞌi tontengi jeꞌo, ko ni ntakutsin. ");
INSERT INTO pps_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Ko jaña ícha juaxruxin xrochondanta asáanta, ixi maski ni meꞌe juaꞌi tsjengaꞌanta na̱ ꞌna̱. Nchakon xroxechón kain ni jian juincheꞌe, ndo Dio tsjengaꞌanta ndo ꞌna̱ ngeꞌe jian juincheꞌenta ngajin ni nóa. ");
INSERT INTO pps_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Kuinꞌen naa xi jii tjenka mesa ko ndache xa ndo Jesús: ―Tsango juaxruxin tsakeꞌe ni sine ti tsakeꞌe kia ti tetuanꞌan ndo Dio. ");
INSERT INTO pps_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Ko ndo Jesús ndache ndo xi meꞌe: ―Naa xi bakeꞌe xa naa kia ijié, ko kuiyeꞌe xa itsjé na̱ tsi̱i̱ na̱ sine na̱. ");
INSERT INTO pps_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Ko kui̱i̱ hora sine na̱, ko xi meꞌe xruanꞌan xa naa xi nchexrée xa tsjiruéꞌe xa kain ni ndache xa tsi̱i̱ ixi ó chao jii kain ngeꞌe. ");
INSERT INTO pps_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Ko kain ni meꞌe kuaxi na̱ ndache na̱ xi kuetuanꞌan xa kueya ko ndachro na̱ ixi juaꞌi tsi̱i̱ na̱. Xi saꞌó ndachro xa: “Janꞌan kueꞌna naa nunte, ko xrokonda tsitsjaꞌa nunte; toñaoꞌanta ixi tsjiꞌa.” ");
INSERT INTO pps_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Ko ndachro inaa xa: “Janꞌan kueꞌna naꞌó yuntee kuxinta, ko xrokonda xrotsjaꞌa á chao ncheꞌe ba ixra̱; méxin, ndachrja̱n toñaoꞌanta ixi tsjiꞌa.” ");
INSERT INTO pps_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Ko inaa xa ndachro xa: “Janꞌan nandá kuténa, méxin, juaꞌi itsji.” ");
INSERT INTO pps_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Ko xi nchexra̱ ikjan xa ngajin xi tsixruaꞌan xa tsjiruéꞌe xa na̱ ko chronga xa kain jiꞌi. Ko jeꞌe xa kuinꞌen xa ngeꞌe tsichro ni xrokui sine, ko koñao xa ko ndache xa xi nchexrée xa: “Jaiko itjia kain chaꞌo ko kain ndasin chónda tjajna jiꞌi, ko tikua ntiꞌi kain ni nóa ko ni juaꞌi itji, ko ni juaꞌi tontengi jeꞌo, ko ni tikonꞌa.” ");
INSERT INTO pps_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Tjumeꞌe jeꞌe xi nchexra̱ ndachro xa: “Ó juintaꞌa xranchi kuetuannanta, ko xrajíi no tsintee ícha chujni.” ");
INSERT INTO pps_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Ko tjumeꞌe jeꞌe xi tetuanꞌan ndache xa xi nchexra̱: “Itjia kain chaꞌo ko kain chaꞌo tatuꞌka ngandeꞌe tjajna, ko nchekateya na̱ tsi̱i̱ na̱, ixi jaña xrokaon nía. ");
INSERT INTO pps_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Janꞌan ndachrja̱n tjaunꞌa tixinꞌin ninaa ni kuiyaꞌa ícha saꞌó tsi̱i̱ na̱ sine na̱.” ");
INSERT INTO pps_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Tsango itsjé na̱ ruéꞌe na̱ ndo Jesús ko jeꞌe ndo ngatjia ndo ko ndache ndo na̱: ");
INSERT INTO pps_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","*―Siá xrojan jaꞌanta tjaunnta xroruénanta, xrokonda ícha xrotjaunninta janꞌan ixi ndotánta, o̱ janáanta, o̱ janchriꞌanta, o̱ chjanꞌanta, o̱ nchrikichuunta o̱ xi kichuunta, ko kaxon jeꞌa ícha xrotjueꞌenta asáanta. Ko siá ícha xrotjaunanta janꞌan, chao xrokjannta sen chujnina. ");
INSERT INTO pps_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","*Ko ngisen tsatsingaꞌi juachjaon tsatsinga janꞌan ti tsenꞌen na̱ nganito nta̱cru, ni meꞌe juaꞌi xrokjan na̱ sen chujnina. ");
INSERT INTO pps_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Siá xrojannta tjaunnta sinchekonchjiannta naa tjatuꞌo tsango noi, ¿á tsakeꞌanta saꞌó xroxraxaonnta ngijanꞌin tomi xrokonda tsonchjianxin tjatuꞌo meꞌe?, ko, ¿á chondanta kain tomi xrokonda tsjexixin tsonchjian tjatuꞌo? ");
INSERT INTO pps_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Ixi siá naꞌi, jeꞌo kuitenta ixro tsetaꞌa tjatuꞌo ko juexin tomi, ko í juexinꞌa juinchekonchjiannta tjatuꞌo meꞌe, ko kain ni tsikon tsjanoanta na̱ ixi juexinꞌa kuitenta tjatuꞌo. ");
INSERT INTO pps_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Ko ni meꞌe xrondachro na̱: “Xi jiꞌi juangíxin xa juinchekonchjian xa tjatuée xa ko jueꞌa xa kuite xa tjatuꞌo.” ");
INSERT INTO pps_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","O̱ naa xi rey xrokonda itsji xa ko tse̱ꞌto̱ xa ngajin inaa xi rey, ¿á jeꞌa saꞌó xroxraxaon xa ixi á chao ixi ite mil xi soldado chónda xa, tse̱ꞌto̱ xa ngajin xi rey chónda ikán mil xi soldado? ");
INSERT INTO pps_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Xi rey meꞌe xraxaon xa ixi juaꞌi tsjacha xa ngajin xi rey ti kueya xi soldado chónda xa, méxin xroxruanꞌan xa kaxin na̱ tsikao na̱ juajna ngajin xi rey chónda kueya xi soldado ixi xrajíi xa ikjín, ko jaña tse̱to̱ꞌa xa. ");
INSERT INTO pps_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Jaña, jaꞌanta kaxon siá tsintueꞌanta kain ti chondanta, juaꞌi xrokjannta chujnina. ");
INSERT INTO pps_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","’Xíjnta tsango jian xíjnta tojníxin ti ineni ko nchakon sinchejníꞌa xíjnta, ¿ngeꞌe tsojníxin ti sineni? ");
INSERT INTO pps_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Méxin nchakon tsojníꞌa xíjnta ningeꞌo tsonda xíjnta, tsintjini xíjnta ixi íxroꞌanxrée xíjnta. Ngisen tinꞌen, tsinꞌen sen jian. ");
INSERT INTO pps_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","*Konchjiñeꞌe xi xengeꞌe iꞌna̱ tomi ti tjanchia xi tetuanꞌan, ko kaxon kueya ni ndakoꞌa ncheꞌe konchjiñeꞌe na̱ ngajin ndo Jesús ixi tsinꞌen na̱ ti ndachro ndo. ");
INSERT INTO pps_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Tjumeꞌe xi fariseo ko xi tjako chijni kuetuanꞌan ndo Dio nichjangíꞌe na̱ ndo Jesús, ko ndachro na̱: ―Xi Jesús tjento xa kain ni ndakoꞌa ncheꞌe ko nekao xa na̱. ");
INSERT INTO pps_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Méxin ndo Jesús juako ndo naa chijni ngajin na̱: ");
INSERT INTO pps_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","―Ngixeꞌe jaꞌanta, chondanta naa ciento kutuchjon, ko sinchetjáñanta naa ba, ¿á tsintueꞌanta ko noventa y nueve ngataon ijngi ko itsjinta tsijéenta iko kuitjáña ko tsinchíjanta ba? ");
INSERT INTO pps_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Ko nchakon tsinchíinta ba, jaꞌanta tsakeꞌenta juaxruxin ko tsamanta ba ngataꞌa ntachaannta, ");
INSERT INTO pps_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","ko nchakon tsjasonta ndointa, tsiyeꞌenta ni tjentonta ko kain ni ste tjenka ndointa ko xrondachenta na̱: “Jai tsojuna juaxruxin ixi ó kuitja kutuchjonna, iko kuitjáña.” ");
INSERT INTO pps_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Janꞌan ntatjunta, xrajeꞌo jaña Ndotáina jii ngajní ko kain sen ángel tsango chéꞌe sen ixi naa ngisen ndakoꞌa juincheꞌe ó titikaon sen chijnie ndo Dio ixi ni noventa y nueve jian ncheꞌe, íxrokondaꞌi tsindoxin na̱. ");
INSERT INTO pps_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Ko kaxon ndachro ndo Jesús: ―Naa nchri chónda nchra ite tomi ko juinchetjáña nchra naa tomi, jeꞌe nchra sinchekakiin nchra xroꞌi ixi tsjée nchra tomi juinchetjáña nchra ko tsajon nchra nguixin ngaxinꞌin nchia tsitjaja nchra tomi juinchetjáña nchra. ");
INSERT INTO pps_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Ko hora tsitja nchra tomi, tsiyeꞌe nchra kain nchri tjento nchra ko kain ni ste tjenka ndoꞌa nchra ko xrondache nchra kain na̱: “Tújúna juaxruxin ixi ó kuitja tomi juintatjáña.” ");
INSERT INTO pps_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Janꞌan ntatjunta kaxon ngajní kain sen ángel neꞌe ndo Dio ste sen juaxruxin nchakon naa ngisen ndakoꞌa juincheꞌe tindoxin sen ko ikjan sen ngajin ndo Dio ko titikaon sen chijnie ndo. ");
INSERT INTO pps_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Ko kaxon ndachro ndo Jesús: ―Naa xi kuachónda xa yuu chajan. ");
INSERT INTO pps_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Ko chán yuxin ndache chán ndotée chán: “Tata, chjánanta tomi ko ngeꞌe tikinixin tsayáꞌa̱ janꞌan.” Ko tjumeꞌe jeꞌe ndo konchjeya ndo yui chájeꞌen ndo ti tikinixinꞌen chán. ");
INSERT INTO pps_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Tsjéꞌa nchakon kuatsinga, jeꞌe chán juinchekji chán ti kuayéꞌe chán ko juejo chán kain tomi, ko tjumeꞌe sakjui chán inaa tjajna ikjín ko juincheꞌe chán kain ti ndakoꞌa, ko juinchexienxin chán kain tomi kuayéꞌe chán. ");
INSERT INTO pps_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Ko jueꞌe chán juinchexienxin chán kain tomi, ko tjumeꞌe kui̱i̱ nchakon kain ni tjajna meꞌe tsango kuatse na̱ jinta ko jeꞌe chán tsango tangi kuatsinga chán kaxon. ");
INSERT INTO pps_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Ko tjumeꞌe ikjui chán bijanchia chán ixra̱ ngajin naa xi tjajna ntiꞌa. Ko xi meꞌe kotuenꞌen xa chán itsji chán ngataon jngiꞌe xa xrotsjeꞌe chán kuchinga. ");
INSERT INTO pps_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Ko jeꞌe chán tsango bakenꞌen chán jinta, ixi xroꞌan ngeꞌe jii sineni ko tjaun chán xrojuine chán tjaja bajine kuchinga. ");
INSERT INTO pps_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Méxin bakeꞌe chán xraxaon chán ko ndachro chán: “¡Itsjé ni nchexra̱ ste na̱ ndoꞌa ndotána! ¡Ko jeꞌe na̱ chónda na̱ itsjé ngeꞌe sine na̱, ko janꞌan ntiꞌi jiteenxinna jinta! ");
INSERT INTO pps_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Tsingatjen ko satsji ti jii ndotána ko xrontatjan ndo: Tata, janꞌan juintaꞌa ti ndakoꞌa ngajin ndo Dio jii ngajní ko ngajinnta kaxon. ");
INSERT INTO pps_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Ítikinixinꞌa tsinꞌinna chjaꞌannta; jeꞌo xrokjanna xranchi naa xi nchexráanta, naa xi xroꞌan tjintee.” ");
INSERT INTO pps_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Tjumeꞌe kua chán chaꞌo ikjan chán ndoꞌa ndotée chán. Ko xrakjín jitiji chán, ndotée chán bikon ndo chán ko bikonóeꞌe ndo chán ko binga ndo ti no jiti̱i̱ chán ko joa ndo chán ko kue̱to̱xin ndo chán. ");
INSERT INTO pps_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Ko tjumeꞌe jeꞌe chán ndache chán ndotée chán: “Tata, janꞌan juintaꞌa ti ndakoꞌa ngajin ndo Dio jii ngajní ko ngajinnta kaxon. Méxin, ítikinixinꞌa tsinꞌinna chjanꞌanta.” ");
INSERT INTO pps_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Ko jeꞌe ndotée chán ndache ndo ni nchexrée ndo: “Taka tikuunta manta ícha jian ko tjintee ko nchekitsáanta chjanꞌna; ko kaxon tsikuunta kuchaningo tseyá itja xjan, ko takeꞌénta xjan kate ícha tjintee. ");
INSERT INTO pps_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","¡Tsikuunta kuxinta ícha ntao ko toꞌinta ba sintena ko sinchéñana kia! ");
INSERT INTO pps_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Ixi chjanꞌna jiꞌi xranchi xrokuenꞌen xjan ko jai xechón xjan. Jeꞌe xjan kuitjáña xjan ko jai ikjan xjan. Nchéñana kia ko tújúna juaxruxin.” ");
INSERT INTO pps_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","’Ko chán saꞌó ngataon ijngi jincheꞌe chán ixra̱. Ko hora ikjan chán konchjiñeꞌe chán nchia, kuinꞌen chán jii soon ko steté na̱. ");
INSERT INTO pps_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Meꞌe kuiyeꞌe chán naa xi nchexra̱ ko juanchangiꞌe chán xa: “¿Sonda jii kia?” ");
INSERT INTO pps_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Ko xi nchexra̱ meꞌe ndachro xa: “Ikjan chán kichuunta, ko ndotánta kuetuanꞌan ndo kuenꞌen kuxinta ícha ntao ixi ikjan chán ko xroꞌan ngeꞌe tsikonꞌen chán.” ");
INSERT INTO pps_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Ko chán saꞌó tsango koñao chán, ko chroꞌa chán tixinꞌin chán nchia. Ko jeꞌe ndotée chán kuachrje ndo ko juinchetsenꞌen ndo ñao chán ixi tixinꞌin chán nchia. ");
INSERT INTO pps_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Ko jeꞌe chán ndache chán ndotée chán: “Jaꞌanta noꞌanta ngijanꞌin nano rintaꞌa ixra̱ ngajinnta ko naiꞌa nichjangíꞌanta, ko jaꞌanta ninaa kubitochjan chjánaꞌinta xrojuinekiꞌan xi tjento. ");
INSERT INTO pps_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Ko jai kui̱i̱ chjanꞌanta jiꞌi, xjan ndakoꞌa juinchexienxin kain tomi ko kain ngeꞌe chje̱ꞌénta xjan, juinchexienxin xjan kain tomi kuayéꞌe xjan ngajin nchri ndakoꞌa ncheꞌe, ko jaꞌanta konꞌinta kuxinta ícha ntao ko juinchéñeꞌenta xjan kia.” ");
INSERT INTO pps_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Tjumeꞌe jeꞌe ndo ndache ndo chán saꞌó: “Chjanꞌna, jaꞌa kain nchakon ritjén ngaji̱n, ko kain ti chonda janꞌan, jaꞌa tikinixinꞌan. ");
INSERT INTO pps_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Ko jai xrokonda tsojuna juaxruxin ko sinchéñana kia ixi xjan kichuua xrokjui xranchi ó kuenꞌen xjan, ko jai xechón xjan ko jeꞌe xjan kuitjáña xjan, ko jai kuichuee xjan.” ");
INSERT INTO pps_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Ndo Jesús bekiꞌe ndo sen teyuu chrikao ndo: ―Bakeꞌe naa xi chónda itsjé tomi, ko xi meꞌe kuachónda xa naa xi bakeki kain tomi ko kain ngeꞌe kuachónda xa. Ko naa nchakon ikjui kaxin na̱ kuindache na̱ xi tomie ixi xi nchexrée xa tsango nchexienxin xa tomi ko ngeꞌe bakeꞌe ngaya itja xa. ");
INSERT INTO pps_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Ko tjumeꞌe xi tomie kuiyeꞌe xa xi nchexrée xa ko ndache kichuu xa: “¿Á nduaxin ncheꞌe xranchi bekina̱na janꞌan, nchexienxinkua tomina ko ngeꞌe chonda janꞌan? Jai ndachijiana ngeꞌe juincheꞌe ixi kain ngeꞌe bakée ngaya tjáa ko tomi bakeꞌkia ixi jaꞌa ísincheꞌa ixra̱ ngaji̱n.” ");
INSERT INTO pps_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Ko tjumeꞌe xi bakeki tomi bakeꞌe xa xraxaon xa: “¿Ngeꞌe sintaꞌa jai ixi jeꞌe nchána tsantsjena xa ixra̱? Janꞌan ísojiꞌina sintaꞌa ixra̱ ngataon ijngi, ko tsosuaꞌna tsjanchakaꞌa. ");
INSERT INTO pps_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ó nóna ngeꞌe sintaꞌa nchakon i xrochonda ixra̱ ixi ni sinkeꞌe nchána tsiyaꞌna na̱ ndoꞌa na̱.” ");
INSERT INTO pps_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Ko tjumeꞌe kuiyeꞌe xa ngujngu ni sinkeꞌe xi nchée xa. Ko jeꞌe xa juanchangiꞌe xa xi kui̱i̱ saꞌó: “Jaꞌa, ¿ngijanꞌin tasinka ngajin nchána?” ");
INSERT INTO pps_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Ko jeꞌe xa juatingíexin xa: “Janꞌan tasinka cien barril tikia ndaxiꞌe ko tasinka ndaxiꞌe meꞌe.” Ko jeꞌe xi teki tomi ndachro xa: “Itsé xroon ti jitaxin ti tasinka ko nchéñana tuinxin inaa xroon xrondachro jeꞌo tasinka cincuenta nta̱barril.” ");
INSERT INTO pps_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Tjumeꞌe xi teki tomi juanchangiꞌe xa inaa xi sínká: “Jaꞌa, ¿ngijanꞌin tasinka?” Xi meꞌe juatingíexin xa: “Cien costa noatrigo.” Ko tjumeꞌe jeꞌe xi teki tomi ndachro xa: “Itsé xroon ti jitaxin ngeꞌe tasinka ko tasintaxian jeꞌo tasinka noó ikán costa.” ");
INSERT INTO pps_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Tjumeꞌe xi tomie konoꞌe xa ngeꞌe juincheꞌe xi nchexrée xa, xi teki tomi, ko ndachro xa ixi xi jiꞌi jaiko xraxaon xa ngeꞌe sincheꞌe xa ixi kain ni ngataꞌa nunte, ni chúxinꞌa chijnie ndo Dio, ícha ñaꞌi na̱ ixi tsingijna na̱ ni naxrajeꞌo ndakuaꞌi ncheꞌe xranchi jeꞌe na̱ ko sen titikaon chijnie ndo Dio, naꞌi. ");
INSERT INTO pps_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Janꞌan ntatjunta chijni jiꞌi: tondaꞌanta kain tomi ko kain ngeꞌe richondanta ngataꞌa nunte ntiꞌi, ko tomi meꞌe tsjachaxinnta chujni tsjentonta, ixi nchakon tsjexin kain ngeꞌe ko kain tomi, jaꞌanta tsayeꞌenta nchia jii ngajní tsarixiꞌinta kain nchakon. ");
INSERT INTO pps_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","’Ngisen tayakonꞌen ti kueyaꞌi chónda sen, kaxon chao tayakonꞌen sen ti kueya xrochónda sen, ko ngisen juaꞌi tayakonꞌen ti kueyaꞌi, kaxon juaꞌi tayakonꞌen sen ti kueya. ");
INSERT INTO pps_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Méxin siá juaꞌi xrotsjeꞌenta jian tomi ko kain ngeꞌe jii ngataꞌa nunte ntiꞌi, ¿ngisen tsakeꞌe ngaya tjáanta tomi nduaxin tjintee? ");
INSERT INTO pps_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ko siá juaꞌi xrotsjeꞌenta jian tomie inaa chujni, ¿ngisen xrotjáꞌanta tomi nduaxin tikinixinꞌannta? ");
INSERT INTO pps_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","*’Ni nchexra̱ juaꞌi xrochónda na̱ yuu sen tituenꞌen na̱, ixi xraningakonꞌen na̱ naa xi tituenꞌen na̱ ko xrotjueꞌe na̱ inaa xa, o̱ chaxro tsitikaon na̱ ngajin naa xa ko xronichjangíꞌe na̱ xi yuxin. Jaña kaxon juaꞌi sincheꞌe na̱ ixra̱ ngajin ndo Dio ko kaxon ícha xrotjueꞌe na̱ tomi. ");
INSERT INTO pps_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Ko xi fariseo tsango tjueꞌe xa tomi, méxin juanoa xa ndo Jesús ixi ngeꞌe ndachro ndo. ");
INSERT INTO pps_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Ko ndo Jesús ndachro ndo: ―Jaꞌanta tjaunnta tsonoꞌe na̱ ixi jian jaꞌanta ko jeꞌa nduaxin meꞌe, ixi ndo Dio chúxin ndo asáanta. Méxin ngeꞌe tsango tjueꞌe chujni, ndo Dio ncheꞌa ndo juaxruxin. ");
INSERT INTO pps_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","*’Chijni kuayéꞌe ndo Moisés ko kain ti tsindachro kain sen profeta meꞌe chijnie ndo Dio. Chijni meꞌe baketuanꞌan ko kuachronga kain sen ncheꞌe xrée Ndo Dio kuijija nchakon kui̱i̱ ndo Juan, ndo bikitée na̱. Ko janꞌan tjáꞌanta chijni jian chronga xranchi jii ngajní ti tetuaꞌan Ndo Dio. Méxin kain ni kuayéꞌe chijni jiꞌi tsango ncheꞌe na̱ ngeꞌe ixi tixinꞌin na̱ ti no tetuanꞌan ndo Dio. ");
INSERT INTO pps_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","*Ko janꞌan ntatjunta ixi ícha tangiꞌa tsitjáña ngajní ko nunte ntiꞌi ixi tsitjáña naa letrée chijnie Ndo Dio. ");
INSERT INTO pps_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","*’Siá naa xi tsikuteꞌe naa nchri ko tsi̱i̱ nchakon tsintuꞌe xa janchriꞌe xa ko tsuteꞌe xa inaa nchri, xi meꞌe ndakuaꞌi jincheꞌe xa ixi kuitikaonꞌa xa ley kuetuanꞌan ndo Dio. Kaxon, xi tsuteꞌe naa nchri tsikintuꞌe ndoxiꞌe nchra, xi meꞌe kaxon ndakuaꞌi jincheꞌe xa. ");
INSERT INTO pps_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","’Bakeꞌe naa xi chónda itsjé tomi ko teya xa manta tjintee, ko kain nchakon takeꞌe xa kia. ");
INSERT INTO pps_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Ko nduja ndoꞌa xi meꞌe bakeꞌe naa xi nóa bakinꞌin Lázaro; xi meꞌe tsango niꞌe xa, ko nchijíi ntauꞌe xa jirenga. ");
INSERT INTO pps_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Ko kunia tonchjiñeꞌe ba tuni ba ntauꞌe xi nóa. Ko jeꞌe xa tjaun xa sine xa kain ti tsixeꞌe ine xi chónda itsjé tomi. ");
INSERT INTO pps_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Ko tjumeꞌe naa nchakon xi nóa kuenꞌen xa ko sen ángel sabikao sen xa ti juaxruxin ti jii ndo Abraham, ti jii kain sen jian. Ko kaxon xi chónda itsjé tomi kuenꞌen xa ko juabaa na̱ xa. ");
INSERT INTO pps_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Ko xi kuachónda itsjé tomi kaxon ikjui xa ti ste ni tsikenꞌen ko tsango tangi ste na̱ ntiꞌa. Jeꞌe xa tsjeꞌe xa noi ko ikjín bikon xa ti jii ndo Abraham ko xi Lázaro. ");
INSERT INTO pps_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Tjumeꞌe kuyako xa ko ndachro xa: “Tata Abraham, tikonóananta, ko xruanꞌannta xi Lázaro sinchetjao xa dedue xa ixi inda ko tsi̱i̱ xa sinchetjao xa nejen ixi tsango tangi ritjén chringi xroꞌi ntiꞌi.” ");
INSERT INTO pps_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Ko ndo Abraham ndache ndo xa: “Chjanꞌna, xraxaoan ixi tsango jian bakeꞌe ngataꞌa nunte, ko tsango kueya ngeꞌe chaxro kuachonda, ko xi Lázaro tsango tangi bakeꞌe xa ntiꞌa. Ko jai jeꞌe xa ntiꞌi jii xa juaxruxin ko jaꞌa tangi ritjén ti jii xroi. ");
INSERT INTO pps_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ko kaxon jii naa yasoꞌe tsango ijié ngusine ti ste janꞌanna ko jaꞌanta. Méxin sen ste ntiꞌi maski xrotjaun sen xrokjui sen tsingijnanta sen, juaꞌi itsji sen; ko ni ste ntiꞌa juaꞌi tsi̱i̱ na̱ ntiꞌi ti ste janꞌanna.” ");
INSERT INTO pps_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Tjumeꞌe ndachro xi kuachónda itsjé tomi: “Tata Abraham, janꞌan tinóatáana, xruanꞌannta xi Lázaro itsji xa ndoꞌa ndotána ");
INSERT INTO pps_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","ixi ntiꞌa ste naꞌó xi kichian, ko janꞌan tjaꞌon sinchenoꞌe sen xa chijnie ndo Dio, ko jaña jian tsitikaon xa, ko jeꞌe xa tsiꞌa xa ntiꞌi ti jii xroꞌi.” ");
INSERT INTO pps_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Ko ndachro ndo Abraham: “Xi kichuua chónda xa xroon ti jitaxin tsikjin ndo Moisés, chijnie Ndo Dio ko ti tsinichja kain sen profeta. Sinchekuanxin xa ko tsitikaon xa xroon meꞌe.” ");
INSERT INTO pps_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Ko xi kuachónda itsjé tomi ndachro xa: “Naꞌi, tata Abraham, tsitikaonꞌa xa. Cháña xruanꞌannta naa ngisen ó ndakuenꞌen xronichjeꞌe sen xa, meꞌe tsitikaon xa ko tsindoxin xa.” ");
INSERT INTO pps_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Tjumeꞌe ndachro ndo Abraham: “Siá tjaunꞌa na̱ tsitikaon na̱ chijnie Ndo Dio tsikayéꞌe ndo Moisés jitaxin xroon ko ti tsichronga kain sen profeta, maski tsikon na̱ naa chujni ndakuenꞌen ko xroxechón chujni, tsitikaonꞌa na̱ kaxon.” ");
INSERT INTO pps_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Ndo Jesús ndache ndo sen teyuu chrikao ndo: ―Itsjé ngeꞌe jii nchekateyani ixi sincheꞌe ni ti ndakoꞌa, ko, ¡ícha tangi tsonꞌen ngisen kondeexin sincheꞌeni ti ndakoꞌa! ");
INSERT INTO pps_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Ni meꞌe xrokuiteꞌe tusin na̱ naa ixro ijié ti tontsingaxin ko xrokuitsingangi na̱ ndachaon ixi jaña ísincheꞌa na̱ ixi naa chjan xranoeꞌa xrojuincheꞌe xjan ti ndakoꞌa. ");
INSERT INTO pps_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","*Taanta juachjaon ixi jaꞌanta sincheꞌanta ti ndakoꞌa, ko siá naa ni kichuunta sincheꞌe ti ndakoꞌa ngajinnta, tuyakutéenta na̱; ko siá ísincheꞌa na̱ ti ndakoꞌa ngajinnta, jaꞌanta tjáñaꞌanta ngeꞌe juintaꞌanta na̱. ");
INSERT INTO pps_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Maski ya̱a̱to̱ ndakuaꞌi sintaꞌanta na̱ naa nchakon, ko ya̱a̱to̱ xrondachro na̱ tjáñaꞌanta ngeꞌe juintaꞌanta na̱, xrokonda ya̱a̱to̱ xrotjáñaꞌanta jaꞌanta kaxon ngeꞌe juintaꞌanta na̱. ");
INSERT INTO pps_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Sen kuajikao ndo Jesús ndache sen Ndo: ―Tingijnaninta ixi ícha xrochuntiana ngajinnta. ");
INSERT INTO pps_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Ko jeꞌe Ndo Jesús ndachro ndo: ―Siá jaꞌanta xrochuntianta ndo Dio naa nchinchjaon xranchi naa tse̱e̱ ka mostaza, jaꞌanta xrondachenta naa nta̱yua: “Jaꞌa tachrjengíxian inche ntiꞌi, ko xenga ngangi ndachaon”, ko nta̱a̱ meꞌe tsitikaon nta̱a̱. ");
INSERT INTO pps_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","’Siá naa jaꞌanta, chondanta naa xi nchexra̱ ko xi meꞌe tsikikao xa ngataon ijngi yunta o̱ kuitsjeꞌe xa kutuchjoanta, ko ikjan xa tondó, ¿á xrojan jaꞌanta xrondachenta xa: “Xrokuia takeꞌé sinte”? ");
INSERT INTO pps_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Naꞌi, jaꞌanta xrondachenta xi nchexra̱ meꞌe: “Xakonꞌan nchéñana̱na sine, ko tikia sine ko tsiꞌi, ko tjumeꞌe takeꞌé sinte jaꞌa.” ");
INSERT INTO pps_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Ko, ¿á kaxon tájonnta juasaya ngajin xi nchexra̱ ixi kuitikaon xa ngeꞌe kuituenꞌennta xa? ");
INSERT INTO pps_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Jaña kaxon jaꞌanta, ti tsjexin sincheꞌenta kain ti kuetuanꞌannta ndo Dio, xrondachronta: “Janꞌanna xi nchexra̱ xroꞌan tundana; ixi jeꞌo juintaꞌana ixra̱ tikinixinnana sintaꞌana.” ");
INSERT INTO pps_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Ndo Jesús tingakitji ndo tjajna Jerusalén, kuatsinga ndo itsjé tjajna tikinixinꞌen nunte Samaria ko nunte Galilea. ");
INSERT INTO pps_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Ko tjumeꞌe kuiji ndo tjenka naa tjajna, ko tjajna meꞌe kuachrjexin ite xi níexin chinlepra. Ko konchjiñeꞌa xa tjenka ndo, ikjíon kuíxi xa. ");
INSERT INTO pps_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Ko xi niꞌe meꞌe kuyako xa ndache xa ndo: ―¡Jesús, Maestro, tikonóaꞌnananta! ");
INSERT INTO pps_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Ko hora bikon ndo Jesús xi niꞌe ndachro ndo: ―Itjinta ko tjakonta ngajin xi taana tjako ley. Ko xranchi stetji xi niꞌe, kuachrje chinꞌen xa ko koxruenꞌen xa. ");
INSERT INTO pps_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Ko naa xi niꞌe meꞌe, bikon xa ixi koxruenꞌen xa, ikjan xa ko kuajon xa juasaya ngajin ndo Dio. ");
INSERT INTO pps_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Bakeꞌexin xa ntatuchiꞌin xa ngajin ndo Jesús, ko kuisée xa ngataꞌa nche, kuajon xa juasaya ngajin ndo. Ko xi meꞌe, xi tjajna Samaria. ");
INSERT INTO pps_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Ko tjumeꞌe ndachro ndo Jesús: ―¿Á jeꞌa ite xi koxruenxin ichin lepra? ¿No ste xi kaxin? ");
INSERT INTO pps_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","¿Á jeꞌo xi jiꞌi, xi kui̱xi̱n ikjín, ikjan xa chjée xa juasaya ndo Dio? ");
INSERT INTO pps_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Ko tjumeꞌe ndo Jesús ndache ndo xi meꞌe: ―Tingatjen ko satjia; ixi nduaxin chuntia ndo Dio, méxin koxruanꞌan. ");
INSERT INTO pps_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Ko tjumeꞌe xi fariseo juanchangiꞌe xa ndo Jesús, ngisa tsi̱i̱ nchakon tsetuanꞌan ndo Dio, ko ndo Jesús juatingíexin ndo: ―Nchakon tsi̱i̱ ti tsetuanꞌan ndo Dio, ni chúxinꞌa ndo juaꞌi tsikon na̱ ti tetuanꞌan ndo. ");
INSERT INTO pps_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Juaꞌi xrondachro na̱: “Ntiꞌi jii”, o̱ “no jiꞌa jii”, ixi ti tetuanꞌan Ndo Dio jii ngaya aséen ni titikaon. ");
INSERT INTO pps_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Ko tjumeꞌe ndache ndo sen teyuu chrikao ndo: ―Tsi̱i̱ nchakon xrotjaunnta tsikonnta, maski naakua nchakon, chjenꞌen ndo Dio, xjan jongíꞌe xranchi chujni, ixi kain juachaxien xjan, ko ítsikonꞌanta. ");
INSERT INTO pps_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Ko xrontatjunta na̱ ixi ntiꞌi jii ndo o̱ no jiaꞌa jii ndo, ko jaꞌanta tjiꞌanta ko rueꞌanta na̱. ");
INSERT INTO pps_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Xranchi tikonni tóngíxin ko tsingasáña nchijíi ngajní, jaña tsonꞌen nchakon xrokjanna janꞌan, chjenꞌen ndo Dio, xjan jongíꞌe xranchi chujni. ");
INSERT INTO pps_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Ko xrokonda tsango tangi tsónna ko ni jii jai tsitikaonꞌa na̱ ko xrotjaunꞌana na̱ janꞌan. ");
INSERT INTO pps_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Méxin xranchi konꞌen nchakon bakeꞌe ndo Noé, jaña tsonꞌen kaxon nchakon xrokjanna janꞌan, chjenꞌen ndo Dio, xjan jongíꞌe xranchi chujni. ");
INSERT INTO pps_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Ixi nchakon bakeꞌe ndo Noé, kain na̱ bajine na̱ ko bakiꞌi na̱ ko bakute̱ꞌe na̱ ko bakajon na̱ chjenꞌen na̱ tsuteꞌe xjan. Ko ti kuitja nchakon kuixinꞌin ndo Noé nta̱barco ko kuania ichrin, kain na̱ kuituꞌe na̱ nduja ko kuenꞌen na̱. ");
INSERT INTO pps_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Jaña konꞌen kaxon nchakon bakeꞌe ndo Lot, ni meꞌe bajine na̱ ko bakiꞌi na̱, bakeꞌna na̱ ko banchekji na̱, bakenga na̱ ko banchekonchjian na̱ nchia. ");
INSERT INTO pps_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Ko nchakon kuachrjexin ndo Lot tjajna Sodoma, kuaniaxin ngajní xroꞌi ko ndagaa azufre, ko meꞌe kuenxin kain na̱. ");
INSERT INTO pps_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Jaña tsonꞌen nchakon xrokjanna janꞌan, chjenꞌen ndo Dio, xjan jongíꞌe xranchi chujni. ");
INSERT INTO pps_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","*’Ko nchakon meꞌe xrojan ngisen jii ngataꞌa ndoꞌa, ko xrojan ngeꞌe kuintuꞌe na̱ ngaxinꞌin nchia, xroxingajinꞌa na̱ xrotsé na̱ ngeꞌe jii ngaxinꞌin nchia. Ko siá xrojan ngisen jii ngataon ijngi, cháña xrokjanꞌina na̱ ndoꞌa na̱. ");
INSERT INTO pps_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Xraxaonnta xranchi konꞌen janchriꞌe ndo Lot. ");
INSERT INTO pps_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","*Ni ícha tjaun chaxro tsakeꞌe ngataꞌa nunte ntiꞌi, ni meꞌe tsitjáña na̱, ko ngisen tsjée ixi titikaon sen chijnie ndo Dio, sen meꞌe sinchetjáñaꞌi sen aséen sen. ");
INSERT INTO pps_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","’Janꞌan ntatjunta ixi tiie meꞌe, ti yuu ngisen stejua ngataꞌa naa kania, naa na̱ tsajinꞌin na̱ ngajní ko inaa na̱ tsituꞌe na̱. ");
INSERT INTO pps_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Kaxon, siá jii yuu nchri stetaꞌo nchra, naa nchra tsajinꞌin nchra ngajní ko naa nchra tsituꞌe nchra. ");
INSERT INTO pps_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Yuu xi jincheꞌe xa ixra̱ ngataon ijngi, naa xa tsajinꞌin xa ngajní ko naa xa tsituꞌe xa. ");
INSERT INTO pps_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Ko tjumeꞌe chujni kuinꞌen jiꞌi, juanchangiꞌe na̱ ndo Jesús ko ndachro na̱: ―¿Tinó tsoenxin ti rindachronta? Ko ndo Jesús juatingíexin ndo: ―Ti jii cuerpoe ti tsikenꞌen, ntiꞌa tjangataon kuntachrjen. ");
INSERT INTO pps_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Ndo Jesús juinchekuenꞌen ndo sen teyuu chrikao ndo ixi kain nchakon xronichjeꞌe sen ndo Dio ko tsonchrjenꞌa sen sincheꞌe sen meꞌe. ");
INSERT INTO pps_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Méxin jaꞌin nichja ndo: ―Bakeꞌe naa xi juez, kuachóndeꞌa xa juasaya ndo Dio, ko chóndeꞌa xa juasaya ngajin chujni. ");
INSERT INTO pps_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Ko tjajna meꞌe bakeꞌe kaxon naa nchri kaꞌan, nchri meꞌe nanaó bakji nchra ngajin xi juez ñaꞌi ixi tjanchia nchra tsoñeꞌe nchra ijie̱ ngajin naa xi bake̱to̱kaꞌo nchra. ");
INSERT INTO pps_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Tsango kueya vez ikjui nchra kuitsjeꞌe nchra xi juez meꞌe ixi sinchéña xa ijie̱, ko jeꞌe xa juincheꞌa xa nchra kuenta, ko tjumeꞌe xraxaon xi juez meꞌe: “Maski janꞌan chondaꞌi juasaya ndo Dio ko chondaꞌi juasaya chujni, ");
INSERT INTO pps_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","ixi nchri kaꞌan jiꞌi nanaó ti̱i̱ nchra tjanchia nchra ijie̱ ko tsango tajondaxin nchra ixra̱, janꞌan cháña sintaña ijie̱ ngajin nchra ixi jaña ítsiꞌa nchra ícha.” ");
INSERT INTO pps_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Ko ndachro ndo Jesús: ―Jaña ndachro xi juez ñaꞌi. ");
INSERT INTO pps_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Méxin, ¿á jeꞌa ndo Dio ícha tsingijna ndo kain sen kuincheꞌe ndo ti tinóatée sen ngajin ndo tiie, nchakon? ¿Á tsonchrjenꞌen ndo tsjateꞌe ndo? ");
INSERT INTO pps_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Janꞌan ndachrja̱n ixi jeꞌe ndo tuinxin tsingijna ndo sen. Ko nchakon xrokjanna janꞌan, Chjenꞌen ndo Dio, xjan jongíꞌe xranchi chujni, ¿á xratsitja ngisen ngataꞌa nunte ntiꞌi xrochuntia ngajin janꞌan? ");
INSERT INTO pps_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Ko tjumeꞌe ndo Jesús beki ndo inaa chijni ngajin kaxin ni xraxaon ixi jeꞌe na̱ tsango jian na̱, ko batjaunꞌa na̱ ni kaxin. Ko ndachro ndo: ");
INSERT INTO pps_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","―Yuu xi ikjui xa niꞌngo kuinichjeꞌe xa ndo Dio. Naa xi fariseo, ko naa xi tjáka tomie tjajna Roma. ");
INSERT INTO pps_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Ko xi fariseo meꞌe siin xa, jinichjeꞌe xa ndo Dio jaꞌin: “Ndotána Dio, juasianta ixi janꞌan chondaꞌi ijie̱ xranchi xicheꞌe, xiñaꞌi, ko xi ncheyeꞌe janchriꞌe ko xranchi xi tjáka tomi jiꞌi. ");
INSERT INTO pps_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Janꞌan ntakatsaꞌa aséenna yuu nchakon ngujngu semana, ko tantsjendáa tomi ti tjacha ngujngu semana tikinixinꞌen Ndo Dio.” ");
INSERT INTO pps_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Ko xi tjáka tomi siin xa nchion ikjín ko jiséya xa nunte, tjenduaꞌi ikon xa noi, ko tandeꞌe xa ntakuin xa ko ndachro xa: “¡Ndotána Dio, tikonóananinta ixi chonda ijie̱!” ");
INSERT INTO pps_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","*’Ko janꞌan ndachrja̱n ixi xi tjáka tomi, ícha jian ikjan xa ndoꞌa xa ixi ndo Dio juincheméꞌe ndo kain jíee xa, ko xi fariseo naꞌi. Méxin ngisen ícha tojié, ícha tjinteꞌa na̱ ngajin ndo Dio. Ko ngisen tojiéꞌa, Ndo Dio ícha xrotjueꞌe ndo sen. ");
INSERT INTO pps_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Kaxon itsjé na̱ bikao na̱ chjenꞌen na̱ ti jii ndo Jesús ixi jeꞌe ndo tsakeꞌe ndo itja ndo ngataꞌa jaa xjan. Ko sen teyuu chrikao ndo, kuaxi sen kuyakutee sen ni bikao chjenꞌen. ");
INSERT INTO pps_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Ko ndo Jesús kuiyeꞌe ndo sen ko ndachro ndo: ―Tintuꞌenta ichjan tsi̱i̱ xjan ngajin, ko tingakuenꞌanta xjan. Ixi ngisen tayéꞌe ti tetuanꞌan ndo Dio, sen meꞌe, ikjan sen xranchi naa ichjan. ");
INSERT INTO pps_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Nduaxin xrontatjunta ngisen xrokjanꞌi xranchi naa chjan, juaꞌi tsayéꞌe sen ti tetuanꞌan ndo Dio. ");
INSERT INTO pps_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Naa xi tetuanꞌan ningue ni judío juanchangiꞌe xa ndo Jesús ko ndachro xa: ―Maestro, jian jaꞌanta, ndachronta, ¿ingeꞌe sintaꞌa ixi tsjacha tsarichón kain nchakon? ");
INSERT INTO pps_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Ko tjumeꞌe ndo Jesús ndachro ndo: ―¿Sonda ndachijiana ixi jianna? Xroꞌan ngisen jian, jeꞌo Ndo Dio jian ndo. ");
INSERT INTO pps_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Ó noꞌa chijnie ndo Dio: “Xrochondaꞌia inaa nchri, tóñaiꞌa chujni, temaꞌia, jeꞌa xruenxon tjankataꞌa ijie̱ inaa chujni, ko chóndeꞌe juasaya ndotáa ko janáa.” ");
INSERT INTO pps_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Ko jeꞌe xa ndachro xa: ―Kain ña̱ ó juintaꞌa, xranchiona. ");
INSERT INTO pps_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Ko kuinꞌen ndo Jesús ngeꞌe ichro xa, ko jeꞌe ndo juatingíexin ndo: ―Xratitjáña naa ngeꞌe sincheꞌe. Nchekjia kain ngeꞌe chonda ko tonchjeyeꞌé ni nóa tomi meꞌe, ko xrochónda ngeꞌe ícha tjintee ngajní. Ko tjumeꞌe tsjiꞌia ruaꞌna̱na. ");
INSERT INTO pps_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Ko xi meꞌe kuinꞌen xa ngeꞌe ichro ndo ko tsango kuechíín xa ixi itsjé ngeꞌe tjintee chónda xa. ");
INSERT INTO pps_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Ko ti bikon ndo Jesús ixi tsango kuechíín xa, ndachro ndo: ―¡Tangi tixinꞌin naa ngisen chónda itsjé tomi ti tetuanꞌan Ndo Dio! ");
INSERT INTO pps_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Ícha tangiꞌa tixinꞌin naa kucamello ikon naa ntachika ixi naa ngisen chónda itsjé tomi tixinꞌin ti tetuanꞌan ndo Dio. ");
INSERT INTO pps_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Ko ni kuinꞌen jiꞌi ndachro na̱: ―¿Ngisen chao tixinꞌin ti tetuanꞌan ndo Dio tjumeꞌe? ");
INSERT INTO pps_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Ko juatingíexin ndo Jesús: ―Ngeꞌe juaꞌi sincheꞌe chujni, Ndo Dio chao sincheꞌe ndo. ");
INSERT INTO pps_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Ndo Pedro ndache ndo ndo Jesús: ―Nchána, janꞌanna kuintuꞌana kain ti kuachondana ko ruaꞌananta. ");
INSERT INTO pps_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Ko ndo Jesús juatingíexin Ndo: ―Janꞌan nduaxin ntatjunta ixi ngisen kuintuꞌe ndoꞌa, ndotée, ko janée, xjan kichuu, o̱ janchriꞌe, chjenꞌen ixi kondeexin chijnie Ndo Dio ko ngeꞌe tetuanꞌan ndo, ");
INSERT INTO pps_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","sen meꞌe ícha itsjé ngeꞌe tsayéꞌe sen jai ti jichón sen ngataꞌa nunte ntiꞌi, ko kaxon tsayéꞌe sen nchakon tsi̱i̱ ti tsechónni kain nchakon. ");
INSERT INTO pps_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Ndo Jesús kuiyeꞌe ndo sen teyuu chrikao ndo ko ndachro ndo: ―Jai satsjina tjajna Jerusalén. Ko ntiꞌa tsoenxin kain ti tsikjin sen profeta ó saꞌó xranchi sinchekaona, chjenꞌen ndo Dio, xjan jongíꞌe xranchi chujni. ");
INSERT INTO pps_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Ko ni meꞌe tsajon na̱ xjan ngajin ni jeꞌa tjajna judío ko ni meꞌe tsjanoana xjan, ko chinga xrondache na̱ xjan, ko tsikitéena na̱ xjan ndatée na̱. ");
INSERT INTO pps_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Tsaxi na̱ xjan nta̱a̱ ko ito̱n ko naatsóñaxón na̱ xjan. Ko nchakon nínxin xroxechón xjan. ");
INSERT INTO pps_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Ko sen teyuu chrikao ndo Jesús kuienxinꞌa sen ti nichja ndo, ixi juaꞌi xrokuienxin sen. ");
INSERT INTO pps_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Ko nchakon ndo Jesús ko sen teyuu chrikao ndo kuiji sen tjenka tjajna Jericó, ko ngandeꞌe chaꞌo bakeꞌe naa xi juaꞌi tikon ko jitjanchiakaꞌa xa. ");
INSERT INTO pps_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Ko jeꞌe ti xi tikonꞌa kuinꞌen xa ixi jitatsinga itsjé na̱, méxin juanchangi xa ngeꞌe jitonꞌen. ");
INSERT INTO pps_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Ko ndache na̱ xa ixi ndo Jesús tjajna Nazaret jitatsinga ndo ntiꞌa. ");
INSERT INTO pps_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Ko tjumeꞌe jeꞌe xa séen kuyako xa: ―¡Jesús, kuachrjenixinnta ndo David, tikonóananinta! ");
INSERT INTO pps_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Ko ni stetaon ntiꞌa koñaoꞌe na̱ xa ko ndachro na̱ ixi xrotenko xa ko jeꞌe xa ícha séen kuyako xa: ―¡Jaꞌanta kuachrjenixinnta ndo David, tikonóananinta! ");
INSERT INTO pps_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Ko tjumeꞌe ndo Jesús chónꞌen ndo ko kuetuanꞌan ndo ixi tsikaꞌo na̱ xi tikonꞌa. Ko bikaꞌo na̱ xa ti jii ndo, ko tjumeꞌe jeꞌe ndo Jesús juanchangiꞌe ndo xa: ");
INSERT INTO pps_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","―¿Ngeꞌe tjauan sintaꞌa ixi jaꞌa? Ko xi tikonꞌa juatingíexin xa: ―Nchána, janꞌan tjaꞌon tsikon. ");
INSERT INTO pps_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Ko ndo Jesús ndachro ndo: ―¡Chao tsikuan!, ixi chuntia meꞌe koxruanꞌan. ");
INSERT INTO pps_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Hora meꞌe xi juaꞌi bakikon chao bikon xa, ko ruéꞌe xa ndo Jesús, ko jitajon xa juasaya ngajin ndo Dio. Ko kain ni bikon ngeꞌe juincheꞌe Ndo Jesús kaxon kuajon na̱ juasaya ngajin ndo Dio. ");
INSERT INTO pps_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Ko Ndo Jesús kuiji ndo tjajna Jericó ko kuixinꞌin ndo tjajna meꞌe. ");
INSERT INTO pps_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Ko ntiꞌa bakeꞌe naa xi chónda itsjé tomi ndatinꞌin xa Zaqueo. Xi meꞌe tetuenꞌen xa xi tjejo tomie xi tetuanꞌan tjajna Roma. ");
INSERT INTO pps_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Ko jeꞌe xa tjaun xa tsikon xa ndo Jesús. Ko juaꞌi tikon xa ndo ixi tsango itsjé na̱ jii na̱ ntiꞌa, ko jeꞌe xi Zaqueo jine̱ꞌa xa. ");
INSERT INTO pps_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Méxin binga xa kuitaon xa ko kuajinꞌin xa naa nta̱a̱ ndatinꞌin sicómoro, ti no tsatsinga ndo Jesús. ");
INSERT INTO pps_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Ko hora kuatsinga ndo Jesús, tsjeꞌe ndo noi ti jii xi Zaqueo ko ndachro ndo: ―Zaqueo, jaiko xingajian ixi jai xrokonda tsituna ndúya. ");
INSERT INTO pps_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Tjumeꞌe xi Zaqueo jaiko xingajin xa, ko tsango juaxruxin bakeꞌe xa ixi ndo Jesús tsituꞌe ndo ndoꞌa xa. ");
INSERT INTO pps_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Ko kain na̱ bikon na̱, ko kuaxi na̱ nichja na̱ ixi sonda ndo Jesús itsji ndo tsikituꞌe ndo ndoꞌa naa xiñaꞌi. ");
INSERT INTO pps_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Ko tjumeꞌe xi Zaqueo ndache xa ndo Jesús: ―Nchána, jai xrotjáꞌa ni nóa ngusinexin kain ngeꞌe chonda, ko siá xrojan ngisen juintayaꞌa ko kueꞌé tomie na̱, janꞌan tsonkjanꞌan na̱ noóxin ícha ti kuantsjaꞌa na̱. ");
INSERT INTO pps_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Ko ndo Jesús ndache ndo xi Zaqueo: ―Jai ndo Dio tsantsje ndo jíee ni ste nchia ntiꞌi, ixi kaxon xi jiꞌi kuachrjenixin xa ndo Abraham. ");
INSERT INTO pps_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","*Méxin, janꞌan chjenꞌen ndo Dio, xjan jongíꞌe xranchi chujni, juiꞌi bijée ngisen tsikitjáña ko tsantsje ijie̱ chónda sen. ");
INSERT INTO pps_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Ko ndajitinꞌen na̱ ngeꞌe jindachro ndo Jesús ko beki ndo naa chijni juakoxin ndo, ixi ó kuiji ndo tjenka tjajna Jerusalén, ko ixi jeꞌe na̱ xraxaon na̱ ixi ndo Dio ó tsaxi ndo tsetuanꞌan ndo ngataꞌa nunte ntiꞌi. ");
INSERT INTO pps_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Méxin ndachro ndo: ―Bakeꞌe naa xi, xi meꞌe chjenꞌen kaxin ni tetuanꞌan ko sakjui xa ikjín inaa nunte ixi ntiꞌa jeꞌe xa xrokjan xa rey, ko tjumeꞌe xrokjan xa tjajnée xa. ");
INSERT INTO pps_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Ko ó xrokuachrjexin xa tjajnée xa, méxin kuiyeꞌe xa ite xi nchexrée xa ko chjée xa xi nchexra̱ kaxin tomi ngujngu xa, ko ndachro xa: “Nchejincheꞌenta tomi jiꞌi ixra̱ xrokjanjan janꞌan.” ");
INSERT INTO pps_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Ko ni tjajnée xi meꞌe ningakonꞌen na̱ xa, méxin xruanꞌan na̱ kaxin ni xrondachro: “Tjaunꞌana xi jiꞌi xrokjan xa rey tsetuanna̱na.” ");
INSERT INTO pps_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Ko tjumeꞌe, juexin kuayéꞌe xa juachaxin ikjan xa rey, ko nchakon ikjan xa tjajnée xa kuetuanꞌan xa tsi̱i̱ ni nchexrée xa, ni chjeyeꞌe tomi, ixi tjaun xa tsonoꞌe xa ngijanꞌin juacha tomi kuajon xa ngajin ngujngu na̱. ");
INSERT INTO pps_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Xi ícha tuinxin konchjiñeꞌe ndachro xa: “Nchána, tomi chjána̱na juacha íjngo ite tomi xranchi chjána̱na.” ");
INSERT INTO pps_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Ko jeꞌe xi rey ndachro xa: “Chao; jian juincheꞌe ixra̱, ixi jian juinchejincheꞌe ti kueyaꞌi tjáꞌa, méxin jai xrotjáꞌa juachaxin tsituanꞌan ite tjajna.” ");
INSERT INTO pps_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Tjumeꞌe konchjiñeꞌe inaa xi nchexra̱ ko ndachro xa: “Nchána, ti tomi chjána̱na juacha tomi íjngo naꞌó tomi xranchi chjána̱na.” ");
INSERT INTO pps_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Xrajeꞌo jaña ndachro xi rey xranchi ndache xa xi saꞌó kui̱i̱: “Janꞌan xrotjáꞌa juachaxin tsetuanꞌan naꞌó tjajna.” ");
INSERT INTO pps_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Ko tjumeꞌe konchjiñeꞌe inaa xi nchexrée xa ko ndachro xa: “Ntiꞌi jii tomia chjána̱na. Janꞌan kuatsíin tomi ngaya naa panito ");
INSERT INTO pps_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","ixi janꞌan xronkana ixi jaꞌa naa xi tsango ntueꞌe, ko tatsían ngeꞌe jeꞌa naꞌa, ko tatsían ti no bengaꞌia.” ");
INSERT INTO pps_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Tjumeꞌe xi rey ndachro xa: “Jaꞌa jeꞌa naa xi nchexra̱ jian, ixi ti ndachrua jaꞌua kuama ijie̱. Siá ó noꞌa ixi janꞌan tsango ntuena, ixi tjaꞌo ti no xroꞌan ngeꞌe bakée, ko tatsiin ti no bengaꞌi, ");
INSERT INTO pps_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","¿sonda bikanꞌia tomina naa nchia nchejinchexina tomi ixra̱ ixi jaña nchakon xrojuiꞌi xrokuaya tomina ko ti juacha tomi?” ");
INSERT INTO pps_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Ko ndache xi Rey ni ste ntiꞌa: “Tantsjeꞌenta xi jiꞌi tomi kuayéꞌe xa ko tájonnta tomi ngajin xi chónda ite tomi.” ");
INSERT INTO pps_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Ko jeꞌe na̱ ndachro na̱: “Nchána, ¿sonda tsayéꞌe jeꞌe xa siá ó chónda xa ite tomi?” ");
INSERT INTO pps_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","*Ko xi Rey ndachro xa: “Janꞌan ntatjunta, ngisen chónda itsjé, sen meꞌe ícha tsayéꞌe sen, ko ni xroꞌan chónda ko maski ti nchíín chónda na̱ tsachrjeꞌe na̱. ");
INSERT INTO pps_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","*Ko kain ni ningakonna, ni tjaunꞌana ixi janꞌan xrokuayaꞌa̱ juachaxin tsetuanꞌan ngataꞌa nunte ntiꞌi, tikuunta na̱ ntiꞌi ixi tsikon xranchi tsenꞌen na̱.” ");
INSERT INTO pps_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Juexin ndachro ndo Jesús kain jiꞌi, íjngo kua ndo chaꞌo itji tjajna Jerusalén. ");
INSERT INTO pps_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Ko tjumeꞌe kuiji sen tjenka tjajna Betfagé ko tjajna Betania, tjenka ijna̱ ndatinꞌin Olivo, jeꞌe ndo kuetuenꞌen ndo yuu sen chrikao ndo ");
INSERT INTO pps_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","ko ndache ndo sen: ―Itjinta nchia ste no yáꞌa, ko ti tsjasonta ntiꞌa tsinchíinta naa kuntajno jichroá ba ntiꞌa ko xraxroꞌan ngisen tetaꞌa ba. Tonxindangeꞌenta ba ko tikuunta ba ntiꞌi. ");
INSERT INTO pps_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Ko siá xrojan ngisen tsjanchangiꞌanta ko xrondachro na̱: “¿Sonda tonxindangeꞌenta kuntajnona?”, jaꞌanta tjatingíexinnta: “Nchána̱na xrokondeꞌe ndo ba.” ");
INSERT INTO pps_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Ko sen xruanꞌan ndo ikjui sen ko kuitja sen kuntajno xranchi ndachro ndo. ");
INSERT INTO pps_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Ko stetoxindangeꞌe sen kuntajno meꞌe, kui̱i̱ ni kuntajnoé ko ndachro na̱: ―¿Sonda tonxindangeꞌenta kuntajnona? ");
INSERT INTO pps_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Ko jeꞌe sen juatingíexin sen: ―Ixi Nchána̱na xrokondeꞌe ndo ba. ");
INSERT INTO pps_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Ko tjumeꞌe bikaꞌo sen ba ti no jii ndo Jesús, ko bakeꞌe sen ti tetsáa sen ngataꞌa ba ko juinchekitaꞌa sen ndo kuntajno. ");
INSERT INTO pps_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Ko ti jitatsinga ndo, bingó na̱ ti tetsáa na̱ ngatja chaꞌo ti jitatsinga ndo Jesús. ");
INSERT INTO pps_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Ko stetonchjiñeꞌe sen ti xingajinxinni ijna̱ Olivo, tsango itsjé na̱ steruéꞌe na̱ ndo Jesús ko chéꞌe na̱, méxin séen kuyako na̱ stetajon na̱ juasaya ngajin ndo Dio ixi tsango itsjé ngeꞌe jian bikon na̱ juincheꞌe ndo Jesús. ");
INSERT INTO pps_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Ko séen ndachro na̱: ―¡Itsjé juachaxin chónda ndo Rey, ndo jiti̱i̱ tsixruaꞌan ndo Dio! ¡Chaxro ko ijié juaxruxin tsakeꞌe ngajní ko ijié juasaya tsayéꞌe ndo Dio! ");
INSERT INTO pps_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Tjumeꞌe kaxin xi fariseo ste xa ngakjenꞌen ni ntiꞌa ndachro xa: ―Maestro, tetuenꞌén chujnia xrotenko na̱. ");
INSERT INTO pps_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Jeꞌe ndo Jesús juatingíexin ndo ko ndachro ndo: ―Janꞌan ntatjunta ixi siá xrotenko chujnina, ixro tsaxi ixro xronichja ixro. ");
INSERT INTO pps_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Ti kuiji ndo Jesús tjajna Jerusalén, bikon ndo tjajna, jeꞌe ndo tsjangaxin ndo tjajna meꞌe, ");
INSERT INTO pps_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","ko ndachro ndo: ―¡Siá nchakon jai jaꞌa xrokuichuxianna, xrokuayeꞌé ijié juaxruxin! Ko jai jaꞌa tienxinꞌa ixi jijeꞌe̱ ikuan. ");
INSERT INTO pps_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Ko tsi̱i̱ nchakon tangi ngajian ixi tsi̱i̱ kaxin tjajna xroningakonꞌan ko tsijaꞌa na̱ ko tsingakonꞌan na̱ nguixin ngandajian, ko tse̱ꞌto̱ na̱ ngajian. ");
INSERT INTO pps_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Ko tsjacha na̱ tsóña na̱, jaꞌa ko kain chjanꞌan, ko kain tjatuꞌo ndúya tsonchjejin na̱, tsintueꞌa na̱ ninaa ixro ngataꞌa inaa ixro. Ixi jaꞌa kuichuxinꞌa nchakon kui̱i̱ ndo Dio ngajian. ");
INSERT INTO pps_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Nchakon kuixinꞌin ndo Jesús ngaxinꞌin niꞌngo ijié jii tjajna Jerusalén, kuaxi ndo kuantsje ndo kain ni stenchekji ko ni steteꞌna ntiꞌa. ");
INSERT INTO pps_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Ko ndachro ndo: ―Chijnie ndo Dio ndachro: “Nía ndatinꞌin nchia nichjanaxinna sen”, ko jaꞌanta juinchekjannta ncha ndoꞌe xicheꞌe. ");
INSERT INTO pps_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","*Kain nchakon bakeꞌe ndo Jesús ngaxinꞌin niꞌngo meꞌe, ko banchekuenꞌen ndo chujni chijnie ndo Dio. Ko xitaana baketuanꞌan, ko kain xi tjako ley, ko kain xi baketuanꞌan tjajna meꞌe jitjee na̱ xranchi tsóña na̱ ndo Jesús. ");
INSERT INTO pps_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Ko kuitjaꞌi na̱ xranchi tsóña na̱ ndo Jesús ixi kain na̱ stetinꞌen na̱ ngeꞌe jichro ndo. ");
INSERT INTO pps_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Naa nchakon ndo Jesús juinchekuenꞌen ndo na̱ ngaxinꞌin niꞌngo ijié, xranchi ndo Dio tsantsje ndo ijie̱ chónda na̱. Hora meꞌe kuiji kaxin xitaana, xi ícha tetuanꞌan, ko xi tjako ley, ko kaxon kaxin xi tetuanꞌan. ");
INSERT INTO pps_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Ko ndache xa ndo Jesús: ―Ndachijiana ngisen tjáa juachaxin ixi jaña ncheꞌe o̱, ¿ngisen tjáa juachaxin jiꞌi? ");
INSERT INTO pps_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Ko ndo Jesús juatingíexin ndo ko ndachro ndo: ―Kaxon janꞌan tsjanchangiꞌanta naa ngeꞌe ko tjatingíexinnta. ");
INSERT INTO pps_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿Ngisen xruanꞌan ndo Juan, ndo bikitée chujni? ¿Á ndo Dio o̱ chujni? ");
INSERT INTO pps_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Ko kuaxi xa tjakaxin kichuu xa ko ndachro xa: ―¿Ngeꞌe tsjatingíexinna? Siá xrondachrona ixi ndo Dio tsixruaꞌan xi Juan, xi Jesús xrondachro xa: “¿Sonda kuitikaonꞌanta xa tjumeꞌe?” ");
INSERT INTO pps_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Ko siá xrondachrona ixi chujni xruanꞌan xa, kain ni ste ntiꞌi tsoñao na̱ ko tsaxinna na̱ ixro, ixi noꞌe na̱ ixi xi Juan naa ndo profeta. ");
INSERT INTO pps_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Méxin jeꞌe xa juatingíexin xa: ―Nónaꞌina ngisen xruanꞌan xi Juan. ");
INSERT INTO pps_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Tjumeꞌe ndachro ndo Jesús: ―Kaxon janꞌan xrontatjuꞌinta ngisen chjána juachaxin ntaꞌa jiꞌi. ");
INSERT INTO pps_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Ndo Jesús kuaxi ndo nichja ndo chijni jiꞌi ko ndachro ndo: ―Bakeꞌe naa xi benga nta̱a̱ tu uva nunteꞌe xa, ko tjumeꞌe kuajon xa nunte ngajin inaa xi sincheꞌe xa ixra̱ ko sakjui xa kaxin nano. ");
INSERT INTO pps_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Ko kui̱i̱ nchakon xroxejo itu meꞌe, xruanꞌan xi nunteꞌe naa xi nchexrée xa ixi xrokuayéꞌe xa itu tikinixinꞌen xi nunteꞌe. Ko jeꞌe xi kuayéꞌe nunte xroꞌan ngeꞌe kuajon xa, ko juaya xa ngajin xi xrokuayéꞌe itu ko bengi kichuu xa. ");
INSERT INTO pps_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Tjumeꞌe xruanꞌan xi nunteꞌe inaa xi nchexrée xa. Ko kaxon jaña juinchekao na̱ xa, juaya na̱ ngajin xa ko kuyakutee kichuu xa, ko xroꞌan ngeꞌe kuayéꞌe xa. ");
INSERT INTO pps_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Ko tjumeꞌe xi nunteꞌe xruanꞌan xa inaa xi nchexrée xa. Ko kaxon xi meꞌe xrajeꞌo juinchekaon na̱ xa ko bengi na̱ xa. ");
INSERT INTO pps_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","’Ko tjumeꞌe xi nunteꞌe ndachro xa: “¿Ngeꞌe sintaꞌa? Xroxruanꞌan chjanꞌna, xjan tsango tjuaꞌa. Ko siá tsikon na̱ chjanꞌna tsitikaon na̱ ko tsajon na̱ juasaya ngajin xjan.” ");
INSERT INTO pps_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Ko jeꞌe xi kua nunte, bikon xa chjenꞌen xi nunteꞌe, ndache xa xi kaxin xi ncheꞌe ixra̱: “Xjan jiꞌi tsayéꞌe xjan nunteꞌe ndotée xjan, méxin naatsóñaxón na̱ xjan ixi tsintueina kain ngeꞌe tikinixinꞌen xjan.” ");
INSERT INTO pps_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Ko tjumeꞌe kuantsjexin na̱ xjan ngataꞌa nunte ko naakóñaxón na̱ xjan. Ko ndo Jesús ndachro ndo: ―¿Ngeꞌe sincheꞌe xi nunteꞌe ngajin ni nchexra̱ ñaꞌi? ");
INSERT INTO pps_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Jeꞌe xa itsji xa ko naatsóñaxón xa xi kua nunte, ko tsajon xa nunteꞌe xa ngajin ikaxin na̱. Hora kuinꞌen na̱ jiꞌi, ndachro na̱: ―¡Ndo Dio tsajonꞌa juachaxin tsonꞌen jiꞌi! ");
INSERT INTO pps_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Ko ndo Jesús jitsjeꞌe ndo na̱ ko ndachro ndo: ―Méxin, ¿ngeꞌe xrondachro xroon chijnie ndo Dio ti jitaxin jaꞌin? Ixro jueñaoꞌa ni nchekonchjian nchia, ixro meꞌe ikjan ixro ícha tjintee. ");
INSERT INTO pps_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Ko ngisen tsitsingataꞌa ixro jiꞌi, ni meꞌe tsaki kain nteꞌe na̱. Ko siá ixro tsitsingataꞌa ixro ngataꞌa naa ngisen, ni meꞌe xrokjan na̱ xranchi inche. ");
INSERT INTO pps_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Ko tjumeꞌe kain xitaana baketuanꞌan ko xi tjako ley tjaun xa xrotsé xa ndo Jesús ixi kuienxin xa contre xa nichja ndo. Ko juaꞌi itsé xa ndo ixi xrakonꞌen xa ni tjajna. ");
INSERT INTO pps_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Méxin xruanꞌan xa kaxin xi xrotsjaya xa ndo Jesús ko xi meꞌe sincheꞌe xa xranchi ngisen tsango jian ko nduaxinꞌa, xi meꞌe stechónꞌen xa ixi nchéxin tsinꞌen xa xronichja ndo Jesús naa ngeꞌe ndakuaꞌi ixi jaña tsjangíꞌe xa ndo ngajin xi tetuanꞌan. ");
INSERT INTO pps_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Méxin juanchangi xi stetsjaya ndo Jesús: ―Maestro, nónana ixi kain ti nichjanta ko ti tjakonta meꞌe ti nduaxin ko ti tjaun ndo Dio, ko jaꞌanta tincheꞌanta kaxion chujni, ixi jaꞌanta tjueꞌenta kain na̱. ");
INSERT INTO pps_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Ko jai ndachijinnta: ¿á chao tsjengana ꞌna̱ ngajin xi tetuanꞌan, o̱ á naꞌi? ");
INSERT INTO pps_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Ko ndo Jesús konoꞌe ndo ixi ndakoꞌa stexraxaon xa, méxin ndachro ndo: ―¿Sonda tjaunnta sincheyananta? ");
INSERT INTO pps_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Tjakoꞌnanta naa tomi. ¿Ngisen ikon jinito ntiꞌi, ko ngeꞌe jitaxin? Ko jeꞌe xa juatingíexin xa ko ndachro xa: ―Ikon xi César. ");
INSERT INTO pps_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Méxin ndachro ndo Jesús: ―Chje̱ꞌénta xi César ti tikinixinꞌen xa, ko chje̱ꞌénta ndo Dio ti tikinixinꞌen ndo tsayéꞌe ndo. ");
INSERT INTO pps_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Ko juachaꞌi xa sinchenichja xa ndo Jesús ninaa ngeꞌe ndakoꞌa ngatoxin ni tjajna jitinꞌen. Ko jeꞌe xa juincheꞌe xa juaxruxin xranchi juatingíexin ndo, méxin tenko xa. ");
INSERT INTO pps_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","*Ko tjumeꞌe kuiji kaxin xi saduceo kuitsjeꞌe xa ndo Jesús. Ko xi saduceo meꞌe titikaonꞌa xa ixi xroxechón chujni tsikenꞌen. Méxin ndache xa ndo Jesús: ");
INSERT INTO pps_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","―Maestro, ndo Moisés tsikjin ndo xroon ndachro siá naa xi tsikuteꞌe, ko ndakuenꞌen xa ko xroꞌan ichjan kuachónda xa ngajin janchriꞌe xa, xi kichuu xi kuenꞌen xrokonda tsuteꞌe xa ngajin nchri kaꞌan meꞌe, ko xrochónda xa ichjan, ko xjan meꞌe xrokjan xjan xranchi chjenꞌen xi kuenꞌen. ");
INSERT INTO pps_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Bakeꞌe ya̱a̱to̱ xi, xi meꞌe kichuu xa. Ko xi saꞌó kuteꞌe xa janchriꞌe xa ko ndakuenꞌen xa ko xroꞌan ichjan kuachónda xa ngajin janchriꞌe xa. ");
INSERT INTO pps_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Ko xi yuxin kuteꞌe xa nchri kaꞌan, ko kaxon ndakuenꞌen xa ko xroꞌan ichjan kuachónda xa ngajin nchra. ");
INSERT INTO pps_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Ko tjumeꞌe xi nínxin kuteꞌe xa nchri kaꞌan meꞌe, ko xrajeꞌo ndakuenꞌen xa. Ko jaña konꞌen kain ti ya̱a̱to̱ xa. Kain xa kuenꞌen xa ko xroꞌan chjan kuachónda xa ngajin nchra. ");
INSERT INTO pps_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Ko tjumeꞌe jeꞌe nchra kuenꞌen nchra kaxon. ");
INSERT INTO pps_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Méxin nchakon xroxechónni, ¿ngixeꞌi ti ya̱a̱to̱ xi kuenꞌen xrokjan xixiꞌe nchra, ixi kain ya̱a̱to̱ xa, kuteꞌe xa nchri meꞌe? ");
INSERT INTO pps_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Tjumeꞌe juatingíexin ndo Jesús: ―Ntiꞌi ngataꞌa nunte, xi ko nchri tuteꞌe na̱. ");
INSERT INTO pps_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Ko ni tsikinixin satsji ngajní xroxechón na̱, ntiꞌa tsuteꞌa na̱. ");
INSERT INTO pps_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Ixi ntiꞌa ítsenꞌa chujni, nchakon meꞌe chujni xrokjan sen xranchi sen ángel, ko ni meꞌe xrokjan na̱ chjenꞌen ndo Dio ixi ndo Dio juinchexechón ndo na̱. ");
INSERT INTO pps_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Ko kaxon ndo Moisés juako ndo kondee ti xroxechón chujni, ikjin ndo ti jitaxin xranchi naa nta̱a̱ kjuáa xroꞌi ko cheꞌa nta̱a̱, ntiꞌa ndachro ndo Moisés ixi ndo Dio meꞌe ndo Dio titikaon ndo Abraham, ndo Isaac, ko ndo Jacob. ");
INSERT INTO pps_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Ko ndo Dio jeꞌa ndo Dio neꞌe chujni ndatsikenꞌen. Ndo Dio, ndo Dio neꞌe chujni stechón, ixi jeꞌe ndo tikon ndo kain na̱ jichón na̱. ");
INSERT INTO pps_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Ko kaxin xi tjako ley ndachro xa: ―Maestro jian ndachronta. ");
INSERT INTO pps_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Ko xronka xa ko íxroꞌan ngeꞌe juanchangiꞌe xa ndo. ");
INSERT INTO pps_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Ndo Jesús ndachro ndo: ―¿Á nduaxin ndachro chujni ixi ndo Cristo kuachrjenixin ndo ndo David? ");
INSERT INTO pps_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Ndo David tsikjin ndo xroon Salmos ko ndachro ndo: Nchána ndo Dio ndache ndo Nchána: “Takeꞌé tjenkana ndatsjonxin jian, ");
INSERT INTO pps_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","tsakeꞌejan ni ningakonꞌan chringi tutáa.” ");
INSERT INTO pps_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Ko siá ndo David ndache ndo ndo Mesías Nchána, ¿sonda tjumeꞌe ndo Cristo xrokjan chjenꞌen ndo David? ");
INSERT INTO pps_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Kain na̱ stetinꞌen na̱ ti nichja ndo Jesús ngajin sen teyuu chrikao ndo: ");
INSERT INTO pps_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","―Tsjeꞌenta jian xranchi ncheꞌe xi tjako ley ko ncheꞌanta xranchi jeꞌe xa, jeꞌe xa ncheꞌe xa juaxruxin takeꞌe xa manta jine̱, ko tjaun xa tsajon na̱ juajna ngajin xa ngataon ndasin, ko takeꞌe xa ícha tjenka ngaxinꞌin niꞌngo, ko nchakon itji xa kia tjaun xa tsakeꞌe xa ti xitaon ícha jian. ");
INSERT INTO pps_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Ko ixi juancheya xa tantsjeꞌe xa nchri kaꞌan ndoꞌa nchra ko tjumeꞌe nchexion xa, sée nichjeꞌe xa ndo Dio. Xi meꞌe ícha tangi tsonꞌen xa nchakon sinchéña ndo Dio ijie̱. ");
INSERT INTO pps_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Ndo Jesús jii ndo ngaxinꞌin niꞌngo ijié ko jitsjeꞌe ndo ixi itsjé ni chónda kueya tomi ko kueya ngeꞌe, kui̱i̱ na̱ ko bakeꞌe na̱ tomi ngaya nta̱a̱ tingachjian tomi. ");
INSERT INTO pps_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ko bikon ndo Jesús kui̱i̱ naa nchri kaꞌan ko nóa nchra, nchri meꞌe bakeꞌe nchra yuu tomi nchínchín, tomi tjinteꞌa. ");
INSERT INTO pps_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Ko ndo Jesús ndachro ndo: ―Janꞌan nduaxin ntatjunta ixi nchri kaꞌan nóa, ícha tjintee tomi bakeꞌe nchra ixi ti kuajon ikaxin na̱, ");
INSERT INTO pps_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","ixi jeꞌe na̱ kuajon na̱ ti ngeꞌe xeꞌe chónda na̱, ko jeꞌe nchri nóa kuajon nchra kain tomi xrojuinexin nchra. ");
INSERT INTO pps_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Kaxin na̱ stetjao na̱ ixi niꞌngo ijié tsango chaxro ixro tsikiꞌtexin niꞌngo, ko chaxro jitsjeꞌe ngeꞌe tsikajon na̱ ngajin ndo Dio. Ko ndo Jesús ndachro ndo: ");
INSERT INTO pps_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","―Tsi̱i̱ nchakon kain ngeꞌe tikonnta tsitjáña, kain xrochjejin ko ninaa ixro tsituꞌe ngataꞌa inaa ixro. ");
INSERT INTO pps_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Juanchangiꞌe na̱ ndo Jesús: ―Maestro, ¿ngisa tsonꞌen jiꞌi? ¿Ko ngeꞌe tsjakoxin ixi jaña tsonꞌen? ");
INSERT INTO pps_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Ndo Jesús ndachro ndo: ―Tsjeꞌenta jian ixi xroꞌan ngisen sintayaꞌanta. Ixi tsi̱i̱ kueya na̱ xrondachro na̱ ixi jeꞌe na̱ ndo Cristo na̱, ko xrondachro na̱: “Ó tsitjáña nunte.” Jaꞌanta titikaonꞌanta ti ndachro ni meꞌe ko rueꞌanta na̱. ");
INSERT INTO pps_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Nchakon tsinꞌennta ixi stetóña kichuu naa tjajna ko inaa tjajna, ko kaxon kaxin tjajna steteto na̱, xronkaꞌinta ixi kain jiꞌi saꞌó xrokonda tsonꞌen ko xratsitjáñaꞌi nunte. ");
INSERT INTO pps_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Ko ndo Jesús ndachro ndo ikaxin ngeꞌe: ―Tse̱to̱ naa tjajna ko inaa tjajna, naa xi tetuanꞌan naa tjajna ngajin inaa xi tetuanꞌan inaa tjajna. ");
INSERT INTO pps_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Ko itsjé no tsanga tsontengi nunte, ko tsango tsatse na̱ jinta ngataꞌa nunte, ko kaxon tsango itsjé ichin tsi̱i̱ ngataꞌa na̱, ko tsango chinga ngeꞌe tsikonni ngajní ko tsango sinchexronkana. ");
INSERT INTO pps_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","’Ko kain jiꞌi xratsuenꞌa, ixi saꞌó tsenginta na̱, ko ndakoꞌa sintaꞌanta na̱ ko xroxraxinꞌinnta na̱ ndoꞌachjiso ko tsingakjinnta na̱ ngajin ni tituanꞌan niꞌngo ko tsikaannta na̱ ngajin xi tetuanꞌan, kondanaxin janꞌan. ");
INSERT INTO pps_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Ko kain jiꞌi sintaꞌanta na̱, ko jaña jaꞌanta chao xrondachronta ixi titikaonntana janꞌan. ");
INSERT INTO pps_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","*Jaꞌanta taꞌinta juachjaon ko xraxaonꞌanta xranchi tsjatingíexinnta ti ngeꞌe tsjanchangiꞌanta na̱. ");
INSERT INTO pps_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Ixi janꞌan xrontatjunta ngeꞌe tsjateꞌenta, chijni jian tsayeꞌenta, ko ninaa ni ningakonꞌannta juaꞌi tsjatingíexin na̱. ");
INSERT INTO pps_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Ko kaxon ndotánta, janáanta o̱ xi kichuunta o̱ ngixeꞌi inaa ni ndointa, tsajon na̱ juachaxin naatsóñaxónnta na̱. ");
INSERT INTO pps_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Ko kain ngisen xroningakonꞌannta ixi titikaonntana. ");
INSERT INTO pps_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Ko maski jaña tsonꞌen, ninaa xrajaanta tsitjáñaꞌi. ");
INSERT INTO pps_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Soji tinteenta, meꞌe jaña tsjachanta tsaricho̱nnta kain nchakon. ");
INSERT INTO pps_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","’Ko nchakon tsikonnta ixi tjajna Jerusalén tsixindajin xi soldado, jaꞌanta tsonoꞌanta ixi íseꞌa xrochjejin nchijíi tjajna meꞌe. ");
INSERT INTO pps_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Tjumeꞌe ni jii nunte Judea xrokonda tsingana satsji na̱ ngataꞌa jna̱. Ko ni ste tjajna Jerusalén kaxon xrokonda satsjixin na̱ ntiꞌa ko ni ste ngataon ijngi íxrokjanꞌi na̱ tjajna. ");
INSERT INTO pps_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Ixi kain nchakon meꞌe tsango tsikaon ni titikaonꞌa, ko ijié juachjaon tsakeꞌe, xranchi jitaxin xroon chijnie ndo Dio. ");
INSERT INTO pps_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","¡Lastu kain nchri jiá ichjan nchakon meꞌe, ko nchri chónda ichjan stetaki! Ixi tsango ijié juachjaon tsakeꞌe nchijíi ngataꞌa nunte, ixi tsango tsikaon ko tangi tsonꞌen ni tjajna meꞌe. ");
INSERT INTO pps_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Ko kaxin sen tsóñaxin na̱ sen ixi chika espada ko kaxin sen xrotsé na̱ sen satsikao na̱ sen ndoꞌachjiso inaa tjajna. Ko ni chúxinꞌa ndo Dio tsingatjangi na̱ tjajnée ndo, tjajna Jerusalén, tsitjaja nchakon xrokjan chjenꞌen ndo Dio. ");
INSERT INTO pps_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","*’Tjumeꞌe tsonoxin ngeꞌe tsonꞌen chjiixro ko nchanitjao ko nchanotsé. Ko ngataꞌa nunte xasintajni kain tjajna tsaa na̱ juachjaon, ko xroxranka na̱ ixi tsanga tsontengi ko xroxruin ndachaon. ");
INSERT INTO pps_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Tsango xroxronka na̱ ko tsontiyeꞌe na̱ kondeexin xraxaon na̱ ngeꞌe tsonꞌen ngataꞌa nunte, ko kaxon kondeexin kain ngeꞌe jii ngajní tsontengi. ");
INSERT INTO pps_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","*Ko tjumeꞌe tsikon na̱ ndo Jesús, chjenꞌen ndo Dio, xjan jongíꞌe xranchi chujni, tsi̱i̱ ndo ngataꞌa naa itjui̱ ko tsikaꞌo ndo ijié juachaxin tsetuanꞌan ndo ko kaxon tsango ijié chjiixro tsikaꞌo ndo. ");
INSERT INTO pps_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Ko nchakon xroxrangíxin tsonꞌen kain jiꞌi, takeꞌénta juaxruxin, ko tsikonnta ixi ndo Cristo ó kui̱i̱ ndo tsantsjen ndo ijie̱ chondanta. ");
INSERT INTO pps_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Ko ndachro ndo Jesús inaa chijni: ―Tsjeꞌenta xranchi jii nta̱a̱ tajon itu higo ko ikaxin nta̱a̱. ");
INSERT INTO pps_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Nchakon tsikonnta jixechji nta̱a̱, meꞌe noꞌanta ixi ó tsaxi sincheꞌe súa. ");
INSERT INTO pps_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Jaña kaxon nchakon tsikonnta ixi tsaxi tsonꞌen ngajní kain jiꞌi, tsonoꞌanta ixi tuinxin tsi̱i̱ ti tsetuanꞌan ndo Dio ngataꞌa nunte. ");
INSERT INTO pps_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","’Janꞌan nduaxin ntatjunta ixi saꞌó tsonꞌen kain jiꞌi, ko xratsenꞌa chujni jii jai ngataꞌa nunte. ");
INSERT INTO pps_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Ngajní ko nunte xasintajni tsatsinga, ko ti nichja janꞌan tsatsingaꞌi, nduaxin tsonꞌen. ");
INSERT INTO pps_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","’Tsjeꞌenta xranchi takeꞌénta; xraxaonꞌanta ixi jeꞌo xrotjaunna sintenta, xrokoannta ko ti ícha tajon juaxruxin ngataꞌa nunte ntiꞌi ko ixi kondeexin meꞌe tsonoaꞌinta ó kui̱i̱ nchakon tsjiꞌi. ");
INSERT INTO pps_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Ixi nchakon meꞌe tsonꞌen xranchi takeꞌe naa nochaꞌa itsé kulano, jaña tsonꞌen ngajin kain ni ste ngataꞌa nunte. ");
INSERT INTO pps_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Méxin tsejuaꞌi asáanta, ko jian tantjeꞌe ikonnta, ko kain nchakon nichjeꞌenta ndo Dio ixi jaña chao tsatsinganta juachjaon tsi̱i̱, ko jaña chao tsonchjiñeꞌenta ngajin chjenꞌen ndo Dio, xjan jongíꞌe xranchi chujni. ");
INSERT INTO pps_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","*Taanchakon ndo Jesús banchekuenꞌen ndo na̱ chijnie ndo Dio ngaxinꞌin niꞌngo ko tiie bakituꞌe ndo ti ijna̱ ndatinꞌin Olivo. ");
INSERT INTO pps_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Ko kain ni tjajna, ndúyo bakonchjiñeꞌe na̱ ti jii niꞌngo ixi tjaun na̱ tsinꞌen na̱ ti ndachro ndo Jesús. ");
INSERT INTO pps_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Ó jitonchjiñeꞌe nchakon xrangíxin kia ti sine na̱ nutja chóndaꞌi ti tjaꞌin nio, ko kia meꞌe ndatinꞌin Pascua. ");
INSERT INTO pps_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Kaxin xitaana xi tetuanꞌan ko xi tjako ley stexraxaon xa xranchi tsóña xa ndo Jesús ixi ste xrakonꞌen xa ni tjajnée xa. ");
INSERT INTO pps_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Ko Xixronꞌanxrée kuixinꞌin aséen xi Judas kaxon ndatinꞌin Iscariote. Xi meꞌe naa xi teyuu sen bajikao ndo Jesús. ");
INSERT INTO pps_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Ko xi Judas ikjui xa ngajin xitaana, xi tetuanꞌan, ko xi stendáa niꞌngo ko kuintejao xa xranchi tsingijna xa xrotsé na̱ ndo Jesús. ");
INSERT INTO pps_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Ko xi ste niꞌngo tsango bakeꞌe xa juaxruxin ko juao xa ixi xrochjée na̱ xi Judas tomi ixi tsingijna xa. ");
INSERT INTO pps_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Ko xi Judas kutuexin xa ko jichónꞌen xa xrochronga xa ngiora chao xrotsé na̱ ndo Jesús nchakon xroꞌan ngisen jii. ");
INSERT INTO pps_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Ko kui̱i̱ nchakon kia pascua sine sen nutja chóndaꞌi ti tjaꞌin nio, ko nchakon meꞌe xrokonda tsenꞌen naa kutuchjon sine sen. ");
INSERT INTO pps_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Ko ndo Jesús xruanꞌan ndo ndo Pedro ko ndo Juan ko ndachro ndo: ―Itjinta nchekonchjiannta ti sintena kia Pascua. ");
INSERT INTO pps_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Ko jeꞌe sen juanchangiꞌe sen ndo Jesús: ―¿Tinó tjaunnta tsonchjian ti sintena? ");
INSERT INTO pps_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Jeꞌe ndo ndachro ndo: ―Hora tsixinꞌinnta tjajna ijié, tsetannta naa xi yama xa naa nchixréen inda. Rueꞌénta xa ti nchia tixinꞌin xa. ");
INSERT INTO pps_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Ko ndachenta xi ndoꞌa: “Ndo nchekuanna̱na ndachro ndo: ¿Ti no jii nchia sinexinna, janꞌan ko sen teyuu tajikiaꞌan, jai kia Pascua?” ");
INSERT INTO pps_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Ko jeꞌe xi ndoꞌa tsjakoꞌanta xa naa nchia ijié, nchia yuxin jii ngataꞌa noi, ko nchia meꞌe ó chónda nchia kain ngeꞌe. Ntiꞌa nchekonchjianxinnta ti sintena. ");
INSERT INTO pps_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Ko jeꞌe sen sakjui sen ko kuitja sen kain ngeꞌe xranchi ndachro jeꞌe ndo. Ko ntiꞌa juinchekonchjian sen ti sinekao sen ndo Jesús kia Pascua. ");
INSERT INTO pps_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Ko kuitja hora sine sen, ndo Jesús ko ti sen teyuu chrikao ndo kuiji sen ntiꞌa ko bakeꞌe sen ti jii ntachaon. ");
INSERT INTO pps_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Tjumeꞌe ndo Jesús ndachro ndo: ―¡Janꞌan tsango jueñaꞌo sinekuu kichuuna kia Pascua ti xratsenꞌana! ");
INSERT INTO pps_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Ixi janꞌan ntatjunta í sine̱ꞌa kia jiꞌi tsija nchakon tsetuanꞌan ndo Dio. ");
INSERT INTO pps_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Ko tjumeꞌe itsé ndo naa copa jitjiá vino ko kuajon ndo juasie ndo ngajin ndo Dio, ko ndachro ndo: ―Tinꞌinnta ti jitjiá copa ko tonchjeyeꞌe kichuunta. ");
INSERT INTO pps_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Janꞌan ntatjunta ixi tsi̱ꞌa vino tsija nchakon ti tsetuanꞌan ndo Dio. ");
INSERT INTO pps_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Ko tjumeꞌe itsé ndo nutja ko kuajon ndo juasie ndo ngajin ndo Dio, ko konchrinjin ndo nio ko konchjeyeꞌe ndo sen ko ndachro ndo: ―Jiꞌi cuerpona tsájon tsenꞌen ixi jaꞌanta. Ncheꞌenta jaꞌin, meꞌe xraxaonxinnintana janꞌan. ");
INSERT INTO pps_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Ko juexin juine sen nutja kaxon kuajon ndo copa jitjiá vino ko ndachro ndo: ―Ti jitjiá copa jiꞌi xrondachro ngeꞌe natjúá tsixintaxin ixi jnina tsintji ixi jaꞌanta. ");
INSERT INTO pps_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","’Ko xi sinchekjina ntiꞌi jii xa, rineki̱ꞌa̱n xa ngataꞌa ntachaon. ");
INSERT INTO pps_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Méxin chjenꞌen ndo Dio, xjan jongíꞌe xranchi chujni, xrokonda tsonꞌen xjan xranchi jitaxin xroon, ko, ¡ícha tangi tsonꞌen xi sinchekji xjan! ");
INSERT INTO pps_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Ko tjumeꞌe sen teyuu chrikao ndo kuaxi sen juakaxin kichuu sen ixi ngisen sincheꞌe meꞌe. ");
INSERT INTO pps_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","*Ko tjumeꞌe juakaxin kichuu sen ixi ngakjenꞌen sen, ngisen ícha tjintee. ");
INSERT INTO pps_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Tjumeꞌe ndachro ndo Jesús: ―Kaxin xi chúxinꞌa ndo Dio tsango tetuanꞌan xa ngajin ni tjajnée xa, ko xi tituanꞌan ndachro xa ixi tsango jian xa ko tingijna xa tjajnée xa. ");
INSERT INTO pps_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","*Ko jaꞌanta ncheꞌanta jaña. Ixi ngisen ícha tjintee, ícha tsitikaon sen xranchi naa chajan, ko chujni ícha tetuanꞌan, meꞌe sincheꞌe ixra̱ xranchi naa xi nchexra̱. ");
INSERT INTO pps_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","*Méxin, ¿ngisen ícha tetuanꞌan, á sen takeꞌe sine, o̱ sen tajon sine ngajin ni jii ntachaon? Ngisen sine ti jii ntachaon, ni meꞌe ícha tetuanꞌan na̱, ko janꞌan ritjén ngajin jaꞌanta xranchi naa ni nchexra̱. ");
INSERT INTO pps_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","’Ko jaꞌanta bakeꞌenta ngaji̱n janꞌan kain nchakon ko bikonta kain ngeꞌe tangi kuatsinga. ");
INSERT INTO pps_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Méxin janꞌan tjáꞌanta juachaxin tsetuanꞌannta xranchi juachaxin kuayáꞌa̱ chjána Ndotána, ");
INSERT INTO pps_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","*ko jaꞌanta sintenta ko tsiꞌinta ti jii ntachaon tsétuanꞌan; tsakeꞌenta ntiꞌa tsetuanꞌannta ko sinchéñanta ijie̱ ngajin teyuu tjajna kuachrjenixin ndo Israel. ");
INSERT INTO pps_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Kaxon ndachro ndo Jesús: ―Simón, Simón, Xixronꞌanxrée juanchia xa juachaxin tsontsjenga xa xranchi noa trigo. ");
INSERT INTO pps_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Ko janꞌan kuinóatáana ngajin Ndotána ixi jaꞌa nduaxin xrochuntiana. Ko nchakon xrokjan tsitikaonna, tingijna sen kichuua ixi kaxon tsitikaon sen ko soji tsintee sen. ");
INSERT INTO pps_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Ko ndo Simón ndachro ndo: ―Nchána, janꞌan xroruaꞌanta ti no tsikuꞌunta na̱ ko siá tsijaꞌanta kaxon janꞌan, ko siá jaꞌanta tsenꞌennta, kaxon janꞌan tsenꞌena. ");
INSERT INTO pps_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Ko juatingíexin ndo Jesús: ―Pedro, janꞌan ntatjua ixi jai xraxrotsje̱ꞌa kuntaxichíká, jaꞌa xrondachrua níi vez chuxinꞌana. ");
INSERT INTO pps_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","*Tjumeꞌe ndo Jesús juanchangiꞌe ndo sen chrikao ndo: ―Nchakon xruanꞌannta, bikonꞌinta puxa, ngeꞌe tsinga tomi, ko kate ko, ¿á xrojan ngeꞌe xrokondaꞌanta? Ko jeꞌe sen juatingíexin sen: ―Naꞌi, xroꞌan ngeꞌe. ");
INSERT INTO pps_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Ko tjumeꞌe ndachro ndo Jesús: ―Ko jai jeꞌa jaña tsonꞌen; ngisen chónda tomi, tsama sen tomie sen, ko kaxon puxa tsengachjian sen ngeꞌe sine sen; ko ngisen chóndaꞌi espada sinchekji sen noxrée sen ko tseꞌna sen chika. ");
INSERT INTO pps_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Janꞌan nduaxin ntatjunta ixi xrokonda tangi tsónna xranchi ndachro chijnie ndo Dio: “Xranchi naa xi ndakoꞌa ncheꞌe, bikona ndo.” Méxin kain ti jitaxin xroon ixi janꞌan, xrokonda jaña tsonꞌen. ");
INSERT INTO pps_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Tjumeꞌe sen chrikao ndo ndachro sen: ―Ncháina ntiꞌi jii yuu chika espada. Ko ndachro ndo Jesús: ―Ó chao, í nichjaꞌinta ícha. ");
INSERT INTO pps_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Tjumeꞌe ndo Jesús kuachrjexin ndo tjajna Jerusalén ko sakjui ndo ti jii ijna̱ ndatinꞌin olivo xranchi kuancheꞌe ndo, ko sen chrikao ndo ruéꞌe sen ndo. ");
INSERT INTO pps_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Ko hora kuiji sen ntiꞌa, ndachro ndo: ―Jaꞌanta nichjeꞌenta ndo Dio ixi tsingijnanta ndo ixi xroꞌan ijie̱ tsamanta. ");
INSERT INTO pps_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Ko tjumeꞌe ndo Jesús kuachrjendáa ndo kjínxin xranchi ti tjankani naa ixro, ko ntiꞌa bakeꞌexin ndo ntatuchiꞌin ndo ko nichjeꞌe ndo ndotée ndo, ndo Dio. ");
INSERT INTO pps_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Ko ndachro ndo: ―Ndotána, siá tjaunnta, tsatsinga kain ngeꞌe tangi tsónna ko tsoenꞌa xranchi janꞌan tjaꞌon, tsonꞌen xranchi tjaun jaꞌanta. ");
INSERT INTO pps_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Ko tjumeꞌe konoxin naa ndo ángel kui̱xi̱n ngajní ixi sinchesoji ndo aséen ndo Jesús. ");
INSERT INTO pps_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Ko ixi tangi jitonꞌen aséen ndo Jesús, ícha soji nichjeꞌe ndo ndotée ndo ko bakintjí ndachjién ndo ngataꞌa nche xranchi ndua gota ijni̱. ");
INSERT INTO pps_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Hora juexin nichjeꞌe ndo Jesús ndotée ndo, ko bingatjen ndo kuitsjeꞌe ndo ti jii sen kuajikao ndo, kuitja ndo sen stejua sen ixi ijié juachjaon chónda aséen sen. ");
INSERT INTO pps_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Méxin ndachro ndo: ―¿Sonda stechrinnta? Xingamaꞌanta, ko nichjeꞌenta ndo Dio ixi tsingijnanta ndo sincheꞌanta ngeꞌe ndakoꞌa. ");
INSERT INTO pps_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Xrajinichja ndo Jesús, kui̱i̱ kueya na̱ ko jitaon xi Judas, xi meꞌe naa xi teyuu sen bajikao ndo. Ko konchjiñeꞌe xi meꞌe ngajin ndo Jesús ko kuitoxin xa ndo. ");
INSERT INTO pps_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Ko tjumeꞌe ndo Jesús ndache ndo xi Judas: ―Judas, ¿á ixi kuitoxiana meꞌe xrondachro sinchekjiana, janꞌan chjenꞌen ndo Dio, xjan jongíꞌe xranchi chujni? ");
INSERT INTO pps_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Ko sen chrikao ndo Jesús, bikon sen ngeꞌe jitonꞌen meꞌe juanchangiꞌe sen ndo: ―Ncháina, ¿á tsjayana ngajin ni jiꞌi ixi chika espada? ");
INSERT INTO pps_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Ko naa sen chrikao ndo Jesús juincheniꞌe sen naa xi nchexrée xitaana, xi ícha tetuanꞌan, naa chrinjinxon ndatsjon xa ti jian. ");
INSERT INTO pps_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Ko ndo Jesús ndache ndo sen chrikao ndo: ―Ó chao, tintuꞌenta xa. Ko tjumeꞌe ndo Jesús itsé ndo ndatsjon xi meꞌe, ko juinchexruenꞌen ndo xa. ");
INSERT INTO pps_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Tjumeꞌe ndo Jesús ndache ndo xi tetuenꞌen xitaana, ko xi tetuenꞌen niꞌngo ko ikaxin sen tetuanꞌan, xi kui̱i̱ itsé xa ndo Jesús: ―¿Sonda bikuunta nta̱a̱ ko espada xrotséxinninta xranchi janꞌan xrokjui naa xicheꞌe? ");
INSERT INTO pps_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","*Kain nchakon bakeꞌe ngajinnta ngaxinꞌin niꞌngo, ko xroꞌan juincheꞌenta. Ko jai oránta ixi tsitikaonnta xi tetuenꞌen ti naxixeꞌe. ");
INSERT INTO pps_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Ko tjumeꞌe itsé na̱ ndo Jesús, ko sabikao na̱ ndo ndoꞌa xitaana, xi ícha tetuanꞌan. Ko ndo Pedro kjínxin jiruéꞌe ndo. ");
INSERT INTO pps_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Ko juaaka na̱ xroꞌi ngusine ntasien nchia meꞌe ko kuendajin na̱ xroꞌi. Ko kaxon ndo Pedro bakeꞌe ndo ngakjenꞌen na̱ ntiꞌa. ");
INSERT INTO pps_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Tjumeꞌe naa nchri ncheꞌe ixra̱ nchia ngajin xitaana, ti bikon nchra ndo Pedro ntiꞌa ti jii xroꞌi, ndachro nchra: ―Kaxon xi jiꞌi chrikao xa xi Jesús. ");
INSERT INTO pps_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Ko ndo Pedro ndachro ndo: ―Naꞌi, chuxinꞌa xi meꞌe. ");
INSERT INTO pps_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Ko tjumeꞌe kui̱i̱ inaa xi ko bikon xa ndo Pedro ko ndachro xa: ―Jaꞌa kaxon naa xi tajikao xi Jesús. Ko ndo Pedro ndachro ndo: ―Naꞌi, nduaxinꞌa meꞌe. ");
INSERT INTO pps_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Kuatsinga xranchi naa hora ko tjumeꞌe ndachro inaa xi: ―Nduaxin xi jiꞌi chrikao xa xi Jesús, ixi kaxon jeꞌe xa xi nunte Galilea. ");
INSERT INTO pps_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Ko ndachro ndo Pedro: ―Nónaꞌi ngeꞌe ndachronta. Ko xrajinichja ndo itsje̱ naa kuntaxichíká. ");
INSERT INTO pps_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Ko tjumeꞌe jeꞌe ndo Jesús konkjan ndo tsjeꞌe ndo ndo Pedro, ko ndo Pedro xraxaon ndo ixi jaña tsindachro ndo Jesús: “Xraxrotsje̱ꞌa kuntaxichíká jaꞌa xrondachrua níi vez chuxinꞌana.” ");
INSERT INTO pps_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Ko tjumeꞌe ndo Pedro kuachrje ndo nduja ko tsango tsjanga ndo. ");
INSERT INTO pps_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Ko xi soldado ti stendáa xa ndo Jesús juaya xa ngajin ndo ko juanoa xa ndo. ");
INSERT INTO pps_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Ko bijeꞌe xa ikon ndo ko tandeꞌe xa ito̱n ngaya ikon ndo ko tjanchangi xa: ―¡Ndachrua ngisen kóña! ");
INSERT INTO pps_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ko tsango chinga ndache xa ndo, ko kuyakutee xa ndo. ");
INSERT INTO pps_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Ko ndúyaxin xraꞌo kain xi tetuanꞌan niꞌngo, ko xi taana tetuanꞌan, ko kain xi tjako ley ko bikao xa ndo Jesús ti ste xi tetuanꞌan ntiꞌa ko ndachro xa: ");
INSERT INTO pps_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","―Ndachijiana, ¿á jaꞌa ndo Cristo? Ko jeꞌe ndo ndachro ndo: ―Siá jaán xrondachrja̱n, jaꞌanta tsitikaonꞌanta. ");
INSERT INTO pps_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Ko siá tsjanchangiꞌanta naa ngeꞌe, jaꞌanta tsjatengíexinꞌanta, ko tsajandaꞌintana satsji. ");
INSERT INTO pps_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Ko janꞌan, chjenꞌen ndo Dio, xjan jongíꞌe xranchi chujni, xrajai tsakeꞌe ndatsjonxin jian ti jii ndo Dio chónda kain juachaxin. ");
INSERT INTO pps_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Ko tjumeꞌe kain xi ste ntiꞌa juanchangiꞌe xa ndo Jesús ko ndachro xa: ―¿Á jaꞌa nduaxin chjenꞌen ndo Dio tjumeꞌe? Ko ndo Jesús juatingíexin ndo: ―Jaán, jaꞌanta ó ndachronta. ");
INSERT INTO pps_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Ko tjumeꞌe ndachro xa: ―Íxrokondaꞌi xronichja ikaxin na̱. Janꞌanna ó kuinꞌanna ngeꞌe nichja xi jiꞌi. ");
INSERT INTO pps_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Tjumeꞌe kain xa bingatjen xa ko sabikao xa ndo Jesús ngajin xi Pilato. ");
INSERT INTO pps_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Ko ntiꞌa kuaxi juankataꞌa xa ijie̱ ngajin ndo Jesús, ko ndachro xa: ―Janꞌanna kuitjána xi jiꞌi juinchexronka xa ni tjajnana̱na. Ko ndachro xa ixi xrokondaꞌi tsjengana iꞌna̱ ngajin xi tetuanꞌan Roma, ko kaxon ndachro xa ixi jeꞌe xa ndo Cristo, ko jeꞌe xa naa rey tetuanꞌan. ");
INSERT INTO pps_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Ko tjumeꞌe xi Pilato juanchangiꞌe xa ndo Jesús: ―¿Á jaꞌa Rey tituenꞌen ni judío? Ko ndo Jesús ndachro ndo: ―Jaꞌa ndachrua. ");
INSERT INTO pps_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Ko tjumeꞌe xi Pilato ndache xa xitaana tetuanꞌan ko ni bikao ndo Jesús: ―Xroꞌan ijie̱ titja janꞌan ngajin xi jiꞌi. ");
INSERT INTO pps_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Ko kain ni ste ntiꞌa ícha séen kuyako na̱ ko ndachro na̱: ―Jeꞌe xa juincheyeꞌe xa kain ni tjajnana̱na ixi jée tjako xa. Ko kuaxi juako xa nunte Galilea, ko jai ó ntiꞌi tjajna Judea tjako xa. ");
INSERT INTO pps_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Ko konoꞌe xi Pilato jiꞌi, ko juanchangi xa á ndo Jesús kui̱xi̱n ndo nunte Galilea. ");
INSERT INTO pps_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Ko ndachro na̱ ixi ntiꞌa tikinixinꞌen ndo, meꞌe xi Pilato kuetuanꞌan xa ixi satsikao na̱ ndo Jesús ngajin xi Herodes ixi xi meꞌe tituanꞌan nunte Galilea, ko nchakon meꞌe xi Herodes tsiki̱i̱ xa tjajna Jerusalén. ");
INSERT INTO pps_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Ko ti bikon xi Herodes ndo Jesús, tsango bakeꞌe xa juaxruxin ixi ó sée tjaun xa xrokuichuxin xa ndo ixi tsikinꞌen xa ngeꞌe jian kuancheꞌe ndo, ko tjaun xa xrobikon xa naa ixra̱ ijié xrojuincheꞌe ndo Jesús. ");
INSERT INTO pps_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Ko xi Herodes juanchangiꞌe xa ndo Jesús itsjé ngeꞌe ko jeꞌe ndo xroꞌan ngeꞌe juatingíexin ndo. ");
INSERT INTO pps_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Ko kaxon ntiꞌa konchjiñeꞌe itsjé xitaana tetuanꞌan ko itsjé xi tjako ley ko tsango kueya ijie̱ tjankataꞌa xa ndo Jesús. ");
INSERT INTO pps_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Ko tjumeꞌe xi Herodes ko kain xi soldadoe xa kuaxi xa chinga juinchekao xa ndo Jesús, ko juanoa xa ndo, ko tjumeꞌe juinchekitsa xa ndo manta tetsáa xi rey. Tjumeꞌe xi Herodes kuetuanꞌan xa satsjikao na̱ ndo Jesús ngajin xi Pilato íjngo. ");
INSERT INTO pps_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Nchakon meꞌe xi Pilato ko xi Herodes kuaxi tjento kichuu xa ixi seno kuaningakonꞌen kichuu xa. ");
INSERT INTO pps_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Tjumeꞌe xi Pilato kuiyeꞌe xa xitaana tetuanꞌan ko kain ni tetuenꞌen ni judío, ko ni tjajna, ");
INSERT INTO pps_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","ko ndache xa na̱: ―Jaꞌanta bikuunta xi jiꞌi, ko ndachronta ixi nchexronka xa ni tjajna, ko jaꞌanta kuinꞌennta ngeꞌe juanchangiꞌa xa, ko janꞌan kuitjaꞌi ijie̱ ngajin xa, xranchi jaꞌanta ndachronta. ");
INSERT INTO pps_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Kaxon xi Herodes kuitjaꞌi xa ijie̱ ngajin xa, méxin íjngo xruanꞌan xa xi jiꞌi ntiꞌi. Ko ó bikonta ixi xroꞌan ijie̱ chónda xa tsikinixin tsenꞌen xa. ");
INSERT INTO pps_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Ko tsetuanꞌan tsikaon xa, ko tjumeꞌe tsajon juachaxin satsji xa. ");
INSERT INTO pps_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Ko kia meꞌe, xi Pilato xrokonda tsajanda xa naa xi jixinꞌin ndoꞌachjiso. ");
INSERT INTO pps_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Ko kain na̱ kuaxi na̱ kuyako na̱: ―¡Tajandaꞌia xi jiꞌi! ¡Tjaꞌonna tsajanda xi Barrabás satsji xa! ");
INSERT INTO pps_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Ko xi Barrabás jixinꞌin xa ndoꞌachjiso ixi juinchexronka xa ni tjajna Jerusalén ko naakóñaxón xa chujni. ");
INSERT INTO pps_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Ko xi Pilato íjngo ndachro xa tsajanda xa ndo Jesús. ");
INSERT INTO pps_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Ko jeꞌe na̱ ícha séen kuyako na̱: ―¡Tjankanitua xa nta̱cru! ¡Tjankanitua xa nta̱cru! ");
INSERT INTO pps_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Nínxin juanchangi xi Pilato: ―¿Ngeꞌe ndakoꞌa juincheꞌe xi jiꞌi? Janꞌan titjaꞌi ijie̱ tsikinixin tsenxin xa. Janꞌan tsetuanꞌan tsikaon xa, ko tjumeꞌe tsajanda xa satsji xa. ");
INSERT INTO pps_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Ko jeꞌe na̱ ícha séen kuyako na̱ ko ndache na̱ xi Pilato tsjankanito xa ndo Jesús nta̱cru. Séen kuyako na̱ ko kaxon kuyako kain xi taana, xi tetuanꞌan, ko juacha na̱ ngeꞌe tjaun na̱. ");
INSERT INTO pps_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Méxin xi Pilato juincheꞌe xa xranchi tjanchia na̱. ");
INSERT INTO pps_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Ko kuajanda xa xi Barrabás xranchi tjaun na̱, xi bakeꞌe ngaxinꞌin ndoꞌachjiso, xi juinchexronka ni tjajna ko naatsikóñaxón xa chujni. Ko xi Pilato kuajon xa ndo Jesús ixi sinchekao na̱ ndo xranchi tjaun na̱. ");
INSERT INTO pps_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Hora jitikao na̱ ndo Jesús ixi tsjankanito na̱ ndo nta̱cru, itsé na̱ naa xi tjajna Cirene ndatinꞌin xa Simón. Xi meꞌe nandá tsiki̱ꞌxi̱n xa chjakée xa ko juinchekama na̱ xa nta̱cru ko jiruéꞌe xa ndo Jesús. ");
INSERT INTO pps_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Ko jiruéꞌe kueya ni tjajna, ko kaxon jiruéꞌe itsjé nchri stetsjanga nchra ko stetoyako nchra ixi yaa nchra juachjaon ixi ndo Jesús. ");
INSERT INTO pps_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Ko ndo Jesús ngatjia ndo tsjeꞌe ndo nchra ko ndachro ndo: ―Jaꞌanta nchri tjajna Jerusalén, tsjangaxinꞌantana. Jaꞌanta tsjangaxinnta chjanꞌanta ko jaꞌanta. ");
INSERT INTO pps_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Ixi tsi̱i̱ nchakon xrondache kichuunta: “Tsango chaxro nchri juaꞌi kuachónda ichjan, nchri xroꞌan ichjan juinchejongíꞌe, ko juinchekakiꞌa nchra ichjan.” ");
INSERT INTO pps_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","*Tjumeꞌe tsaxi na̱ xrondache na̱ ijna̱ “Xrabatjaninta”; ko xronichjeꞌe na̱ itjao̱ ko xrondachro na̱ “Nchekemáninta.” ");
INSERT INTO pps_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Siá nta̱yua jaña stenchekao na̱ nta̱a̱, ¿ngeꞌe sinchekao na̱ nta̱a̱ xema? ");
INSERT INTO pps_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Ko kaxon bikao na̱ yuu xicheꞌe, xi meꞌe kaxon tsjankanito na̱ xa nta̱cru tjenka ndo Jesús. ");
INSERT INTO pps_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Ko kuiji na̱ ijna̱ ndatinꞌin Ntajaa Chujni, ko ntiꞌa juankanito na̱ ndo Jesús nta̱cru ko kao kayui xicheꞌe, naa xi bakeꞌe na̱ xa ndatsjonxin jian ti jii ndo Jesús, ko inaa xa bakeꞌe na̱ xa ndatsjonxin kjon. ");
INSERT INTO pps_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Ko ndo Jesús ndache ndo ndotée ndo: ―Ndotána, tjáñaꞌanta ti ndakoꞌa stenchena na̱ ixi jeꞌe na̱ noeꞌa na̱ ngeꞌe stencheꞌe na̱. Ko xi soldado sondaonxin xa ixro ixi tsonoꞌe xa ngisen tsjacha manta jiá ndo Jesús. ");
INSERT INTO pps_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Ko kueya ni tjajna ntiꞌa stetsjeꞌe na̱, ko kaxon xi tetuanꞌan ko kain xa tjanoa xa ndo Jesús ko ndachro xa: ―Ikaxin na̱ bingijna xi jiꞌi, ko jai juaꞌi jeꞌo xa tingijna xa aséen xa. Siá nduaxin jeꞌe xa ndo Cristo tsixruaꞌan ndo Dio, chao xrobingijna aséen xa. ");
INSERT INTO pps_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Ko kaxon xi soldado tjanoa xa ndo Jesús; ko tjokéꞌe xa ndo vino tsikonsán xrokuiꞌi ndo. ");
INSERT INTO pps_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Ko ndachro xa: ―Siá jaꞌa ndo Rey tetuanꞌan ni judío, jaꞌua xingajinxian nta̱a̱ meꞌe. ");
INSERT INTO pps_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Ko nui ti nta̱a̱ tsikakeꞌe na̱ ndo Jesús tsikakeꞌe na̱ naa nta̱a̱ nchíín ko tsikjin na̱ tée griego, ko latín, ko hebreo ko jaꞌin ndachro: “Xi jiꞌi Rey tetuenꞌen ni judío.” ");
INSERT INTO pps_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Ko naa xicheꞌe ti yuu xi jitji̱a̱n ntiꞌa, nichjangíꞌe xa ndo Jesús ko ndachro xa: ―Siá nduaxin jaꞌa ndo Mesías, xingajinxian nta̱a̱ meꞌe ko nchexingajianna janꞌanna kaxon. ");
INSERT INTO pps_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Ko inaa xicheꞌe jitji̱a̱n nango kuyakutee kichuu xa: ―Jaꞌa, ¿á xrakuenꞌa ndo Dio? Jai̱na stetjianna ntiꞌi ko chinga stenchei̱nana. ");
INSERT INTO pps_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Ixi jaña tikinixinna ixi ndakoꞌa juintuꞌuna. Ko xi jiꞌi xroꞌan ngeꞌe ndakoꞌa juincheꞌe xa ko ntiꞌi jitji̱a̱n xa. ");
INSERT INTO pps_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Ko xi meꞌe ndache xa ndo Jesús: ―Jaꞌanta Jesús, xraxaonninta nchakon tsjangixinnta tsetuanꞌannta. ");
INSERT INTO pps_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Ko juatingíexin ndo Jesús: ―Nduaxin ntatjua ixi jai tsakeꞌe ngajin ti chaxro jii ngajní. ");
INSERT INTO pps_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Ko konaxixeꞌe ngataꞌa nunte xrangíxixión ngusine nchakon, ko kuiji hora nínxin. ");
INSERT INTO pps_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Ko chjiixro konaxixeꞌe, ko manta jijee̱xin ti ícha tjúá ndoꞌa ndo Dio chrinjintonga manta. ");
INSERT INTO pps_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Ko ndo Jesús séen ndachro ndo: ―Ndotána, ngaya tjáanta takée aséenna. Ko jaña jinichja ndo, ndakuenꞌen ndo. ");
INSERT INTO pps_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Ko hora bikon xi tituenꞌen xi soldado romano ngeꞌe konꞌen, jeꞌe xa kuajon xa juasie xa ngajin ndo Dio ko ndachro xa: ―Xi jiꞌi tjúá xa ko nduaxin xroꞌan ngeꞌe sínká xa. ");
INSERT INTO pps_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Ko kain ni ste ntiꞌa, bikon na̱ ngeꞌe konꞌen, ko sakuintekji na̱ ko stexronka na̱ ko tandeꞌe itja na̱ ntakuin na̱. ");
INSERT INTO pps_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","*Ko kain ni chúxin ndo Jesús, ko kaxon nchri ruéꞌe ndo tsiki̱ꞌxi̱n nchra tjajna Galilea, ikjín ste na̱ stenchexroan na̱ kain ngeꞌe konꞌen. ");
INSERT INTO pps_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Ko bakeꞌe naa xi tsango jian, ndatinꞌin xa José ko tjajnée xa tjajna Arimatea tikinixinꞌen Judea. Xi meꞌe kaxon xi tetuanꞌan tjajnée ni judío. ");
INSERT INTO pps_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Jeꞌe xi meꞌe jichónꞌen xa kaxon ngisen xroxruanꞌan ndo Dio tsetuanꞌan ngataꞌa nunte. Ko jeꞌe xa bakeꞌa xa juaxruxin ti ngeꞌe juincheꞌe ikaxin ni tetuanꞌan. ");
INSERT INTO pps_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Méxin, jeꞌe xa kuitsjeꞌe xa xi Pilato ko juanchia xa juachaxin ixi satsikao xa cuerpoe ndo Jesús. ");
INSERT INTO pps_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Ko juinchexingajin xa cuerpoe ndo Jesús ko kuintsía xa ndo naa manta natjúá tsango tjintee, ko bikao na̱ ndo ti tsinge na̱ ngaxinꞌin naa itjao̱ natjúá ti xraxroꞌan ngisen xrabaa. Ntiꞌa bakeꞌe na̱ cuerpoe ndo Jesús. ");
INSERT INTO pps_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Kain jiꞌi konꞌen kóndo viernes ti taxi nchekonchjian na̱ ixi tsjokéꞌe na̱ nchakon sábado. ");
INSERT INTO pps_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Ko sen nchri ruéꞌe ndo Jesús kui̱xi̱n nunte Galilea, konchjiñeꞌe nchra ko bikon nchra ti no tsikakeꞌe na̱ cuerpoe ndo Jesús. ");
INSERT INTO pps_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Ko ikjan nchra ndoꞌa nchra sinchekonchjian nchra inda chaxro xraxe ko xro̱a̱n tsjimá cuerpoe ndo. Ko nchakon sábado jokeꞌe nchra, xranchi tsikitueꞌen kain ni judío. ");
INSERT INTO pps_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Ndúyo domingo, nchakon xrangíxixín semana, ikjan nchra ti tsixrabaa ndo Jesús, ko jitikao nchra inda chaxro xraxe tsijinchekonchjian nchra ko sabikao kichuu nchra. ");
INSERT INTO pps_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Ko kuiji nchra ntiꞌa ko bikon nchra ixi ixro tsikijee̱xin itjao̱ ti no bakeꞌe na̱ cuerpoe ndo Jesús nango jii ixro. ");
INSERT INTO pps_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Ko kuixinꞌin nchra itjao̱ ko í kuitjaꞌi nchra cuerpoe ndo. ");
INSERT INTO pps_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Tjumeꞌe tsango xronka nchra ixi noeꞌa nchra ngeꞌe konꞌen. Ko tuinxin bikon nchra yuu xi ste tjenka nchra ko tóngíxin manta steyá xa. ");
INSERT INTO pps_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Ko tsango xronka nchra ko kuisée nchra nunte, ko xi meꞌe ndachro xa: ―¿Sonda tjéenta naa sen jichón ngakjenꞌen sen tsikenꞌen? ");
INSERT INTO pps_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","*Jeꞌe ndo í koꞌa ndo ntiꞌi; xechón ndo. Sintaxiñaonta ngeꞌe ntatjunta ndo nchakon bakaji ndo nunte Galilea. ");
INSERT INTO pps_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Chjenꞌen ndo Dio, xjan jongíꞌe xranchi chujni, ndachro ndo ixi xrokonda xrotsé na̱ ndo ni tsango ñaꞌi ko tsóña na̱ ndo ko tsenito na̱ ndo nta̱cru ko nchakon nínxin xroxechón ndo. ");
INSERT INTO pps_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Ko jeꞌe nchra xraxaon nchra ngeꞌe tsindachro ndo Jesús ");
INSERT INTO pps_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","ko ikjan nchra ko beki nchra ngeꞌe konꞌen ngajin sen tenaá chrikao ndo ko ngajin ikaxin na̱ kaxon. ");
INSERT INTO pps_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Ko nchri bikao juajna ndatinꞌin nchra María Magdalena, nchri Juana ko inaa nchri ndatinꞌin María, janée ndo Jacobo, ko ikaxin nchri ste ngajin nchra. ");
INSERT INTO pps_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Ko sen chrikao ndo Jesús kuitikaonꞌa sen ngeꞌe ichro nchra ixi xraxaon sen jée ngeꞌe stenichja nchra. ");
INSERT INTO pps_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Ko ndo Pedro kuachrjexin ndo nchia ko binga ndo kuitsjeꞌe ndo ti no tsixrabaa ndo Jesús. Ko tsjeꞌe ndo ngaxinꞌin itjao̱ ko bikon ndo ixi xroꞌan ngeꞌe jii ntiꞌa, jeꞌo manta kuitsía cuerpoe ndo Jesús jii nango. Tjumeꞌe ikjan ndo nchia ko tsango xronka ndo ixi ngeꞌe konꞌen. ");
INSERT INTO pps_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Xrajeꞌo nchakon meꞌe, yuu sen chrikao ndo Jesús stetji sen chaꞌo itji tjajna ndatinꞌin Emaús, tjajna meꞌe jii xranchi tenaá kilómetro kjínxin ti jii tjajna Jerusalén. ");
INSERT INTO pps_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Ko stetjao sen kondee kain ngeꞌe juinchekao na̱ ndo Jesús. ");
INSERT INTO pps_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Ko stenichja sen, ndo Jesús konchjiñeꞌe ndo tjenka sen ko jitikao ndo sen ngatja chaꞌo. ");
INSERT INTO pps_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Ko maski bikon sen ndo Jesús juaꞌi kuichúxin sen ndo. ");
INSERT INTO pps_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Ko ndo Jesús juanchangi ndo: ―Jaꞌanta, ¿ngeꞌe stetjaunnta ti yaꞌanta chaꞌo? ¿Ko sonda tsango niꞌe asáanta? ");
INSERT INTO pps_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Ko naa sen ndatinꞌin Cleofas juatingíexin: ―¿Jaꞌua jaꞌa juiꞌa tjajna Jerusalén ko noaꞌia ngeꞌe konꞌen nchakon jiꞌi? ");
INSERT INTO pps_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Ko ndo Jesús ndachro ndo: ―¿Ngeꞌe konꞌen ntiꞌa? Ko jeꞌe sen juatingíexin sen: ―¿Á noaꞌia ngeꞌe konꞌen ndo Jesús, ndo tjajna Nazaret, naa ndo profeta kuachronga chijnie ndo Dio? Kain ngeꞌe nichja ndo ko ti juincheꞌe ndo juako ndo ijié juachaxien ndo Dio, ko ni bikon kain jiꞌi juincheꞌe na̱ juaxruxin. ");
INSERT INTO pps_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Ko xi taana xi tetuanꞌan ko xi tetuanꞌan tjajnana̱na kuajon xa ndo Jesús ngajin xi Pilato ixi tsakeꞌe ndo xa nganito nta̱cru. ");
INSERT INTO pps_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Ko janꞌanna xraxaꞌonna ixi jeꞌe ndo Jesús xrokuantsjengíꞌe ndo ti tetuanꞌan ni romano ngajin tjajnana̱na Israel. Ko jai ó chónda níi nchakon kuenꞌen ndo. ");
INSERT INTO pps_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Ko kaxin nchri baruéꞌe ndo Jesús juinchexronkana nchra ixi ndúyo kuitsjeꞌe nchra ti no tsixrabaa ndo Jesús, ");
INSERT INTO pps_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","ko kuitjaꞌi nchra cuerpoe ndo, ko ikjan nchra nchia ko bekina̱na nchra ixi yuu sen ángel konoxin sen ngajin nchra ko chronga sen ixi ndo Jesús jichón ndo. ");
INSERT INTO pps_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Ko kaxin sen kichianna ikjui sen kuitsjeꞌe sen ti no tsixrabaa ndo ko kuitja sen xranchi ndachro jeꞌe nchra, ko kaxon bikonꞌa sen ndo. ");
INSERT INTO pps_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Ko ndo Jesús ndachro ndo: ―¡Sonda tienxinꞌanta, ko tsango indao titikaonnta kain ti ngeꞌe ndachro sen profeta kui̱i̱ saꞌó! ");
INSERT INTO pps_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","¿Á jeꞌa ixi tsango tangi xrokonꞌen ndo Cristo saꞌó ko tjumeꞌe xrokuayéꞌe ndo itsjé juasaya ngajní? ");
INSERT INTO pps_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Ko tjumeꞌe juangíxin ndo juinchekuenꞌen ndo sen ngeꞌe jitaxin xroon chijnie ndo Dio ti ndachro ngeꞌe xrokonꞌen jeꞌe ndo Cristo. Ko juangíxixín ndo ti no tsikjin ndo Moisés ko kain sen kuachronga chijnie ndo Dio ó saꞌó. ");
INSERT INTO pps_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Ko kuiji sen tjajna, ko ndo Jesús juincheꞌe ndo xranchi saxrokjui ndo ícha ikjín. ");
INSERT INTO pps_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Ko jeꞌe sen kuinóatée sen tsituꞌe ndo ngajin sen: ―Tituanꞌanta ngajinna ixi ó kontie. Ko ndo Jesús kuixinꞌin ndo nchia ko kuituꞌe ndo ngajin sen. ");
INSERT INTO pps_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Ko kuintee sen ti mesa ko ndo Jesús itsé ndo nutja ko kuajon ndo juasie ndo ngajin ndo Dio, ko tjumeꞌe konchrinjin ndo nio ko kuajon ndo nio ngajin sen. ");
INSERT INTO pps_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Ko hora meꞌe, xitjeꞌe̱ ikon sen ko kuichúxin sen ndo Jesús ko jeꞌe ndo sajuixin ndo ti ste sen. ");
INSERT INTO pps_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Ko jeꞌe sen ndache kichuu sen: ―¿Á jeꞌa aséei̱na tsango chaxro konoꞌe ti steyáꞌana chaꞌo ko jeꞌe ndo jinichjai̱na ndo ngeꞌe xrondachro chijnie ndo Dio? ");
INSERT INTO pps_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Ko í chuenꞌa sen ícha; tuinxin kua sen chaꞌo ko ikjan sen tjajna Jerusalén. Ntiꞌa kuixinꞌin sen nchia ti ste sen tenaá apóstol chrikao ndo Jesús ko ikaxin sen ste ntiꞌa. ");
INSERT INTO pps_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Ko sen ste ngaxinꞌin nchia chronga sen: ―Ndo Jesús nduaxin xechón ndo, ixi konoxin ndo ngajin ndo Simón Pedro. ");
INSERT INTO pps_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Tjumeꞌe sen yuu kui̱xi̱n tjajna Emaús chronga sen ngeꞌe konꞌen ngatja chaꞌo, ko xranchi kuichúxin sen ndo Jesús ti konchrinjin ndo nutja ko konchjeya ndo nio. ");
INSERT INTO pps_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Ko xra stetjao sen ngeꞌe konꞌen, jeꞌe ndo Jesús bakeꞌe ndo ngusine ti ste sen ko ndachro ndo: ―¿Á chao stenta? ");
INSERT INTO pps_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Ko jeꞌe sen ícha xronka sen ixi xraxaon sen ti stetsjeꞌe sen naa espíritue ni tsikenꞌen. ");
INSERT INTO pps_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Ko jeꞌe ndo Jesús ndache ndo sen: ―¿Sonda tsango stexronkanta ko sonda xratitikaonꞌanta ngaya asáanta? ");
INSERT INTO pps_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Tsjeꞌenta tjáana ko tutéena ixi nduaxin janꞌan. Itseninta ko tsjeꞌenta; ixi naa espíritue ni tsikenꞌen chóndaꞌi ntao ko inta̱a̱ xranchi tikonnta chonda janꞌan. ");
INSERT INTO pps_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Jaña ndachro ndo, ko juako ndo itja ndo ko tutée ndo. ");
INSERT INTO pps_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Ko jeꞌe sen xratitikaonꞌa sen ngeꞌe stetsjeꞌe sen ixi tsango juaxruxin ste sen ko xrastexronka sen; méxin, jeꞌe ndo ndachro ndo: ―¿Á chondanta ngeꞌe sineni? ");
INSERT INTO pps_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Ko jeꞌe sen chjée sen ndo tuꞌo kuchee̱ tsichjántaꞌa xroꞌi ko tuꞌo katje chónda tsjeen kuchji̱ꞌi̱. ");
INSERT INTO pps_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Ko jeꞌe ndo itsé ndo ngeꞌe kuajon sen ko juine ndo ko jeꞌe sen stetsjeꞌe sen. ");
INSERT INTO pps_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Ko tjumeꞌe ndachro ndo: ―Nchakon bakeꞌe ngajinnta ntatjunta kain ngeꞌe xrojuinchena̱ na̱ xranchi tsikjin ndo Moisés ko tsikjin sen profeta ko ti jitaxin xroon Salmo. ");
INSERT INTO pps_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Ko tjumeꞌe jeꞌe ndo kuajon ndo juachaxin ixi tsienxin sen ti jitaxin xroon chijnie ndo Dio, ");
INSERT INTO pps_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","ko ndachro ndo: ―Jaꞌin jitaxin ixi ndo Cristo xrokonda tsenꞌen ndo ko nchakon nínxin xroxechón ndo. ");
INSERT INTO pps_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Ko juachaxien ndo ko nombrée ndo xrokonda xronichja na̱ tsinꞌen kain ni tjajna xasintajni ixi jaña xrokjan na̱ tsitikaon na̱ ndo Dio, ko tsoméꞌe kain ti ndakoꞌa ncheꞌe na̱. Xroxrangíxixión tsinꞌen ni tjajna Jerusalén. ");
INSERT INTO pps_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Ko jaꞌanta ti bikonta kain jiꞌi xrokonda xronichjanta ti ngeꞌe bikonta. ");
INSERT INTO pps_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","*Ko janꞌan xroxruanꞌannta ti ngeꞌe ndachro Ndotána. Jaꞌanta tituanꞌanta ntiꞌi tjajna Jerusalén tsayéjanta ijié juachaxin tsi̱ꞌxi̱n ngajní ko meꞌe Espíritue ndo Dio. ");
INSERT INTO pps_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","*Ko kuachrjexin sen tjajna meꞌe ko ndo Jesús bikao ndo sen tjajna Betania. Ntiꞌa juatsiꞌin itja ndo ko juinchenchaon ndo sen. ");
INSERT INTO pps_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Ko xrajinchenchaon ndo sen, jeꞌe ndo kuachrjendáa ndo, ko kuaxi kuajinꞌin ndo ngajní. ");
INSERT INTO pps_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Ko jeꞌe sen kuajon sen juasaya ngajin ndo Jesús. Ko tjumeꞌe ikjan sen tjajna Jerusalén, ko tsango ijié juaxruxin chónda aséen sen. ");
INSERT INTO pps_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Ko kain nchakon bakeꞌe sen ngaxinꞌin ndoꞌa ndo Dio ko tajon sen juasaya ngajin ndo.");
INSERT INTO pps_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Ti xrangíxixín xrakoꞌa nunte xasintajni ó jii chijni ko chijni meꞌe ndo Cristo, ko jeꞌe ndo bakekao ndo ndo Dio ko jeꞌe ndo ndo Dio ndo. ");
INSERT INTO pps_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Ti xrangíxixín bakekao ndo ndo Dio, ");
INSERT INTO pps_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","ko ixi jeꞌe ndo Cristo, ndo Dio juinchéña ndo kain ngeꞌe jii. Ko ninaa ngeꞌe jii xrokuakeꞌa siá xrakuajonꞌa ndo juachaxien ndo xrobakeꞌe. ");
INSERT INTO pps_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Jeꞌe ndo kuajon ndo juachaxin jichón kain ngeꞌe ko jeꞌe ndo naa xroꞌi tingasáña ngajin chujni. ");
INSERT INTO pps_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Ko xroꞌi meꞌe tingasáña ti naxixeꞌe ko ti naxixeꞌe juaꞌi nchekanga xroꞌi. ");
INSERT INTO pps_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","*Bakeꞌe naa ngisen tsixruaꞌan ndo Dio, ndo meꞌe ndatinꞌin ndo Juan ");
INSERT INTO pps_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","ixi xrochronga ndo kondee xroꞌi meꞌe ixi kain chujni tsitikaon na̱ xroꞌi ixi ngeꞌe xrondachro ndo. ");
INSERT INTO pps_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Ko ndo Juan jeꞌa jeꞌe ndo xroꞌi meꞌe. Jeꞌe ndo jeꞌo xrochronga ndo kondee xroꞌi. ");
INSERT INTO pps_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Xroꞌi nduaxin xroꞌi tingasáña kain chujni ó jiti̱i̱ xroꞌi nunte xasintajni. ");
INSERT INTO pps_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Chijni jian, ndo Cristo, ó jii ndo nunte xasintajni, ko maski ndo juinchéña ndo nunte, chujni ste nunte xasintajni kuichúxinꞌa na̱ ndo. ");
INSERT INTO pps_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Kui̱i̱ ndo ngajin ni judío, ni tjajnée ndo, ko kuayéꞌa na̱ ndo. ");
INSERT INTO pps_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Ko ikaxin sen kuayéꞌe sen ndo ko kuitikaon sen ndo, kuajon ndo juachaxin ngajin sen ixi xrokjan sen chjenꞌen ndo Dio. ");
INSERT INTO pps_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Sen meꞌe jeꞌa xranchi tjongíꞌe naa chjenꞌen naa chujni jaña tjongíꞌe sen. Naꞌi. Ó chjenꞌen ndo Dio jeꞌe sen. ");
INSERT INTO pps_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Ko chijni, ndo Cristo, jeꞌe ndo ikjan ndo chujni ko bakeꞌe ndo ngajinna ko tjaunna ndo ko ti nduaxin ndachro ndo. Ko ó bikona juachaxien ndo, juachaxien chjenꞌen Ndotáina Dio, xjan naakuaxon. ");
INSERT INTO pps_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Ndo Juan nichja ndo ixi ndo Cristo ko ndachro ndo: ―Jiꞌi ngisen ntatjunta nchakon ndachrja̱n, tjumeꞌe tsi̱i̱ inaa ngisen ícha tetuanꞌan, ixi ó saꞌó jii ndo ixi najanꞌan. ");
INSERT INTO pps_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Kainna ó kuayeꞌena juachaxin tjintee tajon ndo, ko nchenchaonna ndo kain nchakon. ");
INSERT INTO pps_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Ley kuetuanꞌan ndo Dio juinchenoi̱na ndo Moisés, ko ti tjueꞌe ndo chujni ko ti nduaxin meꞌe ti̱ꞌxi̱n ixi ndo Jesucristo. ");
INSERT INTO pps_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Xroꞌan ngisen bikon ndo Dio. Jeꞌo chjenꞌen ndo, xjan naakuaxon, xjan jiníi Ndotée ko jeꞌe xjan juinchenoi̱na xjan xranchi jii Ndo Dio. ");
INSERT INTO pps_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Kaxin ni judío, ni tjajna Jerusalén, xruanꞌan na̱ xitaana ko xi tjako ley ngajin ndo Juan ixi tsjanchangíꞌe na̱ ndo: ―¿Ngisen jaꞌa? ");
INSERT INTO pps_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Ko jeꞌe ndo ndako juatingíexin ndo: ―Jeꞌa ndo Cristo najanꞌan. ");
INSERT INTO pps_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Tjumeꞌe íjngo juanchangiꞌe xa ndo: ―¿Ngisen jaꞌa tjumeꞌe? ¿Á ndo kuachronga chijnie ndo Dio ó saꞌó, ndo Elías? Ko ndo Juan ndachro ndo: ―Jeꞌa jeꞌe ndo janꞌan. Tjumeꞌe juanchangiꞌe xa ndo: ―¿Á jaꞌa ndo xrochronga chijnie ndo Dio, ndo xrokui̱i̱? Ko juatingíexin ndo: ―Naꞌi. ");
INSERT INTO pps_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Méxin, ndache xa ndo: ―¿Ngisen jaꞌa tjumeꞌe? Xrokonda tsikiꞌanna chijni ngajin ngisen xruanꞌanna. ¿Ngeꞌe chao xrondachrua ngisen jaꞌa? ");
INSERT INTO pps_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Juatengíexin ndo Juan: ―Janꞌan naa ngisen nichja séen jii ntajie ndachro: “Tantjeꞌenta naa chaꞌo nao itji ixi Ncháina tsi̱i̱” ―ti ndachro ndo Juan meꞌe tsindachro ndo profeta Isaías. ");
INSERT INTO pps_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Ko chujni tsikjin tsijao ndo Juan, xi fariseo tsixruaꞌan chujni ");
INSERT INTO pps_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","ko juanchangiꞌe na̱ ndo: ―Siá jeꞌa jaꞌa ndo Cristo, ko jeꞌa ndo profeta Elías, ko kaxon jeꞌa ndo profeta stechónꞌen na̱, ¿sonda tikitée na̱ tjumeꞌe? ");
INSERT INTO pps_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Ndo Juan ndache ndo na̱: ―Janꞌan tikitéexin na̱ inda, ko ngakjenꞌen jaꞌanta jii naa ngisen chuxinꞌanta. ");
INSERT INTO pps_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Tuenxin najanꞌan jiti̱i̱ ndo ko ícha tetuanꞌan ndo ixi janꞌan. Ko tikinixinꞌa tsoxindangaꞌa tjuée katée ndo. ");
INSERT INTO pps_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Kain jiꞌi konꞌen tjajna Betábara ndatsjonxin ti indajitinga ndatinꞌin Jordán ti no jii ndo Juan jitikitée ndo chujni. ");
INSERT INTO pps_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Ndúyaxin ndo Juan bikon ndo ndo Jesús jitonchjiñeꞌe ndo tjenka ndo ko ndachro ndo: ―Tsjeꞌenta ntiꞌi jiti̱i̱ ndo xranchi naa Kutuchjoen ndo Dio, ndo tantsje jíee ni nunte xasintajni. ");
INSERT INTO pps_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Nchakon ndachrja̱n jiti̱i̱ naa ngisen tuenxin najanꞌan, ngisen ícha tetuanꞌan ixi ó saꞌó jii jeꞌe ndo, meꞌe nichja ixi jeꞌe ndo. ");
INSERT INTO pps_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Janꞌan kaxon kuichuxinꞌa ndo. Ko janꞌan bakikitéexin na̱ ixi inda ixi jaña ni tjajna Israel xrokuichuxin na̱ ndo. ");
INSERT INTO pps_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Kaxon ndachro ndo Juan: ―Janꞌan bikon Espíritue ndo Dio xingajinxin ngajní xranchi naa kuntúá ko bakeꞌe ngataꞌa ndo. ");
INSERT INTO pps_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Ko xranónaꞌi ngisen jeꞌe ndo. Ko ngisen xruanꞌanna tsikitée chujni ixi inda, ndo meꞌe ndachijina ndo: “Nchakon tsikuan Espíritue ndo Dio xroxingajinxin ngajní ko tsi̱i̱ ngataꞌa naa ngisen, ndo meꞌe tsikitée ndo na̱ ixi Espíritue ndo Dio.” ");
INSERT INTO pps_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Janꞌan ó bikon ndo ko chrjaꞌnga ixi jeꞌe ndo Chjenꞌen ndo Dio. ");
INSERT INTO pps_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Ndúyaxin ndo Juan jii ndo ntiꞌa íjngo ko kao yuu sen chrjikao ndo, ");
INSERT INTO pps_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","ko hora bikon ndo Juan kuatsinga ndo Jesús, ndachro ndo: ―Tsjeꞌenta, jeꞌe ndo Kutuchjoen ndo Dio. ");
INSERT INTO pps_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Kayui sen ruéꞌe ndo Juan kuinꞌen sen ngeꞌe ndachro ndo ko ruéꞌe sen ndo Jesús. ");
INSERT INTO pps_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Méxin, ndo Jesús ngatjia ndo tsjeꞌe ndo ko bikon ndo jiruéꞌe sen ndo ko ndachro ndo: ―¿Ngeꞌe tjéenta? Jeꞌe sen ndachro sen: ―Maestro, ¿no jii ndúya? ");
INSERT INTO pps_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Ko juatingíexin ndo Jesús: ―Xrokuinta tsjeꞌenta. Méxin, ikjui sen ko bikon sen ti no bakituꞌe ndo ko kuatsinga sen nguixin nchakon meꞌe ngajin ndo ixi ó kóndo xranchi las cuatro. ");
INSERT INTO pps_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Naa sen yuu tsikinꞌen ngeꞌe ndachro ndo Juan ko tsirueꞌe ndo Jesús, ndo meꞌe ndatinꞌin Andrés, ndo kichuu ndo Simón Pedro. ");
INSERT INTO pps_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Ndo Andrés tuinxin ikjui ndo bijée ndo ndo kichuu ndo, ndo Simón, ko ndachro ndo: ―Kuitjána ndo Mesías. Mesías xrondachro Cristo. ");
INSERT INTO pps_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Tjumeꞌe ndo Andrés bikao ndo ndo Simón ti no jii ndo Jesús. Ko hora bikon ndo Jesús sen, ndachro ndo: ―Jaꞌa Simón, chjenꞌen ndo Jonás. Ko jai ndatsiꞌian Cefas. Ko Cefas xrondachro Pedro. ");
INSERT INTO pps_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Ndúyaxin ndo Jesús tjaun ndo xrokjui ndo nunte Galilea ko kuetan ndo ndo Felipe, ko ndache ndo ndo: ―Ruana̱na. ");
INSERT INTO pps_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Ko ndo Felipe, ndo tjajna Betsaida, ntiꞌa kaxon tjajnée ndo Andrés ko ndo Pedro. ");
INSERT INTO pps_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Ko ndo Felipe ikjui ndo bijée ndo ndo Natanael ko ndachro ndo: ―Ó bikona ndo xrokui̱i̱ xranchi tsikjin ndo Moisés ti xroon ley ko kaxon ngisen tsikjin sen profeta. Jiꞌi ndo Jesús, chjenꞌen ndo José, ndo tjajna Nazaret. ");
INSERT INTO pps_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Ndachro ndo Natanael: ―¿Á ko chao xrokuachrje naa ngeꞌe jian tjajna Nazaret? Juatengíexin ndo Felipe: ―Xrokuia tsjeꞌé. ");
INSERT INTO pps_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Ko hora bikon ndo Jesús jitonchjiñeꞌe ndo Natanael, ndachro ndo: ―Ntiꞌi jiti̱i̱ naa ndo nduaxin israelita ko xroꞌan juancheya jii ngajin ndo. ");
INSERT INTO pps_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Méxin, juanchangi ndo Natanael ngajin ndo Jesús: ―¿Xranchi chuxianna? Ko ndachro ndo Jesús: ―Janꞌan bikuan ti xratiyaꞌia ndo Felipe hora bakeꞌe chringi nta̱a̱ tajon tuhigo. ");
INSERT INTO pps_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Méxin, ndachro ndo Natanael: ―Maestro, jaꞌa Chjenꞌen ndo Dio, ndo Rey tetuanꞌan tjajna Israel. ");
INSERT INTO pps_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Juatengíexin ndo Jesús: ―¿Á kuitikaonna ixi jeꞌo ntatjua bikuan chringi nta̱a̱ tajon tuhigo? Tjumeꞌe tsikuan ícha ijié ngeꞌe ixi ti ngeꞌe bikuan jai. ");
INSERT INTO pps_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Kaxon ndachro ndo Jesús: ―Nduaxin ntatjunta ixi tsikonnta xroxitjeꞌe ngajní ko sen angéel ndo Dio stetajinꞌin sen ko stexinganjin sen ngataꞌa Chjenꞌen ndo Dio, xjan jongíꞌe xranchi chujni. ");
INSERT INTO pps_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Níi nchakon tjumeꞌe bakeꞌe naa kia kuteꞌe na̱ tjajna Caná nunte Galilea. Janée ndo Jesús jii jan ntiꞌa. ");
INSERT INTO pps_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Ni bakeꞌe kia nichjeꞌe na̱ ndo Jesús ko sen teyuu chrikao ndo xrokui̱i̱ sen kia meꞌe kaxon. ");
INSERT INTO pps_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Tjumeꞌe tsikanga xranvino ko janée ndo Jesús ndache jan ndo: ―Í chóndaꞌi na̱ xranvino. ");
INSERT INTO pps_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Ko juatingíexin ndo Jesús: ―Nchri, ¿sonda ndachijiana meꞌe? Xratijiꞌa nchakon sintaꞌa naa ixra̱ ijié. ");
INSERT INTO pps_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Ko jeꞌe jan ndache jan ni stetonchjeya ngeꞌe: ―Ncheꞌenta kain ngeꞌe xrontatjunta ndo. ");
INSERT INTO pps_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Ko ntiꞌa jii ikjaon ichi tsikoña ixro, jitjiá inda, meꞌe tundeꞌe ni judío nchakon tijma na̱, nchakon tantsje na̱ jíee na̱. Ko ngujngu ichi meꞌe titja tikia xranchi ochenta o̱ ciento litro inda. ");
INSERT INTO pps_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Ndo Jesús ndache ndo sen jitonchjeya ngeꞌe: ―Nchechrénta inda ichi jiꞌi. Ko juincheꞌchré na̱ ichi inda. ");
INSERT INTO pps_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Tjumeꞌe ndachro ndo Jesús: ―Tantsjenta nchíín inda ko tikuꞌunta inda ngajin xi tetuanꞌan kia. Ko jaña juincheꞌe na̱. ");
INSERT INTO pps_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Ko xi tetuanꞌan kia kuiꞌi xa nchíín inda ko ó tsikjan inda xranvino ko noeꞌa xa no kui̱xi̱n xran. Jeꞌo ni tochjeya ngeꞌe noꞌe na̱ ixi jeꞌe na̱ tsikantsje na̱ inda. Méxin, xi tetuanꞌan kia kuiyeꞌe xa xi kuteꞌe. ");
INSERT INTO pps_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Ko ndache xa xi kuteꞌe: ―Kain na̱ saꞌó tajon na̱ xran ícha jian ko hora ni kui̱i̱ kia ó kuiꞌi na̱ yee xran, meꞌe tajonni xran ngixeko. Ko jaꞌa tsikatsian xran jian hasta jai. ");
INSERT INTO pps_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Ngeꞌe tsijincheꞌe ndo Jesús tjajna Caná nunte Galilea, ña̱ saꞌó ngeꞌe juincheꞌe ndo ixi tsjako ndo juachaxien ndo, ko sen teyuu chrikao ndo kuitikaon sen ndo. ");
INSERT INTO pps_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","*Ko kuatsinga jiꞌi, ikjui ndo tjajna Capernaum, ko janée ndo ko xikichuu ndo ko sen teyuu chrikao ndo, ko ntiꞌa bakeꞌe sen kaxin nchakon. ");
INSERT INTO pps_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Ó tsi̱i̱ nchakon kia Pascua neꞌe ni judío, ndo Jesús sakjui ndo tjajna Jerusalén. ");
INSERT INTO pps_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Ko ntiꞌa ngaxinꞌin niꞌngo jié kuitja ndo ni nchekji kuxinta, kutuchjon, kuntúá, ko ni ste nunte jitasingixin na̱ tomie chujni. ");
INSERT INTO pps_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Ko hora bikon ndo Jesús jiꞌi, juinchéña ndo naa cuarta, ko bengixin ndo na̱ ntiꞌa ko kao kutuchjoen na̱ ko kuxinteꞌe na̱. Ko kuintjí ndo ngataꞌa nche tomie ni bakasingixin ko ndáꞌa banka ndo mesé na̱. ");
INSERT INTO pps_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Ko jeꞌe ndo ndache ndo ni nchekji kuntúá: ―¡Tantsjexinnta kain ngeꞌe ntiꞌi! Nchéñaꞌinta ndoꞌa Ndotána xranchi naa ndasin. ");
INSERT INTO pps_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Méxin, sen teyuu chrikao ndo xraxaon sen ngeꞌe ti ndachro xroon chijnie ndo Dio: “Tsango chjána juañao ngeꞌe ndakoꞌa tonꞌen ngaxinꞌin ndointa.” ");
INSERT INTO pps_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Méxin ni judío juanchangiꞌe na̱ ndo: ―¿Ngeꞌe tjakoxian ixi chao sincheꞌe kain jiꞌi? ");
INSERT INTO pps_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","*Ko juatingíexin ndo Jesús: ―Tonchjejinnta niꞌngo jiꞌi ko nínxin nchakon sintakonchjian niꞌngo íjngo. ");
INSERT INTO pps_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Ko ni judío ndache na̱ ndo: ―Yuukan ko ikjaon nano konchjianxin niꞌngo jiꞌi, ko, ¿á jaꞌa nínxin nchakon sinchekonchjianxian niꞌngo íjngo? ");
INSERT INTO pps_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Ko ti niꞌngo nichja ndo Jesús meꞌe cuerpoe ndo. ");
INSERT INTO pps_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Méxin, nchakon xechón ndo Jesús, sen teyuu chrikao ndo xraxaon sen ti ngeꞌe tsichronga ndo, ko kuitikaon sen xroen ndo Dio ko chijni tsindache ndo sen. ");
INSERT INTO pps_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Nchakon ndo Jesús bakeꞌe ndo tjajna Jerusalén kia Pascua, itsjé na̱ kuitikaon na̱ ndo nchakon bikon na̱ ngeꞌe jian juincheꞌe ndo. ");
INSERT INTO pps_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Ko ndo Jesús kuachúntiaꞌi ndo na̱ ixi chúxin ndo ngeꞌe xraxaon kain na̱, ");
INSERT INTO pps_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","ko baxrokondeꞌa ndo ixi naa chujni xrobekiꞌe ndo ngeꞌe juincheꞌe inaa chujni ixi jeꞌe ndo noꞌe ndo ngeꞌe xraxaon na̱ ngaya aséen na̱. ");
INSERT INTO pps_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Bakeꞌe naa xi Fariseo ndatinꞌin xa Nicodemo, xi meꞌe tetuenꞌen xa ngajin ni judío. ");
INSERT INTO pps_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Xi jiꞌi kui̱i̱ xa ngajin ndo Jesús naa tiie ko ndachro xa: ―Maestro, nónana ixi ndo Dio xruanꞌan ndo ixi sinchekuanna̱na, ixi xroꞌan ngisen xrojuincheꞌe ngeꞌe jian ncheꞌe jaꞌa siá ndo Dio xrobakeꞌa ndo ngajian. ");
INSERT INTO pps_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Ko ndo Jesús ndachro ndo: ―Janꞌan ntatjua ixi ngisen tjongíeꞌa íjngo juaꞌi tsikon sen ti tetuanꞌan ndo Dio. ");
INSERT INTO pps_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Juanchangi xi Nicodemo: ―¿Xranchi tsjongíꞌe naa xi íjngo siá ó nta̱xi xa? ¿Xranchi chao íjngo tsixinꞌin xa tse̱ꞌe̱ janée xa ko tsjongíꞌe xa íjngo? ");
INSERT INTO pps_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Ko ndo Jesús ndachro ndo: ―Nduaxin ntatjua: ixi ngisen tsjongíexinꞌa inda ko Espíritue ndo Dio juaꞌi tsixinꞌin sen ti tetuanꞌan ndo Dio. ");
INSERT INTO pps_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Chujni tjongíexin ndotée ko janée xra jeꞌo chujni sen, ko sen tjongíexin Espíritue ndo Dio, sen meꞌe tayéꞌe sen Espíritue ndo. ");
INSERT INTO pps_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Xronkaꞌia ixi ngeꞌe ntatjua ixi xrokonda tsjongíꞌe kain chujni íjngo. ");
INSERT INTO pps_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Chrinto itji chrinto no tjaun chrinto. Ko jaꞌa tinꞌen xroin chrinto ko noaꞌia no itji chrinto ko no ti̱ꞌxi̱n chrinto. Ko jaña sen tjongíexin Espíritue ndo Dio. ");
INSERT INTO pps_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Ko jeꞌe xi Nicodemo juanchangi xa: ―¿Xranchi tsonꞌen jiꞌi? ");
INSERT INTO pps_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Ko ndo Jesús ndachro ndo: ―Jaꞌa nchekuenꞌén chujni Israel, ¿á tienxinꞌa ti ntatjua? ");
INSERT INTO pps_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Janꞌan nduaxin ntatjua ti nónana nichjana ko ti bikona tekina, ko jaꞌanta titikaonꞌanta ti ngeꞌe ndachrja̱nna. ");
INSERT INTO pps_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Tekiꞌanta ngeꞌe tsonꞌen ngataꞌa nunte ntiꞌi ko titikaonꞌanta ko, ¿xranchi tsitikaonnta siá xrontatjunta ngeꞌe tsonꞌen ngajní? ");
INSERT INTO pps_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Xroꞌan ngisen kuajinꞌin ngajní, jeꞌo Chjenꞌen Ndo Dio, xjan jongíꞌe xranchi Chujni, jeꞌe xjan bakeꞌe xjan ngajní ko kui̱xi̱n xjan ntiꞌa. ");
INSERT INTO pps_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Xranchi juincheꞌe ndo Moisés nchakon bakeꞌe sen ntajie, ntiꞌa kuasintjian ndo naa kunchee chika ixi xrotsjeꞌe sen ba ko jaña tsenꞌa sen; méxin, jaña tsonꞌen tsasintjian na̱ Chjenꞌen ndo Dio, xjan jongíꞌe xranchi chujni, ");
INSERT INTO pps_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","ko jaña kain sen tsitikaon ndo Jesús tsenꞌa aséen sen, tsechón sen kain nchakon. ");
INSERT INTO pps_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","’Ndotáina Dio tsango tjueꞌe ndo kain chujni jii ngataꞌa nunte xasintajni, méxin xruanꞌan ndo chjenꞌen ndo, xjan naakuaxon, ixi kain sen tsitikaon xjan tsitjáñaꞌi aséen sen ko jeꞌe sen tsechón sen kain nchakon. ");
INSERT INTO pps_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Ko ndo Dio xruanꞌi ndo chjenꞌen ndo ngataꞌa nunte xasintajni ixi tsjankataꞌa xjan ijie̱ ngajin na̱. Naꞌi, jeꞌe xjan tsantsje xjan ijie̱ chónda na̱ ko jaña tsitjáñaꞌi na̱. ");
INSERT INTO pps_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Ngisen tsitikaon chjenꞌen ndo Dio tsjankataꞌi ndo sen ijie̱. Ko ni tsitikaonꞌa, ó juankataꞌa ndo ijie̱ ngajin na̱ ixi kuitikaonꞌa na̱ chjenꞌen ndo Dio, xjan naakuaxon. ");
INSERT INTO pps_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Méxin, ni titikaonꞌa ó juexin juankataꞌa ndo na̱ ijie̱, ixi kui̱i̱ ngisen juinchengasáñeꞌe chujni jii ngataꞌa nunte xasintajni ko jeꞌe chujni juincheꞌa juaxruxin ixi ícha ruéꞌe na̱ ti naxixeꞌe ixi ndakoꞌa ncheꞌe na̱. ");
INSERT INTO pps_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","’Kain ni ndakoꞌa ncheꞌe, ningakonꞌen na̱ xroꞌi tingasáña ko tonchjiñeꞌa na̱ tjenka xroꞌi ixi tjaunꞌa na̱ tsonoxin ti ndakoꞌa stencheꞌe na̱. ");
INSERT INTO pps_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Ko sen ncheꞌe jian tonchjiñeꞌe sen tjenka xroꞌi tingasáña ixi chao tsikon chujni kain ngeꞌe stencheꞌe sen xranchi tjaun ndo Dio. ");
INSERT INTO pps_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Tjumeꞌe ndo Jesús ko sen teyuu chrikao ndo sakjui sen nunte Judea. Ntiꞌa kuatsinga ndo kaxin nchakon bikitée ndo chujni. ");
INSERT INTO pps_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Kaxon ndo Juan bakeꞌe ndo tjajna Enón tjenka tjajna Salim ko ntiꞌa bikitée ndo chujni ixi ntiꞌa jii yee inda. Ko chujni baki̱i̱ na̱ batikitée na̱. ");
INSERT INTO pps_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","*Jiꞌi konꞌen ti xratijéꞌa na̱ ndo Juan ndoꞌachjiso. ");
INSERT INTO pps_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Méxin, kaxin chujni, sen chrikao ndo Juan ko ni judío kuaxi nichja na̱ xranchi xrotjúáxin chujni. ");
INSERT INTO pps_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Ko sen chrikao ndo Juan kuintekji sen ngajin ndo ko chronga sen ngajin ndo: ―Maestro, ndo bakeꞌe ngajinnta tuenxin ndarío Jordán, ndo kondee bekina̱nanta, jai kao ndo tikitée ndo chujni ko itsjé na̱ ruéꞌe na̱ ndo. ");
INSERT INTO pps_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Ko ndachro ndo Juan: ―Xroꞌan ngisen xrojuincheꞌe naa ixra̱ siá ndo Dio xrokuajonꞌa ndo juachaxin. ");
INSERT INTO pps_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","*Jaꞌanta kuinꞌennta nchakon ndachrja̱n ixi janꞌan jeꞌa ndo Cristo. Jeꞌo naa ngisen kuitaoꞌen ndo chaꞌo ixi xrochrjanga tsi̱i̱ ndo. ");
INSERT INTO pps_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Nchakon tuteꞌe chujni, xi tuteꞌe tsayéꞌe xa janchriꞌe xa. Ko tjumeꞌe sen chúxin xa takeꞌe sen juaxruxin ixi jitinꞌen sen ngeꞌe jinichja xa. Ko kaxon janꞌan juaxruxin ritjén ixi kueya chujni jitonchjiñeꞌe ngajin ndo Jesús. ");
INSERT INTO pps_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Jeꞌe ndo xrokonda ícha tsetuanꞌan ndo ko janꞌan ínaꞌi. ");
INSERT INTO pps_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","’Ndo kui̱xi̱n ngajní tetuenꞌen kain chujni. Ko chujni nunte xasintajni chronga ngeꞌe jii nunte xasintajni. Ko ndo kui̱xi̱n ngajní tetuenꞌen ndo kain ngeꞌe. ");
INSERT INTO pps_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Jeꞌe ndo nichja ndo ngeꞌe tsikikon ndo ko ngeꞌe tsikinꞌen ndo. Ko xroꞌan chujni titikaon na̱ ngeꞌe ndachro ndo. ");
INSERT INTO pps_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Ko siá xrojan ngisen titikaon ngeꞌe ndachro ndo, jaña tjako sen ixi nduaxin ngeꞌe nichja ndo Dio, ");
INSERT INTO pps_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","ixi ndo xruanꞌan ndo Dio nichja ndo chijnie ndo Dio, ixi jeꞌe ndo kuayéꞌe ndo kain juachaxien Espíritue ndo Dio. ");
INSERT INTO pps_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","*Ndotáina Dio tjueꞌe ndo Chjenꞌen ndo, ko jaña tsikajon ndo kain juachaxin ixi tsetuenꞌen xjan kain ngeꞌe. ");
INSERT INTO pps_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Ngisen tsitikaon Chjenꞌen ndo Dio xrochónda sen juachaxin tsechón sen kain nchakon. Ko ngisen tjaunꞌa tsitikaon Chjenꞌen ndo xrochóndaꞌi sen juachaxin meꞌe, ixi ndo Dio tsajon ndo juachaxin tangi tsonꞌen sen. ");
INSERT INTO pps_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Tjumeꞌe ni fariseo konoꞌe na̱ ixi ícha itsjé chujni ruéꞌe ndo Jesús ko ícha itsjé chujni bikitée ndo ixi ndo Juan. ");
INSERT INTO pps_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Ko jeꞌa ndo Jesús tikitée ndo na̱. Sen chrikao ndo, sen meꞌe bikitée chujni. ");
INSERT INTO pps_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Hora konoꞌe ndo Jesús ixi jaña tsikinꞌen ni fariseo, kuachrjexin ndo nunte Judea ko íjngo ikjan ndo nunte Galilea. ");
INSERT INTO pps_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Ko hora kuachrjexin ndo ntiꞌa xrokonda tsatsinga ndo nunte Samaria. ");
INSERT INTO pps_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Ko kuiji ndo naa tjajna Sicar nunte Samaria, tjenka nunte tsikajon ndo Jacob kuayéꞌe chjenꞌen ndo, ndo José. ");
INSERT INTO pps_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Ntiꞌa jii naa pozo tjiá inda kuachónda ndo Jacob. Ko ndo Jesús kuiji ndo ntiꞌa ko tsango konchrje ndo ixi tsango ikjín tsikjixin ndo, méxin bakeꞌe ndo nunte tjenka pozo. Hora meꞌe xranchi ngusine nchakon. ");
INSERT INTO pps_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Ko tuinxin kui̱i̱ naa nchri tjajna Samaria, kui̱i̱ nchra ti pozo meꞌe ixi tsantsje nchra inda. Ko ndo Jesús ndache ndo nchra: ―Chjána̱na nchíín inda tsiꞌi. ");
INSERT INTO pps_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Ko sen teyuu chrikao ndo satsikintekji sen tjajna tjenka ntiꞌa bikeꞌna sen ngeꞌe sinekao sen ndo. ");
INSERT INTO pps_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Ko nchri samaritana juatingíexin nchra: ―¿Sonda jaꞌa naa chujni judío tjanchiana̱na inda ixi janꞌan naa nchri samaritanana? (Jaña ichro nchra ixi ni judío tjentoꞌa na̱ ni samaritano.) ");
INSERT INTO pps_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Ko juatingíexin ndo Jesús: ―Siá xrokonoꞌa ngeꞌe tajon ndo Dio ko xrochuxian ngisen jitjanchiaꞌa inda, jaꞌa xrojuanchana̱na inda ko janꞌan xrotjáꞌa inda jichón. ");
INSERT INTO pps_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Ko jeꞌe nchra juateꞌe nchra: ―Jaꞌa chondaiꞌa ngeꞌe tsantsjexian inda ko pozo tsango yasoꞌe pozo, ¿no xrochjánaxianna inda jichón? ");
INSERT INTO pps_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Ndo Jacob, ndo kuachrjenixinna, ndo meꞌe kuituna̱na ndo pozo jiꞌi, ko jeꞌe ndo bakiꞌi ndo inda ko chjenꞌen ndo ko kain kuée ndo kaxon. ¿Á jaꞌa, á ícha tjintee ixi jeꞌe ndo? ");
INSERT INTO pps_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Ko juatingíexin ndo Jesús: ―Kain ni tiꞌi inda jiꞌi, íjngo tsenꞌen na̱ inda. ");
INSERT INTO pps_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Ko sen tsiꞌi inda tajon janꞌan, naiꞌa tsintekenꞌen sen inda. Ixi inda tajon janꞌan tsoña̱ xranchi inda jitachrjexin ngaya aséen sen ko jiꞌi tajon juachaxin tsechón sen kain nchakon. ");
INSERT INTO pps_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Ko ndachro nchra: ―Chjána̱na inda meꞌe, ixi tsenꞌana inda íjngo ko íxrokjanꞌina tsantsje inda ntiꞌi. ");
INSERT INTO pps_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Ko ndachro ndo Jesús: ―Itjia tiyeꞌé ndoxiꞌa ko tjumeꞌe tsjiꞌia ntiꞌi íjngo. ");
INSERT INTO pps_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Ko jeꞌe nchra ndachro nchra: ―Chondaꞌi xixiꞌna. Méxin, ndachro ndo Jesús: ―Nduaxin ndachrua ixi chondaꞌia xixiꞌa. ");
INSERT INTO pps_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Ixi kuachonda naꞌó xixiꞌa, ko xi chonda jai jeꞌa xixiꞌa. Nduaxin ndachrua ixi chondaꞌia xixiꞌa. ");
INSERT INTO pps_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Ko kuinꞌen nchra jiꞌi ko ndachro nchra: ―Nóna ixi jaꞌa naa ngisen chronga chijnie ndo Dio. ");
INSERT INTO pps_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Sen kuachrjenixinna, kuaxraxaonxin sen ndo Dio ijna̱ ntiꞌi. Ko jaꞌanta, ni judíonta ndachronta ixi xrokonda xroxraxaonxinna ndo Dio niꞌngo ijié jii tjajna Jerusalén. ");
INSERT INTO pps_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Ko ndo Jesús ndache ndo nchra: ―Titikáoanna ixi tsi̱i̱ nchakon xrokondaꞌi xroxraxaonxinnta Ndotáina Dio ijna̱ ntiꞌi ko xroxraxaonxinꞌanta ndo tjajna Jerusalén. ");
INSERT INTO pps_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Jaꞌanta chujni samaritanonta noaꞌinta ngisen xraxaonnta. Ko janꞌan naa chujni judío chuxinna ngisen xraxaꞌonna. Méxin, ndo tantsje ijie̱ chónda chujni, ndo meꞌe tsikachrjexin ndo ni judío. ");
INSERT INTO pps_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Ko jitiji nchakon ko jai nchakon meꞌe, ixi sen nduaxin tjaun sen tsajon sen juasaya ngajin Ndotáina Dio, xrokonda ixi nchijíi aséen sen xroxraxaonxin sen Ndo. Ko Ndo Dio tsakeꞌe ndo juaxruxin ixi jaña xroxraxaon sen ndo. ");
INSERT INTO pps_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Ndo Dio espíritu ndo, ko sen xraxaon ndo xrokonda xroxraxaonxin sen ndo ixi aséen sen. ");
INSERT INTO pps_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Ko ndachro nchra: ―Janꞌan nóna ixi tsi̱i̱ ndo Mesías, ndo Cristo. Ko nchakon tsi̱i̱ ndo sinchekuanna̱na ndo kain ngeꞌe. ");
INSERT INTO pps_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Ko juatingíexin ndo Jesús: ―Ndo meꞌe najanꞌan, ndo ritjáoa jai. ");
INSERT INTO pps_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Xrastetjao sen jaꞌin, sen teyuu chrikao ndo kuiji sen, ko xronka sen ixi bikon sen jinichjeꞌe ndo naa nchri, ko xroꞌan ngisen juanchangiꞌe ndo ngeꞌe tjaun nchra, o̱ sonda jinichjeꞌe ndo nchra. ");
INSERT INTO pps_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Tjumeꞌe jeꞌe nchra bakeꞌe nchra nchixran nunte ko sakjui nchra tjajna bekiꞌe nchra kain chujni: ");
INSERT INTO pps_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","―Ichjina, tsikonnta naa ndo chronga kain ngeꞌe juintaꞌa. ¿Á jeꞌa ndo Cristo ndo meꞌe? ");
INSERT INTO pps_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Tjumeꞌe chujni kuachrjexin na̱ tjajna kuitsjeꞌe na̱ ndo Jesús. ");
INSERT INTO pps_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Xratijiꞌa na̱, sen teyuu chrikao ndo tinóatée sen ngajin ndo, ndachro sen: ―Maestro, inte ngeꞌe. ");
INSERT INTO pps_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Ko ndachro ndo: ―Janꞌan chónda ngeꞌe iné ko jaꞌanta chuxinꞌanta meꞌe. ");
INSERT INTO pps_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Ko sen teyuu chrikao ndo kuaxi sen juanchangiꞌe kichuu sen: ―¿Á xrojan chujni bikenꞌen ndo ngeꞌe juine ndo? ");
INSERT INTO pps_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Ko ndachro ndo Jesús: ―Ti iné janꞌan meꞌe ixra̱ sintaꞌa ti tsiketuanꞌan ngisen xruanꞌanna, ko xrokonda sintajexin ixra̱. ");
INSERT INTO pps_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Jaꞌanta ndachronta: “Xratitjáña noó nchanitjao tsandáanta noatrigo.” Ko janꞌan ntatjunta: Tsjeꞌenta no tsikinga ixi ó kuicha noa ko ó chao tsandáani. ");
INSERT INTO pps_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Sen tandáa, xengeꞌe sen ꞌna̱. Ko ngeꞌe tandáa sen meꞌe chujni, ko chujni meꞌe tsechón kain nchakon. Ko sen tenga ko sen tandáa xreꞌó juaxruxin takeꞌe sen. ");
INSERT INTO pps_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Ko nduaxin ngeꞌe ndachro sen: “Naa sen tenga, ko inaa sen tsandáa.” ");
INSERT INTO pps_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Méxin, janꞌan xruanꞌannta ixi tsandáanta naa nunte tsikengaꞌinta. Inaa sen tsijincheꞌe ixra̱ ko jaꞌanta tsjachanta tsasiinnta ngeꞌe benga sen. ");
INSERT INTO pps_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Ko itsjé ni tjajna samaritano ni ikjui nchra kuindache nchra, kuitikaon na̱ ndo Jesús ixi chronga nchra: “Ndo jiꞌi chronga ndo kain ngeꞌe juintaꞌa saꞌó.” ");
INSERT INTO pps_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Ko hora kuinꞌen na̱ ngeꞌe juincheꞌe ndo, kui̱i̱ na̱ ngajin ndo ko kuinóatée na̱ ngajin ndo ixi tsituꞌe ndo ntiꞌa ngajin na̱. Ko ntiꞌa kuituꞌe ndo yuu nchakon. ");
INSERT INTO pps_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Ko ícha kueya na̱ kuitikaon na̱ ndo ixi kuinꞌen na̱ ngeꞌe nichja ndo. ");
INSERT INTO pps_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Ko ndache na̱ nchra: ―Jai titikaꞌonna, ko ixi jeꞌa jeꞌo ngeꞌe ndachijiana. Kaxon ixi jai janꞌanna kuitikaonna ixi kuinꞌanna ngeꞌe nichja ndo ko nónana ixi jeꞌe ndo nduaxin ndo Cristo ndo, ndo sincheméꞌe jíee kain chujni. ");
INSERT INTO pps_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Yuu nchakon tjumeꞌe, ndo Jesús kuachrjexin ndo nunte Samaria ko sakjui ndo no nunte Galilea. ");
INSERT INTO pps_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","*Xranchi tsindachro ndo Jesús, ninaa ndo chronga chijnie ndo Dio, ni tjajnée ndo xrochóndeꞌe na̱ ndo juasaya. ");
INSERT INTO pps_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","*Nchakon kuiji ndo nunte Galilea, ni ntiꞌa kuayéꞌe na̱ ndo ko kuajon na̱ juasaya ngajin ndo ixi kaxon tsikjin na̱ kia Pascua tjajna Jerusalén, ko bikon na̱ ngeꞌe juincheꞌe ndo kia ntiꞌa. ");
INSERT INTO pps_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","*Tjumeꞌe ikjan ndo Jesús tjajna Caná nunte Galilea, ti no tsijinchekjan ndo inda ixran vino. Ntiꞌa bakeꞌe naa xi tituanꞌan xrée gobierno. Ko kuachónda xi naa chjan niꞌe tjajna Capernaum. ");
INSERT INTO pps_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Ko hora tsikinꞌen xa tsiki̱xi̱n ndo Jesús nunte Judea ko kuiji ndo nunte Galilea, ruéꞌe xa ndo ko kuinóatée xa ngajin ndo ixi itsji ndo ndoꞌa xa ko sinchexrjuenꞌen ndo chjenꞌen xa, ixi ó jiteꞌen xjan. ");
INSERT INTO pps_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Ko ndachro ndo Jesús: ―Jaꞌanta, titikaonꞌanta siá tsikonꞌanta naa ngeꞌe jian sintaꞌa. ");
INSERT INTO pps_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Ko kuinóatée xi ncheꞌe xrée gobierno ko ndachro xa: ―Taka ichjina ixi chjanꞌna ó jiteꞌen xjan. ");
INSERT INTO pps_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Ko juateꞌe ndo Jesús: ―Ikjan ndúya ixi chjanꞌan chao jii xjan jai. Ko xi meꞌe kuitikaon xa ngeꞌe ti ndachro ndo Jesús, ko sakjui xa. ");
INSERT INTO pps_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Ko ikjan xa ndoꞌa xa, ni ncheꞌe xrée xa kuachrje na̱ biketan na̱ xa ngatja chaꞌo, ko ndache na̱ xa: ―Chajanꞌan ó jian jii chán. ");
INSERT INTO pps_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Ko juanchangiꞌe xa na̱ ngixeꞌe hora kuaxi koxruenꞌen chán. Ko chronga na̱: ―Jnajna xranchi hora naa kóndo kuachrjeꞌe chán súa. ");
INSERT INTO pps_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Ko jaña konoꞌe ndotée chán ixi hora ña̱ tsindachro ndo Jesús ixi chjenꞌen xa ó jian jii chán. Ko jeꞌe xa ko kain ni ndoꞌa xa kuitikaon na̱ ndo Jesús. ");
INSERT INTO pps_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Jiꞌi yuxin ngeꞌe jian juincheꞌe ndo Jesús nchakon kui̱xi̱n ndo nunte Judea, ikjan ndo nunte Galilea. ");
INSERT INTO pps_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Tjumeꞌe ni judío bakeꞌe na̱ naa kia ko ndo Jesús ikjan ndo tjajna Jerusalén íjngo. ");
INSERT INTO pps_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Ntiꞌa tjenka nta̱chja ndatinꞌin Nta̱chjeꞌe Kutuchjon jii naa pila inda ngigua hebreo ndatinꞌin Betesda. Ko ngandeꞌe pila meꞌe jii naꞌó tjatuꞌo nchínchín tsikiꞌte na̱. ");
INSERT INTO pps_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Ntiꞌa stetsinga kueya ni niꞌe, ni tikonꞌa, ni juaꞌi itji ko ni juaꞌi nchetengi tutée. Stechónꞌen na̱ tsontengi inda ");
INSERT INTO pps_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","ixi jeꞌa nanaunka xingajin naa ndo ángel tjenka pila meꞌe ko nchetengi ndo inda. Ko ni saꞌó tiji ntiꞌa ko tjingi na̱ inda toxruenxin na̱ ixi ngixeꞌi ichin bachónda na̱. ");
INSERT INTO pps_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Ntiꞌa jii naa xi niꞌe, ó níi ite ko ijní nano niꞌe xa. ");
INSERT INTO pps_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Ko hora bikon ndo Jesús jitsinga xa, konoꞌe ndo ixi ó sée niꞌe xa, ko juanchangiꞌe ndo xa: ―¿Á tjauan tsoxruanꞌan? ");
INSERT INTO pps_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Ko xi niꞌe juatingíexin xa: ―Chondaꞌi ngisen tsingijnana tsjingi inda hora tontengi inda. Ko hora tjaꞌon tsjingi nda, inaa ngisen ícha taka tjingi nda. ");
INSERT INTO pps_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Ko ndachro ndo Jesús: ―Tingatjen, tatsían kaniaꞌa, ko tajia. ");
INSERT INTO pps_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Ko tuinxin koxruenꞌen xa, ko juatsiꞌin xa kanieꞌe xa ko chao ikjui xa. Ko meꞌe konꞌen nchakon tjokéꞌe ni judío. ");
INSERT INTO pps_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Tjumeꞌe ni judío ndache na̱ xi koxruenꞌen: ―Jai nchakon tjokéꞌeni ko xroꞌan juachaxin jii tsama kaniaꞌa. ");
INSERT INTO pps_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Ko ndachro xa: ―Xi juinchexruanna ndachijina xa tatsían kaniaꞌa ko tajia. ");
INSERT INTO pps_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Ko juanchangiꞌe na̱ xa: ―¿Ngisen kuetuanꞌan tsatsian kaniaꞌa ko ndachro tsajia? ");
INSERT INTO pps_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Ko xi tsikoxruenꞌen noeꞌa xa ngisen juinchexruenꞌen xa ixi ntiꞌa jii kueya na̱, ko ndo Jesús íkonoxinꞌa ndo chrikenꞌen na̱ ntiꞌa. ");
INSERT INTO pps_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Tjumeꞌe ndo Jesús kuetan ndo xa ngaxinꞌin niꞌngo ijié ko ndache ndo xa: ―Tsjeꞌé jai ó koxruanꞌan ko íncheꞌa ti ndakoꞌa, ba ícha tangi tsonꞌan. ");
INSERT INTO pps_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Tjumeꞌe sakjui xa, ko ndache xa ni judío ixi ndo Jesús juinchexruenꞌen ndo xa. ");
INSERT INTO pps_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Méxin ni judío kuaxi na̱ ruéꞌe na̱ ndo Jesús ko tjaun na̱ tsóña na̱ ndo ixi kuancheꞌe ndo kain jiꞌi nchakon tjokéꞌe na̱. ");
INSERT INTO pps_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Ko ndo Jesús ndache ndo na̱: ―Ndotána kain nchakon ncheꞌe ndo ixra̱, ko janꞌan kaxon jaña ntaꞌa ixra̱. ");
INSERT INTO pps_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Méxin, jaña ni judío ícha tjaun na̱ tsóña na̱ ndo Jesús ixi titikaonꞌa ndo nchakon tjokéꞌe na̱ ko ixi kaxon ndachro ndo ixi jeꞌe ndo ko ndo Dio naxrajeꞌo sen, ko ndachro ndo ndotée ndo, ndo Dio. ");
INSERT INTO pps_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Tjumeꞌe ndo Jesús ndache ndo na̱: ―Naa ngeꞌe nduaxin ntatjunta ixi Chjenꞌen ndo Dio juaꞌi sincheꞌe ndo naa ngeꞌe jeꞌo jeꞌe ndo. Jeꞌo ncheꞌe ndo ngeꞌe tikon ndo ncheꞌe Ndotée ndo. Kain ngeꞌe ncheꞌe ndotée ndo kao chjenꞌen ndo ncheꞌe xjan jaña. ");
INSERT INTO pps_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Ko Ndotána tjueꞌe ndo Chjenꞌen ndo, ko tjakoꞌe ndo chjenꞌen ndo kain ngeꞌe ncheꞌe ndo, ko xratsjako ndo ngeꞌe ícha ijié ko jaꞌanta xroxronkanta ixi tsikonnta meꞌe. ");
INSERT INTO pps_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Xranchi Ndotána nchexechón ndo ni tsikenꞌen ko tajon ndo juachaxin tsechón na̱ íjngo. Jaña kaxon Chjenꞌen ndo chao tsajon xjan juachaxin tsechón kain ni tjaun jeꞌe xjan. ");
INSERT INTO pps_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Ko Ndotána xruanꞌan ngisen tjankataꞌa ndo ijie̱ ixi kuajon ndo juachaxin ngajin chjenꞌen ndo, ");
INSERT INTO pps_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","ixi kain na̱ tsajon na̱ juasaya ngajin chjenꞌen ndo xranchi juasaya tayéꞌe Ndotána. Ngisen tajonꞌa juasaya ngajin chjenꞌen ndo kaxon tajonꞌa sen juasaya ngajin Ndotée ndo, ndo xruanꞌan ndo Cristo. ");
INSERT INTO pps_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","’Nduaxin ngeꞌe ntatjunta: Ngisen tinꞌen ngeꞌe ntatjunta ko titikaon Ndo xruanꞌanna, chónda sen juachaxin tsechón sen kain nchakon ko tangiꞌa tsonꞌen sen, ixi ó kuatsinga ti tsenꞌen sen ko jai tsechón sen kain nchakon. ");
INSERT INTO pps_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Nduaxin ntatjunta ixi ó tsi̱i̱ hora, ko jai hora meꞌe, ni tsikenꞌen tsinꞌen na̱ xronichja Chjenꞌen ndo Dio. Ko sen tsitikaon ndo tsechón sen. ");
INSERT INTO pps_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Ixi Ndotána chao tsajon ndo juachaxin tsechón na̱ ko kaxon tsikajon ndo juachaxin ngajin Chjenꞌen ndo sincheꞌe xjan jaña, ");
INSERT INTO pps_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","ko kaxon tsikajon ndo juachaxin ngajin Chjenꞌen ndo sinchéña xjan ijie̱ ixi jeꞌe xjan Chjenꞌen ndo Dio, xjan jongíꞌe xranchi chujni. ");
INSERT INTO pps_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Xrakonꞌanta ixi ti ngeꞌe ntatjunta. Ixi tsiji hora ti kain ni tsikenꞌen, tsinꞌen na̱ xronichja xjan. ");
INSERT INTO pps_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Ko tsachrjexin na̱ ti no stexrabaa na̱. Ko ni ndako juincheꞌe, xroxechón na̱ ixi tsechón na̱ kain nchakon. Ko ni ndakoꞌa juincheꞌe xroxechón na̱ ko tangi tsikaon na̱ ti tsoñeꞌe na̱ ijie̱. ");
INSERT INTO pps_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","’Janꞌan juaꞌi sintaꞌa naa ngeꞌe janꞌon. Janꞌan ntáña ijie̱ xranchi tituanna. Ko ijie̱ ntáña, ndako ntáña ijie̱ ko ntaꞌi ngeꞌe tjaꞌon janꞌan. Naꞌi. Ntaꞌa ngeꞌe tjaun Ndotána, ndo xruanꞌanna. ");
INSERT INTO pps_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Ko siá janꞌon nichjaxin ixi najanꞌan, ti ndachrja̱n tjinteꞌa. ");
INSERT INTO pps_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Ko jii inaa ngisen nichjaxinna ko ngeꞌe ndachro sen meꞌe ixi najanꞌan, tjintee. ");
INSERT INTO pps_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","*Jaꞌanta xruanꞌannta ngisen ikjui juanchangiꞌe ndo Juan, ko ngeꞌe juatingíexin ndo ixi najanꞌan, nduaxin meꞌe. ");
INSERT INTO pps_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Ko janꞌan chuntiaꞌi ngeꞌe xrondachro xrojan ngisen ixi janꞌan. Ko jeꞌo ndachrja̱n jiꞌi ixi jaꞌanta xrochondanta juachaxin tsechonnta kain nchakon. ");
INSERT INTO pps_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Ndo Juan bakeꞌe ndo xranchi naa xroꞌi jiche ko tingasáña, ko jaꞌanta juaxruxin bakeꞌenta ixi xroꞌi meꞌe, maski tsjéꞌa nchakon. ");
INSERT INTO pps_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","’Ko janꞌan chónda naa ngeꞌe ícha tjintee tjakoxin ixi najanꞌan, ixi ngeꞌe tsindachro ndo Juan. Ixra̱ ntaꞌa janꞌan, ixra̱ naxreꞌo tituanna Ndotána sintaꞌa, ña̱ tjakoxin ixi nduaxin Ndotána tsixruanꞌanna ndo. ");
INSERT INTO pps_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","*Kaxon Ndotána, ndo xruanꞌanna, tjakoxin ndo ixi najanꞌan. Ko jaꞌanta naiꞌa kuinꞌennta nichja ndo ko naiꞌa bikonta ndo. ");
INSERT INTO pps_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Ko chijnie ndo xra jeꞌa jii ngaya asáanta ixi jaꞌanta xratsitikaonꞌanta ngisen Ndotána, ndo tsixruanꞌanna. ");
INSERT INTO pps_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Jaꞌanta jian nchekuanxinnta xroon chijnie ndo Dio ixi chonꞌénnta tsayeꞌenta juachaxin tsechonnta kain nchakon. Ko xroon meꞌe nichja ixi najanꞌan. ");
INSERT INTO pps_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Ko jaꞌanta tjaunꞌanta tonchjiñeꞌenta tjenkana ixi tsayeꞌenta juachaxin meꞌe. ");
INSERT INTO pps_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","’Janꞌan tayéꞌa juasaya tajon chujni. ");
INSERT INTO pps_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Ko janꞌan chuxinnta ko nóna ixi tjaunꞌanta ndo Dio. ");
INSERT INTO pps_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Janꞌan juiꞌi ixi Ndotána xruanꞌanna ndo ko jaꞌanta titikaonꞌantana. Ko siá ti̱i̱ naa ngisen jeꞌo nichja ngeꞌe chónda ngaya aséen na̱, ni meꞌe titikaonnta. ");
INSERT INTO pps_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","¿Xranchi tsitikaonnta, siá tsayeꞌenta juasaya tajon chujni, ko tjéꞌanta ti ngeꞌe jian ti̱ꞌxi̱n ngajin ndo Dio, ndo naáko Dio? ");
INSERT INTO pps_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Xraxaonꞌanta ixi janꞌan tsjankataꞌanta ijie̱ ngajinxin Ndotána. Naꞌi. Ndo tsjankataꞌanta ijie̱ meꞌe ndo Moisés ixi chuntianta ngajin ndo. ");
INSERT INTO pps_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Ixi siá xrokuitikaonnta ngeꞌe tsindachro ndo Moisés, kaxon xrokuitikaonnta ixi ndo Moisés ikjin ndo ixi najanꞌan. ");
INSERT INTO pps_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Ko siá tsitikaonꞌanta ngeꞌe tsikjin ndo, ¿xranchi tsitikaonnta ngeꞌe ntatjunta? ");
INSERT INTO pps_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Tjumeꞌe sakjui ndo Jesús kuatu ndo ndachaon Galilea, inda meꞌe ndatinꞌin Tiberias kaxon. ");
INSERT INTO pps_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Ko kueya chujni ruéꞌe na̱ ixi bikon na̱ ixra̱ ijié juincheꞌe ndo ti juinchexruenꞌen ndo ni niꞌe. ");
INSERT INTO pps_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Ko ndo Jesús kuajinꞌin ndo naa ijna̱ ko ntiꞌa bakeꞌe ndo nunte kao sen teyuu chrikao ndo. ");
INSERT INTO pps_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Ko ó jitonchjiñeꞌe nchakon tsi̱i̱ kia pascua, kiée ni judío. ");
INSERT INTO pps_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Ko bikon ndo Jesús ixi kueya chujni kuajinꞌin na̱ jna̱, jiruéꞌe na̱ ndo ko juanchangiꞌe ndo ndo Felipe: ―¿No tseꞌnana ngeꞌe sine kain chujni? ");
INSERT INTO pps_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Jaña ndachro ndo ixi tsinꞌen ndo ngeꞌe xichro ndo Felipe ixi ndo Jesús ó noꞌe ndo ngeꞌe sincheꞌe ndo. ");
INSERT INTO pps_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Ko juateꞌe ndo Felipe, ndachro ndo: ―Maski doscientos tomi xrochondana xrokuenaxinna nutja xraxrokuitjaꞌi xrojuine ngujngu chujni tuꞌo nutja. ");
INSERT INTO pps_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Ko ndo Andrés, naa sen chrikao ndo Jesús, ndosaué ndo Simón Pedro, ndachro ndo: ");
INSERT INTO pps_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","―Ntiꞌi jii naa chjan chónda xjan naꞌó nutja tsikoña noa cebada ko chónda xjan yuu kuchee̱. ¿Á tsitja jiꞌi, ixi kueya chujni jii? ");
INSERT INTO pps_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Ko ndachro ndo Jesús: ―Tetuenꞌenta na̱ tsakeꞌe na̱ nunte. Ti jii kayua ntiꞌa, bakeꞌe na̱ nunte, xranchi naꞌó mil chujni xi. ");
INSERT INTO pps_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Ko ndo Jesús kua ndo nutja ko kuajon ndo juasie ndo ngajin ndo Dio, ko tjumeꞌe kuajon ndo nio ngajin sen teyuu chrikao ndo. Ko jeꞌe sen konchjeya sen nio, kuayéꞌe kain ni ste ntiꞌa. Jaña kaxon konchjeya sen kuchee̱. Ko kain na̱ juine na̱ kain ti tjaun na̱. ");
INSERT INTO pps_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Juexin juine na̱, tjumeꞌe kuetuenꞌen ndo Jesús sen teyuu chrikao ndo, ndachro ndo: ―Tjaꞌonta ngeꞌe tsixeꞌe ixi xroꞌan ngeꞌe tsitjáña. ");
INSERT INTO pps_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Ko jaña juincheꞌe sen ko juinchekaon sen teyuu ntaxra nutja tutuꞌo ti naꞌó nutja tsikoña noa cebada tsijinchexeꞌe̱ na̱ hora juexin juine na̱. ");
INSERT INTO pps_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Ko ni juine nutja bikon na̱ ti ixra̱ ijié juincheꞌe ndo Jesús ko ndachro na̱: ―Ndo meꞌe nduaxin ndo tsixruaꞌan ndo Dio tsi̱i̱ nunte xasintajni. ");
INSERT INTO pps_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Ko ndo Jesús konoꞌe ndo ixi tjaun na̱ xraxrobikao na̱ ndo xrojuinchéña na̱ ndo rey ixi xrokuetuanꞌan ndo. Ko jeꞌe ndo tjaunꞌa ndo jiꞌi ko jeꞌo ndo sakjui ndo ntajie íjngo, ko ntiꞌa bakeꞌe ndo. ");
INSERT INTO pps_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Tjumeꞌe ó kóndo sen teyuu chrikao ndo Jesús xingajinxin sen ijna̱ sakjui sen ngandeꞌe inda, ");
INSERT INTO pps_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","ko kuajinꞌin sen naa nta̱barco ko kuaxi sen kuatu sen inda satsji sen tjajna Capernaum. Ó naxixeꞌe ko xrakjanꞌi ndo Jesús. ");
INSERT INTO pps_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Tjumeꞌe kuaxi kui̱i̱ chrinto soji ko kuaxi jamangitaon inda. ");
INSERT INTO pps_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Ko chao sakjui sen xranchi naꞌó o̱ ikjaon kilómetro ko tuinxin bikon sen ndo Jesús, jitonchjiñeꞌe ndo tjenka nta̱barco, xranchi yaa ndo chaꞌo jitji ndo ngataon inda. Jaña bikon sen ko tsango xronka sen. ");
INSERT INTO pps_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Ko ndo Jesús ndachro ndo: ―Janꞌan juiꞌi. Xronkaꞌinta. ");
INSERT INTO pps_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Ko tsango juaxruxin kuintee sen ixi kuajinꞌin ndo nta̱barco. Ko tuinxin kuiji sen ti no xrokuiji sen. ");
INSERT INTO pps_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Ko nchakon ndúyaxin, ni kuituꞌe ti ndachaon konoꞌe na̱ ixi naakuaxon nta̱barco bakeꞌe ntiꞌa, ko noꞌe na̱ ixi ndo Jesús tsikikaoꞌa sen ndo ixi bikon na̱ ixi jeꞌo sen teyuu chrikao ndo, satsikji sen. ");
INSERT INTO pps_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Ko tjumeꞌe kui̱i̱ kaxin nta̱barco ti̱ꞌxi̱n tjajna Tiberias tjenka ti no juinexin na̱ nutja, ti kuajonxin ndo Jesús juasie ndo ngajin ndo Dio. ");
INSERT INTO pps_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Ko nchakon bikon na̱ ixi koꞌa ndo Jesús ko kaxon koꞌa sen teyuu chrikao ndo, tjumeꞌe jeꞌe na̱ kuajinꞌin na̱ nta̱barco ko sakjui na̱ tjajna Capernaum ko bijée na̱ ndo Jesús. ");
INSERT INTO pps_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Tjumeꞌe kuiji na̱ tuenxin inda ko bikon na̱ ndo Jesús ko juanchangiꞌe na̱ ndo: ―Maestro, ¿ngisa juiꞌia ntiꞌi? ");
INSERT INTO pps_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Ko juateꞌe ndo Jesús, ndachro ndo: ―Ó nóna ixi jaꞌanta tjéenta na̱ ixi juintenta nutja ko kaonnta, ko jeꞌa ixi kuienxinnta ti ixra̱ ijié juintaꞌa. ");
INSERT INTO pps_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Taꞌinta juachjaon ixi ngeꞌe sintenta taka tsjexin. Ncheꞌenta ixra̱ ixi ngeꞌe ti sintenta tsjexinꞌa ixi tsayeꞌenta juachaxin tsechonnta kain nchakon. Meꞌe tajon Chjenꞌen ndo Dio, xjan jongíꞌe xranchi chujni, ixi Ndotée ndo tjako ndo ixi Chjenꞌen ndo chónda xjan juachaxin. ");
INSERT INTO pps_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Ko juanchangiꞌe na̱ ndo: ―¿Xranchi sintaꞌana ixi tsitikaꞌonna xranchi tjaun ndo Dio? ");
INSERT INTO pps_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Ko juateꞌe ndo Jesús, ndachro ndo: ―Ndo Dio tjaun ndo ixi tsitikaonnta ngisen tsixruaꞌan ndo. ");
INSERT INTO pps_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Ko juanchangiꞌe na̱ ndo: ―¿Ngeꞌe tjakoxian ixi tsikonna ko chao tsitikaꞌonna? ¿Ngeꞌe ixra̱ ncheꞌe? ");
INSERT INTO pps_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Sen tsikachrjenixinna saꞌó juine sen maná ikjan nutja nchakon bakeꞌe sen ntajie, méxin, jaña chijnie ndo Dio tsikjin na̱ ndachro: “Kuajon ndo ngeꞌe juine na̱, meꞌe nutja kui̱xi̱n ngajní.” ");
INSERT INTO pps_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Ko juateꞌe ndo Jesús, ndachro ndo: ―Naa ngeꞌe nduaxin ntatjunta, jeꞌa ndo Moisés kuajon maná ikjan nutja xingajinxin ngajní. Ndotána tajon ndo nutja nduaxin, nutja xingajinxin ngajní. ");
INSERT INTO pps_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Nutja tajon ndo Dio, meꞌe ndo xingajinxin ngajní ko jeꞌe ndo chjée ndo chujni nunte xasintajni juachaxin tsechón na̱ kain nchakon. ");
INSERT INTO pps_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Ko ndachro na̱: ―Ncháina, kain nchakon chjána̱na nutja meꞌe. ");
INSERT INTO pps_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Ko ndachro ndo Jesús: ―Janꞌan meꞌe nutja tajon juachaxin tsechón chujni. Sen tonchjiñeꞌe ngajin janꞌan ítsenꞌa sen jinta, ko sen tsitikaonna, ítsenꞌa sen inda. ");
INSERT INTO pps_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Ko xranchi ntatjunta saꞌó, maski ó bikontana, xratitikaonꞌanta. ");
INSERT INTO pps_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Ko kain chujni chjána Ndotána tsonchjiñeꞌe na̱ ngajin. Ko kain ni tonchjiñeꞌe ngajin, janꞌan tsengíꞌa na̱ satsji na̱. ");
INSERT INTO pps_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Janꞌan juixin ngajní ko jeꞌa ngeꞌe tjaꞌon sintaꞌa. Juiꞌi ixi sintaꞌa ixra̱ tjaun ndo tsixruanꞌanna. ");
INSERT INTO pps_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ko Ndotána tsixruanꞌanna, meꞌe tjaun ndo ixi xroꞌan chujni chjána ndo tsitjáña, ixi tjaun ndo janꞌan sintaxechón kain na̱ nchakon tsjexixin. ");
INSERT INTO pps_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Ngisen tsixruanꞌanna tjaun ixi kain ni tsikon janꞌan, Chjenꞌen ndo Dio, ko tsitikaonna na̱, ni meꞌe tsayéꞌe na̱ juachaxin tsechón na̱ kain nchakon. Tjumeꞌe janꞌan sintaxechón na̱ nchakon tsjexixin. ");
INSERT INTO pps_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Ko ni judío juangíxin na̱ ndakoꞌa nichjeꞌe na̱ ndo Jesús ixi tsindachro ndo jeꞌe ndo nutja xingajinxin ngajní. ");
INSERT INTO pps_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Ko ndachro na̱: ―¿Á jeꞌa xiꞌi xi Jesús, ndotée xa ndatinꞌin José? Chuxinna ndotée ko janée xa. ¿Méxin, sonda ndachro xa ixi ngajní tsixingajinxin xa? ");
INSERT INTO pps_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Ko juateꞌe ndo Jesús, ndachro ndo: ―Ínichjangiꞌanta. ");
INSERT INTO pps_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Xroꞌan chujni xrokonchjiñeꞌe ti ritjén janꞌan siá xrokuajonꞌa juachaxin Ndotána. Ko sen tonchjiñeꞌe ti ritjén, janꞌan sintaxechón sen nchakon tsjexixin. ");
INSERT INTO pps_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Sen kuachronga chijnie ndo Dio ó saꞌó tsikjin sen xroon ndachro: “Ndo Dio sinchekuenꞌen ndo kain chujni.” Méxin kain sen tsikinꞌen ti nichja Ndotána ko juinchekuenꞌen ndo sen jitonchjiñeꞌe sen ti ritjén janꞌan. ");
INSERT INTO pps_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","’Xroꞌan chujni tsikikon Ndotána. Jeꞌo ngisen kui̱xi̱n ti jii ndo Dio tsikikon ndo. ");
INSERT INTO pps_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Nduaxin ngeꞌe ndachrja̱n ixi sen titikaonna ó chónda sen juachaxin tsechón sen kain nchakon. ");
INSERT INTO pps_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Janꞌan nutja tajon juachaxin tsechón chujni. ");
INSERT INTO pps_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Chujni kuachrjenixinnta saꞌó juine na̱ maná ikjan nutja, nchakon bakeꞌe na̱ ntajie, ko maski juine na̱ tjumeꞌe kuenꞌen na̱ ko kuitjáña na̱. ");
INSERT INTO pps_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Ko ti nichja janꞌan meꞌe nutja xingajinxin ngajní, ko sen sine nutja meꞌe tsenꞌa sen. ");
INSERT INTO pps_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Janꞌan nutja jichón xingajinxin ngajní. Ko sen sine nutja, tsechón sen kain nchakon. Nutja tsajon janꞌan ntauꞌna meꞌe, ko janꞌan tsajon nutja meꞌe ixi chujni nunte xasintajni xrochónda sen juachaxin tsechón sen kain nchakon. ");
INSERT INTO pps_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Ko ni judío koñao na̱, tjao kichuu na̱, ndachro na̱: ―¿Xranchi xrokuajon xiꞌi ntauꞌe xa xrojuinena? ");
INSERT INTO pps_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Ko juateꞌe ndo Jesús, ndachro ndo: ―Janꞌan ndachrja̱n ixi siá sineꞌanta ntauꞌe Chjenꞌen ndo Dio, xjan jongíꞌe xranchi chujni, ko siá tsiꞌanta jnié xjan, xrochondaꞌinta juachaxin tsechonnta kain nchakon. ");
INSERT INTO pps_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Ngisen sine ntauꞌna ko tsiꞌi jnina, sen meꞌe xrochónda sen juachaxin tsechón sen kain nchakon ko janꞌan sintaxechón sen nchakon tsjexixin. ");
INSERT INTO pps_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Ixi ntauꞌna ngeꞌe nduaxin sine chujni, ko jnina meꞌe nduaxin tsiꞌi chujni. ");
INSERT INTO pps_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Sen ine ntauꞌna ko tiꞌi jnina stenii sen janꞌan ko janꞌan riníi jeꞌe sen. ");
INSERT INTO pps_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Ndotána tsixruanꞌanna ndo janꞌan, ndo meꞌe jichón ndo, ko janꞌan richónxin ixi jeꞌe ndo. Ko sen sine ntauꞌna, sen meꞌe tsechónxin sen ixi janꞌan. ");
INSERT INTO pps_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Méxin, rinichja ixi nutja xingajinxin ngajní, nutja meꞌe jeꞌa xranchi maná juine ni tsikachrjenixinnta saꞌó ixi jeꞌe na̱, maski juine na̱ maná, kuenꞌen na̱. Ko siá sintenta nutja xingajinxin ngajní, jaꞌanta tsayeꞌenta juachaxin tsechonnta kain nchakon. ");
INSERT INTO pps_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Kain jiꞌi juinchekuenꞌen ndo ni tsixraꞌo niꞌngo Israel tjajna Capernaum. ");
INSERT INTO pps_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Ko nchakon kuinꞌen na̱ ngeꞌe juinchekuenꞌen ndo Jesús na̱, tjumeꞌe itsjé sen chrikao ndo ndachro sen: ―Tsango tangi ngeꞌe chronga ndo. ¿Ngisen xrokuitikaon jiꞌi? ");
INSERT INTO pps_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Ko konoꞌe ndo Jesús ixi jaña ndachro sen kuienxinꞌa sen ngeꞌe tsindachro ndo ko juanchangiꞌe ndo sen: ―¿Á kaxon jaꞌanta tjaunꞌanta tsinꞌennta jiꞌi? ");
INSERT INTO pps_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","¿Xranchi xrokonꞌen siá tsikonnta ixi Chjenꞌen ndo Dio, xjan jongíꞌe xranchi chujni, satsji xjan íjngo ti no tsiki̱ꞌxi̱n xjan? ");
INSERT INTO pps_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Espíritue ndo Dio tajon juachaxin tsechón chujni kain nchakon, ko ntauꞌe chujni xroꞌan tjintee. Ko ngeꞌe ntatjunta meꞌe kondee Espíritue ndo Dio ko chónda juachaxin tsechónxin chujni. ");
INSERT INTO pps_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Ko kaxinnta xratitikaonꞌanta. Jaña ichro ndo ixi xrangíxixín ó noꞌe ndo ngisen tsitikaonꞌa ndo ko noꞌe ndo ngisen sinchekji ndo. ");
INSERT INTO pps_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Méxin, ndachro ndo: ―Jaña ntatjunta ixi xroꞌan chujni tsonchjiñeꞌe ti ritjén janꞌan siá Ndotána tsajonꞌa ndo juachaxin. ");
INSERT INTO pps_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Ko juexin jiꞌi, kueya sen bakajikao ndo Jesús tuinxin kuintuꞌe sen ndo, rueꞌa sen ndo. ");
INSERT INTO pps_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Tjumeꞌe juanchangiꞌe ndo sen teyuu chrikao ndo, ndachro ndo: ―¿Á kaxon jaꞌanta tjaunnta satsjinta? ");
INSERT INTO pps_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","*Ko juateꞌe ndo Simón Pedro: ―Ncháina, ¿ti no itsjina? Chijni nichja jaꞌanta tajon juachaxin tsechónna kain nchakon ");
INSERT INTO pps_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","ko titikaꞌonna ko nónana ixi nduaxin jaꞌanta ndo Cristo, Chjenꞌen ndo Dio jichón. ");
INSERT INTO pps_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Ko juateꞌe ndo Jesús, ndachro ndo: ―Janꞌan kuinchaꞌa kainnta teyuunta, ko naánta ntiꞌi xrokjannta naa chujni ñaꞌi. ");
INSERT INTO pps_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Ti ndachro ndo Jesús xrondachro ixi xi Judas Iscariote, ndotée xa ndatinꞌin Simón. Xi Judas naa teyuu sen kuincheꞌe ndo, ko xi meꞌe sinchekji xa ndo Jesús. ");
INSERT INTO pps_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Tjumeꞌe ndo Jesús kuaji ndo nunte Galilea ixi juaꞌi tsaji ndo nunte Judea ixi ni judío tjaun na̱ naatsóñaxón na̱ ndo. ");
INSERT INTO pps_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Ko ó kui̱i̱ nchakon kia, kiée ni judío nchéña na̱ kueya nchia nchínchín, ");
INSERT INTO pps_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","ko sen kichuu ndo Jesús ndache sen ndo: ―Tituaꞌia ntiꞌi. Satjia nunte Judea ixi kaxon sen ruaꞌa ntiꞌa tsikon sen ixra̱ ijié ncheꞌe. ");
INSERT INTO pps_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Ixi siá naa chujni tjaun ixi chujni xrochuxin na̱ sen, sen meꞌe jeꞌa imao sincheꞌe sen ixra̱. Méxin, siá nduaxin ncheꞌe ixra̱ ijié, jeꞌa imao xrojuincheꞌe meꞌe. Tsikon kain chujni nunte xasintajni. ");
INSERT INTO pps_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Jaña ndachro sen kichuu ndo Jesús ixi kaxon jeꞌe sen titikaonꞌa sen ndo. ");
INSERT INTO pps_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Ko juatingíexin ndo Jesús: ―Xratitjáꞌi hora sintaꞌa ixra̱ ijié. Ko jaꞌanta ngixeꞌi hora chao sincheꞌenta ngeꞌe. ");
INSERT INTO pps_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Chujni nunte xasintajni juaꞌi xroningakonꞌannta na̱. Janꞌan tsango ningakonna na̱ ixi janꞌan ntatjan na̱ ixi jeꞌe na̱ jeꞌa jian ngeꞌe ncheꞌe na̱. ");
INSERT INTO pps_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Jaꞌanta itjinta kia. Janꞌan tsjiꞌa ixi xratijiꞌa orána. ");
INSERT INTO pps_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Jaña ndachro ndo, ko kuituꞌe ndo nunte Galilea. ");
INSERT INTO pps_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Ko juexin satsikji sen kichuu ndo Jesús, tjumeꞌe jeꞌe ndo kaxon ikjui ndo kia, ko konoxinꞌa ndo ixi tjaun ndo xroꞌan ngisen xrobikon ndo. ");
INSERT INTO pps_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Ko ni judío tjée na̱ ndo ti kia ko ndachro na̱: ―¿No jii xi meꞌe? ");
INSERT INTO pps_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Ko kueya ni ste ntiꞌa stetjao na̱ kondee ndo Jesús. Kaxin na̱ ndachro na̱: “Jian xi ña̱”; ko ikaxin na̱ ndachro na̱: “Jeꞌa jian xa ixi ncheyeꞌe xa chujni.” ");
INSERT INTO pps_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Ko xroꞌan ngisen nichja kondee ndo ícha, ixi xrakonꞌen na̱ ni judío. ");
INSERT INTO pps_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Tjumeꞌe ó ngusine kia kuixinꞌin ndo Jesús niꞌngo ijié ko juangíxin ndo juinchekuenꞌen ndo na̱. ");
INSERT INTO pps_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Ko ni judío xronka na̱, tsjeꞌe na̱ ndo, ko ndachro na̱: ―¿Xranchi tsango noꞌe xi jiꞌi kain ngeꞌe ixi xroꞌan ngisen juakoꞌe xa? ");
INSERT INTO pps_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Ko juateꞌe ndo Jesús, ndachro ndo: ―Ngeꞌe ntakuanꞌan chujni jeꞌa ngeꞌe tjaꞌon, ti ntakuanꞌan na̱ meꞌe kondee ngisen tsixruanꞌanna juiꞌi. ");
INSERT INTO pps_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Siá xrojannta tjaunnta tsitikaonnta ngeꞌe tjaun ndo Dio, meꞌe tsonoꞌanta á nduaxin ixi ndo Dio tjako o̱ á jeꞌo ngeꞌe xraxaꞌon. ");
INSERT INTO pps_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Ko ngisen nichja ngeꞌe tjaun, jeꞌo nichja na̱ ixi tjaun na̱ ixi ikaxin na̱ tsajon na̱ juasaya ngajin jeꞌe na̱. Ko ngisen tjaun ixi ngisen tsixruaꞌan na̱ tsayéꞌe juasaya, ni meꞌe tjako ngeꞌe nduaxin ko ncheyaꞌi na̱. ");
INSERT INTO pps_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","’¿Á jeꞌa ndo Moisés tjáanta ndo ley chijnie ndo Dio? Ko ninaánta kuitikaonnta ngeꞌe tsikjin ndo. Méxin, ¿sonda tjaunnta tsonꞌintana? ");
INSERT INTO pps_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Ko jeꞌe na̱ juateꞌe na̱: ―Jaꞌa chonda naa espíritue Xixronꞌanxrée. ¿Ngisen tjaun tsóñaxion? ");
INSERT INTO pps_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Ko ndachro ndo Jesús: ―Naáko ngeꞌe juintaꞌa nchakon tjokéꞌe na̱ ko xronkanta. ");
INSERT INTO pps_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Ko ndo Moisés tsiketuanꞌan ndo ixi chjanꞌanta, xjan xi, tsaa xjan chjiꞌe, (ko jeꞌa ndo Moisés kuaxi ndo juinchekuenꞌen ndo na̱ jiꞌi, sen tsikachrjenixinnta kuaxi sen juincheꞌe sen). Jaña jaꞌanta chje̱ꞌénta xjan chjiꞌe, maski nchakon tjokaꞌanta. ");
INSERT INTO pps_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","*Jaꞌanta tjaunnta tsitikaonnta ngeꞌe tsiketuanꞌan ndo Moisés, méxin, chje̱ꞌénta ichjan chjiꞌe xjan nchakon tjokaꞌanta, ko, ¿sonda toñaonta ixi juintaxruanꞌan naa chujni nchakon meꞌe? ");
INSERT INTO pps_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Tjankataꞌinta ijie̱ ixi jeꞌo ngeꞌe tikonxinnta ikonnta. Saꞌó xraxaonnta ngeꞌe jian tjaun ndo Dio. ");
INSERT INTO pps_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Tjumeꞌe kaxin ni tjajna Jerusalén kuaxi na̱ juintejao kichuu na̱, ko juanchangi na̱: ―¿Á jeꞌa xi jiꞌi tjée na̱ tsóña na̱ xa? ");
INSERT INTO pps_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Ko jai jinichja xa ngajinxin ikon kain na̱ ko xroꞌan ngisen ndachro ngeꞌe. ¿Á titikaon ni tituanꞌan ixi xi jiꞌi nduaxin ndo Cristo xa? ");
INSERT INTO pps_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Ko jai̱na noi̱na no tsiki̱ꞌxi̱n xa. Ko nchakon tsi̱i̱ ndo Cristo, xroꞌan ngisen tsonoꞌe no tsi̱ꞌxi̱n ndo. ");
INSERT INTO pps_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Ko ndo Jesús juinchekuenꞌen ndo na̱ ti niꞌngo ko kuinꞌen ndo jaña juao na̱, ko séen nichja ndo, ndachro ndo: ―Nduaxin chuxinntana, ko noꞌanta no juixin. Ko jeꞌa juiꞌi ixi janꞌan tjaꞌon. Janꞌan juiꞌi ixi xruanꞌanna ndo nduaxin ncheꞌe ngeꞌe, ko jaꞌanta chuxinꞌanta ndo. ");
INSERT INTO pps_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Janꞌan chuxin ndo ixi ntiꞌa juixin ti jii ndo, ko jeꞌe ndo xruanꞌanna ndo. ");
INSERT INTO pps_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Tjumeꞌe tjaun na̱ xrotsé na̱ ndo, xroxraxinꞌin na̱ ndo ndoꞌachjiso, ko xroꞌan ngisen itsé ndo ixi xrakuajonꞌa ndo Dio juachaxin sincheꞌe na̱ meꞌe. ");
INSERT INTO pps_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Ko kueya na̱ kuitikaon na̱ ndo ko ndachro na̱: ―Hora tsi̱i̱ ndo Cristo, ¿á ícha ijié ngeꞌe sincheꞌe ndo, ixi xi jiꞌi? ");
INSERT INTO pps_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Tjumeꞌe ni fariseo kuinꞌen na̱ ngeꞌe ndachro na̱ ixi ndo Jesús, ko jeꞌe na̱ ko xitaana tetuanꞌan kuetuenꞌen na̱ kaxin ni policía ncheꞌe ixra̱ niꞌngo xrotsé na̱ ndo Jesús xroxraxinꞌin na̱ ndo ndoꞌachjiso. ");
INSERT INTO pps_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Méxin, ndachro ndo Jesús: ―Tsakeꞌe ngajinnta kaxin nchakon ko tjumeꞌe xrokjanna ngajin ngisen tsixruanꞌanna. ");
INSERT INTO pps_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Jaꞌanta tsjéentana ko tsinchiiꞌantana ixi juaꞌi itsjinta ti no tsakeꞌe janꞌan. ");
INSERT INTO pps_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Ko ni judío juangíxin na̱ juanchangiꞌe kichuu na̱: ―¿No satsji xa ixi juaꞌi tsitjana xa? ¿Á tsji xa ngajin ni judío stekjenꞌen ngajin ni nichja ngigua griego ixi sinchekuenꞌen xa na̱ ntiꞌa? ");
INSERT INTO pps_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","¿Ngeꞌe xrondachro ti ndachro xa ixi tsjéena xa ko tsitjaꞌina xa ko juaꞌi itsjina ti no tsakeꞌe xa? ");
INSERT INTO pps_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Nchakon jitjexin kia, meꞌe nchakon ijié, bingatjen ndo Jesús, ko séen nichja ndo: ―Siá xrojan ngisen kuenꞌen inda tonchjiñeꞌenta ngajin janꞌan ko tinꞌinnta inda. ");
INSERT INTO pps_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Xranchi ndachro xroon Chijnie ndo Dio, ngisen titikaonna, sen meꞌe ngaya aséen sen tsinga naa ndajitinga jichón. ");
INSERT INTO pps_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Jaña ndachro ndo Jesús ixi sen titikaon ndo tsayéꞌe sen Espíritue ndo Dio. Ixi xratiꞌa Espíritue ndo ko ndo Jesús xrasatjiꞌa ndo ngajní. ");
INSERT INTO pps_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Ko kaxin na̱, nchakon kuinꞌen na̱ ngeꞌe ndachro ndo Jesús, ndachro na̱: ―Á nduaxin xi jiꞌi xi profeta xrokui̱i̱. ");
INSERT INTO pps_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Ko ikaxin na̱ ndachro na̱: ―Xi jiꞌi ndo Cristo. Ko ikaxin na̱ ndachro na̱: ―¿Xranchi xrokui̱ꞌxi̱n nunte Galilea ndo Cristo? ");
INSERT INTO pps_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Xroon tsikjin sen kuachronga chijnie ndo Dio saꞌó ndachro ixi ndo Cristo tsachrjexin ndo ni kuachrjenixin ndo rey David ko tsi̱ꞌxi̱n ndo tjajna Belén, tjajna bakeꞌe ndo David. ");
INSERT INTO pps_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Méxin, kain na̱ jeꞌa naxrajeꞌo xraxaon na̱ ko chjeya na̱ kondeexin ndo Jesús. ");
INSERT INTO pps_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Kaxin na̱ tjaun na̱ saxrobikao na̱ ndo ixi xroxraxinꞌin na̱ ndo ndoꞌachjiso ko xroꞌan ni juincheꞌe ngeꞌe. ");
INSERT INTO pps_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Tjumeꞌe ni policía kondee niꞌngo ikjan na̱ ti ste ni fariseo ko xitaana tituanꞌan. Ko jeꞌe na̱ juanchangiꞌe na̱ ni policía: ―¿Sonda bikoꞌinta xa? ");
INSERT INTO pps_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Ko juateꞌe ni policía: ―Xroꞌan ngisen kuanichja xranchi nichja xi meꞌe. ");
INSERT INTO pps_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Ko ndache ni fariseo ni policía: ―¿Á kaxonnta kuintuꞌenta juintayaꞌanta xa? ");
INSERT INTO pps_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","¿Á xrojan na̱ tetuanꞌan tjajnai̱na o̱ ni fariseo kuitikaon xa? ");
INSERT INTO pps_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Ni titikaon xa, ni meꞌe chúxinꞌa na̱ ley ko jeꞌe na̱ tsikaon na̱. ");
INSERT INTO pps_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","*Xi Nicodemo, xi kuitsjeꞌe ndo Jesús naa tiie ó saꞌó, xi meꞌe naa ni fariseo, ko ndache xa na̱: ");
INSERT INTO pps_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","―Ley tajonꞌa juachaxin tsjankataꞌana naa chujni ijie̱ ti xratienꞌani ngeꞌe nichja na̱ ko noeꞌani ngeꞌe ijie̱ juincheꞌe na̱. ");
INSERT INTO pps_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Ko juateꞌe na̱: ―¿Á kaxon jaꞌa juixian nunte Galilea? Nchekuanxian xroon chijnie ndo Dio ko tsonoꞌa ixi xroꞌan ngisen kuachronga chijnie ndo Dio tsiki̱ꞌxi̱n nunte ntiꞌa. ");
INSERT INTO pps_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Ko ngujngu na̱ chjeya na̱ sakjui na̱ ndoꞌa na̱. ");
INSERT INTO pps_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Ko ndo Jesús sakjui ndo ijna̱ Olivo. ");
INSERT INTO pps_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Ndúyaxin kui̱i̱ ndo Jesús niꞌngo ko chujni tjajna kui̱i̱ na̱ ngajin ndo ko bakeꞌe ndo nunte ko kuaxi ndo juinchekuenꞌen ndo na̱. ");
INSERT INTO pps_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Tjumeꞌe ni tjako ley ko ni fariseo bikaꞌo na̱ naa nchri tsikitjaxin na̱ nchra jijuakao nchra naa xi, ko xi meꞌe jeꞌa xixiꞌe nchra. Ko bakeꞌe na̱ nchra ngusine ni ste ntiꞌa. ");
INSERT INTO pps_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Ko ndache na̱ ndo Jesús: ―Maestro, nchri jiꞌi kuitjaxin na̱ nchra jijuakao nchra naa xi, ko xi meꞌe jeꞌa xixiꞌe nchra. ");
INSERT INTO pps_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Ko xroon tsikjin ndo Moisés ndachro ixi kain nchri jaña sincheꞌe tsóñaxin na̱ nchra ixro, ko jaꞌa, ¿ngeꞌe ndachrua? ");
INSERT INTO pps_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Jaña juanchangiꞌe na̱ ndo ixi tjaun na̱ ndakoꞌa xrojuatingíexin ndo ixi xrokuitja na̱ ngeꞌe xrobankataꞌa na̱ ndo ijie̱. Ko jeꞌe ndo Jesús kuisée ndo ko kuaxi ndo ikjin ndo ngataꞌa inche ixi dedo itja ndo. ");
INSERT INTO pps_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Ko jeꞌe na̱ ícha tjanchangíꞌe na̱ ndo. Meꞌe xendua ndo ko ndache ndo na̱: ―Ni xroꞌan ijie̱ chónda, ni meꞌe saꞌó tsjánka na̱ ixro ko tsóña na̱ nchra. ");
INSERT INTO pps_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Ko íjngo kuisée ndo ko kuaxi ikjin ndo ngataꞌa inche. ");
INSERT INTO pps_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Ko jeꞌe na̱ kuinꞌen na̱ ngeꞌe ndachro ndo ko xraxaon na̱ ixi jeꞌe na̱ chónda na̱ ijie̱ kaxon. Méxin, kuaxi na̱ sakjui na̱, naa ko naa na̱, xrangíxixín ni ícha tachríi hasta ni ícha nchíín. Ko jeꞌe ndo Jesús ko nchri tsikikaꞌo na̱, yutu jeꞌo sen kuituꞌe sen. ");
INSERT INTO pps_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Ko tjumeꞌe ndo Jesús xendua ndo ko juanchangiꞌe ndo nchra: ―Jaꞌa nchri, ¿no ste ni tangiꞌa ko ni ndachro ixi chonda ijie̱ ko xrokuenꞌen? ¿Á ninaa na̱ tjankataꞌa na̱ ijie̱? ");
INSERT INTO pps_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Ko jeꞌe nchra ndachro nchra: ―Naꞌi, Ncháina, ninaa na̱ koꞌa na̱. Ko tjumeꞌe ndo Jesús ndachro ndo: ―Kaxon janꞌan tjankatáiꞌa ijie̱. Satjia ko íncheꞌa ícha ti ndakoꞌa juincheꞌe. ");
INSERT INTO pps_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","*Tjumeꞌe ndo Jesús nichja ndo íjngo ngajin na̱ ko ndachro ndo: ―Janꞌan xroꞌi tingasáña nunte xasintajni. Sen xroruéna xrochónda sen xroꞌi tajon juachaxin tsechón sen kain nchakon ko ítsajiꞌa sen ti naxixeꞌe. ");
INSERT INTO pps_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","*Ko ni fariseo ndachro na̱: ―Jaꞌua nichjaxian ixi jaꞌa, ko ti ndachrua tjinteꞌa. ");
INSERT INTO pps_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Ko juatingíexin ndo Jesús: ―Ngeꞌe nichjaxin janꞌon tjintee ixi nóna no juixin ko nóna no satsji. Ko jaꞌanta noaꞌinta no juixin ko no satsji. ");
INSERT INTO pps_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Jaꞌanta nchéñanta ijie̱ xranchi chujni nunte xasintajni nchéña ijie̱. Ko janꞌan xroꞌan ngisen tjankataꞌa ijie̱. ");
INSERT INTO pps_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Ko siá janꞌan sintaña ijie̱, ndako ntáña ijie̱ ixi jeꞌa janꞌon ntáña jiꞌi. Ndotána, ndo xruanꞌanna juiꞌi, kayuina ntáñana ijie̱. ");
INSERT INTO pps_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Ko ley tsikjin ndo Moisés ndachro siá tsonoxin yuu ni xrochronga á nduaxin jaña tsikonꞌen, jaña xrokonda tsitikaonni na̱. ");
INSERT INTO pps_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Ko janꞌan nichjaxin ixi janꞌan ko meꞌe ó naa ni chronga ngeꞌe, ko kaxon Ndotána, xruanꞌanna juiꞌi, jeꞌe ndo nichjaxin ndo ixi najanꞌan. Meꞌe ó yuu sen chronga. ");
INSERT INTO pps_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Ko juanchangiꞌe na̱ ndo: ―¿No jii Ndotáa? Ko juateꞌe ndo Jesús: ―Jaꞌanta chuxinꞌantana ko kaxon chuxinꞌanta Ndotána. Siá xrokuichuxinntana, kaxon xrokuichuxinnta Ndotána. ");
INSERT INTO pps_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Jaña ichro ndo Jesús nchakon juako ndo ngaxinꞌin niꞌngo ijié tjenka ti jii nta̱a̱ tjinga tomi tajon na̱. Ko xroꞌan chujni itsé ndo ixi ndo Dio xratajonꞌa ndo juachaxin xrotsé na̱ ndo. ");
INSERT INTO pps_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Ndo Jesús íjngo ndache ndo na̱: ―Janꞌan satsji. Ko jaꞌanta tsjéentana, ko nchakon tsenꞌennta xratsamanta ijie̱ chondanta. Ko juaꞌi itsjinta ti no satsji janꞌan. ");
INSERT INTO pps_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Ko ni judío juao kichuu na̱ ko ndachro na̱: ―¿Á tsóña xa aséen xa, méxin ndachro xa ixi juaꞌi itsjina tinó satsji xa? ");
INSERT INTO pps_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Ko ndache ndo Jesús na̱: ―Jaꞌanta nunte ntiꞌinta. Ko janꞌan juixin ngajní. Jaꞌanta nunte xasintajninta ko janꞌan jeꞌa nunte xasintajnina. ");
INSERT INTO pps_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Méxin, ndachrja̱n ixi nchakon tsenꞌennta xratsamanta ijie̱ chondanta ixi siá tsitikaonꞌanta ngisen ndachrja̱n, ngisen najanꞌan, nchakon tsenꞌennta xraxrochondanta ijie̱. ");
INSERT INTO pps_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Ko tjumeꞌe juanchangiꞌe na̱ ndo: ―¿Ngisen jaꞌa? Ko juateꞌe ndo: ―Xrangíxixión kuaxi ndachrja̱n ngisen najanꞌan. ");
INSERT INTO pps_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Itsjé ngeꞌe xrondachrja̱n ko kaxon sintaña ijie̱ ngajinnta. Ko ngisen xruanꞌanna juiꞌi chronga ndo ngeꞌe nduaxin. Ko jeꞌo ngeꞌe kui̱nꞌa̱n ndachro ndo xruanꞌanna, meꞌe ntakuanꞌan ni nunte xasintajni. ");
INSERT INTO pps_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Ko jeꞌe na̱ kuienxinꞌa na̱ ti nichja ndo ixi Ndotée ndo jii ngajní. ");
INSERT INTO pps_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Ko ndachro ndo: ―Nchakon tsjankanitonta nta̱cru Chjenꞌen ndo Dio, xjan jongíꞌe xranchi chujni, tsonoꞌanta ixi janꞌan nduaxin ngisen ntatjunta ngisen najanꞌan. Ko tsonoꞌanta ixi jeꞌa janꞌon tituanꞌan ixra̱ ntaꞌa. Naꞌi. Jeꞌo ngeꞌe juakoꞌna Ndotána meꞌe tjako. ");
INSERT INTO pps_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Ixi ndo xruanꞌanna juiꞌi, ndo meꞌe jii ndo ngajin janꞌan. Ndotána kuintunaꞌina ndo janꞌon ixi kain nchakon titikaꞌon ngeꞌe tjaun ndo. ");
INSERT INTO pps_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Nchakon jaña ndachro ndo Jesús kueya na̱ kuitikaon na̱ ndo. ");
INSERT INTO pps_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Tjumeꞌe ndo Jesús ndache ndo ni judío, ni kuitikaon ndo: ―Siá tsintueꞌanta ti tjako janꞌan, jaꞌanta nduaxin chujnina. ");
INSERT INTO pps_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Ko xrochuxinnta ti nduaxin, ko meꞌe xrotjáanta juachaxin ixi jian tsakeꞌenta ko xroꞌan ngisen tsantsjaꞌanta juachaxin meꞌe. ");
INSERT INTO pps_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","*Ko juateꞌe na̱: ―Janꞌanna kuachrjenixinna ndo Abraham, méxin í juaꞌi tsituanna̱na inaa ngisen. ¿Sonda ndachrua jaꞌa jai, xroꞌan ngisen tsingakonna̱na? ");
INSERT INTO pps_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Ko ndachro ndo Jesús: ―Naa ngeꞌe nduaxin ntatjunta ixi ngisen ncheꞌe ngeꞌe ndakoꞌa, juaꞌi tintuꞌe na̱ ti ndakoꞌa, ko ijie̱ chónda na̱ meꞌe tantsjeꞌe na̱ juachaxin. ");
INSERT INTO pps_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Ixi naa ni nchexra̱ juaꞌi tituꞌe na̱ nchia kain nchakon. Ko naa chjenꞌen ni ndoꞌa, tikinixinꞌen xjan tituꞌe xjan nchia kain nchakon. ");
INSERT INTO pps_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Ko nchakon Chjenꞌen ndo Dio xrotjáanta xjan juachaxin, xroꞌan ngeꞌe tsingakoꞌannta ko nduaxin chao tsajinta. ");
INSERT INTO pps_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Ó nóna ixi jaꞌanta tsikachrjenixinnta ndo Abraham. Ko tjaunnta tsóñantana ixi titikaonꞌanta ngeꞌe ndachrja̱n. ");
INSERT INTO pps_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Janꞌan ndachrja̱n ngeꞌe ó juakona Ndotána. Ko jaꞌanta titikaonnta ngeꞌe ntatjunta ndotáanta. ");
INSERT INTO pps_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Ko jeꞌe na̱ juateꞌe na̱: ―Ndotána̱na ndo Abraham. Ko ndachro ndo Jesús: ―Siá nduaxin xrokjuinta chjenꞌen ndo Abraham xrojuincheꞌenta ngeꞌe juincheꞌe ndo. ");
INSERT INTO pps_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Ko janꞌan ntatjunta ngeꞌe nduaxin, ngeꞌe ndo Dio juakoꞌna ndo, jaꞌanta tjaunnta tsonꞌintana. Ndo Abraham naiꞌa juincheꞌe ndo naa ngeꞌe jaña. ");
INSERT INTO pps_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Jaꞌanta ncheꞌenta xrajeꞌo ngeꞌe ncheꞌe ndotáanta. Ko ndachro na̱: ―Jeꞌa juinchéñamána na̱. Naꞌi. Chondana naakua Ndotána̱na meꞌe ndo Dio. ");
INSERT INTO pps_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Ko ndache ndo Jesús na̱: ―Siá nduaxin ndo Dio Ndotáanta meꞌe xrotjauntana ixi janꞌan kaxon kuachrjexin ti jii ndo ko ntiꞌi ritjén. Jeꞌa janꞌon juiꞌi. Naꞌi. Ndo Dio xruanꞌanna. ");
INSERT INTO pps_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","¿Sonda tienxinꞌanta ngeꞌe ndachrja̱n? Titikaonꞌanta ixi tjaunꞌanta tsinꞌennta ngeꞌe tjako. ");
INSERT INTO pps_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Jaꞌanta chjenꞌen Xixronꞌanxrée ko jaꞌanta tsikachrjexinnta xa ko tjaunnta tsitikaonnta ngeꞌe tjaun xa. Xixronꞌanxrée xrangíxixión tóña xa chujni. Ko naiꞌa nichja xa ngeꞌe nduaxin. Kain nchakon ncheya xa ixi jaña xraxaon xa. Jeꞌe xa tituanꞌan xa kain juancheya. ");
INSERT INTO pps_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Ko janꞌan ndachrja̱n ngeꞌe nduaxin ko jaꞌanta titikaonꞌanta. ");
INSERT INTO pps_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","¿Á xrojannta noꞌanta naa ijie̱ juintaꞌa? Siá ndachrja̱n ngeꞌe nduaxin, ¿sonda titikaonꞌantana? ");
INSERT INTO pps_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Ngisen titikaon ndo Dio tjaun sen tsinꞌen sen chijnie ndo. Ko jaꞌanta titikaonꞌanta ndo, meꞌe tjaunꞌanta tsinꞌennta chijnie ndo. ");
INSERT INTO pps_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Ko ni judío ndache na̱ ndo Jesús: ―Nduaxin ndako ndachrja̱nna ixi jaꞌa naa chujni samaritano ko chónda naa espíritue Xixronꞌanxrée. ");
INSERT INTO pps_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Ko juateꞌe ndo Jesús: ―Xroꞌan espíritue Xixronꞌanxrée chonda. Ixra̱ ntaꞌa tajonxin juasaya ngajin Ndotána. Ko jaꞌanta chondaꞌinta juasaya ngajin janꞌan. ");
INSERT INTO pps_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Janꞌan tjaunꞌa xrochjána chujni juasaya. Ko jii naa ngisen tjaun ixi chujni xrochjána juasaya, ko jeꞌe ndo nchéña ndo ijie̱ ngajin kain chujni. ");
INSERT INTO pps_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Naa ngeꞌe nduaxin ntatjunta; siá tsitikaonnta ngeꞌe tjako, naiꞌa tsenꞌennta. ");
INSERT INTO pps_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Ko juateꞌe ni judío: ―Jai nóna ixi nduaxin chonda naa espíritue Xixronꞌanxrée. Ndo Abraham ko kain sen kuachronga chijnie ndo Dio saꞌó, kuenꞌen sen. Ko jaꞌa ndachrua ixi siá tsitikaonna ngeꞌe tjakoa, tsenꞌana. ");
INSERT INTO pps_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","¿Á ícha tetuanꞌan jaꞌa ixi ndotána̱na Abraham? Jeꞌe ndo kuenꞌen ndo ko kaxon kuenꞌen sen kuachronga chijnie ndo Dio ó saꞌó. ¿Ngisen jaꞌa ixi jaña ndachrua? ");
INSERT INTO pps_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Ko juateꞌe ndo Jesús, ndachro ndo: ―Siá janꞌon tsajon juasaya ngajin janꞌan, tjinteꞌa jiꞌi. Ko Ndotána chjána ndo juasaya ko jaꞌanta ndachronta ixi jeꞌe ndo, ndo Dio naꞌanta. ");
INSERT INTO pps_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Ko jaꞌanta chuxinꞌanta ndo. Ko janꞌan chuxin ndo. Siá xrondachrja̱n chuxinꞌa ndo meꞌe xrojuincheya xranchi jaꞌanta. Ko janꞌan chuxin ndo ko titikaꞌon ngeꞌe tituanꞌan ndo. ");
INSERT INTO pps_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Ndo Abraham, ndo tsikachrjenixinnta tsango juaxruxin bakeꞌe ndo ixi xrobikon ndo nchakon xrojuiꞌi janꞌan. Ko bikon ndo nchakon meꞌe ko juaxruxin bakeꞌe ndo. ");
INSERT INTO pps_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Ko ni judío ndache na̱ ndo Jesús: ―Jaꞌa xrachondaꞌia yukante nano, ¿ko sonda ndachrua ixi ó bikuan ndo Abraham? ");
INSERT INTO pps_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Ko juateꞌe ndo Jesús: ―Naa ngeꞌe nduaxin ntatjunta ixi xrakoꞌa ndo Abraham, ó ritjén janꞌan. ");
INSERT INTO pps_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Ko tjumeꞌe kua na̱ ixro xrobankeꞌe na̱ ndo Jesús, ko jeꞌe ndo kuemá ndo, ko kuachrjexin ndo niꞌngo ntiꞌa. Tjumeꞌe kuatsinga ndo ngusine ti ste na̱ ko sakjui ndo. ");
INSERT INTO pps_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Jitatsinga ndo Jesús naa chaꞌo ko bikon ndo naa xi nchakon tsijongíexón xa tikonꞌa xa. ");
INSERT INTO pps_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Ko sen chrikao ndo juanchangiꞌe sen ndo: ―Maestro, ¿sonda tsijongíexón xa tikonꞌa xa? ¿Á kondeexin jíee ndotée o̱ janée xa o̱ á jíeó xa? ");
INSERT INTO pps_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Ko juateꞌe ndo Jesús, ndachro ndo: ―Jiꞌi jeꞌa jíee xa ko jeꞌa jíee ndotée ko janée xa. Jaña tsikonꞌen xa ixi ndo Dio tsjako juachaxien ndo. ");
INSERT INTO pps_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Xratáanchakon xrokonda sintaꞌa ixra̱ tjaun ngisen tsixruanꞌanna. Ko ó tsi̱i̱ tiie ko xroꞌan ngisen chao sincheꞌe ixra̱. ");
INSERT INTO pps_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","*Xraritjén janꞌan ntiꞌi nunte xasintajni, janꞌan meꞌe xroꞌi tingasáñaxin nunte. ");
INSERT INTO pps_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Ko juexin ndachro ndo jiꞌi, tjumeꞌe kuintjí ndo ndatée ndo nunte ko juinchéña ndo nchíín nchitaꞌo ko bingamá ndo nchitaꞌo meꞌe ikon xi tikonꞌa. ");
INSERT INTO pps_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Ko kuetuenꞌen ndo xa: ―Itjia tuye tjiá inda ndatinꞌin Siloé ko tontia inda ikuan. (Ko Siloé xrondachro ngigueꞌe na̱, tsixruaꞌan.) Ko sakjui xi tikonꞌa, konti xa inda ikon xa, ko hora ikjan xa ó chao tikon xa. ");
INSERT INTO pps_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Ko ni ndoꞌa tjenka ndoꞌa xa ko ni bakikon ixi tikonꞌa xa, ndachro na̱: ―¿Á jeꞌa xi jiꞌi batjanchiakaꞌa? ");
INSERT INTO pps_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Ko ikaxin na̱ ndachro na̱: ―Jaán, jeꞌe xa. Ko ikaxin na̱ ndachro na̱: ―Naꞌi, jeꞌa xa. Jeꞌo tikonni xa xranchi xi meꞌe. Ko jeꞌe xa juatingíexin xa: ―Jaán, janꞌanna. ");
INSERT INTO pps_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Méxin, juanchangiꞌe na̱ xa: ―¿Xranchi jai chao tikuan? ");
INSERT INTO pps_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Ko juatingíexin xa: ―Naa ndo ndatinꞌin Jesús juinchéña ndo nchitaꞌo bingamá ndo ikon ko tjumeꞌe kuetuanna ndo itsji ti jii pila jitjiá inda nchekinꞌin na̱ Siloé ko tsonti inda ikon. Ko ikjui konti inda, ko tuinxin biko̱n. ");
INSERT INTO pps_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Ko juanchangiꞌe na̱ xa: ―¿No jii xi meꞌe? Ko juateꞌe xa: ―Nónaꞌi. ");
INSERT INTO pps_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Ko jeꞌe na̱ sabikao na̱ xi batikonꞌa ngajin ni fariseo. ");
INSERT INTO pps_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Ko nchakon tjokéꞌe na̱ tsijinchekonchjian ndo Jesús nchitaꞌo ko juinchexruenꞌen ndo xi batikonꞌa. ");
INSERT INTO pps_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Méxin, ni fariseo juanchangiꞌe na̱ xa íjngo xranchi koxruenꞌen xa ko chao tikon xa jai. Ko jeꞌe xa ndachro xa: ―Juinchéña ndo chitaꞌo bingamá ndo ikon, ko konti inda ikon, ko jai chao tiko̱n. ");
INSERT INTO pps_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Ko kaxin ni fariseo ndachro na̱: ―Xi juincheꞌe jiꞌi, jeꞌa chujnie ndo Dio xa ixi chóndaꞌi xa juasaya nchakon tjokéꞌeni. Ko ikaxin na̱ ndachro na̱: ―¿Xranchi ncheꞌe xa ixra̱ ijié siá chónda xa ijie̱? Ko jaña jeꞌa xrajeꞌo xraxaon na̱. ");
INSERT INTO pps_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Tjumeꞌe juanchangiꞌe na̱ xi batikonꞌa íjngo: ―¿Jaꞌa ngeꞌe ndachrua ixi xi juintaxruanꞌan? Ko jeꞌe xa ndachro xa: ―Janꞌan ndachrja̱n ixi jeꞌe ndo naa ngisen nichja chijnie ndo Dio. ");
INSERT INTO pps_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Ko ni judío kuitikaonꞌa na̱ ixi nduaxin batikonꞌa xa ko jai chao tikon xa. Méxin, kuiyeꞌe na̱ ndotée ko janée xi tsikoxruenꞌen, ");
INSERT INTO pps_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","ko juanchangiꞌe na̱ sen: ―¿Á jiꞌi chjanꞌanta, jaꞌanta ndachronta ixi ti jongíexón xa tikonꞌa xa? ¿Ko xranchi jai chao tikon xa? ");
INSERT INTO pps_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Ko juatingíexin ndotée ko janée xa: ―Nónana ixi xi jiꞌi chjanꞌna̱na ko nónana ixi nchakon jongíꞌe xa tikonꞌa xa. ");
INSERT INTO pps_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Ko nónaꞌi na̱ xranchi tikon xa jai ko nónaꞌi na̱ ngisen juinchexruenꞌen xa. Tjanchangíꞌenta xa, ó jié xa ko jeꞌe xa xrochronga xa xranchi koxruenꞌen xa. ");
INSERT INTO pps_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Jaña juatingíexin ndotée ko janée xa ixi xrakonꞌen na̱ ni judío, ixi jeꞌe na̱ tsindachro na̱ ixi tsantsjexin na̱ niꞌngo chujni titikaon ndo Jesús ndo Cristo. ");
INSERT INTO pps_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Méxin, ndachro ndotée ko janée xa: “Tjanchangíꞌenta xa ixi ó ijié xa.” ");
INSERT INTO pps_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Ko ni judío íjngo kuiyeꞌe na̱ xi batikonꞌa ko ndache na̱ xa: ―Ndako chronga ngajinxin ikon ndo Dio ixi ó nónana ixi xi meꞌe ndakoꞌa ncheꞌe xa. ");
INSERT INTO pps_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Ko xi batikonꞌa juatingíexin xa: ―Nónaꞌi á chónda ndo ijie̱ o̱ naꞌi. Naakua ngeꞌe nóna ixi saꞌó batikonꞌa ko jai ó tiko̱n. ");
INSERT INTO pps_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Ko juanchangiꞌe na̱ xa íjngo: ―¿Xranchi juincheꞌe xa ixi juinchexruanꞌan xa? ");
INSERT INTO pps_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Ko juatingíexin xa: ―Juexin ntatjunta ko titikaonꞌanta. ¿Sonda tjaunnta íjngo xrondachrja̱n? ¿Á kaxonnta tjaunnta xroruéꞌenta ndo? ");
INSERT INTO pps_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Ko koyakuꞌe na̱ xa ko ndachro na̱: ―Jaꞌa rueꞌé xi meꞌe. Ko janꞌanna titikaꞌonna ngeꞌe kuetuanꞌan ndo Moisés. ");
INSERT INTO pps_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Janꞌanna nónana ixi ndo Dio nichjeꞌe ndo ndo Moisés. A̱ xi meꞌe, nónaꞌina no tsiki̱ꞌxi̱n xa. ");
INSERT INTO pps_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Ko juateꞌe xa ko ndachro xa: ―Tsango jée jiꞌi. Ndo meꞌe juinchexruanna ndo ko chao tiko̱n ko jaꞌanta noaꞌinta no tsiki̱ꞌxi̱n ndo. ");
INSERT INTO pps_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Nónana ixi ndo Dio tienꞌa ndo ngeꞌe tjanchia chujni chónda ijie̱. Jeꞌo tinꞌen ndo ngeꞌe tjanchia sen titikaon ndo, ko sen titikaon ngeꞌe tjaun ndo. ");
INSERT INTO pps_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Ko naiꞌa kuinꞌanna ixi naa ngisen nchexruenꞌen naa chujni xratsijongíexión tikonꞌa. ");
INSERT INTO pps_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Ko ndo meꞌe, siá xrokui̱xi̱nꞌa ndo ti jii ndo Dio, xroꞌan ngeꞌe jian xrojuincheꞌe ndo. ");
INSERT INTO pps_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Ko juateꞌe ni fariseo ko ndachro na̱: ―Jaꞌa kueya ijie̱ chonda nchakon jongíꞌa. Ko jai, ¿á tjauan ixi jaꞌa tsjakoꞌna̱na? Ko bengixin na̱ xa niꞌngo. ");
INSERT INTO pps_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Ndo Jesús konoꞌe ndo ixi jaña juinchekao ni judío xi batikonꞌa ti bantsjexinna xa niꞌngo. Ko kuetan ndo Jesús xi meꞌe ko juanchangiꞌe ndo xa: ―¿Á chuntia Chjenꞌen ndo Dio, xjan jongíꞌe xranchi chujni? ");
INSERT INTO pps_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Ko ndachro xa: ―Ncháina, ndachijiana ngisen meꞌe ixi xrochu̱ntia ndo. ");
INSERT INTO pps_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Ko juateꞌe ndo Jesús: ―Ó bikuan ndo. Meꞌe ndo ritjáoa. ");
INSERT INTO pps_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Ko xi meꞌe bakeꞌexin ntatuchiꞌin xa tutée ndo Jesús, ko ndachro xa: ―Jai chuntia, Ncháina. ");
INSERT INTO pps_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Ko ndachro ndo Jesús: ―Janꞌan juiꞌi nunte xasintajni ixi sintaꞌa ijie̱ ngajin chujni, ixi ni tikonꞌa, tsikon na̱, ko ni tikon, tsikonꞌa na̱. ");
INSERT INTO pps_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Ko kaxin ni fariseo ste ntiꞌa kuinꞌen na̱ jaña ndachro ndo Jesús ko juanchangiꞌe na̱ ndo: ―¿Á kaxon janꞌanna tikonꞌana? ");
INSERT INTO pps_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Ko juatingíexin ndo Jesús: ―Jaꞌanta siá nduaxin xrobikonꞌanta, xrochondaꞌinta ijie̱. Ko na̱ ndachronta tikonnta, meꞌe chondanta ijie̱. ");
INSERT INTO pps_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Tjumeꞌe ndachro ndo Jesús: ―Nduaxin ntatjunta: ni tsixinꞌa nta̱chja tijexin kutuchjon, ko tixixin na̱ nango; ni meꞌe ncheꞌe na̱ xranchi naa xicheꞌe ko naa ni ndakoꞌa ncheꞌe. ");
INSERT INTO pps_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Ko ngisen tixixin nta̱chja, sen meꞌe nduaxin sen tsjeꞌe kutuchjon. ");
INSERT INTO pps_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Ko sen tendáa nta̱chja tantjeꞌe sen nta̱chja ixi tixinꞌin sen nduaxin tsjeꞌe ba, ko kutuchjon chúxin ba tée sen. Ko tiyeꞌe sen ngujngu kutuchjon ixi xranchi tinꞌin ba ko tantsjexin sen ba ndoꞌa ba. ");
INSERT INTO pps_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Ko juexin tachrje kain ba, titaonꞌen sen ba chaꞌo ko ruéꞌe ba ixi chúxin ba tée sen. ");
INSERT INTO pps_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Ko rueꞌa ba inaa ngisen chúxinꞌa ba; cháña satinga ba ixi chúxinꞌa ba tée jeꞌe na̱. ");
INSERT INTO pps_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Jaña juako ndo Jesús chijni jiꞌi, ko jeꞌe na̱ kuienxinꞌa na̱ ngeꞌe ndachro ndo. ");
INSERT INTO pps_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Tjumeꞌe ndachro ndo Jesús íjngo: ―Nduaxin ndachrja̱n ixi janꞌan nta̱chja meꞌe tixixin kutuchjon. ");
INSERT INTO pps_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Kain ni kui̱i̱ ti xratiꞌa janꞌan, ni meꞌe xicheꞌe ko ni te̱e. Ko kutuchjon kuitikaonꞌa ba na̱. ");
INSERT INTO pps_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Janꞌan nta̱chja meꞌe: siá tixinxinnta janꞌan, tsitjáñaꞌinta ko xrokjannta xranchi kutuchjonna tsachrjexin ba ti jijeꞌe̱ ba ko tixinꞌin ba ko titja ba ngeꞌe ine ba. ");
INSERT INTO pps_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","’Ko xicheꞌe jeꞌo ti̱i̱ xa ixi tjaun xa tse̱e̱ xa, ko tsóña xa, ko nchetjáñajin xa kain ngeꞌe. Ko janꞌan juiꞌi ixi tsaricho̱nnta kain nchakon ko xroꞌan ngeꞌe tsitjáñaꞌanta. ");
INSERT INTO pps_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Janꞌan naa ngisen jian tsjeꞌe kutuchjon, ko sen jian meꞌe tsenxin sen ixi kutuchjoen. ");
INSERT INTO pps_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Ko ngisen jeꞌo ncheꞌe ixra̱ jeꞌo tjaun na̱ tsjacha na̱; tikon na̱ jiti̱i̱ naa kundanixra tintuꞌe na̱ kutuchjon ko satsji na̱ ixi jeꞌe na̱ jeꞌa ngisen nduaxin tsjeꞌe kutuchjon ko jeꞌa kutuchjoen na̱. Ko kundanixra xrotsé ba kutuchjon ko ikaxin kutuchjon satsinga ba, xrochjekeꞌe ba. ");
INSERT INTO pps_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Ko ni meꞌe satsinga na̱ ixi jeꞌo tjaun na̱ tsjengeꞌe na̱ na̱ ꞌna̱ ko taꞌi na̱ juachjaon ixi kutuchjon tsjeꞌe na̱. ");
INSERT INTO pps_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","*’Ko janꞌan naa sen jian tsjeꞌe kutuchjon. Ko xranchi Ndotána chúxin na̱ ndo, kaxon janꞌan chuxin ndo. Jaña chuxin janꞌan kutuchjonna ko jeꞌe ba chúxinna ba. Ko janꞌan tsenxin ixi kutuchjonna. ");
INSERT INTO pps_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Kaxon janꞌan chonda ikaxin kutuchjon xra jeꞌa ntiꞌi ste ba ko xrokonda tsikian ba. Ko siá jeꞌe ba tsinꞌen ba ti nichja janꞌan, tsoña̱ naakua no tsintee ba ko naakua ngisen xrotsjeꞌe ba. ");
INSERT INTO pps_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","’Ndotána tjaunna ndo ixi maski tsenꞌén, xroxechónna íjngo. ");
INSERT INTO pps_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Xroꞌan ngisen tsantsjena ti rícho̱n, janꞌon tajon aséenna tsenꞌen ixi jaña tjaꞌon. Chonda juachaxin tsajon aséenna ko chonda juachaxin xroxechónna íjngo. Jiꞌi kuetuanna Ndotána. ");
INSERT INTO pps_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Hora kuinꞌen ni judío ti ndachro ndo Jesús, kuaxi na̱ chjeyeꞌe na̱ íjngo. ");
INSERT INTO pps_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Kueya na̱ ndachro na̱: ―¿Sonda tinꞌenna ingeꞌe ndachro xa? Jeꞌe xa chónda xa espíritue Xixronꞌanxrée ko xraxaonꞌa xa jian. ");
INSERT INTO pps_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Ko ikaxin na̱ ndachro na̱: ―Ninaa chujni chónda espíritu ñaꞌi nichja jaña. ¿Á chao naa espíritue Xixronꞌanxrée xrokuajon juachaxin ixi naa ngisen tikonꞌa, chao tsikon? ");
INSERT INTO pps_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Ko ó nchakuen ikin, tjajna Jerusalén stencheꞌe na̱ kia xraxaonxin na̱ nchakon juexin tsikoña niꞌngo. ");
INSERT INTO pps_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Ko ndo Jesús jitji ndo ti ndasin ndatinꞌin Salomón, naa ndasin niꞌngo. ");
INSERT INTO pps_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Ko ni judío kondentájin na̱ ndo Jesús ko juanchangiꞌe na̱ ndo: ―Stechonꞌanna tsonónana ngisen jaꞌa. Jai chronga nduaxin á jaꞌa ndo Cristo. ");
INSERT INTO pps_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Ko juatingíexin ndo Jesús: ―Ó ntatjunta ko titikaonꞌanta. Kain ixra̱ ntaꞌa, juachaxien Ndotána ntaꞌaxin ixra̱; ko jiꞌi tjakoxin ngisen janꞌan. ");
INSERT INTO pps_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Ko titikaonꞌanta ixi jeꞌa kutuchjonna jaꞌanta xranchi ntatjunta saꞌó. ");
INSERT INTO pps_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Kutuchjonna chúxin ba taana ko kaxon janꞌan chuxin ba ko jeꞌe ba ruaꞌna ba. ");
INSERT INTO pps_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Janꞌan tjáꞌa ba juachaxin tsechón ba kain nchakon ko naiꞌa tsitjáña ba ko xroꞌan ngisen tsantsjexin ba ngaya tjáana. ");
INSERT INTO pps_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Ndotána chjána ndo ba, ndo ícha tetuanꞌan ngajin kainna, ko xroꞌan ngisen tsantsjexin ba itja ndo. ");
INSERT INTO pps_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Janꞌan ko Ndotána naakua ngisenna. ");
INSERT INTO pps_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Ko ni judío íjngo itsé na̱ ixro xrojuangeꞌe na̱ ndo. ");
INSERT INTO pps_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Ko ndachro ndo Jesús: ―Kueya ngeꞌe jian bikonta juintaꞌa ixi juachaxien Ndotána. ¿Sonda tjaunnta tsóñaxinntana ixro ixi juintaꞌa kain meꞌe? ");
INSERT INTO pps_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Ko juateꞌe ni judío: ―Jeꞌa ixi kain ngeꞌe jian juincheꞌe tsaaxianna ixro. Naꞌi. Ixi ngeꞌe ndakoꞌa ndachrua, jaꞌa xrajeꞌo xranchi inaa chujni, ko jaꞌa ndachrua xixian ndo Dio. ");
INSERT INTO pps_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Ko ndachro ndo Jesús: ―Ndachro xroon chijnie ndo Dio tsikjin sen saꞌó: “Kaxon xranchi ndo Dio jaꞌanta.” ");
INSERT INTO pps_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Ko noi̱na ixi ngeꞌe ndachro xroon chijnie ndo Dio, juaꞌi tsitikaonꞌana. Ndachro ndo Dio ixi xranchi ndo Dio ngujngu chujni kuayéꞌe chijnie ndo. ");
INSERT INTO pps_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Ko ndo Dio kuincheꞌena ko xruanꞌanna ndo nunte xasintajni, ¿sonda ndachronta ixi janꞌan nichjangíꞌa ndo Dio ixi ndachrja̱n janꞌan Chjenꞌen ndo? ");
INSERT INTO pps_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Siá janꞌan xrojuintaꞌi ixra̱ ncheꞌe Ndotána, titikaonꞌantana. ");
INSERT INTO pps_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Ko siá nduaxin ntaꞌa ixra̱ ncheꞌe Ndotána, maski titikaonꞌantana janꞌan, titikaonnta ixra̱ ntaꞌa ixi ña̱ tsitikaonxinnta ixi Ndotána ko janꞌan naakuana ko jeꞌe ndo jii ndo ngajin ko janꞌan ritjén ngajin ndo. ");
INSERT INTO pps_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Ko íjngo xrotsé na̱ ndo Jesús xrobijeꞌe̱ na̱ ndo ko jeꞌe ndo sakjui ndo. ");
INSERT INTO pps_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","*Ko ndo Jesús ikjan ndo íjngo tuenxin ndarío Jordán ti no bakeꞌe ndo Juan batikitéxin ndo chujni saꞌó. ");
INSERT INTO pps_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Ko kueya na̱ ruéꞌe na̱ ndo ko ndachro na̱: ―Nduaxin ndo Juan maski juincheꞌa ndo itsjé ixra̱ ijié, nduaxin chronga ndo ixi xi jiꞌi. ");
INSERT INTO pps_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Ko kueya na̱ jii ntiꞌa kuitikaon na̱ ndo Jesús. ");
INSERT INTO pps_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","*Bakeꞌe naa xi niꞌe ndatinꞌin Lázaro, tjajnée xa Betania, tjajnée nchri María ko nchri Marta, nchri kichuu xa. ");
INSERT INTO pps_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","*Nchri María, nchri kichuu xi Lázaro xi niꞌe, nchri meꞌe nchri bikitée nda chaxro xraxe tutée ndo Jesús ko juinchexemaxin nchra tutée ndo ixi xrajaa nchra. ");
INSERT INTO pps_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Ko kayui nchra, kichuu nchra, xruanꞌan nchra naa ngisen ndache ndo Jesús: ―Ncháina, xi tjentúa niꞌe xa. ");
INSERT INTO pps_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Ko kuinꞌen ndo Jesús ko ndachro ndo: ―Ichin chónda xa jeꞌa tsenxin xa ichin meꞌe. Naꞌi. Jiꞌi tsjako juachaxin ijié chónda Chjenꞌen ndo Dio. ");
INSERT INTO pps_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Ko maski ndo Jesús tsango tjueꞌe ndo nchri Marta, ko kao nchri kichuu nchra ko xi Lázaro, ");
INSERT INTO pps_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","hora ndache na̱ ndo niꞌe xi Lázaro, xrakuituꞌe ndo yuu nchakon ti no jii ndo. ");
INSERT INTO pps_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Ko tjumeꞌe ndache ndo sen chrikao ndo: ―Ichjina íjngo nunte Judea. ");
INSERT INTO pps_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Ko juatingíexin sen chrikao ndo: ―Maestro, xrachóndaꞌi itsjé nchakon, ni judío tjaun na̱ xrokóñaxinna na̱ ixro. ¿Á íjngo tjaunnta itsjinta ntiꞌa? ");
INSERT INTO pps_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Ko ndachro ndo Jesús: ―¿Á jeꞌa nchakon chónda teyuu hora? Siá tanchakon ichrjini tontengixinꞌani ixro ixi jii xroꞌi tingasáñaxin nunte xasintajni. ");
INSERT INTO pps_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Ko siá ichrjini tiie tontengixinni ixi koꞌa xroꞌi. ");
INSERT INTO pps_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Tjumeꞌe ndachro ndo Jesús: ―Xi Lázaro, xi tjentona, jijua xa ko itsji sintaxingamaꞌa xa. ");
INSERT INTO pps_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Ko ndachro sen chrikao ndo: ―Ncháina, siá jijua xa, chao xroxruenꞌen xa. ");
INSERT INTO pps_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Ko ti ndachro ndo Jesús xrondachro ixi tsikenꞌen xi Lázaro. Ko sen teyuu chrikao ndo xraxaon sen ixi jeꞌo ndachro ndo jijua xa. ");
INSERT INTO pps_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Tjumeꞌe ndako chronga ndo Jesús: ―Xi Lázaro tsikenꞌen xa. ");
INSERT INTO pps_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Ko juaxruxin ritjén ixi koꞌana ntiꞌa ixi jaꞌanta tsikonnta ko tsitikaonnta. Ko jai ichjina tsitsjeꞌena xa. ");
INSERT INTO pps_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Tjumeꞌe ndo Tomás, ndo nchekinꞌin sen xjan kuatsi, ndache ndo sen kaxin: ―Kao jai̱na ichjina ko tsenꞌen na̱ xranchi ndo Jesús. ");
INSERT INTO pps_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Nchakon kuiji ndo Jesús ntiꞌa, konoꞌe ndo ixi xi Lázaro ó chónda noó nchakon tsixrabaa xa. ");
INSERT INTO pps_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Tjajna Betania ko tjajna Jerusalén tjenka ste yui tjajna, xranchi yuu kilómetro kutuꞌo kjínxin ste tjajna. ");
INSERT INTO pps_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Ko itsjé ni judío ikjui na̱ kuitsjeꞌe na̱ nchri Marta ko nchri María, kuinichjeꞌe na̱ nchra ixi jitoniꞌe aséen nchra ixi kuenꞌen xi kichuu nchra. ");
INSERT INTO pps_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Hora kuinꞌen nchri Marta ixi ó jiti̱i̱ ndo Jesús, kuachrje nchra biketan nchra ndo. Ko nchri María kuituꞌe nchra nchia. ");
INSERT INTO pps_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Ko nchri Marta ndache nchra ndo Jesús: ―Ncháina, siá jaꞌa xrobakeꞌe ntiꞌi, xrokuenꞌa xi saona. ");
INSERT INTO pps_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Ko nóna ixi ndo Dio xrotjáa ndo kain ngeꞌe tsjancheꞌe ndo. ");
INSERT INTO pps_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Ko ndache ndo Jesús nchra: ―Xisaua xroxechón xa íjngo. ");
INSERT INTO pps_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Nchri Marta ndachro nchra: ―Janꞌan nóna xroxechón xa íjngo nchakon xroxechón kain ni tsikenꞌen, nchakon tsjexixin kain ngeꞌe. ");
INSERT INTO pps_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Ko ndachro ndo Jesús: ―Janꞌan ntaxechón chujni ko tajon juachaxin tsechón chujni. Ngisen titikaonna, maski tsenꞌen sen, xroxechón sen íjngo. ");
INSERT INTO pps_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Ko kain sen xra jichón ko titikaon sen, naiꞌa tsenꞌen sen. ¿Á titikáoan jiꞌi? ");
INSERT INTO pps_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Jeꞌe nchra ndachro nchra: ―Jaán, Ncháina, janꞌan titikaꞌon ixi jaꞌa ndo Cristo, Chjenꞌen ndo Dio, ndo xrokui̱i̱ nunte xasintajni. ");
INSERT INTO pps_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Ó juexin ndachro nchri Marta jaña, ko sakjui nchra kuiyeꞌe nchri kichuu nchra, nchri María, ko imao ndache kichuu nchra: ―Ndo Maestro jii ndo ntiꞌi ko tiyaꞌa ndo. ");
INSERT INTO pps_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Ko kuinꞌen nchri María, tuinxin bingatjen nchra sakuitsjeꞌe nchra ndo Jesús. ");
INSERT INTO pps_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Ko ndo Jesús xratsikixinꞌa ndo tjajna, xra jii ndo ti no kuetanxin ndo nchri Marta. ");
INSERT INTO pps_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Ko ni judío, ni jinichjeꞌe nchri María stenchecháxin na̱ nchra, bikon na̱ ixi taka kuachrjexin nchra nchia, ko ruéꞌe na̱ nchra ixi xraxaon na̱ ixi satsji nchra ti no tsixrabaa xisaoe nchra, ko ntiꞌa xrotsjangaxin nchra xa. ");
INSERT INTO pps_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Tjumeꞌe nchri María kuiji nchra ti jii ndo Jesús, bakeꞌexin ntatuchiꞌin nchra tutée ndo, ko ndachro nchra: ―Ncháina, siá xrobakeꞌe ntiꞌi xrokuenꞌa xisaona. ");
INSERT INTO pps_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Ko bikon ndo Jesús jitsjanga nchri María ko ni judío kuijikao nchra, meꞌe tsango juincheniꞌe ndo. ");
INSERT INTO pps_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Ko juanchangi ndo: ―¿No juabaanta xa? Ko ndachro na̱: ―Ncháina, xrokuia tsjeꞌé. ");
INSERT INTO pps_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Ko tsjanga ndo Jesús. ");
INSERT INTO pps_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Ko ndachro ni judío: ―Tsjeꞌenta tsango tjueꞌe ndo xi tsikenꞌen. ");
INSERT INTO pps_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Ko ikaxin na̱ ndachro na̱: ―Jeꞌe xa juincheꞌe xa ixi chao bikon xi batikonꞌa. ¿Á juaꞌi xrokuajon xa juachaxin ixi xrokuenꞌa xi Lázaro? ");
INSERT INTO pps_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Ko tsango koniꞌe aséen ndo Jesús ko konchjiñeꞌe ndo ti no tsixrabaa xi Lázaro. No tsixrabaa xa naa itjao̱ meꞌe ko nduja tsikijee̱xin na̱ naa ixro. ");
INSERT INTO pps_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Ko kuetuanꞌan ndo Jesús: ―Tintjiannta ixro. Ko nchri Marta, nchrikichuu xi tsikenꞌen, ndachro nchra: ―Ncháina, já ó bakaxra ndo ixi chónda xa noó nchakon kuenꞌen xa. ");
INSERT INTO pps_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Ko ndachro ndo Jesús: ―Á ntatjuꞌia ixi siá tsitikaoan tsikuan naa ixra̱ ijié sincheꞌe ndo Dio ixi juachaxien ndo. ");
INSERT INTO pps_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Tjumeꞌe kuintjian na̱ ixro. Ko ndo Jesús tsjeꞌe ndo ngajní, ko ndachro ndo: ―Ndotána, tajon juasiana ngajinnta ixi ó kuinꞌennta ngeꞌe ndachrja̱n. ");
INSERT INTO pps_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Janꞌan nóna ixi kain nchakon tinꞌennta ngeꞌe ntatjunta ko jai jaña ntatjunta ixi tsinꞌen ni ste ntiꞌi ko tsitikaon na̱ ixi jaꞌanta xruanꞌanntana juiꞌi. ");
INSERT INTO pps_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Ko juexin ndachro ndo jiꞌi, séen kuyako ndo: ―¡Lázaro, tachrjexian ña̱! ");
INSERT INTO pps_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Ko xi tsikenꞌen tuinxin kuachrje xa, ko itja xa ko tutée xa jixritexin ixi manta ko ikon xa jisiamá inaa manta. Ko ndachro ndo Jesús: ―Tonxindangeꞌenta xa ko tintuꞌenta satsji xa. ");
INSERT INTO pps_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Ko kueya ni judío, ni kuijikao nchri María bikon na̱ ngeꞌe juincheꞌe ndo Jesús ko kuitikaon na̱ ndo. ");
INSERT INTO pps_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Ko ikaxin na̱ kuitsjeꞌe na̱ ni fariseo, ko beki na̱ ngeꞌe tsijincheꞌe ndo Jesús. ");
INSERT INTO pps_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Tjumeꞌe xi fariseo ko xitaana tetuanꞌan xraꞌo na̱ ngajin chujni ícha tetuanꞌan, ko ndachro xa: ―¿Ngeꞌe sintuꞌuna ixi xi jiꞌi jincheꞌe xa itsjé ngeꞌe ijié? ");
INSERT INTO pps_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Siá tsintuꞌena xa, tjumeꞌe kain na̱ tsitikaon na̱ xa, ko tsi̱i̱ ni tetuanꞌan Roma ko tsonchjejin na̱ ningoina ko sinchetjáña na̱ tjajnai̱na. ");
INSERT INTO pps_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Ko naa xi tinꞌin Caifás, xitaana ícha tetuanꞌan nano meꞌe, ndache xa na̱: ―Jaꞌanta xroꞌan ngeꞌe noꞌanta ");
INSERT INTO pps_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","ko xraxaonꞌanta ixi ícha jian naakua chujni tsenꞌen ixi tjajnai̱na ko jeꞌa kain ni tjajnai̱na tsitjáña na̱. ");
INSERT INTO pps_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Ko xi Caifás jeꞌa jeꞌe xi tsixraxaon xa jaꞌin, Espíritue ndo Dio juinchenoꞌe xa ixi ndo Jesús tsenxin ndo tjajnée ni judío ixi jeꞌe xa tetuenꞌen xa xitaana nano meꞌe. ");
INSERT INTO pps_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Ko jeꞌa jeꞌo tjajna meꞌe xrokuenxin ndo. Naꞌi. Kaxon xrokuenxin ndo ixi xroxraꞌo kain chjenꞌen ndo Dio, xjan tsichjekeꞌe nchijíi nunte xasintajni. ");
INSERT INTO pps_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Ko hora meꞌe ni tetuenꞌen ni judío juangíxin na̱ xraxaon na̱ xranchi naatsóñaxón na̱ ndo Jesús. ");
INSERT INTO pps_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Méxin, nchakon meꞌe ndo Jesús í bakonoxinꞌa ndo ngakjenꞌen ni judío, ko kuachrjexin ndo nunte Judea, sakjui ndo tjenka ijna̱, ti jii naa tjajna ndatinꞌin Efraín. Ntiꞌa kuituekao ndo sen teyuu chrikao ndo. ");
INSERT INTO pps_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Xratitjáña xrokui kia Pascua, kiée ni judío ko kueya na̱ kuachrjexin na̱ tjajnée na̱ sakjui na̱ tjajna Jerusalén ixi ntiꞌa sintakji na̱ ixi tsontjúá na̱ ti xratiꞌa kia Pascua. ");
INSERT INTO pps_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Ntiꞌa stetjée na̱ ndo Jesús ko kuiji na̱ ngaxinꞌin niꞌngo ijié ko ndache kichuu na̱: ―¿Jaꞌanta ngeꞌe chronta? ¿Á tsi̱i̱ xa kia o̱ naꞌi? ");
INSERT INTO pps_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Ko xi fariseo ko xi tetuenꞌen xitaana kuetuanꞌan xa ixi siá xrojan ngisen noꞌe no jii ndo Jesús xrochronga na̱ ko jaña xrotsé xa ndo ko xroxraxinꞌin xa ndo ndoꞌachjiso. ");
INSERT INTO pps_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Xratitjáña ikjaon nchakon xrokui̱i̱ kia pascua, ndo Jesús ikjui ndo tjajna Betania ti jii xi Lázaro. Xi meꞌe ndo Jesús juinchexechón ndo xa. ");
INSERT INTO pps_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Ko ntiꞌa juine sen naa kónkjín ko kuajon sen juasaya ngajin ndo Jesús. Nchri Marta juinchekonchjian nchra ti juine sen ko xi Lázaro ko ikaxin sen ste sen stenekao sen ndo Jesús. ");
INSERT INTO pps_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","*Tjumeꞌe nchri María bikaꞌo nchra xranchi tuꞌo litro nda chaxro xraxe tsikoña xro̱a̱n nardo tsango tjintee tsikeꞌna nchra ko bingamá nchra tutée ndo Jesús, ko ixi xrajée nchra juinchexemaxin nchra tutée ndo, ko nguixin ngaxinꞌin nchia bakaxraxe xro̱a̱n meꞌe. ");
INSERT INTO pps_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Ko xi Judas Iscariote, ndotée xa ndatinꞌin Simón, jeꞌe xa naa sen teyuu chrikao ndo Jesús, ko xi meꞌe sinchekji ndo ícha tjumeꞌe, ndachro xa: ");
INSERT INTO pps_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","―¿Sonda konchjiꞌa xro̱a̱n xraxe? Xrokúchji̱xi̱n níi ciento tomi denario ixi xrobingijnaxinni ni nóa. ");
INSERT INTO pps_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Ko xi Judas jeꞌa ndachro xa jaña ixi tikonóeꞌe xa ni nóa. Naꞌi. Ndachro xa jiꞌi ixi chéꞌe xa, ko jeꞌe xa tsjeꞌe xa ngeꞌe tjinga tomi ko kain nchakon te̱e xa tomi tsixraꞌo ntiꞌa. ");
INSERT INTO pps_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Méxin, ndachro ndo Jesús: ―Tintuꞌenta nchra. Tsikatsiꞌin nchra xro̱a̱n xraxe jiꞌi ixi nchakon xroxrabaana. ");
INSERT INTO pps_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Ni nóa kain nchakon tsarikuꞌunta na̱ ko janꞌan kainꞌa nchakon xrochondantana. ");
INSERT INTO pps_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Tjumeꞌe kueya ni judío konoꞌe na̱ ixi ndo Jesús jii ndo tjajna Betania, ko sakjui na̱ ntiꞌa. Jeꞌa jeꞌo xrokuitsjeꞌe na̱ ndo. Kaxon tjaun na̱ xrokuitsjeꞌe na̱ xi Lázaro, xi juinchexechón ndo Jesús. ");
INSERT INTO pps_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Tjumeꞌe xitaana tetuanꞌan juao kichuu xa ko xraxaon xa naatóñaxón xa xi Lázaro kaxon ");
INSERT INTO pps_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","ixi kondeexin jeꞌe xa kueya ni judío stetingaxiton na̱ ngajin xitaana ko jititikaon na̱ ndo Jesús. ");
INSERT INTO pps_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Kueya na̱ satsikji na̱ tjajna Jerusalén kia Pascua. Ko ndúyaxin konoꞌe na̱ ixi tsiji ndo Jesús tjajna ntiꞌa. ");
INSERT INTO pps_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Ko konchrinjin na̱ chaan ntakajne ko kuachrje na̱ ngatja chaꞌo kuayéꞌe na̱ ndo Jesús, ko séen ndachro na̱: ―Juasaya ngajin ndo Dio. Tsango jian ndo kui̱xi̱n ixi juachaxien Ndotáina jii ngajní. Tsango jian ndo Rey tetuenꞌen tjajna Israel. ");
INSERT INTO pps_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Ko kuitja ndo Jesús naa kuntajno ko kuetaꞌa ndo ba, xranchi jitaxin chijnie ndo Dio: ");
INSERT INTO pps_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Xrakonꞌa jaꞌa tjajna Jerusalén, tsjeꞌe jiti̱i̱ ndo Rey naꞌa, jitaꞌa ndo naa kuntajno. ");
INSERT INTO pps_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Ko nchakon konꞌen jiꞌi, sen teyuu chrikao ndo Jesús kuienxinꞌa sen sonda konꞌen. Tjumeꞌe nchakon juexin sakjui ndo Jesús ngajní, xraxaon sen ixi jaña jitaxin xroon tsikjin ni kuachronga chijnie ndo Dio saꞌó, xranchi tsonꞌen ndo, ko nduaxin jaña konꞌen. ");
INSERT INTO pps_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Jaña kain ni bakeꞌe ngajin ndo Jesús nchakon kuiyeꞌe ndo xi Lázaro kuachrjexin xa ti no tsixrabaa xa ko xechón xa, ni meꞌe beki na̱ ngeꞌe bikon na̱. ");
INSERT INTO pps_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Méxin, kueya na̱ bijirueꞌe na̱ ndo Jesús ngatja chaꞌo, ixi ó konoꞌe na̱ ixra̱ ijié tsijincheꞌe ndo. ");
INSERT INTO pps_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Méxin, xi fariseo juao kichuu xa: ―Ó bikonta, juaꞌi ngakonꞌen na̱, tsjeꞌenta kain na̱ ruéꞌe na̱ xa. ");
INSERT INTO pps_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Kaxin ni nichja ngigua griego bakeꞌe na̱ ngakjenꞌen ni kui̱i̱ kia tjajna Jerusalén xroxraxaonxin na̱ ndo Dio. ");
INSERT INTO pps_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Meꞌe konchjiñeꞌe na̱ ngajin ndo Felipe, ndo tjajna Betsaida, nunte Galilea, ko kuinóatée na̱ ngajin ndo ko ndachro na̱: ―Tjaꞌonna tsikonna ndo Jesús. ");
INSERT INTO pps_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Ko ndo Felipe kuiji ndo kuindache ndo ndo Andrés. Ko tjumeꞌe yui sen kuindache sen ndo Jesús. ");
INSERT INTO pps_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Ko ndachro ndo Jesús: ―Ó kuiji hora, ixi Chjenꞌen ndo Dio, Xjan jongíꞌe xranchi chujni, satsji ndo tsayéꞌe ndo juachaxien Ndotée ndo. ");
INSERT INTO pps_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Ko nduaxin ngeꞌe ntatjunta ixi siá tsitsinga naa noatrigo ngataꞌa inche, ko tsenꞌa noa, jeꞌo naa noa tsituꞌe. Ko siá tsenꞌen noa, tjumeꞌe tsoña̱ kueya noa ixi jaña tsandáani no. ");
INSERT INTO pps_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","*Ko ni tjueꞌe aséen ixi xroꞌan ngeꞌe sintakonꞌen na̱, ni meꞌe sinchetjáña na̱ ti tsechón na̱ kain nchakon. Ko ngisen ningakonꞌen aséen maski xrokuenꞌen sen ntiꞌi nunte xasintajni ixi xrochronga sen chijnie ndo Dio, sen meꞌe xrochónda sen juachaxin tsechón sen kain nchakon. ");
INSERT INTO pps_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Siá xrojan ngisen tjaun sincheꞌe xra̱na, xroruana sen. Ko ti no tsakeꞌe janꞌan, ntiꞌa kaxon tsakeꞌe sen ncheꞌe xra̱na. Siá xrojan ngisen sincheꞌe xra̱na, Ndotána tsjengeꞌe ndo sen ꞌna̱. ");
INSERT INTO pps_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","’Ko jai tsango toniꞌe aséenna. ¿Ngeꞌe xrondachrja̱n? ¿Á xrondachrja̱n: “Ndotána tájonꞌanta juachaxin ngeꞌe tsónna jai”? Ko ixra̱ meꞌe juixin ntiꞌi ixi jaña tsónna. ");
INSERT INTO pps_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Cháña xrondachrja̱n: “Ndotána, tsjakonta juachaxin ijié chonda ngajin chujni nunte ntiꞌi.” Hora meꞌe kuinꞌen na̱ nichja naa tée ngajní ko ndachro: ―Ó juexin juako juachaxinna ko íjngo sintaꞌa meꞌe. ");
INSERT INTO pps_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Ko ni ste ntiꞌa stetinꞌen na̱, méxin, ndachro na̱ jitjatee ngajní, ko ikaxin na̱ ndachro na̱: ―Naa ndo ángel nichjeꞌe ndo. ");
INSERT INTO pps_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Ko ndachro ndo Jesús: ―Tée kuinꞌennta, kui̱xi̱n ngajní ixi tsitikaonntana. ");
INSERT INTO pps_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Ko jai ndo Dio sinchéña ndo ijie̱ ngajin chujni nunte xasintajni, ko jai Xixronꞌanxrée tetuanꞌan xa nunte xasintajni tsachrjexin xa ntiꞌi. ");
INSERT INTO pps_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Ko nchakon tsakeꞌe nganito nta̱cru, kueya na̱ tsikon na̱ ko tsitikaonna na̱. ");
INSERT INTO pps_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Jaña ndachro ndo ixi jichrónga ndo xranchi tsenxin ndo. ");
INSERT INTO pps_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Ko juateꞌe ni ste ntiꞌa: ―Kuinꞌanna ndachro xroon tsikjin sen saꞌó ixi ndo Cristo kain nchakon tsechón ndo ko, ¿sonda ndachrua jaꞌa ixi Chjenꞌen ndo Dio, xjan jongíꞌe xranchi chujni, xrokonda tsakeꞌe na̱ xjan nganito nta̱cru? ¿Ngisen Chjenꞌen ndo Dio ikjan xranchi Chujni? ");
INSERT INTO pps_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Ko ndachro ndo Jesús: ―Xratsakeꞌe xroꞌi ngajinnta, ko jeꞌo kaxion nchakon. Tajinta ixi xrachondanta xroꞌi jiꞌi ixi sintaxronkaꞌinta ti naxixeꞌe. Ixi ngisen taji ti naxixeꞌe tikonꞌa na̱ no taji na̱. ");
INSERT INTO pps_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Titikaonnta xroꞌi tingasáña ixi ngajinnta jii xroꞌi ixi xrokjannta chujni jian chónda xroꞌi. Ko juexin ndachro ndo Jesús jiꞌi, tjumeꞌe sakjui ndo kuemá ndo. ");
INSERT INTO pps_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Maski ndo Jesús tsijincheꞌe ndo kueya ixra̱ ijié ngato ikon na̱, kuitikaonꞌa na̱ ndo ");
INSERT INTO pps_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","ixi xrokonda jaña tsonꞌen xranchi ngeꞌe tsikjin ndo Isaías saꞌó: Ncháina, ¿ngisen titikaon ngeꞌe nichjana? ¿Ngisen juinchenoꞌe ndo Dio juachaxien ndo? ");
INSERT INTO pps_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Méxin, kuitikaonꞌa na̱ ndo Jesús ixi kaxon tsikjin ndo Isaías: ");
INSERT INTO pps_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Ndo Dio kuajon ndo juachaxin ixi tsikonꞌa na̱ ko juinchecha ndo aséen na̱, ixi tsikonxinꞌa na̱ ikon na̱, ko tsienxinꞌa na̱ ixi aséen na̱, ko xrokjanꞌi na̱ ngaji̱n ixi sintaxruanꞌan na̱. ");
INSERT INTO pps_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Jaña tsichro ndo Isaías saꞌó ixi tsikikon ndo juachaxin ijié chónda ndo Jesús ko nichja ndo ixi jeꞌe ndo. ");
INSERT INTO pps_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Ko kueya ni judío tetuanꞌan kuitikaon na̱ ndo Jesús, ko bachrongaꞌi na̱ ixi ó kuitikaon na̱ ndo ixi xrakonꞌen na̱ xi fariseo, ixi jeꞌe xa xrokuantsjexin xa na̱ ningue ni judío. ");
INSERT INTO pps_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Ixi jeꞌe na̱ ícha bancheꞌe na̱ juaxruxin bakayéꞌe na̱ juasaya tajon chujni ixi juasaya tajon ndo Dio. ");
INSERT INTO pps_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Ko ndo Jesús séen ndachro ndo: ―Ngisen titikaonna, jeꞌa jeꞌo janꞌan titikaonna sen, kaxon titikaon sen Ndotána, ndo xruanꞌanna juiꞌi. ");
INSERT INTO pps_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Ko ngisen tikonna kaxon tikon sen ndo tsixruanꞌanna. ");
INSERT INTO pps_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Janꞌan xroꞌi kui̱i̱ nunte xasintajni ixi sen titikaonna tsakeꞌa sen ti naxixeꞌe. ");
INSERT INTO pps_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Ko xrojan ngisen tinꞌen ngeꞌe ndachrja̱n ko tsitikaonꞌana na̱, jeꞌa janꞌan tsjankataꞌa na̱ ijie̱. Ixi janꞌan juiꞌa tsjankataꞌa jíee chujni nunte ntiꞌi. Naꞌi. Juiꞌi tsingijna na̱ ixi tsitjáñaꞌi na̱. ");
INSERT INTO pps_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Ko chujni titikaonꞌana ko titikaonꞌa chijnina ó jii ngisen tsjankataꞌa na̱ ijie̱. Chijni nichja meꞌe chijni sinchéña ijie̱ ngajin na̱ nchakon tsjexixin nunte xasintajni. ");
INSERT INTO pps_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Ixi janꞌan nichjaxinꞌa janꞌon. Naꞌi. Ndotána, ndo tsixruanꞌanna, kuetuanna ngeꞌe xronichja ko ngeꞌe sintakuanꞌan chujni. ");
INSERT INTO pps_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Ko nóna ixi ti kuetuanꞌan Ndotána meꞌe tajon juachaxin tsechón chujni kain nchakon. Méxin, kain ngeꞌe ndachrja̱n, Ndotána kuetuanna xronichja. ");
INSERT INTO pps_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Titjáña naa nchakon tsi̱i̱ kia pascua ko ndo Jesús ó noꞌe ndo kuiji hora satsjixin ndo nunte xasintajni, ko satsji ndo ti Ndotée ndo. Kain nchakon tjueꞌe ndo sen chujnie ndo ste nunte xasintajni, ko jai ícha tjakoxin ndo ixi tjueꞌe ndo sen. ");
INSERT INTO pps_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Ko ó kui̱i̱ hora sine sen tsokjín, ko Xixronꞌanxrée ó tsixraxinꞌin xa aséen xi Judas Iscariote, ndotée xa ndatinꞌin Simón, sinchekji xa ndo Jesús. ");
INSERT INTO pps_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Ndo Jesús noꞌe ndo ixi tsiki̱xi̱nꞌin ndo ti jii ndo Dio ko ti no xrokjan ndo. Ko noꞌe ndo ixi Ndotée ndo kuajon ndo juachaxin tsetuenꞌen ndo kain ngeꞌe. ");
INSERT INTO pps_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Tjumeꞌe bingatjen ndo ti no stene sen ko kuantsje ndo manta jitsáa ndo, ko kua ndo naa manta xemaxinni, ko bingatóxin ndo manta. ");
INSERT INTO pps_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Ko bikia ndo inda ngaya naa tjatuꞌo, ko kuaxi ndo junéꞌma ndo tutée ngujngu sen chrikao ndo, ko juinchexemaxin ndo ixi manta jingatoxin ndo. ");
INSERT INTO pps_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Ko hora kuiji ndo ti jii ndo Pedro, ndo Pedro ndachro ndo: ―Nchána, ¿á jaꞌanta sinémanta tutéena? ");
INSERT INTO pps_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Ko juatingíexin ndo Jesús: ―Jai tienxinꞌa ngeꞌe rintaꞌa. Tjumeꞌe tsienxian sonda rintaꞌa jiꞌi. ");
INSERT INTO pps_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Ko ndachro ndo Pedro: ―Naiꞌa sinémanta tutéena. Ko ndachro ndo Jesús: ―Siá sinémaꞌi tutáa, ningeꞌo tsikinixinꞌa ngaji̱n. ");
INSERT INTO pps_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Ko juateꞌe ndo Simón Pedro: ―Naꞌi, Nchána. Jeꞌa jeꞌo tutéena néꞌmanta. Kaxon néꞌmanta tjáana ko jáana. ");
INSERT INTO pps_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Ko ndo Jesús ndachro ndo: ―Ngisen tsikengi xrokondaꞌi tsengi sen íjngo. Jeꞌo tutée sen tsijma ixi nchijíi sen tjúá sen. Ko jaꞌanta tjúánta, maski jeꞌa kainnta. ");
INSERT INTO pps_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Ndachro ndo Jesús jeꞌa kainnta tjúánta, ixi noꞌe ndo ngisen xrojuinchekji ndo. ");
INSERT INTO pps_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","*Juexin junéꞌma ndo tutée kain sen, tjumeꞌe itsé ndo mantée ndo, manta jitsáa ndo, ko ikjan ndo bakeꞌe ndo nunte ti no stene sen ko ndachro ndo: ―¿Á tienxinnta ngeꞌe juintaꞌa? ");
INSERT INTO pps_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Jaꞌanta tiyaꞌnantana ngisen tjakoꞌanta ko Ncháanta, ko ndako ndachronta ixi janꞌan ngisen meꞌe. ");
INSERT INTO pps_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Siá janꞌan ngisen tjakoꞌanta ko Ncháanta janꞌan, ko junéꞌma tutáanta, kaxon jaña jaꞌanta xrojuinémeꞌe kichuunta tutáanta. ");
INSERT INTO pps_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Ixi janꞌan juako xranchi juintaꞌa, kaxon jaꞌanta sincheꞌenta jaña. ");
INSERT INTO pps_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","*Naa ngeꞌe nduaxin ntatjunta ixi ni ncheꞌe ixra̱, jeꞌa ícha tjintee na̱ ixi ni xrée, ko ninaa ngisen tikao naa juajna, tjinteꞌa na̱ ícha ixi ni tsixruaꞌan juajna. ");
INSERT INTO pps_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Siá tienxinnta ko siá sincheꞌenta jiꞌi, juaxruxin tsakeꞌenta. ");
INSERT INTO pps_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","’Jeꞌa ixi kainnta ndachrja̱n jiꞌi. Janꞌan nóna ngisen kuinchaꞌa. Ko xrokonda tsonꞌen xranchi tsikjin sen saꞌó: “Ngisen nekiꞌan, ni meꞌe tsingaxiton na̱ ngaji̱n.” ");
INSERT INTO pps_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Janꞌan ntatjunta ixi nchakon tsonꞌen jiꞌi, jaꞌanta tsitikaonnta ixi janꞌan ngisen ntatjunta ngisen najanꞌan. ");
INSERT INTO pps_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","*Naa ngeꞌe nduaxin ntatjunta, ixi ngisen tayéꞌe naa sen xruanꞌan janꞌan, kaxon janꞌan tayéꞌena sen, ko ngisen tayéꞌena janꞌan, tayéꞌe sen ngisen tsixruanꞌanna juiꞌi. ");
INSERT INTO pps_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Ko juexin ndachro ndo Jesús jiꞌi, tsango koniꞌe aséen ndo ko ndako ichro ndo: ―Nduaxin ntatjunta ixi naa jaꞌanta sinchekjintana. ");
INSERT INTO pps_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Ko sen teyuu chrikao ndo kuaxi tsjeꞌe kichuu sen ixi noeꞌa sen ngisen sincheꞌe ti ndachro ndo. ");
INSERT INTO pps_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Ko naa ndo chrikao ndo Jesús, ndo meꞌe ndo Jesús tsango tjueꞌe ndo, jii ndo nunte tjenka ndo Jesús ti no stene sen. ");
INSERT INTO pps_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Ko ndo Simón Pedro jinchetengi ndo ndo meꞌe ixi tjanchangíꞌe ndo ndo ngisen sincheꞌe ti ndachro ndo Jesús. ");
INSERT INTO pps_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Tjumeꞌe jeꞌe ndo konchjiñeꞌe ndo ti jii ndo Jesús, ko juanchangi ndo: ―Ncháina, ¿ngisen sincheꞌe meꞌe? ");
INSERT INTO pps_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Juateꞌe ndo Jesús: ―Ngisen xrotjáꞌa tuꞌo nutja tsikontjao, meꞌe jeꞌe xa. Méxin, juinchetjao ndo tuꞌo nutja ko kuajon ndo ngajin xi Judas Iscariote, chjenꞌen ndo Simón. ");
INSERT INTO pps_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Ko kuayéꞌe xi Judas nutja, ko tuinxin Xixronꞌanxrée kuixinꞌin xa aséen xi Judas. Ko ndo Jesús ndache ndo xa: ―Ngeꞌe sincheꞌe, jaiko xakonꞌan ncheꞌe meꞌe. ");
INSERT INTO pps_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Ko ninaa sen stene ntiꞌa kuienxin sen sonda jaña ndachro ndo. ");
INSERT INTO pps_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Kaxin sen xraxaon sen ixi xi Judas tsjeꞌe xa ti jitjinga tomi, méxin ndo Jesús kuetuenꞌen ndo xa ixi tsikeꞌna xa ngeꞌe ixi ó tsi̱i̱ kia, o̱ xrokuajon xa ngeꞌe ngajin ni nóa. ");
INSERT INTO pps_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Juexin kuayéꞌe xi Judas nutja, tuinxin kuachrje xa ko ó tiie meꞌe. ");
INSERT INTO pps_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Ko ó juexin satsikji xi Judas, ndachro ndo Jesús: ―Jai tsonoxin juachaxien Chjenꞌen ndo Dio, xjan jongíꞌe xranchi chujni, ko tsjakoxin ndo juachaxin ijié chónda ndo Dio. ");
INSERT INTO pps_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Siá Chjenꞌen ndo Dio, xjan jongíꞌe xranchi chujni, tsjakoxin ndo juachaxin neꞌe ndo Dio, ko meꞌe jaña ndo Dio tsjakoxin ndo juachaxin chónda Chjenꞌen ndo, ko tuinxin tsonꞌen meꞌe. ");
INSERT INTO pps_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","*Chjanꞌna, xranaanchion tsakeꞌe ngajinnta ntiꞌi. Tjéentana ko xranchi ntatjan ni judío, jaña ntatjunta kaxon: Ti no itsji janꞌan, juaꞌi itsjinta. ");
INSERT INTO pps_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","*Naa ngeꞌe natjúá tetuanꞌannta ixi xrotjueꞌenta kichuunta xranchi janꞌan tjuaꞌanta. ");
INSERT INTO pps_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Jiꞌi tsjakoxin ngajin kain ni xasintajni ixi jaꞌanta chujninanta siá xrotjueꞌenta kichuunta. ");
INSERT INTO pps_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Tjumeꞌe juanchangiꞌe ndo Simón Pedro ndo Jesús: ―Nchána, ¿no itsjinta? Ko juateꞌe ndo Jesús: ―Ti no satsji, juaꞌi itsjia jai. Ko tjumeꞌe xroruana̱na ntiꞌa. ");
INSERT INTO pps_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Ko ndachro ndo Pedro: ―¿Sonda juaꞌi xroruaꞌa jai? Janꞌan chao tsenxinna ixi jaꞌanta. ");
INSERT INTO pps_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Ko ndo Jesús juateꞌe ndo: ―¿Á nduaxin tsenxian ixi janꞌan? Nduaxin ntatjua xraxrotsje̱ꞌa kuntaxichíká, níi xrondachrua chuxinꞌana. ");
INSERT INTO pps_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","’Taꞌinta juachjaon. Titikaonnta ndo Dio, titikaonntana janꞌan kaxon. ");
INSERT INTO pps_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Ndoꞌa Ndotána kueya nchia jii. Ko siá jeꞌa xrobakeꞌe nchia, janꞌan xrontatjunta. Méxin, satsji, sintakonchjian no tsakeꞌenta. ");
INSERT INTO pps_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Ko siá satsji ko sintakonchjian no tsakeꞌenta, tsjiꞌi íjngo, ko tsjiruaꞌanta ixi ti no tsakeꞌe janꞌan kaxon jaꞌanta tsakeꞌenta ntiꞌa. ");
INSERT INTO pps_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Jaꞌanta noꞌanta no itsji ko noꞌanta chaꞌo. ");
INSERT INTO pps_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Ko juateꞌe ndo Tomás: ―Ncháina, nónaꞌina ti no itsjia. ¿Xranchi xrokonóna chaꞌo meꞌe? ");
INSERT INTO pps_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Ko ndachro ndo Jesús: ―Janꞌan chaꞌo ko janꞌan chijni nduaxin ko janꞌan tsajon juachaxin stechón chujni. Xroꞌan ngisen itji ti jii Ndotána siá tsjixinꞌa sen ixi janꞌan. ");
INSERT INTO pps_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Siá chuxinntana, kaxon xrochuxinnta Ndotána ko ó chuxinnta ndo jai ko ó bikonta ndo. ");
INSERT INTO pps_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Ko ndachro ndo Felipe: ―Nchána, tjakoꞌna̱na Ndotáa. Meꞌó tjaꞌonna. ");
INSERT INTO pps_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Ko ndo Jesús ndachro ndo: ―Felipe, ó itsjé nchakon ritjén ngajinnta, ¿ko xrachuxinꞌana? Ngisen bikona ó bikon Ndotána kaxon. ¿Sonda ndachrua jaꞌa ixi tsjakoꞌa Ndotána? ");
INSERT INTO pps_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","¿Á titikaonꞌanta ixi janꞌan riníi Ndotata, ko Ndotata jii ndo ngaji̱n? Ti ngeꞌe nichja janꞌan jeꞌa ti tjaꞌon nichja. Naꞌi. Ko Ndotána ndo jii ngaji̱n, jeꞌe ndo ncheꞌe ndo ixra̱. ");
INSERT INTO pps_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Titikaonnta ixi janꞌan ritjén ngajin Ndotána, ko Ndotána jii ndo ngaji̱n. Maski titikaonꞌanta jiꞌi, tsitikaonxinnta ixi ti ixra̱ ijié juintaꞌa ko ngeꞌe bikonta. ");
INSERT INTO pps_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Naa ngeꞌe nduaxin ntatjunta siá nduaxin tsitikaonnantana, ti juintaꞌa kaxon jaꞌanta chao sincheꞌenta kain meꞌe ko kaxon ixra̱ ícha ijié ngeꞌe sincheꞌenta ixi janꞌan satsji ti jii Ndotána. ");
INSERT INTO pps_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Kain ngeꞌe tsjancheꞌenta Ndotána ixi nombréena, janꞌan sintaꞌa ixi jaña tsjako juachaxien Ndotána. ");
INSERT INTO pps_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Siá xrojan ngeꞌe tsjanchaxinnta nombréena, janꞌan tsajon. ");
INSERT INTO pps_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","’Siá nduaxin tjuananta, titikaonnta ngeꞌe kuetuanꞌannta. ");
INSERT INTO pps_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Ko janꞌan tsinóatáana ngajin Ndotána ixi xroxruanꞌan ndo Espíritue ndo ixi tsingijnanta ko tsajon ndo juachaxin tsakeꞌe juaxruxin asáanta ko Espíritue ndo tsakeꞌe ngajinnta kain nchakon, ");
INSERT INTO pps_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Espíritu nduaxin. Ti ni nunte xasintajni juaꞌi tsayéꞌe na̱ Espíritu ko chúxinꞌa na̱ Espíritu. Ko jaꞌanta chuxinnta Espíritu ixi ngajinnta jii ndo ko jeꞌe ndo tsituꞌe ndo ngajinnta kain nchakon. ");
INSERT INTO pps_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Janꞌan tsintuaꞌinta nóanta ko jaꞌonta; xrokjanna íjngo ixi tsakeꞌe ngajinnta. ");
INSERT INTO pps_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Ko ítsjéꞌa nchakon chujni nunte xasintajni tsikonꞌana̱na. Ko jaꞌanta tsikonntana ixi jaꞌanta tsaricho̱nnta ixi janꞌan rícho̱n. ");
INSERT INTO pps_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Ko nchakon meꞌe tsonoꞌanta ixi janꞌan ko Ndotána naakuana ko jaꞌanta ko janꞌan naakuana kaxon. ");
INSERT INTO pps_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Ngisen noꞌe ko titikaon ngeꞌe kuetuanꞌan, sen meꞌe tjuaꞌna. Ko sen tjuaꞌna, Ndotána kaxon xrotjueꞌe ndo sen, kaxon janꞌan tjuaꞌa sen ko tsichuxinna sen. ");
INSERT INTO pps_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Ko xi Judas, jeꞌa xi Iscariote, ndache xa ndo: ―Ncháina, ¿sonda janꞌanna xrochuxiana ko ikaxin ni nunte xasintajni, naꞌi? ");
INSERT INTO pps_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Ko juateꞌe ndo Jesús ndachro ndo: ―Ngisen tjuaꞌna, sen meꞌe titikaon ngeꞌe tituanꞌan. Ko Ndotána xrotjueꞌe ndo sen, ko Ndotána ko janꞌan tsjiꞌina tsinteena ngajin sen. ");
INSERT INTO pps_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Ko ngisen tjaunꞌana, ni meꞌe titikaonꞌa na̱ ngeꞌe ndachrja̱n. Ko ngeꞌe chijni tinꞌennta, jeꞌa chijnina. Naꞌi. Jiꞌi chijnie Ndotána, ndo xruanꞌanna juiꞌi. ");
INSERT INTO pps_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","’Rintatjunta kain jiꞌi ixi xraritjén ngajinnta. ");
INSERT INTO pps_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Ko Espíritue Ndotána, xroxruanꞌan ndo juachaxin ixi nombréena, ixi tsingijnanta, ko xronichjaꞌanta ndako ko tsjakoꞌanta kain ngeꞌe ko sintaxraxaonnta kain ngeꞌe ntatjunta. ");
INSERT INTO pps_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","’Juaxruxin tintoꞌanta ko juaxruxin tajon ngajinnta. Jeꞌa xranchi juaxruxin tajon ni nunte xasintajni. Naꞌi. Xrakonꞌanta ko taꞌinta juachjaon. ");
INSERT INTO pps_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Ó kuinꞌennta ngeꞌe ndachrja̱n, satsji ko xrokjanna íjngo ko tsakeꞌe ngajinnta. Siá nduaxin tjaunnanta, juaxruxin xrobakeꞌenta ixi noꞌanta satsji ti jii Ndotána ixi ícha tetuanꞌan jeꞌe ndo ixi najanꞌan. ");
INSERT INTO pps_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Saꞌó ntatjunta jiꞌi ixi nchakon tsikonnta tsonꞌen, tsitikaonnta. ");
INSERT INTO pps_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","’Ko séꞌa xronichjana jai ixi jiti̱i̱ Xixronꞌanxrée, xi tetuenꞌen chujni nunte xasintajni. Ko jeꞌe xa xroꞌan ngeꞌe tetuenꞌen xa ngaji̱n. ");
INSERT INTO pps_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Ko xrokonda jaña tsonꞌen ixi chujni nunte xasintajni tsonoꞌe na̱ ixi janꞌan tjuaꞌa Ndotána ko titikaꞌon ngeꞌe tetuanna ndo. Ko jai tingatjennta sachjinxina ntiꞌi. ");
INSERT INTO pps_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","’Janꞌan meꞌe xranchi naa viña jichón ko Ndotána xranchi ngisen tayakonꞌen nta̱a̱. ");
INSERT INTO pps_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Tsonchrijin ndo chaan nta̱a̱ tajonꞌa itu ko tsameꞌe ndo nta̱a̱ ko tayakonꞌen ndo nta̱a̱ ixi ícha itsjé itu tsajon nta̱a̱. ");
INSERT INTO pps_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Ko jaꞌanta ó tjúá asáanta ixi chijni tjáꞌanta. ");
INSERT INTO pps_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Takeꞌénta ngaji̱n xranchi janꞌan ritjén ngajinnta. Xranchi chaan nta̱a̱ juaꞌi jeꞌo chaan nta̱a̱ tsajon itu siá jitseꞌa kichuu nta̱a̱, jaña jaꞌanta kaxon juaꞌi sincheꞌenta ngeꞌe siá steꞌanta ngaji̱n. ");
INSERT INTO pps_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","’Janꞌan nta̱a̱ ijié tajon tu uva, ko jaꞌanta chaan nta̱a̱. Ngisen jitséxin najanꞌan ko janꞌan ngajin sen tsajon sen kueya itu ixi jaꞌanta juaꞌi sincheꞌenta naa ngeꞌe siá ritjénꞌa ngajinnta. ");
INSERT INTO pps_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Ko ngisen jitseniꞌa janꞌan, ni meꞌe jii na̱ xranchi chaan nta̱a̱ tjankana ndáꞌa ixi xroxema nta̱a̱ ko tsjaaka na̱ nta̱a̱. ");
INSERT INTO pps_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","’Ko siá jaꞌanta steniintana, ko xrotjáñaꞌinta ngeꞌe juintakuanꞌannta, tjanchianta ngeꞌe tjaunnta ko tsayeꞌenta. ");
INSERT INTO pps_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Ndotána tayéꞌe juasaya siá jaꞌanta tájonnta itsjé itu. Ko jaña tsjakoxinnta ixi titikaonntana. ");
INSERT INTO pps_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Janꞌan tsango tjuaꞌanta xranchi Ndotána tjuaꞌna. Tintueꞌanta ti tjuaꞌanta janꞌan. ");
INSERT INTO pps_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Siá tsitikaonnta ti kuetuanꞌannta, tsonoꞌanta ixi tjuaꞌanta xranchi kaxon janꞌan titikaꞌon ngeꞌe kuetuanna Ndotána ko nóna ixi jeꞌe ndo tjuaꞌna ndo. ");
INSERT INTO pps_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","’Jaña nichjaꞌanta ixi tsakeꞌenta juaxruxin ngaji̱n ko juaxruxin tsakeꞌe asáanta. ");
INSERT INTO pps_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","*Ti tetuanꞌannta meꞌe jiꞌi: tjueꞌenta kichuunta xranchi janꞌan tjuaꞌanta. ");
INSERT INTO pps_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Ngisen ícha tjueꞌe naa ngisen, ba tsenꞌen sen ixi ngisen tjueꞌe sen. ");
INSERT INTO pps_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Jaꞌanta chujni tjento siá tsitikaonnta ti tetuanꞌannta. ");
INSERT INTO pps_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Ítiyaꞌinta ni ncheꞌe ixra̱, ixi chujni ncheꞌe ixra̱ noeꞌa sen ngeꞌe ncheꞌe xi tetuenꞌen sen. Ko jaꞌanta chujni tjentona ixi kain ngeꞌe juinchekuanna Ndotána, juintanoꞌanta. ");
INSERT INTO pps_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Kuincheꞌantana jaꞌanta. Janꞌan kuinchaꞌanta ko kuinóatáana ngajinnta ixi itsjinta ko tájonnta itsjé itu ko tsitjáñaꞌi tu. Ko jaña Ndotána xrotjáꞌanta ndo kain ngeꞌe tsjanchiaxinnta nombréena. ");
INSERT INTO pps_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Jaña tetuanꞌannta ixi xrotjueꞌenta kichuunta. ");
INSERT INTO pps_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","’Siá ni nunte xasintajni toñaoꞌanta, noꞌanta ixi janꞌan ningakonna na̱ saꞌó. ");
INSERT INTO pps_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Siá jaꞌanta xrokjuinta chujni nunte xasintajni, ni nunte xasintajni xrotjuaꞌanta na̱ ixi xrakichuunta na̱. Ko janꞌan kuinchaꞌanta ngakjenꞌen ni nunte xasintajni. Ko méxin, ni nunte xasintajni ningakonꞌannta na̱ ixi í jeꞌanta chujni nunte xasintajninta. ");
INSERT INTO pps_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","*Xraxaonnta ngeꞌe ntatjunta ixi ni naa xi ncheꞌe ixra̱ tetuanꞌan ícha ixi xi xrée. Siá ningakonna na̱ ko ruaꞌna na̱, jaña xroruaꞌanta na̱ kaxon. Ko siá kuitikaon na̱ ngeꞌe juintakuanꞌan na̱, meꞌe kaxon tsitikaonnta na̱ ngeꞌe tsjakoꞌenta na̱. ");
INSERT INTO pps_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Kain jiꞌi sintaꞌanta na̱ kondeexin janꞌan ixi titikaonntana ko ixi chúxinꞌa na̱ ngisen xruanꞌanna juiꞌi. ");
INSERT INTO pps_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","’Siá xrojuiꞌa ntiꞌi ko xronichjaꞌi ngajin na̱, jeꞌe na̱ xrochóndaꞌi na̱ ninaa ijie̱. Ko jai juaꞌi xrondachro na̱ ixi noeꞌa na̱ ko chóndaꞌi na̱ ijie̱. ");
INSERT INTO pps_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Ni ningakonna, ni meꞌe ningakonꞌen na̱ Ndotána kaxon. ");
INSERT INTO pps_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Jeꞌe na̱ xrochóndaꞌi na̱ ijie̱ siá xrojuintaꞌi ngeꞌe ti ninaa ngisen juincheꞌe saꞌó. Ko jai ó bikon na̱ kain ngeꞌe juintaꞌa, ko maski bikon na̱, ningakonna na̱ ko kaxon ningakonꞌen na̱ Ndotána. ");
INSERT INTO pps_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Ko jaña tonꞌen ixi xrokonda tsonꞌen ngeꞌe ndachro ley neꞌe na̱: “Ningakonna na̱ maski xroꞌan ijie̱ chonda.” ");
INSERT INTO pps_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Ko nchakon tsi̱i̱ ngisen tsingijna, meꞌe Espíritue ndo Dio nduaxin, xroxruanꞌan janꞌan ixi juachaxien Ndotána ko jeꞌe ndo xronichjaxinna ndo. ");
INSERT INTO pps_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Ko jaꞌanta kaxon xronichjaxinntana ixi ngaji̱n ritjennta xraxrangíxixión juakoꞌanta. ");
INSERT INTO pps_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","’Kain jiꞌi ntatjunta ixi tsintueꞌanta ngeꞌe juintakuanꞌannta. ");
INSERT INTO pps_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Ni judío tsajonꞌa na̱ juachaxin tsixinꞌinnta niꞌngo ko tsiji nchakon ixi ni naatsóñaxónnta xroxraxaon na̱ ixi ti ncheꞌe na̱ meꞌe naa xrée ndo Dio. ");
INSERT INTO pps_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Jaña sincheꞌe na̱ ixi chúxinꞌa na̱ Ndotána ko chúxinꞌa na̱ najanꞌan. ");
INSERT INTO pps_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Ko ntatjunta kain jiꞌi ixi nchakon jaña tsonꞌen, xroxraxaonnta ixi ó ntatjunta saꞌó jaña tsonꞌen. ’Ti xrangíxixión ntatjuꞌinta jiꞌi ixi bakeꞌe ngajinnta. ");
INSERT INTO pps_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Ko jai satsji ti jii ngisen xruanꞌanna juiꞌi. Ko ninaánta tjanchangínta no satsji ");
INSERT INTO pps_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","ixi tsango jitoniꞌe asáanta ixi ntatjunta kain jiꞌi. ");
INSERT INTO pps_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Nduaxin, cháña satsji ixi jaꞌanta jian tsakeꞌenta. Ko siá satsjiꞌa tsiꞌa ngisen tsingijnanta. Ko siá satsji, janꞌan xroxruanꞌan ndo tsi̱i̱ ndo. ");
INSERT INTO pps_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Ko nchakon tsi̱i̱ ndo sinchexraxaon ndo chujni nunte xasintajni ixi chónda na̱ ijie̱, ko jii naa chaꞌo ndako xroruéꞌe na̱ ko ndo Dio sinchéñeꞌe ndo na̱ ijie̱. ");
INSERT INTO pps_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Jeꞌe na̱ chónda na̱ ijie̱ ixi titikaonꞌa na̱ ");
INSERT INTO pps_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","ko tsonoꞌe na̱ ixi jii naa chaꞌo jian ko ixi janꞌan satsji ti jii Ndotána ko ítsikonꞌantana, ");
INSERT INTO pps_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","ko tsonoꞌe na̱ ixi ndo Dio sinchéña ndo ijie̱ ixi ó juexin juinchéña ndo ijie̱ ngajin Xixronꞌanxrée, xi tituenꞌen nunte xasintajni. ");
INSERT INTO pps_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","’Xrarichonda itsjé ngeꞌe xrontatjunta, ko jai juaꞌi tsienxinnta. ");
INSERT INTO pps_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Nchakon tsi̱i̱ Espíritue ndo Dio nduaxin, jeꞌe ndo sintakuanꞌannta ndo kain ngeꞌe nduaxin ixi jeꞌa ngeꞌe tjaun ndo xrontatjunta ndo. Naꞌi. Xrontatjunta ndo kain ngeꞌe tsinꞌen ndo ko sintanoꞌanta ndo ngeꞌe tsonꞌen. ");
INSERT INTO pps_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Jeꞌe ndo tsajon ndo juasaya ngajin janꞌan ixi tsayéꞌe ndo kain chijnina ko ngeꞌe tikinixinna ko sintanoꞌanta ndo kain jiꞌi. ");
INSERT INTO pps_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Kain ngeꞌe chónda Ndotána naꞌna kaxon. Méxin, ndachrja̱n ixi Espíritue ndo Dio tsayéꞌe ndo ngeꞌe tikinixinna ko tjumeꞌe sintanoꞌanta ndo kain jiꞌi. ");
INSERT INTO pps_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","’Xra íseꞌa í tsikonꞌantana. Ko kaxon íseꞌa tsikonntana íjngo ixi satsji ti jii Ndotána. ");
INSERT INTO pps_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Ko kaxin sen chrikao ndo ndache kichuu sen: ―¿Ngeꞌe xrondachro jiꞌi ixi íseꞌa tsikonna ndo ko kaxon séꞌa tsikonna ndo íjngo ixi satsji ndo ti jii Ndotée ndo? ");
INSERT INTO pps_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","¿Ingeꞌe tjaun ndo xrondachro ndo ixi: “íseꞌa”? Tianxinꞌana ngeꞌe ndachro ndo. ");
INSERT INTO pps_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Ko konoꞌe ndo Jesús ngeꞌe tjaun sen tsjanchangíꞌe sen ndo ko ndache ndo sen: ―Janꞌan ntatjunta ixi íseꞌa ítsikonꞌantana ko kaxon séꞌa tsikonntana íjngo. ¿Á jiꞌi ritjanchiangíꞌe kichuunta? ");
INSERT INTO pps_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Nduaxin ntatjunta ixi tsango xrotsjanganta ko tsoniꞌe asáanta, ko ni nunte xasintajni tsakeꞌe na̱ juaxruxin. Ko maski tsango tsoniꞌe asáanta ko tjumeꞌe xrokjan tsakeꞌenta juaxruxin. ");
INSERT INTO pps_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Hora naa nchri sinchejongíꞌe nchra chjenꞌen nchra, tsango tsoniꞌe aséen nchra ixi ó kuiji hora tsjongíꞌe xjan. Ko tjexin tjongíꞌe xjan, tjumeꞌe ísintexiꞌañao nchra juachjaon kuatsinga nchra ixi juaxruxin takeꞌe nchra ixi juinchejongíꞌe nchra naa chjan ngataꞌa nunte xasintajni. ");
INSERT INTO pps_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Jaña jaꞌanta kaxon toniꞌe asáanta jai. Ko tjumeꞌe tsikonntana íjngo ko tsango tsakeꞌe juaxruxin asáanta ko ninaa chujni tsantsjaꞌanta juaxruxin meꞌe. ");
INSERT INTO pps_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","’Nchakon meꞌe xroꞌan ngeꞌe tsjanchangínanta. Nduaxin ngeꞌe ntatjunta. Ixi Ndotána xrotjáanta ndo kain ngeꞌe tsjanchaxinnta nombréena. ");
INSERT INTO pps_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Jaꞌanta xraxroꞌan ngeꞌe tjanchiaxinnta nombréena jai. Ko jai tjanchianta ko tsayeꞌenta, ko tsango tsakeꞌenta juaxruxin. ");
INSERT INTO pps_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","’Ntatjunta jiꞌi jeꞌo xranchi tekini naa ngeꞌe. Ko tsi̱i̱ nchakon ítsekiaꞌinta jaña ixi ndako xrontatjunta ixi Ndotána. ");
INSERT INTO pps_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Nchakon meꞌe tsjanchiaxinnta ngeꞌe nombréena. Ko ndachrja̱nꞌi ixi janꞌan xronichjaxinnta ngajin Ndotána ");
INSERT INTO pps_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","ixi jeꞌe Ndotána tjuaꞌanta ndo. Tjuaꞌanta ndo ixi jaꞌanta tjuananta janꞌan ko ixi titikaonnta ixi janꞌan juixin ti jii jeꞌe ndo. ");
INSERT INTO pps_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Kuachrjexin ti jii Ndotána ixi juiꞌi nunte xasintajni. Ko jai tintuꞌa nunte xasintajni ixi satsji ti jii Ndotána íjngo. ");
INSERT INTO pps_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Tjumeꞌe ndachro sen chrikao ndo: ―Jai ndako ritjakua ko ítjakoxinꞌa ixi xrojan chijni, ");
INSERT INTO pps_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","jai tienxinna ixi noꞌa kain ngeꞌe ko xrokondaꞌi ixi xrojan ngisen tsjanchangiꞌana. Méxin, titikaꞌonna ixi jaꞌa juixian ti jii ndo Dio. ");
INSERT INTO pps_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Ndo Jesús juateꞌe ndo: ―¿Jai ché kuitikaonnta? ");
INSERT INTO pps_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Ko tsi̱i̱ nchakon ko jai hora meꞌe ixi jaꞌanta xrochjeyanta ko satsjinta ko tsintunantana janꞌon. Ko jeꞌa janꞌon ritjén ixi Ndotána jii ndo ngaji̱n. ");
INSERT INTO pps_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Jiꞌi ntatjunta ixi kainnta juaxruxin tsakeꞌe asáanta ixi titikaonntana. Ko ntiꞌi nunte xasintajni tsatsinganta juachjaon, ko xronkaꞌinta ixi janꞌan ó juacha tetuanꞌan nunte ntiꞌi. ");
INSERT INTO pps_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Ó juexin ndachro ndo Jesús kain jiꞌi, tjumeꞌe tsjeꞌe ndo ngajní ko ndachro ndo: ―Ndotána, ó kuiji nchakon. Chje̱ꞌénta Chjanꞌanta juachaxin ixi kaxon Chjanꞌanta xrotjáanta xjan juasaya. ");
INSERT INTO pps_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Ko jaꞌanta chje̱ꞌénta Chjanꞌanta juachaxin ixi tsetuenꞌen xjan kain chujni ko tsajon xjan juachaxin tsechón sen kain nchakon, kain sen tsichjeꞌenta xjan. ");
INSERT INTO pps_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Ko juachaxin chónda sen tsechón sen kain nchakon meꞌe ti xrochuxinnta sen jaꞌanta, ndo naakua ndo Dio nduaxin jichón, ko kaxon xrochuxin sen ndo Jesucristo, ndo tsixruanꞌannta jaꞌanta nunte xasintajni. ");
INSERT INTO pps_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","’Janꞌan tjáꞌanta juasaya ntiꞌi nunte xasintajni ko juexin juintaꞌa ixra̱ kuetuannanta. ");
INSERT INTO pps_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Ko jai Ndotána, chjánanta juachaxin ijié xranchi kuachonda janꞌan nchakon bakeꞌe ngajinnta ti xrakoꞌa nunte xasintajni. ");
INSERT INTO pps_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","’Ó juintenoꞌa sen chjánanta, sen nunte xasintajni, sen tsikincheꞌe jaꞌanta. Jeꞌe sen chujnianta sen ko jaꞌanta chjánanta sen ko janꞌan ó juintakuanꞌan sen chijnianta ko kuitikaon sen. ");
INSERT INTO pps_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Ko jai ó noꞌe sen ixi kain juachaxin chónda janꞌan ti̱ꞌxi̱n ngajinnta. ");
INSERT INTO pps_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Juiꞌi ixi juakoꞌa sen chijnianta chjánanta, ko jeꞌe sen kuitikaon sen, ko kuienxin sen ixi nduaxin janꞌan juixin ngajinnta, ko kuitikaon sen ixi jaꞌanta tsixruanꞌannanta. ");
INSERT INTO pps_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","’Janꞌan tjanchaꞌanta ixi tsingijnanta sen meꞌe. Jeꞌa tjanchaꞌanta ixi tsingijnanta kain chujni nunte xasintajni. Naꞌi. Jeꞌo tjanchaꞌanta ixi sen chjánanta ko ixi jeꞌe sen chujnianta sen. ");
INSERT INTO pps_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Ko kain ngeꞌe chonda jaꞌanta, naꞌna, ko kain ngeꞌe naꞌna, naꞌanta kaxon. Ko méxin, jeꞌe sen tsajon sen juasaya ngaji̱n. ");
INSERT INTO pps_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","’Jai ítsitunaꞌi ntiꞌi nunte xasintajni. Ko jeꞌe sen xratsituꞌe sen ntiꞌi. Ko janꞌan satsji ixi tsakeꞌe ngajinnta. Ndotána jian, tayakonꞌennta ixi juachaxiannta sen chjánanta ixi jeꞌe sen naakua tsakeꞌe sen xranchi janꞌan ko jaꞌanta naakua stena. ");
INSERT INTO pps_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","*Nchakon bakeꞌe ngajin sen ntiꞌi nunte xasintajni, kuayakonꞌan sen ixi juachaxiannta. Ko ninaa sen kuitjáñaꞌi sen. Jeꞌo naakua naa ngisen kuitjáña, ixi xi meꞌe ó tsikitjáña xa ixi jaña tsonꞌen xranchi jitaxin xroon tsikjin sen saꞌó. ");
INSERT INTO pps_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","’Ko jai satsji ti no ritjennta. Ko ixi xraritjén ntiꞌi nunte xasintajni ndachrja̱n jiꞌi ixi tsakeꞌe sen juaxruxin xranchi juaxruxin chónda janꞌan. ");
INSERT INTO pps_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Janꞌan juintakuanꞌan sen chijnianta, ko jai ni nunte xasintajni ningakonꞌen na̱ sen ixi jeꞌe sen jeꞌa chujni nunte xasintajni xranchi janꞌan kaxon jeꞌa chujni nunte xasintajni. ");
INSERT INTO pps_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Tjáncháꞌianta ixi tsantsjexinnta sen nunte xasintajni. Naꞌi. Tjanchaꞌanta ixi tsingijnanta sen ixi Xixronꞌanxrée sincheyeꞌa xa sen. ");
INSERT INTO pps_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Xranchi janꞌan jeꞌa chujnie nunte xasintajni, kaxon jeꞌe sen jeꞌa chujni nunte xasintajni sen. ");
INSERT INTO pps_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Nchetjúáxinnta sen ixi ngeꞌe nduaxin ixi chijnianta chijni nduaxin. ");
INSERT INTO pps_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Xranchi xruanꞌannanta juiꞌi nunte xasintajni, jaña janꞌan xruanꞌan sen itsji sen ngakjenꞌen chujni nunte xasintajni. ");
INSERT INTO pps_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Ixi jeꞌe sen totjúáxinna janꞌan, ko kaxon jeꞌe sen tsontjúáxin aséen sen ixi chijni nduaxin. ");
INSERT INTO pps_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","’Ko jeꞌa jeꞌo tinóatáana ixi jeꞌe sen. Naꞌi. Kaxon tinóatáana ixi tsingijnanta sen tsitikaon ícha tjumeꞌe, nchakon tsinꞌen sen ngeꞌe xronichja jeꞌe sen. ");
INSERT INTO pps_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Tjanchaꞌanta ixi kain sen naakua xroxraxaon sen xranchi jaꞌanta Ndotána ko janꞌan naakua stena, ixi kain chujni nunte xasintajni tsitikaon na̱ ixi jaꞌanta xruanꞌannanta juiꞌi. ");
INSERT INTO pps_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Ó tjáꞌa sen naxra jeꞌo juachaxin ijié xranchi juachaxin chjánanta ixi naakua xroxraxaon sen xranchi janꞌan ko jaꞌanta naakua stena. ");
INSERT INTO pps_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Janꞌan ko jeꞌe sen naakuana xranchi jaꞌanta ko janꞌan naakuana kaxon. Ko jaña chujni nunte xasintajni tsonoꞌe na̱ ixi jaꞌanta xruanꞌannanta juiꞌi ko kaxon tjueꞌenta na̱ xranchi tjaunnanta janꞌan. ");
INSERT INTO pps_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","’Ndotána, jaꞌanta chjánanta sen, ko tjaꞌon ixi tsakeꞌe sen ti no tsakeꞌe janꞌan ixi tsikon sen juachaxin ijié chjánanta; ixi fiaonanta ti xrakoꞌa nunte xasintajni. ");
INSERT INTO pps_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Ndotána, tsango jian jaꞌanta. Chujni nunte xasintajni chúxinꞌa na̱ ngisen jaꞌanta, ko janꞌan ó chuxinnta, ko kain sen chjánanta, kaxon ó noꞌe sen ixi jaꞌanta xruanꞌannanta juiꞌi. ");
INSERT INTO pps_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Ó juintanoꞌa sen ngisen jaꞌanta ko xrasintanoꞌa sen ícha, ixi xranchi jaꞌanta tjaunntana jaña xrotjueꞌe kichuu sen ko janꞌan tsakeꞌe ngajin sen. ");
INSERT INTO pps_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Juexin ndachro ndo Jesús kain jiꞌi, tjumeꞌe kuachrjenkaꞌo ndo sen chrikao ndo ko sakjui sen kuatu inda Cedrón. Ntiꞌa jii naa ijngi ko ntiꞌa ikjui ndo Jesús ko sen chrikao ndo. ");
INSERT INTO pps_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Kaxon xi Judas, xi juinchekji ndo Jesús, chúxin xa ijngi meꞌe ixi ntiꞌa itsjé nchakon baxraka sen chrikao ndo Jesús ko kao jeꞌe ndo. ");
INSERT INTO pps_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Méxin, xi Judas bikaꞌo xa kueya xi soldado ko kaxin xi policía ncheꞌe xra̱ niꞌngo tsixruaꞌan xitaana tetuanꞌan ko xi fariseo. Kuijikao na̱ chika ko xroꞌi tingasáñaxin. ");
INSERT INTO pps_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Ko ndo Jesús ó noꞌe ndo kain ngeꞌe xrokonꞌen ndo, ko konchjiñeꞌe ndo ngajin na̱ ko juanchangiꞌe ndo na̱: ―¿Ngisen tjéenta? ");
INSERT INTO pps_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Ko juateꞌe na̱: ―Tjéena xi Jesús, xi tjajna Nazaret. Ko juateꞌe ndo Jesús: ―Janꞌanna. Ko xi Judas, xi tsijinchekji ndo, ntiꞌa jikao xa na̱. ");
INSERT INTO pps_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Ko hora ndachro ndo Jesús: “Janꞌanna”, jeꞌe na̱ xronka na̱ ko ngaxiton na̱ kuitsinga na̱ nunte. ");
INSERT INTO pps_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Ko íjngo ikjan ndo Jesús juanchangiꞌe ndo na̱: ―¿Ngisen tjéenta? Ko jeꞌe na̱ ndachro na̱: ―Tjéena xi Jesús, xi tjajna Nazaret. ");
INSERT INTO pps_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Ko ndachro ndo Jesús: ―Ntatjunta janꞌan ngisen tjéenta. Ko siá janꞌan ngisen tjéenta, tintuꞌenta satsji sen chrjikiꞌan. ");
INSERT INTO pps_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Jaña ndachro ndo Jesús ixi xrokonda tsonꞌen ti ngeꞌe tsindachro ndo: “Sen chjána Ndotána, xroꞌan ngisen tsitjáña.” ");
INSERT INTO pps_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Ko ndo Simón Pedro kuantsje ndo naa chika espada konchrijinxin ndo ndatsjon naa xi, ndatsjon xa ti jian, xi meꞌe ndatinꞌin xa Malco, xinchexrée xitaana tetuanꞌan. ");
INSERT INTO pps_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","*Ko ndo Jesús ndache ndo ndo Pedro: ―Xraxiꞌian chika espada ña̱. Siá Ndotána kuetuanꞌan ixi tangi tsatsinga, xrokonda tsatsinga janꞌan kain jiꞌi. ");
INSERT INTO pps_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Tjumeꞌe xi soldado ko xi tetuenꞌen xa ko xi policía judío ncheꞌe xra̱ niꞌngo itsé xa ndo Jesús ko kuintee xa ndo. ");
INSERT INTO pps_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Ko sabikao xa ndo ndoꞌa xi Anás, a̱ xi Anás xichée xi Caifás, ngisen nano meꞌe tituenꞌen xitaana. ");
INSERT INTO pps_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","*Ko xi Caifás, xrajeꞌo jeꞌe xa tsindache ni judío ixi ícha jian naakua naa chujni xrokuenxin ixi tjajnée na̱. ");
INSERT INTO pps_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Ndo Simón Pedro ko inaa ndo bakajikao ndo Jesús steruéꞌe sen ndo. A̱ ndo inaa ó chúxin ndo xitaana tituanꞌan. Méxin, kaxon kuixinꞌin ndo no kuixinꞌin ndo Jesús, ngaxinꞌin ndasin ndoꞌa xitaana tituanꞌan. ");
INSERT INTO pps_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Ko ndo Pedro kuituꞌe ndo nduja ti nta̱chja. Ko ndo chúxin xitaana tituanꞌan kuachrje ndo ko nichjeꞌe ndo nchri tendáa nta̱chja ko kuajon nchra juachaxin kuixinꞌin ndo Pedro. ");
INSERT INTO pps_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Tjumeꞌe nchri tendáa nta̱chja juanchangiꞌe nchra ndo Pedro: ―¿Á kaxon jaꞌa chrikuꞌa xi ña̱? Ko juateꞌe ndo Pedro ndachro ndo: ―Naꞌi, janꞌan naꞌi. ");
INSERT INTO pps_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Ko ntiꞌa tsango ikin ko xi ncheꞌe ixra̱ ko xi policía juaaka xa naa xroꞌi ntiꞌa ko siin xa stexraxruꞌe xa. Kaxon ndo Pedro jixraxruꞌe ndo ntiꞌa. ");
INSERT INTO pps_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Ko xitaana tetuanꞌan juangíxin xa juanchangiꞌe xa ndo Jesús ngisen sen chrikao ndo ko ngeꞌe tjako ndo. ");
INSERT INTO pps_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Ko juateꞌe ndo Jesús: ―Janꞌan nichja ngajinxin ikon kain ni nunte xasintajni, ko bajako ngaxinꞌin nchia ko ngaxinꞌin niꞌngo ti no baxraꞌo kain ni judío. Ko xroꞌan ngeꞌe ndachrja̱n imao. ");
INSERT INTO pps_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","¿Sonda tjanchangina̱na? Tjanchangíꞌe ni kuinꞌen xranchi tjako. Jeꞌe na̱ noꞌe na̱ ngeꞌe ndachrja̱n. ");
INSERT INTO pps_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Juexin ndachro ndo Jesús jiꞌi, tjumeꞌe naa xi policía ncheꞌe xra̱ niꞌngo, jindaxin xa ntiꞌa, kuandeꞌe xa naa ito̱n ikon ndo Jesús ko ndachro xa: ―¿Á jaña tjateꞌé ngajin xi tituenꞌen xitaana? ");
INSERT INTO pps_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Ko juateꞌe ndo Jesús: ―Siá ndakoꞌa ndachrja̱n naa ngeꞌe, ndachijiana ngeꞌe ndakoꞌa ndachrja̱n, ko siá ndako ngeꞌe ndachrja̱n, ¿sonda konꞌiana? ");
INSERT INTO pps_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Tjumeꞌe xi Anás xruanꞌan xa ndo Jesús jixriteꞌe ndo ngajin xi Caifás, xitaana tetuanꞌan. ");
INSERT INTO pps_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Ko ndo Pedro xrasiin ndo ntiꞌa jixraxruꞌe ndo, ndache na̱ ndo: ―¿Á kaxon jaꞌa chrikuꞌa xi ña̱? Ko ndo Pedro ndachro ndo chúxinꞌa ndo ndo Jesús, méxin, jaꞌin juateꞌe ndo: ―Naꞌi, janꞌan naꞌi. ");
INSERT INTO pps_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Tjumeꞌe naa xi ncheꞌe xrée xitaana tetuanꞌan, xi meꞌe xrakichuu xa xi tsikonchrijin ndo Pedro ndatsjon, juanchangi xa: ―¿Á jeꞌa jaꞌa bikon rikuꞌa xa ti jii ijngi chónda lahuerta? ");
INSERT INTO pps_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Ko ndo Pedro ndachro ndo íjngo jeꞌa ndo. Ko tuinxin itsje̱ naa kuntaxichíká. ");
INSERT INTO pps_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Kuachrjexin na̱ ndoꞌa xi Caifás, sabikao na̱ ndo Jesús ti nchia ijié tetuanxin xi gobernador. Ko ó kuaxi jitingasáña ko ni judío kuixinꞌa na̱ nchia meꞌe ixi jaña xrokuamaꞌi na̱ ijie̱, ne̱ juaꞌi sine na̱ kia Pascua. ");
INSERT INTO pps_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Tjumeꞌe xi Pilato kuachrjexin xa nchia tetuanꞌan na̱, juanchangiꞌe xa na̱: ―¿Ngeꞌe ijie̱ chónda xi jiꞌi? ");
INSERT INTO pps_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Ko jeꞌe na̱ juateꞌe na̱: ―Siá jeꞌa ndakoꞌa juincheꞌe xa, xrobikianꞌina xi ntiꞌi. ");
INSERT INTO pps_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Ko ndache xi Pilato na̱: ―Satikuꞌunta xa, nchéñeꞌenta xa ijie̱ xranchi jitaxin ley naꞌanta. Ko juateꞌe ni judío: ―Janꞌanna judíona chondaꞌina juachaxin naatsóñaxónna naa ngisen. ");
INSERT INTO pps_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","*Jaña konꞌen xranchi tsindachro ndo Jesús xranchi tsenꞌen ndo. ");
INSERT INTO pps_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Tjumeꞌe xi Pilato íjngo kuixinꞌin xa nchia tetuanxin xa ko kuiyeꞌe xa ndo Jesús ko juanchangiꞌe xa ndo: ―¿Á jaꞌa xi Rey tetuenꞌen ni judío? ");
INSERT INTO pps_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Ko ndachro ndo Jesús: ―Ti ngeꞌe tjanchangina̱na, ¿á jaꞌua xraxaoan jaña?, o̱, ¿á ixi inaa na̱ jaña ndachro na̱? ");
INSERT INTO pps_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Ko juateꞌe xi Pilato: ―¿Á janꞌan judíona? Ni tjajnáa ko xitaana tetuanꞌan bikaan na̱ ngajin. ¿Ngeꞌe juincheꞌe? ");
INSERT INTO pps_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Ko juateꞌe ndo Jesús: ―Juachaxin chónda janꞌan jeꞌa kui̱xi̱n nunte xasintajni. Siá xrokui̱ꞌxi̱n nunte xasintajni, sen chrjikiꞌan xrojuincheꞌe sen ngeꞌe ixi xrotséꞌana ni judío ko juachaxin chónda janꞌan, jeꞌa juachaxin nunte xasintajni. ");
INSERT INTO pps_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Ko ndachro xi Pilato: ―Jaꞌa, ¿á nduaxin naa xi rey? Ko juateꞌe ndo Jesús: ―Jaán, janꞌan rey xranchi jaꞌa ndachrua. Janꞌan juiꞌi nunte xasintajni ixi xronichja ti nduaxin. Kain sen titikaon ngeꞌe nduaxin, sen meꞌe tinꞌen ngeꞌe tjako. ");
INSERT INTO pps_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Ko ndachro xi Pilato: ―¿Ngeꞌe nduaxin ndako, ndachrua? Ko juexin juanchangi xi Pilato jiꞌi, tjumeꞌe kuachrje xa ko ikjui xa ti ste ni judío, ko ndache xa na̱: ―Kuitjaꞌi ninaa ijie̱ ngajin xi jiꞌi. ");
INSERT INTO pps_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Ko jaꞌanta ó xrakuanꞌanta ixi kia pascua tajanda naa chujni jijeꞌe̱. ¿Á tjaunnta tsajanda xi Rey tetuenꞌen ni judío? ");
INSERT INTO pps_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Ko kain na̱ kuyako na̱ ndachro na̱: ―Xi ña̱ naꞌi. Tajanda xi Barrabás. Ko xi Barrabás naa xicheꞌe meꞌe. ");
INSERT INTO pps_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Tjumeꞌe xi Pilato kuetuanꞌan xa ixi tsjaya na̱ ngajin ndo Jesús. ");
INSERT INTO pps_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Ko ni soldado juinchéña na̱ ixi nta̱chaꞌa naa corona ko bakeꞌe na̱ ngataꞌa jaa ndo Jesús. Ko juinchekeya na̱ ndo naa manta tiie játse. ");
INSERT INTO pps_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Ko konchjiñeꞌe na̱ ti jii ndo, ko ndachro na̱: ―Tsechón ndo rey tetuenꞌen ni judío. Ko juanoa na̱ ndo. Ko itja na̱ kuandexin na̱ ikon ndo. ");
INSERT INTO pps_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Ko xi Pilato íjngo kuachrjexin xa nchia tetuanxin xa, ko ndache xa ni tsixraꞌo ntiꞌa: ―Tsjeꞌenta, tsantsje xa ixi tsienxinnta ixi kuitjaꞌi ninaa ngeꞌe ndakoꞌa juincheꞌe xa. ");
INSERT INTO pps_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Ko kuachrjexin ndo Jesús ntiꞌa jitikao ndo ngataꞌa jaa ndo corona tsikoña nta̱chaꞌa ko jitsáa ndo manta tiie játse. Ko ndachro xi Pilato: ―Tsjeꞌenta, ntiꞌi jii xa. ");
INSERT INTO pps_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Ko nchakon bikon ni taana tetuanꞌan ko ni policía neꞌe niꞌngo juangíxin na̱ kuyako na̱: ―¡Tjankanitua xa nta̱cru! ¡Tjankanitua xa nta̱cru! Ko ndachro xi Pilato: ―Jaꞌanta tikuꞌunta xa ko tankanitonta xa nta̱cru ixi janꞌan kuitjaꞌi ninaa ngeꞌe ndakoꞌa ngajin xa. ");
INSERT INTO pps_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Ko juateꞌe ni judío: ―Janꞌanna chondana naa ley xrokonda tsenꞌen xa ixi ndachro xa ixi Chjenꞌen ndo Dio jeꞌe xa. ");
INSERT INTO pps_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Ko nchakon kuinꞌen xi Pilato jiꞌi ícha xronka xa. ");
INSERT INTO pps_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Tjumeꞌe íjngo kuixinꞌin xa nchia tetuanxin xa ko juanchangiꞌe xa ndo Jesús: ―¿No juixian? Ko ndo Jesús xroꞌan ngeꞌe juateꞌe ndo. ");
INSERT INTO pps_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Ko ndachro xi Pilato: ―¿Sonda tjate̱eꞌa? ¿Á noaꞌia ixi janꞌan chonda juachaxin tsetuanꞌan na̱ tankanitua na̱ nta̱cru o̱ kaxon chonda juachaxin tsajanda satsjia ko xroꞌan ngeꞌe tsonꞌan? ");
INSERT INTO pps_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Ko juateꞌe ndo Jesús: ―Xroꞌan juachaxin chónda jaꞌa siá jeꞌa Ndotána Dio xrotjáa ndo juachaxin. Ko chujni bikaana ntiꞌi ícha ijie̱ chónda na̱ ixi jaꞌa. ");
INSERT INTO pps_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Ko kuinꞌen xi Pilato jiꞌi, tjumeꞌe juangíxin xa juée xa xranchi xrobajanda xa ndo Jesús. Ko ni judío kuyako na̱ ndachro na̱: ―Siá tsintuꞌé satsji xa, jaꞌa jeꞌa tjentua xi tetuenꞌen tjajnai̱na. Ngisen nchéña aséen xranchi naa rey, ni meꞌe ningakonꞌen xa xi tituai̱nna. ");
INSERT INTO pps_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Kuinꞌen xi Pilato jiꞌi, tjumeꞌe sabikao xa ndo Jesús nduja ko bakeꞌe xa nunte ti no nchéñaxin na̱ ijie̱ ko kaxon nchekinꞌin na̱ ti kueya ixro ko ngigua aremeo xrondachro Gabatá. ");
INSERT INTO pps_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Nchakon meꞌe naa nchakon saꞌó kia Pascua, ko ó xrochjée ngusine nchakon ko xi Pilato ndache xa ni judío: ―Ntiꞌi jii xi rey tetuanꞌannta. ");
INSERT INTO pps_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Ko jeꞌe na̱ kuyako na̱ ndachro na̱: ―Tsachrje xa, tsachrje xa. Tankanitua xa nta̱cru. Ko xi Pilato ndachro xa: ―¿Á tjaunnta tsjankanito xa nta̱cru xi rey tituanꞌannta? Ko jeꞌe na̱ juateꞌe na̱: ―Xroꞌan xi rey chondana, jeꞌo xi César tituanꞌan. ");
INSERT INTO pps_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Méxin, xi Pilato kuajon xa ndo Jesús ngajin ni judío ko sabikao na̱ ndo tsjankanito na̱ ndo nta̱cru. ");
INSERT INTO pps_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Jaña ndo Jesús kuachrjexin ndo ntiꞌa yama ndo nta̱cru ti no tsjankanito na̱ ndo, noxon chaꞌo itji ti no tinꞌin ntajaa chujni ko ngigua arameo xrondachro Gólgota. ");
INSERT INTO pps_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Ntiꞌa juankanito na̱ ndo nta̱cru, ko kaxon íjngo yuu xi, naa xi bakeꞌe xa ndatsjonxin jian ko inaa xa ndatsjonxin kjon ko ngusine bakeꞌe na̱ ndo Jesús. ");
INSERT INTO pps_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Ko kuetuanꞌan xi Pilato xrokjin na̱ ngataꞌa naa nta̱a̱ ko tsakeꞌe na̱ ti noi nta̱cru ko xrondachro nta̱a̱: “Ndo Jesús, ndo tjajna Nazaret, meꞌe ndo Rey tetuenꞌen ni judío.” ");
INSERT INTO pps_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Ko itsjé ni judío juinchekuanxin na̱ letra tsikoña ixi tjenka tjajna Jerusalén kuenito na̱ ndo Jesús nganito nta̱cru ko níi tée tjajna tsikjin na̱, naa tée hebreo, naa tée griego, naa tée latín. ");
INSERT INTO pps_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Ko ni taana tetuanꞌan ni judío ndache na̱ xi Pilato: ―Kjinꞌa jaꞌa jeꞌe xa “xi Rey tetuenꞌen ni judío”; cháña ikjian “Jeꞌe xa ndachro xa ixi jeꞌe xa xi Rey tetuenꞌen ni judío.” ");
INSERT INTO pps_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Ko juateꞌe xi Pilato: ―Ti kuetuanꞌan xrokjin na̱ ó juexin kóña, ko jaña tsituꞌe. ");
INSERT INTO pps_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Tjumeꞌe ni soldado, hora juexin bakeꞌe na̱ ndo Jesús nganito nta̱cru, kua na̱ mantée ndo Jesús, konchjeya na̱ manta ko noó juinchéña na̱ manta nanaá mantée na̱. Ko kaxon kua na̱ manta jine̱ jiá ndo. Manta meꞌe tsixraunꞌa manta, naakua manta tsikoña meꞌe. ");
INSERT INTO pps_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Ko ni soldado juao kichuu na̱ ndachro na̱: ―Xrochjeyaꞌina manta jiꞌi. Ícha jian xrosondaoxinna ixro ixi jaña tsonoi̱na ngisen tsjacha manta. Jaña konꞌen xranchi ndachro xroon chijnie ndo Dio tsikjin sen saꞌó: “Sondaonxin na̱ ixro ko jaña chjeyeꞌe na̱ mantána.” Jaña juincheꞌe ni soldado. ");
INSERT INTO pps_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Ko tjenka nta̱cru ti no jinito ndo Jesús bakeꞌe janée ndo ko jan kichuu jan, jan María, janchriꞌe ndo Cleofas ko jan María Magdalena. ");
INSERT INTO pps_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Ko nchakon bikon ndo Jesús janée ndo ko tjenka jan jii ndo chrikao ndo, ndo ícha tjueꞌe ndo, ndache ndo janée ndo: ―Tsjeꞌé ntiꞌi jii chjanꞌan. ");
INSERT INTO pps_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Ko tjumeꞌe nichjeꞌe ndo Jesús ndo bajikao ndo, ndo jii tjenka jan, ko ndachro ndo: ―Ntiꞌi jii janáa. Ko ndo meꞌe kuayéꞌe ndo jan, sabikao ndo jan ndoꞌa ndo ko jeꞌe jan ikjan jan xranchi janée ndo. ");
INSERT INTO pps_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Ó noꞌe ndo Jesús ixi kain ixra̱ ó juexin juincheꞌe ndo ko xrokonda tsonꞌen ngeꞌe jitaxin xroon ko ndachro ndo: ―Kuenꞌenna inda. ");
INSERT INTO pps_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Ko ntiꞌa jii naa chikute jitjiá xran tsjá ko jeꞌe na̱ juinchetjao na̱ naa tuꞌo manta kuintsiá na̱ naa nta̱a̱ ko bakeꞌe na̱ tjenka roꞌa ndo. ");
INSERT INTO pps_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Ko ndo Jesús kuiꞌi ndo xran tsjá ko ndachro ndo: ―Ó juexin juintaꞌa kain ngeꞌe kuituanna. Tjumeꞌe kuisée jaa ndo ko kuajon ndo espíritue ndo ko ndakuenꞌen ndo. ");
INSERT INTO pps_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Nchakon meꞌe naa nchakon saꞌó kia Pascua, méxin, ni judío tjaunꞌa na̱ xrokuituꞌe cuerpoe ni tsikenꞌen nganito nta̱cru nchakon tjokéꞌe na̱, ixi nchakon meꞌe naa nchakon ijié. Méxin, juancheꞌe na̱ xi Pilato tsondaki na̱ tutée ni kuenꞌen nganito nta̱cru ko satsikaoxin na̱ ntiꞌa cuerpoe ni meꞌe. ");
INSERT INTO pps_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Ko ni soldado ikjui na̱ ko kondaki na̱ tutée naa xi ko kao tutée xi yuxin juankanito na̱ nta̱cru tjenka ndo Jesús. ");
INSERT INTO pps_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Ko hora kuiji na̱ tjenka ndo Jesús ko bikon na̱ ó tsikenꞌen ndo, kondakiꞌa na̱ tutée ndo. ");
INSERT INTO pps_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Ko naa xi soldado kuantjeꞌe xa ndatsjonxin ntakuin ndo Jesús ixi naa chika ko tuinxin chrinka ijni̱ ko inda. ");
INSERT INTO pps_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Méxin, janꞌan rikjin xroon ixi bakeꞌé ntiꞌa, bikon ixi jaña konꞌen ko ndachrja̱n ti nduaxin ixi jaꞌanta kaxon tsitikaonnta. ");
INSERT INTO pps_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Jaña konꞌen jiꞌi ixi tsonꞌen ngeꞌe ndachro xroon chijnie ndo Dio tsikjin sen: “Tsondakiꞌa na̱ ninaa nteꞌe ndo.” ");
INSERT INTO pps_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","*Kaxon íjngo nichja xroon chijnie ndo Dio tsikjin na̱ saꞌó ndachro: “Xrotsjeꞌe na̱ ndo juinchekatsingatoꞌe na̱ chika ndatsjonxin ntakuin ndo.” ");
INSERT INTO pps_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Tjumeꞌe ó juexin konꞌen kain jiꞌi, ko ndo José, naa ndo tjajna Arimatea, juanchia ndo ngajin xi Pilato juachaxin ixi tsakinjinxin ndo nta̱cru cuerpoe ndo Jesús ko satsikao ndo ndo xroxrabaa ndo. Jeꞌe ndo José imao ruéꞌe ndo ndo Jesús ixi xrakonꞌen ndo ni judío. Tjumeꞌe xi Pilato kuajon xa juachaxin ko sabikao ndo José cuerpoe ndo Jesús. ");
INSERT INTO pps_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","*Kaxon ndo Nicodemo, ndo meꞌe bikitsjeꞌe ndo Jesús naa tiie, a̱ nchakon xroxrabaa ndo Jesús bikaꞌo ndo níite kilo xro̱a̱n xraxe tsintekjan xro̱a̱n mirra ko xro̱a̱n áloe. ");
INSERT INTO pps_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Jaña ndo José ko ndo Nicodemo kuayéꞌe sen cuerpoe ndo Jesús, juinchekitsa sen ndo naa manta jine̱ tsikaa xro̱a̱n xraxe ixi jaña bakitikaon ni judío nchakon tsixrabaa chujni tsikenꞌen. ");
INSERT INTO pps_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Ti no juankanito na̱ ndo Jesús nta̱cru tjenka ntiꞌa jii naa huerto ko ntiꞌa jii naa itjao̱ natjúá xraxroꞌan chujni tsixrabaa ntiꞌa. ");
INSERT INTO pps_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Ntiꞌa juabaa sen ndo Jesús ixi kjínꞌa jii itjao̱ ko íseꞌa hora xroxrangíxin nchakon tjokéꞌe ni judío. ");
INSERT INTO pps_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Tjumeꞌe nchakon xrangíxin semana xra naxixeꞌe jan María Magdalena ikjui jan ti no tsixrabaa ndo Jesús, ko bikon jan ixi ixro tsijijee̱xin na̱ itjao̱ ti no tsixrabaa ndo tsijinchetengi na̱ ixro. ");
INSERT INTO pps_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Méxin sabinga jan ikjui jan ti no jii ndo Simón Pedro ko ti jii inaa ndo tsikincheꞌe ndo Jesús, ndo meꞌe tsango tjueꞌe ndo ndo Jesús, ko ndachro jan: ―Ó tsikantsje na̱ cuerpoe Ncháina satsikikao na̱ ndo ko nónaꞌina ti no tsikakeꞌe na̱ ndo. ");
INSERT INTO pps_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Ndo Pedro ko ndo meꞌe kuinꞌen sen jaña, méxin, sakjui sen ti tsixrabaa ndo Jesús. ");
INSERT INTO pps_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Yui sen binga sen. Ko ndo naa ícha nteeto binga ndo ixi ndo Pedro, ko jeꞌe ndo saꞌó kuiji ndo tinó tsixrabaa ndo Jesús. ");
INSERT INTO pps_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Kuisée ndo tsjeꞌe ndo ngaxinꞌin ti no tsixrabaa ndo Jesús ko bikon ndo manta tsikitsía na̱ ndo ko kuixinꞌa ndo ntiꞌa. ");
INSERT INTO pps_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Ko tjumeꞌe kuiji ndo Simón Pedro ko kuixinꞌin ndo ti no tsixrabaa ndo Jesús ko kaxon bikon ndo manta tsikitsía ndo, ");
INSERT INTO pps_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","ko bikon ndo ixi manta tsikitsía jaa ndo Jesús nango tsixratuꞌu manta, jiꞌa manta tjenka ti no ste manta kaxin. ");
INSERT INTO pps_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Ko ndo bajikao ndo Jesús, ndo kuiji saꞌó ti no tsixrabaa ndo, kaxon kuixinꞌin ndo ko bikon ndo ngeꞌe tsikonꞌen ko kuitikaon ndo. ");
INSERT INTO pps_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Ko xrakuienxinꞌa sen ngeꞌe ndachro xroon chijnie ndo Dio, ti xrokonda xroxechón ndo Jesús. ");
INSERT INTO pps_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Tjumeꞌe sen tsikji tsikitsjexin ti no tsixrabaa ndo Jesús ikjan sen ndoꞌa sen. ");
INSERT INTO pps_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Ko jan María kuituꞌe jan ngandangi nduja ti no juabaa na̱ ndo Jesús jitsjanga jan. Ko jaña jitsjanga jan, kuisée jan tsjeꞌe jan ngaxinꞌin ti no tsixrabaa ndo, ");
INSERT INTO pps_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","ko bikon jan yuu sen ángel jiá sen manta tjúá ste sen nunte tinó tsikakeꞌe na̱ cuerpoe ndo Jesús ko naa ndo ángel jii ndo ti no bakeꞌe jaa ndo Jesús ko inaa ndo jii ndo ti bakeꞌe tutée ndo. ");
INSERT INTO pps_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Tjumeꞌe sen ángel juanchangi sen: ―Nchri, ¿sonda tsja̱nga? Ko juateꞌe jan: ―Satsikikao na̱ cuerpoe Nchána̱na, ko nónaꞌina no tsikakeꞌe na̱ ndo. ");
INSERT INTO pps_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Juexin ndachro jan jiꞌi ko konkjan jan tsjeꞌe jan ko bikon jan ixi ntiꞌa jii ndo Jesús, ko juatsuanꞌi jan ndo. ");
INSERT INTO pps_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Ko ndo Jesús juanchangiꞌe ndo jan: ―Nchri, ¿sonda tsja̱nga? ¿Ngisen tjée? Ko jeꞌe jan xraxaon jan ixi ndo nichjeꞌe jan naa sen tayakonꞌen huerto ntiꞌa, ko ndachro jan: ―Siá jaꞌa sabikoꞌa ndo, ndachijiana no bakée ndo ixi janꞌan satsikiꞌan ndo. ");
INSERT INTO pps_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Ko ndo Jesús nichjeꞌe ndo jan ndachro ndo: ―¡María! Ko tsjeꞌe jan ndo, ko nichjaxin jan ngigua arameo, ndachro jan: ―¡Raboni! (Jiꞌi xrondachro Maestro.) ");
INSERT INTO pps_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Ko ndachro ndo Jesús: ―Tajandana ixi xrasatjiꞌa ti jii Ndotána. Itjia titsjeꞌé sen kichuuna ko ndache sen ixi sajiin ti jii Ndotána, ndo kaxon Ndotánta, ndo Dio naꞌna ko kaxon ndo Dio naꞌanta. ");
INSERT INTO pps_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Tjumeꞌe jan María Magdalena sakjuichronga jan ngajin sen kuajikao ndo Jesús, ko ndachro jan ixi tsikikon jan Ncháina ko kaxon chronga jan ixi jaña tsindachro ndo. ");
INSERT INTO pps_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Tjumeꞌe kóndo nchakon xrangíxin semana, sen kuajikao ndo Jesús tsixraꞌo sen ngaxinꞌin nchia ko jian tsikijeꞌe̱ sen nchia ixi xrakonꞌen sen ni judío. Ko ndo Jesús kuixinꞌin ndo ko ngusine jeꞌe sen bakeꞌe ndo, ko nichjeꞌe ndo sen, ndachro ndo: ―¿Á jian stenta? ");
INSERT INTO pps_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Ko juexin ndachro ndo jiꞌi, juako ndo itja ndo ko chjiyée ndo. Ko jeꞌe sen bakeꞌe sen juaxruxin ixi bikon sen Ncháina. ");
INSERT INTO pps_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Tjumeꞌe ndachro ndo Jesús: ―Juaxruxin stenta. Xranchi Ndotána xruanꞌanna ndo juiꞌi ntiꞌi, jaña janꞌan xruanꞌannta. ");
INSERT INTO pps_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Ko kuanotée ndo ngataꞌa sen ko ndachro ndo: ―Tayeꞌénta Espíritue ndo Dio. ");
INSERT INTO pps_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","*Siá xrotjáñaꞌanta ijie̱ juincheꞌe xrojan ngisen, jaña kaxon tsoméꞌe jíee na̱. Ko siá xrotjáñaꞌinta ijie̱ juincheꞌe xrojan ngisen, tsoméꞌa ijie̱ chónda na̱. ");
INSERT INTO pps_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Tjumeꞌe ndo Tomás, naa sen teyuu sen chrikao ndo Jesús, kaxon nchekinꞌin sen ndo xjan Kuatsi, ndo meꞌe koꞌa ndo nchakon konoxin ndo Jesús. ");
INSERT INTO pps_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Méxin sen ikaxin chrikao ndo Jesús ndache sen ndo: ―Ó bikona Ncháina. Ko ndachro ndo Tomás: ―Siá tsikonꞌa janꞌan tinó tsikituꞌu na̱ clavo itja ndo ko xroxraxinꞌa dedo tjáana ntiꞌa ko ti chjiyée ndo, tsitikaonꞌa. ");
INSERT INTO pps_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Tjumeꞌe kuatsinga ijní nchakon ko xraꞌo kain sen íjngo ngaxinꞌin nchia ko kaxon ndo Tomás jikao sen ndo ntiꞌa. Tsikijeꞌe̱ sen jian nchia ko tuinxin bikon sen ndo Jesús ngusine ti ste sen ko nichja ndo ngajin sen ko ndachro ndo: ―¿Á juaxruxin stenta? ");
INSERT INTO pps_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Ko ndache ndo ndo Tomás: ―Xraxinꞌia dedo tjáa ti no tsixranduꞌu na̱ chika clavo tjáana ko xraxinꞌia tjáa chiyéna. Ko jaña jeꞌa xrokuitikaonꞌa ixi nduaxin janꞌan. ");
INSERT INTO pps_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Ko juateꞌe ndo Tomás: ―¡Jaꞌa Ncháina ko ndo Dio naꞌna! ");
INSERT INTO pps_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Ko ndache ndo Jesús ndo Tomás: ―Tomás bikonjana, kuitikaoan. Ko ikaxin sen juaxruxin ste sen, maski bikonꞌana sen ko jaña titikaon sen. ");
INSERT INTO pps_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Ndo Jesús juincheꞌe ndo itsjé ixra̱ ijié bikon sen chrikao ndo ko jitaxinꞌa kain ngeꞌe meꞌe xroon jiꞌi. ");
INSERT INTO pps_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Ko ngeꞌe jitaxin xroon jiꞌi, tsikixintaxin ixi tsitikaonnta ixi ndo Jesús meꞌe ndo Cristo, Chjenꞌen ndo Dio, ixi siá tsitikaonnta ndo, xrochondanta juachaxin tsaricho̱nnta kain nchakon. ");
INSERT INTO pps_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Tjumeꞌe íjngo ndo Jesús konoxin ndo ngajin sen chrikao ndo ngandeꞌe ndachaon ndatinꞌin Tiberias. ");
INSERT INTO pps_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Naakua ste sen, ndo Simón Pedro ko ndo Tomás, xi nchekinꞌin sen xjan Kuatsi, ko ndo Natanael, xi tsiki̱ꞌxi̱n tjajna Caná nunte Galilea, ko yuu chjenꞌen ndo Zebedeo ko íjngo yuu sen bakajikao ndo Jesús. ");
INSERT INTO pps_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","*Tjumeꞌe ndachro ndo Simón Pedro: ―Satsji xrotse̱ kuchee̱. Ko juateꞌe sen: ―Kaxon janꞌanna itsjina. Ko sakjui sen kuajinꞌin sen naa nta̱barco. Ko xroꞌan kuchee̱ itsé sen nchijíi tiie. ");
INSERT INTO pps_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Ko ó jitingasáña ko tuinxin bikon sen ndo Jesús ngandeꞌe ndachaon, ko juatsuanꞌi sen ndo. ");
INSERT INTO pps_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Ko juanchangiꞌe ndo sen: ―Jaꞌanta, ¿á xraxroꞌan kuchee̱ itsenta? Ko juateꞌe sen, ndachro sen: ―Xraxroꞌan ngeꞌe. ");
INSERT INTO pps_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","*Ko ndo Jesús ndache ndo sen: ―Tjaꞌngangínta nochaꞌa nango jian nta̱barco ko xrotsénta ba. Tjumeꞌe jaña juincheꞌe sen, banka sen nochaꞌa ko juaꞌi kuantsjexin sen inda nochaꞌa ixi kueya kuchee̱ itsé sen. ");
INSERT INTO pps_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Ko ndo ícha tjueꞌe ndo Jesús ndache ndo ndo Pedro: ―¡Ncháina jiꞌi! Ko kuinꞌen ndo Simón Pedro ixi Ncháina, ko kuéyá ndo mantée ndo, manta jindatexin, ixi tsikantsje ndo manta ko juingi ndo inda. ");
INSERT INTO pps_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Tjumeꞌe sen kaxin bajikao ndo Jesús kuiji sen ngandeꞌe ndachaon bijikao sen nta̱barco jitingakjín nochaꞌa chónda kuchee̱ ixi tsikjin sen xranchi naa ciento metro kjínxin ti no jii ngandeꞌe inda. ");
INSERT INTO pps_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Tjumeꞌe kuiji sen ngandeꞌe inda ko xingajinxin sen nta̱barco ko bikon sen xruitja tsiche xroꞌi ko ngataꞌa xruitja jii naa kuchee̱ ko nango jii nutja. ");
INSERT INTO pps_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Tjumeꞌe ndo Jesús juanchia ndo: ―Tikuunta kaxin kuchee̱ sintenta. ");
INSERT INTO pps_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Ko ndo Simón Pedro kuajinꞌin ndo nta̱barco bingakjin ndo nochaꞌa jitjinga itsjé kuchee̱, naa ciento cincuenta ko níi ba. Ko maski kueya ba tsitsé sen tsichrindaonꞌa nochaꞌa. ");
INSERT INTO pps_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Tjumeꞌe ndachro ndo Jesús: ―Xrokuiinta, sintenta. Tjumeꞌe ninaa sen juanchangiꞌe sen ndo ngisen jeꞌe ndo ixi ó juatsuan sen ndo. ");
INSERT INTO pps_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Ko konchjiñeꞌe ndo Jesús ko kua ndo nutja chjée ndo sen ko jaña kuajon ndo kuchee̱. ");
INSERT INTO pps_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Jiꞌi nínxin konoxin ndo Jesús ti tsixechón ndo. ");
INSERT INTO pps_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Juexin juine sen juanchangiꞌe ndo Jesús ndo Simón Pedro: ―Jaꞌa Simón, chjenꞌen ndo Jonás, ¿á ícha tjauanna ixi sen jiꞌi? Ko juateꞌe ndo Pedro: ―Jaán, Nchána, ó noꞌanta ixi tjuaꞌanta. Ko ndachro ndo Jesús: ―Siá nduaxin meꞌe, tayakonꞌén kutuchjonna. ");
INSERT INTO pps_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Tjumeꞌe yuxin juanchangi ndo Jesús: ―Jaꞌa Simón, chjenꞌen ndo Jonás, ¿á tjauanna? Ko juateꞌe ndo Pedro: ―Nchána, jaꞌanta noꞌanta kain ngeꞌe, janꞌan ó noꞌanta janꞌan tjaꞌonnta. Ko ndachro ndo Jesús: ―Siá nduaxin meꞌe, tayakonꞌén kutuchjonna. ");
INSERT INTO pps_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Tjumeꞌe nínxin juanchangi ndo Jesús: ―Jaꞌa Simón, chjenꞌen ndo Jonás, ¿á tjauanna? Ko koniꞌe aséen ndo Pedro ixi nínxin juanchangi ndo Jesús á tjaun ndo Pedro ndo Jesús ko ndachro ndo: ―Nchána, jaꞌanta ó noꞌanta kain ngeꞌe. Jaꞌanta ó noꞌanta janꞌan tjaunnta. Ko ndachro ndo Jesús: ―Siá nduaxin meꞌe, tayakonꞌén kutuchjonna. ");
INSERT INTO pps_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Ko naa ngeꞌe nduaxin ntatjua ixi nchakon xrachájan jaꞌa, jaꞌua bakaria mantáa ko bakjia tinó tjauan. Ko nchakon tsotáchría tsinxé tjáa ko inaa ngisen sintekitsaa mantáa ko tsikaan na̱ ti no tjaunꞌa itsjia. ");
INSERT INTO pps_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Ti ndachro ndo Jesús xrondachro xranchi tsenxin ndo Pedro ko jiꞌi tachrjexin xranchi tsajon ndo juasaya ngajin ndo Dio. Ko juexin ndachro ndo jiꞌi, íjngo ndache ndo ndo Pedro: ―Ruaꞌna̱na. ");
INSERT INTO pps_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","*Tjumeꞌe ndo Pedro tsjeꞌe ndo tuenxin ndo ko bikon ndo ixi ruéꞌe ndo ícha tjueꞌe ndo Jesús, ndo meꞌe bakeꞌe tjenka ti bakeꞌe ndo Jesús nchakon juine sen ko tsijanchangíꞌe ndo ndo Jesús ixi ngisen sinchekji ndo. ");
INSERT INTO pps_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Ko ndo Pedro bikon ndo ixi jiruéꞌe ndo meꞌe ko juanchangiꞌe ndo ndo Jesús: ―Nchána, ndo jiꞌi, ¿ngeꞌe tsonꞌen ndo? ");
INSERT INTO pps_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Ko juateꞌe ndo Jesús: ―Siá tjaꞌon xratsechón ndo ti nchakon xrokjan janꞌan, jaꞌa ngeꞌe kondaꞌa. Jaꞌa ruena̱na. ");
INSERT INTO pps_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Meꞌe juangíxin juao sen ixi tsenꞌa ndo meꞌe. Ko jeꞌa ndachro ndo Jesús ixi xrokuenꞌa ndo. Naꞌi. Jeꞌo ndachro ndo ixi siá tjaun ndo xratsechón ndo nchakon xrokjan jeꞌe ndo, ngeꞌe kondee jeꞌe ndo Pedro. ");
INSERT INTO pps_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Ndo meꞌe ngisen chronga ixi nduaxin konꞌen kain jiꞌi, ko ikjin ndo xroon jiꞌi. Ko ó noi̱na ixi ngeꞌe tsikjin ndo, meꞌe nduaxin. ");
INSERT INTO pps_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Xrajíi kueya ngeꞌe juako ndo Jesús kjinꞌa janꞌan. Siá xrokjin naanaa meꞌe, xrokuitjaꞌi nunte xasintajni xrobinga kain xroon ti xrokjin. Jaña tsonꞌen.");
INSERT INTO pps_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","*Tjuaꞌanta Teófilo, xroon saꞌó ikjín, ntiꞌa ikjin kain ngeꞌe juinchekuai̱na ndo Jesús ko ixra̱ juincheꞌe ndo ó saꞌó ");
INSERT INTO pps_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","kuijija nchakon sakjui ndo ngajní. Ko ti xrasatjiꞌa ndo kuincheꞌe ndo sen sincheꞌe ixra̱ ko Espíritue ndo Dio bingijna ndo kuetuenꞌen ndo sen ixi tsonoꞌe sen ngeꞌe ixra̱ sincheꞌe sen. ");
INSERT INTO pps_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Nchakon juexin kuenꞌen ndo Jesús, tjumeꞌe konoxin ndo ixi jichón ndo, ko yuu kán nchakon nanaó konoxin ndo ngajin sen. Itsjé ngeꞌe juako ndo ixi tsonoꞌe sen nduaxin jichón ndo ko juinchekuenꞌen ndo sen ti tituanꞌan ndo Dio. ");
INSERT INTO pps_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","*Ti xra jii ndo ngajin sen chrikao ndo, jeꞌe ndo ndache ndo sen satsjixinꞌa sen tjajna Jerusalén. Jaꞌin ndachro ndo: ―Ntiꞌi chonꞌénnta tsayeꞌenta ngeꞌe tsajon Ndotána, ti ngeꞌe ntatjunta ndo saꞌó. ");
INSERT INTO pps_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","*Nduaxin ndo Juan bikitée ndo chujni ixi inda. Ko tsjéꞌa nchakon jaꞌanta tsayeꞌenta Espíritue ndo Dio. ");
INSERT INTO pps_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Tjumeꞌe sen chrikao ndo Jesús, juanchangiꞌe sen ndo: ―Jaꞌanta Nchána̱na, ¿á tsajonnta juachaxin jai ixi ni tjajnai̱na tsetuanꞌan tjajna íjngo? ");
INSERT INTO pps_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Ko juatingíexin ndo Jesús: ―Naꞌi. Jaꞌanta chondaꞌinta juachaxin tsonoꞌanta ngisa tsonꞌen jiꞌi. Jeꞌo Ndotána noꞌe ndo ngixeꞌe nchakon. ");
INSERT INTO pps_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","*Ko nchakon tsi̱i̱ Espíritue ndo Dio tsayeꞌenta, meꞌe xrochondanta juachaxin tsachrjenta ko xrochronganta ngeꞌe ixra̱ juintaꞌa, nguixin tjajna Jerusalén, ko nunte Judea, ko nunte Samaria, ko nchijíi nunte xasintajni. ");
INSERT INTO pps_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","*Ko juexin nichja ndo Jesús jiꞌi, xrastetsjeꞌe sen ndo, tuinxin jeꞌe ndo kuaxi bajinꞌin ndo nui, sakjui ndo ko kuintsía ndo naa tjui̱ ko í bikonꞌa sen ndo íjngo. ");
INSERT INTO pps_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Ko xrastetsjeꞌe sen ti sakjui ndo Jesús ngajní, tuinxin bikon sen yuu xi tjenka ti no ste sen, steyá xa manta tjúá. ");
INSERT INTO pps_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Ko xi meꞌe ndachro xa: ―Jaꞌanta chujni nunte Galilea, ¿sonda stetsjeꞌenta ngajní? Xranchi bikonta sakjui ndo Jesús, jaña xrokjan ndo íjngo. ");
INSERT INTO pps_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Tjumeꞌe kjanxin sen ijna̱ ndatinꞌin Olivo ko kuiji sen tjajna Jerusalén. Chaꞌo meꞌe kjínꞌa xranchi naa kilómetro, xranchi jii juachaxin taji ni judío nchakon tjokéꞌe na̱. ");
INSERT INTO pps_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","*Ko kuiji sen tjajna ntiꞌa ko kuajinꞌin sen ti jii piso noi nchia tsikjen sen ti bakeꞌe sen seno, ndo Pedro, ndo Jacobo, ndo Juan, ndo Andrés, ndo Felipe, ndo Tomás, ndo Bartolomé, ko ndo Mateo. Kaxon ndo Jacobo, ndotée ndo ndatinꞌin Alfeo, ko ndo Simón, ndo meꞌe ndo kuarueꞌe ni Cananista, ko kaxon ndo Judas, ndosaué ndo Jacobo. ");
INSERT INTO pps_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Kain sen xraꞌo sen ntiꞌa xronichjeꞌe sen ndo Dio, ko kaxon jan María, janée ndo, ko sen kichuu ndo ko kaxin nchri. ");
INSERT INTO pps_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Ko nchakon meꞌe, ndo Pedro bingatjen ndo ko bakeꞌexin tutée ndo ngusine ti ste sen titikaon Ncháina Jesús, jeꞌe sen xranchi naa ciento ko kán sen tsixraꞌo ntiꞌa. Tjumeꞌe ndachro ndo: ");
INSERT INTO pps_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","―Kichuuna, xrokonda tsonꞌen xranchi nichja xroon chijnie ndo Dio ti tsinichja ndo David ó saꞌó tsichronga Espíritue ndo Dio ngeꞌe sincheꞌe xi Judas, xi bikaꞌo ni itsé ndo Jesús. ");
INSERT INTO pps_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Jeꞌe xa kaxon kuajikuꞌuna xa ko xrajeꞌo ixra̱ kuayéꞌe xa. ");
INSERT INTO pps_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","*Tjumeꞌe jeꞌe xa sakjui xa bikeꞌna xa naa nunte ixi tomi juacha xa ixi ti ndakoꞌa juincheꞌe xa. Ko ntiꞌa juinxin jaa xa, meꞌe chringa xa ko kuachrje tse̱ꞌe̱ xa. ");
INSERT INTO pps_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Jaña konoꞌe kain ni tjajna Jerusalén, ko nunte meꞌe kuinꞌin ngigueꞌe na̱ Acéldama, meꞌe xrondachro naa nunte ijni̱. ");
INSERT INTO pps_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Jaꞌin jitaxin naa Salmo chijnie ndo Dio: Jeꞌo ndoꞌa xa tsituꞌe, ko xroꞌan ngisen tsakeꞌe ntiꞌa. Ko kaxon ndachro: Inaa chujni tsayéꞌe ixra̱ kuancheꞌe xa. ");
INSERT INTO pps_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","*’Ntiꞌi ste ni kuajikuꞌuna kain nchakon ti bakeꞌe Ncháina Jesús, ");
INSERT INTO pps_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","xranchakon bikona ndo Juan bikitée ndo ndo Jesús ko ti kuijija nchakon bikona sakjui ndo Jesús ngajní. Méxin, jai xrokonda tsjéena inaa sen tsajikuꞌuna, ixi sen meꞌe kaxon xronichja sen ixi nduaxin xechón Ncháina Jesús. ");
INSERT INTO pps_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Ko tjumeꞌe kuincheꞌe sen yuu sen, ndo José, ndatinꞌin ndo kaxon Barsabás ko kaxon Justo, ko inaa ndo ndatinꞌin Matías. ");
INSERT INTO pps_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Tjumeꞌe nichjeꞌe sen ndo Dio ko ndachro sen: ―Ncháina, jaꞌanta chuxinnta aséen kain chujni. Tjakoꞌnananta ngisen kuincheꞌenta ");
INSERT INTO pps_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","tsayéꞌe ixra̱ xranchi apóstol, ixra̱ kuintuꞌe xi Judas, ixi ndakoꞌa juincheꞌe xa ko sakjui xa ti no tikinixinꞌen xa. ");
INSERT INTO pps_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Tjumeꞌe sondaonxin sen ixro ixi jaña tsonoꞌe sen ngixeꞌe xi tsayéꞌe ixra̱, ko juacha ndo Matías, ko hora meꞌe kuayéꞌe ndo ixra̱ ko bajikao ndo sen tenaá kuincheꞌe Ncháina Jesús. ");
INSERT INTO pps_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Tjumeꞌe kui̱i̱ kia Pentecostés ko kain sen titikaon ndo Jesús xraꞌo sen, naakua no ste kain sen. ");
INSERT INTO pps_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Ko tuinxin kuinꞌen sen naa ngeꞌe séen ndachro kui̱xi̱n ngajní xranchi naa chrinto soji. Kuixinꞌin chrinto nguixin ngaxinꞌin nchia ti ste sen. ");
INSERT INTO pps_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Ko bikon sen naa ngeꞌe xranchi nejen xroꞌi. Ko xroꞌi chjeya ko baketaꞌa xroꞌi ngujngu jaa sen. ");
INSERT INTO pps_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Ko kain sen kuayéꞌe sen Espíritue ndo Dio, ko tjumeꞌe kain sen kuaxi sen nichja sen inaa ngigua ixi Espíritue ndo Dio kuajon xronichja sen. ");
INSERT INTO pps_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Ko nchakon meꞌe tjajna Jerusalén bakeꞌe ni judío, ni titikaon ndo Dio, tsiki̱ꞌxi̱n na̱ nchijíi nunte xasintajni. ");
INSERT INTO pps_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Ko kueya na̱ tsikinꞌen na̱ ti chrinto méxin konchjiñeꞌe na̱. Ko noeꞌa na̱ ngeꞌe xroxraxaon na̱ ixi ngujngu na̱ kuinꞌen na̱ nichja sen titikaon ndo Jesús ngujngu ngigueꞌe na̱. ");
INSERT INTO pps_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Méxin, xronka na̱, ko xrakon na̱ ko tjao kichuu na̱: ―¿Á jeꞌa kain ni nichja jiꞌi, ni nunte Galilea? ");
INSERT INTO pps_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","¿Xranchi chao tienxinna nichja na̱ ngujngu ngiguaꞌina? ");
INSERT INTO pps_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Ntiꞌi jii ni tsiki̱ꞌxi̱n tjajna Partia, Media, Elam, Mesopotamia, Judea, Capadocia, Ponto, Asia, ");
INSERT INTO pps_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Frigia, Panfilia, Egipto ko kaxin ni nunte Africa ícha tjenka tjajna Cirene. Ko kaxon ni romano ste na̱ ntiꞌi. Kaxin na̱ judío na̱ xrajongíexon na̱, ko ikaxin na̱ jeꞌo titikaon na̱ ndo Dio xranchi ni judío. ");
INSERT INTO pps_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Kaxon jii ni tsiki̱ꞌxi̱n Creta, ko Arabia. Ko kainna kuinꞌanna ngujngu ngiguaꞌina nichja na̱ ixra̱ ijié juincheꞌe ndo Dio. ");
INSERT INTO pps_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Ko xronka na̱, noeꞌa na̱ ngeꞌe xroxraxaon na̱ meꞌe juanchangiꞌe kichuu na̱: ―¿Ngeꞌe xrondachro kain jiꞌi? ");
INSERT INTO pps_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Ko ikaxin na̱ juano na̱ ko ndachro na̱: ―Tsikuan kain ni jiꞌi. ");
INSERT INTO pps_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Tjumeꞌe jeꞌe ndo Pedro bingatjen ndo ko kao sen tenaá apóstol ko séen nichja ndo ko ndachro ndo: ―Jaꞌanta ni judío ko ni ste tjajna Jerusalén. Kainnta stenta ntiꞌi tinꞌennta ngeꞌe xronichja. ");
INSERT INTO pps_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Sen ste ntiꞌi jeꞌa tsikuan sen xranchi ndachronta, ixi jai xranduyo, nandá las nueve. ");
INSERT INTO pps_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Ti stetikonnta meꞌe tsichronga ndo profeta Joel: ");
INSERT INTO pps_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Ndachro ndo Dio: Nchakon tsjexin meꞌe xroxruanꞌan Espírituna tsayéꞌe kain chujni. Ichjan, xjan xi ko xjan nchri, xrochronga xjan chijnina. Ko sen chajan tsikon sen ixra̱ ijié tsjako janꞌan ko sen ó tachríi, tsoxienxin ngeꞌe xrontatjan sen. ");
INSERT INTO pps_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Nchakon tsonꞌen kain jiꞌi, janꞌan xroxruanꞌan Espírituna tsayéꞌe kain sen ncheꞌe xra̱na, nchri ko xi, ko jeꞌe sen xrochronga sen chijnina. ");
INSERT INTO pps_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Ko janꞌan tsjáko ixra̱ ijié tsikonni ngajní, ko kaxon ngataꞌa nunte xasintajni tsjáko kaxin ixra̱ ijié: ijni̱, xroꞌi ko iꞌnchi xranchi itjui̱ tsikon na̱. ");
INSERT INTO pps_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Chjiixro tsonaxixeꞌe chjiixro. Ko nchanitjao tsikonni xranchi ijni̱. Jaña tsonꞌen ko tjumeꞌe tsi̱i̱ Ncháina. Jiꞌin naa nchakon tsango ijié ko tsango chaxro. ");
INSERT INTO pps_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Ko kain sen tsiyeꞌe Ncháina, sen meꞌe tsitjáñaꞌi sen, tsechón sen kain nchakon. ");
INSERT INTO pps_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","’Jaꞌanta ni israelita, tinꞌennta ngeꞌe xrondachrja̱n. Ndo Jesús, ndo tjajna Nazaret, ndo Dio tsixruaꞌan ndo ndo ngajinnta ko jeꞌe ndo juincheꞌe ndo itsjé ixra̱ ijié bikonta, meꞌe juakoxin ndo ixi ndo Dio tsikajon ndo juachaxin ngajin ndo. Meꞌe jian noꞌanta. ");
INSERT INTO pps_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","*Maski jaña bikonta, jaꞌanta ndakuaꞌi juinchekuunta ndo xranchi tsixraxaon ndo Dio ó saꞌó. Ko jaꞌanta kuajonnta ndo ngajin ni ñaꞌi, ko kuenitonta ndo nta̱cru. ");
INSERT INTO pps_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","*Ko ndo Dio juinchexechón ndo ndo Jesús ko ndo Dio kuantsje ndo kain juachaxin chónda xichononte; í juaꞌi tsetuanꞌan xa ngajin ndo. ");
INSERT INTO pps_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Ko saꞌó ndo rey David tsichronga ndo ixi ndo Jesús ko ndachro ndo: Janꞌan xraxaꞌon Nchána ko jeꞌe ndo tjenkana jii ndo. Jeꞌe ndo jii ndo ndatsjonxin jian, méxin, xroꞌan ngeꞌe tsónna. ");
INSERT INTO pps_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Méxin, tsango juaxruxin bakeꞌe aséenna ko roꞌa chaxro itsje̱, ixi nóna janꞌan maski tsenꞌenna, xroꞌan ngeꞌe tsónna. ");
INSERT INTO pps_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Ixi nóna tsintueꞌanta aséenna ti no ste ni tsikenꞌen, ko tsajonꞌanta juachaxin ixi xrorenga ntauꞌna ngaya tuye ixi janꞌan jian ntaꞌa xráanta. ");
INSERT INTO pps_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Jaꞌanta juakoꞌnanta chaꞌo tsechónxixini, ko janꞌan juaxruxin tsakeꞌe ti ritjén jaꞌanta. ");
INSERT INTO pps_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","’Kichianna, chjánanta juachaxin xrondachrja̱n ixi ndo David, ndo kuachrjenixinna, tsikenꞌen ndo ko tsixrabaa ndo. Ko ti no tsixrabaa ndo xra jii ntiꞌi nchakon stena jai. ");
INSERT INTO pps_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Ko ndo David, naa ngisen tsichronga chijnie ndo Dio, ó noꞌe ndo ixi nduaxin ndo Dio chronga ixi naa ngisen tsachrjenixin ndo xrokjan ndo rey, ndo Cristo tsetuanꞌan xranchi jeꞌe ndo baketuanꞌan ndo. ");
INSERT INTO pps_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Jaña ndo David ó bikon ndo saꞌó, ko chronga ndo ixi xroxechón ndo Cristo ko ndachro ndo ixi aséen ndo Cristo tsitueꞌa ti jii ni tsikenꞌen ko xrorengaꞌi ntauꞌe ndo. ");
INSERT INTO pps_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Méxin, ndo Dio juinchexechón ndo ndo Jesús, ko bikona kainna ko chrongana ixi nduaxin jiꞌi. ");
INSERT INTO pps_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Jai ndo Dio bikao ndo ndo Jesús ko jii ndo Jesús ndatsjonxin jian ti jii jeꞌe ndo. Ko kuayéꞌe ndo Jesús Espíritue ndo Dio, ti tsindachro ndo Dio xroxruanꞌan ndo, meꞌe jai xruanꞌan ndo kuayeꞌena. Ko kain jiꞌin ti bikonta ko ti kuinꞌennta. ");
INSERT INTO pps_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Noi̱na ixi ndo David juiꞌa ndo ngajní xranchi ndo Jesús, ixi jeꞌe ndo David ndachro ndo: Ncháina Dio ndache Ncháina Jesús: “Takeꞌé ndatsjonxin jian ti ritjén janꞌan, ");
INSERT INTO pps_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","tsakeꞌeja kain ni ningakonꞌan ngangi tutáa ixi jaꞌa tsituenꞌen na̱.” ");
INSERT INTO pps_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","’Méxin, kainnta ni israelita xrokonoꞌanta nduaxin ixi jeꞌe ndo Jesús, ndo juankanitonta nta̱cru, ndo meꞌe ndo Dio juinchéña ndo Ncháina, ndo Cristo. ");
INSERT INTO pps_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Ko kuinꞌen na̱ jiꞌi, tjumeꞌe tsango koniꞌe aséen na̱. Ko juanchangiꞌe na̱ ndo Pedro ko sen kaxin kuincheꞌe ndo Jesús ko ndachro na̱: ―Kichianna, jai, ¿ingeꞌe sintaꞌana? ");
INSERT INTO pps_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Tjumeꞌe juateꞌe ndo Pedro ko ndachro ndo: ―Tintuꞌenta ti ndakoꞌa ncheꞌenta ko titikaonnta ndo Dio. Ko tjumeꞌe tikitéxinnta nombrée ndo Jesucristo ko ndo Dio sincheméꞌe ndo jíanta ko tsajon ndo Espíritue ndo tsayeꞌenta. ");
INSERT INTO pps_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Ndo Dio tajon ndo Espíritue ndo tsayéꞌe jaꞌanta ko chjanꞌanta ko kaxon kain ni ste ikjín. Jeꞌe ndo tsajon ndo Espíritue ndo ngajin kain sen tsincheꞌe jeꞌe ndo. ");
INSERT INTO pps_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Jaña ndachro ndo Pedro ko ikaxin ngeꞌe ndachro ndo. Ko nichjeꞌe ndo na̱ íjngo, ko ndachro ndo: ―Tintuꞌenta ti ndakoꞌa ixi tsikaonꞌanta xranchi tsikaon kain ni ndakoꞌa ncheꞌe jai. ");
INSERT INTO pps_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Tjumeꞌe kain ni kuitikaon ngeꞌe ndachro ndo, bikitée na̱ ko ni konchjiñeꞌe nchakon meꞌe níi mil na̱. ");
INSERT INTO pps_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Kain sen kuitikaon sen ngeꞌe juinchekuenꞌen sen sen apóstol tsikincheꞌe ndo Jesús, ko juento kichuu sen, ko juinekao kichuu sen ko kaxon konchrinjin sen nutja ixi jaña xroxraxaon sen ti kuenꞌen ndo Cristo, ko kain sen nichjeꞌe sen ndo Dio. ");
INSERT INTO pps_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Ko tjumeꞌe kain chujni xronka na̱ ixi sen apóstol kuincheꞌe ndo Jesús juincheꞌe sen itsjé ixra̱ ijié. ");
INSERT INTO pps_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","*Ko tjumeꞌe kain sen titikaon ndo Jesús naakua naa ngeꞌe xraxaon sen ko kain sen tonchjeyeꞌe kichuu sen ti sine sen. ");
INSERT INTO pps_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Ko nchakon kuanchekji sen xrojan ngeꞌe kuachónda sen, tomi meꞌe chjeyeꞌe ngujngu sen chóndaꞌi. ");
INSERT INTO pps_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Ko ngujngu nchakon xraꞌo sen niꞌngo ko ngujngu ndoꞌa sen, chaxro nekao kichuu sen. Ko konchrinjin sen nutja ixi xraxaon sen ti kuenꞌen ndo Jesús ko nchejiéꞌa aséen sen. ");
INSERT INTO pps_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Kuajon sen juasaya ngajin ndo Dio. Ko itsjé chujni tjueꞌe na̱ sen. Ko ngujngu nchakon Ncháina bakincheꞌe ikaxin sen ixi itsjé sen tsitikaon sen ko xrochónda sen juachaxin tsechón sen kain nchakon. ");
INSERT INTO pps_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Naa nchakon ndo Pedro ko ndo Juan sakjui sen ti jii niꞌngo. Kuiji sen ó kóndo xranchi hora níi, hora meꞌe nichjeꞌe sen ndo Dio. ");
INSERT INTO pps_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Ntiꞌa jii naa xi juaꞌi itji xratsijongíexión xa. Kain nchakon tikao na̱ xa niꞌngo ixi tsakeꞌe xa ngandangi nduja niꞌngo ndatinꞌin Nta̱chja Chaxro. Ntiꞌa tjanchiakaꞌa xa ngajin ni tixinꞌin niꞌngo. ");
INSERT INTO pps_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Nchakon bikon xi niꞌe ixi ndo Pedro ko ndo Juan xrokuixinꞌin sen niꞌngo juanchiakaꞌa xa ngajin sen. ");
INSERT INTO pps_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Tjumeꞌe ndo Pedro ko ndo Juan tsjeꞌe sen xi meꞌe ko ndachro ndo Pedro: ―Tikonntana. ");
INSERT INTO pps_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Ko xi meꞌe jian tsjeꞌe xa ixi xrojan ngeꞌe tsajon sen ngajin xa. ");
INSERT INTO pps_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Ko ndo Pedro ndachro ndo: ―Chondaꞌi chika plata ko oro, ko ti chonda xrotjáꞌa. Juachaxien ndo Jesucristo, ndo tjajna Nazaret, tingatjen ko itjia. ");
INSERT INTO pps_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Ko ndo Pedro itsé ndo itja xa ti jian ko tjumeꞌe juinchengatjen ndo xa. Ko tuinxin konsoji tutée xa. ");
INSERT INTO pps_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Ko chrinka xa bakeꞌexin tutée xa ko kuaxi xa kuaji xa. Tjumeꞌe jeꞌe sen ko jeꞌe xa kuixinꞌin sen ngaxinꞌin niꞌngo ko jeꞌe xa jitji xa ko jichrinka xa ko tajon xa juasaya ngajin ndo Dio. ");
INSERT INTO pps_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Tjumeꞌe kain ni jii tjajna ntiꞌa bikon na̱ ixi chao itji xa ko tajon xa juasaya ngajin ndo Dio. ");
INSERT INTO pps_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Ko xronka na̱ ixi jaña koxruenꞌen xa ixi kuichúxin na̱ xa ixi xi meꞌe bakakeꞌe xa tjanchiakaꞌa xa tomi ngandangi nduja niꞌngo ndatinꞌin Nta̱chja Chaxro. ");
INSERT INTO pps_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Xi juaꞌi bakji tintueꞌa xa ndo Pedro ko ndo Juan. Tjumeꞌe kain ni ste ntiꞌa xronka na̱ ikjui na̱ sakuitsjeꞌe na̱ ntasien niꞌngo, ndasin Salomón ixi ntiꞌa ste sen ko jeꞌe xa kaxon. ");
INSERT INTO pps_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Ko hora bikon ndo Pedro kui̱i̱ na̱, jeꞌe ndo ndache ndo na̱: ―Jaꞌanta ni israelita, ¿sonda xronkanta ko sonda nchexruanninta? ¿Á xraxaonnta ixi janꞌonna chondana ijié juachaxin o̱ tsango titikaꞌonna ndo Dio, méxin koxruenꞌen xi jiꞌi? ");
INSERT INTO pps_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Naꞌi. Ndo Dio, Nchée ndo Abraham, ndo Isaac, ko ndo Jacob, tsango kuajon ndo ijié juachaxin ngajin Chjenꞌen ndo ndatinꞌin Jesús. Ko jaꞌanta kuajonnta xjan ngajin xi Pilato ko jeꞌe xa tjaun xa xrokuajanda xa ndo Jesús ko jaꞌanta chroꞌanta. ");
INSERT INTO pps_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","*Ko jaꞌanta xrojuanchianta xrokuajanda xa ndo tjúá aséen. Ko chroꞌanta. Ko cháña juanchianta kuajanda xa naa xi naatóñaxón chujni. ");
INSERT INTO pps_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Ko jaꞌanta naakóñaxónnta ngisen tajon juachaxin tsechón chujni, meꞌe ndo Jesús, ko ndo Dio juinchexechón ndo ndo. Jaña bikona janꞌanna ko meꞌe ndachrja̱nna. ");
INSERT INTO pps_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Ko juachaxien ndo Jesús chuntiana, meꞌe koxruenꞌen xi juaꞌi bakaji, xi tikonnta ko chuxinnta. Ko jeꞌe xa nduaxin chuntia xa ko kuitikaon xa, méxin koxruenꞌen xa. Meꞌe stetsjeꞌenta jai. ");
INSERT INTO pps_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","’Ko jai kichianna, nónana ixi nchakon jaꞌanta ko ni tetuanꞌan konꞌinta ndo Jesús, noaꞌinta ngeꞌe juincheꞌenta. ");
INSERT INTO pps_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Ko jaña juexin konꞌen ixi tsindachro ndo Dio tsinichjaxin ndo sen tsichronga chijnie ndo ixi ndo Cristo xrokonda tsenꞌen ndo. ");
INSERT INTO pps_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Méxin, tintuꞌenta ti ndakoꞌa ncheꞌenta ko titikaonnta ndo Dio ko jeꞌe ndo sincheméꞌe ndo kain ijie̱ chondanta ko Ncháina Jesús sinchesoji ndo asáanta. ");
INSERT INTO pps_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Ko tjumeꞌe jeꞌe ndo Dio xroxruanꞌan ndo ndo Jesucristo, ndo tikinixinꞌen sincheméꞌe jíanta. ");
INSERT INTO pps_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Ko jai ndo Jesucristo xrokonda tsituꞌe ndo ngajní tsijija nchakon sinchekonchjian ndo Dio kain ngeꞌe xranchi tsichronga ndo jitaxin chijnie ndo ó saꞌó. ");
INSERT INTO pps_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Ó seno ndo Moisés tsindachro ndo: “Ncháina ndo Dio xroxruanꞌan ndo naa ngisen tsachrjenixina ko ndo meꞌe xrochronga chijnie ndo Dio xranchi janꞌan. Ko jaꞌanta titikaonnta kain ngeꞌe xrondachro ndo. ");
INSERT INTO pps_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Ko ngisen tsitikaonꞌa ti xronichja ndo, sen meꞌe ítsikinixienꞌa sen tjajna Israel.” ");
INSERT INTO pps_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","’Xrangíxin ndo Samuel ko kain sen tsichronga chijnie ndo Dio: chronga sen kain ti jitonꞌen jai. ");
INSERT INTO pps_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Jaꞌanta tikinixinꞌannta tsitonꞌanta ti tsindachro ndo Dio tsinichjaxin ndo sen tsichronga chijnie ndo, ko kaxon tsayeꞌenta naa chijni tjintee ti tsindachro ndo Dio ngajin sen tachríꞌanta. Ixi tsindache ndo Abraham jaꞌin: “Kain ni nunte xasintajni tsonchaonxin na̱ naa ngisen tsachrjenixinnta.” ");
INSERT INTO pps_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Nchakon ndo Dio juinchexechón ndo Chjenꞌen ndo saꞌó xruanꞌannta ndo chjenꞌen ndo ngajinnta jaꞌanta ni israelita ixi sintanchaonnta ndo ngujngunta ko tsintuꞌenta ti ndakoꞌa ncheꞌenta. ");
INSERT INTO pps_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Ndo Pedro ko ndo Juan xranichjeꞌe sen ni ste ntiꞌa ko tuinxin kui̱i̱ xitaana ko xi tetuanꞌan niꞌngo ko xi saduceo. ");
INSERT INTO pps_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Tsango koñao na̱ ixi ndo Pedro ko ndo Juan stenchekuenꞌen sen ni tsixraꞌo ntiꞌa xranchi xroxechón chujni tsikenꞌen xranchi jaña xechón ndo Jesús. ");
INSERT INTO pps_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Tjumeꞌe jeꞌe na̱ itsé na̱ sen ko sabikao na̱ sen, xraxinꞌin na̱ sen ndoꞌachjiso. Ntiꞌa kuituꞌe sen tiie meꞌe ixi nchakon meꞌe ó kóndo. ");
INSERT INTO pps_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Ko kueya na̱ kuinꞌen na̱ chijni juako sen, ko kuitikaon na̱. Ko kain xi kuitikaon, naꞌó mil xi. ");
INSERT INTO pps_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Ko ndúyaxin xraꞌo kain ni tetuanꞌan ni judío ko ni tjako ley neꞌe ndo Moisés ntiꞌa tjajna Jerusalén. ");
INSERT INTO pps_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Kaxon ntiꞌa jii xi Anás, meꞌe xitaana ícha tetuanꞌan, ko xi Caifás, ko kaxon xi Juan, ko xi Alejandro, ko kain ni kichuu xitaana tetuanꞌan. ");
INSERT INTO pps_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Tjumeꞌe kuetuanꞌan xa kuixrakua ndo Pedro ko ndo Juan. Ko bakeꞌe xa sen ngusine ko tjumeꞌe juanchangiꞌe xa sen: ―¿Ngisen kuajon juachaxin o̱ ngisen nombrée ncheꞌexinnta kain jiꞌi? ");
INSERT INTO pps_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Ko ndo Pedro tsango chónda ndo juachaxien Espíritue ndo Dio, juateꞌe ndo ndachro ndo: ―Jaꞌanta ni tetuanꞌan tjajna ko jaꞌanta xi tachríi tjajna Israel, ");
INSERT INTO pps_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","jaꞌanta tjanchangínta xranchi koxruenꞌen naa xi niꞌe ixi tjaunnta tsonoꞌanta xranchi konꞌen jiꞌin. ");
INSERT INTO pps_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Méxin, tinꞌennta jian ngeꞌe xrondachrja̱n ixi kainnta ni tjajna Israel tsonoꞌanta ixi xi jii ntiꞌi koxruenꞌen xa ixi juachaxien ndo Jesucristo, ndo tjajna Nazaret, ndo kuenitonta nta̱cru, ko tjumeꞌe ndo Dio juinchexechón ndo ndo. ");
INSERT INTO pps_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Jaꞌanta juincheꞌenta xranchi ni nchekonchjian nchia kuitikaonꞌa na̱ ixro ko tjumeꞌe ikjan xro ícha jian ko tjintee tonsojixin nchijíi nchia meꞌe ndo Jesús meꞌe ti ixro kuíntuenta ti juinchekonchjiannta tjatuꞌo ko jai ikjan ndo ixro tjintee. ");
INSERT INTO pps_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Ixi jeꞌo ndo Jesús chónda juachaxin sincheméꞌe ndo ijie̱ ko jeꞌo jeꞌe ndo tsixruaꞌan ndo Dio ngataꞌa xasintajni ixi koꞌa inaa ngisen tsitikaon na̱ ixi tsoméꞌe jíee na̱. ");
INSERT INTO pps_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Ko xi tetuanꞌan bikon xa ixi ndo Pedro ko ndo Juan nichja sen ixi nchijíi aséen sen ko konoꞌe xa ixi sen meꞌe xranchi ngixeꞌi inaa sen ko jeꞌa ni ícha noꞌe xroon. Tjumeꞌe xronka xi ixi kuichúxin xa ixi sen meꞌe tsikajikao ndo Jesús. ");
INSERT INTO pps_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Ko xi tsikoxrueꞌen ntiꞌa stekao sen xa. Méxin, juaꞌi tsjankataꞌa xa ijie̱ ngajin sen. ");
INSERT INTO pps_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Ko kuetuanꞌan xa ixi ndo Pedro ko ndo Juan tsachrje sen nduja ko tjumeꞌe jeꞌo xa kuituꞌe xa ngaxinꞌin nchia juintejao kichuu xa. ");
INSERT INTO pps_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Ko tjumeꞌe ndachro xa: ―¿Ngeꞌe sinchekuuna xi ña̱? Ixi kain ni tjajna Jerusalén bikon na̱ ixi ndo Dio bingijna ndo xi jiꞌi, meꞌe koxruenꞌen xi niꞌe ko juaꞌi xrondachrona ixi nduaxinꞌa. ");
INSERT INTO pps_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Ko ítjaunꞌana xronichja xi jiꞌi ngajin kain na̱. Méxin, xrondachena xa íxronichjaxinꞌa xa nombrée ndo Jesús. ");
INSERT INTO pps_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Meꞌe kuiyeꞌe xa sen íjngo ko kuetuenꞌen xa sen ixi xronichjaꞌi sen ko ítsjakoꞌa sen ixi nombrée ndo Jesús. ");
INSERT INTO pps_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Ko tjumeꞌe ndo Pedro ko ndo Juan juateꞌe sen ko ndachro sen: ―Xraxaon jaꞌanta, ¿á xrobakeꞌe ndo Dio juaxruxin siá xrokuitikaꞌonna ngeꞌe ndachro jaꞌanta o̱ xrokuitikaꞌonna ngeꞌe tituanꞌan jeꞌe ndo? ");
INSERT INTO pps_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Ko janꞌanna juaꞌi tsintuꞌana xronichjana ngeꞌe bikona ko ngeꞌe kuinꞌanna. ");
INSERT INTO pps_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Ko tjumeꞌe jeꞌe na̱ kuyakutee na̱ sen ko kuintuꞌe na̱ sen sakjui sen ixi kuitjaꞌi na̱ xranchi chao xrobikaon sen ixi kain ni tjajna ntiꞌa tajon na̱ juasaya ngajin ndo Dio ixi ti ngeꞌe jian juincheꞌe sen. ");
INSERT INTO pps_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Ko xi koxruenꞌen ixi juachaxien ndo Dio, xi meꞌe chónda xa ícha ixi yuu kán nano. ");
INSERT INTO pps_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Tjumeꞌe ndo Pedro ko ndo Juan ó tsikajánda na̱ sen, meꞌe ikjui sen ti tsixraꞌo kain sen chúxin sen. Ko chronga sen kain ti kuetuanꞌan xitaana tetuanꞌan ko sen tachríi tetuanꞌan. ");
INSERT INTO pps_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Ko juexin kuinꞌen sen, meꞌe kain sen nichjeꞌe sen ndo Dio ko ndachro sen: ―Ncháina, jaꞌanta juinchekonchjiannta ngajní ko nunte xasintajni ko ndachaon ko kain ngeꞌe jii. ");
INSERT INTO pps_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Jaꞌanta ixi Espíritue ndo Dio nichjaxinnta ngajin ndo David, ndo juincheꞌe ixra̱ ngajinnta meꞌe jaꞌin ndachro ndo: ¿Sonda toñao ko tjakaxin kain ni tjajna chuxinꞌanta? Xroꞌan tjintee kain ti xraxaon na̱. ");
INSERT INTO pps_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Sen rey jii nunte xasintajni ko kain ni tjajna naakua xraka na̱ ningakonꞌen na̱ Ncháina Dio ko ndo Cristo. ");
INSERT INTO pps_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","*’Nduaxin xi Herodes, ko xi Poncio Pilato, ko ni tsikjixin ikjín, ko ni israelita tsixraꞌo tjajna ntiꞌi ixi ningakonꞌen na̱ Chjanꞌan ndo Jesús, ndo chóndaꞌi ijie̱, meꞌe ndo kuincheꞌenta tsóña ndo Mesías. ");
INSERT INTO pps_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Jaña juincheꞌe na̱ ngeꞌe ó saꞌó tsindachronta ixi jaña xrokonda xrokonꞌen. ");
INSERT INTO pps_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Ncháina, tsjeꞌenta ti juinchexronka na̱ sen ko tingijnanta sen ncheꞌe xráanta ixi xrochronga sen chijnianta ko xroxrakonꞌa sen. ");
INSERT INTO pps_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Ko ixi juachaxiannta sinchexrjuenꞌen sen ni niꞌe ko sincheꞌe sen ijié ixra̱ ixi nombrée chjanꞌanta, ndo tsango tjúá, ndo Jesús. ");
INSERT INTO pps_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Ko juexin nichjeꞌe sen ndo Dio, bengi nunte ti ste sen. Ko kain sen kuayéꞌe sen juachaxien Espíritue ndo Dio ko kuaxi sen chronga sen chijnie ndo Dio ko xrakonꞌa sen. ");
INSERT INTO pps_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","*Kain sen kuitikaon ndo Jesús naakua ngeꞌe xraxaon sen ko kain sen tonchjeyeꞌe kichuu sen ti chónda sen ko xroꞌan ngisen ndachro ixi jeꞌe sen tituanꞌan sen xrojan ngeꞌe. ");
INSERT INTO pps_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Sen kuincheꞌe ndo Jesús ixi juachaxien ndo Dio kuachronga sen ixi xechón Ncháina Jesús ko ndo Dio ícha juinchenchaon ndo sen. ");
INSERT INTO pps_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Ko xroꞌan sen nóa bakeꞌe ngakjenꞌen sen ixi kain sen kuachónda jngiꞌe ko ndoꞌa kuanchekji sen ko meꞌe tikaꞌo sen tomi ");
INSERT INTO pps_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","ko bakajon sen ngajin sen kuincheꞌe ndo Jesús ko jeꞌe sen bakonchjeya sen ngajin ngujngu sen xrokondeꞌe. ");
INSERT INTO pps_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Xranchi juincheꞌe naa xi levita ndatinꞌin José. Jeꞌe xa tsiki̱ꞌxi̱n xa nunte Chipre ko sen kuincheꞌe ndo Jesús juinchekinꞌin sen xa Bernabé, meꞌe xrondachro ngisen tajon juaxruxin. ");
INSERT INTO pps_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Jeꞌe ndo Bernabé juinchekji ndo naa ijngi kuachónda ndo ko bikaꞌo ndo tomi ngajin sen kuincheꞌe ndo Jesús. ");
INSERT INTO pps_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Ko naa xi ndatinꞌin Ananías, ko janchriꞌe xa, Safira, juinchekji sen naa ijngi kuachónda xa. ");
INSERT INTO pps_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Ko xi jiꞌi kuituꞌe xa tuꞌya tomi ko tuꞌya tomi bikaan xa ngajin sen kuincheꞌe ndo Jesús xranchi xrokjui kain tomi. Ko janchriꞌe xa noꞌe jan kaxon. ");
INSERT INTO pps_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Méxin, ndo Pedro ndachro ndo: ―Ananías, ¿sonda chje̱ꞌé juachaxin Xixronꞌanxrée kuixinꞌin xa ntakuian ixi xrojuincheyeꞌé Espíritue ndo Dio ko xrokuituaꞌa tuꞌya tomi tsinchekjixian nunte? ");
INSERT INTO pps_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","¿Á jeꞌa jngiꞌa? Ko siá ó juinchekjia ijngi, ¿á jeꞌa tomia? ¿Sonda xraxaoan juincheꞌe jaꞌin? Jaꞌa juincheyeꞌé ndo Dio, jeꞌa juincheyeꞌé chujni. ");
INSERT INTO pps_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Ko kuinꞌen xi Ananías jiꞌi, tuinxin kuitsinga xa ko ndakuenꞌen xa. Ko kain sen kuinꞌen jiꞌi, tsango xronka sen. ");
INSERT INTO pps_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Tjumeꞌe kaxin chajan kuintsía chán manta cuerpoe xi Ananías ko sabikao chán xa, xroxrabaa xa. ");
INSERT INTO pps_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Níi hora tjumeꞌe kuixinꞌin janchriꞌe xi Ananías ti ste sen. Ko noeꞌa nchra ngeꞌe konꞌen ntiꞌa. ");
INSERT INTO pps_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Ko ndo Pedro juanchangiꞌe ndo nchra: ―Ndachijiana, ¿á juinchekjixinta ijngi ixi ti tomi ndachronta? Ko juatingíexin nchra: ―Jaán, jaña kochjixin ijngi. ");
INSERT INTO pps_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Ko ndo Pedro ndachro ndo: ―¿Sonda juintejaonta xrojuincheyeꞌénta Espíritue ndo Dio? Nduja ste chajan bikao ndoxiꞌa kuixrabaa ndo ko jai jaꞌa satikoꞌa chán tsixrabaa kaxon. ");
INSERT INTO pps_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Ko tuinxin kueꞌé nchri Safira nunte tjenka tutée ndo Pedro ko ndakuenꞌen nchra. Tjumeꞌe kuixinꞌin chajan nchia ko bikon chán nchra ndatsikenꞌen nchra ko kuantsje chán nchra, ko bijabaa chán nchra ndatsjonxin nango ti no jixrabaa ndoxiꞌe nchra. ");
INSERT INTO pps_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Kain sen niꞌngo ko ikaxin sen kuinꞌen sen ngeꞌe konꞌen, meꞌe tsango xronka sen. ");
INSERT INTO pps_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Tjumeꞌe sen kuincheꞌe ndo Jesús juincheꞌe sen kueya ixra̱ ijié ngajin ni ste ntiꞌa ixi juachaxien ndo Dio ko kain sen xraꞌo sen ngaxinꞌin nda̱sin ndatinꞌin Salomón. ");
INSERT INTO pps_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Ninaa na̱ tjaunꞌa na̱ xrokonchjiñeꞌe na̱ tjenka sen titikaon Ncháina Jesús. Ko chujni tjajna chaxro kuanichja na̱ ixi jeꞌe sen. ");
INSERT INTO pps_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Ko kueya xi ko nchri kaxon kuitikaon na̱ Ncháina Jesús. ");
INSERT INTO pps_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Ko itsjé na̱ bakantsje na̱ ni niꞌe ko bakeꞌe na̱ ni niꞌe ngatja chaꞌo, ngataꞌa camé na̱ ko kanieꞌe na̱ ixi tsatsinga ndo Pedro ko maski jeꞌo tsauen ndo tsatsinga ti ste na̱, tsoxruenꞌen na̱. ");
INSERT INTO pps_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Itsjé ni ikaxin tjajna ntiꞌa baki̱i̱ na̱ tjajna Jerusalén bikaꞌo na̱ ni niꞌe ko ni chónda espíritue xiñaꞌi ko kain na̱ koxruenꞌen na̱. ");
INSERT INTO pps_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Ko tjumeꞌe xitaana tetuanꞌan ko xi saduceo tsango kochjuyeꞌe xa ngajin sen kuincheꞌe ndo Jesús, ");
INSERT INTO pps_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","ko itsé xa sen xraxinꞌin xa sen ndoꞌachjiso. ");
INSERT INTO pps_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Tjumeꞌe naa ndo ángel neꞌe Ncháina Jesús kui̱i̱ tiie kuantjeꞌe ndo nta̱chja ndoꞌachjiso ko kuantsje ndo sen. Ko jaꞌin ndache ndo sen: ");
INSERT INTO pps_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","―Itjinta niꞌngo ko nchekuenꞌennta kain ni ste ntiꞌa chijni tsechónxin chujni. ");
INSERT INTO pps_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Ko juexin kuinꞌen sen jiꞌi, ndúyaxin sakjui sen kuixinꞌin sen niꞌngo ko juinchekuenꞌen sen ni ste ntiꞌa. Ko xitaana tetuanꞌan ko ni chrikao xa kue̱ya̱ xa ixi xroxraꞌo ni tetuanꞌan Israel. Ko kuetuanꞌan na̱ ixi tsixrakua sen ste ndoꞌachjiso, sen kuincheꞌe Ncháina Jesús. ");
INSERT INTO pps_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Tjumeꞌe kuiji xi soldado ndoꞌachjiso ko kuitjaꞌi xa sen ko ikjan xa ");
INSERT INTO pps_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","ko ndachro xa: ―Juasona ntiꞌa ko bikona jijeꞌe̱ jian ndoꞌachjiso ko ntiꞌa ste xi jindaa nta̱chja. Ko kuantjanꞌana ndoꞌachjiso ko kuitjaꞌina sen jijeꞌe̱ ntiꞌa. ");
INSERT INTO pps_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Ko kain xi tetuanꞌan xitaana ko xi tetuenꞌen xi policía neꞌe niꞌngo ko ikaxin xitaana tetuanꞌan kuinꞌen xa jiꞌi ko meꞌe xraxaon xa ixi ngeꞌe ícha xrokonꞌen. ");
INSERT INTO pps_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Ko tuinxin kuiji naa ngisen ndachro: ―Ni xraxinꞌinnta ndoꞌachjiso ó ste na̱ ngaxinꞌin niꞌngo, ntiꞌa stenchekuenꞌen na̱ chujni. ");
INSERT INTO pps_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Ko tjumeꞌe xi tetuenꞌen xi policía bikao xa xi policié xa ko jian bikaꞌo xa sen ixi xronka xa ba ni tjajna tsaxi na̱ xa ixro. ");
INSERT INTO pps_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Ko hora bikaꞌo xa sen, bakeꞌe xa sen ngajinxin xi tetuanꞌan, ko xitaana tetuanꞌan ndachro xa: ");
INSERT INTO pps_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","*―Janꞌanna kuajonꞌana juachaxin ixi tsjakonta nombrée xi Jesús ko jaꞌanta kuitikaonꞌanta ko nchijíi tjajna Jerusalén juakoꞌenta na̱ ko tjaunnta tjankataꞌantana ijie̱ ixi janꞌanna konꞌina xi meꞌe. ");
INSERT INTO pps_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Tjumeꞌe ndo Pedro ko kaxin sen kuincheꞌe ndo Jesús ndachro sen: ―Janꞌanna xrokonda tsitikaꞌonna ndo Dio saꞌó ko tjumeꞌe tsitikaꞌonna chujni. ");
INSERT INTO pps_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Ndo Dio, tsikitikaon sen kuachrjenixinna, ndo Dio meꞌe juinchexechón ndo Jesús, ndo kuenitonta nta̱cru. ");
INSERT INTO pps_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Ko jai bakeꞌe ndo Dio ndo Jesús ngajní ndatsjonxin jian ti jii jeꞌe ndo ko kuajon ndo juachaxin ixi jeꞌe ndo tsituanꞌan ndo ko tsantsjeꞌe ndo na̱ ijie̱ ixi ni tjajna Israel xrokjan na̱ xrokuitikaon na̱ ndo Dio, ko meꞌe xrokuitjáña ijie̱ chónda na̱. ");
INSERT INTO pps_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Ko kaxon janꞌanna nichjana kain ngeꞌe bikona ixi juachaxien Espíritue ndo Dio, Espíritu meꞌe tajon ndo Dio tsayéꞌe kain sen nduaxin tsitikaon ndo. ");
INSERT INTO pps_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Ko xi tetuanꞌan kuinꞌen xa kain jiꞌi ko tjumeꞌe ícha koñao xa ko tjaun xa xrokóña xa sen. ");
INSERT INTO pps_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Ko tjumeꞌe naa xi fariseo, xi meꞌe kaxon tituanꞌan xa, ndatinꞌin xa Gamaliel. Jeꞌe xa naa xi maestro juinchekuenꞌen xa ley kain ni tjajna ntiꞌa ko ni tjajna chóndeꞌe na̱ xa juasaya. Bingatjen xa ko ndache xa sen kuincheꞌe Ncháina ixi tsachrje sen nduja naa nchion. ");
INSERT INTO pps_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Tjumeꞌe nichjeꞌe xa kain xi tetuanꞌan ko ndachro xa: ―Jaꞌanta ni israelita, xraxaonnta ngeꞌe sinchekuunta sen jiꞌi. ");
INSERT INTO pps_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Xraxaonnta ixi ó saꞌó bakeꞌe naa xi ndatinꞌin Teudas ko bandachro xa ixi tsango tituanꞌan xa. Ko noó ciento na̱ baruéꞌe na̱ xa. Tjumeꞌe íkaxin chujni kóña na̱ xa ko kain ni baruéꞌe xa chjekeꞌe na̱ ko kuitjáña na̱ ko tjumeꞌe ndajuexin ixra̱ juincheꞌe xa. ");
INSERT INTO pps_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Tjumeꞌe nchakon kueki na̱ chujni tjajna, kui̱i̱ inaa xi ndatinꞌin Judas, naa xi tjajna Galilea, ko itsjé na̱ ruéꞌe na̱ xa. Ko tjumeꞌe kaxon kóña na̱ xa ko kain ni baruéꞌe xa juexin na̱. ");
INSERT INTO pps_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Méxin, tintuꞌenta sen jiꞌi ko tingakuenꞌanta sen. Siá jincheꞌe sen ixra̱ neꞌe chujni, ixra̱ jiꞌi tsjexin xra̱. ");
INSERT INTO pps_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Ko siá nduaxin nchekuenꞌen sen chujni juachaxien ndo Dio, jaꞌanta juaꞌi tsingakonꞌennta sen. Méxin, tintuꞌenta sen, siá naꞌi, jaꞌanta ritetokuꞌunta ndo Dio. ");
INSERT INTO pps_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Tjumeꞌe kain xi tituanꞌan kuitikaon xa ko kuiyeꞌe xa sen tsikincheꞌe ndo Jesús ko kóña na̱ sen ko kuetuanꞌan xa ngajin sen ixi íxronichjaꞌi sen ixi nombrée ndo Jesús ko tjumeꞌe kuajanda xa sen, satsji sen. ");
INSERT INTO pps_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Tjumeꞌe sen kuincheꞌe ndo Jesús kuachrjexin sen ti ste xi tituanꞌan, ko maski jaña konꞌen sen, bakeꞌe sen juaxruxin ixi ndo Dio kuajon ndo juachaxin tangi konꞌen sen kondee nombrée ndo Jesús. ");
INSERT INTO pps_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Ko kuintueꞌa sen ti tjako sen chijnie ndo Jesucristo kain nchakon ngaxinꞌin niꞌngo ko ngujngu ndoꞌa chujni. ");
INSERT INTO pps_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Nchakon meꞌe ícha konkueya sen titikaon Ncháina Jesús. Tjumeꞌe sen nichja ngigua griego bajakaxin sen ngajin sen nichja ngigua hebreo. Ndachro sen ixi nchri kaꞌan tjajnée sen griego tayéꞌa nchra itsjé ngeꞌe tonchjeya sen sine nchra ngujngu nchakon. ");
INSERT INTO pps_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Tjumeꞌe sen teyuu kuincheꞌe ndo Jesús kuiyeꞌe sen kain sen titikaon ndo ko ndachro sen: ―Jai̱na juaꞌi tsintuꞌena ti nchekuenꞌenna chujni chijnie ndo Dio ko itsjina tsonchjeyana ngeꞌe sine nchri kaꞌan. ");
INSERT INTO pps_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Méxin, jaꞌanta kichianna tincheꞌenta ya̱a̱to̱ xi ste ngakjenꞌennta, sen jian chuxinnta ko sen noꞌe ko sen ícha chónda Espíritue ndo Dio, sen meꞌe xrochjeꞌénta ixra̱ jiꞌi. ");
INSERT INTO pps_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Ko janꞌanna xronichjaꞌana ndo Dio ko tsjakona chijnie ndo. ");
INSERT INTO pps_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Kain sen kuinꞌen meꞌe ko naakua naa ngeꞌe xraxaon sen. Ko kuincheꞌe sen ndo Esteban, ndo tsango chuntia Ncháina ko ícha chónda ndo Espíritue ndo Dio, ko kaxon ndo Felipe, ndo Prócuro, ndo Nicanor, ndo Timón, ndo Parmenas ko ndo Nicolás. Jeꞌe ndo meꞌe ndo tjajna Antioquía ko ó saꞌó tsikitikaon ndo xranchi ni judío. ");
INSERT INTO pps_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Ko juexin kuincheꞌe sen sen sincheꞌe xra̱ meꞌe, bikaꞌo kichuu sen ti ste sen tsikincheꞌe Ncháina Jesús. Ko jeꞌe sen nichjeꞌe sen ndo Dio ko bakeꞌe itja sen ngataꞌa ngujngu sen kuayéꞌe xra̱ meꞌe. ");
INSERT INTO pps_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Chijnie ndo Dio tsango binga nunte ntiꞌa ko kueya na̱ kuitikaon na̱ Ncháina tjajna Jerusalén. Kaxon itsjé xitaana judío kuitikaon xa Ncháina. ");
INSERT INTO pps_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Ndo Esteban, ndo kuachónda juachaxin neꞌe ndo Dio, kuancheꞌe ndo itsjé ixra̱ ijié ngajin na̱. ");
INSERT INTO pps_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Tjumeꞌe kaxin ni tsiki̱ꞌxi̱n niꞌngo judío, ni saꞌó bakeꞌe esclavo, ni meꞌe tsiki̱ꞌxi̱n na̱ tjajna Cirene, ko Alejandría, ko Cilicia, ko nunte Asia, ni meꞌe juakaxin na̱ ngajin ndo Esteban. ");
INSERT INTO pps_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Ko juaꞌi juacha na̱ ixi Espíritue ndo Dio kuanichjaxin ndo Esteban. ");
INSERT INTO pps_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Tjumeꞌe jeꞌe na̱ juengeꞌe na̱ ꞌna̱ ikaxin na̱ ixi xrondachro na̱ kuinꞌen na̱ nichjangíꞌe ndo Esteban ndo Moisés ko ndo Dio. ");
INSERT INTO pps_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Meꞌe tsango koñao kain ni tjajna ko xi tetuanꞌan niꞌngo ko xi tjako ley. Tjumeꞌe itsé na̱ ndo Esteban sabikao na̱ ndo ngajin ni tetuanꞌan. ");
INSERT INTO pps_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Kaxon juée na̱ ni ncheya ixi ndachro na̱ ndakoꞌa juako ndo Esteban ko ndachro na̱: ―Xi jiꞌi tsango nichjangíꞌe xa ningoina ko ley kuetuanꞌan ndo Moisés. ");
INSERT INTO pps_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Kuinꞌanna chronga xa ixi xi Jesús, xi tjajna Nazaret, sinchetjáña xa ningoina ntiꞌi ko tsindoxin xa ngeꞌe titikaonna ti tsinichja ndo Moisés. ");
INSERT INTO pps_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Tjumeꞌe xi tetuanꞌan ko kain ni ste ntiꞌa stetsjeꞌe na̱ ndo Esteban ko bikon na̱ ixi ikon ndo Esteban ikjan xranchi ikon naa ndo ángel. ");
INSERT INTO pps_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Tjumeꞌe xitaana tetuanꞌan juanchangiꞌe xa ndo Esteban ko ndachro xa: ―¿Á nduaxin kain ti ndachro na̱ ixi jaꞌa? ");
INSERT INTO pps_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Tjumeꞌe jeꞌe ndo juateꞌe ndo ko ndachro ndo: ―Kichianna xrotjajna Israel ko sen tachríi tinꞌennta ngeꞌe xrondachrja̱n. Ndo Dio titikaꞌonna chónda juachaxin, ndo meꞌe juako ndo juachaxien ndo ngajin ndo Abraham, ndo kuachrjenixinna nchakon bakeꞌe ndo tjajna Mesopotamia, xrasatjiꞌa ndo nunte Harán. ");
INSERT INTO pps_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Ndo Dio ndache ndo ndo Abraham: “Tintuꞌé tjajnáa ko kain sen ndúia ko satjia naa nunte tsjakoꞌa.” ");
INSERT INTO pps_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Tjumeꞌe ndo Abraham kuachrjexin ndo nunte Caldea ko sakjui ndo ko bakeꞌe ndo nunte Harán. Ko ó juexin kuenꞌen ndotée ndo, tjumeꞌe ndo Dio bikao ndo ndo Abraham ti no stenta jai. ");
INSERT INTO pps_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Ko ndo Abraham kuayéꞌa ndo nituꞌo nunte ti no tsakeꞌe tutée ndo. Tjumeꞌe chronga ndo Dio ixi nchakon tsenꞌen ndo Abraham, nduaxin sen tsachrjenixin ndo tsayéꞌe sen nunte jiꞌi. Maski xrachóndaꞌi ndo ichjan, jaña ndachro ndo Dio. ");
INSERT INTO pps_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Kaxon tsindachro ndo Dio ixi sen tsachrjenixin ndo Abraham, sen meꞌe tsetaꞌa sen jée nunte, ko sincheꞌexin sen xrée na̱, ntiꞌa chjinga sinchekao na̱ sen ko xroxengeꞌa sen ꞌna̱ ko ntiꞌa tsintee sen noó ciento nano. ");
INSERT INTO pps_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Kaxon ndachro ndo Dio: “Tjumeꞌe janꞌan sintaña ijie̱ ngajin ni juincheniꞌe chjanꞌan ti no juinchincheꞌe na̱ xjan xra. Ko tjumeꞌe sintakjan chjanꞌan ko xrochjiana xjan juasaya ntiꞌi.” ");
INSERT INTO pps_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Tjumeꞌe ndo Dio tsijao ndo ndo Abraham ixi kain xjan xi tsachrjenixin ndo tsaa xjan chjiꞌe xjan neꞌe sen israelita. Ko jaña nchakon jongíꞌe chjenꞌen ndo Abraham, xjan saꞌó, xjan Isaac, ndo Abraham chjée ndo xjan chjiꞌe xjan nchakon kuitja xjan ijní nchakon. Kaxon jaña juincheꞌe ndo Isaac nchakon kuichónda chjenꞌen ndo, xjan Jacob, ko tjumeꞌe ndo Jacob jaña juincheꞌe ndo ngajin ti teyuu chjenꞌen ndo. Sen meꞌe kóña ndotée ti teyuu tjajna Israel. ");
INSERT INTO pps_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","’Ko chjenꞌen ndo Jacob, sen kuachrjenixinna ó saꞌó, sen meꞌe kochjio sen ngajin xjan kichuu sen xjan José, ko juinchekji sen xjan ngajin kaxin xi, ko sabikao na̱ xjan tjajna Egipto, ko ndo Dio bingijna ndo xjan ");
INSERT INTO pps_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","ko kuantsje ndo ti tangi bakeꞌe ndo. Ko ndo Dio kuajon juachaxin ixi tsango konoꞌe ndo kain ngeꞌe. Meꞌe bikon xi Faraón, rey tjajna Egipto, ixra̱ jian juincheꞌe ndo José, ko kuajon xa juachaxin ixi tsetuanꞌan ndo José tjajna Egipto ko ndoꞌa xa. ");
INSERT INTO pps_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","’Tjumeꞌe kui̱i̱ jinta ngataꞌa tjajna Egipto ko nunte Canaán ko tangi kuintee na̱ ko sen tsikachrjenixinna chóndaꞌi sen ngeꞌe sine sen. ");
INSERT INTO pps_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Ko tsikinꞌen ndo Jacob ixi tjajna Egipto jitochji̱ noa trigo ko kuetuenꞌen ndo chjenꞌen ndo ixi tsintekji xjan ntiꞌa tseꞌna xjan noa, ko jeꞌe xjan meꞌe sen tsikachrjenixinna. Jiꞌi saꞌó ikjui xjan ntiꞌa. ");
INSERT INTO pps_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Tjumeꞌe yuxin ikjan sen ntiꞌa ko ndo José juinchenoꞌe ndo sen ixi jeꞌe ndo ndo kichuu sen. Ko juakoꞌe ndo José xi Faraón kain ndo saoé ndo. ");
INSERT INTO pps_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Tjumeꞌe kuetuanꞌan ndo José ixi tsjiruéꞌe sen ndotée ndo, ndo Jacob, ko kain sen kichuu ndo, xranchi níi ikán ko tenaꞌó sen. ");
INSERT INTO pps_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Jaña konꞌen ko ndo Jacob, sakjui ndo bakeꞌe ndo tjajna Egipto ko tjumeꞌe ntiꞌa kuenxin ndo. Ko kaxon sen tsikachrjenixinna ntiꞌa kuenxin sen. ");
INSERT INTO pps_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Ko tjumeꞌe kuantsjengí sen nteꞌe ndo Jacob ko sabikao sen nteꞌe ndo nunte Siquem, ko ntiꞌa juabaa sen nta̱a̱ ti naa nunte tsikeꞌna ndo Abraham, tsijinchekji chjenꞌen xi Hamor tjajna Siquem. ");
INSERT INTO pps_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","’Tjumeꞌe kui̱i̱ nchakon tsonꞌen ngeꞌe tsindachro ndo Dio tsijao ndo ndo Abraham, ko sen Israel tsango konkueya sen tjajna Egipto. ");
INSERT INTO pps_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Tjumeꞌe tuinxin inaa xi rey baketuanꞌan tjajna Egipto kuachúxinꞌa xa ndo José. ");
INSERT INTO pps_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Ko xi rey meꞌe juincheyeꞌe xa sen tjajnai̱na ko chinga juinchekao xa sen. Kuetuanꞌan xa ixi chjenꞌen sen xjan xi nandá tsjongíꞌe, tsintuꞌe sen xjan ixi tsintekenꞌen xjan. ");
INSERT INTO pps_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Ko tjumeꞌe nchakon tsijongíꞌe ndo Moisés tsango bakeꞌe juaxruxin ndo Dio ixi xjan meꞌe. Ko ndotée xjan ko janée xjan kuachónda sen xjan ndoꞌa sen níi nchanitjao. ");
INSERT INTO pps_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Tjumeꞌe juaꞌi tsemá sen xjan ícha, meꞌe bijánka sen xjan. Ko nchrichjeꞌen xi rey tjajna Egipto kuitja nchra xjan ko sabikao nchra xjan ko juinchekangi nchra xjan xranchi chjenꞌen nchra. ");
INSERT INTO pps_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Ko tjumeꞌe ndo Moisés kuangi ndo kain ngeꞌe noꞌe ni Egipto ko tsango chónda ndo juachaxin ti ngeꞌe ndachro ndo ko ngeꞌe kuancheꞌe ndo. ");
INSERT INTO pps_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","’Ko nchakon kuichónda ndo Moisés yuu ikán nano xraxaon ndo tsitsjeꞌe ndo ni israelita, ni kichuu ndo. ");
INSERT INTO pps_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Ntiꞌa bikon ndo ixi naa xi tjajna Egipto jitoña xa naa ni kichuu ndo. Meꞌe bingijna ndo ni kichuu ndo ko naakóñaxón ndo xi Egipto. ");
INSERT INTO pps_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Xraxaon ndo ixi ni kichuu ndo, ni israelita, xrokonoꞌe na̱ ixi ndo Dio tsixruaꞌan ndo jeꞌe ndo tsingijna ndo na̱. Ko jeꞌe na̱ juatsuanꞌi na̱ ndo. ");
INSERT INTO pps_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Tjumeꞌe inaa nchakon ndo Moisés bikon ndo ixi yuu ni israelita steteto na̱. Ko tjaun ndo xrojuikeꞌe̱ ndo ixi íxrokue̱to̱ꞌa na̱. Ko ndachro ndo: “Jaꞌanta kichuunta, ¿sonda stetetonta?” ");
INSERT INTO pps_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Tjumeꞌe xi chónda ijie̱ koñao xa ko kuncheka xa ndo Moisés. Ko ndachro xa: “¿Ngisen kuajon juachaxin ixi jaꞌa tsituanna̱na ko sinchéña ijie̱ ngajin na̱? ");
INSERT INTO pps_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","¿Á tjauan tsonꞌiana xranchi naakóñáxuan xi Egipto najna?” ");
INSERT INTO pps_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Ko kuinꞌen ndo Moisés jiꞌi ko sabinga ndo tjajna Madián ko ntiꞌa bakeꞌe ndo xranchi naa ni tsiki̱ꞌxi̱n jée nunte. Ko tjumeꞌe ntiꞌa kuteꞌe ndo ko kuachónda ndo yuu xjan xi. ");
INSERT INTO pps_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","’Tjumeꞌe kuatsinga yuu kán nano ko tjenka jna̱ ndatinꞌin Sinaí bikon ndo naa ndo ángel tjenka naa nta̱a̱ yaa xroꞌi. ");
INSERT INTO pps_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Ko ndo Moisés xronka ndo ixi jaña bikon ndo ko konchjiñeꞌe ndo ixi xrotsjeꞌe ndo ti xroꞌi ko kuinꞌen ndo tée Ncháina Dio ndachro: ");
INSERT INTO pps_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","“Janꞌan ndo Dio titikaon sen tsikachrjenixin ndo Abraham, ko ndo Isaac, ko ndo Jacob.” Ko ndo Moisés kuaxi xranga ndo ko xronka ndo ko tjaunꞌa ndo xrotsjeꞌe ndo. ");
INSERT INTO pps_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Ko ndachro Ncháina: “Tantsje kateá ixi nunte ritingatjangia, nunte tjúá. ");
INSERT INTO pps_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Janꞌan bikon ixi ni tjajnána tsango tangi ste na̱ tjajna Egipto ko ó kui̱nꞌa̱n ixi teya na̱. Ko jai juiꞌi ixi tsingijna na̱. Méxin, xroxruanꞌan jaꞌa itsjia tjajna Egipto.” ");
INSERT INTO pps_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","’Ko ni israelita juanoa na̱ ndo Moisés ko tsindachro na̱: “¿Ngisen tjáa juachaxin ixi jaꞌa tsituanna̱na ko sinchéñana̱na ijie̱?” Ko ndo Dio xruanꞌan ndo ndo Moisés ixi tsetuanꞌan ndo ko tsingijna ndo ni israelita ko ixi juachaxien ndo ángel bikon ndo ngakaꞌa nta̱a̱ yaa xroꞌi. ");
INSERT INTO pps_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Ndo Moisés kuantsjexin ndo ni tsikachrjenixinna tjajna Egipto. Tsango itsjé ixra̱ ijié juincheꞌe ndo ko itsjé ngeꞌe juakoxin ndo tjajna Egipto, ko ndachaon tinꞌin Ndachaon Játse, ko no ntajie kuaji na̱ yuu kán nano. ");
INSERT INTO pps_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Jeꞌe ndo Moisés ndache ndo ni israelita: “Ndo Dio xroxruanꞌan naa ngisen xronichja chijnie ndo xranchi xruanꞌanna ndo janꞌan ko ndo meꞌe tsachrjenixin ndo ni kichuunta. Titikaonnta ndo.” ");
INSERT INTO pps_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Ndo Moisés bakeꞌe ndo ngajin ni israelita nchakon bakeꞌe na̱ ntajie. Ko juao ndo ndo ángel neꞌe ndo Dio ijna̱ Sinaí ko ni kuachrjenixinna kuayéꞌe na̱ chijni tajon juachaxin tsechón chujni, ko chijni meꞌe kuayeꞌena jai. ");
INSERT INTO pps_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","’Tjumeꞌe ni kuachrjenixinna kuitikaonꞌa na̱ ko juanoa na̱ ndo Moisés ko tjaun na̱ íjngo xrokjan na̱ tjajna Egipto. ");
INSERT INTO pps_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Ko ndache na̱ ndo Aarón: “Tjaꞌonna xrochondana naa dio tsitaonana ntiꞌa ixi ínonaꞌina ngeꞌe konꞌen ndo Moisés, ndo bingijna kuachrjexinna tjajna Egipto.” ");
INSERT INTO pps_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Ko juinchéña na̱ naa kuxintachjan ko naakóñaxón na̱ iko kuajon na̱ kuayéꞌe kuxintachjan meꞌe, ko tsango bakeꞌe na̱ juaxruxin ixi bikon na̱ ngeꞌe tsikóñaxin itja chujni. ");
INSERT INTO pps_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Tjumeꞌe ndo Dio kuintuꞌe ndo na̱ ixi tsitikaon na̱ nchanotsé jii ngajní. Jiꞌi tsikjin naa ngisen kuachronga chijnie ndo Dio ko ndachro jaꞌin: Jaꞌanta ni Israel, ¿á naakóñaxónnta iko xrokuayaꞌa̱ janꞌan ti yuu kán nano bakeꞌenta ntajie? ");
INSERT INTO pps_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Naꞌi, jaꞌanta bikuꞌunta iko meꞌe ti jii ningue xi dio Moloc ko kaxon bikuꞌunta nchanotsé neꞌe xi dio Renfán. Jaꞌanta juinchekonchjiannta kain jiꞌi ixi xrochjeꞌénta juasaya xranchi xrokjui ndo dio naꞌanta. Méxin, janꞌan tsantsjexinnta tjajnánta ko xroxruanꞌannta tjajna Babilonia ko ícha ntaꞌa. ");
INSERT INTO pps_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","’Xrabakeꞌe ni kuachrjenixinna ntajie, ntiꞌa chónda na̱ naa niꞌngo tsikonchjianxin manta ti no jii ley tsiketuanꞌan ndo Dio. Jiꞌi juinchéña na̱ xranchi tsiketuenꞌen ndo Dio ndo Moisés sinchéña ndo xranchi tsikikon ndo. ");
INSERT INTO pps_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Tjumeꞌe ni tsikachrjenixinna kuayéꞌe na̱ niꞌngo manta kuituꞌe na̱. Tjumeꞌe ni chrikao ndo Josué bikao na̱ niꞌngo meꞌe nchakon juacha na̱ kuayéꞌe na̱ nunteꞌe ikaxin tjajna, ni meꞌe kuantsjexin ndo Dio. Jaña konꞌen kuijija nchakon kuaxi kuetuanꞌan ndo David. ");
INSERT INTO pps_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Tsango juinchenchaon ndo Dio ndo rey David ko ndo David tjaun ndo sinchekonchjian ndo naa ningue ndo Dio, ndo tsikitikaon ndo Jacob. ");
INSERT INTO pps_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Ko jeꞌe ndo juinchekonchjianꞌi ndo niꞌngo. Ndo Salomón, chjenꞌen ndo David, juinchekonchjian niꞌngo meꞌe. ");
INSERT INTO pps_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Ko ndo Dio jii ngajní jiꞌa ndo ngaxinꞌin naa niꞌngo tsikonchjianxin itja chujni. Ndachro naa xi nichja chijnie ndo Dio: ");
INSERT INTO pps_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Janꞌan ndo Dio ngajní ntiꞌa tetuanxin ko nunte xasintajni ntiꞌa jitaꞌa tutéena. ¿Ngixeꞌe nchia sinchekonchjiananta?, o̱, ¿ti no tsakeꞌe tsjokéena? ");
INSERT INTO pps_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","¿Á jeꞌa tjáana juintañaxin kain ngeꞌe? ");
INSERT INTO pps_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","’Ko jaꞌanta icha asáanta ko titikaonꞌanta. Jaꞌanta tinꞌennta ko ncheꞌenta xranchi ni chúxinꞌa ndo Dio. Kain nchakon te̱to̱kuꞌunta Espíritue ndo Dio. Jaꞌanta ncheꞌenta xranchi ni tsikachrjenixinnta ó saꞌó. ");
INSERT INTO pps_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Ni tsikachrjenixinnta chinga juinchekao na̱ sen chronga chijnie ndo Dio. Ko naakóñaxón na̱ sen kuachronga ixi tsi̱i̱ ngisen xrochóndaꞌi ijie̱. Ko ó kui̱i̱ ndo meꞌe ko jaꞌanta juinchekjinta ndo ko tjumeꞌe naakóñaxón na̱ ndo. ");
INSERT INTO pps_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Jaꞌanta kuayeꞌenta ley kuetuanꞌan ndo Dio, ngeꞌe chronga ndo ángel, ko jaꞌanta kuitikaonꞌanta. ");
INSERT INTO pps_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Ko hora kuinꞌen na̱ ngeꞌe ndachro ndo Esteban, tsango koñao na̱, ncheketo neno na̱ ixi koñaoꞌe na̱ ndo. ");
INSERT INTO pps_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Ko ndo Esteban ícha jichónda ndo juachaxin Espíritue ndo Dio ko tsjeꞌe ndo ngajní ko bikon ndo juachaxien ndo Dio ko kaxon bikon ndo ndo Jesús siin ndo ndatsjonxin jian ti jii ndo Dio. ");
INSERT INTO pps_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Ko ndachro ndo Esteban: ―Bikon xitjeꞌe̱ ngajní ko ntiꞌa jii Chjenꞌen ndo Dio, xjan jongíꞌe xranchi chujni, ndatsjonxin jian ti jii ndo Dio. ");
INSERT INTO pps_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Ko jeꞌe na̱ bijeꞌe ndatsjon na̱ ko séen koyakuꞌe na̱ ndo, ");
INSERT INTO pps_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","ko sabikao na̱ ndo ngandeꞌe tjajna ko ixro kóñaxin na̱ ndo, ko ni tjangiꞌe ndo Esteban kuantsje na̱ ti jitsáa na̱ ko bakeꞌe na̱ tutée naa chajan ndatinꞌin Saulo ixi xrotsjeꞌe chán manta. ");
INSERT INTO pps_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Ko jeꞌe na̱ yaxin na̱ ixro ndo Esteban ko jeꞌe ndo tinóatée ndo ngajin Ncháina Jesús ko jaꞌin ndachro ndo: ―Ncháina Jesús tayeꞌénta aséenna. ");
INSERT INTO pps_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Ko bakeꞌexin ntatuchiꞌin ndo ko séen nichja ndo: ―Ncháina Jesús, jaꞌanta tjankataꞌinta ijie̱ ngajin ni stetóñana. Jaña ichro ndo ko ndakuenꞌen ndo. ");
INSERT INTO pps_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Ndo Saulo naxrajeꞌo xraxaon ndo xranchi ni kóña ndo Esteban. Ko nchakon meꞌe juangíxin na̱ tóña na̱ sen titikaon ndo Jesús tjajna Jerusalén ko kain sen titikaon ndo Cristo kuaxi chjekeꞌe sen sakjui sen nchijíi nunte Judea ko nunte Samaria. Ko jeꞌo sen apóstol tsikincheꞌe ndo Jesús kuituꞌe sen Jerusalén. ");
INSERT INTO pps_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Kaxin sen tsango titikaon ndo Dio juabaa sen ndo Esteban ko tsjangaxin sen ndo. ");
INSERT INTO pps_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","*Ko xi Saulo ningakonꞌen xa sen titikaon ndo Cristo. Ko kuaxi xa kuixinꞌin xa ngujngu ndoꞌa sen ko itsé xa sen xi ko sen nchri ko bingakjin xa sen ko xraxinꞌin xa sen ndoꞌachjiso. ");
INSERT INTO pps_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Ko sen sajuixin tjajna Jerusalén stetjako sen chijnie ndo Cristo nchijíi ti no kuintekji sen. ");
INSERT INTO pps_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Naa ndo ndatinꞌin Felipe sakjui ndo naa tjajna nunte Samaria ko kuaxi ndo chronga ndo chijnie ndo Cristo. ");
INSERT INTO pps_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Ko tsango tsjé na̱ xraꞌo ntiꞌa ko kuinꞌen na̱ ngeꞌe ndachro ndo Felipe ixi ó bikon na̱ ixra̱ ijié juako ndo. ");
INSERT INTO pps_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Ko itsjé ni chónda espíritue Xixronꞌanxrée koxruenꞌen na̱ ko espíritu meꞌe kuyako kuachrjexin jeꞌe chujni meꞌe. Kueya ni juaꞌi tingatjen kuaxi na̱ itji na̱ ko ni ntarengo chao itji na̱ kaxon. ");
INSERT INTO pps_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Ko kain ni tjajna ijié tsango juaxruxin bakeꞌe na̱. ");
INSERT INTO pps_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Tjajna meꞌe bakeꞌe naa xi ndatinꞌin Simón, xi meꞌe tuso xa ko bancheyeꞌe xa ni nunte Samaria ko jeꞌe xa ndachro xa tsango tetuanꞌan xa. ");
INSERT INTO pps_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Kain na̱ jian stetinꞌen na̱, xjanchínchín ko ni tachríi ko ndachro na̱: ―Xi jiꞌi tsango chónda xa juachaxien ndo Dio. ");
INSERT INTO pps_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Kain na̱ bakitikaon na̱ xa ixi ti ixra̱ ijié bancheꞌe xa meꞌe juincheyeꞌe xa na̱ itsjé nano. ");
INSERT INTO pps_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Ko nchakon kuitikaon na̱ chijni juako ndo Felipe kondee juachaxien ndo Dio ko ndo Jesucristo, tjumeꞌe ni xi ko ni nchri bikitée na̱. ");
INSERT INTO pps_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Ko kaxon xi Simón, kuitikaon xa ko bikitée xa ko juangíxin xa ruéꞌe xa ndo Felipe ko tsango kuitekaon xa ixi bikon xa ixra̱ ijié juako ndo Felipe. ");
INSERT INTO pps_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Tjumeꞌe sen apóstol, sen tsikituꞌe tjajna Jerusalén, kuinꞌen sen ixi itsjé ni nunte Samaria ó kuitikaon na̱ chijnie ndo Dio. Ko tjumeꞌe kuetuenꞌen sen ndo Pedro ko ndo Juan satsji sen ntiꞌa. ");
INSERT INTO pps_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Ko nchakon kuiji sen juancheꞌe sen ndo Dio ixi ni titikaon ndo Cristo ntiꞌa xrokuayéꞌe na̱ Espíritue ndo Dio ");
INSERT INTO pps_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","ixi xratayéꞌa na̱ Espíritue ndo. Jeꞌo tsikikitexin na̱ nombrée Ncháina Jesús. ");
INSERT INTO pps_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Tjumeꞌe ndo Pedro ko ndo Juan bakeꞌe itja sen ngataꞌa jaa na̱ ko kuayéꞌe na̱ Espíritue ndo Dio. ");
INSERT INTO pps_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Ko xi Simón bikon xa ixi sen apóstol bakeꞌe itja sen ngataꞌa jaa ni tsikitikaon ko kuayéꞌe na̱ Espíritue ndo Dio, ko tjumeꞌe xi Simón tjaun xa tsajon xa tomi ngajin sen apóstol ");
INSERT INTO pps_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","ko ndachro xa: ―Chjánanta juachaxin ixi kaxon janꞌan tsakée tjáana ngataꞌa jaa chujni ko tsayéꞌe na̱ Espíritue ndo Dio. ");
INSERT INTO pps_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Ko ndachro ndo Pedro: ―Jaꞌa ko tomia xroche ti xroꞌi tangaꞌi ixi xraxaoan tseꞌna juachaxien ndo Dio. ");
INSERT INTO pps_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Jaꞌa juaꞌi sincheꞌe ixra̱ jiꞌi ixi ndo Dio noꞌe ndo ixi jaꞌa tjúáꞌi asáan. ");
INSERT INTO pps_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Ko tintuꞌé ti ndakoꞌa ncheꞌe ko tinóatáa ngajin ndo Dio ixi sincheméꞌe ndo ijie̱ chonda. ");
INSERT INTO pps_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Ó bikona ixi tsango chjuyeꞌe asáan ko kueya ijie̱ chonda. ");
INSERT INTO pps_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Ko tjumeꞌe xi Simón juateꞌe xa ndachro xa: ―Tjancheꞌenta Ncháina Jesús ixi ti ndachronta tsoenꞌa jiꞌin ngajin janꞌan. ");
INSERT INTO pps_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Tjumeꞌe juexin chronga sen apóstol chijnie ndo Jesús, sakjui sen itsjé tjajna tikinixinꞌen nunte Samaria ko juinchekuenꞌen sen na̱ chijni tajon juachaxin tsechón aséen chujni. Ko tjumeꞌe ikjan sen tjajna Jerusalén. ");
INSERT INTO pps_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Tjumeꞌe naa ndo ángel neꞌe Ncháina Dio ndache ndo Felipe: ―Tingatjen satjia no níjin, ti jii chaꞌo xingajinxin chujni tjajna Jerusalén ti tjixin ni tjajna Gaza. Chaꞌo jiꞌi tatsinga no ntajie. ");
INSERT INTO pps_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Ko ndo Felipe bingatjen ndo ko sakjui ndo no chaꞌo meꞌe. Ntiꞌa kuetan ndo naa xi tjajna Etiopía. Jeꞌe xa naa xi eunuco ko xi meꞌe tjaꞌo xa tomie jan Candace, naa jan reina tetuenꞌen tjajna Etiopía. Jeꞌe xa tsikji xa tjajna Jerusalén, ntiꞌa kuajon xa juasaya ngajin ndo Dio. ");
INSERT INTO pps_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Tjumeꞌe jeꞌe xa kjanxin xa tjajna Jerusalén ko satsji xa tjajnée xa ko jeꞌe xa jiyá xa naa carreta meꞌe jinchekuanxin xa naa xroon tsikjin ndo profeta Isaías, ndo kuachronga chijnie ndo Dio ó saꞌó. ");
INSERT INTO pps_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Ko Espíritue ndo Dio kuetuenꞌen ndo Felipe: ―Itjia tonchjiñeꞌe tjenka carreta meꞌe. ");
INSERT INTO pps_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Ko konchjiñeꞌe ndo Felipe ti jii carreta, ko kuinꞌen ndo ixi xi meꞌe jinchekuanxin xa xroon tsikjin ndo Isaías. Ko juanchangiꞌe ndo xa: ―¿Á tienxian ngeꞌe rinchekuanxian? ");
INSERT INTO pps_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Tjumeꞌe juateꞌe xa ko ndachro xa: ―¿Xranchi tsianxin siá xroꞌan ngisen tingijnana tsianxin ngeꞌe jichro xroon jiꞌi? Ko juancheꞌe xa ndo Felipe tsajinꞌin ndo carreta tsakeꞌe ndo tjenka xa. ");
INSERT INTO pps_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Ko xroon chijnie ndo Dio jinchekuanxin xa, jaꞌin ndachro: Sabikao na̱ ndo xranchi naa kutuchjon tsóña na̱. Xranchi naa kutuchjon tenko ba nchakon kjinꞌen na̱ ba, jaña jeꞌe ndo kaxon xroꞌan ngeꞌe ndachro ndo ko xroꞌan ngeꞌe nichja ndo. ");
INSERT INTO pps_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Juanoa na̱ ndo ko juincheñeꞌa na̱ ndo ijie̱. Ko sen kuachrjenixin ndo, ¿ngisen tseki jiꞌi?, ixi jeꞌe ndo kuenꞌen ndo ngataꞌa nunte ntiꞌi. ");
INSERT INTO pps_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Tjumeꞌe xi eunuco juanchangiꞌe xa ndo Felipe ko ndachro xa: ―Ixudio ndachijiana ngisen konꞌen kain jiꞌin. ¿Á ndo tsikjin xroon jiꞌin o̱ á inaa ngisen? ");
INSERT INTO pps_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Tjumeꞌe ndo Felipe kuaxi ndo chronga ndo ti no jinchekuanxin xa ko juakoꞌe ndo xa chijnie ndo Jesús. ");
INSERT INTO pps_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Ko stetatsinga sen ti no jii inda, meꞌe ndachro xi eunuco: ―Ntiꞌi jii inda. ¿Á juaꞌi tsikitéexinna ntiꞌi? ");
INSERT INTO pps_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Ko ndachro ndo Felipe: ―Siá nduaxin titikáoan ngaya asáan, chao tsikitée. Ko jeꞌe xa juateꞌe xa: ―Titikaꞌon ixi ndo Jesucristo, Chjenꞌen ndo Dio. ");
INSERT INTO pps_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Ko kuetuanꞌan xi meꞌe tsíxin carreta ko kayui sen xingajin sen ti jii inda ko ndo Felipe bikitée ndo xa. ");
INSERT INTO pps_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Tjumeꞌe juexin kuachrjexin sen inda, Espíritue ndo Dio sabikao ndo Felipe íjngo. Ko xi bikitée, í bikonꞌa xa ndo Felipe. Ko tsango juaxruxin kua xa chaoé xa. ");
INSERT INTO pps_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Ko ndo Felipe konoxin ndo tjajna Azoto ko bakatsinga ndo ngujngu tjajna ko kuachronga ndo chijnie Ncháina Jesús, jaña juincheꞌe ndo ko kuiji ndo tjajna Cesarea. ");
INSERT INTO pps_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Xi Saulo tsango ningakonꞌen xa sen titikaon Ncháina Jesús ko tjaun xa naatsóñaxón xa sen. Méxin, sakjui xa bijée xa xitaana tetuanꞌan ");
INSERT INTO pps_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","ko juanchia xa naa xroon chónda juachaxin satsji xa niꞌngo tjajna Damasco tsjée xa sen titikaon chijnie ndo Jesús ixi tsikao xa sen nchri ko sen xi tjajna Jerusalén xroxraxinꞌin xa sen ndoꞌachjiso. ");
INSERT INTO pps_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Ko yaa xa chaꞌo ko ó xrokuiji xa tjajna Damasco, tuinxin kui̱i̱ naa xroꞌi kui̱xi̱n ngajní bingasáña ngandajin xa. ");
INSERT INTO pps_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Ko xi Saulo kuitsinga xa nunte, ko kuinꞌen xa nichja naa ngisen ko ndachro: ―Saulo, Saulo, ¿sonda ningakonna̱na ko tengiana? ");
INSERT INTO pps_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Ko tjumeꞌe xi Saulo juanchangi xa: ―¿Ngisen jaꞌanta? Ko tée sen nichja, ndachro: ―Janꞌan ndo Jesús, ndo tsango ningakonꞌén. ");
INSERT INTO pps_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Jeꞌe xa xranga xa ko xronka xa, ko jaꞌin ndachro xa: ―Jaꞌanta, ¿ngeꞌe tjaunnta sintaꞌa? Ko Ncháina Jesús ndachro ndo: ―Tingatjén, tixinꞌia tjajna Damasco, ko ntiꞌa tsetuanꞌan ngeꞌe sincheꞌe. ");
INSERT INTO pps_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Ko tjumeꞌe ni bijikao xi Saulo tsango xronka na̱ ixi kuinꞌen na̱ tée naa ngisen nichja ko xroꞌan ngisen bikon na̱. ");
INSERT INTO pps_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Ko bingatjen xi Saulo ko kuantjeꞌe ikon xa ko xroꞌan ngeꞌe bikon xa. Ko ni tikao xa ngatséꞌe na̱ xa ko sabikao na̱ xa tjajna Damasco. ");
INSERT INTO pps_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Ko ntiꞌa bakeꞌe xa níi nchakon, bikonꞌa xa ko juineꞌa xa ko xroꞌan ngeꞌe kuiꞌi xa. ");
INSERT INTO pps_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Ko tjajna Damasco bakeꞌe naa ndo titikaon Ncháina Jesús ndatinꞌin Ananías, ko juachaxin espíritue ndo Dio tsikikonxin ndo ndo Jesús jaꞌin kuituanꞌan ndo Jesús ngajin ndo: ―Ananías. Ko ndo Ananías juateꞌe ndo: ―Ntiꞌi ritjén, Nchána. ");
INSERT INTO pps_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Ko ndachro Ndo Jesús: ―Tingatjén satjia chaꞌo ndatinꞌin Nao. Ko tjée ndoꞌa naa ndo ndatinꞌin Judas ko ntiꞌa tsinchíia naa xi ndatinꞌin Saulo tsiki̱ꞌxi̱n tjajna Tarso ko jeꞌe xa jinichjaꞌna xa, ");
INSERT INTO pps_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","ixi jeꞌe xa bikon xa naa xi ndatinꞌin Ananías tixinꞌin xa nchia ko tsakeꞌe itja xa ngataꞌa jaa jeꞌe xi meꞌe ko chao tsikon xa íjngo. ");
INSERT INTO pps_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ko ndo Ananías juateꞌe ndo: ―Nchána, ó kui̱nꞌa̱n ngeꞌe ndachro kueya chujni, ixi xi meꞌe ndakoꞌa ncheꞌe xa ngajin sen titikaon ngajinnta, sen ste tjajna Jerusalén. ");
INSERT INTO pps_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Ko jai kui̱i̱ xa ntiꞌi ixi tsikayéꞌe xa juachaxien xitaana tetuanꞌan ixi tsikao xa kain sen titikaonnta. ");
INSERT INTO pps_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Ko Ncháina Jesús ndachro ndo: ―Itjia ixi janꞌan kuinchaꞌa xi meꞌe ixi tsjako xa chijnina. Sinchekuenꞌen xa ni ste jée tjajna ko xi rey ko kaxon ni israelita, ");
INSERT INTO pps_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","ko janꞌan tsjakoꞌa xa ixi tsango tangi tsonꞌen xa ixi tsitikaonna xa. ");
INSERT INTO pps_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Tjumeꞌe ndo Ananías sakjui ndo nchia ti jii xi Saulo ko bakeꞌe itja ndo ngataꞌa jaa xa ko ndachro ndo: ―Jaꞌa kichian Saulo, Ncháina Jesús, ndo bikuan ngatja chaꞌo, kuetuanna ndo juiꞌi ixi tsikuan íjngo ko tsayeꞌé Espíritue ndo. ");
INSERT INTO pps_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Ko tuinxin kuintjíxin ikon xi Saulo naa ngeꞌe xranchi kjoꞌe kuchee̱, ko chao bikon xa íjngo. Ko bingatjen xa ko bikitée xa. ");
INSERT INTO pps_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Ko tjumeꞌe juine xa ko chao konsoji xa íjngo. Ko kuituꞌe xa kaxin nchakon ngajin sen titikaon Ncháina Jesús tjajna Damasco. ");
INSERT INTO pps_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Ko tjumeꞌe juangíxin ndo Saulo juako ndo ngaxinꞌin niꞌngo Israel ixi ndo Jesús, Chjenꞌen ndo Dio. ");
INSERT INTO pps_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Kain ni jitinꞌen tsango xronka na̱ ko ndachro na̱: ―¿Á jeꞌa xi jiꞌi baruéꞌe ko bakoña kain ni titikaon ndo Jesús tjajna Jerusalén? ¿Á meꞌe kui̱ꞌxi̱n xa ntiꞌi ixi tsikao xa ni titikaon ndo Jesús ngajin xitaana tetuanꞌan? ");
INSERT INTO pps_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Ko ícha xrakonꞌa xa juako xa ixi nduaxin ndo Jesús ndo Cristo. Ko ni judío bakeꞌe tjajna Damasco juaꞌi nichjangíꞌe na̱ ndo. ");
INSERT INTO pps_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","*Ko ó kuatsinga itsjé nchakon ko ni judío stexraxaon na̱ xranchi naatsóñaxón na̱ xi Saulo. ");
INSERT INTO pps_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Ko ó konoꞌe ndo ti stexraxaon na̱. Ko tiie ko nchakon stechónꞌen na̱ ngandangi nduja tjajna ixi tjaun na̱ naatsóñaxón na̱ ndo. ");
INSERT INTO pps_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Ko naa tiie sen titikaon Ncháina Jesús bakeꞌe sen ndo Saulo ngaya naa ntaxra ijié ko tjumeꞌe juinchexingajin sen ntaxra jiá ndo tuenxin tjatuꞌo jii ngandajin nduja tjajna. Meꞌe chao sabinga ndo. ");
INSERT INTO pps_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Ko nchakon kuiji ndo Saulo tjajna Jerusalén tjaun ndo xrokui ndo ngajin sen titikaon Ncháina Jesús. Ko kain sen xronka sen ixi kuitikaonꞌa sen á nduaxin kaxon jeꞌe ndo ó titikaon ndo Ncháina Jesús. ");
INSERT INTO pps_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Ko tjumeꞌe ndo Bernabé sabikao ndo ndo Saulo ti ste sen apóstol ko chronga ndo ixi ndo Saulo tsikikon ndo Ncháina ngatja chaꞌo ko Ncháina tsinichjeꞌe ndo ndo. Ko tjajna Damasco juako ndo Saulo nombrée Ncháina Jesús ko xronkaꞌi ndo. ");
INSERT INTO pps_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Tjumeꞌe ndo Saulo kuituꞌe ndo tjajna Jerusalén ko chrikao ndo sen apóstol. Ko xrakonꞌa ndo tjako ndo chijnie Ncháina Jesús. ");
INSERT INTO pps_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Ko jeꞌe ndo tjaun ndo tsjao ndo ni judío nichja griego ko jeꞌe na̱ tjaun na̱ naatsóñaxón na̱ ndo. ");
INSERT INTO pps_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Tjumeꞌe sen titikaon ndo Cristo tsikinꞌen sen ngeꞌe xrokonꞌen ndo ko sabikao sen ndo tjajna Cesarea ko kuetuenꞌen sen ndo satsji ndo tjajna Tarso. ");
INSERT INTO pps_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Ko tjumeꞌe sen titikaon Ncháina nchijíi nunte Judea, nunte Galilea ko nunte Samaria juaxruxin bakeꞌe sen ko ícha kuitikaon sen ndo Jesús. Kuachónda sen juasaya ngajin Ncháina ko Espíritue ndo Dio bingijna sen ko ícha konkueya sen. ");
INSERT INTO pps_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Tjumeꞌe ndo Pedro kuitsjeꞌe ndo kain sen titikaon Ncháina Jesús. Kaxon sakjui ndo kuitsjeꞌe ndo sen titikaon Ncháina ste tjajna Lida. ");
INSERT INTO pps_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Ntiꞌa kuitja ndo naa xi ndatinꞌin Eneas. Ijní nano jitsingataꞌa xa kania ixi tsikenꞌen yui tutée xa. ");
INSERT INTO pps_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Ko ndachro ndo Pedro: ―Eneas, ndo Jesucristo sintaxruanꞌan ndo jai. Tingatjen tatsían kaniaꞌa. Ko tjumeꞌe xi Eneas tuinxin bingatjen xa. ");
INSERT INTO pps_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Ko kain ni jii tjajna Lida ko tjajna Sarón bikon na̱ ixi koxruenꞌen xa ko kaxon jeꞌe na̱ kuitikaon na̱ Ncháina Jesús. ");
INSERT INTO pps_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Ko nchakon meꞌe bakeꞌe naa nchri tjajna Jope titikaon nchra Ncháina ko ndatinꞌin nchra Tabita ko ngigua griego xrondachro Dorcas. Ko jeꞌe nchra jian juincheꞌe nchra ko bingijna nchra ni nóa. ");
INSERT INTO pps_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Tjumeꞌe naa nchakon tsango koniꞌe nchra ko ndakuenꞌen nchra. Ko juinéma sen cuerpoe nchra ko bakeꞌe sen nchra ti piso yuxin noi. ");
INSERT INTO pps_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","A̱ tjajna Jope jii tjajna tjenka tjajna Lida, ntiꞌa bakeꞌe ndo Pedro. Ko sen titikaon Ncháina noꞌe sen ixi ntiꞌa jii ndo. Ko tjumeꞌe xruanꞌan sen yuu sen xrondache sen ndo ixi tuinxin tsi̱i̱ ndo ko tsonchrjenꞌa ndo. ");
INSERT INTO pps_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Ko tjumeꞌe sabikao sen ndo Pedro. Ko kuiji sen ntiꞌa ko tuinxin bikao sen ndo ti jii cuerpoe nchri tsikenꞌen. Ntiꞌa ste kain nchri kaꞌan tsango tsjanga nchra ko juako nchra kain manta tsijaon nchri Dorcas nchakon xrabakechón nchra. ");
INSERT INTO pps_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Tjumeꞌe kuetuanꞌan ndo Pedro ixi kain na̱ tsachrje na̱ nduja. Ko bakeꞌexin ntatuchiꞌin ndo ko nichjeꞌe ndo ndo Dio. Ko jitsjeꞌe ndo nchri tsikenꞌen ko ndachro ndo: ―Tabita, tayá. Ko jeꞌe nchra kuantjeꞌe ikon nchra ko bikon nchra ndo Pedro ko bakeꞌe nchra nunte. ");
INSERT INTO pps_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Ko tjumeꞌe itsé ndo itja nchra ko juinchengatjen ndo nchra. Ko kuiyeꞌe ndo kain sen titikaon Ncháina ko kaxon kain nchri kaꞌan ixi tsikon sen ó tsixechón nchra. ");
INSERT INTO pps_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Tjumeꞌe kain ni jii tjajna Jope konoꞌe na̱ ngeꞌe juincheꞌe ndo Pedro ko itsjé na̱ kuitikaon na̱ Ncháina Jesús. ");
INSERT INTO pps_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Tjumeꞌe ndo Pedro kuituꞌe ndo itsjé nchakon tjajna meꞌe ko bakeꞌe ndo ndoꞌa ndo Simón, naa ndo kuanchexema tjueꞌé iko. ");
INSERT INTO pps_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Tjajna Cesarea bakeꞌe naa ndo ndatinꞌin Cornelio. Ndo meꞌe ndo capitán tetuenꞌen xi soldado kui̱xi̱n Italia. ");
INSERT INTO pps_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Tsango jian ndo ko kain sen ndoꞌa ndo xraxaon na̱ ndo Dio ko tajon ndo kueya tomi ixi tjaun ndo tsingijna ndo sen judío ko kain nchakon nichjeꞌe ndo ndo Dio. ");
INSERT INTO pps_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Tjumeꞌe naa nchakon hora nínxin ó kóndo tuinxin bikon ndo naa ndo ángel ncheꞌe ixra̱ ngajin ndo Dio, ndo meꞌe kuixinꞌin ndo ti jii ndo Cornelio ko ndachro ndo: ―Cornelio. ");
INSERT INTO pps_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Ko ndo Cornelio jitsjeꞌe ndo ndo ángel ko xronka ndo ko juanchangi ndo: ―¿Ngeꞌe tjaunnta? Ko ndachro ndo ángel: ―Ndo Dio bakeꞌe juaxruxin ixi ti nichjeꞌé ndo ko jian ncheꞌe tingijna ni nóa. ");
INSERT INTO pps_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Méxin, tetuenꞌén naa ngisen satsji tjajna Jope ixi tsikao na̱ ndo Simón kaxon ndatinꞌin Pedro. ");
INSERT INTO pps_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Ko ndo meꞌe jii ndo ndoꞌa naa xi kaxon ndatinꞌin xa Simón. Xi meꞌe kuanchexema tjueꞌé ko. Ndoꞌa xa jii tjenka ndachaon. ");
INSERT INTO pps_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Hora sakjui ndo ángel, ndo nichjeꞌe ndo Cornelio, jeꞌe ndo Cornelio kuiyeꞌe ndo yuu xi nchexra̱ ko kaxon naa xi soldado xraxaon xa ndo Dio ko jian tjento ndo xa. ");
INSERT INTO pps_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Bekiꞌe ndo xa kain ti bikon ndo ko tjumeꞌe kuetuenꞌen ndo xa satsji xa tjajna Jope. ");
INSERT INTO pps_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Ngusine nchakon íjngo steyá xa chaꞌo tjenka tjajna Jope, ko ndo Pedro kuajinꞌin ndo ngataꞌa nchia ixi ntiꞌa xronichjexin ndo ndo Dio. ");
INSERT INTO pps_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Ko tjumeꞌe tsango kuenꞌen ndo jinta ko tjaun ndo sine ndo. Nandá stenchekonchjian na̱ ngeꞌe sine ndo, tuinxin bikon ndo naa ngeꞌe. ");
INSERT INTO pps_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Bikon ndo ixi xitjeꞌe̱ ngajní ko ntiꞌa xingajinxin naa manta ijié. Jixriteꞌe kanoó ikon manta. ");
INSERT INTO pps_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Ko ngaxinꞌin manta jitjinga iko chónda noó tutée kao kunchee ko kain iko tjanga. ");
INSERT INTO pps_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Ko tjumeꞌe kuinꞌen ndo nichja naa ngisen ndachro: ―Pedro, taya, tonꞌiá iko meꞌe, ko inte ba. ");
INSERT INTO pps_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Ko ndo Pedro juateꞌe ndo: ―Nchána. Janꞌan naiꞌa ine ngeꞌe tjúáꞌi. ");
INSERT INTO pps_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Ko ndo ángel nichja íjngo ko ndachro ndo: ―Ti ó juinchetjúá ndo Dio, ndachroꞌa ixi tjúáꞌi. ");
INSERT INTO pps_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Níi konꞌen jaña ko tjumeꞌe tuinxin sakjui manta ngajní. ");
INSERT INTO pps_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Tjumeꞌe ndo Pedro xraxraxaon ndo ngeꞌe xrondachro ti bikon ndo, tuinxin xi xruanꞌan ndo Cornelio kuiji xa ngandangi nduja nchia meꞌe ko tsijanchangi xa ti no jii ndoꞌa ndo Simón. ");
INSERT INTO pps_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Tjumeꞌe séen juanchangi xa: ―¿Á ntiꞌi jii ndo Simón kaxon ndatinꞌin Pedro? ");
INSERT INTO pps_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Xra jixraxaon ndo Pedro ngeꞌe bikon ndo, ko Espíritue ndo Dio ndachro: ―Tsjeꞌé ó kui̱i̱ níi sen tjanchangi ixi jaꞌa. ");
INSERT INTO pps_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Taya, xingajian ko satikoꞌa xa ko taꞌia juachjaon, ixi janꞌan xruanꞌan sen ña̱ ngajian. ");
INSERT INTO pps_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Tjumeꞌe xingajin ndo Pedro ti ste xa ko ndachro ndo: ―Janꞌan Pedrona. ¿Ingeꞌe tjéexinntana? ");
INSERT INTO pps_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Ko juateꞌe xa: ―Kuetuanꞌan ndo capitán Cornelio juiꞌina ntiꞌi. Jeꞌe ndo naa ni tsango jian ko xraxaon ndo ndo Dio. Kain ni judío chóndeꞌe na̱ ndo juasaya ko tjueꞌe na̱ ndo. Naa ndo ángel tsixruaꞌan ndo Dio nichjeꞌe ndo ko chronga ndo ángel ixi xrojuiruaꞌananta ixi itsjinta ndoꞌa ndo ko tsinꞌen ndo ngeꞌe xrondachronta. ");
INSERT INTO pps_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Ko ndo Pedro ndachro ixi chao tsituꞌe xa ntiꞌa tiie meꞌe. Ko ndúyaxin sabikao xa ndo Pedro kaxon kaxin ni titikaon Ncháina ste tjajna Jope. ");
INSERT INTO pps_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Tjumeꞌe inaa nchakon kuiji sen tjajna Cesarea. Ntiꞌa jichónꞌen ndo Cornelio ko kaxon kain ni ndoꞌa ndo ko ni chúxin ndo tsikiyeꞌe ndo. ");
INSERT INTO pps_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Ko nchakon kuiji ndo Pedro ndoꞌa ndo Cornelio, tjumeꞌe ndo Cornelio kuachrjexin ndo nchia ko nichjeꞌe kichuu ndo. Ko bakeꞌexin ntatuchiꞌin ndo Cornelio ngajin ndo Pedro ixi tjaun ndo xrokuajon ndo juasaya ngajin ndo Pedro. ");
INSERT INTO pps_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Tjumeꞌe ndo Pedro juinchengatjen ndo ndo Cornelio ko ndachro ndo: ―Tingatjen. Takexinꞌa ntatuchiꞌian. Janꞌan naa chujni xranchi jaꞌa. ");
INSERT INTO pps_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Ko jitjao kichuu sen kuixinꞌin sen ndoꞌa ndo Cornelio ko bikon ndo Pedro ixi kueya na̱ ste na̱ ntiꞌa. ");
INSERT INTO pps_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Ko ndachro ndo Pedro: ―Jaꞌanta noꞌanta ixi janꞌanna xro judíona juaꞌi tsjentona chujni jeꞌa judío ko chondaꞌina juachaxin tsixinꞌinna ndoꞌa ni meꞌe. Ko jeꞌe ndo Dio juakoꞌna ndo ixi juaꞌi xrondachrja̱n tjúáꞌi ngixeꞌi chujni. ");
INSERT INTO pps_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Méxin, nchakon kuiyaꞌnanta, tuinxin juiꞌi. Tjaꞌon tsonóna sonda kuiyaꞌnantana. ");
INSERT INTO pps_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Tjumeꞌe juateꞌe ndo Cornelio ko ndachro ndo: ―Ó kuatsinga noó nchakon, xranchi hora i ntiꞌi ritjén nía rintakatseñaꞌo jinta ko rinichjaꞌa ndo Dio. Ko tuinxin bikon naa ngisen jiyá manta tjúá jitóngíxin. ");
INSERT INTO pps_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Ndachro sen meꞌe: “Cornelio, ó kuinꞌen ndo Dio ngeꞌe nichjeꞌé ndo ko ó noꞌe ndo ixi tsango tingijna ni nóa. ");
INSERT INTO pps_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Méxin, tetuenꞌén naa ngisen satsji tjajna Jope ixi tsikaꞌo sen ndo Simón kaxon ndatinꞌin Pedro. Jii ndo ndoꞌa naa xi kaxon ndatinꞌin xa Simón chjée xro̱a̱n tjueꞌé iko ko tjenka ndachaon jii ndoꞌa xa”, ichro ndo ángel meꞌe. ");
INSERT INTO pps_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Méxin, jaña tuinxin kuituanꞌan ngisen kuiyaꞌa. Jian juincheꞌe ixi juiꞌia nía. Ko jai ó noꞌe ndo Dio ixi kain janꞌanna tjaꞌonna tsinꞌanna ngeꞌe kuetuanꞌan Ncháina Dio xrochronga ngajinna. ");
INSERT INTO pps_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Tjumeꞌe ndachro ndo Pedro: ―Jai ó tianxin ixi ndo Dio xrajeꞌo tjueꞌe ndo Dio kain chujni, ");
INSERT INTO pps_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","ixi jeꞌe ndo tayéꞌe ndo kain sen ngixeꞌi tjajna titikaon ko tajon sen juasaya ngajin ndo. ");
INSERT INTO pps_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Ndo Dio nichjeꞌe ndo sen tjajna Israel ko kuinꞌen sen chijni tajon juaxruxin chronga Ncháina Jesucristo. Jeꞌe ndo Nchée kain chujni. ");
INSERT INTO pps_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Jaꞌanta ó noꞌanta jian kain ngeꞌe tsikonꞌen nchijíi ti ste ni judío xrangíxinxín nunte Galilea nchakon ndachro ndo Juan xrokonda tsikitée kain chujni. ");
INSERT INTO pps_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Jaꞌanta ó noꞌanta ixi ndo Dio kuajon ndo juachaxien Espíritue ndo kuayéꞌe ndo Jesús, ndo tsiki̱ꞌxi̱n tjajna Nazaret ko ó noꞌanta kaxon ixi ndo Jesús jian juincheꞌe ndo ko juinchexruenꞌen ndo kain ni tangi ste kondeexin Xixronꞌanxrée. Jaña jian juincheꞌe ndo Jesús ixi ndo Dio jii ngajin ndo. ");
INSERT INTO pps_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Tjumeꞌe janꞌanna nduaxin bikona kain ngeꞌe juincheꞌe ndo Jesús nunte Judea ko tjajna Jerusalén. Tjumeꞌe juankanito na̱ ndo nta̱cru ko naakóñaxón na̱ ndo. ");
INSERT INTO pps_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Tjumeꞌe ndo Dio juinchexechón ndo ndo Jesús nchakon nínxin ko kuajon ndo juachaxin bikona ndo íjngo. ");
INSERT INTO pps_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Jeꞌa kain chujni bikon na̱ ndo. Jeꞌo sen kuincheꞌe ndo Dio ixi tsikon sen nduaxin xechón ndo. Janꞌanna juinekianna ndo ko kuikiana ndo nchakon xechón ndo. ");
INSERT INTO pps_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Kuituanꞌan ndo ixi janꞌanna sintakuanꞌanna ko xrochraꞌngana ixi jeꞌe ndo sinchéña ndo ijie̱ ngajin kain chujni, ni stechón ko ni tsikenꞌen. ");
INSERT INTO pps_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Kain sen chronga chijnie ndo Dio chronga sen ixi ngujngu chujni titikaon ndo Jesús, sen meꞌe sincheméꞌe ndo jíee sen. ");
INSERT INTO pps_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Xrajinichja ndo Pedro, tjumeꞌe kain ni jitinꞌen ngeꞌe juako ndo kuayéꞌe na̱ Espíritue ndo Dio. ");
INSERT INTO pps_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Tjumeꞌe sen judío tsikikaꞌo ndo Pedro xronka sen ixi ndo Dio kuajon Espíritue ndo, kuayéꞌe sen jeꞌa judío. ");
INSERT INTO pps_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Méxin, kuinꞌen sen judío jinichja ndo Cornelio ko sen jikao ndo jée ngigua ko stetajon sen juasaya ngajin ndo Dio. ");
INSERT INTO pps_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Tjumeꞌe ndachro ndo Pedro: ―Sen jiꞌi ó kuayéꞌe sen Espíritue ndo Dio xranchi kuayéꞌe jai̱na. Jai ó chao tsikitée sen. ");
INSERT INTO pps_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Tjumeꞌe kuetuanꞌan ndo Pedro tsikitée kain sen ixi juachaxien ndo Jesucristo. Ko sen bikitée juanchia sen tsituꞌe ndo Pedro ntiꞌa kaxin nchakon. ");
INSERT INTO pps_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Tjumeꞌe sen kuincheꞌe Ncháina Jesús ko kain sen titikaon Ncháina ste nunte Judea, sen meꞌe kuinꞌen sen ixi ni jeꞌa judío ó titikaon na̱ chijnie ndo Dio. ");
INSERT INTO pps_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Ko nchakon ikjan ndo Pedro tjajna Jerusalén kaxin sen ste ntiꞌa tjaun sen ixi kain sen xrochónda sen chjiꞌe ni judío, ko tjakaxin sen ndo Pedro. ");
INSERT INTO pps_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Juanchangiꞌe sen ndo ko ndachro sen: ―¿Sonda ikjuinta kuitsjeꞌenta ni jeꞌa judío, ko juinekuunta na̱? ");
INSERT INTO pps_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Ko ndo Pedro kuaxi chronga ndo kain ngeꞌe tsikonꞌen ko ndachro ndo: ");
INSERT INTO pps_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","―Janꞌan bakeꞌe tjajna Jope rinichjaꞌa ndo Dio ko tuinxin bikon naa manta ijié xingajinxin ngajní. Jixriteꞌe kanoó ikon manta ko kui̱i̱ manta ti ritjén janꞌan. ");
INSERT INTO pps_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Tjumeꞌe tsja̱ꞌa̱ jian ko bikon ngaya manta jitjinga iko chónda noó tutée, ko jieꞌe, kao kunchee ko kain ko tjanga. ");
INSERT INTO pps_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Kaxon kui̱nꞌa̱n tée naa ngisen ndachijina: “Pedro, taya tonꞌiá iko meꞌe ko inte.” ");
INSERT INTO pps_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Ko juataꞌa: “Naꞌi, Nchána. Naiꞌa ine janꞌan ninaa ngeꞌe tjúáꞌi.” ");
INSERT INTO pps_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","’Ko íjngo nichja tée kui̱xi̱n ngajní ko ndachro: “Ti ngeꞌe juinchetjúá ndo Dio ndachroꞌa jaꞌa ixi tjúáꞌi.” ");
INSERT INTO pps_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Jaña konꞌen nínxin. Ko tjumeꞌe kain jiꞌin ikjan ngajní. ");
INSERT INTO pps_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Ko tuinxin níi xi kuiji nchia ritjén. Tsiki̱ꞌxi̱n xa tjajna Cesarea ko tjéena xa. ");
INSERT INTO pps_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Ko Espíritue ndo Dio kuetuanna chao tsikiꞌan xa ko kaxon bikiꞌan ikjaon sen kichuuna. Kainna kuixiꞌinna ndoꞌa naa ndo ndatinꞌin Cornelio. ");
INSERT INTO pps_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Tjumeꞌe ndo Cornelio chronga ndo ixi bikon ndo naa ndo ángel siin, jaꞌin nichja: “Tetuenꞌén ngisen satsji tjajna Jope tsikaꞌo sen naa ndo ndatinꞌin Simón ko kaxon ndatinꞌin Pedro. ");
INSERT INTO pps_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Jeꞌe ndo xrochronga ndo xranchi jaꞌanta ko kain sen ndointa xrochondanta juachaxin tsarichonnta kain nchakon.” ");
INSERT INTO pps_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Tjumeꞌe janꞌan kuaxi nichjaꞌa sen ko tuinxin kuayéꞌe sen Espíritue ndo Dio xranchi kuayéꞌe jai̱na seno. ");
INSERT INTO pps_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","*Tjumeꞌe xraxaꞌon ti kuanichja Ncháina Jesús, ti kuandachro ndo: “Nduaxin ndo Juan jeꞌo inda bikitéexin ndo chujni, ko jai jaꞌanta tsayeꞌenta Espíritue ndo Dio.” ");
INSERT INTO pps_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Xranchi janꞌanna nchakon kuaxi kuitikaonna Ncháina Jesucristo, tjumeꞌe kuajon ndo Dio Espíritue ndo kuayeꞌena, jaña jai kuajon ndo Dio Espíritue ndo kuayéꞌe sen jiꞌin. ¿Ngisen janꞌan ixi xrokuitikaonꞌa ngeꞌe juincheꞌe ndo Dio? ");
INSERT INTO pps_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Tjumeꞌe sen kichuuna, sen ste tjajna Jerusalén, kuinꞌen sen ngeꞌe tsikonꞌen ko tenko sen ko kuajon sen juasaya ngajin ndo Dio ko ndachro sen: ―Kuajon ndo Dio juachaxin kaxon ngajin ni jeꞌa judío ixi tsayéꞌe na̱ juachaxin tsitikaon na̱ ndo Dio ko xrochónda na̱ juachaxin tsechón na̱ kain nchakon. ");
INSERT INTO pps_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","*Nchakon naakóñaxón na̱ ndo Esteban, kuaxi na̱ ruéꞌe na̱ ko ningakonꞌen na̱ sen titikaon Ncháina Jesucristo. Xrokonda sakjui sen nunte Fenicia ko Chipre, ko tjajna Antioquía. Ntiꞌa juinchekuenꞌen sen jeꞌo ni judío chijni jian. ");
INSERT INTO pps_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Tjumeꞌe ikaxin sen titikaon Ncháina tsiki̱ꞌxi̱n sen tjajna Chipre ko kaxin sen tjajna Cirene sakjui sen tjajna Antioquía ko nchakon kuiji sen ntiꞌa juinchekuenꞌen sen ni jeꞌa judío chijni jian neꞌe Ncháina Jesucristo. ");
INSERT INTO pps_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Juachaxien Ncháina Jesús chonda sen; méxin, kueya ni ntiꞌa kuayéꞌe na̱ chijni jian ko kuitikaon na̱ Ncháina Jesucristo. ");
INSERT INTO pps_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Ko tjumeꞌe sen titikaon Ncháina Jesús tjajna Jerusalén kuinꞌen sen ngeꞌe tsikonꞌen tjajna Antioquía ko xruanꞌan sen ndo Bernabé ntiꞌa. ");
INSERT INTO pps_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Ko nchakon kuiji ndo Bernabé bikon ndo xranchi ndo Dio tsango bingijna ndo ni ntiꞌa kaxon. Ko tsango bakeꞌe juaxruxin aséen ndo. Tjumeꞌe nichjeꞌe ndo na̱ ixi nchijíi aséen na̱ tsitikaon na̱ Ncháina ko soji tsakeꞌe na̱. ");
INSERT INTO pps_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Ixi ndo Bernabé meꞌe naa ngisen tsango jian aséen ko chónda ndo juachaxien Espíritue ndo Dio ko jian chuntia ndo ndo Jesús; méxin, kueya na̱ kuitikaon na̱ Ncháina Jesús. ");
INSERT INTO pps_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Tjumeꞌe ndo Bernabé sakjui ndo tjajna Tarso bijée ndo ndo Saulo. ");
INSERT INTO pps_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Nchakon kuitja ndo ndo Saulo, sakjui sen tjajna Antioquía. Ko bakeꞌe sen ngajin sen titikaon Ncháina nchijíi naa nano ko juinchekuenꞌen sen itsjé chujni. Méxin ntiꞌa xrangíxixín kuiyeꞌe na̱ sen titikaon ndo Cristo: “sen Cristiano.” ");
INSERT INTO pps_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Tjumeꞌe kaxin sen chronga sen chijnie ndo Dio sajuixin sen tjajna Jerusalén ko kuiji sen tjajna Antioquía. ");
INSERT INTO pps_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","*Naa ndo ndatinꞌin Agabo kuíxin ndo ti tsixraꞌo sen titikaon ndo Jesús ko ixi juachaxien Espíritue ndo Dio chronga ndo ixi tsi̱i̱ jinta nchijíi nunte ntiꞌa. Ko ti chronga ndo nduaxin konꞌen nchakon baketuanꞌan naa xi ndatinꞌin Claudio. ");
INSERT INTO pps_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Ko tjumeꞌe sen titikaon Ncháina tjajna Antioquía xraxaon sen ixi jeꞌe sen tsingijna sen sen titikaon ndo Cristo jii nunte Judea. Ko ngujngu sen kuajon sen ngeꞌe kuachónda sen. ");
INSERT INTO pps_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Jaña xraxaon sen ko kuajon sen tomi sabikao ndo Bernabé ko ndo Saulo xrokuayéꞌe sen tituanꞌan niꞌngo nunte Judea. ");
INSERT INTO pps_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Nchakon meꞌe xi rey Herodes kuaxi xa bengi xa sen titikaon ndo Jesús ixi tjaun xa xrotsé xa sen. ");
INSERT INTO pps_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Ko kuetuanꞌan xa tsenxin ndo Jacobo ixi chika espada, ndo Jacobo meꞌe ndo kichuu ndo Juan. ");
INSERT INTO pps_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Ko bikon xi Herodes ixi juincheꞌe ni judío juaxruxin ixi kuenꞌen ndo Jacobo, meꞌe itsé xa ndo Pedro. Jiꞌi konꞌen nchakon kia Pascua ti ine na̱ nutja chóndaꞌi ngeꞌe nchetjaꞌin nio. ");
INSERT INTO pps_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Itsé xi Herodes ndo Pedro ko xraxinꞌin xa ndo ndoꞌachjiso. Ko ntiꞌa jii noó grupo xi soldado ko jii noó xi soldado ngujngu grupo. Jixraxaon xi Herodes ixi tsatsingaja kia pascua, tsantsje xa ndo Pedro ixi tsikon nchijíi tjajna israelita xranchi tsenꞌen ndo. ");
INSERT INTO pps_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Xrajíi ndo Pedro ngaxinꞌin ndoꞌachjiso ko jindaa xi soldado ndo, ko kain sen titikaon Ncháina jinichjeꞌe sen ndo Dio ixi tsingijna ndo ndo Pedro. ");
INSERT INTO pps_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Tiie meꞌe xraxaon xi Herodes ixi ndúyaxin tsantsje xa ndo Pedro tsjako xa ndo ngajin ni tjajna. Ko ndo Pedro jijua ndo ngusine yuu xi soldado ko jichroaxin ndo yuu chika cadena. Ko ikaxin xa jindaa xa nta̱chja ndoꞌachjiso. ");
INSERT INTO pps_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Ko tuinxin konoxin naa ndo ángel neꞌe Ncháina, ko ngaxinꞌin ndoꞌachjiso tsango kongíxin ko bakeꞌe ndo ángel itja ndo chjiyée ndo Pedro meꞌe xingameꞌe ndo. Ko ndachro ndo ángel: ―Taka xingamaꞌa. Ko tjumeꞌe chika cadena jitséxin itja ndo Pedro kueꞌe chika nunte. ");
INSERT INTO pps_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Ko kuetuanꞌan ndo ángel: ―Taritsía ko takée kateá. Ko kuitikaon ndo Pedro meꞌe ndachro ndo ángel íjngo: ―Taritsía noxráa ko ruanaꞌna sachjina. ");
INSERT INTO pps_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Ko tjumeꞌe ndo Pedro ruéꞌe ndo ndo ángel ko noeꞌa ndo á nduaxin jaña jitonꞌen o̱ jeꞌo naa ngeꞌe jitikon ndo. ");
INSERT INTO pps_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Ko juexin kuatsinga sen ti ste xi saꞌó stendáa ko kuatsinga sen ti ste xi yuxin stendáa. Tjumeꞌe kuiji sen ti jii nta̱chja chika ijié tjenka chaꞌo. Ko nta̱chja chika jeꞌo nta̱chja xitjeꞌe̱ nta̱chja ko kuachrje sen ko kuatsinga sen naa chaꞌo ko tuinxin ndo Pedro í bikonꞌa ndo ndo ángel jeꞌo ndo kuituꞌe ndo. ");
INSERT INTO pps_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Ko tjumeꞌe ndo Pedro konoꞌe ndo ixi nduaxin konꞌen jiꞌi ko ndachro ndo: ―Ó nóna jai ixi nduaxin Ncháina tsixruaꞌan naa ndo ángel ixi tsingijnana ndo ixi tsóñaꞌina xi Herodes ko xruanꞌan ngeꞌe tsónna xranchi tjaun ni judío. ");
INSERT INTO pps_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Ko jixraxaon ndo ngeꞌe konꞌen ndo, meꞌe sakjui ndo ndoꞌa jan María, janée ndo Juan, kaxon nchekinꞌin sen Marcos. Ntiꞌa tsixraꞌo itsjé sen titikaon ndo Jesús ko stenichjeꞌe sen ndo Dio. ");
INSERT INTO pps_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Ko binga ndo nta̱chja chaꞌo ko nichja ndo. Ko naa nchrichajan ndatinꞌin Rode kuachrje nchrichan kuitsjeꞌe nchrichan ngisen kui̱i̱. ");
INSERT INTO pps_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Ko hora juatsuan nchrichan nichja ndo Pedro, tjumeꞌe takaꞌi kuantjeꞌe nchrichan nta̱chja ixi tsango chéꞌe nchrichan. Ko binga nchrichan sakjuichronga nchrichan ixi ngandangi nduja nchia jii ndo Pedro. ");
INSERT INTO pps_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Ko ndachro sen: ―Tsijinchetjáña jáa. Ko jeꞌe nchrichan ndachro: ―Nduaxin jeꞌe ndo Pedro ―ichro nchrichan. Ko jeꞌe sen ndachro sen: ―Jeꞌa jeꞌe ndo. Jeꞌo espíritue ndo. ");
INSERT INTO pps_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Ko ndo Pedro ícha jitinga ndo nta̱chja ko hora kuantjeꞌe sen nta̱chja bikon sen ndo ko xronka sen. ");
INSERT INTO pps_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Ko tjumeꞌe juakoxin ndo Pedro itja ndo ixi xrotenko sen ixi chronga ndo xranchi Ncháina kuantsjexin ndo ndo ndoꞌachjiso. Ko ndachro ndo: ―Tekiꞌénta ndo Jacobo ko kain sen kichuuna ngeꞌe kónna ―ichro ndo ko tjumeꞌe sakjui ndo jée tjajna. ");
INSERT INTO pps_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Ko ndúyaxin tsango xrakon xi soldado ixi noeꞌa xa ti no satsikji ndo Pedro. ");
INSERT INTO pps_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Ko xi Herodes kuetuenꞌen xa xi soldado satsijée xa ndo Pedro, ko kuitjaꞌi xa ndo, ko xi Herodes juankataꞌa xa xi soldado ijie̱ ko kuetuanꞌan xa ixi tsenꞌen xi soldado. Ko tjumeꞌe xi Herodes kuachrjexin xa nunte Judea ko sakjui xa tjajna Cesarea ko ntiꞌa bakeꞌe xa. ");
INSERT INTO pps_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Xi Herodes ningakonꞌen xa ni tjajna Tiro ko tjajna Sidón. Ko jeꞌe na̱ juao kichuu na̱ ixi satsjitsjeꞌe na̱ xa. Ntiꞌa jii naa xi ndatinꞌin Blasto ko kuayakonꞌen xa ndoꞌa xi Herodes, ko tjumeꞌe juancheꞌe na̱ xa xronichjaxin xa na̱ ngajin xi tetuanꞌan. Ko juanchia na̱ ixi tse̱to̱kauꞌa xi Herodes jeꞌe na̱ ixi tjajnée xa ti̱ꞌxi̱n ngeꞌe ine na̱. ");
INSERT INTO pps_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Tjumeꞌe xi Herodes ndache xa na̱ ixi xroxraꞌo na̱ naa nchakon. Ko jeꞌe xa kuéyá xa manta chaxro tsjeꞌe ko tjintee ko kuetaꞌa xa ntaxitaon neꞌe chujni tetuanꞌan. Ko tjumeꞌe kuaxi xa nichjeꞌe xa kain ni tsixraꞌo ntiꞌa. ");
INSERT INTO pps_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Ko tjumeꞌe kuaxi na̱ kuyako na̱, ko ndachro na̱: ―¡Jeꞌa chujni jinichja! Naa dio jinichja. ");
INSERT INTO pps_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Tjumeꞌe tuinxin naa ndo ángel neꞌe ndo Dio juincheniꞌe xi Herodes ixi kuajonꞌa xa juasaya ngajin ndo Dio. Ko kutsindo juine ngaya tse̱ꞌe̱ xa ko ndakuenꞌen xa. ");
INSERT INTO pps_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Ko itsjé na̱ kuinꞌen na̱ chijnie ndo Dio nguixin ntiꞌa ko konkueya ni kuitikaon Ncháina Jesús. ");
INSERT INTO pps_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Ko ndo Bernabé ko ndo Saulo ó juinchejexin ixra̱ kuachónda sen tjajna Jerusalén, tjumeꞌe ikjan sen tjajna Antioquía ko sabikao sen ndo Juan, ndo kaxon nchekinꞌin sen Marcos. ");
INSERT INTO pps_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Niꞌngo Antioquía ste sen nichja chijnie ndo Dio. Sen meꞌe ndo Bernabé ko ndo Simón, kaxon nchekinꞌin na̱ ndo Negro, ndo Lucio, ndo tjajna Cirene, ndo Manaén, naa ndo tsikajikao xi Herodes, xi tetuanꞌan nunte Galilea, ko ndo Saulo. ");
INSERT INTO pps_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Naa nchakon tsixraꞌo sen tsajon sen juasaya ngajin ndo Dio, nchakon meꞌe tsijinchekatse ñao sen jinta. Tjumeꞌe Espíritue ndo Dio ndache ndo sen: ―Tantsjendáanantana ndo Bernabé ko ndo Saulo ixi janꞌan ó kuinchaꞌa sen xrotjáꞌa sen naa ixra̱ sincheꞌe sen. ");
INSERT INTO pps_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Ko juexin nichjeꞌe sen ndo Dio ko juinchekatse ñao sen jinta, bakeꞌe itja sen ngataꞌa jaa sen meꞌe ko ndachro sen ixi chao satsji sen. ");
INSERT INTO pps_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Ko tjumeꞌe Espíritue ndo Dio xruanꞌan ndo Bernabé ko ndo Saulo sakjui sen tjajna Seleucia. Ko ntiꞌa kuajinꞌin sen naa nta̱barco ko sakjui sen nunte Chipre. ");
INSERT INTO pps_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Ko kuiji sen naa tjajna ndatinꞌin Salamina ngandeꞌe nda, ntiꞌa xingajinxin sen nta̱barco ko ntiꞌa juangíxin sen juako sen chijnie ndo Dio ningue ni judío. Kaxon bikao sen ndo Juan ixi tsingijna ndo sen. ");
INSERT INTO pps_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Ko tjumeꞌe sakjui sen nchijíi nunte Chipre kuijija sen tjajna Pafos. Ntiꞌa kuetan sen naa xi tuso, xi meꞌe naa xi judío ndatinꞌin Barjesús. Jeꞌe xa ncheya xa ixi ndachro xa kaxon nichja xa chijnie ndo Dio. ");
INSERT INTO pps_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Ko xi meꞌe bakekao xa xi tetuanꞌan ndatinꞌin Sergio Paulo. Ko jeꞌe xi tetuanꞌan tsango jian xraxaon xa, meꞌe kuiyeꞌe xa ndo Bernabé ko ndo Saulo ixi jeꞌe xa tjaun xa tsinꞌen xa chijnie ndo Dio. ");
INSERT INTO pps_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Tjumeꞌe xi tuso, kaxon ndatinꞌin xa Elimas, ningakonꞌen xa sen tjako chijnie ndo Dio ixi tjaunꞌa xa ixi xi tetuanꞌan xrochuntia xa ndo Dio. ");
INSERT INTO pps_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Tjumeꞌe ndo Saulo, kaxon nchekinꞌin na̱ Pablo, tsango chónda ndo Espíritue ndo Dio. Ko jian tsjeꞌe ndo xi tuso ");
INSERT INTO pps_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","ko ndachro ndo: ―Jaꞌa naa chujni ncheya, chjenꞌen Xixronꞌanxrée jaꞌa, ningakonꞌen kain ngeꞌe jian. ¿Sonda nchetjáñajian chujni ixi tjaunꞌa tsitikaon na̱ Nchána̱na Jesús? ");
INSERT INTO pps_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Jai tangi tsonꞌan. Tsontakutsian ko kaxin nchakon tsikonꞌa chjiixrué nchakon. Ko tuinxin xi Elimas í bikonꞌa xa ko juée xa naa ngisen tsingatseꞌe xa ko satsikao na̱ xa ixi ítikonꞌa xa. ");
INSERT INTO pps_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Tjumeꞌe jaña bikon xi tetuanꞌan ngeꞌe konꞌen ko kuaxi kuitikaon xa Ncháina ixi bakeꞌe xa juaxruxin ti juako sen ngajin xa. ");
INSERT INTO pps_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Tjumeꞌe ndo Pablo ko sen chrikao ndo sajuixin sen tjajna Pafos. Kuixinꞌin sen naa nta̱barco sakjui sen ko kuiji sen tjajna Perge nunte Panfilia. Ko ndo Juan Marcos kuintuꞌe ndo sen ko ikjan ndo tjajna Jerusalén. ");
INSERT INTO pps_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Tjumeꞌe sajuixin ndo Pablo ko ndo Bernabé tjajna Perge ko kuiji sen tjajna Antioquía tjenka tjajna Pisidia. Ko nchakon tjokéꞌe sen kuixinꞌin sen ningue ni judío ko ntiꞌa bakeꞌe sen. ");
INSERT INTO pps_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Ko juexin juinchekuanxin sen xroon jitaxin ley ko ngeꞌe tsikjin sen kuachronga chijnie ndo Dio ó saꞌó, tjumeꞌe ni tetuanꞌan niꞌngo kuiyeꞌe na̱ sen tjako ko ndachro na̱: ―Kichianna siá chondanta ngeꞌe xrochronganta ixi ícha tsakeꞌena juaxruxin, ndachronta, jai tsinꞌanna. ");
INSERT INTO pps_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Ko tjumeꞌe ndo Pablo bingatjen ndo ko itja ndo juanchiaxin ixi xrotenko sen. Ko ndachro ndo: ―Tinꞌennta jaꞌanta sen israelita ko kaxon tinꞌennta jaꞌanta ti tsikixinnta jée tjajna ko jaꞌanta sen titikaonnta ndo Dio. ");
INSERT INTO pps_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Ndo Dio titikaon sen tjajna Israel kuincheꞌe ndo sen tachríꞌina. Ko tjumeꞌe ndo Dio kuajon ndo juachaxin ixi konkueya sen ti xrabakeꞌe sen tjajna Egipto. Xranchi ngisen tsiki̱ꞌxi̱n inaa tjajna jaña bakeꞌe sen ntiꞌa ko juachaxien ndo Dio bingijna sen kuachrjexin sen nunte Egipto. ");
INSERT INTO pps_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Ndo Dio bingijna ndo sen yuu kán nano bakeꞌe sen ntajie nchese. ");
INSERT INTO pps_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Ko tjumeꞌe juinchetjáña ndo ya̱a̱to̱ tjajna ti bakeꞌe nunte Canaán, ixi sen tsikachrjenixinna xrokuayéꞌe sen nunte meꞌe. ");
INSERT INTO pps_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Ko kain nano bakeꞌe sen ntiꞌa xranchi cuatrociento cincuenta nano. Ko tjumeꞌe ndo Dio baketuenꞌen ndo sen ixi kaxin xi bancheña ijie̱ ti kuijija ndo Samuel, naa ndo kuachronga chijnie ndo Dio. ");
INSERT INTO pps_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Tjumeꞌe juanchia sen israelita naa ndo rey tsetuenꞌen sen. Ko ndo Dio kuincheꞌe ndo ndo Saúl, kuetuanꞌan ndo yuu kán nano. Ko ndotée ndo Saúl, ndo Cis, ko kuachrjenixin ndo ndo Benjamín. ");
INSERT INTO pps_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Tjumeꞌe ndo Dio kuantsjeꞌe ndo ndo Saúl ti ixra̱ rey kuachónda ndo ko ndo David kuayéꞌe ti xra̱ rey meꞌe. Ko ndachro ndo Dio: “Ó kuitja ndo David, chjenꞌen ndo Isaí. Jeꞌe ndo naa ngisen chjána jié juaxruxin ko titikaon ndo kain ngeꞌe tjaꞌon.” ");
INSERT INTO pps_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Ndo Jesús meꞌe naa chujni kuachrjenixin ndo David ko ndo Dio xruanꞌan ndo ixi jeꞌe ndo sincheméꞌe ndo jíee sen israelita xranchi tsindachro ndo. ");
INSERT INTO pps_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","*Xratiꞌa ndo Jesús, ndo Juan bajako ndo chijni jian ngajin ni israelita ko ndachro ndo ixi xrokjan na̱ tsitikaon na̱ ndo Dio, tjumeꞌe tsikitée na̱. ");
INSERT INTO pps_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","*Ko ó xrokuiji nchakon xrokuenꞌen ndo Juan, meꞌe ndachro ndo: “Janꞌan jeꞌa ngisen xraxaon jaꞌanta ixi tjumeꞌe tsi̱i̱ inaa ngisen ko janꞌan chondaꞌi juachaxin tsoxindanga tjuée katée ndo ixi jeꞌe ndo ícha tetuanꞌan ndo ixi najanꞌan.” ");
INSERT INTO pps_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","’Jaꞌanta kichianna tsikachrjenixinnta ndo Abraham tinꞌennta, ko kainnta ni tsiki̱ꞌxi̱n ikjín titikaonnta ndo Dio, tinꞌennta chijnie ndo ixi sincheméꞌe ndo ti ndakoꞌa juincheꞌenta. ");
INSERT INTO pps_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Méxin, ni ste tjajna Jerusalén ko ni tetuanꞌan ntiꞌa konoeꞌa na̱ ngisen ndo Jesús ko kuienxinꞌa na̱ ngeꞌe tsikjin sen kuachronga chijnie ndo Dio ó saꞌó ti juinchekuanxin na̱ xroon ngaxinꞌin niꞌngo ngujngu nchakon tjokéꞌe na̱. Jaña jeꞌe na̱, nchakon tangi juinchekao na̱ ndo Jesús, tsijincheꞌe na̱ xranchi nichja xroon. ");
INSERT INTO pps_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","*Ko maski kuitjaꞌi na̱ xrojan ngeꞌe ndakoꞌa juincheꞌe ndo Jesús juancheꞌe na̱ xi Pilato ixi tsetuanꞌan xa tsenꞌen ndo. ");
INSERT INTO pps_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","*Ko nchakon juexin konꞌen kain jiꞌi, tjumeꞌe sen kuitikaon ndo Jesús juinchenganjinxin sen cuerpoe ndo nta̱cru ko juabaa sen ndo. ");
INSERT INTO pps_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Ko ndo Dio juinchexechón ndo ndo Jesús íjngo. ");
INSERT INTO pps_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","*Ko itsjé nchakon bikon sen ndo Jesús, sen chrikao ndo nchakon kui̱xi̱n sen nunte Galilea sakjui sen tjajna Jerusalén. Ko jai sen meꞌe nichja sen xranchi juako ndo Jesús ko nchekuenꞌen sen itsjé chujni. ");
INSERT INTO pps_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","’Jai janꞌanna tjakona chijni jian, ngeꞌe tsikajon ndo Dio kuayéꞌe sen tsikachrjenixinna ó saꞌó. ");
INSERT INTO pps_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Jaña konꞌen, janꞌanna kuayáꞌana xranchi tsindachro ndo Dio tsayéꞌe sen tsachrjenixin sen bakeꞌe saꞌó. Tjumeꞌe ndo Dio juinchexechón ndo ndo Jesús xranchi nichja xroon Salmo yuxin ko ndachro: “Jaꞌanta chjanꞌna, janꞌan tjáꞌanta juachaxin tsaricho̱nnta.” ");
INSERT INTO pps_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Ko tsindachro ndo Dio ixi sinchexechón ndo ndo Jesús ixi cuerpoe ndo xrorengaꞌi. Jaña chronga xroon chijnie ndo Dio, ndachro: “Janꞌan tsajon ngeꞌe jian ngajin ndo David.” ");
INSERT INTO pps_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Ko inaa Salmo ndachro jaꞌin: “Jaꞌanta tsintueꞌanta xrorenga cuerpoe ndo tsango tjúá.” ");
INSERT INTO pps_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Ko ndo David kuitikaon ndo xranchi tsiketuanꞌan ndo Dio nchakon bakeꞌe ndo ko tjumeꞌe kuenꞌen ndo ko tsixrabaa ndo, jaña kuaxrabaa ni tsikachrjenixinna ko renga cuerpoe ndo. ");
INSERT INTO pps_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Ko cuerpoe ndo juinchexechón ndo Dio rengaꞌi. ");
INSERT INTO pps_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Méxin, kichianna, xrokonda tsonoꞌanta xranchi tsoméꞌe jíanta ixi ndo Jesús meꞌe kuenxin ndo ixi jaꞌanta. ");
INSERT INTO pps_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Tjumeꞌe kain sen titikaon ndo Jesús ó juinchetjúá ndo aséen sen ixi ley kuetuanꞌan ndo Moisés chóndaꞌi juachaxin tsantsjen jíee sen. ");
INSERT INTO pps_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Tsjeꞌenta jian ixi tsuanꞌinta xranchi tsikjin sen kuachronga chijnie ndo Dio ó saꞌó: ");
INSERT INTO pps_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","Tsjeꞌe jaꞌanta ti tjanonta ko titikaonꞌanta. Jai xronkanta ko satinganta ixi ngeꞌe tsonꞌen ixi janꞌan ndo Dio tsjáko naa ixra̱ ijié jai ko jaꞌanta tsitikaonꞌanta maski inaa ngisen xrontatjunta. ");
INSERT INTO pps_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Tjumeꞌe ndo Pablo ko sen chrikao ndo kuachrjexin sen niꞌngo, ko ni jeꞌa judío juancheꞌe na̱ ndo ixi xrokjan sen nchakon íjngo tjokéꞌe na̱ ixi ícha xrojuinchekuenꞌen ndo na̱. ");
INSERT INTO pps_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Nchakon juexin sajuixin sen niꞌngo, tjumeꞌe kueya ni judío ko ni jeꞌa judío, ni bakitikaon xranchi ni judío ko baxraxaon na̱ ndo Dio, tsango bakeꞌe na̱ juaxruxin ixi ngeꞌe juako ndo Pablo ko ndo Bernabé ko ruéꞌe na̱ sen. Ko jeꞌe sen kuetuanꞌan sen ixi ícha jian tsitikaon na̱ ndo Dio ixi jeꞌe ndo tsango tjueꞌe ndo na̱. ");
INSERT INTO pps_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Tjumeꞌe inaa semana nchakon tjokéꞌe na̱, xraꞌo kain ni jii tjajna ntiꞌa ixi tjaun na̱ tsinꞌen na̱ chijnie ndo Dio. ");
INSERT INTO pps_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Ko bikon ni judío ixi kueya na̱ tsixraꞌo na̱, ko tsango kochjio na̱, tjumeꞌe kaxin na̱ nichjangíꞌe na̱ ndo Pablo. ");
INSERT INTO pps_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Tjumeꞌe ndo Pablo ko ndo Bernabé soji nichja sen ko ndachro sen: ―Xrokonda saꞌó jaꞌanta ni judíonta xrokuinꞌennta chijnie ndo Dio. Ko jaꞌanta tjaunꞌanta tsinꞌennta ngeꞌe jian tsajon juachaxin tsechón chujni kain nchakon. Ko jai tsintuꞌananta jaꞌanta ni judíonta ko satsjina sintakuanꞌanna ni jeꞌa judío. ");
INSERT INTO pps_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Jaña tsiketuanꞌan Ncháina: Janꞌan bakéenta jaꞌanta xranchi xroꞌi tsingasáñaxin kain tjajna ixi tsikuꞌunta chijni tajon juachaxin tsechón chujni nguixin nunte. ");
INSERT INTO pps_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Tjumeꞌe kuinꞌen ni jeꞌa judío jiꞌin ko bakeꞌe na̱ juaxruxin ko ndachro na̱ ixi jian chijnie Ncháina Jesús. Tjumeꞌe kuaxi kuitikaon kain ni tikinixinꞌen xrochónda juachaxin tsechón kain nchakon. ");
INSERT INTO pps_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Ko jaña xrangíxin juinchekuenꞌen sen na̱ chijnie Ncháina nchijíi tjajna ntiꞌa. ");
INSERT INTO pps_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Ko tjumeꞌe ni judío nichjeꞌe na̱ kaxin nchri ncheꞌe jian ko ngajin xi tetuanꞌan tjajna ntiꞌa ixi ndachro na̱ ndakoꞌa ncheꞌe ndo Pablo ko Bernabé ixi tsango toñaoꞌe na̱ sen ko bengixin na̱ sen ntiꞌa. ");
INSERT INTO pps_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","*Ko jeꞌe sen kontsjenga sen katée sen, jaña juakoxin sen ixi jeꞌe na̱ ndakoꞌa xraxaon na̱ ixi jeꞌe sen. Tjumeꞌe sakjui sen tjajna Iconio. ");
INSERT INTO pps_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Ko sen titikaon Ncháina Jesús tsango bakeꞌe sen juaxruxin ko ícha chónda sen juachaxien Espíritue ndo Dio. ");
INSERT INTO pps_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Tjumeꞌe kuiji ndo Pablo ko ndo Bernabé tjajna Iconio ko kuixinꞌin sen ningue sen judío ko ntiꞌa juinchekuenꞌen sen chujni. Ko itsjé sen judío ko sen jeꞌa judío kuitikaon sen. ");
INSERT INTO pps_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Tjumeꞌe kaxin ni judío, ni kuitikaonꞌa, kuaxi na̱ kuajon na̱ chijni ngajin ikaxin ni jeꞌa judío ixi xronichjangíꞌe na̱ ndo Pablo ko ndo Bernabé. ");
INSERT INTO pps_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Ko jeꞌe sen itsjé nchakon kuituꞌe sen ntiꞌa ko ícha chuntia sen Ncháina Jesús ko xronkaꞌi sen nichja sen chijnie ndo. Ko juachaxien ndo Jesús ícha bakingijna sen ixi ngeꞌe kuanichja sen xranchi ndo Dio tjueꞌe ndo chujni, ko kuajon ndo juachaxin sinchexrjuenꞌen sen chujni ko tsjako sen ijié ixra̱. ");
INSERT INTO pps_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Ko chujni tjajna ntiꞌa jeꞌa xrajeꞌo xraxaon na̱. Kaxin na̱ kuitikaon na̱ ni judío ko ikaxin na̱ kuitikaon na̱ sen kuincheꞌe Ncháina Jesús. ");
INSERT INTO pps_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Ko tjumeꞌe ni judío ko ni jeꞌa judío xraxaon na̱ naakua naa ngeꞌe, kao xi tetuanꞌan, ixi tjaun na̱ sinchexronka na̱ sen kuincheꞌe ndo Jesús ko xrokuaxin na̱ sen ixro. ");
INSERT INTO pps_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Ko ndo Pablo ko ndo Bernabé konoꞌe sen ngeꞌe xraxaon na̱, meꞌe sakjui sen tjajna Listra ko tjajna Derbe nunte Licaonia ko nguixin no ntiꞌa ");
INSERT INTO pps_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","ko juako sen chijni jian neꞌe Ncháina Jesús. ");
INSERT INTO pps_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Ko tjajna Listra jii naa xi xratsijongíexión xa juaꞌi itji xa. ");
INSERT INTO pps_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Xi meꞌe jii xa nunte ko jitinꞌen xa ngeꞌe juako ndo Pablo. Tjumeꞌe ndo Pablo jian jitsjeꞌe ndo xa ko konoꞌe ndo ixi jeꞌe xa chuntia xa Ncháina ko chao xrokoxruenꞌen xa. ");
INSERT INTO pps_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Ko jeꞌe ndo Pablo séen ndache ndo xa: ―Tingatjen, ndako takeꞌé tutáa. Ko tuinxin bingatjen xa ko chrinka xa, bakeꞌexin xa tutée xa ko chao kuaxi kuaji xa. ");
INSERT INTO pps_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Tjumeꞌe kain ni tjajna ntiꞌa bikon na̱ ngeꞌe juincheꞌe ndo Pablo, ko kuaxi na̱ kuyako na̱ ixi ngigueꞌe ni Licaonia ko ndachro na̱: ―Ndo Dio tsikjan chujni tsiki̱ꞌxi̱n ngajní, stekuꞌuna ntiꞌi. ");
INSERT INTO pps_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Ko jeꞌe na̱ juinchekinꞌin na̱ ndo Bernabé dio Júpiter ko ndo Pablo dio Mercurio ixi ícha juako ndo chijni. ");
INSERT INTO pps_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Ko xitaana neꞌe dio Júpiter chónda niꞌngo ngandeꞌe tjajna ko bikaꞌo xa kuxinta ko itsjo, ko jeꞌe xa ko kain ni ruéꞌe xa tjaun na̱ xrokuajon na̱ juasaya ngajin ndo Pablo ko ndo Bernabé ko tjaun na̱ xrokóñeꞌe na̱ sen kuxinta. ");
INSERT INTO pps_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Ko ndo Pablo ko ndo Bernabé konoꞌe sen ngeꞌe tjaun na̱ sincheꞌe na̱, meꞌe kuinchje sen mantée sen ko juikeꞌe sen ngakjenꞌen chujni ste ntiꞌa ko kuyako sen ndachro sen: ");
INSERT INTO pps_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","―¿Sonda ncheꞌenta jiꞌi? Janꞌanna chujnina xranchi jaꞌanta. Janꞌanna juiꞌina ixi sintakuanꞌannta chijnie ndo Dio ko tintuꞌenta kain ngeꞌe xroꞌan tjintee ko ikjannta tsitikaonnta ndo Dio, ndo jichón. Jeꞌe ndo juinchéña ndo ngajní ko nunte xasintajni ko ndachaon ko kain ngeꞌe jii ngataon nche. ");
INSERT INTO pps_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Saꞌó ndo Dio kuintuꞌe ndo chujni ixi sincheꞌe na̱ xranchi tjaun na̱. ");
INSERT INTO pps_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Ko ndo Dio juako ndo ixi jeꞌe ndo tetuanꞌan ndo ixi juinchéña ndo kain ngeꞌe jii. Jeꞌe ndo tetuanꞌan ndo ixi tsi̱i̱ ichrin, meꞌe tenga na̱ ko jian toñeꞌe na̱, ko kain nchakon jeꞌe ndo tajon ndo ngeꞌe sine na̱, ko jeꞌe ndo tajon ndo juachaxin juaxruxin ste na̱. ");
INSERT INTO pps_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Maski jaña ichro ndo Pablo ko ndo Bernabé, jeꞌe na̱ titikaonꞌa na̱ ixi tjaun na̱ tsajon na̱ juasaya ngajin sen ko xrokóñeꞌe na̱ sen kuxinta. ");
INSERT INTO pps_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Tjumeꞌe kui̱i̱ kaxin ni judío kui̱xi̱n tjajna Antioquía ko tjajna Iconio. Nichjeꞌe na̱ ni ste ntiꞌa ixi tsintuꞌe na̱ ti ngeꞌe tjako ndo Pablo ko ndo Bernabé, méxin kuaxi na̱ ixro ndo Pablo. Ko xraxaon na̱ kuenꞌen ndo, meꞌe bingakjin na̱ ndo ngandeꞌe tjajna. ");
INSERT INTO pps_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Ko tjumeꞌe sen titikaon Ncháina Jesús xraꞌo sen ngandajin ndo Pablo ko jeꞌe ndo bingatjen ndo ko ikjan ndo tjajna ntiꞌa íjngo. Ko ndúyaxin sabikao ndo Pablo ndo Bernabé tjajna Derbe. ");
INSERT INTO pps_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Ko ó juexin chronga sen chijni jian ko juacha sen kueya na̱ kuitikaon na̱ Ncháina Jesús, tjumeꞌe ikjan sen tjajna Listra ko tjajna Iconio ko tjajna Antioquía. ");
INSERT INTO pps_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Kain tjajna kuatsinga sen nichjeꞌe sen sen kuitikaon Ndo Jesús ko kuetuanꞌan sen ixi soji xrochuntia sen Ncháina ko ndachro sen ixi siá tsixinꞌinni ti tetuanꞌan ndo Dio, xrokonda tangi tsonꞌenni. ");
INSERT INTO pps_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Ko ngujngu niꞌngo kuincheꞌe sen ngisen tsetuenꞌen sen ti sen titikaon ndo Jesús ko nichjeꞌe sen ndo Dio ko juinchekatse ñao sen jinta ko tjumeꞌe ndache sen Ncháina ixi tsayakonꞌen ndo sen kuitikaon jeꞌe ndo. ");
INSERT INTO pps_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Tjumeꞌe kuatsinga sen nunte Pisidia ko kuiji sen nunte Panfilia. ");
INSERT INTO pps_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Ko tjajna Perge juako sen chijnie Ncháina ko tjumeꞌe sakjui sen tjajna Atalia. ");
INSERT INTO pps_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Ntiꞌa kuixinꞌin sen nta̱barco ko sakjui sen tjajna Antioquía, tjajna meꞌe tsinichjeꞌe sen ndo Dio ko tsijanchia sen ixi ndo Dio xrobingijna ndo sen ti ixra̱ juincheꞌe sen. ");
INSERT INTO pps_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Ko nchakon kuiji sen tjajna Antioquía xraꞌo kain sen titikaon ndo Jesús ko kuaxi chronga ndo Pablo xranchi bingijna ndo Dio ngajin sen ko xranchi kuajon ndo Dio juachaxin sinchekuenꞌen sen ni jeꞌa judío ixi kaxon xrochuntia na̱ Ncháina Jesús. ");
INSERT INTO pps_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Ko ndo Pablo ko ndo Bernabé kuituꞌe sen ngajin sen titikaon Ncháina Jesús itsjé nchakon. ");
INSERT INTO pps_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Kaxin sen tsiki̱ꞌxi̱n nunte Judea kuiji sen tjajna Antioquía. Kuaxi sen juinchekuenꞌen sen sen kichuuna ntiꞌa ixi juaꞌi tsoméꞌe jíee sen siá chóndaꞌi sen chjiꞌe sen ti tsiketuanꞌan ndo Moisés. ");
INSERT INTO pps_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Tjumeꞌe ndo Pablo ko ndo Bernabé ko jeꞌe sen judío kuaxi juakaxin kichuu sen. Méxin, juao sen ixi ndo Pablo ko ndo Bernabé ko ikaxin sen xrokui̱i̱ sen tjajna Jerusalén. Ntiꞌa tsjao sen apóstol ko sen tetuanꞌan niꞌngo ixi á xrokonda xrochónda na̱ chjiꞌe ti tsiketuanꞌan ndo Moisés. ");
INSERT INTO pps_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Jaña sen titikaon Ncháina tjajna Antioquía xruanꞌan sen kichuu sen, ko tjumeꞌe kuatsinga sen nunte Fenicia ko nunte Samaria ko ntiꞌa chronga sen xranchi itsjé sen jeꞌa judío kuayéꞌe sen chijnie ndo Dio. Ko kain sen kichuuna kuinꞌen meꞌe, tsango juaxruxin bakeꞌe sen. ");
INSERT INTO pps_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Tjumeꞌe kuiji ndo Pablo ko ndo Bernabé tjajna Jerusalén ko sen titikaon Ncháina ko sen apóstol ko sen tetuanꞌan neꞌe niꞌngo kuajon sen juachaxin tsintee sen ntiꞌa. Ko chronga sen xranchi ndo Dio tsango bingijna ndo sen. ");
INSERT INTO pps_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Tjumeꞌe ikaxin ni fariseo tsikitikaon Ncháina Jesús bingatjen na̱ ko ndachro na̱: ―Ni jeꞌa judío titikaon na̱ Ncháina xrokonda tsaa na̱ chjiꞌe ni judío, ko xrokonda tsitikaon na̱ nchijíi ley tsiketuanꞌan ndo Moisés. ");
INSERT INTO pps_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Ko tjumeꞌe kain sen apóstol ko sen tetuanꞌan niꞌngo xraꞌo sen ko xraxaon sen xranchi tsonꞌen ixi jaña ichro ikaxin sen judío. ");
INSERT INTO pps_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","*Sée juakaxin kichuu sen ko tjumeꞌe bingatjen ndo Pedro ndachro ndo: ―Jaꞌanta kichuuna, ó noꞌanta ixi seno ndo Dio kuinchena ndo janꞌan ixi tsjako ngajin kain ni jeꞌa judío ixi tsinꞌen na̱ chijni jian neꞌe ndo Cristo ko kaxon jeꞌe na̱ tsitikaon na̱. ");
INSERT INTO pps_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","*Ndo Dio chúxin ndo aséen chujni, juako ndo ixi kuayéꞌe ndo ni jeꞌa judío, meꞌe kuajon ndo Espíritue ndo kuayéꞌe na̱ xranchi jai̱na. ");
INSERT INTO pps_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Ndo Dio tikon ndo kain chujni naxrajeꞌo xranchi jai̱na. Ko juinchetjúá ndo aséen sen ixi ó chuntia sen Ncháina Jesús. ");
INSERT INTO pps_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Méxin, ¿sonda titikaonꞌanta ngeꞌe juincheꞌe ndo Dio ko tetuenꞌennta na̱ tsitikaon na̱ kain ley tangi? Ko jai̱na ko sen tsikachrjenixinna juaꞌi kuitikaon sen kain jiꞌi. ");
INSERT INTO pps_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Ó noi̱na ixi juasie Ncháina Jesús koméexin jíei̱na ko kaxon jaña koméꞌe jíee sen jeꞌa judío, sen kuitikaon. ");
INSERT INTO pps_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Ko kain sen tsixraꞌo tenko sen ko tjumeꞌe kuinꞌen sen xranchi ndachro ndo Bernabé ko ndo Pablo ixi ndo Dio bingijna ndo sen juincheꞌe sen itsjé ixra̱ ijié, jaña bikon kaxon ni jeꞌa judío. ");
INSERT INTO pps_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Juexin nichja ndo Pablo ko ndo Bernabé, tjumeꞌe kuaxi nichja ndo Jacobo ko ndachro ndo: ―Kichuuna, jian tinꞌennta ngeꞌe xrondachrja̱n. ");
INSERT INTO pps_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Ndo Simón Pedro chronga ndo xranchi juako ndo Dio ixi tjueꞌe ndo ni jeꞌa judío ko xranchi kuincheꞌe ndo ikaxin na̱ ixi tsitikaon na̱ ndo. ");
INSERT INTO pps_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Jaña nduaxin chronga xroon tsikjin sen kuachronga chijnie ndo Dio ó saꞌó: ");
INSERT INTO pps_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","Janꞌan xrokjanna ixi sintakonchjian íjngo niꞌngo tsichjejin neꞌe ndo David ko janꞌan tsingijna ixi tsetuanꞌan naa sen ndoꞌa ndo David. ");
INSERT INTO pps_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Ixi kain na̱ tsjéena na̱ ko kaxon kain ni jée tjajna kuiyaꞌa na̱ ixi tsitikaon na̱ janꞌan. ");
INSERT INTO pps_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Janꞌan ndo Dio, ndo ndachro saꞌó tsonꞌen jiꞌi. ");
INSERT INTO pps_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","’Méxin, ndachrja̱n janꞌan ixi ni jeꞌa judío xrokondaꞌi tsitikaon na̱ nchijíi ley ixi jeꞌe na̱ ó kuintuꞌe na̱ ngeꞌe kuitikaon na̱ saꞌó. ");
INSERT INTO pps_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Méxin, xroxruenꞌenna na̱ naa xroon ixi sinchenoꞌena sineꞌa na̱ ntao ti tikinixinꞌen ídolo ko xrochóndaꞌi na̱ inaa nchri jeꞌa nchrinchriꞌe na̱ ko sineꞌa na̱ ntauꞌe iko tsikintjiꞌa jnié ko sineꞌa na̱ jnié ba. ");
INSERT INTO pps_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Méxin, ngujngu tjajna jii ngisen chronga ley tsiketuanꞌan ndo Moisés ngaxinꞌin niꞌngo ngujngu nchakon tjokéꞌe na̱. ");
INSERT INTO pps_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Tjumeꞌe kain sen kuincheꞌe Ncháina Jesús ko sen tetuanꞌan niꞌngo ko kaxin sen titikaon Ncháina juao sen ixi kaxin sen satsji sen tjajna Antioquía. Ko sen itsji meꞌe ndo Judas, ndo nchekinꞌin sen Barsabás, ko ndo Silas, kayui sen jian titikaon sen, satsikao sen ndo Pablo ko ndo Bernabé. ");
INSERT INTO pps_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Ko jaꞌin ndachro xroon tsikao sen: “Janꞌanna, ni kuincheꞌe Ncháina Jesús ko ni tetuanꞌan niꞌngo ntiꞌi nichjaꞌananta jaꞌanta kichuuna ni jeꞌa judío, ti stenta tjajna Antioquía ko nunte Siria ko nunte Cilicia, tayeꞌénta juajna. ");
INSERT INTO pps_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Ó nóna ixi ikaxin sen kichuuna tsiki̱ꞌxi̱n tjajnana̱na maski kuachóndaꞌi sen juachaxin, kuiji sen juintaxronkanta sen ixi xrokonda tsaanta chjiꞌe ni judío ti tsiketuanꞌan ndo Moisés. ");
INSERT INTO pps_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Tjumeꞌe juaona ixi kaxin sen ste ntiꞌi tsitsjaꞌanta sen, jeꞌe sen ko ndo Bernabé ko ndo Pablo, sen tsango tjuaꞌana. ");
INSERT INTO pps_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Jeꞌe sen tsango tangi juinchekaon na̱ sen ixi ti titikaon sen Ncháina Jesucristo. ");
INSERT INTO pps_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Méxin, xroxruanꞌannanta ndo Judas ko ndo Silas ixi kaxon xronichjaꞌanta sen ko xrochronga sen kain jiꞌi. ");
INSERT INTO pps_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Ixi Espíritue Dio jian bingijnana ko jaꞌin juaona ixi tsitikaonꞌanta ngeꞌe tsango tangi. Ko ntiꞌi jitaxin ngeꞌe xrokonda tsitikaonnta: ");
INSERT INTO pps_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Nteꞌanta iko tikinixinꞌen ngajin ídolo ko kaxon sinteꞌanta jnié ba ko nteꞌanta ntauꞌe iko tsikintjiꞌa jnié ko kaxon xrochondaꞌinta inaa nchri jeꞌa nchriꞌanta. Titikaonnta kain jiꞌin ko jaña chao tsintenta.” ");
INSERT INTO pps_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Ko tjumeꞌe jeꞌe sen sakjui sen tjajna Antioquía. Ko nchakon kuiji sen ntiꞌa xraꞌo sen titikaon ndo Jesús ko jeꞌe sen kuajon sen xroon meꞌe. ");
INSERT INTO pps_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Ko nchakon juinchekuanxin sen kichuuna xroon meꞌe, tsango juaxruxin bakeꞌe sen ixi ngeꞌe chronga xroon. ");
INSERT INTO pps_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Tjumeꞌe ndo Judas ko ndo Silas kaxon chronga sen chijnie ndo Dio, ko nichja sen jian ko juaxruxin bakeꞌe sen kichuuna. ");
INSERT INTO pps_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Ko ntiꞌa kuintee sen kaxin nchakon, ko nchakon ó satsji sen, kain sen titikaon Ncháina Jesús jian nichjeꞌe kichuu sen ko ikjan sen ti no tsiki̱ꞌxi̱n sen tjajna Jerusalén ti ste sen kichuu sen. ");
INSERT INTO pps_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Ko ndo Silas xraxaon ndo ixi ntiꞌao xrokuituꞌe ndo. ");
INSERT INTO pps_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Ko kaxon ndo Pablo ko ndo Bernabé kuituꞌe sen tjajna Antioquía. Jeꞌe sen ko ikaxin sen juako sen ko chronga sen chijnie Ncháina Jesús. ");
INSERT INTO pps_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Tjumeꞌe ndo Pablo nichjeꞌe ndo ndo Bernabé ko ndachro ndo: ―Ichjina titsjeꞌena sen kichuuna ti kain tjajna juakona chijnie ndo Dio ó saꞌó ixi tsonoi̱na xranchi ste sen ntiꞌa. ");
INSERT INTO pps_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Ko ndo Bernabé kaxon tjaun ndo xrobikao sen ndo Juan, ndo kaxon nchekinꞌin sen Marcos. ");
INSERT INTO pps_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","*Ko ndo Pablo juincheꞌa ndo juaxruxin ixi xrobikao sen ndo Juan Marcos ixi jeꞌe ndo juincheꞌa ndo ixra̱, ixra̱ juincheꞌe sen nunte Panfilia. ");
INSERT INTO pps_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Méxin, jeꞌa naxrajeꞌo xraxaon sen, méxin chjeya sen. Ndo Bernabé sabikao ndo ndo Juan Marcos ko kuixinꞌin sen inaa nta̱barco sakjui sen nunte Chipre. ");
INSERT INTO pps_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Ko ndo Pablo kuincheꞌe ndo ndo Silas satsikao ndo, ko sen kichuu sen ntiꞌa juancheꞌe sen ndo Dio ixi jian tsingijna ndo sen ko jaña sakjui sen. ");
INSERT INTO pps_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Tjumeꞌe kuatsinga sen nunte Siria ko nunte Cilicia ko jian nichjeꞌe sen sen titikaon Ncháina niꞌngo ntiꞌa. ");
INSERT INTO pps_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Tjumeꞌe kuiji ndo Pablo tjajna Derbe ko tjajna Listra. Ntiꞌa bakeꞌe inaa ndo titikaon ndo Jesús ndatinꞌin ndo Timoteo. Janée ndo naa nchri tjajna judío titikaon nchra Ncháina Jesús ko ndotée ndo naa xi tjajna griego. ");
INSERT INTO pps_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Sen kichuuna jii tjajna Listra ko tjajna Iconio nichja sen jian ixi ndo Timoteo. ");
INSERT INTO pps_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Méxin, ndo Pablo tjaun ndo xrobikao ndo ndo Timoteo. Saꞌó kuetuanꞌan ndo ixi ndo Timoteo xrokua ndo chjiꞌe ni tjajna judío ixi xroningakuenꞌa na̱ ndo kain ni judío ti tjajna xrokjui sen ixi noꞌe na̱ ndotée ndo Timoteo naa xi griego. ");
INSERT INTO pps_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Tjumeꞌe kuatsinga sen kain tjajna ko chronga sen ngeꞌe tsiketuanꞌan sen apóstol ko sen tetuanꞌan niꞌngo tjajna Jerusalén. ");
INSERT INTO pps_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Sen chuntia Ncháina ícha konsoji sen ko ngujngu nchakon ícha konkueya sen. ");
INSERT INTO pps_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Tjumeꞌe Espíritue ndo Dio kuajonꞌa juachaxin tsjako sen chijnie ndo Dio nunte Asia, meꞌe kuatsinga sen nunte Frigia ko nunte Galacia. ");
INSERT INTO pps_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Ko nchakon kuiji sen nunte Misia xraxaon sen xrokjui sen nunte Bitinia. Ko Espíritue ndo Jesús kuajonꞌa juachaxin satsji sen ntiꞌa. ");
INSERT INTO pps_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Méxin, xrakuatsingako sen nunte Misia ko kuiji sen tjajna Troas ngandeꞌe ndachaon. ");
INSERT INTO pps_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Ko naa tiie ixi juachaxien espíritue ndo Dio bikon ndo Pablo naa xi nunte Macedonia, siin xa jitinóatée xa ko ndachro xa: “Tatsinga nunte Macedonia ko tingijnana.” ");
INSERT INTO pps_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Jaña tsikikon ndo Pablo, méxin tuinxin konchjianna ixi satsjina nunte Macedonia ixi jian nónana ixi ndo Dio kuetuanꞌan ndo ntiꞌa tsjakona chijni jian xranchi tsoméꞌe jíee na̱. Janꞌan ndo Lucas ikjin xroon jiꞌi sabikiꞌan sen kaxon. ");
INSERT INTO pps_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Tjumeꞌe ntiꞌa tjajna Troas kuixiꞌinna inaa nta̱barco ko xrajuikona naa nunte nchíín ngataon inda ndatinꞌin Samotracia. Ko ndúyaxin juasona tjajna Neápolis. ");
INSERT INTO pps_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Ntiꞌa sajuixinna ko juasona tjajna Filipos. Tjajna meꞌe tetuanꞌan ni romano, ko tjajna meꞌe naa tjajna ícha tjintee ixi ikaxin tjajna nunte Macedonia. Ntiꞌa kuinteena kaxin nchakon. ");
INSERT INTO pps_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Ko nchakon tjokéꞌe ni israelita kuachrjexinna tjajna Filipos ko sakjuina ngandeꞌe ndarío ko ntiꞌa nanaunka xraꞌo na̱ nichjeꞌe na̱ ndo Dio. Meꞌe ntiꞌa kuinteena nunte ko kuaxina juintakuanꞌanna kaxin nchri ste ntiꞌa. ");
INSERT INTO pps_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Ko ntiꞌa jii naa nchri ndatinꞌin Lidia tsiki̱ꞌxi̱n tjajna Tiatira. Jeꞌe nchra nchekji nchra manta chaxro játse tiie. Ko jeꞌe nchra xraxaon nchra ndo Dio ko jitinꞌen nchra ngeꞌe tjako ndo Pablo ko Ncháina bingijna nchra ixi tsienxin nchra jian chijnie ndo Dio. ");
INSERT INTO pps_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Jeꞌe nchra ko kain ni ndoꞌa nchra bikitée na̱. Tjumeꞌe kuinóatée nchra ngajin ndo Pablo ko ndachro nchra: ―Siá titikaonnta ixi nduaxin titikaꞌonna Ncháina, tituanꞌanta nía ntiꞌi. Ko kuituna̱na ntiꞌa. ");
INSERT INTO pps_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Tjumeꞌe inaa nchakon sakjuina ti no nichjeꞌe sen ndo Dio ko kuetanna naa nchrichajan chónda nchrichan espíritue Xixronꞌanxrée tonuexin nchrichan kaxin ngeꞌe ko jii naa ngisen tetuenꞌen nchrichan ko kueya tomi tjacha ni meꞌe ixi ti chronga nchrichan. ");
INSERT INTO pps_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Ko nchrichajan meꞌe kuaxi nchrichan ruéꞌe nchrichan ndo Pablo ko janꞌanna ko tjumeꞌe séen nichja nchrichan: ―Sen jiꞌi ncheꞌe sen xrée ndo Dio jii ngajní ko tjako sen chaꞌo tsechónxin chujni. ");
INSERT INTO pps_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Jaña juincheꞌe nchrichan itsjé nchakon. Tjumeꞌe tsango koñao ndo Pablo ko ngatjia ndo nichjeꞌe ndo espíritue Xixronꞌanxrée chónda nchrichan, ko ndachro ndo: ―Juachaxien nombrée ndo Jesucristo tetuanꞌan ixi tsachrjexian nchrichan jiꞌi. Tjumeꞌe tuinxin kuachrjexin nchrichan espíritue Xixronꞌanxrée. ");
INSERT INTO pps_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Ko tjumeꞌe ni tetuanꞌan nchrichan bikon na̱ ngeꞌe konꞌen nchrichan ko konoꞌe na̱ ixi ítsjachaꞌi na̱ ícha tomi ixi ixra̱ kuancheꞌe nchrichan. Méxin koñao na̱ ko itsé na̱ ndo Pablo ko ndo Silas ko bingakjina sen ti ste ni tetuanꞌan ntaasien tjajna. ");
INSERT INTO pps_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Ko tjumeꞌe bikona na̱ ntiꞌa ti jii xi nchéña ijie̱ ko ndachro na̱: ―Ni jiꞌi ni judío tsango nchexronka na̱ ni tjajnai̱na ");
INSERT INTO pps_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","ko tjako na̱ ngeꞌe juaꞌi tsitikaonna ko juaꞌi sintuꞌuna ixi janꞌanna ni romanona. ");
INSERT INTO pps_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Ko kain ni ntiꞌa koñaoꞌe na̱ sen. Tjumeꞌe xi nchéña ijie̱ kuetuanꞌan xa tsantsjeꞌe na̱ sen manta steyá sen ko tsóña na̱ sen ixi ntasé. ");
INSERT INTO pps_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Ko tsango kóña na̱ sen, tjumeꞌe xraxinꞌin na̱ sen ndoꞌachjiso ko kuetuanꞌan na̱ ngajin xi jindaa ndoꞌachjiso ixi xrotsjeꞌe xa satsingaꞌi sen. ");
INSERT INTO pps_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Ko kuitekaon xa ko xraxinꞌin xa sen ti ícha yasoꞌe ndoꞌachjiso ixi tsachrjeꞌa sen. Ko kuintexin xa tutée sen ixi naa nta̱a̱ chónda tuye ixi satsjiꞌa sen. ");
INSERT INTO pps_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Tjumeꞌe ngusine tiie ndo Pablo ko ndo Silas nichjeꞌe sen ndo Dio ko itsje̱ sen ngajin ndo Dio. Ko ikaxin ni jii ndoꞌachjiso kuinꞌen na̱ ixi jaña jitsje̱ sen. ");
INSERT INTO pps_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Tuinxin kontengí nunte meꞌe kontsjenga nchijíi tjatuée ndoꞌachjiso ko kain nta̱chja xitjeꞌe̱ ko kuitsinga chika cadena ti stetséxin kain ni ste ntiꞌa. ");
INSERT INTO pps_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Tjumeꞌe xi jindaa ndoꞌachjiso kuaya xa ko bikon xa ixi tsixitjeꞌe nta̱chja, méxin kuantsje xa naa chika espada, ko xroxrantuꞌu xa chika meꞌe ntakuin xa ixi ndaxrokuenꞌen xa ixi xraxaon xa sabinga kain ni jii ngaxinꞌin ndoꞌachjiso. ");
INSERT INTO pps_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Ko ndo Pablo séen kuyako ndo ndachro ndo: ―Naꞌi, xruanꞌan ngeꞌe nchekua asáan ixi kainna stena ntiꞌi. ");
INSERT INTO pps_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Tjumeꞌe xi jindaa ndoꞌachjiso juanchia xa naa xroꞌi ko nteeto kuixinꞌin xa ko jixranga xa ixi xronka xa ko bakeꞌexin ntatuchiꞌin xa tutée ndo Pablo ko ndo Silas. ");
INSERT INTO pps_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Ko tuinxin kuantsjexin xa sen ntiꞌa ko juanchangiꞌe xa sen: ―¿Ngeꞌe sintaꞌa ixi tsechón aséenna kain nchakon? ");
INSERT INTO pps_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Ko jeꞌe sen ndachro sen: ―Titikáoan Nchána̱na Jesucristo ko jaña tsoméꞌe jiá ko jíee ni ndúya. ");
INSERT INTO pps_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Tjumeꞌe juinchekuenꞌen sen xa ko kao kain ni ste ndoꞌa xa chijnie Ncháina Jesucristo. ");
INSERT INTO pps_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Ko maski naxixeꞌe, hora meꞌe sabikao xa sen ko junéꞌma xa kain ti no juincheniꞌe na̱ sen. Ko tuinxin jeꞌe xa ko kain ni ste ndoꞌa xa bikitée na̱. ");
INSERT INTO pps_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Ko tjumeꞌe jeꞌe xa sabikao xa sen ndoꞌa xa íjngo; ntiꞌa kuajon xa ngeꞌe juine sen. Jeꞌe xa ko kain ni ndoꞌa xa bakeꞌe na̱ juaxruxin ixi kuitikaon na̱ ndo Dio. ");
INSERT INTO pps_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Tjumeꞌe ndúyaxin xi nchéña ijie̱ kuetuenꞌen xa xi policía tsitsjeꞌe xa xi jindaa ndoꞌachjiso ixi tsantsje xa ndo Pablo ko ndo Silas. ");
INSERT INTO pps_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Tjumeꞌe xi jindaa ndoꞌachjiso ndache xa ndo Pablo ngeꞌe ndachro xipolicía: ―Xi nchéña ijie̱ kuetuanꞌan xa ixi tsachrjenta. Juaxruxin satsjinta. ");
INSERT INTO pps_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Tjumeꞌe ndo Pablo ndache ndo xi policía: ―Janꞌanna ni romanona, juaya na̱ ngajinna ko bikon kueya chujni ko ndachroꞌa xa ngeꞌe ijie̱ juintaꞌana. Ko jaña xraxinꞌinna xa ndoꞌachjiso ko jai, ¿á imao tsajandana xa? Naꞌi. Tsi̱i̱ jeꞌe xa ko jeꞌe xa tsantsjena xa. ");
INSERT INTO pps_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Tjumeꞌe xipolicía sakjui xa ko ndache xa xi nchéña ijie̱ ngeꞌe ndachro sen ste ngaxinꞌin ndoꞌachjiso. Ko tsango xronka xi nchéña ijie̱ ixi kuinꞌen xa ixi jeꞌe sen romano sen. ");
INSERT INTO pps_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Tjumeꞌe ikjui xi nchéña ijie̱ ko kuinóatée xa ngajin ndo Pablo ko ndo Silas ixi tsoñaoꞌa sen ixi ngeꞌe konꞌen sen, ko tjumeꞌe kuachrjexin sen ntiꞌa ko juanchia xa ixi satsjixin sen tjajna ntiꞌa. ");
INSERT INTO pps_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Tjumeꞌe ndo Pablo ko ndo Silas, hora kuachrjexin sen ndoꞌachjiso, kuiji sen ndoꞌa jan Lidia. Ko ntiꞌa bikon sen sen kichuu sen ko juinchechaxin kichuu sen ko sajuixin sen ntiꞌa. ");
INSERT INTO pps_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Tjumeꞌe ndo Pablo ko ndo Silas kuatsinga sen tjajna Anfípolis ko tjajna Apolonia ko sakjui sen tjajna Tesalónica. Ntiꞌa jii naa niꞌngo judío. ");
INSERT INTO pps_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Ko tjumeꞌe ndo Pablo sakjui ndo niꞌngo ixi jaña xrakuenꞌen ndo ko níi semana ngujngu nchakon tjokéꞌe ni judío juako ndo xranchi ndachro xroon chijnie ndo Dio. ");
INSERT INTO pps_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Juako ndo ixi ndo Cristo xrokonda xrokuenꞌen ndo ko tjumeꞌe xroxechón ndo íjngo. Jaña ndachro ndo: ―Ndo Jesús, ndo ntatjunta, meꞌe ndo Cristo. ");
INSERT INTO pps_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Tjumeꞌe kaxin ni judío kuitikaon na̱ ko ruéꞌe na̱ ndo Pablo ko ndo Silas. Ko kaxon kuitikaon itsjé ni griego, ni ó chóxin ndo Dio, ko kaxon kaxin nchri ícha chúxin na̱ tjajna ntiꞌa, kuitikaon nchra. ");
INSERT INTO pps_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Ko ikaxin ni judío kuitikaonꞌa na̱ ngeꞌe nichja ndo Pablo ko tsango kochjio na̱ meꞌe juée na̱ kaxin xi ñaꞌi, xi naiꞌa ncheꞌe xra̱ ko juinchekateya na̱ ni tjajna. Tjumeꞌe kuixinꞌin na̱ ndoꞌa naa xi ndatinꞌin Jasón ixi chrjitjée na̱ ndo Pablo ko ndo Silas ko tjaun na̱ tsikaan na̱ sen ti jii ni tetuanꞌan. ");
INSERT INTO pps_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Ko kuitjaꞌi na̱ sen meꞌe itsé na̱ xi Jasón ko ikaxin sen titikaon Ncháina ko bingakjin na̱ sen sabikao na̱ sen ti jii xi tetuanꞌan tjajna ntiꞌa. Ko kuintee na̱ ko kuyako na̱ ko ndachro na̱: ―Ni jiꞌi juincheyeꞌe na̱ chujni nchijíi nunte ko jai ó kui̱i̱ na̱ tjajnai̱na ntiꞌi. ");
INSERT INTO pps_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Xi Jasón kuajon xa juachaxin ixi kuituꞌe na̱ ndoꞌa xa. Kain ni jiꞌin titikaonꞌa na̱ ley tetuanꞌan xi romano ko ndachro na̱ ixi jii inaa ngisen ícha tetuanꞌan ndatinꞌin Jesús. ");
INSERT INTO pps_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Hora kuinꞌen na̱ jiꞌin kain ni tsixraꞌo ko xi tetuanꞌan tsango koñao na̱. ");
INSERT INTO pps_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Ko xi Jasón ko sen titikaon Ncháina juenga sen ꞌna̱ méxin xi tetuanꞌan kuintuꞌe xa sakjui sen. ");
INSERT INTO pps_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Ko tuinxin tiie meꞌe sen kichuuna xruanꞌan sen ndo Pablo ko ndo Silas satsji sen tjajna Berea. Ko nchakon kuiji sen ntiꞌa kuixinꞌin sen ningue ni judío. ");
INSERT INTO pps_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Ko ni judío ntiꞌa ícha jian ncheꞌe na̱ ixi ni tjajna Tesalónica. Ko ícha juincheꞌe na̱ juaxruxin kuinꞌen na̱ chijnie ndo Dio ko ngujngu nchakon nchekuanxin na̱ xroon chijnie ndo Dio ixi tsonoꞌe na̱ á nduaxin ti juakoꞌe na̱ sen. ");
INSERT INTO pps_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Méxin, itsjé ni ntiꞌa kuitikaon na̱, ko ikaxin nchri griega ícha chúxin na̱ kuitikaon nchra ko kaxon ni xi. ");
INSERT INTO pps_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Ko ni judío tjajna Tesalónica konoꞌe na̱ ixi ndo Pablo juako ndo chijnie ndo Dio tjajna Berea ko sakjui na̱ ntiꞌa ko juinchekateya na̱ ni ntiꞌa. ");
INSERT INTO pps_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Méxin sen kichuuna titikaon Ncháina xruanꞌan sen ndo Pablo satsji ndo no ngandeꞌe ndachaon. Ko ndo Silas ko ndo Timoteo xrakuituꞌe sen tjajna Berea. ");
INSERT INTO pps_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Tjumeꞌe kaxin sen ntiꞌa sabikao sen ndo Pablo tjajna Atenas. Ko ikjan sen tjajnée sen ixi kuetuanꞌan ndo Pablo xrochronga sen ngajin ndo Silas ko ndo Timoteo ixi jaiko satsji sen ti jii ndo ixi ntiꞌa tsetan sen ndo Pablo. ");
INSERT INTO pps_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Xrajichonꞌen ndo Pablo ixi tsiji ndo Silas ko ndo Timoteo tjajna Atenas, tsango koniꞌe aséen ndo ixi bikon ndo ntiꞌa jii kueya ídolo ko chujni tajon juasaya ngajin ídolo meꞌe. ");
INSERT INTO pps_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Ko niꞌngo judío ntiꞌa juako ndo ngajin kaxin ni judío ko ikaxin na̱ chúxin na̱ ndo Dio, ko kain nchakon bakeꞌe ndo ti ntaasin, juakoꞌe ndo ni jii ntiꞌa. ");
INSERT INTO pps_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Ko kaxin chujni tikinixinꞌen chujni ndatinꞌin epicúreos ko ikaxin ni tikinixin chujni ndatinꞌin estoicos kuaxi na̱ juao na̱ ndo Pablo. Kaxin na̱ ndachro na̱: ―¿Ngeꞌe xrondachro ti nichja xi jiꞌi? Ko kaxin na̱ ndachro na̱: ―Jinichja xa ixi inaa dio. Jaña ichro na̱ ixi juako ndo Pablo chijni jian kondee ndo Jesús ko ndachro ndo ixi ndo Jesús maski kuenꞌen ndo, xechón ndo íjngo. ");
INSERT INTO pps_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Tjumeꞌe sabikao na̱ ndo Pablo naa ijna̱ ndatinꞌin Areópago. Ntiꞌa nichjeꞌe na̱ ndo ko ndachro na̱: ―Tjaꞌonna xrondachijiana ngeꞌe natjúá tjakoa jaꞌa. ");
INSERT INTO pps_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Itsjé ngeꞌe jée tjakoa, ko tjaꞌonna tsonónana ngeꞌe xrondachro meꞌe. ");
INSERT INTO pps_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Ko kain ni tjajna Atenas ko ni tsiki̱ꞌxi̱n jée tjajna ste ntiꞌa, jeꞌo bakiꞌen na̱ ko bakeki na̱ ngeꞌe natjúá kuinꞌen na̱. ");
INSERT INTO pps_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Tjumeꞌe ndo Pablo bakeꞌexin tutée ndo ti ste na̱ ntiꞌa ti Ijna̱ Areópago ko ndachro ndo: ―Jaꞌanta ni tjajna Atenas tinꞌennta. Janꞌan tiko̱n ixi jaꞌanta titikaonnta itsjé dio tsikoña tjatuꞌo. ");
INSERT INTO pps_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Ko hora kuatsinga ntiꞌa janꞌan bikon ti no tájonxinnta juasaya ngajin ídoloanta ko bikon naa altar jaꞌin tsikjinnta: “Ntiꞌi xraxaonxinna naa Dio chuxinꞌani.” Méxin, ti Dio xraxaonnta maski xrachuxinꞌanta, meꞌe ndo Dio tjako janꞌan. ");
INSERT INTO pps_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","*’Ndo Dio meꞌe juinchéña ndo nunte xasintajni ko kain ngeꞌe jii ngataꞌa nunte. Jeꞌe ndo meꞌe Nchée ngajní ko nunte ntiꞌi. Ndo Dio jiꞌa ndo ngaxinꞌin naa niꞌngo tsikonchjianxin itja chujni. ");
INSERT INTO pps_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Ko xrokondeꞌa ndo ixi xrojan chujni xrobingijna ndo ixi jeꞌe ndo tajon ndo juachaxin tsechón kain chujni ko tajon ndo chrinto ko kain ngeꞌe jii ngataꞌa nunte. ");
INSERT INTO pps_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","’Naakua ngisen kuantsjenixin ndo kain tjajna ixi tsakeꞌe na̱ nguixin ngataꞌa nunte. Ko kaxon ndachro ndo Dio tinó ko ngisa tsakeꞌe na̱. ");
INSERT INTO pps_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Jai̱na xrokonda tsjéena ndo Dio ixi indao tsienxinna xranchi tsitjana ndo. Ko nduaxin jeꞌe ndo kjínꞌa jii ndo. ");
INSERT INTO pps_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Ixi jeꞌe ndo stechónxinna ko tontengina ko tayakui̱na ndo. Ko tsindachro naa xi tjajnánta saꞌó: “Jai̱na kuachrjenixinna ndo Dio.” ");
INSERT INTO pps_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Nduaxin jai̱na kuachrjenixinna ndo Dio, méxin juaꞌi xroxraxaonna ixi ndo Dio, jeꞌe ndo naa chika oro o̱ naa chika plata o̱ naa ixro xranchi xraxaon ni nchéña ídolo. ");
INSERT INTO pps_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Saꞌó ndo Dio tjáñeꞌe ndo ti kuancheꞌe chujni ixi noꞌe ndo xrakuachuxinꞌa na̱ ndo. Ko jai tituanꞌan Dio ngajin kain chujni jii ngataꞌa nunte xrokonda tsitikaon na̱ ndo. ");
INSERT INTO pps_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Ndo Dio kuincheꞌe ndo naa nchakon sinchéña ndo ijie̱ ngajin chujni jii ngataꞌa nunte ko kuincheꞌe ndo naa ndo juakoxin kain juachaxin, ndo meꞌe maski kuenꞌen ndo, xechón ndo íjngo. ");
INSERT INTO pps_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Ko nchakon kuinꞌen na̱ ixi xroxechón chujni tsikenꞌen, kaxin na̱ juanoa na̱ ndo Pablo. Ko ikaxin na̱ ndachro na̱: ―Íjngo nchakon tsinꞌanna ngeꞌe ndachrua. ");
INSERT INTO pps_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Tjumeꞌe ndo Pablo sakjui ndo. ");
INSERT INTO pps_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Ko ikaxin na̱ ruéꞌe na̱ ndo ko kuitikaon na̱ Ncháina. Ko naa xi kuitikaon ndatinꞌin Dionisio, meꞌe naa xi kuanchéña ijie̱ ngajin chujni ngataꞌa ijna̱ Areópago, ko naa nchri kuitikaon nchra ndatinꞌin nchra Dámaris ko ikaxin na̱ kaxon kuaxi na̱ kuitikaon na̱ Ncháina. ");
INSERT INTO pps_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Tjumeꞌe ndo Pablo sajuixin ndo tjajna Atenas ko ikjui ndo tjajna Corinto. ");
INSERT INTO pps_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Ntiꞌa kuetan ndo naa xi judío ndatinꞌin Aquila. Jeꞌe xa xi tjajna nunte Ponto ko séꞌa nchakon jeꞌe xa ko janchriꞌe xa tsiki̱xi̱n sen tjajna Italia ixi xi tetuanꞌan ntiꞌa, xi Claudio, kuetuanꞌan xa ixi kain ni judío tsachrjexin na̱ tjajna Roma. Tjumeꞌe ndo Pablo ikjui ndo kuitsjeꞌe ndo sen meꞌe. ");
INSERT INTO pps_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Ko xrajeꞌo ixra̱ kuancheꞌe sen, ti kuanchéña sen nchia manta. Méxin, ntiꞌao kuituꞌe ndo Pablo ixi xrojuincheꞌe sen xra̱. ");
INSERT INTO pps_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Ko kain nchakon tjokéꞌe ni judío, ndo Pablo bakji ndo niꞌngo nichjeꞌe ndo ni judío ko ni jeꞌa judío ixi tjaun ndo kain na̱ tsitikaon na̱ Ncháina. ");
INSERT INTO pps_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Ko nchakon ndo Silas ko ndo Timoteo kui̱xi̱n sen nunte Macedonia, tjumeꞌe ndo Pablo í kuancheꞌa ndo xra̱, jeꞌo bajako ndo chijnie ndo Dio ixi tsonoꞌe ni judío ixi ndo Jesús meꞌe ndo Cristo. ");
INSERT INTO pps_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Ko jeꞌe ni judío kuaxi na̱ ningakonꞌen na̱ ndo Pablo ko tsango nichjangíꞌe na̱ ndo. Ko jeꞌe ndo kontsjenga ndo manta jitsáa ndo ixi jaña juakoxin ndo jeꞌa juaxruxin jii ndo. Ko ndachro ndo: ―Jaꞌonta tamanta ijie̱ tsitjáñaxinnta. Janꞌan íxroꞌan ijie̱ tama ixi ó juintanoꞌanta chijni jian, ko jaꞌanta kuitikaonꞌanta. Méxin, jai satsji sintakuanꞌan ni jeꞌa judío. ");
INSERT INTO pps_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Tjumeꞌe kuachrjexin ndo niꞌngo judío ko sakjui ndo ndoꞌa naa sen ndatinꞌin Justo, ndo meꞌe xraxaon ndo ndo Dio. Ko tjenka ndoꞌa ndo jii niꞌngo. ");
INSERT INTO pps_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Ko ndo Crispo, ndo tetuanꞌan niꞌngo judío, ko kain sen ndoꞌa ndo, kuitikaon sen Ncháina Jesús. Ko kaxon kueya ni tjajna Corinto kuinꞌen na̱ chijnie ndo Dio ko kuaxi na̱ kuitikaon na̱ Ncháina Jesús ko bikitée na̱. ");
INSERT INTO pps_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Tjumeꞌe naa tiie bikon ndo Pablo Ncháina Jesús ko jaꞌin ndachro ndo Jesús: ―Tjakua chijnina ko xronkaꞌia. Naiꞌa tintuꞌe nichja chijnina ");
INSERT INTO pps_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","ixi janꞌan tjenka ritjén ko xroꞌan ngisen ndakoꞌa sintaꞌa ixi janꞌan chonda itsjé sen titikaonna tjajna ntiꞌi. ");
INSERT INTO pps_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Méxin, ndo Pablo kuituꞌe ndo naa nano ko tuꞌo ntiꞌa tjajna Corinto, ko juinchekuenꞌen ndo na̱ chijnie ndo Dio. ");
INSERT INTO pps_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Nchakon baketuanꞌan xi Galión nunte Acaya, itsjé ni judío ningakonꞌen na̱ ndo Pablo ko bikao na̱ ndo ti ste xi tetuanꞌan. ");
INSERT INTO pps_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Ko ndache na̱ xi tetuanꞌan: ―Xi jiꞌi ichrji xa nchekateya xa chujni ixi tjaun xa jée xronichjexin na̱ ndo Dio, jeꞌa xranchi ndachro ley. ");
INSERT INTO pps_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Ko ndo Pablo ó tjaun ndo xronichja ndo, ko tuinxin xi Galión ndache xa ni judío: ―Siá nduaxin naa ijie̱ tsango ijié juincheꞌe xi jiꞌi, janꞌan xrokonda tsinꞌan ngeꞌe xrondachronta. ");
INSERT INTO pps_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Ko jiꞌi jeꞌo chijni ko nombre ko ley naꞌanta te̱to̱xinnta. Méxin, jaꞌonta nchekonchjiannta jiꞌi ixi janꞌan tjaunꞌa tsjitexin ngeꞌe te̱to̱xinnta. ");
INSERT INTO pps_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Tjumeꞌe kuetuanꞌan xa ixi satsjixin na̱ ntiꞌa. ");
INSERT INTO pps_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Ko ni griego koñao na̱ ko itsé na̱ xi Sóstenes, xi tetuanꞌan niꞌngo judío, ko ntiꞌa juaya na̱ ngajin xa ko stetsjeꞌe kain xi tetuanꞌan, ko xi Galión xroꞌan ngeꞌe ndachro xa. ");
INSERT INTO pps_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Ndo Pablo xrakuituꞌe ndo itsjé nchakon tjajna Corinto ko tjumeꞌe chjée ndo sen juajna sen kichuuna ko kuixinꞌin ndo naa nta̱barco ixi sakjui ndo nunte Siria ko kao jan Priscila ko ndo Aquila. Tjumeꞌe kuiji sen tjajna Cencrea ko ntiꞌa ikjín jaa ndo Pablo ixi juakoxin ndo juincheꞌe ndo ti ngeꞌe tsindachro ndo. ");
INSERT INTO pps_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Nchakon kuiji sen tjajna Éfeso kuintuꞌe ndo Pablo jan Priscila ko ndo Aquila ko sakjui ndo naa niꞌngo ko juao ndo ni judío tsixraꞌo ntiꞌa. ");
INSERT INTO pps_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Ko jeꞌe na̱ kuinóatée na̱ ixi xrokuituꞌe ndo ntiꞌa, ko jeꞌe ndo chroꞌa ndo. ");
INSERT INTO pps_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Méxin, nichjeꞌe ndo na̱ ko ndachro ndo: ―Xrokonda tsakeꞌé tjajna Jerusalén nchakon tsi̱i̱ kia. Ko xrokjanna íjngo xrotsjaꞌanta siá tsituexin ndo Dio. Tjumeꞌe kuintuꞌe ndo na̱ ko kuixinꞌin ndo nta̱barco sakui̱xi̱n ndo tjajna Éfeso. ");
INSERT INTO pps_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Nchakon kuiji ndo tjajna Cesarea sakjui ndo tjajna Jerusalén ko bikitsjeꞌe ndo sen titikaon Ncháina ntiꞌa. Ko tuinxin bingajin ndo tjajna Antioquía. ");
INSERT INTO pps_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Kuatsinga kaxin nchakon, kuachrjexin ndo ntiꞌa ko bakji ndo kaxin tjajna nunte Galacia ko Frigia ko nichjeꞌe ndo kain sen titikaon Ncháina Jesús ixi juaxruxin tsintee sen. ");
INSERT INTO pps_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Nchakon meꞌe naa ndo judío ndatinꞌin Apolos kuiji ndo tjajna Éfeso, ndo meꞌe tikinixin ndo tjajna Alejandría. Jeꞌe ndo jian tjako ndo ko jian chúxin ndo xroon chijnie ndo Dio. ");
INSERT INTO pps_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Jeꞌe ndo noꞌe ndo chaꞌo neꞌe Ncháina ko juaxruxin banichja ndo kondee ndo Jesús maski jeꞌo noꞌe ndo xranchi batikitée ndo Juan chujni. ");
INSERT INTO pps_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Ko ndo Apolos juako ndo ti niꞌngo ko xrakonꞌa ndo. Ko nchakon kuinꞌen jan Priscila ko ndo Aquila ti juako ndo, tjumeꞌe kuachrjendakaꞌo sen ndo ko juinchekuenꞌen sen ndo ti ngeꞌe xranoeꞌa ndo chaꞌo neꞌe ndo Dio. ");
INSERT INTO pps_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Tjumeꞌe nchakon tjaun ndo Apolos satsji ndo nunte Acaya, sen kichuuna bingijna sen ndo ko ikjin sen naa xroon ngajin sen titikaon Ncháina ste ntiꞌa ixi xrokuayéꞌe sen ndo jian. Ko nchakon kuiji ndo nunte Acaya bingijna ndo ngajin sen ixi juasie ndo Dio ó tsikitikaon sen. ");
INSERT INTO pps_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Ko stetinꞌen kain chujni, juakoxin ndo ixi ndakoꞌa titikaon ni judío ko juacha ndo juako ndo ixi xroon chijnie ndo Dio chronga ixi nduaxin ndo Jesús ndo Cristo. ");
INSERT INTO pps_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Xrabakeꞌe ndo Apolos tjajna Corinto, ndo Pablo bakaji ndo tjajna ste nganito jna̱ ko tjumeꞌe kuiji ndo tjajna Éfeso ko ntiꞌa kuetan ndo kueya ni titikaon chijnie ndo Dio. ");
INSERT INTO pps_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Ko tjumeꞌe juanchangiꞌe ndo sen meꞌe: ―¿Á kuayeꞌenta Espíritue ndo Dio nchakon kuitikaonnta Ncháina? Ko jeꞌe sen juateꞌe sen: ―Naꞌi, janꞌanna xratianꞌina á jii Espíritue ndo Dio. ");
INSERT INTO pps_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Tjumeꞌe juanchangi ndo Pablo: ―¿Ngisen juachaxien bikitéexinta? Ko jeꞌe sen juateꞌe sen: ―Xranchi kuachronga ndo Juan, jaña bikitéena. ");
INSERT INTO pps_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","*Ndachro ndo Pablo: ―Ndo Juan kuanchekitée ndo chujni ixi xrokjan na̱ xrokuitikaon na̱ ndo Dio ko juako ndo ixi xrokuitikaon na̱ ngisen tsi̱i̱ tuenxin ndo, ko ndo xrokui̱i̱ ndo meꞌe ndo Jesús, ndo Cristo. ");
INSERT INTO pps_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Kuinꞌen sen jiꞌi, meꞌe bikitée sen; ixi juachaxien Ncháina Jesús. ");
INSERT INTO pps_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Tjumeꞌe ndo Pablo ba̱ke̱ꞌe̱ itja ndo ngataꞌa jaa sen ko kui̱i̱ Espíritue ndo Dio ngajin sen ko kuaxi sen nichja sen jée ngigua ti chúxinꞌa sen ko nichja sen ngeꞌe kuajon ndo Dio. ");
INSERT INTO pps_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Ko sen xi meꞌe xranchi teyuu sen. ");
INSERT INTO pps_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Ko níi nchanitjao, ndo Pablo bakeꞌe ndo niꞌngo judío ntiꞌa ko bajako ndo ko baxronkaꞌi ndo. Ko nichjeꞌe ndo sen ko jian banchekuenꞌen ndo na̱ xranchi jii juachaxin tetuanꞌan ndo Dio. ");
INSERT INTO pps_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Ko kaxin na̱ tsango icha aséen na̱ ko tjaunꞌa na̱ tsitikaon na̱ Ncháina Jesús ko chaxroꞌa kuanichja na̱ ixi chijnie Ncháina ngajin kain chujni. Tjumeꞌe ndo Pablo kuachrjendáa ndo ko sabikao ndo sen titikaon chijnie Ncháina ko kain nchakon bajako ndo ti jii naa escuela ndatinꞌin Tiranno. ");
INSERT INTO pps_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Jaña bajako ndo yuu nano, ko kain ni bakeꞌe ntiꞌa nunte Asia kuinꞌen na̱ chijnie Ncháina Jesús, ni judío ko kaxon ni jeꞌa judío. ");
INSERT INTO pps_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Ko ndo Dio ícha juincheꞌe ndo ijié ixra̱ ixi ti kuanichja ndo Pablo. ");
INSERT INTO pps_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Ko itsjé na̱ bakikao na̱ pañuelo ko manta ngajin ndo Pablo ixi tsa̱ke̱ꞌe̱ itja ndo ko jaña bakikao na̱ ngajin ni niꞌe ko kain ichin chónda na̱ kuachrje ichin ko espíritue Xixronꞌanxrée kuachrje kaxon. ");
INSERT INTO pps_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Ko kaxin ni judío bakaji na̱ ko tjaun na̱ tsantsje na̱ espíritue Xixronꞌanxrée ko jeꞌe na̱ jeꞌo ncheyeꞌe na̱ chujni ixi tjaun na̱ xronichja na̱ ixi juachaxien ndo Jesús. Ko bandache na̱ espíritue Xixronꞌanxrée: ―Juachaxien ndo Jesús, ndo tjako ndo Pablo, tetuanꞌanna jaꞌa espíritue Xixronꞌanxrée tachrjexian ntiꞌi. ");
INSERT INTO pps_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Jaña bancheꞌe ya̱a̱to̱ chjenꞌen naa xi judío ndatinꞌin Esceba, xitaana tetuanꞌan. ");
INSERT INTO pps_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Tjumeꞌe naa nchakon nichjeꞌe na̱ espíritue Xixronꞌanxrée. Ko espíritu meꞌe ndachro: ―Chuxinna ndo Jesús ko nónana ngisen ndo Pablo. Ko jaꞌa, ¿ngisen jaꞌa? ");
INSERT INTO pps_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Ko jaña xi chónda espíritue Xixronꞌanxrée chringanito xa na̱ ko tsango soji xa juacha xa juincheniꞌe xa kain na̱. Ko turuchu na̱ kuachrjexin na̱ nchia ko tsikoniꞌe na̱. ");
INSERT INTO pps_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Ko kain ni judío ko ni jeꞌa judío ste na̱ tjajna Éfeso kuinꞌen na̱ ngeꞌe tsikonꞌen ko tsango xronka na̱ ko ndachro na̱ ixi tsango ijié juachaxien Ncháina Jesús. ");
INSERT INTO pps_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Kaxon itsjé ni kuitikaon Ncháina bakiji na̱ ko kuachronga na̱ kain ti ixra̱ ndakoꞌa bancheꞌe na̱. ");
INSERT INTO pps_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Ixi itsjé na̱ bancheꞌe xra̱ tuso, ni meꞌe bakikaꞌo na̱ xroon banchekuanxixin na̱ xra̱ tuso ko juaaka na̱ xroon stetsjeꞌe kain chujni ste ntiꞌa. Ko ti tjintee kain xroon meꞌe xranchi yuu ikánte mil tomi chika plata. ");
INSERT INTO pps_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Ko chijnie Ncháina Jesús ícha jitingangi ko tjakoxin ixi nduaxin chónda chijni ijié juachaxin. ");
INSERT INTO pps_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Ko ndo Pablo xraxaon ndo tsitsjeꞌe ndo sen tjajna Jerusalén ko tsatsinga ndo nunte Macedonia ko Acaya. Ko tsjexinja tsakeꞌe ndo tjajna Jerusalén, satsji ndo tjajna Roma. ");
INSERT INTO pps_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Ko xruanꞌan ndo yuu sen tingijna ndo satsji sen nunte Macedonia, sen meꞌe ndo Timoteo ko ndo Erasto, ko jeꞌe ndo Pablo xrakuituꞌe ndo nunte Asia kaxin nchakon. ");
INSERT INTO pps_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Ko nchakon meꞌe itsjé ni tjajna Éfeso koñao na̱ ixi juaxruxinꞌa ste na̱ ixi chijnie Ncháina Jesús. ");
INSERT INTO pps_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Ixi ntiꞌa jii naa xi ndatinꞌin Demetrio ko jeꞌe xa banchekonchjian xa ixi chika plata kaxin niꞌngo nchínchín kondee naa nchri diosa ndatinꞌin Diana, ko kueya tomi bajacha xa ko kaxon ni chéꞌe xrée xa. ");
INSERT INTO pps_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Tjumeꞌe juaꞌo xa ikaxin ni kuancheꞌe xra̱ meꞌe ko ndache xa na̱: ―Jaꞌanta noꞌanta ixi ti ixra̱ ncheꞌena tjachana jian ko jaña juaxruxin stena. ");
INSERT INTO pps_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Ko xranchi tikonnta ko tinꞌennta ixi xi Pablo tjako xa ixi ídolo nchéñana jeꞌa dio. Ko jaña ndache xa itsjé chujni ko jeꞌa jeꞌo ntiꞌi tjajna Éfeso, kaxon nguixin nunte Asia. ");
INSERT INTO pps_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Tsango chaxroꞌa jiꞌi ixi xrai̱na tsitjáña xra̱ ko kaxon ningue nchri diosa Diana ba̱ tsitjáña, ko ítsitikaonꞌa na̱ nchra ko tsitjáña juachaxien nchra nguixin nunte Asia ko nchijíi xasintajni. ");
INSERT INTO pps_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Ko hora kuinꞌen na̱ jiꞌin, tsango koñao na̱ ko séen kuyako na̱: ―Tsechón nchri Diana, santoe ni tjajna Éfeso. ");
INSERT INTO pps_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Tjumeꞌe tsango koñao kain ni tjajna Éfeso ko ningakonꞌen na̱ ndo Gayo ko ndo Aristarco, sen meꞌe yuu sen tsiki̱ꞌxi̱n nunte Macedonia. Ko itsé na̱ sen ko bingakjin na̱ sen bikao na̱ sen ngaxinꞌin ti tóñaxin junta. ");
INSERT INTO pps_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Tjumeꞌe ndo Pablo tjaun ndo tixinꞌin ndo ntiꞌa ixi xronichjeꞌe ndo na̱, ko sen titikaon Ncháina kuintueꞌa sen ndo itsji ndo. ");
INSERT INTO pps_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Kaxon ikaxin ni tetuanꞌan nunte Asia, ni chúxin ndo Pablo, xruenꞌen na̱ chujni ixi xrondache sen ndo Pablo ixi tsi̱xi̱nꞌa ndo ntiꞌa. ");
INSERT INTO pps_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Ko tjumeꞌe ni tsixraꞌo ntiꞌa ndachro na̱ naa ngeꞌe, ko ikaxin na̱ jée chro na̱ ko koñao na̱ ko itsjé na̱ noeꞌa na̱ sonda xraꞌo na̱ ntiꞌa. ");
INSERT INTO pps_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Ko ikaxin ni judío ndache na̱ naa xi ndatinꞌin Alejandro ngeꞌe jitonꞌen ko ba̱ke̱ꞌe̱ na̱ xa ngusine ko jeꞌe xa juakoxin itja xa ixi xrotenko na̱ ixi xronichjaxin xa ni judío ngajin ni ste ntiꞌa. ");
INSERT INTO pps_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Ko hora juatsuan na̱ xi Alejandro ixi kaxon xa ni judío xa, kain na̱ kuyako na̱ xranchi yuu hora ko jaꞌin ndachro na̱: ―Tsechón nchri Diana, santoe ni tjajna Éfeso. ");
INSERT INTO pps_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Tjumeꞌe xi secretarioe ni tjajna ntiꞌa kuetuanꞌan xa xrotenko na̱ ko ndachro xa: ―Chujni tjajna Éfeso tinꞌennta. Nchijíi nunte xasintajni noꞌe na̱ ixi ni tjajna Éfeso tayakonꞌen na̱ ningue nchri diosa Diana, tsikoña ixro kui̱xi̱n ngajní. ");
INSERT INTO pps_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Xroꞌan ngisen ndachro ixi nduaxinꞌa jiꞌin. Méxin, tenkonta, ko xraxaonnta ngeꞌe ncheꞌenta ");
INSERT INTO pps_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","ixi ni bikuunta ntiꞌi nichjangíeꞌa na̱ ningoina ko nichjangíeꞌa na̱ santoina Diana. ");
INSERT INTO pps_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Ko siá xi Demetrio ko ni nchexrée xa tjankataꞌa na̱ ijie̱ xrojan ngisen jii ntiꞌi, méxin jii ni nchéña ijie̱, jeꞌe na̱ xrokuinꞌen na̱ ngeꞌe xrondachro xi Demetrio ko jaña sinchéña na̱ ijie̱. ");
INSERT INTO pps_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Ko siá jii inaa ngeꞌe ntaꞌinta juaxruxin, xrokonda xronichjanta nchakon xroxraꞌo kain na̱ ko nchakon meꞌe tsoña̱ ijie̱. ");
INSERT INTO pps_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Xrokondaꞌi tsjakaxin kichuuna ko sincheketona chujni ixi ba̱ tsjangiina xi tetuanꞌan ixi ndakoꞌa stentuꞌuna. ");
INSERT INTO pps_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Ko tjumeꞌe kuetuanꞌan xi secretario ixi satsji na̱ ko jaña juexin sakjui ni tsixraꞌo ntiꞌa. ");
INSERT INTO pps_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Nchakon juexin kain jiꞌin, tjumeꞌe ndo Pablo kuiyeꞌe ndo kain sen titikaon Ncháina Jesús ntiꞌa ko ndachro ndo kaxin chijni ixi ícha xrochuntia sen Ncháina ko tjumeꞌe sakjui ndo no nunte Macedonia. ");
INSERT INTO pps_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Ko nchijíi ti no kuatsinga ndo, chaxro nichjeꞌe ndo sen titikaon Ncháina ixi juaxruxin tsintee sen. Ko tjumeꞌe kuiji ndo nunte Grecia. ");
INSERT INTO pps_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Ntiꞌa kuituꞌe ndo níi nchanitjao ko tjumeꞌe xrokua ndo naa nta̱barco saxrokjui ndo nunte Siria. Ko konoꞌe ndo ixi kaxin ni judío ningakonꞌen na̱ ndo ko xraxaon ndo cháña xrokjanxin ndo tutée ndo ko tsatsinga ndo nunte Macedonia. ");
INSERT INTO pps_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Ko sen bikao ndo Pablo, meꞌe ndo Sópater, ndo tjajna Berea, ndo Aristarco, ndo Segundo, ndo tjajna Tesalónica, ndo Gayo, ndo tjajna Derbe, ndo Timoteo, ko kaxon ndo Tíquico, ko ndo Trófimo, sen nunte Asia. ");
INSERT INTO pps_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Sen kichuuna kuitaon sen ntiꞌa ko chonna̱na sen tjajna Troas. ");
INSERT INTO pps_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Ko juexinja kuatsinga kia ine sen nutja chóndaꞌi ti tjaꞌin nio, tjumeꞌe kuixiꞌinna naa nta̱barco ko kuachrjexinna tjajna Filipos ko kuatsinga naꞌó nchakon, tjumeꞌe juasona tjajna Troas ko ntiꞌa kuetanna sen kuitaonxin ko ntiꞌa kuituna̱na ya̱a̱to̱ nchakon. ");
INSERT INTO pps_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Ko nchakon xrangíxixín semana xraꞌona ixi xrochrijin nutja xraxaonxinna Ncháina Jesucristo. Ko ndo Pablo nichjeꞌe ndo kain sen titikaon Ncháina Jesús ixi tjaun ndo saxrokjui ndo ndúyaxin, méxin xrajitjako ndo chjéja ngusine tiie. ");
INSERT INTO pps_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Ko piso noi nchia ntiꞌa xrauxinna ko ntiꞌa steche kueya xroꞌi. ");
INSERT INTO pps_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Ko ntiꞌa jii naa chajan ndatinꞌin chán Eutico, chán meꞌe bakeꞌe chán nunte ngataꞌa ventana. Ko ndo Pablo tsango sée nichja ndo, méxin, tsango chjée chán kotachrin. Ko ndatsikejua chán ko kueꞌe chán nunte ti nínxin piso ko hora kuatsiꞌin sen chán, ndatsikenꞌen chán. ");
INSERT INTO pps_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Méxin, ndo Pablo xingajin ndo ko kuitsingataꞌa ndo chán ko joa ndo chán. Ko ndache ndo sen kichuuna: ―Xronkaꞌinta, jichón chán. ");
INSERT INTO pps_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Tjumeꞌe ndo Pablo ikjan ndo bajinꞌin ndo ixi tsonchrijin ndo nutja sine sen, xroxraxaonxin sen Ncháina Jesucristo. Ko nichja ndo bingasáñajan ko tjumeꞌe sakjui ndo. ");
INSERT INTO pps_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Ko chán tsikeꞌe nunte sabikao sen chán jichón chán, ko kain sen juaxruxin kuituꞌe sen. ");
INSERT INTO pps_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Janꞌanna kuitaonxinna ntiꞌa ko kuaana naa nta̱barco ko juasona tjajna Asón ixi ntiꞌa tsetanna ndo Pablo ixi ndachro ndo tsjixin ndo tutée ndo. ");
INSERT INTO pps_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Nchakon kuetanna ndo tjajna Asón, kuixinꞌin ndo nta̱barco stetji janꞌanna ko sakjuina tjajna Mitilene. ");
INSERT INTO pps_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Ko kuachrjexin na̱ ntiꞌa, ndúyaxin kuatsingana nunte Quío ko nchakon yuxin juasona tjajna Samos ti no tachrje ikaxin nta̱barco ko tjumeꞌe sakjuina tjajna Trogilio ko ntiꞌa jokéna̱na. Ko kuatsinga naa nchakon juasona tjajna Mileto. ");
INSERT INTO pps_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Jaña juintaꞌana ixi ndo Pablo tjaunꞌa ndo sée xrobakeꞌe ndo nunte Asia ko tjaunꞌa ndo xrokjui ndo tjajna Éfeso ixi tjaun ndo taka tsiji ndo tjajna Jerusalén ixi ntiꞌa tsakeꞌe ndo nchakon kia Pentecostés. ");
INSERT INTO pps_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Hora bakeꞌe ndo Pablo tjajna Mileto kuituanꞌan ndo ixi tsi̱i̱ sen tetuenꞌen niꞌngo tjajna Éfeso. ");
INSERT INTO pps_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Ko nchakon kuiji sen ndachro ndo: ―Jaꞌanta ó noꞌanta xranchi kuantaꞌa nchakon xrangíxixín juaso nunte Asia. ");
INSERT INTO pps_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Ó noꞌanta ixi kain nchakon bakeꞌé ngajinnta ko juintaꞌa ixra̱ ngajin Ncháina Jesucristo ko juintajiéꞌa aséenna ko tsjanga ixi kueya juachjaon kua ixi ni judío tjaun na̱ xrojuinchenina na̱. ");
INSERT INTO pps_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Ko janꞌan kuíntuaꞌi juáko kain ngeꞌe jian xrokonda xrokonoꞌanta. Ko juakoꞌanta ti xraꞌo kain itsjé chujni ko kaxon ndointa. ");
INSERT INTO pps_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Juintakuanꞌan kain ni judío ko kain ni jeꞌa judío ixi xrokonda tsintuꞌe na̱ ti ndakoꞌa ncheꞌe na̱ ko xrochuntia na̱ ndo Dio ko Ncháina Jesucristo. ");
INSERT INTO pps_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Ko jai satsji tjajna Jerusalén ixi Espíritue ndo Dio kotuanna ko nónaꞌi ngeꞌe tsónna ntiꞌa. ");
INSERT INTO pps_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Jeꞌo nóna ixi kain tjajna tsatsinga, Espíritue ndo Dio ndachijina ixi ni tjajna Jerusalén xroxraxinꞌinna na̱ ndoꞌachjiso ko tangi sinchena̱na. ");
INSERT INTO pps_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","*Ko taꞌi juachjaon ixi maski tangi tsónna. Jeꞌo juaxruxin tsakeꞌé ixi sintajexin ti kotuanna Ncháina Jesús ixi tsjáko chijnie ndo, xranchi ndo Dio tjueꞌe ndo chujni. ");
INSERT INTO pps_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","’Ko jai nóna ixi ninaánta, ni juakoꞌanta juachaxien ndo Dio, ítsikonꞌaninta íjngo. ");
INSERT INTO pps_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Méxin, jai ntatjunta ixi xroꞌan ijie̱ chónda siá xrojannta ítsitikaonꞌanta. ");
INSERT INTO pps_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Ixi ó juakoꞌanta kain ngeꞌe tjaun ndo Dio, ko ítitjáñaꞌi tsjáko xrojan ngeꞌe. ");
INSERT INTO pps_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Tsjeꞌenta xranchi jian takeꞌénta ko tsjeꞌenta sen kichuunta, sen niꞌngo, ixi Espíritue Dio tjáanta ndo ixra̱ tayakonꞌennta sen ste ningue Ncháina, sen kuenaxin ndo ixi jnié ndo. ");
INSERT INTO pps_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Ko ó nóna nchakon satsji janꞌan, tsi̱i̱ kaxin ni sinchekeꞌto sen niꞌngo xranchi kundanixra tinchje ba kutuchjon. ");
INSERT INTO pps_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Ko kaxin na̱ ste na̱ ngakjenꞌennta sincheya na̱ ko jaña sen niꞌngo xroruéꞌe sen na̱ ko ítsitikaonꞌa sen Ncháina. ");
INSERT INTO pps_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Méxin, tsjeꞌenta, ko xraxaonnta ixi xranchi níi nano janꞌan juintakuanꞌannta tiie ko nchakon ko tsjanga ko kuíntuaꞌi juintakuanꞌannta ti jian. ");
INSERT INTO pps_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","’Ko jai jaꞌanta kichianna, ngaya itja ndo Dio takéenta ko kaxon tsingijnaxinnta ndo chijnie ndo ixi jeꞌe ndo tjuaꞌanta ndo. Ko jeꞌe ndo tsango chónda ndo juachaxin tsingijnanta ndo ixi tsayeꞌenta kain ngeꞌe ti tjaun ndo ti xrochjée ndo kain sen chujnie ndo ti tjúá aséen sen. ");
INSERT INTO pps_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Janꞌan tjaunꞌa tomie na̱ ni mantée na̱. ");
INSERT INTO pps_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Jaꞌanta noꞌanta jian ixi janꞌan tjáana juintaꞌaxin ixra̱ ko kuenaxin ngeꞌe xrokondana ko kaxon ngeꞌe xrokondeꞌe sen rikiꞌan. ");
INSERT INTO pps_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Jaña juako ngajinnta ixi sincheꞌenta ixra̱ ko tsingijnanta ni xroꞌan ngeꞌe chónda ngeꞌe. Ko xraxaonnta ti tsindachro Ncháina Jesús: “Ícha juaxruxin takeꞌe sen tajon, ixi sen tayéꞌe.” ");
INSERT INTO pps_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Ko juexin ndachro ndo Pablo jiꞌi, bakeꞌexin ntatuchiꞌin ndo ko nichjeꞌe ndo ndo Dio ko kaxon kain sen. ");
INSERT INTO pps_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Tjumeꞌe kain sen tsjanga sen, joa sen ndo ko kuitoxin sen ndo. ");
INSERT INTO pps_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Ko tsango koniꞌe aséen sen ixi chronga ndo ítsikonꞌa sen ndo íjngo. Tjumeꞌe bikao sen ndo ti no jii nta̱barco ko sakjui ndo. ");
INSERT INTO pps_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Nchakon kuintuꞌana sen kichuuna, tjumeꞌe kuixiꞌinna nta̱barco ko sakjuina nunte Cos. Ko ndúyaxin sakjuina tjajna Rodas, ko ntiꞌa sakjuixinna tjajna Pátara. ");
INSERT INTO pps_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Tjajna Pátara kuitjána naa nta̱barco satsjixinna no nunte Fenicia ko kuixiꞌinna nta̱barco meꞌe ko sakjuina. ");
INSERT INTO pps_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Nchakon kuatsingana ntiꞌa bikona nunte Chipre ko kuatsingana ndatsjonxin ikjon ko xrabikonna nunte Siria. Tjumeꞌe nta̱barco sakjui nta̱a̱ tjajna Tiro ixi xrokonda xroxingajin ngeꞌe tjinga nta̱a̱ ti tjajna meꞌe, ko ntiꞌa kuixiꞌinna tjajna. ");
INSERT INTO pps_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Ko kuitjána sen titikaon Ncháina ko ntiꞌa kuituna̱na ngajin sen ya̱a̱to̱ nchakon. Ko Espíritue ndo Dio juinchenoꞌe sen ixi xrondache sen ndo Pablo satsjiꞌa ndo tjajna Jerusalén. ");
INSERT INTO pps_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Ko juexin kuatsinga ti ya̱a̱to̱ nchakon meꞌe, kuachrjexinna ntiꞌa kainna ko kain sen titikaon Ncháina Jesús ko janchriꞌe sen ko chjenꞌen sen bikaanxina sen ngandeꞌe tjajna ko ngandeꞌe ndachaon bakeꞌexinna ntatuchiꞌinna nichjaꞌana ndo Dio. ");
INSERT INTO pps_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Ko tjáꞌana sen juajna ko bajíina nta̱barco ko jeꞌe sen ikjan sen ndoꞌa sen. ");
INSERT INTO pps_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Ko juasona tjajna Tiro ko tjajna Tolemaida. Ntiꞌa tjáꞌana juajna sen titikaon Ncháina ko ntiꞌa kuituna̱na ngajin sen naa nchakon. ");
INSERT INTO pps_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","*Ko ndúyaxin ndo Pablo ko janꞌanna sajuixinna ntiꞌa, sakjuina tjajna Cesarea. Ntiꞌa ikjuina ndoꞌa ndo Felipe, naa ndo tjako chijnie Ncháina Jesús. Jeꞌe ndo naa sen ya̱to̱ sen tingijna kuincheꞌe Ncháina Jesús ko kuituna̱na ndoꞌa ndo. ");
INSERT INTO pps_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Ndo Felipe kuachónda ndo noó nchrichajenꞌen ndo, nchri xratuteeꞌa, nchri meꞌe tayéꞌe nchrichan chijnie ndo Dio ti tjaun ndo tsonoꞌe chujnie ndo. ");
INSERT INTO pps_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","*Ntiꞌa kuinteena itsjé nchakon ko tjumeꞌe kuiji naa ndo tayéꞌe chijnie ndo Dio ko ndo meꞌe ndatinꞌin ndo Agabo, ndo nunte Judea. ");
INSERT INTO pps_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Kuiji ndo kuitsjena̱na ndo ko itsé ndo tju̱a̱ tingatóxin ndo Pablo ko tju̱a̱ meꞌe kuintexin ndo tutée ndo ko itja ndo ko ndachro ndo: ―Espíritue ndo Dio ndachro ixi ni judío jaꞌin sinchekao na̱ nchée tju̱a̱ jiꞌi ko tsikao na̱ ndo ngajin ni jeꞌa tjajna judío. ");
INSERT INTO pps_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Juexin kuinꞌanna ti ndachro ndo Agabo, tjumeꞌe janꞌanna ko ni tjajna Cesarea kuinóatána̱na ngajin ndo Pablo ixi tsjiꞌa ndo tjajna Jerusalén. ");
INSERT INTO pps_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Ko juatingíexin ndo Pablo: ―¿Sonda ncheniꞌenta aséenna ixi ritsja̱nganta? Janꞌan jeꞌa jeꞌo xrocho̱nꞌa̱n tsinteenana̱, kaxon janꞌan tsenxinna kondeexin Ncháina Jesús ntiꞌa tjajna Jerusalén. ");
INSERT INTO pps_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Ko janꞌanna juachaꞌina xrokuitikaonna ndo, méxin kuintuꞌana ndo satsji ndo ko ntatjanna ndo: ―Tsonꞌen ti tjaun Ncháina Jesús. ");
INSERT INTO pps_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Ko kuatsinga kaxin nchakon xakonnana ko sakjuina tjajna Jerusalén. ");
INSERT INTO pps_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Ko bikiꞌana kaxin sen titikaon Ncháina, sen tjajna Cesarea. Sabikiꞌanna sen ndoꞌa naa ndo tjajna Chipre ndatinꞌin ndo Mnasón. Jeꞌe ndo ó saꞌó titikaon ndo Ncháina Jesús ko kuajon ndo ndoꞌa ndo kuituna̱na. ");
INSERT INTO pps_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Nchakon juasona tjajna Jerusalén sen kichuuna jian nichjaꞌnana sen. ");
INSERT INTO pps_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Ko ndúyaxin bikiꞌana ndo Pablo bikitsjaꞌana ndo Jacobo, ndo kichuu Ncháina Jesús, ko kaxon ntiꞌa ste kain sen kichuuna tetuanꞌan niꞌngo. ");
INSERT INTO pps_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Ndo Pablo chjée ndo sen juajna ko bekiꞌe ndo sen kain ngeꞌe juincheꞌe ndo Dio nchakon juakoꞌe ndo ni jeꞌa judío. ");
INSERT INTO pps_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Juexin kuinꞌen sen jiꞌin, kuajon sen juasaya ngajin ndo Dio, ko ndache sen ndo Pablo: ―Kichianna, jaꞌanta ó bikonta ixi jii itsjé mil ni judío ó titikaon na̱ ndo Jesús ko kain na̱ ndachro na̱ ixi xrokonda kaxon tsitikaonna ley kuajon ndo Moisés. ");
INSERT INTO pps_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Ko jai tsikinꞌen na̱ ixi jaꞌanta juinchekueꞌennta ni judío ste tjajna ícha ikjín ixi tsitikaonꞌa na̱ ti ley juako ndo Moisés ko kaxon ndachenta na̱ ixi xrochjéꞌa na̱ chjiꞌe ni judío chjenꞌen na̱ ko xrokondaꞌi tsitikaon na̱ ti titikaon ni judío. ");
INSERT INTO pps_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","¿Ngeꞌe sintaꞌana ixi tsinꞌen na̱ ixi ó juiꞌinta? ");
INSERT INTO pps_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Méxin, cháña jaꞌin ncheꞌenta. Ntiꞌi jii noó sen tjaun sincheꞌe sen ti ó ndache sen ndo Dio. ");
INSERT INTO pps_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Tikuꞌunta sen ko tjenganta ꞌna̱ kain ngeꞌe xrokonda sincheꞌe sen ti tontjúá aséen sen ko ti ikjín jaa sen, tjenganta ꞌna̱ ti tsoxienxin ko jaña tsonoꞌe kain sen kichuuna ixi nduaxinꞌa kain ti nichja na̱ ti jaꞌanta ncheꞌenta ko jai tsikon sen ixi jaꞌanta titikaonnta ley. ");
INSERT INTO pps_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","*Ko ni jeꞌa judío, ni ó tsikitikaon Ncháina Jesús ó kjinꞌanna na̱ naa xroon ixi tsaꞌi na̱ juachjaon ixi kain jiꞌin. Jeꞌo sineꞌa na̱ ntao tsikinixinꞌen ídolo ko sineꞌa na̱ ijni̱ ko ntauꞌe iko tsikintjiꞌa jnié ba, ko xrochóndaꞌi na̱ inaa nchri o̱ xi jeꞌa ndoxiꞌe o̱ janchriꞌe na̱. ");
INSERT INTO pps_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Tjumeꞌe ndo Pablo sabikao ndo sen noó ko ndúyaxin juexin kontjúá sen kao jeꞌe ndo. Ko tjumeꞌe kuixinꞌin ndo niꞌngo ixi xrochronga ndo ixi juexin kontjúá sen ko xrobikao ngujngu sen ngeꞌe tikinixinꞌen ndo Dio tsayéꞌe xitaana. ");
INSERT INTO pps_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Ó xroxetja ya̱a̱to̱ nchakon, tjumeꞌe kaxin ni judío tsiki̱ꞌxi̱n nunte Asia bikon na̱ ndo Pablo ngaxinꞌin niꞌngo. Ko tjumeꞌe juinchekateya na̱ kain chujni tjajna ko itsé na̱ ndo Pablo. ");
INSERT INTO pps_vpl VA